
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  137 ( 1079),  selected  137 , name 1ozb_B
# Molecule2: number of CA atoms  101 ( 1588),  selected  101 , name T0482_7_107.pdb
# PARAMETERS: 1ozb_B.T0482_7_107.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q    15_B      P     7_A           -
LGA    P    16_B      G     8_A           -
LGA    V    17_B      H     9_A           -
LGA    L    18_B      L    10_A           -
LGA    Q    19_B      H    11_A           -
LGA    I    20_B      L    12_A           -
LGA    Q    21_B      V    13_A           -
LGA    R    22_B      S    14_A           -
LGA    I    23_B      L    15_A           -
LGA    Y    24_B      P    16_A           -
LGA    V    25_B      G    17_A           -
LGA    K    26_B      L    18_A           -
LGA    D    27_B      -       -           -
LGA    V    28_B      -       -           -
LGA    S    29_B      -       -           -
LGA    F    30_B      -       -           -
LGA    E    31_B      -       -           -
LGA    A    32_B      -       -           -
LGA    P    33_B      -       -           -
LGA    N    34_B      -       -           -
LGA    L    35_B      -       -           -
LGA    P    36_B      -       -           -
LGA    H    37_B      -       -           -
LGA    I    38_B      -       -           -
LGA    F    39_B      -       -           -
LGA    Q    40_B      -       -           -
LGA    Q    41_B      -       -           -
LGA    E    42_B      -       -           -
LGA    W    43_B      -       -           -
LGA    K    44_B      D    19_A           #
LGA    P    45_B      Q    20_A          4.111
LGA    -       -      Q    21_A           -
LGA    K    46_B      D    22_A          3.015
LGA    L    47_B      I    23_A          2.414
LGA    G    48_B      N    24_A          2.078
LGA    F    49_B      I    25_A          2.821
LGA    D    50_B      H    26_A          1.847
LGA    L    51_B      I    27_A          1.876
LGA    S    52_B      R    28_A          1.921
LGA    T    53_B      Y    29_A          0.646
LGA    E    54_B      E    30_A          0.639
LGA    T    55_B      V    31_A          1.128
LGA    T    56_B      R    32_A          1.159
LGA    Q    57_B      Q    33_A          1.152
LGA    V    58_B      N    34_A          0.854
LGA    G    59_B      A    35_A          2.151
LGA    D    60_B      E    36_A           #
LGA    D    61_B      S    37_A          5.418
LGA    L    62_B      G    38_A          2.180
LGA    Y    63_B      A    39_A          1.946
LGA    E    64_B      Y    40_A          2.170
LGA    V    65_B      V    41_A          1.046
LGA    V    66_B      H    42_A          1.974
LGA    L    67_B      F    43_A          2.455
LGA    N    68_B      D    44_A          2.412
LGA    I    69_B      M    45_A          2.410
LGA    S    70_B      D    46_A          2.641
LGA    V    71_B      G    47_A          3.538
LGA    E    72_B      E    48_A          2.611
LGA    T    73_B      I    49_A          3.257
LGA    T    74_B      -       -           -
LGA    L    75_B      -       -           -
LGA    E    76_B      -       -           -
LGA    D    77_B      -       -           -
LGA    S    78_B      -       -           -
LGA    G    79_B      -       -           -
LGA    D    80_B      -       -           -
LGA    V    81_B      D    50_A           #
LGA    A    82_B      G    51_A          2.192
LGA    F    83_B      K    52_A          1.673
LGA    I    84_B      P    53_A          2.335
LGA    C    85_B      F    54_A          2.779
LGA    E    86_B      S    55_A          3.064
LGA    V    87_B      D    56_A          2.444
LGA    K    88_B      S    57_A          1.686
LGA    Q    89_B      F    58_A          2.084
LGA    A    90_B      E    59_A          1.358
LGA    G    91_B      L    60_A          0.999
LGA    V    92_B      P    61_A          1.759
LGA    F    93_B      R    62_A          2.656
LGA    T    94_B      D    63_A          4.699
LGA    I    95_B      T    64_A           -
LGA    S    96_B      -       -           -
LGA    G    97_B      -       -           -
LGA    L    98_B      -       -           -
LGA    E    99_B      -       -           -
LGA    D   100_B      -       -           -
LGA    V   101_B      -       -           -
LGA    Q   102_B      -       -           -
LGA    M   103_B      -       -           -
LGA    A   104_B      -       -           -
LGA    H   105_B      -       -           -
LGA    C   106_B      -       -           -
LGA    L   107_B      -       -           -
LGA    T   108_B      -       -           -
LGA    S   109_B      -       -           -
LGA    Q   110_B      A    65_A           #
LGA    C   111_B      F    66_A          2.443
LGA    P   112_B      -       -           -
LGA    N   113_B      -       -           -
LGA    M   114_B      N    67_A          1.055
LGA    L   115_B      F    68_A          1.527
LGA    F   116_B      A    69_A          2.484
LGA    P   117_B      S    70_A          1.510
LGA    Y   118_B      D    71_A          1.481
LGA    A   119_B      A    72_A          2.686
LGA    R   120_B      T    73_A          2.136
LGA    E   121_B      R    74_A          1.871
LGA    L   122_B      V    75_A          2.342
LGA    V   123_B      A    76_A          3.066
LGA    S   124_B      Q    77_A          2.644
LGA    N   125_B      K    78_A          2.779
LGA    L   126_B      H    79_A          4.214
LGA    V   127_B      G    80_A          3.583
LGA    N   128_B      -       -           -
LGA    R   129_B      -       -           -
LGA    G   130_B      -       -           -
LGA    T   131_B      -       -           -
LGA    F   132_B      -       -           -
LGA    P   133_B      -       -           -
LGA    A   134_B      L    81_A          4.368
LGA    L   135_B      H    82_A          3.507
LGA    N   136_B      P    83_A          4.771
LGA    -       -      K    84_A           -
LGA    -       -      F    85_A           -
LGA    L   137_B      G    86_A           #
LGA    S   138_B      A    87_A          2.509
LGA    P   139_B      I    88_A          5.248
LGA    -       -      T    89_A           -
LGA    -       -      R    90_A           -
LGA    -       -      V    91_A           -
LGA    V   140_B      H    92_A          5.485
LGA    -       -      K    93_A           -
LGA    N   141_B      E    94_A          3.431
LGA    F   142_B      Y    95_A          4.341
LGA    -       -      D    96_A           -
LGA    D   143_B      A    97_A          1.599
LGA    A   144_B      M    98_A          4.947
LGA    L   145_B      F    99_A           #
LGA    -       -      E   100_A           -
LGA    F   146_B      D   101_A          2.858
LGA    V   147_B      I   102_A           -
LGA    E   148_B      R   103_A           -
LGA    -       -      A   104_A           -
LGA    Y   149_B      K   105_A           #
LGA    M   150_B      L   106_A           -
LGA    N   151_B      H   107_A           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  137  101    5.0     67    2.80     7.46     42.967     2.311

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.144436 * X  +  -0.842412 * Y  +  -0.519114 * Z  + -111.291840
  Y_new =   0.043257 * X  +   0.518738 * Y  +  -0.853838 * Z  + -315.557251
  Z_new =   0.988568 * X  +  -0.145780 * Y  +  -0.038484 * Z  + -129.989838 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.828894    1.312699  [ DEG:  -104.7879     75.2121 ]
  Theta =  -1.419445   -1.722148  [ DEG:   -81.3282    -98.6718 ]
  Phi   =   2.850602   -0.290991  [ DEG:   163.3275    -16.6725 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ozb_B                                        
REMARK     2: T0482_7_107.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ozb_B.T0482_7_107.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  137  101   5.0   67   2.80    7.46  42.967
REMARK  ---------------------------------------------------------- 
MOLECULE 1ozb_B
HEADER    PROTEIN TRANSPORT                       08-APR-03   1OZB              
TITLE     CRYSTAL STRUCTURE OF SECB COMPLEXED WITH SECA C-TERMINUS              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN-EXPORT PROTEIN SECB;                               
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: PREPROTEIN TRANSLOCASE SECA SUBUNIT;                       
COMPND   7 CHAIN: I, J;                                                         
COMPND   8 FRAGMENT: C-TERMINAL DOMAIN;                                         
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: SECB OR HI0743;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PSJ4-SECBHI;                              
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 GENE: SECA OR HI0909;                                                
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: DH5ALPHA;                                  
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PGEX-2T-SECACHI                           
KEYWDS    ZINC BINDING MOTIF, PROTEIN-PROTEIN COMPLEX                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.ZHOU,Z.XU                                                           
REVDAT   2   04-NOV-03 1OZB    1       JRNL                                     
REVDAT   1   14-OCT-03 1OZB    0                                                
JRNL        AUTH   J.ZHOU,Z.XU                                                  
JRNL        TITL   STRUCTURAL DETERMINANTS OF SECB RECOGNITION BY               
JRNL        TITL 2 SECA IN BACTERIAL PROTEIN TRANSLOCATION                      
JRNL        REF    NAT.STRUCT.BIOL.              V.  10   942 2003              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  1OZB A    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB B    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB C    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB D    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB E    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB F    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB G    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB H    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB I    1    27  UNP    P43803   SECA_HAEIN     875    901             
DBREF  1OZB J    1    27  UNP    P43803   SECA_HAEIN     875    901             
SEQRES   1 A  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 A  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 A  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 A  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 A  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 A  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 A  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 A  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 A  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 A  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 A  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 A  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 A  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 B  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 B  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 B  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 B  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 B  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 B  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 B  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 B  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 B  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 B  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 B  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 B  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 B  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 C  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 C  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 C  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 C  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 C  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 C  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 C  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 C  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 C  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 C  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 C  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 C  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 C  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 D  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 D  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 D  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 D  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 D  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 D  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 D  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 D  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 D  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 D  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 D  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 D  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 D  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 E  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 E  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 E  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 E  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 E  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 E  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 E  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 E  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 E  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 E  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 E  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 E  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 E  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 F  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 F  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 F  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 F  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 F  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 F  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 F  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 F  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 F  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 F  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 F  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 F  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 F  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 G  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 G  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 G  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 G  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 G  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 G  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 G  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 G  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 G  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 G  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 G  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 G  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 G  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 H  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 H  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 H  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 H  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 H  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 H  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 H  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 H  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 H  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 H  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 H  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 H  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 H  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 I   27  ARG ILE GLY ARG ASN GLU PRO CYS PRO CYS GLY SER GLY          
SEQRES   2 I   27  LYS LYS TYR LYS HIS CYS HIS GLY SER ARG VAL ALA ARG          
SEQRES   3 I   27  GLN                                                          
SEQRES   1 J   27  ARG ILE GLY ARG ASN GLU PRO CYS PRO CYS GLY SER GLY          
SEQRES   2 J   27  LYS LYS TYR LYS HIS CYS HIS GLY SER ARG VAL ALA ARG          
SEQRES   3 J   27  GLN                                                          
HET     ZN     50       1                                                       
HET     ZN     51       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL  11   ZN    2(ZN 2+)                                                     
CRYST1  114.500  114.500  286.100  90.00  90.00  90.00 P 41 21 2    64          
ATOM   1122  N   GLN B  15      27.277   4.895   3.339  1.00 72.26           N  
ATOM   1123  CA  GLN B  15      26.525   4.772   2.054  1.00 72.26           C  
ATOM   1124  C   GLN B  15      25.161   4.139   2.310  1.00 72.26           C  
ATOM   1125  O   GLN B  15      25.074   2.996   2.767  1.00 72.26           O  
ATOM   1126  CB  GLN B  15      27.315   3.927   1.052  1.00 50.10           C  
ATOM   1127  N   PRO B  16      24.076   4.874   1.997  1.00 75.31           N  
ATOM   1128  CA  PRO B  16      22.689   4.427   2.182  1.00 75.31           C  
ATOM   1129  C   PRO B  16      22.369   3.036   1.662  1.00 75.31           C  
ATOM   1130  O   PRO B  16      22.917   2.589   0.656  1.00 75.31           O  
ATOM   1131  CB  PRO B  16      21.872   5.514   1.474  1.00 73.50           C  
ATOM   1132  CG  PRO B  16      22.813   6.041   0.441  1.00 62.33           C  
ATOM   1133  CD  PRO B  16      24.109   6.125   1.217  1.00 62.33           C  
ATOM   1134  N   VAL B  17      21.471   2.356   2.362  1.00 59.87           N  
ATOM   1135  CA  VAL B  17      21.071   1.017   1.962  1.00 59.87           C  
ATOM   1136  C   VAL B  17      19.572   0.763   2.132  1.00 59.87           C  
ATOM   1137  O   VAL B  17      18.951   1.177   3.111  1.00 59.87           O  
ATOM   1138  CB  VAL B  17      21.869  -0.062   2.736  1.00 71.98           C  
ATOM   1139  CG1 VAL B  17      21.776   0.182   4.225  1.00 71.98           C  
ATOM   1140  CG2 VAL B  17      21.339  -1.441   2.386  1.00 71.98           C  
ATOM   1141  N   LEU B  18      19.005   0.090   1.140  1.00 49.39           N  
ATOM   1142  CA  LEU B  18      17.590  -0.263   1.113  1.00 49.39           C  
ATOM   1143  C   LEU B  18      17.517  -1.691   0.608  1.00 49.39           C  
ATOM   1144  O   LEU B  18      17.687  -1.944  -0.585  1.00 49.39           O  
ATOM   1145  CB  LEU B  18      16.803   0.649   0.163  1.00 48.93           C  
ATOM   1146  CG  LEU B  18      15.334   0.265  -0.093  1.00 48.93           C  
ATOM   1147  CD1 LEU B  18      14.610   0.055   1.234  1.00 48.93           C  
ATOM   1148  CD2 LEU B  18      14.649   1.349  -0.915  1.00 48.93           C  
ATOM   1149  N   GLN B  19      17.259  -2.616   1.525  1.00 48.71           N  
ATOM   1150  CA  GLN B  19      17.189  -4.034   1.202  1.00 48.71           C  
ATOM   1151  C   GLN B  19      15.859  -4.661   1.616  1.00 48.71           C  
ATOM   1152  O   GLN B  19      15.286  -4.312   2.646  1.00 48.71           O  
ATOM   1153  CB  GLN B  19      18.334  -4.770   1.906  1.00 91.88           C  
ATOM   1154  CG  GLN B  19      19.174  -5.629   0.990  1.00 91.88           C  
ATOM   1155  CD  GLN B  19      19.514  -4.920  -0.307  1.00 91.88           C  
ATOM   1156  OE1 GLN B  19      19.983  -3.782  -0.303  1.00 91.88           O  
ATOM   1157  NE2 GLN B  19      19.278  -5.591  -1.427  1.00 91.88           N  
ATOM   1158  N   ILE B  20      15.378  -5.593   0.807  1.00 44.95           N  
ATOM   1159  CA  ILE B  20      14.128  -6.285   1.092  1.00 44.95           C  
ATOM   1160  C   ILE B  20      14.464  -7.564   1.853  1.00 44.95           C  
ATOM   1161  O   ILE B  20      15.166  -8.424   1.326  1.00 44.95           O  
ATOM   1162  CB  ILE B  20      13.408  -6.669  -0.204  1.00 28.72           C  
ATOM   1163  CG1 ILE B  20      13.114  -5.401  -1.011  1.00 28.72           C  
ATOM   1164  CG2 ILE B  20      12.147  -7.442   0.116  1.00 28.72           C  
ATOM   1165  CD1 ILE B  20      12.381  -5.641  -2.318  1.00 28.72           C  
ATOM   1166  N   GLN B  21      13.978  -7.683   3.090  1.00 35.14           N  
ATOM   1167  CA  GLN B  21      14.237  -8.871   3.908  1.00 35.14           C  
ATOM   1168  C   GLN B  21      13.169  -9.945   3.735  1.00 35.14           C  
ATOM   1169  O   GLN B  21      13.481 -11.130   3.594  1.00 35.14           O  
ATOM   1170  CB  GLN B  21      14.312  -8.508   5.390  1.00 57.34           C  
ATOM   1171  CG  GLN B  21      15.475  -7.615   5.760  1.00 57.34           C  
ATOM   1172  CD  GLN B  21      16.811  -8.144   5.253  1.00 57.34           C  
ATOM   1173  OE1 GLN B  21      17.130  -9.329   5.406  1.00 57.34           O  
ATOM   1174  NE2 GLN B  21      17.606  -7.255   4.652  1.00 57.34           N  
ATOM   1175  N   ARG B  22      11.905  -9.528   3.760  1.00 48.37           N  
ATOM   1176  CA  ARG B  22      10.804 -10.463   3.614  1.00 48.37           C  
ATOM   1177  C   ARG B  22       9.531  -9.773   3.134  1.00 48.37           C  
ATOM   1178  O   ARG B  22       9.260  -8.629   3.484  1.00 48.37           O  
ATOM   1179  CB  ARG B  22      10.531 -11.149   4.952  1.00 64.51           C  
ATOM   1180  CG  ARG B  22       9.634 -12.381   4.850  1.00 64.51           C  
ATOM   1181  CD  ARG B  22       8.996 -12.705   6.201  1.00 64.51           C  
ATOM   1182  NE  ARG B  22       9.989 -13.007   7.225  1.00 64.51           N  
ATOM   1183  CZ  ARG B  22      10.501 -14.212   7.433  1.00 64.51           C  
ATOM   1184  NH1 ARG B  22      10.111 -15.242   6.692  1.00 64.51           N  
ATOM   1185  NH2 ARG B  22      11.417 -14.382   8.374  1.00 64.51           N  
ATOM   1186  N   ILE B  23       8.756 -10.480   2.320  1.00 22.72           N  
ATOM   1187  CA  ILE B  23       7.496  -9.964   1.819  1.00 22.72           C  
ATOM   1188  C   ILE B  23       6.460 -10.984   2.275  1.00 22.72           C  
ATOM   1189  O   ILE B  23       6.589 -12.166   1.958  1.00 22.72           O  
ATOM   1190  CB  ILE B  23       7.460  -9.938   0.291  1.00 23.18           C  
ATOM   1191  CG1 ILE B  23       8.691  -9.212  -0.279  1.00 23.18           C  
ATOM   1192  CG2 ILE B  23       6.175  -9.284  -0.160  1.00 23.18           C  
ATOM   1193  CD1 ILE B  23       8.694  -7.723  -0.057  1.00 23.18           C  
ATOM   1194  N   TYR B  24       5.437 -10.545   3.007  1.00 33.70           N  
ATOM   1195  CA  TYR B  24       4.416 -11.465   3.493  1.00 33.70           C  
ATOM   1196  C   TYR B  24       3.082 -10.785   3.674  1.00 33.70           C  
ATOM   1197  O   TYR B  24       3.001  -9.561   3.687  1.00 33.70           O  
ATOM   1198  CB  TYR B  24       4.857 -12.072   4.825  1.00 29.32           C  
ATOM   1199  CG  TYR B  24       5.224 -11.036   5.866  1.00 29.32           C  
ATOM   1200  CD1 TYR B  24       4.261 -10.518   6.742  1.00 29.32           C  
ATOM   1201  CD2 TYR B  24       6.526 -10.527   5.938  1.00 29.32           C  
ATOM   1202  CE1 TYR B  24       4.587  -9.518   7.660  1.00 29.32           C  
ATOM   1203  CE2 TYR B  24       6.868  -9.528   6.848  1.00 29.32           C  
ATOM   1204  CZ  TYR B  24       5.895  -9.026   7.704  1.00 29.32           C  
ATOM   1205  OH  TYR B  24       6.228  -8.030   8.598  1.00 29.32           O  
ATOM   1206  N   VAL B  25       2.031 -11.584   3.815  1.00 33.73           N  
ATOM   1207  CA  VAL B  25       0.700 -11.044   4.008  1.00 33.73           C  
ATOM   1208  C   VAL B  25       0.308 -11.209   5.461  1.00 33.73           C  
ATOM   1209  O   VAL B  25       0.387 -12.305   5.995  1.00 33.73           O  
ATOM   1210  CB  VAL B  25      -0.326 -11.772   3.135  1.00 43.70           C  
ATOM   1211  CG1 VAL B  25      -1.711 -11.462   3.626  1.00 43.70           C  
ATOM   1212  CG2 VAL B  25      -0.190 -11.320   1.694  1.00 43.70           C  
ATOM   1213  N   LYS B  26      -0.118 -10.124   6.101  1.00 30.90           N  
ATOM   1214  CA  LYS B  26      -0.512 -10.184   7.505  1.00 30.90           C  
ATOM   1215  C   LYS B  26      -1.988 -10.523   7.651  1.00 30.90           C  
ATOM   1216  O   LYS B  26      -2.381 -11.180   8.618  1.00 30.90           O  
ATOM   1217  CB  LYS B  26      -0.213  -8.856   8.201  1.00 39.82           C  
ATOM   1218  CG  LYS B  26       1.271  -8.494   8.252  1.00 39.82           C  
ATOM   1219  CD  LYS B  26       1.525  -7.094   8.850  1.00 39.82           C  
ATOM   1220  CE  LYS B  26       1.237  -7.011  10.347  1.00 39.82           C  
ATOM   1221  NZ  LYS B  26       2.073  -7.979  11.094  1.00 39.82           N  
ATOM   1222  N   ASP B  27      -2.797 -10.097   6.677  1.00 32.72           N  
ATOM   1223  CA  ASP B  27      -4.236 -10.336   6.715  1.00 32.72           C  
ATOM   1224  C   ASP B  27      -4.902 -10.247   5.329  1.00 32.72           C  
ATOM   1225  O   ASP B  27      -4.562  -9.395   4.505  1.00 32.72           O  
ATOM   1226  CB  ASP B  27      -4.874  -9.327   7.671  1.00 37.53           C  
ATOM   1227  CG  ASP B  27      -6.306  -9.647   7.977  1.00 37.53           C  
ATOM   1228  OD1 ASP B  27      -6.607 -10.795   8.359  1.00 37.53           O  
ATOM   1229  OD2 ASP B  27      -7.144  -8.749   7.839  1.00 37.53           O  
ATOM   1230  N   VAL B  28      -5.851 -11.142   5.074  1.00 26.05           N  
ATOM   1231  CA  VAL B  28      -6.573 -11.159   3.802  1.00 26.05           C  
ATOM   1232  C   VAL B  28      -8.024 -11.473   4.078  1.00 26.05           C  
ATOM   1233  O   VAL B  28      -8.336 -12.294   4.943  1.00 26.05           O  
ATOM   1234  CB  VAL B  28      -6.129 -12.287   2.841  1.00 36.66           C  
ATOM   1235  CG1 VAL B  28      -6.677 -12.029   1.459  1.00 36.66           C  
ATOM   1236  CG2 VAL B  28      -4.658 -12.416   2.816  1.00 36.66           C  
ATOM   1237  N   SER B  29      -8.900 -10.848   3.301  1.00 29.88           N  
ATOM   1238  CA  SER B  29     -10.336 -11.058   3.408  1.00 29.88           C  
ATOM   1239  C   SER B  29     -10.948 -10.894   2.039  1.00 29.88           C  
ATOM   1240  O   SER B  29     -10.623  -9.943   1.322  1.00 29.88           O  
ATOM   1241  CB  SER B  29     -10.991 -10.022   4.320  1.00 39.87           C  
ATOM   1242  OG  SER B  29     -10.787 -10.312   5.680  1.00 39.87           O  
ATOM   1243  N   PHE B  30     -11.826 -11.818   1.672  1.00 27.17           N  
ATOM   1244  CA  PHE B  30     -12.528 -11.718   0.405  1.00 27.17           C  
ATOM   1245  C   PHE B  30     -13.897 -12.294   0.647  1.00 27.17           C  
ATOM   1246  O   PHE B  30     -14.017 -13.436   1.100  1.00 27.17           O  
ATOM   1247  CB  PHE B  30     -11.835 -12.499  -0.717  1.00 14.84           C  
ATOM   1248  CG  PHE B  30     -12.615 -12.504  -2.013  1.00 14.84           C  
ATOM   1249  CD1 PHE B  30     -12.532 -11.440  -2.897  1.00 14.84           C  
ATOM   1250  CD2 PHE B  30     -13.445 -13.568  -2.335  1.00 14.84           C  
ATOM   1251  CE1 PHE B  30     -13.269 -11.444  -4.089  1.00 14.84           C  
ATOM   1252  CE2 PHE B  30     -14.182 -13.569  -3.530  1.00 14.84           C  
ATOM   1253  CZ  PHE B  30     -14.087 -12.509  -4.399  1.00 14.84           C  
ATOM   1254  N   GLU B  31     -14.922 -11.507   0.341  1.00 36.32           N  
ATOM   1255  CA  GLU B  31     -16.292 -11.934   0.556  1.00 36.32           C  
ATOM   1256  C   GLU B  31     -17.169 -11.703  -0.656  1.00 36.32           C  
ATOM   1257  O   GLU B  31     -17.126 -10.638  -1.267  1.00 36.32           O  
ATOM   1258  CB  GLU B  31     -16.876 -11.186   1.745  1.00 62.04           C  
ATOM   1259  CG  GLU B  31     -15.918 -11.063   2.910  1.00 62.04           C  
ATOM   1260  CD  GLU B  31     -16.571 -10.466   4.140  1.00 62.04           C  
ATOM   1261  OE1 GLU B  31     -17.441 -11.143   4.736  1.00 62.04           O  
ATOM   1262  OE2 GLU B  31     -16.218  -9.322   4.505  1.00 62.04           O  
ATOM   1263  N   ALA B  32     -17.964 -12.717  -0.986  1.00 27.27           N  
ATOM   1264  CA  ALA B  32     -18.888 -12.672  -2.105  1.00 27.27           C  
ATOM   1265  C   ALA B  32     -20.233 -13.134  -1.551  1.00 27.27           C  
ATOM   1266  O   ALA B  32     -20.659 -14.273  -1.776  1.00 27.27           O  
ATOM   1267  CB  ALA B  32     -18.416 -13.598  -3.202  1.00 58.85           C  
ATOM   1268  N   PRO B  33     -20.936 -12.236  -0.849  1.00 38.94           N  
ATOM   1269  CA  PRO B  33     -22.241 -12.373  -0.186  1.00 38.94           C  
ATOM   1270  C   PRO B  33     -23.379 -12.961  -1.007  1.00 38.94           C  
ATOM   1271  O   PRO B  33     -24.021 -13.930  -0.602  1.00 38.94           O  
ATOM   1272  CB  PRO B  33     -22.600 -10.940   0.188  1.00 27.74           C  
ATOM   1273  CG  PRO B  33     -21.324 -10.159   0.028  1.00 27.74           C  
ATOM   1274  CD  PRO B  33     -20.620 -10.818  -1.079  1.00 27.74           C  
ATOM   1275  N   ASN B  34     -23.620 -12.343  -2.160  1.00 44.97           N  
ATOM   1276  CA  ASN B  34     -24.732 -12.698  -3.035  1.00 44.97           C  
ATOM   1277  C   ASN B  34     -24.516 -13.735  -4.138  1.00 44.97           C  
ATOM   1278  O   ASN B  34     -25.034 -13.580  -5.243  1.00 44.97           O  
ATOM   1279  CB  ASN B  34     -25.285 -11.405  -3.655  1.00 31.90           C  
ATOM   1280  CG  ASN B  34     -25.400 -10.266  -2.635  1.00 31.90           C  
ATOM   1281  OD1 ASN B  34     -26.041 -10.412  -1.589  1.00 31.90           O  
ATOM   1282  ND2 ASN B  34     -24.773  -9.127  -2.937  1.00 31.90           N  
ATOM   1283  N   LEU B  35     -23.765 -14.793  -3.853  1.00 29.52           N  
ATOM   1284  CA  LEU B  35     -23.531 -15.848  -4.848  1.00 29.52           C  
ATOM   1285  C   LEU B  35     -24.487 -17.013  -4.593  1.00 29.52           C  
ATOM   1286  O   LEU B  35     -24.833 -17.305  -3.449  1.00 29.52           O  
ATOM   1287  CB  LEU B  35     -22.085 -16.352  -4.779  1.00 37.25           C  
ATOM   1288  CG  LEU B  35     -20.983 -15.548  -5.486  1.00 37.25           C  
ATOM   1289  CD1 LEU B  35     -21.097 -14.081  -5.131  1.00 37.25           C  
ATOM   1290  CD2 LEU B  35     -19.613 -16.092  -5.084  1.00 37.25           C  
ATOM   1291  N   PRO B  36     -24.926 -17.703  -5.650  1.00 53.37           N  
ATOM   1292  CA  PRO B  36     -24.584 -17.460  -7.053  1.00 53.37           C  
ATOM   1293  C   PRO B  36     -25.546 -16.568  -7.826  1.00 53.37           C  
ATOM   1294  O   PRO B  36     -25.303 -16.283  -8.997  1.00 53.37           O  
ATOM   1295  CB  PRO B  36     -24.556 -18.857  -7.637  1.00 33.71           C  
ATOM   1296  CG  PRO B  36     -25.721 -19.513  -6.921  1.00 33.71           C  
ATOM   1297  CD  PRO B  36     -25.529 -19.041  -5.482  1.00 33.71           C  
ATOM   1298  N   HIS B  37     -26.627 -16.122  -7.195  1.00 59.18           N  
ATOM   1299  CA  HIS B  37     -27.589 -15.294  -7.909  1.00 59.18           C  
ATOM   1300  C   HIS B  37     -27.058 -13.985  -8.498  1.00 59.18           C  
ATOM   1301  O   HIS B  37     -27.525 -13.561  -9.550  1.00 59.18           O  
ATOM   1302  CB  HIS B  37     -28.828 -15.018  -7.040  1.00 80.30           C  
ATOM   1303  CG  HIS B  37     -28.523 -14.450  -5.689  1.00 80.30           C  
ATOM   1304  ND1 HIS B  37     -28.024 -15.212  -4.655  1.00 80.30           N  
ATOM   1305  CD2 HIS B  37     -28.671 -13.197  -5.196  1.00 80.30           C  
ATOM   1306  CE1 HIS B  37     -27.878 -14.453  -3.583  1.00 80.30           C  
ATOM   1307  NE2 HIS B  37     -28.263 -13.226  -3.885  1.00 80.30           N  
ATOM   1308  N   ILE B  38     -26.090 -13.347  -7.848  1.00 51.27           N  
ATOM   1309  CA  ILE B  38     -25.552 -12.088  -8.368  1.00 51.27           C  
ATOM   1310  C   ILE B  38     -25.070 -12.271  -9.810  1.00 51.27           C  
ATOM   1311  O   ILE B  38     -24.977 -11.301 -10.573  1.00 51.27           O  
ATOM   1312  CB  ILE B  38     -24.348 -11.562  -7.502  1.00 37.65           C  
ATOM   1313  CG1 ILE B  38     -24.050 -10.093  -7.811  1.00 37.65           C  
ATOM   1314  CG2 ILE B  38     -23.080 -12.351  -7.811  1.00 37.65           C  
ATOM   1315  CD1 ILE B  38     -25.130  -9.147  -7.358  1.00 37.65           C  
ATOM   1316  N   PHE B  39     -24.758 -13.515 -10.172  1.00 59.91           N  
ATOM   1317  CA  PHE B  39     -24.273 -13.839 -11.515  1.00 59.91           C  
ATOM   1318  C   PHE B  39     -25.339 -13.660 -12.585  1.00 59.91           C  
ATOM   1319  O   PHE B  39     -25.041 -13.737 -13.772  1.00 59.91           O  
ATOM   1320  CB  PHE B  39     -23.781 -15.292 -11.576  1.00 53.03           C  
ATOM   1321  CG  PHE B  39     -22.492 -15.536 -10.843  1.00 53.03           C  
ATOM   1322  CD1 PHE B  39     -22.252 -16.771 -10.237  1.00 53.03           C  
ATOM   1323  CD2 PHE B  39     -21.529 -14.531 -10.733  1.00 53.03           C  
ATOM   1324  CE1 PHE B  39     -21.077 -16.998  -9.526  1.00 53.03           C  
ATOM   1325  CE2 PHE B  39     -20.355 -14.744 -10.031  1.00 53.03           C  
ATOM   1326  CZ  PHE B  39     -20.127 -15.980  -9.422  1.00 53.03           C  
ATOM   1327  N   GLN B  40     -26.581 -13.442 -12.166  1.00 60.08           N  
ATOM   1328  CA  GLN B  40     -27.687 -13.268 -13.099  1.00 60.08           C  
ATOM   1329  C   GLN B  40     -27.946 -11.821 -13.440  1.00 60.08           C  
ATOM   1330  O   GLN B  40     -28.667 -11.528 -14.387  1.00 60.08           O  
ATOM   1331  CB  GLN B  40     -28.973 -13.861 -12.537  1.00 65.93           C  
ATOM   1332  CG  GLN B  40     -29.064 -15.362 -12.608  1.00 65.93           C  
ATOM   1333  CD  GLN B  40     -30.443 -15.846 -12.216  1.00 65.93           C  
ATOM   1334  OE1 GLN B  40     -31.434 -15.120 -12.384  1.00 65.93           O  
ATOM   1335  NE2 GLN B  40     -30.524 -17.078 -11.705  1.00 65.93           N  
ATOM   1336  N   GLN B  41     -27.384 -10.916 -12.655  1.00 44.64           N  
ATOM   1337  CA  GLN B  41     -27.561  -9.494 -12.902  1.00 44.64           C  
ATOM   1338  C   GLN B  41     -26.614  -9.076 -14.015  1.00 44.64           C  
ATOM   1339  O   GLN B  41     -25.678  -9.803 -14.353  1.00 44.64           O  
ATOM   1340  CB  GLN B  41     -27.253  -8.694 -11.635  1.00 53.19           C  
ATOM   1341  CG  GLN B  41     -28.195  -8.989 -10.481  1.00 53.19           C  
ATOM   1342  CD  GLN B  41     -27.983  -8.058  -9.296  1.00 53.19           C  
ATOM   1343  OE1 GLN B  41     -27.631  -6.882  -9.458  1.00 53.19           O  
ATOM   1344  NE2 GLN B  41     -28.220  -8.575  -8.096  1.00 53.19           N  
ATOM   1345  N   GLU B  42     -26.856  -7.910 -14.594  1.00 56.13           N  
ATOM   1346  CA  GLU B  42     -25.980  -7.446 -15.648  1.00 56.13           C  
ATOM   1347  C   GLU B  42     -24.732  -6.906 -14.986  1.00 56.13           C  
ATOM   1348  O   GLU B  42     -24.800  -6.104 -14.059  1.00 56.13           O  
ATOM   1349  CB  GLU B  42     -26.673  -6.386 -16.493  1.00 93.12           C  
ATOM   1350  CG  GLU B  42     -27.958  -6.901 -17.107  1.00 93.12           C  
ATOM   1351  CD  GLU B  42     -28.242  -6.297 -18.453  1.00 93.12           C  
ATOM   1352  OE1 GLU B  42     -27.434  -6.521 -19.379  1.00 93.12           O  
ATOM   1353  OE2 GLU B  42     -29.270  -5.601 -18.583  1.00 93.12           O  
ATOM   1354  N   TRP B  43     -23.590  -7.382 -15.450  1.00 42.00           N  
ATOM   1355  CA  TRP B  43     -22.325  -6.960 -14.900  1.00 42.00           C  
ATOM   1356  C   TRP B  43     -22.003  -5.498 -15.206  1.00 42.00           C  
ATOM   1357  O   TRP B  43     -21.281  -5.204 -16.160  1.00 42.00           O  
ATOM   1358  CB  TRP B  43     -21.208  -7.869 -15.421  1.00 39.73           C  
ATOM   1359  CG  TRP B  43     -19.927  -7.669 -14.688  1.00 39.73           C  
ATOM   1360  CD1 TRP B  43     -18.802  -7.052 -15.148  1.00 39.73           C  
ATOM   1361  CD2 TRP B  43     -19.675  -7.990 -13.314  1.00 39.73           C  
ATOM   1362  NE1 TRP B  43     -17.867  -6.957 -14.144  1.00 39.73           N  
ATOM   1363  CE2 TRP B  43     -18.377  -7.529 -13.008  1.00 39.73           C  
ATOM   1364  CE3 TRP B  43     -20.425  -8.622 -12.309  1.00 39.73           C  
ATOM   1365  CZ2 TRP B  43     -17.810  -7.680 -11.737  1.00 39.73           C  
ATOM   1366  CZ3 TRP B  43     -19.854  -8.773 -11.041  1.00 39.73           C  
ATOM   1367  CH2 TRP B  43     -18.562  -8.303 -10.770  1.00 39.73           C  
ATOM   1368  N   LYS B  44     -22.551  -4.588 -14.407  1.00 48.56           N  
ATOM   1369  CA  LYS B  44     -22.291  -3.163 -14.563  1.00 48.56           C  
ATOM   1370  C   LYS B  44     -21.637  -2.789 -13.234  1.00 48.56           C  
ATOM   1371  O   LYS B  44     -22.284  -2.278 -12.331  1.00 48.56           O  
ATOM   1372  CB  LYS B  44     -23.602  -2.406 -14.765  1.00 77.53           C  
ATOM   1373  CG  LYS B  44     -24.411  -2.853 -15.973  1.00 77.53           C  
ATOM   1374  CD  LYS B  44     -25.653  -1.986 -16.146  1.00 77.53           C  
ATOM   1375  CE  LYS B  44     -26.461  -2.399 -17.363  1.00 77.53           C  
ATOM   1376  NZ  LYS B  44     -27.540  -1.417 -17.657  1.00 77.53           N  
ATOM   1377  N   PRO B  45     -20.332  -3.040 -13.108  1.00 49.95           N  
ATOM   1378  CA  PRO B  45     -19.545  -2.769 -11.904  1.00 49.95           C  
ATOM   1379  C   PRO B  45     -19.236  -1.345 -11.512  1.00 49.95           C  
ATOM   1380  O   PRO B  45     -18.962  -0.507 -12.362  1.00 49.95           O  
ATOM   1381  CB  PRO B  45     -18.274  -3.569 -12.151  1.00 44.24           C  
ATOM   1382  CG  PRO B  45     -18.085  -3.397 -13.613  1.00 44.24           C  
ATOM   1383  CD  PRO B  45     -19.478  -3.600 -14.171  1.00 44.24           C  
ATOM   1384  N   LYS B  46     -19.266  -1.105 -10.204  1.00 47.79           N  
ATOM   1385  CA  LYS B  46     -18.950   0.185  -9.600  1.00 47.79           C  
ATOM   1386  C   LYS B  46     -17.886  -0.161  -8.552  1.00 47.79           C  
ATOM   1387  O   LYS B  46     -18.189  -0.781  -7.524  1.00 47.79           O  
ATOM   1388  CB  LYS B  46     -20.200   0.778  -8.942  1.00 76.61           C  
ATOM   1389  CG  LYS B  46     -20.043   2.220  -8.462  1.00 76.61           C  
ATOM   1390  CD  LYS B  46     -21.386   2.823  -8.036  1.00 76.61           C  
ATOM   1391  CE  LYS B  46     -21.229   4.241  -7.481  1.00 76.61           C  
ATOM   1392  NZ  LYS B  46     -20.457   4.287  -6.199  1.00 76.61           N  
ATOM   1393  N   LEU B  47     -16.640   0.227  -8.827  1.00 43.58           N  
ATOM   1394  CA  LEU B  47     -15.504  -0.073  -7.957  1.00 43.58           C  
ATOM   1395  C   LEU B  47     -15.117   0.961  -6.897  1.00 43.58           C  
ATOM   1396  O   LEU B  47     -14.828   2.108  -7.220  1.00 43.58           O  
ATOM   1397  CB  LEU B  47     -14.264  -0.353  -8.815  1.00 38.06           C  
ATOM   1398  CG  LEU B  47     -12.965  -0.602  -8.032  1.00 38.06           C  
ATOM   1399  CD1 LEU B  47     -12.823  -2.084  -7.742  1.00 38.06           C  
ATOM   1400  CD2 LEU B  47     -11.766  -0.128  -8.813  1.00 38.06           C  
ATOM   1401  N   GLY B  48     -15.089   0.531  -5.636  1.00 51.55           N  
ATOM   1402  CA  GLY B  48     -14.685   1.393  -4.536  1.00 51.55           C  
ATOM   1403  C   GLY B  48     -13.294   0.926  -4.140  1.00 51.55           C  
ATOM   1404  O   GLY B  48     -13.100  -0.259  -3.843  1.00 51.55           O  
ATOM   1405  N   PHE B  49     -12.328   1.843  -4.121  1.00 40.96           N  
ATOM   1406  CA  PHE B  49     -10.945   1.488  -3.821  1.00 40.96           C  
ATOM   1407  C   PHE B  49     -10.304   2.353  -2.733  1.00 40.96           C  
ATOM   1408  O   PHE B  49     -10.152   3.555  -2.902  1.00 40.96           O  
ATOM   1409  CB  PHE B  49     -10.148   1.585  -5.134  1.00 58.28           C  
ATOM   1410  CG  PHE B  49      -8.673   1.353  -4.987  1.00 58.28           C  
ATOM   1411  CD1 PHE B  49      -8.178   0.104  -4.635  1.00 58.28           C  
ATOM   1412  CD2 PHE B  49      -7.776   2.388  -5.211  1.00 58.28           C  
ATOM   1413  CE1 PHE B  49      -6.811  -0.116  -4.509  1.00 58.28           C  
ATOM   1414  CE2 PHE B  49      -6.408   2.180  -5.088  1.00 58.28           C  
ATOM   1415  CZ  PHE B  49      -5.923   0.923  -4.736  1.00 58.28           C  
ATOM   1416  N   ASP B  50      -9.929   1.744  -1.612  1.00 54.68           N  
ATOM   1417  CA  ASP B  50      -9.293   2.495  -0.536  1.00 54.68           C  
ATOM   1418  C   ASP B  50      -7.866   2.003  -0.323  1.00 54.68           C  
ATOM   1419  O   ASP B  50      -7.584   0.807  -0.441  1.00 54.68           O  
ATOM   1420  CB  ASP B  50     -10.107   2.371   0.749  1.00125.62           C  
ATOM   1421  CG  ASP B  50     -11.505   2.933   0.600  1.00125.62           C  
ATOM   1422  OD1 ASP B  50     -11.635   4.095   0.157  1.00125.62           O  
ATOM   1423  OD2 ASP B  50     -12.473   2.218   0.924  1.00125.62           O  
ATOM   1424  N   LEU B  51      -6.964   2.930  -0.016  1.00 36.61           N  
ATOM   1425  CA  LEU B  51      -5.561   2.586   0.188  1.00 36.61           C  
ATOM   1426  C   LEU B  51      -4.887   3.387   1.315  1.00 36.61           C  
ATOM   1427  O   LEU B  51      -5.221   4.553   1.571  1.00 36.61           O  
ATOM   1428  CB  LEU B  51      -4.807   2.806  -1.120  1.00 45.08           C  
ATOM   1429  CG  LEU B  51      -3.317   2.480  -1.223  1.00 45.08           C  
ATOM   1430  CD1 LEU B  51      -2.937   2.368  -2.704  1.00 45.08           C  
ATOM   1431  CD2 LEU B  51      -2.486   3.544  -0.537  1.00 45.08           C  
ATOM   1432  N   SER B  52      -3.929   2.762   1.990  1.00 40.97           N  
ATOM   1433  CA  SER B  52      -3.215   3.438   3.064  1.00 40.97           C  
ATOM   1434  C   SER B  52      -1.990   2.631   3.458  1.00 40.97           C  
ATOM   1435  O   SER B  52      -1.929   1.430   3.220  1.00 40.97           O  
ATOM   1436  CB  SER B  52      -4.112   3.595   4.283  1.00 28.42           C  
ATOM   1437  OG  SER B  52      -3.870   2.536   5.189  1.00 28.42           O  
ATOM   1438  N   THR B  53      -1.015   3.298   4.062  1.00 43.18           N  
ATOM   1439  CA  THR B  53       0.197   2.616   4.491  1.00 43.18           C  
ATOM   1440  C   THR B  53       0.565   2.986   5.921  1.00 43.18           C  
ATOM   1441  O   THR B  53       0.123   4.004   6.449  1.00 43.18           O  
ATOM   1442  CB  THR B  53       1.381   2.942   3.571  1.00 40.93           C  
ATOM   1443  OG1 THR B  53       1.735   4.324   3.701  1.00 40.93           O  
ATOM   1444  CG2 THR B  53       1.011   2.657   2.125  1.00 40.93           C  
ATOM   1445  N   GLU B  54       1.369   2.142   6.548  1.00 47.83           N  
ATOM   1446  CA  GLU B  54       1.795   2.367   7.918  1.00 47.83           C  
ATOM   1447  C   GLU B  54       3.110   1.645   8.131  1.00 47.83           C  
ATOM   1448  O   GLU B  54       3.326   0.547   7.615  1.00 47.83           O  
ATOM   1449  CB  GLU B  54       0.752   1.838   8.890  1.00 74.77           C  
ATOM   1450  CG  GLU B  54       0.527   0.353   8.777  1.00 74.77           C  
ATOM   1451  CD  GLU B  54      -0.564  -0.128   9.703  1.00 74.77           C  
ATOM   1452  OE1 GLU B  54      -0.473   0.166  10.913  1.00 74.77           O  
ATOM   1453  OE2 GLU B  54      -1.508  -0.799   9.225  1.00 74.77           O  
ATOM   1454  N   THR B  55       3.989   2.269   8.901  1.00 59.33           N  
ATOM   1455  CA  THR B  55       5.298   1.704   9.163  1.00 59.33           C  
ATOM   1456  C   THR B  55       5.539   1.461  10.643  1.00 59.33           C  
ATOM   1457  O   THR B  55       4.904   2.069  11.499  1.00 59.33           O  
ATOM   1458  CB  THR B  55       6.373   2.641   8.631  1.00 56.68           C  
ATOM   1459  OG1 THR B  55       6.034   3.022   7.299  1.00 56.68           O  
ATOM   1460  CG2 THR B  55       7.717   1.963   8.619  1.00 56.68           C  
ATOM   1461  N   THR B  56       6.458   0.556  10.934  1.00 55.33           N  
ATOM   1462  CA  THR B  56       6.806   0.235  12.302  1.00 55.33           C  
ATOM   1463  C   THR B  56       8.221  -0.297  12.318  1.00 55.33           C  
ATOM   1464  O   THR B  56       8.563  -1.187  11.542  1.00 55.33           O  
ATOM   1465  CB  THR B  56       5.869  -0.828  12.900  1.00 48.15           C  
ATOM   1466  OG1 THR B  56       4.643  -0.212  13.304  1.00 48.15           O  
ATOM   1467  CG2 THR B  56       6.517  -1.491  14.106  1.00 48.15           C  
ATOM   1468  N   GLN B  57       9.059   0.266  13.182  1.00 48.86           N  
ATOM   1469  CA  GLN B  57      10.421  -0.220  13.260  1.00 48.86           C  
ATOM   1470  C   GLN B  57      10.358  -1.513  14.053  1.00 48.86           C  
ATOM   1471  O   GLN B  57       9.769  -1.578  15.132  1.00 48.86           O  
ATOM   1472  CB  GLN B  57      11.343   0.786  13.931  1.00 47.43           C  
ATOM   1473  CG  GLN B  57      12.792   0.331  13.908  1.00 47.43           C  
ATOM   1474  CD  GLN B  57      13.759   1.462  14.191  1.00 47.43           C  
ATOM   1475  OE1 GLN B  57      13.346   2.607  14.374  1.00 47.43           O  
ATOM   1476  NE2 GLN B  57      15.054   1.152  14.218  1.00 47.43           N  
ATOM   1477  N   VAL B  58      10.951  -2.552  13.493  1.00 63.91           N  
ATOM   1478  CA  VAL B  58      10.921  -3.856  14.122  1.00 63.91           C  
ATOM   1479  C   VAL B  58      12.317  -4.325  14.526  1.00 63.91           C  
ATOM   1480  O   VAL B  58      12.498  -5.457  14.981  1.00 63.91           O  
ATOM   1481  CB  VAL B  58      10.287  -4.884  13.164  1.00 46.02           C  
ATOM   1482  CG1 VAL B  58      11.164  -5.040  11.939  1.00 46.02           C  
ATOM   1483  CG2 VAL B  58      10.087  -6.218  13.869  1.00 46.02           C  
ATOM   1484  N   GLY B  59      13.302  -3.447  14.364  1.00 52.54           N  
ATOM   1485  CA  GLY B  59      14.671  -3.792  14.714  1.00 52.54           C  
ATOM   1486  C   GLY B  59      15.613  -2.659  14.367  1.00 52.54           C  
ATOM   1487  O   GLY B  59      15.170  -1.569  14.016  1.00 52.54           O  
ATOM   1488  N   ASP B  60      16.912  -2.900  14.480  1.00 70.56           N  
ATOM   1489  CA  ASP B  60      17.887  -1.873  14.139  1.00 70.56           C  
ATOM   1490  C   ASP B  60      17.928  -1.780  12.625  1.00 70.56           C  
ATOM   1491  O   ASP B  60      18.330  -2.737  11.961  1.00 70.56           O  
ATOM   1492  CB  ASP B  60      19.274  -2.259  14.643  1.00121.05           C  
ATOM   1493  CG  ASP B  60      19.377  -2.217  16.144  1.00121.05           C  
ATOM   1494  OD1 ASP B  60      19.268  -1.109  16.707  1.00121.05           O  
ATOM   1495  OD2 ASP B  60      19.565  -3.291  16.755  1.00121.05           O  
ATOM   1496  N   ASP B  61      17.514  -0.645  12.073  1.00 68.22           N  
ATOM   1497  CA  ASP B  61      17.523  -0.480  10.620  1.00 68.22           C  
ATOM   1498  C   ASP B  61      16.513  -1.402   9.948  1.00 68.22           C  
ATOM   1499  O   ASP B  61      16.558  -1.579   8.737  1.00 68.22           O  
ATOM   1500  CB  ASP B  61      18.903  -0.810  10.049  1.00 84.17           C  
ATOM   1501  CG  ASP B  61      19.984   0.087  10.583  1.00 84.17           C  
ATOM   1502  OD1 ASP B  61      21.169  -0.319  10.534  1.00 84.17           O  
ATOM   1503  OD2 ASP B  61      19.648   1.199  11.040  1.00 84.17           O  
ATOM   1504  N   LEU B  62      15.624  -2.005  10.732  1.00 40.88           N  
ATOM   1505  CA  LEU B  62      14.613  -2.908  10.194  1.00 40.88           C  
ATOM   1506  C   LEU B  62      13.240  -2.322  10.395  1.00 40.88           C  
ATOM   1507  O   LEU B  62      12.833  -2.059  11.526  1.00 40.88           O  
ATOM   1508  CB  LEU B  62      14.683  -4.278  10.867  1.00 48.99           C  
ATOM   1509  CG  LEU B  62      15.773  -5.198  10.331  1.00 48.99           C  
ATOM   1510  CD1 LEU B  62      15.619  -6.584  10.925  1.00 48.99           C  
ATOM   1511  CD2 LEU B  62      15.663  -5.258   8.811  1.00 48.99           C  
ATOM   1512  N   TYR B  63      12.526  -2.119   9.295  1.00 50.32           N  
ATOM   1513  CA  TYR B  63      11.197  -1.545   9.365  1.00 50.32           C  
ATOM   1514  C   TYR B  63      10.210  -2.413   8.619  1.00 50.32           C  
ATOM   1515  O   TYR B  63      10.531  -2.969   7.570  1.00 50.32           O  
ATOM   1516  CB  TYR B  63      11.199  -0.144   8.751  1.00 48.82           C  
ATOM   1517  CG  TYR B  63      12.299   0.755   9.261  1.00 48.82           C  
ATOM   1518  CD1 TYR B  63      13.641   0.416   9.079  1.00 48.82           C  
ATOM   1519  CD2 TYR B  63      12.003   1.941   9.939  1.00 48.82           C  
ATOM   1520  CE1 TYR B  63      14.662   1.226   9.560  1.00 48.82           C  
ATOM   1521  CE2 TYR B  63      13.024   2.767  10.425  1.00 48.82           C  
ATOM   1522  CZ  TYR B  63      14.348   2.398  10.233  1.00 48.82           C  
ATOM   1523  OH  TYR B  63      15.367   3.177  10.727  1.00 48.82           O  
ATOM   1524  N   GLU B  64       9.011  -2.537   9.174  1.00 53.47           N  
ATOM   1525  CA  GLU B  64       7.965  -3.309   8.533  1.00 53.47           C  
ATOM   1526  C   GLU B  64       7.029  -2.299   7.905  1.00 53.47           C  
ATOM   1527  O   GLU B  64       6.401  -1.510   8.617  1.00 53.47           O  
ATOM   1528  CB  GLU B  64       7.173  -4.135   9.543  1.00 39.42           C  
ATOM   1529  CG  GLU B  64       5.952  -4.833   8.929  1.00 39.42           C  
ATOM   1530  CD  GLU B  64       4.868  -5.134   9.962  1.00 39.42           C  
ATOM   1531  OE1 GLU B  64       4.485  -4.201  10.699  1.00 39.42           O  
ATOM   1532  OE2 GLU B  64       4.389  -6.287  10.038  1.00 39.42           O  
ATOM   1533  N   VAL B  65       6.946  -2.295   6.578  1.00 46.63           N  
ATOM   1534  CA  VAL B  65       6.038  -1.378   5.918  1.00 46.63           C  
ATOM   1535  C   VAL B  65       4.805  -2.189   5.546  1.00 46.63           C  
ATOM   1536  O   VAL B  65       4.906  -3.313   5.052  1.00 46.63           O  
ATOM   1537  CB  VAL B  65       6.665  -0.724   4.667  1.00 43.92           C  
ATOM   1538  CG1 VAL B  65       5.695   0.295   4.082  1.00 43.92           C  
ATOM   1539  CG2 VAL B  65       7.953  -0.004   5.037  1.00 43.92           C  
ATOM   1540  N   VAL B  66       3.638  -1.619   5.811  1.00 42.15           N  
ATOM   1541  CA  VAL B  66       2.384  -2.295   5.546  1.00 42.15           C  
ATOM   1542  C   VAL B  66       1.512  -1.516   4.566  1.00 42.15           C  
ATOM   1543  O   VAL B  66       1.254  -0.339   4.753  1.00 42.15           O  
ATOM   1544  CB  VAL B  66       1.624  -2.516   6.885  1.00 37.98           C  
ATOM   1545  CG1 VAL B  66       0.243  -3.060   6.633  1.00 37.98           C  
ATOM   1546  CG2 VAL B  66       2.400  -3.477   7.752  1.00 37.98           C  
ATOM   1547  N   LEU B  67       1.072  -2.188   3.510  1.00 28.55           N  
ATOM   1548  CA  LEU B  67       0.209  -1.585   2.503  1.00 28.55           C  
ATOM   1549  C   LEU B  67      -1.198  -2.131   2.662  1.00 28.55           C  
ATOM   1550  O   LEU B  67      -1.424  -3.326   2.510  1.00 28.55           O  
ATOM   1551  CB  LEU B  67       0.716  -1.913   1.101  1.00 44.39           C  
ATOM   1552  CG  LEU B  67      -0.231  -1.441   0.003  1.00 44.39           C  
ATOM   1553  CD1 LEU B  67      -0.519   0.050   0.180  1.00 44.39           C  
ATOM   1554  CD2 LEU B  67       0.382  -1.728  -1.356  1.00 44.39           C  
ATOM   1555  N   ASN B  68      -2.143  -1.257   2.986  1.00 36.74           N  
ATOM   1556  CA  ASN B  68      -3.528  -1.670   3.158  1.00 36.74           C  
ATOM   1557  C   ASN B  68      -4.347  -1.296   1.943  1.00 36.74           C  
ATOM   1558  O   ASN B  68      -4.381  -0.143   1.520  1.00 36.74           O  
ATOM   1559  CB  ASN B  68      -4.127  -1.022   4.395  1.00 48.29           C  
ATOM   1560  CG  ASN B  68      -3.364  -1.359   5.622  1.00 48.29           C  
ATOM   1561  OD1 ASN B  68      -3.172  -2.529   5.932  1.00 48.29           O  
ATOM   1562  ND2 ASN B  68      -2.899  -0.342   6.331  1.00 48.29           N  
ATOM   1563  N   ILE B  69      -5.015  -2.283   1.376  1.00 24.71           N  
ATOM   1564  CA  ILE B  69      -5.828  -2.042   0.210  1.00 24.71           C  
ATOM   1565  C   ILE B  69      -7.204  -2.631   0.445  1.00 24.71           C  
ATOM   1566  O   ILE B  69      -7.345  -3.775   0.871  1.00 24.71           O  
ATOM   1567  CB  ILE B  69      -5.140  -2.631  -1.059  1.00 32.31           C  
ATOM   1568  CG1 ILE B  69      -4.013  -1.688  -1.487  1.00 32.31           C  
ATOM   1569  CG2 ILE B  69      -6.139  -2.840  -2.175  1.00 32.31           C  
ATOM   1570  CD1 ILE B  69      -3.470  -1.930  -2.849  1.00 32.31           C  
ATOM   1571  N   SER B  70      -8.219  -1.819   0.186  1.00 36.53           N  
ATOM   1572  CA  SER B  70      -9.600  -2.221   0.377  1.00 36.53           C  
ATOM   1573  C   SER B  70     -10.324  -2.034  -0.949  1.00 36.53           C  
ATOM   1574  O   SER B  70     -10.248  -0.979  -1.560  1.00 36.53           O  
ATOM   1575  CB  SER B  70     -10.236  -1.353   1.456  1.00 61.35           C  
ATOM   1576  OG  SER B  70     -11.343  -2.014   2.030  1.00 61.35           O  
ATOM   1577  N   VAL B  71     -11.030  -3.067  -1.385  1.00 41.65           N  
ATOM   1578  CA  VAL B  71     -11.737  -3.027  -2.646  1.00 41.65           C  
ATOM   1579  C   VAL B  71     -13.166  -3.534  -2.529  1.00 41.65           C  
ATOM   1580  O   VAL B  71     -13.405  -4.621  -2.022  1.00 41.65           O  
ATOM   1581  CB  VAL B  71     -10.999  -3.874  -3.677  1.00 38.52           C  
ATOM   1582  CG1 VAL B  71     -11.870  -4.081  -4.885  1.00 38.52           C  
ATOM   1583  CG2 VAL B  71      -9.712  -3.186  -4.067  1.00 38.52           C  
ATOM   1584  N   GLU B  72     -14.114  -2.744  -3.013  1.00 34.89           N  
ATOM   1585  CA  GLU B  72     -15.522  -3.113  -2.968  1.00 34.89           C  
ATOM   1586  C   GLU B  72     -16.162  -2.886  -4.337  1.00 34.89           C  
ATOM   1587  O   GLU B  72     -16.079  -1.808  -4.898  1.00 34.89           O  
ATOM   1588  CB  GLU B  72     -16.242  -2.269  -1.919  1.00100.74           C  
ATOM   1589  CG  GLU B  72     -17.732  -2.537  -1.819  1.00100.74           C  
ATOM   1590  CD  GLU B  72     -18.402  -1.734  -0.717  1.00100.74           C  
ATOM   1591  OE1 GLU B  72     -19.615  -1.926  -0.494  1.00100.74           O  
ATOM   1592  OE2 GLU B  72     -17.717  -0.909  -0.072  1.00100.74           O  
ATOM   1593  N   THR B  73     -16.801  -3.901  -4.884  1.00 37.23           N  
ATOM   1594  CA  THR B  73     -17.431  -3.742  -6.181  1.00 37.23           C  
ATOM   1595  C   THR B  73     -18.913  -4.035  -6.086  1.00 37.23           C  
ATOM   1596  O   THR B  73     -19.329  -5.093  -5.581  1.00 37.23           O  
ATOM   1597  CB  THR B  73     -16.784  -4.676  -7.239  1.00 34.48           C  
ATOM   1598  OG1 THR B  73     -15.526  -4.126  -7.640  1.00 34.48           O  
ATOM   1599  CG2 THR B  73     -17.670  -4.825  -8.454  1.00 34.48           C  
ATOM   1600  N   THR B  74     -19.707  -3.084  -6.569  1.00 43.50           N  
ATOM   1601  CA  THR B  74     -21.153  -3.234  -6.562  1.00 43.50           C  
ATOM   1602  C   THR B  74     -21.677  -3.123  -7.978  1.00 43.50           C  
ATOM   1603  O   THR B  74     -21.034  -2.526  -8.836  1.00 43.50           O  
ATOM   1604  CB  THR B  74     -21.847  -2.153  -5.696  1.00 35.36           C  
ATOM   1605  OG1 THR B  74     -21.422  -0.847  -6.114  1.00 35.36           O  
ATOM   1606  CG2 THR B  74     -21.499  -2.343  -4.229  1.00 35.36           C  
ATOM   1607  N   LEU B  75     -22.832  -3.734  -8.218  1.00 45.87           N  
ATOM   1608  CA  LEU B  75     -23.511  -3.700  -9.511  1.00 45.87           C  
ATOM   1609  C   LEU B  75     -24.451  -2.475  -9.465  1.00 45.87           C  
ATOM   1610  O   LEU B  75     -25.317  -2.394  -8.594  1.00 45.87           O  
ATOM   1611  CB  LEU B  75     -24.313  -4.991  -9.674  1.00 23.92           C  
ATOM   1612  CG  LEU B  75     -23.666  -6.199 -10.367  1.00 23.92           C  
ATOM   1613  CD1 LEU B  75     -22.272  -6.443  -9.849  1.00 23.92           C  
ATOM   1614  CD2 LEU B  75     -24.553  -7.441 -10.187  1.00 23.92           C  
ATOM   1615  N   GLU B  76     -24.294  -1.539 -10.398  1.00 60.51           N  
ATOM   1616  CA  GLU B  76     -25.091  -0.309 -10.411  1.00 60.51           C  
ATOM   1617  C   GLU B  76     -26.611  -0.377 -10.459  1.00 60.51           C  
ATOM   1618  O   GLU B  76     -27.287   0.286  -9.671  1.00 60.51           O  
ATOM   1619  CB  GLU B  76     -24.601   0.618 -11.531  1.00 89.36           C  
ATOM   1620  CG  GLU B  76     -24.425  -0.034 -12.886  1.00 89.36           C  
ATOM   1621  CD  GLU B  76     -23.607   0.830 -13.838  1.00 89.36           C  
ATOM   1622  OE1 GLU B  76     -22.549   1.344 -13.413  1.00 89.36           O  
ATOM   1623  OE2 GLU B  76     -24.013   0.991 -15.010  1.00 89.36           O  
ATOM   1624  N   ASP B  77     -27.175  -1.160 -11.362  1.00 86.63           N  
ATOM   1625  CA  ASP B  77     -28.626  -1.187 -11.418  1.00 86.63           C  
ATOM   1626  C   ASP B  77     -29.288  -2.086 -10.376  1.00 86.63           C  
ATOM   1627  O   ASP B  77     -30.314  -2.715 -10.641  1.00 86.63           O  
ATOM   1628  CB  ASP B  77     -29.106  -1.541 -12.826  1.00100.62           C  
ATOM   1629  CG  ASP B  77     -28.697  -2.918 -13.248  1.00100.62           C  
ATOM   1630  OD1 ASP B  77     -29.011  -3.278 -14.400  1.00100.62           O  
ATOM   1631  OD2 ASP B  77     -28.070  -3.637 -12.433  1.00100.62           O  
ATOM   1632  N   SER B  78     -28.702  -2.138  -9.181  1.00 59.15           N  
ATOM   1633  CA  SER B  78     -29.272  -2.930  -8.089  1.00 59.15           C  
ATOM   1634  C   SER B  78     -28.621  -2.587  -6.757  1.00 59.15           C  
ATOM   1635  O   SER B  78     -29.216  -2.790  -5.697  1.00 59.15           O  
ATOM   1636  CB  SER B  78     -29.136  -4.433  -8.360  1.00 60.39           C  
ATOM   1637  OG  SER B  78     -27.831  -4.895  -8.071  1.00 60.39           O  
ATOM   1638  N   GLY B  79     -27.401  -2.065  -6.811  1.00 61.48           N  
ATOM   1639  CA  GLY B  79     -26.708  -1.703  -5.587  1.00 61.48           C  
ATOM   1640  C   GLY B  79     -26.109  -2.881  -4.835  1.00 61.48           C  
ATOM   1641  O   GLY B  79     -25.382  -2.678  -3.865  1.00 61.48           O  
ATOM   1642  N   ASP B  80     -26.414  -4.102  -5.280  1.00 51.56           N  
ATOM   1643  CA  ASP B  80     -25.898  -5.329  -4.662  1.00 51.56           C  
ATOM   1644  C   ASP B  80     -24.371  -5.408  -4.631  1.00 51.56           C  
ATOM   1645  O   ASP B  80     -23.703  -4.976  -5.573  1.00 51.56           O  
ATOM   1646  CB  ASP B  80     -26.397  -6.561  -5.417  1.00 42.37           C  
ATOM   1647  CG  ASP B  80     -27.864  -6.809  -5.224  1.00 42.37           C  
ATOM   1648  OD1 ASP B  80     -28.363  -7.830  -5.747  1.00 42.37           O  
ATOM   1649  OD2 ASP B  80     -28.519  -5.986  -4.548  1.00 42.37           O  
ATOM   1650  N   VAL B  81     -23.821  -5.984  -3.562  1.00 37.90           N  
ATOM   1651  CA  VAL B  81     -22.370  -6.134  -3.463  1.00 37.90           C  
ATOM   1652  C   VAL B  81     -21.965  -7.369  -4.242  1.00 37.90           C  
ATOM   1653  O   VAL B  81     -22.515  -8.448  -4.033  1.00 37.90           O  
ATOM   1654  CB  VAL B  81     -21.888  -6.354  -2.026  1.00 39.36           C  
ATOM   1655  CG1 VAL B  81     -20.435  -6.002  -1.934  1.00 39.36           C  
ATOM   1656  CG2 VAL B  81     -22.708  -5.530  -1.061  1.00 39.36           C  
ATOM   1657  N   ALA B  82     -21.015  -7.209  -5.155  1.00 32.57           N  
ATOM   1658  CA  ALA B  82     -20.539  -8.342  -5.937  1.00 32.57           C  
ATOM   1659  C   ALA B  82     -19.460  -9.034  -5.093  1.00 32.57           C  
ATOM   1660  O   ALA B  82     -19.480 -10.260  -4.900  1.00 32.57           O  
ATOM   1661  CB  ALA B  82     -19.973  -7.862  -7.242  1.00 11.42           C  
ATOM   1662  N   PHE B  83     -18.539  -8.224  -4.570  1.00 23.29           N  
ATOM   1663  CA  PHE B  83     -17.472  -8.726  -3.723  1.00 23.29           C  
ATOM   1664  C   PHE B  83     -16.728  -7.611  -2.970  1.00 23.29           C  
ATOM   1665  O   PHE B  83     -16.666  -6.459  -3.431  1.00 23.29           O  
ATOM   1666  CB  PHE B  83     -16.473  -9.581  -4.553  1.00 15.92           C  
ATOM   1667  CG  PHE B  83     -15.629  -8.790  -5.535  1.00 15.92           C  
ATOM   1668  CD1 PHE B  83     -14.664  -7.886  -5.090  1.00 15.92           C  
ATOM   1669  CD2 PHE B  83     -15.815  -8.937  -6.913  1.00 15.92           C  
ATOM   1670  CE1 PHE B  83     -13.904  -7.138  -6.010  1.00 15.92           C  
ATOM   1671  CE2 PHE B  83     -15.056  -8.190  -7.820  1.00 15.92           C  
ATOM   1672  CZ  PHE B  83     -14.105  -7.293  -7.361  1.00 15.92           C  
ATOM   1673  N   ILE B  84     -16.192  -7.973  -1.800  1.00 43.04           N  
ATOM   1674  CA  ILE B  84     -15.414  -7.064  -0.965  1.00 43.04           C  
ATOM   1675  C   ILE B  84     -14.079  -7.771  -0.779  1.00 43.04           C  
ATOM   1676  O   ILE B  84     -14.054  -8.966  -0.500  1.00 43.04           O  
ATOM   1677  CB  ILE B  84     -15.977  -6.892   0.465  1.00 37.86           C  
ATOM   1678  CG1 ILE B  84     -17.480  -6.653   0.456  1.00 37.86           C  
ATOM   1679  CG2 ILE B  84     -15.286  -5.716   1.133  1.00 37.86           C  
ATOM   1680  CD1 ILE B  84     -17.868  -5.255   0.057  1.00 37.86           C  
ATOM   1681  N   CYS B  85     -12.978  -7.040  -0.911  1.00 25.45           N  
ATOM   1682  CA  CYS B  85     -11.671  -7.638  -0.735  1.00 25.45           C  
ATOM   1683  C   CYS B  85     -10.735  -6.683  -0.008  1.00 25.45           C  
ATOM   1684  O   CYS B  85     -10.527  -5.554  -0.451  1.00 25.45           O  
ATOM   1685  CB  CYS B  85     -11.075  -8.014  -2.089  1.00 46.42           C  
ATOM   1686  SG  CYS B  85      -9.472  -8.830  -1.969  1.00 46.42           S  
ATOM   1687  N   GLU B  86     -10.184  -7.136   1.117  1.00 46.68           N  
ATOM   1688  CA  GLU B  86      -9.257  -6.332   1.898  1.00 46.68           C  
ATOM   1689  C   GLU B  86      -7.966  -7.102   2.036  1.00 46.68           C  
ATOM   1690  O   GLU B  86      -7.974  -8.280   2.383  1.00 46.68           O  
ATOM   1691  CB  GLU B  86      -9.817  -6.035   3.281  1.00 84.84           C  
ATOM   1692  CG  GLU B  86     -11.135  -5.316   3.255  1.00 84.84           C  
ATOM   1693  CD  GLU B  86     -11.587  -4.905   4.637  1.00 84.84           C  
ATOM   1694  OE1 GLU B  86     -11.685  -5.788   5.520  1.00 84.84           O  
ATOM   1695  OE2 GLU B  86     -11.845  -3.697   4.837  1.00 84.84           O  
ATOM   1696  N   VAL B  87      -6.858  -6.430   1.753  1.00 35.38           N  
ATOM   1697  CA  VAL B  87      -5.533  -7.032   1.834  1.00 35.38           C  
ATOM   1698  C   VAL B  87      -4.565  -6.174   2.643  1.00 35.38           C  
ATOM   1699  O   VAL B  87      -4.531  -4.944   2.501  1.00 35.38           O  
ATOM   1700  CB  VAL B  87      -4.930  -7.225   0.431  1.00 27.35           C  
ATOM   1701  CG1 VAL B  87      -3.424  -7.465   0.533  1.00 27.35           C  
ATOM   1702  CG2 VAL B  87      -5.590  -8.407  -0.258  1.00 27.35           C  
ATOM   1703  N   LYS B  88      -3.786  -6.825   3.497  1.00 44.37           N  
ATOM   1704  CA  LYS B  88      -2.798  -6.138   4.311  1.00 44.37           C  
ATOM   1705  C   LYS B  88      -1.461  -6.758   3.897  1.00 44.37           C  
ATOM   1706  O   LYS B  88      -0.993  -7.745   4.467  1.00 44.37           O  
ATOM   1707  CB  LYS B  88      -3.093  -6.369   5.787  1.00 64.55           C  
ATOM   1708  CG  LYS B  88      -2.452  -5.367   6.697  1.00 64.55           C  
ATOM   1709  CD  LYS B  88      -2.981  -5.507   8.112  1.00 64.55           C  
ATOM   1710  CE  LYS B  88      -2.248  -4.586   9.088  1.00 64.55           C  
ATOM   1711  NZ  LYS B  88      -2.518  -3.135   8.834  1.00 64.55           N  
ATOM   1712  N   GLN B  89      -0.872  -6.175   2.865  1.00 31.60           N  
ATOM   1713  CA  GLN B  89       0.378  -6.652   2.313  1.00 31.60           C  
ATOM   1714  C   GLN B  89       1.530  -5.965   3.024  1.00 31.60           C  
ATOM   1715  O   GLN B  89       1.554  -4.746   3.124  1.00 31.60           O  
ATOM   1716  CB  GLN B  89       0.399  -6.347   0.814  1.00 26.75           C  
ATOM   1717  CG  GLN B  89       1.624  -6.839   0.098  1.00 26.75           C  
ATOM   1718  CD  GLN B  89       1.717  -8.336   0.104  1.00 26.75           C  
ATOM   1719  OE1 GLN B  89       0.783  -9.023  -0.304  1.00 26.75           O  
ATOM   1720  NE2 GLN B  89       2.845  -8.859   0.562  1.00 26.75           N  
ATOM   1721  N   ALA B  90       2.493  -6.741   3.504  1.00 23.04           N  
ATOM   1722  CA  ALA B  90       3.617  -6.160   4.223  1.00 23.04           C  
ATOM   1723  C   ALA B  90       4.986  -6.642   3.774  1.00 23.04           C  
ATOM   1724  O   ALA B  90       5.109  -7.623   3.036  1.00 23.04           O  
ATOM   1725  CB  ALA B  90       3.455  -6.427   5.702  1.00 22.26           C  
ATOM   1726  N   GLY B  91       6.011  -5.935   4.242  1.00 49.08           N  
ATOM   1727  CA  GLY B  91       7.379  -6.288   3.921  1.00 49.08           C  
ATOM   1728  C   GLY B  91       8.315  -5.760   4.990  1.00 49.08           C  
ATOM   1729  O   GLY B  91       8.040  -4.721   5.581  1.00 49.08           O  
ATOM   1730  N   VAL B  92       9.392  -6.488   5.270  1.00 43.87           N  
ATOM   1731  CA  VAL B  92      10.385  -6.044   6.246  1.00 43.87           C  
ATOM   1732  C   VAL B  92      11.571  -5.553   5.430  1.00 43.87           C  
ATOM   1733  O   VAL B  92      12.135  -6.303   4.625  1.00 43.87           O  
ATOM   1734  CB  VAL B  92      10.883  -7.190   7.169  1.00 38.06           C  
ATOM   1735  CG1 VAL B  92      12.115  -6.740   7.931  1.00 38.06           C  
ATOM   1736  CG2 VAL B  92       9.813  -7.573   8.164  1.00 38.06           C  
ATOM   1737  N   PHE B  93      11.953  -4.295   5.621  1.00 55.29           N  
ATOM   1738  CA  PHE B  93      13.074  -3.749   4.868  1.00 55.29           C  
ATOM   1739  C   PHE B  93      14.180  -3.271   5.776  1.00 55.29           C  
ATOM   1740  O   PHE B  93      13.935  -2.875   6.912  1.00 55.29           O  
ATOM   1741  CB  PHE B  93      12.640  -2.560   4.005  1.00 44.94           C  
ATOM   1742  CG  PHE B  93      11.475  -2.840   3.116  1.00 44.94           C  
ATOM   1743  CD1 PHE B  93      10.189  -2.939   3.642  1.00 44.94           C  
ATOM   1744  CD2 PHE B  93      11.659  -3.006   1.751  1.00 44.94           C  
ATOM   1745  CE1 PHE B  93       9.103  -3.198   2.824  1.00 44.94           C  
ATOM   1746  CE2 PHE B  93      10.577  -3.268   0.919  1.00 44.94           C  
ATOM   1747  CZ  PHE B  93       9.291  -3.364   1.461  1.00 44.94           C  
ATOM   1748  N   THR B  94      15.399  -3.321   5.251  1.00 54.04           N  
ATOM   1749  CA  THR B  94      16.581  -2.842   5.942  1.00 54.04           C  
ATOM   1750  C   THR B  94      16.834  -1.469   5.328  1.00 54.04           C  
ATOM   1751  O   THR B  94      17.167  -1.368   4.152  1.00 54.04           O  
ATOM   1752  CB  THR B  94      17.799  -3.721   5.655  1.00 39.16           C  
ATOM   1753  OG1 THR B  94      17.581  -5.029   6.190  1.00 39.16           O  
ATOM   1754  CG2 THR B  94      19.043  -3.121   6.287  1.00 39.16           C  
ATOM   1755  N   ILE B  95      16.652  -0.413   6.111  1.00 55.36           N  
ATOM   1756  CA  ILE B  95      16.872   0.930   5.600  1.00 55.36           C  
ATOM   1757  C   ILE B  95      17.779   1.739   6.522  1.00 55.36           C  
ATOM   1758  O   ILE B  95      17.589   1.771   7.742  1.00 55.36           O  
ATOM   1759  CB  ILE B  95      15.541   1.685   5.429  1.00 43.83           C  
ATOM   1760  CG1 ILE B  95      14.538   0.821   4.661  1.00 43.83           C  
ATOM   1761  CG2 ILE B  95      15.784   2.986   4.674  1.00 43.83           C  
ATOM   1762  CD1 ILE B  95      13.144   1.409   4.617  1.00 43.83           C  
ATOM   1763  N   SER B  96      18.766   2.401   5.931  1.00 82.24           N  
ATOM   1764  CA  SER B  96      19.691   3.205   6.714  1.00 82.24           C  
ATOM   1765  C   SER B  96      20.448   4.209   5.855  1.00 82.24           C  
ATOM   1766  O   SER B  96      20.668   3.985   4.668  1.00 82.24           O  
ATOM   1767  CB  SER B  96      20.692   2.298   7.444  1.00 50.90           C  
ATOM   1768  OG  SER B  96      21.630   1.728   6.546  1.00 50.90           O  
ATOM   1769  N   GLY B  97      20.837   5.319   6.473  1.00 61.83           N  
ATOM   1770  CA  GLY B  97      21.589   6.342   5.773  1.00 61.83           C  
ATOM   1771  C   GLY B  97      20.760   7.351   5.014  1.00 61.83           C  
ATOM   1772  O   GLY B  97      21.143   7.759   3.929  1.00 61.83           O  
ATOM   1773  N   LEU B  98      19.632   7.769   5.574  1.00 83.08           N  
ATOM   1774  CA  LEU B  98      18.786   8.742   4.891  1.00 83.08           C  
ATOM   1775  C   LEU B  98      18.363   9.851   5.831  1.00 83.08           C  
ATOM   1776  O   LEU B  98      18.101   9.610   7.011  1.00 83.08           O  
ATOM   1777  CB  LEU B  98      17.522   8.078   4.341  1.00 84.59           C  
ATOM   1778  CG  LEU B  98      17.613   6.830   3.467  1.00 84.59           C  
ATOM   1779  CD1 LEU B  98      16.210   6.466   3.012  1.00 84.59           C  
ATOM   1780  CD2 LEU B  98      18.518   7.075   2.274  1.00 84.59           C  
ATOM   1781  N   GLU B  99      18.277  11.066   5.303  1.00 58.56           N  
ATOM   1782  CA  GLU B  99      17.864  12.200   6.116  1.00 58.56           C  
ATOM   1783  C   GLU B  99      16.366  12.088   6.368  1.00 58.56           C  
ATOM   1784  O   GLU B  99      15.654  11.463   5.592  1.00 58.56           O  
ATOM   1785  CB  GLU B  99      18.202  13.513   5.407  1.00122.76           C  
ATOM   1786  CG  GLU B  99      19.026  14.459   6.270  1.00122.76           C  
ATOM   1787  CD  GLU B  99      20.242  13.778   6.880  1.00122.76           C  
ATOM   1788  OE1 GLU B  99      21.093  13.281   6.113  1.00122.76           O  
ATOM   1789  OE2 GLU B  99      20.349  13.738   8.125  1.00122.76           O  
ATOM   1790  N   ASP B 100      15.893  12.690   7.451  1.00115.88           N  
ATOM   1791  CA  ASP B 100      14.482  12.624   7.811  1.00115.88           C  
ATOM   1792  C   ASP B 100      13.490  12.641   6.647  1.00115.88           C  
ATOM   1793  O   ASP B 100      12.556  11.842   6.614  1.00115.88           O  
ATOM   1794  CB  ASP B 100      14.154  13.744   8.794  1.00102.39           C  
ATOM   1795  CG  ASP B 100      14.999  13.672  10.047  1.00102.39           C  
ATOM   1796  OD1 ASP B 100      14.677  14.380  11.021  1.00102.39           O  
ATOM   1797  OD2 ASP B 100      15.989  12.908  10.056  1.00102.39           O  
ATOM   1798  N   VAL B 101      13.697  13.541   5.693  1.00 93.34           N  
ATOM   1799  CA  VAL B 101      12.812  13.651   4.539  1.00 93.34           C  
ATOM   1800  C   VAL B 101      12.977  12.457   3.596  1.00 93.34           C  
ATOM   1801  O   VAL B 101      11.993  11.870   3.144  1.00 93.34           O  
ATOM   1802  CB  VAL B 101      13.105  14.942   3.766  1.00 84.24           C  
ATOM   1803  CG1 VAL B 101      11.961  15.254   2.831  1.00 84.24           C  
ATOM   1804  CG2 VAL B 101      13.341  16.082   4.738  1.00 84.24           C  
ATOM   1805  N   GLN B 102      14.231  12.122   3.299  1.00 73.02           N  
ATOM   1806  CA  GLN B 102      14.573  10.997   2.434  1.00 73.02           C  
ATOM   1807  C   GLN B 102      13.924   9.714   2.962  1.00 73.02           C  
ATOM   1808  O   GLN B 102      13.318   8.943   2.217  1.00 73.02           O  
ATOM   1809  CB  GLN B 102      16.091  10.802   2.422  1.00113.27           C  
ATOM   1810  CG  GLN B 102      16.885  12.010   1.972  1.00113.27           C  
ATOM   1811  CD  GLN B 102      17.000  12.097   0.466  1.00113.27           C  
ATOM   1812  OE1 GLN B 102      17.523  13.072  -0.074  1.00113.27           O  
ATOM   1813  NE2 GLN B 102      16.520  11.069  -0.224  1.00113.27           N  
ATOM   1814  N   MET B 103      14.072   9.490   4.263  1.00 67.48           N  
ATOM   1815  CA  MET B 103      13.523   8.303   4.904  1.00 67.48           C  
ATOM   1816  C   MET B 103      11.994   8.290   4.841  1.00 67.48           C  
ATOM   1817  O   MET B 103      11.393   7.246   4.604  1.00 67.48           O  
ATOM   1818  CB  MET B 103      14.001   8.223   6.364  1.00 66.65           C  
ATOM   1819  CG  MET B 103      13.559   6.970   7.134  1.00 66.65           C  
ATOM   1820  SD  MET B 103      14.446   5.454   6.686  1.00 66.65           S  
ATOM   1821  CE  MET B 103      15.399   5.122   8.147  1.00 66.65           C  
ATOM   1822  N   ALA B 104      11.366   9.444   5.044  1.00 74.18           N  
ATOM   1823  CA  ALA B 104       9.910   9.517   5.004  1.00 74.18           C  
ATOM   1824  C   ALA B 104       9.385   9.150   3.625  1.00 74.18           C  
ATOM   1825  O   ALA B 104       8.331   8.524   3.502  1.00 74.18           O  
ATOM   1826  CB  ALA B 104       9.447  10.899   5.376  1.00 29.86           C  
ATOM   1827  N   HIS B 105      10.118   9.546   2.588  1.00 71.44           N  
ATOM   1828  CA  HIS B 105       9.723   9.240   1.218  1.00 71.44           C  
ATOM   1829  C   HIS B 105       9.877   7.743   0.977  1.00 71.44           C  
ATOM   1830  O   HIS B 105       9.044   7.111   0.319  1.00 71.44           O  
ATOM   1831  CB  HIS B 105      10.585  10.027   0.230  1.00 59.01           C  
ATOM   1832  CG  HIS B 105      10.429   9.594  -1.195  1.00 59.01           C  
ATOM   1833  ND1 HIS B 105      11.217   8.618  -1.767  1.00 59.01           N  
ATOM   1834  CD2 HIS B 105       9.574  10.003  -2.162  1.00 59.01           C  
ATOM   1835  CE1 HIS B 105      10.856   8.448  -3.026  1.00 59.01           C  
ATOM   1836  NE2 HIS B 105       9.861   9.276  -3.291  1.00 59.01           N  
ATOM   1837  N   CYS B 106      10.945   7.184   1.534  1.00 54.25           N  
ATOM   1838  CA  CYS B 106      11.235   5.764   1.403  1.00 54.25           C  
ATOM   1839  C   CYS B 106      10.177   4.892   2.092  1.00 54.25           C  
ATOM   1840  O   CYS B 106       9.799   3.844   1.582  1.00 54.25           O  
ATOM   1841  CB  CYS B 106      12.619   5.476   1.987  1.00 64.71           C  
ATOM   1842  SG  CYS B 106      13.140   3.756   1.925  1.00 64.71           S  
ATOM   1843  N   LEU B 107       9.678   5.338   3.238  1.00 48.27           N  
ATOM   1844  CA  LEU B 107       8.690   4.559   3.973  1.00 48.27           C  
ATOM   1845  C   LEU B 107       7.251   4.756   3.537  1.00 48.27           C  
ATOM   1846  O   LEU B 107       6.425   3.873   3.758  1.00 48.27           O  
ATOM   1847  CB  LEU B 107       8.819   4.826   5.479  1.00 49.45           C  
ATOM   1848  CG  LEU B 107      10.218   4.542   6.048  1.00 49.45           C  
ATOM   1849  CD1 LEU B 107      10.280   4.951   7.501  1.00 49.45           C  
ATOM   1850  CD2 LEU B 107      10.556   3.073   5.883  1.00 49.45           C  
ATOM   1851  N   THR B 108       6.950   5.893   2.913  1.00 55.37           N  
ATOM   1852  CA  THR B 108       5.579   6.173   2.474  1.00 55.37           C  
ATOM   1853  C   THR B 108       5.370   6.073   0.971  1.00 55.37           C  
ATOM   1854  O   THR B 108       4.237   6.093   0.497  1.00 55.37           O  
ATOM   1855  CB  THR B 108       5.106   7.582   2.910  1.00 51.49           C  
ATOM   1856  OG1 THR B 108       5.985   8.571   2.362  1.00 51.49           O  
ATOM   1857  CG2 THR B 108       5.088   7.704   4.423  1.00 51.49           C  
ATOM   1858  N   SER B 109       6.456   5.971   0.219  1.00 63.42           N  
ATOM   1859  CA  SER B 109       6.342   5.880  -1.225  1.00 63.42           C  
ATOM   1860  C   SER B 109       7.161   4.742  -1.812  1.00 63.42           C  
ATOM   1861  O   SER B 109       6.611   3.833  -2.432  1.00 63.42           O  
ATOM   1862  CB  SER B 109       6.767   7.195  -1.874  1.00 74.05           C  
ATOM   1863  OG  SER B 109       6.740   7.082  -3.285  1.00 74.05           O  
ATOM   1864  N   GLN B 110       8.476   4.794  -1.621  1.00 39.66           N  
ATOM   1865  CA  GLN B 110       9.342   3.756  -2.156  1.00 39.66           C  
ATOM   1866  C   GLN B 110       8.904   2.335  -1.804  1.00 39.66           C  
ATOM   1867  O   GLN B 110       8.633   1.517  -2.688  1.00 39.66           O  
ATOM   1868  CB  GLN B 110      10.774   3.936  -1.669  1.00 56.22           C  
ATOM   1869  CG  GLN B 110      11.552   5.022  -2.342  1.00 56.22           C  
ATOM   1870  CD  GLN B 110      13.029   4.747  -2.262  1.00 56.22           C  
ATOM   1871  OE1 GLN B 110      13.526   3.816  -2.893  1.00 56.22           O  
ATOM   1872  NE2 GLN B 110      13.743   5.539  -1.467  1.00 56.22           N  
ATOM   1873  N   CYS B 111       8.864   2.040  -0.508  1.00 33.06           N  
ATOM   1874  CA  CYS B 111       8.492   0.717  -0.049  1.00 33.06           C  
ATOM   1875  C   CYS B 111       7.074   0.309  -0.440  1.00 33.06           C  
ATOM   1876  O   CYS B 111       6.863  -0.773  -1.009  1.00 33.06           O  
ATOM   1877  CB  CYS B 111       8.673   0.621   1.457  1.00 49.38           C  
ATOM   1878  SG  CYS B 111      10.396   0.501   1.917  1.00 49.38           S  
ATOM   1879  N   PRO B 112       6.081   1.160  -0.144  1.00 44.49           N  
ATOM   1880  CA  PRO B 112       4.718   0.793  -0.508  1.00 44.49           C  
ATOM   1881  C   PRO B 112       4.655   0.466  -1.985  1.00 44.49           C  
ATOM   1882  O   PRO B 112       3.938  -0.437  -2.411  1.00 44.49           O  
ATOM   1883  CB  PRO B 112       3.925   2.038  -0.164  1.00 50.80           C  
ATOM   1884  CG  PRO B 112       4.655   2.564   1.014  1.00 50.80           C  
ATOM   1885  CD  PRO B 112       6.095   2.448   0.562  1.00 50.80           C  
ATOM   1886  N   ASN B 113       5.429   1.191  -2.770  1.00 43.97           N  
ATOM   1887  CA  ASN B 113       5.432   0.959  -4.195  1.00 43.97           C  
ATOM   1888  C   ASN B 113       5.979  -0.427  -4.551  1.00 43.97           C  
ATOM   1889  O   ASN B 113       5.534  -1.050  -5.513  1.00 43.97           O  
ATOM   1890  CB  ASN B 113       6.241   2.047  -4.886  1.00 62.29           C  
ATOM   1891  CG  ASN B 113       6.138   1.968  -6.379  1.00 62.29           C  
ATOM   1892  OD1 ASN B 113       7.100   1.608  -7.057  1.00 62.29           O  
ATOM   1893  ND2 ASN B 113       4.958   2.288  -6.909  1.00 62.29           N  
ATOM   1894  N   MET B 114       6.949  -0.911  -3.789  1.00 33.12           N  
ATOM   1895  CA  MET B 114       7.505  -2.228  -4.055  1.00 33.12           C  
ATOM   1896  C   MET B 114       6.481  -3.303  -3.676  1.00 33.12           C  
ATOM   1897  O   MET B 114       6.414  -4.373  -4.289  1.00 33.12           O  
ATOM   1898  CB  MET B 114       8.795  -2.434  -3.257  1.00 38.04           C  
ATOM   1899  CG  MET B 114      10.023  -1.808  -3.895  1.00 38.04           C  
ATOM   1900  SD  MET B 114      11.570  -2.211  -3.031  1.00 38.04           S  
ATOM   1901  CE  MET B 114      12.036  -0.574  -2.479  1.00 38.04           C  
ATOM   1902  N   LEU B 115       5.669  -2.995  -2.672  1.00 34.31           N  
ATOM   1903  CA  LEU B 115       4.659  -3.919  -2.183  1.00 34.31           C  
ATOM   1904  C   LEU B 115       3.401  -3.979  -3.040  1.00 34.31           C  
ATOM   1905  O   LEU B 115       2.736  -5.007  -3.106  1.00 34.31           O  
ATOM   1906  CB  LEU B 115       4.263  -3.529  -0.757  1.00 35.24           C  
ATOM   1907  CG  LEU B 115       5.370  -3.573   0.300  1.00 35.24           C  
ATOM   1908  CD1 LEU B 115       4.902  -2.876   1.546  1.00 35.24           C  
ATOM   1909  CD2 LEU B 115       5.748  -5.009   0.602  1.00 35.24           C  
ATOM   1910  N   PHE B 116       3.078  -2.876  -3.696  1.00 35.80           N  
ATOM   1911  CA  PHE B 116       1.871  -2.802  -4.495  1.00 35.80           C  
ATOM   1912  C   PHE B 116       1.633  -3.960  -5.463  1.00 35.80           C  
ATOM   1913  O   PHE B 116       0.610  -4.644  -5.383  1.00 35.80           O  
ATOM   1914  CB  PHE B 116       1.843  -1.479  -5.252  1.00 37.28           C  
ATOM   1915  CG  PHE B 116       0.645  -1.309  -6.114  1.00 37.28           C  
ATOM   1916  CD1 PHE B 116      -0.606  -1.140  -5.548  1.00 37.28           C  
ATOM   1917  CD2 PHE B 116       0.765  -1.319  -7.494  1.00 37.28           C  
ATOM   1918  CE1 PHE B 116      -1.736  -0.978  -6.350  1.00 37.28           C  
ATOM   1919  CE2 PHE B 116      -0.348  -1.158  -8.304  1.00 37.28           C  
ATOM   1920  CZ  PHE B 116      -1.610  -0.986  -7.727  1.00 37.28           C  
ATOM   1921  N   PRO B 117       2.564  -4.194  -6.397  1.00 26.16           N  
ATOM   1922  CA  PRO B 117       2.300  -5.305  -7.308  1.00 26.16           C  
ATOM   1923  C   PRO B 117       1.955  -6.632  -6.618  1.00 26.16           C  
ATOM   1924  O   PRO B 117       1.174  -7.426  -7.156  1.00 26.16           O  
ATOM   1925  CB  PRO B 117       3.559  -5.351  -8.188  1.00 36.62           C  
ATOM   1926  CG  PRO B 117       4.568  -4.484  -7.479  1.00 36.62           C  
ATOM   1927  CD  PRO B 117       3.763  -3.443  -6.798  1.00 36.62           C  
ATOM   1928  N   TYR B 118       2.511  -6.868  -5.432  1.00 32.66           N  
ATOM   1929  CA  TYR B 118       2.209  -8.085  -4.690  1.00 32.66           C  
ATOM   1930  C   TYR B 118       0.751  -8.054  -4.274  1.00 32.66           C  
ATOM   1931  O   TYR B 118       0.020  -9.026  -4.441  1.00 32.66           O  
ATOM   1932  CB  TYR B 118       3.042  -8.188  -3.423  1.00 25.32           C  
ATOM   1933  CG  TYR B 118       4.484  -8.520  -3.663  1.00 25.32           C  
ATOM   1934  CD1 TYR B 118       5.440  -7.515  -3.801  1.00 25.32           C  
ATOM   1935  CD2 TYR B 118       4.890  -9.843  -3.789  1.00 25.32           C  
ATOM   1936  CE1 TYR B 118       6.776  -7.826  -4.060  1.00 25.32           C  
ATOM   1937  CE2 TYR B 118       6.205 -10.165  -4.047  1.00 25.32           C  
ATOM   1938  CZ  TYR B 118       7.148  -9.154  -4.182  1.00 25.32           C  
ATOM   1939  OH  TYR B 118       8.461  -9.486  -4.451  1.00 25.32           O  
ATOM   1940  N   ALA B 119       0.329  -6.934  -3.715  1.00 28.95           N  
ATOM   1941  CA  ALA B 119      -1.053  -6.789  -3.289  1.00 28.95           C  
ATOM   1942  C   ALA B 119      -1.996  -6.873  -4.476  1.00 28.95           C  
ATOM   1943  O   ALA B 119      -3.078  -7.462  -4.379  1.00 28.95           O  
ATOM   1944  CB  ALA B 119      -1.254  -5.452  -2.577  1.00 10.38           C  
ATOM   1945  N   ARG B 120      -1.588  -6.266  -5.589  1.00 25.58           N  
ATOM   1946  CA  ARG B 120      -2.404  -6.264  -6.791  1.00 25.58           C  
ATOM   1947  C   ARG B 120      -2.710  -7.705  -7.222  1.00 25.58           C  
ATOM   1948  O   ARG B 120      -3.868  -8.049  -7.481  1.00 25.58           O  
ATOM   1949  CB  ARG B 120      -1.683  -5.504  -7.916  1.00 31.13           C  
ATOM   1950  CG  ARG B 120      -2.624  -4.997  -8.990  1.00 31.13           C  
ATOM   1951  CD  ARG B 120      -1.937  -4.141 -10.023  1.00 31.13           C  
ATOM   1952  NE  ARG B 120      -1.091  -4.928 -10.904  1.00 31.13           N  
ATOM   1953  CZ  ARG B 120      -1.242  -5.007 -12.224  1.00 31.13           C  
ATOM   1954  NH1 ARG B 120      -2.223  -4.349 -12.822  1.00 31.13           N  
ATOM   1955  NH2 ARG B 120      -0.387  -5.722 -12.941  1.00 31.13           N  
ATOM   1956  N   GLU B 121      -1.663  -8.534  -7.270  1.00 29.65           N  
ATOM   1957  CA  GLU B 121      -1.779  -9.929  -7.674  1.00 29.65           C  
ATOM   1958  C   GLU B 121      -2.661 -10.708  -6.704  1.00 29.65           C  
ATOM   1959  O   GLU B 121      -3.376 -11.617  -7.121  1.00 29.65           O  
ATOM   1960  CB  GLU B 121      -0.376 -10.568  -7.773  1.00 32.92           C  
ATOM   1961  CG  GLU B 121      -0.346 -11.950  -8.431  1.00 32.92           C  
ATOM   1962  CD  GLU B 121      -0.847 -13.052  -7.516  1.00 32.92           C  
ATOM   1963  OE1 GLU B 121      -1.403 -14.064  -8.023  1.00 32.92           O  
ATOM   1964  OE2 GLU B 121      -0.670 -12.902  -6.281  1.00 32.92           O  
ATOM   1965  N   LEU B 122      -2.613 -10.361  -5.415  1.00 24.32           N  
ATOM   1966  CA  LEU B 122      -3.433 -11.063  -4.426  1.00 24.32           C  
ATOM   1967  C   LEU B 122      -4.886 -10.719  -4.644  1.00 24.32           C  
ATOM   1968  O   LEU B 122      -5.752 -11.589  -4.570  1.00 24.32           O  
ATOM   1969  CB  LEU B 122      -3.039 -10.714  -2.981  1.00 29.00           C  
ATOM   1970  CG  LEU B 122      -3.969 -11.349  -1.920  1.00 29.00           C  
ATOM   1971  CD1 LEU B 122      -4.087 -12.857  -2.143  1.00 29.00           C  
ATOM   1972  CD2 LEU B 122      -3.459 -11.051  -0.528  1.00 29.00           C  
ATOM   1973  N   VAL B 123      -5.161  -9.448  -4.909  1.00 33.49           N  
ATOM   1974  CA  VAL B 123      -6.532  -9.042  -5.172  1.00 33.49           C  
ATOM   1975  C   VAL B 123      -7.040  -9.731  -6.441  1.00 33.49           C  
ATOM   1976  O   VAL B 123      -8.132 -10.294  -6.440  1.00 33.49           O  
ATOM   1977  CB  VAL B 123      -6.670  -7.528  -5.378  1.00 27.46           C  
ATOM   1978  CG1 VAL B 123      -8.137  -7.189  -5.693  1.00 27.46           C  
ATOM   1979  CG2 VAL B 123      -6.185  -6.780  -4.140  1.00 27.46           C  
ATOM   1980  N   SER B 124      -6.258  -9.703  -7.518  1.00 24.81           N  
ATOM   1981  CA  SER B 124      -6.698 -10.342  -8.749  1.00 24.81           C  
ATOM   1982  C   SER B 124      -6.908 -11.853  -8.563  1.00 24.81           C  
ATOM   1983  O   SER B 124      -7.855 -12.444  -9.097  1.00 24.81           O  
ATOM   1984  CB  SER B 124      -5.708 -10.081  -9.894  1.00 27.77           C  
ATOM   1985  OG  SER B 124      -4.469 -10.713  -9.663  1.00 27.77           O  
ATOM   1986  N   ASN B 125      -6.034 -12.478  -7.794  1.00 17.27           N  
ATOM   1987  CA  ASN B 125      -6.111 -13.906  -7.563  1.00 17.27           C  
ATOM   1988  C   ASN B 125      -7.444 -14.253  -6.898  1.00 17.27           C  
ATOM   1989  O   ASN B 125      -8.188 -15.121  -7.377  1.00 17.27           O  
ATOM   1990  CB  ASN B 125      -4.937 -14.306  -6.681  1.00 22.10           C  
ATOM   1991  CG  ASN B 125      -4.641 -15.759  -6.745  1.00 22.10           C  
ATOM   1992  OD1 ASN B 125      -5.473 -16.582  -6.382  1.00 22.10           O  
ATOM   1993  ND2 ASN B 125      -3.433 -16.104  -7.213  1.00 22.10           N  
ATOM   1994  N   LEU B 126      -7.751 -13.552  -5.805  1.00 31.11           N  
ATOM   1995  CA  LEU B 126      -8.988 -13.779  -5.062  1.00 31.11           C  
ATOM   1996  C   LEU B 126     -10.249 -13.491  -5.875  1.00 31.11           C  
ATOM   1997  O   LEU B 126     -11.213 -14.256  -5.824  1.00 31.11           O  
ATOM   1998  CB  LEU B 126      -9.005 -12.929  -3.793  1.00 22.23           C  
ATOM   1999  CG  LEU B 126      -8.039 -13.391  -2.699  1.00 22.23           C  
ATOM   2000  CD1 LEU B 126      -7.768 -12.263  -1.711  1.00 22.23           C  
ATOM   2001  CD2 LEU B 126      -8.623 -14.617  -2.010  1.00 22.23           C  
ATOM   2002  N   VAL B 127     -10.256 -12.390  -6.622  1.00 24.67           N  
ATOM   2003  CA  VAL B 127     -11.433 -12.068  -7.417  1.00 24.67           C  
ATOM   2004  C   VAL B 127     -11.685 -13.162  -8.443  1.00 24.67           C  
ATOM   2005  O   VAL B 127     -12.818 -13.608  -8.612  1.00 24.67           O  
ATOM   2006  CB  VAL B 127     -11.299 -10.698  -8.107  1.00 24.87           C  
ATOM   2007  CG1 VAL B 127     -12.497 -10.440  -9.008  1.00 24.87           C  
ATOM   2008  CG2 VAL B 127     -11.228  -9.604  -7.053  1.00 24.87           C  
ATOM   2009  N   ASN B 128     -10.628 -13.617  -9.112  1.00 27.30           N  
ATOM   2010  CA  ASN B 128     -10.759 -14.682 -10.099  1.00 27.30           C  
ATOM   2011  C   ASN B 128     -11.342 -15.942  -9.439  1.00 27.30           C  
ATOM   2012  O   ASN B 128     -12.083 -16.674 -10.075  1.00 27.30           O  
ATOM   2013  CB  ASN B 128      -9.391 -14.971 -10.733  1.00 28.26           C  
ATOM   2014  CG  ASN B 128      -9.437 -16.091 -11.777  1.00 28.26           C  
ATOM   2015  OD1 ASN B 128     -10.116 -15.984 -12.804  1.00 28.26           O  
ATOM   2016  ND2 ASN B 128      -8.702 -17.168 -11.517  1.00 28.26           N  
ATOM   2017  N   ARG B 129     -11.020 -16.187  -8.170  1.00 32.27           N  
ATOM   2018  CA  ARG B 129     -11.540 -17.362  -7.489  1.00 32.27           C  
ATOM   2019  C   ARG B 129     -13.040 -17.260  -7.246  1.00 32.27           C  
ATOM   2020  O   ARG B 129     -13.706 -18.271  -7.019  1.00 32.27           O  
ATOM   2021  CB  ARG B 129     -10.792 -17.577  -6.190  1.00 18.20           C  
ATOM   2022  CG  ARG B 129      -9.363 -18.038  -6.403  1.00 18.20           C  
ATOM   2023  CD  ARG B 129      -8.602 -18.068  -5.093  1.00 18.20           C  
ATOM   2024  NE  ARG B 129      -7.208 -18.411  -5.295  1.00 18.20           N  
ATOM   2025  CZ  ARG B 129      -6.750 -19.652  -5.373  1.00 18.20           C  
ATOM   2026  NH1 ARG B 129      -7.596 -20.663  -5.256  1.00 18.20           N  
ATOM   2027  NH2 ARG B 129      -5.444 -19.876  -5.572  1.00 18.20           N  
ATOM   2028  N   GLY B 130     -13.574 -16.044  -7.299  1.00 31.52           N  
ATOM   2029  CA  GLY B 130     -15.005 -15.881  -7.129  1.00 31.52           C  
ATOM   2030  C   GLY B 130     -15.661 -15.874  -8.502  1.00 31.52           C  
ATOM   2031  O   GLY B 130     -16.850 -15.620  -8.629  1.00 31.52           O  
ATOM   2032  N   THR B 131     -14.859 -16.179  -9.525  1.00 25.63           N  
ATOM   2033  CA  THR B 131     -15.256 -16.204 -10.933  1.00 25.63           C  
ATOM   2034  C   THR B 131     -15.853 -14.891 -11.397  1.00 25.63           C  
ATOM   2035  O   THR B 131     -16.831 -14.859 -12.130  1.00 25.63           O  
ATOM   2036  CB  THR B 131     -16.240 -17.366 -11.292  1.00 24.13           C  
ATOM   2037  OG1 THR B 131     -17.481 -17.223 -10.585  1.00 24.13           O  
ATOM   2038  CG2 THR B 131     -15.607 -18.704 -10.973  1.00 24.13           C  
ATOM   2039  N   PHE B 132     -15.260 -13.795 -10.963  1.00 38.96           N  
ATOM   2040  CA  PHE B 132     -15.732 -12.494 -11.385  1.00 38.96           C  
ATOM   2041  C   PHE B 132     -14.783 -12.068 -12.484  1.00 38.96           C  
ATOM   2042  O   PHE B 132     -13.657 -12.551 -12.562  1.00 38.96           O  
ATOM   2043  CB  PHE B 132     -15.664 -11.479 -10.226  1.00 43.06           C  
ATOM   2044  CG  PHE B 132     -16.667 -11.723  -9.154  1.00 43.06           C  
ATOM   2045  CD1 PHE B 132     -16.273 -12.175  -7.916  1.00 43.06           C  
ATOM   2046  CD2 PHE B 132     -18.024 -11.551  -9.410  1.00 43.06           C  
ATOM   2047  CE1 PHE B 132     -17.211 -12.461  -6.941  1.00 43.06           C  
ATOM   2048  CE2 PHE B 132     -18.976 -11.836  -8.443  1.00 43.06           C  
ATOM   2049  CZ  PHE B 132     -18.571 -12.293  -7.205  1.00 43.06           C  
ATOM   2050  N   PRO B 133     -15.226 -11.178 -13.370  1.00 24.13           N  
ATOM   2051  CA  PRO B 133     -14.282 -10.774 -14.411  1.00 24.13           C  
ATOM   2052  C   PRO B 133     -13.031 -10.099 -13.811  1.00 24.13           C  
ATOM   2053  O   PRO B 133     -13.106  -9.375 -12.821  1.00 24.13           O  
ATOM   2054  CB  PRO B 133     -15.121  -9.850 -15.302  1.00 25.79           C  
ATOM   2055  CG  PRO B 133     -16.230  -9.396 -14.419  1.00 25.79           C  
ATOM   2056  CD  PRO B 133     -16.554 -10.583 -13.577  1.00 25.79           C  
ATOM   2057  N   ALA B 134     -11.880 -10.364 -14.415  1.00 37.85           N  
ATOM   2058  CA  ALA B 134     -10.595  -9.816 -13.969  1.00 37.85           C  
ATOM   2059  C   ALA B 134     -10.594  -8.391 -13.422  1.00 37.85           C  
ATOM   2060  O   ALA B 134     -11.234  -7.509 -13.972  1.00 37.85           O  
ATOM   2061  CB  ALA B 134      -9.580  -9.903 -15.104  1.00 43.04           C  
ATOM   2062  N   LEU B 135      -9.869  -8.183 -12.326  1.00 44.92           N  
ATOM   2063  CA  LEU B 135      -9.718  -6.863 -11.727  1.00 44.92           C  
ATOM   2064  C   LEU B 135      -8.257  -6.677 -11.401  1.00 44.92           C  
ATOM   2065  O   LEU B 135      -7.748  -7.230 -10.426  1.00 44.92           O  
ATOM   2066  CB  LEU B 135     -10.528  -6.705 -10.441  1.00 21.73           C  
ATOM   2067  CG  LEU B 135     -10.215  -5.435  -9.618  1.00 21.73           C  
ATOM   2068  CD1 LEU B 135     -10.529  -4.155 -10.425  1.00 21.73           C  
ATOM   2069  CD2 LEU B 135     -11.042  -5.448  -8.324  1.00 21.73           C  
ATOM   2070  N   ASN B 136      -7.574  -5.909 -12.238  1.00 35.33           N  
ATOM   2071  CA  ASN B 136      -6.167  -5.635 -12.011  1.00 35.33           C  
ATOM   2072  C   ASN B 136      -6.052  -4.172 -11.652  1.00 35.33           C  
ATOM   2073  O   ASN B 136      -6.128  -3.305 -12.528  1.00 35.33           O  
ATOM   2074  CB  ASN B 136      -5.345  -5.926 -13.259  1.00 43.71           C  
ATOM   2075  CG  ASN B 136      -5.418  -7.366 -13.664  1.00 43.71           C  
ATOM   2076  OD1 ASN B 136      -5.235  -8.259 -12.841  1.00 43.71           O  
ATOM   2077  ND2 ASN B 136      -5.680  -7.610 -14.936  1.00 43.71           N  
ATOM   2078  N   LEU B 137      -5.887  -3.900 -10.360  1.00 33.13           N  
ATOM   2079  CA  LEU B 137      -5.765  -2.528  -9.877  1.00 33.13           C  
ATOM   2080  C   LEU B 137      -4.805  -1.695 -10.717  1.00 33.13           C  
ATOM   2081  O   LEU B 137      -3.710  -2.137 -11.050  1.00 33.13           O  
ATOM   2082  CB  LEU B 137      -5.310  -2.519  -8.418  1.00 34.58           C  
ATOM   2083  CG  LEU B 137      -6.373  -2.969  -7.416  1.00 34.58           C  
ATOM   2084  CD1 LEU B 137      -5.803  -2.985  -6.007  1.00 34.58           C  
ATOM   2085  CD2 LEU B 137      -7.560  -2.049  -7.508  1.00 34.58           C  
ATOM   2086  N   SER B 138      -5.234  -0.490 -11.073  1.00 43.35           N  
ATOM   2087  CA  SER B 138      -4.407   0.414 -11.865  1.00 43.35           C  
ATOM   2088  C   SER B 138      -3.235   0.901 -11.031  1.00 43.35           C  
ATOM   2089  O   SER B 138      -3.326   0.981  -9.809  1.00 43.35           O  
ATOM   2090  CB  SER B 138      -5.215   1.631 -12.320  1.00 46.70           C  
ATOM   2091  OG  SER B 138      -6.205   1.275 -13.261  1.00 46.70           O  
ATOM   2092  N   PRO B 139      -2.123   1.251 -11.687  1.00 42.64           N  
ATOM   2093  CA  PRO B 139      -0.924   1.739 -11.002  1.00 42.64           C  
ATOM   2094  C   PRO B 139      -1.246   2.890 -10.052  1.00 42.64           C  
ATOM   2095  O   PRO B 139      -2.085   3.739 -10.352  1.00 42.64           O  
ATOM   2096  CB  PRO B 139      -0.030   2.180 -12.155  1.00 44.29           C  
ATOM   2097  CG  PRO B 139      -0.407   1.224 -13.249  1.00 44.29           C  
ATOM   2098  CD  PRO B 139      -1.919   1.223 -13.143  1.00 44.29           C  
ATOM   2099  N   VAL B 140      -0.584   2.904  -8.901  1.00 56.39           N  
ATOM   2100  CA  VAL B 140      -0.792   3.955  -7.916  1.00 56.39           C  
ATOM   2101  C   VAL B 140       0.465   4.800  -7.822  1.00 56.39           C  
ATOM   2102  O   VAL B 140       1.570   4.273  -7.703  1.00 56.39           O  
ATOM   2103  CB  VAL B 140      -1.101   3.370  -6.530  1.00 42.16           C  
ATOM   2104  CG1 VAL B 140      -1.147   4.490  -5.494  1.00 42.16           C  
ATOM   2105  CG2 VAL B 140      -2.428   2.620  -6.569  1.00 42.16           C  
ATOM   2106  N   ASN B 141       0.290   6.113  -7.918  1.00 70.15           N  
ATOM   2107  CA  ASN B 141       1.405   7.043  -7.825  1.00 70.15           C  
ATOM   2108  C   ASN B 141       1.537   7.365  -6.343  1.00 70.15           C  
ATOM   2109  O   ASN B 141       0.827   8.232  -5.827  1.00 70.15           O  
ATOM   2110  CB  ASN B 141       1.096   8.314  -8.619  1.00 92.77           C  
ATOM   2111  CG  ASN B 141       2.312   9.204  -8.790  1.00 92.77           C  
ATOM   2112  OD1 ASN B 141       2.891   9.684  -7.814  1.00 92.77           O  
ATOM   2113  ND2 ASN B 141       2.708   9.427 -10.038  1.00 92.77           N  
ATOM   2114  N   PHE B 142       2.435   6.657  -5.658  1.00 82.98           N  
ATOM   2115  CA  PHE B 142       2.625   6.850  -4.225  1.00 82.98           C  
ATOM   2116  C   PHE B 142       3.248   8.175  -3.815  1.00 82.98           C  
ATOM   2117  O   PHE B 142       3.229   8.524  -2.635  1.00 82.98           O  
ATOM   2118  CB  PHE B 142       3.449   5.702  -3.631  1.00 54.63           C  
ATOM   2119  CG  PHE B 142       2.707   4.404  -3.554  1.00 54.63           C  
ATOM   2120  CD1 PHE B 142       2.804   3.464  -4.583  1.00 54.63           C  
ATOM   2121  CD2 PHE B 142       1.879   4.128  -2.468  1.00 54.63           C  
ATOM   2122  CE1 PHE B 142       2.088   2.272  -4.537  1.00 54.63           C  
ATOM   2123  CE2 PHE B 142       1.156   2.936  -2.412  1.00 54.63           C  
ATOM   2124  CZ  PHE B 142       1.263   2.008  -3.450  1.00 54.63           C  
ATOM   2125  N   ASP B 143       3.809   8.913  -4.768  1.00 93.28           N  
ATOM   2126  CA  ASP B 143       4.401  10.203  -4.432  1.00 93.28           C  
ATOM   2127  C   ASP B 143       3.289  11.158  -4.005  1.00 93.28           C  
ATOM   2128  O   ASP B 143       3.521  12.096  -3.242  1.00 93.28           O  
ATOM   2129  CB  ASP B 143       5.182  10.775  -5.618  1.00 58.95           C  
ATOM   2130  CG  ASP B 143       6.425   9.966  -5.944  1.00 58.95           C  
ATOM   2131  OD1 ASP B 143       7.238   9.724  -5.029  1.00 58.95           O  
ATOM   2132  OD2 ASP B 143       6.596   9.572  -7.116  1.00 58.95           O  
ATOM   2133  N   ALA B 144       2.078  10.909  -4.494  1.00154.65           N  
ATOM   2134  CA  ALA B 144       0.937  11.736  -4.126  1.00154.65           C  
ATOM   2135  C   ALA B 144       0.719  11.524  -2.634  1.00154.65           C  
ATOM   2136  O   ALA B 144       0.332  12.443  -1.915  1.00154.65           O  
ATOM   2137  CB  ALA B 144      -0.307  11.314  -4.906  1.00 73.98           C  
ATOM   2138  N   LEU B 145       0.983  10.300  -2.181  1.00112.19           N  
ATOM   2139  CA  LEU B 145       0.829   9.943  -0.772  1.00112.19           C  
ATOM   2140  C   LEU B 145       1.977  10.472   0.083  1.00112.19           C  
ATOM   2141  O   LEU B 145       1.901  10.449   1.311  1.00112.19           O  
ATOM   2142  CB  LEU B 145       0.747   8.421  -0.597  1.00101.36           C  
ATOM   2143  CG  LEU B 145      -0.497   7.638  -1.028  1.00101.36           C  
ATOM   2144  CD1 LEU B 145      -0.270   6.171  -0.692  1.00101.36           C  
ATOM   2145  CD2 LEU B 145      -1.750   8.154  -0.319  1.00101.36           C  
ATOM   2146  N   PHE B 146       3.044  10.932  -0.563  1.00165.09           N  
ATOM   2147  CA  PHE B 146       4.193  11.470   0.158  1.00165.09           C  
ATOM   2148  C   PHE B 146       3.946  12.942   0.454  1.00165.09           C  
ATOM   2149  O   PHE B 146       4.170  13.411   1.570  1.00165.09           O  
ATOM   2150  CB  PHE B 146       5.472  11.319  -0.673  1.00 84.08           C  
ATOM   2151  CG  PHE B 146       6.685  11.952  -0.043  1.00 84.08           C  
ATOM   2152  CD1 PHE B 146       7.091  11.586   1.237  1.00 84.08           C  
ATOM   2153  CD2 PHE B 146       7.416  12.916  -0.729  1.00 84.08           C  
ATOM   2154  CE1 PHE B 146       8.205  12.169   1.823  1.00 84.08           C  
ATOM   2155  CE2 PHE B 146       8.534  13.505  -0.151  1.00 84.08           C  
ATOM   2156  CZ  PHE B 146       8.929  13.131   1.129  1.00 84.08           C  
ATOM   2157  N   VAL B 147       3.481  13.661  -0.561  1.00130.93           N  
ATOM   2158  CA  VAL B 147       3.185  15.079  -0.434  1.00130.93           C  
ATOM   2159  C   VAL B 147       2.176  15.301   0.691  1.00130.93           C  
ATOM   2160  O   VAL B 147       2.270  16.273   1.438  1.00130.93           O  
ATOM   2161  CB  VAL B 147       2.622  15.632  -1.757  1.00 77.53           C  
ATOM   2162  CG1 VAL B 147       2.219  17.073  -1.589  1.00 77.53           C  
ATOM   2163  CG2 VAL B 147       3.668  15.498  -2.856  1.00 77.53           C  
ATOM   2164  N   GLU B 148       1.220  14.386   0.810  1.00120.14           N  
ATOM   2165  CA  GLU B 148       0.196  14.465   1.845  1.00120.14           C  
ATOM   2166  C   GLU B 148       0.808  14.239   3.224  1.00120.14           C  
ATOM   2167  O   GLU B 148       0.491  14.950   4.176  1.00120.14           O  
ATOM   2168  CB  GLU B 148      -0.880  13.406   1.608  1.00137.53           C  
ATOM   2169  CG  GLU B 148      -1.594  13.515   0.277  1.00137.53           C  
ATOM   2170  CD  GLU B 148      -2.484  12.316   0.010  1.00137.53           C  
ATOM   2171  OE1 GLU B 148      -3.361  12.027   0.852  1.00137.53           O  
ATOM   2172  OE2 GLU B 148      -2.306  11.661  -1.038  1.00137.53           O  
ATOM   2173  N   TYR B 149       1.681  13.242   3.321  1.00114.69           N  
ATOM   2174  CA  TYR B 149       2.338  12.906   4.580  1.00114.69           C  
ATOM   2175  C   TYR B 149       3.182  14.041   5.139  1.00114.69           C  
ATOM   2176  O   TYR B 149       3.207  14.265   6.348  1.00114.69           O  
ATOM   2177  CB  TYR B 149       3.244  11.690   4.403  1.00 97.45           C  
ATOM   2178  CG  TYR B 149       4.001  11.318   5.660  1.00 97.45           C  
ATOM   2179  CD1 TYR B 149       3.367  10.648   6.706  1.00 97.45           C  
ATOM   2180  CD2 TYR B 149       5.351  11.647   5.810  1.00 97.45           C  
ATOM   2181  CE1 TYR B 149       4.053  10.309   7.871  1.00 97.45           C  
ATOM   2182  CE2 TYR B 149       6.049  11.314   6.973  1.00 97.45           C  
ATOM   2183  CZ  TYR B 149       5.392  10.643   8.000  1.00 97.45           C  
ATOM   2184  OH  TYR B 149       6.067  10.299   9.152  1.00 97.45           O  
ATOM   2185  N   MET B 150       3.888  14.743   4.260  1.00162.57           N  
ATOM   2186  CA  MET B 150       4.745  15.843   4.678  1.00162.57           C  
ATOM   2187  C   MET B 150       4.001  16.933   5.439  1.00162.57           C  
ATOM   2188  O   MET B 150       4.447  17.377   6.500  1.00162.57           O  
ATOM   2189  CB  MET B 150       5.452  16.447   3.462  1.00115.66           C  
ATOM   2190  CG  MET B 150       6.456  15.505   2.830  1.00115.66           C  
ATOM   2191  SD  MET B 150       7.608  14.859   4.061  1.00115.66           S  
ATOM   2192  CE  MET B 150       8.944  16.008   3.899  1.00115.66           C  
ATOM   2193  N   ASN B 151       2.864  17.363   4.902  1.00142.28           N  
ATOM   2194  CA  ASN B 151       2.080  18.407   5.544  1.00142.28           C  
ATOM   2195  C   ASN B 151       1.527  17.924   6.880  1.00142.28           C  
ATOM   2196  O   ASN B 151       1.998  18.415   7.929  1.00142.28           O  
ATOM   2197  CB  ASN B 151       0.933  18.829   4.628  1.00100.67           C  
ATOM   2198  CG  ASN B 151       1.388  19.062   3.202  1.00100.67           C  
ATOM   2199  OD1 ASN B 151       2.365  19.771   2.955  1.00100.67           O  
ATOM   2200  ND2 ASN B 151       0.678  18.467   2.254  1.00100.67           N  
TER    2201      ASN B 151                                                      
END
MOLECULE T0482_7_107.pdb
EXPDTA     NMR, 20 STRUCTURES
ATOM     97  N   PRO A   7      -1.524  11.209   1.755  1.00  0.00           N 
ATOM     98  CA  PRO A   7      -0.374  10.698   2.544  1.00  0.00           C 
ATOM     99  C   PRO A   7      -0.850   9.805   3.722  1.00  0.00           C 
ATOM    100  O   PRO A   7      -1.278  10.304   4.769  1.00  0.00           O 
ATOM    101  CB  PRO A   7       0.357  11.990   3.010  1.00  0.00           C 
ATOM    102  CG  PRO A   7      -0.693  13.067   2.965  1.00  0.00           C 
ATOM    103  CD  PRO A   7      -1.639  12.691   1.839  1.00  0.00           C 
ATOM    104  HA  PRO A   7       0.295  10.112   1.912  1.00  0.00           H 
ATOM    105 2HB  PRO A   7       1.175  12.209   2.329  1.00  0.00           H 
ATOM    106 1HB  PRO A   7       0.755  11.857   4.011  1.00  0.00           H 
ATOM    107 2HG  PRO A   7      -0.229  14.028   2.770  1.00  0.00           H 
ATOM    108 1HG  PRO A   7      -1.226  13.101   3.913  1.00  0.00           H 
ATOM    109 2HD  PRO A   7      -1.329  13.151   0.907  1.00  0.00           H 
ATOM    110 1HD  PRO A   7      -2.654  12.988   2.079  1.00  0.00           H 
ATOM    111  N   GLY A   8      -0.828   8.476   3.495  1.00  0.00           N 
ATOM    112  CA  GLY A   8      -1.248   7.480   4.493  1.00  0.00           C 
ATOM    113  C   GLY A   8      -2.274   6.471   3.961  1.00  0.00           C 
ATOM    114  O   GLY A   8      -2.481   5.419   4.582  1.00  0.00           O 
ATOM    115  H   GLY A   8      -0.501   8.160   2.624  1.00  0.00           H 
ATOM    116 2HA  GLY A   8      -1.674   7.981   5.357  1.00  0.00           H 
ATOM    117 1HA  GLY A   8      -0.369   6.938   4.816  1.00  0.00           H 
ATOM    118  N   HIS A   9      -2.906   6.777   2.799  1.00  0.00           N 
ATOM    119  CA  HIS A   9      -4.036   5.976   2.252  1.00  0.00           C 
ATOM    120  C   HIS A   9      -4.258   6.233   0.734  1.00  0.00           C 
ATOM    121  O   HIS A   9      -3.912   7.285   0.219  1.00  0.00           O 
ATOM    122  CB  HIS A   9      -5.320   6.285   3.075  1.00  0.00           C 
ATOM    123  CG  HIS A   9      -6.600   5.708   2.529  1.00  0.00           C 
ATOM    124  ND1 HIS A   9      -7.504   6.454   1.813  1.00  0.00           N 
ATOM    125  CD2 HIS A   9      -7.111   4.456   2.576  1.00  0.00           C 
ATOM    126  CE1 HIS A   9      -8.507   5.700   1.449  1.00  0.00           C 
ATOM    127  NE2 HIS A   9      -8.304   4.476   1.894  1.00  0.00           N 
ATOM    128  H   HIS A   9      -2.612   7.568   2.302  1.00  0.00           H 
ATOM    129  HA  HIS A   9      -3.784   4.925   2.378  1.00  0.00           H 
ATOM    130 2HB  HIS A   9      -5.440   7.359   3.139  1.00  0.00           H 
ATOM    131 1HB  HIS A   9      -5.194   5.897   4.079  1.00  0.00           H 
ATOM    132  HD1 HIS A   9      -7.432   7.415   1.622  1.00  0.00           H 
ATOM    133  HD2 HIS A   9      -6.669   3.600   3.069  1.00  0.00           H 
ATOM    134  HE1 HIS A   9      -9.362   6.027   0.875  1.00  0.00           H 
ATOM    135  HE2 HIS A   9      -9.027   3.830   2.038  1.00  0.00           H 
ATOM    136  N   LEU A  10      -4.830   5.233   0.035  1.00  0.00           N 
ATOM    137  CA  LEU A  10      -5.185   5.300  -1.392  1.00  0.00           C 
ATOM    138  C   LEU A  10      -6.605   4.693  -1.551  1.00  0.00           C 
ATOM    139  O   LEU A  10      -6.861   3.572  -1.112  1.00  0.00           O 
ATOM    140  CB  LEU A  10      -4.118   4.513  -2.232  1.00  0.00           C 
ATOM    141  CG  LEU A  10      -3.964   4.864  -3.759  1.00  0.00           C 
ATOM    142  CD1 LEU A  10      -2.752   4.129  -4.371  1.00  0.00           C 
ATOM    143  CD2 LEU A  10      -5.232   4.548  -4.578  1.00  0.00           C 
ATOM    144  H   LEU A  10      -5.018   4.397   0.485  1.00  0.00           H 
ATOM    145  HA  LEU A  10      -5.199   6.343  -1.700  1.00  0.00           H 
ATOM    146 2HB  LEU A  10      -4.344   3.454  -2.152  1.00  0.00           H 
ATOM    147 1HB  LEU A  10      -3.151   4.673  -1.763  1.00  0.00           H 
ATOM    148  HG  LEU A  10      -3.771   5.929  -3.848  1.00  0.00           H 
ATOM    149 1HD1 LEU A  10      -1.853   4.401  -3.832  1.00  0.00           H 
ATOM    150 2HD1 LEU A  10      -2.633   4.414  -5.410  1.00  0.00           H 
ATOM    151 3HD1 LEU A  10      -2.899   3.060  -4.308  1.00  0.00           H 
ATOM    152 1HD2 LEU A  10      -5.076   4.802  -5.618  1.00  0.00           H 
ATOM    153 2HD2 LEU A  10      -6.065   5.124  -4.196  1.00  0.00           H 
ATOM    154 3HD2 LEU A  10      -5.468   3.492  -4.500  1.00  0.00           H 
ATOM    155  N   HIS A  11      -7.521   5.455  -2.162  1.00  0.00           N 
ATOM    156  CA  HIS A  11      -8.909   5.023  -2.451  1.00  0.00           C 
ATOM    157  C   HIS A  11      -9.022   4.538  -3.915  1.00  0.00           C 
ATOM    158  O   HIS A  11      -8.440   5.144  -4.808  1.00  0.00           O 
ATOM    159  CB  HIS A  11      -9.859   6.222  -2.187  1.00  0.00           C 
ATOM    160  CG  HIS A  11     -11.311   6.011  -2.554  1.00  0.00           C 
ATOM    161  ND1 HIS A  11     -12.115   7.025  -3.033  1.00  0.00           N 
ATOM    162  CD2 HIS A  11     -12.106   4.912  -2.473  1.00  0.00           C 
ATOM    163  CE1 HIS A  11     -13.331   6.558  -3.230  1.00  0.00           C 
ATOM    164  NE2 HIS A  11     -13.352   5.285  -2.896  1.00  0.00           N 
ATOM    165  H   HIS A  11      -7.258   6.357  -2.423  1.00  0.00           H 
ATOM    166  HA  HIS A  11      -9.168   4.208  -1.778  1.00  0.00           H 
ATOM    167 2HB  HIS A  11      -9.500   7.080  -2.747  1.00  0.00           H 
ATOM    168 1HB  HIS A  11      -9.827   6.467  -1.132  1.00  0.00           H 
ATOM    169  HD1 HIS A  11     -11.837   7.951  -3.202  1.00  0.00           H 
ATOM    170  HD2 HIS A  11     -11.792   3.914  -2.187  1.00  0.00           H 
ATOM    171  HE1 HIS A  11     -14.169   7.125  -3.598  1.00  0.00           H 
ATOM    172  HE2 HIS A  11     -14.164   4.745  -2.804  1.00  0.00           H 
ATOM    173  N   LEU A  12      -9.781   3.446  -4.141  1.00  0.00           N 
ATOM    174  CA  LEU A  12      -9.995   2.857  -5.482  1.00  0.00           C 
ATOM    175  C   LEU A  12     -11.490   2.576  -5.724  1.00  0.00           C 
ATOM    176  O   LEU A  12     -12.110   1.830  -4.975  1.00  0.00           O 
ATOM    177  CB  LEU A  12      -9.193   1.535  -5.642  1.00  0.00           C 
ATOM    178  CG  LEU A  12      -7.639   1.670  -5.707  1.00  0.00           C 
ATOM    179  CD1 LEU A  12      -6.956   0.282  -5.754  1.00  0.00           C 
ATOM    180  CD2 LEU A  12      -7.218   2.547  -6.912  1.00  0.00           C 
ATOM    181  H   LEU A  12     -10.225   3.025  -3.380  1.00  0.00           H 
ATOM    182  HA  LEU A  12      -9.648   3.566  -6.232  1.00  0.00           H 
ATOM    183 2HB  LEU A  12      -9.523   1.038  -6.552  1.00  0.00           H 
ATOM    184 1HB  LEU A  12      -9.444   0.894  -4.804  1.00  0.00           H 
ATOM    185  HG  LEU A  12      -7.294   2.168  -4.805  1.00  0.00           H 
ATOM    186 1HD1 LEU A  12      -7.273  -0.256  -6.639  1.00  0.00           H 
ATOM    187 2HD1 LEU A  12      -7.230  -0.289  -4.875  1.00  0.00           H 
ATOM    188 3HD1 LEU A  12      -5.881   0.403  -5.771  1.00  0.00           H 
ATOM    189 1HD2 LEU A  12      -7.556   2.093  -7.836  1.00  0.00           H 
ATOM    190 2HD2 LEU A  12      -6.140   2.646  -6.937  1.00  0.00           H 
ATOM    191 3HD2 LEU A  12      -7.659   3.531  -6.817  1.00  0.00           H 
ATOM    192  N   VAL A  13     -12.051   3.244  -6.737  1.00  0.00           N 
ATOM    193  CA  VAL A  13     -13.336   2.894  -7.399  1.00  0.00           C 
ATOM    194  C   VAL A  13     -13.076   3.039  -8.916  1.00  0.00           C 
ATOM    195  O   VAL A  13     -12.109   3.725  -9.296  1.00  0.00           O 
ATOM    196  CB  VAL A  13     -14.527   3.828  -6.930  1.00  0.00           C 
ATOM    197  CG1 VAL A  13     -15.858   3.513  -7.660  1.00  0.00           C 
ATOM    198  CG2 VAL A  13     -14.735   3.741  -5.402  1.00  0.00           C 
ATOM    199  H   VAL A  13     -11.580   4.036  -7.069  1.00  0.00           H 
ATOM    200  HA  VAL A  13     -13.578   1.856  -7.176  1.00  0.00           H 
ATOM    201  HB  VAL A  13     -14.255   4.855  -7.166  1.00  0.00           H 
ATOM    202 1HG1 VAL A  13     -15.729   3.647  -8.725  1.00  0.00           H 
ATOM    203 2HG1 VAL A  13     -16.639   4.177  -7.311  1.00  0.00           H 
ATOM    204 3HG1 VAL A  13     -16.149   2.486  -7.461  1.00  0.00           H 
ATOM    205 1HG2 VAL A  13     -15.544   4.398  -5.098  1.00  0.00           H 
ATOM    206 2HG2 VAL A  13     -13.829   4.040  -4.895  1.00  0.00           H 
ATOM    207 3HG2 VAL A  13     -14.981   2.723  -5.124  1.00  0.00           H 
ATOM    208  N   SER A  14     -13.897   2.435  -9.805  1.00  0.00           N 
ATOM    209  CA  SER A  14     -13.634   2.491 -11.249  1.00  0.00           C 
ATOM    210  C   SER A  14     -14.392   3.701 -11.809  1.00  0.00           C 
ATOM    211  O   SER A  14     -15.602   3.825 -11.575  1.00  0.00           O 
ATOM    212  CB  SER A  14     -14.108   1.193 -11.941  1.00  0.00           C 
ATOM    213  OG  SER A  14     -13.741   1.176 -13.314  1.00  0.00           O 
ATOM    214  H   SER A  14     -14.777   2.087  -9.568  1.00  0.00           H 
ATOM    215  HA  SER A  14     -12.561   2.613 -11.412  1.00  0.00           H 
ATOM    216 2HB  SER A  14     -15.188   1.105 -11.864  1.00  0.00           H 
ATOM    217 1HB  SER A  14     -13.651   0.341 -11.457  1.00  0.00           H 
ATOM    218  HG  SER A  14     -14.208   0.462 -13.761  1.00  0.00           H 
ATOM    219  N   LEU A  15     -13.686   4.605 -12.504  1.00  0.00           N 
ATOM    220  CA  LEU A  15     -14.301   5.816 -13.070  1.00  0.00           C 
ATOM    221  C   LEU A  15     -15.236   5.433 -14.251  1.00  0.00           C 
ATOM    222  O   LEU A  15     -14.894   4.533 -15.035  1.00  0.00           O 
ATOM    223  CB  LEU A  15     -13.192   6.848 -13.458  1.00  0.00           C 
ATOM    224  CG  LEU A  15     -12.126   6.418 -14.537  1.00  0.00           C 
ATOM    225  CD1 LEU A  15     -12.578   6.764 -15.978  1.00  0.00           C 
ATOM    226  CD2 LEU A  15     -10.733   7.029 -14.237  1.00  0.00           C 
ATOM    227  H   LEU A  15     -12.733   4.445 -12.654  1.00  0.00           H 
ATOM    228  HA  LEU A  15     -14.911   6.258 -12.283  1.00  0.00           H 
ATOM    229 2HB  LEU A  15     -12.665   7.103 -12.541  1.00  0.00           H 
ATOM    230 1HB  LEU A  15     -13.685   7.754 -13.803  1.00  0.00           H 
ATOM    231  HG  LEU A  15     -12.016   5.339 -14.497  1.00  0.00           H 
ATOM    232 1HD1 LEU A  15     -11.837   6.415 -16.690  1.00  0.00           H 
ATOM    233 2HD1 LEU A  15     -12.689   7.836 -16.077  1.00  0.00           H 
ATOM    234 3HD1 LEU A  15     -13.525   6.286 -16.189  1.00  0.00           H 
ATOM    235 1HD2 LEU A  15     -10.023   6.705 -14.987  1.00  0.00           H 
ATOM    236 2HD2 LEU A  15     -10.392   6.700 -13.265  1.00  0.00           H 
ATOM    237 3HD2 LEU A  15     -10.795   8.111 -14.245  1.00  0.00           H 
ATOM    238  N   PRO A  16     -16.448   6.073 -14.363  1.00  0.00           N 
ATOM    239  CA  PRO A  16     -17.434   5.743 -15.418  1.00  0.00           C 
ATOM    240  C   PRO A  16     -16.866   5.982 -16.835  1.00  0.00           C 
ATOM    241  O   PRO A  16     -16.247   7.022 -17.106  1.00  0.00           O 
ATOM    242  CB  PRO A  16     -18.642   6.673 -15.098  1.00  0.00           C 
ATOM    243  CG  PRO A  16     -18.065   7.780 -14.273  1.00  0.00           C 
ATOM    244  CD  PRO A  16     -16.955   7.147 -13.467  1.00  0.00           C 
ATOM    245  HA  PRO A  16     -17.746   4.703 -15.334  1.00  0.00           H 
ATOM    246 2HB  PRO A  16     -19.388   6.117 -14.538  1.00  0.00           H 
ATOM    247 1HB  PRO A  16     -19.093   7.050 -16.012  1.00  0.00           H 
ATOM    248 2HG  PRO A  16     -18.825   8.194 -13.618  1.00  0.00           H 
ATOM    249 1HG  PRO A  16     -17.668   8.564 -14.918  1.00  0.00           H 
ATOM    250 2HD  PRO A  16     -17.337   6.725 -12.541  1.00  0.00           H 
ATOM    251 1HD  PRO A  16     -16.180   7.876 -13.251  1.00  0.00           H 
ATOM    252  N   GLY A  17     -17.074   4.995 -17.717  1.00  0.00           N 
ATOM    253  CA  GLY A  17     -16.491   4.985 -19.061  1.00  0.00           C 
ATOM    254  C   GLY A  17     -15.361   3.967 -19.184  1.00  0.00           C 
ATOM    255  O   GLY A  17     -15.148   3.398 -20.260  1.00  0.00           O 
ATOM    256  H   GLY A  17     -17.649   4.248 -17.447  1.00  0.00           H 
ATOM    257 2HA  GLY A  17     -16.104   5.969 -19.310  1.00  0.00           H 
ATOM    258 1HA  GLY A  17     -17.269   4.735 -19.770  1.00  0.00           H 
ATOM    259  N   LEU A  18     -14.629   3.741 -18.070  1.00  0.00           N 
ATOM    260  CA  LEU A  18     -13.489   2.804 -18.026  1.00  0.00           C 
ATOM    261  C   LEU A  18     -13.995   1.352 -17.944  1.00  0.00           C 
ATOM    262  O   LEU A  18     -13.786   0.564 -18.878  1.00  0.00           O 
ATOM    263  CB  LEU A  18     -12.565   3.146 -16.822  1.00  0.00           C 
ATOM    264  CG  LEU A  18     -11.286   2.264 -16.636  1.00  0.00           C 
ATOM    265  CD1 LEU A  18     -10.365   2.318 -17.878  1.00  0.00           C 
ATOM    266  CD2 LEU A  18     -10.522   2.674 -15.355  1.00  0.00           C 
ATOM    267  H   LEU A  18     -14.867   4.225 -17.248  1.00  0.00           H 
ATOM    268  HA  LEU A  18     -12.918   2.926 -18.946  1.00  0.00           H 
ATOM    269 2HB  LEU A  18     -13.161   3.074 -15.917  1.00  0.00           H 
ATOM    270 1HB  LEU A  18     -12.248   4.180 -16.929  1.00  0.00           H 
ATOM    271  HG  LEU A  18     -11.593   1.231 -16.512  1.00  0.00           H 
ATOM    272 1HD1 LEU A  18     -10.893   1.940 -18.743  1.00  0.00           H 
ATOM    273 2HD1 LEU A  18      -9.487   1.707 -17.708  1.00  0.00           H 
ATOM    274 3HD1 LEU A  18     -10.055   3.340 -18.066  1.00  0.00           H 
ATOM    275 1HD2 LEU A  18      -9.649   2.044 -15.234  1.00  0.00           H 
ATOM    276 2HD2 LEU A  18     -11.164   2.554 -14.491  1.00  0.00           H 
ATOM    277 3HD2 LEU A  18     -10.209   3.709 -15.426  1.00  0.00           H 
ATOM    278  N   ASP A  19     -14.673   1.023 -16.827  1.00  0.00           N 
ATOM    279  CA  ASP A  19     -15.207  -0.327 -16.570  1.00  0.00           C 
ATOM    280  C   ASP A  19     -16.367  -0.235 -15.566  1.00  0.00           C 
ATOM    281  O   ASP A  19     -16.154   0.074 -14.392  1.00  0.00           O 
ATOM    282  CB  ASP A  19     -14.083  -1.273 -16.043  1.00  0.00           C 
ATOM    283  CG  ASP A  19     -14.572  -2.707 -15.753  1.00  0.00           C 
ATOM    284  OD1 ASP A  19     -15.077  -3.371 -16.683  1.00  0.00           O 
ATOM    285  OD2 ASP A  19     -14.447  -3.184 -14.604  1.00  0.00           O 
ATOM    286  H   ASP A  19     -14.821   1.715 -16.146  1.00  0.00           H 
ATOM    287  HA  ASP A  19     -15.589  -0.725 -17.509  1.00  0.00           H 
ATOM    288 2HB  ASP A  19     -13.666  -0.849 -15.135  1.00  0.00           H 
ATOM    289 1HB  ASP A  19     -13.293  -1.330 -16.787  1.00  0.00           H 
ATOM    290  N   GLN A  20     -17.601  -0.473 -16.047  1.00  0.00           N 
ATOM    291  CA  GLN A  20     -18.811  -0.441 -15.212  1.00  0.00           C 
ATOM    292  C   GLN A  20     -18.952  -1.771 -14.446  1.00  0.00           C 
ATOM    293  O   GLN A  20     -19.638  -2.702 -14.884  1.00  0.00           O 
ATOM    294  CB  GLN A  20     -20.082  -0.121 -16.069  1.00  0.00           C 
ATOM    295  CG  GLN A  20     -20.203   1.352 -16.540  1.00  0.00           C 
ATOM    296  CD  GLN A  20     -19.119   1.782 -17.538  1.00  0.00           C 
ATOM    297  OE1 GLN A  20     -18.051   2.270 -17.156  1.00  0.00           O 
ATOM    298  NE2 GLN A  20     -19.390   1.619 -18.824  1.00  0.00           N 
ATOM    299  H   GLN A  20     -17.698  -0.678 -16.999  1.00  0.00           H 
ATOM    300  HA  GLN A  20     -18.685   0.360 -14.482  1.00  0.00           H 
ATOM    301 2HB  GLN A  20     -20.964  -0.349 -15.480  1.00  0.00           H 
ATOM    302 1HB  GLN A  20     -20.085  -0.758 -16.947  1.00  0.00           H 
ATOM    303 2HG  GLN A  20     -20.148   1.997 -15.673  1.00  0.00           H 
ATOM    304 1HG  GLN A  20     -21.173   1.487 -17.008  1.00  0.00           H 
ATOM    305 2HE2 GLN A  20     -20.256   1.233 -19.070  1.00  0.00           H 
ATOM    306 1HE2 GLN A  20     -18.712   1.891 -19.479  1.00  0.00           H 
ATOM    307  N   GLN A  21     -18.229  -1.843 -13.323  1.00  0.00           N 
ATOM    308  CA  GLN A  21     -18.253  -2.971 -12.386  1.00  0.00           C 
ATOM    309  C   GLN A  21     -18.057  -2.406 -10.977  1.00  0.00           C 
ATOM    310  O   GLN A  21     -17.362  -1.389 -10.806  1.00  0.00           O 
ATOM    311  CB  GLN A  21     -17.137  -3.996 -12.730  1.00  0.00           C 
ATOM    312  CG  GLN A  21     -17.169  -5.302 -11.906  1.00  0.00           C 
ATOM    313  CD  GLN A  21     -16.076  -6.297 -12.307  1.00  0.00           C 
ATOM    314  OE1 GLN A  21     -16.263  -7.107 -13.214  1.00  0.00           O 
ATOM    315  NE2 GLN A  21     -14.933  -6.255 -11.635  1.00  0.00           N 
ATOM    316  H   GLN A  21     -17.645  -1.082 -13.106  1.00  0.00           H 
ATOM    317  HA  GLN A  21     -19.226  -3.453 -12.446  1.00  0.00           H 
ATOM    318 2HB  GLN A  21     -16.173  -3.523 -12.578  1.00  0.00           H 
ATOM    319 1HB  GLN A  21     -17.223  -4.257 -13.781  1.00  0.00           H 
ATOM    320 2HG  GLN A  21     -18.136  -5.775 -12.042  1.00  0.00           H 
ATOM    321 1HG  GLN A  21     -17.046  -5.055 -10.856  1.00  0.00           H 
ATOM    322 2HE2 GLN A  21     -14.843  -5.598 -10.921  1.00  0.00           H 
ATOM    323 1HE2 GLN A  21     -14.221  -6.886 -11.881  1.00  0.00           H 
ATOM    324  N   ASP A  22     -18.655  -3.067  -9.977  1.00  0.00           N 
ATOM    325  CA  ASP A  22     -18.577  -2.626  -8.576  1.00  0.00           C 
ATOM    326  C   ASP A  22     -17.223  -3.037  -7.987  1.00  0.00           C 
ATOM    327  O   ASP A  22     -17.087  -4.115  -7.404  1.00  0.00           O 
ATOM    328  CB  ASP A  22     -19.759  -3.213  -7.751  1.00  0.00           C 
ATOM    329  CG  ASP A  22     -19.741  -2.828  -6.254  1.00  0.00           C 
ATOM    330  OD1 ASP A  22     -19.571  -3.714  -5.384  1.00  0.00           O 
ATOM    331  OD2 ASP A  22     -19.891  -1.624  -5.945  1.00  0.00           O 
ATOM    332  H   ASP A  22     -19.128  -3.901 -10.182  1.00  0.00           H 
ATOM    333  HA  ASP A  22     -18.645  -1.536  -8.565  1.00  0.00           H 
ATOM    334 2HB  ASP A  22     -19.737  -4.294  -7.837  1.00  0.00           H 
ATOM    335 1HB  ASP A  22     -20.690  -2.857  -8.177  1.00  0.00           H 
ATOM    336  N   ILE A  23     -16.190  -2.218  -8.247  1.00  0.00           N 
ATOM    337  CA  ILE A  23     -14.882  -2.380  -7.609  1.00  0.00           C 
ATOM    338  C   ILE A  23     -14.695  -1.215  -6.635  1.00  0.00           C 
ATOM    339  O   ILE A  23     -14.928  -0.050  -6.983  1.00  0.00           O 
ATOM    340  CB  ILE A  23     -13.684  -2.511  -8.656  1.00  0.00           C 
ATOM    341  CG1 ILE A  23     -13.206  -1.140  -9.277  1.00  0.00           C 
ATOM    342  CG2 ILE A  23     -14.069  -3.505  -9.777  1.00  0.00           C 
ATOM    343  CD1 ILE A  23     -11.995  -0.499  -8.596  1.00  0.00           C 
ATOM    344  H   ILE A  23     -16.317  -1.488  -8.895  1.00  0.00           H 
ATOM    345  HA  ILE A  23     -14.909  -3.306  -7.026  1.00  0.00           H 
ATOM    346  HB  ILE A  23     -12.846  -2.960  -8.120  1.00  0.00           H 
ATOM    347 2HG1 ILE A  23     -14.018  -0.422  -9.237  1.00  0.00           H 
ATOM    348 1HG1 ILE A  23     -12.928  -1.283 -10.315  1.00  0.00           H 
ATOM    349 1HG2 ILE A  23     -13.249  -3.606 -10.478  1.00  0.00           H 
ATOM    350 2HG2 ILE A  23     -14.943  -3.142 -10.305  1.00  0.00           H 
ATOM    351 3HG2 ILE A  23     -14.292  -4.474  -9.348  1.00  0.00           H 
ATOM    352 1HD1 ILE A  23     -12.217  -0.305  -7.554  1.00  0.00           H 
ATOM    353 2HD1 ILE A  23     -11.763   0.433  -9.090  1.00  0.00           H 
ATOM    354 3HD1 ILE A  23     -11.147  -1.164  -8.669  1.00  0.00           H 
ATOM    355  N   ASN A  24     -14.353  -1.554  -5.398  1.00  0.00           N 
ATOM    356  CA  ASN A  24     -14.068  -0.582  -4.346  1.00  0.00           C 
ATOM    357  C   ASN A  24     -13.066  -1.203  -3.375  1.00  0.00           C 
ATOM    358  O   ASN A  24     -13.285  -2.299  -2.847  1.00  0.00           O 
ATOM    359  CB  ASN A  24     -15.359  -0.070  -3.644  1.00  0.00           C 
ATOM    360  CG  ASN A  24     -16.286  -1.164  -3.116  1.00  0.00           C 
ATOM    361  OD1 ASN A  24     -16.199  -1.563  -1.958  1.00  0.00           O 
ATOM    362  ND2 ASN A  24     -17.171  -1.666  -3.973  1.00  0.00           N 
ATOM    363  H   ASN A  24     -14.280  -2.510  -5.190  1.00  0.00           H 
ATOM    364  HA  ASN A  24     -13.581   0.271  -4.826  1.00  0.00           H 
ATOM    365 2HB  ASN A  24     -15.923   0.534  -4.348  1.00  0.00           H 
ATOM    366 1HB  ASN A  24     -15.078   0.563  -2.808  1.00  0.00           H 
ATOM    367 2HD2 ASN A  24     -17.185  -1.311  -4.887  1.00  0.00           H 
ATOM    368 1HD2 ASN A  24     -17.765  -2.384  -3.662  1.00  0.00           H 
ATOM    369  N   ILE A  25     -11.938  -0.500  -3.196  1.00  0.00           N 
ATOM    370  CA  ILE A  25     -10.764  -0.971  -2.451  1.00  0.00           C 
ATOM    371  C   ILE A  25     -10.221   0.217  -1.653  1.00  0.00           C 
ATOM    372  O   ILE A  25     -10.222   1.356  -2.139  1.00  0.00           O 
ATOM    373  CB  ILE A  25      -9.608  -1.495  -3.399  1.00  0.00           C 
ATOM    374  CG1 ILE A  25     -10.131  -2.536  -4.436  1.00  0.00           C 
ATOM    375  CG2 ILE A  25      -8.430  -2.089  -2.576  1.00  0.00           C 
ATOM    376  CD1 ILE A  25      -9.111  -2.967  -5.474  1.00  0.00           C 
ATOM    377  H   ILE A  25     -11.906   0.417  -3.535  1.00  0.00           H 
ATOM    378  HA  ILE A  25     -11.067  -1.768  -1.773  1.00  0.00           H 
ATOM    379  HB  ILE A  25      -9.219  -0.635  -3.944  1.00  0.00           H 
ATOM    380 2HG1 ILE A  25     -10.978  -2.118  -4.970  1.00  0.00           H 
ATOM    381 1HG1 ILE A  25     -10.456  -3.431  -3.919  1.00  0.00           H 
ATOM    382 1HG2 ILE A  25      -7.635  -2.401  -3.245  1.00  0.00           H 
ATOM    383 2HG2 ILE A  25      -8.773  -2.946  -2.010  1.00  0.00           H 
ATOM    384 3HG2 ILE A  25      -8.045  -1.342  -1.893  1.00  0.00           H 
ATOM    385 1HD1 ILE A  25      -9.569  -3.666  -6.155  1.00  0.00           H 
ATOM    386 2HD1 ILE A  25      -8.273  -3.445  -4.984  1.00  0.00           H 
ATOM    387 3HD1 ILE A  25      -8.759  -2.105  -6.028  1.00  0.00           H 
ATOM    388  N   HIS A  26      -9.790  -0.046  -0.427  1.00  0.00           N 
ATOM    389  CA  HIS A  26      -9.086   0.923   0.411  1.00  0.00           C 
ATOM    390  C   HIS A  26      -7.667   0.375   0.593  1.00  0.00           C 
ATOM    391  O   HIS A  26      -7.521  -0.815   0.856  1.00  0.00           O 
ATOM    392  CB  HIS A  26      -9.795   1.066   1.797  1.00  0.00           C 
ATOM    393  CG  HIS A  26     -11.306   1.197   1.770  1.00  0.00           C 
ATOM    394  ND1 HIS A  26     -12.106   0.832   2.833  1.00  0.00           N 
ATOM    395  CD2 HIS A  26     -12.158   1.660   0.818  1.00  0.00           C 
ATOM    396  CE1 HIS A  26     -13.369   1.063   2.538  1.00  0.00           C 
ATOM    397  NE2 HIS A  26     -13.425   1.566   1.323  1.00  0.00           N 
ATOM    398  H   HIS A  26      -9.945  -0.938  -0.061  1.00  0.00           H 
ATOM    399  HA  HIS A  26      -9.046   1.888  -0.093  1.00  0.00           H 
ATOM    400 2HB  HIS A  26      -9.402   1.943   2.299  1.00  0.00           H 
ATOM    401 1HB  HIS A  26      -9.568   0.195   2.400  1.00  0.00           H 
ATOM    402  HD1 HIS A  26     -11.791   0.444   3.677  1.00  0.00           H 
ATOM    403  HD2 HIS A  26     -11.887   2.016  -0.165  1.00  0.00           H 
ATOM    404  HE1 HIS A  26     -14.214   0.866   3.177  1.00  0.00           H 
ATOM    405  HE2 HIS A  26     -14.248   1.778   0.837  1.00  0.00           H 
ATOM    406  N   ILE A  27      -6.632   1.213   0.442  1.00  0.00           N 
ATOM    407  CA  ILE A  27      -5.231   0.800   0.655  1.00  0.00           C 
ATOM    408  C   ILE A  27      -4.631   1.734   1.713  1.00  0.00           C 
ATOM    409  O   ILE A  27      -4.342   2.889   1.438  1.00  0.00           O 
ATOM    410  CB  ILE A  27      -4.367   0.863  -0.670  1.00  0.00           C 
ATOM    411  CG1 ILE A  27      -5.003  -0.016  -1.805  1.00  0.00           C 
ATOM    412  CG2 ILE A  27      -2.892   0.432  -0.400  1.00  0.00           C 
ATOM    413  CD1 ILE A  27      -4.245  -0.003  -3.128  1.00  0.00           C 
ATOM    414  H   ILE A  27      -6.809   2.142   0.228  1.00  0.00           H 
ATOM    415  HA  ILE A  27      -5.211  -0.228   1.030  1.00  0.00           H 
ATOM    416  HB  ILE A  27      -4.350   1.899  -1.002  1.00  0.00           H 
ATOM    417 2HG1 ILE A  27      -6.014   0.331  -2.005  1.00  0.00           H 
ATOM    418 1HG1 ILE A  27      -5.052  -1.046  -1.477  1.00  0.00           H 
ATOM    419 1HG2 ILE A  27      -2.866  -0.597  -0.063  1.00  0.00           H 
ATOM    420 2HG2 ILE A  27      -2.460   1.063   0.368  1.00  0.00           H 
ATOM    421 3HG2 ILE A  27      -2.303   0.526  -1.304  1.00  0.00           H 
ATOM    422 1HD1 ILE A  27      -4.774  -0.612  -3.849  1.00  0.00           H 
ATOM    423 2HD1 ILE A  27      -3.252  -0.404  -2.985  1.00  0.00           H 
ATOM    424 3HD1 ILE A  27      -4.178   1.010  -3.502  1.00  0.00           H 
ATOM    425  N   ARG A  28      -4.461   1.212   2.912  1.00  0.00           N 
ATOM    426  CA  ARG A  28      -3.893   1.936   4.051  1.00  0.00           C 
ATOM    427  C   ARG A  28      -2.453   1.471   4.225  1.00  0.00           C 
ATOM    428  O   ARG A  28      -2.190   0.273   4.173  1.00  0.00           O 
ATOM    429  CB  ARG A  28      -4.735   1.635   5.320  1.00  0.00           C 
ATOM    430  CG  ARG A  28      -4.268   2.331   6.615  1.00  0.00           C 
ATOM    431  CD  ARG A  28      -5.196   2.012   7.802  1.00  0.00           C 
ATOM    432  NE  ARG A  28      -4.780   2.692   9.038  1.00  0.00           N 
ATOM    433  CZ  ARG A  28      -5.565   2.918  10.102  1.00  0.00           C 
ATOM    434  NH1 ARG A  28      -6.853   2.609  10.074  1.00  0.00           N 
ATOM    435  NH2 ARG A  28      -5.055   3.463  11.194  1.00  0.00           N 
ATOM    436  H   ARG A  28      -4.724   0.286   3.047  1.00  0.00           H 
ATOM    437  HA  ARG A  28      -3.915   3.005   3.845  1.00  0.00           H 
ATOM    438 2HB  ARG A  28      -4.735   0.561   5.487  1.00  0.00           H 
ATOM    439 1HB  ARG A  28      -5.757   1.946   5.124  1.00  0.00           H 
ATOM    440 2HG  ARG A  28      -4.259   3.403   6.455  1.00  0.00           H 
ATOM    441 1HG  ARG A  28      -3.266   1.998   6.855  1.00  0.00           H 
ATOM    442 2HD  ARG A  28      -5.188   0.942   7.974  1.00  0.00           H 
ATOM    443 1HD  ARG A  28      -6.206   2.323   7.549  1.00  0.00           H 
ATOM    444  HE  ARG A  28      -3.851   2.976   9.087  1.00  0.00           H 
ATOM    445 1HH1 ARG A  28      -7.258   2.207   9.252  1.00  0.00           H 
ATOM    446 2HH1 ARG A  28      -7.429   2.778  10.877  1.00  0.00           H 
ATOM    447 1HH2 ARG A  28      -4.081   3.705  11.226  1.00  0.00           H 
ATOM    448 2HH2 ARG A  28      -5.638   3.639  11.992  1.00  0.00           H 
ATOM    449  N   TYR A  29      -1.520   2.408   4.386  1.00  0.00           N 
ATOM    450  CA  TYR A  29      -0.120   2.079   4.660  1.00  0.00           C 
ATOM    451  C   TYR A  29       0.343   2.884   5.878  1.00  0.00           C 
ATOM    452  O   TYR A  29       0.193   4.113   5.923  1.00  0.00           O 
ATOM    453  CB  TYR A  29       0.775   2.295   3.402  1.00  0.00           C 
ATOM    454  CG  TYR A  29       0.919   3.736   2.880  1.00  0.00           C 
ATOM    455  CD1 TYR A  29       1.995   4.543   3.276  1.00  0.00           C 
ATOM    456  CD2 TYR A  29      -0.010   4.289   1.996  1.00  0.00           C 
ATOM    457  CE1 TYR A  29       2.132   5.833   2.814  1.00  0.00           C 
ATOM    458  CE2 TYR A  29       0.131   5.583   1.527  1.00  0.00           C 
ATOM    459  CZ  TYR A  29       1.200   6.351   1.944  1.00  0.00           C 
ATOM    460  OH  TYR A  29       1.331   7.643   1.500  1.00  0.00           O 
ATOM    461  H   TYR A  29      -1.780   3.354   4.348  1.00  0.00           H 
ATOM    462  HA  TYR A  29      -0.072   1.019   4.928  1.00  0.00           H 
ATOM    463 2HB  TYR A  29       0.368   1.693   2.593  1.00  0.00           H 
ATOM    464 1HB  TYR A  29       1.769   1.924   3.616  1.00  0.00           H 
ATOM    465  HD1 TYR A  29       2.730   4.140   3.961  1.00  0.00           H 
ATOM    466  HD2 TYR A  29      -0.853   3.689   1.669  1.00  0.00           H 
ATOM    467  HE1 TYR A  29       2.971   6.435   3.136  1.00  0.00           H 
ATOM    468  HE2 TYR A  29      -0.603   5.993   0.844  1.00  0.00           H 
ATOM    469  HH  TYR A  29       2.260   7.825   1.314  1.00  0.00           H 
ATOM    470  N   GLU A  30       0.830   2.161   6.889  1.00  0.00           N 
ATOM    471  CA  GLU A  30       1.320   2.727   8.146  1.00  0.00           C 
ATOM    472  C   GLU A  30       2.724   2.190   8.394  1.00  0.00           C 
ATOM    473  O   GLU A  30       2.901   0.979   8.560  1.00  0.00           O 
ATOM    474  CB  GLU A  30       0.393   2.334   9.327  1.00  0.00           C 
ATOM    475  CG  GLU A  30      -1.074   2.767   9.177  1.00  0.00           C 
ATOM    476  CD  GLU A  30      -1.896   2.506  10.444  1.00  0.00           C 
ATOM    477  OE1 GLU A  30      -2.382   1.374  10.628  1.00  0.00           O 
ATOM    478  OE2 GLU A  30      -2.071   3.435  11.258  1.00  0.00           O 
ATOM    479  H   GLU A  30       0.869   1.193   6.780  1.00  0.00           H 
ATOM    480  HA  GLU A  30       1.355   3.814   8.063  1.00  0.00           H 
ATOM    481 2HB  GLU A  30       0.789   2.783  10.237  1.00  0.00           H 
ATOM    482 1HB  GLU A  30       0.414   1.252   9.446  1.00  0.00           H 
ATOM    483 2HG  GLU A  30      -1.523   2.220   8.352  1.00  0.00           H 
ATOM    484 1HG  GLU A  30      -1.105   3.827   8.942  1.00  0.00           H 
ATOM    485  N   VAL A  31       3.716   3.081   8.411  1.00  0.00           N 
ATOM    486  CA  VAL A  31       5.100   2.694   8.661  1.00  0.00           C 
ATOM    487  C   VAL A  31       5.310   2.491  10.166  1.00  0.00           C 
ATOM    488  O   VAL A  31       5.168   3.426  10.963  1.00  0.00           O 
ATOM    489  CB  VAL A  31       6.101   3.756   8.089  1.00  0.00           C 
ATOM    490  CG1 VAL A  31       7.579   3.365   8.368  1.00  0.00           C 
ATOM    491  CG2 VAL A  31       5.846   3.944   6.576  1.00  0.00           C 
ATOM    492  H   VAL A  31       3.510   4.029   8.264  1.00  0.00           H 
ATOM    493  HA  VAL A  31       5.281   1.746   8.141  1.00  0.00           H 
ATOM    494  HB  VAL A  31       5.908   4.705   8.584  1.00  0.00           H 
ATOM    495 1HG1 VAL A  31       7.795   2.405   7.915  1.00  0.00           H 
ATOM    496 2HG1 VAL A  31       7.749   3.300   9.433  1.00  0.00           H 
ATOM    497 3HG1 VAL A  31       8.244   4.114   7.949  1.00  0.00           H 
ATOM    498 1HG2 VAL A  31       5.992   3.006   6.057  1.00  0.00           H 
ATOM    499 2HG2 VAL A  31       6.534   4.679   6.178  1.00  0.00           H 
ATOM    500 3HG2 VAL A  31       4.830   4.286   6.410  1.00  0.00           H 
ATOM    501  N   ARG A  32       5.643   1.256  10.526  1.00  0.00           N 
ATOM    502  CA  ARG A  32       5.896   0.833  11.906  1.00  0.00           C 
ATOM    503  C   ARG A  32       7.346   0.340  11.980  1.00  0.00           C 
ATOM    504  O   ARG A  32       7.948   0.008  10.952  1.00  0.00           O 
ATOM    505  CB  ARG A  32       4.916  -0.307  12.304  1.00  0.00           C 
ATOM    506  CG  ARG A  32       4.998  -0.761  13.789  1.00  0.00           C 
ATOM    507  CD  ARG A  32       4.409  -2.152  14.004  1.00  0.00           C 
ATOM    508  NE  ARG A  32       4.377  -2.570  15.419  1.00  0.00           N 
ATOM    509  CZ  ARG A  32       4.117  -3.823  15.844  1.00  0.00           C 
ATOM    510  NH1 ARG A  32       3.940  -4.810  14.972  1.00  0.00           N 
ATOM    511  NH2 ARG A  32       4.059  -4.089  17.142  1.00  0.00           N 
ATOM    512  H   ARG A  32       5.766   0.589   9.818  1.00  0.00           H 
ATOM    513  HA  ARG A  32       5.766   1.683  12.575  1.00  0.00           H 
ATOM    514 2HB  ARG A  32       5.114  -1.168  11.671  1.00  0.00           H 
ATOM    515 1HB  ARG A  32       3.899   0.025  12.114  1.00  0.00           H 
ATOM    516 2HG  ARG A  32       4.458  -0.049  14.404  1.00  0.00           H 
ATOM    517 1HG  ARG A  32       6.038  -0.774  14.102  1.00  0.00           H 
ATOM    518 2HD  ARG A  32       5.020  -2.858  13.448  1.00  0.00           H 
ATOM    519 1HD  ARG A  32       3.399  -2.172  13.615  1.00  0.00           H 
ATOM    520  HE  ARG A  32       4.541  -1.871  16.090  1.00  0.00           H 
ATOM    521 1HH1 ARG A  32       4.001  -4.633  13.983  1.00  0.00           H 
ATOM    522 2HH1 ARG A  32       3.748  -5.738  15.294  1.00  0.00           H 
ATOM    523 1HH2 ARG A  32       4.211  -3.359  17.813  1.00  0.00           H 
ATOM    524 2HH2 ARG A  32       3.862  -5.023  17.459  1.00  0.00           H 
ATOM    525  N   GLN A  33       7.916   0.305  13.183  1.00  0.00           N 
ATOM    526  CA  GLN A  33       9.278  -0.182  13.398  1.00  0.00           C 
ATOM    527  C   GLN A  33       9.241  -1.548  14.104  1.00  0.00           C 
ATOM    528  O   GLN A  33       8.695  -1.668  15.199  1.00  0.00           O 
ATOM    529  CB  GLN A  33      10.112   0.837  14.227  1.00  0.00           C 
ATOM    530  CG  GLN A  33      10.094   2.295  13.722  1.00  0.00           C 
ATOM    531  CD  GLN A  33      10.625   2.478  12.299  1.00  0.00           C 
ATOM    532  OE1 GLN A  33      11.831   2.616  12.086  1.00  0.00           O 
ATOM    533  NE2 GLN A  33       9.728   2.539  11.320  1.00  0.00           N 
ATOM    534  H   GLN A  33       7.399   0.599  13.953  1.00  0.00           H 
ATOM    535  HA  GLN A  33       9.747  -0.310  12.427  1.00  0.00           H 
ATOM    536 2HB  GLN A  33      11.149   0.504  14.248  1.00  0.00           H 
ATOM    537 1HB  GLN A  33       9.740   0.840  15.240  1.00  0.00           H 
ATOM    538 2HG  GLN A  33      10.694   2.900  14.390  1.00  0.00           H 
ATOM    539 1HG  GLN A  33       9.071   2.657  13.757  1.00  0.00           H 
ATOM    540 2HE2 GLN A  33       8.780   2.463  11.560  1.00  0.00           H 
ATOM    541 1HE2 GLN A  33      10.047   2.667  10.406  1.00  0.00           H 
ATOM    542  N   ASN A  34       9.791  -2.570  13.437  1.00  0.00           N 
ATOM    543  CA  ASN A  34      10.073  -3.899  14.031  1.00  0.00           C 
ATOM    544  C   ASN A  34      11.561  -3.977  14.409  1.00  0.00           C 
ATOM    545  O   ASN A  34      12.392  -3.360  13.754  1.00  0.00           O 
ATOM    546  CB  ASN A  34       9.684  -5.067  13.057  1.00  0.00           C 
ATOM    547  CG  ASN A  34      10.487  -5.200  11.737  1.00  0.00           C 
ATOM    548  OD1 ASN A  34      10.576  -6.289  11.190  1.00  0.00           O 
ATOM    549  ND2 ASN A  34      11.099  -4.142  11.222  1.00  0.00           N 
ATOM    550  H   ASN A  34      10.044  -2.421  12.513  1.00  0.00           H 
ATOM    551  HA  ASN A  34       9.480  -3.993  14.941  1.00  0.00           H 
ATOM    552 2HB  ASN A  34       8.638  -4.956  12.795  1.00  0.00           H 
ATOM    553 1HB  ASN A  34       9.801  -6.008  13.585  1.00  0.00           H 
ATOM    554 2HD2 ASN A  34      11.047  -3.299  11.691  1.00  0.00           H 
ATOM    555 1HD2 ASN A  34      11.561  -4.250  10.367  1.00  0.00           H 
ATOM    556  N   ALA A  35      11.890  -4.732  15.463  1.00  0.00           N 
ATOM    557  CA  ALA A  35      13.290  -4.924  15.913  1.00  0.00           C 
ATOM    558  C   ALA A  35      14.095  -5.817  14.937  1.00  0.00           C 
ATOM    559  O   ALA A  35      15.325  -5.902  15.038  1.00  0.00           O 
ATOM    560  CB  ALA A  35      13.302  -5.505  17.335  1.00  0.00           C 
ATOM    561  H   ALA A  35      11.175  -5.183  15.958  1.00  0.00           H 
ATOM    562  HA  ALA A  35      13.764  -3.947  15.952  1.00  0.00           H 
ATOM    563 1HB  ALA A  35      14.323  -5.601  17.686  1.00  0.00           H 
ATOM    564 2HB  ALA A  35      12.831  -6.480  17.334  1.00  0.00           H 
ATOM    565 3HB  ALA A  35      12.754  -4.849  18.000  1.00  0.00           H 
ATOM    566  N   GLU A  36      13.386  -6.469  13.998  1.00  0.00           N 
ATOM    567  CA  GLU A  36      13.981  -7.370  13.003  1.00  0.00           C 
ATOM    568  C   GLU A  36      14.697  -6.589  11.875  1.00  0.00           C 
ATOM    569  O   GLU A  36      15.887  -6.809  11.622  1.00  0.00           O 
ATOM    570  CB  GLU A  36      12.869  -8.279  12.419  1.00  0.00           C 
ATOM    571  CG  GLU A  36      13.323  -9.215  11.280  1.00  0.00           C 
ATOM    572  CD  GLU A  36      12.177 -10.041  10.683  1.00  0.00           C 
ATOM    573  OE1 GLU A  36      11.908 -11.160  11.173  1.00  0.00           O 
ATOM    574  OE2 GLU A  36      11.521  -9.564   9.732  1.00  0.00           O 
ATOM    575  H   GLU A  36      12.415  -6.351  13.989  1.00  0.00           H 
ATOM    576  HA  GLU A  36      14.709  -7.995  13.516  1.00  0.00           H 
ATOM    577 2HB  GLU A  36      12.075  -7.645  12.041  1.00  0.00           H 
ATOM    578 1HB  GLU A  36      12.468  -8.889  13.221  1.00  0.00           H 
ATOM    579 2HG  GLU A  36      14.083  -9.886  11.663  1.00  0.00           H 
ATOM    580 1HG  GLU A  36      13.759  -8.606  10.495  1.00  0.00           H 
ATOM    581  N   SER A  37      13.970  -5.671  11.209  1.00  0.00           N 
ATOM    582  CA  SER A  37      14.483  -4.925  10.024  1.00  0.00           C 
ATOM    583  C   SER A  37      14.617  -3.417  10.315  1.00  0.00           C 
ATOM    584  O   SER A  37      15.155  -2.659   9.498  1.00  0.00           O 
ATOM    585  CB  SER A  37      13.536  -5.167   8.813  1.00  0.00           C 
ATOM    586  OG  SER A  37      14.001  -4.528   7.627  1.00  0.00           O 
ATOM    587  H   SER A  37      13.059  -5.491  11.514  1.00  0.00           H 
ATOM    588  HA  SER A  37      15.469  -5.310   9.771  1.00  0.00           H 
ATOM    589 2HB  SER A  37      12.549  -4.786   9.043  1.00  0.00           H 
ATOM    590 1HB  SER A  37      13.467  -6.229   8.619  1.00  0.00           H 
ATOM    591  HG  SER A  37      14.531  -5.151   7.111  1.00  0.00           H 
ATOM    592  N   GLY A  38      14.134  -2.991  11.486  1.00  0.00           N 
ATOM    593  CA  GLY A  38      14.043  -1.571  11.818  1.00  0.00           C 
ATOM    594  C   GLY A  38      12.745  -1.004  11.274  1.00  0.00           C 
ATOM    595  O   GLY A  38      11.676  -1.339  11.769  1.00  0.00           O 
ATOM    596  H   GLY A  38      13.804  -3.653  12.124  1.00  0.00           H 
ATOM    597 2HA  GLY A  38      14.886  -1.030  11.397  1.00  0.00           H 
ATOM    598 1HA  GLY A  38      14.057  -1.462  12.896  1.00  0.00           H 
ATOM    599  N   ALA A  39      12.832  -0.183  10.225  1.00  0.00           N 
ATOM    600  CA  ALA A  39      11.649   0.341   9.520  1.00  0.00           C 
ATOM    601  C   ALA A  39      10.990  -0.747   8.646  1.00  0.00           C 
ATOM    602  O   ALA A  39      11.680  -1.587   8.058  1.00  0.00           O 
ATOM    603  CB  ALA A  39      12.030   1.568   8.663  1.00  0.00           C 
ATOM    604  H   ALA A  39      13.721   0.099   9.939  1.00  0.00           H 
ATOM    605  HA  ALA A  39      10.930   0.669  10.281  1.00  0.00           H 
ATOM    606 1HB  ALA A  39      12.477   2.328   9.294  1.00  0.00           H 
ATOM    607 2HB  ALA A  39      11.145   1.978   8.195  1.00  0.00           H 
ATOM    608 3HB  ALA A  39      12.738   1.278   7.894  1.00  0.00           H 
ATOM    609  N   TYR A  40       9.651  -0.736   8.615  1.00  0.00           N 
ATOM    610  CA  TYR A  40       8.839  -1.526   7.659  1.00  0.00           C 
ATOM    611  C   TYR A  40       7.460  -0.857   7.508  1.00  0.00           C 
ATOM    612  O   TYR A  40       7.109   0.021   8.301  1.00  0.00           O 
ATOM    613  CB  TYR A  40       8.708  -3.024   8.103  1.00  0.00           C 
ATOM    614  CG  TYR A  40       7.592  -3.358   9.113  1.00  0.00           C 
ATOM    615  CD1 TYR A  40       7.764  -3.160  10.484  1.00  0.00           C 
ATOM    616  CD2 TYR A  40       6.365  -3.897   8.687  1.00  0.00           C 
ATOM    617  CE1 TYR A  40       6.763  -3.475  11.382  1.00  0.00           C 
ATOM    618  CE2 TYR A  40       5.372  -4.200   9.583  1.00  0.00           C 
ATOM    619  CZ  TYR A  40       5.570  -3.999  10.923  1.00  0.00           C 
ATOM    620  OH  TYR A  40       4.568  -4.332  11.809  1.00  0.00           O 
ATOM    621  H   TYR A  40       9.182  -0.173   9.270  1.00  0.00           H 
ATOM    622  HA  TYR A  40       9.343  -1.485   6.691  1.00  0.00           H 
ATOM    623 2HB  TYR A  40       9.652  -3.336   8.538  1.00  0.00           H 
ATOM    624 1HB  TYR A  40       8.537  -3.629   7.219  1.00  0.00           H 
ATOM    625  HD1 TYR A  40       8.697  -2.748  10.847  1.00  0.00           H 
ATOM    626  HD2 TYR A  40       6.191  -4.064   7.629  1.00  0.00           H 
ATOM    627  HE1 TYR A  40       6.917  -3.311  12.441  1.00  0.00           H 
ATOM    628  HE2 TYR A  40       4.436  -4.607   9.225  1.00  0.00           H 
ATOM    629  HH  TYR A  40       4.164  -5.170  11.535  1.00  0.00           H 
ATOM    630  N   VAL A  41       6.675  -1.257   6.493  1.00  0.00           N 
ATOM    631  CA  VAL A  41       5.313  -0.724   6.293  1.00  0.00           C 
ATOM    632  C   VAL A  41       4.272  -1.847   6.460  1.00  0.00           C 
ATOM    633  O   VAL A  41       4.377  -2.903   5.826  1.00  0.00           O 
ATOM    634  CB  VAL A  41       5.120  -0.056   4.879  1.00  0.00           C 
ATOM    635  CG1 VAL A  41       3.846   0.823   4.856  1.00  0.00           C 
ATOM    636  CG2 VAL A  41       6.357   0.755   4.444  1.00  0.00           C 
ATOM    637  H   VAL A  41       7.014  -1.927   5.867  1.00  0.00           H 
ATOM    638  HA  VAL A  41       5.131   0.038   7.054  1.00  0.00           H 
ATOM    639  HB  VAL A  41       4.980  -0.853   4.149  1.00  0.00           H 
ATOM    640 1HG1 VAL A  41       3.933   1.615   5.590  1.00  0.00           H 
ATOM    641 2HG1 VAL A  41       2.977   0.220   5.090  1.00  0.00           H 
ATOM    642 3HG1 VAL A  41       3.716   1.257   3.870  1.00  0.00           H 
ATOM    643 1HG2 VAL A  41       6.543   1.550   5.155  1.00  0.00           H 
ATOM    644 2HG2 VAL A  41       6.190   1.186   3.464  1.00  0.00           H 
ATOM    645 3HG2 VAL A  41       7.223   0.109   4.403  1.00  0.00           H 
ATOM    646  N   HIS A  42       3.292  -1.607   7.335  1.00  0.00           N 
ATOM    647  CA  HIS A  42       2.101  -2.452   7.494  1.00  0.00           C 
ATOM    648  C   HIS A  42       0.995  -1.928   6.558  1.00  0.00           C 
ATOM    649  O   HIS A  42       0.576  -0.775   6.679  1.00  0.00           O 
ATOM    650  CB  HIS A  42       1.637  -2.417   8.980  1.00  0.00           C 
ATOM    651  CG  HIS A  42       0.253  -2.984   9.237  1.00  0.00           C 
ATOM    652  ND1 HIS A  42      -0.006  -4.326   9.399  1.00  0.00           N 
ATOM    653  CD2 HIS A  42      -0.949  -2.365   9.343  1.00  0.00           C 
ATOM    654  CE1 HIS A  42      -1.297  -4.504   9.582  1.00  0.00           C 
ATOM    655  NE2 HIS A  42      -1.888  -3.333   9.557  1.00  0.00           N 
ATOM    656  H   HIS A  42       3.357  -0.813   7.894  1.00  0.00           H 
ATOM    657  HA  HIS A  42       2.359  -3.477   7.222  1.00  0.00           H 
ATOM    658 2HB  HIS A  42       1.642  -1.390   9.326  1.00  0.00           H 
ATOM    659 1HB  HIS A  42       2.337  -2.985   9.577  1.00  0.00           H 
ATOM    660  HD1 HIS A  42       0.663  -5.041   9.409  1.00  0.00           H 
ATOM    661  HD2 HIS A  42      -1.134  -1.301   9.266  1.00  0.00           H 
ATOM    662  HE1 HIS A  42      -1.786  -5.456   9.732  1.00  0.00           H 
ATOM    663  HE2 HIS A  42      -2.854  -3.204   9.431  1.00  0.00           H 
ATOM    664  N   PHE A  43       0.527  -2.777   5.637  1.00  0.00           N 
ATOM    665  CA  PHE A  43      -0.545  -2.423   4.684  1.00  0.00           C 
ATOM    666  C   PHE A  43      -1.856  -3.149   5.057  1.00  0.00           C 
ATOM    667  O   PHE A  43      -1.820  -4.285   5.548  1.00  0.00           O 
ATOM    668  CB  PHE A  43      -0.139  -2.807   3.240  1.00  0.00           C 
ATOM    669  CG  PHE A  43       1.185  -2.214   2.740  1.00  0.00           C 
ATOM    670  CD1 PHE A  43       1.224  -0.962   2.134  1.00  0.00           C 
ATOM    671  CD2 PHE A  43       2.385  -2.924   2.856  1.00  0.00           C 
ATOM    672  CE1 PHE A  43       2.412  -0.442   1.654  1.00  0.00           C 
ATOM    673  CE2 PHE A  43       3.568  -2.404   2.380  1.00  0.00           C 
ATOM    674  CZ  PHE A  43       3.584  -1.162   1.785  1.00  0.00           C 
ATOM    675  H   PHE A  43       0.906  -3.676   5.583  1.00  0.00           H 
ATOM    676  HA  PHE A  43      -0.707  -1.348   4.725  1.00  0.00           H 
ATOM    677 2HB  PHE A  43      -0.925  -2.484   2.559  1.00  0.00           H 
ATOM    678 1HB  PHE A  43      -0.056  -3.887   3.170  1.00  0.00           H 
ATOM    679  HD1 PHE A  43       0.310  -0.387   2.039  1.00  0.00           H 
ATOM    680  HD2 PHE A  43       2.380  -3.902   3.315  1.00  0.00           H 
ATOM    681  HE1 PHE A  43       2.428   0.532   1.185  1.00  0.00           H 
ATOM    682  HE2 PHE A  43       4.484  -2.969   2.482  1.00  0.00           H 
ATOM    683  HZ  PHE A  43       4.514  -0.756   1.408  1.00  0.00           H 
ATOM    684  N   ASP A  44      -2.997  -2.470   4.833  1.00  0.00           N 
ATOM    685  CA  ASP A  44      -4.359  -3.047   4.955  1.00  0.00           C 
ATOM    686  C   ASP A  44      -5.135  -2.746   3.672  1.00  0.00           C 
ATOM    687  O   ASP A  44      -5.175  -1.593   3.244  1.00  0.00           O 
ATOM    688  CB  ASP A  44      -5.142  -2.432   6.150  1.00  0.00           C 
ATOM    689  CG  ASP A  44      -4.435  -2.600   7.496  1.00  0.00           C 
ATOM    690  OD1 ASP A  44      -4.476  -3.711   8.067  1.00  0.00           O 
ATOM    691  OD2 ASP A  44      -3.835  -1.624   7.994  1.00  0.00           O 
ATOM    692  H   ASP A  44      -2.927  -1.527   4.586  1.00  0.00           H 
ATOM    693  HA  ASP A  44      -4.283  -4.124   5.087  1.00  0.00           H 
ATOM    694 2HB  ASP A  44      -6.122  -2.905   6.218  1.00  0.00           H 
ATOM    695 1HB  ASP A  44      -5.294  -1.372   5.965  1.00  0.00           H 
ATOM    696  N   MET A  45      -5.741  -3.765   3.047  1.00  0.00           N 
ATOM    697  CA  MET A  45      -6.638  -3.568   1.890  1.00  0.00           C 
ATOM    698  C   MET A  45      -8.014  -4.187   2.170  1.00  0.00           C 
ATOM    699  O   MET A  45      -8.100  -5.355   2.536  1.00  0.00           O 
ATOM    700  CB  MET A  45      -6.005  -4.167   0.603  1.00  0.00           C 
ATOM    701  CG  MET A  45      -4.753  -3.414   0.113  1.00  0.00           C 
ATOM    702  SD  MET A  45      -4.014  -4.131  -1.369  1.00  0.00           S 
ATOM    703  CE  MET A  45      -5.384  -4.102  -2.520  1.00  0.00           C 
ATOM    704  H   MET A  45      -5.569  -4.680   3.348  1.00  0.00           H 
ATOM    705  HA  MET A  45      -6.772  -2.500   1.743  1.00  0.00           H 
ATOM    706 2HB  MET A  45      -6.742  -4.148  -0.195  1.00  0.00           H 
ATOM    707 1HB  MET A  45      -5.730  -5.198   0.790  1.00  0.00           H 
ATOM    708 2HG  MET A  45      -4.008  -3.421   0.899  1.00  0.00           H 
ATOM    709 1HG  MET A  45      -5.023  -2.389  -0.106  1.00  0.00           H 
ATOM    710 1HE  MET A  45      -5.707  -3.084  -2.675  1.00  0.00           H 
ATOM    711 2HE  MET A  45      -6.202  -4.688  -2.125  1.00  0.00           H 
ATOM    712 3HE  MET A  45      -5.065  -4.525  -3.464  1.00  0.00           H 
ATOM    713  N   ASP A  46      -9.090  -3.404   1.953  1.00  0.00           N 
ATOM    714  CA  ASP A  46     -10.474  -3.828   2.282  1.00  0.00           C 
ATOM    715  C   ASP A  46     -11.513  -3.099   1.399  1.00  0.00           C 
ATOM    716  O   ASP A  46     -11.311  -1.950   1.014  1.00  0.00           O 
ATOM    717  CB  ASP A  46     -10.780  -3.593   3.790  1.00  0.00           C 
ATOM    718  CG  ASP A  46     -10.745  -2.111   4.211  1.00  0.00           C 
ATOM    719  OD1 ASP A  46     -11.805  -1.546   4.557  1.00  0.00           O 
ATOM    720  OD2 ASP A  46      -9.656  -1.509   4.211  1.00  0.00           O 
ATOM    721  H   ASP A  46      -8.952  -2.513   1.571  1.00  0.00           H 
ATOM    722  HA  ASP A  46     -10.546  -4.898   2.083  1.00  0.00           H 
ATOM    723 2HB  ASP A  46     -10.047  -4.131   4.380  1.00  0.00           H 
ATOM    724 1HB  ASP A  46     -11.762  -4.005   4.020  1.00  0.00           H 
ATOM    725  N   GLY A  47     -12.619  -3.795   1.091  1.00  0.00           N 
ATOM    726  CA  GLY A  47     -13.722  -3.249   0.274  1.00  0.00           C 
ATOM    727  C   GLY A  47     -14.694  -4.355  -0.109  1.00  0.00           C 
ATOM    728  O   GLY A  47     -14.804  -5.329   0.638  1.00  0.00           O 
ATOM    729  H   GLY A  47     -12.691  -4.719   1.419  1.00  0.00           H 
ATOM    730 2HA  GLY A  47     -13.317  -2.800  -0.624  1.00  0.00           H 
ATOM    731 1HA  GLY A  47     -14.251  -2.496   0.842  1.00  0.00           H 
ATOM    732  N   GLU A  48     -15.392  -4.242  -1.265  1.00  0.00           N 
ATOM    733  CA  GLU A  48     -16.205  -5.349  -1.807  1.00  0.00           C 
ATOM    734  C   GLU A  48     -16.282  -5.277  -3.350  1.00  0.00           C 
ATOM    735  O   GLU A  48     -16.906  -4.393  -3.934  1.00  0.00           O 
ATOM    736  CB  GLU A  48     -17.629  -5.382  -1.180  1.00  0.00           C 
ATOM    737  CG  GLU A  48     -18.451  -4.078  -1.306  1.00  0.00           C 
ATOM    738  CD  GLU A  48     -19.870  -4.198  -0.729  1.00  0.00           C 
ATOM    739  OE1 GLU A  48     -20.103  -3.774   0.426  1.00  0.00           O 
ATOM    740  OE2 GLU A  48     -20.767  -4.707  -1.437  1.00  0.00           O 
ATOM    741  H   GLU A  48     -15.343  -3.411  -1.783  1.00  0.00           H 
ATOM    742  HA  GLU A  48     -15.700  -6.277  -1.540  1.00  0.00           H 
ATOM    743 2HB  GLU A  48     -17.534  -5.625  -0.123  1.00  0.00           H 
ATOM    744 1HB  GLU A  48     -18.179  -6.183  -1.660  1.00  0.00           H 
ATOM    745 2HG  GLU A  48     -18.525  -3.815  -2.357  1.00  0.00           H 
ATOM    746 1HG  GLU A  48     -17.923  -3.282  -0.789  1.00  0.00           H 
ATOM    747  N   ILE A  49     -15.591  -6.224  -3.993  1.00  0.00           N 
ATOM    748  CA  ILE A  49     -15.570  -6.320  -5.474  1.00  0.00           C 
ATOM    749  C   ILE A  49     -16.518  -7.408  -5.978  1.00  0.00           C 
ATOM    750  O   ILE A  49     -16.443  -8.551  -5.529  1.00  0.00           O 
ATOM    751  CB  ILE A  49     -14.120  -6.577  -6.000  1.00  0.00           C 
ATOM    752  CG1 ILE A  49     -13.161  -5.456  -5.479  1.00  0.00           C 
ATOM    753  CG2 ILE A  49     -14.096  -6.661  -7.553  1.00  0.00           C 
ATOM    754  CD1 ILE A  49     -11.703  -5.680  -5.795  1.00  0.00           C 
ATOM    755  H   ILE A  49     -14.919  -6.673  -3.456  1.00  0.00           H 
ATOM    756  HA  ILE A  49     -15.899  -5.358  -5.875  1.00  0.00           H 
ATOM    757  HB  ILE A  49     -13.791  -7.539  -5.605  1.00  0.00           H 
ATOM    758 2HG1 ILE A  49     -13.252  -5.384  -4.399  1.00  0.00           H 
ATOM    759 1HG1 ILE A  49     -13.444  -4.507  -5.914  1.00  0.00           H 
ATOM    760 1HG2 ILE A  49     -14.443  -5.727  -7.981  1.00  0.00           H 
ATOM    761 2HG2 ILE A  49     -14.741  -7.463  -7.890  1.00  0.00           H 
ATOM    762 3HG2 ILE A  49     -13.087  -6.857  -7.893  1.00  0.00           H 
ATOM    763 1HD1 ILE A  49     -11.357  -6.578  -5.305  1.00  0.00           H 
ATOM    764 2HD1 ILE A  49     -11.132  -4.838  -5.439  1.00  0.00           H 
ATOM    765 3HD1 ILE A  49     -11.570  -5.777  -6.862  1.00  0.00           H 
ATOM    766  N   ASP A  50     -17.397  -7.008  -6.934  1.00  0.00           N 
ATOM    767  CA  ASP A  50     -18.531  -7.814  -7.434  1.00  0.00           C 
ATOM    768  C   ASP A  50     -19.528  -8.069  -6.270  1.00  0.00           C 
ATOM    769  O   ASP A  50     -20.337  -8.997  -6.290  1.00  0.00           O 
ATOM    770  CB  ASP A  50     -18.011  -9.132  -8.115  1.00  0.00           C 
ATOM    771  CG  ASP A  50     -19.090  -9.936  -8.867  1.00  0.00           C 
ATOM    772  OD1 ASP A  50     -19.443 -11.057  -8.433  1.00  0.00           O 
ATOM    773  OD2 ASP A  50     -19.597  -9.443  -9.897  1.00  0.00           O 
ATOM    774  H   ASP A  50     -17.271  -6.119  -7.317  1.00  0.00           H 
ATOM    775  HA  ASP A  50     -19.041  -7.211  -8.175  1.00  0.00           H 
ATOM    776 2HB  ASP A  50     -17.568  -9.762  -7.349  1.00  0.00           H 
ATOM    777 1HB  ASP A  50     -17.234  -8.873  -8.826  1.00  0.00           H 
ATOM    778  N   GLY A  51     -19.455  -7.185  -5.247  1.00  0.00           N 
ATOM    779  CA  GLY A  51     -20.244  -7.313  -4.024  1.00  0.00           C 
ATOM    780  C   GLY A  51     -19.589  -8.192  -2.966  1.00  0.00           C 
ATOM    781  O   GLY A  51     -20.138  -8.337  -1.869  1.00  0.00           O 
ATOM    782  H   GLY A  51     -18.830  -6.434  -5.322  1.00  0.00           H 
ATOM    783 2HA  GLY A  51     -21.219  -7.726  -4.262  1.00  0.00           H 
ATOM    784 1HA  GLY A  51     -20.384  -6.328  -3.605  1.00  0.00           H 
ATOM    785  N   LYS A  52     -18.422  -8.797  -3.291  1.00  0.00           N 
ATOM    786  CA  LYS A  52     -17.698  -9.716  -2.394  1.00  0.00           C 
ATOM    787  C   LYS A  52     -16.756  -8.966  -1.440  1.00  0.00           C 
ATOM    788  O   LYS A  52     -15.719  -8.451  -1.887  1.00  0.00           O 
ATOM    789  CB  LYS A  52     -16.897 -10.749  -3.231  1.00  0.00           C 
ATOM    790  CG  LYS A  52     -17.778 -11.707  -4.067  1.00  0.00           C 
ATOM    791  CD  LYS A  52     -18.702 -12.570  -3.172  1.00  0.00           C 
ATOM    792  CE  LYS A  52     -19.616 -13.512  -3.970  1.00  0.00           C 
ATOM    793  NZ  LYS A  52     -20.494 -14.303  -3.071  1.00  0.00           N 
ATOM    794  H   LYS A  52     -18.037  -8.656  -4.176  1.00  0.00           H 
ATOM    795  HA  LYS A  52     -18.424 -10.243  -1.814  1.00  0.00           H 
ATOM    796 2HB  LYS A  52     -16.280 -11.346  -2.561  1.00  0.00           H 
ATOM    797 1HB  LYS A  52     -16.239 -10.205  -3.907  1.00  0.00           H 
ATOM    798 2HG  LYS A  52     -17.133 -12.362  -4.643  1.00  0.00           H 
ATOM    799 1HG  LYS A  52     -18.391 -11.121  -4.745  1.00  0.00           H 
ATOM    800 2HD  LYS A  52     -19.322 -11.914  -2.569  1.00  0.00           H 
ATOM    801 1HD  LYS A  52     -18.085 -13.170  -2.511  1.00  0.00           H 
ATOM    802 2HE  LYS A  52     -19.008 -14.192  -4.553  1.00  0.00           H 
ATOM    803 1HE  LYS A  52     -20.240 -12.926  -4.635  1.00  0.00           H 
ATOM    804 1HZ  LYS A  52     -19.920 -14.924  -2.473  1.00  0.00           H 
ATOM    805 2HZ  LYS A  52     -21.150 -14.884  -3.627  1.00  0.00           H 
ATOM    806 3HZ  LYS A  52     -21.046 -13.663  -2.461  1.00  0.00           H 
ATOM    807  N   PRO A  53     -17.078  -8.923  -0.103  1.00  0.00           N 
ATOM    808  CA  PRO A  53     -16.271  -8.193   0.891  1.00  0.00           C 
ATOM    809  C   PRO A  53     -14.951  -8.920   1.207  1.00  0.00           C 
ATOM    810  O   PRO A  53     -14.908 -10.159   1.282  1.00  0.00           O 
ATOM    811  CB  PRO A  53     -17.206  -8.117   2.123  1.00  0.00           C 
ATOM    812  CG  PRO A  53     -18.041  -9.359   2.027  1.00  0.00           C 
ATOM    813  CD  PRO A  53     -18.242  -9.606   0.542  1.00  0.00           C 
ATOM    814  HA  PRO A  53     -16.048  -7.186   0.541  1.00  0.00           H 
ATOM    815 2HB  PRO A  53     -17.820  -7.221   2.063  1.00  0.00           H 
ATOM    816 1HB  PRO A  53     -16.625  -8.090   3.041  1.00  0.00           H 
ATOM    817 2HG  PRO A  53     -18.993  -9.209   2.524  1.00  0.00           H 
ATOM    818 1HG  PRO A  53     -17.514 -10.194   2.483  1.00  0.00           H 
ATOM    819 2HD  PRO A  53     -19.175  -9.168   0.201  1.00  0.00           H 
ATOM    820 1HD  PRO A  53     -18.233 -10.669   0.326  1.00  0.00           H 
ATOM    821  N   PHE A  54     -13.879  -8.138   1.392  1.00  0.00           N 
ATOM    822  CA  PHE A  54     -12.543  -8.666   1.695  1.00  0.00           C 
ATOM    823  C   PHE A  54     -11.845  -7.771   2.719  1.00  0.00           C 
ATOM    824  O   PHE A  54     -12.084  -6.561   2.760  1.00  0.00           O 
ATOM    825  CB  PHE A  54     -11.685  -8.813   0.400  1.00  0.00           C 
ATOM    826  CG  PHE A  54     -11.315  -7.508  -0.332  1.00  0.00           C 
ATOM    827  CD1 PHE A  54     -12.199  -6.909  -1.232  1.00  0.00           C 
ATOM    828  CD2 PHE A  54     -10.070  -6.901  -0.136  1.00  0.00           C 
ATOM    829  CE1 PHE A  54     -11.851  -5.754  -1.906  1.00  0.00           C 
ATOM    830  CE2 PHE A  54      -9.727  -5.746  -0.808  1.00  0.00           C 
ATOM    831  CZ  PHE A  54     -10.617  -5.173  -1.692  1.00  0.00           C 
ATOM    832  H   PHE A  54     -13.993  -7.167   1.344  1.00  0.00           H 
ATOM    833  HA  PHE A  54     -12.667  -9.654   2.141  1.00  0.00           H 
ATOM    834 2HB  PHE A  54     -12.227  -9.442  -0.299  1.00  0.00           H 
ATOM    835 1HB  PHE A  54     -10.761  -9.322   0.653  1.00  0.00           H 
ATOM    836  HD1 PHE A  54     -13.169  -7.361  -1.401  1.00  0.00           H 
ATOM    837  HD2 PHE A  54      -9.365  -7.347   0.558  1.00  0.00           H 
ATOM    838  HE1 PHE A  54     -12.548  -5.305  -2.600  1.00  0.00           H 
ATOM    839  HE2 PHE A  54      -8.760  -5.289  -0.641  1.00  0.00           H 
ATOM    840  HZ  PHE A  54     -10.346  -4.270  -2.221  1.00  0.00           H 
ATOM    841  N   SER A  55     -11.010  -8.393   3.554  1.00  0.00           N 
ATOM    842  CA  SER A  55     -10.126  -7.707   4.494  1.00  0.00           C 
ATOM    843  C   SER A  55      -8.772  -8.430   4.472  1.00  0.00           C 
ATOM    844  O   SER A  55      -8.675  -9.614   4.824  1.00  0.00           O 
ATOM    845  CB  SER A  55     -10.748  -7.685   5.911  1.00  0.00           C 
ATOM    846  OG  SER A  55     -11.035  -8.997   6.384  1.00  0.00           O 
ATOM    847  H   SER A  55     -11.003  -9.371   3.558  1.00  0.00           H 
ATOM    848  HA  SER A  55      -9.985  -6.680   4.149  1.00  0.00           H 
ATOM    849 2HB  SER A  55     -11.671  -7.120   5.888  1.00  0.00           H 
ATOM    850 1HB  SER A  55     -10.062  -7.212   6.596  1.00  0.00           H 
ATOM    851  HG  SER A  55     -10.208  -9.424   6.634  1.00  0.00           H 
ATOM    852  N   ASP A  56      -7.743  -7.706   4.040  1.00  0.00           N 
ATOM    853  CA  ASP A  56      -6.400  -8.241   3.772  1.00  0.00           C 
ATOM    854  C   ASP A  56      -5.363  -7.364   4.484  1.00  0.00           C 
ATOM    855  O   ASP A  56      -5.573  -6.160   4.649  1.00  0.00           O 
ATOM    856  CB  ASP A  56      -6.149  -8.260   2.235  1.00  0.00           C 
ATOM    857  CG  ASP A  56      -4.816  -8.921   1.840  1.00  0.00           C 
ATOM    858  OD1 ASP A  56      -3.799  -8.216   1.677  1.00  0.00           O 
ATOM    859  OD2 ASP A  56      -4.781 -10.163   1.716  1.00  0.00           O 
ATOM    860  H   ASP A  56      -7.886  -6.752   3.904  1.00  0.00           H 
ATOM    861  HA  ASP A  56      -6.340  -9.256   4.163  1.00  0.00           H 
ATOM    862 2HB  ASP A  56      -6.161  -7.241   1.862  1.00  0.00           H 
ATOM    863 1HB  ASP A  56      -6.960  -8.804   1.756  1.00  0.00           H 
ATOM    864  N   SER A  57      -4.265  -7.976   4.937  1.00  0.00           N 
ATOM    865  CA  SER A  57      -3.132  -7.254   5.530  1.00  0.00           C 
ATOM    866  C   SER A  57      -1.823  -7.933   5.100  1.00  0.00           C 
ATOM    867  O   SER A  57      -1.684  -9.155   5.218  1.00  0.00           O 
ATOM    868  CB  SER A  57      -3.252  -7.219   7.075  1.00  0.00           C 
ATOM    869  OG  SER A  57      -4.499  -6.677   7.494  1.00  0.00           O 
ATOM    870  H   SER A  57      -4.217  -8.952   4.883  1.00  0.00           H 
ATOM    871  HA  SER A  57      -3.137  -6.234   5.151  1.00  0.00           H 
ATOM    872 2HB  SER A  57      -2.456  -6.607   7.486  1.00  0.00           H 
ATOM    873 1HB  SER A  57      -3.175  -8.223   7.469  1.00  0.00           H 
ATOM    874  HG  SER A  57      -4.576  -5.766   7.178  1.00  0.00           H 
ATOM    875  N   PHE A  58      -0.878  -7.134   4.591  1.00  0.00           N 
ATOM    876  CA  PHE A  58       0.451  -7.607   4.164  1.00  0.00           C 
ATOM    877  C   PHE A  58       1.506  -6.595   4.608  1.00  0.00           C 
ATOM    878  O   PHE A  58       1.246  -5.398   4.618  1.00  0.00           O 
ATOM    879  CB  PHE A  58       0.497  -7.850   2.628  1.00  0.00           C 
ATOM    880  CG  PHE A  58       0.152  -6.642   1.736  1.00  0.00           C 
ATOM    881  CD1 PHE A  58       1.153  -5.895   1.109  1.00  0.00           C 
ATOM    882  CD2 PHE A  58      -1.174  -6.277   1.507  1.00  0.00           C 
ATOM    883  CE1 PHE A  58       0.837  -4.837   0.281  1.00  0.00           C 
ATOM    884  CE2 PHE A  58      -1.488  -5.215   0.686  1.00  0.00           C 
ATOM    885  CZ  PHE A  58      -0.484  -4.495   0.071  1.00  0.00           C 
ATOM    886  H   PHE A  58      -1.077  -6.175   4.508  1.00  0.00           H 
ATOM    887  HA  PHE A  58       0.656  -8.551   4.673  1.00  0.00           H 
ATOM    888 2HB  PHE A  58      -0.201  -8.649   2.387  1.00  0.00           H 
ATOM    889 1HB  PHE A  58       1.492  -8.192   2.359  1.00  0.00           H 
ATOM    890  HD1 PHE A  58       2.193  -6.157   1.270  1.00  0.00           H 
ATOM    891  HD2 PHE A  58      -1.968  -6.837   1.988  1.00  0.00           H 
ATOM    892  HE1 PHE A  58       1.627  -4.266  -0.188  1.00  0.00           H 
ATOM    893  HE2 PHE A  58      -2.522  -4.948   0.521  1.00  0.00           H 
ATOM    894  HZ  PHE A  58      -0.732  -3.665  -0.577  1.00  0.00           H 
ATOM    895  N   GLU A  59       2.684  -7.086   5.010  1.00  0.00           N 
ATOM    896  CA  GLU A  59       3.763  -6.250   5.570  1.00  0.00           C 
ATOM    897  C   GLU A  59       5.064  -6.484   4.803  1.00  0.00           C 
ATOM    898  O   GLU A  59       5.443  -7.630   4.539  1.00  0.00           O 
ATOM    899  CB  GLU A  59       3.950  -6.556   7.078  1.00  0.00           C 
ATOM    900  CG  GLU A  59       2.683  -6.318   7.924  1.00  0.00           C 
ATOM    901  CD  GLU A  59       2.854  -6.655   9.415  1.00  0.00           C 
ATOM    902  OE1 GLU A  59       3.364  -7.745   9.738  1.00  0.00           O 
ATOM    903  OE2 GLU A  59       2.457  -5.842  10.271  1.00  0.00           O 
ATOM    904  H   GLU A  59       2.842  -8.049   4.916  1.00  0.00           H 
ATOM    905  HA  GLU A  59       3.479  -5.203   5.461  1.00  0.00           H 
ATOM    906 2HB  GLU A  59       4.743  -5.927   7.472  1.00  0.00           H 
ATOM    907 1HB  GLU A  59       4.245  -7.597   7.196  1.00  0.00           H 
ATOM    908 2HG  GLU A  59       1.889  -6.925   7.523  1.00  0.00           H 
ATOM    909 1HG  GLU A  59       2.397  -5.274   7.823  1.00  0.00           H 
ATOM    910  N   LEU A  60       5.734  -5.386   4.449  1.00  0.00           N 
ATOM    911  CA  LEU A  60       6.993  -5.396   3.690  1.00  0.00           C 
ATOM    912  C   LEU A  60       8.065  -4.632   4.479  1.00  0.00           C 
ATOM    913  O   LEU A  60       7.801  -3.504   4.905  1.00  0.00           O 
ATOM    914  CB  LEU A  60       6.767  -4.752   2.297  1.00  0.00           C 
ATOM    915  CG  LEU A  60       5.928  -5.606   1.289  1.00  0.00           C 
ATOM    916  CD1 LEU A  60       5.480  -4.774   0.071  1.00  0.00           C 
ATOM    917  CD2 LEU A  60       6.721  -6.865   0.849  1.00  0.00           C 
ATOM    918  H   LEU A  60       5.371  -4.515   4.727  1.00  0.00           H 
ATOM    919  HA  LEU A  60       7.314  -6.425   3.555  1.00  0.00           H 
ATOM    920 2HB  LEU A  60       7.736  -4.555   1.843  1.00  0.00           H 
ATOM    921 1HB  LEU A  60       6.266  -3.799   2.442  1.00  0.00           H 
ATOM    922  HG  LEU A  60       5.028  -5.947   1.790  1.00  0.00           H 
ATOM    923 1HD1 LEU A  60       6.345  -4.370  -0.440  1.00  0.00           H 
ATOM    924 2HD1 LEU A  60       4.846  -3.958   0.400  1.00  0.00           H 
ATOM    925 3HD1 LEU A  60       4.919  -5.400  -0.612  1.00  0.00           H 
ATOM    926 1HD2 LEU A  60       6.968  -7.466   1.715  1.00  0.00           H 
ATOM    927 2HD2 LEU A  60       7.633  -6.572   0.344  1.00  0.00           H 
ATOM    928 3HD2 LEU A  60       6.114  -7.456   0.174  1.00  0.00           H 
ATOM    929  N   PRO A  61       9.283  -5.234   4.700  1.00  0.00           N 
ATOM    930  CA  PRO A  61      10.419  -4.533   5.347  1.00  0.00           C 
ATOM    931  C   PRO A  61      10.906  -3.349   4.498  1.00  0.00           C 
ATOM    932  O   PRO A  61      10.579  -3.277   3.318  1.00  0.00           O 
ATOM    933  CB  PRO A  61      11.498  -5.639   5.481  1.00  0.00           C 
ATOM    934  CG  PRO A  61      11.162  -6.628   4.410  1.00  0.00           C 
ATOM    935  CD  PRO A  61       9.650  -6.630   4.333  1.00  0.00           C 
ATOM    936  HA  PRO A  61      10.145  -4.169   6.326  1.00  0.00           H 
ATOM    937 2HB  PRO A  61      11.429  -6.090   6.466  1.00  0.00           H 
ATOM    938 1HB  PRO A  61      12.493  -5.228   5.348  1.00  0.00           H 
ATOM    939 2HG  PRO A  61      11.533  -7.611   4.678  1.00  0.00           H 
ATOM    940 1HG  PRO A  61      11.594  -6.314   3.460  1.00  0.00           H 
ATOM    941 2HD  PRO A  61       9.229  -7.336   5.042  1.00  0.00           H 
ATOM    942 1HD  PRO A  61       9.321  -6.870   3.327  1.00  0.00           H 
ATOM    943  N   ARG A  62      11.653  -2.422   5.123  1.00  0.00           N 
ATOM    944  CA  ARG A  62      12.271  -1.254   4.439  1.00  0.00           C 
ATOM    945  C   ARG A  62      12.963  -1.628   3.088  1.00  0.00           C 
ATOM    946  O   ARG A  62      12.952  -0.840   2.133  1.00  0.00           O 
ATOM    947  CB  ARG A  62      13.292  -0.566   5.391  1.00  0.00           C 
ATOM    948  CG  ARG A  62      14.632  -1.326   5.562  1.00  0.00           C 
ATOM    949  CD  ARG A  62      15.616  -0.656   6.537  1.00  0.00           C 
ATOM    950  NE  ARG A  62      16.993  -1.161   6.352  1.00  0.00           N 
ATOM    951  CZ  ARG A  62      17.438  -2.395   6.676  1.00  0.00           C 
ATOM    952  NH1 ARG A  62      16.658  -3.281   7.289  1.00  0.00           N 
ATOM    953  NH2 ARG A  62      18.687  -2.727   6.402  1.00  0.00           N 
ATOM    954  H   ARG A  62      11.711  -2.470   6.099  1.00  0.00           H 
ATOM    955  HA  ARG A  62      11.467  -0.556   4.227  1.00  0.00           H 
ATOM    956 2HB  ARG A  62      12.835  -0.466   6.370  1.00  0.00           H 
ATOM    957 1HB  ARG A  62      13.507   0.428   5.015  1.00  0.00           H 
ATOM    958 2HG  ARG A  62      15.107  -1.402   4.588  1.00  0.00           H 
ATOM    959 1HG  ARG A  62      14.420  -2.327   5.924  1.00  0.00           H 
ATOM    960 2HD  ARG A  62      15.301  -0.847   7.558  1.00  0.00           H 
ATOM    961 1HD  ARG A  62      15.617   0.414   6.361  1.00  0.00           H 
ATOM    962  HE  ARG A  62      17.628  -0.538   5.934  1.00  0.00           H 
ATOM    963 1HH1 ARG A  62      15.710  -3.048   7.528  1.00  0.00           H 
ATOM    964 2HH1 ARG A  62      17.013  -4.192   7.519  1.00  0.00           H 
ATOM    965 1HH2 ARG A  62      19.298  -2.070   5.954  1.00  0.00           H 
ATOM    966 2HH2 ARG A  62      19.029  -3.640   6.645  1.00  0.00           H 
ATOM    967  N   ASP A  63      13.509  -2.863   3.034  1.00  0.00           N 
ATOM    968  CA  ASP A  63      14.270  -3.396   1.889  1.00  0.00           C 
ATOM    969  C   ASP A  63      13.370  -3.680   0.662  1.00  0.00           C 
ATOM    970  O   ASP A  63      13.822  -3.557  -0.479  1.00  0.00           O 
ATOM    971  CB  ASP A  63      15.014  -4.687   2.337  1.00  0.00           C 
ATOM    972  CG  ASP A  63      15.954  -5.276   1.264  1.00  0.00           C 
ATOM    973  OD1 ASP A  63      17.051  -4.718   1.056  1.00  0.00           O 
ATOM    974  OD2 ASP A  63      15.602  -6.289   0.624  1.00  0.00           O 
ATOM    975  H   ASP A  63      13.394  -3.443   3.813  1.00  0.00           H 
ATOM    976  HA  ASP A  63      15.009  -2.648   1.614  1.00  0.00           H 
ATOM    977 2HB  ASP A  63      14.279  -5.438   2.613  1.00  0.00           H 
ATOM    978 1HB  ASP A  63      15.608  -4.456   3.214  1.00  0.00           H 
ATOM    979  N   THR A  64      12.090  -4.015   0.902  1.00  0.00           N 
ATOM    980  CA  THR A  64      11.126  -4.404  -0.155  1.00  0.00           C 
ATOM    981  C   THR A  64       9.813  -3.608  -0.002  1.00  0.00           C 
ATOM    982  O   THR A  64       8.790  -3.966  -0.596  1.00  0.00           O 
ATOM    983  CB  THR A  64      10.831  -5.948  -0.127  1.00  0.00           C 
ATOM    984  OG1 THR A  64      10.411  -6.339   1.185  1.00  0.00           O 
ATOM    985  CG2 THR A  64      12.059  -6.778  -0.549  1.00  0.00           C 
ATOM    986  H   THR A  64      11.743  -3.920   1.810  1.00  0.00           H 
ATOM    987  HA  THR A  64      11.550  -4.152  -1.125  1.00  0.00           H 
ATOM    988  HB  THR A  64      10.022  -6.158  -0.820  1.00  0.00           H 
ATOM    989  HG1 THR A  64      10.391  -7.298   1.240  1.00  0.00           H 
ATOM    990 1HG2 THR A  64      11.811  -7.830  -0.527  1.00  0.00           H 
ATOM    991 2HG2 THR A  64      12.881  -6.591   0.134  1.00  0.00           H 
ATOM    992 3HG2 THR A  64      12.360  -6.504  -1.552  1.00  0.00           H 
ATOM    993  N   ALA A  65       9.865  -2.507   0.782  1.00  0.00           N 
ATOM    994  CA  ALA A  65       8.704  -1.623   1.020  1.00  0.00           C 
ATOM    995  C   ALA A  65       8.240  -0.960  -0.283  1.00  0.00           C 
ATOM    996  O   ALA A  65       7.048  -0.895  -0.557  1.00  0.00           O 
ATOM    997  CB  ALA A  65       9.049  -0.561   2.074  1.00  0.00           C 
ATOM    998  H   ALA A  65      10.710  -2.304   1.237  1.00  0.00           H 
ATOM    999  HA  ALA A  65       7.897  -2.234   1.412  1.00  0.00           H 
ATOM   1000 1HB  ALA A  65       8.179   0.051   2.277  1.00  0.00           H 
ATOM   1001 2HB  ALA A  65       9.852   0.069   1.716  1.00  0.00           H 
ATOM   1002 3HB  ALA A  65       9.363  -1.049   2.989  1.00  0.00           H 
ATOM   1003  N   PHE A  66       9.221  -0.494  -1.073  1.00  0.00           N 
ATOM   1004  CA  PHE A  66       9.001   0.180  -2.378  1.00  0.00           C 
ATOM   1005  C   PHE A  66       8.574  -0.807  -3.492  1.00  0.00           C 
ATOM   1006  O   PHE A  66       8.283  -0.394  -4.616  1.00  0.00           O 
ATOM   1007  CB  PHE A  66      10.281   0.951  -2.784  1.00  0.00           C 
ATOM   1008  CG  PHE A  66      10.816   1.835  -1.659  1.00  0.00           C 
ATOM   1009  CD1 PHE A  66      11.880   1.414  -0.857  1.00  0.00           C 
ATOM   1010  CD2 PHE A  66      10.223   3.062  -1.377  1.00  0.00           C 
ATOM   1011  CE1 PHE A  66      12.335   2.195   0.184  1.00  0.00           C 
ATOM   1012  CE2 PHE A  66      10.681   3.840  -0.343  1.00  0.00           C 
ATOM   1013  CZ  PHE A  66      11.738   3.406   0.441  1.00  0.00           C 
ATOM   1014  H   PHE A  66      10.131  -0.547  -0.723  1.00  0.00           H 
ATOM   1015  HA  PHE A  66       8.196   0.899  -2.243  1.00  0.00           H 
ATOM   1016 2HB  PHE A  66      10.066   1.586  -3.641  1.00  0.00           H 
ATOM   1017 1HB  PHE A  66      11.057   0.243  -3.069  1.00  0.00           H 
ATOM   1018  HD1 PHE A  66      12.355   0.460  -1.062  1.00  0.00           H 
ATOM   1019  HD2 PHE A  66       9.398   3.409  -1.985  1.00  0.00           H 
ATOM   1020  HE1 PHE A  66      13.161   1.857   0.797  1.00  0.00           H 
ATOM   1021  HE2 PHE A  66      10.216   4.797  -0.137  1.00  0.00           H 
ATOM   1022  HZ  PHE A  66      12.092   4.022   1.258  1.00  0.00           H 
ATOM   1023  N   ASN A  67       8.513  -2.106  -3.156  1.00  0.00           N 
ATOM   1024  CA  ASN A  67       7.995  -3.162  -4.053  1.00  0.00           C 
ATOM   1025  C   ASN A  67       6.468  -3.320  -3.874  1.00  0.00           C 
ATOM   1026  O   ASN A  67       5.854  -4.195  -4.503  1.00  0.00           O 
ATOM   1027  CB  ASN A  67       8.720  -4.508  -3.756  1.00  0.00           C 
ATOM   1028  CG  ASN A  67      10.211  -4.571  -4.147  1.00  0.00           C 
ATOM   1029  OD1 ASN A  67      10.731  -5.648  -4.436  1.00  0.00           O 
ATOM   1030  ND2 ASN A  67      10.922  -3.449  -4.168  1.00  0.00           N 
ATOM   1031  H   ASN A  67       8.812  -2.367  -2.264  1.00  0.00           H 
ATOM   1032  HA  ASN A  67       8.190  -2.868  -5.078  1.00  0.00           H 
ATOM   1033 2HB  ASN A  67       8.202  -5.306  -4.281  1.00  0.00           H 
ATOM   1034 1HB  ASN A  67       8.657  -4.708  -2.694  1.00  0.00           H 
ATOM   1035 2HD2 ASN A  67      10.482  -2.607  -3.940  1.00  0.00           H 
ATOM   1036 1HD2 ASN A  67      11.872  -3.511  -4.405  1.00  0.00           H 
ATOM   1037  N   PHE A  68       5.888  -2.465  -2.994  1.00  0.00           N 
ATOM   1038  CA  PHE A  68       4.460  -2.478  -2.648  1.00  0.00           C 
ATOM   1039  C   PHE A  68       3.555  -2.379  -3.883  1.00  0.00           C 
ATOM   1040  O   PHE A  68       2.650  -3.178  -4.018  1.00  0.00           O 
ATOM   1041  CB  PHE A  68       4.117  -1.352  -1.629  1.00  0.00           C 
ATOM   1042  CG  PHE A  68       4.151   0.080  -2.197  1.00  0.00           C 
ATOM   1043  CD1 PHE A  68       5.359   0.693  -2.541  1.00  0.00           C 
ATOM   1044  CD2 PHE A  68       2.977   0.791  -2.415  1.00  0.00           C 
ATOM   1045  CE1 PHE A  68       5.393   1.956  -3.083  1.00  0.00           C 
ATOM   1046  CE2 PHE A  68       3.011   2.057  -2.954  1.00  0.00           C 
ATOM   1047  CZ  PHE A  68       4.217   2.642  -3.290  1.00  0.00           C 
ATOM   1048  H   PHE A  68       6.476  -1.848  -2.515  1.00  0.00           H 
ATOM   1049  HA  PHE A  68       4.273  -3.435  -2.162  1.00  0.00           H 
ATOM   1050 2HB  PHE A  68       4.820  -1.402  -0.807  1.00  0.00           H 
ATOM   1051 1HB  PHE A  68       3.124  -1.537  -1.229  1.00  0.00           H 
ATOM   1052  HD1 PHE A  68       6.281   0.154  -2.377  1.00  0.00           H 
ATOM   1053  HD2 PHE A  68       2.023   0.342  -2.156  1.00  0.00           H 
ATOM   1054  HE1 PHE A  68       6.341   2.412  -3.342  1.00  0.00           H 
ATOM   1055  HE2 PHE A  68       2.090   2.593  -3.116  1.00  0.00           H 
ATOM   1056  HZ  PHE A  68       4.238   3.638  -3.714  1.00  0.00           H 
ATOM   1057  N   ALA A  69       3.812  -1.395  -4.779  1.00  0.00           N 
ATOM   1058  CA  ALA A  69       2.968  -1.129  -5.968  1.00  0.00           C 
ATOM   1059  C   ALA A  69       2.750  -2.362  -6.864  1.00  0.00           C 
ATOM   1060  O   ALA A  69       1.723  -2.452  -7.540  1.00  0.00           O 
ATOM   1061  CB  ALA A  69       3.541   0.035  -6.782  1.00  0.00           C 
ATOM   1062  H   ALA A  69       4.534  -0.753  -4.600  1.00  0.00           H 
ATOM   1063  HA  ALA A  69       1.995  -0.814  -5.591  1.00  0.00           H 
ATOM   1064 1HB  ALA A  69       2.866   0.291  -7.588  1.00  0.00           H 
ATOM   1065 2HB  ALA A  69       4.501  -0.244  -7.192  1.00  0.00           H 
ATOM   1066 3HB  ALA A  69       3.669   0.898  -6.138  1.00  0.00           H 
ATOM   1067  N   SER A  70       3.719  -3.295  -6.867  1.00  0.00           N 
ATOM   1068  CA  SER A  70       3.591  -4.571  -7.581  1.00  0.00           C 
ATOM   1069  C   SER A  70       2.582  -5.487  -6.856  1.00  0.00           C 
ATOM   1070  O   SER A  70       1.629  -5.966  -7.467  1.00  0.00           O 
ATOM   1071  CB  SER A  70       4.982  -5.244  -7.682  1.00  0.00           C 
ATOM   1072  OG  SER A  70       5.938  -4.362  -8.264  1.00  0.00           O 
ATOM   1073  H   SER A  70       4.539  -3.131  -6.357  1.00  0.00           H 
ATOM   1074  HA  SER A  70       3.231  -4.362  -8.588  1.00  0.00           H 
ATOM   1075 2HB  SER A  70       4.914  -6.133  -8.297  1.00  0.00           H 
ATOM   1076 1HB  SER A  70       5.327  -5.519  -6.692  1.00  0.00           H 
ATOM   1077  HG  SER A  70       5.510  -3.523  -8.482  1.00  0.00           H 
ATOM   1078  N   ASP A  71       2.790  -5.676  -5.533  1.00  0.00           N 
ATOM   1079  CA  ASP A  71       1.988  -6.621  -4.716  1.00  0.00           C 
ATOM   1080  C   ASP A  71       0.567  -6.097  -4.432  1.00  0.00           C 
ATOM   1081  O   ASP A  71      -0.396  -6.816  -4.628  1.00  0.00           O 
ATOM   1082  CB  ASP A  71       2.705  -6.946  -3.384  1.00  0.00           C 
ATOM   1083  CG  ASP A  71       1.993  -8.057  -2.582  1.00  0.00           C 
ATOM   1084  OD1 ASP A  71       1.260  -7.755  -1.614  1.00  0.00           O 
ATOM   1085  OD2 ASP A  71       2.157  -9.243  -2.934  1.00  0.00           O 
ATOM   1086  H   ASP A  71       3.516  -5.175  -5.094  1.00  0.00           H 
ATOM   1087  HA  ASP A  71       1.904  -7.537  -5.293  1.00  0.00           H 
ATOM   1088 2HB  ASP A  71       2.758  -6.045  -2.779  1.00  0.00           H 
ATOM   1089 1HB  ASP A  71       3.718  -7.271  -3.602  1.00  0.00           H 
ATOM   1090  N   ALA A  72       0.477  -4.860  -3.910  1.00  0.00           N 
ATOM   1091  CA  ALA A  72      -0.798  -4.140  -3.659  1.00  0.00           C 
ATOM   1092  C   ALA A  72      -1.756  -4.176  -4.870  1.00  0.00           C 
ATOM   1093  O   ALA A  72      -2.974  -4.266  -4.708  1.00  0.00           O 
ATOM   1094  CB  ALA A  72      -0.501  -2.686  -3.254  1.00  0.00           C 
ATOM   1095  H   ALA A  72       1.301  -4.443  -3.622  1.00  0.00           H 
ATOM   1096  HA  ALA A  72      -1.282  -4.625  -2.815  1.00  0.00           H 
ATOM   1097 1HB  ALA A  72      -0.029  -2.167  -4.079  1.00  0.00           H 
ATOM   1098 2HB  ALA A  72       0.170  -2.678  -2.402  1.00  0.00           H 
ATOM   1099 3HB  ALA A  72      -1.419  -2.180  -2.988  1.00  0.00           H 
ATOM   1100  N   THR A  73      -1.182  -4.106  -6.079  1.00  0.00           N 
ATOM   1101  CA  THR A  73      -1.939  -4.250  -7.332  1.00  0.00           C 
ATOM   1102  C   THR A  73      -2.302  -5.733  -7.594  1.00  0.00           C 
ATOM   1103  O   THR A  73      -3.441  -6.040  -7.949  1.00  0.00           O 
ATOM   1104  CB  THR A  73      -1.141  -3.667  -8.538  1.00  0.00           C 
ATOM   1105  OG1 THR A  73      -0.950  -2.253  -8.349  1.00  0.00           O 
ATOM   1106  CG2 THR A  73      -1.846  -3.916  -9.880  1.00  0.00           C 
ATOM   1107  H   THR A  73      -0.217  -3.955  -6.116  1.00  0.00           H 
ATOM   1108  HA  THR A  73      -2.862  -3.679  -7.229  1.00  0.00           H 
ATOM   1109  HB  THR A  73      -0.162  -4.143  -8.567  1.00  0.00           H 
ATOM   1110  HG1 THR A  73      -0.325  -2.116  -7.632  1.00  0.00           H 
ATOM   1111 1HG2 THR A  73      -2.838  -3.479  -9.862  1.00  0.00           H 
ATOM   1112 2HG2 THR A  73      -1.929  -4.981 -10.062  1.00  0.00           H 
ATOM   1113 3HG2 THR A  73      -1.277  -3.464 -10.679  1.00  0.00           H 
ATOM   1114  N   ARG A  74      -1.316  -6.626  -7.391  1.00  0.00           N 
ATOM   1115  CA  ARG A  74      -1.441  -8.090  -7.607  1.00  0.00           C 
ATOM   1116  C   ARG A  74      -2.608  -8.699  -6.792  1.00  0.00           C 
ATOM   1117  O   ARG A  74      -3.410  -9.475  -7.319  1.00  0.00           O 
ATOM   1118  CB  ARG A  74      -0.091  -8.770  -7.248  1.00  0.00           C 
ATOM   1119  CG  ARG A  74      -0.047 -10.304  -7.400  1.00  0.00           C 
ATOM   1120  CD  ARG A  74       1.334 -10.879  -7.031  1.00  0.00           C 
ATOM   1121  NE  ARG A  74       1.378 -12.353  -7.150  1.00  0.00           N 
ATOM   1122  CZ  ARG A  74       2.390 -13.063  -7.676  1.00  0.00           C 
ATOM   1123  NH1 ARG A  74       3.445 -12.456  -8.206  1.00  0.00           N 
ATOM   1124  NH2 ARG A  74       2.331 -14.384  -7.672  1.00  0.00           N 
ATOM   1125  H   ARG A  74      -0.452  -6.280  -7.089  1.00  0.00           H 
ATOM   1126  HA  ARG A  74      -1.637  -8.245  -8.663  1.00  0.00           H 
ATOM   1127 2HB  ARG A  74       0.154  -8.524  -6.217  1.00  0.00           H 
ATOM   1128 1HB  ARG A  74       0.680  -8.350  -7.884  1.00  0.00           H 
ATOM   1129 2HG  ARG A  74      -0.277 -10.564  -8.428  1.00  0.00           H 
ATOM   1130 1HG  ARG A  74      -0.793 -10.745  -6.746  1.00  0.00           H 
ATOM   1131 2HD  ARG A  74       1.564 -10.611  -6.006  1.00  0.00           H 
ATOM   1132 1HD  ARG A  74       2.079 -10.441  -7.686  1.00  0.00           H 
ATOM   1133  HE  ARG A  74       0.607 -12.843  -6.783  1.00  0.00           H 
ATOM   1134 1HH1 ARG A  74       3.497 -11.456  -8.217  1.00  0.00           H 
ATOM   1135 2HH1 ARG A  74       4.199 -12.995  -8.593  1.00  0.00           H 
ATOM   1136 1HH2 ARG A  74       1.536 -14.855  -7.274  1.00  0.00           H 
ATOM   1137 2HH2 ARG A  74       3.080 -14.921  -8.064  1.00  0.00           H 
ATOM   1138  N   VAL A  75      -2.703  -8.307  -5.518  1.00  0.00           N 
ATOM   1139  CA  VAL A  75      -3.766  -8.751  -4.603  1.00  0.00           C 
ATOM   1140  C   VAL A  75      -5.114  -8.080  -4.955  1.00  0.00           C 
ATOM   1141  O   VAL A  75      -6.171  -8.698  -4.806  1.00  0.00           O 
ATOM   1142  CB  VAL A  75      -3.361  -8.516  -3.094  1.00  0.00           C 
ATOM   1143  CG1 VAL A  75      -3.126  -7.030  -2.774  1.00  0.00           C 
ATOM   1144  CG2 VAL A  75      -4.377  -9.140  -2.108  1.00  0.00           C 
ATOM   1145  H   VAL A  75      -2.036  -7.687  -5.180  1.00  0.00           H 
ATOM   1146  HA  VAL A  75      -3.882  -9.821  -4.750  1.00  0.00           H 
ATOM   1147  HB  VAL A  75      -2.410  -9.027  -2.942  1.00  0.00           H 
ATOM   1148 1HG1 VAL A  75      -4.042  -6.472  -2.932  1.00  0.00           H 
ATOM   1149 2HG1 VAL A  75      -2.354  -6.633  -3.419  1.00  0.00           H 
ATOM   1150 3HG1 VAL A  75      -2.816  -6.920  -1.741  1.00  0.00           H 
ATOM   1151 1HG2 VAL A  75      -4.472 -10.201  -2.297  1.00  0.00           H 
ATOM   1152 2HG2 VAL A  75      -5.345  -8.669  -2.230  1.00  0.00           H 
ATOM   1153 3HG2 VAL A  75      -4.037  -8.991  -1.089  1.00  0.00           H 
ATOM   1154  N   ALA A  76      -5.063  -6.833  -5.477  1.00  0.00           N 
ATOM   1155  CA  ALA A  76      -6.268  -6.064  -5.850  1.00  0.00           C 
ATOM   1156  C   ALA A  76      -6.974  -6.713  -7.054  1.00  0.00           C 
ATOM   1157  O   ALA A  76      -8.201  -6.859  -7.069  1.00  0.00           O 
ATOM   1158  CB  ALA A  76      -5.889  -4.613  -6.184  1.00  0.00           C 
ATOM   1159  H   ALA A  76      -4.191  -6.435  -5.679  1.00  0.00           H 
ATOM   1160  HA  ALA A  76      -6.941  -6.053  -4.995  1.00  0.00           H 
ATOM   1161 1HB  ALA A  76      -5.212  -4.599  -7.029  1.00  0.00           H 
ATOM   1162 2HB  ALA A  76      -5.399  -4.157  -5.331  1.00  0.00           H 
ATOM   1163 3HB  ALA A  76      -6.776  -4.046  -6.429  1.00  0.00           H 
ATOM   1164  N   GLN A  77      -6.162  -7.125  -8.042  1.00  0.00           N 
ATOM   1165  CA  GLN A  77      -6.653  -7.753  -9.279  1.00  0.00           C 
ATOM   1166  C   GLN A  77      -7.008  -9.228  -9.051  1.00  0.00           C 
ATOM   1167  O   GLN A  77      -7.849  -9.785  -9.772  1.00  0.00           O 
ATOM   1168  CB  GLN A  77      -5.651  -7.583 -10.449  1.00  0.00           C 
ATOM   1169  CG  GLN A  77      -4.273  -8.216 -10.229  1.00  0.00           C 
ATOM   1170  CD  GLN A  77      -3.381  -8.128 -11.464  1.00  0.00           C 
ATOM   1171  OE1 GLN A  77      -2.637  -7.160 -11.649  1.00  0.00           O 
ATOM   1172  NE2 GLN A  77      -3.459  -9.133 -12.325  1.00  0.00           N 
ATOM   1173  H   GLN A  77      -5.199  -7.018  -7.910  1.00  0.00           H 
ATOM   1174  HA  GLN A  77      -7.571  -7.239  -9.551  1.00  0.00           H 
ATOM   1175 2HB  GLN A  77      -5.512  -6.520 -10.629  1.00  0.00           H 
ATOM   1176 1HB  GLN A  77      -6.092  -8.021 -11.342  1.00  0.00           H 
ATOM   1177 2HG  GLN A  77      -4.402  -9.260  -9.959  1.00  0.00           H 
ATOM   1178 1HG  GLN A  77      -3.785  -7.701  -9.411  1.00  0.00           H 
ATOM   1179 2HE2 GLN A  77      -4.075  -9.868 -12.125  1.00  0.00           H 
ATOM   1180 1HE2 GLN A  77      -2.893  -9.102 -13.125  1.00  0.00           H 
ATOM   1181  N   LYS A  78      -6.365  -9.857  -8.043  1.00  0.00           N 
ATOM   1182  CA  LYS A  78      -6.742 -11.199  -7.557  1.00  0.00           C 
ATOM   1183  C   LYS A  78      -8.146 -11.164  -6.911  1.00  0.00           C 
ATOM   1184  O   LYS A  78      -8.851 -12.172  -6.875  1.00  0.00           O 
ATOM   1185  CB  LYS A  78      -5.672 -11.721  -6.555  1.00  0.00           C 
ATOM   1186  CG  LYS A  78      -5.885 -13.175  -6.073  1.00  0.00           C 
ATOM   1187  CD  LYS A  78      -4.740 -13.696  -5.165  1.00  0.00           C 
ATOM   1188  CE  LYS A  78      -3.396 -13.835  -5.900  1.00  0.00           C 
ATOM   1189  NZ  LYS A  78      -3.464 -14.823  -7.012  1.00  0.00           N 
ATOM   1190  H   LYS A  78      -5.596  -9.418  -7.625  1.00  0.00           H 
ATOM   1191  HA  LYS A  78      -6.772 -11.864  -8.415  1.00  0.00           H 
ATOM   1192 2HB  LYS A  78      -5.661 -11.072  -5.684  1.00  0.00           H 
ATOM   1193 1HB  LYS A  78      -4.697 -11.663  -7.032  1.00  0.00           H 
ATOM   1194 2HG  LYS A  78      -5.969 -13.824  -6.942  1.00  0.00           H 
ATOM   1195 1HG  LYS A  78      -6.818 -13.221  -5.517  1.00  0.00           H 
ATOM   1196 2HD  LYS A  78      -5.024 -14.669  -4.772  1.00  0.00           H 
ATOM   1197 1HD  LYS A  78      -4.613 -13.012  -4.333  1.00  0.00           H 
ATOM   1198 2HE  LYS A  78      -2.642 -14.163  -5.192  1.00  0.00           H 
ATOM   1199 1HE  LYS A  78      -3.108 -12.875  -6.304  1.00  0.00           H 
ATOM   1200 1HZ  LYS A  78      -3.722 -15.764  -6.642  1.00  0.00           H 
ATOM   1201 2HZ  LYS A  78      -2.544 -14.895  -7.484  1.00  0.00           H 
ATOM   1202 3HZ  LYS A  78      -4.176 -14.531  -7.713  1.00  0.00           H 
ATOM   1203  N   HIS A  79      -8.544  -9.970  -6.421  1.00  0.00           N 
ATOM   1204  CA  HIS A  79      -9.883  -9.736  -5.844  1.00  0.00           C 
ATOM   1205  C   HIS A  79     -10.934  -9.356  -6.915  1.00  0.00           C 
ATOM   1206  O   HIS A  79     -12.097  -9.150  -6.561  1.00  0.00           O 
ATOM   1207  CB  HIS A  79      -9.823  -8.651  -4.730  1.00  0.00           C 
ATOM   1208  CG  HIS A  79      -9.238  -9.128  -3.423  1.00  0.00           C 
ATOM   1209  ND1 HIS A  79      -8.108  -8.588  -2.846  1.00  0.00           N 
ATOM   1210  CD2 HIS A  79      -9.665 -10.085  -2.565  1.00  0.00           C 
ATOM   1211  CE1 HIS A  79      -7.871  -9.190  -1.700  1.00  0.00           C 
ATOM   1212  NE2 HIS A  79      -8.796 -10.102  -1.503  1.00  0.00           N 
ATOM   1213  H   HIS A  79      -7.908  -9.223  -6.448  1.00  0.00           H 
ATOM   1214  HA  HIS A  79     -10.212 -10.670  -5.391  1.00  0.00           H 
ATOM   1215 2HB  HIS A  79     -10.824  -8.290  -4.525  1.00  0.00           H 
ATOM   1216 1HB  HIS A  79      -9.223  -7.820  -5.079  1.00  0.00           H 
ATOM   1217  HD1 HIS A  79      -7.548  -7.885  -3.235  1.00  0.00           H 
ATOM   1218  HD2 HIS A  79     -10.536 -10.716  -2.687  1.00  0.00           H 
ATOM   1219  HE1 HIS A  79      -7.054  -8.970  -1.031  1.00  0.00           H 
ATOM   1220  HE2 HIS A  79      -8.704 -10.853  -0.873  1.00  0.00           H 
ATOM   1221  N   GLY A  80     -10.557  -9.291  -8.214  1.00  0.00           N 
ATOM   1222  CA  GLY A  80     -11.533  -9.018  -9.294  1.00  0.00           C 
ATOM   1223  C   GLY A  80     -11.312  -7.720 -10.069  1.00  0.00           C 
ATOM   1224  O   GLY A  80     -12.272  -6.996 -10.349  1.00  0.00           O 
ATOM   1225  H   GLY A  80      -9.639  -9.502  -8.466  1.00  0.00           H 
ATOM   1226 2HA  GLY A  80     -12.542  -9.007  -8.882  1.00  0.00           H 
ATOM   1227 1HA  GLY A  80     -11.476  -9.830 -10.000  1.00  0.00           H 
ATOM   1228  N   LEU A  81     -10.051  -7.419 -10.427  1.00  0.00           N 
ATOM   1229  CA  LEU A  81      -9.723  -6.369 -11.432  1.00  0.00           C 
ATOM   1230  C   LEU A  81      -9.052  -7.044 -12.637  1.00  0.00           C 
ATOM   1231  O   LEU A  81      -8.228  -7.946 -12.465  1.00  0.00           O 
ATOM   1232  CB  LEU A  81      -8.778  -5.239 -10.870  1.00  0.00           C 
ATOM   1233  CG  LEU A  81      -9.440  -4.074 -10.065  1.00  0.00           C 
ATOM   1234  CD1 LEU A  81     -10.495  -3.342 -10.914  1.00  0.00           C 
ATOM   1235  CD2 LEU A  81     -10.031  -4.561  -8.735  1.00  0.00           C 
ATOM   1236  H   LEU A  81      -9.318  -7.923 -10.025  1.00  0.00           H 
ATOM   1237  HA  LEU A  81     -10.656  -5.914 -11.768  1.00  0.00           H 
ATOM   1238 2HB  LEU A  81      -8.246  -4.790 -11.706  1.00  0.00           H 
ATOM   1239 1HB  LEU A  81      -8.039  -5.704 -10.234  1.00  0.00           H 
ATOM   1240  HG  LEU A  81      -8.670  -3.345  -9.823  1.00  0.00           H 
ATOM   1241 1HD1 LEU A  81     -11.306  -4.018 -11.167  1.00  0.00           H 
ATOM   1242 2HD1 LEU A  81     -10.040  -2.979 -11.825  1.00  0.00           H 
ATOM   1243 3HD1 LEU A  81     -10.890  -2.503 -10.360  1.00  0.00           H 
ATOM   1244 1HD2 LEU A  81     -10.446  -3.725  -8.184  1.00  0.00           H 
ATOM   1245 2HD2 LEU A  81      -9.252  -5.021  -8.142  1.00  0.00           H 
ATOM   1246 3HD2 LEU A  81     -10.812  -5.288  -8.922  1.00  0.00           H 
ATOM   1247  N   HIS A  82      -9.420  -6.614 -13.848  1.00  0.00           N 
ATOM   1248  CA  HIS A  82      -8.747  -7.029 -15.093  1.00  0.00           C 
ATOM   1249  C   HIS A  82      -7.687  -5.973 -15.485  1.00  0.00           C 
ATOM   1250  O   HIS A  82      -7.828  -4.808 -15.103  1.00  0.00           O 
ATOM   1251  CB  HIS A  82      -9.788  -7.234 -16.232  1.00  0.00           C 
ATOM   1252  CG  HIS A  82     -10.710  -8.413 -16.018  1.00  0.00           C 
ATOM   1253  ND1 HIS A  82     -11.999  -8.471 -16.508  1.00  0.00           N 
ATOM   1254  CD2 HIS A  82     -10.502  -9.599 -15.392  1.00  0.00           C 
ATOM   1255  CE1 HIS A  82     -12.536  -9.632 -16.191  1.00  0.00           C 
ATOM   1256  NE2 HIS A  82     -11.652 -10.333 -15.515  1.00  0.00           N 
ATOM   1257  H   HIS A  82     -10.169  -5.985 -13.911  1.00  0.00           H 
ATOM   1258  HA  HIS A  82      -8.238  -7.971 -14.910  1.00  0.00           H 
ATOM   1259 2HB  HIS A  82      -9.266  -7.395 -17.170  1.00  0.00           H 
ATOM   1260 1HB  HIS A  82     -10.399  -6.348 -16.319  1.00  0.00           H 
ATOM   1261  HD1 HIS A  82     -12.450  -7.769 -17.025  1.00  0.00           H 
ATOM   1262  HD2 HIS A  82      -9.596  -9.910 -14.892  1.00  0.00           H 
ATOM   1263  HE1 HIS A  82     -13.533  -9.958 -16.452  1.00  0.00           H 
ATOM   1264  HE2 HIS A  82     -11.857 -11.145 -15.006  1.00  0.00           H 
ATOM   1265  N   PRO A  83      -6.595  -6.361 -16.235  1.00  0.00           N 
ATOM   1266  CA  PRO A  83      -5.561  -5.401 -16.737  1.00  0.00           C 
ATOM   1267  C   PRO A  83      -6.128  -4.285 -17.654  1.00  0.00           C 
ATOM   1268  O   PRO A  83      -5.462  -3.276 -17.889  1.00  0.00           O 
ATOM   1269  CB  PRO A  83      -4.564  -6.314 -17.502  1.00  0.00           C 
ATOM   1270  CG  PRO A  83      -4.762  -7.675 -16.899  1.00  0.00           C 
ATOM   1271  CD  PRO A  83      -6.237  -7.763 -16.594  1.00  0.00           C 
ATOM   1272  HA  PRO A  83      -5.050  -4.931 -15.903  1.00  0.00           H 
ATOM   1273 2HB  PRO A  83      -3.547  -5.962 -17.357  1.00  0.00           H 
ATOM   1274 1HB  PRO A  83      -4.790  -6.317 -18.566  1.00  0.00           H 
ATOM   1275 2HG  PRO A  83      -4.178  -7.773 -15.987  1.00  0.00           H 
ATOM   1276 1HG  PRO A  83      -4.471  -8.445 -17.609  1.00  0.00           H 
ATOM   1277 2HD  PRO A  83      -6.416  -8.432 -15.762  1.00  0.00           H 
ATOM   1278 1HD  PRO A  83      -6.795  -8.092 -17.467  1.00  0.00           H 
ATOM   1279  N   LYS A  84      -7.366  -4.481 -18.138  1.00  0.00           N 
ATOM   1280  CA  LYS A  84      -8.084  -3.502 -18.983  1.00  0.00           C 
ATOM   1281  C   LYS A  84      -8.407  -2.216 -18.189  1.00  0.00           C 
ATOM   1282  O   LYS A  84      -8.498  -1.127 -18.763  1.00  0.00           O 
ATOM   1283  CB  LYS A  84      -9.385  -4.143 -19.541  1.00  0.00           C 
ATOM   1284  CG  LYS A  84      -9.183  -5.533 -20.199  1.00  0.00           C 
ATOM   1285  CD  LYS A  84      -8.175  -5.517 -21.380  1.00  0.00           C 
ATOM   1286  CE  LYS A  84      -8.673  -4.711 -22.596  1.00  0.00           C 
ATOM   1287  NZ  LYS A  84      -9.898  -5.301 -23.192  1.00  0.00           N 
ATOM   1288  H   LYS A  84      -7.818  -5.316 -17.913  1.00  0.00           H 
ATOM   1289  HA  LYS A  84      -7.434  -3.246 -19.814  1.00  0.00           H 
ATOM   1290 2HB  LYS A  84      -9.814  -3.474 -20.280  1.00  0.00           H 
ATOM   1291 1HB  LYS A  84     -10.097  -4.259 -18.727  1.00  0.00           H 
ATOM   1292 2HG  LYS A  84     -10.143  -5.890 -20.561  1.00  0.00           H 
ATOM   1293 1HG  LYS A  84      -8.818  -6.223 -19.443  1.00  0.00           H 
ATOM   1294 2HD  LYS A  84      -7.991  -6.540 -21.691  1.00  0.00           H 
ATOM   1295 1HD  LYS A  84      -7.238  -5.085 -21.038  1.00  0.00           H 
ATOM   1296 2HE  LYS A  84      -7.897  -4.692 -23.351  1.00  0.00           H 
ATOM   1297 1HE  LYS A  84      -8.893  -3.697 -22.288  1.00  0.00           H 
ATOM   1298 1HZ  LYS A  84      -9.713  -6.277 -23.501  1.00  0.00           H 
ATOM   1299 2HZ  LYS A  84     -10.203  -4.747 -24.013  1.00  0.00           H 
ATOM   1300 3HZ  LYS A  84     -10.667  -5.311 -22.493  1.00  0.00           H 
ATOM   1301  N   PHE A  85      -8.575  -2.382 -16.861  1.00  0.00           N 
ATOM   1302  CA  PHE A  85      -8.742  -1.277 -15.890  1.00  0.00           C 
ATOM   1303  C   PHE A  85      -7.506  -0.352 -15.878  1.00  0.00           C 
ATOM   1304  O   PHE A  85      -7.622   0.863 -15.679  1.00  0.00           O 
ATOM   1305  CB  PHE A  85      -8.978  -1.887 -14.478  1.00  0.00           C 
ATOM   1306  CG  PHE A  85      -9.107  -0.877 -13.331  1.00  0.00           C 
ATOM   1307  CD1 PHE A  85      -8.052  -0.657 -12.436  1.00  0.00           C 
ATOM   1308  CD2 PHE A  85     -10.289  -0.165 -13.138  1.00  0.00           C 
ATOM   1309  CE1 PHE A  85      -8.176   0.253 -11.400  1.00  0.00           C 
ATOM   1310  CE2 PHE A  85     -10.407   0.744 -12.103  1.00  0.00           C 
ATOM   1311  CZ  PHE A  85      -9.357   0.949 -11.231  1.00  0.00           C 
ATOM   1312  H   PHE A  85      -8.606  -3.301 -16.518  1.00  0.00           H 
ATOM   1313  HA  PHE A  85      -9.614  -0.702 -16.182  1.00  0.00           H 
ATOM   1314 2HB  PHE A  85      -8.154  -2.559 -14.248  1.00  0.00           H 
ATOM   1315 1HB  PHE A  85      -9.888  -2.475 -14.505  1.00  0.00           H 
ATOM   1316  HD1 PHE A  85      -7.122  -1.200 -12.563  1.00  0.00           H 
ATOM   1317  HD2 PHE A  85     -11.121  -0.319 -13.819  1.00  0.00           H 
ATOM   1318  HE1 PHE A  85      -7.351   0.413 -10.718  1.00  0.00           H 
ATOM   1319  HE2 PHE A  85     -11.330   1.289 -11.973  1.00  0.00           H 
ATOM   1320  HZ  PHE A  85      -9.458   1.659 -10.423  1.00  0.00           H 
ATOM   1321  N   GLY A  86      -6.328  -0.944 -16.131  1.00  0.00           N 
ATOM   1322  CA  GLY A  86      -5.050  -0.245 -16.002  1.00  0.00           C 
ATOM   1323  C   GLY A  86      -4.503  -0.368 -14.593  1.00  0.00           C 
ATOM   1324  O   GLY A  86      -4.081   0.620 -13.984  1.00  0.00           O 
ATOM   1325  H   GLY A  86      -6.329  -1.878 -16.417  1.00  0.00           H 
ATOM   1326 2HA  GLY A  86      -5.170   0.803 -16.256  1.00  0.00           H 
ATOM   1327 1HA  GLY A  86      -4.345  -0.693 -16.690  1.00  0.00           H 
ATOM   1328  N   ALA A  87      -4.539  -1.604 -14.072  1.00  0.00           N 
ATOM   1329  CA  ALA A  87      -4.053  -1.917 -12.723  1.00  0.00           C 
ATOM   1330  C   ALA A  87      -2.509  -1.847 -12.673  1.00  0.00           C 
ATOM   1331  O   ALA A  87      -1.939  -0.888 -12.143  1.00  0.00           O 
ATOM   1332  CB  ALA A  87      -4.589  -3.294 -12.286  1.00  0.00           C 
ATOM   1333  H   ALA A  87      -4.914  -2.326 -14.612  1.00  0.00           H 
ATOM   1334  HA  ALA A  87      -4.457  -1.173 -12.041  1.00  0.00           H 
ATOM   1335 1HB  ALA A  87      -5.670  -3.300 -12.342  1.00  0.00           H 
ATOM   1336 2HB  ALA A  87      -4.286  -3.499 -11.268  1.00  0.00           H 
ATOM   1337 3HB  ALA A  87      -4.193  -4.065 -12.937  1.00  0.00           H 
ATOM   1338  N   ILE A  88      -1.840  -2.864 -13.253  1.00  0.00           N 
ATOM   1339  CA  ILE A  88      -0.359  -2.942 -13.308  1.00  0.00           C 
ATOM   1340  C   ILE A  88       0.151  -2.513 -14.703  1.00  0.00           C 
ATOM   1341  O   ILE A  88       1.319  -2.169 -14.873  1.00  0.00           O 
ATOM   1342  CB  ILE A  88       0.129  -4.404 -12.954  1.00  0.00           C 
ATOM   1343  CG1 ILE A  88       1.685  -4.461 -12.764  1.00  0.00           C 
ATOM   1344  CG2 ILE A  88      -0.354  -5.429 -14.016  1.00  0.00           C 
ATOM   1345  CD1 ILE A  88       2.242  -5.819 -12.370  1.00  0.00           C 
ATOM   1346  H   ILE A  88      -2.352  -3.595 -13.648  1.00  0.00           H 
ATOM   1347  HA  ILE A  88       0.050  -2.255 -12.563  1.00  0.00           H 
ATOM   1348  HB  ILE A  88      -0.342  -4.674 -12.012  1.00  0.00           H 
ATOM   1349 2HG1 ILE A  88       1.976  -3.754 -11.993  1.00  0.00           H 
ATOM   1350 1HG1 ILE A  88       2.167  -4.182 -13.689  1.00  0.00           H 
ATOM   1351 1HG2 ILE A  88      -0.052  -6.432 -13.733  1.00  0.00           H 
ATOM   1352 2HG2 ILE A  88       0.078  -5.192 -14.981  1.00  0.00           H 
ATOM   1353 3HG2 ILE A  88      -1.434  -5.393 -14.097  1.00  0.00           H 
ATOM   1354 1HD1 ILE A  88       1.785  -6.150 -11.448  1.00  0.00           H 
ATOM   1355 2HD1 ILE A  88       3.312  -5.743 -12.228  1.00  0.00           H 
ATOM   1356 3HD1 ILE A  88       2.037  -6.535 -13.152  1.00  0.00           H 
ATOM   1357  N   THR A  89      -0.758  -2.527 -15.689  1.00  0.00           N 
ATOM   1358  CA  THR A  89      -0.455  -2.236 -17.105  1.00  0.00           C 
ATOM   1359  C   THR A  89      -0.475  -0.723 -17.419  1.00  0.00           C 
ATOM   1360  O   THR A  89      -0.211  -0.314 -18.558  1.00  0.00           O 
ATOM   1361  CB  THR A  89      -1.482  -3.000 -17.999  1.00  0.00           C 
ATOM   1362  OG1 THR A  89      -2.806  -2.780 -17.479  1.00  0.00           O 
ATOM   1363  CG2 THR A  89      -1.195  -4.515 -18.037  1.00  0.00           C 
ATOM   1364  H   THR A  89      -1.684  -2.747 -15.462  1.00  0.00           H 
ATOM   1365  HA  THR A  89       0.540  -2.616 -17.327  1.00  0.00           H 
ATOM   1366  HB  THR A  89      -1.434  -2.613 -19.014  1.00  0.00           H 
ATOM   1367  HG1 THR A  89      -3.365  -2.408 -18.175  1.00  0.00           H 
ATOM   1368 1HG2 THR A  89      -1.239  -4.921 -17.034  1.00  0.00           H 
ATOM   1369 2HG2 THR A  89      -0.208  -4.695 -18.450  1.00  0.00           H 
ATOM   1370 3HG2 THR A  89      -1.933  -5.010 -18.654  1.00  0.00           H 
ATOM   1371  N   ARG A  90      -0.800   0.098 -16.406  1.00  0.00           N 
ATOM   1372  CA  ARG A  90      -0.725   1.567 -16.492  1.00  0.00           C 
ATOM   1373  C   ARG A  90       0.533   2.016 -15.742  1.00  0.00           C 
ATOM   1374  O   ARG A  90       0.660   1.732 -14.540  1.00  0.00           O 
ATOM   1375  CB  ARG A  90      -1.994   2.212 -15.854  1.00  0.00           C 
ATOM   1376  CG  ARG A  90      -2.208   3.716 -16.171  1.00  0.00           C 
ATOM   1377  CD  ARG A  90      -2.627   3.955 -17.637  1.00  0.00           C 
ATOM   1378  NE  ARG A  90      -2.886   5.381 -17.933  1.00  0.00           N 
ATOM   1379  CZ  ARG A  90      -3.411   5.851 -19.080  1.00  0.00           C 
ATOM   1380  NH1 ARG A  90      -3.732   5.030 -20.072  1.00  0.00           N 
ATOM   1381  NH2 ARG A  90      -3.611   7.150 -19.221  1.00  0.00           N 
ATOM   1382  H   ARG A  90      -1.100  -0.300 -15.564  1.00  0.00           H 
ATOM   1383  HA  ARG A  90      -0.652   1.865 -17.535  1.00  0.00           H 
ATOM   1384 2HB  ARG A  90      -1.945   2.098 -14.774  1.00  0.00           H 
ATOM   1385 1HB  ARG A  90      -2.865   1.671 -16.207  1.00  0.00           H 
ATOM   1386 2HG  ARG A  90      -1.281   4.250 -15.978  1.00  0.00           H 
ATOM   1387 1HG  ARG A  90      -2.981   4.112 -15.519  1.00  0.00           H 
ATOM   1388 2HD  ARG A  90      -3.526   3.383 -17.842  1.00  0.00           H 
ATOM   1389 1HD  ARG A  90      -1.831   3.607 -18.289  1.00  0.00           H 
ATOM   1390  HE  ARG A  90      -2.664   6.028 -17.227  1.00  0.00           H 
ATOM   1391 1HH1 ARG A  90      -3.587   4.043 -19.973  1.00  0.00           H 
ATOM   1392 2HH1 ARG A  90      -4.131   5.389 -20.918  1.00  0.00           H 
ATOM   1393 1HH2 ARG A  90      -3.378   7.777 -18.472  1.00  0.00           H 
ATOM   1394 2HH2 ARG A  90      -4.001   7.513 -20.069  1.00  0.00           H 
ATOM   1395  N   VAL A  91       1.483   2.667 -16.442  1.00  0.00           N 
ATOM   1396  CA  VAL A  91       2.668   3.246 -15.787  1.00  0.00           C 
ATOM   1397  C   VAL A  91       2.232   4.461 -14.935  1.00  0.00           C 
ATOM   1398  O   VAL A  91       1.983   5.559 -15.451  1.00  0.00           O 
ATOM   1399  CB  VAL A  91       3.833   3.618 -16.804  1.00  0.00           C 
ATOM   1400  CG1 VAL A  91       4.455   2.343 -17.425  1.00  0.00           C 
ATOM   1401  CG2 VAL A  91       3.373   4.587 -17.924  1.00  0.00           C 
ATOM   1402  H   VAL A  91       1.383   2.756 -17.409  1.00  0.00           H 
ATOM   1403  HA  VAL A  91       3.061   2.484 -15.106  1.00  0.00           H 
ATOM   1404  HB  VAL A  91       4.616   4.116 -16.232  1.00  0.00           H 
ATOM   1405 1HG1 VAL A  91       4.830   1.698 -16.639  1.00  0.00           H 
ATOM   1406 2HG1 VAL A  91       5.277   2.614 -18.077  1.00  0.00           H 
ATOM   1407 3HG1 VAL A  91       3.707   1.809 -17.998  1.00  0.00           H 
ATOM   1408 1HG2 VAL A  91       2.584   4.126 -18.506  1.00  0.00           H 
ATOM   1409 2HG2 VAL A  91       4.205   4.823 -18.575  1.00  0.00           H 
ATOM   1410 3HG2 VAL A  91       3.002   5.502 -17.483  1.00  0.00           H 
ATOM   1411  N   HIS A  92       2.041   4.214 -13.622  1.00  0.00           N 
ATOM   1412  CA  HIS A  92       1.611   5.252 -12.673  1.00  0.00           C 
ATOM   1413  C   HIS A  92       2.725   6.301 -12.547  1.00  0.00           C 
ATOM   1414  O   HIS A  92       3.779   6.029 -11.982  1.00  0.00           O 
ATOM   1415  CB  HIS A  92       1.242   4.649 -11.290  1.00  0.00           C 
ATOM   1416  CG  HIS A  92       0.083   3.671 -11.333  1.00  0.00           C 
ATOM   1417  ND1 HIS A  92      -1.236   4.053 -11.206  1.00  0.00           N 
ATOM   1418  CD2 HIS A  92       0.057   2.322 -11.494  1.00  0.00           C 
ATOM   1419  CE1 HIS A  92      -2.014   2.989 -11.292  1.00  0.00           C 
ATOM   1420  NE2 HIS A  92      -1.253   1.929 -11.465  1.00  0.00           N 
ATOM   1421  H   HIS A  92       2.198   3.305 -13.292  1.00  0.00           H 
ATOM   1422  HA  HIS A  92       0.724   5.731 -13.090  1.00  0.00           H 
ATOM   1423 2HB  HIS A  92       0.968   5.458 -10.614  1.00  0.00           H 
ATOM   1424 1HB  HIS A  92       2.102   4.133 -10.883  1.00  0.00           H 
ATOM   1425  HD1 HIS A  92      -1.555   4.969 -11.050  1.00  0.00           H 
ATOM   1426  HD2 HIS A  92       0.915   1.678 -11.627  1.00  0.00           H 
ATOM   1427  HE1 HIS A  92      -3.092   2.988 -11.233  1.00  0.00           H 
ATOM   1428  HE2 HIS A  92      -1.559   1.004 -11.383  1.00  0.00           H 
ATOM   1429  N   LYS A  93       2.492   7.482 -13.133  1.00  0.00           N 
ATOM   1430  CA  LYS A  93       3.489   8.568 -13.188  1.00  0.00           C 
ATOM   1431  C   LYS A  93       3.647   9.235 -11.810  1.00  0.00           C 
ATOM   1432  O   LYS A  93       4.724   9.737 -11.469  1.00  0.00           O 
ATOM   1433  CB  LYS A  93       3.075   9.600 -14.267  1.00  0.00           C 
ATOM   1434  CG  LYS A  93       2.959   9.017 -15.694  1.00  0.00           C 
ATOM   1435  CD  LYS A  93       2.605  10.069 -16.786  1.00  0.00           C 
ATOM   1436  CE  LYS A  93       1.178  10.666 -16.665  1.00  0.00           C 
ATOM   1437  NZ  LYS A  93       1.033  11.660 -15.562  1.00  0.00           N 
ATOM   1438  H   LYS A  93       1.610   7.638 -13.536  1.00  0.00           H 
ATOM   1439  HA  LYS A  93       4.443   8.132 -13.472  1.00  0.00           H 
ATOM   1440 2HB  LYS A  93       3.807  10.403 -14.287  1.00  0.00           H 
ATOM   1441 1HB  LYS A  93       2.111  10.022 -13.996  1.00  0.00           H 
ATOM   1442 2HG  LYS A  93       2.193   8.246 -15.689  1.00  0.00           H 
ATOM   1443 1HG  LYS A  93       3.908   8.558 -15.956  1.00  0.00           H 
ATOM   1444 2HD  LYS A  93       2.700   9.596 -17.760  1.00  0.00           H 
ATOM   1445 1HD  LYS A  93       3.319  10.882 -16.729  1.00  0.00           H 
ATOM   1446 2HE  LYS A  93       0.476   9.859 -16.496  1.00  0.00           H 
ATOM   1447 1HE  LYS A  93       0.925  11.158 -17.595  1.00  0.00           H 
ATOM   1448 1HZ  LYS A  93       1.721  12.431 -15.678  1.00  0.00           H 
ATOM   1449 2HZ  LYS A  93       1.192  11.205 -14.642  1.00  0.00           H 
ATOM   1450 3HZ  LYS A  93       0.076  12.062 -15.570  1.00  0.00           H 
ATOM   1451  N   GLU A  94       2.556   9.207 -11.022  1.00  0.00           N 
ATOM   1452  CA  GLU A  94       2.523   9.729  -9.643  1.00  0.00           C 
ATOM   1453  C   GLU A  94       2.995   8.671  -8.620  1.00  0.00           C 
ATOM   1454  O   GLU A  94       2.924   8.912  -7.406  1.00  0.00           O 
ATOM   1455  CB  GLU A  94       1.092  10.213  -9.311  1.00  0.00           C 
ATOM   1456  CG  GLU A  94       0.583  11.336 -10.238  1.00  0.00           C 
ATOM   1457  CD  GLU A  94      -0.884  11.706  -9.996  1.00  0.00           C 
ATOM   1458  OE1 GLU A  94      -1.771  11.134 -10.672  1.00  0.00           O 
ATOM   1459  OE2 GLU A  94      -1.167  12.561  -9.125  1.00  0.00           O 
ATOM   1460  H   GLU A  94       1.732   8.819 -11.388  1.00  0.00           H 
ATOM   1461  HA  GLU A  94       3.200  10.577  -9.584  1.00  0.00           H 
ATOM   1462 2HB  GLU A  94       1.072  10.578  -8.288  1.00  0.00           H 
ATOM   1463 1HB  GLU A  94       0.413   9.368  -9.391  1.00  0.00           H 
ATOM   1464 2HG  GLU A  94       0.696  11.002 -11.267  1.00  0.00           H 
ATOM   1465 1HG  GLU A  94       1.199  12.220 -10.093  1.00  0.00           H 
ATOM   1466  N   TYR A  95       3.476   7.503  -9.118  1.00  0.00           N 
ATOM   1467  CA  TYR A  95       4.135   6.486  -8.279  1.00  0.00           C 
ATOM   1468  C   TYR A  95       5.365   7.088  -7.593  1.00  0.00           C 
ATOM   1469  O   TYR A  95       5.620   6.779  -6.446  1.00  0.00           O 
ATOM   1470  CB  TYR A  95       4.545   5.236  -9.115  1.00  0.00           C 
ATOM   1471  CG  TYR A  95       5.515   4.274  -8.392  1.00  0.00           C 
ATOM   1472  CD1 TYR A  95       6.863   4.178  -8.774  1.00  0.00           C 
ATOM   1473  CD2 TYR A  95       5.098   3.507  -7.302  1.00  0.00           C 
ATOM   1474  CE1 TYR A  95       7.742   3.349  -8.104  1.00  0.00           C 
ATOM   1475  CE2 TYR A  95       5.978   2.674  -6.635  1.00  0.00           C 
ATOM   1476  CZ  TYR A  95       7.293   2.602  -7.033  1.00  0.00           C 
ATOM   1477  OH  TYR A  95       8.162   1.777  -6.358  1.00  0.00           O 
ATOM   1478  H   TYR A  95       3.386   7.329 -10.076  1.00  0.00           H 
ATOM   1479  HA  TYR A  95       3.423   6.180  -7.516  1.00  0.00           H 
ATOM   1480 2HB  TYR A  95       5.016   5.567 -10.034  1.00  0.00           H 
ATOM   1481 1HB  TYR A  95       3.652   4.675  -9.373  1.00  0.00           H 
ATOM   1482  HD1 TYR A  95       7.216   4.759  -9.619  1.00  0.00           H 
ATOM   1483  HD2 TYR A  95       4.065   3.558  -6.987  1.00  0.00           H 
ATOM   1484  HE1 TYR A  95       8.780   3.294  -8.417  1.00  0.00           H 
ATOM   1485  HE2 TYR A  95       5.631   2.089  -5.797  1.00  0.00           H 
ATOM   1486  HH  TYR A  95       7.726   0.944  -6.165  1.00  0.00           H 
ATOM   1487  N   ASP A  96       6.110   7.947  -8.322  1.00  0.00           N 
ATOM   1488  CA  ASP A  96       7.323   8.614  -7.801  1.00  0.00           C 
ATOM   1489  C   ASP A  96       7.007   9.511  -6.587  1.00  0.00           C 
ATOM   1490  O   ASP A  96       7.827   9.639  -5.678  1.00  0.00           O 
ATOM   1491  CB  ASP A  96       8.008   9.445  -8.910  1.00  0.00           C 
ATOM   1492  CG  ASP A  96       8.579   8.562 -10.026  1.00  0.00           C 
ATOM   1493  OD1 ASP A  96       7.841   8.243 -10.981  1.00  0.00           O 
ATOM   1494  OD2 ASP A  96       9.759   8.151  -9.938  1.00  0.00           O 
ATOM   1495  H   ASP A  96       5.848   8.128  -9.252  1.00  0.00           H 
ATOM   1496  HA  ASP A  96       8.009   7.832  -7.481  1.00  0.00           H 
ATOM   1497 2HB  ASP A  96       8.818  10.029  -8.479  1.00  0.00           H 
ATOM   1498 1HB  ASP A  96       7.280  10.130  -9.336  1.00  0.00           H 
ATOM   1499  N   ALA A  97       5.803  10.107  -6.585  1.00  0.00           N 
ATOM   1500  CA  ALA A  97       5.326  10.970  -5.487  1.00  0.00           C 
ATOM   1501  C   ALA A  97       5.018  10.140  -4.217  1.00  0.00           C 
ATOM   1502  O   ALA A  97       5.357  10.536  -3.100  1.00  0.00           O 
ATOM   1503  CB  ALA A  97       4.099  11.770  -5.945  1.00  0.00           C 
ATOM   1504  H   ALA A  97       5.212   9.961  -7.353  1.00  0.00           H 
ATOM   1505  HA  ALA A  97       6.119  11.679  -5.254  1.00  0.00           H 
ATOM   1506 1HB  ALA A  97       3.784  12.445  -5.157  1.00  0.00           H 
ATOM   1507 2HB  ALA A  97       3.286  11.095  -6.178  1.00  0.00           H 
ATOM   1508 3HB  ALA A  97       4.344  12.345  -6.829  1.00  0.00           H 
ATOM   1509  N   MET A  98       4.338   9.006  -4.405  1.00  0.00           N 
ATOM   1510  CA  MET A  98       4.095   8.012  -3.331  1.00  0.00           C 
ATOM   1511  C   MET A  98       5.418   7.385  -2.814  1.00  0.00           C 
ATOM   1512  O   MET A  98       5.594   7.159  -1.619  1.00  0.00           O 
ATOM   1513  CB  MET A  98       3.161   6.917  -3.897  1.00  0.00           C 
ATOM   1514  CG  MET A  98       2.554   5.951  -2.868  1.00  0.00           C 
ATOM   1515  SD  MET A  98       1.484   4.703  -3.631  1.00  0.00           S 
ATOM   1516  CE  MET A  98       0.508   5.665  -4.781  1.00  0.00           C 
ATOM   1517  H   MET A  98       3.896   8.869  -5.270  1.00  0.00           H 
ATOM   1518  HA  MET A  98       3.598   8.517  -2.511  1.00  0.00           H 
ATOM   1519 2HB  MET A  98       3.715   6.332  -4.624  1.00  0.00           H 
ATOM   1520 1HB  MET A  98       2.341   7.403  -4.410  1.00  0.00           H 
ATOM   1521 2HG  MET A  98       1.971   6.512  -2.151  1.00  0.00           H 
ATOM   1522 1HG  MET A  98       3.355   5.437  -2.351  1.00  0.00           H 
ATOM   1523 1HE  MET A  98       1.155   6.105  -5.526  1.00  0.00           H 
ATOM   1524 2HE  MET A  98      -0.012   6.446  -4.247  1.00  0.00           H 
ATOM   1525 3HE  MET A  98      -0.213   5.023  -5.265  1.00  0.00           H 
ATOM   1526  N   PHE A  99       6.315   7.121  -3.766  1.00  0.00           N 
ATOM   1527  CA  PHE A  99       7.653   6.536  -3.543  1.00  0.00           C 
ATOM   1528  C   PHE A  99       8.479   7.417  -2.592  1.00  0.00           C 
ATOM   1529  O   PHE A  99       9.036   6.926  -1.598  1.00  0.00           O 
ATOM   1530  CB  PHE A  99       8.364   6.379  -4.916  1.00  0.00           C 
ATOM   1531  CG  PHE A  99       9.773   5.779  -4.878  1.00  0.00           C 
ATOM   1532  CD1 PHE A  99      10.906   6.597  -4.812  1.00  0.00           C 
ATOM   1533  CD2 PHE A  99       9.962   4.397  -4.912  1.00  0.00           C 
ATOM   1534  CE1 PHE A  99      12.172   6.051  -4.782  1.00  0.00           C 
ATOM   1535  CE2 PHE A  99      11.231   3.855  -4.884  1.00  0.00           C 
ATOM   1536  CZ  PHE A  99      12.335   4.680  -4.817  1.00  0.00           C 
ATOM   1537  H   PHE A  99       6.034   7.320  -4.670  1.00  0.00           H 
ATOM   1538  HA  PHE A  99       7.520   5.556  -3.096  1.00  0.00           H 
ATOM   1539 2HB  PHE A  99       8.428   7.356  -5.384  1.00  0.00           H 
ATOM   1540 1HB  PHE A  99       7.752   5.746  -5.550  1.00  0.00           H 
ATOM   1541  HD1 PHE A  99      10.785   7.675  -4.786  1.00  0.00           H 
ATOM   1542  HD2 PHE A  99       9.097   3.743  -4.964  1.00  0.00           H 
ATOM   1543  HE1 PHE A  99      13.041   6.698  -4.731  1.00  0.00           H 
ATOM   1544  HE2 PHE A  99      11.361   2.784  -4.912  1.00  0.00           H 
ATOM   1545  HZ  PHE A  99      13.331   4.252  -4.794  1.00  0.00           H 
ATOM   1546  N   GLU A 100       8.531   8.729  -2.905  1.00  0.00           N 
ATOM   1547  CA  GLU A 100       9.299   9.709  -2.124  1.00  0.00           C 
ATOM   1548  C   GLU A 100       8.654   9.971  -0.745  1.00  0.00           C 
ATOM   1549  O   GLU A 100       9.364  10.256   0.232  1.00  0.00           O 
ATOM   1550  CB  GLU A 100       9.487  11.024  -2.904  1.00  0.00           C 
ATOM   1551  CG  GLU A 100       8.188  11.775  -3.220  1.00  0.00           C 
ATOM   1552  CD  GLU A 100       8.413  13.113  -3.918  1.00  0.00           C 
ATOM   1553  OE1 GLU A 100       8.721  13.118  -5.126  1.00  0.00           O 
ATOM   1554  OE2 GLU A 100       8.297  14.167  -3.256  1.00  0.00           O 
ATOM   1555  H   GLU A 100       8.051   9.040  -3.699  1.00  0.00           H 
ATOM   1556  HA  GLU A 100      10.279   9.274  -1.958  1.00  0.00           H 
ATOM   1557 2HB  GLU A 100       9.985  10.797  -3.843  1.00  0.00           H 
ATOM   1558 1HB  GLU A 100      10.134  11.680  -2.329  1.00  0.00           H 
ATOM   1559 2HG  GLU A 100       7.653  11.944  -2.290  1.00  0.00           H 
ATOM   1560 1HG  GLU A 100       7.572  11.151  -3.861  1.00  0.00           H 
ATOM   1561  N   ASP A 101       7.313   9.859  -0.678  1.00  0.00           N 
ATOM   1562  CA  ASP A 101       6.566   9.938   0.591  1.00  0.00           C 
ATOM   1563  C   ASP A 101       7.044   8.829   1.546  1.00  0.00           C 
ATOM   1564  O   ASP A 101       7.445   9.103   2.675  1.00  0.00           O 
ATOM   1565  CB  ASP A 101       5.037   9.810   0.338  1.00  0.00           C 
ATOM   1566  CG  ASP A 101       4.196   9.798   1.637  1.00  0.00           C 
ATOM   1567  OD1 ASP A 101       3.781  10.883   2.104  1.00  0.00           O 
ATOM   1568  OD2 ASP A 101       3.970   8.708   2.209  1.00  0.00           O 
ATOM   1569  H   ASP A 101       6.814   9.717  -1.511  1.00  0.00           H 
ATOM   1570  HA  ASP A 101       6.773  10.908   1.038  1.00  0.00           H 
ATOM   1571 2HB  ASP A 101       4.845   8.893  -0.211  1.00  0.00           H 
ATOM   1572 1HB  ASP A 101       4.716  10.646  -0.274  1.00  0.00           H 
ATOM   1573  N   ILE A 102       6.995   7.586   1.045  1.00  0.00           N 
ATOM   1574  CA  ILE A 102       7.371   6.379   1.795  1.00  0.00           C 
ATOM   1575  C   ILE A 102       8.872   6.366   2.192  1.00  0.00           C 
ATOM   1576  O   ILE A 102       9.186   5.946   3.296  1.00  0.00           O 
ATOM   1577  CB  ILE A 102       6.952   5.080   0.992  1.00  0.00           C 
ATOM   1578  CG1 ILE A 102       5.390   5.028   0.855  1.00  0.00           C 
ATOM   1579  CG2 ILE A 102       7.492   3.774   1.638  1.00  0.00           C 
ATOM   1580  CD1 ILE A 102       4.835   3.822   0.114  1.00  0.00           C 
ATOM   1581  H   ILE A 102       6.629   7.478   0.146  1.00  0.00           H 
ATOM   1582  HA  ILE A 102       6.786   6.395   2.715  1.00  0.00           H 
ATOM   1583  HB  ILE A 102       7.387   5.157  -0.004  1.00  0.00           H 
ATOM   1584 2HG1 ILE A 102       5.054   5.916   0.329  1.00  0.00           H 
ATOM   1585 1HG1 ILE A 102       4.947   5.024   1.841  1.00  0.00           H 
ATOM   1586 1HG2 ILE A 102       7.104   3.678   2.645  1.00  0.00           H 
ATOM   1587 2HG2 ILE A 102       8.571   3.803   1.677  1.00  0.00           H 
ATOM   1588 3HG2 ILE A 102       7.184   2.916   1.052  1.00  0.00           H 
ATOM   1589 1HD1 ILE A 102       5.238   3.791  -0.888  1.00  0.00           H 
ATOM   1590 2HD1 ILE A 102       3.759   3.900   0.063  1.00  0.00           H 
ATOM   1591 3HD1 ILE A 102       5.102   2.915   0.639  1.00  0.00           H 
ATOM   1592  N   ARG A 103       9.792   6.849   1.319  1.00  0.00           N 
ATOM   1593  CA  ARG A 103      11.250   6.864   1.657  1.00  0.00           C 
ATOM   1594  C   ARG A 103      11.562   7.892   2.760  1.00  0.00           C 
ATOM   1595  O   ARG A 103      12.472   7.680   3.572  1.00  0.00           O 
ATOM   1596  CB  ARG A 103      12.169   7.019   0.397  1.00  0.00           C 
ATOM   1597  CG  ARG A 103      12.073   8.333  -0.411  1.00  0.00           C 
ATOM   1598  CD  ARG A 103      12.959   9.483   0.108  1.00  0.00           C 
ATOM   1599  NE  ARG A 103      12.919  10.630  -0.821  1.00  0.00           N 
ATOM   1600  CZ  ARG A 103      12.215  11.763  -0.650  1.00  0.00           C 
ATOM   1601  NH1 ARG A 103      11.569  12.003   0.477  1.00  0.00           N 
ATOM   1602  NH2 ARG A 103      12.164  12.658  -1.621  1.00  0.00           N 
ATOM   1603  H   ARG A 103       9.473   7.177   0.456  1.00  0.00           H 
ATOM   1604  HA  ARG A 103      11.459   5.881   2.085  1.00  0.00           H 
ATOM   1605 2HB  ARG A 103      11.930   6.200  -0.279  1.00  0.00           H 
ATOM   1606 1HB  ARG A 103      13.200   6.891   0.706  1.00  0.00           H 
ATOM   1607 2HG  ARG A 103      11.041   8.664  -0.402  1.00  0.00           H 
ATOM   1608 1HG  ARG A 103      12.356   8.130  -1.438  1.00  0.00           H 
ATOM   1609 2HD  ARG A 103      13.982   9.132   0.186  1.00  0.00           H 
ATOM   1610 1HD  ARG A 103      12.612   9.791   1.089  1.00  0.00           H 
ATOM   1611  HE  ARG A 103      13.433  10.530  -1.655  1.00  0.00           H 
ATOM   1612 1HH1 ARG A 103      11.604  11.347   1.228  1.00  0.00           H 
ATOM   1613 2HH1 ARG A 103      11.022  12.838   0.570  1.00  0.00           H 
ATOM   1614 1HH2 ARG A 103      12.657  12.497  -2.480  1.00  0.00           H 
ATOM   1615 2HH2 ARG A 103      11.623  13.497  -1.507  1.00  0.00           H 
ATOM   1616  N   ALA A 104      10.784   8.990   2.798  1.00  0.00           N 
ATOM   1617  CA  ALA A 104      10.911  10.016   3.848  1.00  0.00           C 
ATOM   1618  C   ALA A 104      10.304   9.512   5.169  1.00  0.00           C 
ATOM   1619  O   ALA A 104      10.874   9.709   6.237  1.00  0.00           O 
ATOM   1620  CB  ALA A 104      10.240  11.320   3.405  1.00  0.00           C 
ATOM   1621  H   ALA A 104      10.064   9.084   2.136  1.00  0.00           H 
ATOM   1622  HA  ALA A 104      11.972  10.211   3.998  1.00  0.00           H 
ATOM   1623 1HB  ALA A 104      10.365  12.076   4.170  1.00  0.00           H 
ATOM   1624 2HB  ALA A 104       9.183  11.149   3.236  1.00  0.00           H 
ATOM   1625 3HB  ALA A 104      10.695  11.666   2.489  1.00  0.00           H 
ATOM   1626  N   LYS A 105       9.113   8.899   5.068  1.00  0.00           N 
ATOM   1627  CA  LYS A 105       8.384   8.275   6.193  1.00  0.00           C 
ATOM   1628  C   LYS A 105       9.185   7.149   6.885  1.00  0.00           C 
ATOM   1629  O   LYS A 105       9.189   7.047   8.112  1.00  0.00           O 
ATOM   1630  CB  LYS A 105       7.035   7.725   5.649  1.00  0.00           C 
ATOM   1631  CG  LYS A 105       5.956   7.453   6.708  1.00  0.00           C 
ATOM   1632  CD  LYS A 105       5.529   8.726   7.462  1.00  0.00           C 
ATOM   1633  CE  LYS A 105       4.398   8.459   8.459  1.00  0.00           C 
ATOM   1634  NZ  LYS A 105       3.126   8.088   7.782  1.00  0.00           N 
ATOM   1635  H   LYS A 105       8.628   8.947   4.226  1.00  0.00           H 
ATOM   1636  HA  LYS A 105       8.182   9.055   6.914  1.00  0.00           H 
ATOM   1637 2HB  LYS A 105       7.227   6.797   5.113  1.00  0.00           H 
ATOM   1638 1HB  LYS A 105       6.632   8.439   4.943  1.00  0.00           H 
ATOM   1639 2HG  LYS A 105       6.345   6.733   7.424  1.00  0.00           H 
ATOM   1640 1HG  LYS A 105       5.086   7.024   6.218  1.00  0.00           H 
ATOM   1641 2HD  LYS A 105       5.193   9.465   6.740  1.00  0.00           H 
ATOM   1642 1HD  LYS A 105       6.384   9.123   8.000  1.00  0.00           H 
ATOM   1643 2HE  LYS A 105       4.233   9.348   9.054  1.00  0.00           H 
ATOM   1644 1HE  LYS A 105       4.697   7.644   9.111  1.00  0.00           H 
ATOM   1645 1HZ  LYS A 105       2.791   8.877   7.190  1.00  0.00           H 
ATOM   1646 2HZ  LYS A 105       2.393   7.863   8.485  1.00  0.00           H 
ATOM   1647 3HZ  LYS A 105       3.273   7.258   7.178  1.00  0.00           H 
ATOM   1648  N   LEU A 106       9.835   6.303   6.073  1.00  0.00           N 
ATOM   1649  CA  LEU A 106      10.764   5.252   6.553  1.00  0.00           C 
ATOM   1650  C   LEU A 106      11.969   5.862   7.293  1.00  0.00           C 
ATOM   1651  O   LEU A 106      12.514   5.244   8.209  1.00  0.00           O 
ATOM   1652  CB  LEU A 106      11.261   4.346   5.371  1.00  0.00           C 
ATOM   1653  CG  LEU A 106      10.479   3.013   5.133  1.00  0.00           C 
ATOM   1654  CD1 LEU A 106       8.976   3.257   4.962  1.00  0.00           C 
ATOM   1655  CD2 LEU A 106      11.045   2.245   3.916  1.00  0.00           C 
ATOM   1656  H   LEU A 106       9.644   6.363   5.127  1.00  0.00           H 
ATOM   1657  HA  LEU A 106      10.197   4.645   7.258  1.00  0.00           H 
ATOM   1658 2HB  LEU A 106      12.303   4.089   5.538  1.00  0.00           H 
ATOM   1659 1HB  LEU A 106      11.213   4.932   4.459  1.00  0.00           H 
ATOM   1660  HG  LEU A 106      10.600   2.376   6.004  1.00  0.00           H 
ATOM   1661 1HD1 LEU A 106       8.585   3.768   5.831  1.00  0.00           H 
ATOM   1662 2HD1 LEU A 106       8.464   2.313   4.852  1.00  0.00           H 
ATOM   1663 3HD1 LEU A 106       8.800   3.863   4.081  1.00  0.00           H 
ATOM   1664 1HD2 LEU A 106      10.508   1.313   3.793  1.00  0.00           H 
ATOM   1665 2HD2 LEU A 106      12.094   2.027   4.073  1.00  0.00           H 
ATOM   1666 3HD2 LEU A 106      10.934   2.841   3.017  1.00  0.00           H 
ATOM   1667  N   HIS A 107      12.381   7.063   6.863  1.00  0.00           N 
ATOM   1668  CA  HIS A 107      13.452   7.827   7.525  1.00  0.00           C 
ATOM   1669  C   HIS A 107      12.904   8.573   8.768  1.00  0.00           C 
ATOM   1670  O   HIS A 107      13.686   8.991   9.639  1.00  0.00           O 
ATOM   1671  CB  HIS A 107      14.090   8.813   6.507  1.00  0.00           C 
ATOM   1672  CG  HIS A 107      15.289   9.570   7.026  1.00  0.00           C 
ATOM   1673  ND1 HIS A 107      16.525   8.984   7.199  1.00  0.00           N 
ATOM   1674  CD2 HIS A 107      15.429  10.855   7.429  1.00  0.00           C 
ATOM   1675  CE1 HIS A 107      17.367   9.873   7.681  1.00  0.00           C 
ATOM   1676  NE2 HIS A 107      16.728  11.018   7.828  1.00  0.00           N 
ATOM   1677  H   HIS A 107      11.949   7.450   6.073  1.00  0.00           H 
ATOM   1678  HA  HIS A 107      14.213   7.121   7.855  1.00  0.00           H 
ATOM   1679 2HB  HIS A 107      13.342   9.536   6.195  1.00  0.00           H 
ATOM   1680 1HB  HIS A 107      14.414   8.256   5.636  1.00  0.00           H 
ATOM   1681  HD1 HIS A 107      16.750   8.051   6.995  1.00  0.00           H 
ATOM   1682  HD2 HIS A 107      14.659  11.614   7.432  1.00  0.00           H 
ATOM   1683  HE1 HIS A 107      18.406   9.694   7.922  1.00  0.00           H 
ATOM   1684  HE2 HIS A 107      17.070  11.790   8.325  1.00  0.00           H 
END
