
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  136 (  998),  selected  136 , name 2f0x_F
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 2f0x_F.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_F      -       -           -
LGA    X     4_F      -       -           -
LGA    T     5_F      -       -           -
LGA    Q     6_F      -       -           -
LGA    S     7_F      -       -           -
LGA    L     8_F      -       -           -
LGA    R     9_F      -       -           -
LGA    E    10_F      -       -           -
LGA    V    11_F      -       -           -
LGA    I    12_F      T       6          3.397
LGA    K    13_F      D       7          3.879
LGA    -       -      F       8           -
LGA    -       -      F       9           -
LGA    -       -      G      10           -
LGA    -       -      L      11           -
LGA    A    14_F      T      12          4.059
LGA    X    15_F      I      13          4.504
LGA    T    16_F      -       -           -
LGA    K    17_F      -       -           -
LGA    A    18_F      P      14          2.661
LGA    R    19_F      -       -           -
LGA    N    20_F      -       -           -
LGA    F    21_F      F      15          2.935
LGA    E    22_F      M      16          3.035
LGA    R    23_F      Q      17          3.493
LGA    V    24_F      L      18          3.149
LGA    L    25_F      L      19          2.981
LGA    G    26_F      G      20          2.832
LGA    K    27_F      -       -           -
LGA    I    28_F      V      21          1.783
LGA    T    29_F      V      22          1.946
LGA    L    30_F      P      23          2.821
LGA    V    31_F      E      24          2.714
LGA    S    32_F      H      25          2.747
LGA    A    33_F      S      26          2.879
LGA    A    34_F      G      27          2.815
LGA    P    35_F      N      28          0.919
LGA    G    36_F      G      29          1.029
LGA    K    37_F      T      30          1.006
LGA    V    38_F      A      31          1.134
LGA    I    39_F      R      32          1.049
LGA    C    40_F      T      33          1.390
LGA    E    41_F      R      34          1.440
LGA    X    42_F      L      35          1.688
LGA    K    43_F      P      36          1.820
LGA    V    44_F      A      37          2.045
LGA    E    45_F      R      38          1.075
LGA    E    46_F      A      39          0.688
LGA    E    47_F      D      40          1.053
LGA    H    48_F      L      41          1.067
LGA    T    49_F      V      42          0.829
LGA    N    50_F      N      43          1.585
LGA    A    51_F      S      44          1.731
LGA    I    52_F      R      45          1.618
LGA    G    53_F      G      46          1.316
LGA    T    54_F      D      47          0.830
LGA    L    55_F      I      48          1.112
LGA    H    56_F      H      49          0.945
LGA    G    57_F      G      50          1.060
LGA    G    58_F      G      51          0.977
LGA    L    59_F      T      52          1.323
LGA    T    60_F      L      53          0.932
LGA    A    61_F      M      54          1.016
LGA    T    62_F      S      55          0.797
LGA    L    63_F      V      56          0.976
LGA    V    64_F      L      57          1.278
LGA    D    65_F      D      58          1.009
LGA    N    66_F      F      59          0.805
LGA    I    67_F      T      60          1.112
LGA    S    68_F      L      61          1.192
LGA    T    69_F      G      62          1.642
LGA    X    70_F      A      63          1.629
LGA    A    71_F      A      64          1.585
LGA    L    72_F      I      65          1.316
LGA    L    73_F      R      66          1.213
LGA    C    74_F      G      67          1.025
LGA    T    75_F      D      68          1.738
LGA    E    76_F      -       -           -
LGA    R    77_F      T      69          4.563
LGA    G    78_F      P      70          4.243
LGA    -       -      E      71           -
LGA    A    79_F      V      72          2.429
LGA    P    80_F      G      73          3.209
LGA    G    81_F      V      74          1.546
LGA    V    82_F      A      75          1.361
LGA    S    83_F      T      76          1.475
LGA    V    84_F      I      77          1.122
LGA    D    85_F      D      78          1.055
LGA    X    86_F      M      79          0.389
LGA    N    87_F      N      80          0.316
LGA    I    88_F      T      81          0.349
LGA    T    89_F      S      82          0.436
LGA    Y    90_F      F      83          0.390
LGA    X    91_F      M      84          0.235
LGA    S    92_F      S      85          0.430
LGA    P    93_F      P      86          0.545
LGA    A    94_F      G      87          0.912
LGA    K    95_F      R      88          2.123
LGA    L    96_F      -       -           -
LGA    G    97_F      -       -           -
LGA    E    98_F      G      89          0.801
LGA    D    99_F      D      90          1.383
LGA    I   100_F      L      91          0.708
LGA    V   101_F      V      92          0.619
LGA    I   102_F      I      93          0.301
LGA    T   103_F      E      94          0.213
LGA    A   104_F      T      95          1.209
LGA    H   105_F      R      96          0.777
LGA    V   106_F      C      97          1.057
LGA    L   107_F      L      98          1.080
LGA    K   108_F      R      99          0.812
LGA    Q   109_F      R     100          0.910
LGA    G   110_F      G     101          0.271
LGA    K   111_F      A     102          1.216
LGA    T   112_F      S     103          0.931
LGA    L   113_F      I     104          0.481
LGA    A   114_F      A     105          0.545
LGA    F   115_F      F     106          0.720
LGA    T   116_F      C     107          0.704
LGA    S   117_F      E     108          0.659
LGA    V   118_F      G     109          1.457
LGA    D   119_F      E     110          0.628
LGA    L   120_F      I     111          0.182
LGA    T   121_F      R     112          0.459
LGA    N   122_F      D     113          0.980
LGA    K   123_F      S     114          2.611
LGA    A   124_F      A     115          3.213
LGA    T   125_F      -       -           -
LGA    G   126_F      G     116          0.907
LGA    K   127_F      E     117          0.534
LGA    L   128_F      L     118          0.535
LGA    I   129_F      V     119          0.417
LGA    A   130_F      A     120          0.270
LGA    Q   131_F      K     121          0.354
LGA    G   132_F      A     122          0.655
LGA    R   133_F      T     123          0.178
LGA    H   134_F      A     124          0.562
LGA    T   135_F      T     125          0.368
LGA    K   136_F      F     126          0.706
LGA    H   137_F      K     127          1.246
LGA    L   138_F      I     128          1.730
LGA    -       -      I     129           -
LGA    -       -      Q     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  136  125    5.0    118    1.73    22.88     86.154     6.463

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.432887 * X  +   0.339743 * Y  +  -0.834975 * Z  + -50.982529
  Y_new =  -0.441987 * X  +  -0.887274 * Y  +  -0.131878 * Z  +  11.816970
  Z_new =  -0.785657 * X  +   0.311959 * Y  +   0.534251 * Z  +  12.031553 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.528511   -2.613081  [ DEG:    30.2815   -149.7185 ]
  Theta =   0.903757    2.237836  [ DEG:    51.7815    128.2185 ]
  Phi   =  -2.345794    0.795799  [ DEG:  -134.4041     45.5959 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f0x_F                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f0x_F.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  136  125   5.0  118   1.73   22.88  86.154
REMARK  ---------------------------------------------------------- 
MOLECULE 2f0x_F
HEADER    HYDROLASE                               14-NOV-05   2F0X              
TITLE     CRYSTAL STRUCTURE AND FUNCTION OF HUMAN THIOESTERASE                  
TITLE    2 SUPERFAMILY MEMBER 2(THEM2)                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOESTERASE SUPERFAMILY MEMBER 2;                         
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET22B                                    
KEYWDS    HOT DOG FOLD                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Z.CHENG,F.SONG,X.SHAN,Y.WANG,Z.WEI,W.GONG                             
REVDAT   1   10-OCT-06 2F0X    0                                                
JRNL        AUTH   Z.CHENG,F.SONG,X.SHAN,Z.WEI,Y.WANG,                          
JRNL        AUTH 2 D.DUNAWAY-MARIANO,W.GONG                                     
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN THIOESTERASE                      
JRNL        TITL 2 SUPERFAMILY MEMBER 2                                         
JRNL        REF    BIOCHEM.BIOPHYS.RES.COMMUN.   V. 349   172 2006              
JRNL        REFN   ASTM BBRCA9  US ISSN 0006-291X                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2F0X A    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X B    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X C    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X D    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X E    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X F    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X G    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
DBREF  2F0X H    1   140  UNP    Q9NPJ3   THEM2_HUMAN      1    140             
SEQRES   1 A  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 A  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 A  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 A  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 A  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 A  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 A  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 A  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 A  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 A  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 A  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 A  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 B  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 B  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 B  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 B  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 B  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 B  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 B  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 B  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 B  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 B  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 B  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 B  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 C  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 C  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 C  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 C  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 C  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 C  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 C  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 C  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 C  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 C  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 C  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 C  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 D  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 D  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 D  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 D  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 D  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 D  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 D  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 D  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 D  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 D  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 D  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 D  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 E  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 E  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 E  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 E  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 E  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 E  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 E  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 E  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 E  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 E  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 E  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 E  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 F  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 F  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 F  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 F  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 F  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 F  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 F  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 F  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 F  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 F  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 F  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 F  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 G  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 G  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 G  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 G  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 G  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 G  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 G  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 G  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 G  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 G  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 G  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 G  148  HIS HIS HIS HIS HIS                                          
SEQRES   1 H  148  MSE THR SER MSE THR GLN SER LEU ARG GLU VAL ILE LYS          
SEQRES   2 H  148  ALA MSE THR LYS ALA ARG ASN PHE GLU ARG VAL LEU GLY          
SEQRES   3 H  148  LYS ILE THR LEU VAL SER ALA ALA PRO GLY LYS VAL ILE          
SEQRES   4 H  148  CYS GLU MSE LYS VAL GLU GLU GLU HIS THR ASN ALA ILE          
SEQRES   5 H  148  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 H  148  ASN ILE SER THR MSE ALA LEU LEU CYS THR GLU ARG GLY          
SEQRES   7 H  148  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 H  148  SER PRO ALA LYS LEU GLY GLU ASP ILE VAL ILE THR ALA          
SEQRES   9 H  148  HIS VAL LEU LYS GLN GLY LYS THR LEU ALA PHE THR SER          
SEQRES  10 H  148  VAL ASP LEU THR ASN LYS ALA THR GLY LYS LEU ILE ALA          
SEQRES  11 H  148  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN LEU GLU HIS          
SEQRES  12 H  148  HIS HIS HIS HIS HIS                                          
HET    MSE  A   4       8                                                       
HET    MSE  A  15       8                                                       
HET    MSE  A  42       8                                                       
HET    MSE  A  70       8                                                       
HET    MSE  A  86       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  B   4       8                                                       
HET    MSE  B  15       8                                                       
HET    MSE  B  42       8                                                       
HET    MSE  B  70       8                                                       
HET    MSE  B  86       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  C   4       8                                                       
HET    MSE  C  15       8                                                       
HET    MSE  C  42       8                                                       
HET    MSE  C  70       8                                                       
HET    MSE  C  86       8                                                       
HET    MSE  C  91       8                                                       
HET    MSE  D   4       8                                                       
HET    MSE  D  15       8                                                       
HET    MSE  D  42       8                                                       
HET    MSE  D  70       8                                                       
HET    MSE  D  86       8                                                       
HET    MSE  D  91       8                                                       
HET    MSE  E   4       8                                                       
HET    MSE  E  15       8                                                       
HET    MSE  E  42       8                                                       
HET    MSE  E  70       8                                                       
HET    MSE  E  86       8                                                       
HET    MSE  E  91       8                                                       
HET    MSE  F   4       8                                                       
HET    MSE  F  15       8                                                       
HET    MSE  F  42       8                                                       
HET    MSE  F  70       8                                                       
HET    MSE  F  86       8                                                       
HET    MSE  F  91       8                                                       
HET    MSE  G   4       8                                                       
HET    MSE  G  15       8                                                       
HET    MSE  G  42       8                                                       
HET    MSE  G  70       8                                                       
HET    MSE  G  86       8                                                       
HET    MSE  G  91       8                                                       
HET    MSE  H   4       8                                                       
HET    MSE  H  15       8                                                       
HET    MSE  H  42       8                                                       
HET    MSE  H  70       8                                                       
HET    MSE  H  86       8                                                       
HET    MSE  H  91       8                                                       
HET    SO4   1001       5                                                       
HET    SO4   1002       5                                                       
HET    SO4   1003       5                                                       
HET    SO4   1004       5                                                       
HET    SO4   1005       5                                                       
HET    SO4   1006       5                                                       
HET    SO4   1007       5                                                       
HET    SO4   1008       5                                                       
HET    SO4   1009       5                                                       
HET    SO4   1010       5                                                       
HET    SO4   1011       5                                                       
HET    SO4   1012       5                                                       
HET    SO4   1013       5                                                       
HET    SO4   1014       5                                                       
HET    SO4   1015       5                                                       
HET    SO4   1016       5                                                       
HET    SO4   1017       5                                                       
HET    SO4   1018       5                                                       
HET    SO4   1019       5                                                       
HET    SO4   1020       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    48(C5 H11 N O2 SE)                                           
FORMUL   9  SO4    20(O4 S 2-)                                                  
FORMUL  29  HOH   *446(H2 O)                                                    
CRYST1  131.937  122.076   90.977  90.00 123.90  90.00 C 1 2 1      32          
ATOM   4949  N   SER F   3      33.149  49.059  25.538  1.00 53.28           N  
ATOM   4950  CA  SER F   3      31.780  49.654  25.626  1.00 52.66           C  
ATOM   4951  C   SER F   3      31.151  49.267  26.953  1.00 53.21           C  
ATOM   4952  O   SER F   3      30.746  50.121  27.744  1.00 52.80           O  
ATOM   4953  CB  SER F   3      30.902  49.142  24.485  1.00 53.05           C  
ATOM   4954  OG  SER F   3      29.553  49.533  24.678  1.00 53.36           O  
HETATM 4955  N   MSE F   4      31.067  47.961  27.174  1.00 52.98           N  
HETATM 4956  CA  MSE F   4      30.520  47.396  28.399  1.00 52.15           C  
HETATM 4957  C   MSE F   4      31.434  47.868  29.534  1.00 49.28           C  
HETATM 4958  O   MSE F   4      30.975  48.407  30.543  1.00 48.76           O  
HETATM 4959  CB  MSE F   4      30.527  45.863  28.266  1.00 56.64           C  
HETATM 4960  CG  MSE F   4      29.958  45.043  29.423  1.00 61.27           C  
HETATM 4961 SE   MSE F   4      29.766  43.137  28.928  1.00 67.77          SE  
HETATM 4962  CE  MSE F   4      31.592  42.743  28.427  1.00 65.53           C  
ATOM   4963  N   THR F   5      32.734  47.687  29.332  1.00 46.31           N  
ATOM   4964  CA  THR F   5      33.753  48.071  30.302  1.00 44.30           C  
ATOM   4965  C   THR F   5      33.878  49.585  30.481  1.00 41.84           C  
ATOM   4966  O   THR F   5      34.053  50.073  31.600  1.00 40.91           O  
ATOM   4967  CB  THR F   5      35.120  47.512  29.881  1.00 43.98           C  
ATOM   4968  OG1 THR F   5      35.021  46.088  29.742  1.00 46.95           O  
ATOM   4969  CG2 THR F   5      36.182  47.844  30.917  1.00 44.30           C  
ATOM   4970  N   GLN F   6      33.802  50.318  29.375  1.00 39.63           N  
ATOM   4971  CA  GLN F   6      33.903  51.771  29.411  1.00 38.76           C  
ATOM   4972  C   GLN F   6      32.809  52.361  30.294  1.00 37.67           C  
ATOM   4973  O   GLN F   6      33.070  53.234  31.125  1.00 36.81           O  
ATOM   4974  CB  GLN F   6      33.800  52.344  27.993  1.00 39.47           C  
ATOM   4975  CG  GLN F   6      35.123  52.400  27.232  1.00 42.65           C  
ATOM   4976  CD  GLN F   6      34.957  52.152  25.735  1.00 45.36           C  
ATOM   4977  OE1 GLN F   6      33.955  52.545  25.133  1.00 48.75           O  
ATOM   4978  NE2 GLN F   6      35.949  51.508  25.125  1.00 43.19           N  
ATOM   4979  N   SER F   7      31.586  51.868  30.122  1.00 35.69           N  
ATOM   4980  CA  SER F   7      30.456  52.356  30.899  1.00 36.04           C  
ATOM   4981  C   SER F   7      30.575  52.064  32.392  1.00 34.99           C  
ATOM   4982  O   SER F   7      30.180  52.880  33.227  1.00 34.73           O  
ATOM   4983  CB  SER F   7      29.156  51.753  30.371  1.00 37.45           C  
ATOM   4984  OG  SER F   7      28.061  52.187  31.157  1.00 42.81           O  
ATOM   4985  N   LEU F   8      31.115  50.899  32.731  1.00 33.01           N  
ATOM   4986  CA  LEU F   8      31.258  50.542  34.128  1.00 30.84           C  
ATOM   4987  C   LEU F   8      32.358  51.343  34.794  1.00 30.75           C  
ATOM   4988  O   LEU F   8      32.282  51.615  35.992  1.00 31.96           O  
ATOM   4989  CB  LEU F   8      31.514  49.038  34.280  1.00 29.30           C  
ATOM   4990  CG  LEU F   8      30.383  48.216  34.922  1.00 27.60           C  
ATOM   4991  CD1 LEU F   8      29.075  49.003  34.959  1.00 26.46           C  
ATOM   4992  CD2 LEU F   8      30.206  46.926  34.153  1.00 25.24           C  
ATOM   4993  N   ARG F   9      33.384  51.722  34.037  1.00 29.06           N  
ATOM   4994  CA  ARG F   9      34.455  52.520  34.619  1.00 28.53           C  
ATOM   4995  C   ARG F   9      33.881  53.882  34.967  1.00 28.15           C  
ATOM   4996  O   ARG F   9      34.299  54.513  35.939  1.00 28.37           O  
ATOM   4997  CB  ARG F   9      35.627  52.694  33.653  1.00 30.90           C  
ATOM   4998  CG  ARG F   9      36.504  51.469  33.484  1.00 34.55           C  
ATOM   4999  CD  ARG F   9      37.886  51.862  32.966  1.00 38.46           C  
ATOM   5000  NE  ARG F   9      38.710  50.700  32.641  1.00 41.09           N  
ATOM   5001  CZ  ARG F   9      38.628  50.019  31.502  1.00 42.72           C  
ATOM   5002  NH1 ARG F   9      37.758  50.387  30.565  1.00 45.31           N  
ATOM   5003  NH2 ARG F   9      39.407  48.966  31.301  1.00 43.74           N  
ATOM   5004  N   GLU F  10      32.915  54.340  34.178  1.00 28.37           N  
ATOM   5005  CA  GLU F  10      32.293  55.627  34.444  1.00 29.69           C  
ATOM   5006  C   GLU F  10      31.473  55.518  35.714  1.00 29.71           C  
ATOM   5007  O   GLU F  10      31.621  56.321  36.627  1.00 30.58           O  
ATOM   5008  CB  GLU F  10      31.401  56.053  33.282  1.00 31.23           C  
ATOM   5009  CG  GLU F  10      32.165  56.482  32.044  1.00 33.53           C  
ATOM   5010  CD  GLU F  10      31.250  56.729  30.858  1.00 35.91           C  
ATOM   5011  OE1 GLU F  10      31.751  57.179  29.808  1.00 37.01           O  
ATOM   5012  OE2 GLU F  10      30.031  56.468  30.977  1.00 38.78           O  
ATOM   5013  N   VAL F  11      30.605  54.515  35.770  1.00 29.39           N  
ATOM   5014  CA  VAL F  11      29.780  54.306  36.951  1.00 27.69           C  
ATOM   5015  C   VAL F  11      30.633  54.374  38.216  1.00 28.28           C  
ATOM   5016  O   VAL F  11      30.267  55.031  39.188  1.00 28.82           O  
ATOM   5017  CB  VAL F  11      29.076  52.935  36.888  1.00 25.77           C  
ATOM   5018  CG1 VAL F  11      28.544  52.549  38.253  1.00 26.02           C  
ATOM   5019  CG2 VAL F  11      27.937  52.989  35.883  1.00 27.90           C  
ATOM   5020  N   ILE F  12      31.774  53.696  38.195  1.00 27.05           N  
ATOM   5021  CA  ILE F  12      32.665  53.672  39.345  1.00 28.50           C  
ATOM   5022  C   ILE F  12      33.277  55.044  39.632  1.00 28.56           C  
ATOM   5023  O   ILE F  12      33.366  55.457  40.788  1.00 27.25           O  
ATOM   5024  CB  ILE F  12      33.794  52.639  39.142  1.00 27.21           C  
ATOM   5025  CG1 ILE F  12      33.190  51.260  38.874  1.00 26.71           C  
ATOM   5026  CG2 ILE F  12      34.681  52.593  40.367  1.00 27.10           C  
ATOM   5027  CD1 ILE F  12      34.206  50.213  38.502  1.00 27.99           C  
ATOM   5028  N   LYS F  13      33.703  55.744  38.583  1.00 30.33           N  
ATOM   5029  CA  LYS F  13      34.294  57.071  38.757  1.00 32.83           C  
ATOM   5030  C   LYS F  13      33.299  57.954  39.499  1.00 33.51           C  
ATOM   5031  O   LYS F  13      33.647  58.617  40.478  1.00 33.89           O  
ATOM   5032  CB  LYS F  13      34.633  57.699  37.399  1.00 33.55           C  
ATOM   5033  CG  LYS F  13      35.561  58.912  37.481  1.00 35.55           C  
ATOM   5034  CD  LYS F  13      36.107  59.293  36.106  1.00 36.32           C  
ATOM   5035  CE  LYS F  13      37.352  60.180  36.206  1.00 38.82           C  
ATOM   5036  NZ  LYS F  13      37.094  61.516  36.832  1.00 40.58           N  
ATOM   5037  N   ALA F  14      32.053  57.938  39.033  1.00 33.38           N  
ATOM   5038  CA  ALA F  14      30.996  58.731  39.642  1.00 32.77           C  
ATOM   5039  C   ALA F  14      30.851  58.462  41.132  1.00 34.05           C  
ATOM   5040  O   ALA F  14      30.390  59.325  41.874  1.00 34.17           O  
ATOM   5041  CB  ALA F  14      29.677  58.457  38.941  1.00 33.86           C  
HETATM 5042  N   MSE F  15      31.237  57.270  41.574  1.00 34.04           N  
HETATM 5043  CA  MSE F  15      31.120  56.928  42.988  1.00 35.35           C  
HETATM 5044  C   MSE F  15      32.047  57.741  43.884  1.00 35.75           C  
HETATM 5045  O   MSE F  15      31.792  57.890  45.081  1.00 35.40           O  
HETATM 5046  CB  MSE F  15      31.384  55.442  43.196  1.00 34.65           C  
HETATM 5047  CG  MSE F  15      30.402  54.565  42.453  1.00 37.55           C  
HETATM 5048 SE   MSE F  15      30.640  52.695  42.850  1.00 43.31          SE  
HETATM 5049  CE  MSE F  15      28.961  52.042  42.129  1.00 41.03           C  
ATOM   5050  N   THR F  16      33.120  58.270  43.304  1.00 37.06           N  
ATOM   5051  CA  THR F  16      34.074  59.078  44.055  1.00 38.34           C  
ATOM   5052  C   THR F  16      33.489  60.431  44.403  1.00 38.36           C  
ATOM   5053  O   THR F  16      33.885  61.050  45.388  1.00 41.88           O  
ATOM   5054  CB  THR F  16      35.350  59.343  43.250  1.00 38.85           C  
ATOM   5055  OG1 THR F  16      36.013  58.105  42.984  1.00 40.97           O  
ATOM   5056  CG2 THR F  16      36.284  60.261  44.028  1.00 38.21           C  
ATOM   5057  N   LYS F  17      32.557  60.899  43.584  1.00 37.20           N  
ATOM   5058  CA  LYS F  17      31.949  62.199  43.811  1.00 37.67           C  
ATOM   5059  C   LYS F  17      30.563  62.074  44.415  1.00 36.79           C  
ATOM   5060  O   LYS F  17      30.010  63.046  44.932  1.00 35.99           O  
ATOM   5061  CB  LYS F  17      31.880  62.965  42.502  1.00 37.79           C  
ATOM   5062  N   ALA F  18      30.004  60.871  44.343  1.00 36.36           N  
ATOM   5063  CA  ALA F  18      28.675  60.607  44.873  1.00 34.54           C  
ATOM   5064  C   ALA F  18      28.584  60.982  46.343  1.00 34.37           C  
ATOM   5065  O   ALA F  18      29.518  60.753  47.110  1.00 35.01           O  
ATOM   5066  CB  ALA F  18      28.334  59.138  44.698  1.00 34.55           C  
ATOM   5067  N   ARG F  19      27.467  61.577  46.741  1.00 33.67           N  
ATOM   5068  CA  ARG F  19      27.301  61.914  48.140  1.00 34.06           C  
ATOM   5069  C   ARG F  19      26.303  60.952  48.779  1.00 32.80           C  
ATOM   5070  O   ARG F  19      26.151  60.920  50.003  1.00 31.31           O  
ATOM   5071  CB  ARG F  19      26.896  63.388  48.313  1.00 38.33           C  
ATOM   5072  CG  ARG F  19      25.810  63.901  47.390  1.00 44.53           C  
ATOM   5073  CD  ARG F  19      26.117  65.339  46.979  1.00 48.02           C  
ATOM   5074  NE  ARG F  19      24.917  66.162  46.878  1.00 52.48           N  
ATOM   5075  CZ  ARG F  19      24.313  66.727  47.921  1.00 55.26           C  
ATOM   5076  NH1 ARG F  19      24.807  66.559  49.143  1.00 56.42           N  
ATOM   5077  NH2 ARG F  19      23.211  67.451  47.750  1.00 53.31           N  
ATOM   5078  N   ASN F  20      25.637  60.140  47.957  1.00 30.95           N  
ATOM   5079  CA  ASN F  20      24.714  59.168  48.526  1.00 29.30           C  
ATOM   5080  C   ASN F  20      25.570  58.034  49.086  1.00 27.74           C  
ATOM   5081  O   ASN F  20      26.799  58.164  49.171  1.00 27.12           O  
ATOM   5082  CB  ASN F  20      23.689  58.645  47.494  1.00 28.96           C  
ATOM   5083  CG  ASN F  20      24.314  57.819  46.389  1.00 27.21           C  
ATOM   5084  OD1 ASN F  20      25.287  57.098  46.600  1.00 25.19           O  
ATOM   5085  ND2 ASN F  20      23.729  57.901  45.199  1.00 27.36           N  
ATOM   5086  N   PHE F  21      24.945  56.923  49.458  1.00 25.09           N  
ATOM   5087  CA  PHE F  21      25.699  55.828  50.065  1.00 24.79           C  
ATOM   5088  C   PHE F  21      26.770  55.157  49.206  1.00 24.07           C  
ATOM   5089  O   PHE F  21      27.723  54.584  49.736  1.00 23.55           O  
ATOM   5090  CB  PHE F  21      24.740  54.767  50.601  1.00 23.56           C  
ATOM   5091  CG  PHE F  21      25.356  53.869  51.632  1.00 22.21           C  
ATOM   5092  CD1 PHE F  21      25.782  54.388  52.852  1.00 20.50           C  
ATOM   5093  CD2 PHE F  21      25.544  52.513  51.376  1.00 19.20           C  
ATOM   5094  CE1 PHE F  21      26.387  53.576  53.801  1.00 16.61           C  
ATOM   5095  CE2 PHE F  21      26.150  51.690  52.322  1.00 18.43           C  
ATOM   5096  CZ  PHE F  21      26.572  52.224  53.535  1.00 17.77           C  
ATOM   5097  N   GLU F  22      26.637  55.229  47.886  1.00 25.89           N  
ATOM   5098  CA  GLU F  22      27.620  54.584  47.022  1.00 28.91           C  
ATOM   5099  C   GLU F  22      29.036  55.156  47.164  1.00 28.86           C  
ATOM   5100  O   GLU F  22      30.006  54.567  46.676  1.00 29.95           O  
ATOM   5101  CB  GLU F  22      27.172  54.651  45.562  1.00 30.04           C  
ATOM   5102  CG  GLU F  22      25.850  53.954  45.292  1.00 34.04           C  
ATOM   5103  CD  GLU F  22      25.605  53.749  43.814  1.00 36.52           C  
ATOM   5104  OE1 GLU F  22      25.708  54.728  43.051  1.00 39.63           O  
ATOM   5105  OE2 GLU F  22      25.309  52.607  43.409  1.00 39.96           O  
ATOM   5106  N   ARG F  23      29.156  56.292  47.842  1.00 28.54           N  
ATOM   5107  CA  ARG F  23      30.460  56.926  48.028  1.00 28.25           C  
ATOM   5108  C   ARG F  23      31.413  55.976  48.748  1.00 27.13           C  
ATOM   5109  O   ARG F  23      32.623  56.052  48.568  1.00 28.85           O  
ATOM   5110  CB  ARG F  23      30.316  58.215  48.848  1.00 29.01           C  
ATOM   5111  CG  ARG F  23      30.577  58.039  50.343  1.00 31.60           C  
ATOM   5112  CD  ARG F  23      30.005  59.189  51.156  1.00 33.24           C  
ATOM   5113  NE  ARG F  23      28.580  58.999  51.368  1.00 36.71           N  
ATOM   5114  CZ  ARG F  23      28.031  58.633  52.521  1.00 35.46           C  
ATOM   5115  NH1 ARG F  23      28.784  58.423  53.593  1.00 33.48           N  
ATOM   5116  NH2 ARG F  23      26.724  58.454  52.589  1.00 35.96           N  
ATOM   5117  N   VAL F  24      30.861  55.081  49.557  1.00 25.44           N  
ATOM   5118  CA  VAL F  24      31.669  54.133  50.317  1.00 23.09           C  
ATOM   5119  C   VAL F  24      32.420  53.134  49.433  1.00 22.95           C  
ATOM   5120  O   VAL F  24      33.252  52.366  49.925  1.00 21.94           O  
ATOM   5121  CB  VAL F  24      30.797  53.343  51.324  1.00 24.07           C  
ATOM   5122  CG1 VAL F  24      30.145  54.292  52.297  1.00 20.63           C  
ATOM   5123  CG2 VAL F  24      29.727  52.540  50.585  1.00 23.97           C  
ATOM   5124  N   LEU F  25      32.129  53.141  48.134  1.00 23.02           N  
ATOM   5125  CA  LEU F  25      32.790  52.236  47.203  1.00 23.93           C  
ATOM   5126  C   LEU F  25      33.748  52.977  46.269  1.00 23.83           C  
ATOM   5127  O   LEU F  25      34.257  52.414  45.302  1.00 22.31           O  
ATOM   5128  CB  LEU F  25      31.744  51.490  46.368  1.00 24.53           C  
ATOM   5129  CG  LEU F  25      30.709  50.691  47.163  1.00 28.03           C  
ATOM   5130  CD1 LEU F  25      29.824  49.905  46.201  1.00 28.78           C  
ATOM   5131  CD2 LEU F  25      31.414  49.743  48.129  1.00 27.25           C  
ATOM   5132  N   GLY F  26      33.994  54.245  46.572  1.00 25.51           N  
ATOM   5133  CA  GLY F  26      34.872  55.047  45.739  1.00 25.58           C  
ATOM   5134  C   GLY F  26      36.243  54.478  45.414  1.00 25.64           C  
ATOM   5135  O   GLY F  26      36.810  54.812  44.374  1.00 27.29           O  
ATOM   5136  N   LYS F  27      36.778  53.615  46.274  1.00 25.27           N  
ATOM   5137  CA  LYS F  27      38.108  53.051  46.044  1.00 27.65           C  
ATOM   5138  C   LYS F  27      38.196  51.766  45.214  1.00 27.17           C  
ATOM   5139  O   LYS F  27      39.299  51.335  44.877  1.00 27.28           O  
ATOM   5140  CB  LYS F  27      38.824  52.826  47.387  1.00 29.22           C  
ATOM   5141  CG  LYS F  27      39.013  54.088  48.222  1.00 29.91           C  
ATOM   5142  CD  LYS F  27      39.804  55.142  47.468  1.00 33.03           C  
ATOM   5143  CE  LYS F  27      39.877  56.451  48.251  1.00 35.05           C  
ATOM   5144  NZ  LYS F  27      40.572  56.298  49.562  1.00 37.03           N  
ATOM   5145  N   ILE F  28      37.065  51.147  44.888  1.00 25.60           N  
ATOM   5146  CA  ILE F  28      37.107  49.921  44.090  1.00 24.90           C  
ATOM   5147  C   ILE F  28      37.516  50.244  42.653  1.00 25.09           C  
ATOM   5148  O   ILE F  28      37.269  51.348  42.154  1.00 26.02           O  
ATOM   5149  CB  ILE F  28      35.728  49.203  44.034  1.00 24.10           C  
ATOM   5150  CG1 ILE F  28      34.737  50.026  43.197  1.00 22.22           C  
ATOM   5151  CG2 ILE F  28      35.198  48.976  45.444  1.00 22.66           C  
ATOM   5152  CD1 ILE F  28      33.379  49.374  43.003  1.00 23.43           C  
ATOM   5153  N   THR F  29      38.143  49.283  41.991  1.00 25.25           N  
ATOM   5154  CA  THR F  29      38.552  49.465  40.602  1.00 27.04           C  
ATOM   5155  C   THR F  29      38.019  48.297  39.782  1.00 26.23           C  
ATOM   5156  O   THR F  29      37.870  47.190  40.290  1.00 26.42           O  
ATOM   5157  CB  THR F  29      40.106  49.540  40.456  1.00 28.61           C  
ATOM   5158  OG1 THR F  29      40.710  48.385  41.055  1.00 32.60           O  
ATOM   5159  CG2 THR F  29      40.649  50.796  41.133  1.00 30.22           C  
ATOM   5160  N   LEU F  30      37.719  48.554  38.518  1.00 25.93           N  
ATOM   5161  CA  LEU F  30      37.202  47.520  37.633  1.00 25.44           C  
ATOM   5162  C   LEU F  30      38.320  46.670  37.043  1.00 27.70           C  
ATOM   5163  O   LEU F  30      39.300  47.195  36.509  1.00 27.38           O  
ATOM   5164  CB  LEU F  30      36.408  48.150  36.487  1.00 22.93           C  
ATOM   5165  CG  LEU F  30      35.902  47.218  35.381  1.00 21.38           C  
ATOM   5166  CD1 LEU F  30      34.875  46.250  35.941  1.00 21.14           C  
ATOM   5167  CD2 LEU F  30      35.296  48.050  34.271  1.00 19.29           C  
ATOM   5168  N   VAL F  31      38.176  45.354  37.153  1.00 28.03           N  
ATOM   5169  CA  VAL F  31      39.157  44.450  36.584  1.00 27.10           C  
ATOM   5170  C   VAL F  31      38.644  44.046  35.208  1.00 28.11           C  
ATOM   5171  O   VAL F  31      39.330  44.229  34.205  1.00 30.43           O  
ATOM   5172  CB  VAL F  31      39.341  43.185  37.438  1.00 26.88           C  
ATOM   5173  CG1 VAL F  31      40.284  42.225  36.736  1.00 26.97           C  
ATOM   5174  CG2 VAL F  31      39.901  43.553  38.794  1.00 26.60           C  
ATOM   5175  N   SER F  32      37.425  43.513  35.164  1.00 28.14           N  
ATOM   5176  CA  SER F  32      36.827  43.086  33.904  1.00 27.29           C  
ATOM   5177  C   SER F  32      35.305  43.025  33.941  1.00 27.42           C  
ATOM   5178  O   SER F  32      34.686  42.943  35.004  1.00 27.30           O  
ATOM   5179  CB  SER F  32      37.371  41.713  33.503  1.00 26.64           C  
ATOM   5180  OG  SER F  32      37.183  40.764  34.544  1.00 28.24           O  
ATOM   5181  N   ALA F  33      34.716  43.069  32.753  1.00 27.65           N  
ATOM   5182  CA  ALA F  33      33.279  43.005  32.587  1.00 27.89           C  
ATOM   5183  C   ALA F  33      33.012  42.041  31.437  1.00 29.83           C  
ATOM   5184  O   ALA F  33      33.652  42.118  30.386  1.00 32.86           O  
ATOM   5185  CB  ALA F  33      32.731  44.378  32.261  1.00 29.97           C  
ATOM   5186  N   ALA F  34      32.080  41.121  31.647  1.00 29.15           N  
ATOM   5187  CA  ALA F  34      31.724  40.141  30.631  1.00 28.08           C  
ATOM   5188  C   ALA F  34      30.256  39.797  30.843  1.00 26.55           C  
ATOM   5189  O   ALA F  34      29.689  40.131  31.875  1.00 26.72           O  
ATOM   5190  CB  ALA F  34      32.592  38.897  30.781  1.00 28.00           C  
ATOM   5191  N   PRO F  35      29.612  39.150  29.863  1.00 26.21           N  
ATOM   5192  CA  PRO F  35      28.200  38.814  30.054  1.00 25.38           C  
ATOM   5193  C   PRO F  35      27.965  38.078  31.373  1.00 24.22           C  
ATOM   5194  O   PRO F  35      28.539  37.020  31.612  1.00 25.76           O  
ATOM   5195  CB  PRO F  35      27.889  37.954  28.836  1.00 26.04           C  
ATOM   5196  CG  PRO F  35      28.755  38.575  27.775  1.00 26.34           C  
ATOM   5197  CD  PRO F  35      30.066  38.772  28.513  1.00 26.52           C  
ATOM   5198  N   GLY F  36      27.140  38.669  32.235  1.00 22.55           N  
ATOM   5199  CA  GLY F  36      26.826  38.075  33.521  1.00 21.28           C  
ATOM   5200  C   GLY F  36      27.984  37.961  34.496  1.00 21.23           C  
ATOM   5201  O   GLY F  36      27.870  37.281  35.517  1.00 19.38           O  
ATOM   5202  N   LYS F  37      29.094  38.632  34.209  1.00 20.94           N  
ATOM   5203  CA  LYS F  37      30.245  38.542  35.095  1.00 21.87           C  
ATOM   5204  C   LYS F  37      31.041  39.835  35.194  1.00 22.15           C  
ATOM   5205  O   LYS F  37      31.435  40.420  34.188  1.00 22.40           O  
ATOM   5206  CB  LYS F  37      31.159  37.409  34.621  1.00 23.65           C  
ATOM   5207  CG  LYS F  37      32.281  37.061  35.587  1.00 25.46           C  
ATOM   5208  CD  LYS F  37      33.136  35.927  35.033  1.00 28.45           C  
ATOM   5209  CE  LYS F  37      34.249  35.538  35.996  1.00 28.80           C  
ATOM   5210  NZ  LYS F  37      35.088  34.433  35.450  1.00 31.18           N  
ATOM   5211  N   VAL F  38      31.288  40.272  36.420  1.00 22.65           N  
ATOM   5212  CA  VAL F  38      32.041  41.494  36.651  1.00 23.87           C  
ATOM   5213  C   VAL F  38      33.057  41.267  37.758  1.00 24.69           C  
ATOM   5214  O   VAL F  38      32.728  40.722  38.806  1.00 25.96           O  
ATOM   5215  CB  VAL F  38      31.099  42.667  37.061  1.00 23.24           C  
ATOM   5216  CG1 VAL F  38      31.917  43.874  37.495  1.00 24.95           C  
ATOM   5217  CG2 VAL F  38      30.200  43.048  35.892  1.00 21.25           C  
ATOM   5218  N   ILE F  39      34.299  41.671  37.525  1.00 26.72           N  
ATOM   5219  CA  ILE F  39      35.322  41.518  38.546  1.00 25.55           C  
ATOM   5220  C   ILE F  39      35.878  42.878  38.947  1.00 25.65           C  
ATOM   5221  O   ILE F  39      36.275  43.671  38.098  1.00 25.98           O  
ATOM   5222  CB  ILE F  39      36.478  40.631  38.062  1.00 26.11           C  
ATOM   5223  CG1 ILE F  39      35.939  39.251  37.668  1.00 24.74           C  
ATOM   5224  CG2 ILE F  39      37.519  40.490  39.172  1.00 25.33           C  
ATOM   5225  CD1 ILE F  39      37.007  38.287  37.173  1.00 24.64           C  
ATOM   5226  N   CYS F  40      35.877  43.147  40.249  1.00 25.00           N  
ATOM   5227  CA  CYS F  40      36.405  44.391  40.791  1.00 25.60           C  
ATOM   5228  C   CYS F  40      37.411  44.045  41.881  1.00 27.02           C  
ATOM   5229  O   CYS F  40      37.419  42.929  42.407  1.00 26.64           O  
ATOM   5230  CB  CYS F  40      35.288  45.260  41.400  1.00 26.77           C  
ATOM   5231  SG  CYS F  40      34.232  46.151  40.216  1.00 26.61           S  
ATOM   5232  N   GLU F  41      38.265  45.000  42.212  1.00 26.21           N  
ATOM   5233  CA  GLU F  41      39.253  44.787  43.250  1.00 27.66           C  
ATOM   5234  C   GLU F  41      39.238  45.985  44.162  1.00 27.94           C  
ATOM   5235  O   GLU F  41      38.785  47.066  43.784  1.00 28.61           O  
ATOM   5236  CB  GLU F  41      40.656  44.642  42.661  1.00 30.83           C  
ATOM   5237  CG  GLU F  41      40.855  43.435  41.778  1.00 36.23           C  
ATOM   5238  CD  GLU F  41      42.286  43.317  41.287  1.00 40.10           C  
ATOM   5239  OE1 GLU F  41      42.913  44.371  41.033  1.00 41.35           O  
ATOM   5240  OE2 GLU F  41      42.777  42.173  41.145  1.00 41.86           O  
HETATM 5241  N   MSE F  42      39.749  45.793  45.366  1.00 27.29           N  
HETATM 5242  CA  MSE F  42      39.805  46.874  46.323  1.00 27.99           C  
HETATM 5243  C   MSE F  42      40.882  46.586  47.352  1.00 28.52           C  
HETATM 5244  O   MSE F  42      41.139  45.427  47.690  1.00 27.35           O  
HETATM 5245  CB  MSE F  42      38.451  47.038  47.023  1.00 27.65           C  
HETATM 5246  CG  MSE F  42      38.413  48.219  47.972  1.00 28.46           C  
HETATM 5247 SE   MSE F  42      36.725  48.446  48.879  1.00 34.58          SE  
HETATM 5248  CE  MSE F  42      37.029  47.243  50.370  1.00 26.21           C  
ATOM   5249  N   LYS F  43      41.523  47.648  47.825  1.00 28.88           N  
ATOM   5250  CA  LYS F  43      42.546  47.520  48.849  1.00 31.21           C  
ATOM   5251  C   LYS F  43      41.893  47.965  50.141  1.00 30.60           C  
ATOM   5252  O   LYS F  43      41.413  49.091  50.247  1.00 30.71           O  
ATOM   5253  CB  LYS F  43      43.756  48.408  48.540  1.00 33.11           C  
ATOM   5254  CG  LYS F  43      44.873  48.290  49.576  1.00 35.52           C  
ATOM   5255  CD  LYS F  43      46.048  49.215  49.252  1.00 39.72           C  
ATOM   5256  CE  LYS F  43      47.140  49.108  50.309  1.00 40.58           C  
ATOM   5257  NZ  LYS F  43      47.741  47.743  50.356  1.00 42.64           N  
ATOM   5258  N   VAL F  44      41.864  47.080  51.124  1.00 31.16           N  
ATOM   5259  CA  VAL F  44      41.243  47.407  52.392  1.00 31.95           C  
ATOM   5260  C   VAL F  44      42.007  48.513  53.114  1.00 33.85           C  
ATOM   5261  O   VAL F  44      43.197  48.383  53.400  1.00 34.75           O  
ATOM   5262  CB  VAL F  44      41.158  46.158  53.300  1.00 30.77           C  
ATOM   5263  CG1 VAL F  44      40.401  46.490  54.574  1.00 30.24           C  
ATOM   5264  CG2 VAL F  44      40.485  45.020  52.553  1.00 29.60           C  
ATOM   5265  N   GLU F  45      41.317  49.612  53.389  1.00 35.41           N  
ATOM   5266  CA  GLU F  45      41.915  50.735  54.095  1.00 36.63           C  
ATOM   5267  C   GLU F  45      41.141  50.927  55.386  1.00 37.38           C  
ATOM   5268  O   GLU F  45      40.124  50.265  55.610  1.00 37.33           O  
ATOM   5269  CB  GLU F  45      41.844  52.007  53.248  1.00 39.07           C  
ATOM   5270  CG  GLU F  45      42.837  52.053  52.092  1.00 43.31           C  
ATOM   5271  CD  GLU F  45      42.685  53.306  51.239  1.00 45.78           C  
ATOM   5272  OE1 GLU F  45      42.397  54.384  51.800  1.00 47.40           O  
ATOM   5273  OE2 GLU F  45      42.865  53.218  50.008  1.00 47.67           O  
ATOM   5274  N   GLU F  46      41.622  51.835  56.230  1.00 37.70           N  
ATOM   5275  CA  GLU F  46      40.990  52.120  57.513  1.00 38.07           C  
ATOM   5276  C   GLU F  46      39.519  52.504  57.390  1.00 36.22           C  
ATOM   5277  O   GLU F  46      38.723  52.205  58.276  1.00 36.39           O  
ATOM   5278  CB  GLU F  46      41.756  53.238  58.234  1.00 39.76           C  
ATOM   5279  CG  GLU F  46      41.181  53.651  59.588  1.00 41.04           C  
ATOM   5280  CD  GLU F  46      41.034  52.485  60.556  1.00 43.42           C  
ATOM   5281  OE1 GLU F  46      41.843  51.532  60.480  1.00 43.34           O  
ATOM   5282  OE2 GLU F  46      40.117  52.528  61.406  1.00 44.56           O  
ATOM   5283  N   GLU F  47      39.163  53.160  56.291  1.00 34.53           N  
ATOM   5284  CA  GLU F  47      37.786  53.591  56.070  1.00 33.61           C  
ATOM   5285  C   GLU F  47      36.843  52.424  55.749  1.00 33.07           C  
ATOM   5286  O   GLU F  47      35.620  52.584  55.760  1.00 34.24           O  
ATOM   5287  CB  GLU F  47      37.739  54.601  54.925  1.00 32.50           C  
ATOM   5288  CG  GLU F  47      38.057  54.001  53.566  1.00 32.27           C  
ATOM   5289  CD  GLU F  47      37.932  55.003  52.440  1.00 33.70           C  
ATOM   5290  OE1 GLU F  47      38.915  55.723  52.160  1.00 33.33           O  
ATOM   5291  OE2 GLU F  47      36.838  55.081  51.841  1.00 34.12           O  
ATOM   5292  N   HIS F  48      37.415  51.261  55.469  1.00 30.90           N  
ATOM   5293  CA  HIS F  48      36.638  50.075  55.124  1.00 30.50           C  
ATOM   5294  C   HIS F  48      36.582  49.092  56.278  1.00 30.58           C  
ATOM   5295  O   HIS F  48      36.015  48.006  56.143  1.00 30.12           O  
ATOM   5296  CB  HIS F  48      37.281  49.370  53.935  1.00 28.71           C  
ATOM   5297  CG  HIS F  48      37.420  50.234  52.725  1.00 28.19           C  
ATOM   5298  ND1 HIS F  48      38.499  50.145  51.873  1.00 28.08           N  
ATOM   5299  CD2 HIS F  48      36.601  51.176  52.201  1.00 28.74           C  
ATOM   5300  CE1 HIS F  48      38.337  50.994  50.874  1.00 28.99           C  
ATOM   5301  NE2 HIS F  48      37.193  51.631  51.048  1.00 29.11           N  
ATOM   5302  N   THR F  49      37.159  49.475  57.412  1.00 31.00           N  
ATOM   5303  CA  THR F  49      37.220  48.584  58.562  1.00 31.82           C  
ATOM   5304  C   THR F  49      36.136  48.746  59.618  1.00 33.56           C  
ATOM   5305  O   THR F  49      35.380  49.716  59.624  1.00 33.10           O  
ATOM   5306  CB  THR F  49      38.604  48.698  59.261  1.00 31.96           C  
ATOM   5307  OG1 THR F  49      38.778  50.023  59.789  1.00 27.19           O  
ATOM   5308  CG2 THR F  49      39.723  48.403  58.265  1.00 31.42           C  
ATOM   5309  N   ASN F  50      36.091  47.763  60.515  1.00 36.30           N  
ATOM   5310  CA  ASN F  50      35.140  47.726  61.622  1.00 38.67           C  
ATOM   5311  C   ASN F  50      35.874  48.030  62.925  1.00 40.33           C  
ATOM   5312  O   ASN F  50      36.969  48.592  62.918  1.00 41.98           O  
ATOM   5313  CB  ASN F  50      34.498  46.339  61.728  1.00 37.22           C  
ATOM   5314  CG  ASN F  50      35.526  45.230  61.815  1.00 37.55           C  
ATOM   5315  OD1 ASN F  50      36.638  45.441  62.293  1.00 39.19           O  
ATOM   5316  ND2 ASN F  50      35.157  44.039  61.362  1.00 37.07           N  
ATOM   5317  N   ALA F  51      35.271  47.620  64.036  1.00 41.20           N  
ATOM   5318  CA  ALA F  51      35.832  47.845  65.362  1.00 42.50           C  
ATOM   5319  C   ALA F  51      37.173  47.163  65.624  1.00 42.84           C  
ATOM   5320  O   ALA F  51      38.010  47.702  66.354  1.00 44.07           O  
ATOM   5321  CB  ALA F  51      34.825  47.419  66.421  1.00 42.73           C  
ATOM   5322  N   ILE F  52      37.383  45.982  65.050  1.00 41.66           N  
ATOM   5323  CA  ILE F  52      38.640  45.277  65.272  1.00 40.08           C  
ATOM   5324  C   ILE F  52      39.631  45.396  64.118  1.00 39.00           C  
ATOM   5325  O   ILE F  52      40.618  44.662  64.060  1.00 38.99           O  
ATOM   5326  CB  ILE F  52      38.404  43.780  65.596  1.00 40.42           C  
ATOM   5327  CG1 ILE F  52      37.717  43.077  64.427  1.00 39.06           C  
ATOM   5328  CG2 ILE F  52      37.553  43.654  66.847  1.00 40.25           C  
ATOM   5329  CD1 ILE F  52      37.634  41.575  64.605  1.00 37.88           C  
ATOM   5330  N   GLY F  53      39.356  46.315  63.195  1.00 38.58           N  
ATOM   5331  CA  GLY F  53      40.264  46.540  62.083  1.00 36.96           C  
ATOM   5332  C   GLY F  53      40.182  45.717  60.808  1.00 36.59           C  
ATOM   5333  O   GLY F  53      41.021  45.892  59.926  1.00 38.06           O  
ATOM   5334  N   THR F  54      39.204  44.827  60.686  1.00 35.51           N  
ATOM   5335  CA  THR F  54      39.089  44.031  59.466  1.00 33.70           C  
ATOM   5336  C   THR F  54      37.976  44.604  58.591  1.00 32.87           C  
ATOM   5337  O   THR F  54      37.274  45.523  59.009  1.00 33.90           O  
ATOM   5338  CB  THR F  54      38.789  42.550  59.786  1.00 34.00           C  
ATOM   5339  OG1 THR F  54      37.560  42.454  60.515  1.00 34.47           O  
ATOM   5340  CG2 THR F  54      39.906  41.957  60.623  1.00 31.60           C  
ATOM   5341  N   LEU F  55      37.827  44.083  57.374  1.00 31.26           N  
ATOM   5342  CA  LEU F  55      36.786  44.563  56.469  1.00 29.67           C  
ATOM   5343  C   LEU F  55      35.422  44.432  57.162  1.00 28.20           C  
ATOM   5344  O   LEU F  55      35.097  43.379  57.719  1.00 27.18           O  
ATOM   5345  CB  LEU F  55      36.809  43.755  55.167  1.00 28.59           C  
ATOM   5346  CG  LEU F  55      35.801  44.137  54.076  1.00 27.98           C  
ATOM   5347  CD1 LEU F  55      35.959  45.613  53.699  1.00 27.49           C  
ATOM   5348  CD2 LEU F  55      36.018  43.235  52.858  1.00 27.30           C  
ATOM   5349  N   HIS F  56      34.638  45.507  57.133  1.00 26.56           N  
ATOM   5350  CA  HIS F  56      33.327  45.525  57.777  1.00 25.72           C  
ATOM   5351  C   HIS F  56      32.309  44.657  57.043  1.00 24.37           C  
ATOM   5352  O   HIS F  56      32.116  44.799  55.838  1.00 24.10           O  
ATOM   5353  CB  HIS F  56      32.799  46.962  57.856  1.00 27.31           C  
ATOM   5354  CG  HIS F  56      31.665  47.135  58.818  1.00 29.48           C  
ATOM   5355  ND1 HIS F  56      31.819  47.736  60.050  1.00 30.55           N  
ATOM   5356  CD2 HIS F  56      30.367  46.755  58.745  1.00 30.09           C  
ATOM   5357  CE1 HIS F  56      30.666  47.717  60.693  1.00 29.54           C  
ATOM   5358  NE2 HIS F  56      29.768  47.126  59.924  1.00 30.21           N  
ATOM   5359  N   GLY F  57      31.655  43.765  57.777  1.00 24.21           N  
ATOM   5360  CA  GLY F  57      30.659  42.893  57.179  1.00 23.67           C  
ATOM   5361  C   GLY F  57      29.615  43.691  56.415  1.00 24.69           C  
ATOM   5362  O   GLY F  57      29.012  43.199  55.460  1.00 23.42           O  
ATOM   5363  N   GLY F  58      29.412  44.936  56.842  1.00 23.08           N  
ATOM   5364  CA  GLY F  58      28.447  45.800  56.191  1.00 22.97           C  
ATOM   5365  C   GLY F  58      28.949  46.276  54.840  1.00 22.79           C  
ATOM   5366  O   GLY F  58      28.171  46.413  53.895  1.00 21.71           O  
ATOM   5367  N   LEU F  59      30.248  46.534  54.737  1.00 20.65           N  
ATOM   5368  CA  LEU F  59      30.799  46.974  53.466  1.00 21.15           C  
ATOM   5369  C   LEU F  59      30.790  45.776  52.527  1.00 20.40           C  
ATOM   5370  O   LEU F  59      30.527  45.912  51.331  1.00 20.80           O  
ATOM   5371  CB  LEU F  59      32.223  47.513  53.639  1.00 20.63           C  
ATOM   5372  CG  LEU F  59      32.879  48.065  52.368  1.00 22.28           C  
ATOM   5373  CD1 LEU F  59      31.970  49.103  51.713  1.00 20.60           C  
ATOM   5374  CD2 LEU F  59      34.237  48.678  52.722  1.00 20.04           C  
ATOM   5375  N   THR F  60      31.074  44.596  53.073  1.00 21.01           N  
ATOM   5376  CA  THR F  60      31.055  43.381  52.265  1.00 20.52           C  
ATOM   5377  C   THR F  60      29.652  43.244  51.666  1.00 20.14           C  
ATOM   5378  O   THR F  60      29.504  42.966  50.476  1.00 20.50           O  
ATOM   5379  CB  THR F  60      31.393  42.139  53.114  1.00 20.83           C  
ATOM   5380  OG1 THR F  60      32.784  42.176  53.461  1.00 19.24           O  
ATOM   5381  CG2 THR F  60      31.099  40.845  52.343  1.00 18.67           C  
ATOM   5382  N   ALA F  61      28.630  43.465  52.489  1.00 19.53           N  
ATOM   5383  CA  ALA F  61      27.249  43.390  52.018  1.00 21.45           C  
ATOM   5384  C   ALA F  61      27.045  44.440  50.938  1.00 21.64           C  
ATOM   5385  O   ALA F  61      26.449  44.160  49.897  1.00 23.00           O  
ATOM   5386  CB  ALA F  61      26.268  43.628  53.176  1.00 18.47           C  
ATOM   5387  N   THR F  62      27.540  45.649  51.186  1.00 20.99           N  
ATOM   5388  CA  THR F  62      27.408  46.723  50.212  1.00 21.54           C  
ATOM   5389  C   THR F  62      28.106  46.344  48.904  1.00 21.21           C  
ATOM   5390  O   THR F  62      27.597  46.624  47.814  1.00 20.02           O  
ATOM   5391  CB  THR F  62      28.012  48.039  50.745  1.00 23.33           C  
ATOM   5392  OG1 THR F  62      27.360  48.396  51.968  1.00 24.52           O  
ATOM   5393  CG2 THR F  62      27.819  49.169  49.730  1.00 22.87           C  
ATOM   5394  N   LEU F  63      29.273  45.715  49.018  1.00 21.12           N  
ATOM   5395  CA  LEU F  63      30.030  45.268  47.849  1.00 20.56           C  
ATOM   5396  C   LEU F  63      29.216  44.232  47.062  1.00 20.60           C  
ATOM   5397  O   LEU F  63      29.124  44.299  45.834  1.00 21.06           O  
ATOM   5398  CB  LEU F  63      31.371  44.658  48.286  1.00 20.04           C  
ATOM   5399  CG  LEU F  63      32.461  45.645  48.718  1.00 22.20           C  
ATOM   5400  CD1 LEU F  63      33.453  44.987  49.643  1.00 20.86           C  
ATOM   5401  CD2 LEU F  63      33.152  46.180  47.481  1.00 23.71           C  
ATOM   5402  N   VAL F  64      28.629  43.272  47.768  1.00 20.82           N  
ATOM   5403  CA  VAL F  64      27.823  42.251  47.103  1.00 21.53           C  
ATOM   5404  C   VAL F  64      26.696  42.913  46.299  1.00 21.82           C  
ATOM   5405  O   VAL F  64      26.594  42.727  45.090  1.00 22.10           O  
ATOM   5406  CB  VAL F  64      27.222  41.262  48.135  1.00 20.16           C  
ATOM   5407  CG1 VAL F  64      26.281  40.288  47.447  1.00 20.44           C  
ATOM   5408  CG2 VAL F  64      28.347  40.499  48.833  1.00 19.24           C  
ATOM   5409  N   ASP F  65      25.886  43.717  46.981  1.00 22.82           N  
ATOM   5410  CA  ASP F  65      24.755  44.418  46.381  1.00 23.29           C  
ATOM   5411  C   ASP F  65      25.086  45.205  45.102  1.00 24.36           C  
ATOM   5412  O   ASP F  65      24.442  45.024  44.060  1.00 23.83           O  
ATOM   5413  CB  ASP F  65      24.139  45.355  47.436  1.00 25.49           C  
ATOM   5414  CG  ASP F  65      22.876  46.056  46.947  1.00 27.84           C  
ATOM   5415  OD1 ASP F  65      22.477  45.854  45.779  1.00 30.17           O  
ATOM   5416  OD2 ASP F  65      22.285  46.819  47.740  1.00 28.93           O  
ATOM   5417  N   ASN F  66      26.087  46.077  45.176  1.00 23.70           N  
ATOM   5418  CA  ASN F  66      26.464  46.896  44.024  1.00 23.21           C  
ATOM   5419  C   ASN F  66      27.159  46.177  42.876  1.00 22.15           C  
ATOM   5420  O   ASN F  66      26.764  46.319  41.717  1.00 22.80           O  
ATOM   5421  CB  ASN F  66      27.315  48.079  44.486  1.00 21.70           C  
ATOM   5422  CG  ASN F  66      26.469  49.260  44.898  1.00 23.81           C  
ATOM   5423  OD1 ASN F  66      26.032  50.047  44.052  1.00 28.82           O  
ATOM   5424  ND2 ASN F  66      26.206  49.382  46.189  1.00 19.17           N  
ATOM   5425  N   ILE F  67      28.190  45.408  43.180  1.00 20.44           N  
ATOM   5426  CA  ILE F  67      28.888  44.703  42.116  1.00 20.41           C  
ATOM   5427  C   ILE F  67      27.950  43.650  41.518  1.00 20.41           C  
ATOM   5428  O   ILE F  67      28.025  43.329  40.331  1.00 19.77           O  
ATOM   5429  CB  ILE F  67      30.209  44.107  42.647  1.00 20.05           C  
ATOM   5430  CG1 ILE F  67      31.071  45.262  43.194  1.00 18.97           C  
ATOM   5431  CG2 ILE F  67      30.943  43.380  41.536  1.00 18.20           C  
ATOM   5432  CD1 ILE F  67      32.434  44.862  43.706  1.00 19.14           C  
ATOM   5433  N   SER F  68      27.046  43.140  42.345  1.00 21.00           N  
ATOM   5434  CA  SER F  68      26.041  42.177  41.900  1.00 23.23           C  
ATOM   5435  C   SER F  68      25.204  42.873  40.817  1.00 22.95           C  
ATOM   5436  O   SER F  68      24.853  42.282  39.793  1.00 23.89           O  
ATOM   5437  CB  SER F  68      25.149  41.795  43.085  1.00 24.71           C  
ATOM   5438  OG  SER F  68      24.184  40.840  42.726  1.00 29.55           O  
ATOM   5439  N   THR F  69      24.902  44.147  41.050  1.00 21.32           N  
ATOM   5440  CA  THR F  69      24.125  44.953  40.109  1.00 20.79           C  
ATOM   5441  C   THR F  69      24.872  45.163  38.791  1.00 20.92           C  
ATOM   5442  O   THR F  69      24.286  45.045  37.709  1.00 21.20           O  
ATOM   5443  CB  THR F  69      23.807  46.326  40.726  1.00 20.62           C  
ATOM   5444  OG1 THR F  69      23.032  46.131  41.908  1.00 19.10           O  
ATOM   5445  CG2 THR F  69      23.037  47.210  39.755  1.00 19.86           C  
HETATM 5446  N   MSE F  70      26.161  45.475  38.878  1.00 21.55           N  
HETATM 5447  CA  MSE F  70      26.969  45.693  37.674  1.00 21.66           C  
HETATM 5448  C   MSE F  70      26.944  44.471  36.756  1.00 19.83           C  
HETATM 5449  O   MSE F  70      26.970  44.599  35.531  1.00 20.42           O  
HETATM 5450  CB  MSE F  70      28.423  45.996  38.048  1.00 21.80           C  
HETATM 5451  CG  MSE F  70      28.629  47.254  38.874  1.00 24.24           C  
HETATM 5452 SE   MSE F  70      30.521  47.541  39.217  1.00 31.61          SE  
HETATM 5453  CE  MSE F  70      30.362  48.923  40.563  1.00 26.13           C  
ATOM   5454  N   ALA F  71      26.922  43.287  37.358  1.00 18.70           N  
ATOM   5455  CA  ALA F  71      26.892  42.043  36.596  1.00 18.53           C  
ATOM   5456  C   ALA F  71      25.568  41.953  35.863  1.00 18.54           C  
ATOM   5457  O   ALA F  71      25.510  41.509  34.723  1.00 18.36           O  
ATOM   5458  CB  ALA F  71      27.055  40.850  37.526  1.00 17.54           C  
ATOM   5459  N   LEU F  72      24.504  42.384  36.527  1.00 19.86           N  
ATOM   5460  CA  LEU F  72      23.180  42.344  35.932  1.00 23.73           C  
ATOM   5461  C   LEU F  72      23.109  43.337  34.768  1.00 25.50           C  
ATOM   5462  O   LEU F  72      22.416  43.096  33.771  1.00 23.67           O  
ATOM   5463  CB  LEU F  72      22.130  42.669  36.997  1.00 23.99           C  
ATOM   5464  CG  LEU F  72      21.113  41.597  37.410  1.00 25.07           C  
ATOM   5465  CD1 LEU F  72      21.570  40.208  37.018  1.00 23.94           C  
ATOM   5466  CD2 LEU F  72      20.898  41.695  38.915  1.00 23.62           C  
ATOM   5467  N   LEU F  73      23.834  44.450  34.896  1.00 27.07           N  
ATOM   5468  CA  LEU F  73      23.867  45.453  33.835  1.00 27.41           C  
ATOM   5469  C   LEU F  73      24.571  44.840  32.633  1.00 28.00           C  
ATOM   5470  O   LEU F  73      24.308  45.208  31.492  1.00 28.86           O  
ATOM   5471  CB  LEU F  73      24.633  46.701  34.284  1.00 26.92           C  
ATOM   5472  CG  LEU F  73      23.985  47.597  35.340  1.00 27.99           C  
ATOM   5473  CD1 LEU F  73      24.990  48.650  35.800  1.00 28.68           C  
ATOM   5474  CD2 LEU F  73      22.737  48.247  34.772  1.00 26.57           C  
ATOM   5475  N   CYS F  74      25.469  43.897  32.892  1.00 27.71           N  
ATOM   5476  CA  CYS F  74      26.200  43.261  31.806  1.00 28.05           C  
ATOM   5477  C   CYS F  74      25.469  42.065  31.215  1.00 27.61           C  
ATOM   5478  O   CYS F  74      26.081  41.054  30.875  1.00 28.74           O  
ATOM   5479  CB  CYS F  74      27.598  42.849  32.270  1.00 27.63           C  
ATOM   5480  SG  CYS F  74      28.687  44.257  32.646  1.00 31.00           S  
ATOM   5481  N   THR F  75      24.151  42.184  31.106  1.00 26.26           N  
ATOM   5482  CA  THR F  75      23.345  41.126  30.512  1.00 26.56           C  
ATOM   5483  C   THR F  75      22.535  41.728  29.383  1.00 29.22           C  
ATOM   5484  O   THR F  75      22.509  42.948  29.207  1.00 28.97           O  
ATOM   5485  CB  THR F  75      22.361  40.484  31.511  1.00 24.60           C  
ATOM   5486  OG1 THR F  75      21.497  41.492  32.055  1.00 18.06           O  
ATOM   5487  CG2 THR F  75      23.115  39.771  32.616  1.00 21.72           C  
ATOM   5488  N   GLU F  76      21.873  40.861  28.623  1.00 32.26           N  
ATOM   5489  CA  GLU F  76      21.056  41.284  27.500  1.00 35.25           C  
ATOM   5490  C   GLU F  76      19.933  42.206  27.975  1.00 36.10           C  
ATOM   5491  O   GLU F  76      19.718  43.271  27.394  1.00 36.20           O  
ATOM   5492  CB  GLU F  76      20.506  40.045  26.774  1.00 36.38           C  
ATOM   5493  CG  GLU F  76      21.628  39.115  26.283  1.00 39.65           C  
ATOM   5494  CD  GLU F  76      21.136  37.779  25.736  1.00 40.52           C  
ATOM   5495  OE1 GLU F  76      20.368  37.083  26.433  1.00 42.66           O  
ATOM   5496  OE2 GLU F  76      21.534  37.414  24.611  1.00 39.06           O  
ATOM   5497  N   ARG F  77      19.233  41.818  29.036  1.00 36.75           N  
ATOM   5498  CA  ARG F  77      18.157  42.651  29.562  1.00 38.06           C  
ATOM   5499  C   ARG F  77      18.734  43.902  30.213  1.00 37.12           C  
ATOM   5500  O   ARG F  77      18.140  44.979  30.151  1.00 38.00           O  
ATOM   5501  CB  ARG F  77      17.319  41.887  30.586  1.00 40.48           C  
ATOM   5502  CG  ARG F  77      16.158  42.709  31.131  1.00 43.56           C  
ATOM   5503  CD  ARG F  77      15.225  41.878  31.986  1.00 45.92           C  
ATOM   5504  NE  ARG F  77      14.113  42.674  32.501  1.00 47.91           N  
ATOM   5505  CZ  ARG F  77      13.145  42.193  33.275  1.00 47.88           C  
ATOM   5506  NH1 ARG F  77      13.146  40.912  33.626  1.00 47.51           N  
ATOM   5507  NH2 ARG F  77      12.179  42.997  33.701  1.00 48.29           N  
ATOM   5508  N   GLY F  78      19.891  43.745  30.848  1.00 36.99           N  
ATOM   5509  CA  GLY F  78      20.566  44.864  31.484  1.00 36.24           C  
ATOM   5510  C   GLY F  78      19.814  45.679  32.524  1.00 35.57           C  
ATOM   5511  O   GLY F  78      20.094  46.866  32.691  1.00 35.19           O  
ATOM   5512  N   ALA F  79      18.874  45.061  33.233  1.00 35.02           N  
ATOM   5513  CA  ALA F  79      18.111  45.770  34.259  1.00 34.15           C  
ATOM   5514  C   ALA F  79      18.813  45.637  35.612  1.00 33.57           C  
ATOM   5515  O   ALA F  79      19.243  44.550  35.988  1.00 34.64           O  
ATOM   5516  CB  ALA F  79      16.704  45.202  34.342  1.00 33.80           C  
ATOM   5517  N   PRO F  80      18.937  46.744  36.361  1.00 32.92           N  
ATOM   5518  CA  PRO F  80      19.597  46.712  37.668  1.00 33.27           C  
ATOM   5519  C   PRO F  80      18.814  45.939  38.735  1.00 33.34           C  
ATOM   5520  O   PRO F  80      19.384  45.139  39.471  1.00 32.67           O  
ATOM   5521  CB  PRO F  80      19.748  48.194  38.011  1.00 33.64           C  
ATOM   5522  CG  PRO F  80      18.517  48.791  37.393  1.00 34.20           C  
ATOM   5523  CD  PRO F  80      18.456  48.102  36.045  1.00 33.32           C  
ATOM   5524  N   GLY F  81      17.511  46.181  38.817  1.00 32.52           N  
ATOM   5525  CA  GLY F  81      16.701  45.483  39.799  1.00 31.09           C  
ATOM   5526  C   GLY F  81      16.785  46.058  41.203  1.00 30.35           C  
ATOM   5527  O   GLY F  81      17.644  46.884  41.495  1.00 30.76           O  
ATOM   5528  N   VAL F  82      15.871  45.620  42.067  1.00 29.82           N  
ATOM   5529  CA  VAL F  82      15.811  46.050  43.460  1.00 26.17           C  
ATOM   5530  C   VAL F  82      16.045  44.840  44.367  1.00 26.13           C  
ATOM   5531  O   VAL F  82      15.608  43.728  44.058  1.00 24.28           O  
ATOM   5532  CB  VAL F  82      14.442  46.650  43.801  1.00 25.83           C  
ATOM   5533  CG1 VAL F  82      14.452  47.178  45.212  1.00 24.49           C  
ATOM   5534  CG2 VAL F  82      14.106  47.762  42.826  1.00 28.21           C  
ATOM   5535  N   SER F  83      16.730  45.056  45.484  1.00 25.01           N  
ATOM   5536  CA  SER F  83      17.018  43.968  46.409  1.00 23.10           C  
ATOM   5537  C   SER F  83      15.776  43.322  47.007  1.00 21.01           C  
ATOM   5538  O   SER F  83      14.835  44.005  47.390  1.00 20.29           O  
ATOM   5539  CB  SER F  83      17.919  44.461  47.546  1.00 23.38           C  
ATOM   5540  OG  SER F  83      19.243  44.676  47.090  1.00 28.69           O  
ATOM   5541  N   VAL F  84      15.793  41.996  47.080  1.00 18.54           N  
ATOM   5542  CA  VAL F  84      14.704  41.220  47.660  1.00 18.15           C  
ATOM   5543  C   VAL F  84      15.293  40.443  48.841  1.00 19.50           C  
ATOM   5544  O   VAL F  84      14.837  40.576  49.979  1.00 20.35           O  
ATOM   5545  CB  VAL F  84      14.107  40.223  46.636  1.00 15.65           C  
ATOM   5546  CG1 VAL F  84      13.058  39.357  47.311  1.00 12.39           C  
ATOM   5547  CG2 VAL F  84      13.499  40.974  45.470  1.00 15.52           C  
ATOM   5548  N   ASP F  85      16.308  39.632  48.566  1.00 20.41           N  
ATOM   5549  CA  ASP F  85      16.974  38.863  49.617  1.00 24.23           C  
ATOM   5550  C   ASP F  85      18.475  38.909  49.402  1.00 24.32           C  
ATOM   5551  O   ASP F  85      18.943  39.093  48.288  1.00 24.77           O  
ATOM   5552  CB  ASP F  85      16.573  37.375  49.603  1.00 25.70           C  
ATOM   5553  CG  ASP F  85      15.072  37.148  49.721  1.00 31.24           C  
ATOM   5554  OD1 ASP F  85      14.431  37.665  50.662  1.00 33.96           O  
ATOM   5555  OD2 ASP F  85      14.535  36.419  48.862  1.00 31.42           O  
HETATM 5556  N   MSE F  86      19.225  38.745  50.483  1.00 25.08           N  
HETATM 5557  CA  MSE F  86      20.667  38.677  50.405  1.00 26.05           C  
HETATM 5558  C   MSE F  86      21.132  37.830  51.585  1.00 25.84           C  
HETATM 5559  O   MSE F  86      20.638  37.991  52.700  1.00 23.22           O  
HETATM 5560  CB  MSE F  86      21.308  40.065  50.462  1.00 29.54           C  
HETATM 5561  CG  MSE F  86      22.829  40.032  50.191  1.00 34.93           C  
HETATM 5562 SE   MSE F  86      23.708  41.781  50.179  1.00 43.91          SE  
HETATM 5563  CE  MSE F  86      23.537  42.187  52.061  1.00 38.97           C  
ATOM   5564  N   ASN F  87      22.053  36.905  51.324  1.00 24.81           N  
ATOM   5565  CA  ASN F  87      22.615  36.050  52.359  1.00 25.33           C  
ATOM   5566  C   ASN F  87      24.137  36.109  52.199  1.00 25.09           C  
ATOM   5567  O   ASN F  87      24.664  35.993  51.088  1.00 25.12           O  
ATOM   5568  CB  ASN F  87      22.125  34.610  52.204  0.50 28.53           C  
ATOM   5570  CG  ASN F  87      22.513  34.008  50.880  0.50 33.63           C  
ATOM   5572  OD1 ASN F  87      23.242  34.611  50.112  0.50 38.94           O  
ATOM   5574  ND2 ASN F  87      22.032  32.810  50.609  0.50 38.32           N  
ATOM   5576  N   ILE F  88      24.854  36.296  53.296  1.00 24.24           N  
ATOM   5577  CA  ILE F  88      26.303  36.352  53.205  1.00 23.65           C  
ATOM   5578  C   ILE F  88      26.929  35.424  54.223  1.00 23.09           C  
ATOM   5579  O   ILE F  88      26.555  35.426  55.389  1.00 21.71           O  
ATOM   5580  CB  ILE F  88      26.837  37.771  53.451  1.00 23.52           C  
ATOM   5581  CG1 ILE F  88      26.145  38.760  52.505  1.00 22.90           C  
ATOM   5582  CG2 ILE F  88      28.355  37.792  53.224  1.00 23.93           C  
ATOM   5583  CD1 ILE F  88      26.219  40.208  52.968  1.00 21.93           C  
ATOM   5584  N   THR F  89      27.872  34.617  53.760  1.00 22.07           N  
ATOM   5585  CA  THR F  89      28.579  33.701  54.635  1.00 25.22           C  
ATOM   5586  C   THR F  89      29.997  34.253  54.762  1.00 25.08           C  
ATOM   5587  O   THR F  89      30.690  34.455  53.763  1.00 24.51           O  
ATOM   5588  CB  THR F  89      28.604  32.266  54.047  1.00 26.00           C  
ATOM   5589  OG1 THR F  89      27.264  31.764  53.947  1.00 25.89           O  
ATOM   5590  CG2 THR F  89      29.408  31.342  54.936  1.00 27.52           C  
ATOM   5591  N   TYR F  90      30.400  34.548  55.994  1.00 26.53           N  
ATOM   5592  CA  TYR F  90      31.728  35.084  56.265  1.00 27.10           C  
ATOM   5593  C   TYR F  90      32.611  33.921  56.664  1.00 28.85           C  
ATOM   5594  O   TYR F  90      32.322  33.225  57.631  1.00 29.37           O  
ATOM   5595  CB  TYR F  90      31.670  36.109  57.396  1.00 24.53           C  
ATOM   5596  CG  TYR F  90      30.809  37.300  57.076  1.00 24.05           C  
ATOM   5597  CD1 TYR F  90      29.486  37.368  57.517  1.00 23.47           C  
ATOM   5598  CD2 TYR F  90      31.309  38.357  56.311  1.00 22.44           C  
ATOM   5599  CE1 TYR F  90      28.684  38.461  57.206  1.00 22.48           C  
ATOM   5600  CE2 TYR F  90      30.518  39.447  55.989  1.00 20.21           C  
ATOM   5601  CZ  TYR F  90      29.206  39.497  56.436  1.00 21.99           C  
ATOM   5602  OH  TYR F  90      28.409  40.565  56.092  1.00 18.46           O  
HETATM 5603  N   MSE F  91      33.692  33.721  55.921  1.00 29.93           N  
HETATM 5604  CA  MSE F  91      34.588  32.602  56.172  1.00 32.69           C  
HETATM 5605  C   MSE F  91      36.018  32.948  56.587  1.00 31.99           C  
HETATM 5606  O   MSE F  91      36.671  32.159  57.260  1.00 31.90           O  
HETATM 5607  CB  MSE F  91      34.609  31.719  54.932  1.00 35.81           C  
HETATM 5608  CG  MSE F  91      33.224  31.227  54.555  1.00 40.26           C  
HETATM 5609 SE   MSE F  91      33.122  30.552  52.760  1.00 47.72          SE  
HETATM 5610  CE  MSE F  91      32.417  32.137  51.900  1.00 45.08           C  
ATOM   5611  N   SER F  92      36.507  34.111  56.177  1.00 32.25           N  
ATOM   5612  CA  SER F  92      37.859  34.524  56.530  1.00 34.04           C  
ATOM   5613  C   SER F  92      37.936  36.037  56.540  1.00 33.74           C  
ATOM   5614  O   SER F  92      37.399  36.700  55.655  1.00 35.48           O  
ATOM   5615  CB  SER F  92      38.873  33.965  55.530  1.00 35.93           C  
ATOM   5616  OG  SER F  92      38.664  34.508  54.238  1.00 38.81           O  
ATOM   5617  N   PRO F  93      38.606  36.609  57.548  1.00 33.45           N  
ATOM   5618  CA  PRO F  93      38.728  38.067  57.646  1.00 32.78           C  
ATOM   5619  C   PRO F  93      39.610  38.665  56.556  1.00 33.06           C  
ATOM   5620  O   PRO F  93      40.529  38.017  56.062  1.00 35.87           O  
ATOM   5621  CB  PRO F  93      39.340  38.279  59.036  1.00 32.59           C  
ATOM   5622  CG  PRO F  93      38.976  37.027  59.786  1.00 33.08           C  
ATOM   5623  CD  PRO F  93      39.153  35.953  58.747  1.00 32.41           C  
ATOM   5624  N   ALA F  94      39.313  39.898  56.177  1.00 32.91           N  
ATOM   5625  CA  ALA F  94      40.109  40.614  55.187  1.00 32.87           C  
ATOM   5626  C   ALA F  94      40.748  41.712  56.030  1.00 32.60           C  
ATOM   5627  O   ALA F  94      40.047  42.588  56.543  1.00 30.22           O  
ATOM   5628  CB  ALA F  94      39.218  41.210  54.103  1.00 33.18           C  
ATOM   5629  N   LYS F  95      42.069  41.640  56.194  1.00 32.88           N  
ATOM   5630  CA  LYS F  95      42.811  42.601  57.019  1.00 33.58           C  
ATOM   5631  C   LYS F  95      43.168  43.922  56.339  1.00 34.04           C  
ATOM   5632  O   LYS F  95      43.121  44.049  55.116  1.00 34.65           O  
ATOM   5633  CB  LYS F  95      44.088  41.931  57.563  1.00 33.53           C  
ATOM   5634  N   LEU F  96      43.528  44.908  57.153  1.00 35.19           N  
ATOM   5635  CA  LEU F  96      43.909  46.222  56.649  1.00 35.26           C  
ATOM   5636  C   LEU F  96      45.088  46.064  55.692  1.00 36.04           C  
ATOM   5637  O   LEU F  96      45.962  45.228  55.908  1.00 35.10           O  
ATOM   5638  CB  LEU F  96      44.319  47.129  57.811  1.00 36.11           C  
ATOM   5639  CG  LEU F  96      43.864  48.595  57.799  1.00 36.90           C  
ATOM   5640  CD1 LEU F  96      44.526  49.315  58.956  1.00 38.42           C  
ATOM   5641  CD2 LEU F  96      44.220  49.267  56.489  1.00 37.45           C  
ATOM   5642  N   GLY F  97      45.105  46.869  54.634  1.00 36.86           N  
ATOM   5643  CA  GLY F  97      46.189  46.800  53.670  1.00 37.07           C  
ATOM   5644  C   GLY F  97      46.078  45.653  52.681  1.00 37.11           C  
ATOM   5645  O   GLY F  97      46.780  45.620  51.669  1.00 38.35           O  
ATOM   5646  N   GLU F  98      45.190  44.710  52.961  1.00 37.38           N  
ATOM   5647  CA  GLU F  98      45.012  43.563  52.085  1.00 37.47           C  
ATOM   5648  C   GLU F  98      44.299  43.928  50.783  1.00 36.32           C  
ATOM   5649  O   GLU F  98      43.518  44.875  50.735  1.00 34.68           O  
ATOM   5650  CB  GLU F  98      44.216  42.487  52.822  1.00 41.02           C  
ATOM   5651  CG  GLU F  98      44.163  41.146  52.123  1.00 45.83           C  
ATOM   5652  CD  GLU F  98      43.513  40.085  52.989  1.00 49.50           C  
ATOM   5653  OE1 GLU F  98      43.904  39.967  54.172  1.00 50.84           O  
ATOM   5654  OE2 GLU F  98      42.618  39.366  52.486  1.00 50.36           O  
ATOM   5655  N   ASP F  99      44.589  43.185  49.721  1.00 36.01           N  
ATOM   5656  CA  ASP F  99      43.935  43.412  48.437  1.00 36.30           C  
ATOM   5657  C   ASP F  99      42.897  42.316  48.258  1.00 35.54           C  
ATOM   5658  O   ASP F  99      43.200  41.130  48.407  1.00 35.80           O  
ATOM   5659  CB  ASP F  99      44.937  43.362  47.277  1.00 38.35           C  
ATOM   5660  CG  ASP F  99      45.738  44.647  47.136  1.00 40.68           C  
ATOM   5661  OD1 ASP F  99      45.117  45.725  47.010  1.00 41.12           O  
ATOM   5662  OD2 ASP F  99      46.986  44.579  47.148  1.00 41.23           O  
ATOM   5663  N   ILE F 100      41.666  42.708  47.952  1.00 34.27           N  
ATOM   5664  CA  ILE F 100      40.605  41.725  47.762  1.00 30.26           C  
ATOM   5665  C   ILE F 100      40.032  41.807  46.354  1.00 30.32           C  
ATOM   5666  O   ILE F 100      40.112  42.846  45.692  1.00 29.72           O  
ATOM   5667  CB  ILE F 100      39.459  41.918  48.784  1.00 28.97           C  
ATOM   5668  CG1 ILE F 100      38.747  43.249  48.545  1.00 27.90           C  
ATOM   5669  CG2 ILE F 100      40.010  41.896  50.194  1.00 29.85           C  
ATOM   5670  CD1 ILE F 100      37.592  43.483  49.494  1.00 25.68           C  
ATOM   5671  N   VAL F 101      39.467  40.695  45.902  1.00 28.54           N  
ATOM   5672  CA  VAL F 101      38.861  40.609  44.584  1.00 25.26           C  
ATOM   5673  C   VAL F 101      37.373  40.304  44.752  1.00 25.68           C  
ATOM   5674  O   VAL F 101      37.006  39.381  45.483  1.00 25.17           O  
ATOM   5675  CB  VAL F 101      39.506  39.481  43.751  1.00 24.93           C  
ATOM   5676  CG1 VAL F 101      38.843  39.397  42.382  1.00 22.08           C  
ATOM   5677  CG2 VAL F 101      41.017  39.718  43.621  1.00 24.77           C  
ATOM   5678  N   ILE F 102      36.524  41.094  44.100  1.00 25.27           N  
ATOM   5679  CA  ILE F 102      35.082  40.871  44.168  1.00 22.96           C  
ATOM   5680  C   ILE F 102      34.608  40.368  42.802  1.00 23.56           C  
ATOM   5681  O   ILE F 102      34.669  41.091  41.800  1.00 23.04           O  
ATOM   5682  CB  ILE F 102      34.293  42.162  44.531  1.00 23.12           C  
ATOM   5683  CG1 ILE F 102      34.875  42.821  45.784  1.00 22.06           C  
ATOM   5684  CG2 ILE F 102      32.836  41.813  44.795  1.00 22.17           C  
ATOM   5685  CD1 ILE F 102      35.988  43.817  45.489  1.00 22.86           C  
ATOM   5686  N   THR F 103      34.142  39.121  42.772  1.00 23.37           N  
ATOM   5687  CA  THR F 103      33.667  38.495  41.543  1.00 24.85           C  
ATOM   5688  C   THR F 103      32.166  38.216  41.605  1.00 23.57           C  
ATOM   5689  O   THR F 103      31.693  37.475  42.461  1.00 24.28           O  
ATOM   5690  CB  THR F 103      34.424  37.172  41.297  1.00 24.92           C  
ATOM   5691  OG1 THR F 103      35.829  37.447  41.219  1.00 26.38           O  
ATOM   5692  CG2 THR F 103      33.949  36.501  40.010  1.00 25.53           C  
ATOM   5693  N   ALA F 104      31.422  38.813  40.681  1.00 24.37           N  
ATOM   5694  CA  ALA F 104      29.970  38.646  40.626  1.00 23.89           C  
ATOM   5695  C   ALA F 104      29.547  37.870  39.394  1.00 23.02           C  
ATOM   5696  O   ALA F 104      29.988  38.168  38.285  1.00 23.37           O  
ATOM   5697  CB  ALA F 104      29.287  40.007  40.630  1.00 22.92           C  
ATOM   5698  N   HIS F 105      28.686  36.881  39.606  1.00 22.18           N  
ATOM   5699  CA  HIS F 105      28.156  36.036  38.539  1.00 22.10           C  
ATOM   5700  C   HIS F 105      26.636  36.102  38.565  1.00 22.72           C  
ATOM   5701  O   HIS F 105      26.024  35.984  39.633  1.00 20.82           O  
ATOM   5702  CB  HIS F 105      28.519  34.564  38.759  1.00 22.27           C  
ATOM   5703  CG  HIS F 105      29.968  34.243  38.577  1.00 26.30           C  
ATOM   5704  ND1 HIS F 105      30.521  33.970  37.342  1.00 25.81           N  
ATOM   5705  CD2 HIS F 105      30.967  34.097  39.480  1.00 25.45           C  
ATOM   5706  CE1 HIS F 105      31.798  33.666  37.494  1.00 27.08           C  
ATOM   5707  NE2 HIS F 105      32.093  33.736  38.781  1.00 29.34           N  
ATOM   5708  N   VAL F 106      26.027  36.296  37.400  1.00 22.52           N  
ATOM   5709  CA  VAL F 106      24.578  36.292  37.315  1.00 23.20           C  
ATOM   5710  C   VAL F 106      24.240  34.807  37.169  1.00 23.83           C  
ATOM   5711  O   VAL F 106      24.614  34.173  36.182  1.00 23.62           O  
ATOM   5712  CB  VAL F 106      24.074  37.074  36.085  1.00 23.53           C  
ATOM   5713  CG1 VAL F 106      22.555  36.944  35.964  1.00 22.12           C  
ATOM   5714  CG2 VAL F 106      24.461  38.536  36.217  1.00 23.23           C  
ATOM   5715  N   LEU F 107      23.554  34.250  38.159  1.00 23.23           N  
ATOM   5716  CA  LEU F 107      23.205  32.830  38.134  1.00 24.14           C  
ATOM   5717  C   LEU F 107      22.044  32.501  37.222  1.00 24.62           C  
ATOM   5718  O   LEU F 107      22.038  31.470  36.559  1.00 26.64           O  
ATOM   5719  CB  LEU F 107      22.882  32.346  39.544  1.00 22.93           C  
ATOM   5720  CG  LEU F 107      24.035  32.511  40.531  1.00 22.60           C  
ATOM   5721  CD1 LEU F 107      23.571  32.091  41.909  1.00 21.60           C  
ATOM   5722  CD2 LEU F 107      25.237  31.686  40.065  1.00 20.71           C  
ATOM   5723  N   LYS F 108      21.059  33.387  37.184  1.00 27.17           N  
ATOM   5724  CA  LYS F 108      19.887  33.158  36.359  1.00 28.80           C  
ATOM   5725  C   LYS F 108      18.959  34.352  36.470  1.00 29.19           C  
ATOM   5726  O   LYS F 108      18.979  35.076  37.463  1.00 28.42           O  
ATOM   5727  CB  LYS F 108      19.191  31.878  36.844  1.00 28.79           C  
ATOM   5728  CG  LYS F 108      17.719  32.009  37.186  1.00 30.46           C  
ATOM   5729  CD  LYS F 108      16.849  31.661  35.999  1.00 30.18           C  
ATOM   5730  CE  LYS F 108      15.414  31.478  36.440  1.00 32.31           C  
ATOM   5731  NZ  LYS F 108      14.550  31.057  35.313  1.00 33.25           N  
ATOM   5732  N   GLN F 109      18.161  34.583  35.441  1.00 30.82           N  
ATOM   5733  CA  GLN F 109      17.225  35.682  35.514  1.00 32.73           C  
ATOM   5734  C   GLN F 109      15.998  35.452  34.652  1.00 32.62           C  
ATOM   5735  O   GLN F 109      16.090  34.986  33.518  1.00 32.37           O  
ATOM   5736  CB  GLN F 109      17.909  37.009  35.169  1.00 34.03           C  
ATOM   5737  CG  GLN F 109      18.309  37.222  33.728  1.00 37.52           C  
ATOM   5738  CD  GLN F 109      18.799  38.649  33.497  1.00 38.77           C  
ATOM   5739  OE1 GLN F 109      18.135  39.619  33.890  1.00 38.05           O  
ATOM   5740  NE2 GLN F 109      19.957  38.783  32.857  1.00 39.20           N  
ATOM   5741  N   GLY F 110      14.840  35.759  35.222  1.00 33.09           N  
ATOM   5742  CA  GLY F 110      13.596  35.575  34.505  1.00 33.56           C  
ATOM   5743  C   GLY F 110      12.872  36.876  34.238  1.00 33.63           C  
ATOM   5744  O   GLY F 110      13.452  37.966  34.326  1.00 33.60           O  
ATOM   5745  N   LYS F 111      11.587  36.758  33.922  1.00 33.32           N  
ATOM   5746  CA  LYS F 111      10.773  37.919  33.621  1.00 32.65           C  
ATOM   5747  C   LYS F 111      10.781  38.954  34.735  1.00 32.18           C  
ATOM   5748  O   LYS F 111      10.774  40.151  34.461  1.00 33.61           O  
ATOM   5749  CB  LYS F 111       9.347  37.486  33.319  1.00 34.41           C  
ATOM   5750  N   THR F 112      10.829  38.509  35.986  1.00 31.06           N  
ATOM   5751  CA  THR F 112      10.794  39.453  37.100  1.00 29.64           C  
ATOM   5752  C   THR F 112      11.810  39.260  38.240  1.00 27.50           C  
ATOM   5753  O   THR F 112      11.922  40.110  39.123  1.00 26.03           O  
ATOM   5754  CB  THR F 112       9.378  39.474  37.706  1.00 31.17           C  
ATOM   5755  OG1 THR F 112       9.129  40.753  38.300  1.00 35.56           O  
ATOM   5756  CG2 THR F 112       9.240  38.400  38.769  1.00 30.83           C  
ATOM   5757  N   LEU F 113      12.549  38.156  38.227  1.00 25.49           N  
ATOM   5758  CA  LEU F 113      13.513  37.884  39.292  1.00 24.15           C  
ATOM   5759  C   LEU F 113      14.929  37.597  38.785  1.00 21.82           C  
ATOM   5760  O   LEU F 113      15.117  36.913  37.794  1.00 20.64           O  
ATOM   5761  CB  LEU F 113      13.010  36.699  40.125  1.00 25.73           C  
ATOM   5762  CG  LEU F 113      12.505  36.889  41.567  1.00 27.59           C  
ATOM   5763  CD1 LEU F 113      12.209  38.335  41.897  1.00 26.22           C  
ATOM   5764  CD2 LEU F 113      11.263  36.023  41.744  1.00 27.55           C  
ATOM   5765  N   ALA F 114      15.931  38.122  39.474  1.00 21.09           N  
ATOM   5766  CA  ALA F 114      17.308  37.884  39.053  1.00 20.45           C  
ATOM   5767  C   ALA F 114      18.133  37.356  40.217  1.00 19.09           C  
ATOM   5768  O   ALA F 114      18.021  37.854  41.330  1.00 21.39           O  
ATOM   5769  CB  ALA F 114      17.916  39.167  38.503  1.00 19.29           C  
ATOM   5770  N   PHE F 115      18.955  36.343  39.964  1.00 18.07           N  
ATOM   5771  CA  PHE F 115      19.773  35.772  41.030  1.00 18.70           C  
ATOM   5772  C   PHE F 115      21.257  35.864  40.717  1.00 18.78           C  
ATOM   5773  O   PHE F 115      21.690  35.526  39.621  1.00 19.56           O  
ATOM   5774  CB  PHE F 115      19.409  34.304  41.268  1.00 17.27           C  
ATOM   5775  CG  PHE F 115      17.934  34.061  41.397  1.00 17.90           C  
ATOM   5776  CD1 PHE F 115      17.161  33.820  40.274  1.00 19.04           C  
ATOM   5777  CD2 PHE F 115      17.317  34.098  42.638  1.00 15.96           C  
ATOM   5778  CE1 PHE F 115      15.784  33.620  40.385  1.00 20.56           C  
ATOM   5779  CE2 PHE F 115      15.955  33.901  42.758  1.00 18.26           C  
ATOM   5780  CZ  PHE F 115      15.185  33.659  41.629  1.00 19.22           C  
ATOM   5781  N   THR F 116      22.032  36.308  41.698  1.00 16.75           N  
ATOM   5782  CA  THR F 116      23.470  36.444  41.526  1.00 17.11           C  
ATOM   5783  C   THR F 116      24.245  35.827  42.682  1.00 17.64           C  
ATOM   5784  O   THR F 116      23.711  35.597  43.766  1.00 16.89           O  
ATOM   5785  CB  THR F 116      23.899  37.930  41.463  1.00 14.63           C  
ATOM   5786  OG1 THR F 116      23.611  38.546  42.720  1.00 13.33           O  
ATOM   5787  CG2 THR F 116      23.167  38.673  40.356  1.00 13.67           C  
ATOM   5788  N   SER F 117      25.522  35.575  42.432  1.00 20.90           N  
ATOM   5789  CA  SER F 117      26.414  35.050  43.453  1.00 23.65           C  
ATOM   5790  C   SER F 117      27.661  35.925  43.381  1.00 23.71           C  
ATOM   5791  O   SER F 117      28.104  36.273  42.292  1.00 24.66           O  
ATOM   5792  CB  SER F 117      26.782  33.597  43.178  1.00 24.31           C  
ATOM   5793  OG  SER F 117      27.492  33.089  44.290  1.00 27.70           O  
ATOM   5794  N   VAL F 118      28.216  36.279  44.534  1.00 22.48           N  
ATOM   5795  CA  VAL F 118      29.397  37.138  44.583  1.00 21.87           C  
ATOM   5796  C   VAL F 118      30.433  36.650  45.588  1.00 23.14           C  
ATOM   5797  O   VAL F 118      30.128  36.468  46.772  1.00 23.67           O  
ATOM   5798  CB  VAL F 118      29.032  38.582  44.989  1.00 20.24           C  
ATOM   5799  CG1 VAL F 118      30.284  39.455  44.985  1.00 21.02           C  
ATOM   5800  CG2 VAL F 118      27.981  39.145  44.051  1.00 19.29           C  
ATOM   5801  N   ASP F 119      31.662  36.455  45.091  1.00 22.40           N  
ATOM   5802  CA  ASP F 119      32.742  35.970  45.939  1.00 23.92           C  
ATOM   5803  C   ASP F 119      33.811  37.027  46.194  1.00 23.62           C  
ATOM   5804  O   ASP F 119      34.273  37.690  45.268  1.00 21.55           O  
ATOM   5805  CB  ASP F 119      33.410  34.750  45.310  1.00 25.08           C  
ATOM   5806  CG  ASP F 119      32.517  33.548  45.311  1.00 27.04           C  
ATOM   5807  OD1 ASP F 119      31.562  33.529  46.106  1.00 28.91           O  
ATOM   5808  OD2 ASP F 119      32.784  32.617  44.531  1.00 32.12           O  
ATOM   5809  N   LEU F 120      34.206  37.214  47.500  1.00 22.90           N  
ATOM   5810  CA  LEU F 120      35.296  38.110  47.885  1.00 24.31           C  
ATOM   5811  C   LEU F 120      36.474  37.197  48.172  1.00 26.18           C  
ATOM   5812  O   LEU F 120      36.370  36.292  49.000  1.00 28.94           O  
ATOM   5813  CB  LEU F 120      34.961  38.870  49.168  1.00 21.84           C  
ATOM   5814  CG  LEU F 120      33.849  39.918  49.310  1.00 24.61           C  
ATOM   5815  CD1 LEU F 120      34.465  41.299  49.307  1.00 23.19           C  
ATOM   5816  CD2 LEU F 120      32.780  39.749  48.224  1.00 23.26           C  
ATOM   5817  N   THR F 121      37.589  37.415  47.488  1.00 26.84           N  
ATOM   5818  CA  THR F 121      38.761  36.589  47.723  1.00 27.64           C  
ATOM   5819  C   THR F 121      40.002  37.431  47.939  1.00 28.84           C  
ATOM   5820  O   THR F 121      40.071  38.590  47.521  1.00 28.74           O  
ATOM   5821  CB  THR F 121      39.029  35.614  46.554  1.00 27.24           C  
ATOM   5822  OG1 THR F 121      38.983  36.324  45.310  1.00 26.83           O  
ATOM   5823  CG2 THR F 121      38.004  34.495  46.549  1.00 26.26           C  
ATOM   5824  N   ASN F 122      40.972  36.840  48.621  1.00 31.01           N  
ATOM   5825  CA  ASN F 122      42.231  37.506  48.878  1.00 31.38           C  
ATOM   5826  C   ASN F 122      42.916  37.476  47.525  1.00 31.52           C  
ATOM   5827  O   ASN F 122      43.108  36.409  46.956  1.00 31.80           O  
ATOM   5828  CB  ASN F 122      43.035  36.710  49.902  1.00 32.64           C  
ATOM   5829  CG  ASN F 122      44.355  37.371  50.247  1.00 33.94           C  
ATOM   5830  OD1 ASN F 122      45.171  37.652  49.367  1.00 33.14           O  
ATOM   5831  ND2 ASN F 122      44.575  37.618  51.535  1.00 33.51           N  
ATOM   5832  N   LYS F 123      43.266  38.640  46.995  1.00 31.86           N  
ATOM   5833  CA  LYS F 123      43.908  38.704  45.684  1.00 32.88           C  
ATOM   5834  C   LYS F 123      45.183  37.873  45.578  1.00 34.87           C  
ATOM   5835  O   LYS F 123      45.402  37.192  44.575  1.00 35.36           O  
ATOM   5836  CB  LYS F 123      44.219  40.159  45.321  1.00 30.41           C  
ATOM   5837  CG  LYS F 123      44.923  40.349  43.980  1.00 28.33           C  
ATOM   5838  CD  LYS F 123      45.151  41.839  43.737  1.00 29.38           C  
ATOM   5839  CE  LYS F 123      45.941  42.119  42.475  1.00 30.38           C  
ATOM   5840  NZ  LYS F 123      45.338  41.461  41.291  1.00 32.71           N  
ATOM   5841  N   ALA F 124      46.012  37.920  46.618  1.00 34.94           N  
ATOM   5842  CA  ALA F 124      47.279  37.198  46.620  1.00 36.96           C  
ATOM   5843  C   ALA F 124      47.147  35.697  46.790  1.00 36.70           C  
ATOM   5844  O   ALA F 124      47.717  34.926  46.020  1.00 36.60           O  
ATOM   5845  CB  ALA F 124      48.194  37.760  47.712  1.00 36.08           C  
ATOM   5846  N   THR F 125      46.394  35.291  47.805  1.00 38.56           N  
ATOM   5847  CA  THR F 125      46.201  33.881  48.121  1.00 39.26           C  
ATOM   5848  C   THR F 125      45.030  33.220  47.413  1.00 38.64           C  
ATOM   5849  O   THR F 125      44.994  31.997  47.274  1.00 39.24           O  
ATOM   5850  CB  THR F 125      45.986  33.704  49.625  1.00 41.72           C  
ATOM   5851  OG1 THR F 125      47.017  34.402  50.332  1.00 43.41           O  
ATOM   5852  CG2 THR F 125      46.024  32.231  50.002  1.00 44.36           C  
ATOM   5853  N   GLY F 126      44.067  34.023  46.973  1.00 37.20           N  
ATOM   5854  CA  GLY F 126      42.901  33.471  46.317  1.00 34.89           C  
ATOM   5855  C   GLY F 126      41.970  32.870  47.356  1.00 34.04           C  
ATOM   5856  O   GLY F 126      40.929  32.303  47.020  1.00 33.65           O  
ATOM   5857  N   LYS F 127      42.348  32.993  48.625  1.00 31.60           N  
ATOM   5858  CA  LYS F 127      41.545  32.464  49.720  1.00 32.58           C  
ATOM   5859  C   LYS F 127      40.205  33.188  49.804  1.00 32.49           C  
ATOM   5860  O   LYS F 127      40.136  34.419  49.759  1.00 32.21           O  
ATOM   5861  CB  LYS F 127      42.293  32.599  51.037  1.00 32.88           C  
ATOM   5862  N   LEU F 128      39.144  32.402  49.934  1.00 31.25           N  
ATOM   5863  CA  LEU F 128      37.785  32.917  50.006  1.00 29.28           C  
ATOM   5864  C   LEU F 128      37.552  33.719  51.288  1.00 27.12           C  
ATOM   5865  O   LEU F 128      37.800  33.233  52.387  1.00 26.79           O  
ATOM   5866  CB  LEU F 128      36.813  31.737  49.919  1.00 30.93           C  
ATOM   5867  CG  LEU F 128      35.391  31.895  49.381  1.00 31.70           C  
ATOM   5868  CD1 LEU F 128      35.367  32.746  48.116  1.00 29.90           C  
ATOM   5869  CD2 LEU F 128      34.842  30.497  49.097  1.00 29.78           C  
ATOM   5870  N   ILE F 129      37.089  34.959  51.134  1.00 25.22           N  
ATOM   5871  CA  ILE F 129      36.811  35.833  52.278  1.00 23.01           C  
ATOM   5872  C   ILE F 129      35.340  35.714  52.713  1.00 23.96           C  
ATOM   5873  O   ILE F 129      35.031  35.614  53.900  1.00 23.32           O  
ATOM   5874  CB  ILE F 129      37.112  37.316  51.926  1.00 22.95           C  
ATOM   5875  CG1 ILE F 129      38.621  37.512  51.747  1.00 21.63           C  
ATOM   5876  CG2 ILE F 129      36.553  38.247  53.009  1.00 17.32           C  
ATOM   5877  CD1 ILE F 129      39.003  38.921  51.351  1.00 23.28           C  
ATOM   5878  N   ALA F 130      34.440  35.726  51.739  1.00 22.02           N  
ATOM   5879  CA  ALA F 130      33.017  35.633  52.012  1.00 22.34           C  
ATOM   5880  C   ALA F 130      32.269  35.404  50.705  1.00 22.68           C  
ATOM   5881  O   ALA F 130      32.796  35.662  49.623  1.00 23.14           O  
ATOM   5882  CB  ALA F 130      32.524  36.908  52.683  1.00 21.95           C  
ATOM   5883  N   GLN F 131      31.039  34.917  50.814  1.00 22.00           N  
ATOM   5884  CA  GLN F 131      30.240  34.645  49.636  1.00 22.41           C  
ATOM   5885  C   GLN F 131      28.807  35.145  49.822  1.00 22.48           C  
ATOM   5886  O   GLN F 131      28.171  34.904  50.849  1.00 22.75           O  
ATOM   5887  CB  GLN F 131      30.264  33.144  49.352  1.00 23.56           C  
ATOM   5888  CG  GLN F 131      29.708  32.735  48.011  1.00 28.62           C  
ATOM   5889  CD  GLN F 131      29.748  31.230  47.825  1.00 29.06           C  
ATOM   5890  OE1 GLN F 131      30.514  30.701  47.013  1.00 31.27           O  
ATOM   5891  NE2 GLN F 131      28.926  30.531  48.591  1.00 29.51           N  
ATOM   5892  N   GLY F 132      28.316  35.867  48.826  1.00 22.83           N  
ATOM   5893  CA  GLY F 132      26.970  36.383  48.896  1.00 22.84           C  
ATOM   5894  C   GLY F 132      26.106  35.834  47.779  1.00 24.80           C  
ATOM   5895  O   GLY F 132      26.593  35.572  46.686  1.00 24.41           O  
ATOM   5896  N   ARG F 133      24.828  35.633  48.079  1.00 25.28           N  
ATOM   5897  CA  ARG F 133      23.838  35.149  47.123  1.00 25.47           C  
ATOM   5898  C   ARG F 133      22.810  36.264  47.231  1.00 22.25           C  
ATOM   5899  O   ARG F 133      22.400  36.635  48.334  1.00 19.78           O  
ATOM   5900  CB  ARG F 133      23.257  33.810  47.574  1.00 28.51           C  
ATOM   5901  CG  ARG F 133      24.312  32.784  47.939  1.00 34.04           C  
ATOM   5902  CD  ARG F 133      25.205  32.427  46.759  1.00 37.54           C  
ATOM   5903  NE  ARG F 133      26.132  31.357  47.117  1.00 43.64           N  
ATOM   5904  CZ  ARG F 133      26.879  30.683  46.246  1.00 46.78           C  
ATOM   5905  NH1 ARG F 133      26.820  30.968  44.954  1.00 48.93           N  
ATOM   5906  NH2 ARG F 133      27.671  29.702  46.665  1.00 48.24           N  
ATOM   5907  N   HIS F 134      22.380  36.777  46.090  1.00 21.89           N  
ATOM   5908  CA  HIS F 134      21.498  37.931  46.067  1.00 20.52           C  
ATOM   5909  C   HIS F 134      20.307  37.767  45.124  1.00 21.05           C  
ATOM   5910  O   HIS F 134      20.468  37.367  43.978  1.00 20.77           O  
ATOM   5911  CB  HIS F 134      22.384  39.117  45.644  1.00 21.72           C  
ATOM   5912  CG  HIS F 134      21.745  40.463  45.746  1.00 23.44           C  
ATOM   5913  ND1 HIS F 134      20.978  40.850  46.820  1.00 25.30           N  
ATOM   5914  CD2 HIS F 134      21.862  41.557  44.953  1.00 25.71           C  
ATOM   5915  CE1 HIS F 134      20.649  42.124  46.687  1.00 28.16           C  
ATOM   5916  NE2 HIS F 134      21.175  42.577  45.562  1.00 26.09           N  
ATOM   5917  N   THR F 135      19.107  38.062  45.617  1.00 20.43           N  
ATOM   5918  CA  THR F 135      17.916  37.986  44.779  1.00 19.51           C  
ATOM   5919  C   THR F 135      17.395  39.399  44.526  1.00 20.44           C  
ATOM   5920  O   THR F 135      17.166  40.164  45.460  1.00 20.62           O  
ATOM   5921  CB  THR F 135      16.786  37.153  45.426  1.00 16.72           C  
ATOM   5922  OG1 THR F 135      17.234  35.804  45.624  1.00 15.82           O  
ATOM   5923  CG2 THR F 135      15.566  37.131  44.504  1.00 15.95           C  
ATOM   5924  N   LYS F 136      17.224  39.744  43.255  1.00 21.59           N  
ATOM   5925  CA  LYS F 136      16.730  41.060  42.889  1.00 23.38           C  
ATOM   5926  C   LYS F 136      15.420  40.980  42.102  1.00 22.80           C  
ATOM   5927  O   LYS F 136      15.171  40.016  41.371  1.00 21.81           O  
ATOM   5928  CB  LYS F 136      17.786  41.820  42.071  1.00 25.61           C  
ATOM   5929  CG  LYS F 136      18.930  42.438  42.888  1.00 28.57           C  
ATOM   5930  CD  LYS F 136      19.913  43.135  41.960  1.00 30.29           C  
ATOM   5931  CE  LYS F 136      20.458  44.435  42.544  1.00 33.71           C  
ATOM   5932  NZ  LYS F 136      21.384  44.235  43.701  1.00 34.45           N  
ATOM   5933  N   HIS F 137      14.593  42.004  42.275  1.00 25.30           N  
ATOM   5934  CA  HIS F 137      13.301  42.123  41.607  1.00 30.05           C  
ATOM   5935  C   HIS F 137      13.475  43.121  40.467  1.00 31.11           C  
ATOM   5936  O   HIS F 137      13.860  44.265  40.697  1.00 31.04           O  
ATOM   5937  CB  HIS F 137      12.253  42.638  42.604  1.00 32.88           C  
ATOM   5938  CG  HIS F 137      10.849  42.642  42.080  1.00 35.69           C  
ATOM   5939  ND1 HIS F 137      10.301  41.574  41.403  1.00 38.30           N  
ATOM   5940  CD2 HIS F 137       9.862  43.563  42.187  1.00 38.38           C  
ATOM   5941  CE1 HIS F 137       9.038  41.835  41.116  1.00 38.18           C  
ATOM   5942  NE2 HIS F 137       8.746  43.035  41.582  1.00 39.07           N  
ATOM   5943  N   LEU F 138      13.206  42.681  39.242  1.00 32.67           N  
ATOM   5944  CA  LEU F 138      13.350  43.539  38.067  1.00 34.60           C  
ATOM   5945  C   LEU F 138      12.002  44.145  37.691  1.00 35.69           C  
ATOM   5946  O   LEU F 138      10.974  43.514  38.011  1.00 36.21           O  
ATOM   5947  CB  LEU F 138      13.874  42.719  36.880  1.00 33.93           C  
ATOM   5948  CG  LEU F 138      15.010  41.724  37.138  1.00 34.58           C  
ATOM   5949  CD1 LEU F 138      15.275  40.935  35.879  1.00 33.49           C  
ATOM   5950  CD2 LEU F 138      16.268  42.459  37.588  1.00 34.71           C  
TER    5951      LEU F 138                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
