
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  136 ( 1073),  selected  136 , name 1t82_D
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1t82_D.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_D      -       -           -
LGA    D     2_D      -       -           -
LGA    E     3_D      -       -           -
LGA    L     4_D      -       -           -
LGA    L     5_D      -       -           -
LGA    N     6_D      T       6           #
LGA    R     7_D      D       7          4.016
LGA    L     8_D      F       8          2.449
LGA    R     9_D      F       9          5.086
LGA    Q    10_D      G      10           #
LGA    T    11_D      L      11          1.625
LGA    W    12_D      T      12          3.414
LGA    H    13_D      I      13          3.176
LGA    S    14_D      -       -           -
LGA    T    15_D      -       -           -
LGA    I    16_D      -       -           -
LGA    P    17_D      P      14          2.423
LGA    V    18_D      F      15          1.824
LGA    S    19_D      M      16          1.054
LGA    E    20_D      Q      17          1.446
LGA    F    21_D      L      18          1.211
LGA    X    22_D      L      19          0.404
LGA    Q    23_D      G      20          1.340
LGA    I    24_D      V      21          1.913
LGA    A    25_D      V      22          2.150
LGA    P    26_D      P      23          0.969
LGA    L    27_D      E      24          1.566
LGA    S    28_D      H      25          2.657
LGA    F    29_D      S      26          3.957
LGA    T    30_D      G      27          7.137
LGA    D    31_D      N      28          6.178
LGA    G    32_D      G      29          4.519
LGA    E    33_D      T      30          2.839
LGA    L    34_D      A      31          1.161
LGA    S    35_D      R      32          0.911
LGA    V    36_D      T      33          0.489
LGA    S    37_D      R      34          1.206
LGA    A    38_D      L      35          1.819
LGA    P    39_D      P      36          1.931
LGA    L    40_D      A      37          2.058
LGA    A    41_D      R      38          0.757
LGA    -       -      A      39           -
LGA    P    42_D      D      40          2.823
LGA    N    43_D      L      41          1.353
LGA    I    44_D      V      42          1.298
LGA    N    45_D      N      43          1.617
LGA    L    46_D      S      44          1.830
LGA    H    47_D      R      45          2.395
LGA    H    48_D      G      46          2.296
LGA    T    49_D      D      47          1.617
LGA    X    50_D      I      48          0.805
LGA    F    51_D      H      49          0.569
LGA    A    52_D      G      50          1.031
LGA    G    53_D      G      51          0.693
LGA    S    54_D      T      52          0.451
LGA    I    55_D      L      53          0.426
LGA    Y    56_D      M      54          0.574
LGA    T    57_D      S      55          0.406
LGA    I    58_D      V      56          0.352
LGA    X    59_D      L      57          0.259
LGA    T    60_D      D      58          0.364
LGA    L    61_D      F      59          0.377
LGA    T    62_D      T      60          0.301
LGA    G    63_D      L      61          0.900
LGA    W    64_D      G      62          1.704
LGA    G    65_D      A      63          1.585
LGA    X    66_D      A      64          1.747
LGA    V    67_D      I      65          2.113
LGA    W    68_D      R      66          1.976
LGA    L    69_D      G      67          0.953
LGA    Q    70_D      D      68          2.437
LGA    Q    71_D      T      69          2.095
LGA    Q    72_D      P      70          3.119
LGA    L    73_D      -       -           -
LGA    L    74_D      -       -           -
LGA    N    75_D      -       -           -
LGA    V    76_D      E      71          4.219
LGA    D    77_D      V      72          2.878
LGA    G    78_D      G      73          3.268
LGA    D    79_D      -       -           -
LGA    I    80_D      V      74          1.640
LGA    V    81_D      A      75          0.968
LGA    L    82_D      T      76          0.753
LGA    A    83_D      I      77          0.754
LGA    D    84_D      D      78          0.684
LGA    A    85_D      M      79          0.913
LGA    H    86_D      N      80          0.725
LGA    I    87_D      T      81          0.575
LGA    R    88_D      S      82          0.453
LGA    Y    89_D      F      83          0.328
LGA    L    90_D      M      84          0.294
LGA    A    91_D      S      85          0.223
LGA    P    92_D      P      86          0.534
LGA    V    93_D      G      87          0.685
LGA    T    94_D      R      88          0.919
LGA    S    95_D      G      89          1.154
LGA    A    96_D      D      90          1.288
LGA    P    97_D      L      91          0.776
LGA    E    98_D      V      92          0.840
LGA    V    99_D      I      93          0.620
LGA    K   100_D      E      94          0.452
LGA    V   101_D      T      95          0.837
LGA    R   102_D      R      96          1.521
LGA    W   103_D      C      97          2.127
LGA    P   104_D      L      98          2.114
LGA    -       -      R      99           -
LGA    -       -      R     100           -
LGA    Q   112_D      G     101           #
LGA    R   113_D      A     102           #
LGA    G   114_D      -       -           -
LGA    R   115_D      -       -           -
LGA    K   116_D      -       -           -
LGA    A   117_D      S     103          1.018
LGA    K   118_D      I     104          0.641
LGA    V   119_D      A     105          0.912
LGA    K   120_D      F     106          1.112
LGA    L   121_D      C     107          0.429
LGA    E   122_D      E     108          0.533
LGA    V   123_D      G     109          1.319
LGA    Q   124_D      E     110          0.885
LGA    L   125_D      I     111          0.872
LGA    F   126_D      R     112          0.858
LGA    C   127_D      D     113          0.868
LGA    D   128_D      S     114          2.207
LGA    -       -      A     115           -
LGA    G   129_D      G     116          0.626
LGA    K   130_D      E     117          0.711
LGA    L   131_D      L     118          0.928
LGA    C   132_D      V     119          0.953
LGA    A   133_D      A     120          0.407
LGA    Q   134_D      K     121          0.794
LGA    F   135_D      A     122          0.508
LGA    D   136_D      T     123          0.677
LGA    G   137_D      A     124          0.478
LGA    L   138_D      T     125          0.394
LGA    Y   139_D      F     126          0.625
LGA    V   140_D      K     127          0.661
LGA    S   141_D      I     128          0.709
LGA    V   142_D      I     129          1.687
LGA    P   143_D      Q     130          2.015

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  136  125    5.0    117    1.89    12.82     84.748     5.875

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.821476 * X  +   0.285426 * Y  +   0.493669 * Z  +  28.930502
  Y_new =   0.172613 * X  +   0.949566 * Y  +  -0.261781 * Z  +  23.933048
  Z_new =  -0.543491 * X  +  -0.129833 * Y  +  -0.829314 * Z  + 106.931000 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.986299    0.155294  [ DEG:  -171.1023      8.8977 ]
  Theta =   0.574590    2.567003  [ DEG:    32.9216    147.0784 ]
  Phi   =   2.934480   -0.207113  [ DEG:   168.1333    -11.8667 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1t82_D                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1t82_D.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  136  125   5.0  117   1.89   12.82  84.748
REMARK  ---------------------------------------------------------- 
MOLECULE 1t82_D
HEADER    TRANSFERASE                             11-MAY-04   1T82              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE THIOESTERASE FROM                   
TITLE    2 SHEWANELLA ONEIDENSIS, NORTHEAST STRUCTURAL GENOMICS                 
TITLE    3 TARGET SOR51                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL ACETYLTRANSFERASE;                            
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHEWANELLA ONEIDENSIS MR-1;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PET21;                                     
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: BL21(DE3)+MAGIC                           
KEYWDS    STRUCTURAL GENOMICS, ALPHA-BETA DIMERIC PROTEIN WITH A FOLD           
KEYWDS   2 RESEMBLING A HOTDOG, PSI, PROTEIN STRUCTURE INITIATIVE,              
KEYWDS   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,I.LEE,S.M.VOROBIEV,R.XIAO,T.B.ACTON,                       
AUTHOR   2 G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL                  
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   2   25-JAN-05 1T82    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   18-MAY-04 1T82    0                                                
JRNL        AUTH   F.FOROUHAR,I.LEE,S.M.VOROBIEV,R.XIAO,T.B.ACTON,              
JRNL        AUTH 2 G.T.MONTELIONE,J.F.HUNT,L.TONG                               
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE THIOESTERASE               
JRNL        TITL 2 FROM SHEWANELLA ONEIDENSIS, NORTHEAST STRUCTURAL             
JRNL        TITL 3 GENOMICS TARGET SOR51                                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1T82 A    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
DBREF  1T82 B    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
DBREF  1T82 C    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
DBREF  1T82 D    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
SEQRES   1 A  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 A  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 A  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 A  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 A  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 A  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 A  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 A  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 A  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 A  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 A  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 A  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
SEQRES   1 B  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 B  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 B  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 B  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 B  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 B  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 B  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 B  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 B  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 B  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 B  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 B  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
SEQRES   1 C  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 C  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 C  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 C  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 C  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 C  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 C  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 C  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 C  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 C  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 C  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 C  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
SEQRES   1 D  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 D  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 D  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 D  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 D  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 D  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 D  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 D  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 D  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 D  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 D  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 D  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
HET    MSE  A   1       8                                                       
HET    MSE  A  22       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  59       8                                                       
HET    MSE  A  66       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  22       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B  66       8                                                       
HET    MSE  C  22       8                                                       
HET    MSE  C  50       8                                                       
HET    MSE  C  59       8                                                       
HET    MSE  C  66       8                                                       
HET    MSE  C 145       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  22       8                                                       
HET    MSE  D  50       8                                                       
HET    MSE  D  59       8                                                       
HET    MSE  D  66       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   5  HOH   *434(H2 O)                                                    
CRYST1   54.980   49.669   99.670  90.00  91.09  90.00 P 1 21 1      8          
HETATM 3428  N   MSE D   1      33.560  45.875  29.184  1.00 29.81           N  
HETATM 3429  CA  MSE D   1      34.813  46.555  28.737  1.00 29.79           C  
HETATM 3430  C   MSE D   1      35.044  47.856  29.497  1.00 27.81           C  
HETATM 3431  O   MSE D   1      34.190  48.297  30.262  1.00 25.90           O  
HETATM 3432  CB  MSE D   1      34.750  46.838  27.235  1.00 33.25           C  
HETATM 3433  CG  MSE D   1      34.880  45.602  26.354  1.00 36.61           C  
HETATM 3434 SE   MSE D   1      33.580  44.214  26.734  1.00 42.87          SE  
HETATM 3435  CE  MSE D   1      31.993  45.099  26.075  1.00 39.46           C  
ATOM   3436  N   ASP D   2      36.202  48.470  29.274  1.00 26.88           N  
ATOM   3437  CA  ASP D   2      36.556  49.714  29.952  1.00 25.84           C  
ATOM   3438  C   ASP D   2      35.456  50.772  29.918  1.00 24.21           C  
ATOM   3439  O   ASP D   2      35.067  51.304  30.958  1.00 24.48           O  
ATOM   3440  CB  ASP D   2      37.839  50.291  29.350  1.00 27.81           C  
ATOM   3441  CG  ASP D   2      38.993  49.313  29.398  1.00 29.52           C  
ATOM   3442  OD1 ASP D   2      39.305  48.810  30.498  1.00 29.32           O  
ATOM   3443  OD2 ASP D   2      39.591  49.048  28.333  1.00 31.93           O  
ATOM   3444  N   GLU D   3      34.961  51.078  28.724  1.00 23.08           N  
ATOM   3445  CA  GLU D   3      33.911  52.079  28.547  1.00 21.98           C  
ATOM   3446  C   GLU D   3      32.653  51.748  29.343  1.00 21.25           C  
ATOM   3447  O   GLU D   3      32.045  52.619  29.972  1.00 19.29           O  
ATOM   3448  CB  GLU D   3      33.567  52.197  27.059  1.00 24.68           C  
ATOM   3449  CG  GLU D   3      32.254  52.898  26.748  1.00 27.06           C  
ATOM   3450  CD  GLU D   3      32.206  54.320  27.260  1.00 29.17           C  
ATOM   3451  OE1 GLU D   3      33.098  55.119  26.899  1.00 31.68           O  
ATOM   3452  OE2 GLU D   3      31.268  54.643  28.017  1.00 31.55           O  
ATOM   3453  N   LEU D   4      32.273  50.478  29.309  1.00 20.06           N  
ATOM   3454  CA  LEU D   4      31.091  50.011  30.011  1.00 19.50           C  
ATOM   3455  C   LEU D   4      31.331  50.021  31.520  1.00 17.51           C  
ATOM   3456  O   LEU D   4      30.486  50.477  32.290  1.00 16.42           O  
ATOM   3457  CB  LEU D   4      30.748  48.596  29.538  1.00 21.26           C  
ATOM   3458  CG  LEU D   4      29.363  48.043  29.860  1.00 24.15           C  
ATOM   3459  CD1 LEU D   4      28.291  48.914  29.211  1.00 23.36           C  
ATOM   3460  CD2 LEU D   4      29.267  46.612  29.344  1.00 24.75           C  
ATOM   3461  N   LEU D   5      32.489  49.524  31.940  1.00 16.73           N  
ATOM   3462  CA  LEU D   5      32.815  49.479  33.362  1.00 15.26           C  
ATOM   3463  C   LEU D   5      33.006  50.874  33.939  1.00 14.70           C  
ATOM   3464  O   LEU D   5      32.728  51.110  35.115  1.00 13.27           O  
ATOM   3465  CB  LEU D   5      34.072  48.639  33.594  1.00 16.31           C  
ATOM   3466  CG  LEU D   5      33.951  47.167  33.189  1.00 19.28           C  
ATOM   3467  CD1 LEU D   5      35.226  46.432  33.559  1.00 20.07           C  
ATOM   3468  CD2 LEU D   5      32.754  46.533  33.885  1.00 17.80           C  
ATOM   3469  N   ASN D   6      33.476  51.802  33.114  1.00 14.94           N  
ATOM   3470  CA  ASN D   6      33.676  53.165  33.582  1.00 14.92           C  
ATOM   3471  C   ASN D   6      32.315  53.804  33.847  1.00 14.58           C  
ATOM   3472  O   ASN D   6      32.141  54.520  34.834  1.00 13.66           O  
ATOM   3473  CB  ASN D   6      34.461  53.973  32.545  1.00 18.94           C  
ATOM   3474  CG  ASN D   6      34.881  55.326  33.068  1.00 23.63           C  
ATOM   3475  OD1 ASN D   6      34.060  56.233  33.206  1.00 28.67           O  
ATOM   3476  ND2 ASN D   6      36.166  55.468  33.380  1.00 27.33           N  
ATOM   3477  N   ARG D   7      31.352  53.534  32.969  1.00 14.36           N  
ATOM   3478  CA  ARG D   7      30.001  54.069  33.125  1.00 14.82           C  
ATOM   3479  C   ARG D   7      29.381  53.534  34.409  1.00 14.26           C  
ATOM   3480  O   ARG D   7      28.720  54.267  35.144  1.00 13.41           O  
ATOM   3481  CB  ARG D   7      29.118  53.662  31.941  1.00 17.41           C  
ATOM   3482  CG  ARG D   7      29.429  54.367  30.637  1.00 22.31           C  
ATOM   3483  CD  ARG D   7      28.753  53.653  29.474  1.00 25.76           C  
ATOM   3484  NE  ARG D   7      27.327  53.448  29.708  1.00 29.25           N  
ATOM   3485  CZ  ARG D   7      26.552  52.673  28.956  1.00 30.38           C  
ATOM   3486  NH1 ARG D   7      27.068  52.026  27.919  1.00 32.38           N  
ATOM   3487  NH2 ARG D   7      25.265  52.539  29.244  1.00 31.80           N  
ATOM   3488  N   LEU D   8      29.597  52.249  34.669  1.00 12.60           N  
ATOM   3489  CA  LEU D   8      29.052  51.614  35.867  1.00 11.36           C  
ATOM   3490  C   LEU D   8      29.601  52.287  37.120  1.00 11.63           C  
ATOM   3491  O   LEU D   8      28.842  52.626  38.029  1.00 10.80           O  
ATOM   3492  CB  LEU D   8      29.395  50.120  35.875  1.00 12.10           C  
ATOM   3493  CG  LEU D   8      28.950  49.284  37.078  1.00 11.17           C  
ATOM   3494  CD1 LEU D   8      27.453  49.434  37.306  1.00 12.54           C  
ATOM   3495  CD2 LEU D   8      29.308  47.828  36.833  1.00 12.38           C  
ATOM   3496  N   ARG D   9      30.916  52.493  37.165  1.00 11.42           N  
ATOM   3497  CA  ARG D   9      31.538  53.132  38.322  1.00 12.72           C  
ATOM   3498  C   ARG D   9      30.960  54.528  38.534  1.00 13.52           C  
ATOM   3499  O   ARG D   9      30.555  54.881  39.640  1.00 12.03           O  
ATOM   3500  CB  ARG D   9      33.055  53.244  38.135  1.00 13.54           C  
ATOM   3501  CG  ARG D   9      33.783  53.716  39.389  1.00 14.18           C  
ATOM   3502  CD  ARG D   9      35.243  54.070  39.119  1.00 15.33           C  
ATOM   3503  NE  ARG D   9      35.363  55.210  38.216  1.00 17.55           N  
ATOM   3504  CZ  ARG D   9      35.667  55.119  36.925  1.00 18.55           C  
ATOM   3505  NH1 ARG D   9      35.889  53.935  36.372  1.00 19.22           N  
ATOM   3506  NH2 ARG D   9      35.734  56.215  36.184  1.00 19.66           N  
ATOM   3507  N   GLN D  10      30.929  55.318  37.465  1.00 13.28           N  
ATOM   3508  CA  GLN D  10      30.409  56.678  37.533  1.00 14.61           C  
ATOM   3509  C   GLN D  10      28.965  56.696  38.016  1.00 14.90           C  
ATOM   3510  O   GLN D  10      28.565  57.583  38.773  1.00 15.90           O  
ATOM   3511  CB  GLN D  10      30.497  57.353  36.162  1.00 15.35           C  
ATOM   3512  CG  GLN D  10      31.910  57.470  35.613  1.00 20.66           C  
ATOM   3513  CD  GLN D  10      31.953  58.175  34.269  1.00 22.61           C  
ATOM   3514  OE1 GLN D  10      31.248  57.795  33.333  1.00 24.83           O  
ATOM   3515  NE2 GLN D  10      32.787  59.207  34.166  1.00 25.45           N  
ATOM   3516  N   THR D  11      28.182  55.719  37.572  1.00 13.34           N  
ATOM   3517  CA  THR D  11      26.786  55.630  37.973  1.00 15.04           C  
ATOM   3518  C   THR D  11      26.707  55.417  39.480  1.00 14.27           C  
ATOM   3519  O   THR D  11      25.942  56.090  40.172  1.00 14.20           O  
ATOM   3520  CB  THR D  11      26.074  54.469  37.259  1.00 15.97           C  
ATOM   3521  OG1 THR D  11      26.149  54.662  35.841  1.00 20.84           O  
ATOM   3522  CG2 THR D  11      24.607  54.406  37.676  1.00 18.69           C  
ATOM   3523  N   TRP D  12      27.508  54.483  39.987  1.00 11.74           N  
ATOM   3524  CA  TRP D  12      27.516  54.215  41.421  1.00 12.04           C  
ATOM   3525  C   TRP D  12      27.905  55.444  42.224  1.00 11.52           C  
ATOM   3526  O   TRP D  12      27.170  55.875  43.110  1.00 11.66           O  
ATOM   3527  CB  TRP D  12      28.502  53.100  41.782  1.00 10.16           C  
ATOM   3528  CG  TRP D  12      28.080  51.724  41.401  1.00  9.67           C  
ATOM   3529  CD1 TRP D  12      26.812  51.290  41.149  1.00  8.72           C  
ATOM   3530  CD2 TRP D  12      28.930  50.581  41.274  1.00  9.83           C  
ATOM   3531  NE1 TRP D  12      26.820  49.945  40.872  1.00  8.98           N  
ATOM   3532  CE2 TRP D  12      28.107  49.483  40.942  1.00 10.28           C  
ATOM   3533  CE3 TRP D  12      30.309  50.379  41.411  1.00  9.14           C  
ATOM   3534  CZ2 TRP D  12      28.618  48.196  40.740  1.00  9.99           C  
ATOM   3535  CZ3 TRP D  12      30.820  49.095  41.212  1.00  9.06           C  
ATOM   3536  CH2 TRP D  12      29.972  48.022  40.880  1.00 11.83           C  
ATOM   3537  N   HIS D  13      29.068  56.007  41.914  1.00 12.40           N  
ATOM   3538  CA  HIS D  13      29.571  57.158  42.650  1.00 12.94           C  
ATOM   3539  C   HIS D  13      28.730  58.424  42.549  1.00 14.17           C  
ATOM   3540  O   HIS D  13      28.727  59.232  43.477  1.00 15.83           O  
ATOM   3541  CB  HIS D  13      31.015  57.461  42.232  1.00 13.28           C  
ATOM   3542  CG  HIS D  13      31.978  56.352  42.533  1.00 13.48           C  
ATOM   3543  ND1 HIS D  13      33.326  56.444  42.263  1.00 11.61           N  
ATOM   3544  CD2 HIS D  13      31.783  55.116  43.053  1.00 12.25           C  
ATOM   3545  CE1 HIS D  13      33.920  55.313  42.600  1.00 11.31           C  
ATOM   3546  NE2 HIS D  13      33.006  54.490  43.082  1.00 10.37           N  
ATOM   3547  N   SER D  14      28.017  58.597  41.441  1.00 13.45           N  
ATOM   3548  CA  SER D  14      27.193  59.793  41.265  1.00 15.77           C  
ATOM   3549  C   SER D  14      25.788  59.652  41.853  1.00 16.23           C  
ATOM   3550  O   SER D  14      25.077  60.645  42.007  1.00 18.34           O  
ATOM   3551  CB  SER D  14      27.088  60.158  39.779  1.00 17.31           C  
ATOM   3552  OG  SER D  14      26.281  59.235  39.071  1.00 18.92           O  
ATOM   3553  N   THR D  15      25.389  58.431  42.199  1.00 14.22           N  
ATOM   3554  CA  THR D  15      24.056  58.214  42.753  1.00 13.24           C  
ATOM   3555  C   THR D  15      24.038  57.632  44.167  1.00 12.61           C  
ATOM   3556  O   THR D  15      23.057  57.791  44.893  1.00 11.82           O  
ATOM   3557  CB  THR D  15      23.223  57.282  41.848  1.00 14.63           C  
ATOM   3558  OG1 THR D  15      23.826  55.983  41.808  1.00 14.36           O  
ATOM   3559  CG2 THR D  15      23.143  57.841  40.432  1.00 15.74           C  
ATOM   3560  N   ILE D  16      25.120  56.963  44.551  1.00 10.47           N  
ATOM   3561  CA  ILE D  16      25.212  56.341  45.870  1.00  9.44           C  
ATOM   3562  C   ILE D  16      26.449  56.856  46.608  1.00  9.25           C  
ATOM   3563  O   ILE D  16      27.533  56.286  46.480  1.00  8.49           O  
ATOM   3564  CB  ILE D  16      25.309  54.808  45.728  1.00  9.48           C  
ATOM   3565  CG1 ILE D  16      24.167  54.301  44.847  1.00 11.27           C  
ATOM   3566  CG2 ILE D  16      25.260  54.144  47.100  1.00 10.52           C  
ATOM   3567  CD1 ILE D  16      24.296  52.847  44.461  1.00 11.54           C  
ATOM   3568  N   PRO D  17      26.305  57.942  47.390  1.00  9.04           N  
ATOM   3569  CA  PRO D  17      27.415  58.535  48.146  1.00  9.12           C  
ATOM   3570  C   PRO D  17      28.293  57.541  48.910  1.00  8.90           C  
ATOM   3571  O   PRO D  17      29.509  57.718  49.001  1.00  9.22           O  
ATOM   3572  CB  PRO D  17      26.709  59.522  49.071  1.00 10.02           C  
ATOM   3573  CG  PRO D  17      25.575  59.991  48.225  1.00  8.99           C  
ATOM   3574  CD  PRO D  17      25.060  58.703  47.609  1.00 10.69           C  
ATOM   3575  N   VAL D  18      27.674  56.500  49.460  1.00  8.52           N  
ATOM   3576  CA  VAL D  18      28.404  55.489  50.211  1.00  8.46           C  
ATOM   3577  C   VAL D  18      29.378  54.714  49.334  1.00  7.73           C  
ATOM   3578  O   VAL D  18      30.472  54.354  49.781  1.00  6.77           O  
ATOM   3579  CB  VAL D  18      27.439  54.479  50.877  1.00 10.31           C  
ATOM   3580  CG1 VAL D  18      28.208  53.257  51.363  1.00 12.32           C  
ATOM   3581  CG2 VAL D  18      26.728  55.142  52.035  1.00 12.94           C  
ATOM   3582  N   SER D  19      28.989  54.454  48.090  1.00  7.16           N  
ATOM   3583  CA  SER D  19      29.856  53.695  47.190  1.00  7.41           C  
ATOM   3584  C   SER D  19      31.101  54.510  46.856  1.00  8.56           C  
ATOM   3585  O   SER D  19      32.175  53.952  46.637  1.00  9.00           O  
ATOM   3586  CB  SER D  19      29.105  53.295  45.905  1.00  7.11           C  
ATOM   3587  OG  SER D  19      28.859  54.396  45.045  1.00  6.57           O  
ATOM   3588  N   GLU D  20      30.950  55.829  46.839  1.00  8.78           N  
ATOM   3589  CA  GLU D  20      32.060  56.727  46.552  1.00 10.74           C  
ATOM   3590  C   GLU D  20      32.991  56.781  47.764  1.00  9.28           C  
ATOM   3591  O   GLU D  20      34.213  56.786  47.614  1.00 10.95           O  
ATOM   3592  CB  GLU D  20      31.531  58.120  46.215  1.00 13.44           C  
ATOM   3593  CG  GLU D  20      32.601  59.131  45.851  1.00 19.83           C  
ATOM   3594  CD  GLU D  20      32.004  60.456  45.423  1.00 22.72           C  
ATOM   3595  OE1 GLU D  20      31.216  61.036  46.200  1.00 25.54           O  
ATOM   3596  OE2 GLU D  20      32.326  60.919  44.310  1.00 26.02           O  
ATOM   3597  N   PHE D  21      32.425  56.817  48.968  1.00  8.56           N  
ATOM   3598  CA  PHE D  21      33.263  56.841  50.163  1.00  8.87           C  
ATOM   3599  C   PHE D  21      34.067  55.542  50.234  1.00  7.90           C  
ATOM   3600  O   PHE D  21      35.278  55.565  50.459  1.00  9.36           O  
ATOM   3601  CB  PHE D  21      32.430  56.984  51.448  1.00  7.88           C  
ATOM   3602  CG  PHE D  21      33.258  56.932  52.709  1.00  8.90           C  
ATOM   3603  CD1 PHE D  21      33.950  58.057  53.156  1.00 10.61           C  
ATOM   3604  CD2 PHE D  21      33.406  55.738  53.410  1.00 10.67           C  
ATOM   3605  CE1 PHE D  21      34.776  57.990  54.280  1.00 11.04           C  
ATOM   3606  CE2 PHE D  21      34.229  55.659  54.535  1.00  9.58           C  
ATOM   3607  CZ  PHE D  21      34.917  56.786  54.971  1.00 11.15           C  
HETATM 3608  N   MSE D  22      33.389  54.412  50.033  1.00  8.59           N  
HETATM 3609  CA  MSE D  22      34.035  53.095  50.081  1.00  6.40           C  
HETATM 3610  C   MSE D  22      34.959  52.852  48.889  1.00  7.05           C  
HETATM 3611  O   MSE D  22      35.732  51.891  48.873  1.00  6.18           O  
HETATM 3612  CB  MSE D  22      32.980  51.986  50.107  1.00  8.47           C  
HETATM 3613  CG  MSE D  22      32.189  51.909  51.391  1.00  7.40           C  
HETATM 3614 SE   MSE D  22      30.891  50.481  51.311  1.00 16.27          SE  
HETATM 3615  CE  MSE D  22      30.162  50.608  53.088  1.00 10.31           C  
ATOM   3616  N   GLN D  23      34.852  53.720  47.889  1.00  7.12           N  
ATOM   3617  CA  GLN D  23      35.656  53.628  46.681  1.00  8.56           C  
ATOM   3618  C   GLN D  23      35.516  52.294  45.958  1.00  7.71           C  
ATOM   3619  O   GLN D  23      36.494  51.701  45.502  1.00  8.94           O  
ATOM   3620  CB  GLN D  23      37.117  53.922  47.015  1.00  8.45           C  
ATOM   3621  CG  GLN D  23      37.388  55.415  47.153  1.00  9.55           C  
ATOM   3622  CD  GLN D  23      37.250  56.146  45.823  1.00 11.13           C  
ATOM   3623  OE1 GLN D  23      37.914  55.804  44.842  1.00 10.23           O  
ATOM   3624  NE2 GLN D  23      36.386  57.156  45.784  1.00 13.51           N  
ATOM   3625  N   ILE D  24      34.275  51.830  45.855  1.00  8.07           N  
ATOM   3626  CA  ILE D  24      33.979  50.578  45.174  1.00  7.41           C  
ATOM   3627  C   ILE D  24      34.019  50.817  43.668  1.00  8.64           C  
ATOM   3628  O   ILE D  24      33.432  51.778  43.165  1.00  9.73           O  
ATOM   3629  CB  ILE D  24      32.583  50.056  45.581  1.00  8.75           C  
ATOM   3630  CG1 ILE D  24      32.545  49.841  47.100  1.00 11.07           C  
ATOM   3631  CG2 ILE D  24      32.277  48.758  44.853  1.00  8.16           C  
ATOM   3632  CD1 ILE D  24      31.175  49.458  47.650  1.00 10.93           C  
ATOM   3633  N   ALA D  25      34.716  49.949  42.944  1.00  8.80           N  
ATOM   3634  CA  ALA D  25      34.808  50.110  41.501  1.00  9.09           C  
ATOM   3635  C   ALA D  25      35.065  48.795  40.778  1.00  9.43           C  
ATOM   3636  O   ALA D  25      35.723  47.901  41.307  1.00  8.66           O  
ATOM   3637  CB  ALA D  25      35.909  51.109  41.161  1.00 12.06           C  
ATOM   3638  N   PRO D  26      34.539  48.665  39.549  1.00  9.83           N  
ATOM   3639  CA  PRO D  26      34.728  47.446  38.759  1.00 11.28           C  
ATOM   3640  C   PRO D  26      36.189  47.259  38.378  1.00 11.88           C  
ATOM   3641  O   PRO D  26      36.896  48.232  38.108  1.00 14.86           O  
ATOM   3642  CB  PRO D  26      33.866  47.688  37.521  1.00 12.46           C  
ATOM   3643  CG  PRO D  26      32.828  48.647  37.991  1.00 13.84           C  
ATOM   3644  CD  PRO D  26      33.609  49.585  38.875  1.00 11.77           C  
ATOM   3645  N   LEU D  27      36.626  46.007  38.355  1.00 13.28           N  
ATOM   3646  CA  LEU D  27      37.992  45.673  37.979  1.00 15.11           C  
ATOM   3647  C   LEU D  27      38.016  45.189  36.538  1.00 15.74           C  
ATOM   3648  O   LEU D  27      38.885  45.579  35.751  1.00 16.13           O  
ATOM   3649  CB  LEU D  27      38.545  44.565  38.880  1.00 16.28           C  
ATOM   3650  CG  LEU D  27      38.947  44.938  40.306  1.00 17.93           C  
ATOM   3651  CD1 LEU D  27      39.463  43.709  41.027  1.00 19.31           C  
ATOM   3652  CD2 LEU D  27      40.017  46.021  40.263  1.00 19.04           C  
ATOM   3653  N   SER D  28      37.052  44.339  36.195  1.00 13.06           N  
ATOM   3654  CA  SER D  28      36.978  43.779  34.853  1.00 14.09           C  
ATOM   3655  C   SER D  28      35.694  42.992  34.616  1.00 14.23           C  
ATOM   3656  O   SER D  28      34.970  42.656  35.552  1.00 11.35           O  
ATOM   3657  CB  SER D  28      38.166  42.849  34.627  1.00 14.99           C  
ATOM   3658  OG  SER D  28      38.179  41.827  35.611  1.00 15.97           O  
ATOM   3659  N   PHE D  29      35.432  42.699  33.348  1.00 13.76           N  
ATOM   3660  CA  PHE D  29      34.265  41.926  32.940  1.00 14.20           C  
ATOM   3661  C   PHE D  29      34.760  41.005  31.836  1.00 14.65           C  
ATOM   3662  O   PHE D  29      34.620  41.305  30.651  1.00 16.15           O  
ATOM   3663  CB  PHE D  29      33.165  42.852  32.417  1.00 15.05           C  
ATOM   3664  CG  PHE D  29      31.917  42.132  31.980  1.00 15.92           C  
ATOM   3665  CD1 PHE D  29      31.365  41.123  32.766  1.00 15.89           C  
ATOM   3666  CD2 PHE D  29      31.280  42.482  30.793  1.00 16.63           C  
ATOM   3667  CE1 PHE D  29      30.194  40.473  32.374  1.00 16.90           C  
ATOM   3668  CE2 PHE D  29      30.110  41.838  30.393  1.00 16.45           C  
ATOM   3669  CZ  PHE D  29      29.566  40.832  31.186  1.00 17.02           C  
ATOM   3670  N   THR D  30      35.357  39.892  32.241  1.00 16.41           N  
ATOM   3671  CA  THR D  30      35.915  38.936  31.299  1.00 17.00           C  
ATOM   3672  C   THR D  30      35.150  37.622  31.262  1.00 17.45           C  
ATOM   3673  O   THR D  30      34.909  36.999  32.295  1.00 16.70           O  
ATOM   3674  CB  THR D  30      37.380  38.625  31.642  1.00 18.84           C  
ATOM   3675  OG1 THR D  30      38.118  39.851  31.721  1.00 20.86           O  
ATOM   3676  CG2 THR D  30      37.998  37.731  30.575  1.00 20.39           C  
ATOM   3677  N   ASP D  31      34.783  37.206  30.056  1.00 16.49           N  
ATOM   3678  CA  ASP D  31      34.062  35.962  29.839  1.00 18.18           C  
ATOM   3679  C   ASP D  31      32.818  35.784  30.710  1.00 18.31           C  
ATOM   3680  O   ASP D  31      32.582  34.709  31.267  1.00 18.03           O  
ATOM   3681  CB  ASP D  31      35.010  34.775  30.024  1.00 21.10           C  
ATOM   3682  CG  ASP D  31      34.394  33.467  29.576  1.00 22.98           C  
ATOM   3683  OD1 ASP D  31      33.672  33.477  28.555  1.00 23.92           O  
ATOM   3684  OD2 ASP D  31      34.639  32.434  30.231  1.00 24.18           O  
ATOM   3685  N   GLY D  32      32.032  36.851  30.823  1.00 17.54           N  
ATOM   3686  CA  GLY D  32      30.803  36.800  31.593  1.00 16.92           C  
ATOM   3687  C   GLY D  32      30.943  36.967  33.092  1.00 16.05           C  
ATOM   3688  O   GLY D  32      29.949  36.958  33.814  1.00 15.54           O  
ATOM   3689  N   GLU D  33      32.168  37.122  33.568  1.00 14.71           N  
ATOM   3690  CA  GLU D  33      32.382  37.284  34.996  1.00 14.09           C  
ATOM   3691  C   GLU D  33      32.789  38.710  35.334  1.00 12.90           C  
ATOM   3692  O   GLU D  33      33.768  39.233  34.800  1.00 11.37           O  
ATOM   3693  CB  GLU D  33      33.457  36.309  35.478  1.00 16.19           C  
ATOM   3694  CG  GLU D  33      33.689  36.345  36.975  1.00 18.68           C  
ATOM   3695  CD  GLU D  33      34.718  35.336  37.422  1.00 20.57           C  
ATOM   3696  OE1 GLU D  33      35.894  35.466  37.023  1.00 21.69           O  
ATOM   3697  OE2 GLU D  33      34.351  34.407  38.170  1.00 21.04           O  
ATOM   3698  N   LEU D  34      32.015  39.342  36.210  1.00 12.37           N  
ATOM   3699  CA  LEU D  34      32.308  40.699  36.644  1.00 11.60           C  
ATOM   3700  C   LEU D  34      33.100  40.620  37.945  1.00 11.09           C  
ATOM   3701  O   LEU D  34      32.712  39.906  38.872  1.00 10.67           O  
ATOM   3702  CB  LEU D  34      31.013  41.487  36.886  1.00 11.49           C  
ATOM   3703  CG  LEU D  34      31.157  42.875  37.533  1.00 11.56           C  
ATOM   3704  CD1 LEU D  34      31.964  43.797  36.622  1.00 11.06           C  
ATOM   3705  CD2 LEU D  34      29.779  43.466  37.799  1.00 13.08           C  
ATOM   3706  N   SER D  35      34.214  41.342  37.996  1.00 10.41           N  
ATOM   3707  CA  SER D  35      35.056  41.385  39.181  1.00 11.10           C  
ATOM   3708  C   SER D  35      35.083  42.833  39.663  1.00 10.24           C  
ATOM   3709  O   SER D  35      35.249  43.758  38.866  1.00  9.63           O  
ATOM   3710  CB  SER D  35      36.471  40.898  38.855  1.00 12.41           C  
ATOM   3711  OG  SER D  35      37.302  40.940  40.006  1.00 16.62           O  
ATOM   3712  N   VAL D  36      34.907  43.020  40.970  1.00  8.19           N  
ATOM   3713  CA  VAL D  36      34.869  44.345  41.581  1.00  8.67           C  
ATOM   3714  C   VAL D  36      35.780  44.384  42.803  1.00  7.24           C  
ATOM   3715  O   VAL D  36      36.048  43.353  43.419  1.00  6.98           O  
ATOM   3716  CB  VAL D  36      33.418  44.678  42.031  1.00  8.37           C  
ATOM   3717  CG1 VAL D  36      33.334  46.078  42.620  1.00  8.53           C  
ATOM   3718  CG2 VAL D  36      32.478  44.538  40.849  1.00  9.10           C  
ATOM   3719  N   SER D  37      36.250  45.573  43.162  1.00  6.43           N  
ATOM   3720  CA  SER D  37      37.112  45.711  44.326  1.00  6.49           C  
ATOM   3721  C   SER D  37      36.930  47.072  44.981  1.00  7.56           C  
ATOM   3722  O   SER D  37      36.109  47.885  44.555  1.00  7.06           O  
ATOM   3723  CB  SER D  37      38.581  45.524  43.926  1.00  7.02           C  
ATOM   3724  OG  SER D  37      39.435  45.573  45.059  1.00  9.14           O  
ATOM   3725  N   ALA D  38      37.702  47.294  46.033  1.00  5.91           N  
ATOM   3726  CA  ALA D  38      37.685  48.546  46.769  1.00  7.59           C  
ATOM   3727  C   ALA D  38      38.883  48.509  47.698  1.00  8.17           C  
ATOM   3728  O   ALA D  38      39.340  47.438  48.099  1.00  6.56           O  
ATOM   3729  CB  ALA D  38      36.397  48.682  47.575  1.00  9.00           C  
ATOM   3730  N   PRO D  39      39.417  49.682  48.041  1.00  8.12           N  
ATOM   3731  CA  PRO D  39      40.571  49.767  48.932  1.00 10.27           C  
ATOM   3732  C   PRO D  39      40.166  49.424  50.357  1.00 10.51           C  
ATOM   3733  O   PRO D  39      39.033  49.672  50.767  1.00 10.15           O  
ATOM   3734  CB  PRO D  39      41.005  51.216  48.781  1.00  9.72           C  
ATOM   3735  CG  PRO D  39      39.696  51.920  48.594  1.00  8.27           C  
ATOM   3736  CD  PRO D  39      38.980  51.020  47.610  1.00  5.64           C  
ATOM   3737  N   LEU D  40      41.101  48.858  51.112  1.00 10.74           N  
ATOM   3738  CA  LEU D  40      40.831  48.478  52.492  1.00 10.85           C  
ATOM   3739  C   LEU D  40      40.662  49.654  53.457  1.00 11.60           C  
ATOM   3740  O   LEU D  40      39.724  49.678  54.249  1.00 11.99           O  
ATOM   3741  CB  LEU D  40      41.952  47.573  53.005  1.00 12.73           C  
ATOM   3742  CG  LEU D  40      41.880  47.204  54.487  1.00 14.65           C  
ATOM   3743  CD1 LEU D  40      40.636  46.362  54.749  1.00 14.47           C  
ATOM   3744  CD2 LEU D  40      43.133  46.433  54.882  1.00 17.72           C  
ATOM   3745  N   ALA D  41      41.572  50.624  53.383  1.00 10.82           N  
ATOM   3746  CA  ALA D  41      41.576  51.781  54.279  1.00 11.65           C  
ATOM   3747  C   ALA D  41      40.241  52.413  54.698  1.00 10.34           C  
ATOM   3748  O   ALA D  41      39.951  52.510  55.892  1.00 12.10           O  
ATOM   3749  CB  ALA D  41      42.506  52.862  53.717  1.00 14.16           C  
ATOM   3750  N   PRO D  42      39.417  52.862  53.738  1.00  9.94           N  
ATOM   3751  CA  PRO D  42      38.139  53.473  54.127  1.00  9.56           C  
ATOM   3752  C   PRO D  42      37.182  52.446  54.728  1.00  9.69           C  
ATOM   3753  O   PRO D  42      36.278  52.781  55.498  1.00  9.38           O  
ATOM   3754  CB  PRO D  42      37.595  54.020  52.806  1.00 10.74           C  
ATOM   3755  CG  PRO D  42      38.816  54.163  51.937  1.00 12.34           C  
ATOM   3756  CD  PRO D  42      39.611  52.937  52.280  1.00  9.47           C  
ATOM   3757  N   ASN D  43      37.408  51.191  54.370  1.00 10.07           N  
ATOM   3758  CA  ASN D  43      36.551  50.093  54.789  1.00  9.67           C  
ATOM   3759  C   ASN D  43      37.047  49.234  55.940  1.00 10.65           C  
ATOM   3760  O   ASN D  43      36.575  48.113  56.125  1.00  7.76           O  
ATOM   3761  CB  ASN D  43      36.283  49.224  53.565  1.00  9.90           C  
ATOM   3762  CG  ASN D  43      35.620  50.003  52.453  1.00  8.39           C  
ATOM   3763  OD1 ASN D  43      34.501  50.484  52.611  1.00  8.05           O  
ATOM   3764  ND2 ASN D  43      36.313  50.154  51.328  1.00  7.98           N  
ATOM   3765  N   ILE D  44      37.980  49.759  56.724  1.00  9.95           N  
ATOM   3766  CA  ILE D  44      38.529  49.002  57.839  1.00 10.78           C  
ATOM   3767  C   ILE D  44      37.650  48.965  59.084  1.00 10.42           C  
ATOM   3768  O   ILE D  44      36.682  49.717  59.214  1.00  9.44           O  
ATOM   3769  CB  ILE D  44      39.912  49.542  58.262  1.00 12.45           C  
ATOM   3770  CG1 ILE D  44      39.799  51.011  58.675  1.00 13.81           C  
ATOM   3771  CG2 ILE D  44      40.899  49.372  57.122  1.00 15.76           C  
ATOM   3772  CD1 ILE D  44      41.054  51.558  59.333  1.00 18.39           C  
ATOM   3773  N   ASN D  45      37.994  48.049  59.983  1.00 10.48           N  
ATOM   3774  CA  ASN D  45      37.305  47.898  61.251  1.00 11.73           C  
ATOM   3775  C   ASN D  45      38.370  47.983  62.344  1.00 12.73           C  
ATOM   3776  O   ASN D  45      39.501  48.391  62.080  1.00 12.56           O  
ATOM   3777  CB  ASN D  45      36.550  46.560  61.310  1.00 12.74           C  
ATOM   3778  CG  ASN D  45      37.451  45.352  61.097  1.00 13.75           C  
ATOM   3779  OD1 ASN D  45      36.973  44.269  60.738  1.00 17.95           O  
ATOM   3780  ND2 ASN D  45      38.746  45.519  61.329  1.00 12.08           N  
ATOM   3781  N   LEU D  46      38.011  47.593  63.559  1.00 15.72           N  
ATOM   3782  CA  LEU D  46      38.929  47.650  64.689  1.00 18.92           C  
ATOM   3783  C   LEU D  46      40.188  46.808  64.476  1.00 20.79           C  
ATOM   3784  O   LEU D  46      41.289  47.220  64.844  1.00 21.14           O  
ATOM   3785  CB  LEU D  46      38.206  47.183  65.954  1.00 23.09           C  
ATOM   3786  CG  LEU D  46      38.642  47.776  67.299  1.00 26.71           C  
ATOM   3787  CD1 LEU D  46      37.644  47.362  68.372  1.00 27.63           C  
ATOM   3788  CD2 LEU D  46      40.041  47.315  67.659  1.00 26.33           C  
ATOM   3789  N   HIS D  47      40.014  45.636  63.869  1.00 20.47           N  
ATOM   3790  CA  HIS D  47      41.109  44.699  63.619  1.00 22.50           C  
ATOM   3791  C   HIS D  47      41.910  45.017  62.361  1.00 22.35           C  
ATOM   3792  O   HIS D  47      42.775  44.235  61.955  1.00 21.98           O  
ATOM   3793  CB  HIS D  47      40.546  43.279  63.503  1.00 23.96           C  
ATOM   3794  CG  HIS D  47      39.512  42.952  64.536  1.00 26.69           C  
ATOM   3795  ND1 HIS D  47      39.788  42.925  65.885  1.00 27.04           N  
ATOM   3796  CD2 HIS D  47      38.198  42.648  64.415  1.00 26.76           C  
ATOM   3797  CE1 HIS D  47      38.689  42.619  66.552  1.00 28.07           C  
ATOM   3798  NE2 HIS D  47      37.709  42.446  65.683  1.00 27.73           N  
ATOM   3799  N   HIS D  48      41.626  46.159  61.747  1.00 21.37           N  
ATOM   3800  CA  HIS D  48      42.313  46.559  60.527  1.00 21.67           C  
ATOM   3801  C   HIS D  48      41.974  45.651  59.350  1.00 19.01           C  
ATOM   3802  O   HIS D  48      42.690  45.635  58.348  1.00 19.28           O  
ATOM   3803  CB  HIS D  48      43.830  46.580  60.737  1.00 24.96           C  
ATOM   3804  CG  HIS D  48      44.363  47.920  61.138  1.00 29.17           C  
ATOM   3805  ND1 HIS D  48      43.944  48.579  62.273  1.00 30.75           N  
ATOM   3806  CD2 HIS D  48      45.269  48.732  60.543  1.00 30.67           C  
ATOM   3807  CE1 HIS D  48      44.568  49.741  62.360  1.00 32.38           C  
ATOM   3808  NE2 HIS D  48      45.378  49.857  61.323  1.00 32.88           N  
ATOM   3809  N   THR D  49      40.897  44.880  59.476  1.00 16.23           N  
ATOM   3810  CA  THR D  49      40.463  44.010  58.388  1.00 12.63           C  
ATOM   3811  C   THR D  49      39.232  44.676  57.780  1.00 10.87           C  
ATOM   3812  O   THR D  49      38.769  45.687  58.297  1.00 12.28           O  
ATOM   3813  CB  THR D  49      40.100  42.588  58.881  1.00 12.82           C  
ATOM   3814  OG1 THR D  49      39.114  42.664  59.916  1.00 13.82           O  
ATOM   3815  CG2 THR D  49      41.339  41.880  59.403  1.00 15.66           C  
HETATM 3816  N   MSE D  50      38.699  44.145  56.688  1.00  8.61           N  
HETATM 3817  CA  MSE D  50      37.545  44.810  56.098  1.00  8.15           C  
HETATM 3818  C   MSE D  50      36.275  44.679  56.924  1.00  8.60           C  
HETATM 3819  O   MSE D  50      35.891  43.588  57.353  1.00  7.30           O  
HETATM 3820  CB  MSE D  50      37.279  44.316  54.673  1.00  7.33           C  
HETATM 3821  CG  MSE D  50      36.254  45.185  53.944  1.00 10.54           C  
HETATM 3822 SE   MSE D  50      36.151  44.909  52.055  1.00 18.31          SE  
HETATM 3823  CE  MSE D  50      37.612  46.071  51.555  1.00 12.26           C  
ATOM   3824  N   PHE D  51      35.626  45.822  57.123  1.00  6.08           N  
ATOM   3825  CA  PHE D  51      34.387  45.928  57.883  1.00  7.02           C  
ATOM   3826  C   PHE D  51      33.273  45.080  57.265  1.00  6.35           C  
ATOM   3827  O   PHE D  51      33.131  45.022  56.041  1.00  5.58           O  
ATOM   3828  CB  PHE D  51      33.983  47.405  57.937  1.00  8.38           C  
ATOM   3829  CG  PHE D  51      32.623  47.655  58.522  1.00  7.08           C  
ATOM   3830  CD1 PHE D  51      32.257  47.090  59.738  1.00  8.94           C  
ATOM   3831  CD2 PHE D  51      31.716  48.477  57.862  1.00 10.09           C  
ATOM   3832  CE1 PHE D  51      31.001  47.338  60.290  1.00  6.92           C  
ATOM   3833  CE2 PHE D  51      30.454  48.736  58.404  1.00  9.67           C  
ATOM   3834  CZ  PHE D  51      30.098  48.162  59.622  1.00  7.43           C  
ATOM   3835  N   ALA D  52      32.486  44.430  58.120  1.00  5.69           N  
ATOM   3836  CA  ALA D  52      31.386  43.569  57.672  1.00  8.24           C  
ATOM   3837  C   ALA D  52      30.381  44.283  56.771  1.00  6.71           C  
ATOM   3838  O   ALA D  52      29.844  43.691  55.827  1.00  6.82           O  
ATOM   3839  CB  ALA D  52      30.665  42.973  58.884  1.00  8.52           C  
ATOM   3840  N   GLY D  53      30.117  45.551  57.069  1.00  4.53           N  
ATOM   3841  CA  GLY D  53      29.182  46.313  56.265  1.00  5.80           C  
ATOM   3842  C   GLY D  53      29.755  46.619  54.899  1.00  5.37           C  
ATOM   3843  O   GLY D  53      29.038  46.618  53.901  1.00  5.99           O  
ATOM   3844  N   SER D  54      31.056  46.893  54.854  1.00  6.02           N  
ATOM   3845  CA  SER D  54      31.709  47.190  53.589  1.00  5.21           C  
ATOM   3846  C   SER D  54      31.707  45.940  52.723  1.00  6.13           C  
ATOM   3847  O   SER D  54      31.426  46.013  51.526  1.00  6.55           O  
ATOM   3848  CB  SER D  54      33.144  47.673  53.829  1.00  5.21           C  
ATOM   3849  OG  SER D  54      33.141  48.961  54.436  1.00  7.59           O  
ATOM   3850  N   ILE D  55      32.011  44.794  53.331  1.00  5.39           N  
ATOM   3851  CA  ILE D  55      32.014  43.531  52.600  1.00  6.32           C  
ATOM   3852  C   ILE D  55      30.640  43.296  51.968  1.00  6.00           C  
ATOM   3853  O   ILE D  55      30.540  42.991  50.780  1.00  5.08           O  
ATOM   3854  CB  ILE D  55      32.369  42.355  53.534  1.00  5.77           C  
ATOM   3855  CG1 ILE D  55      33.855  42.438  53.911  1.00  6.52           C  
ATOM   3856  CG2 ILE D  55      32.035  41.024  52.859  1.00  5.41           C  
ATOM   3857  CD1 ILE D  55      34.305  41.411  54.936  1.00  6.50           C  
ATOM   3858  N   TYR D  56      29.582  43.451  52.761  1.00  4.88           N  
ATOM   3859  CA  TYR D  56      28.233  43.255  52.248  1.00  5.27           C  
ATOM   3860  C   TYR D  56      27.910  44.228  51.120  1.00  4.08           C  
ATOM   3861  O   TYR D  56      27.375  43.844  50.084  1.00  3.81           O  
ATOM   3862  CB  TYR D  56      27.198  43.443  53.356  1.00  4.82           C  
ATOM   3863  CG  TYR D  56      25.768  43.322  52.867  1.00  4.10           C  
ATOM   3864  CD1 TYR D  56      25.130  42.085  52.814  1.00  6.31           C  
ATOM   3865  CD2 TYR D  56      25.064  44.445  52.428  1.00  6.76           C  
ATOM   3866  CE1 TYR D  56      23.827  41.969  52.333  1.00  5.06           C  
ATOM   3867  CE2 TYR D  56      23.757  44.336  51.948  1.00  5.33           C  
ATOM   3868  CZ  TYR D  56      23.149  43.094  51.905  1.00  6.61           C  
ATOM   3869  OH  TYR D  56      21.859  42.967  51.433  1.00  7.69           O  
ATOM   3870  N   THR D  57      28.240  45.496  51.325  1.00  4.09           N  
ATOM   3871  CA  THR D  57      27.939  46.507  50.324  1.00  5.31           C  
ATOM   3872  C   THR D  57      28.650  46.280  48.996  1.00  5.14           C  
ATOM   3873  O   THR D  57      28.045  46.459  47.932  1.00  4.75           O  
ATOM   3874  CB  THR D  57      28.247  47.921  50.866  1.00  6.07           C  
ATOM   3875  OG1 THR D  57      27.417  48.176  52.007  1.00  6.78           O  
ATOM   3876  CG2 THR D  57      27.959  48.973  49.806  1.00  7.76           C  
ATOM   3877  N   ILE D  58      29.918  45.884  49.035  1.00  5.35           N  
ATOM   3878  CA  ILE D  58      30.622  45.645  47.782  1.00  6.18           C  
ATOM   3879  C   ILE D  58      29.992  44.446  47.062  1.00  7.03           C  
ATOM   3880  O   ILE D  58      29.811  44.477  45.850  1.00  5.97           O  
ATOM   3881  CB  ILE D  58      32.150  45.433  48.007  1.00  7.95           C  
ATOM   3882  CG1 ILE D  58      32.867  45.338  46.657  1.00  8.92           C  
ATOM   3883  CG2 ILE D  58      32.404  44.196  48.852  1.00 11.40           C  
ATOM   3884  CD1 ILE D  58      34.373  45.397  46.773  1.00 11.36           C  
HETATM 3885  N   MSE D  59      29.627  43.404  47.806  1.00  6.21           N  
HETATM 3886  CA  MSE D  59      29.012  42.239  47.178  1.00  6.66           C  
HETATM 3887  C   MSE D  59      27.644  42.601  46.595  1.00  6.13           C  
HETATM 3888  O   MSE D  59      27.304  42.181  45.491  1.00  5.30           O  
HETATM 3889  CB  MSE D  59      28.909  41.097  48.187  1.00  6.76           C  
HETATM 3890  CG  MSE D  59      30.287  40.637  48.641  1.00  7.53           C  
HETATM 3891 SE   MSE D  59      30.353  39.250  50.009  1.00 14.35          SE  
HETATM 3892  CE  MSE D  59      30.450  37.701  48.859  1.00 10.88           C  
ATOM   3893  N   THR D  60      26.882  43.406  47.331  1.00  5.67           N  
ATOM   3894  CA  THR D  60      25.574  43.859  46.881  1.00  5.94           C  
ATOM   3895  C   THR D  60      25.700  44.624  45.561  1.00  6.36           C  
ATOM   3896  O   THR D  60      24.939  44.381  44.619  1.00  6.10           O  
ATOM   3897  CB  THR D  60      24.921  44.782  47.935  1.00  8.21           C  
ATOM   3898  OG1 THR D  60      24.578  44.007  49.089  1.00 10.19           O  
ATOM   3899  CG2 THR D  60      23.669  45.448  47.377  1.00 10.14           C  
ATOM   3900  N   LEU D  61      26.655  45.547  45.487  1.00  6.46           N  
ATOM   3901  CA  LEU D  61      26.842  46.318  44.258  1.00  7.68           C  
ATOM   3902  C   LEU D  61      27.401  45.470  43.116  1.00  7.18           C  
ATOM   3903  O   LEU D  61      27.135  45.749  41.944  1.00  7.39           O  
ATOM   3904  CB  LEU D  61      27.739  47.538  44.516  1.00  6.74           C  
ATOM   3905  CG  LEU D  61      27.107  48.654  45.360  1.00  9.41           C  
ATOM   3906  CD1 LEU D  61      28.137  49.749  45.592  1.00  9.65           C  
ATOM   3907  CD2 LEU D  61      25.874  49.223  44.653  1.00  7.87           C  
ATOM   3908  N   THR D  62      28.168  44.434  43.446  1.00  6.99           N  
ATOM   3909  CA  THR D  62      28.717  43.554  42.418  1.00  7.47           C  
ATOM   3910  C   THR D  62      27.564  42.796  41.755  1.00  8.24           C  
ATOM   3911  O   THR D  62      27.548  42.613  40.532  1.00  8.29           O  
ATOM   3912  CB  THR D  62      29.738  42.564  43.023  1.00  6.90           C  
ATOM   3913  OG1 THR D  62      30.861  43.301  43.524  1.00  8.31           O  
ATOM   3914  CG2 THR D  62      30.220  41.573  41.976  1.00  8.44           C  
ATOM   3915  N   GLY D  63      26.596  42.369  42.562  1.00  7.34           N  
ATOM   3916  CA  GLY D  63      25.444  41.672  42.021  1.00  6.33           C  
ATOM   3917  C   GLY D  63      24.621  42.669  41.230  1.00  7.22           C  
ATOM   3918  O   GLY D  63      24.150  42.383  40.130  1.00  7.58           O  
ATOM   3919  N   TRP D  64      24.453  43.856  41.801  1.00  7.18           N  
ATOM   3920  CA  TRP D  64      23.700  44.925  41.159  1.00  8.84           C  
ATOM   3921  C   TRP D  64      24.346  45.214  39.799  1.00  8.67           C  
ATOM   3922  O   TRP D  64      23.659  45.307  38.780  1.00  9.74           O  
ATOM   3923  CB  TRP D  64      23.735  46.177  42.042  1.00 10.56           C  
ATOM   3924  CG  TRP D  64      22.804  47.284  41.628  1.00 12.88           C  
ATOM   3925  CD1 TRP D  64      21.579  47.576  42.163  1.00 14.77           C  
ATOM   3926  CD2 TRP D  64      23.045  48.270  40.617  1.00 13.08           C  
ATOM   3927  NE1 TRP D  64      21.046  48.689  41.550  1.00 15.93           N  
ATOM   3928  CE2 TRP D  64      21.926  49.133  40.598  1.00 13.97           C  
ATOM   3929  CE3 TRP D  64      24.098  48.508  39.726  1.00 10.38           C  
ATOM   3930  CZ2 TRP D  64      21.835  50.219  39.721  1.00 15.64           C  
ATOM   3931  CZ3 TRP D  64      24.008  49.586  38.856  1.00 12.42           C  
ATOM   3932  CH2 TRP D  64      22.883  50.428  38.861  1.00 12.97           C  
ATOM   3933  N   GLY D  65      25.671  45.327  39.792  1.00  9.40           N  
ATOM   3934  CA  GLY D  65      26.391  45.601  38.558  1.00  9.39           C  
ATOM   3935  C   GLY D  65      26.217  44.537  37.488  1.00 11.30           C  
ATOM   3936  O   GLY D  65      26.212  44.844  36.296  1.00  9.90           O  
HETATM 3937  N   MSE D  66      26.078  43.282  37.901  1.00 10.98           N  
HETATM 3938  CA  MSE D  66      25.900  42.194  36.946  1.00 13.24           C  
HETATM 3939  C   MSE D  66      24.539  42.336  36.272  1.00 11.42           C  
HETATM 3940  O   MSE D  66      24.404  42.100  35.074  1.00 12.35           O  
HETATM 3941  CB  MSE D  66      25.996  40.837  37.650  1.00 14.86           C  
HETATM 3942  CG  MSE D  66      25.918  39.633  36.718  1.00 18.92           C  
HETATM 3943 SE   MSE D  66      27.388  39.558  35.452  1.00 28.49          SE  
HETATM 3944  CE  MSE D  66      26.502  40.287  33.908  1.00 26.84           C  
ATOM   3945  N   VAL D  67      23.527  42.718  37.044  1.00 11.36           N  
ATOM   3946  CA  VAL D  67      22.198  42.901  36.479  1.00 12.01           C  
ATOM   3947  C   VAL D  67      22.253  44.067  35.502  1.00 13.10           C  
ATOM   3948  O   VAL D  67      21.633  44.036  34.436  1.00 14.27           O  
ATOM   3949  CB  VAL D  67      21.153  43.221  37.557  1.00 11.90           C  
ATOM   3950  CG1 VAL D  67      19.799  43.462  36.910  1.00 11.05           C  
ATOM   3951  CG2 VAL D  67      21.070  42.065  38.547  1.00 12.35           C  
ATOM   3952  N   TRP D  68      23.012  45.091  35.873  1.00 13.31           N  
ATOM   3953  CA  TRP D  68      23.166  46.275  35.045  1.00 13.94           C  
ATOM   3954  C   TRP D  68      23.837  45.914  33.719  1.00 13.49           C  
ATOM   3955  O   TRP D  68      23.403  46.366  32.659  1.00 14.71           O  
ATOM   3956  CB  TRP D  68      24.001  47.318  35.791  1.00 14.34           C  
ATOM   3957  CG  TRP D  68      24.062  48.652  35.121  1.00 14.26           C  
ATOM   3958  CD1 TRP D  68      23.162  49.673  35.234  1.00 14.51           C  
ATOM   3959  CD2 TRP D  68      25.096  49.123  34.253  1.00 13.86           C  
ATOM   3960  NE1 TRP D  68      23.577  50.756  34.493  1.00 16.70           N  
ATOM   3961  CE2 TRP D  68      24.761  50.443  33.879  1.00 15.27           C  
ATOM   3962  CE3 TRP D  68      26.276  48.556  33.753  1.00 13.22           C  
ATOM   3963  CZ2 TRP D  68      25.566  51.209  33.027  1.00 15.71           C  
ATOM   3964  CZ3 TRP D  68      27.076  49.316  32.907  1.00 15.47           C  
ATOM   3965  CH2 TRP D  68      26.716  50.629  32.553  1.00 15.23           C  
ATOM   3966  N   LEU D  69      24.894  45.104  33.776  1.00 13.37           N  
ATOM   3967  CA  LEU D  69      25.602  44.696  32.562  1.00 13.36           C  
ATOM   3968  C   LEU D  69      24.697  43.860  31.659  1.00 15.38           C  
ATOM   3969  O   LEU D  69      24.679  44.048  30.440  1.00 14.17           O  
ATOM   3970  CB  LEU D  69      26.864  43.892  32.912  1.00 13.54           C  
ATOM   3971  CG  LEU D  69      28.040  44.670  33.513  1.00 13.20           C  
ATOM   3972  CD1 LEU D  69      29.084  43.703  34.075  1.00 14.91           C  
ATOM   3973  CD2 LEU D  69      28.654  45.555  32.442  1.00 14.97           C  
ATOM   3974  N   GLN D  70      23.945  42.942  32.256  1.00 15.48           N  
ATOM   3975  CA  GLN D  70      23.045  42.097  31.481  1.00 17.45           C  
ATOM   3976  C   GLN D  70      21.957  42.917  30.802  1.00 17.41           C  
ATOM   3977  O   GLN D  70      21.520  42.582  29.702  1.00 16.37           O  
ATOM   3978  CB  GLN D  70      22.415  41.027  32.372  1.00 19.57           C  
ATOM   3979  CG  GLN D  70      23.338  39.860  32.660  1.00 25.46           C  
ATOM   3980  CD  GLN D  70      23.735  39.116  31.397  1.00 27.06           C  
ATOM   3981  OE1 GLN D  70      22.881  38.615  30.664  1.00 30.43           O  
ATOM   3982  NE2 GLN D  70      25.034  39.040  31.138  1.00 30.17           N  
ATOM   3983  N   GLN D  71      21.518  43.988  31.456  1.00 16.06           N  
ATOM   3984  CA  GLN D  71      20.489  44.842  30.879  1.00 18.03           C  
ATOM   3985  C   GLN D  71      21.053  45.519  29.636  1.00 18.09           C  
ATOM   3986  O   GLN D  71      20.345  45.714  28.645  1.00 18.27           O  
ATOM   3987  CB  GLN D  71      20.035  45.910  31.879  1.00 18.18           C  
ATOM   3988  CG  GLN D  71      19.298  45.370  33.103  1.00 19.06           C  
ATOM   3989  CD  GLN D  71      18.719  46.484  33.957  1.00 20.53           C  
ATOM   3990  OE1 GLN D  71      19.369  47.503  34.188  1.00 22.88           O  
ATOM   3991  NE2 GLN D  71      17.498  46.289  34.438  1.00 21.69           N  
ATOM   3992  N   GLN D  72      22.331  45.880  29.699  1.00 17.90           N  
ATOM   3993  CA  GLN D  72      22.996  46.527  28.577  1.00 17.70           C  
ATOM   3994  C   GLN D  72      23.139  45.532  27.428  1.00 18.96           C  
ATOM   3995  O   GLN D  72      22.828  45.847  26.279  1.00 19.47           O  
ATOM   3996  CB  GLN D  72      24.378  47.031  29.001  1.00 19.28           C  
ATOM   3997  CG  GLN D  72      24.348  48.082  30.105  1.00 20.89           C  
ATOM   3998  CD  GLN D  72      23.697  49.375  29.656  1.00 23.66           C  
ATOM   3999  OE1 GLN D  72      24.133  49.996  28.684  1.00 25.84           O  
ATOM   4000  NE2 GLN D  72      22.655  49.793  30.363  1.00 25.86           N  
ATOM   4001  N   LEU D  73      23.598  44.326  27.751  1.00 19.03           N  
ATOM   4002  CA  LEU D  73      23.781  43.286  26.746  1.00 19.08           C  
ATOM   4003  C   LEU D  73      22.461  42.857  26.111  1.00 19.85           C  
ATOM   4004  O   LEU D  73      22.432  42.449  24.951  1.00 17.63           O  
ATOM   4005  CB  LEU D  73      24.474  42.070  27.367  1.00 20.12           C  
ATOM   4006  CG  LEU D  73      25.919  42.286  27.829  1.00 20.35           C  
ATOM   4007  CD1 LEU D  73      26.398  41.072  28.610  1.00 21.32           C  
ATOM   4008  CD2 LEU D  73      26.808  42.539  26.624  1.00 20.18           C  
ATOM   4009  N   LEU D  74      21.373  42.948  26.871  1.00 20.26           N  
ATOM   4010  CA  LEU D  74      20.060  42.563  26.361  1.00 21.93           C  
ATOM   4011  C   LEU D  74      19.219  43.765  25.951  1.00 23.34           C  
ATOM   4012  O   LEU D  74      18.068  43.615  25.537  1.00 24.02           O  
ATOM   4013  CB  LEU D  74      19.299  41.740  27.404  1.00 21.87           C  
ATOM   4014  CG  LEU D  74      19.597  40.237  27.452  1.00 22.72           C  
ATOM   4015  CD1 LEU D  74      21.073  39.997  27.728  1.00 24.99           C  
ATOM   4016  CD2 LEU D  74      18.736  39.593  28.526  1.00 23.92           C  
ATOM   4017  N   ASN D  75      19.800  44.954  26.066  1.00 25.13           N  
ATOM   4018  CA  ASN D  75      19.110  46.187  25.707  1.00 26.89           C  
ATOM   4019  C   ASN D  75      17.744  46.284  26.379  1.00 27.85           C  
ATOM   4020  O   ASN D  75      16.724  46.479  25.716  1.00 28.50           O  
ATOM   4021  CB  ASN D  75      18.946  46.278  24.188  1.00 27.42           C  
ATOM   4022  CG  ASN D  75      18.408  47.621  23.742  1.00 29.70           C  
ATOM   4023  OD1 ASN D  75      18.972  48.667  24.070  1.00 31.00           O  
ATOM   4024  ND2 ASN D  75      17.316  47.604  22.985  1.00 30.94           N  
ATOM   4025  N   VAL D  76      17.730  46.139  27.699  1.00 28.15           N  
ATOM   4026  CA  VAL D  76      16.496  46.225  28.470  1.00 28.78           C  
ATOM   4027  C   VAL D  76      16.712  47.162  29.651  1.00 28.50           C  
ATOM   4028  O   VAL D  76      17.686  47.026  30.389  1.00 29.00           O  
ATOM   4029  CB  VAL D  76      16.063  44.836  28.993  1.00 29.75           C  
ATOM   4030  CG1 VAL D  76      15.605  43.966  27.835  1.00 30.89           C  
ATOM   4031  CG2 VAL D  76      17.218  44.168  29.720  1.00 31.02           C  
ATOM   4032  N   ASP D  77      15.807  48.119  29.826  1.00 28.51           N  
ATOM   4033  CA  ASP D  77      15.930  49.072  30.922  1.00 29.18           C  
ATOM   4034  C   ASP D  77      15.127  48.607  32.130  1.00 28.69           C  
ATOM   4035  O   ASP D  77      14.385  47.624  32.056  1.00 29.69           O  
ATOM   4036  CB  ASP D  77      15.434  50.449  30.482  1.00 30.29           C  
ATOM   4037  CG  ASP D  77      13.925  50.559  30.517  1.00 33.10           C  
ATOM   4038  OD1 ASP D  77      13.364  50.718  31.626  1.00 34.74           O  
ATOM   4039  OD2 ASP D  77      13.294  50.474  29.442  1.00 34.87           O  
ATOM   4040  N   GLY D  78      15.273  49.325  33.238  1.00 27.78           N  
ATOM   4041  CA  GLY D  78      14.551  48.977  34.447  1.00 26.13           C  
ATOM   4042  C   GLY D  78      15.354  49.257  35.700  1.00 24.66           C  
ATOM   4043  O   GLY D  78      16.584  49.256  35.670  1.00 25.45           O  
ATOM   4044  N   ASP D  79      14.660  49.507  36.806  1.00 24.29           N  
ATOM   4045  CA  ASP D  79      15.321  49.778  38.075  1.00 22.99           C  
ATOM   4046  C   ASP D  79      15.670  48.469  38.767  1.00 22.39           C  
ATOM   4047  O   ASP D  79      14.825  47.588  38.917  1.00 24.48           O  
ATOM   4048  CB  ASP D  79      14.422  50.623  38.980  1.00 24.42           C  
ATOM   4049  CG  ASP D  79      14.160  52.000  38.410  1.00 26.07           C  
ATOM   4050  OD1 ASP D  79      15.138  52.719  38.118  1.00 27.43           O  
ATOM   4051  OD2 ASP D  79      12.977  52.366  38.256  1.00 28.96           O  
ATOM   4052  N   ILE D  80      16.923  48.355  39.190  1.00 19.86           N  
ATOM   4053  CA  ILE D  80      17.408  47.156  39.858  1.00 17.99           C  
ATOM   4054  C   ILE D  80      17.168  47.258  41.358  1.00 16.86           C  
ATOM   4055  O   ILE D  80      17.572  48.231  41.992  1.00 17.64           O  
ATOM   4056  CB  ILE D  80      18.916  46.976  39.619  1.00 17.99           C  
ATOM   4057  CG1 ILE D  80      19.220  47.072  38.122  1.00 17.83           C  
ATOM   4058  CG2 ILE D  80      19.369  45.626  40.158  1.00 16.79           C  
ATOM   4059  CD1 ILE D  80      20.699  47.182  37.808  1.00 18.83           C  
ATOM   4060  N   VAL D  81      16.514  46.256  41.931  1.00 14.76           N  
ATOM   4061  CA  VAL D  81      16.248  46.277  43.361  1.00 14.99           C  
ATOM   4062  C   VAL D  81      16.624  44.956  44.016  1.00 12.59           C  
ATOM   4063  O   VAL D  81      16.421  43.889  43.444  1.00 14.25           O  
ATOM   4064  CB  VAL D  81      14.757  46.582  43.640  1.00 16.59           C  
ATOM   4065  CG1 VAL D  81      14.496  46.602  45.140  1.00 18.09           C  
ATOM   4066  CG2 VAL D  81      14.379  47.920  43.026  1.00 18.47           C  
ATOM   4067  N   LEU D  82      17.195  45.033  45.213  1.00 12.01           N  
ATOM   4068  CA  LEU D  82      17.575  43.830  45.940  1.00 11.00           C  
ATOM   4069  C   LEU D  82      16.420  43.495  46.878  1.00 11.01           C  
ATOM   4070  O   LEU D  82      16.041  44.309  47.721  1.00 12.98           O  
ATOM   4071  CB  LEU D  82      18.861  44.070  46.736  1.00 10.25           C  
ATOM   4072  CG  LEU D  82      19.374  42.904  47.585  1.00 10.58           C  
ATOM   4073  CD1 LEU D  82      19.636  41.681  46.711  1.00  9.12           C  
ATOM   4074  CD2 LEU D  82      20.650  43.331  48.291  1.00  8.82           C  
ATOM   4075  N   ALA D  83      15.854  42.302  46.715  1.00 10.88           N  
ATOM   4076  CA  ALA D  83      14.722  41.863  47.534  1.00  9.74           C  
ATOM   4077  C   ALA D  83      15.162  41.251  48.856  1.00 10.97           C  
ATOM   4078  O   ALA D  83      14.587  41.531  49.907  1.00 10.42           O  
ATOM   4079  CB  ALA D  83      13.883  40.856  46.761  1.00 10.80           C  
ATOM   4080  N   ASP D  84      16.166  40.390  48.798  1.00  9.79           N  
ATOM   4081  CA  ASP D  84      16.663  39.768  50.010  1.00 11.35           C  
ATOM   4082  C   ASP D  84      18.036  39.210  49.736  1.00  9.17           C  
ATOM   4083  O   ASP D  84      18.414  38.984  48.586  1.00  9.60           O  
ATOM   4084  CB  ASP D  84      15.733  38.646  50.479  1.00 18.19           C  
ATOM   4085  CG  ASP D  84      15.821  37.416  49.611  1.00 22.41           C  
ATOM   4086  OD1 ASP D  84      15.270  37.426  48.491  1.00 27.99           O  
ATOM   4087  OD2 ASP D  84      16.453  36.432  50.051  1.00 27.80           O  
ATOM   4088  N   ALA D  85      18.787  38.985  50.801  1.00  8.05           N  
ATOM   4089  CA  ALA D  85      20.126  38.470  50.636  1.00  7.32           C  
ATOM   4090  C   ALA D  85      20.560  37.656  51.834  1.00  7.18           C  
ATOM   4091  O   ALA D  85      20.054  37.832  52.945  1.00  6.89           O  
ATOM   4092  CB  ALA D  85      21.090  39.630  50.412  1.00  6.17           C  
ATOM   4093  N   HIS D  86      21.493  36.747  51.584  1.00  8.68           N  
ATOM   4094  CA  HIS D  86      22.066  35.893  52.614  1.00  9.60           C  
ATOM   4095  C   HIS D  86      23.571  36.054  52.457  1.00  7.81           C  
ATOM   4096  O   HIS D  86      24.088  35.967  51.345  1.00  9.02           O  
ATOM   4097  CB  HIS D  86      21.693  34.426  52.379  1.00 13.46           C  
ATOM   4098  CG  HIS D  86      22.346  33.472  53.332  1.00 18.50           C  
ATOM   4099  ND1 HIS D  86      22.508  32.132  53.050  1.00 21.83           N  
ATOM   4100  CD2 HIS D  86      22.868  33.663  54.567  1.00 20.29           C  
ATOM   4101  CE1 HIS D  86      23.103  31.539  54.071  1.00 23.16           C  
ATOM   4102  NE2 HIS D  86      23.332  32.446  55.005  1.00 23.86           N  
ATOM   4103  N   ILE D  87      24.273  36.304  53.556  1.00  5.89           N  
ATOM   4104  CA  ILE D  87      25.720  36.458  53.483  1.00  6.67           C  
ATOM   4105  C   ILE D  87      26.411  35.640  54.568  1.00  8.48           C  
ATOM   4106  O   ILE D  87      25.941  35.566  55.706  1.00  6.74           O  
ATOM   4107  CB  ILE D  87      26.147  37.963  53.578  1.00  6.83           C  
ATOM   4108  CG1 ILE D  87      27.668  38.094  53.431  1.00  7.31           C  
ATOM   4109  CG2 ILE D  87      25.691  38.564  54.904  1.00  7.19           C  
ATOM   4110  CD1 ILE D  87      28.158  39.532  53.286  1.00  5.92           C  
ATOM   4111  N   ARG D  88      27.506  34.991  54.187  1.00  7.34           N  
ATOM   4112  CA  ARG D  88      28.292  34.188  55.119  1.00  8.32           C  
ATOM   4113  C   ARG D  88      29.716  34.711  55.142  1.00  8.10           C  
ATOM   4114  O   ARG D  88      30.355  34.828  54.102  1.00  8.84           O  
ATOM   4115  CB  ARG D  88      28.310  32.713  54.694  1.00 11.72           C  
ATOM   4116  CG  ARG D  88      26.985  32.000  54.849  1.00 15.88           C  
ATOM   4117  CD  ARG D  88      27.205  30.505  55.009  1.00 21.30           C  
ATOM   4118  NE  ARG D  88      28.094  30.220  56.133  1.00 25.06           N  
ATOM   4119  CZ  ARG D  88      28.552  29.010  56.433  1.00 27.96           C  
ATOM   4120  NH1 ARG D  88      29.358  28.841  57.475  1.00 29.26           N  
ATOM   4121  NH2 ARG D  88      28.211  27.967  55.689  1.00 27.30           N  
ATOM   4122  N   TYR D  89      30.210  35.037  56.329  1.00  7.31           N  
ATOM   4123  CA  TYR D  89      31.571  35.529  56.460  1.00  9.33           C  
ATOM   4124  C   TYR D  89      32.432  34.343  56.877  1.00 10.50           C  
ATOM   4125  O   TYR D  89      32.295  33.815  57.982  1.00 10.46           O  
ATOM   4126  CB  TYR D  89      31.637  36.647  57.494  1.00  9.09           C  
ATOM   4127  CG  TYR D  89      30.799  37.861  57.153  1.00  7.07           C  
ATOM   4128  CD1 TYR D  89      29.452  37.934  57.517  1.00  5.49           C  
ATOM   4129  CD2 TYR D  89      31.364  38.957  56.500  1.00  6.79           C  
ATOM   4130  CE1 TYR D  89      28.693  39.071  57.247  1.00  7.83           C  
ATOM   4131  CE2 TYR D  89      30.612  40.100  56.223  1.00  6.09           C  
ATOM   4132  CZ  TYR D  89      29.283  40.149  56.602  1.00  7.88           C  
ATOM   4133  OH  TYR D  89      28.547  41.287  56.357  1.00  7.35           O  
ATOM   4134  N   LEU D  90      33.315  33.933  55.972  1.00 11.50           N  
ATOM   4135  CA  LEU D  90      34.174  32.776  56.184  1.00 11.84           C  
ATOM   4136  C   LEU D  90      35.545  33.065  56.794  1.00 12.80           C  
ATOM   4137  O   LEU D  90      36.063  32.260  57.572  1.00 12.96           O  
ATOM   4138  CB  LEU D  90      34.357  32.042  54.852  1.00 12.53           C  
ATOM   4139  CG  LEU D  90      33.065  31.655  54.128  1.00 14.80           C  
ATOM   4140  CD1 LEU D  90      33.394  31.090  52.756  1.00 13.50           C  
ATOM   4141  CD2 LEU D  90      32.289  30.642  54.960  1.00 14.56           C  
ATOM   4142  N   ALA D  91      36.137  34.198  56.431  1.00 11.25           N  
ATOM   4143  CA  ALA D  91      37.448  34.565  56.949  1.00 12.46           C  
ATOM   4144  C   ALA D  91      37.659  36.070  56.876  1.00 12.68           C  
ATOM   4145  O   ALA D  91      36.999  36.764  56.110  1.00 10.54           O  
ATOM   4146  CB  ALA D  91      38.541  33.852  56.161  1.00 13.10           C  
ATOM   4147  N   PRO D  92      38.576  36.597  57.696  1.00 12.70           N  
ATOM   4148  CA  PRO D  92      38.847  38.036  57.687  1.00 13.15           C  
ATOM   4149  C   PRO D  92      39.465  38.484  56.358  1.00 13.65           C  
ATOM   4150  O   PRO D  92      40.243  37.752  55.741  1.00 13.34           O  
ATOM   4151  CB  PRO D  92      39.807  38.210  58.863  1.00 15.11           C  
ATOM   4152  CG  PRO D  92      39.385  37.106  59.806  1.00 16.66           C  
ATOM   4153  CD  PRO D  92      39.208  35.950  58.859  1.00 14.71           C  
ATOM   4154  N   VAL D  93      39.100  39.685  55.922  1.00 12.39           N  
ATOM   4155  CA  VAL D  93      39.615  40.259  54.682  1.00 12.10           C  
ATOM   4156  C   VAL D  93      40.750  41.202  55.083  1.00 12.71           C  
ATOM   4157  O   VAL D  93      40.518  42.244  55.690  1.00 12.09           O  
ATOM   4158  CB  VAL D  93      38.499  41.035  53.940  1.00 10.70           C  
ATOM   4159  CG1 VAL D  93      39.034  41.642  52.654  1.00 10.27           C  
ATOM   4160  CG2 VAL D  93      37.342  40.090  53.638  1.00 10.02           C  
ATOM   4161  N   THR D  94      41.979  40.825  54.740  1.00 14.50           N  
ATOM   4162  CA  THR D  94      43.155  41.604  55.116  1.00 15.26           C  
ATOM   4163  C   THR D  94      43.719  42.558  54.069  1.00 15.13           C  
ATOM   4164  O   THR D  94      44.684  43.272  54.342  1.00 16.30           O  
ATOM   4165  CB  THR D  94      44.284  40.663  55.563  1.00 16.17           C  
ATOM   4166  OG1 THR D  94      44.561  39.727  54.515  1.00 17.13           O  
ATOM   4167  CG2 THR D  94      43.876  39.902  56.819  1.00 17.77           C  
ATOM   4168  N   SER D  95      43.130  42.574  52.879  1.00 15.38           N  
ATOM   4169  CA  SER D  95      43.599  43.457  51.817  1.00 14.54           C  
ATOM   4170  C   SER D  95      42.535  43.632  50.739  1.00 13.01           C  
ATOM   4171  O   SER D  95      41.486  42.987  50.786  1.00 11.91           O  
ATOM   4172  CB  SER D  95      44.887  42.900  51.198  1.00 15.45           C  
ATOM   4173  OG  SER D  95      44.677  41.624  50.620  1.00 18.23           O  
ATOM   4174  N   ALA D  96      42.803  44.510  49.775  1.00 12.59           N  
ATOM   4175  CA  ALA D  96      41.859  44.760  48.683  1.00 13.27           C  
ATOM   4176  C   ALA D  96      41.388  43.422  48.117  1.00 13.10           C  
ATOM   4177  O   ALA D  96      42.187  42.628  47.620  1.00 12.49           O  
ATOM   4178  CB  ALA D  96      42.520  45.596  47.595  1.00 13.09           C  
ATOM   4179  N   PRO D  97      40.076  43.159  48.189  1.00 11.81           N  
ATOM   4180  CA  PRO D  97      39.499  41.906  47.693  1.00  9.94           C  
ATOM   4181  C   PRO D  97      39.123  41.874  46.214  1.00  9.30           C  
ATOM   4182  O   PRO D  97      39.178  42.885  45.512  1.00  9.61           O  
ATOM   4183  CB  PRO D  97      38.273  41.739  48.580  1.00 10.91           C  
ATOM   4184  CG  PRO D  97      37.791  43.155  48.702  1.00 11.67           C  
ATOM   4185  CD  PRO D  97      39.076  43.936  48.946  1.00 11.19           C  
ATOM   4186  N   GLU D  98      38.766  40.684  45.747  1.00  8.15           N  
ATOM   4187  CA  GLU D  98      38.309  40.488  44.378  1.00  9.59           C  
ATOM   4188  C   GLU D  98      36.925  39.884  44.548  1.00  9.89           C  
ATOM   4189  O   GLU D  98      36.785  38.758  45.021  1.00 11.02           O  
ATOM   4190  CB  GLU D  98      39.220  39.519  43.621  1.00 14.53           C  
ATOM   4191  CG  GLU D  98      40.594  40.087  43.328  1.00 19.58           C  
ATOM   4192  CD  GLU D  98      41.465  39.120  42.560  1.00 24.57           C  
ATOM   4193  OE1 GLU D  98      41.892  38.101  43.148  1.00 26.48           O  
ATOM   4194  OE2 GLU D  98      41.718  39.375  41.363  1.00 27.19           O  
ATOM   4195  N   VAL D  99      35.904  40.654  44.192  1.00  8.98           N  
ATOM   4196  CA  VAL D  99      34.527  40.202  44.324  1.00  8.58           C  
ATOM   4197  C   VAL D  99      34.012  39.828  42.949  1.00 10.39           C  
ATOM   4198  O   VAL D  99      33.913  40.680  42.060  1.00  9.27           O  
ATOM   4199  CB  VAL D  99      33.653  41.303  44.933  1.00  9.46           C  
ATOM   4200  CG1 VAL D  99      32.290  40.744  45.282  1.00  7.64           C  
ATOM   4201  CG2 VAL D  99      34.338  41.864  46.174  1.00  9.37           C  
ATOM   4202  N   LYS D 100      33.675  38.553  42.785  1.00  9.18           N  
ATOM   4203  CA  LYS D 100      33.227  38.044  41.493  1.00  9.35           C  
ATOM   4204  C   LYS D 100      31.793  37.532  41.422  1.00 10.52           C  
ATOM   4205  O   LYS D 100      31.229  37.065  42.414  1.00 11.07           O  
ATOM   4206  CB  LYS D 100      34.168  36.925  41.055  1.00  9.74           C  
ATOM   4207  CG  LYS D 100      35.636  37.301  41.126  1.00 13.05           C  
ATOM   4208  CD  LYS D 100      36.517  36.115  40.780  1.00 15.92           C  
ATOM   4209  CE  LYS D 100      37.992  36.462  40.900  1.00 18.90           C  
ATOM   4210  NZ  LYS D 100      38.378  37.567  39.980  1.00 23.80           N  
ATOM   4211  N   VAL D 101      31.219  37.613  40.226  1.00  9.31           N  
ATOM   4212  CA  VAL D 101      29.860  37.139  39.985  1.00 11.02           C  
ATOM   4213  C   VAL D 101      29.644  36.805  38.504  1.00 12.92           C  
ATOM   4214  O   VAL D 101      30.229  37.430  37.617  1.00 12.99           O  
ATOM   4215  CB  VAL D 101      28.805  38.187  40.441  1.00  8.29           C  
ATOM   4216  CG1 VAL D 101      28.904  39.452  39.596  1.00  7.77           C  
ATOM   4217  CG2 VAL D 101      27.406  37.587  40.365  1.00  9.54           C  
ATOM   4218  N   ARG D 102      28.816  35.796  38.258  1.00 13.90           N  
ATOM   4219  CA  ARG D 102      28.478  35.351  36.909  1.00 17.32           C  
ATOM   4220  C   ARG D 102      26.961  35.284  36.817  1.00 18.73           C  
ATOM   4221  O   ARG D 102      26.281  35.124  37.831  1.00 17.55           O  
ATOM   4222  CB  ARG D 102      29.051  33.955  36.634  1.00 17.67           C  
ATOM   4223  CG  ARG D 102      30.533  33.907  36.295  1.00 20.61           C  
ATOM   4224  CD  ARG D 102      30.987  32.458  36.093  1.00 21.01           C  
ATOM   4225  NE  ARG D 102      32.344  32.362  35.563  1.00 22.56           N  
ATOM   4226  CZ  ARG D 102      32.688  32.706  34.327  1.00 23.66           C  
ATOM   4227  NH1 ARG D 102      31.776  33.171  33.484  1.00 24.75           N  
ATOM   4228  NH2 ARG D 102      33.948  32.580  33.932  1.00 26.00           N  
ATOM   4229  N   TRP D 103      26.424  35.404  35.608  1.00 19.63           N  
ATOM   4230  CA  TRP D 103      24.983  35.333  35.435  1.00 21.45           C  
ATOM   4231  C   TRP D 103      24.576  33.867  35.318  1.00 22.42           C  
ATOM   4232  O   TRP D 103      25.201  33.102  34.583  1.00 23.96           O  
ATOM   4233  CB  TRP D 103      24.561  36.102  34.180  1.00 21.69           C  
ATOM   4234  CG  TRP D 103      23.078  36.213  34.025  1.00 22.52           C  
ATOM   4235  CD1 TRP D 103      22.259  35.385  33.312  1.00 24.52           C  
ATOM   4236  CD2 TRP D 103      22.230  37.198  34.624  1.00 23.83           C  
ATOM   4237  NE1 TRP D 103      20.951  35.794  33.429  1.00 25.53           N  
ATOM   4238  CE2 TRP D 103      20.906  36.906  34.229  1.00 24.59           C  
ATOM   4239  CE3 TRP D 103      22.461  38.301  35.457  1.00 23.03           C  
ATOM   4240  CZ2 TRP D 103      19.815  37.676  34.639  1.00 25.73           C  
ATOM   4241  CZ3 TRP D 103      21.374  39.069  35.865  1.00 23.89           C  
ATOM   4242  CH2 TRP D 103      20.068  38.752  35.455  1.00 24.24           C  
ATOM   4243  N   PRO D 104      23.533  33.455  36.057  1.00 22.69           N  
ATOM   4244  CA  PRO D 104      23.049  32.071  36.027  1.00 23.88           C  
ATOM   4245  C   PRO D 104      22.378  31.726  34.699  1.00 24.76           C  
ATOM   4246  O   PRO D 104      21.911  30.601  34.500  1.00 28.22           O  
ATOM   4247  CB  PRO D 104      22.076  32.026  37.199  1.00 22.84           C  
ATOM   4248  CG  PRO D 104      21.512  33.412  37.203  1.00 23.30           C  
ATOM   4249  CD  PRO D 104      22.752  34.257  37.015  1.00 22.01           C  
ATOM   4250  N   GLN D 112      14.418  39.534  29.314  1.00 29.80           N  
ATOM   4251  CA  GLN D 112      14.044  40.607  30.227  1.00 29.29           C  
ATOM   4252  C   GLN D 112      12.882  41.409  29.647  1.00 30.01           C  
ATOM   4253  O   GLN D 112      11.768  41.373  30.174  1.00 31.19           O  
ATOM   4254  CB  GLN D 112      15.236  41.538  30.463  1.00 29.93           C  
ATOM   4255  CG  GLN D 112      16.529  40.834  30.864  1.00 29.75           C  
ATOM   4256  CD  GLN D 112      16.451  40.175  32.225  1.00 29.85           C  
ATOM   4257  OE1 GLN D 112      15.584  39.335  32.474  1.00 31.65           O  
ATOM   4258  NE2 GLN D 112      17.366  40.548  33.115  1.00 30.29           N  
ATOM   4259  N   ARG D 113      13.146  42.132  28.561  1.00 30.50           N  
ATOM   4260  CA  ARG D 113      12.122  42.942  27.910  1.00 29.93           C  
ATOM   4261  C   ARG D 113      11.481  43.924  28.883  1.00 31.12           C  
ATOM   4262  O   ARG D 113      11.999  44.152  29.978  1.00 33.22           O  
ATOM   4263  CB  ARG D 113      11.044  42.032  27.310  1.00 29.83           C  
ATOM   4264  CG  ARG D 113      11.244  41.667  25.840  1.00 28.62           C  
ATOM   4265  CD  ARG D 113      12.710  41.442  25.487  1.00 28.64           C  
ATOM   4266  NE  ARG D 113      13.374  42.701  25.165  1.00 30.65           N  
ATOM   4267  CZ  ARG D 113      14.659  42.817  24.844  1.00 30.83           C  
ATOM   4268  NH1 ARG D 113      15.441  41.744  24.803  1.00 32.46           N  
ATOM   4269  NH2 ARG D 113      15.161  44.011  24.554  1.00 30.21           N  
ATOM   4270  N   GLY D 114      10.355  44.502  28.476  1.00 30.94           N  
ATOM   4271  CA  GLY D 114       9.656  45.446  29.329  1.00 30.33           C  
ATOM   4272  C   GLY D 114       8.747  44.721  30.303  1.00 30.53           C  
ATOM   4273  O   GLY D 114       7.608  45.130  30.532  1.00 31.77           O  
ATOM   4274  N   ARG D 115       9.266  43.640  30.878  1.00 30.15           N  
ATOM   4275  CA  ARG D 115       8.528  42.817  31.832  1.00 29.12           C  
ATOM   4276  C   ARG D 115       9.366  42.671  33.103  1.00 28.19           C  
ATOM   4277  O   ARG D 115      10.588  42.569  33.032  1.00 27.33           O  
ATOM   4278  CB  ARG D 115       8.278  41.434  31.227  1.00 29.89           C  
ATOM   4279  CG  ARG D 115       7.345  40.536  32.028  1.00 30.86           C  
ATOM   4280  CD  ARG D 115       7.523  39.076  31.620  1.00 32.19           C  
ATOM   4281  NE  ARG D 115       7.531  38.908  30.168  1.00 34.60           N  
ATOM   4282  CZ  ARG D 115       7.904  37.793  29.545  1.00 33.81           C  
ATOM   4283  NH1 ARG D 115       8.302  36.739  30.245  1.00 34.28           N  
ATOM   4284  NH2 ARG D 115       7.891  37.738  28.221  1.00 32.76           N  
ATOM   4285  N   LYS D 116       8.713  42.656  34.262  1.00 26.58           N  
ATOM   4286  CA  LYS D 116       9.436  42.517  35.522  1.00 26.21           C  
ATOM   4287  C   LYS D 116      10.142  41.163  35.567  1.00 25.40           C  
ATOM   4288  O   LYS D 116       9.542  40.133  35.263  1.00 26.44           O  
ATOM   4289  CB  LYS D 116       8.477  42.639  36.710  1.00 25.94           C  
ATOM   4290  CG  LYS D 116       9.186  42.799  38.048  1.00 26.95           C  
ATOM   4291  CD  LYS D 116       8.214  42.868  39.218  1.00 26.62           C  
ATOM   4292  CE  LYS D 116       7.558  41.523  39.486  1.00 27.14           C  
ATOM   4293  NZ  LYS D 116       6.747  41.562  40.735  1.00 27.83           N  
ATOM   4294  N   ALA D 117      11.418  41.164  35.940  1.00 24.48           N  
ATOM   4295  CA  ALA D 117      12.176  39.921  36.012  1.00 22.84           C  
ATOM   4296  C   ALA D 117      12.925  39.795  37.333  1.00 22.81           C  
ATOM   4297  O   ALA D 117      13.212  40.792  37.994  1.00 23.19           O  
ATOM   4298  CB  ALA D 117      13.153  39.836  34.849  1.00 24.31           C  
ATOM   4299  N   LYS D 118      13.234  38.559  37.709  1.00 21.05           N  
ATOM   4300  CA  LYS D 118      13.954  38.288  38.947  1.00 20.66           C  
ATOM   4301  C   LYS D 118      15.132  37.366  38.662  1.00 19.49           C  
ATOM   4302  O   LYS D 118      15.098  36.570  37.726  1.00 19.43           O  
ATOM   4303  CB  LYS D 118      13.011  37.649  39.977  1.00 23.04           C  
ATOM   4304  CG  LYS D 118      12.332  36.368  39.507  1.00 25.94           C  
ATOM   4305  CD  LYS D 118      11.077  36.049  40.327  1.00 27.70           C  
ATOM   4306  CE  LYS D 118      11.397  35.625  41.757  1.00 29.49           C  
ATOM   4307  NZ  LYS D 118      12.028  34.273  41.833  1.00 29.49           N  
ATOM   4308  N   VAL D 119      16.187  37.486  39.461  1.00 16.51           N  
ATOM   4309  CA  VAL D 119      17.357  36.642  39.276  1.00 14.69           C  
ATOM   4310  C   VAL D 119      18.102  36.433  40.582  1.00 13.90           C  
ATOM   4311  O   VAL D 119      18.312  37.374  41.348  1.00 13.65           O  
ATOM   4312  CB  VAL D 119      18.337  37.239  38.238  1.00 15.11           C  
ATOM   4313  CG1 VAL D 119      18.847  38.588  38.715  1.00 14.18           C  
ATOM   4314  CG2 VAL D 119      19.493  36.279  38.009  1.00 15.97           C  
ATOM   4315  N   LYS D 120      18.483  35.187  40.831  1.00 13.77           N  
ATOM   4316  CA  LYS D 120      19.222  34.827  42.030  1.00 12.93           C  
ATOM   4317  C   LYS D 120      20.695  34.837  41.664  1.00 11.64           C  
ATOM   4318  O   LYS D 120      21.138  34.061  40.809  1.00 11.76           O  
ATOM   4319  CB  LYS D 120      18.817  33.432  42.511  1.00 16.07           C  
ATOM   4320  CG  LYS D 120      17.361  33.312  42.929  1.00 19.64           C  
ATOM   4321  CD  LYS D 120      17.012  31.878  43.306  1.00 22.89           C  
ATOM   4322  CE  LYS D 120      15.563  31.763  43.750  1.00 25.28           C  
ATOM   4323  NZ  LYS D 120      14.617  32.195  42.683  1.00 26.52           N  
ATOM   4324  N   LEU D 121      21.454  35.718  42.306  1.00 10.37           N  
ATOM   4325  CA  LEU D 121      22.875  35.826  42.028  1.00  9.51           C  
ATOM   4326  C   LEU D 121      23.751  35.352  43.183  1.00 10.78           C  
ATOM   4327  O   LEU D 121      23.464  35.602  44.355  1.00 10.73           O  
ATOM   4328  CB  LEU D 121      23.236  37.274  41.668  1.00 10.06           C  
ATOM   4329  CG  LEU D 121      22.664  37.849  40.367  1.00 12.89           C  
ATOM   4330  CD1 LEU D 121      23.161  39.284  40.181  1.00 10.88           C  
ATOM   4331  CD2 LEU D 121      23.105  36.991  39.189  1.00 12.03           C  
ATOM   4332  N   GLU D 122      24.816  34.645  42.828  1.00 10.33           N  
ATOM   4333  CA  GLU D 122      25.771  34.144  43.799  1.00 11.63           C  
ATOM   4334  C   GLU D 122      27.036  34.966  43.623  1.00 12.17           C  
ATOM   4335  O   GLU D 122      27.651  34.961  42.553  1.00 13.62           O  
ATOM   4336  CB  GLU D 122      26.053  32.662  43.551  1.00 16.65           C  
ATOM   4337  CG  GLU D 122      24.825  31.786  43.712  1.00 22.36           C  
ATOM   4338  CD  GLU D 122      25.130  30.315  43.527  1.00 26.33           C  
ATOM   4339  OE1 GLU D 122      25.610  29.939  42.436  1.00 28.71           O  
ATOM   4340  OE2 GLU D 122      24.886  29.536  44.474  1.00 28.44           O  
ATOM   4341  N   VAL D 123      27.404  35.693  44.670  1.00  7.60           N  
ATOM   4342  CA  VAL D 123      28.588  36.539  44.640  1.00  8.15           C  
ATOM   4343  C   VAL D 123      29.627  35.991  45.612  1.00  8.29           C  
ATOM   4344  O   VAL D 123      29.291  35.573  46.720  1.00  8.26           O  
ATOM   4345  CB  VAL D 123      28.230  37.994  45.043  1.00  7.27           C  
ATOM   4346  CG1 VAL D 123      29.453  38.882  44.932  1.00  8.75           C  
ATOM   4347  CG2 VAL D 123      27.110  38.525  44.145  1.00  8.25           C  
ATOM   4348  N   GLN D 124      30.887  35.984  45.193  1.00  7.95           N  
ATOM   4349  CA  GLN D 124      31.959  35.493  46.047  1.00  9.92           C  
ATOM   4350  C   GLN D 124      33.039  36.543  46.236  1.00  8.49           C  
ATOM   4351  O   GLN D 124      33.367  37.286  45.310  1.00  8.87           O  
ATOM   4352  CB  GLN D 124      32.581  34.229  45.453  1.00 10.90           C  
ATOM   4353  CG  GLN D 124      31.616  33.062  45.350  1.00 16.16           C  
ATOM   4354  CD  GLN D 124      32.304  31.798  44.890  1.00 21.89           C  
ATOM   4355  OE1 GLN D 124      32.897  31.759  43.812  1.00 25.75           O  
ATOM   4356  NE2 GLN D 124      32.230  30.753  45.706  1.00 22.70           N  
ATOM   4357  N   LEU D 125      33.584  36.603  47.449  1.00  7.12           N  
ATOM   4358  CA  LEU D 125      34.637  37.553  47.772  1.00  6.92           C  
ATOM   4359  C   LEU D 125      35.927  36.820  48.125  1.00  8.95           C  
ATOM   4360  O   LEU D 125      35.948  35.970  49.019  1.00  8.59           O  
ATOM   4361  CB  LEU D 125      34.209  38.447  48.941  1.00  5.97           C  
ATOM   4362  CG  LEU D 125      35.186  39.581  49.282  1.00  6.44           C  
ATOM   4363  CD1 LEU D 125      34.410  40.757  49.853  1.00  8.76           C  
ATOM   4364  CD2 LEU D 125      36.248  39.104  50.265  1.00  7.50           C  
ATOM   4365  N   PHE D 126      37.000  37.153  47.413  1.00  9.05           N  
ATOM   4366  CA  PHE D 126      38.301  36.530  47.639  1.00 10.23           C  
ATOM   4367  C   PHE D 126      39.350  37.533  48.080  1.00 11.58           C  
ATOM   4368  O   PHE D 126      39.257  38.721  47.787  1.00 11.53           O  
ATOM   4369  CB  PHE D 126      38.824  35.858  46.366  1.00 11.75           C  
ATOM   4370  CG  PHE D 126      37.908  34.826  45.790  1.00 12.37           C  
ATOM   4371  CD1 PHE D 126      36.831  35.197  44.990  1.00 12.88           C  
ATOM   4372  CD2 PHE D 126      38.125  33.473  46.038  1.00 14.21           C  
ATOM   4373  CE1 PHE D 126      35.988  34.238  44.445  1.00 16.20           C  
ATOM   4374  CE2 PHE D 126      37.286  32.507  45.496  1.00 14.25           C  
ATOM   4375  CZ  PHE D 126      36.216  32.887  44.698  1.00 13.50           C  
ATOM   4376  N   CYS D 127      40.363  37.037  48.778  1.00 13.16           N  
ATOM   4377  CA  CYS D 127      41.462  37.873  49.231  1.00 13.01           C  
ATOM   4378  C   CYS D 127      42.711  37.010  49.140  1.00 14.71           C  
ATOM   4379  O   CYS D 127      42.819  35.992  49.824  1.00 13.98           O  
ATOM   4380  CB  CYS D 127      41.237  38.335  50.671  1.00 13.95           C  
ATOM   4381  SG  CYS D 127      42.539  39.429  51.298  1.00 18.22           S  
ATOM   4382  N   ASP D 128      43.641  37.410  48.282  1.00 17.38           N  
ATOM   4383  CA  ASP D 128      44.877  36.657  48.094  1.00 21.04           C  
ATOM   4384  C   ASP D 128      44.579  35.236  47.606  1.00 20.92           C  
ATOM   4385  O   ASP D 128      45.387  34.330  47.797  1.00 23.12           O  
ATOM   4386  CB  ASP D 128      45.672  36.585  49.403  1.00 24.36           C  
ATOM   4387  CG  ASP D 128      46.182  37.941  49.860  1.00 27.56           C  
ATOM   4388  OD1 ASP D 128      46.859  38.628  49.065  1.00 29.28           O  
ATOM   4389  OD2 ASP D 128      45.911  38.318  51.021  1.00 31.23           O  
ATOM   4390  N   GLY D 129      43.416  35.046  46.986  1.00 19.43           N  
ATOM   4391  CA  GLY D 129      43.053  33.732  46.477  1.00 18.23           C  
ATOM   4392  C   GLY D 129      42.190  32.898  47.408  1.00 16.97           C  
ATOM   4393  O   GLY D 129      41.758  31.800  47.051  1.00 18.40           O  
ATOM   4394  N   LYS D 130      41.926  33.417  48.601  1.00 14.11           N  
ATOM   4395  CA  LYS D 130      41.115  32.705  49.582  1.00 11.49           C  
ATOM   4396  C   LYS D 130      39.678  33.216  49.608  1.00  9.79           C  
ATOM   4397  O   LYS D 130      39.447  34.423  49.588  1.00  8.46           O  
ATOM   4398  CB  LYS D 130      41.731  32.855  50.977  1.00 13.50           C  
ATOM   4399  CG  LYS D 130      40.879  32.277  52.095  1.00 15.83           C  
ATOM   4400  CD  LYS D 130      41.475  32.551  53.468  1.00 19.59           C  
ATOM   4401  CE  LYS D 130      42.773  31.785  53.691  1.00 25.11           C  
ATOM   4402  NZ  LYS D 130      43.296  31.997  55.070  1.00 27.30           N  
ATOM   4403  N   LEU D 131      38.716  32.297  49.646  1.00  8.54           N  
ATOM   4404  CA  LEU D 131      37.308  32.685  49.705  1.00  8.57           C  
ATOM   4405  C   LEU D 131      37.053  33.165  51.128  1.00  8.15           C  
ATOM   4406  O   LEU D 131      37.190  32.395  52.081  1.00  9.19           O  
ATOM   4407  CB  LEU D 131      36.397  31.491  49.395  1.00 10.16           C  
ATOM   4408  CG  LEU D 131      34.887  31.746  49.395  1.00  9.16           C  
ATOM   4409  CD1 LEU D 131      34.502  32.641  48.217  1.00 10.03           C  
ATOM   4410  CD2 LEU D 131      34.144  30.419  49.301  1.00  9.48           C  
ATOM   4411  N   CYS D 132      36.682  34.434  51.275  1.00  6.83           N  
ATOM   4412  CA  CYS D 132      36.439  34.999  52.595  1.00  7.73           C  
ATOM   4413  C   CYS D 132      34.971  35.283  52.908  1.00  6.17           C  
ATOM   4414  O   CYS D 132      34.619  35.484  54.069  1.00  8.46           O  
ATOM   4415  CB  CYS D 132      37.270  36.272  52.778  1.00  7.85           C  
ATOM   4416  SG  CYS D 132      39.060  35.988  52.753  1.00 11.16           S  
ATOM   4417  N   ALA D 133      34.123  35.304  51.882  1.00  7.59           N  
ATOM   4418  CA  ALA D 133      32.687  35.542  52.073  1.00  7.03           C  
ATOM   4419  C   ALA D 133      31.854  35.054  50.888  1.00  7.65           C  
ATOM   4420  O   ALA D 133      32.318  35.054  49.748  1.00  8.22           O  
ATOM   4421  CB  ALA D 133      32.418  37.038  52.316  1.00  5.88           C  
ATOM   4422  N   GLN D 134      30.622  34.637  51.175  1.00  6.86           N  
ATOM   4423  CA  GLN D 134      29.684  34.156  50.159  1.00  8.18           C  
ATOM   4424  C   GLN D 134      28.389  34.950  50.309  1.00  7.37           C  
ATOM   4425  O   GLN D 134      27.914  35.167  51.422  1.00  9.55           O  
ATOM   4426  CB  GLN D 134      29.393  32.669  50.356  1.00 10.98           C  
ATOM   4427  CG  GLN D 134      30.619  31.790  50.321  1.00 17.33           C  
ATOM   4428  CD  GLN D 134      30.294  30.351  50.659  1.00 19.64           C  
ATOM   4429  OE1 GLN D 134      29.747  30.063  51.723  1.00 21.10           O  
ATOM   4430  NE2 GLN D 134      30.628  29.438  49.755  1.00 21.63           N  
ATOM   4431  N   PHE D 135      27.817  35.362  49.184  1.00  7.91           N  
ATOM   4432  CA  PHE D 135      26.607  36.175  49.176  1.00  7.99           C  
ATOM   4433  C   PHE D 135      25.597  35.650  48.160  1.00 10.08           C  
ATOM   4434  O   PHE D 135      25.958  35.340  47.029  1.00  9.02           O  
ATOM   4435  CB  PHE D 135      27.025  37.624  48.856  1.00  8.29           C  
ATOM   4436  CG  PHE D 135      25.890  38.565  48.528  1.00  7.83           C  
ATOM   4437  CD1 PHE D 135      25.332  38.604  47.250  1.00  6.72           C  
ATOM   4438  CD2 PHE D 135      25.446  39.481  49.475  1.00  8.26           C  
ATOM   4439  CE1 PHE D 135      24.355  39.554  46.921  1.00  8.68           C  
ATOM   4440  CE2 PHE D 135      24.474  40.431  49.162  1.00  6.67           C  
ATOM   4441  CZ  PHE D 135      23.927  40.470  47.882  1.00  7.55           C  
ATOM   4442  N   ASP D 136      24.341  35.522  48.578  1.00 10.07           N  
ATOM   4443  CA  ASP D 136      23.281  35.069  47.689  1.00 12.12           C  
ATOM   4444  C   ASP D 136      22.201  36.137  47.727  1.00 12.28           C  
ATOM   4445  O   ASP D 136      21.584  36.373  48.768  1.00 13.23           O  
ATOM   4446  CB  ASP D 136      22.714  33.724  48.156  1.00 16.32           C  
ATOM   4447  CG  ASP D 136      23.691  32.582  47.957  1.00 21.26           C  
ATOM   4448  OD1 ASP D 136      24.035  32.288  46.793  1.00 24.98           O  
ATOM   4449  OD2 ASP D 136      24.116  31.980  48.966  1.00 25.51           O  
ATOM   4450  N   GLY D 137      21.982  36.793  46.593  1.00 10.13           N  
ATOM   4451  CA  GLY D 137      20.979  37.839  46.555  1.00 10.18           C  
ATOM   4452  C   GLY D 137      19.925  37.662  45.484  1.00 10.14           C  
ATOM   4453  O   GLY D 137      20.208  37.177  44.385  1.00 11.01           O  
ATOM   4454  N   LEU D 138      18.698  38.045  45.815  1.00  9.89           N  
ATOM   4455  CA  LEU D 138      17.589  37.960  44.877  1.00 10.89           C  
ATOM   4456  C   LEU D 138      17.352  39.372  44.369  1.00 12.07           C  
ATOM   4457  O   LEU D 138      16.921  40.249  45.122  1.00 11.85           O  
ATOM   4458  CB  LEU D 138      16.319  37.448  45.565  1.00 14.39           C  
ATOM   4459  CG  LEU D 138      15.118  37.255  44.631  1.00 17.09           C  
ATOM   4460  CD1 LEU D 138      15.421  36.137  43.638  1.00 18.95           C  
ATOM   4461  CD2 LEU D 138      13.876  36.923  45.441  1.00 19.71           C  
ATOM   4462  N   TYR D 139      17.656  39.594  43.096  1.00 10.68           N  
ATOM   4463  CA  TYR D 139      17.475  40.906  42.499  1.00 12.09           C  
ATOM   4464  C   TYR D 139      16.266  40.916  41.585  1.00 12.83           C  
ATOM   4465  O   TYR D 139      15.918  39.901  40.983  1.00 11.59           O  
ATOM   4466  CB  TYR D 139      18.711  41.317  41.690  1.00 11.17           C  
ATOM   4467  CG  TYR D 139      19.968  41.509  42.509  1.00  9.59           C  
ATOM   4468  CD1 TYR D 139      20.733  40.415  42.924  1.00  7.69           C  
ATOM   4469  CD2 TYR D 139      20.399  42.788  42.864  1.00  9.51           C  
ATOM   4470  CE1 TYR D 139      21.901  40.593  43.672  1.00  9.05           C  
ATOM   4471  CE2 TYR D 139      21.561  42.977  43.612  1.00  8.09           C  
ATOM   4472  CZ  TYR D 139      22.305  41.882  44.011  1.00  9.41           C  
ATOM   4473  OH  TYR D 139      23.451  42.060  44.752  1.00  8.41           O  
ATOM   4474  N   VAL D 140      15.628  42.075  41.493  1.00 14.41           N  
ATOM   4475  CA  VAL D 140      14.462  42.238  40.640  1.00 15.93           C  
ATOM   4476  C   VAL D 140      14.725  43.392  39.678  1.00 17.59           C  
ATOM   4477  O   VAL D 140      15.247  44.436  40.073  1.00 17.16           O  
ATOM   4478  CB  VAL D 140      13.196  42.551  41.473  1.00 17.04           C  
ATOM   4479  CG1 VAL D 140      11.996  42.730  40.551  1.00 19.72           C  
ATOM   4480  CG2 VAL D 140      12.935  41.428  42.468  1.00 17.68           C  
ATOM   4481  N   SER D 141      14.379  43.185  38.411  1.00 18.07           N  
ATOM   4482  CA  SER D 141      14.549  44.203  37.382  1.00 21.23           C  
ATOM   4483  C   SER D 141      13.153  44.652  36.958  1.00 22.93           C  
ATOM   4484  O   SER D 141      12.410  43.885  36.347  1.00 23.65           O  
ATOM   4485  CB  SER D 141      15.304  43.621  36.183  1.00 20.80           C  
ATOM   4486  OG  SER D 141      15.524  44.602  35.178  1.00 22.83           O  
ATOM   4487  N   VAL D 142      12.794  45.885  37.306  1.00 24.90           N  
ATOM   4488  CA  VAL D 142      11.481  46.429  36.963  1.00 26.83           C  
ATOM   4489  C   VAL D 142      11.629  47.532  35.923  1.00 27.50           C  
ATOM   4490  O   VAL D 142      12.118  48.619  36.223  1.00 27.44           O  
ATOM   4491  CB  VAL D 142      10.774  47.019  38.203  1.00 26.99           C  
ATOM   4492  CG1 VAL D 142       9.369  47.476  37.835  1.00 27.71           C  
ATOM   4493  CG2 VAL D 142      10.724  45.986  39.316  1.00 28.84           C  
ATOM   4494  N   PRO D 143      11.193  47.270  34.679  1.00 28.35           N  
ATOM   4495  CA  PRO D 143      11.297  48.268  33.611  1.00 28.24           C  
ATOM   4496  C   PRO D 143      10.472  49.525  33.877  1.00 28.26           C  
ATOM   4497  O   PRO D 143       9.611  49.490  34.784  1.00 27.49           O  
ATOM   4498  CB  PRO D 143      10.812  47.502  32.385  1.00 28.53           C  
ATOM   4499  CG  PRO D 143       9.786  46.578  32.965  1.00 29.93           C  
ATOM   4500  CD  PRO D 143      10.485  46.067  34.208  1.00 28.66           C  
TER    4501      PRO D 143                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
