
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1165),  selected  147 , name 1t82_B
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1t82_B.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -5_B      T       6           -
LGA    H    -4_B      D       7           -
LGA    H    -3_B      F       8           -
LGA    H    -2_B      -       -           -
LGA    X     1_B      -       -           -
LGA    D     2_B      -       -           -
LGA    E     3_B      -       -           -
LGA    L     4_B      -       -           -
LGA    L     5_B      -       -           -
LGA    N     6_B      -       -           -
LGA    R     7_B      -       -           -
LGA    L     8_B      F       9          1.431
LGA    R     9_B      -       -           -
LGA    Q    10_B      G      10           #
LGA    T    11_B      L      11          1.395
LGA    W    12_B      T      12          3.455
LGA    H    13_B      I      13          3.342
LGA    S    14_B      -       -           -
LGA    T    15_B      -       -           -
LGA    I    16_B      -       -           -
LGA    P    17_B      P      14          2.087
LGA    V    18_B      F      15          1.675
LGA    S    19_B      M      16          0.817
LGA    E    20_B      Q      17          1.105
LGA    F    21_B      L      18          1.070
LGA    X    22_B      L      19          0.205
LGA    Q    23_B      G      20          1.075
LGA    I    24_B      V      21          1.570
LGA    A    25_B      V      22          1.780
LGA    P    26_B      P      23          1.085
LGA    L    27_B      E      24          1.423
LGA    S    28_B      H      25          2.534
LGA    F    29_B      S      26          3.700
LGA    T    30_B      G      27          5.960
LGA    D    31_B      N      28          5.605
LGA    G    32_B      G      29          3.896
LGA    E    33_B      T      30          2.616
LGA    L    34_B      A      31          1.046
LGA    S    35_B      R      32          0.996
LGA    V    36_B      T      33          0.604
LGA    S    37_B      R      34          1.114
LGA    A    38_B      L      35          1.597
LGA    P    39_B      P      36          1.664
LGA    L    40_B      A      37          2.073
LGA    A    41_B      R      38          0.398
LGA    -       -      A      39           -
LGA    P    42_B      D      40          2.956
LGA    N    43_B      L      41          1.418
LGA    I    44_B      V      42          1.306
LGA    N    45_B      N      43          1.737
LGA    L    46_B      S      44          2.186
LGA    H    47_B      R      45          2.630
LGA    H    48_B      G      46          2.515
LGA    T    49_B      D      47          1.699
LGA    X    50_B      I      48          0.729
LGA    F    51_B      H      49          0.577
LGA    A    52_B      G      50          1.109
LGA    G    53_B      G      51          0.786
LGA    S    54_B      T      52          0.467
LGA    I    55_B      L      53          0.546
LGA    Y    56_B      M      54          0.655
LGA    T    57_B      S      55          0.388
LGA    I    58_B      V      56          0.352
LGA    X    59_B      L      57          0.247
LGA    T    60_B      D      58          0.487
LGA    L    61_B      F      59          0.525
LGA    T    62_B      T      60          0.401
LGA    G    63_B      L      61          0.891
LGA    W    64_B      G      62          1.690
LGA    G    65_B      A      63          1.828
LGA    X    66_B      A      64          1.948
LGA    V    67_B      I      65          2.049
LGA    W    68_B      R      66          2.170
LGA    L    69_B      G      67          1.488
LGA    Q    70_B      D      68          2.393
LGA    Q    71_B      T      69          2.310
LGA    Q    72_B      P      70          2.215
LGA    L    73_B      -       -           -
LGA    L    74_B      -       -           -
LGA    N    75_B      -       -           -
LGA    V    76_B      E      71          3.761
LGA    D    77_B      V      72          3.363
LGA    G    78_B      G      73          3.195
LGA    D    79_B      -       -           -
LGA    I    80_B      V      74          1.711
LGA    V    81_B      A      75          1.250
LGA    L    82_B      T      76          0.863
LGA    A    83_B      I      77          0.936
LGA    D    84_B      D      78          0.850
LGA    A    85_B      M      79          1.027
LGA    H    86_B      N      80          0.876
LGA    I    87_B      T      81          0.691
LGA    R    88_B      S      82          0.889
LGA    Y    89_B      F      83          0.509
LGA    L    90_B      M      84          0.410
LGA    A    91_B      S      85          0.410
LGA    P    92_B      P      86          0.518
LGA    V    93_B      G      87          0.745
LGA    T    94_B      R      88          0.941
LGA    S    95_B      G      89          1.098
LGA    A    96_B      D      90          1.333
LGA    P    97_B      L      91          0.791
LGA    E    98_B      V      92          1.012
LGA    V    99_B      I      93          0.696
LGA    K   100_B      E      94          0.624
LGA    V   101_B      T      95          0.652
LGA    R   102_B      R      96          1.608
LGA    W   103_B      C      97          2.788
LGA    P   104_B      L      98          2.753
LGA    D   105_B      R      99          5.040
LGA    T   106_B      R     100          1.925
LGA    N   107_B      G     101          3.800
LGA    L   108_B      -       -           -
LGA    S   109_B      -       -           -
LGA    P   110_B      A     102          2.867
LGA    L   111_B      -       -           -
LGA    Q   112_B      -       -           -
LGA    R   113_B      -       -           -
LGA    G   114_B      -       -           -
LGA    R   115_B      -       -           -
LGA    K   116_B      -       -           -
LGA    A   117_B      S     103          0.818
LGA    K   118_B      I     104          0.512
LGA    V   119_B      A     105          0.526
LGA    K   120_B      F     106          0.951
LGA    L   121_B      C     107          0.444
LGA    E   122_B      E     108          0.444
LGA    V   123_B      G     109          1.417
LGA    Q   124_B      E     110          0.823
LGA    L   125_B      I     111          0.850
LGA    F   126_B      R     112          0.861
LGA    C   127_B      D     113          0.899
LGA    D   128_B      S     114          2.515
LGA    -       -      A     115           -
LGA    G   129_B      G     116          0.595
LGA    K   130_B      E     117          0.690
LGA    L   131_B      L     118          0.802
LGA    C   132_B      V     119          0.965
LGA    A   133_B      A     120          0.284
LGA    Q   134_B      K     121          1.006
LGA    F   135_B      A     122          0.508
LGA    D   136_B      T     123          0.860
LGA    G   137_B      A     124          0.583
LGA    L   138_B      T     125          0.536
LGA    Y   139_B      F     126          0.670
LGA    V   140_B      K     127          0.736
LGA    S   141_B      I     128          1.506
LGA    V   142_B      I     129          2.295
LGA    P   143_B      Q     130          1.932

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  125    5.0    119    1.84    12.61     87.526     6.130

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.679152 * X  +   0.591988 * Y  +   0.433939 * Z  +  17.514160
  Y_new =   0.455660 * X  +   0.803526 * Y  +  -0.383040 * Z  +  15.351232
  Z_new =  -0.575436 * X  +  -0.062414 * Y  +  -0.815461 * Z  +  49.602184 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.065203    0.076389  [ DEG:  -175.6232      4.3768 ]
  Theta =   0.613138    2.528455  [ DEG:    35.1302    144.8698 ]
  Phi   =   2.550648   -0.590945  [ DEG:   146.1414    -33.8586 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1t82_B                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1t82_B.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  125   5.0  119   1.84   12.61  87.526
REMARK  ---------------------------------------------------------- 
MOLECULE 1t82_B
HEADER    TRANSFERASE                             11-MAY-04   1T82              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE THIOESTERASE FROM                   
TITLE    2 SHEWANELLA ONEIDENSIS, NORTHEAST STRUCTURAL GENOMICS                 
TITLE    3 TARGET SOR51                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL ACETYLTRANSFERASE;                            
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHEWANELLA ONEIDENSIS MR-1;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PET21;                                     
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: BL21(DE3)+MAGIC                           
KEYWDS    STRUCTURAL GENOMICS, ALPHA-BETA DIMERIC PROTEIN WITH A FOLD           
KEYWDS   2 RESEMBLING A HOTDOG, PSI, PROTEIN STRUCTURE INITIATIVE,              
KEYWDS   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,I.LEE,S.M.VOROBIEV,R.XIAO,T.B.ACTON,                       
AUTHOR   2 G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL                  
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   2   25-JAN-05 1T82    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   18-MAY-04 1T82    0                                                
JRNL        AUTH   F.FOROUHAR,I.LEE,S.M.VOROBIEV,R.XIAO,T.B.ACTON,              
JRNL        AUTH 2 G.T.MONTELIONE,J.F.HUNT,L.TONG                               
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE THIOESTERASE               
JRNL        TITL 2 FROM SHEWANELLA ONEIDENSIS, NORTHEAST STRUCTURAL             
JRNL        TITL 3 GENOMICS TARGET SOR51                                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1T82 A    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
DBREF  1T82 B    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
DBREF  1T82 C    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
DBREF  1T82 D    1   145  UNP    Q8E989   Q8E989_SHEON     1    145             
SEQRES   1 A  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 A  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 A  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 A  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 A  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 A  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 A  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 A  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 A  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 A  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 A  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 A  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
SEQRES   1 B  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 B  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 B  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 B  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 B  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 B  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 B  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 B  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 B  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 B  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 B  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 B  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
SEQRES   1 C  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 C  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 C  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 C  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 C  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 C  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 C  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 C  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 C  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 C  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 C  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 C  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
SEQRES   1 D  155  MSE GLY HIS HIS HIS HIS HIS HIS SER HIS MSE ASP GLU          
SEQRES   2 D  155  LEU LEU ASN ARG LEU ARG GLN THR TRP HIS SER THR ILE          
SEQRES   3 D  155  PRO VAL SER GLU PHE MSE GLN ILE ALA PRO LEU SER PHE          
SEQRES   4 D  155  THR ASP GLY GLU LEU SER VAL SER ALA PRO LEU ALA PRO          
SEQRES   5 D  155  ASN ILE ASN LEU HIS HIS THR MSE PHE ALA GLY SER ILE          
SEQRES   6 D  155  TYR THR ILE MSE THR LEU THR GLY TRP GLY MSE VAL TRP          
SEQRES   7 D  155  LEU GLN GLN GLN LEU LEU ASN VAL ASP GLY ASP ILE VAL          
SEQRES   8 D  155  LEU ALA ASP ALA HIS ILE ARG TYR LEU ALA PRO VAL THR          
SEQRES   9 D  155  SER ALA PRO GLU VAL LYS VAL ARG TRP PRO ASP THR ASN          
SEQRES  10 D  155  LEU SER PRO LEU GLN ARG GLY ARG LYS ALA LYS VAL LYS          
SEQRES  11 D  155  LEU GLU VAL GLN LEU PHE CYS ASP GLY LYS LEU CYS ALA          
SEQRES  12 D  155  GLN PHE ASP GLY LEU TYR VAL SER VAL PRO LYS MSE              
HET    MSE  A   1       8                                                       
HET    MSE  A  22       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  59       8                                                       
HET    MSE  A  66       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  22       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B  66       8                                                       
HET    MSE  C  22       8                                                       
HET    MSE  C  50       8                                                       
HET    MSE  C  59       8                                                       
HET    MSE  C  66       8                                                       
HET    MSE  C 145       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  22       8                                                       
HET    MSE  D  50       8                                                       
HET    MSE  D  59       8                                                       
HET    MSE  D  66       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   5  HOH   *434(H2 O)                                                    
CRYST1   54.980   49.669   99.670  90.00  91.09  90.00 P 1 21 1      8          
ATOM   1127  N   HIS B  -5      38.855  54.832  32.445  1.00 21.24           N  
ATOM   1128  CA  HIS B  -5      39.684  53.737  33.022  1.00 21.66           C  
ATOM   1129  C   HIS B  -5      39.788  52.538  32.089  1.00 21.38           C  
ATOM   1130  O   HIS B  -5      38.837  52.204  31.375  1.00 22.27           O  
ATOM   1131  CB  HIS B  -5      39.100  53.278  34.359  1.00 23.51           C  
ATOM   1132  CG  HIS B  -5      39.274  54.267  35.469  1.00 25.75           C  
ATOM   1133  ND1 HIS B  -5      38.827  55.569  35.386  1.00 27.67           N  
ATOM   1134  CD2 HIS B  -5      39.830  54.138  36.697  1.00 26.25           C  
ATOM   1135  CE1 HIS B  -5      39.098  56.197  36.516  1.00 27.47           C  
ATOM   1136  NE2 HIS B  -5      39.707  55.351  37.329  1.00 26.25           N  
ATOM   1137  N   HIS B  -4      40.946  51.886  32.103  1.00 20.19           N  
ATOM   1138  CA  HIS B  -4      41.175  50.713  31.264  1.00 19.28           C  
ATOM   1139  C   HIS B  -4      41.231  49.464  32.135  1.00 18.51           C  
ATOM   1140  O   HIS B  -4      41.951  49.421  33.129  1.00 18.98           O  
ATOM   1141  CB  HIS B  -4      42.480  50.871  30.484  1.00 19.31           C  
ATOM   1142  CG  HIS B  -4      42.590  52.178  29.762  1.00 19.09           C  
ATOM   1143  ND1 HIS B  -4      43.261  53.262  30.284  1.00 21.42           N  
ATOM   1144  CD2 HIS B  -4      42.072  52.588  28.581  1.00 20.19           C  
ATOM   1145  CE1 HIS B  -4      43.151  54.285  29.456  1.00 20.37           C  
ATOM   1146  NE2 HIS B  -4      42.435  53.904  28.415  1.00 22.22           N  
ATOM   1147  N   HIS B  -3      40.460  48.453  31.753  1.00 17.50           N  
ATOM   1148  CA  HIS B  -3      40.398  47.203  32.501  1.00 19.59           C  
ATOM   1149  C   HIS B  -3      40.962  46.065  31.660  1.00 20.38           C  
ATOM   1150  O   HIS B  -3      41.143  46.208  30.452  1.00 22.65           O  
ATOM   1151  CB  HIS B  -3      38.944  46.897  32.864  1.00 18.17           C  
ATOM   1152  CG  HIS B  -3      38.177  48.096  33.329  1.00 17.76           C  
ATOM   1153  ND1 HIS B  -3      38.028  48.416  34.661  1.00 17.51           N  
ATOM   1154  CD2 HIS B  -3      37.554  49.077  32.636  1.00 16.37           C  
ATOM   1155  CE1 HIS B  -3      37.344  49.542  34.768  1.00 17.82           C  
ATOM   1156  NE2 HIS B  -3      37.045  49.964  33.552  1.00 19.03           N  
ATOM   1157  N   HIS B  -2      41.237  44.930  32.295  1.00 22.88           N  
ATOM   1158  CA  HIS B  -2      41.767  43.779  31.572  1.00 25.40           C  
ATOM   1159  C   HIS B  -2      40.864  43.449  30.387  1.00 27.26           C  
ATOM   1160  O   HIS B  -2      40.877  42.327  29.879  1.00 29.56           O  
ATOM   1161  CB  HIS B  -2      41.857  42.573  32.509  1.00 26.72           C  
ATOM   1162  CG  HIS B  -2      43.231  41.988  32.614  1.00 28.79           C  
ATOM   1163  ND1 HIS B  -2      44.375  42.718  32.371  1.00 27.29           N  
ATOM   1164  CD2 HIS B  -2      43.646  40.745  32.958  1.00 29.93           C  
ATOM   1165  CE1 HIS B  -2      45.435  41.951  32.562  1.00 28.57           C  
ATOM   1166  NE2 HIS B  -2      45.019  40.750  32.919  1.00 30.35           N  
HETATM 1167  N   MSE B   1      35.156  45.808  27.220  1.00 22.98           N  
HETATM 1168  CA  MSE B   1      33.946  46.276  27.896  1.00 21.80           C  
HETATM 1169  C   MSE B   1      34.239  47.558  28.676  1.00 20.57           C  
HETATM 1170  O   MSE B   1      33.478  47.925  29.567  1.00 18.46           O  
HETATM 1171  CB  MSE B   1      33.424  45.197  28.864  1.00 25.81           C  
HETATM 1172  CG  MSE B   1      32.827  43.928  28.216  1.00 28.03           C  
HETATM 1173 SE   MSE B   1      30.927  44.025  27.785  1.00 51.21          SE  
HETATM 1174  CE  MSE B   1      30.988  43.554  25.907  1.00 28.49           C  
ATOM   1175  N   ASP B   2      35.336  48.235  28.334  1.00 20.03           N  
ATOM   1176  CA  ASP B   2      35.718  49.468  29.025  1.00 18.80           C  
ATOM   1177  C   ASP B   2      34.588  50.486  29.122  1.00 17.94           C  
ATOM   1178  O   ASP B   2      34.373  51.087  30.174  1.00 16.05           O  
ATOM   1179  CB  ASP B   2      36.927  50.125  28.351  1.00 23.00           C  
ATOM   1180  CG  ASP B   2      38.216  49.357  28.584  1.00 26.94           C  
ATOM   1181  OD1 ASP B   2      38.485  48.976  29.746  1.00 27.65           O  
ATOM   1182  OD2 ASP B   2      38.971  49.151  27.610  1.00 29.04           O  
ATOM   1183  N   GLU B   3      33.871  50.685  28.021  1.00 17.07           N  
ATOM   1184  CA  GLU B   3      32.772  51.638  28.000  1.00 18.46           C  
ATOM   1185  C   GLU B   3      31.723  51.343  29.071  1.00 16.00           C  
ATOM   1186  O   GLU B   3      31.353  52.227  29.842  1.00 15.81           O  
ATOM   1187  CB  GLU B   3      32.122  51.659  26.612  1.00 19.96           C  
ATOM   1188  CG  GLU B   3      33.034  52.206  25.516  1.00 25.30           C  
ATOM   1189  CD  GLU B   3      34.146  51.248  25.118  1.00 27.31           C  
ATOM   1190  OE1 GLU B   3      35.115  51.703  24.469  1.00 30.82           O  
ATOM   1191  OE2 GLU B   3      34.053  50.042  25.439  1.00 27.33           O  
ATOM   1192  N   LEU B   4      31.246  50.102  29.121  1.00 15.99           N  
ATOM   1193  CA  LEU B   4      30.238  49.717  30.104  1.00 15.55           C  
ATOM   1194  C   LEU B   4      30.751  49.748  31.538  1.00 13.71           C  
ATOM   1195  O   LEU B   4      30.052  50.209  32.437  1.00 12.52           O  
ATOM   1196  CB  LEU B   4      29.686  48.320  29.796  1.00 17.31           C  
ATOM   1197  CG  LEU B   4      28.617  48.229  28.706  1.00 19.87           C  
ATOM   1198  CD1 LEU B   4      28.255  46.773  28.472  1.00 20.88           C  
ATOM   1199  CD2 LEU B   4      27.388  49.026  29.123  1.00 21.42           C  
ATOM   1200  N   LEU B   5      31.967  49.258  31.757  1.00 11.76           N  
ATOM   1201  CA  LEU B   5      32.532  49.243  33.103  1.00 13.35           C  
ATOM   1202  C   LEU B   5      32.724  50.651  33.648  1.00 13.30           C  
ATOM   1203  O   LEU B   5      32.497  50.900  34.832  1.00 13.29           O  
ATOM   1204  CB  LEU B   5      33.859  48.482  33.119  1.00 13.09           C  
ATOM   1205  CG  LEU B   5      33.734  46.987  32.797  1.00 15.38           C  
ATOM   1206  CD1 LEU B   5      35.108  46.373  32.661  1.00 18.52           C  
ATOM   1207  CD2 LEU B   5      32.926  46.291  33.885  1.00 17.21           C  
ATOM   1208  N   ASN B   6      33.153  51.572  32.792  1.00 13.57           N  
ATOM   1209  CA  ASN B   6      33.335  52.951  33.227  1.00 13.07           C  
ATOM   1210  C   ASN B   6      31.974  53.556  33.542  1.00 13.15           C  
ATOM   1211  O   ASN B   6      31.823  54.309  34.502  1.00 10.62           O  
ATOM   1212  CB  ASN B   6      34.041  53.770  32.143  1.00 13.85           C  
ATOM   1213  CG  ASN B   6      35.541  53.571  32.155  1.00 14.82           C  
ATOM   1214  OD1 ASN B   6      36.141  53.173  31.156  1.00 19.28           O  
ATOM   1215  ND2 ASN B   6      36.157  53.848  33.297  1.00 15.86           N  
ATOM   1216  N   ARG B   7      30.985  53.209  32.722  1.00 12.91           N  
ATOM   1217  CA  ARG B   7      29.620  53.691  32.893  1.00 14.24           C  
ATOM   1218  C   ARG B   7      29.070  53.183  34.219  1.00 12.41           C  
ATOM   1219  O   ARG B   7      28.399  53.910  34.948  1.00 12.45           O  
ATOM   1220  CB  ARG B   7      28.736  53.180  31.751  1.00 16.49           C  
ATOM   1221  CG  ARG B   7      27.301  53.674  31.799  1.00 22.26           C  
ATOM   1222  CD  ARG B   7      27.088  54.848  30.860  1.00 25.72           C  
ATOM   1223  NE  ARG B   7      27.288  54.467  29.466  1.00 27.39           N  
ATOM   1224  CZ  ARG B   7      26.534  53.586  28.815  1.00 28.94           C  
ATOM   1225  NH1 ARG B   7      26.790  53.301  27.543  1.00 30.54           N  
ATOM   1226  NH2 ARG B   7      25.521  52.993  29.432  1.00 29.23           N  
ATOM   1227  N   LEU B   8      29.353  51.920  34.520  1.00 11.48           N  
ATOM   1228  CA  LEU B   8      28.886  51.317  35.760  1.00 10.62           C  
ATOM   1229  C   LEU B   8      29.505  52.034  36.957  1.00 10.40           C  
ATOM   1230  O   LEU B   8      28.809  52.408  37.899  1.00  9.80           O  
ATOM   1231  CB  LEU B   8      29.248  49.826  35.789  1.00 10.48           C  
ATOM   1232  CG  LEU B   8      28.907  49.057  37.069  1.00 10.75           C  
ATOM   1233  CD1 LEU B   8      27.424  49.177  37.361  1.00 11.23           C  
ATOM   1234  CD2 LEU B   8      29.306  47.594  36.918  1.00 12.18           C  
ATOM   1235  N   ARG B   9      30.817  52.239  36.903  1.00 11.14           N  
ATOM   1236  CA  ARG B   9      31.540  52.908  37.982  1.00 12.39           C  
ATOM   1237  C   ARG B   9      30.999  54.329  38.203  1.00 11.38           C  
ATOM   1238  O   ARG B   9      30.773  54.750  39.336  1.00 10.20           O  
ATOM   1239  CB  ARG B   9      33.034  52.941  37.639  1.00 13.47           C  
ATOM   1240  CG  ARG B   9      33.971  53.237  38.798  1.00 20.12           C  
ATOM   1241  CD  ARG B   9      34.180  54.721  38.990  1.00 23.82           C  
ATOM   1242  NE  ARG B   9      34.501  55.408  37.740  1.00 27.20           N  
ATOM   1243  CZ  ARG B   9      35.512  55.093  36.935  1.00 25.64           C  
ATOM   1244  NH1 ARG B   9      35.708  55.789  35.822  1.00 27.30           N  
ATOM   1245  NH2 ARG B   9      36.322  54.088  37.232  1.00 28.62           N  
ATOM   1246  N   GLN B  10      30.784  55.054  37.108  1.00 11.23           N  
ATOM   1247  CA  GLN B  10      30.272  56.418  37.163  1.00 12.32           C  
ATOM   1248  C   GLN B  10      28.856  56.450  37.733  1.00 11.53           C  
ATOM   1249  O   GLN B  10      28.495  57.364  38.480  1.00 12.33           O  
ATOM   1250  CB  GLN B  10      30.284  57.031  35.761  1.00 16.03           C  
ATOM   1251  CG  GLN B  10      29.737  58.444  35.678  1.00 22.02           C  
ATOM   1252  CD  GLN B  10      30.386  59.378  36.675  1.00 25.89           C  
ATOM   1253  OE1 GLN B  10      31.612  59.472  36.752  1.00 29.30           O  
ATOM   1254  NE2 GLN B  10      29.565  60.084  37.444  1.00 28.96           N  
ATOM   1255  N   THR B  11      28.061  55.448  37.377  1.00 11.48           N  
ATOM   1256  CA  THR B  11      26.689  55.354  37.864  1.00 11.63           C  
ATOM   1257  C   THR B  11      26.711  55.188  39.378  1.00 10.70           C  
ATOM   1258  O   THR B  11      25.933  55.821  40.088  1.00 10.63           O  
ATOM   1259  CB  THR B  11      25.957  54.152  37.236  1.00 12.07           C  
ATOM   1260  OG1 THR B  11      25.884  54.326  35.814  1.00 13.48           O  
ATOM   1261  CG2 THR B  11      24.548  54.025  37.803  1.00 13.80           C  
ATOM   1262  N   TRP B  12      27.607  54.339  39.871  1.00 10.48           N  
ATOM   1263  CA  TRP B  12      27.705  54.118  41.308  1.00 10.03           C  
ATOM   1264  C   TRP B  12      28.105  55.372  42.073  1.00 10.48           C  
ATOM   1265  O   TRP B  12      27.388  55.822  42.964  1.00 10.52           O  
ATOM   1266  CB  TRP B  12      28.726  53.023  41.639  1.00  8.47           C  
ATOM   1267  CG  TRP B  12      28.298  51.630  41.339  1.00  7.15           C  
ATOM   1268  CD1 TRP B  12      27.022  51.164  41.232  1.00  7.86           C  
ATOM   1269  CD2 TRP B  12      29.156  50.495  41.193  1.00  8.69           C  
ATOM   1270  NE1 TRP B  12      27.030  49.800  41.030  1.00  8.14           N  
ATOM   1271  CE2 TRP B  12      28.329  49.365  41.002  1.00  9.55           C  
ATOM   1272  CE3 TRP B  12      30.546  50.323  41.208  1.00 11.04           C  
ATOM   1273  CZ2 TRP B  12      28.846  48.078  40.827  1.00 10.57           C  
ATOM   1274  CZ3 TRP B  12      31.062  49.042  41.034  1.00 11.08           C  
ATOM   1275  CH2 TRP B  12      30.210  47.936  40.846  1.00 10.95           C  
ATOM   1276  N   HIS B  13      29.255  55.937  41.731  1.00 10.95           N  
ATOM   1277  CA  HIS B  13      29.746  57.110  42.444  1.00 11.74           C  
ATOM   1278  C   HIS B  13      28.869  58.350  42.318  1.00 11.94           C  
ATOM   1279  O   HIS B  13      28.863  59.189  43.213  1.00 13.67           O  
ATOM   1280  CB  HIS B  13      31.172  57.438  41.998  1.00 12.35           C  
ATOM   1281  CG  HIS B  13      32.155  56.344  42.282  1.00 13.07           C  
ATOM   1282  ND1 HIS B  13      33.494  56.445  41.969  1.00 12.75           N  
ATOM   1283  CD2 HIS B  13      31.990  55.117  42.830  1.00 13.66           C  
ATOM   1284  CE1 HIS B  13      34.111  55.328  42.312  1.00 13.76           C  
ATOM   1285  NE2 HIS B  13      33.220  54.505  42.837  1.00 11.71           N  
ATOM   1286  N   SER B  14      28.128  58.465  41.222  1.00 12.48           N  
ATOM   1287  CA  SER B  14      27.271  59.629  41.026  1.00 13.12           C  
ATOM   1288  C   SER B  14      25.897  59.492  41.670  1.00 14.01           C  
ATOM   1289  O   SER B  14      25.223  60.493  41.921  1.00 15.50           O  
ATOM   1290  CB  SER B  14      27.096  59.922  39.532  1.00 12.25           C  
ATOM   1291  OG  SER B  14      26.329  58.916  38.892  1.00 16.42           O  
ATOM   1292  N   THR B  15      25.467  58.268  41.941  1.00 10.65           N  
ATOM   1293  CA  THR B  15      24.147  58.087  42.533  1.00 11.67           C  
ATOM   1294  C   THR B  15      24.171  57.565  43.961  1.00 10.34           C  
ATOM   1295  O   THR B  15      23.212  57.748  44.713  1.00 10.37           O  
ATOM   1296  CB  THR B  15      23.293  57.122  41.692  1.00 11.55           C  
ATOM   1297  OG1 THR B  15      23.844  55.800  41.767  1.00 10.97           O  
ATOM   1298  CG2 THR B  15      23.265  57.571  40.238  1.00 15.17           C  
ATOM   1299  N   ILE B  16      25.275  56.928  44.335  1.00  8.97           N  
ATOM   1300  CA  ILE B  16      25.410  56.346  45.668  1.00  7.25           C  
ATOM   1301  C   ILE B  16      26.672  56.859  46.356  1.00  7.55           C  
ATOM   1302  O   ILE B  16      27.745  56.276  46.213  1.00  5.88           O  
ATOM   1303  CB  ILE B  16      25.475  54.810  45.558  1.00  7.62           C  
ATOM   1304  CG1 ILE B  16      24.242  54.294  44.806  1.00 10.42           C  
ATOM   1305  CG2 ILE B  16      25.571  54.189  46.942  1.00  7.45           C  
ATOM   1306  CD1 ILE B  16      24.316  52.824  44.430  1.00 11.11           C  
ATOM   1307  N   PRO B  17      26.557  57.955  47.124  1.00  7.58           N  
ATOM   1308  CA  PRO B  17      27.701  58.543  47.828  1.00  8.22           C  
ATOM   1309  C   PRO B  17      28.555  57.549  48.622  1.00  6.94           C  
ATOM   1310  O   PRO B  17      29.777  57.685  48.675  1.00  8.46           O  
ATOM   1311  CB  PRO B  17      27.051  59.607  48.712  1.00  6.42           C  
ATOM   1312  CG  PRO B  17      25.866  60.041  47.880  1.00  8.49           C  
ATOM   1313  CD  PRO B  17      25.321  58.709  47.410  1.00  8.91           C  
ATOM   1314  N   VAL B  18      27.914  56.554  49.233  1.00  7.20           N  
ATOM   1315  CA  VAL B  18      28.639  55.545  50.003  1.00  7.34           C  
ATOM   1316  C   VAL B  18      29.607  54.764  49.114  1.00  6.00           C  
ATOM   1317  O   VAL B  18      30.715  54.414  49.545  1.00  5.47           O  
ATOM   1318  CB  VAL B  18      27.665  54.537  50.674  1.00  6.69           C  
ATOM   1319  CG1 VAL B  18      28.415  53.256  51.066  1.00  7.01           C  
ATOM   1320  CG2 VAL B  18      27.051  55.162  51.918  1.00  8.65           C  
ATOM   1321  N   SER B  19      29.200  54.488  47.878  1.00  6.01           N  
ATOM   1322  CA  SER B  19      30.059  53.720  46.968  1.00  6.63           C  
ATOM   1323  C   SER B  19      31.326  54.489  46.605  1.00  7.22           C  
ATOM   1324  O   SER B  19      32.378  53.893  46.363  1.00  6.40           O  
ATOM   1325  CB  SER B  19      29.295  53.320  45.692  1.00  6.86           C  
ATOM   1326  OG  SER B  19      29.004  54.428  44.861  1.00  8.74           O  
ATOM   1327  N   GLU B  20      31.216  55.815  46.572  1.00  6.44           N  
ATOM   1328  CA  GLU B  20      32.344  56.677  46.260  1.00  8.00           C  
ATOM   1329  C   GLU B  20      33.265  56.748  47.469  1.00  8.22           C  
ATOM   1330  O   GLU B  20      34.491  56.724  47.332  1.00  8.38           O  
ATOM   1331  CB  GLU B  20      31.846  58.073  45.897  1.00 10.91           C  
ATOM   1332  CG  GLU B  20      32.944  59.060  45.559  1.00 15.96           C  
ATOM   1333  CD  GLU B  20      32.391  60.423  45.200  1.00 18.52           C  
ATOM   1334  OE1 GLU B  20      31.735  61.047  46.062  1.00 20.26           O  
ATOM   1335  OE2 GLU B  20      32.609  60.868  44.055  1.00 20.82           O  
ATOM   1336  N   PHE B  21      32.682  56.836  48.658  1.00  6.95           N  
ATOM   1337  CA  PHE B  21      33.499  56.894  49.862  1.00  6.22           C  
ATOM   1338  C   PHE B  21      34.273  55.584  50.014  1.00  7.64           C  
ATOM   1339  O   PHE B  21      35.446  55.585  50.381  1.00  8.72           O  
ATOM   1340  CB  PHE B  21      32.636  57.142  51.105  1.00  6.05           C  
ATOM   1341  CG  PHE B  21      33.406  57.062  52.391  1.00  6.68           C  
ATOM   1342  CD1 PHE B  21      33.531  55.850  53.064  1.00  8.16           C  
ATOM   1343  CD2 PHE B  21      34.062  58.183  52.896  1.00  6.36           C  
ATOM   1344  CE1 PHE B  21      34.302  55.753  54.220  1.00  8.42           C  
ATOM   1345  CE2 PHE B  21      34.836  58.097  54.049  1.00  6.41           C  
ATOM   1346  CZ  PHE B  21      34.957  56.874  54.715  1.00  8.14           C  
HETATM 1347  N   MSE B  22      33.613  54.470  49.709  1.00  7.75           N  
HETATM 1348  CA  MSE B  22      34.237  53.153  49.813  1.00  8.75           C  
HETATM 1349  C   MSE B  22      35.204  52.865  48.666  1.00  7.09           C  
HETATM 1350  O   MSE B  22      35.922  51.859  48.687  1.00  5.80           O  
HETATM 1351  CB  MSE B  22      33.159  52.063  49.852  1.00  8.43           C  
HETATM 1352  CG  MSE B  22      32.325  52.035  51.117  1.00  7.61           C  
HETATM 1353 SE   MSE B  22      31.112  50.541  51.126  1.00 16.41          SE  
HETATM 1354  CE  MSE B  22      30.363  50.740  52.892  1.00 12.33           C  
ATOM   1355  N   GLN B  23      35.214  53.746  47.669  1.00  6.96           N  
ATOM   1356  CA  GLN B  23      36.084  53.609  46.500  1.00  8.13           C  
ATOM   1357  C   GLN B  23      35.899  52.281  45.771  1.00  8.74           C  
ATOM   1358  O   GLN B  23      36.864  51.665  45.310  1.00  9.05           O  
ATOM   1359  CB  GLN B  23      37.550  53.791  46.915  1.00 10.09           C  
ATOM   1360  CG  GLN B  23      37.858  55.188  47.444  1.00 13.14           C  
ATOM   1361  CD  GLN B  23      37.864  56.257  46.359  1.00 17.13           C  
ATOM   1362  OE1 GLN B  23      37.399  56.035  45.239  1.00 18.73           O  
ATOM   1363  NE2 GLN B  23      38.391  57.433  46.695  1.00 18.79           N  
ATOM   1364  N   ILE B  24      34.648  51.845  45.668  1.00  8.04           N  
ATOM   1365  CA  ILE B  24      34.331  50.596  44.983  1.00  8.67           C  
ATOM   1366  C   ILE B  24      34.403  50.819  43.478  1.00 10.20           C  
ATOM   1367  O   ILE B  24      33.874  51.804  42.960  1.00 10.75           O  
ATOM   1368  CB  ILE B  24      32.920  50.107  45.366  1.00  9.27           C  
ATOM   1369  CG1 ILE B  24      32.849  49.917  46.884  1.00 12.57           C  
ATOM   1370  CG2 ILE B  24      32.590  48.812  44.632  1.00  8.93           C  
ATOM   1371  CD1 ILE B  24      31.470  49.579  47.411  1.00 16.51           C  
ATOM   1372  N   ALA B  25      35.068  49.910  42.777  1.00  8.80           N  
ATOM   1373  CA  ALA B  25      35.190  50.042  41.337  1.00 10.16           C  
ATOM   1374  C   ALA B  25      35.318  48.695  40.652  1.00  8.56           C  
ATOM   1375  O   ALA B  25      35.878  47.754  41.206  1.00  8.29           O  
ATOM   1376  CB  ALA B  25      36.391  50.914  40.990  1.00 11.72           C  
ATOM   1377  N   PRO B  26      34.789  48.587  39.426  1.00 10.63           N  
ATOM   1378  CA  PRO B  26      34.854  47.338  38.661  1.00 11.08           C  
ATOM   1379  C   PRO B  26      36.287  47.048  38.230  1.00 12.35           C  
ATOM   1380  O   PRO B  26      37.076  47.968  38.002  1.00 14.47           O  
ATOM   1381  CB  PRO B  26      33.952  47.619  37.456  1.00 11.60           C  
ATOM   1382  CG  PRO B  26      33.001  48.653  37.964  1.00 13.94           C  
ATOM   1383  CD  PRO B  26      33.902  49.557  38.763  1.00 10.80           C  
ATOM   1384  N   LEU B  27      36.620  45.767  38.130  1.00 11.49           N  
ATOM   1385  CA  LEU B  27      37.951  45.348  37.701  1.00 12.91           C  
ATOM   1386  C   LEU B  27      37.906  44.805  36.278  1.00 13.11           C  
ATOM   1387  O   LEU B  27      38.755  45.136  35.451  1.00 13.98           O  
ATOM   1388  CB  LEU B  27      38.502  44.259  38.628  1.00 14.55           C  
ATOM   1389  CG  LEU B  27      38.984  44.665  40.023  1.00 15.81           C  
ATOM   1390  CD1 LEU B  27      39.355  43.422  40.825  1.00 17.88           C  
ATOM   1391  CD2 LEU B  27      40.180  45.590  39.895  1.00 17.50           C  
ATOM   1392  N   SER B  28      36.908  43.976  35.992  1.00 12.35           N  
ATOM   1393  CA  SER B  28      36.793  43.378  34.671  1.00 12.46           C  
ATOM   1394  C   SER B  28      35.461  42.679  34.459  1.00 12.07           C  
ATOM   1395  O   SER B  28      34.765  42.338  35.415  1.00 10.29           O  
ATOM   1396  CB  SER B  28      37.921  42.365  34.474  1.00 12.84           C  
ATOM   1397  OG  SER B  28      37.867  41.369  35.487  1.00 14.87           O  
ATOM   1398  N   PHE B  29      35.119  42.458  33.196  1.00 12.11           N  
ATOM   1399  CA  PHE B  29      33.881  41.778  32.843  1.00 13.75           C  
ATOM   1400  C   PHE B  29      34.106  41.002  31.553  1.00 15.33           C  
ATOM   1401  O   PHE B  29      34.060  41.568  30.460  1.00 16.24           O  
ATOM   1402  CB  PHE B  29      32.741  42.787  32.662  1.00 13.64           C  
ATOM   1403  CG  PHE B  29      31.433  42.164  32.244  1.00 15.16           C  
ATOM   1404  CD1 PHE B  29      30.913  41.070  32.930  1.00 16.85           C  
ATOM   1405  CD2 PHE B  29      30.718  42.677  31.166  1.00 17.95           C  
ATOM   1406  CE1 PHE B  29      29.701  40.496  32.548  1.00 16.98           C  
ATOM   1407  CE2 PHE B  29      29.505  42.113  30.776  1.00 17.39           C  
ATOM   1408  CZ  PHE B  29      28.996  41.018  31.467  1.00 18.05           C  
ATOM   1409  N   THR B  30      34.366  39.706  31.688  1.00 16.33           N  
ATOM   1410  CA  THR B  30      34.599  38.855  30.527  1.00 19.20           C  
ATOM   1411  C   THR B  30      34.121  37.434  30.779  1.00 18.01           C  
ATOM   1412  O   THR B  30      34.142  36.953  31.912  1.00 15.89           O  
ATOM   1413  CB  THR B  30      36.096  38.813  30.155  1.00 22.21           C  
ATOM   1414  OG1 THR B  30      36.286  37.951  29.026  1.00 25.83           O  
ATOM   1415  CG2 THR B  30      36.921  38.298  31.323  1.00 22.91           C  
ATOM   1416  N   ASP B  31      33.692  36.764  29.713  1.00 17.99           N  
ATOM   1417  CA  ASP B  31      33.206  35.393  29.812  1.00 19.34           C  
ATOM   1418  C   ASP B  31      32.085  35.229  30.828  1.00 16.31           C  
ATOM   1419  O   ASP B  31      31.984  34.192  31.479  1.00 16.38           O  
ATOM   1420  CB  ASP B  31      34.353  34.449  30.175  1.00 23.52           C  
ATOM   1421  CG  ASP B  31      35.127  33.986  28.964  1.00 28.35           C  
ATOM   1422  OD1 ASP B  31      35.643  34.846  28.216  1.00 29.67           O  
ATOM   1423  OD2 ASP B  31      35.219  32.756  28.759  1.00 31.48           O  
ATOM   1424  N   GLY B  32      31.253  36.257  30.964  1.00 13.52           N  
ATOM   1425  CA  GLY B  32      30.140  36.187  31.888  1.00 12.39           C  
ATOM   1426  C   GLY B  32      30.468  36.379  33.356  1.00 10.87           C  
ATOM   1427  O   GLY B  32      29.610  36.159  34.209  1.00 10.88           O  
ATOM   1428  N   GLU B  33      31.694  36.791  33.661  1.00 10.40           N  
ATOM   1429  CA  GLU B  33      32.085  37.004  35.051  1.00  9.41           C  
ATOM   1430  C   GLU B  33      32.467  38.451  35.325  1.00  9.42           C  
ATOM   1431  O   GLU B  33      33.304  39.024  34.631  1.00 10.50           O  
ATOM   1432  CB  GLU B  33      33.263  36.100  35.428  1.00 12.04           C  
ATOM   1433  CG  GLU B  33      33.672  36.220  36.890  1.00 14.05           C  
ATOM   1434  CD  GLU B  33      34.804  35.281  37.262  1.00 17.54           C  
ATOM   1435  OE1 GLU B  33      35.901  35.422  36.690  1.00 20.64           O  
ATOM   1436  OE2 GLU B  33      34.590  34.408  38.122  1.00 20.36           O  
ATOM   1437  N   LEU B  34      31.836  39.040  36.335  1.00  8.69           N  
ATOM   1438  CA  LEU B  34      32.135  40.412  36.725  1.00  7.96           C  
ATOM   1439  C   LEU B  34      32.998  40.371  37.982  1.00  8.48           C  
ATOM   1440  O   LEU B  34      32.678  39.669  38.945  1.00  8.30           O  
ATOM   1441  CB  LEU B  34      30.845  41.194  37.014  1.00  7.74           C  
ATOM   1442  CG  LEU B  34      31.027  42.572  37.663  1.00  9.64           C  
ATOM   1443  CD1 LEU B  34      31.768  43.494  36.701  1.00  7.03           C  
ATOM   1444  CD2 LEU B  34      29.673  43.170  38.036  1.00  8.33           C  
ATOM   1445  N   SER B  35      34.104  41.109  37.962  1.00  6.55           N  
ATOM   1446  CA  SER B  35      35.010  41.181  39.104  1.00  7.90           C  
ATOM   1447  C   SER B  35      35.043  42.630  39.590  1.00  7.19           C  
ATOM   1448  O   SER B  35      35.188  43.555  38.789  1.00  8.84           O  
ATOM   1449  CB  SER B  35      36.420  40.734  38.699  1.00 10.38           C  
ATOM   1450  OG  SER B  35      36.465  39.334  38.447  1.00 17.37           O  
ATOM   1451  N   VAL B  36      34.909  42.817  40.901  1.00  6.83           N  
ATOM   1452  CA  VAL B  36      34.886  44.145  41.514  1.00  6.96           C  
ATOM   1453  C   VAL B  36      35.811  44.187  42.733  1.00  7.04           C  
ATOM   1454  O   VAL B  36      36.094  43.155  43.338  1.00  8.44           O  
ATOM   1455  CB  VAL B  36      33.436  44.493  41.960  1.00  7.71           C  
ATOM   1456  CG1 VAL B  36      33.397  45.826  42.695  1.00  7.45           C  
ATOM   1457  CG2 VAL B  36      32.516  44.529  40.742  1.00  6.08           C  
ATOM   1458  N   SER B  37      36.294  45.374  43.094  1.00  7.49           N  
ATOM   1459  CA  SER B  37      37.159  45.491  44.260  1.00  7.04           C  
ATOM   1460  C   SER B  37      37.002  46.858  44.910  1.00  7.73           C  
ATOM   1461  O   SER B  37      36.256  47.709  44.426  1.00  6.74           O  
ATOM   1462  CB  SER B  37      38.627  45.274  43.870  1.00  8.62           C  
ATOM   1463  OG  SER B  37      39.464  45.217  45.019  1.00  9.95           O  
ATOM   1464  N   ALA B  38      37.701  47.044  46.021  1.00  6.93           N  
ATOM   1465  CA  ALA B  38      37.691  48.297  46.759  1.00  7.03           C  
ATOM   1466  C   ALA B  38      38.890  48.234  47.682  1.00  7.15           C  
ATOM   1467  O   ALA B  38      39.291  47.153  48.114  1.00  9.03           O  
ATOM   1468  CB  ALA B  38      36.405  48.442  47.574  1.00  7.92           C  
ATOM   1469  N   PRO B  39      39.494  49.390  47.975  1.00  7.91           N  
ATOM   1470  CA  PRO B  39      40.653  49.429  48.860  1.00  6.91           C  
ATOM   1471  C   PRO B  39      40.206  49.139  50.280  1.00  6.88           C  
ATOM   1472  O   PRO B  39      39.037  49.326  50.630  1.00  8.70           O  
ATOM   1473  CB  PRO B  39      41.161  50.858  48.698  1.00  7.96           C  
ATOM   1474  CG  PRO B  39      39.899  51.624  48.448  1.00  9.11           C  
ATOM   1475  CD  PRO B  39      39.174  50.732  47.467  1.00  7.49           C  
ATOM   1476  N   LEU B  40      41.136  48.679  51.100  1.00  7.57           N  
ATOM   1477  CA  LEU B  40      40.817  48.370  52.477  1.00  8.22           C  
ATOM   1478  C   LEU B  40      40.690  49.631  53.329  1.00  8.28           C  
ATOM   1479  O   LEU B  40      39.787  49.736  54.152  1.00  9.45           O  
ATOM   1480  CB  LEU B  40      41.892  47.456  53.064  1.00 10.65           C  
ATOM   1481  CG  LEU B  40      41.692  46.996  54.506  1.00 11.83           C  
ATOM   1482  CD1 LEU B  40      40.320  46.337  54.672  1.00 12.61           C  
ATOM   1483  CD2 LEU B  40      42.805  46.019  54.866  1.00 14.95           C  
ATOM   1484  N   ALA B  41      41.577  50.596  53.099  1.00  8.63           N  
ATOM   1485  CA  ALA B  41      41.625  51.833  53.881  1.00  8.24           C  
ATOM   1486  C   ALA B  41      40.336  52.479  54.394  1.00  7.35           C  
ATOM   1487  O   ALA B  41      40.165  52.630  55.603  1.00  9.41           O  
ATOM   1488  CB  ALA B  41      42.465  52.877  53.138  1.00  7.72           C  
ATOM   1489  N   PRO B  42      39.418  52.881  53.498  1.00  8.04           N  
ATOM   1490  CA  PRO B  42      38.183  53.509  53.982  1.00  7.06           C  
ATOM   1491  C   PRO B  42      37.191  52.496  54.539  1.00  6.37           C  
ATOM   1492  O   PRO B  42      36.212  52.850  55.198  1.00  7.46           O  
ATOM   1493  CB  PRO B  42      37.651  54.211  52.737  1.00  8.79           C  
ATOM   1494  CG  PRO B  42      38.056  53.272  51.633  1.00  8.81           C  
ATOM   1495  CD  PRO B  42      39.460  52.846  52.022  1.00  7.44           C  
ATOM   1496  N   ASN B  43      37.476  51.230  54.279  1.00  5.64           N  
ATOM   1497  CA  ASN B  43      36.610  50.130  54.682  1.00  6.18           C  
ATOM   1498  C   ASN B  43      37.067  49.310  55.883  1.00  7.53           C  
ATOM   1499  O   ASN B  43      36.597  48.192  56.085  1.00  6.31           O  
ATOM   1500  CB  ASN B  43      36.421  49.212  53.474  1.00  4.72           C  
ATOM   1501  CG  ASN B  43      35.810  49.938  52.297  1.00  5.33           C  
ATOM   1502  OD1 ASN B  43      36.401  50.018  51.217  1.00  7.60           O  
ATOM   1503  ND2 ASN B  43      34.622  50.478  52.502  1.00  2.67           N  
ATOM   1504  N   ILE B  44      37.968  49.858  56.691  1.00  7.21           N  
ATOM   1505  CA  ILE B  44      38.463  49.113  57.843  1.00  7.14           C  
ATOM   1506  C   ILE B  44      37.563  49.120  59.081  1.00  7.51           C  
ATOM   1507  O   ILE B  44      36.578  49.863  59.170  1.00  6.33           O  
ATOM   1508  CB  ILE B  44      39.864  49.616  58.276  1.00  8.34           C  
ATOM   1509  CG1 ILE B  44      39.801  51.097  58.670  1.00  8.58           C  
ATOM   1510  CG2 ILE B  44      40.853  49.428  57.135  1.00 10.16           C  
ATOM   1511  CD1 ILE B  44      41.135  51.658  59.163  1.00 13.61           C  
ATOM   1512  N   ASN B  45      37.919  48.247  60.017  1.00  8.70           N  
ATOM   1513  CA  ASN B  45      37.247  48.118  61.302  1.00  9.27           C  
ATOM   1514  C   ASN B  45      38.386  48.227  62.317  1.00  9.83           C  
ATOM   1515  O   ASN B  45      39.519  48.521  61.938  1.00  8.80           O  
ATOM   1516  CB  ASN B  45      36.547  46.761  61.431  1.00 10.01           C  
ATOM   1517  CG  ASN B  45      37.483  45.599  61.181  1.00  7.55           C  
ATOM   1518  OD1 ASN B  45      38.678  45.684  61.455  1.00  9.55           O  
ATOM   1519  ND2 ASN B  45      36.939  44.496  60.664  1.00  9.43           N  
ATOM   1520  N   LEU B  46      38.100  47.980  63.589  1.00 11.71           N  
ATOM   1521  CA  LEU B  46      39.120  48.086  64.629  1.00 13.64           C  
ATOM   1522  C   LEU B  46      40.306  47.138  64.455  1.00 12.80           C  
ATOM   1523  O   LEU B  46      41.400  47.405  64.959  1.00 13.57           O  
ATOM   1524  CB  LEU B  46      38.482  47.882  66.010  1.00 15.72           C  
ATOM   1525  CG  LEU B  46      37.928  46.514  66.420  1.00 17.66           C  
ATOM   1526  CD1 LEU B  46      39.041  45.670  67.033  1.00 18.31           C  
ATOM   1527  CD2 LEU B  46      36.815  46.706  67.440  1.00 19.48           C  
ATOM   1528  N   HIS B  47      40.092  46.033  63.749  1.00 12.86           N  
ATOM   1529  CA  HIS B  47      41.154  45.054  63.517  1.00 13.70           C  
ATOM   1530  C   HIS B  47      41.976  45.421  62.290  1.00 14.15           C  
ATOM   1531  O   HIS B  47      42.946  44.736  61.954  1.00 13.61           O  
ATOM   1532  CB  HIS B  47      40.565  43.657  63.290  1.00 13.27           C  
ATOM   1533  CG  HIS B  47      39.653  43.193  64.381  1.00 17.70           C  
ATOM   1534  ND1 HIS B  47      38.281  43.297  64.298  1.00 18.84           N  
ATOM   1535  CD2 HIS B  47      39.916  42.616  65.577  1.00 18.07           C  
ATOM   1536  CE1 HIS B  47      37.739  42.803  65.396  1.00 18.64           C  
ATOM   1537  NE2 HIS B  47      38.708  42.383  66.188  1.00 20.36           N  
ATOM   1538  N   HIS B  48      41.587  46.499  61.622  1.00 13.83           N  
ATOM   1539  CA  HIS B  48      42.269  46.926  60.413  1.00 12.89           C  
ATOM   1540  C   HIS B  48      42.015  45.914  59.293  1.00 12.75           C  
ATOM   1541  O   HIS B  48      42.795  45.811  58.345  1.00 12.16           O  
ATOM   1542  CB  HIS B  48      43.773  47.101  60.664  1.00 15.97           C  
ATOM   1543  CG  HIS B  48      44.114  48.362  61.393  1.00 18.55           C  
ATOM   1544  ND1 HIS B  48      44.271  49.572  60.753  1.00 20.82           N  
ATOM   1545  CD2 HIS B  48      44.269  48.613  62.714  1.00 20.82           C  
ATOM   1546  CE1 HIS B  48      44.507  50.515  61.647  1.00 21.85           C  
ATOM   1547  NE2 HIS B  48      44.511  49.960  62.846  1.00 23.24           N  
ATOM   1548  N   THR B  49      40.932  45.149  59.426  1.00 11.09           N  
ATOM   1549  CA  THR B  49      40.532  44.189  58.395  1.00  9.84           C  
ATOM   1550  C   THR B  49      39.262  44.782  57.806  1.00  8.40           C  
ATOM   1551  O   THR B  49      38.769  45.785  58.319  1.00  8.03           O  
ATOM   1552  CB  THR B  49      40.244  42.775  58.960  1.00 11.83           C  
ATOM   1553  OG1 THR B  49      39.270  42.848  60.007  1.00 12.42           O  
ATOM   1554  CG2 THR B  49      41.530  42.156  59.488  1.00 12.07           C  
HETATM 1555  N   MSE B  50      38.707  44.198  56.750  1.00  6.05           N  
HETATM 1556  CA  MSE B  50      37.523  44.832  56.180  1.00  6.56           C  
HETATM 1557  C   MSE B  50      36.256  44.718  57.023  1.00  4.83           C  
HETATM 1558  O   MSE B  50      35.879  43.644  57.495  1.00  4.98           O  
HETATM 1559  CB  MSE B  50      37.255  44.335  54.758  1.00  7.36           C  
HETATM 1560  CG  MSE B  50      36.329  45.285  53.984  1.00  6.39           C  
HETATM 1561 SE   MSE B  50      36.086  44.847  52.111  1.00 16.72          SE  
HETATM 1562  CE  MSE B  50      37.528  45.957  51.437  1.00 10.46           C  
ATOM   1563  N   PHE B  51      35.615  45.869  57.205  1.00  4.67           N  
ATOM   1564  CA  PHE B  51      34.379  45.995  57.972  1.00  5.74           C  
ATOM   1565  C   PHE B  51      33.253  45.171  57.351  1.00  6.48           C  
ATOM   1566  O   PHE B  51      33.053  45.187  56.133  1.00  4.76           O  
ATOM   1567  CB  PHE B  51      33.991  47.480  58.030  1.00  5.93           C  
ATOM   1568  CG  PHE B  51      32.643  47.746  58.638  1.00  5.46           C  
ATOM   1569  CD1 PHE B  51      32.299  47.214  59.875  1.00  6.27           C  
ATOM   1570  CD2 PHE B  51      31.731  48.560  57.981  1.00  5.69           C  
ATOM   1571  CE1 PHE B  51      31.062  47.490  60.455  1.00  5.45           C  
ATOM   1572  CE2 PHE B  51      30.484  48.849  58.548  1.00  6.34           C  
ATOM   1573  CZ  PHE B  51      30.156  48.312  59.783  1.00  5.47           C  
ATOM   1574  N   ALA B  52      32.511  44.465  58.199  1.00  6.01           N  
ATOM   1575  CA  ALA B  52      31.411  43.616  57.748  1.00  6.60           C  
ATOM   1576  C   ALA B  52      30.417  44.349  56.847  1.00  5.86           C  
ATOM   1577  O   ALA B  52      29.895  43.778  55.891  1.00  4.93           O  
ATOM   1578  CB  ALA B  52      30.683  43.024  58.957  1.00  5.91           C  
ATOM   1579  N   GLY B  53      30.162  45.614  57.154  1.00  4.58           N  
ATOM   1580  CA  GLY B  53      29.234  46.391  56.353  1.00  5.16           C  
ATOM   1581  C   GLY B  53      29.786  46.695  54.974  1.00  4.87           C  
ATOM   1582  O   GLY B  53      29.049  46.719  53.994  1.00  5.31           O  
ATOM   1583  N   SER B  54      31.089  46.941  54.893  1.00  3.91           N  
ATOM   1584  CA  SER B  54      31.707  47.231  53.611  1.00  4.10           C  
ATOM   1585  C   SER B  54      31.737  45.962  52.773  1.00  4.77           C  
ATOM   1586  O   SER B  54      31.480  46.004  51.572  1.00  4.38           O  
ATOM   1587  CB  SER B  54      33.127  47.774  53.801  1.00  6.29           C  
ATOM   1588  OG  SER B  54      33.097  49.043  54.437  1.00  5.85           O  
ATOM   1589  N   ILE B  55      32.047  44.836  53.410  1.00  4.37           N  
ATOM   1590  CA  ILE B  55      32.078  43.559  52.711  1.00  3.80           C  
ATOM   1591  C   ILE B  55      30.711  43.338  52.056  1.00  4.22           C  
ATOM   1592  O   ILE B  55      30.622  43.068  50.863  1.00  3.04           O  
ATOM   1593  CB  ILE B  55      32.388  42.397  53.694  1.00  4.66           C  
ATOM   1594  CG1 ILE B  55      33.836  42.509  54.183  1.00  6.15           C  
ATOM   1595  CG2 ILE B  55      32.160  41.049  53.010  1.00  5.72           C  
ATOM   1596  CD1 ILE B  55      34.225  41.451  55.200  1.00  7.50           C  
ATOM   1597  N   TYR B  56      29.646  43.471  52.840  1.00  4.18           N  
ATOM   1598  CA  TYR B  56      28.294  43.288  52.322  1.00  4.57           C  
ATOM   1599  C   TYR B  56      27.980  44.271  51.204  1.00  4.66           C  
ATOM   1600  O   TYR B  56      27.455  43.899  50.149  1.00  3.81           O  
ATOM   1601  CB  TYR B  56      27.256  43.482  53.426  1.00  4.76           C  
ATOM   1602  CG  TYR B  56      25.828  43.403  52.926  1.00  5.23           C  
ATOM   1603  CD1 TYR B  56      25.146  42.183  52.884  1.00  6.36           C  
ATOM   1604  CD2 TYR B  56      25.158  44.550  52.482  1.00  5.41           C  
ATOM   1605  CE1 TYR B  56      23.833  42.113  52.421  1.00  6.50           C  
ATOM   1606  CE2 TYR B  56      23.847  44.481  52.012  1.00  6.11           C  
ATOM   1607  CZ  TYR B  56      23.195  43.263  51.988  1.00  6.73           C  
ATOM   1608  OH  TYR B  56      21.893  43.193  51.553  1.00  7.81           O  
ATOM   1609  N   THR B  57      28.298  45.540  51.432  1.00  4.72           N  
ATOM   1610  CA  THR B  57      28.003  46.554  50.435  1.00  5.11           C  
ATOM   1611  C   THR B  57      28.684  46.309  49.100  1.00  4.10           C  
ATOM   1612  O   THR B  57      28.049  46.426  48.055  1.00  4.77           O  
ATOM   1613  CB  THR B  57      28.364  47.957  50.945  1.00  4.15           C  
ATOM   1614  OG1 THR B  57      27.560  48.260  52.094  1.00  5.35           O  
ATOM   1615  CG2 THR B  57      28.102  48.996  49.860  1.00  6.27           C  
ATOM   1616  N   ILE B  58      29.968  45.962  49.116  1.00  4.89           N  
ATOM   1617  CA  ILE B  58      30.639  45.722  47.847  1.00  5.15           C  
ATOM   1618  C   ILE B  58      30.036  44.506  47.144  1.00  5.36           C  
ATOM   1619  O   ILE B  58      29.907  44.495  45.922  1.00  4.56           O  
ATOM   1620  CB  ILE B  58      32.183  45.547  48.022  1.00  7.98           C  
ATOM   1621  CG1 ILE B  58      32.846  45.321  46.663  1.00 10.44           C  
ATOM   1622  CG2 ILE B  58      32.492  44.394  48.947  1.00  8.87           C  
ATOM   1623  CD1 ILE B  58      34.362  45.444  46.707  1.00 15.64           C  
HETATM 1624  N   MSE B  59      29.646  43.493  47.909  1.00  4.05           N  
HETATM 1625  CA  MSE B  59      29.058  42.308  47.299  1.00  3.53           C  
HETATM 1626  C   MSE B  59      27.686  42.620  46.713  1.00  3.82           C  
HETATM 1627  O   MSE B  59      27.373  42.182  45.614  1.00  4.92           O  
HETATM 1628  CB  MSE B  59      28.970  41.170  48.320  1.00  5.38           C  
HETATM 1629  CG  MSE B  59      30.347  40.725  48.781  1.00  7.35           C  
HETATM 1630 SE   MSE B  59      30.384  39.330  50.109  1.00 14.77          SE  
HETATM 1631  CE  MSE B  59      30.603  37.795  48.956  1.00  7.48           C  
ATOM   1632  N   THR B  60      26.872  43.387  47.427  1.00  4.08           N  
ATOM   1633  CA  THR B  60      25.565  43.707  46.887  1.00  6.44           C  
ATOM   1634  C   THR B  60      25.675  44.604  45.652  1.00  5.57           C  
ATOM   1635  O   THR B  60      24.886  44.464  44.722  1.00  7.23           O  
ATOM   1636  CB  THR B  60      24.643  44.359  47.933  1.00 10.55           C  
ATOM   1637  OG1 THR B  60      23.320  44.450  47.385  1.00 16.18           O  
ATOM   1638  CG2 THR B  60      25.137  45.744  48.302  1.00 14.65           C  
ATOM   1639  N   LEU B  61      26.650  45.515  45.623  1.00  5.58           N  
ATOM   1640  CA  LEU B  61      26.812  46.372  44.449  1.00  6.34           C  
ATOM   1641  C   LEU B  61      27.331  45.562  43.264  1.00  7.22           C  
ATOM   1642  O   LEU B  61      27.028  45.869  42.109  1.00  7.61           O  
ATOM   1643  CB  LEU B  61      27.762  47.543  44.736  1.00  7.33           C  
ATOM   1644  CG  LEU B  61      27.158  48.720  45.508  1.00 10.39           C  
ATOM   1645  CD1 LEU B  61      28.270  49.649  45.955  1.00 14.17           C  
ATOM   1646  CD2 LEU B  61      26.156  49.469  44.627  1.00 12.43           C  
ATOM   1647  N   THR B  62      28.109  44.520  43.543  1.00  6.56           N  
ATOM   1648  CA  THR B  62      28.632  43.677  42.476  1.00  6.71           C  
ATOM   1649  C   THR B  62      27.475  42.909  41.832  1.00  6.14           C  
ATOM   1650  O   THR B  62      27.395  42.810  40.609  1.00  5.01           O  
ATOM   1651  CB  THR B  62      29.712  42.705  43.012  1.00  7.10           C  
ATOM   1652  OG1 THR B  62      30.853  43.462  43.436  1.00  7.70           O  
ATOM   1653  CG2 THR B  62      30.152  41.725  41.929  1.00  8.27           C  
ATOM   1654  N   GLY B  63      26.570  42.393  42.660  1.00  6.79           N  
ATOM   1655  CA  GLY B  63      25.422  41.672  42.140  1.00  5.85           C  
ATOM   1656  C   GLY B  63      24.547  42.627  41.348  1.00  5.46           C  
ATOM   1657  O   GLY B  63      24.147  42.338  40.219  1.00  4.90           O  
ATOM   1658  N   TRP B  64      24.254  43.780  41.947  1.00  4.58           N  
ATOM   1659  CA  TRP B  64      23.440  44.804  41.302  1.00  6.70           C  
ATOM   1660  C   TRP B  64      24.087  45.170  39.964  1.00  7.14           C  
ATOM   1661  O   TRP B  64      23.410  45.259  38.934  1.00  7.19           O  
ATOM   1662  CB  TRP B  64      23.369  46.046  42.203  1.00  8.48           C  
ATOM   1663  CG  TRP B  64      22.435  47.121  41.714  1.00  9.04           C  
ATOM   1664  CD1 TRP B  64      21.129  47.297  42.069  1.00 11.13           C  
ATOM   1665  CD2 TRP B  64      22.743  48.164  40.785  1.00 11.14           C  
ATOM   1666  NE1 TRP B  64      20.603  48.391  41.417  1.00 13.17           N  
ATOM   1667  CE2 TRP B  64      21.574  48.940  40.621  1.00 12.16           C  
ATOM   1668  CE3 TRP B  64      23.896  48.519  40.070  1.00 10.17           C  
ATOM   1669  CZ2 TRP B  64      21.524  50.053  39.772  1.00 13.29           C  
ATOM   1670  CZ3 TRP B  64      23.847  49.624  39.227  1.00 11.22           C  
ATOM   1671  CH2 TRP B  64      22.666  50.378  39.085  1.00 12.84           C  
ATOM   1672  N   GLY B  65      25.404  45.369  39.991  1.00  6.68           N  
ATOM   1673  CA  GLY B  65      26.136  45.729  38.788  1.00  7.67           C  
ATOM   1674  C   GLY B  65      26.028  44.702  37.682  1.00  7.01           C  
ATOM   1675  O   GLY B  65      25.985  45.055  36.500  1.00  7.10           O  
HETATM 1676  N   MSE B  66      25.989  43.425  38.050  1.00  7.70           N  
HETATM 1677  CA  MSE B  66      25.870  42.381  37.044  1.00  6.83           C  
HETATM 1678  C   MSE B  66      24.508  42.463  36.362  1.00  6.71           C  
HETATM 1679  O   MSE B  66      24.421  42.343  35.141  1.00  5.07           O  
HETATM 1680  CB  MSE B  66      26.058  40.992  37.662  1.00  9.92           C  
HETATM 1681  CG  MSE B  66      25.875  39.856  36.656  1.00 10.73           C  
HETATM 1682 SE   MSE B  66      27.038  40.010  35.110  1.00 19.58          SE  
HETATM 1683  CE  MSE B  66      28.421  38.772  35.661  1.00 12.06           C  
ATOM   1684  N   VAL B  67      23.444  42.662  37.138  1.00  6.93           N  
ATOM   1685  CA  VAL B  67      22.120  42.758  36.533  1.00  6.59           C  
ATOM   1686  C   VAL B  67      22.087  43.967  35.612  1.00  6.88           C  
ATOM   1687  O   VAL B  67      21.562  43.902  34.498  1.00  7.43           O  
ATOM   1688  CB  VAL B  67      21.003  42.920  37.583  1.00  4.36           C  
ATOM   1689  CG1 VAL B  67      19.641  42.945  36.883  1.00  8.92           C  
ATOM   1690  CG2 VAL B  67      21.061  41.783  38.587  1.00  5.39           C  
ATOM   1691  N   TRP B  68      22.650  45.071  36.087  1.00  7.07           N  
ATOM   1692  CA  TRP B  68      22.701  46.307  35.312  1.00  7.13           C  
ATOM   1693  C   TRP B  68      23.406  46.067  33.976  1.00  6.21           C  
ATOM   1694  O   TRP B  68      22.911  46.469  32.922  1.00  7.16           O  
ATOM   1695  CB  TRP B  68      23.445  47.380  36.109  1.00  8.42           C  
ATOM   1696  CG  TRP B  68      23.479  48.726  35.462  1.00  9.91           C  
ATOM   1697  CD1 TRP B  68      22.542  49.710  35.566  1.00 10.77           C  
ATOM   1698  CD2 TRP B  68      24.522  49.247  34.631  1.00  9.41           C  
ATOM   1699  NE1 TRP B  68      22.940  50.821  34.854  1.00 11.09           N  
ATOM   1700  CE2 TRP B  68      24.151  50.562  34.271  1.00 10.34           C  
ATOM   1701  CE3 TRP B  68      25.733  48.731  34.157  1.00 10.27           C  
ATOM   1702  CZ2 TRP B  68      24.953  51.368  33.457  1.00 10.25           C  
ATOM   1703  CZ3 TRP B  68      26.530  49.532  33.347  1.00 11.86           C  
ATOM   1704  CH2 TRP B  68      26.135  50.836  33.008  1.00 11.43           C  
ATOM   1705  N   LEU B  69      24.560  45.407  34.025  1.00  6.20           N  
ATOM   1706  CA  LEU B  69      25.333  45.115  32.820  1.00  7.47           C  
ATOM   1707  C   LEU B  69      24.546  44.284  31.826  1.00  7.32           C  
ATOM   1708  O   LEU B  69      24.540  44.578  30.630  1.00  7.29           O  
ATOM   1709  CB  LEU B  69      26.623  44.375  33.183  1.00  6.49           C  
ATOM   1710  CG  LEU B  69      27.752  45.217  33.786  1.00  7.86           C  
ATOM   1711  CD1 LEU B  69      28.809  44.310  34.387  1.00  9.45           C  
ATOM   1712  CD2 LEU B  69      28.357  46.105  32.705  1.00 11.71           C  
ATOM   1713  N   GLN B  70      23.883  43.240  32.315  1.00  6.85           N  
ATOM   1714  CA  GLN B  70      23.105  42.382  31.435  1.00  8.32           C  
ATOM   1715  C   GLN B  70      21.966  43.168  30.791  1.00  9.12           C  
ATOM   1716  O   GLN B  70      21.627  42.934  29.631  1.00  9.80           O  
ATOM   1717  CB  GLN B  70      22.562  41.179  32.211  1.00  8.87           C  
ATOM   1718  CG  GLN B  70      23.642  40.213  32.708  1.00  9.60           C  
ATOM   1719  CD  GLN B  70      24.493  39.634  31.588  1.00  9.10           C  
ATOM   1720  OE1 GLN B  70      24.024  39.461  30.462  1.00  9.48           O  
ATOM   1721  NE2 GLN B  70      25.746  39.315  31.898  1.00 10.08           N  
ATOM   1722  N   GLN B  71      21.380  44.103  31.537  1.00 10.25           N  
ATOM   1723  CA  GLN B  71      20.299  44.916  30.993  1.00  9.95           C  
ATOM   1724  C   GLN B  71      20.846  45.839  29.912  1.00  9.98           C  
ATOM   1725  O   GLN B  71      20.206  46.049  28.886  1.00 10.41           O  
ATOM   1726  CB  GLN B  71      19.625  45.736  32.098  1.00  9.49           C  
ATOM   1727  CG  GLN B  71      18.895  44.873  33.109  1.00 11.00           C  
ATOM   1728  CD  GLN B  71      18.077  45.675  34.097  1.00 11.15           C  
ATOM   1729  OE1 GLN B  71      18.115  46.906  34.109  1.00 15.86           O  
ATOM   1730  NE2 GLN B  71      17.335  44.976  34.941  1.00 11.94           N  
ATOM   1731  N   GLN B  72      22.034  46.386  30.140  1.00  9.62           N  
ATOM   1732  CA  GLN B  72      22.642  47.268  29.153  1.00 10.43           C  
ATOM   1733  C   GLN B  72      22.902  46.507  27.859  1.00 10.66           C  
ATOM   1734  O   GLN B  72      22.675  47.029  26.768  1.00 11.18           O  
ATOM   1735  CB  GLN B  72      23.958  47.841  29.683  1.00 11.20           C  
ATOM   1736  CG  GLN B  72      23.799  48.781  30.864  1.00 16.60           C  
ATOM   1737  CD  GLN B  72      23.072  50.061  30.495  1.00 20.81           C  
ATOM   1738  OE1 GLN B  72      23.492  50.786  29.592  1.00 25.08           O  
ATOM   1739  NE2 GLN B  72      21.986  50.350  31.198  1.00 23.34           N  
ATOM   1740  N   LEU B  73      23.375  45.268  27.978  1.00 10.83           N  
ATOM   1741  CA  LEU B  73      23.668  44.453  26.802  1.00 12.05           C  
ATOM   1742  C   LEU B  73      22.437  44.188  25.938  1.00 14.00           C  
ATOM   1743  O   LEU B  73      22.544  44.082  24.714  1.00 14.56           O  
ATOM   1744  CB  LEU B  73      24.313  43.126  27.225  1.00 12.26           C  
ATOM   1745  CG  LEU B  73      25.734  43.241  27.794  1.00 13.11           C  
ATOM   1746  CD1 LEU B  73      26.213  41.879  28.287  1.00 13.93           C  
ATOM   1747  CD2 LEU B  73      26.667  43.783  26.721  1.00 15.05           C  
ATOM   1748  N   LEU B  74      21.272  44.088  26.573  1.00 15.15           N  
ATOM   1749  CA  LEU B  74      20.018  43.839  25.859  1.00 15.07           C  
ATOM   1750  C   LEU B  74      19.296  45.138  25.531  1.00 16.61           C  
ATOM   1751  O   LEU B  74      18.279  45.138  24.833  1.00 15.90           O  
ATOM   1752  CB  LEU B  74      19.096  42.965  26.709  1.00 16.94           C  
ATOM   1753  CG  LEU B  74      19.505  41.510  26.909  1.00 17.89           C  
ATOM   1754  CD1 LEU B  74      18.529  40.839  27.857  1.00 20.59           C  
ATOM   1755  CD2 LEU B  74      19.528  40.796  25.565  1.00 20.15           C  
ATOM   1756  N   ASN B  75      19.828  46.239  26.047  1.00 16.14           N  
ATOM   1757  CA  ASN B  75      19.252  47.558  25.841  1.00 18.96           C  
ATOM   1758  C   ASN B  75      17.845  47.610  26.429  1.00 19.56           C  
ATOM   1759  O   ASN B  75      16.905  48.076  25.784  1.00 19.50           O  
ATOM   1760  CB  ASN B  75      19.209  47.902  24.349  1.00 20.37           C  
ATOM   1761  CG  ASN B  75      18.827  49.350  24.096  1.00 23.77           C  
ATOM   1762  OD1 ASN B  75      18.647  49.765  22.948  1.00 27.67           O  
ATOM   1763  ND2 ASN B  75      18.705  50.131  25.167  1.00 25.17           N  
ATOM   1764  N   VAL B  76      17.706  47.116  27.654  1.00 19.77           N  
ATOM   1765  CA  VAL B  76      16.418  47.118  28.336  1.00 21.44           C  
ATOM   1766  C   VAL B  76      16.512  47.951  29.605  1.00 22.46           C  
ATOM   1767  O   VAL B  76      17.536  47.948  30.285  1.00 21.63           O  
ATOM   1768  CB  VAL B  76      15.966  45.685  28.707  1.00 22.69           C  
ATOM   1769  CG1 VAL B  76      15.758  44.865  27.449  1.00 24.40           C  
ATOM   1770  CG2 VAL B  76      16.994  45.021  29.608  1.00 22.55           C  
ATOM   1771  N   ASP B  77      15.443  48.675  29.916  1.00 23.72           N  
ATOM   1772  CA  ASP B  77      15.427  49.511  31.107  1.00 24.81           C  
ATOM   1773  C   ASP B  77      14.611  48.876  32.220  1.00 24.30           C  
ATOM   1774  O   ASP B  77      13.508  48.371  31.994  1.00 24.79           O  
ATOM   1775  CB  ASP B  77      14.870  50.900  30.778  1.00 28.38           C  
ATOM   1776  CG  ASP B  77      15.768  51.680  29.840  1.00 30.79           C  
ATOM   1777  OD1 ASP B  77      15.903  51.274  28.665  1.00 33.42           O  
ATOM   1778  OD2 ASP B  77      16.346  52.697  30.280  1.00 33.57           O  
ATOM   1779  N   GLY B  78      15.165  48.899  33.428  1.00 22.18           N  
ATOM   1780  CA  GLY B  78      14.476  48.326  34.569  1.00 21.14           C  
ATOM   1781  C   GLY B  78      15.140  48.730  35.869  1.00 19.41           C  
ATOM   1782  O   GLY B  78      16.369  48.746  35.961  1.00 19.53           O  
ATOM   1783  N   ASP B  79      14.331  49.071  36.869  1.00 18.37           N  
ATOM   1784  CA  ASP B  79      14.845  49.465  38.176  1.00 18.33           C  
ATOM   1785  C   ASP B  79      15.184  48.212  38.976  1.00 16.32           C  
ATOM   1786  O   ASP B  79      14.297  47.439  39.346  1.00 14.70           O  
ATOM   1787  CB  ASP B  79      13.807  50.302  38.934  1.00 21.35           C  
ATOM   1788  CG  ASP B  79      14.297  50.734  40.304  1.00 26.71           C  
ATOM   1789  OD1 ASP B  79      15.469  51.154  40.404  1.00 30.77           O  
ATOM   1790  OD2 ASP B  79      13.513  50.667  41.277  1.00 30.39           O  
ATOM   1791  N   ILE B  80      16.475  48.027  39.245  1.00 13.22           N  
ATOM   1792  CA  ILE B  80      16.976  46.866  39.981  1.00 11.79           C  
ATOM   1793  C   ILE B  80      16.965  47.098  41.488  1.00 11.02           C  
ATOM   1794  O   ILE B  80      17.570  48.050  41.979  1.00 11.89           O  
ATOM   1795  CB  ILE B  80      18.419  46.536  39.547  1.00 11.78           C  
ATOM   1796  CG1 ILE B  80      18.478  46.405  38.024  1.00 12.37           C  
ATOM   1797  CG2 ILE B  80      18.891  45.246  40.217  1.00 11.45           C  
ATOM   1798  CD1 ILE B  80      19.886  46.355  37.454  1.00 14.40           C  
ATOM   1799  N   VAL B  81      16.287  46.222  42.222  1.00  8.53           N  
ATOM   1800  CA  VAL B  81      16.205  46.364  43.669  1.00 10.81           C  
ATOM   1801  C   VAL B  81      16.487  45.037  44.367  1.00 10.94           C  
ATOM   1802  O   VAL B  81      15.944  44.000  43.985  1.00 12.64           O  
ATOM   1803  CB  VAL B  81      14.801  46.861  44.090  1.00 13.16           C  
ATOM   1804  CG1 VAL B  81      14.763  47.118  45.586  1.00 14.24           C  
ATOM   1805  CG2 VAL B  81      14.449  48.126  43.321  1.00 15.11           C  
ATOM   1806  N   LEU B  82      17.342  45.062  45.382  1.00  9.11           N  
ATOM   1807  CA  LEU B  82      17.643  43.840  46.118  1.00  7.38           C  
ATOM   1808  C   LEU B  82      16.473  43.557  47.055  1.00  8.13           C  
ATOM   1809  O   LEU B  82      16.094  44.405  47.868  1.00  8.00           O  
ATOM   1810  CB  LEU B  82      18.937  44.003  46.920  1.00  7.45           C  
ATOM   1811  CG  LEU B  82      19.377  42.827  47.802  1.00  6.38           C  
ATOM   1812  CD1 LEU B  82      19.670  41.589  46.956  1.00  7.01           C  
ATOM   1813  CD2 LEU B  82      20.620  43.241  48.574  1.00  7.96           C  
ATOM   1814  N   ALA B  83      15.894  42.367  46.936  1.00  7.00           N  
ATOM   1815  CA  ALA B  83      14.757  41.986  47.766  1.00  7.85           C  
ATOM   1816  C   ALA B  83      15.181  41.287  49.049  1.00  7.76           C  
ATOM   1817  O   ALA B  83      14.670  41.587  50.124  1.00  9.30           O  
ATOM   1818  CB  ALA B  83      13.821  41.085  46.971  1.00 10.79           C  
ATOM   1819  N   ASP B  84      16.100  40.340  48.933  1.00  8.17           N  
ATOM   1820  CA  ASP B  84      16.572  39.621  50.105  1.00 10.19           C  
ATOM   1821  C   ASP B  84      17.965  39.088  49.852  1.00  9.97           C  
ATOM   1822  O   ASP B  84      18.345  38.803  48.714  1.00  8.26           O  
ATOM   1823  CB  ASP B  84      15.627  38.469  50.453  1.00 15.84           C  
ATOM   1824  CG  ASP B  84      15.448  37.496  49.314  1.00 22.24           C  
ATOM   1825  OD1 ASP B  84      14.830  37.876  48.294  1.00 28.11           O  
ATOM   1826  OD2 ASP B  84      15.927  36.346  49.433  1.00 28.67           O  
ATOM   1827  N   ALA B  85      18.734  38.956  50.920  1.00  7.18           N  
ATOM   1828  CA  ALA B  85      20.085  38.469  50.778  1.00  7.15           C  
ATOM   1829  C   ALA B  85      20.560  37.763  52.027  1.00  8.74           C  
ATOM   1830  O   ALA B  85      20.086  38.026  53.131  1.00  9.26           O  
ATOM   1831  CB  ALA B  85      21.016  39.624  50.445  1.00  7.16           C  
ATOM   1832  N   HIS B  86      21.497  36.849  51.826  1.00  7.71           N  
ATOM   1833  CA  HIS B  86      22.095  36.094  52.909  1.00  9.24           C  
ATOM   1834  C   HIS B  86      23.600  36.204  52.730  1.00  8.27           C  
ATOM   1835  O   HIS B  86      24.111  36.038  51.623  1.00  8.57           O  
ATOM   1836  CB  HIS B  86      21.663  34.632  52.835  1.00 14.17           C  
ATOM   1837  CG  HIS B  86      22.317  33.762  53.860  1.00 20.47           C  
ATOM   1838  ND1 HIS B  86      22.329  34.077  55.201  1.00 23.34           N  
ATOM   1839  CD2 HIS B  86      22.979  32.587  53.743  1.00 24.50           C  
ATOM   1840  CE1 HIS B  86      22.972  33.135  55.867  1.00 24.30           C  
ATOM   1841  NE2 HIS B  86      23.377  32.219  55.005  1.00 26.33           N  
ATOM   1842  N   ILE B  87      24.314  36.492  53.811  1.00  8.13           N  
ATOM   1843  CA  ILE B  87      25.767  36.611  53.726  1.00  6.51           C  
ATOM   1844  C   ILE B  87      26.433  35.844  54.859  1.00  8.11           C  
ATOM   1845  O   ILE B  87      25.954  35.849  55.992  1.00  7.52           O  
ATOM   1846  CB  ILE B  87      26.216  38.103  53.766  1.00  5.14           C  
ATOM   1847  CG1 ILE B  87      27.739  38.202  53.618  1.00  7.26           C  
ATOM   1848  CG2 ILE B  87      25.765  38.751  55.069  1.00  6.59           C  
ATOM   1849  CD1 ILE B  87      28.251  39.617  53.351  1.00  7.01           C  
ATOM   1850  N   ARG B  88      27.525  35.157  54.537  1.00  6.98           N  
ATOM   1851  CA  ARG B  88      28.278  34.407  55.530  1.00  8.68           C  
ATOM   1852  C   ARG B  88      29.709  34.918  55.492  1.00  8.35           C  
ATOM   1853  O   ARG B  88      30.303  35.041  54.423  1.00  9.06           O  
ATOM   1854  CB  ARG B  88      28.262  32.907  55.217  1.00 11.15           C  
ATOM   1855  CG  ARG B  88      26.869  32.318  55.067  1.00 16.53           C  
ATOM   1856  CD  ARG B  88      26.916  30.799  54.939  1.00 20.28           C  
ATOM   1857  NE  ARG B  88      27.244  30.163  56.210  1.00 24.35           N  
ATOM   1858  CZ  ARG B  88      26.394  30.041  57.226  1.00 25.93           C  
ATOM   1859  NH1 ARG B  88      26.784  29.451  58.351  1.00 25.54           N  
ATOM   1860  NH2 ARG B  88      25.149  30.490  57.113  1.00 24.31           N  
ATOM   1861  N   TYR B  89      30.251  35.234  56.662  1.00  8.05           N  
ATOM   1862  CA  TYR B  89      31.619  35.717  56.756  1.00  7.53           C  
ATOM   1863  C   TYR B  89      32.487  34.542  57.195  1.00  8.82           C  
ATOM   1864  O   TYR B  89      32.340  34.032  58.304  1.00 10.73           O  
ATOM   1865  CB  TYR B  89      31.707  36.862  57.766  1.00  7.11           C  
ATOM   1866  CG  TYR B  89      30.848  38.059  57.411  1.00  7.26           C  
ATOM   1867  CD1 TYR B  89      29.511  38.129  57.805  1.00  7.32           C  
ATOM   1868  CD2 TYR B  89      31.381  39.131  56.701  1.00  7.60           C  
ATOM   1869  CE1 TYR B  89      28.728  39.248  57.504  1.00  6.86           C  
ATOM   1870  CE2 TYR B  89      30.612  40.244  56.390  1.00  7.27           C  
ATOM   1871  CZ  TYR B  89      29.294  40.301  56.794  1.00  6.57           C  
ATOM   1872  OH  TYR B  89      28.545  41.411  56.499  1.00  7.46           O  
ATOM   1873  N   LEU B  90      33.391  34.122  56.314  1.00 10.61           N  
ATOM   1874  CA  LEU B  90      34.259  32.978  56.575  1.00  9.75           C  
ATOM   1875  C   LEU B  90      35.604  33.307  57.207  1.00 12.02           C  
ATOM   1876  O   LEU B  90      36.065  32.596  58.101  1.00 15.70           O  
ATOM   1877  CB  LEU B  90      34.504  32.216  55.273  1.00  9.96           C  
ATOM   1878  CG  LEU B  90      33.265  31.776  54.489  1.00 14.14           C  
ATOM   1879  CD1 LEU B  90      33.705  31.070  53.212  1.00 16.61           C  
ATOM   1880  CD2 LEU B  90      32.412  30.861  55.341  1.00 16.94           C  
ATOM   1881  N   ALA B  91      36.243  34.370  56.735  1.00 10.62           N  
ATOM   1882  CA  ALA B  91      37.544  34.754  57.265  1.00 12.52           C  
ATOM   1883  C   ALA B  91      37.783  36.244  57.091  1.00 12.43           C  
ATOM   1884  O   ALA B  91      37.195  36.880  56.213  1.00 11.77           O  
ATOM   1885  CB  ALA B  91      38.644  33.960  56.561  1.00 13.12           C  
ATOM   1886  N   PRO B  92      38.653  36.828  57.929  1.00 12.12           N  
ATOM   1887  CA  PRO B  92      38.929  38.261  57.810  1.00 12.39           C  
ATOM   1888  C   PRO B  92      39.551  38.613  56.459  1.00 12.30           C  
ATOM   1889  O   PRO B  92      40.292  37.814  55.875  1.00 12.02           O  
ATOM   1890  CB  PRO B  92      39.889  38.527  58.973  1.00 13.47           C  
ATOM   1891  CG  PRO B  92      39.475  37.506  59.992  1.00 14.07           C  
ATOM   1892  CD  PRO B  92      39.288  36.270  59.136  1.00 14.15           C  
ATOM   1893  N   VAL B  93      39.229  39.806  55.969  1.00 10.35           N  
ATOM   1894  CA  VAL B  93      39.745  40.312  54.702  1.00  9.39           C  
ATOM   1895  C   VAL B  93      40.880  41.270  55.042  1.00 10.07           C  
ATOM   1896  O   VAL B  93      40.654  42.330  55.622  1.00 10.24           O  
ATOM   1897  CB  VAL B  93      38.653  41.073  53.918  1.00 10.26           C  
ATOM   1898  CG1 VAL B  93      39.229  41.637  52.633  1.00 10.73           C  
ATOM   1899  CG2 VAL B  93      37.486  40.145  53.621  1.00 12.94           C  
ATOM   1900  N   THR B  94      42.098  40.898  54.661  1.00 10.82           N  
ATOM   1901  CA  THR B  94      43.280  41.693  54.978  1.00 11.22           C  
ATOM   1902  C   THR B  94      43.856  42.618  53.909  1.00 12.06           C  
ATOM   1903  O   THR B  94      44.875  43.275  54.135  1.00 14.24           O  
ATOM   1904  CB  THR B  94      44.397  40.774  55.486  1.00 10.89           C  
ATOM   1905  OG1 THR B  94      44.638  39.741  54.523  1.00 12.30           O  
ATOM   1906  CG2 THR B  94      43.991  40.148  56.807  1.00 11.46           C  
ATOM   1907  N   SER B  95      43.226  42.671  52.743  1.00 10.93           N  
ATOM   1908  CA  SER B  95      43.683  43.564  51.686  1.00 10.59           C  
ATOM   1909  C   SER B  95      42.569  43.711  50.666  1.00  9.93           C  
ATOM   1910  O   SER B  95      41.502  43.120  50.823  1.00 10.38           O  
ATOM   1911  CB  SER B  95      44.967  43.036  51.019  1.00 12.84           C  
ATOM   1912  OG  SER B  95      44.773  41.775  50.402  1.00 12.71           O  
ATOM   1913  N   ALA B  96      42.812  44.513  49.637  1.00  8.57           N  
ATOM   1914  CA  ALA B  96      41.814  44.737  48.589  1.00 11.27           C  
ATOM   1915  C   ALA B  96      41.367  43.380  48.050  1.00 11.74           C  
ATOM   1916  O   ALA B  96      42.163  42.640  47.479  1.00 11.61           O  
ATOM   1917  CB  ALA B  96      42.415  45.580  47.482  1.00  9.62           C  
ATOM   1918  N   PRO B  97      40.079  43.041  48.221  1.00 10.83           N  
ATOM   1919  CA  PRO B  97      39.559  41.755  47.752  1.00 10.46           C  
ATOM   1920  C   PRO B  97      39.089  41.699  46.307  1.00 10.18           C  
ATOM   1921  O   PRO B  97      38.973  42.719  45.625  1.00 10.17           O  
ATOM   1922  CB  PRO B  97      38.410  41.495  48.712  1.00 10.59           C  
ATOM   1923  CG  PRO B  97      37.828  42.873  48.861  1.00 10.86           C  
ATOM   1924  CD  PRO B  97      39.063  43.762  49.016  1.00 11.16           C  
ATOM   1925  N   GLU B  98      38.839  40.481  45.843  1.00 10.35           N  
ATOM   1926  CA  GLU B  98      38.315  40.269  44.505  1.00 11.18           C  
ATOM   1927  C   GLU B  98      36.909  39.742  44.727  1.00  9.21           C  
ATOM   1928  O   GLU B  98      36.720  38.664  45.290  1.00 10.14           O  
ATOM   1929  CB  GLU B  98      39.156  39.253  43.735  1.00 14.45           C  
ATOM   1930  CG  GLU B  98      40.478  39.816  43.258  1.00 19.21           C  
ATOM   1931  CD  GLU B  98      41.250  38.830  42.418  1.00 22.97           C  
ATOM   1932  OE1 GLU B  98      41.701  37.805  42.970  1.00 27.08           O  
ATOM   1933  OE2 GLU B  98      41.396  39.077  41.202  1.00 26.40           O  
ATOM   1934  N   VAL B  99      35.927  40.535  44.314  1.00  7.71           N  
ATOM   1935  CA  VAL B  99      34.528  40.166  44.467  1.00  6.55           C  
ATOM   1936  C   VAL B  99      34.037  39.756  43.092  1.00  7.72           C  
ATOM   1937  O   VAL B  99      34.049  40.551  42.145  1.00  8.66           O  
ATOM   1938  CB  VAL B  99      33.693  41.345  44.988  1.00  6.65           C  
ATOM   1939  CG1 VAL B  99      32.295  40.871  45.339  1.00  5.03           C  
ATOM   1940  CG2 VAL B  99      34.373  41.954  46.196  1.00  9.10           C  
ATOM   1941  N   LYS B 100      33.601  38.506  42.993  1.00  7.25           N  
ATOM   1942  CA  LYS B 100      33.167  37.954  41.723  1.00  7.05           C  
ATOM   1943  C   LYS B 100      31.745  37.419  41.667  1.00  7.90           C  
ATOM   1944  O   LYS B 100      31.224  36.884  42.643  1.00  7.34           O  
ATOM   1945  CB  LYS B 100      34.122  36.826  41.325  1.00  8.09           C  
ATOM   1946  CG  LYS B 100      35.591  37.216  41.356  1.00 11.57           C  
ATOM   1947  CD  LYS B 100      36.482  36.016  41.039  1.00 15.89           C  
ATOM   1948  CE  LYS B 100      37.959  36.387  41.081  1.00 19.70           C  
ATOM   1949  NZ  LYS B 100      38.840  35.226  40.750  1.00 23.91           N  
ATOM   1950  N   VAL B 101      31.130  37.573  40.499  1.00  6.91           N  
ATOM   1951  CA  VAL B 101      29.788  37.061  40.253  1.00  8.27           C  
ATOM   1952  C   VAL B 101      29.743  36.570  38.807  1.00  8.02           C  
ATOM   1953  O   VAL B 101      30.272  37.220  37.899  1.00  7.50           O  
ATOM   1954  CB  VAL B 101      28.689  38.141  40.491  1.00  7.04           C  
ATOM   1955  CG1 VAL B 101      28.870  39.313  39.538  1.00  6.76           C  
ATOM   1956  CG2 VAL B 101      27.308  37.518  40.326  1.00  9.58           C  
ATOM   1957  N   ARG B 102      29.144  35.399  38.610  1.00  8.66           N  
ATOM   1958  CA  ARG B 102      29.019  34.801  37.285  1.00 10.13           C  
ATOM   1959  C   ARG B 102      27.549  34.775  36.897  1.00  9.17           C  
ATOM   1960  O   ARG B 102      26.699  34.372  37.685  1.00 11.97           O  
ATOM   1961  CB  ARG B 102      29.585  33.375  37.281  1.00 10.97           C  
ATOM   1962  CG  ARG B 102      29.505  32.687  35.914  1.00 16.25           C  
ATOM   1963  CD  ARG B 102      30.293  31.377  35.877  1.00 19.72           C  
ATOM   1964  NE  ARG B 102      31.733  31.584  36.016  1.00 22.91           N  
ATOM   1965  CZ  ARG B 102      32.504  32.168  35.103  1.00 26.12           C  
ATOM   1966  NH1 ARG B 102      31.982  32.610  33.966  1.00 27.67           N  
ATOM   1967  NH2 ARG B 102      33.804  32.307  35.327  1.00 28.14           N  
ATOM   1968  N   TRP B 103      27.254  35.211  35.678  1.00  9.75           N  
ATOM   1969  CA  TRP B 103      25.886  35.251  35.187  1.00 10.30           C  
ATOM   1970  C   TRP B 103      25.314  33.843  34.989  1.00 10.81           C  
ATOM   1971  O   TRP B 103      25.910  33.016  34.298  1.00 12.33           O  
ATOM   1972  CB  TRP B 103      25.847  36.025  33.865  1.00 10.85           C  
ATOM   1973  CG  TRP B 103      24.472  36.272  33.342  1.00 10.28           C  
ATOM   1974  CD1 TRP B 103      23.960  35.847  32.145  1.00  8.93           C  
ATOM   1975  CD2 TRP B 103      23.430  37.016  33.983  1.00 10.41           C  
ATOM   1976  NE1 TRP B 103      22.667  36.281  32.002  1.00  9.25           N  
ATOM   1977  CE2 TRP B 103      22.313  37.000  33.116  1.00  9.14           C  
ATOM   1978  CE3 TRP B 103      23.330  37.695  35.205  1.00  9.24           C  
ATOM   1979  CZ2 TRP B 103      21.109  37.638  33.433  1.00  9.61           C  
ATOM   1980  CZ3 TRP B 103      22.131  38.331  35.520  1.00  9.48           C  
ATOM   1981  CH2 TRP B 103      21.035  38.297  34.635  1.00  8.39           C  
ATOM   1982  N   PRO B 104      24.155  33.552  35.605  1.00 11.23           N  
ATOM   1983  CA  PRO B 104      23.501  32.244  35.498  1.00 12.22           C  
ATOM   1984  C   PRO B 104      22.571  32.114  34.289  1.00 10.84           C  
ATOM   1985  O   PRO B 104      21.718  31.229  34.249  1.00 10.41           O  
ATOM   1986  CB  PRO B 104      22.748  32.138  36.817  1.00 11.22           C  
ATOM   1987  CG  PRO B 104      22.293  33.549  37.024  1.00 12.90           C  
ATOM   1988  CD  PRO B 104      23.533  34.357  36.674  1.00  9.30           C  
ATOM   1989  N   ASP B 105      22.741  33.001  33.312  1.00 10.31           N  
ATOM   1990  CA  ASP B 105      21.925  32.996  32.097  1.00 12.39           C  
ATOM   1991  C   ASP B 105      20.432  33.137  32.378  1.00 12.98           C  
ATOM   1992  O   ASP B 105      19.608  32.429  31.794  1.00 12.78           O  
ATOM   1993  CB  ASP B 105      22.148  31.716  31.288  1.00 15.18           C  
ATOM   1994  CG  ASP B 105      23.570  31.568  30.801  1.00 17.96           C  
ATOM   1995  OD1 ASP B 105      24.254  32.597  30.608  1.00 20.27           O  
ATOM   1996  OD2 ASP B 105      23.999  30.413  30.594  1.00 18.77           O  
ATOM   1997  N   THR B 106      20.089  34.062  33.265  1.00 12.92           N  
ATOM   1998  CA  THR B 106      18.702  34.304  33.628  1.00 13.87           C  
ATOM   1999  C   THR B 106      17.940  34.894  32.449  1.00 13.68           C  
ATOM   2000  O   THR B 106      18.474  35.706  31.694  1.00 13.12           O  
ATOM   2001  CB  THR B 106      18.618  35.279  34.809  1.00 16.28           C  
ATOM   2002  OG1 THR B 106      19.539  34.865  35.822  1.00 17.55           O  
ATOM   2003  CG2 THR B 106      17.209  35.300  35.390  1.00 16.86           C  
ATOM   2004  N   ASN B 107      16.690  34.478  32.293  1.00 14.55           N  
ATOM   2005  CA  ASN B 107      15.855  34.975  31.208  1.00 15.84           C  
ATOM   2006  C   ASN B 107      15.330  36.350  31.596  1.00 15.56           C  
ATOM   2007  O   ASN B 107      14.564  36.481  32.550  1.00 15.11           O  
ATOM   2008  CB  ASN B 107      14.689  34.015  30.970  1.00 18.83           C  
ATOM   2009  CG  ASN B 107      13.869  34.378  29.749  1.00 20.95           C  
ATOM   2010  OD1 ASN B 107      12.937  33.662  29.383  1.00 26.66           O  
ATOM   2011  ND2 ASN B 107      14.208  35.491  29.109  1.00 20.44           N  
ATOM   2012  N   LEU B 108      15.749  37.376  30.863  1.00 14.79           N  
ATOM   2013  CA  LEU B 108      15.309  38.733  31.153  1.00 14.63           C  
ATOM   2014  C   LEU B 108      14.207  39.177  30.199  1.00 16.40           C  
ATOM   2015  O   LEU B 108      13.785  40.330  30.234  1.00 15.24           O  
ATOM   2016  CB  LEU B 108      16.487  39.705  31.064  1.00 15.04           C  
ATOM   2017  CG  LEU B 108      17.658  39.420  32.009  1.00 14.69           C  
ATOM   2018  CD1 LEU B 108      18.765  40.431  31.763  1.00 14.28           C  
ATOM   2019  CD2 LEU B 108      17.180  39.486  33.456  1.00 14.03           C  
ATOM   2020  N   SER B 109      13.732  38.257  29.362  1.00 17.49           N  
ATOM   2021  CA  SER B 109      12.678  38.581  28.401  1.00 19.19           C  
ATOM   2022  C   SER B 109      11.447  39.241  29.032  1.00 19.15           C  
ATOM   2023  O   SER B 109      10.835  40.117  28.422  1.00 18.69           O  
ATOM   2024  CB  SER B 109      12.259  37.330  27.611  1.00 18.18           C  
ATOM   2025  OG  SER B 109      11.739  36.315  28.450  1.00 24.09           O  
ATOM   2026  N   PRO B 110      11.063  38.832  30.256  1.00 19.97           N  
ATOM   2027  CA  PRO B 110       9.892  39.447  30.891  1.00 20.26           C  
ATOM   2028  C   PRO B 110       9.972  40.974  30.917  1.00 20.52           C  
ATOM   2029  O   PRO B 110       8.965  41.658  30.747  1.00 19.43           O  
ATOM   2030  CB  PRO B 110       9.907  38.839  32.290  1.00 21.97           C  
ATOM   2031  CG  PRO B 110      10.416  37.462  32.029  1.00 21.20           C  
ATOM   2032  CD  PRO B 110      11.567  37.713  31.075  1.00 20.82           C  
ATOM   2033  N   LEU B 111      11.173  41.502  31.130  1.00 20.71           N  
ATOM   2034  CA  LEU B 111      11.367  42.948  31.165  1.00 21.73           C  
ATOM   2035  C   LEU B 111      10.968  43.568  29.833  1.00 23.33           C  
ATOM   2036  O   LEU B 111      10.413  44.666  29.790  1.00 23.13           O  
ATOM   2037  CB  LEU B 111      12.828  43.284  31.459  1.00 21.13           C  
ATOM   2038  CG  LEU B 111      13.346  42.923  32.848  1.00 20.63           C  
ATOM   2039  CD1 LEU B 111      14.813  43.307  32.942  1.00 20.11           C  
ATOM   2040  CD2 LEU B 111      12.529  43.649  33.911  1.00 21.11           C  
ATOM   2041  N   GLN B 112      11.258  42.854  28.751  1.00 25.41           N  
ATOM   2042  CA  GLN B 112      10.943  43.315  27.404  1.00 27.36           C  
ATOM   2043  C   GLN B 112       9.455  43.121  27.118  1.00 28.03           C  
ATOM   2044  O   GLN B 112       8.971  43.453  26.036  1.00 29.38           O  
ATOM   2045  CB  GLN B 112      11.778  42.536  26.382  1.00 28.58           C  
ATOM   2046  CG  GLN B 112      13.284  42.602  26.632  1.00 29.02           C  
ATOM   2047  CD  GLN B 112      14.072  41.630  25.768  1.00 30.19           C  
ATOM   2048  OE1 GLN B 112      13.877  40.416  25.845  1.00 30.31           O  
ATOM   2049  NE2 GLN B 112      14.972  42.160  24.945  1.00 28.29           N  
ATOM   2050  N   ARG B 113       8.740  42.580  28.102  1.00 28.19           N  
ATOM   2051  CA  ARG B 113       7.308  42.326  27.988  1.00 28.83           C  
ATOM   2052  C   ARG B 113       6.546  43.278  28.904  1.00 28.54           C  
ATOM   2053  O   ARG B 113       5.317  43.311  28.896  1.00 29.35           O  
ATOM   2054  CB  ARG B 113       6.994  40.887  28.407  1.00 28.91           C  
ATOM   2055  CG  ARG B 113       6.208  40.075  27.393  1.00 31.02           C  
ATOM   2056  CD  ARG B 113       7.136  39.254  26.510  1.00 30.29           C  
ATOM   2057  NE  ARG B 113       8.016  38.395  27.299  1.00 32.12           N  
ATOM   2058  CZ  ARG B 113       7.598  37.449  28.134  1.00 31.79           C  
ATOM   2059  NH1 ARG B 113       8.479  36.722  28.809  1.00 31.26           N  
ATOM   2060  NH2 ARG B 113       6.301  37.225  28.294  1.00 33.24           N  
ATOM   2061  N   GLY B 114       7.285  44.045  29.699  1.00 28.49           N  
ATOM   2062  CA  GLY B 114       6.658  44.972  30.623  1.00 28.38           C  
ATOM   2063  C   GLY B 114       6.343  44.285  31.938  1.00 28.34           C  
ATOM   2064  O   GLY B 114       5.467  44.720  32.685  1.00 28.92           O  
ATOM   2065  N   ARG B 115       7.061  43.200  32.219  1.00 26.52           N  
ATOM   2066  CA  ARG B 115       6.864  42.437  33.445  1.00 24.29           C  
ATOM   2067  C   ARG B 115       8.138  42.490  34.286  1.00 22.31           C  
ATOM   2068  O   ARG B 115       9.237  42.606  33.747  1.00 19.17           O  
ATOM   2069  CB  ARG B 115       6.568  40.970  33.123  1.00 27.27           C  
ATOM   2070  CG  ARG B 115       5.625  40.721  31.957  1.00 29.43           C  
ATOM   2071  CD  ARG B 115       4.176  41.035  32.291  1.00 32.25           C  
ATOM   2072  NE  ARG B 115       3.272  40.163  31.543  1.00 34.59           N  
ATOM   2073  CZ  ARG B 115       3.218  40.089  30.215  1.00 34.73           C  
ATOM   2074  NH1 ARG B 115       2.366  39.258  29.634  1.00 35.64           N  
ATOM   2075  NH2 ARG B 115       4.005  40.851  29.467  1.00 36.99           N  
ATOM   2076  N   LYS B 116       7.988  42.397  35.603  1.00 20.84           N  
ATOM   2077  CA  LYS B 116       9.143  42.407  36.492  1.00 21.17           C  
ATOM   2078  C   LYS B 116       9.894  41.093  36.293  1.00 19.14           C  
ATOM   2079  O   LYS B 116       9.294  40.080  35.925  1.00 19.39           O  
ATOM   2080  CB  LYS B 116       8.695  42.536  37.953  1.00 23.50           C  
ATOM   2081  CG  LYS B 116       7.780  41.414  38.422  1.00 27.69           C  
ATOM   2082  CD  LYS B 116       7.427  41.526  39.908  1.00 30.56           C  
ATOM   2083  CE  LYS B 116       6.487  42.691  40.202  1.00 32.02           C  
ATOM   2084  NZ  LYS B 116       7.133  44.024  40.049  1.00 34.52           N  
ATOM   2085  N   ALA B 117      11.203  41.112  36.529  1.00 16.23           N  
ATOM   2086  CA  ALA B 117      12.030  39.916  36.379  1.00 15.23           C  
ATOM   2087  C   ALA B 117      12.827  39.669  37.658  1.00 14.77           C  
ATOM   2088  O   ALA B 117      13.352  40.607  38.254  1.00 14.56           O  
ATOM   2089  CB  ALA B 117      12.978  40.077  35.195  1.00 16.03           C  
ATOM   2090  N   LYS B 118      12.912  38.407  38.068  1.00 13.43           N  
ATOM   2091  CA  LYS B 118      13.644  38.029  39.274  1.00 14.54           C  
ATOM   2092  C   LYS B 118      14.993  37.424  38.899  1.00 13.70           C  
ATOM   2093  O   LYS B 118      15.074  36.576  38.012  1.00 14.18           O  
ATOM   2094  CB  LYS B 118      12.835  37.016  40.089  1.00 16.22           C  
ATOM   2095  CG  LYS B 118      11.519  37.563  40.624  1.00 21.42           C  
ATOM   2096  CD  LYS B 118      10.666  36.459  41.232  1.00 25.40           C  
ATOM   2097  CE  LYS B 118       9.315  36.992  41.680  1.00 27.60           C  
ATOM   2098  NZ  LYS B 118       8.398  35.899  42.116  1.00 28.70           N  
ATOM   2099  N   VAL B 119      16.049  37.859  39.579  1.00 13.09           N  
ATOM   2100  CA  VAL B 119      17.389  37.359  39.300  1.00 12.06           C  
ATOM   2101  C   VAL B 119      18.097  36.936  40.583  1.00 11.80           C  
ATOM   2102  O   VAL B 119      18.353  37.763  41.458  1.00 11.93           O  
ATOM   2103  CB  VAL B 119      18.256  38.436  38.612  1.00 12.00           C  
ATOM   2104  CG1 VAL B 119      19.603  37.846  38.221  1.00 13.47           C  
ATOM   2105  CG2 VAL B 119      17.536  38.984  37.390  1.00 12.93           C  
ATOM   2106  N   LYS B 120      18.401  35.649  40.695  1.00 11.62           N  
ATOM   2107  CA  LYS B 120      19.095  35.142  41.872  1.00 12.24           C  
ATOM   2108  C   LYS B 120      20.579  35.067  41.528  1.00 11.42           C  
ATOM   2109  O   LYS B 120      20.969  34.358  40.601  1.00 12.44           O  
ATOM   2110  CB  LYS B 120      18.582  33.747  42.244  1.00 17.22           C  
ATOM   2111  CG  LYS B 120      18.548  33.502  43.747  1.00 20.16           C  
ATOM   2112  CD  LYS B 120      18.671  32.024  44.109  1.00 22.63           C  
ATOM   2113  CE  LYS B 120      17.572  31.177  43.493  1.00 22.46           C  
ATOM   2114  NZ  LYS B 120      17.707  29.742  43.892  1.00 19.96           N  
ATOM   2115  N   LEU B 121      21.404  35.803  42.268  1.00  7.37           N  
ATOM   2116  CA  LEU B 121      22.835  35.804  42.016  1.00  6.10           C  
ATOM   2117  C   LEU B 121      23.657  35.378  43.219  1.00  6.27           C  
ATOM   2118  O   LEU B 121      23.265  35.576  44.370  1.00  8.87           O  
ATOM   2119  CB  LEU B 121      23.306  37.196  41.582  1.00  7.15           C  
ATOM   2120  CG  LEU B 121      22.761  37.768  40.277  1.00  6.31           C  
ATOM   2121  CD1 LEU B 121      23.355  39.152  40.039  1.00  6.22           C  
ATOM   2122  CD2 LEU B 121      23.121  36.839  39.127  1.00  6.01           C  
ATOM   2123  N   GLU B 122      24.810  34.794  42.932  1.00  5.10           N  
ATOM   2124  CA  GLU B 122      25.727  34.362  43.971  1.00  6.56           C  
ATOM   2125  C   GLU B 122      26.991  35.186  43.806  1.00  6.86           C  
ATOM   2126  O   GLU B 122      27.565  35.231  42.721  1.00  7.86           O  
ATOM   2127  CB  GLU B 122      26.059  32.886  43.804  1.00  7.46           C  
ATOM   2128  CG  GLU B 122      26.985  32.347  44.864  1.00  9.77           C  
ATOM   2129  CD  GLU B 122      27.214  30.862  44.709  1.00 11.78           C  
ATOM   2130  OE1 GLU B 122      27.921  30.469  43.758  1.00 10.52           O  
ATOM   2131  OE2 GLU B 122      26.670  30.094  45.528  1.00 11.00           O  
ATOM   2132  N   VAL B 123      27.420  35.842  44.877  1.00  6.08           N  
ATOM   2133  CA  VAL B 123      28.626  36.651  44.826  1.00  6.00           C  
ATOM   2134  C   VAL B 123      29.624  36.072  45.816  1.00  6.63           C  
ATOM   2135  O   VAL B 123      29.248  35.687  46.922  1.00  6.90           O  
ATOM   2136  CB  VAL B 123      28.336  38.121  45.207  1.00  6.25           C  
ATOM   2137  CG1 VAL B 123      29.609  38.946  45.089  1.00  6.60           C  
ATOM   2138  CG2 VAL B 123      27.246  38.694  44.311  1.00  6.64           C  
ATOM   2139  N   GLN B 124      30.890  35.988  45.415  1.00  6.69           N  
ATOM   2140  CA  GLN B 124      31.924  35.461  46.300  1.00  6.44           C  
ATOM   2141  C   GLN B 124      33.033  36.484  46.465  1.00  6.02           C  
ATOM   2142  O   GLN B 124      33.377  37.189  45.522  1.00  7.08           O  
ATOM   2143  CB  GLN B 124      32.514  34.168  45.737  1.00  9.68           C  
ATOM   2144  CG  GLN B 124      31.530  33.021  45.657  1.00 12.62           C  
ATOM   2145  CD  GLN B 124      32.216  31.712  45.334  1.00 14.89           C  
ATOM   2146  OE1 GLN B 124      32.896  31.589  44.316  1.00 17.71           O  
ATOM   2147  NE2 GLN B 124      32.038  30.725  46.199  1.00 17.60           N  
ATOM   2148  N   LEU B 125      33.593  36.566  47.667  1.00  5.94           N  
ATOM   2149  CA  LEU B 125      34.670  37.508  47.926  1.00  5.78           C  
ATOM   2150  C   LEU B 125      35.935  36.751  48.303  1.00  6.80           C  
ATOM   2151  O   LEU B 125      35.932  35.929  49.222  1.00  8.19           O  
ATOM   2152  CB  LEU B 125      34.262  38.477  49.042  1.00  6.21           C  
ATOM   2153  CG  LEU B 125      35.246  39.598  49.400  1.00  6.54           C  
ATOM   2154  CD1 LEU B 125      34.473  40.808  49.918  1.00  8.89           C  
ATOM   2155  CD2 LEU B 125      36.246  39.106  50.434  1.00  8.28           C  
ATOM   2156  N   PHE B 126      37.008  37.026  47.572  1.00  9.20           N  
ATOM   2157  CA  PHE B 126      38.293  36.381  47.808  1.00 10.52           C  
ATOM   2158  C   PHE B 126      39.357  37.399  48.199  1.00 11.13           C  
ATOM   2159  O   PHE B 126      39.299  38.559  47.793  1.00 11.43           O  
ATOM   2160  CB  PHE B 126      38.774  35.659  46.545  1.00 10.36           C  
ATOM   2161  CG  PHE B 126      37.812  34.631  46.022  1.00 12.74           C  
ATOM   2162  CD1 PHE B 126      36.749  35.002  45.203  1.00 13.72           C  
ATOM   2163  CD2 PHE B 126      37.966  33.288  46.354  1.00 13.95           C  
ATOM   2164  CE1 PHE B 126      35.853  34.051  44.726  1.00 15.52           C  
ATOM   2165  CE2 PHE B 126      37.073  32.328  45.880  1.00 14.65           C  
ATOM   2166  CZ  PHE B 126      36.015  32.712  45.066  1.00 14.12           C  
ATOM   2167  N   CYS B 127      40.326  36.949  48.991  1.00 11.08           N  
ATOM   2168  CA  CYS B 127      41.451  37.779  49.404  1.00 12.40           C  
ATOM   2169  C   CYS B 127      42.662  36.853  49.369  1.00 12.68           C  
ATOM   2170  O   CYS B 127      42.686  35.827  50.048  1.00 12.05           O  
ATOM   2171  CB  CYS B 127      41.257  38.333  50.817  1.00 12.42           C  
ATOM   2172  SG  CYS B 127      42.592  39.444  51.349  1.00 14.07           S  
ATOM   2173  N   ASP B 128      43.657  37.214  48.567  1.00 16.23           N  
ATOM   2174  CA  ASP B 128      44.862  36.408  48.411  1.00 19.20           C  
ATOM   2175  C   ASP B 128      44.513  35.022  47.867  1.00 20.18           C  
ATOM   2176  O   ASP B 128      45.222  34.046  48.112  1.00 21.83           O  
ATOM   2177  CB  ASP B 128      45.611  36.276  49.740  1.00 21.50           C  
ATOM   2178  CG  ASP B 128      46.166  37.600  50.229  1.00 22.12           C  
ATOM   2179  OD1 ASP B 128      46.447  38.476  49.385  1.00 23.71           O  
ATOM   2180  OD2 ASP B 128      46.335  37.761  51.455  1.00 26.14           O  
ATOM   2181  N   GLY B 129      43.412  34.945  47.129  1.00 20.06           N  
ATOM   2182  CA  GLY B 129      42.999  33.682  46.546  1.00 19.79           C  
ATOM   2183  C   GLY B 129      42.226  32.787  47.491  1.00 19.62           C  
ATOM   2184  O   GLY B 129      41.971  31.624  47.179  1.00 22.11           O  
ATOM   2185  N   LYS B 130      41.858  33.321  48.651  1.00 16.30           N  
ATOM   2186  CA  LYS B 130      41.098  32.556  49.628  1.00 14.68           C  
ATOM   2187  C   LYS B 130      39.684  33.105  49.753  1.00 12.56           C  
ATOM   2188  O   LYS B 130      39.492  34.318  49.841  1.00 11.96           O  
ATOM   2189  CB  LYS B 130      41.774  32.596  50.999  1.00 17.46           C  
ATOM   2190  CG  LYS B 130      41.026  31.798  52.053  1.00 21.42           C  
ATOM   2191  CD  LYS B 130      41.717  31.838  53.403  1.00 25.32           C  
ATOM   2192  CE  LYS B 130      41.689  33.232  53.995  1.00 26.69           C  
ATOM   2193  NZ  LYS B 130      42.331  33.273  55.335  1.00 29.69           N  
ATOM   2194  N   LEU B 131      38.701  32.209  49.759  1.00 11.70           N  
ATOM   2195  CA  LEU B 131      37.299  32.601  49.889  1.00 10.57           C  
ATOM   2196  C   LEU B 131      37.073  33.112  51.308  1.00 10.30           C  
ATOM   2197  O   LEU B 131      37.236  32.365  52.273  1.00 11.25           O  
ATOM   2198  CB  LEU B 131      36.385  31.400  49.620  1.00 11.63           C  
ATOM   2199  CG  LEU B 131      34.881  31.680  49.749  1.00 11.25           C  
ATOM   2200  CD1 LEU B 131      34.489  32.746  48.748  1.00  9.16           C  
ATOM   2201  CD2 LEU B 131      34.074  30.404  49.514  1.00 12.00           C  
ATOM   2202  N   CYS B 132      36.682  34.379  51.434  1.00  9.09           N  
ATOM   2203  CA  CYS B 132      36.466  34.978  52.748  1.00  8.66           C  
ATOM   2204  C   CYS B 132      35.015  35.316  53.085  1.00  7.14           C  
ATOM   2205  O   CYS B 132      34.682  35.528  54.251  1.00  7.99           O  
ATOM   2206  CB  CYS B 132      37.327  36.239  52.895  1.00  9.64           C  
ATOM   2207  SG  CYS B 132      39.109  35.928  52.929  1.00 12.49           S  
ATOM   2208  N   ALA B 133      34.158  35.388  52.072  1.00  7.64           N  
ATOM   2209  CA  ALA B 133      32.746  35.682  52.299  1.00  7.47           C  
ATOM   2210  C   ALA B 133      31.879  35.178  51.147  1.00  7.18           C  
ATOM   2211  O   ALA B 133      32.305  35.172  49.990  1.00  7.38           O  
ATOM   2212  CB  ALA B 133      32.534  37.187  52.518  1.00  8.35           C  
ATOM   2213  N   GLN B 134      30.664  34.755  51.493  1.00  8.43           N  
ATOM   2214  CA  GLN B 134      29.694  34.210  50.541  1.00  8.67           C  
ATOM   2215  C   GLN B 134      28.392  35.004  50.606  1.00  7.77           C  
ATOM   2216  O   GLN B 134      27.877  35.284  51.689  1.00  9.04           O  
ATOM   2217  CB  GLN B 134      29.419  32.741  50.872  1.00 13.03           C  
ATOM   2218  CG  GLN B 134      28.642  31.988  49.810  1.00 18.95           C  
ATOM   2219  CD  GLN B 134      29.414  31.860  48.507  1.00 20.20           C  
ATOM   2220  OE1 GLN B 134      30.477  31.236  48.456  1.00 25.05           O  
ATOM   2221  NE2 GLN B 134      28.885  32.457  47.447  1.00 21.72           N  
ATOM   2222  N   PHE B 135      27.849  35.326  49.437  1.00  7.40           N  
ATOM   2223  CA  PHE B 135      26.634  36.128  49.336  1.00  7.73           C  
ATOM   2224  C   PHE B 135      25.626  35.547  48.350  1.00  8.77           C  
ATOM   2225  O   PHE B 135      25.981  35.100  47.263  1.00  7.09           O  
ATOM   2226  CB  PHE B 135      27.047  37.546  48.919  1.00  6.24           C  
ATOM   2227  CG  PHE B 135      25.900  38.487  48.641  1.00  7.77           C  
ATOM   2228  CD1 PHE B 135      25.270  38.500  47.399  1.00  8.09           C  
ATOM   2229  CD2 PHE B 135      25.519  39.427  49.594  1.00  8.98           C  
ATOM   2230  CE1 PHE B 135      24.278  39.444  47.104  1.00  8.41           C  
ATOM   2231  CE2 PHE B 135      24.532  40.371  49.312  1.00  7.23           C  
ATOM   2232  CZ  PHE B 135      23.913  40.381  48.063  1.00  7.84           C  
ATOM   2233  N   ASP B 136      24.362  35.545  48.755  1.00  8.67           N  
ATOM   2234  CA  ASP B 136      23.283  35.064  47.915  1.00 11.68           C  
ATOM   2235  C   ASP B 136      22.227  36.150  47.933  1.00 10.72           C  
ATOM   2236  O   ASP B 136      21.720  36.517  48.990  1.00 13.78           O  
ATOM   2237  CB  ASP B 136      22.733  33.746  48.458  1.00 16.37           C  
ATOM   2238  CG  ASP B 136      23.650  32.575  48.153  1.00 20.42           C  
ATOM   2239  OD1 ASP B 136      23.796  32.242  46.959  1.00 25.37           O  
ATOM   2240  OD2 ASP B 136      24.230  32.000  49.096  1.00 25.64           O  
ATOM   2241  N   GLY B 137      21.917  36.691  46.762  1.00  9.86           N  
ATOM   2242  CA  GLY B 137      20.935  37.749  46.706  1.00  8.63           C  
ATOM   2243  C   GLY B 137      19.878  37.563  45.645  1.00  9.32           C  
ATOM   2244  O   GLY B 137      20.143  37.052  44.557  1.00 10.26           O  
ATOM   2245  N   LEU B 138      18.660  37.963  45.975  1.00  8.44           N  
ATOM   2246  CA  LEU B 138      17.561  37.878  45.028  1.00  8.28           C  
ATOM   2247  C   LEU B 138      17.279  39.304  44.585  1.00  9.00           C  
ATOM   2248  O   LEU B 138      16.865  40.134  45.393  1.00  9.26           O  
ATOM   2249  CB  LEU B 138      16.314  37.286  45.692  1.00 10.71           C  
ATOM   2250  CG  LEU B 138      15.055  37.271  44.818  1.00 12.41           C  
ATOM   2251  CD1 LEU B 138      15.308  36.447  43.570  1.00 14.32           C  
ATOM   2252  CD2 LEU B 138      13.883  36.706  45.610  1.00 15.42           C  
ATOM   2253  N   TYR B 139      17.523  39.598  43.313  1.00  9.19           N  
ATOM   2254  CA  TYR B 139      17.277  40.939  42.800  1.00  9.49           C  
ATOM   2255  C   TYR B 139      16.004  40.941  41.971  1.00 10.75           C  
ATOM   2256  O   TYR B 139      15.691  39.961  41.301  1.00 11.57           O  
ATOM   2257  CB  TYR B 139      18.446  41.425  41.929  1.00  8.39           C  
ATOM   2258  CG  TYR B 139      19.745  41.609  42.680  1.00  7.43           C  
ATOM   2259  CD1 TYR B 139      20.544  40.516  43.008  1.00  7.95           C  
ATOM   2260  CD2 TYR B 139      20.157  42.875  43.093  1.00  7.52           C  
ATOM   2261  CE1 TYR B 139      21.724  40.676  43.731  1.00  8.24           C  
ATOM   2262  CE2 TYR B 139      21.336  43.047  43.819  1.00  7.00           C  
ATOM   2263  CZ  TYR B 139      22.113  41.943  44.136  1.00  7.81           C  
ATOM   2264  OH  TYR B 139      23.269  42.103  44.870  1.00  8.65           O  
ATOM   2265  N   VAL B 140      15.270  42.043  42.025  1.00 11.04           N  
ATOM   2266  CA  VAL B 140      14.039  42.169  41.262  1.00 12.67           C  
ATOM   2267  C   VAL B 140      14.149  43.409  40.392  1.00 12.20           C  
ATOM   2268  O   VAL B 140      14.432  44.497  40.886  1.00 12.80           O  
ATOM   2269  CB  VAL B 140      12.819  42.309  42.191  1.00 13.98           C  
ATOM   2270  CG1 VAL B 140      11.550  42.493  41.362  1.00 15.91           C  
ATOM   2271  CG2 VAL B 140      12.702  41.081  43.077  1.00 15.31           C  
ATOM   2272  N   SER B 141      13.948  43.240  39.089  1.00 12.26           N  
ATOM   2273  CA  SER B 141      14.026  44.367  38.172  1.00 13.58           C  
ATOM   2274  C   SER B 141      12.641  44.691  37.635  1.00 13.33           C  
ATOM   2275  O   SER B 141      11.949  43.815  37.119  1.00 13.88           O  
ATOM   2276  CB  SER B 141      14.960  44.050  37.006  1.00 13.13           C  
ATOM   2277  OG  SER B 141      15.058  45.162  36.134  1.00 15.43           O  
ATOM   2278  N   VAL B 142      12.240  45.950  37.770  1.00 16.07           N  
ATOM   2279  CA  VAL B 142      10.936  46.389  37.291  1.00 19.42           C  
ATOM   2280  C   VAL B 142      11.083  47.334  36.101  1.00 20.09           C  
ATOM   2281  O   VAL B 142      11.757  48.362  36.188  1.00 19.63           O  
ATOM   2282  CB  VAL B 142      10.134  47.107  38.408  1.00 20.65           C  
ATOM   2283  CG1 VAL B 142       9.733  46.110  39.481  1.00 24.02           C  
ATOM   2284  CG2 VAL B 142      10.966  48.225  39.013  1.00 23.51           C  
ATOM   2285  N   PRO B 143      10.461  46.988  34.964  1.00 21.85           N  
ATOM   2286  CA  PRO B 143      10.516  47.803  33.747  1.00 23.81           C  
ATOM   2287  C   PRO B 143       9.749  49.113  33.902  1.00 24.61           C  
ATOM   2288  O   PRO B 143      10.221  50.141  33.372  1.00 26.88           O  
ATOM   2289  CB  PRO B 143       9.912  46.884  32.690  1.00 23.50           C  
ATOM   2290  CG  PRO B 143       8.917  46.093  33.472  1.00 22.84           C  
ATOM   2291  CD  PRO B 143       9.676  45.761  34.736  1.00 22.88           C  
TER    2292      PRO B 143                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
