
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 ( 1027),  selected  130 , name 1ixl_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1ixl_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      T       6           -
LGA    I     2_A      D       7           -
LGA    P     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    Q     6_A      F       8          5.565
LGA    R     7_A      F       9          5.072
LGA    T     8_A      G      10          4.668
LGA    H     9_A      L      11          4.167
LGA    K    10_A      T      12          2.737
LGA    L    11_A      I      13          2.894
LGA    T    12_A      P      14          4.685
LGA    -       -      F      15           -
LGA    S    13_A      M      16          2.782
LGA    R    14_A      Q      17          3.658
LGA    I    15_A      L      18          4.711
LGA    L    16_A      L      19          0.326
LGA    V    17_A      G      20          5.623
LGA    G    18_A      V      21          1.709
LGA    K    19_A      V      22          0.918
LGA    P    20_A      P      23          0.704
LGA    I    21_A      E      24          0.882
LGA    L    22_A      H      25          1.155
LGA    I    23_A      S      26          1.501
LGA    K    24_A      G      27          1.470
LGA    E    25_A      N      28          2.033
LGA    G    26_A      G      29          1.124
LGA    Y    27_A      T      30          1.025
LGA    A    28_A      A      31          0.708
LGA    E    29_A      R      32          0.046
LGA    V    30_A      T      33          0.310
LGA    E    31_A      R      34          0.232
LGA    L    32_A      L      35          0.617
LGA    E    33_A      P      36          1.066
LGA    T    34_A      A      37          2.639
LGA    I    35_A      R      38          1.159
LGA    D    36_A      A      39          0.763
LGA    E    37_A      D      40          1.437
LGA    X    38_A      L      41          1.726
LGA    K    39_A      V      42          2.020
LGA    V    40_A      N      43          2.685
LGA    D    41_A      S      44          1.783
LGA    E    42_A      -       -           -
LGA    K    43_A      R      45          4.071
LGA    G    44_A      G      46          1.197
LGA    L    45_A      D      47          2.109
LGA    V    46_A      I      48          2.001
LGA    H    47_A      H      49          1.244
LGA    G    48_A      G      50          0.358
LGA    G    49_A      G      51          0.258
LGA    F    50_A      T      52          0.271
LGA    T    51_A      L      53          0.701
LGA    F    52_A      M      54          0.768
LGA    G    53_A      S      55          0.633
LGA    L    54_A      V      56          0.819
LGA    A    55_A      L      57          0.809
LGA    D    56_A      D      58          0.703
LGA    Y    57_A      F      59          0.668
LGA    A    58_A      T      60          0.615
LGA    A    59_A      L      61          0.847
LGA    X    60_A      G      62          1.559
LGA    L    61_A      A      63          0.974
LGA    A    62_A      A      64          0.773
LGA    V    63_A      I      65          1.133
LGA    N    64_A      R      66          1.577
LGA    -       -      G      67           -
LGA    -       -      D      68           -
LGA    -       -      T      69           -
LGA    -       -      P      70           -
LGA    E    65_A      E      71          4.871
LGA    P    66_A      V      72           #
LGA    T    67_A      G      73          1.854
LGA    V    68_A      V      74          1.042
LGA    V    69_A      A      75          1.188
LGA    L    70_A      T      76          0.859
LGA    G    71_A      I      77          0.891
LGA    K    72_A      D      78          0.456
LGA    A    73_A      M      79          0.598
LGA    E    74_A      N      80          0.939
LGA    V    75_A      T      81          1.108
LGA    R    76_A      S      82          0.300
LGA    F    77_A      F      83          0.799
LGA    T    78_A      M      84          0.759
LGA    K    79_A      S      85          0.446
LGA    P    80_A      P      86          0.781
LGA    V    81_A      G      87          1.458
LGA    K    82_A      R      88          3.143
LGA    V    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    D    85_A      G      89          0.977
LGA    K    86_A      D      90          0.476
LGA    L    87_A      L      91          0.787
LGA    V    88_A      V      92          0.766
LGA    A    89_A      I      93          0.699
LGA    K    90_A      E      94          0.340
LGA    A    91_A      T      95          0.756
LGA    K    92_A      R      96          0.564
LGA    I    93_A      C      97          0.348
LGA    I    94_A      L      98          0.747
LGA    E    95_A      R      99          1.152
LGA    D    96_A      R     100          1.303
LGA    L    97_A      G     101          2.123
LGA    G    98_A      A     102          2.099
LGA    K    99_A      S     103          1.897
LGA    K   100_A      I     104          1.074
LGA    K   101_A      A     105          0.815
LGA    I   102_A      F     106          0.441
LGA    V   103_A      C     107          0.693
LGA    E   104_A      E     108          0.815
LGA    V   105_A      G     109          0.804
LGA    K   106_A      E     110          0.744
LGA    V   107_A      I     111          0.882
LGA    Y   108_A      R     112          1.007
LGA    R   109_A      D     113          0.781
LGA    E   110_A      S     114          2.684
LGA    -       -      A     115           -
LGA    E   111_A      G     116          1.027
LGA    E   112_A      E     117          0.821
LGA    V   113_A      L     118          0.990
LGA    V   114_A      V     119          0.471
LGA    L   115_A      A     120          0.749
LGA    E   116_A      K     121          0.508
LGA    G   117_A      A     122          1.107
LGA    K   118_A      T     123          0.703
LGA    F   119_A      A     124          1.095
LGA    Y   120_A      T     125          0.691
LGA    C   121_A      F     126          1.272
LGA    Y   122_A      K     127          1.262
LGA    V   123_A      I     128          1.115
LGA    L   124_A      I     129          1.342
LGA    E   125_A      Q     130          3.503
LGA    K   126_A      -       -           -
LGA    H   127_A      -       -           -
LGA    V   128_A      -       -           -
LGA    L   129_A      -       -           -
LGA    D   130_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130  125    5.0    116    1.87    17.24     85.688     5.892

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.173523 * X  +  -0.692924 * Y  +  -0.699819 * Z  +  35.705921
  Y_new =  -0.684112 * X  +  -0.595978 * Y  +   0.420477 * Z  +  60.645454
  Z_new =  -0.708435 * X  +   0.405792 * Y  +  -0.577454 * Z  +  53.740181 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.529039   -0.612554  [ DEG:   144.9032    -35.0968 ]
  Theta =   0.787278    2.354315  [ DEG:    45.1077    134.8923 ]
  Phi   =  -1.322388    1.819205  [ DEG:   -75.7672    104.2328 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ixl_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ixl_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130  125   5.0  116   1.87   17.24  85.688
REMARK  ---------------------------------------------------------- 
MOLECULE 1ixl_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-JUN-02   1IXL              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN PH1136 FROM              
TITLE    2 PYROCOCCUS HORIKOSHII                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PH1136;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-22B                                   
KEYWDS    ALPHA+BETA, HOT-DOG-FOLD, STRUCTURAL GENOMICS                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.TAJIKA,N.SAKAI,Y.TANAKA,M.YAO,N.WATANABE,I.TANAKA                   
REVDAT   2   16-MAR-04 1IXL    1       JRNL                                     
REVDAT   1   09-SEP-03 1IXL    0                                                
JRNL        AUTH   Y.TAJIKA,N.SAKAI,Y.TANAKA,M.YAO,N.WATANABE,I.TANAKA          
JRNL        TITL   CRYSTAL STRUCTURE OF CONSERVED PROTEIN PH1136 FROM           
JRNL        TITL 2 PYROCOCCUS HORIKOSHII.                                       
JRNL        REF    PROTEINS                      V.  55   210 2004              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 1.94 ANGSTROMS.                                          
DBREF  1IXL A    1   131  UNP    O58863   O58863_PYRHO     1    131             
SEQRES   1 A  131  MSE ILE PRO VAL GLU GLN ARG THR HIS LYS LEU THR SER          
SEQRES   2 A  131  ARG ILE LEU VAL GLY LYS PRO ILE LEU ILE LYS GLU GLY          
SEQRES   3 A  131  TYR ALA GLU VAL GLU LEU GLU THR ILE ASP GLU MSE LYS          
SEQRES   4 A  131  VAL ASP GLU LYS GLY LEU VAL HIS GLY GLY PHE THR PHE          
SEQRES   5 A  131  GLY LEU ALA ASP TYR ALA ALA MSE LEU ALA VAL ASN GLU          
SEQRES   6 A  131  PRO THR VAL VAL LEU GLY LYS ALA GLU VAL ARG PHE THR          
SEQRES   7 A  131  LYS PRO VAL LYS VAL GLY ASP LYS LEU VAL ALA LYS ALA          
SEQRES   8 A  131  LYS ILE ILE GLU ASP LEU GLY LYS LYS LYS ILE VAL GLU          
SEQRES   9 A  131  VAL LYS VAL TYR ARG GLU GLU GLU VAL VAL LEU GLU GLY          
SEQRES  10 A  131  LYS PHE TYR CYS TYR VAL LEU GLU LYS HIS VAL LEU ASP          
SEQRES  11 A  131  ASN                                                          
HET    MSE  A   1       8                                                       
HET    MSE  A  38       8                                                       
HET    MSE  A  60       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *89(H2 O)                                                     
CRYST1   57.500   57.500   79.500  90.00  90.00 120.00 P 31 2 1      6          
HETATM    1  N   MSE A   1      35.894  37.836  25.498  1.00 34.91           N  
HETATM    2  CA  MSE A   1      34.688  38.528  26.045  1.00 32.84           C  
HETATM    3  C   MSE A   1      34.489  39.890  25.373  1.00 31.74           C  
HETATM    4  O   MSE A   1      35.444  40.507  24.912  1.00 30.56           O  
HETATM    5  CB  MSE A   1      34.869  38.768  27.545  1.00 33.94           C  
HETATM    6  CG  MSE A   1      35.479  40.118  27.856  1.00 33.75           C  
HETATM    7 SE   MSE A   1      35.772  40.383  29.596  1.00 36.40          SE  
HETATM    8  CE  MSE A   1      36.694  38.887  29.955  1.00 36.76           C  
ATOM      9  N   ILE A   2      33.251  40.363  25.336  1.00 30.81           N  
ATOM     10  CA  ILE A   2      32.975  41.681  24.783  1.00 30.69           C  
ATOM     11  C   ILE A   2      32.640  42.575  25.984  1.00 33.05           C  
ATOM     12  O   ILE A   2      31.675  42.317  26.716  1.00 31.48           O  
ATOM     13  CB  ILE A   2      31.772  41.678  23.813  1.00 30.26           C  
ATOM     14  CG1 ILE A   2      32.076  40.786  22.608  1.00 25.69           C  
ATOM     15  CG2 ILE A   2      31.456  43.113  23.374  1.00 28.39           C  
ATOM     16  CD1 ILE A   2      30.941  40.706  21.596  1.00 31.34           C  
ATOM     17  N   PRO A   3      33.451  43.616  26.213  1.00 32.19           N  
ATOM     18  CA  PRO A   3      33.252  44.556  27.327  1.00 34.81           C  
ATOM     19  C   PRO A   3      31.933  45.286  27.135  1.00 33.82           C  
ATOM     20  O   PRO A   3      31.478  45.470  26.009  1.00 29.56           O  
ATOM     21  CB  PRO A   3      34.432  45.521  27.191  1.00 33.50           C  
ATOM     22  CG  PRO A   3      35.470  44.705  26.446  1.00 34.84           C  
ATOM     23  CD  PRO A   3      34.639  43.982  25.428  1.00 31.15           C  
ATOM     24  N   VAL A   4      31.309  45.689  28.230  1.00 32.43           N  
ATOM     25  CA  VAL A   4      30.062  46.417  28.125  1.00 33.49           C  
ATOM     26  C   VAL A   4      30.254  47.604  29.039  1.00 34.92           C  
ATOM     27  O   VAL A   4      30.930  47.484  30.060  1.00 35.06           O  
ATOM     28  CB  VAL A   4      28.878  45.562  28.609  1.00 35.97           C  
ATOM     29  CG1 VAL A   4      27.570  46.268  28.331  1.00 37.70           C  
ATOM     30  CG2 VAL A   4      28.908  44.219  27.916  1.00 39.04           C  
ATOM     31  N   GLU A   5      29.701  48.753  28.672  1.00 31.54           N  
ATOM     32  CA  GLU A   5      29.834  49.922  29.523  1.00 32.18           C  
ATOM     33  C   GLU A   5      28.908  49.750  30.731  1.00 30.78           C  
ATOM     34  O   GLU A   5      27.926  48.993  30.683  1.00 27.03           O  
ATOM     35  CB  GLU A   5      29.470  51.197  28.744  1.00 37.49           C  
ATOM     36  CG  GLU A   5      28.250  51.065  27.860  1.00 46.78           C  
ATOM     37  CD  GLU A   5      28.058  52.267  26.930  1.00 52.00           C  
ATOM     38  OE1 GLU A   5      29.054  52.720  26.313  1.00 56.43           O  
ATOM     39  OE2 GLU A   5      26.911  52.747  26.806  1.00 51.10           O  
ATOM     40  N   GLN A   6      29.233  50.443  31.813  1.00 29.14           N  
ATOM     41  CA  GLN A   6      28.423  50.369  33.015  1.00 26.90           C  
ATOM     42  C   GLN A   6      27.112  51.114  32.781  1.00 27.22           C  
ATOM     43  O   GLN A   6      27.113  52.322  32.506  1.00 25.81           O  
ATOM     44  CB  GLN A   6      29.161  51.002  34.185  1.00 27.69           C  
ATOM     45  CG  GLN A   6      28.484  50.706  35.490  1.00 25.16           C  
ATOM     46  CD  GLN A   6      29.331  51.066  36.674  1.00 28.68           C  
ATOM     47  OE1 GLN A   6      30.558  51.106  36.588  1.00 25.75           O  
ATOM     48  NE2 GLN A   6      28.686  51.302  37.805  1.00 23.39           N  
ATOM     49  N   ARG A   7      25.990  50.419  32.931  1.00 24.95           N  
ATOM     50  CA  ARG A   7      24.696  51.061  32.692  1.00 26.44           C  
ATOM     51  C   ARG A   7      23.860  51.364  33.939  1.00 26.43           C  
ATOM     52  O   ARG A   7      22.738  51.850  33.828  1.00 23.08           O  
ATOM     53  CB  ARG A   7      23.871  50.193  31.744  1.00 29.31           C  
ATOM     54  CG  ARG A   7      24.516  49.947  30.386  1.00 28.05           C  
ATOM     55  CD  ARG A   7      23.653  48.979  29.609  1.00 30.22           C  
ATOM     56  NE  ARG A   7      22.333  49.538  29.321  1.00 33.45           N  
ATOM     57  CZ  ARG A   7      21.236  48.806  29.146  1.00 32.05           C  
ATOM     58  NH1 ARG A   7      21.299  47.481  29.236  1.00 32.12           N  
ATOM     59  NH2 ARG A   7      20.075  49.395  28.885  1.00 31.99           N  
ATOM     60  N   THR A   8      24.402  51.091  35.120  1.00 26.35           N  
ATOM     61  CA  THR A   8      23.670  51.326  36.361  1.00 23.89           C  
ATOM     62  C   THR A   8      24.633  51.556  37.510  1.00 24.49           C  
ATOM     63  O   THR A   8      25.805  51.200  37.405  1.00 23.31           O  
ATOM     64  CB  THR A   8      22.779  50.100  36.727  1.00 27.70           C  
ATOM     65  OG1 THR A   8      21.985  50.413  37.883  1.00 28.75           O  
ATOM     66  CG2 THR A   8      23.658  48.871  37.053  1.00 26.88           C  
ATOM     67  N   HIS A   9      24.131  52.149  38.599  1.00 22.06           N  
ATOM     68  CA  HIS A   9      24.933  52.388  39.789  1.00 23.38           C  
ATOM     69  C   HIS A   9      26.220  53.129  39.441  1.00 26.09           C  
ATOM     70  O   HIS A   9      27.266  52.863  40.032  1.00 22.67           O  
ATOM     71  CB  HIS A   9      25.288  51.041  40.450  1.00 19.36           C  
ATOM     72  CG  HIS A   9      24.159  50.411  41.212  1.00 21.71           C  
ATOM     73  ND1 HIS A   9      22.944  50.096  40.632  1.00 23.83           N  
ATOM     74  CD2 HIS A   9      24.045  50.079  42.521  1.00 21.82           C  
ATOM     75  CE1 HIS A   9      22.130  49.606  41.551  1.00 21.26           C  
ATOM     76  NE2 HIS A   9      22.772  49.585  42.707  1.00 21.72           N  
ATOM     77  N   LYS A  10      26.128  54.083  38.517  1.00 26.17           N  
ATOM     78  CA  LYS A  10      27.300  54.822  38.039  1.00 29.57           C  
ATOM     79  C   LYS A  10      28.056  55.725  39.004  1.00 30.13           C  
ATOM     80  O   LYS A  10      29.250  55.946  38.831  1.00 30.74           O  
ATOM     81  CB  LYS A  10      26.919  55.649  36.798  1.00 31.39           C  
ATOM     82  CG  LYS A  10      26.457  54.839  35.612  1.00 32.63           C  
ATOM     83  CD  LYS A  10      25.895  55.772  34.534  1.00 34.87           C  
ATOM     84  CE  LYS A  10      25.458  55.026  33.301  1.00 38.19           C  
ATOM     85  NZ  LYS A  10      24.821  55.955  32.301  1.00 42.59           N  
ATOM     86  N   LEU A  11      27.387  56.252  40.022  1.00 29.98           N  
ATOM     87  CA  LEU A  11      28.063  57.151  40.939  1.00 28.11           C  
ATOM     88  C   LEU A  11      28.552  56.483  42.221  1.00 28.23           C  
ATOM     89  O   LEU A  11      28.985  57.149  43.147  1.00 27.67           O  
ATOM     90  CB  LEU A  11      27.130  58.312  41.279  1.00 29.53           C  
ATOM     91  CG  LEU A  11      26.549  59.082  40.076  1.00 32.55           C  
ATOM     92  CD1 LEU A  11      25.709  60.252  40.590  1.00 32.07           C  
ATOM     93  CD2 LEU A  11      27.688  59.598  39.174  1.00 33.01           C  
ATOM     94  N   THR A  12      28.486  55.157  42.255  1.00 27.02           N  
ATOM     95  CA  THR A  12      28.920  54.394  43.416  1.00 24.77           C  
ATOM     96  C   THR A  12      30.368  54.747  43.756  1.00 27.16           C  
ATOM     97  O   THR A  12      31.224  54.786  42.880  1.00 24.54           O  
ATOM     98  CB  THR A  12      28.795  52.884  43.133  1.00 24.38           C  
ATOM     99  OG1 THR A  12      27.450  52.601  42.731  1.00 23.53           O  
ATOM    100  CG2 THR A  12      29.128  52.078  44.357  1.00 17.92           C  
ATOM    101  N   SER A  13      30.613  55.004  45.039  1.00 25.84           N  
ATOM    102  CA  SER A  13      31.922  55.377  45.550  1.00 27.03           C  
ATOM    103  C   SER A  13      33.019  54.359  45.253  1.00 27.32           C  
ATOM    104  O   SER A  13      32.940  53.207  45.656  1.00 22.34           O  
ATOM    105  CB  SER A  13      31.843  55.615  47.066  1.00 27.95           C  
ATOM    106  OG  SER A  13      33.131  55.885  47.584  1.00 27.41           O  
ATOM    107  N   ARG A  14      34.047  54.804  44.543  1.00 27.51           N  
ATOM    108  CA  ARG A  14      35.161  53.942  44.193  1.00 29.65           C  
ATOM    109  C   ARG A  14      36.007  53.667  45.428  1.00 27.15           C  
ATOM    110  O   ARG A  14      36.727  52.677  45.493  1.00 26.51           O  
ATOM    111  CB  ARG A  14      36.013  54.619  43.109  1.00 31.20           C  
ATOM    112  CG  ARG A  14      35.271  54.816  41.793  1.00 35.29           C  
ATOM    113  CD  ARG A  14      35.323  53.570  40.933  1.00 42.89           C  
ATOM    114  NE  ARG A  14      34.335  53.613  39.856  1.00 43.56           N  
ATOM    115  CZ  ARG A  14      33.075  53.201  39.980  1.00 45.87           C  
ATOM    116  NH1 ARG A  14      32.625  52.693  41.149  1.00 34.62           N  
ATOM    117  NH2 ARG A  14      32.256  53.321  38.935  1.00 44.60           N  
ATOM    118  N   ILE A  15      35.900  54.547  46.411  1.00 29.86           N  
ATOM    119  CA  ILE A  15      36.685  54.426  47.636  1.00 29.09           C  
ATOM    120  C   ILE A  15      36.033  53.601  48.735  1.00 29.04           C  
ATOM    121  O   ILE A  15      36.723  52.898  49.480  1.00 27.93           O  
ATOM    122  CB  ILE A  15      36.991  55.820  48.212  1.00 34.60           C  
ATOM    123  CG1 ILE A  15      37.819  56.620  47.210  1.00 36.62           C  
ATOM    124  CG2 ILE A  15      37.712  55.695  49.564  1.00 37.53           C  
ATOM    125  CD1 ILE A  15      38.987  55.837  46.625  1.00 42.69           C  
ATOM    126  N   LEU A  16      34.707  53.673  48.815  1.00 26.50           N  
ATOM    127  CA  LEU A  16      33.967  52.970  49.870  1.00 27.01           C  
ATOM    128  C   LEU A  16      33.339  51.656  49.449  1.00 25.61           C  
ATOM    129  O   LEU A  16      33.116  50.782  50.275  1.00 26.81           O  
ATOM    130  CB  LEU A  16      32.861  53.872  50.417  1.00 23.95           C  
ATOM    131  CG  LEU A  16      33.312  55.131  51.145  1.00 27.54           C  
ATOM    132  CD1 LEU A  16      32.123  56.068  51.313  1.00 29.19           C  
ATOM    133  CD2 LEU A  16      33.941  54.752  52.504  1.00 30.15           C  
ATOM    134  N   VAL A  17      33.075  51.509  48.158  1.00 23.31           N  
ATOM    135  CA  VAL A  17      32.426  50.310  47.671  1.00 23.01           C  
ATOM    136  C   VAL A  17      33.276  49.542  46.674  1.00 24.08           C  
ATOM    137  O   VAL A  17      33.404  48.321  46.773  1.00 23.38           O  
ATOM    138  CB  VAL A  17      31.040  50.684  47.058  1.00 24.38           C  
ATOM    139  CG1 VAL A  17      30.248  49.425  46.695  1.00 21.41           C  
ATOM    140  CG2 VAL A  17      30.271  51.553  48.059  1.00 22.61           C  
ATOM    141  N   GLY A  18      33.840  50.239  45.698  1.00 24.02           N  
ATOM    142  CA  GLY A  18      34.674  49.533  44.757  1.00 23.74           C  
ATOM    143  C   GLY A  18      34.790  50.108  43.366  1.00 24.23           C  
ATOM    144  O   GLY A  18      34.014  50.974  42.965  1.00 21.70           O  
ATOM    145  N   LYS A  19      35.779  49.595  42.639  1.00 25.97           N  
ATOM    146  CA  LYS A  19      36.084  50.009  41.275  1.00 25.70           C  
ATOM    147  C   LYS A  19      35.868  48.810  40.374  1.00 24.87           C  
ATOM    148  O   LYS A  19      36.525  47.785  40.521  1.00 24.05           O  
ATOM    149  CB  LYS A  19      37.549  50.467  41.192  1.00 32.05           C  
ATOM    150  CG  LYS A  19      37.902  51.577  42.183  1.00 38.71           C  
ATOM    151  CD  LYS A  19      39.399  51.926  42.137  1.00 42.75           C  
ATOM    152  CE  LYS A  19      39.713  53.150  42.985  1.00 44.74           C  
ATOM    153  NZ  LYS A  19      41.157  53.529  42.913  1.00 48.97           N  
ATOM    154  N   PRO A  20      34.923  48.911  39.434  1.00 23.81           N  
ATOM    155  CA  PRO A  20      34.687  47.764  38.549  1.00 25.76           C  
ATOM    156  C   PRO A  20      35.921  47.594  37.661  1.00 27.26           C  
ATOM    157  O   PRO A  20      36.462  48.585  37.171  1.00 26.03           O  
ATOM    158  CB  PRO A  20      33.442  48.187  37.753  1.00 25.04           C  
ATOM    159  CG  PRO A  20      32.786  49.257  38.638  1.00 26.25           C  
ATOM    160  CD  PRO A  20      33.974  50.004  39.174  1.00 25.57           C  
ATOM    161  N   ILE A  21      36.385  46.362  37.485  1.00 26.11           N  
ATOM    162  CA  ILE A  21      37.552  46.124  36.644  1.00 28.48           C  
ATOM    163  C   ILE A  21      37.159  45.247  35.472  1.00 28.20           C  
ATOM    164  O   ILE A  21      37.940  45.037  34.550  1.00 28.30           O  
ATOM    165  CB  ILE A  21      38.730  45.460  37.439  1.00 29.18           C  
ATOM    166  CG1 ILE A  21      38.277  44.157  38.102  1.00 31.14           C  
ATOM    167  CG2 ILE A  21      39.237  46.418  38.490  1.00 30.10           C  
ATOM    168  CD1 ILE A  21      39.402  43.418  38.858  1.00 32.27           C  
ATOM    169  N   LEU A  22      35.936  44.732  35.502  1.00 27.34           N  
ATOM    170  CA  LEU A  22      35.472  43.900  34.403  1.00 26.89           C  
ATOM    171  C   LEU A  22      33.959  43.787  34.389  1.00 27.92           C  
ATOM    172  O   LEU A  22      33.341  43.474  35.409  1.00 24.85           O  
ATOM    173  CB  LEU A  22      36.089  42.494  34.490  1.00 26.58           C  
ATOM    174  CG  LEU A  22      35.940  41.582  33.256  1.00 31.37           C  
ATOM    175  CD1 LEU A  22      36.907  40.406  33.393  1.00 33.63           C  
ATOM    176  CD2 LEU A  22      34.514  41.061  33.127  1.00 29.57           C  
ATOM    177  N   ILE A  23      33.361  44.072  33.236  1.00 23.48           N  
ATOM    178  CA  ILE A  23      31.919  43.932  33.102  1.00 24.76           C  
ATOM    179  C   ILE A  23      31.635  43.338  31.731  1.00 26.64           C  
ATOM    180  O   ILE A  23      32.033  43.899  30.712  1.00 27.28           O  
ATOM    181  CB  ILE A  23      31.157  45.280  33.174  1.00 25.50           C  
ATOM    182  CG1 ILE A  23      31.522  46.067  34.441  1.00 21.01           C  
ATOM    183  CG2 ILE A  23      29.632  44.999  33.151  1.00 23.86           C  
ATOM    184  CD1 ILE A  23      30.854  47.468  34.522  1.00 22.62           C  
ATOM    185  N   LYS A  24      30.963  42.197  31.709  1.00 27.51           N  
ATOM    186  CA  LYS A  24      30.595  41.576  30.456  1.00 28.95           C  
ATOM    187  C   LYS A  24      29.217  40.975  30.690  1.00 32.03           C  
ATOM    188  O   LYS A  24      28.684  41.053  31.807  1.00 27.55           O  
ATOM    189  CB  LYS A  24      31.592  40.482  30.074  1.00 31.54           C  
ATOM    190  CG  LYS A  24      31.637  39.294  31.002  1.00 28.76           C  
ATOM    191  CD  LYS A  24      32.633  38.278  30.484  1.00 31.34           C  
ATOM    192  CE  LYS A  24      32.610  37.000  31.289  1.00 35.26           C  
ATOM    193  NZ  LYS A  24      33.600  36.007  30.752  1.00 38.99           N  
ATOM    194  N   GLU A  25      28.651  40.370  29.650  1.00 28.19           N  
ATOM    195  CA  GLU A  25      27.334  39.746  29.746  1.00 28.95           C  
ATOM    196  C   GLU A  25      27.250  38.726  30.886  1.00 29.36           C  
ATOM    197  O   GLU A  25      27.997  37.741  30.915  1.00 25.53           O  
ATOM    198  CB  GLU A  25      27.003  39.035  28.437  1.00 31.81           C  
ATOM    199  CG  GLU A  25      25.725  38.194  28.474  1.00 34.51           C  
ATOM    200  CD  GLU A  25      24.468  39.031  28.592  1.00 35.71           C  
ATOM    201  OE1 GLU A  25      24.559  40.271  28.455  1.00 36.45           O  
ATOM    202  OE2 GLU A  25      23.388  38.440  28.814  1.00 36.47           O  
ATOM    203  N   GLY A  26      26.353  38.997  31.830  1.00 28.55           N  
ATOM    204  CA  GLY A  26      26.127  38.105  32.957  1.00 30.49           C  
ATOM    205  C   GLY A  26      27.234  37.930  33.980  1.00 27.76           C  
ATOM    206  O   GLY A  26      27.137  37.038  34.831  1.00 26.55           O  
ATOM    207  N   TYR A  27      28.252  38.788  33.940  1.00 26.51           N  
ATOM    208  CA  TYR A  27      29.379  38.643  34.863  1.00 27.49           C  
ATOM    209  C   TYR A  27      30.118  39.962  35.112  1.00 26.64           C  
ATOM    210  O   TYR A  27      30.271  40.793  34.213  1.00 24.62           O  
ATOM    211  CB  TYR A  27      30.334  37.597  34.284  1.00 26.99           C  
ATOM    212  CG  TYR A  27      31.560  37.286  35.119  1.00 28.97           C  
ATOM    213  CD1 TYR A  27      31.507  36.339  36.138  1.00 29.04           C  
ATOM    214  CD2 TYR A  27      32.765  37.961  34.905  1.00 27.35           C  
ATOM    215  CE1 TYR A  27      32.614  36.068  36.928  1.00 29.98           C  
ATOM    216  CE2 TYR A  27      33.886  37.694  35.701  1.00 29.62           C  
ATOM    217  CZ  TYR A  27      33.795  36.746  36.707  1.00 28.47           C  
ATOM    218  OH  TYR A  27      34.887  36.456  37.495  1.00 31.75           O  
ATOM    219  N   ALA A  28      30.569  40.165  36.346  1.00 24.39           N  
ATOM    220  CA  ALA A  28      31.304  41.389  36.663  1.00 23.58           C  
ATOM    221  C   ALA A  28      32.294  41.168  37.796  1.00 24.78           C  
ATOM    222  O   ALA A  28      32.121  40.273  38.620  1.00 24.46           O  
ATOM    223  CB  ALA A  28      30.350  42.501  37.029  1.00 25.20           C  
ATOM    224  N   GLU A  29      33.344  41.985  37.799  1.00 24.52           N  
ATOM    225  CA  GLU A  29      34.372  41.924  38.821  1.00 28.09           C  
ATOM    226  C   GLU A  29      34.638  43.345  39.283  1.00 26.65           C  
ATOM    227  O   GLU A  29      34.779  44.268  38.469  1.00 25.96           O  
ATOM    228  CB  GLU A  29      35.655  41.279  38.282  1.00 28.69           C  
ATOM    229  CG  GLU A  29      35.499  39.798  37.938  1.00 28.19           C  
ATOM    230  CD  GLU A  29      36.811  39.153  37.522  1.00 36.48           C  
ATOM    231  OE1 GLU A  29      37.849  39.860  37.525  1.00 33.71           O  
ATOM    232  OE2 GLU A  29      36.801  37.941  37.203  1.00 32.38           O  
ATOM    233  N   VAL A  30      34.694  43.515  40.601  1.00 26.64           N  
ATOM    234  CA  VAL A  30      34.918  44.821  41.207  1.00 24.80           C  
ATOM    235  C   VAL A  30      35.949  44.648  42.328  1.00 23.79           C  
ATOM    236  O   VAL A  30      35.884  43.691  43.091  1.00 22.54           O  
ATOM    237  CB  VAL A  30      33.608  45.378  41.821  1.00 26.41           C  
ATOM    238  CG1 VAL A  30      33.829  46.803  42.294  1.00 23.24           C  
ATOM    239  CG2 VAL A  30      32.461  45.303  40.796  1.00 23.71           C  
ATOM    240  N   GLU A  31      36.898  45.568  42.424  1.00 24.23           N  
ATOM    241  CA  GLU A  31      37.927  45.458  43.448  1.00 27.39           C  
ATOM    242  C   GLU A  31      37.816  46.589  44.457  1.00 27.09           C  
ATOM    243  O   GLU A  31      37.332  47.685  44.142  1.00 25.69           O  
ATOM    244  CB  GLU A  31      39.319  45.469  42.808  1.00 31.74           C  
ATOM    245  CG  GLU A  31      39.578  46.662  41.913  1.00 36.30           C  
ATOM    246  CD  GLU A  31      41.045  46.769  41.481  1.00 41.05           C  
ATOM    247  OE1 GLU A  31      41.648  45.720  41.166  1.00 40.67           O  
ATOM    248  OE2 GLU A  31      41.580  47.899  41.453  1.00 36.64           O  
ATOM    249  N   LEU A  32      38.261  46.315  45.678  1.00 26.21           N  
ATOM    250  CA  LEU A  32      38.210  47.317  46.726  1.00 25.39           C  
ATOM    251  C   LEU A  32      39.433  47.211  47.626  1.00 27.02           C  
ATOM    252  O   LEU A  32      39.773  46.122  48.106  1.00 26.97           O  
ATOM    253  CB  LEU A  32      36.952  47.133  47.585  1.00 22.52           C  
ATOM    254  CG  LEU A  32      36.779  47.988  48.853  1.00 22.44           C  
ATOM    255  CD1 LEU A  32      36.607  49.452  48.487  1.00 20.85           C  
ATOM    256  CD2 LEU A  32      35.534  47.516  49.618  1.00 22.23           C  
ATOM    257  N   GLU A  33      40.095  48.345  47.818  1.00 29.17           N  
ATOM    258  CA  GLU A  33      41.244  48.430  48.719  1.00 30.84           C  
ATOM    259  C   GLU A  33      40.606  48.881  50.033  1.00 28.19           C  
ATOM    260  O   GLU A  33      39.977  49.946  50.088  1.00 28.56           O  
ATOM    261  CB  GLU A  33      42.239  49.499  48.241  1.00 35.09           C  
ATOM    262  CG  GLU A  33      43.136  49.044  47.095  1.00 37.87           C  
ATOM    263  CD  GLU A  33      44.123  47.973  47.523  1.00 40.67           C  
ATOM    264  OE1 GLU A  33      44.837  47.437  46.641  1.00 41.27           O  
ATOM    265  OE2 GLU A  33      44.190  47.676  48.745  1.00 36.36           O  
ATOM    266  N   THR A  34      40.719  48.069  51.075  1.00 29.00           N  
ATOM    267  CA  THR A  34      40.122  48.461  52.344  1.00 28.42           C  
ATOM    268  C   THR A  34      40.946  49.562  53.002  1.00 31.80           C  
ATOM    269  O   THR A  34      42.180  49.569  52.899  1.00 31.79           O  
ATOM    270  CB  THR A  34      39.975  47.266  53.288  1.00 28.10           C  
ATOM    271  OG1 THR A  34      41.246  46.640  53.493  1.00 28.99           O  
ATOM    272  CG2 THR A  34      38.994  46.264  52.701  1.00 25.08           C  
ATOM    273  N   ILE A  35      40.256  50.503  53.649  1.00 31.16           N  
ATOM    274  CA  ILE A  35      40.902  51.637  54.309  1.00 31.73           C  
ATOM    275  C   ILE A  35      40.620  51.701  55.796  1.00 31.42           C  
ATOM    276  O   ILE A  35      39.714  51.034  56.310  1.00 29.58           O  
ATOM    277  CB  ILE A  35      40.493  52.998  53.682  1.00 32.36           C  
ATOM    278  CG1 ILE A  35      38.968  53.148  53.696  1.00 32.16           C  
ATOM    279  CG2 ILE A  35      41.043  53.097  52.265  1.00 35.91           C  
ATOM    280  CD1 ILE A  35      38.480  54.498  53.145  1.00 34.62           C  
ATOM    281  N   ASP A  36      41.393  52.535  56.480  1.00 29.39           N  
ATOM    282  CA  ASP A  36      41.296  52.660  57.924  1.00 30.41           C  
ATOM    283  C   ASP A  36      39.921  53.024  58.497  1.00 28.22           C  
ATOM    284  O   ASP A  36      39.568  52.592  59.592  1.00 27.93           O  
ATOM    285  CB  ASP A  36      42.356  53.647  58.408  1.00 33.70           C  
ATOM    286  CG  ASP A  36      42.647  53.493  59.872  1.00 34.44           C  
ATOM    287  OD1 ASP A  36      42.124  54.287  60.678  1.00 32.57           O  
ATOM    288  OD2 ASP A  36      43.385  52.550  60.214  1.00 38.36           O  
ATOM    289  N   GLU A  37      39.136  53.805  57.764  1.00 28.96           N  
ATOM    290  CA  GLU A  37      37.818  54.196  58.252  1.00 29.38           C  
ATOM    291  C   GLU A  37      36.837  53.029  58.329  1.00 28.35           C  
ATOM    292  O   GLU A  37      35.809  53.116  59.011  1.00 27.69           O  
ATOM    293  CB  GLU A  37      37.225  55.306  57.366  1.00 33.15           C  
ATOM    294  CG  GLU A  37      37.993  56.635  57.438  1.00 40.96           C  
ATOM    295  CD  GLU A  37      39.172  56.708  56.474  1.00 43.38           C  
ATOM    296  OE1 GLU A  37      40.035  55.801  56.467  1.00 42.87           O  
ATOM    297  OE2 GLU A  37      39.229  57.691  55.710  1.00 51.75           O  
HETATM  298  N   MSE A  38      37.168  51.941  57.638  1.00 28.72           N  
HETATM  299  CA  MSE A  38      36.342  50.727  57.581  1.00 25.82           C  
HETATM  300  C   MSE A  38      36.547  49.803  58.785  1.00 26.27           C  
HETATM  301  O   MSE A  38      35.859  48.789  58.912  1.00 23.77           O  
HETATM  302  CB  MSE A  38      36.682  49.931  56.298  1.00 27.07           C  
HETATM  303  CG  MSE A  38      36.143  50.510  55.008  1.00 22.35           C  
HETATM  304 SE   MSE A  38      36.707  49.636  53.488  1.00 11.35          SE  
HETATM  305  CE  MSE A  38      36.437  48.142  53.803  1.00 27.23           C  
ATOM    306  N   LYS A  39      37.506  50.134  59.646  1.00 24.17           N  
ATOM    307  CA  LYS A  39      37.801  49.312  60.811  1.00 24.58           C  
ATOM    308  C   LYS A  39      36.758  49.393  61.921  1.00 21.91           C  
ATOM    309  O   LYS A  39      36.037  50.368  62.036  1.00 24.06           O  
ATOM    310  CB  LYS A  39      39.171  49.685  61.392  1.00 27.08           C  
ATOM    311  CG  LYS A  39      39.192  50.996  62.152  1.00 30.33           C  
ATOM    312  CD  LYS A  39      40.609  51.355  62.590  1.00 33.93           C  
ATOM    313  CE  LYS A  39      40.635  52.693  63.307  1.00 38.22           C  
ATOM    314  NZ  LYS A  39      39.935  53.737  62.512  1.00 40.67           N  
ATOM    315  N   VAL A  40      36.683  48.353  62.743  1.00 22.58           N  
ATOM    316  CA  VAL A  40      35.747  48.353  63.858  1.00 22.23           C  
ATOM    317  C   VAL A  40      36.477  48.288  65.201  1.00 25.26           C  
ATOM    318  O   VAL A  40      35.869  48.475  66.236  1.00 25.69           O  
ATOM    319  CB  VAL A  40      34.738  47.174  63.771  1.00 24.85           C  
ATOM    320  CG1 VAL A  40      33.991  47.232  62.438  1.00 20.48           C  
ATOM    321  CG2 VAL A  40      35.446  45.841  63.946  1.00 25.17           C  
ATOM    322  N   ASP A  41      37.784  48.049  65.181  1.00 27.35           N  
ATOM    323  CA  ASP A  41      38.558  47.961  66.436  1.00 28.01           C  
ATOM    324  C   ASP A  41      40.019  48.286  66.176  1.00 29.44           C  
ATOM    325  O   ASP A  41      40.395  48.559  65.032  1.00 27.27           O  
ATOM    326  CB  ASP A  41      38.427  46.558  67.046  1.00 28.66           C  
ATOM    327  CG  ASP A  41      38.870  45.458  66.096  1.00 29.72           C  
ATOM    328  OD1 ASP A  41      38.256  44.370  66.134  1.00 34.84           O  
ATOM    329  OD2 ASP A  41      39.835  45.666  65.329  1.00 28.87           O  
ATOM    330  N   GLU A  42      40.834  48.257  67.230  1.00 31.49           N  
ATOM    331  CA  GLU A  42      42.260  48.582  67.113  1.00 34.41           C  
ATOM    332  C   GLU A  42      43.081  47.514  66.414  1.00 34.11           C  
ATOM    333  O   GLU A  42      44.216  47.768  66.014  1.00 32.00           O  
ATOM    334  CB  GLU A  42      42.882  48.836  68.492  1.00 37.84           C  
ATOM    335  CG  GLU A  42      41.968  48.596  69.676  1.00 46.19           C  
ATOM    336  CD  GLU A  42      42.736  48.277  70.958  1.00 51.60           C  
ATOM    337  OE1 GLU A  42      43.179  47.113  71.122  1.00 54.31           O  
ATOM    338  OE2 GLU A  42      42.904  49.191  71.797  1.00 54.59           O  
ATOM    339  N   LYS A  43      42.522  46.317  66.277  1.00 31.78           N  
ATOM    340  CA  LYS A  43      43.236  45.240  65.615  1.00 33.16           C  
ATOM    341  C   LYS A  43      43.137  45.358  64.099  1.00 32.68           C  
ATOM    342  O   LYS A  43      43.763  44.590  63.364  1.00 33.55           O  
ATOM    343  CB  LYS A  43      42.712  43.878  66.076  1.00 36.36           C  
ATOM    344  CG  LYS A  43      43.114  43.497  67.501  1.00 44.74           C  
ATOM    345  CD  LYS A  43      42.628  44.506  68.534  1.00 50.82           C  
ATOM    346  CE  LYS A  43      43.013  44.080  69.946  1.00 52.22           C  
ATOM    347  NZ  LYS A  43      44.489  43.887  70.071  1.00 54.89           N  
ATOM    348  N   GLY A  44      42.339  46.317  63.637  1.00 29.44           N  
ATOM    349  CA  GLY A  44      42.208  46.541  62.209  1.00 30.13           C  
ATOM    350  C   GLY A  44      41.152  45.709  61.504  1.00 28.76           C  
ATOM    351  O   GLY A  44      41.179  45.589  60.284  1.00 29.10           O  
ATOM    352  N   LEU A  45      40.229  45.131  62.261  1.00 25.99           N  
ATOM    353  CA  LEU A  45      39.186  44.318  61.662  1.00 23.00           C  
ATOM    354  C   LEU A  45      38.235  45.206  60.847  1.00 23.03           C  
ATOM    355  O   LEU A  45      37.708  46.193  61.350  1.00 21.88           O  
ATOM    356  CB  LEU A  45      38.419  43.556  62.751  1.00 22.80           C  
ATOM    357  CG  LEU A  45      37.222  42.698  62.339  1.00 22.56           C  
ATOM    358  CD1 LEU A  45      37.684  41.565  61.412  1.00 22.11           C  
ATOM    359  CD2 LEU A  45      36.560  42.123  63.595  1.00 22.01           C  
ATOM    360  N   VAL A  46      38.061  44.858  59.574  1.00 22.92           N  
ATOM    361  CA  VAL A  46      37.175  45.597  58.683  1.00 21.32           C  
ATOM    362  C   VAL A  46      35.722  45.161  58.870  1.00 21.75           C  
ATOM    363  O   VAL A  46      35.407  43.977  58.929  1.00 23.36           O  
ATOM    364  CB  VAL A  46      37.581  45.395  57.204  1.00 22.30           C  
ATOM    365  CG1 VAL A  46      36.521  46.042  56.275  1.00 24.88           C  
ATOM    366  CG2 VAL A  46      38.952  46.037  56.963  1.00 24.40           C  
ATOM    367  N   HIS A  47      34.829  46.130  58.967  1.00 23.02           N  
ATOM    368  CA  HIS A  47      33.421  45.810  59.150  1.00 23.05           C  
ATOM    369  C   HIS A  47      32.874  45.058  57.939  1.00 19.77           C  
ATOM    370  O   HIS A  47      33.110  45.449  56.798  1.00 21.34           O  
ATOM    371  CB  HIS A  47      32.629  47.102  59.382  1.00 20.56           C  
ATOM    372  CG  HIS A  47      31.219  46.868  59.817  1.00 18.10           C  
ATOM    373  ND1 HIS A  47      30.888  46.001  60.832  1.00 22.97           N  
ATOM    374  CD2 HIS A  47      30.053  47.405  59.380  1.00 20.21           C  
ATOM    375  CE1 HIS A  47      29.576  46.013  61.004  1.00 21.90           C  
ATOM    376  NE2 HIS A  47      29.048  46.857  60.132  1.00 21.03           N  
ATOM    377  N   GLY A  48      32.126  43.984  58.197  1.00 24.63           N  
ATOM    378  CA  GLY A  48      31.554  43.174  57.132  1.00 23.50           C  
ATOM    379  C   GLY A  48      30.596  43.934  56.228  1.00 24.47           C  
ATOM    380  O   GLY A  48      30.291  43.497  55.108  1.00 22.09           O  
ATOM    381  N   GLY A  49      30.116  45.081  56.702  1.00 24.71           N  
ATOM    382  CA  GLY A  49      29.214  45.864  55.874  1.00 21.38           C  
ATOM    383  C   GLY A  49      29.905  46.337  54.607  1.00 20.04           C  
ATOM    384  O   GLY A  49      29.280  46.474  53.550  1.00 21.40           O  
ATOM    385  N   PHE A  50      31.205  46.604  54.690  1.00 21.58           N  
ATOM    386  CA  PHE A  50      31.911  47.060  53.496  1.00 21.26           C  
ATOM    387  C   PHE A  50      32.130  45.925  52.497  1.00 21.66           C  
ATOM    388  O   PHE A  50      31.973  46.105  51.289  1.00 21.51           O  
ATOM    389  CB  PHE A  50      33.229  47.729  53.909  1.00 22.09           C  
ATOM    390  CG  PHE A  50      33.017  48.989  54.708  1.00 23.92           C  
ATOM    391  CD1 PHE A  50      32.579  50.153  54.081  1.00 24.93           C  
ATOM    392  CD2 PHE A  50      33.160  48.987  56.091  1.00 23.16           C  
ATOM    393  CE1 PHE A  50      32.284  51.291  54.813  1.00 23.44           C  
ATOM    394  CE2 PHE A  50      32.867  50.120  56.838  1.00 22.55           C  
ATOM    395  CZ  PHE A  50      32.428  51.277  56.205  1.00 20.40           C  
ATOM    396  N   THR A  51      32.467  44.756  53.023  1.00 19.98           N  
ATOM    397  CA  THR A  51      32.670  43.575  52.205  1.00 20.38           C  
ATOM    398  C   THR A  51      31.362  43.222  51.504  1.00 21.43           C  
ATOM    399  O   THR A  51      31.345  42.860  50.307  1.00 22.45           O  
ATOM    400  CB  THR A  51      33.098  42.405  53.075  1.00 21.38           C  
ATOM    401  OG1 THR A  51      34.231  42.800  53.848  1.00 25.17           O  
ATOM    402  CG2 THR A  51      33.471  41.206  52.203  1.00 22.72           C  
ATOM    403  N   PHE A  52      30.263  43.325  52.246  1.00 19.73           N  
ATOM    404  CA  PHE A  52      28.937  43.056  51.671  1.00 19.28           C  
ATOM    405  C   PHE A  52      28.612  44.100  50.600  1.00 20.70           C  
ATOM    406  O   PHE A  52      28.085  43.762  49.541  1.00 21.43           O  
ATOM    407  CB  PHE A  52      27.849  43.108  52.756  1.00 20.08           C  
ATOM    408  CG  PHE A  52      26.431  42.957  52.216  1.00 20.41           C  
ATOM    409  CD1 PHE A  52      25.806  41.716  52.195  1.00 22.01           C  
ATOM    410  CD2 PHE A  52      25.741  44.057  51.726  1.00 19.81           C  
ATOM    411  CE1 PHE A  52      24.496  41.574  51.684  1.00 21.48           C  
ATOM    412  CE2 PHE A  52      24.429  43.938  51.206  1.00 19.09           C  
ATOM    413  CZ  PHE A  52      23.808  42.688  51.187  1.00 19.27           C  
ATOM    414  N   GLY A  53      28.927  45.367  50.882  1.00 20.86           N  
ATOM    415  CA  GLY A  53      28.641  46.423  49.931  1.00 20.25           C  
ATOM    416  C   GLY A  53      29.369  46.144  48.635  1.00 22.69           C  
ATOM    417  O   GLY A  53      28.815  46.303  47.552  1.00 19.95           O  
ATOM    418  N   LEU A  54      30.636  45.748  48.739  1.00 22.93           N  
ATOM    419  CA  LEU A  54      31.390  45.421  47.527  1.00 23.15           C  
ATOM    420  C   LEU A  54      30.714  44.275  46.772  1.00 23.36           C  
ATOM    421  O   LEU A  54      30.525  44.347  45.545  1.00 22.91           O  
ATOM    422  CB  LEU A  54      32.839  45.036  47.873  1.00 21.49           C  
ATOM    423  CG  LEU A  54      33.633  44.253  46.810  1.00 23.94           C  
ATOM    424  CD1 LEU A  54      33.852  45.108  45.569  1.00 22.81           C  
ATOM    425  CD2 LEU A  54      34.981  43.834  47.387  1.00 20.87           C  
ATOM    426  N   ALA A  55      30.351  43.210  47.474  1.00 20.75           N  
ATOM    427  CA  ALA A  55      29.696  42.087  46.786  1.00 22.85           C  
ATOM    428  C   ALA A  55      28.359  42.495  46.140  1.00 21.22           C  
ATOM    429  O   ALA A  55      28.036  42.076  45.025  1.00 24.73           O  
ATOM    430  CB  ALA A  55      29.473  40.923  47.759  1.00 23.28           C  
ATOM    431  N   ASP A  56      27.588  43.305  46.860  1.00 21.74           N  
ATOM    432  CA  ASP A  56      26.274  43.815  46.404  1.00 23.34           C  
ATOM    433  C   ASP A  56      26.465  44.571  45.069  1.00 21.05           C  
ATOM    434  O   ASP A  56      25.744  44.347  44.094  1.00 21.93           O  
ATOM    435  CB  ASP A  56      25.727  44.759  47.505  1.00 23.69           C  
ATOM    436  CG  ASP A  56      24.392  45.432  47.147  1.00 25.72           C  
ATOM    437  OD1 ASP A  56      23.942  45.358  45.976  1.00 24.96           O  
ATOM    438  OD2 ASP A  56      23.803  46.061  48.070  1.00 23.88           O  
ATOM    439  N   TYR A  57      27.445  45.466  45.039  1.00 21.50           N  
ATOM    440  CA  TYR A  57      27.737  46.249  43.846  1.00 20.86           C  
ATOM    441  C   TYR A  57      28.143  45.351  42.674  1.00 22.49           C  
ATOM    442  O   TYR A  57      27.713  45.588  41.549  1.00 20.11           O  
ATOM    443  CB  TYR A  57      28.831  47.301  44.179  1.00 20.30           C  
ATOM    444  CG  TYR A  57      29.289  48.246  43.055  1.00 20.55           C  
ATOM    445  CD1 TYR A  57      28.385  48.762  42.111  1.00 18.26           C  
ATOM    446  CD2 TYR A  57      30.608  48.723  43.025  1.00 21.70           C  
ATOM    447  CE1 TYR A  57      28.782  49.726  41.185  1.00 20.91           C  
ATOM    448  CE2 TYR A  57      31.018  49.693  42.111  1.00 24.34           C  
ATOM    449  CZ  TYR A  57      30.095  50.199  41.194  1.00 22.85           C  
ATOM    450  OH  TYR A  57      30.463  51.217  40.342  1.00 23.74           O  
ATOM    451  N   ALA A  58      28.955  44.319  42.923  1.00 21.29           N  
ATOM    452  CA  ALA A  58      29.359  43.429  41.844  1.00 22.35           C  
ATOM    453  C   ALA A  58      28.128  42.739  41.237  1.00 22.08           C  
ATOM    454  O   ALA A  58      28.012  42.567  40.005  1.00 19.78           O  
ATOM    455  CB  ALA A  58      30.368  42.371  42.370  1.00 23.41           C  
ATOM    456  N   ALA A  59      27.213  42.347  42.111  1.00 19.83           N  
ATOM    457  CA  ALA A  59      25.979  41.686  41.711  1.00 19.91           C  
ATOM    458  C   ALA A  59      25.142  42.608  40.811  1.00 19.65           C  
ATOM    459  O   ALA A  59      24.618  42.170  39.782  1.00 23.01           O  
ATOM    460  CB  ALA A  59      25.180  41.279  42.967  1.00 20.28           C  
HETATM  461  N   MSE A  60      25.038  43.883  41.182  1.00 20.10           N  
HETATM  462  CA  MSE A  60      24.294  44.841  40.381  1.00 19.56           C  
HETATM  463  C   MSE A  60      24.940  44.952  38.994  1.00 23.59           C  
HETATM  464  O   MSE A  60      24.241  45.137  37.993  1.00 21.90           O  
HETATM  465  CB  MSE A  60      24.280  46.229  41.043  1.00 20.84           C  
HETATM  466  CG  MSE A  60      23.617  46.310  42.434  1.00 21.41           C  
HETATM  467 SE   MSE A  60      21.838  45.946  42.461  1.00 10.51          SE  
HETATM  468  CE  MSE A  60      21.871  44.331  42.458  1.00 15.99           C  
ATOM    469  N   LEU A  61      26.268  44.852  38.919  1.00 23.74           N  
ATOM    470  CA  LEU A  61      26.934  44.956  37.609  1.00 23.52           C  
ATOM    471  C   LEU A  61      26.891  43.671  36.811  1.00 24.05           C  
ATOM    472  O   LEU A  61      27.054  43.697  35.592  1.00 24.64           O  
ATOM    473  CB  LEU A  61      28.385  45.457  37.742  1.00 23.45           C  
ATOM    474  CG  LEU A  61      28.465  46.869  38.343  1.00 23.39           C  
ATOM    475  CD1 LEU A  61      29.897  47.409  38.305  1.00 23.34           C  
ATOM    476  CD2 LEU A  61      27.547  47.792  37.582  1.00 21.50           C  
ATOM    477  N   ALA A  62      26.678  42.541  37.476  1.00 23.10           N  
ATOM    478  CA  ALA A  62      26.566  41.294  36.743  1.00 23.85           C  
ATOM    479  C   ALA A  62      25.236  41.355  35.966  1.00 26.80           C  
ATOM    480  O   ALA A  62      25.099  40.730  34.914  1.00 22.65           O  
ATOM    481  CB  ALA A  62      26.594  40.101  37.687  1.00 26.07           C  
ATOM    482  N   VAL A  63      24.260  42.108  36.475  1.00 23.03           N  
ATOM    483  CA  VAL A  63      22.977  42.239  35.763  1.00 24.71           C  
ATOM    484  C   VAL A  63      23.104  43.434  34.831  1.00 25.09           C  
ATOM    485  O   VAL A  63      22.698  43.378  33.676  1.00 26.07           O  
ATOM    486  CB  VAL A  63      21.807  42.443  36.736  1.00 25.46           C  
ATOM    487  CG1 VAL A  63      20.494  42.650  35.951  1.00 30.03           C  
ATOM    488  CG2 VAL A  63      21.701  41.214  37.662  1.00 22.32           C  
ATOM    489  N   ASN A  64      23.650  44.522  35.361  1.00 25.72           N  
ATOM    490  CA  ASN A  64      23.929  45.728  34.596  1.00 28.82           C  
ATOM    491  C   ASN A  64      22.767  46.270  33.776  1.00 31.56           C  
ATOM    492  O   ASN A  64      22.901  46.547  32.586  1.00 32.22           O  
ATOM    493  CB  ASN A  64      25.137  45.473  33.683  1.00 27.54           C  
ATOM    494  CG  ASN A  64      25.719  46.753  33.104  1.00 26.05           C  
ATOM    495  OD1 ASN A  64      25.720  47.797  33.757  1.00 26.50           O  
ATOM    496  ND2 ASN A  64      26.231  46.676  31.870  1.00 26.73           N  
ATOM    497  N   GLU A  65      21.633  46.436  34.440  1.00 31.68           N  
ATOM    498  CA  GLU A  65      20.432  46.970  33.825  1.00 32.44           C  
ATOM    499  C   GLU A  65      20.193  48.237  34.637  1.00 28.42           C  
ATOM    500  O   GLU A  65      20.298  48.207  35.855  1.00 28.73           O  
ATOM    501  CB  GLU A  65      19.294  45.973  34.014  1.00 38.72           C  
ATOM    502  CG  GLU A  65      18.336  45.944  32.883  1.00 47.63           C  
ATOM    503  CD  GLU A  65      18.719  44.936  31.827  1.00 52.34           C  
ATOM    504  OE1 GLU A  65      18.405  43.736  32.018  1.00 50.58           O  
ATOM    505  OE2 GLU A  65      19.336  45.341  30.815  1.00 53.57           O  
ATOM    506  N   PRO A  66      19.870  49.368  33.986  1.00 28.02           N  
ATOM    507  CA  PRO A  66      19.640  50.633  34.699  1.00 26.76           C  
ATOM    508  C   PRO A  66      18.843  50.592  36.009  1.00 28.25           C  
ATOM    509  O   PRO A  66      19.289  51.118  37.044  1.00 29.39           O  
ATOM    510  CB  PRO A  66      18.950  51.498  33.648  1.00 30.53           C  
ATOM    511  CG  PRO A  66      19.607  51.024  32.354  1.00 27.72           C  
ATOM    512  CD  PRO A  66      19.644  49.523  32.533  1.00 27.66           C  
ATOM    513  N   THR A  67      17.672  49.966  35.955  1.00 25.20           N  
ATOM    514  CA  THR A  67      16.782  49.863  37.101  1.00 26.98           C  
ATOM    515  C   THR A  67      17.027  48.688  38.064  1.00 28.03           C  
ATOM    516  O   THR A  67      16.189  48.432  38.941  1.00 29.83           O  
ATOM    517  CB  THR A  67      15.323  49.754  36.619  1.00 26.73           C  
ATOM    518  OG1 THR A  67      15.179  48.573  35.816  1.00 27.95           O  
ATOM    519  CG2 THR A  67      14.943  50.976  35.791  1.00 25.93           C  
ATOM    520  N   VAL A  68      18.144  47.975  37.933  1.00 24.29           N  
ATOM    521  CA  VAL A  68      18.356  46.818  38.819  1.00 25.24           C  
ATOM    522  C   VAL A  68      18.452  47.228  40.299  1.00 25.17           C  
ATOM    523  O   VAL A  68      18.965  48.298  40.627  1.00 25.49           O  
ATOM    524  CB  VAL A  68      19.624  46.012  38.401  1.00 23.99           C  
ATOM    525  CG1 VAL A  68      20.877  46.857  38.624  1.00 22.08           C  
ATOM    526  CG2 VAL A  68      19.692  44.682  39.191  1.00 23.15           C  
ATOM    527  N   VAL A  69      17.908  46.399  41.186  1.00 26.69           N  
ATOM    528  CA  VAL A  69      17.963  46.674  42.621  1.00 25.47           C  
ATOM    529  C   VAL A  69      18.156  45.366  43.385  1.00 24.52           C  
ATOM    530  O   VAL A  69      17.857  44.290  42.881  1.00 24.10           O  
ATOM    531  CB  VAL A  69      16.672  47.393  43.130  1.00 26.87           C  
ATOM    532  CG1 VAL A  69      15.466  46.472  43.045  1.00 25.44           C  
ATOM    533  CG2 VAL A  69      16.872  47.845  44.550  1.00 34.00           C  
ATOM    534  N   LEU A  70      18.671  45.435  44.604  1.00 25.97           N  
ATOM    535  CA  LEU A  70      18.851  44.185  45.349  1.00 24.99           C  
ATOM    536  C   LEU A  70      17.632  43.965  46.251  1.00 23.17           C  
ATOM    537  O   LEU A  70      17.270  44.835  47.054  1.00 22.74           O  
ATOM    538  CB  LEU A  70      20.136  44.235  46.181  1.00 23.37           C  
ATOM    539  CG  LEU A  70      20.412  42.986  47.022  1.00 22.69           C  
ATOM    540  CD1 LEU A  70      20.503  41.743  46.110  1.00 17.79           C  
ATOM    541  CD2 LEU A  70      21.745  43.200  47.824  1.00 20.45           C  
ATOM    542  N   GLY A  71      16.997  42.807  46.116  1.00 24.13           N  
ATOM    543  CA  GLY A  71      15.812  42.533  46.927  1.00 24.01           C  
ATOM    544  C   GLY A  71      16.101  41.717  48.170  1.00 24.60           C  
ATOM    545  O   GLY A  71      15.570  41.985  49.257  1.00 22.19           O  
ATOM    546  N   LYS A  72      16.962  40.724  48.006  1.00 24.67           N  
ATOM    547  CA  LYS A  72      17.300  39.827  49.096  1.00 24.05           C  
ATOM    548  C   LYS A  72      18.699  39.285  48.894  1.00 21.96           C  
ATOM    549  O   LYS A  72      19.191  39.197  47.761  1.00 19.07           O  
ATOM    550  CB  LYS A  72      16.294  38.670  49.108  1.00 23.96           C  
ATOM    551  CG  LYS A  72      16.508  37.653  50.180  1.00 31.00           C  
ATOM    552  CD  LYS A  72      15.488  36.515  50.039  1.00 34.57           C  
ATOM    553  CE  LYS A  72      15.806  35.649  48.830  1.00 40.38           C  
ATOM    554  NZ  LYS A  72      15.268  34.265  48.981  1.00 43.19           N  
ATOM    555  N   ALA A  73      19.333  38.899  49.993  1.00 20.90           N  
ATOM    556  CA  ALA A  73      20.674  38.352  49.925  1.00 20.78           C  
ATOM    557  C   ALA A  73      20.916  37.411  51.092  1.00 21.81           C  
ATOM    558  O   ALA A  73      20.376  37.600  52.175  1.00 22.10           O  
ATOM    559  CB  ALA A  73      21.699  39.491  49.945  1.00 20.67           C  
ATOM    560  N   GLU A  74      21.698  36.375  50.848  1.00 18.80           N  
ATOM    561  CA  GLU A  74      22.075  35.440  51.891  1.00 24.89           C  
ATOM    562  C   GLU A  74      23.590  35.417  51.748  1.00 22.39           C  
ATOM    563  O   GLU A  74      24.109  35.181  50.654  1.00 25.26           O  
ATOM    564  CB  GLU A  74      21.475  34.063  51.612  1.00 29.09           C  
ATOM    565  CG  GLU A  74      19.942  34.099  51.596  1.00 37.38           C  
ATOM    566  CD  GLU A  74      19.333  32.869  50.948  1.00 47.07           C  
ATOM    567  OE1 GLU A  74      19.921  32.356  49.963  1.00 47.07           O  
ATOM    568  OE2 GLU A  74      18.257  32.427  51.415  1.00 50.48           O  
ATOM    569  N   VAL A  75      24.310  35.695  52.820  1.00 21.08           N  
ATOM    570  CA  VAL A  75      25.766  35.706  52.722  1.00 20.13           C  
ATOM    571  C   VAL A  75      26.410  35.018  53.916  1.00 23.39           C  
ATOM    572  O   VAL A  75      25.826  34.940  55.003  1.00 24.70           O  
ATOM    573  CB  VAL A  75      26.327  37.142  52.639  1.00 23.86           C  
ATOM    574  CG1 VAL A  75      25.820  37.842  51.357  1.00 23.91           C  
ATOM    575  CG2 VAL A  75      25.928  37.939  53.894  1.00 21.32           C  
ATOM    576  N   ARG A  76      27.605  34.495  53.689  1.00 23.55           N  
ATOM    577  CA  ARG A  76      28.390  33.835  54.728  1.00 24.06           C  
ATOM    578  C   ARG A  76      29.738  34.520  54.682  1.00 23.24           C  
ATOM    579  O   ARG A  76      30.339  34.669  53.606  1.00 21.32           O  
ATOM    580  CB  ARG A  76      28.609  32.345  54.420  1.00 27.41           C  
ATOM    581  CG  ARG A  76      27.373  31.488  54.524  1.00 37.12           C  
ATOM    582  CD  ARG A  76      27.618  30.084  53.982  1.00 40.68           C  
ATOM    583  NE  ARG A  76      26.358  29.354  53.875  1.00 47.24           N  
ATOM    584  CZ  ARG A  76      25.760  28.757  54.900  1.00 49.88           C  
ATOM    585  NH1 ARG A  76      26.321  28.797  56.106  1.00 48.22           N  
ATOM    586  NH2 ARG A  76      24.597  28.136  54.723  1.00 51.17           N  
ATOM    587  N   PHE A  77      30.208  34.963  55.835  1.00 21.78           N  
ATOM    588  CA  PHE A  77      31.504  35.608  55.901  1.00 19.95           C  
ATOM    589  C   PHE A  77      32.409  34.447  56.281  1.00 21.06           C  
ATOM    590  O   PHE A  77      32.264  33.863  57.342  1.00 23.17           O  
ATOM    591  CB  PHE A  77      31.484  36.691  56.974  1.00 23.50           C  
ATOM    592  CG  PHE A  77      30.552  37.830  56.649  1.00 23.27           C  
ATOM    593  CD1 PHE A  77      29.168  37.680  56.783  1.00 25.01           C  
ATOM    594  CD2 PHE A  77      31.050  39.033  56.193  1.00 22.76           C  
ATOM    595  CE1 PHE A  77      28.301  38.730  56.461  1.00 22.13           C  
ATOM    596  CE2 PHE A  77      30.187  40.098  55.866  1.00 22.09           C  
ATOM    597  CZ  PHE A  77      28.813  39.933  56.004  1.00 20.24           C  
ATOM    598  N   THR A  78      33.338  34.117  55.408  1.00 22.40           N  
ATOM    599  CA  THR A  78      34.190  32.954  55.620  1.00 25.14           C  
ATOM    600  C   THR A  78      35.542  33.223  56.272  1.00 26.10           C  
ATOM    601  O   THR A  78      36.090  32.346  56.954  1.00 26.48           O  
ATOM    602  CB  THR A  78      34.386  32.226  54.279  1.00 23.14           C  
ATOM    603  OG1 THR A  78      34.960  33.129  53.333  1.00 29.48           O  
ATOM    604  CG2 THR A  78      33.028  31.775  53.721  1.00 28.15           C  
ATOM    605  N   LYS A  79      36.078  34.415  56.055  1.00 23.91           N  
ATOM    606  CA  LYS A  79      37.375  34.819  56.642  1.00 27.23           C  
ATOM    607  C   LYS A  79      37.336  36.295  57.003  1.00 24.06           C  
ATOM    608  O   LYS A  79      36.760  37.093  56.265  1.00 25.32           O  
ATOM    609  CB  LYS A  79      38.516  34.620  55.653  1.00 25.73           C  
ATOM    610  CG  LYS A  79      38.881  33.184  55.361  1.00 32.32           C  
ATOM    611  CD  LYS A  79      40.069  33.171  54.406  1.00 34.98           C  
ATOM    612  CE  LYS A  79      40.837  31.859  54.481  1.00 41.57           C  
ATOM    613  NZ  LYS A  79      39.968  30.713  54.111  1.00 45.16           N  
ATOM    614  N   PRO A  80      37.956  36.682  58.139  1.00 24.23           N  
ATOM    615  CA  PRO A  80      37.965  38.083  58.555  1.00 23.12           C  
ATOM    616  C   PRO A  80      38.797  38.926  57.602  1.00 25.91           C  
ATOM    617  O   PRO A  80      39.779  38.453  57.040  1.00 27.81           O  
ATOM    618  CB  PRO A  80      38.561  38.020  59.962  1.00 24.10           C  
ATOM    619  CG  PRO A  80      39.581  36.881  59.829  1.00 24.47           C  
ATOM    620  CD  PRO A  80      38.756  35.849  59.065  1.00 23.93           C  
ATOM    621  N   VAL A  81      38.398  40.178  57.408  1.00 25.32           N  
ATOM    622  CA  VAL A  81      39.125  41.067  56.511  1.00 23.85           C  
ATOM    623  C   VAL A  81      39.817  42.115  57.370  1.00 26.14           C  
ATOM    624  O   VAL A  81      39.227  42.655  58.306  1.00 24.59           O  
ATOM    625  CB  VAL A  81      38.149  41.757  55.496  1.00 23.83           C  
ATOM    626  CG1 VAL A  81      38.869  42.849  54.710  1.00 25.21           C  
ATOM    627  CG2 VAL A  81      37.593  40.718  54.540  1.00 24.00           C  
ATOM    628  N   LYS A  82      41.074  42.394  57.049  1.00 26.25           N  
ATOM    629  CA  LYS A  82      41.860  43.354  57.812  1.00 29.25           C  
ATOM    630  C   LYS A  82      42.178  44.588  56.977  1.00 24.32           C  
ATOM    631  O   LYS A  82      42.384  44.480  55.776  1.00 27.11           O  
ATOM    632  CB  LYS A  82      43.150  42.655  58.297  1.00 31.40           C  
ATOM    633  CG  LYS A  82      44.415  43.466  58.168  1.00 40.38           C  
ATOM    634  CD  LYS A  82      45.660  42.643  58.520  1.00 44.47           C  
ATOM    635  CE  LYS A  82      45.764  42.395  60.010  1.00 48.47           C  
ATOM    636  NZ  LYS A  82      45.885  43.672  60.780  1.00 51.64           N  
ATOM    637  N   VAL A  83      42.195  45.765  57.595  1.00 28.34           N  
ATOM    638  CA  VAL A  83      42.507  46.991  56.850  1.00 30.14           C  
ATOM    639  C   VAL A  83      43.801  46.778  56.088  1.00 31.83           C  
ATOM    640  O   VAL A  83      44.766  46.261  56.645  1.00 31.34           O  
ATOM    641  CB  VAL A  83      42.693  48.209  57.778  1.00 32.48           C  
ATOM    642  CG1 VAL A  83      43.409  49.336  57.024  1.00 32.56           C  
ATOM    643  CG2 VAL A  83      41.340  48.690  58.277  1.00 35.26           C  
ATOM    644  N   GLY A  84      43.819  47.171  54.818  1.00 32.42           N  
ATOM    645  CA  GLY A  84      45.003  46.961  54.007  1.00 32.43           C  
ATOM    646  C   GLY A  84      44.785  45.825  53.021  1.00 33.35           C  
ATOM    647  O   GLY A  84      45.509  45.717  52.031  1.00 33.25           O  
ATOM    648  N   ASP A  85      43.808  44.961  53.293  1.00 29.94           N  
ATOM    649  CA  ASP A  85      43.504  43.869  52.372  1.00 27.64           C  
ATOM    650  C   ASP A  85      42.910  44.487  51.110  1.00 27.01           C  
ATOM    651  O   ASP A  85      42.209  45.493  51.169  1.00 26.53           O  
ATOM    652  CB  ASP A  85      42.458  42.891  52.960  1.00 27.86           C  
ATOM    653  CG  ASP A  85      43.002  42.030  54.088  1.00 28.44           C  
ATOM    654  OD1 ASP A  85      44.228  42.060  54.357  1.00 27.56           O  
ATOM    655  OD2 ASP A  85      42.194  41.301  54.698  1.00 25.61           O  
ATOM    656  N   LYS A  86      43.217  43.889  49.967  1.00 26.09           N  
ATOM    657  CA  LYS A  86      42.671  44.326  48.697  1.00 29.58           C  
ATOM    658  C   LYS A  86      41.703  43.192  48.384  1.00 27.51           C  
ATOM    659  O   LYS A  86      42.096  42.010  48.406  1.00 28.44           O  
ATOM    660  CB  LYS A  86      43.748  44.379  47.616  1.00 31.78           C  
ATOM    661  CG  LYS A  86      43.196  44.701  46.231  1.00 39.45           C  
ATOM    662  CD  LYS A  86      44.122  44.190  45.142  1.00 42.78           C  
ATOM    663  CE  LYS A  86      43.367  43.953  43.852  1.00 42.40           C  
ATOM    664  NZ  LYS A  86      42.653  45.192  43.451  1.00 46.89           N  
ATOM    665  N   LEU A  87      40.452  43.537  48.112  1.00 23.93           N  
ATOM    666  CA  LEU A  87      39.430  42.533  47.835  1.00 23.28           C  
ATOM    667  C   LEU A  87      38.905  42.602  46.412  1.00 24.34           C  
ATOM    668  O   LEU A  87      38.845  43.678  45.830  1.00 23.26           O  
ATOM    669  CB  LEU A  87      38.237  42.721  48.784  1.00 24.82           C  
ATOM    670  CG  LEU A  87      38.508  42.843  50.293  1.00 25.39           C  
ATOM    671  CD1 LEU A  87      37.168  43.079  51.037  1.00 28.04           C  
ATOM    672  CD2 LEU A  87      39.190  41.570  50.816  1.00 23.53           C  
ATOM    673  N   VAL A  88      38.533  41.446  45.864  1.00 20.95           N  
ATOM    674  CA  VAL A  88      37.951  41.393  44.526  1.00 22.87           C  
ATOM    675  C   VAL A  88      36.670  40.548  44.560  1.00 21.05           C  
ATOM    676  O   VAL A  88      36.697  39.373  44.889  1.00 22.76           O  
ATOM    677  CB  VAL A  88      38.891  40.763  43.476  1.00 23.98           C  
ATOM    678  CG1 VAL A  88      38.185  40.742  42.103  1.00 25.23           C  
ATOM    679  CG2 VAL A  88      40.197  41.540  43.391  1.00 24.46           C  
ATOM    680  N   ALA A  89      35.551  41.159  44.208  1.00 22.74           N  
ATOM    681  CA  ALA A  89      34.293  40.441  44.177  1.00 21.76           C  
ATOM    682  C   ALA A  89      34.028  39.990  42.735  1.00 22.72           C  
ATOM    683  O   ALA A  89      34.159  40.786  41.811  1.00 23.53           O  
ATOM    684  CB  ALA A  89      33.177  41.358  44.658  1.00 20.74           C  
ATOM    685  N   LYS A  90      33.684  38.712  42.568  1.00 23.19           N  
ATOM    686  CA  LYS A  90      33.355  38.127  41.274  1.00 23.40           C  
ATOM    687  C   LYS A  90      31.891  37.673  41.319  1.00 22.52           C  
ATOM    688  O   LYS A  90      31.530  36.781  42.077  1.00 25.01           O  
ATOM    689  CB  LYS A  90      34.306  36.960  40.971  1.00 25.37           C  
ATOM    690  CG  LYS A  90      35.769  37.444  40.931  1.00 26.52           C  
ATOM    691  CD  LYS A  90      36.769  36.378  40.500  1.00 28.62           C  
ATOM    692  CE  LYS A  90      38.193  36.903  40.737  1.00 28.96           C  
ATOM    693  NZ  LYS A  90      39.206  35.869  40.364  1.00 33.97           N  
ATOM    694  N   ALA A  91      31.062  38.310  40.497  1.00 22.13           N  
ATOM    695  CA  ALA A  91      29.616  38.059  40.448  1.00 24.25           C  
ATOM    696  C   ALA A  91      29.129  37.462  39.127  1.00 26.81           C  
ATOM    697  O   ALA A  91      29.459  37.969  38.067  1.00 26.06           O  
ATOM    698  CB  ALA A  91      28.876  39.370  40.707  1.00 19.61           C  
ATOM    699  N   LYS A  92      28.344  36.388  39.195  1.00 30.68           N  
ATOM    700  CA  LYS A  92      27.810  35.771  37.975  1.00 26.91           C  
ATOM    701  C   LYS A  92      26.321  35.454  38.111  1.00 25.39           C  
ATOM    702  O   LYS A  92      25.882  34.968  39.147  1.00 24.73           O  
ATOM    703  CB  LYS A  92      28.563  34.482  37.635  1.00 32.73           C  
ATOM    704  CG  LYS A  92      28.014  33.803  36.354  1.00 34.85           C  
ATOM    705  CD  LYS A  92      28.870  32.646  35.884  1.00 43.20           C  
ATOM    706  CE  LYS A  92      28.849  31.474  36.847  1.00 45.96           C  
ATOM    707  NZ  LYS A  92      29.480  30.260  36.213  1.00 50.00           N  
ATOM    708  N   ILE A  93      25.539  35.771  37.083  1.00 24.74           N  
ATOM    709  CA  ILE A  93      24.122  35.458  37.116  1.00 25.09           C  
ATOM    710  C   ILE A  93      24.066  33.937  37.009  1.00 30.26           C  
ATOM    711  O   ILE A  93      24.607  33.367  36.066  1.00 26.59           O  
ATOM    712  CB  ILE A  93      23.376  36.075  35.926  1.00 26.23           C  
ATOM    713  CG1 ILE A  93      23.368  37.602  36.054  1.00 22.16           C  
ATOM    714  CG2 ILE A  93      21.944  35.552  35.884  1.00 25.44           C  
ATOM    715  CD1 ILE A  93      22.697  38.303  34.875  1.00 26.38           C  
ATOM    716  N   ILE A  94      23.462  33.272  37.991  1.00 29.14           N  
ATOM    717  CA  ILE A  94      23.390  31.815  37.941  1.00 31.10           C  
ATOM    718  C   ILE A  94      21.994  31.311  37.584  1.00 31.77           C  
ATOM    719  O   ILE A  94      21.815  30.128  37.270  1.00 32.27           O  
ATOM    720  CB  ILE A  94      23.849  31.141  39.266  1.00 30.52           C  
ATOM    721  CG1 ILE A  94      23.033  31.669  40.453  1.00 32.17           C  
ATOM    722  CG2 ILE A  94      25.352  31.361  39.471  1.00 28.72           C  
ATOM    723  CD1 ILE A  94      23.203  30.820  41.718  1.00 33.76           C  
ATOM    724  N   GLU A  95      21.011  32.206  37.639  1.00 30.84           N  
ATOM    725  CA  GLU A  95      19.644  31.867  37.276  1.00 32.61           C  
ATOM    726  C   GLU A  95      18.966  33.100  36.732  1.00 35.15           C  
ATOM    727  O   GLU A  95      18.913  34.140  37.390  1.00 32.25           O  
ATOM    728  CB  GLU A  95      18.843  31.369  38.482  1.00 38.29           C  
ATOM    729  CG  GLU A  95      19.075  29.923  38.851  1.00 45.86           C  
ATOM    730  CD  GLU A  95      18.238  29.494  40.048  1.00 46.46           C  
ATOM    731  OE1 GLU A  95      16.992  29.504  39.942  1.00 45.22           O  
ATOM    732  OE2 GLU A  95      18.833  29.157  41.090  1.00 48.42           O  
ATOM    733  N   ASP A  96      18.458  33.007  35.513  1.00 36.97           N  
ATOM    734  CA  ASP A  96      17.765  34.148  34.947  1.00 41.16           C  
ATOM    735  C   ASP A  96      16.286  33.809  34.941  1.00 42.77           C  
ATOM    736  O   ASP A  96      15.836  32.959  34.176  1.00 43.10           O  
ATOM    737  CB  ASP A  96      18.233  34.431  33.526  1.00 43.50           C  
ATOM    738  CG  ASP A  96      17.672  35.730  32.995  1.00 48.71           C  
ATOM    739  OD1 ASP A  96      16.427  35.887  33.003  1.00 46.90           O  
ATOM    740  OD2 ASP A  96      18.477  36.598  32.586  1.00 52.60           O  
ATOM    741  N   LEU A  97      15.537  34.479  35.805  1.00 42.12           N  
ATOM    742  CA  LEU A  97      14.108  34.245  35.927  1.00 43.48           C  
ATOM    743  C   LEU A  97      13.363  35.471  35.404  1.00 42.51           C  
ATOM    744  O   LEU A  97      12.460  36.000  36.051  1.00 42.29           O  
ATOM    745  CB  LEU A  97      13.776  33.975  37.400  1.00 42.98           C  
ATOM    746  CG  LEU A  97      14.703  32.898  37.980  1.00 42.68           C  
ATOM    747  CD1 LEU A  97      14.592  32.846  39.492  1.00 44.88           C  
ATOM    748  CD2 LEU A  97      14.358  31.546  37.363  1.00 47.45           C  
ATOM    749  N   GLY A  98      13.754  35.907  34.211  1.00 44.30           N  
ATOM    750  CA  GLY A  98      13.146  37.074  33.609  1.00 43.18           C  
ATOM    751  C   GLY A  98      13.595  38.335  34.325  1.00 42.47           C  
ATOM    752  O   GLY A  98      14.776  38.675  34.320  1.00 41.46           O  
ATOM    753  N   LYS A  99      12.650  39.018  34.962  1.00 39.53           N  
ATOM    754  CA  LYS A  99      12.938  40.249  35.676  1.00 39.01           C  
ATOM    755  C   LYS A  99      13.672  39.997  36.980  1.00 37.99           C  
ATOM    756  O   LYS A  99      14.211  40.921  37.573  1.00 34.22           O  
ATOM    757  CB  LYS A  99      11.649  41.030  35.940  1.00 44.44           C  
ATOM    758  CG  LYS A  99      10.459  40.199  36.423  1.00 51.14           C  
ATOM    759  CD  LYS A  99       9.972  39.169  35.387  1.00 53.20           C  
ATOM    760  CE  LYS A  99       8.498  38.831  35.583  1.00 55.72           C  
ATOM    761  NZ  LYS A  99       8.132  38.650  37.019  1.00 53.96           N  
ATOM    762  N   LYS A 100      13.671  38.749  37.437  1.00 36.03           N  
ATOM    763  CA  LYS A 100      14.395  38.411  38.651  1.00 35.31           C  
ATOM    764  C   LYS A 100      15.630  37.643  38.227  1.00 33.25           C  
ATOM    765  O   LYS A 100      15.554  36.745  37.372  1.00 34.91           O  
ATOM    766  CB  LYS A 100      13.573  37.540  39.607  1.00 39.34           C  
ATOM    767  CG  LYS A 100      14.304  37.342  40.951  1.00 43.67           C  
ATOM    768  CD  LYS A 100      13.520  36.548  41.998  1.00 45.83           C  
ATOM    769  CE  LYS A 100      13.792  35.054  41.887  1.00 48.16           C  
ATOM    770  NZ  LYS A 100      13.208  34.277  43.014  1.00 47.86           N  
ATOM    771  N   LYS A 101      16.764  37.994  38.833  1.00 29.88           N  
ATOM    772  CA  LYS A 101      18.038  37.366  38.537  1.00 28.87           C  
ATOM    773  C   LYS A 101      18.703  36.883  39.829  1.00 26.79           C  
ATOM    774  O   LYS A 101      18.754  37.615  40.807  1.00 25.43           O  
ATOM    775  CB  LYS A 101      18.952  38.386  37.862  1.00 29.41           C  
ATOM    776  CG  LYS A 101      18.282  39.176  36.734  1.00 35.13           C  
ATOM    777  CD  LYS A 101      18.114  38.316  35.492  1.00 36.93           C  
ATOM    778  CE  LYS A 101      17.571  39.119  34.308  1.00 40.57           C  
ATOM    779  NZ  LYS A 101      18.367  40.343  34.023  1.00 43.99           N  
ATOM    780  N   ILE A 102      19.184  35.646  39.845  1.00 25.33           N  
ATOM    781  CA  ILE A 102      19.874  35.133  41.028  1.00 24.72           C  
ATOM    782  C   ILE A 102      21.362  35.219  40.681  1.00 25.70           C  
ATOM    783  O   ILE A 102      21.816  34.651  39.693  1.00 26.34           O  
ATOM    784  CB  ILE A 102      19.473  33.683  41.342  1.00 26.88           C  
ATOM    785  CG1 ILE A 102      17.984  33.626  41.690  1.00 31.28           C  
ATOM    786  CG2 ILE A 102      20.277  33.157  42.521  1.00 25.53           C  
ATOM    787  CD1 ILE A 102      17.444  32.192  41.880  1.00 30.33           C  
ATOM    788  N   VAL A 103      22.116  35.957  41.483  1.00 23.63           N  
ATOM    789  CA  VAL A 103      23.534  36.149  41.208  1.00 20.43           C  
ATOM    790  C   VAL A 103      24.363  35.587  42.346  1.00 22.94           C  
ATOM    791  O   VAL A 103      24.079  35.850  43.507  1.00 20.90           O  
ATOM    792  CB  VAL A 103      23.831  37.645  41.073  1.00 22.16           C  
ATOM    793  CG1 VAL A 103      25.306  37.874  40.787  1.00 22.92           C  
ATOM    794  CG2 VAL A 103      22.946  38.234  39.970  1.00 26.99           C  
ATOM    795  N   GLU A 104      25.371  34.795  42.016  1.00 22.11           N  
ATOM    796  CA  GLU A 104      26.230  34.249  43.050  1.00 24.05           C  
ATOM    797  C   GLU A 104      27.444  35.168  43.085  1.00 23.96           C  
ATOM    798  O   GLU A 104      27.924  35.614  42.041  1.00 22.23           O  
ATOM    799  CB  GLU A 104      26.660  32.819  42.704  1.00 25.88           C  
ATOM    800  CG  GLU A 104      27.646  32.227  43.705  1.00 36.09           C  
ATOM    801  CD  GLU A 104      27.897  30.748  43.474  1.00 44.83           C  
ATOM    802  OE1 GLU A 104      28.153  30.371  42.305  1.00 47.52           O  
ATOM    803  OE2 GLU A 104      27.840  29.971  44.458  1.00 44.12           O  
ATOM    804  N   VAL A 105      27.928  35.486  44.276  1.00 22.11           N  
ATOM    805  CA  VAL A 105      29.090  36.353  44.374  1.00 21.37           C  
ATOM    806  C   VAL A 105      30.064  35.766  45.384  1.00 24.17           C  
ATOM    807  O   VAL A 105      29.669  35.237  46.429  1.00 24.72           O  
ATOM    808  CB  VAL A 105      28.720  37.796  44.858  1.00 21.53           C  
ATOM    809  CG1 VAL A 105      29.958  38.654  44.888  1.00 20.92           C  
ATOM    810  CG2 VAL A 105      27.682  38.434  43.947  1.00 22.75           C  
ATOM    811  N   LYS A 106      31.339  35.842  45.052  1.00 23.15           N  
ATOM    812  CA  LYS A 106      32.369  35.369  45.949  1.00 28.68           C  
ATOM    813  C   LYS A 106      33.361  36.511  46.008  1.00 27.82           C  
ATOM    814  O   LYS A 106      33.710  37.089  44.976  1.00 26.69           O  
ATOM    815  CB  LYS A 106      33.030  34.091  45.408  1.00 26.85           C  
ATOM    816  CG  LYS A 106      32.242  32.834  45.739  1.00 33.88           C  
ATOM    817  CD  LYS A 106      33.107  31.591  45.640  1.00 40.67           C  
ATOM    818  CE  LYS A 106      32.799  30.797  44.395  1.00 43.28           C  
ATOM    819  NZ  LYS A 106      31.407  30.278  44.470  1.00 47.43           N  
ATOM    820  N   VAL A 107      33.769  36.879  47.217  1.00 26.12           N  
ATOM    821  CA  VAL A 107      34.729  37.950  47.356  1.00 24.33           C  
ATOM    822  C   VAL A 107      36.050  37.299  47.748  1.00 25.96           C  
ATOM    823  O   VAL A 107      36.087  36.504  48.686  1.00 25.86           O  
ATOM    824  CB  VAL A 107      34.304  38.952  48.426  1.00 24.34           C  
ATOM    825  CG1 VAL A 107      35.365  40.052  48.553  1.00 23.36           C  
ATOM    826  CG2 VAL A 107      32.936  39.561  48.049  1.00 21.05           C  
ATOM    827  N   TYR A 108      37.113  37.642  47.019  1.00 26.71           N  
ATOM    828  CA  TYR A 108      38.450  37.076  47.253  1.00 27.29           C  
ATOM    829  C   TYR A 108      39.493  38.055  47.759  1.00 28.11           C  
ATOM    830  O   TYR A 108      39.421  39.260  47.504  1.00 25.01           O  
ATOM    831  CB  TYR A 108      39.029  36.496  45.944  1.00 29.47           C  
ATOM    832  CG  TYR A 108      38.198  35.415  45.280  1.00 31.98           C  
ATOM    833  CD1 TYR A 108      37.071  35.738  44.513  1.00 31.55           C  
ATOM    834  CD2 TYR A 108      38.511  34.071  45.455  1.00 32.26           C  
ATOM    835  CE1 TYR A 108      36.270  34.738  43.945  1.00 32.54           C  
ATOM    836  CE2 TYR A 108      37.729  33.065  44.893  1.00 34.01           C  
ATOM    837  CZ  TYR A 108      36.609  33.400  44.141  1.00 32.85           C  
ATOM    838  OH  TYR A 108      35.825  32.397  43.605  1.00 32.86           O  
ATOM    839  N   ARG A 109      40.476  37.519  48.473  1.00 27.81           N  
ATOM    840  CA  ARG A 109      41.627  38.306  48.916  1.00 29.34           C  
ATOM    841  C   ARG A 109      42.674  37.375  48.311  1.00 32.85           C  
ATOM    842  O   ARG A 109      42.975  36.329  48.869  1.00 30.28           O  
ATOM    843  CB  ARG A 109      41.755  38.349  50.437  1.00 30.44           C  
ATOM    844  CG  ARG A 109      43.006  39.101  50.904  1.00 30.72           C  
ATOM    845  CD  ARG A 109      43.011  39.179  52.405  1.00 24.85           C  
ATOM    846  NE  ARG A 109      42.921  37.846  52.977  1.00 26.57           N  
ATOM    847  CZ  ARG A 109      42.312  37.579  54.126  1.00 29.89           C  
ATOM    848  NH1 ARG A 109      41.745  38.563  54.811  1.00 28.10           N  
ATOM    849  NH2 ARG A 109      42.263  36.335  54.583  1.00 28.95           N  
ATOM    850  N   GLU A 110      43.171  37.743  47.133  1.00 35.49           N  
ATOM    851  CA  GLU A 110      44.097  36.900  46.390  1.00 38.64           C  
ATOM    852  C   GLU A 110      43.315  35.615  46.086  1.00 37.81           C  
ATOM    853  O   GLU A 110      42.294  35.682  45.394  1.00 38.35           O  
ATOM    854  CB  GLU A 110      45.368  36.649  47.199  1.00 42.69           C  
ATOM    855  CG  GLU A 110      46.061  37.968  47.554  1.00 48.67           C  
ATOM    856  CD  GLU A 110      47.440  37.785  48.128  1.00 55.05           C  
ATOM    857  OE1 GLU A 110      47.579  37.047  49.126  1.00 60.77           O  
ATOM    858  OE2 GLU A 110      48.393  38.388  47.583  1.00 60.47           O  
ATOM    859  N   GLU A 111      43.734  34.464  46.602  1.00 36.70           N  
ATOM    860  CA  GLU A 111      42.993  33.229  46.298  1.00 36.52           C  
ATOM    861  C   GLU A 111      41.972  32.802  47.343  1.00 32.54           C  
ATOM    862  O   GLU A 111      41.159  31.916  47.099  1.00 30.83           O  
ATOM    863  CB  GLU A 111      43.963  32.059  46.067  1.00 41.55           C  
ATOM    864  CG  GLU A 111      44.834  32.185  44.832  1.00 49.33           C  
ATOM    865  CD  GLU A 111      44.019  32.384  43.575  1.00 55.19           C  
ATOM    866  OE1 GLU A 111      43.448  33.488  43.408  1.00 60.58           O  
ATOM    867  OE2 GLU A 111      43.943  31.436  42.758  1.00 59.34           O  
ATOM    868  N   GLU A 112      42.013  33.428  48.510  1.00 31.86           N  
ATOM    869  CA  GLU A 112      41.099  33.069  49.582  1.00 30.55           C  
ATOM    870  C   GLU A 112      39.715  33.700  49.447  1.00 28.76           C  
ATOM    871  O   GLU A 112      39.585  34.863  49.077  1.00 29.23           O  
ATOM    872  CB  GLU A 112      41.658  33.517  50.926  1.00 32.61           C  
ATOM    873  CG  GLU A 112      43.133  33.289  51.144  1.00 35.07           C  
ATOM    874  CD  GLU A 112      43.654  34.155  52.280  1.00 37.04           C  
ATOM    875  OE1 GLU A 112      44.428  35.107  52.010  1.00 41.05           O  
ATOM    876  OE2 GLU A 112      43.274  33.897  53.440  1.00 37.66           O  
ATOM    877  N   VAL A 113      38.690  32.926  49.771  1.00 27.24           N  
ATOM    878  CA  VAL A 113      37.328  33.434  49.762  1.00 27.48           C  
ATOM    879  C   VAL A 113      37.072  34.046  51.150  1.00 26.46           C  
ATOM    880  O   VAL A 113      37.333  33.397  52.171  1.00 24.99           O  
ATOM    881  CB  VAL A 113      36.322  32.297  49.494  1.00 28.14           C  
ATOM    882  CG1 VAL A 113      34.896  32.793  49.692  1.00 31.01           C  
ATOM    883  CG2 VAL A 113      36.506  31.783  48.047  1.00 30.45           C  
ATOM    884  N   VAL A 114      36.609  35.298  51.193  1.00 23.21           N  
ATOM    885  CA  VAL A 114      36.308  35.950  52.466  1.00 22.08           C  
ATOM    886  C   VAL A 114      34.790  36.105  52.627  1.00 26.01           C  
ATOM    887  O   VAL A 114      34.296  36.322  53.728  1.00 24.06           O  
ATOM    888  CB  VAL A 114      36.997  37.349  52.592  1.00 23.69           C  
ATOM    889  CG1 VAL A 114      38.513  37.189  52.475  1.00 27.19           C  
ATOM    890  CG2 VAL A 114      36.476  38.319  51.517  1.00 24.21           C  
ATOM    891  N   LEU A 115      34.057  36.017  51.515  1.00 23.27           N  
ATOM    892  CA  LEU A 115      32.601  36.094  51.561  1.00 24.54           C  
ATOM    893  C   LEU A 115      31.995  35.339  50.385  1.00 23.38           C  
ATOM    894  O   LEU A 115      32.541  35.361  49.292  1.00 26.09           O  
ATOM    895  CB  LEU A 115      32.113  37.560  51.512  1.00 21.20           C  
ATOM    896  CG  LEU A 115      30.569  37.725  51.496  1.00 22.13           C  
ATOM    897  CD1 LEU A 115      30.189  39.022  52.204  1.00 24.50           C  
ATOM    898  CD2 LEU A 115      30.013  37.717  50.047  1.00 20.46           C  
ATOM    899  N   GLU A 116      30.872  34.669  50.610  1.00 25.26           N  
ATOM    900  CA  GLU A 116      30.181  33.985  49.520  1.00 26.82           C  
ATOM    901  C   GLU A 116      28.702  34.256  49.724  1.00 26.81           C  
ATOM    902  O   GLU A 116      28.202  34.266  50.859  1.00 22.11           O  
ATOM    903  CB  GLU A 116      30.446  32.461  49.526  1.00 32.17           C  
ATOM    904  CG  GLU A 116      30.227  31.786  50.886  1.00 43.55           C  
ATOM    905  CD  GLU A 116      30.314  30.266  50.837  1.00 47.95           C  
ATOM    906  OE1 GLU A 116      31.191  29.747  50.112  1.00 50.00           O  
ATOM    907  OE2 GLU A 116      29.513  29.599  51.539  1.00 49.69           O  
ATOM    908  N   GLY A 117      27.980  34.479  48.637  1.00 22.27           N  
ATOM    909  CA  GLY A 117      26.568  34.744  48.817  1.00 25.64           C  
ATOM    910  C   GLY A 117      25.734  34.669  47.569  1.00 23.59           C  
ATOM    911  O   GLY A 117      26.273  34.624  46.465  1.00 23.48           O  
ATOM    912  N   LYS A 118      24.418  34.620  47.764  1.00 22.32           N  
ATOM    913  CA  LYS A 118      23.462  34.607  46.673  1.00 25.16           C  
ATOM    914  C   LYS A 118      22.720  35.932  46.771  1.00 23.49           C  
ATOM    915  O   LYS A 118      22.253  36.303  47.849  1.00 24.12           O  
ATOM    916  CB  LYS A 118      22.463  33.463  46.820  1.00 26.72           C  
ATOM    917  CG  LYS A 118      23.033  32.101  46.483  1.00 36.57           C  
ATOM    918  CD  LYS A 118      21.924  31.137  46.061  1.00 36.00           C  
ATOM    919  CE  LYS A 118      22.433  29.699  46.088  1.00 42.84           C  
ATOM    920  NZ  LYS A 118      23.911  29.649  45.867  1.00 42.36           N  
ATOM    921  N   PHE A 119      22.639  36.653  45.661  1.00 20.71           N  
ATOM    922  CA  PHE A 119      21.957  37.941  45.632  1.00 22.05           C  
ATOM    923  C   PHE A 119      20.775  37.854  44.656  1.00 25.42           C  
ATOM    924  O   PHE A 119      20.951  37.519  43.479  1.00 26.10           O  
ATOM    925  CB  PHE A 119      22.944  39.036  45.210  1.00 22.63           C  
ATOM    926  CG  PHE A 119      24.055  39.259  46.209  1.00 23.02           C  
ATOM    927  CD1 PHE A 119      25.029  38.287  46.415  1.00 24.69           C  
ATOM    928  CD2 PHE A 119      24.070  40.401  47.003  1.00 21.89           C  
ATOM    929  CE1 PHE A 119      26.010  38.454  47.418  1.00 26.51           C  
ATOM    930  CE2 PHE A 119      25.035  40.576  47.994  1.00 24.55           C  
ATOM    931  CZ  PHE A 119      25.999  39.608  48.202  1.00 24.55           C  
ATOM    932  N   TYR A 120      19.579  38.138  45.167  1.00 24.26           N  
ATOM    933  CA  TYR A 120      18.340  38.084  44.388  1.00 25.26           C  
ATOM    934  C   TYR A 120      18.044  39.502  43.941  1.00 23.96           C  
ATOM    935  O   TYR A 120      17.634  40.356  44.740  1.00 24.70           O  
ATOM    936  CB  TYR A 120      17.203  37.502  45.245  1.00 22.22           C  
ATOM    937  CG  TYR A 120      17.531  36.134  45.805  1.00 27.18           C  
ATOM    938  CD1 TYR A 120      18.539  35.978  46.752  1.00 23.23           C  
ATOM    939  CD2 TYR A 120      16.860  34.988  45.361  1.00 27.39           C  
ATOM    940  CE1 TYR A 120      18.877  34.727  47.244  1.00 31.18           C  
ATOM    941  CE2 TYR A 120      17.193  33.732  45.845  1.00 27.41           C  
ATOM    942  CZ  TYR A 120      18.203  33.609  46.786  1.00 27.38           C  
ATOM    943  OH  TYR A 120      18.565  32.381  47.276  1.00 35.06           O  
ATOM    944  N   CYS A 121      18.267  39.726  42.647  1.00 23.48           N  
ATOM    945  CA  CYS A 121      18.136  41.024  42.015  1.00 24.78           C  
ATOM    946  C   CYS A 121      16.899  41.161  41.121  1.00 26.91           C  
ATOM    947  O   CYS A 121      16.457  40.191  40.489  1.00 24.79           O  
ATOM    948  CB  CYS A 121      19.399  41.293  41.179  1.00 24.68           C  
ATOM    949  SG  CYS A 121      20.969  40.788  42.004  1.00 29.15           S  
ATOM    950  N   TYR A 122      16.363  42.382  41.071  1.00 23.20           N  
ATOM    951  CA  TYR A 122      15.170  42.661  40.277  1.00 27.05           C  
ATOM    952  C   TYR A 122      15.359  43.821  39.332  1.00 26.85           C  
ATOM    953  O   TYR A 122      15.782  44.894  39.745  1.00 22.59           O  
ATOM    954  CB  TYR A 122      13.997  43.007  41.198  1.00 28.74           C  
ATOM    955  CG  TYR A 122      13.528  41.843  42.018  1.00 32.10           C  
ATOM    956  CD1 TYR A 122      12.623  40.913  41.491  1.00 35.84           C  
ATOM    957  CD2 TYR A 122      14.011  41.644  43.306  1.00 34.28           C  
ATOM    958  CE1 TYR A 122      12.208  39.808  42.235  1.00 37.88           C  
ATOM    959  CE2 TYR A 122      13.616  40.550  44.058  1.00 37.77           C  
ATOM    960  CZ  TYR A 122      12.717  39.633  43.521  1.00 38.76           C  
ATOM    961  OH  TYR A 122      12.363  38.533  44.254  1.00 40.31           O  
ATOM    962  N   VAL A 123      15.018  43.607  38.070  1.00 29.23           N  
ATOM    963  CA  VAL A 123      15.089  44.667  37.088  1.00 28.29           C  
ATOM    964  C   VAL A 123      13.665  45.226  37.060  1.00 30.67           C  
ATOM    965  O   VAL A 123      12.715  44.529  36.670  1.00 29.87           O  
ATOM    966  CB  VAL A 123      15.489  44.099  35.723  1.00 30.27           C  
ATOM    967  CG1 VAL A 123      15.499  45.198  34.678  1.00 25.37           C  
ATOM    968  CG2 VAL A 123      16.873  43.447  35.835  1.00 29.92           C  
ATOM    969  N   LEU A 124      13.524  46.470  37.491  1.00 29.97           N  
ATOM    970  CA  LEU A 124      12.220  47.125  37.584  1.00 32.86           C  
ATOM    971  C   LEU A 124      11.809  47.863  36.321  1.00 34.45           C  
ATOM    972  O   LEU A 124      12.655  48.243  35.513  1.00 30.88           O  
ATOM    973  CB  LEU A 124      12.234  48.109  38.761  1.00 34.31           C  
ATOM    974  CG  LEU A 124      12.864  47.567  40.056  1.00 34.54           C  
ATOM    975  CD1 LEU A 124      12.980  48.667  41.110  1.00 30.85           C  
ATOM    976  CD2 LEU A 124      12.030  46.424  40.591  1.00 34.85           C  
ATOM    977  N   GLU A 125      10.500  48.052  36.158  1.00 35.16           N  
ATOM    978  CA  GLU A 125       9.966  48.774  35.005  1.00 37.09           C  
ATOM    979  C   GLU A 125      10.511  50.197  35.070  1.00 34.61           C  
ATOM    980  O   GLU A 125      10.890  50.791  34.055  1.00 33.65           O  
ATOM    981  CB  GLU A 125       8.429  48.811  35.060  1.00 42.65           C  
ATOM    982  CG  GLU A 125       7.789  49.606  33.915  1.00 50.49           C  
ATOM    983  CD  GLU A 125       7.561  48.769  32.664  1.00 55.19           C  
ATOM    984  OE1 GLU A 125       6.399  48.360  32.427  1.00 57.56           O  
ATOM    985  OE2 GLU A 125       8.540  48.508  31.928  1.00 57.44           O  
ATOM    986  N   LYS A 126      10.542  50.740  36.279  1.00 32.45           N  
ATOM    987  CA  LYS A 126      11.052  52.078  36.499  1.00 34.27           C  
ATOM    988  C   LYS A 126      12.060  52.040  37.636  1.00 35.06           C  
ATOM    989  O   LYS A 126      12.170  51.040  38.348  1.00 33.47           O  
ATOM    990  CB  LYS A 126       9.921  53.046  36.859  1.00 39.61           C  
ATOM    991  CG  LYS A 126      10.397  54.476  37.091  1.00 46.03           C  
ATOM    992  CD  LYS A 126      11.407  54.907  36.023  1.00 51.36           C  
ATOM    993  CE  LYS A 126      11.877  56.332  36.223  1.00 52.66           C  
ATOM    994  NZ  LYS A 126      12.469  56.563  37.566  1.00 57.17           N  
ATOM    995  N   HIS A 127      12.780  53.142  37.802  1.00 29.91           N  
ATOM    996  CA  HIS A 127      13.783  53.259  38.837  1.00 32.81           C  
ATOM    997  C   HIS A 127      13.088  53.126  40.182  1.00 32.33           C  
ATOM    998  O   HIS A 127      12.005  53.670  40.387  1.00 31.68           O  
ATOM    999  CB  HIS A 127      14.490  54.614  38.714  1.00 31.31           C  
ATOM   1000  CG  HIS A 127      15.626  54.791  39.671  1.00 33.01           C  
ATOM   1001  ND1 HIS A 127      15.441  55.179  40.983  1.00 32.73           N  
ATOM   1002  CD2 HIS A 127      16.961  54.641  39.503  1.00 31.03           C  
ATOM   1003  CE1 HIS A 127      16.618  55.264  41.578  1.00 35.48           C  
ATOM   1004  NE2 HIS A 127      17.557  54.944  40.705  1.00 30.98           N  
ATOM   1005  N   VAL A 128      13.739  52.419  41.094  1.00 29.99           N  
ATOM   1006  CA  VAL A 128      13.203  52.154  42.417  1.00 29.10           C  
ATOM   1007  C   VAL A 128      12.697  53.356  43.194  1.00 30.58           C  
ATOM   1008  O   VAL A 128      11.811  53.209  44.034  1.00 33.25           O  
ATOM   1009  CB  VAL A 128      14.239  51.396  43.273  1.00 28.85           C  
ATOM   1010  CG1 VAL A 128      15.331  52.355  43.748  1.00 24.48           C  
ATOM   1011  CG2 VAL A 128      13.542  50.692  44.416  1.00 27.76           C  
ATOM   1012  N   LEU A 129      13.251  54.538  42.941  1.00 31.10           N  
ATOM   1013  CA  LEU A 129      12.792  55.728  43.642  1.00 34.87           C  
ATOM   1014  C   LEU A 129      11.669  56.426  42.855  1.00 39.77           C  
ATOM   1015  O   LEU A 129      11.426  57.619  43.036  1.00 40.64           O  
ATOM   1016  CB  LEU A 129      13.953  56.710  43.879  1.00 33.45           C  
ATOM   1017  CG  LEU A 129      14.983  56.260  44.928  1.00 34.08           C  
ATOM   1018  CD1 LEU A 129      16.105  57.270  45.036  1.00 33.10           C  
ATOM   1019  CD2 LEU A 129      14.290  56.104  46.287  1.00 32.89           C  
ATOM   1020  N   ASP A 130      10.996  55.672  41.994  1.00 42.89           N  
ATOM   1021  CA  ASP A 130       9.894  56.198  41.183  1.00 50.18           C  
ATOM   1022  C   ASP A 130      10.438  57.115  40.114  1.00 51.62           C  
ATOM   1023  O   ASP A 130      10.527  56.658  38.957  1.00 52.74           O  
ATOM   1024  CB  ASP A 130       8.893  56.986  42.044  1.00 53.79           C  
ATOM   1025  CG  ASP A 130       7.763  56.118  42.585  1.00 59.65           C  
ATOM   1026  OD1 ASP A 130       8.054  55.108  43.260  1.00 64.42           O  
ATOM   1027  OD2 ASP A 130       6.579  56.452  42.340  1.00 61.99           O  
TER    1028      ASP A 130                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
