
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 (  956),  selected  132 , name 2pim_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 2pim_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     5_A      T       6           -
LGA    Y     6_A      D       7           -
LGA    F     7_A      F       8           #
LGA    S     8_A      F       9          5.432
LGA    R     9_A      G      10          4.362
LGA    X    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    R    12_A      -       -           -
LGA    G    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    A    15_A      -       -           -
LGA    P    16_A      L      11          4.600
LGA    V    17_A      T      12          2.723
LGA    P    18_A      I      13          1.218
LGA    A    19_A      P      14          1.481
LGA    V    20_A      F      15          1.972
LGA    A    21_A      M      16          2.045
LGA    G    22_A      Q      17          1.258
LGA    T    23_A      L      18          1.813
LGA    L    24_A      L      19          2.320
LGA    G    25_A      G      20          2.122
LGA    G    26_A      V      21          2.065
LGA    V    27_A      V      22          1.701
LGA    I    28_A      P      23          1.910
LGA    R    29_A      E      24          1.705
LGA    A    30_A      H      25          2.455
LGA    V    31_A      S      26          2.978
LGA    D    32_A      G      27          3.406
LGA    L    33_A      N      28          1.470
LGA    E    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    G    36_A      G      29          1.190
LGA    S    37_A      T      30          0.875
LGA    L    38_A      A      31          1.052
LGA    E    39_A      R      32          0.919
LGA    S    40_A      T      33          1.020
LGA    D    41_A      R      34          0.921
LGA    Y    42_A      L      35          1.485
LGA    V    43_A      P      36          2.456
LGA    A    44_A      A      37          3.959
LGA    T    45_A      R      38          1.977
LGA    D    46_A      A      39          1.043
LGA    A    47_A      D      40          1.801
LGA    F    48_A      L      41          2.183
LGA    L    49_A      V      42          1.690
LGA    N    50_A      N      43          1.890
LGA    P    51_A      S      44          1.826
LGA    V    52_A      R      45          1.703
LGA    G    53_A      G      46          0.565
LGA    Q    54_A      D      47          0.782
LGA    V    55_A      I      48          1.293
LGA    Q    56_A      H      49          1.493
LGA    G    57_A      G      50          1.235
LGA    G    58_A      G      51          1.642
LGA    X    59_A      T      52          1.441
LGA    L    60_A      L      53          0.768
LGA    G    61_A      M      54          0.844
LGA    A    62_A      S      55          0.704
LGA    X    63_A      V      56          1.019
LGA    L    64_A      L      57          0.649
LGA    D    65_A      D      58          0.575
LGA    D    66_A      F      59          0.968
LGA    V    67_A      T      60          0.683
LGA    T    68_A      L      61          0.448
LGA    A    69_A      G      62          1.454
LGA    X    70_A      A      63          1.835
LGA    L    71_A      A      64          1.893
LGA    V    72_A      I      65          1.932
LGA    T    73_A      R      66          2.280
LGA    A    74_A      G      67          1.764
LGA    T    75_A      D      68          2.899
LGA    L    76_A      T      69          3.205
LGA    E    77_A      P      70          5.533
LGA    D    78_A      E      71          2.611
LGA    G    79_A      -       -           -
LGA    A    80_A      V      72          3.031
LGA    S    81_A      G      73          1.005
LGA    C    82_A      V      74          0.503
LGA    S    83_A      A      75          0.402
LGA    T    84_A      T      76          0.202
LGA    L    85_A      I      77          0.591
LGA    N    86_A      D      78          0.458
LGA    L    87_A      M      79          0.717
LGA    N    88_A      N      80          0.307
LGA    L    89_A      T      81          0.344
LGA    S    90_A      S      82          0.297
LGA    F    91_A      F      83          0.443
LGA    L    92_A      M      84          0.554
LGA    R    93_A      S      85          0.344
LGA    P    94_A      P      86          0.397
LGA    A    95_A      G      87          0.892
LGA    Q    96_A      R      88          1.799
LGA    A    97_A      -       -           -
LGA    G    98_A      G      89          3.137
LGA    L    99_A      D      90          1.551
LGA    L   100_A      L      91          0.893
LGA    R   101_A      V      92          0.268
LGA    G   102_A      I      93          0.346
LGA    R   103_A      E      94          0.075
LGA    A   104_A      T      95          0.600
LGA    R   105_A      R      96          0.345
LGA    L   106_A      C      97          0.528
LGA    E   107_A      L      98          0.572
LGA    R   108_A      R      99          0.528
LGA    R   109_A      R     100          1.005
LGA    G   110_A      G     101          1.100
LGA    R   111_A      A     102          1.017
LGA    N   112_A      S     103          0.719
LGA    V   113_A      I     104          0.812
LGA    C   114_A      A     105          0.762
LGA    N   115_A      F     106          0.477
LGA    V   116_A      C     107          0.529
LGA    V   117_A      E     108          0.515
LGA    G   118_A      G     109          1.256
LGA    E   119_A      E     110          0.540
LGA    L   120_A      I     111          0.542
LGA    S   121_A      R     112          0.798
LGA    Q   122_A      D     113          0.868
LGA    D   123_A      S     114          1.643
LGA    G   124_A      A     115          2.744
LGA    K   125_A      G     116          3.054
LGA    -       -      E     117           -
LGA    L   126_A      L     118          1.228
LGA    V   127_A      V     119          0.301
LGA    A   128_A      A     120          0.470
LGA    T   129_A      K     121          0.675
LGA    A   130_A      A     122          0.514
LGA    T   131_A      T     123          0.152
LGA    A   132_A      A     124          0.751
LGA    T   133_A      T     125          0.362
LGA    C   134_A      F     126          0.396
LGA    X   135_A      K     127          0.809
LGA    V   136_A      I     128          0.856
LGA    -       -      I     129           -
LGA    -       -      Q     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  125    5.0    119    1.74    26.89     87.316     6.468

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.279988 * X  +  -0.752952 * Y  +  -0.595542 * Z  +  48.469288
  Y_new =  -0.740028 * X  +  -0.564450 * Y  +   0.365725 * Z  +  81.937782
  Z_new =  -0.611527 * X  +   0.338319 * Y  +  -0.715245 * Z  +  54.609177 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.699768   -0.441824  [ DEG:   154.6853    -25.3147 ]
  Theta =   0.657989    2.483604  [ DEG:    37.7000    142.3000 ]
  Phi   =  -1.209093    1.932499  [ DEG:   -69.2760    110.7240 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pim_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pim_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  125   5.0  119   1.74   26.89  87.316
REMARK  ---------------------------------------------------------- 
MOLECULE 2pim_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   13-APR-07   2PIM              
TITLE     CRYSTAL STRUCTURE OF PHENYLACETIC ACID DEGRADATION-RELATED            
TITLE    2 PROTEIN (YP_298971.1) FROM RALSTONIA EUTROPHA JMP134 AT              
TITLE    3 2.20 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHENYLACETIC ACID DEGRADATION-RELATED PROTEIN;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RALSTONIA EUTROPHA JMP134;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YP_298971.1, REUT_B4779;                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_298971.1, THIOESTERASE SUPERFAMILY, PHENYLACETIC ACID              
KEYWDS   2 DEGRADATION-RELATED PROTEIN, STRUCTURAL GENOMICS, JOINT              
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE              
KEYWDS   4 INITIATIVE, PSI-2                                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   01-MAY-07 2PIM    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PHENYLACETIC ACID                       
JRNL        TITL 2 DEGRADATION-RELATED PROTEIN (YP_298971.1) FROM               
JRNL        TITL 3 RALSTONIA EUTROPHA JMP134 AT 2.20 A RESOLUTION               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2PIM A    1   140  UNP    Q46RV7   Q46RV7_RALEJ     1    140             
SEQRES   1 A  141  GLY MSE SER GLN ASP ASN TYR PHE SER ARG MSE LEU ARG          
SEQRES   2 A  141  GLY GLU ALA PRO VAL PRO ALA VAL ALA GLY THR LEU GLY          
SEQRES   3 A  141  GLY VAL ILE ARG ALA VAL ASP LEU GLU ALA GLY SER LEU          
SEQRES   4 A  141  GLU SER ASP TYR VAL ALA THR ASP ALA PHE LEU ASN PRO          
SEQRES   5 A  141  VAL GLY GLN VAL GLN GLY GLY MSE LEU GLY ALA MSE LEU          
SEQRES   6 A  141  ASP ASP VAL THR ALA MSE LEU VAL THR ALA THR LEU GLU          
SEQRES   7 A  141  ASP GLY ALA SER CYS SER THR LEU ASN LEU ASN LEU SER          
SEQRES   8 A  141  PHE LEU ARG PRO ALA GLN ALA GLY LEU LEU ARG GLY ARG          
SEQRES   9 A  141  ALA ARG LEU GLU ARG ARG GLY ARG ASN VAL CYS ASN VAL          
SEQRES  10 A  141  VAL GLY GLU LEU SER GLN ASP GLY LYS LEU VAL ALA THR          
SEQRES  11 A  141  ALA THR ALA THR CYS MSE VAL ALA ARG ARG ALA                  
HET    MSE  A  10       8                                                       
HET    MSE  A  59       8                                                       
HET    MSE  A  63       8                                                       
HET    MSE  A  70       8                                                       
HET    MSE  A 135       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *55(H2 O)                                                     
CRYST1  111.774  111.774   46.461  90.00  90.00 120.00 P 6 2 2      12          
ATOM      1  N   ASN A   5      22.753  51.247  27.307  1.00 21.60           N  
ATOM      2  CA  ASN A   5      22.968  50.664  28.690  1.00 25.73           C  
ATOM      3  C   ASN A   5      23.516  51.727  29.634  1.00 25.40           C  
ATOM      4  O   ASN A   5      24.580  52.278  29.364  1.00 26.15           O  
ATOM      5  CB  ASN A   5      23.996  49.513  28.612  1.00 26.26           C  
ATOM      6  CG  ASN A   5      23.735  48.404  29.577  1.00 27.49           C  
ATOM      7  OD1 ASN A   5      22.604  48.134  29.923  1.00 37.80           O  
ATOM      8  ND2 ASN A   5      24.793  47.698  29.974  1.00 39.83           N  
ATOM      9  N   TYR A   6      22.820  52.027  30.728  1.00 24.80           N  
ATOM     10  CA  TYR A   6      23.418  52.908  31.715  1.00 26.44           C  
ATOM     11  C   TYR A   6      24.808  52.387  32.101  1.00 25.60           C  
ATOM     12  O   TYR A   6      25.749  53.148  32.197  1.00 26.58           O  
ATOM     13  CB  TYR A   6      22.562  53.058  32.985  1.00 30.12           C  
ATOM     14  CG  TYR A   6      23.395  53.473  34.203  1.00 28.37           C  
ATOM     15  CD1 TYR A   6      23.609  54.826  34.519  1.00 34.20           C  
ATOM     16  CD2 TYR A   6      23.997  52.500  35.022  1.00 44.02           C  
ATOM     17  CE1 TYR A   6      24.394  55.196  35.627  1.00 33.53           C  
ATOM     18  CE2 TYR A   6      24.778  52.851  36.134  1.00 39.71           C  
ATOM     19  CZ  TYR A   6      24.975  54.193  36.426  1.00 40.39           C  
ATOM     20  OH  TYR A   6      25.748  54.500  37.524  1.00 39.96           O  
ATOM     21  N   PHE A   7      24.911  51.087  32.341  1.00 26.25           N  
ATOM     22  CA  PHE A   7      26.164  50.463  32.799  1.00 24.97           C  
ATOM     23  C   PHE A   7      27.353  50.720  31.847  1.00 26.11           C  
ATOM     24  O   PHE A   7      28.458  51.043  32.292  1.00 25.41           O  
ATOM     25  CB  PHE A   7      25.953  48.967  32.924  1.00 21.11           C  
ATOM     26  CG  PHE A   7      27.204  48.200  33.163  1.00 16.71           C  
ATOM     27  CD1 PHE A   7      27.660  47.980  34.456  1.00 22.02           C  
ATOM     28  CD2 PHE A   7      27.915  47.663  32.109  1.00 19.72           C  
ATOM     29  CE1 PHE A   7      28.813  47.285  34.683  1.00 18.72           C  
ATOM     30  CE2 PHE A   7      29.072  46.951  32.333  1.00 21.83           C  
ATOM     31  CZ  PHE A   7      29.512  46.751  33.615  1.00 19.75           C  
ATOM     32  N   SER A   8      27.141  50.539  30.548  1.00 25.10           N  
ATOM     33  CA  SER A   8      28.251  50.687  29.616  1.00 28.17           C  
ATOM     34  C   SER A   8      28.597  52.161  29.401  1.00 28.92           C  
ATOM     35  O   SER A   8      29.752  52.475  29.141  1.00 30.95           O  
ATOM     36  CB  SER A   8      27.995  49.964  28.293  1.00 27.38           C  
ATOM     37  OG  SER A   8      26.852  50.497  27.695  1.00 31.87           O  
ATOM     38  N   ARG A   9      27.613  53.054  29.537  1.00 28.80           N  
ATOM     39  CA  ARG A   9      27.882  54.498  29.595  1.00 29.06           C  
ATOM     40  C   ARG A   9      28.782  54.825  30.784  1.00 29.46           C  
ATOM     41  O   ARG A   9      29.752  55.566  30.668  1.00 29.54           O  
ATOM     42  CB  ARG A   9      26.580  55.305  29.685  1.00 27.40           C  
ATOM     43  CG  ARG A   9      25.805  55.346  28.392  1.00 27.49           C  
ATOM     44  CD  ARG A   9      24.748  56.426  28.417  1.00 29.63           C  
ATOM     45  NE  ARG A   9      23.643  56.098  29.319  1.00 30.05           N  
ATOM     46  CZ  ARG A   9      22.603  55.333  28.989  1.00 27.93           C  
ATOM     47  NH1 ARG A   9      22.513  54.790  27.782  1.00 28.32           N  
ATOM     48  NH2 ARG A   9      21.646  55.099  29.875  1.00 25.40           N  
HETATM   49  N   MSE A  10      28.447  54.265  31.929  1.00 32.07           N  
HETATM   50  CA  MSE A  10      29.252  54.427  33.133  1.00 34.15           C  
HETATM   51  C   MSE A  10      30.708  53.952  32.941  1.00 33.00           C  
HETATM   52  O   MSE A  10      31.631  54.606  33.399  1.00 34.16           O  
HETATM   53  CB  MSE A  10      28.591  53.679  34.284  1.00 33.62           C  
HETATM   54  CG  MSE A  10      29.246  53.890  35.633  1.00 33.82           C  
HETATM   55 SE   MSE A  10      28.974  52.349  36.746  0.75 44.27          SE  
HETATM   56  CE  MSE A  10      30.545  51.307  36.158  1.00 47.91           C  
ATOM     57  N   LEU A  11      30.908  52.827  32.267  1.00 33.40           N  
ATOM     58  CA  LEU A  11      32.253  52.291  32.036  1.00 35.21           C  
ATOM     59  C   LEU A  11      33.160  53.156  31.192  1.00 36.59           C  
ATOM     60  O   LEU A  11      34.366  53.102  31.347  1.00 40.28           O  
ATOM     61  CB  LEU A  11      32.195  50.953  31.314  1.00 35.60           C  
ATOM     62  CG  LEU A  11      31.825  49.729  32.116  1.00 35.88           C  
ATOM     63  CD1 LEU A  11      31.952  48.525  31.198  1.00 34.66           C  
ATOM     64  CD2 LEU A  11      32.716  49.593  33.315  1.00 36.44           C  
ATOM     65  N   ARG A  12      32.596  53.908  30.267  1.00 35.59           N  
ATOM     66  CA  ARG A  12      33.405  54.726  29.372  1.00 35.69           C  
ATOM     67  C   ARG A  12      33.368  56.197  29.796  1.00 35.49           C  
ATOM     68  O   ARG A  12      33.669  57.090  29.008  1.00 38.13           O  
ATOM     69  CB  ARG A  12      32.970  54.525  27.914  1.00 34.84           C  
ATOM     70  CG  ARG A  12      31.522  54.837  27.644  1.00 35.25           C  
ATOM     71  CD  ARG A  12      31.182  54.707  26.184  1.00 36.54           C  
ATOM     72  NE  ARG A  12      29.794  55.103  25.940  1.00 37.56           N  
ATOM     73  CZ  ARG A  12      28.799  54.279  25.596  1.00 38.90           C  
ATOM     74  NH1 ARG A  12      28.993  52.970  25.408  1.00 34.62           N  
ATOM     75  NH2 ARG A  12      27.584  54.785  25.408  1.00 41.74           N  
ATOM     76  N   GLY A  13      33.021  56.433  31.058  1.00 35.48           N  
ATOM     77  CA  GLY A  13      33.055  57.764  31.633  1.00 34.79           C  
ATOM     78  C   GLY A  13      31.927  58.687  31.216  1.00 34.73           C  
ATOM     79  O   GLY A  13      31.999  59.882  31.478  1.00 36.17           O  
ATOM     80  N   GLU A  14      30.884  58.167  30.578  1.00 33.34           N  
ATOM     81  CA  GLU A  14      29.821  59.040  30.065  1.00 34.72           C  
ATOM     82  C   GLU A  14      28.576  59.064  30.941  1.00 34.03           C  
ATOM     83  O   GLU A  14      27.548  59.646  30.575  1.00 31.64           O  
ATOM     84  CB  GLU A  14      29.481  58.676  28.614  1.00 35.75           C  
ATOM     85  CG  GLU A  14      30.691  58.689  27.669  1.00 40.18           C  
ATOM     86  CD  GLU A  14      31.302  60.091  27.441  1.00 51.04           C  
ATOM     87  OE1 GLU A  14      31.015  61.050  28.204  1.00 47.51           O  
ATOM     88  OE2 GLU A  14      32.070  60.234  26.455  1.00 56.16           O  
ATOM     89  N   ALA A  15      28.696  58.425  32.100  1.00 34.76           N  
ATOM     90  CA  ALA A  15      27.708  58.488  33.162  1.00 36.26           C  
ATOM     91  C   ALA A  15      28.427  58.323  34.509  1.00 36.16           C  
ATOM     92  O   ALA A  15      29.503  57.696  34.581  1.00 31.09           O  
ATOM     93  CB  ALA A  15      26.649  57.397  32.992  1.00 37.56           C  
ATOM     94  N   PRO A  16      27.843  58.911  35.573  1.00 38.51           N  
ATOM     95  CA  PRO A  16      28.443  58.872  36.913  1.00 37.70           C  
ATOM     96  C   PRO A  16      28.464  57.479  37.542  1.00 35.59           C  
ATOM     97  O   PRO A  16      27.470  56.732  37.488  1.00 30.65           O  
ATOM     98  CB  PRO A  16      27.550  59.822  37.722  1.00 39.28           C  
ATOM     99  CG  PRO A  16      26.219  59.795  37.009  1.00 40.47           C  
ATOM    100  CD  PRO A  16      26.575  59.679  35.559  1.00 39.58           C  
ATOM    101  N   VAL A  17      29.616  57.139  38.110  1.00 35.94           N  
ATOM    102  CA  VAL A  17      29.713  55.992  39.003  1.00 37.34           C  
ATOM    103  C   VAL A  17      28.878  56.362  40.226  1.00 35.86           C  
ATOM    104  O   VAL A  17      28.896  57.525  40.644  1.00 36.76           O  
ATOM    105  CB  VAL A  17      31.180  55.710  39.430  1.00 38.86           C  
ATOM    106  CG1 VAL A  17      31.258  54.515  40.382  1.00 40.25           C  
ATOM    107  CG2 VAL A  17      32.066  55.476  38.194  1.00 43.84           C  
ATOM    108  N   PRO A  18      28.131  55.395  40.789  1.00 33.04           N  
ATOM    109  CA  PRO A  18      27.401  55.674  42.030  1.00 32.87           C  
ATOM    110  C   PRO A  18      28.355  56.079  43.135  1.00 30.44           C  
ATOM    111  O   PRO A  18      29.433  55.508  43.230  1.00 29.74           O  
ATOM    112  CB  PRO A  18      26.752  54.334  42.378  1.00 32.28           C  
ATOM    113  CG  PRO A  18      26.784  53.532  41.109  1.00 35.43           C  
ATOM    114  CD  PRO A  18      27.935  54.016  40.319  1.00 32.11           C  
ATOM    115  N   ALA A  19      27.957  57.043  43.963  1.00 29.39           N  
ATOM    116  CA  ALA A  19      28.793  57.508  45.052  1.00 27.04           C  
ATOM    117  C   ALA A  19      29.283  56.358  45.935  1.00 27.22           C  
ATOM    118  O   ALA A  19      30.444  56.341  46.347  1.00 25.84           O  
ATOM    119  CB  ALA A  19      28.054  58.513  45.877  1.00 29.60           C  
ATOM    120  N   VAL A  20      28.416  55.386  46.206  1.00 27.33           N  
ATOM    121  CA  VAL A  20      28.780  54.278  47.090  1.00 26.34           C  
ATOM    122  C   VAL A  20      29.953  53.462  46.537  1.00 27.59           C  
ATOM    123  O   VAL A  20      30.808  53.010  47.296  1.00 30.42           O  
ATOM    124  CB  VAL A  20      27.542  53.382  47.471  1.00 26.45           C  
ATOM    125  CG1 VAL A  20      26.878  52.703  46.236  1.00 21.02           C  
ATOM    126  CG2 VAL A  20      27.937  52.339  48.517  1.00 26.85           C  
ATOM    127  N   ALA A  21      30.023  53.290  45.228  1.00 28.33           N  
ATOM    128  CA  ALA A  21      31.177  52.611  44.607  1.00 30.14           C  
ATOM    129  C   ALA A  21      32.485  53.375  44.804  1.00 30.41           C  
ATOM    130  O   ALA A  21      33.501  52.783  45.114  1.00 32.75           O  
ATOM    131  CB  ALA A  21      30.923  52.384  43.139  1.00 35.03           C  
ATOM    132  N   GLY A  22      32.458  54.688  44.645  1.00 32.06           N  
ATOM    133  CA  GLY A  22      33.552  55.541  45.110  1.00 30.87           C  
ATOM    134  C   GLY A  22      33.940  55.228  46.554  1.00 31.22           C  
ATOM    135  O   GLY A  22      35.082  54.960  46.866  1.00 33.04           O  
ATOM    136  N   THR A  23      32.978  55.243  47.451  1.00 30.14           N  
ATOM    137  CA  THR A  23      33.258  55.005  48.849  1.00 28.44           C  
ATOM    138  C   THR A  23      33.957  53.649  49.063  1.00 27.90           C  
ATOM    139  O   THR A  23      34.899  53.551  49.833  1.00 29.50           O  
ATOM    140  CB  THR A  23      31.935  55.116  49.620  1.00 29.41           C  
ATOM    141  OG1 THR A  23      31.413  56.428  49.417  1.00 34.17           O  
ATOM    142  CG2 THR A  23      32.066  54.832  51.099  1.00 23.74           C  
ATOM    143  N   LEU A  24      33.513  52.615  48.346  1.00 27.98           N  
ATOM    144  CA  LEU A  24      34.111  51.269  48.452  1.00 28.81           C  
ATOM    145  C   LEU A  24      35.368  51.035  47.600  1.00 30.21           C  
ATOM    146  O   LEU A  24      35.947  49.948  47.659  1.00 31.25           O  
ATOM    147  CB  LEU A  24      33.051  50.213  48.130  1.00 31.29           C  
ATOM    148  CG  LEU A  24      31.787  50.345  49.005  1.00 31.65           C  
ATOM    149  CD1 LEU A  24      30.689  49.517  48.414  1.00 31.26           C  
ATOM    150  CD2 LEU A  24      32.096  49.967  50.452  1.00 31.42           C  
ATOM    151  N   GLY A  25      35.820  52.066  46.865  1.00 31.18           N  
ATOM    152  CA  GLY A  25      37.006  51.977  45.983  1.00 28.48           C  
ATOM    153  C   GLY A  25      36.754  51.020  44.832  1.00 30.29           C  
ATOM    154  O   GLY A  25      37.650  50.320  44.383  1.00 30.76           O  
ATOM    155  N   GLY A  26      35.507  50.982  44.362  1.00 30.62           N  
ATOM    156  CA  GLY A  26      35.072  50.021  43.377  1.00 30.33           C  
ATOM    157  C   GLY A  26      35.563  50.359  41.984  1.00 29.59           C  
ATOM    158  O   GLY A  26      35.386  51.485  41.520  1.00 30.45           O  
ATOM    159  N   VAL A  27      36.194  49.393  41.323  1.00 29.88           N  
ATOM    160  CA  VAL A  27      36.696  49.577  39.943  1.00 28.04           C  
ATOM    161  C   VAL A  27      36.480  48.290  39.205  1.00 28.03           C  
ATOM    162  O   VAL A  27      37.106  47.256  39.525  1.00 24.61           O  
ATOM    163  CB  VAL A  27      38.215  49.914  39.872  1.00 27.75           C  
ATOM    164  CG1 VAL A  27      38.629  50.174  38.458  1.00 23.89           C  
ATOM    165  CG2 VAL A  27      38.559  51.110  40.730  1.00 29.44           C  
ATOM    166  N   ILE A  28      35.624  48.370  38.189  1.00 29.03           N  
ATOM    167  CA  ILE A  28      35.251  47.219  37.383  1.00 27.65           C  
ATOM    168  C   ILE A  28      36.457  46.793  36.575  1.00 28.92           C  
ATOM    169  O   ILE A  28      37.036  47.586  35.848  1.00 27.34           O  
ATOM    170  CB  ILE A  28      34.135  47.570  36.387  1.00 29.60           C  
ATOM    171  CG1 ILE A  28      32.876  48.090  37.095  1.00 31.08           C  
ATOM    172  CG2 ILE A  28      33.829  46.381  35.493  1.00 31.28           C  
ATOM    173  CD1 ILE A  28      32.172  47.110  37.841  1.00 30.86           C  
ATOM    174  N   ARG A  29      36.835  45.528  36.683  1.00 29.00           N  
ATOM    175  CA  ARG A  29      37.991  45.040  35.960  1.00 27.23           C  
ATOM    176  C   ARG A  29      37.622  44.124  34.782  1.00 26.43           C  
ATOM    177  O   ARG A  29      38.410  43.988  33.898  1.00 25.86           O  
ATOM    178  CB  ARG A  29      38.940  44.315  36.927  1.00 27.51           C  
ATOM    179  CG  ARG A  29      39.424  45.164  38.078  1.00 30.34           C  
ATOM    180  CD  ARG A  29      40.125  46.444  37.593  1.00 29.89           C  
ATOM    181  NE  ARG A  29      41.300  46.159  36.772  1.00 20.46           N  
ATOM    182  CZ  ARG A  29      42.509  45.878  37.255  1.00 21.69           C  
ATOM    183  NH1 ARG A  29      42.709  45.844  38.560  1.00 23.97           N  
ATOM    184  NH2 ARG A  29      43.535  45.682  36.429  1.00 21.66           N  
ATOM    185  N   ALA A  30      36.441  43.510  34.766  1.00 26.70           N  
ATOM    186  CA  ALA A  30      36.092  42.534  33.738  1.00 25.79           C  
ATOM    187  C   ALA A  30      34.605  42.335  33.670  1.00 27.29           C  
ATOM    188  O   ALA A  30      33.919  42.384  34.695  1.00 28.14           O  
ATOM    189  CB  ALA A  30      36.774  41.198  34.014  1.00 25.63           C  
ATOM    190  N   VAL A  31      34.097  42.158  32.457  1.00 27.38           N  
ATOM    191  CA  VAL A  31      32.691  41.811  32.256  1.00 27.71           C  
ATOM    192  C   VAL A  31      32.597  40.793  31.143  1.00 28.22           C  
ATOM    193  O   VAL A  31      33.348  40.843  30.174  1.00 30.66           O  
ATOM    194  CB  VAL A  31      31.805  43.010  31.843  1.00 28.68           C  
ATOM    195  CG1 VAL A  31      30.357  42.750  32.254  1.00 28.96           C  
ATOM    196  CG2 VAL A  31      32.283  44.291  32.461  1.00 32.15           C  
ATOM    197  N   ASP A  32      31.675  39.860  31.285  1.00 28.27           N  
ATOM    198  CA  ASP A  32      31.417  38.886  30.247  1.00 27.08           C  
ATOM    199  C   ASP A  32      29.927  38.630  30.285  1.00 26.83           C  
ATOM    200  O   ASP A  32      29.429  37.881  31.118  1.00 24.49           O  
ATOM    201  CB  ASP A  32      32.216  37.616  30.521  1.00 29.42           C  
ATOM    202  CG  ASP A  32      32.306  36.682  29.311  1.00 30.47           C  
ATOM    203  OD1 ASP A  32      31.412  36.657  28.432  1.00 32.20           O  
ATOM    204  OD2 ASP A  32      33.294  35.929  29.274  1.00 36.23           O  
ATOM    205  N   LEU A  33      29.211  39.286  29.384  1.00 28.83           N  
ATOM    206  CA  LEU A  33      27.761  39.229  29.394  1.00 31.17           C  
ATOM    207  C   LEU A  33      27.223  37.903  28.895  1.00 32.11           C  
ATOM    208  O   LEU A  33      26.130  37.525  29.282  1.00 33.49           O  
ATOM    209  CB  LEU A  33      27.182  40.394  28.593  1.00 33.35           C  
ATOM    210  CG  LEU A  33      27.408  41.731  29.309  1.00 34.03           C  
ATOM    211  CD1 LEU A  33      27.358  42.873  28.316  1.00 44.81           C  
ATOM    212  CD2 LEU A  33      26.401  41.913  30.391  1.00 36.07           C  
ATOM    213  N   GLU A  34      27.989  37.190  28.070  1.00 31.46           N  
ATOM    214  CA  GLU A  34      27.583  35.869  27.589  1.00 31.41           C  
ATOM    215  C   GLU A  34      27.823  34.790  28.651  1.00 29.20           C  
ATOM    216  O   GLU A  34      26.970  33.932  28.864  1.00 30.76           O  
ATOM    217  CB  GLU A  34      28.313  35.515  26.297  1.00 31.10           C  
ATOM    218  CG  GLU A  34      27.501  34.567  25.415  1.00 38.22           C  
ATOM    219  CD  GLU A  34      28.236  34.154  24.160  1.00 38.11           C  
ATOM    220  OE1 GLU A  34      29.255  34.804  23.814  1.00 51.12           O  
ATOM    221  OE2 GLU A  34      27.794  33.177  23.511  1.00 51.80           O  
ATOM    222  N   ALA A  35      28.973  34.839  29.314  1.00 26.71           N  
ATOM    223  CA  ALA A  35      29.243  33.982  30.472  1.00 26.80           C  
ATOM    224  C   ALA A  35      28.422  34.396  31.688  1.00 27.93           C  
ATOM    225  O   ALA A  35      28.167  33.575  32.549  1.00 31.06           O  
ATOM    226  CB  ALA A  35      30.692  34.016  30.837  1.00 27.70           C  
ATOM    227  N   GLY A  36      28.031  35.668  31.767  1.00 26.12           N  
ATOM    228  CA  GLY A  36      27.214  36.165  32.859  1.00 24.78           C  
ATOM    229  C   GLY A  36      28.068  36.368  34.076  1.00 24.93           C  
ATOM    230  O   GLY A  36      27.730  35.904  35.138  1.00 24.11           O  
ATOM    231  N   SER A  37      29.185  37.075  33.914  1.00 25.36           N  
ATOM    232  CA  SER A  37      30.144  37.254  34.997  1.00 25.88           C  
ATOM    233  C   SER A  37      30.678  38.677  34.971  1.00 26.15           C  
ATOM    234  O   SER A  37      30.559  39.384  33.975  1.00 22.93           O  
ATOM    235  CB  SER A  37      31.290  36.255  34.864  1.00 28.28           C  
ATOM    236  OG  SER A  37      32.126  36.529  33.734  1.00 31.93           O  
ATOM    237  N   LEU A  38      31.234  39.096  36.094  1.00 26.53           N  
ATOM    238  CA  LEU A  38      31.751  40.429  36.245  1.00 27.27           C  
ATOM    239  C   LEU A  38      32.759  40.394  37.388  1.00 27.97           C  
ATOM    240  O   LEU A  38      32.630  39.618  38.298  1.00 22.20           O  
ATOM    241  CB  LEU A  38      30.621  41.425  36.537  1.00 29.52           C  
ATOM    242  CG  LEU A  38      31.005  42.909  36.696  1.00 26.91           C  
ATOM    243  CD1 LEU A  38      30.007  43.845  36.036  1.00 32.84           C  
ATOM    244  CD2 LEU A  38      31.143  43.255  38.145  1.00 27.33           C  
ATOM    245  N   GLU A  39      33.762  41.257  37.311  1.00 28.12           N  
ATOM    246  CA  GLU A  39      34.814  41.317  38.302  1.00 30.37           C  
ATOM    247  C   GLU A  39      35.040  42.794  38.648  1.00 27.75           C  
ATOM    248  O   GLU A  39      35.000  43.644  37.762  1.00 24.00           O  
ATOM    249  CB  GLU A  39      36.048  40.693  37.685  1.00 32.87           C  
ATOM    250  CG  GLU A  39      37.099  40.187  38.635  1.00 44.02           C  
ATOM    251  CD  GLU A  39      37.930  39.013  38.032  1.00 36.23           C  
ATOM    252  OE1 GLU A  39      37.483  37.845  38.002  1.00 43.54           O  
ATOM    253  OE2 GLU A  39      39.043  39.277  37.578  1.00 58.67           O  
ATOM    254  N   SER A  40      35.183  43.097  39.934  1.00 25.28           N  
ATOM    255  CA  SER A  40      35.480  44.440  40.387  1.00 25.88           C  
ATOM    256  C   SER A  40      36.498  44.413  41.541  1.00 25.40           C  
ATOM    257  O   SER A  40      36.494  43.512  42.388  1.00 25.82           O  
ATOM    258  CB  SER A  40      34.184  45.149  40.819  1.00 26.09           C  
ATOM    259  OG  SER A  40      34.410  46.495  41.240  1.00 26.57           O  
ATOM    260  N   ASP A  41      37.367  45.409  41.563  1.00 25.70           N  
ATOM    261  CA  ASP A  41      38.203  45.666  42.721  1.00 28.76           C  
ATOM    262  C   ASP A  41      37.435  46.485  43.754  1.00 27.43           C  
ATOM    263  O   ASP A  41      36.536  47.221  43.388  1.00 29.31           O  
ATOM    264  CB  ASP A  41      39.427  46.472  42.312  1.00 28.52           C  
ATOM    265  CG  ASP A  41      40.389  45.681  41.482  1.00 33.78           C  
ATOM    266  OD1 ASP A  41      40.481  44.462  41.705  1.00 31.81           O  
ATOM    267  OD2 ASP A  41      41.058  46.290  40.624  1.00 26.15           O  
ATOM    268  N   TYR A  42      37.822  46.351  45.018  1.00 25.36           N  
ATOM    269  CA  TYR A  42      37.315  47.161  46.109  1.00 29.16           C  
ATOM    270  C   TYR A  42      38.511  47.485  47.023  1.00 31.88           C  
ATOM    271  O   TYR A  42      39.535  46.778  46.996  1.00 30.70           O  
ATOM    272  CB  TYR A  42      36.149  46.437  46.871  1.00 30.08           C  
ATOM    273  CG  TYR A  42      34.941  46.227  45.971  1.00 28.61           C  
ATOM    274  CD1 TYR A  42      34.070  47.268  45.690  1.00 25.97           C  
ATOM    275  CD2 TYR A  42      34.726  45.013  45.342  1.00 32.23           C  
ATOM    276  CE1 TYR A  42      33.002  47.100  44.842  1.00 26.35           C  
ATOM    277  CE2 TYR A  42      33.673  44.838  44.468  1.00 20.10           C  
ATOM    278  CZ  TYR A  42      32.826  45.885  44.201  1.00 27.85           C  
ATOM    279  OH  TYR A  42      31.799  45.706  43.297  1.00 30.49           O  
ATOM    280  N   VAL A  43      38.397  48.571  47.795  1.00 30.40           N  
ATOM    281  CA  VAL A  43      39.428  48.939  48.774  1.00 30.31           C  
ATOM    282  C   VAL A  43      38.724  49.049  50.132  1.00 33.03           C  
ATOM    283  O   VAL A  43      37.728  49.764  50.263  1.00 31.58           O  
ATOM    284  CB  VAL A  43      40.142  50.271  48.438  1.00 30.40           C  
ATOM    285  CG1 VAL A  43      41.096  50.679  49.556  1.00 29.67           C  
ATOM    286  CG2 VAL A  43      40.911  50.177  47.129  1.00 26.15           C  
ATOM    287  N   ALA A  44      39.222  48.295  51.117  1.00 31.62           N  
ATOM    288  CA  ALA A  44      38.784  48.448  52.490  1.00 30.54           C  
ATOM    289  C   ALA A  44      39.727  49.482  53.133  1.00 28.34           C  
ATOM    290  O   ALA A  44      40.941  49.319  53.096  1.00 28.04           O  
ATOM    291  CB  ALA A  44      38.825  47.103  53.217  1.00 29.22           C  
ATOM    292  N   THR A  45      39.170  50.556  53.686  1.00 28.25           N  
ATOM    293  CA  THR A  45      39.981  51.581  54.356  1.00 27.01           C  
ATOM    294  C   THR A  45      40.071  51.318  55.857  1.00 26.19           C  
ATOM    295  O   THR A  45      39.382  50.446  56.368  1.00 24.10           O  
ATOM    296  CB  THR A  45      39.429  52.968  54.082  1.00 26.94           C  
ATOM    297  OG1 THR A  45      38.118  53.092  54.648  1.00 28.84           O  
ATOM    298  CG2 THR A  45      39.381  53.208  52.557  1.00 29.34           C  
ATOM    299  N   ASP A  46      40.933  52.048  56.569  1.00 24.90           N  
ATOM    300  CA  ASP A  46      41.029  51.894  58.022  1.00 27.83           C  
ATOM    301  C   ASP A  46      39.662  52.270  58.690  1.00 28.29           C  
ATOM    302  O   ASP A  46      39.361  51.853  59.810  1.00 30.24           O  
ATOM    303  CB  ASP A  46      42.180  52.732  58.600  1.00 27.62           C  
ATOM    304  CG  ASP A  46      43.588  52.171  58.265  1.00 34.33           C  
ATOM    305  OD1 ASP A  46      43.755  50.965  57.966  1.00 34.37           O  
ATOM    306  OD2 ASP A  46      44.556  52.967  58.346  1.00 42.36           O  
ATOM    307  N   ALA A  47      38.841  53.019  57.955  1.00 26.06           N  
ATOM    308  CA  ALA A  47      37.546  53.446  58.404  1.00 26.06           C  
ATOM    309  C   ALA A  47      36.507  52.330  58.437  1.00 26.91           C  
ATOM    310  O   ALA A  47      35.410  52.523  58.930  1.00 26.34           O  
ATOM    311  CB  ALA A  47      37.070  54.548  57.506  1.00 25.67           C  
ATOM    312  N   PHE A  48      36.820  51.175  57.866  1.00 28.94           N  
ATOM    313  CA  PHE A  48      35.863  50.099  57.771  1.00 28.09           C  
ATOM    314  C   PHE A  48      36.192  48.981  58.748  1.00 27.33           C  
ATOM    315  O   PHE A  48      35.595  47.908  58.673  1.00 27.62           O  
ATOM    316  CB  PHE A  48      35.864  49.482  56.371  1.00 28.77           C  
ATOM    317  CG  PHE A  48      35.493  50.410  55.262  1.00 24.73           C  
ATOM    318  CD1 PHE A  48      34.925  51.648  55.481  1.00 27.47           C  
ATOM    319  CD2 PHE A  48      35.714  49.999  53.950  1.00 25.28           C  
ATOM    320  CE1 PHE A  48      34.601  52.477  54.403  1.00 25.91           C  
ATOM    321  CE2 PHE A  48      35.392  50.802  52.875  1.00 25.51           C  
ATOM    322  CZ  PHE A  48      34.838  52.037  53.095  1.00 29.90           C  
ATOM    323  N   LEU A  49      37.130  49.242  59.647  1.00 29.18           N  
ATOM    324  CA  LEU A  49      37.680  48.240  60.560  1.00 30.53           C  
ATOM    325  C   LEU A  49      36.937  48.134  61.892  1.00 32.11           C  
ATOM    326  O   LEU A  49      36.423  49.129  62.436  1.00 29.28           O  
ATOM    327  CB  LEU A  49      39.162  48.511  60.836  1.00 28.28           C  
ATOM    328  CG  LEU A  49      40.063  48.569  59.596  1.00 29.35           C  
ATOM    329  CD1 LEU A  49      41.502  48.752  59.995  1.00 28.21           C  
ATOM    330  CD2 LEU A  49      39.921  47.336  58.699  1.00 31.73           C  
ATOM    331  N   ASN A  50      36.872  46.889  62.357  1.00 33.62           N  
ATOM    332  CA  ASN A  50      36.404  46.536  63.693  1.00 37.37           C  
ATOM    333  C   ASN A  50      37.514  46.813  64.732  1.00 37.08           C  
ATOM    334  O   ASN A  50      38.621  47.212  64.369  1.00 38.13           O  
ATOM    335  CB  ASN A  50      35.905  45.062  63.697  1.00 36.87           C  
ATOM    336  CG  ASN A  50      37.042  44.026  63.741  1.00 37.88           C  
ATOM    337  OD1 ASN A  50      38.212  44.351  63.869  1.00 40.81           O  
ATOM    338  ND2 ASN A  50      36.675  42.766  63.630  1.00 45.88           N  
ATOM    339  N   PRO A  51      37.232  46.617  66.029  1.00 40.29           N  
ATOM    340  CA  PRO A  51      38.260  46.919  67.041  1.00 41.59           C  
ATOM    341  C   PRO A  51      39.585  46.155  66.902  1.00 44.06           C  
ATOM    342  O   PRO A  51      40.645  46.678  67.265  1.00 44.65           O  
ATOM    343  CB  PRO A  51      37.580  46.539  68.352  1.00 41.47           C  
ATOM    344  CG  PRO A  51      36.141  46.623  68.075  1.00 39.80           C  
ATOM    345  CD  PRO A  51      35.991  46.149  66.658  1.00 41.73           C  
ATOM    346  N   VAL A  52      39.520  44.929  66.384  1.00 45.51           N  
ATOM    347  CA  VAL A  52      40.707  44.079  66.231  1.00 44.25           C  
ATOM    348  C   VAL A  52      41.410  44.319  64.881  1.00 44.37           C  
ATOM    349  O   VAL A  52      42.386  43.646  64.561  1.00 44.79           O  
ATOM    350  CB  VAL A  52      40.359  42.560  66.483  1.00 45.35           C  
ATOM    351  CG1 VAL A  52      39.270  42.046  65.532  1.00 48.48           C  
ATOM    352  CG2 VAL A  52      41.595  41.680  66.383  1.00 47.94           C  
ATOM    353  N   GLY A  53      40.934  45.284  64.094  1.00 42.22           N  
ATOM    354  CA  GLY A  53      41.636  45.675  62.872  1.00 40.56           C  
ATOM    355  C   GLY A  53      41.273  44.885  61.627  1.00 38.90           C  
ATOM    356  O   GLY A  53      41.925  45.011  60.581  1.00 39.71           O  
ATOM    357  N   GLN A  54      40.236  44.066  61.712  1.00 34.69           N  
ATOM    358  CA  GLN A  54      39.725  43.420  60.526  1.00 34.98           C  
ATOM    359  C   GLN A  54      38.529  44.210  59.939  1.00 32.12           C  
ATOM    360  O   GLN A  54      37.862  44.987  60.625  1.00 33.14           O  
ATOM    361  CB  GLN A  54      39.322  41.992  60.843  1.00 35.16           C  
ATOM    362  CG  GLN A  54      40.371  41.153  61.559  1.00 36.29           C  
ATOM    363  CD  GLN A  54      39.714  40.006  62.357  1.00 43.50           C  
ATOM    364  OE1 GLN A  54      38.488  39.774  62.268  1.00 55.43           O  
ATOM    365  NE2 GLN A  54      40.524  39.289  63.139  1.00 51.46           N  
ATOM    366  N   VAL A  55      38.260  43.990  58.668  1.00 31.03           N  
ATOM    367  CA  VAL A  55      37.180  44.679  57.984  1.00 31.07           C  
ATOM    368  C   VAL A  55      35.843  44.159  58.540  1.00 30.24           C  
ATOM    369  O   VAL A  55      35.619  42.936  58.618  1.00 30.45           O  
ATOM    370  CB  VAL A  55      37.239  44.448  56.436  1.00 29.29           C  
ATOM    371  CG1 VAL A  55      36.145  45.207  55.714  1.00 28.25           C  
ATOM    372  CG2 VAL A  55      38.571  44.875  55.875  1.00 35.75           C  
ATOM    373  N   GLN A  56      34.951  45.080  58.896  1.00 28.15           N  
ATOM    374  CA  GLN A  56      33.598  44.699  59.319  1.00 28.38           C  
ATOM    375  C   GLN A  56      32.925  43.902  58.211  1.00 29.99           C  
ATOM    376  O   GLN A  56      33.045  44.271  57.025  1.00 30.92           O  
ATOM    377  CB  GLN A  56      32.744  45.929  59.596  1.00 27.54           C  
ATOM    378  CG  GLN A  56      31.498  45.632  60.434  1.00 27.38           C  
ATOM    379  CD  GLN A  56      30.281  46.414  59.967  1.00 37.99           C  
ATOM    380  OE1 GLN A  56      30.096  46.624  58.761  1.00 32.39           O  
ATOM    381  NE2 GLN A  56      29.427  46.833  60.923  1.00 31.96           N  
ATOM    382  N   GLY A  57      32.215  42.836  58.610  1.00 28.52           N  
ATOM    383  CA  GLY A  57      31.502  41.947  57.716  1.00 29.12           C  
ATOM    384  C   GLY A  57      30.512  42.696  56.835  1.00 28.97           C  
ATOM    385  O   GLY A  57      30.435  42.486  55.642  1.00 31.60           O  
ATOM    386  N   GLY A  58      29.749  43.587  57.437  1.00 29.08           N  
ATOM    387  CA  GLY A  58      28.800  44.367  56.697  1.00 29.09           C  
ATOM    388  C   GLY A  58      29.418  45.173  55.582  1.00 28.02           C  
ATOM    389  O   GLY A  58      28.816  45.293  54.540  1.00 30.55           O  
HETATM  390  N   MSE A  59      30.617  45.726  55.804  1.00 29.75           N  
HETATM  391  CA  MSE A  59      31.301  46.530  54.774  1.00 30.61           C  
HETATM  392  C   MSE A  59      31.676  45.617  53.595  1.00 30.92           C  
HETATM  393  O   MSE A  59      31.504  46.014  52.453  1.00 26.44           O  
HETATM  394  CB  MSE A  59      32.524  47.269  55.340  1.00 31.22           C  
HETATM  395  CG  MSE A  59      32.129  48.365  56.355  1.00 30.88           C  
HETATM  396 SE   MSE A  59      30.892  49.650  55.534  0.75 27.03          SE  
HETATM  397  CE  MSE A  59      31.805  50.061  53.972  1.00 28.18           C  
ATOM    398  N   LEU A  60      32.123  44.391  53.890  1.00 29.05           N  
ATOM    399  CA  LEU A  60      32.333  43.386  52.844  1.00 28.87           C  
ATOM    400  C   LEU A  60      31.055  43.078  52.091  1.00 29.48           C  
ATOM    401  O   LEU A  60      31.063  42.902  50.873  1.00 26.56           O  
ATOM    402  CB  LEU A  60      32.852  42.097  53.418  1.00 25.60           C  
ATOM    403  CG  LEU A  60      34.178  42.155  54.199  1.00 31.36           C  
ATOM    404  CD1 LEU A  60      34.449  40.822  54.898  1.00 28.91           C  
ATOM    405  CD2 LEU A  60      35.325  42.526  53.330  1.00 32.45           C  
ATOM    406  N   GLY A  61      29.958  42.990  52.838  1.00 29.12           N  
ATOM    407  CA  GLY A  61      28.645  42.822  52.240  1.00 26.99           C  
ATOM    408  C   GLY A  61      28.272  43.951  51.291  1.00 27.38           C  
ATOM    409  O   GLY A  61      27.631  43.700  50.298  1.00 28.34           O  
ATOM    410  N   ALA A  62      28.664  45.189  51.589  1.00 28.41           N  
ATOM    411  CA  ALA A  62      28.403  46.309  50.675  1.00 28.16           C  
ATOM    412  C   ALA A  62      29.186  46.170  49.377  1.00 27.00           C  
ATOM    413  O   ALA A  62      28.721  46.560  48.325  1.00 26.30           O  
ATOM    414  CB  ALA A  62      28.702  47.665  51.370  1.00 29.95           C  
HETATM  415  N   MSE A  63      30.371  45.575  49.440  1.00 27.74           N  
HETATM  416  CA  MSE A  63      31.135  45.244  48.217  1.00 28.41           C  
HETATM  417  C   MSE A  63      30.483  44.104  47.396  1.00 29.97           C  
HETATM  418  O   MSE A  63      30.399  44.171  46.160  1.00 30.46           O  
HETATM  419  CB  MSE A  63      32.531  44.835  48.630  1.00 27.53           C  
HETATM  420  CG  MSE A  63      33.301  45.965  49.211  1.00 31.43           C  
HETATM  421 SE   MSE A  63      34.960  45.346  50.114  0.75 26.05          SE  
HETATM  422  CE  MSE A  63      35.493  47.011  50.995  1.00 28.89           C  
ATOM    423  N   LEU A  64      30.000  43.081  48.107  1.00 29.28           N  
ATOM    424  CA  LEU A  64      29.251  41.981  47.500  1.00 27.74           C  
ATOM    425  C   LEU A  64      27.952  42.466  46.876  1.00 28.05           C  
ATOM    426  O   LEU A  64      27.555  42.022  45.786  1.00 29.49           O  
ATOM    427  CB  LEU A  64      29.026  40.856  48.531  1.00 28.68           C  
ATOM    428  CG  LEU A  64      30.308  40.034  48.881  1.00 23.42           C  
ATOM    429  CD1 LEU A  64      30.211  39.290  50.190  1.00 31.04           C  
ATOM    430  CD2 LEU A  64      30.719  39.082  47.762  1.00 26.12           C  
ATOM    431  N   ASP A  65      27.301  43.404  47.545  1.00 28.59           N  
ATOM    432  CA  ASP A  65      26.115  44.027  47.007  1.00 29.20           C  
ATOM    433  C   ASP A  65      26.447  44.737  45.710  1.00 29.54           C  
ATOM    434  O   ASP A  65      25.690  44.641  44.724  1.00 34.62           O  
ATOM    435  CB  ASP A  65      25.490  44.965  48.063  1.00 28.52           C  
ATOM    436  CG  ASP A  65      24.124  45.544  47.623  1.00 30.65           C  
ATOM    437  OD1 ASP A  65      23.290  44.828  47.068  1.00 43.29           O  
ATOM    438  OD2 ASP A  65      23.869  46.725  47.866  1.00 38.64           O  
ATOM    439  N   ASP A  66      27.566  45.473  45.691  1.00 29.54           N  
ATOM    440  CA  ASP A  66      27.935  46.241  44.507  1.00 29.77           C  
ATOM    441  C   ASP A  66      28.228  45.319  43.306  1.00 29.76           C  
ATOM    442  O   ASP A  66      27.731  45.525  42.200  1.00 32.11           O  
ATOM    443  CB  ASP A  66      29.158  47.123  44.773  1.00 29.36           C  
ATOM    444  CG  ASP A  66      29.533  47.955  43.546  1.00 32.14           C  
ATOM    445  OD1 ASP A  66      28.815  48.931  43.292  1.00 30.36           O  
ATOM    446  OD2 ASP A  66      30.523  47.626  42.824  1.00 33.19           O  
ATOM    447  N   VAL A  67      29.030  44.290  43.524  1.00 27.64           N  
ATOM    448  CA  VAL A  67      29.468  43.447  42.407  1.00 27.44           C  
ATOM    449  C   VAL A  67      28.299  42.685  41.765  1.00 29.01           C  
ATOM    450  O   VAL A  67      28.185  42.620  40.485  1.00 30.04           O  
ATOM    451  CB  VAL A  67      30.691  42.548  42.799  1.00 28.08           C  
ATOM    452  CG1 VAL A  67      30.291  41.428  43.759  1.00 24.31           C  
ATOM    453  CG2 VAL A  67      31.366  42.034  41.583  1.00 27.20           C  
ATOM    454  N   THR A  68      27.383  42.218  42.618  1.00 28.09           N  
ATOM    455  CA  THR A  68      26.236  41.434  42.178  1.00 25.20           C  
ATOM    456  C   THR A  68      25.198  42.308  41.448  1.00 24.93           C  
ATOM    457  O   THR A  68      24.779  41.999  40.345  1.00 22.13           O  
ATOM    458  CB  THR A  68      25.609  40.600  43.324  1.00 25.20           C  
ATOM    459  OG1 THR A  68      25.136  41.440  44.400  1.00 24.08           O  
ATOM    460  CG2 THR A  68      26.615  39.587  43.850  1.00 29.99           C  
ATOM    461  N   ALA A  69      24.856  43.438  42.042  1.00 29.08           N  
ATOM    462  CA  ALA A  69      23.972  44.435  41.398  1.00 26.21           C  
ATOM    463  C   ALA A  69      24.542  45.054  40.137  1.00 28.42           C  
ATOM    464  O   ALA A  69      23.785  45.446  39.196  1.00 30.54           O  
ATOM    465  CB  ALA A  69      23.627  45.525  42.419  1.00 27.70           C  
HETATM  466  N   MSE A  70      25.868  45.193  40.100  1.00 29.89           N  
HETATM  467  CA  MSE A  70      26.535  45.701  38.881  1.00 27.85           C  
HETATM  468  C   MSE A  70      26.378  44.708  37.743  1.00 25.61           C  
HETATM  469  O   MSE A  70      26.012  45.066  36.591  1.00 21.16           O  
HETATM  470  CB  MSE A  70      28.038  45.982  39.102  1.00 29.73           C  
HETATM  471  CG  MSE A  70      28.403  47.377  39.657  1.00 38.91           C  
HETATM  472 SE   MSE A  70      27.545  48.875  38.695  0.75 38.20          SE  
HETATM  473  CE  MSE A  70      25.841  49.058  39.807  1.00 38.12           C  
ATOM    474  N   LEU A  71      26.659  43.454  38.051  1.00 24.53           N  
ATOM    475  CA  LEU A  71      26.493  42.399  37.038  1.00 25.71           C  
ATOM    476  C   LEU A  71      25.041  42.394  36.470  1.00 24.23           C  
ATOM    477  O   LEU A  71      24.840  42.428  35.258  1.00 26.69           O  
ATOM    478  CB  LEU A  71      26.905  41.043  37.602  1.00 22.07           C  
ATOM    479  CG  LEU A  71      26.540  39.882  36.658  1.00 26.35           C  
ATOM    480  CD1 LEU A  71      27.047  40.078  35.237  1.00 21.42           C  
ATOM    481  CD2 LEU A  71      27.063  38.627  37.260  1.00 24.08           C  
ATOM    482  N   VAL A  72      24.048  42.433  37.359  1.00 24.60           N  
ATOM    483  CA  VAL A  72      22.655  42.442  36.923  1.00 25.61           C  
ATOM    484  C   VAL A  72      22.390  43.621  36.040  1.00 25.86           C  
ATOM    485  O   VAL A  72      21.801  43.461  34.979  1.00 26.00           O  
ATOM    486  CB  VAL A  72      21.639  42.454  38.085  1.00 26.64           C  
ATOM    487  CG1 VAL A  72      20.220  42.507  37.551  1.00 29.72           C  
ATOM    488  CG2 VAL A  72      21.834  41.233  38.962  1.00 27.62           C  
ATOM    489  N   THR A  73      22.838  44.803  36.472  1.00 27.68           N  
ATOM    490  CA  THR A  73      22.650  46.066  35.704  1.00 25.12           C  
ATOM    491  C   THR A  73      23.272  46.018  34.325  1.00 23.47           C  
ATOM    492  O   THR A  73      22.669  46.462  33.324  1.00 23.68           O  
ATOM    493  CB  THR A  73      23.192  47.271  36.528  1.00 25.57           C  
ATOM    494  OG1 THR A  73      22.478  47.308  37.761  1.00 24.21           O  
ATOM    495  CG2 THR A  73      22.977  48.596  35.821  1.00 27.79           C  
ATOM    496  N   ALA A  74      24.474  45.467  34.256  1.00 21.76           N  
ATOM    497  CA  ALA A  74      25.135  45.244  32.972  1.00 24.40           C  
ATOM    498  C   ALA A  74      24.270  44.541  31.923  1.00 24.26           C  
ATOM    499  O   ALA A  74      24.439  44.798  30.729  1.00 27.83           O  
ATOM    500  CB  ALA A  74      26.414  44.481  33.173  1.00 25.15           C  
ATOM    501  N   THR A  75      23.362  43.658  32.362  1.00 25.59           N  
ATOM    502  CA  THR A  75      22.495  42.892  31.450  1.00 26.65           C  
ATOM    503  C   THR A  75      21.206  43.631  31.038  1.00 27.18           C  
ATOM    504  O   THR A  75      20.519  43.189  30.134  1.00 26.76           O  
ATOM    505  CB  THR A  75      22.131  41.462  31.997  1.00 24.74           C  
ATOM    506  OG1 THR A  75      21.213  41.543  33.102  1.00 28.84           O  
ATOM    507  CG2 THR A  75      23.352  40.735  32.437  1.00 31.82           C  
ATOM    508  N   LEU A  76      20.897  44.765  31.662  1.00 29.14           N  
ATOM    509  CA  LEU A  76      19.583  45.376  31.496  1.00 28.97           C  
ATOM    510  C   LEU A  76      19.437  46.234  30.269  1.00 32.57           C  
ATOM    511  O   LEU A  76      20.383  46.832  29.798  1.00 32.81           O  
ATOM    512  CB  LEU A  76      19.219  46.189  32.743  1.00 30.56           C  
ATOM    513  CG  LEU A  76      19.242  45.349  34.028  1.00 27.82           C  
ATOM    514  CD1 LEU A  76      18.596  46.071  35.199  1.00 27.29           C  
ATOM    515  CD2 LEU A  76      18.611  43.964  33.841  1.00 28.87           C  
ATOM    516  N   GLU A  77      18.227  46.271  29.737  1.00 34.33           N  
ATOM    517  CA  GLU A  77      17.879  47.260  28.739  1.00 37.12           C  
ATOM    518  C   GLU A  77      17.842  48.645  29.397  1.00 37.96           C  
ATOM    519  O   GLU A  77      17.849  48.767  30.625  1.00 38.70           O  
ATOM    520  CB  GLU A  77      16.537  46.912  28.068  1.00 36.18           C  
ATOM    521  CG  GLU A  77      15.330  46.824  29.004  1.00 36.19           C  
ATOM    522  CD  GLU A  77      15.008  45.405  29.517  1.00 41.14           C  
ATOM    523  OE1 GLU A  77      15.822  44.791  30.261  1.00 30.26           O  
ATOM    524  OE2 GLU A  77      13.897  44.930  29.203  1.00 41.79           O  
ATOM    525  N   ASP A  78      17.837  49.684  28.577  1.00 39.85           N  
ATOM    526  CA  ASP A  78      17.600  51.040  29.057  1.00 41.60           C  
ATOM    527  C   ASP A  78      16.177  51.124  29.567  1.00 42.08           C  
ATOM    528  O   ASP A  78      15.247  50.644  28.910  1.00 42.75           O  
ATOM    529  CB  ASP A  78      17.784  52.073  27.928  1.00 44.53           C  
ATOM    530  CG  ASP A  78      19.184  52.673  27.895  1.00 50.52           C  
ATOM    531  OD1 ASP A  78      20.039  52.292  28.736  1.00 59.43           O  
ATOM    532  OD2 ASP A  78      19.417  53.542  27.026  1.00 56.47           O  
ATOM    533  N   GLY A  79      16.008  51.734  30.733  1.00 41.32           N  
ATOM    534  CA  GLY A  79      14.685  51.864  31.325  1.00 41.70           C  
ATOM    535  C   GLY A  79      14.399  50.819  32.385  1.00 41.79           C  
ATOM    536  O   GLY A  79      13.628  51.082  33.314  1.00 43.89           O  
ATOM    537  N   ALA A  80      14.999  49.634  32.236  1.00 40.36           N  
ATOM    538  CA  ALA A  80      14.922  48.582  33.250  1.00 39.26           C  
ATOM    539  C   ALA A  80      15.885  48.911  34.358  1.00 38.65           C  
ATOM    540  O   ALA A  80      16.855  49.627  34.138  1.00 39.03           O  
ATOM    541  CB  ALA A  80      15.255  47.218  32.653  1.00 37.81           C  
ATOM    542  N   SER A  81      15.631  48.355  35.540  1.00 38.07           N  
ATOM    543  CA  SER A  81      16.422  48.673  36.702  1.00 36.94           C  
ATOM    544  C   SER A  81      16.600  47.500  37.680  1.00 35.73           C  
ATOM    545  O   SER A  81      15.708  46.705  37.880  1.00 35.08           O  
ATOM    546  CB  SER A  81      15.788  49.846  37.424  1.00 37.51           C  
ATOM    547  OG  SER A  81      16.721  50.363  38.348  1.00 48.33           O  
ATOM    548  N   CYS A  82      17.761  47.413  38.304  1.00 35.60           N  
ATOM    549  CA  CYS A  82      18.023  46.321  39.233  1.00 33.77           C  
ATOM    550  C   CYS A  82      17.711  46.721  40.686  1.00 34.12           C  
ATOM    551  O   CYS A  82      18.280  47.676  41.234  1.00 33.57           O  
ATOM    552  CB  CYS A  82      19.459  45.858  39.134  1.00 31.05           C  
ATOM    553  SG  CYS A  82      19.926  44.715  40.556  1.00 40.70           S  
ATOM    554  N   SER A  83      16.865  45.919  41.316  1.00 30.77           N  
ATOM    555  CA  SER A  83      16.485  46.105  42.681  1.00 29.23           C  
ATOM    556  C   SER A  83      16.737  44.856  43.523  1.00 27.36           C  
ATOM    557  O   SER A  83      16.055  43.878  43.365  1.00 31.29           O  
ATOM    558  CB  SER A  83      15.003  46.428  42.647  1.00 31.17           C  
ATOM    559  OG  SER A  83      14.525  46.726  43.911  1.00 33.24           O  
ATOM    560  N   THR A  84      17.691  44.885  44.442  1.00 26.56           N  
ATOM    561  CA  THR A  84      17.995  43.713  45.265  1.00 24.75           C  
ATOM    562  C   THR A  84      17.004  43.509  46.424  1.00 24.08           C  
ATOM    563  O   THR A  84      16.797  44.402  47.229  1.00 23.86           O  
ATOM    564  CB  THR A  84      19.418  43.812  45.831  1.00 28.75           C  
ATOM    565  OG1 THR A  84      20.361  43.919  44.747  1.00 33.51           O  
ATOM    566  CG2 THR A  84      19.774  42.599  46.633  1.00 26.07           C  
ATOM    567  N   LEU A  85      16.428  42.312  46.526  1.00 22.40           N  
ATOM    568  CA  LEU A  85      15.361  42.016  47.466  1.00 22.20           C  
ATOM    569  C   LEU A  85      15.921  41.365  48.703  1.00 22.83           C  
ATOM    570  O   LEU A  85      15.487  41.657  49.812  1.00 22.93           O  
ATOM    571  CB  LEU A  85      14.348  41.072  46.841  1.00 19.53           C  
ATOM    572  CG  LEU A  85      13.680  41.560  45.571  1.00 19.14           C  
ATOM    573  CD1 LEU A  85      12.661  40.530  45.099  1.00 25.59           C  
ATOM    574  CD2 LEU A  85      12.981  42.915  45.743  1.00 16.09           C  
ATOM    575  N   ASN A  86      16.870  40.464  48.507  1.00 26.61           N  
ATOM    576  CA  ASN A  86      17.511  39.742  49.588  1.00 29.18           C  
ATOM    577  C   ASN A  86      18.963  39.597  49.204  1.00 30.60           C  
ATOM    578  O   ASN A  86      19.269  39.479  47.994  1.00 25.24           O  
ATOM    579  CB  ASN A  86      16.877  38.327  49.760  1.00 29.80           C  
ATOM    580  CG  ASN A  86      17.377  37.584  51.026  1.00 31.66           C  
ATOM    581  OD1 ASN A  86      18.300  36.759  50.950  1.00 32.94           O  
ATOM    582  ND2 ASN A  86      16.695  37.828  52.190  1.00 30.40           N  
ATOM    583  N   LEU A  87      19.840  39.636  50.220  1.00 24.88           N  
ATOM    584  CA  LEU A  87      21.265  39.380  50.062  1.00 25.41           C  
ATOM    585  C   LEU A  87      21.726  38.540  51.275  1.00 26.76           C  
ATOM    586  O   LEU A  87      21.558  38.952  52.389  1.00 27.28           O  
ATOM    587  CB  LEU A  87      22.018  40.705  50.043  1.00 27.30           C  
ATOM    588  CG  LEU A  87      23.541  40.759  49.865  1.00 26.56           C  
ATOM    589  CD1 LEU A  87      24.001  40.117  48.579  1.00 31.17           C  
ATOM    590  CD2 LEU A  87      23.983  42.195  49.904  1.00 26.74           C  
ATOM    591  N   ASN A  88      22.228  37.336  51.040  1.00 26.76           N  
ATOM    592  CA  ASN A  88      22.675  36.485  52.104  1.00 27.89           C  
ATOM    593  C   ASN A  88      24.178  36.465  52.049  1.00 29.68           C  
ATOM    594  O   ASN A  88      24.748  36.139  51.009  1.00 30.87           O  
ATOM    595  CB  ASN A  88      22.109  35.055  51.978  1.00 25.88           C  
ATOM    596  CG  ASN A  88      22.532  34.157  53.155  1.00 28.85           C  
ATOM    597  OD1 ASN A  88      23.518  33.449  53.062  1.00 28.62           O  
ATOM    598  ND2 ASN A  88      21.799  34.215  54.257  1.00 22.63           N  
ATOM    599  N   LEU A  89      24.807  36.790  53.171  1.00 27.62           N  
ATOM    600  CA  LEU A  89      26.248  36.964  53.261  1.00 28.08           C  
ATOM    601  C   LEU A  89      26.824  35.919  54.186  1.00 28.29           C  
ATOM    602  O   LEU A  89      26.283  35.694  55.233  1.00 24.12           O  
ATOM    603  CB  LEU A  89      26.574  38.324  53.889  1.00 28.51           C  
ATOM    604  CG  LEU A  89      26.016  39.518  53.138  1.00 27.91           C  
ATOM    605  CD1 LEU A  89      26.257  40.783  53.981  1.00 29.80           C  
ATOM    606  CD2 LEU A  89      26.591  39.653  51.731  1.00 29.83           C  
ATOM    607  N   SER A  90      27.913  35.285  53.757  1.00 29.73           N  
ATOM    608  CA  SER A  90      28.625  34.311  54.535  1.00 28.77           C  
ATOM    609  C   SER A  90      30.022  34.861  54.643  1.00 29.98           C  
ATOM    610  O   SER A  90      30.637  35.257  53.625  1.00 30.01           O  
ATOM    611  CB  SER A  90      28.648  32.920  53.852  1.00 28.37           C  
ATOM    612  OG  SER A  90      27.347  32.404  53.644  1.00 35.98           O  
ATOM    613  N   PHE A  91      30.517  34.844  55.874  1.00 25.00           N  
ATOM    614  CA  PHE A  91      31.803  35.386  56.241  1.00 28.55           C  
ATOM    615  C   PHE A  91      32.691  34.219  56.605  1.00 27.33           C  
ATOM    616  O   PHE A  91      32.406  33.516  57.549  1.00 23.12           O  
ATOM    617  CB  PHE A  91      31.666  36.332  57.449  1.00 28.97           C  
ATOM    618  CG  PHE A  91      30.685  37.444  57.218  1.00 28.81           C  
ATOM    619  CD1 PHE A  91      30.908  38.364  56.212  1.00 28.87           C  
ATOM    620  CD2 PHE A  91      29.525  37.551  57.975  1.00 34.88           C  
ATOM    621  CE1 PHE A  91      30.001  39.364  55.947  1.00 31.66           C  
ATOM    622  CE2 PHE A  91      28.613  38.583  57.726  1.00 34.35           C  
ATOM    623  CZ  PHE A  91      28.852  39.477  56.700  1.00 29.79           C  
ATOM    624  N   LEU A  92      33.768  34.063  55.850  1.00 27.05           N  
ATOM    625  CA  LEU A  92      34.511  32.845  55.763  1.00 29.57           C  
ATOM    626  C   LEU A  92      35.842  33.020  56.453  1.00 29.75           C  
ATOM    627  O   LEU A  92      36.253  32.160  57.235  1.00 31.80           O  
ATOM    628  CB  LEU A  92      34.721  32.535  54.282  1.00 30.05           C  
ATOM    629  CG  LEU A  92      33.783  31.545  53.554  1.00 35.86           C  
ATOM    630  CD1 LEU A  92      32.347  31.725  53.839  1.00 39.27           C  
ATOM    631  CD2 LEU A  92      34.021  31.608  52.061  1.00 35.28           C  
ATOM    632  N   ARG A  93      36.526  34.122  56.109  1.00 28.19           N  
ATOM    633  CA  ARG A  93      37.841  34.477  56.637  1.00 30.96           C  
ATOM    634  C   ARG A  93      37.945  35.971  56.854  1.00 30.73           C  
ATOM    635  O   ARG A  93      37.325  36.741  56.124  1.00 32.93           O  
ATOM    636  CB  ARG A  93      38.957  34.103  55.657  1.00 28.97           C  
ATOM    637  CG  ARG A  93      38.957  32.679  55.248  1.00 31.95           C  
ATOM    638  CD  ARG A  93      40.034  32.382  54.227  1.00 36.22           C  
ATOM    639  NE  ARG A  93      40.158  30.931  54.073  1.00 38.76           N  
ATOM    640  CZ  ARG A  93      39.388  30.173  53.294  1.00 41.48           C  
ATOM    641  NH1 ARG A  93      38.422  30.703  52.547  1.00 37.35           N  
ATOM    642  NH2 ARG A  93      39.591  28.860  53.254  1.00 48.55           N  
ATOM    643  N   PRO A  94      38.768  36.382  57.821  1.00 34.17           N  
ATOM    644  CA  PRO A  94      38.961  37.806  58.088  1.00 34.74           C  
ATOM    645  C   PRO A  94      39.720  38.526  56.968  1.00 33.84           C  
ATOM    646  O   PRO A  94      40.604  37.951  56.328  1.00 33.83           O  
ATOM    647  CB  PRO A  94      39.752  37.807  59.412  1.00 35.90           C  
ATOM    648  CG  PRO A  94      40.464  36.532  59.414  1.00 37.37           C  
ATOM    649  CD  PRO A  94      39.590  35.540  58.724  1.00 31.33           C  
ATOM    650  N   ALA A  95      39.301  39.758  56.694  1.00 33.50           N  
ATOM    651  CA  ALA A  95      39.947  40.614  55.718  1.00 33.18           C  
ATOM    652  C   ALA A  95      40.686  41.723  56.460  1.00 32.67           C  
ATOM    653  O   ALA A  95      40.349  42.073  57.598  1.00 32.93           O  
ATOM    654  CB  ALA A  95      38.931  41.205  54.769  1.00 33.51           C  
ATOM    655  N   GLN A  96      41.693  42.275  55.803  0.50 32.92           N  
ATOM    657  CA  GLN A  96      42.460  43.372  56.346  0.50 32.52           C  
ATOM    659  C   GLN A  96      42.229  44.567  55.435  0.50 31.06           C  
ATOM    661  O   GLN A  96      41.723  44.419  54.316  0.50 31.05           O  
ATOM    663  CB  GLN A  96      43.944  42.996  56.393  0.50 33.71           C  
ATOM    665  CG  GLN A  96      44.246  41.520  56.717  0.50 38.02           C  
ATOM    667  CD  GLN A  96      43.726  41.071  58.082  0.50 43.31           C  
ATOM    669  OE1 GLN A  96      43.533  41.885  58.983  0.50 47.15           O  
ATOM    671  NE2 GLN A  96      43.505  39.763  58.235  0.50 41.56           N  
ATOM    673  N   ALA A  97      42.596  45.749  55.909  1.00 29.94           N  
ATOM    674  CA  ALA A  97      42.594  46.941  55.060  1.00 29.86           C  
ATOM    675  C   ALA A  97      43.453  46.690  53.826  1.00 28.76           C  
ATOM    676  O   ALA A  97      44.524  46.065  53.908  1.00 30.37           O  
ATOM    677  CB  ALA A  97      43.126  48.146  55.806  1.00 28.88           C  
ATOM    678  N   GLY A  98      42.999  47.210  52.691  1.00 27.56           N  
ATOM    679  CA  GLY A  98      43.707  47.034  51.432  1.00 26.71           C  
ATOM    680  C   GLY A  98      42.748  46.614  50.336  1.00 26.71           C  
ATOM    681  O   GLY A  98      41.531  46.684  50.503  1.00 29.25           O  
ATOM    682  N   LEU A  99      43.307  46.207  49.206  1.00 26.83           N  
ATOM    683  CA  LEU A  99      42.541  45.763  48.048  1.00 27.43           C  
ATOM    684  C   LEU A  99      41.828  44.420  48.282  1.00 26.33           C  
ATOM    685  O   LEU A  99      42.340  43.545  48.969  1.00 28.22           O  
ATOM    686  CB  LEU A  99      43.456  45.603  46.845  1.00 28.21           C  
ATOM    687  CG  LEU A  99      43.671  46.741  45.863  1.00 32.31           C  
ATOM    688  CD1 LEU A  99      44.852  46.370  44.975  1.00 30.69           C  
ATOM    689  CD2 LEU A  99      42.416  46.965  45.044  1.00 32.18           C  
ATOM    690  N   LEU A 100      40.652  44.286  47.676  1.00 25.74           N  
ATOM    691  CA  LEU A 100      39.932  43.017  47.545  1.00 27.08           C  
ATOM    692  C   LEU A 100      39.435  42.930  46.130  1.00 27.28           C  
ATOM    693  O   LEU A 100      39.310  43.931  45.443  1.00 29.71           O  
ATOM    694  CB  LEU A 100      38.718  42.903  48.496  1.00 26.91           C  
ATOM    695  CG  LEU A 100      39.002  42.994  50.015  1.00 26.52           C  
ATOM    696  CD1 LEU A 100      38.880  44.404  50.564  1.00 29.21           C  
ATOM    697  CD2 LEU A 100      38.095  42.083  50.772  1.00 29.44           C  
ATOM    698  N   ARG A 101      39.144  41.710  45.721  1.00 28.32           N  
ATOM    699  CA  ARG A 101      38.659  41.387  44.400  1.00 27.81           C  
ATOM    700  C   ARG A 101      37.282  40.744  44.551  1.00 27.74           C  
ATOM    701  O   ARG A 101      37.166  39.669  45.161  1.00 27.59           O  
ATOM    702  CB  ARG A 101      39.605  40.362  43.786  1.00 27.05           C  
ATOM    703  CG  ARG A 101      39.155  39.727  42.485  1.00 33.08           C  
ATOM    704  CD  ARG A 101      38.744  40.757  41.498  1.00 38.10           C  
ATOM    705  NE  ARG A 101      39.846  41.690  41.223  1.00 45.38           N  
ATOM    706  CZ  ARG A 101      40.615  41.684  40.132  1.00 40.32           C  
ATOM    707  NH1 ARG A 101      40.420  40.846  39.129  1.00 37.07           N  
ATOM    708  NH2 ARG A 101      41.577  42.547  40.030  1.00 30.65           N  
ATOM    709  N   GLY A 102      36.274  41.386  43.965  1.00 26.34           N  
ATOM    710  CA  GLY A 102      34.927  40.866  43.937  1.00 27.81           C  
ATOM    711  C   GLY A 102      34.622  40.224  42.613  1.00 26.24           C  
ATOM    712  O   GLY A 102      34.898  40.806  41.557  1.00 25.20           O  
ATOM    713  N   ARG A 103      34.037  39.035  42.658  1.00 28.10           N  
ATOM    714  CA  ARG A 103      33.623  38.312  41.417  1.00 31.37           C  
ATOM    715  C   ARG A 103      32.131  37.942  41.502  1.00 30.62           C  
ATOM    716  O   ARG A 103      31.680  37.438  42.517  1.00 30.08           O  
ATOM    717  CB  ARG A 103      34.497  37.067  41.193  1.00 30.44           C  
ATOM    718  CG  ARG A 103      35.957  37.420  40.925  1.00 36.71           C  
ATOM    719  CD  ARG A 103      36.876  36.243  40.476  1.00 36.76           C  
ATOM    720  NE  ARG A 103      38.307  36.659  40.432  1.00 54.96           N  
ATOM    721  CZ  ARG A 103      39.189  36.640  41.462  1.00 49.88           C  
ATOM    722  NH1 ARG A 103      38.882  36.183  42.661  1.00 50.64           N  
ATOM    723  NH2 ARG A 103      40.426  37.057  41.277  1.00 49.35           N  
ATOM    724  N   ALA A 104      31.361  38.273  40.461  1.00 29.81           N  
ATOM    725  CA  ALA A 104      29.959  37.920  40.397  1.00 27.97           C  
ATOM    726  C   ALA A 104      29.705  36.957  39.236  1.00 27.77           C  
ATOM    727  O   ALA A 104      30.418  37.001  38.231  1.00 27.92           O  
ATOM    728  CB  ALA A 104      29.107  39.163  40.268  1.00 29.22           C  
ATOM    729  N   ARG A 105      28.734  36.056  39.431  0.50 26.99           N  
ATOM    731  CA  ARG A 105      28.199  35.166  38.393  0.50 27.18           C  
ATOM    733  C   ARG A 105      26.675  35.093  38.525  0.50 26.08           C  
ATOM    735  O   ARG A 105      26.154  34.903  39.632  0.50 23.07           O  
ATOM    737  CB  ARG A 105      28.752  33.725  38.519  0.50 28.10           C  
ATOM    739  CG  ARG A 105      28.160  32.742  37.482  0.50 27.57           C  
ATOM    741  CD  ARG A 105      28.559  31.257  37.635  0.50 28.95           C  
ATOM    743  NE  ARG A 105      27.716  30.479  38.563  0.50 30.60           N  
ATOM    745  CZ  ARG A 105      28.037  30.206  39.826  0.50 29.11           C  
ATOM    747  NH1 ARG A 105      29.172  30.631  40.362  0.50 42.10           N  
ATOM    749  NH2 ARG A 105      27.223  29.503  40.570  0.50 29.60           N  
ATOM    751  N   LEU A 106      25.981  35.191  37.394  1.00 23.57           N  
ATOM    752  CA  LEU A 106      24.538  34.904  37.318  1.00 24.96           C  
ATOM    753  C   LEU A 106      24.235  33.405  37.354  1.00 23.32           C  
ATOM    754  O   LEU A 106      24.639  32.685  36.469  1.00 23.43           O  
ATOM    755  CB  LEU A 106      23.936  35.479  36.012  1.00 19.45           C  
ATOM    756  CG  LEU A 106      23.714  36.982  36.080  1.00 22.45           C  
ATOM    757  CD1 LEU A 106      23.614  37.605  34.705  1.00 26.22           C  
ATOM    758  CD2 LEU A 106      22.494  37.296  36.925  1.00 23.96           C  
ATOM    759  N   GLU A 107      23.511  32.940  38.370  1.00 27.54           N  
ATOM    760  CA  GLU A 107      23.022  31.566  38.398  1.00 29.81           C  
ATOM    761  C   GLU A 107      21.764  31.424  37.591  1.00 28.66           C  
ATOM    762  O   GLU A 107      21.491  30.346  37.119  1.00 28.50           O  
ATOM    763  CB  GLU A 107      22.683  31.094  39.808  1.00 30.09           C  
ATOM    764  CG  GLU A 107      23.866  30.899  40.681  1.00 46.53           C  
ATOM    765  CD  GLU A 107      24.196  29.454  40.934  1.00 47.96           C  
ATOM    766  OE1 GLU A 107      24.345  28.703  39.941  1.00 47.87           O  
ATOM    767  OE2 GLU A 107      24.344  29.098  42.132  1.00 52.09           O  
ATOM    768  N   ARG A 108      20.967  32.480  37.530  1.00 27.11           N  
ATOM    769  CA  ARG A 108      19.789  32.510  36.683  1.00 28.44           C  
ATOM    770  C   ARG A 108      19.408  33.934  36.362  1.00 27.35           C  
ATOM    771  O   ARG A 108      19.419  34.774  37.240  1.00 27.26           O  
ATOM    772  CB  ARG A 108      18.609  31.842  37.384  1.00 29.63           C  
ATOM    773  CG  ARG A 108      17.313  31.968  36.565  1.00 30.09           C  
ATOM    774  CD  ARG A 108      16.402  30.774  36.690  1.00 30.46           C  
ATOM    775  NE  ARG A 108      15.375  30.833  35.646  1.00 40.47           N  
ATOM    776  CZ  ARG A 108      14.292  31.611  35.684  1.00 40.14           C  
ATOM    777  NH1 ARG A 108      14.051  32.411  36.725  1.00 46.83           N  
ATOM    778  NH2 ARG A 108      13.455  31.604  34.662  1.00 33.35           N  
ATOM    779  N   ARG A 109      19.104  34.178  35.100  1.00 30.00           N  
ATOM    780  CA  ARG A 109      18.562  35.436  34.598  1.00 32.96           C  
ATOM    781  C   ARG A 109      17.118  35.221  34.217  1.00 28.68           C  
ATOM    782  O   ARG A 109      16.875  34.740  33.144  1.00 28.35           O  
ATOM    783  CB  ARG A 109      19.217  35.805  33.278  1.00 31.45           C  
ATOM    784  CG  ARG A 109      20.642  36.104  33.367  1.00 41.62           C  
ATOM    785  CD  ARG A 109      21.137  36.692  32.019  1.00 41.62           C  
ATOM    786  NE  ARG A 109      22.443  36.108  31.732  1.00 50.02           N  
ATOM    787  CZ  ARG A 109      23.362  36.622  30.936  1.00 45.62           C  
ATOM    788  NH1 ARG A 109      23.155  37.766  30.273  1.00 51.08           N  
ATOM    789  NH2 ARG A 109      24.501  35.962  30.818  1.00 49.19           N  
ATOM    790  N   GLY A 110      16.170  35.587  35.061  1.00 27.28           N  
ATOM    791  CA  GLY A 110      14.778  35.331  34.767  1.00 24.35           C  
ATOM    792  C   GLY A 110      14.175  36.500  34.036  1.00 22.94           C  
ATOM    793  O   GLY A 110      14.850  37.479  33.781  1.00 24.41           O  
ATOM    794  N   ARG A 111      12.896  36.373  33.702  1.00 19.21           N  
ATOM    795  CA  ARG A 111      12.085  37.476  33.181  1.00 17.64           C  
ATOM    796  C   ARG A 111      12.106  38.620  34.219  1.00 18.59           C  
ATOM    797  O   ARG A 111      12.483  39.720  33.893  1.00 19.18           O  
ATOM    798  CB  ARG A 111      10.662  36.977  32.908  1.00 16.12           C  
ATOM    799  CG  ARG A 111       9.890  37.791  31.956  1.00 19.96           C  
ATOM    800  CD  ARG A 111       8.647  37.054  31.576  1.00 13.01           C  
ATOM    801  NE  ARG A 111       8.838  36.017  30.569  1.00  2.00           N  
ATOM    802  CZ  ARG A 111       8.702  36.205  29.265  1.00 17.82           C  
ATOM    803  NH1 ARG A 111       8.450  37.410  28.789  1.00 13.31           N  
ATOM    804  NH2 ARG A 111       8.819  35.198  28.416  1.00 24.27           N  
ATOM    805  N   ASN A 112      11.787  38.357  35.489  1.00 19.38           N  
ATOM    806  CA  ASN A 112      11.828  39.428  36.479  1.00 17.51           C  
ATOM    807  C   ASN A 112      12.762  39.183  37.649  1.00 18.43           C  
ATOM    808  O   ASN A 112      12.978  40.090  38.427  1.00 19.35           O  
ATOM    809  CB  ASN A 112      10.428  39.774  36.982  1.00 12.55           C  
ATOM    810  CG  ASN A 112       9.516  40.278  35.862  1.00 18.46           C  
ATOM    811  OD1 ASN A 112       9.600  41.418  35.375  1.00  7.78           O  
ATOM    812  ND2 ASN A 112       8.643  39.416  35.445  1.00  2.00           N  
ATOM    813  N   VAL A 113      13.308  37.987  37.804  1.00 20.39           N  
ATOM    814  CA  VAL A 113      14.262  37.743  38.899  1.00 22.84           C  
ATOM    815  C   VAL A 113      15.597  37.261  38.390  1.00 24.08           C  
ATOM    816  O   VAL A 113      15.641  36.423  37.485  1.00 25.77           O  
ATOM    817  CB  VAL A 113      13.738  36.662  39.893  1.00 25.38           C  
ATOM    818  CG1 VAL A 113      14.602  36.616  41.126  1.00 30.38           C  
ATOM    819  CG2 VAL A 113      12.337  36.972  40.277  1.00 27.10           C  
ATOM    820  N   CYS A 114      16.678  37.757  38.991  1.00 22.31           N  
ATOM    821  CA  CYS A 114      18.007  37.248  38.720  1.00 23.15           C  
ATOM    822  C   CYS A 114      18.578  36.761  40.034  1.00 24.20           C  
ATOM    823  O   CYS A 114      18.443  37.416  41.042  1.00 24.34           O  
ATOM    824  CB  CYS A 114      18.928  38.331  38.138  1.00 20.76           C  
ATOM    825  SG  CYS A 114      18.431  38.777  36.464  1.00 31.54           S  
ATOM    826  N   ASN A 115      19.176  35.588  39.996  1.00 23.76           N  
ATOM    827  CA  ASN A 115      19.875  35.011  41.117  1.00 25.85           C  
ATOM    828  C   ASN A 115      21.349  35.120  40.804  1.00 22.96           C  
ATOM    829  O   ASN A 115      21.813  34.633  39.776  1.00 21.19           O  
ATOM    830  CB  ASN A 115      19.430  33.573  41.296  1.00 30.25           C  
ATOM    831  CG  ASN A 115      17.917  33.450  41.486  1.00 37.09           C  
ATOM    832  OD1 ASN A 115      17.398  33.636  42.598  1.00 48.13           O  
ATOM    833  ND2 ASN A 115      17.209  33.144  40.409  1.00 35.94           N  
ATOM    834  N   VAL A 116      22.075  35.819  41.667  1.00 25.24           N  
ATOM    835  CA  VAL A 116      23.475  36.157  41.436  1.00 26.01           C  
ATOM    836  C   VAL A 116      24.272  35.596  42.588  1.00 29.14           C  
ATOM    837  O   VAL A 116      23.782  35.591  43.695  1.00 26.73           O  
ATOM    838  CB  VAL A 116      23.692  37.683  41.431  1.00 27.43           C  
ATOM    839  CG1 VAL A 116      25.002  38.024  40.679  1.00 32.37           C  
ATOM    840  CG2 VAL A 116      22.526  38.415  40.808  1.00 30.76           C  
ATOM    841  N   VAL A 117      25.482  35.104  42.339  1.00 28.60           N  
ATOM    842  CA  VAL A 117      26.389  34.762  43.425  1.00 32.08           C  
ATOM    843  C   VAL A 117      27.609  35.687  43.320  1.00 29.91           C  
ATOM    844  O   VAL A 117      28.022  36.064  42.226  1.00 30.62           O  
ATOM    845  CB  VAL A 117      26.839  33.279  43.427  1.00 34.30           C  
ATOM    846  CG1 VAL A 117      25.615  32.343  43.351  1.00 39.73           C  
ATOM    847  CG2 VAL A 117      27.724  33.003  42.288  1.00 38.65           C  
ATOM    848  N   GLY A 118      28.127  36.076  44.471  1.00 26.96           N  
ATOM    849  CA  GLY A 118      29.286  36.915  44.566  1.00 28.59           C  
ATOM    850  C   GLY A 118      30.298  36.251  45.487  1.00 27.58           C  
ATOM    851  O   GLY A 118      29.909  35.544  46.394  1.00 25.19           O  
ATOM    852  N   GLU A 119      31.589  36.456  45.200  1.00 27.22           N  
ATOM    853  CA  GLU A 119      32.700  35.992  46.041  1.00 32.27           C  
ATOM    854  C   GLU A 119      33.657  37.162  46.204  1.00 34.71           C  
ATOM    855  O   GLU A 119      33.827  37.960  45.294  1.00 35.43           O  
ATOM    856  CB  GLU A 119      33.385  34.827  45.377  1.00 32.79           C  
ATOM    857  CG  GLU A 119      32.429  33.639  45.225  1.00 40.64           C  
ATOM    858  CD  GLU A 119      32.958  32.485  44.365  1.00 43.73           C  
ATOM    859  OE1 GLU A 119      34.034  32.666  43.719  1.00 47.90           O  
ATOM    860  OE2 GLU A 119      32.280  31.404  44.361  1.00 51.17           O  
ATOM    861  N   LEU A 120      34.218  37.303  47.391  1.00 34.07           N  
ATOM    862  CA  LEU A 120      35.157  38.371  47.670  1.00 31.70           C  
ATOM    863  C   LEU A 120      36.432  37.704  48.173  1.00 32.85           C  
ATOM    864  O   LEU A 120      36.392  36.902  49.134  1.00 26.82           O  
ATOM    865  CB  LEU A 120      34.565  39.304  48.722  1.00 30.21           C  
ATOM    866  CG  LEU A 120      34.953  40.753  48.830  1.00 32.99           C  
ATOM    867  CD1 LEU A 120      34.734  41.586  47.542  1.00 33.04           C  
ATOM    868  CD2 LEU A 120      34.150  41.328  49.987  1.00 32.62           C  
ATOM    869  N   SER A 121      37.539  38.035  47.501  1.00 32.16           N  
ATOM    870  CA  SER A 121      38.862  37.562  47.850  1.00 33.57           C  
ATOM    871  C   SER A 121      39.813  38.682  48.214  1.00 32.15           C  
ATOM    872  O   SER A 121      39.701  39.813  47.721  1.00 31.76           O  
ATOM    873  CB  SER A 121      39.511  36.805  46.674  1.00 32.76           C  
ATOM    874  OG  SER A 121      38.751  35.659  46.401  1.00 47.25           O  
ATOM    875  N   GLN A 122      40.775  38.303  49.054  1.00 28.82           N  
ATOM    876  CA  GLN A 122      41.906  39.113  49.415  1.00 28.79           C  
ATOM    877  C   GLN A 122      43.093  38.169  49.618  1.00 28.39           C  
ATOM    878  O   GLN A 122      42.966  37.139  50.293  1.00 28.37           O  
ATOM    879  CB  GLN A 122      41.628  39.863  50.703  1.00 28.69           C  
ATOM    880  CG  GLN A 122      42.693  40.875  50.999  1.00 30.49           C  
ATOM    881  CD  GLN A 122      42.358  41.726  52.188  1.00 32.10           C  
ATOM    882  OE1 GLN A 122      42.275  41.227  53.316  1.00 35.14           O  
ATOM    883  NE2 GLN A 122      42.173  43.022  51.955  1.00 31.68           N  
ATOM    884  N   ASP A 123      44.231  38.541  49.035  1.00 28.43           N  
ATOM    885  CA  ASP A 123      45.481  37.779  49.061  1.00 30.19           C  
ATOM    886  C   ASP A 123      45.303  36.322  48.651  1.00 31.22           C  
ATOM    887  O   ASP A 123      45.929  35.407  49.216  1.00 32.18           O  
ATOM    888  CB  ASP A 123      46.183  37.897  50.426  1.00 31.81           C  
ATOM    889  CG  ASP A 123      46.512  39.354  50.813  1.00 40.01           C  
ATOM    890  OD1 ASP A 123      46.626  40.238  49.921  1.00 41.57           O  
ATOM    891  OD2 ASP A 123      46.649  39.614  52.035  1.00 51.58           O  
ATOM    892  N   GLY A 124      44.443  36.104  47.662  1.00 30.45           N  
ATOM    893  CA  GLY A 124      44.268  34.780  47.105  1.00 30.75           C  
ATOM    894  C   GLY A 124      43.387  33.849  47.895  1.00 31.89           C  
ATOM    895  O   GLY A 124      43.336  32.673  47.560  1.00 33.42           O  
ATOM    896  N   LYS A 125      42.697  34.357  48.926  1.00 33.12           N  
ATOM    897  CA  LYS A 125      41.715  33.562  49.696  1.00 34.80           C  
ATOM    898  C   LYS A 125      40.359  34.219  49.710  1.00 31.15           C  
ATOM    899  O   LYS A 125      40.270  35.429  49.746  1.00 29.93           O  
ATOM    900  CB  LYS A 125      42.158  33.366  51.147  1.00 34.64           C  
ATOM    901  CG  LYS A 125      43.530  32.723  51.285  1.00 39.80           C  
ATOM    902  CD  LYS A 125      43.828  32.375  52.734  1.00 43.36           C  
ATOM    903  CE  LYS A 125      45.328  32.415  52.997  1.00 55.30           C  
ATOM    904  NZ  LYS A 125      45.746  31.452  54.055  1.00 56.48           N  
ATOM    905  N   LEU A 126      39.315  33.399  49.684  1.00 32.12           N  
ATOM    906  CA  LEU A 126      37.931  33.870  49.811  1.00 34.50           C  
ATOM    907  C   LEU A 126      37.720  34.382  51.191  1.00 32.85           C  
ATOM    908  O   LEU A 126      37.921  33.641  52.131  1.00 30.47           O  
ATOM    909  CB  LEU A 126      36.928  32.749  49.672  1.00 34.48           C  
ATOM    910  CG  LEU A 126      36.306  32.455  48.328  1.00 41.50           C  
ATOM    911  CD1 LEU A 126      35.363  31.263  48.500  1.00 42.00           C  
ATOM    912  CD2 LEU A 126      35.575  33.650  47.810  1.00 51.06           C  
ATOM    913  N   VAL A 127      37.274  35.624  51.322  1.00 30.85           N  
ATOM    914  CA  VAL A 127      36.926  36.127  52.647  1.00 28.59           C  
ATOM    915  C   VAL A 127      35.412  36.058  52.938  1.00 28.81           C  
ATOM    916  O   VAL A 127      34.998  35.857  54.100  1.00 27.31           O  
ATOM    917  CB  VAL A 127      37.528  37.514  52.894  1.00 29.56           C  
ATOM    918  CG1 VAL A 127      39.062  37.419  52.853  1.00 29.05           C  
ATOM    919  CG2 VAL A 127      37.060  38.537  51.901  1.00 34.00           C  
ATOM    920  N   ALA A 128      34.593  36.225  51.903  1.00 25.09           N  
ATOM    921  CA  ALA A 128      33.180  36.234  52.078  1.00 24.79           C  
ATOM    922  C   ALA A 128      32.498  35.863  50.774  1.00 27.79           C  
ATOM    923  O   ALA A 128      33.052  36.096  49.695  1.00 28.46           O  
ATOM    924  CB  ALA A 128      32.716  37.616  52.538  1.00 23.37           C  
ATOM    925  N   THR A 129      31.311  35.269  50.889  1.00 29.12           N  
ATOM    926  CA  THR A 129      30.456  35.026  49.732  1.00 32.22           C  
ATOM    927  C   THR A 129      29.072  35.617  49.918  1.00 29.37           C  
ATOM    928  O   THR A 129      28.658  35.914  51.041  1.00 28.28           O  
ATOM    929  CB  THR A 129      30.339  33.517  49.439  1.00 30.94           C  
ATOM    930  OG1 THR A 129      29.824  32.863  50.565  1.00 36.94           O  
ATOM    931  CG2 THR A 129      31.683  32.913  49.150  1.00 29.31           C  
ATOM    932  N   ALA A 130      28.346  35.709  48.811  1.00 27.56           N  
ATOM    933  CA  ALA A 130      26.991  36.171  48.796  1.00 25.75           C  
ATOM    934  C   ALA A 130      26.094  35.469  47.774  1.00 28.54           C  
ATOM    935  O   ALA A 130      26.541  35.011  46.719  1.00 25.49           O  
ATOM    936  CB  ALA A 130      26.944  37.639  48.496  1.00 30.83           C  
ATOM    937  N   THR A 131      24.801  35.490  48.090  1.00 27.54           N  
ATOM    938  CA  THR A 131      23.736  35.178  47.177  1.00 32.64           C  
ATOM    939  C   THR A 131      22.785  36.363  47.176  1.00 30.66           C  
ATOM    940  O   THR A 131      22.284  36.760  48.231  1.00 32.63           O  
ATOM    941  CB  THR A 131      23.000  33.890  47.703  1.00 35.21           C  
ATOM    942  OG1 THR A 131      23.872  32.764  47.527  1.00 44.89           O  
ATOM    943  CG2 THR A 131      21.707  33.654  46.959  1.00 40.10           C  
ATOM    944  N   ALA A 132      22.520  36.904  46.008  1.00 29.19           N  
ATOM    945  CA  ALA A 132      21.589  38.006  45.828  1.00 28.06           C  
ATOM    946  C   ALA A 132      20.406  37.561  45.020  1.00 27.45           C  
ATOM    947  O   ALA A 132      20.564  36.884  44.007  1.00 29.72           O  
ATOM    948  CB  ALA A 132      22.262  39.140  45.090  1.00 30.49           C  
ATOM    949  N   THR A 133      19.218  37.930  45.486  1.00 26.60           N  
ATOM    950  CA  THR A 133      17.982  37.813  44.723  1.00 29.24           C  
ATOM    951  C   THR A 133      17.538  39.196  44.322  1.00 26.08           C  
ATOM    952  O   THR A 133      17.287  40.015  45.188  1.00 27.52           O  
ATOM    953  CB  THR A 133      16.895  37.178  45.593  1.00 32.27           C  
ATOM    954  OG1 THR A 133      17.383  35.931  46.058  1.00 29.76           O  
ATOM    955  CG2 THR A 133      15.629  36.994  44.829  1.00 28.40           C  
ATOM    956  N   CYS A 134      17.461  39.441  43.022  1.00 25.65           N  
ATOM    957  CA  CYS A 134      17.250  40.763  42.456  1.00 29.29           C  
ATOM    958  C   CYS A 134      16.049  40.737  41.554  1.00 28.22           C  
ATOM    959  O   CYS A 134      15.838  39.768  40.858  1.00 31.02           O  
ATOM    960  CB  CYS A 134      18.442  41.189  41.595  1.00 28.91           C  
ATOM    961  SG  CYS A 134      19.984  41.163  42.484  1.00 36.13           S  
HETATM  962  N   MSE A 135      15.251  41.789  41.578  1.00 28.52           N  
HETATM  963  CA  MSE A 135      14.129  41.908  40.655  1.00 31.87           C  
HETATM  964  C   MSE A 135      14.497  43.005  39.700  1.00 30.24           C  
HETATM  965  O   MSE A 135      15.289  43.871  40.059  1.00 25.88           O  
HETATM  966  CB  MSE A 135      12.881  42.326  41.414  1.00 34.99           C  
HETATM  967  CG  MSE A 135      11.564  42.102  40.695  1.00 33.07           C  
HETATM  968 SE   MSE A 135      10.160  42.792  41.865  0.75 42.77          SE  
HETATM  969  CE  MSE A 135       9.238  41.358  42.406  1.00 50.40           C  
ATOM    970  N   VAL A 136      13.905  42.998  38.500  1.00 33.47           N  
ATOM    971  CA  VAL A 136      14.189  44.029  37.531  1.00 35.73           C  
ATOM    972  C   VAL A 136      12.954  44.834  37.088  1.00 35.76           C  
ATOM    973  O   VAL A 136      11.924  44.262  36.753  1.00 37.77           O  
ATOM    974  CB  VAL A 136      14.986  43.463  36.294  1.00 38.33           C  
ATOM    975  CG1 VAL A 136      15.915  42.279  36.688  1.00 34.42           C  
ATOM    976  CG2 VAL A 136      14.079  43.055  35.236  1.00 39.15           C  
TER     977      VAL A 136                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
