
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  938),  selected  126 , name 1zki_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1zki_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     4_A      -       -           -
LGA    P     5_A      -       -           -
LGA    A     6_A      -       -           -
LGA    R     7_A      T       6          5.648
LGA    E     8_A      D       7          2.234
LGA    Q     9_A      F       8          4.887
LGA    X    10_A      F       9          2.672
LGA    I    11_A      G      10           #
LGA    -       -      L      11           -
LGA    -       -      T      12           -
LGA    S    12_A      I      13          0.497
LGA    A    13_A      P      14          0.415
LGA    Y    14_A      F      15          0.510
LGA    S    15_A      M      16          0.507
LGA    E    16_A      Q      17          0.658
LGA    L    17_A      L      18          0.637
LGA    V    18_A      L      19          0.893
LGA    G    19_A      G      20          1.147
LGA    L    20_A      V      21          1.270
LGA    D    21_A      V      22          0.651
LGA    P    22_A      P      23          0.278
LGA    V    23_A      E      24          0.582
LGA    S    24_A      H      25          1.153
LGA    L    25_A      S      26          1.704
LGA    G    26_A      G      27          2.527
LGA    D    27_A      N      28          0.398
LGA    G    28_A      G      29          1.112
LGA    V    29_A      T      30          0.606
LGA    A    30_A      A      31          0.471
LGA    E    31_A      R      32          0.156
LGA    V    32_A      T      33          0.249
LGA    R    33_A      R      34          0.071
LGA    L    34_A      L      35          0.225
LGA    P    35_A      P      36          0.981
LGA    X    36_A      A      37          1.321
LGA    A    37_A      R      38          0.408
LGA    A    38_A      A      39          0.757
LGA    H    39_A      D      40          0.587
LGA    L    40_A      L      41          0.668
LGA    R    41_A      V      42          0.938
LGA    N    42_A      N      43          0.915
LGA    R    43_A      S      44          0.964
LGA    G    44_A      R      45          0.699
LGA    G    45_A      G      46          0.779
LGA    V    46_A      D      47          0.668
LGA    X    47_A      I      48          0.094
LGA    H    48_A      H      49          0.041
LGA    G    49_A      G      50          0.395
LGA    G    50_A      G      51          0.182
LGA    A    51_A      T      52          0.116
LGA    L    52_A      L      53          0.516
LGA    F    53_A      M      54          0.533
LGA    S    54_A      S      55          0.519
LGA    L    55_A      V      56          0.883
LGA    X    56_A      L      57          0.391
LGA    D    57_A      D      58          0.289
LGA    V    58_A      F      59          0.455
LGA    T    59_A      T      60          0.428
LGA    X    60_A      L      61          0.632
LGA    G    61_A      G      62          1.396
LGA    L    62_A      A      63          0.997
LGA    A    63_A      A      64          0.907
LGA    C    64_A      I      65          1.368
LGA    S    65_A      R      66          0.682
LGA    S    66_A      G      67          1.440
LGA    S    67_A      D      68          3.193
LGA    H    68_A      -       -           -
LGA    G    69_A      T      69          0.730
LGA    F    70_A      P      70          0.675
LGA    D    71_A      E      71          1.308
LGA    R    72_A      V      72          1.168
LGA    Q    73_A      G      73          0.553
LGA    S    74_A      V      74          0.882
LGA    V    75_A      A      75          0.488
LGA    T    76_A      T      76          0.294
LGA    L    77_A      I      77          0.338
LGA    E    78_A      D      78          0.554
LGA    C    79_A      M      79          0.356
LGA    K    80_A      N      80          0.263
LGA    I    81_A      T      81          0.398
LGA    N    82_A      S      82          0.324
LGA    Y    83_A      F      83          0.672
LGA    I    84_A      M      84          0.584
LGA    R    85_A      S      85          0.480
LGA    A    86_A      P      86          0.631
LGA    V    87_A      G      87          1.908
LGA    A    88_A      R      88          2.850
LGA    D    89_A      G      89          2.409
LGA    G    90_A      -       -           -
LGA    E    91_A      D      90          0.438
LGA    V    92_A      L      91          0.335
LGA    R    93_A      V      92          0.503
LGA    C    94_A      I      93          0.581
LGA    V    95_A      E      94          0.353
LGA    A    96_A      T      95          0.616
LGA    R    97_A      R      96          0.379
LGA    V    98_A      C      97          0.378
LGA    L    99_A      L      98          0.316
LGA    H   100_A      R      99          0.230
LGA    A   101_A      R     100          0.418
LGA    G   102_A      G     101          0.274
LGA    R   103_A      A     102          0.458
LGA    R   104_A      S     103          0.839
LGA    S   105_A      I     104          0.370
LGA    L   106_A      A     105          0.200
LGA    V   107_A      F     106          0.092
LGA    V   108_A      C     107          0.175
LGA    E   109_A      E     108          0.325
LGA    A   110_A      G     109          0.502
LGA    E   111_A      E     110          0.590
LGA    V   112_A      I     111          0.489
LGA    R   113_A      R     112          0.593
LGA    Q   114_A      D     113          1.360
LGA    G   115_A      S     114          3.924
LGA    -       -      A     115           -
LGA    D   116_A      G     116          2.025
LGA    K   117_A      E     117          0.698
LGA    L   118_A      L     118          0.629
LGA    V   119_A      V     119          0.504
LGA    A   120_A      A     120          0.476
LGA    K   121_A      K     121          0.369
LGA    G   122_A      A     122          0.698
LGA    Q   123_A      T     123          0.411
LGA    G   124_A      A     124          0.501
LGA    T   125_A      T     125          0.174
LGA    F   126_A      F     126          0.287
LGA    A   127_A      K     127          0.494
LGA    Q   128_A      I     128          1.132
LGA    L   129_A      I     129          0.666
LGA    -       -      Q     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  125    5.0    120    1.20    29.17     93.316     9.243

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.064992 * X  +  -0.529644 * Y  +  -0.845726 * Z  +  47.167664
  Y_new =   0.538812 * X  +  -0.694726 * Y  +   0.476485 * Z  +  45.109100
  Z_new =  -0.839915 * X  +  -0.486655 * Y  +   0.240227 * Z  +  49.195610 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.112259    2.029334  [ DEG:   -63.7277    116.2723 ]
  Theta =   0.997127    2.144466  [ DEG:    57.1312    122.8688 ]
  Phi   =   1.450755   -1.690837  [ DEG:    83.1222    -96.8778 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zki_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zki_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  125   5.0  120   1.20   29.17  93.316
REMARK  ---------------------------------------------------------- 
MOLECULE 1zki_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   02-MAY-05   1ZKI              
TITLE     STRUCTURE OF CONSERVED PROTEIN PA5202 FROM PSEUDOMONAS                
TITLE    2 AERUGINOSA                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA5202;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PAO1;                                                        
SOURCE   5 GENE: PA5202;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: P11                                       
KEYWDS    PSEUDOMONAS AERUGINOSA, STRUCTURAL GENOMICS, PSI, PROTEIN             
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,E.EVDOKIMOVA,A.EDWARDS,A.SAVCHENKO,A.JOACHIMIAK,             
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   2   09-AUG-05 1ZKI    1       AUTHOR JRNL                              
REVDAT   1   14-JUN-05 1ZKI    0                                                
JRNL        AUTH   M.E.CUFF,E.EVDOKIMOVA,A.EDWARDS,A.SAVCHENKO,                 
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   STRUCTURE OF CONSERVED PROTEIN PA5202 FROM                   
JRNL        TITL 2 PSEUDOMONAS AERUGINOSA                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1ZKI A    1   129  UNP    Q9HTY7   Q9HTY7_PSEAE     1    129             
DBREF  1ZKI B    1   129  UNP    Q9HTY7   Q9HTY7_PSEAE     1    129             
SEQRES   1 A  133  ASN GLY MSE SER GLU MSE PRO ALA ARG GLU GLN MSE ILE          
SEQRES   2 A  133  SER ALA TYR SER GLU LEU VAL GLY LEU ASP PRO VAL SER          
SEQRES   3 A  133  LEU GLY ASP GLY VAL ALA GLU VAL ARG LEU PRO MSE ALA          
SEQRES   4 A  133  ALA HIS LEU ARG ASN ARG GLY GLY VAL MSE HIS GLY GLY          
SEQRES   5 A  133  ALA LEU PHE SER LEU MSE ASP VAL THR MSE GLY LEU ALA          
SEQRES   6 A  133  CYS SER SER SER HIS GLY PHE ASP ARG GLN SER VAL THR          
SEQRES   7 A  133  LEU GLU CYS LYS ILE ASN TYR ILE ARG ALA VAL ALA ASP          
SEQRES   8 A  133  GLY GLU VAL ARG CYS VAL ALA ARG VAL LEU HIS ALA GLY          
SEQRES   9 A  133  ARG ARG SER LEU VAL VAL GLU ALA GLU VAL ARG GLN GLY          
SEQRES  10 A  133  ASP LYS LEU VAL ALA LYS GLY GLN GLY THR PHE ALA GLN          
SEQRES  11 A  133  LEU GLY SER                                                  
SEQRES   1 B  133  ASN GLY MSE SER GLU MSE PRO ALA ARG GLU GLN MSE ILE          
SEQRES   2 B  133  SER ALA TYR SER GLU LEU VAL GLY LEU ASP PRO VAL SER          
SEQRES   3 B  133  LEU GLY ASP GLY VAL ALA GLU VAL ARG LEU PRO MSE ALA          
SEQRES   4 B  133  ALA HIS LEU ARG ASN ARG GLY GLY VAL MSE HIS GLY GLY          
SEQRES   5 B  133  ALA LEU PHE SER LEU MSE ASP VAL THR MSE GLY LEU ALA          
SEQRES   6 B  133  CYS SER SER SER HIS GLY PHE ASP ARG GLN SER VAL THR          
SEQRES   7 B  133  LEU GLU CYS LYS ILE ASN TYR ILE ARG ALA VAL ALA ASP          
SEQRES   8 B  133  GLY GLU VAL ARG CYS VAL ALA ARG VAL LEU HIS ALA GLY          
SEQRES   9 B  133  ARG ARG SER LEU VAL VAL GLU ALA GLU VAL ARG GLN GLY          
SEQRES  10 B  133  ASP LYS LEU VAL ALA LYS GLY GLN GLY THR PHE ALA GLN          
SEQRES  11 B  133  LEU GLY SER                                                  
HET    MSE  A   4       8                                                       
HET    MSE  A  10       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  47       8                                                       
HET    MSE  A  56       8                                                       
HET    MSE  A  60       8                                                       
HET    MSE  B  10       8                                                       
HET    MSE  B  36       8                                                       
HET    MSE  B  47       8                                                       
HET    MSE  B  56       8                                                       
HET    MSE  B  60       8                                                       
HET    ACY    804       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACY ACETIC ACID                                                      
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   3  ACY    C2 H4 O2                                                     
FORMUL   4  HOH   *252(H2 O)                                                    
CRYST1   57.948   57.948  113.502  90.00  90.00 120.00 P 31 2 1     12          
HETATM    1  N   MSE A   4      33.165  47.394  28.732  1.00 54.71           N  
HETATM    2  CA  MSE A   4      32.601  48.200  29.851  1.00 55.44           C  
HETATM    3  C   MSE A   4      32.107  49.568  29.379  1.00 52.82           C  
HETATM    4  O   MSE A   4      32.816  50.259  28.642  1.00 53.19           O  
HETATM    5  CB  MSE A   4      33.647  48.405  30.954  1.00 55.19           C  
HETATM    6  CG  MSE A   4      33.915  47.183  31.826  1.00 57.18           C  
HETATM    7 SE   MSE A   4      34.694  47.652  33.586  1.00 61.69          SE  
HETATM    8  CE  MSE A   4      36.335  48.671  32.979  1.00 60.06           C  
ATOM      9  N   PRO A   5      30.889  49.965  29.802  1.00 50.86           N  
ATOM     10  CA  PRO A   5      30.483  51.369  29.673  1.00 48.95           C  
ATOM     11  C   PRO A   5      31.404  52.282  30.493  1.00 47.01           C  
ATOM     12  O   PRO A   5      32.305  51.795  31.178  1.00 46.82           O  
ATOM     13  CB  PRO A   5      29.052  51.379  30.232  1.00 49.00           C  
ATOM     14  CG  PRO A   5      28.942  50.143  31.060  1.00 49.91           C  
ATOM     15  CD  PRO A   5      29.824  49.135  30.394  1.00 50.60           C  
ATOM     16  N   ALA A   6      31.192  53.591  30.416  1.00 44.87           N  
ATOM     17  CA  ALA A   6      32.018  54.538  31.163  1.00 42.78           C  
ATOM     18  C   ALA A   6      31.912  54.258  32.659  1.00 41.26           C  
ATOM     19  O   ALA A   6      30.871  53.794  33.125  1.00 40.53           O  
ATOM     20  CB  ALA A   6      31.594  55.961  30.855  1.00 42.95           C  
ATOM     21  N   ARG A   7      32.985  54.532  33.404  1.00 39.59           N  
ATOM     22  CA  ARG A   7      32.999  54.300  34.854  1.00 37.97           C  
ATOM     23  C   ARG A   7      31.811  54.973  35.545  1.00 36.88           C  
ATOM     24  O   ARG A   7      31.175  54.369  36.421  1.00 36.35           O  
ATOM     25  CB  ARG A   7      34.324  54.749  35.493  1.00 38.16           C  
ATOM     26  CG  ARG A   7      34.524  54.235  36.925  1.00 37.93           C  
ATOM     27  CD  ARG A   7      35.903  54.592  37.481  1.00 38.17           C  
ATOM     28  NE  ARG A   7      36.129  54.006  38.804  1.00 38.27           N  
ATOM     29  CZ  ARG A   7      35.834  54.608  39.957  1.00 39.31           C  
ATOM     30  NH1 ARG A   7      36.067  53.993  41.112  1.00 39.05           N  
ATOM     31  NH2 ARG A   7      35.306  55.827  39.964  1.00 38.06           N  
ATOM     32  N   GLU A   8      31.511  56.209  35.146  0.50 36.12           N  
ATOM     34  CA  GLU A   8      30.418  56.980  35.746  0.50 35.64           C  
ATOM     36  C   GLU A   8      29.070  56.259  35.678  0.50 35.09           C  
ATOM     38  O   GLU A   8      28.173  56.531  36.470  0.50 35.10           O  
ATOM     40  CB  GLU A   8      30.324  58.374  35.109  0.50 35.64           C  
ATOM     42  CG  GLU A   8      29.289  59.309  35.745  0.50 36.12           C  
ATOM     44  CD  GLU A   8      29.441  59.433  37.258  0.50 36.88           C  
ATOM     46  OE1 GLU A   8      28.518  59.000  37.981  0.50 36.57           O  
ATOM     48  OE2 GLU A   8      30.481  59.953  37.725  0.50 37.11           O  
ATOM     50  N   GLN A   9      28.944  55.329  34.735  1.00 34.55           N  
ATOM     51  CA  GLN A   9      27.704  54.575  34.531  1.00 33.68           C  
ATOM     52  C   GLN A   9      27.602  53.380  35.498  1.00 32.15           C  
ATOM     53  O   GLN A   9      26.545  52.751  35.631  1.00 32.20           O  
ATOM     54  CB  GLN A   9      27.657  54.101  33.069  1.00 34.30           C  
ATOM     55  CG  GLN A   9      26.486  53.209  32.685  1.00 37.16           C  
ATOM     56  CD  GLN A   9      25.401  53.942  31.909  1.00 40.01           C  
ATOM     57  OE1 GLN A   9      24.845  53.402  30.946  1.00 41.01           O  
ATOM     58  NE2 GLN A   9      25.095  55.172  32.320  1.00 41.20           N  
HETATM   59  N   MSE A  10      28.705  53.068  36.171  1.00 29.57           N  
HETATM   60  CA  MSE A  10      28.781  51.859  36.984  1.00 28.46           C  
HETATM   61  C   MSE A  10      28.954  52.127  38.472  1.00 25.95           C  
HETATM   62  O   MSE A  10      29.132  51.183  39.256  1.00 26.10           O  
HETATM   63  CB  MSE A  10      29.942  50.998  36.509  1.00 27.89           C  
HETATM   64  CG  MSE A  10      29.834  50.575  35.071  1.00 29.33           C  
HETATM   65 SE   MSE A  10      31.327  49.420  34.697  1.00 33.07          SE  
HETATM   66  CE  MSE A  10      32.709  50.749  34.390  1.00 31.53           C  
ATOM     67  N   ILE A  11      28.951  53.400  38.857  1.00 22.28           N  
ATOM     68  CA  ILE A  11      29.270  53.766  40.232  1.00 19.77           C  
ATOM     69  C   ILE A  11      28.182  54.640  40.832  1.00 17.72           C  
ATOM     70  O   ILE A  11      27.362  55.214  40.108  1.00 17.06           O  
ATOM     71  CB  ILE A  11      30.643  54.490  40.335  1.00 19.92           C  
ATOM     72  CG1 ILE A  11      30.595  55.839  39.595  1.00 19.89           C  
ATOM     73  CG2 ILE A  11      31.767  53.602  39.804  1.00 20.52           C  
ATOM     74  CD1 ILE A  11      31.904  56.634  39.624  1.00 20.78           C  
ATOM     75  N   SER A  12      28.171  54.724  42.155  1.00 15.28           N  
ATOM     76  CA  SER A  12      27.234  55.584  42.878  1.00 13.93           C  
ATOM     77  C   SER A  12      28.043  56.372  43.915  1.00 12.90           C  
ATOM     78  O   SER A  12      29.214  56.058  44.146  1.00 12.28           O  
ATOM     79  CB  SER A  12      26.182  54.740  43.603  1.00 13.90           C  
ATOM     80  OG  SER A  12      26.768  53.894  44.592  1.00 12.88           O  
ATOM     81  N   ALA A  13      27.420  57.354  44.561  1.00 11.67           N  
ATOM     82  CA  ALA A  13      28.091  58.083  45.640  1.00 11.26           C  
ATOM     83  C   ALA A  13      28.562  57.101  46.717  1.00 11.80           C  
ATOM     84  O   ALA A  13      29.676  57.216  47.232  1.00 11.92           O  
ATOM     85  CB  ALA A  13      27.167  59.101  46.248  1.00 11.24           C  
ATOM     86  N   TYR A  14      27.719  56.119  47.039  1.00 11.04           N  
ATOM     87  CA  TYR A  14      28.085  55.183  48.094  1.00 11.40           C  
ATOM     88  C   TYR A  14      29.226  54.242  47.676  1.00 11.45           C  
ATOM     89  O   TYR A  14      30.139  53.976  48.472  1.00 11.26           O  
ATOM     90  CB  TYR A  14      26.865  54.404  48.591  1.00 11.76           C  
ATOM     91  CG  TYR A  14      27.165  53.435  49.704  1.00 12.50           C  
ATOM     92  CD1 TYR A  14      27.371  53.889  51.013  1.00 12.53           C  
ATOM     93  CD2 TYR A  14      27.236  52.054  49.452  1.00 12.73           C  
ATOM     94  CE1 TYR A  14      27.632  52.983  52.062  1.00 13.14           C  
ATOM     95  CE2 TYR A  14      27.503  51.134  50.496  1.00 12.32           C  
ATOM     96  CZ  TYR A  14      27.703  51.622  51.789  1.00 14.47           C  
ATOM     97  OH  TYR A  14      27.953  50.758  52.823  1.00 14.55           O  
ATOM     98  N   SER A  15      29.210  53.760  46.435  1.00 11.39           N  
ATOM     99  CA  SER A  15      30.296  52.879  45.999  1.00 12.05           C  
ATOM    100  C   SER A  15      31.612  53.660  46.023  1.00 11.77           C  
ATOM    101  O   SER A  15      32.641  53.134  46.403  1.00 12.18           O  
ATOM    102  CB  SER A  15      30.031  52.257  44.618  1.00 12.33           C  
ATOM    103  OG  SER A  15      30.200  53.190  43.557  1.00 14.48           O  
ATOM    104  N   GLU A  16      31.561  54.933  45.670  1.00 12.13           N  
ATOM    105  CA  GLU A  16      32.752  55.799  45.740  1.00 11.98           C  
ATOM    106  C   GLU A  16      33.282  56.005  47.157  1.00 12.38           C  
ATOM    107  O   GLU A  16      34.504  55.999  47.382  1.00 11.77           O  
ATOM    108  CB  GLU A  16      32.422  57.144  45.109  1.00 12.94           C  
ATOM    109  CG  GLU A  16      32.162  56.999  43.654  1.00 14.22           C  
ATOM    110  CD  GLU A  16      33.416  57.179  42.894  1.00 22.59           C  
ATOM    111  OE1 GLU A  16      34.047  56.133  42.595  1.00 26.82           O  
ATOM    112  OE2 GLU A  16      33.769  58.370  42.644  1.00 21.14           O  
ATOM    113  N   LEU A  17      32.358  56.177  48.102  1.00 12.69           N  
ATOM    114  CA  LEU A  17      32.680  56.370  49.511  1.00 12.89           C  
ATOM    115  C   LEU A  17      33.447  55.159  50.036  1.00 13.11           C  
ATOM    116  O   LEU A  17      34.495  55.289  50.672  1.00 12.86           O  
ATOM    117  CB  LEU A  17      31.393  56.513  50.327  1.00 12.84           C  
ATOM    118  CG  LEU A  17      31.579  56.635  51.846  1.00 12.52           C  
ATOM    119  CD1 LEU A  17      32.076  58.048  52.223  1.00 13.55           C  
ATOM    120  CD2 LEU A  17      30.277  56.236  52.611  1.00 13.89           C  
ATOM    121  N   VAL A  18      32.924  53.975  49.751  1.00 12.28           N  
ATOM    122  CA  VAL A  18      33.554  52.756  50.248  1.00 12.73           C  
ATOM    123  C   VAL A  18      34.907  52.511  49.556  1.00 13.35           C  
ATOM    124  O   VAL A  18      35.825  51.917  50.146  1.00 13.47           O  
ATOM    125  CB  VAL A  18      32.583  51.571  50.111  1.00 13.06           C  
ATOM    126  CG1 VAL A  18      33.248  50.274  50.498  1.00 12.72           C  
ATOM    127  CG2 VAL A  18      31.376  51.821  51.003  1.00 13.62           C  
ATOM    128  N   GLY A  19      35.019  52.973  48.311  1.00 13.29           N  
ATOM    129  CA  GLY A  19      36.232  52.809  47.510  1.00 14.04           C  
ATOM    130  C   GLY A  19      36.155  51.652  46.527  1.00 13.94           C  
ATOM    131  O   GLY A  19      37.190  51.100  46.112  1.00 13.67           O  
ATOM    132  N   LEU A  20      34.929  51.298  46.134  1.00 14.03           N  
ATOM    133  CA  LEU A  20      34.712  50.193  45.200  1.00 14.90           C  
ATOM    134  C   LEU A  20      35.147  50.633  43.813  1.00 15.47           C  
ATOM    135  O   LEU A  20      34.852  51.737  43.387  1.00 16.82           O  
ATOM    136  CB  LEU A  20      33.240  49.741  45.183  1.00 14.54           C  
ATOM    137  CG  LEU A  20      32.705  49.331  46.552  1.00 13.29           C  
ATOM    138  CD1 LEU A  20      31.202  49.035  46.536  1.00 15.97           C  
ATOM    139  CD2 LEU A  20      33.494  48.160  47.187  1.00 14.58           C  
ATOM    140  N   ASP A  21      35.743  49.709  43.083  0.50 15.14           N  
ATOM    142  CA  ASP A  21      36.366  50.040  41.840  0.50 14.51           C  
ATOM    144  C   ASP A  21      36.040  48.929  40.829  0.50 14.56           C  
ATOM    146  O   ASP A  21      36.615  47.843  40.910  0.50 13.90           O  
ATOM    148  CB  ASP A  21      37.866  50.163  42.137  0.50 14.74           C  
ATOM    150  CG  ASP A  21      38.686  50.531  40.942  0.50 14.52           C  
ATOM    152  OD1 ASP A  21      38.148  51.118  39.985  0.50 16.51           O  
ATOM    154  OD2 ASP A  21      39.904  50.250  40.989  0.50 15.75           O  
ATOM    156  N   PRO A  22      35.103  49.185  39.885  1.00 14.93           N  
ATOM    157  CA  PRO A  22      34.790  48.146  38.884  1.00 14.39           C  
ATOM    158  C   PRO A  22      36.042  47.737  38.117  1.00 14.12           C  
ATOM    159  O   PRO A  22      36.868  48.602  37.802  1.00 14.78           O  
ATOM    160  CB  PRO A  22      33.801  48.844  37.937  1.00 15.33           C  
ATOM    161  CG  PRO A  22      33.184  49.938  38.792  1.00 15.80           C  
ATOM    162  CD  PRO A  22      34.319  50.421  39.648  1.00 15.21           C  
ATOM    163  N   VAL A  23      36.183  46.437  37.851  1.00 13.10           N  
ATOM    164  CA  VAL A  23      37.348  45.886  37.145  1.00 13.40           C  
ATOM    165  C   VAL A  23      36.964  45.380  35.756  1.00 14.11           C  
ATOM    166  O   VAL A  23      37.629  45.714  34.758  1.00 14.04           O  
ATOM    167  CB  VAL A  23      38.008  44.724  37.953  1.00 13.23           C  
ATOM    168  CG1 VAL A  23      39.136  44.066  37.150  1.00 13.88           C  
ATOM    169  CG2 VAL A  23      38.566  45.246  39.262  1.00 13.46           C  
ATOM    170  N   SER A  24      35.905  44.572  35.679  1.00 14.43           N  
ATOM    171  CA  SER A  24      35.474  44.017  34.395  1.00 15.66           C  
ATOM    172  C   SER A  24      34.013  43.594  34.408  1.00 16.30           C  
ATOM    173  O   SER A  24      33.406  43.448  35.466  1.00 15.12           O  
ATOM    174  CB  SER A  24      36.341  42.823  33.999  1.00 16.19           C  
ATOM    175  OG  SER A  24      36.200  41.767  34.929  1.00 17.75           O  
ATOM    176  N   LEU A  25      33.472  43.407  33.214  1.00 17.43           N  
ATOM    177  CA  LEU A  25      32.122  42.890  33.013  1.00 19.26           C  
ATOM    178  C   LEU A  25      32.147  41.879  31.880  1.00 20.54           C  
ATOM    179  O   LEU A  25      32.843  42.078  30.874  1.00 20.98           O  
ATOM    180  CB  LEU A  25      31.175  44.002  32.587  1.00 19.62           C  
ATOM    181  CG  LEU A  25      30.939  45.234  33.446  1.00 21.86           C  
ATOM    182  CD1 LEU A  25      30.145  46.220  32.634  1.00 24.61           C  
ATOM    183  CD2 LEU A  25      30.186  44.854  34.694  1.00 22.35           C  
ATOM    184  N   GLY A  26      31.374  40.814  32.037  1.00 20.65           N  
ATOM    185  CA  GLY A  26      31.195  39.814  31.003  1.00 21.55           C  
ATOM    186  C   GLY A  26      29.708  39.621  30.800  1.00 21.22           C  
ATOM    187  O   GLY A  26      28.922  40.510  31.084  1.00 21.69           O  
ATOM    188  N   ASP A  27      29.329  38.466  30.285  1.00 21.64           N  
ATOM    189  CA  ASP A  27      27.935  38.179  30.009  1.00 20.74           C  
ATOM    190  C   ASP A  27      27.318  37.624  31.283  1.00 18.89           C  
ATOM    191  O   ASP A  27      27.373  36.407  31.521  1.00 18.36           O  
ATOM    192  CB  ASP A  27      27.821  37.152  28.884  1.00 21.86           C  
ATOM    193  CG  ASP A  27      26.369  36.885  28.478  1.00 25.23           C  
ATOM    194  OD1 ASP A  27      25.452  37.573  28.991  1.00 29.29           O  
ATOM    195  OD2 ASP A  27      26.146  35.985  27.633  1.00 29.05           O  
ATOM    196  N   GLY A  28      26.738  38.511  32.092  1.00 16.90           N  
ATOM    197  CA  GLY A  28      26.124  38.112  33.368  1.00 15.28           C  
ATOM    198  C   GLY A  28      27.168  37.858  34.446  1.00 14.49           C  
ATOM    199  O   GLY A  28      26.932  37.094  35.372  1.00 14.76           O  
ATOM    200  N   VAL A  29      28.322  38.506  34.316  0.50 13.99           N  
ATOM    202  CA  VAL A  29      29.414  38.369  35.283  0.50 13.35           C  
ATOM    204  C   VAL A  29      30.117  39.723  35.443  0.50 13.07           C  
ATOM    206  O   VAL A  29      30.262  40.479  34.474  0.50 13.01           O  
ATOM    208  CB  VAL A  29      30.406  37.217  34.878  0.50 13.69           C  
ATOM    210  CG1 VAL A  29      31.007  37.458  33.503  0.50 13.45           C  
ATOM    212  CG2 VAL A  29      31.512  37.010  35.922  0.50 13.74           C  
ATOM    214  N   ALA A  30      30.525  40.038  36.671  1.00 12.30           N  
ATOM    215  CA  ALA A  30      31.245  41.272  36.950  1.00 12.20           C  
ATOM    216  C   ALA A  30      32.311  41.053  38.002  1.00 12.23           C  
ATOM    217  O   ALA A  30      32.200  40.137  38.818  1.00 12.57           O  
ATOM    218  CB  ALA A  30      30.270  42.369  37.397  1.00 12.23           C  
ATOM    219  N   GLU A  31      33.346  41.886  37.965  1.00 11.62           N  
ATOM    220  CA  GLU A  31      34.378  41.873  38.990  1.00 12.53           C  
ATOM    221  C   GLU A  31      34.597  43.295  39.472  1.00 11.85           C  
ATOM    222  O   GLU A  31      34.687  44.224  38.665  1.00 10.79           O  
ATOM    223  CB  GLU A  31      35.704  41.285  38.476  1.00 11.94           C  
ATOM    224  CG  GLU A  31      36.802  41.277  39.567  1.00 13.90           C  
ATOM    225  CD  GLU A  31      38.070  40.526  39.179  1.00 16.51           C  
ATOM    226  OE1 GLU A  31      38.067  39.799  38.157  1.00 19.33           O  
ATOM    227  OE2 GLU A  31      39.082  40.668  39.910  1.00 18.56           O  
ATOM    228  N   VAL A  32      34.697  43.439  40.790  1.00 11.46           N  
ATOM    229  CA  VAL A  32      34.941  44.730  41.440  1.00 11.26           C  
ATOM    230  C   VAL A  32      36.059  44.552  42.476  1.00 11.50           C  
ATOM    231  O   VAL A  32      36.120  43.504  43.132  1.00 11.52           O  
ATOM    232  CB  VAL A  32      33.620  45.242  42.111  1.00 11.38           C  
ATOM    233  CG1 VAL A  32      33.842  46.513  42.892  1.00 13.07           C  
ATOM    234  CG2 VAL A  32      32.511  45.434  41.059  1.00 10.71           C  
ATOM    235  N   ARG A  33      36.938  45.548  42.619  1.00 11.48           N  
ATOM    236  CA  ARG A  33      38.016  45.475  43.617  1.00 11.62           C  
ATOM    237  C   ARG A  33      37.749  46.466  44.735  1.00 12.35           C  
ATOM    238  O   ARG A  33      37.061  47.476  44.524  1.00 11.81           O  
ATOM    239  CB  ARG A  33      39.397  45.732  42.982  1.00 12.38           C  
ATOM    240  CG  ARG A  33      39.591  47.116  42.445  1.00 11.70           C  
ATOM    241  CD  ARG A  33      40.982  47.307  41.791  1.00 12.60           C  
ATOM    242  NE  ARG A  33      42.079  47.407  42.767  1.00 12.81           N  
ATOM    243  CZ  ARG A  33      42.469  48.528  43.372  1.00 13.07           C  
ATOM    244  NH1 ARG A  33      43.483  48.502  44.239  1.00 12.30           N  
ATOM    245  NH2 ARG A  33      41.844  49.690  43.136  1.00 14.84           N  
ATOM    246  N   LEU A  34      38.300  46.174  45.910  1.00 11.77           N  
ATOM    247  CA  LEU A  34      38.167  47.026  47.091  1.00 12.40           C  
ATOM    248  C   LEU A  34      39.479  46.992  47.861  1.00 12.62           C  
ATOM    249  O   LEU A  34      39.783  45.987  48.505  1.00 12.19           O  
ATOM    250  CB  LEU A  34      37.006  46.578  47.995  1.00 12.59           C  
ATOM    251  CG  LEU A  34      36.836  47.344  49.330  1.00 12.50           C  
ATOM    252  CD1 LEU A  34      36.769  48.868  49.100  1.00 13.04           C  
ATOM    253  CD2 LEU A  34      35.580  46.835  50.102  1.00 13.15           C  
ATOM    254  N   PRO A  35      40.261  48.083  47.783  1.00 12.95           N  
ATOM    255  CA  PRO A  35      41.481  48.170  48.588  1.00 13.44           C  
ATOM    256  C   PRO A  35      41.155  48.501  50.041  1.00 14.08           C  
ATOM    257  O   PRO A  35      40.226  49.293  50.310  1.00 13.82           O  
ATOM    258  CB  PRO A  35      42.257  49.323  47.934  1.00 13.89           C  
ATOM    259  CG  PRO A  35      41.210  50.185  47.297  1.00 13.91           C  
ATOM    260  CD  PRO A  35      40.073  49.252  46.899  1.00 12.73           C  
HETATM  261  N   MSE A  36      41.895  47.894  50.977  1.00 15.45           N  
HETATM  262  CA  MSE A  36      41.756  48.249  52.397  1.00 15.99           C  
HETATM  263  C   MSE A  36      42.066  49.736  52.590  1.00 15.21           C  
HETATM  264  O   MSE A  36      42.907  50.320  51.888  1.00 14.46           O  
HETATM  265  CB  MSE A  36      42.701  47.413  53.287  1.00 18.67           C  
HETATM  266  CG  MSE A  36      42.533  47.670  54.803  1.00 20.77           C  
HETATM  267 SE   MSE A  36      40.780  47.084  55.360  1.00 35.16          SE  
HETATM  268  CE  MSE A  36      40.901  47.344  57.245  1.00 27.29           C  
ATOM    269  N   ALA A  37      41.366  50.349  53.540  1.00 14.46           N  
ATOM    270  CA  ALA A  37      41.649  51.711  53.942  1.00 13.35           C  
ATOM    271  C   ALA A  37      41.257  51.852  55.406  1.00 12.45           C  
ATOM    272  O   ALA A  37      40.480  51.050  55.912  1.00 12.15           O  
ATOM    273  CB  ALA A  37      40.872  52.703  53.089  1.00 14.14           C  
ATOM    274  N   ALA A  38      41.776  52.891  56.056  1.00 11.96           N  
ATOM    275  CA  ALA A  38      41.551  53.099  57.485  1.00 11.59           C  
ATOM    276  C   ALA A  38      40.050  53.082  57.807  1.00 11.71           C  
ATOM    277  O   ALA A  38      39.629  52.476  58.800  1.00 11.75           O  
ATOM    278  CB  ALA A  38      42.191  54.420  57.946  1.00 12.14           C  
ATOM    279  N   HIS A  39      39.249  53.745  56.970  1.00 10.97           N  
ATOM    280  CA  HIS A  39      37.824  53.905  57.255  1.00 11.10           C  
ATOM    281  C   HIS A  39      36.985  52.651  56.995  1.00 11.36           C  
ATOM    282  O   HIS A  39      35.761  52.684  57.173  1.00 11.68           O  
ATOM    283  CB  HIS A  39      37.230  55.113  56.512  1.00 11.96           C  
ATOM    284  CG  HIS A  39      37.603  55.178  55.062  1.00 12.25           C  
ATOM    285  ND1 HIS A  39      38.771  55.763  54.623  1.00 13.23           N  
ATOM    286  CD2 HIS A  39      36.964  54.736  53.952  1.00 15.73           C  
ATOM    287  CE1 HIS A  39      38.840  55.672  53.306  1.00 14.68           C  
ATOM    288  NE2 HIS A  39      37.747  55.066  52.869  1.00 14.09           N  
ATOM    289  N   LEU A  40      37.626  51.554  56.586  1.00 11.19           N  
ATOM    290  CA  LEU A  40      36.946  50.262  56.439  1.00 12.15           C  
ATOM    291  C   LEU A  40      37.130  49.355  57.659  1.00 12.43           C  
ATOM    292  O   LEU A  40      36.543  48.272  57.714  1.00 12.54           O  
ATOM    293  CB  LEU A  40      37.405  49.535  55.157  1.00 13.32           C  
ATOM    294  CG  LEU A  40      37.231  50.276  53.820  1.00 14.35           C  
ATOM    295  CD1 LEU A  40      37.606  49.365  52.648  1.00 17.87           C  
ATOM    296  CD2 LEU A  40      35.807  50.820  53.652  1.00 16.04           C  
ATOM    297  N   ARG A  41      37.926  49.795  58.641  1.00 13.05           N  
ATOM    298  CA  ARG A  41      38.239  48.914  59.767  0.50 13.16           C  
ATOM    300  C   ARG A  41      37.069  48.792  60.752  1.00 13.28           C  
ATOM    301  O   ARG A  41      36.351  49.766  61.042  1.00 12.47           O  
ATOM    302  CB  ARG A  41      39.562  49.301  60.457  0.50 13.27           C  
ATOM    304  CG  ARG A  41      40.749  49.365  59.482  0.50 14.55           C  
ATOM    306  CD  ARG A  41      42.106  49.012  60.108  0.50 16.08           C  
ATOM    308  NE  ARG A  41      43.203  49.060  59.127  0.50 17.10           N  
ATOM    310  CZ  ARG A  41      43.839  47.997  58.624  0.50 18.19           C  
ATOM    312  NH1 ARG A  41      44.823  48.164  57.744  0.50 17.92           N  
ATOM    314  NH2 ARG A  41      43.507  46.765  58.991  0.50 18.01           N  
ATOM    316  N   ASN A  42      36.861  47.568  61.230  1.00 13.48           N  
ATOM    317  CA  ASN A  42      35.906  47.346  62.311  1.00 14.13           C  
ATOM    318  C   ASN A  42      36.656  47.468  63.653  1.00 15.13           C  
ATOM    319  O   ASN A  42      37.809  47.903  63.680  1.00 14.59           O  
ATOM    320  CB  ASN A  42      35.155  46.007  62.157  1.00 14.18           C  
ATOM    321  CG  ASN A  42      36.056  44.788  62.303  1.00 13.62           C  
ATOM    322  OD1 ASN A  42      37.229  44.885  62.669  1.00 13.68           O  
ATOM    323  ND2 ASN A  42      35.496  43.616  61.988  1.00 14.86           N  
ATOM    324  N   ARG A  43      36.014  47.103  64.756  1.00 16.53           N  
ATOM    325  CA  ARG A  43      36.658  47.272  66.065  1.00 18.42           C  
ATOM    326  C   ARG A  43      37.881  46.356  66.227  1.00 18.53           C  
ATOM    327  O   ARG A  43      38.797  46.666  66.995  1.00 19.16           O  
ATOM    328  CB  ARG A  43      35.653  47.072  67.202  1.00 18.67           C  
ATOM    329  CG  ARG A  43      34.614  48.209  67.295  1.00 20.21           C  
ATOM    330  CD  ARG A  43      33.847  48.200  68.621  1.00 20.95           C  
ATOM    331  NE  ARG A  43      34.722  48.288  69.790  1.00 24.98           N  
ATOM    332  CZ  ARG A  43      35.205  49.415  70.315  1.00 26.61           C  
ATOM    333  NH1 ARG A  43      34.924  50.605  69.784  1.00 25.87           N  
ATOM    334  NH2 ARG A  43      35.979  49.347  71.388  1.00 26.72           N  
ATOM    335  N   GLY A  44      37.894  45.248  65.482  1.00 18.27           N  
ATOM    336  CA  GLY A  44      39.023  44.308  65.482  1.00 17.96           C  
ATOM    337  C   GLY A  44      40.142  44.697  64.529  1.00 17.38           C  
ATOM    338  O   GLY A  44      41.152  43.988  64.405  1.00 17.51           O  
ATOM    339  N   GLY A  45      39.971  45.818  63.843  1.00 16.20           N  
ATOM    340  CA  GLY A  45      40.992  46.328  62.931  1.00 15.84           C  
ATOM    341  C   GLY A  45      41.054  45.637  61.578  1.00 16.09           C  
ATOM    342  O   GLY A  45      42.036  45.819  60.837  1.00 17.28           O  
ATOM    343  N   VAL A  46      40.020  44.862  61.240  1.00 14.38           N  
ATOM    344  CA  VAL A  46      39.932  44.193  59.930  1.00 13.59           C  
ATOM    345  C   VAL A  46      38.797  44.767  59.064  1.00 13.46           C  
ATOM    346  O   VAL A  46      37.975  45.548  59.548  1.00 11.80           O  
ATOM    347  CB  VAL A  46      39.788  42.656  60.082  1.00 13.26           C  
ATOM    348  CG1 VAL A  46      40.978  42.101  60.869  1.00 13.49           C  
ATOM    349  CG2 VAL A  46      38.461  42.277  60.758  1.00 13.23           C  
HETATM  350  N   MSE A  47      38.738  44.374  57.794  1.00 13.05           N  
HETATM  351  CA  MSE A  47      37.711  44.915  56.903  1.00 15.76           C  
HETATM  352  C   MSE A  47      36.320  44.613  57.456  1.00 13.73           C  
HETATM  353  O   MSE A  47      35.994  43.466  57.764  1.00 12.38           O  
HETATM  354  CB  MSE A  47      37.857  44.381  55.476  1.00 15.09           C  
HETATM  355  CG  MSE A  47      36.951  45.101  54.499  1.00 16.53           C  
HETATM  356 SE   MSE A  47      37.363  44.464  52.693  1.00 27.05          SE  
HETATM  357  CE  MSE A  47      39.033  45.238  52.424  1.00 20.60           C  
ATOM    358  N   HIS A  48      35.515  45.654  57.597  1.00 12.72           N  
ATOM    359  CA  HIS A  48      34.204  45.519  58.224  1.00 12.88           C  
ATOM    360  C   HIS A  48      33.282  44.657  57.356  1.00 11.88           C  
ATOM    361  O   HIS A  48      33.310  44.742  56.123  1.00 12.00           O  
ATOM    362  CB  HIS A  48      33.587  46.894  58.437  1.00 13.07           C  
ATOM    363  CG  HIS A  48      32.460  46.905  59.417  1.00 12.17           C  
ATOM    364  ND1 HIS A  48      31.208  46.398  59.128  1.00 14.33           N  
ATOM    365  CD2 HIS A  48      32.384  47.401  60.678  1.00 13.07           C  
ATOM    366  CE1 HIS A  48      30.422  46.549  60.178  1.00 14.67           C  
ATOM    367  NE2 HIS A  48      31.108  47.158  61.133  1.00 13.74           N  
ATOM    368  N   GLY A  49      32.491  43.808  58.004  1.00 12.79           N  
ATOM    369  CA  GLY A  49      31.516  42.988  57.293  1.00 12.85           C  
ATOM    370  C   GLY A  49      30.579  43.809  56.411  1.00 12.27           C  
ATOM    371  O   GLY A  49      30.144  43.336  55.362  1.00 12.34           O  
ATOM    372  N   GLY A  50      30.253  45.027  56.842  1.00 11.56           N  
ATOM    373  CA  GLY A  50      29.409  45.893  56.033  1.00 11.73           C  
ATOM    374  C   GLY A  50      30.090  46.307  54.735  1.00 11.93           C  
ATOM    375  O   GLY A  50      29.436  46.443  53.695  1.00 12.25           O  
ATOM    376  N   ALA A  51      31.405  46.545  54.794  1.00 11.02           N  
ATOM    377  CA  ALA A  51      32.154  46.932  53.586  1.00 11.70           C  
ATOM    378  C   ALA A  51      32.230  45.768  52.611  1.00 11.77           C  
ATOM    379  O   ALA A  51      32.050  45.937  51.399  1.00 11.71           O  
ATOM    380  CB  ALA A  51      33.528  47.429  53.958  1.00 11.24           C  
ATOM    381  N   LEU A  52      32.462  44.579  53.149  1.00 11.31           N  
ATOM    382  CA  LEU A  52      32.449  43.370  52.319  1.00 12.12           C  
ATOM    383  C   LEU A  52      31.078  43.136  51.676  1.00 11.76           C  
ATOM    384  O   LEU A  52      30.999  42.804  50.483  1.00 11.50           O  
ATOM    385  CB  LEU A  52      32.863  42.159  53.137  1.00 12.02           C  
ATOM    386  CG  LEU A  52      34.362  42.099  53.450  1.00 13.05           C  
ATOM    387  CD1 LEU A  52      34.703  41.097  54.582  1.00 13.67           C  
ATOM    388  CD2 LEU A  52      35.193  41.781  52.199  1.00 14.22           C  
ATOM    389  N   PHE A  53      30.006  43.314  52.442  1.00 12.10           N  
ATOM    390  CA  PHE A  53      28.684  43.161  51.865  1.00 11.81           C  
ATOM    391  C   PHE A  53      28.431  44.218  50.784  1.00 11.74           C  
ATOM    392  O   PHE A  53      27.855  43.907  49.746  1.00 12.69           O  
ATOM    393  CB  PHE A  53      27.605  43.227  52.938  1.00 11.50           C  
ATOM    394  CG  PHE A  53      26.224  43.131  52.383  1.00 12.23           C  
ATOM    395  CD1 PHE A  53      25.583  41.892  52.302  1.00 14.46           C  
ATOM    396  CD2 PHE A  53      25.581  44.275  51.899  1.00 13.62           C  
ATOM    397  CE1 PHE A  53      24.295  41.790  51.766  1.00 16.88           C  
ATOM    398  CE2 PHE A  53      24.296  44.198  51.357  1.00 14.94           C  
ATOM    399  CZ  PHE A  53      23.644  42.952  51.295  1.00 14.84           C  
ATOM    400  N   SER A  54      28.844  45.461  51.032  1.00 11.63           N  
ATOM    401  CA  SER A  54      28.644  46.552  50.074  1.00 11.37           C  
ATOM    402  C   SER A  54      29.343  46.210  48.761  1.00 11.72           C  
ATOM    403  O   SER A  54      28.772  46.345  47.692  1.00 11.57           O  
ATOM    404  CB  SER A  54      29.170  47.866  50.643  1.00 11.69           C  
ATOM    405  OG  SER A  54      28.417  48.239  51.792  1.00 11.59           O  
ATOM    406  N   LEU A  55      30.574  45.726  48.863  1.00 11.15           N  
ATOM    407  CA  LEU A  55      31.294  45.238  47.706  1.00 11.80           C  
ATOM    408  C   LEU A  55      30.478  44.176  46.965  1.00 12.57           C  
ATOM    409  O   LEU A  55      30.273  44.280  45.734  1.00 12.12           O  
ATOM    410  CB  LEU A  55      32.631  44.669  48.156  1.00 11.99           C  
ATOM    411  CG  LEU A  55      33.384  43.824  47.129  1.00 11.68           C  
ATOM    412  CD1 LEU A  55      33.792  44.692  45.925  1.00 11.99           C  
ATOM    413  CD2 LEU A  55      34.598  43.204  47.817  1.00 11.24           C  
HETATM  414  N   MSE A  56      29.980  43.181  47.703  1.00 13.75           N  
HETATM  415  CA  MSE A  56      29.211  42.119  47.077  1.00 15.44           C  
HETATM  416  C   MSE A  56      27.939  42.636  46.386  1.00 14.54           C  
HETATM  417  O   MSE A  56      27.675  42.295  45.240  1.00 13.75           O  
HETATM  418  CB  MSE A  56      28.853  41.030  48.097  1.00 15.31           C  
HETATM  419  CG  MSE A  56      28.126  39.869  47.449  1.00 16.73           C  
HETATM  420 SE   MSE A  56      27.947  38.455  48.747  1.00 25.80          SE  
HETATM  421  CE  MSE A  56      29.850  38.019  48.889  1.00 18.24           C  
ATOM    422  N   ASP A  57      27.169  43.466  47.082  1.00 13.60           N  
ATOM    423  CA  ASP A  57      25.915  43.991  46.517  1.00 14.11           C  
ATOM    424  C   ASP A  57      26.181  44.769  45.213  1.00 13.88           C  
ATOM    425  O   ASP A  57      25.467  44.609  44.202  1.00 14.15           O  
ATOM    426  CB  ASP A  57      25.202  44.868  47.551  1.00 14.52           C  
ATOM    427  CG  ASP A  57      23.912  45.458  47.011  1.00 19.49           C  
ATOM    428  OD1 ASP A  57      22.983  44.692  46.673  1.00 22.47           O  
ATOM    429  OD2 ASP A  57      23.853  46.683  46.867  1.00 26.56           O  
ATOM    430  N   VAL A  58      27.222  45.599  45.219  1.00 12.70           N  
ATOM    431  CA  VAL A  58      27.569  46.367  44.027  1.00 12.43           C  
ATOM    432  C   VAL A  58      27.978  45.466  42.860  1.00 11.85           C  
ATOM    433  O   VAL A  58      27.535  45.676  41.732  1.00 12.17           O  
ATOM    434  CB  VAL A  58      28.626  47.438  44.335  1.00 12.51           C  
ATOM    435  CG1 VAL A  58      29.204  48.038  43.051  1.00 14.55           C  
ATOM    436  CG2 VAL A  58      27.989  48.552  45.240  1.00 13.01           C  
ATOM    437  N   THR A  59      28.831  44.483  43.136  1.00 10.99           N  
ATOM    438  CA  THR A  59      29.274  43.542  42.100  1.00 10.75           C  
ATOM    439  C   THR A  59      28.088  42.754  41.522  1.00 10.72           C  
ATOM    440  O   THR A  59      27.989  42.566  40.315  1.00 10.18           O  
ATOM    441  CB  THR A  59      30.340  42.559  42.642  1.00 11.09           C  
ATOM    442  OG1 THR A  59      31.348  43.299  43.344  1.00 10.76           O  
ATOM    443  CG2 THR A  59      31.007  41.815  41.474  1.00 10.71           C  
HETATM  444  N   MSE A  60      27.200  42.285  42.398  1.00 11.37           N  
HETATM  445  CA  MSE A  60      25.989  41.591  41.951  1.00 13.22           C  
HETATM  446  C   MSE A  60      25.111  42.486  41.070  1.00 11.64           C  
HETATM  447  O   MSE A  60      24.613  42.032  40.057  1.00 11.90           O  
HETATM  448  CB  MSE A  60      25.199  41.068  43.147  1.00 11.62           C  
HETATM  449  CG  MSE A  60      25.867  39.917  43.861  1.00 11.03           C  
HETATM  450 SE   MSE A  60      24.684  39.520  45.425  1.00 23.81          SE  
HETATM  451  CE  MSE A  60      25.328  37.721  45.794  1.00 15.59           C  
ATOM    452  N   GLY A  61      24.944  43.759  41.442  1.00 11.72           N  
ATOM    453  CA  GLY A  61      24.170  44.698  40.619  1.00 11.59           C  
ATOM    454  C   GLY A  61      24.753  44.862  39.218  1.00 11.89           C  
ATOM    455  O   GLY A  61      24.017  44.916  38.226  1.00 12.28           O  
ATOM    456  N   LEU A  62      26.081  44.950  39.152  1.00 11.25           N  
ATOM    457  CA  LEU A  62      26.793  45.096  37.886  1.00 11.09           C  
ATOM    458  C   LEU A  62      26.686  43.831  37.031  1.00 11.39           C  
ATOM    459  O   LEU A  62      26.542  43.906  35.813  1.00 11.04           O  
ATOM    460  CB  LEU A  62      28.252  45.472  38.158  1.00 11.67           C  
ATOM    461  CG  LEU A  62      28.491  46.927  38.600  1.00 12.12           C  
ATOM    462  CD1 LEU A  62      29.998  47.135  38.871  1.00 13.22           C  
ATOM    463  CD2 LEU A  62      27.980  47.921  37.551  1.00 13.42           C  
ATOM    464  N   ALA A  63      26.748  42.660  37.673  1.00 11.37           N  
ATOM    465  CA  ALA A  63      26.514  41.399  36.969  1.00 11.55           C  
ATOM    466  C   ALA A  63      25.108  41.379  36.374  1.00 12.56           C  
ATOM    467  O   ALA A  63      24.934  41.000  35.223  1.00 12.17           O  
ATOM    468  CB  ALA A  63      26.728  40.194  37.902  1.00 11.12           C  
ATOM    469  N   CYS A  64      24.113  41.827  37.144  1.00 12.27           N  
ATOM    470  CA  CYS A  64      22.742  41.919  36.627  1.00 14.13           C  
ATOM    471  C   CYS A  64      22.667  42.853  35.436  1.00 14.68           C  
ATOM    472  O   CYS A  64      22.088  42.509  34.418  1.00 14.58           O  
ATOM    473  CB  CYS A  64      21.786  42.365  37.712  1.00 14.13           C  
ATOM    474  SG  CYS A  64      21.520  41.035  38.853  1.00 18.22           S  
ATOM    475  N   SER A  65      23.288  44.021  35.559  1.00 15.07           N  
ATOM    476  CA  SER A  65      23.310  44.974  34.462  1.00 15.96           C  
ATOM    477  C   SER A  65      23.982  44.405  33.216  1.00 16.42           C  
ATOM    478  O   SER A  65      23.583  44.721  32.089  1.00 17.10           O  
ATOM    479  CB  SER A  65      23.993  46.259  34.908  1.00 15.45           C  
ATOM    480  OG  SER A  65      23.173  46.926  35.854  1.00 17.02           O  
ATOM    481  N   SER A  66      24.980  43.544  33.396  1.00 17.12           N  
ATOM    482  CA  SER A  66      25.656  42.971  32.227  1.00 18.10           C  
ATOM    483  C   SER A  66      24.781  41.920  31.547  1.00 18.58           C  
ATOM    484  O   SER A  66      24.996  41.592  30.380  1.00 19.51           O  
ATOM    485  CB  SER A  66      27.006  42.384  32.608  1.00 18.29           C  
ATOM    486  OG  SER A  66      26.845  41.178  33.319  1.00 19.89           O  
ATOM    487  N   SER A  67      23.790  41.414  32.277  1.00 18.99           N  
ATOM    488  CA  SER A  67      22.835  40.438  31.754  1.00 19.45           C  
ATOM    489  C   SER A  67      21.669  41.117  31.039  1.00 19.79           C  
ATOM    490  O   SER A  67      21.363  40.782  29.883  1.00 19.69           O  
ATOM    491  CB  SER A  67      22.303  39.571  32.902  1.00 19.49           C  
ATOM    492  OG  SER A  67      21.284  38.705  32.447  1.00 21.34           O  
ATOM    493  N   HIS A  68      21.005  42.056  31.717  1.00 19.80           N  
ATOM    494  CA  HIS A  68      19.845  42.741  31.113  1.00 20.55           C  
ATOM    495  C   HIS A  68      20.181  44.008  30.308  1.00 21.10           C  
ATOM    496  O   HIS A  68      19.312  44.566  29.615  1.00 21.52           O  
ATOM    497  CB  HIS A  68      18.715  43.002  32.129  1.00 20.30           C  
ATOM    498  CG  HIS A  68      19.126  43.781  33.342  1.00 19.99           C  
ATOM    499  ND1 HIS A  68      19.625  45.067  33.280  1.00 19.29           N  
ATOM    500  CD2 HIS A  68      19.050  43.472  34.659  1.00 17.82           C  
ATOM    501  CE1 HIS A  68      19.873  45.500  34.505  1.00 20.24           C  
ATOM    502  NE2 HIS A  68      19.535  44.550  35.361  1.00 19.66           N  
ATOM    503  N   GLY A  69      21.439  44.442  30.381  1.00 21.49           N  
ATOM    504  CA  GLY A  69      21.879  45.666  29.711  1.00 21.58           C  
ATOM    505  C   GLY A  69      21.742  46.867  30.625  1.00 22.20           C  
ATOM    506  O   GLY A  69      20.863  46.906  31.498  1.00 21.89           O  
ATOM    507  N   PHE A  70      22.605  47.860  30.414  1.00 22.68           N  
ATOM    508  CA  PHE A  70      22.614  49.069  31.247  1.00 23.14           C  
ATOM    509  C   PHE A  70      21.477  50.022  30.896  1.00 23.70           C  
ATOM    510  O   PHE A  70      21.252  51.021  31.589  1.00 24.13           O  
ATOM    511  CB  PHE A  70      23.979  49.765  31.193  1.00 23.06           C  
ATOM    512  CG  PHE A  70      25.017  49.097  32.040  1.00 22.80           C  
ATOM    513  CD1 PHE A  70      25.274  49.548  33.339  1.00 22.69           C  
ATOM    514  CD2 PHE A  70      25.713  47.989  31.561  1.00 23.20           C  
ATOM    515  CE1 PHE A  70      26.231  48.916  34.146  1.00 23.65           C  
ATOM    516  CE2 PHE A  70      26.665  47.344  32.357  1.00 23.58           C  
ATOM    517  CZ  PHE A  70      26.926  47.807  33.658  1.00 22.86           C  
ATOM    518  N   ASP A  71      20.752  49.690  29.829  1.00 23.93           N  
ATOM    519  CA  ASP A  71      19.552  50.422  29.429  1.00 24.67           C  
ATOM    520  C   ASP A  71      18.323  49.931  30.200  1.00 24.49           C  
ATOM    521  O   ASP A  71      17.217  50.447  30.015  1.00 24.82           O  
ATOM    522  CB  ASP A  71      19.324  50.268  27.922  1.00 25.09           C  
ATOM    523  CG  ASP A  71      19.019  48.826  27.515  1.00 27.51           C  
ATOM    524  OD1 ASP A  71      19.611  47.881  28.101  1.00 30.13           O  
ATOM    525  OD2 ASP A  71      18.187  48.636  26.597  1.00 31.17           O  
ATOM    526  N   ARG A  72      18.518  48.895  31.014  1.00 24.09           N  
ATOM    527  CA  ARG A  72      17.472  48.386  31.895  0.50 23.88           C  
ATOM    529  C   ARG A  72      17.969  48.399  33.335  1.00 23.48           C  
ATOM    530  O   ARG A  72      19.175  48.508  33.579  1.00 23.26           O  
ATOM    531  CB  ARG A  72      17.054  46.973  31.490  0.50 24.12           C  
ATOM    533  CG  ARG A  72      16.047  46.937  30.358  0.50 24.98           C  
ATOM    535  CD  ARG A  72      15.550  45.523  30.115  0.50 27.12           C  
ATOM    537  NE  ARG A  72      14.246  45.524  29.459  0.50 27.77           N  
ATOM    539  CZ  ARG A  72      14.058  45.609  28.145  0.50 27.90           C  
ATOM    541  NH1 ARG A  72      15.095  45.695  27.318  0.50 27.52           N  
ATOM    543  NH2 ARG A  72      12.825  45.609  27.658  0.50 28.69           N  
ATOM    545  N   GLN A  73      17.039  48.299  34.284  1.00 22.79           N  
ATOM    546  CA  GLN A  73      17.394  48.379  35.697  1.00 22.57           C  
ATOM    547  C   GLN A  73      16.936  47.147  36.466  1.00 21.44           C  
ATOM    548  O   GLN A  73      15.958  46.499  36.095  1.00 20.42           O  
ATOM    549  CB  GLN A  73      16.777  49.633  36.325  1.00 23.39           C  
ATOM    550  CG  GLN A  73      17.094  50.940  35.592  1.00 26.49           C  
ATOM    551  CD  GLN A  73      18.578  51.292  35.636  1.00 30.98           C  
ATOM    552  OE1 GLN A  73      19.157  51.731  34.635  1.00 34.08           O  
ATOM    553  NE2 GLN A  73      19.195  51.106  36.799  1.00 33.03           N  
ATOM    554  N   SER A  74      17.673  46.835  37.532  1.00 20.25           N  
ATOM    555  CA  SER A  74      17.251  45.848  38.524  1.00 19.57           C  
ATOM    556  C   SER A  74      17.625  46.392  39.897  1.00 19.25           C  
ATOM    557  O   SER A  74      18.513  47.249  40.011  1.00 19.75           O  
ATOM    558  CB  SER A  74      17.914  44.486  38.280  1.00 19.25           C  
ATOM    559  OG  SER A  74      19.324  44.625  38.134  1.00 19.21           O  
ATOM    560  N   VAL A  75      16.942  45.907  40.934  1.00 18.06           N  
ATOM    561  CA  VAL A  75      17.234  46.315  42.309  1.00 17.33           C  
ATOM    562  C   VAL A  75      17.282  45.076  43.199  1.00 16.49           C  
ATOM    563  O   VAL A  75      16.590  44.086  42.926  1.00 15.23           O  
ATOM    564  CB  VAL A  75      16.181  47.316  42.866  1.00 17.29           C  
ATOM    565  CG1 VAL A  75      16.193  48.616  42.043  1.00 18.82           C  
ATOM    566  CG2 VAL A  75      14.781  46.703  42.875  1.00 17.15           C  
ATOM    567  N   THR A  76      18.108  45.133  44.237  1.00 16.39           N  
ATOM    568  CA  THR A  76      18.228  44.016  45.164  1.00 15.91           C  
ATOM    569  C   THR A  76      16.922  43.795  45.937  1.00 15.10           C  
ATOM    570  O   THR A  76      16.397  44.739  46.572  1.00 14.92           O  
ATOM    571  CB  THR A  76      19.362  44.259  46.177  1.00 16.78           C  
ATOM    572  OG1 THR A  76      20.508  44.816  45.508  1.00 20.19           O  
ATOM    573  CG2 THR A  76      19.743  42.958  46.878  1.00 18.18           C  
ATOM    574  N   LEU A  77      16.369  42.582  45.871  1.00 13.00           N  
ATOM    575  CA  LEU A  77      15.277  42.208  46.767  1.00 12.70           C  
ATOM    576  C   LEU A  77      15.838  41.724  48.109  1.00 11.62           C  
ATOM    577  O   LEU A  77      15.327  42.084  49.173  1.00 11.87           O  
ATOM    578  CB  LEU A  77      14.394  41.095  46.185  1.00 13.17           C  
ATOM    579  CG  LEU A  77      13.396  41.410  45.075  1.00 15.39           C  
ATOM    580  CD1 LEU A  77      12.728  40.116  44.670  1.00 17.48           C  
ATOM    581  CD2 LEU A  77      12.365  42.443  45.561  1.00 15.47           C  
ATOM    582  N   GLU A  78      16.856  40.867  48.048  1.00 10.79           N  
ATOM    583  CA  GLU A  78      17.428  40.280  49.266  1.00 10.53           C  
ATOM    584  C   GLU A  78      18.802  39.727  48.955  1.00 10.86           C  
ATOM    585  O   GLU A  78      19.113  39.472  47.804  1.00 10.81           O  
ATOM    586  CB  GLU A  78      16.525  39.152  49.819  1.00 11.23           C  
ATOM    587  CG  GLU A  78      16.349  37.930  48.891  1.00 11.02           C  
ATOM    588  CD  GLU A  78      17.493  36.910  49.019  1.00 13.41           C  
ATOM    589  OE1 GLU A  78      18.038  36.745  50.131  1.00 12.10           O  
ATOM    590  OE2 GLU A  78      17.859  36.276  47.992  1.00 12.89           O  
ATOM    591  N   CYS A  79      19.603  39.520  49.987  1.00 12.28           N  
ATOM    592  CA  CYS A  79      20.927  38.911  49.818  1.00 11.61           C  
ATOM    593  C   CYS A  79      21.327  38.241  51.111  1.00 11.97           C  
ATOM    594  O   CYS A  79      20.918  38.681  52.193  1.00 12.38           O  
ATOM    595  CB  CYS A  79      21.958  39.983  49.451  1.00 12.32           C  
ATOM    596  SG  CYS A  79      23.521  39.281  48.901  1.00 17.21           S  
ATOM    597  N   LYS A  80      22.157  37.207  50.998  1.00 10.59           N  
ATOM    598  CA  LYS A  80      22.650  36.452  52.144  1.00 11.27           C  
ATOM    599  C   LYS A  80      24.135  36.273  51.938  1.00 11.05           C  
ATOM    600  O   LYS A  80      24.550  35.894  50.855  1.00 11.63           O  
ATOM    601  CB  LYS A  80      21.968  35.084  52.192  1.00 11.87           C  
ATOM    602  CG  LYS A  80      22.400  34.168  53.360  1.00 11.50           C  
ATOM    603  CD  LYS A  80      23.412  33.108  52.923  1.00 12.83           C  
ATOM    604  CE  LYS A  80      23.390  31.914  53.891  1.00 13.36           C  
ATOM    605  NZ  LYS A  80      24.079  32.208  55.154  1.00 13.76           N  
ATOM    606  N   ILE A  81      24.916  36.526  52.984  1.00 10.58           N  
ATOM    607  CA  ILE A  81      26.380  36.460  52.896  1.00 10.24           C  
ATOM    608  C   ILE A  81      26.930  35.605  54.032  1.00 10.52           C  
ATOM    609  O   ILE A  81      26.388  35.635  55.140  1.00 11.06           O  
ATOM    610  CB  ILE A  81      26.997  37.915  52.973  1.00 10.49           C  
ATOM    611  CG1 ILE A  81      28.513  37.894  52.739  1.00 11.07           C  
ATOM    612  CG2 ILE A  81      26.669  38.629  54.325  1.00 10.82           C  
ATOM    613  CD1 ILE A  81      29.091  39.274  52.466  1.00 12.26           C  
ATOM    614  N   ASN A  82      27.996  34.844  53.757  1.00  9.54           N  
ATOM    615  CA  ASN A  82      28.792  34.184  54.799  1.00 10.44           C  
ATOM    616  C   ASN A  82      30.159  34.813  54.823  1.00 11.34           C  
ATOM    617  O   ASN A  82      30.757  35.032  53.770  1.00 11.61           O  
ATOM    618  CB  ASN A  82      28.980  32.698  54.511  1.00 10.16           C  
ATOM    619  CG  ASN A  82      27.915  31.857  55.139  1.00 10.99           C  
ATOM    620  OD1 ASN A  82      28.105  31.281  56.234  1.00 14.87           O  
ATOM    621  ND2 ASN A  82      26.785  31.796  54.485  1.00  8.80           N  
ATOM    622  N   TYR A  83      30.651  35.071  56.025  1.00 11.55           N  
ATOM    623  CA  TYR A  83      32.001  35.606  56.216  1.00 11.82           C  
ATOM    624  C   TYR A  83      32.913  34.469  56.603  1.00 12.04           C  
ATOM    625  O   TYR A  83      32.658  33.755  57.586  1.00 11.78           O  
ATOM    626  CB  TYR A  83      31.982  36.655  57.326  1.00 12.20           C  
ATOM    627  CG  TYR A  83      31.107  37.827  56.971  1.00 13.07           C  
ATOM    628  CD1 TYR A  83      31.556  38.788  56.063  1.00 12.10           C  
ATOM    629  CD2 TYR A  83      29.835  37.966  57.525  1.00 12.93           C  
ATOM    630  CE1 TYR A  83      30.749  39.878  55.708  1.00 13.90           C  
ATOM    631  CE2 TYR A  83      29.014  39.062  57.186  1.00 12.83           C  
ATOM    632  CZ  TYR A  83      29.484  40.002  56.271  1.00 13.24           C  
ATOM    633  OH  TYR A  83      28.694  41.082  55.943  1.00 16.01           O  
ATOM    634  N   ILE A  84      33.983  34.301  55.848  1.00 12.70           N  
ATOM    635  CA  ILE A  84      34.805  33.104  56.038  1.00 14.08           C  
ATOM    636  C   ILE A  84      36.095  33.422  56.773  1.00 14.50           C  
ATOM    637  O   ILE A  84      36.459  32.730  57.737  1.00 14.72           O  
ATOM    638  CB  ILE A  84      35.017  32.369  54.695  1.00 14.38           C  
ATOM    639  CG1 ILE A  84      33.687  31.683  54.322  1.00 17.94           C  
ATOM    640  CG2 ILE A  84      36.176  31.357  54.797  1.00 14.83           C  
ATOM    641  CD1 ILE A  84      33.516  31.387  52.869  1.00 21.67           C  
ATOM    642  N   ARG A  85      36.807  34.449  56.329  1.00 14.56           N  
ATOM    643  CA  ARG A  85      37.937  34.917  57.138  1.00 15.79           C  
ATOM    644  C   ARG A  85      38.176  36.406  57.001  1.00 15.28           C  
ATOM    645  O   ARG A  85      37.679  37.021  56.059  1.00 15.64           O  
ATOM    646  CB  ARG A  85      39.203  34.172  56.766  1.00 16.28           C  
ATOM    647  CG  ARG A  85      39.633  34.340  55.307  1.00 16.70           C  
ATOM    648  CD  ARG A  85      40.910  33.532  55.105  1.00 17.87           C  
ATOM    649  NE  ARG A  85      42.033  34.170  55.793  1.00 18.79           N  
ATOM    650  CZ  ARG A  85      43.316  33.856  55.631  1.00 16.73           C  
ATOM    651  NH1 ARG A  85      43.686  32.902  54.781  1.00 15.40           N  
ATOM    652  NH2 ARG A  85      44.236  34.542  56.296  1.00 14.87           N  
ATOM    653  N   ALA A  86      38.946  36.951  57.945  1.00 14.67           N  
ATOM    654  CA  ALA A  86      39.154  38.392  58.056  1.00 14.55           C  
ATOM    655  C   ALA A  86      40.218  38.871  57.082  1.00 14.76           C  
ATOM    656  O   ALA A  86      41.184  38.148  56.786  1.00 14.71           O  
ATOM    657  CB  ALA A  86      39.572  38.759  59.482  1.00 14.53           C  
ATOM    658  N   VAL A  87      40.053  40.106  56.625  1.00 14.96           N  
ATOM    659  CA  VAL A  87      41.025  40.776  55.763  1.00 16.05           C  
ATOM    660  C   VAL A  87      41.650  41.954  56.530  1.00 16.35           C  
ATOM    661  O   VAL A  87      40.939  42.819  57.010  1.00 16.10           O  
ATOM    662  CB  VAL A  87      40.344  41.312  54.467  1.00 16.46           C  
ATOM    663  CG1 VAL A  87      41.347  42.099  53.598  1.00 17.60           C  
ATOM    664  CG2 VAL A  87      39.732  40.179  53.680  1.00 19.00           C  
ATOM    665  N   ALA A  88      42.976  41.970  56.654  1.00 17.38           N  
ATOM    666  CA  ALA A  88      43.657  43.011  57.444  1.00 18.67           C  
ATOM    667  C   ALA A  88      44.357  44.060  56.580  1.00 19.11           C  
ATOM    668  O   ALA A  88      44.647  45.171  57.046  1.00 19.26           O  
ATOM    669  CB  ALA A  88      44.649  42.383  58.434  1.00 19.29           C  
ATOM    670  N   ASP A  89      44.636  43.715  55.325  1.00 18.64           N  
ATOM    671  CA  ASP A  89      45.327  44.649  54.438  1.00 19.25           C  
ATOM    672  C   ASP A  89      45.227  44.232  52.982  1.00 17.90           C  
ATOM    673  O   ASP A  89      44.670  43.170  52.671  1.00 18.23           O  
ATOM    674  CB  ASP A  89      46.794  44.798  54.850  1.00 20.71           C  
ATOM    675  CG  ASP A  89      47.522  43.488  54.884  1.00 24.79           C  
ATOM    676  OD1 ASP A  89      47.330  42.639  53.980  1.00 30.15           O  
ATOM    677  OD2 ASP A  89      48.311  43.306  55.829  1.00 32.57           O  
ATOM    678  N   GLY A  90      45.787  45.058  52.104  1.00 16.84           N  
ATOM    679  CA  GLY A  90      45.820  44.766  50.676  1.00 16.24           C  
ATOM    680  C   GLY A  90      44.452  45.018  50.072  1.00 16.25           C  
ATOM    681  O   GLY A  90      43.724  45.905  50.527  1.00 17.61           O  
ATOM    682  N   GLU A  91      44.087  44.249  49.059  1.00 14.01           N  
ATOM    683  CA  GLU A  91      42.776  44.429  48.455  1.00 12.75           C  
ATOM    684  C   GLU A  91      42.044  43.109  48.283  1.00 12.67           C  
ATOM    685  O   GLU A  91      42.655  42.033  48.269  1.00 11.84           O  
ATOM    686  CB  GLU A  91      42.884  45.136  47.102  1.00 13.47           C  
ATOM    687  CG  GLU A  91      43.469  44.272  45.995  1.00 13.38           C  
ATOM    688  CD  GLU A  91      43.678  45.060  44.708  1.00 12.86           C  
ATOM    689  OE1 GLU A  91      44.625  45.887  44.687  1.00 12.06           O  
ATOM    690  OE2 GLU A  91      42.908  44.835  43.733  1.00 14.10           O  
ATOM    691  N   VAL A  92      40.734  43.217  48.113  1.00 12.37           N  
ATOM    692  CA  VAL A  92      39.925  42.046  47.790  1.00 11.67           C  
ATOM    693  C   VAL A  92      39.258  42.224  46.434  1.00 12.17           C  
ATOM    694  O   VAL A  92      39.054  43.359  45.969  1.00 12.23           O  
ATOM    695  CB  VAL A  92      38.868  41.732  48.890  1.00 12.09           C  
ATOM    696  CG1 VAL A  92      39.555  41.353  50.220  1.00 12.11           C  
ATOM    697  CG2 VAL A  92      37.904  42.920  49.089  1.00 12.08           C  
ATOM    698  N   ARG A  93      38.928  41.095  45.809  1.00 11.89           N  
ATOM    699  CA  ARG A  93      38.206  41.076  44.546  1.00 11.79           C  
ATOM    700  C   ARG A  93      36.915  40.332  44.760  1.00 12.09           C  
ATOM    701  O   ARG A  93      36.911  39.287  45.389  1.00 11.29           O  
ATOM    702  CB  ARG A  93      39.037  40.366  43.462  1.00 12.02           C  
ATOM    703  CG  ARG A  93      40.382  41.020  43.164  1.00 14.80           C  
ATOM    704  CD  ARG A  93      40.152  42.343  42.487  1.00 14.56           C  
ATOM    705  NE  ARG A  93      41.368  43.090  42.173  1.00 13.90           N  
ATOM    706  CZ  ARG A  93      41.841  43.259  40.947  1.00 13.80           C  
ATOM    707  NH1 ARG A  93      41.232  42.688  39.904  1.00 14.40           N  
ATOM    708  NH2 ARG A  93      42.922  44.009  40.765  1.00 13.94           N  
ATOM    709  N   CYS A  94      35.830  40.896  44.247  1.00 11.03           N  
ATOM    710  CA  CYS A  94      34.547  40.206  44.222  1.00 11.07           C  
ATOM    711  C   CYS A  94      34.197  39.876  42.783  1.00 11.33           C  
ATOM    712  O   CYS A  94      34.277  40.743  41.899  1.00 10.79           O  
ATOM    713  CB  CYS A  94      33.470  41.071  44.846  1.00 11.23           C  
ATOM    714  SG  CYS A  94      31.832  40.256  44.829  1.00 13.66           S  
ATOM    715  N   VAL A  95      33.838  38.616  42.544  1.00 11.56           N  
ATOM    716  CA  VAL A  95      33.294  38.206  41.249  1.00 11.50           C  
ATOM    717  C   VAL A  95      31.865  37.716  41.476  1.00 11.99           C  
ATOM    718  O   VAL A  95      31.631  36.849  42.333  1.00 12.05           O  
ATOM    719  CB  VAL A  95      34.145  37.096  40.593  1.00 11.61           C  
ATOM    720  CG1 VAL A  95      33.505  36.642  39.274  1.00 13.16           C  
ATOM    721  CG2 VAL A  95      35.576  37.601  40.375  1.00 12.21           C  
ATOM    722  N   ALA A  96      30.921  38.286  40.726  1.00 11.58           N  
ATOM    723  CA  ALA A  96      29.523  37.905  40.826  1.00 12.26           C  
ATOM    724  C   ALA A  96      29.075  37.336  39.484  1.00 12.89           C  
ATOM    725  O   ALA A  96      29.551  37.767  38.425  1.00 13.05           O  
ATOM    726  CB  ALA A  96      28.654  39.100  41.215  1.00 11.93           C  
ATOM    727  N   ARG A  97      28.163  36.366  39.547  1.00 13.06           N  
ATOM    728  CA  ARG A  97      27.703  35.649  38.374  1.00 14.70           C  
ATOM    729  C   ARG A  97      26.198  35.449  38.457  1.00 13.08           C  
ATOM    730  O   ARG A  97      25.699  34.896  39.443  1.00 12.74           O  
ATOM    731  CB  ARG A  97      28.404  34.289  38.325  1.00 14.83           C  
ATOM    732  CG  ARG A  97      28.160  33.496  37.062  1.00 19.35           C  
ATOM    733  CD  ARG A  97      29.039  32.222  37.066  1.00 19.76           C  
ATOM    734  NE  ARG A  97      30.457  32.574  37.214  1.00 28.75           N  
ATOM    735  CZ  ARG A  97      31.284  32.891  36.211  1.00 31.47           C  
ATOM    736  NH1 ARG A  97      30.863  32.889  34.945  1.00 32.20           N  
ATOM    737  NH2 ARG A  97      32.550  33.210  36.477  1.00 32.83           N  
ATOM    738  N   VAL A  98      25.483  35.897  37.432  1.00 11.63           N  
ATOM    739  CA  VAL A  98      24.048  35.635  37.325  1.00 11.27           C  
ATOM    740  C   VAL A  98      23.825  34.132  37.078  1.00 11.36           C  
ATOM    741  O   VAL A  98      24.362  33.553  36.107  1.00 10.41           O  
ATOM    742  CB  VAL A  98      23.423  36.447  36.168  1.00 11.81           C  
ATOM    743  CG1 VAL A  98      21.953  36.128  36.029  1.00 11.26           C  
ATOM    744  CG2 VAL A  98      23.638  37.973  36.394  1.00 11.84           C  
ATOM    745  N   LEU A  99      23.044  33.509  37.956  1.00 10.57           N  
ATOM    746  CA  LEU A  99      22.729  32.071  37.843  1.00 11.23           C  
ATOM    747  C   LEU A  99      21.428  31.845  37.086  1.00 11.47           C  
ATOM    748  O   LEU A  99      21.219  30.781  36.488  1.00 10.62           O  
ATOM    749  CB  LEU A  99      22.573  31.452  39.230  1.00 11.37           C  
ATOM    750  CG  LEU A  99      23.835  31.480  40.096  1.00 11.86           C  
ATOM    751  CD1 LEU A  99      23.601  30.861  41.466  1.00 14.04           C  
ATOM    752  CD2 LEU A  99      24.981  30.798  39.392  1.00 15.29           C  
ATOM    753  N   HIS A 100      20.534  32.824  37.158  0.50 11.58           N  
ATOM    755  CA  HIS A 100      19.290  32.781  36.406  0.50 12.31           C  
ATOM    757  C   HIS A 100      18.784  34.186  36.139  0.50 12.85           C  
ATOM    759  O   HIS A 100      18.770  35.033  37.027  0.50 12.54           O  
ATOM    761  CB  HIS A 100      18.226  31.972  37.140  0.50 12.67           C  
ATOM    763  CG  HIS A 100      17.003  31.710  36.321  0.50 12.75           C  
ATOM    765  ND1 HIS A 100      16.937  30.707  35.378  0.50 14.24           N  
ATOM    767  CD2 HIS A 100      15.795  32.324  36.303  0.50 13.85           C  
ATOM    769  CE1 HIS A 100      15.740  30.711  34.816  0.50 14.33           C  
ATOM    771  NE2 HIS A 100      15.030  31.684  35.356  0.50 15.06           N  
ATOM    773  N   ALA A 101      18.383  34.427  34.900  1.00 13.38           N  
ATOM    774  CA  ALA A 101      17.791  35.709  34.525  1.00 14.89           C  
ATOM    775  C   ALA A 101      16.391  35.451  33.997  1.00 16.40           C  
ATOM    776  O   ALA A 101      16.225  35.039  32.850  1.00 16.91           O  
ATOM    777  CB  ALA A 101      18.648  36.419  33.497  1.00 14.69           C  
ATOM    778  N   GLY A 102      15.389  35.638  34.854  1.00 17.21           N  
ATOM    779  CA  GLY A 102      13.995  35.470  34.467  1.00 18.86           C  
ATOM    780  C   GLY A 102      13.405  36.803  34.044  1.00 19.76           C  
ATOM    781  O   GLY A 102      14.080  37.832  34.132  1.00 19.87           O  
ATOM    782  N   ARG A 103      12.150  36.796  33.596  1.00 20.68           N  
ATOM    783  CA  ARG A 103      11.490  38.043  33.195  1.00 21.99           C  
ATOM    784  C   ARG A 103      11.261  38.979  34.389  1.00 21.33           C  
ATOM    785  O   ARG A 103      11.266  40.200  34.231  1.00 21.71           O  
ATOM    786  CB  ARG A 103      10.189  37.787  32.394  1.00 22.53           C  
ATOM    787  CG  ARG A 103       9.048  37.106  33.163  1.00 24.34           C  
ATOM    788  CD  ARG A 103       8.007  36.452  32.230  1.00 24.39           C  
ATOM    789  NE  ARG A 103       7.124  37.398  31.538  1.00 29.69           N  
ATOM    790  CZ  ARG A 103       5.937  37.075  31.009  1.00 31.40           C  
ATOM    791  NH1 ARG A 103       5.202  37.998  30.386  1.00 32.06           N  
ATOM    792  NH2 ARG A 103       5.470  35.832  31.105  1.00 32.39           N  
ATOM    793  N   ARG A 104      11.112  38.409  35.582  1.00 20.91           N  
ATOM    794  CA  ARG A 104      10.786  39.209  36.763  1.00 20.76           C  
ATOM    795  C   ARG A 104      11.857  39.215  37.851  1.00 20.08           C  
ATOM    796  O   ARG A 104      11.933  40.159  38.646  1.00 20.03           O  
ATOM    797  CB  ARG A 104       9.450  38.758  37.343  1.00 21.29           C  
ATOM    798  CG  ARG A 104       8.268  39.134  36.474  1.00 23.43           C  
ATOM    799  CD  ARG A 104       6.987  38.608  37.060  1.00 26.95           C  
ATOM    800  NE  ARG A 104       6.935  38.808  38.509  1.00 29.99           N  
ATOM    801  CZ  ARG A 104       5.964  38.345  39.290  1.00 31.42           C  
ATOM    802  NH1 ARG A 104       4.950  37.660  38.764  1.00 31.12           N  
ATOM    803  NH2 ARG A 104       6.002  38.573  40.597  1.00 31.54           N  
ATOM    804  N   SER A 105      12.687  38.180  37.884  1.00 18.63           N  
ATOM    805  CA  SER A 105      13.745  38.127  38.884  1.00 17.80           C  
ATOM    806  C   SER A 105      15.028  37.526  38.351  1.00 17.03           C  
ATOM    807  O   SER A 105      15.022  36.778  37.367  1.00 17.31           O  
ATOM    808  CB  SER A 105      13.273  37.366  40.130  1.00 18.35           C  
ATOM    809  OG  SER A 105      12.973  36.023  39.806  1.00 21.10           O  
ATOM    810  N   LEU A 106      16.125  37.877  39.011  1.00 15.20           N  
ATOM    811  CA  LEU A 106      17.422  37.306  38.720  1.00 14.11           C  
ATOM    812  C   LEU A 106      18.004  36.748  40.011  1.00 13.11           C  
ATOM    813  O   LEU A 106      17.826  37.325  41.079  1.00 12.64           O  
ATOM    814  CB  LEU A 106      18.387  38.340  38.128  1.00 14.24           C  
ATOM    815  CG  LEU A 106      18.002  39.167  36.899  1.00 15.11           C  
ATOM    816  CD1 LEU A 106      17.431  40.518  37.334  1.00 15.15           C  
ATOM    817  CD2 LEU A 106      19.209  39.366  36.005  1.00 15.70           C  
ATOM    818  N   VAL A 107      18.683  35.612  39.904  1.00 11.45           N  
ATOM    819  CA  VAL A 107      19.428  35.053  41.020  1.00 11.34           C  
ATOM    820  C   VAL A 107      20.912  35.185  40.707  1.00 11.45           C  
ATOM    821  O   VAL A 107      21.361  34.863  39.583  1.00 11.18           O  
ATOM    822  CB  VAL A 107      19.077  33.584  41.253  1.00 11.44           C  
ATOM    823  CG1 VAL A 107      19.800  33.041  42.495  1.00 12.50           C  
ATOM    824  CG2 VAL A 107      17.559  33.420  41.393  1.00 11.53           C  
ATOM    825  N   VAL A 108      21.670  35.634  41.701  1.00 10.81           N  
ATOM    826  CA  VAL A 108      23.091  35.933  41.508  1.00 11.91           C  
ATOM    827  C   VAL A 108      23.891  35.381  42.677  1.00 12.17           C  
ATOM    828  O   VAL A 108      23.394  35.387  43.814  1.00 12.09           O  
ATOM    829  CB  VAL A 108      23.350  37.477  41.424  1.00 11.29           C  
ATOM    830  CG1 VAL A 108      24.792  37.778  40.992  1.00 11.38           C  
ATOM    831  CG2 VAL A 108      22.375  38.146  40.479  1.00 14.87           C  
ATOM    832  N   GLU A 109      25.087  34.847  42.398  1.00 12.13           N  
ATOM    833  CA  GLU A 109      25.996  34.446  43.469  1.00 13.53           C  
ATOM    834  C   GLU A 109      27.250  35.291  43.367  1.00 13.13           C  
ATOM    835  O   GLU A 109      27.504  35.897  42.317  1.00 12.17           O  
ATOM    836  CB  GLU A 109      26.347  32.954  43.390  1.00 13.95           C  
ATOM    837  CG  GLU A 109      27.187  32.572  42.184  1.00 15.82           C  
ATOM    838  CD  GLU A 109      27.738  31.124  42.251  1.00 18.97           C  
ATOM    839  OE1 GLU A 109      27.674  30.487  43.325  1.00 25.65           O  
ATOM    840  OE2 GLU A 109      28.242  30.637  41.219  1.00 23.56           O  
ATOM    841  N   ALA A 110      28.025  35.351  44.445  1.00 12.21           N  
ATOM    842  CA  ALA A 110      29.278  36.112  44.411  1.00 12.74           C  
ATOM    843  C   ALA A 110      30.261  35.555  45.415  1.00 13.12           C  
ATOM    844  O   ALA A 110      29.861  34.939  46.405  1.00 13.87           O  
ATOM    845  CB  ALA A 110      29.031  37.606  44.659  1.00 12.53           C  
ATOM    846  N   GLU A 111      31.549  35.723  45.133  1.00 13.42           N  
ATOM    847  CA  GLU A 111      32.586  35.360  46.079  1.00 15.20           C  
ATOM    848  C   GLU A 111      33.568  36.515  46.183  1.00 13.71           C  
ATOM    849  O   GLU A 111      33.779  37.253  45.208  1.00 13.55           O  
ATOM    850  CB  GLU A 111      33.316  34.066  45.677  1.00 15.00           C  
ATOM    851  CG  GLU A 111      34.023  34.144  44.356  1.00 19.25           C  
ATOM    852  CD  GLU A 111      34.956  32.953  44.110  1.00 21.56           C  
ATOM    853  OE1 GLU A 111      35.816  33.063  43.210  1.00 30.30           O  
ATOM    854  OE2 GLU A 111      34.846  31.935  44.827  1.00 28.82           O  
ATOM    855  N   VAL A 112      34.105  36.703  47.378  1.00 11.88           N  
ATOM    856  CA  VAL A 112      35.148  37.692  47.615  1.00 12.13           C  
ATOM    857  C   VAL A 112      36.404  36.921  47.962  1.00 11.77           C  
ATOM    858  O   VAL A 112      36.363  35.999  48.791  1.00 11.61           O  
ATOM    859  CB  VAL A 112      34.782  38.631  48.779  1.00 12.32           C  
ATOM    860  CG1 VAL A 112      35.909  39.658  49.029  1.00 13.41           C  
ATOM    861  CG2 VAL A 112      33.434  39.333  48.490  1.00 12.31           C  
ATOM    862  N   ARG A 113      37.507  37.291  47.323  1.00 11.90           N  
ATOM    863  CA  ARG A 113      38.778  36.604  47.538  1.00 12.72           C  
ATOM    864  C   ARG A 113      39.913  37.596  47.704  1.00 12.24           C  
ATOM    865  O   ARG A 113      39.841  38.739  47.252  1.00 11.40           O  
ATOM    866  CB  ARG A 113      39.108  35.692  46.350  1.00 12.77           C  
ATOM    867  CG  ARG A 113      38.207  34.482  46.221  1.00 15.18           C  
ATOM    868  CD  ARG A 113      38.720  33.517  45.132  1.00 16.74           C  
ATOM    869  NE  ARG A 113      37.888  32.327  45.156  1.00 25.52           N  
ATOM    870  CZ  ARG A 113      38.122  31.265  45.914  1.00 26.15           C  
ATOM    871  NH1 ARG A 113      39.198  31.215  46.688  1.00 29.80           N  
ATOM    872  NH2 ARG A 113      37.278  30.251  45.890  1.00 30.28           N  
ATOM    873  N   GLN A 114      40.987  37.128  48.323  1.00 11.91           N  
ATOM    874  CA  GLN A 114      42.279  37.793  48.198  1.00 13.09           C  
ATOM    875  C   GLN A 114      43.231  36.688  47.733  1.00 13.18           C  
ATOM    876  O   GLN A 114      43.664  35.848  48.528  1.00 13.63           O  
ATOM    877  CB  GLN A 114      42.707  38.394  49.536  1.00 12.77           C  
ATOM    878  CG  GLN A 114      43.977  39.218  49.457  1.00 15.44           C  
ATOM    879  CD  GLN A 114      44.276  39.902  50.774  1.00 18.78           C  
ATOM    880  OE1 GLN A 114      44.721  39.258  51.722  1.00 22.67           O  
ATOM    881  NE2 GLN A 114      44.050  41.204  50.837  1.00 17.21           N  
ATOM    882  N   GLY A 115      43.519  36.655  46.437  1.00 13.76           N  
ATOM    883  CA  GLY A 115      44.253  35.529  45.853  1.00 15.79           C  
ATOM    884  C   GLY A 115      43.553  34.204  46.115  1.00 16.42           C  
ATOM    885  O   GLY A 115      42.364  34.056  45.818  1.00 18.11           O  
ATOM    886  N   ASP A 116      44.297  33.261  46.697  0.50 16.59           N  
ATOM    888  CA  ASP A 116      43.783  31.926  47.047  0.50 16.86           C  
ATOM    890  C   ASP A 116      43.130  31.876  48.440  0.50 16.49           C  
ATOM    892  O   ASP A 116      42.988  30.800  49.037  0.50 16.37           O  
ATOM    894  CB  ASP A 116      44.889  30.859  46.929  0.50 17.07           C  
ATOM    896  CG  ASP A 116      45.889  30.890  48.089  0.50 18.20           C  
ATOM    898  OD1 ASP A 116      46.035  31.938  48.742  0.50 19.83           O  
ATOM    900  OD2 ASP A 116      46.541  29.850  48.349  0.50 20.44           O  
ATOM    902  N   LYS A 117      42.750  33.040  48.958  1.00 15.84           N  
ATOM    903  CA  LYS A 117      42.010  33.099  50.211  1.00 15.72           C  
ATOM    904  C   LYS A 117      40.547  33.432  49.933  1.00 14.63           C  
ATOM    905  O   LYS A 117      40.242  34.508  49.411  1.00 14.07           O  
ATOM    906  CB  LYS A 117      42.621  34.125  51.168  1.00 15.46           C  
ATOM    907  CG  LYS A 117      44.150  34.026  51.329  1.00 19.30           C  
ATOM    908  CD  LYS A 117      44.626  35.220  52.126  1.00 25.42           C  
ATOM    909  CE  LYS A 117      46.081  35.521  51.851  1.00 29.84           C  
ATOM    910  NZ  LYS A 117      46.354  36.958  52.136  1.00 32.27           N  
ATOM    911  N   LEU A 118      39.641  32.515  50.288  1.00 13.75           N  
ATOM    912  CA  LEU A 118      38.209  32.816  50.216  1.00 13.06           C  
ATOM    913  C   LEU A 118      37.808  33.628  51.432  1.00 12.51           C  
ATOM    914  O   LEU A 118      37.961  33.174  52.577  1.00 13.75           O  
ATOM    915  CB  LEU A 118      37.371  31.534  50.120  1.00 13.30           C  
ATOM    916  CG  LEU A 118      35.858  31.722  50.012  1.00 14.34           C  
ATOM    917  CD1 LEU A 118      35.450  32.519  48.786  1.00 15.56           C  
ATOM    918  CD2 LEU A 118      35.141  30.348  50.017  1.00 14.65           C  
ATOM    919  N   VAL A 119      37.311  34.833  51.180  1.00 11.26           N  
ATOM    920  CA  VAL A 119      36.958  35.762  52.256  1.00 11.47           C  
ATOM    921  C   VAL A 119      35.460  35.723  52.577  1.00 11.75           C  
ATOM    922  O   VAL A 119      35.067  35.722  53.761  1.00 11.85           O  
ATOM    923  CB  VAL A 119      37.395  37.210  51.893  1.00 11.98           C  
ATOM    924  CG1 VAL A 119      36.810  38.244  52.874  1.00 12.93           C  
ATOM    925  CG2 VAL A 119      38.943  37.291  51.868  1.00 12.36           C  
ATOM    926  N   ALA A 120      34.626  35.728  51.540  1.00 11.61           N  
ATOM    927  CA  ALA A 120      33.158  35.716  51.765  1.00 11.30           C  
ATOM    928  C   ALA A 120      32.461  35.108  50.559  1.00 11.85           C  
ATOM    929  O   ALA A 120      33.032  35.036  49.474  1.00 11.59           O  
ATOM    930  CB  ALA A 120      32.638  37.138  52.026  1.00 11.40           C  
ATOM    931  N   LYS A 121      31.238  34.640  50.767  1.00 11.24           N  
ATOM    932  CA  LYS A 121      30.467  34.026  49.689  1.00 12.03           C  
ATOM    933  C   LYS A 121      29.026  34.433  49.928  1.00 11.55           C  
ATOM    934  O   LYS A 121      28.581  34.508  51.083  1.00 11.20           O  
ATOM    935  CB  LYS A 121      30.572  32.500  49.739  1.00 12.88           C  
ATOM    936  CG  LYS A 121      29.818  31.784  48.599  1.00 15.72           C  
ATOM    937  CD  LYS A 121      30.674  31.781  47.324  1.00 20.70           C  
ATOM    938  CE  LYS A 121      29.843  31.829  46.037  1.00 25.04           C  
ATOM    939  NZ  LYS A 121      29.244  30.548  45.674  1.00 27.06           N  
ATOM    940  N   GLY A 122      28.300  34.732  48.855  1.00 10.68           N  
ATOM    941  CA  GLY A 122      26.873  35.070  49.022  1.00 10.82           C  
ATOM    942  C   GLY A 122      26.004  34.762  47.831  1.00 10.62           C  
ATOM    943  O   GLY A 122      26.507  34.391  46.763  1.00 10.78           O  
ATOM    944  N   GLN A 123      24.701  34.953  48.028  1.00 10.36           N  
ATOM    945  CA  GLN A 123      23.683  34.642  47.037  1.00 11.20           C  
ATOM    946  C   GLN A 123      22.552  35.609  47.284  1.00 11.48           C  
ATOM    947  O   GLN A 123      22.197  35.850  48.437  1.00 11.46           O  
ATOM    948  CB  GLN A 123      23.196  33.208  47.273  1.00 10.84           C  
ATOM    949  CG  GLN A 123      22.215  32.669  46.266  1.00 12.10           C  
ATOM    950  CD  GLN A 123      21.818  31.230  46.590  1.00 13.17           C  
ATOM    951  OE1 GLN A 123      20.627  30.919  46.741  1.00 15.29           O  
ATOM    952  NE2 GLN A 123      22.815  30.357  46.733  1.00 15.08           N  
ATOM    953  N   GLY A 124      22.002  36.171  46.215  1.00 10.26           N  
ATOM    954  CA  GLY A 124      20.898  37.143  46.345  1.00 11.18           C  
ATOM    955  C   GLY A 124      19.933  37.103  45.181  1.00 11.45           C  
ATOM    956  O   GLY A 124      20.164  36.402  44.172  1.00 11.07           O  
ATOM    957  N   THR A 125      18.863  37.881  45.313  1.00 10.73           N  
ATOM    958  CA  THR A 125      17.775  37.874  44.355  1.00 11.38           C  
ATOM    959  C   THR A 125      17.534  39.322  44.005  1.00 11.78           C  
ATOM    960  O   THR A 125      17.444  40.181  44.894  1.00 11.66           O  
ATOM    961  CB  THR A 125      16.506  37.267  44.962  1.00 11.18           C  
ATOM    962  OG1 THR A 125      16.844  36.077  45.682  1.00 12.18           O  
ATOM    963  CG2 THR A 125      15.444  36.939  43.863  1.00 11.66           C  
ATOM    964  N   PHE A 126      17.429  39.585  42.708  1.00 12.69           N  
ATOM    965  CA  PHE A 126      17.156  40.926  42.189  1.00 14.35           C  
ATOM    966  C   PHE A 126      15.802  40.943  41.498  1.00 15.07           C  
ATOM    967  O   PHE A 126      15.357  39.928  40.940  1.00 14.05           O  
ATOM    968  CB  PHE A 126      18.278  41.330  41.215  1.00 15.25           C  
ATOM    969  CG  PHE A 126      19.524  41.824  41.895  1.00 16.66           C  
ATOM    970  CD1 PHE A 126      19.884  43.161  41.807  1.00 18.94           C  
ATOM    971  CD2 PHE A 126      20.322  40.969  42.644  1.00 17.86           C  
ATOM    972  CE1 PHE A 126      21.029  43.640  42.435  1.00 19.18           C  
ATOM    973  CE2 PHE A 126      21.472  41.434  43.302  1.00 19.15           C  
ATOM    974  CZ  PHE A 126      21.830  42.773  43.195  1.00 18.79           C  
ATOM    975  N   ALA A 127      15.128  42.093  41.535  1.00 16.11           N  
ATOM    976  CA  ALA A 127      13.861  42.235  40.836  1.00 17.70           C  
ATOM    977  C   ALA A 127      14.176  42.942  39.522  1.00 19.23           C  
ATOM    978  O   ALA A 127      14.883  43.958  39.509  1.00 18.67           O  
ATOM    979  CB  ALA A 127      12.876  43.030  41.668  1.00 18.43           C  
ATOM    980  N   GLN A 128      13.723  42.350  38.421  1.00 20.40           N  
ATOM    981  CA  GLN A 128      13.896  42.937  37.093  1.00 22.68           C  
ATOM    982  C   GLN A 128      12.899  44.078  36.938  1.00 23.59           C  
ATOM    983  O   GLN A 128      11.687  43.857  37.018  1.00 23.43           O  
ATOM    984  CB  GLN A 128      13.683  41.872  36.002  1.00 22.78           C  
ATOM    985  CG  GLN A 128      13.870  42.381  34.570  1.00 24.62           C  
ATOM    986  CD  GLN A 128      15.303  42.788  34.289  1.00 26.43           C  
ATOM    987  OE1 GLN A 128      16.199  41.947  34.278  1.00 25.10           O  
ATOM    988  NE2 GLN A 128      15.526  44.090  34.063  1.00 26.96           N  
ATOM    989  N   LEU A 129      13.411  45.296  36.762  1.00 25.12           N  
ATOM    990  CA  LEU A 129      12.547  46.455  36.529  1.00 26.77           C  
ATOM    991  C   LEU A 129      12.378  46.685  35.031  1.00 27.71           C  
ATOM    992  O   LEU A 129      13.023  46.017  34.214  1.00 28.45           O  
ATOM    993  CB  LEU A 129      13.093  47.711  37.224  1.00 26.87           C  
ATOM    994  CG  LEU A 129      13.292  47.613  38.744  1.00 28.01           C  
ATOM    995  CD1 LEU A 129      13.769  48.944  39.307  1.00 28.97           C  
ATOM    996  CD2 LEU A 129      12.020  47.138  39.462  1.00 28.78           C  
TER     997      LEU A 129                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
