
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  153 ( 1202),  selected  153 , name 1sh8_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1sh8_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     0_A      -       -           -
LGA    M     1_A      -       -           -
LGA    P     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    T     5_A      -       -           -
LGA    E     6_A      -       -           -
LGA    L     7_A      -       -           -
LGA    A     8_A      -       -           -
LGA    R     9_A      -       -           -
LGA    H    10_A      T       6          4.733
LGA    L    11_A      D       7          3.451
LGA    T    12_A      F       8          1.466
LGA    E    13_A      F       9           #
LGA    -       -      G      10           -
LGA    E    14_A      L      11           #
LGA    K    15_A      T      12          1.382
LGA    I    16_A      I      13          1.273
LGA    A    17_A      P      14          0.629
LGA    F    18_A      F      15          0.785
LGA    V    19_A      M      16          0.729
LGA    Q    20_A      Q      17          0.631
LGA    R    21_A      L      18          0.392
LGA    S    22_A      L      19          0.292
LGA    G    23_A      G      20          0.709
LGA    L    24_A      V      21          0.784
LGA    R    25_A      V      22          0.627
LGA    A    26_A      P      23          1.386
LGA    E    27_A      E      24          1.732
LGA    V    28_A      H      25          1.954
LGA    L    29_A      S      26          2.385
LGA    E    30_A      G      27          2.438
LGA    P    31_A      N      28          3.200
LGA    G    32_A      G      29          1.877
LGA    Y    33_A      T      30          2.031
LGA    V    34_A      A      31          1.049
LGA    R    35_A      R      32          0.798
LGA    L    36_A      T      33          0.729
LGA    R    37_A      R      34          0.881
LGA    M    38_A      L      35          1.164
LGA    P    39_A      P      36          1.613
LGA    G    40_A      A      37          1.896
LGA    A    41_A      R      38          1.352
LGA    G    42_A      A      39          3.533
LGA    -       -      D      40           -
LGA    N    43_A      L      41          1.346
LGA    E    44_A      V      42          1.467
LGA    N    45_A      N      43          1.805
LGA    H    46_A      S      44          2.243
LGA    I    47_A      R      45          1.724
LGA    G    48_A      G      46          1.278
LGA    S    49_A      D      47          0.816
LGA    M    50_A      I      48          0.304
LGA    Y    51_A      H      49          0.980
LGA    A    52_A      G      50          1.488
LGA    G    53_A      G      51          1.331
LGA    A    54_A      T      52          0.651
LGA    L    55_A      L      53          0.559
LGA    F    56_A      M      54          0.680
LGA    T    57_A      S      55          0.973
LGA    L    58_A      V      56          1.678
LGA    A    59_A      L      57          1.389
LGA    E    60_A      D      58          1.077
LGA    L    61_A      F      59          1.102
LGA    P    62_A      T      60          1.798
LGA    G    63_A      L      61          2.837
LGA    G    64_A      G      62          2.614
LGA    A    65_A      A      63          1.584
LGA    L    66_A      A      64          2.251
LGA    F    67_A      I      65          3.414
LGA    L    68_A      R      66          3.244
LGA    T    69_A      G      67          1.010
LGA    S    70_A      D      68          1.368
LGA    F    71_A      T      69          1.764
LGA    D    72_A      P      70          4.496
LGA    S    73_A      E      71          2.275
LGA    A    74_A      V      72          5.288
LGA    R    75_A      -       -           -
LGA    F    76_A      -       -           -
LGA    Y    77_A      G      73          1.128
LGA    P    78_A      V      74          0.692
LGA    I    79_A      A      75          0.636
LGA    V    80_A      T      76          0.524
LGA    K    81_A      I      77          0.738
LGA    E    82_A      D      78          0.766
LGA    M    83_A      M      79          0.887
LGA    T    84_A      N      80          1.313
LGA    L    85_A      T      81          1.150
LGA    R    86_A      S      82          1.354
LGA    F    87_A      F      83          1.040
LGA    R    88_A      M      84          1.073
LGA    R    89_A      S      85          1.507
LGA    P    90_A      P      86          0.977
LGA    A    91_A      G      87          0.473
LGA    K    92_A      R      88          0.777
LGA    G    93_A      G      89          0.587
LGA    D    94_A      D      90          1.135
LGA    I    95_A      L      91          1.338
LGA    R    96_A      V      92          1.449
LGA    V    97_A      I      93          1.581
LGA    E    98_A      E      94          0.965
LGA    A    99_A      T      95          1.446
LGA    R   100_A      R      96          2.212
LGA    L   101_A      C      97          3.231
LGA    D   102_A      L      98           #
LGA    A   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    R   105_A      R      99          4.901
LGA    I   106_A      R     100          5.270
LGA    R   107_A      -       -           -
LGA    Q   108_A      -       -           -
LGA    L   109_A      G     101          3.083
LGA    E   110_A      -       -           -
LGA    T   111_A      -       -           -
LGA    E   112_A      A     102          2.112
LGA    A   113_A      -       -           -
LGA    G   114_A      -       -           -
LGA    E   115_A      -       -           -
LGA    R   116_A      -       -           -
LGA    G   117_A      -       -           -
LGA    K   118_A      -       -           -
LGA    A   119_A      S     103          1.496
LGA    E   120_A      I     104          1.274
LGA    Y   121_A      A     105          1.502
LGA    S   122_A      F     106          1.527
LGA    L   123_A      C     107          1.656
LGA    E   124_A      E     108          2.301
LGA    L   125_A      G     109          1.757
LGA    Q   126_A      E     110          1.812
LGA    L   127_A      I     111          1.148
LGA    T   128_A      R     112          0.754
LGA    D   129_A      D     113          0.624
LGA    E   130_A      S     114          0.622
LGA    Q   131_A      A     115          0.532
LGA    G   132_A      G     116          0.739
LGA    E   133_A      E     117          0.640
LGA    V   134_A      L     118          0.570
LGA    V   135_A      V     119          1.039
LGA    A   136_A      A     120          1.050
LGA    E   137_A      K     121          1.373
LGA    S   138_A      A     122          0.995
LGA    A   139_A      T     123          1.556
LGA    A   140_A      A     124          1.159
LGA    L   141_A      T     125          0.975
LGA    Y   142_A      F     126          1.012
LGA    Q   143_A      K     127          1.416
LGA    L   144_A      I     128          0.660
LGA    R   145_A      I     129          1.844
LGA    S   146_A      Q     130          1.728
LGA    H   147_A      -       -           -
LGA    A   148_A      -       -           -
LGA    R   149_A      -       -           -
LGA    P   150_A      -       -           -
LGA    G   151_A      -       -           -
LGA    S   152_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  153  125    5.0    120    1.83    25.00     87.886     6.230

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.179074 * X  +  -0.801142 * Y  +  -0.571055 * Z  +  34.035034
  Y_new =   0.907463 * X  +  -0.089723 * Y  +   0.410441 * Z  +  26.701715
  Z_new =  -0.380058 * X  +  -0.591710 * Y  +   0.710940 * Z  +  58.036816 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.694124    2.447469  [ DEG:   -39.7704    140.2296 ]
  Theta =   0.389859    2.751734  [ DEG:    22.3373    157.6627 ]
  Phi   =   1.375964   -1.765628  [ DEG:    78.8370   -101.1630 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1sh8_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1sh8_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  153  125   5.0  120   1.83   25.00  87.886
REMARK  ---------------------------------------------------------- 
MOLECULE 1sh8_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-FEB-04   1SH8              
TITLE     1.5 A CRYSTAL STRUCTURE OF A PROTEIN OF UNKNOWN FUNCTION              
TITLE    2 PA5026 FROM PSEUDOMONAS AERUGINOSA, PROBABLE THIOESTERASE            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA5026;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PA5026;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    STRUCTURAL GENOMICS, PSEUDOMONAS AERUGINOSA, PSI, PROTEIN             
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,E.EVDOKIMOVA,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,              
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   2   18-JAN-05 1SH8    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   06-JUL-04 1SH8    0                                                
JRNL        AUTH   R.ZHANG,E.EVDOKIMOVA,A.SAVCHENKO,A.EDWARDS,                  
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   1.5A CRYSTAL STRUCTURE OF A HYPOTHETICAL PROTEIN             
JRNL        TITL 2 PA5026 FROM PSEUDOMONAS AERUGINOSA                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1SH8 A    1   150  UNP    Q9HUE3   Q9HUE3_PSEAE     1    150             
DBREF  1SH8 B    1   150  UNP    Q9HUE3   Q9HUE3_PSEAE     1    150             
SEQRES   1 A  154  GLY HIS MET PRO LEU PRO THR GLU LEU ALA ARG HIS LEU          
SEQRES   2 A  154  THR GLU GLU LYS ILE ALA PHE VAL GLN ARG SER GLY LEU          
SEQRES   3 A  154  ARG ALA GLU VAL LEU GLU PRO GLY TYR VAL ARG LEU ARG          
SEQRES   4 A  154  MET PRO GLY ALA GLY ASN GLU ASN HIS ILE GLY SER MET          
SEQRES   5 A  154  TYR ALA GLY ALA LEU PHE THR LEU ALA GLU LEU PRO GLY          
SEQRES   6 A  154  GLY ALA LEU PHE LEU THR SER PHE ASP SER ALA ARG PHE          
SEQRES   7 A  154  TYR PRO ILE VAL LYS GLU MET THR LEU ARG PHE ARG ARG          
SEQRES   8 A  154  PRO ALA LYS GLY ASP ILE ARG VAL GLU ALA ARG LEU ASP          
SEQRES   9 A  154  ALA GLU ARG ILE ARG GLN LEU GLU THR GLU ALA GLY GLU          
SEQRES  10 A  154  ARG GLY LYS ALA GLU TYR SER LEU GLU LEU GLN LEU THR          
SEQRES  11 A  154  ASP GLU GLN GLY GLU VAL VAL ALA GLU SER ALA ALA LEU          
SEQRES  12 A  154  TYR GLN LEU ARG SER HIS ALA ARG PRO GLY SER                  
SEQRES   1 B  154  GLY HIS MET PRO LEU PRO THR GLU LEU ALA ARG HIS LEU          
SEQRES   2 B  154  THR GLU GLU LYS ILE ALA PHE VAL GLN ARG SER GLY LEU          
SEQRES   3 B  154  ARG ALA GLU VAL LEU GLU PRO GLY TYR VAL ARG LEU ARG          
SEQRES   4 B  154  MET PRO GLY ALA GLY ASN GLU ASN HIS ILE GLY SER MET          
SEQRES   5 B  154  TYR ALA GLY ALA LEU PHE THR LEU ALA GLU LEU PRO GLY          
SEQRES   6 B  154  GLY ALA LEU PHE LEU THR SER PHE ASP SER ALA ARG PHE          
SEQRES   7 B  154  TYR PRO ILE VAL LYS GLU MET THR LEU ARG PHE ARG ARG          
SEQRES   8 B  154  PRO ALA LYS GLY ASP ILE ARG VAL GLU ALA ARG LEU ASP          
SEQRES   9 B  154  ALA GLU ARG ILE ARG GLN LEU GLU THR GLU ALA GLY GLU          
SEQRES  10 B  154  ARG GLY LYS ALA GLU TYR SER LEU GLU LEU GLN LEU THR          
SEQRES  11 B  154  ASP GLU GLN GLY GLU VAL VAL ALA GLU SER ALA ALA LEU          
SEQRES  12 B  154  TYR GLN LEU ARG SER HIS ALA ARG PRO GLY SER                  
FORMUL   3  HOH   *332(H2 O)                                                    
CRYST1   56.608   72.231   91.051  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   HIS A   0      25.907  41.255  22.161  1.00 35.19           N  
ATOM      2  CA  HIS A   0      26.326  42.689  22.105  1.00 33.90           C  
ATOM      3  C   HIS A   0      26.375  43.293  23.517  1.00 32.23           C  
ATOM      4  O   HIS A   0      25.891  42.691  24.484  1.00 32.77           O  
ATOM      5  CB  HIS A   0      25.347  43.481  21.227  1.00 34.32           C  
ATOM      6  CG  HIS A   0      24.067  43.839  21.917  1.00 35.11           C  
ATOM      7  ND1 HIS A   0      23.909  45.010  22.627  1.00 35.34           N  
ATOM      8  CD2 HIS A   0      22.901  43.160  22.045  1.00 36.50           C  
ATOM      9  CE1 HIS A   0      22.702  45.038  23.165  1.00 36.47           C  
ATOM     10  NE2 HIS A   0      22.071  43.927  22.828  1.00 37.50           N  
ATOM     11  N   MET A   1      26.958  44.485  23.621  1.00 29.46           N  
ATOM     12  CA  MET A   1      27.082  45.184  24.898  1.00 25.47           C  
ATOM     13  C   MET A   1      26.045  46.301  25.002  1.00 23.30           C  
ATOM     14  O   MET A   1      25.960  47.156  24.120  1.00 22.52           O  
ATOM     15  CB  MET A   1      28.469  45.812  25.015  1.00 26.71           C  
ATOM     16  CG  MET A   1      29.621  44.849  24.841  1.00 29.48           C  
ATOM     17  SD  MET A   1      31.086  45.714  24.243  1.00 33.82           S  
ATOM     18  CE  MET A   1      31.475  46.760  25.663  1.00 28.62           C  
ATOM     19  N   PRO A   2      25.240  46.308  26.075  1.00 19.98           N  
ATOM     20  CA  PRO A   2      24.232  47.362  26.230  1.00 17.99           C  
ATOM     21  C   PRO A   2      24.870  48.718  26.552  1.00 16.19           C  
ATOM     22  O   PRO A   2      24.238  49.764  26.389  1.00 15.65           O  
ATOM     23  CB  PRO A   2      23.359  46.839  27.370  1.00 19.63           C  
ATOM     24  CG  PRO A   2      24.330  46.054  28.200  1.00 20.47           C  
ATOM     25  CD  PRO A   2      25.105  45.295  27.137  1.00 21.12           C  
ATOM     26  N   LEU A   3      26.120  48.691  27.017  1.00 14.06           N  
ATOM     27  CA  LEU A   3      26.860  49.912  27.348  1.00 13.66           C  
ATOM     28  C   LEU A   3      28.341  49.752  27.028  1.00 13.37           C  
ATOM     29  O   LEU A   3      28.882  48.649  27.122  1.00 14.26           O  
ATOM     30  CB  LEU A   3      26.756  50.242  28.844  1.00 13.28           C  
ATOM     31  CG  LEU A   3      25.489  50.830  29.464  1.00 13.51           C  
ATOM     32  CD1 LEU A   3      25.691  50.930  30.970  1.00 12.28           C  
ATOM     33  CD2 LEU A   3      25.190  52.206  28.873  1.00 12.87           C  
ATOM     34  N   PRO A   4      29.012  50.848  26.630  1.00 12.33           N  
ATOM     35  CA  PRO A   4      30.446  50.764  26.327  1.00 11.91           C  
ATOM     36  C   PRO A   4      31.166  50.600  27.675  1.00 11.13           C  
ATOM     37  O   PRO A   4      30.653  51.023  28.712  1.00 10.61           O  
ATOM     38  CB  PRO A   4      30.738  52.096  25.636  1.00 11.70           C  
ATOM     39  CG  PRO A   4      29.737  53.028  26.250  1.00 12.03           C  
ATOM     40  CD  PRO A   4      28.480  52.187  26.316  1.00 10.81           C  
ATOM     41  N   THR A   5      32.346  49.993  27.657  1.00 11.65           N  
ATOM     42  CA  THR A   5      33.086  49.707  28.883  1.00 11.38           C  
ATOM     43  C   THR A   5      33.417  50.829  29.868  1.00 10.52           C  
ATOM     44  O   THR A   5      33.183  50.679  31.075  1.00 10.39           O  
ATOM     45  CB  THR A   5      34.383  48.964  28.554  1.00 12.51           C  
ATOM     46  OG1 THR A   5      34.073  47.853  27.704  1.00 14.56           O  
ATOM     47  CG2 THR A   5      35.039  48.444  29.830  1.00 13.86           C  
ATOM     48  N   GLU A   6      33.969  51.938  29.387  1.00  8.89           N  
ATOM     49  CA  GLU A   6      34.327  53.019  30.300  1.00 10.61           C  
ATOM     50  C   GLU A   6      33.103  53.601  31.017  1.00  9.47           C  
ATOM     51  O   GLU A   6      33.155  53.907  32.215  1.00  8.08           O  
ATOM     52  CB  GLU A   6      35.089  54.120  29.555  1.00 12.42           C  
ATOM     53  CG  GLU A   6      36.410  53.654  28.954  1.00 18.07           C  
ATOM     54  CD  GLU A   6      37.258  52.851  29.935  1.00 24.28           C  
ATOM     55  OE1 GLU A   6      37.521  53.340  31.059  1.00 25.67           O  
ATOM     56  OE2 GLU A   6      37.666  51.721  29.582  1.00 29.01           O  
ATOM     57  N   LEU A   7      32.005  53.745  30.280  1.00  7.87           N  
ATOM     58  CA  LEU A   7      30.781  54.270  30.857  1.00  7.63           C  
ATOM     59  C   LEU A   7      30.238  53.272  31.884  1.00  7.79           C  
ATOM     60  O   LEU A   7      29.790  53.665  32.968  1.00  8.50           O  
ATOM     61  CB  LEU A   7      29.755  54.533  29.750  1.00  8.10           C  
ATOM     62  CG  LEU A   7      28.343  54.980  30.151  1.00  8.16           C  
ATOM     63  CD1 LEU A   7      28.385  56.190  31.087  1.00  7.92           C  
ATOM     64  CD2 LEU A   7      27.563  55.301  28.885  1.00  9.03           C  
ATOM     65  N   ALA A   8      30.291  51.979  31.558  1.00  6.99           N  
ATOM     66  CA  ALA A   8      29.800  50.958  32.486  1.00  7.38           C  
ATOM     67  C   ALA A   8      30.615  50.994  33.775  1.00  6.83           C  
ATOM     68  O   ALA A   8      30.069  50.892  34.875  1.00  7.84           O  
ATOM     69  CB  ALA A   8      29.880  49.571  31.846  1.00  7.73           C  
ATOM     70  N   ARG A   9      31.926  51.157  33.636  1.00  6.89           N  
ATOM     71  CA  ARG A   9      32.812  51.218  34.794  1.00  7.73           C  
ATOM     72  C   ARG A   9      32.514  52.470  35.621  1.00  7.79           C  
ATOM     73  O   ARG A   9      32.437  52.412  36.848  1.00  7.16           O  
ATOM     74  CB  ARG A   9      34.276  51.201  34.331  1.00  9.33           C  
ATOM     75  CG  ARG A   9      35.305  51.332  35.448  1.00 12.85           C  
ATOM     76  CD  ARG A   9      35.647  52.792  35.692  1.00 15.65           C  
ATOM     77  NE  ARG A   9      36.216  53.404  34.492  1.00 16.05           N  
ATOM     78  CZ  ARG A   9      36.191  54.707  34.236  1.00 16.01           C  
ATOM     79  NH1 ARG A   9      36.732  55.174  33.117  1.00 15.90           N  
ATOM     80  NH2 ARG A   9      35.622  55.544  35.094  1.00 14.61           N  
ATOM     81  N   HIS A  10      32.324  53.600  34.945  1.00  7.05           N  
ATOM     82  CA  HIS A  10      32.027  54.843  35.644  1.00  7.43           C  
ATOM     83  C   HIS A  10      30.735  54.707  36.450  1.00  7.67           C  
ATOM     84  O   HIS A  10      30.683  55.074  37.625  1.00  7.76           O  
ATOM     85  CB  HIS A  10      31.906  55.999  34.642  1.00  7.24           C  
ATOM     86  CG  HIS A  10      31.727  57.341  35.284  1.00  8.78           C  
ATOM     87  ND1 HIS A  10      30.491  57.854  35.613  1.00  9.78           N  
ATOM     88  CD2 HIS A  10      32.636  58.262  35.685  1.00  7.31           C  
ATOM     89  CE1 HIS A  10      30.645  59.033  36.190  1.00  6.62           C  
ATOM     90  NE2 HIS A  10      31.937  59.302  36.246  1.00 11.08           N  
ATOM     91  N   LEU A  11      29.692  54.173  35.821  1.00  7.79           N  
ATOM     92  CA  LEU A  11      28.410  54.000  36.505  1.00  7.72           C  
ATOM     93  C   LEU A  11      28.527  53.031  37.683  1.00  8.32           C  
ATOM     94  O   LEU A  11      27.996  53.287  38.762  1.00  9.33           O  
ATOM     95  CB  LEU A  11      27.346  53.513  35.518  1.00  8.00           C  
ATOM     96  CG  LEU A  11      26.973  54.540  34.439  1.00  9.18           C  
ATOM     97  CD1 LEU A  11      25.978  53.931  33.450  1.00  9.34           C  
ATOM     98  CD2 LEU A  11      26.392  55.788  35.107  1.00  9.42           C  
ATOM     99  N   THR A  12      29.239  51.927  37.480  1.00  7.90           N  
ATOM    100  CA  THR A  12      29.417  50.933  38.532  1.00  7.77           C  
ATOM    101  C   THR A  12      30.112  51.516  39.760  1.00  9.05           C  
ATOM    102  O   THR A  12      29.680  51.307  40.894  1.00 10.12           O  
ATOM    103  CB  THR A  12      30.253  49.731  38.023  1.00  8.10           C  
ATOM    104  OG1 THR A  12      29.545  49.065  36.974  1.00  8.47           O  
ATOM    105  CG2 THR A  12      30.516  48.736  39.150  1.00  7.29           C  
ATOM    106  N   GLU A  13      31.186  52.259  39.528  1.00  9.60           N  
ATOM    107  CA  GLU A  13      31.960  52.836  40.617  1.00 11.24           C  
ATOM    108  C   GLU A  13      31.431  54.139  41.188  1.00 12.82           C  
ATOM    109  O   GLU A  13      31.648  54.425  42.369  1.00 13.95           O  
ATOM    110  CB  GLU A  13      33.405  53.074  40.162  1.00 10.64           C  
ATOM    111  CG  GLU A  13      34.148  51.821  39.717  1.00 10.67           C  
ATOM    112  CD  GLU A  13      35.564  52.113  39.231  1.00 12.19           C  
ATOM    113  OE1 GLU A  13      35.951  53.304  39.163  1.00 13.69           O  
ATOM    114  OE2 GLU A  13      36.293  51.149  38.910  1.00 11.59           O  
ATOM    115  N   GLU A  14      30.727  54.921  40.373  1.00 12.31           N  
ATOM    116  CA  GLU A  14      30.275  56.231  40.835  1.00 13.33           C  
ATOM    117  C   GLU A  14      28.801  56.614  40.850  1.00 12.85           C  
ATOM    118  O   GLU A  14      28.460  57.672  41.378  1.00 13.92           O  
ATOM    119  CB  GLU A  14      31.053  57.304  40.068  1.00 14.36           C  
ATOM    120  CG  GLU A  14      32.556  57.235  40.299  1.00 17.53           C  
ATOM    121  CD  GLU A  14      33.328  58.200  39.432  1.00 19.96           C  
ATOM    122  OE1 GLU A  14      32.932  59.384  39.363  1.00 19.76           O  
ATOM    123  OE2 GLU A  14      34.335  57.777  38.824  1.00 20.15           O  
ATOM    124  N   LYS A  15      27.914  55.796  40.300  1.00 12.96           N  
ATOM    125  CA  LYS A  15      26.513  56.198  40.310  1.00 13.74           C  
ATOM    126  C   LYS A  15      25.971  56.343  41.729  1.00 13.83           C  
ATOM    127  O   LYS A  15      25.188  57.252  42.013  1.00 13.83           O  
ATOM    128  CB  LYS A  15      25.650  55.210  39.531  1.00 15.36           C  
ATOM    129  CG  LYS A  15      24.271  55.769  39.204  1.00 19.47           C  
ATOM    130  CD  LYS A  15      23.551  54.889  38.212  1.00 23.17           C  
ATOM    131  CE  LYS A  15      22.210  55.477  37.817  1.00 25.23           C  
ATOM    132  NZ  LYS A  15      21.514  54.575  36.851  1.00 27.23           N  
ATOM    133  N   ILE A  16      26.387  55.445  42.616  1.00 11.69           N  
ATOM    134  CA  ILE A  16      25.943  55.484  44.011  1.00  9.75           C  
ATOM    135  C   ILE A  16      27.080  56.043  44.866  1.00  9.72           C  
ATOM    136  O   ILE A  16      28.139  55.421  44.996  1.00 10.00           O  
ATOM    137  CB  ILE A  16      25.543  54.065  44.495  1.00  9.63           C  
ATOM    138  CG1 ILE A  16      24.383  53.542  43.640  1.00  7.97           C  
ATOM    139  CG2 ILE A  16      25.143  54.097  45.973  1.00  9.21           C  
ATOM    140  CD1 ILE A  16      23.940  52.140  43.998  1.00 10.96           C  
ATOM    141  N   ALA A  17      26.854  57.225  45.441  1.00  9.71           N  
ATOM    142  CA  ALA A  17      27.860  57.909  46.256  1.00  9.82           C  
ATOM    143  C   ALA A  17      28.425  57.067  47.399  1.00  9.32           C  
ATOM    144  O   ALA A  17      29.625  57.113  47.676  1.00 10.10           O  
ATOM    145  CB  ALA A  17      27.286  59.212  46.805  1.00 10.26           C  
ATOM    146  N   PHE A  18      27.554  56.316  48.067  1.00  8.58           N  
ATOM    147  CA  PHE A  18      27.958  55.451  49.172  1.00  7.81           C  
ATOM    148  C   PHE A  18      29.049  54.506  48.673  1.00  8.99           C  
ATOM    149  O   PHE A  18      30.043  54.261  49.363  1.00  9.06           O  
ATOM    150  CB  PHE A  18      26.739  54.654  49.649  1.00  8.66           C  
ATOM    151  CG  PHE A  18      27.010  53.741  50.821  1.00  8.18           C  
ATOM    152  CD1 PHE A  18      26.717  54.151  52.122  1.00  9.05           C  
ATOM    153  CD2 PHE A  18      27.517  52.459  50.620  1.00  7.51           C  
ATOM    154  CE1 PHE A  18      26.921  53.290  53.210  1.00  8.50           C  
ATOM    155  CE2 PHE A  18      27.724  51.595  51.694  1.00  8.03           C  
ATOM    156  CZ  PHE A  18      27.424  52.010  52.992  1.00  7.89           C  
ATOM    157  N   VAL A  19      28.861  53.983  47.463  1.00  9.07           N  
ATOM    158  CA  VAL A  19      29.818  53.065  46.849  1.00  8.73           C  
ATOM    159  C   VAL A  19      31.079  53.812  46.425  1.00  9.45           C  
ATOM    160  O   VAL A  19      32.197  53.357  46.661  1.00  9.41           O  
ATOM    161  CB  VAL A  19      29.200  52.367  45.615  1.00  9.45           C  
ATOM    162  CG1 VAL A  19      30.266  51.553  44.873  1.00  9.67           C  
ATOM    163  CG2 VAL A  19      28.060  51.459  46.061  1.00  7.12           C  
ATOM    164  N   GLN A  20      30.895  54.969  45.807  1.00  9.49           N  
ATOM    165  CA  GLN A  20      32.024  55.765  45.362  1.00 10.71           C  
ATOM    166  C   GLN A  20      32.969  56.078  46.533  1.00 11.08           C  
ATOM    167  O   GLN A  20      34.192  55.959  46.401  1.00 11.64           O  
ATOM    168  CB  GLN A  20      31.514  57.061  44.720  1.00 12.16           C  
ATOM    169  CG  GLN A  20      32.558  57.786  43.892  1.00 14.36           C  
ATOM    170  CD  GLN A  20      33.611  58.461  44.741  1.00 18.42           C  
ATOM    171  OE1 GLN A  20      34.788  58.511  44.368  1.00 23.34           O  
ATOM    172  NE2 GLN A  20      33.197  58.998  45.886  1.00 16.06           N  
ATOM    173  N   ARG A  21      32.398  56.457  47.678  1.00 10.71           N  
ATOM    174  CA  ARG A  21      33.190  56.796  48.864  1.00 11.04           C  
ATOM    175  C   ARG A  21      34.027  55.632  49.395  1.00 10.74           C  
ATOM    176  O   ARG A  21      35.037  55.855  50.063  1.00 10.78           O  
ATOM    177  CB  ARG A  21      32.286  57.306  49.993  1.00 11.54           C  
ATOM    178  CG  ARG A  21      31.538  58.597  49.693  1.00 14.08           C  
ATOM    179  CD  ARG A  21      30.950  59.209  50.973  1.00 14.63           C  
ATOM    180  NE  ARG A  21      29.979  58.346  51.652  1.00 18.17           N  
ATOM    181  CZ  ARG A  21      28.664  58.364  51.434  1.00 19.17           C  
ATOM    182  NH1 ARG A  21      28.143  59.203  50.542  1.00 16.65           N  
ATOM    183  NH2 ARG A  21      27.866  57.555  52.124  1.00 17.91           N  
ATOM    184  N   SER A  22      33.613  54.400  49.107  1.00  9.26           N  
ATOM    185  CA  SER A  22      34.347  53.224  49.581  1.00  9.94           C  
ATOM    186  C   SER A  22      35.577  52.912  48.732  1.00 10.21           C  
ATOM    187  O   SER A  22      36.439  52.138  49.144  1.00 12.00           O  
ATOM    188  CB  SER A  22      33.441  51.990  49.601  1.00  9.49           C  
ATOM    189  OG  SER A  22      33.279  51.457  48.297  1.00 10.18           O  
ATOM    190  N   GLY A  23      35.647  53.496  47.541  1.00 10.25           N  
ATOM    191  CA  GLY A  23      36.787  53.254  46.672  1.00 11.41           C  
ATOM    192  C   GLY A  23      36.698  51.972  45.856  1.00 10.90           C  
ATOM    193  O   GLY A  23      37.690  51.535  45.265  1.00 11.02           O  
ATOM    194  N   LEU A  24      35.516  51.364  45.819  1.00  9.54           N  
ATOM    195  CA  LEU A  24      35.321  50.134  45.061  1.00 10.22           C  
ATOM    196  C   LEU A  24      35.732  50.328  43.607  1.00  9.75           C  
ATOM    197  O   LEU A  24      35.406  51.348  42.993  1.00  9.82           O  
ATOM    198  CB  LEU A  24      33.856  49.694  45.131  1.00 10.52           C  
ATOM    199  CG  LEU A  24      33.514  48.421  44.353  1.00 10.93           C  
ATOM    200  CD1 LEU A  24      32.460  47.619  45.100  1.00 12.08           C  
ATOM    201  CD2 LEU A  24      33.051  48.793  42.952  1.00  9.37           C  
ATOM    202  N   ARG A  25      36.454  49.351  43.064  1.00  8.63           N  
ATOM    203  CA  ARG A  25      36.911  49.412  41.680  1.00  9.22           C  
ATOM    204  C   ARG A  25      36.457  48.196  40.877  1.00  9.73           C  
ATOM    205  O   ARG A  25      36.410  47.075  41.391  1.00 10.81           O  
ATOM    206  CB  ARG A  25      38.435  49.508  41.637  1.00 10.87           C  
ATOM    207  CG  ARG A  25      38.983  50.738  42.345  1.00 16.00           C  
ATOM    208  CD  ARG A  25      38.753  51.989  41.519  1.00 22.08           C  
ATOM    209  NE  ARG A  25      39.575  51.959  40.316  1.00 30.83           N  
ATOM    210  CZ  ARG A  25      39.485  52.830  39.315  1.00 35.41           C  
ATOM    211  NH1 ARG A  25      38.597  53.819  39.359  1.00 36.76           N  
ATOM    212  NH2 ARG A  25      40.287  52.708  38.265  1.00 37.31           N  
ATOM    213  N   ALA A  26      36.104  48.427  39.617  1.00  9.04           N  
ATOM    214  CA  ALA A  26      35.678  47.345  38.739  1.00  9.52           C  
ATOM    215  C   ALA A  26      36.904  46.899  37.963  1.00 10.72           C  
ATOM    216  O   ALA A  26      37.567  47.718  37.332  1.00 13.15           O  
ATOM    217  CB  ALA A  26      34.605  47.839  37.773  1.00 10.53           C  
ATOM    218  N   GLU A  27      37.225  45.611  38.022  1.00 10.23           N  
ATOM    219  CA  GLU A  27      38.376  45.099  37.286  1.00  9.74           C  
ATOM    220  C   GLU A  27      37.932  44.640  35.903  1.00 10.61           C  
ATOM    221  O   GLU A  27      38.616  44.891  34.909  1.00 11.70           O  
ATOM    222  CB  GLU A  27      39.041  43.952  38.052  1.00  9.54           C  
ATOM    223  CG  GLU A  27      39.618  44.386  39.391  1.00 10.77           C  
ATOM    224  CD  GLU A  27      40.561  43.365  40.002  1.00 12.11           C  
ATOM    225  OE1 GLU A  27      40.480  42.167  39.645  1.00 11.08           O  
ATOM    226  OE2 GLU A  27      41.378  43.766  40.857  1.00 13.43           O  
ATOM    227  N   VAL A  28      36.786  43.968  35.841  1.00  9.84           N  
ATOM    228  CA  VAL A  28      36.227  43.502  34.575  1.00 10.78           C  
ATOM    229  C   VAL A  28      34.713  43.710  34.574  1.00 10.47           C  
ATOM    230  O   VAL A  28      34.036  43.409  35.558  1.00  9.69           O  
ATOM    231  CB  VAL A  28      36.508  41.999  34.326  1.00 11.17           C  
ATOM    232  CG1 VAL A  28      35.775  41.531  33.073  1.00 11.90           C  
ATOM    233  CG2 VAL A  28      38.007  41.766  34.166  1.00 13.14           C  
ATOM    234  N   LEU A  29      34.198  44.243  33.470  1.00  9.99           N  
ATOM    235  CA  LEU A  29      32.764  44.479  33.303  1.00 10.39           C  
ATOM    236  C   LEU A  29      32.387  44.115  31.872  1.00 10.96           C  
ATOM    237  O   LEU A  29      32.703  44.846  30.934  1.00 12.60           O  
ATOM    238  CB  LEU A  29      32.418  45.949  33.566  1.00  9.27           C  
ATOM    239  CG  LEU A  29      32.577  46.439  35.004  1.00  9.27           C  
ATOM    240  CD1 LEU A  29      32.354  47.940  35.055  1.00  9.53           C  
ATOM    241  CD2 LEU A  29      31.582  45.715  35.909  1.00  8.31           C  
ATOM    242  N   GLU A  30      31.718  42.982  31.708  1.00  9.90           N  
ATOM    243  CA  GLU A  30      31.307  42.527  30.387  1.00 10.92           C  
ATOM    244  C   GLU A  30      29.941  41.867  30.512  1.00 10.89           C  
ATOM    245  O   GLU A  30      29.511  41.507  31.615  1.00  9.79           O  
ATOM    246  CB  GLU A  30      32.316  41.507  29.844  1.00 12.72           C  
ATOM    247  CG  GLU A  30      33.768  41.937  29.996  1.00 16.31           C  
ATOM    248  CD  GLU A  30      34.758  40.901  29.486  1.00 16.51           C  
ATOM    249  OE1 GLU A  30      34.557  39.694  29.737  1.00 15.88           O  
ATOM    250  OE2 GLU A  30      35.748  41.307  28.845  1.00 19.26           O  
ATOM    251  N   PRO A  31      29.226  41.712  29.387  1.00 10.53           N  
ATOM    252  CA  PRO A  31      27.913  41.073  29.476  1.00 10.60           C  
ATOM    253  C   PRO A  31      28.078  39.706  30.139  1.00 10.76           C  
ATOM    254  O   PRO A  31      28.924  38.916  29.721  1.00 11.79           O  
ATOM    255  CB  PRO A  31      27.493  40.954  28.014  1.00 10.97           C  
ATOM    256  CG  PRO A  31      28.118  42.173  27.392  1.00 11.34           C  
ATOM    257  CD  PRO A  31      29.499  42.184  28.016  1.00 11.89           C  
ATOM    258  N   GLY A  32      27.298  39.444  31.184  1.00  9.11           N  
ATOM    259  CA  GLY A  32      27.372  38.162  31.863  1.00  8.42           C  
ATOM    260  C   GLY A  32      28.545  37.898  32.799  1.00  8.41           C  
ATOM    261  O   GLY A  32      28.618  36.823  33.382  1.00  8.51           O  
ATOM    262  N   TYR A  33      29.465  38.847  32.949  1.00  8.77           N  
ATOM    263  CA  TYR A  33      30.604  38.643  33.842  1.00  7.93           C  
ATOM    264  C   TYR A  33      31.191  39.934  34.396  1.00  8.17           C  
ATOM    265  O   TYR A  33      31.492  40.863  33.648  1.00  8.32           O  
ATOM    266  CB  TYR A  33      31.722  37.866  33.135  1.00  9.12           C  
ATOM    267  CG  TYR A  33      32.949  37.681  34.007  1.00  8.57           C  
ATOM    268  CD1 TYR A  33      32.938  36.787  35.083  1.00  9.22           C  
ATOM    269  CD2 TYR A  33      34.099  38.443  33.794  1.00  9.10           C  
ATOM    270  CE1 TYR A  33      34.046  36.658  35.933  1.00  9.49           C  
ATOM    271  CE2 TYR A  33      35.210  38.328  34.637  1.00  9.72           C  
ATOM    272  CZ  TYR A  33      35.177  37.434  35.702  1.00  9.43           C  
ATOM    273  OH  TYR A  33      36.274  37.318  36.526  1.00  9.82           O  
ATOM    274  N   VAL A  34      31.362  39.978  35.715  1.00  7.57           N  
ATOM    275  CA  VAL A  34      31.940  41.145  36.369  1.00  7.70           C  
ATOM    276  C   VAL A  34      32.894  40.701  37.471  1.00  8.35           C  
ATOM    277  O   VAL A  34      32.734  39.620  38.049  1.00  8.13           O  
ATOM    278  CB  VAL A  34      30.852  42.066  37.014  1.00  7.64           C  
ATOM    279  CG1 VAL A  34      29.826  42.483  35.966  1.00  8.12           C  
ATOM    280  CG2 VAL A  34      30.172  41.355  38.185  1.00  7.48           C  
ATOM    281  N   ARG A  35      33.897  41.530  37.734  1.00  6.97           N  
ATOM    282  CA  ARG A  35      34.858  41.276  38.802  1.00  8.49           C  
ATOM    283  C   ARG A  35      35.145  42.622  39.449  1.00  8.38           C  
ATOM    284  O   ARG A  35      35.573  43.562  38.777  1.00  8.12           O  
ATOM    285  CB  ARG A  35      36.163  40.661  38.274  1.00  8.24           C  
ATOM    286  CG  ARG A  35      37.147  40.343  39.398  1.00  9.26           C  
ATOM    287  CD  ARG A  35      38.299  39.462  38.939  1.00  8.20           C  
ATOM    288  NE  ARG A  35      39.272  40.153  38.095  1.00  9.20           N  
ATOM    289  CZ  ARG A  35      39.426  39.951  36.789  1.00 10.72           C  
ATOM    290  NH1 ARG A  35      38.659  39.081  36.144  1.00  9.69           N  
ATOM    291  NH2 ARG A  35      40.382  40.597  36.134  1.00 11.02           N  
ATOM    292  N   LEU A  36      34.894  42.709  40.752  1.00  7.26           N  
ATOM    293  CA  LEU A  36      35.095  43.947  41.496  1.00  6.72           C  
ATOM    294  C   LEU A  36      36.124  43.770  42.603  1.00  6.49           C  
ATOM    295  O   LEU A  36      36.379  42.651  43.057  1.00  7.78           O  
ATOM    296  CB  LEU A  36      33.769  44.401  42.121  1.00  7.46           C  
ATOM    297  CG  LEU A  36      32.506  44.345  41.250  1.00  7.61           C  
ATOM    298  CD1 LEU A  36      31.303  44.729  42.108  1.00  8.45           C  
ATOM    299  CD2 LEU A  36      32.637  45.277  40.049  1.00  7.87           C  
ATOM    300  N   ARG A  37      36.701  44.885  43.040  1.00  7.35           N  
ATOM    301  CA  ARG A  37      37.702  44.880  44.102  1.00  7.78           C  
ATOM    302  C   ARG A  37      37.422  45.983  45.121  1.00  7.64           C  
ATOM    303  O   ARG A  37      37.178  47.130  44.752  1.00  7.82           O  
ATOM    304  CB  ARG A  37      39.104  45.092  43.514  1.00  9.11           C  
ATOM    305  CG  ARG A  37      40.222  45.067  44.565  1.00 10.74           C  
ATOM    306  CD  ARG A  37      41.601  45.359  43.965  1.00 11.52           C  
ATOM    307  NE  ARG A  37      41.752  46.763  43.591  1.00 15.35           N  
ATOM    308  CZ  ARG A  37      41.811  47.213  42.342  1.00 15.50           C  
ATOM    309  NH1 ARG A  37      41.735  46.373  41.317  1.00 18.04           N  
ATOM    310  NH2 ARG A  37      41.948  48.512  42.116  1.00 17.45           N  
ATOM    311  N   MET A  38      37.442  45.639  46.402  1.00  7.10           N  
ATOM    312  CA  MET A  38      37.234  46.644  47.440  1.00  7.40           C  
ATOM    313  C   MET A  38      38.582  46.828  48.133  1.00  8.86           C  
ATOM    314  O   MET A  38      39.138  45.880  48.688  1.00  8.09           O  
ATOM    315  CB  MET A  38      36.185  46.195  48.461  1.00  7.50           C  
ATOM    316  CG  MET A  38      35.880  47.245  49.543  1.00  8.36           C  
ATOM    317  SD  MET A  38      35.019  48.734  48.948  1.00  3.33           S  
ATOM    318  CE  MET A  38      33.351  48.100  48.867  1.00  8.01           C  
ATOM    319  N   PRO A  39      39.137  48.050  48.088  1.00 10.87           N  
ATOM    320  CA  PRO A  39      40.431  48.272  48.741  1.00 11.14           C  
ATOM    321  C   PRO A  39      40.342  48.127  50.258  1.00 11.10           C  
ATOM    322  O   PRO A  39      39.335  48.498  50.870  1.00 10.52           O  
ATOM    323  CB  PRO A  39      40.797  49.693  48.305  1.00 12.31           C  
ATOM    324  CG  PRO A  39      39.456  50.358  48.151  1.00 13.34           C  
ATOM    325  CD  PRO A  39      38.638  49.285  47.454  1.00 12.16           C  
ATOM    326  N   GLY A  40      41.392  47.575  50.859  1.00 10.34           N  
ATOM    327  CA  GLY A  40      41.405  47.408  52.298  1.00 10.70           C  
ATOM    328  C   GLY A  40      41.587  48.757  52.957  1.00 12.15           C  
ATOM    329  O   GLY A  40      40.992  49.043  53.997  1.00 11.79           O  
ATOM    330  N   ALA A  41      42.404  49.598  52.334  1.00 12.94           N  
ATOM    331  CA  ALA A  41      42.686  50.925  52.866  1.00 13.39           C  
ATOM    332  C   ALA A  41      41.446  51.813  52.900  1.00 12.46           C  
ATOM    333  O   ALA A  41      40.796  52.025  51.878  1.00 14.43           O  
ATOM    334  CB  ALA A  41      43.788  51.589  52.043  1.00 14.58           C  
ATOM    335  N   GLY A  42      41.131  52.329  54.085  1.00 12.82           N  
ATOM    336  CA  GLY A  42      39.978  53.199  54.247  1.00 13.38           C  
ATOM    337  C   GLY A  42      38.699  52.476  54.630  1.00 14.20           C  
ATOM    338  O   GLY A  42      37.719  53.101  55.040  1.00 14.29           O  
ATOM    339  N   ASN A  43      38.711  51.153  54.508  1.00 12.86           N  
ATOM    340  CA  ASN A  43      37.536  50.346  54.819  1.00 11.56           C  
ATOM    341  C   ASN A  43      37.745  49.427  56.015  1.00 11.97           C  
ATOM    342  O   ASN A  43      37.013  48.456  56.191  1.00 11.70           O  
ATOM    343  CB  ASN A  43      37.151  49.515  53.592  1.00 10.88           C  
ATOM    344  CG  ASN A  43      36.676  50.374  52.440  1.00 11.10           C  
ATOM    345  OD1 ASN A  43      37.158  50.253  51.307  1.00 13.95           O  
ATOM    346  ND2 ASN A  43      35.720  51.249  52.720  1.00  9.07           N  
ATOM    347  N   GLU A  44      38.742  49.742  56.839  1.00 12.65           N  
ATOM    348  CA  GLU A  44      39.053  48.931  58.012  1.00 13.35           C  
ATOM    349  C   GLU A  44      38.072  49.162  59.157  1.00 14.25           C  
ATOM    350  O   GLU A  44      37.522  50.257  59.309  1.00 13.97           O  
ATOM    351  CB  GLU A  44      40.473  49.241  58.515  1.00 15.24           C  
ATOM    352  CG  GLU A  44      41.534  49.337  57.419  1.00 18.24           C  
ATOM    353  CD  GLU A  44      41.769  50.769  56.930  1.00 20.04           C  
ATOM    354  OE1 GLU A  44      40.839  51.606  57.011  1.00 20.58           O  
ATOM    355  OE2 GLU A  44      42.887  51.053  56.447  1.00 22.76           O  
ATOM    356  N   ASN A  45      37.841  48.123  59.956  1.00 13.72           N  
ATOM    357  CA  ASN A  45      36.976  48.262  61.114  1.00 14.55           C  
ATOM    358  C   ASN A  45      37.909  48.679  62.249  1.00 16.75           C  
ATOM    359  O   ASN A  45      39.029  49.119  62.002  1.00 17.41           O  
ATOM    360  CB  ASN A  45      36.260  46.946  61.447  1.00 14.02           C  
ATOM    361  CG  ASN A  45      37.206  45.766  61.544  1.00 16.55           C  
ATOM    362  OD1 ASN A  45      38.389  45.921  61.849  1.00 17.05           O  
ATOM    363  ND2 ASN A  45      36.680  44.569  61.301  1.00 17.16           N  
ATOM    364  N   HIS A  46      37.463  48.543  63.487  1.00 18.46           N  
ATOM    365  CA  HIS A  46      38.289  48.937  64.625  1.00 22.74           C  
ATOM    366  C   HIS A  46      39.272  47.843  65.053  1.00 23.51           C  
ATOM    367  O   HIS A  46      40.197  48.098  65.825  1.00 24.61           O  
ATOM    368  CB  HIS A  46      37.378  49.303  65.803  1.00 24.12           C  
ATOM    369  CG  HIS A  46      36.430  48.210  66.189  1.00 27.25           C  
ATOM    370  ND1 HIS A  46      35.633  47.560  65.269  1.00 28.39           N  
ATOM    371  CD2 HIS A  46      36.170  47.631  67.386  1.00 28.36           C  
ATOM    372  CE1 HIS A  46      34.927  46.625  65.881  1.00 29.64           C  
ATOM    373  NE2 HIS A  46      35.234  46.648  67.167  1.00 29.67           N  
ATOM    374  N   ILE A  47      39.092  46.635  64.525  1.00 23.52           N  
ATOM    375  CA  ILE A  47      39.934  45.512  64.915  1.00 22.52           C  
ATOM    376  C   ILE A  47      40.875  44.895  63.879  1.00 22.09           C  
ATOM    377  O   ILE A  47      41.129  43.690  63.909  1.00 22.21           O  
ATOM    378  CB  ILE A  47      39.062  44.400  65.522  1.00 22.92           C  
ATOM    379  CG1 ILE A  47      37.941  44.028  64.548  1.00 23.79           C  
ATOM    380  CG2 ILE A  47      38.467  44.878  66.832  1.00 22.70           C  
ATOM    381  CD1 ILE A  47      36.963  43.011  65.096  1.00 25.25           C  
ATOM    382  N   GLY A  48      41.382  45.715  62.964  1.00 21.92           N  
ATOM    383  CA  GLY A  48      42.340  45.230  61.982  1.00 21.74           C  
ATOM    384  C   GLY A  48      41.924  44.492  60.720  1.00 21.28           C  
ATOM    385  O   GLY A  48      42.783  43.899  60.068  1.00 22.87           O  
ATOM    386  N   SER A  49      40.641  44.503  60.368  1.00 18.57           N  
ATOM    387  CA  SER A  49      40.190  43.835  59.141  1.00 16.19           C  
ATOM    388  C   SER A  49      39.097  44.666  58.469  1.00 14.94           C  
ATOM    389  O   SER A  49      38.685  45.697  59.003  1.00 15.35           O  
ATOM    390  CB  SER A  49      39.677  42.423  59.440  1.00 15.84           C  
ATOM    391  OG  SER A  49      38.573  42.448  60.316  1.00 17.00           O  
ATOM    392  N   MET A  50      38.630  44.228  57.302  1.00 11.84           N  
ATOM    393  CA  MET A  50      37.613  44.985  56.581  1.00  9.97           C  
ATOM    394  C   MET A  50      36.301  45.050  57.342  1.00  8.70           C  
ATOM    395  O   MET A  50      35.825  44.046  57.871  1.00  9.51           O  
ATOM    396  CB  MET A  50      37.368  44.385  55.183  1.00  8.51           C  
ATOM    397  CG  MET A  50      36.436  45.227  54.284  1.00 10.19           C  
ATOM    398  SD  MET A  50      36.463  44.745  52.526  1.00  2.35           S  
ATOM    399  CE  MET A  50      34.964  44.466  52.197  1.00 19.99           C  
ATOM    400  N   TYR A  51      35.720  46.243  57.388  1.00  8.57           N  
ATOM    401  CA  TYR A  51      34.449  46.440  58.068  1.00  8.52           C  
ATOM    402  C   TYR A  51      33.360  45.639  57.346  1.00  7.84           C  
ATOM    403  O   TYR A  51      33.336  45.581  56.114  1.00  8.96           O  
ATOM    404  CB  TYR A  51      34.086  47.931  58.093  1.00  7.31           C  
ATOM    405  CG  TYR A  51      32.697  48.190  58.635  1.00  8.95           C  
ATOM    406  CD1 TYR A  51      32.316  47.700  59.883  1.00  8.59           C  
ATOM    407  CD2 TYR A  51      31.743  48.862  57.871  1.00  8.33           C  
ATOM    408  CE1 TYR A  51      31.016  47.862  60.358  1.00  8.69           C  
ATOM    409  CE2 TYR A  51      30.440  49.028  58.336  1.00  8.95           C  
ATOM    410  CZ  TYR A  51      30.086  48.520  59.577  1.00  8.91           C  
ATOM    411  OH  TYR A  51      28.794  48.633  60.021  1.00 10.43           O  
ATOM    412  N   ALA A  52      32.468  45.023  58.117  1.00  7.43           N  
ATOM    413  CA  ALA A  52      31.377  44.217  57.563  1.00  7.40           C  
ATOM    414  C   ALA A  52      30.573  44.923  56.473  1.00  7.08           C  
ATOM    415  O   ALA A  52      30.156  44.288  55.505  1.00  7.74           O  
ATOM    416  CB  ALA A  52      30.444  43.771  58.683  1.00  7.66           C  
ATOM    417  N   GLY A  53      30.346  46.224  56.644  1.00  7.16           N  
ATOM    418  CA  GLY A  53      29.587  47.000  55.673  1.00  6.96           C  
ATOM    419  C   GLY A  53      30.280  47.095  54.325  1.00  7.59           C  
ATOM    420  O   GLY A  53      29.620  47.160  53.280  1.00  7.59           O  
ATOM    421  N   ALA A  54      31.611  47.112  54.345  1.00  6.25           N  
ATOM    422  CA  ALA A  54      32.386  47.174  53.112  1.00  6.57           C  
ATOM    423  C   ALA A  54      32.285  45.811  52.423  1.00  7.07           C  
ATOM    424  O   ALA A  54      32.158  45.733  51.196  1.00  7.34           O  
ATOM    425  CB  ALA A  54      33.834  47.515  53.419  1.00  7.35           C  
ATOM    426  N   LEU A  55      32.352  44.734  53.210  1.00  6.79           N  
ATOM    427  CA  LEU A  55      32.230  43.385  52.658  1.00  6.41           C  
ATOM    428  C   LEU A  55      30.851  43.234  52.023  1.00  6.12           C  
ATOM    429  O   LEU A  55      30.718  42.691  50.925  1.00  6.32           O  
ATOM    430  CB  LEU A  55      32.431  42.337  53.758  1.00  6.14           C  
ATOM    431  CG  LEU A  55      33.883  42.149  54.221  1.00  8.96           C  
ATOM    432  CD1 LEU A  55      33.933  41.349  55.518  1.00  9.04           C  
ATOM    433  CD2 LEU A  55      34.671  41.443  53.114  1.00  8.22           C  
ATOM    434  N   PHE A  56      29.825  43.733  52.705  1.00  5.30           N  
ATOM    435  CA  PHE A  56      28.466  43.640  52.170  1.00  5.92           C  
ATOM    436  C   PHE A  56      28.350  44.373  50.839  1.00  5.69           C  
ATOM    437  O   PHE A  56      27.773  43.862  49.881  1.00  6.53           O  
ATOM    438  CB  PHE A  56      27.447  44.241  53.139  1.00  6.27           C  
ATOM    439  CG  PHE A  56      26.034  44.202  52.619  1.00  6.96           C  
ATOM    440  CD1 PHE A  56      25.209  43.105  52.869  1.00  7.84           C  
ATOM    441  CD2 PHE A  56      25.539  45.246  51.841  1.00  7.78           C  
ATOM    442  CE1 PHE A  56      23.904  43.055  52.347  1.00  8.71           C  
ATOM    443  CE2 PHE A  56      24.243  45.204  51.313  1.00  8.72           C  
ATOM    444  CZ  PHE A  56      23.427  44.108  51.568  1.00  8.02           C  
ATOM    445  N   THR A  57      28.892  45.586  50.787  1.00  5.51           N  
ATOM    446  CA  THR A  57      28.822  46.383  49.574  1.00  6.55           C  
ATOM    447  C   THR A  57      29.501  45.663  48.409  1.00  6.38           C  
ATOM    448  O   THR A  57      28.966  45.622  47.299  1.00  7.33           O  
ATOM    449  CB  THR A  57      29.452  47.771  49.806  1.00  6.07           C  
ATOM    450  OG1 THR A  57      28.701  48.457  50.815  1.00  6.90           O  
ATOM    451  CG2 THR A  57      29.424  48.601  48.533  1.00  7.00           C  
ATOM    452  N   LEU A  58      30.667  45.078  48.666  1.00  5.88           N  
ATOM    453  CA  LEU A  58      31.388  44.352  47.625  1.00  6.50           C  
ATOM    454  C   LEU A  58      30.582  43.152  47.128  1.00  6.54           C  
ATOM    455  O   LEU A  58      30.516  42.896  45.929  1.00  6.23           O  
ATOM    456  CB  LEU A  58      32.737  43.860  48.156  1.00  6.56           C  
ATOM    457  CG  LEU A  58      33.543  43.010  47.165  1.00  5.94           C  
ATOM    458  CD1 LEU A  58      33.882  43.849  45.935  1.00  6.13           C  
ATOM    459  CD2 LEU A  58      34.810  42.501  47.832  1.00  6.54           C  
ATOM    460  N   ALA A  59      29.974  42.423  48.062  1.00  6.69           N  
ATOM    461  CA  ALA A  59      29.191  41.235  47.725  1.00  5.56           C  
ATOM    462  C   ALA A  59      27.854  41.547  47.059  1.00  7.12           C  
ATOM    463  O   ALA A  59      27.363  40.767  46.246  1.00  8.08           O  
ATOM    464  CB  ALA A  59      28.953  40.404  48.982  1.00  6.29           C  
ATOM    465  N   GLU A  60      27.275  42.695  47.398  1.00  6.64           N  
ATOM    466  CA  GLU A  60      25.972  43.100  46.873  1.00  7.63           C  
ATOM    467  C   GLU A  60      25.992  43.753  45.483  1.00  7.60           C  
ATOM    468  O   GLU A  60      25.106  43.503  44.655  1.00  7.44           O  
ATOM    469  CB  GLU A  60      25.314  44.061  47.880  1.00  7.36           C  
ATOM    470  CG  GLU A  60      23.842  44.412  47.638  1.00  8.66           C  
ATOM    471  CD  GLU A  60      23.599  45.388  46.487  1.00 11.47           C  
ATOM    472  OE1 GLU A  60      24.444  46.278  46.236  1.00 10.25           O  
ATOM    473  OE2 GLU A  60      22.531  45.274  45.844  1.00 12.78           O  
ATOM    474  N   LEU A  61      27.002  44.583  45.233  1.00  6.70           N  
ATOM    475  CA  LEU A  61      27.090  45.323  43.978  1.00  7.57           C  
ATOM    476  C   LEU A  61      27.096  44.512  42.679  1.00  6.94           C  
ATOM    477  O   LEU A  61      26.641  45.007  41.647  1.00  8.15           O  
ATOM    478  CB  LEU A  61      28.296  46.269  44.010  1.00  7.98           C  
ATOM    479  CG  LEU A  61      28.120  47.502  43.121  1.00 10.31           C  
ATOM    480  CD1 LEU A  61      26.992  48.360  43.669  1.00 11.98           C  
ATOM    481  CD2 LEU A  61      29.413  48.300  43.083  1.00 12.17           C  
ATOM    482  N   PRO A  62      27.618  43.268  42.699  1.00  7.24           N  
ATOM    483  CA  PRO A  62      27.610  42.501  41.446  1.00  6.97           C  
ATOM    484  C   PRO A  62      26.224  42.394  40.809  1.00  7.06           C  
ATOM    485  O   PRO A  62      26.106  42.259  39.593  1.00  7.88           O  
ATOM    486  CB  PRO A  62      28.168  41.147  41.872  1.00  6.90           C  
ATOM    487  CG  PRO A  62      29.194  41.545  42.893  1.00  6.50           C  
ATOM    488  CD  PRO A  62      28.442  42.589  43.718  1.00  5.78           C  
ATOM    489  N   GLY A  63      25.175  42.449  41.627  1.00  7.90           N  
ATOM    490  CA  GLY A  63      23.824  42.377  41.092  1.00  7.52           C  
ATOM    491  C   GLY A  63      23.556  43.563  40.182  1.00  7.72           C  
ATOM    492  O   GLY A  63      22.979  43.420  39.105  1.00  8.72           O  
ATOM    493  N   GLY A  64      23.980  44.742  40.624  1.00  7.77           N  
ATOM    494  CA  GLY A  64      23.800  45.936  39.823  1.00  7.46           C  
ATOM    495  C   GLY A  64      24.807  46.019  38.683  1.00  7.40           C  
ATOM    496  O   GLY A  64      24.476  46.489  37.594  1.00  7.80           O  
ATOM    497  N   ALA A  65      26.039  45.574  38.921  1.00  6.38           N  
ATOM    498  CA  ALA A  65      27.065  45.618  37.878  1.00  6.29           C  
ATOM    499  C   ALA A  65      26.685  44.711  36.705  1.00  7.04           C  
ATOM    500  O   ALA A  65      26.820  45.107  35.548  1.00  6.67           O  
ATOM    501  CB  ALA A  65      28.430  45.215  38.448  1.00  6.69           C  
ATOM    502  N   LEU A  66      26.218  43.497  36.998  1.00  7.34           N  
ATOM    503  CA  LEU A  66      25.797  42.569  35.940  1.00  8.04           C  
ATOM    504  C   LEU A  66      24.617  43.172  35.168  1.00  8.38           C  
ATOM    505  O   LEU A  66      24.499  43.003  33.957  1.00  8.27           O  
ATOM    506  CB  LEU A  66      25.397  41.214  36.533  1.00  7.13           C  
ATOM    507  CG  LEU A  66      26.556  40.258  36.826  1.00  8.09           C  
ATOM    508  CD1 LEU A  66      26.078  39.109  37.712  1.00  8.03           C  
ATOM    509  CD2 LEU A  66      27.121  39.731  35.509  1.00  6.80           C  
ATOM    510  N   PHE A  67      23.743  43.877  35.881  1.00  8.54           N  
ATOM    511  CA  PHE A  67      22.599  44.538  35.254  1.00  9.02           C  
ATOM    512  C   PHE A  67      23.112  45.574  34.241  1.00  9.15           C  
ATOM    513  O   PHE A  67      22.628  45.651  33.111  1.00  9.44           O  
ATOM    514  CB  PHE A  67      21.748  45.231  36.330  1.00  9.51           C  
ATOM    515  CG  PHE A  67      20.969  46.420  35.826  1.00 10.86           C  
ATOM    516  CD1 PHE A  67      19.786  46.250  35.111  1.00 10.69           C  
ATOM    517  CD2 PHE A  67      21.433  47.711  36.054  1.00  9.66           C  
ATOM    518  CE1 PHE A  67      19.078  47.352  34.632  1.00 10.81           C  
ATOM    519  CE2 PHE A  67      20.731  48.819  35.579  1.00 11.29           C  
ATOM    520  CZ  PHE A  67      19.551  48.637  34.867  1.00 10.00           C  
ATOM    521  N   LEU A  68      24.092  46.371  34.658  1.00  7.94           N  
ATOM    522  CA  LEU A  68      24.669  47.395  33.789  1.00  8.22           C  
ATOM    523  C   LEU A  68      25.366  46.819  32.556  1.00  8.64           C  
ATOM    524  O   LEU A  68      25.348  47.429  31.485  1.00  9.02           O  
ATOM    525  CB  LEU A  68      25.670  48.256  34.566  1.00  7.99           C  
ATOM    526  CG  LEU A  68      25.094  49.265  35.561  1.00 10.02           C  
ATOM    527  CD1 LEU A  68      26.221  49.878  36.373  1.00  8.99           C  
ATOM    528  CD2 LEU A  68      24.320  50.348  34.812  1.00  9.18           C  
ATOM    529  N   THR A  69      25.988  45.653  32.695  1.00  7.98           N  
ATOM    530  CA  THR A  69      26.686  45.068  31.555  1.00  8.39           C  
ATOM    531  C   THR A  69      25.849  44.106  30.723  1.00  8.75           C  
ATOM    532  O   THR A  69      26.214  43.793  29.587  1.00 10.01           O  
ATOM    533  CB  THR A  69      27.941  44.281  31.994  1.00  8.32           C  
ATOM    534  OG1 THR A  69      27.544  43.100  32.707  1.00  8.88           O  
ATOM    535  CG2 THR A  69      28.840  45.139  32.867  1.00  8.36           C  
ATOM    536  N   SER A  70      24.721  43.659  31.264  1.00  8.54           N  
ATOM    537  CA  SER A  70      23.924  42.658  30.569  1.00  8.94           C  
ATOM    538  C   SER A  70      22.528  43.023  30.081  1.00 10.20           C  
ATOM    539  O   SER A  70      21.999  42.358  29.187  1.00 10.75           O  
ATOM    540  CB  SER A  70      23.823  41.413  31.455  1.00  9.42           C  
ATOM    541  OG  SER A  70      25.086  41.097  32.012  1.00  8.84           O  
ATOM    542  N   PHE A  71      21.930  44.056  30.660  1.00  9.32           N  
ATOM    543  CA  PHE A  71      20.578  44.438  30.271  1.00  9.87           C  
ATOM    544  C   PHE A  71      20.461  45.883  29.808  1.00  9.98           C  
ATOM    545  O   PHE A  71      21.385  46.676  29.978  1.00  9.92           O  
ATOM    546  CB  PHE A  71      19.626  44.217  31.449  1.00  9.93           C  
ATOM    547  CG  PHE A  71      19.603  42.804  31.951  1.00 10.88           C  
ATOM    548  CD1 PHE A  71      19.044  41.786  31.180  1.00 12.95           C  
ATOM    549  CD2 PHE A  71      20.159  42.483  33.186  1.00 11.86           C  
ATOM    550  CE1 PHE A  71      19.038  40.463  31.634  1.00 12.52           C  
ATOM    551  CE2 PHE A  71      20.159  41.169  33.647  1.00 12.61           C  
ATOM    552  CZ  PHE A  71      19.595  40.156  32.864  1.00 11.97           C  
ATOM    553  N   ASP A  72      19.315  46.196  29.199  1.00  9.32           N  
ATOM    554  CA  ASP A  72      19.005  47.551  28.747  1.00  9.42           C  
ATOM    555  C   ASP A  72      18.809  48.273  30.074  1.00  9.31           C  
ATOM    556  O   ASP A  72      17.773  48.111  30.721  1.00 10.04           O  
ATOM    557  CB  ASP A  72      17.694  47.544  27.960  1.00 10.09           C  
ATOM    558  CG  ASP A  72      17.302  48.922  27.461  1.00 10.31           C  
ATOM    559  OD1 ASP A  72      17.494  49.903  28.212  1.00  9.00           O  
ATOM    560  OD2 ASP A  72      16.787  49.012  26.323  1.00 11.16           O  
ATOM    561  N   SER A  73      19.802  49.064  30.475  1.00 10.93           N  
ATOM    562  CA  SER A  73      19.764  49.749  31.764  1.00 11.70           C  
ATOM    563  C   SER A  73      18.912  51.005  31.876  1.00 12.12           C  
ATOM    564  O   SER A  73      18.963  51.704  32.884  1.00 12.64           O  
ATOM    565  CB  SER A  73      21.195  50.033  32.236  1.00 12.42           C  
ATOM    566  OG  SER A  73      21.965  50.613  31.204  1.00 12.88           O  
ATOM    567  N   ALA A  74      18.132  51.293  30.842  1.00 11.29           N  
ATOM    568  CA  ALA A  74      17.235  52.437  30.872  1.00 10.44           C  
ATOM    569  C   ALA A  74      15.821  51.859  30.921  1.00 11.31           C  
ATOM    570  O   ALA A  74      14.944  52.387  31.602  1.00 10.83           O  
ATOM    571  CB  ALA A  74      17.419  53.292  29.624  1.00 11.94           C  
ATOM    572  N   ARG A  75      15.617  50.750  30.210  1.00 10.94           N  
ATOM    573  CA  ARG A  75      14.317  50.084  30.171  1.00 11.32           C  
ATOM    574  C   ARG A  75      13.996  49.383  31.495  1.00 11.28           C  
ATOM    575  O   ARG A  75      12.843  49.353  31.935  1.00 11.77           O  
ATOM    576  CB  ARG A  75      14.294  49.055  29.040  1.00 11.62           C  
ATOM    577  CG  ARG A  75      12.971  48.321  28.923  1.00 13.76           C  
ATOM    578  CD  ARG A  75      13.023  47.208  27.890  1.00 15.97           C  
ATOM    579  NE  ARG A  75      11.727  46.540  27.759  1.00 17.12           N  
ATOM    580  CZ  ARG A  75      11.541  45.373  27.146  1.00 19.48           C  
ATOM    581  NH1 ARG A  75      12.570  44.732  26.601  1.00 21.25           N  
ATOM    582  NH2 ARG A  75      10.325  44.843  27.080  1.00 20.12           N  
ATOM    583  N   PHE A  76      15.030  48.826  32.122  1.00 10.47           N  
ATOM    584  CA  PHE A  76      14.892  48.104  33.386  1.00  9.42           C  
ATOM    585  C   PHE A  76      15.770  48.708  34.472  1.00 10.11           C  
ATOM    586  O   PHE A  76      16.632  49.541  34.210  1.00  9.73           O  
ATOM    587  CB  PHE A  76      15.336  46.643  33.220  1.00  9.76           C  
ATOM    588  CG  PHE A  76      14.603  45.891  32.151  1.00 10.45           C  
ATOM    589  CD1 PHE A  76      13.255  45.571  32.302  1.00 11.14           C  
ATOM    590  CD2 PHE A  76      15.266  45.487  30.997  1.00 12.18           C  
ATOM    591  CE1 PHE A  76      12.581  44.859  31.320  1.00 12.84           C  
ATOM    592  CE2 PHE A  76      14.597  44.771  30.003  1.00 14.17           C  
ATOM    593  CZ  PHE A  76      13.255  44.457  30.167  1.00 14.54           C  
ATOM    594  N   TYR A  77      15.539  48.266  35.703  1.00  9.86           N  
ATOM    595  CA  TYR A  77      16.355  48.682  36.833  1.00  9.21           C  
ATOM    596  C   TYR A  77      16.360  47.492  37.774  1.00  9.99           C  
ATOM    597  O   TYR A  77      15.405  46.709  37.805  1.00  9.95           O  
ATOM    598  CB  TYR A  77      15.792  49.931  37.520  1.00  9.78           C  
ATOM    599  CG  TYR A  77      14.469  49.742  38.215  1.00 10.61           C  
ATOM    600  CD1 TYR A  77      14.407  49.400  39.566  1.00 10.53           C  
ATOM    601  CD2 TYR A  77      13.274  49.938  37.528  1.00 11.11           C  
ATOM    602  CE1 TYR A  77      13.180  49.266  40.216  1.00 11.10           C  
ATOM    603  CE2 TYR A  77      12.049  49.806  38.162  1.00 12.14           C  
ATOM    604  CZ  TYR A  77      12.006  49.472  39.506  1.00 12.60           C  
ATOM    605  OH  TYR A  77      10.782  49.359  40.129  1.00 13.42           O  
ATOM    606  N   PRO A  78      17.458  47.308  38.516  1.00  9.38           N  
ATOM    607  CA  PRO A  78      17.534  46.183  39.446  1.00  8.99           C  
ATOM    608  C   PRO A  78      17.279  46.613  40.886  1.00  9.36           C  
ATOM    609  O   PRO A  78      17.464  47.775  41.240  1.00  9.75           O  
ATOM    610  CB  PRO A  78      18.962  45.701  39.257  1.00  8.65           C  
ATOM    611  CG  PRO A  78      19.718  47.017  39.135  1.00  7.89           C  
ATOM    612  CD  PRO A  78      18.800  47.876  38.260  1.00  9.32           C  
ATOM    613  N   ILE A  79      16.830  45.672  41.706  1.00  8.81           N  
ATOM    614  CA  ILE A  79      16.643  45.929  43.127  1.00  9.46           C  
ATOM    615  C   ILE A  79      17.037  44.643  43.832  1.00  9.20           C  
ATOM    616  O   ILE A  79      16.860  43.548  43.290  1.00 10.61           O  
ATOM    617  CB  ILE A  79      15.182  46.263  43.523  1.00 12.04           C  
ATOM    618  CG1 ILE A  79      14.243  45.152  43.065  1.00 14.39           C  
ATOM    619  CG2 ILE A  79      14.780  47.606  42.963  1.00 15.55           C  
ATOM    620  CD1 ILE A  79      12.836  45.311  43.595  1.00 19.65           C  
ATOM    621  N   VAL A  80      17.601  44.768  45.023  1.00  8.03           N  
ATOM    622  CA  VAL A  80      17.964  43.585  45.777  1.00  8.39           C  
ATOM    623  C   VAL A  80      16.790  43.320  46.724  1.00  8.31           C  
ATOM    624  O   VAL A  80      16.292  44.244  47.371  1.00  9.28           O  
ATOM    625  CB  VAL A  80      19.302  43.789  46.547  1.00  7.73           C  
ATOM    626  CG1 VAL A  80      19.227  45.013  47.448  1.00  8.28           C  
ATOM    627  CG2 VAL A  80      19.633  42.535  47.343  1.00  8.23           C  
ATOM    628  N   LYS A  81      16.325  42.072  46.773  1.00  7.26           N  
ATOM    629  CA  LYS A  81      15.189  41.709  47.621  1.00  8.33           C  
ATOM    630  C   LYS A  81      15.618  41.196  48.991  1.00  8.63           C  
ATOM    631  O   LYS A  81      15.047  41.571  50.013  1.00  8.69           O  
ATOM    632  CB  LYS A  81      14.332  40.642  46.934  1.00 10.89           C  
ATOM    633  CG  LYS A  81      13.755  41.054  45.585  1.00 14.89           C  
ATOM    634  CD  LYS A  81      13.010  42.377  45.664  1.00 19.50           C  
ATOM    635  CE  LYS A  81      11.844  42.316  46.642  1.00 22.84           C  
ATOM    636  NZ  LYS A  81      11.127  43.625  46.726  1.00 26.80           N  
ATOM    637  N   GLU A  82      16.595  40.295  49.000  1.00  8.40           N  
ATOM    638  CA  GLU A  82      17.122  39.759  50.248  1.00  8.95           C  
ATOM    639  C   GLU A  82      18.514  39.222  50.023  1.00  7.97           C  
ATOM    640  O   GLU A  82      18.882  38.867  48.903  1.00  8.31           O  
ATOM    641  CB  GLU A  82      16.203  38.692  50.851  1.00 11.22           C  
ATOM    642  CG  GLU A  82      15.498  37.788  49.881  1.00 13.95           C  
ATOM    643  CD  GLU A  82      14.417  36.952  50.566  1.00 15.28           C  
ATOM    644  OE1 GLU A  82      13.423  37.530  51.067  1.00 17.46           O  
ATOM    645  OE2 GLU A  82      14.563  35.716  50.609  1.00 14.41           O  
ATOM    646  N   MET A  83      19.300  39.185  51.089  1.00  6.74           N  
ATOM    647  CA  MET A  83      20.674  38.741  50.973  1.00  7.07           C  
ATOM    648  C   MET A  83      21.219  38.260  52.304  1.00  7.83           C  
ATOM    649  O   MET A  83      20.938  38.844  53.354  1.00  7.74           O  
ATOM    650  CB  MET A  83      21.532  39.896  50.444  1.00  7.08           C  
ATOM    651  CG  MET A  83      23.010  39.581  50.233  1.00  9.54           C  
ATOM    652  SD  MET A  83      23.900  40.938  49.383  1.00  6.22           S  
ATOM    653  CE  MET A  83      22.888  41.267  48.092  1.00 17.43           C  
ATOM    654  N   THR A  84      21.986  37.179  52.237  1.00  7.39           N  
ATOM    655  CA  THR A  84      22.631  36.598  53.398  1.00  6.90           C  
ATOM    656  C   THR A  84      24.127  36.714  53.153  1.00  7.64           C  
ATOM    657  O   THR A  84      24.600  36.406  52.056  1.00  7.62           O  
ATOM    658  CB  THR A  84      22.263  35.109  53.554  1.00  8.71           C  
ATOM    659  OG1 THR A  84      20.868  34.996  53.858  1.00  8.60           O  
ATOM    660  CG2 THR A  84      23.087  34.462  54.671  1.00  8.50           C  
ATOM    661  N   LEU A  85      24.860  37.180  54.162  1.00  7.04           N  
ATOM    662  CA  LEU A  85      26.315  37.326  54.068  1.00  6.75           C  
ATOM    663  C   LEU A  85      26.931  36.543  55.223  1.00  6.48           C  
ATOM    664  O   LEU A  85      26.652  36.833  56.384  1.00  7.11           O  
ATOM    665  CB  LEU A  85      26.720  38.801  54.166  1.00  6.96           C  
ATOM    666  CG  LEU A  85      28.221  39.112  54.074  1.00  6.95           C  
ATOM    667  CD1 LEU A  85      28.782  38.624  52.736  1.00  6.84           C  
ATOM    668  CD2 LEU A  85      28.448  40.612  54.228  1.00  7.56           C  
ATOM    669  N   ARG A  86      27.747  35.543  54.905  1.00  6.73           N  
ATOM    670  CA  ARG A  86      28.379  34.712  55.927  1.00  6.55           C  
ATOM    671  C   ARG A  86      29.858  35.065  56.037  1.00  6.92           C  
ATOM    672  O   ARG A  86      30.588  35.045  55.048  1.00  8.39           O  
ATOM    673  CB  ARG A  86      28.215  33.228  55.570  1.00  7.26           C  
ATOM    674  CG  ARG A  86      26.775  32.813  55.257  1.00  9.28           C  
ATOM    675  CD  ARG A  86      26.688  31.337  54.870  1.00 11.81           C  
ATOM    676  NE  ARG A  86      25.493  31.041  54.076  1.00 14.39           N  
ATOM    677  CZ  ARG A  86      24.268  30.874  54.570  1.00 15.54           C  
ATOM    678  NH1 ARG A  86      24.045  30.961  55.874  1.00 14.94           N  
ATOM    679  NH2 ARG A  86      23.254  30.631  53.746  1.00 17.25           N  
ATOM    680  N   PHE A  87      30.298  35.392  57.246  1.00  7.29           N  
ATOM    681  CA  PHE A  87      31.683  35.778  57.482  1.00  7.99           C  
ATOM    682  C   PHE A  87      32.510  34.555  57.861  1.00  8.40           C  
ATOM    683  O   PHE A  87      32.205  33.865  58.839  1.00  9.25           O  
ATOM    684  CB  PHE A  87      31.717  36.839  58.586  1.00  8.46           C  
ATOM    685  CG  PHE A  87      30.858  38.043  58.284  1.00  8.25           C  
ATOM    686  CD1 PHE A  87      31.302  39.030  57.403  1.00  8.38           C  
ATOM    687  CD2 PHE A  87      29.588  38.172  58.848  1.00  8.49           C  
ATOM    688  CE1 PHE A  87      30.490  40.129  57.088  1.00  9.37           C  
ATOM    689  CE2 PHE A  87      28.766  39.268  58.538  1.00  8.77           C  
ATOM    690  CZ  PHE A  87      29.222  40.248  57.655  1.00  8.89           C  
ATOM    691  N   ARG A  88      33.557  34.292  57.080  1.00  8.38           N  
ATOM    692  CA  ARG A  88      34.410  33.128  57.298  1.00  8.99           C  
ATOM    693  C   ARG A  88      35.703  33.410  58.051  1.00 11.07           C  
ATOM    694  O   ARG A  88      36.110  32.624  58.911  1.00 11.47           O  
ATOM    695  CB  ARG A  88      34.745  32.477  55.958  1.00  8.55           C  
ATOM    696  CG  ARG A  88      33.527  32.128  55.115  1.00  8.52           C  
ATOM    697  CD  ARG A  88      32.473  31.357  55.909  1.00  9.30           C  
ATOM    698  NE  ARG A  88      31.534  30.699  55.005  1.00  8.88           N  
ATOM    699  CZ  ARG A  88      30.412  30.100  55.386  1.00  9.65           C  
ATOM    700  NH1 ARG A  88      30.064  30.074  56.668  1.00  9.46           N  
ATOM    701  NH2 ARG A  88      29.651  29.502  54.481  1.00  8.19           N  
ATOM    702  N   ARG A  89      36.362  34.515  57.716  1.00 11.14           N  
ATOM    703  CA  ARG A  89      37.608  34.883  58.384  1.00 13.72           C  
ATOM    704  C   ARG A  89      37.919  36.364  58.205  1.00 12.59           C  
ATOM    705  O   ARG A  89      37.439  36.996  57.264  1.00 11.53           O  
ATOM    706  CB  ARG A  89      38.761  34.026  57.853  1.00 16.66           C  
ATOM    707  CG  ARG A  89      38.835  33.927  56.347  1.00 21.58           C  
ATOM    708  CD  ARG A  89      39.616  32.690  55.930  1.00 25.80           C  
ATOM    709  NE  ARG A  89      41.046  32.828  56.178  1.00 29.94           N  
ATOM    710  CZ  ARG A  89      41.887  31.803  56.293  1.00 32.24           C  
ATOM    711  NH1 ARG A  89      41.435  30.558  56.189  1.00 32.15           N  
ATOM    712  NH2 ARG A  89      43.179  32.023  56.503  1.00 32.03           N  
ATOM    713  N   PRO A  90      38.712  36.945  59.120  1.00 13.12           N  
ATOM    714  CA  PRO A  90      39.056  38.366  59.008  1.00 13.42           C  
ATOM    715  C   PRO A  90      39.550  38.685  57.600  1.00 11.78           C  
ATOM    716  O   PRO A  90      40.423  37.998  57.074  1.00 13.82           O  
ATOM    717  CB  PRO A  90      40.148  38.535  60.063  1.00 14.90           C  
ATOM    718  CG  PRO A  90      39.731  37.553  61.123  1.00 14.54           C  
ATOM    719  CD  PRO A  90      39.361  36.335  60.296  1.00 13.94           C  
ATOM    720  N   ALA A  91      38.982  39.719  56.989  1.00 11.54           N  
ATOM    721  CA  ALA A  91      39.361  40.111  55.634  1.00 10.79           C  
ATOM    722  C   ALA A  91      40.461  41.162  55.668  1.00 10.71           C  
ATOM    723  O   ALA A  91      40.211  42.324  55.991  1.00 11.04           O  
ATOM    724  CB  ALA A  91      38.139  40.645  54.887  1.00 10.19           C  
ATOM    725  N   LYS A  92      41.681  40.743  55.341  1.00 11.04           N  
ATOM    726  CA  LYS A  92      42.824  41.647  55.341  1.00 12.13           C  
ATOM    727  C   LYS A  92      43.267  41.975  53.923  1.00 10.95           C  
ATOM    728  O   LYS A  92      43.248  41.116  53.043  1.00 11.19           O  
ATOM    729  CB  LYS A  92      43.983  41.024  56.128  1.00 14.63           C  
ATOM    730  CG  LYS A  92      43.653  40.801  57.600  1.00 19.35           C  
ATOM    731  CD  LYS A  92      44.826  40.215  58.362  1.00 23.48           C  
ATOM    732  CE  LYS A  92      44.451  39.928  59.809  1.00 26.40           C  
ATOM    733  NZ  LYS A  92      44.055  41.162  60.537  1.00 29.10           N  
ATOM    734  N   GLY A  93      43.656  43.230  53.707  1.00 10.29           N  
ATOM    735  CA  GLY A  93      44.096  43.647  52.393  1.00  8.97           C  
ATOM    736  C   GLY A  93      42.921  43.884  51.467  1.00 10.10           C  
ATOM    737  O   GLY A  93      41.786  44.054  51.923  1.00  9.44           O  
ATOM    738  N   ASP A  94      43.191  43.904  50.165  1.00  9.74           N  
ATOM    739  CA  ASP A  94      42.145  44.114  49.173  1.00  9.82           C  
ATOM    740  C   ASP A  94      41.340  42.831  48.995  1.00  9.27           C  
ATOM    741  O   ASP A  94      41.894  41.726  48.978  1.00  8.93           O  
ATOM    742  CB  ASP A  94      42.750  44.530  47.833  1.00  9.42           C  
ATOM    743  CG  ASP A  94      43.416  45.891  47.884  1.00 10.72           C  
ATOM    744  OD1 ASP A  94      43.297  46.580  48.914  1.00 10.85           O  
ATOM    745  OD2 ASP A  94      44.054  46.274  46.880  1.00 13.97           O  
ATOM    746  N   ILE A  95      40.028  42.988  48.848  1.00  8.34           N  
ATOM    747  CA  ILE A  95      39.126  41.856  48.693  1.00  7.10           C  
ATOM    748  C   ILE A  95      38.424  41.945  47.343  1.00  8.20           C  
ATOM    749  O   ILE A  95      38.075  43.038  46.894  1.00  7.41           O  
ATOM    750  CB  ILE A  95      38.079  41.856  49.836  1.00  7.34           C  
ATOM    751  CG1 ILE A  95      38.791  41.922  51.195  1.00  7.90           C  
ATOM    752  CG2 ILE A  95      37.207  40.620  49.759  1.00  7.42           C  
ATOM    753  CD1 ILE A  95      39.741  40.758  51.472  1.00  8.07           C  
ATOM    754  N   ARG A  96      38.214  40.797  46.699  1.00  7.46           N  
ATOM    755  CA  ARG A  96      37.563  40.771  45.394  1.00  6.93           C  
ATOM    756  C   ARG A  96      36.400  39.802  45.331  1.00  6.56           C  
ATOM    757  O   ARG A  96      36.233  38.931  46.189  1.00  7.07           O  
ATOM    758  CB  ARG A  96      38.558  40.375  44.286  1.00  7.74           C  
ATOM    759  CG  ARG A  96      39.749  41.296  44.110  1.00  7.62           C  
ATOM    760  CD  ARG A  96      40.495  40.957  42.816  1.00  9.75           C  
ATOM    761  NE  ARG A  96      41.054  39.602  42.827  1.00 10.22           N  
ATOM    762  CZ  ARG A  96      41.643  39.026  41.778  1.00 10.72           C  
ATOM    763  NH1 ARG A  96      41.749  39.681  40.627  1.00 10.26           N  
ATOM    764  NH2 ARG A  96      42.135  37.794  41.879  1.00 11.40           N  
ATOM    765  N   VAL A  97      35.610  39.958  44.278  1.00  6.66           N  
ATOM    766  CA  VAL A  97      34.472  39.097  44.029  1.00  6.66           C  
ATOM    767  C   VAL A  97      34.217  39.079  42.527  1.00  7.68           C  
ATOM    768  O   VAL A  97      34.486  40.060  41.827  1.00  7.73           O  
ATOM    769  CB  VAL A  97      33.192  39.616  44.737  1.00  6.05           C  
ATOM    770  CG1 VAL A  97      32.755  40.947  44.130  1.00  5.76           C  
ATOM    771  CG2 VAL A  97      32.068  38.585  44.617  1.00  7.92           C  
ATOM    772  N   GLU A  98      33.738  37.949  42.026  1.00  7.57           N  
ATOM    773  CA  GLU A  98      33.374  37.860  40.623  1.00  8.95           C  
ATOM    774  C   GLU A  98      32.012  37.185  40.569  1.00  8.86           C  
ATOM    775  O   GLU A  98      31.644  36.425  41.465  1.00  7.88           O  
ATOM    776  CB  GLU A  98      34.439  37.125  39.788  1.00 13.08           C  
ATOM    777  CG  GLU A  98      34.804  35.718  40.180  1.00 17.13           C  
ATOM    778  CD  GLU A  98      36.090  35.253  39.479  1.00 20.81           C  
ATOM    779  OE1 GLU A  98      36.179  35.363  38.240  1.00 17.47           O  
ATOM    780  OE2 GLU A  98      37.018  34.778  40.170  1.00 24.28           O  
ATOM    781  N   ALA A  99      31.240  37.512  39.544  1.00  9.31           N  
ATOM    782  CA  ALA A  99      29.903  36.960  39.400  1.00  9.56           C  
ATOM    783  C   ALA A  99      29.573  36.849  37.925  1.00  9.57           C  
ATOM    784  O   ALA A  99      30.078  37.620  37.115  1.00  9.44           O  
ATOM    785  CB  ALA A  99      28.891  37.866  40.093  1.00  9.07           C  
ATOM    786  N   ARG A 100      28.721  35.894  37.579  1.00  9.96           N  
ATOM    787  CA  ARG A 100      28.354  35.719  36.187  1.00 11.57           C  
ATOM    788  C   ARG A 100      26.897  35.315  35.978  1.00 11.74           C  
ATOM    789  O   ARG A 100      26.222  34.855  36.899  1.00 11.65           O  
ATOM    790  CB  ARG A 100      29.284  34.685  35.534  1.00 14.83           C  
ATOM    791  CG  ARG A 100      29.241  33.299  36.161  1.00 18.41           C  
ATOM    792  CD  ARG A 100      30.316  32.378  35.556  1.00 22.10           C  
ATOM    793  NE  ARG A 100      31.673  32.751  35.959  1.00 24.50           N  
ATOM    794  CZ  ARG A 100      32.787  32.245  35.427  1.00 26.07           C  
ATOM    795  NH1 ARG A 100      32.714  31.340  34.458  1.00 26.52           N  
ATOM    796  NH2 ARG A 100      33.978  32.641  35.867  1.00 25.74           N  
ATOM    797  N   LEU A 101      26.427  35.540  34.754  1.00 12.38           N  
ATOM    798  CA  LEU A 101      25.079  35.185  34.306  1.00 15.39           C  
ATOM    799  C   LEU A 101      25.299  34.632  32.903  1.00 16.00           C  
ATOM    800  O   LEU A 101      25.874  35.320  32.061  1.00 15.63           O  
ATOM    801  CB  LEU A 101      24.174  36.417  34.203  1.00 15.48           C  
ATOM    802  CG  LEU A 101      23.514  36.994  35.447  1.00 18.12           C  
ATOM    803  CD1 LEU A 101      22.705  38.231  35.058  1.00 17.32           C  
ATOM    804  CD2 LEU A 101      22.616  35.942  36.079  1.00 17.94           C  
ATOM    805  N   ASP A 102      24.865  33.404  32.638  1.00 18.44           N  
ATOM    806  CA  ASP A 102      25.078  32.854  31.300  1.00 22.08           C  
ATOM    807  C   ASP A 102      24.174  33.540  30.271  1.00 21.20           C  
ATOM    808  O   ASP A 102      23.143  34.127  30.620  1.00 19.59           O  
ATOM    809  CB  ASP A 102      24.854  31.337  31.280  1.00 26.73           C  
ATOM    810  CG  ASP A 102      23.405  30.959  31.468  1.00 31.95           C  
ATOM    811  OD1 ASP A 102      22.889  31.124  32.594  1.00 36.91           O  
ATOM    812  OD2 ASP A 102      22.780  30.499  30.489  1.00 36.43           O  
ATOM    813  N   ALA A 103      24.577  33.466  29.004  1.00 20.86           N  
ATOM    814  CA  ALA A 103      23.841  34.088  27.909  1.00 21.09           C  
ATOM    815  C   ALA A 103      22.364  33.717  27.885  1.00 21.75           C  
ATOM    816  O   ALA A 103      21.499  34.571  27.666  1.00 21.15           O  
ATOM    817  CB  ALA A 103      24.487  33.720  26.581  1.00 20.88           C  
ATOM    818  N   GLU A 104      22.083  32.438  28.104  1.00 21.83           N  
ATOM    819  CA  GLU A 104      20.715  31.942  28.104  1.00 22.71           C  
ATOM    820  C   GLU A 104      19.888  32.554  29.236  1.00 20.13           C  
ATOM    821  O   GLU A 104      18.732  32.926  29.025  1.00 19.15           O  
ATOM    822  CB  GLU A 104      20.721  30.414  28.214  1.00 26.87           C  
ATOM    823  CG  GLU A 104      19.354  29.758  28.087  1.00 34.70           C  
ATOM    824  CD  GLU A 104      19.431  28.240  28.208  1.00 39.40           C  
ATOM    825  OE1 GLU A 104      20.108  27.604  27.367  1.00 41.08           O  
ATOM    826  OE2 GLU A 104      18.816  27.684  29.148  1.00 41.83           O  
ATOM    827  N   ARG A 105      20.469  32.655  30.432  1.00 17.77           N  
ATOM    828  CA  ARG A 105      19.756  33.241  31.569  1.00 16.60           C  
ATOM    829  C   ARG A 105      19.450  34.711  31.308  1.00 14.46           C  
ATOM    830  O   ARG A 105      18.388  35.208  31.679  1.00 13.85           O  
ATOM    831  CB  ARG A 105      20.569  33.115  32.866  1.00 18.18           C  
ATOM    832  CG  ARG A 105      20.280  31.846  33.665  1.00 21.78           C  
ATOM    833  CD  ARG A 105      18.808  31.752  34.028  1.00 22.41           C  
ATOM    834  NE  ARG A 105      18.472  32.391  35.301  1.00 22.33           N  
ATOM    835  CZ  ARG A 105      17.265  32.871  35.592  1.00 22.09           C  
ATOM    836  NH1 ARG A 105      16.289  32.794  34.695  1.00 22.80           N  
ATOM    837  NH2 ARG A 105      17.023  33.405  36.783  1.00 21.70           N  
ATOM    838  N   ILE A 106      20.384  35.405  30.672  1.00 14.67           N  
ATOM    839  CA  ILE A 106      20.180  36.816  30.359  1.00 14.23           C  
ATOM    840  C   ILE A 106      18.957  36.945  29.451  1.00 14.27           C  
ATOM    841  O   ILE A 106      18.100  37.804  29.669  1.00 12.85           O  
ATOM    842  CB  ILE A 106      21.425  37.425  29.669  1.00 13.97           C  
ATOM    843  CG1 ILE A 106      22.599  37.462  30.659  1.00 14.12           C  
ATOM    844  CG2 ILE A 106      21.108  38.833  29.163  1.00 12.95           C  
ATOM    845  CD1 ILE A 106      23.923  37.939  30.059  1.00 13.41           C  
ATOM    846  N   ARG A 107      18.871  36.081  28.441  1.00 15.33           N  
ATOM    847  CA  ARG A 107      17.730  36.106  27.528  1.00 17.60           C  
ATOM    848  C   ARG A 107      16.424  35.806  28.263  1.00 16.86           C  
ATOM    849  O   ARG A 107      15.420  36.487  28.055  1.00 16.47           O  
ATOM    850  CB  ARG A 107      17.921  35.101  26.390  1.00 19.82           C  
ATOM    851  CG  ARG A 107      18.843  35.593  25.291  1.00 25.63           C  
ATOM    852  CD  ARG A 107      18.738  34.711  24.054  1.00 29.59           C  
ATOM    853  NE  ARG A 107      19.345  33.397  24.252  1.00 33.84           N  
ATOM    854  CZ  ARG A 107      20.656  33.168  24.239  1.00 34.12           C  
ATOM    855  NH1 ARG A 107      21.508  34.166  24.033  1.00 35.34           N  
ATOM    856  NH2 ARG A 107      21.114  31.940  24.439  1.00 35.24           N  
ATOM    857  N   GLN A 108      16.438  34.793  29.125  1.00 17.12           N  
ATOM    858  CA  GLN A 108      15.242  34.434  29.881  1.00 17.39           C  
ATOM    859  C   GLN A 108      14.776  35.596  30.750  1.00 16.28           C  
ATOM    860  O   GLN A 108      13.590  35.927  30.779  1.00 16.00           O  
ATOM    861  CB  GLN A 108      15.518  33.224  30.776  1.00 19.77           C  
ATOM    862  CG  GLN A 108      16.096  32.024  30.047  1.00 23.86           C  
ATOM    863  CD  GLN A 108      16.279  30.825  30.963  1.00 27.06           C  
ATOM    864  OE1 GLN A 108      16.761  30.958  32.092  1.00 29.23           O  
ATOM    865  NE2 GLN A 108      15.903  29.646  30.479  1.00 28.71           N  
ATOM    866  N   LEU A 109      15.720  36.216  31.454  1.00 13.92           N  
ATOM    867  CA  LEU A 109      15.410  37.332  32.337  1.00 14.02           C  
ATOM    868  C   LEU A 109      14.813  38.542  31.621  1.00 14.68           C  
ATOM    869  O   LEU A 109      13.805  39.090  32.070  1.00 14.23           O  
ATOM    870  CB  LEU A 109      16.666  37.750  33.109  1.00 12.56           C  
ATOM    871  CG  LEU A 109      17.123  36.748  34.177  1.00 12.01           C  
ATOM    872  CD1 LEU A 109      18.548  37.047  34.606  1.00 10.87           C  
ATOM    873  CD2 LEU A 109      16.168  36.803  35.362  1.00 11.94           C  
ATOM    874  N   GLU A 110      15.422  38.965  30.516  1.00 16.17           N  
ATOM    875  CA  GLU A 110      14.902  40.127  29.795  1.00 18.53           C  
ATOM    876  C   GLU A 110      13.533  39.841  29.194  1.00 18.19           C  
ATOM    877  O   GLU A 110      12.668  40.717  29.154  1.00 18.23           O  
ATOM    878  CB  GLU A 110      15.876  40.572  28.704  1.00 22.19           C  
ATOM    879  CG  GLU A 110      16.351  39.467  27.798  1.00 30.02           C  
ATOM    880  CD  GLU A 110      17.390  39.951  26.803  1.00 34.63           C  
ATOM    881  OE1 GLU A 110      18.341  40.640  27.232  1.00 37.24           O  
ATOM    882  OE2 GLU A 110      17.258  39.638  25.598  1.00 36.85           O  
ATOM    883  N   THR A 111      13.335  38.610  28.740  1.00 18.23           N  
ATOM    884  CA  THR A 111      12.058  38.218  28.163  1.00 19.61           C  
ATOM    885  C   THR A 111      10.971  38.282  29.230  1.00 20.19           C  
ATOM    886  O   THR A 111       9.936  38.927  29.036  1.00 19.35           O  
ATOM    887  CB  THR A 111      12.126  36.791  27.598  1.00 22.25           C  
ATOM    888  OG1 THR A 111      12.962  36.786  26.434  1.00 24.01           O  
ATOM    889  CG2 THR A 111      10.735  36.288  27.234  1.00 23.19           C  
ATOM    890  N   GLU A 112      11.215  37.622  30.360  1.00 18.76           N  
ATOM    891  CA  GLU A 112      10.255  37.604  31.457  1.00 18.40           C  
ATOM    892  C   GLU A 112      10.013  38.994  32.060  1.00 17.72           C  
ATOM    893  O   GLU A 112       8.878  39.341  32.384  1.00 18.50           O  
ATOM    894  CB  GLU A 112      10.730  36.634  32.537  1.00 20.71           C  
ATOM    895  CG  GLU A 112       9.929  36.679  33.817  1.00 24.67           C  
ATOM    896  CD  GLU A 112      10.377  35.616  34.798  1.00 29.54           C  
ATOM    897  OE1 GLU A 112      11.595  35.325  34.847  1.00 31.76           O  
ATOM    898  OE2 GLU A 112       9.519  35.077  35.527  1.00 33.22           O  
ATOM    899  N   ALA A 113      11.073  39.786  32.213  1.00 16.22           N  
ATOM    900  CA  ALA A 113      10.932  41.132  32.762  1.00 15.82           C  
ATOM    901  C   ALA A 113      10.161  41.993  31.764  1.00 16.97           C  
ATOM    902  O   ALA A 113       9.369  42.856  32.146  1.00 17.36           O  
ATOM    903  CB  ALA A 113      12.302  41.743  33.032  1.00 14.91           C  
ATOM    904  N   GLY A 114      10.398  41.750  30.481  1.00 17.42           N  
ATOM    905  CA  GLY A 114       9.707  42.511  29.460  1.00 20.67           C  
ATOM    906  C   GLY A 114       8.234  42.161  29.373  1.00 21.46           C  
ATOM    907  O   GLY A 114       7.386  43.047  29.258  1.00 22.31           O  
ATOM    908  N   GLU A 115       7.926  40.869  29.446  1.00 22.64           N  
ATOM    909  CA  GLU A 115       6.544  40.408  29.351  1.00 23.87           C  
ATOM    910  C   GLU A 115       5.739  40.518  30.641  1.00 23.39           C  
ATOM    911  O   GLU A 115       4.536  40.791  30.605  1.00 23.36           O  
ATOM    912  CB  GLU A 115       6.501  38.955  28.877  1.00 25.47           C  
ATOM    913  CG  GLU A 115       7.234  38.687  27.580  1.00 30.62           C  
ATOM    914  CD  GLU A 115       7.016  37.269  27.080  1.00 33.74           C  
ATOM    915  OE1 GLU A 115       6.911  36.352  27.925  1.00 36.20           O  
ATOM    916  OE2 GLU A 115       6.965  37.069  25.846  1.00 36.05           O  
ATOM    917  N   ARG A 116       6.391  40.307  31.779  1.00 22.47           N  
ATOM    918  CA  ARG A 116       5.690  40.353  33.055  1.00 22.42           C  
ATOM    919  C   ARG A 116       6.010  41.541  33.945  1.00 20.26           C  
ATOM    920  O   ARG A 116       5.365  41.737  34.974  1.00 20.32           O  
ATOM    921  CB  ARG A 116       5.934  39.045  33.803  1.00 26.00           C  
ATOM    922  CG  ARG A 116       5.422  37.853  33.020  1.00 31.91           C  
ATOM    923  CD  ARG A 116       5.811  36.529  33.643  1.00 38.51           C  
ATOM    924  NE  ARG A 116       5.280  35.412  32.862  1.00 44.16           N  
ATOM    925  CZ  ARG A 116       5.580  35.171  31.585  1.00 46.19           C  
ATOM    926  NH1 ARG A 116       6.417  35.967  30.927  1.00 46.83           N  
ATOM    927  NH2 ARG A 116       5.037  34.133  30.964  1.00 47.93           N  
ATOM    928  N   GLY A 117       6.997  42.336  33.553  1.00 17.49           N  
ATOM    929  CA  GLY A 117       7.346  43.500  34.346  1.00 16.62           C  
ATOM    930  C   GLY A 117       8.452  43.273  35.360  1.00 16.18           C  
ATOM    931  O   GLY A 117       9.042  44.233  35.855  1.00 15.03           O  
ATOM    932  N   LYS A 118       8.731  42.012  35.680  1.00 15.02           N  
ATOM    933  CA  LYS A 118       9.786  41.689  36.637  1.00 15.03           C  
ATOM    934  C   LYS A 118      10.257  40.247  36.475  1.00 14.66           C  
ATOM    935  O   LYS A 118       9.510  39.382  35.992  1.00 14.81           O  
ATOM    936  CB  LYS A 118       9.299  41.902  38.072  1.00 15.78           C  
ATOM    937  CG  LYS A 118       8.221  40.929  38.515  1.00 19.59           C  
ATOM    938  CD  LYS A 118       7.814  41.189  39.960  1.00 25.45           C  
ATOM    939  CE  LYS A 118       6.742  40.214  40.421  1.00 28.03           C  
ATOM    940  NZ  LYS A 118       6.393  40.426  41.855  1.00 31.87           N  
ATOM    941  N   ALA A 119      11.501  40.002  36.879  1.00 12.61           N  
ATOM    942  CA  ALA A 119      12.117  38.681  36.798  1.00 11.14           C  
ATOM    943  C   ALA A 119      13.189  38.614  37.874  1.00 11.98           C  
ATOM    944  O   ALA A 119      13.926  39.579  38.075  1.00 13.48           O  
ATOM    945  CB  ALA A 119      12.739  38.477  35.432  1.00 10.20           C  
ATOM    946  N   GLU A 120      13.285  37.482  38.562  1.00 11.11           N  
ATOM    947  CA  GLU A 120      14.275  37.333  39.627  1.00  9.88           C  
ATOM    948  C   GLU A 120      15.521  36.578  39.192  1.00  9.74           C  
ATOM    949  O   GLU A 120      15.458  35.666  38.373  1.00  8.65           O  
ATOM    950  CB  GLU A 120      13.706  36.550  40.815  1.00 12.86           C  
ATOM    951  CG  GLU A 120      12.408  37.027  41.425  1.00 16.74           C  
ATOM    952  CD  GLU A 120      11.959  36.101  42.552  1.00 18.42           C  
ATOM    953  OE1 GLU A 120      12.216  34.874  42.453  1.00 18.82           O  
ATOM    954  OE2 GLU A 120      11.346  36.588  43.526  1.00 19.20           O  
ATOM    955  N   TYR A 121      16.659  36.964  39.756  1.00  8.44           N  
ATOM    956  CA  TYR A 121      17.904  36.253  39.508  1.00  8.00           C  
ATOM    957  C   TYR A 121      18.669  36.249  40.830  1.00  8.10           C  
ATOM    958  O   TYR A 121      18.600  37.204  41.609  1.00  8.19           O  
ATOM    959  CB  TYR A 121      18.727  36.876  38.360  1.00  7.72           C  
ATOM    960  CG  TYR A 121      19.176  38.315  38.524  1.00  8.78           C  
ATOM    961  CD1 TYR A 121      20.469  38.624  38.960  1.00  8.84           C  
ATOM    962  CD2 TYR A 121      18.329  39.369  38.183  1.00  9.02           C  
ATOM    963  CE1 TYR A 121      20.907  39.953  39.044  1.00  8.72           C  
ATOM    964  CE2 TYR A 121      18.754  40.699  38.265  1.00  9.27           C  
ATOM    965  CZ  TYR A 121      20.041  40.983  38.693  1.00  9.31           C  
ATOM    966  OH  TYR A 121      20.447  42.299  38.759  1.00 10.17           O  
ATOM    967  N   SER A 122      19.356  35.149  41.111  1.00  8.08           N  
ATOM    968  CA  SER A 122      20.113  35.043  42.349  1.00  7.34           C  
ATOM    969  C   SER A 122      21.600  34.887  42.069  1.00  8.00           C  
ATOM    970  O   SER A 122      22.000  34.472  40.976  1.00  7.95           O  
ATOM    971  CB  SER A 122      19.616  33.852  43.170  1.00  8.36           C  
ATOM    972  OG  SER A 122      19.732  32.648  42.431  1.00  9.49           O  
ATOM    973  N   LEU A 123      22.414  35.245  43.057  1.00  6.35           N  
ATOM    974  CA  LEU A 123      23.862  35.125  42.943  1.00  6.48           C  
ATOM    975  C   LEU A 123      24.381  34.548  44.257  1.00  6.87           C  
ATOM    976  O   LEU A 123      23.957  34.969  45.338  1.00  6.50           O  
ATOM    977  CB  LEU A 123      24.510  36.497  42.694  1.00  6.92           C  
ATOM    978  CG  LEU A 123      24.125  37.274  41.425  1.00  6.02           C  
ATOM    979  CD1 LEU A 123      24.769  38.660  41.451  1.00  7.28           C  
ATOM    980  CD2 LEU A 123      24.570  36.511  40.190  1.00  7.50           C  
ATOM    981  N   GLU A 124      25.273  33.568  44.150  1.00  6.75           N  
ATOM    982  CA  GLU A 124      25.902  32.930  45.309  1.00  7.21           C  
ATOM    983  C   GLU A 124      27.387  33.136  45.060  1.00  7.41           C  
ATOM    984  O   GLU A 124      27.991  32.447  44.234  1.00  7.74           O  
ATOM    985  CB  GLU A 124      25.546  31.444  45.364  1.00  8.21           C  
ATOM    986  CG  GLU A 124      24.066  31.208  45.619  1.00 10.04           C  
ATOM    987  CD  GLU A 124      23.698  29.746  45.568  1.00 13.54           C  
ATOM    988  OE1 GLU A 124      23.973  29.020  46.545  1.00 15.69           O  
ATOM    989  OE2 GLU A 124      23.139  29.326  44.537  1.00 15.46           O  
ATOM    990  N   LEU A 125      27.965  34.088  45.785  1.00  6.43           N  
ATOM    991  CA  LEU A 125      29.350  34.480  45.583  1.00  7.06           C  
ATOM    992  C   LEU A 125      30.311  34.264  46.735  1.00  7.19           C  
ATOM    993  O   LEU A 125      29.907  34.114  47.887  1.00  8.19           O  
ATOM    994  CB  LEU A 125      29.384  35.967  45.221  1.00  6.81           C  
ATOM    995  CG  LEU A 125      28.283  36.484  44.288  1.00  8.55           C  
ATOM    996  CD1 LEU A 125      28.434  37.990  44.112  1.00  9.03           C  
ATOM    997  CD2 LEU A 125      28.360  35.774  42.945  1.00  9.07           C  
ATOM    998  N   GLN A 126      31.597  34.276  46.397  1.00  7.10           N  
ATOM    999  CA  GLN A 126      32.669  34.146  47.374  1.00  7.08           C  
ATOM   1000  C   GLN A 126      33.548  35.383  47.259  1.00  7.33           C  
ATOM   1001  O   GLN A 126      33.876  35.823  46.154  1.00  7.90           O  
ATOM   1002  CB  GLN A 126      33.542  32.928  47.091  1.00  8.90           C  
ATOM   1003  CG  GLN A 126      32.832  31.598  47.143  1.00 12.48           C  
ATOM   1004  CD  GLN A 126      33.810  30.446  47.083  1.00 14.22           C  
ATOM   1005  OE1 GLN A 126      34.686  30.407  46.221  1.00 14.97           O  
ATOM   1006  NE2 GLN A 126      33.668  29.499  48.004  1.00 14.17           N  
ATOM   1007  N   LEU A 127      33.906  35.954  48.401  1.00  6.84           N  
ATOM   1008  CA  LEU A 127      34.790  37.113  48.430  1.00  7.35           C  
ATOM   1009  C   LEU A 127      36.136  36.544  48.849  1.00  7.75           C  
ATOM   1010  O   LEU A 127      36.216  35.777  49.809  1.00  7.42           O  
ATOM   1011  CB  LEU A 127      34.301  38.145  49.451  1.00  8.92           C  
ATOM   1012  CG  LEU A 127      33.215  39.120  48.976  1.00  9.18           C  
ATOM   1013  CD1 LEU A 127      32.024  38.367  48.393  1.00 10.83           C  
ATOM   1014  CD2 LEU A 127      32.798  39.993  50.161  1.00  8.49           C  
ATOM   1015  N   THR A 128      37.193  36.917  48.137  1.00  7.53           N  
ATOM   1016  CA  THR A 128      38.513  36.381  48.437  1.00  8.05           C  
ATOM   1017  C   THR A 128      39.567  37.447  48.676  1.00  7.93           C  
ATOM   1018  O   THR A 128      39.463  38.559  48.160  1.00  8.22           O  
ATOM   1019  CB  THR A 128      38.998  35.473  47.281  1.00  9.54           C  
ATOM   1020  OG1 THR A 128      39.092  36.243  46.072  1.00 12.22           O  
ATOM   1021  CG2 THR A 128      38.018  34.326  47.059  1.00  9.76           C  
ATOM   1022  N   ASP A 129      40.584  37.110  49.464  1.00  7.96           N  
ATOM   1023  CA  ASP A 129      41.663  38.059  49.704  1.00  8.93           C  
ATOM   1024  C   ASP A 129      42.786  37.820  48.686  1.00 10.38           C  
ATOM   1025  O   ASP A 129      42.655  36.975  47.797  1.00  9.80           O  
ATOM   1026  CB  ASP A 129      42.188  37.968  51.144  1.00  9.41           C  
ATOM   1027  CG  ASP A 129      42.822  36.632  51.469  1.00 10.56           C  
ATOM   1028  OD1 ASP A 129      43.238  35.900  50.544  1.00  9.62           O  
ATOM   1029  OD2 ASP A 129      42.921  36.326  52.677  1.00 11.21           O  
ATOM   1030  N   GLU A 130      43.880  38.564  48.814  1.00 10.89           N  
ATOM   1031  CA  GLU A 130      44.998  38.465  47.878  1.00 13.34           C  
ATOM   1032  C   GLU A 130      45.648  37.088  47.744  1.00 13.57           C  
ATOM   1033  O   GLU A 130      46.365  36.833  46.773  1.00 13.23           O  
ATOM   1034  CB  GLU A 130      46.048  39.521  48.236  1.00 15.26           C  
ATOM   1035  CG  GLU A 130      45.571  40.942  47.922  1.00 22.71           C  
ATOM   1036  CD  GLU A 130      46.471  42.019  48.507  1.00 27.79           C  
ATOM   1037  OE1 GLU A 130      47.710  41.883  48.387  1.00 29.95           O  
ATOM   1038  OE2 GLU A 130      45.937  43.005  49.077  1.00 28.55           O  
ATOM   1039  N   GLN A 131      45.383  36.210  48.709  1.00 13.33           N  
ATOM   1040  CA  GLN A 131      45.925  34.853  48.709  1.00 13.64           C  
ATOM   1041  C   GLN A 131      44.876  33.856  48.223  1.00 12.27           C  
ATOM   1042  O   GLN A 131      45.105  32.646  48.233  1.00 11.13           O  
ATOM   1043  CB  GLN A 131      46.366  34.465  50.122  1.00 17.28           C  
ATOM   1044  CG  GLN A 131      47.472  35.328  50.678  1.00 23.37           C  
ATOM   1045  CD  GLN A 131      48.762  35.117  49.939  1.00 27.82           C  
ATOM   1046  OE1 GLN A 131      49.313  34.014  49.940  1.00 30.85           O  
ATOM   1047  NE2 GLN A 131      49.254  36.166  49.290  1.00 31.42           N  
ATOM   1048  N   GLY A 132      43.718  34.365  47.812  1.00 10.97           N  
ATOM   1049  CA  GLY A 132      42.662  33.490  47.340  1.00  9.60           C  
ATOM   1050  C   GLY A 132      41.850  32.841  48.451  1.00 11.01           C  
ATOM   1051  O   GLY A 132      41.035  31.949  48.178  1.00 10.68           O  
ATOM   1052  N   GLU A 133      42.078  33.252  49.702  1.00  9.58           N  
ATOM   1053  CA  GLU A 133      41.314  32.704  50.827  1.00  9.38           C  
ATOM   1054  C   GLU A 133      39.903  33.291  50.801  1.00  9.25           C  
ATOM   1055  O   GLU A 133      39.723  34.485  50.557  1.00  8.19           O  
ATOM   1056  CB  GLU A 133      41.952  33.056  52.180  1.00  9.11           C  
ATOM   1057  CG  GLU A 133      43.238  32.327  52.513  1.00 14.29           C  
ATOM   1058  CD  GLU A 133      43.085  30.814  52.501  1.00 16.84           C  
ATOM   1059  OE1 GLU A 133      42.152  30.281  53.141  1.00 17.77           O  
ATOM   1060  OE2 GLU A 133      43.913  30.152  51.846  1.00 20.00           O  
ATOM   1061  N   VAL A 134      38.909  32.451  51.056  1.00  8.90           N  
ATOM   1062  CA  VAL A 134      37.520  32.894  51.078  1.00  8.66           C  
ATOM   1063  C   VAL A 134      37.239  33.549  52.428  1.00  8.80           C  
ATOM   1064  O   VAL A 134      37.212  32.879  53.460  1.00 10.46           O  
ATOM   1065  CB  VAL A 134      36.574  31.700  50.852  1.00 10.13           C  
ATOM   1066  CG1 VAL A 134      35.122  32.143  50.971  1.00 10.53           C  
ATOM   1067  CG2 VAL A 134      36.833  31.107  49.474  1.00  9.74           C  
ATOM   1068  N   VAL A 135      37.034  34.863  52.421  1.00  6.88           N  
ATOM   1069  CA  VAL A 135      36.792  35.582  53.664  1.00  7.01           C  
ATOM   1070  C   VAL A 135      35.315  35.714  54.021  1.00  6.48           C  
ATOM   1071  O   VAL A 135      34.967  35.903  55.188  1.00  6.64           O  
ATOM   1072  CB  VAL A 135      37.436  36.991  53.620  1.00  7.26           C  
ATOM   1073  CG1 VAL A 135      38.940  36.868  53.377  1.00  6.80           C  
ATOM   1074  CG2 VAL A 135      36.777  37.843  52.531  1.00  6.50           C  
ATOM   1075  N   ALA A 136      34.453  35.616  53.014  1.00  6.13           N  
ATOM   1076  CA  ALA A 136      33.012  35.721  53.216  1.00  6.35           C  
ATOM   1077  C   ALA A 136      32.304  35.119  52.011  1.00  6.92           C  
ATOM   1078  O   ALA A 136      32.871  35.051  50.921  1.00  6.76           O  
ATOM   1079  CB  ALA A 136      32.608  37.182  53.384  1.00  6.07           C  
ATOM   1080  N   GLU A 137      31.068  34.681  52.216  1.00  6.38           N  
ATOM   1081  CA  GLU A 137      30.273  34.093  51.150  1.00  7.46           C  
ATOM   1082  C   GLU A 137      28.858  34.645  51.244  1.00  8.10           C  
ATOM   1083  O   GLU A 137      28.291  34.732  52.333  1.00  8.52           O  
ATOM   1084  CB  GLU A 137      30.276  32.566  51.282  1.00  8.64           C  
ATOM   1085  CG  GLU A 137      31.662  31.969  51.088  1.00  7.82           C  
ATOM   1086  CD  GLU A 137      31.680  30.456  51.181  1.00 11.98           C  
ATOM   1087  OE1 GLU A 137      31.569  29.922  52.307  1.00 10.89           O  
ATOM   1088  OE2 GLU A 137      31.805  29.801  50.122  1.00 12.22           O  
ATOM   1089  N   SER A 138      28.292  35.021  50.101  1.00  7.38           N  
ATOM   1090  CA  SER A 138      26.948  35.592  50.073  1.00  6.94           C  
ATOM   1091  C   SER A 138      25.976  34.857  49.156  1.00  6.64           C  
ATOM   1092  O   SER A 138      26.375  34.145  48.235  1.00  6.41           O  
ATOM   1093  CB  SER A 138      27.014  37.059  49.628  1.00  7.76           C  
ATOM   1094  OG  SER A 138      27.478  37.160  48.287  1.00  8.51           O  
ATOM   1095  N   ALA A 139      24.692  35.050  49.427  1.00  7.03           N  
ATOM   1096  CA  ALA A 139      23.612  34.481  48.628  1.00  6.37           C  
ATOM   1097  C   ALA A 139      22.593  35.615  48.564  1.00  6.55           C  
ATOM   1098  O   ALA A 139      22.160  36.119  49.605  1.00  6.91           O  
ATOM   1099  CB  ALA A 139      23.014  33.252  49.318  1.00  6.91           C  
ATOM   1100  N   ALA A 140      22.219  36.030  47.358  1.00  6.16           N  
ATOM   1101  CA  ALA A 140      21.283  37.141  47.219  1.00  5.89           C  
ATOM   1102  C   ALA A 140      20.248  36.965  46.120  1.00  6.66           C  
ATOM   1103  O   ALA A 140      20.504  36.313  45.106  1.00  7.29           O  
ATOM   1104  CB  ALA A 140      22.057  38.418  46.974  1.00  7.01           C  
ATOM   1105  N   LEU A 141      19.082  37.570  46.334  1.00  6.64           N  
ATOM   1106  CA  LEU A 141      17.985  37.524  45.374  1.00  6.42           C  
ATOM   1107  C   LEU A 141      17.740  38.934  44.864  1.00  7.01           C  
ATOM   1108  O   LEU A 141      17.516  39.857  45.651  1.00  6.67           O  
ATOM   1109  CB  LEU A 141      16.703  37.000  46.033  1.00  5.73           C  
ATOM   1110  CG  LEU A 141      15.457  36.901  45.143  1.00  7.58           C  
ATOM   1111  CD1 LEU A 141      15.679  35.886  44.023  1.00  6.69           C  
ATOM   1112  CD2 LEU A 141      14.263  36.497  45.989  1.00  6.45           C  
ATOM   1113  N   TYR A 142      17.792  39.087  43.546  1.00  7.34           N  
ATOM   1114  CA  TYR A 142      17.573  40.369  42.889  1.00  7.70           C  
ATOM   1115  C   TYR A 142      16.363  40.263  41.990  1.00  8.29           C  
ATOM   1116  O   TYR A 142      15.941  39.172  41.606  1.00  7.88           O  
ATOM   1117  CB  TYR A 142      18.770  40.741  42.008  1.00  7.07           C  
ATOM   1118  CG  TYR A 142      20.053  40.933  42.762  1.00  7.56           C  
ATOM   1119  CD1 TYR A 142      20.400  42.185  43.278  1.00  7.99           C  
ATOM   1120  CD2 TYR A 142      20.915  39.857  42.990  1.00  7.70           C  
ATOM   1121  CE1 TYR A 142      21.582  42.360  44.009  1.00  7.83           C  
ATOM   1122  CE2 TYR A 142      22.096  40.020  43.719  1.00  7.42           C  
ATOM   1123  CZ  TYR A 142      22.418  41.275  44.223  1.00  8.52           C  
ATOM   1124  OH  TYR A 142      23.567  41.434  44.962  1.00  9.60           O  
ATOM   1125  N   GLN A 143      15.824  41.417  41.634  1.00  9.04           N  
ATOM   1126  CA  GLN A 143      14.693  41.465  40.740  1.00 10.47           C  
ATOM   1127  C   GLN A 143      15.043  42.463  39.642  1.00 10.37           C  
ATOM   1128  O   GLN A 143      15.567  43.542  39.929  1.00 10.94           O  
ATOM   1129  CB  GLN A 143      13.458  41.941  41.500  1.00 13.55           C  
ATOM   1130  CG  GLN A 143      12.177  41.247  41.113  1.00 19.50           C  
ATOM   1131  CD  GLN A 143      11.009  41.724  41.943  1.00 18.97           C  
ATOM   1132  OE1 GLN A 143      10.586  42.869  41.830  1.00 20.48           O  
ATOM   1133  NE2 GLN A 143      10.491  40.849  42.796  1.00 21.81           N  
ATOM   1134  N   LEU A 144      14.806  42.079  38.392  1.00 10.24           N  
ATOM   1135  CA  LEU A 144      15.027  42.968  37.251  1.00 10.83           C  
ATOM   1136  C   LEU A 144      13.609  43.483  36.994  1.00 11.39           C  
ATOM   1137  O   LEU A 144      12.696  42.692  36.748  1.00 11.43           O  
ATOM   1138  CB  LEU A 144      15.532  42.187  36.031  1.00 10.55           C  
ATOM   1139  CG  LEU A 144      15.811  43.009  34.767  1.00 12.56           C  
ATOM   1140  CD1 LEU A 144      16.964  43.980  35.022  1.00 11.38           C  
ATOM   1141  CD2 LEU A 144      16.148  42.074  33.611  1.00 12.47           C  
ATOM   1142  N   ARG A 145      13.415  44.796  37.066  1.00 10.26           N  
ATOM   1143  CA  ARG A 145      12.081  45.353  36.881  1.00 12.29           C  
ATOM   1144  C   ARG A 145      12.010  46.385  35.780  1.00 13.22           C  
ATOM   1145  O   ARG A 145      12.964  47.118  35.541  1.00 12.10           O  
ATOM   1146  CB  ARG A 145      11.602  46.004  38.183  1.00 12.69           C  
ATOM   1147  CG  ARG A 145      11.591  45.072  39.388  1.00 15.20           C  
ATOM   1148  CD  ARG A 145      11.173  45.818  40.644  1.00 18.02           C  
ATOM   1149  NE  ARG A 145       9.839  46.403  40.527  1.00 21.86           N  
ATOM   1150  CZ  ARG A 145       8.700  45.717  40.616  1.00 24.57           C  
ATOM   1151  NH1 ARG A 145       8.716  44.408  40.827  1.00 24.35           N  
ATOM   1152  NH2 ARG A 145       7.539  46.346  40.494  1.00 25.54           N  
ATOM   1153  N   SER A 146      10.870  46.446  35.105  1.00 14.59           N  
ATOM   1154  CA  SER A 146      10.696  47.443  34.065  1.00 16.26           C  
ATOM   1155  C   SER A 146      10.093  48.665  34.744  1.00 16.35           C  
ATOM   1156  O   SER A 146       9.430  48.553  35.777  1.00 14.38           O  
ATOM   1157  CB  SER A 146       9.761  46.931  32.965  1.00 18.02           C  
ATOM   1158  OG  SER A 146       8.478  46.635  33.483  1.00 23.93           O  
ATOM   1159  N   HIS A 147      10.348  49.839  34.187  1.00 17.77           N  
ATOM   1160  CA  HIS A 147       9.794  51.055  34.756  1.00 19.10           C  
ATOM   1161  C   HIS A 147       8.305  51.098  34.433  1.00 20.81           C  
ATOM   1162  O   HIS A 147       7.895  50.787  33.316  1.00 22.89           O  
ATOM   1163  CB  HIS A 147      10.496  52.280  34.165  1.00 19.09           C  
ATOM   1164  CG  HIS A 147      11.901  52.460  34.649  1.00 18.60           C  
ATOM   1165  ND1 HIS A 147      12.198  52.963  35.898  1.00 17.48           N  
ATOM   1166  CD2 HIS A 147      13.089  52.200  34.055  1.00 17.73           C  
ATOM   1167  CE1 HIS A 147      13.510  53.007  36.051  1.00 19.07           C  
ATOM   1168  NE2 HIS A 147      14.074  52.549  34.947  1.00 18.65           N  
ATOM   1169  N   ALA A 148       7.491  51.459  35.417  1.00 22.55           N  
ATOM   1170  CA  ALA A 148       6.054  51.540  35.198  1.00 24.89           C  
ATOM   1171  C   ALA A 148       5.752  52.866  34.513  1.00 26.10           C  
ATOM   1172  O   ALA A 148       6.531  53.818  34.603  1.00 26.03           O  
ATOM   1173  CB  ALA A 148       5.307  51.451  36.524  1.00 25.67           C  
ATOM   1174  N   ARG A 149       4.626  52.924  33.816  1.00 26.90           N  
ATOM   1175  CA  ARG A 149       4.235  54.144  33.133  1.00 27.30           C  
ATOM   1176  C   ARG A 149       3.745  55.117  34.202  1.00 26.87           C  
ATOM   1177  O   ARG A 149       2.929  54.752  35.046  1.00 25.71           O  
ATOM   1178  CB  ARG A 149       3.120  53.836  32.141  1.00 29.90           C  
ATOM   1179  CG  ARG A 149       2.690  55.023  31.323  1.00 33.02           C  
ATOM   1180  CD  ARG A 149       1.560  54.661  30.392  1.00 34.42           C  
ATOM   1181  NE  ARG A 149       1.211  55.801  29.561  1.00 37.39           N  
ATOM   1182  CZ  ARG A 149       2.015  56.327  28.644  1.00 37.93           C  
ATOM   1183  NH1 ARG A 149       3.220  55.814  28.427  1.00 38.61           N  
ATOM   1184  NH2 ARG A 149       1.614  57.380  27.952  1.00 39.13           N  
ATOM   1185  N   PRO A 150       4.252  56.362  34.197  1.00 27.14           N  
ATOM   1186  CA  PRO A 150       3.823  57.345  35.201  1.00 27.07           C  
ATOM   1187  C   PRO A 150       2.304  57.545  35.231  1.00 27.48           C  
ATOM   1188  O   PRO A 150       1.668  57.703  34.190  1.00 26.82           O  
ATOM   1189  CB  PRO A 150       4.569  58.611  34.782  1.00 27.70           C  
ATOM   1190  CG  PRO A 150       5.834  58.068  34.175  1.00 27.49           C  
ATOM   1191  CD  PRO A 150       5.315  56.919  33.337  1.00 27.64           C  
ATOM   1192  N   GLY A 151       1.730  57.530  36.431  1.00 28.20           N  
ATOM   1193  CA  GLY A 151       0.296  57.719  36.566  1.00 29.70           C  
ATOM   1194  C   GLY A 151      -0.521  56.441  36.499  1.00 31.24           C  
ATOM   1195  O   GLY A 151      -1.732  56.466  36.715  1.00 31.24           O  
ATOM   1196  N   SER A 152       0.129  55.320  36.199  1.00 32.07           N  
ATOM   1197  CA  SER A 152      -0.577  54.045  36.111  1.00 33.45           C  
ATOM   1198  C   SER A 152      -0.670  53.365  37.477  1.00 33.64           C  
ATOM   1199  O   SER A 152      -0.073  53.881  38.447  1.00 32.98           O  
ATOM   1200  CB  SER A 152       0.124  53.110  35.117  1.00 33.74           C  
ATOM   1201  OG  SER A 152       1.388  52.691  35.601  1.00 34.78           O  
ATOM   1202  OXT SER A 152      -1.341  52.315  37.558  1.00 35.30           O  
TER    1203      SER A 152                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
