
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  216 ( 1721),  selected  216 , name 2g9n_A
# Molecule2: number of CA atoms  240 ( 1868),  selected  240 , name T0477.pdb
# PARAMETERS: 2g9n_A.T0477.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    21_A      S       1           -
LGA    V    22_A      M       2           -
LGA    I    23_A      K       3           -
LGA    -       -      I       4           -
LGA    -       -      N       5           -
LGA    -       -      F       6           -
LGA    -       -      L       7           -
LGA    -       -      R       8           -
LGA    -       -      N       9           -
LGA    -       -      K      10           -
LGA    -       -      H      11           -
LGA    -       -      K      12           -
LGA    -       -      I      13           -
LGA    E    24_A      H      14          5.520
LGA    S    25_A      V      15          1.154
LGA    N    26_A      Q      16          3.105
LGA    -       -      G      17           -
LGA    -       -      T      18           -
LGA    -       -      D      19           -
LGA    W    27_A      L      20          3.411
LGA    N    28_A      P      21          5.227
LGA    E    29_A      D      22          1.436
LGA    I    30_A      P      23          2.414
LGA    V    31_A      I      24          1.672
LGA    D    32_A      A      25          2.168
LGA    S    33_A      T      26          1.389
LGA    F    34_A      F      27          0.978
LGA    D    35_A      Q      28          1.319
LGA    D    36_A      Q      29          1.050
LGA    M    37_A      L      30          1.258
LGA    N    38_A      D      31          3.034
LGA    -       -      Q      32           -
LGA    -       -      E      33           -
LGA    -       -      Y      34           -
LGA    -       -      K      35           -
LGA    L    39_A      I      36          1.579
LGA    S    40_A      N      37          1.514
LGA    E    41_A      S      38          0.955
LGA    S    42_A      R      39          1.566
LGA    L    43_A      L      40          1.363
LGA    L    44_A      L      41          0.611
LGA    R    45_A      Q      42          1.770
LGA    G    46_A      N      43          2.136
LGA    I    47_A      I      44          1.427
LGA    Y    48_A      L      45          2.224
LGA    A    49_A      D      46          3.053
LGA    Y    50_A      A      47          2.942
LGA    G    51_A      G      48          3.062
LGA    F    52_A      F      49          1.861
LGA    E    53_A      Q      50          1.781
LGA    X    54_A      M      51          1.144
LGA    P    55_A      P      52          0.711
LGA    S    56_A      T      53          0.819
LGA    A    57_A      P      54          0.600
LGA    I    58_A      I      55          0.769
LGA    Q    59_A      Q      56          0.912
LGA    Q    60_A      M      57          1.112
LGA    R    61_A      Q      58          1.191
LGA    A    62_A      A      59          1.107
LGA    I    63_A      I      60          0.789
LGA    L    64_A      P      61          1.310
LGA    P    65_A      V      62          1.589
LGA    C    66_A      M      63          0.814
LGA    I    67_A      L      64          1.538
LGA    X    68_A      H      65          1.801
LGA    G    69_A      G      66          1.177
LGA    Y    70_A      R      67          1.034
LGA    D    71_A      E      68          0.799
LGA    V    72_A      L      69          1.209
LGA    I    73_A      L      70          1.222
LGA    A    74_A      A      71          0.835
LGA    Q    75_A      S      72          1.242
LGA    A    76_A      A      73          0.726
LGA    Q    77_A      P      74          0.863
LGA    S    78_A      T      75          0.800
LGA    G    79_A      G      76          0.249
LGA    T    80_A      S      77          0.340
LGA    G    81_A      G      78          0.627
LGA    X    82_A      K      79          0.301
LGA    T    83_A      T      80          0.283
LGA    A    84_A      L      81          0.705
LGA    T    85_A      A      82          0.692
LGA    F    86_A      F      83          0.516
LGA    A    87_A      S      84          0.878
LGA    I    88_A      I      85          0.709
LGA    S    89_A      P      86          0.898
LGA    I    90_A      I      87          0.651
LGA    L    91_A      L      88          0.619
LGA    Q    92_A      M      89          0.631
LGA    Q    93_A      Q      90          0.999
LGA    I    94_A      L      91          1.088
LGA    E    95_A      K      92          4.452
LGA    L    96_A      Q      93          2.321
LGA    D    97_A      P      94          4.668
LGA    L    98_A      A      95          2.542
LGA    X    99_A      N      96          1.155
LGA    A   100_A      K      97          2.660
LGA    -       -      G      98           -
LGA    T   101_A      F      99          0.600
LGA    Q   102_A      R     100          0.273
LGA    A   103_A      A     101          0.473
LGA    L   104_A      L     102          0.542
LGA    V   105_A      I     103          0.465
LGA    L   106_A      I     104          0.665
LGA    A   107_A      S     105          0.638
LGA    P   108_A      P     106          1.100
LGA    T   109_A      T     107          1.464
LGA    R   110_A      R     108          1.303
LGA    E   111_A      E     109          0.849
LGA    L   112_A      L     110          0.814
LGA    A   113_A      A     111          0.593
LGA    Q   114_A      S     112          0.582
LGA    Q   115_A      Q     113          0.407
LGA    I   116_A      I     114          0.456
LGA    Q   117_A      H     115          0.578
LGA    X   118_A      R     116          0.474
LGA    V   119_A      E     117          0.886
LGA    V   120_A      L     118          0.889
LGA    M   121_A      I     119          1.231
LGA    A   122_A      K     120          1.247
LGA    L   123_A      I     121          1.709
LGA    G   124_A      S     122          2.022
LGA    D   125_A      E     123          2.193
LGA    Y   126_A      G     124          2.308
LGA    M   127_A      T     125          1.021
LGA    G   128_A      G     126          0.827
LGA    A   129_A      F     127          0.938
LGA    S   130_A      R     128          1.043
LGA    C   131_A      I     129          0.815
LGA    H   132_A      H     130          0.785
LGA    A   133_A      M     131          1.561
LGA    C   134_A      I     132          3.592
LGA    I   135_A      H     133           #
LGA    G   136_A      -       -           -
LGA    N   139_A      -       -           -
LGA    V   140_A      K     134          3.438
LGA    R   141_A      A     135          2.520
LGA    A   142_A      A     136          3.334
LGA    E   143_A      V     137          5.006
LGA    V   144_A      A     138          4.573
LGA    Q   145_A      A     139          2.686
LGA    -       -      K     140           -
LGA    X   146_A      K     141          3.298
LGA    L   147_A      F     142          2.858
LGA    -       -      G     143           -
LGA    -       -      P     144           -
LGA    Q   148_A      K     145           #
LGA    M   149_A      S     146           #
LGA    E   150_A      S     147          5.042
LGA    A   151_A      K     148          3.308
LGA    -       -      K     149           -
LGA    P   152_A      F     150          1.853
LGA    H   153_A      D     151          0.504
LGA    I   154_A      I     152          0.586
LGA    I   155_A      L     153          0.539
LGA    V   156_A      V     154          0.847
LGA    G   157_A      T     155          0.666
LGA    T   158_A      T     156          0.638
LGA    P   159_A      P     157          0.417
LGA    G   160_A      N     158          0.827
LGA    R   161_A      R     159          0.563
LGA    V   162_A      L     160          0.944
LGA    F   163_A      I     161          1.500
LGA    D   164_A      Y     162          1.479
LGA    M   165_A      L     163          1.485
LGA    L   166_A      L     164          2.248
LGA    N   167_A      K     165          2.427
LGA    R   168_A      Q     166          2.411
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    R   169_A      P     169          1.955
LGA    Y   170_A      G     170          1.961
LGA    L   171_A      I     171          1.567
LGA    S   172_A      D     172          0.889
LGA    P   173_A      L     173          1.167
LGA    X   174_A      A     174          1.022
LGA    Y   175_A      S     175          0.622
LGA    I   176_A      V     176          0.414
LGA    X   177_A      E     177          0.924
LGA    M   178_A      W     178          0.492
LGA    F   179_A      L     179          0.595
LGA    V   180_A      V     180          0.402
LGA    L   181_A      V     181          0.809
LGA    D   182_A      D     182          0.866
LGA    E   183_A      E     183          0.987
LGA    A   184_A      S     184          0.597
LGA    D   185_A      D     185          1.099
LGA    E   186_A      K     186          0.450
LGA    M   187_A      L     187          0.716
LGA    L   188_A      F     188          1.362
LGA    S   189_A      E     189          1.402
LGA    R   190_A      D     190          1.656
LGA    G   191_A      G     191          0.940
LGA    -       -      G     194           -
LGA    F   192_A      F     195          2.504
LGA    X   193_A      R     196          2.473
LGA    D   194_A      D     197          2.479
LGA    Q   195_A      Q     198          1.677
LGA    I   196_A      L     199          1.719
LGA    Y   197_A      A     200          1.913
LGA    D   198_A      S     201          1.516
LGA    I   199_A      I     202          0.656
LGA    F   200_A      F     203          1.551
LGA    Q   201_A      L     204          1.775
LGA    X   202_A      A     205          1.381
LGA    L   203_A      C     206          1.381
LGA    N   204_A      T     207          1.955
LGA    -       -      S     208           -
LGA    S   205_A      H     209           #
LGA    N   206_A      K     210          4.512
LGA    T   207_A      V     211          1.462
LGA    Q   208_A      R     212          0.653
LGA    V   209_A      R     213          0.718
LGA    V   210_A      A     214          0.645
LGA    L   211_A      M     215          0.667
LGA    L   212_A      F     216          0.956
LGA    S   213_A      S     217          1.092
LGA    A   214_A      A     218          2.031
LGA    T   215_A      T     219          2.475
LGA    M   216_A      F     220          3.640
LGA    P   217_A      A     221          3.252
LGA    S   218_A      Y     222          3.296
LGA    D   219_A      D     223          2.451
LGA    V   220_A      V     224          1.284
LGA    L   221_A      E     225          2.312
LGA    E   222_A      Q     226          3.522
LGA    V   223_A      W     227          2.847
LGA    T   224_A      C     228          0.863
LGA    X   225_A      K     229          2.797
LGA    X   226_A      L     230          3.872
LGA    F   227_A      N     231          2.878
LGA    M   228_A      L     232          1.214
LGA    R   229_A      D     233          1.143
LGA    D   230_A      N     234          1.177
LGA    P   231_A      V     235          1.737
LGA    I   232_A      I     236          1.842
LGA    R   233_A      S     237          1.695
LGA    I   234_A      V     238          0.886
LGA    L   235_A      S     239          1.168
LGA    V   236_A      I     240          0.558
LGA    X   237_A      G     241          1.029
LGA    X   238_A      A     242          1.780

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  216  240    5.0    207    1.86    27.54     77.680    10.535

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.569471 * X  +   0.735245 * Y  +  -0.367583 * Z  + -37.647305
  Y_new =   0.245145 * X  +   0.274922 * Y  +   0.929689 * Z  + -21.356628
  Z_new =   0.784606 * X  +  -0.619542 * Y  +  -0.023682 * Z  +   3.199915 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.609002    1.532591  [ DEG:   -92.1890     87.8110 ]
  Theta =  -0.902061   -2.239532  [ DEG:   -51.6843   -128.3157 ]
  Phi   =   0.406501   -2.735091  [ DEG:    23.2908   -156.7092 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2g9n_A                                        
REMARK     2: T0477.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2g9n_A.T0477.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  216  240   5.0  207   1.86   27.54  77.680
REMARK  ---------------------------------------------------------- 
MOLECULE 2g9n_A
HEADER    HYDROLASE                               07-MAR-06   2G9N              
TITLE     STRUCTURE OF THE DEAD DOMAIN OF HUMAN EUKARYOTIC INITIATION           
TITLE    2 FACTOR 4A, EIF4A                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: EUKARYOTIC INITIATION FACTOR 4A-I;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: DEAD DOMAIN;                                               
COMPND   5 SYNONYM: ATP-DEPENDENT RNA HELICASE EIF4A-1, EIF4A-I, EIF-           
COMPND   6 4A-I;                                                                
COMPND   7 EC: 3.6.1.-;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: EIF4A1, DDX2A, EIF4A;                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PNIC-28-BSA1                              
KEYWDS    DEAD-BOX, HELICASE, DDX2A, RNA, STRUCTURAL GENOMICS,                  
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, SGC                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.HOGBOM,D.OGG,C.ARROWSMITH,H.BERGLUND,R.COLLINS,A.EDWARDS,           
AUTHOR   2 M.EHN,S.FLODIN,A.FLORES,S.GRASLUND,B.M.HALLBERG,                     
AUTHOR   3 M.HAMMARSTROM,T.KOTENYOVA,P.NILSSON-EHLE,P.NORDLUND,T.NYMAN,         
AUTHOR   4 C.PERSSON,J.SAGEMARK,P.STENMARK,M.SUNDSTROM,A.G.THORSELL,            
AUTHOR   5 J.UPPENBERG,S.VAN DEN BERG,J.WEIGELT,L.HOLMBERG-SCHIAVONE,           
AUTHOR   6 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   14-MAR-06 2G9N    0                                                
JRNL        AUTH   M.HOGBOM,D.OGG,C.ARROWSMITH,H.BERGLUND,R.COLLINS,            
JRNL        AUTH 2 A.EDWARDS,M.EHN,S.FLODIN,A.FLORES,S.GRASLUND,                
JRNL        AUTH 3 B.M.HALLBERG,M.HAMMARSTROM,T.KOTENYOVA,                      
JRNL        AUTH 4 P.NILSSON-EHLE,P.NORDLUND,T.NYMAN,C.PERSSON,                 
JRNL        AUTH 5 J.SAGEMARK,P.STENMARK,M.SUNDSTROM,A.G.THORSELL,              
JRNL        AUTH 6 J.UPPENBERG,S.VAN DEN BERG,J.WEIGELT,                        
JRNL        AUTH 7 L.HOLMBERG-SCHIAVONE                                         
JRNL        TITL   STRUCTURE OF THE DEAD DOMAIN OF HUMAN DEAD-BOX               
JRNL        TITL 2 HELICASE DDX2A                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.25 ANGSTROMS.                                          
DBREF  2G9N A   20   238  UNP    P60842   IF4A1_HUMAN     20    236             
DBREF  2G9N B   20   238  UNP    P60842   IF4A1_HUMAN     20    236             
SEQRES   1 A  221  SER MET GLU GLY VAL ILE GLU SER ASN TRP ASN GLU ILE          
SEQRES   2 A  221  VAL ASP SER PHE ASP ASP MET ASN LEU SER GLU SER LEU          
SEQRES   3 A  221  LEU ARG GLY ILE TYR ALA TYR GLY PHE GLU MLY PRO SER          
SEQRES   4 A  221  ALA ILE GLN GLN ARG ALA ILE LEU PRO CYS ILE MLY GLY          
SEQRES   5 A  221  TYR ASP VAL ILE ALA GLN ALA GLN SER GLY THR GLY MLY          
SEQRES   6 A  221  THR ALA THR PHE ALA ILE SER ILE LEU GLN GLN ILE GLU          
SEQRES   7 A  221  LEU ASP LEU MLY ALA THR GLN ALA LEU VAL LEU ALA PRO          
SEQRES   8 A  221  THR ARG GLU LEU ALA GLN GLN ILE GLN MLY VAL VAL MET          
SEQRES   9 A  221  ALA LEU GLY ASP TYR MET GLY ALA SER CYS HIS ALA CYS          
SEQRES  10 A  221  ILE GLY GLY THR ASN VAL ARG ALA GLU VAL GLN MLY LEU          
SEQRES  11 A  221  GLN MET GLU ALA PRO HIS ILE ILE VAL GLY THR PRO GLY          
SEQRES  12 A  221  ARG VAL PHE ASP MET LEU ASN ARG ARG TYR LEU SER PRO          
SEQRES  13 A  221  MLY TYR ILE MLY MET PHE VAL LEU ASP GLU ALA ASP GLU          
SEQRES  14 A  221  MET LEU SER ARG GLY PHE MLY ASP GLN ILE TYR ASP ILE          
SEQRES  15 A  221  PHE GLN MLY LEU ASN SER ASN THR GLN VAL VAL LEU LEU          
SEQRES  16 A  221  SER ALA THR MET PRO SER ASP VAL LEU GLU VAL THR MLY          
SEQRES  17 A  221  MLY PHE MET ARG ASP PRO ILE ARG ILE LEU VAL MLY MLY          
SEQRES   1 B  221  SER MET GLU GLY VAL ILE GLU SER ASN TRP ASN GLU ILE          
SEQRES   2 B  221  VAL ASP SER PHE ASP ASP MET ASN LEU SER GLU SER LEU          
SEQRES   3 B  221  LEU ARG GLY ILE TYR ALA TYR GLY PHE GLU MLY PRO SER          
SEQRES   4 B  221  ALA ILE GLN GLN ARG ALA ILE LEU PRO CYS ILE MLY GLY          
SEQRES   5 B  221  TYR ASP VAL ILE ALA GLN ALA GLN SER GLY THR GLY MLY          
SEQRES   6 B  221  THR ALA THR PHE ALA ILE SER ILE LEU GLN GLN ILE GLU          
SEQRES   7 B  221  LEU ASP LEU MLY ALA THR GLN ALA LEU VAL LEU ALA PRO          
SEQRES   8 B  221  THR ARG GLU LEU ALA GLN GLN ILE GLN MLY VAL VAL MET          
SEQRES   9 B  221  ALA LEU GLY ASP TYR MET GLY ALA SER CYS HIS ALA CYS          
SEQRES  10 B  221  ILE GLY GLY THR ASN VAL ARG ALA GLU VAL GLN MLY LEU          
SEQRES  11 B  221  GLN MET GLU ALA PRO HIS ILE ILE VAL GLY THR PRO GLY          
SEQRES  12 B  221  ARG VAL PHE ASP MET LEU ASN ARG ARG TYR LEU SER PRO          
SEQRES  13 B  221  MLY TYR ILE MLY MET PHE VAL LEU ASP GLU ALA ASP GLU          
SEQRES  14 B  221  MET LEU SER ARG GLY PHE MLY ASP GLN ILE TYR ASP ILE          
SEQRES  15 B  221  PHE GLN MLY LEU ASN SER ASN THR GLN VAL VAL LEU LEU          
SEQRES  16 B  221  SER ALA THR MET PRO SER ASP VAL LEU GLU VAL THR MLY          
SEQRES  17 B  221  MLY PHE MET ARG ASP PRO ILE ARG ILE LEU VAL MLY MLY          
HET    MLY  A  54      11                                                       
HET    MLY  A  68      11                                                       
HET    MLY  A  82      11                                                       
HET    MLY  A  99      11                                                       
HET    MLY  A 118      11                                                       
HET    MLY  A 146      11                                                       
HET    MLY  A 174      11                                                       
HET    MLY  A 177      11                                                       
HET    MLY  A 193      11                                                       
HET    MLY  A 202      11                                                       
HET    MLY  A 225      11                                                       
HET    MLY  A 226      11                                                       
HET    MLY  A 237      11                                                       
HET    MLY  A 238      11                                                       
HET    MLY  B  54      11                                                       
HET    MLY  B  68      11                                                       
HET    MLY  B  82      11                                                       
HET    MLY  B  99      11                                                       
HET    MLY  B 118      11                                                       
HET    MLY  B 146      11                                                       
HET    MLY  B 174      11                                                       
HET    MLY  B 177      11                                                       
HET    MLY  B 193      11                                                       
HET    MLY  B 202      11                                                       
HET    MLY  B 225      11                                                       
HET    MLY  B 226      11                                                       
HET    MLY  B 237      11                                                       
HETNAM     MLY N-DIMETHYL-LYSINE                                                
FORMUL   1  MLY    27(C8 H18 N2 O2)                                             
FORMUL   3  HOH   *226(H2 O)                                                    
CRYST1   47.799   78.252   59.088  90.00 103.43  90.00 P 1 21 1      4          
ATOM      1  N   GLY A  21      -4.258  -6.350  26.442  1.00 28.03           N  
ATOM      2  CA  GLY A  21      -5.580  -5.751  26.047  1.00 29.97           C  
ATOM      3  C   GLY A  21      -5.601  -5.659  24.534  1.00 30.10           C  
ATOM      4  O   GLY A  21      -4.537  -5.822  23.947  1.00 30.58           O  
ATOM      5  N   VAL A  22      -6.763  -5.409  23.900  1.00 30.33           N  
ATOM      6  CA  VAL A  22      -6.899  -5.603  22.413  1.00 30.85           C  
ATOM      7  C   VAL A  22      -7.488  -4.439  21.548  1.00 30.54           C  
ATOM      8  O   VAL A  22      -8.638  -4.035  21.726  1.00 30.61           O  
ATOM      9  CB  VAL A  22      -7.561  -6.995  22.061  1.00 30.82           C  
ATOM     10  CG1 VAL A  22      -7.911  -7.117  20.562  1.00 31.38           C  
ATOM     11  CG2 VAL A  22      -6.628  -8.148  22.457  1.00 32.31           C  
ATOM     12  N   ILE A  23      -6.672  -3.942  20.604  1.00 30.03           N  
ATOM     13  CA  ILE A  23      -7.004  -2.809  19.710  1.00 29.42           C  
ATOM     14  C   ILE A  23      -7.551  -3.280  18.342  1.00 29.92           C  
ATOM     15  O   ILE A  23      -7.323  -4.434  17.943  1.00 30.25           O  
ATOM     16  CB  ILE A  23      -5.760  -1.857  19.481  1.00 29.89           C  
ATOM     17  CG1 ILE A  23      -4.642  -2.554  18.657  1.00 28.38           C  
ATOM     18  CG2 ILE A  23      -5.262  -1.262  20.821  1.00 28.99           C  
ATOM     19  CD1 ILE A  23      -3.425  -1.664  18.317  1.00 28.11           C  
ATOM     20  N   GLU A  24      -8.275  -2.412  17.630  1.00 29.62           N  
ATOM     21  CA  GLU A  24      -8.730  -2.756  16.276  1.00 29.78           C  
ATOM     22  C   GLU A  24      -7.908  -1.996  15.233  1.00 29.15           C  
ATOM     23  O   GLU A  24      -7.835  -0.763  15.283  1.00 28.92           O  
ATOM     24  CB  GLU A  24     -10.255  -2.560  16.084  1.00 29.63           C  
ATOM     25  CG  GLU A  24     -10.803  -3.049  14.701  1.00 30.23           C  
ATOM     26  CD  GLU A  24     -12.309  -3.422  14.690  1.00 31.26           C  
ATOM     27  OE1 GLU A  24     -12.924  -3.577  15.781  1.00 32.79           O  
ATOM     28  OE2 GLU A  24     -12.877  -3.580  13.572  1.00 32.16           O  
ATOM     29  N   SER A  25      -7.260  -2.765  14.343  1.00 28.45           N  
ATOM     30  CA  SER A  25      -6.539  -2.280  13.151  1.00 27.99           C  
ATOM     31  C   SER A  25      -7.392  -1.322  12.309  1.00 27.78           C  
ATOM     32  O   SER A  25      -8.626  -1.466  12.248  1.00 26.97           O  
ATOM     33  CB  SER A  25      -6.134  -3.448  12.237  1.00 28.05           C  
ATOM     34  OG  SER A  25      -5.102  -4.243  12.795  1.00 28.85           O  
ATOM     35  N   ASN A  26      -6.719  -0.377  11.650  1.00 26.70           N  
ATOM     36  CA  ASN A  26      -7.378   0.648  10.867  1.00 26.25           C  
ATOM     37  C   ASN A  26      -6.622   1.128   9.626  1.00 27.08           C  
ATOM     38  O   ASN A  26      -7.089   2.041   8.940  1.00 27.29           O  
ATOM     39  CB  ASN A  26      -7.778   1.828  11.762  1.00 25.48           C  
ATOM     40  CG  ASN A  26      -6.607   2.737  12.109  1.00 23.17           C  
ATOM     41  OD1 ASN A  26      -5.446   2.401  11.884  1.00 18.11           O  
ATOM     42  ND2 ASN A  26      -6.917   3.910  12.667  1.00 21.64           N  
ATOM     43  N   TRP A  27      -5.462   0.539   9.335  1.00 28.37           N  
ATOM     44  CA  TRP A  27      -4.688   0.952   8.154  1.00 30.26           C  
ATOM     45  C   TRP A  27      -4.719  -0.090   7.030  1.00 31.11           C  
ATOM     46  O   TRP A  27      -4.917  -1.280   7.276  1.00 30.83           O  
ATOM     47  CB  TRP A  27      -3.254   1.372   8.501  1.00 30.52           C  
ATOM     48  CG  TRP A  27      -2.617   2.367   7.498  1.00 31.15           C  
ATOM     49  CD1 TRP A  27      -1.390   2.239   6.883  1.00 30.26           C  
ATOM     50  CD2 TRP A  27      -3.176   3.618   7.014  1.00 31.22           C  
ATOM     51  NE1 TRP A  27      -1.162   3.316   6.054  1.00 31.66           N  
ATOM     52  CE2 TRP A  27      -2.231   4.178   6.112  1.00 31.55           C  
ATOM     53  CE3 TRP A  27      -4.381   4.317   7.252  1.00 32.77           C  
ATOM     54  CZ2 TRP A  27      -2.456   5.412   5.440  1.00 31.24           C  
ATOM     55  CZ3 TRP A  27      -4.606   5.555   6.575  1.00 31.01           C  
ATOM     56  CH2 TRP A  27      -3.642   6.080   5.681  1.00 30.33           C  
ATOM     57  N   ASN A  28      -4.551   0.407   5.804  1.00 32.13           N  
ATOM     58  CA  ASN A  28      -4.695  -0.355   4.563  1.00 33.11           C  
ATOM     59  C   ASN A  28      -3.410  -1.020   4.028  1.00 33.05           C  
ATOM     60  O   ASN A  28      -3.385  -2.240   3.847  1.00 33.35           O  
ATOM     61  CB  ASN A  28      -5.370   0.514   3.470  1.00 34.03           C  
ATOM     62  CG  ASN A  28      -5.221   2.052   3.719  1.00 36.15           C  
ATOM     63  OD1 ASN A  28      -5.497   2.561   4.825  1.00 36.54           O  
ATOM     64  ND2 ASN A  28      -4.814   2.785   2.672  1.00 37.02           N  
ATOM     65  N   GLU A  29      -2.351  -0.232   3.804  1.00 32.22           N  
ATOM     66  CA  GLU A  29      -1.168  -0.701   3.086  1.00 31.99           C  
ATOM     67  C   GLU A  29      -0.534  -1.936   3.715  1.00 30.68           C  
ATOM     68  O   GLU A  29      -0.437  -2.031   4.938  1.00 31.21           O  
ATOM     69  CB  GLU A  29      -0.077   0.375   2.990  1.00 32.25           C  
ATOM     70  CG  GLU A  29      -0.446   1.814   3.332  1.00 34.46           C  
ATOM     71  CD  GLU A  29       0.799   2.702   3.411  1.00 34.70           C  
ATOM     72  OE1 GLU A  29       1.015   3.362   4.462  1.00 36.38           O  
ATOM     73  OE2 GLU A  29       1.573   2.721   2.412  1.00 39.20           O  
ATOM     74  N   ILE A  30      -0.127  -2.884   2.869  1.00 28.62           N  
ATOM     75  CA  ILE A  30       0.796  -3.957   3.245  1.00 26.76           C  
ATOM     76  C   ILE A  30       1.887  -4.034   2.168  1.00 24.55           C  
ATOM     77  O   ILE A  30       1.608  -3.904   0.983  1.00 24.46           O  
ATOM     78  CB  ILE A  30       0.091  -5.312   3.497  1.00 26.79           C  
ATOM     79  CG1 ILE A  30      -0.804  -5.219   4.733  1.00 28.23           C  
ATOM     80  CG2 ILE A  30       1.118  -6.435   3.697  1.00 26.89           C  
ATOM     81  CD1 ILE A  30      -1.566  -6.512   5.110  1.00 28.13           C  
ATOM     82  N   VAL A  31       3.131  -4.172   2.597  1.00 22.42           N  
ATOM     83  CA  VAL A  31       4.282  -4.174   1.708  1.00 20.37           C  
ATOM     84  C   VAL A  31       5.173  -5.362   2.082  1.00 19.11           C  
ATOM     85  O   VAL A  31       5.720  -5.406   3.174  1.00 19.56           O  
ATOM     86  CB  VAL A  31       5.082  -2.879   1.886  1.00 21.03           C  
ATOM     87  CG1 VAL A  31       6.210  -2.788   0.877  1.00 18.83           C  
ATOM     88  CG2 VAL A  31       4.159  -1.705   1.780  1.00 20.65           C  
ATOM     89  N   ASP A  32       5.359  -6.293   1.159  1.00 17.52           N  
ATOM     90  CA  ASP A  32       5.978  -7.574   1.482  1.00 15.27           C  
ATOM     91  C   ASP A  32       7.490  -7.639   1.197  1.00 14.04           C  
ATOM     92  O   ASP A  32       8.135  -8.686   1.393  1.00 13.79           O  
ATOM     93  CB  ASP A  32       5.188  -8.742   0.849  1.00 14.49           C  
ATOM     94  CG  ASP A  32       5.338  -8.843  -0.679  1.00 14.20           C  
ATOM     95  OD1 ASP A  32       6.057  -8.067  -1.335  1.00 10.06           O  
ATOM     96  OD2 ASP A  32       4.727  -9.770  -1.241  1.00 16.36           O  
ATOM     97  N   SER A  33       8.035  -6.506   0.760  1.00 11.95           N  
ATOM     98  CA  SER A  33       9.430  -6.397   0.379  1.00 10.36           C  
ATOM     99  C   SER A  33      10.036  -5.075   0.861  1.00  9.86           C  
ATOM    100  O   SER A  33       9.425  -4.027   0.710  1.00 10.66           O  
ATOM    101  CB  SER A  33       9.549  -6.530  -1.142  1.00 10.13           C  
ATOM    102  OG  SER A  33      10.876  -6.365  -1.526  1.00  6.53           O  
ATOM    103  N   PHE A  34      11.212  -5.134   1.483  1.00  9.45           N  
ATOM    104  CA  PHE A  34      11.987  -3.929   1.826  1.00  9.02           C  
ATOM    105  C   PHE A  34      12.398  -3.152   0.555  1.00  9.54           C  
ATOM    106  O   PHE A  34      12.615  -1.952   0.628  1.00 10.17           O  
ATOM    107  CB  PHE A  34      13.252  -4.266   2.592  1.00  6.82           C  
ATOM    108  CG  PHE A  34      13.034  -4.888   3.948  1.00  6.52           C  
ATOM    109  CD1 PHE A  34      12.435  -4.167   4.990  1.00  4.12           C  
ATOM    110  CD2 PHE A  34      13.526  -6.164   4.222  1.00  3.06           C  
ATOM    111  CE1 PHE A  34      12.294  -4.723   6.228  1.00  3.27           C  
ATOM    112  CE2 PHE A  34      13.341  -6.737   5.465  1.00  4.02           C  
ATOM    113  CZ  PHE A  34      12.737  -6.018   6.473  1.00  2.13           C  
ATOM    114  N   ASP A  35      12.546  -3.833  -0.586  1.00 10.49           N  
ATOM    115  CA  ASP A  35      12.726  -3.153  -1.907  1.00 12.06           C  
ATOM    116  C   ASP A  35      11.638  -2.108  -2.272  1.00 12.10           C  
ATOM    117  O   ASP A  35      11.885  -1.207  -3.086  1.00 11.42           O  
ATOM    118  CB  ASP A  35      12.663  -4.163  -3.030  1.00 12.44           C  
ATOM    119  CG  ASP A  35      13.798  -5.163  -3.016  1.00 16.47           C  
ATOM    120  OD1 ASP A  35      14.855  -4.946  -2.354  1.00 15.93           O  
ATOM    121  OD2 ASP A  35      13.590  -6.184  -3.710  1.00 20.36           O  
ATOM    122  N   ASP A  36      10.433  -2.290  -1.711  1.00 12.10           N  
ATOM    123  CA  ASP A  36       9.234  -1.546  -2.090  1.00 12.68           C  
ATOM    124  C   ASP A  36       8.833  -0.464  -1.098  1.00 12.11           C  
ATOM    125  O   ASP A  36       7.735   0.061  -1.166  1.00 11.97           O  
ATOM    126  CB  ASP A  36       8.064  -2.526  -2.286  1.00 13.16           C  
ATOM    127  CG  ASP A  36       8.304  -3.499  -3.427  1.00 15.80           C  
ATOM    128  OD1 ASP A  36       9.154  -3.207  -4.311  1.00 17.90           O  
ATOM    129  OD2 ASP A  36       7.644  -4.566  -3.439  1.00 18.24           O  
ATOM    130  N   MET A  37       9.715  -0.140  -0.163  1.00 11.97           N  
ATOM    131  CA  MET A  37       9.357   0.780   0.883  1.00 12.45           C  
ATOM    132  C   MET A  37       9.885   2.199   0.661  1.00 12.04           C  
ATOM    133  O   MET A  37       9.840   3.020   1.562  1.00 11.74           O  
ATOM    134  CB  MET A  37       9.831   0.239   2.232  1.00 12.38           C  
ATOM    135  CG  MET A  37       8.963  -0.873   2.785  1.00 12.97           C  
ATOM    136  SD  MET A  37       9.741  -1.642   4.199  1.00 13.91           S  
ATOM    137  CE  MET A  37       8.642  -3.011   4.468  1.00  9.04           C  
ATOM    138  N   ASN A  38      10.432   2.461  -0.517  1.00 12.72           N  
ATOM    139  CA  ASN A  38      11.053   3.747  -0.812  1.00 13.16           C  
ATOM    140  C   ASN A  38      12.214   4.108   0.093  1.00 11.69           C  
ATOM    141  O   ASN A  38      12.371   5.287   0.440  1.00 11.28           O  
ATOM    142  CB  ASN A  38      10.028   4.879  -0.687  1.00 14.06           C  
ATOM    143  CG  ASN A  38       9.284   5.099  -1.917  1.00 18.42           C  
ATOM    144  OD1 ASN A  38       8.048   5.071  -1.915  1.00 23.01           O  
ATOM    145  ND2 ASN A  38      10.013   5.307  -3.022  1.00 23.37           N  
ATOM    146  N   LEU A  39      13.019   3.141   0.485  1.00 10.16           N  
ATOM    147  CA  LEU A  39      14.085   3.460   1.426  1.00  9.76           C  
ATOM    148  C   LEU A  39      15.245   4.055   0.672  1.00 10.11           C  
ATOM    149  O   LEU A  39      15.355   3.882  -0.545  1.00 10.48           O  
ATOM    150  CB  LEU A  39      14.462   2.255   2.309  1.00  8.33           C  
ATOM    151  CG  LEU A  39      13.254   1.631   3.025  1.00  6.54           C  
ATOM    152  CD1 LEU A  39      13.635   0.300   3.650  1.00  2.00           C  
ATOM    153  CD2 LEU A  39      12.508   2.536   4.068  1.00  2.00           C  
ATOM    154  N   SER A  40      16.099   4.806   1.359  1.00 11.30           N  
ATOM    155  CA  SER A  40      17.283   5.303   0.654  1.00 11.44           C  
ATOM    156  C   SER A  40      18.130   4.079   0.334  1.00 11.54           C  
ATOM    157  O   SER A  40      18.055   3.047   1.043  1.00 11.43           O  
ATOM    158  CB  SER A  40      18.047   6.373   1.449  1.00 11.22           C  
ATOM    159  OG  SER A  40      19.195   5.864   2.096  1.00 12.31           O  
ATOM    160  N   GLU A  41      18.868   4.159  -0.770  1.00 11.60           N  
ATOM    161  CA  GLU A  41      19.666   3.050  -1.236  1.00 11.84           C  
ATOM    162  C   GLU A  41      20.585   2.455  -0.166  1.00 11.47           C  
ATOM    163  O   GLU A  41      20.702   1.232  -0.064  1.00 11.95           O  
ATOM    164  CB  GLU A  41      20.471   3.462  -2.451  1.00 12.15           C  
ATOM    165  CG  GLU A  41      19.736   3.292  -3.769  1.00 16.44           C  
ATOM    166  CD  GLU A  41      20.481   3.940  -4.920  1.00 23.93           C  
ATOM    167  OE1 GLU A  41      21.733   3.819  -4.983  1.00 26.75           O  
ATOM    168  OE2 GLU A  41      19.818   4.581  -5.767  1.00 27.45           O  
ATOM    169  N   SER A  42      21.242   3.298   0.623  1.00 10.55           N  
ATOM    170  CA  SER A  42      22.177   2.758   1.590  1.00 10.64           C  
ATOM    171  C   SER A  42      21.518   2.316   2.894  1.00 10.41           C  
ATOM    172  O   SER A  42      22.072   1.493   3.602  1.00 11.41           O  
ATOM    173  CB  SER A  42      23.393   3.667   1.797  1.00 10.75           C  
ATOM    174  OG  SER A  42      23.015   4.976   2.077  1.00 13.26           O  
ATOM    175  N   LEU A  43      20.328   2.823   3.196  1.00  8.99           N  
ATOM    176  CA  LEU A  43      19.527   2.203   4.233  1.00  9.41           C  
ATOM    177  C   LEU A  43      19.202   0.758   3.811  1.00  9.01           C  
ATOM    178  O   LEU A  43      19.512  -0.162   4.540  1.00  9.85           O  
ATOM    179  CB  LEU A  43      18.260   3.019   4.580  1.00  7.85           C  
ATOM    180  CG  LEU A  43      17.403   2.413   5.710  1.00 10.19           C  
ATOM    181  CD1 LEU A  43      18.254   1.948   6.933  1.00  4.48           C  
ATOM    182  CD2 LEU A  43      16.250   3.356   6.085  1.00  8.80           C  
ATOM    183  N   LEU A  44      18.651   0.575   2.613  1.00  9.43           N  
ATOM    184  CA  LEU A  44      18.373  -0.747   2.092  1.00  9.01           C  
ATOM    185  C   LEU A  44      19.617  -1.650   2.074  1.00 10.02           C  
ATOM    186  O   LEU A  44      19.544  -2.802   2.516  1.00 10.10           O  
ATOM    187  CB  LEU A  44      17.703  -0.677   0.723  1.00  8.44           C  
ATOM    188  CG  LEU A  44      17.241  -2.026   0.152  1.00  8.17           C  
ATOM    189  CD1 LEU A  44      16.183  -2.600   1.083  1.00  8.35           C  
ATOM    190  CD2 LEU A  44      16.676  -1.878  -1.264  1.00  8.34           C  
ATOM    191  N   ARG A  45      20.749  -1.145   1.565  1.00  9.75           N  
ATOM    192  CA  ARG A  45      21.999  -1.905   1.625  1.00  9.89           C  
ATOM    193  C   ARG A  45      22.289  -2.317   3.069  1.00  9.87           C  
ATOM    194  O   ARG A  45      22.636  -3.480   3.316  1.00  9.90           O  
ATOM    195  CB  ARG A  45      23.192  -1.161   0.984  1.00  9.02           C  
ATOM    196  CG  ARG A  45      23.326  -1.483  -0.477  1.00 12.14           C  
ATOM    197  CD  ARG A  45      24.577  -0.917  -1.222  1.00 10.94           C  
ATOM    198  NE  ARG A  45      24.387   0.499  -1.489  1.00 16.52           N  
ATOM    199  CZ  ARG A  45      23.892   1.005  -2.612  1.00 16.00           C  
ATOM    200  NH1 ARG A  45      23.577   0.204  -3.622  1.00 15.20           N  
ATOM    201  NH2 ARG A  45      23.748   2.323  -2.728  1.00 15.47           N  
ATOM    202  N   GLY A  46      22.123  -1.371   4.011  1.00  9.53           N  
ATOM    203  CA  GLY A  46      22.347  -1.611   5.453  1.00  8.44           C  
ATOM    204  C   GLY A  46      21.479  -2.733   6.027  1.00  8.00           C  
ATOM    205  O   GLY A  46      21.975  -3.611   6.747  1.00  6.33           O  
ATOM    206  N   ILE A  47      20.172  -2.680   5.715  1.00  8.23           N  
ATOM    207  CA  ILE A  47      19.195  -3.741   6.049  1.00  7.21           C  
ATOM    208  C   ILE A  47      19.616  -5.127   5.509  1.00  7.75           C  
ATOM    209  O   ILE A  47      19.564  -6.110   6.229  1.00  8.49           O  
ATOM    210  CB  ILE A  47      17.807  -3.355   5.519  1.00  7.58           C  
ATOM    211  CG1 ILE A  47      17.228  -2.178   6.311  1.00  6.13           C  
ATOM    212  CG2 ILE A  47      16.780  -4.538   5.580  1.00  7.31           C  
ATOM    213  CD1 ILE A  47      16.023  -1.565   5.568  1.00  2.00           C  
ATOM    214  N   TYR A  48      20.027  -5.197   4.251  1.00  7.07           N  
ATOM    215  CA  TYR A  48      20.443  -6.462   3.688  1.00  8.53           C  
ATOM    216  C   TYR A  48      21.825  -6.937   4.187  1.00  9.12           C  
ATOM    217  O   TYR A  48      22.054  -8.166   4.351  1.00  9.05           O  
ATOM    218  CB  TYR A  48      20.334  -6.436   2.158  1.00  8.78           C  
ATOM    219  CG  TYR A  48      18.897  -6.457   1.608  1.00  8.27           C  
ATOM    220  CD1 TYR A  48      17.868  -7.161   2.268  1.00  7.34           C  
ATOM    221  CD2 TYR A  48      18.604  -5.866   0.382  1.00  8.29           C  
ATOM    222  CE1 TYR A  48      16.551  -7.189   1.749  1.00  8.01           C  
ATOM    223  CE2 TYR A  48      17.313  -5.907  -0.168  1.00 10.16           C  
ATOM    224  CZ  TYR A  48      16.282  -6.571   0.521  1.00 10.47           C  
ATOM    225  OH  TYR A  48      15.014  -6.634  -0.049  1.00  8.72           O  
ATOM    226  N   ALA A  49      22.726  -5.984   4.473  1.00  8.39           N  
ATOM    227  CA  ALA A  49      24.052  -6.340   4.986  1.00  8.34           C  
ATOM    228  C   ALA A  49      23.938  -6.896   6.383  1.00  8.12           C  
ATOM    229  O   ALA A  49      24.762  -7.701   6.802  1.00  8.62           O  
ATOM    230  CB  ALA A  49      25.034  -5.163   4.940  1.00  7.26           C  
ATOM    231  N   TYR A  50      22.923  -6.455   7.100  1.00  8.58           N  
ATOM    232  CA  TYR A  50      22.640  -6.928   8.438  1.00  9.43           C  
ATOM    233  C   TYR A  50      22.143  -8.401   8.421  1.00  9.76           C  
ATOM    234  O   TYR A  50      22.555  -9.219   9.229  1.00 10.06           O  
ATOM    235  CB  TYR A  50      21.601  -5.990   9.091  1.00  9.69           C  
ATOM    236  CG  TYR A  50      21.356  -6.273  10.557  1.00 12.10           C  
ATOM    237  CD1 TYR A  50      21.933  -5.475  11.544  1.00 12.50           C  
ATOM    238  CD2 TYR A  50      20.556  -7.358  10.959  1.00 12.78           C  
ATOM    239  CE1 TYR A  50      21.731  -5.745  12.877  1.00 11.83           C  
ATOM    240  CE2 TYR A  50      20.355  -7.642  12.301  1.00 13.55           C  
ATOM    241  CZ  TYR A  50      20.945  -6.819  13.254  1.00 13.45           C  
ATOM    242  OH  TYR A  50      20.739  -7.075  14.596  1.00 15.07           O  
ATOM    243  N   GLY A  51      21.235  -8.719   7.508  1.00  9.76           N  
ATOM    244  CA  GLY A  51      20.773 -10.081   7.359  1.00  9.40           C  
ATOM    245  C   GLY A  51      19.271 -10.206   7.379  1.00  9.28           C  
ATOM    246  O   GLY A  51      18.752 -11.325   7.334  1.00  9.54           O  
ATOM    247  N   PHE A  52      18.574  -9.075   7.431  1.00  8.04           N  
ATOM    248  CA  PHE A  52      17.139  -9.090   7.172  1.00  8.49           C  
ATOM    249  C   PHE A  52      16.879  -9.574   5.778  1.00  8.39           C  
ATOM    250  O   PHE A  52      17.668  -9.322   4.856  1.00  8.94           O  
ATOM    251  CB  PHE A  52      16.497  -7.722   7.394  1.00  8.69           C  
ATOM    252  CG  PHE A  52      16.599  -7.244   8.803  1.00  9.71           C  
ATOM    253  CD1 PHE A  52      15.801  -7.779   9.799  1.00 12.37           C  
ATOM    254  CD2 PHE A  52      17.519  -6.268   9.149  1.00 10.25           C  
ATOM    255  CE1 PHE A  52      15.903  -7.330  11.131  1.00  8.11           C  
ATOM    256  CE2 PHE A  52      17.619  -5.828  10.462  1.00 12.01           C  
ATOM    257  CZ  PHE A  52      16.814  -6.386  11.456  1.00 10.54           C  
ATOM    258  N   GLU A  53      15.819 -10.353   5.642  1.00  8.45           N  
ATOM    259  CA  GLU A  53      15.414 -10.884   4.334  1.00  9.44           C  
ATOM    260  C   GLU A  53      14.110 -10.204   3.935  1.00  8.55           C  
ATOM    261  O   GLU A  53      14.139  -9.216   3.213  1.00  9.51           O  
ATOM    262  CB  GLU A  53      15.237 -12.417   4.350  1.00  9.00           C  
ATOM    263  CG  GLU A  53      16.456 -13.258   4.050  1.00 11.58           C  
ATOM    264  CD  GLU A  53      16.936 -13.157   2.616  1.00 14.02           C  
ATOM    265  OE1 GLU A  53      16.352 -13.800   1.725  1.00 13.94           O  
ATOM    266  OE2 GLU A  53      17.932 -12.447   2.387  1.00 14.80           O  
HETATM  267  N   MLY A  54      12.985 -10.794   4.323  1.00  7.17           N  
HETATM  268  CA  MLY A  54      11.689 -10.288   3.832  1.00  8.45           C  
HETATM  269  CB  MLY A  54      10.818 -11.421   3.161  1.00  8.97           C  
HETATM  270  CG  MLY A  54      11.529 -11.989   1.902  1.00 10.44           C  
HETATM  271  CD  MLY A  54      10.615 -12.352   0.721  1.00 14.81           C  
HETATM  272  CE  MLY A  54       9.979 -11.122   0.113  1.00 17.73           C  
HETATM  273  NZ  MLY A  54       9.869 -11.084  -1.365  1.00 20.54           N  
HETATM  274  CH1 MLY A  54      10.007 -12.356  -2.092  1.00 20.22           C  
HETATM  275  CH2 MLY A  54       8.550 -10.502  -1.683  1.00 20.13           C  
HETATM  276  C   MLY A  54      10.964  -9.699   5.035  1.00  7.82           C  
HETATM  277  O   MLY A  54      11.105 -10.257   6.144  1.00  7.51           O  
ATOM    278  N   PRO A  55      10.168  -8.661   5.041  1.00  6.87           N  
ATOM    279  CA  PRO A  55       9.524  -8.126   6.229  1.00  6.61           C  
ATOM    280  C   PRO A  55       8.494  -9.077   6.877  1.00  6.53           C  
ATOM    281  O   PRO A  55       7.734  -9.784   6.189  1.00  6.82           O  
ATOM    282  CB  PRO A  55       8.871  -6.814   5.740  1.00  5.31           C  
ATOM    283  CG  PRO A  55       9.109  -6.707   4.343  1.00  6.00           C  
ATOM    284  CD  PRO A  55       9.866  -7.887   3.823  1.00  7.50           C  
ATOM    285  N   SER A  56       8.508  -9.116   8.205  1.00  6.45           N  
ATOM    286  CA  SER A  56       7.490  -9.828   8.996  1.00  6.98           C  
ATOM    287  C   SER A  56       6.157  -9.028   8.955  1.00  6.69           C  
ATOM    288  O   SER A  56       6.155  -7.881   8.490  1.00  5.28           O  
ATOM    289  CB  SER A  56       7.985  -9.947  10.448  1.00  5.89           C  
ATOM    290  OG  SER A  56       8.073  -8.666  11.057  1.00  8.18           O  
ATOM    291  N   ALA A  57       5.059  -9.588   9.486  1.00  6.62           N  
ATOM    292  CA  ALA A  57       3.752  -8.879   9.444  1.00  7.90           C  
ATOM    293  C   ALA A  57       3.832  -7.453   9.998  1.00  8.53           C  
ATOM    294  O   ALA A  57       3.359  -6.518   9.361  1.00  9.09           O  
ATOM    295  CB  ALA A  57       2.624  -9.666  10.127  1.00  6.52           C  
ATOM    296  N   ILE A  58       4.454  -7.275  11.157  1.00  9.16           N  
ATOM    297  CA  ILE A  58       4.610  -5.922  11.725  1.00  9.43           C  
ATOM    298  C   ILE A  58       5.360  -4.954  10.804  1.00  9.63           C  
ATOM    299  O   ILE A  58       4.952  -3.806  10.626  1.00 11.38           O  
ATOM    300  CB  ILE A  58       5.153  -5.947  13.212  1.00  9.70           C  
ATOM    301  CG1 ILE A  58       4.896  -4.610  13.922  1.00 11.42           C  
ATOM    302  CG2 ILE A  58       6.627  -6.253  13.296  1.00  6.24           C  
ATOM    303  CD1 ILE A  58       3.544  -4.097  13.811  1.00 13.51           C  
ATOM    304  N   GLN A  59       6.443  -5.416  10.201  1.00  9.04           N  
ATOM    305  CA  GLN A  59       7.251  -4.599   9.331  1.00  8.57           C  
ATOM    306  C   GLN A  59       6.512  -4.281   8.038  1.00  9.77           C  
ATOM    307  O   GLN A  59       6.654  -3.163   7.506  1.00 11.51           O  
ATOM    308  CB  GLN A  59       8.583  -5.297   9.036  1.00  8.36           C  
ATOM    309  CG  GLN A  59       9.470  -5.468  10.292  1.00  7.62           C  
ATOM    310  CD  GLN A  59      10.513  -6.595  10.174  1.00  7.14           C  
ATOM    311  OE1 GLN A  59      10.633  -7.260   9.145  1.00  7.73           O  
ATOM    312  NE2 GLN A  59      11.265  -6.804  11.239  1.00  8.06           N  
ATOM    313  N   GLN A  60       5.691  -5.227   7.566  1.00  9.11           N  
ATOM    314  CA  GLN A  60       4.946  -5.065   6.341  1.00  9.98           C  
ATOM    315  C   GLN A  60       3.886  -3.997   6.458  1.00 10.87           C  
ATOM    316  O   GLN A  60       3.544  -3.371   5.465  1.00 11.21           O  
ATOM    317  CB  GLN A  60       4.276  -6.373   5.910  1.00  9.92           C  
ATOM    318  CG  GLN A  60       5.209  -7.505   5.561  1.00  8.01           C  
ATOM    319  CD  GLN A  60       4.469  -8.816   5.373  1.00 10.13           C  
ATOM    320  OE1 GLN A  60       3.257  -8.837   5.232  1.00 12.78           O  
ATOM    321  NE2 GLN A  60       5.198  -9.909   5.355  1.00  9.19           N  
ATOM    322  N   ARG A  61       3.373  -3.804   7.672  1.00 11.81           N  
ATOM    323  CA  ARG A  61       2.242  -2.913   7.954  1.00 12.10           C  
ATOM    324  C   ARG A  61       2.630  -1.533   8.537  1.00 11.67           C  
ATOM    325  O   ARG A  61       1.977  -0.532   8.252  1.00 10.90           O  
ATOM    326  CB  ARG A  61       1.290  -3.613   8.937  1.00 11.83           C  
ATOM    327  CG  ARG A  61       0.525  -4.755   8.351  1.00 14.14           C  
ATOM    328  CD  ARG A  61       0.209  -5.740   9.428  1.00 20.94           C  
ATOM    329  NE  ARG A  61      -0.722  -6.778   8.988  1.00 25.77           N  
ATOM    330  CZ  ARG A  61      -0.435  -7.777   8.154  1.00 28.31           C  
ATOM    331  NH1 ARG A  61       0.775  -7.915   7.607  1.00 29.00           N  
ATOM    332  NH2 ARG A  61      -1.391  -8.634   7.841  1.00 29.37           N  
ATOM    333  N   ALA A  62       3.675  -1.509   9.364  1.00 11.00           N  
ATOM    334  CA  ALA A  62       3.947  -0.362  10.222  1.00 10.97           C  
ATOM    335  C   ALA A  62       5.052   0.567   9.719  1.00 10.87           C  
ATOM    336  O   ALA A  62       5.053   1.748  10.050  1.00  9.82           O  
ATOM    337  CB  ALA A  62       4.245  -0.809  11.675  1.00  9.82           C  
ATOM    338  N   ILE A  63       6.012   0.022   8.968  1.00 10.52           N  
ATOM    339  CA  ILE A  63       7.133   0.825   8.501  1.00 10.00           C  
ATOM    340  C   ILE A  63       6.679   2.007   7.653  1.00 10.39           C  
ATOM    341  O   ILE A  63       7.116   3.151   7.886  1.00 10.77           O  
ATOM    342  CB  ILE A  63       8.229   0.013   7.782  1.00  9.70           C  
ATOM    343  CG1 ILE A  63       8.994  -0.864   8.792  1.00  9.25           C  
ATOM    344  CG2 ILE A  63       9.255   0.969   7.046  1.00  9.59           C  
ATOM    345  CD1 ILE A  63      10.128  -1.752   8.177  1.00  9.15           C  
ATOM    346  N   LEU A  64       5.791   1.764   6.705  1.00 10.34           N  
ATOM    347  CA  LEU A  64       5.369   2.841   5.815  1.00 11.28           C  
ATOM    348  C   LEU A  64       4.620   4.011   6.474  1.00 11.55           C  
ATOM    349  O   LEU A  64       4.929   5.162   6.156  1.00 11.28           O  
ATOM    350  CB  LEU A  64       4.663   2.313   4.550  1.00 11.43           C  
ATOM    351  CG  LEU A  64       5.699   1.642   3.626  1.00 13.91           C  
ATOM    352  CD1 LEU A  64       5.044   0.889   2.503  1.00 14.83           C  
ATOM    353  CD2 LEU A  64       6.678   2.668   3.035  1.00 14.43           C  
ATOM    354  N   PRO A  65       3.598   3.731   7.331  1.00 11.55           N  
ATOM    355  CA  PRO A  65       2.994   4.846   8.075  1.00 11.72           C  
ATOM    356  C   PRO A  65       3.924   5.553   9.084  1.00 11.27           C  
ATOM    357  O   PRO A  65       3.800   6.746   9.257  1.00 11.16           O  
ATOM    358  CB  PRO A  65       1.745   4.225   8.749  1.00 11.26           C  
ATOM    359  CG  PRO A  65       1.921   2.789   8.684  1.00 11.26           C  
ATOM    360  CD  PRO A  65       2.900   2.456   7.598  1.00 11.16           C  
ATOM    361  N   CYS A  66       4.868   4.853   9.697  1.00 11.28           N  
ATOM    362  CA  CYS A  66       5.847   5.533  10.535  1.00 11.76           C  
ATOM    363  C   CYS A  66       6.701   6.496   9.722  1.00 12.07           C  
ATOM    364  O   CYS A  66       6.907   7.634  10.170  1.00 12.18           O  
ATOM    365  CB  CYS A  66       6.767   4.588  11.295  1.00 10.88           C  
ATOM    366  SG  CYS A  66       5.998   3.538  12.559  1.00 15.63           S  
ATOM    367  N   ILE A  67       7.219   6.050   8.571  1.00 11.07           N  
ATOM    368  CA  ILE A  67       8.019   6.925   7.713  1.00 12.20           C  
ATOM    369  C   ILE A  67       7.226   8.113   7.182  1.00 13.25           C  
ATOM    370  O   ILE A  67       7.740   9.239   7.287  1.00 13.81           O  
ATOM    371  CB  ILE A  67       8.694   6.191   6.531  1.00 12.12           C  
ATOM    372  CG1 ILE A  67       9.851   5.365   7.040  1.00 11.13           C  
ATOM    373  CG2 ILE A  67       9.269   7.186   5.520  1.00 12.83           C  
ATOM    374  CD1 ILE A  67      10.314   4.341   6.081  1.00 14.57           C  
HETATM  375  N   MLY A  68       5.922   7.980   6.812  1.00 13.02           N  
HETATM  376  CA  MLY A  68       4.929   9.003   6.420  1.00 13.93           C  
HETATM  377  CB  MLY A  68       3.575   8.385   6.037  1.00 14.45           C  
HETATM  378  CG  MLY A  68       3.155   8.663   4.583  1.00 17.32           C  
HETATM  379  CD  MLY A  68       2.679  10.116   4.372  1.00 21.43           C  
HETATM  380  CE  MLY A  68       3.350  10.868   3.197  1.00 23.91           C  
HETATM  381  NZ  MLY A  68       2.431  11.090   2.047  1.00 25.08           N  
HETATM  382  CH1 MLY A  68       1.640  12.343   2.089  1.00 23.74           C  
HETATM  383  CH2 MLY A  68       3.248  11.103   0.829  1.00 25.16           C  
HETATM  384  C   MLY A  68       4.692   9.985   7.591  1.00 13.00           C  
HETATM  385  O   MLY A  68       4.394  11.166   7.328  1.00 12.79           O  
ATOM    386  N   GLY A  69       5.031   9.605   8.824  1.00  9.48           N  
ATOM    387  CA  GLY A  69       4.911  10.704   9.793  1.00  7.44           C  
ATOM    388  C   GLY A  69       3.693  10.558  10.655  1.00  7.41           C  
ATOM    389  O   GLY A  69       3.403  11.478  11.401  1.00  6.03           O  
ATOM    390  N   TYR A  70       2.980   9.419  10.580  1.00  6.47           N  
ATOM    391  CA  TYR A  70       1.684   9.308  11.294  1.00  7.26           C  
ATOM    392  C   TYR A  70       1.889   8.809  12.685  1.00  6.76           C  
ATOM    393  O   TYR A  70       2.811   8.060  12.917  1.00  8.10           O  
ATOM    394  CB  TYR A  70       0.697   8.351  10.608  1.00  6.64           C  
ATOM    395  CG  TYR A  70       0.298   8.725   9.209  1.00  8.80           C  
ATOM    396  CD1 TYR A  70       0.133  10.057   8.832  1.00  8.28           C  
ATOM    397  CD2 TYR A  70       0.065   7.738   8.239  1.00 10.02           C  
ATOM    398  CE1 TYR A  70      -0.265  10.402   7.528  1.00  5.03           C  
ATOM    399  CE2 TYR A  70      -0.331   8.081   6.951  1.00  7.67           C  
ATOM    400  CZ  TYR A  70      -0.484   9.413   6.598  1.00  6.20           C  
ATOM    401  OH  TYR A  70      -0.892   9.750   5.293  1.00  9.26           O  
ATOM    402  N   ASP A  71       1.034   9.185  13.623  1.00  7.16           N  
ATOM    403  CA  ASP A  71       1.112   8.554  14.954  1.00  8.11           C  
ATOM    404  C   ASP A  71       0.746   7.069  14.794  1.00  8.54           C  
ATOM    405  O   ASP A  71      -0.204   6.731  14.068  1.00  7.58           O  
ATOM    406  CB  ASP A  71       0.195   9.257  15.951  1.00  7.92           C  
ATOM    407  CG  ASP A  71       0.788  10.613  16.437  1.00 10.03           C  
ATOM    408  OD1 ASP A  71       1.967  10.916  16.157  1.00 10.28           O  
ATOM    409  OD2 ASP A  71       0.077  11.367  17.119  1.00 12.74           O  
ATOM    410  N   VAL A  72       1.538   6.178  15.385  1.00  8.22           N  
ATOM    411  CA  VAL A  72       1.223   4.741  15.222  1.00  7.86           C  
ATOM    412  C   VAL A  72       1.020   4.015  16.578  1.00  7.22           C  
ATOM    413  O   VAL A  72       1.814   4.152  17.484  1.00  5.92           O  
ATOM    414  CB  VAL A  72       2.308   4.014  14.345  1.00  7.60           C  
ATOM    415  CG1 VAL A  72       2.082   2.493  14.359  1.00  7.94           C  
ATOM    416  CG2 VAL A  72       2.300   4.511  12.910  1.00  6.11           C  
ATOM    417  N   ILE A  73      -0.050   3.230  16.703  1.00  8.28           N  
ATOM    418  CA  ILE A  73      -0.162   2.278  17.842  1.00  7.50           C  
ATOM    419  C   ILE A  73      -0.053   0.840  17.250  1.00  8.55           C  
ATOM    420  O   ILE A  73      -0.870   0.458  16.410  1.00  8.07           O  
ATOM    421  CB  ILE A  73      -1.514   2.428  18.573  1.00  6.99           C  
ATOM    422  CG1 ILE A  73      -1.814   3.879  18.967  1.00  6.92           C  
ATOM    423  CG2 ILE A  73      -1.622   1.509  19.802  1.00  6.26           C  
ATOM    424  CD1 ILE A  73      -3.363   4.083  19.386  1.00  4.54           C  
ATOM    425  N   ALA A  74       0.974   0.083  17.660  1.00  9.23           N  
ATOM    426  CA  ALA A  74       1.213  -1.288  17.207  1.00  7.89           C  
ATOM    427  C   ALA A  74       1.181  -2.207  18.422  1.00  8.08           C  
ATOM    428  O   ALA A  74       1.966  -2.037  19.347  1.00  7.50           O  
ATOM    429  CB  ALA A  74       2.575  -1.403  16.513  1.00  8.68           C  
ATOM    430  N   GLN A  75       0.248  -3.155  18.412  1.00  7.11           N  
ATOM    431  CA  GLN A  75       0.171  -4.214  19.393  1.00  7.83           C  
ATOM    432  C   GLN A  75       0.706  -5.481  18.716  1.00  8.36           C  
ATOM    433  O   GLN A  75       0.126  -5.984  17.751  1.00  6.92           O  
ATOM    434  CB  GLN A  75      -1.285  -4.429  19.849  1.00  7.69           C  
ATOM    435  CG  GLN A  75      -1.390  -5.413  20.945  1.00  7.95           C  
ATOM    436  CD  GLN A  75      -2.784  -5.521  21.524  1.00  9.55           C  
ATOM    437  OE1 GLN A  75      -3.723  -4.890  21.050  1.00 12.13           O  
ATOM    438  NE2 GLN A  75      -2.924  -6.327  22.558  1.00  7.51           N  
ATOM    439  N   ALA A  76       1.843  -5.974  19.209  1.00  9.12           N  
ATOM    440  CA  ALA A  76       2.497  -7.134  18.619  1.00  8.54           C  
ATOM    441  C   ALA A  76       3.370  -7.727  19.716  1.00  9.57           C  
ATOM    442  O   ALA A  76       3.851  -7.012  20.598  1.00  8.95           O  
ATOM    443  CB  ALA A  76       3.339  -6.714  17.435  1.00  8.75           C  
ATOM    444  N   GLN A  77       3.505  -9.054  19.711  1.00 10.13           N  
ATOM    445  CA  GLN A  77       4.271  -9.729  20.730  1.00 10.14           C  
ATOM    446  C   GLN A  77       5.775  -9.580  20.441  1.00  9.67           C  
ATOM    447  O   GLN A  77       6.186  -9.095  19.379  1.00  8.85           O  
ATOM    448  CB  GLN A  77       3.827 -11.203  20.857  1.00 10.76           C  
ATOM    449  CG  GLN A  77       2.300 -11.436  21.223  1.00 13.18           C  
ATOM    450  CD  GLN A  77       1.758 -10.548  22.374  1.00 17.16           C  
ATOM    451  OE1 GLN A  77       1.901 -10.900  23.568  1.00 18.01           O  
ATOM    452  NE2 GLN A  77       1.072  -9.422  22.014  1.00 14.85           N  
ATOM    453  N   SER A  78       6.574  -9.966  21.415  1.00 10.08           N  
ATOM    454  CA  SER A  78       8.007 -10.087  21.263  1.00 11.42           C  
ATOM    455  C   SER A  78       8.356 -11.172  20.245  1.00 10.59           C  
ATOM    456  O   SER A  78       7.620 -12.154  20.056  1.00 11.54           O  
ATOM    457  CB  SER A  78       8.664 -10.378  22.628  1.00 12.00           C  
ATOM    458  OG  SER A  78       8.081 -11.538  23.227  1.00 15.60           O  
ATOM    459  N   GLY A  79       9.477 -10.970  19.566  1.00  9.97           N  
ATOM    460  CA  GLY A  79       9.926 -11.892  18.567  1.00  9.12           C  
ATOM    461  C   GLY A  79       9.287 -11.696  17.194  1.00  8.27           C  
ATOM    462  O   GLY A  79       9.416 -12.559  16.332  1.00  9.28           O  
ATOM    463  N   THR A  80       8.608 -10.572  16.996  1.00  6.78           N  
ATOM    464  CA  THR A  80       7.818 -10.333  15.786  1.00  5.96           C  
ATOM    465  C   THR A  80       8.462  -9.368  14.801  1.00  6.09           C  
ATOM    466  O   THR A  80       7.936  -9.171  13.698  1.00  6.76           O  
ATOM    467  CB  THR A  80       6.339  -9.847  16.073  1.00  4.65           C  
ATOM    468  OG1 THR A  80       6.356  -8.613  16.792  1.00  4.32           O  
ATOM    469  CG2 THR A  80       5.582 -10.892  16.855  1.00  2.08           C  
ATOM    470  N   GLY A  81       9.616  -8.802  15.158  1.00  6.13           N  
ATOM    471  CA  GLY A  81      10.290  -7.875  14.259  1.00  5.76           C  
ATOM    472  C   GLY A  81      10.016  -6.441  14.679  1.00  5.71           C  
ATOM    473  O   GLY A  81      10.169  -5.526  13.875  1.00  5.09           O  
HETATM  474  N   MLY A  82       9.529  -6.012  15.851  1.00  6.79           N  
HETATM  475  CA  MLY A  82       9.269  -4.597  16.236  1.00  8.11           C  
HETATM  476  CB  MLY A  82       8.730  -4.471  17.661  1.00  8.08           C  
HETATM  477  CG  MLY A  82       7.442  -5.325  17.817  1.00  8.89           C  
HETATM  478  CD  MLY A  82       6.758  -5.054  19.184  1.00 11.75           C  
HETATM  479  CE  MLY A  82       7.625  -5.601  20.326  1.00 12.52           C  
HETATM  480  NZ  MLY A  82       7.015  -5.448  21.697  1.00 17.22           N  
HETATM  481  CH1 MLY A  82       5.708  -4.838  21.722  1.00 15.92           C  
HETATM  482  CH2 MLY A  82       6.948  -6.743  22.419  1.00 14.02           C  
HETATM  483  C   MLY A  82      10.509  -3.713  16.084  1.00  8.75           C  
HETATM  484  O   MLY A  82      10.240  -2.520  15.818  1.00  8.74           O  
ATOM    485  N   THR A  83      11.678  -4.152  16.562  1.00  8.97           N  
ATOM    486  CA  THR A  83      12.876  -3.263  16.730  1.00 10.15           C  
ATOM    487  C   THR A  83      13.292  -2.687  15.398  1.00  8.84           C  
ATOM    488  O   THR A  83      13.475  -1.477  15.238  1.00  8.81           O  
ATOM    489  CB  THR A  83      14.065  -4.010  17.356  1.00 10.26           C  
ATOM    490  OG1 THR A  83      13.678  -4.382  18.682  1.00 13.76           O  
ATOM    491  CG2 THR A  83      15.348  -3.041  17.430  1.00  9.51           C  
ATOM    492  N   ALA A  84      13.359  -3.576  14.432  1.00  8.88           N  
ATOM    493  CA  ALA A  84      13.673  -3.218  13.094  1.00  8.97           C  
ATOM    494  C   ALA A  84      12.608  -2.334  12.493  1.00  8.76           C  
ATOM    495  O   ALA A  84      12.951  -1.494  11.689  1.00 10.30           O  
ATOM    496  CB  ALA A  84      13.926  -4.491  12.218  1.00  8.24           C  
ATOM    497  N   THR A  85      11.329  -2.521  12.863  1.00  8.88           N  
ATOM    498  CA  THR A  85      10.236  -1.678  12.388  1.00  8.11           C  
ATOM    499  C   THR A  85      10.495  -0.208  12.685  1.00  8.94           C  
ATOM    500  O   THR A  85      10.383   0.630  11.787  1.00 10.05           O  
ATOM    501  CB  THR A  85       8.815  -2.079  12.991  1.00  8.69           C  
ATOM    502  OG1 THR A  85       8.453  -3.412  12.591  1.00  9.53           O  
ATOM    503  CG2 THR A  85       7.701  -1.120  12.527  1.00  7.95           C  
ATOM    504  N   PHE A  86      10.771   0.136  13.937  1.00  7.90           N  
ATOM    505  CA  PHE A  86      11.018   1.543  14.250  1.00  7.97           C  
ATOM    506  C   PHE A  86      12.441   1.976  13.952  1.00  7.73           C  
ATOM    507  O   PHE A  86      12.654   3.123  13.632  1.00  8.19           O  
ATOM    508  CB  PHE A  86      10.550   1.961  15.679  1.00  7.05           C  
ATOM    509  CG  PHE A  86      11.191   1.197  16.801  1.00  6.30           C  
ATOM    510  CD1 PHE A  86      12.477   1.538  17.273  1.00  4.98           C  
ATOM    511  CD2 PHE A  86      10.521   0.147  17.415  1.00  2.92           C  
ATOM    512  CE1 PHE A  86      13.053   0.848  18.301  1.00  3.33           C  
ATOM    513  CE2 PHE A  86      11.108  -0.531  18.490  1.00  2.54           C  
ATOM    514  CZ  PHE A  86      12.341  -0.181  18.951  1.00  2.27           C  
ATOM    515  N   ALA A  87      13.406   1.045  13.968  1.00  8.77           N  
ATOM    516  CA  ALA A  87      14.789   1.400  13.668  1.00  7.38           C  
ATOM    517  C   ALA A  87      14.866   1.919  12.231  1.00  7.76           C  
ATOM    518  O   ALA A  87      15.460   2.936  11.961  1.00  7.74           O  
ATOM    519  CB  ALA A  87      15.650   0.210  13.851  1.00  7.29           C  
ATOM    520  N   ILE A  88      14.236   1.189  11.325  1.00  7.88           N  
ATOM    521  CA  ILE A  88      14.170   1.500   9.894  1.00  7.92           C  
ATOM    522  C   ILE A  88      13.381   2.781   9.610  1.00  7.62           C  
ATOM    523  O   ILE A  88      13.843   3.602   8.835  1.00  8.07           O  
ATOM    524  CB  ILE A  88      13.559   0.285   9.092  1.00  6.75           C  
ATOM    525  CG1 ILE A  88      14.520  -0.949   9.176  1.00  9.74           C  
ATOM    526  CG2 ILE A  88      13.296   0.674   7.604  1.00  7.02           C  
ATOM    527  CD1 ILE A  88      13.978  -2.272   8.464  1.00  8.06           C  
ATOM    528  N   SER A  89      12.174   2.913  10.168  1.00  7.57           N  
ATOM    529  CA  SER A  89      11.385   4.137  10.037  1.00  8.32           C  
ATOM    530  C   SER A  89      12.155   5.359  10.532  1.00  8.64           C  
ATOM    531  O   SER A  89      12.184   6.368   9.866  1.00 10.32           O  
ATOM    532  CB  SER A  89      10.053   4.015  10.786  1.00  8.48           C  
ATOM    533  OG  SER A  89       9.450   2.741  10.548  1.00  9.33           O  
ATOM    534  N   ILE A  90      12.800   5.259  11.689  1.00  8.89           N  
ATOM    535  CA  ILE A  90      13.550   6.358  12.231  1.00  9.02           C  
ATOM    536  C   ILE A  90      14.704   6.722  11.330  1.00  9.19           C  
ATOM    537  O   ILE A  90      14.964   7.894  11.085  1.00  9.00           O  
ATOM    538  CB  ILE A  90      14.086   6.005  13.647  1.00  9.68           C  
ATOM    539  CG1 ILE A  90      12.930   5.886  14.624  1.00  9.41           C  
ATOM    540  CG2 ILE A  90      15.060   7.077  14.166  1.00  8.76           C  
ATOM    541  CD1 ILE A  90      13.404   5.584  16.063  1.00 10.40           C  
ATOM    542  N   LEU A  91      15.416   5.714  10.834  1.00  9.34           N  
ATOM    543  CA  LEU A  91      16.616   6.004  10.079  1.00  9.47           C  
ATOM    544  C   LEU A  91      16.277   6.675   8.751  1.00  9.74           C  
ATOM    545  O   LEU A  91      17.032   7.546   8.263  1.00  9.90           O  
ATOM    546  CB  LEU A  91      17.453   4.744   9.854  1.00  9.29           C  
ATOM    547  CG  LEU A  91      18.295   4.295  11.033  1.00  9.25           C  
ATOM    548  CD1 LEU A  91      18.780   2.830  10.883  1.00  8.40           C  
ATOM    549  CD2 LEU A  91      19.447   5.221  11.180  1.00  7.19           C  
ATOM    550  N   GLN A  92      15.162   6.259   8.156  1.00  9.47           N  
ATOM    551  CA  GLN A  92      14.717   6.869   6.931  1.00  9.74           C  
ATOM    552  C   GLN A  92      14.358   8.368   7.047  1.00  9.98           C  
ATOM    553  O   GLN A  92      14.533   9.110   6.093  1.00 10.24           O  
ATOM    554  CB  GLN A  92      13.624   6.027   6.262  1.00  9.63           C  
ATOM    555  CG  GLN A  92      13.099   6.612   5.001  1.00  8.36           C  
ATOM    556  CD  GLN A  92      14.103   6.632   3.871  1.00 10.98           C  
ATOM    557  OE1 GLN A  92      14.960   5.779   3.792  1.00  7.93           O  
ATOM    558  NE2 GLN A  92      13.944   7.589   2.931  1.00 14.52           N  
ATOM    559  N   GLN A  93      13.931   8.830   8.223  1.00 11.06           N  
ATOM    560  CA  GLN A  93      13.521  10.236   8.389  1.00 11.88           C  
ATOM    561  C   GLN A  93      14.658  11.178   8.748  1.00 11.73           C  
ATOM    562  O   GLN A  93      14.469  12.376   8.740  1.00 12.68           O  
ATOM    563  CB  GLN A  93      12.462  10.396   9.496  1.00 11.44           C  
ATOM    564  CG  GLN A  93      11.243   9.576   9.378  1.00 12.35           C  
ATOM    565  CD  GLN A  93      10.357   9.688  10.616  1.00 13.51           C  
ATOM    566  OE1 GLN A  93      10.835   9.747  11.781  1.00 12.77           O  
ATOM    567  NE2 GLN A  93       9.055   9.730  10.371  1.00 12.72           N  
ATOM    568  N   ILE A  94      15.807  10.642   9.137  1.00 12.23           N  
ATOM    569  CA  ILE A  94      16.882  11.464   9.666  1.00 11.13           C  
ATOM    570  C   ILE A  94      17.418  12.381   8.594  1.00 11.38           C  
ATOM    571  O   ILE A  94      17.724  11.951   7.483  1.00  9.87           O  
ATOM    572  CB  ILE A  94      18.049  10.596  10.266  1.00 11.31           C  
ATOM    573  CG1 ILE A  94      17.601   9.743  11.462  1.00 10.76           C  
ATOM    574  CG2 ILE A  94      19.217  11.465  10.645  1.00 11.62           C  
ATOM    575  CD1 ILE A  94      16.982  10.539  12.670  1.00 10.81           C  
ATOM    576  N   GLU A  95      17.522  13.663   8.947  1.00 12.65           N  
ATOM    577  CA  GLU A  95      18.255  14.642   8.150  1.00 13.27           C  
ATOM    578  C   GLU A  95      19.718  14.503   8.576  1.00 12.88           C  
ATOM    579  O   GLU A  95      20.110  14.976   9.642  1.00 12.90           O  
ATOM    580  CB  GLU A  95      17.703  16.052   8.416  1.00 12.85           C  
ATOM    581  CG  GLU A  95      18.226  17.131   7.444  1.00 15.56           C  
ATOM    582  CD  GLU A  95      17.470  18.475   7.520  1.00 16.43           C  
ATOM    583  OE1 GLU A  95      16.497  18.639   8.300  1.00 20.68           O  
ATOM    584  OE2 GLU A  95      17.870  19.389   6.773  1.00 22.89           O  
ATOM    585  N   LEU A  96      20.516  13.839   7.744  1.00 13.35           N  
ATOM    586  CA  LEU A  96      21.867  13.416   8.113  1.00 13.14           C  
ATOM    587  C   LEU A  96      22.851  14.557   8.371  1.00 12.99           C  
ATOM    588  O   LEU A  96      23.735  14.440   9.220  1.00 12.74           O  
ATOM    589  CB  LEU A  96      22.414  12.420   7.083  1.00 13.26           C  
ATOM    590  CG  LEU A  96      21.795  11.016   6.940  1.00 13.44           C  
ATOM    591  CD1 LEU A  96      22.333  10.356   5.674  1.00 11.67           C  
ATOM    592  CD2 LEU A  96      22.068  10.141   8.134  1.00  9.94           C  
ATOM    593  N   ASP A  97      22.690  15.667   7.657  1.00 13.35           N  
ATOM    594  CA  ASP A  97      23.529  16.841   7.899  1.00 13.93           C  
ATOM    595  C   ASP A  97      23.029  17.735   9.042  1.00 13.38           C  
ATOM    596  O   ASP A  97      23.605  18.787   9.284  1.00 13.77           O  
ATOM    597  CB  ASP A  97      23.698  17.681   6.635  1.00 14.63           C  
ATOM    598  CG  ASP A  97      24.199  16.874   5.442  1.00 17.89           C  
ATOM    599  OD1 ASP A  97      24.771  15.766   5.610  1.00 20.42           O  
ATOM    600  OD2 ASP A  97      24.022  17.373   4.307  1.00 22.48           O  
ATOM    601  N   LEU A  98      21.959  17.341   9.731  1.00 12.04           N  
ATOM    602  CA  LEU A  98      21.534  18.074  10.917  1.00 11.17           C  
ATOM    603  C   LEU A  98      22.060  17.380  12.179  1.00 11.80           C  
ATOM    604  O   LEU A  98      21.848  16.171  12.384  1.00 10.71           O  
ATOM    605  CB  LEU A  98      20.010  18.216  10.964  1.00 11.03           C  
ATOM    606  CG  LEU A  98      19.370  18.693  12.278  1.00 10.95           C  
ATOM    607  CD1 LEU A  98      19.842  20.150  12.619  1.00 13.32           C  
ATOM    608  CD2 LEU A  98      17.850  18.625  12.209  1.00  9.81           C  
HETATM  609  N   MLY A  99      23.248  17.947  12.438  1.00 12.53           N  
HETATM  610  CA  MLY A  99      24.000  17.501  13.633  1.00 12.90           C  
HETATM  611  CB  MLY A  99      25.436  18.097  13.592  1.00 13.10           C  
HETATM  612  CG  MLY A  99      26.383  17.419  12.561  1.00 15.24           C  
HETATM  613  CD  MLY A  99      25.914  17.514  11.087  1.00 21.06           C  
HETATM  614  CE  MLY A  99      27.047  17.910  10.109  1.00 26.55           C  
HETATM  615  NZ  MLY A  99      26.561  18.390   8.777  1.00 29.31           N  
HETATM  616  CH1 MLY A  99      26.405  19.861   8.733  1.00 28.71           C  
HETATM  617  CH2 MLY A  99      27.534  18.003   7.722  1.00 28.90           C  
HETATM  618  C   MLY A  99      23.197  17.834  14.935  1.00 11.91           C  
HETATM  619  O   MLY A  99      23.716  18.547  15.852  1.00 12.81           O  
ATOM    620  N   ALA A 100      22.116  17.061  15.145  1.00  7.97           N  
ATOM    621  CA  ALA A 100      21.184  17.236  16.275  1.00  6.96           C  
ATOM    622  C   ALA A 100      20.347  15.983  16.540  1.00  7.31           C  
ATOM    623  O   ALA A 100      20.100  15.165  15.643  1.00  7.32           O  
ATOM    624  CB  ALA A 100      20.276  18.454  16.054  1.00  6.72           C  
ATOM    625  N   THR A 101      19.886  15.871  17.776  1.00  6.40           N  
ATOM    626  CA  THR A 101      19.101  14.741  18.185  1.00  6.95           C  
ATOM    627  C   THR A 101      17.706  14.899  17.589  1.00  7.12           C  
ATOM    628  O   THR A 101      17.060  15.915  17.808  1.00  6.41           O  
ATOM    629  CB  THR A 101      19.130  14.546  19.716  1.00  6.01           C  
ATOM    630  OG1 THR A 101      20.479  14.258  20.105  1.00  5.82           O  
ATOM    631  CG2 THR A 101      18.251  13.391  20.126  1.00  5.62           C  
ATOM    632  N   GLN A 102      17.285  13.887  16.827  1.00  6.53           N  
ATOM    633  CA  GLN A 102      16.075  13.983  16.030  1.00  7.48           C  
ATOM    634  C   GLN A 102      15.043  12.926  16.369  1.00  7.51           C  
ATOM    635  O   GLN A 102      13.872  13.037  15.995  1.00  9.11           O  
ATOM    636  CB  GLN A 102      16.384  13.954  14.521  1.00  7.30           C  
ATOM    637  CG  GLN A 102      17.184  15.123  13.989  1.00  6.87           C  
ATOM    638  CD  GLN A 102      17.734  14.849  12.621  1.00  7.44           C  
ATOM    639  OE1 GLN A 102      17.004  14.445  11.735  1.00  9.34           O  
ATOM    640  NE2 GLN A 102      19.035  15.083  12.426  1.00  6.26           N  
ATOM    641  N   ALA A 103      15.450  11.911  17.092  1.00  6.57           N  
ATOM    642  CA  ALA A 103      14.503  10.884  17.449  1.00  6.84           C  
ATOM    643  C   ALA A 103      14.923  10.304  18.791  1.00  6.79           C  
ATOM    644  O   ALA A 103      16.116  10.234  19.124  1.00  6.19           O  
ATOM    645  CB  ALA A 103      14.421   9.801  16.369  1.00  6.57           C  
ATOM    646  N   LEU A 104      13.925   9.939  19.572  1.00  5.67           N  
ATOM    647  CA  LEU A 104      14.143   9.503  20.908  1.00  6.06           C  
ATOM    648  C   LEU A 104      13.375   8.193  21.018  1.00  6.80           C  
ATOM    649  O   LEU A 104      12.185   8.123  20.642  1.00  7.22           O  
ATOM    650  CB  LEU A 104      13.562  10.550  21.879  1.00  6.15           C  
ATOM    651  CG  LEU A 104      13.534  10.279  23.399  1.00  8.99           C  
ATOM    652  CD1 LEU A 104      14.898   9.759  23.891  1.00  9.26           C  
ATOM    653  CD2 LEU A 104      13.113  11.560  24.248  1.00  5.47           C  
ATOM    654  N   VAL A 105      14.051   7.155  21.507  1.00  7.36           N  
ATOM    655  CA  VAL A 105      13.418   5.873  21.791  1.00  6.28           C  
ATOM    656  C   VAL A 105      13.465   5.525  23.293  1.00  8.00           C  
ATOM    657  O   VAL A 105      14.528   5.513  23.917  1.00  7.63           O  
ATOM    658  CB  VAL A 105      14.019   4.693  20.931  1.00  7.74           C  
ATOM    659  CG1 VAL A 105      13.187   3.398  21.106  1.00  2.00           C  
ATOM    660  CG2 VAL A 105      14.083   5.082  19.432  1.00  4.18           C  
ATOM    661  N   LEU A 106      12.293   5.218  23.858  1.00  8.48           N  
ATOM    662  CA  LEU A 106      12.236   4.749  25.228  1.00  9.07           C  
ATOM    663  C   LEU A 106      12.020   3.213  25.332  1.00  9.79           C  
ATOM    664  O   LEU A 106      11.145   2.640  24.668  1.00  9.40           O  
ATOM    665  CB  LEU A 106      11.135   5.501  25.968  1.00  8.94           C  
ATOM    666  CG  LEU A 106      11.325   6.995  26.273  1.00  9.16           C  
ATOM    667  CD1 LEU A 106      10.264   7.483  27.366  1.00  3.24           C  
ATOM    668  CD2 LEU A 106      12.766   7.363  26.680  1.00  8.04           C  
ATOM    669  N   ALA A 107      12.810   2.564  26.182  1.00  9.72           N  
ATOM    670  CA  ALA A 107      12.648   1.130  26.450  1.00  9.51           C  
ATOM    671  C   ALA A 107      12.627   0.901  27.957  1.00  9.33           C  
ATOM    672  O   ALA A 107      13.213   1.683  28.707  1.00  9.36           O  
ATOM    673  CB  ALA A 107      13.795   0.304  25.767  1.00  9.43           C  
ATOM    674  N   PRO A 108      11.910  -0.149  28.426  1.00  9.58           N  
ATOM    675  CA  PRO A 108      11.796  -0.404  29.871  1.00  8.94           C  
ATOM    676  C   PRO A 108      13.044  -0.884  30.584  1.00  9.18           C  
ATOM    677  O   PRO A 108      13.095  -0.769  31.795  1.00  8.53           O  
ATOM    678  CB  PRO A 108      10.742  -1.508  29.939  1.00  9.33           C  
ATOM    679  CG  PRO A 108      10.907  -2.231  28.618  1.00  8.50           C  
ATOM    680  CD  PRO A 108      11.103  -1.107  27.646  1.00  8.43           C  
ATOM    681  N   THR A 109      14.007  -1.455  29.862  1.00  9.19           N  
ATOM    682  CA  THR A 109      15.247  -1.942  30.480  1.00  9.60           C  
ATOM    683  C   THR A 109      16.501  -1.492  29.725  1.00  9.11           C  
ATOM    684  O   THR A 109      16.454  -1.072  28.574  1.00  8.75           O  
ATOM    685  CB  THR A 109      15.303  -3.514  30.605  1.00  9.62           C  
ATOM    686  OG1 THR A 109      15.217  -4.114  29.317  1.00 10.58           O  
ATOM    687  CG2 THR A 109      14.195  -4.057  31.440  1.00 10.37           C  
ATOM    688  N   ARG A 110      17.631  -1.605  30.391  1.00 10.20           N  
ATOM    689  CA  ARG A 110      18.923  -1.257  29.811  1.00 11.27           C  
ATOM    690  C   ARG A 110      19.376  -2.263  28.729  1.00 10.97           C  
ATOM    691  O   ARG A 110      19.805  -1.862  27.652  1.00 10.47           O  
ATOM    692  CB  ARG A 110      19.958  -1.110  30.930  1.00 11.82           C  
ATOM    693  CG  ARG A 110      19.963  -2.243  31.911  1.00 15.74           C  
ATOM    694  CD  ARG A 110      20.453  -1.801  33.298  1.00 23.08           C  
ATOM    695  NE  ARG A 110      20.467  -2.884  34.303  1.00 26.72           N  
ATOM    696  CZ  ARG A 110      20.637  -4.186  34.045  1.00 28.65           C  
ATOM    697  NH1 ARG A 110      20.822  -4.620  32.794  1.00 29.22           N  
ATOM    698  NH2 ARG A 110      20.628  -5.065  35.048  1.00 28.40           N  
ATOM    699  N   GLU A 111      19.222  -3.558  28.979  1.00 11.62           N  
ATOM    700  CA  GLU A 111      19.552  -4.504  27.935  1.00 12.04           C  
ATOM    701  C   GLU A 111      18.718  -4.330  26.679  1.00 11.58           C  
ATOM    702  O   GLU A 111      19.272  -4.377  25.599  1.00 12.41           O  
ATOM    703  CB  GLU A 111      19.563  -5.977  28.375  1.00 12.57           C  
ATOM    704  CG  GLU A 111      20.164  -6.915  27.201  1.00 14.62           C  
ATOM    705  CD  GLU A 111      21.575  -6.455  26.586  1.00 17.29           C  
ATOM    706  OE1 GLU A 111      22.597  -6.401  27.324  1.00 18.41           O  
ATOM    707  OE2 GLU A 111      21.663  -6.199  25.355  1.00 16.64           O  
ATOM    708  N   LEU A 112      17.403  -4.145  26.808  1.00 10.69           N  
ATOM    709  CA  LEU A 112      16.582  -3.848  25.643  1.00 10.93           C  
ATOM    710  C   LEU A 112      16.992  -2.530  24.935  1.00  9.88           C  
ATOM    711  O   LEU A 112      17.022  -2.487  23.701  1.00  9.72           O  
ATOM    712  CB  LEU A 112      15.072  -3.834  26.006  1.00 10.66           C  
ATOM    713  CG  LEU A 112      14.135  -3.662  24.786  1.00 12.28           C  
ATOM    714  CD1 LEU A 112      14.389  -4.700  23.652  1.00 13.41           C  
ATOM    715  CD2 LEU A 112      12.629  -3.614  25.180  1.00 12.05           C  
ATOM    716  N   ALA A 113      17.270  -1.468  25.714  1.00  8.64           N  
ATOM    717  CA  ALA A 113      17.822  -0.206  25.157  1.00  8.64           C  
ATOM    718  C   ALA A 113      19.125  -0.381  24.357  1.00  9.01           C  
ATOM    719  O   ALA A 113      19.268   0.167  23.273  1.00 10.05           O  
ATOM    720  CB  ALA A 113      18.018   0.845  26.274  1.00  7.72           C  
ATOM    721  N   GLN A 114      20.068  -1.137  24.896  1.00  9.74           N  
ATOM    722  CA  GLN A 114      21.346  -1.487  24.213  1.00 11.50           C  
ATOM    723  C   GLN A 114      21.167  -2.370  22.955  1.00 11.19           C  
ATOM    724  O   GLN A 114      21.827  -2.176  21.934  1.00 11.36           O  
ATOM    725  CB  GLN A 114      22.287  -2.174  25.202  1.00 11.14           C  
ATOM    726  CG  GLN A 114      23.080  -1.197  26.055  1.00 12.77           C  
ATOM    727  CD  GLN A 114      23.973  -1.879  27.083  1.00 15.54           C  
ATOM    728  OE1 GLN A 114      25.194  -1.665  27.105  1.00 20.00           O  
ATOM    729  NE2 GLN A 114      23.371  -2.694  27.952  1.00 18.59           N  
ATOM    730  N   GLN A 115      20.260  -3.327  23.026  1.00 10.91           N  
ATOM    731  CA  GLN A 115      19.924  -4.126  21.869  1.00 11.55           C  
ATOM    732  C   GLN A 115      19.366  -3.240  20.725  1.00 10.54           C  
ATOM    733  O   GLN A 115      19.744  -3.387  19.581  1.00 10.07           O  
ATOM    734  CB  GLN A 115      18.873  -5.157  22.287  1.00 12.20           C  
ATOM    735  CG  GLN A 115      18.901  -6.436  21.512  1.00 16.03           C  
ATOM    736  CD  GLN A 115      17.956  -7.416  22.102  1.00 20.85           C  
ATOM    737  OE1 GLN A 115      18.353  -8.222  22.935  1.00 24.15           O  
ATOM    738  NE2 GLN A 115      16.666  -7.331  21.720  1.00 23.17           N  
ATOM    739  N   ILE A 116      18.450  -2.331  21.061  1.00  9.96           N  
ATOM    740  CA  ILE A 116      17.880  -1.383  20.102  1.00  8.95           C  
ATOM    741  C   ILE A 116      19.028  -0.514  19.553  1.00  8.43           C  
ATOM    742  O   ILE A 116      19.127  -0.349  18.369  1.00  9.09           O  
ATOM    743  CB  ILE A 116      16.769  -0.484  20.738  1.00  8.81           C  
ATOM    744  CG1 ILE A 116      15.528  -1.311  21.096  1.00  9.42           C  
ATOM    745  CG2 ILE A 116      16.410   0.687  19.831  1.00  8.16           C  
ATOM    746  CD1 ILE A 116      14.567  -0.602  22.022  1.00  8.01           C  
ATOM    747  N   GLN A 117      19.896   0.003  20.408  1.00  8.00           N  
ATOM    748  CA  GLN A 117      21.038   0.792  19.933  1.00  7.71           C  
ATOM    749  C   GLN A 117      21.842  -0.006  18.928  1.00  7.05           C  
ATOM    750  O   GLN A 117      22.186   0.518  17.889  1.00  4.31           O  
ATOM    751  CB  GLN A 117      21.908   1.270  21.087  1.00  7.47           C  
ATOM    752  CG  GLN A 117      22.944   2.351  20.699  1.00 11.06           C  
ATOM    753  CD  GLN A 117      24.263   1.776  20.165  1.00 13.26           C  
ATOM    754  OE1 GLN A 117      24.630   0.676  20.547  1.00 15.47           O  
ATOM    755  NE2 GLN A 117      24.977   2.518  19.289  1.00  8.55           N  
HETATM  756  N   MLY A 118      22.226  -1.294  19.138  1.00  8.38           N  
HETATM  757  CA  MLY A 118      23.045  -2.175  18.299  1.00  7.72           C  
HETATM  758  CB  MLY A 118      23.446  -3.466  19.048  1.00  8.50           C  
HETATM  759  CG  MLY A 118      24.346  -3.126  20.247  1.00 10.68           C  
HETATM  760  CD  MLY A 118      24.963  -4.366  20.898  1.00 16.42           C  
HETATM  761  CE  MLY A 118      25.312  -4.077  22.379  1.00 20.49           C  
HETATM  762  NZ  MLY A 118      26.091  -5.171  23.016  1.00 24.94           N  
HETATM  763  CH1 MLY A 118      26.257  -4.932  24.470  1.00 24.06           C  
HETATM  764  CH2 MLY A 118      25.486  -6.511  22.787  1.00 25.42           C  
HETATM  765  C   MLY A 118      22.335  -2.452  16.967  1.00  6.96           C  
HETATM  766  O   MLY A 118      22.994  -2.226  15.927  1.00  7.01           O  
ATOM    767  N   VAL A 119      21.013  -2.387  16.782  1.00  6.68           N  
ATOM    768  CA  VAL A 119      20.350  -2.547  15.463  1.00  6.32           C  
ATOM    769  C   VAL A 119      20.390  -1.228  14.743  1.00  7.15           C  
ATOM    770  O   VAL A 119      20.677  -1.158  13.547  1.00  8.11           O  
ATOM    771  CB  VAL A 119      18.869  -3.070  15.618  1.00  6.75           C  
ATOM    772  CG1 VAL A 119      18.155  -3.075  14.291  1.00  3.52           C  
ATOM    773  CG2 VAL A 119      18.828  -4.524  16.291  1.00  5.33           C  
ATOM    774  N   VAL A 120      20.097  -0.163  15.465  1.00  6.41           N  
ATOM    775  CA  VAL A 120      20.099   1.128  14.818  1.00  7.24           C  
ATOM    776  C   VAL A 120      21.503   1.484  14.309  1.00  6.50           C  
ATOM    777  O   VAL A 120      21.646   1.943  13.183  1.00  7.45           O  
ATOM    778  CB  VAL A 120      19.604   2.266  15.735  1.00  7.63           C  
ATOM    779  CG1 VAL A 120      19.731   3.570  14.960  1.00  7.38           C  
ATOM    780  CG2 VAL A 120      18.182   1.994  16.282  1.00  4.81           C  
ATOM    781  N   MET A 121      22.521   1.271  15.130  1.00  6.49           N  
ATOM    782  CA  MET A 121      23.902   1.541  14.742  1.00  7.37           C  
ATOM    783  C   MET A 121      24.341   0.696  13.556  1.00  6.83           C  
ATOM    784  O   MET A 121      24.963   1.210  12.651  1.00  7.36           O  
ATOM    785  CB  MET A 121      24.862   1.335  15.913  1.00  6.67           C  
ATOM    786  CG  MET A 121      26.242   1.921  15.635  1.00  9.81           C  
ATOM    787  SD  MET A 121      27.612   1.536  16.733  1.00 13.11           S  
ATOM    788  CE  MET A 121      27.658  -0.265  16.701  1.00 15.59           C  
ATOM    789  N   ALA A 122      24.031  -0.602  13.563  1.00  7.54           N  
ATOM    790  CA  ALA A 122      24.405  -1.490  12.460  1.00  8.18           C  
ATOM    791  C   ALA A 122      23.708  -1.141  11.097  1.00  8.69           C  
ATOM    792  O   ALA A 122      24.326  -1.275  10.037  1.00  8.94           O  
ATOM    793  CB  ALA A 122      24.228  -2.993  12.857  1.00  7.29           C  
ATOM    794  N   LEU A 123      22.463  -0.658  11.125  1.00  9.24           N  
ATOM    795  CA  LEU A 123      21.843  -0.127   9.909  1.00 10.23           C  
ATOM    796  C   LEU A 123      22.340   1.296   9.547  1.00 12.08           C  
ATOM    797  O   LEU A 123      22.696   1.604   8.348  1.00 12.20           O  
ATOM    798  CB  LEU A 123      20.323  -0.198  10.001  1.00 10.02           C  
ATOM    799  CG  LEU A 123      19.640  -1.548  10.289  1.00 10.07           C  
ATOM    800  CD1 LEU A 123      18.151  -1.325  10.321  1.00 12.40           C  
ATOM    801  CD2 LEU A 123      19.962  -2.572   9.242  1.00  9.98           C  
ATOM    802  N   GLY A 124      22.429   2.140  10.580  1.00 11.63           N  
ATOM    803  CA  GLY A 124      22.867   3.520  10.384  1.00 12.95           C  
ATOM    804  C   GLY A 124      24.291   3.644   9.905  1.00 13.74           C  
ATOM    805  O   GLY A 124      24.650   4.632   9.280  1.00 13.42           O  
ATOM    806  N   ASP A 125      25.109   2.637  10.220  1.00 15.21           N  
ATOM    807  CA  ASP A 125      26.527   2.617   9.874  1.00 15.86           C  
ATOM    808  C   ASP A 125      26.735   2.649   8.356  1.00 15.86           C  
ATOM    809  O   ASP A 125      27.808   3.045   7.883  1.00 15.61           O  
ATOM    810  CB  ASP A 125      27.174   1.343  10.417  1.00 16.66           C  
ATOM    811  CG  ASP A 125      27.963   1.554  11.721  1.00 17.64           C  
ATOM    812  OD1 ASP A 125      27.904   2.645  12.362  1.00 16.25           O  
ATOM    813  OD2 ASP A 125      28.619   0.554  12.110  1.00 19.19           O  
ATOM    814  N   TYR A 126      25.725   2.204   7.608  1.00 15.49           N  
ATOM    815  CA  TYR A 126      25.751   2.293   6.135  1.00 15.82           C  
ATOM    816  C   TYR A 126      25.327   3.659   5.594  1.00 16.02           C  
ATOM    817  O   TYR A 126      25.593   3.967   4.448  1.00 16.33           O  
ATOM    818  CB  TYR A 126      24.943   1.135   5.477  1.00 15.97           C  
ATOM    819  CG  TYR A 126      25.791  -0.088   5.237  1.00 14.30           C  
ATOM    820  CD1 TYR A 126      26.050  -0.978   6.268  1.00 12.41           C  
ATOM    821  CD2 TYR A 126      26.415  -0.297   3.993  1.00 16.14           C  
ATOM    822  CE1 TYR A 126      26.873  -2.083   6.073  1.00 15.30           C  
ATOM    823  CE2 TYR A 126      27.262  -1.404   3.773  1.00 15.17           C  
ATOM    824  CZ  TYR A 126      27.472  -2.293   4.821  1.00 15.86           C  
ATOM    825  OH  TYR A 126      28.283  -3.377   4.652  1.00 17.27           O  
ATOM    826  N   MET A 127      24.670   4.476   6.420  1.00 17.01           N  
ATOM    827  CA  MET A 127      24.233   5.840   6.002  1.00 17.60           C  
ATOM    828  C   MET A 127      24.897   6.980   6.717  1.00 17.63           C  
ATOM    829  O   MET A 127      24.697   8.111   6.336  1.00 18.88           O  
ATOM    830  CB  MET A 127      22.741   6.050   6.233  1.00 17.84           C  
ATOM    831  CG  MET A 127      21.849   4.888   5.904  1.00 17.14           C  
ATOM    832  SD  MET A 127      20.642   4.956   7.208  1.00 22.96           S  
ATOM    833  CE  MET A 127      19.851   6.506   6.822  1.00 19.18           C  
ATOM    834  N   GLY A 128      25.638   6.702   7.782  1.00 18.01           N  
ATOM    835  CA  GLY A 128      26.189   7.749   8.630  1.00 18.31           C  
ATOM    836  C   GLY A 128      25.160   8.443   9.514  1.00 18.52           C  
ATOM    837  O   GLY A 128      25.240   9.660   9.730  1.00 18.82           O  
ATOM    838  N   ALA A 129      24.198   7.668  10.019  1.00 18.28           N  
ATOM    839  CA  ALA A 129      23.292   8.119  11.059  1.00 17.83           C  
ATOM    840  C   ALA A 129      23.821   7.601  12.396  1.00 17.17           C  
ATOM    841  O   ALA A 129      24.080   6.403  12.509  1.00 18.53           O  
ATOM    842  CB  ALA A 129      21.902   7.608  10.786  1.00 17.59           C  
ATOM    843  N   SER A 130      24.025   8.493  13.381  1.00 15.97           N  
ATOM    844  CA  SER A 130      24.518   8.121  14.742  1.00 14.37           C  
ATOM    845  C   SER A 130      23.392   7.798  15.748  1.00 14.47           C  
ATOM    846  O   SER A 130      22.295   8.375  15.669  1.00 14.60           O  
ATOM    847  CB  SER A 130      25.405   9.226  15.311  1.00 13.90           C  
ATOM    848  OG  SER A 130      24.759  10.489  15.260  1.00 11.92           O  
ATOM    849  N   CYS A 131      23.672   6.895  16.693  1.00 13.96           N  
ATOM    850  CA  CYS A 131      22.720   6.499  17.750  1.00 13.66           C  
ATOM    851  C   CYS A 131      23.448   6.229  19.079  1.00 14.63           C  
ATOM    852  O   CYS A 131      24.443   5.462  19.119  1.00 14.83           O  
ATOM    853  CB  CYS A 131      21.914   5.256  17.332  1.00 13.34           C  
ATOM    854  SG  CYS A 131      20.680   4.688  18.570  1.00 12.50           S  
ATOM    855  N   HIS A 132      22.975   6.863  20.155  1.00 14.57           N  
ATOM    856  CA  HIS A 132      23.580   6.669  21.470  1.00 15.59           C  
ATOM    857  C   HIS A 132      22.620   6.055  22.465  1.00 15.34           C  
ATOM    858  O   HIS A 132      21.440   6.381  22.482  1.00 14.48           O  
ATOM    859  CB  HIS A 132      24.151   7.990  22.012  1.00 16.91           C  
ATOM    860  CG  HIS A 132      25.371   8.475  21.283  1.00 19.02           C  
ATOM    861  ND1 HIS A 132      26.421   9.094  21.927  1.00 22.05           N  
ATOM    862  CD2 HIS A 132      25.714   8.424  19.970  1.00 21.96           C  
ATOM    863  CE1 HIS A 132      27.353   9.409  21.042  1.00 22.59           C  
ATOM    864  NE2 HIS A 132      26.950   9.013  19.848  1.00 21.37           N  
ATOM    865  N   ALA A 133      23.125   5.146  23.289  1.00 16.00           N  
ATOM    866  CA  ALA A 133      22.312   4.594  24.363  1.00 17.53           C  
ATOM    867  C   ALA A 133      22.399   5.485  25.592  1.00 18.76           C  
ATOM    868  O   ALA A 133      23.437   6.066  25.896  1.00 19.16           O  
ATOM    869  CB  ALA A 133      22.728   3.164  24.695  1.00 17.45           C  
ATOM    870  N   CYS A 134      21.300   5.582  26.311  1.00 20.99           N  
ATOM    871  CA  CYS A 134      21.194   6.484  27.424  1.00 21.41           C  
ATOM    872  C   CYS A 134      20.703   5.692  28.609  1.00 21.72           C  
ATOM    873  O   CYS A 134      19.522   5.673  28.866  1.00 21.03           O  
ATOM    874  CB  CYS A 134      20.146   7.527  27.074  1.00 21.78           C  
ATOM    875  SG  CYS A 134      20.524   9.139  27.713  1.00 24.27           S  
ATOM    876  N   ILE A 135      21.603   5.034  29.330  1.00 22.78           N  
ATOM    877  CA  ILE A 135      21.195   4.077  30.362  1.00 24.09           C  
ATOM    878  C   ILE A 135      21.837   4.387  31.724  1.00 24.66           C  
ATOM    879  O   ILE A 135      22.643   5.311  31.829  1.00 24.86           O  
ATOM    880  CB  ILE A 135      21.413   2.604  29.853  1.00 24.49           C  
ATOM    881  CG1 ILE A 135      20.241   2.166  28.993  1.00 23.17           C  
ATOM    882  CG2 ILE A 135      21.503   1.603  30.973  1.00 25.31           C  
ATOM    883  CD1 ILE A 135      20.318   2.628  27.617  1.00 23.62           C  
ATOM    884  N   GLY A 136      21.448   3.640  32.755  1.00 25.04           N  
ATOM    885  CA  GLY A 136      21.936   3.841  34.127  1.00 25.98           C  
ATOM    886  C   GLY A 136      23.358   3.384  34.451  1.00 26.26           C  
ATOM    887  O   GLY A 136      24.290   3.585  33.669  1.00 26.48           O  
ATOM    888  N   ASN A 139      26.699   3.361  36.737  1.00 55.87           N  
ATOM    889  CA  ASN A 139      27.839   3.957  37.435  1.00 55.89           C  
ATOM    890  C   ASN A 139      28.879   4.631  36.533  1.00 55.85           C  
ATOM    891  O   ASN A 139      29.855   5.207  37.025  1.00 55.85           O  
ATOM    892  CB  ASN A 139      28.503   2.955  38.406  1.00 55.99           C  
ATOM    893  CG  ASN A 139      28.981   1.659  37.729  1.00 56.23           C  
ATOM    894  OD1 ASN A 139      29.392   0.714  38.410  1.00 56.24           O  
ATOM    895  ND2 ASN A 139      28.935   1.613  36.403  1.00 56.80           N  
ATOM    896  N   VAL A 140      28.675   4.547  35.221  1.00 56.06           N  
ATOM    897  CA  VAL A 140      29.486   5.311  34.266  1.00 56.14           C  
ATOM    898  C   VAL A 140      28.677   6.520  33.771  1.00 56.20           C  
ATOM    899  O   VAL A 140      27.625   6.365  33.124  1.00 55.88           O  
ATOM    900  CB  VAL A 140      30.015   4.460  33.055  1.00 56.20           C  
ATOM    901  CG1 VAL A 140      31.065   5.244  32.267  1.00 55.85           C  
ATOM    902  CG2 VAL A 140      30.613   3.135  33.513  1.00 55.90           C  
ATOM    903  N   ARG A 141      29.168   7.715  34.117  1.00 56.18           N  
ATOM    904  CA  ARG A 141      28.592   8.979  33.641  1.00 56.04           C  
ATOM    905  C   ARG A 141      29.610   9.871  32.902  1.00 55.95           C  
ATOM    906  O   ARG A 141      29.491  11.101  32.878  1.00 55.95           O  
ATOM    907  CB  ARG A 141      27.827   9.727  34.761  1.00 56.09           C  
ATOM    908  CG  ARG A 141      28.539   9.884  36.111  1.00 55.68           C  
ATOM    909  CD  ARG A 141      29.307  11.193  36.218  1.00 55.57           C  
ATOM    910  NE  ARG A 141      30.551  11.146  35.450  1.00 55.67           N  
ATOM    911  CZ  ARG A 141      31.443  12.130  35.374  1.00 55.47           C  
ATOM    912  NH1 ARG A 141      31.249  13.272  36.026  1.00 55.03           N  
ATOM    913  NH2 ARG A 141      32.537  11.967  34.642  1.00 55.55           N  
ATOM    914  N   ALA A 142      30.613   9.228  32.303  1.00 55.84           N  
ATOM    915  CA  ALA A 142      31.503   9.875  31.338  1.00 55.68           C  
ATOM    916  C   ALA A 142      30.783   9.973  29.988  1.00 55.49           C  
ATOM    917  O   ALA A 142      31.119  10.814  29.154  1.00 55.56           O  
ATOM    918  CB  ALA A 142      32.804   9.093  31.205  1.00 55.71           C  
ATOM    919  N   GLU A 143      29.799   9.092  29.798  1.00 55.24           N  
ATOM    920  CA  GLU A 143      28.814   9.145  28.706  1.00 55.07           C  
ATOM    921  C   GLU A 143      28.070  10.492  28.681  1.00 54.79           C  
ATOM    922  O   GLU A 143      27.559  10.915  27.640  1.00 54.76           O  
ATOM    923  CB  GLU A 143      27.845   7.952  28.859  1.00 55.13           C  
ATOM    924  CG  GLU A 143      26.451   8.060  28.212  1.00 55.35           C  
ATOM    925  CD  GLU A 143      25.632   6.765  28.348  1.00 55.20           C  
ATOM    926  OE1 GLU A 143      24.606   6.763  29.061  1.00 54.35           O  
ATOM    927  OE2 GLU A 143      26.022   5.739  27.753  1.00 55.66           O  
ATOM    928  N   VAL A 144      28.052  11.163  29.831  1.00 54.46           N  
ATOM    929  CA  VAL A 144      27.346  12.433  30.026  1.00 54.20           C  
ATOM    930  C   VAL A 144      28.228  13.649  29.688  1.00 53.78           C  
ATOM    931  O   VAL A 144      28.022  14.743  30.210  1.00 53.64           O  
ATOM    932  CB  VAL A 144      26.810  12.550  31.485  1.00 54.23           C  
ATOM    933  CG1 VAL A 144      25.693  13.568  31.573  1.00 54.62           C  
ATOM    934  CG2 VAL A 144      26.301  11.206  31.986  1.00 54.47           C  
ATOM    935  N   GLN A 145      29.206  13.449  28.808  1.00 53.43           N  
ATOM    936  CA  GLN A 145      30.148  14.507  28.444  1.00 53.13           C  
ATOM    937  C   GLN A 145      30.260  14.586  26.926  1.00 52.84           C  
ATOM    938  O   GLN A 145      29.399  15.185  26.281  1.00 52.90           O  
ATOM    939  CB  GLN A 145      31.508  14.289  29.143  1.00 53.06           C  
ATOM    940  CG  GLN A 145      32.786  14.651  28.351  1.00 53.24           C  
ATOM    941  CD  GLN A 145      33.019  16.150  28.172  1.00 53.02           C  
ATOM    942  OE1 GLN A 145      32.704  16.958  29.049  1.00 52.69           O  
ATOM    943  NE2 GLN A 145      33.589  16.522  27.027  1.00 52.54           N  
HETATM  944  N   MLY A 146      30.445  13.566  26.078  1.00 51.97           N  
HETATM  945  CA  MLY A 146      31.003  12.759  24.967  1.00 51.60           C  
HETATM  946  CB  MLY A 146      31.808  11.563  25.539  1.00 51.74           C  
HETATM  947  CG  MLY A 146      30.935  10.340  25.886  1.00 52.55           C  
HETATM  948  CD  MLY A 146      31.790   9.124  26.277  1.00 54.16           C  
HETATM  949  CE  MLY A 146      31.214   7.810  25.717  1.00 54.65           C  
HETATM  950  NZ  MLY A 146      32.289   6.826  25.448  1.00 55.14           N  
HETATM  951  CH1 MLY A 146      31.871   5.501  25.938  1.00 55.03           C  
HETATM  952  CH2 MLY A 146      32.581   6.737  24.003  1.00 55.30           C  
HETATM  953  C   MLY A 146      29.869  12.312  23.999  1.00 50.83           C  
HETATM  954  O   MLY A 146      30.182  11.715  22.937  1.00 50.96           O  
ATOM    955  N   LEU A 147      28.732  12.869  23.568  1.00 48.38           N  
ATOM    956  CA  LEU A 147      27.577  13.823  23.468  1.00 47.21           C  
ATOM    957  C   LEU A 147      28.079  15.248  23.152  1.00 46.59           C  
ATOM    958  O   LEU A 147      27.368  16.040  22.519  1.00 46.55           O  
ATOM    959  CB  LEU A 147      26.714  13.784  24.754  1.00 47.51           C  
ATOM    960  CG  LEU A 147      25.176  13.617  24.703  1.00 47.26           C  
ATOM    961  CD1 LEU A 147      24.742  12.390  23.904  1.00 46.95           C  
ATOM    962  CD2 LEU A 147      24.572  13.544  26.106  1.00 46.88           C  
ATOM    963  N   GLN A 148      29.298  15.565  23.590  1.00 45.38           N  
ATOM    964  CA  GLN A 148      29.951  16.821  23.191  1.00 44.44           C  
ATOM    965  C   GLN A 148      31.101  16.640  22.190  1.00 43.25           C  
ATOM    966  O   GLN A 148      32.020  17.453  22.114  1.00 43.28           O  
ATOM    967  CB  GLN A 148      30.330  17.705  24.389  1.00 44.70           C  
ATOM    968  CG  GLN A 148      29.138  18.480  24.983  1.00 45.66           C  
ATOM    969  CD  GLN A 148      28.320  19.277  23.946  1.00 46.58           C  
ATOM    970  OE1 GLN A 148      28.715  19.430  22.782  1.00 46.81           O  
ATOM    971  NE2 GLN A 148      27.172  19.792  24.381  1.00 46.67           N  
ATOM    972  N   MET A 149      31.042  15.538  21.451  1.00 41.91           N  
ATOM    973  CA  MET A 149      31.483  15.521  20.067  1.00 40.28           C  
ATOM    974  C   MET A 149      30.197  15.807  19.256  1.00 38.94           C  
ATOM    975  O   MET A 149      29.775  16.969  19.118  1.00 38.99           O  
ATOM    976  CB  MET A 149      32.130  14.177  19.703  1.00 40.37           C  
ATOM    977  CG  MET A 149      32.530  14.007  18.220  1.00 41.19           C  
ATOM    978  SD  MET A 149      33.276  15.427  17.357  1.00 44.09           S  
ATOM    979  CE  MET A 149      34.683  15.853  18.414  1.00 41.69           C  
ATOM    980  N   GLU A 150      29.554  14.753  18.766  1.00 36.49           N  
ATOM    981  CA  GLU A 150      28.289  14.889  18.074  1.00 34.19           C  
ATOM    982  C   GLU A 150      27.171  14.907  19.105  1.00 31.77           C  
ATOM    983  O   GLU A 150      27.227  14.162  20.091  1.00 32.00           O  
ATOM    984  CB  GLU A 150      28.035  13.684  17.153  1.00 34.87           C  
ATOM    985  CG  GLU A 150      29.212  12.717  16.956  1.00 36.10           C  
ATOM    986  CD  GLU A 150      28.848  11.275  17.322  1.00 37.28           C  
ATOM    987  OE1 GLU A 150      28.064  11.093  18.290  1.00 37.21           O  
ATOM    988  OE2 GLU A 150      29.359  10.334  16.660  1.00 36.09           O  
ATOM    989  N   ALA A 151      26.166  15.760  18.887  1.00 28.10           N  
ATOM    990  CA  ALA A 151      24.818  15.462  19.367  1.00 24.13           C  
ATOM    991  C   ALA A 151      24.405  14.317  18.450  1.00 21.17           C  
ATOM    992  O   ALA A 151      24.401  14.497  17.231  1.00 21.76           O  
ATOM    993  CB  ALA A 151      23.882  16.662  19.195  1.00 23.91           C  
ATOM    994  N   PRO A 152      24.130  13.117  19.012  1.00 18.06           N  
ATOM    995  CA  PRO A 152      23.749  11.972  18.162  1.00 15.68           C  
ATOM    996  C   PRO A 152      22.382  12.195  17.519  1.00 13.76           C  
ATOM    997  O   PRO A 152      21.506  12.778  18.163  1.00 13.30           O  
ATOM    998  CB  PRO A 152      23.652  10.804  19.158  1.00 15.24           C  
ATOM    999  CG  PRO A 152      23.529  11.457  20.513  1.00 16.77           C  
ATOM   1000  CD  PRO A 152      24.162  12.777  20.447  1.00 16.99           C  
ATOM   1001  N   HIS A 153      22.185  11.687  16.303  1.00 11.84           N  
ATOM   1002  CA  HIS A 153      20.872  11.772  15.609  1.00 10.04           C  
ATOM   1003  C   HIS A 153      19.723  11.073  16.377  1.00  9.81           C  
ATOM   1004  O   HIS A 153      18.546  11.495  16.346  1.00  9.16           O  
ATOM   1005  CB  HIS A 153      20.963  11.148  14.208  1.00  9.88           C  
ATOM   1006  CG  HIS A 153      21.854  11.861  13.246  1.00  8.79           C  
ATOM   1007  ND1 HIS A 153      22.761  11.201  12.447  1.00  9.90           N  
ATOM   1008  CD2 HIS A 153      21.940  13.168  12.906  1.00  9.56           C  
ATOM   1009  CE1 HIS A 153      23.394  12.076  11.684  1.00  8.90           C  
ATOM   1010  NE2 HIS A 153      22.911  13.274  11.942  1.00  7.53           N  
ATOM   1011  N   ILE A 154      20.056   9.984  17.061  1.00  9.49           N  
ATOM   1012  CA  ILE A 154      19.028   9.147  17.737  1.00  8.83           C  
ATOM   1013  C   ILE A 154      19.513   8.749  19.112  1.00  9.46           C  
ATOM   1014  O   ILE A 154      20.667   8.340  19.292  1.00 10.14           O  
ATOM   1015  CB  ILE A 154      18.715   7.874  16.940  1.00  8.30           C  
ATOM   1016  CG1 ILE A 154      18.469   8.214  15.475  1.00  7.78           C  
ATOM   1017  CG2 ILE A 154      17.525   7.058  17.568  1.00  8.76           C  
ATOM   1018  CD1 ILE A 154      18.862   7.069  14.492  1.00  7.92           C  
ATOM   1019  N   ILE A 155      18.652   8.930  20.107  1.00  9.96           N  
ATOM   1020  CA  ILE A 155      18.951   8.463  21.443  1.00  9.52           C  
ATOM   1021  C   ILE A 155      17.987   7.324  21.749  1.00  8.83           C  
ATOM   1022  O   ILE A 155      16.807   7.462  21.516  1.00  8.32           O  
ATOM   1023  CB  ILE A 155      18.762   9.594  22.525  1.00  9.84           C  
ATOM   1024  CG1 ILE A 155      19.808  10.724  22.399  1.00 11.28           C  
ATOM   1025  CG2 ILE A 155      18.767   8.998  23.959  1.00  8.80           C  
ATOM   1026  CD1 ILE A 155      21.274  10.349  22.686  1.00 13.10           C  
ATOM   1027  N   VAL A 156      18.494   6.228  22.316  1.00  8.90           N  
ATOM   1028  CA  VAL A 156      17.663   5.208  22.922  1.00  8.57           C  
ATOM   1029  C   VAL A 156      17.967   5.106  24.417  1.00  9.22           C  
ATOM   1030  O   VAL A 156      19.100   5.027  24.807  1.00 10.02           O  
ATOM   1031  CB  VAL A 156      17.804   3.800  22.242  1.00  9.16           C  
ATOM   1032  CG1 VAL A 156      19.230   3.299  22.258  1.00  9.38           C  
ATOM   1033  CG2 VAL A 156      16.913   2.797  22.973  1.00  7.69           C  
ATOM   1034  N   GLY A 157      16.967   5.102  25.277  1.00  8.78           N  
ATOM   1035  CA  GLY A 157      17.295   5.058  26.670  1.00  8.01           C  
ATOM   1036  C   GLY A 157      16.117   4.610  27.474  1.00  8.54           C  
ATOM   1037  O   GLY A 157      15.046   4.373  26.921  1.00  7.47           O  
ATOM   1038  N   THR A 158      16.345   4.472  28.781  1.00  8.50           N  
ATOM   1039  CA  THR A 158      15.300   4.169  29.729  1.00  8.77           C  
ATOM   1040  C   THR A 158      14.758   5.495  30.270  1.00  8.73           C  
ATOM   1041  O   THR A 158      15.499   6.500  30.272  1.00  7.49           O  
ATOM   1042  CB  THR A 158      15.819   3.252  30.889  1.00  8.91           C  
ATOM   1043  OG1 THR A 158      16.925   3.868  31.566  1.00  9.65           O  
ATOM   1044  CG2 THR A 158      16.271   1.911  30.342  1.00  9.32           C  
ATOM   1045  N   PRO A 159      13.472   5.507  30.723  1.00  9.05           N  
ATOM   1046  CA  PRO A 159      12.776   6.787  31.035  1.00  8.55           C  
ATOM   1047  C   PRO A 159      13.375   7.706  32.116  1.00  9.49           C  
ATOM   1048  O   PRO A 159      13.388   8.935  31.925  1.00  9.57           O  
ATOM   1049  CB  PRO A 159      11.357   6.348  31.392  1.00  8.57           C  
ATOM   1050  CG  PRO A 159      11.208   4.930  30.735  1.00  6.74           C  
ATOM   1051  CD  PRO A 159      12.575   4.337  30.892  1.00  8.05           C  
ATOM   1052  N   GLY A 160      13.860   7.150  33.221  1.00  9.74           N  
ATOM   1053  CA  GLY A 160      14.503   7.955  34.263  1.00  9.38           C  
ATOM   1054  C   GLY A 160      15.774   8.602  33.734  1.00  9.86           C  
ATOM   1055  O   GLY A 160      16.015   9.800  33.922  1.00  9.57           O  
ATOM   1056  N   ARG A 161      16.594   7.808  33.057  1.00  9.60           N  
ATOM   1057  CA  ARG A 161      17.860   8.297  32.571  1.00 10.30           C  
ATOM   1058  C   ARG A 161      17.701   9.374  31.483  1.00 10.35           C  
ATOM   1059  O   ARG A 161      18.409  10.390  31.510  1.00 10.58           O  
ATOM   1060  CB  ARG A 161      18.715   7.139  32.097  1.00 10.39           C  
ATOM   1061  CG  ARG A 161      20.004   7.569  31.445  1.00 14.34           C  
ATOM   1062  CD  ARG A 161      20.881   8.540  32.288  1.00 17.77           C  
ATOM   1063  NE  ARG A 161      22.281   8.304  31.957  1.00 21.55           N  
ATOM   1064  CZ  ARG A 161      22.903   8.812  30.892  1.00 24.16           C  
ATOM   1065  NH1 ARG A 161      22.273   9.634  30.068  1.00 24.42           N  
ATOM   1066  NH2 ARG A 161      24.174   8.515  30.651  1.00 24.09           N  
ATOM   1067  N   VAL A 162      16.786   9.146  30.540  1.00  9.77           N  
ATOM   1068  CA  VAL A 162      16.497  10.101  29.497  1.00  9.49           C  
ATOM   1069  C   VAL A 162      15.871  11.389  30.057  1.00  9.93           C  
ATOM   1070  O   VAL A 162      16.241  12.494  29.648  1.00  8.71           O  
ATOM   1071  CB  VAL A 162      15.594   9.502  28.406  1.00  9.43           C  
ATOM   1072  CG1 VAL A 162      15.149  10.572  27.407  1.00  7.26           C  
ATOM   1073  CG2 VAL A 162      16.330   8.384  27.661  1.00 11.65           C  
ATOM   1074  N   PHE A 163      14.917  11.265  30.985  1.00 10.82           N  
ATOM   1075  CA  PHE A 163      14.395  12.466  31.604  1.00 11.23           C  
ATOM   1076  C   PHE A 163      15.464  13.284  32.349  1.00 11.75           C  
ATOM   1077  O   PHE A 163      15.461  14.511  32.291  1.00 10.47           O  
ATOM   1078  CB  PHE A 163      13.144  12.230  32.462  1.00 11.85           C  
ATOM   1079  CG  PHE A 163      12.623  13.490  33.081  1.00 11.19           C  
ATOM   1080  CD1 PHE A 163      11.989  14.454  32.294  1.00 12.75           C  
ATOM   1081  CD2 PHE A 163      12.845  13.751  34.425  1.00 11.55           C  
ATOM   1082  CE1 PHE A 163      11.522  15.656  32.869  1.00 13.68           C  
ATOM   1083  CE2 PHE A 163      12.381  14.933  35.033  1.00 13.10           C  
ATOM   1084  CZ  PHE A 163      11.713  15.888  34.251  1.00 13.34           C  
ATOM   1085  N   ASP A 164      16.386  12.588  33.007  1.00 12.84           N  
ATOM   1086  CA  ASP A 164      17.521  13.221  33.656  1.00 14.54           C  
ATOM   1087  C   ASP A 164      18.331  14.090  32.700  1.00 14.57           C  
ATOM   1088  O   ASP A 164      18.692  15.219  33.026  1.00 14.69           O  
ATOM   1089  CB  ASP A 164      18.433  12.165  34.297  1.00 15.55           C  
ATOM   1090  CG  ASP A 164      17.952  11.720  35.697  1.00 18.21           C  
ATOM   1091  OD1 ASP A 164      17.251  12.511  36.377  1.00 20.63           O  
ATOM   1092  OD2 ASP A 164      18.285  10.578  36.112  1.00 20.76           O  
ATOM   1093  N   MET A 165      18.615  13.562  31.521  1.00 14.74           N  
ATOM   1094  CA  MET A 165      19.406  14.302  30.543  1.00 15.26           C  
ATOM   1095  C   MET A 165      18.612  15.451  29.901  1.00 14.98           C  
ATOM   1096  O   MET A 165      19.171  16.468  29.560  1.00 14.60           O  
ATOM   1097  CB  MET A 165      19.975  13.333  29.502  1.00 15.52           C  
ATOM   1098  CG  MET A 165      20.771  12.194  30.113  1.00 16.56           C  
ATOM   1099  SD  MET A 165      22.353  12.586  30.912  1.00 25.00           S  
ATOM   1100  CE  MET A 165      21.899  12.929  32.624  1.00 19.59           C  
ATOM   1101  N   LEU A 166      17.300  15.284  29.749  1.00 14.97           N  
ATOM   1102  CA  LEU A 166      16.459  16.404  29.327  1.00 14.84           C  
ATOM   1103  C   LEU A 166      16.440  17.513  30.382  1.00 15.37           C  
ATOM   1104  O   LEU A 166      16.652  18.684  30.054  1.00 14.62           O  
ATOM   1105  CB  LEU A 166      15.044  15.939  28.944  1.00 14.50           C  
ATOM   1106  CG  LEU A 166      14.901  15.299  27.548  1.00 13.62           C  
ATOM   1107  CD1 LEU A 166      13.515  14.740  27.299  1.00 14.40           C  
ATOM   1108  CD2 LEU A 166      15.271  16.274  26.435  1.00 12.33           C  
ATOM   1109  N   ASN A 167      16.217  17.100  31.642  1.00 16.02           N  
ATOM   1110  CA  ASN A 167      16.068  17.963  32.822  1.00 15.80           C  
ATOM   1111  C   ASN A 167      17.265  18.834  33.011  1.00 15.76           C  
ATOM   1112  O   ASN A 167      17.129  20.037  33.183  1.00 15.60           O  
ATOM   1113  CB  ASN A 167      15.872  17.119  34.098  1.00 15.86           C  
ATOM   1114  CG  ASN A 167      15.335  17.934  35.276  1.00 16.46           C  
ATOM   1115  OD1 ASN A 167      14.407  18.717  35.116  1.00 17.18           O  
ATOM   1116  ND2 ASN A 167      15.909  17.732  36.466  1.00 15.01           N  
ATOM   1117  N   ARG A 168      18.436  18.201  32.983  1.00 16.01           N  
ATOM   1118  CA  ARG A 168      19.725  18.874  33.151  1.00 16.53           C  
ATOM   1119  C   ARG A 168      20.336  19.371  31.815  1.00 15.25           C  
ATOM   1120  O   ARG A 168      21.458  19.911  31.796  1.00 14.53           O  
ATOM   1121  CB  ARG A 168      20.698  17.955  33.903  1.00 16.16           C  
ATOM   1122  CG  ARG A 168      20.255  17.631  35.330  1.00 18.33           C  
ATOM   1123  CD  ARG A 168      21.126  16.541  35.962  1.00 20.73           C  
ATOM   1124  NE  ARG A 168      20.619  16.080  37.271  1.00 29.89           N  
ATOM   1125  CZ  ARG A 168      19.793  15.039  37.440  1.00 32.08           C  
ATOM   1126  NH1 ARG A 168      19.364  14.355  36.391  1.00 33.15           N  
ATOM   1127  NH2 ARG A 168      19.381  14.679  38.658  1.00 34.15           N  
ATOM   1128  N   ARG A 169      19.600  19.162  30.715  1.00 14.32           N  
ATOM   1129  CA  ARG A 169      19.863  19.815  29.423  1.00 13.52           C  
ATOM   1130  C   ARG A 169      21.129  19.308  28.716  1.00 13.07           C  
ATOM   1131  O   ARG A 169      21.779  20.052  27.986  1.00 12.26           O  
ATOM   1132  CB  ARG A 169      19.923  21.350  29.586  1.00 13.60           C  
ATOM   1133  CG  ARG A 169      18.576  22.026  29.838  1.00 14.20           C  
ATOM   1134  CD  ARG A 169      18.766  23.443  30.312  1.00 15.32           C  
ATOM   1135  NE  ARG A 169      19.736  24.144  29.471  1.00 18.17           N  
ATOM   1136  CZ  ARG A 169      19.421  25.044  28.543  1.00 16.70           C  
ATOM   1137  NH1 ARG A 169      18.140  25.338  28.376  1.00 15.42           N  
ATOM   1138  NH2 ARG A 169      20.371  25.651  27.805  1.00 10.43           N  
ATOM   1139  N   TYR A 170      21.485  18.051  28.947  1.00 12.95           N  
ATOM   1140  CA  TYR A 170      22.534  17.411  28.166  1.00 13.48           C  
ATOM   1141  C   TYR A 170      21.958  17.003  26.818  1.00 13.45           C  
ATOM   1142  O   TYR A 170      22.684  16.824  25.846  1.00 13.84           O  
ATOM   1143  CB  TYR A 170      23.112  16.208  28.907  1.00 13.85           C  
ATOM   1144  CG  TYR A 170      23.907  16.589  30.121  1.00 14.28           C  
ATOM   1145  CD1 TYR A 170      25.259  16.932  30.014  1.00 16.46           C  
ATOM   1146  CD2 TYR A 170      23.318  16.611  31.384  1.00 15.83           C  
ATOM   1147  CE1 TYR A 170      26.016  17.300  31.161  1.00 17.04           C  
ATOM   1148  CE2 TYR A 170      24.058  16.976  32.531  1.00 17.18           C  
ATOM   1149  CZ  TYR A 170      25.398  17.320  32.408  1.00 15.94           C  
ATOM   1150  OH  TYR A 170      26.118  17.656  33.525  1.00 16.19           O  
ATOM   1151  N   LEU A 171      20.636  16.861  26.779  1.00 13.45           N  
ATOM   1152  CA  LEU A 171      19.913  16.540  25.559  1.00 12.66           C  
ATOM   1153  C   LEU A 171      18.881  17.626  25.380  1.00 11.70           C  
ATOM   1154  O   LEU A 171      18.247  18.072  26.351  1.00 11.63           O  
ATOM   1155  CB  LEU A 171      19.270  15.136  25.645  1.00 12.79           C  
ATOM   1156  CG  LEU A 171      18.113  14.673  24.728  1.00 14.69           C  
ATOM   1157  CD1 LEU A 171      18.430  14.836  23.233  1.00 17.11           C  
ATOM   1158  CD2 LEU A 171      17.651  13.223  25.022  1.00 13.52           C  
ATOM   1159  N   SER A 172      18.740  18.054  24.131  1.00 10.52           N  
ATOM   1160  CA  SER A 172      17.784  19.070  23.712  1.00  9.52           C  
ATOM   1161  C   SER A 172      16.583  18.443  22.956  1.00  9.48           C  
ATOM   1162  O   SER A 172      16.755  17.638  22.017  1.00  8.88           O  
ATOM   1163  CB  SER A 172      18.521  20.119  22.866  1.00  9.43           C  
ATOM   1164  OG  SER A 172      17.671  21.042  22.231  1.00  8.97           O  
ATOM   1165  N   PRO A 173      15.359  18.819  23.366  1.00  8.82           N  
ATOM   1166  CA  PRO A 173      14.154  18.366  22.686  1.00  8.51           C  
ATOM   1167  C   PRO A 173      13.953  19.111  21.359  1.00  7.85           C  
ATOM   1168  O   PRO A 173      13.037  18.790  20.606  1.00  7.89           O  
ATOM   1169  CB  PRO A 173      13.044  18.717  23.690  1.00  8.71           C  
ATOM   1170  CG  PRO A 173      13.558  19.972  24.352  1.00  8.93           C  
ATOM   1171  CD  PRO A 173      15.050  19.729  24.493  1.00  9.24           C  
HETATM 1172  N   MLY A 174      14.676  20.140  20.895  1.00  6.16           N  
HETATM 1173  CA  MLY A 174      14.437  21.207  19.936  1.00  6.09           C  
HETATM 1174  CB  MLY A 174      15.663  22.065  19.900  1.00  5.69           C  
HETATM 1175  CG  MLY A 174      15.419  23.256  19.008  1.00  5.13           C  
HETATM 1176  CD  MLY A 174      16.529  24.274  19.224  1.00  6.44           C  
HETATM 1177  CE  MLY A 174      16.568  25.247  18.059  1.00  6.27           C  
HETATM 1178  NZ  MLY A 174      16.955  26.586  18.494  1.00  9.77           N  
HETATM 1179  CH1 MLY A 174      17.657  26.599  19.796  1.00 10.56           C  
HETATM 1180  CH2 MLY A 174      17.761  27.216  17.430  1.00  9.02           C  
HETATM 1181  C   MLY A 174      14.175  20.612  18.536  1.00  6.63           C  
HETATM 1182  O   MLY A 174      13.135  20.971  17.935  1.00  7.61           O  
ATOM   1183  N   TYR A 175      14.875  19.597  18.065  1.00  5.48           N  
ATOM   1184  CA  TYR A 175      14.890  18.841  16.783  1.00  4.14           C  
ATOM   1185  C   TYR A 175      14.314  17.438  16.916  1.00  4.16           C  
ATOM   1186  O   TYR A 175      14.373  16.684  15.954  1.00  4.35           O  
ATOM   1187  CB  TYR A 175      16.305  18.815  16.205  1.00  3.33           C  
ATOM   1188  CG  TYR A 175      16.887  20.207  16.043  1.00  4.27           C  
ATOM   1189  CD1 TYR A 175      16.457  21.056  15.023  1.00  4.79           C  
ATOM   1190  CD2 TYR A 175      17.832  20.699  16.947  1.00  3.81           C  
ATOM   1191  CE1 TYR A 175      16.991  22.371  14.889  1.00  4.10           C  
ATOM   1192  CE2 TYR A 175      18.379  21.975  16.805  1.00  4.65           C  
ATOM   1193  CZ  TYR A 175      17.961  22.797  15.786  1.00  4.11           C  
ATOM   1194  OH  TYR A 175      18.503  24.043  15.695  1.00  3.76           O  
ATOM   1195  N   ILE A 176      13.780  17.072  18.083  1.00  3.88           N  
ATOM   1196  CA  ILE A 176      13.231  15.719  18.233  1.00  5.45           C  
ATOM   1197  C   ILE A 176      11.843  15.535  17.566  1.00  6.68           C  
ATOM   1198  O   ILE A 176      10.930  16.330  17.765  1.00  6.46           O  
ATOM   1199  CB  ILE A 176      13.180  15.195  19.692  1.00  6.18           C  
ATOM   1200  CG1 ILE A 176      14.586  15.084  20.310  1.00  4.57           C  
ATOM   1201  CG2 ILE A 176      12.424  13.839  19.719  1.00  5.19           C  
ATOM   1202  CD1 ILE A 176      14.558  14.594  21.780  1.00  4.72           C  
HETATM 1203  N   MLY A 177      11.992  15.072  16.329  1.00  9.96           N  
HETATM 1204  CA  MLY A 177      10.589  15.077  15.867  1.00 11.71           C  
HETATM 1205  CB  MLY A 177      10.460  16.044  14.654  1.00 13.61           C  
HETATM 1206  CG  MLY A 177      10.894  15.501  13.320  1.00 15.82           C  
HETATM 1207  CD  MLY A 177      11.584  16.641  12.582  1.00 19.41           C  
HETATM 1208  CE  MLY A 177      13.120  16.385  12.702  1.00 25.85           C  
HETATM 1209  NZ  MLY A 177      13.650  15.667  11.507  1.00 26.49           N  
HETATM 1210  CH1 MLY A 177      14.905  16.302  11.102  1.00 24.78           C  
HETATM 1211  CH2 MLY A 177      13.857  14.226  11.711  1.00 25.86           C  
HETATM 1212  C   MLY A 177      10.060  13.661  15.596  1.00 11.21           C  
HETATM 1213  O   MLY A 177       8.835  13.526  15.370  1.00 11.00           O  
ATOM   1214  N   MET A 178      10.497  12.655  16.379  1.00 10.42           N  
ATOM   1215  CA  MET A 178      10.066  11.228  16.465  1.00 11.85           C  
ATOM   1216  C   MET A 178      10.312  10.722  17.880  1.00 10.78           C  
ATOM   1217  O   MET A 178      11.411  10.863  18.413  1.00 10.66           O  
ATOM   1218  CB  MET A 178      10.739  10.371  15.398  1.00 11.90           C  
ATOM   1219  CG  MET A 178      10.605   8.875  15.620  1.00 16.96           C  
ATOM   1220  SD  MET A 178       8.894   8.246  15.460  1.00 21.94           S  
ATOM   1221  CE  MET A 178       9.095   7.347  13.906  1.00 19.61           C  
ATOM   1222  N   PHE A 179       9.246  10.227  18.503  1.00 10.25           N  
ATOM   1223  CA  PHE A 179       9.284   9.725  19.873  1.00 10.83           C  
ATOM   1224  C   PHE A 179       8.666   8.312  19.924  1.00 11.74           C  
ATOM   1225  O   PHE A 179       7.450   8.149  19.632  1.00 11.93           O  
ATOM   1226  CB  PHE A 179       8.519  10.687  20.786  1.00 10.03           C  
ATOM   1227  CG  PHE A 179       8.547  10.341  22.235  1.00  8.53           C  
ATOM   1228  CD1 PHE A 179       9.706   9.945  22.862  1.00  6.56           C  
ATOM   1229  CD2 PHE A 179       7.396  10.474  22.997  1.00  8.81           C  
ATOM   1230  CE1 PHE A 179       9.713   9.670  24.223  1.00  7.37           C  
ATOM   1231  CE2 PHE A 179       7.408  10.221  24.346  1.00  9.64           C  
ATOM   1232  CZ  PHE A 179       8.550   9.817  24.956  1.00  9.98           C  
ATOM   1233  N   VAL A 180       9.496   7.315  20.281  1.00 10.81           N  
ATOM   1234  CA  VAL A 180       9.085   5.926  20.240  1.00  9.87           C  
ATOM   1235  C   VAL A 180       9.086   5.349  21.659  1.00 10.50           C  
ATOM   1236  O   VAL A 180      10.063   5.509  22.428  1.00 10.12           O  
ATOM   1237  CB  VAL A 180       9.992   5.071  19.315  1.00 10.34           C  
ATOM   1238  CG1 VAL A 180       9.514   3.567  19.307  1.00  9.89           C  
ATOM   1239  CG2 VAL A 180      10.058   5.625  17.851  1.00  9.93           C  
ATOM   1240  N   LEU A 181       7.987   4.674  21.980  1.00 10.86           N  
ATOM   1241  CA  LEU A 181       7.754   4.049  23.278  1.00 12.28           C  
ATOM   1242  C   LEU A 181       7.615   2.540  23.029  1.00 13.21           C  
ATOM   1243  O   LEU A 181       6.557   2.052  22.577  1.00 11.89           O  
ATOM   1244  CB  LEU A 181       6.456   4.584  23.908  1.00 13.10           C  
ATOM   1245  CG  LEU A 181       6.316   6.100  24.192  1.00 14.55           C  
ATOM   1246  CD1 LEU A 181       5.127   6.400  25.112  1.00 15.90           C  
ATOM   1247  CD2 LEU A 181       7.583   6.607  24.852  1.00 15.49           C  
ATOM   1248  N   ASP A 182       8.714   1.807  23.255  1.00 13.61           N  
ATOM   1249  CA  ASP A 182       8.709   0.368  22.969  1.00 13.39           C  
ATOM   1250  C   ASP A 182       8.345  -0.361  24.250  1.00 13.13           C  
ATOM   1251  O   ASP A 182       8.916  -0.065  25.306  1.00 12.31           O  
ATOM   1252  CB  ASP A 182      10.064  -0.073  22.442  1.00 13.52           C  
ATOM   1253  CG  ASP A 182      10.048  -1.486  21.940  1.00 15.77           C  
ATOM   1254  OD1 ASP A 182       8.998  -1.941  21.431  1.00 15.49           O  
ATOM   1255  OD2 ASP A 182      11.097  -2.150  22.045  1.00 17.12           O  
ATOM   1256  N   GLU A 183       7.377  -1.285  24.175  1.00 11.89           N  
ATOM   1257  CA  GLU A 183       6.954  -2.060  25.372  1.00 11.96           C  
ATOM   1258  C   GLU A 183       6.377  -1.118  26.420  1.00 11.36           C  
ATOM   1259  O   GLU A 183       6.867  -1.008  27.529  1.00 10.38           O  
ATOM   1260  CB  GLU A 183       8.130  -2.863  25.964  1.00 12.20           C  
ATOM   1261  CG  GLU A 183       8.647  -3.900  25.013  1.00 15.10           C  
ATOM   1262  CD  GLU A 183       9.481  -4.965  25.664  1.00 21.09           C  
ATOM   1263  OE1 GLU A 183       9.802  -4.866  26.883  1.00 23.62           O  
ATOM   1264  OE2 GLU A 183       9.832  -5.909  24.930  1.00 22.43           O  
ATOM   1265  N   ALA A 184       5.319  -0.423  26.038  1.00 11.73           N  
ATOM   1266  CA  ALA A 184       4.780   0.631  26.866  1.00 11.04           C  
ATOM   1267  C   ALA A 184       4.224   0.047  28.143  1.00 10.52           C  
ATOM   1268  O   ALA A 184       4.366   0.655  29.188  1.00 10.08           O  
ATOM   1269  CB  ALA A 184       3.723   1.421  26.108  1.00 10.75           C  
ATOM   1270  N   ASP A 185       3.626  -1.152  28.055  1.00 10.53           N  
ATOM   1271  CA  ASP A 185       3.028  -1.807  29.205  1.00  8.97           C  
ATOM   1272  C   ASP A 185       4.097  -2.089  30.280  1.00  8.78           C  
ATOM   1273  O   ASP A 185       3.858  -1.832  31.468  1.00  6.59           O  
ATOM   1274  CB  ASP A 185       2.252  -3.090  28.803  1.00  9.79           C  
ATOM   1275  CG  ASP A 185       3.084  -4.117  27.973  1.00 11.58           C  
ATOM   1276  OD1 ASP A 185       4.232  -3.858  27.513  1.00 14.14           O  
ATOM   1277  OD2 ASP A 185       2.554  -5.227  27.751  1.00 12.01           O  
ATOM   1278  N   GLU A 186       5.254  -2.616  29.845  1.00  7.75           N  
ATOM   1279  CA  GLU A 186       6.394  -2.904  30.732  1.00  8.69           C  
ATOM   1280  C   GLU A 186       6.918  -1.661  31.424  1.00  8.23           C  
ATOM   1281  O   GLU A 186       7.290  -1.700  32.589  1.00  7.72           O  
ATOM   1282  CB  GLU A 186       7.577  -3.482  29.944  1.00  9.30           C  
ATOM   1283  CG  GLU A 186       7.374  -4.868  29.411  1.00 14.16           C  
ATOM   1284  CD  GLU A 186       7.261  -5.903  30.506  1.00 21.83           C  
ATOM   1285  OE1 GLU A 186       7.755  -5.669  31.656  1.00 22.70           O  
ATOM   1286  OE2 GLU A 186       6.670  -6.968  30.194  1.00 27.15           O  
ATOM   1287  N   MET A 187       6.983  -0.571  30.675  1.00  8.25           N  
ATOM   1288  CA  MET A 187       7.418   0.679  31.243  1.00  8.99           C  
ATOM   1289  C   MET A 187       6.454   1.148  32.311  1.00  8.59           C  
ATOM   1290  O   MET A 187       6.895   1.617  33.367  1.00  8.85           O  
ATOM   1291  CB  MET A 187       7.599   1.724  30.137  1.00  8.66           C  
ATOM   1292  CG  MET A 187       8.780   1.405  29.272  1.00  6.86           C  
ATOM   1293  SD  MET A 187       9.371   2.757  28.235  1.00 10.97           S  
ATOM   1294  CE  MET A 187       7.971   3.068  27.128  1.00  3.88           C  
ATOM   1295  N   LEU A 188       5.143   1.036  32.053  1.00  7.85           N  
ATOM   1296  CA  LEU A 188       4.165   1.428  33.079  1.00  7.63           C  
ATOM   1297  C   LEU A 188       4.272   0.497  34.257  1.00  6.66           C  
ATOM   1298  O   LEU A 188       4.333   0.960  35.380  1.00  7.22           O  
ATOM   1299  CB  LEU A 188       2.715   1.535  32.556  1.00  7.75           C  
ATOM   1300  CG  LEU A 188       2.577   2.545  31.414  1.00 10.16           C  
ATOM   1301  CD1 LEU A 188       1.138   2.697  30.928  1.00 13.23           C  
ATOM   1302  CD2 LEU A 188       3.138   3.916  31.773  1.00 12.14           C  
ATOM   1303  N   SER A 189       4.353  -0.806  34.005  1.00  6.51           N  
ATOM   1304  CA  SER A 189       4.499  -1.773  35.083  1.00  7.21           C  
ATOM   1305  C   SER A 189       5.707  -1.491  35.986  1.00  6.51           C  
ATOM   1306  O   SER A 189       5.622  -1.714  37.180  1.00  5.20           O  
ATOM   1307  CB  SER A 189       4.577  -3.211  34.547  1.00  7.46           C  
ATOM   1308  OG  SER A 189       3.392  -3.516  33.859  1.00 11.13           O  
ATOM   1309  N   ARG A 190       6.799  -0.994  35.396  1.00  6.36           N  
ATOM   1310  CA  ARG A 190       8.030  -0.667  36.125  1.00  7.71           C  
ATOM   1311  C   ARG A 190       8.050   0.720  36.829  1.00  8.23           C  
ATOM   1312  O   ARG A 190       9.049   1.084  37.473  1.00  9.85           O  
ATOM   1313  CB  ARG A 190       9.248  -0.822  35.216  1.00  7.14           C  
ATOM   1314  CG  ARG A 190       9.640  -2.261  34.951  1.00  9.19           C  
ATOM   1315  CD  ARG A 190      10.658  -2.330  33.807  1.00  9.33           C  
ATOM   1316  NE  ARG A 190      10.919  -3.720  33.435  1.00 11.01           N  
ATOM   1317  CZ  ARG A 190      11.847  -4.504  33.989  1.00 12.39           C  
ATOM   1318  NH1 ARG A 190      12.661  -4.036  34.933  1.00 11.71           N  
ATOM   1319  NH2 ARG A 190      11.968  -5.763  33.580  1.00  9.56           N  
ATOM   1320  N   GLY A 191       6.975   1.491  36.712  1.00  8.41           N  
ATOM   1321  CA  GLY A 191       6.830   2.727  37.503  1.00  8.49           C  
ATOM   1322  C   GLY A 191       7.304   3.950  36.749  1.00  8.23           C  
ATOM   1323  O   GLY A 191       7.592   4.968  37.360  1.00  8.17           O  
ATOM   1324  N   PHE A 192       7.382   3.852  35.418  1.00  7.62           N  
ATOM   1325  CA  PHE A 192       7.931   4.930  34.611  1.00  7.74           C  
ATOM   1326  C   PHE A 192       6.926   5.942  34.102  1.00  7.44           C  
ATOM   1327  O   PHE A 192       7.294   6.821  33.348  1.00  6.35           O  
ATOM   1328  CB  PHE A 192       8.756   4.382  33.427  1.00  8.81           C  
ATOM   1329  CG  PHE A 192      10.031   3.735  33.867  1.00  9.91           C  
ATOM   1330  CD1 PHE A 192      10.878   4.396  34.756  1.00 11.02           C  
ATOM   1331  CD2 PHE A 192      10.372   2.464  33.432  1.00  8.56           C  
ATOM   1332  CE1 PHE A 192      12.060   3.798  35.190  1.00 11.47           C  
ATOM   1333  CE2 PHE A 192      11.550   1.869  33.869  1.00  7.00           C  
ATOM   1334  CZ  PHE A 192      12.384   2.523  34.724  1.00 10.67           C  
HETATM 1335  N   MLY A 193       5.620   5.931  34.373  1.00  8.55           N  
HETATM 1336  CA  MLY A 193       4.583   6.878  33.958  1.00  9.45           C  
HETATM 1337  CB  MLY A 193       3.260   6.595  34.685  1.00  9.11           C  
HETATM 1338  CG  MLY A 193       2.138   7.253  33.881  1.00 10.47           C  
HETATM 1339  CD  MLY A 193       0.926   7.590  34.777  1.00 15.47           C  
HETATM 1340  CE  MLY A 193      -0.189   8.247  33.937  1.00 16.31           C  
HETATM 1341  NZ  MLY A 193      -1.507   8.264  34.623  1.00 18.72           N  
HETATM 1342  CH1 MLY A 193      -2.419   9.214  33.975  1.00 16.04           C  
HETATM 1343  CH2 MLY A 193      -2.138   6.928  34.607  1.00 18.69           C  
HETATM 1344  C   MLY A 193       5.035   8.300  34.294  1.00  8.44           C  
HETATM 1345  O   MLY A 193       4.984   9.122  33.362  1.00  8.77           O  
ATOM   1346  N   ASP A 194       5.542   8.738  35.425  1.00  8.68           N  
ATOM   1347  CA  ASP A 194       5.868  10.196  35.625  1.00  9.37           C  
ATOM   1348  C   ASP A 194       6.938  10.682  34.673  1.00  9.06           C  
ATOM   1349  O   ASP A 194       6.766  11.724  34.078  1.00  9.26           O  
ATOM   1350  CB  ASP A 194       6.290  10.452  37.053  1.00  9.51           C  
ATOM   1351  CG  ASP A 194       5.163  10.226  38.030  1.00 11.71           C  
ATOM   1352  OD1 ASP A 194       3.975  10.204  37.599  1.00 10.27           O  
ATOM   1353  OD2 ASP A 194       5.476  10.077  39.229  1.00 13.88           O  
ATOM   1354  N   GLN A 195       8.026   9.916  34.533  1.00  9.16           N  
ATOM   1355  CA  GLN A 195       9.153  10.213  33.612  1.00  8.74           C  
ATOM   1356  C   GLN A 195       8.666  10.309  32.178  1.00  8.58           C  
ATOM   1357  O   GLN A 195       9.014  11.223  31.449  1.00  9.48           O  
ATOM   1358  CB  GLN A 195      10.217   9.101  33.704  1.00  8.66           C  
ATOM   1359  CG  GLN A 195      10.900   8.932  35.084  1.00  8.15           C  
ATOM   1360  CD  GLN A 195       9.938   8.572  36.239  1.00 10.66           C  
ATOM   1361  OE1 GLN A 195       9.137   7.619  36.157  1.00  6.49           O  
ATOM   1362  NE2 GLN A 195      10.051   9.326  37.344  1.00 11.12           N  
ATOM   1363  N   ILE A 196       7.847   9.356  31.766  1.00  8.17           N  
ATOM   1364  CA  ILE A 196       7.336   9.346  30.392  1.00  7.58           C  
ATOM   1365  C   ILE A 196       6.484  10.581  30.076  1.00  7.57           C  
ATOM   1366  O   ILE A 196       6.611  11.165  28.975  1.00  5.59           O  
ATOM   1367  CB  ILE A 196       6.470   8.106  30.069  1.00  7.88           C  
ATOM   1368  CG1 ILE A 196       7.326   6.822  30.001  1.00  7.85           C  
ATOM   1369  CG2 ILE A 196       5.649   8.349  28.743  1.00  4.79           C  
ATOM   1370  CD1 ILE A 196       6.443   5.532  30.039  1.00  5.79           C  
ATOM   1371  N   TYR A 197       5.594  10.929  31.021  1.00  7.24           N  
ATOM   1372  CA  TYR A 197       4.751  12.121  30.911  1.00  8.02           C  
ATOM   1373  C   TYR A 197       5.586  13.398  30.967  1.00  8.83           C  
ATOM   1374  O   TYR A 197       5.271  14.388  30.285  1.00 10.89           O  
ATOM   1375  CB  TYR A 197       3.654  12.153  31.999  1.00  8.37           C  
ATOM   1376  CG  TYR A 197       2.379  11.423  31.581  1.00 10.19           C  
ATOM   1377  CD1 TYR A 197       2.414  10.034  31.298  1.00  9.80           C  
ATOM   1378  CD2 TYR A 197       1.145  12.106  31.455  1.00  8.93           C  
ATOM   1379  CE1 TYR A 197       1.278   9.380  30.888  1.00 11.32           C  
ATOM   1380  CE2 TYR A 197      -0.002  11.443  31.060  1.00  6.97           C  
ATOM   1381  CZ  TYR A 197       0.065  10.078  30.780  1.00  8.16           C  
ATOM   1382  OH  TYR A 197      -1.042   9.336  30.381  1.00  9.80           O  
ATOM   1383  N   ASP A 198       6.636  13.393  31.772  1.00  8.02           N  
ATOM   1384  CA  ASP A 198       7.464  14.551  31.898  1.00  8.30           C  
ATOM   1385  C   ASP A 198       8.269  14.782  30.622  1.00  7.90           C  
ATOM   1386  O   ASP A 198       8.424  15.937  30.210  1.00  6.85           O  
ATOM   1387  CB  ASP A 198       8.361  14.427  33.128  1.00  9.33           C  
ATOM   1388  CG  ASP A 198       7.572  14.550  34.462  1.00 13.34           C  
ATOM   1389  OD1 ASP A 198       6.309  14.695  34.453  1.00 18.33           O  
ATOM   1390  OD2 ASP A 198       8.217  14.487  35.529  1.00 15.05           O  
ATOM   1391  N   ILE A 199       8.745  13.678  30.001  1.00  7.34           N  
ATOM   1392  CA  ILE A 199       9.418  13.719  28.713  1.00  6.58           C  
ATOM   1393  C   ILE A 199       8.480  14.211  27.615  1.00  6.69           C  
ATOM   1394  O   ILE A 199       8.849  15.105  26.855  1.00  5.79           O  
ATOM   1395  CB  ILE A 199      10.121  12.368  28.303  1.00  6.41           C  
ATOM   1396  CG1 ILE A 199      11.292  12.082  29.250  1.00  5.95           C  
ATOM   1397  CG2 ILE A 199      10.631  12.451  26.831  1.00  2.65           C  
ATOM   1398  CD1 ILE A 199      11.752  10.563  29.270  1.00  6.74           C  
ATOM   1399  N   PHE A 200       7.293  13.611  27.524  1.00  7.85           N  
ATOM   1400  CA  PHE A 200       6.211  14.134  26.670  1.00  9.56           C  
ATOM   1401  C   PHE A 200       6.065  15.678  26.761  1.00  9.89           C  
ATOM   1402  O   PHE A 200       6.168  16.359  25.760  1.00  8.96           O  
ATOM   1403  CB  PHE A 200       4.865  13.481  26.985  1.00 10.01           C  
ATOM   1404  CG  PHE A 200       4.501  12.384  26.067  1.00 12.72           C  
ATOM   1405  CD1 PHE A 200       4.383  12.616  24.687  1.00 13.28           C  
ATOM   1406  CD2 PHE A 200       4.282  11.071  26.577  1.00 15.71           C  
ATOM   1407  CE1 PHE A 200       4.047  11.559  23.827  1.00 15.63           C  
ATOM   1408  CE2 PHE A 200       3.944   9.990  25.732  1.00 13.69           C  
ATOM   1409  CZ  PHE A 200       3.804  10.233  24.358  1.00 14.43           C  
ATOM   1410  N   GLN A 201       5.832  16.194  27.966  1.00 10.78           N  
ATOM   1411  CA  GLN A 201       5.716  17.641  28.212  1.00 13.38           C  
ATOM   1412  C   GLN A 201       6.939  18.369  27.653  1.00 12.08           C  
ATOM   1413  O   GLN A 201       6.886  19.537  27.307  1.00 12.57           O  
ATOM   1414  CB  GLN A 201       5.590  17.895  29.718  1.00 12.93           C  
ATOM   1415  CG  GLN A 201       5.419  19.361  30.136  1.00 16.23           C  
ATOM   1416  CD  GLN A 201       5.152  19.509  31.641  1.00 19.26           C  
ATOM   1417  OE1 GLN A 201       5.991  19.123  32.485  1.00 26.44           O  
ATOM   1418  NE2 GLN A 201       3.977  20.056  31.993  1.00 24.17           N  
HETATM 1419  N   MLY A 202       8.204  17.954  27.707  1.00 11.32           N  
HETATM 1420  CA  MLY A 202       9.436  18.581  27.267  1.00 10.52           C  
HETATM 1421  CB  MLY A 202      10.617  17.876  27.947  1.00 10.91           C  
HETATM 1422  CG  MLY A 202      11.420  18.872  28.766  1.00 14.92           C  
HETATM 1423  CD  MLY A 202      11.290  18.627  30.275  1.00 19.41           C  
HETATM 1424  CE  MLY A 202      12.454  19.268  31.057  1.00 21.41           C  
HETATM 1425  NZ  MLY A 202      12.513  20.737  30.853  1.00 26.56           N  
HETATM 1426  CH1 MLY A 202      11.610  21.470  31.771  1.00 25.52           C  
HETATM 1427  CH2 MLY A 202      13.893  21.229  31.067  1.00 25.87           C  
HETATM 1428  C   MLY A 202       9.494  18.490  25.748  1.00 10.10           C  
HETATM 1429  O   MLY A 202      10.250  19.311  25.188  1.00  9.13           O  
ATOM   1430  N   LEU A 203       8.887  17.567  24.971  1.00  9.64           N  
ATOM   1431  CA  LEU A 203       8.911  17.536  23.496  1.00  9.13           C  
ATOM   1432  C   LEU A 203       8.004  18.583  22.867  1.00  9.71           C  
ATOM   1433  O   LEU A 203       6.994  18.978  23.452  1.00  8.97           O  
ATOM   1434  CB  LEU A 203       8.556  16.129  22.964  1.00  9.51           C  
ATOM   1435  CG  LEU A 203       9.413  14.989  23.524  1.00 10.31           C  
ATOM   1436  CD1 LEU A 203       8.949  13.610  22.966  1.00 10.91           C  
ATOM   1437  CD2 LEU A 203      10.916  15.214  23.320  1.00  7.20           C  
ATOM   1438  N   ASN A 204       8.370  19.012  21.656  1.00 10.05           N  
ATOM   1439  CA  ASN A 204       7.505  19.852  20.831  1.00 10.57           C  
ATOM   1440  C   ASN A 204       6.126  19.219  20.639  1.00 11.42           C  
ATOM   1441  O   ASN A 204       6.009  17.999  20.434  1.00 10.24           O  
ATOM   1442  CB  ASN A 204       8.148  20.076  19.461  1.00 10.09           C  
ATOM   1443  CG  ASN A 204       9.448  20.883  19.541  1.00 10.74           C  
ATOM   1444  OD1 ASN A 204       9.733  21.562  20.547  1.00  9.02           O  
ATOM   1445  ND2 ASN A 204      10.230  20.824  18.474  1.00  9.01           N  
ATOM   1446  N   SER A 205       5.105  20.061  20.654  1.00 12.43           N  
ATOM   1447  CA  SER A 205       3.737  19.622  20.424  1.00 14.86           C  
ATOM   1448  C   SER A 205       3.576  18.901  19.065  1.00 15.38           C  
ATOM   1449  O   SER A 205       2.689  18.086  18.871  1.00 15.61           O  
ATOM   1450  CB  SER A 205       2.757  20.804  20.560  1.00 14.65           C  
ATOM   1451  OG  SER A 205       2.913  21.743  19.499  1.00 16.38           O  
ATOM   1452  N   ASN A 206       4.477  19.160  18.143  1.00 15.79           N  
ATOM   1453  CA  ASN A 206       4.330  18.585  16.837  1.00 16.57           C  
ATOM   1454  C   ASN A 206       4.844  17.132  16.652  1.00 15.31           C  
ATOM   1455  O   ASN A 206       4.736  16.559  15.562  1.00 15.63           O  
ATOM   1456  CB  ASN A 206       4.933  19.568  15.814  1.00 17.08           C  
ATOM   1457  CG  ASN A 206       6.413  19.360  15.613  1.00 20.79           C  
ATOM   1458  OD1 ASN A 206       6.908  18.224  15.701  1.00 23.80           O  
ATOM   1459  ND2 ASN A 206       7.131  20.445  15.300  1.00 22.08           N  
ATOM   1460  N   THR A 207       5.370  16.542  17.715  1.00 13.72           N  
ATOM   1461  CA  THR A 207       6.200  15.340  17.639  1.00 11.62           C  
ATOM   1462  C   THR A 207       5.421  14.080  17.256  1.00 10.58           C  
ATOM   1463  O   THR A 207       4.408  13.767  17.870  1.00  9.72           O  
ATOM   1464  CB  THR A 207       6.957  15.138  18.987  1.00 11.49           C  
ATOM   1465  OG1 THR A 207       7.719  16.305  19.256  1.00 13.14           O  
ATOM   1466  CG2 THR A 207       7.929  13.975  18.954  1.00  9.44           C  
ATOM   1467  N   GLN A 208       5.905  13.350  16.252  1.00  8.74           N  
ATOM   1468  CA  GLN A 208       5.308  12.059  15.929  1.00  7.95           C  
ATOM   1469  C   GLN A 208       5.506  11.085  17.089  1.00  8.04           C  
ATOM   1470  O   GLN A 208       6.600  11.003  17.692  1.00  8.33           O  
ATOM   1471  CB  GLN A 208       5.811  11.516  14.576  1.00  7.42           C  
ATOM   1472  CG  GLN A 208       5.457  10.021  14.222  1.00  7.12           C  
ATOM   1473  CD  GLN A 208       6.153   9.589  12.950  1.00  8.96           C  
ATOM   1474  OE1 GLN A 208       7.123  10.235  12.502  1.00  9.80           O  
ATOM   1475  NE2 GLN A 208       5.695   8.500  12.364  1.00  6.13           N  
ATOM   1476  N   VAL A 209       4.447  10.354  17.430  1.00  7.84           N  
ATOM   1477  CA  VAL A 209       4.552   9.407  18.529  1.00  8.36           C  
ATOM   1478  C   VAL A 209       4.269   7.989  18.000  1.00  8.87           C  
ATOM   1479  O   VAL A 209       3.298   7.799  17.314  1.00  8.95           O  
ATOM   1480  CB  VAL A 209       3.639   9.769  19.712  1.00  8.74           C  
ATOM   1481  CG1 VAL A 209       3.834   8.763  20.891  1.00  8.39           C  
ATOM   1482  CG2 VAL A 209       3.850  11.261  20.164  1.00  8.66           C  
ATOM   1483  N   VAL A 210       5.161   7.024  18.291  1.00  8.71           N  
ATOM   1484  CA  VAL A 210       4.941   5.614  17.946  1.00  8.06           C  
ATOM   1485  C   VAL A 210       4.989   4.821  19.260  1.00  8.90           C  
ATOM   1486  O   VAL A 210       6.006   4.871  19.988  1.00 10.22           O  
ATOM   1487  CB  VAL A 210       5.977   5.085  16.889  1.00  8.55           C  
ATOM   1488  CG1 VAL A 210       5.774   3.569  16.608  1.00  5.59           C  
ATOM   1489  CG2 VAL A 210       5.871   5.874  15.573  1.00  6.39           C  
ATOM   1490  N   LEU A 211       3.878   4.147  19.607  1.00  7.28           N  
ATOM   1491  CA  LEU A 211       3.829   3.324  20.804  1.00  7.18           C  
ATOM   1492  C   LEU A 211       3.667   1.854  20.395  1.00  7.57           C  
ATOM   1493  O   LEU A 211       2.713   1.498  19.691  1.00  6.09           O  
ATOM   1494  CB  LEU A 211       2.635   3.712  21.724  1.00  6.58           C  
ATOM   1495  CG  LEU A 211       2.480   3.016  23.114  1.00  7.60           C  
ATOM   1496  CD1 LEU A 211       1.951   4.028  24.240  1.00  3.93           C  
ATOM   1497  CD2 LEU A 211       1.612   1.728  23.104  1.00  3.69           C  
ATOM   1498  N   LEU A 212       4.542   1.001  20.930  1.00  7.97           N  
ATOM   1499  CA  LEU A 212       4.463  -0.441  20.684  1.00  8.96           C  
ATOM   1500  C   LEU A 212       4.326  -1.127  22.007  1.00  9.38           C  
ATOM   1501  O   LEU A 212       5.030  -0.785  22.958  1.00  9.29           O  
ATOM   1502  CB  LEU A 212       5.734  -0.960  19.932  1.00  9.04           C  
ATOM   1503  CG  LEU A 212       6.106  -0.264  18.619  1.00  9.30           C  
ATOM   1504  CD1 LEU A 212       7.153   0.830  18.827  1.00  7.25           C  
ATOM   1505  CD2 LEU A 212       6.643  -1.255  17.526  1.00  9.80           C  
ATOM   1506  N   SER A 213       3.421  -2.106  22.076  1.00 10.45           N  
ATOM   1507  CA  SER A 213       3.201  -2.829  23.298  1.00  9.59           C  
ATOM   1508  C   SER A 213       2.539  -4.179  23.034  1.00 10.55           C  
ATOM   1509  O   SER A 213       1.622  -4.257  22.223  1.00 10.53           O  
ATOM   1510  CB  SER A 213       2.317  -1.966  24.192  1.00  9.52           C  
ATOM   1511  OG  SER A 213       2.155  -2.503  25.480  1.00  9.08           O  
ATOM   1512  N   ALA A 214       2.960  -5.219  23.766  1.00  9.76           N  
ATOM   1513  CA  ALA A 214       2.345  -6.552  23.667  1.00  9.43           C  
ATOM   1514  C   ALA A 214       0.919  -6.558  24.186  1.00  9.03           C  
ATOM   1515  O   ALA A 214       0.064  -7.263  23.631  1.00  8.47           O  
ATOM   1516  CB  ALA A 214       3.167  -7.606  24.444  1.00  8.85           C  
ATOM   1517  N   THR A 215       0.684  -5.825  25.287  1.00  8.43           N  
ATOM   1518  CA  THR A 215      -0.647  -5.685  25.846  1.00  7.40           C  
ATOM   1519  C   THR A 215      -1.113  -4.226  25.819  1.00  7.27           C  
ATOM   1520  O   THR A 215      -0.286  -3.312  25.791  1.00  7.37           O  
ATOM   1521  CB  THR A 215      -0.800  -6.300  27.318  1.00  8.83           C  
ATOM   1522  OG1 THR A 215      -0.145  -5.472  28.286  1.00  6.79           O  
ATOM   1523  CG2 THR A 215      -0.255  -7.770  27.393  1.00  7.72           C  
ATOM   1524  N   MET A 216      -2.433  -4.013  25.853  1.00  6.55           N  
ATOM   1525  CA  MET A 216      -2.982  -2.661  25.788  1.00  7.11           C  
ATOM   1526  C   MET A 216      -3.992  -2.453  26.906  1.00  6.85           C  
ATOM   1527  O   MET A 216      -5.179  -2.357  26.660  1.00  5.64           O  
ATOM   1528  CB  MET A 216      -3.626  -2.393  24.430  1.00  6.73           C  
ATOM   1529  CG  MET A 216      -2.657  -2.446  23.272  1.00  8.20           C  
ATOM   1530  SD  MET A 216      -1.583  -1.003  23.204  1.00 11.10           S  
ATOM   1531  CE  MET A 216      -0.621  -1.424  21.765  1.00  5.98           C  
ATOM   1532  N   PRO A 217      -3.510  -2.411  28.160  1.00  8.01           N  
ATOM   1533  CA  PRO A 217      -4.450  -2.124  29.243  1.00  8.57           C  
ATOM   1534  C   PRO A 217      -4.774  -0.647  29.259  1.00  9.25           C  
ATOM   1535  O   PRO A 217      -4.150   0.130  28.563  1.00  9.21           O  
ATOM   1536  CB  PRO A 217      -3.662  -2.527  30.480  1.00  8.94           C  
ATOM   1537  CG  PRO A 217      -2.245  -2.305  30.114  1.00  7.55           C  
ATOM   1538  CD  PRO A 217      -2.132  -2.613  28.659  1.00  6.82           C  
ATOM   1539  N   SER A 218      -5.735  -0.258  30.073  1.00 10.51           N  
ATOM   1540  CA  SER A 218      -6.261   1.093  30.041  1.00 11.32           C  
ATOM   1541  C   SER A 218      -5.244   2.242  30.230  1.00 11.38           C  
ATOM   1542  O   SER A 218      -5.378   3.289  29.584  1.00 11.27           O  
ATOM   1543  CB  SER A 218      -7.439   1.221  31.024  1.00 11.02           C  
ATOM   1544  OG  SER A 218      -7.001   1.051  32.360  1.00 11.73           O  
ATOM   1545  N   ASP A 219      -4.228   2.052  31.074  1.00 11.43           N  
ATOM   1546  CA  ASP A 219      -3.216   3.097  31.285  1.00 11.27           C  
ATOM   1547  C   ASP A 219      -2.255   3.217  30.102  1.00 11.04           C  
ATOM   1548  O   ASP A 219      -1.736   4.302  29.827  1.00 11.24           O  
ATOM   1549  CB  ASP A 219      -2.464   2.914  32.606  1.00 11.93           C  
ATOM   1550  CG  ASP A 219      -3.301   3.321  33.832  1.00 15.76           C  
ATOM   1551  OD1 ASP A 219      -4.462   3.784  33.685  1.00 20.20           O  
ATOM   1552  OD2 ASP A 219      -2.799   3.175  34.971  1.00 20.22           O  
ATOM   1553  N   VAL A 220      -2.013   2.123  29.388  1.00  9.83           N  
ATOM   1554  CA  VAL A 220      -1.324   2.243  28.105  1.00  9.65           C  
ATOM   1555  C   VAL A 220      -2.168   3.035  27.071  1.00  9.72           C  
ATOM   1556  O   VAL A 220      -1.670   3.940  26.372  1.00  8.99           O  
ATOM   1557  CB  VAL A 220      -0.927   0.860  27.518  1.00  8.72           C  
ATOM   1558  CG1 VAL A 220      -0.222   1.031  26.176  1.00  9.03           C  
ATOM   1559  CG2 VAL A 220      -0.011   0.153  28.460  1.00  9.80           C  
ATOM   1560  N   LEU A 221      -3.434   2.651  26.955  1.00  9.85           N  
ATOM   1561  CA  LEU A 221      -4.342   3.318  26.046  1.00 10.96           C  
ATOM   1562  C   LEU A 221      -4.468   4.801  26.378  1.00 10.78           C  
ATOM   1563  O   LEU A 221      -4.547   5.632  25.458  1.00 11.23           O  
ATOM   1564  CB  LEU A 221      -5.728   2.653  26.082  1.00 11.31           C  
ATOM   1565  CG  LEU A 221      -5.811   1.225  25.502  1.00 13.64           C  
ATOM   1566  CD1 LEU A 221      -7.247   0.682  25.632  1.00 13.59           C  
ATOM   1567  CD2 LEU A 221      -5.332   1.204  24.042  1.00 11.51           C  
ATOM   1568  N   GLU A 222      -4.495   5.133  27.674  1.00 10.16           N  
ATOM   1569  CA  GLU A 222      -4.582   6.537  28.113  1.00 10.08           C  
ATOM   1570  C   GLU A 222      -3.412   7.384  27.600  1.00  9.52           C  
ATOM   1571  O   GLU A 222      -3.598   8.541  27.268  1.00  9.94           O  
ATOM   1572  CB  GLU A 222      -4.714   6.633  29.644  1.00 10.67           C  
ATOM   1573  CG  GLU A 222      -4.683   8.073  30.215  1.00 12.85           C  
ATOM   1574  CD  GLU A 222      -5.760   8.985  29.590  1.00 16.80           C  
ATOM   1575  OE1 GLU A 222      -6.871   8.483  29.236  1.00 15.76           O  
ATOM   1576  OE2 GLU A 222      -5.485  10.208  29.452  1.00 17.40           O  
ATOM   1577  N   VAL A 223      -2.217   6.801  27.499  1.00  8.89           N  
ATOM   1578  CA  VAL A 223      -1.082   7.484  26.891  1.00  8.74           C  
ATOM   1579  C   VAL A 223      -1.377   7.802  25.434  1.00  8.78           C  
ATOM   1580  O   VAL A 223      -1.091   8.903  24.970  1.00  8.14           O  
ATOM   1581  CB  VAL A 223       0.225   6.655  26.961  1.00  9.46           C  
ATOM   1582  CG1 VAL A 223       1.379   7.366  26.158  1.00  8.79           C  
ATOM   1583  CG2 VAL A 223       0.615   6.376  28.416  1.00  9.09           C  
ATOM   1584  N   THR A 224      -1.959   6.832  24.724  1.00  8.27           N  
ATOM   1585  CA  THR A 224      -2.342   7.018  23.309  1.00  7.28           C  
ATOM   1586  C   THR A 224      -3.395   8.063  23.158  1.00  7.78           C  
ATOM   1587  O   THR A 224      -3.237   8.937  22.341  1.00  7.69           O  
ATOM   1588  CB  THR A 224      -2.780   5.705  22.587  1.00  5.62           C  
ATOM   1589  OG1 THR A 224      -4.115   5.350  22.971  1.00  6.20           O  
ATOM   1590  CG2 THR A 224      -1.756   4.558  22.883  1.00  4.26           C  
HETATM 1591  N   MLY A 225      -4.334   8.130  24.109  1.00 11.15           N  
HETATM 1592  CA  MLY A 225      -5.427   9.118  24.128  1.00 12.04           C  
HETATM 1593  CB  MLY A 225      -6.465   8.753  25.176  1.00 11.79           C  
HETATM 1594  CG  MLY A 225      -7.471   7.741  24.619  1.00 14.63           C  
HETATM 1595  CD  MLY A 225      -8.856   7.953  25.261  1.00 19.51           C  
HETATM 1596  CE  MLY A 225      -9.704   6.645  25.260  1.00 24.59           C  
HETATM 1597  NZ  MLY A 225     -10.772   6.575  26.306  1.00 26.37           N  
HETATM 1598  CH1 MLY A 225     -10.277   6.805  27.682  1.00 26.01           C  
HETATM 1599  CH2 MLY A 225     -11.906   7.496  26.015  1.00 27.91           C  
HETATM 1600  C   MLY A 225      -4.820  10.490  24.456  1.00 12.27           C  
HETATM 1601  O   MLY A 225      -5.252  11.494  23.843  1.00 12.49           O  
HETATM 1602  N   MLY A 226      -3.843  10.787  25.312  1.00 12.12           N  
HETATM 1603  CA  MLY A 226      -3.300  12.058  25.769  1.00 11.12           C  
HETATM 1604  CB  MLY A 226      -2.626  11.836  27.121  1.00 11.28           C  
HETATM 1605  CG  MLY A 226      -1.815  13.100  27.525  1.00 13.05           C  
HETATM 1606  CD  MLY A 226      -2.578  14.142  28.352  1.00 13.20           C  
HETATM 1607  CE  MLY A 226      -1.940  15.517  28.147  1.00 15.66           C  
HETATM 1608  NZ  MLY A 226      -2.321  16.501  29.154  1.00 17.85           N  
HETATM 1609  CH1 MLY A 226      -1.505  17.701  28.943  1.00 20.04           C  
HETATM 1610  CH2 MLY A 226      -3.722  16.921  29.116  1.00 18.09           C  
HETATM 1611  C   MLY A 226      -2.304  12.529  24.759  1.00 12.04           C  
HETATM 1612  O   MLY A 226      -2.419  13.673  24.297  1.00 11.18           O  
ATOM   1613  N   PHE A 227      -1.642  11.594  24.091  1.00 15.34           N  
ATOM   1614  CA  PHE A 227      -0.446  12.031  23.339  1.00 15.83           C  
ATOM   1615  C   PHE A 227      -0.483  11.803  21.827  1.00 15.81           C  
ATOM   1616  O   PHE A 227       0.376  12.297  21.096  1.00 16.31           O  
ATOM   1617  CB  PHE A 227       0.763  11.405  23.994  1.00 16.03           C  
ATOM   1618  CG  PHE A 227       1.031  11.996  25.357  1.00 17.71           C  
ATOM   1619  CD1 PHE A 227       1.201  13.403  25.495  1.00 17.47           C  
ATOM   1620  CD2 PHE A 227       1.051  11.188  26.498  1.00 16.08           C  
ATOM   1621  CE1 PHE A 227       1.434  13.985  26.757  1.00 17.21           C  
ATOM   1622  CE2 PHE A 227       1.264  11.740  27.747  1.00 17.58           C  
ATOM   1623  CZ  PHE A 227       1.453  13.153  27.893  1.00 16.91           C  
ATOM   1624  N   MET A 228      -1.482  11.092  21.340  1.00 15.65           N  
ATOM   1625  CA  MET A 228      -1.536  10.869  19.903  1.00 16.21           C  
ATOM   1626  C   MET A 228      -2.759  11.502  19.264  1.00 15.82           C  
ATOM   1627  O   MET A 228      -3.766  11.769  19.930  1.00 14.91           O  
ATOM   1628  CB  MET A 228      -1.444   9.381  19.581  1.00 16.07           C  
ATOM   1629  CG  MET A 228      -0.044   8.786  19.844  1.00 16.75           C  
ATOM   1630  SD  MET A 228      -0.031   6.965  19.776  1.00 18.18           S  
ATOM   1631  CE  MET A 228      -1.487   6.851  18.892  1.00 12.09           C  
ATOM   1632  N   ARG A 229      -2.649  11.738  17.958  1.00 15.38           N  
ATOM   1633  CA  ARG A 229      -3.709  12.342  17.193  1.00 15.97           C  
ATOM   1634  C   ARG A 229      -3.970  11.484  15.960  1.00 13.95           C  
ATOM   1635  O   ARG A 229      -3.039  11.189  15.204  1.00 13.61           O  
ATOM   1636  CB  ARG A 229      -3.321  13.765  16.761  1.00 15.83           C  
ATOM   1637  CG  ARG A 229      -3.127  14.764  17.882  1.00 17.81           C  
ATOM   1638  CD  ARG A 229      -2.455  16.035  17.335  1.00 20.41           C  
ATOM   1639  NE  ARG A 229      -2.562  17.186  18.247  1.00 30.18           N  
ATOM   1640  CZ  ARG A 229      -3.685  17.849  18.537  1.00 31.77           C  
ATOM   1641  NH1 ARG A 229      -4.864  17.511  18.002  1.00 33.72           N  
ATOM   1642  NH2 ARG A 229      -3.622  18.864  19.381  1.00 32.71           N  
ATOM   1643  N   ASP A 230      -5.235  11.098  15.777  1.00 12.62           N  
ATOM   1644  CA  ASP A 230      -5.690  10.275  14.661  1.00 12.00           C  
ATOM   1645  C   ASP A 230      -4.662   9.168  14.333  1.00 11.59           C  
ATOM   1646  O   ASP A 230      -4.097   9.124  13.240  1.00 10.59           O  
ATOM   1647  CB  ASP A 230      -6.018  11.161  13.464  1.00 11.84           C  
ATOM   1648  CG  ASP A 230      -6.362  10.368  12.213  1.00 13.37           C  
ATOM   1649  OD1 ASP A 230      -7.182   9.423  12.283  1.00 15.37           O  
ATOM   1650  OD2 ASP A 230      -5.817  10.714  11.150  1.00 12.46           O  
ATOM   1651  N   PRO A 231      -4.427   8.260  15.295  1.00 11.28           N  
ATOM   1652  CA  PRO A 231      -3.312   7.385  15.069  1.00 11.81           C  
ATOM   1653  C   PRO A 231      -3.627   6.194  14.139  1.00 11.63           C  
ATOM   1654  O   PRO A 231      -4.809   5.837  13.879  1.00 10.86           O  
ATOM   1655  CB  PRO A 231      -2.938   6.942  16.485  1.00 11.36           C  
ATOM   1656  CG  PRO A 231      -4.225   6.904  17.185  1.00 12.19           C  
ATOM   1657  CD  PRO A 231      -5.114   7.950  16.565  1.00 11.80           C  
ATOM   1658  N   ILE A 232      -2.568   5.645  13.573  1.00 12.25           N  
ATOM   1659  CA  ILE A 232      -2.685   4.333  12.911  1.00 12.93           C  
ATOM   1660  C   ILE A 232      -2.696   3.249  14.007  1.00 12.58           C  
ATOM   1661  O   ILE A 232      -1.980   3.360  15.028  1.00 11.08           O  
ATOM   1662  CB  ILE A 232      -1.644   4.162  11.790  1.00 13.43           C  
ATOM   1663  CG1 ILE A 232      -2.263   4.750  10.518  1.00 14.24           C  
ATOM   1664  CG2 ILE A 232      -1.312   2.690  11.516  1.00 11.86           C  
ATOM   1665  CD1 ILE A 232      -1.306   5.496   9.704  1.00 14.83           C  
ATOM   1666  N   ARG A 233      -3.611   2.292  13.830  1.00 12.59           N  
ATOM   1667  CA  ARG A 233      -3.763   1.158  14.728  1.00 13.26           C  
ATOM   1668  C   ARG A 233      -3.438  -0.158  14.012  1.00 12.46           C  
ATOM   1669  O   ARG A 233      -4.073  -0.516  13.006  1.00 11.77           O  
ATOM   1670  CB  ARG A 233      -5.159   1.137  15.325  1.00 13.39           C  
ATOM   1671  CG  ARG A 233      -5.340   2.119  16.463  1.00 15.49           C  
ATOM   1672  CD  ARG A 233      -6.793   2.181  16.971  1.00 16.74           C  
ATOM   1673  NE  ARG A 233      -6.875   3.023  18.180  1.00 23.45           N  
ATOM   1674  CZ  ARG A 233      -7.239   4.300  18.165  1.00 25.69           C  
ATOM   1675  NH1 ARG A 233      -7.575   4.883  17.020  1.00 25.96           N  
ATOM   1676  NH2 ARG A 233      -7.266   4.998  19.287  1.00 27.30           N  
ATOM   1677  N   ILE A 234      -2.411  -0.841  14.507  1.00 12.05           N  
ATOM   1678  CA  ILE A 234      -1.991  -2.127  13.949  1.00 12.66           C  
ATOM   1679  C   ILE A 234      -1.965  -3.189  15.046  1.00 12.31           C  
ATOM   1680  O   ILE A 234      -1.330  -3.013  16.091  1.00 11.75           O  
ATOM   1681  CB  ILE A 234      -0.622  -2.030  13.196  1.00 13.18           C  
ATOM   1682  CG1 ILE A 234      -0.741  -1.050  11.989  1.00 12.72           C  
ATOM   1683  CG2 ILE A 234      -0.109  -3.453  12.746  1.00 12.26           C  
ATOM   1684  CD1 ILE A 234       0.557  -0.396  11.625  1.00 13.36           C  
ATOM   1685  N   LEU A 235      -2.751  -4.235  14.823  1.00 11.96           N  
ATOM   1686  CA  LEU A 235      -2.736  -5.432  15.658  1.00 12.26           C  
ATOM   1687  C   LEU A 235      -2.089  -6.570  14.875  1.00 12.65           C  
ATOM   1688  O   LEU A 235      -2.531  -6.894  13.762  1.00 12.94           O  
ATOM   1689  CB  LEU A 235      -4.150  -5.853  16.049  1.00 11.32           C  
ATOM   1690  CG  LEU A 235      -4.275  -7.173  16.838  1.00 11.08           C  
ATOM   1691  CD1 LEU A 235      -3.507  -7.168  18.198  1.00  5.35           C  
ATOM   1692  CD2 LEU A 235      -5.746  -7.493  17.037  1.00  7.35           C  
ATOM   1693  N   VAL A 236      -1.033  -7.148  15.435  1.00 12.87           N  
ATOM   1694  CA  VAL A 236      -0.493  -8.419  14.923  1.00 12.64           C  
ATOM   1695  C   VAL A 236      -0.799  -9.514  15.956  1.00 14.04           C  
ATOM   1696  O   VAL A 236      -0.194  -9.558  17.040  1.00 12.91           O  
ATOM   1697  CB  VAL A 236       1.031  -8.371  14.626  1.00 12.81           C  
ATOM   1698  CG1 VAL A 236       1.462  -9.618  13.792  1.00 11.44           C  
ATOM   1699  CG2 VAL A 236       1.431  -7.061  13.923  1.00 11.04           C  
HETATM 1700  N   MLY A 237      -1.603 -10.417  15.410  1.00 17.78           N  
HETATM 1701  CA  MLY A 237      -2.246 -11.485  16.200  1.00 20.76           C  
HETATM 1702  CB  MLY A 237      -3.472 -12.053  15.438  1.00 20.67           C  
HETATM 1703  CG  MLY A 237      -4.374 -10.961  14.805  1.00 23.49           C  
HETATM 1704  CD  MLY A 237      -5.790 -10.898  15.406  1.00 26.15           C  
HETATM 1705  CE  MLY A 237      -6.865 -11.456  14.443  1.00 29.15           C  
HETATM 1706  NZ  MLY A 237      -8.203 -10.781  14.539  1.00 29.74           N  
HETATM 1707  CH1 MLY A 237      -9.087 -11.346  13.493  1.00 30.06           C  
HETATM 1708  CH2 MLY A 237      -8.887 -10.941  15.840  1.00 30.69           C  
HETATM 1709  C   MLY A 237      -1.216 -12.612  16.499  1.00 21.83           C  
HETATM 1710  O   MLY A 237      -0.466 -12.980  15.535  1.00 20.96           O  
HETATM 1711  N   MLY A 238      -1.279 -13.089  17.760  1.00 25.68           N  
HETATM 1712  CA  MLY A 238      -0.346 -14.196  18.124  1.00 27.27           C  
HETATM 1713  CB  MLY A 238       0.259 -14.038  19.531  1.00 27.44           C  
HETATM 1714  CG  MLY A 238       1.648 -14.736  19.605  1.00 30.32           C  
HETATM 1715  CD  MLY A 238       2.376 -14.617  20.981  1.00 34.67           C  
HETATM 1716  CE  MLY A 238       3.848 -15.132  20.930  1.00 36.72           C  
HETATM 1717  NZ  MLY A 238       4.875 -14.263  21.568  1.00 36.70           N  
HETATM 1718  CH1 MLY A 238       4.808 -14.346  23.041  1.00 37.47           C  
HETATM 1719  CH2 MLY A 238       6.205 -14.710  21.127  1.00 36.37           C  
HETATM 1720  C   MLY A 238      -1.010 -15.574  17.995  1.00 27.05           C  
HETATM 1721  O   MLY A 238      -2.177 -15.727  18.412  1.00 27.77           O  
TER    1722      MLY A 238                                                      
END
MOLECULE T0477.pdb
ATOM      1  N   SER     1      -5.659  -3.669  -3.054  1.00 17.95           N
ATOM      2  CA  SER     1      -7.095  -3.767  -2.643  1.00 17.35           C
ATOM      3  CB  SER     1      -8.006  -3.336  -3.778  1.00 17.52           C
ATOM      4  OG  SER     1      -7.556  -3.920  -4.983  1.00 19.58           O
ATOM      5  C   SER     1      -7.406  -5.196  -2.216  1.00 16.26           C
ATOM      6  O   SER     1      -7.452  -5.474  -1.016  1.00 15.55           O
ATOM      7  N   MET     2      -7.636  -6.090  -3.185  1.00 15.05           N
ATOM      8  CA  MET     2      -7.535  -7.518  -2.895  1.00 14.46           C
ATOM      9  CB  MET     2      -7.833  -8.357  -4.115  1.00 14.66           C
ATOM     10  CG  MET     2      -9.282  -8.693  -4.242  1.00 17.58           C
ATOM     11  SD  MET     2      -9.760 -10.089  -3.220  1.00 21.31           S
ATOM     12  CE  MET     2     -11.366 -10.405  -3.940  1.00 19.89           C
ATOM     13  C   MET     2      -6.145  -7.880  -2.369  1.00 13.11           C
ATOM     14  O   MET     2      -6.025  -8.668  -1.432  1.00 12.74           O
ATOM     15  N   LYS     3      -5.109  -7.331  -2.997  1.00 11.97           N
ATOM     16  CA  LYS     3      -3.733  -7.461  -2.521  1.00 11.94           C
ATOM     17  CB  LYS     3      -2.799  -6.595  -3.375  1.00 12.58           C
ATOM     18  CG  LYS     3      -2.014  -7.344  -4.446  1.00 15.44           C
ATOM     19  CD  LYS     3      -1.131  -6.388  -5.255  1.00 19.75           C
ATOM     20  CE  LYS     3      -1.957  -5.548  -6.242  1.00 21.62           C
ATOM     21  NZ  LYS     3      -1.229  -4.326  -6.698  1.00 21.88           N
ATOM     22  C   LYS     3      -3.600  -7.025  -1.054  1.00 11.20           C
ATOM     23  O   LYS     3      -3.057  -7.735  -0.218  1.00 10.86           O
ATOM     24  N   ILE     4      -4.114  -5.840  -0.760  1.00 10.33           N
ATOM     25  CA  ILE     4      -4.024  -5.242   0.550  1.00  9.80           C
ATOM     26  CB  ILE     4      -4.492  -3.780   0.479  1.00 10.33           C
ATOM     27  CG1 ILE     4      -3.621  -3.033  -0.527  1.00 10.13           C
ATOM     28  CD1 ILE     4      -2.180  -2.968  -0.117  1.00 13.19           C
ATOM     29  CG2 ILE     4      -4.447  -3.109   1.855  1.00 10.34           C
ATOM     30  C   ILE     4      -4.840  -5.997   1.569  1.00  9.20           C
ATOM     31  O   ILE     4      -4.358  -6.253   2.663  1.00  9.45           O
ATOM     32  N   ASN     5      -6.084  -6.335   1.224  1.00  7.85           N
ATOM     33  CA  ASN     5      -6.909  -7.155   2.093  1.00  7.06           C
ATOM     34  CB  ASN     5      -8.309  -7.400   1.482  1.00  7.38           C
ATOM     35  CG  ASN     5      -9.209  -6.155   1.522  1.00  9.03           C
ATOM     36  OD1 ASN     5      -8.895  -5.152   2.183  1.00 14.61           O
ATOM     37  ND2 ASN     5     -10.333  -6.220   0.810  1.00 10.87           N
ATOM     38  C   ASN     5      -6.229  -8.498   2.404  1.00  5.63           C
ATOM     39  O   ASN     5      -6.249  -8.982   3.543  1.00  5.56           O
ATOM     40  N   PHE     6      -5.638  -9.110   1.390  1.00  4.41           N
ATOM     41  CA  PHE     6      -4.878 -10.325   1.598  1.00  2.63           C
ATOM     42  CB  PHE     6      -4.282 -10.808   0.278  1.00  2.68           C
ATOM     43  CG  PHE     6      -3.341 -11.973   0.428  1.00  2.00           C
ATOM     44  CD1 PHE     6      -3.819 -13.269   0.457  1.00  2.00           C
ATOM     45  CE1 PHE     6      -2.963 -14.352   0.591  1.00  2.00           C
ATOM     46  CZ  PHE     6      -1.594 -14.134   0.678  1.00  2.00           C
ATOM     47  CE2 PHE     6      -1.094 -12.824   0.643  1.00  3.17           C
ATOM     48  CD2 PHE     6      -1.979 -11.756   0.517  1.00  2.77           C
ATOM     49  C   PHE     6      -3.767 -10.154   2.628  1.00  2.55           C
ATOM     50  O   PHE     6      -3.563 -11.008   3.493  1.00  2.00           O
ATOM     51  N   LEU     7      -3.014  -9.071   2.503  1.00  2.73           N
ATOM     52  CA  LEU     7      -1.892  -8.824   3.393  1.00  3.85           C
ATOM     53  CB  LEU     7      -1.215  -7.478   3.076  1.00  3.76           C
ATOM     54  CG  LEU     7      -0.192  -7.445   1.935  1.00  6.53           C
ATOM     55  CD1 LEU     7       0.496  -6.061   1.874  1.00  8.73           C
ATOM     56  CD2 LEU     7       0.852  -8.552   2.094  1.00  6.22           C
ATOM     57  C   LEU     7      -2.367  -8.814   4.835  1.00  3.44           C
ATOM     58  O   LEU     7      -1.824  -9.500   5.688  1.00  2.66           O
ATOM     59  N   ARG     8      -3.405  -8.032   5.082  1.00  3.96           N
ATOM     60  CA  ARG     8      -3.892  -7.848   6.429  1.00  4.55           C
ATOM     61  CB  ARG     8      -4.829  -6.655   6.487  1.00  4.13           C
ATOM     62  CG  ARG     8      -4.123  -5.294   6.366  1.00  4.29           C
ATOM     63  CD  ARG     8      -4.991  -4.240   6.966  1.00  7.06           C
ATOM     64  NE  ARG     8      -4.449  -2.888   6.846  1.00 10.41           N
ATOM     65  CZ  ARG     8      -4.948  -1.950   6.046  1.00  7.79           C
ATOM     66  NH1 ARG     8      -5.979  -2.236   5.281  1.00  7.63           N
ATOM     67  NH2 ARG     8      -4.392  -0.742   5.987  1.00  7.49           N
ATOM     68  C   ARG     8      -4.569  -9.123   6.949  1.00  5.35           C
ATOM     69  O   ARG     8      -4.409  -9.472   8.114  1.00  5.41           O
ATOM     70  N   ASN     9      -5.283  -9.840   6.084  1.00  5.63           N
ATOM     71  CA  ASN     9      -5.972 -11.056   6.534  1.00  6.49           C
ATOM     72  CB  ASN     9      -7.125 -11.439   5.576  1.00  7.74           C
ATOM     73  CG  ASN     9      -8.388 -10.566   5.779  1.00  9.38           C
ATOM     74  OD1 ASN     9      -9.383 -11.021   6.336  1.00 17.28           O
ATOM     75  ND2 ASN     9      -8.342  -9.330   5.337  1.00 12.60           N
ATOM     76  C   ASN     9      -4.992 -12.221   6.731  1.00  6.61           C
ATOM     77  O   ASN     9      -5.005 -12.885   7.777  1.00  5.28           O
ATOM     78  N   LYS    10      -4.112 -12.441   5.747  1.00  6.56           N
ATOM     79  CA  LYS    10      -3.100 -13.501   5.854  1.00  6.19           C
ATOM     80  CB  LYS    10      -2.251 -13.598   4.583  1.00  6.80           C
ATOM     81  CG  LYS    10      -1.160 -14.712   4.617  1.00  7.78           C
ATOM     82  CD  LYS    10      -1.740 -16.036   4.190  1.00  9.64           C
ATOM     83  CE  LYS    10      -0.693 -17.170   4.091  1.00 13.22           C
ATOM     84  NZ  LYS    10       0.570 -16.755   3.402  1.00 12.50           N
ATOM     85  C   LYS    10      -2.157 -13.309   7.047  1.00  6.31           C
ATOM     86  O   LYS    10      -1.809 -14.284   7.707  1.00  6.75           O
ATOM     87  N   HIS    11      -1.727 -12.071   7.312  1.00  5.77           N
ATOM     88  CA  HIS    11      -0.688 -11.842   8.338  1.00  5.29           C
ATOM     89  CB  HIS    11       0.428 -10.898   7.820  1.00  4.67           C
ATOM     90  CG  HIS    11       1.127 -11.403   6.587  1.00  5.24           C
ATOM     91  ND1 HIS    11       1.933 -12.523   6.587  1.00  3.26           N
ATOM     92  CE1 HIS    11       2.399 -12.731   5.372  1.00  6.26           C
ATOM     93  NE2 HIS    11       1.942 -11.772   4.585  1.00  7.13           N
ATOM     94  CD2 HIS    11       1.147 -10.930   5.318  1.00  5.65           C
ATOM     95  C   HIS    11      -1.274 -11.373   9.665  1.00  5.27           C
ATOM     96  O   HIS    11      -0.533 -11.015  10.597  1.00  5.26           O
ATOM     97  N   LYS    12      -2.606 -11.399   9.750  1.00  5.55           N
ATOM     98  CA  LYS    12      -3.344 -11.075  10.986  1.00  5.59           C
ATOM     99  CB  LYS    12      -3.030 -12.087  12.091  1.00  6.39           C
ATOM    100  CG  LYS    12      -3.151 -13.543  11.634  1.00  7.17           C
ATOM    101  CD  LYS    12      -4.545 -13.841  11.086  1.00 10.08           C
ATOM    102  CE  LYS    12      -4.682 -15.305  10.536  1.00 11.56           C
ATOM    103  NZ  LYS    12      -4.795 -16.289  11.651  1.00 12.60           N
ATOM    104  C   LYS    12      -3.096  -9.667  11.493  1.00  4.90           C
ATOM    105  O   LYS    12      -3.036  -9.419  12.708  1.00  4.82           O
ATOM    106  N   ILE    13      -2.991  -8.738  10.561  1.00  4.03           N
ATOM    107  CA  ILE    13      -2.760  -7.341  10.899  1.00  3.91           C
ATOM    108  CB  ILE    13      -2.127  -6.611   9.722  1.00  3.35           C
ATOM    109  CG1 ILE    13      -0.834  -7.306   9.290  1.00  5.05           C
ATOM    110  CD1 ILE    13      -0.265  -6.783   7.969  1.00  3.66           C
ATOM    111  CG2 ILE    13      -1.871  -5.166  10.075  1.00  3.40           C
ATOM    112  C   ILE    13      -4.078  -6.652  11.220  1.00  4.10           C
ATOM    113  O   ILE    13      -4.869  -6.340  10.314  1.00  4.62           O
ATOM    114  N   HIS    14      -4.324  -6.401  12.492  1.00  4.34           N
ATOM    115  CA  HIS    14      -5.564  -5.749  12.886  1.00  5.42           C
ATOM    116  CB  HIS    14      -6.072  -6.309  14.220  1.00  6.20           C
ATOM    117  CG  HIS    14      -6.502  -7.741  14.161  1.00  8.71           C
ATOM    118  ND1 HIS    14      -5.690  -8.778  14.565  1.00 15.22           N
ATOM    119  CE1 HIS    14      -6.325  -9.929  14.404  1.00 13.26           C
ATOM    120  NE2 HIS    14      -7.530  -9.671  13.928  1.00 15.10           N
ATOM    121  CD2 HIS    14      -7.671  -8.309  13.777  1.00 12.48           C
ATOM    122  C   HIS    14      -5.272  -4.283  13.064  1.00  5.47           C
ATOM    123  O   HIS    14      -4.397  -3.932  13.844  1.00  5.02           O
ATOM    124  N   VAL    15      -6.031  -3.425  12.392  1.00  5.61           N
ATOM    125  CA  VAL    15      -5.723  -1.999  12.385  1.00  5.96           C
ATOM    126  CB  VAL    15      -5.187  -1.551  11.006  1.00  6.55           C
ATOM    127  CG1 VAL    15      -3.953  -2.359  10.627  1.00  4.10           C
ATOM    128  CG2 VAL    15      -6.269  -1.725   9.880  1.00  7.69           C
ATOM    129  C   VAL    15      -6.965  -1.209  12.756  1.00  7.11           C
ATOM    130  O   VAL    15      -8.046  -1.508  12.267  1.00  7.66           O
ATOM    131  N   GLN    16      -6.830  -0.228  13.643  1.00  7.29           N
ATOM    132  CA  GLN    16      -7.942   0.680  13.920  1.00  8.99           C
ATOM    133  CB  GLN    16      -8.433   0.491  15.354  1.00  9.09           C
ATOM    134  CG  GLN    16      -9.941   0.475  15.522  1.00 14.25           C
ATOM    135  CD  GLN    16     -10.344   0.081  16.940  1.00 19.16           C
ATOM    136  OE1 GLN    16      -9.703  -0.776  17.558  1.00 23.17           O
ATOM    137  NE2 GLN    16     -11.393   0.705  17.462  1.00 20.49           N
ATOM    138  C   GLN    16      -7.426   2.098  13.721  1.00  8.81           C
ATOM    139  O   GLN    16      -6.240   2.368  13.967  1.00  7.01           O
ATOM    140  N   GLY    17      -8.301   2.996  13.258  1.00  8.72           N
ATOM    141  CA  GLY    17      -7.919   4.401  13.073  1.00  9.42           C
ATOM    142  C   GLY    17      -8.501   4.976  11.801  1.00  9.78           C
ATOM    143  O   GLY    17      -9.215   4.280  11.091  1.00  9.86           O
ATOM    144  N   THR    18      -8.213   6.241  11.504  1.00  9.63           N
ATOM    145  CA  THR    18      -8.760   6.853  10.300  1.00 10.09           C
ATOM    146  CB  THR    18      -9.633   8.120  10.631  1.00 10.26           C
ATOM    147  OG1 THR    18      -8.796   9.186  11.072  1.00 13.22           O
ATOM    148  CG2 THR    18     -10.639   7.806  11.735  1.00 10.14           C
ATOM    149  C   THR    18      -7.663   7.158   9.285  1.00  9.97           C
ATOM    150  O   THR    18      -6.531   7.432   9.668  1.00 10.18           O
ATOM    151  N   ASP    19      -7.978   7.070   7.994  1.00 10.12           N
ATOM    152  CA  ASP    19      -7.008   7.388   6.939  1.00 10.87           C
ATOM    153  CB  ASP    19      -6.568   8.847   7.076  1.00 11.72           C
ATOM    154  CG  ASP    19      -6.706   9.608   5.794  1.00 16.05           C
ATOM    155  OD1 ASP    19      -5.810   9.456   4.938  1.00 20.87           O
ATOM    156  OD2 ASP    19      -7.723  10.340   5.641  1.00 16.82           O
ATOM    157  C   ASP    19      -5.757   6.507   6.998  1.00 10.23           C
ATOM    158  O   ASP    19      -4.628   7.007   6.905  1.00 10.35           O
ATOM    159  N   LEU    20      -5.963   5.205   7.131  1.00  9.45           N
ATOM    160  CA  LEU    20      -4.884   4.242   7.274  1.00  8.26           C
ATOM    161  CB  LEU    20      -5.473   2.867   7.597  1.00  7.80           C
ATOM    162  CG  LEU    20      -6.490   2.867   8.735  1.00  8.16           C
ATOM    163  CD1 LEU    20      -7.139   1.475   8.895  1.00  9.83           C
ATOM    164  CD2 LEU    20      -5.806   3.316  10.025  1.00  5.08           C
ATOM    165  C   LEU    20      -4.025   4.107   6.028  1.00  8.14           C
ATOM    166  O   LEU    20      -4.532   3.802   4.959  1.00  7.97           O
ATOM    167  N   PRO    21      -2.695   4.265   6.176  1.00  8.38           N
ATOM    168  CA  PRO    21      -1.776   3.949   5.082  1.00  7.07           C
ATOM    169  CB  PRO    21      -0.393   4.320   5.672  1.00  7.84           C
ATOM    170  CG  PRO    21      -0.700   5.241   6.855  1.00  7.81           C
ATOM    171  CD  PRO    21      -1.982   4.674   7.404  1.00  7.70           C
ATOM    172  C   PRO    21      -1.810   2.448   4.799  1.00  7.20           C
ATOM    173  O   PRO    21      -1.935   1.631   5.727  1.00  6.28           O
ATOM    174  N   ASP    22      -1.710   2.078   3.533  1.00  6.41           N
ATOM    175  CA  ASP    22      -1.571   0.673   3.196  1.00  6.59           C
ATOM    176  CB  ASP    22      -1.646   0.467   1.692  1.00  6.57           C
ATOM    177  CG  ASP    22      -2.988   0.813   1.152  1.00  9.72           C
ATOM    178  OD1 ASP    22      -3.967   0.783   1.944  1.00 13.39           O
ATOM    179  OD2 ASP    22      -3.082   1.126  -0.047  1.00 12.17           O
ATOM    180  C   ASP    22      -0.279   0.074   3.729  1.00  6.33           C
ATOM    181  O   ASP    22       0.773   0.750   3.832  1.00  5.40           O
ATOM    182  N   PRO    23      -0.353  -1.207   4.091  1.00  5.78           N
ATOM    183  CA  PRO    23       0.849  -1.900   4.506  1.00  6.27           C
ATOM    184  CB  PRO    23       0.330  -3.242   5.062  1.00  5.96           C
ATOM    185  CG  PRO    23      -1.029  -3.437   4.457  1.00  5.73           C
ATOM    186  CD  PRO    23      -1.567  -2.042   4.147  1.00  6.03           C
ATOM    187  C   PRO    23       1.757  -2.126   3.295  1.00  6.84           C
ATOM    188  O   PRO    23       1.284  -2.119   2.159  1.00  6.83           O
ATOM    189  N   ILE    24       3.054  -2.291   3.521  1.00  6.64           N
ATOM    190  CA  ILE    24       3.906  -2.707   2.415  1.00  8.19           C
ATOM    191  CB  ILE    24       5.272  -2.013   2.444  1.00  8.19           C
ATOM    192  CG1 ILE    24       5.927  -2.229   3.804  1.00 10.05           C
ATOM    193  CD1 ILE    24       7.106  -3.104   3.791  1.00 12.47           C
ATOM    194  CG2 ILE    24       5.125  -0.528   2.189  1.00  8.08           C
ATOM    195  C   ILE    24       4.094  -4.229   2.433  1.00  7.88           C
ATOM    196  O   ILE    24       4.215  -4.854   3.506  1.00  7.51           O
ATOM    197  N   ALA    25       4.108  -4.816   1.244  1.00  7.03           N
ATOM    198  CA  ALA    25       4.312  -6.242   1.098  1.00  7.10           C
ATOM    199  CB  ALA    25       3.685  -6.704  -0.224  1.00  7.01           C
ATOM    200  C   ALA    25       5.799  -6.643   1.149  1.00  7.21           C
ATOM    201  O   ALA    25       6.153  -7.750   1.571  1.00  7.08           O
ATOM    202  N   THR    26       6.670  -5.761   0.674  1.00  6.89           N
ATOM    203  CA  THR    26       8.073  -6.122   0.494  1.00  7.41           C
ATOM    204  CB  THR    26       8.351  -6.486  -0.983  1.00  7.50           C
ATOM    205  OG1 THR    26       8.245  -5.295  -1.750  1.00  9.52           O
ATOM    206  CG2 THR    26       7.366  -7.534  -1.532  1.00  6.04           C
ATOM    207  C   THR    26       8.959  -4.925   0.809  1.00  7.38           C
ATOM    208  O   THR    26       8.503  -3.782   0.699  1.00  5.97           O
ATOM    209  N   PHE    27      10.221  -5.149   1.186  1.00  7.87           N
ATOM    210  CA  PHE    27      11.124  -3.989   1.371  1.00  9.14           C
ATOM    211  CB  PHE    27      12.436  -4.352   2.066  1.00  8.85           C
ATOM    212  CG  PHE    27      12.264  -4.758   3.503  1.00  8.65           C
ATOM    213  CD1 PHE    27      11.713  -3.883   4.427  1.00  9.20           C
ATOM    214  CE1 PHE    27      11.560  -4.267   5.745  1.00  8.54           C
ATOM    215  CZ  PHE    27      11.960  -5.535   6.151  1.00  6.73           C
ATOM    216  CE2 PHE    27      12.500  -6.400   5.248  1.00  8.63           C
ATOM    217  CD2 PHE    27      12.661  -6.014   3.927  1.00  9.55           C
ATOM    218  C   PHE    27      11.412  -3.239   0.073  1.00  9.88           C
ATOM    219  O   PHE    27      11.730  -2.044   0.087  1.00 10.95           O
ATOM    220  N   GLN    28      11.288  -3.931  -1.044  1.00 11.33           N
ATOM    221  CA  GLN    28      11.498  -3.311  -2.362  1.00 13.30           C
ATOM    222  CB  GLN    28      11.477  -4.383  -3.455  1.00 12.59           C
ATOM    223  CG  GLN    28      12.709  -5.296  -3.464  1.00 14.77           C
ATOM    224  CD  GLN    28      12.657  -6.415  -2.413  1.00 17.46           C
ATOM    225  OE1 GLN    28      11.599  -6.717  -1.867  1.00 19.05           O
ATOM    226  NE2 GLN    28      13.802  -7.053  -2.157  1.00 17.01           N
ATOM    227  C   GLN    28      10.493  -2.175  -2.666  1.00 14.26           C
ATOM    228  O   GLN    28      10.857  -1.158  -3.239  1.00 14.44           O
ATOM    229  N   GLN    29       9.232  -2.364  -2.290  1.00 16.58           N
ATOM    230  CA  GLN    29       8.243  -1.271  -2.303  1.00 18.31           C
ATOM    231  CB  GLN    29       7.084  -1.599  -1.392  1.00 19.04           C
ATOM    232  CG  GLN    29       6.348  -2.870  -1.708  1.00 20.63           C
ATOM    233  CD  GLN    29       4.876  -2.671  -1.516  1.00 22.61           C
ATOM    234  OE1 GLN    29       4.126  -3.610  -1.221  1.00 23.50           O
ATOM    235  NE2 GLN    29       4.442  -1.430  -1.680  1.00 22.36           N
ATOM    236  C   GLN    29       8.791   0.045  -1.783  1.00 19.43           C
ATOM    237  O   GLN    29       8.474   1.093  -2.326  1.00 19.91           O
ATOM    238  N   LEU    30       9.578  -0.008  -0.697  1.00 20.35           N
ATOM    239  CA  LEU    30      10.090   1.197  -0.050  1.00 20.07           C
ATOM    240  CB  LEU    30      10.819   0.852   1.269  1.00 20.80           C
ATOM    241  CG  LEU    30      10.016   0.221   2.409  1.00 18.32           C
ATOM    242  CD1 LEU    30      10.955  -0.112   3.566  1.00 17.02           C
ATOM    243  CD2 LEU    30       8.897   1.175   2.855  1.00 16.63           C
ATOM    244  C   LEU    30      11.058   1.931  -0.947  1.00 20.93           C
ATOM    245  O   LEU    30      11.216   3.151  -0.834  1.00 20.57           O
ATOM    246  N   ASP    31      11.741   1.220  -1.834  1.00 20.86           N
ATOM    247  CA  ASP    31      12.552   1.977  -2.768  1.00 22.27           C
ATOM    248  CB  ASP    31      13.641   1.146  -3.459  1.00 22.39           C
ATOM    249  CG  ASP    31      14.248   1.886  -4.652  1.00 25.04           C
ATOM    250  OD1 ASP    31      14.351   3.133  -4.567  1.00 27.40           O
ATOM    251  OD2 ASP    31      14.606   1.250  -5.679  1.00 25.37           O
ATOM    252  C   ASP    31      11.602   2.630  -3.774  1.00 21.84           C
ATOM    253  O   ASP    31      11.720   3.823  -4.080  1.00 21.76           O
ATOM    254  N   GLN    32      10.633   1.853  -4.249  1.00 21.73           N
ATOM    255  CA  GLN    32       9.721   2.338  -5.283  1.00 21.51           C
ATOM    256  CB  GLN    32       8.873   1.181  -5.845  1.00 21.95           C
ATOM    257  CG  GLN    32       9.713   0.182  -6.669  1.00 24.69           C
ATOM    258  CD  GLN    32       9.226  -1.281  -6.600  1.00 29.21           C
ATOM    259  OE1 GLN    32       8.056  -1.560  -6.290  1.00 30.67           O
ATOM    260  NE2 GLN    32      10.132  -2.220  -6.906  1.00 28.57           N
ATOM    261  C   GLN    32       8.853   3.474  -4.750  1.00 20.66           C
ATOM    262  O   GLN    32       8.680   4.472  -5.414  1.00 20.02           O
ATOM    263  N   GLU    33       8.338   3.336  -3.530  1.00 20.19           N
ATOM    264  CA  GLU    33       7.380   4.318  -3.000  1.00 20.03           C
ATOM    265  CB  GLU    33       6.264   3.609  -2.223  1.00 19.71           C
ATOM    266  CG  GLU    33       5.589   2.487  -3.043  1.00 21.07           C
ATOM    267  CD  GLU    33       4.501   1.708  -2.297  1.00 21.95           C
ATOM    268  OE1 GLU    33       4.510   1.665  -1.057  1.00 23.44           O
ATOM    269  OE2 GLU    33       3.628   1.123  -2.967  1.00 24.25           O
ATOM    270  C   GLU    33       7.997   5.486  -2.197  1.00 19.96           C
ATOM    271  O   GLU    33       7.560   6.627  -2.347  1.00 19.73           O
ATOM    272  N   TYR    34       9.016   5.207  -1.375  1.00 19.86           N
ATOM    273  CA  TYR    34       9.659   6.232  -0.522  1.00 19.80           C
ATOM    274  CB  TYR    34       9.555   5.858   0.958  1.00 20.03           C
ATOM    275  CG  TYR    34       8.155   5.587   1.407  1.00 18.02           C
ATOM    276  CD1 TYR    34       7.378   6.586   1.986  1.00 17.16           C
ATOM    277  CE1 TYR    34       6.087   6.329   2.394  1.00 14.98           C
ATOM    278  CZ  TYR    34       5.562   5.085   2.208  1.00 15.25           C
ATOM    279  OH  TYR    34       4.270   4.796   2.581  1.00 17.03           O
ATOM    280  CE2 TYR    34       6.311   4.092   1.619  1.00 16.16           C
ATOM    281  CD2 TYR    34       7.597   4.349   1.230  1.00 16.18           C
ATOM    282  C   TYR    34      11.125   6.491  -0.826  1.00 20.35           C
ATOM    283  O   TYR    34      11.734   7.383  -0.234  1.00 22.01           O
ATOM    284  N   LYS    35      11.728   5.724  -1.722  1.00 19.60           N
ATOM    285  CA  LYS    35      13.058   6.121  -2.172  1.00 18.68           C
ATOM    286  CB  LYS    35      12.989   7.512  -2.764  1.00 19.29           C
ATOM    287  CG  LYS    35      14.321   8.044  -3.254  1.00 20.61           C
ATOM    288  CD  LYS    35      14.112   9.110  -4.324  1.00 23.53           C
ATOM    289  CE  LYS    35      13.101   8.654  -5.375  1.00 25.65           C
ATOM    290  NZ  LYS    35      13.210   9.485  -6.616  1.00 25.37           N
ATOM    291  C   LYS    35      14.098   6.088  -1.040  1.00 17.71           C
ATOM    292  O   LYS    35      14.986   6.976  -0.932  1.00 17.81           O
ATOM    293  N   ILE    36      13.972   5.045  -0.220  1.00 15.11           N
ATOM    294  CA  ILE    36      14.920   4.656   0.821  1.00 12.81           C
ATOM    295  CB  ILE    36      14.567   3.230   1.288  1.00 12.59           C
ATOM    296  CG1 ILE    36      15.539   2.751   2.376  1.00 12.56           C
ATOM    297  CD1 ILE    36      15.291   1.342   2.861  1.00 12.40           C
ATOM    298  CG2 ILE    36      14.577   2.277   0.083  1.00 11.79           C
ATOM    299  C   ILE    36      16.397   4.647   0.377  1.00 11.23           C
ATOM    300  O   ILE    36      16.738   4.270  -0.743  1.00 10.98           O
ATOM    301  N   ASN    37      17.268   5.067   1.276  1.00  9.64           N
ATOM    302  CA  ASN    37      18.715   5.023   1.059  1.00  8.41           C
ATOM    303  CB  ASN    37      19.411   5.291   2.395  1.00  8.19           C
ATOM    304  CG  ASN    37      20.893   5.456   2.250  1.00  9.36           C
ATOM    305  OD1 ASN    37      21.661   4.524   2.472  1.00 11.55           O
ATOM    306  ND2 ASN    37      21.311   6.645   1.867  1.00  9.77           N
ATOM    307  C   ASN    37      19.144   3.653   0.556  1.00  7.48           C
ATOM    308  O   ASN    37      18.781   2.626   1.161  1.00  7.31           O
ATOM    309  N   SER    38      19.914   3.621  -0.529  1.00  6.13           N
ATOM    310  CA  SER    38      20.308   2.350  -1.137  1.00  6.04           C
ATOM    311  CB  SER    38      20.954   2.562  -2.519  1.00  6.04           C
ATOM    312  OG  SER    38      22.193   3.233  -2.398  1.00  7.40           O
ATOM    313  C   SER    38      21.205   1.492  -0.245  1.00  5.54           C
ATOM    314  O   SER    38      21.123   0.260  -0.275  1.00  5.89           O
ATOM    315  N   ARG    39      22.057   2.122   0.554  1.00  4.42           N
ATOM    316  CA  ARG    39      22.871   1.358   1.481  1.00  4.50           C
ATOM    317  CB  ARG    39      24.010   2.204   2.087  1.00  4.28           C
ATOM    318  CG  ARG    39      24.765   1.443   3.159  1.00  5.12           C
ATOM    319  CD  ARG    39      25.584   0.330   2.557  1.00  6.51           C
ATOM    320  NE  ARG    39      26.278  -0.480   3.549  1.00  6.87           N
ATOM    321  CZ  ARG    39      27.545  -0.298   3.905  1.00  6.84           C
ATOM    322  NH1 ARG    39      28.236   0.685   3.344  1.00  5.71           N
ATOM    323  NH2 ARG    39      28.106  -1.087   4.824  1.00  4.29           N
ATOM    324  C   ARG    39      22.029   0.732   2.590  1.00  3.74           C
ATOM    325  O   ARG    39      22.211  -0.439   2.918  1.00  3.30           O
ATOM    326  N   LEU    40      21.136   1.530   3.181  1.00  4.10           N
ATOM    327  CA  LEU    40      20.192   1.015   4.183  1.00  4.15           C
ATOM    328  CB  LEU    40      19.194   2.110   4.618  1.00  4.56           C
ATOM    329  CG  LEU    40      18.088   1.834   5.643  1.00  5.36           C
ATOM    330  CD1 LEU    40      18.604   1.114   6.913  1.00  4.80           C
ATOM    331  CD2 LEU    40      17.396   3.161   6.041  1.00  5.69           C
ATOM    332  C   LEU    40      19.445  -0.220   3.658  1.00  3.51           C
ATOM    333  O   LEU    40      19.436  -1.262   4.315  1.00  3.52           O
ATOM    334  N   LEU    41      18.811  -0.109   2.492  1.00  2.79           N
ATOM    335  CA  LEU    41      18.096  -1.261   1.912  1.00  2.44           C
ATOM    336  CB  LEU    41      17.389  -0.884   0.598  1.00  2.50           C
ATOM    337  CG  LEU    41      16.668  -2.004  -0.175  1.00  2.03           C
ATOM    338  CD1 LEU    41      15.517  -2.578   0.664  1.00  2.00           C
ATOM    339  CD2 LEU    41      16.125  -1.540  -1.547  1.00  2.00           C
ATOM    340  C   LEU    41      19.025  -2.485   1.704  1.00  3.30           C
ATOM    341  O   LEU    41      18.624  -3.638   1.957  1.00  2.99           O
ATOM    342  N   GLN    42      20.258  -2.254   1.262  1.00  2.73           N
ATOM    343  CA  GLN    42      21.175  -3.381   1.100  1.00  3.62           C
ATOM    344  CB  GLN    42      22.434  -2.987   0.315  1.00  2.71           C
ATOM    345  CG  GLN    42      23.294  -4.212  -0.116  1.00  5.86           C
ATOM    346  CD  GLN    42      22.524  -5.200  -1.024  1.00  9.82           C
ATOM    347  OE1 GLN    42      21.977  -4.816  -2.060  1.00  9.25           O
ATOM    348  NE2 GLN    42      22.479  -6.479  -0.623  1.00 11.74           N
ATOM    349  C   GLN    42      21.554  -3.974   2.467  1.00  3.97           C
ATOM    350  O   GLN    42      21.719  -5.195   2.596  1.00  3.81           O
ATOM    351  N   ASN    43      21.704  -3.118   3.482  1.00  3.76           N
ATOM    352  CA  ASN    43      22.003  -3.626   4.834  1.00  4.12           C
ATOM    353  CB  ASN    43      22.180  -2.475   5.821  1.00  3.08           C
ATOM    354  CG  ASN    43      23.479  -1.743   5.631  1.00  2.00           C
ATOM    355  OD1 ASN    43      24.378  -2.223   4.958  1.00  2.00           O
ATOM    356  ND2 ASN    43      23.585  -0.582   6.224  1.00  2.00           N
ATOM    357  C   ASN    43      20.896  -4.561   5.337  1.00  4.09           C
ATOM    358  O   ASN    43      21.153  -5.636   5.873  1.00  4.14           O
ATOM    359  N   ILE    44      19.664  -4.105   5.179  1.00  5.02           N
ATOM    360  CA  ILE    44      18.470  -4.865   5.552  1.00  5.62           C
ATOM    361  CB  ILE    44      17.193  -4.035   5.209  1.00  5.65           C
ATOM    362  CG1 ILE    44      17.058  -2.859   6.184  1.00  6.47           C
ATOM    363  CD1 ILE    44      16.122  -1.755   5.720  1.00  4.91           C
ATOM    364  CG2 ILE    44      15.930  -4.893   5.244  1.00  5.42           C
ATOM    365  C   ILE    44      18.471  -6.239   4.857  1.00  6.19           C
ATOM    366  O   ILE    44      18.346  -7.278   5.502  1.00  7.14           O
ATOM    367  N   LEU    45      18.655  -6.247   3.542  1.00  6.20           N
ATOM    368  CA  LEU    45      18.691  -7.493   2.787  1.00  6.82           C
ATOM    369  CB  LEU    45      18.572  -7.197   1.279  1.00  7.28           C
ATOM    370  CG  LEU    45      17.323  -6.366   0.880  1.00  6.92           C
ATOM    371  CD1 LEU    45      17.201  -6.241  -0.647  1.00  8.11           C
ATOM    372  CD2 LEU    45      16.026  -6.988   1.420  1.00  5.85           C
ATOM    373  C   LEU    45      19.906  -8.393   3.137  1.00  7.19           C
ATOM    374  O   LEU    45      19.750  -9.604   3.332  1.00  6.65           O
ATOM    375  N   ASP    46      21.095  -7.798   3.257  1.00  7.54           N
ATOM    376  CA  ASP    46      22.297  -8.509   3.745  1.00  7.92           C
ATOM    377  CB  ASP    46      23.496  -7.566   3.839  1.00  7.77           C
ATOM    378  CG  ASP    46      24.082  -7.204   2.492  1.00  9.57           C
ATOM    379  OD1 ASP    46      23.699  -7.801   1.465  1.00  9.79           O
ATOM    380  OD2 ASP    46      24.967  -6.323   2.474  1.00 11.70           O
ATOM    381  C   ASP    46      22.135  -9.137   5.136  1.00  8.26           C
ATOM    382  O   ASP    46      22.823 -10.093   5.468  1.00  7.99           O
ATOM    383  N   ALA    47      21.285  -8.556   5.971  1.00  8.87           N
ATOM    384  CA  ALA    47      21.038  -9.116   7.297  1.00  9.92           C
ATOM    385  CB  ALA    47      20.415  -8.078   8.221  1.00  9.39           C
ATOM    386  C   ALA    47      20.147 -10.359   7.209  1.00 10.55           C
ATOM    387  O   ALA    47      19.913 -11.025   8.214  1.00 11.19           O
ATOM    388  N   GLY    48      19.669 -10.665   6.000  1.00 10.64           N
ATOM    389  CA  GLY    48      18.837 -11.832   5.758  1.00 10.65           C
ATOM    390  C   GLY    48      17.370 -11.500   5.981  1.00 11.02           C
ATOM    391  O   GLY    48      16.527 -12.382   6.040  1.00 11.61           O
ATOM    392  N   PHE    49      17.058 -10.221   6.123  1.00 10.84           N
ATOM    393  CA  PHE    49      15.678  -9.843   6.300  1.00 10.34           C
ATOM    394  CB  PHE    49      15.553  -8.524   7.041  1.00 10.27           C
ATOM    395  CG  PHE    49      16.289  -8.482   8.367  1.00 10.53           C
ATOM    396  CD1 PHE    49      16.438  -9.629   9.151  1.00  9.15           C
ATOM    397  CE1 PHE    49      17.103  -9.572  10.380  1.00  8.21           C
ATOM    398  CZ  PHE    49      17.629  -8.371  10.827  1.00  6.77           C
ATOM    399  CE2 PHE    49      17.508  -7.237  10.048  1.00  8.64           C
ATOM    400  CD2 PHE    49      16.836  -7.296   8.822  1.00  7.85           C
ATOM    401  C   PHE    49      15.100  -9.743   4.921  1.00 10.17           C
ATOM    402  O   PHE    49      15.013  -8.653   4.357  1.00 11.58           O
ATOM    403  N   GLN    50      14.728 -10.898   4.375  1.00  8.82           N
ATOM    404  CA  GLN    50      14.202 -10.994   3.034  1.00  7.78           C
ATOM    405  CB  GLN    50      14.172 -12.463   2.634  1.00  7.84           C
ATOM    406  CG  GLN    50      13.041 -12.864   1.715  1.00  9.37           C
ATOM    410  C   GLN    50      12.807 -10.336   2.852  1.00  6.87           C
ATOM    411  O   GLN    50      12.495  -9.781   1.792  1.00  6.01           O
ATOM    412  N   MET    51      11.990 -10.386   3.902  1.00  5.70           N
ATOM    413  CA  MET    51      10.599  -9.939   3.838  0.50  5.02           C
ATOM    415  CB  MET    51       9.688 -11.156   3.635  0.50  5.14           C
ATOM    417  CG  MET    51       9.832 -11.859   2.288  0.50  6.48           C
ATOM    419  SD  MET    51       9.048 -10.903   0.976  0.50  9.57           S
ATOM    421  CE  MET    51       7.496 -10.519   1.767  0.50  9.06           C
ATOM    423  C   MET    51      10.212  -9.260   5.149  1.00  3.99           C
ATOM    424  O   MET    51      10.524  -9.765   6.213  1.00  4.09           O
ATOM    425  N   PRO    52       9.504  -8.123   5.086  1.00  3.02           N
ATOM    426  CA  PRO    52       9.134  -7.550   6.375  1.00  2.00           C
ATOM    427  CB  PRO    52       8.329  -6.297   5.996  1.00  2.00           C
ATOM    428  CG  PRO    52       7.949  -6.512   4.577  1.00  2.45           C
ATOM    429  CD  PRO    52       9.009  -7.330   3.954  1.00  2.00           C
ATOM    430  C   PRO    52       8.207  -8.466   7.127  1.00  2.00           C
ATOM    431  O   PRO    52       7.423  -9.216   6.512  1.00  2.00           O
ATOM    432  N   THR    53       8.251  -8.348   8.452  1.00  2.00           N
ATOM    433  CA  THR    53       7.363  -9.088   9.323  1.00  2.00           C
ATOM    434  CB  THR    53       7.910  -9.173  10.752  1.00  2.00           C
ATOM    435  OG1 THR    53       7.929  -7.863  11.336  1.00  2.00           O
ATOM    436  CG2 THR    53       9.302  -9.781  10.762  1.00  2.00           C
ATOM    437  C   THR    53       6.013  -8.372   9.336  1.00  2.00           C
ATOM    438  O   THR    53       5.923  -7.240   8.902  1.00  2.00           O
ATOM    439  N   PRO    54       4.951  -9.061   9.817  1.00  2.00           N
ATOM    440  CA  PRO    54       3.614  -8.446   9.836  1.00  2.00           C
ATOM    441  CB  PRO    54       2.764  -9.499  10.554  1.00  2.00           C
ATOM    442  CG  PRO    54       3.434 -10.845  10.109  1.00  2.00           C
ATOM    443  CD  PRO    54       4.913 -10.522  10.084  1.00  2.00           C
ATOM    444  C   PRO    54       3.575  -7.045  10.511  1.00  2.00           C
ATOM    445  O   PRO    54       2.921  -6.128   9.970  1.00  2.12           O
ATOM    446  N   ILE    55       4.286  -6.857  11.631  1.00  2.00           N
ATOM    447  CA  ILE    55       4.277  -5.552  12.311  1.00  2.00           C
ATOM    448  CB  ILE    55       4.798  -5.637  13.788  1.00  2.00           C
ATOM    449  CG1 ILE    55       4.445  -4.380  14.592  1.00  2.25           C
ATOM    450  CD1 ILE    55       2.939  -4.024  14.606  1.00  2.00           C
ATOM    451  CG2 ILE    55       6.303  -5.838  13.848  1.00  2.00           C
ATOM    452  C   ILE    55       5.031  -4.496  11.479  1.00  2.00           C
ATOM    453  O   ILE    55       4.572  -3.360  11.336  1.00  2.00           O
ATOM    454  N   GLN    56       6.172  -4.885  10.921  1.00  2.00           N
ATOM    455  CA  GLN    56       6.886  -4.046   9.958  1.00  2.00           C
ATOM    456  CB  GLN    56       8.151  -4.760   9.495  1.00  2.00           C
ATOM    457  CG  GLN    56       9.140  -4.972  10.662  1.00  2.00           C
ATOM    458  CD  GLN    56      10.206  -5.998  10.364  1.00  2.68           C
ATOM    459  OE1 GLN    56      10.304  -6.506   9.228  1.00  2.00           O
ATOM    460  NE2 GLN    56      11.013  -6.336  11.397  1.00  2.00           N
ATOM    461  C   GLN    56       6.012  -3.665   8.771  1.00  2.00           C
ATOM    462  O   GLN    56       5.979  -2.513   8.367  1.00  2.00           O
ATOM    463  N   MET    57       5.295  -4.632   8.209  1.00  2.00           N
ATOM    464  CA  MET    57       4.436  -4.374   7.048  1.00  2.00           C
ATOM    465  CB  MET    57       3.590  -5.610   6.715  1.00  2.00           C
ATOM    466  CG  MET    57       4.390  -6.774   6.183  1.00  2.00           C
ATOM    467  SD  MET    57       3.250  -8.128   5.782  1.00  2.36           S
ATOM    468  CE  MET    57       4.399  -9.242   4.913  1.00  2.00           C
ATOM    469  C   MET    57       3.510  -3.178   7.261  1.00  2.00           C
ATOM    470  O   MET    57       3.329  -2.347   6.356  1.00  2.00           O
ATOM    471  N   GLN    58       2.877  -3.113   8.430  1.00  2.00           N
ATOM    472  CA  GLN    58       1.941  -2.027   8.691  1.00  2.00           C
ATOM    473  CB  GLN    58       0.626  -2.532   9.308  1.00  2.00           C
ATOM    474  CG  GLN    58      -0.428  -1.426   9.490  1.00  2.00           C
ATOM    475  CD  GLN    58      -1.001  -0.929   8.177  1.00  2.00           C
ATOM    476  OE1 GLN    58      -1.953  -1.504   7.637  1.00  2.07           O
ATOM    477  NE2 GLN    58      -0.439   0.152   7.659  1.00  2.00           N
ATOM    478  C   GLN    58       2.523  -0.876   9.528  1.00  2.00           C
ATOM    479  O   GLN    58       2.118   0.265   9.361  1.00  2.31           O
ATOM    480  N   ALA    59       3.451  -1.156  10.433  1.00  2.00           N
ATOM    481  CA  ALA    59       3.966  -0.066  11.288  1.00  2.00           C
ATOM    482  CB  ALA    59       4.767  -0.610  12.451  1.00  2.00           C
ATOM    483  C   ALA    59       4.833   0.926  10.499  1.00  2.62           C
ATOM    484  O   ALA    59       4.805   2.132  10.746  1.00  2.00           O
ATOM    485  N   ILE    60       5.649   0.398   9.588  1.00  2.19           N
ATOM    486  CA  ILE    60       6.577   1.248   8.866  1.00  2.13           C
ATOM    487  CB  ILE    60       7.525   0.403   7.984  1.00  2.84           C
ATOM    488  CG1 ILE    60       8.507  -0.352   8.905  1.00  2.72           C
ATOM    489  CD1 ILE    60       9.371  -1.389   8.203  1.00  2.00           C
ATOM    490  CG2 ILE    60       8.257   1.278   6.969  1.00  2.00           C
ATOM    491  C   ILE    60       5.876   2.348   8.080  1.00  2.31           C
ATOM    492  O   ILE    60       6.241   3.532   8.195  1.00  2.00           O
ATOM    493  N   PRO    61       4.884   1.970   7.241  1.00  2.57           N
ATOM    494  CA  PRO    61       4.244   3.028   6.459  1.00  2.12           C
ATOM    495  CB  PRO    61       3.383   2.273   5.452  1.00  2.00           C
ATOM    496  CG  PRO    61       3.304   0.855   5.965  1.00  3.34           C
ATOM    497  CD  PRO    61       4.543   0.618   6.756  1.00  2.61           C
ATOM    498  C   PRO    61       3.420   3.982   7.338  1.00  2.11           C
ATOM    499  O   PRO    61       3.307   5.160   7.012  1.00  2.10           O
ATOM    500  N   VAL    62       2.884   3.500   8.459  1.00  2.00           N
ATOM    501  CA  VAL    62       2.221   4.401   9.390  1.00  2.00           C
ATOM    502  CB  VAL    62       1.589   3.678  10.592  1.00  2.00           C
ATOM    503  CG1 VAL    62       1.036   4.716  11.619  1.00  2.38           C
ATOM    504  CG2 VAL    62       0.437   2.750  10.116  1.00  2.00           C
ATOM    505  C   VAL    62       3.168   5.524   9.877  1.00  2.00           C
ATOM    506  O   VAL    62       2.783   6.682   9.881  1.00  2.00           O
ATOM    507  N   MET    63       4.391   5.170  10.273  1.00  2.00           N
ATOM    508  CA  MET    63       5.376   6.165  10.740  1.00  2.00           C
ATOM    509  CB  MET    63       6.544   5.475  11.473  1.00  2.00           C
ATOM    510  CG  MET    63       6.093   4.863  12.793  1.00  3.01           C
ATOM    511  SD  MET    63       7.416   4.028  13.721  1.00  2.45           S
ATOM    512  CE  MET    63       8.532   5.387  14.031  1.00  2.00           C
ATOM    513  C   MET    63       5.894   7.038   9.613  1.00  2.00           C
ATOM    514  O   MET    63       6.115   8.238   9.795  1.00  2.00           O
ATOM    515  N   LEU    64       6.060   6.446   8.433  1.00  2.00           N
ATOM    516  CA  LEU    64       6.559   7.193   7.312  1.00  2.00           C
ATOM    517  CB  LEU    64       6.878   6.264   6.106  1.00  2.00           C
ATOM    518  CG  LEU    64       8.097   5.312   6.217  1.00  2.00           C
ATOM    519  CD1 LEU    64       8.242   4.334   5.003  1.00  2.00           C
ATOM    520  CD2 LEU    64       9.395   6.073   6.409  1.00  2.00           C
ATOM    521  C   LEU    64       5.536   8.299   6.971  1.00  2.00           C
ATOM    522  O   LEU    64       5.919   9.381   6.543  1.00  2.00           O
ATOM    523  N   HIS    65       4.253   8.027   7.203  1.00  2.00           N
ATOM    524  CA  HIS    65       3.195   8.987   6.903  1.00  2.60           C
ATOM    525  CB  HIS    65       1.863   8.284   6.553  1.00  2.89           C
ATOM    526  CG  HIS    65       1.806   7.810   5.139  1.00  2.94           C
ATOM    527  ND1 HIS    65       1.119   8.481   4.152  1.00  5.30           N
ATOM    528  CE1 HIS    65       1.266   7.840   3.003  1.00  4.25           C
ATOM    529  NE2 HIS    65       2.040   6.789   3.208  1.00  3.79           N
ATOM    530  CD2 HIS    65       2.395   6.749   4.534  1.00  4.11           C
ATOM    531  C   HIS    65       2.995   9.978   8.028  1.00  3.62           C
ATOM    532  O   HIS    65       2.083  10.783   7.967  1.00  3.71           O
ATOM    533  N   GLY    66       3.867   9.936   9.043  1.00  3.80           N
ATOM    534  CA  GLY    66       3.801  10.915  10.123  1.00  3.84           C
ATOM    535  C   GLY    66       2.617  10.746  11.080  1.00  4.06           C
ATOM    536  O   GLY    66       2.163  11.726  11.693  1.00  4.10           O
ATOM    537  N   ARG    67       2.139   9.511  11.229  1.00  2.77           N
ATOM    538  CA  ARG    67       0.969   9.234  12.037  1.00  2.47           C
ATOM    539  CB  ARG    67       0.004   8.306  11.288  1.00  2.00           C
ATOM    540  CG  ARG    67      -0.658   8.986  10.043  1.00  2.00           C
ATOM    541  CD  ARG    67      -1.548  10.165  10.431  1.00  2.00           C
ATOM    542  NE  ARG    67      -2.656   9.676  11.231  1.00  2.00           N
ATOM    543  CZ  ARG    67      -3.725   9.049  10.737  1.00  3.82           C
ATOM    544  NH1 ARG    67      -3.872   8.866   9.422  1.00  4.83           N
ATOM    545  NH2 ARG    67      -4.664   8.615  11.560  1.00  3.19           N
ATOM    546  C   ARG    67       1.408   8.614  13.341  1.00  3.21           C
ATOM    547  O   ARG    67       2.270   7.744  13.338  1.00  3.81           O
ATOM    548  N   GLU    68       0.855   9.092  14.455  1.00  3.11           N
ATOM    549  CA  GLU    68       1.120   8.485  15.750  1.00  3.33           C
ATOM    550  CB  GLU    68       0.557   9.354  16.887  1.00  3.14           C
ATOM    551  CG  GLU    68       0.934  10.866  16.706  1.00  4.51           C
ATOM    552  CD  GLU    68       1.246  11.586  18.027  1.00  7.62           C
ATOM    553  OE1 GLU    68       0.321  11.841  18.816  1.00 11.49           O
ATOM    554  OE2 GLU    68       2.419  11.917  18.286  1.00  8.02           O
ATOM    555  C   GLU    68       0.561   7.077  15.773  1.00  3.85           C
ATOM    556  O   GLU    68      -0.427   6.777  15.094  1.00  4.04           O
ATOM    557  N   LEU    69       1.180   6.215  16.569  1.00  3.09           N
ATOM    558  CA  LEU    69       1.015   4.793  16.412  1.00  3.00           C
ATOM    559  CB  LEU    69       2.211   4.247  15.599  1.00  2.82           C
ATOM    560  CG  LEU    69       2.403   2.745  15.372  1.00  4.17           C
ATOM    561  CD1 LEU    69       1.227   2.120  14.586  1.00  5.87           C
ATOM    562  CD2 LEU    69       3.738   2.421  14.660  1.00  2.00           C
ATOM    563  C   LEU    69       1.014   4.113  17.766  1.00  2.93           C
ATOM    564  O   LEU    69       1.856   4.390  18.619  1.00  2.47           O
ATOM    565  N   LEU    70       0.074   3.211  17.961  1.00  3.47           N
ATOM    566  CA  LEU    70       0.215   2.203  19.002  1.00  4.88           C
ATOM    567  CB  LEU    70      -0.994   2.209  19.953  1.00  5.32           C
ATOM    568  CG  LEU    70      -1.060   1.042  20.952  1.00  9.07           C
ATOM    569  CD1 LEU    70       0.135   1.034  21.875  1.00 11.28           C
ATOM    570  CD2 LEU    70      -2.370   1.059  21.793  1.00  9.52           C
ATOM    571  C   LEU    70       0.344   0.863  18.276  1.00  5.01           C
ATOM    572  O   LEU    70      -0.567   0.456  17.558  1.00  5.32           O
ATOM    573  N   ALA    71       1.490   0.208  18.440  1.00  4.65           N
ATOM    574  CA  ALA    71       1.791  -1.027  17.751  1.00  4.52           C
ATOM    575  CB  ALA    71       3.038  -0.867  16.900  1.00  3.53           C
ATOM    576  C   ALA    71       2.010  -2.141  18.752  1.00  5.13           C
ATOM    577  O   ALA    71       2.853  -1.997  19.655  1.00  6.52           O
ATOM    578  N   SER    72       1.294  -3.251  18.580  1.00  4.10           N
ATOM    579  CA  SER    72       1.398  -4.381  19.487  1.00  4.12           C
ATOM    580  CB  SER    72       0.114  -4.568  20.325  1.00  4.46           C
ATOM    581  OG  SER    72      -0.237  -3.354  21.002  1.00 10.59           O
ATOM    582  C   SER    72       1.664  -5.652  18.720  1.00  3.39           C
ATOM    583  O   SER    72       0.954  -5.987  17.748  1.00  3.27           O
ATOM    584  N   ALA    73       2.668  -6.388  19.170  1.00  2.47           N
ATOM    585  CA  ALA    73       2.975  -7.679  18.585  1.00  2.45           C
ATOM    586  CB  ALA    73       3.727  -7.478  17.264  1.00  2.35           C
ATOM    587  C   ALA    73       3.835  -8.453  19.586  1.00  2.00           C
ATOM    588  O   ALA    73       4.648  -7.858  20.258  1.00  2.00           O
ATOM    589  N   PRO    74       3.670  -9.780  19.667  1.00  2.62           N
ATOM    590  CA  PRO    74       4.425 -10.575  20.664  1.00  2.95           C
ATOM    591  CB  PRO    74       4.066 -12.037  20.329  1.00  3.18           C
ATOM    592  CG  PRO    74       2.831 -11.980  19.469  1.00  3.56           C
ATOM    593  CD  PRO    74       2.768 -10.592  18.830  1.00  3.29           C
ATOM    594  C   PRO    74       5.937 -10.379  20.527  1.00  2.89           C
ATOM    595  O   PRO    74       6.410  -9.920  19.481  1.00  3.93           O
ATOM    596  N   THR    75       6.681 -10.674  21.579  1.00  2.00           N
ATOM    597  CA  THR    75       8.129 -10.846  21.482  1.00  2.28           C
ATOM    598  CB  THR    75       8.670 -11.503  22.801  1.00  2.76           C
ATOM    599  OG1 THR    75       8.280 -10.686  23.918  1.00  4.52           O
ATOM    600  CG2 THR    75      10.179 -11.637  22.788  1.00  2.48           C
ATOM    601  C   THR    75       8.533 -11.705  20.268  1.00  2.19           C
ATOM    602  O   THR    75       7.918 -12.735  19.975  1.00  2.22           O
ATOM    603  N   GLY    76       9.579 -11.287  19.562  1.00  2.00           N
ATOM    604  CA  GLY    76      10.046 -12.055  18.421  1.00  2.00           C
ATOM    605  C   GLY    76       9.407 -11.587  17.120  1.00  2.00           C
ATOM    606  O   GLY    76       9.570 -12.216  16.086  1.00  2.28           O
ATOM    607  N   SER    77       8.685 -10.481  17.154  1.00  2.00           N
ATOM    608  CA  SER    77       7.941 -10.080  15.975  1.00  2.00           C
ATOM    609  CB  SER    77       6.635  -9.399  16.387  1.00  2.00           C
ATOM    610  OG  SER    77       5.809 -10.325  17.065  1.00  2.05           O
ATOM    611  C   SER    77       8.701  -9.156  15.013  1.00  2.00           C
ATOM    612  O   SER    77       8.199  -8.910  13.918  1.00  2.00           O
ATOM    613  N   GLY    78       9.874  -8.659  15.437  1.00  2.00           N
ATOM    614  CA  GLY    78      10.666  -7.657  14.711  1.00  2.00           C
ATOM    615  C   GLY    78      10.248  -6.214  14.970  1.00  2.00           C
ATOM    616  O   GLY    78      10.280  -5.361  14.067  1.00  2.00           O
ATOM    617  N   LYS    79       9.842  -5.911  16.204  1.00  2.00           N
ATOM    618  CA  LYS    79       9.396  -4.551  16.505  1.00  2.00           C
ATOM    619  CB  LYS    79       8.665  -4.468  17.856  1.00  2.01           C
ATOM    620  CG  LYS    79       7.351  -5.229  17.876  1.00  2.00           C
ATOM    621  CD  LYS    79       6.554  -4.973  19.148  1.00  2.00           C
ATOM    622  CE  LYS    79       7.197  -5.686  20.342  1.00  2.75           C
ATOM    623  NZ  LYS    79       7.418  -7.177  20.125  1.00  2.00           N
ATOM    624  C   LYS    79      10.556  -3.541  16.451  1.00  2.37           C
ATOM    625  O   LYS    79      10.331  -2.376  16.122  1.00  2.00           O
ATOM    626  N   THR    80      11.796  -3.974  16.713  1.00  2.00           N
ATOM    627  CA  THR    80      12.921  -3.018  16.596  1.00  2.00           C
ATOM    628  CB  THR    80      14.269  -3.618  17.038  1.00  2.00           C
ATOM    629  OG1 THR    80      14.106  -4.198  18.327  1.00  3.32           O
ATOM    630  CG2 THR    80      15.361  -2.544  17.141  1.00  2.00           C
ATOM    631  C   THR    80      13.064  -2.434  15.200  1.00  2.03           C
ATOM    632  O   THR    80      13.161  -1.234  15.037  1.00  2.00           O
ATOM    633  N   LEU    81      13.045  -3.279  14.168  1.00  2.61           N
ATOM    634  CA  LEU    81      13.222  -2.754  12.814  1.00  3.14           C
ATOM    635  CB  LEU    81      13.462  -3.919  11.869  1.00  4.34           C
ATOM    636  CG  LEU    81      14.566  -3.711  10.896  1.00  8.83           C
ATOM    637  CD1 LEU    81      15.794  -3.641  11.784  1.00 12.92           C
ATOM    638  CD2 LEU    81      14.567  -4.933   9.911  1.00 11.75           C
ATOM    639  C   LEU    81      12.006  -1.973  12.343  1.00  2.84           C
ATOM    640  O   LEU    81      12.130  -1.034  11.520  1.00  2.37           O
ATOM    641  N   ALA    82      10.831  -2.381  12.836  1.00  2.00           N
ATOM    642  CA  ALA    82       9.572  -1.669  12.583  1.00  2.39           C
ATOM    643  CB  ALA    82       8.396  -2.352  13.314  1.00  2.00           C
ATOM    644  C   ALA    82       9.603  -0.163  12.947  1.00  2.88           C
ATOM    645  O   ALA    82       8.961   0.669  12.260  1.00  2.31           O
ATOM    646  N   PHE    83      10.306   0.189  14.029  1.00  2.48           N
ATOM    647  CA  PHE    83      10.511   1.621  14.303  1.00  3.05           C
ATOM    648  CB  PHE    83      10.226   2.002  15.768  1.00  2.70           C
ATOM    649  CG  PHE    83      11.113   1.319  16.792  1.00  4.42           C
ATOM    650  CD1 PHE    83      12.417   1.747  17.006  1.00  3.70           C
ATOM    651  CE1 PHE    83      13.216   1.146  17.996  1.00  2.00           C
ATOM    652  CZ  PHE    83      12.710   0.142  18.784  1.00  2.00           C
ATOM    653  CE2 PHE    83      11.393  -0.285  18.595  1.00  3.79           C
ATOM    654  CD2 PHE    83      10.606   0.304  17.603  1.00  4.41           C
ATOM    655  C   PHE    83      11.836   2.224  13.820  1.00  3.40           C
ATOM    656  O   PHE    83      11.918   3.437  13.618  1.00  2.94           O
ATOM    657  N   SER    84      12.851   1.388  13.596  1.00  2.76           N
ATOM    658  CA  SER    84      14.182   1.899  13.276  1.00  3.03           C
ATOM    659  CB  SER    84      15.231   0.823  13.581  1.00  2.28           C
ATOM    660  OG  SER    84      15.209   0.603  14.977  1.00  4.99           O
ATOM    661  C   SER    84      14.308   2.358  11.831  1.00  2.92           C
ATOM    662  O   SER    84      14.958   3.365  11.538  1.00  2.00           O
ATOM    663  N   ILE    85      13.699   1.575  10.934  1.00  2.00           N
ATOM    664  CA  ILE    85      13.707   1.884   9.519  1.00  2.00           C
ATOM    665  CB  ILE    85      13.043   0.728   8.700  1.00  2.00           C
ATOM    666  CG1 ILE    85      14.013  -0.477   8.618  1.00  2.00           C
ATOM    667  CD1 ILE    85      13.414  -1.658   7.850  1.00  2.00           C
ATOM    668  CG2 ILE    85      12.662   1.184   7.291  1.00  2.00           C
ATOM    669  C   ILE    85      13.044   3.212   9.191  1.00  2.00           C
ATOM    670  O   ILE    85      13.618   4.041   8.510  1.00  2.00           O
ATOM    671  N   PRO    86      11.824   3.418   9.659  1.00  2.00           N
ATOM    672  CA  PRO    86      11.180   4.698   9.366  1.00  2.00           C
ATOM    673  CB  PRO    86       9.775   4.557   9.979  1.00  2.00           C
ATOM    674  CG  PRO    86       9.739   3.315  10.697  1.00  2.00           C
ATOM    675  CD  PRO    86      10.912   2.449  10.291  1.00  2.00           C
ATOM    676  C   PRO    86      11.895   5.889  10.016  1.00  2.56           C
ATOM    677  O   PRO    86      11.934   6.966   9.428  1.00  3.83           O
ATOM    678  N   ILE    87      12.434   5.711  11.214  1.00  2.17           N
ATOM    679  CA  ILE    87      13.258   6.763  11.814  1.00  2.12           C
ATOM    680  CB  ILE    87      13.775   6.329  13.208  1.00  2.41           C
ATOM    681  CG1 ILE    87      12.618   6.402  14.214  1.00  2.71           C
ATOM    682  CD1 ILE    87      12.971   5.703  15.499  1.00  4.63           C
ATOM    683  CG2 ILE    87      14.981   7.173  13.656  1.00  2.00           C
ATOM    684  C   ILE    87      14.461   7.096  10.935  1.00  2.00           C
ATOM    685  O   ILE    87      14.716   8.258  10.630  1.00  2.15           O
ATOM    686  N   LEU    88      15.231   6.082  10.549  1.00  2.00           N
ATOM    687  CA  LEU    88      16.350   6.343   9.634  1.00  2.00           C
ATOM    688  CB  LEU    88      17.093   5.038   9.367  1.00  2.00           C
ATOM    689  CG  LEU    88      17.805   4.450  10.583  1.00  2.54           C
ATOM    690  CD1 LEU    88      18.288   3.037  10.235  1.00  2.00           C
ATOM    691  CD2 LEU    88      18.987   5.353  11.039  1.00  2.00           C
ATOM    692  C   LEU    88      15.915   6.977   8.304  1.00  2.00           C
ATOM    693  O   LEU    88      16.578   7.891   7.784  1.00  2.00           O
ATOM    694  N   MET    89      14.827   6.463   7.726  1.00  2.00           N
ATOM    695  CA  MET    89      14.320   7.002   6.460  1.00  2.00           C
ATOM    696  CB  MET    89      13.151   6.161   5.945  1.00  2.00           C
ATOM    697  CG  MET    89      13.552   4.799   5.480  1.00  3.11           C
ATOM    698  SD  MET    89      12.178   3.813   4.889  1.00  2.61           S
ATOM    699  CE  MET    89      11.669   4.767   3.476  1.00  2.00           C
ATOM    700  C   MET    89      13.871   8.460   6.571  1.00  2.00           C
ATOM    701  O   MET    89      14.167   9.280   5.701  1.00  2.00           O
ATOM    702  N   GLN    90      13.142   8.775   7.641  1.00  2.20           N
ATOM    703  CA  GLN    90      12.672  10.145   7.870  1.00  2.77           C
ATOM    704  CB  GLN    90      11.746  10.223   9.101  1.00  3.27           C
ATOM    705  CG  GLN    90      11.113  11.643   9.262  1.00  6.16           C
ATOM    706  CD  GLN    90       9.921  11.690  10.217  1.00 11.29           C
ATOM    707  OE1 GLN    90       8.946  10.928  10.082  1.00 11.99           O
ATOM    708  NE2 GLN    90       9.977  12.607  11.169  1.00 13.52           N
ATOM    709  C   GLN    90      13.839  11.103   8.056  1.00  2.64           C
ATOM    710  O   GLN    90      13.865  12.217   7.497  1.00  2.68           O
ATOM    711  N   LEU    91      14.833  10.676   8.829  1.00  2.94           N
ATOM    712  CA  LEU    91      15.930  11.578   9.151  1.00  2.56           C
ATOM    713  CB  LEU    91      16.769  11.006  10.282  1.00  2.98           C
ATOM    714  CG  LEU    91      16.111  10.876  11.662  1.00  4.89           C
ATOM    715  CD1 LEU    91      17.152  10.647  12.756  1.00  2.00           C
ATOM    716  CD2 LEU    91      15.273  12.104  11.976  1.00  7.22           C
ATOM    717  C   LEU    91      16.808  11.874   7.906  1.00  3.02           C
ATOM    718  O   LEU    91      17.500  12.898   7.854  1.00  2.00           O
ATOM    719  N   LYS    92      16.749  10.964   6.931  1.00  3.61           N
ATOM    720  CA  LYS    92      17.442  11.063   5.630  1.00  5.29           C
ATOM    721  CB  LYS    92      17.013  12.332   4.874  1.00  5.67           C
ATOM    722  CG  LYS    92      15.534  12.413   4.631  1.00  9.99           C
ATOM    723  CD  LYS    92      15.180  13.725   3.945  1.00 15.63           C
ATOM    724  CE  LYS    92      13.804  13.621   3.319  1.00 19.94           C
ATOM    725  NZ  LYS    92      13.651  12.321   2.584  1.00 21.82           N
ATOM    726  C   LYS    92      18.967  10.983   5.662  1.00  5.67           C
ATOM    727  O   LYS    92      19.566  10.142   4.976  1.00  6.66           O
ATOM    728  N   GLN    93      19.589  11.897   6.405  1.00  5.46           N
ATOM    729  CA  GLN    93      21.045  12.032   6.441  1.00  5.18           C
ATOM    730  CB  GLN    93      21.555  13.177   5.535  1.00  5.51           C
ATOM    731  CG  GLN    93      21.266  13.102   4.027  1.00  8.17           C
ATOM    732  CD  GLN    93      21.817  14.343   3.323  1.00 11.14           C
ATOM    733  OE1 GLN    93      22.946  14.770   3.591  1.00 15.39           O
ATOM    734  NE2 GLN    93      21.023  14.942   2.453  1.00 12.80           N
ATOM    735  C   GLN    93      21.467  12.409   7.839  1.00  4.54           C
ATOM    736  O   GLN    93      20.721  13.104   8.544  1.00  3.67           O
ATOM    737  N   PRO    94      22.691  11.997   8.226  1.00  4.14           N
ATOM    738  CA  PRO    94      23.272  12.456   9.478  1.00  4.11           C
ATOM    739  CB  PRO    94      24.724  11.970   9.412  1.00  3.31           C
ATOM    740  CG  PRO    94      24.849  11.137   8.158  1.00  3.98           C
ATOM    741  CD  PRO    94      23.537  11.025   7.504  1.00  4.01           C
ATOM    742  C   PRO    94      23.248  13.973   9.460  1.00  4.37           C
ATOM    743  O   PRO    94      23.379  14.570   8.408  1.00  3.84           O
ATOM    744  N   ALA    95      23.093  14.603  10.616  1.00  4.85           N
ATOM    745  CA  ALA    95      23.059  16.058  10.653  1.00  5.05           C
ATOM    746  CB  ALA    95      21.601  16.587  10.447  1.00  4.19           C
ATOM    747  C   ALA    95      23.625  16.539  11.980  1.00  5.56           C
ATOM    748  O   ALA    95      23.797  15.744  12.893  1.00  5.25           O
ATOM    749  N   ASN    96      23.892  17.842  12.071  1.00  5.99           N
ATOM    750  CA  ASN    96      24.551  18.431  13.225  1.00  7.05           C
ATOM    751  CB  ASN    96      25.730  19.316  12.791  1.00  6.79           C
ATOM    755  C   ASN    96      23.556  19.237  14.036  1.00  7.61           C
ATOM    756  O   ASN    96      23.886  20.285  14.580  1.00  7.55           O
ATOM    757  N   LYS    97      22.331  18.712  14.118  1.00  8.01           N
ATOM    758  CA  LYS    97      21.205  19.404  14.734  1.00  7.98           C
ATOM    759  CB  LYS    97      19.945  19.196  13.854  1.00  8.66           C
ATOM    760  CG  LYS    97      19.648  20.246  12.750  1.00  9.51           C
ATOM    761  CD  LYS    97      20.770  21.221  12.504  1.00 11.14           C
ATOM    764  C   LYS    97      20.920  18.847  16.131  1.00  7.75           C
ATOM    765  O   LYS    97      19.918  19.198  16.732  1.00  7.92           O
ATOM    766  N   GLY    98      21.765  17.942  16.629  1.00  6.64           N
ATOM    767  CA  GLY    98      21.469  17.262  17.911  1.00  4.72           C
ATOM    768  C   GLY    98      20.448  16.171  17.672  1.00  3.30           C
ATOM    769  O   GLY    98      20.003  16.000  16.538  1.00  3.19           O
ATOM    770  N   PHE    99      20.030  15.460  18.723  1.00  2.62           N
ATOM    771  CA  PHE    99      19.193  14.254  18.523  1.00  2.00           C
ATOM    772  CB  PHE    99      18.920  13.517  19.833  1.00  2.00           C
ATOM    773  CG  PHE    99      20.144  12.939  20.458  1.00  2.82           C
ATOM    774  CD1 PHE    99      20.807  11.884  19.860  1.00  4.02           C
ATOM    775  CE1 PHE    99      21.958  11.341  20.437  1.00  4.64           C
ATOM    776  CZ  PHE    99      22.440  11.853  21.632  1.00  6.05           C
ATOM    777  CE2 PHE    99      21.788  12.916  22.237  1.00  6.13           C
ATOM    778  CD2 PHE    99      20.637  13.451  21.653  1.00  4.45           C
ATOM    779  C   PHE    99      17.879  14.560  17.845  1.00  2.00           C
ATOM    780  O   PHE    99      17.141  15.436  18.289  1.00  2.00           O
ATOM    781  N   ARG   100      17.593  13.824  16.777  1.00  2.00           N
ATOM    782  CA  ARG   100      16.347  14.003  16.029  1.00  2.00           C
ATOM    783  CB  ARG   100      16.636  14.226  14.534  1.00  2.00           C
ATOM    784  CG  ARG   100      17.194  15.663  14.239  1.00  2.00           C
ATOM    785  CD  ARG   100      17.570  15.857  12.763  1.00  2.00           C
ATOM    786  NE  ARG   100      18.702  14.983  12.442  1.00  2.00           N
ATOM    787  CZ  ARG   100      18.848  14.363  11.281  1.00  2.00           C
ATOM    788  NH1 ARG   100      17.939  14.536  10.318  1.00  2.00           N
ATOM    789  NH2 ARG   100      19.894  13.569  11.082  1.00  2.00           N
ATOM    790  C   ARG   100      15.389  12.845  16.260  1.00  2.00           C
ATOM    791  O   ARG   100      14.286  12.805  15.747  1.00  2.00           O
ATOM    792  N   ALA   101      15.818  11.891  17.056  1.00  2.00           N
ATOM    793  CA  ALA   101      14.955  10.779  17.358  1.00  2.00           C
ATOM    794  CB  ALA   101      14.984   9.708  16.249  1.00  2.00           C
ATOM    795  C   ALA   101      15.399  10.225  18.683  1.00  2.00           C
ATOM    796  O   ALA   101      16.577  10.283  19.019  1.00  2.00           O
ATOM    797  N   LEU   102      14.438   9.694  19.411  1.00  2.00           N
ATOM    798  CA  LEU   102      14.628   9.293  20.789  1.00  2.68           C
ATOM    799  CB  LEU   102      14.087  10.411  21.707  1.00  3.10           C
ATOM    800  CG  LEU   102      14.000  10.196  23.215  1.00  5.28           C
ATOM    801  CD1 LEU   102      15.328   9.757  23.804  1.00 11.18           C
ATOM    802  CD2 LEU   102      13.480  11.465  23.900  1.00 10.50           C
ATOM    803  C   LEU   102      13.841   8.008  21.017  1.00  2.36           C
ATOM    804  O   LEU   102      12.646   7.984  20.817  1.00  2.00           O
ATOM    805  N   ILE   103      14.509   6.960  21.471  1.00  2.00           N
ATOM    806  CA  ILE   103      13.842   5.699  21.715  1.00  2.00           C
ATOM    807  CB  ILE   103      14.530   4.571  20.899  1.00  2.00           C
ATOM    808  CG1 ILE   103      14.256   4.789  19.391  1.00  2.00           C
ATOM    809  CD1 ILE   103      15.330   4.253  18.435  1.00  2.00           C
ATOM    810  CG2 ILE   103      14.035   3.219  21.402  1.00  2.00           C
ATOM    811  C   ILE   103      13.995   5.379  23.192  1.00  2.00           C
ATOM    812  O   ILE   103      15.105   5.367  23.705  1.00  2.00           O
ATOM    813  N   ILE   104      12.892   5.116  23.860  1.00  2.00           N
ATOM    814  CA  ILE   104      12.894   4.833  25.276  1.00  2.92           C
ATOM    815  CB  ILE   104      11.850   5.738  25.979  1.00  3.13           C
ATOM    816  CG1 ILE   104      12.324   7.190  25.955  1.00  6.62           C
ATOM    817  CD1 ILE   104      11.146   8.150  26.134  1.00 11.71           C
ATOM    818  CG2 ILE   104      11.605   5.338  27.421  1.00  5.31           C
ATOM    819  C   ILE   104      12.587   3.353  25.490  1.00  2.55           C
ATOM    820  O   ILE   104      11.620   2.806  24.943  1.00  2.64           O
ATOM    821  N   SER   105      13.417   2.703  26.280  1.00  2.48           N
ATOM    822  CA  SER   105      13.259   1.287  26.544  1.00  3.30           C
ATOM    823  CB  SER   105      14.324   0.532  25.733  1.00  3.85           C
ATOM    824  OG  SER   105      14.528  -0.788  26.190  1.00  7.51           O
ATOM    825  C   SER   105      13.425   1.116  28.044  1.00  3.08           C
ATOM    826  O   SER   105      14.031   1.978  28.682  1.00  2.39           O
ATOM    827  N   PRO   106      12.870   0.017  28.627  1.00  3.28           N
ATOM    828  CA  PRO   106      12.837  -0.123  30.085  1.00  3.43           C
ATOM    829  CB  PRO   106      12.050  -1.441  30.306  1.00  4.16           C
ATOM    830  CG  PRO   106      11.330  -1.706  29.026  1.00  3.07           C
ATOM    831  CD  PRO   106      12.204  -1.115  27.950  1.00  3.01           C
ATOM    832  C   PRO   106      14.207  -0.223  30.765  1.00  3.80           C
ATOM    833  O   PRO   106      14.375   0.279  31.880  1.00  2.85           O
ATOM    834  N   THR   107      15.170  -0.877  30.126  1.00  3.73           N
ATOM    835  CA  THR   107      16.429  -1.149  30.821  1.00  4.76           C
ATOM    836  CB  THR   107      16.501  -2.613  31.359  1.00  4.32           C
ATOM    837  OG1 THR   107      16.383  -3.540  30.270  1.00  6.22           O
ATOM    838  CG2 THR   107      15.396  -2.885  32.363  1.00  4.98           C
ATOM    839  C   THR   107      17.658  -0.893  29.962  1.00  5.12           C
ATOM    840  O   THR   107      17.565  -0.841  28.740  1.00  4.73           O
ATOM    841  N   ARG   108      18.804  -0.710  30.622  1.00  5.75           N
ATOM    842  CA  ARG   108      20.093  -0.699  29.942  1.00  6.24           C
ATOM    843  CB  ARG   108      21.244  -0.669  30.971  1.00  6.48           C
ATOM    844  CG  ARG   108      22.626  -0.554  30.332  1.00  9.74           C
ATOM    845  CD  ARG   108      23.752  -0.526  31.355  1.00 13.87           C
ATOM    846  NE  ARG   108      23.490  -1.420  32.477  1.00 17.31           N
ATOM    847  CZ  ARG   108      23.059  -1.008  33.667  1.00 17.75           C
ATOM    848  NH1 ARG   108      22.852   0.284  33.891  1.00 18.97           N
ATOM    849  NH2 ARG   108      22.840  -1.883  34.633  1.00 17.54           N
ATOM    850  C   ARG   108      20.242  -1.898  28.983  1.00  5.78           C
ATOM    851  O   ARG   108      20.658  -1.711  27.840  1.00  6.04           O
ATOM    852  N   GLU   109      19.900  -3.112  29.446  1.00  5.39           N
ATOM    853  CA  GLU   109      20.001  -4.343  28.637  1.00  5.47           C
ATOM    854  CB  GLU   109      19.490  -5.574  29.414  1.00  5.95           C
ATOM    855  CG  GLU   109      20.008  -5.720  30.846  1.00  9.99           C
ATOM    856  CD  GLU   109      19.128  -5.019  31.915  1.00 13.36           C
ATOM    857  OE1 GLU   109      18.055  -5.578  32.307  1.00 12.23           O
ATOM    858  OE2 GLU   109      19.541  -3.923  32.380  1.00 13.33           O
ATOM    859  C   GLU   109      19.216  -4.239  27.331  1.00  4.33           C
ATOM    860  O   GLU   109      19.752  -4.436  26.231  1.00  3.59           O
ATOM    861  N   LEU   110      17.937  -3.914  27.453  1.00  3.40           N
ATOM    862  CA  LEU   110      17.094  -3.800  26.274  1.00  2.93           C
ATOM    863  CB  LEU   110      15.625  -3.720  26.668  1.00  2.90           C
ATOM    864  CG  LEU   110      15.178  -5.006  27.372  1.00  4.84           C
ATOM    865  CD1 LEU   110      13.763  -4.890  27.946  1.00  7.07           C
ATOM    866  CD2 LEU   110      15.307  -6.208  26.469  1.00  4.99           C
ATOM    867  C   LEU   110      17.506  -2.613  25.397  1.00  2.63           C
ATOM    868  O   LEU   110      17.468  -2.710  24.178  1.00  2.00           O
ATOM    869  N   ALA   111      17.871  -1.495  26.019  1.00  2.83           N
ATOM    870  CA  ALA   111      18.388  -0.341  25.273  1.00  3.71           C
ATOM    871  CB  ALA   111      18.667   0.854  26.204  1.00  2.80           C
ATOM    872  C   ALA   111      19.641  -0.728  24.480  1.00  4.78           C
ATOM    873  O   ALA   111      19.769  -0.407  23.288  1.00  4.84           O
ATOM    874  N   SER   112      20.563  -1.434  25.126  1.00  6.27           N
ATOM    875  CA  SER   112      21.794  -1.791  24.428  1.00  7.57           C
ATOM    876  CB  SER   112      22.806  -2.459  25.360  1.00  7.45           C
ATOM    877  OG  SER   112      22.466  -3.823  25.495  1.00 12.33           O
ATOM    878  C   SER   112      21.525  -2.640  23.165  1.00  7.23           C
ATOM    879  O   SER   112      22.145  -2.405  22.128  1.00  5.94           O
ATOM    880  N   GLN   113      20.574  -3.578  23.239  1.00  7.50           N
ATOM    881  CA  GLN   113      20.190  -4.370  22.056  1.00  7.95           C
ATOM    882  CB  GLN   113      19.224  -5.504  22.421  1.00  9.10           C
ATOM    883  CG  GLN   113      19.803  -6.597  23.301  1.00 15.35           C
ATOM    884  CD  GLN   113      18.744  -7.602  23.705  1.00 20.73           C
ATOM    885  OE1 GLN   113      18.007  -7.393  24.671  1.00 23.30           O
ATOM    886  NE2 GLN   113      18.653  -8.698  22.954  1.00 23.56           N
ATOM    887  C   GLN   113      19.572  -3.531  20.923  1.00  6.67           C
ATOM    888  O   GLN   113      19.860  -3.759  19.737  1.00  5.80           O
ATOM    889  N   ILE   114      18.703  -2.579  21.262  1.00  5.06           N
ATOM    890  CA  ILE   114      18.209  -1.670  20.233  1.00  4.34           C
ATOM    891  CB  ILE   114      17.156  -0.680  20.793  1.00  5.00           C
ATOM    892  CG1 ILE   114      15.855  -1.431  21.147  1.00  5.80           C
ATOM    893  CD1 ILE   114      14.988  -0.711  22.207  1.00  5.98           C
ATOM    894  CG2 ILE   114      16.911   0.454  19.814  1.00  4.99           C
ATOM    895  C   ILE   114      19.371  -0.892  19.613  1.00  4.38           C
ATOM    896  O   ILE   114      19.452  -0.707  18.397  1.00  3.41           O
ATOM    897  N   HIS   115      20.281  -0.429  20.452  1.00  4.02           N
ATOM    898  CA  HIS   115      21.414   0.354  19.963  1.00  5.12           C
ATOM    899  CB  HIS   115      22.276   0.791  21.171  1.00  4.94           C
ATOM    900  CG  HIS   115      23.448   1.639  20.808  1.00  4.43           C
ATOM    901  ND1 HIS   115      24.744   1.186  20.868  1.00  8.16           N
ATOM    902  CE1 HIS   115      25.567   2.155  20.517  1.00  7.33           C
ATOM    903  NE2 HIS   115      24.846   3.223  20.230  1.00  6.55           N
ATOM    904  CD2 HIS   115      23.519   2.925  20.403  1.00  5.61           C
ATOM    905  C   HIS   115      22.252  -0.459  18.941  1.00  5.67           C
ATOM    906  O   HIS   115      22.635   0.048  17.869  1.00  5.57           O
ATOM    907  N   ARG   116      22.540  -1.715  19.265  1.00  6.93           N
ATOM    908  CA  ARG   116      23.320  -2.556  18.359  1.00  8.35           C
ATOM    909  CB  ARG   116      23.750  -3.858  19.061  1.00  9.22           C
ATOM    910  CG  ARG   116      24.782  -3.632  20.153  1.00 11.28           C
ATOM    911  CD  ARG   116      25.399  -4.933  20.636  1.00 16.80           C
ATOM    912  NE  ARG   116      26.241  -5.571  19.621  1.00 21.11           N
ATOM    913  CZ  ARG   116      27.239  -6.406  19.911  1.00 21.97           C
ATOM    914  NH1 ARG   116      27.504  -6.699  21.183  1.00 22.55           N
ATOM    915  NH2 ARG   116      27.971  -6.952  18.943  1.00 21.73           N
ATOM    916  C   ARG   116      22.609  -2.839  17.016  1.00  8.58           C
ATOM    917  O   ARG   116      23.240  -2.848  15.956  1.00  9.07           O
ATOM    918  N   GLU   117      21.309  -3.085  17.071  1.00  8.39           N
ATOM    919  CA  GLU   117      20.528  -3.315  15.868  1.00  9.36           C
ATOM    920  CB  GLU   117      19.080  -3.651  16.232  1.00  9.61           C
ATOM    921  CG  GLU   117      18.180  -3.895  15.025  1.00 14.15           C
ATOM    922  CD  GLU   117      18.004  -5.400  14.739  1.00 20.80           C
ATOM    923  OE1 GLU   117      19.035  -6.104  14.634  1.00 21.79           O
ATOM    924  OE2 GLU   117      16.837  -5.871  14.644  1.00 24.25           O
ATOM    925  C   GLU   117      20.585  -2.065  14.965  1.00  8.68           C
ATOM    926  O   GLU   117      20.785  -2.169  13.755  1.00  8.54           O
ATOM    927  N   LEU   118      20.445  -0.888  15.564  1.00  7.27           N
ATOM    928  CA  LEU   118      20.543   0.358  14.806  1.00  7.76           C
ATOM    929  CB  LEU   118      20.237   1.571  15.702  1.00  7.42           C
ATOM    930  CG  LEU   118      18.764   1.954  15.829  1.00  7.92           C
ATOM    931  CD1 LEU   118      18.488   2.869  17.054  1.00  8.32           C
ATOM    932  CD2 LEU   118      18.276   2.606  14.542  1.00  6.55           C
ATOM    933  C   LEU   118      21.924   0.535  14.175  1.00  7.42           C
ATOM    934  O   LEU   118      22.048   0.967  13.022  1.00  7.74           O
ATOM    935  N   ILE   119      22.954   0.257  14.955  1.00  6.50           N
ATOM    936  CA  ILE   119      24.307   0.407  14.488  1.00  6.76           C
ATOM    937  CB  ILE   119      25.324  -0.048  15.553  1.00  6.73           C
ATOM    938  CG1 ILE   119      25.377   0.962  16.700  1.00  7.32           C
ATOM    939  CD1 ILE   119      25.589   2.336  16.211  1.00  8.63           C
ATOM    940  CG2 ILE   119      26.703  -0.226  14.932  1.00  5.63           C
ATOM    941  C   ILE   119      24.467  -0.483  13.269  1.00  7.02           C
ATOM    942  O   ILE   119      24.972  -0.047  12.239  1.00  6.37           O
ATOM    943  N   LYS   120      24.002  -1.728  13.387  1.00  7.26           N
ATOM    944  CA  LYS   120      24.234  -2.719  12.337  1.00  7.41           C
ATOM    945  CB  LYS   120      23.900  -4.129  12.841  1.00  7.82           C
ATOM    946  CG  LYS   120      24.586  -5.263  12.083  1.00 11.90           C
ATOM    947  CD  LYS   120      23.801  -6.553  12.270  1.00 16.51           C
ATOM    948  CE  LYS   120      22.459  -6.496  11.510  1.00 18.66           C
ATOM    949  NZ  LYS   120      21.406  -7.252  12.249  1.00 21.96           N
ATOM    950  C   LYS   120      23.465  -2.374  11.053  1.00  6.64           C
ATOM    951  O   LYS   120      24.051  -2.371   9.968  1.00  6.78           O
ATOM    952  N   ILE   121      22.175  -2.047  11.175  1.00  5.79           N
ATOM    953  CA  ILE   121      21.364  -1.766   9.984  0.50  5.80           C
ATOM    955  CB  ILE   121      19.824  -1.783  10.237  0.50  5.78           C
ATOM    957  CG1 ILE   121      19.391  -0.613  11.126  0.50  4.91           C
ATOM    959  CD1 ILE   121      17.936  -0.272  10.967  0.50  2.62           C
ATOM    961  CG2 ILE   121      19.361  -3.128  10.790  0.50  7.00           C
ATOM    963  C   ILE   121      21.737  -0.442   9.340  1.00  5.51           C
ATOM    964  O   ILE   121      21.449  -0.203   8.168  1.00  6.07           O
ATOM    965  N   SER   122      22.424   0.414  10.068  1.00  5.61           N
ATOM    966  CA  SER   122      22.780   1.704   9.498  1.00  5.53           C
ATOM    967  CB  SER   122      22.372   2.854  10.439  1.00  6.02           C
ATOM    968  OG  SER   122      23.234   2.952  11.569  1.00  6.51           O
ATOM    969  C   SER   122      24.250   1.808   9.093  1.00  5.41           C
ATOM    970  O   SER   122      24.705   2.878   8.684  1.00  5.28           O
ATOM    971  N   GLU   123      24.990   0.697   9.158  1.00  5.57           N
ATOM    972  CA  GLU   123      26.402   0.719   8.783  1.00  6.04           C
ATOM    973  CB  GLU   123      26.998  -0.694   8.762  1.00  7.03           C
ATOM    974  CG  GLU   123      27.265  -1.228  10.146  1.00 10.40           C
ATOM    975  CD  GLU   123      27.928  -2.592  10.122  1.00 16.71           C
ATOM    976  OE1 GLU   123      28.176  -3.138   9.010  1.00 18.65           O
ATOM    977  OE2 GLU   123      28.196  -3.120  11.226  1.00 19.05           O
ATOM    978  C   GLU   123      26.622   1.399   7.439  1.00  5.58           C
ATOM    979  O   GLU   123      25.891   1.135   6.457  1.00  5.05           O
ATOM    980  N   GLY   124      27.617   2.277   7.395  1.00  4.24           N
ATOM    981  CA  GLY   124      27.957   2.970   6.159  1.00  3.98           C
ATOM    982  C   GLY   124      27.079   4.158   5.779  1.00  3.83           C
ATOM    983  O   GLY   124      27.319   4.781   4.759  1.00  3.96           O
ATOM    984  N   THR   125      26.071   4.479   6.593  1.00  3.61           N
ATOM    985  CA  THR   125      25.171   5.603   6.329  1.00  3.88           C
ATOM    986  CB  THR   125      23.719   5.285   6.790  1.00  3.79           C
ATOM    987  OG1 THR   125      23.635   5.329   8.224  1.00  2.98           O
ATOM    988  CG2 THR   125      23.292   3.903   6.295  1.00  5.14           C
ATOM    989  C   THR   125      25.594   6.892   7.025  1.00  4.01           C
ATOM    990  O   THR   125      25.047   7.975   6.739  1.00  4.24           O
ATOM    991  N   GLY   126      26.509   6.763   7.986  1.00  3.16           N
ATOM    992  CA  GLY   126      26.991   7.896   8.764  1.00  3.02           C
ATOM    993  C   GLY   126      26.126   8.369   9.924  1.00  2.57           C
ATOM    994  O   GLY   126      26.458   9.350  10.569  1.00  2.12           O
ATOM    995  N   PHE   127      24.993   7.721  10.174  1.00  3.20           N
ATOM    996  CA  PHE   127      24.185   8.100  11.346  1.00  2.65           C
ATOM    997  CB  PHE   127      22.818   7.420  11.353  1.00  3.03           C
ATOM    998  CG  PHE   127      21.811   8.082  10.454  1.00  4.00           C
ATOM    999  CD1 PHE   127      21.113   9.208  10.880  1.00  4.40           C
ATOM   1000  CE1 PHE   127      20.186   9.841  10.040  1.00  2.17           C
ATOM   1001  CZ  PHE   127      19.955   9.342   8.796  1.00  3.15           C
ATOM   1002  CE2 PHE   127      20.621   8.202   8.366  1.00  3.16           C
ATOM   1003  CD2 PHE   127      21.561   7.586   9.183  1.00  2.91           C
ATOM   1004  C   PHE   127      24.935   7.766  12.647  1.00  2.77           C
ATOM   1005  O   PHE   127      25.556   6.706  12.774  1.00  2.00           O
ATOM   1006  N   ARG   128      24.857   8.686  13.600  1.00  2.53           N
ATOM   1007  CA  ARG   128      25.471   8.512  14.905  1.00  3.52           C
ATOM   1008  CB  ARG   128      26.287   9.757  15.260  1.00  3.97           C
ATOM   1009  CG  ARG   128      27.535   9.823  14.398  1.00  7.72           C
ATOM   1010  CD  ARG   128      27.795  11.209  13.917  1.00 11.74           C
ATOM   1011  NE  ARG   128      26.517  11.828  13.563  1.00 13.54           N
ATOM   1012  CZ  ARG   128      26.392  13.088  13.169  1.00 10.99           C
ATOM   1013  NH1 ARG   128      27.495  13.850  13.047  1.00 10.55           N
ATOM   1014  NH2 ARG   128      25.191  13.563  12.879  1.00  4.20           N
ATOM   1015  C   ARG   128      24.388   8.215  15.933  1.00  3.59           C
ATOM   1016  O   ARG   128      23.474   9.017  16.178  1.00  3.03           O
ATOM   1017  N   ILE   129      24.471   7.024  16.500  1.00  3.61           N
ATOM   1018  CA  ILE   129      23.449   6.543  17.388  1.00  3.38           C
ATOM   1019  CB  ILE   129      22.873   5.265  16.837  1.00  3.90           C
ATOM   1020  CG1 ILE   129      22.297   5.513  15.431  1.00  5.13           C
ATOM   1021  CD1 ILE   129      22.597   4.385  14.452  1.00  5.34           C
ATOM   1022  CG2 ILE   129      21.843   4.676  17.796  1.00  2.38           C
ATOM   1023  C   ILE   129      24.147   6.276  18.709  1.00  4.22           C
ATOM   1024  O   ILE   129      25.225   5.666  18.750  1.00  3.31           O
ATOM   1025  N   HIS   130      23.550   6.753  19.788  1.00  4.46           N
ATOM   1026  CA  HIS   130      24.240   6.805  21.068  1.00  5.28           C
ATOM   1027  CB  HIS   130      24.653   8.249  21.391  1.00  5.77           C
ATOM   1028  CG  HIS   130      25.719   8.786  20.496  1.00  8.01           C
ATOM   1029  ND1 HIS   130      27.051   8.470  20.655  1.00 12.01           N
ATOM   1030  CE1 HIS   130      27.761   9.075  19.715  1.00 11.42           C
ATOM   1031  NE2 HIS   130      26.931   9.758  18.944  1.00 11.39           N
ATOM   1032  CD2 HIS   130      25.649   9.592  19.407  1.00  8.29           C
ATOM   1033  C   HIS   130      23.361   6.307  22.193  1.00  4.99           C
ATOM   1034  O   HIS   130      22.137   6.374  22.117  1.00  3.70           O
ATOM   1035  N   MET   131      24.005   5.811  23.233  1.00  5.47           N
ATOM   1036  CA  MET   131      23.395   5.704  24.542  1.00  6.59           C
ATOM   1037  CB  MET   131      23.569   4.289  25.089  1.00  6.48           C
ATOM   1038  CG  MET   131      22.939   3.255  24.175  1.00  8.78           C
ATOM   1039  SD  MET   131      22.701   1.658  24.951  1.00  9.07           S
ATOM   1040  CE  MET   131      24.337   0.955  24.850  1.00 13.73           C
ATOM   1041  C   MET   131      24.178   6.728  25.360  1.00  7.00           C
ATOM   1042  O   MET   131      25.341   6.997  25.052  1.00  7.28           O
ATOM   1043  N   ILE   132      23.564   7.338  26.363  1.00  7.35           N
ATOM   1044  CA  ILE   132      24.318   8.245  27.214  1.00  7.34           C
ATOM   1045  CB  ILE   132      23.625   9.612  27.363  1.00  7.59           C
ATOM   1046  CG1 ILE   132      23.469  10.281  25.985  1.00  6.69           C
ATOM   1047  CD1 ILE   132      22.551  11.485  25.985  1.00  7.48           C
ATOM   1048  CG2 ILE   132      24.438  10.489  28.330  1.00  7.04           C
ATOM   1049  C   ILE   132      24.643   7.624  28.598  1.00  7.77           C
ATOM   1050  O   ILE   132      23.787   7.504  29.480  1.00  7.79           O
ATOM   1051  N   HIS   133      25.891   7.223  28.763  1.00  7.80           N
ATOM   1052  CA  HIS   133      26.340   6.557  29.971  1.00  8.35           C
ATOM   1053  CB  HIS   133      27.483   5.565  29.655  1.00  8.72           C
ATOM   1054  CG  HIS   133      27.048   4.398  28.823  1.00 10.75           C
ATOM   1055  ND1 HIS   133      26.449   3.279  29.368  1.00 13.62           N
ATOM   1056  CE1 HIS   133      26.145   2.430  28.400  1.00 14.32           C
ATOM   1057  NE2 HIS   133      26.508   2.965  27.245  1.00 14.63           N
ATOM   1058  CD2 HIS   133      27.069   4.199  27.482  1.00 12.82           C
ATOM   1059  C   HIS   133      26.784   7.562  31.018  1.00  8.10           C
ATOM   1060  O   HIS   133      26.924   8.757  30.726  1.00  7.93           O
ATOM   1061  N   LYS   134      27.017   7.057  32.227  1.00  7.98           N
ATOM   1062  CA  LYS   134      27.360   7.867  33.392  1.00  8.10           C
ATOM   1063  CB  LYS   134      27.757   6.958  34.568  1.00  8.20           C
ATOM   1064  CG  LYS   134      26.594   6.413  35.404  1.00  8.64           C
ATOM   1065  CD  LYS   134      27.152   5.631  36.614  1.00  9.93           C
ATOM   1066  CE  LYS   134      26.100   5.414  37.689  1.00 10.02           C
ATOM   1067  NZ  LYS   134      24.906   4.719  37.135  1.00 10.40           N
ATOM   1068  C   LYS   134      28.469   8.886  33.158  1.00  8.09           C
ATOM   1069  O   LYS   134      28.315  10.066  33.474  1.00  8.89           O
ATOM   1070  N   ALA   135      29.601   8.435  32.634  1.00  7.78           N
ATOM   1071  CA  ALA   135      30.725   9.344  32.348  1.00  7.06           C
ATOM   1072  CB  ALA   135      31.933   8.544  31.953  1.00  6.58           C
ATOM   1073  C   ALA   135      30.388  10.416  31.272  1.00  7.07           C
ATOM   1074  O   ALA   135      30.828  11.569  31.361  1.00  5.86           O
ATOM   1075  N   ALA   136      29.612  10.037  30.259  1.00  7.08           N
ATOM   1076  CA  ALA   136      29.136  11.015  29.285  1.00  8.14           C
ATOM   1077  CB  ALA   136      28.414  10.320  28.132  1.00  8.53           C
ATOM   1078  C   ALA   136      28.208  12.054  29.949  1.00  9.04           C
ATOM   1079  O   ALA   136      28.216  13.240  29.594  1.00  8.86           O
ATOM   1080  N   VAL   137      27.402  11.597  30.902  1.00  9.47           N
ATOM   1081  CA  VAL   137      26.561  12.496  31.665  1.00 10.61           C
ATOM   1082  CB  VAL   137      25.621  11.706  32.624  1.00 10.83           C
ATOM   1083  CG1 VAL   137      24.750  12.663  33.472  1.00 10.73           C
ATOM   1084  CG2 VAL   137      24.760  10.711  31.837  1.00  8.15           C
ATOM   1085  C   VAL   137      27.462  13.446  32.466  1.00 11.72           C
ATOM   1086  O   VAL   137      27.307  14.663  32.410  1.00 11.69           O
ATOM   1087  N   ALA   138      28.414  12.883  33.205  1.00 12.47           N
ATOM   1088  CA  ALA   138      29.390  13.703  33.914  1.00 13.56           C
ATOM   1089  CB  ALA   138      30.415  12.826  34.616  1.00 13.10           C
ATOM   1090  C   ALA   138      30.077  14.704  32.967  1.00 14.14           C
ATOM   1091  O   ALA   138      30.207  15.878  33.291  1.00 14.53           O
ATOM   1092  N   ALA   139      30.490  14.243  31.792  1.00 14.92           N
ATOM   1093  CA  ALA   139      31.201  15.105  30.842  1.00 16.02           C
ATOM   1094  CB  ALA   139      32.042  14.274  29.896  1.00 16.22           C
ATOM   1095  C   ALA   139      30.335  16.087  30.040  1.00 16.61           C
ATOM   1096  O   ALA   139      30.876  16.962  29.375  1.00 16.58           O
ATOM   1097  N   LYS   140      29.009  15.943  30.086  1.00 17.36           N
ATOM   1098  CA  LYS   140      28.133  16.847  29.343  1.00 17.49           C
ATOM   1099  CB  LYS   140      28.375  18.302  29.775  1.00 17.87           C
ATOM   1100  CG  LYS   140      27.917  18.654  31.192  1.00 19.17           C
ATOM   1101  CD  LYS   140      26.449  19.124  31.199  1.00 21.75           C
ATOM   1102  CE  LYS   140      25.975  19.491  32.608  1.00 22.07           C
ATOM   1103  NZ  LYS   140      24.537  19.921  32.677  1.00 21.26           N
ATOM   1104  C   LYS   140      28.410  16.710  27.853  1.00 17.29           C
ATOM   1105  O   LYS   140      28.281  17.664  27.094  1.00 17.27           O
ATOM   1106  N   LYS   141      28.795  15.513  27.432  1.00 17.15           N
ATOM   1107  CA  LYS   141      29.212  15.306  26.054  1.00 17.26           C
ATOM   1108  CB  LYS   141      29.758  13.883  25.865  1.00 17.28           C
ATOM   1109  CG  LYS   141      30.601  13.701  24.603  1.00 19.02           C
ATOM   1110  CD  LYS   141      30.559  12.250  24.107  1.00 21.82           C
ATOM   1111  CE  LYS   141      30.748  12.166  22.586  1.00 21.87           C
ATOM   1112  NZ  LYS   141      31.105  10.793  22.133  1.00 21.82           N
ATOM   1113  C   LYS   141      28.084  15.598  25.043  1.00 17.19           C
ATOM   1114  O   LYS   141      28.347  15.921  23.885  1.00 16.57           O
ATOM   1115  N   PHE   142      26.830  15.471  25.467  1.00 17.38           N
ATOM   1116  CA  PHE   142      25.708  15.700  24.542  1.00 18.04           C
ATOM   1117  CB  PHE   142      24.792  14.479  24.463  1.00 17.39           C
ATOM   1118  CG  PHE   142      25.492  13.239  24.020  1.00 17.23           C
ATOM   1119  CD1 PHE   142      26.091  12.400  24.946  1.00 18.95           C
ATOM   1120  CE1 PHE   142      26.751  11.258  24.540  1.00 18.92           C
ATOM   1121  CZ  PHE   142      26.822  10.945  23.197  1.00 19.30           C
ATOM   1122  CE2 PHE   142      26.221  11.770  22.263  1.00 19.14           C
ATOM   1123  CD2 PHE   142      25.569  12.913  22.677  1.00 18.44           C
ATOM   1124  C   PHE   142      24.916  16.919  24.949  1.00 18.77           C
ATOM   1125  O   PHE   142      23.770  17.086  24.539  1.00 19.52           O
ATOM   1126  N   GLY   143      25.531  17.767  25.764  1.00 19.79           N
ATOM   1127  CA  GLY   143      24.896  19.001  26.208  1.00 20.51           C
ATOM   1128  C   GLY   143      24.483  19.922  25.071  1.00 21.43           C
ATOM   1129  O   GLY   143      24.968  19.804  23.941  1.00 21.03           O
ATOM   1130  N   PRO   144      23.545  20.839  25.363  1.00 22.22           N
ATOM   1131  CA  PRO   144      23.202  21.927  24.444  1.00 22.20           C
ATOM   1132  CB  PRO   144      22.248  22.788  25.278  1.00 22.24           C
ATOM   1133  CG  PRO   144      21.518  21.754  26.140  1.00 22.75           C
ATOM   1134  CD  PRO   144      22.589  20.730  26.489  1.00 21.98           C
ATOM   1135  C   PRO   144      24.431  22.731  23.959  1.00 22.05           C
ATOM   1136  O   PRO   144      24.429  23.219  22.822  1.00 22.83           O
ATOM   1137  N   LYS   145      25.485  22.841  24.765  1.00 20.97           N
ATOM   1138  CA  LYS   145      26.684  23.546  24.279  1.00 20.14           C
ATOM   1139  CB  LYS   145      27.315  24.406  25.380  1.00 20.22           C
ATOM   1144  C   LYS   145      27.739  22.630  23.640  1.00 19.49           C
ATOM   1145  O   LYS   145      28.912  22.976  23.579  1.00 19.66           O
ATOM   1146  N   SER   146      27.322  21.468  23.152  1.00 18.25           N
ATOM   1147  CA  SER   146      28.250  20.547  22.495  1.00 16.80           C
ATOM   1148  CB  SER   146      27.864  19.099  22.807  1.00 16.94           C
ATOM   1149  OG  SER   146      26.706  18.719  22.061  1.00 14.20           O
ATOM   1150  C   SER   146      28.232  20.739  20.978  1.00 16.24           C
ATOM   1151  O   SER   146      27.574  21.642  20.460  1.00 15.50           O
ATOM   1152  N   SER   147      28.937  19.853  20.285  1.00 15.80           N
ATOM   1153  CA  SER   147      29.011  19.824  18.815  1.00 15.62           C
ATOM   1154  CB  SER   147      29.947  18.683  18.396  1.00 15.78           C
ATOM   1155  OG  SER   147      29.349  17.415  18.708  1.00 17.28           O
ATOM   1156  C   SER   147      27.648  19.610  18.118  1.00 14.85           C
ATOM   1157  O   SER   147      27.420  20.110  17.025  1.00 15.12           O
ATOM   1158  N   LYS   148      26.768  18.838  18.742  1.00 13.81           N
ATOM   1159  CA  LYS   148      25.466  18.470  18.151  1.00 13.28           C
ATOM   1160  CB  LYS   148      24.645  19.698  17.773  1.00 13.70           C
ATOM   1161  CG  LYS   148      24.599  20.705  18.891  1.00 16.01           C
ATOM   1162  CD  LYS   148      23.301  21.495  18.977  1.00 20.40           C
ATOM   1163  CE  LYS   148      23.398  22.428  20.204  1.00 23.32           C
ATOM   1164  NZ  LYS   148      22.284  23.426  20.342  1.00 25.99           N
ATOM   1165  C   LYS   148      25.561  17.493  16.976  1.00 12.03           C
ATOM   1166  O   LYS   148      24.594  17.278  16.250  1.00 11.95           O
ATOM   1167  N   LYS   149      26.726  16.894  16.810  1.00 10.19           N
ATOM   1168  CA  LYS   149      26.897  15.889  15.801  1.00  9.30           C
ATOM   1169  CB  LYS   149      28.340  15.866  15.295  1.00  9.29           C
ATOM   1170  CG  LYS   149      28.825  17.235  14.822  1.00 11.57           C
ATOM   1171  CD  LYS   149      29.563  17.189  13.475  1.00 14.93           C
ATOM   1172  CE  LYS   149      30.943  16.580  13.631  1.00 17.83           C
ATOM   1173  NZ  LYS   149      31.599  17.084  14.872  1.00 19.27           N
ATOM   1174  C   LYS   149      26.490  14.534  16.362  1.00  7.95           C
ATOM   1175  O   LYS   149      27.334  13.674  16.612  1.00  8.28           O
ATOM   1176  N   PHE   150      25.190  14.369  16.571  1.00  6.10           N
ATOM   1177  CA  PHE   150      24.603  13.100  16.965  1.00  5.12           C
ATOM   1178  CB  PHE   150      24.702  12.886  18.475  1.00  5.47           C
ATOM   1179  CG  PHE   150      24.635  14.160  19.287  1.00  7.37           C
ATOM   1180  CD1 PHE   150      23.421  14.643  19.755  1.00  9.59           C
ATOM   1181  CE1 PHE   150      23.357  15.800  20.500  1.00  9.47           C
ATOM   1182  CZ  PHE   150      24.499  16.487  20.800  1.00  9.07           C
ATOM   1183  CE2 PHE   150      25.724  16.029  20.342  1.00  9.88           C
ATOM   1184  CD2 PHE   150      25.790  14.869  19.585  1.00  8.47           C
ATOM   1185  C   PHE   150      23.154  13.106  16.500  1.00  3.91           C
ATOM   1186  O   PHE   150      22.532  14.161  16.441  1.00  3.83           O
ATOM   1187  N   ASP   151      22.619  11.934  16.171  1.00  2.77           N
ATOM   1188  CA  ASP   151      21.342  11.847  15.442  1.00  2.00           C
ATOM   1189  CB  ASP   151      21.556  11.065  14.129  1.00  2.00           C
ATOM   1190  CG  ASP   151      22.543  11.759  13.176  1.00  2.00           C
ATOM   1191  OD1 ASP   151      22.199  12.859  12.726  1.00  2.00           O
ATOM   1192  OD2 ASP   151      23.628  11.195  12.869  1.00  2.00           O
ATOM   1193  C   ASP   151      20.233  11.175  16.258  1.00  2.00           C
ATOM   1194  O   ASP   151      19.088  11.648  16.299  1.00  2.00           O
ATOM   1195  N   ILE   152      20.562  10.042  16.867  1.00  2.00           N
ATOM   1196  CA  ILE   152      19.550   9.177  17.472  1.00  2.00           C
ATOM   1197  CB  ILE   152      19.290   7.938  16.625  1.00  2.00           C
ATOM   1198  CG1 ILE   152      18.757   8.344  15.239  1.00  2.80           C
ATOM   1199  CD1 ILE   152      18.685   7.140  14.237  1.00  3.82           C
ATOM   1200  CG2 ILE   152      18.272   6.982  17.326  1.00  2.00           C
ATOM   1201  C   ILE   152      20.018   8.762  18.854  1.00  2.00           C
ATOM   1202  O   ILE   152      21.188   8.342  19.010  1.00  2.00           O
ATOM   1203  N   LEU   153      19.136   8.914  19.854  1.00  2.00           N
ATOM   1204  CA  LEU   153      19.447   8.502  21.237  1.00  2.00           C
ATOM   1205  CB  LEU   153      19.176   9.677  22.209  1.00  2.00           C
ATOM   1206  CG  LEU   153      19.434   9.376  23.700  1.00  2.00           C
ATOM   1207  CD1 LEU   153      20.914   9.084  23.976  1.00  2.00           C
ATOM   1208  CD2 LEU   153      18.933  10.532  24.619  1.00  2.00           C
ATOM   1209  C   LEU   153      18.604   7.302  21.655  1.00  2.00           C
ATOM   1210  O   LEU   153      17.371   7.331  21.519  1.00  2.00           O
ATOM   1211  N   VAL   154      19.246   6.246  22.157  1.00  2.36           N
ATOM   1212  CA  VAL   154      18.499   5.148  22.804  1.00  2.17           C
ATOM   1213  CB  VAL   154      18.931   3.724  22.300  1.00  3.16           C
ATOM   1214  CG1 VAL   154      17.880   2.664  22.743  1.00  2.00           C
ATOM   1215  CG2 VAL   154      19.050   3.693  20.759  1.00  2.42           C
ATOM   1216  C   VAL   154      18.716   5.243  24.310  1.00  2.60           C
ATOM   1217  O   VAL   154      19.842   5.361  24.766  1.00  2.46           O
ATOM   1218  N   THR   155      17.653   5.181  25.105  1.00  2.34           N
ATOM   1219  CA  THR   155      17.830   5.427  26.527  1.00  2.60           C
ATOM   1220  CB  THR   155      17.955   6.970  26.783  1.00  2.96           C
ATOM   1221  OG1 THR   155      18.328   7.209  28.135  1.00  4.18           O
ATOM   1222  CG2 THR   155      16.639   7.665  26.526  1.00  2.00           C
ATOM   1223  C   THR   155      16.684   4.825  27.363  1.00  2.43           C
ATOM   1224  O   THR   155      15.748   4.224  26.822  1.00  2.00           O
ATOM   1225  N   THR   156      16.799   4.974  28.677  1.00  2.00           N
ATOM   1226  CA  THR   156      15.783   4.571  29.617  1.00  2.10           C
ATOM   1227  CB  THR   156      16.417   3.916  30.836  1.00  2.00           C
ATOM   1228  OG1 THR   156      17.341   4.846  31.414  1.00  2.00           O
ATOM   1229  CG2 THR   156      17.152   2.646  30.439  1.00  3.36           C
ATOM   1230  C   THR   156      15.074   5.833  30.110  1.00  2.00           C
ATOM   1231  O   THR   156      15.585   6.933  29.971  1.00  2.88           O
ATOM   1232  N   PRO   157      13.887   5.670  30.693  1.00  2.41           N
ATOM   1233  CA  PRO   157      13.150   6.821  31.217  1.00  2.25           C
ATOM   1234  CB  PRO   157      11.909   6.180  31.832  1.00  2.61           C
ATOM   1235  CG  PRO   157      11.802   4.788  31.141  1.00  2.11           C
ATOM   1236  CD  PRO   157      13.179   4.382  30.870  1.00  2.00           C
ATOM   1237  C   PRO   157      13.949   7.585  32.299  1.00  3.24           C
ATOM   1238  O   PRO   157      13.993   8.840  32.273  1.00  3.29           O
ATOM   1239  N   ASN   158      14.536   6.861  33.260  1.00  2.64           N
ATOM   1240  CA  ASN   158      15.203   7.533  34.391  1.00  3.59           C
ATOM   1241  CB  ASN   158      15.594   6.548  35.497  1.00  3.31           C
ATOM   1242  CG  ASN   158      14.403   6.039  36.274  1.00  5.55           C
ATOM   1243  OD1 ASN   158      13.294   6.572  36.171  1.00  5.84           O
ATOM   1244  ND2 ASN   158      14.631   5.001  37.073  1.00  6.54           N
ATOM   1245  C   ASN   158      16.452   8.289  33.967  1.00  3.08           C
ATOM   1246  O   ASN   158      16.742   9.365  34.487  1.00  2.08           O
ATOM   1247  N   ARG   159      17.191   7.707  33.032  1.00  2.89           N
ATOM   1248  CA  ARG   159      18.421   8.335  32.542  1.00  4.01           C
ATOM   1249  CB  ARG   159      19.200   7.377  31.611  1.00  4.52           C
ATOM   1250  CG  ARG   159      20.411   8.033  30.878  1.00  6.25           C
ATOM   1251  CD  ARG   159      21.462   8.624  31.859  1.00  8.89           C
ATOM   1252  NE  ARG   159      21.787   7.727  32.977  1.00 10.47           N
ATOM   1253  CZ  ARG   159      22.765   6.812  32.958  1.00 12.46           C
ATOM   1254  NH1 ARG   159      23.533   6.649  31.883  1.00 11.80           N
ATOM   1255  NH2 ARG   159      22.980   6.051  34.020  1.00 12.56           N
ATOM   1256  C   ARG   159      18.097   9.615  31.801  1.00  3.36           C
ATOM   1257  O   ARG   159      18.780  10.640  31.965  1.00  4.40           O
ATOM   1258  N   LEU   160      17.054   9.559  30.989  1.00  2.00           N
ATOM   1259  CA  LEU   160      16.660  10.706  30.202  1.00  2.44           C
ATOM   1260  CB  LEU   160      15.622  10.313  29.171  1.00  2.28           C
ATOM   1261  CG  LEU   160      14.998  11.428  28.342  1.00  3.82           C
ATOM   1262  CD1 LEU   160      16.069  12.209  27.507  1.00  2.00           C
ATOM   1263  CD2 LEU   160      13.957  10.827  27.432  1.00  2.95           C
ATOM   1264  C   LEU   160      16.135  11.830  31.107  1.00  2.72           C
ATOM   1265  O   LEU   160      16.424  13.008  30.874  1.00  2.76           O
ATOM   1266  N   ILE   161      15.397  11.455  32.152  1.00  2.00           N
ATOM   1267  CA  ILE   161      14.815  12.430  33.043  1.00  2.02           C
ATOM   1268  CB  ILE   161      13.787  11.796  34.017  1.00  2.00           C
ATOM   1269  CG1 ILE   161      12.568  11.306  33.241  1.00  2.11           C
ATOM   1270  CD1 ILE   161      11.596  12.437  32.909  1.00  3.36           C
ATOM   1271  CG2 ILE   161      13.313  12.862  35.069  1.00  2.00           C
ATOM   1272  C   ILE   161      15.926  13.057  33.866  1.00  2.03           C
ATOM   1273  O   ILE   161      15.916  14.253  34.155  1.00  2.00           O
ATOM   1274  N   TYR   162      16.882  12.233  34.271  1.00  2.15           N
ATOM   1275  CA  TYR   162      18.036  12.769  34.967  1.00  2.55           C
ATOM   1276  CB  TYR   162      19.022  11.651  35.303  1.00  3.03           C
ATOM   1277  CG  TYR   162      20.128  12.132  36.191  1.00  2.26           C
ATOM   1278  CD1 TYR   162      19.958  12.170  37.560  1.00  4.34           C
ATOM   1279  CE1 TYR   162      20.956  12.618  38.396  1.00  4.04           C
ATOM   1280  CZ  TYR   162      22.146  13.044  37.847  1.00  5.35           C
ATOM   1281  OH  TYR   162      23.138  13.498  38.670  1.00  5.30           O
ATOM   1282  CE2 TYR   162      22.341  13.034  36.479  1.00  5.58           C
ATOM   1283  CD2 TYR   162      21.322  12.579  35.655  1.00  3.64           C
ATOM   1284  C   TYR   162      18.713  13.877  34.142  1.00  2.00           C
ATOM   1285  O   TYR   162      19.035  14.948  34.655  1.00  2.26           O
ATOM   1286  N   LEU   163      18.931  13.625  32.864  1.00  2.00           N
ATOM   1287  CA  LEU   163      19.542  14.638  31.983  1.00  2.00           C
ATOM   1288  CB  LEU   163      19.791  14.064  30.593  1.00  2.00           C
ATOM   1289  CG  LEU   163      20.802  12.921  30.505  1.00  2.76           C
ATOM   1290  CD1 LEU   163      20.720  12.258  29.132  1.00  4.31           C
ATOM   1291  CD2 LEU   163      22.192  13.419  30.802  1.00  6.30           C
ATOM   1292  C   LEU   163      18.709  15.933  31.865  1.00  2.00           C
ATOM   1293  O   LEU   163      19.251  17.026  31.953  1.00  2.00           O
ATOM   1294  N   LEU   164      17.403  15.782  31.657  1.00  2.29           N
ATOM   1295  CA  LEU   164      16.484  16.898  31.519  1.00  3.44           C
ATOM   1296  CB  LEU   164      15.062  16.385  31.240  1.00  3.14           C
ATOM   1297  CG  LEU   164      14.812  15.873  29.811  1.00  4.59           C
ATOM   1298  CD1 LEU   164      13.444  15.173  29.600  1.00  2.00           C
ATOM   1299  CD2 LEU   164      15.015  17.001  28.789  1.00  4.77           C
ATOM   1300  C   LEU   164      16.476  17.758  32.782  1.00  4.24           C
ATOM   1301  O   LEU   164      16.260  18.967  32.716  1.00  4.53           O
ATOM   1302  N   LYS   165      16.708  17.133  33.936  1.00  4.83           N
ATOM   1303  CA  LYS   165      16.526  17.820  35.201  1.00  5.58           C
ATOM   1304  CB  LYS   165      15.909  16.890  36.253  1.00  6.35           C
ATOM   1305  CG  LYS   165      14.449  16.500  35.958  1.00 11.04           C
ATOM   1306  CD  LYS   165      13.647  17.692  35.409  1.00 15.28           C
ATOM   1307  CE  LYS   165      12.149  17.344  35.249  1.00 18.91           C
ATOM   1308  NZ  LYS   165      11.875  16.295  34.186  1.00 21.31           N
ATOM   1309  C   LYS   165      17.812  18.409  35.739  1.00  5.38           C
ATOM   1310  O   LYS   165      17.779  19.139  36.713  1.00  4.35           O
ATOM   1311  N   GLN   166      18.947  18.079  35.127  1.00  5.29           N
ATOM   1312  CA  GLN   166      20.202  18.710  35.509  1.00  5.66           C
ATOM   1313  CB  GLN   166      21.339  18.167  34.657  1.00  5.33           C
ATOM   1314  CG  GLN   166      21.743  16.762  34.980  1.00  5.29           C
ATOM   1315  CD  GLN   166      22.934  16.298  34.160  1.00  7.26           C
ATOM   1316  OE1 GLN   166      22.846  16.161  32.934  1.00  9.26           O
ATOM   1317  NE2 GLN   166      24.041  16.022  34.834  1.00  6.06           N
ATOM   1318  C   GLN   166      20.136  20.239  35.356  1.00  6.66           C
ATOM   1319  O   GLN   166      19.363  20.759  34.560  1.00  7.21           O
ATOM   1320  N   ASP   167      20.967  20.952  36.104  1.00  7.72           N
ATOM   1321  CA  ASP   167      21.025  22.401  36.022  1.00  8.65           C
ATOM   1322  CB  ASP   167      20.678  23.013  37.382  1.00  8.72           C
ATOM   1323  CG  ASP   167      20.897  24.518  37.421  1.00 11.15           C
ATOM   1324  OD1 ASP   167      20.741  25.165  36.355  1.00 12.51           O
ATOM   1325  OD2 ASP   167      21.223  25.053  38.514  1.00  9.59           O
ATOM   1326  C   ASP   167      22.422  22.836  35.605  1.00  8.92           C
ATOM   1327  O   ASP   167      23.338  22.835  36.430  1.00  8.62           O
ATOM   1328  N   PRO   168      22.591  23.215  34.318  1.00  9.32           N
ATOM   1329  CA  PRO   168      21.510  23.299  33.333  1.00  9.33           C
ATOM   1330  CB  PRO   168      22.045  24.310  32.317  1.00  9.51           C
ATOM   1331  CG  PRO   168      23.555  24.122  32.369  1.00 10.10           C
ATOM   1332  CD  PRO   168      23.904  23.495  33.712  1.00  9.20           C
ATOM   1333  C   PRO   168      21.313  21.951  32.672  1.00  9.12           C
ATOM   1334  O   PRO   168      22.095  21.036  32.921  1.00  8.91           O
ATOM   1335  N   PRO   169      20.275  21.826  31.830  1.00  9.05           N
ATOM   1336  CA  PRO   169      19.880  20.539  31.239  1.00  8.86           C
ATOM   1337  CB  PRO   169      18.774  20.932  30.262  1.00  8.62           C
ATOM   1338  CG  PRO   169      18.186  22.178  30.867  1.00  9.71           C
ATOM   1339  CD  PRO   169      19.373  22.917  31.427  1.00  9.23           C
ATOM   1340  C   PRO   169      21.020  19.850  30.489  1.00  8.21           C
ATOM   1341  O   PRO   169      21.704  20.501  29.705  1.00  8.96           O
ATOM   1342  N   GLY   170      21.218  18.561  30.742  1.00  6.31           N
ATOM   1343  CA  GLY   170      22.252  17.784  30.070  1.00  5.80           C
ATOM   1344  C   GLY   170      21.862  17.295  28.677  1.00  5.66           C
ATOM   1345  O   GLY   170      22.621  16.585  28.022  1.00  5.58           O
ATOM   1346  N   ILE   171      20.675  17.679  28.212  1.00  4.95           N
ATOM   1347  CA  ILE   171      20.250  17.331  26.869  1.00  5.59           C
ATOM   1348  CB  ILE   171      19.715  15.892  26.813  1.00  5.67           C
ATOM   1349  CG1 ILE   171      19.618  15.397  25.383  1.00  5.60           C
ATOM   1350  CD1 ILE   171      19.090  14.010  25.321  1.00  7.42           C
ATOM   1351  CG2 ILE   171      18.363  15.780  27.473  1.00  6.75           C
ATOM   1352  C   ILE   171      19.192  18.320  26.388  1.00  5.19           C
ATOM   1353  O   ILE   171      18.526  18.950  27.196  1.00  4.11           O
ATOM   1354  N   ASP   172      19.097  18.494  25.075  1.00  4.97           N
ATOM   1355  CA  ASP   172      18.110  19.393  24.474  1.00  6.12           C
ATOM   1356  CB  ASP   172      18.831  20.532  23.751  1.00  6.06           C
ATOM   1357  CG  ASP   172      17.886  21.393  22.911  1.00 10.18           C
ATOM   1358  OD1 ASP   172      16.647  21.245  23.020  1.00 13.82           O
ATOM   1359  OD2 ASP   172      18.379  22.240  22.143  1.00 12.47           O
ATOM   1360  C   ASP   172      17.299  18.554  23.486  1.00  5.65           C
ATOM   1361  O   ASP   172      17.876  17.916  22.617  1.00  6.36           O
ATOM   1362  N   LEU   173      15.977  18.546  23.630  1.00  5.44           N
ATOM   1363  CA  LEU   173      15.096  17.693  22.834  1.00  4.83           C
ATOM   1364  CB  LEU   173      14.097  16.970  23.740  1.00  4.83           C
ATOM   1365  CG  LEU   173      14.736  16.043  24.769  1.00  3.60           C
ATOM   1366  CD1 LEU   173      13.682  15.251  25.511  1.00  3.57           C
ATOM   1367  CD2 LEU   173      15.671  15.086  24.074  1.00  2.00           C
ATOM   1368  C   LEU   173      14.329  18.473  21.787  1.00  4.66           C
ATOM   1369  O   LEU   173      13.403  17.945  21.168  1.00  4.61           O
ATOM   1370  N   ALA   174      14.751  19.709  21.560  1.00  3.85           N
ATOM   1371  CA  ALA   174      14.048  20.606  20.666  1.00  4.01           C
ATOM   1372  CB  ALA   174      14.635  22.050  20.737  1.00  3.42           C
ATOM   1373  C   ALA   174      13.975  20.109  19.222  1.00  3.45           C
ATOM   1374  O   ALA   174      13.076  20.490  18.512  1.00  3.66           O
ATOM   1375  N   SER   175      14.899  19.266  18.777  1.00  2.95           N
ATOM   1376  CA  SER   175      14.824  18.762  17.396  1.00  2.37           C
ATOM   1377  CB  SER   175      16.187  18.841  16.742  1.00  3.34           C
ATOM   1378  OG  SER   175      16.712  20.149  16.915  1.00  4.22           O
ATOM   1379  C   SER   175      14.295  17.337  17.230  1.00  2.00           C
ATOM   1380  O   SER   175      14.289  16.790  16.112  1.00  2.00           O
ATOM   1381  N   VAL   176      13.870  16.722  18.326  1.00  2.00           N
ATOM   1382  CA  VAL   176      13.402  15.344  18.268  1.00  2.00           C
ATOM   1383  CB  VAL   176      13.076  14.746  19.694  1.00  2.13           C
ATOM   1384  CG1 VAL   176      12.382  13.348  19.597  1.00  2.00           C
ATOM   1385  CG2 VAL   176      14.320  14.621  20.539  1.00  2.00           C
ATOM   1386  C   VAL   176      12.152  15.311  17.395  1.00  2.53           C
ATOM   1387  O   VAL   176      11.166  16.004  17.656  1.00  2.00           O
ATOM   1388  N   GLU   177      12.189  14.499  16.356  1.00  2.40           N
ATOM   1389  CA  GLU   177      11.043  14.375  15.474  1.00  3.02           C
ATOM   1390  CB  GLU   177      11.535  14.368  14.030  1.00  3.09           C
ATOM   1391  CG  GLU   177      12.336  15.590  13.659  1.00  2.88           C
ATOM   1392  CD  GLU   177      12.863  15.540  12.210  1.00  6.49           C
ATOM   1393  OE1 GLU   177      12.427  14.653  11.417  1.00  8.10           O
ATOM   1394  OE2 GLU   177      13.713  16.396  11.870  1.00  5.79           O
ATOM   1395  C   GLU   177      10.274  13.087  15.769  1.00  3.31           C
ATOM   1396  O   GLU   177       9.071  12.987  15.514  1.00  2.97           O
ATOM   1397  N   TRP   178      10.971  12.087  16.302  1.00  4.21           N
ATOM   1398  CA  TRP   178      10.290  10.831  16.649  1.00  4.32           C
ATOM   1399  CB  TRP   178      10.708   9.682  15.691  1.00  3.79           C
ATOM   1400  CG  TRP   178       9.758   9.549  14.506  1.00  3.47           C
ATOM   1401  CD1 TRP   178      10.036   9.811  13.182  1.00  2.59           C
ATOM   1402  NE1 TRP   178       8.902   9.609  12.412  1.00  2.84           N
ATOM   1403  CE2 TRP   178       7.877   9.195  13.227  1.00  2.00           C
ATOM   1404  CD2 TRP   178       8.378   9.145  14.555  1.00  2.00           C
ATOM   1405  CE3 TRP   178       7.525   8.726  15.590  1.00  2.00           C
ATOM   1406  CZ3 TRP   178       6.218   8.391  15.272  1.00  2.99           C
ATOM   1407  CH2 TRP   178       5.751   8.446  13.929  1.00  3.97           C
ATOM   1408  CZ2 TRP   178       6.573   8.824  12.903  1.00  2.00           C
ATOM   1409  C   TRP   178      10.612  10.461  18.086  1.00  4.04           C
ATOM   1410  O   TRP   178      11.774  10.353  18.434  1.00  3.49           O
ATOM   1411  N   LEU   179       9.578  10.248  18.896  1.00  4.24           N
ATOM   1412  CA  LEU   179       9.748   9.723  20.245  1.00  5.21           C
ATOM   1413  CB  LEU   179       9.118  10.669  21.284  1.00  6.21           C
ATOM   1414  CG  LEU   179       9.038  10.281  22.767  1.00  6.16           C
ATOM   1415  CD1 LEU   179      10.432  10.225  23.341  1.00  8.08           C
ATOM   1416  CD2 LEU   179       8.229  11.336  23.507  1.00  7.38           C
ATOM   1417  C   LEU   179       9.079   8.351  20.289  1.00  5.60           C
ATOM   1418  O   LEU   179       7.851   8.224  20.088  1.00  4.36           O
ATOM   1419  N   VAL   180       9.907   7.323  20.469  1.00  4.72           N
ATOM   1420  CA  VAL   180       9.442   5.959  20.423  1.00  4.27           C
ATOM   1421  CB  VAL   180      10.286   5.111  19.432  1.00  4.63           C
ATOM   1422  CG1 VAL   180       9.896   3.636  19.532  1.00  3.54           C
ATOM   1423  CG2 VAL   180      10.113   5.628  17.984  1.00  3.58           C
ATOM   1424  C   VAL   180       9.582   5.333  21.808  1.00  4.59           C
ATOM   1425  O   VAL   180      10.658   5.404  22.421  1.00  3.03           O
ATOM   1426  N   VAL   181       8.489   4.740  22.296  1.00  3.74           N
ATOM   1427  CA  VAL   181       8.516   3.978  23.539  1.00  4.66           C
ATOM   1428  CB  VAL   181       7.414   4.456  24.532  1.00  4.72           C
ATOM   1429  CG1 VAL   181       7.486   3.707  25.845  1.00  5.80           C
ATOM   1430  CG2 VAL   181       7.564   5.961  24.804  1.00  3.26           C
ATOM   1431  C   VAL   181       8.410   2.489  23.195  1.00  5.58           C
ATOM   1432  O   VAL   181       7.422   2.024  22.579  1.00  5.52           O
ATOM   1433  N   ASP   182       9.456   1.753  23.545  1.00  6.03           N
ATOM   1434  CA  ASP   182       9.507   0.329  23.304  1.00  7.74           C
ATOM   1435  CB  ASP   182      10.906  -0.039  22.822  1.00  8.58           C
ATOM   1436  CG  ASP   182      11.008  -1.465  22.274  1.00 10.54           C
ATOM   1437  OD1 ASP   182      10.009  -2.067  21.787  1.00 11.50           O
ATOM   1438  OD2 ASP   182      12.135  -1.974  22.307  1.00 14.04           O
ATOM   1439  C   ASP   182       9.158  -0.399  24.596  1.00  8.09           C
ATOM   1440  O   ASP   182       9.537   0.041  25.690  1.00  8.59           O
ATOM   1441  N   GLU   183       8.435  -1.516  24.471  1.00  8.60           N
ATOM   1442  CA  GLU   183       7.890  -2.244  25.627  1.00  9.16           C
ATOM   1443  CB  GLU   183       9.006  -2.962  26.413  1.00  9.21           C
ATOM   1444  CG  GLU   183       9.852  -3.944  25.567  1.00 10.64           C
ATOM   1445  CD  GLU   183       9.104  -5.229  25.239  1.00 14.44           C
ATOM   1446  OE1 GLU   183       9.014  -6.089  26.130  1.00 15.05           O
ATOM   1447  OE2 GLU   183       8.599  -5.392  24.091  1.00 15.79           O
ATOM   1448  C   GLU   183       7.054  -1.341  26.551  1.00  9.83           C
ATOM   1449  O   GLU   183       7.249  -1.315  27.771  1.00 10.13           O
ATOM   1450  N   SER   184       6.122  -0.607  25.953  1.00 10.57           N
ATOM   1451  CA  SER   184       5.166   0.218  26.675  1.00 11.54           C
ATOM   1452  CB  SER   184       4.189   0.848  25.692  1.00 11.36           C
ATOM   1453  OG  SER   184       4.892   1.489  24.656  1.00 15.74           O
ATOM   1454  C   SER   184       4.344  -0.528  27.724  1.00 12.18           C
ATOM   1455  O   SER   184       4.029   0.032  28.788  1.00 11.97           O
ATOM   1456  N   ASP   185       3.935  -1.755  27.408  1.00 12.39           N
ATOM   1457  CA  ASP   185       3.155  -2.515  28.375  1.00 12.76           C
ATOM   1458  CB  ASP   185       2.746  -3.879  27.829  1.00 12.83           C
ATOM   1459  CG  ASP   185       3.864  -4.577  27.061  1.00 13.81           C
ATOM   1460  OD1 ASP   185       4.009  -5.809  27.247  1.00 15.77           O
ATOM   1461  OD2 ASP   185       4.566  -3.912  26.252  1.00 13.82           O
ATOM   1462  C   ASP   185       3.967  -2.665  29.653  1.00 13.02           C
ATOM   1463  O   ASP   185       3.457  -2.478  30.746  1.00 13.40           O
ATOM   1464  N   LYS   186       5.246  -2.990  29.527  1.00 13.78           N
ATOM   1465  CA  LYS   186       6.053  -3.198  30.727  1.00 14.23           C
ATOM   1466  CB  LYS   186       7.443  -3.752  30.390  1.00 14.24           C
ATOM   1467  CG  LYS   186       7.487  -4.916  29.373  1.00 15.92           C
ATOM   1468  CD  LYS   186       6.760  -6.177  29.846  1.00 17.57           C
ATOM   1469  CE  LYS   186       7.224  -7.427  29.051  1.00 19.17           C
ATOM   1470  NZ  LYS   186       6.857  -7.409  27.575  1.00 18.50           N
ATOM   1471  C   LYS   186       6.172  -1.884  31.499  1.00 14.39           C
ATOM   1472  O   LYS   186       5.892  -1.830  32.687  1.00 14.68           O
ATOM   1473  N   LEU   187       6.584  -0.825  30.810  1.00 14.72           N
ATOM   1474  CA  LEU   187       6.751   0.485  31.417  1.00 15.43           C
ATOM   1475  CB  LEU   187       7.222   1.520  30.368  1.00 14.73           C
ATOM   1476  CG  LEU   187       8.659   1.292  29.849  1.00 14.29           C
ATOM   1477  CD1 LEU   187       8.949   2.051  28.553  1.00 13.90           C
ATOM   1478  CD2 LEU   187       9.698   1.641  30.926  1.00 13.34           C
ATOM   1479  C   LEU   187       5.488   0.979  32.156  1.00 16.62           C
ATOM   1480  O   LEU   187       5.591   1.543  33.234  1.00 15.73           O
ATOM   1481  N   PHE   188       4.305   0.798  31.574  1.00 18.32           N
ATOM   1482  CA  PHE   188       3.091   1.261  32.258  1.00 20.50           C
ATOM   1483  CB  PHE   188       1.887   1.365  31.312  1.00 20.67           C
ATOM   1484  CG  PHE   188       1.959   2.508  30.348  1.00 21.46           C
ATOM   1485  CD1 PHE   188       1.542   3.780  30.724  1.00 23.32           C
ATOM   1486  CE1 PHE   188       1.607   4.848  29.824  1.00 22.90           C
ATOM   1487  CZ  PHE   188       2.081   4.640  28.549  1.00 22.23           C
ATOM   1488  CE2 PHE   188       2.498   3.370  28.164  1.00 23.53           C
ATOM   1489  CD2 PHE   188       2.430   2.314  29.061  1.00 21.49           C
ATOM   1490  C   PHE   188       2.732   0.338  33.416  1.00 21.63           C
ATOM   1491  O   PHE   188       1.770   0.587  34.131  1.00 22.07           O
ATOM   1492  N   GLU   189       3.483  -0.740  33.601  1.00 23.22           N
ATOM   1493  CA  GLU   189       3.156  -1.665  34.694  1.00 24.79           C
ATOM   1494  CB  GLU   189       3.031  -3.101  34.193  1.00 24.76           C
ATOM   1495  CG  GLU   189       2.816  -4.095  35.325  1.00 26.52           C
ATOM   1496  CD  GLU   189       3.397  -5.458  35.019  1.00 27.72           C
ATOM   1497  OE1 GLU   189       3.601  -5.763  33.821  1.00 28.72           O
ATOM   1498  OE2 GLU   189       3.646  -6.220  35.975  1.00 28.44           O
ATOM   1499  C   GLU   189       4.177  -1.627  35.817  1.00 25.36           C
ATOM   1500  O   GLU   189       3.869  -1.998  36.939  1.00 25.41           O
ATOM   1501  N   ASP   190       5.397  -1.202  35.495  1.00 26.50           N
ATOM   1502  CA  ASP   190       6.473  -1.105  36.478  1.00 27.41           C
ATOM   1503  CB  ASP   190       7.848  -1.099  35.794  1.00 27.50           C
ATOM   1507  C   ASP   190       6.292   0.147  37.332  1.00 27.94           C
ATOM   1508  O   ASP   190       6.213   0.057  38.551  1.00 28.15           O
ATOM   1509  N   GLY   191       6.219   1.310  36.686  1.00 28.41           N
ATOM   1510  CA  GLY   191       5.912   2.557  37.392  1.00 28.88           C
ATOM   1511  C   GLY   191       4.454   2.930  37.209  1.00 28.86           C
ATOM   1512  O   GLY   191       3.867   2.656  36.156  1.00 29.00           O
ATOM   1513  N   GLY   194       3.280   7.441  37.532  1.00 13.65           N
ATOM   1514  CA  GLY   194       4.742   7.291  37.628  1.00 14.04           C
ATOM   1515  C   GLY   194       5.459   7.423  36.293  1.00 14.29           C
ATOM   1516  O   GLY   194       6.032   8.465  35.983  1.00 14.10           O
ATOM   1517  N   PHE   195       5.447   6.353  35.498  1.00 14.67           N
ATOM   1518  CA  PHE   195       5.976   6.424  34.145  1.00 14.34           C
ATOM   1519  CB  PHE   195       5.991   5.039  33.477  1.00 14.07           C
ATOM   1520  CG  PHE   195       6.408   5.073  32.031  1.00 14.25           C
ATOM   1521  CD1 PHE   195       7.677   5.490  31.666  1.00 13.19           C
ATOM   1522  CE1 PHE   195       8.044   5.560  30.341  1.00 13.21           C
ATOM   1523  CZ  PHE   195       7.147   5.203  29.359  1.00 14.41           C
ATOM   1524  CE2 PHE   195       5.888   4.796  29.704  1.00 13.00           C
ATOM   1525  CD2 PHE   195       5.521   4.730  31.032  1.00 15.27           C
ATOM   1526  C   PHE   195       5.134   7.431  33.347  1.00 14.51           C
ATOM   1527  O   PHE   195       5.666   8.211  32.546  1.00 14.73           O
ATOM   1528  N   ARG   196       3.825   7.438  33.597  1.00 14.51           N
ATOM   1529  CA  ARG   196       2.907   8.343  32.881  1.00 14.80           C
ATOM   1530  CB  ARG   196       1.464   8.192  33.386  1.00 14.62           C
ATOM   1531  CG  ARG   196       0.747   6.941  32.888  1.00 17.16           C
ATOM   1532  CD  ARG   196      -0.635   6.773  33.559  1.00 20.06           C
ATOM   1533  NE  ARG   196      -0.975   5.358  33.714  1.00 23.74           N
ATOM   1534  CZ  ARG   196      -1.735   4.668  32.864  1.00 25.74           C
ATOM   1535  NH1 ARG   196      -2.250   5.261  31.797  1.00 28.10           N
ATOM   1536  NH2 ARG   196      -1.983   3.384  33.074  1.00 25.54           N
ATOM   1537  C   ARG   196       3.327   9.811  32.987  1.00 14.07           C
ATOM   1538  O   ARG   196       3.251  10.570  32.007  1.00 13.47           O
ATOM   1539  N   ASP   197       3.765  10.200  34.178  1.00 13.40           N
ATOM   1540  CA  ASP   197       4.198  11.571  34.414  1.00 13.44           C
ATOM   1541  CB  ASP   197       4.210  11.892  35.911  1.00 13.83           C
ATOM   1542  CG  ASP   197       2.820  11.896  36.512  1.00 15.53           C
ATOM   1543  OD1 ASP   197       1.844  12.178  35.775  1.00 18.69           O
ATOM   1544  OD2 ASP   197       2.701  11.597  37.715  1.00 17.58           O
ATOM   1545  C   ASP   197       5.557  11.868  33.796  1.00 12.75           C
ATOM   1546  O   ASP   197       5.771  12.969  33.287  1.00 12.41           O
ATOM   1547  N   GLN   198       6.473  10.893  33.845  1.00 12.40           N
ATOM   1548  CA  GLN   198       7.753  11.021  33.164  1.00 12.22           C
ATOM   1549  CB  GLN   198       8.566   9.738  33.315  1.00 12.10           C
ATOM   1550  CG  GLN   198       8.936   9.373  34.740  1.00 13.24           C
ATOM   1551  CD  GLN   198       9.944   8.211  34.794  1.00 14.17           C
ATOM   1552  OE1 GLN   198       9.743   7.171  34.160  1.00 12.65           O
ATOM   1553  NE2 GLN   198      11.030   8.396  35.544  1.00 11.92           N
ATOM   1554  C   GLN   198       7.518  11.297  31.678  1.00 12.38           C
ATOM   1555  O   GLN   198       8.072  12.232  31.095  1.00 12.34           O
ATOM   1556  N   LEU   199       6.698  10.461  31.058  1.00 12.17           N
ATOM   1557  CA  LEU   199       6.424  10.595  29.642  1.00 12.20           C
ATOM   1558  CB  LEU   199       5.543   9.430  29.205  1.00 12.49           C
ATOM   1559  CG  LEU   199       5.421   9.117  27.734  1.00 12.24           C
ATOM   1560  CD1 LEU   199       6.803   8.862  27.202  1.00 13.43           C
ATOM   1561  CD2 LEU   199       4.538   7.882  27.585  1.00 13.51           C
ATOM   1562  C   LEU   199       5.766  11.950  29.319  1.00 12.47           C
ATOM   1563  O   LEU   199       6.000  12.533  28.259  1.00 12.63           O
ATOM   1564  N   ALA   200       4.966  12.472  30.244  1.00 12.20           N
ATOM   1565  CA  ALA   200       4.410  13.800  30.059  1.00 12.43           C
ATOM   1566  CB  ALA   200       3.387  14.137  31.182  1.00 12.39           C
ATOM   1567  C   ALA   200       5.512  14.859  30.010  1.00 12.64           C
ATOM   1568  O   ALA   200       5.482  15.745  29.144  1.00 13.01           O
ATOM   1569  N   SER   201       6.469  14.784  30.939  1.00 12.08           N
ATOM   1570  CA  SER   201       7.543  15.767  30.996  1.00 12.37           C
ATOM   1571  CB  SER   201       8.272  15.725  32.337  1.00 12.50           C
ATOM   1572  OG  SER   201       8.865  14.464  32.527  1.00 15.19           O
ATOM   1573  C   SER   201       8.521  15.595  29.834  1.00 11.84           C
ATOM   1574  O   SER   201       8.949  16.569  29.235  1.00 12.03           O
ATOM   1575  N   ILE   202       8.858  14.364  29.492  1.00 11.64           N
ATOM   1576  CA  ILE   202       9.593  14.149  28.250  1.00 11.50           C
ATOM   1577  CB  ILE   202       9.883  12.661  27.987  1.00 10.98           C
ATOM   1578  CG1 ILE   202      10.881  12.131  29.032  1.00 10.77           C
ATOM   1579  CD1 ILE   202      10.783  10.603  29.318  1.00  8.30           C
ATOM   1580  CG2 ILE   202      10.451  12.473  26.573  1.00 11.35           C
ATOM   1581  C   ILE   202       8.880  14.814  27.051  1.00 11.56           C
ATOM   1582  O   ILE   202       9.453  15.672  26.385  1.00 11.84           O
ATOM   1583  N   PHE   203       7.635  14.441  26.787  1.00 11.93           N
ATOM   1584  CA  PHE   203       6.965  14.996  25.624  0.50 11.94           C
ATOM   1586  CB  PHE   203       5.571  14.404  25.461  0.50 11.71           C
ATOM   1588  CG  PHE   203       4.848  14.874  24.230  0.50 11.88           C
ATOM   1590  CD1 PHE   203       5.389  14.667  22.969  0.50 10.91           C
ATOM   1592  CE1 PHE   203       4.725  15.090  21.847  0.50 10.71           C
ATOM   1594  CZ  PHE   203       3.499  15.724  21.965  0.50  9.98           C
ATOM   1596  CE2 PHE   203       2.948  15.928  23.210  0.50 10.17           C
ATOM   1598  CD2 PHE   203       3.617  15.502  24.335  0.50  9.43           C
ATOM   1600  C   PHE   203       6.934  16.521  25.692  1.00 12.32           C
ATOM   1601  O   PHE   203       7.109  17.177  24.664  1.00 12.57           O
ATOM   1602  N   LEU   204       6.748  17.079  26.886  1.00 12.06           N
ATOM   1603  CA  LEU   204       6.676  18.536  27.017  1.00 11.46           C
ATOM   1604  CB  LEU   204       6.340  18.939  28.456  1.00 11.75           C
ATOM   1605  CG  LEU   204       6.267  20.424  28.832  1.00 11.35           C
ATOM   1606  CD1 LEU   204       5.007  21.076  28.246  1.00 12.68           C
ATOM   1607  CD2 LEU   204       6.305  20.559  30.360  1.00  9.95           C
ATOM   1608  C   LEU   204       7.983  19.171  26.568  1.00 10.99           C
ATOM   1609  O   LEU   204       7.980  20.273  26.045  1.00  9.86           O
ATOM   1610  N   ALA   205       9.093  18.444  26.743  1.00 10.33           N
ATOM   1611  CA  ALA   205      10.423  18.951  26.374  1.00  9.39           C
ATOM   1612  CB  ALA   205      11.479  18.195  27.157  1.00  8.99           C
ATOM   1613  C   ALA   205      10.690  18.866  24.843  1.00  9.23           C
ATOM   1614  O   ALA   205      11.560  19.564  24.288  1.00  7.95           O
ATOM   1615  N   CYS   206       9.931  18.004  24.174  1.00  8.66           N
ATOM   1616  CA  CYS   206      10.042  17.784  22.743  1.00  8.14           C
ATOM   1617  CB  CYS   206       9.561  16.367  22.408  1.00  8.61           C
ATOM   1618  SG  CYS   206      10.609  15.008  22.963  1.00  7.47           S
ATOM   1619  C   CYS   206       9.174  18.775  21.971  1.00  8.69           C
ATOM   1620  O   CYS   206       8.042  18.450  21.608  1.00  8.50           O
ATOM   1621  N   THR   207       9.727  19.955  21.687  1.00  8.50           N
ATOM   1622  CA  THR   207       8.957  21.096  21.239  1.00  8.61           C
ATOM   1623  CB  THR   207       9.537  22.436  21.809  1.00  9.24           C
ATOM   1624  OG1 THR   207      10.972  22.399  21.770  1.00  8.99           O
ATOM   1625  CG2 THR   207       9.056  22.698  23.262  1.00  9.22           C
ATOM   1626  C   THR   207       8.962  21.248  19.721  1.00  7.85           C
ATOM   1627  O   THR   207       8.432  22.208  19.209  1.00  7.52           O
ATOM   1628  N   SER   208       9.587  20.317  19.005  1.00  6.77           N
ATOM   1629  CA  SER   208       9.620  20.407  17.541  1.00  5.87           C
ATOM   1630  CB  SER   208      10.397  19.230  16.935  1.00  5.73           C
ATOM   1631  OG  SER   208      10.199  19.169  15.524  1.00  6.44           O
ATOM   1632  C   SER   208       8.219  20.394  16.966  1.00  5.58           C
ATOM   1633  O   SER   208       7.373  19.582  17.373  1.00  5.60           O
ATOM   1634  N   HIS   209       7.983  21.254  15.988  1.00  5.81           N
ATOM   1635  CA  HIS   209       6.730  21.244  15.258  1.00  6.57           C
ATOM   1636  CB  HIS   209       6.696  22.373  14.210  1.00  7.29           C
ATOM   1637  CG  HIS   209       7.680  22.206  13.087  1.00  8.13           C
ATOM   1638  ND1 HIS   209       7.304  21.805  11.820  1.00 10.61           N
ATOM   1639  CE1 HIS   209       8.373  21.746  11.041  1.00 10.03           C
ATOM   1640  NE2 HIS   209       9.426  22.104  11.755  1.00  9.86           N
ATOM   1641  CD2 HIS   209       9.019  22.404  13.034  1.00  8.52           C
ATOM   1642  C   HIS   209       6.517  19.895  14.591  1.00  6.78           C
ATOM   1643  O   HIS   209       5.392  19.545  14.240  1.00  6.70           O
ATOM   1644  N   LYS   210       7.593  19.119  14.449  1.00  5.95           N
ATOM   1645  CA  LYS   210       7.508  17.858  13.718  1.00  6.38           C
ATOM   1646  CB  LYS   210       8.816  17.559  12.956  1.00  6.79           C
ATOM   1647  CG  LYS   210       9.243  18.475  11.827  1.00  7.73           C
ATOM   1648  CD  LYS   210      10.190  17.692  10.897  1.00 11.94           C
ATOM   1649  CE  LYS   210      10.743  18.551   9.744  1.00 14.22           C
ATOM   1650  NZ  LYS   210      12.176  18.933   9.962  1.00 15.72           N
ATOM   1651  C   LYS   210       7.273  16.622  14.603  1.00  5.72           C
ATOM   1652  O   LYS   210       7.110  15.534  14.060  1.00  4.45           O
ATOM   1653  N   VAL   211       7.293  16.773  15.930  1.00  5.05           N
ATOM   1654  CA  VAL   211       7.372  15.593  16.802  1.00  5.54           C
ATOM   1655  CB  VAL   211       7.568  15.963  18.279  1.00  5.85           C
ATOM   1656  CG1 VAL   211       6.302  16.700  18.848  1.00  4.88           C
ATOM   1657  CG2 VAL   211       7.953  14.708  19.085  1.00  7.06           C
ATOM   1658  C   VAL   211       6.190  14.635  16.621  1.00  6.08           C
ATOM   1659  O   VAL   211       5.033  15.047  16.528  1.00  5.71           O
ATOM   1660  N   ARG   212       6.495  13.353  16.489  1.00  6.25           N
ATOM   1661  CA  ARG   212       5.447  12.346  16.499  1.00  6.87           C
ATOM   1662  CB  ARG   212       5.242  11.738  15.099  1.00  6.95           C
ATOM   1663  CG  ARG   212       4.868  12.782  14.018  1.00  7.15           C
ATOM   1664  CD  ARG   212       3.486  13.385  14.336  1.00  9.91           C
ATOM   1665  NE  ARG   212       3.017  14.177  13.223  1.00 13.37           N
ATOM   1666  CZ  ARG   212       3.284  15.470  13.067  1.00 18.86           C
ATOM   1667  NH1 ARG   212       4.011  16.113  13.968  1.00 20.13           N
ATOM   1668  NH2 ARG   212       2.814  16.128  12.019  1.00 20.40           N
ATOM   1669  C   ARG   212       5.830  11.277  17.499  1.00  7.01           C
ATOM   1670  O   ARG   212       7.002  11.097  17.763  1.00  6.38           O
ATOM   1671  N   ARG   213       4.834  10.582  18.040  1.00  6.71           N
ATOM   1672  CA  ARG   213       5.040   9.531  19.041  1.00  7.05           C
ATOM   1673  CB  ARG   213       4.278   9.874  20.347  1.00  6.81           C
ATOM   1674  CG  ARG   213       4.856  11.085  21.094  1.00  8.21           C
ATOM   1675  CD  ARG   213       3.899  11.702  22.059  1.00 12.29           C
ATOM   1676  NE  ARG   213       2.776  12.327  21.355  1.00 16.12           N
ATOM   1677  CZ  ARG   213       1.762  12.954  21.961  1.00 17.02           C
ATOM   1678  NH1 ARG   213       1.721  13.033  23.294  1.00 14.75           N
ATOM   1679  NH2 ARG   213       0.773  13.482  21.231  1.00 12.42           N
ATOM   1680  C   ARG   213       4.581   8.160  18.539  1.00  7.44           C
ATOM   1681  O   ARG   213       3.526   8.013  17.892  1.00  7.88           O
ATOM   1682  N   ALA   214       5.343   7.144  18.880  1.00  6.79           N
ATOM   1683  CA  ALA   214       4.918   5.798  18.563  1.00  6.25           C
ATOM   1684  CB  ALA   214       5.749   5.257  17.391  1.00  4.60           C
ATOM   1685  C   ALA   214       5.129   4.970  19.809  1.00  6.08           C
ATOM   1686  O   ALA   214       6.212   5.025  20.421  1.00  6.74           O
ATOM   1687  N   MET   215       4.102   4.213  20.206  1.00  5.11           N
ATOM   1688  CA  MET   215       4.236   3.318  21.332  1.00  5.53           C
ATOM   1689  CB  MET   215       3.099   3.502  22.325  1.00  5.46           C
ATOM   1690  CG  MET   215       2.756   4.944  22.683  1.00  8.94           C
ATOM   1691  SD  MET   215       4.000   5.739  23.717  1.00 12.43           S
ATOM   1692  CE  MET   215       3.548   5.088  25.322  1.00  9.43           C
ATOM   1693  C   MET   215       4.230   1.858  20.861  1.00  5.58           C
ATOM   1694  O   MET   215       3.277   1.415  20.217  1.00  5.62           O
ATOM   1695  N   PHE   216       5.268   1.118  21.224  1.00  4.63           N
ATOM   1696  CA  PHE   216       5.381  -0.282  20.899  1.00  4.89           C
ATOM   1697  CB  PHE   216       6.727  -0.559  20.202  1.00  4.64           C
ATOM   1698  CG  PHE   216       6.734  -0.172  18.746  1.00  4.39           C
ATOM   1699  CD1 PHE   216       6.676  -1.146  17.750  1.00  2.00           C
ATOM   1700  CE1 PHE   216       6.659  -0.786  16.377  1.00  2.00           C
ATOM   1701  CZ  PHE   216       6.718   0.554  16.029  1.00  2.00           C
ATOM   1702  CE2 PHE   216       6.765   1.543  17.014  1.00  2.00           C
ATOM   1703  CD2 PHE   216       6.778   1.176  18.372  1.00  4.24           C
ATOM   1704  C   PHE   216       5.228  -1.110  22.178  1.00  5.74           C
ATOM   1705  O   PHE   216       5.722  -0.727  23.245  1.00  6.17           O
ATOM   1706  N   SER   217       4.515  -2.222  22.068  1.00  5.46           N
ATOM   1707  CA  SER   217       4.262  -3.076  23.216  0.50  6.34           C
ATOM   1709  CB  SER   217       2.971  -2.670  23.906  0.50  6.10           C
ATOM   1711  OG  SER   217       1.890  -2.925  23.039  0.50  7.75           O
ATOM   1713  C   SER   217       4.143  -4.524  22.776  1.00  6.59           C
ATOM   1714  O   SER   217       3.816  -4.815  21.618  1.00  5.80           O
ATOM   1715  N   ALA   218       4.422  -5.436  23.704  1.00  7.17           N
ATOM   1716  CA  ALA   218       4.335  -6.854  23.398  1.00  9.39           C
ATOM   1717  CB  ALA   218       5.139  -7.677  24.397  1.00  9.06           C
ATOM   1718  C   ALA   218       2.886  -7.315  23.390  1.00 11.47           C
ATOM   1719  O   ALA   218       2.525  -8.250  22.674  1.00 12.22           O
ATOM   1720  N   THR   219       2.056  -6.676  24.197  1.00 13.13           N
ATOM   1721  CA  THR   219       0.703  -7.144  24.372  1.00 15.75           C
ATOM   1722  CB  THR   219       0.460  -7.633  25.803  1.00 16.00           C
ATOM   1723  OG1 THR   219       0.714  -6.555  26.712  1.00 15.79           O
ATOM   1724  CG2 THR   219       1.352  -8.830  26.155  1.00 16.51           C
ATOM   1725  C   THR   219      -0.252  -5.991  24.172  1.00 17.61           C
ATOM   1726  O   THR   219       0.005  -4.871  24.629  1.00 17.37           O
ATOM   1727  N   PHE   220      -1.381  -6.281  23.537  1.00 19.65           N
ATOM   1728  CA  PHE   220      -2.409  -5.277  23.323  1.00 21.75           C
ATOM   1729  CB  PHE   220      -3.269  -5.662  22.099  1.00 22.32           C
ATOM   1730  CG  PHE   220      -4.248  -4.592  21.653  1.00 25.67           C
ATOM   1731  CD1 PHE   220      -3.857  -3.253  21.481  1.00 27.90           C
ATOM   1732  CE1 PHE   220      -4.765  -2.286  21.056  1.00 29.11           C
ATOM   1733  CZ  PHE   220      -6.073  -2.651  20.768  1.00 29.43           C
ATOM   1734  CE2 PHE   220      -6.469  -3.975  20.914  1.00 29.06           C
ATOM   1735  CD2 PHE   220      -5.558  -4.938  21.345  1.00 27.95           C
ATOM   1736  C   PHE   220      -3.236  -5.075  24.604  1.00 22.23           C
ATOM   1737  O   PHE   220      -4.224  -5.791  24.843  1.00 22.55           O
ATOM   1738  N   ALA   221      -2.800  -4.099  25.420  1.00 22.77           N
ATOM   1739  CA  ALA   221      -3.206  -3.919  26.834  1.00 23.15           C
ATOM   1740  CB  ALA   221      -1.987  -3.967  27.735  1.00 23.36           C
ATOM   1741  C   ALA   221      -3.995  -2.643  27.128  1.00 23.64           C
ATOM   1742  O   ALA   221      -3.836  -1.633  26.437  1.00 24.08           O
ATOM   1743  N   TYR   222      -4.778  -2.676  28.213  1.00 23.88           N
ATOM   1744  CA  TYR   222      -5.899  -1.747  28.409  1.00 23.76           C
ATOM   1745  CB  TYR   222      -6.852  -2.219  29.525  1.00 23.84           C
ATOM   1746  CG  TYR   222      -8.114  -1.373  29.611  1.00 22.95           C
ATOM   1747  CD1 TYR   222      -8.362  -0.553  30.706  1.00 21.11           C
ATOM   1748  CE1 TYR   222      -9.505   0.234  30.764  1.00 20.73           C
ATOM   1749  CZ  TYR   222     -10.405   0.210  29.706  1.00 21.43           C
ATOM   1750  OH  TYR   222     -11.558   0.970  29.733  1.00 21.30           O
ATOM   1751  CE2 TYR   222     -10.167  -0.588  28.612  1.00 21.07           C
ATOM   1752  CD2 TYR   222      -9.035  -1.368  28.568  1.00 22.41           C
ATOM   1753  C   TYR   222      -5.536  -0.274  28.604  1.00 23.93           C
ATOM   1754  O   TYR   222      -6.041   0.587  27.871  1.00 23.70           O
ATOM   1755  N   ASP   223      -4.667   0.010  29.573  1.00 23.89           N
ATOM   1756  CA  ASP   223      -4.299   1.390  29.899  1.00 23.93           C
ATOM   1757  CB  ASP   223      -3.867   1.480  31.354  1.00 24.12           C
ATOM   1758  CG  ASP   223      -4.913   0.940  32.289  1.00 25.07           C
ATOM   1759  OD1 ASP   223      -5.890   0.337  31.786  1.00 26.45           O
ATOM   1760  OD2 ASP   223      -4.766   1.112  33.514  1.00 26.55           O
ATOM   1761  C   ASP   223      -3.218   1.970  28.989  1.00 23.63           C
ATOM   1762  O   ASP   223      -2.873   3.151  29.085  1.00 24.03           O
ATOM   1763  N   VAL   224      -2.654   1.130  28.133  1.00 23.23           N
ATOM   1764  CA  VAL   224      -1.780   1.621  27.078  1.00 22.54           C
ATOM   1765  CB  VAL   224      -0.801   0.530  26.574  1.00 22.68           C
ATOM   1766  CG1 VAL   224      -0.116   0.972  25.282  1.00 22.70           C
ATOM   1767  CG2 VAL   224       0.231   0.192  27.650  1.00 21.90           C
ATOM   1768  C   VAL   224      -2.725   2.025  25.959  1.00 22.12           C
ATOM   1769  O   VAL   224      -2.613   3.108  25.397  1.00 21.74           O
ATOM   1770  N   GLU   225      -3.683   1.156  25.657  1.00 21.44           N
ATOM   1771  CA  GLU   225      -4.665   1.496  24.659  1.00 21.09           C
ATOM   1772  CB  GLU   225      -5.676   0.372  24.484  1.00 21.13           C
ATOM   1773  CG  GLU   225      -6.498   0.482  23.211  1.00 22.03           C
ATOM   1777  C   GLU   225      -5.356   2.814  25.024  1.00 20.98           C
ATOM   1778  O   GLU   225      -5.438   3.701  24.184  1.00 20.36           O
ATOM   1779  N   GLN   226      -5.844   2.940  26.269  1.00 20.87           N
ATOM   1780  CA  GLN   226      -6.664   4.097  26.658  1.00 20.84           C
ATOM   1781  CB  GLN   226      -7.444   3.858  27.961  1.00 21.10           C
ATOM   1782  CG  GLN   226      -8.284   2.562  28.033  1.00 22.57           C
ATOM   1783  CD  GLN   226      -9.060   2.263  26.755  1.00 24.68           C
ATOM   1784  OE1 GLN   226      -9.809   3.104  26.254  1.00 25.31           O
ATOM   1785  NE2 GLN   226      -8.887   1.052  26.229  1.00 24.97           N
ATOM   1786  C   GLN   226      -5.814   5.344  26.817  1.00 20.54           C
ATOM   1787  O   GLN   226      -6.284   6.451  26.583  1.00 20.01           O
ATOM   1788  N   TRP   227      -4.564   5.158  27.233  1.00 20.27           N
ATOM   1789  CA  TRP   227      -3.615   6.260  27.325  1.00 20.01           C
ATOM   1790  CB  TRP   227      -2.295   5.772  27.915  1.00 19.94           C
ATOM   1791  CG  TRP   227      -1.322   6.886  28.125  1.00 19.70           C
ATOM   1792  CD1 TRP   227      -1.138   7.609  29.273  1.00 18.72           C
ATOM   1793  NE1 TRP   227      -0.162   8.558  29.074  1.00 20.06           N
ATOM   1794  CE2 TRP   227       0.300   8.463  27.785  1.00 19.66           C
ATOM   1795  CD2 TRP   227      -0.410   7.423  27.157  1.00 18.96           C
ATOM   1796  CE3 TRP   227      -0.130   7.127  25.819  1.00 18.76           C
ATOM   1797  CZ3 TRP   227       0.832   7.861  25.160  1.00 19.10           C
ATOM   1798  CH2 TRP   227       1.530   8.890  25.812  1.00 20.17           C
ATOM   1799  CZ2 TRP   227       1.278   9.204  27.121  1.00 20.71           C
ATOM   1800  C   TRP   227      -3.356   6.873  25.954  1.00 19.96           C
ATOM   1801  O   TRP   227      -3.308   8.094  25.807  1.00 20.42           O
ATOM   1802  N   CYS   228      -3.176   6.013  24.954  1.00 19.31           N
ATOM   1803  CA  CYS   228      -2.920   6.445  23.593  1.00 18.95           C
ATOM   1804  CB  CYS   228      -2.504   5.252  22.741  1.00 19.03           C
ATOM   1805  SG  CYS   228      -0.861   4.603  23.147  1.00 19.79           S
ATOM   1806  C   CYS   228      -4.119   7.132  22.939  1.00 18.92           C
ATOM   1807  O   CYS   228      -3.968   8.178  22.327  1.00 18.65           O
ATOM   1808  N   LYS   229      -5.302   6.536  23.055  1.00 18.56           N
ATOM   1809  CA  LYS   229      -6.505   7.127  22.486  1.00 18.76           C
ATOM   1810  CB  LYS   229      -7.734   6.230  22.716  1.00 19.36           C
ATOM   1811  CG  LYS   229      -7.663   4.852  22.059  1.00 21.21           C
ATOM   1812  CD  LYS   229      -7.392   4.929  20.565  1.00 23.63           C
ATOM   1813  CE  LYS   229      -7.177   3.540  19.966  1.00 25.76           C
ATOM   1814  NZ  LYS   229      -6.805   3.585  18.506  1.00 27.82           N
ATOM   1815  C   LYS   229      -6.749   8.497  23.101  1.00 18.28           C
ATOM   1816  O   LYS   229      -7.415   9.350  22.511  1.00 18.13           O
ATOM   1817  N   LEU   230      -6.204   8.686  24.297  1.00 17.51           N
ATOM   1818  CA  LEU   230      -6.429   9.882  25.085  1.00 16.44           C
ATOM   1819  CB  LEU   230      -6.469   9.507  26.565  1.00 16.68           C
ATOM   1820  CG  LEU   230      -6.671  10.597  27.622  1.00 17.29           C
ATOM   1821  CD1 LEU   230      -7.998  11.361  27.431  1.00 15.25           C
ATOM   1822  CD2 LEU   230      -6.575  10.007  29.036  1.00 16.30           C
ATOM   1823  C   LEU   230      -5.338  10.918  24.870  1.00 16.41           C
ATOM   1824  O   LEU   230      -5.627  12.113  24.847  1.00 15.62           O
ATOM   1825  N   ASN   231      -4.086  10.455  24.726  1.00 15.18           N
ATOM   1826  CA  ASN   231      -2.936  11.358  24.616  1.00 15.10           C
ATOM   1827  CB  ASN   231      -1.780  10.908  25.524  1.00 15.20           C
ATOM   1828  CG  ASN   231      -2.118  11.024  26.989  1.00 16.40           C
ATOM   1829  OD1 ASN   231      -1.876  12.050  27.600  1.00 19.89           O
ATOM   1830  ND2 ASN   231      -2.699   9.980  27.556  1.00 16.14           N
ATOM   1831  C   ASN   231      -2.388  11.572  23.211  1.00 14.43           C
ATOM   1832  O   ASN   231      -1.910  12.649  22.886  1.00 14.38           O
ATOM   1833  N   LEU   232      -2.427  10.548  22.376  1.00 13.75           N
ATOM   1834  CA  LEU   232      -1.818  10.675  21.068  1.00 13.37           C
ATOM   1835  CB  LEU   232      -1.364   9.307  20.553  1.00 13.33           C
ATOM   1836  CG  LEU   232      -0.354   8.650  21.496  1.00 14.58           C
ATOM   1837  CD1 LEU   232       0.263   7.332  20.959  1.00 13.39           C
ATOM   1838  CD2 LEU   232       0.744   9.642  21.859  1.00 13.48           C
ATOM   1839  C   LEU   232      -2.818  11.348  20.129  1.00 13.09           C
ATOM   1840  O   LEU   232      -4.015  11.348  20.384  1.00 12.53           O
ATOM   1841  N   ASP   233      -2.319  11.945  19.058  1.00 12.29           N
ATOM   1842  CA  ASP   233      -3.169  12.669  18.146  1.00 12.14           C
ATOM   1843  CB  ASP   233      -2.389  13.850  17.580  1.00 12.64           C
ATOM   1844  CG  ASP   233      -3.134  14.554  16.480  1.00 16.19           C
ATOM   1845  OD1 ASP   233      -4.346  14.788  16.653  1.00 18.48           O
ATOM   1846  OD2 ASP   233      -2.510  14.879  15.441  1.00 21.07           O
ATOM   1847  C   ASP   233      -3.597  11.748  17.008  1.00 10.84           C
ATOM   1848  O   ASP   233      -2.756  11.236  16.292  1.00  9.89           O
ATOM   1849  N   ASN   234      -4.898  11.546  16.836  1.00 10.24           N
ATOM   1850  CA  ASN   234      -5.405  10.779  15.685  1.00  9.30           C
ATOM   1851  CB  ASN   234      -5.152  11.575  14.396  1.00  9.66           C
ATOM   1852  CG  ASN   234      -6.078  11.181  13.249  1.00 11.52           C
ATOM   1853  OD1 ASN   234      -7.079  10.490  13.444  1.00 13.90           O
ATOM   1854  ND2 ASN   234      -5.742  11.635  12.035  1.00 10.14           N
ATOM   1855  C   ASN   234      -4.697   9.433  15.603  1.00  8.61           C
ATOM   1856  O   ASN   234      -4.295   9.007  14.540  1.00  8.68           O
ATOM   1857  N   VAL   235      -4.566   8.742  16.721  1.00  7.61           N
ATOM   1858  CA  VAL   235      -3.765   7.516  16.741  1.00  7.11           C
ATOM   1859  CB  VAL   235      -3.617   6.954  18.179  1.00  6.87           C
ATOM   1860  CG1 VAL   235      -4.926   6.281  18.651  1.00  7.79           C
ATOM   1861  CG2 VAL   235      -2.433   6.008  18.249  1.00  8.36           C
ATOM   1862  C   VAL   235      -4.228   6.397  15.780  1.00  6.32           C
ATOM   1863  O   VAL   235      -5.420   6.234  15.469  1.00  6.31           O
ATOM   1864  N   ILE   236      -3.259   5.649  15.279  1.00  4.55           N
ATOM   1865  CA  ILE   236      -3.546   4.446  14.536  1.00  3.33           C
ATOM   1866  CB  ILE   236      -2.837   4.470  13.165  1.00  2.95           C
ATOM   1867  CG1 ILE   236      -3.664   5.300  12.160  1.00  2.46           C
ATOM   1868  CD1 ILE   236      -2.974   5.455  10.825  1.00  2.00           C
ATOM   1869  CG2 ILE   236      -2.662   3.047  12.585  1.00  2.09           C
ATOM   1870  C   ILE   236      -3.080   3.279  15.408  1.00  2.76           C
ATOM   1871  O   ILE   236      -1.957   3.284  15.893  1.00  2.00           O
ATOM   1872  N   SER   237      -3.951   2.309  15.658  1.00  2.17           N
ATOM   1873  CA  SER   237      -3.561   1.124  16.410  0.50  2.36           C
ATOM   1875  CB  SER   237      -4.639   0.748  17.432  0.50  2.26           C
ATOM   1877  OG  SER   237      -4.774   1.743  18.432  0.50  3.72           O
ATOM   1879  C   SER   237      -3.319  -0.046  15.458  1.00  2.07           C
ATOM   1880  O   SER   237      -4.172  -0.361  14.637  1.00  2.41           O
ATOM   1881  N   VAL   238      -2.169  -0.693  15.576  1.00  2.00           N
ATOM   1882  CA  VAL   238      -1.904  -1.903  14.802  1.00  2.00           C
ATOM   1883  CB  VAL   238      -0.658  -1.761  13.899  1.00  2.00           C
ATOM   1884  CG1 VAL   238      -0.567  -2.949  12.933  1.00  2.00           C
ATOM   1885  CG2 VAL   238      -0.641  -0.414  13.145  1.00  2.00           C
ATOM   1886  C   VAL   238      -1.579  -2.991  15.804  1.00  2.00           C
ATOM   1887  O   VAL   238      -0.754  -2.789  16.712  1.00  2.00           O
ATOM   1888  N   SER   239      -2.214  -4.145  15.649  1.00  2.00           N
ATOM   1889  CA  SER   239      -1.970  -5.273  16.524  1.00  2.34           C
ATOM   1890  CB  SER   239      -3.114  -5.366  17.533  1.00  2.00           C
ATOM   1891  OG  SER   239      -2.943  -6.508  18.344  1.00  6.75           O
ATOM   1892  C   SER   239      -1.921  -6.548  15.658  1.00  2.00           C
ATOM   1893  O   SER   239      -2.731  -6.687  14.745  1.00  2.00           O
ATOM   1894  N   ILE   240      -0.966  -7.442  15.925  1.00  2.00           N
ATOM   1895  CA  ILE   240      -0.873  -8.715  15.206  1.00  2.00           C
ATOM   1896  CB  ILE   240       0.595  -9.118  14.933  1.00  2.16           C
ATOM   1897  CG1 ILE   240       1.417  -7.921  14.411  1.00  2.00           C
ATOM   1898  CD1 ILE   240       0.949  -7.394  13.061  1.00  2.00           C
ATOM   1899  CG2 ILE   240       0.656 -10.318  13.958  1.00  2.00           C
ATOM   1900  C   ILE   240      -1.531  -9.835  16.014  1.00  2.82           C
ATOM   1901  O   ILE   240      -1.113 -10.118  17.139  1.00  2.41           O
ATOM   1902  N   GLY   241      -2.549 -10.469  15.440  1.00  4.28           N
ATOM   1903  CA  GLY   241      -3.271 -11.528  16.131  1.00  5.85           C
ATOM   1904  C   GLY   241      -2.385 -12.757  16.158  1.00  7.38           C
ATOM   1905  O   GLY   241      -1.456 -12.859  15.349  1.00  7.69           O
ATOM   1906  N   ALA   242      -2.657 -13.683  17.082  1.00  8.07           N
ATOM   1907  CA  ALA   242      -1.779 -14.844  17.290  1.00  8.80           C
ATOM   1908  CB  ALA   242      -2.010 -15.465  18.671  1.00  8.95           C
ATOM   1909  C   ALA   242      -2.025 -15.864  16.210  1.00  8.74           C
ATOM   1910  O   ALA   242      -3.069 -15.819  15.578  1.00  9.49           O
END
