
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  139 ( 1104),  selected  139 , name 1jkg_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 1jkg_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    D     5_A      -       -           -
LGA    F     6_A      -       -           -
LGA    K     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    Y     9_A      -       -           -
LGA    V    10_A      -       -           -
LGA    D    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    A    13_A      N       2          1.127
LGA    C    14_A      -       -           -
LGA    R    15_A      S       3          2.664
LGA    A    16_A      E       4          3.086
LGA    A    17_A      I       5          3.804
LGA    E    18_A      E       6          3.648
LGA    E    19_A      L       7          3.480
LGA    F    20_A      P       8          2.950
LGA    V    21_A      V       9          2.596
LGA    N    22_A      Q      10          2.038
LGA    V    23_A      K      11          0.482
LGA    Y    24_A      Q      12          1.075
LGA    Y    25_A      L      13          0.905
LGA    T    26_A      E      14          1.077
LGA    T    27_A      A      15          1.160
LGA    M    28_A      Y      16          1.506
LGA    D    29_A      N      17          1.715
LGA    K    30_A      A      18          1.651
LGA    -       -      R      19           -
LGA    R    31_A      D      20          0.896
LGA    R    32_A      I      21          2.898
LGA    R    33_A      D      22          4.771
LGA    L    34_A      A      23          4.022
LGA    L    35_A      F      24          1.835
LGA    S    36_A      M      25          2.175
LGA    R    37_A      A      26          2.371
LGA    L    38_A      W      27          2.176
LGA    Y    39_A      W      28          1.291
LGA    M    40_A      A      29          0.545
LGA    G    41_A      D      30          1.085
LGA    T    42_A      D      31          0.943
LGA    A    43_A      C      32          0.630
LGA    T    44_A      Q      33          1.001
LGA    L    45_A      Y      34          0.797
LGA    V    46_A      Y      35          0.798
LGA    W    47_A      A      36          2.226
LGA    N    48_A      F      37          2.955
LGA    G    49_A      P      38          4.208
LGA    -       -      A      39           -
LGA    N    50_A      T      40          3.667
LGA    A    51_A      L      41          1.623
LGA    V    52_A      L      42          2.003
LGA    S    53_A      A      43          2.233
LGA    -       -      G      44           -
LGA    G    54_A      N      45          1.083
LGA    Q    55_A      A      46          1.175
LGA    E    56_A      A      47          1.348
LGA    S    57_A      E      48          1.087
LGA    L    58_A      I      49          1.173
LGA    S    59_A      R      50          1.896
LGA    E    60_A      V      51          1.460
LGA    F    61_A      R      52          0.762
LGA    F    62_A      H      53          1.237
LGA    E    63_A      I      54          1.130
LGA    M    64_A      E      55          1.723
LGA    L    65_A      R      56          1.764
LGA    P    66_A      F      57          4.294
LGA    -       -      K      58           -
LGA    S    67_A      E      59          3.559
LGA    -       -      P      60           -
LGA    -       -      D      61           -
LGA    S    68_A      L      62          2.435
LGA    E    69_A      Y      63          1.061
LGA    F    70_A      G      64          1.214
LGA    Q    71_A      E      65          1.656
LGA    I    72_A      L      66          1.572
LGA    S    73_A      L      67          2.242
LGA    V    74_A      T      68          1.678
LGA    V    75_A      R      69          1.660
LGA    D    76_A      V      70          1.584
LGA    C    77_A      I      71          1.478
LGA    Q    78_A      V      72          2.256
LGA    P    79_A      G      73          2.251
LGA    V    80_A      -       -           -
LGA    H    81_A      -       -           -
LGA    D    82_A      -       -           -
LGA    E    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    T    85_A      -       -           -
LGA    P    86_A      -       -           -
LGA    S    87_A      -       -           -
LGA    Q    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    T    90_A      -       -           -
LGA    V    91_A      N      74          0.680
LGA    L    92_A      V      75          1.074
LGA    V    93_A      V      76          1.109
LGA    V    94_A      I      77          1.532
LGA    I    95_A      D      78          2.150
LGA    C    96_A      H      79          1.542
LGA    G    97_A      E      80          2.377
LGA    S    98_A      T      81          1.279
LGA    V    99_A      V      82          1.496
LGA    K   100_A      T      83          1.125
LGA    F   101_A      R      84          2.996
LGA    E   102_A      N      85          4.951
LGA    G   103_A      F      86          5.462
LGA    N   104_A      P      87           #
LGA    -       -      E      88           -
LGA    -       -      G      89           -
LGA    -       -      K      90           -
LGA    K   105_A      G      91          0.789
LGA    Q   106_A      E      92          0.869
LGA    R   107_A      V      93          1.497
LGA    D   108_A      D      94          0.688
LGA    F   109_A      V      95          0.937
LGA    N   110_A      A      96          0.757
LGA    Q   111_A      C      97          1.439
LGA    N   112_A      I      98          0.842
LGA    F   113_A      Y      99          0.952
LGA    I   114_A      E     100          0.516
LGA    L   115_A      V     101          0.712
LGA    T   116_A      E     102          1.728
LGA    A   117_A      N     103          2.762
LGA    Q   118_A      -       -           -
LGA    A   119_A      -       -           -
LGA    S   120_A      -       -           -
LGA    P   121_A      -       -           -
LGA    S   122_A      -       -           -
LGA    N   123_A      -       -           -
LGA    T   124_A      -       -           -
LGA    V   125_A      -       -           -
LGA    W   126_A      G     104          2.569
LGA    K   127_A      R     105          1.471
LGA    I   128_A      I     106          0.800
LGA    A   129_A      A     107          0.563
LGA    S   130_A      K     108          0.339
LGA    D   131_A      A     109          0.297
LGA    C   132_A      W     110          0.539
LGA    F   133_A      F     111          0.709
LGA    R   134_A      K     112          1.453
LGA    F   135_A      I     113          0.887
LGA    Q   136_A      G     114          0.172
LGA    D   137_A      E     115          1.658
LGA    W   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    S   140_A      P     116           #
LGA    -       -      R     117           -
LGA    -       -      I     118           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  139  117    5.0    104    2.05     7.69     73.597     4.846

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.997934 * X  +   0.014685 * Y  +  -0.062544 * Z  +  43.328808
  Y_new =  -0.054244 * X  +   0.329026 * Y  +   0.942762 * Z  + -57.951530
  Z_new =   0.034423 * X  +   0.944207 * Y  +  -0.327549 * Z  +   1.987515 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.904711   -1.236882  [ DEG:   109.1319    -70.8681 ]
  Theta =  -0.034429   -3.107163  [ DEG:    -1.9727   -178.0273 ]
  Phi   =  -3.087290    0.054303  [ DEG:  -176.8887      3.1113 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jkg_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jkg_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  139  117   5.0  104   2.05    7.69  73.597
REMARK  ---------------------------------------------------------- 
MOLECULE 1jkg_A
HEADER    TRANSPORT PROTEIN                       12-JUL-01   1JKG              
TITLE     STRUCTURAL BASIS FOR THE RECOGNITION OF A NUCLEOPORIN FG-             
TITLE    2 REPEAT BY THE NTF2-LIKE DOMAIN OF TAP-P15 MRNA NUCLEAR               
TITLE    3 EXPORT FACTOR                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P15;                                                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: NTF2-RELATED EXPORT PROTEIN 1;                              
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: TAP;                                                       
COMPND   8 CHAIN: B;                                                            
COMPND   9 FRAGMENT: RESIDUES 371-619;                                          
COMPND  10 SYNONYM: TIP ASSOCIATING PROTEIN;                                    
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-28C;                                  
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  11 ORGANISM_COMMON: HUMAN;                                              
SOURCE  12 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  13 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  15 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PGEX-CS                                   
KEYWDS    NTF2-LIKE DOMAIN                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.FRIBOURG,I.C.BRAUN,E.IZAURRALDE,E.CONTI                             
REVDAT   3   01-APR-03 1JKG    1       JRNL                                     
REVDAT   2   18-DEC-02 1JKG    1       REMARK                                   
REVDAT   1   17-OCT-01 1JKG    0                                                
JRNL        AUTH   S.FRIBOURG,I.C.BRAUN,E.IZAURRALDE,E.CONTI                    
JRNL        TITL   STRUCTURAL BASIS FOR THE RECOGNITION OF A                    
JRNL        TITL 2 NUCLEOPORIN FG REPEAT BY THE NTF2-LIKE DOMAIN OF             
JRNL        TITL 3 THE TAP/P15 MRNA NUCLEAR EXPORT FACTOR.                      
JRNL        REF    MOL.CELL                      V.   8   645 2001              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1JKG A    1   140  UNP    Q9UKK6   NXT1_HUMAN       1    140             
DBREF  1JKG B  371   619  UNP    Q9UBU9   NXF1_HUMAN     371    619             
SEQRES   1 A  140  MET ALA SER VAL ASP PHE LYS THR TYR VAL ASP GLN ALA          
SEQRES   2 A  140  CYS ARG ALA ALA GLU GLU PHE VAL ASN VAL TYR TYR THR          
SEQRES   3 A  140  THR MET ASP LYS ARG ARG ARG LEU LEU SER ARG LEU TYR          
SEQRES   4 A  140  MET GLY THR ALA THR LEU VAL TRP ASN GLY ASN ALA VAL          
SEQRES   5 A  140  SER GLY GLN GLU SER LEU SER GLU PHE PHE GLU MET LEU          
SEQRES   6 A  140  PRO SER SER GLU PHE GLN ILE SER VAL VAL ASP CYS GLN          
SEQRES   7 A  140  PRO VAL HIS ASP GLU ALA THR PRO SER GLN THR THR VAL          
SEQRES   8 A  140  LEU VAL VAL ILE CYS GLY SER VAL LYS PHE GLU GLY ASN          
SEQRES   9 A  140  LYS GLN ARG ASP PHE ASN GLN ASN PHE ILE LEU THR ALA          
SEQRES  10 A  140  GLN ALA SER PRO SER ASN THR VAL TRP LYS ILE ALA SER          
SEQRES  11 A  140  ASP CYS PHE ARG PHE GLN ASP TRP ALA SER                      
SEQRES   1 B  250  ALA PRO PRO CYS LYS GLY SER TYR PHE GLY THR GLU ASN          
SEQRES   2 B  250  LEU LYS SER LEU VAL LEU HIS PHE LEU GLN GLN TYR TYR          
SEQRES   3 B  250  ALA ILE TYR ASP SER GLY ASP ARG GLN GLY LEU LEU ASP          
SEQRES   4 B  250  ALA TYR HIS ASP GLY ALA CYS CYS SER LEU SER ILE PRO          
SEQRES   5 B  250  PHE ILE PRO GLN ASN PRO ALA ARG SER SER LEU ALA GLU          
SEQRES   6 B  250  TYR PHE LYS ASP SER ARG ASN VAL LYS LYS LEU LYS ASP          
SEQRES   7 B  250  PRO THR LEU ARG PHE ARG LEU LEU LYS HIS THR ARG LEU          
SEQRES   8 B  250  ASN VAL VAL ALA PHE LEU ASN GLU LEU PRO LYS THR GLN          
SEQRES   9 B  250  HIS ASP VAL ASN SER PHE VAL VAL ASP ILE SER ALA GLN          
SEQRES  10 B  250  THR SER THR LEU LEU CYS PHE SER VAL ASN GLY VAL PHE          
SEQRES  11 B  250  LYS GLU VAL ASP GLY LYS SER ARG ASP SER LEU ARG ALA          
SEQRES  12 B  250  PHE THR ARG THR PHE ILE ALA VAL PRO ALA SER ASN SER          
SEQRES  13 B  250  GLY LEU CYS ILE VAL ASN ASP GLU LEU PHE VAL ARG ASN          
SEQRES  14 B  250  ALA SER SER GLU GLU ILE GLN ARG ALA PHE ALA MET PRO          
SEQRES  15 B  250  ALA PRO THR PRO SER SER SER PRO VAL PRO THR LEU SER          
SEQRES  16 B  250  PRO GLU GLN GLN GLU MET LEU GLN ALA PHE SER THR GLN          
SEQRES  17 B  250  SER GLY MET ASN LEU GLU TRP SER GLN LYS CYS LEU GLN          
SEQRES  18 B  250  ASP ASN ASN TRP ASP TYR THR ARG SER ALA GLN ALA PHE          
SEQRES  19 B  250  THR HIS LEU LYS ALA LYS GLY GLU ILE PRO GLU VAL ALA          
SEQRES  20 B  250  PHE MET LYS                                                  
FORMUL   3  HOH   *235(H2 O)                                                    
CRYST1  104.340  104.340  170.344  90.00  90.00 120.00 P 65 2 2     12          
ATOM      1  N   ALA A   2      13.398   8.058  -8.592  1.00 47.06           N  
ATOM      2  CA  ALA A   2      12.470   7.044  -9.081  1.00 46.39           C  
ATOM      3  C   ALA A   2      11.213   7.687  -9.656  1.00 45.80           C  
ATOM      4  O   ALA A   2      10.792   8.756  -9.215  1.00 46.27           O  
ATOM      5  CB  ALA A   2      12.099   6.087  -7.953  1.00 46.80           C  
ATOM      6  N   SER A   3      10.615   7.022 -10.640  1.00 44.46           N  
ATOM      7  CA  SER A   3       9.404   7.523 -11.278  1.00 43.78           C  
ATOM      8  C   SER A   3       8.218   7.480 -10.317  1.00 42.69           C  
ATOM      9  O   SER A   3       7.225   8.182 -10.513  1.00 42.90           O  
ATOM     10  CB  SER A   3       9.089   6.694 -12.524  1.00 43.60           C  
ATOM     11  OG  SER A   3       8.944   5.323 -12.196  1.00 44.29           O  
ATOM     12  N   VAL A   4       8.325   6.652  -9.282  1.00 41.02           N  
ATOM     13  CA  VAL A   4       7.266   6.527  -8.280  1.00 39.15           C  
ATOM     14  C   VAL A   4       7.884   6.542  -6.882  1.00 37.22           C  
ATOM     15  O   VAL A   4       8.921   5.928  -6.645  1.00 36.28           O  
ATOM     16  CB  VAL A   4       6.466   5.217  -8.462  1.00 39.36           C  
ATOM     17  CG1 VAL A   4       5.413   5.083  -7.365  1.00 39.62           C  
ATOM     18  CG2 VAL A   4       5.798   5.203  -9.826  1.00 39.88           C  
ATOM     19  N   ASP A   5       7.238   7.255  -5.967  1.00 35.01           N  
ATOM     20  CA  ASP A   5       7.711   7.378  -4.596  1.00 33.62           C  
ATOM     21  C   ASP A   5       7.835   5.991  -3.956  1.00 30.95           C  
ATOM     22  O   ASP A   5       6.956   5.143  -4.113  1.00 28.70           O  
ATOM     23  CB  ASP A   5       6.731   8.254  -3.812  1.00 37.46           C  
ATOM     24  CG  ASP A   5       7.293   8.725  -2.487  1.00 43.31           C  
ATOM     25  OD1 ASP A   5       8.522   8.939  -2.401  1.00 45.81           O  
ATOM     26  OD2 ASP A   5       6.499   8.902  -1.536  1.00 46.13           O  
ATOM     27  N   PHE A   6       8.931   5.762  -3.240  1.00 28.00           N  
ATOM     28  CA  PHE A   6       9.160   4.471  -2.594  1.00 26.50           C  
ATOM     29  C   PHE A   6       8.053   4.119  -1.607  1.00 26.31           C  
ATOM     30  O   PHE A   6       7.611   2.968  -1.546  1.00 23.99           O  
ATOM     31  CB  PHE A   6      10.507   4.470  -1.866  1.00 27.04           C  
ATOM     32  CG  PHE A   6      10.870   3.142  -1.266  1.00 25.28           C  
ATOM     33  CD1 PHE A   6      11.040   2.023  -2.074  1.00 26.34           C  
ATOM     34  CD2 PHE A   6      11.031   3.006   0.109  1.00 25.95           C  
ATOM     35  CE1 PHE A   6      11.365   0.782  -1.523  1.00 25.36           C  
ATOM     36  CE2 PHE A   6      11.356   1.770   0.672  1.00 26.22           C  
ATOM     37  CZ  PHE A   6      11.522   0.658  -0.147  1.00 26.07           C  
ATOM     38  N   LYS A   7       7.598   5.100  -0.833  1.00 24.87           N  
ATOM     39  CA  LYS A   7       6.548   4.825   0.139  1.00 27.27           C  
ATOM     40  C   LYS A   7       5.307   4.267  -0.544  1.00 25.53           C  
ATOM     41  O   LYS A   7       4.561   3.490   0.053  1.00 24.27           O  
ATOM     42  CB  LYS A   7       6.180   6.080   0.933  1.00 30.13           C  
ATOM     43  CG  LYS A   7       5.125   5.793   1.995  1.00 34.36           C  
ATOM     44  CD  LYS A   7       5.000   6.903   3.019  1.00 36.30           C  
ATOM     45  CE  LYS A   7       4.020   6.502   4.113  1.00 36.92           C  
ATOM     46  NZ  LYS A   7       2.669   6.202   3.560  1.00 37.98           N  
ATOM     47  N   THR A   8       5.083   4.664  -1.793  1.00 24.25           N  
ATOM     48  CA  THR A   8       3.929   4.169  -2.536  1.00 24.69           C  
ATOM     49  C   THR A   8       4.041   2.659  -2.712  1.00 23.09           C  
ATOM     50  O   THR A   8       3.057   1.931  -2.562  1.00 21.25           O  
ATOM     51  CB  THR A   8       3.825   4.845  -3.917  1.00 25.91           C  
ATOM     52  OG1 THR A   8       3.563   6.243  -3.737  1.00 25.62           O  
ATOM     53  CG2 THR A   8       2.695   4.225  -4.738  1.00 26.76           C  
ATOM     54  N   TYR A   9       5.244   2.192  -3.027  1.00 22.94           N  
ATOM     55  CA  TYR A   9       5.478   0.762  -3.207  1.00 23.29           C  
ATOM     56  C   TYR A   9       5.356   0.010  -1.889  1.00 21.46           C  
ATOM     57  O   TYR A   9       4.844  -1.110  -1.849  1.00 20.45           O  
ATOM     58  CB  TYR A   9       6.870   0.509  -3.783  1.00 24.67           C  
ATOM     59  CG  TYR A   9       7.010   0.854  -5.244  1.00 29.61           C  
ATOM     60  CD1 TYR A   9       7.642   2.030  -5.649  1.00 30.10           C  
ATOM     61  CD2 TYR A   9       6.528  -0.008  -6.225  1.00 31.16           C  
ATOM     62  CE1 TYR A   9       7.793   2.336  -6.995  1.00 32.45           C  
ATOM     63  CE2 TYR A   9       6.673   0.290  -7.574  1.00 33.60           C  
ATOM     64  CZ  TYR A   9       7.306   1.461  -7.953  1.00 34.15           C  
ATOM     65  OH  TYR A   9       7.454   1.756  -9.289  1.00 36.82           O  
ATOM     66  N   VAL A  10       5.845   0.620  -0.815  1.00 18.98           N  
ATOM     67  CA  VAL A  10       5.787  -0.018   0.496  1.00 19.17           C  
ATOM     68  C   VAL A  10       4.345  -0.142   0.978  1.00 20.76           C  
ATOM     69  O   VAL A  10       3.950  -1.182   1.501  1.00 20.50           O  
ATOM     70  CB  VAL A  10       6.609   0.767   1.538  1.00 20.75           C  
ATOM     71  CG1 VAL A  10       6.478   0.112   2.903  1.00 18.55           C  
ATOM     72  CG2 VAL A  10       8.075   0.809   1.109  1.00 19.69           C  
ATOM     73  N   ASP A  11       3.559   0.919   0.803  1.00 21.42           N  
ATOM     74  CA  ASP A  11       2.157   0.882   1.215  1.00 23.81           C  
ATOM     75  C   ASP A  11       1.409  -0.171   0.399  1.00 21.44           C  
ATOM     76  O   ASP A  11       0.658  -0.979   0.944  1.00 22.05           O  
ATOM     77  CB  ASP A  11       1.484   2.243   1.002  1.00 25.75           C  
ATOM     78  CG  ASP A  11       2.037   3.321   1.910  1.00 31.52           C  
ATOM     79  OD1 ASP A  11       2.664   2.977   2.933  1.00 35.49           O  
ATOM     80  OD2 ASP A  11       1.833   4.518   1.609  1.00 34.48           O  
ATOM     81  N   GLN A  12       1.615  -0.148  -0.914  1.00 20.99           N  
ATOM     82  CA  GLN A  12       0.962  -1.104  -1.803  1.00 21.80           C  
ATOM     83  C   GLN A  12       1.322  -2.536  -1.432  1.00 21.40           C  
ATOM     84  O   GLN A  12       0.464  -3.421  -1.439  1.00 19.15           O  
ATOM     85  CB  GLN A  12       1.367  -0.850  -3.257  1.00 24.09           C  
ATOM     86  CG  GLN A  12       0.829  -1.897  -4.223  1.00 27.61           C  
ATOM     87  CD  GLN A  12       1.254  -1.646  -5.654  1.00 30.01           C  
ATOM     88  OE1 GLN A  12       2.439  -1.715  -5.986  1.00 28.84           O  
ATOM     89  NE2 GLN A  12       0.284  -1.346  -6.511  1.00 32.29           N  
ATOM     90  N   ALA A  13       2.597  -2.758  -1.115  1.00 20.65           N  
ATOM     91  CA  ALA A  13       3.075  -4.089  -0.740  1.00 20.31           C  
ATOM     92  C   ALA A  13       2.362  -4.603   0.513  1.00 20.29           C  
ATOM     93  O   ALA A  13       1.935  -5.760   0.563  1.00 18.95           O  
ATOM     94  CB  ALA A  13       4.595  -4.057  -0.507  1.00 20.17           C  
ATOM     95  N   CYS A  14       2.231  -3.747   1.521  1.00 20.01           N  
ATOM     96  CA  CYS A  14       1.567  -4.149   2.756  1.00 21.45           C  
ATOM     97  C   CYS A  14       0.101  -4.500   2.536  1.00 21.69           C  
ATOM     98  O   CYS A  14      -0.386  -5.497   3.064  1.00 20.90           O  
ATOM     99  CB  CYS A  14       1.657  -3.042   3.805  1.00 22.60           C  
ATOM    100  SG  CYS A  14       3.303  -2.796   4.475  1.00 23.84           S  
ATOM    101  N   ARG A  15      -0.600  -3.670   1.773  1.00 22.35           N  
ATOM    102  CA  ARG A  15      -2.016  -3.906   1.502  1.00 25.24           C  
ATOM    103  C   ARG A  15      -2.220  -5.195   0.709  1.00 23.93           C  
ATOM    104  O   ARG A  15      -3.088  -6.007   1.034  1.00 23.54           O  
ATOM    105  CB  ARG A  15      -2.613  -2.730   0.724  1.00 28.82           C  
ATOM    106  CG  ARG A  15      -4.106  -2.869   0.476  1.00 37.90           C  
ATOM    107  CD  ARG A  15      -4.649  -1.715  -0.354  1.00 44.55           C  
ATOM    108  NE  ARG A  15      -6.097  -1.812  -0.524  1.00 49.80           N  
ATOM    109  CZ  ARG A  15      -6.825  -0.961  -1.242  1.00 52.51           C  
ATOM    110  NH1 ARG A  15      -6.243   0.057  -1.865  1.00 52.93           N  
ATOM    111  NH2 ARG A  15      -8.138  -1.129  -1.337  1.00 54.07           N  
ATOM    112  N   ALA A  16      -1.420  -5.373  -0.336  1.00 21.84           N  
ATOM    113  CA  ALA A  16      -1.511  -6.560  -1.175  1.00 21.43           C  
ATOM    114  C   ALA A  16      -1.209  -7.816  -0.368  1.00 21.03           C  
ATOM    115  O   ALA A  16      -1.872  -8.843  -0.529  1.00 20.83           O  
ATOM    116  CB  ALA A  16      -0.540  -6.450  -2.342  1.00 21.70           C  
ATOM    117  N   ALA A  17      -0.204  -7.732   0.497  1.00 19.91           N  
ATOM    118  CA  ALA A  17       0.196  -8.872   1.312  1.00 20.36           C  
ATOM    119  C   ALA A  17      -0.825  -9.237   2.385  1.00 20.17           C  
ATOM    120  O   ALA A  17      -1.178 -10.406   2.534  1.00 21.70           O  
ATOM    121  CB  ALA A  17       1.549  -8.600   1.961  1.00 21.63           C  
ATOM    122  N   GLU A  18      -1.298  -8.246   3.134  1.00 20.38           N  
ATOM    123  CA  GLU A  18      -2.259  -8.531   4.192  1.00 22.72           C  
ATOM    124  C   GLU A  18      -3.536  -9.145   3.635  1.00 22.12           C  
ATOM    125  O   GLU A  18      -4.063 -10.111   4.194  1.00 21.39           O  
ATOM    126  CB  GLU A  18      -2.589  -7.262   4.993  1.00 25.81           C  
ATOM    127  CG  GLU A  18      -3.123  -6.095   4.177  1.00 30.14           C  
ATOM    128  CD  GLU A  18      -3.425  -4.869   5.033  1.00 34.81           C  
ATOM    129  OE1 GLU A  18      -3.035  -4.851   6.223  1.00 33.80           O  
ATOM    130  OE2 GLU A  18      -4.048  -3.917   4.515  1.00 36.12           O  
ATOM    131  N   GLU A  19      -4.026  -8.600   2.527  1.00 22.05           N  
ATOM    132  CA  GLU A  19      -5.249  -9.117   1.927  1.00 22.70           C  
ATOM    133  C   GLU A  19      -5.031 -10.488   1.314  1.00 22.03           C  
ATOM    134  O   GLU A  19      -5.847 -11.391   1.502  1.00 21.39           O  
ATOM    135  CB  GLU A  19      -5.779  -8.152   0.870  1.00 24.94           C  
ATOM    136  CG  GLU A  19      -6.063  -6.768   1.424  1.00 31.83           C  
ATOM    137  CD  GLU A  19      -6.982  -5.958   0.536  1.00 35.78           C  
ATOM    138  OE1 GLU A  19      -7.079  -6.274  -0.669  1.00 37.91           O  
ATOM    139  OE2 GLU A  19      -7.599  -4.997   1.044  1.00 39.12           O  
ATOM    140  N   PHE A  20      -3.929 -10.656   0.587  1.00 19.49           N  
ATOM    141  CA  PHE A  20      -3.654 -11.941  -0.033  1.00 18.92           C  
ATOM    142  C   PHE A  20      -3.491 -13.052   1.004  1.00 19.66           C  
ATOM    143  O   PHE A  20      -3.985 -14.167   0.815  1.00 19.48           O  
ATOM    144  CB  PHE A  20      -2.389 -11.888  -0.894  1.00 18.06           C  
ATOM    145  CG  PHE A  20      -2.141 -13.159  -1.646  1.00 18.83           C  
ATOM    146  CD1 PHE A  20      -2.691 -13.354  -2.909  1.00 18.25           C  
ATOM    147  CD2 PHE A  20      -1.435 -14.200  -1.054  1.00 18.16           C  
ATOM    148  CE1 PHE A  20      -2.546 -14.575  -3.569  1.00 18.45           C  
ATOM    149  CE2 PHE A  20      -1.286 -15.421  -1.704  1.00 18.29           C  
ATOM    150  CZ  PHE A  20      -1.845 -15.609  -2.964  1.00 16.81           C  
ATOM    151  N   VAL A  21      -2.786 -12.760   2.091  1.00 18.89           N  
ATOM    152  CA  VAL A  21      -2.582 -13.764   3.129  1.00 20.04           C  
ATOM    153  C   VAL A  21      -3.921 -14.221   3.697  1.00 20.17           C  
ATOM    154  O   VAL A  21      -4.136 -15.415   3.930  1.00 20.61           O  
ATOM    155  CB  VAL A  21      -1.690 -13.213   4.266  1.00 20.15           C  
ATOM    156  CG1 VAL A  21      -1.749 -14.135   5.477  1.00 19.07           C  
ATOM    157  CG2 VAL A  21      -0.247 -13.106   3.765  1.00 19.92           C  
ATOM    158  N   ASN A  22      -4.818 -13.268   3.918  1.00 19.77           N  
ATOM    159  CA  ASN A  22      -6.141 -13.584   4.443  1.00 21.92           C  
ATOM    160  C   ASN A  22      -6.834 -14.562   3.494  1.00 22.12           C  
ATOM    161  O   ASN A  22      -7.338 -15.609   3.916  1.00 21.70           O  
ATOM    162  CB  ASN A  22      -6.967 -12.304   4.581  1.00 25.64           C  
ATOM    163  CG  ASN A  22      -8.365 -12.565   5.115  1.00 30.08           C  
ATOM    164  OD1 ASN A  22      -9.193 -11.658   5.176  1.00 35.41           O  
ATOM    165  ND2 ASN A  22      -8.632 -13.802   5.509  1.00 32.13           N  
ATOM    166  N   VAL A  23      -6.841 -14.221   2.207  1.00 20.55           N  
ATOM    167  CA  VAL A  23      -7.463 -15.061   1.188  1.00 20.34           C  
ATOM    168  C   VAL A  23      -6.784 -16.425   1.059  1.00 20.17           C  
ATOM    169  O   VAL A  23      -7.451 -17.462   0.980  1.00 18.50           O  
ATOM    170  CB  VAL A  23      -7.422 -14.377  -0.206  1.00 21.00           C  
ATOM    171  CG1 VAL A  23      -7.944 -15.329  -1.274  1.00 19.86           C  
ATOM    172  CG2 VAL A  23      -8.249 -13.096  -0.189  1.00 20.60           C  
ATOM    173  N   TYR A  24      -5.456 -16.419   1.034  1.00 17.64           N  
ATOM    174  CA  TYR A  24      -4.692 -17.646   0.884  1.00 18.56           C  
ATOM    175  C   TYR A  24      -4.991 -18.727   1.922  1.00 18.40           C  
ATOM    176  O   TYR A  24      -5.350 -19.851   1.569  1.00 19.13           O  
ATOM    177  CB  TYR A  24      -3.188 -17.343   0.908  1.00 17.57           C  
ATOM    178  CG  TYR A  24      -2.334 -18.552   0.614  1.00 18.78           C  
ATOM    179  CD1 TYR A  24      -2.051 -18.929  -0.701  1.00 17.93           C  
ATOM    180  CD2 TYR A  24      -1.821 -19.336   1.650  1.00 18.88           C  
ATOM    181  CE1 TYR A  24      -1.274 -20.049  -0.975  1.00 18.25           C  
ATOM    182  CE2 TYR A  24      -1.044 -20.464   1.386  1.00 19.00           C  
ATOM    183  CZ  TYR A  24      -0.774 -20.812   0.073  1.00 19.68           C  
ATOM    184  OH  TYR A  24       0.005 -21.920  -0.194  1.00 20.32           O  
ATOM    185  N   TYR A  25      -4.843 -18.399   3.201  1.00 18.85           N  
ATOM    186  CA  TYR A  25      -5.079 -19.402   4.228  1.00 19.54           C  
ATOM    187  C   TYR A  25      -6.555 -19.729   4.443  1.00 20.35           C  
ATOM    188  O   TYR A  25      -6.892 -20.849   4.829  1.00 21.74           O  
ATOM    189  CB  TYR A  25      -4.385 -18.986   5.525  1.00 19.22           C  
ATOM    190  CG  TYR A  25      -2.878 -18.958   5.355  1.00 19.41           C  
ATOM    191  CD1 TYR A  25      -2.193 -17.755   5.165  1.00 19.91           C  
ATOM    192  CD2 TYR A  25      -2.147 -20.145   5.304  1.00 20.46           C  
ATOM    193  CE1 TYR A  25      -0.816 -17.740   4.925  1.00 18.50           C  
ATOM    194  CE2 TYR A  25      -0.771 -20.140   5.061  1.00 19.37           C  
ATOM    195  CZ  TYR A  25      -0.114 -18.937   4.874  1.00 19.33           C  
ATOM    196  OH  TYR A  25       1.244 -18.939   4.636  1.00 20.06           O  
ATOM    197  N   THR A  26      -7.434 -18.770   4.175  1.00 21.18           N  
ATOM    198  CA  THR A  26      -8.868 -19.026   4.306  1.00 22.16           C  
ATOM    199  C   THR A  26      -9.205 -20.087   3.260  1.00 22.24           C  
ATOM    200  O   THR A  26      -9.885 -21.079   3.543  1.00 22.78           O  
ATOM    201  CB  THR A  26      -9.703 -17.758   4.014  1.00 22.36           C  
ATOM    202  OG1 THR A  26      -9.466 -16.783   5.035  1.00 21.48           O  
ATOM    203  CG2 THR A  26     -11.195 -18.091   3.981  1.00 23.82           C  
ATOM    204  N   THR A  27      -8.701 -19.873   2.050  1.00 21.51           N  
ATOM    205  CA  THR A  27      -8.927 -20.785   0.940  1.00 21.81           C  
ATOM    206  C   THR A  27      -8.279 -22.141   1.206  1.00 22.91           C  
ATOM    207  O   THR A  27      -8.880 -23.185   0.955  1.00 22.15           O  
ATOM    208  CB  THR A  27      -8.374 -20.190  -0.370  1.00 20.65           C  
ATOM    209  OG1 THR A  27      -9.050 -18.957  -0.649  1.00 21.07           O  
ATOM    210  CG2 THR A  27      -8.586 -21.150  -1.536  1.00 22.26           C  
ATOM    211  N   MET A  28      -7.051 -22.120   1.718  1.00 21.33           N  
ATOM    212  CA  MET A  28      -6.334 -23.351   2.029  1.00 21.78           C  
ATOM    213  C   MET A  28      -7.141 -24.239   2.975  1.00 21.56           C  
ATOM    214  O   MET A  28      -7.233 -25.454   2.781  1.00 22.45           O  
ATOM    215  CB  MET A  28      -4.992 -23.019   2.687  1.00 22.83           C  
ATOM    216  CG  MET A  28      -4.249 -24.226   3.241  1.00 25.09           C  
ATOM    217  SD  MET A  28      -3.535 -25.249   1.955  1.00 28.70           S  
ATOM    218  CE  MET A  28      -1.946 -24.410   1.731  1.00 30.45           C  
ATOM    219  N   ASP A  29      -7.724 -23.622   3.997  1.00 22.03           N  
ATOM    220  CA  ASP A  29      -8.494 -24.347   5.005  1.00 22.84           C  
ATOM    221  C   ASP A  29      -9.946 -24.661   4.654  1.00 23.96           C  
ATOM    222  O   ASP A  29     -10.453 -25.729   4.995  1.00 23.27           O  
ATOM    223  CB  ASP A  29      -8.507 -23.568   6.324  1.00 23.18           C  
ATOM    224  CG  ASP A  29      -7.158 -23.532   7.004  1.00 23.89           C  
ATOM    225  OD1 ASP A  29      -6.240 -24.248   6.557  1.00 25.00           O  
ATOM    226  OD2 ASP A  29      -7.028 -22.789   7.999  1.00 23.24           O  
ATOM    227  N   LYS A  30     -10.614 -23.736   3.974  1.00 23.61           N  
ATOM    228  CA  LYS A  30     -12.030 -23.923   3.682  1.00 24.55           C  
ATOM    229  C   LYS A  30     -12.447 -24.051   2.225  1.00 24.78           C  
ATOM    230  O   LYS A  30     -13.618 -24.299   1.942  1.00 25.86           O  
ATOM    231  CB  LYS A  30     -12.809 -22.788   4.342  1.00 24.73           C  
ATOM    232  CG  LYS A  30     -12.364 -22.514   5.772  1.00 28.74           C  
ATOM    233  CD  LYS A  30     -13.030 -21.277   6.350  1.00 30.62           C  
ATOM    234  CE  LYS A  30     -12.376 -20.871   7.661  1.00 33.85           C  
ATOM    235  NZ  LYS A  30     -12.353 -21.982   8.644  1.00 37.16           N  
ATOM    236  N   ARG A  31     -11.510 -23.886   1.300  1.00 23.67           N  
ATOM    237  CA  ARG A  31     -11.841 -23.995  -0.116  1.00 23.53           C  
ATOM    238  C   ARG A  31     -10.600 -24.464  -0.865  1.00 23.42           C  
ATOM    239  O   ARG A  31     -10.206 -23.872  -1.868  1.00 22.08           O  
ATOM    240  CB  ARG A  31     -12.297 -22.634  -0.659  1.00 22.08           C  
ATOM    241  CG  ARG A  31     -13.211 -22.724  -1.873  1.00 24.74           C  
ATOM    242  CD  ARG A  31     -14.584 -23.228  -1.460  1.00 24.62           C  
ATOM    243  NE  ARG A  31     -15.482 -23.426  -2.594  1.00 24.09           N  
ATOM    244  CZ  ARG A  31     -16.784 -23.669  -2.474  1.00 22.40           C  
ATOM    245  NH1 ARG A  31     -17.333 -23.740  -1.269  1.00 21.23           N  
ATOM    246  NH2 ARG A  31     -17.531 -23.847  -3.557  1.00 22.69           N  
ATOM    247  N   ARG A  32     -10.006 -25.548  -0.370  1.00 23.52           N  
ATOM    248  CA  ARG A  32      -8.779 -26.119  -0.927  1.00 23.90           C  
ATOM    249  C   ARG A  32      -8.704 -26.213  -2.450  1.00 23.80           C  
ATOM    250  O   ARG A  32      -7.681 -25.892  -3.049  1.00 22.53           O  
ATOM    251  CB  ARG A  32      -8.543 -27.509  -0.314  1.00 24.75           C  
ATOM    252  CG  ARG A  32      -7.214 -28.170  -0.685  1.00 27.36           C  
ATOM    253  CD  ARG A  32      -6.031 -27.431  -0.066  1.00 25.84           C  
ATOM    254  NE  ARG A  32      -6.023 -27.520   1.393  1.00 24.66           N  
ATOM    255  CZ  ARG A  32      -5.612 -28.581   2.086  1.00 26.38           C  
ATOM    256  NH1 ARG A  32      -5.165 -29.664   1.462  1.00 25.87           N  
ATOM    257  NH2 ARG A  32      -5.646 -28.557   3.411  1.00 24.76           N  
ATOM    258  N   ARG A  33      -9.786 -26.650  -3.081  1.00 25.09           N  
ATOM    259  CA  ARG A  33      -9.806 -26.810  -4.533  1.00 26.49           C  
ATOM    260  C   ARG A  33      -9.633 -25.537  -5.335  1.00 25.27           C  
ATOM    261  O   ARG A  33      -9.384 -25.583  -6.541  1.00 25.86           O  
ATOM    262  CB  ARG A  33     -11.104 -27.484  -4.964  1.00 31.14           C  
ATOM    263  CG  ARG A  33     -11.249 -28.883  -4.406  1.00 38.47           C  
ATOM    264  CD  ARG A  33     -12.490 -29.579  -4.930  1.00 44.33           C  
ATOM    265  NE  ARG A  33     -12.625 -30.933  -4.404  1.00 49.10           N  
ATOM    266  CZ  ARG A  33     -13.594 -31.772  -4.759  1.00 52.18           C  
ATOM    267  NH1 ARG A  33     -14.509 -31.388  -5.645  1.00 52.85           N  
ATOM    268  NH2 ARG A  33     -13.652 -32.988  -4.223  1.00 52.52           N  
ATOM    269  N   LEU A  34      -9.777 -24.403  -4.668  1.00 24.62           N  
ATOM    270  CA  LEU A  34      -9.648 -23.119  -5.335  1.00 25.58           C  
ATOM    271  C   LEU A  34      -8.253 -22.519  -5.159  1.00 23.88           C  
ATOM    272  O   LEU A  34      -7.886 -21.563  -5.844  1.00 24.06           O  
ATOM    273  CB  LEU A  34     -10.695 -22.164  -4.770  1.00 28.98           C  
ATOM    274  CG  LEU A  34     -10.987 -20.854  -5.492  1.00 33.99           C  
ATOM    275  CD1 LEU A  34     -11.517 -21.104  -6.908  1.00 36.45           C  
ATOM    276  CD2 LEU A  34     -12.021 -20.108  -4.668  1.00 36.05           C  
ATOM    277  N   LEU A  35      -7.468 -23.100  -4.257  1.00 22.29           N  
ATOM    278  CA  LEU A  35      -6.134 -22.580  -3.962  1.00 22.31           C  
ATOM    279  C   LEU A  35      -5.186 -22.409  -5.149  1.00 22.08           C  
ATOM    280  O   LEU A  35      -4.489 -21.396  -5.240  1.00 22.18           O  
ATOM    281  CB  LEU A  35      -5.448 -23.445  -2.901  1.00 22.05           C  
ATOM    282  CG  LEU A  35      -4.278 -22.738  -2.203  1.00 22.92           C  
ATOM    283  CD1 LEU A  35      -4.829 -21.651  -1.284  1.00 22.45           C  
ATOM    284  CD2 LEU A  35      -3.458 -23.728  -1.399  1.00 24.07           C  
ATOM    285  N   SER A  36      -5.146 -23.385  -6.051  1.00 20.56           N  
ATOM    286  CA  SER A  36      -4.242 -23.302  -7.196  1.00 21.83           C  
ATOM    287  C   SER A  36      -4.525 -22.109  -8.109  1.00 22.16           C  
ATOM    288  O   SER A  36      -3.663 -21.700  -8.890  1.00 21.60           O  
ATOM    289  CB  SER A  36      -4.290 -24.597  -8.013  1.00 23.46           C  
ATOM    290  OG  SER A  36      -5.564 -24.785  -8.598  1.00 25.64           O  
ATOM    291  N   ARG A  37      -5.726 -21.548  -8.019  1.00 21.76           N  
ATOM    292  CA  ARG A  37      -6.062 -20.397  -8.848  1.00 24.03           C  
ATOM    293  C   ARG A  37      -5.370 -19.136  -8.345  1.00 22.54           C  
ATOM    294  O   ARG A  37      -5.329 -18.118  -9.040  1.00 22.83           O  
ATOM    295  CB  ARG A  37      -7.579 -20.191  -8.894  1.00 26.79           C  
ATOM    296  CG  ARG A  37      -8.290 -21.235  -9.745  1.00 31.25           C  
ATOM    297  CD  ARG A  37      -9.772 -20.934  -9.908  1.00 37.59           C  
ATOM    298  NE  ARG A  37     -10.414 -21.888 -10.812  1.00 43.46           N  
ATOM    299  CZ  ARG A  37     -10.146 -21.989 -12.112  1.00 45.74           C  
ATOM    300  NH1 ARG A  37      -9.248 -21.189 -12.672  1.00 47.41           N  
ATOM    301  NH2 ARG A  37     -10.768 -22.897 -12.853  1.00 47.17           N  
ATOM    302  N   LEU A  38      -4.815 -19.208  -7.141  1.00 20.98           N  
ATOM    303  CA  LEU A  38      -4.113 -18.066  -6.573  1.00 20.41           C  
ATOM    304  C   LEU A  38      -2.663 -18.071  -7.048  1.00 20.80           C  
ATOM    305  O   LEU A  38      -1.890 -17.173  -6.714  1.00 19.78           O  
ATOM    306  CB  LEU A  38      -4.148 -18.119  -5.044  1.00 20.40           C  
ATOM    307  CG  LEU A  38      -5.512 -18.144  -4.352  1.00 20.80           C  
ATOM    308  CD1 LEU A  38      -5.309 -18.156  -2.840  1.00 19.85           C  
ATOM    309  CD2 LEU A  38      -6.329 -16.929  -4.767  1.00 21.84           C  
ATOM    310  N   TYR A  39      -2.300 -19.089  -7.824  1.00 20.02           N  
ATOM    311  CA  TYR A  39      -0.941 -19.220  -8.346  1.00 20.63           C  
ATOM    312  C   TYR A  39      -0.853 -18.946  -9.842  1.00 21.67           C  
ATOM    313  O   TYR A  39      -1.824 -19.131 -10.581  1.00 21.72           O  
ATOM    314  CB  TYR A  39      -0.395 -20.632  -8.110  1.00 20.45           C  
ATOM    315  CG  TYR A  39      -0.069 -20.984  -6.676  1.00 20.61           C  
ATOM    316  CD1 TYR A  39      -1.079 -21.258  -5.753  1.00 20.99           C  
ATOM    317  CD2 TYR A  39       1.255 -21.080  -6.252  1.00 20.96           C  
ATOM    318  CE1 TYR A  39      -0.775 -21.630  -4.442  1.00 21.64           C  
ATOM    319  CE2 TYR A  39       1.572 -21.449  -4.943  1.00 19.83           C  
ATOM    320  CZ  TYR A  39       0.552 -21.725  -4.046  1.00 21.45           C  
ATOM    321  OH  TYR A  39       0.853 -22.110  -2.757  1.00 21.87           O  
ATOM    322  N   MET A  40       0.327 -18.516 -10.279  1.00 22.19           N  
ATOM    323  CA  MET A  40       0.585 -18.268 -11.692  1.00 22.24           C  
ATOM    324  C   MET A  40       0.730 -19.640 -12.352  1.00 22.68           C  
ATOM    325  O   MET A  40       1.066 -20.622 -11.686  1.00 21.90           O  
ATOM    326  CB  MET A  40       1.885 -17.478 -11.862  1.00 21.78           C  
ATOM    327  CG  MET A  40       1.816 -16.031 -11.382  1.00 23.06           C  
ATOM    328  SD  MET A  40       0.738 -15.021 -12.419  1.00 23.99           S  
ATOM    329  CE  MET A  40       1.763 -14.850 -13.887  1.00 23.26           C  
ATOM    330  N   GLY A  41       0.481 -19.709 -13.656  1.00 23.32           N  
ATOM    331  CA  GLY A  41       0.592 -20.977 -14.357  1.00 24.35           C  
ATOM    332  C   GLY A  41       1.949 -21.648 -14.236  1.00 24.70           C  
ATOM    333  O   GLY A  41       2.036 -22.873 -14.140  1.00 26.77           O  
ATOM    334  N   THR A  42       3.011 -20.848 -14.231  1.00 23.69           N  
ATOM    335  CA  THR A  42       4.368 -21.374 -14.141  1.00 24.99           C  
ATOM    336  C   THR A  42       4.900 -21.438 -12.711  1.00 23.93           C  
ATOM    337  O   THR A  42       6.047 -21.823 -12.491  1.00 23.29           O  
ATOM    338  CB  THR A  42       5.352 -20.507 -14.952  1.00 26.23           C  
ATOM    339  OG1 THR A  42       5.425 -19.202 -14.366  1.00 28.21           O  
ATOM    340  CG2 THR A  42       4.893 -20.378 -16.401  1.00 27.51           C  
ATOM    341  N   ALA A  43       4.074 -21.065 -11.740  1.00 23.09           N  
ATOM    342  CA  ALA A  43       4.507 -21.065 -10.346  1.00 22.29           C  
ATOM    343  C   ALA A  43       4.993 -22.416  -9.847  1.00 22.14           C  
ATOM    344  O   ALA A  43       4.547 -23.470 -10.307  1.00 21.27           O  
ATOM    345  CB  ALA A  43       3.379 -20.567  -9.444  1.00 22.40           C  
ATOM    346  N   THR A  44       5.914 -22.367  -8.892  1.00 22.03           N  
ATOM    347  CA  THR A  44       6.461 -23.564  -8.277  1.00 21.40           C  
ATOM    348  C   THR A  44       6.357 -23.411  -6.768  1.00 22.22           C  
ATOM    349  O   THR A  44       6.192 -22.303  -6.253  1.00 20.96           O  
ATOM    350  CB  THR A  44       7.945 -23.761  -8.613  1.00 23.49           C  
ATOM    351  OG1 THR A  44       8.688 -22.628  -8.147  1.00 23.59           O  
ATOM    352  CG2 THR A  44       8.143 -23.932 -10.109  1.00 23.63           C  
ATOM    353  N   LEU A  45       6.461 -24.531  -6.069  1.00 21.94           N  
ATOM    354  CA  LEU A  45       6.408 -24.557  -4.618  1.00 23.08           C  
ATOM    355  C   LEU A  45       7.456 -25.530  -4.103  1.00 23.71           C  
ATOM    356  O   LEU A  45       7.547 -26.661  -4.586  1.00 24.85           O  
ATOM    357  CB  LEU A  45       5.020 -25.014  -4.136  1.00 23.19           C  
ATOM    358  CG  LEU A  45       4.920 -25.590  -2.713  1.00 24.62           C  
ATOM    359  CD1 LEU A  45       5.262 -24.519  -1.681  1.00 21.16           C  
ATOM    360  CD2 LEU A  45       3.511 -26.122  -2.472  1.00 25.17           C  
ATOM    361  N   VAL A  46       8.278 -25.080  -3.157  1.00 21.42           N  
ATOM    362  CA  VAL A  46       9.257 -25.963  -2.546  1.00 21.11           C  
ATOM    363  C   VAL A  46       8.633 -26.209  -1.177  1.00 21.93           C  
ATOM    364  O   VAL A  46       8.662 -25.344  -0.300  1.00 19.96           O  
ATOM    365  CB  VAL A  46      10.644 -25.309  -2.394  1.00 20.91           C  
ATOM    366  CG1 VAL A  46      11.597 -26.284  -1.700  1.00 20.81           C  
ATOM    367  CG2 VAL A  46      11.197 -24.942  -3.767  1.00 20.14           C  
ATOM    368  N   TRP A  47       8.041 -27.389  -1.024  1.00 22.33           N  
ATOM    369  CA  TRP A  47       7.351 -27.775   0.198  1.00 23.31           C  
ATOM    370  C   TRP A  47       8.221 -28.737   0.995  1.00 23.21           C  
ATOM    371  O   TRP A  47       8.386 -29.893   0.612  1.00 22.89           O  
ATOM    372  CB  TRP A  47       6.030 -28.453  -0.171  1.00 24.39           C  
ATOM    373  CG  TRP A  47       5.039 -28.567   0.947  1.00 25.59           C  
ATOM    374  CD1 TRP A  47       4.139 -27.621   1.349  1.00 25.83           C  
ATOM    375  CD2 TRP A  47       4.840 -29.701   1.797  1.00 26.95           C  
ATOM    376  NE1 TRP A  47       3.390 -28.099   2.400  1.00 28.05           N  
ATOM    377  CE2 TRP A  47       3.800 -29.371   2.695  1.00 26.16           C  
ATOM    378  CE3 TRP A  47       5.440 -30.963   1.888  1.00 26.98           C  
ATOM    379  CZ2 TRP A  47       3.345 -30.263   3.672  1.00 28.19           C  
ATOM    380  CZ3 TRP A  47       4.987 -31.850   2.862  1.00 28.83           C  
ATOM    381  CH2 TRP A  47       3.950 -31.493   3.741  1.00 27.95           C  
ATOM    382  N   ASN A  48       8.767 -28.254   2.105  1.00 22.65           N  
ATOM    383  CA  ASN A  48       9.637 -29.068   2.940  1.00 23.55           C  
ATOM    384  C   ASN A  48      10.680 -29.787   2.092  1.00 23.99           C  
ATOM    385  O   ASN A  48      10.879 -30.993   2.222  1.00 25.02           O  
ATOM    386  CB  ASN A  48       8.811 -30.081   3.735  1.00 22.82           C  
ATOM    387  CG  ASN A  48       8.013 -29.428   4.838  1.00 23.73           C  
ATOM    388  OD1 ASN A  48       8.579 -28.883   5.791  1.00 21.50           O  
ATOM    389  ND2 ASN A  48       6.689 -29.468   4.716  1.00 24.83           N  
ATOM    390  N   GLY A  49      11.337 -29.035   1.213  1.00 23.60           N  
ATOM    391  CA  GLY A  49      12.373 -29.611   0.373  1.00 23.77           C  
ATOM    392  C   GLY A  49      11.902 -30.341  -0.869  1.00 24.67           C  
ATOM    393  O   GLY A  49      12.722 -30.877  -1.610  1.00 25.80           O  
ATOM    394  N   ASN A  50      10.593 -30.364  -1.102  1.00 24.57           N  
ATOM    395  CA  ASN A  50      10.026 -31.039  -2.271  1.00 25.67           C  
ATOM    396  C   ASN A  50       9.523 -30.010  -3.280  1.00 25.13           C  
ATOM    397  O   ASN A  50       8.637 -29.217  -2.968  1.00 24.79           O  
ATOM    398  CB  ASN A  50       8.852 -31.927  -1.848  1.00 25.61           C  
ATOM    399  CG  ASN A  50       9.275 -33.062  -0.936  1.00 27.74           C  
ATOM    400  OD1 ASN A  50       9.800 -34.078  -1.392  1.00 29.48           O  
ATOM    401  ND2 ASN A  50       9.052 -32.892   0.363  1.00 26.21           N  
ATOM    402  N   ALA A  51      10.073 -30.035  -4.491  1.00 25.84           N  
ATOM    403  CA  ALA A  51       9.662 -29.090  -5.521  1.00 26.39           C  
ATOM    404  C   ALA A  51       8.433 -29.569  -6.286  1.00 27.53           C  
ATOM    405  O   ALA A  51       8.378 -30.712  -6.744  1.00 27.11           O  
ATOM    406  CB  ALA A  51      10.813 -28.836  -6.494  1.00 25.97           C  
ATOM    407  N   VAL A  52       7.448 -28.687  -6.403  1.00 26.38           N  
ATOM    408  CA  VAL A  52       6.213 -28.968  -7.126  1.00 27.55           C  
ATOM    409  C   VAL A  52       6.138 -27.875  -8.184  1.00 28.24           C  
ATOM    410  O   VAL A  52       6.139 -26.689  -7.849  1.00 28.31           O  
ATOM    411  CB  VAL A  52       4.982 -28.882  -6.198  1.00 27.18           C  
ATOM    412  CG1 VAL A  52       3.712 -29.221  -6.978  1.00 27.58           C  
ATOM    413  CG2 VAL A  52       5.148 -29.835  -5.023  1.00 27.49           C  
ATOM    414  N   SER A  53       6.081 -28.268  -9.455  1.00 27.94           N  
ATOM    415  CA  SER A  53       6.060 -27.298 -10.547  1.00 29.29           C  
ATOM    416  C   SER A  53       4.804 -27.272 -11.416  1.00 29.73           C  
ATOM    417  O   SER A  53       4.311 -28.310 -11.858  1.00 28.43           O  
ATOM    418  CB  SER A  53       7.274 -27.525 -11.452  1.00 29.49           C  
ATOM    419  OG  SER A  53       8.484 -27.432 -10.720  1.00 35.21           O  
ATOM    420  N   GLY A  54       4.305 -26.067 -11.675  1.00 29.31           N  
ATOM    421  CA  GLY A  54       3.130 -25.926 -12.512  1.00 29.78           C  
ATOM    422  C   GLY A  54       1.824 -25.941 -11.752  1.00 28.96           C  
ATOM    423  O   GLY A  54       1.623 -26.736 -10.835  1.00 28.05           O  
ATOM    424  N   GLN A  55       0.927 -25.048 -12.151  1.00 29.88           N  
ATOM    425  CA  GLN A  55      -0.380 -24.922 -11.524  1.00 31.10           C  
ATOM    426  C   GLN A  55      -1.137 -26.253 -11.473  1.00 30.99           C  
ATOM    427  O   GLN A  55      -1.844 -26.534 -10.502  1.00 31.25           O  
ATOM    428  CB  GLN A  55      -1.190 -23.863 -12.276  1.00 31.25           C  
ATOM    429  CG  GLN A  55      -2.542 -23.534 -11.684  1.00 32.48           C  
ATOM    430  CD  GLN A  55      -3.215 -22.402 -12.430  1.00 33.78           C  
ATOM    431  OE1 GLN A  55      -3.308 -22.427 -13.656  1.00 34.97           O  
ATOM    432  NE2 GLN A  55      -3.684 -21.401 -11.697  1.00 32.17           N  
ATOM    433  N   GLU A  56      -0.989 -27.076 -12.507  1.00 32.04           N  
ATOM    434  CA  GLU A  56      -1.671 -28.370 -12.538  1.00 33.02           C  
ATOM    435  C   GLU A  56      -1.132 -29.293 -11.448  1.00 31.51           C  
ATOM    436  O   GLU A  56      -1.900 -29.923 -10.720  1.00 30.09           O  
ATOM    437  CB  GLU A  56      -1.496 -29.041 -13.902  1.00 37.39           C  
ATOM    438  CG  GLU A  56      -2.098 -28.273 -15.071  1.00 45.19           C  
ATOM    439  CD  GLU A  56      -3.595 -28.060 -14.934  1.00 49.37           C  
ATOM    440  OE1 GLU A  56      -4.334 -29.065 -14.837  1.00 52.82           O  
ATOM    441  OE2 GLU A  56      -4.034 -26.888 -14.926  1.00 51.21           O  
ATOM    442  N   SER A  57       0.191 -29.374 -11.337  1.00 29.96           N  
ATOM    443  CA  SER A  57       0.802 -30.218 -10.319  1.00 28.85           C  
ATOM    444  C   SER A  57       0.508 -29.654  -8.937  1.00 26.68           C  
ATOM    445  O   SER A  57       0.364 -30.401  -7.972  1.00 26.27           O  
ATOM    446  CB  SER A  57       2.315 -30.305 -10.526  1.00 30.69           C  
ATOM    447  OG  SER A  57       2.621 -30.941 -11.752  1.00 34.79           O  
ATOM    448  N   LEU A  58       0.426 -28.331  -8.842  1.00 25.45           N  
ATOM    449  CA  LEU A  58       0.141 -27.686  -7.563  1.00 25.08           C  
ATOM    450  C   LEU A  58      -1.264 -28.049  -7.097  1.00 24.79           C  
ATOM    451  O   LEU A  58      -1.484 -28.350  -5.922  1.00 24.69           O  
ATOM    452  CB  LEU A  58       0.269 -26.162  -7.692  1.00 23.07           C  
ATOM    453  CG  LEU A  58       1.702 -25.628  -7.790  1.00 23.44           C  
ATOM    454  CD1 LEU A  58       1.687 -24.157  -8.199  1.00 23.08           C  
ATOM    455  CD2 LEU A  58       2.402 -25.814  -6.449  1.00 22.46           C  
ATOM    456  N   SER A  59      -2.212 -28.022  -8.027  1.00 25.99           N  
ATOM    457  CA  SER A  59      -3.593 -28.356  -7.713  1.00 26.20           C  
ATOM    458  C   SER A  59      -3.680 -29.773  -7.146  1.00 26.65           C  
ATOM    459  O   SER A  59      -4.338 -30.012  -6.131  1.00 24.77           O  
ATOM    460  CB  SER A  59      -4.455 -28.242  -8.973  1.00 28.96           C  
ATOM    461  OG  SER A  59      -5.801 -28.575  -8.692  1.00 31.97           O  
ATOM    462  N   GLU A  60      -3.005 -30.710  -7.803  1.00 26.70           N  
ATOM    463  CA  GLU A  60      -3.003 -32.100  -7.361  1.00 28.92           C  
ATOM    464  C   GLU A  60      -2.330 -32.249  -6.002  1.00 28.11           C  
ATOM    465  O   GLU A  60      -2.769 -33.035  -5.162  1.00 26.68           O  
ATOM    466  CB  GLU A  60      -2.292 -32.971  -8.395  1.00 31.34           C  
ATOM    467  CG  GLU A  60      -3.149 -33.282  -9.610  1.00 37.49           C  
ATOM    468  CD  GLU A  60      -2.327 -33.652 -10.827  1.00 41.14           C  
ATOM    469  OE1 GLU A  60      -1.349 -34.417 -10.685  1.00 43.23           O  
ATOM    470  OE2 GLU A  60      -2.665 -33.180 -11.933  1.00 43.78           O  
ATOM    471  N   PHE A  61      -1.265 -31.484  -5.790  1.00 28.30           N  
ATOM    472  CA  PHE A  61      -0.529 -31.530  -4.534  1.00 28.57           C  
ATOM    473  C   PHE A  61      -1.421 -31.076  -3.383  1.00 28.90           C  
ATOM    474  O   PHE A  61      -1.471 -31.710  -2.325  1.00 28.60           O  
ATOM    475  CB  PHE A  61       0.701 -30.620  -4.610  1.00 29.61           C  
ATOM    476  CG  PHE A  61       1.553 -30.651  -3.375  1.00 31.37           C  
ATOM    477  CD1 PHE A  61       2.417 -31.717  -3.135  1.00 32.92           C  
ATOM    478  CD2 PHE A  61       1.478 -29.625  -2.438  1.00 33.06           C  
ATOM    479  CE1 PHE A  61       3.195 -31.761  -1.980  1.00 33.73           C  
ATOM    480  CE2 PHE A  61       2.251 -29.660  -1.277  1.00 33.84           C  
ATOM    481  CZ  PHE A  61       3.110 -30.729  -1.049  1.00 33.11           C  
ATOM    482  N   PHE A  62      -2.125 -29.968  -3.598  1.00 28.69           N  
ATOM    483  CA  PHE A  62      -3.017 -29.406  -2.588  1.00 30.35           C  
ATOM    484  C   PHE A  62      -4.197 -30.317  -2.260  1.00 30.88           C  
ATOM    485  O   PHE A  62      -4.612 -30.412  -1.105  1.00 29.09           O  
ATOM    486  CB  PHE A  62      -3.531 -28.044  -3.057  1.00 29.32           C  
ATOM    487  CG  PHE A  62      -2.461 -26.994  -3.157  1.00 30.72           C  
ATOM    488  CD1 PHE A  62      -2.557 -25.976  -4.101  1.00 31.94           C  
ATOM    489  CD2 PHE A  62      -1.365 -27.015  -2.299  1.00 29.83           C  
ATOM    490  CE1 PHE A  62      -1.569 -24.990  -4.193  1.00 32.95           C  
ATOM    491  CE2 PHE A  62      -0.372 -26.034  -2.382  1.00 32.24           C  
ATOM    492  CZ  PHE A  62      -0.477 -25.021  -3.331  1.00 30.39           C  
ATOM    493  N   GLU A  63      -4.752 -30.975  -3.270  1.00 34.40           N  
ATOM    494  CA  GLU A  63      -5.874 -31.866  -3.018  1.00 37.95           C  
ATOM    495  C   GLU A  63      -5.365 -33.134  -2.337  1.00 37.61           C  
ATOM    496  O   GLU A  63      -6.102 -33.804  -1.618  1.00 38.17           O  
ATOM    497  CB  GLU A  63      -6.607 -32.201  -4.322  1.00 41.98           C  
ATOM    498  CG  GLU A  63      -5.768 -32.873  -5.389  1.00 48.41           C  
ATOM    499  CD  GLU A  63      -6.584 -33.223  -6.621  1.00 51.93           C  
ATOM    500  OE1 GLU A  63      -7.192 -32.304  -7.217  1.00 54.46           O  
ATOM    501  OE2 GLU A  63      -6.618 -34.415  -6.999  1.00 53.50           O  
ATOM    502  N   MET A  64      -4.090 -33.437  -2.561  1.00 38.19           N  
ATOM    503  CA  MET A  64      -3.434 -34.605  -1.978  1.00 39.14           C  
ATOM    504  C   MET A  64      -3.245 -34.432  -0.469  1.00 38.07           C  
ATOM    505  O   MET A  64      -3.423 -35.375   0.304  1.00 36.63           O  
ATOM    506  CB  MET A  64      -2.069 -34.806  -2.646  1.00 42.91           C  
ATOM    507  CG  MET A  64      -1.168 -35.836  -1.988  1.00 47.55           C  
ATOM    508  SD  MET A  64       0.550 -35.688  -2.563  1.00 53.71           S  
ATOM    509  CE  MET A  64       0.453 -36.494  -4.152  1.00 52.10           C  
ATOM    510  N   LEU A  65      -2.879 -33.219  -0.060  1.00 36.41           N  
ATOM    511  CA  LEU A  65      -2.654 -32.908   1.347  1.00 35.14           C  
ATOM    512  C   LEU A  65      -3.912 -33.016   2.198  1.00 34.89           C  
ATOM    513  O   LEU A  65      -5.018 -32.733   1.734  1.00 33.42           O  
ATOM    514  CB  LEU A  65      -2.080 -31.494   1.495  1.00 36.27           C  
ATOM    515  CG  LEU A  65      -0.649 -31.247   1.018  1.00 37.51           C  
ATOM    516  CD1 LEU A  65      -0.308 -29.775   1.200  1.00 36.77           C  
ATOM    517  CD2 LEU A  65       0.318 -32.123   1.805  1.00 37.65           C  
ATOM    518  N   PRO A  66      -3.753 -33.420   3.469  1.00 34.36           N  
ATOM    519  CA  PRO A  66      -4.868 -33.568   4.410  1.00 34.32           C  
ATOM    520  C   PRO A  66      -5.537 -32.221   4.673  1.00 34.53           C  
ATOM    521  O   PRO A  66      -4.981 -31.170   4.347  1.00 33.38           O  
ATOM    522  CB  PRO A  66      -4.192 -34.105   5.673  1.00 34.04           C  
ATOM    523  CG  PRO A  66      -2.974 -34.806   5.149  1.00 34.39           C  
ATOM    524  CD  PRO A  66      -2.491 -33.853   4.091  1.00 35.09           C  
ATOM    525  N   SER A  67      -6.729 -32.260   5.263  1.00 33.57           N  
ATOM    526  CA  SER A  67      -7.461 -31.040   5.595  1.00 34.81           C  
ATOM    527  C   SER A  67      -6.584 -30.244   6.552  1.00 32.69           C  
ATOM    528  O   SER A  67      -5.795 -30.822   7.303  1.00 32.33           O  
ATOM    529  CB  SER A  67      -8.785 -31.382   6.272  1.00 36.12           C  
ATOM    530  OG  SER A  67      -9.606 -32.146   5.406  1.00 42.01           O  
ATOM    531  N   SER A  68      -6.720 -28.924   6.537  1.00 30.53           N  
ATOM    532  CA  SER A  68      -5.881 -28.098   7.392  1.00 28.75           C  
ATOM    533  C   SER A  68      -6.589 -27.026   8.198  1.00 28.01           C  
ATOM    534  O   SER A  68      -7.720 -26.634   7.909  1.00 26.59           O  
ATOM    535  CB  SER A  68      -4.803 -27.424   6.543  1.00 28.81           C  
ATOM    536  OG  SER A  68      -5.396 -26.539   5.605  1.00 26.46           O  
ATOM    537  N   GLU A  69      -5.879 -26.548   9.210  1.00 26.30           N  
ATOM    538  CA  GLU A  69      -6.342 -25.485  10.082  1.00 27.11           C  
ATOM    539  C   GLU A  69      -5.114 -24.626  10.368  1.00 26.52           C  
ATOM    540  O   GLU A  69      -4.255 -25.008  11.161  1.00 24.41           O  
ATOM    541  CB  GLU A  69      -6.906 -26.067  11.380  1.00 31.44           C  
ATOM    542  CG  GLU A  69      -7.259 -25.023  12.422  1.00 39.73           C  
ATOM    543  CD  GLU A  69      -8.366 -25.479  13.351  1.00 44.17           C  
ATOM    544  OE1 GLU A  69      -8.320 -26.640  13.813  1.00 48.09           O  
ATOM    545  OE2 GLU A  69      -9.281 -24.671  13.624  1.00 47.82           O  
ATOM    546  N   PHE A  70      -5.025 -23.480   9.697  1.00 24.66           N  
ATOM    547  CA  PHE A  70      -3.898 -22.565   9.869  1.00 24.04           C  
ATOM    548  C   PHE A  70      -4.212 -21.421  10.822  1.00 24.95           C  
ATOM    549  O   PHE A  70      -5.322 -20.896  10.834  1.00 24.88           O  
ATOM    550  CB  PHE A  70      -3.477 -21.952   8.524  1.00 23.91           C  
ATOM    551  CG  PHE A  70      -2.569 -22.823   7.703  1.00 21.57           C  
ATOM    552  CD1 PHE A  70      -3.080 -23.843   6.910  1.00 22.52           C  
ATOM    553  CD2 PHE A  70      -1.192 -22.605   7.709  1.00 21.05           C  
ATOM    554  CE1 PHE A  70      -2.233 -24.635   6.129  1.00 24.26           C  
ATOM    555  CE2 PHE A  70      -0.336 -23.387   6.936  1.00 19.84           C  
ATOM    556  CZ  PHE A  70      -0.852 -24.403   6.143  1.00 22.34           C  
ATOM    557  N   GLN A  71      -3.216 -21.042  11.615  1.00 24.47           N  
ATOM    558  CA  GLN A  71      -3.341 -19.936  12.550  1.00 26.87           C  
ATOM    559  C   GLN A  71      -2.152 -19.043  12.209  1.00 25.23           C  
ATOM    560  O   GLN A  71      -1.007 -19.391  12.491  1.00 23.25           O  
ATOM    561  CB  GLN A  71      -3.227 -20.428  13.996  1.00 30.95           C  
ATOM    562  CG  GLN A  71      -3.888 -19.515  15.030  1.00 40.86           C  
ATOM    563  CD  GLN A  71      -3.296 -18.114  15.063  1.00 46.07           C  
ATOM    564  OE1 GLN A  71      -2.108 -17.935  15.337  1.00 49.32           O  
ATOM    565  NE2 GLN A  71      -4.130 -17.112  14.793  1.00 47.56           N  
ATOM    566  N   ILE A  72      -2.423 -17.902  11.587  1.00 24.45           N  
ATOM    567  CA  ILE A  72      -1.358 -16.986  11.190  1.00 24.34           C  
ATOM    568  C   ILE A  72      -1.136 -15.902  12.237  1.00 24.35           C  
ATOM    569  O   ILE A  72      -2.072 -15.211  12.631  1.00 25.40           O  
ATOM    570  CB  ILE A  72      -1.691 -16.317   9.842  1.00 23.87           C  
ATOM    571  CG1 ILE A  72      -2.100 -17.382   8.816  1.00 23.84           C  
ATOM    572  CG2 ILE A  72      -0.496 -15.514   9.351  1.00 24.99           C  
ATOM    573  CD1 ILE A  72      -1.053 -18.455   8.563  1.00 22.65           C  
ATOM    574  N   SER A  73       0.107 -15.742  12.679  1.00 23.37           N  
ATOM    575  CA  SER A  73       0.407 -14.740  13.694  1.00 23.78           C  
ATOM    576  C   SER A  73       1.413 -13.681  13.260  1.00 22.88           C  
ATOM    577  O   SER A  73       1.451 -12.589  13.829  1.00 22.69           O  
ATOM    578  CB  SER A  73       0.917 -15.427  14.959  1.00 25.65           C  
ATOM    579  OG  SER A  73       2.016 -16.265  14.658  1.00 24.89           O  
ATOM    580  N   VAL A  74       2.226 -14.000  12.258  1.00 20.51           N  
ATOM    581  CA  VAL A  74       3.228 -13.053  11.785  1.00 20.44           C  
ATOM    582  C   VAL A  74       3.246 -12.939  10.266  1.00 17.74           C  
ATOM    583  O   VAL A  74       3.296 -13.946   9.567  1.00 19.27           O  
ATOM    584  CB  VAL A  74       4.651 -13.469  12.236  1.00 21.53           C  
ATOM    585  CG1 VAL A  74       5.654 -12.387  11.849  1.00 22.65           C  
ATOM    586  CG2 VAL A  74       4.678 -13.719  13.739  1.00 21.54           C  
ATOM    587  N   VAL A  75       3.191 -11.709   9.771  1.00 17.60           N  
ATOM    588  CA  VAL A  75       3.258 -11.442   8.339  1.00 18.15           C  
ATOM    589  C   VAL A  75       4.141 -10.218   8.127  1.00 17.44           C  
ATOM    590  O   VAL A  75       3.968  -9.199   8.792  1.00 18.21           O  
ATOM    591  CB  VAL A  75       1.867 -11.131   7.714  1.00 18.20           C  
ATOM    592  CG1 VAL A  75       2.031 -10.792   6.229  1.00 17.89           C  
ATOM    593  CG2 VAL A  75       0.938 -12.330   7.861  1.00 19.38           C  
ATOM    594  N   ASP A  76       5.106 -10.329   7.220  1.00 17.76           N  
ATOM    595  CA  ASP A  76       5.970  -9.202   6.901  1.00 16.83           C  
ATOM    596  C   ASP A  76       6.077  -9.226   5.381  1.00 16.84           C  
ATOM    597  O   ASP A  76       5.866 -10.265   4.765  1.00 18.12           O  
ATOM    598  CB  ASP A  76       7.347  -9.365   7.557  1.00 17.42           C  
ATOM    599  CG  ASP A  76       8.204  -8.110   7.444  1.00 18.51           C  
ATOM    600  OD1 ASP A  76       7.658  -7.018   7.174  1.00 19.25           O  
ATOM    601  OD2 ASP A  76       9.433  -8.213   7.641  1.00 19.50           O  
ATOM    602  N   CYS A  77       6.380  -8.090   4.768  1.00 16.99           N  
ATOM    603  CA  CYS A  77       6.467  -8.054   3.316  1.00 17.05           C  
ATOM    604  C   CYS A  77       7.346  -6.906   2.855  1.00 16.90           C  
ATOM    605  O   CYS A  77       7.598  -5.967   3.609  1.00 18.24           O  
ATOM    606  CB  CYS A  77       5.068  -7.891   2.720  1.00 17.50           C  
ATOM    607  SG  CYS A  77       4.291  -6.323   3.171  1.00 23.14           S  
ATOM    608  N   GLN A  78       7.811  -6.990   1.613  1.00 15.32           N  
ATOM    609  CA  GLN A  78       8.662  -5.950   1.056  1.00 17.24           C  
ATOM    610  C   GLN A  78       8.474  -5.854  -0.447  1.00 17.08           C  
ATOM    611  O   GLN A  78       8.252  -6.859  -1.121  1.00 15.94           O  
ATOM    612  CB  GLN A  78      10.145  -6.264   1.290  1.00 18.70           C  
ATOM    613  CG  GLN A  78      10.549  -6.660   2.697  1.00 17.61           C  
ATOM    614  CD  GLN A  78      12.031  -7.003   2.785  1.00 21.06           C  
ATOM    615  OE1 GLN A  78      12.695  -7.219   1.767  1.00 20.02           O  
ATOM    616  NE2 GLN A  78      12.553  -7.066   4.005  1.00 20.78           N  
ATOM    617  N   PRO A  79       8.557  -4.636  -0.992  1.00 18.01           N  
ATOM    618  CA  PRO A  79       8.407  -4.502  -2.442  1.00 18.28           C  
ATOM    619  C   PRO A  79       9.733  -5.028  -3.006  1.00 19.19           C  
ATOM    620  O   PRO A  79      10.798  -4.707  -2.477  1.00 19.07           O  
ATOM    621  CB  PRO A  79       8.232  -2.997  -2.631  1.00 18.95           C  
ATOM    622  CG  PRO A  79       9.030  -2.412  -1.489  1.00 20.84           C  
ATOM    623  CD  PRO A  79       8.660  -3.322  -0.335  1.00 19.25           C  
ATOM    624  N   VAL A  80       9.680  -5.855  -4.047  1.00 17.64           N  
ATOM    625  CA  VAL A  80      10.904  -6.407  -4.623  1.00 17.00           C  
ATOM    626  C   VAL A  80      11.551  -5.409  -5.585  1.00 17.92           C  
ATOM    627  O   VAL A  80      10.875  -4.812  -6.418  1.00 17.21           O  
ATOM    628  CB  VAL A  80      10.615  -7.742  -5.352  1.00 17.87           C  
ATOM    629  CG1 VAL A  80      11.907  -8.325  -5.926  1.00 18.05           C  
ATOM    630  CG2 VAL A  80       9.977  -8.737  -4.366  1.00 16.09           C  
ATOM    631  N   HIS A  81      12.862  -5.223  -5.460  1.00 18.58           N  
ATOM    632  CA  HIS A  81      13.578  -4.267  -6.307  1.00 19.99           C  
ATOM    633  C   HIS A  81      13.406  -4.551  -7.797  1.00 20.93           C  
ATOM    634  O   HIS A  81      13.431  -5.705  -8.222  1.00 19.12           O  
ATOM    635  CB  HIS A  81      15.068  -4.255  -5.945  1.00 20.58           C  
ATOM    636  CG  HIS A  81      15.811  -3.082  -6.502  1.00 22.04           C  
ATOM    637  ND1 HIS A  81      16.142  -2.978  -7.835  1.00 22.38           N  
ATOM    638  CD2 HIS A  81      16.245  -1.941  -5.915  1.00 23.59           C  
ATOM    639  CE1 HIS A  81      16.744  -1.821  -8.047  1.00 24.66           C  
ATOM    640  NE2 HIS A  81      16.818  -1.172  -6.899  1.00 24.95           N  
ATOM    641  N   ASP A  82      13.234  -3.484  -8.579  1.00 22.09           N  
ATOM    642  CA  ASP A  82      13.046  -3.569 -10.038  1.00 26.08           C  
ATOM    643  C   ASP A  82      14.112  -4.373 -10.766  1.00 25.62           C  
ATOM    644  O   ASP A  82      13.829  -5.008 -11.784  1.00 25.26           O  
ATOM    645  CB  ASP A  82      13.036  -2.176 -10.677  1.00 31.74           C  
ATOM    646  CG  ASP A  82      11.835  -1.362 -10.287  1.00 37.51           C  
ATOM    647  OD1 ASP A  82      10.735  -1.947 -10.178  1.00 41.29           O  
ATOM    648  OD2 ASP A  82      11.974  -0.127 -10.126  1.00 42.14           O  
ATOM    649  N   GLU A  83      15.342  -4.334 -10.261  1.00 24.86           N  
ATOM    650  CA  GLU A  83      16.427  -5.049 -10.916  1.00 25.71           C  
ATOM    651  C   GLU A  83      16.236  -6.561 -10.887  1.00 24.32           C  
ATOM    652  O   GLU A  83      16.693  -7.267 -11.783  1.00 24.33           O  
ATOM    653  CB  GLU A  83      17.767  -4.672 -10.285  1.00 28.18           C  
ATOM    654  CG  GLU A  83      18.961  -5.100 -11.121  1.00 34.82           C  
ATOM    655  CD  GLU A  83      20.262  -4.497 -10.635  1.00 36.26           C  
ATOM    656  OE1 GLU A  83      20.378  -3.251 -10.623  1.00 39.40           O  
ATOM    657  OE2 GLU A  83      21.170  -5.270 -10.270  1.00 40.69           O  
ATOM    658  N   ALA A  84      15.554  -7.059  -9.862  1.00 21.62           N  
ATOM    659  CA  ALA A  84      15.309  -8.493  -9.741  1.00 20.09           C  
ATOM    660  C   ALA A  84      14.138  -8.924 -10.626  1.00 19.09           C  
ATOM    661  O   ALA A  84      14.150 -10.021 -11.183  1.00 18.83           O  
ATOM    662  CB  ALA A  84      15.032  -8.856  -8.285  1.00 18.65           C  
ATOM    663  N   THR A  85      13.128  -8.067 -10.753  1.00 18.91           N  
ATOM    664  CA  THR A  85      11.963  -8.385 -11.580  1.00 19.73           C  
ATOM    665  C   THR A  85      11.625  -7.217 -12.502  1.00 19.83           C  
ATOM    666  O   THR A  85      10.645  -6.501 -12.298  1.00 19.56           O  
ATOM    667  CB  THR A  85      10.731  -8.727 -10.715  1.00 20.38           C  
ATOM    668  OG1 THR A  85      10.375  -7.599  -9.911  1.00 20.57           O  
ATOM    669  CG2 THR A  85      11.034  -9.913  -9.809  1.00 20.92           C  
ATOM    670  N   PRO A  86      12.442  -7.017 -13.544  1.00 20.32           N  
ATOM    671  CA  PRO A  86      12.250  -5.932 -14.515  1.00 20.79           C  
ATOM    672  C   PRO A  86      10.844  -5.944 -15.108  1.00 20.93           C  
ATOM    673  O   PRO A  86      10.327  -7.005 -15.459  1.00 19.95           O  
ATOM    674  CB  PRO A  86      13.307  -6.227 -15.580  1.00 21.69           C  
ATOM    675  CG  PRO A  86      14.373  -6.962 -14.827  1.00 23.41           C  
ATOM    676  CD  PRO A  86      13.572  -7.876 -13.934  1.00 20.58           C  
ATOM    677  N   SER A  87      10.235  -4.766 -15.209  1.00 19.72           N  
ATOM    678  CA  SER A  87       8.902  -4.618 -15.791  1.00 20.43           C  
ATOM    679  C   SER A  87       7.847  -5.492 -15.133  1.00 21.07           C  
ATOM    680  O   SER A  87       6.844  -5.832 -15.759  1.00 19.59           O  
ATOM    681  CB  SER A  87       8.948  -4.954 -17.287  1.00 20.47           C  
ATOM    682  OG  SER A  87       9.940  -4.188 -17.945  1.00 21.17           O  
ATOM    683  N   GLN A  88       8.059  -5.846 -13.873  1.00 20.05           N  
ATOM    684  CA  GLN A  88       7.116  -6.702 -13.165  1.00 21.37           C  
ATOM    685  C   GLN A  88       7.047  -6.276 -11.702  1.00 21.74           C  
ATOM    686  O   GLN A  88       8.052  -6.310 -10.999  1.00 24.89           O  
ATOM    687  CB  GLN A  88       7.581  -8.161 -13.262  1.00 20.40           C  
ATOM    688  CG  GLN A  88       6.685  -9.177 -12.549  1.00 19.77           C  
ATOM    689  CD  GLN A  88       7.286 -10.578 -12.512  1.00 19.19           C  
ATOM    690  OE1 GLN A  88       6.637 -11.535 -12.073  1.00 19.57           O  
ATOM    691  NE2 GLN A  88       8.527 -10.704 -12.964  1.00 15.85           N  
ATOM    692  N   THR A  89       5.865  -5.869 -11.248  1.00 20.58           N  
ATOM    693  CA  THR A  89       5.700  -5.449  -9.861  1.00 19.32           C  
ATOM    694  C   THR A  89       5.530  -6.685  -8.987  1.00 18.64           C  
ATOM    695  O   THR A  89       4.556  -7.424  -9.133  1.00 18.86           O  
ATOM    696  CB  THR A  89       4.467  -4.543  -9.692  1.00 19.97           C  
ATOM    697  OG1 THR A  89       4.609  -3.394 -10.537  1.00 20.58           O  
ATOM    698  CG2 THR A  89       4.331  -4.080  -8.232  1.00 21.72           C  
ATOM    699  N   THR A  90       6.482  -6.912  -8.087  1.00 17.09           N  
ATOM    700  CA  THR A  90       6.410  -8.070  -7.209  1.00 16.69           C  
ATOM    701  C   THR A  90       6.604  -7.701  -5.741  1.00 17.01           C  
ATOM    702  O   THR A  90       7.198  -6.670  -5.410  1.00 16.44           O  
ATOM    703  CB  THR A  90       7.441  -9.140  -7.612  1.00 17.35           C  
ATOM    704  OG1 THR A  90       8.761  -8.595  -7.530  1.00 20.08           O  
ATOM    705  CG2 THR A  90       7.188  -9.598  -9.045  1.00 16.79           C  
ATOM    706  N   VAL A  91       6.096  -8.562  -4.868  1.00 16.70           N  
ATOM    707  CA  VAL A  91       6.162  -8.344  -3.432  1.00 15.41           C  
ATOM    708  C   VAL A  91       6.539  -9.635  -2.722  1.00 16.62           C  
ATOM    709  O   VAL A  91       5.958 -10.687  -2.984  1.00 16.81           O  
ATOM    710  CB  VAL A  91       4.785  -7.867  -2.894  1.00 16.55           C  
ATOM    711  CG1 VAL A  91       4.783  -7.853  -1.363  1.00 17.40           C  
ATOM    712  CG2 VAL A  91       4.469  -6.479  -3.441  1.00 18.24           C  
ATOM    713  N   LEU A  92       7.529  -9.546  -1.841  1.00 15.45           N  
ATOM    714  CA  LEU A  92       7.970 -10.693  -1.062  1.00 16.38           C  
ATOM    715  C   LEU A  92       7.115 -10.726   0.198  1.00 16.02           C  
ATOM    716  O   LEU A  92       6.950  -9.707   0.871  1.00 16.70           O  
ATOM    717  CB  LEU A  92       9.446 -10.540  -0.673  1.00 16.83           C  
ATOM    718  CG  LEU A  92       9.994 -11.556   0.335  1.00 17.11           C  
ATOM    719  CD1 LEU A  92       9.888 -12.965  -0.227  1.00 16.85           C  
ATOM    720  CD2 LEU A  92      11.449 -11.212   0.668  1.00 16.72           C  
ATOM    721  N   VAL A  93       6.564 -11.894   0.509  1.00 15.83           N  
ATOM    722  CA  VAL A  93       5.733 -12.045   1.696  1.00 16.15           C  
ATOM    723  C   VAL A  93       6.301 -13.176   2.536  1.00 16.24           C  
ATOM    724  O   VAL A  93       6.628 -14.240   2.013  1.00 15.90           O  
ATOM    725  CB  VAL A  93       4.272 -12.390   1.325  1.00 15.76           C  
ATOM    726  CG1 VAL A  93       3.408 -12.399   2.581  1.00 17.30           C  
ATOM    727  CG2 VAL A  93       3.734 -11.384   0.304  1.00 15.54           C  
ATOM    728  N   VAL A  94       6.444 -12.935   3.836  1.00 17.52           N  
ATOM    729  CA  VAL A  94       6.958 -13.963   4.734  1.00 17.97           C  
ATOM    730  C   VAL A  94       5.929 -14.154   5.836  1.00 18.41           C  
ATOM    731  O   VAL A  94       5.440 -13.190   6.423  1.00 19.71           O  
ATOM    732  CB  VAL A  94       8.325 -13.570   5.337  1.00 21.38           C  
ATOM    733  CG1 VAL A  94       9.328 -13.362   4.211  1.00 21.23           C  
ATOM    734  CG2 VAL A  94       8.196 -12.318   6.179  1.00 23.97           C  
ATOM    735  N   ILE A  95       5.599 -15.412   6.102  1.00 19.35           N  
ATOM    736  CA  ILE A  95       4.579 -15.747   7.085  1.00 18.29           C  
ATOM    737  C   ILE A  95       5.060 -16.754   8.118  1.00 19.08           C  
ATOM    738  O   ILE A  95       5.870 -17.625   7.815  1.00 18.33           O  
ATOM    739  CB  ILE A  95       3.345 -16.367   6.377  1.00 18.53           C  
ATOM    740  CG1 ILE A  95       2.827 -15.415   5.298  1.00 17.89           C  
ATOM    741  CG2 ILE A  95       2.250 -16.696   7.389  1.00 17.73           C  
ATOM    742  CD1 ILE A  95       3.156 -15.866   3.894  1.00 19.19           C  
ATOM    743  N   CYS A  96       4.556 -16.613   9.339  1.00 20.23           N  
ATOM    744  CA  CYS A  96       4.870 -17.542  10.414  1.00 21.08           C  
ATOM    745  C   CYS A  96       3.578 -17.810  11.167  1.00 20.73           C  
ATOM    746  O   CYS A  96       2.769 -16.906  11.377  1.00 18.83           O  
ATOM    747  CB  CYS A  96       5.905 -16.970  11.383  1.00 23.83           C  
ATOM    748  SG  CYS A  96       6.344 -18.165  12.689  1.00 31.73           S  
ATOM    749  N   GLY A  97       3.385 -19.060  11.563  1.00 21.18           N  
ATOM    750  CA  GLY A  97       2.192 -19.417  12.300  1.00 22.26           C  
ATOM    751  C   GLY A  97       2.231 -20.886  12.641  1.00 21.95           C  
ATOM    752  O   GLY A  97       3.300 -21.497  12.672  1.00 20.42           O  
ATOM    753  N   SER A  98       1.063 -21.458  12.903  1.00 22.51           N  
ATOM    754  CA  SER A  98       0.978 -22.872  13.224  1.00 23.48           C  
ATOM    755  C   SER A  98      -0.049 -23.481  12.292  1.00 24.09           C  
ATOM    756  O   SER A  98      -0.886 -22.777  11.728  1.00 23.02           O  
ATOM    757  CB  SER A  98       0.536 -23.071  14.676  1.00 24.71           C  
ATOM    758  OG  SER A  98      -0.793 -22.625  14.863  1.00 29.34           O  
ATOM    759  N   VAL A  99       0.022 -24.793  12.122  1.00 24.26           N  
ATOM    760  CA  VAL A  99      -0.923 -25.473  11.262  1.00 25.62           C  
ATOM    761  C   VAL A  99      -1.149 -26.884  11.760  1.00 27.38           C  
ATOM    762  O   VAL A  99      -0.226 -27.544  12.242  1.00 26.45           O  
ATOM    763  CB  VAL A  99      -0.416 -25.554   9.807  1.00 25.93           C  
ATOM    764  CG1 VAL A  99       0.916 -26.288   9.757  1.00 24.66           C  
ATOM    765  CG2 VAL A  99      -1.445 -26.273   8.939  1.00 26.52           C  
ATOM    766  N   LYS A 100      -2.387 -27.342  11.657  1.00 28.12           N  
ATOM    767  CA  LYS A 100      -2.693 -28.695  12.062  1.00 29.10           C  
ATOM    768  C   LYS A 100      -3.287 -29.420  10.873  1.00 28.26           C  
ATOM    769  O   LYS A 100      -4.374 -29.077  10.412  1.00 28.59           O  
ATOM    770  CB  LYS A 100      -3.684 -28.718  13.227  1.00 31.05           C  
ATOM    771  CG  LYS A 100      -3.916 -30.125  13.768  1.00 33.82           C  
ATOM    772  CD  LYS A 100      -4.853 -30.133  14.958  1.00 36.63           C  
ATOM    773  CE  LYS A 100      -4.909 -31.517  15.588  1.00 37.65           C  
ATOM    774  NZ  LYS A 100      -5.285 -32.559  14.592  1.00 40.60           N  
ATOM    775  N   PHE A 101      -2.551 -30.388  10.342  1.00 28.37           N  
ATOM    776  CA  PHE A 101      -3.057 -31.173   9.231  1.00 30.20           C  
ATOM    777  C   PHE A 101      -3.738 -32.382   9.858  1.00 32.52           C  
ATOM    778  O   PHE A 101      -3.218 -32.968  10.810  1.00 30.26           O  
ATOM    779  CB  PHE A 101      -1.931 -31.648   8.308  1.00 29.96           C  
ATOM    780  CG  PHE A 101      -1.416 -30.585   7.380  1.00 30.22           C  
ATOM    781  CD1 PHE A 101      -0.315 -29.810   7.726  1.00 29.91           C  
ATOM    782  CD2 PHE A 101      -2.051 -30.346   6.164  1.00 30.20           C  
ATOM    783  CE1 PHE A 101       0.149 -28.808   6.874  1.00 29.64           C  
ATOM    784  CE2 PHE A 101      -1.594 -29.346   5.303  1.00 31.00           C  
ATOM    785  CZ  PHE A 101      -0.492 -28.576   5.662  1.00 29.90           C  
ATOM    786  N   GLU A 102      -4.904 -32.741   9.338  1.00 35.42           N  
ATOM    787  CA  GLU A 102      -5.645 -33.886   9.851  1.00 38.60           C  
ATOM    788  C   GLU A 102      -4.729 -35.106   9.873  1.00 38.66           C  
ATOM    789  O   GLU A 102      -4.111 -35.444   8.866  1.00 37.57           O  
ATOM    790  CB  GLU A 102      -6.854 -34.166   8.955  1.00 41.81           C  
ATOM    791  CG  GLU A 102      -7.790 -35.252   9.467  1.00 47.06           C  
ATOM    792  CD  GLU A 102      -8.436 -34.887  10.786  1.00 51.02           C  
ATOM    793  OE1 GLU A 102      -7.717 -34.818  11.808  1.00 54.25           O  
ATOM    794  OE2 GLU A 102      -9.667 -34.668  10.804  1.00 53.99           O  
ATOM    795  N   GLY A 103      -4.631 -35.758  11.027  1.00 40.72           N  
ATOM    796  CA  GLY A 103      -3.785 -36.935  11.125  1.00 42.07           C  
ATOM    797  C   GLY A 103      -2.440 -36.694  11.784  1.00 43.29           C  
ATOM    798  O   GLY A 103      -1.623 -37.608  11.885  1.00 43.75           O  
ATOM    799  N   ASN A 104      -2.201 -35.463  12.227  1.00 43.97           N  
ATOM    800  CA  ASN A 104      -0.949 -35.124  12.892  1.00 43.50           C  
ATOM    801  C   ASN A 104      -1.151 -33.967  13.860  1.00 41.61           C  
ATOM    802  O   ASN A 104      -2.146 -33.247  13.782  1.00 40.66           O  
ATOM    803  CB  ASN A 104       0.130 -34.781  11.862  1.00 46.81           C  
ATOM    804  CG  ASN A 104      -0.379 -33.870  10.772  1.00 50.90           C  
ATOM    805  OD1 ASN A 104      -0.799 -32.745  11.034  1.00 54.23           O  
ATOM    806  ND2 ASN A 104      -0.345 -34.354   9.535  1.00 52.24           N  
ATOM    807  N   LYS A 105      -0.209 -33.798  14.780  1.00 39.79           N  
ATOM    808  CA  LYS A 105      -0.303 -32.738  15.775  1.00 38.70           C  
ATOM    809  C   LYS A 105      -0.015 -31.367  15.178  1.00 36.64           C  
ATOM    810  O   LYS A 105       0.561 -31.256  14.097  1.00 34.10           O  
ATOM    811  CB  LYS A 105       0.666 -33.007  16.928  1.00 41.47           C  
ATOM    812  CG  LYS A 105       2.136 -33.010  16.527  1.00 45.49           C  
ATOM    813  CD  LYS A 105       3.056 -33.315  17.713  1.00 48.59           C  
ATOM    814  CE  LYS A 105       3.060 -32.198  18.753  1.00 50.69           C  
ATOM    815  NZ  LYS A 105       1.744 -32.006  19.430  1.00 52.03           N  
ATOM    816  N   GLN A 106      -0.428 -30.331  15.898  1.00 34.63           N  
ATOM    817  CA  GLN A 106      -0.218 -28.954  15.473  1.00 34.58           C  
ATOM    818  C   GLN A 106       1.279 -28.660  15.498  1.00 33.35           C  
ATOM    819  O   GLN A 106       1.983 -29.063  16.425  1.00 32.57           O  
ATOM    820  CB  GLN A 106      -0.949 -28.003  16.422  1.00 36.03           C  
ATOM    821  CG  GLN A 106      -0.729 -26.529  16.130  1.00 39.26           C  
ATOM    822  CD  GLN A 106      -1.360 -25.629  17.173  1.00 41.09           C  
ATOM    823  OE1 GLN A 106      -2.570 -25.667  17.393  1.00 43.64           O  
ATOM    824  NE2 GLN A 106      -0.541 -24.813  17.825  1.00 43.07           N  
ATOM    825  N   ARG A 107       1.765 -27.961  14.477  1.00 31.16           N  
ATOM    826  CA  ARG A 107       3.180 -27.625  14.405  1.00 28.48           C  
ATOM    827  C   ARG A 107       3.362 -26.235  13.808  1.00 27.12           C  
ATOM    828  O   ARG A 107       2.498 -25.746  13.081  1.00 25.38           O  
ATOM    829  CB  ARG A 107       3.921 -28.670  13.565  1.00 30.52           C  
ATOM    830  CG  ARG A 107       3.445 -28.774  12.129  1.00 31.02           C  
ATOM    831  CD  ARG A 107       3.684 -30.169  11.551  1.00 33.06           C  
ATOM    832  NE  ARG A 107       5.090 -30.562  11.580  1.00 33.25           N  
ATOM    833  CZ  ARG A 107       5.576 -31.633  10.960  1.00 32.03           C  
ATOM    834  NH1 ARG A 107       4.768 -32.420  10.261  1.00 33.17           N  
ATOM    835  NH2 ARG A 107       6.870 -31.911  11.028  1.00 33.16           N  
ATOM    836  N   ASP A 108       4.478 -25.593  14.134  1.00 24.35           N  
ATOM    837  CA  ASP A 108       4.748 -24.256  13.621  1.00 24.02           C  
ATOM    838  C   ASP A 108       5.386 -24.360  12.249  1.00 22.43           C  
ATOM    839  O   ASP A 108       5.979 -25.385  11.908  1.00 22.12           O  
ATOM    840  CB  ASP A 108       5.669 -23.489  14.572  1.00 25.98           C  
ATOM    841  CG  ASP A 108       5.074 -23.339  15.958  1.00 29.00           C  
ATOM    842  OD1 ASP A 108       3.867 -23.038  16.064  1.00 30.02           O  
ATOM    843  OD2 ASP A 108       5.820 -23.513  16.941  1.00 31.54           O  
ATOM    844  N   PHE A 109       5.267 -23.295  11.462  1.00 21.15           N  
ATOM    845  CA  PHE A 109       5.815 -23.296  10.114  1.00 19.48           C  
ATOM    846  C   PHE A 109       6.213 -21.892   9.697  1.00 19.58           C  
ATOM    847  O   PHE A 109       5.868 -20.909  10.348  1.00 18.45           O  
ATOM    848  CB  PHE A 109       4.751 -23.797   9.131  1.00 20.55           C  
ATOM    849  CG  PHE A 109       3.688 -22.768   8.825  1.00 20.31           C  
ATOM    850  CD1 PHE A 109       3.842 -21.882   7.756  1.00 20.46           C  
ATOM    851  CD2 PHE A 109       2.572 -22.636   9.646  1.00 20.93           C  
ATOM    852  CE1 PHE A 109       2.901 -20.876   7.514  1.00 20.80           C  
ATOM    853  CE2 PHE A 109       1.622 -21.631   9.413  1.00 21.03           C  
ATOM    854  CZ  PHE A 109       1.791 -20.750   8.345  1.00 22.59           C  
ATOM    855  N   ASN A 110       6.939 -21.817   8.592  1.00 19.72           N  
ATOM    856  CA  ASN A 110       7.337 -20.545   8.016  1.00 20.47           C  
ATOM    857  C   ASN A 110       7.077 -20.729   6.534  1.00 19.52           C  
ATOM    858  O   ASN A 110       7.328 -21.799   5.977  1.00 19.66           O  
ATOM    859  CB  ASN A 110       8.824 -20.246   8.251  1.00 22.94           C  
ATOM    860  CG  ASN A 110       9.138 -19.944   9.709  1.00 25.74           C  
ATOM    861  OD1 ASN A 110       9.234 -20.848  10.536  1.00 27.89           O  
ATOM    862  ND2 ASN A 110       9.290 -18.662  10.030  1.00 28.44           N  
ATOM    863  N   GLN A 111       6.547 -19.696   5.898  1.00 19.19           N  
ATOM    864  CA  GLN A 111       6.272 -19.777   4.477  1.00 19.23           C  
ATOM    865  C   GLN A 111       6.620 -18.435   3.876  1.00 18.32           C  
ATOM    866  O   GLN A 111       6.476 -17.399   4.520  1.00 18.17           O  
ATOM    867  CB  GLN A 111       4.791 -20.107   4.225  1.00 19.61           C  
ATOM    868  CG  GLN A 111       4.411 -20.181   2.740  1.00 19.78           C  
ATOM    869  CD  GLN A 111       3.034 -20.786   2.498  1.00 22.48           C  
ATOM    870  OE1 GLN A 111       2.262 -21.005   3.434  1.00 21.48           O  
ATOM    871  NE2 GLN A 111       2.719 -21.052   1.231  1.00 20.58           N  
ATOM    872  N   ASN A 112       7.121 -18.456   2.651  1.00 19.16           N  
ATOM    873  CA  ASN A 112       7.450 -17.213   1.983  1.00 19.29           C  
ATOM    874  C   ASN A 112       7.155 -17.382   0.512  1.00 18.37           C  
ATOM    875  O   ASN A 112       7.383 -18.443  -0.067  1.00 20.02           O  
ATOM    876  CB  ASN A 112       8.923 -16.819   2.230  1.00 19.47           C  
ATOM    877  CG  ASN A 112       9.922 -17.807   1.638  1.00 24.35           C  
ATOM    878  OD1 ASN A 112      10.325 -17.684   0.481  1.00 24.17           O  
ATOM    879  ND2 ASN A 112      10.333 -18.785   2.436  1.00 25.06           N  
ATOM    880  N   PHE A 113       6.578 -16.352  -0.085  1.00 17.79           N  
ATOM    881  CA  PHE A 113       6.296 -16.420  -1.497  1.00 17.49           C  
ATOM    882  C   PHE A 113       6.415 -15.058  -2.124  1.00 17.20           C  
ATOM    883  O   PHE A 113       6.412 -14.034  -1.432  1.00 17.40           O  
ATOM    884  CB  PHE A 113       4.914 -17.046  -1.773  1.00 18.74           C  
ATOM    885  CG  PHE A 113       3.793 -16.514  -0.919  1.00 20.97           C  
ATOM    886  CD1 PHE A 113       3.371 -15.193  -1.025  1.00 23.04           C  
ATOM    887  CD2 PHE A 113       3.110 -17.365  -0.053  1.00 24.44           C  
ATOM    888  CE1 PHE A 113       2.280 -14.729  -0.286  1.00 23.49           C  
ATOM    889  CE2 PHE A 113       2.018 -16.910   0.692  1.00 24.65           C  
ATOM    890  CZ  PHE A 113       1.603 -15.588   0.572  1.00 24.95           C  
ATOM    891  N   ILE A 114       6.571 -15.055  -3.438  1.00 16.46           N  
ATOM    892  CA  ILE A 114       6.681 -13.812  -4.171  1.00 17.09           C  
ATOM    893  C   ILE A 114       5.407 -13.645  -4.973  1.00 16.95           C  
ATOM    894  O   ILE A 114       5.051 -14.514  -5.778  1.00 17.06           O  
ATOM    895  CB  ILE A 114       7.902 -13.822  -5.110  1.00 16.53           C  
ATOM    896  CG1 ILE A 114       9.184 -13.873  -4.269  1.00 17.48           C  
ATOM    897  CG2 ILE A 114       7.888 -12.573  -5.993  1.00 16.86           C  
ATOM    898  CD1 ILE A 114      10.468 -14.000  -5.074  1.00 17.33           C  
ATOM    899  N   LEU A 115       4.710 -12.542  -4.716  1.00 16.38           N  
ATOM    900  CA  LEU A 115       3.465 -12.224  -5.408  1.00 17.60           C  
ATOM    901  C   LEU A 115       3.784 -11.315  -6.579  1.00 18.02           C  
ATOM    902  O   LEU A 115       4.684 -10.480  -6.493  1.00 18.25           O  
ATOM    903  CB  LEU A 115       2.497 -11.494  -4.474  1.00 17.65           C  
ATOM    904  CG  LEU A 115       1.967 -12.262  -3.261  1.00 17.67           C  
ATOM    905  CD1 LEU A 115       1.085 -11.342  -2.424  1.00 18.77           C  
ATOM    906  CD2 LEU A 115       1.178 -13.487  -3.736  1.00 19.20           C  
ATOM    907  N   THR A 116       3.038 -11.470  -7.667  1.00 18.13           N  
ATOM    908  CA  THR A 116       3.247 -10.645  -8.846  1.00 19.36           C  
ATOM    909  C   THR A 116       1.925  -9.974  -9.224  1.00 20.81           C  
ATOM    910  O   THR A 116       0.862 -10.604  -9.192  1.00 18.61           O  
ATOM    911  CB  THR A 116       3.801 -11.487 -10.025  1.00 20.46           C  
ATOM    912  OG1 THR A 116       4.011 -10.638 -11.160  1.00 21.94           O  
ATOM    913  CG2 THR A 116       2.842 -12.609 -10.390  1.00 19.93           C  
ATOM    914  N   ALA A 117       2.002  -8.689  -9.561  1.00 20.18           N  
ATOM    915  CA  ALA A 117       0.823  -7.909  -9.910  1.00 22.72           C  
ATOM    916  C   ALA A 117       0.391  -8.107 -11.355  1.00 25.55           C  
ATOM    917  O   ALA A 117       1.177  -7.946 -12.285  1.00 24.25           O  
ATOM    918  CB  ALA A 117       1.082  -6.433  -9.649  1.00 22.01           C  
ATOM    919  N   GLN A 118      -0.879  -8.443 -11.536  1.00 28.18           N  
ATOM    920  CA  GLN A 118      -1.436  -8.661 -12.867  1.00 33.75           C  
ATOM    921  C   GLN A 118      -2.505  -7.602 -13.097  1.00 34.01           C  
ATOM    922  O   GLN A 118      -3.576  -7.661 -12.496  1.00 33.03           O  
ATOM    923  CB  GLN A 118      -2.050 -10.060 -12.946  1.00 37.90           C  
ATOM    924  CG  GLN A 118      -2.451 -10.531 -14.345  1.00 46.36           C  
ATOM    925  CD  GLN A 118      -3.700  -9.851 -14.873  1.00 50.87           C  
ATOM    926  OE1 GLN A 118      -4.688  -9.680 -14.151  1.00 53.88           O  
ATOM    927  NE2 GLN A 118      -3.669  -9.475 -16.145  1.00 51.37           N  
ATOM    928  N   ALA A 119      -2.200  -6.618 -13.934  1.00 36.14           N  
ATOM    929  CA  ALA A 119      -3.149  -5.553 -14.239  1.00 40.21           C  
ATOM    930  C   ALA A 119      -4.289  -6.170 -15.033  1.00 43.27           C  
ATOM    931  O   ALA A 119      -4.101  -7.189 -15.684  1.00 43.98           O  
ATOM    932  CB  ALA A 119      -2.466  -4.469 -15.041  1.00 39.14           C  
ATOM    933  N   SER A 120      -5.463  -5.552 -14.999  1.00 47.43           N  
ATOM    934  CA  SER A 120      -6.617  -6.104 -15.704  1.00 51.95           C  
ATOM    935  C   SER A 120      -7.803  -5.137 -15.761  1.00 53.92           C  
ATOM    936  O   SER A 120      -7.750  -4.051 -15.182  1.00 54.47           O  
ATOM    937  CB  SER A 120      -7.039  -7.402 -15.010  1.00 52.36           C  
ATOM    938  OG  SER A 120      -6.824  -7.320 -13.603  1.00 55.93           O  
ATOM    939  N   PRO A 121      -8.892  -5.525 -16.459  1.00 55.76           N  
ATOM    940  CA  PRO A 121     -10.088  -4.685 -16.581  1.00 56.07           C  
ATOM    941  C   PRO A 121     -10.448  -4.033 -15.253  1.00 55.90           C  
ATOM    942  O   PRO A 121     -10.460  -2.806 -15.136  1.00 56.21           O  
ATOM    943  CB  PRO A 121     -11.150  -5.674 -17.038  1.00 57.02           C  
ATOM    944  CG  PRO A 121     -10.373  -6.569 -17.939  1.00 57.12           C  
ATOM    945  CD  PRO A 121      -9.103  -6.815 -17.144  1.00 56.62           C  
ATOM    946  N   SER A 122     -10.741  -4.857 -14.252  1.00 54.86           N  
ATOM    947  CA  SER A 122     -11.085  -4.338 -12.936  1.00 53.86           C  
ATOM    948  C   SER A 122      -9.813  -4.018 -12.157  1.00 52.99           C  
ATOM    949  O   SER A 122      -8.885  -3.408 -12.692  1.00 53.73           O  
ATOM    950  CB  SER A 122     -11.956  -5.342 -12.168  1.00 54.51           C  
ATOM    951  OG  SER A 122     -11.373  -6.632 -12.128  1.00 55.05           O  
ATOM    952  N   ASN A 123      -9.766  -4.440 -10.899  1.00 50.58           N  
ATOM    953  CA  ASN A 123      -8.615  -4.175 -10.046  1.00 48.03           C  
ATOM    954  C   ASN A 123      -7.418  -5.078 -10.341  1.00 44.75           C  
ATOM    955  O   ASN A 123      -7.530  -6.084 -11.047  1.00 43.92           O  
ATOM    956  CB  ASN A 123      -9.019  -4.323  -8.575  1.00 50.55           C  
ATOM    957  CG  ASN A 123     -10.155  -3.390  -8.183  1.00 53.17           C  
ATOM    958  OD1 ASN A 123     -10.623  -3.408  -7.043  1.00 55.25           O  
ATOM    959  ND2 ASN A 123     -10.604  -2.570  -9.126  1.00 53.92           N  
ATOM    960  N   THR A 124      -6.268  -4.698  -9.797  1.00 41.02           N  
ATOM    961  CA  THR A 124      -5.045  -5.469  -9.966  1.00 36.89           C  
ATOM    962  C   THR A 124      -5.183  -6.775  -9.192  1.00 33.29           C  
ATOM    963  O   THR A 124      -5.701  -6.791  -8.078  1.00 31.46           O  
ATOM    964  CB  THR A 124      -3.832  -4.689  -9.434  1.00 39.16           C  
ATOM    965  OG1 THR A 124      -3.574  -3.574 -10.298  1.00 42.27           O  
ATOM    966  CG2 THR A 124      -2.597  -5.581  -9.368  1.00 38.68           C  
ATOM    967  N   VAL A 125      -4.723  -7.865  -9.795  1.00 28.51           N  
ATOM    968  CA  VAL A 125      -4.792  -9.187  -9.182  1.00 27.54           C  
ATOM    969  C   VAL A 125      -3.391  -9.669  -8.809  1.00 24.33           C  
ATOM    970  O   VAL A 125      -2.501  -9.694  -9.654  1.00 22.31           O  
ATOM    971  CB  VAL A 125      -5.426 -10.207 -10.166  1.00 28.83           C  
ATOM    972  CG1 VAL A 125      -5.309 -11.617  -9.619  1.00 30.31           C  
ATOM    973  CG2 VAL A 125      -6.889  -9.853 -10.408  1.00 30.63           C  
ATOM    974  N   TRP A 126      -3.192 -10.041  -7.548  1.00 22.71           N  
ATOM    975  CA  TRP A 126      -1.887 -10.533  -7.121  1.00 21.26           C  
ATOM    976  C   TRP A 126      -1.892 -12.053  -7.080  1.00 21.22           C  
ATOM    977  O   TRP A 126      -2.795 -12.663  -6.503  1.00 21.10           O  
ATOM    978  CB  TRP A 126      -1.522  -9.983  -5.740  1.00 22.00           C  
ATOM    979  CG  TRP A 126      -1.353  -8.499  -5.720  1.00 21.96           C  
ATOM    980  CD1 TRP A 126      -2.339  -7.563  -5.599  1.00 23.31           C  
ATOM    981  CD2 TRP A 126      -0.125  -7.776  -5.858  1.00 22.54           C  
ATOM    982  NE1 TRP A 126      -1.798  -6.296  -5.652  1.00 23.55           N  
ATOM    983  CE2 TRP A 126      -0.440  -6.399  -5.810  1.00 22.80           C  
ATOM    984  CE3 TRP A 126       1.216  -8.160  -6.019  1.00 21.57           C  
ATOM    985  CZ2 TRP A 126       0.536  -5.401  -5.914  1.00 22.28           C  
ATOM    986  CZ3 TRP A 126       2.189  -7.166  -6.123  1.00 21.01           C  
ATOM    987  CH2 TRP A 126       1.840  -5.803  -6.070  1.00 22.51           C  
ATOM    988  N   LYS A 127      -0.889 -12.663  -7.701  1.00 20.22           N  
ATOM    989  CA  LYS A 127      -0.778 -14.115  -7.725  1.00 19.89           C  
ATOM    990  C   LYS A 127       0.610 -14.570  -7.315  1.00 19.98           C  
ATOM    991  O   LYS A 127       1.582 -13.843  -7.478  1.00 18.54           O  
ATOM    992  CB  LYS A 127      -1.091 -14.652  -9.122  1.00 21.22           C  
ATOM    993  CG  LYS A 127      -2.556 -14.524  -9.517  1.00 25.42           C  
ATOM    994  CD  LYS A 127      -2.833 -15.243 -10.826  1.00 27.48           C  
ATOM    995  CE  LYS A 127      -4.310 -15.200 -11.170  1.00 31.93           C  
ATOM    996  NZ  LYS A 127      -4.590 -15.917 -12.441  1.00 35.57           N  
ATOM    997  N   ILE A 128       0.694 -15.784  -6.785  1.00 18.74           N  
ATOM    998  CA  ILE A 128       1.973 -16.336  -6.359  1.00 18.00           C  
ATOM    999  C   ILE A 128       2.782 -16.794  -7.570  1.00 18.39           C  
ATOM   1000  O   ILE A 128       2.302 -17.578  -8.392  1.00 19.05           O  
ATOM   1001  CB  ILE A 128       1.770 -17.538  -5.403  1.00 17.55           C  
ATOM   1002  CG1 ILE A 128       1.141 -17.054  -4.094  1.00 19.09           C  
ATOM   1003  CG2 ILE A 128       3.105 -18.222  -5.128  1.00 16.55           C  
ATOM   1004  CD1 ILE A 128       0.656 -18.176  -3.178  1.00 19.99           C  
ATOM   1005  N   ALA A 129       4.007 -16.296  -7.685  1.00 17.49           N  
ATOM   1006  CA  ALA A 129       4.873 -16.678  -8.791  1.00 17.76           C  
ATOM   1007  C   ALA A 129       5.844 -17.752  -8.307  1.00 18.71           C  
ATOM   1008  O   ALA A 129       6.273 -18.616  -9.076  1.00 18.76           O  
ATOM   1009  CB  ALA A 129       5.644 -15.462  -9.301  1.00 17.61           C  
ATOM   1010  N   SER A 130       6.172 -17.697  -7.018  1.00 18.86           N  
ATOM   1011  CA  SER A 130       7.103 -18.642  -6.406  1.00 20.65           C  
ATOM   1012  C   SER A 130       6.689 -18.806  -4.944  1.00 20.09           C  
ATOM   1013  O   SER A 130       6.338 -17.828  -4.289  1.00 19.58           O  
ATOM   1014  CB  SER A 130       8.526 -18.089  -6.483  1.00 22.04           C  
ATOM   1015  OG  SER A 130       9.437 -18.955  -5.835  1.00 29.98           O  
ATOM   1016  N   ASP A 131       6.758 -20.032  -4.434  1.00 19.77           N  
ATOM   1017  CA  ASP A 131       6.339 -20.317  -3.064  1.00 19.77           C  
ATOM   1018  C   ASP A 131       7.314 -21.267  -2.363  1.00 19.10           C  
ATOM   1019  O   ASP A 131       7.944 -22.105  -3.006  1.00 18.00           O  
ATOM   1020  CB  ASP A 131       4.934 -20.936  -3.116  1.00 21.43           C  
ATOM   1021  CG  ASP A 131       4.253 -21.010  -1.761  1.00 23.13           C  
ATOM   1022  OD1 ASP A 131       4.730 -20.385  -0.786  1.00 22.42           O  
ATOM   1023  OD2 ASP A 131       3.207 -21.696  -1.682  1.00 25.42           O  
ATOM   1024  N   CYS A 132       7.429 -21.125  -1.045  1.00 18.93           N  
ATOM   1025  CA  CYS A 132       8.318 -21.967  -0.240  1.00 19.90           C  
ATOM   1026  C   CYS A 132       7.684 -22.161   1.136  1.00 20.24           C  
ATOM   1027  O   CYS A 132       7.351 -21.190   1.807  1.00 19.27           O  
ATOM   1028  CB  CYS A 132       9.688 -21.297  -0.094  1.00 21.23           C  
ATOM   1029  SG  CYS A 132      10.893 -22.259   0.857  1.00 24.54           S  
ATOM   1030  N   PHE A 133       7.524 -23.417   1.548  1.00 18.43           N  
ATOM   1031  CA  PHE A 133       6.906 -23.747   2.829  1.00 19.41           C  
ATOM   1032  C   PHE A 133       7.742 -24.793   3.560  1.00 17.70           C  
ATOM   1033  O   PHE A 133       8.211 -25.749   2.952  1.00 17.87           O  
ATOM   1034  CB  PHE A 133       5.497 -24.314   2.590  1.00 19.72           C  
ATOM   1035  CG  PHE A 133       4.799 -24.794   3.842  1.00 21.23           C  
ATOM   1036  CD1 PHE A 133       3.910 -23.967   4.521  1.00 20.29           C  
ATOM   1037  CD2 PHE A 133       5.039 -26.076   4.341  1.00 22.88           C  
ATOM   1038  CE1 PHE A 133       3.266 -24.405   5.681  1.00 22.97           C  
ATOM   1039  CE2 PHE A 133       4.401 -26.525   5.500  1.00 22.79           C  
ATOM   1040  CZ  PHE A 133       3.512 -25.688   6.171  1.00 21.00           C  
ATOM   1041  N   ARG A 134       7.919 -24.614   4.862  1.00 19.34           N  
ATOM   1042  CA  ARG A 134       8.680 -25.579   5.648  1.00 19.79           C  
ATOM   1043  C   ARG A 134       8.274 -25.560   7.118  1.00 20.15           C  
ATOM   1044  O   ARG A 134       8.153 -24.495   7.729  1.00 20.10           O  
ATOM   1045  CB  ARG A 134      10.185 -25.301   5.521  1.00 20.52           C  
ATOM   1046  CG  ARG A 134      11.070 -26.306   6.250  1.00 21.99           C  
ATOM   1047  CD  ARG A 134      12.550 -25.999   6.021  1.00 20.07           C  
ATOM   1048  NE  ARG A 134      13.020 -26.401   4.697  1.00 20.30           N  
ATOM   1049  CZ  ARG A 134      13.249 -27.660   4.335  1.00 21.71           C  
ATOM   1050  NH1 ARG A 134      13.048 -28.651   5.197  1.00 21.31           N  
ATOM   1051  NH2 ARG A 134      13.696 -27.931   3.115  1.00 19.90           N  
ATOM   1052  N   PHE A 135       8.046 -26.749   7.674  1.00 20.76           N  
ATOM   1053  CA  PHE A 135       7.686 -26.889   9.081  1.00 20.86           C  
ATOM   1054  C   PHE A 135       8.945 -26.587   9.885  1.00 23.12           C  
ATOM   1055  O   PHE A 135      10.043 -26.982   9.489  1.00 23.67           O  
ATOM   1056  CB  PHE A 135       7.269 -28.328   9.403  1.00 22.22           C  
ATOM   1057  CG  PHE A 135       5.987 -28.764   8.756  1.00 22.76           C  
ATOM   1058  CD1 PHE A 135       5.956 -29.903   7.960  1.00 23.58           C  
ATOM   1059  CD2 PHE A 135       4.804 -28.070   8.983  1.00 23.22           C  
ATOM   1060  CE1 PHE A 135       4.760 -30.353   7.397  1.00 23.63           C  
ATOM   1061  CE2 PHE A 135       3.603 -28.511   8.425  1.00 23.40           C  
ATOM   1062  CZ  PHE A 135       3.584 -29.656   7.632  1.00 23.91           C  
ATOM   1063  N   GLN A 136       8.794 -25.907  11.015  1.00 23.52           N  
ATOM   1064  CA  GLN A 136       9.949 -25.600  11.846  1.00 26.25           C  
ATOM   1065  C   GLN A 136      10.548 -26.904  12.386  1.00 28.40           C  
ATOM   1066  O   GLN A 136      11.740 -26.969  12.690  1.00 28.57           O  
ATOM   1067  CB  GLN A 136       9.547 -24.673  12.998  1.00 26.20           C  
ATOM   1068  CG  GLN A 136       8.988 -23.330  12.529  1.00 25.62           C  
ATOM   1069  CD  GLN A 136       8.808 -22.332  13.656  1.00 26.54           C  
ATOM   1070  OE1 GLN A 136       8.946 -22.672  14.834  1.00 26.73           O  
ATOM   1071  NE2 GLN A 136       8.493 -21.089  13.299  1.00 23.93           N  
ATOM   1072  N   ASP A 137       9.717 -27.942  12.483  1.00 28.46           N  
ATOM   1073  CA  ASP A 137      10.160 -29.248  12.978  1.00 30.36           C  
ATOM   1074  C   ASP A 137      10.037 -30.313  11.888  1.00 30.73           C  
ATOM   1075  O   ASP A 137       9.659 -31.455  12.158  1.00 30.66           O  
ATOM   1076  CB  ASP A 137       9.319 -29.655  14.197  1.00 31.56           C  
ATOM   1077  CG  ASP A 137       7.872 -29.952  13.838  1.00 33.39           C  
ATOM   1078  OD1 ASP A 137       7.382 -29.407  12.828  1.00 32.03           O  
ATOM   1079  OD2 ASP A 137       7.218 -30.723  14.573  1.00 36.20           O  
ATOM   1080  N   TRP A 138      10.374 -29.939  10.657  1.00 30.37           N  
ATOM   1081  CA  TRP A 138      10.273 -30.857   9.526  1.00 31.65           C  
ATOM   1082  C   TRP A 138      11.071 -32.151   9.688  1.00 34.06           C  
ATOM   1083  O   TRP A 138      10.675 -33.198   9.171  1.00 34.08           O  
ATOM   1084  CB  TRP A 138      10.723 -30.161   8.238  1.00 29.68           C  
ATOM   1085  CG  TRP A 138      12.187 -29.836   8.218  1.00 29.17           C  
ATOM   1086  CD1 TRP A 138      12.784 -28.700   8.683  1.00 28.01           C  
ATOM   1087  CD2 TRP A 138      13.244 -30.686   7.751  1.00 27.63           C  
ATOM   1088  NE1 TRP A 138      14.151 -28.790   8.536  1.00 27.52           N  
ATOM   1089  CE2 TRP A 138      14.459 -29.997   7.967  1.00 27.93           C  
ATOM   1090  CE3 TRP A 138      13.281 -31.963   7.173  1.00 27.67           C  
ATOM   1091  CZ2 TRP A 138      15.702 -30.545   7.624  1.00 27.42           C  
ATOM   1092  CZ3 TRP A 138      14.517 -32.508   6.833  1.00 27.30           C  
ATOM   1093  CH2 TRP A 138      15.711 -31.797   7.061  1.00 27.70           C  
ATOM   1094  N   ALA A 139      12.193 -32.075  10.397  1.00 36.21           N  
ATOM   1095  CA  ALA A 139      13.056 -33.236  10.602  1.00 40.25           C  
ATOM   1096  C   ALA A 139      12.421 -34.341  11.443  1.00 42.92           C  
ATOM   1097  O   ALA A 139      12.870 -35.487  11.412  1.00 44.05           O  
ATOM   1098  CB  ALA A 139      14.373 -32.794  11.231  1.00 38.80           C  
ATOM   1099  N   SER A 140      11.380 -34.002  12.196  1.00 45.60           N  
ATOM   1100  CA  SER A 140      10.709 -34.990  13.036  1.00 48.05           C  
ATOM   1101  C   SER A 140       9.247 -35.161  12.641  1.00 49.07           C  
ATOM   1102  O   SER A 140       8.364 -34.507  13.196  1.00 51.27           O  
ATOM   1103  CB  SER A 140      10.803 -34.581  14.508  1.00 48.81           C  
ATOM   1104  OG  SER A 140      10.221 -33.308  14.725  1.00 50.27           O  
TER    1105      SER A 140                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
