
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   79 (  601),  selected   79 , name 2fi0_A
# Molecule2: number of CA atoms   58 (  904),  selected   58 , name T0473.pdb
# PARAMETERS: 2fi0_A.T0473.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    M     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    N     7_A      -       -           -
LGA    I     8_A      K       2          3.483
LGA    I     9_A      I       3          2.357
LGA    D    10_A      T       4          3.538
LGA    V    11_A      K       5          2.329
LGA    S    12_A      D       6          1.293
LGA    I    13_A      M       7          2.984
LGA    P    14_A      I       8          2.307
LGA    V    15_A      I       9          1.321
LGA    A    16_A      A      10          0.949
LGA    E    17_A      D      11          1.349
LGA    V    18_A      V      12          1.419
LGA    V    19_A      L      13          0.671
LGA    D    20_A      Q      14          1.603
LGA    K    21_A      M      15          2.026
LGA    H    22_A      D      16          1.625
LGA    P    23_A      R      17          1.065
LGA    E    24_A      G      18          1.393
LGA    V    25_A      T      19          0.812
LGA    L    26_A      A      20          0.980
LGA    E    27_A      P      21          1.527
LGA    I    28_A      I      22          1.079
LGA    L    29_A      F      23          1.066
LGA    V    30_A      I      24          1.007
LGA    E    31_A      N      25          0.958
LGA    L    32_A      N      26          1.213
LGA    G    33_A      G      27          1.900
LGA    F    34_A      M      28          1.605
LGA    K    35_A      -       -           -
LGA    P    36_A      -       -           -
LGA    L    37_A      -       -           -
LGA    A    38_A      -       -           -
LGA    N    39_A      -       -           -
LGA    P    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    M    42_A      -       -           -
LGA    R    43_A      -       -           -
LGA    N    44_A      -       -           -
LGA    T    45_A      -       -           -
LGA    V    46_A      -       -           -
LGA    G    47_A      M      37          1.192
LGA    R    48_A      G      38          1.577
LGA    K    49_A      E      39          3.406
LGA    V    50_A      -       -           -
LGA    S    51_A      S      40          0.715
LGA    L    52_A      I      41          0.332
LGA    K    53_A      E      42          0.924
LGA    Q    54_A      D      43          0.587
LGA    G    55_A      A      44          1.140
LGA    S    56_A      C      45          1.283
LGA    K    57_A      A      46          1.020
LGA    L    58_A      V      47          1.244
LGA    A    59_A      H      48          1.980
LGA    G    60_A      G      49          1.368
LGA    T    61_A      I      50          1.575
LGA    P    62_A      D      51          1.848
LGA    M    63_A      A      52          2.438
LGA    D    64_A      D      53          2.266
LGA    K    65_A      K      54          1.580
LGA    I    66_A      L      55          1.394
LGA    V    67_A      V      56          3.004
LGA    R    68_A      K      57          3.094
LGA    T    69_A      E      58          2.123
LGA    L    70_A      L      59          2.464
LGA    E    71_A      N      60          3.607
LGA    A    72_A      E      61          3.571
LGA    N    73_A      Y      62          2.461
LGA    G    74_A      F      63          3.699
LGA    Y    75_A      E      64          4.140
LGA    E    76_A      K      65           -
LGA    V    77_A      K      66           -
LGA    I    78_A      E      67           -
LGA    G    79_A      -       -           -
LGA    L    80_A      -       -           -
LGA    D    81_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   79   58    5.0     55    2.04    20.00     83.439     2.572

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.491589 * X  +   0.392336 * Y  +  -0.777440 * Z  +  -0.282318
  Y_new =  -0.808225 * X  +  -0.126821 * Y  +  -0.575055 * Z  +  30.875643
  Z_new =  -0.324210 * X  +   0.911037 * Y  +   0.254752 * Z  +  -2.453624 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.298132   -1.843461  [ DEG:    74.3775   -105.6225 ]
  Theta =   0.330177    2.811416  [ DEG:    18.9177    161.0822 ]
  Phi   =  -1.024346    2.117247  [ DEG:   -58.6907    121.3093 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fi0_A                                        
REMARK     2: T0473.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fi0_A.T0473.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   79   58   5.0   55   2.04   20.00  83.439
REMARK  ---------------------------------------------------------- 
MOLECULE 2fi0_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-DEC-05   2FI0              
TITLE     THE CRYSTAL STRUCTURE OF THE CONSERVED DOMAIN PROTEIN FROM            
TITLE    2 STREPTOCOCCUS PNEUMONIAE TIGR4                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED DOMAIN PROTEIN;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: TIGR4;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    STRUCTURAL GENOMICS,STREPTOCOCCUS PNEUMONIAE, PSI, PROTEIN            
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,H.LI,J.ABDULLAH,F.COLLART,M.CYMBOROWSKI,W.MINOR,              
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   07-FEB-06 2FI0    0                                                
JRNL        AUTH   R.ZHANG,H.LI,J.ABDULLAH,F.COLLART,M.CYMBOROWSKI,             
JRNL        AUTH 2 W.MINOR,A.JOACHIMIAK                                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE CONSERVED DOMAIN                
JRNL        TITL 2 PROTEIN FROM STREPTOCOCCUS PNEUMONIAE TIGR4                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2FI0 A    1    81  GB     14972036 AAK74717         1     81             
SEQRES   1 A   81  MET GLU VAL VAL MET ASP ASN ILE ILE ASP VAL SER ILE          
SEQRES   2 A   81  PRO VAL ALA GLU VAL VAL ASP LYS HIS PRO GLU VAL LEU          
SEQRES   3 A   81  GLU ILE LEU VAL GLU LEU GLY PHE LYS PRO LEU ALA ASN          
SEQRES   4 A   81  PRO LEU MET ARG ASN THR VAL GLY ARG LYS VAL SER LEU          
SEQRES   5 A   81  LYS GLN GLY SER LYS LEU ALA GLY THR PRO MET ASP LYS          
SEQRES   6 A   81  ILE VAL ARG THR LEU GLU ALA ASN GLY TYR GLU VAL ILE          
SEQRES   7 A   81  GLY LEU ASP                                                  
FORMUL   2  HOH   *57(H2 O)                                                     
CRYST1   92.420   92.420   41.343  90.00  90.00 120.00 H 3           9          
ATOM      1  N   VAL A   3      -7.507   4.078  -5.759  1.00 59.19           N  
ATOM      2  CA  VAL A   3      -6.010   4.096  -5.790  1.00 59.23           C  
ATOM      3  C   VAL A   3      -5.400   3.221  -4.691  1.00 59.14           C  
ATOM      4  O   VAL A   3      -5.994   3.033  -3.624  1.00 59.27           O  
ATOM      5  CB  VAL A   3      -5.440   5.537  -5.659  1.00 59.36           C  
ATOM      6  CG1 VAL A   3      -6.152   6.486  -6.615  1.00 59.53           C  
ATOM      7  CG2 VAL A   3      -5.532   6.051  -4.217  1.00 59.70           C  
ATOM      8  N   VAL A   4      -4.207   2.698  -4.949  1.00 58.90           N  
ATOM      9  CA  VAL A   4      -3.518   1.885  -3.956  1.00 58.71           C  
ATOM     10  C   VAL A   4      -2.726   2.784  -3.009  1.00 58.46           C  
ATOM     11  O   VAL A   4      -2.007   3.697  -3.429  1.00 58.38           O  
ATOM     12  CB  VAL A   4      -2.629   0.824  -4.595  1.00 58.61           C  
ATOM     13  CG1 VAL A   4      -1.984  -0.036  -3.520  1.00 58.76           C  
ATOM     14  CG2 VAL A   4      -3.455  -0.026  -5.550  1.00 58.61           C  
ATOM     15  N   MET A   5      -2.894   2.516  -1.723  1.00 58.05           N  
ATOM     16  CA  MET A   5      -2.395   3.385  -0.670  1.00 57.82           C  
ATOM     17  C   MET A   5      -1.782   2.572   0.468  1.00 57.53           C  
ATOM     18  O   MET A   5      -0.748   2.936   1.024  1.00 57.44           O  
ATOM     19  CB  MET A   5      -3.556   4.218  -0.137  1.00 57.91           C  
ATOM     20  CG  MET A   5      -3.142   5.468   0.624  1.00 57.98           C  
ATOM     21  SD  MET A   5      -2.285   6.708  -0.360  1.00 55.46           S  
ATOM     22  CE  MET A   5      -3.218   6.737  -1.890  1.00 54.72           C  
ATOM     23  N   ASP A   6      -2.442   1.472   0.805  1.00 57.06           N  
ATOM     24  CA  ASP A   6      -2.040   0.623   1.901  1.00 56.44           C  
ATOM     25  C   ASP A   6      -1.673  -0.748   1.335  1.00 55.10           C  
ATOM     26  O   ASP A   6      -1.963  -1.059   0.168  1.00 55.33           O  
ATOM     27  CB  ASP A   6      -3.205   0.512   2.906  1.00 57.53           C  
ATOM     28  CG  ASP A   6      -3.723   1.873   3.360  1.00 61.29           C  
ATOM     29  OD1 ASP A   6      -2.909   2.826   3.429  1.00 67.59           O  
ATOM     30  OD2 ASP A   6      -4.939   2.006   3.666  1.00 66.09           O  
ATOM     31  N   ASN A   7      -1.031  -1.556   2.162  1.00 52.87           N  
ATOM     32  CA  ASN A   7      -0.745  -2.950   1.821  1.00 51.51           C  
ATOM     33  C   ASN A   7       0.187  -3.121   0.607  1.00 49.65           C  
ATOM     34  O   ASN A   7       0.021  -4.018  -0.194  1.00 48.93           O  
ATOM     35  CB  ASN A   7      -2.061  -3.745   1.676  1.00 51.76           C  
ATOM     36  CG  ASN A   7      -2.871  -3.785   2.982  1.00 52.98           C  
ATOM     37  OD1 ASN A   7      -2.413  -4.312   3.999  1.00 52.77           O  
ATOM     38  ND2 ASN A   7      -4.066  -3.188   2.960  1.00 55.32           N  
ATOM     39  N   ILE A   8       1.197  -2.262   0.523  1.00 47.57           N  
ATOM     40  CA  ILE A   8       2.207  -2.320  -0.525  1.00 46.42           C  
ATOM     41  C   ILE A   8       3.408  -3.086   0.037  1.00 45.49           C  
ATOM     42  O   ILE A   8       3.880  -2.780   1.132  1.00 44.57           O  
ATOM     43  CB  ILE A   8       2.621  -0.892  -0.971  1.00 45.73           C  
ATOM     44  CG1 ILE A   8       1.430  -0.174  -1.615  1.00 45.11           C  
ATOM     45  CG2 ILE A   8       3.810  -0.925  -1.920  1.00 45.62           C  
ATOM     46  CD1 ILE A   8       1.601   1.324  -1.658  1.00 45.35           C  
ATOM     47  N   ILE A   9       3.875  -4.082  -0.710  1.00 44.25           N  
ATOM     48  CA  ILE A   9       5.008  -4.904  -0.315  1.00 44.49           C  
ATOM     49  C   ILE A   9       6.111  -4.777  -1.354  1.00 43.58           C  
ATOM     50  O   ILE A   9       5.897  -4.998  -2.533  1.00 42.16           O  
ATOM     51  CB  ILE A   9       4.602  -6.377  -0.103  1.00 44.03           C  
ATOM     52  CG1 ILE A   9       3.702  -6.465   1.129  1.00 46.19           C  
ATOM     53  CG2 ILE A   9       5.860  -7.276   0.052  1.00 44.42           C  
ATOM     54  CD1 ILE A   9       3.082  -7.824   1.374  1.00 47.06           C  
ATOM     55  N   ASP A  10       7.288  -4.391  -0.886  1.00 43.67           N  
ATOM     56  CA  ASP A  10       8.455  -4.237  -1.727  1.00 43.88           C  
ATOM     57  C   ASP A  10       9.293  -5.516  -1.571  1.00 44.10           C  
ATOM     58  O   ASP A  10       9.732  -5.850  -0.470  1.00 44.04           O  
ATOM     59  CB  ASP A  10       9.228  -2.989  -1.285  1.00 43.53           C  
ATOM     60  CG  ASP A  10      10.312  -2.585  -2.267  1.00 43.79           C  
ATOM     61  OD1 ASP A  10      10.835  -3.462  -2.981  1.00 41.41           O  
ATOM     62  OD2 ASP A  10      10.648  -1.379  -2.314  1.00 43.97           O  
ATOM     63  N   VAL A  11       9.489  -6.239  -2.671  1.00 44.00           N  
ATOM     64  CA  VAL A  11      10.212  -7.507  -2.617  1.00 44.15           C  
ATOM     65  C   VAL A  11      11.724  -7.280  -2.678  1.00 44.09           C  
ATOM     66  O   VAL A  11      12.489  -8.234  -2.634  1.00 43.26           O  
ATOM     67  CB  VAL A  11       9.751  -8.510  -3.735  1.00 44.10           C  
ATOM     68  CG1 VAL A  11       8.295  -8.902  -3.543  1.00 44.36           C  
ATOM     69  CG2 VAL A  11       9.973  -7.946  -5.143  1.00 43.81           C  
ATOM     70  N   SER A  12      12.144  -6.018  -2.783  1.00 44.43           N  
ATOM     71  CA  SER A  12      13.558  -5.683  -2.902  1.00 45.08           C  
ATOM     72  C   SER A  12      14.208  -5.192  -1.620  1.00 45.27           C  
ATOM     73  O   SER A  12      15.386  -4.893  -1.634  1.00 46.46           O  
ATOM     74  CB  SER A  12      13.779  -4.647  -4.007  1.00 45.06           C  
ATOM     75  OG  SER A  12      13.399  -3.349  -3.587  1.00 45.99           O  
ATOM     76  N   ILE A  13      13.460  -5.115  -0.523  1.00 45.57           N  
ATOM     77  CA  ILE A  13      13.990  -4.673   0.767  1.00 45.58           C  
ATOM     78  C   ILE A  13      14.062  -5.880   1.725  1.00 46.02           C  
ATOM     79  O   ILE A  13      13.431  -6.904   1.468  1.00 46.15           O  
ATOM     80  CB  ILE A  13      13.128  -3.516   1.384  1.00 45.64           C  
ATOM     81  CG1 ILE A  13      11.714  -3.991   1.743  1.00 45.77           C  
ATOM     82  CG2 ILE A  13      13.063  -2.316   0.427  1.00 45.14           C  
ATOM     83  CD1 ILE A  13      10.936  -2.998   2.547  1.00 45.51           C  
ATOM     84  N   PRO A  14      14.839  -5.772   2.821  1.00 46.26           N  
ATOM     85  CA  PRO A  14      14.964  -6.898   3.757  1.00 46.49           C  
ATOM     86  C   PRO A  14      13.631  -7.426   4.288  1.00 46.48           C  
ATOM     87  O   PRO A  14      12.745  -6.649   4.599  1.00 46.49           O  
ATOM     88  CB  PRO A  14      15.818  -6.319   4.901  1.00 46.54           C  
ATOM     89  CG  PRO A  14      16.603  -5.234   4.263  1.00 46.42           C  
ATOM     90  CD  PRO A  14      15.680  -4.631   3.228  1.00 46.17           C  
ATOM     91  N   VAL A  15      13.501  -8.744   4.391  1.00 46.87           N  
ATOM     92  CA  VAL A  15      12.231  -9.354   4.791  1.00 47.71           C  
ATOM     93  C   VAL A  15      11.746  -8.849   6.165  1.00 47.55           C  
ATOM     94  O   VAL A  15      10.540  -8.675   6.381  1.00 46.93           O  
ATOM     95  CB  VAL A  15      12.297 -10.901   4.775  1.00 48.05           C  
ATOM     96  CG1 VAL A  15      10.992 -11.495   5.275  1.00 50.01           C  
ATOM     97  CG2 VAL A  15      12.532 -11.387   3.382  1.00 50.05           C  
ATOM     98  N   ALA A  16      12.682  -8.591   7.070  1.00 47.51           N  
ATOM     99  CA  ALA A  16      12.345  -8.023   8.387  1.00 47.97           C  
ATOM    100  C   ALA A  16      11.612  -6.668   8.295  1.00 48.05           C  
ATOM    101  O   ALA A  16      10.681  -6.408   9.066  1.00 47.74           O  
ATOM    102  CB  ALA A  16      13.596  -7.882   9.234  1.00 48.02           C  
ATOM    103  N   GLU A  17      12.040  -5.810   7.369  1.00 47.87           N  
ATOM    104  CA  GLU A  17      11.389  -4.515   7.170  1.00 48.06           C  
ATOM    105  C   GLU A  17       9.955  -4.682   6.655  1.00 47.41           C  
ATOM    106  O   GLU A  17       9.048  -3.932   7.027  1.00 47.07           O  
ATOM    107  CB  GLU A  17      12.172  -3.659   6.179  1.00 48.31           C  
ATOM    108  CG  GLU A  17      13.491  -3.164   6.697  1.00 49.55           C  
ATOM    109  CD  GLU A  17      14.206  -2.242   5.716  1.00 50.17           C  
ATOM    110  OE1 GLU A  17      13.519  -1.561   4.913  1.00 53.46           O  
ATOM    111  OE2 GLU A  17      15.462  -2.192   5.763  1.00 52.57           O  
ATOM    112  N   VAL A  18       9.768  -5.660   5.783  1.00 46.61           N  
ATOM    113  CA  VAL A  18       8.442  -5.986   5.302  1.00 46.66           C  
ATOM    114  C   VAL A  18       7.553  -6.386   6.490  1.00 46.27           C  
ATOM    115  O   VAL A  18       6.462  -5.868   6.644  1.00 45.10           O  
ATOM    116  CB  VAL A  18       8.462  -7.101   4.231  1.00 45.88           C  
ATOM    117  CG1 VAL A  18       7.061  -7.482   3.849  1.00 46.04           C  
ATOM    118  CG2 VAL A  18       9.234  -6.652   3.002  1.00 46.59           C  
ATOM    119  N   VAL A  19       8.044  -7.291   7.335  1.00 46.61           N  
ATOM    120  CA  VAL A  19       7.225  -7.878   8.394  1.00 46.82           C  
ATOM    121  C   VAL A  19       6.928  -6.857   9.501  1.00 47.07           C  
ATOM    122  O   VAL A  19       5.830  -6.849  10.047  1.00 46.44           O  
ATOM    123  CB  VAL A  19       7.869  -9.171   8.954  1.00 46.58           C  
ATOM    124  CG1 VAL A  19       7.120  -9.681  10.205  1.00 46.77           C  
ATOM    125  CG2 VAL A  19       7.896 -10.238   7.892  1.00 46.55           C  
ATOM    126  N   ASP A  20       7.904  -6.001   9.802  1.00 47.58           N  
ATOM    127  CA  ASP A  20       7.713  -4.891  10.724  1.00 48.32           C  
ATOM    128  C   ASP A  20       6.584  -3.968  10.279  1.00 48.48           C  
ATOM    129  O   ASP A  20       5.769  -3.542  11.091  1.00 47.49           O  
ATOM    130  CB  ASP A  20       9.010  -4.075  10.867  1.00 49.01           C  
ATOM    131  CG  ASP A  20      10.078  -4.798  11.682  1.00 50.50           C  
ATOM    132  OD1 ASP A  20       9.751  -5.746  12.437  1.00 52.97           O  
ATOM    133  OD2 ASP A  20      11.256  -4.405  11.570  1.00 53.15           O  
ATOM    134  N   LYS A  21       6.534  -3.667   8.983  1.00 48.55           N  
ATOM    135  CA  LYS A  21       5.490  -2.795   8.464  1.00 48.52           C  
ATOM    136  C   LYS A  21       4.154  -3.532   8.356  1.00 48.02           C  
ATOM    137  O   LYS A  21       3.104  -2.944   8.610  1.00 47.50           O  
ATOM    138  CB  LYS A  21       5.908  -2.225   7.113  1.00 48.88           C  
ATOM    139  CG  LYS A  21       4.907  -1.258   6.522  1.00 49.66           C  
ATOM    140  CD  LYS A  21       5.521  -0.462   5.364  1.00 50.26           C  
ATOM    141  CE  LYS A  21       4.974   0.971   5.325  1.00 51.82           C  
ATOM    142  NZ  LYS A  21       6.055   1.899   4.884  1.00 54.45           N  
ATOM    143  N   HIS A  22       4.199  -4.817   8.004  1.00 47.44           N  
ATOM    144  CA  HIS A  22       2.991  -5.623   7.812  1.00 47.54           C  
ATOM    145  C   HIS A  22       3.017  -6.915   8.645  1.00 47.27           C  
ATOM    146  O   HIS A  22       3.254  -7.992   8.083  1.00 46.73           O  
ATOM    147  CB  HIS A  22       2.854  -6.008   6.333  1.00 47.64           C  
ATOM    148  CG  HIS A  22       2.833  -4.843   5.393  1.00 48.13           C  
ATOM    149  ND1 HIS A  22       3.921  -4.497   4.622  1.00 49.25           N  
ATOM    150  CD2 HIS A  22       1.857  -3.953   5.088  1.00 49.18           C  
ATOM    151  CE1 HIS A  22       3.616  -3.446   3.882  1.00 48.16           C  
ATOM    152  NE2 HIS A  22       2.367  -3.101   4.139  1.00 49.58           N  
ATOM    153  N   PRO A  23       2.775  -6.825   9.976  1.00 47.14           N  
ATOM    154  CA  PRO A  23       2.839  -8.034  10.824  1.00 47.24           C  
ATOM    155  C   PRO A  23       1.952  -9.186  10.328  1.00 47.09           C  
ATOM    156  O   PRO A  23       2.335 -10.346  10.423  1.00 46.32           O  
ATOM    157  CB  PRO A  23       2.388  -7.542  12.212  1.00 47.49           C  
ATOM    158  CG  PRO A  23       2.552  -6.054  12.197  1.00 47.55           C  
ATOM    159  CD  PRO A  23       2.485  -5.606  10.749  1.00 47.22           C  
ATOM    160  N   GLU A  24       0.796  -8.847   9.770  1.00 47.49           N  
ATOM    161  CA  GLU A  24      -0.157  -9.832   9.214  1.00 47.80           C  
ATOM    162  C   GLU A  24       0.382 -10.639   8.025  1.00 47.55           C  
ATOM    163  O   GLU A  24      -0.152 -11.706   7.706  1.00 48.05           O  
ATOM    164  CB  GLU A  24      -1.460  -9.160   8.742  1.00 48.61           C  
ATOM    165  CG  GLU A  24      -1.677  -7.697   9.176  1.00 52.09           C  
ATOM    166  CD  GLU A  24      -0.822  -6.687   8.376  1.00 54.59           C  
ATOM    167  OE1 GLU A  24      -0.308  -5.734   9.029  1.00 55.39           O  
ATOM    168  OE2 GLU A  24      -0.675  -6.843   7.122  1.00 54.48           O  
ATOM    169  N   VAL A  25       1.403 -10.131   7.341  1.00 46.95           N  
ATOM    170  CA  VAL A  25       1.940 -10.837   6.179  1.00 46.44           C  
ATOM    171  C   VAL A  25       2.819 -12.032   6.576  1.00 46.16           C  
ATOM    172  O   VAL A  25       3.062 -12.901   5.749  1.00 45.06           O  
ATOM    173  CB  VAL A  25       2.705  -9.885   5.223  1.00 46.33           C  
ATOM    174  CG1 VAL A  25       4.141  -9.683   5.670  1.00 47.39           C  
ATOM    175  CG2 VAL A  25       2.655 -10.413   3.774  1.00 46.52           C  
ATOM    176  N   LEU A  26       3.271 -12.091   7.834  1.00 46.01           N  
ATOM    177  CA  LEU A  26       4.150 -13.184   8.281  1.00 46.37           C  
ATOM    178  C   LEU A  26       3.508 -14.567   8.081  1.00 46.53           C  
ATOM    179  O   LEU A  26       4.155 -15.491   7.596  1.00 46.52           O  
ATOM    180  CB  LEU A  26       4.567 -12.994   9.746  1.00 46.36           C  
ATOM    181  CG  LEU A  26       5.544 -14.021  10.334  1.00 46.21           C  
ATOM    182  CD1 LEU A  26       6.823 -14.093   9.504  1.00 46.69           C  
ATOM    183  CD2 LEU A  26       5.857 -13.698  11.786  1.00 46.06           C  
ATOM    184  N   GLU A  27       2.232 -14.687   8.430  1.00 47.09           N  
ATOM    185  CA  GLU A  27       1.467 -15.930   8.268  1.00 47.38           C  
ATOM    186  C   GLU A  27       1.452 -16.425   6.809  1.00 47.51           C  
ATOM    187  O   GLU A  27       1.394 -17.636   6.545  1.00 47.59           O  
ATOM    188  CB  GLU A  27       0.032 -15.701   8.742  1.00 47.43           C  
ATOM    189  CG  GLU A  27      -0.893 -16.908   8.616  1.00 48.31           C  
ATOM    190  CD  GLU A  27      -2.330 -16.601   9.028  1.00 49.27           C  
ATOM    191  OE1 GLU A  27      -2.836 -15.506   8.683  1.00 52.98           O  
ATOM    192  OE2 GLU A  27      -2.952 -17.467   9.686  1.00 51.91           O  
ATOM    193  N   ILE A  28       1.497 -15.480   5.873  1.00 47.31           N  
ATOM    194  CA  ILE A  28       1.552 -15.809   4.462  1.00 47.26           C  
ATOM    195  C   ILE A  28       2.953 -16.260   4.079  1.00 46.80           C  
ATOM    196  O   ILE A  28       3.110 -17.284   3.427  1.00 46.68           O  
ATOM    197  CB  ILE A  28       1.127 -14.610   3.588  1.00 47.25           C  
ATOM    198  CG1 ILE A  28      -0.338 -14.252   3.874  1.00 47.38           C  
ATOM    199  CG2 ILE A  28       1.325 -14.952   2.120  1.00 47.35           C  
ATOM    200  CD1 ILE A  28      -0.739 -12.875   3.414  1.00 47.97           C  
ATOM    201  N   LEU A  29       3.958 -15.493   4.490  1.00 46.66           N  
ATOM    202  CA  LEU A  29       5.350 -15.769   4.129  1.00 46.75           C  
ATOM    203  C   LEU A  29       5.856 -17.135   4.613  1.00 46.60           C  
ATOM    204  O   LEU A  29       6.640 -17.773   3.909  1.00 45.85           O  
ATOM    205  CB  LEU A  29       6.275 -14.657   4.650  1.00 46.52           C  
ATOM    206  CG  LEU A  29       6.024 -13.250   4.079  1.00 47.41           C  
ATOM    207  CD1 LEU A  29       7.091 -12.273   4.610  1.00 48.59           C  
ATOM    208  CD2 LEU A  29       5.999 -13.235   2.562  1.00 48.44           C  
ATOM    209  N   VAL A  30       5.410 -17.589   5.790  1.00 46.72           N  
ATOM    210  CA  VAL A  30       5.864 -18.882   6.320  1.00 47.13           C  
ATOM    211  C   VAL A  30       5.337 -20.056   5.502  1.00 47.25           C  
ATOM    212  O   VAL A  30       5.900 -21.154   5.547  1.00 47.01           O  
ATOM    213  CB  VAL A  30       5.516 -19.095   7.842  1.00 47.35           C  
ATOM    214  CG1 VAL A  30       6.089 -17.962   8.695  1.00 46.46           C  
ATOM    215  CG2 VAL A  30       4.004 -19.267   8.063  1.00 47.78           C  
ATOM    216  N   GLU A  31       4.257 -19.821   4.761  1.00 47.75           N  
ATOM    217  CA  GLU A  31       3.742 -20.800   3.807  1.00 48.27           C  
ATOM    218  C   GLU A  31       4.414 -20.681   2.429  1.00 48.46           C  
ATOM    219  O   GLU A  31       4.093 -21.453   1.535  1.00 48.73           O  
ATOM    220  CB  GLU A  31       2.222 -20.652   3.665  1.00 48.56           C  
ATOM    221  CG  GLU A  31       1.442 -20.940   4.948  1.00 50.03           C  
ATOM    222  CD  GLU A  31       1.598 -22.383   5.428  1.00 52.28           C  
ATOM    223  OE1 GLU A  31       1.644 -22.619   6.661  1.00 54.44           O  
ATOM    224  OE2 GLU A  31       1.684 -23.290   4.571  1.00 54.33           O  
ATOM    225  N   LEU A  32       5.339 -19.733   2.264  1.00 48.51           N  
ATOM    226  CA  LEU A  32       6.009 -19.494   0.977  1.00 48.64           C  
ATOM    227  C   LEU A  32       7.536 -19.699   1.043  1.00 48.80           C  
ATOM    228  O   LEU A  32       8.281 -19.182   0.204  1.00 49.11           O  
ATOM    229  CB  LEU A  32       5.707 -18.083   0.485  1.00 48.49           C  
ATOM    230  CG  LEU A  32       4.259 -17.773   0.083  1.00 48.55           C  
ATOM    231  CD1 LEU A  32       4.099 -16.287  -0.058  1.00 49.39           C  
ATOM    232  CD2 LEU A  32       3.877 -18.475  -1.196  1.00 47.49           C  
ATOM    233  N   GLY A  33       7.989 -20.452   2.035  1.00 48.82           N  
ATOM    234  CA  GLY A  33       9.411 -20.799   2.171  1.00 48.92           C  
ATOM    235  C   GLY A  33      10.183 -19.959   3.174  1.00 48.60           C  
ATOM    236  O   GLY A  33      11.406 -20.026   3.227  1.00 48.42           O  
ATOM    237  N   PHE A  34       9.477 -19.157   3.961  1.00 48.66           N  
ATOM    238  CA  PHE A  34      10.118 -18.251   4.919  1.00 49.11           C  
ATOM    239  C   PHE A  34       9.782 -18.643   6.349  1.00 49.09           C  
ATOM    240  O   PHE A  34       9.806 -17.805   7.254  1.00 49.41           O  
ATOM    241  CB  PHE A  34       9.707 -16.798   4.642  1.00 48.95           C  
ATOM    242  CG  PHE A  34      10.195 -16.285   3.326  1.00 49.17           C  
ATOM    243  CD1 PHE A  34      11.447 -15.703   3.220  1.00 48.46           C  
ATOM    244  CD2 PHE A  34       9.410 -16.400   2.179  1.00 49.01           C  
ATOM    245  CE1 PHE A  34      11.910 -15.237   1.999  1.00 48.67           C  
ATOM    246  CE2 PHE A  34       9.874 -15.939   0.960  1.00 49.45           C  
ATOM    247  CZ  PHE A  34      11.129 -15.359   0.873  1.00 48.97           C  
ATOM    248  N   LYS A  35       9.513 -19.927   6.564  1.00 49.36           N  
ATOM    249  CA  LYS A  35       8.963 -20.361   7.846  1.00 49.64           C  
ATOM    250  C   LYS A  35       9.960 -20.320   9.013  1.00 49.52           C  
ATOM    251  O   LYS A  35       9.535 -20.154  10.164  1.00 49.18           O  
ATOM    252  CB  LYS A  35       8.233 -21.711   7.713  1.00 50.07           C  
ATOM    253  CG  LYS A  35       9.018 -22.981   7.988  1.00 51.18           C  
ATOM    254  CD  LYS A  35       8.518 -23.663   9.259  1.00 52.96           C  
ATOM    255  CE  LYS A  35       7.081 -24.191   9.101  1.00 53.48           C  
ATOM    256  NZ  LYS A  35       6.686 -25.054  10.271  1.00 53.48           N  
ATOM    257  N   PRO A  36      11.281 -20.446   8.733  1.00 49.65           N  
ATOM    258  CA  PRO A  36      12.227 -20.166   9.819  1.00 49.79           C  
ATOM    259  C   PRO A  36      12.129 -18.727  10.332  1.00 49.83           C  
ATOM    260  O   PRO A  36      12.529 -18.444  11.448  1.00 50.27           O  
ATOM    261  CB  PRO A  36      13.601 -20.411   9.172  1.00 49.91           C  
ATOM    262  CG  PRO A  36      13.330 -21.259   7.989  1.00 49.75           C  
ATOM    263  CD  PRO A  36      11.986 -20.858   7.504  1.00 49.35           C  
ATOM    264  N   LEU A  37      11.590 -17.820   9.534  1.00 49.74           N  
ATOM    265  CA  LEU A  37      11.489 -16.437   9.976  1.00 49.94           C  
ATOM    266  C   LEU A  37      10.235 -16.179  10.821  1.00 49.47           C  
ATOM    267  O   LEU A  37       9.969 -15.041  11.162  1.00 49.45           O  
ATOM    268  CB  LEU A  37      11.553 -15.480   8.776  1.00 50.28           C  
ATOM    269  CG  LEU A  37      12.694 -15.715   7.764  1.00 51.03           C  
ATOM    270  CD1 LEU A  37      13.016 -14.431   7.014  1.00 51.11           C  
ATOM    271  CD2 LEU A  37      13.954 -16.236   8.411  1.00 51.68           C  
ATOM    272  N   ALA A  38       9.465 -17.223  11.142  1.00 48.98           N  
ATOM    273  CA  ALA A  38       8.345 -17.097  12.088  1.00 48.83           C  
ATOM    274  C   ALA A  38       8.869 -16.632  13.439  1.00 48.60           C  
ATOM    275  O   ALA A  38       8.254 -15.792  14.100  1.00 49.27           O  
ATOM    276  CB  ALA A  38       7.608 -18.433  12.258  1.00 48.91           C  
ATOM    277  N   ASN A  39       9.999 -17.209  13.848  1.00 47.98           N  
ATOM    278  CA  ASN A  39      10.672 -16.829  15.079  1.00 47.36           C  
ATOM    279  C   ASN A  39      11.377 -15.472  14.913  1.00 46.66           C  
ATOM    280  O   ASN A  39      12.169 -15.295  13.976  1.00 46.43           O  
ATOM    281  CB  ASN A  39      11.673 -17.920  15.488  1.00 47.47           C  
ATOM    282  CG  ASN A  39      12.266 -17.683  16.862  1.00 48.44           C  
ATOM    283  OD1 ASN A  39      13.211 -16.909  17.012  1.00 50.91           O  
ATOM    284  ND2 ASN A  39      11.721 -18.360  17.878  1.00 49.42           N  
ATOM    285  N   PRO A  40      11.080 -14.505  15.813  1.00 45.89           N  
ATOM    286  CA  PRO A  40      11.668 -13.166  15.757  1.00 45.51           C  
ATOM    287  C   PRO A  40      13.187 -13.132  15.716  1.00 45.00           C  
ATOM    288  O   PRO A  40      13.751 -12.326  14.989  1.00 44.66           O  
ATOM    289  CB  PRO A  40      11.166 -12.506  17.041  1.00 45.31           C  
ATOM    290  CG  PRO A  40       9.956 -13.232  17.401  1.00 45.63           C  
ATOM    291  CD  PRO A  40      10.126 -14.628  16.935  1.00 45.79           C  
ATOM    292  N   LEU A  41      13.843 -13.979  16.512  1.00 44.89           N  
ATOM    293  CA  LEU A  41      15.300 -14.014  16.552  1.00 44.99           C  
ATOM    294  C   LEU A  41      15.862 -14.350  15.164  1.00 44.79           C  
ATOM    295  O   LEU A  41      16.768 -13.666  14.690  1.00 43.98           O  
ATOM    296  CB  LEU A  41      15.804 -15.001  17.618  1.00 44.73           C  
ATOM    297  CG  LEU A  41      17.319 -15.183  17.753  1.00 44.83           C  
ATOM    298  CD1 LEU A  41      18.022 -13.859  18.035  1.00 45.10           C  
ATOM    299  CD2 LEU A  41      17.621 -16.184  18.841  1.00 45.04           C  
ATOM    300  N   MET A  42      15.300 -15.371  14.513  1.00 45.19           N  
ATOM    301  CA  MET A  42      15.720 -15.747  13.152  1.00 45.75           C  
ATOM    302  C   MET A  42      15.388 -14.648  12.148  1.00 46.32           C  
ATOM    303  O   MET A  42      16.232 -14.253  11.348  1.00 46.38           O  
ATOM    304  CB  MET A  42      15.047 -17.043  12.672  1.00 45.83           C  
ATOM    305  CG  MET A  42      15.482 -18.366  13.313  1.00 45.61           C  
ATOM    306  SD  MET A  42      17.252 -18.772  13.389  1.00 45.99           S  
ATOM    307  CE  MET A  42      17.710 -18.173  11.760  1.00 45.15           C  
ATOM    308  N   ARG A  43      14.149 -14.164  12.185  1.00 46.92           N  
ATOM    309  CA  ARG A  43      13.724 -13.108  11.275  1.00 47.41           C  
ATOM    310  C   ARG A  43      14.556 -11.831  11.429  1.00 47.89           C  
ATOM    311  O   ARG A  43      14.806 -11.131  10.447  1.00 48.19           O  
ATOM    312  CB  ARG A  43      12.246 -12.781  11.477  1.00 47.53           C  
ATOM    313  CG  ARG A  43      11.715 -11.725  10.518  1.00 47.35           C  
ATOM    314  CD  ARG A  43      10.200 -11.551  10.636  1.00 47.82           C  
ATOM    315  NE  ARG A  43       9.783 -10.935  11.897  1.00 46.74           N  
ATOM    316  CZ  ARG A  43       9.275 -11.586  12.941  1.00 47.18           C  
ATOM    317  NH1 ARG A  43       9.087 -12.899  12.919  1.00 47.80           N  
ATOM    318  NH2 ARG A  43       8.934 -10.906  14.027  1.00 47.98           N  
ATOM    319  N   ASN A  44      14.984 -11.517  12.645  1.00 47.83           N  
ATOM    320  CA  ASN A  44      15.779 -10.309  12.852  1.00 48.43           C  
ATOM    321  C   ASN A  44      17.292 -10.537  12.739  1.00 48.88           C  
ATOM    322  O   ASN A  44      18.079  -9.631  13.032  1.00 48.85           O  
ATOM    323  CB  ASN A  44      15.388  -9.639  14.164  1.00 48.32           C  
ATOM    324  CG  ASN A  44      13.957  -9.103  14.139  1.00 48.91           C  
ATOM    325  OD1 ASN A  44      13.245  -9.167  15.139  1.00 51.21           O  
ATOM    326  ND2 ASN A  44      13.539  -8.562  12.996  1.00 46.89           N  
ATOM    327  N   THR A  45      17.680 -11.740  12.305  1.00 49.34           N  
ATOM    328  CA  THR A  45      19.067 -12.046  11.938  1.00 49.96           C  
ATOM    329  C   THR A  45      19.148 -12.285  10.418  1.00 50.42           C  
ATOM    330  O   THR A  45      19.526 -11.378   9.664  1.00 50.23           O  
ATOM    331  CB  THR A  45      19.637 -13.253  12.737  1.00 49.92           C  
ATOM    332  OG1 THR A  45      18.770 -14.389  12.609  1.00 50.02           O  
ATOM    333  CG2 THR A  45      19.798 -12.901  14.213  1.00 49.82           C  
ATOM    334  N   VAL A  46      18.761 -13.479   9.964  1.00 51.03           N  
ATOM    335  CA  VAL A  46      18.774 -13.777   8.520  1.00 51.20           C  
ATOM    336  C   VAL A  46      17.860 -12.838   7.719  1.00 51.20           C  
ATOM    337  O   VAL A  46      18.232 -12.408   6.623  1.00 51.20           O  
ATOM    338  CB  VAL A  46      18.446 -15.279   8.188  1.00 51.59           C  
ATOM    339  CG1 VAL A  46      17.121 -15.725   8.782  1.00 52.26           C  
ATOM    340  CG2 VAL A  46      18.419 -15.512   6.670  1.00 51.87           C  
ATOM    341  N   GLY A  47      16.692 -12.515   8.274  1.00 51.10           N  
ATOM    342  CA  GLY A  47      15.701 -11.651   7.614  1.00 51.18           C  
ATOM    343  C   GLY A  47      16.108 -10.192   7.442  1.00 51.14           C  
ATOM    344  O   GLY A  47      15.491  -9.462   6.659  1.00 51.36           O  
ATOM    345  N   ARG A  48      17.147  -9.750   8.154  1.00 51.17           N  
ATOM    346  CA  ARG A  48      17.689  -8.406   7.919  1.00 51.17           C  
ATOM    347  C   ARG A  48      18.714  -8.390   6.750  1.00 50.62           C  
ATOM    348  O   ARG A  48      19.050  -7.334   6.212  1.00 50.05           O  
ATOM    349  CB  ARG A  48      18.232  -7.775   9.223  1.00 51.48           C  
ATOM    350  CG  ARG A  48      17.288  -6.693   9.825  1.00 53.73           C  
ATOM    351  CD  ARG A  48      16.752  -6.968  11.239  1.00 56.77           C  
ATOM    352  NE  ARG A  48      17.549  -6.273  12.266  1.00 58.25           N  
ATOM    353  CZ  ARG A  48      17.136  -5.908  13.489  1.00 57.94           C  
ATOM    354  NH1 ARG A  48      15.906  -6.162  13.933  1.00 58.08           N  
ATOM    355  NH2 ARG A  48      17.980  -5.273  14.289  1.00 58.74           N  
ATOM    356  N   LYS A  49      19.173  -9.570   6.344  1.00 50.35           N  
ATOM    357  CA  LYS A  49      20.129  -9.702   5.247  1.00 50.15           C  
ATOM    358  C   LYS A  49      19.473 -10.079   3.918  1.00 49.83           C  
ATOM    359  O   LYS A  49      20.051  -9.849   2.846  1.00 50.31           O  
ATOM    360  CB  LYS A  49      21.153 -10.781   5.588  1.00 50.20           C  
ATOM    361  CG  LYS A  49      21.988 -10.504   6.811  1.00 50.54           C  
ATOM    362  CD  LYS A  49      22.674 -11.792   7.275  1.00 50.94           C  
ATOM    363  CE  LYS A  49      23.828 -11.518   8.219  1.00 51.31           C  
ATOM    364  NZ  LYS A  49      24.380 -12.781   8.814  1.00 51.86           N  
ATOM    365  N   VAL A  50      18.292 -10.687   3.971  1.00 48.95           N  
ATOM    366  CA  VAL A  50      17.692 -11.244   2.765  1.00 48.56           C  
ATOM    367  C   VAL A  50      16.364 -10.547   2.447  1.00 47.64           C  
ATOM    368  O   VAL A  50      15.551 -10.312   3.334  1.00 46.75           O  
ATOM    369  CB  VAL A  50      17.555 -12.807   2.879  1.00 48.91           C  
ATOM    370  CG1 VAL A  50      16.333 -13.232   3.682  1.00 49.60           C  
ATOM    371  CG2 VAL A  50      17.502 -13.432   1.525  1.00 49.37           C  
ATOM    372  N   SER A  51      16.170 -10.189   1.182  1.00 46.86           N  
ATOM    373  CA  SER A  51      14.882  -9.686   0.712  1.00 46.66           C  
ATOM    374  C   SER A  51      13.994 -10.841   0.274  1.00 46.65           C  
ATOM    375  O   SER A  51      14.435 -11.997   0.248  1.00 46.47           O  
ATOM    376  CB  SER A  51      15.088  -8.713  -0.449  1.00 46.17           C  
ATOM    377  OG  SER A  51      15.644  -9.361  -1.567  1.00 44.04           O  
ATOM    378  N   LEU A  52      12.744 -10.544  -0.070  1.00 46.50           N  
ATOM    379  CA  LEU A  52      11.853 -11.580  -0.623  1.00 47.02           C  
ATOM    380  C   LEU A  52      12.372 -12.105  -1.948  1.00 46.80           C  
ATOM    381  O   LEU A  52      12.239 -13.287  -2.258  1.00 46.69           O  
ATOM    382  CB  LEU A  52      10.423 -11.064  -0.805  1.00 47.16           C  
ATOM    383  CG  LEU A  52       9.658 -10.840   0.508  1.00 48.00           C  
ATOM    384  CD1 LEU A  52       8.293 -10.271   0.216  1.00 48.77           C  
ATOM    385  CD2 LEU A  52       9.524 -12.135   1.279  1.00 48.69           C  
ATOM    386  N   LYS A  53      12.961 -11.217  -2.732  1.00 46.74           N  
ATOM    387  CA  LYS A  53      13.528 -11.603  -4.014  1.00 47.43           C  
ATOM    388  C   LYS A  53      14.723 -12.549  -3.813  1.00 46.99           C  
ATOM    389  O   LYS A  53      14.787 -13.594  -4.436  1.00 46.04           O  
ATOM    390  CB  LYS A  53      13.942 -10.354  -4.772  1.00 47.43           C  
ATOM    391  CG  LYS A  53      14.233 -10.584  -6.213  1.00 48.80           C  
ATOM    392  CD  LYS A  53      14.741  -9.309  -6.888  1.00 48.88           C  
ATOM    393  CE  LYS A  53      13.718  -8.205  -6.873  1.00 47.62           C  
ATOM    394  NZ  LYS A  53      14.117  -7.130  -7.812  1.00 47.90           N  
ATOM    395  N   GLN A  54      15.649 -12.175  -2.930  1.00 47.37           N  
ATOM    396  CA  GLN A  54      16.807 -13.021  -2.588  1.00 47.92           C  
ATOM    397  C   GLN A  54      16.365 -14.321  -1.904  1.00 47.82           C  
ATOM    398  O   GLN A  54      16.771 -15.420  -2.287  1.00 47.48           O  
ATOM    399  CB  GLN A  54      17.776 -12.254  -1.684  1.00 48.12           C  
ATOM    400  CG  GLN A  54      18.502 -11.095  -2.376  1.00 48.71           C  
ATOM    401  CD  GLN A  54      19.035 -10.033  -1.410  1.00 48.62           C  
ATOM    402  OE1 GLN A  54      18.516  -9.839  -0.313  1.00 49.52           O  
ATOM    403  NE2 GLN A  54      20.065  -9.325  -1.838  1.00 50.38           N  
ATOM    404  N   GLY A  55      15.512 -14.181  -0.904  1.00 48.22           N  
ATOM    405  CA  GLY A  55      14.973 -15.309  -0.171  1.00 49.09           C  
ATOM    406  C   GLY A  55      14.250 -16.343  -1.011  1.00 49.79           C  
ATOM    407  O   GLY A  55      14.370 -17.539  -0.748  1.00 50.07           O  
ATOM    408  N   SER A  56      13.501 -15.900  -2.015  1.00 50.30           N  
ATOM    409  CA  SER A  56      12.762 -16.817  -2.884  1.00 50.96           C  
ATOM    410  C   SER A  56      13.694 -17.727  -3.691  1.00 51.46           C  
ATOM    411  O   SER A  56      13.401 -18.911  -3.918  1.00 51.45           O  
ATOM    412  CB  SER A  56      11.837 -16.032  -3.831  1.00 51.58           C  
ATOM    413  OG  SER A  56      12.554 -15.386  -4.875  1.00 52.92           O  
ATOM    414  N   LYS A  57      14.811 -17.162  -4.132  1.00 51.63           N  
ATOM    415  CA  LYS A  57      15.830 -17.910  -4.843  1.00 51.90           C  
ATOM    416  C   LYS A  57      16.488 -18.944  -3.921  1.00 51.49           C  
ATOM    417  O   LYS A  57      16.694 -20.085  -4.314  1.00 51.47           O  
ATOM    418  CB  LYS A  57      16.865 -16.950  -5.433  1.00 52.42           C  
ATOM    419  CG  LYS A  57      16.215 -15.933  -6.365  1.00 53.97           C  
ATOM    420  CD  LYS A  57      17.194 -15.013  -7.092  1.00 54.45           C  
ATOM    421  CE  LYS A  57      16.420 -13.876  -7.798  1.00 56.36           C  
ATOM    422  NZ  LYS A  57      17.310 -12.909  -8.528  1.00 57.99           N  
ATOM    423  N   LEU A  58      16.776 -18.547  -2.686  1.00 51.18           N  
ATOM    424  CA  LEU A  58      17.324 -19.470  -1.695  1.00 51.17           C  
ATOM    425  C   LEU A  58      16.319 -20.553  -1.286  1.00 50.98           C  
ATOM    426  O   LEU A  58      16.690 -21.715  -1.147  1.00 51.30           O  
ATOM    427  CB  LEU A  58      17.810 -18.716  -0.453  1.00 50.83           C  
ATOM    428  CG  LEU A  58      18.888 -17.653  -0.679  1.00 51.13           C  
ATOM    429  CD1 LEU A  58      19.156 -16.904   0.612  1.00 50.80           C  
ATOM    430  CD2 LEU A  58      20.163 -18.262  -1.228  1.00 51.95           C  
ATOM    431  N   ALA A  59      15.055 -20.183  -1.103  1.00 50.77           N  
ATOM    432  CA  ALA A  59      14.035 -21.149  -0.665  1.00 50.80           C  
ATOM    433  C   ALA A  59      13.500 -22.020  -1.801  1.00 50.76           C  
ATOM    434  O   ALA A  59      12.771 -22.984  -1.554  1.00 50.95           O  
ATOM    435  CB  ALA A  59      12.886 -20.445   0.025  1.00 51.01           C  
ATOM    436  N   GLY A  60      13.860 -21.681  -3.037  1.00 50.41           N  
ATOM    437  CA  GLY A  60      13.341 -22.371  -4.207  1.00 50.21           C  
ATOM    438  C   GLY A  60      11.853 -22.169  -4.432  1.00 50.00           C  
ATOM    439  O   GLY A  60      11.195 -23.063  -4.966  1.00 50.08           O  
ATOM    440  N   THR A  61      11.328 -21.012  -4.010  1.00 49.60           N  
ATOM    441  CA  THR A  61       9.956 -20.602  -4.314  1.00 49.35           C  
ATOM    442  C   THR A  61       9.979 -19.629  -5.505  1.00 48.84           C  
ATOM    443  O   THR A  61      10.605 -18.568  -5.422  1.00 48.79           O  
ATOM    444  CB  THR A  61       9.267 -19.885  -3.118  1.00 49.28           C  
ATOM    445  OG1 THR A  61       9.365 -20.691  -1.938  1.00 50.36           O  
ATOM    446  CG2 THR A  61       7.787 -19.624  -3.422  1.00 49.58           C  
ATOM    447  N   PRO A  62       9.302 -19.978  -6.611  1.00 48.34           N  
ATOM    448  CA  PRO A  62       9.260 -19.058  -7.754  1.00 48.08           C  
ATOM    449  C   PRO A  62       8.633 -17.719  -7.382  1.00 47.22           C  
ATOM    450  O   PRO A  62       7.656 -17.683  -6.640  1.00 45.96           O  
ATOM    451  CB  PRO A  62       8.394 -19.796  -8.783  1.00 47.96           C  
ATOM    452  CG  PRO A  62       8.396 -21.202  -8.363  1.00 48.48           C  
ATOM    453  CD  PRO A  62       8.542 -21.208  -6.872  1.00 48.49           C  
ATOM    454  N   MET A  63       9.208 -16.627  -7.873  1.00 47.68           N  
ATOM    455  CA  MET A  63       8.669 -15.299  -7.571  1.00 47.96           C  
ATOM    456  C   MET A  63       7.212 -15.163  -7.987  1.00 47.76           C  
ATOM    457  O   MET A  63       6.431 -14.554  -7.272  1.00 47.95           O  
ATOM    458  CB  MET A  63       9.501 -14.182  -8.226  1.00 48.34           C  
ATOM    459  CG  MET A  63       9.099 -12.741  -7.781  1.00 49.78           C  
ATOM    460  SD  MET A  63       8.820 -12.484  -5.974  1.00 54.17           S  
ATOM    461  CE  MET A  63      10.148 -13.445  -5.320  1.00 51.09           C  
ATOM    462  N   ASP A  64       6.838 -15.721  -9.132  1.00 47.24           N  
ATOM    463  CA  ASP A  64       5.438 -15.659  -9.563  1.00 47.29           C  
ATOM    464  C   ASP A  64       4.475 -16.224  -8.507  1.00 46.20           C  
ATOM    465  O   ASP A  64       3.394 -15.697  -8.314  1.00 45.56           O  
ATOM    466  CB  ASP A  64       5.242 -16.374 -10.904  1.00 48.04           C  
ATOM    467  CG  ASP A  64       6.033 -15.718 -12.047  1.00 52.49           C  
ATOM    468  OD1 ASP A  64       6.084 -16.290 -13.172  1.00 57.48           O  
ATOM    469  OD2 ASP A  64       6.616 -14.629 -11.819  1.00 58.64           O  
ATOM    470  N   LYS A  65       4.878 -17.292  -7.829  1.00 45.27           N  
ATOM    471  CA  LYS A  65       4.076 -17.902  -6.772  1.00 44.99           C  
ATOM    472  C   LYS A  65       3.902 -16.916  -5.609  1.00 44.35           C  
ATOM    473  O   LYS A  65       2.806 -16.763  -5.086  1.00 43.61           O  
ATOM    474  CB  LYS A  65       4.747 -19.207  -6.310  1.00 45.56           C  
ATOM    475  CG  LYS A  65       4.207 -19.844  -5.030  1.00 46.29           C  
ATOM    476  CD  LYS A  65       3.141 -20.881  -5.302  1.00 47.36           C  
ATOM    477  CE  LYS A  65       2.735 -21.599  -4.024  1.00 47.29           C  
ATOM    478  NZ  LYS A  65       1.372 -22.179  -4.180  1.00 48.10           N  
ATOM    479  N   ILE A  66       4.985 -16.243  -5.230  1.00 43.70           N  
ATOM    480  CA  ILE A  66       4.952 -15.246  -4.172  1.00 43.91           C  
ATOM    481  C   ILE A  66       4.099 -14.053  -4.535  1.00 43.15           C  
ATOM    482  O   ILE A  66       3.303 -13.610  -3.718  1.00 42.64           O  
ATOM    483  CB  ILE A  66       6.381 -14.768  -3.800  1.00 44.59           C  
ATOM    484  CG1 ILE A  66       7.122 -15.904  -3.083  1.00 44.22           C  
ATOM    485  CG2 ILE A  66       6.326 -13.499  -2.921  1.00 44.09           C  
ATOM    486  CD1 ILE A  66       8.598 -15.826  -3.165  1.00 44.78           C  
ATOM    487  N   VAL A  67       4.258 -13.541  -5.759  1.00 42.41           N  
ATOM    488  CA  VAL A  67       3.478 -12.390  -6.210  1.00 42.01           C  
ATOM    489  C   VAL A  67       1.982 -12.720  -6.267  1.00 41.10           C  
ATOM    490  O   VAL A  67       1.170 -11.970  -5.748  1.00 40.54           O  
ATOM    491  CB  VAL A  67       3.995 -11.822  -7.548  1.00 42.16           C  
ATOM    492  CG1 VAL A  67       3.087 -10.697  -8.059  1.00 42.60           C  
ATOM    493  CG2 VAL A  67       5.415 -11.286  -7.361  1.00 42.69           C  
ATOM    494  N   ARG A  68       1.636 -13.866  -6.838  1.00 40.42           N  
ATOM    495  CA  ARG A  68       0.230 -14.316  -6.904  1.00 40.07           C  
ATOM    496  C   ARG A  68      -0.395 -14.421  -5.514  1.00 39.90           C  
ATOM    497  O   ARG A  68      -1.513 -13.980  -5.278  1.00 39.61           O  
ATOM    498  CB  ARG A  68       0.140 -15.706  -7.522  1.00 39.27           C  
ATOM    499  CG  ARG A  68       0.279 -15.767  -9.007  1.00 39.90           C  
ATOM    500  CD  ARG A  68       0.171 -17.228  -9.484  1.00 37.83           C  
ATOM    501  NE  ARG A  68      -0.822 -17.198 -10.519  1.00 42.24           N  
ATOM    502  CZ  ARG A  68      -1.977 -17.833 -10.531  1.00 38.90           C  
ATOM    503  NH1 ARG A  68      -2.338 -18.723  -9.625  1.00 38.37           N  
ATOM    504  NH2 ARG A  68      -2.744 -17.609 -11.550  1.00 42.52           N  
ATOM    505  N   THR A  69       0.339 -15.057  -4.616  1.00 39.76           N  
ATOM    506  CA  THR A  69      -0.140 -15.282  -3.249  1.00 40.22           C  
ATOM    507  C   THR A  69      -0.362 -13.959  -2.520  1.00 39.85           C  
ATOM    508  O   THR A  69      -1.404 -13.751  -1.892  1.00 39.83           O  
ATOM    509  CB  THR A  69       0.843 -16.166  -2.462  1.00 39.77           C  
ATOM    510  OG1 THR A  69       1.076 -17.380  -3.184  1.00 39.95           O  
ATOM    511  CG2 THR A  69       0.279 -16.506  -1.087  1.00 40.11           C  
ATOM    512  N   LEU A  70       0.604 -13.058  -2.635  1.00 39.78           N  
ATOM    513  CA  LEU A  70       0.483 -11.758  -2.007  1.00 40.44           C  
ATOM    514  C   LEU A  70      -0.683 -10.960  -2.564  1.00 40.40           C  
ATOM    515  O   LEU A  70      -1.468 -10.404  -1.797  1.00 40.39           O  
ATOM    516  CB  LEU A  70       1.799 -10.977  -2.110  1.00 40.62           C  
ATOM    517  CG  LEU A  70       2.955 -11.485  -1.235  1.00 41.62           C  
ATOM    518  CD1 LEU A  70       4.256 -10.732  -1.580  1.00 42.31           C  
ATOM    519  CD2 LEU A  70       2.633 -11.350   0.251  1.00 41.10           C  
ATOM    520  N   GLU A  71      -0.819 -10.911  -3.893  1.00 41.26           N  
ATOM    521  CA  GLU A  71      -1.975 -10.252  -4.513  1.00 41.42           C  
ATOM    522  C   GLU A  71      -3.306 -10.875  -4.083  1.00 40.82           C  
ATOM    523  O   GLU A  71      -4.236 -10.157  -3.789  1.00 40.62           O  
ATOM    524  CB  GLU A  71      -1.843 -10.236  -6.027  1.00 41.74           C  
ATOM    525  CG  GLU A  71      -0.671  -9.398  -6.511  1.00 43.58           C  
ATOM    526  CD  GLU A  71      -0.612  -9.272  -8.025  1.00 44.61           C  
ATOM    527  OE1 GLU A  71      -1.039 -10.201  -8.748  1.00 48.78           O  
ATOM    528  OE2 GLU A  71      -0.111  -8.234  -8.500  1.00 50.65           O  
ATOM    529  N   ALA A  72      -3.377 -12.201  -4.021  1.00 40.97           N  
ATOM    530  CA  ALA A  72      -4.584 -12.913  -3.561  1.00 41.43           C  
ATOM    531  C   ALA A  72      -4.972 -12.623  -2.108  1.00 41.56           C  
ATOM    532  O   ALA A  72      -6.093 -12.875  -1.721  1.00 41.77           O  
ATOM    533  CB  ALA A  72      -4.402 -14.413  -3.723  1.00 41.28           C  
ATOM    534  N   ASN A  73      -4.034 -12.148  -1.299  1.00 42.08           N  
ATOM    535  CA  ASN A  73      -4.310 -11.809   0.090  1.00 42.51           C  
ATOM    536  C   ASN A  73      -4.386 -10.290   0.333  1.00 42.93           C  
ATOM    537  O   ASN A  73      -4.354  -9.831   1.471  1.00 43.59           O  
ATOM    538  CB  ASN A  73      -3.270 -12.471   0.988  1.00 42.20           C  
ATOM    539  CG  ASN A  73      -3.471 -13.974   1.103  1.00 42.32           C  
ATOM    540  OD1 ASN A  73      -4.321 -14.444   1.873  1.00 41.88           O  
ATOM    541  ND2 ASN A  73      -2.689 -14.743   0.334  1.00 40.49           N  
ATOM    542  N   GLY A  74      -4.483  -9.513  -0.737  1.00 43.37           N  
ATOM    543  CA  GLY A  74      -4.783  -8.085  -0.631  1.00 43.96           C  
ATOM    544  C   GLY A  74      -3.627  -7.116  -0.839  1.00 44.50           C  
ATOM    545  O   GLY A  74      -3.809  -5.897  -0.731  1.00 45.15           O  
ATOM    546  N   TYR A  75      -2.449  -7.629  -1.162  1.00 44.33           N  
ATOM    547  CA  TYR A  75      -1.273  -6.783  -1.272  1.00 44.56           C  
ATOM    548  C   TYR A  75      -0.984  -6.379  -2.708  1.00 44.66           C  
ATOM    549  O   TYR A  75      -1.301  -7.094  -3.642  1.00 45.04           O  
ATOM    550  CB  TYR A  75      -0.064  -7.472  -0.648  1.00 44.57           C  
ATOM    551  CG  TYR A  75      -0.245  -7.748   0.825  1.00 44.78           C  
ATOM    552  CD1 TYR A  75       0.086  -6.784   1.776  1.00 44.49           C  
ATOM    553  CD2 TYR A  75      -0.756  -8.959   1.267  1.00 44.73           C  
ATOM    554  CE1 TYR A  75      -0.087  -7.025   3.128  1.00 45.58           C  
ATOM    555  CE2 TYR A  75      -0.945  -9.208   2.610  1.00 45.76           C  
ATOM    556  CZ  TYR A  75      -0.609  -8.239   3.540  1.00 45.32           C  
ATOM    557  OH  TYR A  75      -0.771  -8.485   4.879  1.00 46.10           O  
ATOM    558  N   GLU A  76      -0.373  -5.212  -2.851  1.00 45.17           N  
ATOM    559  CA  GLU A  76       0.200  -4.756  -4.091  1.00 45.72           C  
ATOM    560  C   GLU A  76       1.706  -4.876  -4.005  1.00 45.40           C  
ATOM    561  O   GLU A  76       2.309  -4.389  -3.065  1.00 44.67           O  
ATOM    562  CB  GLU A  76      -0.192  -3.296  -4.317  1.00 47.00           C  
ATOM    563  CG  GLU A  76      -0.320  -2.932  -5.768  1.00 51.28           C  
ATOM    564  CD  GLU A  76      -1.505  -3.637  -6.434  1.00 54.90           C  
ATOM    565  OE1 GLU A  76      -2.654  -3.482  -5.948  1.00 57.87           O  
ATOM    566  OE2 GLU A  76      -1.264  -4.355  -7.422  1.00 56.92           O  
ATOM    567  N   VAL A  77       2.319  -5.505  -5.010  1.00 45.22           N  
ATOM    568  CA  VAL A  77       3.723  -5.820  -4.964  1.00 45.00           C  
ATOM    569  C   VAL A  77       4.551  -4.854  -5.804  1.00 44.77           C  
ATOM    570  O   VAL A  77       4.191  -4.546  -6.921  1.00 44.43           O  
ATOM    571  CB  VAL A  77       3.945  -7.249  -5.438  1.00 45.41           C  
ATOM    572  CG1 VAL A  77       5.426  -7.592  -5.418  1.00 46.06           C  
ATOM    573  CG2 VAL A  77       3.146  -8.215  -4.558  1.00 46.27           C  
ATOM    574  N   ILE A  78       5.673  -4.391  -5.262  1.00 44.46           N  
ATOM    575  CA  ILE A  78       6.587  -3.531  -6.010  1.00 44.57           C  
ATOM    576  C   ILE A  78       8.001  -4.065  -5.866  1.00 44.52           C  
ATOM    577  O   ILE A  78       8.224  -5.003  -5.118  1.00 44.18           O  
ATOM    578  CB  ILE A  78       6.496  -2.038  -5.560  1.00 44.08           C  
ATOM    579  CG1 ILE A  78       6.957  -1.845  -4.110  1.00 43.61           C  
ATOM    580  CG2 ILE A  78       5.059  -1.515  -5.724  1.00 43.56           C  
ATOM    581  CD1 ILE A  78       7.030  -0.383  -3.700  1.00 43.66           C  
ATOM    582  N   GLY A  79       8.939  -3.469  -6.592  1.00 45.06           N  
ATOM    583  CA  GLY A  79      10.347  -3.830  -6.504  1.00 46.36           C  
ATOM    584  C   GLY A  79      10.768  -5.077  -7.268  1.00 46.82           C  
ATOM    585  O   GLY A  79      11.852  -5.608  -7.029  1.00 46.69           O  
ATOM    586  N   LEU A  80       9.902  -5.552  -8.158  1.00 48.11           N  
ATOM    587  CA  LEU A  80      10.197  -6.676  -9.062  1.00 49.70           C  
ATOM    588  C   LEU A  80      11.289  -6.336 -10.072  1.00 50.63           C  
ATOM    589  O   LEU A  80      11.495  -5.165 -10.382  1.00 50.64           O  
ATOM    590  CB  LEU A  80       8.925  -7.032  -9.852  1.00 50.18           C  
ATOM    591  CG  LEU A  80       7.914  -8.104  -9.403  1.00 51.19           C  
ATOM    592  CD1 LEU A  80       8.299  -8.825  -8.162  1.00 52.49           C  
ATOM    593  CD2 LEU A  80       6.530  -7.527  -9.256  1.00 51.13           C  
ATOM    594  N   ASP A  81      11.968  -7.358 -10.610  1.00 51.91           N  
ATOM    595  CA  ASP A  81      12.911  -7.164 -11.734  1.00 52.58           C  
ATOM    596  C   ASP A  81      12.156  -6.805 -13.024  1.00 53.48           C  
ATOM    597  O   ASP A  81      10.933  -7.000 -13.122  1.00 54.36           O  
ATOM    598  CB  ASP A  81      13.757  -8.426 -12.004  1.00 53.31           C  
ATOM    599  CG  ASP A  81      14.783  -8.708 -10.911  1.00 54.95           C  
ATOM    600  OD1 ASP A  81      15.010  -7.841 -10.039  1.00 58.15           O  
ATOM    601  OD2 ASP A  81      15.376  -9.814 -10.919  1.00 58.76           O  
TER     602      ASP A  81                                                      
END
MOLECULE T0473.pdb
ATOM     20  N   LYS     2       1.495  -1.921  -2.973  1.00 70.22           N 
ATOM     21  CA  LYS     2       2.020  -2.876  -3.958  1.00  1.42           C 
ATOM     22  C   LYS     2       3.410  -3.409  -3.545  1.00  3.25           C 
ATOM     23  O   LYS     2       4.416  -2.707  -3.653  1.00 34.31           O 
ATOM     24  CB  LYS     2       2.086  -2.205  -5.343  1.00 72.54           C 
ATOM     25  CG  LYS     2       2.244  -3.175  -6.514  1.00 22.54           C 
ATOM     26  CD  LYS     2       1.054  -4.133  -6.636  1.00 11.44           C 
ATOM     27  CE  LYS     2      -0.276  -3.394  -6.736  1.00 12.14           C 
ATOM     28  NZ  LYS     2      -1.425  -4.329  -6.889  1.00 60.35           N 
ATOM     29  H   LYS     2       2.061  -1.172  -2.685  1.00 37.32           H 
ATOM     30  HA  LYS     2       1.332  -3.711  -4.008  1.00 13.14           H 
ATOM     31 1HB  LYS     2       2.923  -1.520  -5.356  1.00 37.32           H 
ATOM     32 2HB  LYS     2       1.177  -1.640  -5.497  1.00 37.32           H 
ATOM     33 1HG  LYS     2       3.147  -3.753  -6.368  1.00 37.32           H 
ATOM     34 2HG  LYS     2       2.328  -2.606  -7.429  1.00 37.32           H 
ATOM     35 1HD  LYS     2       1.032  -4.773  -5.766  1.00 37.32           H 
ATOM     36 2HD  LYS     2       1.182  -4.737  -7.522  1.00 37.32           H 
ATOM     37 1HE  LYS     2      -0.245  -2.735  -7.592  1.00 37.32           H 
ATOM     38 2HE  LYS     2      -0.420  -2.810  -5.839  1.00 37.32           H 
ATOM     39 1HZ  LYS     2      -1.476  -4.977  -6.075  1.00 37.32           H 
ATOM     40 2HZ  LYS     2      -1.317  -4.890  -7.756  1.00 37.32           H 
ATOM     41 3HZ  LYS     2      -2.317  -3.797  -6.947  1.00 37.32           H 
ATOM     42  N   ILE     3       3.446  -4.653  -3.066  1.00 53.32           N 
ATOM     43  CA  ILE     3       4.687  -5.302  -2.615  1.00 44.50           C 
ATOM     44  C   ILE     3       5.559  -5.772  -3.796  1.00 43.35           C 
ATOM     45  O   ILE     3       5.051  -6.263  -4.808  1.00 11.54           O 
ATOM     46  CB  ILE     3       4.370  -6.523  -1.707  1.00 72.32           C 
ATOM     47  CG1 ILE     3       3.562  -6.090  -0.470  1.00 52.12           C 
ATOM     48  CG2 ILE     3       5.651  -7.243  -1.283  1.00 61.05           C 
ATOM     49  CD1 ILE     3       4.303  -5.137   0.451  1.00 75.32           C 
ATOM     50  H   ILE     3       2.608  -5.157  -3.013  1.00 37.32           H 
ATOM     51  HA  ILE     3       5.247  -4.584  -2.032  1.00  5.15           H 
ATOM     52  HB  ILE     3       3.776  -7.220  -2.284  1.00 13.31           H 
ATOM     53 1HG1 ILE     3       3.300  -6.968   0.105  1.00 37.32           H 
ATOM     54 2HG1 ILE     3       2.657  -5.597  -0.792  1.00 37.32           H 
ATOM     55 1HG2 ILE     3       6.162  -7.619  -2.158  1.00 37.32           H 
ATOM     56 2HG2 ILE     3       5.402  -8.069  -0.632  1.00 37.32           H 
ATOM     57 3HG2 ILE     3       6.296  -6.554  -0.758  1.00 37.32           H 
ATOM     58 1HD1 ILE     3       4.542  -4.229  -0.084  1.00 37.32           H 
ATOM     59 2HD1 ILE     3       5.216  -5.602   0.796  1.00 37.32           H 
ATOM     60 3HD1 ILE     3       3.678  -4.900   1.299  1.00 37.32           H 
ATOM     61  N   THR     4       6.876  -5.635  -3.652  1.00 35.23           N 
ATOM     62  CA  THR     4       7.831  -6.086  -4.678  1.00 75.53           C 
ATOM     63  C   THR     4       8.826  -7.090  -4.083  1.00 54.14           C 
ATOM     64  O   THR     4       9.077  -7.078  -2.878  1.00 12.24           O 
ATOM     65  CB  THR     4       8.620  -4.903  -5.286  1.00 41.51           C 
ATOM     66  OG1 THR     4       9.479  -4.315  -4.296  1.00 12.44           O 
ATOM     67  CG2 THR     4       7.676  -3.840  -5.840  1.00 54.02           C 
ATOM     68  H   THR     4       7.224  -5.226  -2.828  1.00 37.32           H 
ATOM     69  HA  THR     4       7.275  -6.571  -5.470  1.00 35.43           H 
ATOM     70  HB  THR     4       9.229  -5.277  -6.099  1.00 61.50           H 
ATOM     71  HG1 THR     4       9.576  -3.372  -4.472  1.00 20.53           H 
ATOM     72 1HG2 THR     4       8.252  -3.036  -6.275  1.00 37.32           H 
ATOM     73 2HG2 THR     4       7.060  -3.449  -5.041  1.00 37.32           H 
ATOM     74 3HG2 THR     4       7.044  -4.279  -6.598  1.00 37.32           H 
ATOM     75  N   LYS     5       9.404  -7.957  -4.916  1.00 12.21           N 
ATOM     76  CA  LYS     5      10.329  -8.983  -4.415  1.00 44.41           C 
ATOM     77  C   LYS     5      11.654  -8.372  -3.920  1.00 40.55           C 
ATOM     78  O   LYS     5      12.405  -9.014  -3.180  1.00 33.33           O 
ATOM     79  CB  LYS     5      10.594 -10.050  -5.487  1.00 34.43           C 
ATOM     80  CG  LYS     5      11.298  -9.535  -6.736  1.00 21.22           C 
ATOM     81  CD  LYS     5      11.557 -10.663  -7.733  1.00  4.25           C 
ATOM     82  CE  LYS     5      10.271 -11.188  -8.362  1.00 70.11           C 
ATOM     83  NZ  LYS     5       9.639 -10.179  -9.254  1.00 62.41           N 
ATOM     84  H   LYS     5       9.214  -7.906  -5.877  1.00 37.32           H 
ATOM     85  HA  LYS     5       9.847  -9.462  -3.572  1.00 55.44           H 
ATOM     86 1HB  LYS     5       9.649 -10.478  -5.787  1.00 37.32           H 
ATOM     87 2HB  LYS     5      11.206 -10.829  -5.055  1.00 37.32           H 
ATOM     88 1HG  LYS     5      12.244  -9.096  -6.449  1.00 37.32           H 
ATOM     89 2HG  LYS     5      10.681  -8.781  -7.207  1.00 37.32           H 
ATOM     90 1HD  LYS     5      12.054 -11.475  -7.221  1.00 37.32           H 
ATOM     91 2HD  LYS     5      12.198 -10.291  -8.519  1.00 37.32           H 
ATOM     92 1HE  LYS     5       9.575 -11.444  -7.575  1.00 37.32           H 
ATOM     93 2HE  LYS     5      10.501 -12.071  -8.939  1.00 37.32           H 
ATOM     94 1HZ  LYS     5       9.226  -9.409  -8.690  1.00 37.32           H 
ATOM     95 2HZ  LYS     5       8.889 -10.618  -9.826  1.00 37.32           H 
ATOM     96 3HZ  LYS     5      10.353  -9.773  -9.894  1.00 37.32           H 
ATOM     97  N   ASP     6      11.932  -7.135  -4.328  1.00 51.20           N 
ATOM     98  CA  ASP     6      13.129  -6.417  -3.876  1.00  4.24           C 
ATOM     99  C   ASP     6      12.967  -5.923  -2.424  1.00  2.14           C 
ATOM    100  O   ASP     6      13.949  -5.597  -1.752  1.00 70.41           O 
ATOM    101  CB  ASP     6      13.421  -5.241  -4.820  1.00 21.23           C 
ATOM    102  CG  ASP     6      14.716  -4.520  -4.479  1.00 73.22           C 
ATOM    103  OD1 ASP     6      15.800  -5.035  -4.822  1.00 34.41           O 
ATOM    104  OD2 ASP     6      14.659  -3.426  -3.876  1.00  3.31           O 
ATOM    105  H   ASP     6      11.323  -6.693  -4.959  1.00 37.32           H 
ATOM    106  HA  ASP     6      13.961  -7.109  -3.913  1.00  2.12           H 
ATOM    107 1HB  ASP     6      12.605  -4.531  -4.765  1.00 37.32           H 
ATOM    108 2HB  ASP     6      13.495  -5.613  -5.833  1.00 37.32           H 
ATOM    109  N   MET     7      11.724  -5.877  -1.944  1.00 40.14           N 
ATOM    110  CA  MET     7      11.438  -5.461  -0.564  1.00 74.53           C 
ATOM    111  C   MET     7      11.995  -6.465   0.464  1.00 51.41           C 
ATOM    112  O   MET     7      12.090  -7.665   0.196  1.00 53.51           O 
ATOM    113  CB  MET     7       9.924  -5.292  -0.361  1.00  0.14           C 
ATOM    114  CG  MET     7       9.329  -4.129  -1.139  1.00  4.41           C 
ATOM    115  SD  MET     7       7.541  -3.998  -0.933  1.00 63.03           S 
ATOM    116  CE  MET     7       7.201  -2.522  -1.890  1.00 43.34           C 
ATOM    117  H   MET     7      10.979  -6.132  -2.530  1.00 37.32           H 
ATOM    118  HA  MET     7      11.918  -4.505  -0.405  1.00 45.15           H 
ATOM    119 1HB  MET     7       9.725  -5.132   0.690  1.00 37.32           H 
ATOM    120 2HB  MET     7       9.424  -6.198  -0.678  1.00 37.32           H 
ATOM    121 1HG  MET     7       9.548  -4.264  -2.189  1.00 37.32           H 
ATOM    122 2HG  MET     7       9.782  -3.210  -0.796  1.00 37.32           H 
ATOM    123 1HE  MET     7       6.146  -2.300  -1.846  1.00 37.32           H 
ATOM    124 2HE  MET     7       7.492  -2.684  -2.918  1.00 37.32           H 
ATOM    125 3HE  MET     7       7.760  -1.692  -1.484  1.00 37.32           H 
ATOM    126  N   ILE     8      12.359  -5.961   1.640  1.00 50.33           N 
ATOM    127  CA  ILE     8      12.908  -6.793   2.715  1.00 31.44           C 
ATOM    128  C   ILE     8      11.797  -7.546   3.462  1.00 12.44           C 
ATOM    129  O   ILE     8      10.788  -6.953   3.841  1.00 10.22           O 
ATOM    130  CB  ILE     8      13.700  -5.930   3.733  1.00 43.21           C 
ATOM    131  CG1 ILE     8      14.835  -5.167   3.028  1.00 31.02           C 
ATOM    132  CG2 ILE     8      14.245  -6.791   4.873  1.00 43.43           C 
ATOM    133  CD1 ILE     8      15.858  -6.059   2.354  1.00 71.41           C 
ATOM    134  H   ILE     8      12.250  -4.998   1.794  1.00 37.32           H 
ATOM    135  HA  ILE     8      13.589  -7.510   2.273  1.00  4.42           H 
ATOM    136  HB  ILE     8      13.014  -5.212   4.162  1.00 22.10           H 
ATOM    137 1HG1 ILE     8      15.355  -4.556   3.753  1.00 37.32           H 
ATOM    138 2HG1 ILE     8      14.411  -4.526   2.269  1.00 37.32           H 
ATOM    139 1HG2 ILE     8      13.423  -7.252   5.403  1.00 37.32           H 
ATOM    140 2HG2 ILE     8      14.810  -6.173   5.557  1.00 37.32           H 
ATOM    141 3HG2 ILE     8      14.888  -7.561   4.471  1.00 37.32           H 
ATOM    142 1HD1 ILE     8      16.615  -5.449   1.885  1.00 37.32           H 
ATOM    143 2HD1 ILE     8      15.371  -6.665   1.605  1.00 37.32           H 
ATOM    144 3HD1 ILE     8      16.320  -6.701   3.091  1.00 37.32           H 
ATOM    145  N   ILE     9      11.993  -8.845   3.690  1.00  0.12           N 
ATOM    146  CA  ILE     9      11.005  -9.662   4.411  1.00 23.13           C 
ATOM    147  C   ILE     9      10.683  -9.063   5.793  1.00 30.13           C 
ATOM    148  O   ILE     9       9.516  -8.893   6.153  1.00 40.44           O 
ATOM    149  CB  ILE     9      11.497 -11.124   4.575  1.00 51.55           C 
ATOM    150  CG1 ILE     9      11.711 -11.768   3.192  1.00 12.13           C 
ATOM    151  CG2 ILE     9      10.509 -11.943   5.411  1.00 72.11           C 
ATOM    152  CD1 ILE     9      12.144 -13.220   3.243  1.00  0.10           C 
ATOM    153  H   ILE     9      12.819  -9.268   3.366  1.00 37.32           H 
ATOM    154  HA  ILE     9      10.095  -9.676   3.822  1.00  4.30           H 
ATOM    155  HB  ILE     9      12.441 -11.103   5.102  1.00 34.13           H 
ATOM    156 1HG1 ILE     9      12.473 -11.215   2.659  1.00 37.32           H 
ATOM    157 2HG1 ILE     9      10.788 -11.722   2.633  1.00 37.32           H 
ATOM    158 1HG2 ILE     9      10.877 -12.954   5.520  1.00 37.32           H 
ATOM    159 2HG2 ILE     9       9.548 -11.964   4.918  1.00 37.32           H 
ATOM    160 3HG2 ILE     9      10.401 -11.493   6.388  1.00 37.32           H 
ATOM    161 1HD1 ILE     9      13.074 -13.300   3.786  1.00 37.32           H 
ATOM    162 2HD1 ILE     9      12.281 -13.589   2.237  1.00 37.32           H 
ATOM    163 3HD1 ILE     9      11.385 -13.806   3.741  1.00 37.32           H 
ATOM    164  N   ALA    10      11.726  -8.727   6.554  1.00 35.40           N 
ATOM    165  CA  ALA    10      11.554  -8.087   7.866  1.00 73.44           C 
ATOM    166  C   ALA    10      10.796  -6.749   7.763  1.00  4.41           C 
ATOM    167  O   ALA    10      10.067  -6.367   8.679  1.00 63.21           O 
ATOM    168  CB  ALA    10      12.910  -7.873   8.531  1.00 53.45           C 
ATOM    169  H   ALA    10      12.634  -8.927   6.235  1.00 37.32           H 
ATOM    170  HA  ALA    10      10.983  -8.763   8.488  1.00  1.41           H 
ATOM    171 1HB  ALA    10      13.438  -8.814   8.585  1.00 37.32           H 
ATOM    172 2HB  ALA    10      12.766  -7.486   9.530  1.00 37.32           H 
ATOM    173 3HB  ALA    10      13.490  -7.169   7.952  1.00 37.32           H 
ATOM    174  N   ASP    11      10.965  -6.044   6.641  1.00 53.01           N 
ATOM    175  CA  ASP    11      10.291  -4.757   6.424  1.00 43.15           C 
ATOM    176  C   ASP    11       8.801  -4.955   6.094  1.00  2.40           C 
ATOM    177  O   ASP    11       7.946  -4.189   6.550  1.00 54.04           O 
ATOM    178  CB  ASP    11      10.990  -3.975   5.307  1.00 51.13           C 
ATOM    179  CG  ASP    11      10.341  -2.625   5.050  1.00 41.42           C 
ATOM    180  OD1 ASP    11       9.780  -2.426   3.955  1.00 51.44           O 
ATOM    181  OD2 ASP    11      10.379  -1.761   5.949  1.00 35.23           O 
ATOM    182  H   ASP    11      11.550  -6.400   5.940  1.00 37.32           H 
ATOM    183  HA  ASP    11      10.366  -4.190   7.343  1.00 21.13           H 
ATOM    184 1HB  ASP    11      10.956  -4.556   4.395  1.00 37.32           H 
ATOM    185 2HB  ASP    11      12.023  -3.810   5.583  1.00 37.32           H 
ATOM    186  N   VAL    12       8.492  -5.985   5.305  1.00 14.35           N 
ATOM    187  CA  VAL    12       7.098  -6.359   5.039  1.00 32.44           C 
ATOM    188  C   VAL    12       6.382  -6.718   6.353  1.00 63.21           C 
ATOM    189  O   VAL    12       5.227  -6.344   6.575  1.00 62.52           O 
ATOM    190  CB  VAL    12       7.005  -7.553   4.049  1.00 20.02           C 
ATOM    191  CG1 VAL    12       5.548  -7.910   3.753  1.00  2.03           C 
ATOM    192  CG2 VAL    12       7.764  -7.243   2.757  1.00  1.12           C 
ATOM    193  H   VAL    12       9.215  -6.500   4.884  1.00 37.32           H 
ATOM    194  HA  VAL    12       6.605  -5.505   4.592  1.00 20.11           H 
ATOM    195  HB  VAL    12       7.471  -8.412   4.514  1.00 34.05           H 
ATOM    196 1HG1 VAL    12       5.511  -8.753   3.077  1.00 37.32           H 
ATOM    197 2HG1 VAL    12       5.051  -7.064   3.299  1.00 37.32           H 
ATOM    198 3HG1 VAL    12       5.045  -8.168   4.675  1.00 37.32           H 
ATOM    199 1HG2 VAL    12       7.707  -8.092   2.090  1.00 37.32           H 
ATOM    200 2HG2 VAL    12       8.799  -7.038   2.987  1.00 37.32           H 
ATOM    201 3HG2 VAL    12       7.326  -6.379   2.277  1.00 37.32           H 
ATOM    202  N   LEU    13       7.097  -7.420   7.233  1.00 21.51           N 
ATOM    203  CA  LEU    13       6.593  -7.744   8.576  1.00 11.11           C 
ATOM    204  C   LEU    13       6.315  -6.474   9.399  1.00 15.42           C 
ATOM    205  O   LEU    13       5.504  -6.491  10.325  1.00 23.30           O 
ATOM    206  CB  LEU    13       7.597  -8.635   9.322  1.00 54.24           C 
ATOM    207  CG  LEU    13       7.823 -10.029   8.711  1.00  4.31           C 
ATOM    208  CD1 LEU    13       8.892 -10.793   9.490  1.00 43.11           C 
ATOM    209  CD2 LEU    13       6.514 -10.819   8.666  1.00 75.32           C 
ATOM    210  H   LEU    13       7.987  -7.742   6.969  1.00 37.32           H 
ATOM    211  HA  LEU    13       5.665  -8.287   8.456  1.00 13.21           H 
ATOM    212 1HB  LEU    13       7.249  -8.763  10.339  1.00 37.32           H 
ATOM    213 2HB  LEU    13       8.549  -8.120   9.349  1.00 37.32           H 
ATOM    214  HG  LEU    13       8.177  -9.915   7.695  1.00 42.32           H 
ATOM    215 1HD1 LEU    13       9.819 -10.239   9.466  1.00 37.32           H 
ATOM    216 2HD1 LEU    13       9.043 -11.763   9.039  1.00 37.32           H 
ATOM    217 3HD1 LEU    13       8.575 -10.918  10.515  1.00 37.32           H 
ATOM    218 1HD2 LEU    13       6.119 -10.929   9.668  1.00 37.32           H 
ATOM    219 2HD2 LEU    13       6.696 -11.795   8.243  1.00 37.32           H 
ATOM    220 3HD2 LEU    13       5.797 -10.292   8.055  1.00 37.32           H 
ATOM    221  N   GLN    14       7.006  -5.380   9.070  1.00 71.03           N 
ATOM    222  CA  GLN    14       6.758  -4.086   9.719  1.00 14.02           C 
ATOM    223  C   GLN    14       5.440  -3.465   9.228  1.00 44.50           C 
ATOM    224  O   GLN    14       4.755  -2.769   9.975  1.00  5.41           O 
ATOM    225  CB  GLN    14       7.922  -3.117   9.466  1.00 21.01           C 
ATOM    226  CG  GLN    14       9.245  -3.544  10.099  1.00  2.32           C 
ATOM    227  CD  GLN    14       9.260  -3.434  11.618  1.00  2.12           C 
ATOM    228  OE1 GLN    14       8.238  -3.580  12.284  1.00 71.13           O 
ATOM    229  NE2 GLN    14      10.421  -3.167  12.180  1.00 34.12           N 
ATOM    230  H   GLN    14       7.703  -5.447   8.384  1.00 37.32           H 
ATOM    231  HA  GLN    14       6.680  -4.265  10.783  1.00 14.45           H 
ATOM    232 1HB  GLN    14       7.658  -2.146   9.862  1.00 37.32           H 
ATOM    233 2HB  GLN    14       8.072  -3.027   8.399  1.00 37.32           H 
ATOM    234 1HG  GLN    14      10.035  -2.923   9.700  1.00 37.32           H 
ATOM    235 2HG  GLN    14       9.437  -4.574   9.834  1.00 37.32           H 
ATOM    236 1HE2 GLN    14      11.202  -3.057  11.597  1.00 37.32           H 
ATOM    237 2HE2 GLN    14      10.454  -3.089  13.154  1.00 37.32           H 
ATOM    238  N   MET    15       5.091  -3.723   7.966  1.00 53.23           N 
ATOM    239  CA  MET    15       3.824  -3.234   7.398  1.00 71.22           C 
ATOM    240  C   MET    15       2.643  -4.000   8.005  1.00 34.41           C 
ATOM    241  O   MET    15       1.583  -3.433   8.284  1.00 62.52           O 
ATOM    242  CB  MET    15       3.808  -3.399   5.871  1.00 32.33           C 
ATOM    243  CG  MET    15       5.115  -3.024   5.198  1.00 74.31           C 
ATOM    244  SD  MET    15       4.996  -3.028   3.397  1.00  2.53           S 
ATOM    245  CE  MET    15       6.697  -2.699   2.938  1.00 61.14           C 
ATOM    246  H   MET    15       5.694  -4.255   7.405  1.00 37.32           H 
ATOM    247  HA  MET    15       3.729  -2.185   7.645  1.00 71.04           H 
ATOM    248 1HB  MET    15       3.026  -2.777   5.461  1.00 37.32           H 
ATOM    249 2HB  MET    15       3.593  -4.432   5.633  1.00 37.32           H 
ATOM    250 1HG  MET    15       5.867  -3.740   5.499  1.00 37.32           H 
ATOM    251 2HG  MET    15       5.408  -2.036   5.524  1.00 37.32           H 
ATOM    252 1HE  MET    15       7.332  -3.487   3.316  1.00 37.32           H 
ATOM    253 2HE  MET    15       7.007  -1.754   3.359  1.00 37.32           H 
ATOM    254 3HE  MET    15       6.778  -2.656   1.861  1.00 37.32           H 
ATOM    255  N   ASP    16       2.844  -5.302   8.188  1.00 55.04           N 
ATOM    256  CA  ASP    16       1.847  -6.163   8.832  1.00 74.41           C 
ATOM    257  C   ASP    16       2.494  -7.459   9.358  1.00 20.12           C 
ATOM    258  O   ASP    16       3.208  -8.152   8.629  1.00  0.21           O 
ATOM    259  CB  ASP    16       0.722  -6.500   7.840  1.00 54.32           C 
ATOM    260  CG  ASP    16      -0.517  -7.082   8.505  1.00 41.12           C 
ATOM    261  OD1 ASP    16      -1.578  -7.115   7.858  1.00 50.15           O 
ATOM    262  OD2 ASP    16      -0.449  -7.494   9.681  1.00  3.03           O 
ATOM    263  H   ASP    16       3.684  -5.699   7.864  1.00 37.32           H 
ATOM    264  HA  ASP    16       1.429  -5.617   9.668  1.00 23.24           H 
ATOM    265 1HB  ASP    16       1.090  -7.217   7.120  1.00 37.32           H 
ATOM    266 2HB  ASP    16       0.433  -5.597   7.319  1.00 37.32           H 
ATOM    267  N   ARG    17       2.224  -7.791  10.622  1.00 11.13           N 
ATOM    268  CA  ARG    17       2.755  -9.015  11.232  1.00 22.33           C 
ATOM    269  C   ARG    17       2.068 -10.260  10.638  1.00 21.21           C 
ATOM    270  O   ARG    17       2.615 -11.366  10.670  1.00 32.15           O 
ATOM    271  CB  ARG    17       2.546  -8.991  12.756  1.00 63.24           C 
ATOM    272  CG  ARG    17       2.935  -7.675  13.432  1.00 21.40           C 
ATOM    273  CD  ARG    17       4.409  -7.326  13.246  1.00 61.55           C 
ATOM    274  NE  ARG    17       4.767  -6.097  13.958  1.00 34.25           N 
ATOM    275  CZ  ARG    17       5.806  -5.357  13.677  1.00 13.23           C 
ATOM    276  NH1 ARG    17       6.584  -5.658  12.688  1.00 31.45           N 
ATOM    277  NH2 ARG    17       6.054  -4.302  14.386  1.00 53.00           N 
ATOM    278  H   ARG    17       1.645  -7.203  11.154  1.00 37.32           H 
ATOM    279  HA  ARG    17       3.815  -9.064  11.021  1.00  1.20           H 
ATOM    280 1HB  ARG    17       3.131  -9.785  13.200  1.00 37.32           H 
ATOM    281 2HB  ARG    17       1.501  -9.174  12.963  1.00 37.32           H 
ATOM    282 1HG  ARG    17       2.725  -7.754  14.491  1.00 37.32           H 
ATOM    283 2HG  ARG    17       2.339  -6.879  13.011  1.00 37.32           H 
ATOM    284 1HD  ARG    17       4.605  -7.194  12.192  1.00 37.32           H 
ATOM    285 2HD  ARG    17       5.013  -8.139  13.625  1.00 37.32           H 
ATOM    286  HE  ARG    17       4.191  -5.821  14.698  1.00 51.13           H 
ATOM    287 1HH1 ARG    17       6.387  -6.459  12.128  1.00 37.32           H 
ATOM    288 2HH1 ARG    17       7.372  -5.085  12.484  1.00 37.32           H 
ATOM    289 1HH2 ARG    17       5.450  -4.056  15.140  1.00 37.32           H 
ATOM    290 2HH2 ARG    17       6.847  -3.733  14.175  1.00 37.32           H 
ATOM    291  N   GLY    18       0.866 -10.066  10.086  1.00  1.34           N 
ATOM    292  CA  GLY    18       0.097 -11.169   9.512  1.00 41.12           C 
ATOM    293  C   GLY    18       0.628 -11.653   8.162  1.00 63.21           C 
ATOM    294  O   GLY    18       0.051 -12.549   7.549  1.00 62.43           O 
ATOM    295  H   GLY    18       0.493  -9.158  10.068  1.00 37.32           H 
ATOM    296 1HA  GLY    18      -0.927 -10.844   9.383  1.00 37.32           H 
ATOM    297 2HA  GLY    18       0.108 -11.998  10.205  1.00 37.32           H 
ATOM    298  N   THR    19       1.727 -11.064   7.694  1.00 14.21           N 
ATOM    299  CA  THR    19       2.357 -11.487   6.432  1.00 24.13           C 
ATOM    300  C   THR    19       3.268 -12.706   6.636  1.00 11.53           C 
ATOM    301  O   THR    19       3.588 -13.420   5.684  1.00 73.11           O 
ATOM    302  CB  THR    19       3.190 -10.351   5.799  1.00  1.24           C 
ATOM    303  OG1 THR    19       4.221  -9.935   6.706  1.00 55.13           O 
ATOM    304  CG2 THR    19       2.310  -9.158   5.444  1.00 54.22           C 
ATOM    305  H   THR    19       2.121 -10.322   8.199  1.00 37.32           H 
ATOM    306  HA  THR    19       1.569 -11.754   5.740  1.00  3.25           H 
ATOM    307  HB  THR    19       3.650 -10.722   4.892  1.00 62.43           H 
ATOM    308  HG1 THR    19       4.012  -9.062   7.058  1.00 24.55           H 
ATOM    309 1HG2 THR    19       1.828  -8.786   6.338  1.00 37.32           H 
ATOM    310 2HG2 THR    19       1.557  -9.462   4.731  1.00 37.32           H 
ATOM    311 3HG2 THR    19       2.917  -8.375   5.012  1.00 37.32           H 
ATOM    312  N   ALA    20       3.668 -12.947   7.885  1.00  2.02           N 
ATOM    313  CA  ALA    20       4.545 -14.079   8.225  1.00 30.03           C 
ATOM    314  C   ALA    20       4.006 -15.432   7.701  1.00 22.22           C 
ATOM    315  O   ALA    20       4.737 -16.165   7.030  1.00 32.41           O 
ATOM    316  CB  ALA    20       4.783 -14.137   9.734  1.00 52.45           C 
ATOM    317  H   ALA    20       3.375 -12.343   8.599  1.00 37.32           H 
ATOM    318  HA  ALA    20       5.501 -13.892   7.754  1.00 13.20           H 
ATOM    319 1HB  ALA    20       5.493 -14.920   9.958  1.00 37.32           H 
ATOM    320 2HB  ALA    20       3.851 -14.341  10.240  1.00 37.32           H 
ATOM    321 3HB  ALA    20       5.176 -13.189  10.075  1.00 37.32           H 
ATOM    322  N   PRO    21       2.722 -15.789   7.973  1.00 72.41           N 
ATOM    323  CA  PRO    21       2.142 -17.058   7.490  1.00 70.01           C 
ATOM    324  C   PRO    21       2.163 -17.180   5.954  1.00 33.32           C 
ATOM    325  O   PRO    21       2.097 -18.284   5.409  1.00 22.54           O 
ATOM    326  CB  PRO    21       0.694 -17.028   8.015  1.00 24.35           C 
ATOM    327  CG  PRO    21       0.424 -15.595   8.326  1.00 32.31           C 
ATOM    328  CD  PRO    21       1.742 -15.016   8.761  1.00 24.43           C 
ATOM    329  HA  PRO    21       2.661 -17.908   7.914  1.00 60.21           H 
ATOM    330 1HB  PRO    21       0.619 -17.642   8.902  1.00 37.32           H 
ATOM    331 2HB  PRO    21       0.020 -17.402   7.258  1.00 37.32           H 
ATOM    332 1HG  PRO    21      -0.301 -15.521   9.124  1.00 37.32           H 
ATOM    333 2HG  PRO    21       0.063 -15.088   7.441  1.00 37.32           H 
ATOM    334 1HD  PRO    21       1.894 -15.166   9.820  1.00 37.32           H 
ATOM    335 2HD  PRO    21       1.792 -13.964   8.517  1.00 37.32           H 
ATOM    336  N   ILE    22       2.258 -16.045   5.260  1.00 74.34           N 
ATOM    337  CA  ILE    22       2.369 -16.041   3.797  1.00 14.51           C 
ATOM    338  C   ILE    22       3.776 -16.477   3.366  1.00 21.20           C 
ATOM    339  O   ILE    22       3.936 -17.312   2.471  1.00 30.02           O 
ATOM    340  CB  ILE    22       2.064 -14.643   3.207  1.00 72.21           C 
ATOM    341  CG1 ILE    22       0.684 -14.159   3.677  1.00 43.44           C 
ATOM    342  CG2 ILE    22       2.138 -14.670   1.679  1.00 13.12           C 
ATOM    343  CD1 ILE    22       0.337 -12.761   3.214  1.00 72.35           C 
ATOM    344  H   ILE    22       2.252 -15.190   5.741  1.00 37.32           H 
ATOM    345  HA  ILE    22       1.646 -16.745   3.404  1.00 62.52           H 
ATOM    346  HB  ILE    22       2.819 -13.956   3.565  1.00 33.33           H 
ATOM    347 1HG1 ILE    22       0.654 -14.165   4.757  1.00 37.32           H 
ATOM    348 2HG1 ILE    22      -0.076 -14.828   3.298  1.00 37.32           H 
ATOM    349 1HG2 ILE    22       1.941 -13.681   1.291  1.00 37.32           H 
ATOM    350 2HG2 ILE    22       1.401 -15.360   1.292  1.00 37.32           H 
ATOM    351 3HG2 ILE    22       3.124 -14.986   1.370  1.00 37.32           H 
ATOM    352 1HD1 ILE    22      -0.629 -12.482   3.610  1.00 37.32           H 
ATOM    353 2HD1 ILE    22       0.304 -12.734   2.135  1.00 37.32           H 
ATOM    354 3HD1 ILE    22       1.085 -12.065   3.570  1.00 37.32           H 
ATOM    355  N   PHE    23       4.796 -15.914   4.013  1.00 35.15           N 
ATOM    356  CA  PHE    23       6.178 -16.347   3.788  1.00  2.02           C 
ATOM    357  C   PHE    23       6.332 -17.838   4.127  1.00 24.51           C 
ATOM    358  O   PHE    23       6.930 -18.606   3.370  1.00  4.12           O 
ATOM    359  CB  PHE    23       7.156 -15.510   4.630  1.00 33.53           C 
ATOM    360  CG  PHE    23       7.221 -14.053   4.235  1.00 72.43           C 
ATOM    361  CD1 PHE    23       6.704 -13.061   5.062  1.00 54.33           C 
ATOM    362  CD2 PHE    23       7.806 -13.675   3.034  1.00 43.03           C 
ATOM    363  CE1 PHE    23       6.775 -11.729   4.698  1.00  5.22           C 
ATOM    364  CE2 PHE    23       7.877 -12.346   2.667  1.00 62.42           C 
ATOM    365  CZ  PHE    23       7.359 -11.372   3.499  1.00 42.44           C 
ATOM    366  H   PHE    23       4.617 -15.191   4.654  1.00 37.32           H 
ATOM    367  HA  PHE    23       6.403 -16.204   2.740  1.00 15.53           H 
ATOM    368 1HB  PHE    23       8.150 -15.924   4.530  1.00 37.32           H 
ATOM    369 2HB  PHE    23       6.858 -15.561   5.667  1.00 37.32           H 
ATOM    370  HD1 PHE    23       6.245 -13.339   6.001  1.00 74.31           H 
ATOM    371  HD2 PHE    23       8.212 -14.433   2.379  1.00 54.34           H 
ATOM    372  HE1 PHE    23       6.371 -10.966   5.349  1.00 53.44           H 
ATOM    373  HE2 PHE    23       8.336 -12.068   1.729  1.00 55.35           H 
ATOM    374  HZ  PHE    23       7.414 -10.332   3.214  1.00 64.30           H 
ATOM    375  N   ILE    24       5.768 -18.242   5.265  1.00 21.14           N 
ATOM    376  CA  ILE    24       5.763 -19.650   5.677  1.00 54.15           C 
ATOM    377  C   ILE    24       5.003 -20.524   4.660  1.00 64.43           C 
ATOM    378  O   ILE    24       5.398 -21.657   4.380  1.00 63.33           O 
ATOM    379  CB  ILE    24       5.129 -19.817   7.084  1.00 43.03           C 
ATOM    380  CG1 ILE    24       5.904 -18.985   8.123  1.00 35.24           C 
ATOM    381  CG2 ILE    24       5.089 -21.291   7.495  1.00 55.21           C 
ATOM    382  CD1 ILE    24       5.316 -19.039   9.519  1.00 41.24           C 
ATOM    383  H   ILE    24       5.348 -17.572   5.849  1.00 37.32           H 
ATOM    384  HA  ILE    24       6.792 -19.985   5.725  1.00 74.42           H 
ATOM    385  HB  ILE    24       4.110 -19.457   7.036  1.00 52.44           H 
ATOM    386 1HG1 ILE    24       5.916 -17.949   7.809  1.00 37.32           H 
ATOM    387 2HG1 ILE    24       6.920 -19.347   8.181  1.00 37.32           H 
ATOM    388 1HG2 ILE    24       6.096 -21.682   7.542  1.00 37.32           H 
ATOM    389 2HG2 ILE    24       4.520 -21.853   6.768  1.00 37.32           H 
ATOM    390 3HG2 ILE    24       4.620 -21.384   8.465  1.00 37.32           H 
ATOM    391 1HD1 ILE    24       5.299 -20.063   9.866  1.00 37.32           H 
ATOM    392 2HD1 ILE    24       4.311 -18.646   9.502  1.00 37.32           H 
ATOM    393 3HD1 ILE    24       5.922 -18.444  10.187  1.00 37.32           H 
ATOM    394  N   ASN    25       3.919 -19.982   4.098  1.00 74.35           N 
ATOM    395  CA  ASN    25       3.127 -20.691   3.080  1.00 12.12           C 
ATOM    396  C   ASN    25       3.997 -21.109   1.882  1.00 32.31           C 
ATOM    397  O   ASN    25       3.884 -22.225   1.375  1.00 14.41           O 
ATOM    398  CB  ASN    25       1.972 -19.804   2.591  1.00 25.11           C 
ATOM    399  CG  ASN    25       1.045 -20.520   1.619  1.00 11.50           C 
ATOM    400  OD1 ASN    25       0.797 -21.716   1.744  1.00 12.20           O 
ATOM    401  ND2 ASN    25       0.540 -19.802   0.637  1.00  5.01           N 
ATOM    402  H   ASN    25       3.636 -19.086   4.381  1.00 37.32           H 
ATOM    403  HA  ASN    25       2.719 -21.580   3.541  1.00 52.24           H 
ATOM    404 1HB  ASN    25       2.381 -18.935   2.095  1.00 37.32           H 
ATOM    405 2HB  ASN    25       1.388 -19.483   3.442  1.00 37.32           H 
ATOM    406 1HD2 ASN    25       0.780 -18.852   0.578  1.00 37.32           H 
ATOM    407 2HD2 ASN    25      -0.049 -20.247  -0.002  1.00 37.32           H 
ATOM    408  N   ASN    26       4.875 -20.207   1.451  1.00 13.02           N 
ATOM    409  CA  ASN    26       5.730 -20.446   0.279  1.00 54.13           C 
ATOM    410  C   ASN    26       7.025 -21.207   0.629  1.00 10.11           C 
ATOM    411  O   ASN    26       7.833 -21.501  -0.253  1.00  1.32           O 
ATOM    412  CB  ASN    26       6.052 -19.113  -0.403  1.00 63.20           C 
ATOM    413  CG  ASN    26       4.832 -18.524  -1.088  1.00 24.32           C 
ATOM    414  OD1 ASN    26       4.606 -18.748  -2.270  1.00 12.55           O 
ATOM    415  ND2 ASN    26       4.029 -17.781  -0.352  1.00 30.34           N 
ATOM    416  H   ASN    26       4.949 -19.353   1.927  1.00 37.32           H 
ATOM    417  HA  ASN    26       5.162 -21.054  -0.415  1.00 64.45           H 
ATOM    418 1HB  ASN    26       6.821 -19.268  -1.147  1.00 37.32           H 
ATOM    419 2HB  ASN    26       6.408 -18.408   0.335  1.00 37.32           H 
ATOM    420 1HD2 ASN    26       4.255 -17.642   0.588  1.00 37.32           H 
ATOM    421 2HD2 ASN    26       3.225 -17.404  -0.781  1.00 37.32           H 
ATOM    422  N   GLY    27       7.220 -21.522   1.913  1.00 22.01           N 
ATOM    423  CA  GLY    27       8.349 -22.367   2.318  1.00 13.10           C 
ATOM    424  C   GLY    27       9.514 -21.626   2.980  1.00  2.32           C 
ATOM    425  O   GLY    27      10.622 -22.164   3.057  1.00 52.41           O 
ATOM    426  H   GLY    27       6.587 -21.196   2.587  1.00 37.32           H 
ATOM    427 1HA  GLY    27       8.724 -22.884   1.445  1.00 37.32           H 
ATOM    428 2HA  GLY    27       7.984 -23.106   3.016  1.00 37.32           H 
ATOM    429  N   MET    28       9.290 -20.401   3.455  1.00  3.02           N 
ATOM    430  CA  MET    28      10.335 -19.658   4.178  1.00 45.43           C 
ATOM    431  C   MET    28      10.584 -20.240   5.578  1.00 74.40           C 
ATOM    432  O   MET    28       9.668 -20.740   6.233  1.00 23.31           O 
ATOM    433  CB  MET    28       9.957 -18.179   4.298  1.00 44.10           C 
ATOM    434  CG  MET    28      10.021 -17.429   2.980  1.00  0.31           C 
ATOM    435  SD  MET    28      11.707 -17.285   2.361  1.00 72.43           S 
ATOM    436  CE  MET    28      11.442 -16.307   0.886  1.00 35.32           C 
ATOM    437  H   MET    28       8.416 -19.980   3.313  1.00 37.32           H 
ATOM    438  HA  MET    28      11.249 -19.739   3.605  1.00 62.41           H 
ATOM    439 1HB  MET    28      10.635 -17.700   4.993  1.00 37.32           H 
ATOM    440 2HB  MET    28       8.950 -18.105   4.683  1.00 37.32           H 
ATOM    441 1HG  MET    28       9.616 -16.440   3.120  1.00 37.32           H 
ATOM    442 2HG  MET    28       9.429 -17.959   2.248  1.00 37.32           H 
ATOM    443 1HE  MET    28      10.779 -16.836   0.218  1.00 37.32           H 
ATOM    444 2HE  MET    28      12.388 -16.135   0.394  1.00 37.32           H 
ATOM    445 3HE  MET    28      10.999 -15.359   1.157  1.00 37.32           H 
ATOM    548  N   MET    37      15.264 -13.340   7.267  1.00 42.44           N 
ATOM    549  CA  MET    37      14.619 -12.122   7.781  1.00 44.24           C 
ATOM    550  C   MET    37      15.235 -10.834   7.199  1.00 41.42           C 
ATOM    551  O   MET    37      14.515  -9.940   6.745  1.00 33.35           O 
ATOM    552  CB  MET    37      14.726 -12.091   9.311  1.00 65.31           C 
ATOM    553  CG  MET    37      14.092 -13.290  10.019  1.00 72.10           C 
ATOM    554  SD  MET    37      12.324 -13.088  10.358  1.00 61.42           S 
ATOM    555  CE  MET    37      11.596 -13.125   8.719  1.00 22.40           C 
ATOM    556  H   MET    37      16.162 -13.576   7.580  1.00 37.32           H 
ATOM    557  HA  MET    37      13.574 -12.158   7.508  1.00 51.21           H 
ATOM    558 1HB  MET    37      14.244 -11.193   9.673  1.00 37.32           H 
ATOM    559 2HB  MET    37      15.772 -12.056   9.584  1.00 37.32           H 
ATOM    560 1HG  MET    37      14.604 -13.443  10.959  1.00 37.32           H 
ATOM    561 2HG  MET    37      14.222 -14.167   9.401  1.00 37.32           H 
ATOM    562 1HE  MET    37      11.938 -14.003   8.191  1.00 37.32           H 
ATOM    563 2HE  MET    37      11.884 -12.238   8.173  1.00 37.32           H 
ATOM    564 3HE  MET    37      10.520 -13.156   8.805  1.00 37.32           H 
ATOM    565  N   GLY    38      16.566 -10.751   7.220  1.00 71.12           N 
ATOM    566  CA  GLY    38      17.259  -9.508   6.875  1.00 73.54           C 
ATOM    567  C   GLY    38      17.250  -9.150   5.386  1.00 24.45           C 
ATOM    568  O   GLY    38      17.113  -7.978   5.028  1.00  1.11           O 
ATOM    569  H   GLY    38      17.086 -11.540   7.472  1.00 37.32           H 
ATOM    570 1HA  GLY    38      18.288  -9.595   7.198  1.00 37.32           H 
ATOM    571 2HA  GLY    38      16.802  -8.697   7.423  1.00 37.32           H 
ATOM    572  N   GLU    39      17.421 -10.142   4.518  1.00 14.15           N 
ATOM    573  CA  GLU    39      17.512  -9.902   3.076  1.00 23.44           C 
ATOM    574  C   GLU    39      16.145  -9.667   2.411  1.00 44.13           C 
ATOM    575  O   GLU    39      15.086  -9.785   3.037  1.00 13.24           O 
ATOM    576  CB  GLU    39      18.216 -11.087   2.411  1.00 54.40           C 
ATOM    577  CG  GLU    39      19.637 -11.306   2.917  1.00 74.31           C 
ATOM    578  CD  GLU    39      20.595 -10.200   2.499  1.00 40.10           C 
ATOM    579  OE1 GLU    39      20.767  -9.228   3.266  1.00 72.05           O 
ATOM    580  OE2 GLU    39      21.178 -10.292   1.398  1.00 41.11           O 
ATOM    581  H   GLU    39      17.506 -11.059   4.848  1.00 37.32           H 
ATOM    582  HA  GLU    39      18.118  -9.020   2.928  1.00 33.23           H 
ATOM    583 1HB  GLU    39      18.257 -10.920   1.344  1.00 37.32           H 
ATOM    584 2HB  GLU    39      17.645 -11.986   2.604  1.00 37.32           H 
ATOM    585 1HG  GLU    39      19.997 -12.245   2.535  1.00 37.32           H 
ATOM    586 2HG  GLU    39      19.615 -11.351   3.997  1.00 37.32           H 
ATOM    587  N   SER    40      16.193  -9.321   1.127  1.00 33.12           N 
ATOM    588  CA  SER    40      14.986  -9.094   0.325  1.00  3.03           C 
ATOM    589  C   SER    40      14.264 -10.411   0.012  1.00 20.33           C 
ATOM    590  O   SER    40      14.863 -11.488   0.066  1.00 21.14           O 
ATOM    591  CB  SER    40      15.353  -8.386  -0.988  1.00 45.42           C 
ATOM    592  OG  SER    40      16.065  -7.179  -0.742  1.00  2.42           O 
ATOM    593  H   SER    40      17.070  -9.202   0.705  1.00 37.32           H 
ATOM    594  HA  SER    40      14.322  -8.457   0.892  1.00 23.24           H 
ATOM    595 1HB  SER    40      14.449  -8.151  -1.532  1.00 37.32           H 
ATOM    596 2HB  SER    40      15.974  -9.037  -1.587  1.00 37.32           H 
ATOM    597  HG  SER    40      15.554  -6.432  -1.080  1.00 10.41           H 
ATOM    598  N   ILE    41      12.979 -10.321  -0.331  1.00 42.14           N 
ATOM    599  CA  ILE    41      12.174 -11.502  -0.662  1.00 45.44           C 
ATOM    600  C   ILE    41      12.839 -12.367  -1.748  1.00 43.02           C 
ATOM    601  O   ILE    41      13.027 -13.569  -1.563  1.00  3.20           O 
ATOM    602  CB  ILE    41      10.768 -11.064  -1.130  1.00 73.23           C 
ATOM    603  CG1 ILE    41      10.059 -10.285  -0.005  1.00 32.14           C 
ATOM    604  CG2 ILE    41       9.932 -12.265  -1.576  1.00 61.32           C 
ATOM    605  CD1 ILE    41       9.056  -9.277  -0.509  1.00 24.14           C 
ATOM    606  H   ILE    41      12.548  -9.432  -0.358  1.00 37.32           H 
ATOM    607  HA  ILE    41      12.064 -12.094   0.239  1.00 63.32           H 
ATOM    608  HB  ILE    41      10.890 -10.412  -1.982  1.00  0.44           H 
ATOM    609 1HG1 ILE    41      10.797  -9.752   0.580  1.00 37.32           H 
ATOM    610 2HG1 ILE    41       9.535 -10.979   0.634  1.00 37.32           H 
ATOM    611 1HG2 ILE    41       9.812 -12.950  -0.749  1.00 37.32           H 
ATOM    612 2HG2 ILE    41      10.429 -12.771  -2.392  1.00 37.32           H 
ATOM    613 3HG2 ILE    41       8.960 -11.926  -1.906  1.00 37.32           H 
ATOM    614 1HD1 ILE    41       8.587  -8.787   0.330  1.00 37.32           H 
ATOM    615 2HD1 ILE    41       8.307  -9.776  -1.104  1.00 37.32           H 
ATOM    616 3HD1 ILE    41       9.571  -8.542  -1.112  1.00 37.32           H 
ATOM    617  N   GLU    42      13.205 -11.747  -2.871  1.00 42.22           N 
ATOM    618  CA  GLU    42      13.863 -12.463  -3.975  1.00 12.25           C 
ATOM    619  C   GLU    42      15.180 -13.117  -3.524  1.00 12.21           C 
ATOM    620  O   GLU    42      15.485 -14.250  -3.904  1.00  3.34           O 
ATOM    621  CB  GLU    42      14.136 -11.507  -5.150  1.00 20.42           C 
ATOM    622  CG  GLU    42      14.970 -10.284  -4.777  1.00 64.15           C 
ATOM    623  CD  GLU    42      15.354  -9.443  -5.985  1.00 43.13           C 
ATOM    624  OE1 GLU    42      14.528  -8.626  -6.440  1.00 32.34           O 
ATOM    625  OE2 GLU    42      16.484  -9.601  -6.492  1.00 14.32           O 
ATOM    626  H   GLU    42      13.029 -10.786  -2.963  1.00 37.32           H 
ATOM    627  HA  GLU    42      13.189 -13.238  -4.310  1.00 54.21           H 
ATOM    628 1HB  GLU    42      13.190 -11.163  -5.544  1.00 37.32           H 
ATOM    629 2HB  GLU    42      14.659 -12.049  -5.927  1.00 37.32           H 
ATOM    630 1HG  GLU    42      15.873 -10.618  -4.282  1.00 37.32           H 
ATOM    631 2HG  GLU    42      14.399  -9.669  -4.095  1.00 37.32           H 
ATOM    632  N   ASP    43      15.942 -12.401  -2.698  1.00 24.41           N 
ATOM    633  CA  ASP    43      17.246 -12.874  -2.228  1.00  0.43           C 
ATOM    634  C   ASP    43      17.092 -14.154  -1.385  1.00  2.14           C 
ATOM    635  O   ASP    43      17.753 -15.164  -1.639  1.00 40.33           O 
ATOM    636  CB  ASP    43      17.929 -11.766  -1.412  1.00 14.03           C 
ATOM    637  CG  ASP    43      19.445 -11.874  -1.431  1.00 63.43           C 
ATOM    638  OD1 ASP    43      20.095 -11.072  -2.138  1.00 54.13           O 
ATOM    639  OD2 ASP    43      19.990 -12.761  -0.752  1.00 50.33           O 
ATOM    640  H   ASP    43      15.618 -11.531  -2.394  1.00 37.32           H 
ATOM    641  HA  ASP    43      17.851 -13.097  -3.097  1.00  2.43           H 
ATOM    642 1HB  ASP    43      17.595 -11.821  -0.386  1.00 37.32           H 
ATOM    643 2HB  ASP    43      17.650 -10.804  -1.820  1.00 37.32           H 
ATOM    644  N   ALA    44      16.199 -14.101  -0.396  1.00 61.23           N 
ATOM    645  CA  ALA    44      15.916 -15.254   0.467  1.00 42.42           C 
ATOM    646  C   ALA    44      15.273 -16.411  -0.321  1.00 45.43           C 
ATOM    647  O   ALA    44      15.549 -17.588  -0.061  1.00 14.12           O 
ATOM    648  CB  ALA    44      15.013 -14.829   1.619  1.00 52.13           C 
ATOM    649  H   ALA    44      15.720 -13.259  -0.236  1.00 37.32           H 
ATOM    650  HA  ALA    44      16.853 -15.596   0.885  1.00  4.35           H 
ATOM    651 1HB  ALA    44      14.076 -14.455   1.226  1.00 37.32           H 
ATOM    652 2HB  ALA    44      15.500 -14.050   2.187  1.00 37.32           H 
ATOM    653 3HB  ALA    44      14.822 -15.676   2.263  1.00 37.32           H 
ATOM    654  N   CYS    45      14.414 -16.071  -1.284  1.00 41.35           N 
ATOM    655  CA  CYS    45      13.771 -17.081  -2.137  1.00 32.22           C 
ATOM    656  C   CYS    45      14.805 -17.861  -2.958  1.00 72.35           C 
ATOM    657  O   CYS    45      14.784 -19.091  -2.986  1.00 13.34           O 
ATOM    658  CB  CYS    45      12.741 -16.438  -3.077  1.00 62.12           C 
ATOM    659  SG  CYS    45      11.281 -15.773  -2.239  1.00  4.53           S 
ATOM    660  H   CYS    45      14.208 -15.123  -1.424  1.00 37.32           H 
ATOM    661  HA  CYS    45      13.257 -17.775  -1.486  1.00 42.31           H 
ATOM    662 1HB  CYS    45      12.400 -17.178  -3.788  1.00 37.32           H 
ATOM    663 2HB  CYS    45      13.209 -15.625  -3.613  1.00 37.32           H 
ATOM    664  HG  CYS    45      11.692 -14.870  -1.362  1.00 45.34           H 
ATOM    665  N   ALA    46      15.718 -17.141  -3.610  1.00 12.32           N 
ATOM    666  CA  ALA    46      16.756 -17.765  -4.439  1.00  5.43           C 
ATOM    667  C   ALA    46      17.565 -18.813  -3.656  1.00 11.05           C 
ATOM    668  O   ALA    46      17.931 -19.858  -4.197  1.00 21.42           O 
ATOM    669  CB  ALA    46      17.682 -16.698  -5.010  1.00 25.44           C 
ATOM    670  H   ALA    46      15.695 -16.162  -3.534  1.00 37.32           H 
ATOM    671  HA  ALA    46      16.262 -18.258  -5.268  1.00 31.35           H 
ATOM    672 1HB  ALA    46      17.101 -15.970  -5.556  1.00 37.32           H 
ATOM    673 2HB  ALA    46      18.398 -17.158  -5.675  1.00 37.32           H 
ATOM    674 3HB  ALA    46      18.206 -16.206  -4.203  1.00 37.32           H 
ATOM    675  N   VAL    47      17.827 -18.530  -2.379  1.00 65.15           N 
ATOM    676  CA  VAL    47      18.554 -19.463  -1.505  1.00 64.22           C 
ATOM    677  C   VAL    47      17.848 -20.828  -1.419  1.00 33.40           C 
ATOM    678  O   VAL    47      18.450 -21.870  -1.682  1.00 25.12           O 
ATOM    679  CB  VAL    47      18.715 -18.892  -0.071  1.00 31.41           C 
ATOM    680  CG1 VAL    47      19.514 -19.846   0.815  1.00 62.03           C 
ATOM    681  CG2 VAL    47      19.364 -17.511  -0.108  1.00 42.12           C 
ATOM    682  H   VAL    47      17.537 -17.665  -2.018  1.00 37.32           H 
ATOM    683  HA  VAL    47      19.541 -19.607  -1.924  1.00 24.44           H 
ATOM    684  HB  VAL    47      17.729 -18.785   0.363  1.00 74.20           H 
ATOM    685 1HG1 VAL    47      20.489 -20.014   0.380  1.00 37.32           H 
ATOM    686 2HG1 VAL    47      18.989 -20.788   0.896  1.00 37.32           H 
ATOM    687 3HG1 VAL    47      19.628 -19.413   1.798  1.00 37.32           H 
ATOM    688 1HG2 VAL    47      18.742 -16.836  -0.676  1.00 37.32           H 
ATOM    689 2HG2 VAL    47      20.337 -17.580  -0.574  1.00 37.32           H 
ATOM    690 3HG2 VAL    47      19.475 -17.136   0.899  1.00 37.32           H 
ATOM    691  N   HIS    48      16.563 -20.812  -1.061  1.00 12.53           N 
ATOM    692  CA  HIS    48      15.783 -22.050  -0.894  1.00 55.42           C 
ATOM    693  C   HIS    48      15.039 -22.449  -2.184  1.00 24.03           C 
ATOM    694  O   HIS    48      14.244 -23.391  -2.182  1.00 41.44           O 
ATOM    695  CB  HIS    48      14.776 -21.888   0.256  1.00 33.23           C 
ATOM    696  CG  HIS    48      15.400 -21.836   1.619  1.00 32.34           C 
ATOM    697  ND1 HIS    48      15.073 -22.720   2.624  1.00 65.35           N 
ATOM    698  CD2 HIS    48      16.320 -20.995   2.150  1.00 72.43           C 
ATOM    699  CE1 HIS    48      15.761 -22.429   3.708  1.00 30.33           C 
ATOM    700  NE2 HIS    48      16.524 -21.388   3.449  1.00 21.12           N 
ATOM    701  H   HIS    48      16.124 -19.947  -0.913  1.00 37.32           H 
ATOM    702  HA  HIS    48      16.472 -22.844  -0.639  1.00 63.22           H 
ATOM    703 1HB  HIS    48      14.085 -22.720   0.241  1.00 37.32           H 
ATOM    704 2HB  HIS    48      14.224 -20.971   0.115  1.00 37.32           H 
ATOM    705  HD1 HIS    48      14.418 -23.449   2.554  1.00 41.15           H 
ATOM    706  HD2 HIS    48      16.805 -20.172   1.644  1.00  4.03           H 
ATOM    707  HE1 HIS    48      15.709 -22.956   4.648  1.00 20.22           H 
ATOM    708  HE2 HIS    48      17.020 -20.877   4.124  1.00 37.32           H 
ATOM    709  N   GLY    49      15.297 -21.734  -3.279  1.00  2.41           N 
ATOM    710  CA  GLY    49      14.617 -22.012  -4.546  1.00 61.15           C 
ATOM    711  C   GLY    49      13.105 -21.797  -4.471  1.00 32.04           C 
ATOM    712  O   GLY    49      12.332 -22.487  -5.139  1.00 43.21           O 
ATOM    713  H   GLY    49      15.955 -21.010  -3.232  1.00 37.32           H 
ATOM    714 1HA  GLY    49      14.811 -23.037  -4.831  1.00 37.32           H 
ATOM    715 2HA  GLY    49      15.022 -21.358  -5.306  1.00 37.32           H 
ATOM    716  N   ILE    50      12.692 -20.838  -3.649  1.00 70.30           N 
ATOM    717  CA  ILE    50      11.273 -20.520  -3.455  1.00 53.34           C 
ATOM    718  C   ILE    50      10.719 -19.677  -4.615  1.00 22.13           C 
ATOM    719  O   ILE    50      11.443 -18.898  -5.243  1.00 11.20           O 
ATOM    720  CB  ILE    50      11.062 -19.762  -2.118  1.00 53.31           C 
ATOM    721  CG1 ILE    50      11.562 -20.618  -0.940  1.00 54.03           C 
ATOM    722  CG2 ILE    50       9.599 -19.366  -1.919  1.00 40.25           C 
ATOM    723  CD1 ILE    50      11.386 -19.969   0.416  1.00 71.45           C 
ATOM    724  H   ILE    50      13.362 -20.324  -3.155  1.00 37.32           H 
ATOM    725  HA  ILE    50      10.724 -21.452  -3.406  1.00 31.35           H 
ATOM    726  HB  ILE    50      11.642 -18.855  -2.161  1.00 13.21           H 
ATOM    727 1HG1 ILE    50      12.615 -20.822  -1.075  1.00 37.32           H 
ATOM    728 2HG1 ILE    50      11.022 -21.552  -0.928  1.00 37.32           H 
ATOM    729 1HG2 ILE    50       9.494 -18.822  -0.991  1.00 37.32           H 
ATOM    730 2HG2 ILE    50       8.987 -20.256  -1.883  1.00 37.32           H 
ATOM    731 3HG2 ILE    50       9.277 -18.741  -2.739  1.00 37.32           H 
ATOM    732 1HD1 ILE    50      11.926 -19.034   0.444  1.00 37.32           H 
ATOM    733 2HD1 ILE    50      11.769 -20.628   1.181  1.00 37.32           H 
ATOM    734 3HD1 ILE    50      10.336 -19.785   0.595  1.00 37.32           H 
ATOM    735  N   ASP    51       9.433 -19.837  -4.890  1.00 63.15           N 
ATOM    736  CA  ASP    51       8.771 -19.111  -5.972  1.00 31.11           C 
ATOM    737  C   ASP    51       8.398 -17.686  -5.514  1.00 64.10           C 
ATOM    738  O   ASP    51       7.277 -17.437  -5.060  1.00 72.15           O 
ATOM    739  CB  ASP    51       7.521 -19.881  -6.431  1.00 34.44           C 
ATOM    740  CG  ASP    51       7.060 -19.494  -7.828  1.00 30.44           C 
ATOM    741  OD1 ASP    51       6.850 -18.289  -8.088  1.00  3.13           O 
ATOM    742  OD2 ASP    51       6.896 -20.397  -8.676  1.00 41.01           O 
ATOM    743  H   ASP    51       8.909 -20.456  -4.342  1.00 37.32           H 
ATOM    744  HA  ASP    51       9.465 -19.040  -6.801  1.00 64.42           H 
ATOM    745 1HB  ASP    51       6.712 -19.689  -5.739  1.00 37.32           H 
ATOM    746 2HB  ASP    51       7.740 -20.941  -6.426  1.00 37.32           H 
ATOM    747  N   ALA    52       9.356 -16.759  -5.608  1.00 72.11           N 
ATOM    748  CA  ALA    52       9.138 -15.372  -5.179  1.00 61.45           C 
ATOM    749  C   ALA    52       8.011 -14.702  -5.972  1.00 54.52           C 
ATOM    750  O   ALA    52       7.318 -13.825  -5.458  1.00 62.31           O 
ATOM    751  CB  ALA    52      10.428 -14.567  -5.303  1.00 31.20           C 
ATOM    752  H   ALA    52      10.232 -17.014  -5.966  1.00 37.32           H 
ATOM    753  HA  ALA    52       8.855 -15.393  -4.134  1.00 74.54           H 
ATOM    754 1HB  ALA    52      10.724 -14.516  -6.341  1.00 37.32           H 
ATOM    755 2HB  ALA    52      11.209 -15.048  -4.732  1.00 37.32           H 
ATOM    756 3HB  ALA    52      10.271 -13.567  -4.924  1.00 37.32           H 
ATOM    757  N   ASP    53       7.833 -15.118  -7.222  1.00 61.20           N 
ATOM    758  CA  ASP    53       6.759 -14.591  -8.064  1.00 34.15           C 
ATOM    759  C   ASP    53       5.383 -14.839  -7.418  1.00 42.12           C 
ATOM    760  O   ASP    53       4.559 -13.930  -7.324  1.00 33.23           O 
ATOM    761  CB  ASP    53       6.834 -15.226  -9.457  1.00 53.02           C 
ATOM    762  CG  ASP    53       5.781 -14.685 -10.405  1.00  5.43           C 
ATOM    763  OD1 ASP    53       5.933 -13.537 -10.873  1.00 31.11           O 
ATOM    764  OD2 ASP    53       4.806 -15.409 -10.697  1.00 32.43           O 
ATOM    765  H   ASP    53       8.438 -15.797  -7.589  1.00 37.32           H 
ATOM    766  HA  ASP    53       6.910 -13.524  -8.156  1.00 13.44           H 
ATOM    767 1HB  ASP    53       6.702 -16.296  -9.366  1.00 37.32           H 
ATOM    768 2HB  ASP    53       7.808 -15.027  -9.882  1.00 37.32           H 
ATOM    769  N   LYS    54       5.154 -16.068  -6.952  1.00 34.12           N 
ATOM    770  CA  LYS    54       3.898 -16.414  -6.271  1.00 31.33           C 
ATOM    771  C   LYS    54       3.823 -15.779  -4.873  1.00 21.43           C 
ATOM    772  O   LYS    54       2.790 -15.231  -4.484  1.00 70.12           O 
ATOM    773  CB  LYS    54       3.748 -17.938  -6.159  1.00 35.40           C 
ATOM    774  CG  LYS    54       3.542 -18.640  -7.497  1.00 43.11           C 
ATOM    775  CD  LYS    54       3.426 -20.154  -7.331  1.00 53.11           C 
ATOM    776  CE  LYS    54       3.224 -20.857  -8.668  1.00 62.33           C 
ATOM    777  NZ  LYS    54       4.329 -20.574  -9.620  1.00 40.22           N 
ATOM    778  H   LYS    54       5.846 -16.759  -7.063  1.00 37.32           H 
ATOM    779  HA  LYS    54       3.084 -16.027  -6.868  1.00 41.32           H 
ATOM    780 1HB  LYS    54       2.899 -18.160  -5.526  1.00 37.32           H 
ATOM    781 2HB  LYS    54       4.640 -18.343  -5.700  1.00 37.32           H 
ATOM    782 1HG  LYS    54       4.385 -18.420  -8.138  1.00 37.32           H 
ATOM    783 2HG  LYS    54       2.636 -18.266  -7.952  1.00 37.32           H 
ATOM    784 1HD  LYS    54       2.582 -20.373  -6.689  1.00 37.32           H 
ATOM    785 2HD  LYS    54       4.331 -20.527  -6.875  1.00 37.32           H 
ATOM    786 1HE  LYS    54       2.292 -20.522  -9.101  1.00 37.32           H 
ATOM    787 2HE  LYS    54       3.177 -21.922  -8.496  1.00 37.32           H 
ATOM    788 1HZ  LYS    54       4.356 -19.561  -9.847  1.00 37.32           H 
ATOM    789 2HZ  LYS    54       4.189 -21.110 -10.499  1.00 37.32           H 
ATOM    790 3HZ  LYS    54       5.241 -20.848  -9.203  1.00 37.32           H 
ATOM    791  N   LEU    55       4.928 -15.853  -4.130  1.00 13.10           N 
ATOM    792  CA  LEU    55       5.004 -15.279  -2.780  1.00 50.41           C 
ATOM    793  C   LEU    55       4.624 -13.790  -2.773  1.00 21.32           C 
ATOM    794  O   LEU    55       3.772 -13.359  -1.993  1.00  1.25           O 
ATOM    795  CB  LEU    55       6.420 -15.472  -2.209  1.00 35.45           C 
ATOM    796  CG  LEU    55       6.708 -14.769  -0.866  1.00 30.43           C 
ATOM    797  CD1 LEU    55       5.665 -15.137   0.188  1.00 42.14           C 
ATOM    798  CD2 LEU    55       8.112 -15.117  -0.375  1.00 64.42           C 
ATOM    799  H   LEU    55       5.714 -16.312  -4.497  1.00 37.32           H 
ATOM    800  HA  LEU    55       4.302 -15.816  -2.157  1.00  1.22           H 
ATOM    801 1HB  LEU    55       7.130 -15.105  -2.938  1.00 37.32           H 
ATOM    802 2HB  LEU    55       6.587 -16.532  -2.079  1.00 37.32           H 
ATOM    803  HG  LEU    55       6.664 -13.698  -1.015  1.00 54.13           H 
ATOM    804 1HD1 LEU    55       4.686 -14.828  -0.150  1.00 37.32           H 
ATOM    805 2HD1 LEU    55       5.898 -14.634   1.116  1.00 37.32           H 
ATOM    806 3HD1 LEU    55       5.669 -16.206   0.348  1.00 37.32           H 
ATOM    807 1HD2 LEU    55       8.839 -14.791  -1.105  1.00 37.32           H 
ATOM    808 2HD2 LEU    55       8.195 -16.186  -0.237  1.00 37.32           H 
ATOM    809 3HD2 LEU    55       8.299 -14.618   0.565  1.00 37.32           H 
ATOM    810  N   VAL    56       5.254 -13.012  -3.646  1.00 71.51           N 
ATOM    811  CA  VAL    56       4.974 -11.576  -3.736  1.00  2.13           C 
ATOM    812  C   VAL    56       3.505 -11.308  -4.097  1.00 53.33           C 
ATOM    813  O   VAL    56       2.873 -10.424  -3.520  1.00 60.30           O 
ATOM    814  CB  VAL    56       5.906 -10.879  -4.759  1.00 24.31           C 
ATOM    815  CG1 VAL    56       5.538  -9.407  -4.937  1.00 13.34           C 
ATOM    816  CG2 VAL    56       7.362 -11.019  -4.319  1.00  2.23           C 
ATOM    817  H   VAL    56       5.922 -13.410  -4.246  1.00 37.32           H 
ATOM    818  HA  VAL    56       5.170 -11.147  -2.761  1.00 73.44           H 
ATOM    819  HB  VAL    56       5.795 -11.373  -5.715  1.00 75.25           H 
ATOM    820 1HG1 VAL    56       6.207  -8.951  -5.654  1.00 37.32           H 
ATOM    821 2HG1 VAL    56       5.626  -8.893  -3.990  1.00 37.32           H 
ATOM    822 3HG1 VAL    56       4.522  -9.328  -5.295  1.00 37.32           H 
ATOM    823 1HG2 VAL    56       7.493 -10.556  -3.351  1.00 37.32           H 
ATOM    824 2HG2 VAL    56       8.006 -10.534  -5.039  1.00 37.32           H 
ATOM    825 3HG2 VAL    56       7.621 -12.066  -4.253  1.00 37.32           H 
ATOM    826  N   LYS    57       2.960 -12.077  -5.039  1.00 43.24           N 
ATOM    827  CA  LYS    57       1.546 -11.946  -5.413  1.00 31.43           C 
ATOM    828  C   LYS    57       0.625 -12.140  -4.198  1.00 34.55           C 
ATOM    829  O   LYS    57      -0.275 -11.334  -3.959  1.00 41.33           O 
ATOM    830  CB  LYS    57       1.187 -12.948  -6.516  1.00 22.21           C 
ATOM    831  CG  LYS    57       1.855 -12.647  -7.854  1.00 42.14           C 
ATOM    832  CD  LYS    57       1.543 -13.718  -8.896  1.00  2.45           C 
ATOM    833  CE  LYS    57       2.223 -13.423 -10.228  1.00 73.42           C 
ATOM    834  NZ  LYS    57       1.969 -14.489 -11.232  1.00 35.35           N 
ATOM    835  H   LYS    57       3.517 -12.747  -5.494  1.00 37.32           H 
ATOM    836  HA  LYS    57       1.402 -10.945  -5.793  1.00 43.01           H 
ATOM    837 1HB  LYS    57       0.116 -12.939  -6.663  1.00 37.32           H 
ATOM    838 2HB  LYS    57       1.488 -13.938  -6.199  1.00 37.32           H 
ATOM    839 1HG  LYS    57       2.926 -12.596  -7.708  1.00 37.32           H 
ATOM    840 2HG  LYS    57       1.496 -11.693  -8.217  1.00 37.32           H 
ATOM    841 1HD  LYS    57       0.473 -13.755  -9.050  1.00 37.32           H 
ATOM    842 2HD  LYS    57       1.888 -14.676  -8.532  1.00 37.32           H 
ATOM    843 1HE  LYS    57       3.289 -13.341 -10.067  1.00 37.32           H 
ATOM    844 2HE  LYS    57       1.846 -12.486 -10.613  1.00 37.32           H 
ATOM    845 1HZ  LYS    57       2.440 -14.254 -12.130  1.00 37.32           H 
ATOM    846 2HZ  LYS    57       0.949 -14.587 -11.404  1.00 37.32           H 
ATOM    847 3HZ  LYS    57       2.340 -15.400 -10.891  1.00 37.32           H 
ATOM    848  N   GLU    58       0.864 -13.200  -3.423  1.00 31.12           N 
ATOM    849  CA  GLU    58       0.089 -13.450  -2.201  1.00 54.34           C 
ATOM    850  C   GLU    58       0.240 -12.295  -1.193  1.00 54.12           C 
ATOM    851  O   GLU    58      -0.729 -11.900  -0.542  1.00 41.53           O 
ATOM    852  CB  GLU    58       0.502 -14.783  -1.554  1.00 21.13           C 
ATOM    853  CG  GLU    58       0.138 -16.012  -2.386  1.00 13.34           C 
ATOM    854  CD  GLU    58       0.190 -17.303  -1.579  1.00 70.42           C 
ATOM    855  OE1 GLU    58       1.284 -17.671  -1.105  1.00 55.43           O 
ATOM    856  OE2 GLU    58      -0.867 -17.959  -1.419  1.00 45.30           O 
ATOM    857  H   GLU    58       1.573 -13.830  -3.679  1.00 37.32           H 
ATOM    858  HA  GLU    58      -0.953 -13.515  -2.489  1.00 44.02           H 
ATOM    859 1HB  GLU    58       0.021 -14.871  -0.591  1.00 37.32           H 
ATOM    860 2HB  GLU    58       1.574 -14.779  -1.408  1.00 37.32           H 
ATOM    861 1HG  GLU    58       0.833 -16.093  -3.211  1.00 37.32           H 
ATOM    862 2HG  GLU    58      -0.863 -15.884  -2.775  1.00 37.32           H 
ATOM    863  N   LEU    59       1.456 -11.753  -1.070  1.00 33.14           N 
ATOM    864  CA  LEU    59       1.699 -10.578  -0.219  1.00 61.00           C 
ATOM    865  C   LEU    59       0.846  -9.377  -0.670  1.00 63.14           C 
ATOM    866  O   LEU    59       0.185  -8.734   0.147  1.00 13.02           O 
ATOM    867  CB  LEU    59       3.188 -10.207  -0.241  1.00 13.45           C 
ATOM    868  CG  LEU    59       4.131 -11.249   0.382  1.00 74.21           C 
ATOM    869  CD1 LEU    59       5.588 -10.892   0.106  1.00 12.50           C 
ATOM    870  CD2 LEU    59       3.879 -11.374   1.884  1.00 55.54           C 
ATOM    871  H   LEU    59       2.210 -12.157  -1.554  1.00 37.32           H 
ATOM    872  HA  LEU    59       1.420 -10.841   0.793  1.00 33.13           H 
ATOM    873 1HB  LEU    59       3.316  -9.274   0.292  1.00 37.32           H 
ATOM    874 2HB  LEU    59       3.481 -10.053  -1.271  1.00 37.32           H 
ATOM    875  HG  LEU    59       3.937 -12.212  -0.069  1.00 24.22           H 
ATOM    876 1HD1 LEU    59       6.234 -11.638   0.549  1.00 37.32           H 
ATOM    877 2HD1 LEU    59       5.813  -9.925   0.531  1.00 37.32           H 
ATOM    878 3HD1 LEU    59       5.754 -10.863  -0.962  1.00 37.32           H 
ATOM    879 1HD2 LEU    59       4.032 -10.415   2.359  1.00 37.32           H 
ATOM    880 2HD2 LEU    59       4.562 -12.097   2.306  1.00 37.32           H 
ATOM    881 3HD2 LEU    59       2.863 -11.702   2.053  1.00 37.32           H 
ATOM    882  N   ASN    60       0.862  -9.088  -1.975  1.00 74.50           N 
ATOM    883  CA  ASN    60       0.044  -8.005  -2.542  1.00 60.24           C 
ATOM    884  C   ASN    60      -1.444  -8.228  -2.268  1.00 34.01           C 
ATOM    885  O   ASN    60      -2.084  -7.421  -1.592  1.00 71.32           O 
ATOM    886  CB  ASN    60       0.268  -7.876  -4.051  1.00 12.20           C 
ATOM    887  CG  ASN    60       1.599  -7.244  -4.386  1.00 70.32           C 
ATOM    888  OD1 ASN    60       1.725  -6.035  -4.407  1.00 13.13           O 
ATOM    889  ND2 ASN    60       2.598  -8.049  -4.662  1.00 25.01           N 
ATOM    890  H   ASN    60       1.433  -9.615  -2.569  1.00 37.32           H 
ATOM    891  HA  ASN    60       0.346  -7.083  -2.065  1.00 30.05           H 
ATOM    892 1HB  ASN    60      -0.515  -7.263  -4.478  1.00 37.32           H 
ATOM    893 2HB  ASN    60       0.232  -8.858  -4.503  1.00 37.32           H 
ATOM    894 1HD2 ASN    60       2.437  -9.011  -4.643  1.00 37.32           H 
ATOM    895 2HD2 ASN    60       3.464  -7.644  -4.881  1.00 37.32           H 
ATOM    896  N   GLU    61      -1.980  -9.334  -2.791  1.00 12.01           N 
ATOM    897  CA  GLU    61      -3.394  -9.685  -2.603  1.00 63.54           C 
ATOM    898  C   GLU    61      -3.816  -9.518  -1.138  1.00 23.15           C 
ATOM    899  O   GLU    61      -4.845  -8.917  -0.848  1.00 13.12           O 
ATOM    900  CB  GLU    61      -3.650 -11.127  -3.077  1.00 60.50           C 
ATOM    901  CG  GLU    61      -3.484 -11.314  -4.584  1.00 62.35           C 
ATOM    902  CD  GLU    61      -3.639 -12.760  -5.040  1.00 32.34           C 
ATOM    903  OE1 GLU    61      -4.697 -13.372  -4.762  1.00 63.22           O 
ATOM    904  OE2 GLU    61      -2.725 -13.283  -5.714  1.00 23.20           O 
ATOM    905  H   GLU    61      -1.408  -9.933  -3.314  1.00 37.32           H 
ATOM    906  HA  GLU    61      -3.982  -9.009  -3.210  1.00  2.22           H 
ATOM    907 1HB  GLU    61      -4.659 -11.411  -2.809  1.00 37.32           H 
ATOM    908 2HB  GLU    61      -2.956 -11.786  -2.575  1.00 37.32           H 
ATOM    909 1HG  GLU    61      -2.499 -10.965  -4.866  1.00 37.32           H 
ATOM    910 2HG  GLU    61      -4.228 -10.715  -5.091  1.00 37.32           H 
ATOM    911  N   TYR    62      -2.989 -10.022  -0.226  1.00 11.44           N 
ATOM    912  CA  TYR    62      -3.237  -9.902   1.218  1.00 11.20           C 
ATOM    913  C   TYR    62      -3.505  -8.448   1.648  1.00 73.25           C 
ATOM    914  O   TYR    62      -4.566  -8.140   2.202  1.00 52.40           O 
ATOM    915  CB  TYR    62      -2.039 -10.475   1.984  1.00 21.11           C 
ATOM    916  CG  TYR    62      -2.106 -10.309   3.493  1.00 34.15           C 
ATOM    917  CD1 TYR    62      -1.322  -9.359   4.142  1.00  4.22           C 
ATOM    918  CD2 TYR    62      -2.940 -11.110   4.267  1.00 11.23           C 
ATOM    919  CE1 TYR    62      -1.368  -9.213   5.514  1.00 24.52           C 
ATOM    920  CE2 TYR    62      -2.992 -10.967   5.642  1.00 30.24           C 
ATOM    921  CZ  TYR    62      -2.203 -10.017   6.261  1.00 11.53           C 
ATOM    922  OH  TYR    62      -2.250  -9.865   7.629  1.00 22.22           O 
ATOM    923  H   TYR    62      -2.184 -10.495  -0.530  1.00 37.32           H 
ATOM    924  HA  TYR    62      -4.111 -10.492   1.446  1.00  4.13           H 
ATOM    925 1HB  TYR    62      -1.138  -9.989   1.636  1.00 37.32           H 
ATOM    926 2HB  TYR    62      -1.966 -11.533   1.775  1.00 37.32           H 
ATOM    927  HD1 TYR    62      -0.668  -8.728   3.557  1.00  1.25           H 
ATOM    928  HD2 TYR    62      -3.557 -11.854   3.781  1.00 21.33           H 
ATOM    929  HE1 TYR    62      -0.750  -8.470   5.997  1.00  4.43           H 
ATOM    930  HE2 TYR    62      -3.645 -11.599   6.226  1.00 44.25           H 
ATOM    931  HH  TYR    62      -2.190  -8.925   7.843  1.00 20.10           H 
ATOM    932  N   PHE    63      -2.551  -7.553   1.392  1.00 21.42           N 
ATOM    933  CA  PHE    63      -2.718  -6.133   1.738  1.00 51.33           C 
ATOM    934  C   PHE    63      -3.923  -5.519   1.011  1.00 64.32           C 
ATOM    935  O   PHE    63      -4.717  -4.787   1.608  1.00 64.23           O 
ATOM    936  CB  PHE    63      -1.454  -5.330   1.400  1.00 42.14           C 
ATOM    937  CG  PHE    63      -0.300  -5.561   2.346  1.00 11.32           C 
ATOM    938  CD1 PHE    63      -0.284  -4.957   3.598  1.00  4.31           C 
ATOM    939  CD2 PHE    63       0.771  -6.365   1.983  1.00 10.41           C 
ATOM    940  CE1 PHE    63       0.776  -5.153   4.463  1.00  1.42           C 
ATOM    941  CE2 PHE    63       1.831  -6.565   2.847  1.00 55.44           C 
ATOM    942  CZ  PHE    63       1.834  -5.957   4.087  1.00 40.20           C 
ATOM    943  H   PHE    63      -1.723  -7.848   0.952  1.00 37.32           H 
ATOM    944  HA  PHE    63      -2.894  -6.076   2.806  1.00 73.32           H 
ATOM    945 1HB  PHE    63      -1.691  -4.274   1.419  1.00 37.32           H 
ATOM    946 2HB  PHE    63      -1.125  -5.596   0.406  1.00 37.32           H 
ATOM    947  HD1 PHE    63      -1.111  -4.329   3.897  1.00 13.34           H 
ATOM    948  HD2 PHE    63       0.773  -6.842   1.012  1.00  2.34           H 
ATOM    949  HE1 PHE    63       0.776  -4.677   5.434  1.00 63.03           H 
ATOM    950  HE2 PHE    63       2.659  -7.196   2.552  1.00 54.12           H 
ATOM    951  HZ  PHE    63       2.666  -6.109   4.763  1.00  1.20           H 
ATOM    952  N   GLU    64      -4.061  -5.840  -0.274  1.00  2.21           N 
ATOM    953  CA  GLU    64      -5.123  -5.270  -1.108  1.00 24.23           C 
ATOM    954  C   GLU    64      -6.514  -5.777  -0.681  1.00 21.24           C 
ATOM    955  O   GLU    64      -7.533  -5.160  -0.999  1.00 51.43           O 
ATOM    956  CB  GLU    64      -4.841  -5.559  -2.593  1.00 63.10           C 
ATOM    957  CG  GLU    64      -3.461  -5.063  -3.035  1.00 53.21           C 
ATOM    958  CD  GLU    64      -3.272  -5.011  -4.547  1.00 10.43           C 
ATOM    959  OE1 GLU    64      -2.759  -5.991  -5.130  1.00 63.42           O 
ATOM    960  OE2 GLU    64      -3.603  -3.970  -5.160  1.00 34.01           O 
ATOM    961  H   GLU    64      -3.434  -6.481  -0.673  1.00 37.32           H 
ATOM    962  HA  GLU    64      -5.101  -4.198  -0.961  1.00 73.25           H 
ATOM    963 1HB  GLU    64      -5.591  -5.068  -3.198  1.00 37.32           H 
ATOM    964 2HB  GLU    64      -4.894  -6.627  -2.761  1.00 37.32           H 
ATOM    965 1HG  GLU    64      -2.713  -5.722  -2.619  1.00 37.32           H 
ATOM    966 2HG  GLU    64      -3.311  -4.071  -2.638  1.00 37.32           H 
ATOM    967  N   LYS    65      -6.560  -6.900   0.040  1.00 74.14           N 
ATOM    968  CA  LYS    65      -7.798  -7.335   0.706  1.00 74.14           C 
ATOM    969  C   LYS    65      -8.122  -6.398   1.880  1.00 64.54           C 
ATOM    970  O   LYS    65      -9.262  -5.957   2.052  1.00 14.25           O 
ATOM    971  CB  LYS    65      -7.675  -8.773   1.236  1.00 65.45           C 
ATOM    972  CG  LYS    65      -7.436  -9.826   0.159  1.00 24.44           C 
ATOM    973  CD  LYS    65      -8.648 -10.035  -0.748  1.00 71.34           C 
ATOM    974  CE  LYS    65      -8.408 -11.172  -1.742  1.00 10.54           C 
ATOM    975  NZ  LYS    65      -9.561 -11.379  -2.660  1.00 15.40           N 
ATOM    976  H   LYS    65      -5.751  -7.457   0.112  1.00 37.32           H 
ATOM    977  HA  LYS    65      -8.602  -7.288  -0.016  1.00 23.53           H 
ATOM    978 1HB  LYS    65      -8.585  -9.028   1.762  1.00 37.32           H 
ATOM    979 2HB  LYS    65      -6.849  -8.814   1.932  1.00 37.32           H 
ATOM    980 1HG  LYS    65      -7.189 -10.764   0.638  1.00 37.32           H 
ATOM    981 2HG  LYS    65      -6.606  -9.508  -0.451  1.00 37.32           H 
ATOM    982 1HD  LYS    65      -8.841  -9.122  -1.296  1.00 37.32           H 
ATOM    983 2HD  LYS    65      -9.507 -10.278  -0.138  1.00 37.32           H 
ATOM    984 1HE  LYS    65      -8.236 -12.084  -1.189  1.00 37.32           H 
ATOM    985 2HE  LYS    65      -7.532 -10.942  -2.331  1.00 37.32           H 
ATOM    986 1HZ  LYS    65      -9.390 -12.207  -3.267  1.00 37.32           H 
ATOM    987 2HZ  LYS    65      -9.692 -10.544  -3.266  1.00 37.32           H 
ATOM    988 3HZ  LYS    65     -10.432 -11.538  -2.114  1.00 37.32           H 
ATOM    989  N   LYS    66      -7.099  -6.094   2.683  1.00  1.13           N 
ATOM    990  CA  LYS    66      -7.253  -5.209   3.845  1.00  3.31           C 
ATOM    991  C   LYS    66      -7.714  -3.808   3.428  1.00 40.31           C 
ATOM    992  O   LYS    66      -8.534  -3.186   4.106  1.00 42.20           O 
ATOM    993  CB  LYS    66      -5.937  -5.088   4.619  1.00 34.22           C 
ATOM    994  CG  LYS    66      -5.375  -6.414   5.117  1.00 20.02           C 
ATOM    995  CD  LYS    66      -4.151  -6.200   6.004  1.00 70.21           C 
ATOM    996  CE  LYS    66      -4.508  -5.430   7.274  1.00  3.11           C 
ATOM    997  NZ  LYS    66      -3.321  -5.167   8.129  1.00 21.53           N 
ATOM    998  H   LYS    66      -6.215  -6.477   2.489  1.00 37.32           H 
ATOM    999  HA  LYS    66      -8.003  -5.641   4.493  1.00 21.15           H 
ATOM   1000 1HB  LYS    66      -6.099  -4.448   5.475  1.00 37.32           H 
ATOM   1001 2HB  LYS    66      -5.197  -4.629   3.977  1.00 37.32           H 
ATOM   1002 1HG  LYS    66      -5.091  -7.019   4.265  1.00 37.32           H 
ATOM   1003 2HG  LYS    66      -6.137  -6.927   5.685  1.00 37.32           H 
ATOM   1004 1HD  LYS    66      -3.408  -5.640   5.451  1.00 37.32           H 
ATOM   1005 2HD  LYS    66      -3.744  -7.163   6.278  1.00 37.32           H 
ATOM   1006 1HE  LYS    66      -5.225  -6.006   7.841  1.00 37.32           H 
ATOM   1007 2HE  LYS    66      -4.950  -4.485   6.996  1.00 37.32           H 
ATOM   1008 1HZ  LYS    66      -2.867  -6.062   8.394  1.00 37.32           H 
ATOM   1009 2HZ  LYS    66      -3.606  -4.672   8.998  1.00 37.32           H 
ATOM   1010 3HZ  LYS    66      -2.631  -4.580   7.620  1.00 37.32           H 
ATOM   1011  N   GLU    67      -7.180  -3.315   2.312  1.00 32.43           N 
ATOM   1012  CA  GLU    67      -7.556  -1.997   1.781  1.00 62.04           C 
ATOM   1013  C   GLU    67      -9.051  -1.944   1.404  1.00 12.03           C 
ATOM   1014  O   GLU    67      -9.596  -0.874   1.121  1.00 54.11           O 
ATOM   1015  CB  GLU    67      -6.679  -1.650   0.566  1.00 73.13           C 
ATOM   1016  CG  GLU    67      -5.183  -1.644   0.878  1.00 21.01           C 
ATOM   1017  CD  GLU    67      -4.324  -1.153  -0.279  1.00 73.41           C 
ATOM   1018  OE1 GLU    67      -4.111  -1.914  -1.244  1.00 65.34           O 
ATOM   1019  OE2 GLU    67      -3.841  -0.001  -0.224  1.00 35.01           O 
ATOM   1020  H   GLU    67      -6.504  -3.847   1.834  1.00 37.32           H 
ATOM   1021  HA  GLU    67      -7.375  -1.268   2.560  1.00 25.04           H 
ATOM   1022 1HB  GLU    67      -6.954  -0.669   0.203  1.00 37.32           H 
ATOM   1023 2HB  GLU    67      -6.860  -2.377  -0.214  1.00 37.32           H 
ATOM   1024 1HG  GLU    67      -4.881  -2.652   1.127  1.00 37.32           H 
ATOM   1025 2HG  GLU    67      -5.010  -1.004   1.732  1.00 37.32           H 
END
