
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   93 (  749),  selected   93 , name 1yd8_H
# Molecule2: number of CA atoms   91 (  736),  selected   91 , name T0470_112_214.pdb
# PARAMETERS: 1yd8_H.T0470_112_214.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S     112           -
LGA    G    -1_H      I     113          2.743
LGA    I   208_H      E     114          3.341
LGA    Q   209_H      G     115          3.424
LGA    K   210_H      K     116          3.054
LGA    V   211_H      L     117          2.063
LGA    T   212_H      V     118          2.436
LGA    K   213_H      Q     119          2.233
LGA    R   214_H      D     120          1.722
LGA    L   215_H      A     121          1.607
LGA    H   216_H      D     122          1.527
LGA    T   217_H      R     123          1.436
LGA    L   218_H      L     124          1.364
LGA    E   219_H      D     125          1.446
LGA    E   220_H      A     126          1.357
LGA    V   221_H      L     127          1.041
LGA    N   222_H      G     128          2.265
LGA    N   223_H      A     129          5.094
LGA    N   224_H      I     130          4.547
LGA    V   225_H      G     131          4.383
LGA    R   226_H      I     132          4.359
LGA    L   227_H      A     133          1.332
LGA    L   228_H      R     134           #
LGA    S   229_H      T     135           -
LGA    E   230_H      F     136           -
LGA    M   231_H      A     137           #
LGA    L   232_H      Y     138           -
LGA    L   233_H      G     139           -
LGA    H   234_H      G     140           -
LGA    Y   235_H      A     141           -
LGA    S   236_H      K     142           -
LGA    Q   237_H      -       -           -
LGA    E   238_H      -       -           -
LGA    D   239_H      -       -           -
LGA    S   240_H      -       -           -
LGA    S   241_H      -       -           -
LGA    D   242_H      -       -           -
LGA    G   243_H      G     143           #
LGA    D   244_H      R     144           #
LGA    R   245_H      -       -           -
LGA    E   246_H      L     145          1.330
LGA    L   247_H      M     146          3.245
LGA    M   248_H      Y     147           #
LGA    K   249_H      D     148           #
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    E   250_H      P     168          2.498
LGA    L   251_H      S     169          2.531
LGA    F   252_H      L     170          1.297
LGA    D   253_H      N     171          0.963
LGA    Q   254_H      H     172          1.342
LGA    C   255_H      F     173          1.408
LGA    E   256_H      Y     174          1.964
LGA    N   257_H      E     175          3.288
LGA    -       -      K     176           -
LGA    K   258_H      L     177          0.989
LGA    R   259_H      L     178          0.928
LGA    R   260_H      K     179          1.966
LGA    T   261_H      L     180          2.631
LGA    L   262_H      K     181          1.570
LGA    F   263_H      D     182          3.174
LGA    K   264_H      -       -           -
LGA    L   265_H      L     183          2.038
LGA    A   266_H      M     184          5.829
LGA    S   267_H      -       -           -
LGA    E   268_H      -       -           -
LGA    T   269_H      N     185          5.952
LGA    E   270_H      T     186           #
LGA    D   271_H      -       -           -
LGA    N   272_H      -       -           -
LGA    D   273_H      N     187          3.370
LGA    N   274_H      A     188          1.604
LGA    S   275_H      A     189          2.749
LGA    L   276_H      K     190          2.365
LGA    G   277_H      Q     191          1.168
LGA    D   278_H      E     192          1.375
LGA    I   279_H      A     193          1.932
LGA    L   280_H      E     194          0.951
LGA    Q   281_H      V     195          0.944
LGA    A   282_H      R     196          1.211
LGA    S   283_H      H     197          1.071
LGA    D   284_H      R     198          0.496
LGA    N   285_H      Y     199          0.742
LGA    L   286_H      M     200          1.312
LGA    S   287_H      E     201          0.550
LGA    R   288_H      Q     202          0.961
LGA    V   289_H      F     203          1.150
LGA    I   290_H      I     204          1.468
LGA    N   291_H      E     205          0.875
LGA    S   292_H      Q     206          1.516
LGA    Y   293_H      F     207          1.531
LGA    K   294_H      M     208          1.167
LGA    T   295_H      K     209          1.200
LGA    I   296_H      E     210          1.615
LGA    I   297_H      W     211          1.484
LGA    E   298_H      N     212          1.664
LGA    G   299_H      A     213          1.445
LGA    -       -      Q     214           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   93   91    5.0     67    2.36     5.97     55.670     2.728

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.495249 * X  +   0.603433 * Y  +  -0.624977 * Z  +  47.525745
  Y_new =  -0.317651 * X  +   0.543803 * Y  +   0.776773 * Z  +   2.601623
  Z_new =   0.808595 * X  +   0.583221 * Y  +  -0.077636 * Z  +  44.858437 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.703135   -1.438458  [ DEG:    97.5824    -82.4176 ]
  Theta =  -0.941761   -2.199832  [ DEG:   -53.9589   -126.0411 ]
  Phi   =  -2.571289    0.570304  [ DEG:  -147.3240     32.6760 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yd8_H                                        
REMARK     2: T0470_112_214.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yd8_H.T0470_112_214.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   93   91   5.0   67   2.36    5.97  55.670
REMARK  ---------------------------------------------------------- 
MOLECULE 1yd8_H
HEADER    PROTEIN TRANSPORT, CHROMOSOMAL PROTEIN  23-DEC-04   1YD8              
TITLE     COMPLEX OF HUMAN GGA3 GAT DOMAIN AND UBIQUITIN                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UBIQUIN;                                                   
COMPND   3 CHAIN: U, V;                                                         
COMPND   4 MOL_ID: 2;                                                           
COMPND   5 MOLECULE: ADP-RIBOSYLATION FACTOR BINDING PROTEIN GGA3;              
COMPND   6 CHAIN: G, H;                                                         
COMPND   7 SYNONYM: GOLGI-LOCALIZED, GAMMA EAR-CONTAINING, ARF-                 
COMPND   8 BINDING PROTEIN 3;                                                   
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BOS TAURUS;                                     
SOURCE   3 ORGANISM_COMMON: BOVINE;                                             
SOURCE   4 TISSUE: RED BLOOD CELLS;                                             
SOURCE   5 MOL_ID: 2;                                                           
SOURCE   6 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   7 ORGANISM_COMMON: HUMAN;                                              
SOURCE   8 GENE: GGA3, KIAA0154;                                                
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  11 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) ROSETTA;                         
SOURCE  12 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  13 EXPRESSION_SYSTEM_PLASMID: PET-PARALLEL.3_HIS6_GAT                   
KEYWDS    TRAFFICKING, POST TRANSLATIONAL MODIFICATION, MONO-                   
KEYWDS   2 UBIQUITINATION, PROTEIN TRANSPORT;                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    G.PRAG,S.LEE,R.MATTERA,C.N.ARIGHI,B.M.BEACH,J.S.BONIFACINO,           
AUTHOR   2 J.H.HURLEY                                                           
REVDAT   1   22-FEB-05 1YD8    0                                                
JRNL        AUTH   G.PRAG,S.LEE,R.MATTERA,C.N.ARIGHI,B.M.BEACH,                 
JRNL        AUTH 2 J.S.BONIFACINO,J.H.HURLEY                                    
JRNL        TITL   STRUCTURAL MECHANISM FOR UBIQUITINATED-CARGO                 
JRNL        TITL 2 RECOGNITION BY THE GOLGI-LOCALIZED,                          
JRNL        TITL 3 {GAMMA}-EAR-CONTAINING,                                      
JRNL        TITL 4 ADP-RIBOSYLATION-FACTOR-BINDING PROTEINS                     
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 102  2334 2005              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  1YD8 U    1    76  UNP    P62990   UBIQ_BOVIN       1     76             
DBREF  1YD8 V    1    76  UNP    P62990   UBIQ_BOVIN       1     76             
DBREF  1YD8 G  208   301  UNP    Q9NZ52   GGA3_HUMAN     208    301             
DBREF  1YD8 H  208   301  UNP    Q9NZ52   GGA3_HUMAN     208    301             
SEQRES   1 U   76  MET GLN ILE PHE VAL LYS THR LEU THR GLY LYS THR ILE          
SEQRES   2 U   76  THR LEU GLU VAL GLU PRO SER ASP THR ILE GLU ASN VAL          
SEQRES   3 U   76  LYS ALA LYS ILE GLN ASP LYS GLU GLY ILE PRO PRO ASP          
SEQRES   4 U   76  GLN GLN ARG LEU ILE PHE ALA GLY LYS GLN LEU GLU ASP          
SEQRES   5 U   76  GLY ARG THR LEU SER ASP TYR ASN ILE GLN LYS GLU SER          
SEQRES   6 U   76  THR LEU HIS LEU VAL LEU ARG LEU ARG GLY GLY                  
SEQRES   1 G   98  GLY ALA MET GLY ILE GLN LYS VAL THR LYS ARG LEU HIS          
SEQRES   2 G   98  THR LEU GLU GLU VAL ASN ASN ASN VAL ARG LEU LEU SER          
SEQRES   3 G   98  GLU MET LEU LEU HIS TYR SER GLN GLU ASP SER SER ASP          
SEQRES   4 G   98  GLY ASP ARG GLU LEU MET LYS GLU LEU PHE ASP GLN CYS          
SEQRES   5 G   98  GLU ASN LYS ARG ARG THR LEU PHE LYS LEU ALA SER GLU          
SEQRES   6 G   98  THR GLU ASP ASN ASP ASN SER LEU GLY ASP ILE LEU GLN          
SEQRES   7 G   98  ALA SER ASP ASN LEU SER ARG VAL ILE ASN SER TYR LYS          
SEQRES   8 G   98  THR ILE ILE GLU GLY GLN VAL                                  
SEQRES   1 V   76  MET GLN ILE PHE VAL LYS THR LEU THR GLY LYS THR ILE          
SEQRES   2 V   76  THR LEU GLU VAL GLU PRO SER ASP THR ILE GLU ASN VAL          
SEQRES   3 V   76  LYS ALA LYS ILE GLN ASP LYS GLU GLY ILE PRO PRO ASP          
SEQRES   4 V   76  GLN GLN ARG LEU ILE PHE ALA GLY LYS GLN LEU GLU ASP          
SEQRES   5 V   76  GLY ARG THR LEU SER ASP TYR ASN ILE GLN LYS GLU SER          
SEQRES   6 V   76  THR LEU HIS LEU VAL LEU ARG LEU ARG GLY GLY                  
SEQRES   1 H   98  GLY ALA MET GLY ILE GLN LYS VAL THR LYS ARG LEU HIS          
SEQRES   2 H   98  THR LEU GLU GLU VAL ASN ASN ASN VAL ARG LEU LEU SER          
SEQRES   3 H   98  GLU MET LEU LEU HIS TYR SER GLN GLU ASP SER SER ASP          
SEQRES   4 H   98  GLY ASP ARG GLU LEU MET LYS GLU LEU PHE ASP GLN CYS          
SEQRES   5 H   98  GLU ASN LYS ARG ARG THR LEU PHE LYS LEU ALA SER GLU          
SEQRES   6 H   98  THR GLU ASP ASN ASP ASN SER LEU GLY ASP ILE LEU GLN          
SEQRES   7 H   98  ALA SER ASP ASN LEU SER ARG VAL ILE ASN SER TYR LYS          
SEQRES   8 H   98  THR ILE ILE GLU GLY GLN VAL                                  
FORMUL   5  HOH   *146(H2 O)                                                    
CRYST1   47.886   97.293   66.459  90.00  90.03  90.00 C 1 2 1       8          
ATOM   1917  N   GLY H  -1      38.938  37.375  72.550  1.00 64.92           N  
ATOM   1918  CA  GLY H  -1      39.636  36.053  72.580  1.00 65.09           C  
ATOM   1919  C   GLY H  -1      40.828  36.058  73.516  1.00 64.10           C  
ATOM   1920  O   GLY H  -1      41.072  35.092  74.239  1.00 63.73           O  
ATOM   1921  N   ILE H 208      41.574  37.154  73.489  1.00 63.60           N  
ATOM   1922  CA  ILE H 208      42.748  37.310  74.335  1.00 63.67           C  
ATOM   1923  C   ILE H 208      42.382  38.220  75.506  1.00 63.81           C  
ATOM   1924  O   ILE H 208      42.246  37.779  76.650  1.00 63.40           O  
ATOM   1925  CB  ILE H 208      43.926  37.932  73.528  1.00 63.22           C  
ATOM   1926  CG1 ILE H 208      45.017  38.432  74.475  1.00 61.60           C  
ATOM   1927  CG2 ILE H 208      43.406  39.055  72.619  1.00 63.23           C  
ATOM   1928  CD1 ILE H 208      46.124  39.182  73.776  1.00 60.25           C  
ATOM   1929  N   GLN H 209      42.208  39.499  75.205  1.00 63.81           N  
ATOM   1930  CA  GLN H 209      41.859  40.464  76.218  1.00 63.58           C  
ATOM   1931  C   GLN H 209      40.519  41.063  75.855  1.00 62.90           C  
ATOM   1932  O   GLN H 209      40.079  42.029  76.470  1.00 64.05           O  
ATOM   1933  CB  GLN H 209      42.932  41.555  76.305  1.00 66.05           C  
ATOM   1934  CG  GLN H 209      42.603  42.909  75.643  1.00 68.62           C  
ATOM   1935  CD  GLN H 209      42.518  42.866  74.124  1.00 69.44           C  
ATOM   1936  OE1 GLN H 209      42.601  43.911  73.470  1.00 69.73           O  
ATOM   1937  NE2 GLN H 209      42.342  41.670  73.558  1.00 69.18           N  
ATOM   1938  N   LYS H 210      39.873  40.497  74.842  1.00 61.70           N  
ATOM   1939  CA  LYS H 210      38.562  40.986  74.432  1.00 59.41           C  
ATOM   1940  C   LYS H 210      37.566  40.705  75.554  1.00 56.86           C  
ATOM   1941  O   LYS H 210      36.458  41.230  75.566  1.00 56.47           O  
ATOM   1942  CB  LYS H 210      38.108  40.317  73.126  1.00 59.89           C  
ATOM   1943  CG  LYS H 210      38.566  41.053  71.864  1.00 61.07           C  
ATOM   1944  CD  LYS H 210      38.125  42.524  71.879  1.00 62.38           C  
ATOM   1945  CE  LYS H 210      38.451  43.249  70.570  1.00 63.52           C  
ATOM   1946  NZ  LYS H 210      38.098  44.713  70.609  1.00 64.42           N  
ATOM   1947  N   VAL H 211      37.983  39.873  76.499  1.00 54.27           N  
ATOM   1948  CA  VAL H 211      37.161  39.525  77.644  1.00 53.09           C  
ATOM   1949  C   VAL H 211      37.232  40.647  78.682  1.00 52.40           C  
ATOM   1950  O   VAL H 211      36.266  40.937  79.389  1.00 51.99           O  
ATOM   1951  CB  VAL H 211      37.653  38.217  78.271  1.00 53.89           C  
ATOM   1952  CG1 VAL H 211      39.176  38.263  78.457  1.00 54.42           C  
ATOM   1953  CG2 VAL H 211      36.948  37.986  79.599  1.00 54.76           C  
ATOM   1954  N   THR H 212      38.402  41.270  78.760  1.00 52.00           N  
ATOM   1955  CA  THR H 212      38.657  42.375  79.671  1.00 49.85           C  
ATOM   1956  C   THR H 212      38.058  43.638  79.082  1.00 48.77           C  
ATOM   1957  O   THR H 212      37.307  44.349  79.743  1.00 49.55           O  
ATOM   1958  CB  THR H 212      40.156  42.602  79.827  1.00 49.96           C  
ATOM   1959  OG1 THR H 212      40.782  41.349  80.122  1.00 50.16           O  
ATOM   1960  CG2 THR H 212      40.439  43.621  80.946  1.00 49.72           C  
ATOM   1961  N   LYS H 213      38.413  43.909  77.831  1.00 47.14           N  
ATOM   1962  CA  LYS H 213      37.922  45.079  77.130  1.00 45.21           C  
ATOM   1963  C   LYS H 213      36.424  45.076  77.317  1.00 44.33           C  
ATOM   1964  O   LYS H 213      35.786  46.119  77.308  1.00 44.89           O  
ATOM   1965  CB  LYS H 213      38.291  44.997  75.644  1.00 45.87           C  
ATOM   1966  CG  LYS H 213      38.094  46.296  74.856  1.00 46.50           C  
ATOM   1967  CD  LYS H 213      38.765  46.259  73.463  1.00 46.87           C  
ATOM   1968  CE  LYS H 213      40.291  46.386  73.528  1.00 45.19           C  
ATOM   1969  NZ  LYS H 213      40.926  46.353  72.164  1.00 44.36           N  
ATOM   1970  N   ARG H 214      35.864  43.889  77.512  1.00 44.10           N  
ATOM   1971  CA  ARG H 214      34.434  43.768  77.730  1.00 44.19           C  
ATOM   1972  C   ARG H 214      34.121  44.170  79.152  1.00 43.51           C  
ATOM   1973  O   ARG H 214      33.445  45.166  79.383  1.00 42.63           O  
ATOM   1974  CB  ARG H 214      33.966  42.328  77.491  1.00 46.58           C  
ATOM   1975  CG  ARG H 214      32.631  41.966  78.157  1.00 47.71           C  
ATOM   1976  CD  ARG H 214      31.505  42.967  77.839  1.00 51.24           C  
ATOM   1977  NE  ARG H 214      31.041  42.923  76.449  1.00 52.84           N  
ATOM   1978  CZ  ARG H 214      31.419  43.771  75.489  1.00 54.71           C  
ATOM   1979  NH1 ARG H 214      32.282  44.761  75.744  1.00 52.93           N  
ATOM   1980  NH2 ARG H 214      30.928  43.620  74.262  1.00 54.49           N  
ATOM   1981  N   LEU H 215      34.623  43.396  80.109  1.00 43.02           N  
ATOM   1982  CA  LEU H 215      34.366  43.702  81.497  1.00 42.47           C  
ATOM   1983  C   LEU H 215      34.653  45.156  81.792  1.00 42.59           C  
ATOM   1984  O   LEU H 215      34.018  45.758  82.655  1.00 41.64           O  
ATOM   1985  CB  LEU H 215      35.210  42.844  82.417  1.00 43.44           C  
ATOM   1986  CG  LEU H 215      34.913  43.274  83.859  1.00 45.13           C  
ATOM   1987  CD1 LEU H 215      33.403  43.198  84.092  1.00 45.49           C  
ATOM   1988  CD2 LEU H 215      35.666  42.402  84.849  1.00 45.43           C  
ATOM   1989  N   HIS H 216      35.610  45.721  81.068  1.00 43.10           N  
ATOM   1990  CA  HIS H 216      35.973  47.113  81.259  1.00 43.63           C  
ATOM   1991  C   HIS H 216      34.862  48.070  80.918  1.00 43.33           C  
ATOM   1992  O   HIS H 216      34.773  49.143  81.500  1.00 44.39           O  
ATOM   1993  CB  HIS H 216      37.215  47.455  80.457  1.00 44.63           C  
ATOM   1994  CG  HIS H 216      38.460  47.441  81.277  1.00 46.20           C  
ATOM   1995  ND1 HIS H 216      38.792  46.384  82.097  1.00 47.41           N  
ATOM   1996  CD2 HIS H 216      39.433  48.367  81.438  1.00 46.68           C  
ATOM   1997  CE1 HIS H 216      39.916  46.660  82.734  1.00 47.75           C  
ATOM   1998  NE2 HIS H 216      40.326  47.858  82.352  1.00 48.79           N  
ATOM   1999  N   THR H 217      34.013  47.697  79.973  1.00 43.00           N  
ATOM   2000  CA  THR H 217      32.904  48.565  79.625  1.00 43.74           C  
ATOM   2001  C   THR H 217      31.807  48.394  80.675  1.00 44.36           C  
ATOM   2002  O   THR H 217      31.091  49.341  81.005  1.00 44.71           O  
ATOM   2003  CB  THR H 217      32.343  48.249  78.217  1.00 42.73           C  
ATOM   2004  OG1 THR H 217      32.141  46.842  78.086  1.00 43.37           O  
ATOM   2005  CG2 THR H 217      33.312  48.719  77.137  1.00 43.45           C  
ATOM   2006  N   LEU H 218      31.703  47.187  81.221  1.00 44.53           N  
ATOM   2007  CA  LEU H 218      30.699  46.876  82.230  1.00 44.18           C  
ATOM   2008  C   LEU H 218      30.972  47.626  83.517  1.00 44.58           C  
ATOM   2009  O   LEU H 218      30.047  48.098  84.175  1.00 44.15           O  
ATOM   2010  CB  LEU H 218      30.709  45.387  82.514  1.00 45.08           C  
ATOM   2011  CG  LEU H 218      30.542  44.525  81.269  1.00 46.21           C  
ATOM   2012  CD1 LEU H 218      30.985  43.106  81.592  1.00 47.58           C  
ATOM   2013  CD2 LEU H 218      29.098  44.578  80.797  1.00 45.47           C  
ATOM   2014  N   GLU H 219      32.250  47.714  83.879  1.00 45.12           N  
ATOM   2015  CA  GLU H 219      32.666  48.418  85.088  1.00 45.42           C  
ATOM   2016  C   GLU H 219      32.216  49.853  84.978  1.00 44.58           C  
ATOM   2017  O   GLU H 219      31.660  50.424  85.917  1.00 43.89           O  
ATOM   2018  CB  GLU H 219      34.186  48.386  85.236  1.00 47.97           C  
ATOM   2019  CG  GLU H 219      34.743  46.995  85.412  1.00 50.85           C  
ATOM   2020  CD  GLU H 219      34.120  46.281  86.592  1.00 52.10           C  
ATOM   2021  OE1 GLU H 219      32.870  46.282  86.704  1.00 53.33           O  
ATOM   2022  OE2 GLU H 219      34.877  45.713  87.405  1.00 53.16           O  
ATOM   2023  N   GLU H 220      32.458  50.421  83.806  1.00 42.21           N  
ATOM   2024  CA  GLU H 220      32.087  51.783  83.546  1.00 42.29           C  
ATOM   2025  C   GLU H 220      30.564  51.972  83.685  1.00 43.13           C  
ATOM   2026  O   GLU H 220      30.104  52.962  84.265  1.00 44.35           O  
ATOM   2027  CB  GLU H 220      32.559  52.157  82.151  1.00 41.36           C  
ATOM   2028  CG  GLU H 220      32.681  53.643  81.919  1.00 41.56           C  
ATOM   2029  CD  GLU H 220      32.905  53.955  80.462  1.00 41.56           C  
ATOM   2030  OE1 GLU H 220      31.990  53.649  79.669  1.00 40.61           O  
ATOM   2031  OE2 GLU H 220      33.983  54.497  80.109  1.00 41.46           O  
ATOM   2032  N   VAL H 221      29.786  51.028  83.166  1.00 42.25           N  
ATOM   2033  CA  VAL H 221      28.331  51.116  83.251  1.00 44.01           C  
ATOM   2034  C   VAL H 221      27.839  51.114  84.700  1.00 44.62           C  
ATOM   2035  O   VAL H 221      27.140  52.031  85.140  1.00 43.26           O  
ATOM   2036  CB  VAL H 221      27.638  49.933  82.513  1.00 44.46           C  
ATOM   2037  CG1 VAL H 221      26.118  49.997  82.722  1.00 43.60           C  
ATOM   2038  CG2 VAL H 221      27.961  49.972  81.032  1.00 44.57           C  
ATOM   2039  N   ASN H 222      28.195  50.064  85.426  1.00 46.21           N  
ATOM   2040  CA  ASN H 222      27.802  49.931  86.820  1.00 47.85           C  
ATOM   2041  C   ASN H 222      28.352  51.118  87.612  1.00 48.46           C  
ATOM   2042  O   ASN H 222      27.715  51.609  88.542  1.00 48.39           O  
ATOM   2043  CB  ASN H 222      28.352  48.622  87.383  1.00 48.58           C  
ATOM   2044  CG  ASN H 222      27.352  47.905  88.272  1.00 49.34           C  
ATOM   2045  OD1 ASN H 222      26.922  48.434  89.293  1.00 49.56           O  
ATOM   2046  ND2 ASN H 222      26.977  46.693  87.881  1.00 49.59           N  
ATOM   2047  N   ASN H 223      29.539  51.581  87.231  1.00 49.17           N  
ATOM   2048  CA  ASN H 223      30.143  52.714  87.909  1.00 49.79           C  
ATOM   2049  C   ASN H 223      29.139  53.847  87.967  1.00 50.65           C  
ATOM   2050  O   ASN H 223      28.613  54.167  89.039  1.00 51.37           O  
ATOM   2051  CB  ASN H 223      31.426  53.151  87.186  1.00 49.35           C  
ATOM   2052  CG  ASN H 223      32.653  52.350  87.644  1.00 49.26           C  
ATOM   2053  OD1 ASN H 223      33.657  52.247  86.932  1.00 49.36           O  
ATOM   2054  ND2 ASN H 223      32.571  51.788  88.848  1.00 47.50           N  
ATOM   2055  N   ASN H 224      28.849  54.444  86.817  1.00 50.78           N  
ATOM   2056  CA  ASN H 224      27.895  55.544  86.790  1.00 51.11           C  
ATOM   2057  C   ASN H 224      26.612  55.221  87.544  1.00 50.98           C  
ATOM   2058  O   ASN H 224      26.224  55.970  88.453  1.00 51.79           O  
ATOM   2059  CB  ASN H 224      27.560  55.928  85.359  1.00 51.05           C  
ATOM   2060  CG  ASN H 224      28.723  56.540  84.655  1.00 51.55           C  
ATOM   2061  OD1 ASN H 224      28.664  56.817  83.460  1.00 52.34           O  
ATOM   2062  ND2 ASN H 224      29.802  56.760  85.393  1.00 52.09           N  
ATOM   2063  N   VAL H 225      25.955  54.121  87.174  1.00 49.40           N  
ATOM   2064  CA  VAL H 225      24.717  53.737  87.844  1.00 47.23           C  
ATOM   2065  C   VAL H 225      24.915  53.897  89.350  1.00 46.42           C  
ATOM   2066  O   VAL H 225      23.984  54.265  90.069  1.00 45.50           O  
ATOM   2067  CB  VAL H 225      24.300  52.297  87.456  1.00 45.86           C  
ATOM   2068  CG1 VAL H 225      23.285  51.753  88.420  1.00 44.87           C  
ATOM   2069  CG2 VAL H 225      23.669  52.326  86.077  1.00 45.40           C  
ATOM   2070  N   ARG H 226      26.149  53.669  89.803  1.00 45.83           N  
ATOM   2071  CA  ARG H 226      26.512  53.823  91.212  1.00 45.94           C  
ATOM   2072  C   ARG H 226      26.565  55.311  91.618  1.00 44.86           C  
ATOM   2073  O   ARG H 226      25.796  55.768  92.481  1.00 42.52           O  
ATOM   2074  CB  ARG H 226      27.885  53.189  91.491  1.00 47.41           C  
ATOM   2075  CG  ARG H 226      27.891  51.682  91.728  1.00 48.84           C  
ATOM   2076  CD  ARG H 226      27.237  51.304  93.051  1.00 50.74           C  
ATOM   2077  NE  ARG H 226      27.513  49.918  93.443  1.00 53.39           N  
ATOM   2078  CZ  ARG H 226      28.727  49.442  93.730  1.00 54.61           C  
ATOM   2079  NH1 ARG H 226      29.786  50.236  93.668  1.00 56.47           N  
ATOM   2080  NH2 ARG H 226      28.890  48.176  94.097  1.00 54.39           N  
ATOM   2081  N   LEU H 227      27.463  56.063  90.985  1.00 42.97           N  
ATOM   2082  CA  LEU H 227      27.601  57.468  91.324  1.00 43.93           C  
ATOM   2083  C   LEU H 227      26.369  58.350  91.090  1.00 45.97           C  
ATOM   2084  O   LEU H 227      26.250  59.422  91.691  1.00 47.12           O  
ATOM   2085  CB  LEU H 227      28.805  58.082  90.605  1.00 41.93           C  
ATOM   2086  CG  LEU H 227      29.111  59.516  91.074  1.00 39.97           C  
ATOM   2087  CD1 LEU H 227      28.972  59.596  92.574  1.00 39.97           C  
ATOM   2088  CD2 LEU H 227      30.505  59.936  90.663  1.00 38.84           C  
ATOM   2089  N   LEU H 228      25.446  57.928  90.234  1.00 46.68           N  
ATOM   2090  CA  LEU H 228      24.276  58.761  90.014  1.00 47.03           C  
ATOM   2091  C   LEU H 228      23.268  58.566  91.148  1.00 47.87           C  
ATOM   2092  O   LEU H 228      22.786  59.542  91.737  1.00 48.14           O  
ATOM   2093  CB  LEU H 228      23.611  58.438  88.677  1.00 46.24           C  
ATOM   2094  CG  LEU H 228      22.863  59.617  88.032  1.00 45.55           C  
ATOM   2095  CD1 LEU H 228      21.924  59.079  86.978  1.00 44.79           C  
ATOM   2096  CD2 LEU H 228      22.073  60.410  89.063  1.00 45.05           C  
ATOM   2097  N   SER H 229      22.946  57.312  91.450  1.00 47.53           N  
ATOM   2098  CA  SER H 229      21.988  57.035  92.510  1.00 47.20           C  
ATOM   2099  C   SER H 229      22.567  57.449  93.854  1.00 46.79           C  
ATOM   2100  O   SER H 229      21.853  57.509  94.848  1.00 47.33           O  
ATOM   2101  CB  SER H 229      21.638  55.558  92.535  1.00 46.64           C  
ATOM   2102  OG  SER H 229      22.810  54.808  92.759  1.00 49.47           O  
ATOM   2103  N   GLU H 230      23.865  57.727  93.889  1.00 46.47           N  
ATOM   2104  CA  GLU H 230      24.504  58.165  95.129  1.00 45.72           C  
ATOM   2105  C   GLU H 230      24.146  59.636  95.359  1.00 45.10           C  
ATOM   2106  O   GLU H 230      23.796  60.056  96.463  1.00 44.76           O  
ATOM   2107  CB  GLU H 230      26.022  58.023  95.014  1.00 46.14           C  
ATOM   2108  CG  GLU H 230      26.795  58.493  96.243  1.00 47.57           C  
ATOM   2109  CD  GLU H 230      28.300  58.471  96.025  1.00 47.34           C  
ATOM   2110  OE1 GLU H 230      28.960  59.510  96.252  1.00 48.00           O  
ATOM   2111  OE2 GLU H 230      28.826  57.410  95.627  1.00 47.89           O  
ATOM   2112  N   MET H 231      24.234  60.412  94.287  1.00 44.02           N  
ATOM   2113  CA  MET H 231      23.931  61.823  94.345  1.00 43.25           C  
ATOM   2114  C   MET H 231      22.434  62.058  94.510  1.00 43.63           C  
ATOM   2115  O   MET H 231      22.011  63.069  95.073  1.00 42.31           O  
ATOM   2116  CB  MET H 231      24.458  62.502  93.084  1.00 41.85           C  
ATOM   2117  CG  MET H 231      25.953  62.385  92.954  1.00 40.10           C  
ATOM   2118  SD  MET H 231      26.642  63.676  91.898  1.00 44.69           S  
ATOM   2119  CE  MET H 231      26.893  65.025  93.055  1.00 40.76           C  
ATOM   2120  N   LEU H 232      21.631  61.126  94.006  1.00 45.32           N  
ATOM   2121  CA  LEU H 232      20.179  61.228  94.136  1.00 46.91           C  
ATOM   2122  C   LEU H 232      19.843  61.072  95.621  1.00 47.58           C  
ATOM   2123  O   LEU H 232      19.080  61.862  96.194  1.00 47.24           O  
ATOM   2124  CB  LEU H 232      19.473  60.123  93.323  1.00 47.46           C  
ATOM   2125  CG  LEU H 232      19.377  60.184  91.778  1.00 48.77           C  
ATOM   2126  CD1 LEU H 232      18.625  58.947  91.238  1.00 47.24           C  
ATOM   2127  CD2 LEU H 232      18.638  61.457  91.347  1.00 48.31           C  
ATOM   2128  N   LEU H 233      20.445  60.055  96.237  1.00 47.43           N  
ATOM   2129  CA  LEU H 233      20.221  59.765  97.638  1.00 47.84           C  
ATOM   2130  C   LEU H 233      20.438  60.971  98.519  1.00 49.46           C  
ATOM   2131  O   LEU H 233      19.633  61.249  99.400  1.00 50.29           O  
ATOM   2132  CB  LEU H 233      21.111  58.613  98.071  1.00 46.81           C  
ATOM   2133  CG  LEU H 233      20.414  57.253  97.932  1.00 48.04           C  
ATOM   2134  CD1 LEU H 233      19.336  57.113  98.994  1.00 48.63           C  
ATOM   2135  CD2 LEU H 233      19.781  57.119  96.555  1.00 49.35           C  
ATOM   2136  N   HIS H 234      21.523  61.696  98.273  1.00 51.27           N  
ATOM   2137  CA  HIS H 234      21.820  62.893  99.049  1.00 52.26           C  
ATOM   2138  C   HIS H 234      21.244  64.087  98.341  1.00 52.84           C  
ATOM   2139  O   HIS H 234      21.759  65.197  98.476  1.00 52.95           O  
ATOM   2140  CB  HIS H 234      23.324  63.100  99.183  1.00 52.35           C  
ATOM   2141  CG  HIS H 234      24.022  61.968  99.853  1.00 52.55           C  
ATOM   2142  ND1 HIS H 234      24.048  60.698  99.324  1.00 52.90           N  
ATOM   2143  CD2 HIS H 234      24.697  61.907 101.024  1.00 53.00           C  
ATOM   2144  CE1 HIS H 234      24.712  59.898 100.140  1.00 54.00           C  
ATOM   2145  NE2 HIS H 234      25.115  60.608 101.179  1.00 54.66           N  
ATOM   2146  N   TYR H 235      20.182  63.874  97.578  1.00 53.83           N  
ATOM   2147  CA  TYR H 235      19.617  64.997  96.865  1.00 55.17           C  
ATOM   2148  C   TYR H 235      18.295  65.511  97.343  1.00 56.24           C  
ATOM   2149  O   TYR H 235      17.272  64.807  97.276  1.00 55.26           O  
ATOM   2150  CB  TYR H 235      19.476  64.712  95.380  1.00 55.41           C  
ATOM   2151  CG  TYR H 235      18.757  65.849  94.683  1.00 55.15           C  
ATOM   2152  CD1 TYR H 235      17.455  65.694  94.203  1.00 53.88           C  
ATOM   2153  CD2 TYR H 235      19.371  67.094  94.535  1.00 54.69           C  
ATOM   2154  CE1 TYR H 235      16.789  66.747  93.588  1.00 52.71           C  
ATOM   2155  CE2 TYR H 235      18.711  68.151  93.922  1.00 53.88           C  
ATOM   2156  CZ  TYR H 235      17.423  67.973  93.446  1.00 52.51           C  
ATOM   2157  OH  TYR H 235      16.787  69.010  92.790  1.00 52.15           O  
ATOM   2158  N   SER H 236      18.324  66.766  97.783  1.00 57.67           N  
ATOM   2159  CA  SER H 236      17.120  67.436  98.245  1.00 59.15           C  
ATOM   2160  C   SER H 236      16.932  68.781  97.564  1.00 59.39           C  
ATOM   2161  O   SER H 236      17.900  69.449  97.186  1.00 58.01           O  
ATOM   2162  CB  SER H 236      17.137  67.608  99.764  1.00 59.54           C  
ATOM   2163  OG  SER H 236      16.212  66.709 100.363  1.00 58.70           O  
ATOM   2164  N   GLN H 237      15.665  69.148  97.397  1.00 60.38           N  
ATOM   2165  CA  GLN H 237      15.289  70.396  96.754  1.00 61.59           C  
ATOM   2166  C   GLN H 237      16.168  71.561  97.174  1.00 61.70           C  
ATOM   2167  O   GLN H 237      17.212  71.820  96.563  1.00 62.14           O  
ATOM   2168  CB  GLN H 237      13.822  70.705  97.060  1.00 62.43           C  
ATOM   2169  CG  GLN H 237      12.858  69.961  96.152  1.00 61.85           C  
ATOM   2170  CD  GLN H 237      13.030  70.362  94.701  1.00 60.81           C  
ATOM   2171  OE1 GLN H 237      12.682  71.478  94.299  1.00 59.00           O  
ATOM   2172  NE2 GLN H 237      13.586  69.457  93.908  1.00 60.37           N  
ATOM   2173  N   GLU H 238      15.724  72.264  98.210  1.00 61.64           N  
ATOM   2174  CA  GLU H 238      16.447  73.406  98.751  1.00 62.18           C  
ATOM   2175  C   GLU H 238      17.873  72.972  99.101  1.00 62.03           C  
ATOM   2176  O   GLU H 238      18.851  73.674  98.804  1.00 60.45           O  
ATOM   2177  CB  GLU H 238      15.734  73.920 100.016  1.00 62.64           C  
ATOM   2178  CG  GLU H 238      15.728  72.911 101.182  1.00 63.00           C  
ATOM   2179  CD  GLU H 238      14.791  71.716 100.958  1.00 63.22           C  
ATOM   2180  OE1 GLU H 238      13.605  71.816 101.331  1.00 61.99           O  
ATOM   2181  OE2 GLU H 238      15.235  70.680 100.405  1.00 63.85           O  
ATOM   2182  N   ASP H 239      17.974  71.797  99.719  1.00 62.13           N  
ATOM   2183  CA  ASP H 239      19.255  71.258 100.139  1.00 62.81           C  
ATOM   2184  C   ASP H 239      20.041  70.637  98.993  1.00 61.91           C  
ATOM   2185  O   ASP H 239      19.864  69.453  98.676  1.00 61.68           O  
ATOM   2186  CB  ASP H 239      19.053  70.211 101.230  1.00 64.74           C  
ATOM   2187  CG  ASP H 239      20.274  70.063 102.124  1.00 66.49           C  
ATOM   2188  OD1 ASP H 239      20.381  70.842 103.098  1.00 67.42           O  
ATOM   2189  OD2 ASP H 239      21.131  69.189 101.848  1.00 67.12           O  
ATOM   2190  N   SER H 240      20.916  71.447  98.395  1.00 60.59           N  
ATOM   2191  CA  SER H 240      21.765  71.038  97.278  1.00 58.42           C  
ATOM   2192  C   SER H 240      22.301  72.272  96.565  1.00 57.84           C  
ATOM   2193  O   SER H 240      21.705  73.347  96.647  1.00 58.22           O  
ATOM   2194  CB  SER H 240      20.974  70.197  96.286  1.00 57.91           C  
ATOM   2195  OG  SER H 240      21.770  69.884  95.171  1.00 56.65           O  
ATOM   2196  N   SER H 241      23.422  72.120  95.866  1.00 56.60           N  
ATOM   2197  CA  SER H 241      24.025  73.240  95.143  1.00 54.98           C  
ATOM   2198  C   SER H 241      23.762  73.189  93.642  1.00 54.41           C  
ATOM   2199  O   SER H 241      23.148  72.258  93.139  1.00 54.40           O  
ATOM   2200  CB  SER H 241      25.530  73.276  95.393  1.00 54.40           C  
ATOM   2201  OG  SER H 241      26.095  71.996  95.210  1.00 52.93           O  
ATOM   2202  N   ASP H 242      24.228  74.205  92.930  1.00 54.46           N  
ATOM   2203  CA  ASP H 242      24.030  74.272  91.487  1.00 54.82           C  
ATOM   2204  C   ASP H 242      24.895  73.248  90.765  1.00 55.31           C  
ATOM   2205  O   ASP H 242      24.406  72.512  89.905  1.00 56.91           O  
ATOM   2206  CB  ASP H 242      24.343  75.683  90.973  1.00 54.42           C  
ATOM   2207  CG  ASP H 242      23.221  76.673  91.259  1.00 54.74           C  
ATOM   2208  OD1 ASP H 242      23.481  77.899  91.298  1.00 53.31           O  
ATOM   2209  OD2 ASP H 242      22.068  76.226  91.431  1.00 55.72           O  
ATOM   2210  N   GLY H 243      26.176  73.194  91.129  1.00 54.50           N  
ATOM   2211  CA  GLY H 243      27.094  72.257  90.496  1.00 52.08           C  
ATOM   2212  C   GLY H 243      26.821  70.831  90.892  1.00 49.67           C  
ATOM   2213  O   GLY H 243      27.021  69.919  90.113  1.00 49.93           O  
ATOM   2214  N   ASP H 244      26.357  70.665  92.121  1.00 49.43           N  
ATOM   2215  CA  ASP H 244      26.009  69.377  92.712  1.00 49.11           C  
ATOM   2216  C   ASP H 244      25.049  68.597  91.820  1.00 49.20           C  
ATOM   2217  O   ASP H 244      25.371  67.527  91.290  1.00 48.52           O  
ATOM   2218  CB  ASP H 244      25.329  69.624  94.055  1.00 49.03           C  
ATOM   2219  CG  ASP H 244      25.934  68.834  95.168  1.00 49.42           C  
ATOM   2220  OD1 ASP H 244      25.618  67.635  95.277  1.00 49.83           O  
ATOM   2221  OD2 ASP H 244      26.732  69.415  95.932  1.00 51.08           O  
ATOM   2222  N   ARG H 245      23.854  69.156  91.683  1.00 50.03           N  
ATOM   2223  CA  ARG H 245      22.786  68.570  90.884  1.00 51.02           C  
ATOM   2224  C   ARG H 245      23.119  68.569  89.393  1.00 49.60           C  
ATOM   2225  O   ARG H 245      23.023  67.534  88.739  1.00 48.82           O  
ATOM   2226  CB  ARG H 245      21.500  69.360  91.109  1.00 52.96           C  
ATOM   2227  CG  ARG H 245      21.613  70.802  90.647  1.00 55.22           C  
ATOM   2228  CD  ARG H 245      20.546  71.124  89.623  1.00 57.50           C  
ATOM   2229  NE  ARG H 245      19.213  71.077  90.214  1.00 59.42           N  
ATOM   2230  CZ  ARG H 245      18.838  71.812  91.260  1.00 60.79           C  
ATOM   2231  NH1 ARG H 245      17.598  71.711  91.736  1.00 61.01           N  
ATOM   2232  NH2 ARG H 245      19.703  72.648  91.832  1.00 59.83           N  
ATOM   2233  N   GLU H 246      23.504  69.732  88.867  1.00 48.06           N  
ATOM   2234  CA  GLU H 246      23.839  69.862  87.456  1.00 47.39           C  
ATOM   2235  C   GLU H 246      24.760  68.706  87.032  1.00 46.10           C  
ATOM   2236  O   GLU H 246      24.569  68.106  85.976  1.00 46.02           O  
ATOM   2237  CB  GLU H 246      24.490  71.230  87.198  1.00 48.13           C  
ATOM   2238  CG  GLU H 246      26.000  71.251  87.214  1.00 51.33           C  
ATOM   2239  CD  GLU H 246      26.587  70.709  85.920  1.00 53.43           C  
ATOM   2240  OE1 GLU H 246      26.457  71.393  84.877  1.00 52.04           O  
ATOM   2241  OE2 GLU H 246      27.164  69.596  85.948  1.00 54.56           O  
ATOM   2242  N   LEU H 247      25.750  68.401  87.865  1.00 43.89           N  
ATOM   2243  CA  LEU H 247      26.669  67.304  87.600  1.00 42.55           C  
ATOM   2244  C   LEU H 247      25.845  66.059  87.337  1.00 43.13           C  
ATOM   2245  O   LEU H 247      26.037  65.382  86.328  1.00 41.90           O  
ATOM   2246  CB  LEU H 247      27.564  67.060  88.813  1.00 41.09           C  
ATOM   2247  CG  LEU H 247      28.357  65.753  88.879  1.00 41.22           C  
ATOM   2248  CD1 LEU H 247      29.368  65.661  87.738  1.00 39.55           C  
ATOM   2249  CD2 LEU H 247      29.074  65.704  90.219  1.00 40.12           C  
ATOM   2250  N   MET H 248      24.930  65.777  88.266  1.00 44.19           N  
ATOM   2251  CA  MET H 248      24.033  64.626  88.187  1.00 44.72           C  
ATOM   2252  C   MET H 248      23.377  64.590  86.825  1.00 45.00           C  
ATOM   2253  O   MET H 248      23.367  63.572  86.143  1.00 46.43           O  
ATOM   2254  CB  MET H 248      22.902  64.725  89.212  1.00 45.55           C  
ATOM   2255  CG  MET H 248      23.292  65.011  90.641  1.00 47.76           C  
ATOM   2256  SD  MET H 248      21.806  65.044  91.679  1.00 49.27           S  
ATOM   2257  CE  MET H 248      21.412  63.297  91.733  1.00 47.11           C  
ATOM   2258  N   LYS H 249      22.802  65.722  86.450  1.00 45.39           N  
ATOM   2259  CA  LYS H 249      22.100  65.846  85.193  1.00 45.13           C  
ATOM   2260  C   LYS H 249      23.072  65.601  84.051  1.00 46.01           C  
ATOM   2261  O   LYS H 249      22.683  65.232  82.946  1.00 47.20           O  
ATOM   2262  CB  LYS H 249      21.460  67.232  85.127  1.00 44.40           C  
ATOM   2263  CG  LYS H 249      20.558  67.515  86.349  1.00 45.70           C  
ATOM   2264  CD  LYS H 249      19.832  68.876  86.267  1.00 47.92           C  
ATOM   2265  CE  LYS H 249      18.734  69.027  87.344  1.00 47.65           C  
ATOM   2266  NZ  LYS H 249      17.862  70.238  87.155  1.00 44.10           N  
ATOM   2267  N   GLU H 250      24.355  65.768  84.334  1.00 46.61           N  
ATOM   2268  CA  GLU H 250      25.381  65.553  83.327  1.00 45.67           C  
ATOM   2269  C   GLU H 250      25.783  64.090  83.315  1.00 44.22           C  
ATOM   2270  O   GLU H 250      26.102  63.526  82.271  1.00 44.83           O  
ATOM   2271  CB  GLU H 250      26.591  66.425  83.627  1.00 47.79           C  
ATOM   2272  CG  GLU H 250      27.768  66.167  82.723  1.00 50.67           C  
ATOM   2273  CD  GLU H 250      28.635  67.393  82.565  1.00 52.86           C  
ATOM   2274  OE1 GLU H 250      29.793  67.250  82.114  1.00 55.50           O  
ATOM   2275  OE2 GLU H 250      28.153  68.506  82.883  1.00 54.45           O  
ATOM   2276  N   LEU H 251      25.787  63.481  84.489  1.00 42.38           N  
ATOM   2277  CA  LEU H 251      26.118  62.074  84.594  1.00 40.49           C  
ATOM   2278  C   LEU H 251      24.941  61.411  83.910  1.00 40.72           C  
ATOM   2279  O   LEU H 251      25.072  60.376  83.245  1.00 42.82           O  
ATOM   2280  CB  LEU H 251      26.148  61.655  86.053  1.00 38.41           C  
ATOM   2281  CG  LEU H 251      27.256  60.711  86.496  1.00 37.05           C  
ATOM   2282  CD1 LEU H 251      28.613  61.335  86.221  1.00 36.22           C  
ATOM   2283  CD2 LEU H 251      27.084  60.421  87.982  1.00 36.97           C  
ATOM   2284  N   PHE H 252      23.786  62.042  84.073  1.00 39.19           N  
ATOM   2285  CA  PHE H 252      22.554  61.553  83.490  1.00 38.61           C  
ATOM   2286  C   PHE H 252      22.663  61.440  81.977  1.00 39.38           C  
ATOM   2287  O   PHE H 252      22.418  60.374  81.426  1.00 39.83           O  
ATOM   2288  CB  PHE H 252      21.396  62.470  83.857  1.00 35.42           C  
ATOM   2289  CG  PHE H 252      20.093  62.023  83.294  1.00 33.81           C  
ATOM   2290  CD1 PHE H 252      19.603  60.749  83.576  1.00 32.40           C  
ATOM   2291  CD2 PHE H 252      19.355  62.857  82.456  1.00 32.93           C  
ATOM   2292  CE1 PHE H 252      18.399  60.315  83.028  1.00 32.16           C  
ATOM   2293  CE2 PHE H 252      18.147  62.426  81.904  1.00 31.41           C  
ATOM   2294  CZ  PHE H 252      17.671  61.160  82.188  1.00 30.38           C  
ATOM   2295  N   ASP H 253      23.022  62.533  81.307  1.00 40.42           N  
ATOM   2296  CA  ASP H 253      23.179  62.515  79.851  1.00 41.75           C  
ATOM   2297  C   ASP H 253      24.065  61.335  79.406  1.00 42.34           C  
ATOM   2298  O   ASP H 253      23.648  60.514  78.577  1.00 43.57           O  
ATOM   2299  CB  ASP H 253      23.809  63.835  79.351  1.00 43.59           C  
ATOM   2300  CG  ASP H 253      22.787  64.786  78.699  1.00 46.49           C  
ATOM   2301  OD1 ASP H 253      22.166  64.422  77.662  1.00 48.29           O  
ATOM   2302  OD2 ASP H 253      22.612  65.910  79.221  1.00 45.19           O  
ATOM   2303  N   GLN H 254      25.273  61.243  79.968  1.00 40.60           N  
ATOM   2304  CA  GLN H 254      26.222  60.185  79.602  1.00 39.24           C  
ATOM   2305  C   GLN H 254      25.731  58.774  79.925  1.00 38.81           C  
ATOM   2306  O   GLN H 254      26.298  57.766  79.463  1.00 37.08           O  
ATOM   2307  CB  GLN H 254      27.562  60.412  80.303  1.00 38.17           C  
ATOM   2308  CG  GLN H 254      27.552  60.158  81.798  1.00 33.44           C  
ATOM   2309  CD  GLN H 254      28.956  60.055  82.329  1.00 32.74           C  
ATOM   2310  OE1 GLN H 254      29.690  61.033  82.375  1.00 32.61           O  
ATOM   2311  NE2 GLN H 254      29.348  58.860  82.713  1.00 32.27           N  
ATOM   2312  N   CYS H 255      24.684  58.722  80.736  1.00 37.77           N  
ATOM   2313  CA  CYS H 255      24.091  57.471  81.159  1.00 36.93           C  
ATOM   2314  C   CYS H 255      23.187  56.933  80.053  1.00 36.65           C  
ATOM   2315  O   CYS H 255      23.186  55.743  79.766  1.00 36.62           O  
ATOM   2316  CB  CYS H 255      23.277  57.716  82.435  1.00 37.19           C  
ATOM   2317  SG  CYS H 255      23.916  56.994  83.950  1.00 34.62           S  
ATOM   2318  N   GLU H 256      22.413  57.820  79.437  1.00 36.36           N  
ATOM   2319  CA  GLU H 256      21.505  57.430  78.372  1.00 37.51           C  
ATOM   2320  C   GLU H 256      22.287  56.909  77.181  1.00 38.86           C  
ATOM   2321  O   GLU H 256      21.828  56.043  76.420  1.00 39.03           O  
ATOM   2322  CB  GLU H 256      20.679  58.625  77.944  1.00 36.72           C  
ATOM   2323  CG  GLU H 256      19.881  59.196  79.070  1.00 38.71           C  
ATOM   2324  CD  GLU H 256      18.854  60.182  78.587  1.00 40.94           C  
ATOM   2325  OE1 GLU H 256      19.241  61.324  78.254  1.00 42.41           O  
ATOM   2326  OE2 GLU H 256      17.661  59.801  78.525  1.00 41.61           O  
ATOM   2327  N   ASN H 257      23.483  57.455  77.031  1.00 39.89           N  
ATOM   2328  CA  ASN H 257      24.364  57.077  75.951  1.00 39.74           C  
ATOM   2329  C   ASN H 257      24.879  55.680  76.088  1.00 38.94           C  
ATOM   2330  O   ASN H 257      24.668  54.858  75.195  1.00 39.22           O  
ATOM   2331  CB  ASN H 257      25.532  58.039  75.875  1.00 40.23           C  
ATOM   2332  CG  ASN H 257      25.115  59.374  75.352  1.00 42.22           C  
ATOM   2333  OD1 ASN H 257      25.934  60.275  75.184  1.00 45.36           O  
ATOM   2334  ND2 ASN H 257      23.819  59.517  75.083  1.00 41.99           N  
ATOM   2335  N   LYS H 258      25.571  55.413  77.192  1.00 38.50           N  
ATOM   2336  CA  LYS H 258      26.130  54.085  77.414  1.00 38.11           C  
ATOM   2337  C   LYS H 258      24.992  53.073  77.353  1.00 37.70           C  
ATOM   2338  O   LYS H 258      25.130  52.003  76.736  1.00 37.46           O  
ATOM   2339  CB  LYS H 258      26.861  54.036  78.751  1.00 38.87           C  
ATOM   2340  CG  LYS H 258      28.043  55.004  78.824  1.00 39.78           C  
ATOM   2341  CD  LYS H 258      28.415  55.329  80.276  1.00 41.22           C  
ATOM   2342  CE  LYS H 258      29.017  54.113  81.021  1.00 42.58           C  
ATOM   2343  NZ  LYS H 258      28.134  52.909  81.111  1.00 40.02           N  
ATOM   2344  N   ARG H 259      23.854  53.410  77.959  1.00 35.94           N  
ATOM   2345  CA  ARG H 259      22.716  52.504  77.882  1.00 35.78           C  
ATOM   2346  C   ARG H 259      22.497  52.221  76.391  1.00 35.23           C  
ATOM   2347  O   ARG H 259      22.182  51.094  76.016  1.00 35.76           O  
ATOM   2348  CB  ARG H 259      21.444  53.133  78.464  1.00 35.85           C  
ATOM   2349  CG  ARG H 259      20.497  52.097  79.074  1.00 35.27           C  
ATOM   2350  CD  ARG H 259      19.134  52.032  78.421  1.00 33.24           C  
ATOM   2351  NE  ARG H 259      18.377  53.264  78.602  1.00 35.78           N  
ATOM   2352  CZ  ARG H 259      18.470  54.323  77.803  1.00 36.70           C  
ATOM   2353  NH1 ARG H 259      19.298  54.288  76.758  1.00 34.58           N  
ATOM   2354  NH2 ARG H 259      17.741  55.416  78.054  1.00 35.76           N  
ATOM   2355  N   ARG H 260      22.665  53.249  75.553  1.00 34.51           N  
ATOM   2356  CA  ARG H 260      22.499  53.104  74.102  1.00 33.37           C  
ATOM   2357  C   ARG H 260      23.593  52.232  73.505  1.00 32.73           C  
ATOM   2358  O   ARG H 260      23.319  51.437  72.608  1.00 32.88           O  
ATOM   2359  CB  ARG H 260      22.509  54.468  73.393  1.00 33.20           C  
ATOM   2360  CG  ARG H 260      21.180  55.176  73.362  1.00 32.31           C  
ATOM   2361  CD  ARG H 260      21.073  56.074  72.150  1.00 34.66           C  
ATOM   2362  NE  ARG H 260      21.899  57.288  72.203  1.00 39.91           N  
ATOM   2363  CZ  ARG H 260      21.748  58.288  73.079  1.00 42.65           C  
ATOM   2364  NH1 ARG H 260      20.801  58.246  74.017  1.00 45.59           N  
ATOM   2365  NH2 ARG H 260      22.527  59.361  72.996  1.00 43.17           N  
ATOM   2366  N   THR H 261      24.825  52.383  73.994  1.00 32.05           N  
ATOM   2367  CA  THR H 261      25.949  51.584  73.492  1.00 30.62           C  
ATOM   2368  C   THR H 261      25.648  50.129  73.838  1.00 29.71           C  
ATOM   2369  O   THR H 261      25.774  49.242  72.997  1.00 30.32           O  
ATOM   2370  CB  THR H 261      27.304  51.965  74.157  1.00 30.55           C  
ATOM   2371  OG1 THR H 261      27.494  53.384  74.137  1.00 27.99           O  
ATOM   2372  CG2 THR H 261      28.449  51.298  73.411  1.00 30.52           C  
ATOM   2373  N   LEU H 262      25.252  49.883  75.086  1.00 28.57           N  
ATOM   2374  CA  LEU H 262      24.909  48.525  75.505  1.00 27.02           C  
ATOM   2375  C   LEU H 262      23.871  47.911  74.536  1.00 25.60           C  
ATOM   2376  O   LEU H 262      23.732  46.700  74.453  1.00 25.30           O  
ATOM   2377  CB  LEU H 262      24.342  48.531  76.937  1.00 24.73           C  
ATOM   2378  CG  LEU H 262      25.247  48.684  78.171  1.00 22.26           C  
ATOM   2379  CD1 LEU H 262      24.422  48.742  79.453  1.00 21.10           C  
ATOM   2380  CD2 LEU H 262      26.169  47.527  78.259  1.00 23.52           C  
ATOM   2381  N   PHE H 263      23.144  48.748  73.809  1.00 23.98           N  
ATOM   2382  CA  PHE H 263      22.156  48.239  72.878  1.00 26.80           C  
ATOM   2383  C   PHE H 263      22.813  47.843  71.568  1.00 27.04           C  
ATOM   2384  O   PHE H 263      22.381  46.885  70.904  1.00 26.71           O  
ATOM   2385  CB  PHE H 263      21.073  49.285  72.619  1.00 28.21           C  
ATOM   2386  CG  PHE H 263      20.155  49.507  73.788  1.00 29.21           C  
ATOM   2387  CD1 PHE H 263      19.684  50.785  74.088  1.00 28.40           C  
ATOM   2388  CD2 PHE H 263      19.725  48.432  74.564  1.00 29.62           C  
ATOM   2389  CE1 PHE H 263      18.808  50.986  75.129  1.00 28.59           C  
ATOM   2390  CE2 PHE H 263      18.842  48.629  75.620  1.00 28.73           C  
ATOM   2391  CZ  PHE H 263      18.384  49.900  75.899  1.00 28.78           C  
ATOM   2392  N   LYS H 264      23.858  48.591  71.215  1.00 27.07           N  
ATOM   2393  CA  LYS H 264      24.634  48.360  70.002  1.00 27.12           C  
ATOM   2394  C   LYS H 264      25.427  47.050  70.148  1.00 26.12           C  
ATOM   2395  O   LYS H 264      25.488  46.228  69.222  1.00 26.11           O  
ATOM   2396  CB  LYS H 264      25.590  49.540  69.753  1.00 28.16           C  
ATOM   2397  CG  LYS H 264      26.370  49.485  68.423  1.00 29.28           C  
ATOM   2398  CD  LYS H 264      27.409  50.614  68.317  1.00 30.29           C  
ATOM   2399  CE  LYS H 264      26.734  52.008  68.298  1.00 32.67           C  
ATOM   2400  NZ  LYS H 264      27.646  53.192  68.134  1.00 30.30           N  
ATOM   2401  N   LEU H 265      26.029  46.839  71.305  1.00 24.57           N  
ATOM   2402  CA  LEU H 265      26.782  45.608  71.494  1.00 25.65           C  
ATOM   2403  C   LEU H 265      25.813  44.439  71.573  1.00 25.36           C  
ATOM   2404  O   LEU H 265      26.178  43.293  71.338  1.00 23.99           O  
ATOM   2405  CB  LEU H 265      27.620  45.689  72.768  1.00 26.60           C  
ATOM   2406  CG  LEU H 265      28.417  46.989  72.930  1.00 28.11           C  
ATOM   2407  CD1 LEU H 265      29.435  46.763  74.025  1.00 27.42           C  
ATOM   2408  CD2 LEU H 265      29.105  47.419  71.622  1.00 25.90           C  
ATOM   2409  N   ALA H 266      24.569  44.746  71.924  1.00 26.99           N  
ATOM   2410  CA  ALA H 266      23.519  43.742  72.022  1.00 25.86           C  
ATOM   2411  C   ALA H 266      23.241  43.389  70.594  1.00 26.27           C  
ATOM   2412  O   ALA H 266      23.368  42.238  70.196  1.00 26.50           O  
ATOM   2413  CB  ALA H 266      22.268  44.334  72.647  1.00 24.76           C  
ATOM   2414  N   SER H 267      22.888  44.417  69.825  1.00 26.33           N  
ATOM   2415  CA  SER H 267      22.561  44.271  68.423  1.00 26.35           C  
ATOM   2416  C   SER H 267      23.619  43.546  67.611  1.00 28.33           C  
ATOM   2417  O   SER H 267      23.397  43.254  66.439  1.00 29.30           O  
ATOM   2418  CB  SER H 267      22.292  45.639  67.808  1.00 26.46           C  
ATOM   2419  OG  SER H 267      23.471  46.409  67.705  1.00 28.59           O  
ATOM   2420  N   GLU H 268      24.763  43.243  68.215  1.00 30.38           N  
ATOM   2421  CA  GLU H 268      25.835  42.541  67.505  1.00 32.05           C  
ATOM   2422  C   GLU H 268      26.172  41.222  68.225  1.00 33.96           C  
ATOM   2423  O   GLU H 268      27.331  40.860  68.389  1.00 35.11           O  
ATOM   2424  CB  GLU H 268      27.082  43.445  67.404  1.00 30.53           C  
ATOM   2425  CG  GLU H 268      26.791  44.880  66.884  1.00 31.29           C  
ATOM   2426  CD  GLU H 268      28.034  45.809  66.841  1.00 32.35           C  
ATOM   2427  OE1 GLU H 268      28.716  45.990  67.882  1.00 29.47           O  
ATOM   2428  OE2 GLU H 268      28.322  46.375  65.756  1.00 32.09           O  
ATOM   2429  N   THR H 269      25.145  40.495  68.648  1.00 35.72           N  
ATOM   2430  CA  THR H 269      25.355  39.236  69.346  1.00 37.75           C  
ATOM   2431  C   THR H 269      24.376  38.177  68.838  1.00 40.49           C  
ATOM   2432  O   THR H 269      23.158  38.401  68.817  1.00 39.94           O  
ATOM   2433  CB  THR H 269      25.128  39.415  70.858  1.00 37.42           C  
ATOM   2434  OG1 THR H 269      25.344  40.785  71.211  1.00 37.01           O  
ATOM   2435  CG2 THR H 269      26.080  38.539  71.650  1.00 37.47           C  
ATOM   2436  N   GLU H 270      24.903  37.021  68.448  1.00 44.00           N  
ATOM   2437  CA  GLU H 270      24.072  35.934  67.946  1.00 48.56           C  
ATOM   2438  C   GLU H 270      24.021  34.772  68.931  1.00 51.66           C  
ATOM   2439  O   GLU H 270      25.061  34.184  69.248  1.00 51.62           O  
ATOM   2440  CB  GLU H 270      24.589  35.442  66.594  1.00 48.04           C  
ATOM   2441  CG  GLU H 270      26.021  34.950  66.611  1.00 48.85           C  
ATOM   2442  CD  GLU H 270      27.038  36.073  66.749  1.00 47.53           C  
ATOM   2443  OE1 GLU H 270      27.012  36.792  67.774  1.00 47.15           O  
ATOM   2444  OE2 GLU H 270      27.869  36.229  65.828  1.00 46.67           O  
ATOM   2445  N   ASP H 271      22.799  34.453  69.393  1.00 55.36           N  
ATOM   2446  CA  ASP H 271      22.519  33.377  70.366  1.00 57.86           C  
ATOM   2447  C   ASP H 271      23.688  33.087  71.295  1.00 59.02           C  
ATOM   2448  O   ASP H 271      24.099  31.928  71.456  1.00 60.20           O  
ATOM   2449  CB  ASP H 271      22.110  32.085  69.651  1.00 59.33           C  
ATOM   2450  CG  ASP H 271      22.723  31.955  68.262  1.00 61.03           C  
ATOM   2451  OD1 ASP H 271      22.432  32.826  67.399  1.00 61.93           O  
ATOM   2452  OD2 ASP H 271      23.479  30.977  68.039  1.00 61.22           O  
ATOM   2453  N   ASN H 272      24.206  34.150  71.912  1.00 58.94           N  
ATOM   2454  CA  ASN H 272      25.361  34.059  72.802  1.00 57.67           C  
ATOM   2455  C   ASN H 272      24.980  34.157  74.271  1.00 56.53           C  
ATOM   2456  O   ASN H 272      24.311  35.104  74.680  1.00 55.04           O  
ATOM   2457  CB  ASN H 272      26.348  35.174  72.466  1.00 57.27           C  
ATOM   2458  CG  ASN H 272      27.642  35.045  73.218  1.00 56.38           C  
ATOM   2459  OD1 ASN H 272      28.433  35.988  73.263  1.00 56.53           O  
ATOM   2460  ND2 ASN H 272      27.875  33.875  73.810  1.00 55.24           N  
ATOM   2461  N   ASP H 273      25.418  33.175  75.055  1.00 56.02           N  
ATOM   2462  CA  ASP H 273      25.141  33.135  76.489  1.00 55.36           C  
ATOM   2463  C   ASP H 273      25.672  34.388  77.150  1.00 54.06           C  
ATOM   2464  O   ASP H 273      26.085  35.322  76.473  1.00 53.99           O  
ATOM   2465  CB  ASP H 273      25.788  31.898  77.136  1.00 56.53           C  
ATOM   2466  CG  ASP H 273      24.828  30.713  77.238  1.00 58.00           C  
ATOM   2467  OD1 ASP H 273      25.308  29.555  77.241  1.00 57.48           O  
ATOM   2468  OD2 ASP H 273      23.595  30.942  77.332  1.00 58.93           O  
ATOM   2469  N   ASN H 274      25.658  34.392  78.477  1.00 53.18           N  
ATOM   2470  CA  ASN H 274      26.129  35.526  79.266  1.00 51.77           C  
ATOM   2471  C   ASN H 274      26.092  36.836  78.477  1.00 48.45           C  
ATOM   2472  O   ASN H 274      25.139  37.599  78.579  1.00 47.65           O  
ATOM   2473  CB  ASN H 274      27.560  35.270  79.761  1.00 54.91           C  
ATOM   2474  CG  ASN H 274      27.828  33.802  80.031  1.00 57.15           C  
ATOM   2475  OD1 ASN H 274      28.485  33.118  79.231  1.00 57.08           O  
ATOM   2476  ND2 ASN H 274      27.307  33.302  81.155  1.00 58.43           N  
ATOM   2477  N   SER H 275      27.140  37.071  77.690  1.00 44.70           N  
ATOM   2478  CA  SER H 275      27.281  38.274  76.878  1.00 40.75           C  
ATOM   2479  C   SER H 275      25.989  39.096  76.822  1.00 37.22           C  
ATOM   2480  O   SER H 275      25.934  40.230  77.309  1.00 36.57           O  
ATOM   2481  CB  SER H 275      27.757  37.898  75.459  1.00 41.49           C  
ATOM   2482  OG  SER H 275      28.176  39.045  74.719  1.00 41.27           O  
ATOM   2483  N   LEU H 276      24.940  38.525  76.248  1.00 32.98           N  
ATOM   2484  CA  LEU H 276      23.699  39.267  76.185  1.00 30.60           C  
ATOM   2485  C   LEU H 276      23.146  39.463  77.611  1.00 29.79           C  
ATOM   2486  O   LEU H 276      22.889  40.594  78.028  1.00 29.12           O  
ATOM   2487  CB  LEU H 276      22.687  38.556  75.276  1.00 25.25           C  
ATOM   2488  CG  LEU H 276      21.670  39.507  74.638  1.00 22.78           C  
ATOM   2489  CD1 LEU H 276      22.361  40.779  74.193  1.00 20.34           C  
ATOM   2490  CD2 LEU H 276      21.005  38.830  73.453  1.00 23.63           C  
ATOM   2491  N   GLY H 277      22.996  38.368  78.354  1.00 29.10           N  
ATOM   2492  CA  GLY H 277      22.491  38.448  79.716  1.00 27.44           C  
ATOM   2493  C   GLY H 277      23.159  39.574  80.464  1.00 26.40           C  
ATOM   2494  O   GLY H 277      22.495  40.426  81.049  1.00 25.84           O  
ATOM   2495  N   ASP H 278      24.485  39.577  80.425  1.00 27.02           N  
ATOM   2496  CA  ASP H 278      25.291  40.605  81.081  1.00 25.88           C  
ATOM   2497  C   ASP H 278      25.058  41.975  80.448  1.00 25.48           C  
ATOM   2498  O   ASP H 278      24.986  42.981  81.146  1.00 23.81           O  
ATOM   2499  CB  ASP H 278      26.772  40.215  81.010  1.00 24.96           C  
ATOM   2500  CG  ASP H 278      27.023  38.826  81.579  1.00 24.38           C  
ATOM   2501  OD1 ASP H 278      26.459  38.558  82.653  1.00 26.44           O  
ATOM   2502  OD2 ASP H 278      27.766  38.015  80.977  1.00 20.37           O  
ATOM   2503  N   ILE H 279      24.915  42.022  79.128  1.00 26.28           N  
ATOM   2504  CA  ILE H 279      24.686  43.310  78.484  1.00 27.10           C  
ATOM   2505  C   ILE H 279      23.327  43.882  78.838  1.00 26.58           C  
ATOM   2506  O   ILE H 279      23.204  45.059  79.190  1.00 27.21           O  
ATOM   2507  CB  ILE H 279      24.759  43.217  76.974  1.00 28.19           C  
ATOM   2508  CG1 ILE H 279      26.228  43.190  76.525  1.00 30.39           C  
ATOM   2509  CG2 ILE H 279      24.002  44.387  76.360  1.00 27.96           C  
ATOM   2510  CD1 ILE H 279      26.409  43.115  75.000  1.00 31.04           C  
ATOM   2511  N   LEU H 280      22.301  43.051  78.732  1.00 25.62           N  
ATOM   2512  CA  LEU H 280      20.957  43.494  79.048  1.00 23.37           C  
ATOM   2513  C   LEU H 280      20.786  43.803  80.528  1.00 23.27           C  
ATOM   2514  O   LEU H 280      20.038  44.698  80.887  1.00 22.14           O  
ATOM   2515  CB  LEU H 280      19.954  42.442  78.575  1.00 22.92           C  
ATOM   2516  CG  LEU H 280      19.921  42.364  77.041  1.00 21.34           C  
ATOM   2517  CD1 LEU H 280      19.221  41.115  76.573  1.00 21.27           C  
ATOM   2518  CD2 LEU H 280      19.231  43.588  76.498  1.00 19.42           C  
ATOM   2519  N   GLN H 281      21.497  43.089  81.389  1.00 25.14           N  
ATOM   2520  CA  GLN H 281      21.365  43.343  82.814  1.00 27.91           C  
ATOM   2521  C   GLN H 281      21.820  44.756  83.134  1.00 28.12           C  
ATOM   2522  O   GLN H 281      21.068  45.538  83.706  1.00 29.61           O  
ATOM   2523  CB  GLN H 281      22.179  42.344  83.640  1.00 30.80           C  
ATOM   2524  CG  GLN H 281      21.652  42.149  85.059  1.00 34.62           C  
ATOM   2525  CD  GLN H 281      22.530  41.232  85.895  1.00 39.23           C  
ATOM   2526  OE1 GLN H 281      23.614  41.630  86.339  1.00 41.97           O  
ATOM   2527  NE2 GLN H 281      22.073  39.991  86.108  1.00 41.03           N  
ATOM   2528  N   ALA H 282      23.051  45.091  82.767  1.00 28.02           N  
ATOM   2529  CA  ALA H 282      23.551  46.432  83.028  1.00 26.37           C  
ATOM   2530  C   ALA H 282      22.579  47.435  82.433  1.00 27.19           C  
ATOM   2531  O   ALA H 282      22.091  48.316  83.137  1.00 29.01           O  
ATOM   2532  CB  ALA H 282      24.925  46.615  82.423  1.00 27.75           C  
ATOM   2533  N   SER H 283      22.278  47.311  81.145  1.00 27.08           N  
ATOM   2534  CA  SER H 283      21.336  48.249  80.531  1.00 27.74           C  
ATOM   2535  C   SER H 283      20.121  48.455  81.444  1.00 27.82           C  
ATOM   2536  O   SER H 283      19.623  49.579  81.619  1.00 27.22           O  
ATOM   2537  CB  SER H 283      20.860  47.714  79.182  1.00 27.21           C  
ATOM   2538  OG  SER H 283      20.249  46.459  79.358  1.00 28.07           O  
ATOM   2539  N   ASP H 284      19.661  47.362  82.041  1.00 27.87           N  
ATOM   2540  CA  ASP H 284      18.507  47.405  82.917  1.00 28.11           C  
ATOM   2541  C   ASP H 284      18.679  48.325  84.147  1.00 27.92           C  
ATOM   2542  O   ASP H 284      17.723  48.985  84.587  1.00 27.11           O  
ATOM   2543  CB  ASP H 284      18.147  45.983  83.342  1.00 28.68           C  
ATOM   2544  CG  ASP H 284      16.928  45.943  84.213  1.00 27.56           C  
ATOM   2545  OD1 ASP H 284      17.062  45.546  85.384  1.00 28.70           O  
ATOM   2546  OD2 ASP H 284      15.847  46.322  83.728  1.00 24.76           O  
ATOM   2547  N   ASN H 285      19.878  48.382  84.710  1.00 25.92           N  
ATOM   2548  CA  ASN H 285      20.065  49.258  85.845  1.00 25.48           C  
ATOM   2549  C   ASN H 285      20.136  50.652  85.255  1.00 27.31           C  
ATOM   2550  O   ASN H 285      19.596  51.615  85.806  1.00 29.27           O  
ATOM   2551  CB  ASN H 285      21.371  48.985  86.575  1.00 24.48           C  
ATOM   2552  CG  ASN H 285      21.694  47.528  86.676  1.00 23.38           C  
ATOM   2553  OD1 ASN H 285      20.849  46.702  87.029  1.00 24.10           O  
ATOM   2554  ND2 ASN H 285      22.936  47.197  86.378  1.00 20.28           N  
ATOM   2555  N   LEU H 286      20.841  50.773  84.141  1.00 27.73           N  
ATOM   2556  CA  LEU H 286      20.941  52.075  83.503  1.00 27.87           C  
ATOM   2557  C   LEU H 286      19.538  52.646  83.326  1.00 27.61           C  
ATOM   2558  O   LEU H 286      19.255  53.782  83.728  1.00 26.69           O  
ATOM   2559  CB  LEU H 286      21.627  51.949  82.154  1.00 27.55           C  
ATOM   2560  CG  LEU H 286      23.121  52.211  82.190  1.00 26.82           C  
ATOM   2561  CD1 LEU H 286      23.773  51.633  80.934  1.00 28.32           C  
ATOM   2562  CD2 LEU H 286      23.336  53.715  82.295  1.00 24.59           C  
ATOM   2563  N   SER H 287      18.647  51.864  82.730  1.00 27.00           N  
ATOM   2564  CA  SER H 287      17.298  52.363  82.566  1.00 26.31           C  
ATOM   2565  C   SER H 287      16.693  52.680  83.928  1.00 25.08           C  
ATOM   2566  O   SER H 287      16.268  53.801  84.154  1.00 26.04           O  
ATOM   2567  CB  SER H 287      16.438  51.356  81.810  1.00 26.83           C  
ATOM   2568  OG  SER H 287      16.560  51.569  80.408  1.00 29.75           O  
ATOM   2569  N   ARG H 288      16.685  51.717  84.847  1.00 24.60           N  
ATOM   2570  CA  ARG H 288      16.106  51.954  86.170  1.00 25.00           C  
ATOM   2571  C   ARG H 288      16.536  53.309  86.753  1.00 23.87           C  
ATOM   2572  O   ARG H 288      15.700  54.112  87.186  1.00 22.87           O  
ATOM   2573  CB  ARG H 288      16.481  50.811  87.125  1.00 26.25           C  
ATOM   2574  CG  ARG H 288      15.285  50.170  87.851  1.00 28.59           C  
ATOM   2575  CD  ARG H 288      14.443  49.271  86.936  1.00 33.58           C  
ATOM   2576  NE  ARG H 288      14.712  47.836  87.123  1.00 36.93           N  
ATOM   2577  CZ  ARG H 288      13.971  46.853  86.593  1.00 38.86           C  
ATOM   2578  NH1 ARG H 288      12.908  47.147  85.839  1.00 38.94           N  
ATOM   2579  NH2 ARG H 288      14.277  45.572  86.827  1.00 38.26           N  
ATOM   2580  N   VAL H 289      17.839  53.567  86.738  1.00 24.21           N  
ATOM   2581  CA  VAL H 289      18.401  54.823  87.247  1.00 24.75           C  
ATOM   2582  C   VAL H 289      17.973  56.051  86.407  1.00 25.29           C  
ATOM   2583  O   VAL H 289      17.822  57.160  86.930  1.00 22.91           O  
ATOM   2584  CB  VAL H 289      19.939  54.747  87.265  1.00 23.48           C  
ATOM   2585  CG1 VAL H 289      20.524  55.982  87.929  1.00 21.13           C  
ATOM   2586  CG2 VAL H 289      20.375  53.456  87.941  1.00 22.73           C  
ATOM   2587  N   ILE H 290      17.792  55.845  85.106  1.00 26.49           N  
ATOM   2588  CA  ILE H 290      17.389  56.925  84.226  1.00 28.61           C  
ATOM   2589  C   ILE H 290      16.006  57.420  84.604  1.00 30.51           C  
ATOM   2590  O   ILE H 290      15.784  58.627  84.731  1.00 29.59           O  
ATOM   2591  CB  ILE H 290      17.430  56.467  82.764  1.00 29.17           C  
ATOM   2592  CG1 ILE H 290      18.898  56.441  82.313  1.00 31.98           C  
ATOM   2593  CG2 ILE H 290      16.587  57.366  81.894  1.00 26.17           C  
ATOM   2594  CD1 ILE H 290      19.120  56.280  80.804  1.00 34.29           C  
ATOM   2595  N   ASN H 291      15.076  56.485  84.791  1.00 33.00           N  
ATOM   2596  CA  ASN H 291      13.710  56.824  85.193  1.00 33.98           C  
ATOM   2597  C   ASN H 291      13.760  57.294  86.643  1.00 35.72           C  
ATOM   2598  O   ASN H 291      13.089  58.260  87.016  1.00 35.78           O  
ATOM   2599  CB  ASN H 291      12.816  55.608  85.078  1.00 32.96           C  
ATOM   2600  CG  ASN H 291      12.908  54.959  83.719  1.00 33.80           C  
ATOM   2601  OD1 ASN H 291      12.673  55.608  82.693  1.00 35.34           O  
ATOM   2602  ND2 ASN H 291      13.248  53.676  83.696  1.00 30.79           N  
ATOM   2603  N   SER H 292      14.559  56.605  87.460  1.00 36.47           N  
ATOM   2604  CA  SER H 292      14.701  57.003  88.851  1.00 37.25           C  
ATOM   2605  C   SER H 292      15.011  58.492  88.860  1.00 37.02           C  
ATOM   2606  O   SER H 292      14.290  59.277  89.458  1.00 36.23           O  
ATOM   2607  CB  SER H 292      15.845  56.242  89.531  1.00 36.96           C  
ATOM   2608  OG  SER H 292      16.300  56.942  90.687  1.00 36.02           O  
ATOM   2609  N   TYR H 293      16.083  58.869  88.174  1.00 38.56           N  
ATOM   2610  CA  TYR H 293      16.490  60.261  88.104  1.00 40.06           C  
ATOM   2611  C   TYR H 293      15.305  61.124  87.695  1.00 40.96           C  
ATOM   2612  O   TYR H 293      14.943  62.049  88.419  1.00 40.78           O  
ATOM   2613  CB  TYR H 293      17.657  60.415  87.125  1.00 38.66           C  
ATOM   2614  CG  TYR H 293      17.893  61.829  86.650  1.00 39.25           C  
ATOM   2615  CD1 TYR H 293      17.231  62.322  85.525  1.00 38.55           C  
ATOM   2616  CD2 TYR H 293      18.796  62.677  87.309  1.00 39.98           C  
ATOM   2617  CE1 TYR H 293      17.464  63.627  85.064  1.00 38.57           C  
ATOM   2618  CE2 TYR H 293      19.036  63.982  86.850  1.00 38.32           C  
ATOM   2619  CZ  TYR H 293      18.367  64.441  85.728  1.00 37.35           C  
ATOM   2620  OH  TYR H 293      18.610  65.697  85.245  1.00 37.00           O  
ATOM   2621  N   LYS H 294      14.712  60.812  86.543  1.00 42.65           N  
ATOM   2622  CA  LYS H 294      13.536  61.525  86.029  1.00 44.38           C  
ATOM   2623  C   LYS H 294      12.641  62.008  87.177  1.00 44.96           C  
ATOM   2624  O   LYS H 294      12.381  63.203  87.325  1.00 44.22           O  
ATOM   2625  CB  LYS H 294      12.687  60.602  85.131  1.00 46.13           C  
ATOM   2626  CG  LYS H 294      13.183  60.376  83.693  1.00 48.63           C  
ATOM   2627  CD  LYS H 294      12.310  59.313  82.963  1.00 49.80           C  
ATOM   2628  CE  LYS H 294      12.502  59.307  81.429  1.00 49.45           C  
ATOM   2629  NZ  LYS H 294      13.924  59.097  80.960  1.00 48.89           N  
ATOM   2630  N   THR H 295      12.165  61.063  87.982  1.00 45.92           N  
ATOM   2631  CA  THR H 295      11.283  61.381  89.097  1.00 46.78           C  
ATOM   2632  C   THR H 295      11.930  62.255  90.169  1.00 46.98           C  
ATOM   2633  O   THR H 295      11.531  63.402  90.382  1.00 46.53           O  
ATOM   2634  CB  THR H 295      10.731  60.094  89.765  1.00 47.22           C  
ATOM   2635  OG1 THR H 295      11.815  59.298  90.261  1.00 47.80           O  
ATOM   2636  CG2 THR H 295       9.925  59.280  88.761  1.00 47.41           C  
ATOM   2637  N   ILE H 296      12.929  61.709  90.848  1.00 47.45           N  
ATOM   2638  CA  ILE H 296      13.614  62.433  91.908  1.00 46.86           C  
ATOM   2639  C   ILE H 296      13.911  63.888  91.564  1.00 48.50           C  
ATOM   2640  O   ILE H 296      13.788  64.762  92.414  1.00 49.95           O  
ATOM   2641  CB  ILE H 296      14.899  61.704  92.300  1.00 44.83           C  
ATOM   2642  CG1 ILE H 296      14.529  60.344  92.895  1.00 42.92           C  
ATOM   2643  CG2 ILE H 296      15.714  62.550  93.259  1.00 43.76           C  
ATOM   2644  CD1 ILE H 296      15.683  59.590  93.493  1.00 43.29           C  
ATOM   2645  N   ILE H 297      14.289  64.157  90.322  1.00 50.64           N  
ATOM   2646  CA  ILE H 297      14.570  65.527  89.903  1.00 52.18           C  
ATOM   2647  C   ILE H 297      13.261  66.307  89.782  1.00 53.16           C  
ATOM   2648  O   ILE H 297      13.172  67.447  90.228  1.00 53.57           O  
ATOM   2649  CB  ILE H 297      15.339  65.549  88.550  1.00 52.80           C  
ATOM   2650  CG1 ILE H 297      16.776  65.059  88.771  1.00 53.12           C  
ATOM   2651  CG2 ILE H 297      15.356  66.958  87.958  1.00 53.04           C  
ATOM   2652  CD1 ILE H 297      17.613  65.968  89.676  1.00 52.16           C  
ATOM   2653  N   GLU H 298      12.239  65.687  89.199  1.00 54.57           N  
ATOM   2654  CA  GLU H 298      10.940  66.341  89.038  1.00 54.83           C  
ATOM   2655  C   GLU H 298      10.155  66.441  90.349  1.00 54.67           C  
ATOM   2656  O   GLU H 298       9.199  67.205  90.452  1.00 55.72           O  
ATOM   2657  CB  GLU H 298      10.100  65.608  87.979  1.00 56.00           C  
ATOM   2658  CG  GLU H 298      10.612  65.772  86.532  1.00 57.38           C  
ATOM   2659  CD  GLU H 298       9.715  65.093  85.492  1.00 57.43           C  
ATOM   2660  OE1 GLU H 298       9.664  63.839  85.475  1.00 56.84           O  
ATOM   2661  OE2 GLU H 298       9.060  65.817  84.703  1.00 55.30           O  
ATOM   2662  N   GLY H 299      10.546  65.668  91.352  1.00 54.30           N  
ATOM   2663  CA  GLY H 299       9.854  65.732  92.626  1.00 54.47           C  
ATOM   2664  C   GLY H 299      10.588  66.670  93.569  1.00 54.52           C  
ATOM   2665  O   GLY H 299      11.090  66.203  94.614  1.00 54.25           O  
TER    2666      GLY H 299                                                      
END
MOLECULE T0470_112_214.pdb
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
