
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  187 ( 1492),  selected  187 , name 2o08_A
# Molecule2: number of CA atoms   97 (  787),  selected   97 , name T0470_2_100.pdb
# PARAMETERS: 2o08_A.T0470_2_100.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       2           -
LGA    G     0_A      K       3          4.361
LGA    X     1_A      Q       4           #
LGA    -       -      E       5           -
LGA    N     2_A      K       6          2.132
LGA    R     3_A      I       7          2.536
LGA    G     4_A      E       8          1.925
LGA    K     5_A      K       9          0.367
LGA    A     6_A      T      10          0.373
LGA    L     7_A      I      11          1.156
LGA    Q     8_A      T      12          1.224
LGA    L     9_A      F      13          0.996
LGA    V    10_A      V      14          1.096
LGA    K    11_A      K      15          1.112
LGA    P    12_A      H      16          1.684
LGA    H    13_A      I      17          2.779
LGA    L    14_A      L      18          2.324
LGA    -       -      E      19           -
LGA    -       -      K      20           -
LGA    -       -      D      21           -
LGA    -       -      A      22           -
LGA    T    15_A      S      23          2.299
LGA    E    16_A      G      24          3.850
LGA    H    17_A      H      25          2.854
LGA    R    18_A      D      26          0.725
LGA    Y    19_A      W      27          0.738
LGA    Q    20_A      Y      28          0.406
LGA    H    21_A      H      29          1.035
LGA    T    22_A      I      30          1.176
LGA    I    23_A      R      31          0.617
LGA    G    24_A      R      32          1.069
LGA    V    25_A      V      33          1.535
LGA    X    26_A      H      34          0.922
LGA    E    27_A      K      35          0.871
LGA    T    28_A      M      36          1.191
LGA    A    29_A      A      37          1.139
LGA    I    30_A      I      38          1.180
LGA    D    31_A      S      39          1.639
LGA    L    32_A      L      40          1.766
LGA    A    33_A      S      41          1.502
LGA    K    34_A      E      42          1.391
LGA    L    35_A      Q      43          1.669
LGA    Y    36_A      E      44          1.323
LGA    G    37_A      G      45          0.688
LGA    A    38_A      G      46          0.624
LGA    D    39_A      N      47          0.972
LGA    Q    40_A      R      48          1.181
LGA    Q    41_A      F      49          1.359
LGA    K    42_A      I      50          1.075
LGA    A    43_A      I      51          0.831
LGA    E    44_A      E      52          0.878
LGA    L    45_A      M      53          0.794
LGA    A    46_A      A      54          0.727
LGA    A    47_A      A      55          1.112
LGA    I    48_A      L      56          1.109
LGA    F    49_A      L      57          1.036
LGA    H    50_A      H      58          1.110
LGA    D    51_A      D      59          1.080
LGA    Y    52_A      V      60          1.145
LGA    A    53_A      A      61          2.578
LGA    K    54_A      D      62          3.213
LGA    F    55_A      L      65          2.691
LGA    R    56_A      N      66          2.512
LGA    D    57_A      E      67          2.624
LGA    K    58_A      S      68          2.540
LGA    N    59_A      -       -           -
LGA    E    60_A      -       -           -
LGA    X    61_A      E      69          3.354
LGA    R    62_A      -       -           -
LGA    T    63_A      -       -           -
LGA    L    64_A      -       -           -
LGA    I    65_A      -       -           -
LGA    R    66_A      -       -           -
LGA    E    67_A      -       -           -
LGA    K    68_A      -       -           -
LGA    L    69_A      -       -           -
LGA    S    70_A      -       -           -
LGA    Q    71_A      -       -           -
LGA    Q    72_A      -       -           -
LGA    D    73_A      -       -           -
LGA    I    74_A      -       -           -
LGA    L    75_A      -       -           -
LGA    F    76_A      -       -           -
LGA    Y    77_A      -       -           -
LGA    G    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    L    81_A      -       -           -
LGA    L    82_A      -       -           -
LGA    H    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    P    85_A      E      70          4.548
LGA    C    86_A      A      71          3.947
LGA    G    87_A      G      72          3.202
LGA    A    88_A      M      73          3.156
LGA    Y    89_A      K      74          2.926
LGA    Y    90_A      K      75          2.020
LGA    V    91_A      V      76          0.985
LGA    R    92_A      S      77          1.188
LGA    E    93_A      D      78          2.364
LGA    E    94_A      -       -           -
LGA    V    95_A      W      79          0.481
LGA    G    96_A      L      80          3.353
LGA    I    97_A      E      81          4.099
LGA    E    98_A      E      82           -
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    -       -      V      85           -
LGA    -       -      E      86           -
LGA    -       -      E      87           -
LGA    D    99_A      E      88          4.961
LGA    -       -      E      89           -
LGA    -       -      S      90           -
LGA    E   100_A      K      91          1.378
LGA    D   101_A      H      92          1.351
LGA    V   102_A      V      93          0.728
LGA    L   103_A      L      94          1.145
LGA    Q   104_A      H      95          1.118
LGA    A   105_A      I      96          1.414
LGA    I   106_A      I      97          0.509
LGA    R   107_A      A      98          0.919
LGA    F   108_A      N      99          0.768
LGA    H   109_A      M     100          1.333
LGA    T   110_A      -       -           -
LGA    T   111_A      -       -           -
LGA    G   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    P   114_A      -       -           -
LGA    N   115_A      -       -           -
LGA    X   116_A      -       -           -
LGA    S   117_A      -       -           -
LGA    L   118_A      -       -           -
LGA    L   119_A      -       -           -
LGA    E   120_A      -       -           -
LGA    K   121_A      -       -           -
LGA    I   122_A      -       -           -
LGA    I   123_A      -       -           -
LGA    F   124_A      -       -           -
LGA    L   125_A      -       -           -
LGA    A   126_A      -       -           -
LGA    D   127_A      -       -           -
LGA    Y   128_A      -       -           -
LGA    I   129_A      -       -           -
LGA    E   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    N   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    Q   134_A      -       -           -
LGA    F   135_A      -       -           -
LGA    P   136_A      -       -           -
LGA    G   137_A      -       -           -
LGA    V   138_A      -       -           -
LGA    E   139_A      -       -           -
LGA    K   140_A      -       -           -
LGA    V   141_A      -       -           -
LGA    R   142_A      -       -           -
LGA    T   143_A      -       -           -
LGA    Q   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    K   146_A      -       -           -
LGA    T   147_A      -       -           -
LGA    D   148_A      -       -           -
LGA    L   149_A      -       -           -
LGA    N   150_A      -       -           -
LGA    G   151_A      -       -           -
LGA    A   152_A      -       -           -
LGA    I   153_A      -       -           -
LGA    I   154_A      -       -           -
LGA    S   155_A      -       -           -
LGA    S   156_A      -       -           -
LGA    L   157_A      -       -           -
LGA    V   158_A      -       -           -
LGA    N   159_A      -       -           -
LGA    T   160_A      -       -           -
LGA    I   161_A      -       -           -
LGA    T   162_A      -       -           -
LGA    F   163_A      -       -           -
LGA    L   164_A      -       -           -
LGA    L   165_A      -       -           -
LGA    K   166_A      -       -           -
LGA    K   167_A      -       -           -
LGA    N   168_A      -       -           -
LGA    Q   169_A      -       -           -
LGA    P   170_A      -       -           -
LGA    I   171_A      -       -           -
LGA    Y   172_A      -       -           -
LGA    P   173_A      -       -           -
LGA    D   174_A      -       -           -
LGA    T   175_A      -       -           -
LGA    L   176_A      -       -           -
LGA    A   177_A      -       -           -
LGA    T   178_A      -       -           -
LGA    Y   179_A      -       -           -
LGA    N   180_A      -       -           -
LGA    Q   181_A      -       -           -
LGA    L   182_A      -       -           -
LGA    L   183_A      -       -           -
LGA    L   184_A      -       -           -
LGA    E   185_A      -       -           -
LGA    Q   186_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  187   97    5.0     82    1.99    26.83     75.407     3.918

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.016560 * X  +  -0.580787 * Y  +  -0.813887 * Z  +  58.650326
  Y_new =   0.561069 * X  +   0.668363 * Y  +  -0.488357 * Z  +   2.525584
  Z_new =   0.827603 * X  +  -0.464734 * Y  +   0.314794 * Z  +  32.108128 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.975424    2.166168  [ DEG:   -55.8877    124.1123 ]
  Theta =  -0.974824   -2.166768  [ DEG:   -55.8533   -124.1467 ]
  Phi   =   1.600302   -1.541290  [ DEG:    91.6906    -88.3094 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o08_A                                        
REMARK     2: T0470_2_100.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o08_A.T0470_2_100.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  187   97   5.0   82   1.99   26.83  75.407
REMARK  ---------------------------------------------------------- 
MOLECULE 2o08_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-NOV-06   2O08              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE HD SUPERFAMILY HYDROLASE              
TITLE    2 (NP_242193.1) FROM BACILLUS HALODURANS AT 1.90 A RESOLUTION          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BH1327 PROTEIN;                                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_242193.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_242193.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PSI-2, PROTEIN           
KEYWDS   3 STRUCTURE INITIATIVE                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   19-DEC-06 2O08    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_242193.1) FROM BACILLUS HALODURANS AT 1.90 A             
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2O08 A    1   187  UNP    Q9KD90   Q9KD90_BACHD     1    187             
DBREF  2O08 B    1   187  UNP    Q9KD90   Q9KD90_BACHD     1    187             
SEQRES   1 A  188  GLY MSE ASN ARG GLY LYS ALA LEU GLN LEU VAL LYS PRO          
SEQRES   2 A  188  HIS LEU THR GLU HIS ARG TYR GLN HIS THR ILE GLY VAL          
SEQRES   3 A  188  MSE GLU THR ALA ILE ASP LEU ALA LYS LEU TYR GLY ALA          
SEQRES   4 A  188  ASP GLN GLN LYS ALA GLU LEU ALA ALA ILE PHE HIS ASP          
SEQRES   5 A  188  TYR ALA LYS PHE ARG ASP LYS ASN GLU MSE ARG THR LEU          
SEQRES   6 A  188  ILE ARG GLU LYS LEU SER GLN GLN ASP ILE LEU PHE TYR          
SEQRES   7 A  188  GLY ASP GLU LEU LEU HIS ALA PRO CYS GLY ALA TYR TYR          
SEQRES   8 A  188  VAL ARG GLU GLU VAL GLY ILE GLU ASP GLU ASP VAL LEU          
SEQRES   9 A  188  GLN ALA ILE ARG PHE HIS THR THR GLY ARG PRO ASN MSE          
SEQRES  10 A  188  SER LEU LEU GLU LYS ILE ILE PHE LEU ALA ASP TYR ILE          
SEQRES  11 A  188  GLU PRO ASN ARG GLN PHE PRO GLY VAL GLU LYS VAL ARG          
SEQRES  12 A  188  THR GLN ALA LYS THR ASP LEU ASN GLY ALA ILE ILE SER          
SEQRES  13 A  188  SER LEU VAL ASN THR ILE THR PHE LEU LEU LYS LYS ASN          
SEQRES  14 A  188  GLN PRO ILE TYR PRO ASP THR LEU ALA THR TYR ASN GLN          
SEQRES  15 A  188  LEU LEU LEU GLU GLN LYS                                      
SEQRES   1 B  188  GLY MSE ASN ARG GLY LYS ALA LEU GLN LEU VAL LYS PRO          
SEQRES   2 B  188  HIS LEU THR GLU HIS ARG TYR GLN HIS THR ILE GLY VAL          
SEQRES   3 B  188  MSE GLU THR ALA ILE ASP LEU ALA LYS LEU TYR GLY ALA          
SEQRES   4 B  188  ASP GLN GLN LYS ALA GLU LEU ALA ALA ILE PHE HIS ASP          
SEQRES   5 B  188  TYR ALA LYS PHE ARG ASP LYS ASN GLU MSE ARG THR LEU          
SEQRES   6 B  188  ILE ARG GLU LYS LEU SER GLN GLN ASP ILE LEU PHE TYR          
SEQRES   7 B  188  GLY ASP GLU LEU LEU HIS ALA PRO CYS GLY ALA TYR TYR          
SEQRES   8 B  188  VAL ARG GLU GLU VAL GLY ILE GLU ASP GLU ASP VAL LEU          
SEQRES   9 B  188  GLN ALA ILE ARG PHE HIS THR THR GLY ARG PRO ASN MSE          
SEQRES  10 B  188  SER LEU LEU GLU LYS ILE ILE PHE LEU ALA ASP TYR ILE          
SEQRES  11 B  188  GLU PRO ASN ARG GLN PHE PRO GLY VAL GLU LYS VAL ARG          
SEQRES  12 B  188  THR GLN ALA LYS THR ASP LEU ASN GLY ALA ILE ILE SER          
SEQRES  13 B  188  SER LEU VAL ASN THR ILE THR PHE LEU LEU LYS LYS ASN          
SEQRES  14 B  188  GLN PRO ILE TYR PRO ASP THR LEU ALA THR TYR ASN GLN          
SEQRES  15 B  188  LEU LEU LEU GLU GLN LYS                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  26       8                                                       
HET    MSE  A  61       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  26       8                                                       
HET    MSE  B  61       8                                                       
HET    MSE  B 116       8                                                       
HET     FE  A 400       1                                                       
HET     FE  A 401       1                                                       
HET    PO4  A 500       5                                                       
HET     FE  B 400       1                                                       
HET     FE  B 401       1                                                       
HET    NO3      1       4                                                       
HET    UNL  A 501      14                                                       
HET    DGI  B 500      27                                                       
HET    PG4      2      10                                                       
HET    PG4      3       7                                                       
HET    PG4      4      10                                                       
HET    PG4      5      10                                                       
HET    PG4      6      10                                                       
HET    PG4      7       8                                                       
HET    PG4      8      10                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      FE FE (III) ION                                                     
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     NO3 NITRATE ION                                                      
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     DGI 2'-DEOXYGUANOSINE-5'-DIPHOSPHATE                                 
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3   FE    4(FE 3+)                                                     
FORMUL   5  PO4    O4 P 3-                                                      
FORMUL   8  NO3    N O3 1-                                                      
FORMUL  10  DGI    C10 H15 N5 O10 P2                                            
FORMUL  11  PG4    7(C8 H18 O5)                                                 
FORMUL  18  HOH   *325(H2 O)                                                    
CRYST1   86.830  166.510   73.410  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   GLY A   0      51.983  30.526  81.725  1.00 35.81           N  
ATOM      2  CA  GLY A   0      52.223  31.973  81.926  1.00 35.06           C  
ATOM      3  C   GLY A   0      52.442  32.373  83.366  1.00 34.97           C  
ATOM      4  O   GLY A   0      52.289  31.576  84.281  1.00 37.00           O  
HETATM    5  N   MSE A   1      52.816  33.635  83.541  1.00 35.39           N  
HETATM    6  CA  MSE A   1      53.044  34.201  84.857  1.00 36.13           C  
HETATM    7  C   MSE A   1      51.761  34.096  85.655  1.00 35.30           C  
HETATM    8  O   MSE A   1      50.686  34.332  85.108  1.00 34.10           O  
HETATM    9  CB  MSE A   1      53.428  35.667  84.700  1.00 34.33           C  
HETATM   10  CG  MSE A   1      53.768  36.387  85.944  1.00 40.47           C  
HETATM   11 SE   MSE A   1      54.383  38.156  85.575  0.75 32.93          SE  
HETATM   12  CE  MSE A   1      56.011  37.788  84.541  1.00 38.47           C  
ATOM     13  N   ASN A   2      51.867  33.801  86.948  1.00 35.48           N  
ATOM     14  CA  ASN A   2      50.692  33.671  87.776  1.00 35.46           C  
ATOM     15  C   ASN A   2      50.188  35.034  88.256  1.00 34.08           C  
ATOM     16  O   ASN A   2      50.876  36.025  88.125  1.00 34.81           O  
ATOM     17  CB  ASN A   2      50.906  32.647  88.901  1.00 35.44           C  
ATOM     18  CG  ASN A   2      51.788  33.143  90.034  1.00 44.60           C  
ATOM     19  OD1 ASN A   2      52.003  34.338  90.221  1.00 49.78           O  
ATOM     20  ND2 ASN A   2      52.252  32.197  90.858  1.00 46.09           N  
ATOM     21  N   ARG A   3      48.983  35.046  88.821  1.00 33.21           N  
ATOM     22  CA  ARG A   3      48.303  36.273  89.220  1.00 30.56           C  
ATOM     23  C   ARG A   3      49.160  37.105  90.155  1.00 33.07           C  
ATOM     24  O   ARG A   3      49.365  38.285  89.929  1.00 33.70           O  
ATOM     25  CB  ARG A   3      46.992  35.915  89.939  1.00 30.75           C  
ATOM     26  CG  ARG A   3      46.241  37.119  90.473  1.00 33.65           C  
ATOM     27  CD  ARG A   3      44.984  36.713  91.232  1.00 33.96           C  
ATOM     28  NE  ARG A   3      43.988  36.168  90.322  1.00 27.61           N  
ATOM     29  CZ  ARG A   3      42.707  35.971  90.614  1.00 32.81           C  
ATOM     30  NH1 ARG A   3      42.233  36.218  91.822  1.00 31.80           N  
ATOM     31  NH2 ARG A   3      41.897  35.502  89.691  1.00 34.14           N  
ATOM     32  N   GLY A   4      49.631  36.473  91.231  1.00 32.81           N  
ATOM     33  CA  GLY A   4      50.480  37.147  92.216  1.00 32.12           C  
ATOM     34  C   GLY A   4      51.686  37.856  91.633  1.00 32.78           C  
ATOM     35  O   GLY A   4      51.945  38.995  91.981  1.00 30.63           O  
ATOM     36  N   LYS A   5      52.427  37.187  90.753  1.00 31.65           N  
ATOM     37  CA  LYS A   5      53.616  37.806  90.156  1.00 28.81           C  
ATOM     38  C   LYS A   5      53.184  38.914  89.220  1.00 31.75           C  
ATOM     39  O   LYS A   5      53.746  40.021  89.255  1.00 29.84           O  
ATOM     40  CB  LYS A   5      54.508  36.811  89.394  1.00 30.15           C  
ATOM     41  CG  LYS A   5      55.057  35.647  90.177  1.00 33.47           C  
ATOM     42  CD  LYS A   5      55.825  36.047  91.375  1.00 43.38           C  
ATOM     43  CE  LYS A   5      56.435  34.806  92.015  1.00 47.70           C  
ATOM     44  NZ  LYS A   5      56.498  34.937  93.481  1.00 40.66           N  
ATOM     45  N   ALA A   6      52.162  38.637  88.402  1.00 31.43           N  
ATOM     46  CA  ALA A   6      51.663  39.650  87.464  1.00 32.19           C  
ATOM     47  C   ALA A   6      51.235  40.922  88.198  1.00 30.65           C  
ATOM     48  O   ALA A   6      51.646  42.052  87.837  1.00 29.83           O  
ATOM     49  CB  ALA A   6      50.514  39.071  86.611  1.00 32.44           C  
ATOM     50  N   LEU A   7      50.461  40.752  89.264  1.00 30.06           N  
ATOM     51  CA  LEU A   7      50.058  41.903  90.061  1.00 32.10           C  
ATOM     52  C   LEU A   7      51.218  42.590  90.727  1.00 32.97           C  
ATOM     53  O   LEU A   7      51.223  43.823  90.836  1.00 37.77           O  
ATOM     54  CB  LEU A   7      49.010  41.514  91.123  1.00 28.41           C  
ATOM     55  CG  LEU A   7      47.632  41.241  90.552  1.00 30.16           C  
ATOM     56  CD1 LEU A   7      46.779  40.641  91.654  1.00 27.38           C  
ATOM     57  CD2 LEU A   7      47.003  42.542  89.986  1.00 28.17           C  
ATOM     58  N   GLN A   8      52.218  41.828  91.165  1.00 30.82           N  
ATOM     59  CA  GLN A   8      53.378  42.457  91.792  1.00 32.86           C  
ATOM     60  C   GLN A   8      54.076  43.399  90.808  1.00 33.69           C  
ATOM     61  O   GLN A   8      54.600  44.423  91.198  1.00 30.94           O  
ATOM     62  CB  GLN A   8      54.368  41.430  92.312  1.00 33.57           C  
ATOM     63  CG  GLN A   8      55.190  41.977  93.424  1.00 49.44           C  
ATOM     64  CD  GLN A   8      56.440  41.188  93.691  1.00 61.35           C  
ATOM     65  OE1 GLN A   8      56.385  39.953  93.861  1.00 50.48           O  
ATOM     66  NE2 GLN A   8      57.595  41.902  93.741  1.00 54.31           N  
ATOM     67  N   LEU A   9      54.056  43.075  89.526  1.00 31.42           N  
ATOM     68  CA  LEU A   9      54.704  43.945  88.539  1.00 29.71           C  
ATOM     69  C   LEU A   9      53.933  45.224  88.181  1.00 32.37           C  
ATOM     70  O   LEU A   9      54.564  46.220  87.859  1.00 34.72           O  
ATOM     71  CB  LEU A   9      55.100  43.156  87.301  1.00 30.68           C  
ATOM     72  CG  LEU A   9      56.239  42.134  87.549  1.00 26.75           C  
ATOM     73  CD1 LEU A   9      56.508  41.449  86.274  1.00 24.89           C  
ATOM     74  CD2 LEU A   9      57.531  42.710  88.070  1.00 26.09           C  
ATOM     75  N   VAL A  10      52.600  45.201  88.227  1.00 29.96           N  
ATOM     76  CA  VAL A  10      51.783  46.402  87.931  1.00 29.14           C  
ATOM     77  C   VAL A  10      51.462  47.309  89.141  1.00 30.21           C  
ATOM     78  O   VAL A  10      51.439  48.561  89.017  1.00 30.03           O  
ATOM     79  CB  VAL A  10      50.480  46.011  87.172  1.00 30.17           C  
ATOM     80  CG1 VAL A  10      50.851  45.425  85.804  1.00 28.24           C  
ATOM     81  CG2 VAL A  10      49.603  45.025  87.994  1.00 30.80           C  
ATOM     82  N   LYS A  11      51.307  46.704  90.312  1.00 30.03           N  
ATOM     83  CA  LYS A  11      50.934  47.453  91.541  1.00 33.71           C  
ATOM     84  C   LYS A  11      51.705  48.725  91.856  1.00 32.58           C  
ATOM     85  O   LYS A  11      51.125  49.719  92.279  1.00 36.06           O  
ATOM     86  CB  LYS A  11      50.962  46.565  92.772  1.00 35.12           C  
ATOM     87  CG  LYS A  11      49.620  45.890  92.971  1.00 43.28           C  
ATOM     88  CD  LYS A  11      49.679  44.799  94.017  1.00 45.86           C  
ATOM     89  CE  LYS A  11      49.861  45.318  95.432  1.00 59.05           C  
ATOM     90  NZ  LYS A  11      49.804  44.158  96.409  1.00 57.62           N  
ATOM     91  N   PRO A  12      53.025  48.706  91.698  1.00 37.62           N  
ATOM     92  CA  PRO A  12      53.755  49.952  92.038  1.00 37.08           C  
ATOM     93  C   PRO A  12      53.321  51.231  91.289  1.00 36.27           C  
ATOM     94  O   PRO A  12      53.674  52.331  91.718  1.00 34.21           O  
ATOM     95  CB  PRO A  12      55.204  49.612  91.668  1.00 38.93           C  
ATOM     96  CG  PRO A  12      55.273  48.109  91.745  1.00 42.15           C  
ATOM     97  CD  PRO A  12      53.933  47.628  91.276  1.00 37.11           C  
ATOM     98  N   HIS A  13      52.595  51.092  90.175  1.00 31.22           N  
ATOM     99  CA  HIS A  13      52.164  52.232  89.386  1.00 35.34           C  
ATOM    100  C   HIS A  13      50.671  52.308  89.281  1.00 31.73           C  
ATOM    101  O   HIS A  13      50.145  52.876  88.321  1.00 33.29           O  
ATOM    102  CB  HIS A  13      52.811  52.136  87.995  1.00 37.27           C  
ATOM    103  CG  HIS A  13      54.288  51.837  88.053  1.00 50.58           C  
ATOM    104  ND1 HIS A  13      54.802  50.570  87.838  1.00 62.38           N  
ATOM    105  CD2 HIS A  13      55.352  52.627  88.344  1.00 59.84           C  
ATOM    106  CE1 HIS A  13      56.115  50.598  87.981  1.00 56.80           C  
ATOM    107  NE2 HIS A  13      56.475  51.836  88.287  1.00 58.51           N  
ATOM    108  N   LEU A  14      49.986  51.763  90.297  1.00 33.54           N  
ATOM    109  CA  LEU A  14      48.536  51.772  90.354  1.00 31.20           C  
ATOM    110  C   LEU A  14      48.090  52.517  91.604  1.00 31.80           C  
ATOM    111  O   LEU A  14      48.445  52.122  92.701  1.00 31.25           O  
ATOM    112  CB  LEU A  14      47.981  50.348  90.383  1.00 32.26           C  
ATOM    113  CG  LEU A  14      48.155  49.480  89.126  1.00 28.56           C  
ATOM    114  CD1 LEU A  14      47.645  48.051  89.400  1.00 30.46           C  
ATOM    115  CD2 LEU A  14      47.444  50.111  87.940  1.00 27.41           C  
ATOM    116  N   THR A  15      47.301  53.572  91.438  1.00 31.19           N  
ATOM    117  CA  THR A  15      46.578  54.167  92.580  1.00 30.66           C  
ATOM    118  C   THR A  15      45.509  53.147  92.995  1.00 33.03           C  
ATOM    119  O   THR A  15      45.239  52.148  92.268  1.00 32.88           O  
ATOM    120  CB  THR A  15      45.840  55.426  92.174  1.00 29.16           C  
ATOM    121  OG1 THR A  15      44.863  55.072  91.167  1.00 32.87           O  
ATOM    122  CG2 THR A  15      46.831  56.479  91.615  1.00 28.16           C  
ATOM    123  N   GLU A  16      44.838  53.409  94.110  1.00 34.87           N  
ATOM    124  CA  GLU A  16      43.765  52.507  94.544  1.00 35.79           C  
ATOM    125  C   GLU A  16      42.667  52.352  93.493  1.00 33.81           C  
ATOM    126  O   GLU A  16      42.213  51.231  93.223  1.00 29.87           O  
ATOM    127  CB  GLU A  16      43.195  52.976  95.885  1.00 36.31           C  
ATOM    128  CG  GLU A  16      42.161  52.038  96.536  1.00 45.47           C  
ATOM    129  CD  GLU A  16      42.652  50.576  96.710  1.00 62.37           C  
ATOM    130  OE1 GLU A  16      43.880  50.359  96.838  1.00 66.42           O  
ATOM    131  OE2 GLU A  16      41.803  49.650  96.711  1.00 60.26           O  
ATOM    132  N   HIS A  17      42.264  53.442  92.848  1.00 32.26           N  
ATOM    133  CA  HIS A  17      41.242  53.327  91.812  1.00 29.25           C  
ATOM    134  C   HIS A  17      41.756  52.509  90.657  1.00 30.85           C  
ATOM    135  O   HIS A  17      41.025  51.678  90.123  1.00 27.83           O  
ATOM    136  CB  HIS A  17      40.740  54.661  91.279  1.00 31.35           C  
ATOM    137  CG  HIS A  17      39.763  55.373  92.184  1.00 32.59           C  
ATOM    138  ND1 HIS A  17      38.499  55.742  91.760  1.00 31.01           N  
ATOM    139  CD2 HIS A  17      39.864  55.789  93.472  1.00 37.17           C  
ATOM    140  CE1 HIS A  17      37.872  56.364  92.751  1.00 39.88           C  
ATOM    141  NE2 HIS A  17      38.682  56.411  93.796  1.00 31.86           N  
ATOM    142  N   ARG A  18      42.994  52.731  90.243  1.00 30.39           N  
ATOM    143  CA  ARG A  18      43.526  51.940  89.129  1.00 30.09           C  
ATOM    144  C   ARG A  18      43.723  50.466  89.527  1.00 30.08           C  
ATOM    145  O   ARG A  18      43.536  49.569  88.704  1.00 29.69           O  
ATOM    146  CB  ARG A  18      44.825  52.553  88.580  1.00 31.29           C  
ATOM    147  CG  ARG A  18      44.616  53.948  87.954  1.00 28.15           C  
ATOM    148  CD  ARG A  18      43.538  54.043  86.863  1.00 31.28           C  
ATOM    149  NE  ARG A  18      43.823  53.213  85.703  1.00 32.39           N  
ATOM    150  CZ  ARG A  18      43.109  53.211  84.567  1.00 32.67           C  
ATOM    151  NH1 ARG A  18      42.070  54.027  84.373  1.00 33.43           N  
ATOM    152  NH2 ARG A  18      43.476  52.415  83.576  1.00 34.98           N  
ATOM    153  N   TYR A  19      44.043  50.220  90.791  1.00 30.42           N  
ATOM    154  CA  TYR A  19      44.181  48.850  91.253  1.00 31.33           C  
ATOM    155  C   TYR A  19      42.825  48.164  91.162  1.00 30.94           C  
ATOM    156  O   TYR A  19      42.700  47.041  90.624  1.00 31.11           O  
ATOM    157  CB  TYR A  19      44.726  48.812  92.687  1.00 32.04           C  
ATOM    158  CG  TYR A  19      44.781  47.391  93.223  1.00 34.42           C  
ATOM    159  CD1 TYR A  19      45.724  46.493  92.758  1.00 34.41           C  
ATOM    160  CD2 TYR A  19      43.836  46.927  94.137  1.00 35.99           C  
ATOM    161  CE1 TYR A  19      45.773  45.173  93.231  1.00 32.37           C  
ATOM    162  CE2 TYR A  19      43.879  45.619  94.604  1.00 38.06           C  
ATOM    163  CZ  TYR A  19      44.854  44.753  94.139  1.00 39.53           C  
ATOM    164  OH  TYR A  19      44.918  43.459  94.583  1.00 45.04           O  
ATOM    165  N   GLN A  20      41.790  48.838  91.670  1.00 28.87           N  
ATOM    166  CA  GLN A  20      40.427  48.283  91.551  1.00 28.75           C  
ATOM    167  C   GLN A  20      39.997  48.060  90.116  1.00 29.38           C  
ATOM    168  O   GLN A  20      39.301  47.078  89.821  1.00 32.25           O  
ATOM    169  CB  GLN A  20      39.407  49.150  92.302  1.00 30.61           C  
ATOM    170  CG  GLN A  20      39.638  49.161  93.809  1.00 37.66           C  
ATOM    171  CD  GLN A  20      39.601  47.727  94.438  1.00 47.40           C  
ATOM    172  OE1 GLN A  20      38.885  46.840  93.962  1.00 52.08           O  
ATOM    173  NE2 GLN A  20      40.379  47.520  95.489  1.00 48.44           N  
ATOM    174  N   HIS A  21      40.364  48.963  89.217  1.00 28.00           N  
ATOM    175  CA  HIS A  21      40.113  48.749  87.790  1.00 27.09           C  
ATOM    176  C   HIS A  21      40.746  47.435  87.297  1.00 29.18           C  
ATOM    177  O   HIS A  21      40.106  46.655  86.580  1.00 28.64           O  
ATOM    178  CB  HIS A  21      40.664  49.930  86.960  1.00 27.70           C  
ATOM    179  CG  HIS A  21      40.543  49.748  85.479  1.00 28.13           C  
ATOM    180  ND1 HIS A  21      39.326  49.578  84.846  1.00 28.94           N  
ATOM    181  CD2 HIS A  21      41.482  49.717  84.505  1.00 31.02           C  
ATOM    182  CE1 HIS A  21      39.527  49.473  83.543  1.00 29.55           C  
ATOM    183  NE2 HIS A  21      40.825  49.535  83.312  1.00 28.46           N  
ATOM    184  N   THR A  22      42.001  47.192  87.691  1.00 27.66           N  
ATOM    185  CA  THR A  22      42.763  46.028  87.228  1.00 29.22           C  
ATOM    186  C   THR A  22      42.113  44.732  87.656  1.00 28.08           C  
ATOM    187  O   THR A  22      41.895  43.821  86.836  1.00 28.86           O  
ATOM    188  CB  THR A  22      44.234  46.109  87.755  1.00 31.23           C  
ATOM    189  OG1 THR A  22      44.785  47.379  87.375  1.00 30.15           O  
ATOM    190  CG2 THR A  22      45.147  44.952  87.212  1.00 27.35           C  
ATOM    191  N   ILE A  23      41.783  44.679  88.928  1.00 29.10           N  
ATOM    192  CA  ILE A  23      41.109  43.514  89.513  1.00 33.10           C  
ATOM    193  C   ILE A  23      39.753  43.310  88.854  1.00 33.13           C  
ATOM    194  O   ILE A  23      39.379  42.146  88.526  1.00 33.21           O  
ATOM    195  CB  ILE A  23      40.949  43.687  91.056  1.00 33.09           C  
ATOM    196  CG1 ILE A  23      42.337  43.743  91.739  1.00 34.76           C  
ATOM    197  CG2 ILE A  23      40.094  42.587  91.658  1.00 36.85           C  
ATOM    198  CD1 ILE A  23      43.335  42.647  91.340  1.00 29.05           C  
ATOM    199  N   GLY A  24      39.028  44.418  88.635  1.00 30.70           N  
ATOM    200  CA  GLY A  24      37.721  44.335  87.988  1.00 29.82           C  
ATOM    201  C   GLY A  24      37.834  43.775  86.593  1.00 30.57           C  
ATOM    202  O   GLY A  24      37.073  42.849  86.201  1.00 31.19           O  
ATOM    203  N   VAL A  25      38.781  44.304  85.830  1.00 27.54           N  
ATOM    204  CA  VAL A  25      38.992  43.785  84.434  1.00 28.34           C  
ATOM    205  C   VAL A  25      39.393  42.293  84.447  1.00 28.97           C  
ATOM    206  O   VAL A  25      38.871  41.457  83.658  1.00 28.32           O  
ATOM    207  CB  VAL A  25      40.010  44.648  83.658  1.00 29.03           C  
ATOM    208  CG1 VAL A  25      40.245  44.081  82.224  1.00 25.52           C  
ATOM    209  CG2 VAL A  25      39.527  46.062  83.587  1.00 25.05           C  
HETATM  210  N   MSE A  26      40.315  41.970  85.346  1.00 28.43           N  
HETATM  211  CA  MSE A  26      40.819  40.627  85.530  1.00 29.61           C  
HETATM  212  C   MSE A  26      39.702  39.667  85.859  1.00 31.02           C  
HETATM  213  O   MSE A  26      39.576  38.624  85.193  1.00 29.90           O  
HETATM  214  CB  MSE A  26      41.850  40.595  86.630  1.00 30.30           C  
HETATM  215  CG  MSE A  26      42.488  39.202  86.887  1.00 33.29           C  
HETATM  216 SE   MSE A  26      43.461  39.253  88.551  0.75 31.78          SE  
HETATM  217  CE  MSE A  26      42.044  39.415  89.824  1.00 29.63           C  
ATOM    218  N   GLU A  27      38.865  39.993  86.837  1.00 30.48           N  
ATOM    219  CA  GLU A  27      37.761  39.065  87.203  1.00 32.67           C  
ATOM    220  C   GLU A  27      36.669  38.931  86.142  1.00 32.19           C  
ATOM    221  O   GLU A  27      36.152  37.829  85.894  1.00 29.18           O  
ATOM    222  CB  GLU A  27      37.146  39.459  88.533  1.00 34.11           C  
ATOM    223  CG  GLU A  27      38.142  39.243  89.670  1.00 41.59           C  
ATOM    224  CD  GLU A  27      37.750  39.846  91.009  1.00 43.40           C  
ATOM    225  OE1 GLU A  27      37.145  40.950  91.053  1.00 58.01           O  
ATOM    226  OE2 GLU A  27      38.133  39.221  92.037  1.00 63.13           O  
ATOM    227  N   THR A  28      36.317  40.049  85.527  1.00 28.49           N  
ATOM    228  CA  THR A  28      35.354  40.073  84.434  1.00 29.47           C  
ATOM    229  C   THR A  28      35.885  39.272  83.252  1.00 28.69           C  
ATOM    230  O   THR A  28      35.180  38.504  82.624  1.00 33.10           O  
ATOM    231  CB  THR A  28      35.032  41.551  84.020  1.00 31.73           C  
ATOM    232  OG1 THR A  28      34.665  42.320  85.192  1.00 29.70           O  
ATOM    233  CG2 THR A  28      33.877  41.602  83.005  1.00 32.54           C  
ATOM    234  N   ALA A  29      37.157  39.432  82.955  1.00 28.50           N  
ATOM    235  CA  ALA A  29      37.758  38.686  81.845  1.00 28.58           C  
ATOM    236  C   ALA A  29      37.709  37.186  82.118  1.00 29.15           C  
ATOM    237  O   ALA A  29      37.395  36.405  81.223  1.00 30.61           O  
ATOM    238  CB  ALA A  29      39.176  39.126  81.621  1.00 30.43           C  
ATOM    239  N   ILE A  30      38.017  36.779  83.350  1.00 30.42           N  
ATOM    240  CA  ILE A  30      37.991  35.350  83.703  1.00 29.73           C  
ATOM    241  C   ILE A  30      36.584  34.792  83.515  1.00 30.89           C  
ATOM    242  O   ILE A  30      36.400  33.728  82.934  1.00 34.48           O  
ATOM    243  CB  ILE A  30      38.557  35.082  85.119  1.00 30.80           C  
ATOM    244  CG1 ILE A  30      40.068  35.402  85.158  1.00 32.08           C  
ATOM    245  CG2 ILE A  30      38.329  33.629  85.544  1.00 30.36           C  
ATOM    246  CD1 ILE A  30      40.665  35.659  86.606  1.00 28.02           C  
ATOM    247  N   ASP A  31      35.599  35.533  83.988  1.00 34.39           N  
ATOM    248  CA  ASP A  31      34.190  35.122  83.902  1.00 34.51           C  
ATOM    249  C   ASP A  31      33.700  35.010  82.460  1.00 35.15           C  
ATOM    250  O   ASP A  31      32.993  34.053  82.114  1.00 36.80           O  
ATOM    251  CB  ASP A  31      33.311  36.129  84.634  1.00 36.23           C  
ATOM    252  CG  ASP A  31      33.506  36.112  86.153  1.00 45.73           C  
ATOM    253  OD1 ASP A  31      34.123  35.167  86.704  1.00 54.46           O  
ATOM    254  OD2 ASP A  31      33.014  37.063  86.801  1.00 54.07           O  
ATOM    255  N   LEU A  32      34.076  35.982  81.626  1.00 30.42           N  
ATOM    256  CA  LEU A  32      33.791  35.940  80.213  1.00 30.63           C  
ATOM    257  C   LEU A  32      34.533  34.797  79.539  1.00 33.66           C  
ATOM    258  O   LEU A  32      33.979  34.163  78.638  1.00 36.00           O  
ATOM    259  CB  LEU A  32      34.119  37.274  79.535  1.00 31.38           C  
ATOM    260  CG  LEU A  32      33.235  38.490  79.868  1.00 35.47           C  
ATOM    261  CD1 LEU A  32      33.840  39.792  79.347  1.00 25.88           C  
ATOM    262  CD2 LEU A  32      31.755  38.297  79.294  1.00 33.35           C  
ATOM    263  N   ALA A  33      35.773  34.520  79.948  1.00 32.20           N  
ATOM    264  CA  ALA A  33      36.515  33.361  79.391  1.00 33.52           C  
ATOM    265  C   ALA A  33      35.791  32.063  79.719  1.00 33.23           C  
ATOM    266  O   ALA A  33      35.662  31.212  78.858  1.00 37.20           O  
ATOM    267  CB  ALA A  33      37.931  33.277  79.921  1.00 30.39           C  
ATOM    268  N   LYS A  34      35.354  31.933  80.978  1.00 33.78           N  
ATOM    269  CA  LYS A  34      34.643  30.759  81.455  0.50 34.54           C  
ATOM    271  C   LYS A  34      33.387  30.634  80.608  1.00 36.19           C  
ATOM    272  O   LYS A  34      33.081  29.578  80.067  1.00 39.36           O  
ATOM    273  CB  LYS A  34      34.238  30.902  82.941  0.50 32.58           C  
ATOM    275  CG  LYS A  34      35.356  30.682  83.948  0.50 35.90           C  
ATOM    277  CD  LYS A  34      35.010  31.095  85.418  0.50 33.86           C  
ATOM    279  CE  LYS A  34      36.187  30.807  86.351  0.50 28.46           C  
ATOM    281  NZ  LYS A  34      36.068  31.386  87.725  0.50 40.23           N  
ATOM    283  N   LEU A  35      32.673  31.740  80.503  1.00 37.24           N  
ATOM    284  CA  LEU A  35      31.408  31.761  79.797  1.00 40.61           C  
ATOM    285  C   LEU A  35      31.513  31.391  78.327  1.00 41.34           C  
ATOM    286  O   LEU A  35      30.696  30.596  77.842  1.00 43.84           O  
ATOM    287  CB  LEU A  35      30.765  33.127  79.953  1.00 39.22           C  
ATOM    288  CG  LEU A  35      29.352  33.390  79.494  1.00 43.60           C  
ATOM    289  CD1 LEU A  35      28.395  32.238  79.829  1.00 46.89           C  
ATOM    290  CD2 LEU A  35      28.923  34.691  80.167  1.00 41.39           C  
ATOM    291  N   TYR A  36      32.529  31.914  77.644  1.00 41.36           N  
ATOM    292  CA  TYR A  36      32.661  31.746  76.186  1.00 40.16           C  
ATOM    293  C   TYR A  36      33.708  30.741  75.718  1.00 41.82           C  
ATOM    294  O   TYR A  36      33.997  30.662  74.526  1.00 44.39           O  
ATOM    295  CB  TYR A  36      32.846  33.119  75.539  1.00 41.43           C  
ATOM    296  CG  TYR A  36      31.588  33.948  75.672  1.00 42.75           C  
ATOM    297  CD1 TYR A  36      30.447  33.624  74.937  1.00 49.04           C  
ATOM    298  CD2 TYR A  36      31.510  35.018  76.546  1.00 44.21           C  
ATOM    299  CE1 TYR A  36      29.274  34.360  75.067  1.00 42.10           C  
ATOM    300  CE2 TYR A  36      30.344  35.754  76.679  1.00 40.32           C  
ATOM    301  CZ  TYR A  36      29.233  35.418  75.939  1.00 46.16           C  
ATOM    302  OH  TYR A  36      28.072  36.144  76.051  1.00 46.72           O  
ATOM    303  N   GLY A  37      34.258  29.967  76.641  1.00 41.71           N  
ATOM    304  CA  GLY A  37      35.242  28.950  76.308  1.00 43.15           C  
ATOM    305  C   GLY A  37      36.603  29.435  75.847  1.00 43.30           C  
ATOM    306  O   GLY A  37      37.254  28.776  75.042  1.00 45.03           O  
ATOM    307  N   ALA A  38      37.045  30.577  76.362  1.00 41.15           N  
ATOM    308  CA  ALA A  38      38.385  31.066  76.089  1.00 39.21           C  
ATOM    309  C   ALA A  38      39.296  30.579  77.209  1.00 37.78           C  
ATOM    310  O   ALA A  38      38.829  30.075  78.252  1.00 37.66           O  
ATOM    311  CB  ALA A  38      38.402  32.548  76.017  1.00 36.85           C  
ATOM    312  N   ASP A  39      40.592  30.753  76.986  1.00 37.30           N  
ATOM    313  CA  ASP A  39      41.625  30.412  77.955  1.00 37.15           C  
ATOM    314  C   ASP A  39      41.601  31.417  79.110  1.00 36.70           C  
ATOM    315  O   ASP A  39      41.934  32.582  78.945  1.00 35.42           O  
ATOM    316  CB  ASP A  39      42.977  30.400  77.264  1.00 38.28           C  
ATOM    317  CG  ASP A  39      44.078  29.835  78.128  1.00 38.84           C  
ATOM    318  OD1 ASP A  39      44.197  30.196  79.310  1.00 33.72           O  
ATOM    319  OD2 ASP A  39      44.885  29.055  77.586  1.00 44.59           O  
ATOM    320  N   GLN A  40      41.201  30.952  80.285  1.00 35.31           N  
ATOM    321  CA  GLN A  40      41.032  31.837  81.426  1.00 35.43           C  
ATOM    322  C   GLN A  40      42.341  32.347  82.007  1.00 36.62           C  
ATOM    323  O   GLN A  40      42.329  33.386  82.645  1.00 32.26           O  
ATOM    324  CB  GLN A  40      40.269  31.140  82.540  1.00 36.93           C  
ATOM    325  CG  GLN A  40      38.874  30.761  82.221  1.00 35.09           C  
ATOM    326  CD  GLN A  40      38.347  29.799  83.235  1.00 39.01           C  
ATOM    327  OE1 GLN A  40      38.421  30.044  84.417  1.00 40.33           O  
ATOM    328  NE2 GLN A  40      37.788  28.709  82.777  1.00 40.56           N  
ATOM    329  N   GLN A  41      43.445  31.605  81.810  1.00 35.79           N  
ATOM    330  CA  GLN A  41      44.760  32.033  82.298  1.00 37.42           C  
ATOM    331  C   GLN A  41      45.282  33.139  81.405  1.00 34.52           C  
ATOM    332  O   GLN A  41      45.833  34.096  81.886  1.00 31.98           O  
ATOM    333  CB  GLN A  41      45.760  30.860  82.327  1.00 38.42           C  
ATOM    334  CG  GLN A  41      45.357  29.765  83.352  1.00 46.87           C  
ATOM    335  CD  GLN A  41      46.330  28.585  83.410  1.00 48.78           C  
ATOM    336  OE1 GLN A  41      47.512  28.706  83.047  1.00 57.92           O  
ATOM    337  NE2 GLN A  41      45.839  27.442  83.895  1.00 56.77           N  
ATOM    338  N   LYS A  42      45.139  32.986  80.095  1.00 31.82           N  
ATOM    339  CA  LYS A  42      45.535  34.069  79.170  1.00 32.53           C  
ATOM    340  C   LYS A  42      44.636  35.284  79.372  1.00 30.47           C  
ATOM    341  O   LYS A  42      45.130  36.409  79.340  1.00 34.91           O  
ATOM    342  CB  LYS A  42      45.522  33.617  77.715  1.00 34.30           C  
ATOM    343  CG  LYS A  42      46.473  32.457  77.385  1.00 35.78           C  
ATOM    344  CD  LYS A  42      46.447  32.215  75.917  1.00 35.78           C  
ATOM    345  CE  LYS A  42      47.409  31.125  75.475  1.00 43.75           C  
ATOM    346  NZ  LYS A  42      47.903  31.520  74.085  1.00 50.67           N  
ATOM    347  N   ALA A  43      43.326  35.067  79.573  1.00 31.80           N  
ATOM    348  CA  ALA A  43      42.392  36.163  79.910  1.00 30.11           C  
ATOM    349  C   ALA A  43      42.897  36.920  81.150  1.00 27.78           C  
ATOM    350  O   ALA A  43      43.036  38.153  81.161  1.00 30.09           O  
ATOM    351  CB  ALA A  43      40.928  35.651  80.114  1.00 28.39           C  
ATOM    352  N   GLU A  44      43.204  36.174  82.202  1.00 31.56           N  
ATOM    353  CA  GLU A  44      43.703  36.775  83.467  1.00 30.07           C  
ATOM    354  C   GLU A  44      44.953  37.616  83.292  1.00 30.00           C  
ATOM    355  O   GLU A  44      45.055  38.751  83.804  1.00 30.04           O  
ATOM    356  CB  GLU A  44      44.021  35.649  84.457  1.00 31.21           C  
ATOM    357  CG  GLU A  44      44.375  36.108  85.854  1.00 28.42           C  
ATOM    358  CD  GLU A  44      44.654  34.935  86.794  1.00 33.52           C  
ATOM    359  OE1 GLU A  44      45.527  34.121  86.502  1.00 44.40           O  
ATOM    360  OE2 GLU A  44      44.017  34.857  87.845  1.00 36.74           O  
ATOM    361  N   LEU A  45      45.918  37.033  82.585  1.00 28.72           N  
ATOM    362  CA  LEU A  45      47.216  37.678  82.362  1.00 29.46           C  
ATOM    363  C   LEU A  45      47.096  38.941  81.495  1.00 29.50           C  
ATOM    364  O   LEU A  45      47.643  40.004  81.843  1.00 27.88           O  
ATOM    365  CB  LEU A  45      48.204  36.683  81.708  1.00 30.49           C  
ATOM    366  CG  LEU A  45      49.643  37.163  81.559  1.00 30.20           C  
ATOM    367  CD1 LEU A  45      50.262  37.489  82.927  1.00 31.11           C  
ATOM    368  CD2 LEU A  45      50.484  36.108  80.806  1.00 29.91           C  
ATOM    369  N   ALA A  46      46.374  38.827  80.384  1.00 28.11           N  
ATOM    370  CA  ALA A  46      46.110  39.977  79.495  1.00 27.19           C  
ATOM    371  C   ALA A  46      45.389  41.096  80.222  1.00 28.69           C  
ATOM    372  O   ALA A  46      45.731  42.265  80.075  1.00 29.07           O  
ATOM    373  CB  ALA A  46      45.303  39.525  78.234  1.00 25.42           C  
ATOM    374  N   ALA A  47      44.415  40.722  81.044  1.00 29.92           N  
ATOM    375  CA  ALA A  47      43.688  41.693  81.898  1.00 29.80           C  
ATOM    376  C   ALA A  47      44.576  42.419  82.889  1.00 29.56           C  
ATOM    377  O   ALA A  47      44.535  43.647  82.964  1.00 29.27           O  
ATOM    378  CB  ALA A  47      42.552  41.050  82.603  1.00 29.97           C  
ATOM    379  N   ILE A  48      45.429  41.694  83.597  1.00 27.51           N  
ATOM    380  CA  ILE A  48      46.322  42.325  84.575  1.00 28.95           C  
ATOM    381  C   ILE A  48      47.227  43.343  83.886  1.00 29.98           C  
ATOM    382  O   ILE A  48      47.479  44.431  84.416  1.00 29.62           O  
ATOM    383  CB  ILE A  48      47.151  41.293  85.390  1.00 27.42           C  
ATOM    384  CG1 ILE A  48      46.212  40.459  86.296  1.00 29.74           C  
ATOM    385  CG2 ILE A  48      48.329  42.021  86.244  1.00 25.50           C  
ATOM    386  CD1 ILE A  48      46.804  39.134  86.872  1.00 27.71           C  
ATOM    387  N   PHE A  49      47.721  42.996  82.700  1.00 30.57           N  
ATOM    388  CA  PHE A  49      48.639  43.882  81.980  1.00 28.82           C  
ATOM    389  C   PHE A  49      48.052  44.796  80.939  1.00 29.76           C  
ATOM    390  O   PHE A  49      48.833  45.546  80.338  1.00 27.72           O  
ATOM    391  CB  PHE A  49      49.745  43.068  81.304  1.00 30.31           C  
ATOM    392  CG  PHE A  49      50.774  42.572  82.247  1.00 27.80           C  
ATOM    393  CD1 PHE A  49      51.741  43.427  82.730  1.00 28.50           C  
ATOM    394  CD2 PHE A  49      50.768  41.240  82.664  1.00 31.27           C  
ATOM    395  CE1 PHE A  49      52.689  42.971  83.647  1.00 33.17           C  
ATOM    396  CE2 PHE A  49      51.741  40.761  83.558  1.00 34.75           C  
ATOM    397  CZ  PHE A  49      52.681  41.629  84.047  1.00 32.33           C  
ATOM    398  N   HIS A  50      46.732  44.770  80.707  1.00 27.96           N  
ATOM    399  CA  HIS A  50      46.180  45.527  79.569  1.00 28.29           C  
ATOM    400  C   HIS A  50      46.548  47.037  79.560  1.00 27.35           C  
ATOM    401  O   HIS A  50      46.791  47.619  78.495  1.00 27.56           O  
ATOM    402  CB  HIS A  50      44.663  45.324  79.405  1.00 27.92           C  
ATOM    403  CG  HIS A  50      43.833  46.163  80.315  1.00 25.12           C  
ATOM    404  ND1 HIS A  50      43.695  45.887  81.658  1.00 30.13           N  
ATOM    405  CD2 HIS A  50      43.080  47.265  80.071  1.00 25.39           C  
ATOM    406  CE1 HIS A  50      42.915  46.810  82.212  1.00 29.44           C  
ATOM    407  NE2 HIS A  50      42.508  47.644  81.266  1.00 30.71           N  
ATOM    408  N   ASP A  51      46.620  47.628  80.740  1.00 25.63           N  
ATOM    409  CA  ASP A  51      46.927  49.060  80.902  1.00 28.79           C  
ATOM    410  C   ASP A  51      48.316  49.345  81.417  1.00 27.00           C  
ATOM    411  O   ASP A  51      48.579  50.444  81.932  1.00 26.97           O  
ATOM    412  CB  ASP A  51      45.899  49.747  81.807  1.00 28.72           C  
ATOM    413  CG  ASP A  51      44.606  50.119  81.075  1.00 32.95           C  
ATOM    414  OD1 ASP A  51      44.607  50.306  79.877  1.00 32.26           O  
ATOM    415  OD2 ASP A  51      43.575  50.226  81.724  1.00 31.75           O  
ATOM    416  N   TYR A  52      49.218  48.392  81.201  1.00 25.13           N  
ATOM    417  CA  TYR A  52      50.609  48.542  81.600  1.00 27.80           C  
ATOM    418  C   TYR A  52      51.248  49.892  81.230  1.00 29.15           C  
ATOM    419  O   TYR A  52      52.016  50.443  82.021  1.00 26.96           O  
ATOM    420  CB  TYR A  52      51.416  47.425  80.966  1.00 29.31           C  
ATOM    421  CG  TYR A  52      52.872  47.416  81.302  1.00 29.80           C  
ATOM    422  CD1 TYR A  52      53.323  46.956  82.552  1.00 32.21           C  
ATOM    423  CD2 TYR A  52      53.812  47.826  80.358  1.00 30.22           C  
ATOM    424  CE1 TYR A  52      54.704  46.891  82.835  1.00 34.51           C  
ATOM    425  CE2 TYR A  52      55.165  47.754  80.626  1.00 35.56           C  
ATOM    426  CZ  TYR A  52      55.611  47.268  81.852  1.00 33.98           C  
ATOM    427  OH  TYR A  52      56.979  47.265  82.060  1.00 34.56           O  
ATOM    428  N   ALA A  53      50.985  50.380  80.017  1.00 29.55           N  
ATOM    429  CA  ALA A  53      51.608  51.624  79.532  1.00 28.16           C  
ATOM    430  C   ALA A  53      50.740  52.892  79.721  1.00 29.46           C  
ATOM    431  O   ALA A  53      51.092  53.960  79.256  1.00 31.55           O  
ATOM    432  CB  ALA A  53      51.990  51.457  78.042  1.00 30.38           C  
ATOM    433  N   LYS A  54      49.618  52.792  80.434  1.00 28.73           N  
ATOM    434  CA  LYS A  54      48.690  53.923  80.567  1.00 28.43           C  
ATOM    435  C   LYS A  54      49.413  55.199  81.016  1.00 28.42           C  
ATOM    436  O   LYS A  54      49.175  56.264  80.485  1.00 30.17           O  
ATOM    437  CB  LYS A  54      47.580  53.539  81.552  1.00 30.11           C  
ATOM    438  CG  LYS A  54      46.550  54.573  81.864  1.00 37.54           C  
ATOM    439  CD  LYS A  54      45.459  54.667  80.868  1.00 38.88           C  
ATOM    440  CE  LYS A  54      44.468  55.717  81.362  1.00 41.47           C  
ATOM    441  NZ  LYS A  54      43.382  55.722  80.376  1.00 40.45           N  
ATOM    442  N   PHE A  55      50.302  55.078  81.969  1.00 30.47           N  
ATOM    443  CA  PHE A  55      50.921  56.258  82.577  1.00 30.27           C  
ATOM    444  C   PHE A  55      52.336  56.420  82.172  1.00 33.45           C  
ATOM    445  O   PHE A  55      53.085  57.082  82.860  1.00 33.67           O  
ATOM    446  CB  PHE A  55      50.758  56.190  84.098  1.00 34.22           C  
ATOM    447  CG  PHE A  55      49.330  56.002  84.492  1.00 27.35           C  
ATOM    448  CD1 PHE A  55      48.384  56.966  84.155  1.00 28.32           C  
ATOM    449  CD2 PHE A  55      48.921  54.856  85.119  1.00 37.24           C  
ATOM    450  CE1 PHE A  55      47.053  56.781  84.450  1.00 30.63           C  
ATOM    451  CE2 PHE A  55      47.607  54.660  85.401  1.00 30.82           C  
ATOM    452  CZ  PHE A  55      46.667  55.621  85.062  1.00 34.26           C  
ATOM    453  N   ARG A  56      52.712  55.803  81.061  1.00 34.16           N  
ATOM    454  CA  ARG A  56      54.045  55.994  80.520  1.00 33.21           C  
ATOM    455  C   ARG A  56      54.134  57.316  79.812  1.00 33.50           C  
ATOM    456  O   ARG A  56      53.147  57.892  79.465  1.00 34.08           O  
ATOM    457  CB  ARG A  56      54.410  54.861  79.572  1.00 28.55           C  
ATOM    458  CG  ARG A  56      54.608  53.559  80.271  1.00 36.16           C  
ATOM    459  CD  ARG A  56      55.916  53.520  81.050  1.00 37.23           C  
ATOM    460  NE  ARG A  56      57.035  53.242  80.150  1.00 37.57           N  
ATOM    461  CZ  ARG A  56      57.543  52.040  79.896  1.00 33.09           C  
ATOM    462  NH1 ARG A  56      57.093  50.939  80.476  1.00 32.80           N  
ATOM    463  NH2 ARG A  56      58.537  51.956  79.056  1.00 32.04           N  
ATOM    464  N   ASP A  57      55.352  57.785  79.609  1.00 35.60           N  
ATOM    465  CA  ASP A  57      55.596  59.071  78.978  1.00 39.60           C  
ATOM    466  C   ASP A  57      55.005  59.089  77.571  1.00 38.74           C  
ATOM    467  O   ASP A  57      55.404  58.290  76.710  1.00 36.65           O  
ATOM    468  CB  ASP A  57      57.106  59.323  78.894  1.00 42.13           C  
ATOM    469  CG  ASP A  57      57.441  60.702  78.328  1.00 51.29           C  
ATOM    470  OD1 ASP A  57      57.368  61.683  79.092  1.00 62.30           O  
ATOM    471  OD2 ASP A  57      57.696  60.799  77.113  1.00 54.19           O  
ATOM    472  N   LYS A  58      54.088  60.024  77.331  1.00 38.51           N  
ATOM    473  CA  LYS A  58      53.428  60.125  76.032  1.00 39.11           C  
ATOM    474  C   LYS A  58      54.364  60.455  74.853  1.00 38.60           C  
ATOM    475  O   LYS A  58      54.158  59.954  73.759  1.00 40.61           O  
ATOM    476  CB  LYS A  58      52.203  61.046  76.113  1.00 37.77           C  
ATOM    477  CG  LYS A  58      50.987  60.338  76.799  1.00 38.40           C  
ATOM    478  CD  LYS A  58      49.738  61.197  76.811  1.00 41.28           C  
ATOM    479  CE  LYS A  58      48.594  60.568  77.631  1.00 40.23           C  
ATOM    480  NZ  LYS A  58      48.910  60.487  79.119  1.00 41.89           N  
ATOM    481  N   ASN A  59      55.408  61.237  75.072  1.00 39.79           N  
ATOM    482  CA  ASN A  59      56.366  61.515  73.978  1.00 40.41           C  
ATOM    483  C   ASN A  59      57.179  60.292  73.565  1.00 39.86           C  
ATOM    484  O   ASN A  59      57.375  60.029  72.380  1.00 39.77           O  
ATOM    485  CB  ASN A  59      57.314  62.677  74.338  1.00 45.60           C  
ATOM    486  CG  ASN A  59      56.711  64.044  74.034  1.00 53.16           C  
ATOM    487  OD1 ASN A  59      56.049  64.238  72.997  1.00 59.79           O  
ATOM    488  ND2 ASN A  59      56.950  65.004  74.928  1.00 62.04           N  
ATOM    489  N   GLU A  60      57.661  59.544  74.547  1.00 42.28           N  
ATOM    490  CA  GLU A  60      58.328  58.254  74.282  1.00 42.67           C  
ATOM    491  C   GLU A  60      57.402  57.320  73.513  1.00 37.92           C  
ATOM    492  O   GLU A  60      57.839  56.619  72.609  1.00 37.66           O  
ATOM    493  CB  GLU A  60      58.720  57.579  75.591  1.00 42.78           C  
ATOM    494  CG  GLU A  60      59.836  58.316  76.326  1.00 50.92           C  
ATOM    495  CD  GLU A  60      60.164  57.725  77.706  1.00 51.57           C  
ATOM    496  OE1 GLU A  60      59.582  56.679  78.111  1.00 61.88           O  
ATOM    497  OE2 GLU A  60      61.028  58.330  78.384  1.00 62.54           O  
HETATM  498  N   MSE A  61      56.117  57.318  73.875  1.00 35.08           N  
HETATM  499  CA  MSE A  61      55.159  56.450  73.207  1.00 34.03           C  
HETATM  500  C   MSE A  61      54.933  56.866  71.751  1.00 33.51           C  
HETATM  501  O   MSE A  61      54.940  56.036  70.860  1.00 36.32           O  
HETATM  502  CB  MSE A  61      53.852  56.382  73.993  1.00 34.53           C  
HETATM  503  CG  MSE A  61      53.988  55.520  75.286  1.00 31.49           C  
HETATM  504 SE   MSE A  61      52.387  54.847  76.012  0.75 31.04          SE  
HETATM  505  CE  MSE A  61      51.642  56.401  76.729  1.00 34.49           C  
ATOM    506  N   ARG A  62      54.772  58.155  71.513  1.00 34.54           N  
ATOM    507  CA  ARG A  62      54.653  58.669  70.145  1.00 36.05           C  
ATOM    508  C   ARG A  62      55.861  58.319  69.307  1.00 36.70           C  
ATOM    509  O   ARG A  62      55.724  57.966  68.136  1.00 38.09           O  
ATOM    510  CB  ARG A  62      54.426  60.178  70.170  1.00 36.92           C  
ATOM    511  CG  ARG A  62      53.056  60.549  70.773  1.00 41.45           C  
ATOM    512  CD  ARG A  62      52.782  62.028  70.651  1.00 41.95           C  
ATOM    513  NE  ARG A  62      51.768  62.527  71.588  1.00 47.00           N  
ATOM    514  CZ  ARG A  62      52.030  63.163  72.739  1.00 51.31           C  
ATOM    515  NH1 ARG A  62      53.268  63.381  73.155  1.00 56.43           N  
ATOM    516  NH2 ARG A  62      51.038  63.592  73.499  1.00 56.12           N  
ATOM    517  N   THR A  63      57.043  58.413  69.918  1.00 37.64           N  
ATOM    518  CA  THR A  63      58.298  58.056  69.255  1.00 37.71           C  
ATOM    519  C   THR A  63      58.365  56.573  68.953  1.00 39.09           C  
ATOM    520  O   THR A  63      58.795  56.196  67.869  1.00 41.05           O  
ATOM    521  CB  THR A  63      59.487  58.454  70.117  1.00 39.41           C  
ATOM    522  OG1 THR A  63      59.450  59.877  70.336  1.00 42.00           O  
ATOM    523  CG2 THR A  63      60.808  58.035  69.467  1.00 39.51           C  
ATOM    524  N   LEU A  64      57.915  55.735  69.889  1.00 34.23           N  
ATOM    525  CA  LEU A  64      57.867  54.291  69.687  1.00 35.21           C  
ATOM    526  C   LEU A  64      56.947  53.947  68.517  1.00 37.59           C  
ATOM    527  O   LEU A  64      57.263  53.085  67.687  1.00 37.64           O  
ATOM    528  CB  LEU A  64      57.335  53.568  70.949  1.00 36.12           C  
ATOM    529  CG  LEU A  64      57.304  52.036  70.915  1.00 36.22           C  
ATOM    530  CD1 LEU A  64      58.730  51.503  70.887  1.00 33.61           C  
ATOM    531  CD2 LEU A  64      56.538  51.455  72.100  1.00 34.62           C  
ATOM    532  N   ILE A  65      55.785  54.583  68.472  1.00 39.40           N  
ATOM    533  CA  ILE A  65      54.854  54.378  67.352  1.00 42.63           C  
ATOM    534  C   ILE A  65      55.576  54.723  66.043  1.00 45.53           C  
ATOM    535  O   ILE A  65      55.625  53.898  65.135  1.00 47.73           O  
ATOM    536  CB  ILE A  65      53.549  55.175  67.563  1.00 42.26           C  
ATOM    537  CG1 ILE A  65      52.663  54.417  68.558  1.00 41.93           C  
ATOM    538  CG2 ILE A  65      52.817  55.387  66.246  1.00 43.53           C  
ATOM    539  CD1 ILE A  65      51.749  55.273  69.314  1.00 44.09           C  
ATOM    540  N   ARG A  66      56.189  55.901  65.991  1.00 49.51           N  
ATOM    541  CA  ARG A  66      56.978  56.328  64.824  1.00 52.80           C  
ATOM    542  C   ARG A  66      58.147  55.414  64.444  1.00 54.34           C  
ATOM    543  O   ARG A  66      58.253  54.974  63.292  1.00 55.57           O  
ATOM    544  CB  ARG A  66      57.519  57.751  65.019  1.00 53.45           C  
ATOM    545  CG  ARG A  66      56.471  58.827  64.812  1.00 59.21           C  
ATOM    546  CD  ARG A  66      57.065  60.225  64.687  1.00 58.54           C  
ATOM    547  NE  ARG A  66      57.262  60.857  65.995  1.00 67.10           N  
ATOM    548  CZ  ARG A  66      56.312  61.470  66.710  1.00 65.72           C  
ATOM    549  NH1 ARG A  66      55.044  61.530  66.291  1.00 71.67           N  
ATOM    550  NH2 ARG A  66      56.631  62.020  67.877  1.00 64.92           N  
ATOM    551  N   GLU A  67      59.021  55.136  65.402  1.00 55.39           N  
ATOM    552  CA  GLU A  67      60.251  54.392  65.124  1.00 57.19           C  
ATOM    553  C   GLU A  67      60.052  52.893  64.989  1.00 57.04           C  
ATOM    554  O   GLU A  67      60.492  52.306  64.012  1.00 57.59           O  
ATOM    555  CB  GLU A  67      61.300  54.655  66.205  1.00 57.68           C  
ATOM    556  CG  GLU A  67      61.829  56.082  66.205  1.00 59.24           C  
ATOM    557  CD  GLU A  67      62.838  56.371  67.333  1.00 60.90           C  
ATOM    558  OE1 GLU A  67      62.980  55.569  68.303  1.00 60.69           O  
ATOM    559  OE2 GLU A  67      63.489  57.440  67.243  1.00 69.79           O  
ATOM    560  N   LYS A  68      59.390  52.276  65.964  1.00 56.86           N  
ATOM    561  CA  LYS A  68      59.325  50.813  66.027  1.00 56.02           C  
ATOM    562  C   LYS A  68      58.047  50.151  65.546  1.00 54.99           C  
ATOM    563  O   LYS A  68      58.115  48.997  65.169  1.00 55.81           O  
ATOM    564  CB  LYS A  68      59.673  50.301  67.449  1.00 54.81           C  
ATOM    565  CG  LYS A  68      61.174  50.289  67.755  1.00 53.40           C  
ATOM    566  N   LEU A  69      56.899  50.833  65.546  1.00 56.44           N  
ATOM    567  CA  LEU A  69      55.611  50.145  65.275  1.00 57.43           C  
ATOM    568  C   LEU A  69      55.026  50.385  63.867  1.00 59.40           C  
ATOM    569  O   LEU A  69      55.459  51.286  63.137  1.00 58.41           O  
ATOM    570  CB  LEU A  69      54.580  50.453  66.384  1.00 53.32           C  
ATOM    571  CG  LEU A  69      54.947  50.042  67.834  1.00 52.86           C  
ATOM    572  CD1 LEU A  69      53.811  50.354  68.791  1.00 40.03           C  
ATOM    573  CD2 LEU A  69      55.327  48.557  67.973  1.00 42.61           C  
ATOM    574  N   SER A  70      54.049  49.540  63.513  1.00 63.29           N  
ATOM    575  CA  SER A  70      53.378  49.541  62.186  1.00 66.05           C  
ATOM    576  C   SER A  70      52.404  50.726  61.938  1.00 68.78           C  
ATOM    577  O   SER A  70      52.662  51.564  61.064  1.00 69.77           O  
ATOM    578  CB  SER A  70      52.630  48.208  61.964  1.00 65.56           C  
ATOM    579  N   GLN A  71      51.311  50.789  62.713  1.00 70.37           N  
ATOM    580  CA  GLN A  71      50.239  51.804  62.526  1.00 69.62           C  
ATOM    581  C   GLN A  71      50.592  53.260  62.969  1.00 70.13           C  
ATOM    582  O   GLN A  71      50.431  53.625  64.134  1.00 72.62           O  
ATOM    583  CB  GLN A  71      48.949  51.326  63.231  1.00 69.47           C  
ATOM    584  N   GLN A  72      51.027  54.093  62.026  1.00 68.08           N  
ATOM    585  CA  GLN A  72      51.396  55.498  62.315  1.00 67.06           C  
ATOM    586  C   GLN A  72      50.177  56.421  62.409  1.00 62.88           C  
ATOM    587  O   GLN A  72      50.226  57.472  63.064  1.00 60.26           O  
ATOM    588  CB  GLN A  72      52.327  56.071  61.216  1.00 68.52           C  
ATOM    589  CG  GLN A  72      53.483  55.163  60.785  1.00 71.61           C  
ATOM    590  CD  GLN A  72      54.268  54.670  61.964  1.00 73.96           C  
ATOM    591  OE1 GLN A  72      54.769  55.475  62.738  1.00 76.13           O  
ATOM    592  NE2 GLN A  72      54.354  53.348  62.131  1.00 70.00           N  
ATOM    593  N   ASP A  73      49.096  56.035  61.729  1.00 60.25           N  
ATOM    594  CA  ASP A  73      47.895  56.871  61.653  1.00 58.15           C  
ATOM    595  C   ASP A  73      47.248  57.076  63.023  1.00 53.44           C  
ATOM    596  O   ASP A  73      46.550  58.053  63.223  1.00 52.66           O  
ATOM    597  CB  ASP A  73      46.881  56.360  60.579  1.00 59.21           C  
ATOM    598  CG  ASP A  73      45.972  55.212  61.069  1.00 62.99           C  
ATOM    599  OD1 ASP A  73      46.435  54.316  61.825  1.00 72.52           O  
ATOM    600  OD2 ASP A  73      44.781  55.211  60.660  1.00 62.82           O  
ATOM    601  N   ILE A  74      47.535  56.177  63.966  1.00 49.34           N  
ATOM    602  CA  ILE A  74      46.994  56.251  65.315  1.00 47.03           C  
ATOM    603  C   ILE A  74      47.329  57.586  65.964  1.00 42.50           C  
ATOM    604  O   ILE A  74      46.557  58.081  66.758  1.00 40.74           O  
ATOM    605  CB  ILE A  74      47.505  55.058  66.186  1.00 48.00           C  
ATOM    606  CG1 ILE A  74      46.357  54.295  66.831  1.00 51.09           C  
ATOM    607  CG2 ILE A  74      48.512  55.489  67.241  1.00 50.89           C  
ATOM    608  CD1 ILE A  74      46.780  52.915  67.309  1.00 51.05           C  
ATOM    609  N   LEU A  75      48.475  58.172  65.615  1.00 39.48           N  
ATOM    610  CA  LEU A  75      48.918  59.454  66.182  1.00 41.50           C  
ATOM    611  C   LEU A  75      48.043  60.658  65.855  1.00 43.36           C  
ATOM    612  O   LEU A  75      48.232  61.722  66.432  1.00 45.97           O  
ATOM    613  CB  LEU A  75      50.362  59.768  65.734  1.00 41.27           C  
ATOM    614  CG  LEU A  75      51.480  58.797  66.127  1.00 43.22           C  
ATOM    615  CD1 LEU A  75      52.792  59.213  65.472  1.00 39.93           C  
ATOM    616  CD2 LEU A  75      51.651  58.749  67.646  1.00 42.14           C  
ATOM    617  N   PHE A  76      47.113  60.511  64.920  1.00 45.04           N  
ATOM    618  CA  PHE A  76      46.169  61.578  64.553  1.00 46.92           C  
ATOM    619  C   PHE A  76      44.857  61.560  65.335  1.00 45.35           C  
ATOM    620  O   PHE A  76      44.116  62.537  65.290  1.00 43.68           O  
ATOM    621  CB  PHE A  76      45.895  61.517  63.032  1.00 50.90           C  
ATOM    622  CG  PHE A  76      47.076  61.989  62.191  1.00 52.91           C  
ATOM    623  CD1 PHE A  76      48.178  61.150  61.980  1.00 59.72           C  
ATOM    624  CD2 PHE A  76      47.107  63.289  61.669  1.00 57.69           C  
ATOM    625  CE1 PHE A  76      49.293  61.594  61.243  1.00 62.75           C  
ATOM    626  CE2 PHE A  76      48.204  63.741  60.925  1.00 60.15           C  
ATOM    627  CZ  PHE A  76      49.301  62.890  60.710  1.00 58.23           C  
ATOM    628  N   TYR A  77      44.599  60.497  66.098  1.00 43.09           N  
ATOM    629  CA  TYR A  77      43.287  60.286  66.718  1.00 43.31           C  
ATOM    630  C   TYR A  77      43.205  60.268  68.257  1.00 44.25           C  
ATOM    631  O   TYR A  77      42.283  59.679  68.815  1.00 47.66           O  
ATOM    632  CB  TYR A  77      42.703  58.998  66.154  1.00 42.70           C  
ATOM    633  CG  TYR A  77      42.536  59.036  64.666  1.00 39.16           C  
ATOM    634  CD1 TYR A  77      41.396  59.574  64.092  1.00 39.34           C  
ATOM    635  CD2 TYR A  77      43.524  58.546  63.821  1.00 43.82           C  
ATOM    636  CE1 TYR A  77      41.234  59.621  62.712  1.00 39.92           C  
ATOM    637  CE2 TYR A  77      43.377  58.582  62.432  1.00 44.04           C  
ATOM    638  CZ  TYR A  77      42.222  59.122  61.884  1.00 44.78           C  
ATOM    639  OH  TYR A  77      42.052  59.165  60.522  1.00 44.28           O  
ATOM    640  N   GLY A  78      44.138  60.906  68.943  1.00 42.25           N  
ATOM    641  CA  GLY A  78      44.015  61.094  70.398  1.00 43.13           C  
ATOM    642  C   GLY A  78      44.984  60.294  71.246  1.00 39.11           C  
ATOM    643  O   GLY A  78      45.230  59.129  70.984  1.00 38.80           O  
ATOM    644  N   ASP A  79      45.507  60.938  72.282  1.00 37.27           N  
ATOM    645  CA  ASP A  79      46.502  60.338  73.164  1.00 38.56           C  
ATOM    646  C   ASP A  79      46.080  59.035  73.842  1.00 36.89           C  
ATOM    647  O   ASP A  79      46.948  58.236  74.229  1.00 35.89           O  
ATOM    648  CB  ASP A  79      46.928  61.348  74.233  1.00 42.83           C  
ATOM    649  CG  ASP A  79      47.881  62.407  73.706  1.00 46.31           C  
ATOM    650  OD1 ASP A  79      48.439  62.291  72.575  1.00 55.77           O  
ATOM    651  OD2 ASP A  79      48.118  63.365  74.473  1.00 63.86           O  
ATOM    652  N   GLU A  80      44.769  58.801  73.939  1.00 34.03           N  
ATOM    653  CA  GLU A  80      44.239  57.592  74.571  1.00 33.72           C  
ATOM    654  C   GLU A  80      44.553  56.321  73.785  1.00 32.80           C  
ATOM    655  O   GLU A  80      44.529  55.239  74.357  1.00 34.85           O  
ATOM    656  CB  GLU A  80      42.716  57.715  74.823  1.00 37.54           C  
ATOM    657  N   LEU A  81      44.878  56.450  72.494  1.00 32.22           N  
ATOM    658  CA  LEU A  81      45.145  55.288  71.634  1.00 30.30           C  
ATOM    659  C   LEU A  81      46.586  54.794  71.698  1.00 31.20           C  
ATOM    660  O   LEU A  81      46.912  53.770  71.092  1.00 30.20           O  
ATOM    661  CB  LEU A  81      44.796  55.608  70.190  1.00 29.03           C  
ATOM    662  CG  LEU A  81      43.392  56.137  69.867  1.00 30.05           C  
ATOM    663  CD1 LEU A  81      43.172  56.110  68.350  1.00 36.67           C  
ATOM    664  CD2 LEU A  81      42.296  55.382  70.578  1.00 39.12           C  
ATOM    665  N   LEU A  82      47.435  55.506  72.443  1.00 32.18           N  
ATOM    666  CA  LEU A  82      48.844  55.175  72.546  1.00 31.41           C  
ATOM    667  C   LEU A  82      49.125  53.954  73.420  1.00 30.50           C  
ATOM    668  O   LEU A  82      49.923  53.121  73.062  1.00 29.26           O  
ATOM    669  CB  LEU A  82      49.624  56.363  73.137  1.00 30.36           C  
ATOM    670  CG  LEU A  82      49.688  57.682  72.345  1.00 32.73           C  
ATOM    671  CD1 LEU A  82      50.291  58.843  73.199  1.00 33.49           C  
ATOM    672  CD2 LEU A  82      50.497  57.502  71.077  1.00 32.47           C  
ATOM    673  N   HIS A  83      48.476  53.871  74.570  1.00 29.45           N  
ATOM    674  CA  HIS A  83      48.905  52.929  75.585  1.00 30.11           C  
ATOM    675  C   HIS A  83      48.663  51.466  75.266  1.00 29.15           C  
ATOM    676  O   HIS A  83      49.406  50.627  75.755  1.00 29.32           O  
ATOM    677  CB  HIS A  83      48.328  53.295  76.970  1.00 30.64           C  
ATOM    678  CG  HIS A  83      46.866  53.029  77.119  1.00 29.75           C  
ATOM    679  ND1 HIS A  83      45.895  53.920  76.716  1.00 29.04           N  
ATOM    680  CD2 HIS A  83      46.213  52.008  77.714  1.00 38.54           C  
ATOM    681  CE1 HIS A  83      44.706  53.424  77.000  1.00 36.88           C  
ATOM    682  NE2 HIS A  83      44.872  52.269  77.616  1.00 37.37           N  
ATOM    683  N   ALA A  84      47.652  51.154  74.452  1.00 28.00           N  
ATOM    684  CA  ALA A  84      47.394  49.748  74.087  1.00 28.20           C  
ATOM    685  C   ALA A  84      48.520  49.132  73.229  1.00 30.94           C  
ATOM    686  O   ALA A  84      49.095  48.114  73.623  1.00 29.71           O  
ATOM    687  CB  ALA A  84      45.977  49.579  73.388  1.00 27.51           C  
ATOM    688  N   PRO A  85      48.807  49.709  72.038  1.00 29.48           N  
ATOM    689  CA  PRO A  85      49.878  49.161  71.220  1.00 30.53           C  
ATOM    690  C   PRO A  85      51.266  49.277  71.860  1.00 31.19           C  
ATOM    691  O   PRO A  85      52.082  48.386  71.694  1.00 32.18           O  
ATOM    692  CB  PRO A  85      49.784  49.971  69.930  1.00 31.53           C  
ATOM    693  CG  PRO A  85      49.076  51.234  70.291  1.00 31.49           C  
ATOM    694  CD  PRO A  85      48.121  50.827  71.357  1.00 33.58           C  
ATOM    695  N   CYS A  86      51.520  50.361  72.582  1.00 29.41           N  
ATOM    696  CA  CYS A  86      52.811  50.561  73.233  1.00 31.45           C  
ATOM    697  C   CYS A  86      52.941  49.629  74.419  1.00 31.80           C  
ATOM    698  O   CYS A  86      54.006  49.042  74.642  1.00 31.81           O  
ATOM    699  CB  CYS A  86      53.019  52.032  73.657  1.00 30.67           C  
ATOM    700  SG  CYS A  86      53.119  53.187  72.226  1.00 32.14           S  
ATOM    701  N   GLY A  87      51.855  49.487  75.166  1.00 30.36           N  
ATOM    702  CA  GLY A  87      51.770  48.503  76.254  1.00 29.12           C  
ATOM    703  C   GLY A  87      52.043  47.090  75.761  1.00 30.69           C  
ATOM    704  O   GLY A  87      52.781  46.347  76.394  1.00 33.17           O  
ATOM    705  N   ALA A  88      51.463  46.702  74.625  1.00 27.56           N  
ATOM    706  CA  ALA A  88      51.753  45.372  74.075  1.00 27.65           C  
ATOM    707  C   ALA A  88      53.260  45.264  73.797  1.00 28.60           C  
ATOM    708  O   ALA A  88      53.895  44.235  74.107  1.00 29.11           O  
ATOM    709  CB  ALA A  88      50.909  45.102  72.819  1.00 25.98           C  
ATOM    710  N   TYR A  89      53.848  46.335  73.266  1.00 31.73           N  
ATOM    711  CA  TYR A  89      55.273  46.357  72.972  1.00 31.59           C  
ATOM    712  C   TYR A  89      56.104  46.245  74.270  1.00 31.85           C  
ATOM    713  O   TYR A  89      57.005  45.405  74.387  1.00 31.67           O  
ATOM    714  CB  TYR A  89      55.669  47.618  72.193  1.00 32.79           C  
ATOM    715  CG  TYR A  89      57.162  47.674  71.855  1.00 30.82           C  
ATOM    716  CD1 TYR A  89      57.649  47.086  70.700  1.00 42.83           C  
ATOM    717  CD2 TYR A  89      58.072  48.288  72.715  1.00 32.98           C  
ATOM    718  CE1 TYR A  89      59.014  47.116  70.393  1.00 37.77           C  
ATOM    719  CE2 TYR A  89      59.410  48.308  72.436  1.00 36.79           C  
ATOM    720  CZ  TYR A  89      59.879  47.724  71.262  1.00 40.04           C  
ATOM    721  OH  TYR A  89      61.218  47.759  70.963  1.00 43.90           O  
ATOM    722  N   TYR A  90      55.774  47.075  75.247  1.00 34.08           N  
ATOM    723  CA  TYR A  90      56.549  47.108  76.489  1.00 32.32           C  
ATOM    724  C   TYR A  90      56.458  45.833  77.303  1.00 34.31           C  
ATOM    725  O   TYR A  90      57.455  45.386  77.835  1.00 35.50           O  
ATOM    726  CB  TYR A  90      56.175  48.314  77.332  1.00 32.75           C  
ATOM    727  CG  TYR A  90      56.492  49.671  76.724  1.00 32.73           C  
ATOM    728  CD1 TYR A  90      57.677  49.896  76.006  1.00 32.39           C  
ATOM    729  CD2 TYR A  90      55.670  50.776  76.976  1.00 31.68           C  
ATOM    730  CE1 TYR A  90      57.979  51.136  75.504  1.00 29.23           C  
ATOM    731  CE2 TYR A  90      55.980  52.041  76.495  1.00 30.83           C  
ATOM    732  CZ  TYR A  90      57.132  52.215  75.751  1.00 33.64           C  
ATOM    733  OH  TYR A  90      57.464  53.454  75.253  1.00 37.88           O  
ATOM    734  N   VAL A  91      55.264  45.261  77.407  1.00 32.52           N  
ATOM    735  CA  VAL A  91      55.061  43.983  78.089  1.00 34.49           C  
ATOM    736  C   VAL A  91      55.962  42.877  77.474  1.00 35.01           C  
ATOM    737  O   VAL A  91      56.573  42.103  78.205  1.00 33.36           O  
ATOM    738  CB  VAL A  91      53.576  43.597  78.104  1.00 31.38           C  
ATOM    739  CG1 VAL A  91      53.334  42.188  78.680  1.00 37.12           C  
ATOM    740  CG2 VAL A  91      52.791  44.625  78.940  1.00 30.26           C  
ATOM    741  N   ARG A  92      56.066  42.816  76.147  1.00 34.32           N  
ATOM    742  CA  ARG A  92      56.940  41.814  75.513  0.50 33.86           C  
ATOM    744  C   ARG A  92      58.401  42.111  75.811  1.00 33.64           C  
ATOM    745  O   ARG A  92      59.118  41.230  76.237  1.00 35.76           O  
ATOM    746  CB  ARG A  92      56.734  41.692  74.000  0.50 34.06           C  
ATOM    748  CG  ARG A  92      57.557  40.552  73.378  0.50 32.21           C  
ATOM    750  CD  ARG A  92      57.436  40.462  71.868  0.50 34.79           C  
ATOM    752  NE  ARG A  92      58.713  40.066  71.261  0.50 43.41           N  
ATOM    754  CZ  ARG A  92      59.186  38.824  71.135  0.50 44.40           C  
ATOM    756  NH1 ARG A  92      58.508  37.763  71.569  0.50 47.44           N  
ATOM    758  NH2 ARG A  92      60.370  38.642  70.566  0.50 44.89           N  
ATOM    760  N   GLU A  93      58.815  43.354  75.608  1.00 33.91           N  
ATOM    761  CA  GLU A  93      60.208  43.749  75.771  1.00 35.52           C  
ATOM    762  C   GLU A  93      60.693  43.825  77.187  1.00 33.18           C  
ATOM    763  O   GLU A  93      61.842  43.489  77.441  1.00 33.91           O  
ATOM    764  CB  GLU A  93      60.495  45.096  75.087  1.00 38.12           C  
ATOM    765  CG  GLU A  93      60.276  45.062  73.591  1.00 46.68           C  
ATOM    766  CD  GLU A  93      61.120  44.004  72.859  1.00 53.04           C  
ATOM    767  OE1 GLU A  93      62.343  43.951  73.128  1.00 52.28           O  
ATOM    768  OE2 GLU A  93      60.559  43.256  72.020  1.00 48.67           O  
ATOM    769  N   GLU A  94      59.841  44.244  78.108  1.00 31.28           N  
ATOM    770  CA  GLU A  94      60.255  44.491  79.473  1.00 30.39           C  
ATOM    771  C   GLU A  94      59.910  43.369  80.388  1.00 32.57           C  
ATOM    772  O   GLU A  94      60.727  42.997  81.234  1.00 32.69           O  
ATOM    773  CB  GLU A  94      59.643  45.783  80.004  1.00 31.49           C  
ATOM    774  CG  GLU A  94      60.054  46.975  79.201  1.00 35.05           C  
ATOM    775  CD  GLU A  94      59.351  48.256  79.535  1.00 33.68           C  
ATOM    776  OE1 GLU A  94      58.469  48.346  80.441  1.00 29.11           O  
ATOM    777  OE2 GLU A  94      59.685  49.198  78.824  1.00 37.17           O  
ATOM    778  N   VAL A  95      58.689  42.864  80.267  1.00 30.44           N  
ATOM    779  CA  VAL A  95      58.224  41.768  81.112  1.00 32.26           C  
ATOM    780  C   VAL A  95      58.576  40.396  80.513  1.00 32.03           C  
ATOM    781  O   VAL A  95      58.703  39.440  81.243  1.00 31.58           O  
ATOM    782  CB  VAL A  95      56.721  41.905  81.459  1.00 32.78           C  
ATOM    783  CG1 VAL A  95      56.291  40.838  82.438  1.00 34.53           C  
ATOM    784  CG2 VAL A  95      56.435  43.298  81.985  1.00 29.56           C  
ATOM    785  N   GLY A  96      58.812  40.330  79.207  1.00 31.32           N  
ATOM    786  CA  GLY A  96      59.193  39.082  78.574  1.00 33.08           C  
ATOM    787  C   GLY A  96      58.046  38.170  78.185  1.00 32.56           C  
ATOM    788  O   GLY A  96      58.260  37.007  77.858  1.00 35.03           O  
ATOM    789  N   ILE A  97      56.832  38.694  78.154  1.00 35.67           N  
ATOM    790  CA  ILE A  97      55.671  37.911  77.742  1.00 32.37           C  
ATOM    791  C   ILE A  97      55.663  37.866  76.235  1.00 32.75           C  
ATOM    792  O   ILE A  97      55.569  38.878  75.604  1.00 32.44           O  
ATOM    793  CB  ILE A  97      54.389  38.509  78.306  1.00 33.83           C  
ATOM    794  CG1 ILE A  97      54.376  38.317  79.826  1.00 36.03           C  
ATOM    795  CG2 ILE A  97      53.113  37.807  77.727  1.00 31.60           C  
ATOM    796  CD1 ILE A  97      53.349  39.175  80.518  1.00 44.80           C  
ATOM    797  N   GLU A  98      55.773  36.673  75.652  1.00 33.97           N  
ATOM    798  CA  GLU A  98      55.781  36.503  74.203  1.00 38.57           C  
ATOM    799  C   GLU A  98      54.524  35.794  73.674  1.00 38.99           C  
ATOM    800  O   GLU A  98      54.479  35.433  72.501  1.00 42.81           O  
ATOM    801  CB  GLU A  98      57.036  35.718  73.782  1.00 37.90           C  
ATOM    802  CG  GLU A  98      58.342  36.240  74.346  1.00 41.86           C  
ATOM    803  CD  GLU A  98      59.569  35.480  73.834  1.00 47.97           C  
ATOM    804  OE1 GLU A  98      59.439  34.653  72.905  1.00 59.88           O  
ATOM    805  OE2 GLU A  98      60.677  35.719  74.366  1.00 64.10           O  
ATOM    806  N   ASP A  99      53.517  35.571  74.520  1.00 37.58           N  
ATOM    807  CA  ASP A  99      52.292  34.922  74.090  1.00 35.68           C  
ATOM    808  C   ASP A  99      51.558  35.911  73.195  1.00 36.75           C  
ATOM    809  O   ASP A  99      51.035  36.898  73.681  1.00 36.07           O  
ATOM    810  CB  ASP A  99      51.465  34.572  75.321  1.00 36.40           C  
ATOM    811  CG  ASP A  99      50.148  33.839  74.997  1.00 40.12           C  
ATOM    812  OD1 ASP A  99      49.486  34.105  73.965  1.00 41.29           O  
ATOM    813  OD2 ASP A  99      49.757  32.997  75.839  1.00 43.53           O  
ATOM    814  N   GLU A 100      51.517  35.631  71.893  1.00 38.03           N  
ATOM    815  CA  GLU A 100      50.891  36.531  70.910  1.00 39.52           C  
ATOM    816  C   GLU A 100      49.404  36.772  71.126  1.00 35.84           C  
ATOM    817  O   GLU A 100      48.900  37.852  70.866  1.00 33.58           O  
ATOM    818  CB  GLU A 100      51.124  36.028  69.490  1.00 42.62           C  
ATOM    819  CG  GLU A 100      52.574  36.198  69.030  1.00 56.12           C  
ATOM    820  CD  GLU A 100      53.045  37.669  68.979  1.00 64.34           C  
ATOM    821  OE1 GLU A 100      52.204  38.614  68.921  1.00 74.00           O  
ATOM    822  OE2 GLU A 100      54.279  37.863  68.977  1.00 72.37           O  
ATOM    823  N   ASP A 101      48.714  35.774  71.636  1.00 38.25           N  
ATOM    824  CA  ASP A 101      47.301  35.929  71.949  1.00 39.73           C  
ATOM    825  C   ASP A 101      47.119  36.981  73.053  1.00 38.27           C  
ATOM    826  O   ASP A 101      46.271  37.868  72.928  1.00 38.66           O  
ATOM    827  CB  ASP A 101      46.694  34.589  72.381  1.00 41.82           C  
ATOM    828  CG  ASP A 101      46.913  33.451  71.336  1.00 57.30           C  
ATOM    829  OD1 ASP A 101      46.905  33.724  70.092  1.00 66.66           O  
ATOM    830  OD2 ASP A 101      47.099  32.281  71.776  1.00 67.00           O  
ATOM    831  N   VAL A 102      47.917  36.878  74.124  1.00 36.02           N  
ATOM    832  CA  VAL A 102      47.853  37.835  75.235  1.00 33.94           C  
ATOM    833  C   VAL A 102      48.223  39.227  74.712  1.00 32.14           C  
ATOM    834  O   VAL A 102      47.547  40.191  75.000  1.00 30.94           O  
ATOM    835  CB  VAL A 102      48.783  37.418  76.439  1.00 32.35           C  
ATOM    836  CG1 VAL A 102      49.140  38.612  77.330  1.00 27.56           C  
ATOM    837  CG2 VAL A 102      48.131  36.301  77.291  1.00 34.61           C  
ATOM    838  N   LEU A 103      49.307  39.317  73.959  1.00 29.41           N  
ATOM    839  CA  LEU A 103      49.802  40.605  73.493  1.00 30.24           C  
ATOM    840  C   LEU A 103      48.805  41.296  72.555  1.00 31.75           C  
ATOM    841  O   LEU A 103      48.617  42.495  72.650  1.00 31.09           O  
ATOM    842  CB  LEU A 103      51.182  40.437  72.802  1.00 30.02           C  
ATOM    843  CG  LEU A 103      52.369  39.956  73.623  1.00 32.67           C  
ATOM    844  CD1 LEU A 103      53.647  39.826  72.745  1.00 28.73           C  
ATOM    845  CD2 LEU A 103      52.625  40.930  74.719  1.00 27.04           C  
ATOM    846  N   GLN A 104      48.172  40.540  71.639  1.00 33.92           N  
ATOM    847  CA  GLN A 104      47.123  41.107  70.738  1.00 33.17           C  
ATOM    848  C   GLN A 104      45.949  41.620  71.539  1.00 29.64           C  
ATOM    849  O   GLN A 104      45.394  42.669  71.243  1.00 30.09           O  
ATOM    850  CB  GLN A 104      46.593  40.049  69.773  1.00 36.62           C  
ATOM    851  CG  GLN A 104      47.530  39.733  68.661  1.00 46.10           C  
ATOM    852  CD  GLN A 104      47.353  40.665  67.476  1.00 60.35           C  
ATOM    853  OE1 GLN A 104      48.232  41.485  67.167  1.00 57.86           O  
ATOM    854  NE2 GLN A 104      46.196  40.552  66.807  1.00 68.39           N  
ATOM    855  N   ALA A 105      45.553  40.869  72.550  1.00 30.60           N  
ATOM    856  CA  ALA A 105      44.433  41.307  73.414  1.00 27.44           C  
ATOM    857  C   ALA A 105      44.766  42.637  74.064  1.00 31.80           C  
ATOM    858  O   ALA A 105      43.897  43.463  74.267  1.00 33.46           O  
ATOM    859  CB  ALA A 105      44.127  40.272  74.452  1.00 28.91           C  
ATOM    860  N   ILE A 106      46.030  42.823  74.456  1.00 31.45           N  
ATOM    861  CA  ILE A 106      46.438  44.076  75.046  1.00 29.91           C  
ATOM    862  C   ILE A 106      46.407  45.172  73.968  1.00 32.12           C  
ATOM    863  O   ILE A 106      45.870  46.242  74.189  1.00 31.05           O  
ATOM    864  CB  ILE A 106      47.852  43.981  75.677  1.00 30.40           C  
ATOM    865  CG1 ILE A 106      47.836  43.037  76.876  1.00 33.63           C  
ATOM    866  CG2 ILE A 106      48.319  45.379  76.111  1.00 25.06           C  
ATOM    867  CD1 ILE A 106      49.227  42.689  77.442  1.00 29.08           C  
ATOM    868  N   ARG A 107      46.989  44.864  72.809  1.00 31.89           N  
ATOM    869  CA  ARG A 107      47.149  45.792  71.694  1.00 31.56           C  
ATOM    870  C   ARG A 107      45.853  46.419  71.216  1.00 31.62           C  
ATOM    871  O   ARG A 107      45.829  47.612  70.917  1.00 32.93           O  
ATOM    872  CB  ARG A 107      47.818  45.067  70.533  1.00 31.79           C  
ATOM    873  CG  ARG A 107      48.151  45.894  69.264  1.00 31.02           C  
ATOM    874  CD  ARG A 107      48.970  45.017  68.282  1.00 38.61           C  
ATOM    875  NE  ARG A 107      50.311  44.626  68.799  1.00 50.19           N  
ATOM    876  CZ  ARG A 107      50.717  43.400  69.206  1.00 52.89           C  
ATOM    877  NH1 ARG A 107      49.932  42.323  69.165  1.00 52.18           N  
ATOM    878  NH2 ARG A 107      51.973  43.245  69.635  1.00 55.56           N  
ATOM    879  N   PHE A 108      44.780  45.619  71.166  1.00 32.97           N  
ATOM    880  CA  PHE A 108      43.521  46.088  70.572  1.00 29.47           C  
ATOM    881  C   PHE A 108      42.417  46.425  71.541  1.00 31.58           C  
ATOM    882  O   PHE A 108      41.249  46.590  71.140  1.00 29.83           O  
ATOM    883  CB  PHE A 108      43.065  45.072  69.512  1.00 28.73           C  
ATOM    884  CG  PHE A 108      43.976  45.048  68.344  1.00 26.07           C  
ATOM    885  CD1 PHE A 108      44.034  46.159  67.514  1.00 28.75           C  
ATOM    886  CD2 PHE A 108      44.833  43.978  68.116  1.00 28.75           C  
ATOM    887  CE1 PHE A 108      44.920  46.189  66.433  1.00 28.43           C  
ATOM    888  CE2 PHE A 108      45.721  44.012  67.066  1.00 31.86           C  
ATOM    889  CZ  PHE A 108      45.769  45.110  66.223  1.00 33.36           C  
ATOM    890  N   HIS A 109      42.758  46.555  72.822  1.00 30.25           N  
ATOM    891  CA  HIS A 109      41.704  46.666  73.836  1.00 29.55           C  
ATOM    892  C   HIS A 109      41.031  48.009  73.851  1.00 30.86           C  
ATOM    893  O   HIS A 109      39.942  48.124  74.439  1.00 31.66           O  
ATOM    894  CB  HIS A 109      42.218  46.349  75.264  1.00 30.42           C  
ATOM    895  CG  HIS A 109      42.932  47.485  75.940  1.00 31.85           C  
ATOM    896  ND1 HIS A 109      44.308  47.641  75.902  1.00 31.60           N  
ATOM    897  CD2 HIS A 109      42.460  48.503  76.690  1.00 28.39           C  
ATOM    898  CE1 HIS A 109      44.633  48.715  76.607  1.00 32.33           C  
ATOM    899  NE2 HIS A 109      43.528  49.254  77.090  1.00 25.90           N  
ATOM    900  N   THR A 110      41.729  49.034  73.358  1.00 33.29           N  
ATOM    901  CA  THR A 110      41.170  50.395  73.322  1.00 32.91           C  
ATOM    902  C   THR A 110      40.355  50.656  72.032  1.00 32.67           C  
ATOM    903  O   THR A 110      39.260  51.168  72.108  1.00 30.02           O  
ATOM    904  CB  THR A 110      42.253  51.474  73.373  1.00 33.30           C  
ATOM    905  OG1 THR A 110      43.054  51.286  74.529  1.00 32.46           O  
ATOM    906  CG2 THR A 110      41.622  52.871  73.405  1.00 27.50           C  
ATOM    907  N   THR A 111      40.933  50.362  70.866  1.00 29.62           N  
ATOM    908  CA  THR A 111      40.292  50.695  69.609  1.00 29.85           C  
ATOM    909  C   THR A 111      39.419  49.571  69.040  1.00 30.16           C  
ATOM    910  O   THR A 111      38.456  49.846  68.322  1.00 30.53           O  
ATOM    911  CB  THR A 111      41.309  51.031  68.561  1.00 29.78           C  
ATOM    912  OG1 THR A 111      42.112  49.871  68.280  1.00 34.23           O  
ATOM    913  CG2 THR A 111      42.183  52.273  68.984  1.00 30.07           C  
ATOM    914  N   GLY A 112      39.742  48.328  69.382  1.00 30.91           N  
ATOM    915  CA  GLY A 112      39.137  47.167  68.735  1.00 30.78           C  
ATOM    916  C   GLY A 112      39.789  47.034  67.367  1.00 30.36           C  
ATOM    917  O   GLY A 112      40.639  47.849  66.985  1.00 34.23           O  
ATOM    918  N   ARG A 113      39.445  45.959  66.674  1.00 33.24           N  
ATOM    919  CA  ARG A 113      39.716  45.806  65.266  1.00 34.73           C  
ATOM    920  C   ARG A 113      38.620  44.900  64.679  1.00 36.35           C  
ATOM    921  O   ARG A 113      37.994  44.140  65.418  1.00 34.73           O  
ATOM    922  CB  ARG A 113      41.084  45.198  65.021  1.00 32.99           C  
ATOM    923  CG  ARG A 113      41.284  43.790  65.524  1.00 33.82           C  
ATOM    924  CD  ARG A 113      42.664  43.371  65.141  1.00 39.04           C  
ATOM    925  NE  ARG A 113      43.023  42.028  65.567  1.00 39.76           N  
ATOM    926  CZ  ARG A 113      42.877  40.924  64.837  1.00 45.34           C  
ATOM    927  NH1 ARG A 113      42.365  40.944  63.610  1.00 48.93           N  
ATOM    928  NH2 ARG A 113      43.255  39.767  65.345  1.00 46.49           N  
ATOM    929  N   PRO A 114      38.370  44.997  63.368  1.00 37.61           N  
ATOM    930  CA  PRO A 114      37.508  43.973  62.780  1.00 38.79           C  
ATOM    931  C   PRO A 114      38.172  42.587  62.896  1.00 39.66           C  
ATOM    932  O   PRO A 114      39.402  42.454  62.786  1.00 38.96           O  
ATOM    933  CB  PRO A 114      37.418  44.372  61.304  1.00 40.02           C  
ATOM    934  CG  PRO A 114      37.907  45.756  61.229  1.00 36.79           C  
ATOM    935  CD  PRO A 114      38.825  45.979  62.374  1.00 39.06           C  
ATOM    936  N   ASN A 115      37.344  41.592  63.156  1.00 38.78           N  
ATOM    937  CA  ASN A 115      37.760  40.206  63.227  1.00 40.31           C  
ATOM    938  C   ASN A 115      38.727  39.967  64.401  1.00 41.11           C  
ATOM    939  O   ASN A 115      39.804  39.376  64.250  1.00 43.12           O  
ATOM    940  CB  ASN A 115      38.314  39.726  61.869  1.00 40.11           C  
ATOM    941  CG  ASN A 115      37.374  40.060  60.700  1.00 42.20           C  
ATOM    942  OD1 ASN A 115      37.766  40.734  59.745  1.00 48.16           O  
ATOM    943  ND2 ASN A 115      36.127  39.639  60.806  1.00 43.08           N  
HETATM  944  N   MSE A 116      38.331  40.451  65.575  1.00 39.04           N  
HETATM  945  CA  MSE A 116      39.056  40.147  66.803  1.00 37.10           C  
HETATM  946  C   MSE A 116      38.937  38.663  67.139  1.00 37.93           C  
HETATM  947  O   MSE A 116      37.884  38.069  66.938  1.00 40.05           O  
HETATM  948  CB  MSE A 116      38.479  40.928  67.976  1.00 36.59           C  
HETATM  949  CG  MSE A 116      39.014  42.362  68.013  1.00 40.74           C  
HETATM  950 SE   MSE A 116      38.447  43.369  69.547  0.75 34.85          SE  
HETATM  951  CE  MSE A 116      36.608  43.717  69.129  1.00 31.43           C  
ATOM    952  N   SER A 117      40.024  38.080  67.635  1.00 35.52           N  
ATOM    953  CA  SER A 117      39.996  36.773  68.310  1.00 34.05           C  
ATOM    954  C   SER A 117      39.064  36.858  69.518  1.00 35.03           C  
ATOM    955  O   SER A 117      38.765  37.956  70.013  1.00 34.46           O  
ATOM    956  CB  SER A 117      41.387  36.394  68.827  1.00 35.34           C  
ATOM    957  OG  SER A 117      41.739  37.168  69.977  1.00 35.85           O  
ATOM    958  N   LEU A 118      38.619  35.709  70.022  1.00 33.71           N  
ATOM    959  CA  LEU A 118      37.775  35.691  71.235  1.00 33.51           C  
ATOM    960  C   LEU A 118      38.445  36.363  72.448  1.00 32.44           C  
ATOM    961  O   LEU A 118      37.809  37.098  73.206  1.00 35.24           O  
ATOM    962  CB  LEU A 118      37.364  34.250  71.556  1.00 34.64           C  
ATOM    963  CG  LEU A 118      36.394  33.965  72.704  1.00 34.59           C  
ATOM    964  CD1 LEU A 118      35.063  34.615  72.461  1.00 42.18           C  
ATOM    965  CD2 LEU A 118      36.251  32.436  72.921  1.00 35.16           C  
ATOM    966  N   LEU A 119      39.738  36.127  72.628  1.00 34.58           N  
ATOM    967  CA  LEU A 119      40.469  36.709  73.744  1.00 33.95           C  
ATOM    968  C   LEU A 119      40.559  38.252  73.585  1.00 31.96           C  
ATOM    969  O   LEU A 119      40.428  38.966  74.556  1.00 28.94           O  
ATOM    970  CB  LEU A 119      41.871  36.094  73.867  1.00 33.69           C  
ATOM    971  CG  LEU A 119      42.506  36.424  75.229  1.00 34.45           C  
ATOM    972  CD1 LEU A 119      41.892  35.496  76.279  1.00 39.36           C  
ATOM    973  CD2 LEU A 119      44.030  36.312  75.174  1.00 40.10           C  
ATOM    974  N   GLU A 120      40.830  38.753  72.378  1.00 33.48           N  
ATOM    975  CA  GLU A 120      40.770  40.216  72.146  1.00 32.68           C  
ATOM    976  C   GLU A 120      39.379  40.810  72.530  1.00 32.19           C  
ATOM    977  O   GLU A 120      39.291  41.830  73.212  1.00 29.77           O  
ATOM    978  CB  GLU A 120      41.078  40.567  70.696  1.00 32.24           C  
ATOM    979  CG  GLU A 120      42.460  40.292  70.269  1.00 27.83           C  
ATOM    980  CD  GLU A 120      42.601  40.425  68.773  1.00 37.54           C  
ATOM    981  OE1 GLU A 120      42.727  41.566  68.280  1.00 44.62           O  
ATOM    982  OE2 GLU A 120      42.508  39.387  68.104  1.00 39.18           O  
ATOM    983  N   LYS A 121      38.301  40.126  72.121  1.00 33.54           N  
ATOM    984  CA  LYS A 121      36.943  40.558  72.446  1.00 33.41           C  
ATOM    985  C   LYS A 121      36.698  40.592  73.955  1.00 34.25           C  
ATOM    986  O   LYS A 121      36.060  41.539  74.506  1.00 35.55           O  
ATOM    987  CB  LYS A 121      35.920  39.627  71.759  1.00 32.52           C  
ATOM    988  CG  LYS A 121      35.815  39.786  70.250  1.00 35.58           C  
ATOM    989  CD  LYS A 121      34.755  38.847  69.618  1.00 38.12           C  
ATOM    990  CE  LYS A 121      34.590  39.088  68.104  1.00 37.87           C  
ATOM    991  NZ  LYS A 121      33.688  38.054  67.497  1.00 40.17           N  
ATOM    992  N   ILE A 122      37.151  39.548  74.632  1.00 31.72           N  
ATOM    993  CA  ILE A 122      36.964  39.441  76.090  1.00 32.96           C  
ATOM    994  C   ILE A 122      37.666  40.595  76.831  1.00 31.08           C  
ATOM    995  O   ILE A 122      37.075  41.219  77.707  1.00 31.07           O  
ATOM    996  CB  ILE A 122      37.405  38.027  76.607  1.00 31.59           C  
ATOM    997  CG1 ILE A 122      36.353  37.007  76.162  1.00 36.88           C  
ATOM    998  CG2 ILE A 122      37.626  37.991  78.135  1.00 31.83           C  
ATOM    999  CD1 ILE A 122      36.815  35.584  76.247  1.00 38.53           C  
ATOM   1000  N   ILE A 123      38.900  40.909  76.438  1.00 31.24           N  
ATOM   1001  CA  ILE A 123      39.650  42.002  77.089  1.00 31.09           C  
ATOM   1002  C   ILE A 123      39.056  43.371  76.746  1.00 27.88           C  
ATOM   1003  O   ILE A 123      38.877  44.218  77.630  1.00 29.36           O  
ATOM   1004  CB  ILE A 123      41.182  41.939  76.812  1.00 30.52           C  
ATOM   1005  CG1 ILE A 123      41.758  40.620  77.347  1.00 32.08           C  
ATOM   1006  CG2 ILE A 123      41.933  43.151  77.462  1.00 31.45           C  
ATOM   1007  CD1 ILE A 123      41.531  40.351  78.873  1.00 30.31           C  
ATOM   1008  N   PHE A 124      38.732  43.582  75.474  1.00 31.59           N  
ATOM   1009  CA  PHE A 124      38.059  44.795  75.052  1.00 31.92           C  
ATOM   1010  C   PHE A 124      36.814  45.035  75.894  1.00 31.14           C  
ATOM   1011  O   PHE A 124      36.583  46.106  76.466  1.00 31.11           O  
ATOM   1012  CB  PHE A 124      37.643  44.685  73.557  1.00 29.41           C  
ATOM   1013  CG  PHE A 124      36.950  45.920  73.041  1.00 29.65           C  
ATOM   1014  CD1 PHE A 124      35.575  46.116  73.255  1.00 34.92           C  
ATOM   1015  CD2 PHE A 124      37.675  46.917  72.397  1.00 29.83           C  
ATOM   1016  CE1 PHE A 124      34.963  47.305  72.838  1.00 37.84           C  
ATOM   1017  CE2 PHE A 124      37.063  48.076  71.965  1.00 25.86           C  
ATOM   1018  CZ  PHE A 124      35.713  48.270  72.179  1.00 34.72           C  
ATOM   1019  N   LEU A 125      35.961  44.026  75.933  1.00 30.73           N  
ATOM   1020  CA  LEU A 125      34.698  44.163  76.650  1.00 30.78           C  
ATOM   1021  C   LEU A 125      34.853  44.240  78.160  1.00 30.06           C  
ATOM   1022  O   LEU A 125      34.148  44.995  78.803  1.00 30.07           O  
ATOM   1023  CB  LEU A 125      33.762  42.987  76.309  1.00 31.89           C  
ATOM   1024  CG  LEU A 125      32.343  43.079  76.846  1.00 30.75           C  
ATOM   1025  CD1 LEU A 125      31.670  44.368  76.359  1.00 26.87           C  
ATOM   1026  CD2 LEU A 125      31.578  41.793  76.423  1.00 26.62           C  
ATOM   1027  N   ALA A 126      35.757  43.433  78.711  1.00 33.12           N  
ATOM   1028  CA  ALA A 126      36.017  43.386  80.173  1.00 30.44           C  
ATOM   1029  C   ALA A 126      36.422  44.766  80.689  1.00 31.89           C  
ATOM   1030  O   ALA A 126      35.987  45.204  81.722  1.00 31.13           O  
ATOM   1031  CB  ALA A 126      37.071  42.332  80.476  1.00 28.57           C  
ATOM   1032  N   ASP A 127      37.182  45.489  79.887  1.00 32.96           N  
ATOM   1033  CA  ASP A 127      37.619  46.846  80.206  1.00 32.95           C  
ATOM   1034  C   ASP A 127      36.459  47.790  80.309  1.00 33.56           C  
ATOM   1035  O   ASP A 127      36.414  48.649  81.153  1.00 34.47           O  
ATOM   1036  CB  ASP A 127      38.520  47.364  79.094  1.00 32.77           C  
ATOM   1037  CG  ASP A 127      39.200  48.684  79.465  1.00 35.03           C  
ATOM   1038  OD1 ASP A 127      39.622  48.858  80.615  1.00 34.86           O  
ATOM   1039  OD2 ASP A 127      39.283  49.579  78.634  1.00 39.62           O  
ATOM   1040  N   TYR A 128      35.490  47.575  79.435  1.00 35.94           N  
ATOM   1041  CA  TYR A 128      34.348  48.434  79.338  1.00 37.21           C  
ATOM   1042  C   TYR A 128      33.303  48.179  80.407  1.00 36.50           C  
ATOM   1043  O   TYR A 128      32.729  49.136  80.930  1.00 38.48           O  
ATOM   1044  CB  TYR A 128      33.751  48.233  77.943  1.00 40.09           C  
ATOM   1045  CG  TYR A 128      32.790  49.287  77.589  1.00 47.78           C  
ATOM   1046  CD1 TYR A 128      33.211  50.503  77.041  1.00 59.88           C  
ATOM   1047  CD2 TYR A 128      31.453  49.083  77.812  1.00 61.10           C  
ATOM   1048  CE1 TYR A 128      32.298  51.483  76.727  1.00 57.01           C  
ATOM   1049  CE2 TYR A 128      30.562  50.006  77.487  1.00 66.34           C  
ATOM   1050  CZ  TYR A 128      30.971  51.223  76.965  1.00 62.54           C  
ATOM   1051  OH  TYR A 128      29.995  52.123  76.675  1.00 61.85           O  
ATOM   1052  N   ILE A 129      33.037  46.905  80.720  1.00 32.80           N  
ATOM   1053  CA  ILE A 129      31.969  46.562  81.660  1.00 34.46           C  
ATOM   1054  C   ILE A 129      32.419  46.161  83.082  1.00 35.51           C  
ATOM   1055  O   ILE A 129      31.586  45.759  83.927  1.00 33.46           O  
ATOM   1056  CB  ILE A 129      31.013  45.496  81.057  1.00 35.34           C  
ATOM   1057  CG1 ILE A 129      31.690  44.127  80.925  1.00 39.09           C  
ATOM   1058  CG2 ILE A 129      30.449  45.971  79.678  1.00 33.93           C  
ATOM   1059  CD1 ILE A 129      30.761  43.020  80.670  1.00 33.90           C  
ATOM   1060  N   GLU A 130      33.718  46.270  83.392  1.00 36.04           N  
ATOM   1061  CA  GLU A 130      34.181  45.868  84.744  1.00 34.48           C  
ATOM   1062  C   GLU A 130      33.376  46.651  85.782  1.00 35.99           C  
ATOM   1063  O   GLU A 130      32.958  47.785  85.505  1.00 34.81           O  
ATOM   1064  CB  GLU A 130      35.697  46.023  84.901  1.00 35.73           C  
ATOM   1065  CG  GLU A 130      36.216  47.440  84.868  1.00 27.14           C  
ATOM   1066  CD  GLU A 130      36.371  48.120  86.217  1.00 37.92           C  
ATOM   1067  OE1 GLU A 130      35.907  47.582  87.250  1.00 34.74           O  
ATOM   1068  OE2 GLU A 130      36.977  49.229  86.224  1.00 31.59           O  
ATOM   1069  N   PRO A 131      33.160  46.067  86.976  1.00 35.69           N  
ATOM   1070  CA  PRO A 131      32.129  46.599  87.876  1.00 37.90           C  
ATOM   1071  C   PRO A 131      32.303  48.053  88.327  1.00 38.29           C  
ATOM   1072  O   PRO A 131      31.314  48.696  88.655  1.00 34.91           O  
ATOM   1073  CB  PRO A 131      32.166  45.643  89.073  1.00 36.94           C  
ATOM   1074  CG  PRO A 131      33.453  44.957  88.990  1.00 42.05           C  
ATOM   1075  CD  PRO A 131      33.879  44.937  87.576  1.00 35.27           C  
ATOM   1076  N   ASN A 132      33.517  48.586  88.315  1.00 38.44           N  
ATOM   1077  CA  ASN A 132      33.741  49.985  88.742  1.00 40.04           C  
ATOM   1078  C   ASN A 132      33.394  51.024  87.682  1.00 42.03           C  
ATOM   1079  O   ASN A 132      33.371  52.212  87.968  1.00 42.10           O  
ATOM   1080  CB  ASN A 132      35.204  50.180  89.167  1.00 40.43           C  
ATOM   1081  CG  ASN A 132      35.601  49.261  90.296  1.00 44.56           C  
ATOM   1082  OD1 ASN A 132      35.309  49.549  91.463  1.00 46.20           O  
ATOM   1083  ND2 ASN A 132      36.267  48.137  89.967  1.00 39.27           N  
ATOM   1084  N   ARG A 133      33.147  50.589  86.459  1.00 42.17           N  
ATOM   1085  CA  ARG A 133      32.816  51.517  85.378  1.00 46.78           C  
ATOM   1086  C   ARG A 133      31.370  51.984  85.514  1.00 51.87           C  
ATOM   1087  O   ARG A 133      30.490  51.174  85.762  1.00 50.99           O  
ATOM   1088  CB  ARG A 133      32.989  50.846  84.033  1.00 45.73           C  
ATOM   1089  CG  ARG A 133      34.386  50.485  83.696  1.00 45.98           C  
ATOM   1090  CD  ARG A 133      35.281  51.690  83.459  1.00 44.30           C  
ATOM   1091  NE  ARG A 133      36.164  51.377  82.346  1.00 56.73           N  
ATOM   1092  CZ  ARG A 133      37.408  51.813  82.172  1.00 47.82           C  
ATOM   1093  NH1 ARG A 133      38.017  52.585  83.058  1.00 56.43           N  
ATOM   1094  NH2 ARG A 133      38.054  51.416  81.089  1.00 46.07           N  
ATOM   1095  N   GLN A 134      31.136  53.281  85.332  1.00 58.36           N  
ATOM   1096  CA  GLN A 134      29.807  53.866  85.544  1.00 63.63           C  
ATOM   1097  C   GLN A 134      29.290  54.625  84.351  1.00 64.32           C  
ATOM   1098  O   GLN A 134      28.350  55.407  84.497  1.00 67.60           O  
ATOM   1099  CB  GLN A 134      29.821  54.763  86.781  1.00 64.14           C  
ATOM   1100  CG  GLN A 134      30.413  54.076  88.012  1.00 67.36           C  
ATOM   1101  CD  GLN A 134      30.213  54.850  89.311  1.00 69.78           C  
ATOM   1102  OE1 GLN A 134      29.621  55.938  89.341  1.00 80.49           O  
ATOM   1103  NE2 GLN A 134      30.707  54.272  90.405  1.00 79.87           N  
ATOM   1104  N   PHE A 135      29.837  54.350  83.166  1.00 63.26           N  
ATOM   1105  CA  PHE A 135      29.365  55.021  81.962  0.50 64.24           C  
ATOM   1107  C   PHE A 135      27.846  54.742  81.783  1.00 65.62           C  
ATOM   1108  O   PHE A 135      27.354  53.651  82.115  1.00 65.85           O  
ATOM   1109  CB  PHE A 135      30.140  54.584  80.705  0.50 63.17           C  
ATOM   1111  CG  PHE A 135      29.534  53.405  80.026  0.50 58.97           C  
ATOM   1113  CD1 PHE A 135      28.521  53.587  79.095  0.50 56.31           C  
ATOM   1115  CD2 PHE A 135      29.930  52.117  80.356  0.50 53.64           C  
ATOM   1117  CE1 PHE A 135      27.903  52.514  78.495  0.50 52.64           C  
ATOM   1119  CE2 PHE A 135      29.334  51.045  79.757  0.50 54.02           C  
ATOM   1121  CZ  PHE A 135      28.291  51.250  78.818  0.50 57.55           C  
ATOM   1123  N   PRO A 136      27.076  55.744  81.267  1.00 67.65           N  
ATOM   1124  CA  PRO A 136      25.626  55.542  81.064  1.00 65.16           C  
ATOM   1125  C   PRO A 136      25.219  54.410  80.145  1.00 62.40           C  
ATOM   1126  O   PRO A 136      25.654  54.372  79.016  1.00 65.88           O  
ATOM   1127  CB  PRO A 136      25.182  56.872  80.441  1.00 66.38           C  
ATOM   1128  CG  PRO A 136      26.150  57.860  80.981  1.00 67.97           C  
ATOM   1129  CD  PRO A 136      27.452  57.135  80.914  1.00 68.86           C  
ATOM   1130  N   GLY A 137      24.350  53.521  80.624  1.00 60.95           N  
ATOM   1131  CA  GLY A 137      23.887  52.345  79.853  1.00 57.18           C  
ATOM   1132  C   GLY A 137      24.630  51.041  80.147  1.00 55.28           C  
ATOM   1133  O   GLY A 137      24.218  49.975  79.692  1.00 56.52           O  
ATOM   1134  N   VAL A 138      25.692  51.124  80.942  1.00 54.67           N  
ATOM   1135  CA  VAL A 138      26.567  49.978  81.263  1.00 53.04           C  
ATOM   1136  C   VAL A 138      25.854  48.742  81.748  1.00 51.60           C  
ATOM   1137  O   VAL A 138      26.235  47.634  81.393  1.00 51.06           O  
ATOM   1138  CB  VAL A 138      27.641  50.379  82.303  1.00 51.06           C  
ATOM   1139  CG1 VAL A 138      27.012  50.719  83.623  1.00 52.90           C  
ATOM   1140  CG2 VAL A 138      28.680  49.281  82.448  1.00 49.99           C  
ATOM   1141  N   GLU A 139      24.790  48.938  82.518  1.00 51.73           N  
ATOM   1142  CA  GLU A 139      24.050  47.842  83.114  1.00 52.66           C  
ATOM   1143  C   GLU A 139      23.436  46.952  82.035  1.00 50.76           C  
ATOM   1144  O   GLU A 139      23.480  45.724  82.127  1.00 51.72           O  
ATOM   1145  CB  GLU A 139      22.972  48.350  84.097  1.00 55.21           C  
ATOM   1146  CG  GLU A 139      23.480  49.272  85.264  1.00 62.15           C  
ATOM   1147  CD  GLU A 139      23.614  50.781  84.916  1.00 70.43           C  
ATOM   1148  OE1 GLU A 139      23.306  51.210  83.765  1.00 68.44           O  
ATOM   1149  OE2 GLU A 139      24.050  51.543  85.817  1.00 74.38           O  
ATOM   1150  N   LYS A 140      22.885  47.578  81.002  1.00 49.63           N  
ATOM   1151  CA  LYS A 140      22.346  46.845  79.864  1.00 49.05           C  
ATOM   1152  C   LYS A 140      23.449  46.060  79.154  1.00 42.79           C  
ATOM   1153  O   LYS A 140      23.259  44.898  78.759  1.00 43.87           O  
ATOM   1154  CB  LYS A 140      21.666  47.805  78.873  1.00 50.70           C  
ATOM   1155  N   VAL A 141      24.598  46.701  78.990  1.00 42.43           N  
ATOM   1156  CA  VAL A 141      25.734  46.083  78.299  1.00 37.46           C  
ATOM   1157  C   VAL A 141      26.219  44.845  79.117  1.00 36.51           C  
ATOM   1158  O   VAL A 141      26.478  43.786  78.551  1.00 39.10           O  
ATOM   1159  CB  VAL A 141      26.852  47.114  77.983  1.00 39.27           C  
ATOM   1160  CG1 VAL A 141      28.016  46.456  77.281  1.00 30.01           C  
ATOM   1161  CG2 VAL A 141      26.330  48.230  77.091  1.00 33.78           C  
ATOM   1162  N   ARG A 142      26.297  44.979  80.433  1.00 37.91           N  
ATOM   1163  CA  ARG A 142      26.680  43.866  81.310  1.00 38.96           C  
ATOM   1164  C   ARG A 142      25.766  42.674  81.218  1.00 40.38           C  
ATOM   1165  O   ARG A 142      26.230  41.533  81.207  1.00 41.42           O  
ATOM   1166  CB  ARG A 142      26.699  44.309  82.750  1.00 39.07           C  
ATOM   1167  CG  ARG A 142      27.853  45.160  83.038  1.00 34.75           C  
ATOM   1168  CD  ARG A 142      27.848  45.608  84.460  1.00 41.86           C  
ATOM   1169  NE  ARG A 142      28.954  46.528  84.684  1.00 35.54           N  
ATOM   1170  CZ  ARG A 142      28.935  47.616  85.445  1.00 39.58           C  
ATOM   1171  NH1 ARG A 142      27.845  48.049  86.033  1.00 37.38           N  
ATOM   1172  NH2 ARG A 142      30.028  48.346  85.538  1.00 35.72           N  
ATOM   1173  N   THR A 143      24.460  42.943  81.147  1.00 41.27           N  
ATOM   1174  CA  THR A 143      23.466  41.890  80.984  1.00 41.18           C  
ATOM   1175  C   THR A 143      23.620  41.238  79.606  1.00 39.72           C  
ATOM   1176  O   THR A 143      23.667  39.994  79.465  1.00 40.41           O  
ATOM   1177  CB  THR A 143      21.996  42.459  81.205  1.00 40.47           C  
ATOM   1178  OG1 THR A 143      21.795  42.697  82.600  1.00 45.11           O  
ATOM   1179  CG2 THR A 143      20.933  41.489  80.704  1.00 44.76           C  
ATOM   1180  N   GLN A 144      23.734  42.078  78.593  1.00 38.51           N  
ATOM   1181  CA  GLN A 144      23.908  41.587  77.218  1.00 38.63           C  
ATOM   1182  C   GLN A 144      25.097  40.623  77.061  1.00 38.78           C  
ATOM   1183  O   GLN A 144      25.022  39.598  76.346  1.00 39.64           O  
ATOM   1184  CB  GLN A 144      24.066  42.782  76.283  1.00 36.78           C  
ATOM   1185  CG  GLN A 144      23.811  42.458  74.859  1.00 37.90           C  
ATOM   1186  CD  GLN A 144      23.901  43.679  73.962  1.00 38.35           C  
ATOM   1187  OE1 GLN A 144      24.451  44.728  74.337  1.00 44.74           O  
ATOM   1188  NE2 GLN A 144      23.413  43.533  72.761  1.00 36.78           N  
ATOM   1189  N   ALA A 145      26.161  40.951  77.791  1.00 36.65           N  
ATOM   1190  CA  ALA A 145      27.434  40.241  77.772  1.00 37.04           C  
ATOM   1191  C   ALA A 145      27.302  38.792  78.250  1.00 38.39           C  
ATOM   1192  O   ALA A 145      28.033  37.898  77.806  1.00 37.18           O  
ATOM   1193  CB  ALA A 145      28.443  41.012  78.634  1.00 32.01           C  
ATOM   1194  N   LYS A 146      26.343  38.563  79.132  1.00 39.70           N  
ATOM   1195  CA  LYS A 146      26.092  37.224  79.662  1.00 42.65           C  
ATOM   1196  C   LYS A 146      25.625  36.230  78.600  1.00 43.02           C  
ATOM   1197  O   LYS A 146      25.797  35.011  78.754  1.00 41.83           O  
ATOM   1198  CB  LYS A 146      25.117  37.303  80.826  1.00 42.34           C  
ATOM   1199  CG  LYS A 146      25.725  38.078  81.995  1.00 46.56           C  
ATOM   1200  CD  LYS A 146      24.789  38.181  83.182  1.00 49.21           C  
ATOM   1201  CE  LYS A 146      25.441  38.911  84.358  1.00 52.04           C  
ATOM   1202  NZ  LYS A 146      26.700  38.231  84.780  1.00 56.09           N  
ATOM   1203  N   THR A 147      25.078  36.759  77.507  1.00 44.47           N  
ATOM   1204  CA  THR A 147      24.562  35.947  76.436  1.00 43.52           C  
ATOM   1205  C   THR A 147      25.053  36.288  75.043  1.00 45.22           C  
ATOM   1206  O   THR A 147      25.161  35.387  74.208  1.00 45.42           O  
ATOM   1207  CB  THR A 147      23.023  36.012  76.478  1.00 46.59           C  
ATOM   1208  OG1 THR A 147      22.589  37.334  76.859  1.00 47.18           O  
ATOM   1209  CG2 THR A 147      22.513  35.016  77.537  1.00 46.40           C  
ATOM   1210  N   ASP A 148      25.384  37.552  74.785  1.00 41.43           N  
ATOM   1211  CA  ASP A 148      25.680  37.998  73.438  1.00 41.01           C  
ATOM   1212  C   ASP A 148      26.911  38.854  73.473  1.00 40.32           C  
ATOM   1213  O   ASP A 148      26.790  40.070  73.619  1.00 38.81           O  
ATOM   1214  CB  ASP A 148      24.482  38.814  72.958  1.00 41.22           C  
ATOM   1215  CG  ASP A 148      24.615  39.316  71.534  1.00 42.76           C  
ATOM   1216  OD1 ASP A 148      25.575  38.950  70.820  1.00 39.94           O  
ATOM   1217  OD2 ASP A 148      23.712  40.076  71.131  1.00 46.27           O  
ATOM   1218  N   LEU A 149      28.081  38.215  73.332  1.00 39.73           N  
ATOM   1219  CA  LEU A 149      29.375  38.922  73.404  1.00 37.81           C  
ATOM   1220  C   LEU A 149      29.489  39.982  72.315  1.00 36.26           C  
ATOM   1221  O   LEU A 149      29.798  41.112  72.589  1.00 33.73           O  
ATOM   1222  CB  LEU A 149      30.520  37.927  73.263  1.00 40.64           C  
ATOM   1223  CG  LEU A 149      31.968  38.438  73.352  1.00 36.96           C  
ATOM   1224  CD1 LEU A 149      32.297  38.916  74.734  1.00 33.14           C  
ATOM   1225  CD2 LEU A 149      32.919  37.333  72.971  1.00 38.23           C  
ATOM   1226  N   ASN A 150      29.212  39.600  71.071  1.00 36.69           N  
ATOM   1227  CA  ASN A 150      29.332  40.537  69.939  1.00 36.35           C  
ATOM   1228  C   ASN A 150      28.366  41.714  70.073  1.00 36.75           C  
ATOM   1229  O   ASN A 150      28.748  42.891  69.827  1.00 37.61           O  
ATOM   1230  CB  ASN A 150      29.134  39.790  68.615  1.00 38.04           C  
ATOM   1231  CG  ASN A 150      30.310  38.881  68.265  1.00 38.96           C  
ATOM   1232  OD1 ASN A 150      31.407  38.992  68.830  1.00 39.08           O  
ATOM   1233  ND2 ASN A 150      30.093  37.995  67.296  1.00 44.35           N  
ATOM   1234  N   GLY A 151      27.153  41.419  70.548  1.00 35.53           N  
ATOM   1235  CA  GLY A 151      26.165  42.454  70.813  1.00 35.12           C  
ATOM   1236  C   GLY A 151      26.578  43.420  71.912  1.00 33.20           C  
ATOM   1237  O   GLY A 151      26.374  44.623  71.772  1.00 32.43           O  
ATOM   1238  N   ALA A 152      27.130  42.903  73.014  1.00 33.88           N  
ATOM   1239  CA  ALA A 152      27.663  43.783  74.083  1.00 34.19           C  
ATOM   1240  C   ALA A 152      28.774  44.677  73.557  1.00 31.45           C  
ATOM   1241  O   ALA A 152      28.883  45.850  73.927  1.00 31.63           O  
ATOM   1242  CB  ALA A 152      28.186  42.981  75.289  1.00 32.63           C  
ATOM   1243  N   ILE A 153      29.622  44.111  72.720  1.00 33.05           N  
ATOM   1244  CA  ILE A 153      30.721  44.886  72.137  1.00 31.43           C  
ATOM   1245  C   ILE A 153      30.158  45.929  71.213  1.00 31.32           C  
ATOM   1246  O   ILE A 153      30.623  47.063  71.228  1.00 31.54           O  
ATOM   1247  CB  ILE A 153      31.758  43.994  71.429  1.00 33.55           C  
ATOM   1248  CG1 ILE A 153      32.467  43.111  72.464  1.00 34.80           C  
ATOM   1249  CG2 ILE A 153      32.755  44.888  70.632  1.00 29.54           C  
ATOM   1250  CD1 ILE A 153      33.380  42.072  71.878  1.00 29.51           C  
ATOM   1251  N   ILE A 154      29.134  45.587  70.427  1.00 28.49           N  
ATOM   1252  CA  ILE A 154      28.468  46.599  69.576  1.00 31.40           C  
ATOM   1253  C   ILE A 154      27.903  47.770  70.418  1.00 33.17           C  
ATOM   1254  O   ILE A 154      28.155  48.946  70.145  1.00 31.95           O  
ATOM   1255  CB  ILE A 154      27.352  45.971  68.728  1.00 30.76           C  
ATOM   1256  CG1 ILE A 154      27.965  45.124  67.601  1.00 33.06           C  
ATOM   1257  CG2 ILE A 154      26.466  47.060  68.161  1.00 29.42           C  
ATOM   1258  CD1 ILE A 154      27.009  44.100  66.933  1.00 32.92           C  
ATOM   1259  N   SER A 155      27.182  47.427  71.478  1.00 32.41           N  
ATOM   1260  CA  SER A 155      26.631  48.433  72.383  1.00 32.37           C  
ATOM   1261  C   SER A 155      27.689  49.329  72.988  1.00 31.18           C  
ATOM   1262  O   SER A 155      27.449  50.532  73.167  1.00 32.74           O  
ATOM   1263  CB  SER A 155      25.820  47.760  73.488  1.00 32.02           C  
ATOM   1264  OG  SER A 155      24.737  47.027  72.944  1.00 36.16           O  
ATOM   1265  N   SER A 156      28.843  48.765  73.327  1.00 33.11           N  
ATOM   1266  CA  SER A 156      29.911  49.550  73.917  0.50 33.65           C  
ATOM   1268  C   SER A 156      30.477  50.554  72.907  1.00 35.08           C  
ATOM   1269  O   SER A 156      30.735  51.690  73.250  1.00 35.43           O  
ATOM   1270  CB  SER A 156      31.034  48.653  74.412  0.50 34.70           C  
ATOM   1272  OG  SER A 156      31.676  48.009  73.321  0.50 38.10           O  
ATOM   1274  N   LEU A 157      30.709  50.087  71.678  1.00 36.56           N  
ATOM   1275  CA  LEU A 157      31.191  50.911  70.571  1.00 35.80           C  
ATOM   1276  C   LEU A 157      30.207  52.037  70.250  1.00 36.44           C  
ATOM   1277  O   LEU A 157      30.619  53.180  70.020  1.00 38.25           O  
ATOM   1278  CB  LEU A 157      31.474  50.021  69.346  1.00 37.12           C  
ATOM   1279  CG  LEU A 157      32.685  49.083  69.446  1.00 38.10           C  
ATOM   1280  CD1 LEU A 157      32.699  47.952  68.398  1.00 26.31           C  
ATOM   1281  CD2 LEU A 157      33.969  49.883  69.360  1.00 30.19           C  
ATOM   1282  N   VAL A 158      28.912  51.716  70.233  1.00 37.48           N  
ATOM   1283  CA  VAL A 158      27.857  52.709  70.033  1.00 36.25           C  
ATOM   1284  C   VAL A 158      28.012  53.834  71.079  1.00 38.18           C  
ATOM   1285  O   VAL A 158      28.093  55.013  70.717  1.00 36.07           O  
ATOM   1286  CB  VAL A 158      26.449  52.065  70.051  1.00 35.83           C  
ATOM   1287  CG1 VAL A 158      25.329  53.120  70.228  1.00 37.73           C  
ATOM   1288  CG2 VAL A 158      26.236  51.260  68.746  1.00 29.90           C  
ATOM   1289  N   ASN A 159      28.107  53.471  72.356  1.00 38.59           N  
ATOM   1290  CA  ASN A 159      28.228  54.478  73.400  0.50 37.64           C  
ATOM   1292  C   ASN A 159      29.567  55.257  73.272  1.00 36.57           C  
ATOM   1293  O   ASN A 159      29.583  56.483  73.441  1.00 34.84           O  
ATOM   1294  CB  ASN A 159      27.986  53.839  74.790  0.50 38.75           C  
ATOM   1296  CG  ASN A 159      26.563  53.245  74.948  0.50 36.44           C  
ATOM   1298  OD1 ASN A 159      25.684  53.435  74.097  0.50 31.33           O  
ATOM   1300  ND2 ASN A 159      26.346  52.515  76.041  0.50 34.44           N  
ATOM   1302  N   THR A 160      30.654  54.562  72.940  1.00 37.98           N  
ATOM   1303  CA  THR A 160      31.952  55.208  72.760  1.00 37.73           C  
ATOM   1304  C   THR A 160      31.959  56.201  71.603  1.00 37.18           C  
ATOM   1305  O   THR A 160      32.305  57.373  71.774  1.00 34.65           O  
ATOM   1306  CB  THR A 160      33.093  54.180  72.551  1.00 39.98           C  
ATOM   1307  OG1 THR A 160      33.313  53.497  73.785  1.00 47.52           O  
ATOM   1308  CG2 THR A 160      34.405  54.870  72.121  1.00 39.15           C  
ATOM   1309  N   ILE A 161      31.555  55.717  70.439  1.00 35.51           N  
ATOM   1310  CA  ILE A 161      31.555  56.540  69.236  1.00 35.17           C  
ATOM   1311  C   ILE A 161      30.569  57.686  69.422  1.00 34.47           C  
ATOM   1312  O   ILE A 161      30.880  58.804  69.062  1.00 30.88           O  
ATOM   1313  CB  ILE A 161      31.251  55.720  67.951  1.00 35.98           C  
ATOM   1314  CG1 ILE A 161      32.341  54.652  67.732  1.00 36.98           C  
ATOM   1315  CG2 ILE A 161      31.165  56.667  66.743  1.00 31.74           C  
ATOM   1316  CD1 ILE A 161      31.986  53.521  66.721  1.00 32.67           C  
ATOM   1317  N   THR A 162      29.407  57.422  70.025  1.00 32.60           N  
ATOM   1318  CA  THR A 162      28.440  58.495  70.251  1.00 33.89           C  
ATOM   1319  C   THR A 162      29.033  59.620  71.087  1.00 36.06           C  
ATOM   1320  O   THR A 162      28.838  60.787  70.781  1.00 36.87           O  
ATOM   1321  CB  THR A 162      27.160  57.953  70.901  1.00 35.05           C  
ATOM   1322  OG1 THR A 162      26.482  57.128  69.942  1.00 37.11           O  
ATOM   1323  CG2 THR A 162      26.210  59.082  71.334  1.00 37.80           C  
ATOM   1324  N   PHE A 163      29.756  59.245  72.142  1.00 37.05           N  
ATOM   1325  CA  PHE A 163      30.369  60.189  73.064  1.00 35.72           C  
ATOM   1326  C   PHE A 163      31.416  61.017  72.363  1.00 33.10           C  
ATOM   1327  O   PHE A 163      31.439  62.229  72.493  1.00 34.27           O  
ATOM   1328  CB  PHE A 163      31.017  59.441  74.233  1.00 41.02           C  
ATOM   1329  CG  PHE A 163      31.720  60.338  75.196  1.00 40.43           C  
ATOM   1330  CD1 PHE A 163      30.992  61.040  76.150  1.00 47.94           C  
ATOM   1331  CD2 PHE A 163      33.102  60.526  75.116  1.00 49.80           C  
ATOM   1332  CE1 PHE A 163      31.632  61.906  77.030  1.00 49.28           C  
ATOM   1333  CE2 PHE A 163      33.756  61.398  76.003  1.00 48.51           C  
ATOM   1334  CZ  PHE A 163      33.005  62.089  76.956  1.00 46.11           C  
ATOM   1335  N   LEU A 164      32.287  60.360  71.619  1.00 34.64           N  
ATOM   1336  CA  LEU A 164      33.330  61.073  70.888  1.00 34.06           C  
ATOM   1337  C   LEU A 164      32.728  62.085  69.871  1.00 34.46           C  
ATOM   1338  O   LEU A 164      33.260  63.201  69.693  1.00 33.38           O  
ATOM   1339  CB  LEU A 164      34.280  60.059  70.193  1.00 35.38           C  
ATOM   1340  CG  LEU A 164      35.176  59.149  71.072  1.00 35.58           C  
ATOM   1341  CD1 LEU A 164      35.930  58.170  70.211  1.00 33.09           C  
ATOM   1342  CD2 LEU A 164      36.149  59.986  71.909  1.00 37.72           C  
ATOM   1343  N   LEU A 165      31.647  61.683  69.189  1.00 33.73           N  
ATOM   1344  CA  LEU A 165      30.973  62.562  68.222  1.00 33.99           C  
ATOM   1345  C   LEU A 165      30.423  63.793  68.903  1.00 37.16           C  
ATOM   1346  O   LEU A 165      30.622  64.917  68.427  1.00 38.65           O  
ATOM   1347  CB  LEU A 165      29.837  61.813  67.496  1.00 33.81           C  
ATOM   1348  CG  LEU A 165      30.281  60.822  66.419  1.00 29.01           C  
ATOM   1349  CD1 LEU A 165      29.071  59.958  66.039  1.00 32.90           C  
ATOM   1350  CD2 LEU A 165      30.877  61.532  65.172  1.00 34.68           C  
ATOM   1351  N   LYS A 166      29.779  63.569  70.048  1.00 41.05           N  
ATOM   1352  CA  LYS A 166      29.156  64.620  70.876  1.00 39.37           C  
ATOM   1353  C   LYS A 166      30.171  65.613  71.405  1.00 42.11           C  
ATOM   1354  O   LYS A 166      29.878  66.787  71.493  1.00 40.27           O  
ATOM   1355  CB  LYS A 166      28.451  63.959  72.063  1.00 41.62           C  
ATOM   1356  CG  LYS A 166      27.777  64.881  73.059  1.00 46.37           C  
ATOM   1357  N   LYS A 167      31.359  65.129  71.776  1.00 42.17           N  
ATOM   1358  CA  LYS A 167      32.449  65.999  72.229  1.00 41.20           C  
ATOM   1359  C   LYS A 167      33.323  66.496  71.062  1.00 41.12           C  
ATOM   1360  O   LYS A 167      34.347  67.135  71.285  1.00 42.01           O  
ATOM   1361  CB  LYS A 167      33.313  65.258  73.270  1.00 42.07           C  
ATOM   1362  CG  LYS A 167      32.569  64.722  74.490  1.00 44.21           C  
ATOM   1363  CD  LYS A 167      31.880  65.824  75.263  1.00 46.36           C  
ATOM   1364  CE  LYS A 167      31.353  65.369  76.624  1.00 48.76           C  
ATOM   1365  NZ  LYS A 167      30.635  66.491  77.312  1.00 45.76           N  
ATOM   1366  N   ASN A 168      32.934  66.210  69.824  1.00 39.65           N  
ATOM   1367  CA  ASN A 168      33.696  66.616  68.631  1.00 40.12           C  
ATOM   1368  C   ASN A 168      35.167  66.172  68.627  1.00 41.09           C  
ATOM   1369  O   ASN A 168      36.069  66.961  68.341  1.00 37.74           O  
ATOM   1370  CB  ASN A 168      33.587  68.127  68.391  1.00 45.38           C  
ATOM   1371  CG  ASN A 168      32.181  68.568  67.966  1.00 42.06           C  
ATOM   1372  OD1 ASN A 168      31.260  67.760  67.763  1.00 40.92           O  
ATOM   1373  ND2 ASN A 168      32.023  69.862  67.829  1.00 40.03           N  
ATOM   1374  N   GLN A 169      35.380  64.892  68.925  1.00 37.42           N  
ATOM   1375  CA  GLN A 169      36.689  64.318  68.980  1.00 37.76           C  
ATOM   1376  C   GLN A 169      36.891  63.466  67.750  1.00 37.58           C  
ATOM   1377  O   GLN A 169      35.935  62.944  67.193  1.00 35.02           O  
ATOM   1378  CB  GLN A 169      36.840  63.467  70.219  1.00 39.63           C  
ATOM   1379  CG  GLN A 169      36.541  64.199  71.529  1.00 44.06           C  
ATOM   1380  CD  GLN A 169      37.562  65.267  71.855  1.00 43.55           C  
ATOM   1381  OE1 GLN A 169      38.758  64.983  71.971  1.00 48.76           O  
ATOM   1382  NE2 GLN A 169      37.098  66.500  72.020  1.00 48.85           N  
ATOM   1383  N   PRO A 170      38.143  63.323  67.309  1.00 39.44           N  
ATOM   1384  CA  PRO A 170      38.408  62.472  66.159  1.00 39.65           C  
ATOM   1385  C   PRO A 170      38.090  61.016  66.508  1.00 40.44           C  
ATOM   1386  O   PRO A 170      38.210  60.629  67.677  1.00 36.30           O  
ATOM   1387  CB  PRO A 170      39.901  62.687  65.900  1.00 43.52           C  
ATOM   1388  CG  PRO A 170      40.443  63.136  67.178  1.00 45.99           C  
ATOM   1389  CD  PRO A 170      39.371  63.937  67.831  1.00 41.39           C  
ATOM   1390  N   ILE A 171      37.591  60.259  65.534  1.00 35.29           N  
ATOM   1391  CA  ILE A 171      37.274  58.848  65.747  1.00 34.01           C  
ATOM   1392  C   ILE A 171      38.172  57.992  64.855  1.00 32.52           C  
ATOM   1393  O   ILE A 171      38.260  58.186  63.656  1.00 33.80           O  
ATOM   1394  CB  ILE A 171      35.781  58.601  65.525  1.00 31.01           C  
ATOM   1395  CG1 ILE A 171      34.987  59.390  66.567  1.00 34.73           C  
ATOM   1396  CG2 ILE A 171      35.452  57.080  65.556  1.00 28.80           C  
ATOM   1397  CD1 ILE A 171      33.582  59.727  66.110  1.00 36.25           C  
ATOM   1398  N   TYR A 172      38.865  57.054  65.489  1.00 30.44           N  
ATOM   1399  CA  TYR A 172      39.778  56.147  64.832  1.00 30.30           C  
ATOM   1400  C   TYR A 172      38.955  55.299  63.887  1.00 30.47           C  
ATOM   1401  O   TYR A 172      38.007  54.647  64.308  1.00 32.26           O  
ATOM   1402  CB  TYR A 172      40.510  55.290  65.850  1.00 32.54           C  
ATOM   1403  CG  TYR A 172      41.643  54.469  65.282  1.00 32.98           C  
ATOM   1404  CD1 TYR A 172      42.733  55.085  64.647  1.00 32.97           C  
ATOM   1405  CD2 TYR A 172      41.629  53.086  65.372  1.00 36.69           C  
ATOM   1406  CE1 TYR A 172      43.791  54.328  64.137  1.00 39.70           C  
ATOM   1407  CE2 TYR A 172      42.665  52.332  64.870  1.00 34.01           C  
ATOM   1408  CZ  TYR A 172      43.745  52.948  64.254  1.00 37.31           C  
ATOM   1409  OH  TYR A 172      44.747  52.149  63.746  1.00 36.92           O  
ATOM   1410  N   PRO A 173      39.273  55.339  62.589  1.00 31.48           N  
ATOM   1411  CA  PRO A 173      38.462  54.596  61.611  1.00 33.86           C  
ATOM   1412  C   PRO A 173      38.310  53.095  61.842  1.00 34.45           C  
ATOM   1413  O   PRO A 173      37.240  52.576  61.598  1.00 36.10           O  
ATOM   1414  CB  PRO A 173      39.212  54.838  60.294  1.00 32.78           C  
ATOM   1415  CG  PRO A 173      39.863  56.147  60.503  1.00 33.72           C  
ATOM   1416  CD  PRO A 173      40.337  56.103  61.918  1.00 34.27           C  
ATOM   1417  N   ASP A 174      39.354  52.417  62.330  1.00 34.83           N  
ATOM   1418  CA  ASP A 174      39.266  50.965  62.565  1.00 36.63           C  
ATOM   1419  C   ASP A 174      38.310  50.625  63.706  1.00 33.92           C  
ATOM   1420  O   ASP A 174      37.855  49.485  63.816  1.00 37.48           O  
ATOM   1421  CB  ASP A 174      40.631  50.319  62.816  1.00 37.26           C  
ATOM   1422  CG  ASP A 174      40.800  49.009  62.081  1.00 42.71           C  
ATOM   1423  OD1 ASP A 174      40.322  48.911  60.913  1.00 38.97           O  
ATOM   1424  OD2 ASP A 174      41.465  48.100  62.638  1.00 42.89           O  
ATOM   1425  N   THR A 175      38.008  51.608  64.554  1.00 31.96           N  
ATOM   1426  CA  THR A 175      36.983  51.423  65.588  1.00 30.35           C  
ATOM   1427  C   THR A 175      35.584  51.342  64.965  1.00 32.69           C  
ATOM   1428  O   THR A 175      34.758  50.494  65.355  1.00 31.37           O  
ATOM   1429  CB  THR A 175      37.077  52.537  66.612  1.00 30.99           C  
ATOM   1430  OG1 THR A 175      38.345  52.400  67.252  1.00 31.81           O  
ATOM   1431  CG2 THR A 175      35.922  52.461  67.671  1.00 32.13           C  
ATOM   1432  N   LEU A 176      35.331  52.197  63.987  1.00 29.82           N  
ATOM   1433  CA  LEU A 176      34.099  52.115  63.219  1.00 30.52           C  
ATOM   1434  C   LEU A 176      34.080  50.842  62.380  1.00 28.54           C  
ATOM   1435  O   LEU A 176      33.051  50.221  62.234  1.00 32.76           O  
ATOM   1436  CB  LEU A 176      33.946  53.349  62.310  1.00 29.80           C  
ATOM   1437  CG  LEU A 176      32.585  53.420  61.580  1.00 30.18           C  
ATOM   1438  CD1 LEU A 176      31.465  53.664  62.556  1.00 28.36           C  
ATOM   1439  CD2 LEU A 176      32.601  54.487  60.505  1.00 30.91           C  
ATOM   1440  N   ALA A 177      35.215  50.453  61.805  1.00 30.48           N  
ATOM   1441  CA  ALA A 177      35.262  49.225  61.025  1.00 29.32           C  
ATOM   1442  C   ALA A 177      34.892  48.067  61.927  1.00 30.41           C  
ATOM   1443  O   ALA A 177      34.221  47.150  61.486  1.00 32.96           O  
ATOM   1444  CB  ALA A 177      36.622  49.006  60.397  1.00 28.57           C  
ATOM   1445  N   THR A 178      35.336  48.114  63.187  1.00 34.05           N  
ATOM   1446  CA  THR A 178      34.982  47.097  64.182  1.00 30.16           C  
ATOM   1447  C   THR A 178      33.459  47.015  64.377  1.00 32.25           C  
ATOM   1448  O   THR A 178      32.884  45.937  64.319  1.00 32.11           O  
ATOM   1449  CB  THR A 178      35.716  47.354  65.520  1.00 30.20           C  
ATOM   1450  OG1 THR A 178      37.126  47.306  65.267  1.00 30.91           O  
ATOM   1451  CG2 THR A 178      35.330  46.323  66.579  1.00 32.24           C  
ATOM   1452  N   TYR A 179      32.839  48.152  64.656  1.00 32.69           N  
ATOM   1453  CA  TYR A 179      31.389  48.252  64.763  1.00 29.43           C  
ATOM   1454  C   TYR A 179      30.698  47.688  63.550  1.00 30.91           C  
ATOM   1455  O   TYR A 179      29.812  46.845  63.667  1.00 29.41           O  
ATOM   1456  CB  TYR A 179      31.001  49.718  64.916  1.00 32.34           C  
ATOM   1457  CG  TYR A 179      29.553  50.009  64.710  1.00 34.24           C  
ATOM   1458  CD1 TYR A 179      28.633  49.805  65.737  1.00 33.28           C  
ATOM   1459  CD2 TYR A 179      29.089  50.493  63.486  1.00 27.54           C  
ATOM   1460  CE1 TYR A 179      27.293  50.066  65.551  1.00 31.09           C  
ATOM   1461  CE2 TYR A 179      27.760  50.775  63.292  1.00 31.09           C  
ATOM   1462  CZ  TYR A 179      26.850  50.556  64.317  1.00 27.35           C  
ATOM   1463  OH  TYR A 179      25.520  50.826  64.105  1.00 31.07           O  
ATOM   1464  N   ASN A 180      31.091  48.167  62.378  1.00 29.51           N  
ATOM   1465  CA  ASN A 180      30.475  47.688  61.130  1.00 30.96           C  
ATOM   1466  C   ASN A 180      30.646  46.195  60.926  1.00 33.86           C  
ATOM   1467  O   ASN A 180      29.685  45.520  60.551  1.00 33.06           O  
ATOM   1468  CB  ASN A 180      31.036  48.434  59.927  1.00 30.76           C  
ATOM   1469  CG  ASN A 180      30.442  49.800  59.770  1.00 29.26           C  
ATOM   1470  OD1 ASN A 180      29.277  50.002  60.055  1.00 33.33           O  
ATOM   1471  ND2 ASN A 180      31.214  50.728  59.221  1.00 28.58           N  
ATOM   1472  N   GLN A 181      31.839  45.673  61.200  1.00 34.95           N  
ATOM   1473  CA  GLN A 181      32.086  44.238  61.011  1.00 35.10           C  
ATOM   1474  C   GLN A 181      31.202  43.364  61.903  1.00 36.58           C  
ATOM   1475  O   GLN A 181      30.623  42.380  61.429  1.00 37.95           O  
ATOM   1476  CB  GLN A 181      33.564  43.897  61.212  1.00 36.13           C  
ATOM   1477  CG  GLN A 181      33.882  42.390  61.126  1.00 37.07           C  
ATOM   1478  CD  GLN A 181      33.907  41.735  62.480  1.00 40.19           C  
ATOM   1479  OE1 GLN A 181      34.649  42.181  63.358  1.00 39.74           O  
ATOM   1480  NE2 GLN A 181      33.127  40.666  62.664  1.00 40.06           N  
ATOM   1481  N   LEU A 182      31.097  43.736  63.167  1.00 36.95           N  
ATOM   1482  CA  LEU A 182      30.315  43.009  64.143  1.00 37.63           C  
ATOM   1483  C   LEU A 182      28.851  43.173  63.879  1.00 40.59           C  
ATOM   1484  O   LEU A 182      28.070  42.260  64.094  1.00 41.71           O  
ATOM   1485  CB  LEU A 182      30.617  43.507  65.559  1.00 38.09           C  
ATOM   1486  CG  LEU A 182      31.989  43.146  66.136  1.00 39.05           C  
ATOM   1487  CD1 LEU A 182      32.183  43.872  67.438  1.00 33.86           C  
ATOM   1488  CD2 LEU A 182      32.132  41.655  66.326  1.00 36.83           C  
ATOM   1489  N   LEU A 183      28.479  44.364  63.438  1.00 42.73           N  
ATOM   1490  CA  LEU A 183      27.110  44.643  63.063  1.00 44.58           C  
ATOM   1491  C   LEU A 183      26.732  43.773  61.879  1.00 45.48           C  
ATOM   1492  O   LEU A 183      25.782  43.012  61.966  1.00 44.20           O  
ATOM   1493  CB  LEU A 183      26.943  46.117  62.685  1.00 43.03           C  
ATOM   1494  CG  LEU A 183      25.518  46.637  62.648  1.00 50.86           C  
ATOM   1495  CD1 LEU A 183      24.981  46.853  64.084  1.00 52.75           C  
ATOM   1496  CD2 LEU A 183      25.493  47.925  61.821  1.00 43.26           C  
ATOM   1497  N   LEU A 184      27.495  43.876  60.790  1.00 49.91           N  
ATOM   1498  CA  LEU A 184      27.173  43.172  59.537  1.00 55.18           C  
ATOM   1499  C   LEU A 184      27.209  41.641  59.696  1.00 57.75           C  
ATOM   1500  O   LEU A 184      26.428  40.949  59.050  1.00 59.64           O  
ATOM   1501  CB  LEU A 184      28.012  43.696  58.340  1.00 53.05           C  
ATOM   1502  CG  LEU A 184      27.836  45.212  57.999  1.00 55.61           C  
ATOM   1503  CD1 LEU A 184      28.710  45.698  56.818  1.00 45.61           C  
ATOM   1504  CD2 LEU A 184      26.383  45.581  57.759  1.00 53.24           C  
ATOM   1505  N   GLU A 185      28.063  41.120  60.564  1.00 60.40           N  
ATOM   1506  CA  GLU A 185      28.054  39.684  60.890  1.00 64.09           C  
ATOM   1507  C   GLU A 185      26.881  39.355  61.841  1.00 67.44           C  
ATOM   1508  O   GLU A 185      26.313  38.268  61.745  1.00 69.31           O  
ATOM   1509  CB  GLU A 185      29.448  39.210  61.400  1.00 65.50           C  
ATOM   1510  CG  GLU A 185      29.539  38.135  62.534  1.00 65.25           C  
ATOM   1511  CD  GLU A 185      29.843  38.748  63.924  1.00 72.88           C  
ATOM   1512  OE1 GLU A 185      28.937  39.369  64.583  1.00 60.31           O  
ATOM   1513  OE2 GLU A 185      31.031  38.622  64.319  1.00 71.67           O  
ATOM   1514  N   GLN A 186      26.556  40.311  62.730  1.00 70.96           N  
ATOM   1515  CA  GLN A 186      25.415  40.320  63.712  1.00 70.81           C  
ATOM   1516  C   GLN A 186      25.838  40.141  65.189  1.00 72.08           C  
ATOM   1517  O   GLN A 186      25.380  40.880  66.079  1.00 70.13           O  
ATOM   1518  CB  GLN A 186      24.248  39.379  63.360  1.00 72.79           C  
ATOM   1519  CG  GLN A 186      23.616  39.638  61.986  1.00 75.56           C  
ATOM   1520  CD  GLN A 186      22.110  39.496  61.979  1.00 83.86           C  
ATOM   1521  OE1 GLN A 186      21.541  38.646  62.672  1.00 84.25           O  
ATOM   1522  NE2 GLN A 186      21.447  40.331  61.179  1.00 91.74           N  
TER    1523      GLN A 186                                                      
END
MOLECULE T0470_2_100.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
END
