
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 (  837),  selected   87 , name 1gvp_A
# Molecule2: number of CA atoms   66 ( 1132),  selected   66 , name T0468.pdb
# PARAMETERS: 1gvp_A.T0468.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    I     2_A      D      12          2.387
LGA    K     3_A      V      13          3.133
LGA    V     4_A      Y      14          2.141
LGA    E     5_A      Y      15          2.354
LGA    I     6_A      M      16          2.868
LGA    K     7_A      -       -           -
LGA    P     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    Q    10_A      Q      17          3.309
LGA    A    11_A      I      18          2.179
LGA    Q    12_A      K      19          1.048
LGA    F    13_A      -       -           -
LGA    T    14_A      -       -           -
LGA    T    15_A      T      23          2.390
LGA    R    16_A      I      24          4.420
LGA    S    17_A      E      25          1.748
LGA    G    18_A      K      26          1.649
LGA    V    19_A      V      27          3.516
LGA    S    20_A      D      28          0.593
LGA    R    21_A      -       -           -
LGA    Q    22_A      -       -           -
LGA    G    23_A      G      29          3.375
LGA    K    24_A      R      30          2.167
LGA    P    25_A      N      31          2.339
LGA    Y    26_A      L      32          2.161
LGA    S    27_A      R      33          3.015
LGA    L    28_A      N      34          2.197
LGA    N    29_A      Y      35          1.545
LGA    E    30_A      T      36          0.903
LGA    Q    31_A      L      37          1.168
LGA    L    32_A      P      38          1.155
LGA    C    33_A      A      39          1.035
LGA    Y    34_A      Y      40          0.710
LGA    V    35_A      D      41          1.195
LGA    D    36_A      E      42          2.541
LGA    L    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    N    39_A      -       -           -
LGA    E    40_A      -       -           -
LGA    Y    41_A      D      43           #
LGA    P    42_A      G      44          1.624
LGA    V    43_A      V      45          1.745
LGA    L    44_A      K      46          1.720
LGA    V    45_A      K      47          1.646
LGA    K    46_A      Q      48          1.685
LGA    I    47_A      I      49          1.837
LGA    T    48_A      T      50          1.423
LGA    L    49_A      F      51          1.586
LGA    D    50_A      R      52          1.411
LGA    E    51_A      -       -           -
LGA    G    52_A      -       -           -
LGA    Q    53_A      -       -           -
LGA    P    54_A      -       -           -
LGA    A    55_A      -       -           -
LGA    Y    56_A      -       -           -
LGA    A    57_A      A      66          2.908
LGA    P    58_A      F      67          1.536
LGA    G    59_A      -       -           -
LGA    L    60_A      L      68          5.971
LGA    Y    61_A      R      69          2.306
LGA    T    62_A      L      70          4.647
LGA    V    63_A      Y      71          0.482
LGA    H    64_A      V      72          5.781
LGA    L    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    S    67_A      K      88          2.079
LGA    F    68_A      -       -           -
LGA    K    69_A      -       -           -
LGA    V    70_A      -       -           -
LGA    G    71_A      -       -           -
LGA    Q    72_A      -       -           -
LGA    F    73_A      -       -           -
LGA    G    74_A      -       -           -
LGA    S    75_A      -       -           -
LGA    L    76_A      -       -           -
LGA    M    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    R    80_A      -       -           -
LGA    L    81_A      -       -           -
LGA    R    82_A      S      89          2.963
LGA    L    83_A      Y      90          1.490
LGA    V    84_A      E      91          2.814
LGA    P    85_A      E      92          5.334
LGA    A    86_A      I      93           #
LGA    K    87_A      Q      94           -
LGA    -       -      K      95           -
LGA    -       -      A      96           -
LGA    -       -      D      97           -
LGA    -       -      L      98           -
LGA    -       -      P      99           -
LGA    -       -      E     100           -
LGA    -       -      K     101           -
LGA    -       -      V     102           -
LGA    -       -      K     103           -
LGA    -       -      D     104           -
LGA    -       -      K     105           -
LGA    -       -      F     106           -
LGA    -       -      T     107           -
LGA    -       -      I     108           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87   66    5.0     49    2.61    20.41     52.534     1.811

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.023331 * X  +   0.062165 * Y  +   0.997793 * Z  + -11.626121
  Y_new =   0.981627 * X  +  -0.187641 * Y  +   0.034644 * Z  +  -5.196844
  Z_new =   0.189380 * X  +   0.980269 * Y  +  -0.056645 * Z  + -11.085312 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.628517   -1.513076  [ DEG:    93.3072    -86.6928 ]
  Theta =  -0.190531   -2.951061  [ DEG:   -10.9166   -169.0834 ]
  Phi   =   1.594560   -1.547033  [ DEG:    91.3615    -88.6385 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gvp_A                                        
REMARK     2: T0468.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gvp_A.T0468.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87   66   5.0   49   2.61   20.41  52.534
REMARK  ---------------------------------------------------------- 
MOLECULE 1gvp_A
HEADER    DNA-BINDING PROTEIN                     26-FEB-97   1GVP              
TITLE     GENE V PROTEIN (SINGLE-STRANDED DNA BINDING PROTEIN)                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GENE V PROTEIN;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: K561;                                                        
SOURCE   4 GENE: GEN V IN BACTERIOPHAGE F1;                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: K561;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PTT2;                                      
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PTT2;                                     
SOURCE  10 EXPRESSION_SYSTEM_GENE: GEN V                                        
KEYWDS    DNA-BINDING PROTEIN, DNA REPLICATION                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SU,Y.-G.GAO,H.ZHANG,T.C.TERWILLIGER,A.H.-J.WANG                     
REVDAT   1   04-SEP-97 1GVP    0                                                
JRNL        AUTH   S.SU,Y.G.GAO,H.ZHANG,T.C.TERWILLIGER,A.H.WANG                
JRNL        TITL   ANALYSES OF THE STABILITY AND FUNCTION OF THREE              
JRNL        TITL 2 SURFACE MUTANTS (R82C, K69H, AND L32R) OF THE GENE           
JRNL        TITL 3 V PROTEIN FROM FF PHAGE BY X-RAY CRYSTALLOGRAPHY.            
JRNL        REF    PROTEIN SCI.                  V.   6   771 1997              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1GVP A    1    87  UNP    P69543   VHED_BPF1        1     87             
SEQRES   1 A   87  MET ILE LYS VAL GLU ILE LYS PRO SER GLN ALA GLN PHE          
SEQRES   2 A   87  THR THR ARG SER GLY VAL SER ARG GLN GLY LYS PRO TYR          
SEQRES   3 A   87  SER LEU ASN GLU GLN LEU CYS TYR VAL ASP LEU GLY ASN          
SEQRES   4 A   87  GLU TYR PRO VAL LEU VAL LYS ILE THR LEU ASP GLU GLY          
SEQRES   5 A   87  GLN PRO ALA TYR ALA PRO GLY LEU TYR THR VAL HIS LEU          
SEQRES   6 A   87  SER SER PHE LYS VAL GLY GLN PHE GLY SER LEU MET ILE          
SEQRES   7 A   87  ASP ARG LEU ARG LEU VAL PRO ALA LYS                          
FORMUL   2  HOH   *53(H2 O)                                                     
CRYST1   75.810   27.920   42.400  90.00 103.10  90.00 C 1 2 1       4          
ATOM      1  N   MET A   1      -7.206  -8.938   8.764  1.00 46.59           N  
ATOM      2  CA  MET A   1      -7.539  -9.750   7.586  1.00 45.10           C  
ATOM      3  C   MET A   1      -6.465  -9.573   6.523  1.00 39.57           C  
ATOM      4  O   MET A   1      -5.515 -10.332   6.612  1.00 41.65           O  
ATOM      5  CB  MET A   1      -8.893  -9.384   6.925  1.00 51.04           C  
ATOM      6  CG  MET A   1      -9.279 -10.262   5.689  1.00 58.23           C  
ATOM      7  SD  MET A   1     -10.643  -9.723   4.596  1.00 66.49           S  
ATOM      8  CE  MET A   1     -11.959 -10.758   5.193  1.00 62.60           C  
ATOM      9  H1  MET A   1      -7.105  -7.921   8.571  1.00 15.00           H  
ATOM     10  H2  MET A   1      -7.904  -8.985   9.537  1.00 15.00           H  
ATOM     11  H3  MET A   1      -6.295  -9.291   9.140  1.00 15.00           H  
ATOM     12  N   ILE A   2      -6.457  -8.643   5.555  1.00 34.39           N  
ATOM     13  CA  ILE A   2      -5.324  -8.609   4.631  1.00 28.36           C  
ATOM     14  C   ILE A   2      -4.228  -7.843   5.355  1.00 23.56           C  
ATOM     15  O   ILE A   2      -4.505  -6.804   5.939  1.00 22.42           O  
ATOM     16  CB  ILE A   2      -5.613  -7.876   3.255  1.00 29.44           C  
ATOM     17  CG1 ILE A   2      -6.702  -8.499   2.423  1.00 30.75           C  
ATOM     18  CG2 ILE A   2      -4.428  -8.093   2.341  1.00 29.56           C  
ATOM     19  CD1 ILE A   2      -8.090  -7.856   2.608  1.00 34.94           C  
ATOM     20  H   ILE A   2      -7.188  -8.007   5.441  1.00 15.00           H  
ATOM     21  N   LYS A   3      -3.044  -8.388   5.421  1.00 21.40           N  
ATOM     22  CA  LYS A   3      -1.891  -7.698   5.958  1.00 21.77           C  
ATOM     23  C   LYS A   3      -1.141  -6.937   4.840  1.00 19.66           C  
ATOM     24  O   LYS A   3      -0.695  -7.499   3.825  1.00 20.32           O  
ATOM     25  CB  LYS A   3      -0.968  -8.709   6.593  1.00 24.21           C  
ATOM     26  CG  LYS A   3       0.158  -8.057   7.359  1.00 29.28           C  
ATOM     27  CD  LYS A   3       1.133  -9.168   7.516  1.00 34.30           C  
ATOM     28  CE  LYS A   3       1.755  -9.172   8.897  1.00 39.45           C  
ATOM     29  NZ  LYS A   3       2.322 -10.486   9.184  1.00 44.69           N  
ATOM     30  H   LYS A   3      -2.960  -9.311   5.120  1.00 15.00           H  
ATOM     31  HZ1 LYS A   3       1.640 -11.214   8.860  1.00 15.00           H  
ATOM     32  HZ2 LYS A   3       3.204 -10.630   8.658  1.00 15.00           H  
ATOM     33  HZ3 LYS A   3       2.460 -10.573  10.214  1.00 15.00           H  
ATOM     34  N   VAL A   4      -1.034  -5.618   5.030  1.00 19.04           N  
ATOM     35  CA  VAL A   4      -0.325  -4.706   4.108  1.00 17.58           C  
ATOM     36  C   VAL A   4       0.819  -4.051   4.906  1.00 17.47           C  
ATOM     37  O   VAL A   4       0.710  -3.650   6.074  1.00 15.98           O  
ATOM     38  CB  VAL A   4      -1.254  -3.547   3.509  1.00 18.64           C  
ATOM     39  CG1 VAL A   4      -0.478  -2.788   2.412  1.00 16.78           C  
ATOM     40  CG2 VAL A   4      -2.586  -4.124   2.933  1.00 20.20           C  
ATOM     41  H   VAL A   4      -1.465  -5.236   5.826  1.00 15.00           H  
ATOM     42  N   GLU A   5       1.955  -3.990   4.250  1.00 16.58           N  
ATOM     43  CA  GLU A   5       3.119  -3.380   4.846  1.00 18.62           C  
ATOM     44  C   GLU A   5       3.761  -2.307   3.974  1.00 16.71           C  
ATOM     45  O   GLU A   5       4.006  -2.532   2.785  1.00 17.49           O  
ATOM     46  CB  GLU A   5       4.101  -4.479   5.145  1.00 20.67           C  
ATOM     47  CG  GLU A   5       5.186  -3.905   6.033  1.00 29.23           C  
ATOM     48  CD  GLU A   5       6.208  -4.881   6.587  1.00 34.71           C  
ATOM     49  OE1 GLU A   5       6.202  -6.086   6.283  1.00 36.25           O  
ATOM     50  OE2 GLU A   5       7.085  -4.389   7.300  1.00 35.48           O  
ATOM     51  H   GLU A   5       2.001  -4.372   3.355  1.00 15.00           H  
ATOM     52  N   ILE A   6       3.966  -1.105   4.493  1.00 15.90           N  
ATOM     53  CA  ILE A   6       4.779  -0.109   3.792  1.00 17.31           C  
ATOM     54  C   ILE A   6       6.204  -0.210   4.367  1.00 19.10           C  
ATOM     55  O   ILE A   6       6.386   0.059   5.552  1.00 20.23           O  
ATOM     56  CB  ILE A   6       4.290   1.338   4.033  1.00 17.13           C  
ATOM     57  CG1 ILE A   6       2.794   1.476   3.724  1.00 20.58           C  
ATOM     58  CG2 ILE A   6       5.185   2.296   3.185  1.00 16.11           C  
ATOM     59  CD1 ILE A   6       2.406   1.596   2.275  1.00 16.18           C  
ATOM     60  H   ILE A   6       3.586  -0.914   5.378  1.00 15.00           H  
ATOM     61  N   LYS A   7       7.202  -0.727   3.643  1.00 18.84           N  
ATOM     62  CA  LYS A   7       8.632  -0.747   4.050  1.00 18.39           C  
ATOM     63  C   LYS A   7       9.266   0.660   4.169  1.00 18.78           C  
ATOM     64  O   LYS A   7       8.702   1.642   3.609  1.00 18.21           O  
ATOM     65  CB  LYS A   7       9.440  -1.552   3.041  1.00 17.52           C  
ATOM     66  CG  LYS A   7       9.186  -3.035   2.939  1.00 20.38           C  
ATOM     67  CD  LYS A   7       9.321  -3.594   4.299  1.00 22.23           C  
ATOM     68  CE  LYS A   7       9.403  -5.106   4.321  1.00 27.97           C  
ATOM     69  NZ  LYS A   7       9.268  -5.555   5.704  1.00 33.30           N  
ATOM     70  H   LYS A   7       6.928  -1.279   2.892  1.00 15.00           H  
ATOM     71  HZ1 LYS A   7       9.919  -5.041   6.344  1.00 15.00           H  
ATOM     72  HZ2 LYS A   7       8.307  -5.343   6.077  1.00 15.00           H  
ATOM     73  HZ3 LYS A   7       9.397  -6.577   5.794  1.00 15.00           H  
ATOM     74  N   PRO A   8      10.410   0.866   4.868  1.00 17.97           N  
ATOM     75  CA  PRO A   8      11.133   2.150   4.898  1.00 16.71           C  
ATOM     76  C   PRO A   8      11.443   2.685   3.507  1.00 15.60           C  
ATOM     77  O   PRO A   8      11.364   3.890   3.253  1.00 18.40           O  
ATOM     78  CB  PRO A   8      12.335   1.834   5.723  1.00 15.38           C  
ATOM     79  CG  PRO A   8      11.747   0.893   6.739  1.00 17.56           C  
ATOM     80  CD  PRO A   8      11.015  -0.058   5.808  1.00 18.63           C  
ATOM     81  N   SER A   9      11.727   1.804   2.530  1.00 16.31           N  
ATOM     82  CA  SER A   9      11.971   2.165   1.115  1.00 18.75           C  
ATOM     83  C   SER A   9      10.771   2.633   0.298  1.00 18.69           C  
ATOM     84  O   SER A   9      10.910   3.191  -0.782  1.00 21.93           O  
ATOM     85  CB  SER A   9      12.549   1.014   0.323  1.00 21.29           C  
ATOM     86  OG  SER A   9      11.713  -0.131   0.288  1.00 24.36           O  
ATOM     87  H   SER A   9      11.839   0.867   2.802  1.00 15.00           H  
ATOM     88  HG  SER A   9      12.266  -0.913   0.100  1.00 15.00           H  
ATOM     89  N   GLN A  10       9.563   2.469   0.829  1.00 19.93           N  
ATOM     90  CA  GLN A  10       8.307   2.790   0.152  1.00 20.87           C  
ATOM     91  C   GLN A  10       7.570   3.973   0.750  1.00 22.68           C  
ATOM     92  O   GLN A  10       6.434   4.280   0.380  1.00 23.19           O  
ATOM     93  CB  GLN A  10       7.407   1.541   0.188  1.00 20.03           C  
ATOM     94  CG  GLN A  10       8.042   0.308  -0.471  1.00 17.82           C  
ATOM     95  CD  GLN A  10       7.286  -1.002  -0.302  1.00 17.59           C  
ATOM     96  OE1 GLN A  10       7.166  -1.818  -1.206  1.00 21.15           O  
ATOM     97  NE2 GLN A  10       6.714  -1.312   0.835  1.00 12.71           N  
ATOM     98  H   GLN A  10       9.522   2.074   1.724  1.00 15.00           H  
ATOM     99 HE21 GLN A  10       6.303  -2.196   0.842  1.00 15.00           H  
ATOM    100 HE22 GLN A  10       6.734  -0.635   1.527  1.00 15.00           H  
ATOM    101  N   ALA A  11       8.222   4.703   1.655  1.00 20.95           N  
ATOM    102  CA  ALA A  11       7.600   5.842   2.295  1.00 22.49           C  
ATOM    103  C   ALA A  11       7.290   7.052   1.432  1.00 24.17           C  
ATOM    104  O   ALA A  11       6.655   7.998   1.896  1.00 29.37           O  
ATOM    105  CB  ALA A  11       8.471   6.322   3.425  1.00 22.83           C  
ATOM    106  H   ALA A  11       9.123   4.432   1.926  1.00 15.00           H  
ATOM    107  N   GLN A  12       7.774   7.099   0.205  1.00 27.20           N  
ATOM    108  CA  GLN A  12       7.509   8.188  -0.738  1.00 30.66           C  
ATOM    109  C   GLN A  12       6.502   7.863  -1.849  1.00 27.50           C  
ATOM    110  O   GLN A  12       6.385   6.728  -2.307  1.00 28.21           O  
ATOM    111  CB  GLN A  12       8.849   8.638  -1.393  1.00 36.48           C  
ATOM    112  CG  GLN A  12       8.890   9.690  -2.574  1.00 47.72           C  
ATOM    113  CD  GLN A  12       8.403  11.143  -2.346  1.00 51.40           C  
ATOM    114  OE1 GLN A  12       7.251  11.449  -2.014  1.00 54.29           O  
ATOM    115  NE2 GLN A  12       9.237  12.152  -2.517  1.00 54.05           N  
ATOM    116  H   GLN A  12       8.308   6.344  -0.100  1.00 15.00           H  
ATOM    117 HE21 GLN A  12       8.821  13.020  -2.367  1.00 15.00           H  
ATOM    118 HE22 GLN A  12      10.158  11.983  -2.776  1.00 15.00           H  
ATOM    119  N   PHE A  13       5.763   8.835  -2.330  1.00 24.86           N  
ATOM    120  CA  PHE A  13       4.966   8.589  -3.510  1.00 24.76           C  
ATOM    121  C   PHE A  13       5.508   9.301  -4.754  1.00 26.18           C  
ATOM    122  O   PHE A  13       6.348  10.219  -4.722  1.00 26.71           O  
ATOM    123  CB  PHE A  13       3.557   9.033  -3.269  1.00 26.37           C  
ATOM    124  CG  PHE A  13       3.510  10.502  -2.967  1.00 31.79           C  
ATOM    125  CD1 PHE A  13       3.820  10.945  -1.680  1.00 36.52           C  
ATOM    126  CD2 PHE A  13       3.181  11.396  -3.972  1.00 29.23           C  
ATOM    127  CE1 PHE A  13       3.798  12.296  -1.405  1.00 37.41           C  
ATOM    128  CE2 PHE A  13       3.161  12.742  -3.693  1.00 31.10           C  
ATOM    129  CZ  PHE A  13       3.466  13.195  -2.416  1.00 37.48           C  
ATOM    130  H   PHE A  13       5.898   9.745  -1.996  1.00 15.00           H  
ATOM    131  N   THR A  14       5.065   8.866  -5.913  1.00 24.02           N  
ATOM    132  CA  THR A  14       5.416   9.583  -7.136  1.00 23.69           C  
ATOM    133  C   THR A  14       4.142  10.126  -7.712  1.00 21.57           C  
ATOM    134  O   THR A  14       3.069   9.686  -7.320  1.00 19.84           O  
ATOM    135  CB  THR A  14       6.122   8.676  -8.180  1.00 24.62           C  
ATOM    136  OG1 THR A  14       5.348   7.515  -8.463  1.00 24.56           O  
ATOM    137  CG2 THR A  14       7.470   8.224  -7.629  1.00 22.44           C  
ATOM    138  H   THR A  14       4.486   8.074  -5.936  1.00 15.00           H  
ATOM    139  HG1 THR A  14       4.664   7.756  -9.113  1.00 15.00           H  
ATOM    140  N   THR A  15       4.184  11.113  -8.576  1.00 19.99           N  
ATOM    141  CA  THR A  15       2.993  11.735  -9.120  1.00 20.27           C  
ATOM    142  C   THR A  15       2.928  11.619 -10.616  1.00 24.37           C  
ATOM    143  O   THR A  15       3.866  11.910 -11.363  1.00 24.36           O  
ATOM    144  CB  THR A  15       2.897  13.226  -8.835  1.00 16.22           C  
ATOM    145  OG1 THR A  15       2.950  13.298  -7.438  1.00 20.32           O  
ATOM    146  CG2 THR A  15       1.662  13.907  -9.316  1.00 17.74           C  
ATOM    147  H   THR A  15       5.067  11.438  -8.840  1.00 15.00           H  
ATOM    148  HG1 THR A  15       2.929  14.224  -7.126  1.00 15.00           H  
ATOM    149  N   ARG A  16       1.771  11.170 -11.045  1.00 26.71           N  
ATOM    150  CA  ARG A  16       1.401  11.101 -12.449  1.00 29.82           C  
ATOM    151  C   ARG A  16       0.499  12.272 -12.746  1.00 31.21           C  
ATOM    152  O   ARG A  16      -0.373  12.636 -11.966  1.00 29.93           O  
ATOM    153  CB  ARG A  16       0.522   9.955 -12.873  1.00 30.52           C  
ATOM    154  CG  ARG A  16       0.928   8.538 -12.997  1.00 31.33           C  
ATOM    155  CD  ARG A  16      -0.364   8.213 -13.704  1.00 34.75           C  
ATOM    156  NE  ARG A  16      -0.365   6.849 -14.147  1.00 40.04           N  
ATOM    157  CZ  ARG A  16      -0.716   6.454 -15.356  1.00 35.11           C  
ATOM    158  NH1 ARG A  16      -1.030   7.231 -16.376  1.00 31.80           N  
ATOM    159  NH2 ARG A  16      -0.622   5.192 -15.515  1.00 34.56           N  
ATOM    160  H   ARG A  16       1.127  10.866 -10.374  1.00 15.00           H  
ATOM    161  HE  ARG A  16      -0.082   6.183 -13.483  1.00 15.00           H  
ATOM    162 HH11 ARG A  16      -0.949   8.231 -16.268  1.00 15.00           H  
ATOM    163 HH12 ARG A  16      -1.239   6.854 -17.271  1.00 15.00           H  
ATOM    164 HH21 ARG A  16      -0.093   4.660 -14.845  1.00 15.00           H  
ATOM    165 HH22 ARG A  16      -0.800   4.809 -16.405  1.00 15.00           H  
ATOM    166  N   SER A  17       0.658  12.806 -13.936  1.00 37.65           N  
ATOM    167  CA  SER A  17      -0.201  13.903 -14.334  1.00 43.31           C  
ATOM    168  C   SER A  17      -0.816  13.758 -15.704  1.00 45.68           C  
ATOM    169  O   SER A  17      -0.620  12.760 -16.423  1.00 46.26           O  
ATOM    170  CB  SER A  17       0.576  15.181 -14.285  1.00 44.84           C  
ATOM    171  OG  SER A  17       1.080  15.307 -12.963  1.00 52.95           O  
ATOM    172  H   SER A  17       1.372  12.475 -14.525  1.00 15.00           H  
ATOM    173  HG  SER A  17       2.008  15.017 -12.971  1.00 15.00           H  
ATOM    174  N   GLY A  18      -1.712  14.703 -15.981  1.00 48.87           N  
ATOM    175  CA  GLY A  18      -2.329  14.771 -17.300  1.00 51.75           C  
ATOM    176  C   GLY A  18      -3.580  15.621 -17.390  1.00 52.80           C  
ATOM    177  O   GLY A  18      -3.901  16.388 -16.494  1.00 51.28           O  
ATOM    178  H   GLY A  18      -2.011  15.300 -15.257  1.00 15.00           H  
ATOM    179  N   VAL A  19      -4.298  15.434 -18.487  1.00 57.40           N  
ATOM    180  CA  VAL A  19      -5.526  16.162 -18.813  1.00 62.32           C  
ATOM    181  C   VAL A  19      -6.660  15.302 -19.423  1.00 64.36           C  
ATOM    182  O   VAL A  19      -6.483  14.526 -20.365  1.00 63.90           O  
ATOM    183  CB  VAL A  19      -5.126  17.347 -19.783  1.00 62.87           C  
ATOM    184  CG1 VAL A  19      -6.331  17.903 -20.546  1.00 64.71           C  
ATOM    185  CG2 VAL A  19      -4.581  18.516 -18.970  1.00 61.68           C  
ATOM    186  H   VAL A  19      -3.946  14.805 -19.156  1.00 15.00           H  
ATOM    187  N   SER A  20      -7.861  15.423 -18.871  1.00 67.85           N  
ATOM    188  CA  SER A  20      -9.086  14.813 -19.407  1.00 73.19           C  
ATOM    189  C   SER A  20      -9.438  15.226 -20.847  1.00 76.22           C  
ATOM    190  O   SER A  20      -9.193  16.380 -21.212  1.00 76.31           O  
ATOM    191  CB  SER A  20     -10.284  15.182 -18.509  1.00 73.34           C  
ATOM    192  OG  SER A  20     -11.560  14.945 -19.105  1.00 75.85           O  
ATOM    193  H   SER A  20      -7.893  15.938 -18.047  1.00 15.00           H  
ATOM    194  HG  SER A  20     -12.259  15.175 -18.468  1.00 15.00           H  
ATOM    195  N   ARG A  21     -10.035  14.408 -21.738  1.00 79.55           N  
ATOM    196  CA  ARG A  21     -10.458  14.871 -23.087  1.00 82.93           C  
ATOM    197  C   ARG A  21     -11.401  16.095 -23.049  1.00 83.06           C  
ATOM    198  O   ARG A  21     -11.630  16.824 -24.021  1.00 83.06           O  
ATOM    199  CB  ARG A  21     -11.248  13.829 -23.889  1.00 86.43           C  
ATOM    200  CG  ARG A  21     -10.929  12.371 -23.707  1.00 90.33           C  
ATOM    201  CD  ARG A  21     -11.935  11.392 -24.336  1.00 94.00           C  
ATOM    202  NE  ARG A  21     -13.347  11.556 -23.975  1.00 96.80           N  
ATOM    203  CZ  ARG A  21     -13.824  11.468 -22.739  1.00 98.28           C  
ATOM    204  NH1 ARG A  21     -13.074  11.253 -21.684  1.00 98.30           N  
ATOM    205  NH2 ARG A  21     -15.103  11.615 -22.528  1.00 98.83           N  
ATOM    206  H   ARG A  21     -10.107  13.470 -21.475  1.00 15.00           H  
ATOM    207  HE  ARG A  21     -13.982  11.791 -24.693  1.00 15.00           H  
ATOM    208 HH11 ARG A  21     -12.083  11.253 -21.758  1.00 15.00           H  
ATOM    209 HH12 ARG A  21     -13.517  11.395 -20.780  1.00 15.00           H  
ATOM    210 HH21 ARG A  21     -15.738  11.852 -23.254  1.00 15.00           H  
ATOM    211 HH22 ARG A  21     -15.403  11.612 -21.562  1.00 15.00           H  
ATOM    212  N   GLN A  22     -12.045  16.209 -21.888  1.00 83.11           N  
ATOM    213  CA  GLN A  22     -12.938  17.288 -21.501  1.00 83.29           C  
ATOM    214  C   GLN A  22     -12.183  18.518 -20.931  1.00 81.65           C  
ATOM    215  O   GLN A  22     -12.763  19.424 -20.325  1.00 82.70           O  
ATOM    216  CB  GLN A  22     -13.920  16.560 -20.540  1.00 85.45           C  
ATOM    217  CG  GLN A  22     -14.809  17.262 -19.512  1.00 88.61           C  
ATOM    218  CD  GLN A  22     -14.305  17.275 -18.062  1.00 90.43           C  
ATOM    219  OE1 GLN A  22     -13.264  16.759 -17.657  1.00 90.98           O  
ATOM    220  NE2 GLN A  22     -15.058  17.857 -17.158  1.00 89.60           N  
ATOM    221  H   GLN A  22     -11.903  15.500 -21.222  1.00 15.00           H  
ATOM    222 HE21 GLN A  22     -14.670  17.962 -16.265  1.00 15.00           H  
ATOM    223 HE22 GLN A  22     -15.932  18.175 -17.445  1.00 15.00           H  
ATOM    224  N   GLY A  23     -10.851  18.583 -21.099  1.00 79.06           N  
ATOM    225  CA  GLY A  23     -10.007  19.700 -20.665  1.00 75.14           C  
ATOM    226  C   GLY A  23      -9.353  19.614 -19.279  1.00 72.69           C  
ATOM    227  O   GLY A  23      -8.233  20.084 -19.099  1.00 72.51           O  
ATOM    228  H   GLY A  23     -10.414  17.845 -21.566  1.00 15.00           H  
ATOM    229  N   LYS A  24      -9.996  19.002 -18.275  1.00 70.90           N  
ATOM    230  CA  LYS A  24      -9.521  18.925 -16.880  1.00 68.12           C  
ATOM    231  C   LYS A  24      -8.180  18.253 -16.518  1.00 64.55           C  
ATOM    232  O   LYS A  24      -8.047  17.023 -16.580  1.00 65.20           O  
ATOM    233  CB  LYS A  24     -10.663  18.278 -16.083  1.00 70.32           C  
ATOM    234  CG  LYS A  24     -10.473  17.883 -14.618  1.00 74.77           C  
ATOM    235  CD  LYS A  24     -11.822  17.297 -14.206  1.00 79.35           C  
ATOM    236  CE  LYS A  24     -11.909  16.549 -12.869  1.00 81.61           C  
ATOM    237  NZ  LYS A  24     -13.302  16.298 -12.516  1.00 83.61           N  
ATOM    238  H   LYS A  24     -10.861  18.614 -18.514  1.00 15.00           H  
ATOM    239  HZ1 LYS A  24     -13.807  15.860 -13.309  1.00 15.00           H  
ATOM    240  HZ2 LYS A  24     -13.401  15.677 -11.691  1.00 15.00           H  
ATOM    241  HZ3 LYS A  24     -13.793  17.205 -12.318  1.00 15.00           H  
ATOM    242  N   PRO A  25      -7.147  18.986 -16.089  1.00 60.23           N  
ATOM    243  CA  PRO A  25      -5.933  18.425 -15.524  1.00 56.19           C  
ATOM    244  C   PRO A  25      -6.063  17.610 -14.241  1.00 52.34           C  
ATOM    245  O   PRO A  25      -6.682  18.007 -13.247  1.00 51.85           O  
ATOM    246  CB  PRO A  25      -5.025  19.621 -15.357  1.00 57.39           C  
ATOM    247  CG  PRO A  25      -5.990  20.750 -15.103  1.00 57.88           C  
ATOM    248  CD  PRO A  25      -7.065  20.441 -16.128  1.00 60.22           C  
ATOM    249  N   TYR A  26      -5.509  16.407 -14.295  1.00 47.66           N  
ATOM    250  CA  TYR A  26      -5.447  15.526 -13.141  1.00 42.13           C  
ATOM    251  C   TYR A  26      -4.024  15.317 -12.634  1.00 38.76           C  
ATOM    252  O   TYR A  26      -3.007  15.433 -13.325  1.00 37.64           O  
ATOM    253  CB  TYR A  26      -6.055  14.132 -13.456  1.00 40.62           C  
ATOM    254  CG  TYR A  26      -5.305  13.275 -14.468  1.00 41.19           C  
ATOM    255  CD1 TYR A  26      -4.252  12.429 -14.051  1.00 40.18           C  
ATOM    256  CD2 TYR A  26      -5.665  13.343 -15.819  1.00 40.60           C  
ATOM    257  CE1 TYR A  26      -3.556  11.660 -14.982  1.00 39.81           C  
ATOM    258  CE2 TYR A  26      -4.970  12.570 -16.755  1.00 42.10           C  
ATOM    259  CZ  TYR A  26      -3.926  11.743 -16.328  1.00 42.26           C  
ATOM    260  OH  TYR A  26      -3.238  11.013 -17.268  1.00 45.33           O  
ATOM    261  H   TYR A  26      -5.134  16.126 -15.147  1.00 15.00           H  
ATOM    262  HH  TYR A  26      -2.460  10.619 -16.853  1.00 15.00           H  
ATOM    263  N   SER A  27      -4.035  14.876 -11.396  1.00 36.36           N  
ATOM    264  CA  SER A  27      -2.819  14.529 -10.693  1.00 36.06           C  
ATOM    265  C   SER A  27      -3.093  13.293  -9.834  1.00 34.14           C  
ATOM    266  O   SER A  27      -4.091  13.219  -9.106  1.00 35.48           O  
ATOM    267  CB  SER A  27      -2.411  15.708  -9.836  1.00 38.72           C  
ATOM    268  OG  SER A  27      -1.150  15.522  -9.222  1.00 44.26           O  
ATOM    269  H   SER A  27      -4.893  14.785 -10.932  1.00 15.00           H  
ATOM    270  HG  SER A  27      -0.453  15.614  -9.883  1.00 15.00           H  
ATOM    271  N   LEU A  28      -2.302  12.236  -9.979  1.00 29.37           N  
ATOM    272  CA  LEU A  28      -2.488  11.016  -9.200  1.00 25.93           C  
ATOM    273  C   LEU A  28      -1.218  10.640  -8.463  1.00 23.14           C  
ATOM    274  O   LEU A  28      -0.153  10.544  -9.060  1.00 22.83           O  
ATOM    275  CB  LEU A  28      -2.811   9.824 -10.061  1.00 26.15           C  
ATOM    276  CG  LEU A  28      -3.986   9.852 -10.987  1.00 28.72           C  
ATOM    277  CD1 LEU A  28      -3.934   8.647 -11.940  1.00 27.22           C  
ATOM    278  CD2 LEU A  28      -5.235   9.886 -10.140  1.00 29.19           C  
ATOM    279  H   LEU A  28      -1.555  12.310 -10.600  1.00 15.00           H  
ATOM    280  N   ASN A  29      -1.337  10.390  -7.172  1.00 21.81           N  
ATOM    281  CA  ASN A  29      -0.229   9.944  -6.352  1.00 18.88           C  
ATOM    282  C   ASN A  29      -0.198   8.460  -6.183  1.00 18.54           C  
ATOM    283  O   ASN A  29      -1.214   7.841  -5.922  1.00 19.55           O  
ATOM    284  CB  ASN A  29      -0.311  10.603  -5.017  1.00 18.62           C  
ATOM    285  CG  ASN A  29      -0.209  12.112  -5.213  1.00 24.09           C  
ATOM    286  OD1 ASN A  29      -0.733  12.897  -4.424  1.00 28.37           O  
ATOM    287  ND2 ASN A  29       0.439  12.660  -6.231  1.00 19.72           N  
ATOM    288  H   ASN A  29      -2.227  10.526  -6.777  1.00 15.00           H  
ATOM    289 HD21 ASN A  29       0.369  13.634  -6.223  1.00 15.00           H  
ATOM    290 HD22 ASN A  29       0.946  12.146  -6.886  1.00 15.00           H  
ATOM    291  N   GLU A  30       0.927   7.840  -6.402  1.00 17.41           N  
ATOM    292  CA  GLU A  30       1.032   6.407  -6.301  1.00 19.98           C  
ATOM    293  C   GLU A  30       2.137   6.014  -5.321  1.00 20.70           C  
ATOM    294  O   GLU A  30       3.218   6.606  -5.253  1.00 20.94           O  
ATOM    295  CB  GLU A  30       1.367   5.777  -7.646  1.00 21.00           C  
ATOM    296  CG  GLU A  30       0.577   6.358  -8.804  1.00 31.16           C  
ATOM    297  CD  GLU A  30       0.808   5.712 -10.158  1.00 39.61           C  
ATOM    298  OE1 GLU A  30       1.933   5.320 -10.477  1.00 44.52           O  
ATOM    299  OE2 GLU A  30      -0.160   5.575 -10.913  1.00 47.23           O  
ATOM    300  H   GLU A  30       1.703   8.372  -6.677  1.00 15.00           H  
ATOM    301  N   GLN A  31       1.877   4.988  -4.549  1.00 17.03           N  
ATOM    302  CA  GLN A  31       2.865   4.460  -3.651  1.00 15.55           C  
ATOM    303  C   GLN A  31       2.922   2.935  -3.736  1.00 16.28           C  
ATOM    304  O   GLN A  31       1.942   2.282  -4.100  1.00 16.35           O  
ATOM    305  CB  GLN A  31       2.465   5.023  -2.291  1.00 14.13           C  
ATOM    306  CG  GLN A  31       3.252   4.527  -1.088  1.00 13.85           C  
ATOM    307  CD  GLN A  31       2.840   5.075   0.265  1.00 16.06           C  
ATOM    308  OE1 GLN A  31       1.744   5.570   0.525  1.00 16.20           O  
ATOM    309  NE2 GLN A  31       3.746   5.010   1.224  1.00 20.12           N  
ATOM    310  H   GLN A  31       0.986   4.581  -4.605  1.00 15.00           H  
ATOM    311 HE21 GLN A  31       3.475   5.334   2.106  1.00 15.00           H  
ATOM    312 HE22 GLN A  31       4.621   4.636   1.006  1.00 15.00           H  
ATOM    313  N   LEU A  32       4.066   2.328  -3.503  1.00 14.73           N  
ATOM    314  CA  LEU A  32       4.174   0.904  -3.448  1.00 15.17           C  
ATOM    315  C   LEU A  32       4.032   0.342  -2.048  1.00 14.50           C  
ATOM    316  O   LEU A  32       4.196   1.029  -1.045  1.00 13.85           O  
ATOM    317  CB  LEU A  32       5.496   0.476  -4.026  1.00 16.91           C  
ATOM    318  CG  LEU A  32       5.668   0.821  -5.500  1.00 23.41           C  
ATOM    319  CD1 LEU A  32       7.024   0.363  -5.907  1.00 26.30           C  
ATOM    320  CD2 LEU A  32       4.652   0.115  -6.394  1.00 25.30           C  
ATOM    321  H   LEU A  32       4.851   2.884  -3.313  1.00 15.00           H  
ATOM    322  N   CYS A  33       3.627  -0.914  -1.984  1.00 13.68           N  
ATOM    323  CA  CYS A  33       3.485  -1.625  -0.733  1.00 13.82           C  
ATOM    324  C   CYS A  33       3.598  -3.097  -0.944  1.00 12.95           C  
ATOM    325  O   CYS A  33       3.727  -3.571  -2.066  1.00 16.29           O  
ATOM    326  CB  CYS A  33       2.141  -1.372  -0.024  1.00 19.99           C  
ATOM    327  SG  CYS A  33       0.638  -1.979  -0.866  1.00 17.75           S  
ATOM    328  H   CYS A  33       3.358  -1.352  -2.821  1.00 15.00           H  
ATOM    329  N   TYR A  34       3.648  -3.819   0.164  1.00 14.67           N  
ATOM    330  CA  TYR A  34       3.681  -5.264   0.158  1.00 16.20           C  
ATOM    331  C   TYR A  34       2.417  -5.824   0.755  1.00 17.19           C  
ATOM    332  O   TYR A  34       1.971  -5.402   1.810  1.00 18.20           O  
ATOM    333  CB  TYR A  34       4.832  -5.815   0.976  1.00 19.14           C  
ATOM    334  CG  TYR A  34       6.101  -5.748   0.171  1.00 19.36           C  
ATOM    335  CD1 TYR A  34       6.295  -6.649  -0.870  1.00 20.02           C  
ATOM    336  CD2 TYR A  34       7.057  -4.791   0.493  1.00 20.88           C  
ATOM    337  CE1 TYR A  34       7.465  -6.611  -1.611  1.00 23.23           C  
ATOM    338  CE2 TYR A  34       8.234  -4.739  -0.247  1.00 23.76           C  
ATOM    339  CZ  TYR A  34       8.426  -5.651  -1.292  1.00 25.33           C  
ATOM    340  OH  TYR A  34       9.583  -5.598  -2.030  1.00 27.97           O  
ATOM    341  H   TYR A  34       3.662  -3.355   1.026  1.00 15.00           H  
ATOM    342  HH  TYR A  34      10.072  -4.802  -1.792  1.00 15.00           H  
ATOM    343  N   VAL A  35       1.807  -6.741   0.039  1.00 16.20           N  
ATOM    344  CA  VAL A  35       0.573  -7.344   0.479  1.00 17.18           C  
ATOM    345  C   VAL A  35       0.791  -8.848   0.651  1.00 15.59           C  
ATOM    346  O   VAL A  35       1.294  -9.549  -0.241  1.00 13.55           O  
ATOM    347  CB  VAL A  35      -0.542  -6.979  -0.605  1.00 20.01           C  
ATOM    348  CG1 VAL A  35      -1.908  -7.630  -0.297  1.00 21.74           C  
ATOM    349  CG2 VAL A  35      -0.812  -5.470  -0.556  1.00 17.65           C  
ATOM    350  H   VAL A  35       2.180  -6.978  -0.832  1.00 15.00           H  
ATOM    351  N   ASP A  36       0.451  -9.367   1.826  1.00 16.06           N  
ATOM    352  CA  ASP A  36       0.585 -10.793   2.006  1.00 19.12           C  
ATOM    353  C   ASP A  36      -0.656 -11.507   1.464  1.00 21.00           C  
ATOM    354  O   ASP A  36      -1.773 -11.380   1.956  1.00 18.77           O  
ATOM    355  CB  ASP A  36       0.752 -11.102   3.459  1.00 23.22           C  
ATOM    356  CG  ASP A  36       1.112 -12.547   3.768  1.00 27.26           C  
ATOM    357  OD1 ASP A  36       1.382 -13.368   2.871  1.00 26.36           O  
ATOM    358  OD2 ASP A  36       1.096 -12.817   4.971  1.00 34.91           O  
ATOM    359  H   ASP A  36       0.158  -8.795   2.568  1.00 15.00           H  
ATOM    360  N   LEU A  37      -0.470 -12.190   0.352  1.00 23.67           N  
ATOM    361  CA  LEU A  37      -1.559 -12.975  -0.205  1.00 27.30           C  
ATOM    362  C   LEU A  37      -1.463 -14.447   0.186  1.00 28.23           C  
ATOM    363  O   LEU A  37      -2.208 -15.317  -0.266  1.00 29.72           O  
ATOM    364  CB  LEU A  37      -1.516 -12.752  -1.710  1.00 24.69           C  
ATOM    365  CG  LEU A  37      -2.620 -11.921  -2.324  1.00 25.41           C  
ATOM    366  CD1 LEU A  37      -3.263 -10.928  -1.373  1.00 19.82           C  
ATOM    367  CD2 LEU A  37      -1.984 -11.308  -3.534  1.00 23.02           C  
ATOM    368  H   LEU A  37       0.407 -12.140  -0.088  1.00 15.00           H  
ATOM    369  N   GLY A  38      -0.577 -14.708   1.137  1.00 29.82           N  
ATOM    370  CA  GLY A  38      -0.327 -16.045   1.603  1.00 33.02           C  
ATOM    371  C   GLY A  38       0.589 -16.829   0.692  1.00 35.93           C  
ATOM    372  O   GLY A  38       0.531 -18.058   0.647  1.00 39.29           O  
ATOM    373  H   GLY A  38      -0.132 -13.975   1.615  1.00 15.00           H  
ATOM    374  N   ASN A  39       1.401 -16.172  -0.124  1.00 38.05           N  
ATOM    375  CA  ASN A  39       2.400 -16.889  -0.931  1.00 39.77           C  
ATOM    376  C   ASN A  39       3.716 -17.070  -0.111  1.00 39.94           C  
ATOM    377  O   ASN A  39       3.740 -16.756   1.084  1.00 39.23           O  
ATOM    378  CB  ASN A  39       2.678 -16.080  -2.220  1.00 46.82           C  
ATOM    379  CG  ASN A  39       1.445 -15.535  -2.970  1.00 52.01           C  
ATOM    380  OD1 ASN A  39       0.574 -16.269  -3.420  1.00 54.50           O  
ATOM    381  ND2 ASN A  39       1.211 -14.250  -3.153  1.00 50.84           N  
ATOM    382  H   ASN A  39       1.327 -15.199  -0.149  1.00 15.00           H  
ATOM    383 HD21 ASN A  39       0.421 -14.085  -3.696  1.00 15.00           H  
ATOM    384 HD22 ASN A  39       1.795 -13.585  -2.747  1.00 15.00           H  
ATOM    385  N   GLU A  40       4.853 -17.549  -0.649  1.00 38.67           N  
ATOM    386  CA  GLU A  40       6.151 -17.586   0.061  1.00 37.14           C  
ATOM    387  C   GLU A  40       6.481 -16.266   0.745  1.00 32.57           C  
ATOM    388  O   GLU A  40       6.823 -16.170   1.921  1.00 34.42           O  
ATOM    389  CB  GLU A  40       7.350 -17.815  -0.864  1.00 42.57           C  
ATOM    390  CG  GLU A  40       7.234 -18.811  -1.995  1.00 52.63           C  
ATOM    391  CD  GLU A  40       6.957 -20.214  -1.501  1.00 58.80           C  
ATOM    392  OE1 GLU A  40       7.433 -20.575  -0.420  1.00 61.77           O  
ATOM    393  OE2 GLU A  40       6.265 -20.964  -2.198  1.00 62.97           O  
ATOM    394  H   GLU A  40       4.792 -17.997  -1.515  1.00 15.00           H  
ATOM    395  N   TYR A  41       6.457 -15.233  -0.087  1.00 28.33           N  
ATOM    396  CA  TYR A  41       6.722 -13.880   0.347  1.00 26.62           C  
ATOM    397  C   TYR A  41       5.562 -12.960  -0.018  1.00 26.22           C  
ATOM    398  O   TYR A  41       4.735 -13.304  -0.878  1.00 30.29           O  
ATOM    399  CB  TYR A  41       8.032 -13.373  -0.296  1.00 24.74           C  
ATOM    400  CG  TYR A  41       9.232 -14.137   0.230  1.00 22.70           C  
ATOM    401  CD1 TYR A  41       9.768 -13.871   1.491  1.00 22.56           C  
ATOM    402  CD2 TYR A  41       9.751 -15.161  -0.546  1.00 21.35           C  
ATOM    403  CE1 TYR A  41      10.818 -14.655   1.974  1.00 20.79           C  
ATOM    404  CE2 TYR A  41      10.791 -15.938  -0.073  1.00 20.95           C  
ATOM    405  CZ  TYR A  41      11.310 -15.681   1.174  1.00 21.30           C  
ATOM    406  OH  TYR A  41      12.330 -16.498   1.629  1.00 31.20           O  
ATOM    407  H   TYR A  41       6.237 -15.409  -1.023  1.00 15.00           H  
ATOM    408  HH  TYR A  41      12.831 -16.850   0.883  1.00 15.00           H  
ATOM    409  N   PRO A  42       5.407 -11.792   0.583  1.00 25.23           N  
ATOM    410  CA  PRO A  42       4.456 -10.779   0.173  1.00 23.74           C  
ATOM    411  C   PRO A  42       4.673 -10.327  -1.256  1.00 24.55           C  
ATOM    412  O   PRO A  42       5.756 -10.436  -1.822  1.00 24.31           O  
ATOM    413  CB  PRO A  42       4.651  -9.656   1.155  1.00 25.93           C  
ATOM    414  CG  PRO A  42       5.228 -10.316   2.380  1.00 25.25           C  
ATOM    415  CD  PRO A  42       6.113 -11.381   1.791  1.00 25.57           C  
ATOM    416  N   VAL A  43       3.635  -9.812  -1.875  1.00 22.90           N  
ATOM    417  CA  VAL A  43       3.736  -9.349  -3.227  1.00 21.40           C  
ATOM    418  C   VAL A  43       3.739  -7.836  -3.280  1.00 18.24           C  
ATOM    419  O   VAL A  43       3.181  -7.187  -2.400  1.00 18.66           O  
ATOM    420  CB  VAL A  43       2.550  -9.955  -4.039  1.00 25.82           C  
ATOM    421  CG1 VAL A  43       2.779 -11.481  -4.176  1.00 29.07           C  
ATOM    422  CG2 VAL A  43       1.201  -9.642  -3.359  1.00 25.34           C  
ATOM    423  H   VAL A  43       2.796  -9.728  -1.380  1.00 15.00           H  
ATOM    424  N   LEU A  44       4.374  -7.259  -4.297  1.00 19.90           N  
ATOM    425  CA  LEU A  44       4.397  -5.819  -4.464  1.00 20.15           C  
ATOM    426  C   LEU A  44       3.161  -5.343  -5.229  1.00 18.22           C  
ATOM    427  O   LEU A  44       2.832  -5.807  -6.328  1.00 20.14           O  
ATOM    428  CB  LEU A  44       5.659  -5.437  -5.212  1.00 22.25           C  
ATOM    429  CG  LEU A  44       6.474  -4.172  -4.988  1.00 27.63           C  
ATOM    430  CD1 LEU A  44       6.886  -3.802  -6.394  1.00 30.33           C  
ATOM    431  CD2 LEU A  44       5.761  -2.978  -4.386  1.00 28.28           C  
ATOM    432  H   LEU A  44       4.791  -7.831  -4.972  1.00 15.00           H  
ATOM    433  N   VAL A  45       2.515  -4.364  -4.626  1.00 14.86           N  
ATOM    434  CA  VAL A  45       1.277  -3.776  -5.086  1.00 14.86           C  
ATOM    435  C   VAL A  45       1.369  -2.259  -5.163  1.00 16.23           C  
ATOM    436  O   VAL A  45       1.872  -1.569  -4.276  1.00 17.21           O  
ATOM    437  CB  VAL A  45       0.148  -4.265  -4.086  1.00 12.49           C  
ATOM    438  CG1 VAL A  45      -1.128  -3.517  -4.191  1.00 14.66           C  
ATOM    439  CG2 VAL A  45      -0.267  -5.667  -4.457  1.00 15.95           C  
ATOM    440  H   VAL A  45       2.920  -4.024  -3.799  1.00 15.00           H  
ATOM    441  N   LYS A  46       0.869  -1.687  -6.231  1.00 16.56           N  
ATOM    442  CA  LYS A  46       0.737  -0.259  -6.317  1.00 20.12           C  
ATOM    443  C   LYS A  46      -0.633   0.304  -5.878  1.00 19.39           C  
ATOM    444  O   LYS A  46      -1.719  -0.102  -6.288  1.00 18.14           O  
ATOM    445  CB  LYS A  46       1.099   0.146  -7.768  1.00 26.14           C  
ATOM    446  CG  LYS A  46       1.151   1.668  -7.898  1.00 35.88           C  
ATOM    447  CD  LYS A  46       2.021   2.259  -9.025  1.00 45.49           C  
ATOM    448  CE  LYS A  46       3.280   2.925  -8.414  1.00 50.13           C  
ATOM    449  NZ  LYS A  46       3.859   4.021  -9.178  1.00 51.95           N  
ATOM    450  H   LYS A  46       0.574  -2.270  -6.963  1.00 15.00           H  
ATOM    451  HZ1 LYS A  46       4.145   3.750 -10.131  1.00 15.00           H  
ATOM    452  HZ2 LYS A  46       3.156   4.784  -9.280  1.00 15.00           H  
ATOM    453  HZ3 LYS A  46       4.669   4.407  -8.647  1.00 15.00           H  
ATOM    454  N   ILE A  47      -0.593   1.233  -4.934  1.00 19.31           N  
ATOM    455  CA  ILE A  47      -1.718   2.008  -4.403  1.00 21.75           C  
ATOM    456  C   ILE A  47      -1.857   3.367  -5.148  1.00 22.99           C  
ATOM    457  O   ILE A  47      -0.850   4.003  -5.490  1.00 19.08           O  
ATOM    458  CB  ILE A  47      -1.518   2.330  -2.876  1.00 23.58           C  
ATOM    459  CG1 ILE A  47      -1.324   1.114  -2.024  1.00 26.46           C  
ATOM    460  CG2 ILE A  47      -2.775   2.951  -2.332  1.00 29.37           C  
ATOM    461  CD1 ILE A  47      -0.820   1.604  -0.641  1.00 23.74           C  
ATOM    462  H   ILE A  47       0.291   1.389  -4.540  1.00 15.00           H  
ATOM    463  N   THR A  48      -3.076   3.795  -5.521  1.00 23.68           N  
ATOM    464  CA  THR A  48      -3.317   5.184  -5.942  1.00 25.22           C  
ATOM    465  C   THR A  48      -4.007   5.819  -4.758  1.00 26.42           C  
ATOM    466  O   THR A  48      -5.087   5.416  -4.321  1.00 27.16           O  
ATOM    467  CB  THR A  48      -4.311   5.469  -7.111  1.00 27.36           C  
ATOM    468  OG1 THR A  48      -3.903   4.704  -8.243  1.00 30.54           O  
ATOM    469  CG2 THR A  48      -4.288   6.938  -7.559  1.00 27.75           C  
ATOM    470  H   THR A  48      -3.817   3.156  -5.481  1.00 15.00           H  
ATOM    471  HG1 THR A  48      -4.668   4.822  -8.852  1.00 15.00           H  
ATOM    472  N   LEU A  49      -3.354   6.812  -4.192  1.00 25.22           N  
ATOM    473  CA  LEU A  49      -3.873   7.551  -3.051  1.00 26.51           C  
ATOM    474  C   LEU A  49      -5.085   8.400  -3.411  1.00 27.69           C  
ATOM    475  O   LEU A  49      -5.309   8.733  -4.592  1.00 28.89           O  
ATOM    476  CB  LEU A  49      -2.762   8.478  -2.464  1.00 25.80           C  
ATOM    477  CG  LEU A  49      -1.605   8.000  -1.542  1.00 26.40           C  
ATOM    478  CD1 LEU A  49      -1.224   6.565  -1.791  1.00 26.28           C  
ATOM    479  CD2 LEU A  49      -0.400   8.911  -1.779  1.00 23.62           C  
ATOM    480  H   LEU A  49      -2.485   7.063  -4.572  1.00 15.00           H  
ATOM    481  N   ASP A  50      -5.932   8.719  -2.441  1.00 29.56           N  
ATOM    482  CA  ASP A  50      -6.988   9.681  -2.685  1.00 31.43           C  
ATOM    483  C   ASP A  50      -6.514  11.130  -2.767  1.00 34.69           C  
ATOM    484  O   ASP A  50      -5.476  11.469  -2.216  1.00 32.27           O  
ATOM    485  CB  ASP A  50      -8.010   9.578  -1.597  1.00 30.14           C  
ATOM    486  CG  ASP A  50      -8.846   8.334  -1.707  1.00 29.23           C  
ATOM    487  OD1 ASP A  50      -9.294   7.962  -2.790  1.00 28.36           O  
ATOM    488  OD2 ASP A  50      -9.150   7.779  -0.671  1.00 33.06           O  
ATOM    489  H   ASP A  50      -5.866   8.274  -1.568  1.00 15.00           H  
ATOM    490  N   GLU A  51      -7.261  11.993  -3.464  1.00 40.56           N  
ATOM    491  CA  GLU A  51      -6.996  13.427  -3.509  1.00 45.16           C  
ATOM    492  C   GLU A  51      -6.692  13.955  -2.105  1.00 46.83           C  
ATOM    493  O   GLU A  51      -7.366  13.596  -1.129  1.00 47.33           O  
ATOM    494  CB  GLU A  51      -8.219  14.173  -4.069  1.00 51.48           C  
ATOM    495  CG  GLU A  51      -8.151  15.735  -4.124  1.00 61.72           C  
ATOM    496  CD  GLU A  51      -9.389  16.523  -4.602  1.00 67.12           C  
ATOM    497  OE1 GLU A  51     -10.381  15.967  -5.101  1.00 72.57           O  
ATOM    498  OE2 GLU A  51      -9.376  17.759  -4.557  1.00 69.25           O  
ATOM    499  H   GLU A  51      -8.040  11.647  -3.934  1.00 15.00           H  
ATOM    500  N   GLY A  52      -5.558  14.642  -1.965  1.00 46.99           N  
ATOM    501  CA  GLY A  52      -5.224  15.284  -0.700  1.00 47.73           C  
ATOM    502  C   GLY A  52      -4.740  14.419   0.466  1.00 49.76           C  
ATOM    503  O   GLY A  52      -4.463  14.948   1.554  1.00 52.27           O  
ATOM    504  H   GLY A  52      -4.944  14.663  -2.723  1.00 15.00           H  
ATOM    505  N   GLN A  53      -4.621  13.094   0.351  1.00 50.06           N  
ATOM    506  CA  GLN A  53      -4.020  12.367   1.458  1.00 48.01           C  
ATOM    507  C   GLN A  53      -2.534  12.073   1.210  1.00 44.46           C  
ATOM    508  O   GLN A  53      -2.073  11.908   0.072  1.00 42.17           O  
ATOM    509  CB  GLN A  53      -4.831  11.092   1.714  1.00 50.78           C  
ATOM    510  CG  GLN A  53      -4.721   9.931   0.777  1.00 57.94           C  
ATOM    511  CD  GLN A  53      -5.338   8.710   1.429  1.00 62.01           C  
ATOM    512  OE1 GLN A  53      -6.142   7.983   0.846  1.00 65.83           O  
ATOM    513  NE2 GLN A  53      -5.013   8.417   2.679  1.00 63.41           N  
ATOM    514  H   GLN A  53      -4.950  12.639  -0.456  1.00 15.00           H  
ATOM    515 HE21 GLN A  53      -5.466   7.622   3.017  1.00 15.00           H  
ATOM    516 HE22 GLN A  53      -4.372   8.961   3.171  1.00 15.00           H  
ATOM    517  N   PRO A  54      -1.678  12.153   2.231  1.00 42.29           N  
ATOM    518  CA  PRO A  54      -0.244  11.941   2.082  1.00 39.37           C  
ATOM    519  C   PRO A  54       0.117  10.487   1.909  1.00 33.96           C  
ATOM    520  O   PRO A  54      -0.725   9.607   2.056  1.00 33.78           O  
ATOM    521  CB  PRO A  54       0.358  12.559   3.340  1.00 40.66           C  
ATOM    522  CG  PRO A  54      -0.726  12.307   4.375  1.00 41.37           C  
ATOM    523  CD  PRO A  54      -1.971  12.677   3.570  1.00 43.22           C  
ATOM    524  N   ALA A  55       1.375  10.251   1.589  1.00 29.58           N  
ATOM    525  CA  ALA A  55       1.896   8.904   1.617  1.00 27.72           C  
ATOM    526  C   ALA A  55       1.695   8.281   3.008  1.00 27.22           C  
ATOM    527  O   ALA A  55       1.764   8.938   4.066  1.00 27.42           O  
ATOM    528  CB  ALA A  55       3.395   8.860   1.342  1.00 26.13           C  
ATOM    529  H   ALA A  55       1.944  10.998   1.324  1.00 15.00           H  
ATOM    530  N   TYR A  56       1.321   7.011   2.982  1.00 23.54           N  
ATOM    531  CA  TYR A  56       1.258   6.227   4.189  1.00 19.81           C  
ATOM    532  C   TYR A  56       2.662   6.113   4.780  1.00 23.00           C  
ATOM    533  O   TYR A  56       3.598   5.841   4.007  1.00 21.67           O  
ATOM    534  CB  TYR A  56       0.788   4.836   3.878  1.00 18.15           C  
ATOM    535  CG  TYR A  56      -0.654   4.826   3.463  1.00 17.86           C  
ATOM    536  CD1 TYR A  56      -1.629   4.973   4.448  1.00 18.45           C  
ATOM    537  CD2 TYR A  56      -1.006   4.656   2.131  1.00 19.25           C  
ATOM    538  CE1 TYR A  56      -2.974   4.949   4.105  1.00 16.20           C  
ATOM    539  CE2 TYR A  56      -2.355   4.626   1.780  1.00 18.87           C  
ATOM    540  CZ  TYR A  56      -3.320   4.774   2.779  1.00 17.75           C  
ATOM    541  OH  TYR A  56      -4.645   4.744   2.453  1.00 18.96           O  
ATOM    542  H   TYR A  56       1.115   6.605   2.114  1.00 15.00           H  
ATOM    543  HH  TYR A  56      -4.690   4.818   1.478  1.00 15.00           H  
ATOM    544  N   ALA A  57       2.836   6.361   6.082  1.00 20.92           N  
ATOM    545  CA  ALA A  57       4.124   6.117   6.734  1.00 23.06           C  
ATOM    546  C   ALA A  57       4.511   4.627   6.806  1.00 24.48           C  
ATOM    547  O   ALA A  57       3.610   3.767   6.822  1.00 24.88           O  
ATOM    548  CB  ALA A  57       4.078   6.654   8.137  1.00 22.48           C  
ATOM    549  H   ALA A  57       2.058   6.626   6.609  1.00 15.00           H  
ATOM    550  N   PRO A  58       5.786   4.199   6.832  1.00 23.79           N  
ATOM    551  CA  PRO A  58       6.149   2.793   6.988  1.00 23.26           C  
ATOM    552  C   PRO A  58       5.457   2.172   8.199  1.00 23.04           C  
ATOM    553  O   PRO A  58       5.189   2.817   9.225  1.00 22.30           O  
ATOM    554  CB  PRO A  58       7.674   2.788   7.091  1.00 24.97           C  
ATOM    555  CG  PRO A  58       8.031   4.012   6.284  1.00 24.24           C  
ATOM    556  CD  PRO A  58       6.982   5.033   6.723  1.00 22.61           C  
ATOM    557  N   GLY A  59       5.121   0.911   8.041  1.00 21.52           N  
ATOM    558  CA  GLY A  59       4.378   0.212   9.063  1.00 19.59           C  
ATOM    559  C   GLY A  59       3.373  -0.786   8.486  1.00 17.46           C  
ATOM    560  O   GLY A  59       3.349  -1.070   7.301  1.00 15.02           O  
ATOM    561  H   GLY A  59       5.329   0.475   7.189  1.00 15.00           H  
ATOM    562  N   LEU A  60       2.624  -1.385   9.420  1.00 20.14           N  
ATOM    563  CA  LEU A  60       1.577  -2.373   9.168  1.00 18.29           C  
ATOM    564  C   LEU A  60       0.172  -1.805   9.149  1.00 16.25           C  
ATOM    565  O   LEU A  60      -0.249  -0.937   9.936  1.00 16.20           O  
ATOM    566  CB  LEU A  60       1.668  -3.470  10.200  1.00 19.70           C  
ATOM    567  CG  LEU A  60       2.940  -4.279  10.121  1.00 19.91           C  
ATOM    568  CD1 LEU A  60       2.958  -5.262  11.262  1.00 25.39           C  
ATOM    569  CD2 LEU A  60       3.013  -5.058   8.833  1.00 22.99           C  
ATOM    570  H   LEU A  60       2.907  -1.210  10.342  1.00 15.00           H  
ATOM    571  N   TYR A  61      -0.561  -2.234   8.142  1.00 16.32           N  
ATOM    572  CA  TYR A  61      -1.879  -1.711   7.874  1.00 14.04           C  
ATOM    573  C   TYR A  61      -2.781  -2.871   7.498  1.00 16.79           C  
ATOM    574  O   TYR A  61      -2.364  -3.975   7.133  1.00 16.19           O  
ATOM    575  CB  TYR A  61      -1.879  -0.719   6.676  1.00 17.14           C  
ATOM    576  CG  TYR A  61      -1.073   0.550   6.861  1.00 17.37           C  
ATOM    577  CD1 TYR A  61       0.301   0.558   6.639  1.00 16.22           C  
ATOM    578  CD2 TYR A  61      -1.740   1.699   7.292  1.00 19.52           C  
ATOM    579  CE1 TYR A  61       1.011   1.746   6.858  1.00 18.70           C  
ATOM    580  CE2 TYR A  61      -1.041   2.889   7.516  1.00 21.57           C  
ATOM    581  CZ  TYR A  61       0.350   2.902   7.289  1.00 21.30           C  
ATOM    582  OH  TYR A  61       1.048   4.079   7.482  1.00 20.67           O  
ATOM    583  H   TYR A  61      -0.198  -2.936   7.560  1.00 15.00           H  
ATOM    584  HH  TYR A  61       0.451   4.839   7.530  1.00 15.00           H  
ATOM    585  N   THR A  62      -4.051  -2.583   7.620  1.00 17.80           N  
ATOM    586  CA  THR A  62      -4.989  -3.509   7.028  1.00 21.41           C  
ATOM    587  C   THR A  62      -5.902  -2.700   6.099  1.00 21.88           C  
ATOM    588  O   THR A  62      -5.800  -1.461   6.017  1.00 19.19           O  
ATOM    589  CB  THR A  62      -5.771  -4.254   8.152  1.00 22.89           C  
ATOM    590  OG1 THR A  62      -6.331  -5.428   7.516  1.00 30.36           O  
ATOM    591  CG2 THR A  62      -6.802  -3.393   8.836  1.00 20.31           C  
ATOM    592  H   THR A  62      -4.341  -1.737   8.022  1.00 15.00           H  
ATOM    593  HG1 THR A  62      -5.556  -5.864   7.123  1.00 15.00           H  
ATOM    594  N   VAL A  63      -6.776  -3.383   5.340  1.00 23.04           N  
ATOM    595  CA  VAL A  63      -7.685  -2.760   4.348  1.00 25.37           C  
ATOM    596  C   VAL A  63      -9.022  -2.223   4.895  1.00 24.31           C  
ATOM    597  O   VAL A  63      -9.805  -2.868   5.586  1.00 25.59           O  
ATOM    598  CB  VAL A  63      -7.948  -3.794   3.183  1.00 26.01           C  
ATOM    599  CG1 VAL A  63      -8.896  -3.288   2.094  1.00 23.88           C  
ATOM    600  CG2 VAL A  63      -6.592  -4.033   2.504  1.00 27.03           C  
ATOM    601  H   VAL A  63      -6.835  -4.343   5.508  1.00 15.00           H  
ATOM    602  N   HIS A  64      -9.301  -0.961   4.666  1.00 21.34           N  
ATOM    603  CA  HIS A  64     -10.522  -0.365   5.130  1.00 21.58           C  
ATOM    604  C   HIS A  64     -11.714  -0.743   4.212  1.00 22.70           C  
ATOM    605  O   HIS A  64     -11.603  -0.759   2.987  1.00 18.12           O  
ATOM    606  CB  HIS A  64     -10.276   1.131   5.196  1.00 23.11           C  
ATOM    607  CG  HIS A  64     -11.472   1.924   5.709  1.00 24.83           C  
ATOM    608  ND1 HIS A  64     -12.387   2.499   4.957  1.00 28.28           N  
ATOM    609  CD2 HIS A  64     -11.836   2.156   7.016  1.00 31.58           C  
ATOM    610  CE1 HIS A  64     -13.300   3.069   5.704  1.00 31.54           C  
ATOM    611  NE2 HIS A  64     -12.951   2.858   6.947  1.00 33.71           N  
ATOM    612  H   HIS A  64      -8.638  -0.463   4.147  1.00 15.00           H  
ATOM    613  HD1 HIS A  64     -12.340   2.546   3.987  1.00 15.00           H  
ATOM    614  HE2 HIS A  64     -13.368   3.366   7.691  1.00 15.00           H  
ATOM    615  N   LEU A  65     -12.894  -1.034   4.765  1.00 21.19           N  
ATOM    616  CA  LEU A  65     -14.079  -1.318   3.952  1.00 22.09           C  
ATOM    617  C   LEU A  65     -14.401  -0.478   2.746  1.00 19.51           C  
ATOM    618  O   LEU A  65     -14.868  -0.979   1.739  1.00 20.91           O  
ATOM    619  CB  LEU A  65     -15.367  -1.262   4.744  1.00 22.80           C  
ATOM    620  CG  LEU A  65     -15.931  -2.525   5.298  1.00 24.27           C  
ATOM    621  CD1 LEU A  65     -17.346  -2.133   5.700  1.00 23.65           C  
ATOM    622  CD2 LEU A  65     -15.856  -3.698   4.327  1.00 21.18           C  
ATOM    623  H   LEU A  65     -12.923  -1.213   5.727  1.00 15.00           H  
ATOM    624  N   SER A  66     -14.222   0.835   2.839  1.00 20.32           N  
ATOM    625  CA  SER A  66     -14.408   1.738   1.702  1.00 18.70           C  
ATOM    626  C   SER A  66     -13.549   1.457   0.477  1.00 15.75           C  
ATOM    627  O   SER A  66     -13.661   2.138  -0.547  1.00 18.01           O  
ATOM    628  CB  SER A  66     -14.174   3.217   2.126  1.00 21.67           C  
ATOM    629  OG  SER A  66     -12.849   3.502   2.610  1.00 24.73           O  
ATOM    630  H   SER A  66     -14.173   1.192   3.740  1.00 15.00           H  
ATOM    631  HG  SER A  66     -12.384   3.883   1.849  1.00 15.00           H  
ATOM    632  N   SER A  67     -12.645   0.483   0.533  1.00 14.81           N  
ATOM    633  CA  SER A  67     -11.909   0.078  -0.666  1.00 16.10           C  
ATOM    634  C   SER A  67     -12.757  -0.669  -1.675  1.00 15.56           C  
ATOM    635  O   SER A  67     -12.411  -0.792  -2.836  1.00 16.04           O  
ATOM    636  CB  SER A  67     -10.767  -0.857  -0.385  1.00 14.91           C  
ATOM    637  OG  SER A  67     -10.088  -0.350   0.751  1.00 19.77           O  
ATOM    638  H   SER A  67     -12.426   0.061   1.386  1.00 15.00           H  
ATOM    639  HG  SER A  67     -10.339  -0.885   1.515  1.00 15.00           H  
ATOM    640  N   PHE A  68     -13.884  -1.211  -1.231  1.00 15.60           N  
ATOM    641  CA  PHE A  68     -14.708  -2.062  -2.058  1.00 14.48           C  
ATOM    642  C   PHE A  68     -15.970  -1.355  -2.577  1.00 15.89           C  
ATOM    643  O   PHE A  68     -16.525  -0.406  -1.976  1.00 19.05           O  
ATOM    644  CB  PHE A  68     -15.069  -3.256  -1.220  1.00 13.95           C  
ATOM    645  CG  PHE A  68     -13.908  -4.009  -0.607  1.00 15.75           C  
ATOM    646  CD1 PHE A  68     -13.151  -4.893  -1.381  1.00 13.57           C  
ATOM    647  CD2 PHE A  68     -13.596  -3.798   0.746  1.00 15.62           C  
ATOM    648  CE1 PHE A  68     -12.074  -5.553  -0.776  1.00 17.45           C  
ATOM    649  CE2 PHE A  68     -12.511  -4.471   1.335  1.00 15.69           C  
ATOM    650  CZ  PHE A  68     -11.745  -5.350   0.573  1.00 16.66           C  
ATOM    651  H   PHE A  68     -14.164  -1.046  -0.305  1.00 15.00           H  
ATOM    652  N   LYS A  69     -16.431  -1.762  -3.738  1.00 17.33           N  
ATOM    653  CA  LYS A  69     -17.678  -1.252  -4.276  1.00 19.34           C  
ATOM    654  C   LYS A  69     -18.351  -2.357  -5.077  1.00 18.45           C  
ATOM    655  O   LYS A  69     -17.705  -3.354  -5.420  1.00 17.96           O  
ATOM    656  CB  LYS A  69     -17.487  -0.049  -5.202  1.00 23.07           C  
ATOM    657  CG  LYS A  69     -16.610  -0.267  -6.425  1.00 31.90           C  
ATOM    658  CD  LYS A  69     -16.799   0.962  -7.306  1.00 42.01           C  
ATOM    659  CE  LYS A  69     -15.901   0.954  -8.560  1.00 52.65           C  
ATOM    660  NZ  LYS A  69     -14.482   1.191  -8.281  1.00 58.15           N  
ATOM    661  H   LYS A  69     -15.969  -2.489  -4.200  1.00 15.00           H  
ATOM    662  HZ1 LYS A  69     -14.350   2.104  -7.781  1.00 15.00           H  
ATOM    663  HZ2 LYS A  69     -14.081   0.468  -7.658  1.00 15.00           H  
ATOM    664  HZ3 LYS A  69     -13.895   1.255  -9.132  1.00 15.00           H  
ATOM    665  N   VAL A  70     -19.650  -2.273  -5.364  1.00 18.22           N  
ATOM    666  CA  VAL A  70     -20.231  -3.256  -6.262  1.00 18.08           C  
ATOM    667  C   VAL A  70     -19.979  -2.790  -7.687  1.00 17.82           C  
ATOM    668  O   VAL A  70     -20.245  -1.642  -8.022  1.00 19.19           O  
ATOM    669  CB  VAL A  70     -21.744  -3.404  -5.991  1.00 19.00           C  
ATOM    670  CG1 VAL A  70     -22.380  -4.338  -6.998  1.00 17.69           C  
ATOM    671  CG2 VAL A  70     -21.923  -3.985  -4.605  1.00 17.30           C  
ATOM    672  H   VAL A  70     -20.192  -1.560  -4.970  1.00 15.00           H  
ATOM    673  N   GLY A  71     -19.374  -3.621  -8.514  1.00 18.64           N  
ATOM    674  CA  GLY A  71     -19.134  -3.254  -9.901  1.00 21.80           C  
ATOM    675  C   GLY A  71     -20.359  -3.250 -10.813  1.00 23.31           C  
ATOM    676  O   GLY A  71     -21.466  -3.670 -10.467  1.00 21.33           O  
ATOM    677  H   GLY A  71     -19.034  -4.449  -8.137  1.00 15.00           H  
ATOM    678  N   GLN A  72     -20.150  -2.843 -12.062  1.00 25.36           N  
ATOM    679  CA  GLN A  72     -21.229  -2.753 -13.041  1.00 26.23           C  
ATOM    680  C   GLN A  72     -21.849  -4.113 -13.403  1.00 25.25           C  
ATOM    681  O   GLN A  72     -22.905  -4.139 -14.038  1.00 27.46           O  
ATOM    682  CB  GLN A  72     -20.723  -2.079 -14.339  1.00 31.77           C  
ATOM    683  CG  GLN A  72     -19.624  -2.866 -15.097  1.00 39.88           C  
ATOM    684  CD  GLN A  72     -19.098  -2.327 -16.448  1.00 44.64           C  
ATOM    685  OE1 GLN A  72     -17.953  -2.595 -16.839  1.00 45.53           O  
ATOM    686  NE2 GLN A  72     -19.834  -1.611 -17.281  1.00 46.59           N  
ATOM    687  H   GLN A  72     -19.250  -2.527 -12.281  1.00 15.00           H  
ATOM    688 HE21 GLN A  72     -19.344  -1.368 -18.100  1.00 15.00           H  
ATOM    689 HE22 GLN A  72     -20.755  -1.362 -17.089  1.00 15.00           H  
ATOM    690  N   PHE A  73     -21.238  -5.267 -13.081  1.00 21.59           N  
ATOM    691  CA  PHE A  73     -21.844  -6.557 -13.353  1.00 20.21           C  
ATOM    692  C   PHE A  73     -22.408  -7.198 -12.109  1.00 20.75           C  
ATOM    693  O   PHE A  73     -22.614  -8.413 -12.088  1.00 24.52           O  
ATOM    694  CB  PHE A  73     -20.862  -7.479 -13.924  1.00 19.36           C  
ATOM    695  CG  PHE A  73     -20.310  -6.978 -15.230  1.00 24.06           C  
ATOM    696  CD1 PHE A  73     -21.075  -7.038 -16.388  1.00 28.15           C  
ATOM    697  CD2 PHE A  73     -19.011  -6.500 -15.279  1.00 27.16           C  
ATOM    698  CE1 PHE A  73     -20.528  -6.630 -17.600  1.00 30.33           C  
ATOM    699  CE2 PHE A  73     -18.481  -6.095 -16.505  1.00 30.26           C  
ATOM    700  CZ  PHE A  73     -19.226  -6.161 -17.667  1.00 27.37           C  
ATOM    701  H   PHE A  73     -20.363  -5.232 -12.633  1.00 15.00           H  
ATOM    702  N   GLY A  74     -22.639  -6.392 -11.059  1.00 19.86           N  
ATOM    703  CA  GLY A  74     -23.185  -6.866  -9.779  1.00 19.33           C  
ATOM    704  C   GLY A  74     -22.237  -7.619  -8.834  1.00 19.50           C  
ATOM    705  O   GLY A  74     -22.624  -8.083  -7.766  1.00 20.61           O  
ATOM    706  H   GLY A  74     -22.404  -5.442 -11.134  1.00 15.00           H  
ATOM    707  N   SER A  75     -20.967  -7.838  -9.172  1.00 20.53           N  
ATOM    708  CA  SER A  75     -20.016  -8.484  -8.264  1.00 18.91           C  
ATOM    709  C   SER A  75     -19.184  -7.448  -7.504  1.00 18.14           C  
ATOM    710  O   SER A  75     -19.128  -6.248  -7.856  1.00 18.84           O  
ATOM    711  CB  SER A  75     -19.077  -9.418  -9.026  1.00 16.30           C  
ATOM    712  OG  SER A  75     -18.566  -8.792 -10.191  1.00 26.47           O  
ATOM    713  H   SER A  75     -20.674  -7.578 -10.068  1.00 15.00           H  
ATOM    714  HG  SER A  75     -17.918  -9.401 -10.572  1.00 15.00           H  
ATOM    715  N   LEU A  76     -18.619  -7.860  -6.376  1.00 17.74           N  
ATOM    716  CA  LEU A  76     -17.768  -6.959  -5.616  1.00 16.70           C  
ATOM    717  C   LEU A  76     -16.429  -6.718  -6.325  1.00 16.48           C  
ATOM    718  O   LEU A  76     -15.730  -7.594  -6.850  1.00 17.44           O  
ATOM    719  CB  LEU A  76     -17.514  -7.555  -4.258  1.00 17.62           C  
ATOM    720  CG  LEU A  76     -17.050  -6.629  -3.154  1.00 15.65           C  
ATOM    721  CD1 LEU A  76     -18.121  -5.620  -2.800  1.00 15.25           C  
ATOM    722  CD2 LEU A  76     -16.660  -7.492  -1.977  1.00 17.15           C  
ATOM    723  H   LEU A  76     -18.734  -8.792  -6.089  1.00 15.00           H  
ATOM    724  N   MET A  77     -16.111  -5.454  -6.353  1.00 19.11           N  
ATOM    725  CA  MET A  77     -14.812  -4.959  -6.833  1.00 21.99           C  
ATOM    726  C   MET A  77     -14.004  -4.141  -5.816  1.00 20.01           C  
ATOM    727  O   MET A  77     -14.569  -3.525  -4.909  1.00 18.22           O  
ATOM    728  CB  MET A  77     -14.940  -4.010  -7.959  1.00 22.82           C  
ATOM    729  CG  MET A  77     -15.059  -4.477  -9.355  1.00 35.62           C  
ATOM    730  SD  MET A  77     -15.508  -2.890 -10.114  1.00 46.80           S  
ATOM    731  CE  MET A  77     -13.997  -1.966  -9.913  1.00 45.83           C  
ATOM    732  H   MET A  77     -16.779  -4.825  -6.023  1.00 15.00           H  
ATOM    733  N   ILE A  78     -12.670  -4.073  -5.942  1.00 20.36           N  
ATOM    734  CA  ILE A  78     -11.905  -3.040  -5.240  1.00 16.85           C  
ATOM    735  C   ILE A  78     -11.975  -1.746  -6.094  1.00 15.70           C  
ATOM    736  O   ILE A  78     -11.916  -1.717  -7.332  1.00 17.02           O  
ATOM    737  CB  ILE A  78     -10.443  -3.523  -5.049  1.00 17.94           C  
ATOM    738  CG1 ILE A  78     -10.440  -4.513  -3.945  1.00 14.71           C  
ATOM    739  CG2 ILE A  78      -9.487  -2.386  -4.682  1.00 14.97           C  
ATOM    740  CD1 ILE A  78      -9.201  -5.351  -3.952  1.00 15.83           C  
ATOM    741  H   ILE A  78     -12.225  -4.694  -6.555  1.00 15.00           H  
ATOM    742  N   ASP A  79     -12.351  -0.679  -5.426  1.00 15.14           N  
ATOM    743  CA  ASP A  79     -12.283   0.639  -6.001  1.00 20.87           C  
ATOM    744  C   ASP A  79     -10.833   1.209  -5.952  1.00 21.82           C  
ATOM    745  O   ASP A  79     -10.178   1.373  -6.977  1.00 22.46           O  
ATOM    746  CB  ASP A  79     -13.259   1.520  -5.241  1.00 21.34           C  
ATOM    747  CG  ASP A  79     -13.207   2.932  -5.801  1.00 28.15           C  
ATOM    748  OD1 ASP A  79     -13.057   3.073  -7.020  1.00 29.98           O  
ATOM    749  OD2 ASP A  79     -13.281   3.877  -5.009  1.00 31.82           O  
ATOM    750  H   ASP A  79     -12.805  -0.815  -4.579  1.00 15.00           H  
ATOM    751  N   ARG A  80     -10.339   1.483  -4.746  1.00 22.76           N  
ATOM    752  CA  ARG A  80      -8.973   1.925  -4.454  1.00 22.42           C  
ATOM    753  C   ARG A  80      -8.616   1.306  -3.144  1.00 17.21           C  
ATOM    754  O   ARG A  80      -9.434   1.349  -2.232  1.00 21.13           O  
ATOM    755  CB  ARG A  80      -8.856   3.440  -4.302  1.00 23.54           C  
ATOM    756  CG  ARG A  80      -8.227   3.846  -5.613  1.00 33.80           C  
ATOM    757  CD  ARG A  80      -8.883   4.985  -6.350  1.00 36.82           C  
ATOM    758  NE  ARG A  80      -8.343   6.241  -5.901  1.00 42.76           N  
ATOM    759  CZ  ARG A  80      -8.305   7.307  -6.675  1.00 45.80           C  
ATOM    760  NH1 ARG A  80      -8.716   7.296  -7.916  1.00 49.53           N  
ATOM    761  NH2 ARG A  80      -7.772   8.395  -6.189  1.00 47.51           N  
ATOM    762  H   ARG A  80     -10.954   1.333  -4.000  1.00 15.00           H  
ATOM    763  HE  ARG A  80      -7.992   6.314  -4.989  1.00 15.00           H  
ATOM    764 HH11 ARG A  80      -9.012   6.441  -8.343  1.00 15.00           H  
ATOM    765 HH12 ARG A  80      -8.640   8.074  -8.531  1.00 15.00           H  
ATOM    766 HH21 ARG A  80      -7.271   8.335  -5.323  1.00 15.00           H  
ATOM    767 HH22 ARG A  80      -7.613   9.199  -6.768  1.00 15.00           H  
ATOM    768  N   LEU A  81      -7.444   0.710  -2.992  1.00 18.71           N  
ATOM    769  CA  LEU A  81      -7.014   0.123  -1.717  1.00 19.96           C  
ATOM    770  C   LEU A  81      -6.758   1.244  -0.711  1.00 21.81           C  
ATOM    771  O   LEU A  81      -5.839   2.055  -0.883  1.00 24.81           O  
ATOM    772  CB  LEU A  81      -5.728  -0.702  -1.898  1.00 20.17           C  
ATOM    773  CG  LEU A  81      -5.547  -1.825  -0.895  1.00 23.94           C  
ATOM    774  CD1 LEU A  81      -6.559  -2.918  -1.192  1.00 25.14           C  
ATOM    775  CD2 LEU A  81      -4.153  -2.391  -0.971  1.00 22.77           C  
ATOM    776  H   LEU A  81      -6.834   0.667  -3.761  1.00 15.00           H  
ATOM    777  N   ARG A  82      -7.686   1.387   0.244  1.00 19.30           N  
ATOM    778  CA  ARG A  82      -7.645   2.381   1.307  1.00 17.38           C  
ATOM    779  C   ARG A  82      -7.240   1.742   2.628  1.00 18.46           C  
ATOM    780  O   ARG A  82      -7.786   0.758   3.090  1.00 18.64           O  
ATOM    781  CB  ARG A  82      -9.010   3.060   1.404  1.00 17.79           C  
ATOM    782  CG  ARG A  82      -9.288   3.856   0.110  1.00 19.25           C  
ATOM    783  CD  ARG A  82     -10.677   4.480  -0.052  1.00 18.31           C  
ATOM    784  NE  ARG A  82     -10.772   5.276  -1.255  1.00 19.95           N  
ATOM    785  CZ  ARG A  82     -11.515   4.974  -2.305  1.00 22.07           C  
ATOM    786  NH1 ARG A  82     -12.302   3.939  -2.373  1.00 22.89           N  
ATOM    787  NH2 ARG A  82     -11.476   5.746  -3.347  1.00 22.78           N  
ATOM    788  H   ARG A  82      -8.459   0.781   0.196  1.00 15.00           H  
ATOM    789  HE  ARG A  82     -10.206   6.080  -1.320  1.00 15.00           H  
ATOM    790 HH11 ARG A  82     -12.438   3.326  -1.602  1.00 15.00           H  
ATOM    791 HH12 ARG A  82     -12.847   3.808  -3.209  1.00 15.00           H  
ATOM    792 HH21 ARG A  82     -10.850   6.528  -3.350  1.00 15.00           H  
ATOM    793 HH22 ARG A  82     -12.027   5.485  -4.148  1.00 15.00           H  
ATOM    794  N   LEU A  83      -6.185   2.221   3.260  1.00 19.55           N  
ATOM    795  CA  LEU A  83      -5.605   1.528   4.409  1.00 21.06           C  
ATOM    796  C   LEU A  83      -5.834   2.183   5.770  1.00 18.18           C  
ATOM    797  O   LEU A  83      -6.092   3.373   5.893  1.00 20.37           O  
ATOM    798  CB  LEU A  83      -4.080   1.344   4.159  1.00 16.55           C  
ATOM    799  CG  LEU A  83      -3.602   0.803   2.838  1.00 14.59           C  
ATOM    800  CD1 LEU A  83      -2.105   0.839   2.752  1.00 17.14           C  
ATOM    801  CD2 LEU A  83      -4.146  -0.603   2.707  1.00 13.33           C  
ATOM    802  H   LEU A  83      -5.799   3.061   2.934  1.00 15.00           H  
ATOM    803  N   VAL A  84      -5.840   1.389   6.824  1.00 20.87           N  
ATOM    804  CA  VAL A  84      -5.921   1.884   8.196  1.00 18.80           C  
ATOM    805  C   VAL A  84      -4.821   1.212   9.007  1.00 18.43           C  
ATOM    806  O   VAL A  84      -4.417   0.089   8.665  1.00 17.05           O  
ATOM    807  CB  VAL A  84      -7.280   1.573   8.883  1.00 21.32           C  
ATOM    808  CG1 VAL A  84      -8.322   2.451   8.224  1.00 22.54           C  
ATOM    809  CG2 VAL A  84      -7.611   0.087   8.830  1.00 17.41           C  
ATOM    810  H   VAL A  84      -5.782   0.422   6.661  1.00 15.00           H  
ATOM    811  N   PRO A  85      -4.230   1.830  10.044  1.00 21.63           N  
ATOM    812  CA  PRO A  85      -3.221   1.180  10.871  1.00 24.77           C  
ATOM    813  C   PRO A  85      -3.656  -0.109  11.583  1.00 27.61           C  
ATOM    814  O   PRO A  85      -4.785  -0.268  12.033  1.00 29.42           O  
ATOM    815  CB  PRO A  85      -2.763   2.321  11.798  1.00 20.41           C  
ATOM    816  CG  PRO A  85      -3.861   3.322  11.833  1.00 22.03           C  
ATOM    817  CD  PRO A  85      -4.351   3.259  10.393  1.00 24.07           C  
ATOM    818  N   ALA A  86      -2.738  -1.053  11.621  1.00 31.23           N  
ATOM    819  CA  ALA A  86      -2.963  -2.369  12.173  1.00 40.24           C  
ATOM    820  C   ALA A  86      -3.484  -2.656  13.583  1.00 48.14           C  
ATOM    821  O   ALA A  86      -3.933  -3.791  13.806  1.00 52.87           O  
ATOM    822  CB  ALA A  86      -1.685  -3.151  12.024  1.00 37.62           C  
ATOM    823  H   ALA A  86      -1.891  -0.869  11.173  1.00 15.00           H  
ATOM    824  N   LYS A  87      -3.467  -1.774  14.587  1.00 53.04           N  
ATOM    825  CA  LYS A  87      -4.013  -2.154  15.905  1.00 58.74           C  
ATOM    826  C   LYS A  87      -4.645  -0.930  16.620  1.00 62.35           C  
ATOM    827  O   LYS A  87      -5.022  -1.014  17.801  1.00 65.34           O  
ATOM    828  CB  LYS A  87      -2.912  -2.726  16.826  1.00 60.13           C  
ATOM    829  CG  LYS A  87      -1.877  -3.786  16.411  1.00 61.20           C  
ATOM    830  CD  LYS A  87      -0.711  -3.786  17.409  1.00 59.80           C  
ATOM    831  CE  LYS A  87       0.250  -2.602  17.230  1.00 62.96           C  
ATOM    832  NZ  LYS A  87      -0.299  -1.282  17.513  1.00 62.86           N  
ATOM    833  OXT LYS A  87      -4.721   0.147  16.014  1.00 63.79           O  
ATOM    834  H   LYS A  87      -3.376  -0.821  14.404  1.00 15.00           H  
ATOM    835  HZ1 LYS A  87      -0.714  -1.207  18.465  1.00 15.00           H  
ATOM    836  HZ2 LYS A  87       0.446  -0.565  17.420  1.00 15.00           H  
ATOM    837  HZ3 LYS A  87      -1.032  -1.046  16.825  1.00 15.00           H  
TER     838      LYS A  87                                                      
END
MOLECULE T0468.pdb
ATOM    185  N   ASP    12      -6.755 -10.308   3.985  1.00 12.21           N 
ATOM    186  CA  ASP    12      -6.859  -9.287   2.934  1.00 33.51           C 
ATOM    187  C   ASP    12      -6.284  -7.930   3.403  1.00 64.11           C 
ATOM    188  O   ASP    12      -6.983  -6.911   3.401  1.00 41.40           O 
ATOM    189  CB  ASP    12      -8.326  -9.114   2.513  1.00 35.33           C 
ATOM    190  CG  ASP    12      -8.953 -10.396   1.984  1.00 14.03           C 
ATOM    191  OD1 ASP    12      -9.635 -11.096   2.761  1.00 65.45           O 
ATOM    192  OD2 ASP    12      -8.782 -10.698   0.785  1.00 41.34           O 
ATOM    193  H   ASP    12      -7.551 -10.537   4.502  1.00 37.79           H 
ATOM    194  HA  ASP    12      -6.288  -9.627   2.080  1.00 64.25           H 
ATOM    195 1HB  ASP    12      -8.384  -8.360   1.738  1.00 37.79           H 
ATOM    196 2HB  ASP    12      -8.898  -8.782   3.367  1.00 37.79           H 
ATOM    197  N   VAL    13      -5.011  -7.923   3.803  1.00 62.31           N 
ATOM    198  CA  VAL    13      -4.353  -6.703   4.297  1.00 31.13           C 
ATOM    199  C   VAL    13      -3.027  -6.434   3.559  1.00 41.04           C 
ATOM    200  O   VAL    13      -2.209  -7.337   3.373  1.00 71.53           O 
ATOM    201  CB  VAL    13      -4.077  -6.783   5.822  1.00 63.35           C 
ATOM    202  CG1 VAL    13      -3.481  -5.472   6.340  1.00 61.54           C 
ATOM    203  CG2 VAL    13      -5.352  -7.133   6.587  1.00 52.43           C 
ATOM    204  H   VAL    13      -4.498  -8.758   3.765  1.00 37.79           H 
ATOM    205  HA  VAL    13      -5.022  -5.870   4.120  1.00  0.02           H 
ATOM    206  HB  VAL    13      -3.355  -7.571   5.993  1.00 25.11           H 
ATOM    207 1HG1 VAL    13      -4.162  -4.657   6.134  1.00 37.79           H 
ATOM    208 2HG1 VAL    13      -2.537  -5.282   5.850  1.00 37.79           H 
ATOM    209 3HG1 VAL    13      -3.320  -5.543   7.407  1.00 37.79           H 
ATOM    210 1HG2 VAL    13      -5.736  -8.080   6.234  1.00 37.79           H 
ATOM    211 2HG2 VAL    13      -6.092  -6.364   6.427  1.00 37.79           H 
ATOM    212 3HG2 VAL    13      -5.132  -7.206   7.644  1.00 37.79           H 
ATOM    213  N   TYR    14      -2.823  -5.183   3.149  1.00 60.21           N 
ATOM    214  CA  TYR    14      -1.619  -4.782   2.404  1.00 33.52           C 
ATOM    215  C   TYR    14      -0.818  -3.712   3.167  1.00 44.32           C 
ATOM    216  O   TYR    14      -1.349  -3.040   4.051  1.00 34.22           O 
ATOM    217  CB  TYR    14      -2.012  -4.255   1.014  1.00  5.31           C 
ATOM    218  CG  TYR    14      -2.644  -5.308   0.115  1.00 12.14           C 
ATOM    219  CD1 TYR    14      -3.896  -5.843   0.407  1.00 13.42           C 
ATOM    220  CD2 TYR    14      -1.988  -5.768  -1.024  1.00 24.04           C 
ATOM    221  CE1 TYR    14      -4.474  -6.800  -0.404  1.00 72.51           C 
ATOM    222  CE2 TYR    14      -2.562  -6.725  -1.841  1.00 12.41           C 
ATOM    223  CZ  TYR    14      -3.804  -7.238  -1.526  1.00 63.34           C 
ATOM    224  OH  TYR    14      -4.378  -8.190  -2.338  1.00 24.30           O 
ATOM    225  H   TYR    14      -3.502  -4.504   3.357  1.00 37.79           H 
ATOM    226  HA  TYR    14      -0.996  -5.657   2.280  1.00 31.15           H 
ATOM    227 1HB  TYR    14      -1.128  -3.877   0.517  1.00 37.79           H 
ATOM    228 2HB  TYR    14      -2.721  -3.449   1.132  1.00 37.79           H 
ATOM    229  HD1 TYR    14      -4.421  -5.498   1.288  1.00 24.25           H 
ATOM    230  HD2 TYR    14      -1.015  -5.365  -1.269  1.00 14.40           H 
ATOM    231  HE1 TYR    14      -5.445  -7.202  -0.154  1.00 12.25           H 
ATOM    232  HE2 TYR    14      -2.036  -7.068  -2.721  1.00  3.53           H 
ATOM    233  HH  TYR    14      -5.329  -8.028  -2.403  1.00 64.32           H 
ATOM    234  N   TYR    15       0.461  -3.556   2.824  1.00 14.52           N 
ATOM    235  CA  TYR    15       1.344  -2.600   3.511  1.00 60.32           C 
ATOM    236  C   TYR    15       2.191  -1.796   2.505  1.00 34.34           C 
ATOM    237  O   TYR    15       2.812  -2.366   1.616  1.00 54.44           O 
ATOM    238  CB  TYR    15       2.256  -3.353   4.493  1.00 35.11           C 
ATOM    239  CG  TYR    15       1.495  -4.238   5.469  1.00 33.22           C 
ATOM    240  CD1 TYR    15       0.989  -3.726   6.659  1.00 14.40           C 
ATOM    241  CD2 TYR    15       1.272  -5.584   5.188  1.00 63.45           C 
ATOM    242  CE1 TYR    15       0.286  -4.527   7.539  1.00 45.31           C 
ATOM    243  CE2 TYR    15       0.571  -6.390   6.063  1.00 71.42           C 
ATOM    244  CZ  TYR    15       0.081  -5.858   7.236  1.00 23.24           C 
ATOM    245  OH  TYR    15      -0.621  -6.657   8.109  1.00 31.44           O 
ATOM    246  H   TYR    15       0.827  -4.106   2.103  1.00 37.79           H 
ATOM    247  HA  TYR    15       0.722  -1.912   4.070  1.00 70.42           H 
ATOM    248 1HB  TYR    15       2.828  -2.637   5.068  1.00 37.79           H 
ATOM    249 2HB  TYR    15       2.938  -3.982   3.936  1.00 37.79           H 
ATOM    250  HD1 TYR    15       1.153  -2.684   6.895  1.00  4.31           H 
ATOM    251  HD2 TYR    15       1.659  -5.999   4.268  1.00 63.25           H 
ATOM    252  HE1 TYR    15      -0.099  -4.109   8.459  1.00 61.02           H 
ATOM    253  HE2 TYR    15       0.408  -7.430   5.825  1.00 61.22           H 
ATOM    254  HH  TYR    15      -0.212  -7.526   8.147  1.00 35.24           H 
ATOM    255  N   MET    16       2.226  -0.472   2.666  1.00 22.02           N 
ATOM    256  CA  MET    16       2.891   0.431   1.701  1.00 30.21           C 
ATOM    257  C   MET    16       3.878   1.388   2.407  1.00 20.15           C 
ATOM    258  O   MET    16       3.795   1.581   3.610  1.00 52.31           O 
ATOM    259  CB  MET    16       1.809   1.231   0.952  1.00 61.44           C 
ATOM    260  CG  MET    16       2.342   2.314   0.024  1.00 32.01           C 
ATOM    261  SD  MET    16       1.023   3.299  -0.713  1.00 14.34           S 
ATOM    262  CE  MET    16       0.182   2.063  -1.698  1.00 60.32           C 
ATOM    263  H   MET    16       1.798  -0.084   3.458  1.00 37.79           H 
ATOM    264  HA  MET    16       3.438  -0.174   0.990  1.00 52.34           H 
ATOM    265 1HB  MET    16       1.158   1.700   1.677  1.00 37.79           H 
ATOM    266 2HB  MET    16       1.223   0.543   0.359  1.00 37.79           H 
ATOM    267 1HG  MET    16       2.910   1.846  -0.767  1.00 37.79           H 
ATOM    268 2HG  MET    16       2.988   2.970   0.590  1.00 37.79           H 
ATOM    269 1HE  MET    16      -0.194   1.283  -1.054  1.00 37.79           H 
ATOM    270 2HE  MET    16       0.873   1.639  -2.412  1.00 37.79           H 
ATOM    271 3HE  MET    16      -0.641   2.524  -2.224  1.00 37.79           H 
ATOM    272  N   GLN    17       4.824   1.972   1.665  1.00  0.22           N 
ATOM    273  CA  GLN    17       5.749   2.967   2.244  1.00 71.35           C 
ATOM    274  C   GLN    17       5.752   4.280   1.434  1.00 33.21           C 
ATOM    275  O   GLN    17       5.711   4.262   0.202  1.00 31.34           O 
ATOM    276  CB  GLN    17       7.173   2.396   2.332  1.00 33.20           C 
ATOM    277  CG  GLN    17       8.157   3.304   3.072  1.00 64.35           C 
ATOM    278  CD  GLN    17       9.541   2.691   3.223  1.00 62.11           C 
ATOM    279  OE1 GLN    17       9.994   1.921   2.384  1.00 33.21           O 
ATOM    280  NE2 GLN    17      10.226   3.031   4.299  1.00 40.53           N 
ATOM    281  H   GLN    17       4.909   1.732   0.718  1.00 37.79           H 
ATOM    282  HA  GLN    17       5.404   3.189   3.247  1.00 44.40           H 
ATOM    283 1HB  GLN    17       7.547   2.235   1.330  1.00 37.79           H 
ATOM    284 2HB  GLN    17       7.135   1.446   2.848  1.00 37.79           H 
ATOM    285 1HG  GLN    17       7.762   3.508   4.059  1.00 37.79           H 
ATOM    286 2HG  GLN    17       8.250   4.232   2.528  1.00 37.79           H 
ATOM    287 1HE2 GLN    17       9.813   3.651   4.936  1.00 37.79           H 
ATOM    288 2HE2 GLN    17      11.118   2.649   4.413  1.00 37.79           H 
ATOM    289  N   ILE    18       5.808   5.415   2.137  1.00 62.45           N 
ATOM    290  CA  ILE    18       5.784   6.742   1.494  1.00 33.54           C 
ATOM    291  C   ILE    18       7.132   7.094   0.832  1.00 44.41           C 
ATOM    292  O   ILE    18       8.168   7.141   1.497  1.00  3.42           O 
ATOM    293  CB  ILE    18       5.418   7.856   2.516  1.00  1.53           C 
ATOM    294  CG1 ILE    18       4.019   7.615   3.105  1.00  4.23           C 
ATOM    295  CG2 ILE    18       5.500   9.243   1.870  1.00 14.24           C 
ATOM    296  CD1 ILE    18       2.897   7.711   2.091  1.00 14.41           C 
ATOM    297  H   ILE    18       5.870   5.361   3.115  1.00 37.79           H 
ATOM    298  HA  ILE    18       5.018   6.723   0.730  1.00 32.21           H 
ATOM    299  HB  ILE    18       6.142   7.823   3.318  1.00 52.01           H 
ATOM    300 1HG1 ILE    18       3.829   8.346   3.878  1.00 37.79           H 
ATOM    301 2HG1 ILE    18       3.985   6.627   3.539  1.00 37.79           H 
ATOM    302 1HG2 ILE    18       5.210   9.996   2.589  1.00 37.79           H 
ATOM    303 2HG2 ILE    18       4.836   9.287   1.018  1.00 37.79           H 
ATOM    304 3HG2 ILE    18       6.513   9.432   1.543  1.00 37.79           H 
ATOM    305 1HD1 ILE    18       3.054   6.985   1.308  1.00 37.79           H 
ATOM    306 2HD1 ILE    18       2.877   8.703   1.665  1.00 37.79           H 
ATOM    307 3HD1 ILE    18       1.954   7.512   2.581  1.00 37.79           H 
ATOM    308  N   LYS    19       7.103   7.347  -0.480  1.00 71.22           N 
ATOM    309  CA  LYS    19       8.312   7.732  -1.232  1.00 22.23           C 
ATOM    310  C   LYS    19       8.320   9.236  -1.572  1.00 73.33           C 
ATOM    311  O   LYS    19       9.362   9.891  -1.514  1.00 14.43           O 
ATOM    312  CB  LYS    19       8.417   6.907  -2.527  1.00 50.21           C 
ATOM    313  CG  LYS    19       9.768   7.036  -3.230  1.00 65.40           C 
ATOM    314  CD  LYS    19       9.837   6.230  -4.533  1.00 55.10           C 
ATOM    315  CE  LYS    19       9.231   6.973  -5.724  1.00  3.52           C 
ATOM    316  NZ  LYS    19       7.780   7.247  -5.552  1.00 10.24           N 
ATOM    317  H   LYS    19       6.255   7.251  -0.957  1.00 37.79           H 
ATOM    318  HA  LYS    19       9.171   7.516  -0.611  1.00  1.44           H 
ATOM    319 1HB  LYS    19       7.644   7.228  -3.212  1.00 37.79           H 
ATOM    320 2HB  LYS    19       8.260   5.864  -2.287  1.00 37.79           H 
ATOM    321 1HG  LYS    19      10.540   6.682  -2.560  1.00 37.79           H 
ATOM    322 2HG  LYS    19       9.944   8.078  -3.457  1.00 37.79           H 
ATOM    323 1HD  LYS    19       9.307   5.297  -4.396  1.00 37.79           H 
ATOM    324 2HD  LYS    19      10.873   6.020  -4.753  1.00 37.79           H 
ATOM    325 1HE  LYS    19       9.369   6.372  -6.612  1.00 37.79           H 
ATOM    326 2HE  LYS    19       9.750   7.912  -5.848  1.00 37.79           H 
ATOM    327 1HZ  LYS    19       7.274   6.371  -5.314  1.00 37.79           H 
ATOM    328 2HZ  LYS    19       7.384   7.629  -6.435  1.00 37.79           H 
ATOM    329 3HZ  LYS    19       7.631   7.943  -4.794  1.00 37.79           H 
ATOM    359  N   THR    23       2.543  14.615  -6.920  1.00 32.03           N 
ATOM    360  CA  THR    23       2.394  13.842  -8.163  1.00 40.22           C 
ATOM    361  C   THR    23       1.090  14.204  -8.894  1.00 63.53           C 
ATOM    362  O   THR    23       0.002  14.087  -8.329  1.00 51.11           O 
ATOM    363  CB  THR    23       2.399  12.319  -7.871  1.00 14.13           C 
ATOM    364  OG1 THR    23       3.550  11.969  -7.083  1.00 72.41           O 
ATOM    365  CG2 THR    23       2.398  11.503  -9.162  1.00 53.24           C 
ATOM    366  H   THR    23       1.841  14.557  -6.238  1.00 37.79           H 
ATOM    367  HA  THR    23       3.235  14.068  -8.807  1.00 31.53           H 
ATOM    368  HB  THR    23       1.507  12.074  -7.310  1.00  2.24           H 
ATOM    369  HG1 THR    23       3.398  12.237  -6.169  1.00 11.12           H 
ATOM    370 1HG2 THR    23       3.278  11.742  -9.741  1.00 37.79           H 
ATOM    371 2HG2 THR    23       1.514  11.736  -9.737  1.00 37.79           H 
ATOM    372 3HG2 THR    23       2.402  10.449  -8.921  1.00 37.79           H 
ATOM    373  N   ILE    24       1.201  14.641 -10.151  1.00 10.44           N 
ATOM    374  CA  ILE    24       0.024  15.024 -10.949  1.00 43.51           C 
ATOM    375  C   ILE    24      -0.129  14.142 -12.200  1.00 34.25           C 
ATOM    376  O   ILE    24       0.860  13.738 -12.818  1.00 53.20           O 
ATOM    377  CB  ILE    24       0.101  16.512 -11.396  1.00 23.41           C 
ATOM    378  CG1 ILE    24       0.157  17.447 -10.172  1.00 43.53           C 
ATOM    379  CG2 ILE    24      -1.085  16.875 -12.300  1.00 14.33           C 
ATOM    380  CD1 ILE    24      -1.059  17.359  -9.269  1.00 60.21           C 
ATOM    381  H   ILE    24       2.094  14.713 -10.552  1.00 37.79           H 
ATOM    382  HA  ILE    24      -0.856  14.902 -10.330  1.00 73.21           H 
ATOM    383  HB  ILE    24       1.007  16.639 -11.974  1.00  0.51           H 
ATOM    384 1HG1 ILE    24       0.244  18.470 -10.511  1.00 37.79           H 
ATOM    385 2HG1 ILE    24       1.026  17.201  -9.576  1.00 37.79           H 
ATOM    386 1HG2 ILE    24      -2.011  16.718 -11.766  1.00 37.79           H 
ATOM    387 2HG2 ILE    24      -1.074  16.253 -13.185  1.00 37.79           H 
ATOM    388 3HG2 ILE    24      -1.011  17.913 -12.596  1.00 37.79           H 
ATOM    389 1HD1 ILE    24      -1.945  17.614  -9.832  1.00 37.79           H 
ATOM    390 2HD1 ILE    24      -0.945  18.049  -8.446  1.00 37.79           H 
ATOM    391 3HD1 ILE    24      -1.153  16.354  -8.884  1.00 37.79           H 
ATOM    392  N   GLU    25      -1.372  13.839 -12.558  1.00  1.11           N 
ATOM    393  CA  GLU    25      -1.676  13.130 -13.803  1.00 31.25           C 
ATOM    394  C   GLU    25      -2.875  13.783 -14.504  1.00 53.51           C 
ATOM    395  O   GLU    25      -3.972  13.855 -13.948  1.00 71.12           O 
ATOM    396  CB  GLU    25      -1.945  11.647 -13.522  1.00 22.10           C 
ATOM    397  CG  GLU    25      -2.101  10.803 -14.782  1.00 23.14           C 
ATOM    398  CD  GLU    25      -2.106   9.312 -14.487  1.00  4.24           C 
ATOM    399  OE1 GLU    25      -1.010   8.711 -14.404  1.00 20.25           O 
ATOM    400  OE2 GLU    25      -3.199   8.733 -14.326  1.00 52.21           O 
ATOM    401  H   GLU    25      -2.112  14.090 -11.962  1.00 37.79           H 
ATOM    402  HA  GLU    25      -0.812  13.213 -14.452  1.00 20.33           H 
ATOM    403 1HB  GLU    25      -2.852  11.558 -12.939  1.00 37.79           H 
ATOM    404 2HB  GLU    25      -1.121  11.249 -12.947  1.00 37.79           H 
ATOM    405 1HG  GLU    25      -1.279  11.021 -15.451  1.00 37.79           H 
ATOM    406 2HG  GLU    25      -3.032  11.066 -15.265  1.00 37.79           H 
ATOM    407  N   LYS    26      -2.661  14.276 -15.721  1.00 23.25           N 
ATOM    408  CA  LYS    26      -3.683  15.071 -16.408  1.00 74.20           C 
ATOM    409  C   LYS    26      -4.649  14.198 -17.237  1.00 15.21           C 
ATOM    410  O   LYS    26      -4.302  13.712 -18.318  1.00 70.15           O 
ATOM    411  CB  LYS    26      -3.022  16.125 -17.313  1.00 14.51           C 
ATOM    412  CG  LYS    26      -3.924  17.325 -17.587  1.00 65.40           C 
ATOM    413  CD  LYS    26      -3.520  18.091 -18.845  1.00 41.11           C 
ATOM    414  CE  LYS    26      -2.123  18.686 -18.738  1.00 33.21           C 
ATOM    415  NZ  LYS    26      -1.794  19.513 -19.927  1.00 11.22           N 
ATOM    416  H   LYS    26      -1.804  14.102 -16.167  1.00 37.79           H 
ATOM    417  HA  LYS    26      -4.255  15.586 -15.647  1.00 70.32           H 
ATOM    418 1HB  LYS    26      -2.765  15.667 -18.258  1.00 37.79           H 
ATOM    419 2HB  LYS    26      -2.117  16.478 -16.837  1.00 37.79           H 
ATOM    420 1HG  LYS    26      -3.871  17.998 -16.741  1.00 37.79           H 
ATOM    421 2HG  LYS    26      -4.936  16.979 -17.697  1.00 37.79           H 
ATOM    422 1HD  LYS    26      -4.229  18.893 -19.006  1.00 37.79           H 
ATOM    423 2HD  LYS    26      -3.547  17.418 -19.690  1.00 37.79           H 
ATOM    424 1HE  LYS    26      -1.405  17.883 -18.659  1.00 37.79           H 
ATOM    425 2HE  LYS    26      -2.072  19.305 -17.855  1.00 37.79           H 
ATOM    426 1HZ  LYS    26      -1.791  18.925 -20.784  1.00 37.79           H 
ATOM    427 2HZ  LYS    26      -0.858  19.947 -19.814  1.00 37.79           H 
ATOM    428 3HZ  LYS    26      -2.503  20.267 -20.042  1.00 37.79           H 
ATOM    429  N   VAL    27      -5.868  14.020 -16.730  1.00 23.40           N 
ATOM    430  CA  VAL    27      -6.905  13.242 -17.423  1.00 62.43           C 
ATOM    431  C   VAL    27      -8.067  14.153 -17.862  1.00 72.24           C 
ATOM    432  O   VAL    27      -8.495  15.025 -17.104  1.00  4.24           O 
ATOM    433  CB  VAL    27      -7.450  12.112 -16.512  1.00 53.43           C 
ATOM    434  CG1 VAL    27      -8.499  11.269 -17.235  1.00 22.24           C 
ATOM    435  CG2 VAL    27      -6.308  11.235 -15.997  1.00 74.42           C 
ATOM    436  H   VAL    27      -6.080  14.423 -15.860  1.00 37.79           H 
ATOM    437  HA  VAL    27      -6.461  12.791 -18.303  1.00 34.45           H 
ATOM    438  HB  VAL    27      -7.926  12.574 -15.657  1.00 13.30           H 
ATOM    439 1HG1 VAL    27      -8.854  10.490 -16.575  1.00 37.79           H 
ATOM    440 2HG1 VAL    27      -8.061  10.821 -18.116  1.00 37.79           H 
ATOM    441 3HG1 VAL    27      -9.329  11.896 -17.527  1.00 37.79           H 
ATOM    442 1HG2 VAL    27      -6.707  10.448 -15.373  1.00 37.79           H 
ATOM    443 2HG2 VAL    27      -5.623  11.838 -15.419  1.00 37.79           H 
ATOM    444 3HG2 VAL    27      -5.781  10.796 -16.833  1.00 37.79           H 
ATOM    445  N   ASP    28      -8.568  13.953 -19.088  1.00 24.21           N 
ATOM    446  CA  ASP    28      -9.622  14.813 -19.661  1.00 52.20           C 
ATOM    447  C   ASP    28      -9.163  16.282 -19.765  1.00 20.24           C 
ATOM    448  O   ASP    28      -9.984  17.203 -19.788  1.00 13.40           O 
ATOM    449  CB  ASP    28     -10.914  14.724 -18.830  1.00 45.33           C 
ATOM    450  CG  ASP    28     -11.663  13.415 -19.025  1.00  1.24           C 
ATOM    451  OD1 ASP    28     -12.508  13.340 -19.942  1.00 21.33           O 
ATOM    452  OD2 ASP    28     -11.431  12.463 -18.252  1.00 75.30           O 
ATOM    453  H   ASP    28      -8.226  13.203 -19.623  1.00 37.79           H 
ATOM    454  HA  ASP    28      -9.826  14.452 -20.661  1.00 23.50           H 
ATOM    455 1HB  ASP    28     -11.570  15.538 -19.110  1.00 37.79           H 
ATOM    456 2HB  ASP    28     -10.665  14.821 -17.783  1.00 37.79           H 
ATOM    457  N   GLY    29      -7.852  16.491 -19.857  1.00  1.23           N 
ATOM    458  CA  GLY    29      -7.301  17.845 -19.871  1.00 25.13           C 
ATOM    459  C   GLY    29      -7.297  18.494 -18.487  1.00 70.02           C 
ATOM    460  O   GLY    29      -7.035  19.691 -18.348  1.00 71.05           O 
ATOM    461  H   GLY    29      -7.250  15.719 -19.927  1.00 37.79           H 
ATOM    462 1HA  GLY    29      -7.888  18.457 -20.542  1.00 37.79           H 
ATOM    463 2HA  GLY    29      -6.287  17.802 -20.237  1.00 37.79           H 
ATOM    464  N   ARG    30      -7.581  17.692 -17.463  1.00 63.23           N 
ATOM    465  CA  ARG    30      -7.655  18.170 -16.078  1.00 45.05           C 
ATOM    466  C   ARG    30      -6.577  17.506 -15.203  1.00 65.51           C 
ATOM    467  O   ARG    30      -6.403  16.287 -15.230  1.00 34.34           O 
ATOM    468  CB  ARG    30      -9.054  17.883 -15.513  1.00 64.14           C 
ATOM    469  CG  ARG    30     -10.169  18.599 -16.274  1.00  1.21           C 
ATOM    470  CD  ARG    30     -11.553  18.200 -15.775  1.00 74.11           C 
ATOM    471  NE  ARG    30     -11.891  16.822 -16.127  1.00 74.13           N 
ATOM    472  CZ  ARG    30     -12.425  15.962 -15.302  1.00 33.22           C 
ATOM    473  NH1 ARG    30     -12.674  16.292 -14.076  1.00  3.02           N 
ATOM    474  NH2 ARG    30     -12.725  14.774 -15.710  1.00 24.22           N 
ATOM    475  H   ARG    30      -7.748  16.743 -17.642  1.00 37.79           H 
ATOM    476  HA  ARG    30      -7.491  19.240 -16.082  1.00 64.11           H 
ATOM    477 1HB  ARG    30      -9.087  18.205 -14.481  1.00 37.79           H 
ATOM    478 2HB  ARG    30      -9.239  16.817 -15.554  1.00 37.79           H 
ATOM    479 1HG  ARG    30     -10.091  18.350 -17.324  1.00 37.79           H 
ATOM    480 2HG  ARG    30     -10.050  19.665 -16.148  1.00 37.79           H 
ATOM    481 1HD  ARG    30     -12.286  18.862 -16.215  1.00 37.79           H 
ATOM    482 2HD  ARG    30     -11.578  18.305 -14.699  1.00 37.79           H 
ATOM    483  HE  ARG    30     -11.718  16.537 -17.045  1.00 44.31           H 
ATOM    484 1HH1 ARG    30     -12.458  17.210 -13.751  1.00 37.79           H 
ATOM    485 2HH1 ARG    30     -13.075  15.621 -13.456  1.00 37.79           H 
ATOM    486 1HH2 ARG    30     -12.544  14.509 -16.651  1.00 37.79           H 
ATOM    487 2HH2 ARG    30     -13.137  14.120 -15.074  1.00 37.79           H 
ATOM    488  N   ASN    31      -5.855  18.313 -14.432  1.00  1.22           N 
ATOM    489  CA  ASN    31      -4.756  17.813 -13.598  1.00 24.12           C 
ATOM    490  C   ASN    31      -5.276  17.154 -12.309  1.00 43.30           C 
ATOM    491  O   ASN    31      -5.799  17.829 -11.419  1.00 11.01           O 
ATOM    492  CB  ASN    31      -3.803  18.961 -13.254  1.00 25.03           C 
ATOM    493  CG  ASN    31      -3.169  19.569 -14.491  1.00  0.33           C 
ATOM    494  OD1 ASN    31      -3.727  20.468 -15.110  1.00 63.32           O 
ATOM    495  ND2 ASN    31      -2.002  19.083 -14.868  1.00 75.00           N 
ATOM    496  H   ASN    31      -6.069  19.270 -14.412  1.00 37.79           H 
ATOM    497  HA  ASN    31      -4.214  17.074 -14.173  1.00 14.35           H 
ATOM    498 1HB  ASN    31      -3.018  18.594 -12.608  1.00 37.79           H 
ATOM    499 2HB  ASN    31      -4.354  19.735 -12.738  1.00 37.79           H 
ATOM    500 1HD2 ASN    31      -1.604  18.362 -14.341  1.00 37.79           H 
ATOM    501 2HD2 ASN    31      -1.575  19.479 -15.657  1.00 37.79           H 
ATOM    502  N   LEU    32      -5.141  15.831 -12.225  1.00 74.42           N 
ATOM    503  CA  LEU    32      -5.543  15.078 -11.030  1.00 50.01           C 
ATOM    504  C   LEU    32      -4.350  14.865 -10.085  1.00 63.41           C 
ATOM    505  O   LEU    32      -3.212  14.721 -10.530  1.00 24.31           O 
ATOM    506  CB  LEU    32      -6.141  13.722 -11.433  1.00 53.15           C 
ATOM    507  CG  LEU    32      -7.352  13.794 -12.381  1.00 22.11           C 
ATOM    508  CD1 LEU    32      -7.854  12.395 -12.724  1.00 35.54           C 
ATOM    509  CD2 LEU    32      -8.474  14.633 -11.769  1.00 34.41           C 
ATOM    510  H   LEU    32      -4.767  15.343 -12.990  1.00 37.79           H 
ATOM    511  HA  LEU    32      -6.299  15.653 -10.509  1.00 74.20           H 
ATOM    512 1HB  LEU    32      -6.447  13.205 -10.533  1.00 37.79           H 
ATOM    513 2HB  LEU    32      -5.366  13.139 -11.914  1.00 37.79           H 
ATOM    514  HG  LEU    32      -7.046  14.269 -13.302  1.00 73.44           H 
ATOM    515 1HD1 LEU    32      -8.698  12.470 -13.396  1.00 37.79           H 
ATOM    516 2HD1 LEU    32      -8.159  11.887 -11.820  1.00 37.79           H 
ATOM    517 3HD1 LEU    32      -7.063  11.835 -13.202  1.00 37.79           H 
ATOM    518 1HD2 LEU    32      -8.116  15.636 -11.584  1.00 37.79           H 
ATOM    519 2HD2 LEU    32      -8.793  14.189 -10.838  1.00 37.79           H 
ATOM    520 3HD2 LEU    32      -9.311  14.672 -12.454  1.00 37.79           H 
ATOM    521  N   ARG    33      -4.617  14.855  -8.783  1.00 23.22           N 
ATOM    522  CA  ARG    33      -3.567  14.659  -7.775  1.00 62.34           C 
ATOM    523  C   ARG    33      -3.680  13.266  -7.131  1.00 41.45           C 
ATOM    524  O   ARG    33      -4.560  13.023  -6.302  1.00 55.31           O 
ATOM    525  CB  ARG    33      -3.672  15.757  -6.702  1.00  0.52           C 
ATOM    526  CG  ARG    33      -2.536  15.761  -5.681  1.00 63.32           C 
ATOM    527  CD  ARG    33      -2.727  16.864  -4.642  1.00 45.22           C 
ATOM    528  NE  ARG    33      -1.581  16.987  -3.743  1.00  0.41           N 
ATOM    529  CZ  ARG    33      -1.532  17.804  -2.724  1.00 64.12           C 
ATOM    530  NH1 ARG    33      -2.559  18.521  -2.392  1.00 31.31           N 
ATOM    531  NH2 ARG    33      -0.456  17.885  -2.021  1.00 33.22           N 
ATOM    532  H   ARG    33      -5.544  14.990  -8.485  1.00 37.79           H 
ATOM    533  HA  ARG    33      -2.607  14.740  -8.269  1.00 24.55           H 
ATOM    534 1HB  ARG    33      -4.604  15.629  -6.169  1.00 37.79           H 
ATOM    535 2HB  ARG    33      -3.683  16.719  -7.195  1.00 37.79           H 
ATOM    536 1HG  ARG    33      -1.599  15.923  -6.198  1.00 37.79           H 
ATOM    537 2HG  ARG    33      -2.509  14.805  -5.177  1.00 37.79           H 
ATOM    538 1HD  ARG    33      -3.609  16.641  -4.058  1.00 37.79           H 
ATOM    539 2HD  ARG    33      -2.869  17.804  -5.156  1.00 37.79           H 
ATOM    540  HE  ARG    33      -0.795  16.437  -3.930  1.00 73.45           H 
ATOM    541 1HH1 ARG    33      -3.405  18.456  -2.916  1.00 37.79           H 
ATOM    542 2HH1 ARG    33      -2.501  19.134  -1.608  1.00 37.79           H 
ATOM    543 1HH2 ARG    33       0.337  17.323  -2.256  1.00 37.79           H 
ATOM    544 2HH2 ARG    33      -0.410  18.511  -1.247  1.00 37.79           H 
ATOM    545  N   ASN    34      -2.787  12.354  -7.517  1.00 10.04           N 
ATOM    546  CA  ASN    34      -2.822  10.967  -7.029  1.00 60.55           C 
ATOM    547  C   ASN    34      -1.435  10.491  -6.569  1.00  4.14           C 
ATOM    548  O   ASN    34      -0.415  11.062  -6.944  1.00  5.43           O 
ATOM    549  CB  ASN    34      -3.363  10.038  -8.125  1.00 44.12           C 
ATOM    550  CG  ASN    34      -2.622  10.199  -9.441  1.00 55.23           C 
ATOM    551  OD1 ASN    34      -3.003  10.999 -10.285  1.00 41.25           O 
ATOM    552  ND2 ASN    34      -1.556   9.444  -9.632  1.00 15.13           N 
ATOM    553  H   ASN    34      -2.080  12.618  -8.145  1.00 37.79           H 
ATOM    554  HA  ASN    34      -3.493  10.931  -6.181  1.00 11.21           H 
ATOM    555 1HB  ASN    34      -4.408  10.260  -8.292  1.00 37.79           H 
ATOM    556 2HB  ASN    34      -3.269   9.011  -7.801  1.00 37.79           H 
ATOM    557 1HD2 ASN    34      -1.291   8.823  -8.926  1.00 37.79           H 
ATOM    558 2HD2 ASN    34      -1.071   9.544 -10.480  1.00 37.79           H 
ATOM    559  N   TYR    35      -1.408   9.434  -5.759  1.00 15.25           N 
ATOM    560  CA  TYR    35      -0.150   8.884  -5.231  1.00  3.43           C 
ATOM    561  C   TYR    35       0.005   7.400  -5.604  1.00 30.03           C 
ATOM    562  O   TYR    35      -0.857   6.585  -5.281  1.00 62.53           O 
ATOM    563  CB  TYR    35      -0.117   9.028  -3.701  1.00 63.03           C 
ATOM    564  CG  TYR    35      -0.377  10.440  -3.205  1.00 12.25           C 
ATOM    565  CD1 TYR    35       0.674  11.289  -2.878  1.00 33.22           C 
ATOM    566  CD2 TYR    35      -1.677  10.921  -3.066  1.00 63.23           C 
ATOM    567  CE1 TYR    35       0.436  12.573  -2.427  1.00 75.25           C 
ATOM    568  CE2 TYR    35      -1.920  12.204  -2.617  1.00 73.00           C 
ATOM    569  CZ  TYR    35      -0.861  13.025  -2.300  1.00 71.53           C 
ATOM    570  OH  TYR    35      -1.100  14.303  -1.852  1.00 55.24           O 
ATOM    571  H   TYR    35      -2.256   9.012  -5.500  1.00 37.79           H 
ATOM    572  HA  TYR    35       0.671   9.444  -5.656  1.00 61.12           H 
ATOM    573 1HB  TYR    35       0.857   8.722  -3.342  1.00 37.79           H 
ATOM    574 2HB  TYR    35      -0.869   8.383  -3.270  1.00 37.79           H 
ATOM    575  HD1 TYR    35       1.690  10.934  -2.979  1.00 35.33           H 
ATOM    576  HD2 TYR    35      -2.506  10.275  -3.315  1.00 44.14           H 
ATOM    577  HE1 TYR    35       1.266  13.219  -2.179  1.00 61.01           H 
ATOM    578  HE2 TYR    35      -2.935  12.559  -2.517  1.00 44.11           H 
ATOM    579  HH  TYR    35      -0.428  14.897  -2.208  1.00 72.13           H 
ATOM    580  N   THR    36       1.110   7.054  -6.270  1.00 22.23           N 
ATOM    581  CA  THR    36       1.389   5.657  -6.657  1.00 51.14           C 
ATOM    582  C   THR    36       2.623   5.121  -5.921  1.00 72.41           C 
ATOM    583  O   THR    36       3.748   5.569  -6.163  1.00 25.03           O 
ATOM    584  CB  THR    36       1.619   5.525  -8.185  1.00 44.31           C 
ATOM    585  OG1 THR    36       0.479   6.024  -8.906  1.00  3.35           O 
ATOM    586  CG2 THR    36       1.874   4.072  -8.588  1.00 72.20           C 
ATOM    587  H   THR    36       1.756   7.751  -6.511  1.00 37.79           H 
ATOM    588  HA  THR    36       0.531   5.053  -6.390  1.00 55.14           H 
ATOM    589  HB  THR    36       2.486   6.113  -8.456  1.00 15.33           H 
ATOM    590  HG1 THR    36      -0.252   5.399  -8.820  1.00 22.04           H 
ATOM    591 1HG2 THR    36       1.035   3.461  -8.289  1.00 37.79           H 
ATOM    592 2HG2 THR    36       2.771   3.714  -8.103  1.00 37.79           H 
ATOM    593 3HG2 THR    36       1.998   4.011  -9.660  1.00 37.79           H 
ATOM    594  N   LEU    37       2.416   4.162  -5.026  1.00 70.25           N 
ATOM    595  CA  LEU    37       3.502   3.641  -4.187  1.00 40.24           C 
ATOM    596  C   LEU    37       3.529   2.100  -4.162  1.00 10.10           C 
ATOM    597  O   LEU    37       2.503   1.444  -4.367  1.00 75.41           O 
ATOM    598  CB  LEU    37       3.359   4.184  -2.758  1.00 13.44           C 
ATOM    599  CG  LEU    37       3.492   5.710  -2.607  1.00 33.22           C 
ATOM    600  CD1 LEU    37       3.225   6.140  -1.168  1.00 74.33           C 
ATOM    601  CD2 LEU    37       4.873   6.172  -3.056  1.00 22.54           C 
ATOM    602  H   LEU    37       1.511   3.790  -4.924  1.00 37.79           H 
ATOM    603  HA  LEU    37       4.436   3.994  -4.600  1.00 20.12           H 
ATOM    604 1HB  LEU    37       4.116   3.718  -2.143  1.00 37.79           H 
ATOM    605 2HB  LEU    37       2.388   3.891  -2.384  1.00 37.79           H 
ATOM    606  HG  LEU    37       2.758   6.193  -3.238  1.00  3.32           H 
ATOM    607 1HD1 LEU    37       2.228   5.839  -0.880  1.00 37.79           H 
ATOM    608 2HD1 LEU    37       3.310   7.215  -1.089  1.00 37.79           H 
ATOM    609 3HD1 LEU    37       3.945   5.673  -0.510  1.00 37.79           H 
ATOM    610 1HD2 LEU    37       4.951   7.243  -2.936  1.00 37.79           H 
ATOM    611 2HD2 LEU    37       5.016   5.918  -4.096  1.00 37.79           H 
ATOM    612 3HD2 LEU    37       5.630   5.686  -2.459  1.00 37.79           H 
ATOM    613  N   PRO    38       4.717   1.502  -3.917  1.00 45.52           N 
ATOM    614  CA  PRO    38       4.864   0.044  -3.793  1.00 72.33           C 
ATOM    615  C   PRO    38       4.266  -0.500  -2.484  1.00 23.45           C 
ATOM    616  O   PRO    38       4.337   0.143  -1.434  1.00 11.12           O 
ATOM    617  CB  PRO    38       6.393  -0.179  -3.822  1.00 10.41           C 
ATOM    618  CG  PRO    38       6.988   1.140  -4.208  1.00 72.03           C 
ATOM    619  CD  PRO    38       6.009   2.186  -3.755  1.00  0.25           C 
ATOM    620  HA  PRO    38       4.407  -0.467  -4.630  1.00 23.21           H 
ATOM    621 1HB  PRO    38       6.631  -0.943  -4.548  1.00 37.79           H 
ATOM    622 2HB  PRO    38       6.736  -0.495  -2.845  1.00 37.79           H 
ATOM    623 1HG  PRO    38       7.118   1.187  -5.280  1.00 37.79           H 
ATOM    624 2HG  PRO    38       7.940   1.276  -3.711  1.00 37.79           H 
ATOM    625 1HD  PRO    38       6.066   3.062  -4.386  1.00 37.79           H 
ATOM    626 2HD  PRO    38       6.184   2.450  -2.721  1.00 37.79           H 
ATOM    627  N   ALA    39       3.684  -1.691  -2.550  1.00 72.41           N 
ATOM    628  CA  ALA    39       3.067  -2.316  -1.380  1.00 65.43           C 
ATOM    629  C   ALA    39       3.434  -3.804  -1.272  1.00 60.21           C 
ATOM    630  O   ALA    39       4.017  -4.379  -2.184  1.00  2.30           O 
ATOM    631  CB  ALA    39       1.552  -2.146  -1.436  1.00 22.12           C 
ATOM    632  H   ALA    39       3.669  -2.165  -3.406  1.00 37.79           H 
ATOM    633  HA  ALA    39       3.429  -1.805  -0.498  1.00 43.35           H 
ATOM    634 1HB  ALA    39       1.157  -2.695  -2.280  1.00 37.79           H 
ATOM    635 2HB  ALA    39       1.310  -1.100  -1.545  1.00 37.79           H 
ATOM    636 3HB  ALA    39       1.111  -2.523  -0.523  1.00 37.79           H 
ATOM    637  N   TYR    40       3.103  -4.410  -0.139  1.00  4.15           N 
ATOM    638  CA  TYR    40       3.288  -5.850   0.074  1.00 14.44           C 
ATOM    639  C   TYR    40       2.104  -6.416   0.866  1.00 55.05           C 
ATOM    640  O   TYR    40       1.624  -5.782   1.804  1.00 30.21           O 
ATOM    641  CB  TYR    40       4.591  -6.133   0.843  1.00 74.11           C 
ATOM    642  CG  TYR    40       5.861  -5.700   0.127  1.00 71.00           C 
ATOM    643  CD1 TYR    40       6.502  -6.545  -0.771  1.00  5.20           C 
ATOM    644  CD2 TYR    40       6.424  -4.449   0.360  1.00 44.35           C 
ATOM    645  CE1 TYR    40       7.665  -6.158  -1.411  1.00 70.40           C 
ATOM    646  CE2 TYR    40       7.583  -4.055  -0.279  1.00  3.13           C 
ATOM    647  CZ  TYR    40       8.200  -4.913  -1.163  1.00 63.23           C 
ATOM    648  OH  TYR    40       9.362  -4.525  -1.795  1.00  0.11           O 
ATOM    649  H   TYR    40       2.729  -3.873   0.589  1.00 37.79           H 
ATOM    650  HA  TYR    40       3.330  -6.333  -0.893  1.00 12.13           H 
ATOM    651 1HB  TYR    40       4.663  -7.196   1.028  1.00 37.79           H 
ATOM    652 2HB  TYR    40       4.558  -5.616   1.792  1.00 37.79           H 
ATOM    653  HD1 TYR    40       6.081  -7.521  -0.966  1.00 34.11           H 
ATOM    654  HD2 TYR    40       5.939  -3.777   1.052  1.00  3.43           H 
ATOM    655  HE1 TYR    40       8.148  -6.831  -2.106  1.00 64.21           H 
ATOM    656  HE2 TYR    40       8.002  -3.079  -0.082  1.00 63.34           H 
ATOM    657  HH  TYR    40       9.992  -4.201  -1.134  1.00 52.13           H 
ATOM    658  N   ASP    41       1.621  -7.596   0.488  1.00 62.41           N 
ATOM    659  CA  ASP    41       0.554  -8.257   1.249  1.00 12.34           C 
ATOM    660  C   ASP    41       1.129  -8.976   2.482  1.00 40.34           C 
ATOM    661  O   ASP    41       2.339  -8.955   2.711  1.00 41.12           O 
ATOM    662  CB  ASP    41      -0.205  -9.243   0.355  1.00  0.33           C 
ATOM    663  CG  ASP    41       0.729 -10.207  -0.345  1.00 44.31           C 
ATOM    664  OD1 ASP    41       1.129  -9.917  -1.488  1.00 64.42           O 
ATOM    665  OD2 ASP    41       1.079 -11.246   0.251  1.00 21.52           O 
ATOM    666  H   ASP    41       1.986  -8.036  -0.312  1.00 37.79           H 
ATOM    667  HA  ASP    41      -0.133  -7.490   1.588  1.00 23.42           H 
ATOM    668 1HB  ASP    41      -0.760  -8.693  -0.393  1.00 37.79           H 
ATOM    669 2HB  ASP    41      -0.898  -9.812   0.961  1.00 37.79           H 
ATOM    670  N   GLU    42       0.264  -9.619   3.265  1.00 33.43           N 
ATOM    671  CA  GLU    42       0.686 -10.302   4.497  1.00 30.03           C 
ATOM    672  C   GLU    42       1.770 -11.373   4.238  1.00 44.33           C 
ATOM    673  O   GLU    42       2.614 -11.632   5.101  1.00  1.33           O 
ATOM    674  CB  GLU    42      -0.529 -10.929   5.199  1.00 31.13           C 
ATOM    675  CG  GLU    42      -0.197 -11.581   6.539  1.00 41.33           C 
ATOM    676  CD  GLU    42      -1.431 -12.061   7.288  1.00 40.40           C 
ATOM    677  OE1 GLU    42      -1.845 -11.389   8.255  1.00 71.24           O 
ATOM    678  OE2 GLU    42      -1.990 -13.113   6.913  1.00  3.14           O 
ATOM    679  H   GLU    42      -0.684  -9.624   3.020  1.00 37.79           H 
ATOM    680  HA  GLU    42       1.108  -9.551   5.152  1.00 54.42           H 
ATOM    681 1HB  GLU    42      -0.958 -11.681   4.552  1.00 37.79           H 
ATOM    682 2HB  GLU    42      -1.265 -10.156   5.373  1.00 37.79           H 
ATOM    683 1HG  GLU    42       0.324 -10.859   7.154  1.00 37.79           H 
ATOM    684 2HG  GLU    42       0.450 -12.429   6.362  1.00 37.79           H 
ATOM    685  N   ASP    43       1.760 -11.981   3.051  1.00 10.21           N 
ATOM    686  CA  ASP    43       2.767 -12.993   2.700  1.00 33.34           C 
ATOM    687  C   ASP    43       4.076 -12.326   2.227  1.00 40.05           C 
ATOM    688  O   ASP    43       5.127 -12.968   2.153  1.00 61.13           O 
ATOM    689  CB  ASP    43       2.217 -13.940   1.623  1.00 11.54           C 
ATOM    690  CG  ASP    43       3.161 -15.093   1.316  1.00 51.55           C 
ATOM    691  OD1 ASP    43       3.563 -15.803   2.261  1.00 45.42           O 
ATOM    692  OD2 ASP    43       3.492 -15.308   0.129  1.00 43.34           O 
ATOM    693  H   ASP    43       1.073 -11.743   2.394  1.00 37.79           H 
ATOM    694  HA  ASP    43       2.979 -13.567   3.593  1.00 20.33           H 
ATOM    695 1HB  ASP    43       2.049 -13.380   0.713  1.00 37.79           H 
ATOM    696 2HB  ASP    43       1.277 -14.352   1.962  1.00 37.79           H 
ATOM    697  N   GLY    44       4.004 -11.035   1.912  1.00 12.42           N 
ATOM    698  CA  GLY    44       5.191 -10.275   1.530  1.00 42.21           C 
ATOM    699  C   GLY    44       5.411 -10.188   0.022  1.00 44.44           C 
ATOM    700  O   GLY    44       6.471  -9.749  -0.430  1.00 65.25           O 
ATOM    701  H   GLY    44       3.132 -10.587   1.946  1.00 37.79           H 
ATOM    702 1HA  GLY    44       6.059 -10.735   1.980  1.00 37.79           H 
ATOM    703 2HA  GLY    44       5.095  -9.272   1.919  1.00 37.79           H 
ATOM    704  N   VAL    45       4.420 -10.600  -0.765  1.00 43.22           N 
ATOM    705  CA  VAL    45       4.533 -10.536  -2.227  1.00  2.11           C 
ATOM    706  C   VAL    45       4.348  -9.093  -2.724  1.00  0.42           C 
ATOM    707  O   VAL    45       3.403  -8.407  -2.331  1.00 64.13           O 
ATOM    708  CB  VAL    45       3.504 -11.462  -2.920  1.00 34.25           C 
ATOM    709  CG1 VAL    45       3.731 -11.503  -4.430  1.00 53.21           C 
ATOM    710  CG2 VAL    45       3.555 -12.864  -2.319  1.00 25.44           C 
ATOM    711  H   VAL    45       3.598 -10.949  -0.359  1.00 37.79           H 
ATOM    712  HA  VAL    45       5.528 -10.874  -2.496  1.00 53.41           H 
ATOM    713  HB  VAL    45       2.516 -11.059  -2.743  1.00 55.33           H 
ATOM    714 1HG1 VAL    45       3.597 -10.513  -4.841  1.00 37.79           H 
ATOM    715 2HG1 VAL    45       3.019 -12.179  -4.884  1.00 37.79           H 
ATOM    716 3HG1 VAL    45       4.734 -11.846  -4.637  1.00 37.79           H 
ATOM    717 1HG2 VAL    45       4.545 -13.276  -2.443  1.00 37.79           H 
ATOM    718 2HG2 VAL    45       2.836 -13.498  -2.820  1.00 37.79           H 
ATOM    719 3HG2 VAL    45       3.314 -12.813  -1.266  1.00 37.79           H 
ATOM    720  N   LYS    46       5.247  -8.640  -3.596  1.00 54.35           N 
ATOM    721  CA  LYS    46       5.262  -7.241  -4.027  1.00 10.30           C 
ATOM    722  C   LYS    46       3.981  -6.838  -4.779  1.00  5.11           C 
ATOM    723  O   LYS    46       3.448  -7.593  -5.594  1.00 22.04           O 
ATOM    724  CB  LYS    46       6.490  -6.958  -4.898  1.00 70.52           C 
ATOM    725  CG  LYS    46       6.629  -5.487  -5.273  1.00 32.21           C 
ATOM    726  CD  LYS    46       7.899  -5.207  -6.068  1.00 52.33           C 
ATOM    727  CE  LYS    46       8.023  -3.728  -6.407  1.00 24.42           C 
ATOM    728  NZ  LYS    46       9.285  -3.420  -7.127  1.00 32.13           N 
ATOM    729  H   LYS    46       5.913  -9.259  -3.959  1.00 37.79           H 
ATOM    730  HA  LYS    46       5.335  -6.635  -3.134  1.00 55.44           H 
ATOM    731 1HB  LYS    46       6.412  -7.534  -5.808  1.00 37.79           H 
ATOM    732 2HB  LYS    46       7.380  -7.264  -4.363  1.00 37.79           H 
ATOM    733 1HG  LYS    46       6.643  -4.896  -4.367  1.00 37.79           H 
ATOM    734 2HG  LYS    46       5.775  -5.199  -5.873  1.00 37.79           H 
ATOM    735 1HD  LYS    46       7.870  -5.774  -6.988  1.00 37.79           H 
ATOM    736 2HD  LYS    46       8.758  -5.508  -5.484  1.00 37.79           H 
ATOM    737 1HE  LYS    46       7.992  -3.155  -5.491  1.00 37.79           H 
ATOM    738 2HE  LYS    46       7.189  -3.444  -7.033  1.00 37.79           H 
ATOM    739 1HZ  LYS    46      10.105  -3.689  -6.547  1.00 37.79           H 
ATOM    740 2HZ  LYS    46       9.341  -2.403  -7.337  1.00 37.79           H 
ATOM    741 3HZ  LYS    46       9.321  -3.945  -8.021  1.00 37.79           H 
ATOM    742  N   LYS    47       3.507  -5.633  -4.485  1.00 65.11           N 
ATOM    743  CA  LYS    47       2.312  -5.055  -5.106  1.00 12.42           C 
ATOM    744  C   LYS    47       2.574  -3.587  -5.473  1.00 60.21           C 
ATOM    745  O   LYS    47       3.574  -3.002  -5.049  1.00 74.33           O 
ATOM    746  CB  LYS    47       1.117  -5.133  -4.136  1.00  2.20           C 
ATOM    747  CG  LYS    47       0.718  -6.551  -3.730  1.00 54.23           C 
ATOM    748  CD  LYS    47       0.148  -7.342  -4.903  1.00 44.32           C 
ATOM    749  CE  LYS    47      -0.235  -8.762  -4.495  1.00 52.11           C 
ATOM    750  NZ  LYS    47       0.940  -9.549  -4.035  1.00 24.05           N 
ATOM    751  H   LYS    47       3.986  -5.098  -3.821  1.00 37.79           H 
ATOM    752  HA  LYS    47       2.084  -5.609  -6.005  1.00 25.00           H 
ATOM    753 1HB  LYS    47       0.261  -4.660  -4.600  1.00 37.79           H 
ATOM    754 2HB  LYS    47       1.368  -4.588  -3.236  1.00 37.79           H 
ATOM    755 1HG  LYS    47      -0.029  -6.494  -2.949  1.00 37.79           H 
ATOM    756 2HG  LYS    47       1.592  -7.066  -3.354  1.00 37.79           H 
ATOM    757 1HD  LYS    47       0.891  -7.390  -5.688  1.00 37.79           H 
ATOM    758 2HD  LYS    47      -0.733  -6.835  -5.273  1.00 37.79           H 
ATOM    759 1HE  LYS    47      -0.679  -9.261  -5.347  1.00 37.79           H 
ATOM    760 2HE  LYS    47      -0.958  -8.712  -3.694  1.00 37.79           H 
ATOM    761 1HZ  LYS    47       1.355  -9.114  -3.181  1.00 37.79           H 
ATOM    762 2HZ  LYS    47       1.663  -9.584  -4.779  1.00 37.79           H 
ATOM    763 3HZ  LYS    47       0.651 -10.520  -3.803  1.00 37.79           H 
ATOM    764  N   GLN    48       1.687  -2.994  -6.262  1.00 41.13           N 
ATOM    765  CA  GLN    48       1.772  -1.563  -6.575  1.00 14.12           C 
ATOM    766  C   GLN    48       0.375  -0.925  -6.557  1.00 12.32           C 
ATOM    767  O   GLN    48      -0.478  -1.255  -7.380  1.00  3.41           O 
ATOM    768  CB  GLN    48       2.450  -1.343  -7.935  1.00 72.20           C 
ATOM    769  CG  GLN    48       2.762   0.122  -8.229  1.00 42.23           C 
ATOM    770  CD  GLN    48       3.547   0.309  -9.513  1.00 13.05           C 
ATOM    771  OE1 GLN    48       4.777   0.300  -9.512  1.00 73.54           O 
ATOM    772  NE2 GLN    48       2.849   0.479 -10.616  1.00 31.21           N 
ATOM    773  H   GLN    48       0.958  -3.527  -6.648  1.00 37.79           H 
ATOM    774  HA  GLN    48       2.374  -1.094  -5.806  1.00 52.12           H 
ATOM    775 1HB  GLN    48       1.800  -1.716  -8.714  1.00 37.79           H 
ATOM    776 2HB  GLN    48       3.377  -1.900  -7.957  1.00 37.79           H 
ATOM    777 1HG  GLN    48       3.339   0.527  -7.410  1.00 37.79           H 
ATOM    778 2HG  GLN    48       1.831   0.666  -8.312  1.00 37.79           H 
ATOM    779 1HE2 GLN    48       1.875   0.470 -10.553  1.00 37.79           H 
ATOM    780 2HE2 GLN    48       3.339   0.619 -11.452  1.00 37.79           H 
ATOM    781  N   ILE    49       0.146  -0.011  -5.615  1.00 63.01           N 
ATOM    782  CA  ILE    49      -1.192   0.556  -5.398  1.00 42.34           C 
ATOM    783  C   ILE    49      -1.189   2.093  -5.480  1.00 34.32           C 
ATOM    784  O   ILE    49      -0.243   2.753  -5.045  1.00 62.45           O 
ATOM    785  CB  ILE    49      -1.758   0.108  -4.020  1.00 22.44           C 
ATOM    786  CG1 ILE    49      -1.835  -1.429  -3.946  1.00 34.13           C 
ATOM    787  CG2 ILE    49      -3.131   0.734  -3.753  1.00 42.50           C 
ATOM    788  CD1 ILE    49      -2.295  -1.962  -2.604  1.00 41.43           C 
ATOM    789  H   ILE    49       0.894   0.298  -5.057  1.00 37.79           H 
ATOM    790  HA  ILE    49      -1.847   0.171  -6.171  1.00 72.51           H 
ATOM    791  HB  ILE    49      -1.081   0.458  -3.254  1.00 74.33           H 
ATOM    792 1HG1 ILE    49      -0.855  -1.840  -4.145  1.00 37.79           H 
ATOM    793 2HG1 ILE    49      -2.526  -1.786  -4.694  1.00 37.79           H 
ATOM    794 1HG2 ILE    49      -3.499   0.399  -2.795  1.00 37.79           H 
ATOM    795 2HG2 ILE    49      -3.823   0.438  -4.528  1.00 37.79           H 
ATOM    796 3HG2 ILE    49      -3.042   1.812  -3.745  1.00 37.79           H 
ATOM    797 1HD1 ILE    49      -1.606  -1.646  -1.834  1.00 37.79           H 
ATOM    798 2HD1 ILE    49      -2.324  -3.041  -2.638  1.00 37.79           H 
ATOM    799 3HD1 ILE    49      -3.282  -1.582  -2.382  1.00 37.79           H 
ATOM    800  N   THR    50      -2.260   2.650  -6.049  1.00 12.32           N 
ATOM    801  CA  THR    50      -2.417   4.108  -6.182  1.00 23.40           C 
ATOM    802  C   THR    50      -3.593   4.624  -5.336  1.00 43.22           C 
ATOM    803  O   THR    50      -4.733   4.196  -5.519  1.00  1.20           O 
ATOM    804  CB  THR    50      -2.647   4.521  -7.662  1.00 13.23           C 
ATOM    805  OG1 THR    50      -1.533   4.108  -8.468  1.00 53.32           O 
ATOM    806  CG2 THR    50      -2.837   6.033  -7.801  1.00 70.42           C 
ATOM    807  H   THR    50      -2.967   2.066  -6.393  1.00 37.79           H 
ATOM    808  HA  THR    50      -1.505   4.578  -5.837  1.00 33.34           H 
ATOM    809  HB  THR    50      -3.540   4.027  -8.023  1.00 52.11           H 
ATOM    810  HG1 THR    50      -1.832   3.953  -9.375  1.00 21.21           H 
ATOM    811 1HG2 THR    50      -2.995   6.283  -8.842  1.00 37.79           H 
ATOM    812 2HG2 THR    50      -1.957   6.544  -7.440  1.00 37.79           H 
ATOM    813 3HG2 THR    50      -3.695   6.342  -7.222  1.00 37.79           H 
ATOM    814  N   PHE    51      -3.313   5.548  -4.417  1.00 61.31           N 
ATOM    815  CA  PHE    51      -4.349   6.121  -3.544  1.00 61.02           C 
ATOM    816  C   PHE    51      -4.439   7.651  -3.699  1.00  3.32           C 
ATOM    817  O   PHE    51      -3.613   8.272  -4.370  1.00 14.14           O 
ATOM    818  CB  PHE    51      -4.083   5.752  -2.072  1.00  2.33           C 
ATOM    819  CG  PHE    51      -2.799   6.319  -1.506  1.00 44.42           C 
ATOM    820  CD1 PHE    51      -1.578   5.704  -1.753  1.00 41.41           C 
ATOM    821  CD2 PHE    51      -2.818   7.465  -0.719  1.00 23.55           C 
ATOM    822  CE1 PHE    51      -0.407   6.223  -1.232  1.00 12.42           C 
ATOM    823  CE2 PHE    51      -1.649   7.986  -0.197  1.00 30.20           C 
ATOM    824  CZ  PHE    51      -0.444   7.364  -0.452  1.00 12.21           C 
ATOM    825  H   PHE    51      -2.387   5.859  -4.324  1.00 37.79           H 
ATOM    826  HA  PHE    51      -5.299   5.697  -3.839  1.00 75.34           H 
ATOM    827 1HB  PHE    51      -4.039   4.675  -1.984  1.00 37.79           H 
ATOM    828 2HB  PHE    51      -4.901   6.117  -1.466  1.00 37.79           H 
ATOM    829  HD1 PHE    51      -1.547   4.812  -2.363  1.00 53.43           H 
ATOM    830  HD2 PHE    51      -3.761   7.954  -0.517  1.00 71.12           H 
ATOM    831  HE1 PHE    51       0.535   5.734  -1.430  1.00 24.20           H 
ATOM    832  HE2 PHE    51      -1.679   8.879   0.411  1.00 10.11           H 
ATOM    833  HZ  PHE    51       0.471   7.770  -0.044  1.00 51.34           H 
ATOM    834  N   ARG    52      -5.451   8.250  -3.073  1.00 14.43           N 
ATOM    835  CA  ARG    52      -5.648   9.703  -3.126  1.00 61.04           C 
ATOM    836  C   ARG    52      -6.253  10.226  -1.813  1.00 60.55           C 
ATOM    837  O   ARG    52      -6.974   9.505  -1.120  1.00 50.23           O 
ATOM    838  CB  ARG    52      -6.553  10.078  -4.314  1.00 11.20           C 
ATOM    839  CG  ARG    52      -6.758  11.583  -4.487  1.00 12.44           C 
ATOM    840  CD  ARG    52      -7.656  11.902  -5.677  1.00 33.42           C 
ATOM    841  NE  ARG    52      -8.997  11.343  -5.518  1.00 12.14           N 
ATOM    842  CZ  ARG    52      -9.762  10.979  -6.509  1.00 71.40           C 
ATOM    843  NH1 ARG    52      -9.366  11.120  -7.735  1.00  2.21           N 
ATOM    844  NH2 ARG    52     -10.926  10.479  -6.271  1.00 34.31           N 
ATOM    845  H   ARG    52      -6.080   7.704  -2.560  1.00 37.79           H 
ATOM    846  HA  ARG    52      -4.680  10.165  -3.264  1.00 31.44           H 
ATOM    847 1HB  ARG    52      -7.521   9.617  -4.174  1.00 37.79           H 
ATOM    848 2HB  ARG    52      -6.110   9.692  -5.221  1.00 37.79           H 
ATOM    849 1HG  ARG    52      -5.796  12.053  -4.638  1.00 37.79           H 
ATOM    850 2HG  ARG    52      -7.214  11.979  -3.591  1.00 37.79           H 
ATOM    851 1HD  ARG    52      -7.206  11.491  -6.572  1.00 37.79           H 
ATOM    852 2HD  ARG    52      -7.734  12.976  -5.778  1.00 37.79           H 
ATOM    853  HE  ARG    52      -9.341  11.240  -4.606  1.00 63.42           H 
ATOM    854 1HH1 ARG    52      -8.474  11.510  -7.927  1.00 37.79           H 
ATOM    855 2HH1 ARG    52      -9.964  10.845  -8.487  1.00 37.79           H 
ATOM    856 1HH2 ARG    52     -11.241  10.374  -5.331  1.00 37.79           H 
ATOM    857 2HH2 ARG    52     -11.512  10.199  -7.031  1.00 37.79           H 
ATOM   1084  N   ALA    66       7.886   6.509   6.773  1.00 33.30           N 
ATOM   1085  CA  ALA    66       6.896   5.734   7.524  1.00 61.21           C 
ATOM   1086  C   ALA    66       6.144   4.745   6.622  1.00 32.42           C 
ATOM   1087  O   ALA    66       6.234   4.807   5.393  1.00 74.34           O 
ATOM   1088  CB  ALA    66       5.910   6.673   8.214  1.00 33.23           C 
ATOM   1089  H   ALA    66       7.704   7.454   6.597  1.00 37.79           H 
ATOM   1090  HA  ALA    66       7.418   5.179   8.290  1.00 21.04           H 
ATOM   1091 1HB  ALA    66       6.449   7.363   8.846  1.00 37.79           H 
ATOM   1092 2HB  ALA    66       5.221   6.097   8.817  1.00 37.79           H 
ATOM   1093 3HB  ALA    66       5.358   7.227   7.468  1.00 37.79           H 
ATOM   1094  N   PHE    67       5.385   3.847   7.242  1.00 24.01           N 
ATOM   1095  CA  PHE    67       4.688   2.787   6.514  1.00 25.55           C 
ATOM   1096  C   PHE    67       3.168   3.004   6.510  1.00 55.04           C 
ATOM   1097  O   PHE    67       2.639   3.845   7.236  1.00 71.21           O 
ATOM   1098  CB  PHE    67       5.033   1.423   7.125  1.00 72.14           C 
ATOM   1099  CG  PHE    67       6.517   1.142   7.151  1.00 61.03           C 
ATOM   1100  CD1 PHE    67       7.147   0.552   6.063  1.00  1.43           C 
ATOM   1101  CD2 PHE    67       7.284   1.478   8.258  1.00 21.24           C 
ATOM   1102  CE1 PHE    67       8.507   0.304   6.080  1.00 42.30           C 
ATOM   1103  CE2 PHE    67       8.644   1.230   8.279  1.00 14.12           C 
ATOM   1104  CZ  PHE    67       9.256   0.642   7.189  1.00 50.14           C 
ATOM   1105  H   PHE    67       5.279   3.903   8.215  1.00 37.79           H 
ATOM   1106  HA  PHE    67       5.039   2.803   5.491  1.00 73.32           H 
ATOM   1107 1HB  PHE    67       4.555   0.641   6.548  1.00 37.79           H 
ATOM   1108 2HB  PHE    67       4.667   1.386   8.141  1.00 37.79           H 
ATOM   1109  HD1 PHE    67       6.564   0.284   5.194  1.00  0.25           H 
ATOM   1110  HD2 PHE    67       6.808   1.938   9.112  1.00 22.25           H 
ATOM   1111  HE1 PHE    67       8.983  -0.155   5.225  1.00  1.04           H 
ATOM   1112  HE2 PHE    67       9.227   1.495   9.147  1.00 75.12           H 
ATOM   1113  HZ  PHE    67      10.319   0.447   7.204  1.00 74.31           H 
ATOM   1114  N   LEU    68       2.478   2.231   5.683  1.00 35.22           N 
ATOM   1115  CA  LEU    68       1.029   2.328   5.527  1.00 15.24           C 
ATOM   1116  C   LEU    68       0.387   0.939   5.574  1.00 62.43           C 
ATOM   1117  O   LEU    68       1.025  -0.068   5.270  1.00  2.30           O 
ATOM   1118  CB  LEU    68       0.661   3.011   4.198  1.00 72.32           C 
ATOM   1119  CG  LEU    68       1.066   4.487   4.065  1.00  0.21           C 
ATOM   1120  CD1 LEU    68       0.669   5.028   2.693  1.00 24.04           C 
ATOM   1121  CD2 LEU    68       0.438   5.325   5.176  1.00 44.23           C 
ATOM   1122  H   LEU    68       2.958   1.555   5.171  1.00 37.79           H 
ATOM   1123  HA  LEU    68       0.641   2.919   6.347  1.00 44.13           H 
ATOM   1124 1HB  LEU    68      -0.412   2.943   4.069  1.00 37.79           H 
ATOM   1125 2HB  LEU    68       1.133   2.459   3.397  1.00 37.79           H 
ATOM   1126  HG  LEU    68       2.141   4.566   4.153  1.00 14.14           H 
ATOM   1127 1HD1 LEU    68       1.167   4.457   1.923  1.00 37.79           H 
ATOM   1128 2HD1 LEU    68       0.962   6.065   2.617  1.00 37.79           H 
ATOM   1129 3HD1 LEU    68      -0.401   4.946   2.566  1.00 37.79           H 
ATOM   1130 1HD2 LEU    68      -0.639   5.257   5.118  1.00 37.79           H 
ATOM   1131 2HD2 LEU    68       0.741   6.356   5.066  1.00 37.79           H 
ATOM   1132 3HD2 LEU    68       0.769   4.956   6.136  1.00 37.79           H 
ATOM   1133  N   ARG    69      -0.881   0.906   5.939  1.00 72.04           N 
ATOM   1134  CA  ARG    69      -1.646  -0.331   6.041  1.00 31.20           C 
ATOM   1135  C   ARG    69      -2.964  -0.175   5.274  1.00 32.31           C 
ATOM   1136  O   ARG    69      -3.812   0.630   5.647  1.00 22.14           O 
ATOM   1137  CB  ARG    69      -1.899  -0.600   7.530  1.00 41.14           C 
ATOM   1138  CG  ARG    69      -2.595  -1.915   7.863  1.00 34.12           C 
ATOM   1139  CD  ARG    69      -2.746  -2.052   9.373  1.00 73.44           C 
ATOM   1140  NE  ARG    69      -3.442  -3.266   9.785  1.00 34.12           N 
ATOM   1141  CZ  ARG    69      -3.940  -3.428  10.981  1.00 45.14           C 
ATOM   1142  NH1 ARG    69      -3.904  -2.460  11.843  1.00 23.24           N 
ATOM   1143  NH2 ARG    69      -4.503  -4.544  11.308  1.00 21.24           N 
ATOM   1144  H   ARG    69      -1.323   1.748   6.155  1.00 37.79           H 
ATOM   1145  HA  ARG    69      -1.067  -1.140   5.616  1.00 13.24           H 
ATOM   1146 1HB  ARG    69      -2.505   0.207   7.923  1.00 37.79           H 
ATOM   1147 2HB  ARG    69      -0.949  -0.593   8.044  1.00 37.79           H 
ATOM   1148 1HG  ARG    69      -2.002  -2.737   7.489  1.00 37.79           H 
ATOM   1149 2HG  ARG    69      -3.574  -1.926   7.403  1.00 37.79           H 
ATOM   1150 1HD  ARG    69      -3.297  -1.194   9.739  1.00 37.79           H 
ATOM   1151 2HD  ARG    69      -1.762  -2.053   9.818  1.00 37.79           H 
ATOM   1152  HE  ARG    69      -3.515  -3.994   9.142  1.00  1.31           H 
ATOM   1153 1HH1 ARG    69      -3.496  -1.580  11.593  1.00 37.79           H 
ATOM   1154 2HH1 ARG    69      -4.278  -2.594  12.758  1.00 37.79           H 
ATOM   1155 1HH2 ARG    69      -4.560  -5.290  10.647  1.00 37.79           H 
ATOM   1156 2HH2 ARG    69      -4.878  -4.659  12.224  1.00 37.79           H 
ATOM   1157  N   LEU    70      -3.132  -0.943   4.204  1.00 20.55           N 
ATOM   1158  CA  LEU    70      -4.292  -0.796   3.320  1.00 33.33           C 
ATOM   1159  C   LEU    70      -5.294  -1.938   3.514  1.00 12.31           C 
ATOM   1160  O   LEU    70      -4.933  -3.118   3.489  1.00 73.23           O 
ATOM   1161  CB  LEU    70      -3.854  -0.723   1.842  1.00 62.21           C 
ATOM   1162  CG  LEU    70      -3.135   0.575   1.407  1.00 75.23           C 
ATOM   1163  CD1 LEU    70      -1.827   0.781   2.170  1.00 73.03           C 
ATOM   1164  CD2 LEU    70      -2.881   0.569  -0.097  1.00 15.32           C 
ATOM   1165  H   LEU    70      -2.464  -1.628   4.001  1.00 37.79           H 
ATOM   1166  HA  LEU    70      -4.783   0.134   3.578  1.00  3.31           H 
ATOM   1167 1HB  LEU    70      -4.733  -0.842   1.223  1.00 37.79           H 
ATOM   1168 2HB  LEU    70      -3.190  -1.554   1.650  1.00 37.79           H 
ATOM   1169  HG  LEU    70      -3.777   1.417   1.627  1.00  5.31           H 
ATOM   1170 1HD1 LEU    70      -1.176  -0.066   2.009  1.00 37.79           H 
ATOM   1171 2HD1 LEU    70      -2.036   0.878   3.225  1.00 37.79           H 
ATOM   1172 3HD1 LEU    70      -1.339   1.680   1.818  1.00 37.79           H 
ATOM   1173 1HD2 LEU    70      -3.822   0.504  -0.623  1.00 37.79           H 
ATOM   1174 2HD2 LEU    70      -2.266  -0.281  -0.356  1.00 37.79           H 
ATOM   1175 3HD2 LEU    70      -2.373   1.480  -0.383  1.00 37.79           H 
ATOM   1176  N   TYR    71      -6.554  -1.572   3.705  1.00  4.11           N 
ATOM   1177  CA  TYR    71      -7.629  -2.541   3.923  1.00 10.13           C 
ATOM   1178  C   TYR    71      -8.475  -2.719   2.657  1.00 15.31           C 
ATOM   1179  O   TYR    71      -9.033  -1.753   2.128  1.00 52.43           O 
ATOM   1180  CB  TYR    71      -8.522  -2.073   5.079  1.00  1.32           C 
ATOM   1181  CG  TYR    71      -7.754  -1.742   6.347  1.00 20.41           C 
ATOM   1182  CD1 TYR    71      -7.517  -0.420   6.716  1.00 63.43           C 
ATOM   1183  CD2 TYR    71      -7.263  -2.749   7.170  1.00 71.51           C 
ATOM   1184  CE1 TYR    71      -6.818  -0.114   7.869  1.00 32.32           C 
ATOM   1185  CE2 TYR    71      -6.565  -2.449   8.324  1.00 14.31           C 
ATOM   1186  CZ  TYR    71      -6.345  -1.131   8.667  1.00 12.13           C 
ATOM   1187  OH  TYR    71      -5.649  -0.833   9.816  1.00 52.25           O 
ATOM   1188  H   TYR    71      -6.772  -0.618   3.704  1.00 37.79           H 
ATOM   1189  HA  TYR    71      -7.183  -3.490   4.185  1.00 71.44           H 
ATOM   1190 1HB  TYR    71      -9.234  -2.852   5.314  1.00 37.79           H 
ATOM   1191 2HB  TYR    71      -9.059  -1.185   4.774  1.00 37.79           H 
ATOM   1192  HD1 TYR    71      -7.889   0.376   6.089  1.00 20.44           H 
ATOM   1193  HD2 TYR    71      -7.435  -3.782   6.901  1.00 52.23           H 
ATOM   1194  HE1 TYR    71      -6.644   0.918   8.138  1.00 35.22           H 
ATOM   1195  HE2 TYR    71      -6.193  -3.246   8.951  1.00 22.14           H 
ATOM   1196  HH  TYR    71      -6.100  -0.128  10.295  1.00 71.31           H 
ATOM   1197  N   VAL    72      -8.558  -3.951   2.167  1.00 31.02           N 
ATOM   1198  CA  VAL    72      -9.406  -4.271   1.016  1.00 71.24           C 
ATOM   1199  C   VAL    72     -10.546  -5.213   1.432  1.00 53.44           C 
ATOM   1200  O   VAL    72     -10.357  -6.114   2.254  1.00 50.24           O 
ATOM   1201  CB  VAL    72      -8.584  -4.905  -0.138  1.00 55.51           C 
ATOM   1202  CG1 VAL    72      -7.912  -6.202   0.306  1.00 24.42           C 
ATOM   1203  CG2 VAL    72      -9.456  -5.135  -1.372  1.00 31.30           C 
ATOM   1204  H   VAL    72      -8.036  -4.668   2.588  1.00 37.79           H 
ATOM   1205  HA  VAL    72      -9.839  -3.345   0.653  1.00 25.11           H 
ATOM   1206  HB  VAL    72      -7.803  -4.207  -0.409  1.00 74.53           H 
ATOM   1207 1HG1 VAL    72      -8.665  -6.920   0.598  1.00 37.79           H 
ATOM   1208 2HG1 VAL    72      -7.259  -6.005   1.146  1.00 37.79           H 
ATOM   1209 3HG1 VAL    72      -7.332  -6.603  -0.512  1.00 37.79           H 
ATOM   1210 1HG2 VAL    72      -8.857  -5.570  -2.160  1.00 37.79           H 
ATOM   1211 2HG2 VAL    72      -9.861  -4.191  -1.710  1.00 37.79           H 
ATOM   1212 3HG2 VAL    72     -10.267  -5.806  -1.125  1.00 37.79           H 
ATOM   1433  N   LYS    88     -10.565   0.120   0.556  1.00 13.14           N 
ATOM   1434  CA  LYS    88     -11.628   0.878   1.232  1.00 34.52           C 
ATOM   1435  C   LYS    88     -11.065   1.902   2.233  1.00 74.05           C 
ATOM   1436  O   LYS    88     -11.679   2.943   2.476  1.00 35.55           O 
ATOM   1437  CB  LYS    88     -12.598  -0.087   1.938  1.00  4.12           C 
ATOM   1438  CG  LYS    88     -11.936  -1.000   2.970  1.00 35.03           C 
ATOM   1439  CD  LYS    88     -12.904  -2.045   3.527  1.00 34.12           C 
ATOM   1440  CE  LYS    88     -14.118  -1.413   4.198  1.00 34.05           C 
ATOM   1441  NZ  LYS    88     -15.086  -2.440   4.666  1.00 62.25           N 
ATOM   1442  H   LYS    88     -10.290  -0.747   0.923  1.00 37.79           H 
ATOM   1443  HA  LYS    88     -12.177   1.417   0.470  1.00 54.25           H 
ATOM   1444 1HB  LYS    88     -13.070  -0.709   1.190  1.00 37.79           H 
ATOM   1445 2HB  LYS    88     -13.361   0.493   2.439  1.00 37.79           H 
ATOM   1446 1HG  LYS    88     -11.566  -0.393   3.785  1.00 37.79           H 
ATOM   1447 2HG  LYS    88     -11.110  -1.513   2.500  1.00 37.79           H 
ATOM   1448 1HD  LYS    88     -12.379  -2.651   4.252  1.00 37.79           H 
ATOM   1449 2HD  LYS    88     -13.244  -2.673   2.717  1.00 37.79           H 
ATOM   1450 1HE  LYS    88     -14.610  -0.763   3.490  1.00 37.79           H 
ATOM   1451 2HE  LYS    88     -13.785  -0.833   5.047  1.00 37.79           H 
ATOM   1452 1HZ  LYS    88     -15.374  -3.052   3.875  1.00 37.79           H 
ATOM   1453 2HZ  LYS    88     -15.933  -1.983   5.056  1.00 37.79           H 
ATOM   1454 3HZ  LYS    88     -14.657  -3.030   5.405  1.00 37.79           H 
ATOM   1455  N   SER    89      -9.898   1.608   2.810  1.00 25.23           N 
ATOM   1456  CA  SER    89      -9.257   2.510   3.789  1.00 12.22           C 
ATOM   1457  C   SER    89      -7.758   2.223   3.926  1.00 42.34           C 
ATOM   1458  O   SER    89      -7.279   1.170   3.508  1.00 60.11           O 
ATOM   1459  CB  SER    89      -9.916   2.387   5.175  1.00 73.00           C 
ATOM   1460  OG  SER    89     -11.252   2.865   5.172  1.00 43.43           O 
ATOM   1461  H   SER    89      -9.448   0.771   2.567  1.00 37.79           H 
ATOM   1462  HA  SER    89      -9.382   3.523   3.432  1.00 45.21           H 
ATOM   1463 1HB  SER    89      -9.347   2.962   5.893  1.00 37.79           H 
ATOM   1464 2HB  SER    89      -9.925   1.350   5.477  1.00 37.79           H 
ATOM   1465  HG  SER    89     -11.439   3.292   4.326  1.00 35.04           H 
ATOM   1466  N   TYR    90      -7.022   3.162   4.527  1.00 22.31           N 
ATOM   1467  CA  TYR    90      -5.592   2.966   4.800  1.00 52.02           C 
ATOM   1468  C   TYR    90      -5.207   3.534   6.180  1.00 25.35           C 
ATOM   1469  O   TYR    90      -5.932   4.348   6.755  1.00 34.33           O 
ATOM   1470  CB  TYR    90      -4.723   3.600   3.698  1.00  3.22           C 
ATOM   1471  CG  TYR    90      -4.642   5.117   3.751  1.00 12.41           C 
ATOM   1472  CD1 TYR    90      -3.506   5.753   4.246  1.00 14.15           C 
ATOM   1473  CD2 TYR    90      -5.697   5.910   3.312  1.00  1.54           C 
ATOM   1474  CE1 TYR    90      -3.426   7.130   4.300  1.00 61.11           C 
ATOM   1475  CE2 TYR    90      -5.620   7.287   3.362  1.00  4.32           C 
ATOM   1476  CZ  TYR    90      -4.484   7.891   3.858  1.00 71.13           C 
ATOM   1477  OH  TYR    90      -4.410   9.262   3.914  1.00 41.41           O 
ATOM   1478  H   TYR    90      -7.447   4.003   4.793  1.00 37.79           H 
ATOM   1479  HA  TYR    90      -5.407   1.900   4.812  1.00 71.54           H 
ATOM   1480 1HB  TYR    90      -5.124   3.323   2.732  1.00 37.79           H 
ATOM   1481 2HB  TYR    90      -3.717   3.214   3.782  1.00 37.79           H 
ATOM   1482  HD1 TYR    90      -2.675   5.153   4.591  1.00 33.40           H 
ATOM   1483  HD2 TYR    90      -6.586   5.436   2.926  1.00 13.12           H 
ATOM   1484  HE1 TYR    90      -2.535   7.605   4.687  1.00 45.53           H 
ATOM   1485  HE2 TYR    90      -6.450   7.887   3.016  1.00 23.03           H 
ATOM   1486  HH  TYR    90      -5.216   9.603   4.315  1.00  4.41           H 
ATOM   1487  N   GLU    91      -4.061   3.101   6.694  1.00  3.42           N 
ATOM   1488  CA  GLU    91      -3.603   3.473   8.042  1.00 74.55           C 
ATOM   1489  C   GLU    91      -2.085   3.735   8.057  1.00 64.43           C 
ATOM   1490  O   GLU    91      -1.325   2.996   7.444  1.00 14.34           O 
ATOM   1491  CB  GLU    91      -3.963   2.331   9.010  1.00 43.34           C 
ATOM   1492  CG  GLU    91      -3.512   2.534  10.455  1.00 75.05           C 
ATOM   1493  CD  GLU    91      -3.979   1.404  11.367  1.00  3.12           C 
ATOM   1494  OE1 GLU    91      -3.203   0.448  11.599  1.00  3.41           O 
ATOM   1495  OE2 GLU    91      -5.133   1.462  11.849  1.00 20.45           O 
ATOM   1496  H   GLU    91      -3.506   2.499   6.158  1.00 37.79           H 
ATOM   1497  HA  GLU    91      -4.122   4.373   8.344  1.00  1.55           H 
ATOM   1498 1HB  GLU    91      -3.513   1.417   8.644  1.00 37.79           H 
ATOM   1499 2HB  GLU    91      -5.036   2.209   9.011  1.00 37.79           H 
ATOM   1500 1HG  GLU    91      -3.917   3.468  10.821  1.00 37.79           H 
ATOM   1501 2HG  GLU    91      -2.432   2.579  10.479  1.00 37.79           H 
ATOM   1502  N   GLU    92      -1.642   4.781   8.754  1.00 12.34           N 
ATOM   1503  CA  GLU    92      -0.203   5.086   8.848  1.00 71.13           C 
ATOM   1504  C   GLU    92       0.418   4.348  10.044  1.00 52.44           C 
ATOM   1505  O   GLU    92      -0.029   4.509  11.182  1.00 61.33           O 
ATOM   1506  CB  GLU    92       0.022   6.603   8.977  1.00 35.14           C 
ATOM   1507  CG  GLU    92       1.495   7.009   9.066  1.00 11.32           C 
ATOM   1508  CD  GLU    92       1.690   8.510   9.239  1.00 74.44           C 
ATOM   1509  OE1 GLU    92       1.086   9.085  10.172  1.00 65.13           O 
ATOM   1510  OE2 GLU    92       2.458   9.119   8.460  1.00 12.12           O 
ATOM   1511  H   GLU    92      -2.288   5.360   9.214  1.00 37.79           H 
ATOM   1512  HA  GLU    92       0.268   4.736   7.938  1.00 60.42           H 
ATOM   1513 1HB  GLU    92      -0.481   6.954   9.868  1.00 37.79           H 
ATOM   1514 2HB  GLU    92      -0.413   7.093   8.116  1.00 37.79           H 
ATOM   1515 1HG  GLU    92       1.996   6.694   8.161  1.00 37.79           H 
ATOM   1516 2HG  GLU    92       1.942   6.508   9.913  1.00 37.79           H 
ATOM   1517  N   ILE    93       1.441   3.534   9.781  1.00 73.20           N 
ATOM   1518  CA  ILE    93       2.008   2.638  10.800  1.00 20.14           C 
ATOM   1519  C   ILE    93       3.548   2.644  10.822  1.00 22.02           C 
ATOM   1520  O   ILE    93       4.205   3.283   9.994  1.00 32.45           O 
ATOM   1521  CB  ILE    93       1.531   1.178  10.581  1.00 24.51           C 
ATOM   1522  CG1 ILE    93       1.930   0.684   9.178  1.00 61.02           C 
ATOM   1523  CG2 ILE    93       0.021   1.066  10.788  1.00 55.35           C 
ATOM   1524  CD1 ILE    93       1.584  -0.768   8.912  1.00  1.24           C 
ATOM   1525  H   ILE    93       1.831   3.541   8.883  1.00 37.79           H 
ATOM   1526  HA  ILE    93       1.651   2.963  11.767  1.00 34.52           H 
ATOM   1527  HB  ILE    93       2.013   0.555  11.321  1.00 75.22           H 
ATOM   1528 1HG1 ILE    93       2.999   0.797   9.053  1.00 37.79           H 
ATOM   1529 2HG1 ILE    93       1.424   1.282   8.436  1.00 37.79           H 
ATOM   1530 1HG2 ILE    93      -0.280   0.032  10.698  1.00 37.79           H 
ATOM   1531 2HG2 ILE    93      -0.492   1.655  10.043  1.00 37.79           H 
ATOM   1532 3HG2 ILE    93      -0.236   1.429  11.774  1.00 37.79           H 
ATOM   1533 1HD1 ILE    93       1.851  -1.019   7.896  1.00 37.79           H 
ATOM   1534 2HD1 ILE    93       0.525  -0.920   9.053  1.00 37.79           H 
ATOM   1535 3HD1 ILE    93       2.134  -1.400   9.594  1.00 37.79           H 
ATOM   1536  N   GLN    94       4.107   1.907  11.782  1.00 25.52           N 
ATOM   1537  CA  GLN    94       5.559   1.754  11.921  1.00 31.04           C 
ATOM   1538  C   GLN    94       5.989   0.330  11.526  1.00 61.23           C 
ATOM   1539  O   GLN    94       5.148  -0.536  11.281  1.00 31.03           O 
ATOM   1540  CB  GLN    94       5.979   2.053  13.369  1.00 21.14           C 
ATOM   1541  CG  GLN    94       5.425   1.058  14.384  1.00  2.22           C 
ATOM   1542  CD  GLN    94       5.682   1.459  15.826  1.00 30.12           C 
ATOM   1543  OE1 GLN    94       6.704   1.116  16.411  1.00 11.24           O 
ATOM   1544  NE2 GLN    94       4.746   2.171  16.418  1.00  5.21           N 
ATOM   1545  H   GLN    94       3.521   1.437  12.416  1.00 37.79           H 
ATOM   1546  HA  GLN    94       6.040   2.461  11.259  1.00 33.05           H 
ATOM   1547 1HB  GLN    94       5.629   3.041  13.634  1.00 37.79           H 
ATOM   1548 2HB  GLN    94       7.059   2.036  13.430  1.00 37.79           H 
ATOM   1549 1HG  GLN    94       5.884   0.095  14.207  1.00 37.79           H 
ATOM   1550 2HG  GLN    94       4.358   0.974  14.237  1.00 37.79           H 
ATOM   1551 1HE2 GLN    94       3.944   2.401  15.904  1.00 37.79           H 
ATOM   1552 2HE2 GLN    94       4.889   2.436  17.348  1.00 37.79           H 
ATOM   1553  N   LYS    95       7.298   0.085  11.478  1.00  5.41           N 
ATOM   1554  CA  LYS    95       7.824  -1.236  11.098  1.00 60.52           C 
ATOM   1555  C   LYS    95       7.325  -2.344  12.049  1.00 64.21           C 
ATOM   1556  O   LYS    95       7.222  -3.509  11.660  1.00 61.24           O 
ATOM   1557  CB  LYS    95       9.358  -1.203  11.078  1.00 60.14           C 
ATOM   1558  CG  LYS    95      10.003  -2.482  10.550  1.00 42.14           C 
ATOM   1559  CD  LYS    95      11.525  -2.406  10.602  1.00 61.43           C 
ATOM   1560  CE  LYS    95      12.179  -3.706  10.147  1.00 51.12           C 
ATOM   1561  NZ  LYS    95      13.660  -3.649  10.257  1.00 60.40           N 
ATOM   1562  H   LYS    95       7.927   0.802  11.703  1.00 37.79           H 
ATOM   1563  HA  LYS    95       7.468  -1.454  10.101  1.00 70.35           H 
ATOM   1564 1HB  LYS    95       9.715  -1.033  12.085  1.00 37.79           H 
ATOM   1565 2HB  LYS    95       9.679  -0.380  10.453  1.00 37.79           H 
ATOM   1566 1HG  LYS    95       9.691  -2.635   9.525  1.00 37.79           H 
ATOM   1567 2HG  LYS    95       9.675  -3.315  11.156  1.00 37.79           H 
ATOM   1568 1HD  LYS    95      11.830  -2.196  11.618  1.00 37.79           H 
ATOM   1569 2HD  LYS    95      11.859  -1.607   9.955  1.00 37.79           H 
ATOM   1570 1HE  LYS    95      11.910  -3.891   9.117  1.00 37.79           H 
ATOM   1571 2HE  LYS    95      11.816  -4.514  10.764  1.00 37.79           H 
ATOM   1572 1HZ  LYS    95      14.038  -2.903   9.638  1.00 37.79           H 
ATOM   1573 2HZ  LYS    95      14.076  -4.562   9.983  1.00 37.79           H 
ATOM   1574 3HZ  LYS    95      13.939  -3.442  11.238  1.00 37.79           H 
ATOM   1575  N   ALA    96       7.012  -1.969  13.289  1.00 42.05           N 
ATOM   1576  CA  ALA    96       6.493  -2.915  14.286  1.00  2.42           C 
ATOM   1577  C   ALA    96       5.117  -3.490  13.893  1.00  3.13           C 
ATOM   1578  O   ALA    96       4.809  -4.643  14.207  1.00 40.35           O 
ATOM   1579  CB  ALA    96       6.409  -2.241  15.649  1.00 70.41           C 
ATOM   1580  H   ALA    96       7.150  -1.034  13.551  1.00 37.79           H 
ATOM   1581  HA  ALA    96       7.199  -3.731  14.363  1.00 43.25           H 
ATOM   1582 1HB  ALA    96       5.684  -1.440  15.611  1.00 37.79           H 
ATOM   1583 2HB  ALA    96       7.376  -1.838  15.913  1.00 37.79           H 
ATOM   1584 3HB  ALA    96       6.107  -2.965  16.392  1.00 37.79           H 
ATOM   1585  N   ASP    97       4.290  -2.685  13.218  1.00 32.43           N 
ATOM   1586  CA  ASP    97       2.965  -3.141  12.770  1.00 44.52           C 
ATOM   1587  C   ASP    97       3.079  -4.138  11.604  1.00 21.31           C 
ATOM   1588  O   ASP    97       2.160  -4.917  11.342  1.00 22.43           O 
ATOM   1589  CB  ASP    97       2.101  -1.947  12.348  1.00  2.13           C 
ATOM   1590  CG  ASP    97       1.852  -0.971  13.484  1.00 13.33           C 
ATOM   1591  OD1 ASP    97       2.567   0.048  13.570  1.00 15.33           O 
ATOM   1592  OD2 ASP    97       0.936  -1.217  14.298  1.00 62.34           O 
ATOM   1593  H   ASP    97       4.573  -1.767  13.014  1.00 37.79           H 
ATOM   1594  HA  ASP    97       2.489  -3.638  13.603  1.00 42.11           H 
ATOM   1595 1HB  ASP    97       1.145  -2.310  11.992  1.00 37.79           H 
ATOM   1596 2HB  ASP    97       2.597  -1.419  11.545  1.00 37.79           H 
ATOM   1597  N   LEU    98       4.214  -4.106  10.912  1.00 23.41           N 
ATOM   1598  CA  LEU    98       4.457  -4.993   9.774  1.00  3.22           C 
ATOM   1599  C   LEU    98       4.758  -6.425  10.239  1.00  0.12           C 
ATOM   1600  O   LEU    98       5.502  -6.628  11.202  1.00  2.31           O 
ATOM   1601  CB  LEU    98       5.645  -4.477   8.948  1.00 40.31           C 
ATOM   1602  CG  LEU    98       5.532  -3.029   8.442  1.00 44.24           C 
ATOM   1603  CD1 LEU    98       6.805  -2.617   7.705  1.00 62.02           C 
ATOM   1604  CD2 LEU    98       4.309  -2.861   7.543  1.00 22.32           C 
ATOM   1605  H   LEU    98       4.912  -3.474  11.179  1.00 37.79           H 
ATOM   1606  HA  LEU    98       3.573  -4.997   9.155  1.00 24.10           H 
ATOM   1607 1HB  LEU    98       5.768  -5.125   8.091  1.00 37.79           H 
ATOM   1608 2HB  LEU    98       6.535  -4.550   9.558  1.00 37.79           H 
ATOM   1609  HG  LEU    98       5.414  -2.369   9.289  1.00 23.45           H 
ATOM   1610 1HD1 LEU    98       6.721  -1.587   7.387  1.00 37.79           H 
ATOM   1611 2HD1 LEU    98       6.948  -3.249   6.839  1.00 37.79           H 
ATOM   1612 3HD1 LEU    98       7.653  -2.718   8.366  1.00 37.79           H 
ATOM   1613 1HD2 LEU    98       3.413  -3.088   8.105  1.00 37.79           H 
ATOM   1614 2HD2 LEU    98       4.382  -3.532   6.699  1.00 37.79           H 
ATOM   1615 3HD2 LEU    98       4.260  -1.842   7.189  1.00 37.79           H 
ATOM   1616  N   PRO    99       4.185  -7.445   9.567  1.00 33.35           N 
ATOM   1617  CA  PRO    99       4.536  -8.848   9.830  1.00 25.44           C 
ATOM   1618  C   PRO    99       5.992  -9.156   9.433  1.00 43.55           C 
ATOM   1619  O   PRO    99       6.576  -8.458   8.599  1.00 11.51           O 
ATOM   1620  CB  PRO    99       3.544  -9.643   8.964  1.00 64.23           C 
ATOM   1621  CG  PRO    99       3.107  -8.691   7.903  1.00 64.33           C 
ATOM   1622  CD  PRO    99       3.149  -7.318   8.523  1.00 12.14           C 
ATOM   1623  HA  PRO    99       4.391  -9.099  10.873  1.00  4.13           H 
ATOM   1624 1HB  PRO    99       2.708  -9.965   9.569  1.00 37.79           H 
ATOM   1625 2HB  PRO    99       4.037 -10.507   8.539  1.00 37.79           H 
ATOM   1626 1HG  PRO    99       2.101  -8.929   7.585  1.00 37.79           H 
ATOM   1627 2HG  PRO    99       3.784  -8.744   7.062  1.00 37.79           H 
ATOM   1628 1HD  PRO    99       2.191  -7.070   8.959  1.00 37.79           H 
ATOM   1629 2HD  PRO    99       3.431  -6.580   7.784  1.00 37.79           H 
ATOM   1630  N   GLU   100       6.563 -10.207  10.021  1.00 23.10           N 
ATOM   1631  CA  GLU   100       7.989 -10.537   9.848  1.00 74.33           C 
ATOM   1632  C   GLU   100       8.430 -10.547   8.375  1.00 74.30           C 
ATOM   1633  O   GLU   100       9.502 -10.049   8.034  1.00 20.33           O 
ATOM   1634  CB  GLU   100       8.298 -11.900  10.471  1.00  2.53           C 
ATOM   1635  CG  GLU   100       9.788 -12.229  10.511  1.00 43.34           C 
ATOM   1636  CD  GLU   100      10.058 -13.681  10.874  1.00 22.51           C 
ATOM   1637  OE1 GLU   100      10.762 -14.371  10.105  1.00 70.02           O 
ATOM   1638  OE2 GLU   100       9.538 -14.152  11.909  1.00 13.11           O 
ATOM   1639  H   GLU   100       6.012 -10.781  10.593  1.00 37.79           H 
ATOM   1640  HA  GLU   100       8.560  -9.784  10.371  1.00 21.22           H 
ATOM   1641 1HB  GLU   100       7.794 -12.669   9.901  1.00 37.79           H 
ATOM   1642 2HB  GLU   100       7.921 -11.913  11.484  1.00 37.79           H 
ATOM   1643 1HG  GLU   100      10.265 -11.589  11.243  1.00 37.79           H 
ATOM   1644 2HG  GLU   100      10.212 -12.031   9.535  1.00 37.79           H 
ATOM   1645  N   LYS   101       7.611 -11.119   7.504  1.00 25.44           N 
ATOM   1646  CA  LYS   101       7.970 -11.214   6.087  1.00 34.04           C 
ATOM   1647  C   LYS   101       8.005  -9.825   5.423  1.00 63.15           C 
ATOM   1648  O   LYS   101       8.966  -9.477   4.735  1.00 55.54           O 
ATOM   1649  CB  LYS   101       6.993 -12.136   5.341  1.00 25.52           C 
ATOM   1650  CG  LYS   101       6.762 -13.483   6.030  1.00 13.22           C 
ATOM   1651  CD  LYS   101       8.067 -14.181   6.423  1.00 21.22           C 
ATOM   1652  CE  LYS   101       8.953 -14.503   5.224  1.00 24.33           C 
ATOM   1653  NZ  LYS   101      10.209 -15.180   5.639  1.00 25.43           N 
ATOM   1654  H   LYS   101       6.762 -11.494   7.818  1.00 37.79           H 
ATOM   1655  HA  LYS   101       8.960 -11.645   6.032  1.00 31.13           H 
ATOM   1656 1HB  LYS   101       7.381 -12.327   4.350  1.00 37.79           H 
ATOM   1657 2HB  LYS   101       6.039 -11.636   5.252  1.00 37.79           H 
ATOM   1658 1HG  LYS   101       6.209 -14.126   5.357  1.00 37.79           H 
ATOM   1659 2HG  LYS   101       6.178 -13.318   6.924  1.00 37.79           H 
ATOM   1660 1HD  LYS   101       7.823 -15.103   6.931  1.00 37.79           H 
ATOM   1661 2HD  LYS   101       8.618 -13.540   7.096  1.00 37.79           H 
ATOM   1662 1HE  LYS   101       9.202 -13.583   4.713  1.00 37.79           H 
ATOM   1663 2HE  LYS   101       8.412 -15.153   4.552  1.00 37.79           H 
ATOM   1664 1HZ  LYS   101       9.988 -16.090   6.099  1.00 37.79           H 
ATOM   1665 2HZ  LYS   101      10.733 -14.585   6.312  1.00 37.79           H 
ATOM   1666 3HZ  LYS   101      10.810 -15.361   4.812  1.00 37.79           H 
ATOM   1667  N   VAL   102       6.963  -9.031   5.665  1.00 51.42           N 
ATOM   1668  CA  VAL   102       6.828  -7.700   5.057  1.00 13.14           C 
ATOM   1669  C   VAL   102       7.961  -6.743   5.467  1.00 70.44           C 
ATOM   1670  O   VAL   102       8.545  -6.062   4.620  1.00 25.33           O 
ATOM   1671  CB  VAL   102       5.462  -7.068   5.423  1.00 61.20           C 
ATOM   1672  CG1 VAL   102       5.408  -5.593   5.034  1.00 13.43           C 
ATOM   1673  CG2 VAL   102       4.328  -7.841   4.758  1.00 22.51           C 
ATOM   1674  H   VAL   102       6.268  -9.343   6.278  1.00 37.79           H 
ATOM   1675  HA  VAL   102       6.858  -7.827   3.984  1.00 21.35           H 
ATOM   1676  HB  VAL   102       5.333  -7.139   6.495  1.00  3.12           H 
ATOM   1677 1HG1 VAL   102       4.439  -5.186   5.285  1.00 37.79           H 
ATOM   1678 2HG1 VAL   102       5.577  -5.490   3.971  1.00 37.79           H 
ATOM   1679 3HG1 VAL   102       6.173  -5.051   5.573  1.00 37.79           H 
ATOM   1680 1HG2 VAL   102       3.380  -7.404   5.040  1.00 37.79           H 
ATOM   1681 2HG2 VAL   102       4.357  -8.872   5.079  1.00 37.79           H 
ATOM   1682 3HG2 VAL   102       4.438  -7.793   3.685  1.00 37.79           H 
ATOM   1683  N   LYS   103       8.267  -6.689   6.763  1.00  4.22           N 
ATOM   1684  CA  LYS   103       9.319  -5.797   7.268  1.00 40.22           C 
ATOM   1685  C   LYS   103      10.663  -6.060   6.565  1.00 22.05           C 
ATOM   1686  O   LYS   103      11.366  -5.121   6.183  1.00 23.14           O 
ATOM   1687  CB  LYS   103       9.454  -5.941   8.792  1.00 74.03           C 
ATOM   1688  CG  LYS   103       9.708  -7.371   9.259  1.00 15.33           C 
ATOM   1689  CD  LYS   103       9.812  -7.487  10.781  1.00 12.30           C 
ATOM   1690  CE  LYS   103       8.589  -6.903  11.481  1.00 25.02           C 
ATOM   1691  NZ  LYS   103       8.674  -7.032  12.957  1.00 33.23           N 
ATOM   1692  H   LYS   103       7.779  -7.263   7.393  1.00 37.79           H 
ATOM   1693  HA  LYS   103       9.013  -4.784   7.044  1.00 53.12           H 
ATOM   1694 1HB  LYS   103       8.539  -5.589   9.252  1.00 37.79           H 
ATOM   1695 2HB  LYS   103      10.275  -5.323   9.130  1.00 37.79           H 
ATOM   1696 1HG  LYS   103      10.632  -7.720   8.819  1.00 37.79           H 
ATOM   1697 2HG  LYS   103       8.894  -7.996   8.919  1.00 37.79           H 
ATOM   1698 1HD  LYS   103      10.696  -6.968  11.116  1.00 37.79           H 
ATOM   1699 2HD  LYS   103       9.892  -8.533  11.043  1.00 37.79           H 
ATOM   1700 1HE  LYS   103       7.708  -7.425  11.134  1.00 37.79           H 
ATOM   1701 2HE  LYS   103       8.506  -5.856  11.227  1.00 37.79           H 
ATOM   1702 1HZ  LYS   103       7.821  -6.640  13.402  1.00 37.79           H 
ATOM   1703 2HZ  LYS   103       9.503  -6.520  13.316  1.00 37.79           H 
ATOM   1704 3HZ  LYS   103       8.762  -8.032  13.226  1.00 37.79           H 
ATOM   1705  N   ASP   104      11.001  -7.336   6.374  1.00 74.33           N 
ATOM   1706  CA  ASP   104      12.207  -7.715   5.631  1.00 74.15           C 
ATOM   1707  C   ASP   104      12.101  -7.350   4.136  1.00  4.45           C 
ATOM   1708  O   ASP   104      13.108  -7.033   3.495  1.00 11.44           O 
ATOM   1709  CB  ASP   104      12.493  -9.215   5.795  1.00 11.15           C 
ATOM   1710  CG  ASP   104      12.748  -9.615   7.241  1.00 62.31           C 
ATOM   1711  OD1 ASP   104      12.447 -10.771   7.606  1.00 10.55           O 
ATOM   1712  OD2 ASP   104      13.282  -8.786   8.009  1.00 25.44           O 
ATOM   1713  H   ASP   104      10.432  -8.041   6.752  1.00 37.79           H 
ATOM   1714  HA  ASP   104      13.033  -7.162   6.056  1.00 43.15           H 
ATOM   1715 1HB  ASP   104      13.366  -9.472   5.213  1.00 37.79           H 
ATOM   1716 2HB  ASP   104      11.646  -9.780   5.429  1.00 37.79           H 
ATOM   1717  N   LYS   105      10.884  -7.388   3.586  1.00  1.14           N 
ATOM   1718  CA  LYS   105      10.652  -7.024   2.178  1.00 20.34           C 
ATOM   1719  C   LYS   105      10.869  -5.520   1.926  1.00 22.43           C 
ATOM   1720  O   LYS   105      11.214  -5.114   0.815  1.00 61.23           O 
ATOM   1721  CB  LYS   105       9.231  -7.418   1.746  1.00 35.05           C 
ATOM   1722  CG  LYS   105       8.976  -8.923   1.739  1.00 42.20           C 
ATOM   1723  CD  LYS   105       9.871  -9.656   0.739  1.00 61.44           C 
ATOM   1724  CE  LYS   105       9.601  -9.221  -0.699  1.00 30.51           C 
ATOM   1725  NZ  LYS   105      10.407  -9.998  -1.678  1.00 21.42           N 
ATOM   1726  H   LYS   105      10.122  -7.675   4.136  1.00 37.79           H 
ATOM   1727  HA  LYS   105      11.362  -7.578   1.577  1.00 21.31           H 
ATOM   1728 1HB  LYS   105       9.052  -7.042   0.748  1.00 37.79           H 
ATOM   1729 2HB  LYS   105       8.523  -6.959   2.422  1.00 37.79           H 
ATOM   1730 1HG  LYS   105       7.941  -9.101   1.480  1.00 37.79           H 
ATOM   1731 2HG  LYS   105       9.168  -9.314   2.727  1.00 37.79           H 
ATOM   1732 1HD  LYS   105       9.691 -10.720   0.823  1.00 37.79           H 
ATOM   1733 2HD  LYS   105      10.903  -9.448   0.976  1.00 37.79           H 
ATOM   1734 1HE  LYS   105       9.846  -8.173  -0.799  1.00 37.79           H 
ATOM   1735 2HE  LYS   105       8.554  -9.366  -0.919  1.00 37.79           H 
ATOM   1736 1HZ  LYS   105      10.169 -11.008  -1.617  1.00 37.79           H 
ATOM   1737 2HZ  LYS   105      11.421  -9.880  -1.480  1.00 37.79           H 
ATOM   1738 3HZ  LYS   105      10.215  -9.665  -2.643  1.00 37.79           H 
ATOM   1739  N   PHE   106      10.639  -4.696   2.951  1.00 53.42           N 
ATOM   1740  CA  PHE   106      10.887  -3.249   2.851  1.00 43.42           C 
ATOM   1741  C   PHE   106      12.367  -2.904   3.084  1.00 20.54           C 
ATOM   1742  O   PHE   106      12.974  -2.164   2.309  1.00 24.40           O 
ATOM   1743  CB  PHE   106      10.014  -2.471   3.852  1.00 50.33           C 
ATOM   1744  CG  PHE   106       8.601  -2.227   3.381  1.00 62.42           C 
ATOM   1745  CD1 PHE   106       7.528  -2.912   3.937  1.00 31.22           C 
ATOM   1746  CD2 PHE   106       8.346  -1.298   2.381  1.00 64.05           C 
ATOM   1747  CE1 PHE   106       6.235  -2.673   3.505  1.00 24.10           C 
ATOM   1748  CE2 PHE   106       7.055  -1.060   1.947  1.00  3.31           C 
ATOM   1749  CZ  PHE   106       6.000  -1.747   2.510  1.00  3.33           C 
ATOM   1750  H   PHE   106      10.282  -5.067   3.788  1.00 37.79           H 
ATOM   1751  HA  PHE   106      10.620  -2.942   1.849  1.00 70.40           H 
ATOM   1752 1HB  PHE   106      10.470  -1.508   4.043  1.00 37.79           H 
ATOM   1753 2HB  PHE   106       9.965  -3.024   4.779  1.00 37.79           H 
ATOM   1754  HD1 PHE   106       7.706  -3.639   4.716  1.00 43.04           H 
ATOM   1755  HD2 PHE   106       9.169  -0.756   1.938  1.00 62.33           H 
ATOM   1756  HE1 PHE   106       5.408  -3.214   3.945  1.00 51.23           H 
ATOM   1757  HE2 PHE   106       6.873  -0.334   1.167  1.00 25.15           H 
ATOM   1758  HZ  PHE   106       4.990  -1.562   2.172  1.00 20.52           H 
ATOM   1759  N   THR   107      12.947  -3.437   4.157  1.00 21.33           N 
ATOM   1760  CA  THR   107      14.325  -3.087   4.538  1.00 14.34           C 
ATOM   1761  C   THR   107      15.379  -3.877   3.741  1.00 32.33           C 
ATOM   1762  O   THR   107      16.541  -3.475   3.670  1.00 15.42           O 
ATOM   1763  CB  THR   107      14.565  -3.308   6.052  1.00 41.25           C 
ATOM   1764  OG1 THR   107      15.868  -2.839   6.424  1.00  5.12           O 
ATOM   1765  CG2 THR   107      14.434  -4.778   6.433  1.00 24.43           C 
ATOM   1766  H   THR   107      12.441  -4.072   4.709  1.00 37.79           H 
ATOM   1767  HA  THR   107      14.463  -2.032   4.333  1.00 75.15           H 
ATOM   1768  HB  THR   107      13.822  -2.744   6.601  1.00 52.25           H 
ATOM   1769  HG1 THR   107      15.791  -2.301   7.221  1.00 35.33           H 
ATOM   1770 1HG2 THR   107      13.462  -5.144   6.137  1.00 37.79           H 
ATOM   1771 2HG2 THR   107      14.548  -4.886   7.501  1.00 37.79           H 
ATOM   1772 3HG2 THR   107      15.201  -5.349   5.932  1.00 37.79           H 
ATOM   1773  N   ILE   108      14.966  -4.995   3.136  1.00  3.54           N 
ATOM   1774  CA  ILE   108      15.882  -5.865   2.378  1.00 14.53           C 
ATOM   1775  C   ILE   108      17.036  -6.372   3.279  1.00 41.22           C 
ATOM   1776  O   ILE   108      18.187  -6.486   2.853  1.00  3.13           O 
ATOM   1777  CB  ILE   108      16.441  -5.136   1.117  1.00 33.21           C 
ATOM   1778  CG1 ILE   108      15.298  -4.470   0.327  1.00 71.54           C 
ATOM   1779  CG2 ILE   108      17.207  -6.104   0.211  1.00 45.30           C 
ATOM   1780  CD1 ILE   108      14.257  -5.444  -0.192  1.00 62.14           C 
ATOM   1781  H   ILE   108      14.017  -5.239   3.187  1.00 37.79           H 
ATOM   1782  HA  ILE   108      15.310  -6.721   2.047  1.00 62.10           H 
ATOM   1783  HB  ILE   108      17.130  -4.371   1.446  1.00 75.20           H 
ATOM   1784 1HG1 ILE   108      15.714  -3.945  -0.522  1.00 37.79           H 
ATOM   1785 2HG1 ILE   108      14.793  -3.762   0.967  1.00 37.79           H 
ATOM   1786 1HG2 ILE   108      18.039  -6.526   0.755  1.00 37.79           H 
ATOM   1787 2HG2 ILE   108      17.576  -5.575  -0.656  1.00 37.79           H 
ATOM   1788 3HG2 ILE   108      16.548  -6.900  -0.108  1.00 37.79           H 
ATOM   1789 1HD1 ILE   108      13.496  -4.901  -0.733  1.00 37.79           H 
ATOM   1790 2HD1 ILE   108      13.805  -5.966   0.638  1.00 37.79           H 
ATOM   1791 3HD1 ILE   108      14.728  -6.157  -0.853  1.00 37.79           H 
END
