
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   71 ( 1159),  selected   71 , name 1ny4_A
# Molecule2: number of CA atoms   66 ( 1132),  selected   66 , name T0468.pdb
# PARAMETERS: 1ny4_A.T0468.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    A     2_A      -       -           -
LGA    E     3_A      -       -           -
LGA    D     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    G     6_A      -       -           -
LGA    Y     7_A      D      12          1.468
LGA    P     8_A      V      13          1.082
LGA    A     9_A      Y      14          0.982
LGA    E    10_A      Y      15          1.147
LGA    V    11_A      M      16          0.965
LGA    I    12_A      Q      17          3.312
LGA    E    13_A      I      18          4.792
LGA    I    14_A      K      19          2.757
LGA    I    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    R    17_A      T      23          2.065
LGA    T    18_A      I      24          4.181
LGA    G    19_A      E      25          2.466
LGA    T    20_A      K      26          2.152
LGA    T    21_A      V      27          4.243
LGA    -       -      D      28           -
LGA    -       -      G      29           -
LGA    -       -      R      30           -
LGA    -       -      N      31           -
LGA    G    22_A      L      32          1.232
LGA    D    23_A      R      33          0.766
LGA    V    24_A      N      34          1.114
LGA    T    25_A      Y      35          1.040
LGA    Q    26_A      T      36          0.694
LGA    V    27_A      L      37          1.258
LGA    K    28_A      P      38          1.276
LGA    V    29_A      A      39          1.267
LGA    R    30_A      Y      40          0.966
LGA    I    31_A      D      41          0.797
LGA    L    32_A      E      42          2.305
LGA    E    33_A      -       -           -
LGA    G    34_A      -       -           -
LGA    R    35_A      -       -           -
LGA    D    36_A      -       -           -
LGA    K    37_A      D      43          0.798
LGA    G    38_A      G      44          0.747
LGA    R    39_A      V      45          1.542
LGA    V    40_A      K      46          1.820
LGA    I    41_A      K      47          1.336
LGA    R    42_A      Q      48          1.310
LGA    R    43_A      I      49          0.814
LGA    N    44_A      T      50          0.999
LGA    V    45_A      F      51          1.450
LGA    R    46_A      R      52          1.219
LGA    G    47_A      -       -           -
LGA    P    48_A      -       -           -
LGA    V    49_A      -       -           -
LGA    R    50_A      -       -           -
LGA    V    51_A      A      66          2.736
LGA    G    52_A      F      67          1.587
LGA    D    53_A      L      68          1.408
LGA    I    54_A      R      69          0.633
LGA    L    55_A      L      70          0.622
LGA    I    56_A      Y      71          2.281
LGA    L    57_A      V      72          3.385
LGA    R    58_A      K      88           -
LGA    E    59_A      S      89           -
LGA    T    60_A      Y      90           -
LGA    E    61_A      E      91           -
LGA    R    62_A      E      92           -
LGA    E    63_A      I      93           -
LGA    A    64_A      Q      94           -
LGA    R    65_A      K      95           -
LGA    E    66_A      A      96           -
LGA    I    67_A      D      97           -
LGA    K    68_A      L      98           -
LGA    S    69_A      P      99           -
LGA    R    70_A      E     100           -
LGA    R    71_A      K     101           -
LGA    -       -      V     102           -
LGA    -       -      K     103           -
LGA    -       -      D     104           -
LGA    -       -      K     105           -
LGA    -       -      F     106           -
LGA    -       -      T     107           -
LGA    -       -      I     108           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   71   66    5.0     41    1.98     7.32     56.419     1.974

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.879594 * X  +   0.021877 * Y  +   0.475223 * Z  +   0.359274
  Y_new =   0.255760 * X  +   0.864041 * Y  +   0.433612 * Z  +   0.425240
  Z_new =  -0.401126 * X  +   0.502946 * Y  +  -0.765600 * Z  +  -0.596102 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.560361   -0.581231  [ DEG:   146.6979    -33.3021 ]
  Theta =   0.412745    2.728847  [ DEG:    23.6486    156.3514 ]
  Phi   =   2.858624   -0.282969  [ DEG:   163.7871    -16.2129 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ny4_A                                        
REMARK     2: T0468.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ny4_A.T0468.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   71   66   5.0   41   1.98    7.32  56.419
REMARK  ---------------------------------------------------------- 
MOLECULE 1ny4_A
HEADER    RNA BINDING PROTEIN                     11-FEB-03   1NY4              
TITLE     SOLUTION STRUCTURE OF THE 30S RIBOSOMAL PROTEIN S28E FROM             
TITLE    2 PYROCOCCUS HORIKOSHII. NORTHEAST STRUCTURAL GENOMICS                 
TITLE    3 CONSORTIUM TARGET JR19.                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 30S RIBOSOMAL PROTEIN S28E;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 GENE: RPS28E;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21MGK;                                   
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    JR19, NMR STRUCTURE, AUTOSTRUCTURE, RIBOSOMAL PROTEIN,                
KEYWDS   2 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, PSI, PROTEIN               
KEYWDS   3 STRUCTURE INITIATIVE, NESG                                           
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    J.M.ARAMINI,J.R.CORT,Y.J.HUANG,R.XIAO,T.B.ACTON,C.K.HO,L.-            
AUTHOR   2 Y.SHIH,M.A.KENNEDY,G.T.MONTELIONE,NORTHEAST STRUCTURAL               
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   3   25-JAN-05 1NY4    1       AUTHOR KEYWDS REMARK                     
REVDAT   2   09-DEC-03 1NY4    1       JRNL                                     
REVDAT   1   02-SEP-03 1NY4    0                                                
JRNL        AUTH   J.M.ARAMINI,Y.J.HUANG,J.R.CORT,                              
JRNL        AUTH 2 S.GOLDSMITH-FISCHMAN,R.XIAO,L.-Y.SHIH,C.K.HO,J.LIU,          
JRNL        AUTH 3 B.ROST,B.HONIG,M.A.KENNEDY,T.B.ACTON,G.T.MONTELIONE          
JRNL        TITL   SOLUTION NMR STRUCTURE OF THE 30S RIBOSOMAL                  
JRNL        TITL 2 PROTEIN S28E FROM PYROCOCCUS HORIKOSHII.                     
JRNL        REF    PROTEIN SCI.                  V.  12  2823 2003              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1NY4 A    1    71  UNP    P61030   RS28_PYRHO       1     71             
SEQRES   1 A   82  MET ALA GLU ASP GLU GLY TYR PRO ALA GLU VAL ILE GLU          
SEQRES   2 A   82  ILE ILE GLY ARG THR GLY THR THR GLY ASP VAL THR GLN          
SEQRES   3 A   82  VAL LYS VAL ARG ILE LEU GLU GLY ARG ASP LYS GLY ARG          
SEQRES   4 A   82  VAL ILE ARG ARG ASN VAL ARG GLY PRO VAL ARG VAL GLY          
SEQRES   5 A   82  ASP ILE LEU ILE LEU ARG GLU THR GLU ARG GLU ALA ARG          
SEQRES   6 A   82  GLU ILE LYS SER ARG ARG ALA ALA ALA LEU GLU HIS HIS          
SEQRES   7 A   82  HIS HIS HIS HIS                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -7.404 -14.120  13.089  1.00  0.00           N  
ATOM      2  CA  MET A   1      -8.654 -14.469  13.742  1.00  0.00           C  
ATOM      3  C   MET A   1      -9.688 -14.957  12.725  1.00  0.00           C  
ATOM      4  O   MET A   1     -10.842 -14.531  12.754  1.00  0.00           O  
ATOM      5  CB  MET A   1      -9.203 -13.247  14.482  1.00  0.00           C  
ATOM      6  CG  MET A   1      -8.704 -13.211  15.927  1.00  0.00           C  
ATOM      7  SD  MET A   1      -9.192 -11.680  16.704  1.00  0.00           S  
ATOM      8  CE  MET A   1     -10.952 -11.950  16.842  1.00  0.00           C  
ATOM      9  HA  MET A   1      -8.408 -15.274  14.435  1.00  0.00           H  
ATOM     10  HB2 MET A   1      -8.896 -12.338  13.964  1.00  0.00           H  
ATOM     11  HB3 MET A   1     -10.293 -13.269  14.469  1.00  0.00           H  
ATOM     12  HG2 MET A   1      -9.111 -14.056  16.482  1.00  0.00           H  
ATOM     13  HG3 MET A   1      -7.618 -13.309  15.949  1.00  0.00           H  
ATOM     14  HE1 MET A   1     -11.484 -11.087  16.441  1.00  0.00           H  
ATOM     15  HE2 MET A   1     -11.228 -12.841  16.277  1.00  0.00           H  
ATOM     16  HE3 MET A   1     -11.218 -12.088  17.889  1.00  0.00           H  
ATOM     17  H1  MET A   1      -7.502 -13.618  12.230  1.00  0.00           H  
ATOM     18  N   ALA A   2      -9.235 -15.842  11.849  1.00  0.00           N  
ATOM     19  CA  ALA A   2     -10.107 -16.392  10.824  1.00  0.00           C  
ATOM     20  C   ALA A   2     -10.220 -15.395   9.669  1.00  0.00           C  
ATOM     21  O   ALA A   2      -9.929 -15.731   8.522  1.00  0.00           O  
ATOM     22  CB  ALA A   2     -11.467 -16.731  11.438  1.00  0.00           C  
ATOM     23  H   ALA A   2      -8.296 -16.183  11.831  1.00  0.00           H  
ATOM     24  HA  ALA A   2      -9.648 -17.310  10.457  1.00  0.00           H  
ATOM     25  HB1 ALA A   2     -12.216 -16.030  11.070  1.00  0.00           H  
ATOM     26  HB2 ALA A   2     -11.749 -17.746  11.156  1.00  0.00           H  
ATOM     27  HB3 ALA A   2     -11.403 -16.660  12.523  1.00  0.00           H  
ATOM     28  N   GLU A   3     -10.645 -14.187  10.011  1.00  0.00           N  
ATOM     29  CA  GLU A   3     -10.801 -13.139   9.017  1.00  0.00           C  
ATOM     30  C   GLU A   3      -9.692 -13.234   7.967  1.00  0.00           C  
ATOM     31  O   GLU A   3      -8.515 -13.072   8.286  1.00  0.00           O  
ATOM     32  CB  GLU A   3     -10.817 -11.757   9.675  1.00  0.00           C  
ATOM     33  CG  GLU A   3     -10.026 -11.764  10.985  1.00  0.00           C  
ATOM     34  CD  GLU A   3      -9.415 -10.390  11.263  1.00  0.00           C  
ATOM     35  OE1 GLU A   3     -10.082  -9.363  11.069  1.00  0.00           O  
ATOM     36  OE2 GLU A   3      -8.200 -10.412  11.697  1.00  0.00           O  
ATOM     37  H   GLU A   3     -10.880 -13.922  10.946  1.00  0.00           H  
ATOM     38  HA  GLU A   3     -11.769 -13.324   8.551  1.00  0.00           H  
ATOM     39  HB2 GLU A   3     -10.392 -11.021   8.993  1.00  0.00           H  
ATOM     40  HB3 GLU A   3     -11.846 -11.456   9.869  1.00  0.00           H  
ATOM     41  HG2 GLU A   3     -10.682 -12.048  11.808  1.00  0.00           H  
ATOM     42  HG3 GLU A   3      -9.237 -12.514  10.932  1.00  0.00           H  
ATOM     43  HE2 GLU A   3      -8.069 -11.193  12.308  1.00  0.00           H  
ATOM     44  N   ASP A   4     -10.107 -13.496   6.737  1.00  0.00           N  
ATOM     45  CA  ASP A   4      -9.163 -13.613   5.637  1.00  0.00           C  
ATOM     46  C   ASP A   4      -9.851 -13.204   4.335  1.00  0.00           C  
ATOM     47  O   ASP A   4      -9.399 -13.566   3.249  1.00  0.00           O  
ATOM     48  CB  ASP A   4      -8.676 -15.055   5.482  1.00  0.00           C  
ATOM     49  CG  ASP A   4      -7.205 -15.283   5.836  1.00  0.00           C  
ATOM     50  OD1 ASP A   4      -6.871 -15.660   6.970  1.00  0.00           O  
ATOM     51  OD2 ASP A   4      -6.372 -15.053   4.879  1.00  0.00           O  
ATOM     52  H   ASP A   4     -11.066 -13.626   6.486  1.00  0.00           H  
ATOM     53  HA  ASP A   4      -8.337 -12.953   5.899  1.00  0.00           H  
ATOM     54  HB2 ASP A   4      -9.290 -15.700   6.113  1.00  0.00           H  
ATOM     55  HB3 ASP A   4      -8.839 -15.369   4.452  1.00  0.00           H  
ATOM     56  HD2 ASP A   4      -5.513 -14.700   5.249  1.00  0.00           H  
ATOM     57  N   GLU A   5     -10.933 -12.454   4.484  1.00  0.00           N  
ATOM     58  CA  GLU A   5     -11.687 -11.990   3.331  1.00  0.00           C  
ATOM     59  C   GLU A   5     -11.082 -10.696   2.785  1.00  0.00           C  
ATOM     60  O   GLU A   5     -11.676 -10.041   1.930  1.00  0.00           O  
ATOM     61  CB  GLU A   5     -13.164 -11.799   3.684  1.00  0.00           C  
ATOM     62  CG  GLU A   5     -14.041 -12.806   2.935  1.00  0.00           C  
ATOM     63  CD  GLU A   5     -15.389 -12.987   3.637  1.00  0.00           C  
ATOM     64  OE1 GLU A   5     -15.456 -12.929   4.874  1.00  0.00           O  
ATOM     65  OE2 GLU A   5     -16.390 -13.192   2.849  1.00  0.00           O  
ATOM     66  H   GLU A   5     -11.293 -12.163   5.369  1.00  0.00           H  
ATOM     67  HA  GLU A   5     -11.597 -12.784   2.589  1.00  0.00           H  
ATOM     68  HB2 GLU A   5     -13.304 -11.919   4.758  1.00  0.00           H  
ATOM     69  HB3 GLU A   5     -13.473 -10.785   3.433  1.00  0.00           H  
ATOM     70  HG2 GLU A   5     -14.203 -12.462   1.913  1.00  0.00           H  
ATOM     71  HG3 GLU A   5     -13.528 -13.765   2.872  1.00  0.00           H  
ATOM     72  HE2 GLU A   5     -16.320 -14.101   2.438  1.00  0.00           H  
ATOM     73  N   GLY A   6      -9.907 -10.366   3.302  1.00  0.00           N  
ATOM     74  CA  GLY A   6      -9.216  -9.161   2.877  1.00  0.00           C  
ATOM     75  C   GLY A   6      -7.787  -9.128   3.425  1.00  0.00           C  
ATOM     76  O   GLY A   6      -7.579  -9.237   4.632  1.00  0.00           O  
ATOM     77  H   GLY A   6      -9.432 -10.904   3.997  1.00  0.00           H  
ATOM     78  HA2 GLY A   6      -9.191  -9.116   1.788  1.00  0.00           H  
ATOM     79  HA3 GLY A   6      -9.762  -8.283   3.221  1.00  0.00           H  
ATOM     80  N   TYR A   7      -6.840  -8.974   2.511  1.00  0.00           N  
ATOM     81  CA  TYR A   7      -5.437  -8.924   2.888  1.00  0.00           C  
ATOM     82  C   TYR A   7      -4.924  -7.483   2.901  1.00  0.00           C  
ATOM     83  O   TYR A   7      -4.901  -6.819   1.866  1.00  0.00           O  
ATOM     84  CB  TYR A   7      -4.684  -9.712   1.814  1.00  0.00           C  
ATOM     85  CG  TYR A   7      -4.962  -9.238   0.385  1.00  0.00           C  
ATOM     86  CD1 TYR A   7      -4.183  -8.247  -0.177  1.00  0.00           C  
ATOM     87  CD2 TYR A   7      -5.991  -9.803  -0.341  1.00  0.00           C  
ATOM     88  CE1 TYR A   7      -4.444  -7.802  -1.521  1.00  0.00           C  
ATOM     89  CE2 TYR A   7      -6.252  -9.357  -1.685  1.00  0.00           C  
ATOM     90  CZ  TYR A   7      -5.466  -8.378  -2.209  1.00  0.00           C  
ATOM     91  OH  TYR A   7      -5.712  -7.958  -3.478  1.00  0.00           O  
ATOM     92  H   TYR A   7      -7.017  -8.885   1.531  1.00  0.00           H  
ATOM     93  HA  TYR A   7      -5.343  -9.345   3.889  1.00  0.00           H  
ATOM     94  HB2 TYR A   7      -3.614  -9.639   2.008  1.00  0.00           H  
ATOM     95  HB3 TYR A   7      -4.953 -10.765   1.895  1.00  0.00           H  
ATOM     96  HD1 TYR A   7      -3.370  -7.801   0.397  1.00  0.00           H  
ATOM     97  HD2 TYR A   7      -6.606 -10.585   0.104  1.00  0.00           H  
ATOM     98  HE1 TYR A   7      -3.836  -7.020  -1.977  1.00  0.00           H  
ATOM     99  HE2 TYR A   7      -7.061  -9.794  -2.270  1.00  0.00           H  
ATOM    100  HH  TYR A   7      -4.925  -8.155  -4.063  1.00  0.00           H  
ATOM    101  N   PRO A   8      -4.514  -7.030   4.116  1.00  0.00           N  
ATOM    102  CA  PRO A   8      -4.002  -5.680   4.278  1.00  0.00           C  
ATOM    103  C   PRO A   8      -2.584  -5.559   3.715  1.00  0.00           C  
ATOM    104  O   PRO A   8      -1.824  -6.527   3.727  1.00  0.00           O  
ATOM    105  CB  PRO A   8      -4.074  -5.408   5.770  1.00  0.00           C  
ATOM    106  CG  PRO A   8      -4.183  -6.769   6.437  1.00  0.00           C  
ATOM    107  CD  PRO A   8      -4.526  -7.788   5.363  1.00  0.00           C  
ATOM    108  HA  PRO A   8      -4.559  -5.033   3.755  1.00  0.00           H  
ATOM    109  HB2 PRO A   8      -3.187  -4.874   6.114  1.00  0.00           H  
ATOM    110  HB3 PRO A   8      -4.934  -4.783   6.013  1.00  0.00           H  
ATOM    111  HG2 PRO A   8      -3.245  -7.031   6.926  1.00  0.00           H  
ATOM    112  HG3 PRO A   8      -4.952  -6.756   7.210  1.00  0.00           H  
ATOM    113  HD2 PRO A   8      -3.799  -8.599   5.340  1.00  0.00           H  
ATOM    114  HD3 PRO A   8      -5.502  -8.240   5.542  1.00  0.00           H  
ATOM    115  N   ALA A   9      -2.271  -4.365   3.235  1.00  0.00           N  
ATOM    116  CA  ALA A   9      -0.958  -4.106   2.669  1.00  0.00           C  
ATOM    117  C   ALA A   9      -0.373  -2.844   3.307  1.00  0.00           C  
ATOM    118  O   ALA A   9      -1.055  -1.826   3.417  1.00  0.00           O  
ATOM    119  CB  ALA A   9      -1.071  -3.991   1.148  1.00  0.00           C  
ATOM    120  H   ALA A   9      -2.896  -3.584   3.228  1.00  0.00           H  
ATOM    121  HA  ALA A   9      -0.320  -4.955   2.911  1.00  0.00           H  
ATOM    122  HB1 ALA A   9      -0.073  -3.938   0.712  1.00  0.00           H  
ATOM    123  HB2 ALA A   9      -1.593  -4.864   0.756  1.00  0.00           H  
ATOM    124  HB3 ALA A   9      -1.628  -3.091   0.892  1.00  0.00           H  
ATOM    125  N   GLU A  10       0.884  -2.953   3.710  1.00  0.00           N  
ATOM    126  CA  GLU A  10       1.570  -1.834   4.333  1.00  0.00           C  
ATOM    127  C   GLU A  10       2.524  -1.172   3.337  1.00  0.00           C  
ATOM    128  O   GLU A  10       3.261  -1.858   2.630  1.00  0.00           O  
ATOM    129  CB  GLU A  10       2.316  -2.280   5.592  1.00  0.00           C  
ATOM    130  CG  GLU A  10       2.518  -1.107   6.555  1.00  0.00           C  
ATOM    131  CD  GLU A  10       3.958  -1.061   7.068  1.00  0.00           C  
ATOM    132  OE1 GLU A  10       4.853  -0.580   6.359  1.00  0.00           O  
ATOM    133  OE2 GLU A  10       4.131  -1.548   8.250  1.00  0.00           O  
ATOM    134  H   GLU A  10       1.432  -3.784   3.616  1.00  0.00           H  
ATOM    135  HA  GLU A  10       0.783  -1.132   4.614  1.00  0.00           H  
ATOM    136  HB2 GLU A  10       1.755  -3.071   6.091  1.00  0.00           H  
ATOM    137  HB3 GLU A  10       3.283  -2.700   5.317  1.00  0.00           H  
ATOM    138  HG2 GLU A  10       2.278  -0.172   6.049  1.00  0.00           H  
ATOM    139  HG3 GLU A  10       1.831  -1.201   7.396  1.00  0.00           H  
ATOM    140  HE2 GLU A  10       4.085  -0.817   8.931  1.00  0.00           H  
ATOM    141  N   VAL A  11       2.479   0.151   3.311  1.00  0.00           N  
ATOM    142  CA  VAL A  11       3.330   0.912   2.413  1.00  0.00           C  
ATOM    143  C   VAL A  11       4.796   0.600   2.720  1.00  0.00           C  
ATOM    144  O   VAL A  11       5.228   0.699   3.867  1.00  0.00           O  
ATOM    145  CB  VAL A  11       3.001   2.403   2.518  1.00  0.00           C  
ATOM    146  CG1 VAL A  11       3.913   3.231   1.609  1.00  0.00           C  
ATOM    147  CG2 VAL A  11       1.528   2.664   2.200  1.00  0.00           C  
ATOM    148  H   VAL A  11       1.877   0.701   3.890  1.00  0.00           H  
ATOM    149  HA  VAL A  11       3.107   0.588   1.397  1.00  0.00           H  
ATOM    150  HB  VAL A  11       3.182   2.714   3.547  1.00  0.00           H  
ATOM    151 HG11 VAL A  11       4.907   2.784   1.588  1.00  0.00           H  
ATOM    152 HG12 VAL A  11       3.501   3.249   0.600  1.00  0.00           H  
ATOM    153 HG13 VAL A  11       3.981   4.249   1.993  1.00  0.00           H  
ATOM    154 HG21 VAL A  11       1.380   2.644   1.121  1.00  0.00           H  
ATOM    155 HG22 VAL A  11       0.914   1.891   2.664  1.00  0.00           H  
ATOM    156 HG23 VAL A  11       1.238   3.640   2.590  1.00  0.00           H  
ATOM    157  N   ILE A  12       5.521   0.230   1.674  1.00  0.00           N  
ATOM    158  CA  ILE A  12       6.929  -0.098   1.818  1.00  0.00           C  
ATOM    159  C   ILE A  12       7.774   1.088   1.346  1.00  0.00           C  
ATOM    160  O   ILE A  12       8.811   1.388   1.934  1.00  0.00           O  
ATOM    161  CB  ILE A  12       7.251  -1.408   1.097  1.00  0.00           C  
ATOM    162  CG1 ILE A  12       6.618  -1.438  -0.296  1.00  0.00           C  
ATOM    163  CG2 ILE A  12       6.835  -2.615   1.941  1.00  0.00           C  
ATOM    164  CD1 ILE A  12       7.517  -2.174  -1.291  1.00  0.00           C  
ATOM    165  H   ILE A  12       5.161   0.152   0.744  1.00  0.00           H  
ATOM    166  HA  ILE A  12       7.121  -0.257   2.879  1.00  0.00           H  
ATOM    167  HB  ILE A  12       8.330  -1.467   0.962  1.00  0.00           H  
ATOM    168 HG12 ILE A  12       5.645  -1.927  -0.247  1.00  0.00           H  
ATOM    169 HG13 ILE A  12       6.445  -0.419  -0.642  1.00  0.00           H  
ATOM    170 HG21 ILE A  12       7.281  -2.535   2.933  1.00  0.00           H  
ATOM    171 HG22 ILE A  12       5.749  -2.637   2.032  1.00  0.00           H  
ATOM    172 HG23 ILE A  12       7.178  -3.530   1.460  1.00  0.00           H  
ATOM    173 HD11 ILE A  12       8.425  -1.595  -1.459  1.00  0.00           H  
ATOM    174 HD12 ILE A  12       7.780  -3.153  -0.888  1.00  0.00           H  
ATOM    175 HD13 ILE A  12       6.986  -2.302  -2.234  1.00  0.00           H  
ATOM    176  N   GLU A  13       7.298   1.729   0.289  1.00  0.00           N  
ATOM    177  CA  GLU A  13       7.996   2.874  -0.270  1.00  0.00           C  
ATOM    178  C   GLU A  13       7.062   3.675  -1.179  1.00  0.00           C  
ATOM    179  O   GLU A  13       6.239   3.099  -1.889  1.00  0.00           O  
ATOM    180  CB  GLU A  13       9.254   2.436  -1.023  1.00  0.00           C  
ATOM    181  CG  GLU A  13       9.963   3.637  -1.652  1.00  0.00           C  
ATOM    182  CD  GLU A  13      11.483   3.486  -1.561  1.00  0.00           C  
ATOM    183  OE1 GLU A  13      12.089   2.797  -2.395  1.00  0.00           O  
ATOM    184  OE2 GLU A  13      12.034   4.115  -0.580  1.00  0.00           O  
ATOM    185  H   GLU A  13       6.453   1.478  -0.184  1.00  0.00           H  
ATOM    186  HA  GLU A  13       8.288   3.481   0.587  1.00  0.00           H  
ATOM    187  HB2 GLU A  13       9.932   1.925  -0.341  1.00  0.00           H  
ATOM    188  HB3 GLU A  13       8.985   1.719  -1.800  1.00  0.00           H  
ATOM    189  HG2 GLU A  13       9.665   3.733  -2.697  1.00  0.00           H  
ATOM    190  HG3 GLU A  13       9.654   4.552  -1.147  1.00  0.00           H  
ATOM    191  HE2 GLU A  13      11.527   3.946   0.264  1.00  0.00           H  
ATOM    192  N   ILE A  14       7.223   4.989  -1.130  1.00  0.00           N  
ATOM    193  CA  ILE A  14       6.404   5.873  -1.941  1.00  0.00           C  
ATOM    194  C   ILE A  14       7.126   6.166  -3.257  1.00  0.00           C  
ATOM    195  O   ILE A  14       8.337   6.383  -3.269  1.00  0.00           O  
ATOM    196  CB  ILE A  14       6.030   7.130  -1.151  1.00  0.00           C  
ATOM    197  CG1 ILE A  14       5.401   6.765   0.194  1.00  0.00           C  
ATOM    198  CG2 ILE A  14       5.125   8.047  -1.977  1.00  0.00           C  
ATOM    199  CD1 ILE A  14       5.628   7.874   1.224  1.00  0.00           C  
ATOM    200  H   ILE A  14       7.895   5.448  -0.550  1.00  0.00           H  
ATOM    201  HA  ILE A  14       5.476   5.347  -2.165  1.00  0.00           H  
ATOM    202  HB  ILE A  14       6.944   7.685  -0.940  1.00  0.00           H  
ATOM    203 HG12 ILE A  14       4.332   6.597   0.066  1.00  0.00           H  
ATOM    204 HG13 ILE A  14       5.828   5.832   0.559  1.00  0.00           H  
ATOM    205 HG21 ILE A  14       4.694   7.483  -2.805  1.00  0.00           H  
ATOM    206 HG22 ILE A  14       4.326   8.433  -1.346  1.00  0.00           H  
ATOM    207 HG23 ILE A  14       5.711   8.877  -2.371  1.00  0.00           H  
ATOM    208 HD11 ILE A  14       4.887   7.789   2.020  1.00  0.00           H  
ATOM    209 HD12 ILE A  14       6.627   7.777   1.647  1.00  0.00           H  
ATOM    210 HD13 ILE A  14       5.531   8.845   0.739  1.00  0.00           H  
ATOM    211  N   ILE A  15       6.353   6.162  -4.333  1.00  0.00           N  
ATOM    212  CA  ILE A  15       6.905   6.426  -5.652  1.00  0.00           C  
ATOM    213  C   ILE A  15       6.986   7.937  -5.874  1.00  0.00           C  
ATOM    214  O   ILE A  15       8.074   8.485  -6.042  1.00  0.00           O  
ATOM    215  CB  ILE A  15       6.101   5.689  -6.725  1.00  0.00           C  
ATOM    216  CG1 ILE A  15       6.148   4.175  -6.503  1.00  0.00           C  
ATOM    217  CG2 ILE A  15       6.573   6.077  -8.127  1.00  0.00           C  
ATOM    218  CD1 ILE A  15       4.775   3.543  -6.741  1.00  0.00           C  
ATOM    219  H   ILE A  15       5.369   5.985  -4.314  1.00  0.00           H  
ATOM    220  HA  ILE A  15       7.915   6.018  -5.669  1.00  0.00           H  
ATOM    221  HB  ILE A  15       5.058   5.994  -6.641  1.00  0.00           H  
ATOM    222 HG12 ILE A  15       6.880   3.728  -7.177  1.00  0.00           H  
ATOM    223 HG13 ILE A  15       6.479   3.963  -5.486  1.00  0.00           H  
ATOM    224 HG21 ILE A  15       6.564   5.198  -8.770  1.00  0.00           H  
ATOM    225 HG22 ILE A  15       5.906   6.835  -8.538  1.00  0.00           H  
ATOM    226 HG23 ILE A  15       7.586   6.476  -8.072  1.00  0.00           H  
ATOM    227 HD11 ILE A  15       4.089   4.298  -7.123  1.00  0.00           H  
ATOM    228 HD12 ILE A  15       4.868   2.735  -7.466  1.00  0.00           H  
ATOM    229 HD13 ILE A  15       4.391   3.145  -5.801  1.00  0.00           H  
ATOM    230  N   GLY A  16       5.821   8.567  -5.868  1.00  0.00           N  
ATOM    231  CA  GLY A  16       5.747  10.005  -6.066  1.00  0.00           C  
ATOM    232  C   GLY A  16       4.322  10.437  -6.417  1.00  0.00           C  
ATOM    233  O   GLY A  16       3.357   9.919  -5.858  1.00  0.00           O  
ATOM    234  H   GLY A  16       4.941   8.114  -5.731  1.00  0.00           H  
ATOM    235  HA2 GLY A  16       6.074  10.518  -5.162  1.00  0.00           H  
ATOM    236  HA3 GLY A  16       6.427  10.301  -6.865  1.00  0.00           H  
ATOM    237  N   ARG A  17       4.235  11.383  -7.341  1.00  0.00           N  
ATOM    238  CA  ARG A  17       2.944  11.890  -7.774  1.00  0.00           C  
ATOM    239  C   ARG A  17       2.519  11.219  -9.080  1.00  0.00           C  
ATOM    240  O   ARG A  17       3.302  10.493  -9.692  1.00  0.00           O  
ATOM    241  CB  ARG A  17       2.989  13.406  -7.978  1.00  0.00           C  
ATOM    242  CG  ARG A  17       1.691  14.062  -7.505  1.00  0.00           C  
ATOM    243  CD  ARG A  17       1.979  15.222  -6.550  1.00  0.00           C  
ATOM    244  NE  ARG A  17       0.847  16.175  -6.556  1.00  0.00           N  
ATOM    245  CZ  ARG A  17       0.545  16.998  -5.528  1.00  0.00           C  
ATOM    246  NH1 ARG A  17       1.289  16.990  -4.403  1.00  0.00           N  
ATOM    247  NH2 ARG A  17      -0.491  17.810  -5.642  1.00  0.00           N  
ATOM    248  H   ARG A  17       5.025  11.799  -7.791  1.00  0.00           H  
ATOM    249  HA  ARG A  17       2.260  11.638  -6.963  1.00  0.00           H  
ATOM    250  HB2 ARG A  17       3.833  13.826  -7.431  1.00  0.00           H  
ATOM    251  HB3 ARG A  17       3.150  13.630  -9.033  1.00  0.00           H  
ATOM    252  HG2 ARG A  17       1.127  14.425  -8.365  1.00  0.00           H  
ATOM    253  HG3 ARG A  17       1.066  13.321  -7.004  1.00  0.00           H  
ATOM    254  HD2 ARG A  17       2.140  14.843  -5.542  1.00  0.00           H  
ATOM    255  HD3 ARG A  17       2.895  15.731  -6.850  1.00  0.00           H  
ATOM    256  HE  ARG A  17       0.269  16.213  -7.371  1.00  0.00           H  
ATOM    257 HH11 ARG A  17       2.072  16.372  -4.325  1.00  0.00           H  
ATOM    258 HH12 ARG A  17       1.058  17.602  -3.646  1.00  0.00           H  
ATOM    259 HH21 ARG A  17      -0.781  18.448  -4.929  1.00  0.00           H  
ATOM    260  N   THR A  18       1.282  11.484  -9.471  1.00  0.00           N  
ATOM    261  CA  THR A  18       0.744  10.914 -10.694  1.00  0.00           C  
ATOM    262  C   THR A  18      -0.002  11.981 -11.497  1.00  0.00           C  
ATOM    263  O   THR A  18       0.191  12.101 -12.706  1.00  0.00           O  
ATOM    264  CB  THR A  18      -0.132   9.718 -10.314  1.00  0.00           C  
ATOM    265  OG1 THR A  18       0.801   8.716  -9.918  1.00  0.00           O  
ATOM    266  CG2 THR A  18      -0.845   9.107 -11.521  1.00  0.00           C  
ATOM    267  H   THR A  18       0.651  12.075  -8.968  1.00  0.00           H  
ATOM    268  HA  THR A  18       1.576  10.574 -11.310  1.00  0.00           H  
ATOM    269  HB  THR A  18      -0.846   9.990  -9.536  1.00  0.00           H  
ATOM    270  HG1 THR A  18       1.525   8.635 -10.603  1.00  0.00           H  
ATOM    271 HG21 THR A  18      -1.906   8.990 -11.297  1.00  0.00           H  
ATOM    272 HG22 THR A  18      -0.727   9.763 -12.383  1.00  0.00           H  
ATOM    273 HG23 THR A  18      -0.411   8.132 -11.745  1.00  0.00           H  
ATOM    274  N   GLY A  19      -0.837  12.731 -10.793  1.00  0.00           N  
ATOM    275  CA  GLY A  19      -1.612  13.784 -11.426  1.00  0.00           C  
ATOM    276  C   GLY A  19      -2.427  13.237 -12.599  1.00  0.00           C  
ATOM    277  O   GLY A  19      -2.892  12.098 -12.560  1.00  0.00           O  
ATOM    278  H   GLY A  19      -0.988  12.627  -9.810  1.00  0.00           H  
ATOM    279  HA2 GLY A  19      -2.282  14.238 -10.694  1.00  0.00           H  
ATOM    280  HA3 GLY A  19      -0.945  14.571 -11.777  1.00  0.00           H  
ATOM    281  N   THR A  20      -2.573  14.073 -13.617  1.00  0.00           N  
ATOM    282  CA  THR A  20      -3.324  13.687 -14.800  1.00  0.00           C  
ATOM    283  C   THR A  20      -4.790  13.437 -14.444  1.00  0.00           C  
ATOM    284  O   THR A  20      -5.652  14.266 -14.730  1.00  0.00           O  
ATOM    285  CB  THR A  20      -2.634  12.471 -15.421  1.00  0.00           C  
ATOM    286  OG1 THR A  20      -1.451  13.006 -16.010  1.00  0.00           O  
ATOM    287  CG2 THR A  20      -3.413  11.898 -16.606  1.00  0.00           C  
ATOM    288  H   THR A  20      -2.192  14.997 -13.641  1.00  0.00           H  
ATOM    289  HA  THR A  20      -3.303  14.517 -15.506  1.00  0.00           H  
ATOM    290  HB  THR A  20      -2.446  11.704 -14.671  1.00  0.00           H  
ATOM    291  HG1 THR A  20      -1.683  13.774 -16.606  1.00  0.00           H  
ATOM    292 HG21 THR A  20      -4.457  12.203 -16.537  1.00  0.00           H  
ATOM    293 HG22 THR A  20      -2.985  12.270 -17.537  1.00  0.00           H  
ATOM    294 HG23 THR A  20      -3.352  10.809 -16.589  1.00  0.00           H  
ATOM    295  N   THR A  21      -5.029  12.290 -13.824  1.00  0.00           N  
ATOM    296  CA  THR A  21      -6.376  11.921 -13.426  1.00  0.00           C  
ATOM    297  C   THR A  21      -6.945  12.952 -12.449  1.00  0.00           C  
ATOM    298  O   THR A  21      -8.126  13.286 -12.512  1.00  0.00           O  
ATOM    299  CB  THR A  21      -6.328  10.503 -12.853  1.00  0.00           C  
ATOM    300  OG1 THR A  21      -6.413   9.662 -14.001  1.00  0.00           O  
ATOM    301  CG2 THR A  21      -7.578  10.156 -12.043  1.00  0.00           C  
ATOM    302  H   THR A  21      -4.322  11.622 -13.594  1.00  0.00           H  
ATOM    303  HA  THR A  21      -7.011  11.935 -14.311  1.00  0.00           H  
ATOM    304  HB  THR A  21      -5.425  10.354 -12.260  1.00  0.00           H  
ATOM    305  HG1 THR A  21      -6.024   8.764 -13.796  1.00  0.00           H  
ATOM    306 HG21 THR A  21      -8.435  10.079 -12.713  1.00  0.00           H  
ATOM    307 HG22 THR A  21      -7.429   9.204 -11.535  1.00  0.00           H  
ATOM    308 HG23 THR A  21      -7.762  10.937 -11.306  1.00  0.00           H  
ATOM    309  N   GLY A  22      -6.076  13.427 -11.568  1.00  0.00           N  
ATOM    310  CA  GLY A  22      -6.477  14.413 -10.578  1.00  0.00           C  
ATOM    311  C   GLY A  22      -5.558  14.370  -9.357  1.00  0.00           C  
ATOM    312  O   GLY A  22      -5.932  13.843  -8.311  1.00  0.00           O  
ATOM    313  H   GLY A  22      -5.117  13.150 -11.523  1.00  0.00           H  
ATOM    314  HA2 GLY A  22      -6.454  15.409 -11.022  1.00  0.00           H  
ATOM    315  HA3 GLY A  22      -7.506  14.226 -10.270  1.00  0.00           H  
ATOM    316  N   ASP A  23      -4.370  14.932  -9.531  1.00  0.00           N  
ATOM    317  CA  ASP A  23      -3.392  14.964  -8.456  1.00  0.00           C  
ATOM    318  C   ASP A  23      -3.349  13.597  -7.771  1.00  0.00           C  
ATOM    319  O   ASP A  23      -3.466  13.506  -6.549  1.00  0.00           O  
ATOM    320  CB  ASP A  23      -3.766  16.009  -7.403  1.00  0.00           C  
ATOM    321  CG  ASP A  23      -3.950  17.429  -7.939  1.00  0.00           C  
ATOM    322  OD1 ASP A  23      -5.032  17.794  -8.423  1.00  0.00           O  
ATOM    323  OD2 ASP A  23      -2.911  18.187  -7.843  1.00  0.00           O  
ATOM    324  H   ASP A  23      -4.072  15.357 -10.386  1.00  0.00           H  
ATOM    325  HA  ASP A  23      -2.448  15.220  -8.935  1.00  0.00           H  
ATOM    326  HB2 ASP A  23      -4.692  15.697  -6.917  1.00  0.00           H  
ATOM    327  HB3 ASP A  23      -2.992  16.023  -6.636  1.00  0.00           H  
ATOM    328  HD2 ASP A  23      -2.911  18.865  -8.579  1.00  0.00           H  
ATOM    329  N   VAL A  24      -3.180  12.566  -8.587  1.00  0.00           N  
ATOM    330  CA  VAL A  24      -3.120  11.209  -8.075  1.00  0.00           C  
ATOM    331  C   VAL A  24      -1.751  10.970  -7.433  1.00  0.00           C  
ATOM    332  O   VAL A  24      -0.786  11.666  -7.745  1.00  0.00           O  
ATOM    333  CB  VAL A  24      -3.438  10.212  -9.192  1.00  0.00           C  
ATOM    334  CG1 VAL A  24      -3.231   8.773  -8.719  1.00  0.00           C  
ATOM    335  CG2 VAL A  24      -4.860  10.417  -9.720  1.00  0.00           C  
ATOM    336  H   VAL A  24      -3.086  12.648  -9.579  1.00  0.00           H  
ATOM    337  HA  VAL A  24      -3.888  11.111  -7.307  1.00  0.00           H  
ATOM    338  HB  VAL A  24      -2.746  10.398 -10.013  1.00  0.00           H  
ATOM    339 HG11 VAL A  24      -3.627   8.085  -9.465  1.00  0.00           H  
ATOM    340 HG12 VAL A  24      -2.166   8.586  -8.580  1.00  0.00           H  
ATOM    341 HG13 VAL A  24      -3.752   8.622  -7.773  1.00  0.00           H  
ATOM    342 HG21 VAL A  24      -5.560  10.427  -8.885  1.00  0.00           H  
ATOM    343 HG22 VAL A  24      -4.916  11.366 -10.253  1.00  0.00           H  
ATOM    344 HG23 VAL A  24      -5.115   9.604 -10.398  1.00  0.00           H  
ATOM    345  N   THR A  25      -1.711   9.984  -6.550  1.00  0.00           N  
ATOM    346  CA  THR A  25      -0.476   9.644  -5.862  1.00  0.00           C  
ATOM    347  C   THR A  25      -0.287   8.127  -5.824  1.00  0.00           C  
ATOM    348  O   THR A  25      -1.053   7.418  -5.174  1.00  0.00           O  
ATOM    349  CB  THR A  25      -0.516  10.287  -4.474  1.00  0.00           C  
ATOM    350  OG1 THR A  25      -0.311  11.674  -4.727  1.00  0.00           O  
ATOM    351  CG2 THR A  25       0.680   9.886  -3.609  1.00  0.00           C  
ATOM    352  H   THR A  25      -2.500   9.422  -6.302  1.00  0.00           H  
ATOM    353  HA  THR A  25       0.358  10.057  -6.430  1.00  0.00           H  
ATOM    354  HB  THR A  25      -1.456  10.064  -3.969  1.00  0.00           H  
ATOM    355  HG1 THR A  25       0.632  11.833  -5.021  1.00  0.00           H  
ATOM    356 HG21 THR A  25       1.108  10.775  -3.146  1.00  0.00           H  
ATOM    357 HG22 THR A  25       0.350   9.196  -2.831  1.00  0.00           H  
ATOM    358 HG23 THR A  25       1.432   9.401  -4.230  1.00  0.00           H  
ATOM    359  N   GLN A  26       0.740   7.673  -6.529  1.00  0.00           N  
ATOM    360  CA  GLN A  26       1.041   6.253  -6.584  1.00  0.00           C  
ATOM    361  C   GLN A  26       2.032   5.877  -5.480  1.00  0.00           C  
ATOM    362  O   GLN A  26       3.039   6.556  -5.288  1.00  0.00           O  
ATOM    363  CB  GLN A  26       1.578   5.858  -7.961  1.00  0.00           C  
ATOM    364  CG  GLN A  26       0.558   5.014  -8.726  1.00  0.00           C  
ATOM    365  CD  GLN A  26       0.790   3.521  -8.482  1.00  0.00           C  
ATOM    366  OE1 GLN A  26       0.942   3.065  -7.361  1.00  0.00           O  
ATOM    367  NE2 GLN A  26       0.809   2.788  -9.592  1.00  0.00           N  
ATOM    368  H   GLN A  26       1.359   8.256  -7.054  1.00  0.00           H  
ATOM    369  HA  GLN A  26       0.089   5.749  -6.414  1.00  0.00           H  
ATOM    370  HB2 GLN A  26       1.814   6.756  -8.533  1.00  0.00           H  
ATOM    371  HB3 GLN A  26       2.506   5.300  -7.847  1.00  0.00           H  
ATOM    372  HG2 GLN A  26      -0.451   5.283  -8.414  1.00  0.00           H  
ATOM    373  HG3 GLN A  26       0.630   5.227  -9.792  1.00  0.00           H  
ATOM    374 HE21 GLN A  26       0.678   3.225 -10.482  1.00  0.00           H  
ATOM    375 HE22 GLN A  26       0.955   1.800  -9.537  1.00  0.00           H  
ATOM    376  N   VAL A  27       1.711   4.796  -4.784  1.00  0.00           N  
ATOM    377  CA  VAL A  27       2.561   4.322  -3.705  1.00  0.00           C  
ATOM    378  C   VAL A  27       2.668   2.798  -3.778  1.00  0.00           C  
ATOM    379  O   VAL A  27       1.759   2.131  -4.272  1.00  0.00           O  
ATOM    380  CB  VAL A  27       2.027   4.820  -2.361  1.00  0.00           C  
ATOM    381  CG1 VAL A  27       2.224   6.331  -2.217  1.00  0.00           C  
ATOM    382  CG2 VAL A  27       0.556   4.439  -2.180  1.00  0.00           C  
ATOM    383  H   VAL A  27       0.890   4.249  -4.946  1.00  0.00           H  
ATOM    384  HA  VAL A  27       3.552   4.751  -3.854  1.00  0.00           H  
ATOM    385  HB  VAL A  27       2.598   4.332  -1.572  1.00  0.00           H  
ATOM    386 HG11 VAL A  27       3.096   6.526  -1.595  1.00  0.00           H  
ATOM    387 HG12 VAL A  27       2.374   6.773  -3.204  1.00  0.00           H  
ATOM    388 HG13 VAL A  27       1.340   6.770  -1.755  1.00  0.00           H  
ATOM    389 HG21 VAL A  27      -0.069   5.320  -2.328  1.00  0.00           H  
ATOM    390 HG22 VAL A  27       0.287   3.675  -2.910  1.00  0.00           H  
ATOM    391 HG23 VAL A  27       0.403   4.050  -1.173  1.00  0.00           H  
ATOM    392  N   LYS A  28       3.785   2.289  -3.280  1.00  0.00           N  
ATOM    393  CA  LYS A  28       4.023   0.857  -3.282  1.00  0.00           C  
ATOM    394  C   LYS A  28       3.745   0.296  -1.887  1.00  0.00           C  
ATOM    395  O   LYS A  28       4.226   0.834  -0.890  1.00  0.00           O  
ATOM    396  CB  LYS A  28       5.429   0.547  -3.802  1.00  0.00           C  
ATOM    397  CG  LYS A  28       5.419   0.333  -5.316  1.00  0.00           C  
ATOM    398  CD  LYS A  28       6.811  -0.047  -5.825  1.00  0.00           C  
ATOM    399  CE  LYS A  28       6.781  -0.355  -7.323  1.00  0.00           C  
ATOM    400  NZ  LYS A  28       7.064   0.867  -8.109  1.00  0.00           N  
ATOM    401  H   LYS A  28       4.520   2.839  -2.880  1.00  0.00           H  
ATOM    402  HA  LYS A  28       3.316   0.410  -3.981  1.00  0.00           H  
ATOM    403  HB2 LYS A  28       6.102   1.366  -3.550  1.00  0.00           H  
ATOM    404  HB3 LYS A  28       5.815  -0.344  -3.307  1.00  0.00           H  
ATOM    405  HG2 LYS A  28       4.707  -0.451  -5.573  1.00  0.00           H  
ATOM    406  HG3 LYS A  28       5.083   1.243  -5.814  1.00  0.00           H  
ATOM    407  HD2 LYS A  28       7.509   0.766  -5.631  1.00  0.00           H  
ATOM    408  HD3 LYS A  28       7.176  -0.917  -5.278  1.00  0.00           H  
ATOM    409  HE2 LYS A  28       7.518  -1.124  -7.557  1.00  0.00           H  
ATOM    410  HE3 LYS A  28       5.806  -0.754  -7.600  1.00  0.00           H  
ATOM    411  HZ1 LYS A  28       6.516   0.907  -8.960  1.00  0.00           H  
ATOM    412  HZ2 LYS A  28       6.856   1.712  -7.586  1.00  0.00           H  
ATOM    413  N   VAL A  29       2.971  -0.780  -1.858  1.00  0.00           N  
ATOM    414  CA  VAL A  29       2.624  -1.420  -0.601  1.00  0.00           C  
ATOM    415  C   VAL A  29       2.862  -2.926  -0.717  1.00  0.00           C  
ATOM    416  O   VAL A  29       2.797  -3.486  -1.811  1.00  0.00           O  
ATOM    417  CB  VAL A  29       1.185  -1.069  -0.216  1.00  0.00           C  
ATOM    418  CG1 VAL A  29       1.005   0.445  -0.087  1.00  0.00           C  
ATOM    419  CG2 VAL A  29       0.190  -1.657  -1.219  1.00  0.00           C  
ATOM    420  H   VAL A  29       2.584  -1.211  -2.673  1.00  0.00           H  
ATOM    421  HA  VAL A  29       3.286  -1.018   0.167  1.00  0.00           H  
ATOM    422  HB  VAL A  29       0.981  -1.516   0.759  1.00  0.00           H  
ATOM    423 HG11 VAL A  29       1.923   0.946  -0.388  1.00  0.00           H  
ATOM    424 HG12 VAL A  29       0.186   0.769  -0.730  1.00  0.00           H  
ATOM    425 HG13 VAL A  29       0.775   0.696   0.948  1.00  0.00           H  
ATOM    426 HG21 VAL A  29      -0.199  -2.600  -0.834  1.00  0.00           H  
ATOM    427 HG22 VAL A  29      -0.633  -0.957  -1.367  1.00  0.00           H  
ATOM    428 HG23 VAL A  29       0.694  -1.833  -2.170  1.00  0.00           H  
ATOM    429  N   ARG A  30       3.133  -3.540   0.425  1.00  0.00           N  
ATOM    430  CA  ARG A  30       3.381  -4.971   0.465  1.00  0.00           C  
ATOM    431  C   ARG A  30       2.301  -5.675   1.290  1.00  0.00           C  
ATOM    432  O   ARG A  30       1.770  -5.102   2.239  1.00  0.00           O  
ATOM    433  CB  ARG A  30       4.754  -5.276   1.068  1.00  0.00           C  
ATOM    434  CG  ARG A  30       4.964  -6.784   1.220  1.00  0.00           C  
ATOM    435  CD  ARG A  30       6.423  -7.104   1.552  1.00  0.00           C  
ATOM    436  NE  ARG A  30       6.609  -7.148   3.020  1.00  0.00           N  
ATOM    437  CZ  ARG A  30       7.800  -7.342   3.626  1.00  0.00           C  
ATOM    438  NH1 ARG A  30       8.922  -7.513   2.895  1.00  0.00           N  
ATOM    439  NH2 ARG A  30       7.850  -7.365   4.945  1.00  0.00           N  
ATOM    440  H   ARG A  30       3.184  -3.078   1.310  1.00  0.00           H  
ATOM    441  HA  ARG A  30       3.348  -5.290  -0.577  1.00  0.00           H  
ATOM    442  HB2 ARG A  30       5.535  -4.859   0.433  1.00  0.00           H  
ATOM    443  HB3 ARG A  30       4.843  -4.793   2.041  1.00  0.00           H  
ATOM    444  HG2 ARG A  30       4.315  -7.167   2.008  1.00  0.00           H  
ATOM    445  HG3 ARG A  30       4.679  -7.289   0.298  1.00  0.00           H  
ATOM    446  HD2 ARG A  30       6.703  -8.060   1.113  1.00  0.00           H  
ATOM    447  HD3 ARG A  30       7.078  -6.348   1.117  1.00  0.00           H  
ATOM    448  HE  ARG A  30       5.803  -7.026   3.599  1.00  0.00           H  
ATOM    449 HH11 ARG A  30       8.874  -7.495   1.896  1.00  0.00           H  
ATOM    450 HH12 ARG A  30       9.799  -7.657   3.352  1.00  0.00           H  
ATOM    451 HH21 ARG A  30       8.690  -7.503   5.470  1.00  0.00           H  
ATOM    452  N   ILE A  31       2.009  -6.906   0.896  1.00  0.00           N  
ATOM    453  CA  ILE A  31       1.004  -7.693   1.588  1.00  0.00           C  
ATOM    454  C   ILE A  31       1.538  -8.104   2.961  1.00  0.00           C  
ATOM    455  O   ILE A  31       2.649  -8.622   3.069  1.00  0.00           O  
ATOM    456  CB  ILE A  31       0.559  -8.875   0.722  1.00  0.00           C  
ATOM    457  CG1 ILE A  31       0.016  -8.393  -0.626  1.00  0.00           C  
ATOM    458  CG2 ILE A  31      -0.451  -9.751   1.466  1.00  0.00           C  
ATOM    459  CD1 ILE A  31      -0.587  -9.553  -1.419  1.00  0.00           C  
ATOM    460  H   ILE A  31       2.447  -7.364   0.123  1.00  0.00           H  
ATOM    461  HA  ILE A  31       0.131  -7.054   1.733  1.00  0.00           H  
ATOM    462  HB  ILE A  31       1.432  -9.494   0.515  1.00  0.00           H  
ATOM    463 HG12 ILE A  31      -0.739  -7.625  -0.464  1.00  0.00           H  
ATOM    464 HG13 ILE A  31       0.820  -7.933  -1.201  1.00  0.00           H  
ATOM    465 HG21 ILE A  31      -1.292  -9.139   1.792  1.00  0.00           H  
ATOM    466 HG22 ILE A  31      -0.808 -10.536   0.801  1.00  0.00           H  
ATOM    467 HG23 ILE A  31       0.029 -10.199   2.335  1.00  0.00           H  
ATOM    468 HD11 ILE A  31       0.113 -10.387  -1.434  1.00  0.00           H  
ATOM    469 HD12 ILE A  31      -1.519  -9.869  -0.949  1.00  0.00           H  
ATOM    470 HD13 ILE A  31      -0.788  -9.228  -2.441  1.00  0.00           H  
ATOM    471  N   LEU A  32       0.723  -7.858   3.975  1.00  0.00           N  
ATOM    472  CA  LEU A  32       1.099  -8.196   5.337  1.00  0.00           C  
ATOM    473  C   LEU A  32       0.738  -9.657   5.615  1.00  0.00           C  
ATOM    474  O   LEU A  32       1.401 -10.324   6.407  1.00  0.00           O  
ATOM    475  CB  LEU A  32       0.475  -7.210   6.327  1.00  0.00           C  
ATOM    476  CG  LEU A  32       1.171  -5.853   6.450  1.00  0.00           C  
ATOM    477  CD1 LEU A  32       0.355  -4.896   7.321  1.00  0.00           C  
ATOM    478  CD2 LEU A  32       2.602  -6.015   6.965  1.00  0.00           C  
ATOM    479  H   LEU A  32      -0.179  -7.437   3.879  1.00  0.00           H  
ATOM    480  HA  LEU A  32       2.182  -8.088   5.413  1.00  0.00           H  
ATOM    481  HB2 LEU A  32      -0.561  -7.040   6.035  1.00  0.00           H  
ATOM    482  HB3 LEU A  32       0.457  -7.677   7.312  1.00  0.00           H  
ATOM    483  HG  LEU A  32       1.234  -5.409   5.457  1.00  0.00           H  
ATOM    484 HD11 LEU A  32      -0.190  -4.200   6.684  1.00  0.00           H  
ATOM    485 HD12 LEU A  32      -0.352  -5.466   7.924  1.00  0.00           H  
ATOM    486 HD13 LEU A  32       1.025  -4.340   7.977  1.00  0.00           H  
ATOM    487 HD21 LEU A  32       2.848  -7.076   7.028  1.00  0.00           H  
ATOM    488 HD22 LEU A  32       3.293  -5.524   6.279  1.00  0.00           H  
ATOM    489 HD23 LEU A  32       2.688  -5.563   7.953  1.00  0.00           H  
ATOM    490  N   GLU A  33      -0.311 -10.111   4.946  1.00  0.00           N  
ATOM    491  CA  GLU A  33      -0.769 -11.480   5.110  1.00  0.00           C  
ATOM    492  C   GLU A  33      -1.805 -11.826   4.039  1.00  0.00           C  
ATOM    493  O   GLU A  33      -2.306 -10.941   3.346  1.00  0.00           O  
ATOM    494  CB  GLU A  33      -1.337 -11.703   6.513  1.00  0.00           C  
ATOM    495  CG  GLU A  33      -0.909 -13.065   7.067  1.00  0.00           C  
ATOM    496  CD  GLU A  33      -1.156 -13.146   8.575  1.00  0.00           C  
ATOM    497  OE1 GLU A  33      -2.161 -12.613   9.068  1.00  0.00           O  
ATOM    498  OE2 GLU A  33      -0.260 -13.791   9.240  1.00  0.00           O  
ATOM    499  H   GLU A  33      -0.845  -9.561   4.303  1.00  0.00           H  
ATOM    500  HA  GLU A  33       0.119 -12.099   4.981  1.00  0.00           H  
ATOM    501  HB2 GLU A  33      -0.992 -10.912   7.179  1.00  0.00           H  
ATOM    502  HB3 GLU A  33      -2.424 -11.644   6.483  1.00  0.00           H  
ATOM    503  HG2 GLU A  33      -1.463 -13.856   6.561  1.00  0.00           H  
ATOM    504  HG3 GLU A  33       0.147 -13.231   6.858  1.00  0.00           H  
ATOM    505  HE2 GLU A  33       0.072 -14.567   8.703  1.00  0.00           H  
ATOM    506  N   GLY A  34      -2.095 -13.115   3.935  1.00  0.00           N  
ATOM    507  CA  GLY A  34      -3.062 -13.588   2.959  1.00  0.00           C  
ATOM    508  C   GLY A  34      -2.401 -14.517   1.939  1.00  0.00           C  
ATOM    509  O   GLY A  34      -2.299 -14.180   0.761  1.00  0.00           O  
ATOM    510  H   GLY A  34      -1.683 -13.827   4.502  1.00  0.00           H  
ATOM    511  HA2 GLY A  34      -3.868 -14.116   3.469  1.00  0.00           H  
ATOM    512  HA3 GLY A  34      -3.510 -12.738   2.445  1.00  0.00           H  
ATOM    513  N   ARG A  35      -1.968 -15.670   2.430  1.00  0.00           N  
ATOM    514  CA  ARG A  35      -1.320 -16.651   1.575  1.00  0.00           C  
ATOM    515  C   ARG A  35      -0.003 -16.093   1.032  1.00  0.00           C  
ATOM    516  O   ARG A  35       1.073 -16.475   1.490  1.00  0.00           O  
ATOM    517  CB  ARG A  35      -2.222 -17.043   0.403  1.00  0.00           C  
ATOM    518  CG  ARG A  35      -2.371 -18.562   0.310  1.00  0.00           C  
ATOM    519  CD  ARG A  35      -1.956 -19.071  -1.072  1.00  0.00           C  
ATOM    520  NE  ARG A  35      -1.092 -20.265  -0.932  1.00  0.00           N  
ATOM    521  CZ  ARG A  35      -1.534 -21.477  -0.535  1.00  0.00           C  
ATOM    522  NH1 ARG A  35      -2.836 -21.665  -0.232  1.00  0.00           N  
ATOM    523  NH2 ARG A  35      -0.674 -22.474  -0.446  1.00  0.00           N  
ATOM    524  H   ARG A  35      -2.055 -15.937   3.390  1.00  0.00           H  
ATOM    525  HA  ARG A  35      -1.145 -17.510   2.221  1.00  0.00           H  
ATOM    526  HB2 ARG A  35      -3.203 -16.584   0.526  1.00  0.00           H  
ATOM    527  HB3 ARG A  35      -1.804 -16.657  -0.526  1.00  0.00           H  
ATOM    528  HG2 ARG A  35      -1.760 -19.039   1.077  1.00  0.00           H  
ATOM    529  HG3 ARG A  35      -3.407 -18.842   0.510  1.00  0.00           H  
ATOM    530  HD2 ARG A  35      -2.841 -19.318  -1.658  1.00  0.00           H  
ATOM    531  HD3 ARG A  35      -1.425 -18.288  -1.611  1.00  0.00           H  
ATOM    532  HE  ARG A  35      -0.120 -20.167  -1.147  1.00  0.00           H  
ATOM    533 HH11 ARG A  35      -3.481 -20.905  -0.302  1.00  0.00           H  
ATOM    534 HH12 ARG A  35      -3.155 -22.567   0.061  1.00  0.00           H  
ATOM    535 HH21 ARG A  35      -0.919 -23.400  -0.159  1.00  0.00           H  
ATOM    536  N   ASP A  36      -0.131 -15.199   0.063  1.00  0.00           N  
ATOM    537  CA  ASP A  36       1.035 -14.585  -0.548  1.00  0.00           C  
ATOM    538  C   ASP A  36       1.955 -14.043   0.549  1.00  0.00           C  
ATOM    539  O   ASP A  36       3.118 -14.434   0.639  1.00  0.00           O  
ATOM    540  CB  ASP A  36       0.635 -13.415  -1.448  1.00  0.00           C  
ATOM    541  CG  ASP A  36      -0.392 -13.755  -2.531  1.00  0.00           C  
ATOM    542  OD1 ASP A  36      -1.547 -13.310  -2.479  1.00  0.00           O  
ATOM    543  OD2 ASP A  36       0.044 -14.522  -3.473  1.00  0.00           O  
ATOM    544  H   ASP A  36      -1.010 -14.894  -0.304  1.00  0.00           H  
ATOM    545  HA  ASP A  36       1.505 -15.378  -1.130  1.00  0.00           H  
ATOM    546  HB2 ASP A  36       0.231 -12.617  -0.825  1.00  0.00           H  
ATOM    547  HB3 ASP A  36       1.531 -13.022  -1.929  1.00  0.00           H  
ATOM    548  HD2 ASP A  36      -0.495 -15.364  -3.504  1.00  0.00           H  
ATOM    549  N   LYS A  37       1.398 -13.151   1.356  1.00  0.00           N  
ATOM    550  CA  LYS A  37       2.153 -12.552   2.444  1.00  0.00           C  
ATOM    551  C   LYS A  37       3.583 -12.277   1.975  1.00  0.00           C  
ATOM    552  O   LYS A  37       4.463 -13.123   2.127  1.00  0.00           O  
ATOM    553  CB  LYS A  37       2.073 -13.426   3.696  1.00  0.00           C  
ATOM    554  CG  LYS A  37       2.811 -12.774   4.867  1.00  0.00           C  
ATOM    555  CD  LYS A  37       3.448 -13.831   5.771  1.00  0.00           C  
ATOM    556  CE  LYS A  37       4.577 -13.228   6.609  1.00  0.00           C  
ATOM    557  NZ  LYS A  37       5.174 -14.256   7.492  1.00  0.00           N  
ATOM    558  H   LYS A  37       0.451 -12.839   1.276  1.00  0.00           H  
ATOM    559  HA  LYS A  37       1.679 -11.600   2.684  1.00  0.00           H  
ATOM    560  HB2 LYS A  37       1.030 -13.590   3.965  1.00  0.00           H  
ATOM    561  HB3 LYS A  37       2.506 -14.405   3.489  1.00  0.00           H  
ATOM    562  HG2 LYS A  37       3.582 -12.102   4.488  1.00  0.00           H  
ATOM    563  HG3 LYS A  37       2.116 -12.166   5.446  1.00  0.00           H  
ATOM    564  HD2 LYS A  37       2.690 -14.257   6.429  1.00  0.00           H  
ATOM    565  HD3 LYS A  37       3.838 -14.648   5.163  1.00  0.00           H  
ATOM    566  HE2 LYS A  37       5.343 -12.813   5.954  1.00  0.00           H  
ATOM    567  HE3 LYS A  37       4.191 -12.404   7.210  1.00  0.00           H  
ATOM    568  HZ1 LYS A  37       4.738 -14.270   8.407  1.00  0.00           H  
ATOM    569  HZ2 LYS A  37       5.078 -15.189   7.107  1.00  0.00           H  
ATOM    570  N   GLY A  38       3.770 -11.091   1.414  1.00  0.00           N  
ATOM    571  CA  GLY A  38       5.080 -10.695   0.922  1.00  0.00           C  
ATOM    572  C   GLY A  38       5.016 -10.315  -0.558  1.00  0.00           C  
ATOM    573  O   GLY A  38       5.926 -10.631  -1.323  1.00  0.00           O  
ATOM    574  H   GLY A  38       3.050 -10.409   1.295  1.00  0.00           H  
ATOM    575  HA2 GLY A  38       5.449  -9.848   1.503  1.00  0.00           H  
ATOM    576  HA3 GLY A  38       5.788 -11.511   1.063  1.00  0.00           H  
ATOM    577  N   ARG A  39       3.933  -9.642  -0.918  1.00  0.00           N  
ATOM    578  CA  ARG A  39       3.740  -9.216  -2.294  1.00  0.00           C  
ATOM    579  C   ARG A  39       3.694  -7.688  -2.375  1.00  0.00           C  
ATOM    580  O   ARG A  39       2.779  -7.062  -1.842  1.00  0.00           O  
ATOM    581  CB  ARG A  39       2.445  -9.790  -2.872  1.00  0.00           C  
ATOM    582  CG  ARG A  39       2.493  -9.823  -4.401  1.00  0.00           C  
ATOM    583  CD  ARG A  39       2.925 -11.202  -4.904  1.00  0.00           C  
ATOM    584  NE  ARG A  39       2.689 -11.305  -6.362  1.00  0.00           N  
ATOM    585  CZ  ARG A  39       3.372 -12.130  -7.182  1.00  0.00           C  
ATOM    586  NH1 ARG A  39       4.341 -12.934  -6.696  1.00  0.00           N  
ATOM    587  NH2 ARG A  39       3.078 -12.140  -8.470  1.00  0.00           N  
ATOM    588  H   ARG A  39       3.198  -9.388  -0.291  1.00  0.00           H  
ATOM    589  HA  ARG A  39       4.601  -9.611  -2.832  1.00  0.00           H  
ATOM    590  HB2 ARG A  39       2.286 -10.797  -2.487  1.00  0.00           H  
ATOM    591  HB3 ARG A  39       1.597  -9.186  -2.544  1.00  0.00           H  
ATOM    592  HG2 ARG A  39       1.513  -9.575  -4.805  1.00  0.00           H  
ATOM    593  HG3 ARG A  39       3.189  -9.066  -4.763  1.00  0.00           H  
ATOM    594  HD2 ARG A  39       3.979 -11.365  -4.686  1.00  0.00           H  
ATOM    595  HD3 ARG A  39       2.367 -11.980  -4.382  1.00  0.00           H  
ATOM    596  HE  ARG A  39       1.980 -10.725  -6.764  1.00  0.00           H  
ATOM    597 HH11 ARG A  39       4.556 -12.921  -5.718  1.00  0.00           H  
ATOM    598 HH12 ARG A  39       4.841 -13.543  -7.310  1.00  0.00           H  
ATOM    599 HH21 ARG A  39       3.536 -12.720  -9.144  1.00  0.00           H  
ATOM    600  N   VAL A  40       4.691  -7.133  -3.048  1.00  0.00           N  
ATOM    601  CA  VAL A  40       4.777  -5.691  -3.206  1.00  0.00           C  
ATOM    602  C   VAL A  40       4.092  -5.284  -4.512  1.00  0.00           C  
ATOM    603  O   VAL A  40       4.368  -5.856  -5.566  1.00  0.00           O  
ATOM    604  CB  VAL A  40       6.237  -5.241  -3.130  1.00  0.00           C  
ATOM    605  CG1 VAL A  40       6.933  -5.841  -1.906  1.00  0.00           C  
ATOM    606  CG2 VAL A  40       6.986  -5.597  -4.417  1.00  0.00           C  
ATOM    607  H   VAL A  40       5.431  -7.650  -3.479  1.00  0.00           H  
ATOM    608  HA  VAL A  40       4.240  -5.237  -2.373  1.00  0.00           H  
ATOM    609  HB  VAL A  40       6.248  -4.157  -3.026  1.00  0.00           H  
ATOM    610 HG11 VAL A  40       6.306  -6.623  -1.479  1.00  0.00           H  
ATOM    611 HG12 VAL A  40       7.891  -6.264  -2.204  1.00  0.00           H  
ATOM    612 HG13 VAL A  40       7.095  -5.060  -1.163  1.00  0.00           H  
ATOM    613 HG21 VAL A  40       6.805  -4.828  -5.167  1.00  0.00           H  
ATOM    614 HG22 VAL A  40       8.055  -5.657  -4.208  1.00  0.00           H  
ATOM    615 HG23 VAL A  40       6.634  -6.559  -4.788  1.00  0.00           H  
ATOM    616  N   ILE A  41       3.213  -4.300  -4.401  1.00  0.00           N  
ATOM    617  CA  ILE A  41       2.486  -3.810  -5.560  1.00  0.00           C  
ATOM    618  C   ILE A  41       2.490  -2.280  -5.550  1.00  0.00           C  
ATOM    619  O   ILE A  41       2.986  -1.663  -4.608  1.00  0.00           O  
ATOM    620  CB  ILE A  41       1.085  -4.422  -5.613  1.00  0.00           C  
ATOM    621  CG1 ILE A  41       0.261  -4.011  -4.392  1.00  0.00           C  
ATOM    622  CG2 ILE A  41       1.157  -5.942  -5.771  1.00  0.00           C  
ATOM    623  CD1 ILE A  41      -1.237  -4.142  -4.672  1.00  0.00           C  
ATOM    624  H   ILE A  41       2.994  -3.839  -3.540  1.00  0.00           H  
ATOM    625  HA  ILE A  41       3.021  -4.150  -6.448  1.00  0.00           H  
ATOM    626  HB  ILE A  41       0.575  -4.031  -6.493  1.00  0.00           H  
ATOM    627 HG12 ILE A  41       0.531  -4.635  -3.539  1.00  0.00           H  
ATOM    628 HG13 ILE A  41       0.496  -2.982  -4.120  1.00  0.00           H  
ATOM    629 HG21 ILE A  41       1.342  -6.400  -4.800  1.00  0.00           H  
ATOM    630 HG22 ILE A  41       0.213  -6.311  -6.173  1.00  0.00           H  
ATOM    631 HG23 ILE A  41       1.967  -6.199  -6.455  1.00  0.00           H  
ATOM    632 HD11 ILE A  41      -1.549  -3.351  -5.355  1.00  0.00           H  
ATOM    633 HD12 ILE A  41      -1.439  -5.113  -5.123  1.00  0.00           H  
ATOM    634 HD13 ILE A  41      -1.791  -4.054  -3.737  1.00  0.00           H  
ATOM    635  N   ARG A  42       1.930  -1.711  -6.607  1.00  0.00           N  
ATOM    636  CA  ARG A  42       1.862  -0.266  -6.732  1.00  0.00           C  
ATOM    637  C   ARG A  42       0.408   0.186  -6.886  1.00  0.00           C  
ATOM    638  O   ARG A  42      -0.178   0.048  -7.959  1.00  0.00           O  
ATOM    639  CB  ARG A  42       2.670   0.223  -7.935  1.00  0.00           C  
ATOM    640  CG  ARG A  42       2.341  -0.594  -9.186  1.00  0.00           C  
ATOM    641  CD  ARG A  42       3.416  -1.651  -9.450  1.00  0.00           C  
ATOM    642  NE  ARG A  42       3.715  -1.718 -10.897  1.00  0.00           N  
ATOM    643  CZ  ARG A  42       4.756  -2.396 -11.425  1.00  0.00           C  
ATOM    644  NH1 ARG A  42       5.607  -3.073 -10.625  1.00  0.00           N  
ATOM    645  NH2 ARG A  42       4.929  -2.388 -12.733  1.00  0.00           N  
ATOM    646  H   ARG A  42       1.530  -2.220  -7.370  1.00  0.00           H  
ATOM    647  HA  ARG A  42       2.294   0.114  -5.806  1.00  0.00           H  
ATOM    648  HB2 ARG A  42       2.459   1.276  -8.118  1.00  0.00           H  
ATOM    649  HB3 ARG A  42       3.736   0.147  -7.716  1.00  0.00           H  
ATOM    650  HG2 ARG A  42       1.372  -1.078  -9.063  1.00  0.00           H  
ATOM    651  HG3 ARG A  42       2.259   0.070 -10.047  1.00  0.00           H  
ATOM    652  HD2 ARG A  42       4.321  -1.408  -8.893  1.00  0.00           H  
ATOM    653  HD3 ARG A  42       3.076  -2.623  -9.095  1.00  0.00           H  
ATOM    654  HE  ARG A  42       3.108  -1.229 -11.525  1.00  0.00           H  
ATOM    655 HH11 ARG A  42       5.470  -3.075  -9.635  1.00  0.00           H  
ATOM    656 HH12 ARG A  42       6.377  -3.574 -11.024  1.00  0.00           H  
ATOM    657 HH21 ARG A  42       5.673  -2.864 -13.202  1.00  0.00           H  
ATOM    658  N   ARG A  43      -0.132   0.716  -5.799  1.00  0.00           N  
ATOM    659  CA  ARG A  43      -1.506   1.189  -5.800  1.00  0.00           C  
ATOM    660  C   ARG A  43      -1.545   2.708  -5.983  1.00  0.00           C  
ATOM    661  O   ARG A  43      -0.714   3.425  -5.428  1.00  0.00           O  
ATOM    662  CB  ARG A  43      -2.216   0.821  -4.497  1.00  0.00           C  
ATOM    663  CG  ARG A  43      -2.986  -0.493  -4.643  1.00  0.00           C  
ATOM    664  CD  ARG A  43      -4.396  -0.245  -5.185  1.00  0.00           C  
ATOM    665  NE  ARG A  43      -4.345  -0.025  -6.647  1.00  0.00           N  
ATOM    666  CZ  ARG A  43      -5.310   0.601  -7.353  1.00  0.00           C  
ATOM    667  NH1 ARG A  43      -6.412   1.077  -6.734  1.00  0.00           N  
ATOM    668  NH2 ARG A  43      -5.161   0.743  -8.657  1.00  0.00           N  
ATOM    669  H   ARG A  43       0.351   0.826  -4.930  1.00  0.00           H  
ATOM    670  HA  ARG A  43      -1.975   0.680  -6.643  1.00  0.00           H  
ATOM    671  HB2 ARG A  43      -1.485   0.731  -3.693  1.00  0.00           H  
ATOM    672  HB3 ARG A  43      -2.903   1.619  -4.214  1.00  0.00           H  
ATOM    673  HG2 ARG A  43      -2.448  -1.161  -5.315  1.00  0.00           H  
ATOM    674  HG3 ARG A  43      -3.047  -0.993  -3.677  1.00  0.00           H  
ATOM    675  HD2 ARG A  43      -5.037  -1.097  -4.959  1.00  0.00           H  
ATOM    676  HD3 ARG A  43      -4.835   0.623  -4.693  1.00  0.00           H  
ATOM    677  HE  ARG A  43      -3.545  -0.362  -7.145  1.00  0.00           H  
ATOM    678 HH11 ARG A  43      -6.518   0.966  -5.746  1.00  0.00           H  
ATOM    679 HH12 ARG A  43      -7.123   1.540  -7.263  1.00  0.00           H  
ATOM    680 HH21 ARG A  43      -5.828   1.194  -9.251  1.00  0.00           H  
ATOM    681  N   ASN A  44      -2.518   3.153  -6.765  1.00  0.00           N  
ATOM    682  CA  ASN A  44      -2.676   4.573  -7.028  1.00  0.00           C  
ATOM    683  C   ASN A  44      -3.918   5.087  -6.298  1.00  0.00           C  
ATOM    684  O   ASN A  44      -5.005   4.530  -6.446  1.00  0.00           O  
ATOM    685  CB  ASN A  44      -2.862   4.838  -8.523  1.00  0.00           C  
ATOM    686  CG  ASN A  44      -4.238   4.365  -8.996  1.00  0.00           C  
ATOM    687  OD1 ASN A  44      -4.625   3.222  -8.820  1.00  0.00           O  
ATOM    688  ND2 ASN A  44      -4.954   5.307  -9.606  1.00  0.00           N  
ATOM    689  H   ASN A  44      -3.189   2.563  -7.212  1.00  0.00           H  
ATOM    690  HA  ASN A  44      -1.758   5.036  -6.665  1.00  0.00           H  
ATOM    691  HB2 ASN A  44      -2.752   5.905  -8.723  1.00  0.00           H  
ATOM    692  HB3 ASN A  44      -2.083   4.326  -9.087  1.00  0.00           H  
ATOM    693 HD21 ASN A  44      -4.577   6.226  -9.719  1.00  0.00           H  
ATOM    694 HD22 ASN A  44      -5.867   5.094  -9.953  1.00  0.00           H  
ATOM    695  N   VAL A  45      -3.716   6.145  -5.525  1.00  0.00           N  
ATOM    696  CA  VAL A  45      -4.808   6.741  -4.772  1.00  0.00           C  
ATOM    697  C   VAL A  45      -4.587   8.251  -4.674  1.00  0.00           C  
ATOM    698  O   VAL A  45      -3.496   8.744  -4.957  1.00  0.00           O  
ATOM    699  CB  VAL A  45      -4.931   6.064  -3.405  1.00  0.00           C  
ATOM    700  CG1 VAL A  45      -5.960   6.781  -2.529  1.00  0.00           C  
ATOM    701  CG2 VAL A  45      -5.276   4.582  -3.557  1.00  0.00           C  
ATOM    702  H   VAL A  45      -2.830   6.593  -5.411  1.00  0.00           H  
ATOM    703  HA  VAL A  45      -5.728   6.555  -5.324  1.00  0.00           H  
ATOM    704  HB  VAL A  45      -3.962   6.133  -2.909  1.00  0.00           H  
ATOM    705 HG11 VAL A  45      -5.595   7.779  -2.283  1.00  0.00           H  
ATOM    706 HG12 VAL A  45      -6.903   6.861  -3.069  1.00  0.00           H  
ATOM    707 HG13 VAL A  45      -6.114   6.213  -1.611  1.00  0.00           H  
ATOM    708 HG21 VAL A  45      -5.299   4.112  -2.573  1.00  0.00           H  
ATOM    709 HG22 VAL A  45      -6.254   4.484  -4.030  1.00  0.00           H  
ATOM    710 HG23 VAL A  45      -4.523   4.094  -4.175  1.00  0.00           H  
ATOM    711  N   ARG A  46      -5.641   8.946  -4.270  1.00  0.00           N  
ATOM    712  CA  ARG A  46      -5.577  10.391  -4.131  1.00  0.00           C  
ATOM    713  C   ARG A  46      -5.135  10.767  -2.715  1.00  0.00           C  
ATOM    714  O   ARG A  46      -5.624  10.205  -1.738  1.00  0.00           O  
ATOM    715  CB  ARG A  46      -6.935  11.033  -4.422  1.00  0.00           C  
ATOM    716  CG  ARG A  46      -7.546  10.467  -5.705  1.00  0.00           C  
ATOM    717  CD  ARG A  46      -7.657  11.548  -6.782  1.00  0.00           C  
ATOM    718  NE  ARG A  46      -8.946  12.263  -6.651  1.00  0.00           N  
ATOM    719  CZ  ARG A  46     -10.103  11.845  -7.208  1.00  0.00           C  
ATOM    720  NH1 ARG A  46     -10.141  10.712  -7.940  1.00  0.00           N  
ATOM    721  NH2 ARG A  46     -11.195  12.563  -7.026  1.00  0.00           N  
ATOM    722  H   ARG A  46      -6.526   8.538  -4.042  1.00  0.00           H  
ATOM    723  HA  ARG A  46      -4.843  10.710  -4.869  1.00  0.00           H  
ATOM    724  HB2 ARG A  46      -7.612  10.857  -3.584  1.00  0.00           H  
ATOM    725  HB3 ARG A  46      -6.819  12.112  -4.515  1.00  0.00           H  
ATOM    726  HG2 ARG A  46      -6.932   9.644  -6.072  1.00  0.00           H  
ATOM    727  HG3 ARG A  46      -8.533  10.058  -5.493  1.00  0.00           H  
ATOM    728  HD2 ARG A  46      -6.829  12.252  -6.689  1.00  0.00           H  
ATOM    729  HD3 ARG A  46      -7.580  11.096  -7.771  1.00  0.00           H  
ATOM    730  HE  ARG A  46      -8.961  13.108  -6.117  1.00  0.00           H  
ATOM    731 HH11 ARG A  46      -9.308  10.174  -8.072  1.00  0.00           H  
ATOM    732 HH12 ARG A  46     -11.002  10.410  -8.349  1.00  0.00           H  
ATOM    733 HH21 ARG A  46     -12.091  12.324  -7.404  1.00  0.00           H  
ATOM    734  N   GLY A  47      -4.214  11.718  -2.651  1.00  0.00           N  
ATOM    735  CA  GLY A  47      -3.700  12.177  -1.372  1.00  0.00           C  
ATOM    736  C   GLY A  47      -2.298  11.623  -1.114  1.00  0.00           C  
ATOM    737  O   GLY A  47      -1.854  10.703  -1.798  1.00  0.00           O  
ATOM    738  H   GLY A  47      -3.821  12.171  -3.452  1.00  0.00           H  
ATOM    739  HA2 GLY A  47      -3.672  13.267  -1.357  1.00  0.00           H  
ATOM    740  HA3 GLY A  47      -4.372  11.864  -0.573  1.00  0.00           H  
ATOM    741  N   PRO A  48      -1.621  12.222  -0.098  1.00  0.00           N  
ATOM    742  CA  PRO A  48      -0.278  11.798   0.260  1.00  0.00           C  
ATOM    743  C   PRO A  48      -0.306  10.468   1.016  1.00  0.00           C  
ATOM    744  O   PRO A  48      -1.302   9.748   0.975  1.00  0.00           O  
ATOM    745  CB  PRO A  48       0.288  12.941   1.088  1.00  0.00           C  
ATOM    746  CG  PRO A  48      -0.910  13.751   1.553  1.00  0.00           C  
ATOM    747  CD  PRO A  48      -2.115  13.316   0.735  1.00  0.00           C  
ATOM    748  HA  PRO A  48       0.264  11.632  -0.564  1.00  0.00           H  
ATOM    749  HB2 PRO A  48       0.858  12.563   1.936  1.00  0.00           H  
ATOM    750  HB3 PRO A  48       0.968  13.552   0.495  1.00  0.00           H  
ATOM    751  HG2 PRO A  48      -1.091  13.589   2.616  1.00  0.00           H  
ATOM    752  HG3 PRO A  48      -0.724  14.818   1.420  1.00  0.00           H  
ATOM    753  HD2 PRO A  48      -2.931  12.985   1.377  1.00  0.00           H  
ATOM    754  HD3 PRO A  48      -2.499  14.134   0.127  1.00  0.00           H  
ATOM    755  N   VAL A  49       0.799  10.184   1.690  1.00  0.00           N  
ATOM    756  CA  VAL A  49       0.914   8.953   2.454  1.00  0.00           C  
ATOM    757  C   VAL A  49       2.190   8.998   3.296  1.00  0.00           C  
ATOM    758  O   VAL A  49       3.008   9.904   3.142  1.00  0.00           O  
ATOM    759  CB  VAL A  49       0.858   7.747   1.515  1.00  0.00           C  
ATOM    760  CG1 VAL A  49       2.147   7.627   0.700  1.00  0.00           C  
ATOM    761  CG2 VAL A  49       0.580   6.459   2.294  1.00  0.00           C  
ATOM    762  H   VAL A  49       1.604  10.775   1.718  1.00  0.00           H  
ATOM    763  HA  VAL A  49       0.055   8.901   3.123  1.00  0.00           H  
ATOM    764  HB  VAL A  49       0.033   7.901   0.819  1.00  0.00           H  
ATOM    765 HG11 VAL A  49       2.255   6.604   0.339  1.00  0.00           H  
ATOM    766 HG12 VAL A  49       2.104   8.310  -0.150  1.00  0.00           H  
ATOM    767 HG13 VAL A  49       3.000   7.883   1.329  1.00  0.00           H  
ATOM    768 HG21 VAL A  49       0.022   6.695   3.200  1.00  0.00           H  
ATOM    769 HG22 VAL A  49      -0.004   5.778   1.674  1.00  0.00           H  
ATOM    770 HG23 VAL A  49       1.525   5.985   2.562  1.00  0.00           H  
ATOM    771  N   ARG A  50       2.321   8.009   4.167  1.00  0.00           N  
ATOM    772  CA  ARG A  50       3.485   7.923   5.033  1.00  0.00           C  
ATOM    773  C   ARG A  50       3.827   6.461   5.320  1.00  0.00           C  
ATOM    774  O   ARG A  50       2.961   5.682   5.716  1.00  0.00           O  
ATOM    775  CB  ARG A  50       3.242   8.652   6.356  1.00  0.00           C  
ATOM    776  CG  ARG A  50       2.592  10.016   6.120  1.00  0.00           C  
ATOM    777  CD  ARG A  50       2.092  10.621   7.433  1.00  0.00           C  
ATOM    778  NE  ARG A  50       1.192  11.763   7.155  1.00  0.00           N  
ATOM    779  CZ  ARG A  50       0.248  12.208   8.011  1.00  0.00           C  
ATOM    780  NH1 ARG A  50       0.072  11.610   9.208  1.00  0.00           N  
ATOM    781  NH2 ARG A  50      -0.501  13.237   7.659  1.00  0.00           N  
ATOM    782  H   ARG A  50       1.652   7.275   4.285  1.00  0.00           H  
ATOM    783  HA  ARG A  50       4.284   8.412   4.475  1.00  0.00           H  
ATOM    784  HB2 ARG A  50       2.599   8.046   6.996  1.00  0.00           H  
ATOM    785  HB3 ARG A  50       4.187   8.781   6.884  1.00  0.00           H  
ATOM    786  HG2 ARG A  50       3.312  10.690   5.656  1.00  0.00           H  
ATOM    787  HG3 ARG A  50       1.759   9.912   5.424  1.00  0.00           H  
ATOM    788  HD2 ARG A  50       1.565   9.865   8.014  1.00  0.00           H  
ATOM    789  HD3 ARG A  50       2.938  10.953   8.036  1.00  0.00           H  
ATOM    790  HE  ARG A  50       1.290  12.234   6.278  1.00  0.00           H  
ATOM    791 HH11 ARG A  50       0.643  10.832   9.467  1.00  0.00           H  
ATOM    792 HH12 ARG A  50      -0.630  11.947   9.836  1.00  0.00           H  
ATOM    793 HH21 ARG A  50      -1.220  13.627   8.233  1.00  0.00           H  
ATOM    794  N   VAL A  51       5.093   6.129   5.108  1.00  0.00           N  
ATOM    795  CA  VAL A  51       5.561   4.773   5.338  1.00  0.00           C  
ATOM    796  C   VAL A  51       4.915   4.226   6.613  1.00  0.00           C  
ATOM    797  O   VAL A  51       5.059   4.809   7.686  1.00  0.00           O  
ATOM    798  CB  VAL A  51       7.090   4.748   5.385  1.00  0.00           C  
ATOM    799  CG1 VAL A  51       7.606   3.342   5.699  1.00  0.00           C  
ATOM    800  CG2 VAL A  51       7.687   5.270   4.076  1.00  0.00           C  
ATOM    801  H   VAL A  51       5.792   6.768   4.785  1.00  0.00           H  
ATOM    802  HA  VAL A  51       5.238   4.165   4.493  1.00  0.00           H  
ATOM    803  HB  VAL A  51       7.412   5.410   6.187  1.00  0.00           H  
ATOM    804 HG11 VAL A  51       6.920   2.850   6.390  1.00  0.00           H  
ATOM    805 HG12 VAL A  51       7.670   2.764   4.778  1.00  0.00           H  
ATOM    806 HG13 VAL A  51       8.593   3.411   6.155  1.00  0.00           H  
ATOM    807 HG21 VAL A  51       8.136   6.247   4.246  1.00  0.00           H  
ATOM    808 HG22 VAL A  51       8.449   4.576   3.721  1.00  0.00           H  
ATOM    809 HG23 VAL A  51       6.899   5.358   3.327  1.00  0.00           H  
ATOM    810  N   GLY A  52       4.218   3.110   6.453  1.00  0.00           N  
ATOM    811  CA  GLY A  52       3.551   2.478   7.577  1.00  0.00           C  
ATOM    812  C   GLY A  52       2.058   2.295   7.297  1.00  0.00           C  
ATOM    813  O   GLY A  52       1.444   1.342   7.777  1.00  0.00           O  
ATOM    814  H   GLY A  52       4.107   2.641   5.577  1.00  0.00           H  
ATOM    815  HA2 GLY A  52       4.007   1.508   7.778  1.00  0.00           H  
ATOM    816  HA3 GLY A  52       3.685   3.084   8.473  1.00  0.00           H  
ATOM    817  N   ASP A  53       1.516   3.223   6.521  1.00  0.00           N  
ATOM    818  CA  ASP A  53       0.107   3.175   6.171  1.00  0.00           C  
ATOM    819  C   ASP A  53      -0.275   1.741   5.805  1.00  0.00           C  
ATOM    820  O   ASP A  53       0.555   0.979   5.312  1.00  0.00           O  
ATOM    821  CB  ASP A  53      -0.190   4.067   4.963  1.00  0.00           C  
ATOM    822  CG  ASP A  53      -1.512   4.832   5.033  1.00  0.00           C  
ATOM    823  OD1 ASP A  53      -2.599   4.235   5.002  1.00  0.00           O  
ATOM    824  OD2 ASP A  53      -1.396   6.114   5.125  1.00  0.00           O  
ATOM    825  H   ASP A  53       2.023   3.994   6.134  1.00  0.00           H  
ATOM    826  HA  ASP A  53      -0.419   3.536   7.054  1.00  0.00           H  
ATOM    827  HB2 ASP A  53       0.623   4.784   4.851  1.00  0.00           H  
ATOM    828  HB3 ASP A  53      -0.193   3.448   4.066  1.00  0.00           H  
ATOM    829  HD2 ASP A  53      -0.735   6.347   5.839  1.00  0.00           H  
ATOM    830  N   ILE A  54      -1.534   1.414   6.061  1.00  0.00           N  
ATOM    831  CA  ILE A  54      -2.038   0.083   5.766  1.00  0.00           C  
ATOM    832  C   ILE A  54      -3.414   0.198   5.107  1.00  0.00           C  
ATOM    833  O   ILE A  54      -4.230   1.027   5.508  1.00  0.00           O  
ATOM    834  CB  ILE A  54      -2.029  -0.785   7.025  1.00  0.00           C  
ATOM    835  CG1 ILE A  54      -0.600  -1.152   7.430  1.00  0.00           C  
ATOM    836  CG2 ILE A  54      -2.909  -2.023   6.844  1.00  0.00           C  
ATOM    837  CD1 ILE A  54      -0.542  -1.606   8.889  1.00  0.00           C  
ATOM    838  H   ILE A  54      -2.203   2.039   6.464  1.00  0.00           H  
ATOM    839  HA  ILE A  54      -1.351  -0.375   5.054  1.00  0.00           H  
ATOM    840  HB  ILE A  54      -2.456  -0.204   7.843  1.00  0.00           H  
ATOM    841 HG12 ILE A  54      -0.228  -1.946   6.782  1.00  0.00           H  
ATOM    842 HG13 ILE A  54       0.055  -0.291   7.286  1.00  0.00           H  
ATOM    843 HG21 ILE A  54      -2.436  -2.879   7.326  1.00  0.00           H  
ATOM    844 HG22 ILE A  54      -3.884  -1.846   7.295  1.00  0.00           H  
ATOM    845 HG23 ILE A  54      -3.032  -2.228   5.780  1.00  0.00           H  
ATOM    846 HD11 ILE A  54      -1.439  -1.273   9.409  1.00  0.00           H  
ATOM    847 HD12 ILE A  54      -0.481  -2.694   8.929  1.00  0.00           H  
ATOM    848 HD13 ILE A  54       0.338  -1.177   9.369  1.00  0.00           H  
ATOM    849  N   LEU A  55      -3.628  -0.646   4.109  1.00  0.00           N  
ATOM    850  CA  LEU A  55      -4.892  -0.649   3.391  1.00  0.00           C  
ATOM    851  C   LEU A  55      -5.103  -2.021   2.746  1.00  0.00           C  
ATOM    852  O   LEU A  55      -4.169  -2.602   2.195  1.00  0.00           O  
ATOM    853  CB  LEU A  55      -4.947   0.512   2.398  1.00  0.00           C  
ATOM    854  CG  LEU A  55      -5.700   1.760   2.866  1.00  0.00           C  
ATOM    855  CD1 LEU A  55      -4.933   3.032   2.500  1.00  0.00           C  
ATOM    856  CD2 LEU A  55      -7.129   1.775   2.320  1.00  0.00           C  
ATOM    857  H   LEU A  55      -2.959  -1.317   3.790  1.00  0.00           H  
ATOM    858  HA  LEU A  55      -5.683  -0.487   4.122  1.00  0.00           H  
ATOM    859  HB2 LEU A  55      -3.926   0.801   2.149  1.00  0.00           H  
ATOM    860  HB3 LEU A  55      -5.411   0.157   1.478  1.00  0.00           H  
ATOM    861  HG  LEU A  55      -5.771   1.728   3.952  1.00  0.00           H  
ATOM    862 HD11 LEU A  55      -4.402   3.401   3.378  1.00  0.00           H  
ATOM    863 HD12 LEU A  55      -4.217   2.811   1.709  1.00  0.00           H  
ATOM    864 HD13 LEU A  55      -5.634   3.792   2.154  1.00  0.00           H  
ATOM    865 HD21 LEU A  55      -7.834   1.853   3.148  1.00  0.00           H  
ATOM    866 HD22 LEU A  55      -7.255   2.629   1.655  1.00  0.00           H  
ATOM    867 HD23 LEU A  55      -7.317   0.853   1.768  1.00  0.00           H  
ATOM    868  N   ILE A  56      -6.336  -2.498   2.835  1.00  0.00           N  
ATOM    869  CA  ILE A  56      -6.681  -3.790   2.267  1.00  0.00           C  
ATOM    870  C   ILE A  56      -7.075  -3.607   0.800  1.00  0.00           C  
ATOM    871  O   ILE A  56      -7.645  -2.582   0.429  1.00  0.00           O  
ATOM    872  CB  ILE A  56      -7.756  -4.477   3.111  1.00  0.00           C  
ATOM    873  CG1 ILE A  56      -7.660  -4.045   4.576  1.00  0.00           C  
ATOM    874  CG2 ILE A  56      -7.686  -5.997   2.955  1.00  0.00           C  
ATOM    875  CD1 ILE A  56      -8.432  -5.007   5.482  1.00  0.00           C  
ATOM    876  H   ILE A  56      -7.089  -2.019   3.284  1.00  0.00           H  
ATOM    877  HA  ILE A  56      -5.789  -4.414   2.309  1.00  0.00           H  
ATOM    878  HB  ILE A  56      -8.732  -4.161   2.745  1.00  0.00           H  
ATOM    879 HG12 ILE A  56      -6.615  -4.012   4.881  1.00  0.00           H  
ATOM    880 HG13 ILE A  56      -8.057  -3.037   4.688  1.00  0.00           H  
ATOM    881 HG21 ILE A  56      -6.933  -6.398   3.635  1.00  0.00           H  
ATOM    882 HG22 ILE A  56      -8.657  -6.432   3.193  1.00  0.00           H  
ATOM    883 HG23 ILE A  56      -7.418  -6.246   1.929  1.00  0.00           H  
ATOM    884 HD11 ILE A  56      -8.681  -4.504   6.417  1.00  0.00           H  
ATOM    885 HD12 ILE A  56      -9.349  -5.320   4.983  1.00  0.00           H  
ATOM    886 HD13 ILE A  56      -7.816  -5.881   5.692  1.00  0.00           H  
ATOM    887  N   LEU A  57      -6.757  -4.618   0.004  1.00  0.00           N  
ATOM    888  CA  LEU A  57      -7.071  -4.583  -1.414  1.00  0.00           C  
ATOM    889  C   LEU A  57      -8.128  -5.644  -1.725  1.00  0.00           C  
ATOM    890  O   LEU A  57      -7.793  -6.772  -2.085  1.00  0.00           O  
ATOM    891  CB  LEU A  57      -5.796  -4.720  -2.249  1.00  0.00           C  
ATOM    892  CG  LEU A  57      -4.853  -3.515  -2.236  1.00  0.00           C  
ATOM    893  CD1 LEU A  57      -5.622  -2.215  -2.473  1.00  0.00           C  
ATOM    894  CD2 LEU A  57      -4.036  -3.472  -0.943  1.00  0.00           C  
ATOM    895  H   LEU A  57      -6.294  -5.449   0.313  1.00  0.00           H  
ATOM    896  HA  LEU A  57      -7.493  -3.601  -1.630  1.00  0.00           H  
ATOM    897  HB2 LEU A  57      -5.246  -5.591  -1.894  1.00  0.00           H  
ATOM    898  HB3 LEU A  57      -6.082  -4.922  -3.281  1.00  0.00           H  
ATOM    899  HG  LEU A  57      -4.146  -3.627  -3.060  1.00  0.00           H  
ATOM    900 HD11 LEU A  57      -4.977  -1.499  -2.983  1.00  0.00           H  
ATOM    901 HD12 LEU A  57      -6.499  -2.417  -3.089  1.00  0.00           H  
ATOM    902 HD13 LEU A  57      -5.939  -1.801  -1.516  1.00  0.00           H  
ATOM    903 HD21 LEU A  57      -3.260  -2.711  -1.029  1.00  0.00           H  
ATOM    904 HD22 LEU A  57      -4.692  -3.229  -0.108  1.00  0.00           H  
ATOM    905 HD23 LEU A  57      -3.576  -4.444  -0.772  1.00  0.00           H  
ATOM    906  N   ARG A  58      -9.383  -5.247  -1.575  1.00  0.00           N  
ATOM    907  CA  ARG A  58     -10.490  -6.150  -1.836  1.00  0.00           C  
ATOM    908  C   ARG A  58     -10.565  -6.482  -3.327  1.00  0.00           C  
ATOM    909  O   ARG A  58     -11.131  -7.505  -3.711  1.00  0.00           O  
ATOM    910  CB  ARG A  58     -11.818  -5.536  -1.390  1.00  0.00           C  
ATOM    911  CG  ARG A  58     -12.068  -4.200  -2.094  1.00  0.00           C  
ATOM    912  CD  ARG A  58     -13.269  -4.293  -3.037  1.00  0.00           C  
ATOM    913  NE  ARG A  58     -14.479  -3.758  -2.373  1.00  0.00           N  
ATOM    914  CZ  ARG A  58     -14.694  -2.446  -2.138  1.00  0.00           C  
ATOM    915  NH1 ARG A  58     -13.782  -1.523  -2.513  1.00  0.00           N  
ATOM    916  NH2 ARG A  58     -15.811  -2.079  -1.537  1.00  0.00           N  
ATOM    917  H   ARG A  58      -9.647  -4.328  -1.282  1.00  0.00           H  
ATOM    918  HA  ARG A  58     -10.269  -7.040  -1.246  1.00  0.00           H  
ATOM    919  HB2 ARG A  58     -12.634  -6.225  -1.610  1.00  0.00           H  
ATOM    920  HB3 ARG A  58     -11.810  -5.386  -0.310  1.00  0.00           H  
ATOM    921  HG2 ARG A  58     -12.245  -3.422  -1.351  1.00  0.00           H  
ATOM    922  HG3 ARG A  58     -11.181  -3.910  -2.656  1.00  0.00           H  
ATOM    923  HD2 ARG A  58     -13.068  -3.734  -3.951  1.00  0.00           H  
ATOM    924  HD3 ARG A  58     -13.433  -5.332  -3.328  1.00  0.00           H  
ATOM    925  HE  ARG A  58     -15.179  -4.409  -2.080  1.00  0.00           H  
ATOM    926 HH11 ARG A  58     -12.940  -1.810  -2.967  1.00  0.00           H  
ATOM    927 HH12 ARG A  58     -13.950  -0.555  -2.335  1.00  0.00           H  
ATOM    928 HH21 ARG A  58     -16.047  -1.131  -1.327  1.00  0.00           H  
ATOM    929  N   GLU A  59      -9.986  -5.599  -4.127  1.00  0.00           N  
ATOM    930  CA  GLU A  59      -9.980  -5.786  -5.568  1.00  0.00           C  
ATOM    931  C   GLU A  59      -8.739  -5.135  -6.182  1.00  0.00           C  
ATOM    932  O   GLU A  59      -8.046  -5.752  -6.990  1.00  0.00           O  
ATOM    933  CB  GLU A  59     -11.258  -5.232  -6.198  1.00  0.00           C  
ATOM    934  CG  GLU A  59     -11.572  -5.942  -7.518  1.00  0.00           C  
ATOM    935  CD  GLU A  59     -13.064  -6.264  -7.626  1.00  0.00           C  
ATOM    936  OE1 GLU A  59     -13.735  -5.790  -8.554  1.00  0.00           O  
ATOM    937  OE2 GLU A  59     -13.523  -7.038  -6.700  1.00  0.00           O  
ATOM    938  H   GLU A  59      -9.528  -4.770  -3.806  1.00  0.00           H  
ATOM    939  HA  GLU A  59      -9.945  -6.865  -5.720  1.00  0.00           H  
ATOM    940  HB2 GLU A  59     -12.093  -5.356  -5.508  1.00  0.00           H  
ATOM    941  HB3 GLU A  59     -11.148  -4.163  -6.374  1.00  0.00           H  
ATOM    942  HG2 GLU A  59     -11.270  -5.312  -8.354  1.00  0.00           H  
ATOM    943  HG3 GLU A  59     -10.993  -6.862  -7.586  1.00  0.00           H  
ATOM    944  HE2 GLU A  59     -13.014  -7.898  -6.691  1.00  0.00           H  
ATOM    945  N   THR A  60      -8.497  -3.897  -5.776  1.00  0.00           N  
ATOM    946  CA  THR A  60      -7.352  -3.156  -6.276  1.00  0.00           C  
ATOM    947  C   THR A  60      -7.654  -2.579  -7.661  1.00  0.00           C  
ATOM    948  O   THR A  60      -6.830  -1.868  -8.234  1.00  0.00           O  
ATOM    949  CB  THR A  60      -6.140  -4.090  -6.258  1.00  0.00           C  
ATOM    950  OG1 THR A  60      -5.066  -3.256  -5.830  1.00  0.00           O  
ATOM    951  CG2 THR A  60      -5.725  -4.538  -7.662  1.00  0.00           C  
ATOM    952  H   THR A  60      -9.066  -3.404  -5.118  1.00  0.00           H  
ATOM    953  HA  THR A  60      -7.171  -2.312  -5.610  1.00  0.00           H  
ATOM    954  HB  THR A  60      -6.319  -4.948  -5.613  1.00  0.00           H  
ATOM    955  HG1 THR A  60      -4.194  -3.725  -5.967  1.00  0.00           H  
ATOM    956 HG21 THR A  60      -5.168  -5.471  -7.595  1.00  0.00           H  
ATOM    957 HG22 THR A  60      -6.615  -4.688  -8.273  1.00  0.00           H  
ATOM    958 HG23 THR A  60      -5.097  -3.771  -8.117  1.00  0.00           H  
ATOM    959  N   GLU A  61      -8.838  -2.905  -8.157  1.00  0.00           N  
ATOM    960  CA  GLU A  61      -9.259  -2.428  -9.464  1.00  0.00           C  
ATOM    961  C   GLU A  61      -8.148  -2.649 -10.493  1.00  0.00           C  
ATOM    962  O   GLU A  61      -7.117  -3.242 -10.181  1.00  0.00           O  
ATOM    963  CB  GLU A  61      -9.666  -0.955  -9.404  1.00  0.00           C  
ATOM    964  CG  GLU A  61     -10.906  -0.763  -8.527  1.00  0.00           C  
ATOM    965  CD  GLU A  61     -11.421   0.674  -8.614  1.00  0.00           C  
ATOM    966  OE1 GLU A  61     -10.860   1.491  -9.359  1.00  0.00           O  
ATOM    967  OE2 GLU A  61     -12.444   0.932  -7.871  1.00  0.00           O  
ATOM    968  H   GLU A  61      -9.503  -3.484  -7.685  1.00  0.00           H  
ATOM    969  HA  GLU A  61     -10.131  -3.029  -9.724  1.00  0.00           H  
ATOM    970  HB2 GLU A  61      -8.841  -0.361  -9.008  1.00  0.00           H  
ATOM    971  HB3 GLU A  61      -9.869  -0.589 -10.411  1.00  0.00           H  
ATOM    972  HG2 GLU A  61     -11.688  -1.453  -8.842  1.00  0.00           H  
ATOM    973  HG3 GLU A  61     -10.664  -1.006  -7.492  1.00  0.00           H  
ATOM    974  HE2 GLU A  61     -13.267   1.004  -8.435  1.00  0.00           H  
ATOM    975  N   ARG A  62      -8.398  -2.160 -11.699  1.00  0.00           N  
ATOM    976  CA  ARG A  62      -7.431  -2.297 -12.776  1.00  0.00           C  
ATOM    977  C   ARG A  62      -7.550  -1.119 -13.747  1.00  0.00           C  
ATOM    978  O   ARG A  62      -6.590  -0.378 -13.948  1.00  0.00           O  
ATOM    979  CB  ARG A  62      -7.642  -3.604 -13.542  1.00  0.00           C  
ATOM    980  CG  ARG A  62      -6.465  -3.888 -14.477  1.00  0.00           C  
ATOM    981  CD  ARG A  62      -6.920  -4.670 -15.710  1.00  0.00           C  
ATOM    982  NE  ARG A  62      -6.687  -6.117 -15.506  1.00  0.00           N  
ATOM    983  CZ  ARG A  62      -7.333  -7.091 -16.181  1.00  0.00           C  
ATOM    984  NH1 ARG A  62      -8.259  -6.780 -17.112  1.00  0.00           N  
ATOM    985  NH2 ARG A  62      -7.046  -8.352 -15.917  1.00  0.00           N  
ATOM    986  H   ARG A  62      -9.240  -1.678 -11.944  1.00  0.00           H  
ATOM    987  HA  ARG A  62      -6.461  -2.300 -12.281  1.00  0.00           H  
ATOM    988  HB2 ARG A  62      -7.758  -4.427 -12.837  1.00  0.00           H  
ATOM    989  HB3 ARG A  62      -8.565  -3.547 -14.119  1.00  0.00           H  
ATOM    990  HG2 ARG A  62      -6.008  -2.947 -14.786  1.00  0.00           H  
ATOM    991  HG3 ARG A  62      -5.701  -4.453 -13.944  1.00  0.00           H  
ATOM    992  HD2 ARG A  62      -7.978  -4.486 -15.898  1.00  0.00           H  
ATOM    993  HD3 ARG A  62      -6.376  -4.326 -16.590  1.00  0.00           H  
ATOM    994  HE  ARG A  62      -6.007  -6.390 -14.824  1.00  0.00           H  
ATOM    995 HH11 ARG A  62      -8.472  -5.822 -17.306  1.00  0.00           H  
ATOM    996 HH12 ARG A  62      -8.733  -7.507 -17.608  1.00  0.00           H  
ATOM    997 HH21 ARG A  62      -7.477  -9.131 -16.372  1.00  0.00           H  
ATOM    998  N   GLU A  63      -8.735  -0.986 -14.324  1.00  0.00           N  
ATOM    999  CA  GLU A  63      -8.992   0.086 -15.269  1.00  0.00           C  
ATOM   1000  C   GLU A  63      -8.131  -0.092 -16.521  1.00  0.00           C  
ATOM   1001  O   GLU A  63      -7.101   0.565 -16.671  1.00  0.00           O  
ATOM   1002  CB  GLU A  63      -8.746   1.454 -14.626  1.00  0.00           C  
ATOM   1003  CG  GLU A  63     -10.063   2.201 -14.410  1.00  0.00           C  
ATOM   1004  CD  GLU A  63     -10.128   2.803 -13.005  1.00  0.00           C  
ATOM   1005  OE1 GLU A  63      -9.083   3.020 -12.374  1.00  0.00           O  
ATOM   1006  OE2 GLU A  63     -11.318   3.046 -12.569  1.00  0.00           O  
ATOM   1007  H   GLU A  63      -9.511  -1.595 -14.155  1.00  0.00           H  
ATOM   1008  HA  GLU A  63     -10.046  -0.002 -15.529  1.00  0.00           H  
ATOM   1009  HB2 GLU A  63      -8.236   1.323 -13.671  1.00  0.00           H  
ATOM   1010  HB3 GLU A  63      -8.088   2.045 -15.261  1.00  0.00           H  
ATOM   1011  HG2 GLU A  63     -10.162   2.994 -15.152  1.00  0.00           H  
ATOM   1012  HG3 GLU A  63     -10.901   1.520 -14.557  1.00  0.00           H  
ATOM   1013  HE2 GLU A  63     -11.304   3.151 -11.575  1.00  0.00           H  
ATOM   1014  N   ALA A  64      -8.583  -0.985 -17.389  1.00  0.00           N  
ATOM   1015  CA  ALA A  64      -7.868  -1.259 -18.624  1.00  0.00           C  
ATOM   1016  C   ALA A  64      -8.540  -0.508 -19.774  1.00  0.00           C  
ATOM   1017  O   ALA A  64      -8.975  -1.119 -20.750  1.00  0.00           O  
ATOM   1018  CB  ALA A  64      -7.820  -2.770 -18.862  1.00  0.00           C  
ATOM   1019  H   ALA A  64      -9.422  -1.516 -17.260  1.00  0.00           H  
ATOM   1020  HA  ALA A  64      -6.849  -0.889 -18.506  1.00  0.00           H  
ATOM   1021  HB1 ALA A  64      -8.734  -3.088 -19.363  1.00  0.00           H  
ATOM   1022  HB2 ALA A  64      -6.960  -3.011 -19.487  1.00  0.00           H  
ATOM   1023  HB3 ALA A  64      -7.730  -3.285 -17.906  1.00  0.00           H  
ATOM   1024  N   ARG A  65      -8.605   0.806 -19.624  1.00  0.00           N  
ATOM   1025  CA  ARG A  65      -9.217   1.647 -20.639  1.00  0.00           C  
ATOM   1026  C   ARG A  65      -8.568   1.391 -22.001  1.00  0.00           C  
ATOM   1027  O   ARG A  65      -9.242   0.984 -22.947  1.00  0.00           O  
ATOM   1028  CB  ARG A  65      -9.077   3.129 -20.285  1.00  0.00           C  
ATOM   1029  CG  ARG A  65      -9.963   3.493 -19.091  1.00  0.00           C  
ATOM   1030  CD  ARG A  65     -10.248   4.997 -19.059  1.00  0.00           C  
ATOM   1031  NE  ARG A  65     -11.546   5.280 -19.710  1.00  0.00           N  
ATOM   1032  CZ  ARG A  65     -12.746   5.013 -19.153  1.00  0.00           C  
ATOM   1033  NH1 ARG A  65     -12.823   4.451 -17.928  1.00  0.00           N  
ATOM   1034  NH2 ARG A  65     -13.843   5.308 -19.824  1.00  0.00           N  
ATOM   1035  H   ARG A  65      -8.249   1.297 -18.828  1.00  0.00           H  
ATOM   1036  HA  ARG A  65     -10.268   1.358 -20.644  1.00  0.00           H  
ATOM   1037  HB2 ARG A  65      -8.037   3.354 -20.051  1.00  0.00           H  
ATOM   1038  HB3 ARG A  65      -9.350   3.740 -21.146  1.00  0.00           H  
ATOM   1039  HG2 ARG A  65     -10.902   2.944 -19.150  1.00  0.00           H  
ATOM   1040  HG3 ARG A  65      -9.474   3.192 -18.165  1.00  0.00           H  
ATOM   1041  HD2 ARG A  65     -10.263   5.350 -18.029  1.00  0.00           H  
ATOM   1042  HD3 ARG A  65      -9.450   5.537 -19.569  1.00  0.00           H  
ATOM   1043  HE  ARG A  65     -11.534   5.697 -20.619  1.00  0.00           H  
ATOM   1044 HH11 ARG A  65     -11.986   4.230 -17.426  1.00  0.00           H  
ATOM   1045 HH12 ARG A  65     -13.716   4.256 -17.522  1.00  0.00           H  
ATOM   1046 HH21 ARG A  65     -14.769   5.142 -19.485  1.00  0.00           H  
ATOM   1047  N   GLU A  66      -7.268   1.642 -22.058  1.00  0.00           N  
ATOM   1048  CA  GLU A  66      -6.522   1.444 -23.289  1.00  0.00           C  
ATOM   1049  C   GLU A  66      -7.069   2.350 -24.393  1.00  0.00           C  
ATOM   1050  O   GLU A  66      -7.608   1.867 -25.388  1.00  0.00           O  
ATOM   1051  CB  GLU A  66      -6.552  -0.024 -23.718  1.00  0.00           C  
ATOM   1052  CG  GLU A  66      -5.363  -0.356 -24.623  1.00  0.00           C  
ATOM   1053  CD  GLU A  66      -4.247  -1.041 -23.832  1.00  0.00           C  
ATOM   1054  OE1 GLU A  66      -3.406  -0.358 -23.228  1.00  0.00           O  
ATOM   1055  OE2 GLU A  66      -4.272  -2.330 -23.859  1.00  0.00           O  
ATOM   1056  H   GLU A  66      -6.728   1.973 -21.284  1.00  0.00           H  
ATOM   1057  HA  GLU A  66      -5.496   1.726 -23.054  1.00  0.00           H  
ATOM   1058  HB2 GLU A  66      -6.533  -0.665 -22.837  1.00  0.00           H  
ATOM   1059  HB3 GLU A  66      -7.484  -0.234 -24.244  1.00  0.00           H  
ATOM   1060  HG2 GLU A  66      -5.689  -1.004 -25.435  1.00  0.00           H  
ATOM   1061  HG3 GLU A  66      -4.982   0.558 -25.078  1.00  0.00           H  
ATOM   1062  HE2 GLU A  66      -4.089  -2.657 -24.785  1.00  0.00           H  
ATOM   1063  N   ILE A  67      -6.914   3.649 -24.181  1.00  0.00           N  
ATOM   1064  CA  ILE A  67      -7.386   4.626 -25.146  1.00  0.00           C  
ATOM   1065  C   ILE A  67      -7.068   4.136 -26.560  1.00  0.00           C  
ATOM   1066  O   ILE A  67      -5.902   4.032 -26.937  1.00  0.00           O  
ATOM   1067  CB  ILE A  67      -6.813   6.010 -24.832  1.00  0.00           C  
ATOM   1068  CG1 ILE A  67      -7.432   7.078 -25.736  1.00  0.00           C  
ATOM   1069  CG2 ILE A  67      -5.286   6.003 -24.916  1.00  0.00           C  
ATOM   1070  CD1 ILE A  67      -8.653   7.718 -25.072  1.00  0.00           C  
ATOM   1071  H   ILE A  67      -6.476   4.034 -23.369  1.00  0.00           H  
ATOM   1072  HA  ILE A  67      -8.469   4.694 -25.039  1.00  0.00           H  
ATOM   1073  HB  ILE A  67      -7.078   6.264 -23.805  1.00  0.00           H  
ATOM   1074 HG12 ILE A  67      -6.691   7.845 -25.958  1.00  0.00           H  
ATOM   1075 HG13 ILE A  67      -7.723   6.631 -26.687  1.00  0.00           H  
ATOM   1076 HG21 ILE A  67      -4.978   6.149 -25.951  1.00  0.00           H  
ATOM   1077 HG22 ILE A  67      -4.884   6.806 -24.300  1.00  0.00           H  
ATOM   1078 HG23 ILE A  67      -4.907   5.045 -24.557  1.00  0.00           H  
ATOM   1079 HD11 ILE A  67      -8.676   7.447 -24.016  1.00  0.00           H  
ATOM   1080 HD12 ILE A  67      -8.593   8.802 -25.168  1.00  0.00           H  
ATOM   1081 HD13 ILE A  67      -9.561   7.360 -25.558  1.00  0.00           H  
ATOM   1082  N   LYS A  68      -8.126   3.848 -27.304  1.00  0.00           N  
ATOM   1083  CA  LYS A  68      -7.975   3.370 -28.668  1.00  0.00           C  
ATOM   1084  C   LYS A  68      -7.255   4.435 -29.499  1.00  0.00           C  
ATOM   1085  O   LYS A  68      -6.477   4.109 -30.393  1.00  0.00           O  
ATOM   1086  CB  LYS A  68      -9.329   2.952 -29.244  1.00  0.00           C  
ATOM   1087  CG  LYS A  68      -9.629   1.485 -28.927  1.00  0.00           C  
ATOM   1088  CD  LYS A  68     -10.953   1.347 -28.173  1.00  0.00           C  
ATOM   1089  CE  LYS A  68     -10.886   0.209 -27.152  1.00  0.00           C  
ATOM   1090  NZ  LYS A  68     -11.345  -1.061 -27.758  1.00  0.00           N  
ATOM   1091  H   LYS A  68      -9.072   3.934 -26.990  1.00  0.00           H  
ATOM   1092  HA  LYS A  68      -7.349   2.478 -28.634  1.00  0.00           H  
ATOM   1093  HB2 LYS A  68     -10.115   3.585 -28.831  1.00  0.00           H  
ATOM   1094  HB3 LYS A  68      -9.332   3.103 -30.322  1.00  0.00           H  
ATOM   1095  HG2 LYS A  68      -9.672   0.912 -29.853  1.00  0.00           H  
ATOM   1096  HG3 LYS A  68      -8.820   1.064 -28.330  1.00  0.00           H  
ATOM   1097  HD2 LYS A  68     -11.187   2.283 -27.666  1.00  0.00           H  
ATOM   1098  HD3 LYS A  68     -11.760   1.157 -28.880  1.00  0.00           H  
ATOM   1099  HE2 LYS A  68      -9.863   0.097 -26.790  1.00  0.00           H  
ATOM   1100  HE3 LYS A  68     -11.505   0.451 -26.288  1.00  0.00           H  
ATOM   1101  HZ1 LYS A  68     -11.000  -1.869 -27.254  1.00  0.00           H  
ATOM   1102  HZ2 LYS A  68     -12.357  -1.131 -27.770  1.00  0.00           H  
ATOM   1103  N   SER A  69      -7.544   5.687 -29.175  1.00  0.00           N  
ATOM   1104  CA  SER A  69      -6.934   6.802 -29.880  1.00  0.00           C  
ATOM   1105  C   SER A  69      -5.470   6.487 -30.191  1.00  0.00           C  
ATOM   1106  O   SER A  69      -5.075   6.447 -31.355  1.00  0.00           O  
ATOM   1107  CB  SER A  69      -7.038   8.093 -29.065  1.00  0.00           C  
ATOM   1108  OG  SER A  69      -6.829   9.250 -29.869  1.00  0.00           O  
ATOM   1109  H   SER A  69      -8.179   5.945 -28.446  1.00  0.00           H  
ATOM   1110  HA  SER A  69      -7.508   6.908 -30.802  1.00  0.00           H  
ATOM   1111  HB2 SER A  69      -8.021   8.148 -28.598  1.00  0.00           H  
ATOM   1112  HB3 SER A  69      -6.303   8.072 -28.260  1.00  0.00           H  
ATOM   1113  HG  SER A  69      -7.154   9.083 -30.799  1.00  0.00           H  
ATOM   1114  N   ARG A  70      -4.705   6.271 -29.131  1.00  0.00           N  
ATOM   1115  CA  ARG A  70      -3.294   5.961 -29.277  1.00  0.00           C  
ATOM   1116  C   ARG A  70      -2.668   6.836 -30.365  1.00  0.00           C  
ATOM   1117  O   ARG A  70      -2.616   6.443 -31.529  1.00  0.00           O  
ATOM   1118  CB  ARG A  70      -3.088   4.487 -29.636  1.00  0.00           C  
ATOM   1119  CG  ARG A  70      -1.599   4.140 -29.692  1.00  0.00           C  
ATOM   1120  CD  ARG A  70      -1.148   3.451 -28.402  1.00  0.00           C  
ATOM   1121  NE  ARG A  70      -0.007   2.551 -28.682  1.00  0.00           N  
ATOM   1122  CZ  ARG A  70       0.920   2.198 -27.765  1.00  0.00           C  
ATOM   1123  NH1 ARG A  70       0.849   2.667 -26.503  1.00  0.00           N  
ATOM   1124  NH2 ARG A  70       1.898   1.386 -28.125  1.00  0.00           N  
ATOM   1125  H   ARG A  70      -5.036   6.305 -28.188  1.00  0.00           H  
ATOM   1126  HA  ARG A  70      -2.859   6.177 -28.301  1.00  0.00           H  
ATOM   1127  HB2 ARG A  70      -3.585   3.857 -28.899  1.00  0.00           H  
ATOM   1128  HB3 ARG A  70      -3.551   4.276 -30.599  1.00  0.00           H  
ATOM   1129  HG2 ARG A  70      -1.405   3.488 -30.543  1.00  0.00           H  
ATOM   1130  HG3 ARG A  70      -1.016   5.047 -29.847  1.00  0.00           H  
ATOM   1131  HD2 ARG A  70      -0.859   4.199 -27.663  1.00  0.00           H  
ATOM   1132  HD3 ARG A  70      -1.975   2.884 -27.975  1.00  0.00           H  
ATOM   1133  HE  ARG A  70       0.083   2.181 -29.606  1.00  0.00           H  
ATOM   1134 HH11 ARG A  70       0.106   3.280 -26.238  1.00  0.00           H  
ATOM   1135 HH12 ARG A  70       1.540   2.401 -25.831  1.00  0.00           H  
ATOM   1136 HH21 ARG A  70       2.622   1.076 -27.510  1.00  0.00           H  
ATOM   1137  N   ARG A  71      -2.207   8.005 -29.946  1.00  0.00           N  
ATOM   1138  CA  ARG A  71      -1.587   8.940 -30.869  1.00  0.00           C  
ATOM   1139  C   ARG A  71      -0.166   9.275 -30.411  1.00  0.00           C  
ATOM   1140  O   ARG A  71       0.214   8.967 -29.282  1.00  0.00           O  
ATOM   1141  CB  ARG A  71      -2.399  10.232 -30.975  1.00  0.00           C  
ATOM   1142  CG  ARG A  71      -3.813   9.951 -31.489  1.00  0.00           C  
ATOM   1143  CD  ARG A  71      -4.255  11.020 -32.490  1.00  0.00           C  
ATOM   1144  NE  ARG A  71      -4.973  10.389 -33.620  1.00  0.00           N  
ATOM   1145  CZ  ARG A  71      -5.693  11.071 -34.536  1.00  0.00           C  
ATOM   1146  NH1 ARG A  71      -5.797  12.415 -34.461  1.00  0.00           N  
ATOM   1147  NH2 ARG A  71      -6.293  10.405 -35.503  1.00  0.00           N  
ATOM   1148  H   ARG A  71      -2.254   8.317 -28.997  1.00  0.00           H  
ATOM   1149  HA  ARG A  71      -1.577   8.420 -31.827  1.00  0.00           H  
ATOM   1150  HB2 ARG A  71      -2.452  10.713 -29.998  1.00  0.00           H  
ATOM   1151  HB3 ARG A  71      -1.896  10.928 -31.646  1.00  0.00           H  
ATOM   1152  HG2 ARG A  71      -3.843   8.969 -31.962  1.00  0.00           H  
ATOM   1153  HG3 ARG A  71      -4.509   9.922 -30.650  1.00  0.00           H  
ATOM   1154  HD2 ARG A  71      -4.902  11.746 -31.997  1.00  0.00           H  
ATOM   1155  HD3 ARG A  71      -3.387  11.565 -32.859  1.00  0.00           H  
ATOM   1156  HE  ARG A  71      -4.922   9.394 -33.711  1.00  0.00           H  
ATOM   1157 HH11 ARG A  71      -5.340  12.912 -33.724  1.00  0.00           H  
ATOM   1158 HH12 ARG A  71      -6.333  12.913 -35.143  1.00  0.00           H  
ATOM   1159 HH21 ARG A  71      -6.843  10.834 -36.220  1.00  0.00           H  
TER    1160      ARG A  71                                                      
END
MOLECULE T0468.pdb
ATOM    185  N   ASP    12      -6.755 -10.308   3.985  1.00 12.21           N 
ATOM    186  CA  ASP    12      -6.859  -9.287   2.934  1.00 33.51           C 
ATOM    187  C   ASP    12      -6.284  -7.930   3.403  1.00 64.11           C 
ATOM    188  O   ASP    12      -6.983  -6.911   3.401  1.00 41.40           O 
ATOM    189  CB  ASP    12      -8.326  -9.114   2.513  1.00 35.33           C 
ATOM    190  CG  ASP    12      -8.953 -10.396   1.984  1.00 14.03           C 
ATOM    191  OD1 ASP    12      -9.635 -11.096   2.761  1.00 65.45           O 
ATOM    192  OD2 ASP    12      -8.782 -10.698   0.785  1.00 41.34           O 
ATOM    193  H   ASP    12      -7.551 -10.537   4.502  1.00 37.79           H 
ATOM    194  HA  ASP    12      -6.288  -9.627   2.080  1.00 64.25           H 
ATOM    195 1HB  ASP    12      -8.384  -8.360   1.738  1.00 37.79           H 
ATOM    196 2HB  ASP    12      -8.898  -8.782   3.367  1.00 37.79           H 
ATOM    197  N   VAL    13      -5.011  -7.923   3.803  1.00 62.31           N 
ATOM    198  CA  VAL    13      -4.353  -6.703   4.297  1.00 31.13           C 
ATOM    199  C   VAL    13      -3.027  -6.434   3.559  1.00 41.04           C 
ATOM    200  O   VAL    13      -2.209  -7.337   3.373  1.00 71.53           O 
ATOM    201  CB  VAL    13      -4.077  -6.783   5.822  1.00 63.35           C 
ATOM    202  CG1 VAL    13      -3.481  -5.472   6.340  1.00 61.54           C 
ATOM    203  CG2 VAL    13      -5.352  -7.133   6.587  1.00 52.43           C 
ATOM    204  H   VAL    13      -4.498  -8.758   3.765  1.00 37.79           H 
ATOM    205  HA  VAL    13      -5.022  -5.870   4.120  1.00  0.02           H 
ATOM    206  HB  VAL    13      -3.355  -7.571   5.993  1.00 25.11           H 
ATOM    207 1HG1 VAL    13      -4.162  -4.657   6.134  1.00 37.79           H 
ATOM    208 2HG1 VAL    13      -2.537  -5.282   5.850  1.00 37.79           H 
ATOM    209 3HG1 VAL    13      -3.320  -5.543   7.407  1.00 37.79           H 
ATOM    210 1HG2 VAL    13      -5.736  -8.080   6.234  1.00 37.79           H 
ATOM    211 2HG2 VAL    13      -6.092  -6.364   6.427  1.00 37.79           H 
ATOM    212 3HG2 VAL    13      -5.132  -7.206   7.644  1.00 37.79           H 
ATOM    213  N   TYR    14      -2.823  -5.183   3.149  1.00 60.21           N 
ATOM    214  CA  TYR    14      -1.619  -4.782   2.404  1.00 33.52           C 
ATOM    215  C   TYR    14      -0.818  -3.712   3.167  1.00 44.32           C 
ATOM    216  O   TYR    14      -1.349  -3.040   4.051  1.00 34.22           O 
ATOM    217  CB  TYR    14      -2.012  -4.255   1.014  1.00  5.31           C 
ATOM    218  CG  TYR    14      -2.644  -5.308   0.115  1.00 12.14           C 
ATOM    219  CD1 TYR    14      -3.896  -5.843   0.407  1.00 13.42           C 
ATOM    220  CD2 TYR    14      -1.988  -5.768  -1.024  1.00 24.04           C 
ATOM    221  CE1 TYR    14      -4.474  -6.800  -0.404  1.00 72.51           C 
ATOM    222  CE2 TYR    14      -2.562  -6.725  -1.841  1.00 12.41           C 
ATOM    223  CZ  TYR    14      -3.804  -7.238  -1.526  1.00 63.34           C 
ATOM    224  OH  TYR    14      -4.378  -8.190  -2.338  1.00 24.30           O 
ATOM    225  H   TYR    14      -3.502  -4.504   3.357  1.00 37.79           H 
ATOM    226  HA  TYR    14      -0.996  -5.657   2.280  1.00 31.15           H 
ATOM    227 1HB  TYR    14      -1.128  -3.877   0.517  1.00 37.79           H 
ATOM    228 2HB  TYR    14      -2.721  -3.449   1.132  1.00 37.79           H 
ATOM    229  HD1 TYR    14      -4.421  -5.498   1.288  1.00 24.25           H 
ATOM    230  HD2 TYR    14      -1.015  -5.365  -1.269  1.00 14.40           H 
ATOM    231  HE1 TYR    14      -5.445  -7.202  -0.154  1.00 12.25           H 
ATOM    232  HE2 TYR    14      -2.036  -7.068  -2.721  1.00  3.53           H 
ATOM    233  HH  TYR    14      -5.329  -8.028  -2.403  1.00 64.32           H 
ATOM    234  N   TYR    15       0.461  -3.556   2.824  1.00 14.52           N 
ATOM    235  CA  TYR    15       1.344  -2.600   3.511  1.00 60.32           C 
ATOM    236  C   TYR    15       2.191  -1.796   2.505  1.00 34.34           C 
ATOM    237  O   TYR    15       2.812  -2.366   1.616  1.00 54.44           O 
ATOM    238  CB  TYR    15       2.256  -3.353   4.493  1.00 35.11           C 
ATOM    239  CG  TYR    15       1.495  -4.238   5.469  1.00 33.22           C 
ATOM    240  CD1 TYR    15       0.989  -3.726   6.659  1.00 14.40           C 
ATOM    241  CD2 TYR    15       1.272  -5.584   5.188  1.00 63.45           C 
ATOM    242  CE1 TYR    15       0.286  -4.527   7.539  1.00 45.31           C 
ATOM    243  CE2 TYR    15       0.571  -6.390   6.063  1.00 71.42           C 
ATOM    244  CZ  TYR    15       0.081  -5.858   7.236  1.00 23.24           C 
ATOM    245  OH  TYR    15      -0.621  -6.657   8.109  1.00 31.44           O 
ATOM    246  H   TYR    15       0.827  -4.106   2.103  1.00 37.79           H 
ATOM    247  HA  TYR    15       0.722  -1.912   4.070  1.00 70.42           H 
ATOM    248 1HB  TYR    15       2.828  -2.637   5.068  1.00 37.79           H 
ATOM    249 2HB  TYR    15       2.938  -3.982   3.936  1.00 37.79           H 
ATOM    250  HD1 TYR    15       1.153  -2.684   6.895  1.00  4.31           H 
ATOM    251  HD2 TYR    15       1.659  -5.999   4.268  1.00 63.25           H 
ATOM    252  HE1 TYR    15      -0.099  -4.109   8.459  1.00 61.02           H 
ATOM    253  HE2 TYR    15       0.408  -7.430   5.825  1.00 61.22           H 
ATOM    254  HH  TYR    15      -0.212  -7.526   8.147  1.00 35.24           H 
ATOM    255  N   MET    16       2.226  -0.472   2.666  1.00 22.02           N 
ATOM    256  CA  MET    16       2.891   0.431   1.701  1.00 30.21           C 
ATOM    257  C   MET    16       3.878   1.388   2.407  1.00 20.15           C 
ATOM    258  O   MET    16       3.795   1.581   3.610  1.00 52.31           O 
ATOM    259  CB  MET    16       1.809   1.231   0.952  1.00 61.44           C 
ATOM    260  CG  MET    16       2.342   2.314   0.024  1.00 32.01           C 
ATOM    261  SD  MET    16       1.023   3.299  -0.713  1.00 14.34           S 
ATOM    262  CE  MET    16       0.182   2.063  -1.698  1.00 60.32           C 
ATOM    263  H   MET    16       1.798  -0.084   3.458  1.00 37.79           H 
ATOM    264  HA  MET    16       3.438  -0.174   0.990  1.00 52.34           H 
ATOM    265 1HB  MET    16       1.158   1.700   1.677  1.00 37.79           H 
ATOM    266 2HB  MET    16       1.223   0.543   0.359  1.00 37.79           H 
ATOM    267 1HG  MET    16       2.910   1.846  -0.767  1.00 37.79           H 
ATOM    268 2HG  MET    16       2.988   2.970   0.590  1.00 37.79           H 
ATOM    269 1HE  MET    16      -0.194   1.283  -1.054  1.00 37.79           H 
ATOM    270 2HE  MET    16       0.873   1.639  -2.412  1.00 37.79           H 
ATOM    271 3HE  MET    16      -0.641   2.524  -2.224  1.00 37.79           H 
ATOM    272  N   GLN    17       4.824   1.972   1.665  1.00  0.22           N 
ATOM    273  CA  GLN    17       5.749   2.967   2.244  1.00 71.35           C 
ATOM    274  C   GLN    17       5.752   4.280   1.434  1.00 33.21           C 
ATOM    275  O   GLN    17       5.711   4.262   0.202  1.00 31.34           O 
ATOM    276  CB  GLN    17       7.173   2.396   2.332  1.00 33.20           C 
ATOM    277  CG  GLN    17       8.157   3.304   3.072  1.00 64.35           C 
ATOM    278  CD  GLN    17       9.541   2.691   3.223  1.00 62.11           C 
ATOM    279  OE1 GLN    17       9.994   1.921   2.384  1.00 33.21           O 
ATOM    280  NE2 GLN    17      10.226   3.031   4.299  1.00 40.53           N 
ATOM    281  H   GLN    17       4.909   1.732   0.718  1.00 37.79           H 
ATOM    282  HA  GLN    17       5.404   3.189   3.247  1.00 44.40           H 
ATOM    283 1HB  GLN    17       7.547   2.235   1.330  1.00 37.79           H 
ATOM    284 2HB  GLN    17       7.135   1.446   2.848  1.00 37.79           H 
ATOM    285 1HG  GLN    17       7.762   3.508   4.059  1.00 37.79           H 
ATOM    286 2HG  GLN    17       8.250   4.232   2.528  1.00 37.79           H 
ATOM    287 1HE2 GLN    17       9.813   3.651   4.936  1.00 37.79           H 
ATOM    288 2HE2 GLN    17      11.118   2.649   4.413  1.00 37.79           H 
ATOM    289  N   ILE    18       5.808   5.415   2.137  1.00 62.45           N 
ATOM    290  CA  ILE    18       5.784   6.742   1.494  1.00 33.54           C 
ATOM    291  C   ILE    18       7.132   7.094   0.832  1.00 44.41           C 
ATOM    292  O   ILE    18       8.168   7.141   1.497  1.00  3.42           O 
ATOM    293  CB  ILE    18       5.418   7.856   2.516  1.00  1.53           C 
ATOM    294  CG1 ILE    18       4.019   7.615   3.105  1.00  4.23           C 
ATOM    295  CG2 ILE    18       5.500   9.243   1.870  1.00 14.24           C 
ATOM    296  CD1 ILE    18       2.897   7.711   2.091  1.00 14.41           C 
ATOM    297  H   ILE    18       5.870   5.361   3.115  1.00 37.79           H 
ATOM    298  HA  ILE    18       5.018   6.723   0.730  1.00 32.21           H 
ATOM    299  HB  ILE    18       6.142   7.823   3.318  1.00 52.01           H 
ATOM    300 1HG1 ILE    18       3.829   8.346   3.878  1.00 37.79           H 
ATOM    301 2HG1 ILE    18       3.985   6.627   3.539  1.00 37.79           H 
ATOM    302 1HG2 ILE    18       5.210   9.996   2.589  1.00 37.79           H 
ATOM    303 2HG2 ILE    18       4.836   9.287   1.018  1.00 37.79           H 
ATOM    304 3HG2 ILE    18       6.513   9.432   1.543  1.00 37.79           H 
ATOM    305 1HD1 ILE    18       3.054   6.985   1.308  1.00 37.79           H 
ATOM    306 2HD1 ILE    18       2.877   8.703   1.665  1.00 37.79           H 
ATOM    307 3HD1 ILE    18       1.954   7.512   2.581  1.00 37.79           H 
ATOM    308  N   LYS    19       7.103   7.347  -0.480  1.00 71.22           N 
ATOM    309  CA  LYS    19       8.312   7.732  -1.232  1.00 22.23           C 
ATOM    310  C   LYS    19       8.320   9.236  -1.572  1.00 73.33           C 
ATOM    311  O   LYS    19       9.362   9.891  -1.514  1.00 14.43           O 
ATOM    312  CB  LYS    19       8.417   6.907  -2.527  1.00 50.21           C 
ATOM    313  CG  LYS    19       9.768   7.036  -3.230  1.00 65.40           C 
ATOM    314  CD  LYS    19       9.837   6.230  -4.533  1.00 55.10           C 
ATOM    315  CE  LYS    19       9.231   6.973  -5.724  1.00  3.52           C 
ATOM    316  NZ  LYS    19       7.780   7.247  -5.552  1.00 10.24           N 
ATOM    317  H   LYS    19       6.255   7.251  -0.957  1.00 37.79           H 
ATOM    318  HA  LYS    19       9.171   7.516  -0.611  1.00  1.44           H 
ATOM    319 1HB  LYS    19       7.644   7.228  -3.212  1.00 37.79           H 
ATOM    320 2HB  LYS    19       8.260   5.864  -2.287  1.00 37.79           H 
ATOM    321 1HG  LYS    19      10.540   6.682  -2.560  1.00 37.79           H 
ATOM    322 2HG  LYS    19       9.944   8.078  -3.457  1.00 37.79           H 
ATOM    323 1HD  LYS    19       9.307   5.297  -4.396  1.00 37.79           H 
ATOM    324 2HD  LYS    19      10.873   6.020  -4.753  1.00 37.79           H 
ATOM    325 1HE  LYS    19       9.369   6.372  -6.612  1.00 37.79           H 
ATOM    326 2HE  LYS    19       9.750   7.912  -5.848  1.00 37.79           H 
ATOM    327 1HZ  LYS    19       7.274   6.371  -5.314  1.00 37.79           H 
ATOM    328 2HZ  LYS    19       7.384   7.629  -6.435  1.00 37.79           H 
ATOM    329 3HZ  LYS    19       7.631   7.943  -4.794  1.00 37.79           H 
ATOM    359  N   THR    23       2.543  14.615  -6.920  1.00 32.03           N 
ATOM    360  CA  THR    23       2.394  13.842  -8.163  1.00 40.22           C 
ATOM    361  C   THR    23       1.090  14.204  -8.894  1.00 63.53           C 
ATOM    362  O   THR    23       0.002  14.087  -8.329  1.00 51.11           O 
ATOM    363  CB  THR    23       2.399  12.319  -7.871  1.00 14.13           C 
ATOM    364  OG1 THR    23       3.550  11.969  -7.083  1.00 72.41           O 
ATOM    365  CG2 THR    23       2.398  11.503  -9.162  1.00 53.24           C 
ATOM    366  H   THR    23       1.841  14.557  -6.238  1.00 37.79           H 
ATOM    367  HA  THR    23       3.235  14.068  -8.807  1.00 31.53           H 
ATOM    368  HB  THR    23       1.507  12.074  -7.310  1.00  2.24           H 
ATOM    369  HG1 THR    23       3.398  12.237  -6.169  1.00 11.12           H 
ATOM    370 1HG2 THR    23       3.278  11.742  -9.741  1.00 37.79           H 
ATOM    371 2HG2 THR    23       1.514  11.736  -9.737  1.00 37.79           H 
ATOM    372 3HG2 THR    23       2.402  10.449  -8.921  1.00 37.79           H 
ATOM    373  N   ILE    24       1.201  14.641 -10.151  1.00 10.44           N 
ATOM    374  CA  ILE    24       0.024  15.024 -10.949  1.00 43.51           C 
ATOM    375  C   ILE    24      -0.129  14.142 -12.200  1.00 34.25           C 
ATOM    376  O   ILE    24       0.860  13.738 -12.818  1.00 53.20           O 
ATOM    377  CB  ILE    24       0.101  16.512 -11.396  1.00 23.41           C 
ATOM    378  CG1 ILE    24       0.157  17.447 -10.172  1.00 43.53           C 
ATOM    379  CG2 ILE    24      -1.085  16.875 -12.300  1.00 14.33           C 
ATOM    380  CD1 ILE    24      -1.059  17.359  -9.269  1.00 60.21           C 
ATOM    381  H   ILE    24       2.094  14.713 -10.552  1.00 37.79           H 
ATOM    382  HA  ILE    24      -0.856  14.902 -10.330  1.00 73.21           H 
ATOM    383  HB  ILE    24       1.007  16.639 -11.974  1.00  0.51           H 
ATOM    384 1HG1 ILE    24       0.244  18.470 -10.511  1.00 37.79           H 
ATOM    385 2HG1 ILE    24       1.026  17.201  -9.576  1.00 37.79           H 
ATOM    386 1HG2 ILE    24      -2.011  16.718 -11.766  1.00 37.79           H 
ATOM    387 2HG2 ILE    24      -1.074  16.253 -13.185  1.00 37.79           H 
ATOM    388 3HG2 ILE    24      -1.011  17.913 -12.596  1.00 37.79           H 
ATOM    389 1HD1 ILE    24      -1.945  17.614  -9.832  1.00 37.79           H 
ATOM    390 2HD1 ILE    24      -0.945  18.049  -8.446  1.00 37.79           H 
ATOM    391 3HD1 ILE    24      -1.153  16.354  -8.884  1.00 37.79           H 
ATOM    392  N   GLU    25      -1.372  13.839 -12.558  1.00  1.11           N 
ATOM    393  CA  GLU    25      -1.676  13.130 -13.803  1.00 31.25           C 
ATOM    394  C   GLU    25      -2.875  13.783 -14.504  1.00 53.51           C 
ATOM    395  O   GLU    25      -3.972  13.855 -13.948  1.00 71.12           O 
ATOM    396  CB  GLU    25      -1.945  11.647 -13.522  1.00 22.10           C 
ATOM    397  CG  GLU    25      -2.101  10.803 -14.782  1.00 23.14           C 
ATOM    398  CD  GLU    25      -2.106   9.312 -14.487  1.00  4.24           C 
ATOM    399  OE1 GLU    25      -1.010   8.711 -14.404  1.00 20.25           O 
ATOM    400  OE2 GLU    25      -3.199   8.733 -14.326  1.00 52.21           O 
ATOM    401  H   GLU    25      -2.112  14.090 -11.962  1.00 37.79           H 
ATOM    402  HA  GLU    25      -0.812  13.213 -14.452  1.00 20.33           H 
ATOM    403 1HB  GLU    25      -2.852  11.558 -12.939  1.00 37.79           H 
ATOM    404 2HB  GLU    25      -1.121  11.249 -12.947  1.00 37.79           H 
ATOM    405 1HG  GLU    25      -1.279  11.021 -15.451  1.00 37.79           H 
ATOM    406 2HG  GLU    25      -3.032  11.066 -15.265  1.00 37.79           H 
ATOM    407  N   LYS    26      -2.661  14.276 -15.721  1.00 23.25           N 
ATOM    408  CA  LYS    26      -3.683  15.071 -16.408  1.00 74.20           C 
ATOM    409  C   LYS    26      -4.649  14.198 -17.237  1.00 15.21           C 
ATOM    410  O   LYS    26      -4.302  13.712 -18.318  1.00 70.15           O 
ATOM    411  CB  LYS    26      -3.022  16.125 -17.313  1.00 14.51           C 
ATOM    412  CG  LYS    26      -3.924  17.325 -17.587  1.00 65.40           C 
ATOM    413  CD  LYS    26      -3.520  18.091 -18.845  1.00 41.11           C 
ATOM    414  CE  LYS    26      -2.123  18.686 -18.738  1.00 33.21           C 
ATOM    415  NZ  LYS    26      -1.794  19.513 -19.927  1.00 11.22           N 
ATOM    416  H   LYS    26      -1.804  14.102 -16.167  1.00 37.79           H 
ATOM    417  HA  LYS    26      -4.255  15.586 -15.647  1.00 70.32           H 
ATOM    418 1HB  LYS    26      -2.765  15.667 -18.258  1.00 37.79           H 
ATOM    419 2HB  LYS    26      -2.117  16.478 -16.837  1.00 37.79           H 
ATOM    420 1HG  LYS    26      -3.871  17.998 -16.741  1.00 37.79           H 
ATOM    421 2HG  LYS    26      -4.936  16.979 -17.697  1.00 37.79           H 
ATOM    422 1HD  LYS    26      -4.229  18.893 -19.006  1.00 37.79           H 
ATOM    423 2HD  LYS    26      -3.547  17.418 -19.690  1.00 37.79           H 
ATOM    424 1HE  LYS    26      -1.405  17.883 -18.659  1.00 37.79           H 
ATOM    425 2HE  LYS    26      -2.072  19.305 -17.855  1.00 37.79           H 
ATOM    426 1HZ  LYS    26      -1.791  18.925 -20.784  1.00 37.79           H 
ATOM    427 2HZ  LYS    26      -0.858  19.947 -19.814  1.00 37.79           H 
ATOM    428 3HZ  LYS    26      -2.503  20.267 -20.042  1.00 37.79           H 
ATOM    429  N   VAL    27      -5.868  14.020 -16.730  1.00 23.40           N 
ATOM    430  CA  VAL    27      -6.905  13.242 -17.423  1.00 62.43           C 
ATOM    431  C   VAL    27      -8.067  14.153 -17.862  1.00 72.24           C 
ATOM    432  O   VAL    27      -8.495  15.025 -17.104  1.00  4.24           O 
ATOM    433  CB  VAL    27      -7.450  12.112 -16.512  1.00 53.43           C 
ATOM    434  CG1 VAL    27      -8.499  11.269 -17.235  1.00 22.24           C 
ATOM    435  CG2 VAL    27      -6.308  11.235 -15.997  1.00 74.42           C 
ATOM    436  H   VAL    27      -6.080  14.423 -15.860  1.00 37.79           H 
ATOM    437  HA  VAL    27      -6.461  12.791 -18.303  1.00 34.45           H 
ATOM    438  HB  VAL    27      -7.926  12.574 -15.657  1.00 13.30           H 
ATOM    439 1HG1 VAL    27      -8.854  10.490 -16.575  1.00 37.79           H 
ATOM    440 2HG1 VAL    27      -8.061  10.821 -18.116  1.00 37.79           H 
ATOM    441 3HG1 VAL    27      -9.329  11.896 -17.527  1.00 37.79           H 
ATOM    442 1HG2 VAL    27      -6.707  10.448 -15.373  1.00 37.79           H 
ATOM    443 2HG2 VAL    27      -5.623  11.838 -15.419  1.00 37.79           H 
ATOM    444 3HG2 VAL    27      -5.781  10.796 -16.833  1.00 37.79           H 
ATOM    445  N   ASP    28      -8.568  13.953 -19.088  1.00 24.21           N 
ATOM    446  CA  ASP    28      -9.622  14.813 -19.661  1.00 52.20           C 
ATOM    447  C   ASP    28      -9.163  16.282 -19.765  1.00 20.24           C 
ATOM    448  O   ASP    28      -9.984  17.203 -19.788  1.00 13.40           O 
ATOM    449  CB  ASP    28     -10.914  14.724 -18.830  1.00 45.33           C 
ATOM    450  CG  ASP    28     -11.663  13.415 -19.025  1.00  1.24           C 
ATOM    451  OD1 ASP    28     -12.508  13.340 -19.942  1.00 21.33           O 
ATOM    452  OD2 ASP    28     -11.431  12.463 -18.252  1.00 75.30           O 
ATOM    453  H   ASP    28      -8.226  13.203 -19.623  1.00 37.79           H 
ATOM    454  HA  ASP    28      -9.826  14.452 -20.661  1.00 23.50           H 
ATOM    455 1HB  ASP    28     -11.570  15.538 -19.110  1.00 37.79           H 
ATOM    456 2HB  ASP    28     -10.665  14.821 -17.783  1.00 37.79           H 
ATOM    457  N   GLY    29      -7.852  16.491 -19.857  1.00  1.23           N 
ATOM    458  CA  GLY    29      -7.301  17.845 -19.871  1.00 25.13           C 
ATOM    459  C   GLY    29      -7.297  18.494 -18.487  1.00 70.02           C 
ATOM    460  O   GLY    29      -7.035  19.691 -18.348  1.00 71.05           O 
ATOM    461  H   GLY    29      -7.250  15.719 -19.927  1.00 37.79           H 
ATOM    462 1HA  GLY    29      -7.888  18.457 -20.542  1.00 37.79           H 
ATOM    463 2HA  GLY    29      -6.287  17.802 -20.237  1.00 37.79           H 
ATOM    464  N   ARG    30      -7.581  17.692 -17.463  1.00 63.23           N 
ATOM    465  CA  ARG    30      -7.655  18.170 -16.078  1.00 45.05           C 
ATOM    466  C   ARG    30      -6.577  17.506 -15.203  1.00 65.51           C 
ATOM    467  O   ARG    30      -6.403  16.287 -15.230  1.00 34.34           O 
ATOM    468  CB  ARG    30      -9.054  17.883 -15.513  1.00 64.14           C 
ATOM    469  CG  ARG    30     -10.169  18.599 -16.274  1.00  1.21           C 
ATOM    470  CD  ARG    30     -11.553  18.200 -15.775  1.00 74.11           C 
ATOM    471  NE  ARG    30     -11.891  16.822 -16.127  1.00 74.13           N 
ATOM    472  CZ  ARG    30     -12.425  15.962 -15.302  1.00 33.22           C 
ATOM    473  NH1 ARG    30     -12.674  16.292 -14.076  1.00  3.02           N 
ATOM    474  NH2 ARG    30     -12.725  14.774 -15.710  1.00 24.22           N 
ATOM    475  H   ARG    30      -7.748  16.743 -17.642  1.00 37.79           H 
ATOM    476  HA  ARG    30      -7.491  19.240 -16.082  1.00 64.11           H 
ATOM    477 1HB  ARG    30      -9.087  18.205 -14.481  1.00 37.79           H 
ATOM    478 2HB  ARG    30      -9.239  16.817 -15.554  1.00 37.79           H 
ATOM    479 1HG  ARG    30     -10.091  18.350 -17.324  1.00 37.79           H 
ATOM    480 2HG  ARG    30     -10.050  19.665 -16.148  1.00 37.79           H 
ATOM    481 1HD  ARG    30     -12.286  18.862 -16.215  1.00 37.79           H 
ATOM    482 2HD  ARG    30     -11.578  18.305 -14.699  1.00 37.79           H 
ATOM    483  HE  ARG    30     -11.718  16.537 -17.045  1.00 44.31           H 
ATOM    484 1HH1 ARG    30     -12.458  17.210 -13.751  1.00 37.79           H 
ATOM    485 2HH1 ARG    30     -13.075  15.621 -13.456  1.00 37.79           H 
ATOM    486 1HH2 ARG    30     -12.544  14.509 -16.651  1.00 37.79           H 
ATOM    487 2HH2 ARG    30     -13.137  14.120 -15.074  1.00 37.79           H 
ATOM    488  N   ASN    31      -5.855  18.313 -14.432  1.00  1.22           N 
ATOM    489  CA  ASN    31      -4.756  17.813 -13.598  1.00 24.12           C 
ATOM    490  C   ASN    31      -5.276  17.154 -12.309  1.00 43.30           C 
ATOM    491  O   ASN    31      -5.799  17.829 -11.419  1.00 11.01           O 
ATOM    492  CB  ASN    31      -3.803  18.961 -13.254  1.00 25.03           C 
ATOM    493  CG  ASN    31      -3.169  19.569 -14.491  1.00  0.33           C 
ATOM    494  OD1 ASN    31      -3.727  20.468 -15.110  1.00 63.32           O 
ATOM    495  ND2 ASN    31      -2.002  19.083 -14.868  1.00 75.00           N 
ATOM    496  H   ASN    31      -6.069  19.270 -14.412  1.00 37.79           H 
ATOM    497  HA  ASN    31      -4.214  17.074 -14.173  1.00 14.35           H 
ATOM    498 1HB  ASN    31      -3.018  18.594 -12.608  1.00 37.79           H 
ATOM    499 2HB  ASN    31      -4.354  19.735 -12.738  1.00 37.79           H 
ATOM    500 1HD2 ASN    31      -1.604  18.362 -14.341  1.00 37.79           H 
ATOM    501 2HD2 ASN    31      -1.575  19.479 -15.657  1.00 37.79           H 
ATOM    502  N   LEU    32      -5.141  15.831 -12.225  1.00 74.42           N 
ATOM    503  CA  LEU    32      -5.543  15.078 -11.030  1.00 50.01           C 
ATOM    504  C   LEU    32      -4.350  14.865 -10.085  1.00 63.41           C 
ATOM    505  O   LEU    32      -3.212  14.721 -10.530  1.00 24.31           O 
ATOM    506  CB  LEU    32      -6.141  13.722 -11.433  1.00 53.15           C 
ATOM    507  CG  LEU    32      -7.352  13.794 -12.381  1.00 22.11           C 
ATOM    508  CD1 LEU    32      -7.854  12.395 -12.724  1.00 35.54           C 
ATOM    509  CD2 LEU    32      -8.474  14.633 -11.769  1.00 34.41           C 
ATOM    510  H   LEU    32      -4.767  15.343 -12.990  1.00 37.79           H 
ATOM    511  HA  LEU    32      -6.299  15.653 -10.509  1.00 74.20           H 
ATOM    512 1HB  LEU    32      -6.447  13.205 -10.533  1.00 37.79           H 
ATOM    513 2HB  LEU    32      -5.366  13.139 -11.914  1.00 37.79           H 
ATOM    514  HG  LEU    32      -7.046  14.269 -13.302  1.00 73.44           H 
ATOM    515 1HD1 LEU    32      -8.698  12.470 -13.396  1.00 37.79           H 
ATOM    516 2HD1 LEU    32      -8.159  11.887 -11.820  1.00 37.79           H 
ATOM    517 3HD1 LEU    32      -7.063  11.835 -13.202  1.00 37.79           H 
ATOM    518 1HD2 LEU    32      -8.116  15.636 -11.584  1.00 37.79           H 
ATOM    519 2HD2 LEU    32      -8.793  14.189 -10.838  1.00 37.79           H 
ATOM    520 3HD2 LEU    32      -9.311  14.672 -12.454  1.00 37.79           H 
ATOM    521  N   ARG    33      -4.617  14.855  -8.783  1.00 23.22           N 
ATOM    522  CA  ARG    33      -3.567  14.659  -7.775  1.00 62.34           C 
ATOM    523  C   ARG    33      -3.680  13.266  -7.131  1.00 41.45           C 
ATOM    524  O   ARG    33      -4.560  13.023  -6.302  1.00 55.31           O 
ATOM    525  CB  ARG    33      -3.672  15.757  -6.702  1.00  0.52           C 
ATOM    526  CG  ARG    33      -2.536  15.761  -5.681  1.00 63.32           C 
ATOM    527  CD  ARG    33      -2.727  16.864  -4.642  1.00 45.22           C 
ATOM    528  NE  ARG    33      -1.581  16.987  -3.743  1.00  0.41           N 
ATOM    529  CZ  ARG    33      -1.532  17.804  -2.724  1.00 64.12           C 
ATOM    530  NH1 ARG    33      -2.559  18.521  -2.392  1.00 31.31           N 
ATOM    531  NH2 ARG    33      -0.456  17.885  -2.021  1.00 33.22           N 
ATOM    532  H   ARG    33      -5.544  14.990  -8.485  1.00 37.79           H 
ATOM    533  HA  ARG    33      -2.607  14.740  -8.269  1.00 24.55           H 
ATOM    534 1HB  ARG    33      -4.604  15.629  -6.169  1.00 37.79           H 
ATOM    535 2HB  ARG    33      -3.683  16.719  -7.195  1.00 37.79           H 
ATOM    536 1HG  ARG    33      -1.599  15.923  -6.198  1.00 37.79           H 
ATOM    537 2HG  ARG    33      -2.509  14.805  -5.177  1.00 37.79           H 
ATOM    538 1HD  ARG    33      -3.609  16.641  -4.058  1.00 37.79           H 
ATOM    539 2HD  ARG    33      -2.869  17.804  -5.156  1.00 37.79           H 
ATOM    540  HE  ARG    33      -0.795  16.437  -3.930  1.00 73.45           H 
ATOM    541 1HH1 ARG    33      -3.405  18.456  -2.916  1.00 37.79           H 
ATOM    542 2HH1 ARG    33      -2.501  19.134  -1.608  1.00 37.79           H 
ATOM    543 1HH2 ARG    33       0.337  17.323  -2.256  1.00 37.79           H 
ATOM    544 2HH2 ARG    33      -0.410  18.511  -1.247  1.00 37.79           H 
ATOM    545  N   ASN    34      -2.787  12.354  -7.517  1.00 10.04           N 
ATOM    546  CA  ASN    34      -2.822  10.967  -7.029  1.00 60.55           C 
ATOM    547  C   ASN    34      -1.435  10.491  -6.569  1.00  4.14           C 
ATOM    548  O   ASN    34      -0.415  11.062  -6.944  1.00  5.43           O 
ATOM    549  CB  ASN    34      -3.363  10.038  -8.125  1.00 44.12           C 
ATOM    550  CG  ASN    34      -2.622  10.199  -9.441  1.00 55.23           C 
ATOM    551  OD1 ASN    34      -3.003  10.999 -10.285  1.00 41.25           O 
ATOM    552  ND2 ASN    34      -1.556   9.444  -9.632  1.00 15.13           N 
ATOM    553  H   ASN    34      -2.080  12.618  -8.145  1.00 37.79           H 
ATOM    554  HA  ASN    34      -3.493  10.931  -6.181  1.00 11.21           H 
ATOM    555 1HB  ASN    34      -4.408  10.260  -8.292  1.00 37.79           H 
ATOM    556 2HB  ASN    34      -3.269   9.011  -7.801  1.00 37.79           H 
ATOM    557 1HD2 ASN    34      -1.291   8.823  -8.926  1.00 37.79           H 
ATOM    558 2HD2 ASN    34      -1.071   9.544 -10.480  1.00 37.79           H 
ATOM    559  N   TYR    35      -1.408   9.434  -5.759  1.00 15.25           N 
ATOM    560  CA  TYR    35      -0.150   8.884  -5.231  1.00  3.43           C 
ATOM    561  C   TYR    35       0.005   7.400  -5.604  1.00 30.03           C 
ATOM    562  O   TYR    35      -0.857   6.585  -5.281  1.00 62.53           O 
ATOM    563  CB  TYR    35      -0.117   9.028  -3.701  1.00 63.03           C 
ATOM    564  CG  TYR    35      -0.377  10.440  -3.205  1.00 12.25           C 
ATOM    565  CD1 TYR    35       0.674  11.289  -2.878  1.00 33.22           C 
ATOM    566  CD2 TYR    35      -1.677  10.921  -3.066  1.00 63.23           C 
ATOM    567  CE1 TYR    35       0.436  12.573  -2.427  1.00 75.25           C 
ATOM    568  CE2 TYR    35      -1.920  12.204  -2.617  1.00 73.00           C 
ATOM    569  CZ  TYR    35      -0.861  13.025  -2.300  1.00 71.53           C 
ATOM    570  OH  TYR    35      -1.100  14.303  -1.852  1.00 55.24           O 
ATOM    571  H   TYR    35      -2.256   9.012  -5.500  1.00 37.79           H 
ATOM    572  HA  TYR    35       0.671   9.444  -5.656  1.00 61.12           H 
ATOM    573 1HB  TYR    35       0.857   8.722  -3.342  1.00 37.79           H 
ATOM    574 2HB  TYR    35      -0.869   8.383  -3.270  1.00 37.79           H 
ATOM    575  HD1 TYR    35       1.690  10.934  -2.979  1.00 35.33           H 
ATOM    576  HD2 TYR    35      -2.506  10.275  -3.315  1.00 44.14           H 
ATOM    577  HE1 TYR    35       1.266  13.219  -2.179  1.00 61.01           H 
ATOM    578  HE2 TYR    35      -2.935  12.559  -2.517  1.00 44.11           H 
ATOM    579  HH  TYR    35      -0.428  14.897  -2.208  1.00 72.13           H 
ATOM    580  N   THR    36       1.110   7.054  -6.270  1.00 22.23           N 
ATOM    581  CA  THR    36       1.389   5.657  -6.657  1.00 51.14           C 
ATOM    582  C   THR    36       2.623   5.121  -5.921  1.00 72.41           C 
ATOM    583  O   THR    36       3.748   5.569  -6.163  1.00 25.03           O 
ATOM    584  CB  THR    36       1.619   5.525  -8.185  1.00 44.31           C 
ATOM    585  OG1 THR    36       0.479   6.024  -8.906  1.00  3.35           O 
ATOM    586  CG2 THR    36       1.874   4.072  -8.588  1.00 72.20           C 
ATOM    587  H   THR    36       1.756   7.751  -6.511  1.00 37.79           H 
ATOM    588  HA  THR    36       0.531   5.053  -6.390  1.00 55.14           H 
ATOM    589  HB  THR    36       2.486   6.113  -8.456  1.00 15.33           H 
ATOM    590  HG1 THR    36      -0.252   5.399  -8.820  1.00 22.04           H 
ATOM    591 1HG2 THR    36       1.035   3.461  -8.289  1.00 37.79           H 
ATOM    592 2HG2 THR    36       2.771   3.714  -8.103  1.00 37.79           H 
ATOM    593 3HG2 THR    36       1.998   4.011  -9.660  1.00 37.79           H 
ATOM    594  N   LEU    37       2.416   4.162  -5.026  1.00 70.25           N 
ATOM    595  CA  LEU    37       3.502   3.641  -4.187  1.00 40.24           C 
ATOM    596  C   LEU    37       3.529   2.100  -4.162  1.00 10.10           C 
ATOM    597  O   LEU    37       2.503   1.444  -4.367  1.00 75.41           O 
ATOM    598  CB  LEU    37       3.359   4.184  -2.758  1.00 13.44           C 
ATOM    599  CG  LEU    37       3.492   5.710  -2.607  1.00 33.22           C 
ATOM    600  CD1 LEU    37       3.225   6.140  -1.168  1.00 74.33           C 
ATOM    601  CD2 LEU    37       4.873   6.172  -3.056  1.00 22.54           C 
ATOM    602  H   LEU    37       1.511   3.790  -4.924  1.00 37.79           H 
ATOM    603  HA  LEU    37       4.436   3.994  -4.600  1.00 20.12           H 
ATOM    604 1HB  LEU    37       4.116   3.718  -2.143  1.00 37.79           H 
ATOM    605 2HB  LEU    37       2.388   3.891  -2.384  1.00 37.79           H 
ATOM    606  HG  LEU    37       2.758   6.193  -3.238  1.00  3.32           H 
ATOM    607 1HD1 LEU    37       2.228   5.839  -0.880  1.00 37.79           H 
ATOM    608 2HD1 LEU    37       3.310   7.215  -1.089  1.00 37.79           H 
ATOM    609 3HD1 LEU    37       3.945   5.673  -0.510  1.00 37.79           H 
ATOM    610 1HD2 LEU    37       4.951   7.243  -2.936  1.00 37.79           H 
ATOM    611 2HD2 LEU    37       5.016   5.918  -4.096  1.00 37.79           H 
ATOM    612 3HD2 LEU    37       5.630   5.686  -2.459  1.00 37.79           H 
ATOM    613  N   PRO    38       4.717   1.502  -3.917  1.00 45.52           N 
ATOM    614  CA  PRO    38       4.864   0.044  -3.793  1.00 72.33           C 
ATOM    615  C   PRO    38       4.266  -0.500  -2.484  1.00 23.45           C 
ATOM    616  O   PRO    38       4.337   0.143  -1.434  1.00 11.12           O 
ATOM    617  CB  PRO    38       6.393  -0.179  -3.822  1.00 10.41           C 
ATOM    618  CG  PRO    38       6.988   1.140  -4.208  1.00 72.03           C 
ATOM    619  CD  PRO    38       6.009   2.186  -3.755  1.00  0.25           C 
ATOM    620  HA  PRO    38       4.407  -0.467  -4.630  1.00 23.21           H 
ATOM    621 1HB  PRO    38       6.631  -0.943  -4.548  1.00 37.79           H 
ATOM    622 2HB  PRO    38       6.736  -0.495  -2.845  1.00 37.79           H 
ATOM    623 1HG  PRO    38       7.118   1.187  -5.280  1.00 37.79           H 
ATOM    624 2HG  PRO    38       7.940   1.276  -3.711  1.00 37.79           H 
ATOM    625 1HD  PRO    38       6.066   3.062  -4.386  1.00 37.79           H 
ATOM    626 2HD  PRO    38       6.184   2.450  -2.721  1.00 37.79           H 
ATOM    627  N   ALA    39       3.684  -1.691  -2.550  1.00 72.41           N 
ATOM    628  CA  ALA    39       3.067  -2.316  -1.380  1.00 65.43           C 
ATOM    629  C   ALA    39       3.434  -3.804  -1.272  1.00 60.21           C 
ATOM    630  O   ALA    39       4.017  -4.379  -2.184  1.00  2.30           O 
ATOM    631  CB  ALA    39       1.552  -2.146  -1.436  1.00 22.12           C 
ATOM    632  H   ALA    39       3.669  -2.165  -3.406  1.00 37.79           H 
ATOM    633  HA  ALA    39       3.429  -1.805  -0.498  1.00 43.35           H 
ATOM    634 1HB  ALA    39       1.157  -2.695  -2.280  1.00 37.79           H 
ATOM    635 2HB  ALA    39       1.310  -1.100  -1.545  1.00 37.79           H 
ATOM    636 3HB  ALA    39       1.111  -2.523  -0.523  1.00 37.79           H 
ATOM    637  N   TYR    40       3.103  -4.410  -0.139  1.00  4.15           N 
ATOM    638  CA  TYR    40       3.288  -5.850   0.074  1.00 14.44           C 
ATOM    639  C   TYR    40       2.104  -6.416   0.866  1.00 55.05           C 
ATOM    640  O   TYR    40       1.624  -5.782   1.804  1.00 30.21           O 
ATOM    641  CB  TYR    40       4.591  -6.133   0.843  1.00 74.11           C 
ATOM    642  CG  TYR    40       5.861  -5.700   0.127  1.00 71.00           C 
ATOM    643  CD1 TYR    40       6.502  -6.545  -0.771  1.00  5.20           C 
ATOM    644  CD2 TYR    40       6.424  -4.449   0.360  1.00 44.35           C 
ATOM    645  CE1 TYR    40       7.665  -6.158  -1.411  1.00 70.40           C 
ATOM    646  CE2 TYR    40       7.583  -4.055  -0.279  1.00  3.13           C 
ATOM    647  CZ  TYR    40       8.200  -4.913  -1.163  1.00 63.23           C 
ATOM    648  OH  TYR    40       9.362  -4.525  -1.795  1.00  0.11           O 
ATOM    649  H   TYR    40       2.729  -3.873   0.589  1.00 37.79           H 
ATOM    650  HA  TYR    40       3.330  -6.333  -0.893  1.00 12.13           H 
ATOM    651 1HB  TYR    40       4.663  -7.196   1.028  1.00 37.79           H 
ATOM    652 2HB  TYR    40       4.558  -5.616   1.792  1.00 37.79           H 
ATOM    653  HD1 TYR    40       6.081  -7.521  -0.966  1.00 34.11           H 
ATOM    654  HD2 TYR    40       5.939  -3.777   1.052  1.00  3.43           H 
ATOM    655  HE1 TYR    40       8.148  -6.831  -2.106  1.00 64.21           H 
ATOM    656  HE2 TYR    40       8.002  -3.079  -0.082  1.00 63.34           H 
ATOM    657  HH  TYR    40       9.992  -4.201  -1.134  1.00 52.13           H 
ATOM    658  N   ASP    41       1.621  -7.596   0.488  1.00 62.41           N 
ATOM    659  CA  ASP    41       0.554  -8.257   1.249  1.00 12.34           C 
ATOM    660  C   ASP    41       1.129  -8.976   2.482  1.00 40.34           C 
ATOM    661  O   ASP    41       2.339  -8.955   2.711  1.00 41.12           O 
ATOM    662  CB  ASP    41      -0.205  -9.243   0.355  1.00  0.33           C 
ATOM    663  CG  ASP    41       0.729 -10.207  -0.345  1.00 44.31           C 
ATOM    664  OD1 ASP    41       1.129  -9.917  -1.488  1.00 64.42           O 
ATOM    665  OD2 ASP    41       1.079 -11.246   0.251  1.00 21.52           O 
ATOM    666  H   ASP    41       1.986  -8.036  -0.312  1.00 37.79           H 
ATOM    667  HA  ASP    41      -0.133  -7.490   1.588  1.00 23.42           H 
ATOM    668 1HB  ASP    41      -0.760  -8.693  -0.393  1.00 37.79           H 
ATOM    669 2HB  ASP    41      -0.898  -9.812   0.961  1.00 37.79           H 
ATOM    670  N   GLU    42       0.264  -9.619   3.265  1.00 33.43           N 
ATOM    671  CA  GLU    42       0.686 -10.302   4.497  1.00 30.03           C 
ATOM    672  C   GLU    42       1.770 -11.373   4.238  1.00 44.33           C 
ATOM    673  O   GLU    42       2.614 -11.632   5.101  1.00  1.33           O 
ATOM    674  CB  GLU    42      -0.529 -10.929   5.199  1.00 31.13           C 
ATOM    675  CG  GLU    42      -0.197 -11.581   6.539  1.00 41.33           C 
ATOM    676  CD  GLU    42      -1.431 -12.061   7.288  1.00 40.40           C 
ATOM    677  OE1 GLU    42      -1.845 -11.389   8.255  1.00 71.24           O 
ATOM    678  OE2 GLU    42      -1.990 -13.113   6.913  1.00  3.14           O 
ATOM    679  H   GLU    42      -0.684  -9.624   3.020  1.00 37.79           H 
ATOM    680  HA  GLU    42       1.108  -9.551   5.152  1.00 54.42           H 
ATOM    681 1HB  GLU    42      -0.958 -11.681   4.552  1.00 37.79           H 
ATOM    682 2HB  GLU    42      -1.265 -10.156   5.373  1.00 37.79           H 
ATOM    683 1HG  GLU    42       0.324 -10.859   7.154  1.00 37.79           H 
ATOM    684 2HG  GLU    42       0.450 -12.429   6.362  1.00 37.79           H 
ATOM    685  N   ASP    43       1.760 -11.981   3.051  1.00 10.21           N 
ATOM    686  CA  ASP    43       2.767 -12.993   2.700  1.00 33.34           C 
ATOM    687  C   ASP    43       4.076 -12.326   2.227  1.00 40.05           C 
ATOM    688  O   ASP    43       5.127 -12.968   2.153  1.00 61.13           O 
ATOM    689  CB  ASP    43       2.217 -13.940   1.623  1.00 11.54           C 
ATOM    690  CG  ASP    43       3.161 -15.093   1.316  1.00 51.55           C 
ATOM    691  OD1 ASP    43       3.563 -15.803   2.261  1.00 45.42           O 
ATOM    692  OD2 ASP    43       3.492 -15.308   0.129  1.00 43.34           O 
ATOM    693  H   ASP    43       1.073 -11.743   2.394  1.00 37.79           H 
ATOM    694  HA  ASP    43       2.979 -13.567   3.593  1.00 20.33           H 
ATOM    695 1HB  ASP    43       2.049 -13.380   0.713  1.00 37.79           H 
ATOM    696 2HB  ASP    43       1.277 -14.352   1.962  1.00 37.79           H 
ATOM    697  N   GLY    44       4.004 -11.035   1.912  1.00 12.42           N 
ATOM    698  CA  GLY    44       5.191 -10.275   1.530  1.00 42.21           C 
ATOM    699  C   GLY    44       5.411 -10.188   0.022  1.00 44.44           C 
ATOM    700  O   GLY    44       6.471  -9.749  -0.430  1.00 65.25           O 
ATOM    701  H   GLY    44       3.132 -10.587   1.946  1.00 37.79           H 
ATOM    702 1HA  GLY    44       6.059 -10.735   1.980  1.00 37.79           H 
ATOM    703 2HA  GLY    44       5.095  -9.272   1.919  1.00 37.79           H 
ATOM    704  N   VAL    45       4.420 -10.600  -0.765  1.00 43.22           N 
ATOM    705  CA  VAL    45       4.533 -10.536  -2.227  1.00  2.11           C 
ATOM    706  C   VAL    45       4.348  -9.093  -2.724  1.00  0.42           C 
ATOM    707  O   VAL    45       3.403  -8.407  -2.331  1.00 64.13           O 
ATOM    708  CB  VAL    45       3.504 -11.462  -2.920  1.00 34.25           C 
ATOM    709  CG1 VAL    45       3.731 -11.503  -4.430  1.00 53.21           C 
ATOM    710  CG2 VAL    45       3.555 -12.864  -2.319  1.00 25.44           C 
ATOM    711  H   VAL    45       3.598 -10.949  -0.359  1.00 37.79           H 
ATOM    712  HA  VAL    45       5.528 -10.874  -2.496  1.00 53.41           H 
ATOM    713  HB  VAL    45       2.516 -11.059  -2.743  1.00 55.33           H 
ATOM    714 1HG1 VAL    45       3.597 -10.513  -4.841  1.00 37.79           H 
ATOM    715 2HG1 VAL    45       3.019 -12.179  -4.884  1.00 37.79           H 
ATOM    716 3HG1 VAL    45       4.734 -11.846  -4.637  1.00 37.79           H 
ATOM    717 1HG2 VAL    45       4.545 -13.276  -2.443  1.00 37.79           H 
ATOM    718 2HG2 VAL    45       2.836 -13.498  -2.820  1.00 37.79           H 
ATOM    719 3HG2 VAL    45       3.314 -12.813  -1.266  1.00 37.79           H 
ATOM    720  N   LYS    46       5.247  -8.640  -3.596  1.00 54.35           N 
ATOM    721  CA  LYS    46       5.262  -7.241  -4.027  1.00 10.30           C 
ATOM    722  C   LYS    46       3.981  -6.838  -4.779  1.00  5.11           C 
ATOM    723  O   LYS    46       3.448  -7.593  -5.594  1.00 22.04           O 
ATOM    724  CB  LYS    46       6.490  -6.958  -4.898  1.00 70.52           C 
ATOM    725  CG  LYS    46       6.629  -5.487  -5.273  1.00 32.21           C 
ATOM    726  CD  LYS    46       7.899  -5.207  -6.068  1.00 52.33           C 
ATOM    727  CE  LYS    46       8.023  -3.728  -6.407  1.00 24.42           C 
ATOM    728  NZ  LYS    46       9.285  -3.420  -7.127  1.00 32.13           N 
ATOM    729  H   LYS    46       5.913  -9.259  -3.959  1.00 37.79           H 
ATOM    730  HA  LYS    46       5.335  -6.635  -3.134  1.00 55.44           H 
ATOM    731 1HB  LYS    46       6.412  -7.534  -5.808  1.00 37.79           H 
ATOM    732 2HB  LYS    46       7.380  -7.264  -4.363  1.00 37.79           H 
ATOM    733 1HG  LYS    46       6.643  -4.896  -4.367  1.00 37.79           H 
ATOM    734 2HG  LYS    46       5.775  -5.199  -5.873  1.00 37.79           H 
ATOM    735 1HD  LYS    46       7.870  -5.774  -6.988  1.00 37.79           H 
ATOM    736 2HD  LYS    46       8.758  -5.508  -5.484  1.00 37.79           H 
ATOM    737 1HE  LYS    46       7.992  -3.155  -5.491  1.00 37.79           H 
ATOM    738 2HE  LYS    46       7.189  -3.444  -7.033  1.00 37.79           H 
ATOM    739 1HZ  LYS    46      10.105  -3.689  -6.547  1.00 37.79           H 
ATOM    740 2HZ  LYS    46       9.341  -2.403  -7.337  1.00 37.79           H 
ATOM    741 3HZ  LYS    46       9.321  -3.945  -8.021  1.00 37.79           H 
ATOM    742  N   LYS    47       3.507  -5.633  -4.485  1.00 65.11           N 
ATOM    743  CA  LYS    47       2.312  -5.055  -5.106  1.00 12.42           C 
ATOM    744  C   LYS    47       2.574  -3.587  -5.473  1.00 60.21           C 
ATOM    745  O   LYS    47       3.574  -3.002  -5.049  1.00 74.33           O 
ATOM    746  CB  LYS    47       1.117  -5.133  -4.136  1.00  2.20           C 
ATOM    747  CG  LYS    47       0.718  -6.551  -3.730  1.00 54.23           C 
ATOM    748  CD  LYS    47       0.148  -7.342  -4.903  1.00 44.32           C 
ATOM    749  CE  LYS    47      -0.235  -8.762  -4.495  1.00 52.11           C 
ATOM    750  NZ  LYS    47       0.940  -9.549  -4.035  1.00 24.05           N 
ATOM    751  H   LYS    47       3.986  -5.098  -3.821  1.00 37.79           H 
ATOM    752  HA  LYS    47       2.084  -5.609  -6.005  1.00 25.00           H 
ATOM    753 1HB  LYS    47       0.261  -4.660  -4.600  1.00 37.79           H 
ATOM    754 2HB  LYS    47       1.368  -4.588  -3.236  1.00 37.79           H 
ATOM    755 1HG  LYS    47      -0.029  -6.494  -2.949  1.00 37.79           H 
ATOM    756 2HG  LYS    47       1.592  -7.066  -3.354  1.00 37.79           H 
ATOM    757 1HD  LYS    47       0.891  -7.390  -5.688  1.00 37.79           H 
ATOM    758 2HD  LYS    47      -0.733  -6.835  -5.273  1.00 37.79           H 
ATOM    759 1HE  LYS    47      -0.679  -9.261  -5.347  1.00 37.79           H 
ATOM    760 2HE  LYS    47      -0.958  -8.712  -3.694  1.00 37.79           H 
ATOM    761 1HZ  LYS    47       1.355  -9.114  -3.181  1.00 37.79           H 
ATOM    762 2HZ  LYS    47       1.663  -9.584  -4.779  1.00 37.79           H 
ATOM    763 3HZ  LYS    47       0.651 -10.520  -3.803  1.00 37.79           H 
ATOM    764  N   GLN    48       1.687  -2.994  -6.262  1.00 41.13           N 
ATOM    765  CA  GLN    48       1.772  -1.563  -6.575  1.00 14.12           C 
ATOM    766  C   GLN    48       0.375  -0.925  -6.557  1.00 12.32           C 
ATOM    767  O   GLN    48      -0.478  -1.255  -7.380  1.00  3.41           O 
ATOM    768  CB  GLN    48       2.450  -1.343  -7.935  1.00 72.20           C 
ATOM    769  CG  GLN    48       2.762   0.122  -8.229  1.00 42.23           C 
ATOM    770  CD  GLN    48       3.547   0.309  -9.513  1.00 13.05           C 
ATOM    771  OE1 GLN    48       4.777   0.300  -9.512  1.00 73.54           O 
ATOM    772  NE2 GLN    48       2.849   0.479 -10.616  1.00 31.21           N 
ATOM    773  H   GLN    48       0.958  -3.527  -6.648  1.00 37.79           H 
ATOM    774  HA  GLN    48       2.374  -1.094  -5.806  1.00 52.12           H 
ATOM    775 1HB  GLN    48       1.800  -1.716  -8.714  1.00 37.79           H 
ATOM    776 2HB  GLN    48       3.377  -1.900  -7.957  1.00 37.79           H 
ATOM    777 1HG  GLN    48       3.339   0.527  -7.410  1.00 37.79           H 
ATOM    778 2HG  GLN    48       1.831   0.666  -8.312  1.00 37.79           H 
ATOM    779 1HE2 GLN    48       1.875   0.470 -10.553  1.00 37.79           H 
ATOM    780 2HE2 GLN    48       3.339   0.619 -11.452  1.00 37.79           H 
ATOM    781  N   ILE    49       0.146  -0.011  -5.615  1.00 63.01           N 
ATOM    782  CA  ILE    49      -1.192   0.556  -5.398  1.00 42.34           C 
ATOM    783  C   ILE    49      -1.189   2.093  -5.480  1.00 34.32           C 
ATOM    784  O   ILE    49      -0.243   2.753  -5.045  1.00 62.45           O 
ATOM    785  CB  ILE    49      -1.758   0.108  -4.020  1.00 22.44           C 
ATOM    786  CG1 ILE    49      -1.835  -1.429  -3.946  1.00 34.13           C 
ATOM    787  CG2 ILE    49      -3.131   0.734  -3.753  1.00 42.50           C 
ATOM    788  CD1 ILE    49      -2.295  -1.962  -2.604  1.00 41.43           C 
ATOM    789  H   ILE    49       0.894   0.298  -5.057  1.00 37.79           H 
ATOM    790  HA  ILE    49      -1.847   0.171  -6.171  1.00 72.51           H 
ATOM    791  HB  ILE    49      -1.081   0.458  -3.254  1.00 74.33           H 
ATOM    792 1HG1 ILE    49      -0.855  -1.840  -4.145  1.00 37.79           H 
ATOM    793 2HG1 ILE    49      -2.526  -1.786  -4.694  1.00 37.79           H 
ATOM    794 1HG2 ILE    49      -3.499   0.399  -2.795  1.00 37.79           H 
ATOM    795 2HG2 ILE    49      -3.823   0.438  -4.528  1.00 37.79           H 
ATOM    796 3HG2 ILE    49      -3.042   1.812  -3.745  1.00 37.79           H 
ATOM    797 1HD1 ILE    49      -1.606  -1.646  -1.834  1.00 37.79           H 
ATOM    798 2HD1 ILE    49      -2.324  -3.041  -2.638  1.00 37.79           H 
ATOM    799 3HD1 ILE    49      -3.282  -1.582  -2.382  1.00 37.79           H 
ATOM    800  N   THR    50      -2.260   2.650  -6.049  1.00 12.32           N 
ATOM    801  CA  THR    50      -2.417   4.108  -6.182  1.00 23.40           C 
ATOM    802  C   THR    50      -3.593   4.624  -5.336  1.00 43.22           C 
ATOM    803  O   THR    50      -4.733   4.196  -5.519  1.00  1.20           O 
ATOM    804  CB  THR    50      -2.647   4.521  -7.662  1.00 13.23           C 
ATOM    805  OG1 THR    50      -1.533   4.108  -8.468  1.00 53.32           O 
ATOM    806  CG2 THR    50      -2.837   6.033  -7.801  1.00 70.42           C 
ATOM    807  H   THR    50      -2.967   2.066  -6.393  1.00 37.79           H 
ATOM    808  HA  THR    50      -1.505   4.578  -5.837  1.00 33.34           H 
ATOM    809  HB  THR    50      -3.540   4.027  -8.023  1.00 52.11           H 
ATOM    810  HG1 THR    50      -1.832   3.953  -9.375  1.00 21.21           H 
ATOM    811 1HG2 THR    50      -2.995   6.283  -8.842  1.00 37.79           H 
ATOM    812 2HG2 THR    50      -1.957   6.544  -7.440  1.00 37.79           H 
ATOM    813 3HG2 THR    50      -3.695   6.342  -7.222  1.00 37.79           H 
ATOM    814  N   PHE    51      -3.313   5.548  -4.417  1.00 61.31           N 
ATOM    815  CA  PHE    51      -4.349   6.121  -3.544  1.00 61.02           C 
ATOM    816  C   PHE    51      -4.439   7.651  -3.699  1.00  3.32           C 
ATOM    817  O   PHE    51      -3.613   8.272  -4.370  1.00 14.14           O 
ATOM    818  CB  PHE    51      -4.083   5.752  -2.072  1.00  2.33           C 
ATOM    819  CG  PHE    51      -2.799   6.319  -1.506  1.00 44.42           C 
ATOM    820  CD1 PHE    51      -1.578   5.704  -1.753  1.00 41.41           C 
ATOM    821  CD2 PHE    51      -2.818   7.465  -0.719  1.00 23.55           C 
ATOM    822  CE1 PHE    51      -0.407   6.223  -1.232  1.00 12.42           C 
ATOM    823  CE2 PHE    51      -1.649   7.986  -0.197  1.00 30.20           C 
ATOM    824  CZ  PHE    51      -0.444   7.364  -0.452  1.00 12.21           C 
ATOM    825  H   PHE    51      -2.387   5.859  -4.324  1.00 37.79           H 
ATOM    826  HA  PHE    51      -5.299   5.697  -3.839  1.00 75.34           H 
ATOM    827 1HB  PHE    51      -4.039   4.675  -1.984  1.00 37.79           H 
ATOM    828 2HB  PHE    51      -4.901   6.117  -1.466  1.00 37.79           H 
ATOM    829  HD1 PHE    51      -1.547   4.812  -2.363  1.00 53.43           H 
ATOM    830  HD2 PHE    51      -3.761   7.954  -0.517  1.00 71.12           H 
ATOM    831  HE1 PHE    51       0.535   5.734  -1.430  1.00 24.20           H 
ATOM    832  HE2 PHE    51      -1.679   8.879   0.411  1.00 10.11           H 
ATOM    833  HZ  PHE    51       0.471   7.770  -0.044  1.00 51.34           H 
ATOM    834  N   ARG    52      -5.451   8.250  -3.073  1.00 14.43           N 
ATOM    835  CA  ARG    52      -5.648   9.703  -3.126  1.00 61.04           C 
ATOM    836  C   ARG    52      -6.253  10.226  -1.813  1.00 60.55           C 
ATOM    837  O   ARG    52      -6.974   9.505  -1.120  1.00 50.23           O 
ATOM    838  CB  ARG    52      -6.553  10.078  -4.314  1.00 11.20           C 
ATOM    839  CG  ARG    52      -6.758  11.583  -4.487  1.00 12.44           C 
ATOM    840  CD  ARG    52      -7.656  11.902  -5.677  1.00 33.42           C 
ATOM    841  NE  ARG    52      -8.997  11.343  -5.518  1.00 12.14           N 
ATOM    842  CZ  ARG    52      -9.762  10.979  -6.509  1.00 71.40           C 
ATOM    843  NH1 ARG    52      -9.366  11.120  -7.735  1.00  2.21           N 
ATOM    844  NH2 ARG    52     -10.926  10.479  -6.271  1.00 34.31           N 
ATOM    845  H   ARG    52      -6.080   7.704  -2.560  1.00 37.79           H 
ATOM    846  HA  ARG    52      -4.680  10.165  -3.264  1.00 31.44           H 
ATOM    847 1HB  ARG    52      -7.521   9.617  -4.174  1.00 37.79           H 
ATOM    848 2HB  ARG    52      -6.110   9.692  -5.221  1.00 37.79           H 
ATOM    849 1HG  ARG    52      -5.796  12.053  -4.638  1.00 37.79           H 
ATOM    850 2HG  ARG    52      -7.214  11.979  -3.591  1.00 37.79           H 
ATOM    851 1HD  ARG    52      -7.206  11.491  -6.572  1.00 37.79           H 
ATOM    852 2HD  ARG    52      -7.734  12.976  -5.778  1.00 37.79           H 
ATOM    853  HE  ARG    52      -9.341  11.240  -4.606  1.00 63.42           H 
ATOM    854 1HH1 ARG    52      -8.474  11.510  -7.927  1.00 37.79           H 
ATOM    855 2HH1 ARG    52      -9.964  10.845  -8.487  1.00 37.79           H 
ATOM    856 1HH2 ARG    52     -11.241  10.374  -5.331  1.00 37.79           H 
ATOM    857 2HH2 ARG    52     -11.512  10.199  -7.031  1.00 37.79           H 
ATOM   1084  N   ALA    66       7.886   6.509   6.773  1.00 33.30           N 
ATOM   1085  CA  ALA    66       6.896   5.734   7.524  1.00 61.21           C 
ATOM   1086  C   ALA    66       6.144   4.745   6.622  1.00 32.42           C 
ATOM   1087  O   ALA    66       6.234   4.807   5.393  1.00 74.34           O 
ATOM   1088  CB  ALA    66       5.910   6.673   8.214  1.00 33.23           C 
ATOM   1089  H   ALA    66       7.704   7.454   6.597  1.00 37.79           H 
ATOM   1090  HA  ALA    66       7.418   5.179   8.290  1.00 21.04           H 
ATOM   1091 1HB  ALA    66       6.449   7.363   8.846  1.00 37.79           H 
ATOM   1092 2HB  ALA    66       5.221   6.097   8.817  1.00 37.79           H 
ATOM   1093 3HB  ALA    66       5.358   7.227   7.468  1.00 37.79           H 
ATOM   1094  N   PHE    67       5.385   3.847   7.242  1.00 24.01           N 
ATOM   1095  CA  PHE    67       4.688   2.787   6.514  1.00 25.55           C 
ATOM   1096  C   PHE    67       3.168   3.004   6.510  1.00 55.04           C 
ATOM   1097  O   PHE    67       2.639   3.845   7.236  1.00 71.21           O 
ATOM   1098  CB  PHE    67       5.033   1.423   7.125  1.00 72.14           C 
ATOM   1099  CG  PHE    67       6.517   1.142   7.151  1.00 61.03           C 
ATOM   1100  CD1 PHE    67       7.147   0.552   6.063  1.00  1.43           C 
ATOM   1101  CD2 PHE    67       7.284   1.478   8.258  1.00 21.24           C 
ATOM   1102  CE1 PHE    67       8.507   0.304   6.080  1.00 42.30           C 
ATOM   1103  CE2 PHE    67       8.644   1.230   8.279  1.00 14.12           C 
ATOM   1104  CZ  PHE    67       9.256   0.642   7.189  1.00 50.14           C 
ATOM   1105  H   PHE    67       5.279   3.903   8.215  1.00 37.79           H 
ATOM   1106  HA  PHE    67       5.039   2.803   5.491  1.00 73.32           H 
ATOM   1107 1HB  PHE    67       4.555   0.641   6.548  1.00 37.79           H 
ATOM   1108 2HB  PHE    67       4.667   1.386   8.141  1.00 37.79           H 
ATOM   1109  HD1 PHE    67       6.564   0.284   5.194  1.00  0.25           H 
ATOM   1110  HD2 PHE    67       6.808   1.938   9.112  1.00 22.25           H 
ATOM   1111  HE1 PHE    67       8.983  -0.155   5.225  1.00  1.04           H 
ATOM   1112  HE2 PHE    67       9.227   1.495   9.147  1.00 75.12           H 
ATOM   1113  HZ  PHE    67      10.319   0.447   7.204  1.00 74.31           H 
ATOM   1114  N   LEU    68       2.478   2.231   5.683  1.00 35.22           N 
ATOM   1115  CA  LEU    68       1.029   2.328   5.527  1.00 15.24           C 
ATOM   1116  C   LEU    68       0.387   0.939   5.574  1.00 62.43           C 
ATOM   1117  O   LEU    68       1.025  -0.068   5.270  1.00  2.30           O 
ATOM   1118  CB  LEU    68       0.661   3.011   4.198  1.00 72.32           C 
ATOM   1119  CG  LEU    68       1.066   4.487   4.065  1.00  0.21           C 
ATOM   1120  CD1 LEU    68       0.669   5.028   2.693  1.00 24.04           C 
ATOM   1121  CD2 LEU    68       0.438   5.325   5.176  1.00 44.23           C 
ATOM   1122  H   LEU    68       2.958   1.555   5.171  1.00 37.79           H 
ATOM   1123  HA  LEU    68       0.641   2.919   6.347  1.00 44.13           H 
ATOM   1124 1HB  LEU    68      -0.412   2.943   4.069  1.00 37.79           H 
ATOM   1125 2HB  LEU    68       1.133   2.459   3.397  1.00 37.79           H 
ATOM   1126  HG  LEU    68       2.141   4.566   4.153  1.00 14.14           H 
ATOM   1127 1HD1 LEU    68       1.167   4.457   1.923  1.00 37.79           H 
ATOM   1128 2HD1 LEU    68       0.962   6.065   2.617  1.00 37.79           H 
ATOM   1129 3HD1 LEU    68      -0.401   4.946   2.566  1.00 37.79           H 
ATOM   1130 1HD2 LEU    68      -0.639   5.257   5.118  1.00 37.79           H 
ATOM   1131 2HD2 LEU    68       0.741   6.356   5.066  1.00 37.79           H 
ATOM   1132 3HD2 LEU    68       0.769   4.956   6.136  1.00 37.79           H 
ATOM   1133  N   ARG    69      -0.881   0.906   5.939  1.00 72.04           N 
ATOM   1134  CA  ARG    69      -1.646  -0.331   6.041  1.00 31.20           C 
ATOM   1135  C   ARG    69      -2.964  -0.175   5.274  1.00 32.31           C 
ATOM   1136  O   ARG    69      -3.812   0.630   5.647  1.00 22.14           O 
ATOM   1137  CB  ARG    69      -1.899  -0.600   7.530  1.00 41.14           C 
ATOM   1138  CG  ARG    69      -2.595  -1.915   7.863  1.00 34.12           C 
ATOM   1139  CD  ARG    69      -2.746  -2.052   9.373  1.00 73.44           C 
ATOM   1140  NE  ARG    69      -3.442  -3.266   9.785  1.00 34.12           N 
ATOM   1141  CZ  ARG    69      -3.940  -3.428  10.981  1.00 45.14           C 
ATOM   1142  NH1 ARG    69      -3.904  -2.460  11.843  1.00 23.24           N 
ATOM   1143  NH2 ARG    69      -4.503  -4.544  11.308  1.00 21.24           N 
ATOM   1144  H   ARG    69      -1.323   1.748   6.155  1.00 37.79           H 
ATOM   1145  HA  ARG    69      -1.067  -1.140   5.616  1.00 13.24           H 
ATOM   1146 1HB  ARG    69      -2.505   0.207   7.923  1.00 37.79           H 
ATOM   1147 2HB  ARG    69      -0.949  -0.593   8.044  1.00 37.79           H 
ATOM   1148 1HG  ARG    69      -2.002  -2.737   7.489  1.00 37.79           H 
ATOM   1149 2HG  ARG    69      -3.574  -1.926   7.403  1.00 37.79           H 
ATOM   1150 1HD  ARG    69      -3.297  -1.194   9.739  1.00 37.79           H 
ATOM   1151 2HD  ARG    69      -1.762  -2.053   9.818  1.00 37.79           H 
ATOM   1152  HE  ARG    69      -3.515  -3.994   9.142  1.00  1.31           H 
ATOM   1153 1HH1 ARG    69      -3.496  -1.580  11.593  1.00 37.79           H 
ATOM   1154 2HH1 ARG    69      -4.278  -2.594  12.758  1.00 37.79           H 
ATOM   1155 1HH2 ARG    69      -4.560  -5.290  10.647  1.00 37.79           H 
ATOM   1156 2HH2 ARG    69      -4.878  -4.659  12.224  1.00 37.79           H 
ATOM   1157  N   LEU    70      -3.132  -0.943   4.204  1.00 20.55           N 
ATOM   1158  CA  LEU    70      -4.292  -0.796   3.320  1.00 33.33           C 
ATOM   1159  C   LEU    70      -5.294  -1.938   3.514  1.00 12.31           C 
ATOM   1160  O   LEU    70      -4.933  -3.118   3.489  1.00 73.23           O 
ATOM   1161  CB  LEU    70      -3.854  -0.723   1.842  1.00 62.21           C 
ATOM   1162  CG  LEU    70      -3.135   0.575   1.407  1.00 75.23           C 
ATOM   1163  CD1 LEU    70      -1.827   0.781   2.170  1.00 73.03           C 
ATOM   1164  CD2 LEU    70      -2.881   0.569  -0.097  1.00 15.32           C 
ATOM   1165  H   LEU    70      -2.464  -1.628   4.001  1.00 37.79           H 
ATOM   1166  HA  LEU    70      -4.783   0.134   3.578  1.00  3.31           H 
ATOM   1167 1HB  LEU    70      -4.733  -0.842   1.223  1.00 37.79           H 
ATOM   1168 2HB  LEU    70      -3.190  -1.554   1.650  1.00 37.79           H 
ATOM   1169  HG  LEU    70      -3.777   1.417   1.627  1.00  5.31           H 
ATOM   1170 1HD1 LEU    70      -1.176  -0.066   2.009  1.00 37.79           H 
ATOM   1171 2HD1 LEU    70      -2.036   0.878   3.225  1.00 37.79           H 
ATOM   1172 3HD1 LEU    70      -1.339   1.680   1.818  1.00 37.79           H 
ATOM   1173 1HD2 LEU    70      -3.822   0.504  -0.623  1.00 37.79           H 
ATOM   1174 2HD2 LEU    70      -2.266  -0.281  -0.356  1.00 37.79           H 
ATOM   1175 3HD2 LEU    70      -2.373   1.480  -0.383  1.00 37.79           H 
ATOM   1176  N   TYR    71      -6.554  -1.572   3.705  1.00  4.11           N 
ATOM   1177  CA  TYR    71      -7.629  -2.541   3.923  1.00 10.13           C 
ATOM   1178  C   TYR    71      -8.475  -2.719   2.657  1.00 15.31           C 
ATOM   1179  O   TYR    71      -9.033  -1.753   2.128  1.00 52.43           O 
ATOM   1180  CB  TYR    71      -8.522  -2.073   5.079  1.00  1.32           C 
ATOM   1181  CG  TYR    71      -7.754  -1.742   6.347  1.00 20.41           C 
ATOM   1182  CD1 TYR    71      -7.517  -0.420   6.716  1.00 63.43           C 
ATOM   1183  CD2 TYR    71      -7.263  -2.749   7.170  1.00 71.51           C 
ATOM   1184  CE1 TYR    71      -6.818  -0.114   7.869  1.00 32.32           C 
ATOM   1185  CE2 TYR    71      -6.565  -2.449   8.324  1.00 14.31           C 
ATOM   1186  CZ  TYR    71      -6.345  -1.131   8.667  1.00 12.13           C 
ATOM   1187  OH  TYR    71      -5.649  -0.833   9.816  1.00 52.25           O 
ATOM   1188  H   TYR    71      -6.772  -0.618   3.704  1.00 37.79           H 
ATOM   1189  HA  TYR    71      -7.183  -3.490   4.185  1.00 71.44           H 
ATOM   1190 1HB  TYR    71      -9.234  -2.852   5.314  1.00 37.79           H 
ATOM   1191 2HB  TYR    71      -9.059  -1.185   4.774  1.00 37.79           H 
ATOM   1192  HD1 TYR    71      -7.889   0.376   6.089  1.00 20.44           H 
ATOM   1193  HD2 TYR    71      -7.435  -3.782   6.901  1.00 52.23           H 
ATOM   1194  HE1 TYR    71      -6.644   0.918   8.138  1.00 35.22           H 
ATOM   1195  HE2 TYR    71      -6.193  -3.246   8.951  1.00 22.14           H 
ATOM   1196  HH  TYR    71      -6.100  -0.128  10.295  1.00 71.31           H 
ATOM   1197  N   VAL    72      -8.558  -3.951   2.167  1.00 31.02           N 
ATOM   1198  CA  VAL    72      -9.406  -4.271   1.016  1.00 71.24           C 
ATOM   1199  C   VAL    72     -10.546  -5.213   1.432  1.00 53.44           C 
ATOM   1200  O   VAL    72     -10.357  -6.114   2.254  1.00 50.24           O 
ATOM   1201  CB  VAL    72      -8.584  -4.905  -0.138  1.00 55.51           C 
ATOM   1202  CG1 VAL    72      -7.912  -6.202   0.306  1.00 24.42           C 
ATOM   1203  CG2 VAL    72      -9.456  -5.135  -1.372  1.00 31.30           C 
ATOM   1204  H   VAL    72      -8.036  -4.668   2.588  1.00 37.79           H 
ATOM   1205  HA  VAL    72      -9.839  -3.345   0.653  1.00 25.11           H 
ATOM   1206  HB  VAL    72      -7.803  -4.207  -0.409  1.00 74.53           H 
ATOM   1207 1HG1 VAL    72      -8.665  -6.920   0.598  1.00 37.79           H 
ATOM   1208 2HG1 VAL    72      -7.259  -6.005   1.146  1.00 37.79           H 
ATOM   1209 3HG1 VAL    72      -7.332  -6.603  -0.512  1.00 37.79           H 
ATOM   1210 1HG2 VAL    72      -8.857  -5.570  -2.160  1.00 37.79           H 
ATOM   1211 2HG2 VAL    72      -9.861  -4.191  -1.710  1.00 37.79           H 
ATOM   1212 3HG2 VAL    72     -10.267  -5.806  -1.125  1.00 37.79           H 
ATOM   1433  N   LYS    88     -10.565   0.120   0.556  1.00 13.14           N 
ATOM   1434  CA  LYS    88     -11.628   0.878   1.232  1.00 34.52           C 
ATOM   1435  C   LYS    88     -11.065   1.902   2.233  1.00 74.05           C 
ATOM   1436  O   LYS    88     -11.679   2.943   2.476  1.00 35.55           O 
ATOM   1437  CB  LYS    88     -12.598  -0.087   1.938  1.00  4.12           C 
ATOM   1438  CG  LYS    88     -11.936  -1.000   2.970  1.00 35.03           C 
ATOM   1439  CD  LYS    88     -12.904  -2.045   3.527  1.00 34.12           C 
ATOM   1440  CE  LYS    88     -14.118  -1.413   4.198  1.00 34.05           C 
ATOM   1441  NZ  LYS    88     -15.086  -2.440   4.666  1.00 62.25           N 
ATOM   1442  H   LYS    88     -10.290  -0.747   0.923  1.00 37.79           H 
ATOM   1443  HA  LYS    88     -12.177   1.417   0.470  1.00 54.25           H 
ATOM   1444 1HB  LYS    88     -13.070  -0.709   1.190  1.00 37.79           H 
ATOM   1445 2HB  LYS    88     -13.361   0.493   2.439  1.00 37.79           H 
ATOM   1446 1HG  LYS    88     -11.566  -0.393   3.785  1.00 37.79           H 
ATOM   1447 2HG  LYS    88     -11.110  -1.513   2.500  1.00 37.79           H 
ATOM   1448 1HD  LYS    88     -12.379  -2.651   4.252  1.00 37.79           H 
ATOM   1449 2HD  LYS    88     -13.244  -2.673   2.717  1.00 37.79           H 
ATOM   1450 1HE  LYS    88     -14.610  -0.763   3.490  1.00 37.79           H 
ATOM   1451 2HE  LYS    88     -13.785  -0.833   5.047  1.00 37.79           H 
ATOM   1452 1HZ  LYS    88     -15.374  -3.052   3.875  1.00 37.79           H 
ATOM   1453 2HZ  LYS    88     -15.933  -1.983   5.056  1.00 37.79           H 
ATOM   1454 3HZ  LYS    88     -14.657  -3.030   5.405  1.00 37.79           H 
ATOM   1455  N   SER    89      -9.898   1.608   2.810  1.00 25.23           N 
ATOM   1456  CA  SER    89      -9.257   2.510   3.789  1.00 12.22           C 
ATOM   1457  C   SER    89      -7.758   2.223   3.926  1.00 42.34           C 
ATOM   1458  O   SER    89      -7.279   1.170   3.508  1.00 60.11           O 
ATOM   1459  CB  SER    89      -9.916   2.387   5.175  1.00 73.00           C 
ATOM   1460  OG  SER    89     -11.252   2.865   5.172  1.00 43.43           O 
ATOM   1461  H   SER    89      -9.448   0.771   2.567  1.00 37.79           H 
ATOM   1462  HA  SER    89      -9.382   3.523   3.432  1.00 45.21           H 
ATOM   1463 1HB  SER    89      -9.347   2.962   5.893  1.00 37.79           H 
ATOM   1464 2HB  SER    89      -9.925   1.350   5.477  1.00 37.79           H 
ATOM   1465  HG  SER    89     -11.439   3.292   4.326  1.00 35.04           H 
ATOM   1466  N   TYR    90      -7.022   3.162   4.527  1.00 22.31           N 
ATOM   1467  CA  TYR    90      -5.592   2.966   4.800  1.00 52.02           C 
ATOM   1468  C   TYR    90      -5.207   3.534   6.180  1.00 25.35           C 
ATOM   1469  O   TYR    90      -5.932   4.348   6.755  1.00 34.33           O 
ATOM   1470  CB  TYR    90      -4.723   3.600   3.698  1.00  3.22           C 
ATOM   1471  CG  TYR    90      -4.642   5.117   3.751  1.00 12.41           C 
ATOM   1472  CD1 TYR    90      -3.506   5.753   4.246  1.00 14.15           C 
ATOM   1473  CD2 TYR    90      -5.697   5.910   3.312  1.00  1.54           C 
ATOM   1474  CE1 TYR    90      -3.426   7.130   4.300  1.00 61.11           C 
ATOM   1475  CE2 TYR    90      -5.620   7.287   3.362  1.00  4.32           C 
ATOM   1476  CZ  TYR    90      -4.484   7.891   3.858  1.00 71.13           C 
ATOM   1477  OH  TYR    90      -4.410   9.262   3.914  1.00 41.41           O 
ATOM   1478  H   TYR    90      -7.447   4.003   4.793  1.00 37.79           H 
ATOM   1479  HA  TYR    90      -5.407   1.900   4.812  1.00 71.54           H 
ATOM   1480 1HB  TYR    90      -5.124   3.323   2.732  1.00 37.79           H 
ATOM   1481 2HB  TYR    90      -3.717   3.214   3.782  1.00 37.79           H 
ATOM   1482  HD1 TYR    90      -2.675   5.153   4.591  1.00 33.40           H 
ATOM   1483  HD2 TYR    90      -6.586   5.436   2.926  1.00 13.12           H 
ATOM   1484  HE1 TYR    90      -2.535   7.605   4.687  1.00 45.53           H 
ATOM   1485  HE2 TYR    90      -6.450   7.887   3.016  1.00 23.03           H 
ATOM   1486  HH  TYR    90      -5.216   9.603   4.315  1.00  4.41           H 
ATOM   1487  N   GLU    91      -4.061   3.101   6.694  1.00  3.42           N 
ATOM   1488  CA  GLU    91      -3.603   3.473   8.042  1.00 74.55           C 
ATOM   1489  C   GLU    91      -2.085   3.735   8.057  1.00 64.43           C 
ATOM   1490  O   GLU    91      -1.325   2.996   7.444  1.00 14.34           O 
ATOM   1491  CB  GLU    91      -3.963   2.331   9.010  1.00 43.34           C 
ATOM   1492  CG  GLU    91      -3.512   2.534  10.455  1.00 75.05           C 
ATOM   1493  CD  GLU    91      -3.979   1.404  11.367  1.00  3.12           C 
ATOM   1494  OE1 GLU    91      -3.203   0.448  11.599  1.00  3.41           O 
ATOM   1495  OE2 GLU    91      -5.133   1.462  11.849  1.00 20.45           O 
ATOM   1496  H   GLU    91      -3.506   2.499   6.158  1.00 37.79           H 
ATOM   1497  HA  GLU    91      -4.122   4.373   8.344  1.00  1.55           H 
ATOM   1498 1HB  GLU    91      -3.513   1.417   8.644  1.00 37.79           H 
ATOM   1499 2HB  GLU    91      -5.036   2.209   9.011  1.00 37.79           H 
ATOM   1500 1HG  GLU    91      -3.917   3.468  10.821  1.00 37.79           H 
ATOM   1501 2HG  GLU    91      -2.432   2.579  10.479  1.00 37.79           H 
ATOM   1502  N   GLU    92      -1.642   4.781   8.754  1.00 12.34           N 
ATOM   1503  CA  GLU    92      -0.203   5.086   8.848  1.00 71.13           C 
ATOM   1504  C   GLU    92       0.418   4.348  10.044  1.00 52.44           C 
ATOM   1505  O   GLU    92      -0.029   4.509  11.182  1.00 61.33           O 
ATOM   1506  CB  GLU    92       0.022   6.603   8.977  1.00 35.14           C 
ATOM   1507  CG  GLU    92       1.495   7.009   9.066  1.00 11.32           C 
ATOM   1508  CD  GLU    92       1.690   8.510   9.239  1.00 74.44           C 
ATOM   1509  OE1 GLU    92       1.086   9.085  10.172  1.00 65.13           O 
ATOM   1510  OE2 GLU    92       2.458   9.119   8.460  1.00 12.12           O 
ATOM   1511  H   GLU    92      -2.288   5.360   9.214  1.00 37.79           H 
ATOM   1512  HA  GLU    92       0.268   4.736   7.938  1.00 60.42           H 
ATOM   1513 1HB  GLU    92      -0.481   6.954   9.868  1.00 37.79           H 
ATOM   1514 2HB  GLU    92      -0.413   7.093   8.116  1.00 37.79           H 
ATOM   1515 1HG  GLU    92       1.996   6.694   8.161  1.00 37.79           H 
ATOM   1516 2HG  GLU    92       1.942   6.508   9.913  1.00 37.79           H 
ATOM   1517  N   ILE    93       1.441   3.534   9.781  1.00 73.20           N 
ATOM   1518  CA  ILE    93       2.008   2.638  10.800  1.00 20.14           C 
ATOM   1519  C   ILE    93       3.548   2.644  10.822  1.00 22.02           C 
ATOM   1520  O   ILE    93       4.205   3.283   9.994  1.00 32.45           O 
ATOM   1521  CB  ILE    93       1.531   1.178  10.581  1.00 24.51           C 
ATOM   1522  CG1 ILE    93       1.930   0.684   9.178  1.00 61.02           C 
ATOM   1523  CG2 ILE    93       0.021   1.066  10.788  1.00 55.35           C 
ATOM   1524  CD1 ILE    93       1.584  -0.768   8.912  1.00  1.24           C 
ATOM   1525  H   ILE    93       1.831   3.541   8.883  1.00 37.79           H 
ATOM   1526  HA  ILE    93       1.651   2.963  11.767  1.00 34.52           H 
ATOM   1527  HB  ILE    93       2.013   0.555  11.321  1.00 75.22           H 
ATOM   1528 1HG1 ILE    93       2.999   0.797   9.053  1.00 37.79           H 
ATOM   1529 2HG1 ILE    93       1.424   1.282   8.436  1.00 37.79           H 
ATOM   1530 1HG2 ILE    93      -0.280   0.032  10.698  1.00 37.79           H 
ATOM   1531 2HG2 ILE    93      -0.492   1.655  10.043  1.00 37.79           H 
ATOM   1532 3HG2 ILE    93      -0.236   1.429  11.774  1.00 37.79           H 
ATOM   1533 1HD1 ILE    93       1.851  -1.019   7.896  1.00 37.79           H 
ATOM   1534 2HD1 ILE    93       0.525  -0.920   9.053  1.00 37.79           H 
ATOM   1535 3HD1 ILE    93       2.134  -1.400   9.594  1.00 37.79           H 
ATOM   1536  N   GLN    94       4.107   1.907  11.782  1.00 25.52           N 
ATOM   1537  CA  GLN    94       5.559   1.754  11.921  1.00 31.04           C 
ATOM   1538  C   GLN    94       5.989   0.330  11.526  1.00 61.23           C 
ATOM   1539  O   GLN    94       5.148  -0.536  11.281  1.00 31.03           O 
ATOM   1540  CB  GLN    94       5.979   2.053  13.369  1.00 21.14           C 
ATOM   1541  CG  GLN    94       5.425   1.058  14.384  1.00  2.22           C 
ATOM   1542  CD  GLN    94       5.682   1.459  15.826  1.00 30.12           C 
ATOM   1543  OE1 GLN    94       6.704   1.116  16.411  1.00 11.24           O 
ATOM   1544  NE2 GLN    94       4.746   2.171  16.418  1.00  5.21           N 
ATOM   1545  H   GLN    94       3.521   1.437  12.416  1.00 37.79           H 
ATOM   1546  HA  GLN    94       6.040   2.461  11.259  1.00 33.05           H 
ATOM   1547 1HB  GLN    94       5.629   3.041  13.634  1.00 37.79           H 
ATOM   1548 2HB  GLN    94       7.059   2.036  13.430  1.00 37.79           H 
ATOM   1549 1HG  GLN    94       5.884   0.095  14.207  1.00 37.79           H 
ATOM   1550 2HG  GLN    94       4.358   0.974  14.237  1.00 37.79           H 
ATOM   1551 1HE2 GLN    94       3.944   2.401  15.904  1.00 37.79           H 
ATOM   1552 2HE2 GLN    94       4.889   2.436  17.348  1.00 37.79           H 
ATOM   1553  N   LYS    95       7.298   0.085  11.478  1.00  5.41           N 
ATOM   1554  CA  LYS    95       7.824  -1.236  11.098  1.00 60.52           C 
ATOM   1555  C   LYS    95       7.325  -2.344  12.049  1.00 64.21           C 
ATOM   1556  O   LYS    95       7.222  -3.509  11.660  1.00 61.24           O 
ATOM   1557  CB  LYS    95       9.358  -1.203  11.078  1.00 60.14           C 
ATOM   1558  CG  LYS    95      10.003  -2.482  10.550  1.00 42.14           C 
ATOM   1559  CD  LYS    95      11.525  -2.406  10.602  1.00 61.43           C 
ATOM   1560  CE  LYS    95      12.179  -3.706  10.147  1.00 51.12           C 
ATOM   1561  NZ  LYS    95      13.660  -3.649  10.257  1.00 60.40           N 
ATOM   1562  H   LYS    95       7.927   0.802  11.703  1.00 37.79           H 
ATOM   1563  HA  LYS    95       7.468  -1.454  10.101  1.00 70.35           H 
ATOM   1564 1HB  LYS    95       9.715  -1.033  12.085  1.00 37.79           H 
ATOM   1565 2HB  LYS    95       9.679  -0.380  10.453  1.00 37.79           H 
ATOM   1566 1HG  LYS    95       9.691  -2.635   9.525  1.00 37.79           H 
ATOM   1567 2HG  LYS    95       9.675  -3.315  11.156  1.00 37.79           H 
ATOM   1568 1HD  LYS    95      11.830  -2.196  11.618  1.00 37.79           H 
ATOM   1569 2HD  LYS    95      11.859  -1.607   9.955  1.00 37.79           H 
ATOM   1570 1HE  LYS    95      11.910  -3.891   9.117  1.00 37.79           H 
ATOM   1571 2HE  LYS    95      11.816  -4.514  10.764  1.00 37.79           H 
ATOM   1572 1HZ  LYS    95      14.038  -2.903   9.638  1.00 37.79           H 
ATOM   1573 2HZ  LYS    95      14.076  -4.562   9.983  1.00 37.79           H 
ATOM   1574 3HZ  LYS    95      13.939  -3.442  11.238  1.00 37.79           H 
ATOM   1575  N   ALA    96       7.012  -1.969  13.289  1.00 42.05           N 
ATOM   1576  CA  ALA    96       6.493  -2.915  14.286  1.00  2.42           C 
ATOM   1577  C   ALA    96       5.117  -3.490  13.893  1.00  3.13           C 
ATOM   1578  O   ALA    96       4.809  -4.643  14.207  1.00 40.35           O 
ATOM   1579  CB  ALA    96       6.409  -2.241  15.649  1.00 70.41           C 
ATOM   1580  H   ALA    96       7.150  -1.034  13.551  1.00 37.79           H 
ATOM   1581  HA  ALA    96       7.199  -3.731  14.363  1.00 43.25           H 
ATOM   1582 1HB  ALA    96       5.684  -1.440  15.611  1.00 37.79           H 
ATOM   1583 2HB  ALA    96       7.376  -1.838  15.913  1.00 37.79           H 
ATOM   1584 3HB  ALA    96       6.107  -2.965  16.392  1.00 37.79           H 
ATOM   1585  N   ASP    97       4.290  -2.685  13.218  1.00 32.43           N 
ATOM   1586  CA  ASP    97       2.965  -3.141  12.770  1.00 44.52           C 
ATOM   1587  C   ASP    97       3.079  -4.138  11.604  1.00 21.31           C 
ATOM   1588  O   ASP    97       2.160  -4.917  11.342  1.00 22.43           O 
ATOM   1589  CB  ASP    97       2.101  -1.947  12.348  1.00  2.13           C 
ATOM   1590  CG  ASP    97       1.852  -0.971  13.484  1.00 13.33           C 
ATOM   1591  OD1 ASP    97       2.567   0.048  13.570  1.00 15.33           O 
ATOM   1592  OD2 ASP    97       0.936  -1.217  14.298  1.00 62.34           O 
ATOM   1593  H   ASP    97       4.573  -1.767  13.014  1.00 37.79           H 
ATOM   1594  HA  ASP    97       2.489  -3.638  13.603  1.00 42.11           H 
ATOM   1595 1HB  ASP    97       1.145  -2.310  11.992  1.00 37.79           H 
ATOM   1596 2HB  ASP    97       2.597  -1.419  11.545  1.00 37.79           H 
ATOM   1597  N   LEU    98       4.214  -4.106  10.912  1.00 23.41           N 
ATOM   1598  CA  LEU    98       4.457  -4.993   9.774  1.00  3.22           C 
ATOM   1599  C   LEU    98       4.758  -6.425  10.239  1.00  0.12           C 
ATOM   1600  O   LEU    98       5.502  -6.628  11.202  1.00  2.31           O 
ATOM   1601  CB  LEU    98       5.645  -4.477   8.948  1.00 40.31           C 
ATOM   1602  CG  LEU    98       5.532  -3.029   8.442  1.00 44.24           C 
ATOM   1603  CD1 LEU    98       6.805  -2.617   7.705  1.00 62.02           C 
ATOM   1604  CD2 LEU    98       4.309  -2.861   7.543  1.00 22.32           C 
ATOM   1605  H   LEU    98       4.912  -3.474  11.179  1.00 37.79           H 
ATOM   1606  HA  LEU    98       3.573  -4.997   9.155  1.00 24.10           H 
ATOM   1607 1HB  LEU    98       5.768  -5.125   8.091  1.00 37.79           H 
ATOM   1608 2HB  LEU    98       6.535  -4.550   9.558  1.00 37.79           H 
ATOM   1609  HG  LEU    98       5.414  -2.369   9.289  1.00 23.45           H 
ATOM   1610 1HD1 LEU    98       6.721  -1.587   7.387  1.00 37.79           H 
ATOM   1611 2HD1 LEU    98       6.948  -3.249   6.839  1.00 37.79           H 
ATOM   1612 3HD1 LEU    98       7.653  -2.718   8.366  1.00 37.79           H 
ATOM   1613 1HD2 LEU    98       3.413  -3.088   8.105  1.00 37.79           H 
ATOM   1614 2HD2 LEU    98       4.382  -3.532   6.699  1.00 37.79           H 
ATOM   1615 3HD2 LEU    98       4.260  -1.842   7.189  1.00 37.79           H 
ATOM   1616  N   PRO    99       4.185  -7.445   9.567  1.00 33.35           N 
ATOM   1617  CA  PRO    99       4.536  -8.848   9.830  1.00 25.44           C 
ATOM   1618  C   PRO    99       5.992  -9.156   9.433  1.00 43.55           C 
ATOM   1619  O   PRO    99       6.576  -8.458   8.599  1.00 11.51           O 
ATOM   1620  CB  PRO    99       3.544  -9.643   8.964  1.00 64.23           C 
ATOM   1621  CG  PRO    99       3.107  -8.691   7.903  1.00 64.33           C 
ATOM   1622  CD  PRO    99       3.149  -7.318   8.523  1.00 12.14           C 
ATOM   1623  HA  PRO    99       4.391  -9.099  10.873  1.00  4.13           H 
ATOM   1624 1HB  PRO    99       2.708  -9.965   9.569  1.00 37.79           H 
ATOM   1625 2HB  PRO    99       4.037 -10.507   8.539  1.00 37.79           H 
ATOM   1626 1HG  PRO    99       2.101  -8.929   7.585  1.00 37.79           H 
ATOM   1627 2HG  PRO    99       3.784  -8.744   7.062  1.00 37.79           H 
ATOM   1628 1HD  PRO    99       2.191  -7.070   8.959  1.00 37.79           H 
ATOM   1629 2HD  PRO    99       3.431  -6.580   7.784  1.00 37.79           H 
ATOM   1630  N   GLU   100       6.563 -10.207  10.021  1.00 23.10           N 
ATOM   1631  CA  GLU   100       7.989 -10.537   9.848  1.00 74.33           C 
ATOM   1632  C   GLU   100       8.430 -10.547   8.375  1.00 74.30           C 
ATOM   1633  O   GLU   100       9.502 -10.049   8.034  1.00 20.33           O 
ATOM   1634  CB  GLU   100       8.298 -11.900  10.471  1.00  2.53           C 
ATOM   1635  CG  GLU   100       9.788 -12.229  10.511  1.00 43.34           C 
ATOM   1636  CD  GLU   100      10.058 -13.681  10.874  1.00 22.51           C 
ATOM   1637  OE1 GLU   100      10.762 -14.371  10.105  1.00 70.02           O 
ATOM   1638  OE2 GLU   100       9.538 -14.152  11.909  1.00 13.11           O 
ATOM   1639  H   GLU   100       6.012 -10.781  10.593  1.00 37.79           H 
ATOM   1640  HA  GLU   100       8.560  -9.784  10.371  1.00 21.22           H 
ATOM   1641 1HB  GLU   100       7.794 -12.669   9.901  1.00 37.79           H 
ATOM   1642 2HB  GLU   100       7.921 -11.913  11.484  1.00 37.79           H 
ATOM   1643 1HG  GLU   100      10.265 -11.589  11.243  1.00 37.79           H 
ATOM   1644 2HG  GLU   100      10.212 -12.031   9.535  1.00 37.79           H 
ATOM   1645  N   LYS   101       7.611 -11.119   7.504  1.00 25.44           N 
ATOM   1646  CA  LYS   101       7.970 -11.214   6.087  1.00 34.04           C 
ATOM   1647  C   LYS   101       8.005  -9.825   5.423  1.00 63.15           C 
ATOM   1648  O   LYS   101       8.966  -9.477   4.735  1.00 55.54           O 
ATOM   1649  CB  LYS   101       6.993 -12.136   5.341  1.00 25.52           C 
ATOM   1650  CG  LYS   101       6.762 -13.483   6.030  1.00 13.22           C 
ATOM   1651  CD  LYS   101       8.067 -14.181   6.423  1.00 21.22           C 
ATOM   1652  CE  LYS   101       8.953 -14.503   5.224  1.00 24.33           C 
ATOM   1653  NZ  LYS   101      10.209 -15.180   5.639  1.00 25.43           N 
ATOM   1654  H   LYS   101       6.762 -11.494   7.818  1.00 37.79           H 
ATOM   1655  HA  LYS   101       8.960 -11.645   6.032  1.00 31.13           H 
ATOM   1656 1HB  LYS   101       7.381 -12.327   4.350  1.00 37.79           H 
ATOM   1657 2HB  LYS   101       6.039 -11.636   5.252  1.00 37.79           H 
ATOM   1658 1HG  LYS   101       6.209 -14.126   5.357  1.00 37.79           H 
ATOM   1659 2HG  LYS   101       6.178 -13.318   6.924  1.00 37.79           H 
ATOM   1660 1HD  LYS   101       7.823 -15.103   6.931  1.00 37.79           H 
ATOM   1661 2HD  LYS   101       8.618 -13.540   7.096  1.00 37.79           H 
ATOM   1662 1HE  LYS   101       9.202 -13.583   4.713  1.00 37.79           H 
ATOM   1663 2HE  LYS   101       8.412 -15.153   4.552  1.00 37.79           H 
ATOM   1664 1HZ  LYS   101       9.988 -16.090   6.099  1.00 37.79           H 
ATOM   1665 2HZ  LYS   101      10.733 -14.585   6.312  1.00 37.79           H 
ATOM   1666 3HZ  LYS   101      10.810 -15.361   4.812  1.00 37.79           H 
ATOM   1667  N   VAL   102       6.963  -9.031   5.665  1.00 51.42           N 
ATOM   1668  CA  VAL   102       6.828  -7.700   5.057  1.00 13.14           C 
ATOM   1669  C   VAL   102       7.961  -6.743   5.467  1.00 70.44           C 
ATOM   1670  O   VAL   102       8.545  -6.062   4.620  1.00 25.33           O 
ATOM   1671  CB  VAL   102       5.462  -7.068   5.423  1.00 61.20           C 
ATOM   1672  CG1 VAL   102       5.408  -5.593   5.034  1.00 13.43           C 
ATOM   1673  CG2 VAL   102       4.328  -7.841   4.758  1.00 22.51           C 
ATOM   1674  H   VAL   102       6.268  -9.343   6.278  1.00 37.79           H 
ATOM   1675  HA  VAL   102       6.858  -7.827   3.984  1.00 21.35           H 
ATOM   1676  HB  VAL   102       5.333  -7.139   6.495  1.00  3.12           H 
ATOM   1677 1HG1 VAL   102       4.439  -5.186   5.285  1.00 37.79           H 
ATOM   1678 2HG1 VAL   102       5.577  -5.490   3.971  1.00 37.79           H 
ATOM   1679 3HG1 VAL   102       6.173  -5.051   5.573  1.00 37.79           H 
ATOM   1680 1HG2 VAL   102       3.380  -7.404   5.040  1.00 37.79           H 
ATOM   1681 2HG2 VAL   102       4.357  -8.872   5.079  1.00 37.79           H 
ATOM   1682 3HG2 VAL   102       4.438  -7.793   3.685  1.00 37.79           H 
ATOM   1683  N   LYS   103       8.267  -6.689   6.763  1.00  4.22           N 
ATOM   1684  CA  LYS   103       9.319  -5.797   7.268  1.00 40.22           C 
ATOM   1685  C   LYS   103      10.663  -6.060   6.565  1.00 22.05           C 
ATOM   1686  O   LYS   103      11.366  -5.121   6.183  1.00 23.14           O 
ATOM   1687  CB  LYS   103       9.454  -5.941   8.792  1.00 74.03           C 
ATOM   1688  CG  LYS   103       9.708  -7.371   9.259  1.00 15.33           C 
ATOM   1689  CD  LYS   103       9.812  -7.487  10.781  1.00 12.30           C 
ATOM   1690  CE  LYS   103       8.589  -6.903  11.481  1.00 25.02           C 
ATOM   1691  NZ  LYS   103       8.674  -7.032  12.957  1.00 33.23           N 
ATOM   1692  H   LYS   103       7.779  -7.263   7.393  1.00 37.79           H 
ATOM   1693  HA  LYS   103       9.013  -4.784   7.044  1.00 53.12           H 
ATOM   1694 1HB  LYS   103       8.539  -5.589   9.252  1.00 37.79           H 
ATOM   1695 2HB  LYS   103      10.275  -5.323   9.130  1.00 37.79           H 
ATOM   1696 1HG  LYS   103      10.632  -7.720   8.819  1.00 37.79           H 
ATOM   1697 2HG  LYS   103       8.894  -7.996   8.919  1.00 37.79           H 
ATOM   1698 1HD  LYS   103      10.696  -6.968  11.116  1.00 37.79           H 
ATOM   1699 2HD  LYS   103       9.892  -8.533  11.043  1.00 37.79           H 
ATOM   1700 1HE  LYS   103       7.708  -7.425  11.134  1.00 37.79           H 
ATOM   1701 2HE  LYS   103       8.506  -5.856  11.227  1.00 37.79           H 
ATOM   1702 1HZ  LYS   103       7.821  -6.640  13.402  1.00 37.79           H 
ATOM   1703 2HZ  LYS   103       9.503  -6.520  13.316  1.00 37.79           H 
ATOM   1704 3HZ  LYS   103       8.762  -8.032  13.226  1.00 37.79           H 
ATOM   1705  N   ASP   104      11.001  -7.336   6.374  1.00 74.33           N 
ATOM   1706  CA  ASP   104      12.207  -7.715   5.631  1.00 74.15           C 
ATOM   1707  C   ASP   104      12.101  -7.350   4.136  1.00  4.45           C 
ATOM   1708  O   ASP   104      13.108  -7.033   3.495  1.00 11.44           O 
ATOM   1709  CB  ASP   104      12.493  -9.215   5.795  1.00 11.15           C 
ATOM   1710  CG  ASP   104      12.748  -9.615   7.241  1.00 62.31           C 
ATOM   1711  OD1 ASP   104      12.447 -10.771   7.606  1.00 10.55           O 
ATOM   1712  OD2 ASP   104      13.282  -8.786   8.009  1.00 25.44           O 
ATOM   1713  H   ASP   104      10.432  -8.041   6.752  1.00 37.79           H 
ATOM   1714  HA  ASP   104      13.033  -7.162   6.056  1.00 43.15           H 
ATOM   1715 1HB  ASP   104      13.366  -9.472   5.213  1.00 37.79           H 
ATOM   1716 2HB  ASP   104      11.646  -9.780   5.429  1.00 37.79           H 
ATOM   1717  N   LYS   105      10.884  -7.388   3.586  1.00  1.14           N 
ATOM   1718  CA  LYS   105      10.652  -7.024   2.178  1.00 20.34           C 
ATOM   1719  C   LYS   105      10.869  -5.520   1.926  1.00 22.43           C 
ATOM   1720  O   LYS   105      11.214  -5.114   0.815  1.00 61.23           O 
ATOM   1721  CB  LYS   105       9.231  -7.418   1.746  1.00 35.05           C 
ATOM   1722  CG  LYS   105       8.976  -8.923   1.739  1.00 42.20           C 
ATOM   1723  CD  LYS   105       9.871  -9.656   0.739  1.00 61.44           C 
ATOM   1724  CE  LYS   105       9.601  -9.221  -0.699  1.00 30.51           C 
ATOM   1725  NZ  LYS   105      10.407  -9.998  -1.678  1.00 21.42           N 
ATOM   1726  H   LYS   105      10.122  -7.675   4.136  1.00 37.79           H 
ATOM   1727  HA  LYS   105      11.362  -7.578   1.577  1.00 21.31           H 
ATOM   1728 1HB  LYS   105       9.052  -7.042   0.748  1.00 37.79           H 
ATOM   1729 2HB  LYS   105       8.523  -6.959   2.422  1.00 37.79           H 
ATOM   1730 1HG  LYS   105       7.941  -9.101   1.480  1.00 37.79           H 
ATOM   1731 2HG  LYS   105       9.168  -9.314   2.727  1.00 37.79           H 
ATOM   1732 1HD  LYS   105       9.691 -10.720   0.823  1.00 37.79           H 
ATOM   1733 2HD  LYS   105      10.903  -9.448   0.976  1.00 37.79           H 
ATOM   1734 1HE  LYS   105       9.846  -8.173  -0.799  1.00 37.79           H 
ATOM   1735 2HE  LYS   105       8.554  -9.366  -0.919  1.00 37.79           H 
ATOM   1736 1HZ  LYS   105      10.169 -11.008  -1.617  1.00 37.79           H 
ATOM   1737 2HZ  LYS   105      11.421  -9.880  -1.480  1.00 37.79           H 
ATOM   1738 3HZ  LYS   105      10.215  -9.665  -2.643  1.00 37.79           H 
ATOM   1739  N   PHE   106      10.639  -4.696   2.951  1.00 53.42           N 
ATOM   1740  CA  PHE   106      10.887  -3.249   2.851  1.00 43.42           C 
ATOM   1741  C   PHE   106      12.367  -2.904   3.084  1.00 20.54           C 
ATOM   1742  O   PHE   106      12.974  -2.164   2.309  1.00 24.40           O 
ATOM   1743  CB  PHE   106      10.014  -2.471   3.852  1.00 50.33           C 
ATOM   1744  CG  PHE   106       8.601  -2.227   3.381  1.00 62.42           C 
ATOM   1745  CD1 PHE   106       7.528  -2.912   3.937  1.00 31.22           C 
ATOM   1746  CD2 PHE   106       8.346  -1.298   2.381  1.00 64.05           C 
ATOM   1747  CE1 PHE   106       6.235  -2.673   3.505  1.00 24.10           C 
ATOM   1748  CE2 PHE   106       7.055  -1.060   1.947  1.00  3.31           C 
ATOM   1749  CZ  PHE   106       6.000  -1.747   2.510  1.00  3.33           C 
ATOM   1750  H   PHE   106      10.282  -5.067   3.788  1.00 37.79           H 
ATOM   1751  HA  PHE   106      10.620  -2.942   1.849  1.00 70.40           H 
ATOM   1752 1HB  PHE   106      10.470  -1.508   4.043  1.00 37.79           H 
ATOM   1753 2HB  PHE   106       9.965  -3.024   4.779  1.00 37.79           H 
ATOM   1754  HD1 PHE   106       7.706  -3.639   4.716  1.00 43.04           H 
ATOM   1755  HD2 PHE   106       9.169  -0.756   1.938  1.00 62.33           H 
ATOM   1756  HE1 PHE   106       5.408  -3.214   3.945  1.00 51.23           H 
ATOM   1757  HE2 PHE   106       6.873  -0.334   1.167  1.00 25.15           H 
ATOM   1758  HZ  PHE   106       4.990  -1.562   2.172  1.00 20.52           H 
ATOM   1759  N   THR   107      12.947  -3.437   4.157  1.00 21.33           N 
ATOM   1760  CA  THR   107      14.325  -3.087   4.538  1.00 14.34           C 
ATOM   1761  C   THR   107      15.379  -3.877   3.741  1.00 32.33           C 
ATOM   1762  O   THR   107      16.541  -3.475   3.670  1.00 15.42           O 
ATOM   1763  CB  THR   107      14.565  -3.308   6.052  1.00 41.25           C 
ATOM   1764  OG1 THR   107      15.868  -2.839   6.424  1.00  5.12           O 
ATOM   1765  CG2 THR   107      14.434  -4.778   6.433  1.00 24.43           C 
ATOM   1766  H   THR   107      12.441  -4.072   4.709  1.00 37.79           H 
ATOM   1767  HA  THR   107      14.463  -2.032   4.333  1.00 75.15           H 
ATOM   1768  HB  THR   107      13.822  -2.744   6.601  1.00 52.25           H 
ATOM   1769  HG1 THR   107      15.791  -2.301   7.221  1.00 35.33           H 
ATOM   1770 1HG2 THR   107      13.462  -5.144   6.137  1.00 37.79           H 
ATOM   1771 2HG2 THR   107      14.548  -4.886   7.501  1.00 37.79           H 
ATOM   1772 3HG2 THR   107      15.201  -5.349   5.932  1.00 37.79           H 
ATOM   1773  N   ILE   108      14.966  -4.995   3.136  1.00  3.54           N 
ATOM   1774  CA  ILE   108      15.882  -5.865   2.378  1.00 14.53           C 
ATOM   1775  C   ILE   108      17.036  -6.372   3.279  1.00 41.22           C 
ATOM   1776  O   ILE   108      18.187  -6.486   2.853  1.00  3.13           O 
ATOM   1777  CB  ILE   108      16.441  -5.136   1.117  1.00 33.21           C 
ATOM   1778  CG1 ILE   108      15.298  -4.470   0.327  1.00 71.54           C 
ATOM   1779  CG2 ILE   108      17.207  -6.104   0.211  1.00 45.30           C 
ATOM   1780  CD1 ILE   108      14.257  -5.444  -0.192  1.00 62.14           C 
ATOM   1781  H   ILE   108      14.017  -5.239   3.187  1.00 37.79           H 
ATOM   1782  HA  ILE   108      15.310  -6.721   2.047  1.00 62.10           H 
ATOM   1783  HB  ILE   108      17.130  -4.371   1.446  1.00 75.20           H 
ATOM   1784 1HG1 ILE   108      15.714  -3.945  -0.522  1.00 37.79           H 
ATOM   1785 2HG1 ILE   108      14.793  -3.762   0.967  1.00 37.79           H 
ATOM   1786 1HG2 ILE   108      18.039  -6.526   0.755  1.00 37.79           H 
ATOM   1787 2HG2 ILE   108      17.576  -5.575  -0.656  1.00 37.79           H 
ATOM   1788 3HG2 ILE   108      16.548  -6.900  -0.108  1.00 37.79           H 
ATOM   1789 1HD1 ILE   108      13.496  -4.901  -0.733  1.00 37.79           H 
ATOM   1790 2HD1 ILE   108      13.805  -5.966   0.638  1.00 37.79           H 
ATOM   1791 3HD1 ILE   108      14.728  -6.157  -0.853  1.00 37.79           H 
END
