
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   88 ( 1391),  selected   88 , name 2jso_A
# Molecule2: number of CA atoms   66 ( 1132),  selected   66 , name T0468.pdb
# PARAMETERS: 2jso_A.T0468.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      D      12          0.562
LGA    E     2_A      V      13          0.905
LGA    W     3_A      Y      14          0.286
LGA    L     4_A      Y      15          0.480
LGA    V     5_A      M      16          0.495
LGA    K     6_A      Q      17          3.987
LGA    K     7_A      -       -           -
LGA    S     8_A      I      18          3.316
LGA    C     9_A      K      19          3.566
LGA    C    10_A      -       -           -
LGA    N    11_A      -       -           -
LGA    K    12_A      T      23          4.267
LGA    Q    13_A      I      24          2.915
LGA    D    14_A      E      25          3.666
LGA    -       -      K      26           -
LGA    -       -      V      27           -
LGA    -       -      D      28           -
LGA    -       -      G      29           -
LGA    -       -      R      30           -
LGA    -       -      N      31           -
LGA    -       -      L      32           -
LGA    N    15_A      R      33          1.135
LGA    R    16_A      N      34          1.660
LGA    H    17_A      Y      35          0.712
LGA    V    18_A      T      36          0.809
LGA    L    19_A      L      37          1.147
LGA    M    20_A      P      38          1.105
LGA    L    21_A      A      39          1.939
LGA    C    22_A      Y      40          0.683
LGA    D    23_A      D      41          1.297
LGA    A    24_A      E      42          2.820
LGA    G    25_A      D      43          5.901
LGA    G    26_A      G      44          2.880
LGA    A    27_A      -       -           -
LGA    I    28_A      V      45          0.716
LGA    K    29_A      K      46          0.708
LGA    M    30_A      K      47          1.244
LGA    I    31_A      Q      48          1.139
LGA    A    32_A      I      49          2.067
LGA    E    33_A      T      50          2.870
LGA    V    34_A      F      51          3.123
LGA    K    35_A      -       -           -
LGA    S    36_A      R      52          0.998
LGA    D    37_A      -       -           -
LGA    F    38_A      -       -           -
LGA    A    39_A      -       -           -
LGA    V    40_A      -       -           -
LGA    K    41_A      -       -           -
LGA    V    42_A      A      66          4.104
LGA    G    43_A      F      67          1.666
LGA    D    44_A      L      68          1.080
LGA    L    45_A      R      69          0.614
LGA    L    46_A      L      70          0.254
LGA    S    47_A      Y      71          0.115
LGA    P    48_A      V      72          1.926
LGA    L    49_A      K      88          2.696
LGA    Q    50_A      -       -           -
LGA    N    51_A      -       -           -
LGA    A    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    Y    54_A      -       -           -
LGA    C    55_A      S      89          0.979
LGA    I    56_A      Y      90          1.383
LGA    N    57_A      E      91          0.884
LGA    R    58_A      E      92           #
LGA    E    59_A      I      93           -
LGA    K    60_A      Q      94           -
LGA    L    61_A      K      95           -
LGA    H    62_A      A      96           -
LGA    T    63_A      D      97           -
LGA    V    64_A      L      98           -
LGA    K    65_A      P      99           -
LGA    V    66_A      E     100           -
LGA    L    67_A      K     101           -
LGA    S    68_A      V     102           -
LGA    A    69_A      K     103           -
LGA    S    70_A      D     104           -
LGA    S    71_A      K     105           -
LGA    Y    72_A      F     106           -
LGA    S    73_A      T     107           -
LGA    P    74_A      I     108           -
LGA    D    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    W    77_A      -       -           -
LGA    E    78_A      -       -           -
LGA    R    79_A      -       -           -
LGA    Q    80_A      -       -           -
LGA    C    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    V    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    G    85_A      -       -           -
LGA    K    86_A      -       -           -
LGA    T    87_A      -       -           -
LGA    Q    88_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   88   66    5.0     42    2.23    11.90     50.960     1.801

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.504568 * X  +  -0.024106 * Y  +  -0.863036 * Z  + -10.430231
  Y_new =   0.591745 * X  +   0.737549 * Y  +   0.325359 * Z  + -10.338312
  Z_new =   0.628688 * X  +  -0.674863 * Y  +   0.386408 * Z  +   0.822539 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.050788    2.090805  [ DEG:   -60.2057    119.7943 ]
  Theta =  -0.679865   -2.461728  [ DEG:   -38.9534   -141.0466 ]
  Phi   =   0.864750   -2.276842  [ DEG:    49.5465   -130.4535 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jso_A                                        
REMARK     2: T0468.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jso_A.T0468.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   88   66   5.0   42   2.23   11.90  50.960
REMARK  ---------------------------------------------------------- 
MOLECULE 2jso_A
HEADER    SIGNALING PROTEIN                       10-JUL-07   2JSO              
TITLE     ANTIMICROBIAL RESISTANCE PROTEIN                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: POLYMYXIN RESISTANCE PROTEIN PMRD;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: BASR/PMRA POSTTRANSCRIPTIONAL ACTIVATOR, SIGNAL             
COMPND   5 TRANSDUCTION PROTEIN PMRD;                                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 GENE: PMRD;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: K12;                                       
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PET21A(+)                                  
KEYWDS    PROTEIN, ANTIBIOTIC RESISTANCE, TRANSCRIPTION, SIGNALING              
KEYWDS   2 PROTEIN                                                              
EXPDTA    NMR, 21 STRUCTURES                                                    
AUTHOR    C.JIN,W.FU                                                            
REVDAT   1   04-SEP-07 2JSO    0                                                
JRNL        AUTH   W.FU,F.YANG,X.KANG,X.ZHANG,Y.LI,B.XIA,C.JIN                  
JRNL        TITL   FIRST STRUCTURE OF THE POLYMYXIN RESISTANCE                  
JRNL        TITL 2 PROTEINS.                                                    
JRNL        REF    BIOCHEM.BIOPHYS.RES.COMMUN.   V. 361  1033 2007              
JRNL        REFN   ASTM BBRCA9  US ISSN 0006-291X                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JSO A    1    88  UNP    P37590   PMRD_ECOLI       1     88             
SEQRES   1 A   88  MET GLU TRP LEU VAL LYS LYS SER CYS CYS ASN LYS GLN          
SEQRES   2 A   88  ASP ASN ARG HIS VAL LEU MET LEU CYS ASP ALA GLY GLY          
SEQRES   3 A   88  ALA ILE LYS MET ILE ALA GLU VAL LYS SER ASP PHE ALA          
SEQRES   4 A   88  VAL LYS VAL GLY ASP LEU LEU SER PRO LEU GLN ASN ALA          
SEQRES   5 A   88  LEU TYR CYS ILE ASN ARG GLU LYS LEU HIS THR VAL LYS          
SEQRES   6 A   88  VAL LEU SER ALA SER SER TYR SER PRO ASP GLU TRP GLU          
SEQRES   7 A   88  ARG GLN CYS LYS VAL ALA GLY LYS THR GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -8.320  -9.881   2.984  1.00  0.00           N  
ATOM      2  CA  MET A   1      -6.953  -9.614   2.486  1.00  0.00           C  
ATOM      3  C   MET A   1      -6.626  -8.143   2.724  1.00  0.00           C  
ATOM      4  O   MET A   1      -7.372  -7.258   2.299  1.00  0.00           O  
ATOM      5  CB  MET A   1      -6.777 -10.002   1.004  1.00  0.00           C  
ATOM      6  CG  MET A   1      -5.326  -9.830   0.526  1.00  0.00           C  
ATOM      7  SD  MET A   1      -4.100 -10.823   1.425  1.00  0.00           S  
ATOM      8  CE  MET A   1      -2.585 -10.245   0.610  1.00  0.00           C  
ATOM      9  H1  MET A   1      -8.386  -9.548   3.940  1.00  0.00           H  
ATOM     10  H2  MET A   1      -8.990  -9.371   2.430  1.00  0.00           H  
ATOM     11  H3  MET A   1      -8.529 -10.866   2.952  1.00  0.00           H  
ATOM     12  HA  MET A   1      -6.262 -10.218   3.075  1.00  0.00           H  
ATOM     13  HB2 MET A   1      -7.062 -11.046   0.866  1.00  0.00           H  
ATOM     14  HB3 MET A   1      -7.426  -9.383   0.380  1.00  0.00           H  
ATOM     15  HG2 MET A   1      -5.279 -10.103  -0.528  1.00  0.00           H  
ATOM     16  HG3 MET A   1      -5.046  -8.780   0.607  1.00  0.00           H  
ATOM     17  HE1 MET A   1      -2.653 -10.425  -0.463  1.00  0.00           H  
ATOM     18  HE2 MET A   1      -2.455  -9.177   0.790  1.00  0.00           H  
ATOM     19  HE3 MET A   1      -1.727 -10.784   1.010  1.00  0.00           H  
ATOM     20  N   GLU A   2      -5.510  -7.874   3.403  1.00  0.00           N  
ATOM     21  CA  GLU A   2      -5.049  -6.536   3.743  1.00  0.00           C  
ATOM     22  C   GLU A   2      -3.582  -6.454   3.312  1.00  0.00           C  
ATOM     23  O   GLU A   2      -2.918  -7.485   3.153  1.00  0.00           O  
ATOM     24  CB  GLU A   2      -5.214  -6.254   5.248  1.00  0.00           C  
ATOM     25  CG  GLU A   2      -6.658  -6.367   5.775  1.00  0.00           C  
ATOM     26  CD  GLU A   2      -7.078  -7.810   6.124  1.00  0.00           C  
ATOM     27  OE1 GLU A   2      -6.604  -8.352   7.149  1.00  0.00           O  
ATOM     28  OE2 GLU A   2      -7.912  -8.405   5.403  1.00  0.00           O  
ATOM     29  H   GLU A   2      -4.861  -8.619   3.625  1.00  0.00           H  
ATOM     30  HA  GLU A   2      -5.618  -5.789   3.185  1.00  0.00           H  
ATOM     31  HB2 GLU A   2      -4.564  -6.920   5.818  1.00  0.00           H  
ATOM     32  HB3 GLU A   2      -4.874  -5.235   5.431  1.00  0.00           H  
ATOM     33  HG2 GLU A   2      -6.732  -5.765   6.683  1.00  0.00           H  
ATOM     34  HG3 GLU A   2      -7.344  -5.934   5.045  1.00  0.00           H  
ATOM     35  N   TRP A   3      -3.081  -5.237   3.115  1.00  0.00           N  
ATOM     36  CA  TRP A   3      -1.816  -4.987   2.441  1.00  0.00           C  
ATOM     37  C   TRP A   3      -1.002  -3.974   3.242  1.00  0.00           C  
ATOM     38  O   TRP A   3      -1.543  -3.262   4.087  1.00  0.00           O  
ATOM     39  CB  TRP A   3      -2.079  -4.486   1.009  1.00  0.00           C  
ATOM     40  CG  TRP A   3      -2.980  -5.343   0.165  1.00  0.00           C  
ATOM     41  CD1 TRP A   3      -4.330  -5.279   0.148  1.00  0.00           C  
ATOM     42  CD2 TRP A   3      -2.627  -6.399  -0.783  1.00  0.00           C  
ATOM     43  NE1 TRP A   3      -4.837  -6.222  -0.722  1.00  0.00           N  
ATOM     44  CE2 TRP A   3      -3.829  -6.941  -1.330  1.00  0.00           C  
ATOM     45  CE3 TRP A   3      -1.412  -6.952  -1.242  1.00  0.00           C  
ATOM     46  CZ2 TRP A   3      -3.825  -7.978  -2.277  1.00  0.00           C  
ATOM     47  CZ3 TRP A   3      -1.394  -7.996  -2.186  1.00  0.00           C  
ATOM     48  CH2 TRP A   3      -2.597  -8.509  -2.705  1.00  0.00           C  
ATOM     49  H   TRP A   3      -3.639  -4.422   3.354  1.00  0.00           H  
ATOM     50  HA  TRP A   3      -1.252  -5.916   2.385  1.00  0.00           H  
ATOM     51  HB2 TRP A   3      -2.515  -3.489   1.063  1.00  0.00           H  
ATOM     52  HB3 TRP A   3      -1.124  -4.389   0.493  1.00  0.00           H  
ATOM     53  HD1 TRP A   3      -4.923  -4.595   0.743  1.00  0.00           H  
ATOM     54  HE1 TRP A   3      -5.828  -6.350  -0.879  1.00  0.00           H  
ATOM     55  HE3 TRP A   3      -0.483  -6.562  -0.863  1.00  0.00           H  
ATOM     56  HZ2 TRP A   3      -4.753  -8.364  -2.674  1.00  0.00           H  
ATOM     57  HZ3 TRP A   3      -0.449  -8.401  -2.523  1.00  0.00           H  
ATOM     58  HH2 TRP A   3      -2.576  -9.306  -3.437  1.00  0.00           H  
ATOM     59  N   LEU A   4       0.292  -3.888   2.953  1.00  0.00           N  
ATOM     60  CA  LEU A   4       1.268  -3.056   3.641  1.00  0.00           C  
ATOM     61  C   LEU A   4       1.944  -2.185   2.592  1.00  0.00           C  
ATOM     62  O   LEU A   4       2.389  -2.700   1.566  1.00  0.00           O  
ATOM     63  CB  LEU A   4       2.286  -3.981   4.329  1.00  0.00           C  
ATOM     64  CG  LEU A   4       3.467  -3.266   5.012  1.00  0.00           C  
ATOM     65  CD1 LEU A   4       3.011  -2.409   6.196  1.00  0.00           C  
ATOM     66  CD2 LEU A   4       4.474  -4.316   5.500  1.00  0.00           C  
ATOM     67  H   LEU A   4       0.656  -4.509   2.236  1.00  0.00           H  
ATOM     68  HA  LEU A   4       0.773  -2.431   4.386  1.00  0.00           H  
ATOM     69  HB2 LEU A   4       1.763  -4.581   5.071  1.00  0.00           H  
ATOM     70  HB3 LEU A   4       2.691  -4.654   3.573  1.00  0.00           H  
ATOM     71  HG  LEU A   4       3.973  -2.623   4.293  1.00  0.00           H  
ATOM     72 HD11 LEU A   4       2.384  -1.589   5.849  1.00  0.00           H  
ATOM     73 HD12 LEU A   4       2.448  -3.014   6.908  1.00  0.00           H  
ATOM     74 HD13 LEU A   4       3.879  -1.985   6.701  1.00  0.00           H  
ATOM     75 HD21 LEU A   4       4.012  -4.967   6.243  1.00  0.00           H  
ATOM     76 HD22 LEU A   4       4.814  -4.921   4.658  1.00  0.00           H  
ATOM     77 HD23 LEU A   4       5.339  -3.823   5.944  1.00  0.00           H  
ATOM     78  N   VAL A   5       2.026  -0.881   2.841  1.00  0.00           N  
ATOM     79  CA  VAL A   5       2.743   0.060   1.993  1.00  0.00           C  
ATOM     80  C   VAL A   5       4.232  -0.080   2.319  1.00  0.00           C  
ATOM     81  O   VAL A   5       4.680   0.426   3.349  1.00  0.00           O  
ATOM     82  CB  VAL A   5       2.201   1.488   2.239  1.00  0.00           C  
ATOM     83  CG1 VAL A   5       2.909   2.520   1.352  1.00  0.00           C  
ATOM     84  CG2 VAL A   5       0.692   1.561   1.949  1.00  0.00           C  
ATOM     85  H   VAL A   5       1.602  -0.510   3.687  1.00  0.00           H  
ATOM     86  HA  VAL A   5       2.575  -0.200   0.948  1.00  0.00           H  
ATOM     87  HB  VAL A   5       2.360   1.762   3.282  1.00  0.00           H  
ATOM     88 HG11 VAL A   5       3.967   2.579   1.605  1.00  0.00           H  
ATOM     89 HG12 VAL A   5       2.814   2.238   0.305  1.00  0.00           H  
ATOM     90 HG13 VAL A   5       2.468   3.506   1.504  1.00  0.00           H  
ATOM     91 HG21 VAL A   5       0.486   1.204   0.941  1.00  0.00           H  
ATOM     92 HG22 VAL A   5       0.144   0.948   2.662  1.00  0.00           H  
ATOM     93 HG23 VAL A   5       0.339   2.586   2.054  1.00  0.00           H  
ATOM     94  N   LYS A   6       5.011  -0.780   1.486  1.00  0.00           N  
ATOM     95  CA  LYS A   6       6.458  -0.921   1.720  1.00  0.00           C  
ATOM     96  C   LYS A   6       7.272   0.194   1.068  1.00  0.00           C  
ATOM     97  O   LYS A   6       8.367   0.472   1.550  1.00  0.00           O  
ATOM     98  CB  LYS A   6       6.961  -2.298   1.257  1.00  0.00           C  
ATOM     99  CG  LYS A   6       6.675  -3.404   2.294  1.00  0.00           C  
ATOM    100  CD  LYS A   6       7.853  -3.709   3.238  1.00  0.00           C  
ATOM    101  CE  LYS A   6       8.381  -2.486   4.008  1.00  0.00           C  
ATOM    102  NZ  LYS A   6       9.512  -2.837   4.907  1.00  0.00           N  
ATOM    103  H   LYS A   6       4.588  -1.224   0.672  1.00  0.00           H  
ATOM    104  HA  LYS A   6       6.638  -0.833   2.791  1.00  0.00           H  
ATOM    105  HB2 LYS A   6       6.482  -2.534   0.309  1.00  0.00           H  
ATOM    106  HB3 LYS A   6       8.036  -2.261   1.067  1.00  0.00           H  
ATOM    107  HG2 LYS A   6       5.793  -3.144   2.879  1.00  0.00           H  
ATOM    108  HG3 LYS A   6       6.449  -4.328   1.764  1.00  0.00           H  
ATOM    109  HD2 LYS A   6       7.527  -4.466   3.952  1.00  0.00           H  
ATOM    110  HD3 LYS A   6       8.667  -4.132   2.646  1.00  0.00           H  
ATOM    111  HE2 LYS A   6       8.717  -1.732   3.291  1.00  0.00           H  
ATOM    112  HE3 LYS A   6       7.567  -2.059   4.599  1.00  0.00           H  
ATOM    113  HZ1 LYS A   6       9.233  -3.502   5.612  1.00  0.00           H  
ATOM    114  HZ2 LYS A   6      10.285  -3.232   4.391  1.00  0.00           H  
ATOM    115  HZ3 LYS A   6       9.859  -2.017   5.385  1.00  0.00           H  
ATOM    116  N   LYS A   7       6.760   0.850   0.024  1.00  0.00           N  
ATOM    117  CA  LYS A   7       7.342   2.058  -0.567  1.00  0.00           C  
ATOM    118  C   LYS A   7       6.182   2.944  -0.994  1.00  0.00           C  
ATOM    119  O   LYS A   7       5.099   2.423  -1.273  1.00  0.00           O  
ATOM    120  CB  LYS A   7       8.258   1.753  -1.771  1.00  0.00           C  
ATOM    121  CG  LYS A   7       9.437   0.832  -1.416  1.00  0.00           C  
ATOM    122  CD  LYS A   7      10.575   0.910  -2.441  1.00  0.00           C  
ATOM    123  CE  LYS A   7      11.626  -0.165  -2.125  1.00  0.00           C  
ATOM    124  NZ  LYS A   7      12.951   0.142  -2.721  1.00  0.00           N  
ATOM    125  H   LYS A   7       5.828   0.613  -0.292  1.00  0.00           H  
ATOM    126  HA  LYS A   7       7.932   2.579   0.187  1.00  0.00           H  
ATOM    127  HB2 LYS A   7       7.678   1.302  -2.578  1.00  0.00           H  
ATOM    128  HB3 LYS A   7       8.657   2.701  -2.137  1.00  0.00           H  
ATOM    129  HG2 LYS A   7       9.848   1.134  -0.452  1.00  0.00           H  
ATOM    130  HG3 LYS A   7       9.076  -0.195  -1.342  1.00  0.00           H  
ATOM    131  HD2 LYS A   7      10.188   0.751  -3.447  1.00  0.00           H  
ATOM    132  HD3 LYS A   7      11.024   1.903  -2.385  1.00  0.00           H  
ATOM    133  HE2 LYS A   7      11.733  -0.246  -1.040  1.00  0.00           H  
ATOM    134  HE3 LYS A   7      11.265  -1.125  -2.501  1.00  0.00           H  
ATOM    135  HZ1 LYS A   7      12.889   0.253  -3.721  1.00  0.00           H  
ATOM    136  HZ2 LYS A   7      13.339   0.985  -2.325  1.00  0.00           H  
ATOM    137  HZ3 LYS A   7      13.605  -0.605  -2.533  1.00  0.00           H  
ATOM    138  N   SER A   8       6.402   4.250  -1.082  1.00  0.00           N  
ATOM    139  CA  SER A   8       5.384   5.231  -1.430  1.00  0.00           C  
ATOM    140  C   SER A   8       6.067   6.437  -2.074  1.00  0.00           C  
ATOM    141  O   SER A   8       7.209   6.761  -1.729  1.00  0.00           O  
ATOM    142  CB  SER A   8       4.599   5.624  -0.167  1.00  0.00           C  
ATOM    143  OG  SER A   8       5.444   5.757   0.969  1.00  0.00           O  
ATOM    144  H   SER A   8       7.310   4.628  -0.854  1.00  0.00           H  
ATOM    145  HA  SER A   8       4.691   4.799  -2.152  1.00  0.00           H  
ATOM    146  HB2 SER A   8       4.059   6.555  -0.342  1.00  0.00           H  
ATOM    147  HB3 SER A   8       3.871   4.842   0.044  1.00  0.00           H  
ATOM    148  HG  SER A   8       6.056   6.493   0.810  1.00  0.00           H  
ATOM    149  N   CYS A   9       5.366   7.105  -2.991  1.00  0.00           N  
ATOM    150  CA  CYS A   9       5.906   8.168  -3.828  1.00  0.00           C  
ATOM    151  C   CYS A   9       4.967   9.370  -3.736  1.00  0.00           C  
ATOM    152  O   CYS A   9       3.932   9.406  -4.408  1.00  0.00           O  
ATOM    153  CB  CYS A   9       6.068   7.654  -5.267  1.00  0.00           C  
ATOM    154  SG  CYS A   9       7.187   6.219  -5.277  1.00  0.00           S  
ATOM    155  H   CYS A   9       4.458   6.743  -3.263  1.00  0.00           H  
ATOM    156  HA  CYS A   9       6.892   8.464  -3.465  1.00  0.00           H  
ATOM    157  HB2 CYS A   9       5.096   7.364  -5.668  1.00  0.00           H  
ATOM    158  HB3 CYS A   9       6.482   8.448  -5.891  1.00  0.00           H  
ATOM    159  HG  CYS A   9       7.105   5.970  -6.591  1.00  0.00           H  
ATOM    160  N   CYS A  10       5.312  10.311  -2.853  1.00  0.00           N  
ATOM    161  CA  CYS A  10       4.576  11.549  -2.602  1.00  0.00           C  
ATOM    162  C   CYS A  10       4.371  12.336  -3.902  1.00  0.00           C  
ATOM    163  O   CYS A  10       5.256  12.344  -4.762  1.00  0.00           O  
ATOM    164  CB  CYS A  10       5.361  12.404  -1.596  1.00  0.00           C  
ATOM    165  SG  CYS A  10       5.688  11.472  -0.068  1.00  0.00           S  
ATOM    166  H   CYS A  10       6.156  10.179  -2.315  1.00  0.00           H  
ATOM    167  HA  CYS A  10       3.608  11.303  -2.166  1.00  0.00           H  
ATOM    168  HB2 CYS A  10       6.307  12.715  -2.044  1.00  0.00           H  
ATOM    169  HB3 CYS A  10       4.785  13.301  -1.359  1.00  0.00           H  
ATOM    170  HG  CYS A  10       6.381  12.444   0.548  1.00  0.00           H  
ATOM    171  N   ASN A  11       3.241  13.044  -4.026  1.00  0.00           N  
ATOM    172  CA  ASN A  11       2.980  13.936  -5.156  1.00  0.00           C  
ATOM    173  C   ASN A  11       1.998  15.050  -4.775  1.00  0.00           C  
ATOM    174  O   ASN A  11       1.239  14.919  -3.814  1.00  0.00           O  
ATOM    175  CB  ASN A  11       2.425  13.145  -6.365  1.00  0.00           C  
ATOM    176  CG  ASN A  11       0.897  13.105  -6.433  1.00  0.00           C  
ATOM    177  OD1 ASN A  11       0.288  13.757  -7.277  1.00  0.00           O  
ATOM    178  ND2 ASN A  11       0.253  12.396  -5.523  1.00  0.00           N  
ATOM    179  H   ASN A  11       2.554  13.041  -3.278  1.00  0.00           H  
ATOM    180  HA  ASN A  11       3.927  14.391  -5.451  1.00  0.00           H  
ATOM    181  HB2 ASN A  11       2.781  13.629  -7.275  1.00  0.00           H  
ATOM    182  HB3 ASN A  11       2.817  12.128  -6.373  1.00  0.00           H  
ATOM    183 HD21 ASN A  11       0.746  11.938  -4.767  1.00  0.00           H  
ATOM    184 HD22 ASN A  11      -0.752  12.289  -5.572  1.00  0.00           H  
ATOM    185  N   LYS A  12       1.952  16.089  -5.614  1.00  0.00           N  
ATOM    186  CA  LYS A  12       0.796  16.985  -5.760  1.00  0.00           C  
ATOM    187  C   LYS A  12       0.263  16.944  -7.195  1.00  0.00           C  
ATOM    188  O   LYS A  12      -0.923  17.178  -7.421  1.00  0.00           O  
ATOM    189  CB  LYS A  12       1.194  18.449  -5.490  1.00  0.00           C  
ATOM    190  CG  LYS A  12       1.798  18.773  -4.116  1.00  0.00           C  
ATOM    191  CD  LYS A  12       2.245  20.246  -4.127  1.00  0.00           C  
ATOM    192  CE  LYS A  12       2.907  20.686  -2.813  1.00  0.00           C  
ATOM    193  NZ  LYS A  12       1.970  21.388  -1.901  1.00  0.00           N  
ATOM    194  H   LYS A  12       2.696  16.179  -6.290  1.00  0.00           H  
ATOM    195  HA  LYS A  12      -0.002  16.689  -5.074  1.00  0.00           H  
ATOM    196  HB2 LYS A  12       1.909  18.751  -6.259  1.00  0.00           H  
ATOM    197  HB3 LYS A  12       0.302  19.066  -5.618  1.00  0.00           H  
ATOM    198  HG2 LYS A  12       1.054  18.606  -3.337  1.00  0.00           H  
ATOM    199  HG3 LYS A  12       2.665  18.137  -3.935  1.00  0.00           H  
ATOM    200  HD2 LYS A  12       2.980  20.372  -4.923  1.00  0.00           H  
ATOM    201  HD3 LYS A  12       1.396  20.892  -4.358  1.00  0.00           H  
ATOM    202  HE2 LYS A  12       3.335  19.813  -2.317  1.00  0.00           H  
ATOM    203  HE3 LYS A  12       3.728  21.363  -3.060  1.00  0.00           H  
ATOM    204  HZ1 LYS A  12       1.608  22.228  -2.329  1.00  0.00           H  
ATOM    205  HZ2 LYS A  12       1.194  20.801  -1.641  1.00  0.00           H  
ATOM    206  HZ3 LYS A  12       2.445  21.667  -1.055  1.00  0.00           H  
ATOM    207  N   GLN A  13       1.160  16.723  -8.163  1.00  0.00           N  
ATOM    208  CA  GLN A  13       1.076  17.320  -9.493  1.00  0.00           C  
ATOM    209  C   GLN A  13      -0.075  16.787 -10.345  1.00  0.00           C  
ATOM    210  O   GLN A  13      -0.489  17.466 -11.286  1.00  0.00           O  
ATOM    211  CB  GLN A  13       2.419  17.118 -10.210  1.00  0.00           C  
ATOM    212  CG  GLN A  13       3.538  17.980  -9.606  1.00  0.00           C  
ATOM    213  CD  GLN A  13       4.840  17.803 -10.384  1.00  0.00           C  
ATOM    214  OE1 GLN A  13       5.115  18.519 -11.343  1.00  0.00           O  
ATOM    215  NE2 GLN A  13       5.660  16.834 -10.007  1.00  0.00           N  
ATOM    216  H   GLN A  13       2.066  16.375  -7.902  1.00  0.00           H  
ATOM    217  HA  GLN A  13       0.906  18.392  -9.371  1.00  0.00           H  
ATOM    218  HB2 GLN A  13       2.702  16.064 -10.178  1.00  0.00           H  
ATOM    219  HB3 GLN A  13       2.305  17.399 -11.253  1.00  0.00           H  
ATOM    220  HG2 GLN A  13       3.242  19.031  -9.638  1.00  0.00           H  
ATOM    221  HG3 GLN A  13       3.699  17.709  -8.560  1.00  0.00           H  
ATOM    222 HE21 GLN A  13       5.447  16.266  -9.198  1.00  0.00           H  
ATOM    223 HE22 GLN A  13       6.521  16.685 -10.505  1.00  0.00           H  
ATOM    224  N   ASP A  14      -0.602  15.600 -10.039  1.00  0.00           N  
ATOM    225  CA  ASP A  14      -1.800  15.068 -10.693  1.00  0.00           C  
ATOM    226  C   ASP A  14      -2.672  14.320  -9.679  1.00  0.00           C  
ATOM    227  O   ASP A  14      -3.478  13.466 -10.041  1.00  0.00           O  
ATOM    228  CB  ASP A  14      -1.387  14.186 -11.882  1.00  0.00           C  
ATOM    229  CG  ASP A  14      -2.563  13.840 -12.810  1.00  0.00           C  
ATOM    230  OD1 ASP A  14      -3.417  14.713 -13.093  1.00  0.00           O  
ATOM    231  OD2 ASP A  14      -2.580  12.702 -13.331  1.00  0.00           O  
ATOM    232  H   ASP A  14      -0.185  15.051  -9.295  1.00  0.00           H  
ATOM    233  HA  ASP A  14      -2.389  15.905 -11.070  1.00  0.00           H  
ATOM    234  HB2 ASP A  14      -0.634  14.712 -12.472  1.00  0.00           H  
ATOM    235  HB3 ASP A  14      -0.931  13.269 -11.502  1.00  0.00           H  
ATOM    236  N   ASN A  15      -2.460  14.602  -8.385  1.00  0.00           N  
ATOM    237  CA  ASN A  15      -2.955  13.901  -7.191  1.00  0.00           C  
ATOM    238  C   ASN A  15      -2.595  12.401  -7.125  1.00  0.00           C  
ATOM    239  O   ASN A  15      -2.571  11.839  -6.027  1.00  0.00           O  
ATOM    240  CB  ASN A  15      -4.468  14.166  -7.020  1.00  0.00           C  
ATOM    241  CG  ASN A  15      -4.987  14.139  -5.578  1.00  0.00           C  
ATOM    242  OD1 ASN A  15      -5.771  15.000  -5.191  1.00  0.00           O  
ATOM    243  ND2 ASN A  15      -4.605  13.180  -4.751  1.00  0.00           N  
ATOM    244  H   ASN A  15      -1.813  15.358  -8.193  1.00  0.00           H  
ATOM    245  HA  ASN A  15      -2.456  14.377  -6.346  1.00  0.00           H  
ATOM    246  HB2 ASN A  15      -4.693  15.155  -7.423  1.00  0.00           H  
ATOM    247  HB3 ASN A  15      -5.021  13.442  -7.617  1.00  0.00           H  
ATOM    248 HD21 ASN A  15      -3.888  12.517  -5.030  1.00  0.00           H  
ATOM    249 HD22 ASN A  15      -5.001  13.138  -3.811  1.00  0.00           H  
ATOM    250  N   ARG A  16      -2.284  11.736  -8.240  1.00  0.00           N  
ATOM    251  CA  ARG A  16      -1.978  10.309  -8.297  1.00  0.00           C  
ATOM    252  C   ARG A  16      -0.694   9.984  -7.535  1.00  0.00           C  
ATOM    253  O   ARG A  16       0.392  10.365  -7.971  1.00  0.00           O  
ATOM    254  CB  ARG A  16      -1.874   9.832  -9.756  1.00  0.00           C  
ATOM    255  CG  ARG A  16      -3.245   9.837 -10.448  1.00  0.00           C  
ATOM    256  CD  ARG A  16      -3.198   9.120 -11.801  1.00  0.00           C  
ATOM    257  NE  ARG A  16      -2.620   9.965 -12.851  1.00  0.00           N  
ATOM    258  CZ  ARG A  16      -2.212   9.576 -14.061  1.00  0.00           C  
ATOM    259  NH1 ARG A  16      -2.126   8.293 -14.400  1.00  0.00           N  
ATOM    260  NH2 ARG A  16      -1.905  10.530 -14.930  1.00  0.00           N  
ATOM    261  H   ARG A  16      -2.350  12.237  -9.115  1.00  0.00           H  
ATOM    262  HA  ARG A  16      -2.801   9.780  -7.823  1.00  0.00           H  
ATOM    263  HB2 ARG A  16      -1.172  10.458 -10.309  1.00  0.00           H  
ATOM    264  HB3 ARG A  16      -1.494   8.809  -9.749  1.00  0.00           H  
ATOM    265  HG2 ARG A  16      -3.953   9.317  -9.806  1.00  0.00           H  
ATOM    266  HG3 ARG A  16      -3.600  10.857 -10.585  1.00  0.00           H  
ATOM    267  HD2 ARG A  16      -2.622   8.203 -11.695  1.00  0.00           H  
ATOM    268  HD3 ARG A  16      -4.214   8.865 -12.099  1.00  0.00           H  
ATOM    269  HE  ARG A  16      -2.667  10.975 -12.696  1.00  0.00           H  
ATOM    270 HH11 ARG A  16      -2.302   7.544 -13.715  1.00  0.00           H  
ATOM    271 HH12 ARG A  16      -1.839   8.001 -15.321  1.00  0.00           H  
ATOM    272 HH21 ARG A  16      -2.033  11.501 -14.626  1.00  0.00           H  
ATOM    273 HH22 ARG A  16      -1.599  10.345 -15.874  1.00  0.00           H  
ATOM    274  N   HIS A  17      -0.821   9.270  -6.419  1.00  0.00           N  
ATOM    275  CA  HIS A  17       0.299   8.645  -5.729  1.00  0.00           C  
ATOM    276  C   HIS A  17       0.573   7.281  -6.367  1.00  0.00           C  
ATOM    277  O   HIS A  17      -0.269   6.720  -7.074  1.00  0.00           O  
ATOM    278  CB  HIS A  17      -0.033   8.482  -4.236  1.00  0.00           C  
ATOM    279  CG  HIS A  17      -0.002   9.782  -3.480  1.00  0.00           C  
ATOM    280  ND1 HIS A  17      -1.060  10.624  -3.232  1.00  0.00           N  
ATOM    281  CD2 HIS A  17       1.105  10.350  -2.916  1.00  0.00           C  
ATOM    282  CE1 HIS A  17      -0.596  11.683  -2.545  1.00  0.00           C  
ATOM    283  NE2 HIS A  17       0.735  11.576  -2.354  1.00  0.00           N  
ATOM    284  H   HIS A  17      -1.737   8.888  -6.215  1.00  0.00           H  
ATOM    285  HA  HIS A  17       1.190   9.267  -5.830  1.00  0.00           H  
ATOM    286  HB2 HIS A  17      -1.013   8.018  -4.123  1.00  0.00           H  
ATOM    287  HB3 HIS A  17       0.702   7.821  -3.777  1.00  0.00           H  
ATOM    288  HD1 HIS A  17      -2.034  10.434  -3.454  1.00  0.00           H  
ATOM    289  HD2 HIS A  17       2.092   9.918  -2.912  1.00  0.00           H  
ATOM    290  HE1 HIS A  17      -1.207  12.508  -2.198  1.00  0.00           H  
ATOM    291  N   VAL A  18       1.732   6.706  -6.056  1.00  0.00           N  
ATOM    292  CA  VAL A  18       2.072   5.325  -6.378  1.00  0.00           C  
ATOM    293  C   VAL A  18       2.718   4.756  -5.123  1.00  0.00           C  
ATOM    294  O   VAL A  18       3.453   5.462  -4.424  1.00  0.00           O  
ATOM    295  CB  VAL A  18       2.992   5.264  -7.615  1.00  0.00           C  
ATOM    296  CG1 VAL A  18       3.471   3.839  -7.939  1.00  0.00           C  
ATOM    297  CG2 VAL A  18       2.260   5.800  -8.853  1.00  0.00           C  
ATOM    298  H   VAL A  18       2.381   7.185  -5.443  1.00  0.00           H  
ATOM    299  HA  VAL A  18       1.158   4.770  -6.585  1.00  0.00           H  
ATOM    300  HB  VAL A  18       3.870   5.885  -7.434  1.00  0.00           H  
ATOM    301 HG11 VAL A  18       4.001   3.407  -7.092  1.00  0.00           H  
ATOM    302 HG12 VAL A  18       2.623   3.202  -8.194  1.00  0.00           H  
ATOM    303 HG13 VAL A  18       4.165   3.867  -8.777  1.00  0.00           H  
ATOM    304 HG21 VAL A  18       1.379   5.198  -9.058  1.00  0.00           H  
ATOM    305 HG22 VAL A  18       1.958   6.835  -8.712  1.00  0.00           H  
ATOM    306 HG23 VAL A  18       2.913   5.759  -9.714  1.00  0.00           H  
ATOM    307  N   LEU A  19       2.403   3.502  -4.804  1.00  0.00           N  
ATOM    308  CA  LEU A  19       2.935   2.804  -3.646  1.00  0.00           C  
ATOM    309  C   LEU A  19       3.116   1.332  -4.007  1.00  0.00           C  
ATOM    310  O   LEU A  19       2.393   0.793  -4.847  1.00  0.00           O  
ATOM    311  CB  LEU A  19       2.058   2.956  -2.373  1.00  0.00           C  
ATOM    312  CG  LEU A  19       0.626   3.537  -2.478  1.00  0.00           C  
ATOM    313  CD1 LEU A  19      -0.216   3.043  -1.300  1.00  0.00           C  
ATOM    314  CD2 LEU A  19       0.605   5.073  -2.416  1.00  0.00           C  
ATOM    315  H   LEU A  19       1.804   2.962  -5.425  1.00  0.00           H  
ATOM    316  HA  LEU A  19       3.923   3.208  -3.427  1.00  0.00           H  
ATOM    317  HB2 LEU A  19       1.986   1.967  -1.918  1.00  0.00           H  
ATOM    318  HB3 LEU A  19       2.614   3.565  -1.662  1.00  0.00           H  
ATOM    319  HG  LEU A  19       0.147   3.196  -3.397  1.00  0.00           H  
ATOM    320 HD11 LEU A  19      -0.241   1.957  -1.312  1.00  0.00           H  
ATOM    321 HD12 LEU A  19       0.214   3.387  -0.359  1.00  0.00           H  
ATOM    322 HD13 LEU A  19      -1.238   3.413  -1.387  1.00  0.00           H  
ATOM    323 HD21 LEU A  19       1.150   5.426  -1.539  1.00  0.00           H  
ATOM    324 HD22 LEU A  19       1.055   5.499  -3.304  1.00  0.00           H  
ATOM    325 HD23 LEU A  19      -0.420   5.435  -2.355  1.00  0.00           H  
ATOM    326  N   MET A  20       4.077   0.679  -3.353  1.00  0.00           N  
ATOM    327  CA  MET A  20       4.225  -0.767  -3.401  1.00  0.00           C  
ATOM    328  C   MET A  20       3.276  -1.352  -2.363  1.00  0.00           C  
ATOM    329  O   MET A  20       3.529  -1.235  -1.160  1.00  0.00           O  
ATOM    330  CB  MET A  20       5.681  -1.191  -3.145  1.00  0.00           C  
ATOM    331  CG  MET A  20       6.497  -1.157  -4.444  1.00  0.00           C  
ATOM    332  SD  MET A  20       8.297  -1.237  -4.246  1.00  0.00           S  
ATOM    333  CE  MET A  20       8.493  -2.751  -3.269  1.00  0.00           C  
ATOM    334  H   MET A  20       4.579   1.177  -2.627  1.00  0.00           H  
ATOM    335  HA  MET A  20       3.935  -1.125  -4.385  1.00  0.00           H  
ATOM    336  HB2 MET A  20       6.131  -0.535  -2.400  1.00  0.00           H  
ATOM    337  HB3 MET A  20       5.694  -2.211  -2.761  1.00  0.00           H  
ATOM    338  HG2 MET A  20       6.183  -1.994  -5.068  1.00  0.00           H  
ATOM    339  HG3 MET A  20       6.265  -0.237  -4.980  1.00  0.00           H  
ATOM    340  HE1 MET A  20       8.033  -2.620  -2.288  1.00  0.00           H  
ATOM    341  HE2 MET A  20       8.025  -3.588  -3.786  1.00  0.00           H  
ATOM    342  HE3 MET A  20       9.555  -2.958  -3.135  1.00  0.00           H  
ATOM    343  N   LEU A  21       2.168  -1.932  -2.834  1.00  0.00           N  
ATOM    344  CA  LEU A  21       1.297  -2.776  -2.024  1.00  0.00           C  
ATOM    345  C   LEU A  21       2.021  -4.093  -1.830  1.00  0.00           C  
ATOM    346  O   LEU A  21       2.477  -4.686  -2.805  1.00  0.00           O  
ATOM    347  CB  LEU A  21      -0.040  -3.063  -2.740  1.00  0.00           C  
ATOM    348  CG  LEU A  21      -1.176  -2.124  -2.316  1.00  0.00           C  
ATOM    349  CD1 LEU A  21      -0.830  -0.660  -2.611  1.00  0.00           C  
ATOM    350  CD2 LEU A  21      -2.476  -2.522  -3.023  1.00  0.00           C  
ATOM    351  H   LEU A  21       2.071  -2.007  -3.836  1.00  0.00           H  
ATOM    352  HA  LEU A  21       1.117  -2.311  -1.052  1.00  0.00           H  
ATOM    353  HB2 LEU A  21       0.100  -3.026  -3.823  1.00  0.00           H  
ATOM    354  HB3 LEU A  21      -0.355  -4.078  -2.491  1.00  0.00           H  
ATOM    355  HG  LEU A  21      -1.329  -2.239  -1.245  1.00  0.00           H  
ATOM    356 HD11 LEU A  21      -0.056  -0.321  -1.925  1.00  0.00           H  
ATOM    357 HD12 LEU A  21      -0.461  -0.562  -3.630  1.00  0.00           H  
ATOM    358 HD13 LEU A  21      -1.711  -0.029  -2.483  1.00  0.00           H  
ATOM    359 HD21 LEU A  21      -2.369  -2.423  -4.103  1.00  0.00           H  
ATOM    360 HD22 LEU A  21      -2.722  -3.558  -2.782  1.00  0.00           H  
ATOM    361 HD23 LEU A  21      -3.294  -1.888  -2.681  1.00  0.00           H  
ATOM    362  N   CYS A  22       2.067  -4.592  -0.604  1.00  0.00           N  
ATOM    363  CA  CYS A  22       2.705  -5.852  -0.281  1.00  0.00           C  
ATOM    364  C   CYS A  22       1.811  -6.631   0.673  1.00  0.00           C  
ATOM    365  O   CYS A  22       0.889  -6.068   1.263  1.00  0.00           O  
ATOM    366  CB  CYS A  22       4.078  -5.571   0.341  1.00  0.00           C  
ATOM    367  SG  CYS A  22       5.096  -4.608  -0.819  1.00  0.00           S  
ATOM    368  H   CYS A  22       1.742  -4.034   0.176  1.00  0.00           H  
ATOM    369  HA  CYS A  22       2.837  -6.446  -1.186  1.00  0.00           H  
ATOM    370  HB2 CYS A  22       3.948  -5.015   1.272  1.00  0.00           H  
ATOM    371  HB3 CYS A  22       4.573  -6.517   0.563  1.00  0.00           H  
ATOM    372  HG  CYS A  22       6.198  -4.572  -0.062  1.00  0.00           H  
ATOM    373  N   ASP A  23       2.094  -7.920   0.835  1.00  0.00           N  
ATOM    374  CA  ASP A  23       1.554  -8.745   1.915  1.00  0.00           C  
ATOM    375  C   ASP A  23       1.734  -8.020   3.258  1.00  0.00           C  
ATOM    376  O   ASP A  23       2.717  -7.296   3.431  1.00  0.00           O  
ATOM    377  CB  ASP A  23       2.287 -10.095   1.903  1.00  0.00           C  
ATOM    378  CG  ASP A  23       2.294 -10.784   3.274  1.00  0.00           C  
ATOM    379  OD1 ASP A  23       1.256 -11.361   3.668  1.00  0.00           O  
ATOM    380  OD2 ASP A  23       3.350 -10.729   3.941  1.00  0.00           O  
ATOM    381  H   ASP A  23       2.859  -8.303   0.292  1.00  0.00           H  
ATOM    382  HA  ASP A  23       0.491  -8.918   1.747  1.00  0.00           H  
ATOM    383  HB2 ASP A  23       1.828 -10.747   1.156  1.00  0.00           H  
ATOM    384  HB3 ASP A  23       3.322  -9.929   1.601  1.00  0.00           H  
ATOM    385  N   ALA A  24       0.808  -8.219   4.201  1.00  0.00           N  
ATOM    386  CA  ALA A  24       0.866  -7.699   5.566  1.00  0.00           C  
ATOM    387  C   ALA A  24       1.999  -8.374   6.370  1.00  0.00           C  
ATOM    388  O   ALA A  24       1.752  -9.162   7.288  1.00  0.00           O  
ATOM    389  CB  ALA A  24      -0.513  -7.845   6.227  1.00  0.00           C  
ATOM    390  H   ALA A  24       0.036  -8.835   3.989  1.00  0.00           H  
ATOM    391  HA  ALA A  24       1.088  -6.634   5.509  1.00  0.00           H  
ATOM    392  HB1 ALA A  24      -1.262  -7.305   5.645  1.00  0.00           H  
ATOM    393  HB2 ALA A  24      -0.795  -8.897   6.288  1.00  0.00           H  
ATOM    394  HB3 ALA A  24      -0.483  -7.424   7.233  1.00  0.00           H  
ATOM    395  N   GLY A  25       3.243  -8.097   5.980  1.00  0.00           N  
ATOM    396  CA  GLY A  25       4.461  -8.754   6.438  1.00  0.00           C  
ATOM    397  C   GLY A  25       5.589  -8.640   5.402  1.00  0.00           C  
ATOM    398  O   GLY A  25       6.760  -8.792   5.756  1.00  0.00           O  
ATOM    399  H   GLY A  25       3.341  -7.454   5.202  1.00  0.00           H  
ATOM    400  HA2 GLY A  25       4.780  -8.298   7.376  1.00  0.00           H  
ATOM    401  HA3 GLY A  25       4.253  -9.811   6.608  1.00  0.00           H  
ATOM    402  N   GLY A  26       5.261  -8.333   4.140  1.00  0.00           N  
ATOM    403  CA  GLY A  26       6.206  -8.059   3.064  1.00  0.00           C  
ATOM    404  C   GLY A  26       6.550  -9.288   2.219  1.00  0.00           C  
ATOM    405  O   GLY A  26       7.410  -9.180   1.343  1.00  0.00           O  
ATOM    406  H   GLY A  26       4.279  -8.253   3.904  1.00  0.00           H  
ATOM    407  HA2 GLY A  26       5.767  -7.305   2.412  1.00  0.00           H  
ATOM    408  HA3 GLY A  26       7.127  -7.652   3.483  1.00  0.00           H  
ATOM    409  N   ALA A  27       5.922 -10.447   2.457  1.00  0.00           N  
ATOM    410  CA  ALA A  27       6.315 -11.711   1.832  1.00  0.00           C  
ATOM    411  C   ALA A  27       6.053 -11.766   0.315  1.00  0.00           C  
ATOM    412  O   ALA A  27       6.647 -12.595  -0.376  1.00  0.00           O  
ATOM    413  CB  ALA A  27       5.584 -12.866   2.527  1.00  0.00           C  
ATOM    414  H   ALA A  27       5.178 -10.476   3.153  1.00  0.00           H  
ATOM    415  HA  ALA A  27       7.387 -11.842   1.991  1.00  0.00           H  
ATOM    416  HB1 ALA A  27       5.781 -12.839   3.599  1.00  0.00           H  
ATOM    417  HB2 ALA A  27       4.511 -12.790   2.351  1.00  0.00           H  
ATOM    418  HB3 ALA A  27       5.941 -13.816   2.128  1.00  0.00           H  
ATOM    419  N   ILE A  28       5.170 -10.909  -0.201  1.00  0.00           N  
ATOM    420  CA  ILE A  28       4.777 -10.798  -1.607  1.00  0.00           C  
ATOM    421  C   ILE A  28       4.668  -9.292  -1.856  1.00  0.00           C  
ATOM    422  O   ILE A  28       4.256  -8.566  -0.945  1.00  0.00           O  
ATOM    423  CB  ILE A  28       3.432 -11.536  -1.862  1.00  0.00           C  
ATOM    424  CG1 ILE A  28       3.526 -13.033  -1.473  1.00  0.00           C  
ATOM    425  CG2 ILE A  28       2.986 -11.388  -3.331  1.00  0.00           C  
ATOM    426  CD1 ILE A  28       2.241 -13.845  -1.689  1.00  0.00           C  
ATOM    427  H   ILE A  28       4.776 -10.206   0.408  1.00  0.00           H  
ATOM    428  HA  ILE A  28       5.557 -11.219  -2.245  1.00  0.00           H  
ATOM    429  HB  ILE A  28       2.667 -11.073  -1.235  1.00  0.00           H  
ATOM    430 HG12 ILE A  28       4.333 -13.503  -2.036  1.00  0.00           H  
ATOM    431 HG13 ILE A  28       3.763 -13.110  -0.412  1.00  0.00           H  
ATOM    432 HG21 ILE A  28       2.873 -10.337  -3.598  1.00  0.00           H  
ATOM    433 HG22 ILE A  28       3.711 -11.856  -3.997  1.00  0.00           H  
ATOM    434 HG23 ILE A  28       2.011 -11.848  -3.483  1.00  0.00           H  
ATOM    435 HD11 ILE A  28       1.397 -13.338  -1.219  1.00  0.00           H  
ATOM    436 HD12 ILE A  28       2.048 -13.980  -2.752  1.00  0.00           H  
ATOM    437 HD13 ILE A  28       2.360 -14.830  -1.235  1.00  0.00           H  
ATOM    438  N   LYS A  29       5.029  -8.812  -3.051  1.00  0.00           N  
ATOM    439  CA  LYS A  29       5.082  -7.383  -3.357  1.00  0.00           C  
ATOM    440  C   LYS A  29       4.475  -7.112  -4.732  1.00  0.00           C  
ATOM    441  O   LYS A  29       4.612  -7.914  -5.658  1.00  0.00           O  
ATOM    442  CB  LYS A  29       6.530  -6.860  -3.267  1.00  0.00           C  
ATOM    443  CG  LYS A  29       7.197  -7.151  -1.904  1.00  0.00           C  
ATOM    444  CD  LYS A  29       8.414  -6.245  -1.656  1.00  0.00           C  
ATOM    445  CE  LYS A  29       8.955  -6.327  -0.217  1.00  0.00           C  
ATOM    446  NZ  LYS A  29       9.475  -7.669   0.148  1.00  0.00           N  
ATOM    447  H   LYS A  29       5.295  -9.449  -3.792  1.00  0.00           H  
ATOM    448  HA  LYS A  29       4.489  -6.842  -2.619  1.00  0.00           H  
ATOM    449  HB2 LYS A  29       7.134  -7.304  -4.060  1.00  0.00           H  
ATOM    450  HB3 LYS A  29       6.500  -5.782  -3.429  1.00  0.00           H  
ATOM    451  HG2 LYS A  29       6.476  -6.992  -1.105  1.00  0.00           H  
ATOM    452  HG3 LYS A  29       7.509  -8.196  -1.874  1.00  0.00           H  
ATOM    453  HD2 LYS A  29       9.205  -6.491  -2.366  1.00  0.00           H  
ATOM    454  HD3 LYS A  29       8.116  -5.211  -1.829  1.00  0.00           H  
ATOM    455  HE2 LYS A  29       9.761  -5.596  -0.118  1.00  0.00           H  
ATOM    456  HE3 LYS A  29       8.164  -6.043   0.480  1.00  0.00           H  
ATOM    457  HZ1 LYS A  29       8.718  -8.335   0.280  1.00  0.00           H  
ATOM    458  HZ2 LYS A  29      10.116  -8.023  -0.546  1.00  0.00           H  
ATOM    459  HZ3 LYS A  29       9.973  -7.626   1.027  1.00  0.00           H  
ATOM    460  N   MET A  30       3.813  -5.969  -4.856  1.00  0.00           N  
ATOM    461  CA  MET A  30       3.062  -5.478  -6.004  1.00  0.00           C  
ATOM    462  C   MET A  30       3.272  -3.959  -6.071  1.00  0.00           C  
ATOM    463  O   MET A  30       3.968  -3.380  -5.235  1.00  0.00           O  
ATOM    464  CB  MET A  30       1.564  -5.812  -5.838  1.00  0.00           C  
ATOM    465  CG  MET A  30       1.247  -7.306  -5.971  1.00  0.00           C  
ATOM    466  SD  MET A  30      -0.483  -7.771  -5.656  1.00  0.00           S  
ATOM    467  CE  MET A  30      -1.377  -6.660  -6.781  1.00  0.00           C  
ATOM    468  H   MET A  30       3.758  -5.355  -4.048  1.00  0.00           H  
ATOM    469  HA  MET A  30       3.430  -5.926  -6.925  1.00  0.00           H  
ATOM    470  HB2 MET A  30       1.213  -5.459  -4.869  1.00  0.00           H  
ATOM    471  HB3 MET A  30       0.996  -5.283  -6.601  1.00  0.00           H  
ATOM    472  HG2 MET A  30       1.506  -7.629  -6.978  1.00  0.00           H  
ATOM    473  HG3 MET A  30       1.866  -7.864  -5.269  1.00  0.00           H  
ATOM    474  HE1 MET A  30      -1.285  -5.631  -6.434  1.00  0.00           H  
ATOM    475  HE2 MET A  30      -0.968  -6.744  -7.788  1.00  0.00           H  
ATOM    476  HE3 MET A  30      -2.434  -6.930  -6.797  1.00  0.00           H  
ATOM    477  N   ILE A  31       2.661  -3.296  -7.049  1.00  0.00           N  
ATOM    478  CA  ILE A  31       2.662  -1.847  -7.227  1.00  0.00           C  
ATOM    479  C   ILE A  31       1.199  -1.472  -7.457  1.00  0.00           C  
ATOM    480  O   ILE A  31       0.483  -2.225  -8.123  1.00  0.00           O  
ATOM    481  CB  ILE A  31       3.529  -1.445  -8.448  1.00  0.00           C  
ATOM    482  CG1 ILE A  31       4.963  -2.028  -8.448  1.00  0.00           C  
ATOM    483  CG2 ILE A  31       3.625   0.090  -8.556  1.00  0.00           C  
ATOM    484  CD1 ILE A  31       5.461  -2.275  -9.878  1.00  0.00           C  
ATOM    485  H   ILE A  31       2.091  -3.816  -7.713  1.00  0.00           H  
ATOM    486  HA  ILE A  31       3.037  -1.356  -6.330  1.00  0.00           H  
ATOM    487  HB  ILE A  31       3.017  -1.817  -9.338  1.00  0.00           H  
ATOM    488 HG12 ILE A  31       5.643  -1.352  -7.929  1.00  0.00           H  
ATOM    489 HG13 ILE A  31       5.001  -2.983  -7.930  1.00  0.00           H  
ATOM    490 HG21 ILE A  31       2.650   0.517  -8.790  1.00  0.00           H  
ATOM    491 HG22 ILE A  31       3.980   0.513  -7.614  1.00  0.00           H  
ATOM    492 HG23 ILE A  31       4.310   0.380  -9.350  1.00  0.00           H  
ATOM    493 HD11 ILE A  31       4.846  -3.038 -10.356  1.00  0.00           H  
ATOM    494 HD12 ILE A  31       5.404  -1.364 -10.466  1.00  0.00           H  
ATOM    495 HD13 ILE A  31       6.493  -2.622  -9.852  1.00  0.00           H  
ATOM    496  N   ALA A  32       0.763  -0.311  -6.964  1.00  0.00           N  
ATOM    497  CA  ALA A  32      -0.511   0.282  -7.330  1.00  0.00           C  
ATOM    498  C   ALA A  32      -0.323   1.778  -7.553  1.00  0.00           C  
ATOM    499  O   ALA A  32       0.421   2.441  -6.827  1.00  0.00           O  
ATOM    500  CB  ALA A  32      -1.569   0.028  -6.254  1.00  0.00           C  
ATOM    501  H   ALA A  32       1.385   0.266  -6.403  1.00  0.00           H  
ATOM    502  HA  ALA A  32      -0.852  -0.166  -8.259  1.00  0.00           H  
ATOM    503  HB1 ALA A  32      -1.632  -1.038  -6.036  1.00  0.00           H  
ATOM    504  HB2 ALA A  32      -1.317   0.582  -5.351  1.00  0.00           H  
ATOM    505  HB3 ALA A  32      -2.538   0.376  -6.615  1.00  0.00           H  
ATOM    506  N   GLU A  33      -1.039   2.296  -8.542  1.00  0.00           N  
ATOM    507  CA  GLU A  33      -1.242   3.712  -8.771  1.00  0.00           C  
ATOM    508  C   GLU A  33      -2.600   4.023  -8.154  1.00  0.00           C  
ATOM    509  O   GLU A  33      -3.565   3.281  -8.372  1.00  0.00           O  
ATOM    510  CB  GLU A  33      -1.207   3.974 -10.284  1.00  0.00           C  
ATOM    511  CG  GLU A  33      -1.353   5.459 -10.638  1.00  0.00           C  
ATOM    512  CD  GLU A  33      -1.264   5.682 -12.158  1.00  0.00           C  
ATOM    513  OE1 GLU A  33      -0.168   5.520 -12.738  1.00  0.00           O  
ATOM    514  OE2 GLU A  33      -2.288   6.053 -12.775  1.00  0.00           O  
ATOM    515  H   GLU A  33      -1.693   1.681  -9.017  1.00  0.00           H  
ATOM    516  HA  GLU A  33      -0.465   4.292  -8.274  1.00  0.00           H  
ATOM    517  HB2 GLU A  33      -0.253   3.615 -10.672  1.00  0.00           H  
ATOM    518  HB3 GLU A  33      -2.008   3.414 -10.768  1.00  0.00           H  
ATOM    519  HG2 GLU A  33      -2.313   5.821 -10.270  1.00  0.00           H  
ATOM    520  HG3 GLU A  33      -0.569   6.032 -10.139  1.00  0.00           H  
ATOM    521  N   VAL A  34      -2.673   5.082  -7.353  1.00  0.00           N  
ATOM    522  CA  VAL A  34      -3.837   5.397  -6.538  1.00  0.00           C  
ATOM    523  C   VAL A  34      -4.049   6.912  -6.556  1.00  0.00           C  
ATOM    524  O   VAL A  34      -3.127   7.665  -6.868  1.00  0.00           O  
ATOM    525  CB  VAL A  34      -3.666   4.836  -5.099  1.00  0.00           C  
ATOM    526  CG1 VAL A  34      -3.233   3.357  -5.054  1.00  0.00           C  
ATOM    527  CG2 VAL A  34      -2.656   5.617  -4.245  1.00  0.00           C  
ATOM    528  H   VAL A  34      -1.876   5.708  -7.257  1.00  0.00           H  
ATOM    529  HA  VAL A  34      -4.710   4.927  -6.985  1.00  0.00           H  
ATOM    530  HB  VAL A  34      -4.635   4.906  -4.606  1.00  0.00           H  
ATOM    531 HG11 VAL A  34      -3.855   2.755  -5.710  1.00  0.00           H  
ATOM    532 HG12 VAL A  34      -2.193   3.251  -5.368  1.00  0.00           H  
ATOM    533 HG13 VAL A  34      -3.331   2.975  -4.037  1.00  0.00           H  
ATOM    534 HG21 VAL A  34      -1.674   5.610  -4.717  1.00  0.00           H  
ATOM    535 HG22 VAL A  34      -2.991   6.646  -4.114  1.00  0.00           H  
ATOM    536 HG23 VAL A  34      -2.586   5.164  -3.255  1.00  0.00           H  
ATOM    537  N   LYS A  35      -5.229   7.384  -6.164  1.00  0.00           N  
ATOM    538  CA  LYS A  35      -5.454   8.780  -5.791  1.00  0.00           C  
ATOM    539  C   LYS A  35      -5.776   8.790  -4.299  1.00  0.00           C  
ATOM    540  O   LYS A  35      -6.216   7.768  -3.769  1.00  0.00           O  
ATOM    541  CB  LYS A  35      -6.566   9.375  -6.674  1.00  0.00           C  
ATOM    542  CG  LYS A  35      -6.598  10.911  -6.618  1.00  0.00           C  
ATOM    543  CD  LYS A  35      -7.555  11.539  -7.642  1.00  0.00           C  
ATOM    544  CE  LYS A  35      -7.059  11.377  -9.091  1.00  0.00           C  
ATOM    545  NZ  LYS A  35      -7.967  12.029 -10.069  1.00  0.00           N  
ATOM    546  H   LYS A  35      -5.955   6.718  -5.911  1.00  0.00           H  
ATOM    547  HA  LYS A  35      -4.536   9.347  -5.947  1.00  0.00           H  
ATOM    548  HB2 LYS A  35      -6.380   9.074  -7.703  1.00  0.00           H  
ATOM    549  HB3 LYS A  35      -7.534   8.973  -6.370  1.00  0.00           H  
ATOM    550  HG2 LYS A  35      -6.914  11.222  -5.622  1.00  0.00           H  
ATOM    551  HG3 LYS A  35      -5.592  11.293  -6.795  1.00  0.00           H  
ATOM    552  HD2 LYS A  35      -8.542  11.086  -7.534  1.00  0.00           H  
ATOM    553  HD3 LYS A  35      -7.643  12.604  -7.415  1.00  0.00           H  
ATOM    554  HE2 LYS A  35      -6.061  11.816  -9.175  1.00  0.00           H  
ATOM    555  HE3 LYS A  35      -6.981  10.313  -9.326  1.00  0.00           H  
ATOM    556  HZ1 LYS A  35      -8.893  11.628 -10.037  1.00  0.00           H  
ATOM    557  HZ2 LYS A  35      -8.049  13.021  -9.895  1.00  0.00           H  
ATOM    558  HZ3 LYS A  35      -7.622  11.916 -11.012  1.00  0.00           H  
ATOM    559  N   SER A  36      -5.566   9.915  -3.623  1.00  0.00           N  
ATOM    560  CA  SER A  36      -5.574   9.974  -2.168  1.00  0.00           C  
ATOM    561  C   SER A  36      -6.161  11.313  -1.739  1.00  0.00           C  
ATOM    562  O   SER A  36      -5.842  12.342  -2.341  1.00  0.00           O  
ATOM    563  CB  SER A  36      -4.135   9.831  -1.637  1.00  0.00           C  
ATOM    564  OG  SER A  36      -3.371   8.911  -2.407  1.00  0.00           O  
ATOM    565  H   SER A  36      -5.267  10.748  -4.105  1.00  0.00           H  
ATOM    566  HA  SER A  36      -6.181   9.165  -1.764  1.00  0.00           H  
ATOM    567  HB2 SER A  36      -3.639  10.802  -1.669  1.00  0.00           H  
ATOM    568  HB3 SER A  36      -4.174   9.500  -0.600  1.00  0.00           H  
ATOM    569  HG  SER A  36      -2.577   8.681  -1.903  1.00  0.00           H  
ATOM    570  N   ASP A  37      -6.979  11.314  -0.685  1.00  0.00           N  
ATOM    571  CA  ASP A  37      -7.523  12.541  -0.086  1.00  0.00           C  
ATOM    572  C   ASP A  37      -6.795  12.889   1.224  1.00  0.00           C  
ATOM    573  O   ASP A  37      -7.110  13.880   1.884  1.00  0.00           O  
ATOM    574  CB  ASP A  37      -9.038  12.384   0.116  1.00  0.00           C  
ATOM    575  CG  ASP A  37      -9.716  13.699   0.547  1.00  0.00           C  
ATOM    576  OD1 ASP A  37      -9.562  14.726  -0.154  1.00  0.00           O  
ATOM    577  OD2 ASP A  37     -10.476  13.702   1.542  1.00  0.00           O  
ATOM    578  H   ASP A  37      -7.232  10.432  -0.252  1.00  0.00           H  
ATOM    579  HA  ASP A  37      -7.371  13.372  -0.777  1.00  0.00           H  
ATOM    580  HB2 ASP A  37      -9.485  12.057  -0.826  1.00  0.00           H  
ATOM    581  HB3 ASP A  37      -9.219  11.603   0.856  1.00  0.00           H  
ATOM    582  N   PHE A  38      -5.797  12.077   1.590  1.00  0.00           N  
ATOM    583  CA  PHE A  38      -4.984  12.168   2.795  1.00  0.00           C  
ATOM    584  C   PHE A  38      -3.573  11.695   2.425  1.00  0.00           C  
ATOM    585  O   PHE A  38      -3.393  11.026   1.401  1.00  0.00           O  
ATOM    586  CB  PHE A  38      -5.561  11.258   3.896  1.00  0.00           C  
ATOM    587  CG  PHE A  38      -7.028  11.474   4.227  1.00  0.00           C  
ATOM    588  CD1 PHE A  38      -8.023  10.844   3.453  1.00  0.00           C  
ATOM    589  CD2 PHE A  38      -7.402  12.304   5.301  1.00  0.00           C  
ATOM    590  CE1 PHE A  38      -9.382  11.044   3.748  1.00  0.00           C  
ATOM    591  CE2 PHE A  38      -8.762  12.505   5.596  1.00  0.00           C  
ATOM    592  CZ  PHE A  38      -9.752  11.872   4.823  1.00  0.00           C  
ATOM    593  H   PHE A  38      -5.525  11.339   0.956  1.00  0.00           H  
ATOM    594  HA  PHE A  38      -4.951  13.200   3.148  1.00  0.00           H  
ATOM    595  HB2 PHE A  38      -5.433  10.221   3.588  1.00  0.00           H  
ATOM    596  HB3 PHE A  38      -4.973  11.393   4.804  1.00  0.00           H  
ATOM    597  HD1 PHE A  38      -7.743  10.220   2.614  1.00  0.00           H  
ATOM    598  HD2 PHE A  38      -6.646  12.793   5.901  1.00  0.00           H  
ATOM    599  HE1 PHE A  38     -10.145  10.563   3.151  1.00  0.00           H  
ATOM    600  HE2 PHE A  38      -9.047  13.143   6.422  1.00  0.00           H  
ATOM    601  HZ  PHE A  38     -10.798  12.023   5.054  1.00  0.00           H  
ATOM    602  N   ALA A  39      -2.579  12.013   3.257  1.00  0.00           N  
ATOM    603  CA  ALA A  39      -1.234  11.470   3.105  1.00  0.00           C  
ATOM    604  C   ALA A  39      -1.253   9.950   3.323  1.00  0.00           C  
ATOM    605  O   ALA A  39      -2.068   9.435   4.093  1.00  0.00           O  
ATOM    606  CB  ALA A  39      -0.283  12.147   4.098  1.00  0.00           C  
ATOM    607  H   ALA A  39      -2.783  12.538   4.095  1.00  0.00           H  
ATOM    608  HA  ALA A  39      -0.887  11.680   2.091  1.00  0.00           H  
ATOM    609  HB1 ALA A  39      -0.273  13.225   3.928  1.00  0.00           H  
ATOM    610  HB2 ALA A  39      -0.600  11.944   5.121  1.00  0.00           H  
ATOM    611  HB3 ALA A  39       0.728  11.761   3.959  1.00  0.00           H  
ATOM    612  N   VAL A  40      -0.311   9.249   2.695  1.00  0.00           N  
ATOM    613  CA  VAL A  40      -0.079   7.815   2.837  1.00  0.00           C  
ATOM    614  C   VAL A  40       1.435   7.625   2.707  1.00  0.00           C  
ATOM    615  O   VAL A  40       2.063   8.288   1.874  1.00  0.00           O  
ATOM    616  CB  VAL A  40      -0.916   7.033   1.793  1.00  0.00           C  
ATOM    617  CG1 VAL A  40      -0.747   7.517   0.341  1.00  0.00           C  
ATOM    618  CG2 VAL A  40      -0.651   5.522   1.845  1.00  0.00           C  
ATOM    619  H   VAL A  40       0.353   9.732   2.105  1.00  0.00           H  
ATOM    620  HA  VAL A  40      -0.389   7.502   3.835  1.00  0.00           H  
ATOM    621  HB  VAL A  40      -1.965   7.176   2.050  1.00  0.00           H  
ATOM    622 HG11 VAL A  40      -1.046   8.562   0.250  1.00  0.00           H  
ATOM    623 HG12 VAL A  40       0.291   7.412   0.022  1.00  0.00           H  
ATOM    624 HG13 VAL A  40      -1.378   6.927  -0.322  1.00  0.00           H  
ATOM    625 HG21 VAL A  40       0.367   5.300   1.519  1.00  0.00           H  
ATOM    626 HG22 VAL A  40      -0.787   5.155   2.861  1.00  0.00           H  
ATOM    627 HG23 VAL A  40      -1.352   5.000   1.193  1.00  0.00           H  
ATOM    628  N   LYS A  41       2.039   6.775   3.544  1.00  0.00           N  
ATOM    629  CA  LYS A  41       3.487   6.559   3.551  1.00  0.00           C  
ATOM    630  C   LYS A  41       3.853   5.137   3.981  1.00  0.00           C  
ATOM    631  O   LYS A  41       2.987   4.344   4.355  1.00  0.00           O  
ATOM    632  CB  LYS A  41       4.232   7.662   4.346  1.00  0.00           C  
ATOM    633  CG  LYS A  41       3.960   7.907   5.849  1.00  0.00           C  
ATOM    634  CD  LYS A  41       3.120   6.873   6.603  1.00  0.00           C  
ATOM    635  CE  LYS A  41       2.958   7.253   8.077  1.00  0.00           C  
ATOM    636  NZ  LYS A  41       2.241   6.194   8.823  1.00  0.00           N  
ATOM    637  H   LYS A  41       1.474   6.222   4.193  1.00  0.00           H  
ATOM    638  HA  LYS A  41       3.817   6.654   2.518  1.00  0.00           H  
ATOM    639  HB2 LYS A  41       5.302   7.481   4.236  1.00  0.00           H  
ATOM    640  HB3 LYS A  41       4.052   8.610   3.835  1.00  0.00           H  
ATOM    641  HG2 LYS A  41       4.926   7.990   6.351  1.00  0.00           H  
ATOM    642  HG3 LYS A  41       3.465   8.874   5.947  1.00  0.00           H  
ATOM    643  HD2 LYS A  41       2.131   6.836   6.159  1.00  0.00           H  
ATOM    644  HD3 LYS A  41       3.593   5.895   6.538  1.00  0.00           H  
ATOM    645  HE2 LYS A  41       3.943   7.414   8.523  1.00  0.00           H  
ATOM    646  HE3 LYS A  41       2.396   8.188   8.136  1.00  0.00           H  
ATOM    647  HZ1 LYS A  41       1.422   5.877   8.301  1.00  0.00           H  
ATOM    648  HZ2 LYS A  41       2.834   5.389   8.959  1.00  0.00           H  
ATOM    649  HZ3 LYS A  41       1.946   6.526   9.730  1.00  0.00           H  
ATOM    650  N   VAL A  42       5.147   4.820   3.920  1.00  0.00           N  
ATOM    651  CA  VAL A  42       5.701   3.521   4.281  1.00  0.00           C  
ATOM    652  C   VAL A  42       5.228   3.110   5.680  1.00  0.00           C  
ATOM    653  O   VAL A  42       5.253   3.911   6.618  1.00  0.00           O  
ATOM    654  CB  VAL A  42       7.241   3.555   4.168  1.00  0.00           C  
ATOM    655  CG1 VAL A  42       7.852   2.175   4.453  1.00  0.00           C  
ATOM    656  CG2 VAL A  42       7.678   4.009   2.766  1.00  0.00           C  
ATOM    657  H   VAL A  42       5.787   5.500   3.538  1.00  0.00           H  
ATOM    658  HA  VAL A  42       5.320   2.802   3.557  1.00  0.00           H  
ATOM    659  HB  VAL A  42       7.643   4.262   4.894  1.00  0.00           H  
ATOM    660 HG11 VAL A  42       7.697   1.903   5.497  1.00  0.00           H  
ATOM    661 HG12 VAL A  42       7.391   1.421   3.817  1.00  0.00           H  
ATOM    662 HG13 VAL A  42       8.927   2.193   4.269  1.00  0.00           H  
ATOM    663 HG21 VAL A  42       7.123   3.454   2.013  1.00  0.00           H  
ATOM    664 HG22 VAL A  42       7.484   5.074   2.635  1.00  0.00           H  
ATOM    665 HG23 VAL A  42       8.748   3.848   2.627  1.00  0.00           H  
ATOM    666  N   GLY A  43       4.815   1.849   5.815  1.00  0.00           N  
ATOM    667  CA  GLY A  43       4.401   1.243   7.072  1.00  0.00           C  
ATOM    668  C   GLY A  43       2.885   1.282   7.271  1.00  0.00           C  
ATOM    669  O   GLY A  43       2.387   0.651   8.204  1.00  0.00           O  
ATOM    670  H   GLY A  43       4.797   1.252   4.993  1.00  0.00           H  
ATOM    671  HA2 GLY A  43       4.732   0.206   7.080  1.00  0.00           H  
ATOM    672  HA3 GLY A  43       4.880   1.761   7.904  1.00  0.00           H  
ATOM    673  N   ASP A  44       2.141   2.003   6.425  1.00  0.00           N  
ATOM    674  CA  ASP A  44       0.683   2.054   6.513  1.00  0.00           C  
ATOM    675  C   ASP A  44       0.101   0.701   6.110  1.00  0.00           C  
ATOM    676  O   ASP A  44       0.528   0.115   5.111  1.00  0.00           O  
ATOM    677  CB  ASP A  44       0.102   3.152   5.602  1.00  0.00           C  
ATOM    678  CG  ASP A  44       0.245   4.570   6.167  1.00  0.00           C  
ATOM    679  OD1 ASP A  44       0.385   4.720   7.407  1.00  0.00           O  
ATOM    680  OD2 ASP A  44       0.179   5.530   5.372  1.00  0.00           O  
ATOM    681  H   ASP A  44       2.585   2.509   5.669  1.00  0.00           H  
ATOM    682  HA  ASP A  44       0.401   2.263   7.545  1.00  0.00           H  
ATOM    683  HB2 ASP A  44       0.573   3.093   4.619  1.00  0.00           H  
ATOM    684  HB3 ASP A  44      -0.962   2.962   5.464  1.00  0.00           H  
ATOM    685  N   LEU A  45      -0.902   0.222   6.852  1.00  0.00           N  
ATOM    686  CA  LEU A  45      -1.796  -0.827   6.371  1.00  0.00           C  
ATOM    687  C   LEU A  45      -2.724  -0.211   5.315  1.00  0.00           C  
ATOM    688  O   LEU A  45      -3.034   0.983   5.383  1.00  0.00           O  
ATOM    689  CB  LEU A  45      -2.627  -1.375   7.548  1.00  0.00           C  
ATOM    690  CG  LEU A  45      -3.325  -2.728   7.292  1.00  0.00           C  
ATOM    691  CD1 LEU A  45      -2.332  -3.898   7.325  1.00  0.00           C  
ATOM    692  CD2 LEU A  45      -4.392  -2.961   8.367  1.00  0.00           C  
ATOM    693  H   LEU A  45      -1.201   0.723   7.677  1.00  0.00           H  
ATOM    694  HA  LEU A  45      -1.199  -1.624   5.931  1.00  0.00           H  
ATOM    695  HB2 LEU A  45      -1.986  -1.479   8.425  1.00  0.00           H  
ATOM    696  HB3 LEU A  45      -3.394  -0.635   7.783  1.00  0.00           H  
ATOM    697  HG  LEU A  45      -3.823  -2.713   6.325  1.00  0.00           H  
ATOM    698 HD11 LEU A  45      -1.552  -3.756   6.580  1.00  0.00           H  
ATOM    699 HD12 LEU A  45      -1.867  -3.972   8.307  1.00  0.00           H  
ATOM    700 HD13 LEU A  45      -2.854  -4.828   7.103  1.00  0.00           H  
ATOM    701 HD21 LEU A  45      -3.938  -2.976   9.359  1.00  0.00           H  
ATOM    702 HD22 LEU A  45      -5.136  -2.165   8.326  1.00  0.00           H  
ATOM    703 HD23 LEU A  45      -4.897  -3.910   8.184  1.00  0.00           H  
ATOM    704  N   LEU A  46      -3.243  -1.034   4.408  1.00  0.00           N  
ATOM    705  CA  LEU A  46      -4.380  -0.732   3.550  1.00  0.00           C  
ATOM    706  C   LEU A  46      -5.341  -1.909   3.681  1.00  0.00           C  
ATOM    707  O   LEU A  46      -4.906  -3.064   3.643  1.00  0.00           O  
ATOM    708  CB  LEU A  46      -3.966  -0.601   2.074  1.00  0.00           C  
ATOM    709  CG  LEU A  46      -2.941   0.490   1.730  1.00  0.00           C  
ATOM    710  CD1 LEU A  46      -2.603   0.373   0.244  1.00  0.00           C  
ATOM    711  CD2 LEU A  46      -3.428   1.915   1.999  1.00  0.00           C  
ATOM    712  H   LEU A  46      -2.928  -2.002   4.401  1.00  0.00           H  
ATOM    713  HA  LEU A  46      -4.865   0.188   3.879  1.00  0.00           H  
ATOM    714  HB2 LEU A  46      -3.558  -1.561   1.757  1.00  0.00           H  
ATOM    715  HB3 LEU A  46      -4.867  -0.425   1.485  1.00  0.00           H  
ATOM    716  HG  LEU A  46      -2.032   0.318   2.303  1.00  0.00           H  
ATOM    717 HD11 LEU A  46      -2.167  -0.604   0.053  1.00  0.00           H  
ATOM    718 HD12 LEU A  46      -3.499   0.495  -0.366  1.00  0.00           H  
ATOM    719 HD13 LEU A  46      -1.880   1.137  -0.026  1.00  0.00           H  
ATOM    720 HD21 LEU A  46      -4.355   2.104   1.457  1.00  0.00           H  
ATOM    721 HD22 LEU A  46      -3.602   2.042   3.064  1.00  0.00           H  
ATOM    722 HD23 LEU A  46      -2.673   2.636   1.687  1.00  0.00           H  
ATOM    723  N   SER A  47      -6.638  -1.625   3.760  1.00  0.00           N  
ATOM    724  CA  SER A  47      -7.690  -2.629   3.882  1.00  0.00           C  
ATOM    725  C   SER A  47      -8.847  -2.191   2.981  1.00  0.00           C  
ATOM    726  O   SER A  47      -9.122  -0.990   2.931  1.00  0.00           O  
ATOM    727  CB  SER A  47      -8.155  -2.722   5.342  1.00  0.00           C  
ATOM    728  OG  SER A  47      -7.061  -2.914   6.222  1.00  0.00           O  
ATOM    729  H   SER A  47      -6.942  -0.663   3.730  1.00  0.00           H  
ATOM    730  HA  SER A  47      -7.309  -3.600   3.569  1.00  0.00           H  
ATOM    731  HB2 SER A  47      -8.670  -1.799   5.614  1.00  0.00           H  
ATOM    732  HB3 SER A  47      -8.855  -3.552   5.441  1.00  0.00           H  
ATOM    733  HG  SER A  47      -7.413  -3.000   7.123  1.00  0.00           H  
ATOM    734  N   PRO A  48      -9.502  -3.098   2.240  1.00  0.00           N  
ATOM    735  CA  PRO A  48     -10.516  -2.717   1.266  1.00  0.00           C  
ATOM    736  C   PRO A  48     -11.768  -2.161   1.952  1.00  0.00           C  
ATOM    737  O   PRO A  48     -12.127  -2.568   3.062  1.00  0.00           O  
ATOM    738  CB  PRO A  48     -10.815  -3.986   0.462  1.00  0.00           C  
ATOM    739  CG  PRO A  48     -10.441  -5.121   1.416  1.00  0.00           C  
ATOM    740  CD  PRO A  48      -9.282  -4.536   2.221  1.00  0.00           C  
ATOM    741  HA  PRO A  48     -10.111  -1.958   0.593  1.00  0.00           H  
ATOM    742  HB2 PRO A  48     -11.860  -4.045   0.154  1.00  0.00           H  
ATOM    743  HB3 PRO A  48     -10.166  -4.021  -0.413  1.00  0.00           H  
ATOM    744  HG2 PRO A  48     -11.278  -5.331   2.082  1.00  0.00           H  
ATOM    745  HG3 PRO A  48     -10.144  -6.022   0.877  1.00  0.00           H  
ATOM    746  HD2 PRO A  48      -9.274  -4.953   3.229  1.00  0.00           H  
ATOM    747  HD3 PRO A  48      -8.339  -4.750   1.716  1.00  0.00           H  
ATOM    748  N   LEU A  49     -12.468  -1.276   1.240  1.00  0.00           N  
ATOM    749  CA  LEU A  49     -13.767  -0.716   1.622  1.00  0.00           C  
ATOM    750  C   LEU A  49     -14.793  -1.000   0.523  1.00  0.00           C  
ATOM    751  O   LEU A  49     -15.955  -1.273   0.821  1.00  0.00           O  
ATOM    752  CB  LEU A  49     -13.645   0.803   1.843  1.00  0.00           C  
ATOM    753  CG  LEU A  49     -12.846   1.205   3.096  1.00  0.00           C  
ATOM    754  CD1 LEU A  49     -12.582   2.714   3.069  1.00  0.00           C  
ATOM    755  CD2 LEU A  49     -13.596   0.838   4.384  1.00  0.00           C  
ATOM    756  H   LEU A  49     -12.067  -0.955   0.363  1.00  0.00           H  
ATOM    757  HA  LEU A  49     -14.122  -1.188   2.538  1.00  0.00           H  
ATOM    758  HB2 LEU A  49     -13.176   1.242   0.962  1.00  0.00           H  
ATOM    759  HB3 LEU A  49     -14.648   1.227   1.920  1.00  0.00           H  
ATOM    760  HG  LEU A  49     -11.881   0.697   3.087  1.00  0.00           H  
ATOM    761 HD11 LEU A  49     -12.016   2.972   2.174  1.00  0.00           H  
ATOM    762 HD12 LEU A  49     -13.523   3.265   3.071  1.00  0.00           H  
ATOM    763 HD13 LEU A  49     -11.996   3.001   3.943  1.00  0.00           H  
ATOM    764 HD21 LEU A  49     -14.604   1.254   4.369  1.00  0.00           H  
ATOM    765 HD22 LEU A  49     -13.652  -0.245   4.489  1.00  0.00           H  
ATOM    766 HD23 LEU A  49     -13.064   1.232   5.249  1.00  0.00           H  
ATOM    767  N   GLN A  50     -14.351  -0.986  -0.736  1.00  0.00           N  
ATOM    768  CA  GLN A  50     -15.052  -1.501  -1.908  1.00  0.00           C  
ATOM    769  C   GLN A  50     -13.967  -1.859  -2.938  1.00  0.00           C  
ATOM    770  O   GLN A  50     -12.786  -1.911  -2.583  1.00  0.00           O  
ATOM    771  CB  GLN A  50     -16.120  -0.501  -2.413  1.00  0.00           C  
ATOM    772  CG  GLN A  50     -15.638   0.946  -2.606  1.00  0.00           C  
ATOM    773  CD  GLN A  50     -16.702   1.844  -3.249  1.00  0.00           C  
ATOM    774  OE1 GLN A  50     -17.882   1.793  -2.910  1.00  0.00           O  
ATOM    775  NE2 GLN A  50     -16.318   2.695  -4.190  1.00  0.00           N  
ATOM    776  H   GLN A  50     -13.370  -0.780  -0.900  1.00  0.00           H  
ATOM    777  HA  GLN A  50     -15.562  -2.426  -1.637  1.00  0.00           H  
ATOM    778  HB2 GLN A  50     -16.536  -0.864  -3.354  1.00  0.00           H  
ATOM    779  HB3 GLN A  50     -16.937  -0.489  -1.691  1.00  0.00           H  
ATOM    780  HG2 GLN A  50     -15.389   1.366  -1.633  1.00  0.00           H  
ATOM    781  HG3 GLN A  50     -14.741   0.943  -3.225  1.00  0.00           H  
ATOM    782 HE21 GLN A  50     -15.354   2.749  -4.482  1.00  0.00           H  
ATOM    783 HE22 GLN A  50     -16.998   3.300  -4.629  1.00  0.00           H  
ATOM    784  N   ASN A  51     -14.341  -2.108  -4.199  1.00  0.00           N  
ATOM    785  CA  ASN A  51     -13.414  -2.558  -5.245  1.00  0.00           C  
ATOM    786  C   ASN A  51     -12.175  -1.663  -5.379  1.00  0.00           C  
ATOM    787  O   ASN A  51     -11.076  -2.179  -5.586  1.00  0.00           O  
ATOM    788  CB  ASN A  51     -14.140  -2.637  -6.597  1.00  0.00           C  
ATOM    789  CG  ASN A  51     -13.173  -3.030  -7.715  1.00  0.00           C  
ATOM    790  OD1 ASN A  51     -12.709  -4.165  -7.779  1.00  0.00           O  
ATOM    791  ND2 ASN A  51     -12.842  -2.112  -8.610  1.00  0.00           N  
ATOM    792  H   ASN A  51     -15.325  -2.074  -4.429  1.00  0.00           H  
ATOM    793  HA  ASN A  51     -13.071  -3.562  -4.987  1.00  0.00           H  
ATOM    794  HB2 ASN A  51     -14.935  -3.382  -6.541  1.00  0.00           H  
ATOM    795  HB3 ASN A  51     -14.595  -1.671  -6.825  1.00  0.00           H  
ATOM    796 HD21 ASN A  51     -13.237  -1.183  -8.571  1.00  0.00           H  
ATOM    797 HD22 ASN A  51     -12.200  -2.341  -9.356  1.00  0.00           H  
ATOM    798  N   ALA A  52     -12.345  -0.339  -5.254  1.00  0.00           N  
ATOM    799  CA  ALA A  52     -11.265   0.623  -5.465  1.00  0.00           C  
ATOM    800  C   ALA A  52     -10.872   1.391  -4.202  1.00  0.00           C  
ATOM    801  O   ALA A  52      -9.712   1.780  -4.102  1.00  0.00           O  
ATOM    802  CB  ALA A  52     -11.661   1.600  -6.579  1.00  0.00           C  
ATOM    803  H   ALA A  52     -13.279   0.015  -5.118  1.00  0.00           H  
ATOM    804  HA  ALA A  52     -10.373   0.095  -5.806  1.00  0.00           H  
ATOM    805  HB1 ALA A  52     -11.886   1.050  -7.494  1.00  0.00           H  
ATOM    806  HB2 ALA A  52     -12.532   2.183  -6.281  1.00  0.00           H  
ATOM    807  HB3 ALA A  52     -10.830   2.279  -6.777  1.00  0.00           H  
ATOM    808  N   LEU A  53     -11.783   1.644  -3.254  1.00  0.00           N  
ATOM    809  CA  LEU A  53     -11.435   2.405  -2.052  1.00  0.00           C  
ATOM    810  C   LEU A  53     -10.802   1.474  -1.028  1.00  0.00           C  
ATOM    811  O   LEU A  53     -11.308   0.372  -0.801  1.00  0.00           O  
ATOM    812  CB  LEU A  53     -12.653   3.099  -1.417  1.00  0.00           C  
ATOM    813  CG  LEU A  53     -13.175   4.328  -2.185  1.00  0.00           C  
ATOM    814  CD1 LEU A  53     -14.485   4.808  -1.552  1.00  0.00           C  
ATOM    815  CD2 LEU A  53     -12.172   5.489  -2.174  1.00  0.00           C  
ATOM    816  H   LEU A  53     -12.691   1.216  -3.308  1.00  0.00           H  
ATOM    817  HA  LEU A  53     -10.704   3.162  -2.320  1.00  0.00           H  
ATOM    818  HB2 LEU A  53     -13.447   2.367  -1.304  1.00  0.00           H  
ATOM    819  HB3 LEU A  53     -12.377   3.427  -0.412  1.00  0.00           H  
ATOM    820  HG  LEU A  53     -13.375   4.046  -3.219  1.00  0.00           H  
ATOM    821 HD11 LEU A  53     -15.230   4.013  -1.585  1.00  0.00           H  
ATOM    822 HD12 LEU A  53     -14.321   5.100  -0.514  1.00  0.00           H  
ATOM    823 HD13 LEU A  53     -14.874   5.663  -2.107  1.00  0.00           H  
ATOM    824 HD21 LEU A  53     -11.921   5.764  -1.148  1.00  0.00           H  
ATOM    825 HD22 LEU A  53     -11.262   5.207  -2.696  1.00  0.00           H  
ATOM    826 HD23 LEU A  53     -12.598   6.355  -2.682  1.00  0.00           H  
ATOM    827  N   TYR A  54      -9.753   1.956  -0.366  1.00  0.00           N  
ATOM    828  CA  TYR A  54      -9.064   1.274   0.721  1.00  0.00           C  
ATOM    829  C   TYR A  54      -8.812   2.294   1.833  1.00  0.00           C  
ATOM    830  O   TYR A  54      -8.583   3.473   1.547  1.00  0.00           O  
ATOM    831  CB  TYR A  54      -7.723   0.681   0.239  1.00  0.00           C  
ATOM    832  CG  TYR A  54      -7.804  -0.602  -0.575  1.00  0.00           C  
ATOM    833  CD1 TYR A  54      -8.325  -0.589  -1.883  1.00  0.00           C  
ATOM    834  CD2 TYR A  54      -7.325  -1.814  -0.038  1.00  0.00           C  
ATOM    835  CE1 TYR A  54      -8.421  -1.776  -2.629  1.00  0.00           C  
ATOM    836  CE2 TYR A  54      -7.410  -3.007  -0.778  1.00  0.00           C  
ATOM    837  CZ  TYR A  54      -7.968  -2.994  -2.077  1.00  0.00           C  
ATOM    838  OH  TYR A  54      -8.071  -4.141  -2.808  1.00  0.00           O  
ATOM    839  H   TYR A  54      -9.420   2.890  -0.588  1.00  0.00           H  
ATOM    840  HA  TYR A  54      -9.696   0.474   1.104  1.00  0.00           H  
ATOM    841  HB2 TYR A  54      -7.191   1.433  -0.343  1.00  0.00           H  
ATOM    842  HB3 TYR A  54      -7.113   0.482   1.122  1.00  0.00           H  
ATOM    843  HD1 TYR A  54      -8.660   0.338  -2.321  1.00  0.00           H  
ATOM    844  HD2 TYR A  54      -6.889  -1.836   0.948  1.00  0.00           H  
ATOM    845  HE1 TYR A  54      -8.842  -1.753  -3.625  1.00  0.00           H  
ATOM    846  HE2 TYR A  54      -7.052  -3.930  -0.345  1.00  0.00           H  
ATOM    847  HH  TYR A  54      -7.738  -4.926  -2.348  1.00  0.00           H  
ATOM    848  N   CYS A  55      -8.838   1.836   3.088  1.00  0.00           N  
ATOM    849  CA  CYS A  55      -8.403   2.590   4.262  1.00  0.00           C  
ATOM    850  C   CYS A  55      -6.921   2.964   4.142  1.00  0.00           C  
ATOM    851  O   CYS A  55      -6.198   2.341   3.364  1.00  0.00           O  
ATOM    852  CB  CYS A  55      -8.571   1.728   5.526  1.00  0.00           C  
ATOM    853  SG  CYS A  55     -10.217   0.976   5.630  1.00  0.00           S  
ATOM    854  H   CYS A  55      -9.065   0.859   3.233  1.00  0.00           H  
ATOM    855  HA  CYS A  55      -9.008   3.493   4.349  1.00  0.00           H  
ATOM    856  HB2 CYS A  55      -7.822   0.934   5.523  1.00  0.00           H  
ATOM    857  HB3 CYS A  55      -8.401   2.350   6.404  1.00  0.00           H  
ATOM    858  HG  CYS A  55     -10.024   0.359   6.806  1.00  0.00           H  
ATOM    859  N   ILE A  56      -6.439   3.868   4.998  1.00  0.00           N  
ATOM    860  CA  ILE A  56      -5.019   4.169   5.168  1.00  0.00           C  
ATOM    861  C   ILE A  56      -4.675   3.917   6.636  1.00  0.00           C  
ATOM    862  O   ILE A  56      -5.486   4.164   7.532  1.00  0.00           O  
ATOM    863  CB  ILE A  56      -4.690   5.628   4.750  1.00  0.00           C  
ATOM    864  CG1 ILE A  56      -5.014   5.902   3.266  1.00  0.00           C  
ATOM    865  CG2 ILE A  56      -3.206   5.966   5.009  1.00  0.00           C  
ATOM    866  CD1 ILE A  56      -4.987   7.399   2.916  1.00  0.00           C  
ATOM    867  H   ILE A  56      -7.084   4.342   5.624  1.00  0.00           H  
ATOM    868  HA  ILE A  56      -4.427   3.493   4.551  1.00  0.00           H  
ATOM    869  HB  ILE A  56      -5.295   6.293   5.361  1.00  0.00           H  
ATOM    870 HG12 ILE A  56      -4.299   5.366   2.643  1.00  0.00           H  
ATOM    871 HG13 ILE A  56      -6.010   5.532   3.030  1.00  0.00           H  
ATOM    872 HG21 ILE A  56      -2.983   5.937   6.073  1.00  0.00           H  
ATOM    873 HG22 ILE A  56      -2.560   5.264   4.482  1.00  0.00           H  
ATOM    874 HG23 ILE A  56      -2.963   6.975   4.687  1.00  0.00           H  
ATOM    875 HD11 ILE A  56      -5.687   7.936   3.550  1.00  0.00           H  
ATOM    876 HD12 ILE A  56      -3.993   7.822   3.035  1.00  0.00           H  
ATOM    877 HD13 ILE A  56      -5.273   7.546   1.880  1.00  0.00           H  
ATOM    878  N   ASN A  57      -3.435   3.482   6.864  1.00  0.00           N  
ATOM    879  CA  ASN A  57      -2.738   3.316   8.138  1.00  0.00           C  
ATOM    880  C   ASN A  57      -3.308   2.192   8.993  1.00  0.00           C  
ATOM    881  O   ASN A  57      -2.564   1.262   9.292  1.00  0.00           O  
ATOM    882  CB  ASN A  57      -2.622   4.631   8.922  1.00  0.00           C  
ATOM    883  CG  ASN A  57      -1.778   4.409  10.171  1.00  0.00           C  
ATOM    884  OD1 ASN A  57      -2.286   4.380  11.286  1.00  0.00           O  
ATOM    885  ND2 ASN A  57      -0.481   4.216  10.002  1.00  0.00           N  
ATOM    886  H   ASN A  57      -2.921   3.165   6.051  1.00  0.00           H  
ATOM    887  HA  ASN A  57      -1.722   3.021   7.888  1.00  0.00           H  
ATOM    888  HB2 ASN A  57      -2.147   5.391   8.299  1.00  0.00           H  
ATOM    889  HB3 ASN A  57      -3.609   4.991   9.213  1.00  0.00           H  
ATOM    890 HD21 ASN A  57      -0.089   4.288   9.059  1.00  0.00           H  
ATOM    891 HD22 ASN A  57       0.115   4.029  10.794  1.00  0.00           H  
ATOM    892  N   ARG A  58      -4.600   2.267   9.330  1.00  0.00           N  
ATOM    893  CA  ARG A  58      -5.453   1.234   9.930  1.00  0.00           C  
ATOM    894  C   ARG A  58      -6.866   1.777  10.211  1.00  0.00           C  
ATOM    895  O   ARG A  58      -7.603   1.145  10.968  1.00  0.00           O  
ATOM    896  CB  ARG A  58      -4.830   0.602  11.202  1.00  0.00           C  
ATOM    897  CG  ARG A  58      -4.489   1.606  12.316  1.00  0.00           C  
ATOM    898  CD  ARG A  58      -3.961   0.863  13.548  1.00  0.00           C  
ATOM    899  NE  ARG A  58      -3.531   1.794  14.608  1.00  0.00           N  
ATOM    900  CZ  ARG A  58      -2.282   2.223  14.833  1.00  0.00           C  
ATOM    901  NH1 ARG A  58      -1.280   1.871  14.030  1.00  0.00           N  
ATOM    902  NH2 ARG A  58      -2.037   3.007  15.879  1.00  0.00           N  
ATOM    903  H   ARG A  58      -5.078   3.102   9.009  1.00  0.00           H  
ATOM    904  HA  ARG A  58      -5.564   0.439   9.191  1.00  0.00           H  
ATOM    905  HB2 ARG A  58      -5.523  -0.140  11.601  1.00  0.00           H  
ATOM    906  HB3 ARG A  58      -3.930   0.052  10.934  1.00  0.00           H  
ATOM    907  HG2 ARG A  58      -3.726   2.294  11.960  1.00  0.00           H  
ATOM    908  HG3 ARG A  58      -5.379   2.173  12.592  1.00  0.00           H  
ATOM    909  HD2 ARG A  58      -4.753   0.226  13.942  1.00  0.00           H  
ATOM    910  HD3 ARG A  58      -3.130   0.218  13.257  1.00  0.00           H  
ATOM    911  HE  ARG A  58      -4.267   2.097  15.236  1.00  0.00           H  
ATOM    912 HH11 ARG A  58      -1.450   1.290  13.223  1.00  0.00           H  
ATOM    913 HH12 ARG A  58      -0.329   2.170  14.192  1.00  0.00           H  
ATOM    914 HH21 ARG A  58      -2.777   3.284  16.511  1.00  0.00           H  
ATOM    915 HH22 ARG A  58      -1.108   3.343  16.091  1.00  0.00           H  
ATOM    916  N   GLU A  59      -7.263   2.938   9.668  1.00  0.00           N  
ATOM    917  CA  GLU A  59      -8.512   3.600  10.045  1.00  0.00           C  
ATOM    918  C   GLU A  59      -9.297   3.991   8.794  1.00  0.00           C  
ATOM    919  O   GLU A  59      -8.729   4.441   7.797  1.00  0.00           O  
ATOM    920  CB  GLU A  59      -8.235   4.783  10.992  1.00  0.00           C  
ATOM    921  CG  GLU A  59      -7.457   5.959  10.379  1.00  0.00           C  
ATOM    922  CD  GLU A  59      -7.105   7.005  11.453  1.00  0.00           C  
ATOM    923  OE1 GLU A  59      -8.014   7.712  11.945  1.00  0.00           O  
ATOM    924  OE2 GLU A  59      -5.914   7.127  11.820  1.00  0.00           O  
ATOM    925  H   GLU A  59      -6.717   3.401   8.947  1.00  0.00           H  
ATOM    926  HA  GLU A  59      -9.128   2.896  10.604  1.00  0.00           H  
ATOM    927  HB2 GLU A  59      -9.191   5.157  11.360  1.00  0.00           H  
ATOM    928  HB3 GLU A  59      -7.676   4.406  11.851  1.00  0.00           H  
ATOM    929  HG2 GLU A  59      -6.539   5.585   9.920  1.00  0.00           H  
ATOM    930  HG3 GLU A  59      -8.060   6.429   9.600  1.00  0.00           H  
ATOM    931  N   LYS A  60     -10.617   3.788   8.841  1.00  0.00           N  
ATOM    932  CA  LYS A  60     -11.483   3.873   7.661  1.00  0.00           C  
ATOM    933  C   LYS A  60     -11.702   5.314   7.202  1.00  0.00           C  
ATOM    934  O   LYS A  60     -12.129   5.528   6.068  1.00  0.00           O  
ATOM    935  CB  LYS A  60     -12.846   3.203   7.931  1.00  0.00           C  
ATOM    936  CG  LYS A  60     -12.745   1.831   8.621  1.00  0.00           C  
ATOM    937  CD  LYS A  60     -14.108   1.128   8.689  1.00  0.00           C  
ATOM    938  CE  LYS A  60     -14.031  -0.060   9.659  1.00  0.00           C  
ATOM    939  NZ  LYS A  60     -15.294  -0.835   9.708  1.00  0.00           N  
ATOM    940  H   LYS A  60     -11.030   3.443   9.699  1.00  0.00           H  
ATOM    941  HA  LYS A  60     -10.991   3.344   6.846  1.00  0.00           H  
ATOM    942  HB2 LYS A  60     -13.449   3.862   8.559  1.00  0.00           H  
ATOM    943  HB3 LYS A  60     -13.360   3.082   6.976  1.00  0.00           H  
ATOM    944  HG2 LYS A  60     -12.043   1.197   8.080  1.00  0.00           H  
ATOM    945  HG3 LYS A  60     -12.376   1.974   9.638  1.00  0.00           H  
ATOM    946  HD2 LYS A  60     -14.864   1.830   9.042  1.00  0.00           H  
ATOM    947  HD3 LYS A  60     -14.380   0.780   7.690  1.00  0.00           H  
ATOM    948  HE2 LYS A  60     -13.211  -0.716   9.356  1.00  0.00           H  
ATOM    949  HE3 LYS A  60     -13.805   0.322  10.657  1.00  0.00           H  
ATOM    950  HZ1 LYS A  60     -16.076  -0.251   9.965  1.00  0.00           H  
ATOM    951  HZ2 LYS A  60     -15.496  -1.263   8.817  1.00  0.00           H  
ATOM    952  HZ3 LYS A  60     -15.231  -1.575  10.392  1.00  0.00           H  
ATOM    953  N   LEU A  61     -11.456   6.296   8.078  1.00  0.00           N  
ATOM    954  CA  LEU A  61     -11.700   7.705   7.776  1.00  0.00           C  
ATOM    955  C   LEU A  61     -10.756   8.192   6.679  1.00  0.00           C  
ATOM    956  O   LEU A  61     -11.142   9.038   5.875  1.00  0.00           O  
ATOM    957  CB  LEU A  61     -11.508   8.593   9.021  1.00  0.00           C  
ATOM    958  CG  LEU A  61     -12.316   8.200  10.273  1.00  0.00           C  
ATOM    959  CD1 LEU A  61     -12.115   9.262  11.360  1.00  0.00           C  
ATOM    960  CD2 LEU A  61     -13.815   8.029   9.997  1.00  0.00           C  
ATOM    961  H   LEU A  61     -11.114   6.051   8.994  1.00  0.00           H  
ATOM    962  HA  LEU A  61     -12.726   7.812   7.418  1.00  0.00           H  
ATOM    963  HB2 LEU A  61     -10.449   8.599   9.285  1.00  0.00           H  
ATOM    964  HB3 LEU A  61     -11.779   9.613   8.739  1.00  0.00           H  
ATOM    965  HG  LEU A  61     -11.931   7.254  10.653  1.00  0.00           H  
ATOM    966 HD11 LEU A  61     -11.051   9.382  11.565  1.00  0.00           H  
ATOM    967 HD12 LEU A  61     -12.524  10.220  11.033  1.00  0.00           H  
ATOM    968 HD13 LEU A  61     -12.614   8.953  12.278  1.00  0.00           H  
ATOM    969 HD21 LEU A  61     -14.227   8.941   9.562  1.00  0.00           H  
ATOM    970 HD22 LEU A  61     -13.978   7.197   9.311  1.00  0.00           H  
ATOM    971 HD23 LEU A  61     -14.338   7.805  10.927  1.00  0.00           H  
ATOM    972  N   HIS A  62      -9.521   7.682   6.660  1.00  0.00           N  
ATOM    973  CA  HIS A  62      -8.490   8.088   5.717  1.00  0.00           C  
ATOM    974  C   HIS A  62      -8.496   7.073   4.576  1.00  0.00           C  
ATOM    975  O   HIS A  62      -8.518   5.871   4.846  1.00  0.00           O  
ATOM    976  CB  HIS A  62      -7.131   8.112   6.435  1.00  0.00           C  
ATOM    977  CG  HIS A  62      -7.036   9.021   7.640  1.00  0.00           C  
ATOM    978  ND1 HIS A  62      -6.089   8.932   8.637  1.00  0.00           N  
ATOM    979  CD2 HIS A  62      -7.846  10.083   7.953  1.00  0.00           C  
ATOM    980  CE1 HIS A  62      -6.325   9.911   9.527  1.00  0.00           C  
ATOM    981  NE2 HIS A  62      -7.391  10.644   9.154  1.00  0.00           N  
ATOM    982  H   HIS A  62      -9.293   6.917   7.280  1.00  0.00           H  
ATOM    983  HA  HIS A  62      -8.708   9.082   5.336  1.00  0.00           H  
ATOM    984  HB2 HIS A  62      -6.895   7.098   6.761  1.00  0.00           H  
ATOM    985  HB3 HIS A  62      -6.372   8.427   5.719  1.00  0.00           H  
ATOM    986  HD1 HIS A  62      -5.338   8.254   8.697  1.00  0.00           H  
ATOM    987  HD2 HIS A  62      -8.694  10.424   7.376  1.00  0.00           H  
ATOM    988  HE1 HIS A  62      -5.734  10.082  10.421  1.00  0.00           H  
ATOM    989  N   THR A  63      -8.471   7.521   3.319  1.00  0.00           N  
ATOM    990  CA  THR A  63      -8.713   6.642   2.179  1.00  0.00           C  
ATOM    991  C   THR A  63      -7.819   6.955   0.975  1.00  0.00           C  
ATOM    992  O   THR A  63      -7.462   8.113   0.722  1.00  0.00           O  
ATOM    993  CB  THR A  63     -10.202   6.722   1.781  1.00  0.00           C  
ATOM    994  OG1 THR A  63     -10.633   8.074   1.734  1.00  0.00           O  
ATOM    995  CG2 THR A  63     -11.101   5.976   2.770  1.00  0.00           C  
ATOM    996  H   THR A  63      -8.520   8.510   3.129  1.00  0.00           H  
ATOM    997  HA  THR A  63      -8.495   5.622   2.482  1.00  0.00           H  
ATOM    998  HB  THR A  63     -10.325   6.265   0.797  1.00  0.00           H  
ATOM    999  HG1 THR A  63     -11.486   8.109   1.273  1.00  0.00           H  
ATOM   1000 HG21 THR A  63     -10.712   4.970   2.931  1.00  0.00           H  
ATOM   1001 HG22 THR A  63     -11.132   6.501   3.725  1.00  0.00           H  
ATOM   1002 HG23 THR A  63     -12.111   5.902   2.369  1.00  0.00           H  
ATOM   1003  N   VAL A  64      -7.521   5.910   0.200  1.00  0.00           N  
ATOM   1004  CA  VAL A  64      -7.010   5.991  -1.165  1.00  0.00           C  
ATOM   1005  C   VAL A  64      -8.020   5.307  -2.089  1.00  0.00           C  
ATOM   1006  O   VAL A  64      -8.858   4.525  -1.628  1.00  0.00           O  
ATOM   1007  CB  VAL A  64      -5.607   5.352  -1.311  1.00  0.00           C  
ATOM   1008  CG1 VAL A  64      -4.528   6.127  -0.556  1.00  0.00           C  
ATOM   1009  CG2 VAL A  64      -5.552   3.878  -0.873  1.00  0.00           C  
ATOM   1010  H   VAL A  64      -7.870   4.994   0.474  1.00  0.00           H  
ATOM   1011  HA  VAL A  64      -6.943   7.037  -1.460  1.00  0.00           H  
ATOM   1012  HB  VAL A  64      -5.338   5.392  -2.366  1.00  0.00           H  
ATOM   1013 HG11 VAL A  64      -4.636   7.193  -0.746  1.00  0.00           H  
ATOM   1014 HG12 VAL A  64      -4.614   5.937   0.507  1.00  0.00           H  
ATOM   1015 HG13 VAL A  64      -3.542   5.805  -0.891  1.00  0.00           H  
ATOM   1016 HG21 VAL A  64      -5.821   3.779   0.179  1.00  0.00           H  
ATOM   1017 HG22 VAL A  64      -6.237   3.286  -1.478  1.00  0.00           H  
ATOM   1018 HG23 VAL A  64      -4.544   3.488  -1.019  1.00  0.00           H  
ATOM   1019  N   LYS A  65      -7.905   5.562  -3.391  1.00  0.00           N  
ATOM   1020  CA  LYS A  65      -8.710   4.965  -4.445  1.00  0.00           C  
ATOM   1021  C   LYS A  65      -7.732   4.382  -5.454  1.00  0.00           C  
ATOM   1022  O   LYS A  65      -6.967   5.135  -6.056  1.00  0.00           O  
ATOM   1023  CB  LYS A  65      -9.612   6.045  -5.069  1.00  0.00           C  
ATOM   1024  CG  LYS A  65     -10.651   5.439  -6.022  1.00  0.00           C  
ATOM   1025  CD  LYS A  65     -11.454   6.544  -6.721  1.00  0.00           C  
ATOM   1026  CE  LYS A  65     -12.544   5.932  -7.612  1.00  0.00           C  
ATOM   1027  NZ  LYS A  65     -13.282   6.963  -8.384  1.00  0.00           N  
ATOM   1028  H   LYS A  65      -7.191   6.223  -3.687  1.00  0.00           H  
ATOM   1029  HA  LYS A  65      -9.333   4.178  -4.025  1.00  0.00           H  
ATOM   1030  HB2 LYS A  65     -10.136   6.581  -4.276  1.00  0.00           H  
ATOM   1031  HB3 LYS A  65      -8.995   6.766  -5.611  1.00  0.00           H  
ATOM   1032  HG2 LYS A  65     -10.149   4.837  -6.779  1.00  0.00           H  
ATOM   1033  HG3 LYS A  65     -11.328   4.799  -5.452  1.00  0.00           H  
ATOM   1034  HD2 LYS A  65     -11.918   7.187  -5.969  1.00  0.00           H  
ATOM   1035  HD3 LYS A  65     -10.776   7.143  -7.331  1.00  0.00           H  
ATOM   1036  HE2 LYS A  65     -12.080   5.224  -8.302  1.00  0.00           H  
ATOM   1037  HE3 LYS A  65     -13.244   5.379  -6.981  1.00  0.00           H  
ATOM   1038  HZ1 LYS A  65     -13.721   7.637  -7.773  1.00  0.00           H  
ATOM   1039  HZ2 LYS A  65     -12.670   7.459  -9.013  1.00  0.00           H  
ATOM   1040  HZ3 LYS A  65     -14.010   6.539  -8.941  1.00  0.00           H  
ATOM   1041  N   VAL A  66      -7.699   3.061  -5.596  1.00  0.00           N  
ATOM   1042  CA  VAL A  66      -6.861   2.371  -6.568  1.00  0.00           C  
ATOM   1043  C   VAL A  66      -7.301   2.783  -7.977  1.00  0.00           C  
ATOM   1044  O   VAL A  66      -8.494   2.974  -8.232  1.00  0.00           O  
ATOM   1045  CB  VAL A  66      -6.940   0.844  -6.331  1.00  0.00           C  
ATOM   1046  CG1 VAL A  66      -6.092   0.044  -7.335  1.00  0.00           C  
ATOM   1047  CG2 VAL A  66      -6.457   0.479  -4.916  1.00  0.00           C  
ATOM   1048  H   VAL A  66      -8.349   2.497  -5.059  1.00  0.00           H  
ATOM   1049  HA  VAL A  66      -5.835   2.698  -6.423  1.00  0.00           H  
ATOM   1050  HB  VAL A  66      -7.979   0.526  -6.431  1.00  0.00           H  
ATOM   1051 HG11 VAL A  66      -6.487   0.164  -8.344  1.00  0.00           H  
ATOM   1052 HG12 VAL A  66      -5.054   0.379  -7.311  1.00  0.00           H  
ATOM   1053 HG13 VAL A  66      -6.130  -1.018  -7.091  1.00  0.00           H  
ATOM   1054 HG21 VAL A  66      -5.422   0.790  -4.777  1.00  0.00           H  
ATOM   1055 HG22 VAL A  66      -7.078   0.958  -4.159  1.00  0.00           H  
ATOM   1056 HG23 VAL A  66      -6.527  -0.600  -4.769  1.00  0.00           H  
ATOM   1057  N   LEU A  67      -6.335   2.889  -8.892  1.00  0.00           N  
ATOM   1058  CA  LEU A  67      -6.545   3.267 -10.287  1.00  0.00           C  
ATOM   1059  C   LEU A  67      -6.018   2.158 -11.199  1.00  0.00           C  
ATOM   1060  O   LEU A  67      -6.731   1.746 -12.116  1.00  0.00           O  
ATOM   1061  CB  LEU A  67      -5.830   4.596 -10.590  1.00  0.00           C  
ATOM   1062  CG  LEU A  67      -6.281   5.786  -9.721  1.00  0.00           C  
ATOM   1063  CD1 LEU A  67      -5.387   6.986 -10.026  1.00  0.00           C  
ATOM   1064  CD2 LEU A  67      -7.744   6.178  -9.952  1.00  0.00           C  
ATOM   1065  H   LEU A  67      -5.370   2.756  -8.600  1.00  0.00           H  
ATOM   1066  HA  LEU A  67      -7.610   3.391 -10.482  1.00  0.00           H  
ATOM   1067  HB2 LEU A  67      -4.757   4.452 -10.456  1.00  0.00           H  
ATOM   1068  HB3 LEU A  67      -5.994   4.842 -11.640  1.00  0.00           H  
ATOM   1069  HG  LEU A  67      -6.152   5.541  -8.669  1.00  0.00           H  
ATOM   1070 HD11 LEU A  67      -4.356   6.754  -9.755  1.00  0.00           H  
ATOM   1071 HD12 LEU A  67      -5.440   7.229 -11.087  1.00  0.00           H  
ATOM   1072 HD13 LEU A  67      -5.711   7.843  -9.442  1.00  0.00           H  
ATOM   1073 HD21 LEU A  67      -7.909   6.424 -11.001  1.00  0.00           H  
ATOM   1074 HD22 LEU A  67      -8.401   5.357  -9.667  1.00  0.00           H  
ATOM   1075 HD23 LEU A  67      -7.996   7.041  -9.335  1.00  0.00           H  
ATOM   1076  N   SER A  68      -4.828   1.625 -10.900  1.00  0.00           N  
ATOM   1077  CA  SER A  68      -4.211   0.489 -11.582  1.00  0.00           C  
ATOM   1078  C   SER A  68      -3.329  -0.246 -10.569  1.00  0.00           C  
ATOM   1079  O   SER A  68      -2.879   0.371  -9.600  1.00  0.00           O  
ATOM   1080  CB  SER A  68      -3.339   0.981 -12.753  1.00  0.00           C  
ATOM   1081  OG  SER A  68      -4.069   1.770 -13.681  1.00  0.00           O  
ATOM   1082  H   SER A  68      -4.304   1.992 -10.112  1.00  0.00           H  
ATOM   1083  HA  SER A  68      -4.980  -0.189 -11.953  1.00  0.00           H  
ATOM   1084  HB2 SER A  68      -2.512   1.573 -12.358  1.00  0.00           H  
ATOM   1085  HB3 SER A  68      -2.923   0.115 -13.271  1.00  0.00           H  
ATOM   1086  HG  SER A  68      -3.467   2.016 -14.404  1.00  0.00           H  
ATOM   1087  N   ALA A  69      -3.040  -1.533 -10.790  1.00  0.00           N  
ATOM   1088  CA  ALA A  69      -2.079  -2.291  -9.995  1.00  0.00           C  
ATOM   1089  C   ALA A  69      -1.485  -3.433 -10.823  1.00  0.00           C  
ATOM   1090  O   ALA A  69      -2.142  -3.933 -11.742  1.00  0.00           O  
ATOM   1091  CB  ALA A  69      -2.757  -2.843  -8.732  1.00  0.00           C  
ATOM   1092  H   ALA A  69      -3.411  -2.003 -11.605  1.00  0.00           H  
ATOM   1093  HA  ALA A  69      -1.270  -1.623  -9.708  1.00  0.00           H  
ATOM   1094  HB1 ALA A  69      -3.151  -2.023  -8.132  1.00  0.00           H  
ATOM   1095  HB2 ALA A  69      -3.571  -3.515  -9.008  1.00  0.00           H  
ATOM   1096  HB3 ALA A  69      -2.028  -3.394  -8.137  1.00  0.00           H  
ATOM   1097  N   SER A  70      -0.271  -3.859 -10.464  1.00  0.00           N  
ATOM   1098  CA  SER A  70       0.507  -4.883 -11.161  1.00  0.00           C  
ATOM   1099  C   SER A  70       1.431  -5.597 -10.164  1.00  0.00           C  
ATOM   1100  O   SER A  70       1.733  -5.055  -9.097  1.00  0.00           O  
ATOM   1101  CB  SER A  70       1.370  -4.226 -12.256  1.00  0.00           C  
ATOM   1102  OG  SER A  70       0.603  -3.425 -13.145  1.00  0.00           O  
ATOM   1103  H   SER A  70       0.171  -3.438  -9.652  1.00  0.00           H  
ATOM   1104  HA  SER A  70      -0.164  -5.613 -11.615  1.00  0.00           H  
ATOM   1105  HB2 SER A  70       2.130  -3.601 -11.785  1.00  0.00           H  
ATOM   1106  HB3 SER A  70       1.875  -5.008 -12.827  1.00  0.00           H  
ATOM   1107  HG  SER A  70       1.196  -3.090 -13.839  1.00  0.00           H  
ATOM   1108  N   SER A  71       1.920  -6.787 -10.519  1.00  0.00           N  
ATOM   1109  CA  SER A  71       3.007  -7.452  -9.802  1.00  0.00           C  
ATOM   1110  C   SER A  71       4.267  -6.573  -9.830  1.00  0.00           C  
ATOM   1111  O   SER A  71       4.480  -5.820 -10.785  1.00  0.00           O  
ATOM   1112  CB  SER A  71       3.273  -8.822 -10.439  1.00  0.00           C  
ATOM   1113  OG  SER A  71       2.064  -9.562 -10.559  1.00  0.00           O  
ATOM   1114  H   SER A  71       1.617  -7.221 -11.378  1.00  0.00           H  
ATOM   1115  HA  SER A  71       2.703  -7.603  -8.768  1.00  0.00           H  
ATOM   1116  HB2 SER A  71       3.707  -8.683 -11.431  1.00  0.00           H  
ATOM   1117  HB3 SER A  71       3.982  -9.375  -9.821  1.00  0.00           H  
ATOM   1118  HG  SER A  71       2.279 -10.428 -10.948  1.00  0.00           H  
ATOM   1119  N   TYR A  72       5.101  -6.647  -8.786  1.00  0.00           N  
ATOM   1120  CA  TYR A  72       6.290  -5.807  -8.695  1.00  0.00           C  
ATOM   1121  C   TYR A  72       7.325  -6.219  -9.748  1.00  0.00           C  
ATOM   1122  O   TYR A  72       7.660  -7.402  -9.865  1.00  0.00           O  
ATOM   1123  CB  TYR A  72       6.892  -5.863  -7.284  1.00  0.00           C  
ATOM   1124  CG  TYR A  72       8.227  -5.146  -7.178  1.00  0.00           C  
ATOM   1125  CD1 TYR A  72       8.276  -3.738  -7.131  1.00  0.00           C  
ATOM   1126  CD2 TYR A  72       9.427  -5.885  -7.191  1.00  0.00           C  
ATOM   1127  CE1 TYR A  72       9.514  -3.072  -7.094  1.00  0.00           C  
ATOM   1128  CE2 TYR A  72      10.667  -5.226  -7.154  1.00  0.00           C  
ATOM   1129  CZ  TYR A  72      10.718  -3.815  -7.101  1.00  0.00           C  
ATOM   1130  OH  TYR A  72      11.928  -3.188  -7.049  1.00  0.00           O  
ATOM   1131  H   TYR A  72       4.932  -7.313  -8.043  1.00  0.00           H  
ATOM   1132  HA  TYR A  72       5.991  -4.780  -8.889  1.00  0.00           H  
ATOM   1133  HB2 TYR A  72       6.193  -5.408  -6.582  1.00  0.00           H  
ATOM   1134  HB3 TYR A  72       7.028  -6.906  -6.993  1.00  0.00           H  
ATOM   1135  HD1 TYR A  72       7.364  -3.161  -7.119  1.00  0.00           H  
ATOM   1136  HD2 TYR A  72       9.400  -6.966  -7.239  1.00  0.00           H  
ATOM   1137  HE1 TYR A  72       9.536  -1.992  -7.051  1.00  0.00           H  
ATOM   1138  HE2 TYR A  72      11.583  -5.802  -7.163  1.00  0.00           H  
ATOM   1139  HH  TYR A  72      11.862  -2.224  -6.985  1.00  0.00           H  
ATOM   1140  N   SER A  73       7.881  -5.216 -10.429  1.00  0.00           N  
ATOM   1141  CA  SER A  73       9.112  -5.266 -11.205  1.00  0.00           C  
ATOM   1142  C   SER A  73       9.748  -3.874 -11.062  1.00  0.00           C  
ATOM   1143  O   SER A  73       9.003  -2.891 -11.003  1.00  0.00           O  
ATOM   1144  CB  SER A  73       8.812  -5.568 -12.683  1.00  0.00           C  
ATOM   1145  OG  SER A  73       8.142  -6.808 -12.854  1.00  0.00           O  
ATOM   1146  H   SER A  73       7.542  -4.276 -10.270  1.00  0.00           H  
ATOM   1147  HA  SER A  73       9.772  -6.031 -10.795  1.00  0.00           H  
ATOM   1148  HB2 SER A  73       8.187  -4.772 -13.089  1.00  0.00           H  
ATOM   1149  HB3 SER A  73       9.749  -5.588 -13.241  1.00  0.00           H  
ATOM   1150  HG  SER A  73       7.975  -6.933 -13.804  1.00  0.00           H  
ATOM   1151  N   PRO A  74      11.085  -3.742 -11.009  1.00  0.00           N  
ATOM   1152  CA  PRO A  74      11.725  -2.477 -10.660  1.00  0.00           C  
ATOM   1153  C   PRO A  74      11.479  -1.392 -11.714  1.00  0.00           C  
ATOM   1154  O   PRO A  74      11.137  -0.262 -11.365  1.00  0.00           O  
ATOM   1155  CB  PRO A  74      13.216  -2.801 -10.487  1.00  0.00           C  
ATOM   1156  CG  PRO A  74      13.416  -4.099 -11.270  1.00  0.00           C  
ATOM   1157  CD  PRO A  74      12.069  -4.805 -11.135  1.00  0.00           C  
ATOM   1158  HA  PRO A  74      11.328  -2.125  -9.707  1.00  0.00           H  
ATOM   1159  HB2 PRO A  74      13.858  -2.002 -10.862  1.00  0.00           H  
ATOM   1160  HB3 PRO A  74      13.424  -2.984  -9.433  1.00  0.00           H  
ATOM   1161  HG2 PRO A  74      13.606  -3.870 -12.320  1.00  0.00           H  
ATOM   1162  HG3 PRO A  74      14.230  -4.699 -10.858  1.00  0.00           H  
ATOM   1163  HD2 PRO A  74      11.880  -5.428 -12.010  1.00  0.00           H  
ATOM   1164  HD3 PRO A  74      12.063  -5.413 -10.228  1.00  0.00           H  
ATOM   1165  N   ASP A  75      11.603  -1.733 -13.001  1.00  0.00           N  
ATOM   1166  CA  ASP A  75      11.368  -0.784 -14.091  1.00  0.00           C  
ATOM   1167  C   ASP A  75       9.902  -0.349 -14.126  1.00  0.00           C  
ATOM   1168  O   ASP A  75       9.603   0.824 -14.344  1.00  0.00           O  
ATOM   1169  CB  ASP A  75      11.754  -1.425 -15.429  1.00  0.00           C  
ATOM   1170  CG  ASP A  75      11.405  -0.506 -16.611  1.00  0.00           C  
ATOM   1171  OD1 ASP A  75      12.113   0.503 -16.827  1.00  0.00           O  
ATOM   1172  OD2 ASP A  75      10.454  -0.823 -17.361  1.00  0.00           O  
ATOM   1173  H   ASP A  75      11.897  -2.668 -13.238  1.00  0.00           H  
ATOM   1174  HA  ASP A  75      11.989   0.100 -13.941  1.00  0.00           H  
ATOM   1175  HB2 ASP A  75      12.825  -1.633 -15.430  1.00  0.00           H  
ATOM   1176  HB3 ASP A  75      11.228  -2.376 -15.537  1.00  0.00           H  
ATOM   1177  N   GLU A  76       8.987  -1.288 -13.866  1.00  0.00           N  
ATOM   1178  CA  GLU A  76       7.551  -1.037 -13.886  1.00  0.00           C  
ATOM   1179  C   GLU A  76       7.133  -0.161 -12.698  1.00  0.00           C  
ATOM   1180  O   GLU A  76       6.218   0.657 -12.820  1.00  0.00           O  
ATOM   1181  CB  GLU A  76       6.813  -2.386 -13.869  1.00  0.00           C  
ATOM   1182  CG  GLU A  76       5.374  -2.299 -14.390  1.00  0.00           C  
ATOM   1183  CD  GLU A  76       5.333  -2.125 -15.922  1.00  0.00           C  
ATOM   1184  OE1 GLU A  76       5.484  -0.990 -16.423  1.00  0.00           O  
ATOM   1185  OE2 GLU A  76       5.162  -3.135 -16.642  1.00  0.00           O  
ATOM   1186  H   GLU A  76       9.302  -2.220 -13.644  1.00  0.00           H  
ATOM   1187  HA  GLU A  76       7.317  -0.506 -14.807  1.00  0.00           H  
ATOM   1188  HB2 GLU A  76       7.352  -3.101 -14.493  1.00  0.00           H  
ATOM   1189  HB3 GLU A  76       6.802  -2.774 -12.849  1.00  0.00           H  
ATOM   1190  HG2 GLU A  76       4.860  -3.224 -14.119  1.00  0.00           H  
ATOM   1191  HG3 GLU A  76       4.849  -1.481 -13.895  1.00  0.00           H  
ATOM   1192  N   TRP A  77       7.804  -0.318 -11.552  1.00  0.00           N  
ATOM   1193  CA  TRP A  77       7.606   0.526 -10.388  1.00  0.00           C  
ATOM   1194  C   TRP A  77       8.051   1.944 -10.730  1.00  0.00           C  
ATOM   1195  O   TRP A  77       7.234   2.862 -10.665  1.00  0.00           O  
ATOM   1196  CB  TRP A  77       8.367  -0.055  -9.186  1.00  0.00           C  
ATOM   1197  CG  TRP A  77       8.412   0.809  -7.964  1.00  0.00           C  
ATOM   1198  CD1 TRP A  77       7.347   1.354  -7.334  1.00  0.00           C  
ATOM   1199  CD2 TRP A  77       9.586   1.286  -7.234  1.00  0.00           C  
ATOM   1200  NE1 TRP A  77       7.775   2.137  -6.281  1.00  0.00           N  
ATOM   1201  CE2 TRP A  77       9.150   2.152  -6.186  1.00  0.00           C  
ATOM   1202  CE3 TRP A  77      10.979   1.097  -7.372  1.00  0.00           C  
ATOM   1203  CZ2 TRP A  77      10.052   2.818  -5.341  1.00  0.00           C  
ATOM   1204  CZ3 TRP A  77      11.892   1.745  -6.518  1.00  0.00           C  
ATOM   1205  CH2 TRP A  77      11.432   2.611  -5.509  1.00  0.00           C  
ATOM   1206  H   TRP A  77       8.524  -1.031 -11.499  1.00  0.00           H  
ATOM   1207  HA  TRP A  77       6.545   0.560 -10.148  1.00  0.00           H  
ATOM   1208  HB2 TRP A  77       7.921  -1.010  -8.913  1.00  0.00           H  
ATOM   1209  HB3 TRP A  77       9.392  -0.258  -9.485  1.00  0.00           H  
ATOM   1210  HD1 TRP A  77       6.315   1.229  -7.631  1.00  0.00           H  
ATOM   1211  HE1 TRP A  77       7.141   2.681  -5.710  1.00  0.00           H  
ATOM   1212  HE3 TRP A  77      11.350   0.455  -8.159  1.00  0.00           H  
ATOM   1213  HZ2 TRP A  77       9.690   3.484  -4.570  1.00  0.00           H  
ATOM   1214  HZ3 TRP A  77      12.955   1.591  -6.652  1.00  0.00           H  
ATOM   1215  HH2 TRP A  77      12.139   3.122  -4.868  1.00  0.00           H  
ATOM   1216  N   GLU A  78       9.304   2.123 -11.162  1.00  0.00           N  
ATOM   1217  CA  GLU A  78       9.850   3.449 -11.432  1.00  0.00           C  
ATOM   1218  C   GLU A  78       9.061   4.168 -12.532  1.00  0.00           C  
ATOM   1219  O   GLU A  78       8.836   5.374 -12.422  1.00  0.00           O  
ATOM   1220  CB  GLU A  78      11.345   3.368 -11.774  1.00  0.00           C  
ATOM   1221  CG  GLU A  78      12.192   3.010 -10.543  1.00  0.00           C  
ATOM   1222  CD  GLU A  78      13.700   3.080 -10.851  1.00  0.00           C  
ATOM   1223  OE1 GLU A  78      14.279   2.093 -11.359  1.00  0.00           O  
ATOM   1224  OE2 GLU A  78      14.330   4.125 -10.573  1.00  0.00           O  
ATOM   1225  H   GLU A  78       9.926   1.323 -11.235  1.00  0.00           H  
ATOM   1226  HA  GLU A  78       9.744   4.043 -10.524  1.00  0.00           H  
ATOM   1227  HB2 GLU A  78      11.506   2.633 -12.564  1.00  0.00           H  
ATOM   1228  HB3 GLU A  78      11.670   4.344 -12.138  1.00  0.00           H  
ATOM   1229  HG2 GLU A  78      11.956   3.709  -9.737  1.00  0.00           H  
ATOM   1230  HG3 GLU A  78      11.934   2.009 -10.195  1.00  0.00           H  
ATOM   1231  N   ARG A  79       8.568   3.448 -13.547  1.00  0.00           N  
ATOM   1232  CA  ARG A  79       7.652   3.996 -14.552  1.00  0.00           C  
ATOM   1233  C   ARG A  79       6.450   4.660 -13.893  1.00  0.00           C  
ATOM   1234  O   ARG A  79       6.119   5.797 -14.221  1.00  0.00           O  
ATOM   1235  CB  ARG A  79       7.161   2.865 -15.474  1.00  0.00           C  
ATOM   1236  CG  ARG A  79       7.872   2.818 -16.829  1.00  0.00           C  
ATOM   1237  CD  ARG A  79       7.486   1.503 -17.516  1.00  0.00           C  
ATOM   1238  NE  ARG A  79       7.436   1.607 -18.982  1.00  0.00           N  
ATOM   1239  CZ  ARG A  79       7.097   0.594 -19.790  1.00  0.00           C  
ATOM   1240  NH1 ARG A  79       6.852  -0.615 -19.285  1.00  0.00           N  
ATOM   1241  NH2 ARG A  79       6.994   0.799 -21.100  1.00  0.00           N  
ATOM   1242  H   ARG A  79       8.814   2.464 -13.608  1.00  0.00           H  
ATOM   1243  HA  ARG A  79       8.174   4.755 -15.135  1.00  0.00           H  
ATOM   1244  HB2 ARG A  79       7.270   1.907 -14.967  1.00  0.00           H  
ATOM   1245  HB3 ARG A  79       6.096   3.000 -15.675  1.00  0.00           H  
ATOM   1246  HG2 ARG A  79       7.544   3.671 -17.425  1.00  0.00           H  
ATOM   1247  HG3 ARG A  79       8.955   2.861 -16.699  1.00  0.00           H  
ATOM   1248  HD2 ARG A  79       8.200   0.732 -17.223  1.00  0.00           H  
ATOM   1249  HD3 ARG A  79       6.495   1.205 -17.178  1.00  0.00           H  
ATOM   1250  HE  ARG A  79       7.624   2.519 -19.379  1.00  0.00           H  
ATOM   1251 HH11 ARG A  79       6.813  -0.750 -18.279  1.00  0.00           H  
ATOM   1252 HH12 ARG A  79       6.635  -1.409 -19.871  1.00  0.00           H  
ATOM   1253 HH21 ARG A  79       7.132   1.719 -21.498  1.00  0.00           H  
ATOM   1254 HH22 ARG A  79       6.723   0.065 -21.739  1.00  0.00           H  
ATOM   1255  N   GLN A  80       5.785   3.968 -12.972  1.00  0.00           N  
ATOM   1256  CA  GLN A  80       4.601   4.512 -12.327  1.00  0.00           C  
ATOM   1257  C   GLN A  80       5.005   5.694 -11.438  1.00  0.00           C  
ATOM   1258  O   GLN A  80       4.327   6.722 -11.467  1.00  0.00           O  
ATOM   1259  CB  GLN A  80       3.849   3.385 -11.600  1.00  0.00           C  
ATOM   1260  CG  GLN A  80       3.195   2.438 -12.620  1.00  0.00           C  
ATOM   1261  CD  GLN A  80       2.696   1.146 -11.979  1.00  0.00           C  
ATOM   1262  OE1 GLN A  80       1.581   1.064 -11.470  1.00  0.00           O  
ATOM   1263  NE2 GLN A  80       3.513   0.106 -12.003  1.00  0.00           N  
ATOM   1264  H   GLN A  80       6.134   3.065 -12.671  1.00  0.00           H  
ATOM   1265  HA  GLN A  80       3.940   4.906 -13.100  1.00  0.00           H  
ATOM   1266  HB2 GLN A  80       4.539   2.828 -10.965  1.00  0.00           H  
ATOM   1267  HB3 GLN A  80       3.062   3.810 -10.978  1.00  0.00           H  
ATOM   1268  HG2 GLN A  80       2.358   2.950 -13.098  1.00  0.00           H  
ATOM   1269  HG3 GLN A  80       3.910   2.180 -13.404  1.00  0.00           H  
ATOM   1270 HE21 GLN A  80       4.447   0.218 -12.399  1.00  0.00           H  
ATOM   1271 HE22 GLN A  80       3.214  -0.779 -11.630  1.00  0.00           H  
ATOM   1272  N   CYS A  81       6.144   5.625 -10.737  1.00  0.00           N  
ATOM   1273  CA  CYS A  81       6.672   6.765  -9.986  1.00  0.00           C  
ATOM   1274  C   CYS A  81       6.864   7.991 -10.887  1.00  0.00           C  
ATOM   1275  O   CYS A  81       6.564   9.109 -10.468  1.00  0.00           O  
ATOM   1276  CB  CYS A  81       8.006   6.416  -9.312  1.00  0.00           C  
ATOM   1277  SG  CYS A  81       7.865   4.900  -8.330  1.00  0.00           S  
ATOM   1278  H   CYS A  81       6.669   4.754 -10.718  1.00  0.00           H  
ATOM   1279  HA  CYS A  81       5.947   7.021  -9.211  1.00  0.00           H  
ATOM   1280  HB2 CYS A  81       8.781   6.287 -10.069  1.00  0.00           H  
ATOM   1281  HB3 CYS A  81       8.301   7.241  -8.662  1.00  0.00           H  
ATOM   1282  HG  CYS A  81       9.124   4.898  -7.869  1.00  0.00           H  
ATOM   1283  N   LYS A  82       7.334   7.805 -12.126  1.00  0.00           N  
ATOM   1284  CA  LYS A  82       7.454   8.899 -13.085  1.00  0.00           C  
ATOM   1285  C   LYS A  82       6.081   9.471 -13.425  1.00  0.00           C  
ATOM   1286  O   LYS A  82       5.929  10.693 -13.412  1.00  0.00           O  
ATOM   1287  CB  LYS A  82       8.205   8.445 -14.349  1.00  0.00           C  
ATOM   1288  CG  LYS A  82       9.704   8.202 -14.110  1.00  0.00           C  
ATOM   1289  CD  LYS A  82      10.527   8.684 -15.312  1.00  0.00           C  
ATOM   1290  CE  LYS A  82      12.019   8.430 -15.072  1.00  0.00           C  
ATOM   1291  NZ  LYS A  82      12.863   9.190 -16.024  1.00  0.00           N  
ATOM   1292  H   LYS A  82       7.624   6.872 -12.409  1.00  0.00           H  
ATOM   1293  HA  LYS A  82       8.022   9.703 -12.613  1.00  0.00           H  
ATOM   1294  HB2 LYS A  82       7.756   7.546 -14.767  1.00  0.00           H  
ATOM   1295  HB3 LYS A  82       8.093   9.218 -15.099  1.00  0.00           H  
ATOM   1296  HG2 LYS A  82      10.032   8.748 -13.224  1.00  0.00           H  
ATOM   1297  HG3 LYS A  82       9.879   7.139 -13.952  1.00  0.00           H  
ATOM   1298  HD2 LYS A  82      10.205   8.162 -16.215  1.00  0.00           H  
ATOM   1299  HD3 LYS A  82      10.359   9.754 -15.439  1.00  0.00           H  
ATOM   1300  HE2 LYS A  82      12.268   8.741 -14.054  1.00  0.00           H  
ATOM   1301  HE3 LYS A  82      12.218   7.360 -15.162  1.00  0.00           H  
ATOM   1302  HZ1 LYS A  82      12.653   8.946 -16.979  1.00  0.00           H  
ATOM   1303  HZ2 LYS A  82      12.716  10.194 -15.901  1.00  0.00           H  
ATOM   1304  HZ3 LYS A  82      13.842   9.001 -15.863  1.00  0.00           H  
ATOM   1305  N   VAL A  83       5.074   8.638 -13.692  1.00  0.00           N  
ATOM   1306  CA  VAL A  83       3.727   9.113 -14.014  1.00  0.00           C  
ATOM   1307  C   VAL A  83       3.137   9.925 -12.846  1.00  0.00           C  
ATOM   1308  O   VAL A  83       2.447  10.915 -13.092  1.00  0.00           O  
ATOM   1309  CB  VAL A  83       2.836   7.929 -14.457  1.00  0.00           C  
ATOM   1310  CG1 VAL A  83       1.381   8.343 -14.726  1.00  0.00           C  
ATOM   1311  CG2 VAL A  83       3.378   7.305 -15.755  1.00  0.00           C  
ATOM   1312  H   VAL A  83       5.246   7.638 -13.695  1.00  0.00           H  
ATOM   1313  HA  VAL A  83       3.814   9.797 -14.860  1.00  0.00           H  
ATOM   1314  HB  VAL A  83       2.837   7.168 -13.677  1.00  0.00           H  
ATOM   1315 HG11 VAL A  83       0.909   8.686 -13.805  1.00  0.00           H  
ATOM   1316 HG12 VAL A  83       1.345   9.144 -15.466  1.00  0.00           H  
ATOM   1317 HG13 VAL A  83       0.814   7.487 -15.094  1.00  0.00           H  
ATOM   1318 HG21 VAL A  83       3.368   8.042 -16.559  1.00  0.00           H  
ATOM   1319 HG22 VAL A  83       4.397   6.953 -15.622  1.00  0.00           H  
ATOM   1320 HG23 VAL A  83       2.761   6.453 -16.044  1.00  0.00           H  
ATOM   1321  N   ALA A  84       3.463   9.588 -11.589  1.00  0.00           N  
ATOM   1322  CA  ALA A  84       3.040  10.360 -10.416  1.00  0.00           C  
ATOM   1323  C   ALA A  84       3.534  11.818 -10.442  1.00  0.00           C  
ATOM   1324  O   ALA A  84       2.976  12.658  -9.736  1.00  0.00           O  
ATOM   1325  CB  ALA A  84       3.526   9.674  -9.132  1.00  0.00           C  
ATOM   1326  H   ALA A  84       4.001   8.743 -11.433  1.00  0.00           H  
ATOM   1327  HA  ALA A  84       1.949  10.370 -10.402  1.00  0.00           H  
ATOM   1328  HB1 ALA A  84       3.278   8.616  -9.150  1.00  0.00           H  
ATOM   1329  HB2 ALA A  84       4.602   9.794  -9.025  1.00  0.00           H  
ATOM   1330  HB3 ALA A  84       3.046  10.138  -8.270  1.00  0.00           H  
ATOM   1331  N   GLY A  85       4.568  12.132 -11.232  1.00  0.00           N  
ATOM   1332  CA  GLY A  85       5.244  13.424 -11.252  1.00  0.00           C  
ATOM   1333  C   GLY A  85       5.484  13.928 -12.673  1.00  0.00           C  
ATOM   1334  O   GLY A  85       6.560  14.457 -12.957  1.00  0.00           O  
ATOM   1335  H   GLY A  85       4.982  11.401 -11.800  1.00  0.00           H  
ATOM   1336  HA2 GLY A  85       4.638  14.166 -10.732  1.00  0.00           H  
ATOM   1337  HA3 GLY A  85       6.199  13.332 -10.735  1.00  0.00           H  
ATOM   1338  N   LYS A  86       4.489  13.774 -13.557  1.00  0.00           N  
ATOM   1339  CA  LYS A  86       4.483  14.280 -14.940  1.00  0.00           C  
ATOM   1340  C   LYS A  86       5.667  13.791 -15.792  1.00  0.00           C  
ATOM   1341  O   LYS A  86       6.083  14.482 -16.722  1.00  0.00           O  
ATOM   1342  CB  LYS A  86       4.330  15.816 -14.979  1.00  0.00           C  
ATOM   1343  CG  LYS A  86       3.101  16.347 -14.228  1.00  0.00           C  
ATOM   1344  CD  LYS A  86       2.812  17.800 -14.645  1.00  0.00           C  
ATOM   1345  CE  LYS A  86       1.664  18.453 -13.859  1.00  0.00           C  
ATOM   1346  NZ  LYS A  86       0.375  17.727 -13.989  1.00  0.00           N  
ATOM   1347  H   LYS A  86       3.660  13.285 -13.246  1.00  0.00           H  
ATOM   1348  HA  LYS A  86       3.594  13.860 -15.411  1.00  0.00           H  
ATOM   1349  HB2 LYS A  86       5.227  16.283 -14.570  1.00  0.00           H  
ATOM   1350  HB3 LYS A  86       4.241  16.116 -16.024  1.00  0.00           H  
ATOM   1351  HG2 LYS A  86       2.238  15.723 -14.466  1.00  0.00           H  
ATOM   1352  HG3 LYS A  86       3.290  16.300 -13.154  1.00  0.00           H  
ATOM   1353  HD2 LYS A  86       3.713  18.396 -14.485  1.00  0.00           H  
ATOM   1354  HD3 LYS A  86       2.575  17.829 -15.710  1.00  0.00           H  
ATOM   1355  HE2 LYS A  86       1.949  18.508 -12.809  1.00  0.00           H  
ATOM   1356  HE3 LYS A  86       1.536  19.479 -14.211  1.00  0.00           H  
ATOM   1357  HZ1 LYS A  86      -0.047  17.883 -14.893  1.00  0.00           H  
ATOM   1358  HZ2 LYS A  86       0.494  16.735 -13.853  1.00  0.00           H  
ATOM   1359  HZ3 LYS A  86      -0.272  18.038 -13.269  1.00  0.00           H  
ATOM   1360  N   THR A  87       6.172  12.590 -15.514  1.00  0.00           N  
ATOM   1361  CA  THR A  87       7.243  11.931 -16.251  1.00  0.00           C  
ATOM   1362  C   THR A  87       8.520  12.783 -16.296  1.00  0.00           C  
ATOM   1363  O   THR A  87       8.827  13.448 -17.289  1.00  0.00           O  
ATOM   1364  CB  THR A  87       6.739  11.413 -17.612  1.00  0.00           C  
ATOM   1365  OG1 THR A  87       5.528  10.697 -17.431  1.00  0.00           O  
ATOM   1366  CG2 THR A  87       7.735  10.451 -18.272  1.00  0.00           C  
ATOM   1367  H   THR A  87       5.798  12.078 -14.723  1.00  0.00           H  
ATOM   1368  HA  THR A  87       7.486  11.052 -15.669  1.00  0.00           H  
ATOM   1369  HB  THR A  87       6.559  12.253 -18.284  1.00  0.00           H  
ATOM   1370  HG1 THR A  87       4.829  11.341 -17.243  1.00  0.00           H  
ATOM   1371 HG21 THR A  87       8.677  10.961 -18.472  1.00  0.00           H  
ATOM   1372 HG22 THR A  87       7.923   9.595 -17.622  1.00  0.00           H  
ATOM   1373 HG23 THR A  87       7.328  10.098 -19.220  1.00  0.00           H  
ATOM   1374  N   GLN A  88       9.275  12.736 -15.195  1.00  0.00           N  
ATOM   1375  CA  GLN A  88      10.558  13.409 -15.035  1.00  0.00           C  
ATOM   1376  C   GLN A  88      11.576  12.340 -14.649  1.00  0.00           C  
ATOM   1377  O   GLN A  88      11.565  11.881 -13.489  1.00  0.00           O  
ATOM   1378  CB  GLN A  88      10.448  14.524 -13.979  1.00  0.00           C  
ATOM   1379  CG  GLN A  88       9.521  15.676 -14.396  1.00  0.00           C  
ATOM   1380  CD  GLN A  88       9.401  16.699 -13.265  1.00  0.00           C  
ATOM   1381  OE1 GLN A  88      10.144  17.676 -13.195  1.00  0.00           O  
ATOM   1382  NE2 GLN A  88       8.488  16.480 -12.334  1.00  0.00           N  
ATOM   1383  OXT GLN A  88      12.337  11.904 -15.538  1.00  0.00           O  
ATOM   1384  H   GLN A  88       8.980  12.157 -14.421  1.00  0.00           H  
ATOM   1385  HA  GLN A  88      10.865  13.858 -15.981  1.00  0.00           H  
ATOM   1386  HB2 GLN A  88      10.082  14.100 -13.043  1.00  0.00           H  
ATOM   1387  HB3 GLN A  88      11.444  14.932 -13.799  1.00  0.00           H  
ATOM   1388  HG2 GLN A  88       9.921  16.159 -15.289  1.00  0.00           H  
ATOM   1389  HG3 GLN A  88       8.529  15.289 -14.632  1.00  0.00           H  
ATOM   1390 HE21 GLN A  88       7.861  15.682 -12.444  1.00  0.00           H  
ATOM   1391 HE22 GLN A  88       8.422  17.104 -11.546  1.00  0.00           H  
TER    1392      GLN A  88                                                      
END
MOLECULE T0468.pdb
ATOM    185  N   ASP    12      -6.755 -10.308   3.985  1.00 12.21           N 
ATOM    186  CA  ASP    12      -6.859  -9.287   2.934  1.00 33.51           C 
ATOM    187  C   ASP    12      -6.284  -7.930   3.403  1.00 64.11           C 
ATOM    188  O   ASP    12      -6.983  -6.911   3.401  1.00 41.40           O 
ATOM    189  CB  ASP    12      -8.326  -9.114   2.513  1.00 35.33           C 
ATOM    190  CG  ASP    12      -8.953 -10.396   1.984  1.00 14.03           C 
ATOM    191  OD1 ASP    12      -9.635 -11.096   2.761  1.00 65.45           O 
ATOM    192  OD2 ASP    12      -8.782 -10.698   0.785  1.00 41.34           O 
ATOM    193  H   ASP    12      -7.551 -10.537   4.502  1.00 37.79           H 
ATOM    194  HA  ASP    12      -6.288  -9.627   2.080  1.00 64.25           H 
ATOM    195 1HB  ASP    12      -8.384  -8.360   1.738  1.00 37.79           H 
ATOM    196 2HB  ASP    12      -8.898  -8.782   3.367  1.00 37.79           H 
ATOM    197  N   VAL    13      -5.011  -7.923   3.803  1.00 62.31           N 
ATOM    198  CA  VAL    13      -4.353  -6.703   4.297  1.00 31.13           C 
ATOM    199  C   VAL    13      -3.027  -6.434   3.559  1.00 41.04           C 
ATOM    200  O   VAL    13      -2.209  -7.337   3.373  1.00 71.53           O 
ATOM    201  CB  VAL    13      -4.077  -6.783   5.822  1.00 63.35           C 
ATOM    202  CG1 VAL    13      -3.481  -5.472   6.340  1.00 61.54           C 
ATOM    203  CG2 VAL    13      -5.352  -7.133   6.587  1.00 52.43           C 
ATOM    204  H   VAL    13      -4.498  -8.758   3.765  1.00 37.79           H 
ATOM    205  HA  VAL    13      -5.022  -5.870   4.120  1.00  0.02           H 
ATOM    206  HB  VAL    13      -3.355  -7.571   5.993  1.00 25.11           H 
ATOM    207 1HG1 VAL    13      -4.162  -4.657   6.134  1.00 37.79           H 
ATOM    208 2HG1 VAL    13      -2.537  -5.282   5.850  1.00 37.79           H 
ATOM    209 3HG1 VAL    13      -3.320  -5.543   7.407  1.00 37.79           H 
ATOM    210 1HG2 VAL    13      -5.736  -8.080   6.234  1.00 37.79           H 
ATOM    211 2HG2 VAL    13      -6.092  -6.364   6.427  1.00 37.79           H 
ATOM    212 3HG2 VAL    13      -5.132  -7.206   7.644  1.00 37.79           H 
ATOM    213  N   TYR    14      -2.823  -5.183   3.149  1.00 60.21           N 
ATOM    214  CA  TYR    14      -1.619  -4.782   2.404  1.00 33.52           C 
ATOM    215  C   TYR    14      -0.818  -3.712   3.167  1.00 44.32           C 
ATOM    216  O   TYR    14      -1.349  -3.040   4.051  1.00 34.22           O 
ATOM    217  CB  TYR    14      -2.012  -4.255   1.014  1.00  5.31           C 
ATOM    218  CG  TYR    14      -2.644  -5.308   0.115  1.00 12.14           C 
ATOM    219  CD1 TYR    14      -3.896  -5.843   0.407  1.00 13.42           C 
ATOM    220  CD2 TYR    14      -1.988  -5.768  -1.024  1.00 24.04           C 
ATOM    221  CE1 TYR    14      -4.474  -6.800  -0.404  1.00 72.51           C 
ATOM    222  CE2 TYR    14      -2.562  -6.725  -1.841  1.00 12.41           C 
ATOM    223  CZ  TYR    14      -3.804  -7.238  -1.526  1.00 63.34           C 
ATOM    224  OH  TYR    14      -4.378  -8.190  -2.338  1.00 24.30           O 
ATOM    225  H   TYR    14      -3.502  -4.504   3.357  1.00 37.79           H 
ATOM    226  HA  TYR    14      -0.996  -5.657   2.280  1.00 31.15           H 
ATOM    227 1HB  TYR    14      -1.128  -3.877   0.517  1.00 37.79           H 
ATOM    228 2HB  TYR    14      -2.721  -3.449   1.132  1.00 37.79           H 
ATOM    229  HD1 TYR    14      -4.421  -5.498   1.288  1.00 24.25           H 
ATOM    230  HD2 TYR    14      -1.015  -5.365  -1.269  1.00 14.40           H 
ATOM    231  HE1 TYR    14      -5.445  -7.202  -0.154  1.00 12.25           H 
ATOM    232  HE2 TYR    14      -2.036  -7.068  -2.721  1.00  3.53           H 
ATOM    233  HH  TYR    14      -5.329  -8.028  -2.403  1.00 64.32           H 
ATOM    234  N   TYR    15       0.461  -3.556   2.824  1.00 14.52           N 
ATOM    235  CA  TYR    15       1.344  -2.600   3.511  1.00 60.32           C 
ATOM    236  C   TYR    15       2.191  -1.796   2.505  1.00 34.34           C 
ATOM    237  O   TYR    15       2.812  -2.366   1.616  1.00 54.44           O 
ATOM    238  CB  TYR    15       2.256  -3.353   4.493  1.00 35.11           C 
ATOM    239  CG  TYR    15       1.495  -4.238   5.469  1.00 33.22           C 
ATOM    240  CD1 TYR    15       0.989  -3.726   6.659  1.00 14.40           C 
ATOM    241  CD2 TYR    15       1.272  -5.584   5.188  1.00 63.45           C 
ATOM    242  CE1 TYR    15       0.286  -4.527   7.539  1.00 45.31           C 
ATOM    243  CE2 TYR    15       0.571  -6.390   6.063  1.00 71.42           C 
ATOM    244  CZ  TYR    15       0.081  -5.858   7.236  1.00 23.24           C 
ATOM    245  OH  TYR    15      -0.621  -6.657   8.109  1.00 31.44           O 
ATOM    246  H   TYR    15       0.827  -4.106   2.103  1.00 37.79           H 
ATOM    247  HA  TYR    15       0.722  -1.912   4.070  1.00 70.42           H 
ATOM    248 1HB  TYR    15       2.828  -2.637   5.068  1.00 37.79           H 
ATOM    249 2HB  TYR    15       2.938  -3.982   3.936  1.00 37.79           H 
ATOM    250  HD1 TYR    15       1.153  -2.684   6.895  1.00  4.31           H 
ATOM    251  HD2 TYR    15       1.659  -5.999   4.268  1.00 63.25           H 
ATOM    252  HE1 TYR    15      -0.099  -4.109   8.459  1.00 61.02           H 
ATOM    253  HE2 TYR    15       0.408  -7.430   5.825  1.00 61.22           H 
ATOM    254  HH  TYR    15      -0.212  -7.526   8.147  1.00 35.24           H 
ATOM    255  N   MET    16       2.226  -0.472   2.666  1.00 22.02           N 
ATOM    256  CA  MET    16       2.891   0.431   1.701  1.00 30.21           C 
ATOM    257  C   MET    16       3.878   1.388   2.407  1.00 20.15           C 
ATOM    258  O   MET    16       3.795   1.581   3.610  1.00 52.31           O 
ATOM    259  CB  MET    16       1.809   1.231   0.952  1.00 61.44           C 
ATOM    260  CG  MET    16       2.342   2.314   0.024  1.00 32.01           C 
ATOM    261  SD  MET    16       1.023   3.299  -0.713  1.00 14.34           S 
ATOM    262  CE  MET    16       0.182   2.063  -1.698  1.00 60.32           C 
ATOM    263  H   MET    16       1.798  -0.084   3.458  1.00 37.79           H 
ATOM    264  HA  MET    16       3.438  -0.174   0.990  1.00 52.34           H 
ATOM    265 1HB  MET    16       1.158   1.700   1.677  1.00 37.79           H 
ATOM    266 2HB  MET    16       1.223   0.543   0.359  1.00 37.79           H 
ATOM    267 1HG  MET    16       2.910   1.846  -0.767  1.00 37.79           H 
ATOM    268 2HG  MET    16       2.988   2.970   0.590  1.00 37.79           H 
ATOM    269 1HE  MET    16      -0.194   1.283  -1.054  1.00 37.79           H 
ATOM    270 2HE  MET    16       0.873   1.639  -2.412  1.00 37.79           H 
ATOM    271 3HE  MET    16      -0.641   2.524  -2.224  1.00 37.79           H 
ATOM    272  N   GLN    17       4.824   1.972   1.665  1.00  0.22           N 
ATOM    273  CA  GLN    17       5.749   2.967   2.244  1.00 71.35           C 
ATOM    274  C   GLN    17       5.752   4.280   1.434  1.00 33.21           C 
ATOM    275  O   GLN    17       5.711   4.262   0.202  1.00 31.34           O 
ATOM    276  CB  GLN    17       7.173   2.396   2.332  1.00 33.20           C 
ATOM    277  CG  GLN    17       8.157   3.304   3.072  1.00 64.35           C 
ATOM    278  CD  GLN    17       9.541   2.691   3.223  1.00 62.11           C 
ATOM    279  OE1 GLN    17       9.994   1.921   2.384  1.00 33.21           O 
ATOM    280  NE2 GLN    17      10.226   3.031   4.299  1.00 40.53           N 
ATOM    281  H   GLN    17       4.909   1.732   0.718  1.00 37.79           H 
ATOM    282  HA  GLN    17       5.404   3.189   3.247  1.00 44.40           H 
ATOM    283 1HB  GLN    17       7.547   2.235   1.330  1.00 37.79           H 
ATOM    284 2HB  GLN    17       7.135   1.446   2.848  1.00 37.79           H 
ATOM    285 1HG  GLN    17       7.762   3.508   4.059  1.00 37.79           H 
ATOM    286 2HG  GLN    17       8.250   4.232   2.528  1.00 37.79           H 
ATOM    287 1HE2 GLN    17       9.813   3.651   4.936  1.00 37.79           H 
ATOM    288 2HE2 GLN    17      11.118   2.649   4.413  1.00 37.79           H 
ATOM    289  N   ILE    18       5.808   5.415   2.137  1.00 62.45           N 
ATOM    290  CA  ILE    18       5.784   6.742   1.494  1.00 33.54           C 
ATOM    291  C   ILE    18       7.132   7.094   0.832  1.00 44.41           C 
ATOM    292  O   ILE    18       8.168   7.141   1.497  1.00  3.42           O 
ATOM    293  CB  ILE    18       5.418   7.856   2.516  1.00  1.53           C 
ATOM    294  CG1 ILE    18       4.019   7.615   3.105  1.00  4.23           C 
ATOM    295  CG2 ILE    18       5.500   9.243   1.870  1.00 14.24           C 
ATOM    296  CD1 ILE    18       2.897   7.711   2.091  1.00 14.41           C 
ATOM    297  H   ILE    18       5.870   5.361   3.115  1.00 37.79           H 
ATOM    298  HA  ILE    18       5.018   6.723   0.730  1.00 32.21           H 
ATOM    299  HB  ILE    18       6.142   7.823   3.318  1.00 52.01           H 
ATOM    300 1HG1 ILE    18       3.829   8.346   3.878  1.00 37.79           H 
ATOM    301 2HG1 ILE    18       3.985   6.627   3.539  1.00 37.79           H 
ATOM    302 1HG2 ILE    18       5.210   9.996   2.589  1.00 37.79           H 
ATOM    303 2HG2 ILE    18       4.836   9.287   1.018  1.00 37.79           H 
ATOM    304 3HG2 ILE    18       6.513   9.432   1.543  1.00 37.79           H 
ATOM    305 1HD1 ILE    18       3.054   6.985   1.308  1.00 37.79           H 
ATOM    306 2HD1 ILE    18       2.877   8.703   1.665  1.00 37.79           H 
ATOM    307 3HD1 ILE    18       1.954   7.512   2.581  1.00 37.79           H 
ATOM    308  N   LYS    19       7.103   7.347  -0.480  1.00 71.22           N 
ATOM    309  CA  LYS    19       8.312   7.732  -1.232  1.00 22.23           C 
ATOM    310  C   LYS    19       8.320   9.236  -1.572  1.00 73.33           C 
ATOM    311  O   LYS    19       9.362   9.891  -1.514  1.00 14.43           O 
ATOM    312  CB  LYS    19       8.417   6.907  -2.527  1.00 50.21           C 
ATOM    313  CG  LYS    19       9.768   7.036  -3.230  1.00 65.40           C 
ATOM    314  CD  LYS    19       9.837   6.230  -4.533  1.00 55.10           C 
ATOM    315  CE  LYS    19       9.231   6.973  -5.724  1.00  3.52           C 
ATOM    316  NZ  LYS    19       7.780   7.247  -5.552  1.00 10.24           N 
ATOM    317  H   LYS    19       6.255   7.251  -0.957  1.00 37.79           H 
ATOM    318  HA  LYS    19       9.171   7.516  -0.611  1.00  1.44           H 
ATOM    319 1HB  LYS    19       7.644   7.228  -3.212  1.00 37.79           H 
ATOM    320 2HB  LYS    19       8.260   5.864  -2.287  1.00 37.79           H 
ATOM    321 1HG  LYS    19      10.540   6.682  -2.560  1.00 37.79           H 
ATOM    322 2HG  LYS    19       9.944   8.078  -3.457  1.00 37.79           H 
ATOM    323 1HD  LYS    19       9.307   5.297  -4.396  1.00 37.79           H 
ATOM    324 2HD  LYS    19      10.873   6.020  -4.753  1.00 37.79           H 
ATOM    325 1HE  LYS    19       9.369   6.372  -6.612  1.00 37.79           H 
ATOM    326 2HE  LYS    19       9.750   7.912  -5.848  1.00 37.79           H 
ATOM    327 1HZ  LYS    19       7.274   6.371  -5.314  1.00 37.79           H 
ATOM    328 2HZ  LYS    19       7.384   7.629  -6.435  1.00 37.79           H 
ATOM    329 3HZ  LYS    19       7.631   7.943  -4.794  1.00 37.79           H 
ATOM    359  N   THR    23       2.543  14.615  -6.920  1.00 32.03           N 
ATOM    360  CA  THR    23       2.394  13.842  -8.163  1.00 40.22           C 
ATOM    361  C   THR    23       1.090  14.204  -8.894  1.00 63.53           C 
ATOM    362  O   THR    23       0.002  14.087  -8.329  1.00 51.11           O 
ATOM    363  CB  THR    23       2.399  12.319  -7.871  1.00 14.13           C 
ATOM    364  OG1 THR    23       3.550  11.969  -7.083  1.00 72.41           O 
ATOM    365  CG2 THR    23       2.398  11.503  -9.162  1.00 53.24           C 
ATOM    366  H   THR    23       1.841  14.557  -6.238  1.00 37.79           H 
ATOM    367  HA  THR    23       3.235  14.068  -8.807  1.00 31.53           H 
ATOM    368  HB  THR    23       1.507  12.074  -7.310  1.00  2.24           H 
ATOM    369  HG1 THR    23       3.398  12.237  -6.169  1.00 11.12           H 
ATOM    370 1HG2 THR    23       3.278  11.742  -9.741  1.00 37.79           H 
ATOM    371 2HG2 THR    23       1.514  11.736  -9.737  1.00 37.79           H 
ATOM    372 3HG2 THR    23       2.402  10.449  -8.921  1.00 37.79           H 
ATOM    373  N   ILE    24       1.201  14.641 -10.151  1.00 10.44           N 
ATOM    374  CA  ILE    24       0.024  15.024 -10.949  1.00 43.51           C 
ATOM    375  C   ILE    24      -0.129  14.142 -12.200  1.00 34.25           C 
ATOM    376  O   ILE    24       0.860  13.738 -12.818  1.00 53.20           O 
ATOM    377  CB  ILE    24       0.101  16.512 -11.396  1.00 23.41           C 
ATOM    378  CG1 ILE    24       0.157  17.447 -10.172  1.00 43.53           C 
ATOM    379  CG2 ILE    24      -1.085  16.875 -12.300  1.00 14.33           C 
ATOM    380  CD1 ILE    24      -1.059  17.359  -9.269  1.00 60.21           C 
ATOM    381  H   ILE    24       2.094  14.713 -10.552  1.00 37.79           H 
ATOM    382  HA  ILE    24      -0.856  14.902 -10.330  1.00 73.21           H 
ATOM    383  HB  ILE    24       1.007  16.639 -11.974  1.00  0.51           H 
ATOM    384 1HG1 ILE    24       0.244  18.470 -10.511  1.00 37.79           H 
ATOM    385 2HG1 ILE    24       1.026  17.201  -9.576  1.00 37.79           H 
ATOM    386 1HG2 ILE    24      -2.011  16.718 -11.766  1.00 37.79           H 
ATOM    387 2HG2 ILE    24      -1.074  16.253 -13.185  1.00 37.79           H 
ATOM    388 3HG2 ILE    24      -1.011  17.913 -12.596  1.00 37.79           H 
ATOM    389 1HD1 ILE    24      -1.945  17.614  -9.832  1.00 37.79           H 
ATOM    390 2HD1 ILE    24      -0.945  18.049  -8.446  1.00 37.79           H 
ATOM    391 3HD1 ILE    24      -1.153  16.354  -8.884  1.00 37.79           H 
ATOM    392  N   GLU    25      -1.372  13.839 -12.558  1.00  1.11           N 
ATOM    393  CA  GLU    25      -1.676  13.130 -13.803  1.00 31.25           C 
ATOM    394  C   GLU    25      -2.875  13.783 -14.504  1.00 53.51           C 
ATOM    395  O   GLU    25      -3.972  13.855 -13.948  1.00 71.12           O 
ATOM    396  CB  GLU    25      -1.945  11.647 -13.522  1.00 22.10           C 
ATOM    397  CG  GLU    25      -2.101  10.803 -14.782  1.00 23.14           C 
ATOM    398  CD  GLU    25      -2.106   9.312 -14.487  1.00  4.24           C 
ATOM    399  OE1 GLU    25      -1.010   8.711 -14.404  1.00 20.25           O 
ATOM    400  OE2 GLU    25      -3.199   8.733 -14.326  1.00 52.21           O 
ATOM    401  H   GLU    25      -2.112  14.090 -11.962  1.00 37.79           H 
ATOM    402  HA  GLU    25      -0.812  13.213 -14.452  1.00 20.33           H 
ATOM    403 1HB  GLU    25      -2.852  11.558 -12.939  1.00 37.79           H 
ATOM    404 2HB  GLU    25      -1.121  11.249 -12.947  1.00 37.79           H 
ATOM    405 1HG  GLU    25      -1.279  11.021 -15.451  1.00 37.79           H 
ATOM    406 2HG  GLU    25      -3.032  11.066 -15.265  1.00 37.79           H 
ATOM    407  N   LYS    26      -2.661  14.276 -15.721  1.00 23.25           N 
ATOM    408  CA  LYS    26      -3.683  15.071 -16.408  1.00 74.20           C 
ATOM    409  C   LYS    26      -4.649  14.198 -17.237  1.00 15.21           C 
ATOM    410  O   LYS    26      -4.302  13.712 -18.318  1.00 70.15           O 
ATOM    411  CB  LYS    26      -3.022  16.125 -17.313  1.00 14.51           C 
ATOM    412  CG  LYS    26      -3.924  17.325 -17.587  1.00 65.40           C 
ATOM    413  CD  LYS    26      -3.520  18.091 -18.845  1.00 41.11           C 
ATOM    414  CE  LYS    26      -2.123  18.686 -18.738  1.00 33.21           C 
ATOM    415  NZ  LYS    26      -1.794  19.513 -19.927  1.00 11.22           N 
ATOM    416  H   LYS    26      -1.804  14.102 -16.167  1.00 37.79           H 
ATOM    417  HA  LYS    26      -4.255  15.586 -15.647  1.00 70.32           H 
ATOM    418 1HB  LYS    26      -2.765  15.667 -18.258  1.00 37.79           H 
ATOM    419 2HB  LYS    26      -2.117  16.478 -16.837  1.00 37.79           H 
ATOM    420 1HG  LYS    26      -3.871  17.998 -16.741  1.00 37.79           H 
ATOM    421 2HG  LYS    26      -4.936  16.979 -17.697  1.00 37.79           H 
ATOM    422 1HD  LYS    26      -4.229  18.893 -19.006  1.00 37.79           H 
ATOM    423 2HD  LYS    26      -3.547  17.418 -19.690  1.00 37.79           H 
ATOM    424 1HE  LYS    26      -1.405  17.883 -18.659  1.00 37.79           H 
ATOM    425 2HE  LYS    26      -2.072  19.305 -17.855  1.00 37.79           H 
ATOM    426 1HZ  LYS    26      -1.791  18.925 -20.784  1.00 37.79           H 
ATOM    427 2HZ  LYS    26      -0.858  19.947 -19.814  1.00 37.79           H 
ATOM    428 3HZ  LYS    26      -2.503  20.267 -20.042  1.00 37.79           H 
ATOM    429  N   VAL    27      -5.868  14.020 -16.730  1.00 23.40           N 
ATOM    430  CA  VAL    27      -6.905  13.242 -17.423  1.00 62.43           C 
ATOM    431  C   VAL    27      -8.067  14.153 -17.862  1.00 72.24           C 
ATOM    432  O   VAL    27      -8.495  15.025 -17.104  1.00  4.24           O 
ATOM    433  CB  VAL    27      -7.450  12.112 -16.512  1.00 53.43           C 
ATOM    434  CG1 VAL    27      -8.499  11.269 -17.235  1.00 22.24           C 
ATOM    435  CG2 VAL    27      -6.308  11.235 -15.997  1.00 74.42           C 
ATOM    436  H   VAL    27      -6.080  14.423 -15.860  1.00 37.79           H 
ATOM    437  HA  VAL    27      -6.461  12.791 -18.303  1.00 34.45           H 
ATOM    438  HB  VAL    27      -7.926  12.574 -15.657  1.00 13.30           H 
ATOM    439 1HG1 VAL    27      -8.854  10.490 -16.575  1.00 37.79           H 
ATOM    440 2HG1 VAL    27      -8.061  10.821 -18.116  1.00 37.79           H 
ATOM    441 3HG1 VAL    27      -9.329  11.896 -17.527  1.00 37.79           H 
ATOM    442 1HG2 VAL    27      -6.707  10.448 -15.373  1.00 37.79           H 
ATOM    443 2HG2 VAL    27      -5.623  11.838 -15.419  1.00 37.79           H 
ATOM    444 3HG2 VAL    27      -5.781  10.796 -16.833  1.00 37.79           H 
ATOM    445  N   ASP    28      -8.568  13.953 -19.088  1.00 24.21           N 
ATOM    446  CA  ASP    28      -9.622  14.813 -19.661  1.00 52.20           C 
ATOM    447  C   ASP    28      -9.163  16.282 -19.765  1.00 20.24           C 
ATOM    448  O   ASP    28      -9.984  17.203 -19.788  1.00 13.40           O 
ATOM    449  CB  ASP    28     -10.914  14.724 -18.830  1.00 45.33           C 
ATOM    450  CG  ASP    28     -11.663  13.415 -19.025  1.00  1.24           C 
ATOM    451  OD1 ASP    28     -12.508  13.340 -19.942  1.00 21.33           O 
ATOM    452  OD2 ASP    28     -11.431  12.463 -18.252  1.00 75.30           O 
ATOM    453  H   ASP    28      -8.226  13.203 -19.623  1.00 37.79           H 
ATOM    454  HA  ASP    28      -9.826  14.452 -20.661  1.00 23.50           H 
ATOM    455 1HB  ASP    28     -11.570  15.538 -19.110  1.00 37.79           H 
ATOM    456 2HB  ASP    28     -10.665  14.821 -17.783  1.00 37.79           H 
ATOM    457  N   GLY    29      -7.852  16.491 -19.857  1.00  1.23           N 
ATOM    458  CA  GLY    29      -7.301  17.845 -19.871  1.00 25.13           C 
ATOM    459  C   GLY    29      -7.297  18.494 -18.487  1.00 70.02           C 
ATOM    460  O   GLY    29      -7.035  19.691 -18.348  1.00 71.05           O 
ATOM    461  H   GLY    29      -7.250  15.719 -19.927  1.00 37.79           H 
ATOM    462 1HA  GLY    29      -7.888  18.457 -20.542  1.00 37.79           H 
ATOM    463 2HA  GLY    29      -6.287  17.802 -20.237  1.00 37.79           H 
ATOM    464  N   ARG    30      -7.581  17.692 -17.463  1.00 63.23           N 
ATOM    465  CA  ARG    30      -7.655  18.170 -16.078  1.00 45.05           C 
ATOM    466  C   ARG    30      -6.577  17.506 -15.203  1.00 65.51           C 
ATOM    467  O   ARG    30      -6.403  16.287 -15.230  1.00 34.34           O 
ATOM    468  CB  ARG    30      -9.054  17.883 -15.513  1.00 64.14           C 
ATOM    469  CG  ARG    30     -10.169  18.599 -16.274  1.00  1.21           C 
ATOM    470  CD  ARG    30     -11.553  18.200 -15.775  1.00 74.11           C 
ATOM    471  NE  ARG    30     -11.891  16.822 -16.127  1.00 74.13           N 
ATOM    472  CZ  ARG    30     -12.425  15.962 -15.302  1.00 33.22           C 
ATOM    473  NH1 ARG    30     -12.674  16.292 -14.076  1.00  3.02           N 
ATOM    474  NH2 ARG    30     -12.725  14.774 -15.710  1.00 24.22           N 
ATOM    475  H   ARG    30      -7.748  16.743 -17.642  1.00 37.79           H 
ATOM    476  HA  ARG    30      -7.491  19.240 -16.082  1.00 64.11           H 
ATOM    477 1HB  ARG    30      -9.087  18.205 -14.481  1.00 37.79           H 
ATOM    478 2HB  ARG    30      -9.239  16.817 -15.554  1.00 37.79           H 
ATOM    479 1HG  ARG    30     -10.091  18.350 -17.324  1.00 37.79           H 
ATOM    480 2HG  ARG    30     -10.050  19.665 -16.148  1.00 37.79           H 
ATOM    481 1HD  ARG    30     -12.286  18.862 -16.215  1.00 37.79           H 
ATOM    482 2HD  ARG    30     -11.578  18.305 -14.699  1.00 37.79           H 
ATOM    483  HE  ARG    30     -11.718  16.537 -17.045  1.00 44.31           H 
ATOM    484 1HH1 ARG    30     -12.458  17.210 -13.751  1.00 37.79           H 
ATOM    485 2HH1 ARG    30     -13.075  15.621 -13.456  1.00 37.79           H 
ATOM    486 1HH2 ARG    30     -12.544  14.509 -16.651  1.00 37.79           H 
ATOM    487 2HH2 ARG    30     -13.137  14.120 -15.074  1.00 37.79           H 
ATOM    488  N   ASN    31      -5.855  18.313 -14.432  1.00  1.22           N 
ATOM    489  CA  ASN    31      -4.756  17.813 -13.598  1.00 24.12           C 
ATOM    490  C   ASN    31      -5.276  17.154 -12.309  1.00 43.30           C 
ATOM    491  O   ASN    31      -5.799  17.829 -11.419  1.00 11.01           O 
ATOM    492  CB  ASN    31      -3.803  18.961 -13.254  1.00 25.03           C 
ATOM    493  CG  ASN    31      -3.169  19.569 -14.491  1.00  0.33           C 
ATOM    494  OD1 ASN    31      -3.727  20.468 -15.110  1.00 63.32           O 
ATOM    495  ND2 ASN    31      -2.002  19.083 -14.868  1.00 75.00           N 
ATOM    496  H   ASN    31      -6.069  19.270 -14.412  1.00 37.79           H 
ATOM    497  HA  ASN    31      -4.214  17.074 -14.173  1.00 14.35           H 
ATOM    498 1HB  ASN    31      -3.018  18.594 -12.608  1.00 37.79           H 
ATOM    499 2HB  ASN    31      -4.354  19.735 -12.738  1.00 37.79           H 
ATOM    500 1HD2 ASN    31      -1.604  18.362 -14.341  1.00 37.79           H 
ATOM    501 2HD2 ASN    31      -1.575  19.479 -15.657  1.00 37.79           H 
ATOM    502  N   LEU    32      -5.141  15.831 -12.225  1.00 74.42           N 
ATOM    503  CA  LEU    32      -5.543  15.078 -11.030  1.00 50.01           C 
ATOM    504  C   LEU    32      -4.350  14.865 -10.085  1.00 63.41           C 
ATOM    505  O   LEU    32      -3.212  14.721 -10.530  1.00 24.31           O 
ATOM    506  CB  LEU    32      -6.141  13.722 -11.433  1.00 53.15           C 
ATOM    507  CG  LEU    32      -7.352  13.794 -12.381  1.00 22.11           C 
ATOM    508  CD1 LEU    32      -7.854  12.395 -12.724  1.00 35.54           C 
ATOM    509  CD2 LEU    32      -8.474  14.633 -11.769  1.00 34.41           C 
ATOM    510  H   LEU    32      -4.767  15.343 -12.990  1.00 37.79           H 
ATOM    511  HA  LEU    32      -6.299  15.653 -10.509  1.00 74.20           H 
ATOM    512 1HB  LEU    32      -6.447  13.205 -10.533  1.00 37.79           H 
ATOM    513 2HB  LEU    32      -5.366  13.139 -11.914  1.00 37.79           H 
ATOM    514  HG  LEU    32      -7.046  14.269 -13.302  1.00 73.44           H 
ATOM    515 1HD1 LEU    32      -8.698  12.470 -13.396  1.00 37.79           H 
ATOM    516 2HD1 LEU    32      -8.159  11.887 -11.820  1.00 37.79           H 
ATOM    517 3HD1 LEU    32      -7.063  11.835 -13.202  1.00 37.79           H 
ATOM    518 1HD2 LEU    32      -8.116  15.636 -11.584  1.00 37.79           H 
ATOM    519 2HD2 LEU    32      -8.793  14.189 -10.838  1.00 37.79           H 
ATOM    520 3HD2 LEU    32      -9.311  14.672 -12.454  1.00 37.79           H 
ATOM    521  N   ARG    33      -4.617  14.855  -8.783  1.00 23.22           N 
ATOM    522  CA  ARG    33      -3.567  14.659  -7.775  1.00 62.34           C 
ATOM    523  C   ARG    33      -3.680  13.266  -7.131  1.00 41.45           C 
ATOM    524  O   ARG    33      -4.560  13.023  -6.302  1.00 55.31           O 
ATOM    525  CB  ARG    33      -3.672  15.757  -6.702  1.00  0.52           C 
ATOM    526  CG  ARG    33      -2.536  15.761  -5.681  1.00 63.32           C 
ATOM    527  CD  ARG    33      -2.727  16.864  -4.642  1.00 45.22           C 
ATOM    528  NE  ARG    33      -1.581  16.987  -3.743  1.00  0.41           N 
ATOM    529  CZ  ARG    33      -1.532  17.804  -2.724  1.00 64.12           C 
ATOM    530  NH1 ARG    33      -2.559  18.521  -2.392  1.00 31.31           N 
ATOM    531  NH2 ARG    33      -0.456  17.885  -2.021  1.00 33.22           N 
ATOM    532  H   ARG    33      -5.544  14.990  -8.485  1.00 37.79           H 
ATOM    533  HA  ARG    33      -2.607  14.740  -8.269  1.00 24.55           H 
ATOM    534 1HB  ARG    33      -4.604  15.629  -6.169  1.00 37.79           H 
ATOM    535 2HB  ARG    33      -3.683  16.719  -7.195  1.00 37.79           H 
ATOM    536 1HG  ARG    33      -1.599  15.923  -6.198  1.00 37.79           H 
ATOM    537 2HG  ARG    33      -2.509  14.805  -5.177  1.00 37.79           H 
ATOM    538 1HD  ARG    33      -3.609  16.641  -4.058  1.00 37.79           H 
ATOM    539 2HD  ARG    33      -2.869  17.804  -5.156  1.00 37.79           H 
ATOM    540  HE  ARG    33      -0.795  16.437  -3.930  1.00 73.45           H 
ATOM    541 1HH1 ARG    33      -3.405  18.456  -2.916  1.00 37.79           H 
ATOM    542 2HH1 ARG    33      -2.501  19.134  -1.608  1.00 37.79           H 
ATOM    543 1HH2 ARG    33       0.337  17.323  -2.256  1.00 37.79           H 
ATOM    544 2HH2 ARG    33      -0.410  18.511  -1.247  1.00 37.79           H 
ATOM    545  N   ASN    34      -2.787  12.354  -7.517  1.00 10.04           N 
ATOM    546  CA  ASN    34      -2.822  10.967  -7.029  1.00 60.55           C 
ATOM    547  C   ASN    34      -1.435  10.491  -6.569  1.00  4.14           C 
ATOM    548  O   ASN    34      -0.415  11.062  -6.944  1.00  5.43           O 
ATOM    549  CB  ASN    34      -3.363  10.038  -8.125  1.00 44.12           C 
ATOM    550  CG  ASN    34      -2.622  10.199  -9.441  1.00 55.23           C 
ATOM    551  OD1 ASN    34      -3.003  10.999 -10.285  1.00 41.25           O 
ATOM    552  ND2 ASN    34      -1.556   9.444  -9.632  1.00 15.13           N 
ATOM    553  H   ASN    34      -2.080  12.618  -8.145  1.00 37.79           H 
ATOM    554  HA  ASN    34      -3.493  10.931  -6.181  1.00 11.21           H 
ATOM    555 1HB  ASN    34      -4.408  10.260  -8.292  1.00 37.79           H 
ATOM    556 2HB  ASN    34      -3.269   9.011  -7.801  1.00 37.79           H 
ATOM    557 1HD2 ASN    34      -1.291   8.823  -8.926  1.00 37.79           H 
ATOM    558 2HD2 ASN    34      -1.071   9.544 -10.480  1.00 37.79           H 
ATOM    559  N   TYR    35      -1.408   9.434  -5.759  1.00 15.25           N 
ATOM    560  CA  TYR    35      -0.150   8.884  -5.231  1.00  3.43           C 
ATOM    561  C   TYR    35       0.005   7.400  -5.604  1.00 30.03           C 
ATOM    562  O   TYR    35      -0.857   6.585  -5.281  1.00 62.53           O 
ATOM    563  CB  TYR    35      -0.117   9.028  -3.701  1.00 63.03           C 
ATOM    564  CG  TYR    35      -0.377  10.440  -3.205  1.00 12.25           C 
ATOM    565  CD1 TYR    35       0.674  11.289  -2.878  1.00 33.22           C 
ATOM    566  CD2 TYR    35      -1.677  10.921  -3.066  1.00 63.23           C 
ATOM    567  CE1 TYR    35       0.436  12.573  -2.427  1.00 75.25           C 
ATOM    568  CE2 TYR    35      -1.920  12.204  -2.617  1.00 73.00           C 
ATOM    569  CZ  TYR    35      -0.861  13.025  -2.300  1.00 71.53           C 
ATOM    570  OH  TYR    35      -1.100  14.303  -1.852  1.00 55.24           O 
ATOM    571  H   TYR    35      -2.256   9.012  -5.500  1.00 37.79           H 
ATOM    572  HA  TYR    35       0.671   9.444  -5.656  1.00 61.12           H 
ATOM    573 1HB  TYR    35       0.857   8.722  -3.342  1.00 37.79           H 
ATOM    574 2HB  TYR    35      -0.869   8.383  -3.270  1.00 37.79           H 
ATOM    575  HD1 TYR    35       1.690  10.934  -2.979  1.00 35.33           H 
ATOM    576  HD2 TYR    35      -2.506  10.275  -3.315  1.00 44.14           H 
ATOM    577  HE1 TYR    35       1.266  13.219  -2.179  1.00 61.01           H 
ATOM    578  HE2 TYR    35      -2.935  12.559  -2.517  1.00 44.11           H 
ATOM    579  HH  TYR    35      -0.428  14.897  -2.208  1.00 72.13           H 
ATOM    580  N   THR    36       1.110   7.054  -6.270  1.00 22.23           N 
ATOM    581  CA  THR    36       1.389   5.657  -6.657  1.00 51.14           C 
ATOM    582  C   THR    36       2.623   5.121  -5.921  1.00 72.41           C 
ATOM    583  O   THR    36       3.748   5.569  -6.163  1.00 25.03           O 
ATOM    584  CB  THR    36       1.619   5.525  -8.185  1.00 44.31           C 
ATOM    585  OG1 THR    36       0.479   6.024  -8.906  1.00  3.35           O 
ATOM    586  CG2 THR    36       1.874   4.072  -8.588  1.00 72.20           C 
ATOM    587  H   THR    36       1.756   7.751  -6.511  1.00 37.79           H 
ATOM    588  HA  THR    36       0.531   5.053  -6.390  1.00 55.14           H 
ATOM    589  HB  THR    36       2.486   6.113  -8.456  1.00 15.33           H 
ATOM    590  HG1 THR    36      -0.252   5.399  -8.820  1.00 22.04           H 
ATOM    591 1HG2 THR    36       1.035   3.461  -8.289  1.00 37.79           H 
ATOM    592 2HG2 THR    36       2.771   3.714  -8.103  1.00 37.79           H 
ATOM    593 3HG2 THR    36       1.998   4.011  -9.660  1.00 37.79           H 
ATOM    594  N   LEU    37       2.416   4.162  -5.026  1.00 70.25           N 
ATOM    595  CA  LEU    37       3.502   3.641  -4.187  1.00 40.24           C 
ATOM    596  C   LEU    37       3.529   2.100  -4.162  1.00 10.10           C 
ATOM    597  O   LEU    37       2.503   1.444  -4.367  1.00 75.41           O 
ATOM    598  CB  LEU    37       3.359   4.184  -2.758  1.00 13.44           C 
ATOM    599  CG  LEU    37       3.492   5.710  -2.607  1.00 33.22           C 
ATOM    600  CD1 LEU    37       3.225   6.140  -1.168  1.00 74.33           C 
ATOM    601  CD2 LEU    37       4.873   6.172  -3.056  1.00 22.54           C 
ATOM    602  H   LEU    37       1.511   3.790  -4.924  1.00 37.79           H 
ATOM    603  HA  LEU    37       4.436   3.994  -4.600  1.00 20.12           H 
ATOM    604 1HB  LEU    37       4.116   3.718  -2.143  1.00 37.79           H 
ATOM    605 2HB  LEU    37       2.388   3.891  -2.384  1.00 37.79           H 
ATOM    606  HG  LEU    37       2.758   6.193  -3.238  1.00  3.32           H 
ATOM    607 1HD1 LEU    37       2.228   5.839  -0.880  1.00 37.79           H 
ATOM    608 2HD1 LEU    37       3.310   7.215  -1.089  1.00 37.79           H 
ATOM    609 3HD1 LEU    37       3.945   5.673  -0.510  1.00 37.79           H 
ATOM    610 1HD2 LEU    37       4.951   7.243  -2.936  1.00 37.79           H 
ATOM    611 2HD2 LEU    37       5.016   5.918  -4.096  1.00 37.79           H 
ATOM    612 3HD2 LEU    37       5.630   5.686  -2.459  1.00 37.79           H 
ATOM    613  N   PRO    38       4.717   1.502  -3.917  1.00 45.52           N 
ATOM    614  CA  PRO    38       4.864   0.044  -3.793  1.00 72.33           C 
ATOM    615  C   PRO    38       4.266  -0.500  -2.484  1.00 23.45           C 
ATOM    616  O   PRO    38       4.337   0.143  -1.434  1.00 11.12           O 
ATOM    617  CB  PRO    38       6.393  -0.179  -3.822  1.00 10.41           C 
ATOM    618  CG  PRO    38       6.988   1.140  -4.208  1.00 72.03           C 
ATOM    619  CD  PRO    38       6.009   2.186  -3.755  1.00  0.25           C 
ATOM    620  HA  PRO    38       4.407  -0.467  -4.630  1.00 23.21           H 
ATOM    621 1HB  PRO    38       6.631  -0.943  -4.548  1.00 37.79           H 
ATOM    622 2HB  PRO    38       6.736  -0.495  -2.845  1.00 37.79           H 
ATOM    623 1HG  PRO    38       7.118   1.187  -5.280  1.00 37.79           H 
ATOM    624 2HG  PRO    38       7.940   1.276  -3.711  1.00 37.79           H 
ATOM    625 1HD  PRO    38       6.066   3.062  -4.386  1.00 37.79           H 
ATOM    626 2HD  PRO    38       6.184   2.450  -2.721  1.00 37.79           H 
ATOM    627  N   ALA    39       3.684  -1.691  -2.550  1.00 72.41           N 
ATOM    628  CA  ALA    39       3.067  -2.316  -1.380  1.00 65.43           C 
ATOM    629  C   ALA    39       3.434  -3.804  -1.272  1.00 60.21           C 
ATOM    630  O   ALA    39       4.017  -4.379  -2.184  1.00  2.30           O 
ATOM    631  CB  ALA    39       1.552  -2.146  -1.436  1.00 22.12           C 
ATOM    632  H   ALA    39       3.669  -2.165  -3.406  1.00 37.79           H 
ATOM    633  HA  ALA    39       3.429  -1.805  -0.498  1.00 43.35           H 
ATOM    634 1HB  ALA    39       1.157  -2.695  -2.280  1.00 37.79           H 
ATOM    635 2HB  ALA    39       1.310  -1.100  -1.545  1.00 37.79           H 
ATOM    636 3HB  ALA    39       1.111  -2.523  -0.523  1.00 37.79           H 
ATOM    637  N   TYR    40       3.103  -4.410  -0.139  1.00  4.15           N 
ATOM    638  CA  TYR    40       3.288  -5.850   0.074  1.00 14.44           C 
ATOM    639  C   TYR    40       2.104  -6.416   0.866  1.00 55.05           C 
ATOM    640  O   TYR    40       1.624  -5.782   1.804  1.00 30.21           O 
ATOM    641  CB  TYR    40       4.591  -6.133   0.843  1.00 74.11           C 
ATOM    642  CG  TYR    40       5.861  -5.700   0.127  1.00 71.00           C 
ATOM    643  CD1 TYR    40       6.502  -6.545  -0.771  1.00  5.20           C 
ATOM    644  CD2 TYR    40       6.424  -4.449   0.360  1.00 44.35           C 
ATOM    645  CE1 TYR    40       7.665  -6.158  -1.411  1.00 70.40           C 
ATOM    646  CE2 TYR    40       7.583  -4.055  -0.279  1.00  3.13           C 
ATOM    647  CZ  TYR    40       8.200  -4.913  -1.163  1.00 63.23           C 
ATOM    648  OH  TYR    40       9.362  -4.525  -1.795  1.00  0.11           O 
ATOM    649  H   TYR    40       2.729  -3.873   0.589  1.00 37.79           H 
ATOM    650  HA  TYR    40       3.330  -6.333  -0.893  1.00 12.13           H 
ATOM    651 1HB  TYR    40       4.663  -7.196   1.028  1.00 37.79           H 
ATOM    652 2HB  TYR    40       4.558  -5.616   1.792  1.00 37.79           H 
ATOM    653  HD1 TYR    40       6.081  -7.521  -0.966  1.00 34.11           H 
ATOM    654  HD2 TYR    40       5.939  -3.777   1.052  1.00  3.43           H 
ATOM    655  HE1 TYR    40       8.148  -6.831  -2.106  1.00 64.21           H 
ATOM    656  HE2 TYR    40       8.002  -3.079  -0.082  1.00 63.34           H 
ATOM    657  HH  TYR    40       9.992  -4.201  -1.134  1.00 52.13           H 
ATOM    658  N   ASP    41       1.621  -7.596   0.488  1.00 62.41           N 
ATOM    659  CA  ASP    41       0.554  -8.257   1.249  1.00 12.34           C 
ATOM    660  C   ASP    41       1.129  -8.976   2.482  1.00 40.34           C 
ATOM    661  O   ASP    41       2.339  -8.955   2.711  1.00 41.12           O 
ATOM    662  CB  ASP    41      -0.205  -9.243   0.355  1.00  0.33           C 
ATOM    663  CG  ASP    41       0.729 -10.207  -0.345  1.00 44.31           C 
ATOM    664  OD1 ASP    41       1.129  -9.917  -1.488  1.00 64.42           O 
ATOM    665  OD2 ASP    41       1.079 -11.246   0.251  1.00 21.52           O 
ATOM    666  H   ASP    41       1.986  -8.036  -0.312  1.00 37.79           H 
ATOM    667  HA  ASP    41      -0.133  -7.490   1.588  1.00 23.42           H 
ATOM    668 1HB  ASP    41      -0.760  -8.693  -0.393  1.00 37.79           H 
ATOM    669 2HB  ASP    41      -0.898  -9.812   0.961  1.00 37.79           H 
ATOM    670  N   GLU    42       0.264  -9.619   3.265  1.00 33.43           N 
ATOM    671  CA  GLU    42       0.686 -10.302   4.497  1.00 30.03           C 
ATOM    672  C   GLU    42       1.770 -11.373   4.238  1.00 44.33           C 
ATOM    673  O   GLU    42       2.614 -11.632   5.101  1.00  1.33           O 
ATOM    674  CB  GLU    42      -0.529 -10.929   5.199  1.00 31.13           C 
ATOM    675  CG  GLU    42      -0.197 -11.581   6.539  1.00 41.33           C 
ATOM    676  CD  GLU    42      -1.431 -12.061   7.288  1.00 40.40           C 
ATOM    677  OE1 GLU    42      -1.845 -11.389   8.255  1.00 71.24           O 
ATOM    678  OE2 GLU    42      -1.990 -13.113   6.913  1.00  3.14           O 
ATOM    679  H   GLU    42      -0.684  -9.624   3.020  1.00 37.79           H 
ATOM    680  HA  GLU    42       1.108  -9.551   5.152  1.00 54.42           H 
ATOM    681 1HB  GLU    42      -0.958 -11.681   4.552  1.00 37.79           H 
ATOM    682 2HB  GLU    42      -1.265 -10.156   5.373  1.00 37.79           H 
ATOM    683 1HG  GLU    42       0.324 -10.859   7.154  1.00 37.79           H 
ATOM    684 2HG  GLU    42       0.450 -12.429   6.362  1.00 37.79           H 
ATOM    685  N   ASP    43       1.760 -11.981   3.051  1.00 10.21           N 
ATOM    686  CA  ASP    43       2.767 -12.993   2.700  1.00 33.34           C 
ATOM    687  C   ASP    43       4.076 -12.326   2.227  1.00 40.05           C 
ATOM    688  O   ASP    43       5.127 -12.968   2.153  1.00 61.13           O 
ATOM    689  CB  ASP    43       2.217 -13.940   1.623  1.00 11.54           C 
ATOM    690  CG  ASP    43       3.161 -15.093   1.316  1.00 51.55           C 
ATOM    691  OD1 ASP    43       3.563 -15.803   2.261  1.00 45.42           O 
ATOM    692  OD2 ASP    43       3.492 -15.308   0.129  1.00 43.34           O 
ATOM    693  H   ASP    43       1.073 -11.743   2.394  1.00 37.79           H 
ATOM    694  HA  ASP    43       2.979 -13.567   3.593  1.00 20.33           H 
ATOM    695 1HB  ASP    43       2.049 -13.380   0.713  1.00 37.79           H 
ATOM    696 2HB  ASP    43       1.277 -14.352   1.962  1.00 37.79           H 
ATOM    697  N   GLY    44       4.004 -11.035   1.912  1.00 12.42           N 
ATOM    698  CA  GLY    44       5.191 -10.275   1.530  1.00 42.21           C 
ATOM    699  C   GLY    44       5.411 -10.188   0.022  1.00 44.44           C 
ATOM    700  O   GLY    44       6.471  -9.749  -0.430  1.00 65.25           O 
ATOM    701  H   GLY    44       3.132 -10.587   1.946  1.00 37.79           H 
ATOM    702 1HA  GLY    44       6.059 -10.735   1.980  1.00 37.79           H 
ATOM    703 2HA  GLY    44       5.095  -9.272   1.919  1.00 37.79           H 
ATOM    704  N   VAL    45       4.420 -10.600  -0.765  1.00 43.22           N 
ATOM    705  CA  VAL    45       4.533 -10.536  -2.227  1.00  2.11           C 
ATOM    706  C   VAL    45       4.348  -9.093  -2.724  1.00  0.42           C 
ATOM    707  O   VAL    45       3.403  -8.407  -2.331  1.00 64.13           O 
ATOM    708  CB  VAL    45       3.504 -11.462  -2.920  1.00 34.25           C 
ATOM    709  CG1 VAL    45       3.731 -11.503  -4.430  1.00 53.21           C 
ATOM    710  CG2 VAL    45       3.555 -12.864  -2.319  1.00 25.44           C 
ATOM    711  H   VAL    45       3.598 -10.949  -0.359  1.00 37.79           H 
ATOM    712  HA  VAL    45       5.528 -10.874  -2.496  1.00 53.41           H 
ATOM    713  HB  VAL    45       2.516 -11.059  -2.743  1.00 55.33           H 
ATOM    714 1HG1 VAL    45       3.597 -10.513  -4.841  1.00 37.79           H 
ATOM    715 2HG1 VAL    45       3.019 -12.179  -4.884  1.00 37.79           H 
ATOM    716 3HG1 VAL    45       4.734 -11.846  -4.637  1.00 37.79           H 
ATOM    717 1HG2 VAL    45       4.545 -13.276  -2.443  1.00 37.79           H 
ATOM    718 2HG2 VAL    45       2.836 -13.498  -2.820  1.00 37.79           H 
ATOM    719 3HG2 VAL    45       3.314 -12.813  -1.266  1.00 37.79           H 
ATOM    720  N   LYS    46       5.247  -8.640  -3.596  1.00 54.35           N 
ATOM    721  CA  LYS    46       5.262  -7.241  -4.027  1.00 10.30           C 
ATOM    722  C   LYS    46       3.981  -6.838  -4.779  1.00  5.11           C 
ATOM    723  O   LYS    46       3.448  -7.593  -5.594  1.00 22.04           O 
ATOM    724  CB  LYS    46       6.490  -6.958  -4.898  1.00 70.52           C 
ATOM    725  CG  LYS    46       6.629  -5.487  -5.273  1.00 32.21           C 
ATOM    726  CD  LYS    46       7.899  -5.207  -6.068  1.00 52.33           C 
ATOM    727  CE  LYS    46       8.023  -3.728  -6.407  1.00 24.42           C 
ATOM    728  NZ  LYS    46       9.285  -3.420  -7.127  1.00 32.13           N 
ATOM    729  H   LYS    46       5.913  -9.259  -3.959  1.00 37.79           H 
ATOM    730  HA  LYS    46       5.335  -6.635  -3.134  1.00 55.44           H 
ATOM    731 1HB  LYS    46       6.412  -7.534  -5.808  1.00 37.79           H 
ATOM    732 2HB  LYS    46       7.380  -7.264  -4.363  1.00 37.79           H 
ATOM    733 1HG  LYS    46       6.643  -4.896  -4.367  1.00 37.79           H 
ATOM    734 2HG  LYS    46       5.775  -5.199  -5.873  1.00 37.79           H 
ATOM    735 1HD  LYS    46       7.870  -5.774  -6.988  1.00 37.79           H 
ATOM    736 2HD  LYS    46       8.758  -5.508  -5.484  1.00 37.79           H 
ATOM    737 1HE  LYS    46       7.992  -3.155  -5.491  1.00 37.79           H 
ATOM    738 2HE  LYS    46       7.189  -3.444  -7.033  1.00 37.79           H 
ATOM    739 1HZ  LYS    46      10.105  -3.689  -6.547  1.00 37.79           H 
ATOM    740 2HZ  LYS    46       9.341  -2.403  -7.337  1.00 37.79           H 
ATOM    741 3HZ  LYS    46       9.321  -3.945  -8.021  1.00 37.79           H 
ATOM    742  N   LYS    47       3.507  -5.633  -4.485  1.00 65.11           N 
ATOM    743  CA  LYS    47       2.312  -5.055  -5.106  1.00 12.42           C 
ATOM    744  C   LYS    47       2.574  -3.587  -5.473  1.00 60.21           C 
ATOM    745  O   LYS    47       3.574  -3.002  -5.049  1.00 74.33           O 
ATOM    746  CB  LYS    47       1.117  -5.133  -4.136  1.00  2.20           C 
ATOM    747  CG  LYS    47       0.718  -6.551  -3.730  1.00 54.23           C 
ATOM    748  CD  LYS    47       0.148  -7.342  -4.903  1.00 44.32           C 
ATOM    749  CE  LYS    47      -0.235  -8.762  -4.495  1.00 52.11           C 
ATOM    750  NZ  LYS    47       0.940  -9.549  -4.035  1.00 24.05           N 
ATOM    751  H   LYS    47       3.986  -5.098  -3.821  1.00 37.79           H 
ATOM    752  HA  LYS    47       2.084  -5.609  -6.005  1.00 25.00           H 
ATOM    753 1HB  LYS    47       0.261  -4.660  -4.600  1.00 37.79           H 
ATOM    754 2HB  LYS    47       1.368  -4.588  -3.236  1.00 37.79           H 
ATOM    755 1HG  LYS    47      -0.029  -6.494  -2.949  1.00 37.79           H 
ATOM    756 2HG  LYS    47       1.592  -7.066  -3.354  1.00 37.79           H 
ATOM    757 1HD  LYS    47       0.891  -7.390  -5.688  1.00 37.79           H 
ATOM    758 2HD  LYS    47      -0.733  -6.835  -5.273  1.00 37.79           H 
ATOM    759 1HE  LYS    47      -0.679  -9.261  -5.347  1.00 37.79           H 
ATOM    760 2HE  LYS    47      -0.958  -8.712  -3.694  1.00 37.79           H 
ATOM    761 1HZ  LYS    47       1.355  -9.114  -3.181  1.00 37.79           H 
ATOM    762 2HZ  LYS    47       1.663  -9.584  -4.779  1.00 37.79           H 
ATOM    763 3HZ  LYS    47       0.651 -10.520  -3.803  1.00 37.79           H 
ATOM    764  N   GLN    48       1.687  -2.994  -6.262  1.00 41.13           N 
ATOM    765  CA  GLN    48       1.772  -1.563  -6.575  1.00 14.12           C 
ATOM    766  C   GLN    48       0.375  -0.925  -6.557  1.00 12.32           C 
ATOM    767  O   GLN    48      -0.478  -1.255  -7.380  1.00  3.41           O 
ATOM    768  CB  GLN    48       2.450  -1.343  -7.935  1.00 72.20           C 
ATOM    769  CG  GLN    48       2.762   0.122  -8.229  1.00 42.23           C 
ATOM    770  CD  GLN    48       3.547   0.309  -9.513  1.00 13.05           C 
ATOM    771  OE1 GLN    48       4.777   0.300  -9.512  1.00 73.54           O 
ATOM    772  NE2 GLN    48       2.849   0.479 -10.616  1.00 31.21           N 
ATOM    773  H   GLN    48       0.958  -3.527  -6.648  1.00 37.79           H 
ATOM    774  HA  GLN    48       2.374  -1.094  -5.806  1.00 52.12           H 
ATOM    775 1HB  GLN    48       1.800  -1.716  -8.714  1.00 37.79           H 
ATOM    776 2HB  GLN    48       3.377  -1.900  -7.957  1.00 37.79           H 
ATOM    777 1HG  GLN    48       3.339   0.527  -7.410  1.00 37.79           H 
ATOM    778 2HG  GLN    48       1.831   0.666  -8.312  1.00 37.79           H 
ATOM    779 1HE2 GLN    48       1.875   0.470 -10.553  1.00 37.79           H 
ATOM    780 2HE2 GLN    48       3.339   0.619 -11.452  1.00 37.79           H 
ATOM    781  N   ILE    49       0.146  -0.011  -5.615  1.00 63.01           N 
ATOM    782  CA  ILE    49      -1.192   0.556  -5.398  1.00 42.34           C 
ATOM    783  C   ILE    49      -1.189   2.093  -5.480  1.00 34.32           C 
ATOM    784  O   ILE    49      -0.243   2.753  -5.045  1.00 62.45           O 
ATOM    785  CB  ILE    49      -1.758   0.108  -4.020  1.00 22.44           C 
ATOM    786  CG1 ILE    49      -1.835  -1.429  -3.946  1.00 34.13           C 
ATOM    787  CG2 ILE    49      -3.131   0.734  -3.753  1.00 42.50           C 
ATOM    788  CD1 ILE    49      -2.295  -1.962  -2.604  1.00 41.43           C 
ATOM    789  H   ILE    49       0.894   0.298  -5.057  1.00 37.79           H 
ATOM    790  HA  ILE    49      -1.847   0.171  -6.171  1.00 72.51           H 
ATOM    791  HB  ILE    49      -1.081   0.458  -3.254  1.00 74.33           H 
ATOM    792 1HG1 ILE    49      -0.855  -1.840  -4.145  1.00 37.79           H 
ATOM    793 2HG1 ILE    49      -2.526  -1.786  -4.694  1.00 37.79           H 
ATOM    794 1HG2 ILE    49      -3.499   0.399  -2.795  1.00 37.79           H 
ATOM    795 2HG2 ILE    49      -3.823   0.438  -4.528  1.00 37.79           H 
ATOM    796 3HG2 ILE    49      -3.042   1.812  -3.745  1.00 37.79           H 
ATOM    797 1HD1 ILE    49      -1.606  -1.646  -1.834  1.00 37.79           H 
ATOM    798 2HD1 ILE    49      -2.324  -3.041  -2.638  1.00 37.79           H 
ATOM    799 3HD1 ILE    49      -3.282  -1.582  -2.382  1.00 37.79           H 
ATOM    800  N   THR    50      -2.260   2.650  -6.049  1.00 12.32           N 
ATOM    801  CA  THR    50      -2.417   4.108  -6.182  1.00 23.40           C 
ATOM    802  C   THR    50      -3.593   4.624  -5.336  1.00 43.22           C 
ATOM    803  O   THR    50      -4.733   4.196  -5.519  1.00  1.20           O 
ATOM    804  CB  THR    50      -2.647   4.521  -7.662  1.00 13.23           C 
ATOM    805  OG1 THR    50      -1.533   4.108  -8.468  1.00 53.32           O 
ATOM    806  CG2 THR    50      -2.837   6.033  -7.801  1.00 70.42           C 
ATOM    807  H   THR    50      -2.967   2.066  -6.393  1.00 37.79           H 
ATOM    808  HA  THR    50      -1.505   4.578  -5.837  1.00 33.34           H 
ATOM    809  HB  THR    50      -3.540   4.027  -8.023  1.00 52.11           H 
ATOM    810  HG1 THR    50      -1.832   3.953  -9.375  1.00 21.21           H 
ATOM    811 1HG2 THR    50      -2.995   6.283  -8.842  1.00 37.79           H 
ATOM    812 2HG2 THR    50      -1.957   6.544  -7.440  1.00 37.79           H 
ATOM    813 3HG2 THR    50      -3.695   6.342  -7.222  1.00 37.79           H 
ATOM    814  N   PHE    51      -3.313   5.548  -4.417  1.00 61.31           N 
ATOM    815  CA  PHE    51      -4.349   6.121  -3.544  1.00 61.02           C 
ATOM    816  C   PHE    51      -4.439   7.651  -3.699  1.00  3.32           C 
ATOM    817  O   PHE    51      -3.613   8.272  -4.370  1.00 14.14           O 
ATOM    818  CB  PHE    51      -4.083   5.752  -2.072  1.00  2.33           C 
ATOM    819  CG  PHE    51      -2.799   6.319  -1.506  1.00 44.42           C 
ATOM    820  CD1 PHE    51      -1.578   5.704  -1.753  1.00 41.41           C 
ATOM    821  CD2 PHE    51      -2.818   7.465  -0.719  1.00 23.55           C 
ATOM    822  CE1 PHE    51      -0.407   6.223  -1.232  1.00 12.42           C 
ATOM    823  CE2 PHE    51      -1.649   7.986  -0.197  1.00 30.20           C 
ATOM    824  CZ  PHE    51      -0.444   7.364  -0.452  1.00 12.21           C 
ATOM    825  H   PHE    51      -2.387   5.859  -4.324  1.00 37.79           H 
ATOM    826  HA  PHE    51      -5.299   5.697  -3.839  1.00 75.34           H 
ATOM    827 1HB  PHE    51      -4.039   4.675  -1.984  1.00 37.79           H 
ATOM    828 2HB  PHE    51      -4.901   6.117  -1.466  1.00 37.79           H 
ATOM    829  HD1 PHE    51      -1.547   4.812  -2.363  1.00 53.43           H 
ATOM    830  HD2 PHE    51      -3.761   7.954  -0.517  1.00 71.12           H 
ATOM    831  HE1 PHE    51       0.535   5.734  -1.430  1.00 24.20           H 
ATOM    832  HE2 PHE    51      -1.679   8.879   0.411  1.00 10.11           H 
ATOM    833  HZ  PHE    51       0.471   7.770  -0.044  1.00 51.34           H 
ATOM    834  N   ARG    52      -5.451   8.250  -3.073  1.00 14.43           N 
ATOM    835  CA  ARG    52      -5.648   9.703  -3.126  1.00 61.04           C 
ATOM    836  C   ARG    52      -6.253  10.226  -1.813  1.00 60.55           C 
ATOM    837  O   ARG    52      -6.974   9.505  -1.120  1.00 50.23           O 
ATOM    838  CB  ARG    52      -6.553  10.078  -4.314  1.00 11.20           C 
ATOM    839  CG  ARG    52      -6.758  11.583  -4.487  1.00 12.44           C 
ATOM    840  CD  ARG    52      -7.656  11.902  -5.677  1.00 33.42           C 
ATOM    841  NE  ARG    52      -8.997  11.343  -5.518  1.00 12.14           N 
ATOM    842  CZ  ARG    52      -9.762  10.979  -6.509  1.00 71.40           C 
ATOM    843  NH1 ARG    52      -9.366  11.120  -7.735  1.00  2.21           N 
ATOM    844  NH2 ARG    52     -10.926  10.479  -6.271  1.00 34.31           N 
ATOM    845  H   ARG    52      -6.080   7.704  -2.560  1.00 37.79           H 
ATOM    846  HA  ARG    52      -4.680  10.165  -3.264  1.00 31.44           H 
ATOM    847 1HB  ARG    52      -7.521   9.617  -4.174  1.00 37.79           H 
ATOM    848 2HB  ARG    52      -6.110   9.692  -5.221  1.00 37.79           H 
ATOM    849 1HG  ARG    52      -5.796  12.053  -4.638  1.00 37.79           H 
ATOM    850 2HG  ARG    52      -7.214  11.979  -3.591  1.00 37.79           H 
ATOM    851 1HD  ARG    52      -7.206  11.491  -6.572  1.00 37.79           H 
ATOM    852 2HD  ARG    52      -7.734  12.976  -5.778  1.00 37.79           H 
ATOM    853  HE  ARG    52      -9.341  11.240  -4.606  1.00 63.42           H 
ATOM    854 1HH1 ARG    52      -8.474  11.510  -7.927  1.00 37.79           H 
ATOM    855 2HH1 ARG    52      -9.964  10.845  -8.487  1.00 37.79           H 
ATOM    856 1HH2 ARG    52     -11.241  10.374  -5.331  1.00 37.79           H 
ATOM    857 2HH2 ARG    52     -11.512  10.199  -7.031  1.00 37.79           H 
ATOM   1084  N   ALA    66       7.886   6.509   6.773  1.00 33.30           N 
ATOM   1085  CA  ALA    66       6.896   5.734   7.524  1.00 61.21           C 
ATOM   1086  C   ALA    66       6.144   4.745   6.622  1.00 32.42           C 
ATOM   1087  O   ALA    66       6.234   4.807   5.393  1.00 74.34           O 
ATOM   1088  CB  ALA    66       5.910   6.673   8.214  1.00 33.23           C 
ATOM   1089  H   ALA    66       7.704   7.454   6.597  1.00 37.79           H 
ATOM   1090  HA  ALA    66       7.418   5.179   8.290  1.00 21.04           H 
ATOM   1091 1HB  ALA    66       6.449   7.363   8.846  1.00 37.79           H 
ATOM   1092 2HB  ALA    66       5.221   6.097   8.817  1.00 37.79           H 
ATOM   1093 3HB  ALA    66       5.358   7.227   7.468  1.00 37.79           H 
ATOM   1094  N   PHE    67       5.385   3.847   7.242  1.00 24.01           N 
ATOM   1095  CA  PHE    67       4.688   2.787   6.514  1.00 25.55           C 
ATOM   1096  C   PHE    67       3.168   3.004   6.510  1.00 55.04           C 
ATOM   1097  O   PHE    67       2.639   3.845   7.236  1.00 71.21           O 
ATOM   1098  CB  PHE    67       5.033   1.423   7.125  1.00 72.14           C 
ATOM   1099  CG  PHE    67       6.517   1.142   7.151  1.00 61.03           C 
ATOM   1100  CD1 PHE    67       7.147   0.552   6.063  1.00  1.43           C 
ATOM   1101  CD2 PHE    67       7.284   1.478   8.258  1.00 21.24           C 
ATOM   1102  CE1 PHE    67       8.507   0.304   6.080  1.00 42.30           C 
ATOM   1103  CE2 PHE    67       8.644   1.230   8.279  1.00 14.12           C 
ATOM   1104  CZ  PHE    67       9.256   0.642   7.189  1.00 50.14           C 
ATOM   1105  H   PHE    67       5.279   3.903   8.215  1.00 37.79           H 
ATOM   1106  HA  PHE    67       5.039   2.803   5.491  1.00 73.32           H 
ATOM   1107 1HB  PHE    67       4.555   0.641   6.548  1.00 37.79           H 
ATOM   1108 2HB  PHE    67       4.667   1.386   8.141  1.00 37.79           H 
ATOM   1109  HD1 PHE    67       6.564   0.284   5.194  1.00  0.25           H 
ATOM   1110  HD2 PHE    67       6.808   1.938   9.112  1.00 22.25           H 
ATOM   1111  HE1 PHE    67       8.983  -0.155   5.225  1.00  1.04           H 
ATOM   1112  HE2 PHE    67       9.227   1.495   9.147  1.00 75.12           H 
ATOM   1113  HZ  PHE    67      10.319   0.447   7.204  1.00 74.31           H 
ATOM   1114  N   LEU    68       2.478   2.231   5.683  1.00 35.22           N 
ATOM   1115  CA  LEU    68       1.029   2.328   5.527  1.00 15.24           C 
ATOM   1116  C   LEU    68       0.387   0.939   5.574  1.00 62.43           C 
ATOM   1117  O   LEU    68       1.025  -0.068   5.270  1.00  2.30           O 
ATOM   1118  CB  LEU    68       0.661   3.011   4.198  1.00 72.32           C 
ATOM   1119  CG  LEU    68       1.066   4.487   4.065  1.00  0.21           C 
ATOM   1120  CD1 LEU    68       0.669   5.028   2.693  1.00 24.04           C 
ATOM   1121  CD2 LEU    68       0.438   5.325   5.176  1.00 44.23           C 
ATOM   1122  H   LEU    68       2.958   1.555   5.171  1.00 37.79           H 
ATOM   1123  HA  LEU    68       0.641   2.919   6.347  1.00 44.13           H 
ATOM   1124 1HB  LEU    68      -0.412   2.943   4.069  1.00 37.79           H 
ATOM   1125 2HB  LEU    68       1.133   2.459   3.397  1.00 37.79           H 
ATOM   1126  HG  LEU    68       2.141   4.566   4.153  1.00 14.14           H 
ATOM   1127 1HD1 LEU    68       1.167   4.457   1.923  1.00 37.79           H 
ATOM   1128 2HD1 LEU    68       0.962   6.065   2.617  1.00 37.79           H 
ATOM   1129 3HD1 LEU    68      -0.401   4.946   2.566  1.00 37.79           H 
ATOM   1130 1HD2 LEU    68      -0.639   5.257   5.118  1.00 37.79           H 
ATOM   1131 2HD2 LEU    68       0.741   6.356   5.066  1.00 37.79           H 
ATOM   1132 3HD2 LEU    68       0.769   4.956   6.136  1.00 37.79           H 
ATOM   1133  N   ARG    69      -0.881   0.906   5.939  1.00 72.04           N 
ATOM   1134  CA  ARG    69      -1.646  -0.331   6.041  1.00 31.20           C 
ATOM   1135  C   ARG    69      -2.964  -0.175   5.274  1.00 32.31           C 
ATOM   1136  O   ARG    69      -3.812   0.630   5.647  1.00 22.14           O 
ATOM   1137  CB  ARG    69      -1.899  -0.600   7.530  1.00 41.14           C 
ATOM   1138  CG  ARG    69      -2.595  -1.915   7.863  1.00 34.12           C 
ATOM   1139  CD  ARG    69      -2.746  -2.052   9.373  1.00 73.44           C 
ATOM   1140  NE  ARG    69      -3.442  -3.266   9.785  1.00 34.12           N 
ATOM   1141  CZ  ARG    69      -3.940  -3.428  10.981  1.00 45.14           C 
ATOM   1142  NH1 ARG    69      -3.904  -2.460  11.843  1.00 23.24           N 
ATOM   1143  NH2 ARG    69      -4.503  -4.544  11.308  1.00 21.24           N 
ATOM   1144  H   ARG    69      -1.323   1.748   6.155  1.00 37.79           H 
ATOM   1145  HA  ARG    69      -1.067  -1.140   5.616  1.00 13.24           H 
ATOM   1146 1HB  ARG    69      -2.505   0.207   7.923  1.00 37.79           H 
ATOM   1147 2HB  ARG    69      -0.949  -0.593   8.044  1.00 37.79           H 
ATOM   1148 1HG  ARG    69      -2.002  -2.737   7.489  1.00 37.79           H 
ATOM   1149 2HG  ARG    69      -3.574  -1.926   7.403  1.00 37.79           H 
ATOM   1150 1HD  ARG    69      -3.297  -1.194   9.739  1.00 37.79           H 
ATOM   1151 2HD  ARG    69      -1.762  -2.053   9.818  1.00 37.79           H 
ATOM   1152  HE  ARG    69      -3.515  -3.994   9.142  1.00  1.31           H 
ATOM   1153 1HH1 ARG    69      -3.496  -1.580  11.593  1.00 37.79           H 
ATOM   1154 2HH1 ARG    69      -4.278  -2.594  12.758  1.00 37.79           H 
ATOM   1155 1HH2 ARG    69      -4.560  -5.290  10.647  1.00 37.79           H 
ATOM   1156 2HH2 ARG    69      -4.878  -4.659  12.224  1.00 37.79           H 
ATOM   1157  N   LEU    70      -3.132  -0.943   4.204  1.00 20.55           N 
ATOM   1158  CA  LEU    70      -4.292  -0.796   3.320  1.00 33.33           C 
ATOM   1159  C   LEU    70      -5.294  -1.938   3.514  1.00 12.31           C 
ATOM   1160  O   LEU    70      -4.933  -3.118   3.489  1.00 73.23           O 
ATOM   1161  CB  LEU    70      -3.854  -0.723   1.842  1.00 62.21           C 
ATOM   1162  CG  LEU    70      -3.135   0.575   1.407  1.00 75.23           C 
ATOM   1163  CD1 LEU    70      -1.827   0.781   2.170  1.00 73.03           C 
ATOM   1164  CD2 LEU    70      -2.881   0.569  -0.097  1.00 15.32           C 
ATOM   1165  H   LEU    70      -2.464  -1.628   4.001  1.00 37.79           H 
ATOM   1166  HA  LEU    70      -4.783   0.134   3.578  1.00  3.31           H 
ATOM   1167 1HB  LEU    70      -4.733  -0.842   1.223  1.00 37.79           H 
ATOM   1168 2HB  LEU    70      -3.190  -1.554   1.650  1.00 37.79           H 
ATOM   1169  HG  LEU    70      -3.777   1.417   1.627  1.00  5.31           H 
ATOM   1170 1HD1 LEU    70      -1.176  -0.066   2.009  1.00 37.79           H 
ATOM   1171 2HD1 LEU    70      -2.036   0.878   3.225  1.00 37.79           H 
ATOM   1172 3HD1 LEU    70      -1.339   1.680   1.818  1.00 37.79           H 
ATOM   1173 1HD2 LEU    70      -3.822   0.504  -0.623  1.00 37.79           H 
ATOM   1174 2HD2 LEU    70      -2.266  -0.281  -0.356  1.00 37.79           H 
ATOM   1175 3HD2 LEU    70      -2.373   1.480  -0.383  1.00 37.79           H 
ATOM   1176  N   TYR    71      -6.554  -1.572   3.705  1.00  4.11           N 
ATOM   1177  CA  TYR    71      -7.629  -2.541   3.923  1.00 10.13           C 
ATOM   1178  C   TYR    71      -8.475  -2.719   2.657  1.00 15.31           C 
ATOM   1179  O   TYR    71      -9.033  -1.753   2.128  1.00 52.43           O 
ATOM   1180  CB  TYR    71      -8.522  -2.073   5.079  1.00  1.32           C 
ATOM   1181  CG  TYR    71      -7.754  -1.742   6.347  1.00 20.41           C 
ATOM   1182  CD1 TYR    71      -7.517  -0.420   6.716  1.00 63.43           C 
ATOM   1183  CD2 TYR    71      -7.263  -2.749   7.170  1.00 71.51           C 
ATOM   1184  CE1 TYR    71      -6.818  -0.114   7.869  1.00 32.32           C 
ATOM   1185  CE2 TYR    71      -6.565  -2.449   8.324  1.00 14.31           C 
ATOM   1186  CZ  TYR    71      -6.345  -1.131   8.667  1.00 12.13           C 
ATOM   1187  OH  TYR    71      -5.649  -0.833   9.816  1.00 52.25           O 
ATOM   1188  H   TYR    71      -6.772  -0.618   3.704  1.00 37.79           H 
ATOM   1189  HA  TYR    71      -7.183  -3.490   4.185  1.00 71.44           H 
ATOM   1190 1HB  TYR    71      -9.234  -2.852   5.314  1.00 37.79           H 
ATOM   1191 2HB  TYR    71      -9.059  -1.185   4.774  1.00 37.79           H 
ATOM   1192  HD1 TYR    71      -7.889   0.376   6.089  1.00 20.44           H 
ATOM   1193  HD2 TYR    71      -7.435  -3.782   6.901  1.00 52.23           H 
ATOM   1194  HE1 TYR    71      -6.644   0.918   8.138  1.00 35.22           H 
ATOM   1195  HE2 TYR    71      -6.193  -3.246   8.951  1.00 22.14           H 
ATOM   1196  HH  TYR    71      -6.100  -0.128  10.295  1.00 71.31           H 
ATOM   1197  N   VAL    72      -8.558  -3.951   2.167  1.00 31.02           N 
ATOM   1198  CA  VAL    72      -9.406  -4.271   1.016  1.00 71.24           C 
ATOM   1199  C   VAL    72     -10.546  -5.213   1.432  1.00 53.44           C 
ATOM   1200  O   VAL    72     -10.357  -6.114   2.254  1.00 50.24           O 
ATOM   1201  CB  VAL    72      -8.584  -4.905  -0.138  1.00 55.51           C 
ATOM   1202  CG1 VAL    72      -7.912  -6.202   0.306  1.00 24.42           C 
ATOM   1203  CG2 VAL    72      -9.456  -5.135  -1.372  1.00 31.30           C 
ATOM   1204  H   VAL    72      -8.036  -4.668   2.588  1.00 37.79           H 
ATOM   1205  HA  VAL    72      -9.839  -3.345   0.653  1.00 25.11           H 
ATOM   1206  HB  VAL    72      -7.803  -4.207  -0.409  1.00 74.53           H 
ATOM   1207 1HG1 VAL    72      -8.665  -6.920   0.598  1.00 37.79           H 
ATOM   1208 2HG1 VAL    72      -7.259  -6.005   1.146  1.00 37.79           H 
ATOM   1209 3HG1 VAL    72      -7.332  -6.603  -0.512  1.00 37.79           H 
ATOM   1210 1HG2 VAL    72      -8.857  -5.570  -2.160  1.00 37.79           H 
ATOM   1211 2HG2 VAL    72      -9.861  -4.191  -1.710  1.00 37.79           H 
ATOM   1212 3HG2 VAL    72     -10.267  -5.806  -1.125  1.00 37.79           H 
ATOM   1433  N   LYS    88     -10.565   0.120   0.556  1.00 13.14           N 
ATOM   1434  CA  LYS    88     -11.628   0.878   1.232  1.00 34.52           C 
ATOM   1435  C   LYS    88     -11.065   1.902   2.233  1.00 74.05           C 
ATOM   1436  O   LYS    88     -11.679   2.943   2.476  1.00 35.55           O 
ATOM   1437  CB  LYS    88     -12.598  -0.087   1.938  1.00  4.12           C 
ATOM   1438  CG  LYS    88     -11.936  -1.000   2.970  1.00 35.03           C 
ATOM   1439  CD  LYS    88     -12.904  -2.045   3.527  1.00 34.12           C 
ATOM   1440  CE  LYS    88     -14.118  -1.413   4.198  1.00 34.05           C 
ATOM   1441  NZ  LYS    88     -15.086  -2.440   4.666  1.00 62.25           N 
ATOM   1442  H   LYS    88     -10.290  -0.747   0.923  1.00 37.79           H 
ATOM   1443  HA  LYS    88     -12.177   1.417   0.470  1.00 54.25           H 
ATOM   1444 1HB  LYS    88     -13.070  -0.709   1.190  1.00 37.79           H 
ATOM   1445 2HB  LYS    88     -13.361   0.493   2.439  1.00 37.79           H 
ATOM   1446 1HG  LYS    88     -11.566  -0.393   3.785  1.00 37.79           H 
ATOM   1447 2HG  LYS    88     -11.110  -1.513   2.500  1.00 37.79           H 
ATOM   1448 1HD  LYS    88     -12.379  -2.651   4.252  1.00 37.79           H 
ATOM   1449 2HD  LYS    88     -13.244  -2.673   2.717  1.00 37.79           H 
ATOM   1450 1HE  LYS    88     -14.610  -0.763   3.490  1.00 37.79           H 
ATOM   1451 2HE  LYS    88     -13.785  -0.833   5.047  1.00 37.79           H 
ATOM   1452 1HZ  LYS    88     -15.374  -3.052   3.875  1.00 37.79           H 
ATOM   1453 2HZ  LYS    88     -15.933  -1.983   5.056  1.00 37.79           H 
ATOM   1454 3HZ  LYS    88     -14.657  -3.030   5.405  1.00 37.79           H 
ATOM   1455  N   SER    89      -9.898   1.608   2.810  1.00 25.23           N 
ATOM   1456  CA  SER    89      -9.257   2.510   3.789  1.00 12.22           C 
ATOM   1457  C   SER    89      -7.758   2.223   3.926  1.00 42.34           C 
ATOM   1458  O   SER    89      -7.279   1.170   3.508  1.00 60.11           O 
ATOM   1459  CB  SER    89      -9.916   2.387   5.175  1.00 73.00           C 
ATOM   1460  OG  SER    89     -11.252   2.865   5.172  1.00 43.43           O 
ATOM   1461  H   SER    89      -9.448   0.771   2.567  1.00 37.79           H 
ATOM   1462  HA  SER    89      -9.382   3.523   3.432  1.00 45.21           H 
ATOM   1463 1HB  SER    89      -9.347   2.962   5.893  1.00 37.79           H 
ATOM   1464 2HB  SER    89      -9.925   1.350   5.477  1.00 37.79           H 
ATOM   1465  HG  SER    89     -11.439   3.292   4.326  1.00 35.04           H 
ATOM   1466  N   TYR    90      -7.022   3.162   4.527  1.00 22.31           N 
ATOM   1467  CA  TYR    90      -5.592   2.966   4.800  1.00 52.02           C 
ATOM   1468  C   TYR    90      -5.207   3.534   6.180  1.00 25.35           C 
ATOM   1469  O   TYR    90      -5.932   4.348   6.755  1.00 34.33           O 
ATOM   1470  CB  TYR    90      -4.723   3.600   3.698  1.00  3.22           C 
ATOM   1471  CG  TYR    90      -4.642   5.117   3.751  1.00 12.41           C 
ATOM   1472  CD1 TYR    90      -3.506   5.753   4.246  1.00 14.15           C 
ATOM   1473  CD2 TYR    90      -5.697   5.910   3.312  1.00  1.54           C 
ATOM   1474  CE1 TYR    90      -3.426   7.130   4.300  1.00 61.11           C 
ATOM   1475  CE2 TYR    90      -5.620   7.287   3.362  1.00  4.32           C 
ATOM   1476  CZ  TYR    90      -4.484   7.891   3.858  1.00 71.13           C 
ATOM   1477  OH  TYR    90      -4.410   9.262   3.914  1.00 41.41           O 
ATOM   1478  H   TYR    90      -7.447   4.003   4.793  1.00 37.79           H 
ATOM   1479  HA  TYR    90      -5.407   1.900   4.812  1.00 71.54           H 
ATOM   1480 1HB  TYR    90      -5.124   3.323   2.732  1.00 37.79           H 
ATOM   1481 2HB  TYR    90      -3.717   3.214   3.782  1.00 37.79           H 
ATOM   1482  HD1 TYR    90      -2.675   5.153   4.591  1.00 33.40           H 
ATOM   1483  HD2 TYR    90      -6.586   5.436   2.926  1.00 13.12           H 
ATOM   1484  HE1 TYR    90      -2.535   7.605   4.687  1.00 45.53           H 
ATOM   1485  HE2 TYR    90      -6.450   7.887   3.016  1.00 23.03           H 
ATOM   1486  HH  TYR    90      -5.216   9.603   4.315  1.00  4.41           H 
ATOM   1487  N   GLU    91      -4.061   3.101   6.694  1.00  3.42           N 
ATOM   1488  CA  GLU    91      -3.603   3.473   8.042  1.00 74.55           C 
ATOM   1489  C   GLU    91      -2.085   3.735   8.057  1.00 64.43           C 
ATOM   1490  O   GLU    91      -1.325   2.996   7.444  1.00 14.34           O 
ATOM   1491  CB  GLU    91      -3.963   2.331   9.010  1.00 43.34           C 
ATOM   1492  CG  GLU    91      -3.512   2.534  10.455  1.00 75.05           C 
ATOM   1493  CD  GLU    91      -3.979   1.404  11.367  1.00  3.12           C 
ATOM   1494  OE1 GLU    91      -3.203   0.448  11.599  1.00  3.41           O 
ATOM   1495  OE2 GLU    91      -5.133   1.462  11.849  1.00 20.45           O 
ATOM   1496  H   GLU    91      -3.506   2.499   6.158  1.00 37.79           H 
ATOM   1497  HA  GLU    91      -4.122   4.373   8.344  1.00  1.55           H 
ATOM   1498 1HB  GLU    91      -3.513   1.417   8.644  1.00 37.79           H 
ATOM   1499 2HB  GLU    91      -5.036   2.209   9.011  1.00 37.79           H 
ATOM   1500 1HG  GLU    91      -3.917   3.468  10.821  1.00 37.79           H 
ATOM   1501 2HG  GLU    91      -2.432   2.579  10.479  1.00 37.79           H 
ATOM   1502  N   GLU    92      -1.642   4.781   8.754  1.00 12.34           N 
ATOM   1503  CA  GLU    92      -0.203   5.086   8.848  1.00 71.13           C 
ATOM   1504  C   GLU    92       0.418   4.348  10.044  1.00 52.44           C 
ATOM   1505  O   GLU    92      -0.029   4.509  11.182  1.00 61.33           O 
ATOM   1506  CB  GLU    92       0.022   6.603   8.977  1.00 35.14           C 
ATOM   1507  CG  GLU    92       1.495   7.009   9.066  1.00 11.32           C 
ATOM   1508  CD  GLU    92       1.690   8.510   9.239  1.00 74.44           C 
ATOM   1509  OE1 GLU    92       1.086   9.085  10.172  1.00 65.13           O 
ATOM   1510  OE2 GLU    92       2.458   9.119   8.460  1.00 12.12           O 
ATOM   1511  H   GLU    92      -2.288   5.360   9.214  1.00 37.79           H 
ATOM   1512  HA  GLU    92       0.268   4.736   7.938  1.00 60.42           H 
ATOM   1513 1HB  GLU    92      -0.481   6.954   9.868  1.00 37.79           H 
ATOM   1514 2HB  GLU    92      -0.413   7.093   8.116  1.00 37.79           H 
ATOM   1515 1HG  GLU    92       1.996   6.694   8.161  1.00 37.79           H 
ATOM   1516 2HG  GLU    92       1.942   6.508   9.913  1.00 37.79           H 
ATOM   1517  N   ILE    93       1.441   3.534   9.781  1.00 73.20           N 
ATOM   1518  CA  ILE    93       2.008   2.638  10.800  1.00 20.14           C 
ATOM   1519  C   ILE    93       3.548   2.644  10.822  1.00 22.02           C 
ATOM   1520  O   ILE    93       4.205   3.283   9.994  1.00 32.45           O 
ATOM   1521  CB  ILE    93       1.531   1.178  10.581  1.00 24.51           C 
ATOM   1522  CG1 ILE    93       1.930   0.684   9.178  1.00 61.02           C 
ATOM   1523  CG2 ILE    93       0.021   1.066  10.788  1.00 55.35           C 
ATOM   1524  CD1 ILE    93       1.584  -0.768   8.912  1.00  1.24           C 
ATOM   1525  H   ILE    93       1.831   3.541   8.883  1.00 37.79           H 
ATOM   1526  HA  ILE    93       1.651   2.963  11.767  1.00 34.52           H 
ATOM   1527  HB  ILE    93       2.013   0.555  11.321  1.00 75.22           H 
ATOM   1528 1HG1 ILE    93       2.999   0.797   9.053  1.00 37.79           H 
ATOM   1529 2HG1 ILE    93       1.424   1.282   8.436  1.00 37.79           H 
ATOM   1530 1HG2 ILE    93      -0.280   0.032  10.698  1.00 37.79           H 
ATOM   1531 2HG2 ILE    93      -0.492   1.655  10.043  1.00 37.79           H 
ATOM   1532 3HG2 ILE    93      -0.236   1.429  11.774  1.00 37.79           H 
ATOM   1533 1HD1 ILE    93       1.851  -1.019   7.896  1.00 37.79           H 
ATOM   1534 2HD1 ILE    93       0.525  -0.920   9.053  1.00 37.79           H 
ATOM   1535 3HD1 ILE    93       2.134  -1.400   9.594  1.00 37.79           H 
ATOM   1536  N   GLN    94       4.107   1.907  11.782  1.00 25.52           N 
ATOM   1537  CA  GLN    94       5.559   1.754  11.921  1.00 31.04           C 
ATOM   1538  C   GLN    94       5.989   0.330  11.526  1.00 61.23           C 
ATOM   1539  O   GLN    94       5.148  -0.536  11.281  1.00 31.03           O 
ATOM   1540  CB  GLN    94       5.979   2.053  13.369  1.00 21.14           C 
ATOM   1541  CG  GLN    94       5.425   1.058  14.384  1.00  2.22           C 
ATOM   1542  CD  GLN    94       5.682   1.459  15.826  1.00 30.12           C 
ATOM   1543  OE1 GLN    94       6.704   1.116  16.411  1.00 11.24           O 
ATOM   1544  NE2 GLN    94       4.746   2.171  16.418  1.00  5.21           N 
ATOM   1545  H   GLN    94       3.521   1.437  12.416  1.00 37.79           H 
ATOM   1546  HA  GLN    94       6.040   2.461  11.259  1.00 33.05           H 
ATOM   1547 1HB  GLN    94       5.629   3.041  13.634  1.00 37.79           H 
ATOM   1548 2HB  GLN    94       7.059   2.036  13.430  1.00 37.79           H 
ATOM   1549 1HG  GLN    94       5.884   0.095  14.207  1.00 37.79           H 
ATOM   1550 2HG  GLN    94       4.358   0.974  14.237  1.00 37.79           H 
ATOM   1551 1HE2 GLN    94       3.944   2.401  15.904  1.00 37.79           H 
ATOM   1552 2HE2 GLN    94       4.889   2.436  17.348  1.00 37.79           H 
ATOM   1553  N   LYS    95       7.298   0.085  11.478  1.00  5.41           N 
ATOM   1554  CA  LYS    95       7.824  -1.236  11.098  1.00 60.52           C 
ATOM   1555  C   LYS    95       7.325  -2.344  12.049  1.00 64.21           C 
ATOM   1556  O   LYS    95       7.222  -3.509  11.660  1.00 61.24           O 
ATOM   1557  CB  LYS    95       9.358  -1.203  11.078  1.00 60.14           C 
ATOM   1558  CG  LYS    95      10.003  -2.482  10.550  1.00 42.14           C 
ATOM   1559  CD  LYS    95      11.525  -2.406  10.602  1.00 61.43           C 
ATOM   1560  CE  LYS    95      12.179  -3.706  10.147  1.00 51.12           C 
ATOM   1561  NZ  LYS    95      13.660  -3.649  10.257  1.00 60.40           N 
ATOM   1562  H   LYS    95       7.927   0.802  11.703  1.00 37.79           H 
ATOM   1563  HA  LYS    95       7.468  -1.454  10.101  1.00 70.35           H 
ATOM   1564 1HB  LYS    95       9.715  -1.033  12.085  1.00 37.79           H 
ATOM   1565 2HB  LYS    95       9.679  -0.380  10.453  1.00 37.79           H 
ATOM   1566 1HG  LYS    95       9.691  -2.635   9.525  1.00 37.79           H 
ATOM   1567 2HG  LYS    95       9.675  -3.315  11.156  1.00 37.79           H 
ATOM   1568 1HD  LYS    95      11.830  -2.196  11.618  1.00 37.79           H 
ATOM   1569 2HD  LYS    95      11.859  -1.607   9.955  1.00 37.79           H 
ATOM   1570 1HE  LYS    95      11.910  -3.891   9.117  1.00 37.79           H 
ATOM   1571 2HE  LYS    95      11.816  -4.514  10.764  1.00 37.79           H 
ATOM   1572 1HZ  LYS    95      14.038  -2.903   9.638  1.00 37.79           H 
ATOM   1573 2HZ  LYS    95      14.076  -4.562   9.983  1.00 37.79           H 
ATOM   1574 3HZ  LYS    95      13.939  -3.442  11.238  1.00 37.79           H 
ATOM   1575  N   ALA    96       7.012  -1.969  13.289  1.00 42.05           N 
ATOM   1576  CA  ALA    96       6.493  -2.915  14.286  1.00  2.42           C 
ATOM   1577  C   ALA    96       5.117  -3.490  13.893  1.00  3.13           C 
ATOM   1578  O   ALA    96       4.809  -4.643  14.207  1.00 40.35           O 
ATOM   1579  CB  ALA    96       6.409  -2.241  15.649  1.00 70.41           C 
ATOM   1580  H   ALA    96       7.150  -1.034  13.551  1.00 37.79           H 
ATOM   1581  HA  ALA    96       7.199  -3.731  14.363  1.00 43.25           H 
ATOM   1582 1HB  ALA    96       5.684  -1.440  15.611  1.00 37.79           H 
ATOM   1583 2HB  ALA    96       7.376  -1.838  15.913  1.00 37.79           H 
ATOM   1584 3HB  ALA    96       6.107  -2.965  16.392  1.00 37.79           H 
ATOM   1585  N   ASP    97       4.290  -2.685  13.218  1.00 32.43           N 
ATOM   1586  CA  ASP    97       2.965  -3.141  12.770  1.00 44.52           C 
ATOM   1587  C   ASP    97       3.079  -4.138  11.604  1.00 21.31           C 
ATOM   1588  O   ASP    97       2.160  -4.917  11.342  1.00 22.43           O 
ATOM   1589  CB  ASP    97       2.101  -1.947  12.348  1.00  2.13           C 
ATOM   1590  CG  ASP    97       1.852  -0.971  13.484  1.00 13.33           C 
ATOM   1591  OD1 ASP    97       2.567   0.048  13.570  1.00 15.33           O 
ATOM   1592  OD2 ASP    97       0.936  -1.217  14.298  1.00 62.34           O 
ATOM   1593  H   ASP    97       4.573  -1.767  13.014  1.00 37.79           H 
ATOM   1594  HA  ASP    97       2.489  -3.638  13.603  1.00 42.11           H 
ATOM   1595 1HB  ASP    97       1.145  -2.310  11.992  1.00 37.79           H 
ATOM   1596 2HB  ASP    97       2.597  -1.419  11.545  1.00 37.79           H 
ATOM   1597  N   LEU    98       4.214  -4.106  10.912  1.00 23.41           N 
ATOM   1598  CA  LEU    98       4.457  -4.993   9.774  1.00  3.22           C 
ATOM   1599  C   LEU    98       4.758  -6.425  10.239  1.00  0.12           C 
ATOM   1600  O   LEU    98       5.502  -6.628  11.202  1.00  2.31           O 
ATOM   1601  CB  LEU    98       5.645  -4.477   8.948  1.00 40.31           C 
ATOM   1602  CG  LEU    98       5.532  -3.029   8.442  1.00 44.24           C 
ATOM   1603  CD1 LEU    98       6.805  -2.617   7.705  1.00 62.02           C 
ATOM   1604  CD2 LEU    98       4.309  -2.861   7.543  1.00 22.32           C 
ATOM   1605  H   LEU    98       4.912  -3.474  11.179  1.00 37.79           H 
ATOM   1606  HA  LEU    98       3.573  -4.997   9.155  1.00 24.10           H 
ATOM   1607 1HB  LEU    98       5.768  -5.125   8.091  1.00 37.79           H 
ATOM   1608 2HB  LEU    98       6.535  -4.550   9.558  1.00 37.79           H 
ATOM   1609  HG  LEU    98       5.414  -2.369   9.289  1.00 23.45           H 
ATOM   1610 1HD1 LEU    98       6.721  -1.587   7.387  1.00 37.79           H 
ATOM   1611 2HD1 LEU    98       6.948  -3.249   6.839  1.00 37.79           H 
ATOM   1612 3HD1 LEU    98       7.653  -2.718   8.366  1.00 37.79           H 
ATOM   1613 1HD2 LEU    98       3.413  -3.088   8.105  1.00 37.79           H 
ATOM   1614 2HD2 LEU    98       4.382  -3.532   6.699  1.00 37.79           H 
ATOM   1615 3HD2 LEU    98       4.260  -1.842   7.189  1.00 37.79           H 
ATOM   1616  N   PRO    99       4.185  -7.445   9.567  1.00 33.35           N 
ATOM   1617  CA  PRO    99       4.536  -8.848   9.830  1.00 25.44           C 
ATOM   1618  C   PRO    99       5.992  -9.156   9.433  1.00 43.55           C 
ATOM   1619  O   PRO    99       6.576  -8.458   8.599  1.00 11.51           O 
ATOM   1620  CB  PRO    99       3.544  -9.643   8.964  1.00 64.23           C 
ATOM   1621  CG  PRO    99       3.107  -8.691   7.903  1.00 64.33           C 
ATOM   1622  CD  PRO    99       3.149  -7.318   8.523  1.00 12.14           C 
ATOM   1623  HA  PRO    99       4.391  -9.099  10.873  1.00  4.13           H 
ATOM   1624 1HB  PRO    99       2.708  -9.965   9.569  1.00 37.79           H 
ATOM   1625 2HB  PRO    99       4.037 -10.507   8.539  1.00 37.79           H 
ATOM   1626 1HG  PRO    99       2.101  -8.929   7.585  1.00 37.79           H 
ATOM   1627 2HG  PRO    99       3.784  -8.744   7.062  1.00 37.79           H 
ATOM   1628 1HD  PRO    99       2.191  -7.070   8.959  1.00 37.79           H 
ATOM   1629 2HD  PRO    99       3.431  -6.580   7.784  1.00 37.79           H 
ATOM   1630  N   GLU   100       6.563 -10.207  10.021  1.00 23.10           N 
ATOM   1631  CA  GLU   100       7.989 -10.537   9.848  1.00 74.33           C 
ATOM   1632  C   GLU   100       8.430 -10.547   8.375  1.00 74.30           C 
ATOM   1633  O   GLU   100       9.502 -10.049   8.034  1.00 20.33           O 
ATOM   1634  CB  GLU   100       8.298 -11.900  10.471  1.00  2.53           C 
ATOM   1635  CG  GLU   100       9.788 -12.229  10.511  1.00 43.34           C 
ATOM   1636  CD  GLU   100      10.058 -13.681  10.874  1.00 22.51           C 
ATOM   1637  OE1 GLU   100      10.762 -14.371  10.105  1.00 70.02           O 
ATOM   1638  OE2 GLU   100       9.538 -14.152  11.909  1.00 13.11           O 
ATOM   1639  H   GLU   100       6.012 -10.781  10.593  1.00 37.79           H 
ATOM   1640  HA  GLU   100       8.560  -9.784  10.371  1.00 21.22           H 
ATOM   1641 1HB  GLU   100       7.794 -12.669   9.901  1.00 37.79           H 
ATOM   1642 2HB  GLU   100       7.921 -11.913  11.484  1.00 37.79           H 
ATOM   1643 1HG  GLU   100      10.265 -11.589  11.243  1.00 37.79           H 
ATOM   1644 2HG  GLU   100      10.212 -12.031   9.535  1.00 37.79           H 
ATOM   1645  N   LYS   101       7.611 -11.119   7.504  1.00 25.44           N 
ATOM   1646  CA  LYS   101       7.970 -11.214   6.087  1.00 34.04           C 
ATOM   1647  C   LYS   101       8.005  -9.825   5.423  1.00 63.15           C 
ATOM   1648  O   LYS   101       8.966  -9.477   4.735  1.00 55.54           O 
ATOM   1649  CB  LYS   101       6.993 -12.136   5.341  1.00 25.52           C 
ATOM   1650  CG  LYS   101       6.762 -13.483   6.030  1.00 13.22           C 
ATOM   1651  CD  LYS   101       8.067 -14.181   6.423  1.00 21.22           C 
ATOM   1652  CE  LYS   101       8.953 -14.503   5.224  1.00 24.33           C 
ATOM   1653  NZ  LYS   101      10.209 -15.180   5.639  1.00 25.43           N 
ATOM   1654  H   LYS   101       6.762 -11.494   7.818  1.00 37.79           H 
ATOM   1655  HA  LYS   101       8.960 -11.645   6.032  1.00 31.13           H 
ATOM   1656 1HB  LYS   101       7.381 -12.327   4.350  1.00 37.79           H 
ATOM   1657 2HB  LYS   101       6.039 -11.636   5.252  1.00 37.79           H 
ATOM   1658 1HG  LYS   101       6.209 -14.126   5.357  1.00 37.79           H 
ATOM   1659 2HG  LYS   101       6.178 -13.318   6.924  1.00 37.79           H 
ATOM   1660 1HD  LYS   101       7.823 -15.103   6.931  1.00 37.79           H 
ATOM   1661 2HD  LYS   101       8.618 -13.540   7.096  1.00 37.79           H 
ATOM   1662 1HE  LYS   101       9.202 -13.583   4.713  1.00 37.79           H 
ATOM   1663 2HE  LYS   101       8.412 -15.153   4.552  1.00 37.79           H 
ATOM   1664 1HZ  LYS   101       9.988 -16.090   6.099  1.00 37.79           H 
ATOM   1665 2HZ  LYS   101      10.733 -14.585   6.312  1.00 37.79           H 
ATOM   1666 3HZ  LYS   101      10.810 -15.361   4.812  1.00 37.79           H 
ATOM   1667  N   VAL   102       6.963  -9.031   5.665  1.00 51.42           N 
ATOM   1668  CA  VAL   102       6.828  -7.700   5.057  1.00 13.14           C 
ATOM   1669  C   VAL   102       7.961  -6.743   5.467  1.00 70.44           C 
ATOM   1670  O   VAL   102       8.545  -6.062   4.620  1.00 25.33           O 
ATOM   1671  CB  VAL   102       5.462  -7.068   5.423  1.00 61.20           C 
ATOM   1672  CG1 VAL   102       5.408  -5.593   5.034  1.00 13.43           C 
ATOM   1673  CG2 VAL   102       4.328  -7.841   4.758  1.00 22.51           C 
ATOM   1674  H   VAL   102       6.268  -9.343   6.278  1.00 37.79           H 
ATOM   1675  HA  VAL   102       6.858  -7.827   3.984  1.00 21.35           H 
ATOM   1676  HB  VAL   102       5.333  -7.139   6.495  1.00  3.12           H 
ATOM   1677 1HG1 VAL   102       4.439  -5.186   5.285  1.00 37.79           H 
ATOM   1678 2HG1 VAL   102       5.577  -5.490   3.971  1.00 37.79           H 
ATOM   1679 3HG1 VAL   102       6.173  -5.051   5.573  1.00 37.79           H 
ATOM   1680 1HG2 VAL   102       3.380  -7.404   5.040  1.00 37.79           H 
ATOM   1681 2HG2 VAL   102       4.357  -8.872   5.079  1.00 37.79           H 
ATOM   1682 3HG2 VAL   102       4.438  -7.793   3.685  1.00 37.79           H 
ATOM   1683  N   LYS   103       8.267  -6.689   6.763  1.00  4.22           N 
ATOM   1684  CA  LYS   103       9.319  -5.797   7.268  1.00 40.22           C 
ATOM   1685  C   LYS   103      10.663  -6.060   6.565  1.00 22.05           C 
ATOM   1686  O   LYS   103      11.366  -5.121   6.183  1.00 23.14           O 
ATOM   1687  CB  LYS   103       9.454  -5.941   8.792  1.00 74.03           C 
ATOM   1688  CG  LYS   103       9.708  -7.371   9.259  1.00 15.33           C 
ATOM   1689  CD  LYS   103       9.812  -7.487  10.781  1.00 12.30           C 
ATOM   1690  CE  LYS   103       8.589  -6.903  11.481  1.00 25.02           C 
ATOM   1691  NZ  LYS   103       8.674  -7.032  12.957  1.00 33.23           N 
ATOM   1692  H   LYS   103       7.779  -7.263   7.393  1.00 37.79           H 
ATOM   1693  HA  LYS   103       9.013  -4.784   7.044  1.00 53.12           H 
ATOM   1694 1HB  LYS   103       8.539  -5.589   9.252  1.00 37.79           H 
ATOM   1695 2HB  LYS   103      10.275  -5.323   9.130  1.00 37.79           H 
ATOM   1696 1HG  LYS   103      10.632  -7.720   8.819  1.00 37.79           H 
ATOM   1697 2HG  LYS   103       8.894  -7.996   8.919  1.00 37.79           H 
ATOM   1698 1HD  LYS   103      10.696  -6.968  11.116  1.00 37.79           H 
ATOM   1699 2HD  LYS   103       9.892  -8.533  11.043  1.00 37.79           H 
ATOM   1700 1HE  LYS   103       7.708  -7.425  11.134  1.00 37.79           H 
ATOM   1701 2HE  LYS   103       8.506  -5.856  11.227  1.00 37.79           H 
ATOM   1702 1HZ  LYS   103       7.821  -6.640  13.402  1.00 37.79           H 
ATOM   1703 2HZ  LYS   103       9.503  -6.520  13.316  1.00 37.79           H 
ATOM   1704 3HZ  LYS   103       8.762  -8.032  13.226  1.00 37.79           H 
ATOM   1705  N   ASP   104      11.001  -7.336   6.374  1.00 74.33           N 
ATOM   1706  CA  ASP   104      12.207  -7.715   5.631  1.00 74.15           C 
ATOM   1707  C   ASP   104      12.101  -7.350   4.136  1.00  4.45           C 
ATOM   1708  O   ASP   104      13.108  -7.033   3.495  1.00 11.44           O 
ATOM   1709  CB  ASP   104      12.493  -9.215   5.795  1.00 11.15           C 
ATOM   1710  CG  ASP   104      12.748  -9.615   7.241  1.00 62.31           C 
ATOM   1711  OD1 ASP   104      12.447 -10.771   7.606  1.00 10.55           O 
ATOM   1712  OD2 ASP   104      13.282  -8.786   8.009  1.00 25.44           O 
ATOM   1713  H   ASP   104      10.432  -8.041   6.752  1.00 37.79           H 
ATOM   1714  HA  ASP   104      13.033  -7.162   6.056  1.00 43.15           H 
ATOM   1715 1HB  ASP   104      13.366  -9.472   5.213  1.00 37.79           H 
ATOM   1716 2HB  ASP   104      11.646  -9.780   5.429  1.00 37.79           H 
ATOM   1717  N   LYS   105      10.884  -7.388   3.586  1.00  1.14           N 
ATOM   1718  CA  LYS   105      10.652  -7.024   2.178  1.00 20.34           C 
ATOM   1719  C   LYS   105      10.869  -5.520   1.926  1.00 22.43           C 
ATOM   1720  O   LYS   105      11.214  -5.114   0.815  1.00 61.23           O 
ATOM   1721  CB  LYS   105       9.231  -7.418   1.746  1.00 35.05           C 
ATOM   1722  CG  LYS   105       8.976  -8.923   1.739  1.00 42.20           C 
ATOM   1723  CD  LYS   105       9.871  -9.656   0.739  1.00 61.44           C 
ATOM   1724  CE  LYS   105       9.601  -9.221  -0.699  1.00 30.51           C 
ATOM   1725  NZ  LYS   105      10.407  -9.998  -1.678  1.00 21.42           N 
ATOM   1726  H   LYS   105      10.122  -7.675   4.136  1.00 37.79           H 
ATOM   1727  HA  LYS   105      11.362  -7.578   1.577  1.00 21.31           H 
ATOM   1728 1HB  LYS   105       9.052  -7.042   0.748  1.00 37.79           H 
ATOM   1729 2HB  LYS   105       8.523  -6.959   2.422  1.00 37.79           H 
ATOM   1730 1HG  LYS   105       7.941  -9.101   1.480  1.00 37.79           H 
ATOM   1731 2HG  LYS   105       9.168  -9.314   2.727  1.00 37.79           H 
ATOM   1732 1HD  LYS   105       9.691 -10.720   0.823  1.00 37.79           H 
ATOM   1733 2HD  LYS   105      10.903  -9.448   0.976  1.00 37.79           H 
ATOM   1734 1HE  LYS   105       9.846  -8.173  -0.799  1.00 37.79           H 
ATOM   1735 2HE  LYS   105       8.554  -9.366  -0.919  1.00 37.79           H 
ATOM   1736 1HZ  LYS   105      10.169 -11.008  -1.617  1.00 37.79           H 
ATOM   1737 2HZ  LYS   105      11.421  -9.880  -1.480  1.00 37.79           H 
ATOM   1738 3HZ  LYS   105      10.215  -9.665  -2.643  1.00 37.79           H 
ATOM   1739  N   PHE   106      10.639  -4.696   2.951  1.00 53.42           N 
ATOM   1740  CA  PHE   106      10.887  -3.249   2.851  1.00 43.42           C 
ATOM   1741  C   PHE   106      12.367  -2.904   3.084  1.00 20.54           C 
ATOM   1742  O   PHE   106      12.974  -2.164   2.309  1.00 24.40           O 
ATOM   1743  CB  PHE   106      10.014  -2.471   3.852  1.00 50.33           C 
ATOM   1744  CG  PHE   106       8.601  -2.227   3.381  1.00 62.42           C 
ATOM   1745  CD1 PHE   106       7.528  -2.912   3.937  1.00 31.22           C 
ATOM   1746  CD2 PHE   106       8.346  -1.298   2.381  1.00 64.05           C 
ATOM   1747  CE1 PHE   106       6.235  -2.673   3.505  1.00 24.10           C 
ATOM   1748  CE2 PHE   106       7.055  -1.060   1.947  1.00  3.31           C 
ATOM   1749  CZ  PHE   106       6.000  -1.747   2.510  1.00  3.33           C 
ATOM   1750  H   PHE   106      10.282  -5.067   3.788  1.00 37.79           H 
ATOM   1751  HA  PHE   106      10.620  -2.942   1.849  1.00 70.40           H 
ATOM   1752 1HB  PHE   106      10.470  -1.508   4.043  1.00 37.79           H 
ATOM   1753 2HB  PHE   106       9.965  -3.024   4.779  1.00 37.79           H 
ATOM   1754  HD1 PHE   106       7.706  -3.639   4.716  1.00 43.04           H 
ATOM   1755  HD2 PHE   106       9.169  -0.756   1.938  1.00 62.33           H 
ATOM   1756  HE1 PHE   106       5.408  -3.214   3.945  1.00 51.23           H 
ATOM   1757  HE2 PHE   106       6.873  -0.334   1.167  1.00 25.15           H 
ATOM   1758  HZ  PHE   106       4.990  -1.562   2.172  1.00 20.52           H 
ATOM   1759  N   THR   107      12.947  -3.437   4.157  1.00 21.33           N 
ATOM   1760  CA  THR   107      14.325  -3.087   4.538  1.00 14.34           C 
ATOM   1761  C   THR   107      15.379  -3.877   3.741  1.00 32.33           C 
ATOM   1762  O   THR   107      16.541  -3.475   3.670  1.00 15.42           O 
ATOM   1763  CB  THR   107      14.565  -3.308   6.052  1.00 41.25           C 
ATOM   1764  OG1 THR   107      15.868  -2.839   6.424  1.00  5.12           O 
ATOM   1765  CG2 THR   107      14.434  -4.778   6.433  1.00 24.43           C 
ATOM   1766  H   THR   107      12.441  -4.072   4.709  1.00 37.79           H 
ATOM   1767  HA  THR   107      14.463  -2.032   4.333  1.00 75.15           H 
ATOM   1768  HB  THR   107      13.822  -2.744   6.601  1.00 52.25           H 
ATOM   1769  HG1 THR   107      15.791  -2.301   7.221  1.00 35.33           H 
ATOM   1770 1HG2 THR   107      13.462  -5.144   6.137  1.00 37.79           H 
ATOM   1771 2HG2 THR   107      14.548  -4.886   7.501  1.00 37.79           H 
ATOM   1772 3HG2 THR   107      15.201  -5.349   5.932  1.00 37.79           H 
ATOM   1773  N   ILE   108      14.966  -4.995   3.136  1.00  3.54           N 
ATOM   1774  CA  ILE   108      15.882  -5.865   2.378  1.00 14.53           C 
ATOM   1775  C   ILE   108      17.036  -6.372   3.279  1.00 41.22           C 
ATOM   1776  O   ILE   108      18.187  -6.486   2.853  1.00  3.13           O 
ATOM   1777  CB  ILE   108      16.441  -5.136   1.117  1.00 33.21           C 
ATOM   1778  CG1 ILE   108      15.298  -4.470   0.327  1.00 71.54           C 
ATOM   1779  CG2 ILE   108      17.207  -6.104   0.211  1.00 45.30           C 
ATOM   1780  CD1 ILE   108      14.257  -5.444  -0.192  1.00 62.14           C 
ATOM   1781  H   ILE   108      14.017  -5.239   3.187  1.00 37.79           H 
ATOM   1782  HA  ILE   108      15.310  -6.721   2.047  1.00 62.10           H 
ATOM   1783  HB  ILE   108      17.130  -4.371   1.446  1.00 75.20           H 
ATOM   1784 1HG1 ILE   108      15.714  -3.945  -0.522  1.00 37.79           H 
ATOM   1785 2HG1 ILE   108      14.793  -3.762   0.967  1.00 37.79           H 
ATOM   1786 1HG2 ILE   108      18.039  -6.526   0.755  1.00 37.79           H 
ATOM   1787 2HG2 ILE   108      17.576  -5.575  -0.656  1.00 37.79           H 
ATOM   1788 3HG2 ILE   108      16.548  -6.900  -0.108  1.00 37.79           H 
ATOM   1789 1HD1 ILE   108      13.496  -4.901  -0.733  1.00 37.79           H 
ATOM   1790 2HD1 ILE   108      13.805  -5.966   0.638  1.00 37.79           H 
ATOM   1791 3HD1 ILE   108      14.728  -6.157  -0.853  1.00 37.79           H 
END
