
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  712),  selected   98 , name 1ue7_C
# Molecule2: number of CA atoms   66 ( 1132),  selected   66 , name T0468.pdb
# PARAMETERS: 1ue7_C.T0468.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_C      -       -           -
LGA    G     3_C      -       -           -
LGA    D     4_C      -       -           -
LGA    T     5_C      -       -           -
LGA    T     6_C      -       -           -
LGA    I     7_C      -       -           -
LGA    T     8_C      D      12          4.068
LGA    I     9_C      V      13          2.164
LGA    V    10_C      Y      14          3.356
LGA    G    11_C      Y      15          2.569
LGA    N    12_C      M      16          4.251
LGA    L    13_C      Q      17          2.554
LGA    T    14_C      -       -           -
LGA    A    15_C      -       -           -
LGA    D    16_C      I      18          3.661
LGA    P    17_C      K      19          3.965
LGA    E    18_C      -       -           -
LGA    L    19_C      T      23          2.416
LGA    R    20_C      I      24          2.484
LGA    F    21_C      E      25          2.783
LGA    T    22_C      K      26          1.507
LGA    P    23_C      V      27          2.056
LGA    -       -      D      28           -
LGA    -       -      G      29           -
LGA    S    24_C      R      30          2.773
LGA    G    25_C      N      31          1.864
LGA    A    26_C      L      32          1.257
LGA    A    27_C      R      33          0.766
LGA    V    28_C      N      34          1.601
LGA    A    29_C      Y      35          0.752
LGA    N    30_C      T      36          0.625
LGA    F    31_C      L      37          0.779
LGA    T    32_C      P      38          1.619
LGA    V    33_C      A      39          0.745
LGA    A    34_C      Y      40          2.088
LGA    S    35_C      D      41          3.192
LGA    T    36_C      E      42          5.034
LGA    E    51_C      D      43          4.284
LGA    A    52_C      G      44          2.392
LGA    L    53_C      V      45          1.130
LGA    F    54_C      K      46          1.541
LGA    L    55_C      K      47          1.790
LGA    R    56_C      Q      48          0.970
LGA    C    57_C      I      49          0.636
LGA    N    58_C      T      50          1.107
LGA    I    59_C      F      51          1.284
LGA    W    60_C      R      52          3.101
LGA    R    61_C      -       -           -
LGA    E    62_C      -       -           -
LGA    A    63_C      -       -           -
LGA    A    64_C      -       -           -
LGA    E    65_C      -       -           -
LGA    N    66_C      -       -           -
LGA    V    67_C      -       -           -
LGA    A    68_C      -       -           -
LGA    E    69_C      -       -           -
LGA    S    70_C      -       -           -
LGA    L    71_C      -       -           -
LGA    T    72_C      -       -           -
LGA    R    73_C      -       -           -
LGA    G    74_C      -       -           -
LGA    A    75_C      A      66          3.639
LGA    R    76_C      F      67          3.147
LGA    V    77_C      L      68          1.800
LGA    I    78_C      R      69          1.279
LGA    V    79_C      L      70          0.582
LGA    S    80_C      Y      71          2.251
LGA    G    81_C      V      72          3.830
LGA    R    82_C      -       -           -
LGA    L    83_C      -       -           -
LGA    K    84_C      -       -           -
LGA    Q    85_C      -       -           -
LGA    R    91_C      -       -           -
LGA    E    92_C      -       -           -
LGA    G    93_C      -       -           -
LGA    E    94_C      -       -           -
LGA    K    95_C      -       -           -
LGA    R    96_C      -       -           -
LGA    T    97_C      -       -           -
LGA    V    98_C      -       -           -
LGA    I    99_C      -       -           -
LGA    E   100_C      -       -           -
LGA    V   101_C      -       -           -
LGA    E   102_C      -       -           -
LGA    V   103_C      -       -           -
LGA    D   104_C      K      88          3.604
LGA    E   105_C      S      89          1.909
LGA    I   106_C      Y      90          1.751
LGA    G   107_C      E      91          1.989
LGA    P   108_C      E      92          1.094
LGA    S   109_C      I      93          2.015
LGA    L   110_C      Q      94          5.495
LGA    -       -      K      95           -
LGA    R   111_C      A      96          4.846
LGA    Y   112_C      D      97          4.331
LGA    A   113_C      L      98           -
LGA    T   114_C      P      99           -
LGA    A   115_C      E     100           -
LGA    K   116_C      K     101           -
LGA    V   117_C      V     102           -
LGA    N   118_C      K     103           -
LGA    -       -      D     104           -
LGA    -       -      K     105           -
LGA    -       -      F     106           -
LGA    -       -      T     107           -
LGA    -       -      I     108           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   66    5.0     52    2.68     1.92     53.284     1.870

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.782730 * X  +   0.271328 * Y  +   0.560103 * Z  + -130.588028
  Y_new =  -0.611983 * X  +   0.171876 * Y  +   0.771969 * Z  + -103.020668
  Z_new =   0.113188 * X  +  -0.947016 * Y  +   0.300581 * Z  +  46.147869 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.263456    1.878137  [ DEG:   -72.3907    107.6093 ]
  Theta =  -0.113431   -3.028162  [ DEG:    -6.4991   -173.5009 ]
  Phi   =  -0.663580    2.478013  [ DEG:   -38.0203    141.9797 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue7_C                                        
REMARK     2: T0468.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue7_C.T0468.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   66   5.0   52   2.68    1.92  53.284
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue7_C
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE7              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE7    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE7    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 3.20 ANGSTROMS.                                          
DBREF  1UE7 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *183(H2 O)                                                    
CRYST1   60.223  116.720  177.885  90.00  90.00  90.00 I 21 21 21   32          
ATOM   1466  N   ALA C   2     -23.909  -6.041  -2.099  1.00 88.86           N  
ATOM   1467  CA  ALA C   2     -22.527  -6.579  -2.226  1.00 88.86           C  
ATOM   1468  C   ALA C   2     -21.438  -5.505  -2.075  1.00 88.86           C  
ATOM   1469  O   ALA C   2     -21.041  -5.175  -0.955  1.00 88.86           O  
ATOM   1470  CB  ALA C   2     -22.371  -7.304  -3.564  1.00 27.10           C  
ATOM   1471  N   GLY C   3     -20.975  -4.944  -3.193  1.00101.61           N  
ATOM   1472  CA  GLY C   3     -19.896  -3.963  -3.137  1.00101.61           C  
ATOM   1473  C   GLY C   3     -18.693  -4.848  -2.871  1.00101.61           C  
ATOM   1474  O   GLY C   3     -18.187  -4.908  -1.748  1.00101.61           O  
ATOM   1475  N   ASP C   4     -18.227  -5.527  -3.922  1.00101.61           N  
ATOM   1476  CA  ASP C   4     -17.152  -6.503  -3.786  1.00101.61           C  
ATOM   1477  C   ASP C   4     -15.701  -6.309  -4.220  1.00101.61           C  
ATOM   1478  O   ASP C   4     -15.249  -5.215  -4.574  1.00101.61           O  
ATOM   1479  CB  ASP C   4     -17.636  -7.834  -4.370  1.00101.61           C  
ATOM   1480  CG  ASP C   4     -17.711  -8.928  -3.327  1.00101.61           C  
ATOM   1481  OD1 ASP C   4     -18.390  -8.724  -2.292  1.00101.61           O  
ATOM   1482  OD2 ASP C   4     -17.089  -9.990  -3.543  1.00101.61           O  
ATOM   1483  N   THR C   5     -15.010  -7.453  -4.175  1.00 91.53           N  
ATOM   1484  CA  THR C   5     -13.590  -7.644  -4.458  1.00 91.53           C  
ATOM   1485  C   THR C   5     -12.781  -6.658  -3.645  1.00 91.53           C  
ATOM   1486  O   THR C   5     -11.855  -6.023  -4.145  1.00 91.53           O  
ATOM   1487  CB  THR C   5     -13.236  -7.539  -5.961  1.00101.48           C  
ATOM   1488  OG1 THR C   5     -11.874  -7.944  -6.144  1.00101.48           O  
ATOM   1489  CG2 THR C   5     -13.410  -6.123  -6.480  1.00101.48           C  
ATOM   1490  N   THR C   6     -13.164  -6.556  -2.373  1.00 52.93           N  
ATOM   1491  CA  THR C   6     -12.520  -5.684  -1.401  1.00 52.93           C  
ATOM   1492  C   THR C   6     -11.390  -6.439  -0.695  1.00 52.93           C  
ATOM   1493  O   THR C   6     -11.491  -7.650  -0.464  1.00 52.93           O  
ATOM   1494  CB  THR C   6     -13.530  -5.212  -0.351  1.00 58.53           C  
ATOM   1495  OG1 THR C   6     -14.291  -6.336   0.112  1.00 58.53           O  
ATOM   1496  CG2 THR C   6     -14.462  -4.180  -0.940  1.00 58.53           C  
ATOM   1497  N   ILE C   7     -10.321  -5.723  -0.350  1.00 24.11           N  
ATOM   1498  CA  ILE C   7      -9.184  -6.337   0.321  1.00 24.11           C  
ATOM   1499  C   ILE C   7      -8.521  -5.419   1.337  1.00 24.11           C  
ATOM   1500  O   ILE C   7      -8.588  -4.193   1.226  1.00 24.11           O  
ATOM   1501  CB  ILE C   7      -8.091  -6.711  -0.685  1.00 26.93           C  
ATOM   1502  CG1 ILE C   7      -6.950  -7.454   0.020  1.00 26.93           C  
ATOM   1503  CG2 ILE C   7      -7.521  -5.446  -1.306  1.00 26.93           C  
ATOM   1504  CD1 ILE C   7      -5.782  -7.813  -0.884  1.00 26.93           C  
ATOM   1505  N   THR C   8      -7.885  -6.019   2.337  1.00 25.25           N  
ATOM   1506  CA  THR C   8      -7.139  -5.247   3.319  1.00 25.25           C  
ATOM   1507  C   THR C   8      -5.718  -5.781   3.267  1.00 25.25           C  
ATOM   1508  O   THR C   8      -5.495  -7.001   3.324  1.00 25.25           O  
ATOM   1509  CB  THR C   8      -7.686  -5.397   4.737  1.00 25.52           C  
ATOM   1510  OG1 THR C   8      -8.883  -4.627   4.854  1.00 25.52           O  
ATOM   1511  CG2 THR C   8      -6.686  -4.872   5.747  1.00 25.52           C  
ATOM   1512  N   ILE C   9      -4.763  -4.864   3.131  1.00 45.92           N  
ATOM   1513  CA  ILE C   9      -3.362  -5.238   3.051  1.00 45.92           C  
ATOM   1514  C   ILE C   9      -2.583  -4.606   4.187  1.00 45.92           C  
ATOM   1515  O   ILE C   9      -2.948  -3.545   4.712  1.00 45.92           O  
ATOM   1516  CB  ILE C   9      -2.712  -4.778   1.714  1.00 59.41           C  
ATOM   1517  CG1 ILE C   9      -3.548  -5.234   0.517  1.00 59.41           C  
ATOM   1518  CG2 ILE C   9      -1.332  -5.376   1.581  1.00 59.41           C  
ATOM   1519  CD1 ILE C   9      -4.748  -4.370   0.235  1.00 59.41           C  
ATOM   1520  N   VAL C  10      -1.506  -5.280   4.564  1.00 70.86           N  
ATOM   1521  CA  VAL C  10      -0.624  -4.805   5.609  1.00 70.86           C  
ATOM   1522  C   VAL C  10       0.792  -5.055   5.121  1.00 70.86           C  
ATOM   1523  O   VAL C  10       1.127  -6.155   4.657  1.00 70.86           O  
ATOM   1524  CB  VAL C  10      -0.858  -5.557   6.918  1.00 24.32           C  
ATOM   1525  CG1 VAL C  10      -0.024  -4.955   8.023  1.00 24.32           C  
ATOM   1526  CG2 VAL C  10      -2.341  -5.502   7.275  1.00 24.32           C  
ATOM   1527  N   GLY C  11       1.614  -4.020   5.201  1.00 45.41           N  
ATOM   1528  CA  GLY C  11       2.983  -4.144   4.747  1.00 45.41           C  
ATOM   1529  C   GLY C  11       3.672  -2.796   4.698  1.00 45.41           C  
ATOM   1530  O   GLY C  11       3.093  -1.766   5.063  1.00 45.41           O  
ATOM   1531  N   ASN C  12       4.919  -2.809   4.242  1.00 45.85           N  
ATOM   1532  CA  ASN C  12       5.710  -1.602   4.149  1.00 45.85           C  
ATOM   1533  C   ASN C  12       5.810  -1.164   2.704  1.00 45.85           C  
ATOM   1534  O   ASN C  12       5.722  -1.974   1.786  1.00 45.85           O  
ATOM   1535  CB  ASN C  12       7.098  -1.861   4.709  1.00 60.76           C  
ATOM   1536  CG  ASN C  12       7.055  -2.583   6.029  1.00 60.76           C  
ATOM   1537  OD1 ASN C  12       6.666  -2.017   7.059  1.00 60.76           O  
ATOM   1538  ND2 ASN C  12       7.435  -3.854   6.009  1.00 60.76           N  
ATOM   1539  N   LEU C  13       5.988   0.132   2.509  1.00 32.14           N  
ATOM   1540  CA  LEU C  13       6.112   0.677   1.174  1.00 32.14           C  
ATOM   1541  C   LEU C  13       7.488   0.343   0.585  1.00 32.14           C  
ATOM   1542  O   LEU C  13       8.528   0.479   1.246  1.00 32.14           O  
ATOM   1543  CB  LEU C  13       5.910   2.194   1.206  1.00 50.85           C  
ATOM   1544  CG  LEU C  13       4.526   2.651   1.650  1.00 50.85           C  
ATOM   1545  CD1 LEU C  13       4.452   4.169   1.650  1.00 50.85           C  
ATOM   1546  CD2 LEU C  13       3.504   2.058   0.712  1.00 50.85           C  
ATOM   1547  N   THR C  14       7.483  -0.106  -0.663  1.00 73.65           N  
ATOM   1548  CA  THR C  14       8.719  -0.444  -1.341  1.00 73.65           C  
ATOM   1549  C   THR C  14       9.566   0.808  -1.488  1.00 73.65           C  
ATOM   1550  O   THR C  14      10.792   0.752  -1.409  1.00 73.65           O  
ATOM   1551  CB  THR C  14       8.430  -1.030  -2.716  1.00 21.98           C  
ATOM   1552  OG1 THR C  14       7.435  -0.238  -3.369  1.00 21.98           O  
ATOM   1553  CG2 THR C  14       7.913  -2.439  -2.577  1.00 21.98           C  
ATOM   1554  N   ALA C  15       8.900   1.939  -1.697  1.00 71.10           N  
ATOM   1555  CA  ALA C  15       9.575   3.222  -1.855  1.00 71.10           C  
ATOM   1556  C   ALA C  15       8.604   4.308  -1.449  1.00 71.10           C  
ATOM   1557  O   ALA C  15       7.521   4.019  -0.950  1.00 71.10           O  
ATOM   1558  CB  ALA C  15      10.002   3.424  -3.301  1.00 75.93           C  
ATOM   1559  N   ASP C  16       8.989   5.559  -1.665  1.00 48.97           N  
ATOM   1560  CA  ASP C  16       8.125   6.686  -1.320  1.00 48.97           C  
ATOM   1561  C   ASP C  16       6.978   6.779  -2.334  1.00 48.97           C  
ATOM   1562  O   ASP C  16       7.113   6.373  -3.483  1.00 48.97           O  
ATOM   1563  CB  ASP C  16       8.936   7.995  -1.295  1.00101.33           C  
ATOM   1564  CG  ASP C  16      10.094   7.952  -0.298  1.00101.33           C  
ATOM   1565  OD1 ASP C  16      10.723   9.007  -0.050  1.00101.33           O  
ATOM   1566  OD2 ASP C  16      10.381   6.859   0.232  1.00101.33           O  
ATOM   1567  N   PRO C  17       5.829   7.302  -1.912  1.00 56.65           N  
ATOM   1568  CA  PRO C  17       4.700   7.407  -2.834  1.00 56.65           C  
ATOM   1569  C   PRO C  17       4.971   8.335  -4.010  1.00 56.65           C  
ATOM   1570  O   PRO C  17       5.467   9.443  -3.828  1.00 56.65           O  
ATOM   1571  CB  PRO C  17       3.580   7.926  -1.941  1.00 64.32           C  
ATOM   1572  CG  PRO C  17       3.946   7.391  -0.603  1.00 64.32           C  
ATOM   1573  CD  PRO C  17       5.423   7.651  -0.547  1.00 64.32           C  
ATOM   1574  N   GLU C  18       4.640   7.887  -5.218  1.00 50.29           N  
ATOM   1575  CA  GLU C  18       4.840   8.703  -6.411  1.00 50.29           C  
ATOM   1576  C   GLU C  18       3.591   9.525  -6.674  1.00 50.29           C  
ATOM   1577  O   GLU C  18       2.493   8.982  -6.778  1.00 50.29           O  
ATOM   1578  CB  GLU C  18       5.143   7.813  -7.615  1.00100.65           C  
ATOM   1579  CG  GLU C  18       6.343   6.895  -7.422  1.00100.65           C  
ATOM   1580  CD  GLU C  18       6.895   6.359  -8.739  1.00100.65           C  
ATOM   1581  OE1 GLU C  18       7.759   5.455  -8.700  1.00100.65           O  
ATOM   1582  OE2 GLU C  18       6.474   6.844  -9.814  1.00100.65           O  
ATOM   1583  N   LEU C  19       3.762  10.838  -6.786  1.00 92.01           N  
ATOM   1584  CA  LEU C  19       2.634  11.730  -7.015  1.00 92.01           C  
ATOM   1585  C   LEU C  19       2.520  12.235  -8.453  1.00 92.01           C  
ATOM   1586  O   LEU C  19       3.527  12.508  -9.111  1.00 92.01           O  
ATOM   1587  CB  LEU C  19       2.727  12.924  -6.073  1.00 27.05           C  
ATOM   1588  CG  LEU C  19       1.402  13.316  -5.433  1.00 27.05           C  
ATOM   1589  CD1 LEU C  19       1.568  14.627  -4.697  1.00 27.05           C  
ATOM   1590  CD2 LEU C  19       0.338  13.436  -6.497  1.00 27.05           C  
ATOM   1591  N   ARG C  20       1.280  12.371  -8.924  1.00 48.25           N  
ATOM   1592  CA  ARG C  20       1.000  12.838 -10.285  1.00 48.25           C  
ATOM   1593  C   ARG C  20      -0.401  13.449 -10.383  1.00 48.25           C  
ATOM   1594  O   ARG C  20      -1.252  13.210  -9.519  1.00 48.25           O  
ATOM   1595  CB  ARG C  20       1.132  11.671 -11.282  1.00 46.61           C  
ATOM   1596  N   PHE C  21      -0.628  14.239 -11.434  1.00 77.61           N  
ATOM   1597  CA  PHE C  21      -1.925  14.887 -11.660  1.00 77.61           C  
ATOM   1598  C   PHE C  21      -2.350  14.675 -13.117  1.00 77.61           C  
ATOM   1599  O   PHE C  21      -2.297  13.554 -13.618  1.00 77.61           O  
ATOM   1600  CB  PHE C  21      -1.845  16.399 -11.389  1.00 52.28           C  
ATOM   1601  CG  PHE C  21      -1.225  16.768 -10.067  1.00 52.28           C  
ATOM   1602  CD1 PHE C  21       0.126  16.530  -9.821  1.00 52.28           C  
ATOM   1603  CD2 PHE C  21      -1.984  17.398  -9.082  1.00 52.28           C  
ATOM   1604  CE1 PHE C  21       0.717  16.918  -8.611  1.00 52.28           C  
ATOM   1605  CE2 PHE C  21      -1.409  17.791  -7.872  1.00 52.28           C  
ATOM   1606  CZ  PHE C  21      -0.055  17.550  -7.637  1.00 52.28           C  
ATOM   1607  N   THR C  22      -2.797  15.758 -13.761  1.00101.61           N  
ATOM   1608  CA  THR C  22      -3.185  15.791 -15.182  1.00101.61           C  
ATOM   1609  C   THR C  22      -4.587  15.295 -15.622  1.00101.61           C  
ATOM   1610  O   THR C  22      -5.311  14.694 -14.826  1.00101.61           O  
ATOM   1611  CB  THR C  22      -2.067  15.110 -16.036  1.00101.61           C  
ATOM   1612  OG1 THR C  22      -1.970  13.718 -15.719  1.00101.61           O  
ATOM   1613  CG2 THR C  22      -0.722  15.787 -15.786  1.00101.61           C  
ATOM   1614  N   PRO C  23      -4.969  15.538 -16.906  1.00101.61           N  
ATOM   1615  CA  PRO C  23      -6.230  15.180 -17.551  1.00101.61           C  
ATOM   1616  C   PRO C  23      -7.450  14.956 -16.686  1.00101.61           C  
ATOM   1617  O   PRO C  23      -8.190  13.984 -16.854  1.00101.61           O  
ATOM   1618  CB  PRO C  23      -5.826  13.979 -18.389  1.00101.61           C  
ATOM   1619  CG  PRO C  23      -4.407  14.422 -18.894  1.00101.61           C  
ATOM   1620  CD  PRO C  23      -3.973  15.599 -17.982  1.00101.61           C  
ATOM   1621  N   SER C  24      -7.659  15.915 -15.794  1.00101.61           N  
ATOM   1622  CA  SER C  24      -8.759  15.947 -14.840  1.00101.61           C  
ATOM   1623  C   SER C  24      -8.328  17.059 -13.909  1.00101.61           C  
ATOM   1624  O   SER C  24      -9.142  17.839 -13.411  1.00101.61           O  
ATOM   1625  CB  SER C  24      -8.843  14.648 -14.026  1.00101.61           C  
ATOM   1626  OG  SER C  24      -9.138  13.516 -14.823  1.00101.61           O  
ATOM   1627  N   GLY C  25      -7.014  17.120 -13.709  1.00101.61           N  
ATOM   1628  CA  GLY C  25      -6.423  18.089 -12.812  1.00101.61           C  
ATOM   1629  C   GLY C  25      -6.387  17.391 -11.469  1.00101.61           C  
ATOM   1630  O   GLY C  25      -6.214  18.018 -10.420  1.00101.61           O  
ATOM   1631  N   ALA C  26      -6.554  16.070 -11.522  1.00 91.93           N  
ATOM   1632  CA  ALA C  26      -6.580  15.220 -10.334  1.00 91.93           C  
ATOM   1633  C   ALA C  26      -5.194  14.894  -9.795  1.00 91.93           C  
ATOM   1634  O   ALA C  26      -4.197  15.111 -10.476  1.00 91.93           O  
ATOM   1635  CB  ALA C  26      -7.312  13.932 -10.653  1.00 64.79           C  
ATOM   1636  N   ALA C  27      -5.148  14.373  -8.569  1.00 91.98           N  
ATOM   1637  CA  ALA C  27      -3.897  13.983  -7.919  1.00 91.98           C  
ATOM   1638  C   ALA C  27      -3.874  12.460  -7.794  1.00 91.98           C  
ATOM   1639  O   ALA C  27      -4.649  11.878  -7.041  1.00 91.98           O  
ATOM   1640  CB  ALA C  27      -3.795  14.632  -6.537  1.00 29.73           C  
ATOM   1641  N   VAL C  28      -2.980  11.820  -8.531  1.00 61.44           N  
ATOM   1642  CA  VAL C  28      -2.892  10.370  -8.513  1.00 61.44           C  
ATOM   1643  C   VAL C  28      -1.608   9.838  -7.894  1.00 61.44           C  
ATOM   1644  O   VAL C  28      -0.619   9.633  -8.591  1.00 61.44           O  
ATOM   1645  CB  VAL C  28      -2.993   9.793  -9.938  1.00 77.30           C  
ATOM   1646  CG1 VAL C  28      -3.122   8.282  -9.878  1.00 77.30           C  
ATOM   1647  CG2 VAL C  28      -4.165  10.409 -10.668  1.00 77.30           C  
ATOM   1648  N   ALA C  29      -1.637   9.603  -6.588  1.00 40.39           N  
ATOM   1649  CA  ALA C  29      -0.485   9.068  -5.879  1.00 40.39           C  
ATOM   1650  C   ALA C  29      -0.497   7.559  -6.018  1.00 40.39           C  
ATOM   1651  O   ALA C  29      -1.523   6.920  -5.804  1.00 40.39           O  
ATOM   1652  CB  ALA C  29      -0.543   9.455  -4.405  1.00 70.69           C  
ATOM   1653  N   ASN C  30       0.644   6.996  -6.397  1.00 48.35           N  
ATOM   1654  CA  ASN C  30       0.781   5.552  -6.553  1.00 48.35           C  
ATOM   1655  C   ASN C  30       1.834   5.083  -5.568  1.00 48.35           C  
ATOM   1656  O   ASN C  30       2.426   5.886  -4.861  1.00 48.35           O  
ATOM   1657  CB  ASN C  30       1.212   5.187  -7.981  1.00 88.42           C  
ATOM   1658  CG  ASN C  30       0.104   5.388  -8.999  1.00 88.42           C  
ATOM   1659  OD1 ASN C  30      -0.448   6.479  -9.127  1.00 88.42           O  
ATOM   1660  ND2 ASN C  30      -0.221   4.331  -9.735  1.00 88.42           N  
ATOM   1661  N   PHE C  31       2.063   3.780  -5.527  1.00 47.31           N  
ATOM   1662  CA  PHE C  31       3.038   3.193  -4.624  1.00 47.31           C  
ATOM   1663  C   PHE C  31       2.670   1.742  -4.463  1.00 47.31           C  
ATOM   1664  O   PHE C  31       1.502   1.387  -4.593  1.00 47.31           O  
ATOM   1665  CB  PHE C  31       2.980   3.857  -3.256  1.00 45.94           C  
ATOM   1666  CG  PHE C  31       1.662   3.701  -2.567  1.00 45.94           C  
ATOM   1667  CD1 PHE C  31       0.574   4.485  -2.921  1.00 45.94           C  
ATOM   1668  CD2 PHE C  31       1.508   2.761  -1.567  1.00 45.94           C  
ATOM   1669  CE1 PHE C  31      -0.650   4.333  -2.292  1.00 45.94           C  
ATOM   1670  CE2 PHE C  31       0.284   2.596  -0.927  1.00 45.94           C  
ATOM   1671  CZ  PHE C  31      -0.798   3.386  -1.291  1.00 45.94           C  
ATOM   1672  N   THR C  32       3.651   0.898  -4.171  1.00 23.35           N  
ATOM   1673  CA  THR C  32       3.357  -0.512  -3.996  1.00 23.35           C  
ATOM   1674  C   THR C  32       3.743  -0.981  -2.590  1.00 23.35           C  
ATOM   1675  O   THR C  32       4.800  -0.611  -2.067  1.00 23.35           O  
ATOM   1676  CB  THR C  32       4.062  -1.369  -5.075  1.00  8.28           C  
ATOM   1677  OG1 THR C  32       5.118  -2.128  -4.473  1.00  8.28           O  
ATOM   1678  CG2 THR C  32       4.625  -0.473  -6.183  1.00  8.28           C  
ATOM   1679  N   VAL C  33       2.848  -1.765  -1.982  1.00 29.73           N  
ATOM   1680  CA  VAL C  33       3.032  -2.304  -0.636  1.00 29.73           C  
ATOM   1681  C   VAL C  33       3.700  -3.670  -0.732  1.00 29.73           C  
ATOM   1682  O   VAL C  33       3.412  -4.440  -1.656  1.00 29.73           O  
ATOM   1683  CB  VAL C  33       1.669  -2.477   0.083  1.00 29.08           C  
ATOM   1684  CG1 VAL C  33       1.872  -2.899   1.535  1.00 29.08           C  
ATOM   1685  CG2 VAL C  33       0.892  -1.185   0.025  1.00 29.08           C  
ATOM   1686  N   ALA C  34       4.596  -3.968   0.208  1.00 45.76           N  
ATOM   1687  CA  ALA C  34       5.283  -5.254   0.231  1.00 45.76           C  
ATOM   1688  C   ALA C  34       4.810  -6.016   1.464  1.00 45.76           C  
ATOM   1689  O   ALA C  34       5.109  -5.639   2.595  1.00 45.76           O  
ATOM   1690  CB  ALA C  34       6.783  -5.050   0.282  1.00 97.04           C  
ATOM   1691  N   SER C  35       4.058  -7.086   1.242  1.00 54.11           N  
ATOM   1692  CA  SER C  35       3.531  -7.884   2.339  1.00 54.11           C  
ATOM   1693  C   SER C  35       4.461  -9.057   2.656  1.00 54.11           C  
ATOM   1694  O   SER C  35       4.833  -9.826   1.763  1.00 54.11           O  
ATOM   1695  CB  SER C  35       2.133  -8.390   1.975  1.00 55.20           C  
ATOM   1696  OG  SER C  35       1.537  -9.110   3.039  1.00 55.20           O  
ATOM   1697  N   THR C  36       4.827  -9.174   3.936  1.00101.61           N  
ATOM   1698  CA  THR C  36       5.719 -10.223   4.456  1.00101.61           C  
ATOM   1699  C   THR C  36       6.945 -10.503   3.590  1.00101.61           C  
ATOM   1700  O   THR C  36       7.236  -9.687   2.693  1.00101.61           O  
ATOM   1701  CB  THR C  36       4.968 -11.566   4.695  1.00 86.42           C  
ATOM   1702  OG1 THR C  36       4.343 -11.997   3.477  1.00 86.42           O  
ATOM   1703  CG2 THR C  36       3.911 -11.405   5.783  1.00 86.42           C  
ATOM   1704  N   GLU C  51       5.675 -16.305   0.324  1.00100.27           N  
ATOM   1705  CA  GLU C  51       6.125 -15.093   1.068  1.00100.27           C  
ATOM   1706  C   GLU C  51       6.347 -13.909   0.122  1.00100.27           C  
ATOM   1707  O   GLU C  51       6.555 -14.094  -1.080  1.00100.27           O  
ATOM   1708  CB  GLU C  51       7.411 -15.406   1.828  1.00 91.20           C  
ATOM   1709  N   ALA C  52       6.291 -12.698   0.673  1.00101.61           N  
ATOM   1710  CA  ALA C  52       6.489 -11.462  -0.092  1.00101.61           C  
ATOM   1711  C   ALA C  52       5.534 -11.271  -1.274  1.00101.61           C  
ATOM   1712  O   ALA C  52       5.799 -11.741  -2.378  1.00101.61           O  
ATOM   1713  CB  ALA C  52       7.940 -11.378  -0.581  1.00 39.00           C  
ATOM   1714  N   LEU C  53       4.429 -10.569  -1.037  1.00 55.61           N  
ATOM   1715  CA  LEU C  53       3.439 -10.295  -2.077  1.00 55.61           C  
ATOM   1716  C   LEU C  53       3.641  -8.824  -2.425  1.00 55.61           C  
ATOM   1717  O   LEU C  53       3.895  -8.017  -1.540  1.00 55.61           O  
ATOM   1718  CB  LEU C  53       2.031 -10.518  -1.521  1.00 34.58           C  
ATOM   1719  CG  LEU C  53       0.806 -10.636  -2.434  1.00 34.58           C  
ATOM   1720  CD1 LEU C  53      -0.384 -10.074  -1.651  1.00 34.58           C  
ATOM   1721  CD2 LEU C  53       0.974  -9.865  -3.737  1.00 34.58           C  
ATOM   1722  N   PHE C  54       3.540  -8.466  -3.700  1.00 49.08           N  
ATOM   1723  CA  PHE C  54       3.732  -7.071  -4.096  1.00 49.08           C  
ATOM   1724  C   PHE C  54       2.548  -6.475  -4.840  1.00 49.08           C  
ATOM   1725  O   PHE C  54       2.410  -6.666  -6.046  1.00 49.08           O  
ATOM   1726  CB  PHE C  54       4.965  -6.917  -4.989  1.00101.34           C  
ATOM   1727  CG  PHE C  54       6.243  -7.344  -4.346  1.00101.34           C  
ATOM   1728  CD1 PHE C  54       6.530  -8.696  -4.168  1.00101.34           C  
ATOM   1729  CD2 PHE C  54       7.173  -6.400  -3.933  1.00101.34           C  
ATOM   1730  CE1 PHE C  54       7.729  -9.104  -3.588  1.00101.34           C  
ATOM   1731  CE2 PHE C  54       8.373  -6.794  -3.354  1.00101.34           C  
ATOM   1732  CZ  PHE C  54       8.653  -8.151  -3.182  1.00101.34           C  
ATOM   1733  N   LEU C  55       1.707  -5.733  -4.135  1.00 71.07           N  
ATOM   1734  CA  LEU C  55       0.555  -5.105  -4.769  1.00 71.07           C  
ATOM   1735  C   LEU C  55       0.798  -3.613  -4.988  1.00 71.07           C  
ATOM   1736  O   LEU C  55       1.134  -2.877  -4.054  1.00 71.07           O  
ATOM   1737  CB  LEU C  55      -0.693  -5.287  -3.908  1.00 54.96           C  
ATOM   1738  CG  LEU C  55      -1.015  -6.724  -3.500  1.00 54.96           C  
ATOM   1739  CD1 LEU C  55      -2.217  -6.743  -2.557  1.00 54.96           C  
ATOM   1740  CD2 LEU C  55      -1.285  -7.562  -4.740  1.00 54.96           C  
ATOM   1741  N   ARG C  56       0.639  -3.167  -6.228  1.00 51.79           N  
ATOM   1742  CA  ARG C  56       0.823  -1.761  -6.541  1.00 51.79           C  
ATOM   1743  C   ARG C  56      -0.531  -1.095  -6.283  1.00 51.79           C  
ATOM   1744  O   ARG C  56      -1.561  -1.580  -6.747  1.00 51.79           O  
ATOM   1745  CB  ARG C  56       1.276  -1.597  -8.002  1.00101.61           C  
ATOM   1746  CG  ARG C  56       1.240  -2.885  -8.860  1.00101.61           C  
ATOM   1747  CD  ARG C  56       2.253  -3.975  -8.437  1.00101.61           C  
ATOM   1748  NE  ARG C  56       3.658  -3.575  -8.582  1.00101.61           N  
ATOM   1749  CZ  ARG C  56       4.704  -4.387  -8.400  1.00101.61           C  
ATOM   1750  NH1 ARG C  56       4.522  -5.658  -8.067  1.00101.61           N  
ATOM   1751  NH2 ARG C  56       5.943  -3.929  -8.541  1.00101.61           N  
ATOM   1752  N   CYS C  57      -0.530  -0.004  -5.521  1.00 44.86           N  
ATOM   1753  CA  CYS C  57      -1.762   0.715  -5.165  1.00 44.86           C  
ATOM   1754  C   CYS C  57      -1.936   2.099  -5.797  1.00 44.86           C  
ATOM   1755  O   CYS C  57      -0.975   2.733  -6.240  1.00 44.86           O  
ATOM   1756  CB  CYS C  57      -1.840   0.894  -3.655  1.00 42.89           C  
ATOM   1757  SG  CYS C  57      -1.857  -0.617  -2.737  1.00 42.89           S  
ATOM   1758  N   ASN C  58      -3.174   2.579  -5.794  1.00 61.68           N  
ATOM   1759  CA  ASN C  58      -3.489   3.886  -6.349  1.00 61.68           C  
ATOM   1760  C   ASN C  58      -4.511   4.560  -5.464  1.00 61.68           C  
ATOM   1761  O   ASN C  58      -5.492   3.935  -5.056  1.00 61.68           O  
ATOM   1762  CB  ASN C  58      -4.087   3.736  -7.739  1.00 57.53           C  
ATOM   1763  CG  ASN C  58      -3.378   2.706  -8.551  1.00 57.53           C  
ATOM   1764  OD1 ASN C  58      -2.245   2.918  -8.981  1.00 57.53           O  
ATOM   1765  ND2 ASN C  58      -4.027   1.562  -8.755  1.00 57.53           N  
ATOM   1766  N   ILE C  59      -4.280   5.828  -5.155  1.00 48.37           N  
ATOM   1767  CA  ILE C  59      -5.235   6.576  -4.354  1.00 48.37           C  
ATOM   1768  C   ILE C  59      -5.328   7.998  -4.904  1.00 48.37           C  
ATOM   1769  O   ILE C  59      -4.351   8.747  -4.923  1.00 48.37           O  
ATOM   1770  CB  ILE C  59      -4.859   6.563  -2.859  1.00 18.61           C  
ATOM   1771  CG1 ILE C  59      -6.044   7.102  -2.035  1.00 18.61           C  
ATOM   1772  CG2 ILE C  59      -3.531   7.291  -2.643  1.00 18.61           C  
ATOM   1773  CD1 ILE C  59      -5.942   6.879  -0.534  1.00 18.61           C  
ATOM   1774  N   TRP C  60      -6.521   8.333  -5.382  1.00 66.36           N  
ATOM   1775  CA  TRP C  60      -6.809   9.618  -6.000  1.00 66.36           C  
ATOM   1776  C   TRP C  60      -7.131  10.766  -5.044  1.00 66.36           C  
ATOM   1777  O   TRP C  60      -7.075  10.615  -3.820  1.00 66.36           O  
ATOM   1778  CB  TRP C  60      -7.966   9.432  -6.996  1.00 70.34           C  
ATOM   1779  CG  TRP C  60      -7.526   9.251  -8.421  1.00 70.34           C  
ATOM   1780  CD1 TRP C  60      -7.403  10.226  -9.367  1.00 70.34           C  
ATOM   1781  CD2 TRP C  60      -7.057   8.041  -9.031  1.00 70.34           C  
ATOM   1782  NE1 TRP C  60      -6.878   9.704 -10.524  1.00 70.34           N  
ATOM   1783  CE2 TRP C  60      -6.654   8.370 -10.345  1.00 70.34           C  
ATOM   1784  CE3 TRP C  60      -6.932   6.720  -8.592  1.00 70.34           C  
ATOM   1785  CZ2 TRP C  60      -6.133   7.415 -11.229  1.00 70.34           C  
ATOM   1786  CZ3 TRP C  60      -6.410   5.768  -9.475  1.00 70.34           C  
ATOM   1787  CH2 TRP C  60      -6.016   6.126 -10.778  1.00 70.34           C  
ATOM   1788  N   ARG C  61      -7.453  11.915  -5.639  1.00 53.77           N  
ATOM   1789  CA  ARG C  61      -7.818  13.135  -4.930  1.00 53.77           C  
ATOM   1790  C   ARG C  61      -6.859  13.544  -3.812  1.00 53.77           C  
ATOM   1791  O   ARG C  61      -5.692  13.136  -3.798  1.00 53.77           O  
ATOM   1792  CB  ARG C  61      -9.237  13.001  -4.384  1.00 57.15           C  
ATOM   1793  N   GLU C  62      -7.369  14.359  -2.886  1.00 57.98           N  
ATOM   1794  CA  GLU C  62      -6.604  14.868  -1.745  1.00 57.98           C  
ATOM   1795  C   GLU C  62      -5.877  13.770  -0.967  1.00 57.98           C  
ATOM   1796  O   GLU C  62      -4.735  13.956  -0.546  1.00 57.98           O  
ATOM   1797  CB  GLU C  62      -7.528  15.636  -0.816  1.00 76.21           C  
ATOM   1798  N   ALA C  63      -6.545  12.633  -0.778  1.00 85.65           N  
ATOM   1799  CA  ALA C  63      -5.962  11.503  -0.063  1.00 85.65           C  
ATOM   1800  C   ALA C  63      -4.543  11.272  -0.560  1.00 85.65           C  
ATOM   1801  O   ALA C  63      -3.676  10.823   0.188  1.00 85.65           O  
ATOM   1802  CB  ALA C  63      -6.800  10.263  -0.291  1.00101.61           C  
ATOM   1803  N   ALA C  64      -4.317  11.579  -1.834  1.00 99.42           N  
ATOM   1804  CA  ALA C  64      -3.003  11.423  -2.434  1.00 99.42           C  
ATOM   1805  C   ALA C  64      -2.061  12.450  -1.817  1.00 99.42           C  
ATOM   1806  O   ALA C  64      -0.922  12.127  -1.464  1.00 99.42           O  
ATOM   1807  CB  ALA C  64      -3.088  11.620  -3.935  1.00 93.64           C  
ATOM   1808  N   GLU C  65      -2.533  13.691  -1.694  1.00 97.84           N  
ATOM   1809  CA  GLU C  65      -1.717  14.738  -1.089  1.00 97.84           C  
ATOM   1810  C   GLU C  65      -1.205  14.176   0.237  1.00 97.84           C  
ATOM   1811  O   GLU C  65      -0.001  14.115   0.477  1.00 97.84           O  
ATOM   1812  CB  GLU C  65      -2.541  16.030  -0.848  1.00 99.81           C  
ATOM   1813  CG  GLU C  65      -2.600  17.012  -2.045  1.00 99.81           C  
ATOM   1814  CD  GLU C  65      -3.349  18.332  -1.756  1.00 99.81           C  
ATOM   1815  OE1 GLU C  65      -2.992  19.042  -0.787  1.00 99.81           O  
ATOM   1816  OE2 GLU C  65      -4.288  18.670  -2.515  1.00 99.81           O  
ATOM   1817  N   ASN C  66      -2.137  13.720   1.071  1.00 53.46           N  
ATOM   1818  CA  ASN C  66      -1.820  13.161   2.386  1.00 53.46           C  
ATOM   1819  C   ASN C  66      -0.921  11.923   2.365  1.00 53.46           C  
ATOM   1820  O   ASN C  66      -0.033  11.793   3.204  1.00 53.46           O  
ATOM   1821  CB  ASN C  66      -3.117  12.840   3.135  1.00 51.97           C  
ATOM   1822  CG  ASN C  66      -4.074  14.018   3.167  1.00 51.97           C  
ATOM   1823  OD1 ASN C  66      -3.759  15.072   3.709  1.00 51.97           O  
ATOM   1824  ND2 ASN C  66      -5.245  13.845   2.575  1.00 51.97           N  
ATOM   1825  N   VAL C  67      -1.152  11.012   1.423  1.00 55.12           N  
ATOM   1826  CA  VAL C  67      -0.332   9.805   1.340  1.00 55.12           C  
ATOM   1827  C   VAL C  67       1.126  10.173   1.155  1.00 55.12           C  
ATOM   1828  O   VAL C  67       2.010   9.555   1.725  1.00 55.12           O  
ATOM   1829  CB  VAL C  67      -0.788   8.877   0.198  1.00 52.86           C  
ATOM   1830  CG1 VAL C  67       0.266   7.808  -0.058  1.00 52.86           C  
ATOM   1831  CG2 VAL C  67      -2.116   8.213   0.569  1.00 52.86           C  
ATOM   1832  N   ALA C  68       1.367  11.192   0.327  1.00 89.04           N  
ATOM   1833  CA  ALA C  68       2.716  11.689   0.132  1.00 89.04           C  
ATOM   1834  C   ALA C  68       2.894  12.972   0.845  1.00 89.04           C  
ATOM   1835  O   ALA C  68       2.617  14.047   0.292  1.00 89.04           O  
ATOM   1836  CB  ALA C  68       3.026  11.803  -1.345  1.00 66.84           C  
ATOM   1837  N   GLU C  69       3.244  12.837   2.140  1.00 79.66           N  
ATOM   1838  CA  GLU C  69       3.698  13.821   3.126  1.00 79.66           C  
ATOM   1839  C   GLU C  69       3.472  13.232   4.418  1.00 79.66           C  
ATOM   1840  O   GLU C  69       3.370  13.900   5.443  1.00 79.66           O  
ATOM   1841  CB  GLU C  69       3.187  15.340   2.946  1.00 51.60           C  
ATOM   1842  N   SER C  70       3.349  11.916   4.378  1.00 49.28           N  
ATOM   1843  CA  SER C  70       3.178  11.142   5.596  1.00 49.28           C  
ATOM   1844  C   SER C  70       4.027   9.897   5.469  1.00 49.28           C  
ATOM   1845  O   SER C  70       5.008   9.693   6.203  1.00 49.28           O  
ATOM   1846  CB  SER C  70       1.721  10.724   5.775  1.00 18.34           C  
ATOM   1847  OG  SER C  70       0.885  11.852   5.923  1.00 18.34           O  
ATOM   1848  N   LEU C  71       3.644   9.082   4.494  1.00 53.70           N  
ATOM   1849  CA  LEU C  71       4.329   7.833   4.213  1.00 53.70           C  
ATOM   1850  C   LEU C  71       5.641   8.008   3.438  1.00 53.70           C  
ATOM   1851  O   LEU C  71       5.814   8.962   2.664  1.00 53.70           O  
ATOM   1852  CB  LEU C  71       3.398   6.898   3.436  1.00 61.24           C  
ATOM   1853  CG  LEU C  71       1.969   6.719   3.965  1.00 61.24           C  
ATOM   1854  CD1 LEU C  71       1.347   5.465   3.350  1.00 61.24           C  
ATOM   1855  CD2 LEU C  71       1.991   6.598   5.472  1.00 61.24           C  
ATOM   1856  N   THR C  72       6.560   7.067   3.662  1.00 58.69           N  
ATOM   1857  CA  THR C  72       7.868   7.058   3.015  1.00 58.69           C  
ATOM   1858  C   THR C  72       8.263   5.600   2.816  1.00 58.69           C  
ATOM   1859  O   THR C  72       7.619   4.708   3.362  1.00 58.69           O  
ATOM   1860  CB  THR C  72       8.911   7.768   3.892  1.00 54.21           C  
ATOM   1861  OG1 THR C  72       8.801   7.297   5.244  1.00 54.21           O  
ATOM   1862  CG2 THR C  72       8.678   9.266   3.869  1.00 54.21           C  
ATOM   1863  N   ARG C  73       9.314   5.350   2.045  1.00 42.92           N  
ATOM   1864  CA  ARG C  73       9.728   3.977   1.790  1.00 42.92           C  
ATOM   1865  C   ARG C  73       9.989   3.209   3.071  1.00 42.92           C  
ATOM   1866  O   ARG C  73      10.614   3.735   3.995  1.00 42.92           O  
ATOM   1867  CB  ARG C  73      10.990   3.932   0.937  1.00 66.24           C  
ATOM   1868  CG  ARG C  73      12.271   4.200   1.701  1.00 66.24           C  
ATOM   1869  CD  ARG C  73      13.446   3.531   1.022  1.00 66.24           C  
ATOM   1870  NE  ARG C  73      13.292   2.078   1.007  1.00 66.24           N  
ATOM   1871  CZ  ARG C  73      14.284   1.227   0.768  1.00 66.24           C  
ATOM   1872  NH1 ARG C  73      14.058  -0.082   0.774  1.00 66.24           N  
ATOM   1873  NH2 ARG C  73      15.504   1.687   0.531  1.00 66.24           N  
ATOM   1874  N   GLY C  74       9.521   1.959   3.109  1.00 53.72           N  
ATOM   1875  CA  GLY C  74       9.704   1.108   4.274  1.00 53.72           C  
ATOM   1876  C   GLY C  74       8.644   1.296   5.349  1.00 53.72           C  
ATOM   1877  O   GLY C  74       8.700   0.667   6.409  1.00 53.72           O  
ATOM   1878  N   ALA C  75       7.667   2.154   5.082  1.00 44.90           N  
ATOM   1879  CA  ALA C  75       6.613   2.420   6.047  1.00 44.90           C  
ATOM   1880  C   ALA C  75       5.550   1.339   6.067  1.00 44.90           C  
ATOM   1881  O   ALA C  75       5.012   0.975   5.023  1.00 44.90           O  
ATOM   1882  CB  ALA C  75       5.971   3.748   5.751  1.00  2.61           C  
ATOM   1883  N   ARG C  76       5.248   0.831   7.261  1.00 37.73           N  
ATOM   1884  CA  ARG C  76       4.218  -0.188   7.426  1.00 37.73           C  
ATOM   1885  C   ARG C  76       2.872   0.537   7.460  1.00 37.73           C  
ATOM   1886  O   ARG C  76       2.628   1.403   8.313  1.00 37.73           O  
ATOM   1887  CB  ARG C  76       4.429  -0.966   8.721  1.00 34.12           C  
ATOM   1888  CG  ARG C  76       3.328  -1.953   9.010  1.00 34.12           C  
ATOM   1889  CD  ARG C  76       3.487  -2.493  10.406  1.00 34.12           C  
ATOM   1890  NE  ARG C  76       3.867  -3.901  10.399  1.00 34.12           N  
ATOM   1891  CZ  ARG C  76       2.995  -4.913  10.436  1.00 34.12           C  
ATOM   1892  NH1 ARG C  76       1.690  -4.667  10.487  1.00 34.12           N  
ATOM   1893  NH2 ARG C  76       3.418  -6.177  10.420  1.00 34.12           N  
ATOM   1894  N   VAL C  77       2.008   0.161   6.522  1.00 26.81           N  
ATOM   1895  CA  VAL C  77       0.700   0.769   6.364  1.00 26.81           C  
ATOM   1896  C   VAL C  77      -0.455  -0.246   6.360  1.00 26.81           C  
ATOM   1897  O   VAL C  77      -0.242  -1.464   6.309  1.00 26.81           O  
ATOM   1898  CB  VAL C  77       0.656   1.523   5.024  1.00 25.40           C  
ATOM   1899  CG1 VAL C  77       1.603   2.697   5.036  1.00 25.40           C  
ATOM   1900  CG2 VAL C  77       1.042   0.567   3.908  1.00 25.40           C  
ATOM   1901  N   ILE C  78      -1.681   0.268   6.420  1.00 31.42           N  
ATOM   1902  CA  ILE C  78      -2.865  -0.577   6.343  1.00 31.42           C  
ATOM   1903  C   ILE C  78      -3.663  -0.019   5.192  1.00 31.42           C  
ATOM   1904  O   ILE C  78      -4.052   1.138   5.183  1.00 31.42           O  
ATOM   1905  CB  ILE C  78      -3.714  -0.537   7.610  1.00 31.98           C  
ATOM   1906  CG1 ILE C  78      -2.912  -1.105   8.765  1.00 31.98           C  
ATOM   1907  CG2 ILE C  78      -4.949  -1.401   7.445  1.00 31.98           C  
ATOM   1908  CD1 ILE C  78      -3.748  -1.429   9.959  1.00 31.98           C  
ATOM   1909  N   VAL C  79      -3.886  -0.847   4.196  1.00 21.86           N  
ATOM   1910  CA  VAL C  79      -4.620  -0.404   3.041  1.00 21.86           C  
ATOM   1911  C   VAL C  79      -5.919  -1.172   2.958  1.00 21.86           C  
ATOM   1912  O   VAL C  79      -5.990  -2.352   3.332  1.00 21.86           O  
ATOM   1913  CB  VAL C  79      -3.835  -0.671   1.751  1.00 19.13           C  
ATOM   1914  CG1 VAL C  79      -4.507   0.023   0.587  1.00 19.13           C  
ATOM   1915  CG2 VAL C  79      -2.393  -0.207   1.909  1.00 19.13           C  
ATOM   1916  N   SER C  80      -6.955  -0.493   2.481  1.00 52.61           N  
ATOM   1917  CA  SER C  80      -8.259  -1.108   2.306  1.00 52.61           C  
ATOM   1918  C   SER C  80      -8.720  -0.632   0.936  1.00 52.61           C  
ATOM   1919  O   SER C  80      -8.729   0.577   0.671  1.00 52.61           O  
ATOM   1920  CB  SER C  80      -9.229  -0.635   3.387  1.00 68.75           C  
ATOM   1921  OG  SER C  80     -10.403  -1.419   3.363  1.00 68.75           O  
ATOM   1922  N   GLY C  81      -9.075  -1.575   0.061  1.00 28.01           N  
ATOM   1923  CA  GLY C  81      -9.515  -1.196  -1.265  1.00 28.01           C  
ATOM   1924  C   GLY C  81      -9.948  -2.325  -2.169  1.00 28.01           C  
ATOM   1925  O   GLY C  81      -9.798  -3.493  -1.836  1.00 28.01           O  
ATOM   1926  N   ARG C  82     -10.469  -1.951  -3.334  1.00 52.84           N  
ATOM   1927  CA  ARG C  82     -10.970  -2.886  -4.343  1.00 52.84           C  
ATOM   1928  C   ARG C  82      -9.868  -3.352  -5.278  1.00 52.84           C  
ATOM   1929  O   ARG C  82      -9.026  -2.551  -5.680  1.00 52.84           O  
ATOM   1930  CB  ARG C  82     -12.051  -2.202  -5.188  1.00 96.47           C  
ATOM   1931  CG  ARG C  82     -13.171  -1.542  -4.401  1.00 96.47           C  
ATOM   1932  CD  ARG C  82     -13.811  -0.418  -5.215  1.00 96.47           C  
ATOM   1933  NE  ARG C  82     -13.022   0.818  -5.163  1.00 96.47           N  
ATOM   1934  CZ  ARG C  82     -12.951   1.714  -6.146  1.00 96.47           C  
ATOM   1935  NH1 ARG C  82     -13.619   1.510  -7.276  1.00 96.47           N  
ATOM   1936  NH2 ARG C  82     -12.220   2.816  -5.998  1.00 96.47           N  
ATOM   1937  N   LEU C  83      -9.866  -4.638  -5.623  1.00 25.43           N  
ATOM   1938  CA  LEU C  83      -8.875  -5.154  -6.558  1.00 25.43           C  
ATOM   1939  C   LEU C  83      -9.308  -4.617  -7.924  1.00 25.43           C  
ATOM   1940  O   LEU C  83     -10.440  -4.863  -8.360  1.00 25.43           O  
ATOM   1941  CB  LEU C  83      -8.871  -6.685  -6.554  1.00 32.56           C  
ATOM   1942  CG  LEU C  83      -8.159  -7.351  -5.385  1.00 32.56           C  
ATOM   1943  CD1 LEU C  83      -8.210  -8.827  -5.557  1.00 32.56           C  
ATOM   1944  CD2 LEU C  83      -6.720  -6.911  -5.324  1.00 32.56           C  
ATOM   1945  N   LYS C  84      -8.414  -3.897  -8.603  1.00 16.21           N  
ATOM   1946  CA  LYS C  84      -8.757  -3.289  -9.880  1.00 16.21           C  
ATOM   1947  C   LYS C  84      -8.266  -3.895 -11.179  1.00 16.21           C  
ATOM   1948  O   LYS C  84      -7.495  -4.854 -11.209  1.00 16.21           O  
ATOM   1949  CB  LYS C  84      -8.370  -1.809  -9.855  1.00 60.68           C  
ATOM   1950  CG  LYS C  84      -9.494  -0.889  -9.447  1.00 60.68           C  
ATOM   1951  CD  LYS C  84     -10.526  -0.758 -10.562  1.00 60.68           C  
ATOM   1952  CE  LYS C  84     -11.644   0.217 -10.180  1.00 60.68           C  
ATOM   1953  NZ  LYS C  84     -12.653   0.444 -11.269  1.00 60.68           N  
ATOM   1954  N   GLN C  85      -8.736  -3.267 -12.254  1.00101.61           N  
ATOM   1955  CA  GLN C  85      -8.445  -3.640 -13.626  1.00101.61           C  
ATOM   1956  C   GLN C  85      -9.043  -5.002 -13.897  1.00101.61           C  
ATOM   1957  O   GLN C  85     -10.136  -5.037 -14.505  1.00101.61           O  
ATOM   1958  CB  GLN C  85      -6.936  -3.671 -13.872  1.00 69.00           C  
ATOM   1959  CG  GLN C  85      -6.492  -2.770 -15.016  1.00 69.00           C  
ATOM   1960  CD  GLN C  85      -4.993  -2.803 -15.237  1.00 69.00           C  
ATOM   1961  OE1 GLN C  85      -4.415  -3.858 -15.522  1.00 69.00           O  
ATOM   1962  NE2 GLN C  85      -4.350  -1.646 -15.102  1.00 69.00           N  
ATOM   1963  N   ARG C  91       6.086  -4.960 -28.515  1.00 85.36           N  
ATOM   1964  CA  ARG C  91       5.651  -3.562 -28.220  1.00 85.36           C  
ATOM   1965  C   ARG C  91       5.917  -3.233 -26.749  1.00 85.36           C  
ATOM   1966  O   ARG C  91       5.556  -2.165 -26.247  1.00 85.36           O  
ATOM   1967  CB  ARG C  91       4.158  -3.400 -28.556  1.00101.16           C  
ATOM   1968  CG  ARG C  91       3.250  -4.521 -28.039  1.00101.16           C  
ATOM   1969  CD  ARG C  91       1.787  -4.223 -28.361  1.00101.16           C  
ATOM   1970  NE  ARG C  91       0.874  -5.242 -27.853  1.00101.16           N  
ATOM   1971  CZ  ARG C  91       0.715  -6.445 -28.392  1.00101.16           C  
ATOM   1972  NH1 ARG C  91       1.409  -6.787 -29.465  1.00101.16           N  
ATOM   1973  NH2 ARG C  91      -0.138  -7.308 -27.859  1.00101.16           N  
ATOM   1974  N   GLU C  92       6.570  -4.172 -26.074  1.00101.61           N  
ATOM   1975  CA  GLU C  92       6.910  -4.051 -24.665  1.00101.61           C  
ATOM   1976  C   GLU C  92       5.723  -3.687 -23.786  1.00101.61           C  
ATOM   1977  O   GLU C  92       5.887  -3.398 -22.605  1.00101.61           O  
ATOM   1978  CB  GLU C  92       8.049  -3.049 -24.469  1.00100.79           C  
ATOM   1979  CG  GLU C  92       9.260  -3.641 -23.732  1.00100.79           C  
ATOM   1980  CD  GLU C  92       9.809  -4.900 -24.396  1.00100.79           C  
ATOM   1981  OE1 GLU C  92      10.256  -4.830 -25.562  1.00100.79           O  
ATOM   1982  OE2 GLU C  92       9.794  -5.965 -23.748  1.00100.79           O  
ATOM   1983  N   GLY C  93       4.528  -3.688 -24.368  1.00 95.53           N  
ATOM   1984  CA  GLY C  93       3.350  -3.414 -23.573  1.00 95.53           C  
ATOM   1985  C   GLY C  93       2.442  -2.224 -23.792  1.00 95.53           C  
ATOM   1986  O   GLY C  93       2.851  -1.127 -24.162  1.00 95.53           O  
ATOM   1987  N   GLU C  94       1.170  -2.498 -23.533  1.00 87.04           N  
ATOM   1988  CA  GLU C  94       0.067  -1.549 -23.595  1.00 87.04           C  
ATOM   1989  C   GLU C  94      -0.631  -1.965 -22.310  1.00 87.04           C  
ATOM   1990  O   GLU C  94      -0.794  -1.190 -21.373  1.00 87.04           O  
ATOM   1991  CB  GLU C  94      -0.857  -1.850 -24.775  1.00101.61           C  
ATOM   1992  CG  GLU C  94      -0.161  -2.086 -26.102  1.00101.61           C  
ATOM   1993  CD  GLU C  94      -1.148  -2.313 -27.234  1.00101.61           C  
ATOM   1994  OE1 GLU C  94      -2.013  -1.437 -27.447  1.00101.61           O  
ATOM   1995  OE2 GLU C  94      -1.062  -3.359 -27.913  1.00101.61           O  
ATOM   1996  N   LYS C  95      -1.015  -3.236 -22.308  1.00 98.58           N  
ATOM   1997  CA  LYS C  95      -1.666  -3.928 -21.200  1.00 98.58           C  
ATOM   1998  C   LYS C  95      -2.645  -3.253 -20.247  1.00 98.58           C  
ATOM   1999  O   LYS C  95      -2.862  -2.040 -20.246  1.00 98.58           O  
ATOM   2000  CB  LYS C  95      -0.604  -4.624 -20.342  1.00 87.02           C  
ATOM   2001  CG  LYS C  95      -0.325  -6.082 -20.689  1.00 87.02           C  
ATOM   2002  CD  LYS C  95       0.706  -6.616 -19.720  1.00 87.02           C  
ATOM   2003  CE  LYS C  95       1.086  -8.038 -20.012  1.00 87.02           C  
ATOM   2004  NZ  LYS C  95       2.206  -8.453 -19.121  1.00 87.02           N  
ATOM   2005  N   ARG C  96      -3.215  -4.126 -19.424  1.00101.61           N  
ATOM   2006  CA  ARG C  96      -4.189  -3.838 -18.386  1.00101.61           C  
ATOM   2007  C   ARG C  96      -4.503  -5.242 -17.847  1.00101.61           C  
ATOM   2008  O   ARG C  96      -5.643  -5.562 -17.513  1.00101.61           O  
ATOM   2009  CB  ARG C  96      -5.437  -3.188 -18.983  1.00 57.07           C  
ATOM   2010  N   THR C  97      -3.464  -6.076 -17.790  1.00 99.06           N  
ATOM   2011  CA  THR C  97      -3.569  -7.454 -17.319  1.00 99.06           C  
ATOM   2012  C   THR C  97      -2.871  -7.619 -15.981  1.00 99.06           C  
ATOM   2013  O   THR C  97      -2.278  -8.662 -15.701  1.00 99.06           O  
ATOM   2014  CB  THR C  97      -2.919  -8.442 -18.307  1.00101.61           C  
ATOM   2015  OG1 THR C  97      -1.501  -8.231 -18.334  1.00101.61           O  
ATOM   2016  CG2 THR C  97      -3.487  -8.248 -19.706  1.00101.61           C  
ATOM   2017  N   VAL C  98      -2.917  -6.577 -15.167  1.00 40.92           N  
ATOM   2018  CA  VAL C  98      -2.310  -6.646 -13.855  1.00 40.92           C  
ATOM   2019  C   VAL C  98      -3.340  -6.381 -12.773  1.00 40.92           C  
ATOM   2020  O   VAL C  98      -4.425  -5.852 -13.032  1.00 40.92           O  
ATOM   2021  CB  VAL C  98      -1.166  -5.643 -13.699  1.00 43.04           C  
ATOM   2022  CG1 VAL C  98       0.035  -6.122 -14.479  1.00 43.04           C  
ATOM   2023  CG2 VAL C  98      -1.599  -4.273 -14.172  1.00 43.04           C  
ATOM   2024  N   ILE C  99      -3.002  -6.774 -11.556  1.00 44.22           N  
ATOM   2025  CA  ILE C  99      -3.886  -6.566 -10.434  1.00 44.22           C  
ATOM   2026  C   ILE C  99      -3.300  -5.537  -9.465  1.00 44.22           C  
ATOM   2027  O   ILE C  99      -2.203  -5.709  -8.914  1.00 44.22           O  
ATOM   2028  CB  ILE C  99      -4.169  -7.898  -9.748  1.00 46.98           C  
ATOM   2029  CG1 ILE C  99      -5.155  -8.672 -10.615  1.00 46.98           C  
ATOM   2030  CG2 ILE C  99      -4.716  -7.689  -8.345  1.00 46.98           C  
ATOM   2031  CD1 ILE C  99      -5.366 -10.076 -10.161  1.00 46.98           C  
ATOM   2032  N   GLU C 100      -4.040  -4.444  -9.295  1.00 41.03           N  
ATOM   2033  CA  GLU C 100      -3.630  -3.367  -8.406  1.00 41.03           C  
ATOM   2034  C   GLU C 100      -4.730  -3.152  -7.363  1.00 41.03           C  
ATOM   2035  O   GLU C 100      -5.782  -3.788  -7.424  1.00 41.03           O  
ATOM   2036  CB  GLU C 100      -3.397  -2.095  -9.223  1.00100.28           C  
ATOM   2037  CG  GLU C 100      -2.661  -2.346 -10.538  1.00100.28           C  
ATOM   2038  CD  GLU C 100      -2.201  -1.065 -11.214  1.00100.28           C  
ATOM   2039  OE1 GLU C 100      -3.023  -0.138 -11.354  1.00100.28           O  
ATOM   2040  OE2 GLU C 100      -1.017  -0.987 -11.611  1.00100.28           O  
ATOM   2041  N   VAL C 101      -4.483  -2.259  -6.414  1.00 47.25           N  
ATOM   2042  CA  VAL C 101      -5.440  -1.980  -5.360  1.00 47.25           C  
ATOM   2043  C   VAL C 101      -5.882  -0.543  -5.427  1.00 47.25           C  
ATOM   2044  O   VAL C 101      -5.060   0.359  -5.347  1.00 47.25           O  
ATOM   2045  CB  VAL C 101      -4.819  -2.220  -3.972  1.00 13.54           C  
ATOM   2046  CG1 VAL C 101      -5.833  -1.944  -2.889  1.00 13.54           C  
ATOM   2047  CG2 VAL C 101      -4.314  -3.652  -3.872  1.00 13.54           C  
ATOM   2048  N   GLU C 102      -7.182  -0.336  -5.573  1.00 45.45           N  
ATOM   2049  CA  GLU C 102      -7.747   1.006  -5.632  1.00 45.45           C  
ATOM   2050  C   GLU C 102      -7.976   1.476  -4.192  1.00 45.45           C  
ATOM   2051  O   GLU C 102      -9.116   1.527  -3.729  1.00 45.45           O  
ATOM   2052  CB  GLU C 102      -9.077   0.986  -6.391  1.00 88.54           C  
ATOM   2053  CG  GLU C 102      -9.602   2.355  -6.811  1.00 88.54           C  
ATOM   2054  CD  GLU C 102      -8.792   2.986  -7.935  1.00 88.54           C  
ATOM   2055  OE1 GLU C 102      -8.605   2.339  -8.990  1.00 88.54           O  
ATOM   2056  OE2 GLU C 102      -8.346   4.137  -7.766  1.00 88.54           O  
ATOM   2057  N   VAL C 103      -6.883   1.827  -3.509  1.00 20.33           N  
ATOM   2058  CA  VAL C 103      -6.889   2.266  -2.111  1.00 20.33           C  
ATOM   2059  C   VAL C 103      -7.980   3.232  -1.674  1.00 20.33           C  
ATOM   2060  O   VAL C 103      -8.057   4.345  -2.193  1.00 20.33           O  
ATOM   2061  CB  VAL C 103      -5.570   2.932  -1.748  1.00 25.78           C  
ATOM   2062  CG1 VAL C 103      -5.516   3.186  -0.257  1.00 25.78           C  
ATOM   2063  CG2 VAL C 103      -4.432   2.079  -2.189  1.00 25.78           C  
ATOM   2064  N   ASP C 104      -8.798   2.829  -0.698  1.00 61.95           N  
ATOM   2065  CA  ASP C 104      -9.864   3.690  -0.170  1.00 61.95           C  
ATOM   2066  C   ASP C 104      -9.336   4.418   1.056  1.00 61.95           C  
ATOM   2067  O   ASP C 104      -9.323   5.652   1.116  1.00 61.95           O  
ATOM   2068  CB  ASP C 104     -11.074   2.861   0.251  1.00101.61           C  
ATOM   2069  CG  ASP C 104     -11.801   2.265  -0.919  1.00101.61           C  
ATOM   2070  OD1 ASP C 104     -12.708   1.439  -0.694  1.00101.61           O  
ATOM   2071  OD2 ASP C 104     -11.465   2.627  -2.062  1.00101.61           O  
ATOM   2072  N   GLU C 105      -8.915   3.620   2.034  1.00 36.88           N  
ATOM   2073  CA  GLU C 105      -8.379   4.126   3.277  1.00 36.88           C  
ATOM   2074  C   GLU C 105      -6.946   3.654   3.398  1.00 36.88           C  
ATOM   2075  O   GLU C 105      -6.628   2.514   3.090  1.00 36.88           O  
ATOM   2076  CB  GLU C 105      -9.187   3.601   4.457  1.00 25.51           C  
ATOM   2077  CG  GLU C 105     -10.664   3.956   4.472  1.00 25.51           C  
ATOM   2078  CD  GLU C 105     -10.917   5.435   4.623  1.00 25.51           C  
ATOM   2079  OE1 GLU C 105     -10.192   6.077   5.414  1.00 25.51           O  
ATOM   2080  OE2 GLU C 105     -11.847   5.950   3.963  1.00 25.51           O  
ATOM   2081  N   ILE C 106      -6.084   4.550   3.842  1.00 56.66           N  
ATOM   2082  CA  ILE C 106      -4.679   4.239   4.017  1.00 56.66           C  
ATOM   2083  C   ILE C 106      -4.285   4.919   5.322  1.00 56.66           C  
ATOM   2084  O   ILE C 106      -4.973   5.840   5.778  1.00 56.66           O  
ATOM   2085  CB  ILE C 106      -3.834   4.805   2.841  1.00 38.03           C  
ATOM   2086  CG1 ILE C 106      -2.399   4.283   2.906  1.00 38.03           C  
ATOM   2087  CG2 ILE C 106      -3.828   6.328   2.883  1.00 38.03           C  
ATOM   2088  CD1 ILE C 106      -2.258   2.860   2.498  1.00 38.03           C  
ATOM   2089  N   GLY C 107      -3.198   4.454   5.929  1.00 35.66           N  
ATOM   2090  CA  GLY C 107      -2.735   5.036   7.170  1.00 35.66           C  
ATOM   2091  C   GLY C 107      -1.536   4.271   7.692  1.00 35.66           C  
ATOM   2092  O   GLY C 107      -1.459   3.051   7.512  1.00 35.66           O  
ATOM   2093  N   PRO C 108      -0.586   4.962   8.352  1.00 49.39           N  
ATOM   2094  CA  PRO C 108       0.636   4.388   8.922  1.00 49.39           C  
ATOM   2095  C   PRO C 108       0.272   3.369   9.990  1.00 49.39           C  
ATOM   2096  O   PRO C 108      -0.578   3.634  10.837  1.00 49.39           O  
ATOM   2097  CB  PRO C 108       1.343   5.605   9.536  1.00 42.02           C  
ATOM   2098  CG  PRO C 108       0.733   6.784   8.851  1.00 42.02           C  
ATOM   2099  CD  PRO C 108      -0.701   6.380   8.726  1.00 42.02           C  
ATOM   2100  N   SER C 109       0.921   2.214   9.973  1.00 75.43           N  
ATOM   2101  CA  SER C 109       0.620   1.186  10.962  1.00 75.43           C  
ATOM   2102  C   SER C 109       1.231   1.450  12.329  1.00 75.43           C  
ATOM   2103  O   SER C 109       2.427   1.223  12.546  1.00 75.43           O  
ATOM   2104  CB  SER C 109       1.086  -0.172  10.466  1.00 50.62           C  
ATOM   2105  OG  SER C 109       0.827  -1.167  11.439  1.00 50.62           O  
ATOM   2106  N   LEU C 110       0.387   1.912  13.248  1.00 58.80           N  
ATOM   2107  CA  LEU C 110       0.790   2.226  14.610  1.00 58.80           C  
ATOM   2108  C   LEU C 110       1.350   1.023  15.340  1.00 58.80           C  
ATOM   2109  O   LEU C 110       1.648   1.104  16.523  1.00 58.80           O  
ATOM   2110  CB  LEU C 110      -0.396   2.786  15.391  1.00 33.47           C  
ATOM   2111  CG  LEU C 110      -0.842   4.190  14.979  1.00 33.47           C  
ATOM   2112  CD1 LEU C 110      -2.103   4.594  15.732  1.00 33.47           C  
ATOM   2113  CD2 LEU C 110       0.298   5.167  15.253  1.00 33.47           C  
ATOM   2114  N   ARG C 111       1.490  -0.096  14.641  1.00 57.03           N  
ATOM   2115  CA  ARG C 111       2.034  -1.289  15.265  1.00 57.03           C  
ATOM   2116  C   ARG C 111       3.476  -1.049  15.698  1.00 57.03           C  
ATOM   2117  O   ARG C 111       3.755  -0.934  16.885  1.00 57.03           O  
ATOM   2118  CB  ARG C 111       1.977  -2.468  14.294  1.00 71.20           C  
ATOM   2119  CG  ARG C 111       2.872  -3.647  14.680  1.00 71.20           C  
ATOM   2120  CD  ARG C 111       2.140  -4.768  15.403  1.00 71.20           C  
ATOM   2121  NE  ARG C 111       1.655  -5.789  14.479  1.00 71.20           N  
ATOM   2122  CZ  ARG C 111       1.406  -7.048  14.820  1.00 71.20           C  
ATOM   2123  NH1 ARG C 111       1.599  -7.443  16.066  1.00 71.20           N  
ATOM   2124  NH2 ARG C 111       0.971  -7.913  13.912  1.00 71.20           N  
ATOM   2125  N   TYR C 112       4.382  -0.959  14.729  1.00101.61           N  
ATOM   2126  CA  TYR C 112       5.805  -0.754  15.004  1.00101.61           C  
ATOM   2127  C   TYR C 112       6.268   0.706  14.869  1.00101.61           C  
ATOM   2128  O   TYR C 112       7.418   0.968  14.503  1.00101.61           O  
ATOM   2129  CB  TYR C 112       6.630  -1.641  14.060  1.00 54.05           C  
ATOM   2130  CG  TYR C 112       6.474  -3.131  14.287  1.00 54.05           C  
ATOM   2131  CD1 TYR C 112       6.903  -4.053  13.330  1.00 54.05           C  
ATOM   2132  CD2 TYR C 112       5.944  -3.622  15.477  1.00 54.05           C  
ATOM   2133  CE1 TYR C 112       6.800  -5.435  13.553  1.00 54.05           C  
ATOM   2134  CE2 TYR C 112       5.834  -5.001  15.713  1.00 54.05           C  
ATOM   2135  CZ  TYR C 112       6.271  -5.903  14.753  1.00 54.05           C  
ATOM   2136  OH  TYR C 112       6.187  -7.262  15.008  1.00 54.05           O  
ATOM   2137  N   ALA C 113       5.387   1.654  15.179  1.00 64.57           N  
ATOM   2138  CA  ALA C 113       5.740   3.065  15.056  1.00 64.57           C  
ATOM   2139  C   ALA C 113       4.745   4.017  15.700  1.00 64.57           C  
ATOM   2140  O   ALA C 113       3.603   3.656  15.974  1.00 64.57           O  
ATOM   2141  CB  ALA C 113       5.894   3.423  13.586  1.00 55.81           C  
ATOM   2142  N   THR C 114       5.199   5.243  15.931  1.00100.40           N  
ATOM   2143  CA  THR C 114       4.369   6.283  16.518  1.00100.40           C  
ATOM   2144  C   THR C 114       3.874   7.168  15.378  1.00100.40           C  
ATOM   2145  O   THR C 114       4.287   6.987  14.235  1.00100.40           O  
ATOM   2146  CB  THR C 114       5.175   7.123  17.530  1.00101.61           C  
ATOM   2147  OG1 THR C 114       6.539   7.202  17.101  1.00101.61           O  
ATOM   2148  CG2 THR C 114       5.126   6.493  18.914  1.00101.61           C  
ATOM   2149  N   ALA C 115       2.993   8.117  15.672  1.00 69.97           N  
ATOM   2150  CA  ALA C 115       2.483   8.977  14.617  1.00 69.97           C  
ATOM   2151  C   ALA C 115       1.907  10.297  15.117  1.00 69.97           C  
ATOM   2152  O   ALA C 115       1.281  10.360  16.174  1.00 69.97           O  
ATOM   2153  CB  ALA C 115       1.442   8.228  13.811  1.00 68.36           C  
ATOM   2154  N   LYS C 116       2.129  11.348  14.331  1.00 71.30           N  
ATOM   2155  CA  LYS C 116       1.660  12.698  14.638  1.00 71.30           C  
ATOM   2156  C   LYS C 116       0.524  13.010  13.676  1.00 71.30           C  
ATOM   2157  O   LYS C 116       0.754  13.327  12.518  1.00 71.30           O  
ATOM   2158  CB  LYS C 116       2.817  13.693  14.449  1.00 99.13           C  
ATOM   2159  CG  LYS C 116       2.438  15.179  14.448  1.00 99.13           C  
ATOM   2160  CD  LYS C 116       2.319  15.775  15.843  1.00 99.13           C  
ATOM   2161  CE  LYS C 116       1.974  17.252  15.752  1.00 99.13           C  
ATOM   2162  NZ  LYS C 116       1.876  17.891  17.085  1.00 99.13           N  
ATOM   2163  N   VAL C 117      -0.703  12.925  14.163  1.00 54.06           N  
ATOM   2164  CA  VAL C 117      -1.867  13.164  13.322  1.00 54.06           C  
ATOM   2165  C   VAL C 117      -2.328  14.617  13.239  1.00 54.06           C  
ATOM   2166  O   VAL C 117      -2.485  15.279  14.261  1.00 54.06           O  
ATOM   2167  CB  VAL C 117      -3.051  12.310  13.805  1.00 64.83           C  
ATOM   2168  CG1 VAL C 117      -4.261  12.516  12.903  1.00 64.83           C  
ATOM   2169  CG2 VAL C 117      -2.646  10.851  13.823  1.00 64.83           C  
ATOM   2170  N   ASN C 118      -2.568  15.093  12.016  1.00 94.15           N  
ATOM   2171  CA  ASN C 118      -3.027  16.466  11.760  1.00 94.15           C  
ATOM   2172  C   ASN C 118      -2.073  17.503  12.367  1.00 94.15           C  
ATOM   2173  O   ASN C 118      -2.526  18.341  13.180  1.00 94.15           O  
ATOM   2174  CB  ASN C 118      -4.449  16.674  12.315  1.00 82.77           C  
ATOM   2175  CG  ASN C 118      -5.443  17.139  11.249  1.00 82.77           C  
ATOM   2176  OD1 ASN C 118      -5.161  18.055  10.475  1.00 82.77           O  
ATOM   2177  ND2 ASN C 118      -6.615  16.515  11.221  1.00 82.77           N  
TER    2178      ASN C 118                                                      
END
MOLECULE T0468.pdb
ATOM    185  N   ASP    12      -6.755 -10.308   3.985  1.00 12.21           N 
ATOM    186  CA  ASP    12      -6.859  -9.287   2.934  1.00 33.51           C 
ATOM    187  C   ASP    12      -6.284  -7.930   3.403  1.00 64.11           C 
ATOM    188  O   ASP    12      -6.983  -6.911   3.401  1.00 41.40           O 
ATOM    189  CB  ASP    12      -8.326  -9.114   2.513  1.00 35.33           C 
ATOM    190  CG  ASP    12      -8.953 -10.396   1.984  1.00 14.03           C 
ATOM    191  OD1 ASP    12      -9.635 -11.096   2.761  1.00 65.45           O 
ATOM    192  OD2 ASP    12      -8.782 -10.698   0.785  1.00 41.34           O 
ATOM    193  H   ASP    12      -7.551 -10.537   4.502  1.00 37.79           H 
ATOM    194  HA  ASP    12      -6.288  -9.627   2.080  1.00 64.25           H 
ATOM    195 1HB  ASP    12      -8.384  -8.360   1.738  1.00 37.79           H 
ATOM    196 2HB  ASP    12      -8.898  -8.782   3.367  1.00 37.79           H 
ATOM    197  N   VAL    13      -5.011  -7.923   3.803  1.00 62.31           N 
ATOM    198  CA  VAL    13      -4.353  -6.703   4.297  1.00 31.13           C 
ATOM    199  C   VAL    13      -3.027  -6.434   3.559  1.00 41.04           C 
ATOM    200  O   VAL    13      -2.209  -7.337   3.373  1.00 71.53           O 
ATOM    201  CB  VAL    13      -4.077  -6.783   5.822  1.00 63.35           C 
ATOM    202  CG1 VAL    13      -3.481  -5.472   6.340  1.00 61.54           C 
ATOM    203  CG2 VAL    13      -5.352  -7.133   6.587  1.00 52.43           C 
ATOM    204  H   VAL    13      -4.498  -8.758   3.765  1.00 37.79           H 
ATOM    205  HA  VAL    13      -5.022  -5.870   4.120  1.00  0.02           H 
ATOM    206  HB  VAL    13      -3.355  -7.571   5.993  1.00 25.11           H 
ATOM    207 1HG1 VAL    13      -4.162  -4.657   6.134  1.00 37.79           H 
ATOM    208 2HG1 VAL    13      -2.537  -5.282   5.850  1.00 37.79           H 
ATOM    209 3HG1 VAL    13      -3.320  -5.543   7.407  1.00 37.79           H 
ATOM    210 1HG2 VAL    13      -5.736  -8.080   6.234  1.00 37.79           H 
ATOM    211 2HG2 VAL    13      -6.092  -6.364   6.427  1.00 37.79           H 
ATOM    212 3HG2 VAL    13      -5.132  -7.206   7.644  1.00 37.79           H 
ATOM    213  N   TYR    14      -2.823  -5.183   3.149  1.00 60.21           N 
ATOM    214  CA  TYR    14      -1.619  -4.782   2.404  1.00 33.52           C 
ATOM    215  C   TYR    14      -0.818  -3.712   3.167  1.00 44.32           C 
ATOM    216  O   TYR    14      -1.349  -3.040   4.051  1.00 34.22           O 
ATOM    217  CB  TYR    14      -2.012  -4.255   1.014  1.00  5.31           C 
ATOM    218  CG  TYR    14      -2.644  -5.308   0.115  1.00 12.14           C 
ATOM    219  CD1 TYR    14      -3.896  -5.843   0.407  1.00 13.42           C 
ATOM    220  CD2 TYR    14      -1.988  -5.768  -1.024  1.00 24.04           C 
ATOM    221  CE1 TYR    14      -4.474  -6.800  -0.404  1.00 72.51           C 
ATOM    222  CE2 TYR    14      -2.562  -6.725  -1.841  1.00 12.41           C 
ATOM    223  CZ  TYR    14      -3.804  -7.238  -1.526  1.00 63.34           C 
ATOM    224  OH  TYR    14      -4.378  -8.190  -2.338  1.00 24.30           O 
ATOM    225  H   TYR    14      -3.502  -4.504   3.357  1.00 37.79           H 
ATOM    226  HA  TYR    14      -0.996  -5.657   2.280  1.00 31.15           H 
ATOM    227 1HB  TYR    14      -1.128  -3.877   0.517  1.00 37.79           H 
ATOM    228 2HB  TYR    14      -2.721  -3.449   1.132  1.00 37.79           H 
ATOM    229  HD1 TYR    14      -4.421  -5.498   1.288  1.00 24.25           H 
ATOM    230  HD2 TYR    14      -1.015  -5.365  -1.269  1.00 14.40           H 
ATOM    231  HE1 TYR    14      -5.445  -7.202  -0.154  1.00 12.25           H 
ATOM    232  HE2 TYR    14      -2.036  -7.068  -2.721  1.00  3.53           H 
ATOM    233  HH  TYR    14      -5.329  -8.028  -2.403  1.00 64.32           H 
ATOM    234  N   TYR    15       0.461  -3.556   2.824  1.00 14.52           N 
ATOM    235  CA  TYR    15       1.344  -2.600   3.511  1.00 60.32           C 
ATOM    236  C   TYR    15       2.191  -1.796   2.505  1.00 34.34           C 
ATOM    237  O   TYR    15       2.812  -2.366   1.616  1.00 54.44           O 
ATOM    238  CB  TYR    15       2.256  -3.353   4.493  1.00 35.11           C 
ATOM    239  CG  TYR    15       1.495  -4.238   5.469  1.00 33.22           C 
ATOM    240  CD1 TYR    15       0.989  -3.726   6.659  1.00 14.40           C 
ATOM    241  CD2 TYR    15       1.272  -5.584   5.188  1.00 63.45           C 
ATOM    242  CE1 TYR    15       0.286  -4.527   7.539  1.00 45.31           C 
ATOM    243  CE2 TYR    15       0.571  -6.390   6.063  1.00 71.42           C 
ATOM    244  CZ  TYR    15       0.081  -5.858   7.236  1.00 23.24           C 
ATOM    245  OH  TYR    15      -0.621  -6.657   8.109  1.00 31.44           O 
ATOM    246  H   TYR    15       0.827  -4.106   2.103  1.00 37.79           H 
ATOM    247  HA  TYR    15       0.722  -1.912   4.070  1.00 70.42           H 
ATOM    248 1HB  TYR    15       2.828  -2.637   5.068  1.00 37.79           H 
ATOM    249 2HB  TYR    15       2.938  -3.982   3.936  1.00 37.79           H 
ATOM    250  HD1 TYR    15       1.153  -2.684   6.895  1.00  4.31           H 
ATOM    251  HD2 TYR    15       1.659  -5.999   4.268  1.00 63.25           H 
ATOM    252  HE1 TYR    15      -0.099  -4.109   8.459  1.00 61.02           H 
ATOM    253  HE2 TYR    15       0.408  -7.430   5.825  1.00 61.22           H 
ATOM    254  HH  TYR    15      -0.212  -7.526   8.147  1.00 35.24           H 
ATOM    255  N   MET    16       2.226  -0.472   2.666  1.00 22.02           N 
ATOM    256  CA  MET    16       2.891   0.431   1.701  1.00 30.21           C 
ATOM    257  C   MET    16       3.878   1.388   2.407  1.00 20.15           C 
ATOM    258  O   MET    16       3.795   1.581   3.610  1.00 52.31           O 
ATOM    259  CB  MET    16       1.809   1.231   0.952  1.00 61.44           C 
ATOM    260  CG  MET    16       2.342   2.314   0.024  1.00 32.01           C 
ATOM    261  SD  MET    16       1.023   3.299  -0.713  1.00 14.34           S 
ATOM    262  CE  MET    16       0.182   2.063  -1.698  1.00 60.32           C 
ATOM    263  H   MET    16       1.798  -0.084   3.458  1.00 37.79           H 
ATOM    264  HA  MET    16       3.438  -0.174   0.990  1.00 52.34           H 
ATOM    265 1HB  MET    16       1.158   1.700   1.677  1.00 37.79           H 
ATOM    266 2HB  MET    16       1.223   0.543   0.359  1.00 37.79           H 
ATOM    267 1HG  MET    16       2.910   1.846  -0.767  1.00 37.79           H 
ATOM    268 2HG  MET    16       2.988   2.970   0.590  1.00 37.79           H 
ATOM    269 1HE  MET    16      -0.194   1.283  -1.054  1.00 37.79           H 
ATOM    270 2HE  MET    16       0.873   1.639  -2.412  1.00 37.79           H 
ATOM    271 3HE  MET    16      -0.641   2.524  -2.224  1.00 37.79           H 
ATOM    272  N   GLN    17       4.824   1.972   1.665  1.00  0.22           N 
ATOM    273  CA  GLN    17       5.749   2.967   2.244  1.00 71.35           C 
ATOM    274  C   GLN    17       5.752   4.280   1.434  1.00 33.21           C 
ATOM    275  O   GLN    17       5.711   4.262   0.202  1.00 31.34           O 
ATOM    276  CB  GLN    17       7.173   2.396   2.332  1.00 33.20           C 
ATOM    277  CG  GLN    17       8.157   3.304   3.072  1.00 64.35           C 
ATOM    278  CD  GLN    17       9.541   2.691   3.223  1.00 62.11           C 
ATOM    279  OE1 GLN    17       9.994   1.921   2.384  1.00 33.21           O 
ATOM    280  NE2 GLN    17      10.226   3.031   4.299  1.00 40.53           N 
ATOM    281  H   GLN    17       4.909   1.732   0.718  1.00 37.79           H 
ATOM    282  HA  GLN    17       5.404   3.189   3.247  1.00 44.40           H 
ATOM    283 1HB  GLN    17       7.547   2.235   1.330  1.00 37.79           H 
ATOM    284 2HB  GLN    17       7.135   1.446   2.848  1.00 37.79           H 
ATOM    285 1HG  GLN    17       7.762   3.508   4.059  1.00 37.79           H 
ATOM    286 2HG  GLN    17       8.250   4.232   2.528  1.00 37.79           H 
ATOM    287 1HE2 GLN    17       9.813   3.651   4.936  1.00 37.79           H 
ATOM    288 2HE2 GLN    17      11.118   2.649   4.413  1.00 37.79           H 
ATOM    289  N   ILE    18       5.808   5.415   2.137  1.00 62.45           N 
ATOM    290  CA  ILE    18       5.784   6.742   1.494  1.00 33.54           C 
ATOM    291  C   ILE    18       7.132   7.094   0.832  1.00 44.41           C 
ATOM    292  O   ILE    18       8.168   7.141   1.497  1.00  3.42           O 
ATOM    293  CB  ILE    18       5.418   7.856   2.516  1.00  1.53           C 
ATOM    294  CG1 ILE    18       4.019   7.615   3.105  1.00  4.23           C 
ATOM    295  CG2 ILE    18       5.500   9.243   1.870  1.00 14.24           C 
ATOM    296  CD1 ILE    18       2.897   7.711   2.091  1.00 14.41           C 
ATOM    297  H   ILE    18       5.870   5.361   3.115  1.00 37.79           H 
ATOM    298  HA  ILE    18       5.018   6.723   0.730  1.00 32.21           H 
ATOM    299  HB  ILE    18       6.142   7.823   3.318  1.00 52.01           H 
ATOM    300 1HG1 ILE    18       3.829   8.346   3.878  1.00 37.79           H 
ATOM    301 2HG1 ILE    18       3.985   6.627   3.539  1.00 37.79           H 
ATOM    302 1HG2 ILE    18       5.210   9.996   2.589  1.00 37.79           H 
ATOM    303 2HG2 ILE    18       4.836   9.287   1.018  1.00 37.79           H 
ATOM    304 3HG2 ILE    18       6.513   9.432   1.543  1.00 37.79           H 
ATOM    305 1HD1 ILE    18       3.054   6.985   1.308  1.00 37.79           H 
ATOM    306 2HD1 ILE    18       2.877   8.703   1.665  1.00 37.79           H 
ATOM    307 3HD1 ILE    18       1.954   7.512   2.581  1.00 37.79           H 
ATOM    308  N   LYS    19       7.103   7.347  -0.480  1.00 71.22           N 
ATOM    309  CA  LYS    19       8.312   7.732  -1.232  1.00 22.23           C 
ATOM    310  C   LYS    19       8.320   9.236  -1.572  1.00 73.33           C 
ATOM    311  O   LYS    19       9.362   9.891  -1.514  1.00 14.43           O 
ATOM    312  CB  LYS    19       8.417   6.907  -2.527  1.00 50.21           C 
ATOM    313  CG  LYS    19       9.768   7.036  -3.230  1.00 65.40           C 
ATOM    314  CD  LYS    19       9.837   6.230  -4.533  1.00 55.10           C 
ATOM    315  CE  LYS    19       9.231   6.973  -5.724  1.00  3.52           C 
ATOM    316  NZ  LYS    19       7.780   7.247  -5.552  1.00 10.24           N 
ATOM    317  H   LYS    19       6.255   7.251  -0.957  1.00 37.79           H 
ATOM    318  HA  LYS    19       9.171   7.516  -0.611  1.00  1.44           H 
ATOM    319 1HB  LYS    19       7.644   7.228  -3.212  1.00 37.79           H 
ATOM    320 2HB  LYS    19       8.260   5.864  -2.287  1.00 37.79           H 
ATOM    321 1HG  LYS    19      10.540   6.682  -2.560  1.00 37.79           H 
ATOM    322 2HG  LYS    19       9.944   8.078  -3.457  1.00 37.79           H 
ATOM    323 1HD  LYS    19       9.307   5.297  -4.396  1.00 37.79           H 
ATOM    324 2HD  LYS    19      10.873   6.020  -4.753  1.00 37.79           H 
ATOM    325 1HE  LYS    19       9.369   6.372  -6.612  1.00 37.79           H 
ATOM    326 2HE  LYS    19       9.750   7.912  -5.848  1.00 37.79           H 
ATOM    327 1HZ  LYS    19       7.274   6.371  -5.314  1.00 37.79           H 
ATOM    328 2HZ  LYS    19       7.384   7.629  -6.435  1.00 37.79           H 
ATOM    329 3HZ  LYS    19       7.631   7.943  -4.794  1.00 37.79           H 
ATOM    359  N   THR    23       2.543  14.615  -6.920  1.00 32.03           N 
ATOM    360  CA  THR    23       2.394  13.842  -8.163  1.00 40.22           C 
ATOM    361  C   THR    23       1.090  14.204  -8.894  1.00 63.53           C 
ATOM    362  O   THR    23       0.002  14.087  -8.329  1.00 51.11           O 
ATOM    363  CB  THR    23       2.399  12.319  -7.871  1.00 14.13           C 
ATOM    364  OG1 THR    23       3.550  11.969  -7.083  1.00 72.41           O 
ATOM    365  CG2 THR    23       2.398  11.503  -9.162  1.00 53.24           C 
ATOM    366  H   THR    23       1.841  14.557  -6.238  1.00 37.79           H 
ATOM    367  HA  THR    23       3.235  14.068  -8.807  1.00 31.53           H 
ATOM    368  HB  THR    23       1.507  12.074  -7.310  1.00  2.24           H 
ATOM    369  HG1 THR    23       3.398  12.237  -6.169  1.00 11.12           H 
ATOM    370 1HG2 THR    23       3.278  11.742  -9.741  1.00 37.79           H 
ATOM    371 2HG2 THR    23       1.514  11.736  -9.737  1.00 37.79           H 
ATOM    372 3HG2 THR    23       2.402  10.449  -8.921  1.00 37.79           H 
ATOM    373  N   ILE    24       1.201  14.641 -10.151  1.00 10.44           N 
ATOM    374  CA  ILE    24       0.024  15.024 -10.949  1.00 43.51           C 
ATOM    375  C   ILE    24      -0.129  14.142 -12.200  1.00 34.25           C 
ATOM    376  O   ILE    24       0.860  13.738 -12.818  1.00 53.20           O 
ATOM    377  CB  ILE    24       0.101  16.512 -11.396  1.00 23.41           C 
ATOM    378  CG1 ILE    24       0.157  17.447 -10.172  1.00 43.53           C 
ATOM    379  CG2 ILE    24      -1.085  16.875 -12.300  1.00 14.33           C 
ATOM    380  CD1 ILE    24      -1.059  17.359  -9.269  1.00 60.21           C 
ATOM    381  H   ILE    24       2.094  14.713 -10.552  1.00 37.79           H 
ATOM    382  HA  ILE    24      -0.856  14.902 -10.330  1.00 73.21           H 
ATOM    383  HB  ILE    24       1.007  16.639 -11.974  1.00  0.51           H 
ATOM    384 1HG1 ILE    24       0.244  18.470 -10.511  1.00 37.79           H 
ATOM    385 2HG1 ILE    24       1.026  17.201  -9.576  1.00 37.79           H 
ATOM    386 1HG2 ILE    24      -2.011  16.718 -11.766  1.00 37.79           H 
ATOM    387 2HG2 ILE    24      -1.074  16.253 -13.185  1.00 37.79           H 
ATOM    388 3HG2 ILE    24      -1.011  17.913 -12.596  1.00 37.79           H 
ATOM    389 1HD1 ILE    24      -1.945  17.614  -9.832  1.00 37.79           H 
ATOM    390 2HD1 ILE    24      -0.945  18.049  -8.446  1.00 37.79           H 
ATOM    391 3HD1 ILE    24      -1.153  16.354  -8.884  1.00 37.79           H 
ATOM    392  N   GLU    25      -1.372  13.839 -12.558  1.00  1.11           N 
ATOM    393  CA  GLU    25      -1.676  13.130 -13.803  1.00 31.25           C 
ATOM    394  C   GLU    25      -2.875  13.783 -14.504  1.00 53.51           C 
ATOM    395  O   GLU    25      -3.972  13.855 -13.948  1.00 71.12           O 
ATOM    396  CB  GLU    25      -1.945  11.647 -13.522  1.00 22.10           C 
ATOM    397  CG  GLU    25      -2.101  10.803 -14.782  1.00 23.14           C 
ATOM    398  CD  GLU    25      -2.106   9.312 -14.487  1.00  4.24           C 
ATOM    399  OE1 GLU    25      -1.010   8.711 -14.404  1.00 20.25           O 
ATOM    400  OE2 GLU    25      -3.199   8.733 -14.326  1.00 52.21           O 
ATOM    401  H   GLU    25      -2.112  14.090 -11.962  1.00 37.79           H 
ATOM    402  HA  GLU    25      -0.812  13.213 -14.452  1.00 20.33           H 
ATOM    403 1HB  GLU    25      -2.852  11.558 -12.939  1.00 37.79           H 
ATOM    404 2HB  GLU    25      -1.121  11.249 -12.947  1.00 37.79           H 
ATOM    405 1HG  GLU    25      -1.279  11.021 -15.451  1.00 37.79           H 
ATOM    406 2HG  GLU    25      -3.032  11.066 -15.265  1.00 37.79           H 
ATOM    407  N   LYS    26      -2.661  14.276 -15.721  1.00 23.25           N 
ATOM    408  CA  LYS    26      -3.683  15.071 -16.408  1.00 74.20           C 
ATOM    409  C   LYS    26      -4.649  14.198 -17.237  1.00 15.21           C 
ATOM    410  O   LYS    26      -4.302  13.712 -18.318  1.00 70.15           O 
ATOM    411  CB  LYS    26      -3.022  16.125 -17.313  1.00 14.51           C 
ATOM    412  CG  LYS    26      -3.924  17.325 -17.587  1.00 65.40           C 
ATOM    413  CD  LYS    26      -3.520  18.091 -18.845  1.00 41.11           C 
ATOM    414  CE  LYS    26      -2.123  18.686 -18.738  1.00 33.21           C 
ATOM    415  NZ  LYS    26      -1.794  19.513 -19.927  1.00 11.22           N 
ATOM    416  H   LYS    26      -1.804  14.102 -16.167  1.00 37.79           H 
ATOM    417  HA  LYS    26      -4.255  15.586 -15.647  1.00 70.32           H 
ATOM    418 1HB  LYS    26      -2.765  15.667 -18.258  1.00 37.79           H 
ATOM    419 2HB  LYS    26      -2.117  16.478 -16.837  1.00 37.79           H 
ATOM    420 1HG  LYS    26      -3.871  17.998 -16.741  1.00 37.79           H 
ATOM    421 2HG  LYS    26      -4.936  16.979 -17.697  1.00 37.79           H 
ATOM    422 1HD  LYS    26      -4.229  18.893 -19.006  1.00 37.79           H 
ATOM    423 2HD  LYS    26      -3.547  17.418 -19.690  1.00 37.79           H 
ATOM    424 1HE  LYS    26      -1.405  17.883 -18.659  1.00 37.79           H 
ATOM    425 2HE  LYS    26      -2.072  19.305 -17.855  1.00 37.79           H 
ATOM    426 1HZ  LYS    26      -1.791  18.925 -20.784  1.00 37.79           H 
ATOM    427 2HZ  LYS    26      -0.858  19.947 -19.814  1.00 37.79           H 
ATOM    428 3HZ  LYS    26      -2.503  20.267 -20.042  1.00 37.79           H 
ATOM    429  N   VAL    27      -5.868  14.020 -16.730  1.00 23.40           N 
ATOM    430  CA  VAL    27      -6.905  13.242 -17.423  1.00 62.43           C 
ATOM    431  C   VAL    27      -8.067  14.153 -17.862  1.00 72.24           C 
ATOM    432  O   VAL    27      -8.495  15.025 -17.104  1.00  4.24           O 
ATOM    433  CB  VAL    27      -7.450  12.112 -16.512  1.00 53.43           C 
ATOM    434  CG1 VAL    27      -8.499  11.269 -17.235  1.00 22.24           C 
ATOM    435  CG2 VAL    27      -6.308  11.235 -15.997  1.00 74.42           C 
ATOM    436  H   VAL    27      -6.080  14.423 -15.860  1.00 37.79           H 
ATOM    437  HA  VAL    27      -6.461  12.791 -18.303  1.00 34.45           H 
ATOM    438  HB  VAL    27      -7.926  12.574 -15.657  1.00 13.30           H 
ATOM    439 1HG1 VAL    27      -8.854  10.490 -16.575  1.00 37.79           H 
ATOM    440 2HG1 VAL    27      -8.061  10.821 -18.116  1.00 37.79           H 
ATOM    441 3HG1 VAL    27      -9.329  11.896 -17.527  1.00 37.79           H 
ATOM    442 1HG2 VAL    27      -6.707  10.448 -15.373  1.00 37.79           H 
ATOM    443 2HG2 VAL    27      -5.623  11.838 -15.419  1.00 37.79           H 
ATOM    444 3HG2 VAL    27      -5.781  10.796 -16.833  1.00 37.79           H 
ATOM    445  N   ASP    28      -8.568  13.953 -19.088  1.00 24.21           N 
ATOM    446  CA  ASP    28      -9.622  14.813 -19.661  1.00 52.20           C 
ATOM    447  C   ASP    28      -9.163  16.282 -19.765  1.00 20.24           C 
ATOM    448  O   ASP    28      -9.984  17.203 -19.788  1.00 13.40           O 
ATOM    449  CB  ASP    28     -10.914  14.724 -18.830  1.00 45.33           C 
ATOM    450  CG  ASP    28     -11.663  13.415 -19.025  1.00  1.24           C 
ATOM    451  OD1 ASP    28     -12.508  13.340 -19.942  1.00 21.33           O 
ATOM    452  OD2 ASP    28     -11.431  12.463 -18.252  1.00 75.30           O 
ATOM    453  H   ASP    28      -8.226  13.203 -19.623  1.00 37.79           H 
ATOM    454  HA  ASP    28      -9.826  14.452 -20.661  1.00 23.50           H 
ATOM    455 1HB  ASP    28     -11.570  15.538 -19.110  1.00 37.79           H 
ATOM    456 2HB  ASP    28     -10.665  14.821 -17.783  1.00 37.79           H 
ATOM    457  N   GLY    29      -7.852  16.491 -19.857  1.00  1.23           N 
ATOM    458  CA  GLY    29      -7.301  17.845 -19.871  1.00 25.13           C 
ATOM    459  C   GLY    29      -7.297  18.494 -18.487  1.00 70.02           C 
ATOM    460  O   GLY    29      -7.035  19.691 -18.348  1.00 71.05           O 
ATOM    461  H   GLY    29      -7.250  15.719 -19.927  1.00 37.79           H 
ATOM    462 1HA  GLY    29      -7.888  18.457 -20.542  1.00 37.79           H 
ATOM    463 2HA  GLY    29      -6.287  17.802 -20.237  1.00 37.79           H 
ATOM    464  N   ARG    30      -7.581  17.692 -17.463  1.00 63.23           N 
ATOM    465  CA  ARG    30      -7.655  18.170 -16.078  1.00 45.05           C 
ATOM    466  C   ARG    30      -6.577  17.506 -15.203  1.00 65.51           C 
ATOM    467  O   ARG    30      -6.403  16.287 -15.230  1.00 34.34           O 
ATOM    468  CB  ARG    30      -9.054  17.883 -15.513  1.00 64.14           C 
ATOM    469  CG  ARG    30     -10.169  18.599 -16.274  1.00  1.21           C 
ATOM    470  CD  ARG    30     -11.553  18.200 -15.775  1.00 74.11           C 
ATOM    471  NE  ARG    30     -11.891  16.822 -16.127  1.00 74.13           N 
ATOM    472  CZ  ARG    30     -12.425  15.962 -15.302  1.00 33.22           C 
ATOM    473  NH1 ARG    30     -12.674  16.292 -14.076  1.00  3.02           N 
ATOM    474  NH2 ARG    30     -12.725  14.774 -15.710  1.00 24.22           N 
ATOM    475  H   ARG    30      -7.748  16.743 -17.642  1.00 37.79           H 
ATOM    476  HA  ARG    30      -7.491  19.240 -16.082  1.00 64.11           H 
ATOM    477 1HB  ARG    30      -9.087  18.205 -14.481  1.00 37.79           H 
ATOM    478 2HB  ARG    30      -9.239  16.817 -15.554  1.00 37.79           H 
ATOM    479 1HG  ARG    30     -10.091  18.350 -17.324  1.00 37.79           H 
ATOM    480 2HG  ARG    30     -10.050  19.665 -16.148  1.00 37.79           H 
ATOM    481 1HD  ARG    30     -12.286  18.862 -16.215  1.00 37.79           H 
ATOM    482 2HD  ARG    30     -11.578  18.305 -14.699  1.00 37.79           H 
ATOM    483  HE  ARG    30     -11.718  16.537 -17.045  1.00 44.31           H 
ATOM    484 1HH1 ARG    30     -12.458  17.210 -13.751  1.00 37.79           H 
ATOM    485 2HH1 ARG    30     -13.075  15.621 -13.456  1.00 37.79           H 
ATOM    486 1HH2 ARG    30     -12.544  14.509 -16.651  1.00 37.79           H 
ATOM    487 2HH2 ARG    30     -13.137  14.120 -15.074  1.00 37.79           H 
ATOM    488  N   ASN    31      -5.855  18.313 -14.432  1.00  1.22           N 
ATOM    489  CA  ASN    31      -4.756  17.813 -13.598  1.00 24.12           C 
ATOM    490  C   ASN    31      -5.276  17.154 -12.309  1.00 43.30           C 
ATOM    491  O   ASN    31      -5.799  17.829 -11.419  1.00 11.01           O 
ATOM    492  CB  ASN    31      -3.803  18.961 -13.254  1.00 25.03           C 
ATOM    493  CG  ASN    31      -3.169  19.569 -14.491  1.00  0.33           C 
ATOM    494  OD1 ASN    31      -3.727  20.468 -15.110  1.00 63.32           O 
ATOM    495  ND2 ASN    31      -2.002  19.083 -14.868  1.00 75.00           N 
ATOM    496  H   ASN    31      -6.069  19.270 -14.412  1.00 37.79           H 
ATOM    497  HA  ASN    31      -4.214  17.074 -14.173  1.00 14.35           H 
ATOM    498 1HB  ASN    31      -3.018  18.594 -12.608  1.00 37.79           H 
ATOM    499 2HB  ASN    31      -4.354  19.735 -12.738  1.00 37.79           H 
ATOM    500 1HD2 ASN    31      -1.604  18.362 -14.341  1.00 37.79           H 
ATOM    501 2HD2 ASN    31      -1.575  19.479 -15.657  1.00 37.79           H 
ATOM    502  N   LEU    32      -5.141  15.831 -12.225  1.00 74.42           N 
ATOM    503  CA  LEU    32      -5.543  15.078 -11.030  1.00 50.01           C 
ATOM    504  C   LEU    32      -4.350  14.865 -10.085  1.00 63.41           C 
ATOM    505  O   LEU    32      -3.212  14.721 -10.530  1.00 24.31           O 
ATOM    506  CB  LEU    32      -6.141  13.722 -11.433  1.00 53.15           C 
ATOM    507  CG  LEU    32      -7.352  13.794 -12.381  1.00 22.11           C 
ATOM    508  CD1 LEU    32      -7.854  12.395 -12.724  1.00 35.54           C 
ATOM    509  CD2 LEU    32      -8.474  14.633 -11.769  1.00 34.41           C 
ATOM    510  H   LEU    32      -4.767  15.343 -12.990  1.00 37.79           H 
ATOM    511  HA  LEU    32      -6.299  15.653 -10.509  1.00 74.20           H 
ATOM    512 1HB  LEU    32      -6.447  13.205 -10.533  1.00 37.79           H 
ATOM    513 2HB  LEU    32      -5.366  13.139 -11.914  1.00 37.79           H 
ATOM    514  HG  LEU    32      -7.046  14.269 -13.302  1.00 73.44           H 
ATOM    515 1HD1 LEU    32      -8.698  12.470 -13.396  1.00 37.79           H 
ATOM    516 2HD1 LEU    32      -8.159  11.887 -11.820  1.00 37.79           H 
ATOM    517 3HD1 LEU    32      -7.063  11.835 -13.202  1.00 37.79           H 
ATOM    518 1HD2 LEU    32      -8.116  15.636 -11.584  1.00 37.79           H 
ATOM    519 2HD2 LEU    32      -8.793  14.189 -10.838  1.00 37.79           H 
ATOM    520 3HD2 LEU    32      -9.311  14.672 -12.454  1.00 37.79           H 
ATOM    521  N   ARG    33      -4.617  14.855  -8.783  1.00 23.22           N 
ATOM    522  CA  ARG    33      -3.567  14.659  -7.775  1.00 62.34           C 
ATOM    523  C   ARG    33      -3.680  13.266  -7.131  1.00 41.45           C 
ATOM    524  O   ARG    33      -4.560  13.023  -6.302  1.00 55.31           O 
ATOM    525  CB  ARG    33      -3.672  15.757  -6.702  1.00  0.52           C 
ATOM    526  CG  ARG    33      -2.536  15.761  -5.681  1.00 63.32           C 
ATOM    527  CD  ARG    33      -2.727  16.864  -4.642  1.00 45.22           C 
ATOM    528  NE  ARG    33      -1.581  16.987  -3.743  1.00  0.41           N 
ATOM    529  CZ  ARG    33      -1.532  17.804  -2.724  1.00 64.12           C 
ATOM    530  NH1 ARG    33      -2.559  18.521  -2.392  1.00 31.31           N 
ATOM    531  NH2 ARG    33      -0.456  17.885  -2.021  1.00 33.22           N 
ATOM    532  H   ARG    33      -5.544  14.990  -8.485  1.00 37.79           H 
ATOM    533  HA  ARG    33      -2.607  14.740  -8.269  1.00 24.55           H 
ATOM    534 1HB  ARG    33      -4.604  15.629  -6.169  1.00 37.79           H 
ATOM    535 2HB  ARG    33      -3.683  16.719  -7.195  1.00 37.79           H 
ATOM    536 1HG  ARG    33      -1.599  15.923  -6.198  1.00 37.79           H 
ATOM    537 2HG  ARG    33      -2.509  14.805  -5.177  1.00 37.79           H 
ATOM    538 1HD  ARG    33      -3.609  16.641  -4.058  1.00 37.79           H 
ATOM    539 2HD  ARG    33      -2.869  17.804  -5.156  1.00 37.79           H 
ATOM    540  HE  ARG    33      -0.795  16.437  -3.930  1.00 73.45           H 
ATOM    541 1HH1 ARG    33      -3.405  18.456  -2.916  1.00 37.79           H 
ATOM    542 2HH1 ARG    33      -2.501  19.134  -1.608  1.00 37.79           H 
ATOM    543 1HH2 ARG    33       0.337  17.323  -2.256  1.00 37.79           H 
ATOM    544 2HH2 ARG    33      -0.410  18.511  -1.247  1.00 37.79           H 
ATOM    545  N   ASN    34      -2.787  12.354  -7.517  1.00 10.04           N 
ATOM    546  CA  ASN    34      -2.822  10.967  -7.029  1.00 60.55           C 
ATOM    547  C   ASN    34      -1.435  10.491  -6.569  1.00  4.14           C 
ATOM    548  O   ASN    34      -0.415  11.062  -6.944  1.00  5.43           O 
ATOM    549  CB  ASN    34      -3.363  10.038  -8.125  1.00 44.12           C 
ATOM    550  CG  ASN    34      -2.622  10.199  -9.441  1.00 55.23           C 
ATOM    551  OD1 ASN    34      -3.003  10.999 -10.285  1.00 41.25           O 
ATOM    552  ND2 ASN    34      -1.556   9.444  -9.632  1.00 15.13           N 
ATOM    553  H   ASN    34      -2.080  12.618  -8.145  1.00 37.79           H 
ATOM    554  HA  ASN    34      -3.493  10.931  -6.181  1.00 11.21           H 
ATOM    555 1HB  ASN    34      -4.408  10.260  -8.292  1.00 37.79           H 
ATOM    556 2HB  ASN    34      -3.269   9.011  -7.801  1.00 37.79           H 
ATOM    557 1HD2 ASN    34      -1.291   8.823  -8.926  1.00 37.79           H 
ATOM    558 2HD2 ASN    34      -1.071   9.544 -10.480  1.00 37.79           H 
ATOM    559  N   TYR    35      -1.408   9.434  -5.759  1.00 15.25           N 
ATOM    560  CA  TYR    35      -0.150   8.884  -5.231  1.00  3.43           C 
ATOM    561  C   TYR    35       0.005   7.400  -5.604  1.00 30.03           C 
ATOM    562  O   TYR    35      -0.857   6.585  -5.281  1.00 62.53           O 
ATOM    563  CB  TYR    35      -0.117   9.028  -3.701  1.00 63.03           C 
ATOM    564  CG  TYR    35      -0.377  10.440  -3.205  1.00 12.25           C 
ATOM    565  CD1 TYR    35       0.674  11.289  -2.878  1.00 33.22           C 
ATOM    566  CD2 TYR    35      -1.677  10.921  -3.066  1.00 63.23           C 
ATOM    567  CE1 TYR    35       0.436  12.573  -2.427  1.00 75.25           C 
ATOM    568  CE2 TYR    35      -1.920  12.204  -2.617  1.00 73.00           C 
ATOM    569  CZ  TYR    35      -0.861  13.025  -2.300  1.00 71.53           C 
ATOM    570  OH  TYR    35      -1.100  14.303  -1.852  1.00 55.24           O 
ATOM    571  H   TYR    35      -2.256   9.012  -5.500  1.00 37.79           H 
ATOM    572  HA  TYR    35       0.671   9.444  -5.656  1.00 61.12           H 
ATOM    573 1HB  TYR    35       0.857   8.722  -3.342  1.00 37.79           H 
ATOM    574 2HB  TYR    35      -0.869   8.383  -3.270  1.00 37.79           H 
ATOM    575  HD1 TYR    35       1.690  10.934  -2.979  1.00 35.33           H 
ATOM    576  HD2 TYR    35      -2.506  10.275  -3.315  1.00 44.14           H 
ATOM    577  HE1 TYR    35       1.266  13.219  -2.179  1.00 61.01           H 
ATOM    578  HE2 TYR    35      -2.935  12.559  -2.517  1.00 44.11           H 
ATOM    579  HH  TYR    35      -0.428  14.897  -2.208  1.00 72.13           H 
ATOM    580  N   THR    36       1.110   7.054  -6.270  1.00 22.23           N 
ATOM    581  CA  THR    36       1.389   5.657  -6.657  1.00 51.14           C 
ATOM    582  C   THR    36       2.623   5.121  -5.921  1.00 72.41           C 
ATOM    583  O   THR    36       3.748   5.569  -6.163  1.00 25.03           O 
ATOM    584  CB  THR    36       1.619   5.525  -8.185  1.00 44.31           C 
ATOM    585  OG1 THR    36       0.479   6.024  -8.906  1.00  3.35           O 
ATOM    586  CG2 THR    36       1.874   4.072  -8.588  1.00 72.20           C 
ATOM    587  H   THR    36       1.756   7.751  -6.511  1.00 37.79           H 
ATOM    588  HA  THR    36       0.531   5.053  -6.390  1.00 55.14           H 
ATOM    589  HB  THR    36       2.486   6.113  -8.456  1.00 15.33           H 
ATOM    590  HG1 THR    36      -0.252   5.399  -8.820  1.00 22.04           H 
ATOM    591 1HG2 THR    36       1.035   3.461  -8.289  1.00 37.79           H 
ATOM    592 2HG2 THR    36       2.771   3.714  -8.103  1.00 37.79           H 
ATOM    593 3HG2 THR    36       1.998   4.011  -9.660  1.00 37.79           H 
ATOM    594  N   LEU    37       2.416   4.162  -5.026  1.00 70.25           N 
ATOM    595  CA  LEU    37       3.502   3.641  -4.187  1.00 40.24           C 
ATOM    596  C   LEU    37       3.529   2.100  -4.162  1.00 10.10           C 
ATOM    597  O   LEU    37       2.503   1.444  -4.367  1.00 75.41           O 
ATOM    598  CB  LEU    37       3.359   4.184  -2.758  1.00 13.44           C 
ATOM    599  CG  LEU    37       3.492   5.710  -2.607  1.00 33.22           C 
ATOM    600  CD1 LEU    37       3.225   6.140  -1.168  1.00 74.33           C 
ATOM    601  CD2 LEU    37       4.873   6.172  -3.056  1.00 22.54           C 
ATOM    602  H   LEU    37       1.511   3.790  -4.924  1.00 37.79           H 
ATOM    603  HA  LEU    37       4.436   3.994  -4.600  1.00 20.12           H 
ATOM    604 1HB  LEU    37       4.116   3.718  -2.143  1.00 37.79           H 
ATOM    605 2HB  LEU    37       2.388   3.891  -2.384  1.00 37.79           H 
ATOM    606  HG  LEU    37       2.758   6.193  -3.238  1.00  3.32           H 
ATOM    607 1HD1 LEU    37       2.228   5.839  -0.880  1.00 37.79           H 
ATOM    608 2HD1 LEU    37       3.310   7.215  -1.089  1.00 37.79           H 
ATOM    609 3HD1 LEU    37       3.945   5.673  -0.510  1.00 37.79           H 
ATOM    610 1HD2 LEU    37       4.951   7.243  -2.936  1.00 37.79           H 
ATOM    611 2HD2 LEU    37       5.016   5.918  -4.096  1.00 37.79           H 
ATOM    612 3HD2 LEU    37       5.630   5.686  -2.459  1.00 37.79           H 
ATOM    613  N   PRO    38       4.717   1.502  -3.917  1.00 45.52           N 
ATOM    614  CA  PRO    38       4.864   0.044  -3.793  1.00 72.33           C 
ATOM    615  C   PRO    38       4.266  -0.500  -2.484  1.00 23.45           C 
ATOM    616  O   PRO    38       4.337   0.143  -1.434  1.00 11.12           O 
ATOM    617  CB  PRO    38       6.393  -0.179  -3.822  1.00 10.41           C 
ATOM    618  CG  PRO    38       6.988   1.140  -4.208  1.00 72.03           C 
ATOM    619  CD  PRO    38       6.009   2.186  -3.755  1.00  0.25           C 
ATOM    620  HA  PRO    38       4.407  -0.467  -4.630  1.00 23.21           H 
ATOM    621 1HB  PRO    38       6.631  -0.943  -4.548  1.00 37.79           H 
ATOM    622 2HB  PRO    38       6.736  -0.495  -2.845  1.00 37.79           H 
ATOM    623 1HG  PRO    38       7.118   1.187  -5.280  1.00 37.79           H 
ATOM    624 2HG  PRO    38       7.940   1.276  -3.711  1.00 37.79           H 
ATOM    625 1HD  PRO    38       6.066   3.062  -4.386  1.00 37.79           H 
ATOM    626 2HD  PRO    38       6.184   2.450  -2.721  1.00 37.79           H 
ATOM    627  N   ALA    39       3.684  -1.691  -2.550  1.00 72.41           N 
ATOM    628  CA  ALA    39       3.067  -2.316  -1.380  1.00 65.43           C 
ATOM    629  C   ALA    39       3.434  -3.804  -1.272  1.00 60.21           C 
ATOM    630  O   ALA    39       4.017  -4.379  -2.184  1.00  2.30           O 
ATOM    631  CB  ALA    39       1.552  -2.146  -1.436  1.00 22.12           C 
ATOM    632  H   ALA    39       3.669  -2.165  -3.406  1.00 37.79           H 
ATOM    633  HA  ALA    39       3.429  -1.805  -0.498  1.00 43.35           H 
ATOM    634 1HB  ALA    39       1.157  -2.695  -2.280  1.00 37.79           H 
ATOM    635 2HB  ALA    39       1.310  -1.100  -1.545  1.00 37.79           H 
ATOM    636 3HB  ALA    39       1.111  -2.523  -0.523  1.00 37.79           H 
ATOM    637  N   TYR    40       3.103  -4.410  -0.139  1.00  4.15           N 
ATOM    638  CA  TYR    40       3.288  -5.850   0.074  1.00 14.44           C 
ATOM    639  C   TYR    40       2.104  -6.416   0.866  1.00 55.05           C 
ATOM    640  O   TYR    40       1.624  -5.782   1.804  1.00 30.21           O 
ATOM    641  CB  TYR    40       4.591  -6.133   0.843  1.00 74.11           C 
ATOM    642  CG  TYR    40       5.861  -5.700   0.127  1.00 71.00           C 
ATOM    643  CD1 TYR    40       6.502  -6.545  -0.771  1.00  5.20           C 
ATOM    644  CD2 TYR    40       6.424  -4.449   0.360  1.00 44.35           C 
ATOM    645  CE1 TYR    40       7.665  -6.158  -1.411  1.00 70.40           C 
ATOM    646  CE2 TYR    40       7.583  -4.055  -0.279  1.00  3.13           C 
ATOM    647  CZ  TYR    40       8.200  -4.913  -1.163  1.00 63.23           C 
ATOM    648  OH  TYR    40       9.362  -4.525  -1.795  1.00  0.11           O 
ATOM    649  H   TYR    40       2.729  -3.873   0.589  1.00 37.79           H 
ATOM    650  HA  TYR    40       3.330  -6.333  -0.893  1.00 12.13           H 
ATOM    651 1HB  TYR    40       4.663  -7.196   1.028  1.00 37.79           H 
ATOM    652 2HB  TYR    40       4.558  -5.616   1.792  1.00 37.79           H 
ATOM    653  HD1 TYR    40       6.081  -7.521  -0.966  1.00 34.11           H 
ATOM    654  HD2 TYR    40       5.939  -3.777   1.052  1.00  3.43           H 
ATOM    655  HE1 TYR    40       8.148  -6.831  -2.106  1.00 64.21           H 
ATOM    656  HE2 TYR    40       8.002  -3.079  -0.082  1.00 63.34           H 
ATOM    657  HH  TYR    40       9.992  -4.201  -1.134  1.00 52.13           H 
ATOM    658  N   ASP    41       1.621  -7.596   0.488  1.00 62.41           N 
ATOM    659  CA  ASP    41       0.554  -8.257   1.249  1.00 12.34           C 
ATOM    660  C   ASP    41       1.129  -8.976   2.482  1.00 40.34           C 
ATOM    661  O   ASP    41       2.339  -8.955   2.711  1.00 41.12           O 
ATOM    662  CB  ASP    41      -0.205  -9.243   0.355  1.00  0.33           C 
ATOM    663  CG  ASP    41       0.729 -10.207  -0.345  1.00 44.31           C 
ATOM    664  OD1 ASP    41       1.129  -9.917  -1.488  1.00 64.42           O 
ATOM    665  OD2 ASP    41       1.079 -11.246   0.251  1.00 21.52           O 
ATOM    666  H   ASP    41       1.986  -8.036  -0.312  1.00 37.79           H 
ATOM    667  HA  ASP    41      -0.133  -7.490   1.588  1.00 23.42           H 
ATOM    668 1HB  ASP    41      -0.760  -8.693  -0.393  1.00 37.79           H 
ATOM    669 2HB  ASP    41      -0.898  -9.812   0.961  1.00 37.79           H 
ATOM    670  N   GLU    42       0.264  -9.619   3.265  1.00 33.43           N 
ATOM    671  CA  GLU    42       0.686 -10.302   4.497  1.00 30.03           C 
ATOM    672  C   GLU    42       1.770 -11.373   4.238  1.00 44.33           C 
ATOM    673  O   GLU    42       2.614 -11.632   5.101  1.00  1.33           O 
ATOM    674  CB  GLU    42      -0.529 -10.929   5.199  1.00 31.13           C 
ATOM    675  CG  GLU    42      -0.197 -11.581   6.539  1.00 41.33           C 
ATOM    676  CD  GLU    42      -1.431 -12.061   7.288  1.00 40.40           C 
ATOM    677  OE1 GLU    42      -1.845 -11.389   8.255  1.00 71.24           O 
ATOM    678  OE2 GLU    42      -1.990 -13.113   6.913  1.00  3.14           O 
ATOM    679  H   GLU    42      -0.684  -9.624   3.020  1.00 37.79           H 
ATOM    680  HA  GLU    42       1.108  -9.551   5.152  1.00 54.42           H 
ATOM    681 1HB  GLU    42      -0.958 -11.681   4.552  1.00 37.79           H 
ATOM    682 2HB  GLU    42      -1.265 -10.156   5.373  1.00 37.79           H 
ATOM    683 1HG  GLU    42       0.324 -10.859   7.154  1.00 37.79           H 
ATOM    684 2HG  GLU    42       0.450 -12.429   6.362  1.00 37.79           H 
ATOM    685  N   ASP    43       1.760 -11.981   3.051  1.00 10.21           N 
ATOM    686  CA  ASP    43       2.767 -12.993   2.700  1.00 33.34           C 
ATOM    687  C   ASP    43       4.076 -12.326   2.227  1.00 40.05           C 
ATOM    688  O   ASP    43       5.127 -12.968   2.153  1.00 61.13           O 
ATOM    689  CB  ASP    43       2.217 -13.940   1.623  1.00 11.54           C 
ATOM    690  CG  ASP    43       3.161 -15.093   1.316  1.00 51.55           C 
ATOM    691  OD1 ASP    43       3.563 -15.803   2.261  1.00 45.42           O 
ATOM    692  OD2 ASP    43       3.492 -15.308   0.129  1.00 43.34           O 
ATOM    693  H   ASP    43       1.073 -11.743   2.394  1.00 37.79           H 
ATOM    694  HA  ASP    43       2.979 -13.567   3.593  1.00 20.33           H 
ATOM    695 1HB  ASP    43       2.049 -13.380   0.713  1.00 37.79           H 
ATOM    696 2HB  ASP    43       1.277 -14.352   1.962  1.00 37.79           H 
ATOM    697  N   GLY    44       4.004 -11.035   1.912  1.00 12.42           N 
ATOM    698  CA  GLY    44       5.191 -10.275   1.530  1.00 42.21           C 
ATOM    699  C   GLY    44       5.411 -10.188   0.022  1.00 44.44           C 
ATOM    700  O   GLY    44       6.471  -9.749  -0.430  1.00 65.25           O 
ATOM    701  H   GLY    44       3.132 -10.587   1.946  1.00 37.79           H 
ATOM    702 1HA  GLY    44       6.059 -10.735   1.980  1.00 37.79           H 
ATOM    703 2HA  GLY    44       5.095  -9.272   1.919  1.00 37.79           H 
ATOM    704  N   VAL    45       4.420 -10.600  -0.765  1.00 43.22           N 
ATOM    705  CA  VAL    45       4.533 -10.536  -2.227  1.00  2.11           C 
ATOM    706  C   VAL    45       4.348  -9.093  -2.724  1.00  0.42           C 
ATOM    707  O   VAL    45       3.403  -8.407  -2.331  1.00 64.13           O 
ATOM    708  CB  VAL    45       3.504 -11.462  -2.920  1.00 34.25           C 
ATOM    709  CG1 VAL    45       3.731 -11.503  -4.430  1.00 53.21           C 
ATOM    710  CG2 VAL    45       3.555 -12.864  -2.319  1.00 25.44           C 
ATOM    711  H   VAL    45       3.598 -10.949  -0.359  1.00 37.79           H 
ATOM    712  HA  VAL    45       5.528 -10.874  -2.496  1.00 53.41           H 
ATOM    713  HB  VAL    45       2.516 -11.059  -2.743  1.00 55.33           H 
ATOM    714 1HG1 VAL    45       3.597 -10.513  -4.841  1.00 37.79           H 
ATOM    715 2HG1 VAL    45       3.019 -12.179  -4.884  1.00 37.79           H 
ATOM    716 3HG1 VAL    45       4.734 -11.846  -4.637  1.00 37.79           H 
ATOM    717 1HG2 VAL    45       4.545 -13.276  -2.443  1.00 37.79           H 
ATOM    718 2HG2 VAL    45       2.836 -13.498  -2.820  1.00 37.79           H 
ATOM    719 3HG2 VAL    45       3.314 -12.813  -1.266  1.00 37.79           H 
ATOM    720  N   LYS    46       5.247  -8.640  -3.596  1.00 54.35           N 
ATOM    721  CA  LYS    46       5.262  -7.241  -4.027  1.00 10.30           C 
ATOM    722  C   LYS    46       3.981  -6.838  -4.779  1.00  5.11           C 
ATOM    723  O   LYS    46       3.448  -7.593  -5.594  1.00 22.04           O 
ATOM    724  CB  LYS    46       6.490  -6.958  -4.898  1.00 70.52           C 
ATOM    725  CG  LYS    46       6.629  -5.487  -5.273  1.00 32.21           C 
ATOM    726  CD  LYS    46       7.899  -5.207  -6.068  1.00 52.33           C 
ATOM    727  CE  LYS    46       8.023  -3.728  -6.407  1.00 24.42           C 
ATOM    728  NZ  LYS    46       9.285  -3.420  -7.127  1.00 32.13           N 
ATOM    729  H   LYS    46       5.913  -9.259  -3.959  1.00 37.79           H 
ATOM    730  HA  LYS    46       5.335  -6.635  -3.134  1.00 55.44           H 
ATOM    731 1HB  LYS    46       6.412  -7.534  -5.808  1.00 37.79           H 
ATOM    732 2HB  LYS    46       7.380  -7.264  -4.363  1.00 37.79           H 
ATOM    733 1HG  LYS    46       6.643  -4.896  -4.367  1.00 37.79           H 
ATOM    734 2HG  LYS    46       5.775  -5.199  -5.873  1.00 37.79           H 
ATOM    735 1HD  LYS    46       7.870  -5.774  -6.988  1.00 37.79           H 
ATOM    736 2HD  LYS    46       8.758  -5.508  -5.484  1.00 37.79           H 
ATOM    737 1HE  LYS    46       7.992  -3.155  -5.491  1.00 37.79           H 
ATOM    738 2HE  LYS    46       7.189  -3.444  -7.033  1.00 37.79           H 
ATOM    739 1HZ  LYS    46      10.105  -3.689  -6.547  1.00 37.79           H 
ATOM    740 2HZ  LYS    46       9.341  -2.403  -7.337  1.00 37.79           H 
ATOM    741 3HZ  LYS    46       9.321  -3.945  -8.021  1.00 37.79           H 
ATOM    742  N   LYS    47       3.507  -5.633  -4.485  1.00 65.11           N 
ATOM    743  CA  LYS    47       2.312  -5.055  -5.106  1.00 12.42           C 
ATOM    744  C   LYS    47       2.574  -3.587  -5.473  1.00 60.21           C 
ATOM    745  O   LYS    47       3.574  -3.002  -5.049  1.00 74.33           O 
ATOM    746  CB  LYS    47       1.117  -5.133  -4.136  1.00  2.20           C 
ATOM    747  CG  LYS    47       0.718  -6.551  -3.730  1.00 54.23           C 
ATOM    748  CD  LYS    47       0.148  -7.342  -4.903  1.00 44.32           C 
ATOM    749  CE  LYS    47      -0.235  -8.762  -4.495  1.00 52.11           C 
ATOM    750  NZ  LYS    47       0.940  -9.549  -4.035  1.00 24.05           N 
ATOM    751  H   LYS    47       3.986  -5.098  -3.821  1.00 37.79           H 
ATOM    752  HA  LYS    47       2.084  -5.609  -6.005  1.00 25.00           H 
ATOM    753 1HB  LYS    47       0.261  -4.660  -4.600  1.00 37.79           H 
ATOM    754 2HB  LYS    47       1.368  -4.588  -3.236  1.00 37.79           H 
ATOM    755 1HG  LYS    47      -0.029  -6.494  -2.949  1.00 37.79           H 
ATOM    756 2HG  LYS    47       1.592  -7.066  -3.354  1.00 37.79           H 
ATOM    757 1HD  LYS    47       0.891  -7.390  -5.688  1.00 37.79           H 
ATOM    758 2HD  LYS    47      -0.733  -6.835  -5.273  1.00 37.79           H 
ATOM    759 1HE  LYS    47      -0.679  -9.261  -5.347  1.00 37.79           H 
ATOM    760 2HE  LYS    47      -0.958  -8.712  -3.694  1.00 37.79           H 
ATOM    761 1HZ  LYS    47       1.355  -9.114  -3.181  1.00 37.79           H 
ATOM    762 2HZ  LYS    47       1.663  -9.584  -4.779  1.00 37.79           H 
ATOM    763 3HZ  LYS    47       0.651 -10.520  -3.803  1.00 37.79           H 
ATOM    764  N   GLN    48       1.687  -2.994  -6.262  1.00 41.13           N 
ATOM    765  CA  GLN    48       1.772  -1.563  -6.575  1.00 14.12           C 
ATOM    766  C   GLN    48       0.375  -0.925  -6.557  1.00 12.32           C 
ATOM    767  O   GLN    48      -0.478  -1.255  -7.380  1.00  3.41           O 
ATOM    768  CB  GLN    48       2.450  -1.343  -7.935  1.00 72.20           C 
ATOM    769  CG  GLN    48       2.762   0.122  -8.229  1.00 42.23           C 
ATOM    770  CD  GLN    48       3.547   0.309  -9.513  1.00 13.05           C 
ATOM    771  OE1 GLN    48       4.777   0.300  -9.512  1.00 73.54           O 
ATOM    772  NE2 GLN    48       2.849   0.479 -10.616  1.00 31.21           N 
ATOM    773  H   GLN    48       0.958  -3.527  -6.648  1.00 37.79           H 
ATOM    774  HA  GLN    48       2.374  -1.094  -5.806  1.00 52.12           H 
ATOM    775 1HB  GLN    48       1.800  -1.716  -8.714  1.00 37.79           H 
ATOM    776 2HB  GLN    48       3.377  -1.900  -7.957  1.00 37.79           H 
ATOM    777 1HG  GLN    48       3.339   0.527  -7.410  1.00 37.79           H 
ATOM    778 2HG  GLN    48       1.831   0.666  -8.312  1.00 37.79           H 
ATOM    779 1HE2 GLN    48       1.875   0.470 -10.553  1.00 37.79           H 
ATOM    780 2HE2 GLN    48       3.339   0.619 -11.452  1.00 37.79           H 
ATOM    781  N   ILE    49       0.146  -0.011  -5.615  1.00 63.01           N 
ATOM    782  CA  ILE    49      -1.192   0.556  -5.398  1.00 42.34           C 
ATOM    783  C   ILE    49      -1.189   2.093  -5.480  1.00 34.32           C 
ATOM    784  O   ILE    49      -0.243   2.753  -5.045  1.00 62.45           O 
ATOM    785  CB  ILE    49      -1.758   0.108  -4.020  1.00 22.44           C 
ATOM    786  CG1 ILE    49      -1.835  -1.429  -3.946  1.00 34.13           C 
ATOM    787  CG2 ILE    49      -3.131   0.734  -3.753  1.00 42.50           C 
ATOM    788  CD1 ILE    49      -2.295  -1.962  -2.604  1.00 41.43           C 
ATOM    789  H   ILE    49       0.894   0.298  -5.057  1.00 37.79           H 
ATOM    790  HA  ILE    49      -1.847   0.171  -6.171  1.00 72.51           H 
ATOM    791  HB  ILE    49      -1.081   0.458  -3.254  1.00 74.33           H 
ATOM    792 1HG1 ILE    49      -0.855  -1.840  -4.145  1.00 37.79           H 
ATOM    793 2HG1 ILE    49      -2.526  -1.786  -4.694  1.00 37.79           H 
ATOM    794 1HG2 ILE    49      -3.499   0.399  -2.795  1.00 37.79           H 
ATOM    795 2HG2 ILE    49      -3.823   0.438  -4.528  1.00 37.79           H 
ATOM    796 3HG2 ILE    49      -3.042   1.812  -3.745  1.00 37.79           H 
ATOM    797 1HD1 ILE    49      -1.606  -1.646  -1.834  1.00 37.79           H 
ATOM    798 2HD1 ILE    49      -2.324  -3.041  -2.638  1.00 37.79           H 
ATOM    799 3HD1 ILE    49      -3.282  -1.582  -2.382  1.00 37.79           H 
ATOM    800  N   THR    50      -2.260   2.650  -6.049  1.00 12.32           N 
ATOM    801  CA  THR    50      -2.417   4.108  -6.182  1.00 23.40           C 
ATOM    802  C   THR    50      -3.593   4.624  -5.336  1.00 43.22           C 
ATOM    803  O   THR    50      -4.733   4.196  -5.519  1.00  1.20           O 
ATOM    804  CB  THR    50      -2.647   4.521  -7.662  1.00 13.23           C 
ATOM    805  OG1 THR    50      -1.533   4.108  -8.468  1.00 53.32           O 
ATOM    806  CG2 THR    50      -2.837   6.033  -7.801  1.00 70.42           C 
ATOM    807  H   THR    50      -2.967   2.066  -6.393  1.00 37.79           H 
ATOM    808  HA  THR    50      -1.505   4.578  -5.837  1.00 33.34           H 
ATOM    809  HB  THR    50      -3.540   4.027  -8.023  1.00 52.11           H 
ATOM    810  HG1 THR    50      -1.832   3.953  -9.375  1.00 21.21           H 
ATOM    811 1HG2 THR    50      -2.995   6.283  -8.842  1.00 37.79           H 
ATOM    812 2HG2 THR    50      -1.957   6.544  -7.440  1.00 37.79           H 
ATOM    813 3HG2 THR    50      -3.695   6.342  -7.222  1.00 37.79           H 
ATOM    814  N   PHE    51      -3.313   5.548  -4.417  1.00 61.31           N 
ATOM    815  CA  PHE    51      -4.349   6.121  -3.544  1.00 61.02           C 
ATOM    816  C   PHE    51      -4.439   7.651  -3.699  1.00  3.32           C 
ATOM    817  O   PHE    51      -3.613   8.272  -4.370  1.00 14.14           O 
ATOM    818  CB  PHE    51      -4.083   5.752  -2.072  1.00  2.33           C 
ATOM    819  CG  PHE    51      -2.799   6.319  -1.506  1.00 44.42           C 
ATOM    820  CD1 PHE    51      -1.578   5.704  -1.753  1.00 41.41           C 
ATOM    821  CD2 PHE    51      -2.818   7.465  -0.719  1.00 23.55           C 
ATOM    822  CE1 PHE    51      -0.407   6.223  -1.232  1.00 12.42           C 
ATOM    823  CE2 PHE    51      -1.649   7.986  -0.197  1.00 30.20           C 
ATOM    824  CZ  PHE    51      -0.444   7.364  -0.452  1.00 12.21           C 
ATOM    825  H   PHE    51      -2.387   5.859  -4.324  1.00 37.79           H 
ATOM    826  HA  PHE    51      -5.299   5.697  -3.839  1.00 75.34           H 
ATOM    827 1HB  PHE    51      -4.039   4.675  -1.984  1.00 37.79           H 
ATOM    828 2HB  PHE    51      -4.901   6.117  -1.466  1.00 37.79           H 
ATOM    829  HD1 PHE    51      -1.547   4.812  -2.363  1.00 53.43           H 
ATOM    830  HD2 PHE    51      -3.761   7.954  -0.517  1.00 71.12           H 
ATOM    831  HE1 PHE    51       0.535   5.734  -1.430  1.00 24.20           H 
ATOM    832  HE2 PHE    51      -1.679   8.879   0.411  1.00 10.11           H 
ATOM    833  HZ  PHE    51       0.471   7.770  -0.044  1.00 51.34           H 
ATOM    834  N   ARG    52      -5.451   8.250  -3.073  1.00 14.43           N 
ATOM    835  CA  ARG    52      -5.648   9.703  -3.126  1.00 61.04           C 
ATOM    836  C   ARG    52      -6.253  10.226  -1.813  1.00 60.55           C 
ATOM    837  O   ARG    52      -6.974   9.505  -1.120  1.00 50.23           O 
ATOM    838  CB  ARG    52      -6.553  10.078  -4.314  1.00 11.20           C 
ATOM    839  CG  ARG    52      -6.758  11.583  -4.487  1.00 12.44           C 
ATOM    840  CD  ARG    52      -7.656  11.902  -5.677  1.00 33.42           C 
ATOM    841  NE  ARG    52      -8.997  11.343  -5.518  1.00 12.14           N 
ATOM    842  CZ  ARG    52      -9.762  10.979  -6.509  1.00 71.40           C 
ATOM    843  NH1 ARG    52      -9.366  11.120  -7.735  1.00  2.21           N 
ATOM    844  NH2 ARG    52     -10.926  10.479  -6.271  1.00 34.31           N 
ATOM    845  H   ARG    52      -6.080   7.704  -2.560  1.00 37.79           H 
ATOM    846  HA  ARG    52      -4.680  10.165  -3.264  1.00 31.44           H 
ATOM    847 1HB  ARG    52      -7.521   9.617  -4.174  1.00 37.79           H 
ATOM    848 2HB  ARG    52      -6.110   9.692  -5.221  1.00 37.79           H 
ATOM    849 1HG  ARG    52      -5.796  12.053  -4.638  1.00 37.79           H 
ATOM    850 2HG  ARG    52      -7.214  11.979  -3.591  1.00 37.79           H 
ATOM    851 1HD  ARG    52      -7.206  11.491  -6.572  1.00 37.79           H 
ATOM    852 2HD  ARG    52      -7.734  12.976  -5.778  1.00 37.79           H 
ATOM    853  HE  ARG    52      -9.341  11.240  -4.606  1.00 63.42           H 
ATOM    854 1HH1 ARG    52      -8.474  11.510  -7.927  1.00 37.79           H 
ATOM    855 2HH1 ARG    52      -9.964  10.845  -8.487  1.00 37.79           H 
ATOM    856 1HH2 ARG    52     -11.241  10.374  -5.331  1.00 37.79           H 
ATOM    857 2HH2 ARG    52     -11.512  10.199  -7.031  1.00 37.79           H 
ATOM   1084  N   ALA    66       7.886   6.509   6.773  1.00 33.30           N 
ATOM   1085  CA  ALA    66       6.896   5.734   7.524  1.00 61.21           C 
ATOM   1086  C   ALA    66       6.144   4.745   6.622  1.00 32.42           C 
ATOM   1087  O   ALA    66       6.234   4.807   5.393  1.00 74.34           O 
ATOM   1088  CB  ALA    66       5.910   6.673   8.214  1.00 33.23           C 
ATOM   1089  H   ALA    66       7.704   7.454   6.597  1.00 37.79           H 
ATOM   1090  HA  ALA    66       7.418   5.179   8.290  1.00 21.04           H 
ATOM   1091 1HB  ALA    66       6.449   7.363   8.846  1.00 37.79           H 
ATOM   1092 2HB  ALA    66       5.221   6.097   8.817  1.00 37.79           H 
ATOM   1093 3HB  ALA    66       5.358   7.227   7.468  1.00 37.79           H 
ATOM   1094  N   PHE    67       5.385   3.847   7.242  1.00 24.01           N 
ATOM   1095  CA  PHE    67       4.688   2.787   6.514  1.00 25.55           C 
ATOM   1096  C   PHE    67       3.168   3.004   6.510  1.00 55.04           C 
ATOM   1097  O   PHE    67       2.639   3.845   7.236  1.00 71.21           O 
ATOM   1098  CB  PHE    67       5.033   1.423   7.125  1.00 72.14           C 
ATOM   1099  CG  PHE    67       6.517   1.142   7.151  1.00 61.03           C 
ATOM   1100  CD1 PHE    67       7.147   0.552   6.063  1.00  1.43           C 
ATOM   1101  CD2 PHE    67       7.284   1.478   8.258  1.00 21.24           C 
ATOM   1102  CE1 PHE    67       8.507   0.304   6.080  1.00 42.30           C 
ATOM   1103  CE2 PHE    67       8.644   1.230   8.279  1.00 14.12           C 
ATOM   1104  CZ  PHE    67       9.256   0.642   7.189  1.00 50.14           C 
ATOM   1105  H   PHE    67       5.279   3.903   8.215  1.00 37.79           H 
ATOM   1106  HA  PHE    67       5.039   2.803   5.491  1.00 73.32           H 
ATOM   1107 1HB  PHE    67       4.555   0.641   6.548  1.00 37.79           H 
ATOM   1108 2HB  PHE    67       4.667   1.386   8.141  1.00 37.79           H 
ATOM   1109  HD1 PHE    67       6.564   0.284   5.194  1.00  0.25           H 
ATOM   1110  HD2 PHE    67       6.808   1.938   9.112  1.00 22.25           H 
ATOM   1111  HE1 PHE    67       8.983  -0.155   5.225  1.00  1.04           H 
ATOM   1112  HE2 PHE    67       9.227   1.495   9.147  1.00 75.12           H 
ATOM   1113  HZ  PHE    67      10.319   0.447   7.204  1.00 74.31           H 
ATOM   1114  N   LEU    68       2.478   2.231   5.683  1.00 35.22           N 
ATOM   1115  CA  LEU    68       1.029   2.328   5.527  1.00 15.24           C 
ATOM   1116  C   LEU    68       0.387   0.939   5.574  1.00 62.43           C 
ATOM   1117  O   LEU    68       1.025  -0.068   5.270  1.00  2.30           O 
ATOM   1118  CB  LEU    68       0.661   3.011   4.198  1.00 72.32           C 
ATOM   1119  CG  LEU    68       1.066   4.487   4.065  1.00  0.21           C 
ATOM   1120  CD1 LEU    68       0.669   5.028   2.693  1.00 24.04           C 
ATOM   1121  CD2 LEU    68       0.438   5.325   5.176  1.00 44.23           C 
ATOM   1122  H   LEU    68       2.958   1.555   5.171  1.00 37.79           H 
ATOM   1123  HA  LEU    68       0.641   2.919   6.347  1.00 44.13           H 
ATOM   1124 1HB  LEU    68      -0.412   2.943   4.069  1.00 37.79           H 
ATOM   1125 2HB  LEU    68       1.133   2.459   3.397  1.00 37.79           H 
ATOM   1126  HG  LEU    68       2.141   4.566   4.153  1.00 14.14           H 
ATOM   1127 1HD1 LEU    68       1.167   4.457   1.923  1.00 37.79           H 
ATOM   1128 2HD1 LEU    68       0.962   6.065   2.617  1.00 37.79           H 
ATOM   1129 3HD1 LEU    68      -0.401   4.946   2.566  1.00 37.79           H 
ATOM   1130 1HD2 LEU    68      -0.639   5.257   5.118  1.00 37.79           H 
ATOM   1131 2HD2 LEU    68       0.741   6.356   5.066  1.00 37.79           H 
ATOM   1132 3HD2 LEU    68       0.769   4.956   6.136  1.00 37.79           H 
ATOM   1133  N   ARG    69      -0.881   0.906   5.939  1.00 72.04           N 
ATOM   1134  CA  ARG    69      -1.646  -0.331   6.041  1.00 31.20           C 
ATOM   1135  C   ARG    69      -2.964  -0.175   5.274  1.00 32.31           C 
ATOM   1136  O   ARG    69      -3.812   0.630   5.647  1.00 22.14           O 
ATOM   1137  CB  ARG    69      -1.899  -0.600   7.530  1.00 41.14           C 
ATOM   1138  CG  ARG    69      -2.595  -1.915   7.863  1.00 34.12           C 
ATOM   1139  CD  ARG    69      -2.746  -2.052   9.373  1.00 73.44           C 
ATOM   1140  NE  ARG    69      -3.442  -3.266   9.785  1.00 34.12           N 
ATOM   1141  CZ  ARG    69      -3.940  -3.428  10.981  1.00 45.14           C 
ATOM   1142  NH1 ARG    69      -3.904  -2.460  11.843  1.00 23.24           N 
ATOM   1143  NH2 ARG    69      -4.503  -4.544  11.308  1.00 21.24           N 
ATOM   1144  H   ARG    69      -1.323   1.748   6.155  1.00 37.79           H 
ATOM   1145  HA  ARG    69      -1.067  -1.140   5.616  1.00 13.24           H 
ATOM   1146 1HB  ARG    69      -2.505   0.207   7.923  1.00 37.79           H 
ATOM   1147 2HB  ARG    69      -0.949  -0.593   8.044  1.00 37.79           H 
ATOM   1148 1HG  ARG    69      -2.002  -2.737   7.489  1.00 37.79           H 
ATOM   1149 2HG  ARG    69      -3.574  -1.926   7.403  1.00 37.79           H 
ATOM   1150 1HD  ARG    69      -3.297  -1.194   9.739  1.00 37.79           H 
ATOM   1151 2HD  ARG    69      -1.762  -2.053   9.818  1.00 37.79           H 
ATOM   1152  HE  ARG    69      -3.515  -3.994   9.142  1.00  1.31           H 
ATOM   1153 1HH1 ARG    69      -3.496  -1.580  11.593  1.00 37.79           H 
ATOM   1154 2HH1 ARG    69      -4.278  -2.594  12.758  1.00 37.79           H 
ATOM   1155 1HH2 ARG    69      -4.560  -5.290  10.647  1.00 37.79           H 
ATOM   1156 2HH2 ARG    69      -4.878  -4.659  12.224  1.00 37.79           H 
ATOM   1157  N   LEU    70      -3.132  -0.943   4.204  1.00 20.55           N 
ATOM   1158  CA  LEU    70      -4.292  -0.796   3.320  1.00 33.33           C 
ATOM   1159  C   LEU    70      -5.294  -1.938   3.514  1.00 12.31           C 
ATOM   1160  O   LEU    70      -4.933  -3.118   3.489  1.00 73.23           O 
ATOM   1161  CB  LEU    70      -3.854  -0.723   1.842  1.00 62.21           C 
ATOM   1162  CG  LEU    70      -3.135   0.575   1.407  1.00 75.23           C 
ATOM   1163  CD1 LEU    70      -1.827   0.781   2.170  1.00 73.03           C 
ATOM   1164  CD2 LEU    70      -2.881   0.569  -0.097  1.00 15.32           C 
ATOM   1165  H   LEU    70      -2.464  -1.628   4.001  1.00 37.79           H 
ATOM   1166  HA  LEU    70      -4.783   0.134   3.578  1.00  3.31           H 
ATOM   1167 1HB  LEU    70      -4.733  -0.842   1.223  1.00 37.79           H 
ATOM   1168 2HB  LEU    70      -3.190  -1.554   1.650  1.00 37.79           H 
ATOM   1169  HG  LEU    70      -3.777   1.417   1.627  1.00  5.31           H 
ATOM   1170 1HD1 LEU    70      -1.176  -0.066   2.009  1.00 37.79           H 
ATOM   1171 2HD1 LEU    70      -2.036   0.878   3.225  1.00 37.79           H 
ATOM   1172 3HD1 LEU    70      -1.339   1.680   1.818  1.00 37.79           H 
ATOM   1173 1HD2 LEU    70      -3.822   0.504  -0.623  1.00 37.79           H 
ATOM   1174 2HD2 LEU    70      -2.266  -0.281  -0.356  1.00 37.79           H 
ATOM   1175 3HD2 LEU    70      -2.373   1.480  -0.383  1.00 37.79           H 
ATOM   1176  N   TYR    71      -6.554  -1.572   3.705  1.00  4.11           N 
ATOM   1177  CA  TYR    71      -7.629  -2.541   3.923  1.00 10.13           C 
ATOM   1178  C   TYR    71      -8.475  -2.719   2.657  1.00 15.31           C 
ATOM   1179  O   TYR    71      -9.033  -1.753   2.128  1.00 52.43           O 
ATOM   1180  CB  TYR    71      -8.522  -2.073   5.079  1.00  1.32           C 
ATOM   1181  CG  TYR    71      -7.754  -1.742   6.347  1.00 20.41           C 
ATOM   1182  CD1 TYR    71      -7.517  -0.420   6.716  1.00 63.43           C 
ATOM   1183  CD2 TYR    71      -7.263  -2.749   7.170  1.00 71.51           C 
ATOM   1184  CE1 TYR    71      -6.818  -0.114   7.869  1.00 32.32           C 
ATOM   1185  CE2 TYR    71      -6.565  -2.449   8.324  1.00 14.31           C 
ATOM   1186  CZ  TYR    71      -6.345  -1.131   8.667  1.00 12.13           C 
ATOM   1187  OH  TYR    71      -5.649  -0.833   9.816  1.00 52.25           O 
ATOM   1188  H   TYR    71      -6.772  -0.618   3.704  1.00 37.79           H 
ATOM   1189  HA  TYR    71      -7.183  -3.490   4.185  1.00 71.44           H 
ATOM   1190 1HB  TYR    71      -9.234  -2.852   5.314  1.00 37.79           H 
ATOM   1191 2HB  TYR    71      -9.059  -1.185   4.774  1.00 37.79           H 
ATOM   1192  HD1 TYR    71      -7.889   0.376   6.089  1.00 20.44           H 
ATOM   1193  HD2 TYR    71      -7.435  -3.782   6.901  1.00 52.23           H 
ATOM   1194  HE1 TYR    71      -6.644   0.918   8.138  1.00 35.22           H 
ATOM   1195  HE2 TYR    71      -6.193  -3.246   8.951  1.00 22.14           H 
ATOM   1196  HH  TYR    71      -6.100  -0.128  10.295  1.00 71.31           H 
ATOM   1197  N   VAL    72      -8.558  -3.951   2.167  1.00 31.02           N 
ATOM   1198  CA  VAL    72      -9.406  -4.271   1.016  1.00 71.24           C 
ATOM   1199  C   VAL    72     -10.546  -5.213   1.432  1.00 53.44           C 
ATOM   1200  O   VAL    72     -10.357  -6.114   2.254  1.00 50.24           O 
ATOM   1201  CB  VAL    72      -8.584  -4.905  -0.138  1.00 55.51           C 
ATOM   1202  CG1 VAL    72      -7.912  -6.202   0.306  1.00 24.42           C 
ATOM   1203  CG2 VAL    72      -9.456  -5.135  -1.372  1.00 31.30           C 
ATOM   1204  H   VAL    72      -8.036  -4.668   2.588  1.00 37.79           H 
ATOM   1205  HA  VAL    72      -9.839  -3.345   0.653  1.00 25.11           H 
ATOM   1206  HB  VAL    72      -7.803  -4.207  -0.409  1.00 74.53           H 
ATOM   1207 1HG1 VAL    72      -8.665  -6.920   0.598  1.00 37.79           H 
ATOM   1208 2HG1 VAL    72      -7.259  -6.005   1.146  1.00 37.79           H 
ATOM   1209 3HG1 VAL    72      -7.332  -6.603  -0.512  1.00 37.79           H 
ATOM   1210 1HG2 VAL    72      -8.857  -5.570  -2.160  1.00 37.79           H 
ATOM   1211 2HG2 VAL    72      -9.861  -4.191  -1.710  1.00 37.79           H 
ATOM   1212 3HG2 VAL    72     -10.267  -5.806  -1.125  1.00 37.79           H 
ATOM   1433  N   LYS    88     -10.565   0.120   0.556  1.00 13.14           N 
ATOM   1434  CA  LYS    88     -11.628   0.878   1.232  1.00 34.52           C 
ATOM   1435  C   LYS    88     -11.065   1.902   2.233  1.00 74.05           C 
ATOM   1436  O   LYS    88     -11.679   2.943   2.476  1.00 35.55           O 
ATOM   1437  CB  LYS    88     -12.598  -0.087   1.938  1.00  4.12           C 
ATOM   1438  CG  LYS    88     -11.936  -1.000   2.970  1.00 35.03           C 
ATOM   1439  CD  LYS    88     -12.904  -2.045   3.527  1.00 34.12           C 
ATOM   1440  CE  LYS    88     -14.118  -1.413   4.198  1.00 34.05           C 
ATOM   1441  NZ  LYS    88     -15.086  -2.440   4.666  1.00 62.25           N 
ATOM   1442  H   LYS    88     -10.290  -0.747   0.923  1.00 37.79           H 
ATOM   1443  HA  LYS    88     -12.177   1.417   0.470  1.00 54.25           H 
ATOM   1444 1HB  LYS    88     -13.070  -0.709   1.190  1.00 37.79           H 
ATOM   1445 2HB  LYS    88     -13.361   0.493   2.439  1.00 37.79           H 
ATOM   1446 1HG  LYS    88     -11.566  -0.393   3.785  1.00 37.79           H 
ATOM   1447 2HG  LYS    88     -11.110  -1.513   2.500  1.00 37.79           H 
ATOM   1448 1HD  LYS    88     -12.379  -2.651   4.252  1.00 37.79           H 
ATOM   1449 2HD  LYS    88     -13.244  -2.673   2.717  1.00 37.79           H 
ATOM   1450 1HE  LYS    88     -14.610  -0.763   3.490  1.00 37.79           H 
ATOM   1451 2HE  LYS    88     -13.785  -0.833   5.047  1.00 37.79           H 
ATOM   1452 1HZ  LYS    88     -15.374  -3.052   3.875  1.00 37.79           H 
ATOM   1453 2HZ  LYS    88     -15.933  -1.983   5.056  1.00 37.79           H 
ATOM   1454 3HZ  LYS    88     -14.657  -3.030   5.405  1.00 37.79           H 
ATOM   1455  N   SER    89      -9.898   1.608   2.810  1.00 25.23           N 
ATOM   1456  CA  SER    89      -9.257   2.510   3.789  1.00 12.22           C 
ATOM   1457  C   SER    89      -7.758   2.223   3.926  1.00 42.34           C 
ATOM   1458  O   SER    89      -7.279   1.170   3.508  1.00 60.11           O 
ATOM   1459  CB  SER    89      -9.916   2.387   5.175  1.00 73.00           C 
ATOM   1460  OG  SER    89     -11.252   2.865   5.172  1.00 43.43           O 
ATOM   1461  H   SER    89      -9.448   0.771   2.567  1.00 37.79           H 
ATOM   1462  HA  SER    89      -9.382   3.523   3.432  1.00 45.21           H 
ATOM   1463 1HB  SER    89      -9.347   2.962   5.893  1.00 37.79           H 
ATOM   1464 2HB  SER    89      -9.925   1.350   5.477  1.00 37.79           H 
ATOM   1465  HG  SER    89     -11.439   3.292   4.326  1.00 35.04           H 
ATOM   1466  N   TYR    90      -7.022   3.162   4.527  1.00 22.31           N 
ATOM   1467  CA  TYR    90      -5.592   2.966   4.800  1.00 52.02           C 
ATOM   1468  C   TYR    90      -5.207   3.534   6.180  1.00 25.35           C 
ATOM   1469  O   TYR    90      -5.932   4.348   6.755  1.00 34.33           O 
ATOM   1470  CB  TYR    90      -4.723   3.600   3.698  1.00  3.22           C 
ATOM   1471  CG  TYR    90      -4.642   5.117   3.751  1.00 12.41           C 
ATOM   1472  CD1 TYR    90      -3.506   5.753   4.246  1.00 14.15           C 
ATOM   1473  CD2 TYR    90      -5.697   5.910   3.312  1.00  1.54           C 
ATOM   1474  CE1 TYR    90      -3.426   7.130   4.300  1.00 61.11           C 
ATOM   1475  CE2 TYR    90      -5.620   7.287   3.362  1.00  4.32           C 
ATOM   1476  CZ  TYR    90      -4.484   7.891   3.858  1.00 71.13           C 
ATOM   1477  OH  TYR    90      -4.410   9.262   3.914  1.00 41.41           O 
ATOM   1478  H   TYR    90      -7.447   4.003   4.793  1.00 37.79           H 
ATOM   1479  HA  TYR    90      -5.407   1.900   4.812  1.00 71.54           H 
ATOM   1480 1HB  TYR    90      -5.124   3.323   2.732  1.00 37.79           H 
ATOM   1481 2HB  TYR    90      -3.717   3.214   3.782  1.00 37.79           H 
ATOM   1482  HD1 TYR    90      -2.675   5.153   4.591  1.00 33.40           H 
ATOM   1483  HD2 TYR    90      -6.586   5.436   2.926  1.00 13.12           H 
ATOM   1484  HE1 TYR    90      -2.535   7.605   4.687  1.00 45.53           H 
ATOM   1485  HE2 TYR    90      -6.450   7.887   3.016  1.00 23.03           H 
ATOM   1486  HH  TYR    90      -5.216   9.603   4.315  1.00  4.41           H 
ATOM   1487  N   GLU    91      -4.061   3.101   6.694  1.00  3.42           N 
ATOM   1488  CA  GLU    91      -3.603   3.473   8.042  1.00 74.55           C 
ATOM   1489  C   GLU    91      -2.085   3.735   8.057  1.00 64.43           C 
ATOM   1490  O   GLU    91      -1.325   2.996   7.444  1.00 14.34           O 
ATOM   1491  CB  GLU    91      -3.963   2.331   9.010  1.00 43.34           C 
ATOM   1492  CG  GLU    91      -3.512   2.534  10.455  1.00 75.05           C 
ATOM   1493  CD  GLU    91      -3.979   1.404  11.367  1.00  3.12           C 
ATOM   1494  OE1 GLU    91      -3.203   0.448  11.599  1.00  3.41           O 
ATOM   1495  OE2 GLU    91      -5.133   1.462  11.849  1.00 20.45           O 
ATOM   1496  H   GLU    91      -3.506   2.499   6.158  1.00 37.79           H 
ATOM   1497  HA  GLU    91      -4.122   4.373   8.344  1.00  1.55           H 
ATOM   1498 1HB  GLU    91      -3.513   1.417   8.644  1.00 37.79           H 
ATOM   1499 2HB  GLU    91      -5.036   2.209   9.011  1.00 37.79           H 
ATOM   1500 1HG  GLU    91      -3.917   3.468  10.821  1.00 37.79           H 
ATOM   1501 2HG  GLU    91      -2.432   2.579  10.479  1.00 37.79           H 
ATOM   1502  N   GLU    92      -1.642   4.781   8.754  1.00 12.34           N 
ATOM   1503  CA  GLU    92      -0.203   5.086   8.848  1.00 71.13           C 
ATOM   1504  C   GLU    92       0.418   4.348  10.044  1.00 52.44           C 
ATOM   1505  O   GLU    92      -0.029   4.509  11.182  1.00 61.33           O 
ATOM   1506  CB  GLU    92       0.022   6.603   8.977  1.00 35.14           C 
ATOM   1507  CG  GLU    92       1.495   7.009   9.066  1.00 11.32           C 
ATOM   1508  CD  GLU    92       1.690   8.510   9.239  1.00 74.44           C 
ATOM   1509  OE1 GLU    92       1.086   9.085  10.172  1.00 65.13           O 
ATOM   1510  OE2 GLU    92       2.458   9.119   8.460  1.00 12.12           O 
ATOM   1511  H   GLU    92      -2.288   5.360   9.214  1.00 37.79           H 
ATOM   1512  HA  GLU    92       0.268   4.736   7.938  1.00 60.42           H 
ATOM   1513 1HB  GLU    92      -0.481   6.954   9.868  1.00 37.79           H 
ATOM   1514 2HB  GLU    92      -0.413   7.093   8.116  1.00 37.79           H 
ATOM   1515 1HG  GLU    92       1.996   6.694   8.161  1.00 37.79           H 
ATOM   1516 2HG  GLU    92       1.942   6.508   9.913  1.00 37.79           H 
ATOM   1517  N   ILE    93       1.441   3.534   9.781  1.00 73.20           N 
ATOM   1518  CA  ILE    93       2.008   2.638  10.800  1.00 20.14           C 
ATOM   1519  C   ILE    93       3.548   2.644  10.822  1.00 22.02           C 
ATOM   1520  O   ILE    93       4.205   3.283   9.994  1.00 32.45           O 
ATOM   1521  CB  ILE    93       1.531   1.178  10.581  1.00 24.51           C 
ATOM   1522  CG1 ILE    93       1.930   0.684   9.178  1.00 61.02           C 
ATOM   1523  CG2 ILE    93       0.021   1.066  10.788  1.00 55.35           C 
ATOM   1524  CD1 ILE    93       1.584  -0.768   8.912  1.00  1.24           C 
ATOM   1525  H   ILE    93       1.831   3.541   8.883  1.00 37.79           H 
ATOM   1526  HA  ILE    93       1.651   2.963  11.767  1.00 34.52           H 
ATOM   1527  HB  ILE    93       2.013   0.555  11.321  1.00 75.22           H 
ATOM   1528 1HG1 ILE    93       2.999   0.797   9.053  1.00 37.79           H 
ATOM   1529 2HG1 ILE    93       1.424   1.282   8.436  1.00 37.79           H 
ATOM   1530 1HG2 ILE    93      -0.280   0.032  10.698  1.00 37.79           H 
ATOM   1531 2HG2 ILE    93      -0.492   1.655  10.043  1.00 37.79           H 
ATOM   1532 3HG2 ILE    93      -0.236   1.429  11.774  1.00 37.79           H 
ATOM   1533 1HD1 ILE    93       1.851  -1.019   7.896  1.00 37.79           H 
ATOM   1534 2HD1 ILE    93       0.525  -0.920   9.053  1.00 37.79           H 
ATOM   1535 3HD1 ILE    93       2.134  -1.400   9.594  1.00 37.79           H 
ATOM   1536  N   GLN    94       4.107   1.907  11.782  1.00 25.52           N 
ATOM   1537  CA  GLN    94       5.559   1.754  11.921  1.00 31.04           C 
ATOM   1538  C   GLN    94       5.989   0.330  11.526  1.00 61.23           C 
ATOM   1539  O   GLN    94       5.148  -0.536  11.281  1.00 31.03           O 
ATOM   1540  CB  GLN    94       5.979   2.053  13.369  1.00 21.14           C 
ATOM   1541  CG  GLN    94       5.425   1.058  14.384  1.00  2.22           C 
ATOM   1542  CD  GLN    94       5.682   1.459  15.826  1.00 30.12           C 
ATOM   1543  OE1 GLN    94       6.704   1.116  16.411  1.00 11.24           O 
ATOM   1544  NE2 GLN    94       4.746   2.171  16.418  1.00  5.21           N 
ATOM   1545  H   GLN    94       3.521   1.437  12.416  1.00 37.79           H 
ATOM   1546  HA  GLN    94       6.040   2.461  11.259  1.00 33.05           H 
ATOM   1547 1HB  GLN    94       5.629   3.041  13.634  1.00 37.79           H 
ATOM   1548 2HB  GLN    94       7.059   2.036  13.430  1.00 37.79           H 
ATOM   1549 1HG  GLN    94       5.884   0.095  14.207  1.00 37.79           H 
ATOM   1550 2HG  GLN    94       4.358   0.974  14.237  1.00 37.79           H 
ATOM   1551 1HE2 GLN    94       3.944   2.401  15.904  1.00 37.79           H 
ATOM   1552 2HE2 GLN    94       4.889   2.436  17.348  1.00 37.79           H 
ATOM   1553  N   LYS    95       7.298   0.085  11.478  1.00  5.41           N 
ATOM   1554  CA  LYS    95       7.824  -1.236  11.098  1.00 60.52           C 
ATOM   1555  C   LYS    95       7.325  -2.344  12.049  1.00 64.21           C 
ATOM   1556  O   LYS    95       7.222  -3.509  11.660  1.00 61.24           O 
ATOM   1557  CB  LYS    95       9.358  -1.203  11.078  1.00 60.14           C 
ATOM   1558  CG  LYS    95      10.003  -2.482  10.550  1.00 42.14           C 
ATOM   1559  CD  LYS    95      11.525  -2.406  10.602  1.00 61.43           C 
ATOM   1560  CE  LYS    95      12.179  -3.706  10.147  1.00 51.12           C 
ATOM   1561  NZ  LYS    95      13.660  -3.649  10.257  1.00 60.40           N 
ATOM   1562  H   LYS    95       7.927   0.802  11.703  1.00 37.79           H 
ATOM   1563  HA  LYS    95       7.468  -1.454  10.101  1.00 70.35           H 
ATOM   1564 1HB  LYS    95       9.715  -1.033  12.085  1.00 37.79           H 
ATOM   1565 2HB  LYS    95       9.679  -0.380  10.453  1.00 37.79           H 
ATOM   1566 1HG  LYS    95       9.691  -2.635   9.525  1.00 37.79           H 
ATOM   1567 2HG  LYS    95       9.675  -3.315  11.156  1.00 37.79           H 
ATOM   1568 1HD  LYS    95      11.830  -2.196  11.618  1.00 37.79           H 
ATOM   1569 2HD  LYS    95      11.859  -1.607   9.955  1.00 37.79           H 
ATOM   1570 1HE  LYS    95      11.910  -3.891   9.117  1.00 37.79           H 
ATOM   1571 2HE  LYS    95      11.816  -4.514  10.764  1.00 37.79           H 
ATOM   1572 1HZ  LYS    95      14.038  -2.903   9.638  1.00 37.79           H 
ATOM   1573 2HZ  LYS    95      14.076  -4.562   9.983  1.00 37.79           H 
ATOM   1574 3HZ  LYS    95      13.939  -3.442  11.238  1.00 37.79           H 
ATOM   1575  N   ALA    96       7.012  -1.969  13.289  1.00 42.05           N 
ATOM   1576  CA  ALA    96       6.493  -2.915  14.286  1.00  2.42           C 
ATOM   1577  C   ALA    96       5.117  -3.490  13.893  1.00  3.13           C 
ATOM   1578  O   ALA    96       4.809  -4.643  14.207  1.00 40.35           O 
ATOM   1579  CB  ALA    96       6.409  -2.241  15.649  1.00 70.41           C 
ATOM   1580  H   ALA    96       7.150  -1.034  13.551  1.00 37.79           H 
ATOM   1581  HA  ALA    96       7.199  -3.731  14.363  1.00 43.25           H 
ATOM   1582 1HB  ALA    96       5.684  -1.440  15.611  1.00 37.79           H 
ATOM   1583 2HB  ALA    96       7.376  -1.838  15.913  1.00 37.79           H 
ATOM   1584 3HB  ALA    96       6.107  -2.965  16.392  1.00 37.79           H 
ATOM   1585  N   ASP    97       4.290  -2.685  13.218  1.00 32.43           N 
ATOM   1586  CA  ASP    97       2.965  -3.141  12.770  1.00 44.52           C 
ATOM   1587  C   ASP    97       3.079  -4.138  11.604  1.00 21.31           C 
ATOM   1588  O   ASP    97       2.160  -4.917  11.342  1.00 22.43           O 
ATOM   1589  CB  ASP    97       2.101  -1.947  12.348  1.00  2.13           C 
ATOM   1590  CG  ASP    97       1.852  -0.971  13.484  1.00 13.33           C 
ATOM   1591  OD1 ASP    97       2.567   0.048  13.570  1.00 15.33           O 
ATOM   1592  OD2 ASP    97       0.936  -1.217  14.298  1.00 62.34           O 
ATOM   1593  H   ASP    97       4.573  -1.767  13.014  1.00 37.79           H 
ATOM   1594  HA  ASP    97       2.489  -3.638  13.603  1.00 42.11           H 
ATOM   1595 1HB  ASP    97       1.145  -2.310  11.992  1.00 37.79           H 
ATOM   1596 2HB  ASP    97       2.597  -1.419  11.545  1.00 37.79           H 
ATOM   1597  N   LEU    98       4.214  -4.106  10.912  1.00 23.41           N 
ATOM   1598  CA  LEU    98       4.457  -4.993   9.774  1.00  3.22           C 
ATOM   1599  C   LEU    98       4.758  -6.425  10.239  1.00  0.12           C 
ATOM   1600  O   LEU    98       5.502  -6.628  11.202  1.00  2.31           O 
ATOM   1601  CB  LEU    98       5.645  -4.477   8.948  1.00 40.31           C 
ATOM   1602  CG  LEU    98       5.532  -3.029   8.442  1.00 44.24           C 
ATOM   1603  CD1 LEU    98       6.805  -2.617   7.705  1.00 62.02           C 
ATOM   1604  CD2 LEU    98       4.309  -2.861   7.543  1.00 22.32           C 
ATOM   1605  H   LEU    98       4.912  -3.474  11.179  1.00 37.79           H 
ATOM   1606  HA  LEU    98       3.573  -4.997   9.155  1.00 24.10           H 
ATOM   1607 1HB  LEU    98       5.768  -5.125   8.091  1.00 37.79           H 
ATOM   1608 2HB  LEU    98       6.535  -4.550   9.558  1.00 37.79           H 
ATOM   1609  HG  LEU    98       5.414  -2.369   9.289  1.00 23.45           H 
ATOM   1610 1HD1 LEU    98       6.721  -1.587   7.387  1.00 37.79           H 
ATOM   1611 2HD1 LEU    98       6.948  -3.249   6.839  1.00 37.79           H 
ATOM   1612 3HD1 LEU    98       7.653  -2.718   8.366  1.00 37.79           H 
ATOM   1613 1HD2 LEU    98       3.413  -3.088   8.105  1.00 37.79           H 
ATOM   1614 2HD2 LEU    98       4.382  -3.532   6.699  1.00 37.79           H 
ATOM   1615 3HD2 LEU    98       4.260  -1.842   7.189  1.00 37.79           H 
ATOM   1616  N   PRO    99       4.185  -7.445   9.567  1.00 33.35           N 
ATOM   1617  CA  PRO    99       4.536  -8.848   9.830  1.00 25.44           C 
ATOM   1618  C   PRO    99       5.992  -9.156   9.433  1.00 43.55           C 
ATOM   1619  O   PRO    99       6.576  -8.458   8.599  1.00 11.51           O 
ATOM   1620  CB  PRO    99       3.544  -9.643   8.964  1.00 64.23           C 
ATOM   1621  CG  PRO    99       3.107  -8.691   7.903  1.00 64.33           C 
ATOM   1622  CD  PRO    99       3.149  -7.318   8.523  1.00 12.14           C 
ATOM   1623  HA  PRO    99       4.391  -9.099  10.873  1.00  4.13           H 
ATOM   1624 1HB  PRO    99       2.708  -9.965   9.569  1.00 37.79           H 
ATOM   1625 2HB  PRO    99       4.037 -10.507   8.539  1.00 37.79           H 
ATOM   1626 1HG  PRO    99       2.101  -8.929   7.585  1.00 37.79           H 
ATOM   1627 2HG  PRO    99       3.784  -8.744   7.062  1.00 37.79           H 
ATOM   1628 1HD  PRO    99       2.191  -7.070   8.959  1.00 37.79           H 
ATOM   1629 2HD  PRO    99       3.431  -6.580   7.784  1.00 37.79           H 
ATOM   1630  N   GLU   100       6.563 -10.207  10.021  1.00 23.10           N 
ATOM   1631  CA  GLU   100       7.989 -10.537   9.848  1.00 74.33           C 
ATOM   1632  C   GLU   100       8.430 -10.547   8.375  1.00 74.30           C 
ATOM   1633  O   GLU   100       9.502 -10.049   8.034  1.00 20.33           O 
ATOM   1634  CB  GLU   100       8.298 -11.900  10.471  1.00  2.53           C 
ATOM   1635  CG  GLU   100       9.788 -12.229  10.511  1.00 43.34           C 
ATOM   1636  CD  GLU   100      10.058 -13.681  10.874  1.00 22.51           C 
ATOM   1637  OE1 GLU   100      10.762 -14.371  10.105  1.00 70.02           O 
ATOM   1638  OE2 GLU   100       9.538 -14.152  11.909  1.00 13.11           O 
ATOM   1639  H   GLU   100       6.012 -10.781  10.593  1.00 37.79           H 
ATOM   1640  HA  GLU   100       8.560  -9.784  10.371  1.00 21.22           H 
ATOM   1641 1HB  GLU   100       7.794 -12.669   9.901  1.00 37.79           H 
ATOM   1642 2HB  GLU   100       7.921 -11.913  11.484  1.00 37.79           H 
ATOM   1643 1HG  GLU   100      10.265 -11.589  11.243  1.00 37.79           H 
ATOM   1644 2HG  GLU   100      10.212 -12.031   9.535  1.00 37.79           H 
ATOM   1645  N   LYS   101       7.611 -11.119   7.504  1.00 25.44           N 
ATOM   1646  CA  LYS   101       7.970 -11.214   6.087  1.00 34.04           C 
ATOM   1647  C   LYS   101       8.005  -9.825   5.423  1.00 63.15           C 
ATOM   1648  O   LYS   101       8.966  -9.477   4.735  1.00 55.54           O 
ATOM   1649  CB  LYS   101       6.993 -12.136   5.341  1.00 25.52           C 
ATOM   1650  CG  LYS   101       6.762 -13.483   6.030  1.00 13.22           C 
ATOM   1651  CD  LYS   101       8.067 -14.181   6.423  1.00 21.22           C 
ATOM   1652  CE  LYS   101       8.953 -14.503   5.224  1.00 24.33           C 
ATOM   1653  NZ  LYS   101      10.209 -15.180   5.639  1.00 25.43           N 
ATOM   1654  H   LYS   101       6.762 -11.494   7.818  1.00 37.79           H 
ATOM   1655  HA  LYS   101       8.960 -11.645   6.032  1.00 31.13           H 
ATOM   1656 1HB  LYS   101       7.381 -12.327   4.350  1.00 37.79           H 
ATOM   1657 2HB  LYS   101       6.039 -11.636   5.252  1.00 37.79           H 
ATOM   1658 1HG  LYS   101       6.209 -14.126   5.357  1.00 37.79           H 
ATOM   1659 2HG  LYS   101       6.178 -13.318   6.924  1.00 37.79           H 
ATOM   1660 1HD  LYS   101       7.823 -15.103   6.931  1.00 37.79           H 
ATOM   1661 2HD  LYS   101       8.618 -13.540   7.096  1.00 37.79           H 
ATOM   1662 1HE  LYS   101       9.202 -13.583   4.713  1.00 37.79           H 
ATOM   1663 2HE  LYS   101       8.412 -15.153   4.552  1.00 37.79           H 
ATOM   1664 1HZ  LYS   101       9.988 -16.090   6.099  1.00 37.79           H 
ATOM   1665 2HZ  LYS   101      10.733 -14.585   6.312  1.00 37.79           H 
ATOM   1666 3HZ  LYS   101      10.810 -15.361   4.812  1.00 37.79           H 
ATOM   1667  N   VAL   102       6.963  -9.031   5.665  1.00 51.42           N 
ATOM   1668  CA  VAL   102       6.828  -7.700   5.057  1.00 13.14           C 
ATOM   1669  C   VAL   102       7.961  -6.743   5.467  1.00 70.44           C 
ATOM   1670  O   VAL   102       8.545  -6.062   4.620  1.00 25.33           O 
ATOM   1671  CB  VAL   102       5.462  -7.068   5.423  1.00 61.20           C 
ATOM   1672  CG1 VAL   102       5.408  -5.593   5.034  1.00 13.43           C 
ATOM   1673  CG2 VAL   102       4.328  -7.841   4.758  1.00 22.51           C 
ATOM   1674  H   VAL   102       6.268  -9.343   6.278  1.00 37.79           H 
ATOM   1675  HA  VAL   102       6.858  -7.827   3.984  1.00 21.35           H 
ATOM   1676  HB  VAL   102       5.333  -7.139   6.495  1.00  3.12           H 
ATOM   1677 1HG1 VAL   102       4.439  -5.186   5.285  1.00 37.79           H 
ATOM   1678 2HG1 VAL   102       5.577  -5.490   3.971  1.00 37.79           H 
ATOM   1679 3HG1 VAL   102       6.173  -5.051   5.573  1.00 37.79           H 
ATOM   1680 1HG2 VAL   102       3.380  -7.404   5.040  1.00 37.79           H 
ATOM   1681 2HG2 VAL   102       4.357  -8.872   5.079  1.00 37.79           H 
ATOM   1682 3HG2 VAL   102       4.438  -7.793   3.685  1.00 37.79           H 
ATOM   1683  N   LYS   103       8.267  -6.689   6.763  1.00  4.22           N 
ATOM   1684  CA  LYS   103       9.319  -5.797   7.268  1.00 40.22           C 
ATOM   1685  C   LYS   103      10.663  -6.060   6.565  1.00 22.05           C 
ATOM   1686  O   LYS   103      11.366  -5.121   6.183  1.00 23.14           O 
ATOM   1687  CB  LYS   103       9.454  -5.941   8.792  1.00 74.03           C 
ATOM   1688  CG  LYS   103       9.708  -7.371   9.259  1.00 15.33           C 
ATOM   1689  CD  LYS   103       9.812  -7.487  10.781  1.00 12.30           C 
ATOM   1690  CE  LYS   103       8.589  -6.903  11.481  1.00 25.02           C 
ATOM   1691  NZ  LYS   103       8.674  -7.032  12.957  1.00 33.23           N 
ATOM   1692  H   LYS   103       7.779  -7.263   7.393  1.00 37.79           H 
ATOM   1693  HA  LYS   103       9.013  -4.784   7.044  1.00 53.12           H 
ATOM   1694 1HB  LYS   103       8.539  -5.589   9.252  1.00 37.79           H 
ATOM   1695 2HB  LYS   103      10.275  -5.323   9.130  1.00 37.79           H 
ATOM   1696 1HG  LYS   103      10.632  -7.720   8.819  1.00 37.79           H 
ATOM   1697 2HG  LYS   103       8.894  -7.996   8.919  1.00 37.79           H 
ATOM   1698 1HD  LYS   103      10.696  -6.968  11.116  1.00 37.79           H 
ATOM   1699 2HD  LYS   103       9.892  -8.533  11.043  1.00 37.79           H 
ATOM   1700 1HE  LYS   103       7.708  -7.425  11.134  1.00 37.79           H 
ATOM   1701 2HE  LYS   103       8.506  -5.856  11.227  1.00 37.79           H 
ATOM   1702 1HZ  LYS   103       7.821  -6.640  13.402  1.00 37.79           H 
ATOM   1703 2HZ  LYS   103       9.503  -6.520  13.316  1.00 37.79           H 
ATOM   1704 3HZ  LYS   103       8.762  -8.032  13.226  1.00 37.79           H 
ATOM   1705  N   ASP   104      11.001  -7.336   6.374  1.00 74.33           N 
ATOM   1706  CA  ASP   104      12.207  -7.715   5.631  1.00 74.15           C 
ATOM   1707  C   ASP   104      12.101  -7.350   4.136  1.00  4.45           C 
ATOM   1708  O   ASP   104      13.108  -7.033   3.495  1.00 11.44           O 
ATOM   1709  CB  ASP   104      12.493  -9.215   5.795  1.00 11.15           C 
ATOM   1710  CG  ASP   104      12.748  -9.615   7.241  1.00 62.31           C 
ATOM   1711  OD1 ASP   104      12.447 -10.771   7.606  1.00 10.55           O 
ATOM   1712  OD2 ASP   104      13.282  -8.786   8.009  1.00 25.44           O 
ATOM   1713  H   ASP   104      10.432  -8.041   6.752  1.00 37.79           H 
ATOM   1714  HA  ASP   104      13.033  -7.162   6.056  1.00 43.15           H 
ATOM   1715 1HB  ASP   104      13.366  -9.472   5.213  1.00 37.79           H 
ATOM   1716 2HB  ASP   104      11.646  -9.780   5.429  1.00 37.79           H 
ATOM   1717  N   LYS   105      10.884  -7.388   3.586  1.00  1.14           N 
ATOM   1718  CA  LYS   105      10.652  -7.024   2.178  1.00 20.34           C 
ATOM   1719  C   LYS   105      10.869  -5.520   1.926  1.00 22.43           C 
ATOM   1720  O   LYS   105      11.214  -5.114   0.815  1.00 61.23           O 
ATOM   1721  CB  LYS   105       9.231  -7.418   1.746  1.00 35.05           C 
ATOM   1722  CG  LYS   105       8.976  -8.923   1.739  1.00 42.20           C 
ATOM   1723  CD  LYS   105       9.871  -9.656   0.739  1.00 61.44           C 
ATOM   1724  CE  LYS   105       9.601  -9.221  -0.699  1.00 30.51           C 
ATOM   1725  NZ  LYS   105      10.407  -9.998  -1.678  1.00 21.42           N 
ATOM   1726  H   LYS   105      10.122  -7.675   4.136  1.00 37.79           H 
ATOM   1727  HA  LYS   105      11.362  -7.578   1.577  1.00 21.31           H 
ATOM   1728 1HB  LYS   105       9.052  -7.042   0.748  1.00 37.79           H 
ATOM   1729 2HB  LYS   105       8.523  -6.959   2.422  1.00 37.79           H 
ATOM   1730 1HG  LYS   105       7.941  -9.101   1.480  1.00 37.79           H 
ATOM   1731 2HG  LYS   105       9.168  -9.314   2.727  1.00 37.79           H 
ATOM   1732 1HD  LYS   105       9.691 -10.720   0.823  1.00 37.79           H 
ATOM   1733 2HD  LYS   105      10.903  -9.448   0.976  1.00 37.79           H 
ATOM   1734 1HE  LYS   105       9.846  -8.173  -0.799  1.00 37.79           H 
ATOM   1735 2HE  LYS   105       8.554  -9.366  -0.919  1.00 37.79           H 
ATOM   1736 1HZ  LYS   105      10.169 -11.008  -1.617  1.00 37.79           H 
ATOM   1737 2HZ  LYS   105      11.421  -9.880  -1.480  1.00 37.79           H 
ATOM   1738 3HZ  LYS   105      10.215  -9.665  -2.643  1.00 37.79           H 
ATOM   1739  N   PHE   106      10.639  -4.696   2.951  1.00 53.42           N 
ATOM   1740  CA  PHE   106      10.887  -3.249   2.851  1.00 43.42           C 
ATOM   1741  C   PHE   106      12.367  -2.904   3.084  1.00 20.54           C 
ATOM   1742  O   PHE   106      12.974  -2.164   2.309  1.00 24.40           O 
ATOM   1743  CB  PHE   106      10.014  -2.471   3.852  1.00 50.33           C 
ATOM   1744  CG  PHE   106       8.601  -2.227   3.381  1.00 62.42           C 
ATOM   1745  CD1 PHE   106       7.528  -2.912   3.937  1.00 31.22           C 
ATOM   1746  CD2 PHE   106       8.346  -1.298   2.381  1.00 64.05           C 
ATOM   1747  CE1 PHE   106       6.235  -2.673   3.505  1.00 24.10           C 
ATOM   1748  CE2 PHE   106       7.055  -1.060   1.947  1.00  3.31           C 
ATOM   1749  CZ  PHE   106       6.000  -1.747   2.510  1.00  3.33           C 
ATOM   1750  H   PHE   106      10.282  -5.067   3.788  1.00 37.79           H 
ATOM   1751  HA  PHE   106      10.620  -2.942   1.849  1.00 70.40           H 
ATOM   1752 1HB  PHE   106      10.470  -1.508   4.043  1.00 37.79           H 
ATOM   1753 2HB  PHE   106       9.965  -3.024   4.779  1.00 37.79           H 
ATOM   1754  HD1 PHE   106       7.706  -3.639   4.716  1.00 43.04           H 
ATOM   1755  HD2 PHE   106       9.169  -0.756   1.938  1.00 62.33           H 
ATOM   1756  HE1 PHE   106       5.408  -3.214   3.945  1.00 51.23           H 
ATOM   1757  HE2 PHE   106       6.873  -0.334   1.167  1.00 25.15           H 
ATOM   1758  HZ  PHE   106       4.990  -1.562   2.172  1.00 20.52           H 
ATOM   1759  N   THR   107      12.947  -3.437   4.157  1.00 21.33           N 
ATOM   1760  CA  THR   107      14.325  -3.087   4.538  1.00 14.34           C 
ATOM   1761  C   THR   107      15.379  -3.877   3.741  1.00 32.33           C 
ATOM   1762  O   THR   107      16.541  -3.475   3.670  1.00 15.42           O 
ATOM   1763  CB  THR   107      14.565  -3.308   6.052  1.00 41.25           C 
ATOM   1764  OG1 THR   107      15.868  -2.839   6.424  1.00  5.12           O 
ATOM   1765  CG2 THR   107      14.434  -4.778   6.433  1.00 24.43           C 
ATOM   1766  H   THR   107      12.441  -4.072   4.709  1.00 37.79           H 
ATOM   1767  HA  THR   107      14.463  -2.032   4.333  1.00 75.15           H 
ATOM   1768  HB  THR   107      13.822  -2.744   6.601  1.00 52.25           H 
ATOM   1769  HG1 THR   107      15.791  -2.301   7.221  1.00 35.33           H 
ATOM   1770 1HG2 THR   107      13.462  -5.144   6.137  1.00 37.79           H 
ATOM   1771 2HG2 THR   107      14.548  -4.886   7.501  1.00 37.79           H 
ATOM   1772 3HG2 THR   107      15.201  -5.349   5.932  1.00 37.79           H 
ATOM   1773  N   ILE   108      14.966  -4.995   3.136  1.00  3.54           N 
ATOM   1774  CA  ILE   108      15.882  -5.865   2.378  1.00 14.53           C 
ATOM   1775  C   ILE   108      17.036  -6.372   3.279  1.00 41.22           C 
ATOM   1776  O   ILE   108      18.187  -6.486   2.853  1.00  3.13           O 
ATOM   1777  CB  ILE   108      16.441  -5.136   1.117  1.00 33.21           C 
ATOM   1778  CG1 ILE   108      15.298  -4.470   0.327  1.00 71.54           C 
ATOM   1779  CG2 ILE   108      17.207  -6.104   0.211  1.00 45.30           C 
ATOM   1780  CD1 ILE   108      14.257  -5.444  -0.192  1.00 62.14           C 
ATOM   1781  H   ILE   108      14.017  -5.239   3.187  1.00 37.79           H 
ATOM   1782  HA  ILE   108      15.310  -6.721   2.047  1.00 62.10           H 
ATOM   1783  HB  ILE   108      17.130  -4.371   1.446  1.00 75.20           H 
ATOM   1784 1HG1 ILE   108      15.714  -3.945  -0.522  1.00 37.79           H 
ATOM   1785 2HG1 ILE   108      14.793  -3.762   0.967  1.00 37.79           H 
ATOM   1786 1HG2 ILE   108      18.039  -6.526   0.755  1.00 37.79           H 
ATOM   1787 2HG2 ILE   108      17.576  -5.575  -0.656  1.00 37.79           H 
ATOM   1788 3HG2 ILE   108      16.548  -6.900  -0.108  1.00 37.79           H 
ATOM   1789 1HD1 ILE   108      13.496  -4.901  -0.733  1.00 37.79           H 
ATOM   1790 2HD1 ILE   108      13.805  -5.966   0.638  1.00 37.79           H 
ATOM   1791 3HD1 ILE   108      14.728  -6.157  -0.853  1.00 37.79           H 
END
