
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 (  857),  selected  107 , name 2ob9_A
# Molecule2: number of CA atoms  121 (  985),  selected  121 , name T0465.pdb
# PARAMETERS: 2ob9_A.T0465.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      E       7           -
LGA    Q     3_A      K       8           -
LGA    T     4_A      V       9           -
LGA    L     5_A      Y      10           -
LGA    K     6_A      D      11           -
LGA    Q     7_A      L      12           -
LGA    L     8_A      S      13           -
LGA    -       -      F      14           -
LGA    -       -      F      15           -
LGA    -       -      M      16           -
LGA    A     9_A      P      17           #
LGA    X    10_A      G      18           -
LGA    A    11_A      Q      19           -
LGA    K    12_A      -       -           -
LGA    X    13_A      -       -           -
LGA    A    14_A      -       -           -
LGA    G    15_A      T      20           #
LGA    F    16_A      I      21           #
LGA    R    17_A      D      22          3.080
LGA    -       -      A      23           -
LGA    H    18_A      E      24          1.107
LGA    K    19_A      E      25          2.993
LGA    T    20_A      V      26          2.519
LGA    V    21_A      E      27          2.242
LGA    V    22_A      V      28          2.589
LGA    V    23_A      P      29          1.217
LGA    P    24_A      I      30          5.037
LGA    E    25_A      S      31          2.687
LGA    W    26_A      K      32          3.685
LGA    E    27_A      R      33          4.130
LGA    -       -      F      34           -
LGA    -       -      V      35           -
LGA    -       -      D      36           -
LGA    -       -      K      37           -
LGA    -       -      E      38           -
LGA    -       -      G      39           -
LGA    -       -      N      40           -
LGA    G    28_A      V      41          3.456
LGA    V    29_A      V      42          2.288
LGA    K    30_A      P      43          1.764
LGA    V    31_A      F      44          2.149
LGA    V    32_A      I      45          1.713
LGA    L    33_A      F      46          1.006
LGA    R    34_A      K      47          0.777
LGA    E    35_A      A      48          0.925
LGA    P    36_A      I      49          0.942
LGA    S    37_A      T      50          3.801
LGA    G    38_A      T      51           #
LGA    E    39_A      D      52           #
LGA    A    40_A      R      53          3.398
LGA    W    41_A      I      54          1.453
LGA    L    42_A      D      55          3.932
LGA    R    43_A      E      56          3.320
LGA    W    44_A      L      57          2.265
LGA    Q    45_A      E      58          1.777
LGA    E    46_A      K      59          1.002
LGA    -       -      E      60           -
LGA    V    47_A      N      61          1.227
LGA    V    48_A      T      62          4.131
LGA    -       -      T      63           -
LGA    N    56_A      K      74           #
LGA    V    57_A      E      75           #
LGA    S    58_A      -       -           -
LGA    V    59_A      -       -           -
LGA    S    60_A      -       -           -
LGA    E    61_A      -       -           -
LGA    K    62_A      -       -           -
LGA    A    63_A      -       -           -
LGA    H    64_A      -       -           -
LGA    R    65_A      L      76          4.628
LGA    -       -      D      77           -
LGA    N    66_A      S      78          0.273
LGA    L    67_A      Q      79          0.516
LGA    C    68_A      R      80          0.485
LGA    A    69_A      F      81          0.313
LGA    D    70_A      Y      82          0.629
LGA    V    71_A      A      83          1.046
LGA    V    72_A      R      84          0.891
LGA    L    73_A      I      85          0.574
LGA    F    74_A      A      86          0.850
LGA    I    75_A      V      87          0.888
LGA    D    76_A      E      88          0.418
LGA    V    77_A      T      89          0.429
LGA    L    78_A      T      90          0.382
LGA    C    79_A      V      91          1.284
LGA    D    80_A      Y      92          2.266
LGA    T    81_A      -       -           -
LGA    D    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    Q    84_A      -       -           -
LGA    P    85_A      -       -           -
LGA    V    86_A      P      93          2.566
LGA    F    87_A      T      94          2.907
LGA    S    88_A      F      95          4.989
LGA    V    89_A      K      96          4.810
LGA    -       -      A      97           -
LGA    -       -      K      98           -
LGA    -       -      E      99           -
LGA    -       -      L     100           -
LGA    -       -      R     101           -
LGA    -       -      E     102           -
LGA    -       -      A     103           -
LGA    -       -      Y     104           -
LGA    -       -      K     105           -
LGA    -       -      T     106           -
LGA    D    90_A      E     107          5.274
LGA    E    91_A      D     108          2.758
LGA    E    92_A      P     109          2.999
LGA    E    93_A      V     110          4.425
LGA    Q    94_A      E     111          1.815
LGA    V    95_A      V     112          3.701
LGA    R    96_A      A     113           #
LGA    E    97_A      -       -           -
LGA    I    98_A      K     114          1.726
LGA    Y    99_A      R     115           -
LGA    -       -      V     116           -
LGA    -       -      L     117           -
LGA    -       -      S     118           -
LGA    -       -      V     119           -
LGA    -       -      G     120           -
LGA    -       -      G     121           -
LGA    -       -      E     122           -
LGA    G   100_A      Y     123          2.990
LGA    P   101_A      A     124          1.069
LGA    V   102_A      N     125          1.857
LGA    H   103_A      W     126          1.860
LGA    S   104_A      L     127          1.379
LGA    R   105_A      N     128          2.053
LGA    L   106_A      K     129          2.215
LGA    L   107_A      A     130          1.317
LGA    K   108_A      I     131          2.263
LGA    Q   109_A      E     132          2.834
LGA    A   110_A      I     133          1.682
LGA    L   111_A      N     134          1.001
LGA    D   112_A      G     135          2.548
LGA    L   113_A      F     136           -
LGA    I   114_A      D     137           -
LGA    N   115_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107  121    5.0     70    2.54     4.29     37.746     2.656

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.849958 * X  +   0.505491 * Y  +  -0.148494 * Z  +  15.832778
  Y_new =   0.425213 * X  +   0.491760 * Y  +  -0.759846 * Z  +  12.487817
  Z_new =  -0.311072 * X  +  -0.708979 * Y  +  -0.632917 * Z  +  66.226288 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.299572    0.842020  [ DEG:  -131.7558     48.2442 ]
  Theta =   0.316321    2.825272  [ DEG:    18.1239    161.8761 ]
  Phi   =   2.677725   -0.463868  [ DEG:   153.4223    -26.5777 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ob9_A                                        
REMARK     2: T0465.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ob9_A.T0465.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107  121   5.0   70   2.54    4.29  37.746
REMARK  ---------------------------------------------------------- 
MOLECULE 2ob9_A
HEADER    CHAPERONE                               18-DEC-06   2OB9              
TITLE     STRUCTURE OF BACTERIOPHAGE HK97 TAIL ASSEMBLY CHAPERONE               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TAIL ASSEMBLY CHAPERONE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTERIOPHAGE HK97;                             
SOURCE   3 ORGANISM_COMMON: VIRUS;                                              
SOURCE   4 GENE: HK97P121;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: P11 (MODIFIED PET VECTOR)                 
KEYWDS    BACTERIOPHAGE HK97, MORPHOGENESIS, TAIL ASSEMBLY CHAPERONE            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.E.MCGRATH,A.TUITE,D.BONA,V.SARIDAKIS,A.M.EDWARDS,                   
AUTHOR   2 K.MAXWELL,N.Y.CHIRGADZE                                              
REVDAT   1   18-DEC-07 2OB9    0                                                
JRNL        AUTH   A.TUITE,T.E.MCGRATH,D.BONA,A.M.EDWARDS,                      
JRNL        AUTH 2 N.Y.CHIRGADZE,K.MAXWELL                                      
JRNL        TITL   STRUCTURE OF BACTERIOPHAGE HK97 TAIL ASSEMBLY                
JRNL        TITL 2 CHAPERONE                                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2OB9 A    1   128  UNP    Q9MCS6   Q9MCS6_BPHK7     1    128             
DBREF  2OB9 B    1   128  UNP    Q9MCS6   Q9MCS6_BPHK7     1    128             
SEQRES   1 A  130  GLY HIS MSE SER GLN THR LEU LYS GLN LEU ALA MSE ALA          
SEQRES   2 A  130  LYS MSE ALA GLY PHE ARG HIS LYS THR VAL VAL VAL PRO          
SEQRES   3 A  130  GLU TRP GLU GLY VAL LYS VAL VAL LEU ARG GLU PRO SER          
SEQRES   4 A  130  GLY GLU ALA TRP LEU ARG TRP GLN GLU VAL VAL LYS GLY          
SEQRES   5 A  130  GLY GLY ASP ASP GLU ASN VAL SER VAL SER GLU LYS ALA          
SEQRES   6 A  130  HIS ARG ASN LEU CYS ALA ASP VAL VAL LEU PHE ILE ASP          
SEQRES   7 A  130  VAL LEU CYS ASP THR ASP LYS GLN PRO VAL PHE SER VAL          
SEQRES   8 A  130  ASP GLU GLU GLU GLN VAL ARG GLU ILE TYR GLY PRO VAL          
SEQRES   9 A  130  HIS SER ARG LEU LEU LYS GLN ALA LEU ASP LEU ILE ASN          
SEQRES  10 A  130  ASN ALA ASP GLU ALA ARG GLU LYS SER GLN PRO PRO ALA          
SEQRES   1 B  130  GLY HIS MSE SER GLN THR LEU LYS GLN LEU ALA MSE ALA          
SEQRES   2 B  130  LYS MSE ALA GLY PHE ARG HIS LYS THR VAL VAL VAL PRO          
SEQRES   3 B  130  GLU TRP GLU GLY VAL LYS VAL VAL LEU ARG GLU PRO SER          
SEQRES   4 B  130  GLY GLU ALA TRP LEU ARG TRP GLN GLU VAL VAL LYS GLY          
SEQRES   5 B  130  GLY GLY ASP ASP GLU ASN VAL SER VAL SER GLU LYS ALA          
SEQRES   6 B  130  HIS ARG ASN LEU CYS ALA ASP VAL VAL LEU PHE ILE ASP          
SEQRES   7 B  130  VAL LEU CYS ASP THR ASP LYS GLN PRO VAL PHE SER VAL          
SEQRES   8 B  130  ASP GLU GLU GLU GLN VAL ARG GLU ILE TYR GLY PRO VAL          
SEQRES   9 B  130  HIS SER ARG LEU LEU LYS GLN ALA LEU ASP LEU ILE ASN          
SEQRES  10 B  130  ASN ALA ASP GLU ALA ARG GLU LYS SER GLN PRO PRO ALA          
HET    MSE  A  10       8                                                       
HET    MSE  A  13       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  10       8                                                       
HET    MSE  B  13       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *53(H2 O)                                                     
CRYST1  101.140  101.140   63.382  90.00  90.00  90.00 I 4          16          
ATOM      1  N   SER A   2      56.935   7.267  22.277  1.00 53.35           N  
ATOM      2  CA  SER A   2      55.794   7.535  21.340  1.00 53.54           C  
ATOM      3  C   SER A   2      54.667   8.322  21.961  1.00 53.15           C  
ATOM      4  O   SER A   2      54.319   8.105  23.120  1.00 53.42           O  
ATOM      5  CB  SER A   2      55.202   6.244  20.802  1.00 53.97           C  
ATOM      6  OG  SER A   2      54.255   6.555  19.811  1.00 52.95           O  
ATOM      7  N   GLN A   3      54.065   9.184  21.139  1.00 52.63           N  
ATOM      8  CA  GLN A   3      53.111  10.206  21.561  1.00 52.34           C  
ATOM      9  C   GLN A   3      51.653   9.852  21.161  1.00 51.78           C  
ATOM     10  O   GLN A   3      50.688  10.499  21.581  1.00 51.29           O  
ATOM     11  CB  GLN A   3      53.552  11.517  20.913  1.00 52.67           C  
ATOM     12  CG  GLN A   3      53.511  12.745  21.807  1.00 54.01           C  
ATOM     13  CD  GLN A   3      54.349  12.605  23.053  1.00 55.26           C  
ATOM     14  OE1 GLN A   3      53.848  12.758  24.169  1.00 54.92           O  
ATOM     15  NE2 GLN A   3      55.626  12.288  22.876  1.00 56.21           N  
ATOM     16  N   THR A   4      51.521   8.810  20.342  1.00 51.20           N  
ATOM     17  CA  THR A   4      50.251   8.357  19.780  1.00 50.92           C  
ATOM     18  C   THR A   4      49.140   8.200  20.829  1.00 50.52           C  
ATOM     19  O   THR A   4      48.055   8.730  20.663  1.00 51.36           O  
ATOM     20  CB  THR A   4      50.444   7.009  19.035  1.00 50.85           C  
ATOM     21  OG1 THR A   4      51.500   7.146  18.083  1.00 50.76           O  
ATOM     22  CG2 THR A   4      49.169   6.550  18.327  1.00 50.28           C  
ATOM     23  N   LEU A   5      49.422   7.468  21.894  1.00 49.52           N  
ATOM     24  CA  LEU A   5      48.424   7.134  22.882  1.00 48.60           C  
ATOM     25  C   LEU A   5      48.104   8.322  23.822  1.00 47.97           C  
ATOM     26  O   LEU A   5      46.938   8.634  24.057  1.00 47.72           O  
ATOM     27  CB  LEU A   5      48.839   5.857  23.660  1.00 48.30           C  
ATOM     28  CG  LEU A   5      48.005   5.569  24.918  1.00 49.13           C  
ATOM     29  CD1 LEU A   5      46.473   5.583  24.602  1.00 47.72           C  
ATOM     30  CD2 LEU A   5      48.440   4.299  25.637  1.00 47.75           C  
ATOM     31  N   LYS A   6      49.127   8.972  24.358  1.00 47.37           N  
ATOM     32  CA  LYS A   6      48.900  10.117  25.235  1.00 47.47           C  
ATOM     33  C   LYS A   6      48.117  11.201  24.507  1.00 47.38           C  
ATOM     34  O   LYS A   6      47.241  11.824  25.080  1.00 47.52           O  
ATOM     35  CB  LYS A   6      50.223  10.651  25.769  1.00 47.81           C  
ATOM     36  CG  LYS A   6      50.110  11.973  26.492  1.00 48.45           C  
ATOM     37  CD  LYS A   6      51.373  12.185  27.269  1.00 51.21           C  
ATOM     38  CE  LYS A   6      51.315  13.495  28.001  1.00 53.90           C  
ATOM     39  NZ  LYS A   6      52.485  13.669  28.907  1.00 53.80           N  
ATOM     40  N   GLN A   7      48.400  11.374  23.215  1.00 47.17           N  
ATOM     41  CA  GLN A   7      47.676  12.336  22.387  1.00 46.44           C  
ATOM     42  C   GLN A   7      46.205  11.972  22.133  1.00 46.39           C  
ATOM     43  O   GLN A   7      45.357  12.871  22.081  1.00 45.85           O  
ATOM     44  CB  GLN A   7      48.421  12.577  21.072  1.00 45.42           C  
ATOM     45  CG  GLN A   7      47.788  13.598  20.181  1.00 45.45           C  
ATOM     46  CD  GLN A   7      48.711  14.041  19.083  1.00 45.40           C  
ATOM     47  OE1 GLN A   7      49.608  13.307  18.679  1.00 47.10           O  
ATOM     48  NE2 GLN A   7      48.492  15.233  18.582  1.00 45.68           N  
ATOM     49  N   LEU A   8      45.897  10.689  21.958  1.00 46.75           N  
ATOM     50  CA  LEU A   8      44.473  10.256  21.845  1.00 47.76           C  
ATOM     51  C   LEU A   8      43.733  10.356  23.190  1.00 48.83           C  
ATOM     52  O   LEU A   8      42.559  10.708  23.242  1.00 48.58           O  
ATOM     53  CB  LEU A   8      44.376   8.802  21.339  1.00 47.18           C  
ATOM     54  CG  LEU A   8      44.639   8.573  19.836  1.00 47.63           C  
ATOM     55  CD1 LEU A   8      45.042   7.154  19.552  1.00 44.63           C  
ATOM     56  CD2 LEU A   8      43.445   9.014  18.943  1.00 41.67           C  
ATOM     57  N   ALA A   9      44.453   9.983  24.258  1.00 49.88           N  
ATOM     58  CA  ALA A   9      43.982   9.969  25.638  1.00 50.67           C  
ATOM     59  C   ALA A   9      43.678  11.339  26.209  1.00 51.92           C  
ATOM     60  O   ALA A   9      42.894  11.436  27.149  1.00 51.96           O  
ATOM     61  CB  ALA A   9      45.024   9.233  26.537  1.00 50.38           C  
HETATM   62  N   MSE A  10      44.305  12.382  25.642  1.00 53.39           N  
HETATM   63  CA  MSE A  10      44.288  13.747  26.170  1.00 55.66           C  
HETATM   64  C   MSE A  10      43.564  14.738  25.290  1.00 55.29           C  
HETATM   65  O   MSE A  10      43.460  15.909  25.662  1.00 54.88           O  
HETATM   66  CB  MSE A  10      45.725  14.279  26.331  1.00 55.98           C  
HETATM   67  CG  MSE A  10      46.237  14.308  27.760  1.00 57.62           C  
HETATM   68 SE   MSE A  10      47.886  15.356  27.929  0.80 62.07          SE  
HETATM   69  CE  MSE A  10      46.947  16.973  28.528  1.00 63.21           C  
ATOM     70  N   ALA A  11      43.088  14.282  24.126  1.00 55.43           N  
ATOM     71  CA  ALA A  11      42.420  15.127  23.163  1.00 56.18           C  
ATOM     72  C   ALA A  11      41.109  15.675  23.745  1.00 57.69           C  
ATOM     73  O   ALA A  11      40.539  15.107  24.701  1.00 57.25           O  
ATOM     74  CB  ALA A  11      42.159  14.363  21.851  1.00 55.20           C  
ATOM     75  N   LYS A  12      40.672  16.799  23.180  1.00 59.02           N  
ATOM     76  CA  LYS A  12      39.407  17.409  23.516  1.00 61.50           C  
ATOM     77  C   LYS A  12      38.332  16.359  23.288  1.00 61.76           C  
ATOM     78  O   LYS A  12      38.242  15.767  22.186  1.00 63.05           O  
ATOM     79  CB  LYS A  12      39.125  18.639  22.627  1.00 61.27           C  
ATOM     80  CG  LYS A  12      38.253  19.708  23.303  1.00 62.95           C  
ATOM     81  CD  LYS A  12      37.464  20.621  22.326  1.00 63.17           C  
ATOM     82  CE  LYS A  12      38.208  20.913  21.011  1.00 64.55           C  
ATOM     83  NZ  LYS A  12      37.471  21.935  20.159  1.00 66.16           N  
HETATM   84  N   MSE A  13      37.538  16.126  24.320  1.00 60.91           N  
HETATM   85  CA  MSE A  13      36.490  15.096  24.251  1.00 62.55           C  
HETATM   86  C   MSE A  13      36.970  13.653  24.125  1.00 59.24           C  
HETATM   87  O   MSE A  13      36.204  12.794  23.716  1.00 59.69           O  
HETATM   88  CB  MSE A  13      35.425  15.418  23.177  1.00 62.35           C  
HETATM   89  CG  MSE A  13      34.449  16.490  23.611  1.00 63.04           C  
HETATM   90 SE   MSE A  13      32.618  16.127  23.033  0.80 71.60          SE  
HETATM   91  CE  MSE A  13      32.655  16.046  21.132  1.00 69.04           C  
ATOM     92  N   ALA A  14      38.234  13.396  24.484  1.00 56.69           N  
ATOM     93  CA  ALA A  14      38.754  12.031  24.696  1.00 53.10           C  
ATOM     94  C   ALA A  14      37.915  11.245  25.733  1.00 51.24           C  
ATOM     95  O   ALA A  14      37.897   9.999  25.731  1.00 50.33           O  
ATOM     96  CB  ALA A  14      40.216  12.098  25.138  1.00 52.18           C  
ATOM     97  N   GLY A  15      37.265  11.979  26.635  1.00 48.94           N  
ATOM     98  CA  GLY A  15      36.525  11.387  27.718  1.00 47.47           C  
ATOM     99  C   GLY A  15      35.154  10.896  27.323  1.00 47.80           C  
ATOM    100  O   GLY A  15      34.551  10.193  28.080  1.00 48.16           O  
ATOM    101  N   PHE A  16      34.686  11.210  26.117  1.00 47.73           N  
ATOM    102  CA  PHE A  16      33.276  11.038  25.764  1.00 48.33           C  
ATOM    103  C   PHE A  16      33.108  10.439  24.392  1.00 48.58           C  
ATOM    104  O   PHE A  16      33.641  10.956  23.457  1.00 48.55           O  
ATOM    105  CB  PHE A  16      32.553  12.411  25.764  1.00 46.59           C  
ATOM    106  CG  PHE A  16      32.494  13.037  27.102  1.00 46.12           C  
ATOM    107  CD1 PHE A  16      31.418  12.810  27.927  1.00 44.84           C  
ATOM    108  CD2 PHE A  16      33.570  13.793  27.586  1.00 46.94           C  
ATOM    109  CE1 PHE A  16      31.380  13.343  29.192  1.00 43.67           C  
ATOM    110  CE2 PHE A  16      33.543  14.313  28.867  1.00 45.05           C  
ATOM    111  CZ  PHE A  16      32.435  14.089  29.664  1.00 43.40           C  
ATOM    112  N   ARG A  17      32.335   9.367  24.279  1.00 49.63           N  
ATOM    113  CA  ARG A  17      31.682   9.041  23.002  1.00 50.71           C  
ATOM    114  C   ARG A  17      30.851  10.242  22.519  1.00 51.04           C  
ATOM    115  O   ARG A  17      30.220  10.922  23.305  1.00 50.70           O  
ATOM    116  CB  ARG A  17      30.757   7.841  23.177  1.00 50.27           C  
ATOM    117  CG  ARG A  17      31.517   6.576  23.415  1.00 51.93           C  
ATOM    118  CD  ARG A  17      30.576   5.422  23.534  1.00 53.31           C  
ATOM    119  NE  ARG A  17      31.299   4.210  23.842  1.00 55.13           N  
ATOM    120  CZ  ARG A  17      30.730   3.092  24.267  1.00 56.33           C  
ATOM    121  NH1 ARG A  17      29.410   3.029  24.406  1.00 57.68           N  
ATOM    122  NH2 ARG A  17      31.482   2.036  24.540  1.00 55.01           N  
ATOM    123  N   HIS A  18      30.858  10.502  21.220  1.00 52.29           N  
ATOM    124  CA  HIS A  18      30.228  11.709  20.705  1.00 53.21           C  
ATOM    125  C   HIS A  18      30.039  11.586  19.207  1.00 53.71           C  
ATOM    126  O   HIS A  18      30.672  10.749  18.584  1.00 53.05           O  
ATOM    127  CB  HIS A  18      31.035  12.963  21.066  1.00 52.39           C  
ATOM    128  CG  HIS A  18      32.435  12.981  20.515  1.00 54.17           C  
ATOM    129  ND1 HIS A  18      32.812  13.768  19.436  1.00 51.19           N  
ATOM    130  CD2 HIS A  18      33.556  12.335  20.917  1.00 51.93           C  
ATOM    131  CE1 HIS A  18      34.097  13.590  19.193  1.00 50.56           C  
ATOM    132  NE2 HIS A  18      34.570  12.718  20.065  1.00 53.55           N  
ATOM    133  N   LYS A  19      29.153  12.405  18.642  1.00 54.31           N  
ATOM    134  CA  LYS A  19      28.949  12.416  17.195  1.00 55.33           C  
ATOM    135  C   LYS A  19      28.426  13.764  16.695  1.00 55.08           C  
ATOM    136  O   LYS A  19      27.898  14.558  17.460  1.00 54.24           O  
ATOM    137  CB  LYS A  19      28.011  11.265  16.747  1.00 55.40           C  
ATOM    138  CG  LYS A  19      26.698  11.157  17.537  1.00 55.94           C  
ATOM    139  CD  LYS A  19      25.765  10.156  16.863  1.00 57.28           C  
ATOM    140  CE  LYS A  19      24.352  10.321  17.380  1.00 60.63           C  
ATOM    141  NZ  LYS A  19      23.937   9.286  18.380  1.00 63.35           N  
ATOM    142  N   THR A  20      28.593  14.002  15.398  1.00 55.70           N  
ATOM    143  CA  THR A  20      28.004  15.137  14.748  1.00 55.98           C  
ATOM    144  C   THR A  20      26.657  14.755  14.184  1.00 56.50           C  
ATOM    145  O   THR A  20      26.514  13.752  13.487  1.00 57.65           O  
ATOM    146  CB  THR A  20      28.923  15.702  13.668  1.00 56.47           C  
ATOM    147  OG1 THR A  20      30.149  16.120  14.282  1.00 56.19           O  
ATOM    148  CG2 THR A  20      28.283  16.926  13.000  1.00 55.48           C  
ATOM    149  N   VAL A  21      25.672  15.576  14.517  1.00 56.43           N  
ATOM    150  CA  VAL A  21      24.288  15.429  14.121  1.00 56.44           C  
ATOM    151  C   VAL A  21      23.842  16.744  13.430  1.00 55.70           C  
ATOM    152  O   VAL A  21      24.091  17.833  13.935  1.00 54.76           O  
ATOM    153  CB  VAL A  21      23.408  15.123  15.393  1.00 56.58           C  
ATOM    154  CG1 VAL A  21      21.925  15.318  15.135  1.00 58.70           C  
ATOM    155  CG2 VAL A  21      23.663  13.737  15.861  1.00 58.19           C  
ATOM    156  N   VAL A  22      23.217  16.613  12.259  1.00 55.47           N  
ATOM    157  CA  VAL A  22      22.485  17.707  11.629  1.00 54.58           C  
ATOM    158  C   VAL A  22      21.098  17.792  12.261  1.00 54.94           C  
ATOM    159  O   VAL A  22      20.434  16.758  12.469  1.00 55.75           O  
ATOM    160  CB  VAL A  22      22.350  17.506  10.103  1.00 54.21           C  
ATOM    161  CG1 VAL A  22      21.370  18.530   9.498  1.00 53.54           C  
ATOM    162  CG2 VAL A  22      23.700  17.598   9.443  1.00 52.31           C  
ATOM    163  N   VAL A  23      20.656  19.007  12.590  1.00 54.24           N  
ATOM    164  CA  VAL A  23      19.305  19.171  13.102  1.00 53.81           C  
ATOM    165  C   VAL A  23      18.393  19.991  12.175  1.00 54.46           C  
ATOM    166  O   VAL A  23      18.374  21.216  12.227  1.00 53.89           O  
ATOM    167  CB  VAL A  23      19.252  19.424  14.666  1.00 54.18           C  
ATOM    168  CG1 VAL A  23      20.573  19.948  15.252  1.00 53.32           C  
ATOM    169  CG2 VAL A  23      17.952  20.121  15.179  1.00 52.66           C  
ATOM    170  N   PRO A  24      17.628  19.270  11.319  1.00 55.37           N  
ATOM    171  CA  PRO A  24      16.722  19.763  10.273  1.00 55.95           C  
ATOM    172  C   PRO A  24      15.842  20.900  10.733  1.00 56.52           C  
ATOM    173  O   PRO A  24      15.576  21.830   9.962  1.00 57.39           O  
ATOM    174  CB  PRO A  24      15.833  18.543   9.977  1.00 56.32           C  
ATOM    175  CG  PRO A  24      16.715  17.355  10.276  1.00 56.08           C  
ATOM    176  CD  PRO A  24      17.637  17.789  11.385  1.00 55.06           C  
ATOM    177  N   GLU A  25      15.383  20.820  11.980  1.00 56.49           N  
ATOM    178  CA  GLU A  25      14.395  21.757  12.496  1.00 56.42           C  
ATOM    179  C   GLU A  25      15.048  22.988  13.113  1.00 55.58           C  
ATOM    180  O   GLU A  25      14.373  23.970  13.423  1.00 56.55           O  
ATOM    181  CB  GLU A  25      13.481  21.058  13.496  1.00 56.30           C  
ATOM    182  CG  GLU A  25      14.231  20.019  14.282  1.00 59.89           C  
ATOM    183  CD  GLU A  25      13.902  18.608  13.884  1.00 60.20           C  
ATOM    184  OE1 GLU A  25      12.705  18.310  13.735  1.00 57.87           O  
ATOM    185  OE2 GLU A  25      14.846  17.808  13.751  1.00 61.44           O  
ATOM    186  N   TRP A  26      16.361  22.932  13.293  1.00 54.37           N  
ATOM    187  CA  TRP A  26      17.112  24.113  13.679  1.00 52.54           C  
ATOM    188  C   TRP A  26      17.961  24.542  12.511  1.00 51.63           C  
ATOM    189  O   TRP A  26      19.180  24.698  12.627  1.00 52.00           O  
ATOM    190  CB  TRP A  26      17.975  23.850  14.901  1.00 51.69           C  
ATOM    191  CG  TRP A  26      17.238  23.481  16.168  1.00 51.69           C  
ATOM    192  CD1 TRP A  26      15.880  23.607  16.445  1.00 49.78           C  
ATOM    193  CD2 TRP A  26      17.848  22.999  17.367  1.00 49.98           C  
ATOM    194  NE1 TRP A  26      15.626  23.200  17.743  1.00 47.10           N  
ATOM    195  CE2 TRP A  26      16.816  22.826  18.326  1.00 51.06           C  
ATOM    196  CE3 TRP A  26      19.177  22.688  17.722  1.00 50.20           C  
ATOM    197  CZ2 TRP A  26      17.075  22.338  19.612  1.00 51.60           C  
ATOM    198  CZ3 TRP A  26      19.435  22.209  18.992  1.00 49.62           C  
ATOM    199  CH2 TRP A  26      18.383  22.045  19.930  1.00 50.93           C  
ATOM    200  N   GLU A  27      17.296  24.687  11.369  1.00 50.54           N  
ATOM    201  CA  GLU A  27      17.874  25.223  10.122  1.00 49.61           C  
ATOM    202  C   GLU A  27      19.066  24.474   9.559  1.00 48.69           C  
ATOM    203  O   GLU A  27      19.891  25.056   8.863  1.00 49.14           O  
ATOM    204  CB  GLU A  27      18.130  26.731  10.249  1.00 48.98           C  
ATOM    205  CG  GLU A  27      16.846  27.434  10.703  1.00 50.66           C  
ATOM    206  CD  GLU A  27      16.987  28.928  10.867  1.00 52.45           C  
ATOM    207  OE1 GLU A  27      18.118  29.451  10.704  1.00 52.96           O  
ATOM    208  OE2 GLU A  27      15.956  29.574  11.171  1.00 52.83           O  
ATOM    209  N   GLY A  28      19.142  23.173   9.826  1.00 47.70           N  
ATOM    210  CA  GLY A  28      20.190  22.339   9.248  1.00 46.64           C  
ATOM    211  C   GLY A  28      21.490  22.430  10.022  1.00 46.75           C  
ATOM    212  O   GLY A  28      22.464  21.818   9.645  1.00 46.94           O  
ATOM    213  N   VAL A  29      21.498  23.161  11.137  1.00 47.51           N  
ATOM    214  CA  VAL A  29      22.717  23.362  11.956  1.00 47.32           C  
ATOM    215  C   VAL A  29      23.246  22.032  12.455  1.00 47.94           C  
ATOM    216  O   VAL A  29      22.461  21.118  12.784  1.00 48.12           O  
ATOM    217  CB  VAL A  29      22.455  24.366  13.164  1.00 47.37           C  
ATOM    218  CG1 VAL A  29      21.701  23.698  14.334  1.00 45.14           C  
ATOM    219  CG2 VAL A  29      23.732  25.022  13.659  1.00 45.60           C  
ATOM    220  N   LYS A  30      24.561  21.904  12.489  1.00 47.81           N  
ATOM    221  CA  LYS A  30      25.184  20.746  13.078  1.00 49.49           C  
ATOM    222  C   LYS A  30      25.496  21.060  14.533  1.00 49.25           C  
ATOM    223  O   LYS A  30      25.887  22.185  14.865  1.00 48.70           O  
ATOM    224  CB  LYS A  30      26.490  20.359  12.378  1.00 49.36           C  
ATOM    225  CG  LYS A  30      26.398  19.945  10.939  1.00 52.59           C  
ATOM    226  CD  LYS A  30      27.830  19.896  10.333  1.00 53.01           C  
ATOM    227  CE  LYS A  30      28.184  21.254   9.645  1.00 59.25           C  
ATOM    228  NZ  LYS A  30      29.662  21.477   9.314  1.00 56.77           N  
ATOM    229  N   VAL A  31      25.284  20.053  15.389  1.00 49.69           N  
ATOM    230  CA  VAL A  31      25.640  20.082  16.798  1.00 49.37           C  
ATOM    231  C   VAL A  31      26.462  18.825  17.029  1.00 49.62           C  
ATOM    232  O   VAL A  31      26.533  17.953  16.162  1.00 50.13           O  
ATOM    233  CB  VAL A  31      24.379  20.081  17.752  1.00 49.65           C  
ATOM    234  CG1 VAL A  31      23.475  21.258  17.438  1.00 49.49           C  
ATOM    235  CG2 VAL A  31      23.592  18.705  17.725  1.00 47.53           C  
ATOM    236  N   VAL A  32      27.108  18.758  18.184  1.00 49.26           N  
ATOM    237  CA  VAL A  32      27.806  17.576  18.618  1.00 47.85           C  
ATOM    238  C   VAL A  32      27.072  17.059  19.848  1.00 47.39           C  
ATOM    239  O   VAL A  32      26.773  17.798  20.772  1.00 47.71           O  
ATOM    240  CB  VAL A  32      29.308  17.883  18.919  1.00 48.68           C  
ATOM    241  CG1 VAL A  32      29.950  16.745  19.705  1.00 47.10           C  
ATOM    242  CG2 VAL A  32      30.099  18.151  17.620  1.00 46.53           C  
ATOM    243  N   LEU A  33      26.737  15.789  19.817  1.00 47.45           N  
ATOM    244  CA  LEU A  33      26.125  15.105  20.934  1.00 48.43           C  
ATOM    245  C   LEU A  33      27.174  14.204  21.585  1.00 48.75           C  
ATOM    246  O   LEU A  33      27.831  13.410  20.908  1.00 48.94           O  
ATOM    247  CB  LEU A  33      24.937  14.222  20.439  1.00 48.04           C  
ATOM    248  CG  LEU A  33      23.706  14.919  19.831  1.00 47.68           C  
ATOM    249  CD1 LEU A  33      22.590  13.920  19.539  1.00 46.23           C  
ATOM    250  CD2 LEU A  33      23.180  16.091  20.711  1.00 44.11           C  
ATOM    251  N   ARG A  34      27.310  14.338  22.898  1.00 49.06           N  
ATOM    252  CA  ARG A  34      28.228  13.529  23.686  1.00 49.52           C  
ATOM    253  C   ARG A  34      27.404  12.717  24.693  1.00 48.41           C  
ATOM    254  O   ARG A  34      26.345  13.145  25.063  1.00 48.21           O  
ATOM    255  CB  ARG A  34      29.280  14.436  24.377  1.00 49.38           C  
ATOM    256  CG  ARG A  34      28.793  15.176  25.612  1.00 50.56           C  
ATOM    257  CD  ARG A  34      30.024  15.706  26.268  1.00 52.21           C  
ATOM    258  NE  ARG A  34      29.965  16.714  27.327  1.00 50.32           N  
ATOM    259  CZ  ARG A  34      29.374  16.578  28.509  1.00 56.44           C  
ATOM    260  NH1 ARG A  34      28.597  15.514  28.760  1.00 58.56           N  
ATOM    261  NH2 ARG A  34      29.506  17.554  29.436  1.00 54.69           N  
ATOM    262  N   GLU A  35      27.865  11.529  25.078  1.00 48.26           N  
ATOM    263  CA  GLU A  35      27.288  10.815  26.202  1.00 48.06           C  
ATOM    264  C   GLU A  35      27.372  11.705  27.469  1.00 47.87           C  
ATOM    265  O   GLU A  35      28.218  12.574  27.537  1.00 47.94           O  
ATOM    266  CB  GLU A  35      28.012   9.491  26.424  1.00 47.75           C  
ATOM    267  CG  GLU A  35      29.429   9.648  26.935  1.00 48.90           C  
ATOM    268  CD  GLU A  35      30.104   8.312  27.101  1.00 51.20           C  
ATOM    269  OE1 GLU A  35      29.542   7.475  27.837  1.00 51.87           O  
ATOM    270  OE2 GLU A  35      31.194   8.108  26.516  1.00 53.06           O  
ATOM    271  N   PRO A  36      26.462  11.522  28.443  1.00 48.47           N  
ATOM    272  CA  PRO A  36      26.565  12.340  29.649  1.00 49.49           C  
ATOM    273  C   PRO A  36      27.764  12.016  30.509  1.00 50.59           C  
ATOM    274  O   PRO A  36      28.243  10.866  30.534  1.00 50.04           O  
ATOM    275  CB  PRO A  36      25.278  12.013  30.419  1.00 49.87           C  
ATOM    276  CG  PRO A  36      24.370  11.423  29.382  1.00 50.10           C  
ATOM    277  CD  PRO A  36      25.246  10.686  28.453  1.00 48.14           C  
ATOM    278  N   SER A  37      28.224  13.041  31.213  1.00 51.28           N  
ATOM    279  CA  SER A  37      29.311  12.906  32.118  1.00 53.04           C  
ATOM    280  C   SER A  37      28.794  12.161  33.332  1.00 53.81           C  
ATOM    281  O   SER A  37      27.581  11.998  33.498  1.00 53.37           O  
ATOM    282  CB  SER A  37      29.897  14.297  32.461  1.00 53.49           C  
ATOM    283  OG  SER A  37      29.288  14.865  33.597  1.00 55.07           O  
ATOM    284  N   GLY A  38      29.698  11.648  34.166  1.00 54.60           N  
ATOM    285  CA  GLY A  38      29.253  11.029  35.427  1.00 55.87           C  
ATOM    286  C   GLY A  38      28.709  12.033  36.437  1.00 56.81           C  
ATOM    287  O   GLY A  38      27.984  11.666  37.344  1.00 56.42           O  
ATOM    288  N   GLU A  39      29.089  13.302  36.267  1.00 58.99           N  
ATOM    289  CA  GLU A  39      28.576  14.455  37.039  1.00 60.49           C  
ATOM    290  C   GLU A  39      27.153  14.847  36.611  1.00 60.55           C  
ATOM    291  O   GLU A  39      26.480  15.624  37.301  1.00 61.11           O  
ATOM    292  CB  GLU A  39      29.506  15.665  36.843  1.00 61.02           C  
ATOM    293  CG  GLU A  39      30.686  15.722  37.822  1.00 64.86           C  
ATOM    294  CD  GLU A  39      32.034  16.004  37.162  1.00 68.50           C  
ATOM    295  OE1 GLU A  39      32.131  15.999  35.901  1.00 70.61           O  
ATOM    296  OE2 GLU A  39      33.011  16.208  37.926  1.00 70.37           O  
ATOM    297  N   ALA A  40      26.705  14.325  35.474  1.00 59.73           N  
ATOM    298  CA  ALA A  40      25.341  14.560  35.006  1.00 58.99           C  
ATOM    299  C   ALA A  40      24.457  13.351  35.270  1.00 58.68           C  
ATOM    300  O   ALA A  40      23.338  13.492  35.741  1.00 58.55           O  
ATOM    301  CB  ALA A  40      25.338  14.920  33.551  1.00 58.45           C  
ATOM    302  N   TRP A  41      24.946  12.156  34.982  1.00 58.61           N  
ATOM    303  CA  TRP A  41      24.220  10.963  35.413  1.00 58.99           C  
ATOM    304  C   TRP A  41      24.041  11.008  36.934  1.00 60.03           C  
ATOM    305  O   TRP A  41      23.078  10.450  37.463  1.00 59.99           O  
ATOM    306  CB  TRP A  41      24.976   9.692  35.069  1.00 58.25           C  
ATOM    307  CG  TRP A  41      24.863   9.256  33.705  1.00 56.92           C  
ATOM    308  CD1 TRP A  41      25.886   9.101  32.814  1.00 57.60           C  
ATOM    309  CD2 TRP A  41      23.674   8.875  33.029  1.00 57.34           C  
ATOM    310  NE1 TRP A  41      25.397   8.653  31.608  1.00 58.43           N  
ATOM    311  CE2 TRP A  41      24.035   8.511  31.719  1.00 59.36           C  
ATOM    312  CE3 TRP A  41      22.325   8.826  33.390  1.00 57.95           C  
ATOM    313  CZ2 TRP A  41      23.087   8.088  30.780  1.00 58.59           C  
ATOM    314  CZ3 TRP A  41      21.403   8.418  32.454  1.00 55.90           C  
ATOM    315  CH2 TRP A  41      21.780   8.039  31.184  1.00 56.19           C  
ATOM    316  N   LEU A  42      25.004  11.642  37.616  0.70 60.92           N  
ATOM    317  CA  LEU A  42      24.887  12.009  39.024  0.70 62.18           C  
ATOM    318  C   LEU A  42      23.508  12.624  39.321  0.70 62.55           C  
ATOM    319  O   LEU A  42      22.643  11.994  39.942  0.70 62.65           O  
ATOM    320  CB  LEU A  42      25.997  13.006  39.379  0.70 62.30           C  
ATOM    321  CG  LEU A  42      26.104  13.642  40.765  0.70 63.10           C  
ATOM    322  CD1 LEU A  42      27.124  12.900  41.612  0.70 64.19           C  
ATOM    323  CD2 LEU A  42      26.471  15.126  40.626  0.70 63.56           C  
ATOM    324  N   ARG A  43      23.295  13.842  38.842  0.70 63.28           N  
ATOM    325  CA  ARG A  43      22.054  14.543  39.118  0.70 63.59           C  
ATOM    326  C   ARG A  43      20.812  13.803  38.610  0.70 63.74           C  
ATOM    327  O   ARG A  43      19.770  13.831  39.262  0.70 63.97           O  
ATOM    328  CB  ARG A  43      22.107  15.972  38.589  0.70 63.64           C  
ATOM    329  CG  ARG A  43      21.182  16.890  39.361  0.70 64.45           C  
ATOM    330  CD  ARG A  43      21.145  18.285  38.800  0.70 66.82           C  
ATOM    331  NE  ARG A  43      20.264  19.120  39.613  0.70 69.92           N  
ATOM    332  CZ  ARG A  43      20.073  20.425  39.436  0.70 70.91           C  
ATOM    333  NH1 ARG A  43      20.701  21.075  38.455  0.70 69.78           N  
ATOM    334  NH2 ARG A  43      19.248  21.081  40.254  0.70 70.77           N  
ATOM    335  N   TRP A  44      20.921  13.121  37.473  0.70 63.85           N  
ATOM    336  CA  TRP A  44      19.764  12.443  36.890  0.70 64.02           C  
ATOM    337  C   TRP A  44      19.056  11.467  37.834  0.70 64.30           C  
ATOM    338  O   TRP A  44      17.829  11.439  37.857  0.70 64.46           O  
ATOM    339  CB  TRP A  44      20.118  11.737  35.599  0.70 63.78           C  
ATOM    340  CG  TRP A  44      18.959  11.548  34.677  0.70 63.82           C  
ATOM    341  CD1 TRP A  44      18.176  12.520  34.169  0.70 63.90           C  
ATOM    342  CD2 TRP A  44      18.477  10.310  34.115  0.70 64.34           C  
ATOM    343  NE1 TRP A  44      17.220  11.987  33.335  0.70 64.34           N  
ATOM    344  CE2 TRP A  44      17.387  10.631  33.278  0.70 63.92           C  
ATOM    345  CE3 TRP A  44      18.861   8.963  34.240  0.70 65.50           C  
ATOM    346  CZ2 TRP A  44      16.674   9.660  32.556  0.70 64.15           C  
ATOM    347  CZ3 TRP A  44      18.148   7.990  33.521  0.70 64.75           C  
ATOM    348  CH2 TRP A  44      17.070   8.352  32.686  0.70 64.48           C  
ATOM    349  N   GLN A  45      19.801  10.670  38.602  0.70 64.69           N  
ATOM    350  CA  GLN A  45      19.159   9.764  39.586  0.70 64.95           C  
ATOM    351  C   GLN A  45      18.962  10.445  40.959  0.70 64.81           C  
ATOM    352  O   GLN A  45      18.379   9.870  41.872  0.70 64.89           O  
ATOM    353  CB  GLN A  45      19.915   8.426  39.715  0.70 65.29           C  
ATOM    354  CG  GLN A  45      18.998   7.228  40.061  0.70 66.10           C  
ATOM    355  CD  GLN A  45      19.635   6.214  41.031  0.70 67.05           C  
ATOM    356  OE1 GLN A  45      20.809   5.854  40.903  0.70 67.62           O  
ATOM    357  NE2 GLN A  45      18.845   5.739  41.994  0.70 66.61           N  
ATOM    358  N   GLU A  46      19.475  11.665  41.081  0.70 64.91           N  
ATOM    359  CA  GLU A  46      19.245  12.544  42.218  0.70 64.87           C  
ATOM    360  C   GLU A  46      17.903  13.251  42.039  0.70 65.03           C  
ATOM    361  O   GLU A  46      17.145  13.436  43.014  0.70 64.79           O  
ATOM    362  CB  GLU A  46      20.400  13.546  42.322  0.70 64.83           C  
ATOM    363  CG  GLU A  46      20.046  14.989  42.695  0.70 65.37           C  
ATOM    364  CD  GLU A  46      21.212  15.742  43.345  0.70 65.68           C  
ATOM    365  OE1 GLU A  46      22.347  15.201  43.373  0.70 66.82           O  
ATOM    366  OE2 GLU A  46      20.996  16.873  43.840  0.70 66.09           O  
ATOM    367  N   VAL A  47      17.609  13.640  40.795  0.70 64.80           N  
ATOM    368  CA  VAL A  47      16.302  14.174  40.454  0.70 64.40           C  
ATOM    369  C   VAL A  47      15.251  13.058  40.539  0.70 64.55           C  
ATOM    370  O   VAL A  47      14.269  13.201  41.276  0.70 64.59           O  
ATOM    371  CB  VAL A  47      16.276  14.890  39.072  0.70 64.77           C  
ATOM    372  CG1 VAL A  47      14.897  15.554  38.820  0.70 63.89           C  
ATOM    373  CG2 VAL A  47      17.397  15.934  38.964  0.70 64.14           C  
ATOM    374  N   VAL A  48      15.467  11.946  39.831  0.70 64.53           N  
ATOM    375  CA  VAL A  48      14.451  10.876  39.763  0.70 64.61           C  
ATOM    376  C   VAL A  48      14.186  10.241  41.137  0.70 64.94           C  
ATOM    377  O   VAL A  48      13.264  10.652  41.857  0.70 64.90           O  
ATOM    378  CB  VAL A  48      14.805   9.754  38.744  0.70 64.62           C  
ATOM    379  CG1 VAL A  48      13.557   8.898  38.437  0.70 64.31           C  
ATOM    380  CG2 VAL A  48      15.363  10.338  37.450  0.70 64.34           C  
ATOM    381  N   ASN A  56       3.705   9.007  48.468  1.00 61.41           N  
ATOM    382  CA  ASN A  56       2.985   8.406  47.242  1.00 61.69           C  
ATOM    383  C   ASN A  56       2.997   9.632  46.255  1.00 61.29           C  
ATOM    384  O   ASN A  56       2.622  10.763  46.621  1.00 61.48           O  
ATOM    385  CB  ASN A  56       1.343   8.038  47.530  1.00 61.88           C  
ATOM    386  CG  ASN A  56       1.299   7.613  49.046  1.00 62.96           C  
ATOM    387  OD1 ASN A  56       2.241   6.841  49.295  1.00 64.43           O  
ATOM    388  ND2 ASN A  56       0.490   8.719  49.949  1.00 62.00           N  
ATOM    389  N   VAL A  57       3.432   9.404  44.990  1.00 60.96           N  
ATOM    390  CA  VAL A  57       3.562  10.467  43.936  1.00 60.00           C  
ATOM    391  C   VAL A  57       2.297  10.647  43.073  1.00 59.34           C  
ATOM    392  O   VAL A  57       1.674   9.625  42.683  1.00 58.60           O  
ATOM    393  CB  VAL A  57       4.760  10.145  43.059  1.00 60.16           C  
ATOM    394  CG1 VAL A  57       4.661   8.741  42.439  1.00 60.44           C  
ATOM    395  CG2 VAL A  57       4.963  11.243  41.962  1.00 60.81           C  
ATOM    396  N   SER A  58       1.868  11.894  42.833  1.00 58.44           N  
ATOM    397  CA  SER A  58       0.817  12.059  41.869  1.00 57.27           C  
ATOM    398  C   SER A  58       1.464  11.802  40.469  1.00 56.64           C  
ATOM    399  O   SER A  58       2.770  11.949  40.209  1.00 56.44           O  
ATOM    400  CB  SER A  58       0.143  13.463  41.959  1.00 57.13           C  
ATOM    401  OG  SER A  58       0.794  14.473  41.168  1.00 57.31           O  
ATOM    402  N   VAL A  59       0.580  11.467  39.497  1.00 55.54           N  
ATOM    403  CA  VAL A  59       0.972  11.173  38.104  1.00 54.27           C  
ATOM    404  C   VAL A  59       1.695  12.355  37.436  1.00 53.44           C  
ATOM    405  O   VAL A  59       2.688  12.154  36.717  1.00 53.53           O  
ATOM    406  CB  VAL A  59      -0.257  10.713  37.249  1.00 54.01           C  
ATOM    407  CG1 VAL A  59       0.049  10.729  35.763  1.00 54.31           C  
ATOM    408  CG2 VAL A  59      -0.714   9.320  37.665  1.00 54.19           C  
ATOM    409  N   SER A  60       1.208  13.576  37.674  1.00 52.56           N  
ATOM    410  CA  SER A  60       1.809  14.776  37.083  1.00 52.01           C  
ATOM    411  C   SER A  60       3.147  15.149  37.751  1.00 52.02           C  
ATOM    412  O   SER A  60       4.051  15.660  37.091  1.00 52.04           O  
ATOM    413  CB  SER A  60       0.823  15.945  37.115  1.00 51.84           C  
ATOM    414  OG  SER A  60       0.470  16.244  38.442  1.00 52.71           O  
ATOM    415  N   GLU A  61       3.263  14.856  39.047  1.00 52.09           N  
ATOM    416  CA  GLU A  61       4.505  15.017  39.778  1.00 52.54           C  
ATOM    417  C   GLU A  61       5.560  14.045  39.242  1.00 51.54           C  
ATOM    418  O   GLU A  61       6.699  14.452  39.032  1.00 51.78           O  
ATOM    419  CB  GLU A  61       4.282  14.835  41.290  1.00 52.59           C  
ATOM    420  CG  GLU A  61       5.437  15.350  42.153  1.00 53.98           C  
ATOM    421  CD  GLU A  61       5.245  15.098  43.640  1.00 54.83           C  
ATOM    422  OE1 GLU A  61       4.123  15.348  44.195  1.00 60.63           O  
ATOM    423  OE2 GLU A  61       6.229  14.660  44.269  1.00 55.84           O  
ATOM    424  N   LYS A  62       5.173  12.782  39.002  1.00 50.72           N  
ATOM    425  CA  LYS A  62       6.041  11.823  38.305  1.00 50.53           C  
ATOM    426  C   LYS A  62       6.559  12.322  36.934  1.00 49.35           C  
ATOM    427  O   LYS A  62       7.757  12.319  36.704  1.00 49.18           O  
ATOM    428  CB  LYS A  62       5.360  10.450  38.161  1.00 50.47           C  
ATOM    429  CG  LYS A  62       6.192   9.456  37.323  1.00 51.86           C  
ATOM    430  CD  LYS A  62       5.500   8.064  37.161  1.00 52.92           C  
ATOM    431  CE  LYS A  62       6.491   7.101  36.372  1.00 55.39           C  
ATOM    432  NZ  LYS A  62       6.855   7.671  34.997  1.00 58.54           N  
ATOM    433  N   ALA A  63       5.657  12.746  36.040  1.00 49.09           N  
ATOM    434  CA  ALA A  63       6.030  13.398  34.748  1.00 48.84           C  
ATOM    435  C   ALA A  63       6.829  14.698  34.852  1.00 48.76           C  
ATOM    436  O   ALA A  63       7.642  15.004  33.976  1.00 49.82           O  
ATOM    437  CB  ALA A  63       4.794  13.652  33.891  1.00 47.46           C  
ATOM    438  N   HIS A  64       6.579  15.495  35.881  1.00 48.84           N  
ATOM    439  CA  HIS A  64       7.274  16.779  35.987  1.00 49.24           C  
ATOM    440  C   HIS A  64       8.752  16.582  36.323  1.00 49.37           C  
ATOM    441  O   HIS A  64       9.633  17.201  35.711  1.00 49.22           O  
ATOM    442  CB  HIS A  64       6.618  17.686  37.032  1.00 49.01           C  
ATOM    443  CG  HIS A  64       7.362  18.962  37.247  1.00 49.96           C  
ATOM    444  ND1 HIS A  64       7.450  19.942  36.282  1.00 51.90           N  
ATOM    445  CD2 HIS A  64       8.079  19.406  38.306  1.00 50.78           C  
ATOM    446  CE1 HIS A  64       8.165  20.948  36.750  1.00 51.76           C  
ATOM    447  NE2 HIS A  64       8.553  20.650  37.977  1.00 49.58           N  
ATOM    448  N   ARG A  65       9.011  15.695  37.275  1.00 48.89           N  
ATOM    449  CA  ARG A  65      10.362  15.453  37.718  1.00 50.39           C  
ATOM    450  C   ARG A  65      11.175  14.688  36.673  1.00 50.07           C  
ATOM    451  O   ARG A  65      12.385  14.876  36.577  1.00 49.98           O  
ATOM    452  CB  ARG A  65      10.370  14.776  39.094  1.00 50.91           C  
ATOM    453  CG  ARG A  65      10.306  13.295  39.021  1.00 54.27           C  
ATOM    454  CD  ARG A  65       9.856  12.690  40.320  1.00 60.80           C  
ATOM    455  NE  ARG A  65      10.016  11.245  40.215  1.00 63.38           N  
ATOM    456  CZ  ARG A  65       9.459  10.367  41.027  1.00 63.33           C  
ATOM    457  NH1 ARG A  65       8.685  10.779  42.028  1.00 65.61           N  
ATOM    458  NH2 ARG A  65       9.672   9.076  40.817  1.00 62.62           N  
ATOM    459  N   ASN A  66      10.514  13.881  35.849  1.00 50.54           N  
ATOM    460  CA  ASN A  66      11.189  13.233  34.728  1.00 50.91           C  
ATOM    461  C   ASN A  66      11.586  14.239  33.670  1.00 50.79           C  
ATOM    462  O   ASN A  66      12.650  14.152  33.047  1.00 50.62           O  
ATOM    463  CB  ASN A  66      10.343  12.091  34.165  1.00 51.43           C  
ATOM    464  CG  ASN A  66      10.455  10.814  35.010  1.00 54.01           C  
ATOM    465  OD1 ASN A  66      11.546  10.225  35.148  1.00 60.09           O  
ATOM    466  ND2 ASN A  66       9.343  10.377  35.573  1.00 55.50           N  
ATOM    467  N   LEU A  67      10.736  15.237  33.498  1.00 51.53           N  
ATOM    468  CA  LEU A  67      11.031  16.350  32.632  1.00 51.22           C  
ATOM    469  C   LEU A  67      12.239  17.146  33.141  1.00 50.74           C  
ATOM    470  O   LEU A  67      13.172  17.344  32.402  1.00 50.01           O  
ATOM    471  CB  LEU A  67       9.800  17.234  32.474  1.00 51.78           C  
ATOM    472  CG  LEU A  67       9.993  18.427  31.537  1.00 55.26           C  
ATOM    473  CD1 LEU A  67       9.928  17.970  30.045  1.00 56.13           C  
ATOM    474  CD2 LEU A  67       8.952  19.547  31.903  1.00 57.38           C  
ATOM    475  N   CYS A  68      12.202  17.589  34.395  1.00 50.75           N  
ATOM    476  CA  CYS A  68      13.343  18.205  35.069  1.00 51.55           C  
ATOM    477  C   CYS A  68      14.646  17.452  34.938  1.00 51.19           C  
ATOM    478  O   CYS A  68      15.688  18.055  34.676  1.00 51.37           O  
ATOM    479  CB  CYS A  68      13.064  18.390  36.559  1.00 50.98           C  
ATOM    480  SG  CYS A  68      11.725  19.482  36.820  1.00 57.51           S  
ATOM    481  N   ALA A  69      14.587  16.148  35.185  1.00 51.51           N  
ATOM    482  CA  ALA A  69      15.742  15.268  35.045  1.00 50.95           C  
ATOM    483  C   ALA A  69      16.198  15.198  33.598  1.00 51.46           C  
ATOM    484  O   ALA A  69      17.412  15.230  33.335  1.00 51.41           O  
ATOM    485  CB  ALA A  69      15.407  13.891  35.546  1.00 50.80           C  
ATOM    486  N   ASP A  70      15.236  15.107  32.659  1.00 51.32           N  
ATOM    487  CA  ASP A  70      15.580  15.056  31.238  1.00 50.65           C  
ATOM    488  C   ASP A  70      16.306  16.351  30.849  1.00 50.67           C  
ATOM    489  O   ASP A  70      17.346  16.323  30.182  1.00 50.49           O  
ATOM    490  CB  ASP A  70      14.355  14.826  30.338  1.00 50.09           C  
ATOM    491  CG  ASP A  70      13.860  13.392  30.353  1.00 52.22           C  
ATOM    492  OD1 ASP A  70      14.452  12.550  31.061  1.00 56.03           O  
ATOM    493  OD2 ASP A  70      12.840  13.093  29.675  1.00 51.11           O  
ATOM    494  N   VAL A  71      15.793  17.503  31.259  1.00 51.41           N  
ATOM    495  CA  VAL A  71      16.491  18.728  30.823  1.00 51.42           C  
ATOM    496  C   VAL A  71      17.950  18.823  31.310  1.00 52.20           C  
ATOM    497  O   VAL A  71      18.769  19.349  30.598  1.00 53.36           O  
ATOM    498  CB  VAL A  71      15.669  20.087  30.920  1.00 51.56           C  
ATOM    499  CG1 VAL A  71      14.176  19.882  31.035  1.00 48.49           C  
ATOM    500  CG2 VAL A  71      16.255  21.060  31.925  1.00 48.47           C  
ATOM    501  N   VAL A  72      18.249  18.254  32.489  1.00 53.01           N  
ATOM    502  CA  VAL A  72      19.577  18.203  33.124  1.00 52.50           C  
ATOM    503  C   VAL A  72      20.550  17.358  32.347  1.00 52.16           C  
ATOM    504  O   VAL A  72      21.718  17.741  32.168  1.00 53.69           O  
ATOM    505  CB  VAL A  72      19.475  17.666  34.597  1.00 53.19           C  
ATOM    506  CG1 VAL A  72      20.768  16.907  35.073  1.00 53.68           C  
ATOM    507  CG2 VAL A  72      19.111  18.782  35.525  1.00 52.64           C  
ATOM    508  N   LEU A  73      20.089  16.199  31.900  1.00 50.86           N  
ATOM    509  CA  LEU A  73      20.875  15.405  30.996  1.00 50.43           C  
ATOM    510  C   LEU A  73      21.050  16.153  29.678  1.00 49.51           C  
ATOM    511  O   LEU A  73      22.121  16.107  29.075  1.00 49.43           O  
ATOM    512  CB  LEU A  73      20.248  14.005  30.758  1.00 49.28           C  
ATOM    513  CG  LEU A  73      20.602  12.840  31.653  1.00 50.26           C  
ATOM    514  CD1 LEU A  73      20.013  11.528  31.115  1.00 47.95           C  
ATOM    515  CD2 LEU A  73      22.113  12.748  31.812  1.00 52.04           C  
ATOM    516  N   PHE A  74      19.992  16.794  29.194  1.00 49.36           N  
ATOM    517  CA  PHE A  74      20.057  17.484  27.879  1.00 48.79           C  
ATOM    518  C   PHE A  74      21.133  18.559  27.791  1.00 49.62           C  
ATOM    519  O   PHE A  74      21.895  18.665  26.802  1.00 50.97           O  
ATOM    520  CB  PHE A  74      18.701  18.094  27.495  1.00 46.94           C  
ATOM    521  CG  PHE A  74      18.761  18.943  26.234  1.00 47.43           C  
ATOM    522  CD1 PHE A  74      18.818  18.347  24.973  1.00 45.86           C  
ATOM    523  CD2 PHE A  74      18.773  20.343  26.309  1.00 45.71           C  
ATOM    524  CE1 PHE A  74      18.879  19.131  23.805  1.00 42.28           C  
ATOM    525  CE2 PHE A  74      18.840  21.130  25.128  1.00 46.06           C  
ATOM    526  CZ  PHE A  74      18.872  20.515  23.896  1.00 46.15           C  
ATOM    527  N   ILE A  75      21.146  19.391  28.815  1.00 49.72           N  
ATOM    528  CA  ILE A  75      22.072  20.462  28.927  1.00 50.70           C  
ATOM    529  C   ILE A  75      23.503  19.927  28.902  1.00 51.15           C  
ATOM    530  O   ILE A  75      24.400  20.582  28.420  1.00 50.53           O  
ATOM    531  CB  ILE A  75      21.761  21.215  30.189  1.00 50.52           C  
ATOM    532  CG1 ILE A  75      20.612  22.187  29.935  1.00 50.48           C  
ATOM    533  CG2 ILE A  75      22.983  21.885  30.775  1.00 51.95           C  
ATOM    534  CD1 ILE A  75      19.887  22.552  31.240  1.00 54.67           C  
ATOM    535  N   ASP A  76      23.687  18.714  29.395  1.00 52.37           N  
ATOM    536  CA  ASP A  76      24.982  18.134  29.488  1.00 53.48           C  
ATOM    537  C   ASP A  76      25.417  17.455  28.202  1.00 53.87           C  
ATOM    538  O   ASP A  76      26.601  17.442  27.859  1.00 54.65           O  
ATOM    539  CB  ASP A  76      24.988  17.130  30.630  1.00 55.24           C  
ATOM    540  CG  ASP A  76      26.395  16.653  30.968  1.00 56.86           C  
ATOM    541  OD1 ASP A  76      27.211  17.482  31.448  1.00 54.51           O  
ATOM    542  OD2 ASP A  76      26.649  15.453  30.730  1.00 60.72           O  
ATOM    543  N   VAL A  77      24.477  16.884  27.470  1.00 53.74           N  
ATOM    544  CA  VAL A  77      24.855  16.197  26.240  1.00 52.88           C  
ATOM    545  C   VAL A  77      25.088  17.093  25.038  1.00 52.25           C  
ATOM    546  O   VAL A  77      25.771  16.683  24.117  1.00 53.01           O  
ATOM    547  CB  VAL A  77      23.876  15.037  25.880  1.00 53.36           C  
ATOM    548  CG1 VAL A  77      23.722  14.097  27.058  1.00 52.01           C  
ATOM    549  CG2 VAL A  77      22.517  15.562  25.375  1.00 52.17           C  
ATOM    550  N   LEU A  78      24.525  18.299  25.037  1.00 51.36           N  
ATOM    551  CA  LEU A  78      24.450  19.126  23.819  1.00 50.86           C  
ATOM    552  C   LEU A  78      25.598  20.093  23.699  1.00 51.07           C  
ATOM    553  O   LEU A  78      25.768  20.966  24.552  1.00 51.20           O  
ATOM    554  CB  LEU A  78      23.122  19.932  23.746  1.00 51.19           C  
ATOM    555  CG  LEU A  78      22.897  20.722  22.442  1.00 50.70           C  
ATOM    556  CD1 LEU A  78      22.574  19.746  21.297  1.00 50.01           C  
ATOM    557  CD2 LEU A  78      21.796  21.803  22.574  1.00 49.77           C  
ATOM    558  N   CYS A  79      26.347  19.956  22.602  1.00 51.11           N  
ATOM    559  CA  CYS A  79      27.570  20.711  22.373  1.00 51.22           C  
ATOM    560  C   CYS A  79      27.529  21.349  20.992  1.00 51.26           C  
ATOM    561  O   CYS A  79      26.809  20.884  20.110  1.00 51.38           O  
ATOM    562  CB  CYS A  79      28.801  19.793  22.515  1.00 50.55           C  
ATOM    563  SG  CYS A  79      29.100  19.119  24.178  1.00 53.22           S  
ATOM    564  N   ASP A  80      28.292  22.419  20.816  1.00 51.77           N  
ATOM    565  CA  ASP A  80      28.508  22.998  19.498  1.00 52.58           C  
ATOM    566  C   ASP A  80      29.604  22.217  18.738  1.00 52.88           C  
ATOM    567  O   ASP A  80      30.184  21.293  19.287  1.00 53.21           O  
ATOM    568  CB  ASP A  80      28.799  24.505  19.598  1.00 52.76           C  
ATOM    569  CG  ASP A  80      30.162  24.833  20.235  1.00 52.36           C  
ATOM    570  OD1 ASP A  80      31.052  23.992  20.289  1.00 54.39           O  
ATOM    571  OD2 ASP A  80      30.355  25.974  20.679  1.00 56.86           O  
ATOM    572  N   THR A  81      29.892  22.584  17.496  1.00 53.70           N  
ATOM    573  CA  THR A  81      30.866  21.832  16.685  1.00 55.14           C  
ATOM    574  C   THR A  81      32.335  21.989  17.141  1.00 55.81           C  
ATOM    575  O   THR A  81      33.182  21.158  16.813  1.00 55.86           O  
ATOM    576  CB  THR A  81      30.717  22.129  15.169  1.00 54.73           C  
ATOM    577  OG1 THR A  81      30.841  23.540  14.946  1.00 55.71           O  
ATOM    578  CG2 THR A  81      29.343  21.637  14.661  1.00 53.23           C  
ATOM    579  N   ASP A  82      32.622  23.039  17.911  1.00 56.93           N  
ATOM    580  CA  ASP A  82      33.918  23.177  18.565  1.00 58.53           C  
ATOM    581  C   ASP A  82      33.947  22.425  19.888  1.00 59.01           C  
ATOM    582  O   ASP A  82      34.816  22.665  20.727  1.00 60.68           O  
ATOM    583  CB  ASP A  82      34.267  24.653  18.785  1.00 59.09           C  
ATOM    584  CG  ASP A  82      34.238  25.456  17.494  1.00 61.30           C  
ATOM    585  OD1 ASP A  82      34.885  25.040  16.509  1.00 65.00           O  
ATOM    586  OD2 ASP A  82      33.563  26.504  17.456  1.00 64.16           O  
ATOM    587  N   LYS A  83      32.985  21.528  20.071  1.00 58.94           N  
ATOM    588  CA  LYS A  83      32.937  20.588  21.204  1.00 59.16           C  
ATOM    589  C   LYS A  83      32.836  21.310  22.550  1.00 58.61           C  
ATOM    590  O   LYS A  83      33.260  20.814  23.597  1.00 58.80           O  
ATOM    591  CB  LYS A  83      34.054  19.524  21.117  1.00 59.49           C  
ATOM    592  CG  LYS A  83      34.118  18.871  19.706  1.00 58.75           C  
ATOM    593  CD  LYS A  83      34.873  17.569  19.667  1.00 60.61           C  
ATOM    594  CE  LYS A  83      35.292  17.152  18.218  1.00 64.33           C  
ATOM    595  NZ  LYS A  83      34.427  17.712  17.046  1.00 66.08           N  
ATOM    596  N   GLN A  84      32.191  22.471  22.479  1.00 57.45           N  
ATOM    597  CA  GLN A  84      31.852  23.311  23.618  1.00 56.49           C  
ATOM    598  C   GLN A  84      30.364  23.194  24.006  1.00 55.29           C  
ATOM    599  O   GLN A  84      29.506  23.097  23.131  1.00 52.42           O  
ATOM    600  CB  GLN A  84      32.167  24.753  23.249  1.00 56.71           C  
ATOM    601  CG  GLN A  84      33.646  24.956  23.004  1.00 59.90           C  
ATOM    602  CD  GLN A  84      34.392  25.008  24.309  1.00 63.07           C  
ATOM    603  OE1 GLN A  84      34.128  25.890  25.150  1.00 67.44           O  
ATOM    604  NE2 GLN A  84      35.293  24.069  24.512  1.00 61.19           N  
ATOM    605  N   PRO A  85      30.068  23.226  25.328  1.00 55.34           N  
ATOM    606  CA  PRO A  85      28.689  23.229  25.871  1.00 55.28           C  
ATOM    607  C   PRO A  85      27.837  24.358  25.295  1.00 54.46           C  
ATOM    608  O   PRO A  85      28.290  25.496  25.239  1.00 55.91           O  
ATOM    609  CB  PRO A  85      28.912  23.494  27.371  1.00 55.89           C  
ATOM    610  CG  PRO A  85      30.354  24.231  27.427  1.00 55.26           C  
ATOM    611  CD  PRO A  85      31.059  23.315  26.422  1.00 55.32           C  
ATOM    612  N   VAL A  86      26.617  24.072  24.865  1.00 53.82           N  
ATOM    613  CA  VAL A  86      25.711  25.167  24.484  1.00 52.50           C  
ATOM    614  C   VAL A  86      25.160  25.926  25.726  1.00 52.30           C  
ATOM    615  O   VAL A  86      25.026  27.168  25.711  1.00 52.60           O  
ATOM    616  CB  VAL A  86      24.532  24.672  23.581  1.00 52.63           C  
ATOM    617  CG1 VAL A  86      23.639  25.849  23.175  1.00 51.35           C  
ATOM    618  CG2 VAL A  86      25.053  23.983  22.334  1.00 50.28           C  
ATOM    619  N   PHE A  87      24.790  25.161  26.761  1.00 51.06           N  
ATOM    620  CA  PHE A  87      24.142  25.676  27.956  1.00 49.73           C  
ATOM    621  C   PHE A  87      25.003  25.313  29.123  1.00 50.77           C  
ATOM    622  O   PHE A  87      25.618  24.243  29.123  1.00 51.50           O  
ATOM    623  CB  PHE A  87      22.744  25.071  28.149  1.00 48.97           C  
ATOM    624  CG  PHE A  87      21.794  25.367  27.023  1.00 47.08           C  
ATOM    625  CD1 PHE A  87      21.314  26.671  26.819  1.00 47.03           C  
ATOM    626  CD2 PHE A  87      21.369  24.345  26.158  1.00 47.31           C  
ATOM    627  CE1 PHE A  87      20.443  26.978  25.757  1.00 45.80           C  
ATOM    628  CE2 PHE A  87      20.478  24.627  25.096  1.00 46.41           C  
ATOM    629  CZ  PHE A  87      20.010  25.955  24.898  1.00 45.67           C  
ATOM    630  N   SER A  88      25.116  26.213  30.102  1.00 50.46           N  
ATOM    631  CA  SER A  88      25.696  25.812  31.372  1.00 50.26           C  
ATOM    632  C   SER A  88      24.624  25.134  32.246  1.00 50.80           C  
ATOM    633  O   SER A  88      23.402  25.291  32.045  1.00 49.01           O  
ATOM    634  CB  SER A  88      26.296  27.016  32.124  1.00 50.21           C  
ATOM    635  OG  SER A  88      25.242  27.843  32.560  1.00 48.57           O  
ATOM    636  N   VAL A  89      25.116  24.384  33.229  1.00 52.50           N  
ATOM    637  CA  VAL A  89      24.313  23.885  34.358  1.00 54.12           C  
ATOM    638  C   VAL A  89      23.370  24.954  34.930  1.00 54.71           C  
ATOM    639  O   VAL A  89      22.225  24.659  35.267  1.00 55.42           O  
ATOM    640  CB  VAL A  89      25.242  23.232  35.456  1.00 54.48           C  
ATOM    641  CG1 VAL A  89      26.657  23.859  35.461  1.00 55.04           C  
ATOM    642  CG2 VAL A  89      24.610  23.266  36.843  1.00 55.45           C  
ATOM    643  N   ASP A  90      23.837  26.203  34.968  1.00 55.47           N  
ATOM    644  CA  ASP A  90      23.102  27.288  35.585  1.00 56.84           C  
ATOM    645  C   ASP A  90      21.837  27.744  34.851  1.00 57.60           C  
ATOM    646  O   ASP A  90      21.002  28.434  35.429  1.00 57.68           O  
ATOM    647  CB  ASP A  90      24.037  28.478  35.861  1.00 56.83           C  
ATOM    648  CG  ASP A  90      25.099  28.154  36.901  1.00 58.04           C  
ATOM    649  OD1 ASP A  90      24.844  27.319  37.805  1.00 59.03           O  
ATOM    650  OD2 ASP A  90      26.197  28.734  36.819  1.00 60.30           O  
ATOM    651  N   GLU A  91      21.694  27.389  33.580  1.00 58.89           N  
ATOM    652  CA  GLU A  91      20.481  27.784  32.858  1.00 60.30           C  
ATOM    653  C   GLU A  91      19.518  26.640  32.616  1.00 60.95           C  
ATOM    654  O   GLU A  91      18.800  26.623  31.623  1.00 61.38           O  
ATOM    655  CB  GLU A  91      20.790  28.593  31.579  1.00 60.59           C  
ATOM    656  CG  GLU A  91      21.778  27.988  30.580  1.00 61.50           C  
ATOM    657  CD  GLU A  91      22.634  29.074  29.886  1.00 59.70           C  
ATOM    658  OE1 GLU A  91      23.838  28.890  29.710  1.00 60.34           O  
ATOM    659  OE2 GLU A  91      22.105  30.120  29.516  1.00 59.32           O  
ATOM    660  N   GLU A  92      19.483  25.700  33.560  1.00 61.86           N  
ATOM    661  CA  GLU A  92      18.562  24.571  33.510  1.00 63.18           C  
ATOM    662  C   GLU A  92      17.129  25.057  33.403  1.00 62.11           C  
ATOM    663  O   GLU A  92      16.380  24.646  32.524  1.00 62.31           O  
ATOM    664  CB  GLU A  92      18.731  23.708  34.767  1.00 63.96           C  
ATOM    665  CG  GLU A  92      17.708  22.556  34.928  1.00 64.82           C  
ATOM    666  CD  GLU A  92      17.652  22.041  36.384  1.00 65.78           C  
ATOM    667  OE1 GLU A  92      18.451  21.132  36.728  1.00 67.86           O  
ATOM    668  OE2 GLU A  92      16.823  22.559  37.178  1.00 66.68           O  
ATOM    669  N   GLU A  93      16.781  25.947  34.313  1.00 60.93           N  
ATOM    670  CA  GLU A  93      15.456  26.529  34.439  1.00 60.37           C  
ATOM    671  C   GLU A  93      15.004  27.314  33.205  1.00 59.55           C  
ATOM    672  O   GLU A  93      13.836  27.238  32.825  1.00 60.50           O  
ATOM    673  CB  GLU A  93      15.444  27.413  35.696  1.00 60.39           C  
ATOM    674  CG  GLU A  93      16.849  27.984  36.001  1.00 60.35           C  
ATOM    675  CD  GLU A  93      17.702  27.162  36.988  1.00 60.78           C  
ATOM    676  OE1 GLU A  93      17.235  26.828  38.108  1.00 60.94           O  
ATOM    677  OE2 GLU A  93      18.880  26.902  36.658  1.00 60.33           O  
ATOM    678  N   GLN A  94      15.922  28.066  32.596  1.00 57.92           N  
ATOM    679  CA  GLN A  94      15.703  28.717  31.299  1.00 56.39           C  
ATOM    680  C   GLN A  94      15.373  27.686  30.213  1.00 54.87           C  
ATOM    681  O   GLN A  94      14.473  27.887  29.422  1.00 54.85           O  
ATOM    682  CB  GLN A  94      16.965  29.497  30.879  1.00 56.69           C  
ATOM    683  CG  GLN A  94      17.230  30.830  31.629  1.00 58.12           C  
ATOM    684  CD  GLN A  94      17.395  30.692  33.147  1.00 58.01           C  
ATOM    685  OE1 GLN A  94      18.212  29.908  33.633  1.00 58.50           O  
ATOM    686  NE2 GLN A  94      16.618  31.480  33.897  1.00 58.96           N  
ATOM    687  N   VAL A  95      16.121  26.588  30.176  1.00 54.00           N  
ATOM    688  CA  VAL A  95      15.920  25.527  29.166  1.00 53.24           C  
ATOM    689  C   VAL A  95      14.612  24.755  29.394  1.00 53.79           C  
ATOM    690  O   VAL A  95      13.922  24.418  28.453  1.00 52.10           O  
ATOM    691  CB  VAL A  95      17.163  24.552  29.069  1.00 53.15           C  
ATOM    692  CG1 VAL A  95      16.897  23.388  28.120  1.00 49.82           C  
ATOM    693  CG2 VAL A  95      18.422  25.311  28.661  1.00 50.03           C  
ATOM    694  N   ARG A  96      14.300  24.483  30.658  1.00 55.50           N  
ATOM    695  CA  ARG A  96      13.043  23.845  31.058  1.00 58.17           C  
ATOM    696  C   ARG A  96      11.761  24.468  30.458  1.00 58.45           C  
ATOM    697  O   ARG A  96      10.849  23.727  30.065  1.00 58.24           O  
ATOM    698  CB  ARG A  96      12.935  23.781  32.595  1.00 58.71           C  
ATOM    699  CG  ARG A  96      12.614  22.384  33.148  1.00 59.74           C  
ATOM    700  CD  ARG A  96      12.208  22.416  34.649  1.00 60.85           C  
ATOM    701  NE  ARG A  96      13.356  22.549  35.548  1.00 64.13           N  
ATOM    702  CZ  ARG A  96      13.428  23.382  36.583  1.00 64.66           C  
ATOM    703  NH1 ARG A  96      12.420  24.182  36.881  1.00 66.08           N  
ATOM    704  NH2 ARG A  96      14.523  23.408  37.330  1.00 64.63           N  
ATOM    705  N   GLU A  97      11.688  25.799  30.354  1.00 59.08           N  
ATOM    706  CA  GLU A  97      10.485  26.422  29.771  1.00 59.82           C  
ATOM    707  C   GLU A  97      10.299  26.307  28.246  1.00 59.73           C  
ATOM    708  O   GLU A  97       9.164  26.448  27.747  1.00 60.92           O  
ATOM    709  CB  GLU A  97      10.255  27.863  30.251  1.00 60.29           C  
ATOM    710  CG  GLU A  97      11.428  28.799  30.240  1.00 60.86           C  
ATOM    711  CD  GLU A  97      11.003  30.257  30.498  1.00 61.79           C  
ATOM    712  OE1 GLU A  97      10.113  30.768  29.766  1.00 63.72           O  
ATOM    713  OE2 GLU A  97      11.560  30.890  31.433  1.00 63.08           O  
ATOM    714  N   ILE A  98      11.374  26.017  27.518  1.00 58.36           N  
ATOM    715  CA  ILE A  98      11.288  25.852  26.074  1.00 57.25           C  
ATOM    716  C   ILE A  98      11.506  24.423  25.617  1.00 56.40           C  
ATOM    717  O   ILE A  98      11.365  24.133  24.437  1.00 57.05           O  
ATOM    718  CB  ILE A  98      12.270  26.824  25.256  1.00 57.56           C  
ATOM    719  CG1 ILE A  98      13.592  26.144  24.787  1.00 57.90           C  
ATOM    720  CG2 ILE A  98      12.369  28.236  25.879  1.00 58.09           C  
ATOM    721  CD1 ILE A  98      14.705  25.851  25.763  1.00 55.92           C  
ATOM    722  N   TYR A  99      11.877  23.533  26.533  1.00 55.21           N  
ATOM    723  CA  TYR A  99      12.149  22.152  26.192  1.00 54.15           C  
ATOM    724  C   TYR A  99      10.936  21.466  25.556  1.00 55.00           C  
ATOM    725  O   TYR A  99       9.834  21.410  26.132  1.00 55.39           O  
ATOM    726  CB  TYR A  99      12.617  21.398  27.436  1.00 53.28           C  
ATOM    727  CG  TYR A  99      13.174  19.998  27.239  1.00 53.81           C  
ATOM    728  CD1 TYR A  99      14.554  19.782  27.082  1.00 52.52           C  
ATOM    729  CD2 TYR A  99      12.337  18.876  27.303  1.00 53.87           C  
ATOM    730  CE1 TYR A  99      15.076  18.475  26.964  1.00 51.57           C  
ATOM    731  CE2 TYR A  99      12.843  17.576  27.191  1.00 51.33           C  
ATOM    732  CZ  TYR A  99      14.219  17.384  27.010  1.00 52.74           C  
ATOM    733  OH  TYR A  99      14.728  16.107  26.890  1.00 50.83           O  
ATOM    734  N   GLY A 100      11.150  20.931  24.362  1.00 55.37           N  
ATOM    735  CA  GLY A 100      10.095  20.242  23.651  1.00 55.74           C  
ATOM    736  C   GLY A 100      10.646  19.122  22.798  1.00 55.63           C  
ATOM    737  O   GLY A 100      11.725  18.588  23.090  1.00 56.25           O  
ATOM    738  N   PRO A 101       9.893  18.737  21.757  1.00 55.11           N  
ATOM    739  CA  PRO A 101      10.128  17.537  20.940  1.00 54.78           C  
ATOM    740  C   PRO A 101      11.547  17.377  20.350  1.00 54.25           C  
ATOM    741  O   PRO A 101      12.088  16.277  20.359  1.00 55.49           O  
ATOM    742  CB  PRO A 101       9.073  17.668  19.826  1.00 54.72           C  
ATOM    743  CG  PRO A 101       7.965  18.436  20.462  1.00 54.91           C  
ATOM    744  CD  PRO A 101       8.680  19.455  21.331  1.00 55.13           C  
ATOM    745  N   VAL A 102      12.122  18.442  19.816  1.00 52.95           N  
ATOM    746  CA  VAL A 102      13.469  18.396  19.252  1.00 52.18           C  
ATOM    747  C   VAL A 102      14.532  18.094  20.323  1.00 51.96           C  
ATOM    748  O   VAL A 102      15.336  17.175  20.161  1.00 52.11           O  
ATOM    749  CB  VAL A 102      13.808  19.690  18.428  1.00 51.59           C  
ATOM    750  CG1 VAL A 102      15.258  19.654  17.892  1.00 48.03           C  
ATOM    751  CG2 VAL A 102      12.811  19.856  17.298  1.00 50.07           C  
ATOM    752  N   HIS A 103      14.514  18.864  21.411  1.00 51.85           N  
ATOM    753  CA  HIS A 103      15.438  18.669  22.522  1.00 51.38           C  
ATOM    754  C   HIS A 103      15.371  17.237  23.037  1.00 51.29           C  
ATOM    755  O   HIS A 103      16.378  16.605  23.300  1.00 51.07           O  
ATOM    756  CB  HIS A 103      15.115  19.635  23.664  1.00 50.14           C  
ATOM    757  CG  HIS A 103      14.969  21.057  23.220  1.00 52.06           C  
ATOM    758  ND1 HIS A 103      13.874  21.501  22.513  1.00 51.89           N  
ATOM    759  CD2 HIS A 103      15.798  22.119  23.340  1.00 51.78           C  
ATOM    760  CE1 HIS A 103      14.015  22.781  22.245  1.00 52.23           C  
ATOM    761  NE2 HIS A 103      15.190  23.174  22.712  1.00 53.91           N  
ATOM    762  N   SER A 104      14.167  16.730  23.167  1.00 51.82           N  
ATOM    763  CA  SER A 104      13.980  15.425  23.750  1.00 51.84           C  
ATOM    764  C   SER A 104      14.423  14.313  22.796  1.00 50.93           C  
ATOM    765  O   SER A 104      14.919  13.302  23.234  1.00 49.26           O  
ATOM    766  CB  SER A 104      12.544  15.274  24.246  1.00 51.69           C  
ATOM    767  OG  SER A 104      11.721  14.677  23.251  1.00 53.14           O  
ATOM    768  N   ARG A 105      14.291  14.546  21.495  1.00 51.92           N  
ATOM    769  CA  ARG A 105      14.794  13.626  20.449  1.00 52.96           C  
ATOM    770  C   ARG A 105      16.330  13.692  20.357  1.00 51.85           C  
ATOM    771  O   ARG A 105      16.983  12.714  20.044  1.00 51.15           O  
ATOM    772  CB  ARG A 105      14.191  14.009  19.100  1.00 52.29           C  
ATOM    773  CG  ARG A 105      14.593  13.084  17.952  1.00 56.52           C  
ATOM    774  CD  ARG A 105      14.158  13.577  16.522  1.00 57.90           C  
ATOM    775  NE  ARG A 105      14.770  14.857  16.072  1.00 64.99           N  
ATOM    776  CZ  ARG A 105      16.044  14.991  15.685  1.00 68.08           C  
ATOM    777  NH1 ARG A 105      16.878  13.942  15.714  1.00 66.70           N  
ATOM    778  NH2 ARG A 105      16.493  16.182  15.266  1.00 69.30           N  
ATOM    779  N   LEU A 106      16.902  14.863  20.637  1.00 50.99           N  
ATOM    780  CA  LEU A 106      18.362  15.001  20.699  1.00 50.54           C  
ATOM    781  C   LEU A 106      18.921  14.333  21.963  1.00 50.52           C  
ATOM    782  O   LEU A 106      19.948  13.673  21.885  1.00 51.82           O  
ATOM    783  CB  LEU A 106      18.815  16.486  20.579  1.00 49.84           C  
ATOM    784  CG  LEU A 106      18.686  17.129  19.188  1.00 48.08           C  
ATOM    785  CD1 LEU A 106      18.986  18.605  19.245  1.00 45.57           C  
ATOM    786  CD2 LEU A 106      19.608  16.455  18.136  1.00 45.11           C  
ATOM    787  N   LEU A 107      18.243  14.468  23.103  1.00 49.17           N  
ATOM    788  CA  LEU A 107      18.616  13.709  24.276  1.00 48.72           C  
ATOM    789  C   LEU A 107      18.688  12.195  24.005  1.00 49.77           C  
ATOM    790  O   LEU A 107      19.695  11.561  24.364  1.00 48.65           O  
ATOM    791  CB  LEU A 107      17.707  14.002  25.463  1.00 48.10           C  
ATOM    792  CG  LEU A 107      17.929  13.271  26.810  1.00 48.43           C  
ATOM    793  CD1 LEU A 107      19.397  13.374  27.285  1.00 43.97           C  
ATOM    794  CD2 LEU A 107      17.016  13.876  27.896  1.00 48.21           C  
ATOM    795  N   LYS A 108      17.639  11.627  23.396  1.00 50.12           N  
ATOM    796  CA  LYS A 108      17.600  10.195  23.082  1.00 52.24           C  
ATOM    797  C   LYS A 108      18.748   9.740  22.204  1.00 52.82           C  
ATOM    798  O   LYS A 108      19.396   8.765  22.498  1.00 54.48           O  
ATOM    799  CB  LYS A 108      16.261   9.790  22.450  1.00 52.53           C  
ATOM    800  CG  LYS A 108      15.210   9.502  23.501  1.00 56.17           C  
ATOM    801  CD  LYS A 108      13.833   9.463  22.914  1.00 61.85           C  
ATOM    802  CE  LYS A 108      12.776   9.388  24.013  1.00 65.92           C  
ATOM    803  NZ  LYS A 108      12.549   7.988  24.496  1.00 67.83           N  
ATOM    804  N   GLN A 109      18.970  10.452  21.110  1.00 54.69           N  
ATOM    805  CA  GLN A 109      20.085  10.226  20.224  1.00 55.90           C  
ATOM    806  C   GLN A 109      21.392  10.212  21.041  1.00 55.46           C  
ATOM    807  O   GLN A 109      22.187   9.285  20.887  1.00 55.89           O  
ATOM    808  CB  GLN A 109      20.085  11.310  19.148  1.00 55.68           C  
ATOM    809  CG  GLN A 109      20.359  10.832  17.738  1.00 58.40           C  
ATOM    810  CD  GLN A 109      20.284  11.945  16.691  1.00 59.11           C  
ATOM    811  OE1 GLN A 109      20.909  11.855  15.624  1.00 65.70           O  
ATOM    812  NE2 GLN A 109      19.517  12.986  16.979  1.00 64.01           N  
ATOM    813  N   ALA A 110      21.589  11.188  21.947  1.00 54.94           N  
ATOM    814  CA  ALA A 110      22.801  11.207  22.807  1.00 54.73           C  
ATOM    815  C   ALA A 110      22.946   9.973  23.728  1.00 54.67           C  
ATOM    816  O   ALA A 110      24.045   9.409  23.859  1.00 53.75           O  
ATOM    817  CB  ALA A 110      22.892  12.488  23.628  1.00 54.13           C  
ATOM    818  N   LEU A 111      21.840   9.572  24.357  1.00 54.70           N  
ATOM    819  CA  LEU A 111      21.799   8.383  25.212  1.00 55.51           C  
ATOM    820  C   LEU A 111      22.011   7.086  24.416  1.00 55.36           C  
ATOM    821  O   LEU A 111      22.476   6.143  24.981  1.00 55.58           O  
ATOM    822  CB  LEU A 111      20.508   8.309  26.085  1.00 55.11           C  
ATOM    823  CG  LEU A 111      20.226   9.535  26.985  1.00 55.41           C  
ATOM    824  CD1 LEU A 111      18.953   9.384  27.814  1.00 54.05           C  
ATOM    825  CD2 LEU A 111      21.419   9.853  27.847  1.00 52.18           C  
ATOM    826  N   ASP A 112      21.696   7.072  23.120  1.00 56.16           N  
ATOM    827  CA  ASP A 112      22.053   5.962  22.206  1.00 58.01           C  
ATOM    828  C   ASP A 112      23.550   5.618  22.144  1.00 57.95           C  
ATOM    829  O   ASP A 112      23.912   4.527  21.744  1.00 57.79           O  
ATOM    830  CB  ASP A 112      21.605   6.259  20.762  1.00 58.62           C  
ATOM    831  CG  ASP A 112      20.145   5.902  20.486  1.00 62.71           C  
ATOM    832  OD1 ASP A 112      19.529   5.118  21.261  1.00 65.68           O  
ATOM    833  OD2 ASP A 112      19.614   6.417  19.465  1.00 65.66           O  
ATOM    834  N   LEU A 113      24.413   6.567  22.495  1.00 58.37           N  
ATOM    835  CA  LEU A 113      25.858   6.367  22.380  1.00 58.71           C  
ATOM    836  C   LEU A 113      26.377   5.411  23.436  1.00 59.86           C  
ATOM    837  O   LEU A 113      27.360   4.721  23.202  1.00 60.37           O  
ATOM    838  CB  LEU A 113      26.616   7.691  22.468  1.00 57.51           C  
ATOM    839  CG  LEU A 113      26.411   8.713  21.355  1.00 55.89           C  
ATOM    840  CD1 LEU A 113      26.833  10.055  21.846  1.00 53.02           C  
ATOM    841  CD2 LEU A 113      27.187   8.330  20.134  1.00 59.13           C  
ATOM    842  N   ILE A 114      25.725   5.393  24.594  1.00 61.47           N  
ATOM    843  CA  ILE A 114      26.081   4.492  25.681  1.00 63.80           C  
ATOM    844  C   ILE A 114      25.624   3.075  25.351  1.00 65.34           C  
ATOM    845  O   ILE A 114      26.268   2.107  25.772  1.00 66.12           O  
ATOM    846  CB  ILE A 114      25.406   4.901  26.989  1.00 64.10           C  
ATOM    847  CG1 ILE A 114      25.771   6.328  27.356  1.00 63.46           C  
ATOM    848  CG2 ILE A 114      25.763   3.952  28.127  1.00 64.72           C  
ATOM    849  CD1 ILE A 114      24.652   6.992  28.073  1.00 66.14           C  
ATOM    850  N   ASN A 115      24.532   2.952  24.589  1.00 66.97           N  
ATOM    851  CA  ASN A 115      23.995   1.625  24.225  1.00 68.88           C  
ATOM    852  C   ASN A 115      24.912   0.762  23.326  1.00 69.14           C  
ATOM    853  O   ASN A 115      26.018   1.175  22.952  1.00 69.11           O  
ATOM    854  CB  ASN A 115      22.542   1.709  23.689  1.00 69.42           C  
ATOM    855  CG  ASN A 115      22.456   1.717  22.156  1.00 70.92           C  
ATOM    856  OD1 ASN A 115      23.145   0.952  21.478  1.00 72.95           O  
ATOM    857  ND2 ASN A 115      21.569   2.563  21.611  1.00 72.22           N  
TER     858      ASN A 115                                                      
END
MOLECULE T0465.pdb
ATOM      1  N   GLU     7      39.181 -18.735  26.768  1.00 35.74           N  
ATOM      2  CA  GLU     7      38.293 -18.388  27.927  1.00 35.74           C  
ATOM      3  CB  GLU     7      36.984 -19.212  27.923  1.00 35.95           C  
ATOM      4  CG  GLU     7      36.957 -20.406  28.946  1.00 37.55           C  
ATOM      5  CD  GLU     7      35.986 -21.556  28.570  1.00 37.74           C  
ATOM      6  OE1 GLU     7      35.161 -21.412  27.614  1.00 39.56           O  
ATOM      7  OE2 GLU     7      36.068 -22.622  29.249  1.00 41.55           O  
ATOM      8  C   GLU     7      39.006 -18.539  29.273  1.00 34.40           C  
ATOM      9  O   GLU     7      39.106 -17.566  30.008  1.00 34.63           O  
ATOM     10  N   LYS     8      39.512 -19.734  29.596  1.00 33.05           N  
ATOM     11  CA  LYS     8      40.036 -19.984  30.948  1.00 31.69           C  
ATOM     12  CB  LYS     8      40.792 -21.302  31.047  1.00 31.72           C  
ATOM     13  CG  LYS     8      39.830 -22.450  31.184  1.00 31.94           C  
ATOM     14  CD  LYS     8      39.426 -22.651  32.677  1.00 31.74           C  
ATOM     15  CE  LYS     8      38.629 -23.960  32.730  1.00 31.25           C  
ATOM     16  NZ  LYS     8      39.312 -24.858  33.695  1.00 31.01           N  
ATOM     17  C   LYS     8      40.795 -18.843  31.627  1.00 30.68           C  
ATOM     18  O   LYS     8      40.556 -18.598  32.818  1.00 31.53           O  
ATOM     19  N   VAL     9      41.667 -18.128  30.892  1.00 28.15           N  
ATOM     20  CA  VAL     9      42.164 -16.793  31.343  1.00 25.60           C  
ATOM     21  CB  VAL     9      43.695 -16.795  31.785  1.00 26.03           C  
ATOM     22  CG1 VAL     9      44.649 -17.284  30.653  1.00 27.43           C  
ATOM     23  CG2 VAL     9      44.111 -15.433  32.402  1.00 27.28           C  
ATOM     24  C   VAL     9      41.772 -15.657  30.366  1.00 22.74           C  
ATOM     25  O   VAL     9      42.379 -15.475  29.305  1.00 23.05           O  
ATOM     26  N   TYR    10      40.728 -14.922  30.746  1.00 18.97           N  
ATOM     27  CA  TYR    10      40.061 -13.910  29.908  1.00 14.92           C  
ATOM     28  CB  TYR    10      38.718 -13.553  30.541  1.00 15.61           C  
ATOM     29  CG  TYR    10      37.710 -14.662  30.537  1.00 15.84           C  
ATOM     30  CD1 TYR    10      36.904 -14.872  29.420  1.00 16.74           C  
ATOM     31  CE1 TYR    10      35.980 -15.883  29.403  1.00 17.07           C  
ATOM     32  CZ  TYR    10      35.823 -16.698  30.508  1.00 15.22           C  
ATOM     33  OH  TYR    10      34.875 -17.702  30.455  1.00 14.31           O  
ATOM     34  CE2 TYR    10      36.603 -16.499  31.650  1.00 15.67           C  
ATOM     35  CD2 TYR    10      37.536 -15.478  31.658  1.00 14.34           C  
ATOM     36  C   TYR    10      40.838 -12.604  29.797  1.00 11.90           C  
ATOM     37  O   TYR    10      41.562 -12.260  30.714  1.00 11.56           O  
ATOM     38  N   ASP    11      40.637 -11.852  28.713  1.00  7.48           N  
ATOM     39  CA  ASP    11      41.538 -10.760  28.381  1.00  4.06           C  
ATOM     40  CB  ASP    11      42.265 -11.010  27.035  1.00  3.92           C  
ATOM     41  CG  ASP    11      42.927  -9.738  26.431  1.00  4.77           C  
ATOM     42  OD1 ASP    11      42.837  -8.625  26.983  1.00  2.00           O  
ATOM     43  OD2 ASP    11      43.540  -9.866  25.350  1.00  4.72           O  
ATOM     44  C   ASP    11      40.800  -9.440  28.463  1.00  2.15           C  
ATOM     45  O   ASP    11      39.897  -9.141  27.731  1.00  2.00           O  
ATOM     46  N   LEU    12      41.190  -8.654  29.417  1.00  2.00           N  
ATOM     47  CA  LEU    12      40.387  -7.534  29.686  1.00  2.00           C  
ATOM     48  CB  LEU    12      40.126  -7.459  31.181  1.00  2.00           C  
ATOM     49  CG  LEU    12      39.614  -8.713  31.920  1.00  2.00           C  
ATOM     50  CD1 LEU    12      40.109  -8.741  33.367  1.00  2.00           C  
ATOM     51  CD2 LEU    12      38.076  -8.903  31.838  1.00  2.00           C  
ATOM     52  C   LEU    12      41.003  -6.263  29.202  1.00  2.00           C  
ATOM     53  O   LEU    12      40.435  -5.242  29.411  1.00  2.00           O  
ATOM     54  N   SER    13      42.124  -6.292  28.510  1.00  2.00           N  
ATOM     55  CA  SER    13      42.616  -5.082  27.843  1.00  2.00           C  
ATOM     56  CB  SER    13      43.754  -5.333  26.841  1.00  2.00           C  
ATOM     57  OG  SER    13      43.879  -6.689  26.373  1.00  2.00           O  
ATOM     58  C   SER    13      41.529  -4.341  27.149  1.00  2.00           C  
ATOM     59  O   SER    13      41.547  -3.158  27.191  1.00  2.00           O  
ATOM     60  N   PHE    14      40.565  -5.032  26.552  1.00  2.00           N  
ATOM     61  CA  PHE    14      39.562  -4.417  25.681  1.00  2.00           C  
ATOM     62  CB  PHE    14      38.816  -5.425  24.859  1.00  2.00           C  
ATOM     63  CG  PHE    14      39.686  -6.428  24.165  1.00  2.00           C  
ATOM     64  CD1 PHE    14      40.719  -6.030  23.344  1.00  2.00           C  
ATOM     65  CE1 PHE    14      41.480  -6.974  22.723  1.00  2.00           C  
ATOM     66  CZ  PHE    14      41.179  -8.301  22.859  1.00  2.00           C  
ATOM     67  CE2 PHE    14      40.133  -8.694  23.636  1.00  2.00           C  
ATOM     68  CD2 PHE    14      39.413  -7.773  24.296  1.00  2.00           C  
ATOM     69  C   PHE    14      38.502  -3.609  26.382  1.00  2.00           C  
ATOM     70  O   PHE    14      37.622  -2.934  25.731  1.00  2.00           O  
ATOM     71  N   PHE    15      38.504  -3.701  27.703  1.00  2.20           N  
ATOM     72  CA  PHE    15      37.459  -3.028  28.506  1.00  5.00           C  
ATOM     73  CB  PHE    15      36.753  -4.068  29.406  1.00  3.46           C  
ATOM     74  CG  PHE    15      35.994  -5.147  28.630  1.00  2.00           C  
ATOM     75  CD1 PHE    15      34.777  -4.865  28.012  1.00  2.00           C  
ATOM     76  CE1 PHE    15      34.106  -5.880  27.298  1.00  2.00           C  
ATOM     77  CZ  PHE    15      34.649  -7.109  27.203  1.00  2.00           C  
ATOM     78  CE2 PHE    15      35.815  -7.364  27.781  1.00  2.00           C  
ATOM     79  CD2 PHE    15      36.489  -6.407  28.485  1.00  2.00           C  
ATOM     80  C   PHE    15      38.109  -1.927  29.293  1.00  8.24           C  
ATOM     81  O   PHE    15      37.448  -1.241  30.029  1.00  9.45           O  
ATOM     82  N   MET    16      39.421  -1.736  29.119  1.00 13.00           N  
ATOM     83  CA  MET    16      40.097  -0.549  29.669  1.00 18.94           C  
ATOM     84  CB  MET    16      41.381  -1.004  30.281  1.00 16.16           C  
ATOM     85  CG  MET    16      41.078  -1.510  31.594  1.00 16.44           C  
ATOM     86  SD  MET    16      42.327  -2.822  31.983  1.00 30.70          SE  
ATOM     87  CE  MET    16      43.973  -1.683  32.072  1.00 33.27           C  
ATOM     88  C   MET    16      40.241   0.642  28.694  1.00 18.98           C  
ATOM     89  O   MET    16      39.950   0.483  27.539  1.00 18.36           O  
ATOM     90  N   PRO    17      40.667   1.849  29.150  1.00 22.20           N  
ATOM     91  CA  PRO    17      40.533   3.050  28.205  1.00 23.49           C  
ATOM     92  CB  PRO    17      40.550   4.281  29.145  1.00 23.77           C  
ATOM     93  CG  PRO    17      40.856   3.672  30.629  1.00 24.25           C  
ATOM     94  CD  PRO    17      41.321   2.214  30.430  1.00 22.54           C  
ATOM     95  C   PRO    17      41.665   3.079  27.116  1.00 25.81           C  
ATOM     96  O   PRO    17      42.853   3.257  27.433  1.00 26.39           O  
ATOM     97  N   GLY    18      41.284   2.853  25.850  1.00 27.16           N  
ATOM     98  CA  GLY    18      42.128   2.118  24.852  1.00 26.72           C  
ATOM     99  C   GLY    18      41.203   1.008  24.346  1.00 27.34           C  
ATOM    100  O   GLY    18      41.438  -0.166  24.587  1.00 26.98           O  
ATOM    101  N   GLN    19      40.192   1.451  23.592  1.00 28.31           N  
ATOM    102  CA  GLN    19      38.850   0.916  23.420  1.00 29.72           C  
ATOM    103  CB  GLN    19      38.311   0.547  24.747  1.00 29.30           C  
ATOM    104  CG  GLN    19      37.996   1.806  25.460  1.00 30.00           C  
ATOM    105  CD  GLN    19      36.705   1.742  26.088  1.00 31.41           C  
ATOM    106  OE1 GLN    19      36.383   0.754  26.723  1.00 34.42           O  
ATOM    107  NE2 GLN    19      35.926   2.807  25.965  1.00 36.02           N  
ATOM    108  C   GLN    19      37.928   2.107  22.981  1.00 31.46           C  
ATOM    109  O   GLN    19      38.005   3.201  23.558  1.00 30.65           O  
ATOM    110  N   THR    20      37.013   1.873  22.033  1.00 33.63           N  
ATOM    111  CA  THR    20      36.372   2.942  21.259  1.00 35.03           C  
ATOM    112  CB  THR    20      35.409   2.408  20.173  1.00 34.00           C  
ATOM    113  OG1 THR    20      36.116   1.612  19.222  1.00 30.50           O  
ATOM    114  CG2 THR    20      34.792   3.540  19.441  1.00 33.25           C  
ATOM    115  C   THR    20      35.642   3.890  22.181  1.00 38.23           C  
ATOM    116  O   THR    20      34.451   4.055  22.073  1.00 38.53           O  
ATOM    117  N   ILE    21      36.355   4.473  23.132  1.00 42.14           N  
ATOM    118  CA  ILE    21      35.726   5.447  24.020  1.00 46.02           C  
ATOM    119  CB  ILE    21      36.580   5.899  25.407  1.00 46.89           C  
ATOM    120  CG1 ILE    21      35.653   6.218  26.632  1.00 46.90           C  
ATOM    121  CD1 ILE    21      34.225   6.965  26.324  1.00 48.39           C  
ATOM    122  CG2 ILE    21      37.783   6.919  25.177  1.00 48.24           C  
ATOM    123  C   ILE    21      35.285   6.473  23.013  1.00 47.40           C  
ATOM    124  O   ILE    21      36.018   7.352  22.560  1.00 47.65           O  
ATOM    125  N   ASP    22      34.059   6.214  22.598  1.00 49.79           N  
ATOM    126  CA  ASP    22      33.397   6.930  21.556  1.00 51.42           C  
ATOM    127  CB  ASP    22      32.361   6.034  20.824  1.00 52.13           C  
ATOM    128  CG  ASP    22      32.055   6.505  19.368  1.00 54.54           C  
ATOM    129  OD1 ASP    22      31.388   7.588  19.250  1.00 56.75           O  
ATOM    130  OD2 ASP    22      32.433   5.782  18.370  1.00 51.30           O  
ATOM    131  C   ASP    22      32.746   8.052  22.320  1.00 52.10           C  
ATOM    132  O   ASP    22      31.615   7.945  22.835  1.00 52.12           O  
ATOM    133  N   ALA    23      33.545   9.109  22.458  1.00 52.47           N  
ATOM    134  CA  ALA    23      33.010  10.440  22.371  1.00 51.86           C  
ATOM    135  CB  ALA    23      34.132  11.493  22.011  1.00 52.38           C  
ATOM    136  C   ALA    23      32.034  10.275  21.226  1.00 51.09           C  
ATOM    137  O   ALA    23      32.423   9.928  20.099  1.00 50.98           O  
ATOM    138  N   GLU    24      30.756  10.449  21.538  1.00 50.03           N  
ATOM    139  CA  GLU    24      29.774  10.722  20.494  1.00 47.56           C  
ATOM    140  CB  GLU    24      28.384  10.986  21.115  1.00 47.16           C  
ATOM    141  CG  GLU    24      27.880   9.859  22.054  1.00 48.48           C  
ATOM    142  CD  GLU    24      27.516   8.534  21.286  1.00 56.04           C  
ATOM    143  OE1 GLU    24      26.455   8.513  20.587  1.00 56.34           O  
ATOM    144  OE2 GLU    24      28.289   7.510  21.362  1.00 57.71           O  
ATOM    145  C   GLU    24      30.327  11.853  19.585  1.00 45.64           C  
ATOM    146  O   GLU    24      30.845  11.570  18.546  1.00 46.00           O  
ATOM    147  N   GLU    25      30.344  13.110  20.025  1.00 44.59           N  
ATOM    148  CA  GLU    25      30.313  14.269  19.108  1.00 40.46           C  
ATOM    149  CB  GLU    25      31.702  14.685  18.742  1.00 41.26           C  
ATOM    150  CG  GLU    25      31.765  16.136  18.358  1.00 42.09           C  
ATOM    151  CD  GLU    25      32.346  16.971  19.481  1.00 43.84           C  
ATOM    152  OE1 GLU    25      32.775  18.119  19.196  1.00 43.62           O  
ATOM    153  OE2 GLU    25      32.429  16.455  20.631  1.00 43.14           O  
ATOM    154  C   GLU    25      29.505  13.895  17.860  1.00 37.47           C  
ATOM    155  O   GLU    25      30.030  13.317  16.939  1.00 36.40           O  
ATOM    156  N   VAL    26      28.212  14.160  17.886  1.00 33.76           N  
ATOM    157  CA  VAL    26      27.338  13.829  16.795  1.00 30.97           C  
ATOM    158  CB  VAL    26      26.341  12.723  17.212  1.00 30.09           C  
ATOM    159  CG1 VAL    26      25.156  12.687  16.310  1.00 30.98           C  
ATOM    160  CG2 VAL    26      26.990  11.392  17.219  1.00 31.70           C  
ATOM    161  C   VAL    26      26.628  15.136  16.402  1.00 29.39           C  
ATOM    162  O   VAL    26      26.017  15.768  17.237  1.00 29.58           O  
ATOM    163  N   GLU    27      26.742  15.567  15.144  1.00 28.50           N  
ATOM    164  CA  GLU    27      26.029  16.755  14.611  1.00 27.08           C  
ATOM    165  CB  GLU    27      26.785  17.303  13.462  1.00 28.15           C  
ATOM    166  CG  GLU    27      28.027  18.091  13.769  1.00 35.26           C  
ATOM    167  CD  GLU    27      28.381  18.981  12.525  1.00 47.82           C  
ATOM    168  OE1 GLU    27      28.926  20.126  12.709  1.00 51.23           O  
ATOM    169  OE2 GLU    27      28.057  18.543  11.355  1.00 50.12           O  
ATOM    170  C   GLU    27      24.682  16.397  14.047  1.00 24.93           C  
ATOM    171  O   GLU    27      24.551  15.450  13.295  1.00 23.11           O  
ATOM    172  N   VAL    28      23.685  17.172  14.414  1.00 23.19           N  
ATOM    173  CA  VAL    28      22.295  16.903  14.082  1.00 23.34           C  
ATOM    174  CB  VAL    28      21.467  16.262  15.271  1.00 23.67           C  
ATOM    175  CG1 VAL    28      20.054  15.818  14.790  1.00 22.72           C  
ATOM    176  CG2 VAL    28      22.201  15.108  15.980  1.00 23.34           C  
ATOM    177  C   VAL    28      21.631  18.247  13.934  1.00 22.82           C  
ATOM    178  O   VAL    28      21.636  19.032  14.921  1.00 22.97           O  
ATOM    179  N   PRO    29      20.977  18.484  12.785  1.00 21.91           N  
ATOM    180  CA  PRO    29      20.230  19.741  12.554  1.00 22.28           C  
ATOM    181  CB  PRO    29      20.113  19.824  11.060  1.00 20.75           C  
ATOM    182  CG  PRO    29      20.166  18.348  10.613  1.00 22.38           C  
ATOM    183  CD  PRO    29      20.866  17.548  11.662  1.00 22.24           C  
ATOM    184  C   PRO    29      18.848  19.747  13.206  1.00 22.63           C  
ATOM    185  O   PRO    29      17.863  19.288  12.632  1.00 23.83           O  
ATOM    186  N   ILE    30      18.779  20.327  14.386  1.00 22.66           N  
ATOM    187  CA  ILE    30      17.586  20.238  15.212  1.00 22.68           C  
ATOM    188  CB  ILE    30      17.945  20.495  16.673  1.00 21.69           C  
ATOM    189  CG1 ILE    30      18.722  19.301  17.263  1.00 23.56           C  
ATOM    190  CD1 ILE    30      17.941  17.994  17.342  1.00 17.06           C  
ATOM    191  CG2 ILE    30      16.731  20.965  17.463  1.00 23.03           C  
ATOM    192  C   ILE    30      16.532  21.227  14.724  1.00 22.72           C  
ATOM    193  O   ILE    30      15.375  20.884  14.710  1.00 21.85           O  
ATOM    194  N   SER    31      16.966  22.434  14.334  1.00 21.86           N  
ATOM    195  CA  SER    31      16.103  23.452  13.691  1.00 21.54           C  
ATOM    196  CB  SER    31      15.760  24.540  14.738  1.00 21.33           C  
ATOM    197  OG  SER    31      15.406  25.727  14.071  1.00 19.90           O  
ATOM    198  C   SER    31      16.777  24.115  12.442  1.00 20.42           C  
ATOM    199  O   SER    31      17.955  24.563  12.491  1.00 20.06           O  
ATOM    200  N   LYS    32      16.036  24.195  11.350  1.00 18.41           N  
ATOM    201  CA  LYS    32      16.443  25.017  10.170  1.00 18.79           C  
ATOM    202  CB  LYS    32      15.567  24.738   8.931  1.00 17.19           C  
ATOM    203  CG  LYS    32      15.526  23.289   8.432  1.00 19.09           C  
ATOM    204  CD  LYS    32      14.440  23.131   7.330  1.00 19.68           C  
ATOM    205  CE  LYS    32      13.656  21.760   7.361  1.00 24.64           C  
ATOM    206  NZ  LYS    32      12.941  21.381   6.012  1.00 24.01           N  
ATOM    207  C   LYS    32      16.481  26.558  10.440  1.00 18.43           C  
ATOM    208  O   LYS    32      16.786  27.310   9.540  1.00 19.11           O  
ATOM    209  N   ARG    33      16.168  26.996  11.668  1.00 18.15           N  
ATOM    210  CA  ARG    33      16.051  28.410  12.014  1.00 18.44           C  
ATOM    211  CB  ARG    33      15.032  28.650  13.136  1.00 16.04           C  
ATOM    212  CG  ARG    33      13.570  28.311  12.826  1.00 19.41           C  
ATOM    213  CD  ARG    33      12.768  28.212  14.131  1.00 23.06           C  
ATOM    214  NE  ARG    33      13.378  29.140  15.055  1.00 26.92           N  
ATOM    215  CZ  ARG    33      13.494  29.018  16.359  1.00 31.11           C  
ATOM    216  NH1 ARG    33      13.079  27.965  17.045  1.00 31.62           N  
ATOM    217  NH2 ARG    33      14.132  29.976  16.974  1.00 36.23           N  
ATOM    218  C   ARG    33      17.413  28.898  12.481  1.00 18.70           C  
ATOM    219  O   ARG    33      17.624  30.092  12.611  1.00 18.79           O  
ATOM    220  N   PHE    34      18.343  27.991  12.739  1.00 17.86           N  
ATOM    221  CA  PHE    34      19.658  28.471  13.113  1.00 18.49           C  
ATOM    222  CB  PHE    34      20.200  27.723  14.334  1.00 18.10           C  
ATOM    223  CG  PHE    34      19.237  27.686  15.474  1.00 21.15           C  
ATOM    224  CD1 PHE    34      18.803  28.861  16.073  1.00 19.98           C  
ATOM    225  CE1 PHE    34      17.904  28.804  17.136  1.00 22.04           C  
ATOM    226  CZ  PHE    34      17.428  27.577  17.573  1.00 20.31           C  
ATOM    227  CE2 PHE    34      17.845  26.409  16.960  1.00 22.90           C  
ATOM    228  CD2 PHE    34      18.732  26.476  15.927  1.00 21.98           C  
ATOM    229  C   PHE    34      20.615  28.412  11.942  1.00 17.40           C  
ATOM    230  O   PHE    34      20.977  27.329  11.509  1.00 18.58           O  
ATOM    231  N   VAL    35      21.032  29.564  11.427  1.00 17.81           N  
ATOM    232  CA  VAL    35      21.938  29.578  10.277  1.00 18.90           C  
ATOM    233  CB  VAL    35      21.234  29.899   8.907  1.00 19.48           C  
ATOM    234  CG1 VAL    35      20.233  28.788   8.541  1.00 19.67           C  
ATOM    235  CG2 VAL    35      20.532  31.242   8.903  1.00 15.46           C  
ATOM    236  C   VAL    35      23.095  30.492  10.560  1.00 21.01           C  
ATOM    237  O   VAL    35      22.996  31.400  11.394  1.00 21.13           O  
ATOM    238  N   ASP    36      24.217  30.193   9.921  1.00 22.30           N  
ATOM    239  CA  ASP    36      25.357  31.027  10.004  1.00 24.87           C  
ATOM    240  CB  ASP    36      26.662  30.191   9.847  1.00 25.48           C  
ATOM    241  CG  ASP    36      26.851  29.549   8.442  1.00 26.45           C  
ATOM    242  OD1 ASP    36      26.271  29.988   7.422  1.00 29.01           O  
ATOM    243  OD2 ASP    36      27.645  28.600   8.331  1.00 25.54           O  
ATOM    244  C   ASP    36      25.253  32.210   9.006  1.00 26.21           C  
ATOM    245  O   ASP    36      24.199  32.476   8.436  1.00 26.70           O  
ATOM    246  N   LYS    37      26.332  32.952   8.829  1.00 27.60           N  
ATOM    247  CA  LYS    37      26.327  34.114   7.908  1.00 29.41           C  
ATOM    248  CB  LYS    37      27.422  35.136   8.338  1.00 30.68           C  
ATOM    249  CG  LYS    37      28.869  34.509   8.547  1.00 32.91           C  
ATOM    250  CD  LYS    37      29.741  34.640   7.224  1.00 33.76           C  
ATOM    251  CE  LYS    37      31.120  33.853   7.227  1.00 33.44           C  
ATOM    252  NZ  LYS    37      31.141  32.320   7.448  1.00 29.89           N  
ATOM    253  C   LYS    37      26.414  33.733   6.374  1.00 29.68           C  
ATOM    254  O   LYS    37      26.113  34.576   5.510  1.00 30.90           O  
ATOM    255  N   GLU    38      26.836  32.492   6.050  1.00 28.71           N  
ATOM    256  CA  GLU    38      26.718  31.906   4.707  1.00 27.77           C  
ATOM    257  CB  GLU    38      27.766  30.842   4.538  1.00 28.57           C  
ATOM    258  CG  GLU    38      29.183  31.337   4.609  1.00 32.19           C  
ATOM    259  CD  GLU    38      30.130  30.532   3.733  1.00 34.30           C  
ATOM    260  OE1 GLU    38      30.173  29.257   3.825  1.00 32.45           O  
ATOM    261  OE2 GLU    38      30.833  31.223   2.948  1.00 37.07           O  
ATOM    262  C   GLU    38      25.375  31.233   4.377  1.00 25.79           C  
ATOM    263  O   GLU    38      25.250  30.616   3.307  1.00 25.99           O  
ATOM    264  N   GLY    39      24.424  31.286   5.312  1.00 23.87           N  
ATOM    265  CA  GLY    39      23.039  30.877   5.112  1.00 21.45           C  
ATOM    266  C   GLY    39      22.677  29.433   5.387  1.00 20.65           C  
ATOM    267  O   GLY    39      21.528  29.059   5.149  1.00 21.85           O  
ATOM    268  N   ASN    40      23.638  28.634   5.877  1.00 18.13           N  
ATOM    269  CA  ASN    40      23.470  27.204   6.160  1.00 16.01           C  
ATOM    270  CB  ASN    40      24.734  26.441   5.871  1.00 14.98           C  
ATOM    271  CG  ASN    40      25.188  26.589   4.463  1.00 16.86           C  
ATOM    272  OD1 ASN    40      26.375  26.843   4.247  1.00 19.11           O  
ATOM    273  ND2 ASN    40      24.269  26.412   3.465  1.00 14.60           N  
ATOM    274  C   ASN    40      23.162  26.876   7.579  1.00 14.92           C  
ATOM    275  O   ASN    40      23.571  27.593   8.483  1.00 13.89           O  
ATOM    276  N   VAL    41      22.499  25.733   7.746  1.00 14.61           N  
ATOM    277  CA  VAL    41      21.974  25.293   9.050  1.00 15.50           C  
ATOM    278  CB  VAL    41      21.113  24.010   8.965  1.00 14.66           C  
ATOM    279  CG1 VAL    41      20.631  23.607  10.297  1.00 15.90           C  
ATOM    280  CG2 VAL    41      19.921  24.226   8.127  1.00 14.73           C  
ATOM    281  C   VAL    41      23.178  25.046   9.946  1.00 14.95           C  
ATOM    282  O   VAL    41      24.240  24.666   9.486  1.00 15.40           O  
ATOM    283  N   VAL    42      22.986  25.332  11.224  1.00 16.20           N  
ATOM    284  CA  VAL    42      24.032  25.216  12.215  1.00 16.32           C  
ATOM    285  CB  VAL    42      24.089  26.484  13.130  1.00 16.13           C  
ATOM    286  CG1 VAL    42      24.907  26.185  14.282  1.00 12.82           C  
ATOM    287  CG2 VAL    42      24.721  27.694  12.380  1.00 16.83           C  
ATOM    288  C   VAL    42      23.628  23.975  12.989  1.00 16.49           C  
ATOM    289  O   VAL    42      22.633  24.054  13.698  1.00 18.46           O  
ATOM    290  N   PRO    43      24.290  22.815  12.773  1.00 15.85           N  
ATOM    291  CA  PRO    43      23.793  21.708  13.578  1.00 16.52           C  
ATOM    292  CB  PRO    43      24.360  20.469  12.872  1.00 15.23           C  
ATOM    293  CG  PRO    43      25.483  20.945  12.023  1.00 15.28           C  
ATOM    294  CD  PRO    43      25.366  22.398  11.838  1.00 16.43           C  
ATOM    295  C   PRO    43      24.175  21.763  15.093  1.00 15.94           C  
ATOM    296  O   PRO    43      25.091  22.431  15.448  1.00 16.11           O  
ATOM    297  N   PHE    44      23.384  21.116  15.944  1.00 16.71           N  
ATOM    298  CA  PHE    44      23.702  20.855  17.311  1.00 16.38           C  
ATOM    299  CB  PHE    44      22.427  20.390  17.938  1.00 16.80           C  
ATOM    300  CG  PHE    44      21.552  21.510  18.406  1.00 14.20           C  
ATOM    301  CD1 PHE    44      21.293  22.595  17.602  1.00 16.26           C  
ATOM    302  CE1 PHE    44      20.475  23.624  18.074  1.00 18.61           C  
ATOM    303  CZ  PHE    44      19.956  23.593  19.343  1.00 17.71           C  
ATOM    304  CE2 PHE    44      20.255  22.535  20.162  1.00 18.00           C  
ATOM    305  CD2 PHE    44      21.053  21.500  19.662  1.00 14.14           C  
ATOM    306  C   PHE    44      24.705  19.722  17.330  1.00 17.91           C  
ATOM    307  O   PHE    44      24.671  18.857  16.509  1.00 17.55           O  
ATOM    308  N   ILE    45      25.619  19.780  18.273  1.00 18.92           N  
ATOM    309  CA  ILE    45      26.551  18.742  18.576  1.00 20.12           C  
ATOM    310  CB  ILE    45      27.952  19.337  18.578  1.00 19.78           C  
ATOM    311  CG1 ILE    45      28.196  19.976  17.227  1.00 19.58           C  
ATOM    312  CD1 ILE    45      29.511  20.804  17.084  1.00 21.12           C  
ATOM    313  CG2 ILE    45      28.954  18.309  18.888  1.00 20.15           C  
ATOM    314  C   ILE    45      26.182  18.128  19.956  1.00 21.88           C  
ATOM    315  O   ILE    45      26.085  18.830  21.017  1.00 20.95           O  
ATOM    316  N   PHE    46      25.955  16.807  19.901  1.00 22.08           N  
ATOM    317  CA  PHE    46      25.628  15.975  21.027  1.00 20.65           C  
ATOM    318  CB  PHE    46      24.387  15.150  20.738  1.00 20.49           C  
ATOM    319  CG  PHE    46      23.106  15.982  20.505  1.00 21.76           C  
ATOM    320  CD1 PHE    46      22.763  16.424  19.233  1.00 22.02           C  
ATOM    321  CE1 PHE    46      21.562  17.132  19.018  1.00 20.75           C  
ATOM    322  CZ  PHE    46      20.708  17.390  20.056  1.00 20.72           C  
ATOM    323  CE2 PHE    46      21.034  16.985  21.313  1.00 22.02           C  
ATOM    324  CD2 PHE    46      22.212  16.237  21.528  1.00 19.25           C  
ATOM    325  C   PHE    46      26.802  15.052  21.275  1.00 20.65           C  
ATOM    326  O   PHE    46      27.582  14.743  20.373  1.00 20.57           O  
ATOM    327  N   LYS    47      26.951  14.683  22.532  1.00 20.09           N  
ATOM    328  CA  LYS    47      27.899  13.667  22.996  1.00 20.81           C  
ATOM    329  CB  LYS    47      29.237  14.307  23.205  1.00 21.53           C  
ATOM    330  CG  LYS    47      30.384  13.391  23.398  1.00 22.96           C  
ATOM    331  CD  LYS    47      31.402  14.305  24.114  1.00 29.24           C  
ATOM    332  CE  LYS    47      32.737  13.751  24.049  1.00 32.61           C  
ATOM    333  NZ  LYS    47      32.558  12.431  24.712  1.00 34.05           N  
ATOM    334  C   LYS    47      27.409  13.102  24.314  1.00 19.79           C  
ATOM    335  O   LYS    47      27.245  13.830  25.256  1.00 20.41           O  
ATOM    336  N   ALA    48      27.087  11.814  24.358  1.00 20.88           N  
ATOM    337  CA  ALA    48      26.654  11.134  25.608  1.00 19.76           C  
ATOM    338  CB  ALA    48      26.795   9.661  25.445  1.00 20.00           C  
ATOM    339  C   ALA    48      27.403  11.604  26.889  1.00 19.29           C  
ATOM    340  O   ALA    48      28.644  11.778  26.940  1.00 20.25           O  
ATOM    341  N   ILE    49      26.653  11.781  27.952  1.00 17.21           N  
ATOM    342  CA  ILE    49      27.326  11.959  29.244  1.00 16.14           C  
ATOM    343  CB  ILE    49      26.473  12.966  30.111  1.00 16.78           C  
ATOM    344  CG1 ILE    49      25.018  12.476  30.248  1.00 13.52           C  
ATOM    345  CD1 ILE    49      24.302  13.052  31.425  1.00  9.35           C  
ATOM    346  CG2 ILE    49      26.384  14.221  29.328  1.00 14.98           C  
ATOM    347  C   ILE    49      27.658  10.552  29.912  1.00 16.39           C  
ATOM    348  O   ILE    49      27.504   9.481  29.263  1.00 13.99           O  
ATOM    349  N   THR    50      28.148  10.523  31.147  1.00 13.70           N  
ATOM    350  CA  THR    50      28.545   9.220  31.594  1.00 13.79           C  
ATOM    351  CB  THR    50      29.728   9.284  32.451  1.00 13.53           C  
ATOM    352  OG1 THR    50      29.377  10.085  33.558  1.00 14.42           O  
ATOM    353  CG2 THR    50      30.871   9.955  31.688  1.00 13.83           C  
ATOM    354  C   THR    50      27.393   8.651  32.372  1.00 13.57           C  
ATOM    355  O   THR    50      26.437   9.395  32.747  1.00 13.76           O  
ATOM    356  N   THR    51      27.443   7.343  32.578  1.00 11.47           N  
ATOM    357  CA  THR    51      26.469   6.683  33.402  1.00 11.31           C  
ATOM    358  CB  THR    51      26.713   5.219  33.308  1.00 13.10           C  
ATOM    359  OG1 THR    51      26.506   4.793  31.928  1.00 11.78           O  
ATOM    360  CG2 THR    51      25.855   4.445  34.369  1.00 12.02           C  
ATOM    361  C   THR    51      26.480   7.148  34.855  1.00 11.29           C  
ATOM    362  O   THR    51      25.432   7.331  35.465  1.00 12.45           O  
ATOM    363  N   ASP    52      27.654   7.429  35.382  1.00 11.03           N  
ATOM    364  CA  ASP    52      27.794   8.028  36.693  1.00 12.55           C  
ATOM    365  CB  ASP    52      29.302   8.302  37.004  1.00 14.43           C  
ATOM    366  CG  ASP    52      30.072   7.039  37.591  1.00 19.31           C  
ATOM    367  OD1 ASP    52      29.485   5.940  37.513  1.00 27.02           O  
ATOM    368  OD2 ASP    52      31.215   7.128  38.174  1.00 21.55           O  
ATOM    369  C   ASP    52      27.039   9.359  36.765  1.00 12.87           C  
ATOM    370  O   ASP    52      26.404   9.659  37.772  1.00 13.89           O  
ATOM    371  N   ARG    53      27.144  10.154  35.725  1.00 11.18           N  
ATOM    372  CA  ARG    53      26.554  11.466  35.716  1.00 12.54           C  
ATOM    373  CB  ARG    53      27.034  12.310  34.549  1.00 12.60           C  
ATOM    374  CG  ARG    53      26.504  13.716  34.582  1.00  7.78           C  
ATOM    375  CD  ARG    53      26.875  14.388  35.878  1.00 12.76           C  
ATOM    376  NE  ARG    53      26.392  15.761  35.832  1.00 16.78           N  
ATOM    377  CZ  ARG    53      25.997  16.516  36.869  1.00 21.58           C  
ATOM    378  NH1 ARG    53      25.979  16.073  38.109  1.00 19.67           N  
ATOM    379  NH2 ARG    53      25.599  17.759  36.645  1.00 22.77           N  
ATOM    380  C   ARG    53      25.069  11.439  35.639  1.00 13.23           C  
ATOM    381  O   ARG    53      24.429  12.339  36.159  1.00 14.35           O  
ATOM    382  N   ILE    54      24.519  10.433  34.977  1.00 14.38           N  
ATOM    383  CA  ILE    54      23.074  10.265  34.856  1.00 14.31           C  
ATOM    384  CB  ILE    54      22.821   9.224  33.760  1.00 13.66           C  
ATOM    385  CG1 ILE    54      23.237   9.784  32.407  1.00 11.73           C  
ATOM    386  CD1 ILE    54      23.364   8.749  31.309  1.00 16.69           C  
ATOM    387  CG2 ILE    54      21.396   8.788  33.723  1.00 13.08           C  
ATOM    388  C   ILE    54      22.477   9.825  36.218  1.00 16.60           C  
ATOM    389  O   ILE    54      21.343  10.159  36.642  1.00 15.70           O  
ATOM    390  N   ASP    55      23.287   9.057  36.913  1.00 19.23           N  
ATOM    391  CA  ASP    55      22.971   8.671  38.220  1.00 20.82           C  
ATOM    392  CB  ASP    55      24.020   7.729  38.706  1.00 22.62           C  
ATOM    393  CG  ASP    55      23.760   6.294  38.217  1.00 30.74           C  
ATOM    394  OD1 ASP    55      22.550   5.892  38.097  1.00 38.79           O  
ATOM    395  OD2 ASP    55      24.750   5.552  37.960  1.00 38.29           O  
ATOM    396  C   ASP    55      22.935   9.850  39.103  1.00 20.50           C  
ATOM    397  O   ASP    55      22.053   9.929  39.905  1.00 22.08           O  
ATOM    398  N   GLU    56      23.871  10.774  38.997  1.00 19.54           N  
ATOM    399  CA  GLU    56      23.833  11.857  39.918  1.00 19.49           C  
ATOM    400  CB  GLU    56      25.232  12.336  40.268  1.00 19.24           C  
ATOM    401  CG  GLU    56      26.047  12.911  39.175  1.00 22.89           C  
ATOM    402  CD  GLU    56      27.353  13.501  39.679  1.00 26.77           C  
ATOM    403  OE1 GLU    56      28.376  13.652  38.938  1.00 27.13           O  
ATOM    404  OE2 GLU    56      27.342  13.862  40.862  1.00 33.80           O  
ATOM    405  C   GLU    56      22.793  12.959  39.566  1.00 20.35           C  
ATOM    406  O   GLU    56      22.294  13.626  40.426  1.00 21.27           O  
ATOM    407  N   LEU    57      22.404  13.078  38.311  1.00 20.26           N  
ATOM    408  CA  LEU    57      21.223  13.808  37.956  1.00 20.88           C  
ATOM    409  CB  LEU    57      21.043  13.874  36.447  1.00 19.79           C  
ATOM    410  CG  LEU    57      22.077  14.767  35.888  1.00 18.91           C  
ATOM    411  CD1 LEU    57      22.169  14.565  34.395  1.00 19.95           C  
ATOM    412  CD2 LEU    57      21.690  16.131  36.278  1.00 20.37           C  
ATOM    413  C   LEU    57      19.951  13.210  38.436  1.00 22.31           C  
ATOM    414  O   LEU    57      19.012  13.937  38.705  1.00 21.27           O  
ATOM    415  N   GLU    58      19.853  11.891  38.437  1.00 24.47           N  
ATOM    416  CA  GLU    58      18.597  11.284  38.856  1.00 27.45           C  
ATOM    417  CB  GLU    58      18.550   9.793  38.546  1.00 27.98           C  
ATOM    418  CG  GLU    58      17.126   9.266  38.632  1.00 32.73           C  
ATOM    419  CD  GLU    58      17.039   7.888  39.235  1.00 39.29           C  
ATOM    420  OE1 GLU    58      17.705   6.990  38.662  1.00 43.68           O  
ATOM    421  OE2 GLU    58      16.308   7.696  40.264  1.00 41.02           O  
ATOM    422  C   GLU    58      18.445  11.496  40.342  1.00 28.37           C  
ATOM    423  O   GLU    58      17.355  11.787  40.820  1.00 28.80           O  
ATOM    424  N   LYS    59      19.561  11.318  41.046  1.00 29.98           N  
ATOM    425  CA  LYS    59      19.761  11.714  42.437  1.00 31.92           C  
ATOM    426  CB  LYS    59      21.215  11.434  42.854  1.00 32.83           C  
ATOM    427  CG  LYS    59      21.472  11.494  44.370  1.00 34.60           C  
ATOM    428  CD  LYS    59      22.905  11.967  44.742  1.00 34.73           C  
ATOM    429  CE  LYS    59      22.932  12.688  46.155  1.00 37.52           C  
ATOM    430  NZ  LYS    59      22.483  14.144  46.060  1.00 39.04           N  
ATOM    431  C   LYS    59      19.396  13.177  42.736  1.00 31.08           C  
ATOM    432  O   LYS    59      18.800  13.445  43.751  1.00 31.43           O  
ATOM    433  N   GLU    60      19.742  14.104  41.856  1.00 30.65           N  
ATOM    434  CA  GLU    60      19.404  15.530  42.002  1.00 30.83           C  
ATOM    435  CB  GLU    60      20.158  16.326  40.923  1.00 31.45           C  
ATOM    436  CG  GLU    60      20.852  17.680  41.276  1.00 33.28           C  
ATOM    437  CD  GLU    60      22.096  17.934  40.353  1.00 33.99           C  
ATOM    438  OE1 GLU    60      23.208  17.444  40.700  1.00 39.01           O  
ATOM    439  OE2 GLU    60      21.979  18.595  39.272  1.00 36.33           O  
ATOM    440  C   GLU    60      17.919  15.833  41.801  1.00 29.28           C  
ATOM    441  O   GLU    60      17.413  16.842  42.281  1.00 28.68           O  
ATOM    442  N   ASN    61      17.226  14.986  41.067  1.00 28.25           N  
ATOM    443  CA  ASN    61      15.863  15.292  40.701  1.00 28.16           C  
ATOM    444  CB  ASN    61      15.683  15.229  39.185  1.00 27.11           C  
ATOM    445  CG  ASN    61      16.277  16.453  38.487  1.00 26.22           C  
ATOM    446  OD1 ASN    61      15.596  17.461  38.363  1.00 25.01           O  
ATOM    447  ND2 ASN    61      17.553  16.376  38.038  1.00 20.95           N  
ATOM    448  C   ASN    61      14.881  14.413  41.411  1.00 28.78           C  
ATOM    449  O   ASN    61      13.741  14.277  40.983  1.00 28.18           O  
ATOM    450  N   THR    62      15.339  13.813  42.506  1.00 30.76           N  
ATOM    451  CA  THR    62      14.504  12.932  43.346  1.00 32.67           C  
ATOM    452  CB  THR    62      14.939  11.427  43.286  1.00 33.62           C  
ATOM    453  OG1 THR    62      16.366  11.329  43.294  1.00 36.59           O  
ATOM    454  CG2 THR    62      14.442  10.751  42.009  1.00 34.57           C  
ATOM    455  C   THR    62      14.382  13.402  44.797  1.00 32.26           C  
ATOM    456  O   THR    62      15.376  13.736  45.461  1.00 32.05           O  
ATOM    457  N   THR    63      13.142  13.411  45.271  1.00 32.61           N  
ATOM    458  CA  THR    63      12.764  14.129  46.513  1.00 32.78           C  
ATOM    459  CB  THR    63      12.224  15.562  46.193  1.00 32.81           C  
ATOM    460  OG1 THR    63      10.915  15.466  45.620  1.00 33.11           O  
ATOM    461  CG2 THR    63      13.164  16.319  45.196  1.00 32.27           C  
ATOM    462  C   THR    63      11.738  13.365  47.342  1.00 32.32           C  
ATOM    463  O   THR    63      11.068  12.473  46.826  1.00 32.12           O  
ATOM    464  N   LYS    74      11.319   8.612  46.903  1.00 37.42           N  
ATOM    465  CA  LYS    74      10.152   8.090  46.185  1.00 36.53           C  
ATOM    466  CB  LYS    74       9.010   7.662  47.174  1.00 36.19           C  
ATOM    467  CG  LYS    74       8.084   8.786  47.704  1.00 33.82           C  
ATOM    468  CD  LYS    74       8.119   8.904  49.245  1.00 31.41           C  
ATOM    469  CE  LYS    74       7.051   8.058  49.986  1.00 26.31           C  
ATOM    470  NZ  LYS    74       7.482   6.670  50.235  1.00 23.93           N  
ATOM    471  C   LYS    74       9.632   9.030  45.058  1.00 36.33           C  
ATOM    472  O   LYS    74       8.726   8.641  44.314  1.00 36.59           O  
ATOM    473  N   GLU    75      10.190  10.239  44.915  1.00 35.58           N  
ATOM    474  CA  GLU    75       9.659  11.189  43.906  1.00 35.18           C  
ATOM    475  CB  GLU    75       8.762  12.218  44.585  1.00 35.76           C  
ATOM    476  CG  GLU    75       7.851  12.973  43.613  1.00 38.40           C  
ATOM    477  CD  GLU    75       6.904  12.038  42.873  1.00 40.91           C  
ATOM    478  OE1 GLU    75       6.086  11.341  43.516  1.00 40.97           O  
ATOM    479  OE2 GLU    75       6.978  12.006  41.637  1.00 41.99           O  
ATOM    480  C   GLU    75      10.640  11.889  42.919  1.00 34.29           C  
ATOM    481  O   GLU    75      11.349  12.846  43.270  1.00 33.48           O  
ATOM    482  N   LEU    76      10.616  11.433  41.667  1.00 33.59           N  
ATOM    483  CA  LEU    76      11.447  11.975  40.573  1.00 32.82           C  
ATOM    484  CB  LEU    76      12.040  10.816  39.749  1.00 32.65           C  
ATOM    485  CG  LEU    76      12.845  11.067  38.451  1.00 32.53           C  
ATOM    486  CD1 LEU    76      14.275  11.543  38.719  1.00 28.46           C  
ATOM    487  CD2 LEU    76      12.854   9.822  37.564  1.00 32.27           C  
ATOM    488  C   LEU    76      10.706  12.948  39.634  1.00 33.01           C  
ATOM    489  O   LEU    76       9.575  12.678  39.211  1.00 33.18           O  
ATOM    490  N   ASP    77      11.353  14.067  39.299  1.00 32.53           N  
ATOM    491  CA  ASP    77      10.834  15.006  38.310  1.00 32.48           C  
ATOM    492  CB  ASP    77      11.226  16.449  38.676  1.00 32.94           C  
ATOM    493  CG  ASP    77      10.532  17.513  37.791  1.00 35.11           C  
ATOM    494  OD1 ASP    77      10.001  17.201  36.698  1.00 36.56           O  
ATOM    495  OD2 ASP    77      10.534  18.700  38.175  1.00 37.85           O  
ATOM    496  C   ASP    77      11.415  14.641  36.964  1.00 32.39           C  
ATOM    497  O   ASP    77      12.437  15.202  36.554  1.00 31.80           O  
ATOM    498  N   SER    78      10.759  13.706  36.280  1.00 32.31           N  
ATOM    499  CA  SER    78      11.246  13.190  34.991  1.00 32.25           C  
ATOM    500  CB  SER    78      10.196  12.316  34.306  1.00 32.46           C  
ATOM    501  OG  SER    78       9.976  11.136  35.020  1.00 33.62           O  
ATOM    502  C   SER    78      11.556  14.300  34.040  1.00 31.58           C  
ATOM    503  O   SER    78      12.667  14.390  33.523  1.00 32.23           O  
ATOM    504  N   GLN    79      10.541  15.119  33.801  1.00 30.92           N  
ATOM    505  CA  GLN    79      10.585  16.227  32.860  1.00 31.08           C  
ATOM    506  CB  GLN    79       9.472  17.242  33.225  1.00 32.51           C  
ATOM    507  CG  GLN    79       8.882  18.026  32.049  1.00 37.21           C  
ATOM    508  CD  GLN    79       7.928  17.155  31.243  1.00 41.23           C  
ATOM    509  OE1 GLN    79       8.331  16.099  30.678  1.00 41.13           O  
ATOM    510  NE2 GLN    79       6.654  17.576  31.195  1.00 40.07           N  
ATOM    511  C   GLN    79      11.924  16.911  32.980  1.00 28.93           C  
ATOM    512  O   GLN    79      12.715  16.964  32.037  1.00 28.03           O  
ATOM    513  N   ARG    80      12.142  17.379  34.199  1.00 27.01           N  
ATOM    514  CA  ARG    80      13.266  18.147  34.593  1.00 25.70           C  
ATOM    515  CB  ARG    80      13.042  18.444  36.042  1.00 26.46           C  
ATOM    516  CG  ARG    80      14.013  19.352  36.663  1.00 30.51           C  
ATOM    517  CD  ARG    80      13.706  20.742  36.297  1.00 38.40           C  
ATOM    518  NE  ARG    80      14.934  21.501  36.448  1.00 42.71           N  
ATOM    519  CZ  ARG    80      15.094  22.747  36.037  1.00 42.09           C  
ATOM    520  NH1 ARG    80      14.082  23.387  35.447  1.00 39.34           N  
ATOM    521  NH2 ARG    80      16.285  23.323  36.205  1.00 43.29           N  
ATOM    522  C   ARG    80      14.578  17.391  34.419  1.00 23.77           C  
ATOM    523  O   ARG    80      15.557  17.952  33.965  1.00 22.48           O  
ATOM    524  N   PHE    81      14.562  16.121  34.810  1.00 22.62           N  
ATOM    525  CA  PHE    81      15.674  15.177  34.754  1.00 21.65           C  
ATOM    526  CB  PHE    81      15.186  13.890  35.376  1.00 20.76           C  
ATOM    527  CG  PHE    81      16.046  12.718  35.155  1.00 20.61           C  
ATOM    528  CD1 PHE    81      17.400  12.736  35.488  1.00 19.36           C  
ATOM    529  CE1 PHE    81      18.207  11.589  35.309  1.00 20.60           C  
ATOM    530  CZ  PHE    81      17.636  10.416  34.832  1.00 20.54           C  
ATOM    531  CE2 PHE    81      16.235  10.388  34.534  1.00 20.20           C  
ATOM    532  CD2 PHE    81      15.471  11.521  34.698  1.00 20.38           C  
ATOM    533  C   PHE    81      16.124  14.915  33.338  1.00 22.06           C  
ATOM    534  O   PHE    81      17.323  14.919  33.077  1.00 22.40           O  
ATOM    535  N   TYR    82      15.179  14.704  32.420  1.00 22.60           N  
ATOM    536  CA  TYR    82      15.504  14.474  31.012  1.00 23.05           C  
ATOM    537  CB  TYR    82      14.260  13.970  30.275  1.00 25.87           C  
ATOM    538  CG  TYR    82      13.846  12.610  30.765  1.00 28.95           C  
ATOM    539  CD1 TYR    82      14.789  11.657  31.090  1.00 30.67           C  
ATOM    540  CE1 TYR    82      14.425  10.389  31.553  1.00 31.68           C  
ATOM    541  CZ  TYR    82      13.074  10.072  31.713  1.00 34.49           C  
ATOM    542  OH  TYR    82      12.679   8.818  32.175  1.00 33.95           O  
ATOM    543  CE2 TYR    82      12.090  11.008  31.394  1.00 35.76           C  
ATOM    544  CD2 TYR    82      12.498  12.284  30.910  1.00 35.17           C  
ATOM    545  C   TYR    82      16.085  15.715  30.365  1.00 21.43           C  
ATOM    546  O   TYR    82      17.107  15.703  29.686  1.00 21.08           O  
ATOM    547  N   ALA    83      15.441  16.831  30.613  1.00 21.02           N  
ATOM    548  CA  ALA    83      15.958  18.117  30.162  1.00 20.02           C  
ATOM    549  CB  ALA    83      15.016  19.328  30.671  1.00 20.01           C  
ATOM    550  C   ALA    83      17.405  18.313  30.598  1.00 19.29           C  
ATOM    551  O   ALA    83      18.208  18.791  29.818  1.00 20.55           O  
ATOM    552  N   ARG    84      17.745  17.965  31.843  1.00 18.86           N  
ATOM    553  CA  ARG    84      19.065  18.240  32.395  1.00 18.13           C  
ATOM    554  CB  ARG    84      19.093  17.972  33.866  1.00 18.11           C  
ATOM    555  CG  ARG    84      17.917  18.552  34.588  1.00 22.10           C  
ATOM    556  CD  ARG    84      18.145  19.825  35.369  1.00 24.88           C  
ATOM    557  NE  ARG    84      19.550  20.050  35.601  1.00 30.12           N  
ATOM    558  CZ  ARG    84      20.191  19.778  36.714  1.00 32.36           C  
ATOM    559  NH1 ARG    84      19.530  19.249  37.759  1.00 32.45           N  
ATOM    560  NH2 ARG    84      21.509  20.040  36.755  1.00 34.28           N  
ATOM    561  C   ARG    84      20.059  17.357  31.728  1.00 17.71           C  
ATOM    562  O   ARG    84      21.138  17.790  31.448  1.00 19.18           O  
ATOM    563  N   ILE    85      19.691  16.117  31.451  1.00 16.84           N  
ATOM    564  CA  ILE    85      20.486  15.227  30.614  1.00 15.98           C  
ATOM    565  CB  ILE    85      19.819  13.795  30.430  1.00 15.46           C  
ATOM    566  CG1 ILE    85      19.684  13.029  31.765  1.00 15.19           C  
ATOM    567  CD1 ILE    85      18.822  11.659  31.682  1.00 17.17           C  
ATOM    568  CG2 ILE    85      20.605  12.946  29.425  1.00 15.25           C  
ATOM    569  C   ILE    85      20.758  15.814  29.246  1.00 16.66           C  
ATOM    570  O   ILE    85      21.910  15.714  28.753  1.00 15.24           O  
ATOM    571  N   ALA    86      19.684  16.364  28.618  1.00 16.05           N  
ATOM    572  CA  ALA    86      19.765  16.965  27.273  1.00 15.77           C  
ATOM    573  CB  ALA    86      18.392  17.342  26.829  1.00 15.34           C  
ATOM    574  C   ALA    86      20.736  18.193  27.266  1.00 15.80           C  
ATOM    575  O   ALA    86      21.575  18.371  26.373  1.00 15.99           O  
ATOM    576  N   VAL    87      20.616  19.031  28.281  1.00 14.85           N  
ATOM    577  CA  VAL    87      21.425  20.178  28.389  1.00 14.50           C  
ATOM    578  CB  VAL    87      20.934  20.969  29.639  1.00 14.01           C  
ATOM    579  CG1 VAL    87      21.980  22.001  30.162  1.00 12.70           C  
ATOM    580  CG2 VAL    87      19.664  21.689  29.271  1.00 12.19           C  
ATOM    581  C   VAL    87      22.871  19.688  28.380  1.00 16.46           C  
ATOM    582  O   VAL    87      23.624  20.072  27.537  1.00 17.67           O  
ATOM    583  N   GLU    88      23.208  18.722  29.235  1.00 17.32           N  
ATOM    584  CA  GLU    88      24.580  18.225  29.418  1.00 17.61           C  
ATOM    585  CB  GLU    88      24.629  17.598  30.822  1.00 16.62           C  
ATOM    586  CG  GLU    88      24.829  18.630  31.957  1.00 21.54           C  
ATOM    587  CD  GLU    88      24.663  18.089  33.413  1.00 24.56           C  
ATOM    588  OE1 GLU    88      25.102  16.923  33.658  1.00 33.12           O  
ATOM    589  OE2 GLU    88      24.140  18.839  34.353  1.00 27.44           O  
ATOM    590  C   GLU    88      25.073  17.268  28.231  1.00 16.44           C  
ATOM    591  O   GLU    88      26.262  17.186  27.880  1.00 12.07           O  
ATOM    592  N   THR    89      24.149  16.619  27.545  1.00 15.07           N  
ATOM    593  CA  THR    89      24.499  15.958  26.263  1.00 15.29           C  
ATOM    594  CB  THR    89      23.333  15.068  25.935  1.00 15.03           C  
ATOM    595  OG1 THR    89      23.106  14.290  27.112  1.00 14.26           O  
ATOM    596  CG2 THR    89      23.429  14.211  24.681  1.00  9.85           C  
ATOM    597  C   THR    89      24.745  16.968  25.133  1.00 17.04           C  
ATOM    598  O   THR    89      25.364  16.663  24.154  1.00 16.92           O  
ATOM    599  N   THR    90      24.271  18.197  25.281  1.00 19.54           N  
ATOM    600  CA  THR    90      24.367  19.178  24.188  1.00 19.61           C  
ATOM    601  CB  THR    90      23.059  19.992  23.956  1.00 20.32           C  
ATOM    602  OG1 THR    90      21.956  19.068  23.762  1.00 21.12           O  
ATOM    603  CG2 THR    90      23.129  20.885  22.693  1.00 17.16           C  
ATOM    604  C   THR    90      25.664  19.969  24.358  1.00 19.62           C  
ATOM    605  O   THR    90      25.778  20.873  25.215  1.00 20.43           O  
ATOM    606  N   VAL    91      26.638  19.616  23.514  1.00 18.48           N  
ATOM    607  CA  VAL    91      27.956  20.284  23.521  1.00 18.81           C  
ATOM    608  CB  VAL    91      28.987  19.557  22.567  1.00 19.72           C  
ATOM    609  CG1 VAL    91      30.346  20.051  22.846  1.00 19.45           C  
ATOM    610  CG2 VAL    91      28.966  18.123  22.745  1.00 19.46           C  
ATOM    611  C   VAL    91      27.880  21.695  22.968  1.00 18.01           C  
ATOM    612  O   VAL    91      28.627  22.606  23.392  1.00 18.62           O  
ATOM    613  N   TYR    92      27.096  21.815  21.901  1.00 17.56           N  
ATOM    614  CA  TYR    92      26.975  23.058  21.165  1.00 16.59           C  
ATOM    615  CB  TYR    92      27.926  23.062  20.032  1.00 14.55           C  
ATOM    616  CG  TYR    92      27.800  24.286  19.121  1.00 16.38           C  
ATOM    617  CD1 TYR    92      28.114  25.548  19.620  1.00 15.65           C  
ATOM    618  CE1 TYR    92      28.031  26.708  18.811  1.00 18.60           C  
ATOM    619  CZ  TYR    92      27.647  26.599  17.494  1.00 18.37           C  
ATOM    620  OH  TYR    92      27.639  27.766  16.803  1.00 17.93           O  
ATOM    621  CE2 TYR    92      27.239  25.332  16.963  1.00 19.18           C  
ATOM    622  CD2 TYR    92      27.321  24.191  17.778  1.00 13.34           C  
ATOM    623  C   TYR    92      25.592  23.144  20.599  1.00 15.93           C  
ATOM    624  O   TYR    92      25.267  22.347  19.755  1.00 15.58           O  
ATOM    625  N   PRO    93      24.764  24.096  21.067  1.00 17.21           N  
ATOM    626  CA  PRO    93      24.973  25.187  22.027  1.00 18.35           C  
ATOM    627  CB  PRO    93      23.739  26.087  21.770  1.00 16.15           C  
ATOM    628  CG  PRO    93      22.750  25.233  21.411  1.00 18.69           C  
ATOM    629  CD  PRO    93      23.370  24.125  20.572  1.00 17.17           C  
ATOM    630  C   PRO    93      24.956  24.638  23.459  1.00 18.34           C  
ATOM    631  O   PRO    93      24.095  23.797  23.709  1.00 19.20           O  
ATOM    632  N   THR    94      25.907  25.017  24.338  1.00 17.97           N  
ATOM    633  CA  THR    94      25.741  24.685  25.739  1.00 18.77           C  
ATOM    634  CB  THR    94      26.911  24.958  26.644  1.00 19.57           C  
ATOM    635  OG1 THR    94      28.055  24.414  26.061  1.00 30.93           O  
ATOM    636  CG2 THR    94      26.748  24.246  28.082  1.00 18.54           C  
ATOM    637  C   THR    94      24.872  25.781  26.259  1.00 17.08           C  
ATOM    638  O   THR    94      25.356  26.933  26.354  1.00 15.50           O  
ATOM    639  N   PHE    95      23.684  25.367  26.709  1.00 13.94           N  
ATOM    640  CA  PHE    95      22.720  26.234  27.390  1.00 13.94           C  
ATOM    641  CB  PHE    95      21.434  25.519  27.470  1.00 10.07           C  
ATOM    642  CG  PHE    95      20.861  25.281  26.174  1.00 10.86           C  
ATOM    643  CD1 PHE    95      20.812  26.315  25.204  1.00 10.65           C  
ATOM    644  CE1 PHE    95      20.206  26.099  23.929  1.00 13.83           C  
ATOM    645  CZ  PHE    95      19.670  24.782  23.602  1.00 13.30           C  
ATOM    646  CE2 PHE    95      19.782  23.777  24.520  1.00 14.98           C  
ATOM    647  CD2 PHE    95      20.394  24.029  25.825  1.00 13.69           C  
ATOM    648  C   PHE    95      23.134  26.721  28.760  1.00 13.50           C  
ATOM    649  O   PHE    95      22.522  27.645  29.302  1.00 14.82           O  
ATOM    650  N   LYS    96      24.252  26.209  29.267  1.00 14.30           N  
ATOM    651  CA  LYS    96      24.787  26.724  30.505  1.00 13.87           C  
ATOM    652  CB  LYS    96      25.631  25.685  31.168  1.00 13.85           C  
ATOM    653  CG  LYS    96      24.882  24.489  31.510  1.00 16.80           C  
ATOM    654  CD  LYS    96      25.766  23.655  32.396  1.00 20.99           C  
ATOM    655  CE  LYS    96      24.983  22.448  32.681  1.00 26.00           C  
ATOM    656  NZ  LYS    96      25.546  21.790  33.869  1.00 31.16           N  
ATOM    657  C   LYS    96      25.620  27.907  30.259  1.00 14.53           C  
ATOM    658  O   LYS    96      26.070  28.554  31.190  1.00 14.15           O  
ATOM    659  N   ALA    97      25.833  28.208  28.991  1.00 15.05           N  
ATOM    660  CA  ALA    97      26.764  29.230  28.608  1.00 14.58           C  
ATOM    661  CB  ALA    97      26.938  29.240  27.092  1.00 15.32           C  
ATOM    662  C   ALA    97      26.289  30.586  29.114  1.00 15.45           C  
ATOM    663  O   ALA    97      25.145  31.031  28.898  1.00 12.20           O  
ATOM    664  N   LYS    98      27.201  31.281  29.770  1.00 16.58           N  
ATOM    665  CA  LYS    98      26.907  32.603  30.258  1.00 17.66           C  
ATOM    666  CB  LYS    98      28.137  33.298  30.847  1.00 18.84           C  
ATOM    667  CG  LYS    98      27.783  34.579  31.612  1.00 20.38           C  
ATOM    668  CD  LYS    98      26.602  34.313  32.641  1.00 25.48           C  
ATOM    669  CE  LYS    98      26.522  35.316  33.835  1.00 26.15           C  
ATOM    670  NZ  LYS    98      27.555  35.040  34.864  1.00 27.46           N  
ATOM    671  C   LYS    98      26.235  33.524  29.233  1.00 18.86           C  
ATOM    672  O   LYS    98      25.284  34.231  29.589  1.00 18.04           O  
ATOM    673  N   GLU    99      26.729  33.546  27.998  1.00 18.87           N  
ATOM    674  CA  GLU    99      26.246  34.500  27.014  1.00 22.52           C  
ATOM    675  CB  GLU    99      27.095  34.335  25.775  1.00 22.40           C  
ATOM    676  CG  GLU    99      27.145  35.580  24.818  1.00 30.66           C  
ATOM    677  CD  GLU    99      27.966  35.274  23.465  1.00 31.73           C  
ATOM    678  OE1 GLU    99      28.905  34.383  23.507  1.00 35.39           O  
ATOM    679  OE2 GLU    99      27.613  35.880  22.379  1.00 38.64           O  
ATOM    680  C   GLU    99      24.772  34.230  26.662  1.00 20.40           C  
ATOM    681  O   GLU    99      24.047  35.139  26.263  1.00 20.54           O  
ATOM    682  N   LEU   100      24.351  32.969  26.759  1.00 18.76           N  
ATOM    683  CA  LEU   100      22.956  32.571  26.461  1.00 18.78           C  
ATOM    684  CB  LEU   100      22.870  31.071  26.089  1.00 17.50           C  
ATOM    685  CG  LEU   100      23.339  30.554  24.717  1.00 17.80           C  
ATOM    686  CD1 LEU   100      23.200  29.053  24.515  1.00 14.79           C  
ATOM    687  CD2 LEU   100      22.644  31.317  23.541  1.00 14.11           C  
ATOM    688  C   LEU   100      22.093  32.846  27.674  1.00 19.30           C  
ATOM    689  O   LEU   100      20.909  33.219  27.555  1.00 20.76           O  
ATOM    690  N   ARG   101      22.666  32.605  28.846  1.00 18.77           N  
ATOM    691  CA  ARG   101      21.999  32.879  30.089  1.00 19.74           C  
ATOM    692  CB  ARG   101      22.821  32.375  31.282  1.00 18.50           C  
ATOM    693  CG  ARG   101      22.515  30.935  31.584  1.00 19.94           C  
ATOM    694  CD  ARG   101      23.192  30.478  32.879  1.00 22.23           C  
ATOM    695  NE  ARG   101      24.565  30.112  32.673  1.00 16.11           N  
ATOM    696  CZ  ARG   101      25.593  30.694  33.261  1.00 17.66           C  
ATOM    697  NH1 ARG   101      25.429  31.692  34.111  1.00 17.42           N  
ATOM    698  NH2 ARG   101      26.805  30.273  32.984  1.00 14.05           N  
ATOM    699  C   ARG   101      21.667  34.354  30.141  1.00 19.76           C  
ATOM    700  O   ARG   101      20.492  34.677  30.302  1.00 19.71           O  
ATOM    701  N   GLU   102      22.671  35.218  29.939  1.00 19.83           N  
ATOM    702  CA  GLU   102      22.483  36.675  29.867  1.00 22.91           C  
ATOM    703  CB  GLU   102      23.818  37.482  29.690  1.00 23.94           C  
ATOM    704  CG  GLU   102      24.910  37.244  30.767  1.00 29.27           C  
ATOM    705  CD  GLU   102      25.233  38.447  31.686  1.00 36.61           C  
ATOM    706  OE1 GLU   102      25.157  39.610  31.232  1.00 39.33           O  
ATOM    707  OE2 GLU   102      25.617  38.228  32.872  1.00 39.86           O  
ATOM    708  C   GLU   102      21.481  37.117  28.797  1.00 22.86           C  
ATOM    709  O   GLU   102      20.624  37.947  29.104  1.00 24.92           O  
ATOM    710  N   ALA   103      21.581  36.584  27.568  1.00 22.16           N  
ATOM    711  CA  ALA   103      20.672  36.995  26.446  1.00 20.87           C  
ATOM    712  CB  ALA   103      21.159  36.494  25.149  1.00 19.77           C  
ATOM    713  C   ALA   103      19.256  36.581  26.566  1.00 20.67           C  
ATOM    714  O   ALA   103      18.342  37.288  26.077  1.00 20.43           O  
ATOM    715  N   TYR   104      19.053  35.382  27.096  1.00 20.97           N  
ATOM    716  CA  TYR   104      17.719  34.868  27.275  1.00 20.47           C  
ATOM    717  CB  TYR   104      17.660  33.381  27.027  1.00 19.90           C  
ATOM    718  CG  TYR   104      17.652  33.208  25.534  1.00 21.25           C  
ATOM    719  CD1 TYR   104      16.455  33.360  24.806  1.00 15.71           C  
ATOM    720  CE1 TYR   104      16.422  33.242  23.497  1.00 18.68           C  
ATOM    721  CZ  TYR   104      17.593  33.008  22.795  1.00 20.05           C  
ATOM    722  OH  TYR   104      17.538  32.892  21.397  1.00 19.95           O  
ATOM    723  CE2 TYR   104      18.828  32.946  23.461  1.00 21.95           C  
ATOM    724  CD2 TYR   104      18.844  33.060  24.834  1.00 20.82           C  
ATOM    725  C   TYR   104      17.153  35.261  28.596  1.00 21.13           C  
ATOM    726  O   TYR   104      15.944  35.098  28.827  1.00 21.96           O  
ATOM    727  N   LYS   105      18.009  35.873  29.410  1.00 21.62           N  
ATOM    728  CA  LYS   105      17.630  36.387  30.716  1.00 22.93           C  
ATOM    729  CB  LYS   105      16.617  37.532  30.591  1.00 23.91           C  
ATOM    730  CG  LYS   105      17.273  38.921  30.447  1.00 27.24           C  
ATOM    731  CD  LYS   105      17.195  39.533  29.029  1.00 30.95           C  
ATOM    732  CE  LYS   105      18.261  40.704  28.892  1.00 34.64           C  
ATOM    733  NZ  LYS   105      19.113  40.640  27.616  1.00 37.74           N  
ATOM    734  C   LYS   105      17.162  35.290  31.711  1.00 22.05           C  
ATOM    735  O   LYS   105      16.191  35.436  32.430  1.00 21.46           O  
ATOM    736  N   THR   106      17.864  34.173  31.748  1.00 21.64           N  
ATOM    737  CA  THR   106      17.491  33.186  32.728  1.00 20.92           C  
ATOM    738  CB  THR   106      16.259  32.265  32.262  1.00 20.46           C  
ATOM    739  OG1 THR   106      15.976  31.226  33.229  1.00 22.59           O  
ATOM    740  CG2 THR   106      16.487  31.670  30.914  1.00 22.45           C  
ATOM    741  C   THR   106      18.767  32.487  33.143  1.00 19.43           C  
ATOM    742  O   THR   106      19.568  32.128  32.286  1.00 19.04           O  
ATOM    743  N   GLU   107      18.967  32.363  34.455  1.00 17.95           N  
ATOM    744  CA  GLU   107      20.007  31.510  34.937  1.00 18.97           C  
ATOM    745  CB  GLU   107      20.415  31.932  36.338  1.00 18.37           C  
ATOM    746  CG  GLU   107      21.141  33.242  36.407  1.00 23.02           C  
ATOM    747  CD  GLU   107      22.411  33.339  35.569  1.00 26.50           C  
ATOM    748  OE1 GLU   107      23.304  32.496  35.789  1.00 31.41           O  
ATOM    749  OE2 GLU   107      22.518  34.272  34.712  1.00 25.88           O  
ATOM    750  C   GLU   107      19.710  29.974  34.852  1.00 18.34           C  
ATOM    751  O   GLU   107      20.574  29.177  35.139  1.00 19.20           O  
ATOM    752  N   ASP   108      18.508  29.573  34.439  1.00 18.56           N  
ATOM    753  CA  ASP   108      18.150  28.171  34.281  1.00 19.20           C  
ATOM    754  CB  ASP   108      16.678  27.998  34.487  1.00 19.68           C  
ATOM    755  CG  ASP   108      16.269  26.536  34.662  1.00 23.28           C  
ATOM    756  OD1 ASP   108      17.152  25.626  34.525  1.00 24.31           O  
ATOM    757  OD2 ASP   108      15.028  26.314  34.935  1.00 25.02           O  
ATOM    758  C   ASP   108      18.426  27.670  32.880  1.00 19.38           C  
ATOM    759  O   ASP   108      17.761  28.075  31.955  1.00 20.67           O  
ATOM    760  N   PRO   109      19.404  26.766  32.721  1.00 18.70           N  
ATOM    761  CA  PRO   109      19.829  26.330  31.437  1.00 17.64           C  
ATOM    762  CB  PRO   109      20.954  25.379  31.771  1.00 18.20           C  
ATOM    763  CG  PRO   109      21.416  25.852  33.127  1.00 17.19           C  
ATOM    764  CD  PRO   109      20.184  26.144  33.799  1.00 18.29           C  
ATOM    765  C   PRO   109      18.716  25.599  30.706  1.00 18.72           C  
ATOM    766  O   PRO   109      18.639  25.641  29.462  1.00 19.42           O  
ATOM    767  N   VAL   110      17.831  24.963  31.441  1.00 17.84           N  
ATOM    768  CA  VAL   110      16.708  24.297  30.828  1.00 18.02           C  
ATOM    769  CB  VAL   110      16.053  23.419  31.860  1.00 17.83           C  
ATOM    770  CG1 VAL   110      14.598  23.029  31.451  1.00 17.31           C  
ATOM    771  CG2 VAL   110      16.969  22.236  32.173  1.00 17.10           C  
ATOM    772  C   VAL   110      15.656  25.308  30.322  1.00 18.23           C  
ATOM    773  O   VAL   110      14.988  25.046  29.365  1.00 19.68           O  
ATOM    774  N   GLU   111      15.518  26.443  30.968  1.00 17.58           N  
ATOM    775  CA  GLU   111      14.668  27.494  30.448  1.00 19.64           C  
ATOM    776  CB  GLU   111      14.290  28.520  31.546  1.00 19.89           C  
ATOM    777  CG  GLU   111      13.332  29.633  31.091  1.00 22.87           C  
ATOM    778  CD  GLU   111      11.894  29.165  30.963  1.00 32.09           C  
ATOM    779  OE1 GLU   111      11.608  28.007  31.377  1.00 33.07           O  
ATOM    780  OE2 GLU   111      11.027  29.954  30.468  1.00 36.91           O  
ATOM    781  C   GLU   111      15.389  28.165  29.276  1.00 19.09           C  
ATOM    782  O   GLU   111      14.775  28.493  28.279  1.00 20.67           O  
ATOM    783  N   VAL   112      16.702  28.331  29.346  1.00 20.18           N  
ATOM    784  CA  VAL   112      17.425  28.747  28.136  1.00 18.33           C  
ATOM    785  CB  VAL   112      18.932  28.712  28.290  1.00 19.12           C  
ATOM    786  CG1 VAL   112      19.558  29.416  27.112  1.00 20.86           C  
ATOM    787  CG2 VAL   112      19.381  29.344  29.525  1.00 17.22           C  
ATOM    788  C   VAL   112      17.087  27.804  26.981  1.00 17.59           C  
ATOM    789  O   VAL   112      16.879  28.247  25.891  1.00 18.55           O  
ATOM    790  N   ALA   113      17.088  26.503  27.190  1.00 15.88           N  
ATOM    791  CA  ALA   113      16.682  25.583  26.119  1.00 15.33           C  
ATOM    792  CB  ALA   113      16.696  24.102  26.628  1.00 14.31           C  
ATOM    793  C   ALA   113      15.303  25.958  25.531  1.00 14.88           C  
ATOM    794  O   ALA   113      15.181  26.130  24.350  1.00 15.68           O  
ATOM    795  N   LYS   114      14.284  26.113  26.365  1.00 15.49           N  
ATOM    796  CA  LYS   114      12.922  26.379  25.894  1.00 15.81           C  
ATOM    797  CB  LYS   114      11.977  26.418  27.033  1.00 14.89           C  
ATOM    798  CG  LYS   114      11.769  25.047  27.610  1.00 15.66           C  
ATOM    799  CD  LYS   114      11.092  25.255  28.888  1.00 19.06           C  
ATOM    800  CE  LYS   114      11.239  24.085  29.808  1.00 27.60           C  
ATOM    801  NZ  LYS   114      10.194  23.110  29.414  1.00 31.05           N  
ATOM    802  C   LYS   114      12.868  27.693  25.174  1.00 15.99           C  
ATOM    803  O   LYS   114      12.114  27.825  24.264  1.00 15.70           O  
ATOM    804  N   ARG   115      13.722  28.641  25.520  1.00 14.94           N  
ATOM    805  CA  ARG   115      13.610  29.916  24.844  1.00 15.18           C  
ATOM    806  CB  ARG   115      14.048  31.059  25.756  1.00 15.14           C  
ATOM    807  CG  ARG   115      13.301  30.970  27.047  1.00 14.34           C  
ATOM    808  CD  ARG   115      13.597  32.177  27.954  1.00 11.12           C  
ATOM    809  NE  ARG   115      12.713  32.171  29.150  1.00 17.67           N  
ATOM    810  CZ  ARG   115      12.737  33.069  30.153  1.00 14.23           C  
ATOM    811  NH1 ARG   115      13.615  34.046  30.104  1.00 11.07           N  
ATOM    812  NH2 ARG   115      11.866  33.016  31.177  1.00 11.91           N  
ATOM    813  C   ARG   115      14.387  29.848  23.537  1.00 16.52           C  
ATOM    814  O   ARG   115      13.929  30.381  22.568  1.00 18.06           O  
ATOM    815  N   VAL   116      15.528  29.155  23.473  1.00 17.00           N  
ATOM    816  CA  VAL   116      16.218  28.965  22.184  1.00 16.71           C  
ATOM    817  CB  VAL   116      17.631  28.418  22.377  1.00 17.42           C  
ATOM    818  CG1 VAL   116      18.396  28.290  21.037  1.00 16.73           C  
ATOM    819  CG2 VAL   116      18.432  29.310  23.353  1.00 18.31           C  
ATOM    820  C   VAL   116      15.424  28.122  21.162  1.00 17.18           C  
ATOM    821  O   VAL   116      15.290  28.493  20.014  1.00 18.29           O  
ATOM    822  N   LEU   117      14.870  27.006  21.616  1.00 16.52           N  
ATOM    823  CA  LEU   117      14.097  26.103  20.812  1.00 13.53           C  
ATOM    824  CB  LEU   117      14.410  24.676  21.274  1.00 14.08           C  
ATOM    825  CG  LEU   117      15.884  24.200  21.182  1.00  9.14           C  
ATOM    826  CD1 LEU   117      16.161  22.922  21.816  1.00 13.23           C  
ATOM    827  CD2 LEU   117      16.182  23.943  19.787  1.00 16.66           C  
ATOM    828  C   LEU   117      12.600  26.405  20.992  1.00 15.03           C  
ATOM    829  O   LEU   117      11.802  25.609  21.585  1.00 12.93           O  
ATOM    830  N   SER   118      12.227  27.585  20.477  1.00 16.24           N  
ATOM    831  CA  SER   118      10.937  28.164  20.830  1.00 17.43           C  
ATOM    832  CB  SER   118      10.964  29.665  20.704  1.00 18.75           C  
ATOM    833  OG  SER   118      11.532  30.081  19.468  1.00 22.89           O  
ATOM    834  C   SER   118       9.837  27.657  20.022  1.00 16.27           C  
ATOM    835  O   SER   118       8.774  28.161  20.160  1.00 19.93           O  
ATOM    836  N   VAL   119      10.088  26.641  19.199  1.00 16.27           N  
ATOM    837  CA  VAL   119       9.084  25.896  18.460  1.00 13.82           C  
ATOM    838  CB  VAL   119       9.365  25.849  16.946  1.00 14.78           C  
ATOM    839  CG1 VAL   119       8.351  24.907  16.193  1.00  8.31           C  
ATOM    840  CG2 VAL   119       9.361  27.300  16.359  1.00  9.89           C  
ATOM    841  C   VAL   119       8.942  24.519  19.088  1.00 15.59           C  
ATOM    842  O   VAL   119       9.915  23.853  19.310  1.00 15.06           O  
ATOM    843  N   GLY   120       7.679  24.167  19.408  1.00 15.45           N  
ATOM    844  CA  GLY   120       7.387  23.160  20.340  1.00 16.69           C  
ATOM    845  C   GLY   120       8.176  21.948  19.905  1.00 18.23           C  
ATOM    846  O   GLY   120       8.964  21.418  20.708  1.00 20.27           O  
ATOM    847  N   GLY   121       7.956  21.514  18.642  1.00 17.18           N  
ATOM    848  CA  GLY   121       8.465  20.259  18.062  1.00 14.00           C  
ATOM    849  C   GLY   121       9.957  20.166  18.011  1.00 14.68           C  
ATOM    850  O   GLY   121      10.486  19.049  18.092  1.00 15.91           O  
ATOM    851  N   GLU   122      10.631  21.300  17.867  1.00 12.64           N  
ATOM    852  CA  GLU   122      12.102  21.387  18.043  1.00 15.75           C  
ATOM    853  CB  GLU   122      12.629  22.812  17.811  1.00 11.87           C  
ATOM    854  CG  GLU   122      12.345  23.334  16.464  1.00 14.03           C  
ATOM    855  CD  GLU   122      12.839  24.794  16.282  1.00 20.32           C  
ATOM    856  OE1 GLU   122      13.080  25.492  17.313  1.00 19.47           O  
ATOM    857  OE2 GLU   122      13.003  25.237  15.084  1.00 25.71           O  
ATOM    858  C   GLU   122      12.574  21.032  19.420  1.00 15.49           C  
ATOM    859  O   GLU   122      13.510  20.282  19.609  1.00 16.98           O  
ATOM    860  N   TYR   123      11.929  21.618  20.404  1.00 16.30           N  
ATOM    861  CA  TYR   123      12.206  21.201  21.762  1.00 15.43           C  
ATOM    862  CB  TYR   123      11.367  22.039  22.714  1.00 16.38           C  
ATOM    863  CG  TYR   123      11.788  21.835  24.120  1.00 16.07           C  
ATOM    864  CD1 TYR   123      12.901  22.435  24.598  1.00 15.49           C  
ATOM    865  CE1 TYR   123      13.321  22.232  25.929  1.00 19.45           C  
ATOM    866  CZ  TYR   123      12.607  21.400  26.760  1.00 16.23           C  
ATOM    867  OH  TYR   123      13.029  21.228  28.042  1.00 17.35           O  
ATOM    868  CE2 TYR   123      11.451  20.786  26.305  1.00 16.29           C  
ATOM    869  CD2 TYR   123      11.054  20.995  24.970  1.00 16.54           C  
ATOM    870  C   TYR   123      12.018  19.706  22.019  1.00 13.89           C  
ATOM    871  O   TYR   123      12.854  19.054  22.589  1.00 13.53           O  
ATOM    872  N   ALA   124      10.893  19.135  21.618  1.00 13.85           N  
ATOM    873  CA  ALA   124      10.664  17.698  21.851  1.00 12.51           C  
ATOM    874  CB  ALA   124       9.251  17.323  21.367  1.00 13.01           C  
ATOM    875  C   ALA   124      11.715  16.813  21.153  1.00 13.94           C  
ATOM    876  O   ALA   124      12.071  15.705  21.639  1.00 14.53           O  
ATOM    877  N   ASN   125      12.168  17.284  19.990  1.00 14.15           N  
ATOM    878  CA  ASN   125      13.077  16.585  19.125  1.00 14.44           C  
ATOM    879  CB  ASN   125      13.086  17.238  17.722  1.00 14.09           C  
ATOM    880  CG  ASN   125      12.038  16.581  16.752  1.00 21.07           C  
ATOM    881  OD1 ASN   125      11.484  15.501  17.037  1.00 20.17           O  
ATOM    882  ND2 ASN   125      11.804  17.223  15.577  1.00 22.67           N  
ATOM    883  C   ASN   125      14.464  16.678  19.719  1.00 14.47           C  
ATOM    884  O   ASN   125      15.260  15.754  19.612  1.00 15.58           O  
ATOM    885  N   TRP   126      14.784  17.826  20.278  1.00 14.60           N  
ATOM    886  CA  TRP   126      16.078  17.955  20.929  1.00 15.28           C  
ATOM    887  CB  TRP   126      16.285  19.394  21.284  1.00 12.16           C  
ATOM    888  CG  TRP   126      17.431  19.564  22.190  1.00 13.11           C  
ATOM    889  CD1 TRP   126      18.750  19.451  21.869  1.00 11.13           C  
ATOM    890  NE1 TRP   126      19.528  19.739  22.965  1.00 15.14           N  
ATOM    891  CE2 TRP   126      18.703  20.016  24.026  1.00 14.65           C  
ATOM    892  CD2 TRP   126      17.381  19.901  23.577  1.00 12.08           C  
ATOM    893  CE3 TRP   126      16.333  20.148  24.484  1.00 16.02           C  
ATOM    894  CZ3 TRP   126      16.634  20.443  25.781  1.00 12.31           C  
ATOM    895  CH2 TRP   126      17.976  20.548  26.201  1.00 14.89           C  
ATOM    896  CZ2 TRP   126      19.009  20.343  25.347  1.00 14.05           C  
ATOM    897  C   TRP   126      16.159  17.029  22.161  1.00 15.61           C  
ATOM    898  O   TRP   126      17.132  16.306  22.358  1.00 18.88           O  
ATOM    899  N   LEU   127      15.115  16.987  22.965  1.00 16.22           N  
ATOM    900  CA  LEU   127      15.132  16.101  24.094  1.00 15.64           C  
ATOM    901  CB  LEU   127      13.843  16.208  24.864  1.00 15.94           C  
ATOM    902  CG  LEU   127      13.773  17.319  25.868  1.00 17.47           C  
ATOM    903  CD1 LEU   127      12.303  17.328  26.334  1.00 20.47           C  
ATOM    904  CD2 LEU   127      14.644  16.961  27.022  1.00 13.54           C  
ATOM    905  C   LEU   127      15.229  14.708  23.661  1.00 16.81           C  
ATOM    906  O   LEU   127      16.055  13.983  24.202  1.00 17.88           O  
ATOM    907  N   ASN   128      14.360  14.262  22.746  1.00 16.02           N  
ATOM    908  CA  ASN   128      14.436  12.858  22.319  1.00 17.58           C  
ATOM    909  CB  ASN   128      13.314  12.495  21.357  1.00 17.78           C  
ATOM    910  CG  ASN   128      11.937  12.828  21.916  1.00 22.92           C  
ATOM    911  OD1 ASN   128      11.699  12.772  23.126  1.00 25.33           O  
ATOM    912  ND2 ASN   128      11.014  13.187  21.030  1.00 29.82           N  
ATOM    913  C   ASN   128      15.769  12.405  21.739  1.00 17.84           C  
ATOM    914  O   ASN   128      16.188  11.266  21.908  1.00 19.12           O  
ATOM    915  N   LYS   129      16.445  13.298  21.035  1.00 19.51           N  
ATOM    916  CA  LYS   129      17.692  12.910  20.408  1.00 19.48           C  
ATOM    917  CB  LYS   129      18.081  13.913  19.346  1.00 20.26           C  
ATOM    918  CG  LYS   129      19.414  13.588  18.664  1.00 21.78           C  
ATOM    919  CD  LYS   129      19.190  12.721  17.385  1.00 27.59           C  
ATOM    920  CE  LYS   129      20.441  11.828  17.201  1.00 30.64           C  
ATOM    921  NZ  LYS   129      20.401  11.136  15.856  1.00 33.95           N  
ATOM    922  C   LYS   129      18.809  12.747  21.416  1.00 19.18           C  
ATOM    923  O   LYS   129      19.707  11.937  21.227  1.00 19.20           O  
ATOM    924  N   ALA   130      18.767  13.574  22.449  1.00 20.02           N  
ATOM    925  CA  ALA   130      19.708  13.568  23.554  1.00 20.13           C  
ATOM    926  CB  ALA   130      19.414  14.706  24.495  1.00 19.64           C  
ATOM    927  C   ALA   130      19.562  12.237  24.271  1.00 21.11           C  
ATOM    928  O   ALA   130      20.533  11.502  24.488  1.00 22.72           O  
ATOM    929  N   ILE   131      18.345  11.894  24.619  1.00 21.52           N  
ATOM    930  CA  ILE   131      18.102  10.614  25.248  1.00 22.82           C  
ATOM    931  CB  ILE   131      16.631  10.528  25.537  1.00 22.98           C  
ATOM    932  CG1 ILE   131      16.396  11.404  26.767  1.00 27.62           C  
ATOM    933  CD1 ILE   131      15.067  12.122  26.740  1.00 34.83           C  
ATOM    934  CG2 ILE   131      16.145   9.072  25.644  1.00 21.71           C  
ATOM    935  C   ILE   131      18.569   9.486  24.352  1.00 23.21           C  
ATOM    936  O   ILE   131      19.058   8.481  24.796  1.00 22.74           O  
ATOM    937  N   GLU   132      18.429   9.658  23.054  1.00 24.60           N  
ATOM    938  CA  GLU   132      18.835   8.588  22.169  1.00 24.37           C  
ATOM    939  CB  GLU   132      18.042   8.714  20.878  1.00 25.81           C  
ATOM    940  CG  GLU   132      18.554   7.818  19.734  1.00 35.33           C  
ATOM    941  CD  GLU   132      18.513   8.516  18.357  1.00 43.54           C  
ATOM    942  OE1 GLU   132      17.449   9.139  18.028  1.00 45.27           O  
ATOM    943  OE2 GLU   132      19.561   8.442  17.639  1.00 47.03           O  
ATOM    944  C   GLU   132      20.370   8.574  21.984  1.00 21.86           C  
ATOM    945  O   GLU   132      20.975   7.520  21.946  1.00 21.77           O  
ATOM    946  N   ILE   133      21.018   9.731  21.935  1.00 19.79           N  
ATOM    947  CA  ILE   133      22.458   9.795  21.961  1.00 18.10           C  
ATOM    948  CB  ILE   133      22.912  11.272  21.930  1.00 19.34           C  
ATOM    949  CG1 ILE   133      22.800  11.863  20.515  1.00 19.81           C  
ATOM    950  CD1 ILE   133      23.852  11.401  19.558  1.00 14.42           C  
ATOM    951  CG2 ILE   133      24.341  11.447  22.330  1.00 19.41           C  
ATOM    952  C   ILE   133      23.033   9.070  23.217  1.00 19.24           C  
ATOM    953  O   ILE   133      24.218   8.662  23.211  1.00 19.36           O  
ATOM    954  N   ASN   134      22.225   8.886  24.288  1.00 17.13           N  
ATOM    955  CA  ASN   134      22.755   8.298  25.497  1.00 16.69           C  
ATOM    956  CB  ASN   134      22.278   9.040  26.772  1.00 14.46           C  
ATOM    957  CG  ASN   134      23.027  10.305  27.045  1.00 13.06           C  
ATOM    958  OD1 ASN   134      24.174  10.339  27.526  1.00  9.50           O  
ATOM    959  ND2 ASN   134      22.384  11.394  26.738  1.00 10.02           N  
ATOM    960  C   ASN   134      22.468   6.772  25.579  1.00 17.41           C  
ATOM    961  O   ASN   134      22.554   6.228  26.626  1.00 18.12           O  
ATOM    962  N   GLY   135      22.150   6.106  24.475  1.00 18.71           N  
ATOM    963  CA  GLY   135      21.886   4.666  24.393  1.00 20.20           C  
ATOM    964  C   GLY   135      20.513   4.287  24.893  1.00 22.51           C  
ATOM    965  O   GLY   135      20.181   3.132  24.901  1.00 23.03           O  
ATOM    966  N   PHE   136      19.696   5.230  25.332  1.00 25.31           N  
ATOM    967  CA  PHE   136      18.362   4.863  25.833  1.00 28.47           C  
ATOM    968  CB  PHE   136      17.843   5.850  26.837  1.00 26.84           C  
ATOM    969  CG  PHE   136      18.691   5.958  28.042  1.00 25.32           C  
ATOM    970  CD1 PHE   136      18.764   4.904  28.938  1.00 24.90           C  
ATOM    971  CE1 PHE   136      19.557   5.002  30.043  1.00 25.29           C  
ATOM    972  CZ  PHE   136      20.289   6.187  30.249  1.00 25.56           C  
ATOM    973  CE2 PHE   136      20.207   7.229  29.357  1.00 23.45           C  
ATOM    974  CD2 PHE   136      19.444   7.096  28.264  1.00 23.61           C  
ATOM    975  C   PHE   136      17.344   4.740  24.739  1.00 32.43           C  
ATOM    976  O   PHE   136      16.962   5.729  24.089  1.00 34.00           O  
ATOM    977  N   ASP   137      16.873   3.519  24.551  1.00 36.29           N  
ATOM    978  CA  ASP   137      15.985   3.202  23.433  1.00 39.70           C  
ATOM    979  CB  ASP   137      14.639   3.981  23.521  1.00 41.05           C  
ATOM    980  CG  ASP   137      13.510   3.315  22.694  1.00 46.24           C  
ATOM    981  OD1 ASP   137      13.565   2.067  22.529  1.00 50.49           O  
ATOM    982  OD2 ASP   137      12.575   4.032  22.201  1.00 53.64           O  
ATOM    983  C   ASP   137      16.743   3.382  22.078  1.00 40.01           C  
ATOM    984  O   ASP   137      17.027   2.342  21.447  1.00 40.81           O  
ATOM    985  OXT ASP   137      17.121   4.487  21.606  1.00 40.01           O  
END
