
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   70 ( 1098),  selected   70 , name 2js4_A
# Molecule2: number of CA atoms   69 ( 1087),  selected   69 , name T0464.pdb
# PARAMETERS: 2js4_A.T0464.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    R     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    I     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    V    10_A      -       -           -
LGA    C    11_A      -       -           -
LGA    P    12_A      -       -           -
LGA    V    13_A      -       -           -
LGA    C    14_A      -       -           -
LGA    K    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    R    17_A      L      18          3.738
LGA    L    18_A      S      19          1.479
LGA    E    19_A      L      20          3.758
LGA    F    20_A      L      21          2.840
LGA    Q    21_A      E      22          2.658
LGA    -       -      S      23           -
LGA    -       -      K      24           -
LGA    -       -      G      25           -
LGA    R    22_A      L      26          4.732
LGA    A    23_A      E      27          3.548
LGA    -       -      A      28           -
LGA    -       -      L      29           -
LGA    -       -      N      30           -
LGA    -       -      K      31           -
LGA    -       -      A      32           -
LGA    -       -      I      33           -
LGA    -       -      V      34           -
LGA    -       -      S      35           -
LGA    -       -      G      36           -
LGA    -       -      T      37           -
LGA    -       -      V      38           -
LGA    -       -      Q      39           -
LGA    -       -      R      40           -
LGA    -       -      A      41           -
LGA    -       -      D      42           -
LGA    -       -      G      43           -
LGA    -       -      S      44           -
LGA    -       -      I      45           -
LGA    -       -      Q      46           -
LGA    -       -      N      47           -
LGA    -       -      Q      48           -
LGA    -       -      S      49           -
LGA    -       -      L      50           -
LGA    Q    24_A      H      51          4.400
LGA    A    25_A      E      52          1.264
LGA    E    26_A      A      53          1.305
LGA    L    27_A      L      54          0.967
LGA    V    28_A      I      55          0.662
LGA    C    29_A      T      56          0.516
LGA    N    30_A      R      57          1.919
LGA    A    31_A      D      58          1.221
LGA    D    32_A      R      59          4.915
LGA    R    33_A      K      60          1.097
LGA    L    34_A      Q      61          0.802
LGA    A    35_A      V      62          0.939
LGA    F    36_A      F      63          1.050
LGA    P    37_A      R      64          1.331
LGA    V    38_A      I      65          0.901
LGA    R    39_A      E      66          1.458
LGA    D    40_A      D      67          2.778
LGA    G    41_A      S      68          1.640
LGA    V    42_A      I      69          2.255
LGA    P    43_A      P      70          1.987
LGA    I    44_A      V      71          1.328
LGA    M    45_A      L      72          0.539
LGA    L    46_A      L      73          1.397
LGA    E    47_A      P      74          2.757
LGA    A    48_A      E      75          2.591
LGA    E    49_A      E      76          1.717
LGA    A    50_A      A      77          1.586
LGA    R    51_A      I      78          1.632
LGA    S    52_A      A      79          2.082
LGA    L    53_A      T      80          0.964
LGA    D    54_A      I      81          1.182
LGA    A    55_A      Q      82          2.439
LGA    E    56_A      I      83          4.706
LGA    A    57_A      A      84           -
LGA    P    58_A      N      85           -
LGA    A    59_A      F      86           -
LGA    Q    60_A      -       -           -
LGA    P    61_A      -       -           -
LGA    S    62_A      -       -           -
LGA    L    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    H    65_A      -       -           -
LGA    H    66_A      -       -           -
LGA    H    67_A      -       -           -
LGA    H    68_A      -       -           -
LGA    H    69_A      -       -           -
LGA    H    70_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   70   69    5.0     40    2.36    17.50     45.383     1.625

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.824958 * X  +   0.173806 * Y  +  -0.537807 * Z  +  -3.427848
  Y_new =   0.565181 * X  +  -0.247072 * Y  +   0.787100 * Z  +  -1.925311
  Z_new =   0.003926 * X  +  -0.953282 * Y  +  -0.302056 * Z  +   3.066514 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.877648    1.263945  [ DEG:  -107.5813     72.4187 ]
  Theta =  -0.003926   -3.137667  [ DEG:    -0.2249   -179.7751 ]
  Phi   =   0.600658   -2.540935  [ DEG:    34.4152   -145.5848 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2js4_A                                        
REMARK     2: T0464.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2js4_A.T0464.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   70   69   5.0   40   2.36   17.50  45.383
REMARK  ---------------------------------------------------------- 
MOLECULE 2js4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   29-JUN-07   2JS4              
TITLE     SOLUTION NMR STRUCTURE OF BORDETELLA BRONCHISEPTICA PROTEIN           
TITLE    2 BB2007. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET              
TITLE    3 BOR54                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0434 PROTEIN BB2007;                                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BORDETELLA BRONCHISEPTICA;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RB50, NCTC 13252;                                            
SOURCE   5 ATCC: BAA-588;                                                       
SOURCE   6 GENE: BB2007;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: XL10;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    NESG, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, BETA, PSI-2,          
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE                                         
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.ELETSKY,D.SUKUMARAN,Y.WU,K.SINGARAPU,D.PARISH,D.XU,D.WANG,          
AUTHOR   2 C.NWOSU,K.CUNNINGHAM,R.XIAO,J.LIU,M.C.BARAN,G.V.T.SWAPNA,            
AUTHOR   3 T.B.ACTON,B.ROST,G.T.MONTELIONE,T.SZYPERSKI,NORTHEAST                
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   10-JUL-07 2JS4    0                                                
JRNL        AUTH   A.ELETSKY,T.SZYPERSKI                                        
JRNL        TITL   NMR SOLUTION STRUCTURE OF BORDETELLA                         
JRNL        TITL 2 BRONCHISEPTICA PROTEIN BB2007.                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JS4 A    1    62  UNP    Q7WKU6   Y2007_BORBR      1     62             
SEQRES   1 A   70  MET GLU SER ARG LEU LEU ASP ILE LEU VAL CYS PRO VAL          
SEQRES   2 A   70  CYS LYS GLY ARG LEU GLU PHE GLN ARG ALA GLN ALA GLU          
SEQRES   3 A   70  LEU VAL CYS ASN ALA ASP ARG LEU ALA PHE PRO VAL ARG          
SEQRES   4 A   70  ASP GLY VAL PRO ILE MET LEU GLU ALA GLU ALA ARG SER          
SEQRES   5 A   70  LEU ASP ALA GLU ALA PRO ALA GLN PRO SER LEU GLU HIS          
SEQRES   6 A   70  HIS HIS HIS HIS HIS                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1     -16.456 -33.132  11.104  1.00  0.00           N  
ATOM      2  CA  MET A   1     -15.090 -32.802  10.648  1.00  0.00           C  
ATOM      3  C   MET A   1     -14.555 -31.620  11.431  1.00  0.00           C  
ATOM      4  O   MET A   1     -15.307 -30.711  11.786  1.00  0.00           O  
ATOM      5  CB  MET A   1     -15.086 -32.473   9.151  1.00  0.00           C  
ATOM      6  CG  MET A   1     -15.447 -33.655   8.265  1.00  0.00           C  
ATOM      7  SD  MET A   1     -15.486 -33.222   6.513  1.00  0.00           S  
ATOM      8  CE  MET A   1     -15.894 -34.806   5.787  1.00  0.00           C  
ATOM      9  H2  MET A   1     -16.788 -34.006  10.646  1.00  0.00           H  
ATOM     10  HA  MET A   1     -14.454 -33.657  10.826  1.00  0.00           H  
ATOM     11  HB2 MET A   1     -15.798 -31.681   8.967  1.00  0.00           H  
ATOM     12  HB3 MET A   1     -14.102 -32.132   8.873  1.00  0.00           H  
ATOM     13  HG2 MET A   1     -14.714 -34.436   8.412  1.00  0.00           H  
ATOM     14  HG3 MET A   1     -16.423 -34.019   8.552  1.00  0.00           H  
ATOM     15  HE1 MET A   1     -16.848 -35.141   6.166  1.00  0.00           H  
ATOM     16  HE2 MET A   1     -15.130 -35.527   6.043  1.00  0.00           H  
ATOM     17  HE3 MET A   1     -15.951 -34.702   4.713  1.00  0.00           H  
ATOM     18  H1  MET A   1     -16.461 -33.279  12.134  1.00  0.00           H  
ATOM     19  H3  MET A   1     -17.113 -32.355  10.875  1.00  0.00           H  
ATOM     20  N   GLU A   2     -13.262 -31.642  11.707  1.00  0.00           N  
ATOM     21  CA  GLU A   2     -12.624 -30.575  12.459  1.00  0.00           C  
ATOM     22  C   GLU A   2     -11.772 -29.724  11.532  1.00  0.00           C  
ATOM     23  O   GLU A   2     -10.927 -30.241  10.799  1.00  0.00           O  
ATOM     24  CB  GLU A   2     -11.757 -31.142  13.587  1.00  0.00           C  
ATOM     25  CG  GLU A   2     -12.496 -32.100  14.507  1.00  0.00           C  
ATOM     26  CD  GLU A   2     -13.779 -31.518  15.060  1.00  0.00           C  
ATOM     27  OE1 GLU A   2     -13.712 -30.563  15.859  1.00  0.00           O  
ATOM     28  OE2 GLU A   2     -14.861 -32.030  14.711  1.00  0.00           O  
ATOM     29  H   GLU A   2     -12.712 -32.394  11.379  1.00  0.00           H  
ATOM     30  HA  GLU A   2     -13.402 -29.958  12.887  1.00  0.00           H  
ATOM     31  HB2 GLU A   2     -10.920 -31.670  13.153  1.00  0.00           H  
ATOM     32  HB3 GLU A   2     -11.384 -30.323  14.183  1.00  0.00           H  
ATOM     33  HG2 GLU A   2     -12.736 -32.996  13.956  1.00  0.00           H  
ATOM     34  HG3 GLU A   2     -11.847 -32.354  15.335  1.00  0.00           H  
ATOM     35  N   SER A   3     -11.999 -28.422  11.560  1.00  0.00           N  
ATOM     36  CA  SER A   3     -11.261 -27.508  10.708  1.00  0.00           C  
ATOM     37  C   SER A   3     -10.144 -26.837  11.497  1.00  0.00           C  
ATOM     38  O   SER A   3     -10.314 -26.512  12.675  1.00  0.00           O  
ATOM     39  CB  SER A   3     -12.210 -26.457  10.121  1.00  0.00           C  
ATOM     40  OG  SER A   3     -11.553 -25.650   9.159  1.00  0.00           O  
ATOM     41  H   SER A   3     -12.675 -28.064  12.175  1.00  0.00           H  
ATOM     42  HA  SER A   3     -10.826 -28.081   9.904  1.00  0.00           H  
ATOM     43  HB2 SER A   3     -13.044 -26.955   9.645  1.00  0.00           H  
ATOM     44  HB3 SER A   3     -12.576 -25.824  10.915  1.00  0.00           H  
ATOM     45  HG  SER A   3     -12.205 -25.258   8.569  1.00  0.00           H  
ATOM     46  N   ARG A   4      -8.996 -26.663  10.856  1.00  0.00           N  
ATOM     47  CA  ARG A   4      -7.867 -25.984  11.475  1.00  0.00           C  
ATOM     48  C   ARG A   4      -7.673 -24.623  10.809  1.00  0.00           C  
ATOM     49  O   ARG A   4      -8.299 -23.638  11.211  1.00  0.00           O  
ATOM     50  CB  ARG A   4      -6.597 -26.842  11.357  1.00  0.00           C  
ATOM     51  CG  ARG A   4      -6.800 -28.276  11.827  1.00  0.00           C  
ATOM     52  CD  ARG A   4      -5.552 -29.129  11.661  1.00  0.00           C  
ATOM     53  NE  ARG A   4      -5.846 -30.546  11.883  1.00  0.00           N  
ATOM     54  CZ  ARG A   4      -4.929 -31.513  11.973  1.00  0.00           C  
ATOM     55  NH1 ARG A   4      -3.634 -31.234  11.865  1.00  0.00           N  
ATOM     56  NH2 ARG A   4      -5.315 -32.767  12.160  1.00  0.00           N  
ATOM     57  H   ARG A   4      -8.909 -26.991   9.935  1.00  0.00           H  
ATOM     58  HA  ARG A   4      -8.101 -25.833  12.519  1.00  0.00           H  
ATOM     59  HB2 ARG A   4      -6.281 -26.863  10.324  1.00  0.00           H  
ATOM     60  HB3 ARG A   4      -5.814 -26.395  11.956  1.00  0.00           H  
ATOM     61  HG2 ARG A   4      -7.073 -28.265  12.872  1.00  0.00           H  
ATOM     62  HG3 ARG A   4      -7.604 -28.717  11.254  1.00  0.00           H  
ATOM     63  HD2 ARG A   4      -5.171 -29.001  10.659  1.00  0.00           H  
ATOM     64  HD3 ARG A   4      -4.810 -28.806  12.374  1.00  0.00           H  
ATOM     65  HE  ARG A   4      -6.799 -30.794  11.963  1.00  0.00           H  
ATOM     66 HH11 ARG A   4      -3.327 -30.286  11.714  1.00  0.00           H  
ATOM     67 HH12 ARG A   4      -2.951 -31.970  11.940  1.00  0.00           H  
ATOM     68 HH21 ARG A   4      -6.295 -32.988  12.239  1.00  0.00           H  
ATOM     69 HH22 ARG A   4      -4.632 -33.509  12.223  1.00  0.00           H  
ATOM     70  N   LEU A   5      -6.826 -24.596   9.777  1.00  0.00           N  
ATOM     71  CA  LEU A   5      -6.652 -23.428   8.904  1.00  0.00           C  
ATOM     72  C   LEU A   5      -6.046 -22.213   9.610  1.00  0.00           C  
ATOM     73  O   LEU A   5      -6.249 -21.981  10.799  1.00  0.00           O  
ATOM     74  CB  LEU A   5      -7.984 -23.027   8.247  1.00  0.00           C  
ATOM     75  CG  LEU A   5      -8.416 -23.865   7.035  1.00  0.00           C  
ATOM     76  CD1 LEU A   5      -8.714 -25.307   7.424  1.00  0.00           C  
ATOM     77  CD2 LEU A   5      -9.625 -23.237   6.360  1.00  0.00           C  
ATOM     78  H   LEU A   5      -6.296 -25.396   9.588  1.00  0.00           H  
ATOM     79  HA  LEU A   5      -5.973 -23.724   8.119  1.00  0.00           H  
ATOM     80  HB2 LEU A   5      -8.762 -23.096   8.996  1.00  0.00           H  
ATOM     81  HB3 LEU A   5      -7.905 -21.998   7.933  1.00  0.00           H  
ATOM     82  HG  LEU A   5      -7.608 -23.880   6.316  1.00  0.00           H  
ATOM     83 HD11 LEU A   5      -9.516 -25.327   8.144  1.00  0.00           H  
ATOM     84 HD12 LEU A   5      -7.832 -25.753   7.856  1.00  0.00           H  
ATOM     85 HD13 LEU A   5      -9.005 -25.863   6.546  1.00  0.00           H  
ATOM     86 HD21 LEU A   5     -10.457 -23.220   7.050  1.00  0.00           H  
ATOM     87 HD22 LEU A   5      -9.893 -23.817   5.488  1.00  0.00           H  
ATOM     88 HD23 LEU A   5      -9.387 -22.228   6.060  1.00  0.00           H  
ATOM     89  N   LEU A   6      -5.272 -21.454   8.848  1.00  0.00           N  
ATOM     90  CA  LEU A   6      -4.797 -20.144   9.277  1.00  0.00           C  
ATOM     91  C   LEU A   6      -5.362 -19.097   8.325  1.00  0.00           C  
ATOM     92  O   LEU A   6      -4.870 -17.974   8.230  1.00  0.00           O  
ATOM     93  CB  LEU A   6      -3.259 -20.074   9.281  1.00  0.00           C  
ATOM     94  CG  LEU A   6      -2.544 -20.825  10.417  1.00  0.00           C  
ATOM     95  CD1 LEU A   6      -3.140 -20.449  11.768  1.00  0.00           C  
ATOM     96  CD2 LEU A   6      -2.590 -22.331  10.199  1.00  0.00           C  
ATOM     97  H   LEU A   6      -5.005 -21.785   7.962  1.00  0.00           H  
ATOM     98  HA  LEU A   6      -5.170 -19.958  10.275  1.00  0.00           H  
ATOM     99  HB2 LEU A   6      -2.903 -20.471   8.340  1.00  0.00           H  
ATOM    100  HB3 LEU A   6      -2.975 -19.034   9.338  1.00  0.00           H  
ATOM    101  HG  LEU A   6      -1.504 -20.527  10.427  1.00  0.00           H  
ATOM    102 HD11 LEU A   6      -3.003 -19.391  11.938  1.00  0.00           H  
ATOM    103 HD12 LEU A   6      -2.647 -21.006  12.551  1.00  0.00           H  
ATOM    104 HD13 LEU A   6      -4.197 -20.677  11.771  1.00  0.00           H  
ATOM    105 HD21 LEU A   6      -2.112 -22.572   9.261  1.00  0.00           H  
ATOM    106 HD22 LEU A   6      -3.619 -22.659  10.171  1.00  0.00           H  
ATOM    107 HD23 LEU A   6      -2.074 -22.831  11.006  1.00  0.00           H  
ATOM    108  N   ASP A   7      -6.419 -19.490   7.626  1.00  0.00           N  
ATOM    109  CA  ASP A   7      -7.011 -18.674   6.580  1.00  0.00           C  
ATOM    110  C   ASP A   7      -8.195 -17.885   7.127  1.00  0.00           C  
ATOM    111  O   ASP A   7      -9.306 -18.407   7.243  1.00  0.00           O  
ATOM    112  CB  ASP A   7      -7.453 -19.565   5.417  1.00  0.00           C  
ATOM    113  CG  ASP A   7      -7.968 -18.779   4.231  1.00  0.00           C  
ATOM    114  OD1 ASP A   7      -7.249 -17.878   3.761  1.00  0.00           O  
ATOM    115  OD2 ASP A   7      -9.078 -19.085   3.750  1.00  0.00           O  
ATOM    116  H   ASP A   7      -6.826 -20.351   7.836  1.00  0.00           H  
ATOM    117  HA  ASP A   7      -6.259 -17.983   6.231  1.00  0.00           H  
ATOM    118  HB2 ASP A   7      -6.611 -20.162   5.089  1.00  0.00           H  
ATOM    119  HB3 ASP A   7      -8.238 -20.223   5.757  1.00  0.00           H  
ATOM    120  N   ILE A   8      -7.936 -16.645   7.505  1.00  0.00           N  
ATOM    121  CA  ILE A   8      -8.971 -15.783   8.071  1.00  0.00           C  
ATOM    122  C   ILE A   8      -9.508 -14.771   7.056  1.00  0.00           C  
ATOM    123  O   ILE A   8     -10.720 -14.575   6.955  1.00  0.00           O  
ATOM    124  CB  ILE A   8      -8.464 -15.026   9.318  1.00  0.00           C  
ATOM    125  CG1 ILE A   8      -7.100 -14.376   9.047  1.00  0.00           C  
ATOM    126  CG2 ILE A   8      -8.388 -15.961  10.515  1.00  0.00           C  
ATOM    127  CD1 ILE A   8      -6.586 -13.534  10.195  1.00  0.00           C  
ATOM    128  H   ILE A   8      -7.022 -16.308   7.422  1.00  0.00           H  
ATOM    129  HA  ILE A   8      -9.786 -16.419   8.381  1.00  0.00           H  
ATOM    130  HB  ILE A   8      -9.178 -14.251   9.548  1.00  0.00           H  
ATOM    131 HG12 ILE A   8      -6.375 -15.151   8.857  1.00  0.00           H  
ATOM    132 HG13 ILE A   8      -7.178 -13.740   8.178  1.00  0.00           H  
ATOM    133 HG21 ILE A   8      -9.370 -16.361  10.721  1.00  0.00           H  
ATOM    134 HG22 ILE A   8      -8.034 -15.414  11.377  1.00  0.00           H  
ATOM    135 HG23 ILE A   8      -7.706 -16.772  10.299  1.00  0.00           H  
ATOM    136 HD11 ILE A   8      -6.474 -14.153  11.073  1.00  0.00           H  
ATOM    137 HD12 ILE A   8      -7.288 -12.739  10.401  1.00  0.00           H  
ATOM    138 HD13 ILE A   8      -5.628 -13.110   9.928  1.00  0.00           H  
ATOM    139  N   LEU A   9      -8.615 -14.135   6.304  1.00  0.00           N  
ATOM    140  CA  LEU A   9      -9.012 -13.052   5.410  1.00  0.00           C  
ATOM    141  C   LEU A   9      -8.560 -13.300   3.976  1.00  0.00           C  
ATOM    142  O   LEU A   9      -7.363 -13.393   3.692  1.00  0.00           O  
ATOM    143  CB  LEU A   9      -8.453 -11.709   5.896  1.00  0.00           C  
ATOM    144  CG  LEU A   9      -9.440 -10.815   6.658  1.00  0.00           C  
ATOM    145  CD1 LEU A   9     -10.704 -10.587   5.838  1.00  0.00           C  
ATOM    146  CD2 LEU A   9      -9.781 -11.402   8.018  1.00  0.00           C  
ATOM    147  H   LEU A   9      -7.677 -14.408   6.337  1.00  0.00           H  
ATOM    148  HA  LEU A   9     -10.090 -12.998   5.423  1.00  0.00           H  
ATOM    149  HB2 LEU A   9      -7.608 -11.910   6.541  1.00  0.00           H  
ATOM    150  HB3 LEU A   9      -8.099 -11.162   5.034  1.00  0.00           H  
ATOM    151  HG  LEU A   9      -8.980  -9.850   6.822  1.00  0.00           H  
ATOM    152 HD11 LEU A   9     -11.391  -9.968   6.397  1.00  0.00           H  
ATOM    153 HD12 LEU A   9     -11.170 -11.537   5.624  1.00  0.00           H  
ATOM    154 HD13 LEU A   9     -10.449 -10.095   4.911  1.00  0.00           H  
ATOM    155 HD21 LEU A   9      -8.884 -11.474   8.615  1.00  0.00           H  
ATOM    156 HD22 LEU A   9     -10.206 -12.387   7.887  1.00  0.00           H  
ATOM    157 HD23 LEU A   9     -10.495 -10.764   8.516  1.00  0.00           H  
ATOM    158  N   VAL A  10      -9.528 -13.406   3.085  1.00  0.00           N  
ATOM    159  CA  VAL A  10      -9.256 -13.487   1.660  1.00  0.00           C  
ATOM    160  C   VAL A  10      -9.763 -12.228   0.967  1.00  0.00           C  
ATOM    161  O   VAL A  10     -10.655 -11.550   1.479  1.00  0.00           O  
ATOM    162  CB  VAL A  10      -9.914 -14.727   1.010  1.00  0.00           C  
ATOM    163  CG1 VAL A  10      -9.277 -16.008   1.528  1.00  0.00           C  
ATOM    164  CG2 VAL A  10     -11.420 -14.738   1.250  1.00  0.00           C  
ATOM    165  H   VAL A  10     -10.458 -13.420   3.392  1.00  0.00           H  
ATOM    166  HA  VAL A  10      -8.187 -13.556   1.527  1.00  0.00           H  
ATOM    167  HB  VAL A  10      -9.742 -14.678  -0.056  1.00  0.00           H  
ATOM    168 HG11 VAL A  10      -9.426 -16.078   2.597  1.00  0.00           H  
ATOM    169 HG12 VAL A  10      -8.218 -15.994   1.314  1.00  0.00           H  
ATOM    170 HG13 VAL A  10      -9.732 -16.858   1.044  1.00  0.00           H  
ATOM    171 HG21 VAL A  10     -11.859 -13.853   0.815  1.00  0.00           H  
ATOM    172 HG22 VAL A  10     -11.616 -14.752   2.312  1.00  0.00           H  
ATOM    173 HG23 VAL A  10     -11.854 -15.617   0.795  1.00  0.00           H  
ATOM    174  N   CYS A  11      -9.184 -11.914  -0.185  1.00  0.00           N  
ATOM    175  CA  CYS A  11      -9.607 -10.761  -0.972  1.00  0.00           C  
ATOM    176  C   CYS A  11     -11.094 -10.854  -1.301  1.00  0.00           C  
ATOM    177  O   CYS A  11     -11.559 -11.870  -1.815  1.00  0.00           O  
ATOM    178  CB  CYS A  11      -8.786 -10.683  -2.263  1.00  0.00           C  
ATOM    179  SG  CYS A  11      -9.280  -9.355  -3.388  1.00  0.00           S  
ATOM    180  H   CYS A  11      -8.446 -12.476  -0.520  1.00  0.00           H  
ATOM    181  HA  CYS A  11      -9.431  -9.872  -0.382  1.00  0.00           H  
ATOM    182  HB2 CYS A  11      -7.749 -10.529  -2.011  1.00  0.00           H  
ATOM    183  HB3 CYS A  11      -8.886 -11.618  -2.797  1.00  0.00           H  
ATOM    184  HG  CYS A  11      -8.178  -8.767  -3.845  1.00  0.00           H  
ATOM    185  N   PRO A  12     -11.862  -9.799  -1.002  1.00  0.00           N  
ATOM    186  CA  PRO A  12     -13.313  -9.783  -1.234  1.00  0.00           C  
ATOM    187  C   PRO A  12     -13.673  -9.780  -2.721  1.00  0.00           C  
ATOM    188  O   PRO A  12     -14.832  -9.975  -3.090  1.00  0.00           O  
ATOM    189  CB  PRO A  12     -13.766  -8.480  -0.570  1.00  0.00           C  
ATOM    190  CG  PRO A  12     -12.553  -7.612  -0.560  1.00  0.00           C  
ATOM    191  CD  PRO A  12     -11.380  -8.537  -0.407  1.00  0.00           C  
ATOM    192  HA  PRO A  12     -13.800 -10.619  -0.755  1.00  0.00           H  
ATOM    193  HB2 PRO A  12     -14.564  -8.037  -1.146  1.00  0.00           H  
ATOM    194  HB3 PRO A  12     -14.109  -8.686   0.432  1.00  0.00           H  
ATOM    195  HG2 PRO A  12     -12.481  -7.068  -1.490  1.00  0.00           H  
ATOM    196  HG3 PRO A  12     -12.598  -6.927   0.274  1.00  0.00           H  
ATOM    197  HD3 PRO A  12     -10.530  -8.158  -0.951  1.00  0.00           H  
ATOM    198  HD2 PRO A  12     -11.136  -8.668   0.636  1.00  0.00           H  
ATOM    199  N   VAL A  13     -12.679  -9.552  -3.569  1.00  0.00           N  
ATOM    200  CA  VAL A  13     -12.908  -9.499  -5.006  1.00  0.00           C  
ATOM    201  C   VAL A  13     -12.345 -10.735  -5.709  1.00  0.00           C  
ATOM    202  O   VAL A  13     -13.060 -11.425  -6.435  1.00  0.00           O  
ATOM    203  CB  VAL A  13     -12.282  -8.230  -5.630  1.00  0.00           C  
ATOM    204  CG1 VAL A  13     -12.604  -8.135  -7.113  1.00  0.00           C  
ATOM    205  CG2 VAL A  13     -12.754  -6.982  -4.899  1.00  0.00           C  
ATOM    206  H   VAL A  13     -11.775  -9.407  -3.218  1.00  0.00           H  
ATOM    207  HA  VAL A  13     -13.975  -9.464  -5.169  1.00  0.00           H  
ATOM    208  HB  VAL A  13     -11.209  -8.298  -5.522  1.00  0.00           H  
ATOM    209 HG11 VAL A  13     -12.138  -7.252  -7.524  1.00  0.00           H  
ATOM    210 HG12 VAL A  13     -13.674  -8.073  -7.245  1.00  0.00           H  
ATOM    211 HG13 VAL A  13     -12.228  -9.009  -7.621  1.00  0.00           H  
ATOM    212 HG21 VAL A  13     -12.292  -6.111  -5.342  1.00  0.00           H  
ATOM    213 HG22 VAL A  13     -12.476  -7.043  -3.857  1.00  0.00           H  
ATOM    214 HG23 VAL A  13     -13.828  -6.900  -4.982  1.00  0.00           H  
ATOM    215  N   CYS A  14     -11.069 -11.014  -5.483  1.00  0.00           N  
ATOM    216  CA  CYS A  14     -10.390 -12.103  -6.177  1.00  0.00           C  
ATOM    217  C   CYS A  14     -10.435 -13.397  -5.364  1.00  0.00           C  
ATOM    218  O   CYS A  14     -10.123 -14.470  -5.877  1.00  0.00           O  
ATOM    219  CB  CYS A  14      -8.939 -11.706  -6.459  1.00  0.00           C  
ATOM    220  SG  CYS A  14      -8.097 -12.754  -7.671  1.00  0.00           S  
ATOM    221  H   CYS A  14     -10.563 -10.463  -4.849  1.00  0.00           H  
ATOM    222  HA  CYS A  14     -10.895 -12.265  -7.115  1.00  0.00           H  
ATOM    223  HB2 CYS A  14      -8.919 -10.692  -6.833  1.00  0.00           H  
ATOM    224  HB3 CYS A  14      -8.377 -11.751  -5.537  1.00  0.00           H  
ATOM    225  HG  CYS A  14      -7.667 -11.960  -8.648  1.00  0.00           H  
ATOM    226  N   LYS A  15     -10.841 -13.284  -4.097  1.00  0.00           N  
ATOM    227  CA  LYS A  15     -10.891 -14.421  -3.170  1.00  0.00           C  
ATOM    228  C   LYS A  15      -9.517 -15.066  -2.969  1.00  0.00           C  
ATOM    229  O   LYS A  15      -9.412 -16.198  -2.499  1.00  0.00           O  
ATOM    230  CB  LYS A  15     -11.916 -15.450  -3.648  1.00  0.00           C  
ATOM    231  CG  LYS A  15     -13.334 -14.906  -3.660  1.00  0.00           C  
ATOM    232  CD  LYS A  15     -13.836 -14.619  -2.255  1.00  0.00           C  
ATOM    233  CE  LYS A  15     -15.234 -14.023  -2.276  1.00  0.00           C  
ATOM    234  NZ  LYS A  15     -15.784 -13.838  -0.906  1.00  0.00           N  
ATOM    235  H   LYS A  15     -11.150 -12.413  -3.779  1.00  0.00           H  
ATOM    236  HA  LYS A  15     -11.217 -14.037  -2.214  1.00  0.00           H  
ATOM    237  HB2 LYS A  15     -11.661 -15.763  -4.649  1.00  0.00           H  
ATOM    238  HB3 LYS A  15     -11.886 -16.305  -2.990  1.00  0.00           H  
ATOM    239  HG2 LYS A  15     -13.351 -13.988  -4.229  1.00  0.00           H  
ATOM    240  HG3 LYS A  15     -13.981 -15.628  -4.124  1.00  0.00           H  
ATOM    241  HD2 LYS A  15     -13.856 -15.540  -1.694  1.00  0.00           H  
ATOM    242  HD3 LYS A  15     -13.163 -13.919  -1.781  1.00  0.00           H  
ATOM    243  HE2 LYS A  15     -15.194 -13.064  -2.772  1.00  0.00           H  
ATOM    244  HE3 LYS A  15     -15.884 -14.686  -2.831  1.00  0.00           H  
ATOM    245  HZ1 LYS A  15     -15.130 -13.263  -0.330  1.00  0.00           H  
ATOM    246  HZ2 LYS A  15     -15.919 -14.762  -0.442  1.00  0.00           H  
ATOM    247  HZ3 LYS A  15     -16.703 -13.352  -0.954  1.00  0.00           H  
ATOM    248  N   GLY A  16      -8.470 -14.328  -3.305  1.00  0.00           N  
ATOM    249  CA  GLY A  16      -7.126 -14.787  -3.038  1.00  0.00           C  
ATOM    250  C   GLY A  16      -6.710 -14.426  -1.633  1.00  0.00           C  
ATOM    251  O   GLY A  16      -7.116 -13.384  -1.116  1.00  0.00           O  
ATOM    252  H   GLY A  16      -8.613 -13.463  -3.735  1.00  0.00           H  
ATOM    253  HA2 GLY A  16      -7.089 -15.861  -3.154  1.00  0.00           H  
ATOM    254  HA3 GLY A  16      -6.443 -14.328  -3.737  1.00  0.00           H  
ATOM    255  N   ARG A  17      -5.924 -15.285  -1.003  1.00  0.00           N  
ATOM    256  CA  ARG A  17      -5.501 -15.056   0.371  1.00  0.00           C  
ATOM    257  C   ARG A  17      -4.609 -13.821   0.461  1.00  0.00           C  
ATOM    258  O   ARG A  17      -3.742 -13.605  -0.390  1.00  0.00           O  
ATOM    259  CB  ARG A  17      -4.774 -16.289   0.913  1.00  0.00           C  
ATOM    260  CG  ARG A  17      -4.321 -16.153   2.358  1.00  0.00           C  
ATOM    261  CD  ARG A  17      -3.797 -17.474   2.892  1.00  0.00           C  
ATOM    262  NE  ARG A  17      -4.839 -18.499   2.899  1.00  0.00           N  
ATOM    263  CZ  ARG A  17      -4.663 -19.754   2.489  1.00  0.00           C  
ATOM    264  NH1 ARG A  17      -3.483 -20.147   2.025  1.00  0.00           N  
ATOM    265  NH2 ARG A  17      -5.678 -20.609   2.529  1.00  0.00           N  
ATOM    266  H   ARG A  17      -5.616 -16.094  -1.475  1.00  0.00           H  
ATOM    267  HA  ARG A  17      -6.389 -14.884   0.962  1.00  0.00           H  
ATOM    268  HB2 ARG A  17      -5.435 -17.141   0.844  1.00  0.00           H  
ATOM    269  HB3 ARG A  17      -3.902 -16.474   0.301  1.00  0.00           H  
ATOM    270  HG2 ARG A  17      -3.534 -15.414   2.412  1.00  0.00           H  
ATOM    271  HG3 ARG A  17      -5.159 -15.835   2.963  1.00  0.00           H  
ATOM    272  HD2 ARG A  17      -2.984 -17.804   2.263  1.00  0.00           H  
ATOM    273  HD3 ARG A  17      -3.438 -17.327   3.900  1.00  0.00           H  
ATOM    274  HE  ARG A  17      -5.739 -18.224   3.227  1.00  0.00           H  
ATOM    275 HH11 ARG A  17      -2.717 -19.503   1.988  1.00  0.00           H  
ATOM    276 HH12 ARG A  17      -3.358 -21.089   1.691  1.00  0.00           H  
ATOM    277 HH21 ARG A  17      -6.573 -20.308   2.867  1.00  0.00           H  
ATOM    278 HH22 ARG A  17      -5.559 -21.561   2.215  1.00  0.00           H  
ATOM    279  N   LEU A  18      -4.836 -13.013   1.488  1.00  0.00           N  
ATOM    280  CA  LEU A  18      -4.079 -11.787   1.676  1.00  0.00           C  
ATOM    281  C   LEU A  18      -2.688 -12.092   2.218  1.00  0.00           C  
ATOM    282  O   LEU A  18      -2.491 -13.069   2.943  1.00  0.00           O  
ATOM    283  CB  LEU A  18      -4.831 -10.842   2.618  1.00  0.00           C  
ATOM    284  CG  LEU A  18      -6.216 -10.414   2.126  1.00  0.00           C  
ATOM    285  CD1 LEU A  18      -6.905  -9.539   3.159  1.00  0.00           C  
ATOM    286  CD2 LEU A  18      -6.108  -9.685   0.795  1.00  0.00           C  
ATOM    287  H   LEU A  18      -5.526 -13.254   2.143  1.00  0.00           H  
ATOM    288  HA  LEU A  18      -3.975 -11.310   0.712  1.00  0.00           H  
ATOM    289  HB2 LEU A  18      -4.947 -11.336   3.572  1.00  0.00           H  
ATOM    290  HB3 LEU A  18      -4.235  -9.955   2.761  1.00  0.00           H  
ATOM    291  HG  LEU A  18      -6.825 -11.296   1.979  1.00  0.00           H  
ATOM    292 HD11 LEU A  18      -6.983 -10.077   4.091  1.00  0.00           H  
ATOM    293 HD12 LEU A  18      -7.893  -9.278   2.809  1.00  0.00           H  
ATOM    294 HD13 LEU A  18      -6.326  -8.639   3.309  1.00  0.00           H  
ATOM    295 HD21 LEU A  18      -5.441  -8.843   0.898  1.00  0.00           H  
ATOM    296 HD22 LEU A  18      -7.086  -9.336   0.495  1.00  0.00           H  
ATOM    297 HD23 LEU A  18      -5.722 -10.361   0.046  1.00  0.00           H  
ATOM    298  N   GLU A  19      -1.728 -11.257   1.855  1.00  0.00           N  
ATOM    299  CA  GLU A  19      -0.344 -11.456   2.247  1.00  0.00           C  
ATOM    300  C   GLU A  19       0.070 -10.340   3.192  1.00  0.00           C  
ATOM    301  O   GLU A  19       0.247  -9.191   2.785  1.00  0.00           O  
ATOM    302  CB  GLU A  19       0.537 -11.498   0.995  1.00  0.00           C  
ATOM    303  CG  GLU A  19       1.844 -12.261   1.154  1.00  0.00           C  
ATOM    304  CD  GLU A  19       2.967 -11.424   1.728  1.00  0.00           C  
ATOM    305  OE1 GLU A  19       3.533 -10.595   0.982  1.00  0.00           O  
ATOM    306  OE2 GLU A  19       3.312 -11.616   2.913  1.00  0.00           O  
ATOM    307  H   GLU A  19      -1.960 -10.473   1.309  1.00  0.00           H  
ATOM    308  HA  GLU A  19      -0.273 -12.402   2.763  1.00  0.00           H  
ATOM    309  HB2 GLU A  19      -0.024 -11.964   0.205  1.00  0.00           H  
ATOM    310  HB3 GLU A  19       0.771 -10.485   0.706  1.00  0.00           H  
ATOM    311  HG2 GLU A  19       1.675 -13.100   1.813  1.00  0.00           H  
ATOM    312  HG3 GLU A  19       2.149 -12.627   0.184  1.00  0.00           H  
ATOM    313  N   PHE A  20       0.190 -10.689   4.457  1.00  0.00           N  
ATOM    314  CA  PHE A  20       0.406  -9.707   5.512  1.00  0.00           C  
ATOM    315  C   PHE A  20       1.870  -9.308   5.620  1.00  0.00           C  
ATOM    316  O   PHE A  20       2.709 -10.084   6.076  1.00  0.00           O  
ATOM    317  CB  PHE A  20      -0.094 -10.248   6.854  1.00  0.00           C  
ATOM    318  CG  PHE A  20       0.183  -9.334   8.021  1.00  0.00           C  
ATOM    319  CD1 PHE A  20      -0.447  -8.104   8.123  1.00  0.00           C  
ATOM    320  CD2 PHE A  20       1.077  -9.705   9.016  1.00  0.00           C  
ATOM    321  CE1 PHE A  20      -0.190  -7.262   9.189  1.00  0.00           C  
ATOM    322  CE2 PHE A  20       1.338  -8.865  10.083  1.00  0.00           C  
ATOM    323  CZ  PHE A  20       0.702  -7.642  10.172  1.00  0.00           C  
ATOM    324  H   PHE A  20       0.151 -11.638   4.685  1.00  0.00           H  
ATOM    325  HA  PHE A  20      -0.170  -8.828   5.259  1.00  0.00           H  
ATOM    326  HB2 PHE A  20      -1.161 -10.398   6.795  1.00  0.00           H  
ATOM    327  HB3 PHE A  20       0.386 -11.196   7.050  1.00  0.00           H  
ATOM    328  HD1 PHE A  20      -1.144  -7.803   7.356  1.00  0.00           H  
ATOM    329  HD2 PHE A  20       1.575 -10.659   8.951  1.00  0.00           H  
ATOM    330  HE1 PHE A  20      -0.689  -6.304   9.255  1.00  0.00           H  
ATOM    331  HE2 PHE A  20       2.036  -9.166  10.850  1.00  0.00           H  
ATOM    332  HZ  PHE A  20       0.904  -6.986  11.006  1.00  0.00           H  
ATOM    333  N   GLN A  21       2.166  -8.092   5.199  1.00  0.00           N  
ATOM    334  CA  GLN A  21       3.500  -7.551   5.311  1.00  0.00           C  
ATOM    335  C   GLN A  21       3.554  -6.513   6.423  1.00  0.00           C  
ATOM    336  O   GLN A  21       2.520  -6.052   6.910  1.00  0.00           O  
ATOM    337  CB  GLN A  21       3.940  -6.943   3.983  1.00  0.00           C  
ATOM    338  CG  GLN A  21       4.235  -7.980   2.926  1.00  0.00           C  
ATOM    339  CD  GLN A  21       4.730  -7.368   1.642  1.00  0.00           C  
ATOM    340  OE1 GLN A  21       5.356  -6.307   1.635  1.00  0.00           O  
ATOM    341  NE2 GLN A  21       4.466  -8.046   0.549  1.00  0.00           N  
ATOM    342  H   GLN A  21       1.461  -7.533   4.801  1.00  0.00           H  
ATOM    343  HA  GLN A  21       4.165  -8.365   5.564  1.00  0.00           H  
ATOM    344  HB2 GLN A  21       3.157  -6.298   3.617  1.00  0.00           H  
ATOM    345  HB3 GLN A  21       4.830  -6.361   4.137  1.00  0.00           H  
ATOM    346  HG2 GLN A  21       4.989  -8.656   3.297  1.00  0.00           H  
ATOM    347  HG3 GLN A  21       3.329  -8.531   2.719  1.00  0.00           H  
ATOM    348 HE21 GLN A  21       3.975  -8.899   0.643  1.00  0.00           H  
ATOM    349 HE22 GLN A  21       4.754  -7.674  -0.308  1.00  0.00           H  
ATOM    350  N   ARG A  22       4.758  -6.159   6.830  1.00  0.00           N  
ATOM    351  CA  ARG A  22       4.937  -5.228   7.932  1.00  0.00           C  
ATOM    352  C   ARG A  22       5.732  -4.013   7.483  1.00  0.00           C  
ATOM    353  O   ARG A  22       6.373  -3.346   8.296  1.00  0.00           O  
ATOM    354  CB  ARG A  22       5.646  -5.921   9.096  1.00  0.00           C  
ATOM    355  CG  ARG A  22       4.869  -7.092   9.672  1.00  0.00           C  
ATOM    356  CD  ARG A  22       5.609  -7.742  10.826  1.00  0.00           C  
ATOM    357  NE  ARG A  22       5.805  -6.815  11.936  1.00  0.00           N  
ATOM    358  CZ  ARG A  22       6.780  -6.924  12.834  1.00  0.00           C  
ATOM    359  NH1 ARG A  22       7.690  -7.884  12.721  1.00  0.00           N  
ATOM    360  NH2 ARG A  22       6.854  -6.058  13.835  1.00  0.00           N  
ATOM    361  H   ARG A  22       5.546  -6.524   6.376  1.00  0.00           H  
ATOM    362  HA  ARG A  22       3.957  -4.907   8.256  1.00  0.00           H  
ATOM    363  HB2 ARG A  22       6.604  -6.285   8.754  1.00  0.00           H  
ATOM    364  HB3 ARG A  22       5.806  -5.200   9.885  1.00  0.00           H  
ATOM    365  HG2 ARG A  22       3.914  -6.737  10.026  1.00  0.00           H  
ATOM    366  HG3 ARG A  22       4.719  -7.826   8.894  1.00  0.00           H  
ATOM    367  HD2 ARG A  22       5.035  -8.588  11.173  1.00  0.00           H  
ATOM    368  HD3 ARG A  22       6.572  -8.081  10.476  1.00  0.00           H  
ATOM    369  HE  ARG A  22       5.161  -6.070  12.024  1.00  0.00           H  
ATOM    370 HH11 ARG A  22       7.651  -8.537  11.951  1.00  0.00           H  
ATOM    371 HH12 ARG A  22       8.418  -7.970  13.404  1.00  0.00           H  
ATOM    372 HH21 ARG A  22       6.176  -5.322  13.914  1.00  0.00           H  
ATOM    373 HH22 ARG A  22       7.593  -6.134  14.523  1.00  0.00           H  
ATOM    374  N   ALA A  23       5.668  -3.713   6.192  1.00  0.00           N  
ATOM    375  CA  ALA A  23       6.367  -2.556   5.649  1.00  0.00           C  
ATOM    376  C   ALA A  23       5.598  -1.292   6.005  1.00  0.00           C  
ATOM    377  O   ALA A  23       6.062  -0.464   6.791  1.00  0.00           O  
ATOM    378  CB  ALA A  23       6.538  -2.689   4.141  1.00  0.00           C  
ATOM    379  H   ALA A  23       5.113  -4.266   5.597  1.00  0.00           H  
ATOM    380  HA  ALA A  23       7.347  -2.510   6.102  1.00  0.00           H  
ATOM    381  HB1 ALA A  23       5.567  -2.741   3.671  1.00  0.00           H  
ATOM    382  HB2 ALA A  23       7.093  -3.587   3.920  1.00  0.00           H  
ATOM    383  HB3 ALA A  23       7.074  -1.831   3.762  1.00  0.00           H  
ATOM    384  N   GLN A  24       4.411  -1.164   5.438  1.00  0.00           N  
ATOM    385  CA  GLN A  24       3.487  -0.109   5.818  1.00  0.00           C  
ATOM    386  C   GLN A  24       2.298  -0.732   6.535  1.00  0.00           C  
ATOM    387  O   GLN A  24       1.261  -0.093   6.718  1.00  0.00           O  
ATOM    388  CB  GLN A  24       3.007   0.678   4.592  1.00  0.00           C  
ATOM    389  CG  GLN A  24       3.946   1.790   4.127  1.00  0.00           C  
ATOM    390  CD  GLN A  24       5.241   1.282   3.513  1.00  0.00           C  
ATOM    391  OE1 GLN A  24       5.313   1.028   2.309  1.00  0.00           O  
ATOM    392  NE2 GLN A  24       6.287   1.180   4.317  1.00  0.00           N  
ATOM    393  H   GLN A  24       4.139  -1.810   4.739  1.00  0.00           H  
ATOM    394  HA  GLN A  24       3.999   0.560   6.495  1.00  0.00           H  
ATOM    395  HB2 GLN A  24       2.877  -0.013   3.772  1.00  0.00           H  
ATOM    396  HB3 GLN A  24       2.051   1.123   4.824  1.00  0.00           H  
ATOM    397  HG2 GLN A  24       3.432   2.384   3.386  1.00  0.00           H  
ATOM    398  HG3 GLN A  24       4.187   2.412   4.973  1.00  0.00           H  
ATOM    399 HE21 GLN A  24       6.175   1.432   5.257  1.00  0.00           H  
ATOM    400 HE22 GLN A  24       7.136   0.851   3.938  1.00  0.00           H  
ATOM    401  N   ALA A  25       2.483  -1.990   6.941  1.00  0.00           N  
ATOM    402  CA  ALA A  25       1.429  -2.788   7.561  1.00  0.00           C  
ATOM    403  C   ALA A  25       0.280  -2.982   6.582  1.00  0.00           C  
ATOM    404  O   ALA A  25      -0.779  -2.369   6.708  1.00  0.00           O  
ATOM    405  CB  ALA A  25       0.942  -2.162   8.863  1.00  0.00           C  
ATOM    406  H   ALA A  25       3.361  -2.401   6.800  1.00  0.00           H  
ATOM    407  HA  ALA A  25       1.852  -3.757   7.792  1.00  0.00           H  
ATOM    408  HB1 ALA A  25       0.177  -2.786   9.304  1.00  0.00           H  
ATOM    409  HB2 ALA A  25       0.536  -1.182   8.661  1.00  0.00           H  
ATOM    410  HB3 ALA A  25       1.773  -2.072   9.547  1.00  0.00           H  
ATOM    411  N   GLU A  26       0.510  -3.823   5.591  1.00  0.00           N  
ATOM    412  CA  GLU A  26      -0.429  -3.977   4.500  1.00  0.00           C  
ATOM    413  C   GLU A  26      -0.752  -5.441   4.214  1.00  0.00           C  
ATOM    414  O   GLU A  26       0.099  -6.324   4.345  1.00  0.00           O  
ATOM    415  CB  GLU A  26       0.130  -3.310   3.238  1.00  0.00           C  
ATOM    416  CG  GLU A  26       1.472  -3.863   2.761  1.00  0.00           C  
ATOM    417  CD  GLU A  26       2.670  -3.283   3.499  1.00  0.00           C  
ATOM    418  OE1 GLU A  26       3.089  -3.854   4.529  1.00  0.00           O  
ATOM    419  OE2 GLU A  26       3.218  -2.260   3.034  1.00  0.00           O  
ATOM    420  H   GLU A  26       1.343  -4.345   5.585  1.00  0.00           H  
ATOM    421  HA  GLU A  26      -1.342  -3.474   4.779  1.00  0.00           H  
ATOM    422  HB2 GLU A  26      -0.586  -3.431   2.442  1.00  0.00           H  
ATOM    423  HB3 GLU A  26       0.252  -2.255   3.437  1.00  0.00           H  
ATOM    424  HG2 GLU A  26       1.474  -4.935   2.898  1.00  0.00           H  
ATOM    425  HG3 GLU A  26       1.578  -3.640   1.709  1.00  0.00           H  
ATOM    426  N   LEU A  27      -2.000  -5.687   3.839  1.00  0.00           N  
ATOM    427  CA  LEU A  27      -2.428  -6.999   3.384  1.00  0.00           C  
ATOM    428  C   LEU A  27      -2.408  -7.030   1.861  1.00  0.00           C  
ATOM    429  O   LEU A  27      -3.335  -6.548   1.205  1.00  0.00           O  
ATOM    430  CB  LEU A  27      -3.841  -7.313   3.877  1.00  0.00           C  
ATOM    431  CG  LEU A  27      -4.068  -7.148   5.382  1.00  0.00           C  
ATOM    432  CD1 LEU A  27      -5.551  -7.239   5.710  1.00  0.00           C  
ATOM    433  CD2 LEU A  27      -3.298  -8.209   6.147  1.00  0.00           C  
ATOM    434  H   LEU A  27      -2.660  -4.957   3.877  1.00  0.00           H  
ATOM    435  HA  LEU A  27      -1.737  -7.733   3.768  1.00  0.00           H  
ATOM    436  HB2 LEU A  27      -4.531  -6.672   3.352  1.00  0.00           H  
ATOM    437  HB3 LEU A  27      -4.065  -8.336   3.616  1.00  0.00           H  
ATOM    438  HG  LEU A  27      -3.710  -6.177   5.693  1.00  0.00           H  
ATOM    439 HD11 LEU A  27      -6.087  -6.484   5.157  1.00  0.00           H  
ATOM    440 HD12 LEU A  27      -5.696  -7.082   6.769  1.00  0.00           H  
ATOM    441 HD13 LEU A  27      -5.920  -8.217   5.438  1.00  0.00           H  
ATOM    442 HD21 LEU A  27      -3.656  -9.187   5.867  1.00  0.00           H  
ATOM    443 HD22 LEU A  27      -3.442  -8.063   7.209  1.00  0.00           H  
ATOM    444 HD23 LEU A  27      -2.247  -8.129   5.913  1.00  0.00           H  
ATOM    445  N   VAL A  28      -1.341  -7.566   1.302  1.00  0.00           N  
ATOM    446  CA  VAL A  28      -1.159  -7.575  -0.137  1.00  0.00           C  
ATOM    447  C   VAL A  28      -2.068  -8.602  -0.803  1.00  0.00           C  
ATOM    448  O   VAL A  28      -2.046  -9.783  -0.464  1.00  0.00           O  
ATOM    449  CB  VAL A  28       0.310  -7.868  -0.512  1.00  0.00           C  
ATOM    450  CG1 VAL A  28       0.499  -7.866  -2.021  1.00  0.00           C  
ATOM    451  CG2 VAL A  28       1.241  -6.848   0.137  1.00  0.00           C  
ATOM    452  H   VAL A  28      -0.650  -7.969   1.876  1.00  0.00           H  
ATOM    453  HA  VAL A  28      -1.411  -6.592  -0.509  1.00  0.00           H  
ATOM    454  HB  VAL A  28       0.567  -8.849  -0.140  1.00  0.00           H  
ATOM    455 HG11 VAL A  28       0.235  -6.894  -2.414  1.00  0.00           H  
ATOM    456 HG12 VAL A  28      -0.134  -8.620  -2.469  1.00  0.00           H  
ATOM    457 HG13 VAL A  28       1.530  -8.077  -2.252  1.00  0.00           H  
ATOM    458 HG21 VAL A  28       1.132  -6.887   1.210  1.00  0.00           H  
ATOM    459 HG22 VAL A  28       0.988  -5.858  -0.212  1.00  0.00           H  
ATOM    460 HG23 VAL A  28       2.263  -7.071  -0.129  1.00  0.00           H  
ATOM    461  N   CYS A  29      -2.880  -8.137  -1.736  1.00  0.00           N  
ATOM    462  CA  CYS A  29      -3.673  -9.025  -2.564  1.00  0.00           C  
ATOM    463  C   CYS A  29      -2.771  -9.621  -3.632  1.00  0.00           C  
ATOM    464  O   CYS A  29      -2.491  -8.976  -4.649  1.00  0.00           O  
ATOM    465  CB  CYS A  29      -4.828  -8.264  -3.211  1.00  0.00           C  
ATOM    466  SG  CYS A  29      -5.857  -7.364  -2.033  1.00  0.00           S  
ATOM    467  H   CYS A  29      -2.935  -7.166  -1.881  1.00  0.00           H  
ATOM    468  HA  CYS A  29      -4.062  -9.815  -1.940  1.00  0.00           H  
ATOM    469  HB2 CYS A  29      -4.427  -7.545  -3.909  1.00  0.00           H  
ATOM    470  HB3 CYS A  29      -5.459  -8.961  -3.740  1.00  0.00           H  
ATOM    471  HG  CYS A  29      -5.296  -7.468  -0.835  1.00  0.00           H  
ATOM    472  N   ASN A  30      -2.300 -10.836  -3.382  1.00  0.00           N  
ATOM    473  CA  ASN A  30      -1.263 -11.454  -4.193  1.00  0.00           C  
ATOM    474  C   ASN A  30      -1.823 -11.983  -5.512  1.00  0.00           C  
ATOM    475  O   ASN A  30      -1.645 -13.149  -5.866  1.00  0.00           O  
ATOM    476  CB  ASN A  30      -0.613 -12.580  -3.391  1.00  0.00           C  
ATOM    477  CG  ASN A  30       0.853 -12.754  -3.714  1.00  0.00           C  
ATOM    478  OD1 ASN A  30       1.293 -12.526  -4.838  1.00  0.00           O  
ATOM    479  ND2 ASN A  30       1.625 -13.146  -2.716  1.00  0.00           N  
ATOM    480  H   ASN A  30      -2.654 -11.335  -2.618  1.00  0.00           H  
ATOM    481  HA  ASN A  30      -0.521 -10.699  -4.408  1.00  0.00           H  
ATOM    482  HB2 ASN A  30      -0.705 -12.364  -2.340  1.00  0.00           H  
ATOM    483  HB3 ASN A  30      -1.124 -13.509  -3.609  1.00  0.00           H  
ATOM    484 HD21 ASN A  30       1.210 -13.308  -1.841  1.00  0.00           H  
ATOM    485 HD22 ASN A  30       2.577 -13.260  -2.889  1.00  0.00           H  
ATOM    486  N   ALA A  31      -2.501 -11.103  -6.228  1.00  0.00           N  
ATOM    487  CA  ALA A  31      -3.036 -11.396  -7.546  1.00  0.00           C  
ATOM    488  C   ALA A  31      -3.418 -10.098  -8.240  1.00  0.00           C  
ATOM    489  O   ALA A  31      -3.205  -9.927  -9.440  1.00  0.00           O  
ATOM    490  CB  ALA A  31      -4.243 -12.319  -7.449  1.00  0.00           C  
ATOM    491  H   ALA A  31      -2.647 -10.212  -5.845  1.00  0.00           H  
ATOM    492  HA  ALA A  31      -2.267 -11.894  -8.119  1.00  0.00           H  
ATOM    493  HB1 ALA A  31      -3.946 -13.247  -6.986  1.00  0.00           H  
ATOM    494  HB2 ALA A  31      -4.629 -12.518  -8.440  1.00  0.00           H  
ATOM    495  HB3 ALA A  31      -5.010 -11.847  -6.851  1.00  0.00           H  
ATOM    496  N   ASP A  32      -3.974  -9.179  -7.460  1.00  0.00           N  
ATOM    497  CA  ASP A  32      -4.408  -7.885  -7.975  1.00  0.00           C  
ATOM    498  C   ASP A  32      -3.313  -6.838  -7.800  1.00  0.00           C  
ATOM    499  O   ASP A  32      -3.428  -5.724  -8.308  1.00  0.00           O  
ATOM    500  CB  ASP A  32      -5.670  -7.420  -7.245  1.00  0.00           C  
ATOM    501  CG  ASP A  32      -6.798  -8.426  -7.320  1.00  0.00           C  
ATOM    502  OD1 ASP A  32      -6.880  -9.294  -6.428  1.00  0.00           O  
ATOM    503  OD2 ASP A  32      -7.605  -8.353  -8.272  1.00  0.00           O  
ATOM    504  H   ASP A  32      -4.124  -9.387  -6.513  1.00  0.00           H  
ATOM    505  HA  ASP A  32      -4.626  -7.997  -9.027  1.00  0.00           H  
ATOM    506  HB2 ASP A  32      -5.436  -7.252  -6.205  1.00  0.00           H  
ATOM    507  HB3 ASP A  32      -6.012  -6.494  -7.684  1.00  0.00           H  
ATOM    508  N   ARG A  33      -2.262  -7.207  -7.068  1.00  0.00           N  
ATOM    509  CA  ARG A  33      -1.171  -6.290  -6.743  1.00  0.00           C  
ATOM    510  C   ARG A  33      -1.679  -5.123  -5.903  1.00  0.00           C  
ATOM    511  O   ARG A  33      -1.194  -3.996  -6.011  1.00  0.00           O  
ATOM    512  CB  ARG A  33      -0.464  -5.778  -8.004  1.00  0.00           C  
ATOM    513  CG  ARG A  33       0.331  -6.855  -8.721  1.00  0.00           C  
ATOM    514  CD  ARG A  33       1.357  -6.241  -9.652  1.00  0.00           C  
ATOM    515  NE  ARG A  33       0.731  -5.426 -10.689  1.00  0.00           N  
ATOM    516  CZ  ARG A  33       1.248  -4.297 -11.170  1.00  0.00           C  
ATOM    517  NH1 ARG A  33       2.414  -3.841 -10.728  1.00  0.00           N  
ATOM    518  NH2 ARG A  33       0.593  -3.623 -12.102  1.00  0.00           N  
ATOM    519  H   ARG A  33      -2.222  -8.123  -6.728  1.00  0.00           H  
ATOM    520  HA  ARG A  33      -0.453  -6.842  -6.157  1.00  0.00           H  
ATOM    521  HB2 ARG A  33      -1.202  -5.387  -8.689  1.00  0.00           H  
ATOM    522  HB3 ARG A  33       0.214  -4.987  -7.725  1.00  0.00           H  
ATOM    523  HG2 ARG A  33       0.839  -7.463  -7.987  1.00  0.00           H  
ATOM    524  HG3 ARG A  33      -0.346  -7.469  -9.298  1.00  0.00           H  
ATOM    525  HD2 ARG A  33       2.018  -5.619  -9.066  1.00  0.00           H  
ATOM    526  HD3 ARG A  33       1.922  -7.033 -10.116  1.00  0.00           H  
ATOM    527  HE  ARG A  33      -0.137  -5.746 -11.051  1.00  0.00           H  
ATOM    528 HH11 ARG A  33       2.927  -4.350 -10.022  1.00  0.00           H  
ATOM    529 HH12 ARG A  33       2.794  -2.982 -11.098  1.00  0.00           H  
ATOM    530 HH21 ARG A  33      -0.288  -3.959 -12.444  1.00  0.00           H  
ATOM    531 HH22 ARG A  33       0.977  -2.776 -12.477  1.00  0.00           H  
ATOM    532  N   LEU A  34      -2.650  -5.412  -5.049  1.00  0.00           N  
ATOM    533  CA  LEU A  34      -3.201  -4.410  -4.149  1.00  0.00           C  
ATOM    534  C   LEU A  34      -2.708  -4.668  -2.738  1.00  0.00           C  
ATOM    535  O   LEU A  34      -2.096  -5.700  -2.474  1.00  0.00           O  
ATOM    536  CB  LEU A  34      -4.732  -4.430  -4.178  1.00  0.00           C  
ATOM    537  CG  LEU A  34      -5.367  -4.018  -5.504  1.00  0.00           C  
ATOM    538  CD1 LEU A  34      -6.877  -4.193  -5.448  1.00  0.00           C  
ATOM    539  CD2 LEU A  34      -5.014  -2.578  -5.834  1.00  0.00           C  
ATOM    540  H   LEU A  34      -2.993  -6.331  -5.008  1.00  0.00           H  
ATOM    541  HA  LEU A  34      -2.849  -3.440  -4.473  1.00  0.00           H  
ATOM    542  HB2 LEU A  34      -5.058  -5.433  -3.945  1.00  0.00           H  
ATOM    543  HB3 LEU A  34      -5.095  -3.764  -3.408  1.00  0.00           H  
ATOM    544  HG  LEU A  34      -4.983  -4.646  -6.290  1.00  0.00           H  
ATOM    545 HD11 LEU A  34      -7.114  -5.225  -5.235  1.00  0.00           H  
ATOM    546 HD12 LEU A  34      -7.307  -3.915  -6.398  1.00  0.00           H  
ATOM    547 HD13 LEU A  34      -7.285  -3.561  -4.671  1.00  0.00           H  
ATOM    548 HD21 LEU A  34      -5.430  -1.925  -5.080  1.00  0.00           H  
ATOM    549 HD22 LEU A  34      -5.421  -2.318  -6.800  1.00  0.00           H  
ATOM    550 HD23 LEU A  34      -3.941  -2.466  -5.853  1.00  0.00           H  
ATOM    551  N   ALA A  35      -2.970  -3.741  -1.840  1.00  0.00           N  
ATOM    552  CA  ALA A  35      -2.552  -3.887  -0.457  1.00  0.00           C  
ATOM    553  C   ALA A  35      -3.448  -3.081   0.474  1.00  0.00           C  
ATOM    554  O   ALA A  35      -3.454  -1.850   0.436  1.00  0.00           O  
ATOM    555  CB  ALA A  35      -1.098  -3.471  -0.303  1.00  0.00           C  
ATOM    556  H   ALA A  35      -3.450  -2.927  -2.113  1.00  0.00           H  
ATOM    557  HA  ALA A  35      -2.630  -4.933  -0.196  1.00  0.00           H  
ATOM    558  HB1 ALA A  35      -0.485  -4.039  -0.987  1.00  0.00           H  
ATOM    559  HB2 ALA A  35      -0.776  -3.661   0.708  1.00  0.00           H  
ATOM    560  HB3 ALA A  35      -1.000  -2.420  -0.520  1.00  0.00           H  
ATOM    561  N   PHE A  36      -4.218  -3.785   1.295  1.00  0.00           N  
ATOM    562  CA  PHE A  36      -5.092  -3.141   2.267  1.00  0.00           C  
ATOM    563  C   PHE A  36      -4.288  -2.724   3.494  1.00  0.00           C  
ATOM    564  O   PHE A  36      -3.670  -3.560   4.151  1.00  0.00           O  
ATOM    565  CB  PHE A  36      -6.230  -4.080   2.680  1.00  0.00           C  
ATOM    566  CG  PHE A  36      -7.137  -4.469   1.548  1.00  0.00           C  
ATOM    567  CD1 PHE A  36      -7.841  -3.506   0.841  1.00  0.00           C  
ATOM    568  CD2 PHE A  36      -7.288  -5.796   1.193  1.00  0.00           C  
ATOM    569  CE1 PHE A  36      -8.677  -3.862  -0.200  1.00  0.00           C  
ATOM    570  CE2 PHE A  36      -8.125  -6.160   0.155  1.00  0.00           C  
ATOM    571  CZ  PHE A  36      -8.821  -5.191  -0.540  1.00  0.00           C  
ATOM    572  H   PHE A  36      -4.193  -4.766   1.251  1.00  0.00           H  
ATOM    573  HA  PHE A  36      -5.511  -2.259   1.806  1.00  0.00           H  
ATOM    574  HB2 PHE A  36      -5.809  -4.986   3.088  1.00  0.00           H  
ATOM    575  HB3 PHE A  36      -6.831  -3.595   3.437  1.00  0.00           H  
ATOM    576  HD1 PHE A  36      -7.728  -2.467   1.107  1.00  0.00           H  
ATOM    577  HD2 PHE A  36      -6.746  -6.553   1.739  1.00  0.00           H  
ATOM    578  HE1 PHE A  36      -9.219  -3.103  -0.741  1.00  0.00           H  
ATOM    579  HE2 PHE A  36      -8.233  -7.201  -0.112  1.00  0.00           H  
ATOM    580  HZ  PHE A  36      -9.475  -5.473  -1.353  1.00  0.00           H  
ATOM    581  N   PRO A  37      -4.272  -1.428   3.813  1.00  0.00           N  
ATOM    582  CA  PRO A  37      -3.464  -0.904   4.908  1.00  0.00           C  
ATOM    583  C   PRO A  37      -4.101  -1.118   6.277  1.00  0.00           C  
ATOM    584  O   PRO A  37      -5.292  -0.853   6.479  1.00  0.00           O  
ATOM    585  CB  PRO A  37      -3.367   0.584   4.583  1.00  0.00           C  
ATOM    586  CG  PRO A  37      -4.617   0.898   3.835  1.00  0.00           C  
ATOM    587  CD  PRO A  37      -5.039  -0.370   3.132  1.00  0.00           C  
ATOM    588  HA  PRO A  37      -2.476  -1.337   4.907  1.00  0.00           H  
ATOM    589  HB2 PRO A  37      -3.302   1.149   5.502  1.00  0.00           H  
ATOM    590  HB3 PRO A  37      -2.490   0.764   3.980  1.00  0.00           H  
ATOM    591  HG2 PRO A  37      -5.386   1.213   4.526  1.00  0.00           H  
ATOM    592  HG3 PRO A  37      -4.423   1.678   3.114  1.00  0.00           H  
ATOM    593  HD3 PRO A  37      -6.101  -0.529   3.251  1.00  0.00           H  
ATOM    594  HD2 PRO A  37      -4.781  -0.324   2.085  1.00  0.00           H  
ATOM    595  N   VAL A  38      -3.305  -1.604   7.214  1.00  0.00           N  
ATOM    596  CA  VAL A  38      -3.749  -1.755   8.585  1.00  0.00           C  
ATOM    597  C   VAL A  38      -3.365  -0.510   9.377  1.00  0.00           C  
ATOM    598  O   VAL A  38      -2.206  -0.330   9.747  1.00  0.00           O  
ATOM    599  CB  VAL A  38      -3.142  -3.005   9.263  1.00  0.00           C  
ATOM    600  CG1 VAL A  38      -3.706  -3.182  10.672  1.00  0.00           C  
ATOM    601  CG2 VAL A  38      -3.386  -4.245   8.409  1.00  0.00           C  
ATOM    602  H   VAL A  38      -2.381  -1.859   6.977  1.00  0.00           H  
ATOM    603  HA  VAL A  38      -4.825  -1.854   8.577  1.00  0.00           H  
ATOM    604  HB  VAL A  38      -2.075  -2.858   9.348  1.00  0.00           H  
ATOM    605 HG11 VAL A  38      -3.476  -2.306  11.263  1.00  0.00           H  
ATOM    606 HG12 VAL A  38      -3.263  -4.051  11.133  1.00  0.00           H  
ATOM    607 HG13 VAL A  38      -4.777  -3.306  10.620  1.00  0.00           H  
ATOM    608 HG21 VAL A  38      -4.446  -4.378   8.260  1.00  0.00           H  
ATOM    609 HG22 VAL A  38      -2.979  -5.113   8.905  1.00  0.00           H  
ATOM    610 HG23 VAL A  38      -2.902  -4.120   7.450  1.00  0.00           H  
ATOM    611  N   ARG A  39      -4.338   0.349   9.624  1.00  0.00           N  
ATOM    612  CA  ARG A  39      -4.089   1.612  10.297  1.00  0.00           C  
ATOM    613  C   ARG A  39      -4.099   1.402  11.803  1.00  0.00           C  
ATOM    614  O   ARG A  39      -5.067   1.744  12.484  1.00  0.00           O  
ATOM    615  CB  ARG A  39      -5.140   2.644   9.881  1.00  0.00           C  
ATOM    616  CG  ARG A  39      -4.858   4.057  10.366  1.00  0.00           C  
ATOM    617  CD  ARG A  39      -5.963   5.009   9.935  1.00  0.00           C  
ATOM    618  NE  ARG A  39      -5.715   6.381  10.373  1.00  0.00           N  
ATOM    619  CZ  ARG A  39      -6.680   7.236  10.702  1.00  0.00           C  
ATOM    620  NH1 ARG A  39      -7.951   6.850  10.655  1.00  0.00           N  
ATOM    621  NH2 ARG A  39      -6.372   8.470  11.077  1.00  0.00           N  
ATOM    622  H   ARG A  39      -5.260   0.118   9.367  1.00  0.00           H  
ATOM    623  HA  ARG A  39      -3.112   1.964  10.000  1.00  0.00           H  
ATOM    624  HB2 ARG A  39      -5.194   2.664   8.802  1.00  0.00           H  
ATOM    625  HB3 ARG A  39      -6.099   2.339  10.272  1.00  0.00           H  
ATOM    626  HG2 ARG A  39      -4.797   4.054  11.445  1.00  0.00           H  
ATOM    627  HG3 ARG A  39      -3.922   4.394   9.948  1.00  0.00           H  
ATOM    628  HD2 ARG A  39      -6.031   4.996   8.857  1.00  0.00           H  
ATOM    629  HD3 ARG A  39      -6.897   4.670  10.358  1.00  0.00           H  
ATOM    630  HE  ARG A  39      -4.777   6.681  10.413  1.00  0.00           H  
ATOM    631 HH11 ARG A  39      -8.184   5.919  10.370  1.00  0.00           H  
ATOM    632 HH12 ARG A  39      -8.686   7.488  10.922  1.00  0.00           H  
ATOM    633 HH21 ARG A  39      -5.406   8.760  11.119  1.00  0.00           H  
ATOM    634 HH22 ARG A  39      -7.099   9.127  11.310  1.00  0.00           H  
ATOM    635  N   ASP A  40      -3.021   0.786  12.288  1.00  0.00           N  
ATOM    636  CA  ASP A  40      -2.843   0.470  13.706  1.00  0.00           C  
ATOM    637  C   ASP A  40      -4.079  -0.216  14.281  1.00  0.00           C  
ATOM    638  O   ASP A  40      -4.908   0.409  14.942  1.00  0.00           O  
ATOM    639  CB  ASP A  40      -2.490   1.724  14.517  1.00  0.00           C  
ATOM    640  CG  ASP A  40      -2.163   1.409  15.968  1.00  0.00           C  
ATOM    641  OD1 ASP A  40      -1.527   0.364  16.231  1.00  0.00           O  
ATOM    642  OD2 ASP A  40      -2.517   2.217  16.851  1.00  0.00           O  
ATOM    643  H   ASP A  40      -2.316   0.523  11.658  1.00  0.00           H  
ATOM    644  HA  ASP A  40      -2.018  -0.224  13.776  1.00  0.00           H  
ATOM    645  HB2 ASP A  40      -1.630   2.200  14.070  1.00  0.00           H  
ATOM    646  HB3 ASP A  40      -3.327   2.408  14.493  1.00  0.00           H  
ATOM    647  N   GLY A  41      -4.216  -1.498  13.979  1.00  0.00           N  
ATOM    648  CA  GLY A  41      -5.336  -2.265  14.478  1.00  0.00           C  
ATOM    649  C   GLY A  41      -6.482  -2.340  13.492  1.00  0.00           C  
ATOM    650  O   GLY A  41      -7.055  -3.408  13.287  1.00  0.00           O  
ATOM    651  H   GLY A  41      -3.545  -1.930  13.413  1.00  0.00           H  
ATOM    652  HA2 GLY A  41      -5.001  -3.267  14.701  1.00  0.00           H  
ATOM    653  HA3 GLY A  41      -5.692  -1.806  15.390  1.00  0.00           H  
ATOM    654  N   VAL A  42      -6.807  -1.212  12.867  1.00  0.00           N  
ATOM    655  CA  VAL A  42      -7.951  -1.142  11.970  1.00  0.00           C  
ATOM    656  C   VAL A  42      -7.518  -1.289  10.511  1.00  0.00           C  
ATOM    657  O   VAL A  42      -6.888  -0.392   9.948  1.00  0.00           O  
ATOM    658  CB  VAL A  42      -8.713   0.190  12.138  1.00  0.00           C  
ATOM    659  CG1 VAL A  42      -9.935   0.239  11.231  1.00  0.00           C  
ATOM    660  CG2 VAL A  42      -9.110   0.400  13.586  1.00  0.00           C  
ATOM    661  H   VAL A  42      -6.255  -0.409  13.003  1.00  0.00           H  
ATOM    662  HA  VAL A  42      -8.620  -1.954  12.220  1.00  0.00           H  
ATOM    663  HB  VAL A  42      -8.050   0.994  11.854  1.00  0.00           H  
ATOM    664 HG11 VAL A  42     -10.603  -0.572  11.481  1.00  0.00           H  
ATOM    665 HG12 VAL A  42      -9.619   0.143  10.203  1.00  0.00           H  
ATOM    666 HG13 VAL A  42     -10.448   1.180  11.365  1.00  0.00           H  
ATOM    667 HG21 VAL A  42      -9.661   1.326  13.673  1.00  0.00           H  
ATOM    668 HG22 VAL A  42      -8.221   0.449  14.196  1.00  0.00           H  
ATOM    669 HG23 VAL A  42      -9.728  -0.422  13.913  1.00  0.00           H  
ATOM    670  N   PRO A  43      -7.838  -2.429   9.886  1.00  0.00           N  
ATOM    671  CA  PRO A  43      -7.508  -2.694   8.492  1.00  0.00           C  
ATOM    672  C   PRO A  43      -8.531  -2.087   7.537  1.00  0.00           C  
ATOM    673  O   PRO A  43      -9.736  -2.315   7.671  1.00  0.00           O  
ATOM    674  CB  PRO A  43      -7.531  -4.230   8.396  1.00  0.00           C  
ATOM    675  CG  PRO A  43      -7.972  -4.733   9.740  1.00  0.00           C  
ATOM    676  CD  PRO A  43      -8.554  -3.557  10.477  1.00  0.00           C  
ATOM    677  HA  PRO A  43      -6.521  -2.331   8.242  1.00  0.00           H  
ATOM    678  HB2 PRO A  43      -8.220  -4.531   7.621  1.00  0.00           H  
ATOM    679  HB3 PRO A  43      -6.540  -4.586   8.154  1.00  0.00           H  
ATOM    680  HG2 PRO A  43      -8.721  -5.501   9.613  1.00  0.00           H  
ATOM    681  HG3 PRO A  43      -7.121  -5.128  10.276  1.00  0.00           H  
ATOM    682  HD3 PRO A  43      -9.615  -3.483  10.291  1.00  0.00           H  
ATOM    683  HD2 PRO A  43      -8.355  -3.632  11.535  1.00  0.00           H  
ATOM    684  N   ILE A  44      -8.048  -1.315   6.579  1.00  0.00           N  
ATOM    685  CA  ILE A  44      -8.917  -0.687   5.595  1.00  0.00           C  
ATOM    686  C   ILE A  44      -9.124  -1.623   4.408  1.00  0.00           C  
ATOM    687  O   ILE A  44      -8.276  -1.714   3.522  1.00  0.00           O  
ATOM    688  CB  ILE A  44      -8.338   0.657   5.097  1.00  0.00           C  
ATOM    689  CG1 ILE A  44      -8.052   1.590   6.281  1.00  0.00           C  
ATOM    690  CG2 ILE A  44      -9.288   1.327   4.106  1.00  0.00           C  
ATOM    691  CD1 ILE A  44      -9.275   1.939   7.103  1.00  0.00           C  
ATOM    692  H   ILE A  44      -7.078  -1.167   6.526  1.00  0.00           H  
ATOM    693  HA  ILE A  44      -9.872  -0.497   6.065  1.00  0.00           H  
ATOM    694  HB  ILE A  44      -7.413   0.452   4.581  1.00  0.00           H  
ATOM    695 HG12 ILE A  44      -7.337   1.116   6.937  1.00  0.00           H  
ATOM    696 HG13 ILE A  44      -7.631   2.511   5.911  1.00  0.00           H  
ATOM    697 HG21 ILE A  44      -9.438   0.676   3.257  1.00  0.00           H  
ATOM    698 HG22 ILE A  44      -8.859   2.261   3.772  1.00  0.00           H  
ATOM    699 HG23 ILE A  44     -10.236   1.515   4.587  1.00  0.00           H  
ATOM    700 HD11 ILE A  44      -9.998   2.440   6.477  1.00  0.00           H  
ATOM    701 HD12 ILE A  44      -8.989   2.589   7.916  1.00  0.00           H  
ATOM    702 HD13 ILE A  44      -9.710   1.037   7.501  1.00  0.00           H  
ATOM    703  N   MET A  45     -10.253  -2.321   4.406  1.00  0.00           N  
ATOM    704  CA  MET A  45     -10.562  -3.297   3.364  1.00  0.00           C  
ATOM    705  C   MET A  45     -11.243  -2.631   2.168  1.00  0.00           C  
ATOM    706  O   MET A  45     -11.929  -3.287   1.384  1.00  0.00           O  
ATOM    707  CB  MET A  45     -11.459  -4.406   3.933  1.00  0.00           C  
ATOM    708  CG  MET A  45     -10.809  -5.209   5.050  1.00  0.00           C  
ATOM    709  SD  MET A  45      -9.407  -6.193   4.481  1.00  0.00           S  
ATOM    710  CE  MET A  45     -10.211  -7.307   3.328  1.00  0.00           C  
ATOM    711  H   MET A  45     -10.905  -2.178   5.132  1.00  0.00           H  
ATOM    712  HA  MET A  45      -9.630  -3.734   3.037  1.00  0.00           H  
ATOM    713  HB2 MET A  45     -12.364  -3.962   4.319  1.00  0.00           H  
ATOM    714  HB3 MET A  45     -11.716  -5.086   3.134  1.00  0.00           H  
ATOM    715  HG2 MET A  45     -10.459  -4.525   5.808  1.00  0.00           H  
ATOM    716  HG3 MET A  45     -11.546  -5.871   5.477  1.00  0.00           H  
ATOM    717  HE1 MET A  45     -10.670  -6.733   2.535  1.00  0.00           H  
ATOM    718  HE2 MET A  45     -10.966  -7.877   3.847  1.00  0.00           H  
ATOM    719  HE3 MET A  45      -9.477  -7.982   2.909  1.00  0.00           H  
ATOM    720  N   LEU A  46     -11.038  -1.331   2.026  1.00  0.00           N  
ATOM    721  CA  LEU A  46     -11.619  -0.571   0.931  1.00  0.00           C  
ATOM    722  C   LEU A  46     -10.565  -0.324  -0.142  1.00  0.00           C  
ATOM    723  O   LEU A  46      -9.573   0.359   0.108  1.00  0.00           O  
ATOM    724  CB  LEU A  46     -12.167   0.756   1.458  1.00  0.00           C  
ATOM    725  CG  LEU A  46     -13.202   0.624   2.574  1.00  0.00           C  
ATOM    726  CD1 LEU A  46     -13.541   1.989   3.140  1.00  0.00           C  
ATOM    727  CD2 LEU A  46     -14.457  -0.065   2.058  1.00  0.00           C  
ATOM    728  H   LEU A  46     -10.468  -0.869   2.675  1.00  0.00           H  
ATOM    729  HA  LEU A  46     -12.426  -1.149   0.505  1.00  0.00           H  
ATOM    730  HB2 LEU A  46     -11.336   1.339   1.834  1.00  0.00           H  
ATOM    731  HB3 LEU A  46     -12.619   1.292   0.638  1.00  0.00           H  
ATOM    732  HG  LEU A  46     -12.791   0.022   3.371  1.00  0.00           H  
ATOM    733 HD11 LEU A  46     -14.279   1.883   3.919  1.00  0.00           H  
ATOM    734 HD12 LEU A  46     -13.936   2.616   2.354  1.00  0.00           H  
ATOM    735 HD13 LEU A  46     -12.649   2.442   3.547  1.00  0.00           H  
ATOM    736 HD21 LEU A  46     -14.201  -1.048   1.689  1.00  0.00           H  
ATOM    737 HD22 LEU A  46     -14.883   0.520   1.257  1.00  0.00           H  
ATOM    738 HD23 LEU A  46     -15.175  -0.155   2.860  1.00  0.00           H  
ATOM    739  N   GLU A  47     -10.791  -0.866  -1.331  1.00  0.00           N  
ATOM    740  CA  GLU A  47      -9.793  -0.844  -2.399  1.00  0.00           C  
ATOM    741  C   GLU A  47      -9.429   0.585  -2.816  1.00  0.00           C  
ATOM    742  O   GLU A  47      -8.262   0.895  -3.051  1.00  0.00           O  
ATOM    743  CB  GLU A  47     -10.280  -1.653  -3.617  1.00  0.00           C  
ATOM    744  CG  GLU A  47     -11.385  -0.995  -4.442  1.00  0.00           C  
ATOM    745  CD  GLU A  47     -12.683  -0.814  -3.680  1.00  0.00           C  
ATOM    746  OE1 GLU A  47     -13.505  -1.749  -3.675  1.00  0.00           O  
ATOM    747  OE2 GLU A  47     -12.889   0.272  -3.092  1.00  0.00           O  
ATOM    748  H   GLU A  47     -11.656  -1.299  -1.500  1.00  0.00           H  
ATOM    749  HA  GLU A  47      -8.903  -1.317  -2.013  1.00  0.00           H  
ATOM    750  HB2 GLU A  47      -9.440  -1.829  -4.271  1.00  0.00           H  
ATOM    751  HB3 GLU A  47     -10.650  -2.606  -3.265  1.00  0.00           H  
ATOM    752  HG2 GLU A  47     -11.042  -0.025  -4.770  1.00  0.00           H  
ATOM    753  HG3 GLU A  47     -11.580  -1.612  -5.308  1.00  0.00           H  
ATOM    754  N   ALA A  48     -10.429   1.451  -2.887  1.00  0.00           N  
ATOM    755  CA  ALA A  48     -10.227   2.828  -3.317  1.00  0.00           C  
ATOM    756  C   ALA A  48      -9.382   3.616  -2.322  1.00  0.00           C  
ATOM    757  O   ALA A  48      -8.683   4.561  -2.697  1.00  0.00           O  
ATOM    758  CB  ALA A  48     -11.567   3.512  -3.525  1.00  0.00           C  
ATOM    759  H   ALA A  48     -11.338   1.147  -2.663  1.00  0.00           H  
ATOM    760  HA  ALA A  48      -9.715   2.803  -4.267  1.00  0.00           H  
ATOM    761  HB1 ALA A  48     -11.407   4.498  -3.939  1.00  0.00           H  
ATOM    762  HB2 ALA A  48     -12.079   3.597  -2.579  1.00  0.00           H  
ATOM    763  HB3 ALA A  48     -12.165   2.929  -4.207  1.00  0.00           H  
ATOM    764  N   GLU A  49      -9.430   3.219  -1.059  1.00  0.00           N  
ATOM    765  CA  GLU A  49      -8.731   3.947  -0.013  1.00  0.00           C  
ATOM    766  C   GLU A  49      -7.503   3.175   0.455  1.00  0.00           C  
ATOM    767  O   GLU A  49      -6.856   3.541   1.437  1.00  0.00           O  
ATOM    768  CB  GLU A  49      -9.677   4.226   1.151  1.00  0.00           C  
ATOM    769  CG  GLU A  49     -10.974   4.879   0.710  1.00  0.00           C  
ATOM    770  CD  GLU A  49     -11.620   5.694   1.804  1.00  0.00           C  
ATOM    771  OE1 GLU A  49     -12.308   5.112   2.667  1.00  0.00           O  
ATOM    772  OE2 GLU A  49     -11.447   6.931   1.797  1.00  0.00           O  
ATOM    773  H   GLU A  49      -9.939   2.414  -0.826  1.00  0.00           H  
ATOM    774  HA  GLU A  49      -8.405   4.888  -0.430  1.00  0.00           H  
ATOM    775  HB2 GLU A  49      -9.913   3.294   1.641  1.00  0.00           H  
ATOM    776  HB3 GLU A  49      -9.188   4.882   1.854  1.00  0.00           H  
ATOM    777  HG2 GLU A  49     -10.768   5.530  -0.129  1.00  0.00           H  
ATOM    778  HG3 GLU A  49     -11.663   4.106   0.402  1.00  0.00           H  
ATOM    779  N   ALA A  50      -7.180   2.116  -0.272  1.00  0.00           N  
ATOM    780  CA  ALA A  50      -6.008   1.312   0.024  1.00  0.00           C  
ATOM    781  C   ALA A  50      -4.841   1.751  -0.848  1.00  0.00           C  
ATOM    782  O   ALA A  50      -4.912   2.785  -1.518  1.00  0.00           O  
ATOM    783  CB  ALA A  50      -6.311  -0.165  -0.195  1.00  0.00           C  
ATOM    784  H   ALA A  50      -7.742   1.873  -1.035  1.00  0.00           H  
ATOM    785  HA  ALA A  50      -5.750   1.458   1.062  1.00  0.00           H  
ATOM    786  HB1 ALA A  50      -7.121  -0.468   0.452  1.00  0.00           H  
ATOM    787  HB2 ALA A  50      -5.430  -0.750   0.031  1.00  0.00           H  
ATOM    788  HB3 ALA A  50      -6.593  -0.326  -1.225  1.00  0.00           H  
ATOM    789  N   ARG A  51      -3.771   0.971  -0.839  1.00  0.00           N  
ATOM    790  CA  ARG A  51      -2.619   1.256  -1.679  1.00  0.00           C  
ATOM    791  C   ARG A  51      -2.416   0.121  -2.673  1.00  0.00           C  
ATOM    792  O   ARG A  51      -2.838  -1.009  -2.433  1.00  0.00           O  
ATOM    793  CB  ARG A  51      -1.346   1.447  -0.839  1.00  0.00           C  
ATOM    794  CG  ARG A  51      -0.895   0.188  -0.112  1.00  0.00           C  
ATOM    795  CD  ARG A  51       0.458   0.373   0.561  1.00  0.00           C  
ATOM    796  NE  ARG A  51       1.523   0.663  -0.404  1.00  0.00           N  
ATOM    797  CZ  ARG A  51       2.787   0.250  -0.277  1.00  0.00           C  
ATOM    798  NH1 ARG A  51       3.147  -0.511   0.752  1.00  0.00           N  
ATOM    799  NH2 ARG A  51       3.690   0.593  -1.186  1.00  0.00           N  
ATOM    800  H   ARG A  51      -3.764   0.171  -0.272  1.00  0.00           H  
ATOM    801  HA  ARG A  51      -2.822   2.166  -2.222  1.00  0.00           H  
ATOM    802  HB2 ARG A  51      -0.546   1.766  -1.488  1.00  0.00           H  
ATOM    803  HB3 ARG A  51      -1.526   2.215  -0.102  1.00  0.00           H  
ATOM    804  HG2 ARG A  51      -1.628  -0.063   0.642  1.00  0.00           H  
ATOM    805  HG3 ARG A  51      -0.822  -0.618  -0.828  1.00  0.00           H  
ATOM    806  HD2 ARG A  51       0.388   1.194   1.261  1.00  0.00           H  
ATOM    807  HD3 ARG A  51       0.705  -0.533   1.095  1.00  0.00           H  
ATOM    808  HE  ARG A  51       1.285   1.206  -1.189  1.00  0.00           H  
ATOM    809 HH11 ARG A  51       2.474  -0.790   1.442  1.00  0.00           H  
ATOM    810 HH12 ARG A  51       4.101  -0.811   0.849  1.00  0.00           H  
ATOM    811 HH21 ARG A  51       3.427   1.172  -1.978  1.00  0.00           H  
ATOM    812 HH22 ARG A  51       4.644   0.273  -1.098  1.00  0.00           H  
ATOM    813  N   SER A  52      -1.794   0.427  -3.790  1.00  0.00           N  
ATOM    814  CA  SER A  52      -1.467  -0.578  -4.770  1.00  0.00           C  
ATOM    815  C   SER A  52       0.040  -0.699  -4.891  1.00  0.00           C  
ATOM    816  O   SER A  52       0.783   0.071  -4.284  1.00  0.00           O  
ATOM    817  CB  SER A  52      -2.083  -0.206  -6.116  1.00  0.00           C  
ATOM    818  OG  SER A  52      -1.804  -1.171  -7.118  1.00  0.00           O  
ATOM    819  H   SER A  52      -1.553   1.360  -3.971  1.00  0.00           H  
ATOM    820  HA  SER A  52      -1.877  -1.517  -4.442  1.00  0.00           H  
ATOM    821  HB2 SER A  52      -3.146  -0.129  -5.999  1.00  0.00           H  
ATOM    822  HB3 SER A  52      -1.687   0.744  -6.429  1.00  0.00           H  
ATOM    823  HG  SER A  52      -2.368  -1.942  -6.988  1.00  0.00           H  
ATOM    824  N   LEU A  53       0.478  -1.673  -5.663  1.00  0.00           N  
ATOM    825  CA  LEU A  53       1.891  -1.831  -5.974  1.00  0.00           C  
ATOM    826  C   LEU A  53       2.180  -1.167  -7.308  1.00  0.00           C  
ATOM    827  O   LEU A  53       3.327  -1.051  -7.736  1.00  0.00           O  
ATOM    828  CB  LEU A  53       2.276  -3.311  -6.015  1.00  0.00           C  
ATOM    829  CG  LEU A  53       2.074  -4.072  -4.704  1.00  0.00           C  
ATOM    830  CD1 LEU A  53       2.444  -5.538  -4.876  1.00  0.00           C  
ATOM    831  CD2 LEU A  53       2.903  -3.446  -3.594  1.00  0.00           C  
ATOM    832  H   LEU A  53      -0.175  -2.298  -6.049  1.00  0.00           H  
ATOM    833  HA  LEU A  53       2.464  -1.333  -5.205  1.00  0.00           H  
ATOM    834  HB2 LEU A  53       1.688  -3.791  -6.783  1.00  0.00           H  
ATOM    835  HB3 LEU A  53       3.319  -3.380  -6.288  1.00  0.00           H  
ATOM    836  HG  LEU A  53       1.034  -4.020  -4.420  1.00  0.00           H  
ATOM    837 HD11 LEU A  53       1.826  -5.978  -5.646  1.00  0.00           H  
ATOM    838 HD12 LEU A  53       2.288  -6.061  -3.946  1.00  0.00           H  
ATOM    839 HD13 LEU A  53       3.481  -5.615  -5.164  1.00  0.00           H  
ATOM    840 HD21 LEU A  53       2.605  -2.418  -3.459  1.00  0.00           H  
ATOM    841 HD22 LEU A  53       3.948  -3.487  -3.859  1.00  0.00           H  
ATOM    842 HD23 LEU A  53       2.743  -3.988  -2.676  1.00  0.00           H  
ATOM    843  N   ASP A  54       1.105  -0.745  -7.959  1.00  0.00           N  
ATOM    844  CA  ASP A  54       1.183  -0.030  -9.227  1.00  0.00           C  
ATOM    845  C   ASP A  54       0.941   1.460  -9.006  1.00  0.00           C  
ATOM    846  O   ASP A  54       1.492   2.310  -9.709  1.00  0.00           O  
ATOM    847  CB  ASP A  54       0.141  -0.590 -10.198  1.00  0.00           C  
ATOM    848  CG  ASP A  54       0.045   0.200 -11.489  1.00  0.00           C  
ATOM    849  OD1 ASP A  54       0.842  -0.063 -12.415  1.00  0.00           O  
ATOM    850  OD2 ASP A  54      -0.849   1.067 -11.596  1.00  0.00           O  
ATOM    851  H   ASP A  54       0.222  -0.923  -7.572  1.00  0.00           H  
ATOM    852  HA  ASP A  54       2.170  -0.176  -9.638  1.00  0.00           H  
ATOM    853  HB2 ASP A  54       0.400  -1.609 -10.443  1.00  0.00           H  
ATOM    854  HB3 ASP A  54      -0.827  -0.577  -9.718  1.00  0.00           H  
ATOM    855  N   ALA A  55       0.127   1.763  -8.004  1.00  0.00           N  
ATOM    856  CA  ALA A  55      -0.245   3.131  -7.697  1.00  0.00           C  
ATOM    857  C   ALA A  55       0.007   3.428  -6.229  1.00  0.00           C  
ATOM    858  O   ALA A  55      -0.725   2.963  -5.353  1.00  0.00           O  
ATOM    859  CB  ALA A  55      -1.704   3.378  -8.055  1.00  0.00           C  
ATOM    860  H   ALA A  55      -0.214   1.045  -7.438  1.00  0.00           H  
ATOM    861  HA  ALA A  55       0.366   3.787  -8.298  1.00  0.00           H  
ATOM    862  HB1 ALA A  55      -1.865   3.146  -9.097  1.00  0.00           H  
ATOM    863  HB2 ALA A  55      -1.945   4.414  -7.875  1.00  0.00           H  
ATOM    864  HB3 ALA A  55      -2.335   2.749  -7.445  1.00  0.00           H  
ATOM    865  N   GLU A  56       1.071   4.169  -5.970  1.00  0.00           N  
ATOM    866  CA  GLU A  56       1.413   4.573  -4.616  1.00  0.00           C  
ATOM    867  C   GLU A  56       0.596   5.792  -4.202  1.00  0.00           C  
ATOM    868  O   GLU A  56      -0.078   6.402  -5.031  1.00  0.00           O  
ATOM    869  CB  GLU A  56       2.902   4.897  -4.518  1.00  0.00           C  
ATOM    870  CG  GLU A  56       3.807   3.758  -4.954  1.00  0.00           C  
ATOM    871  CD  GLU A  56       3.538   2.473  -4.198  1.00  0.00           C  
ATOM    872  OE1 GLU A  56       3.384   2.528  -2.959  1.00  0.00           O  
ATOM    873  OE2 GLU A  56       3.485   1.408  -4.838  1.00  0.00           O  
ATOM    874  H   GLU A  56       1.644   4.450  -6.711  1.00  0.00           H  
ATOM    875  HA  GLU A  56       1.185   3.752  -3.956  1.00  0.00           H  
ATOM    876  HB2 GLU A  56       3.115   5.753  -5.141  1.00  0.00           H  
ATOM    877  HB3 GLU A  56       3.137   5.140  -3.493  1.00  0.00           H  
ATOM    878  HG2 GLU A  56       3.653   3.574  -6.007  1.00  0.00           H  
ATOM    879  HG3 GLU A  56       4.833   4.048  -4.786  1.00  0.00           H  
ATOM    880  N   ALA A  57       0.674   6.148  -2.928  1.00  0.00           N  
ATOM    881  CA  ALA A  57      -0.043   7.304  -2.412  1.00  0.00           C  
ATOM    882  C   ALA A  57       0.870   8.522  -2.329  1.00  0.00           C  
ATOM    883  O   ALA A  57       1.813   8.552  -1.533  1.00  0.00           O  
ATOM    884  CB  ALA A  57      -0.635   6.991  -1.047  1.00  0.00           C  
ATOM    885  H   ALA A  57       1.230   5.619  -2.320  1.00  0.00           H  
ATOM    886  HA  ALA A  57      -0.856   7.523  -3.089  1.00  0.00           H  
ATOM    887  HB1 ALA A  57       0.159   6.751  -0.356  1.00  0.00           H  
ATOM    888  HB2 ALA A  57      -1.307   6.150  -1.130  1.00  0.00           H  
ATOM    889  HB3 ALA A  57      -1.179   7.851  -0.685  1.00  0.00           H  
ATOM    890  N   PRO A  58       0.627   9.531  -3.173  1.00  0.00           N  
ATOM    891  CA  PRO A  58       1.393  10.775  -3.161  1.00  0.00           C  
ATOM    892  C   PRO A  58       0.992  11.670  -1.994  1.00  0.00           C  
ATOM    893  O   PRO A  58      -0.147  12.134  -1.915  1.00  0.00           O  
ATOM    894  CB  PRO A  58       1.039  11.444  -4.500  1.00  0.00           C  
ATOM    895  CG  PRO A  58       0.208  10.450  -5.251  1.00  0.00           C  
ATOM    896  CD  PRO A  58      -0.397   9.542  -4.220  1.00  0.00           C  
ATOM    897  HA  PRO A  58       2.454  10.586  -3.118  1.00  0.00           H  
ATOM    898  HB2 PRO A  58       0.486  12.352  -4.313  1.00  0.00           H  
ATOM    899  HB3 PRO A  58       1.948  11.679  -5.034  1.00  0.00           H  
ATOM    900  HG2 PRO A  58      -0.569  10.962  -5.800  1.00  0.00           H  
ATOM    901  HG3 PRO A  58       0.835   9.886  -5.926  1.00  0.00           H  
ATOM    902  HD3 PRO A  58      -1.328   9.952  -3.852  1.00  0.00           H  
ATOM    903  HD2 PRO A  58      -0.547   8.553  -4.626  1.00  0.00           H  
ATOM    904  N   ALA A  59       1.921  11.899  -1.083  1.00  0.00           N  
ATOM    905  CA  ALA A  59       1.644  12.701   0.096  1.00  0.00           C  
ATOM    906  C   ALA A  59       2.758  13.707   0.343  1.00  0.00           C  
ATOM    907  O   ALA A  59       3.836  13.353   0.829  1.00  0.00           O  
ATOM    908  CB  ALA A  59       1.457  11.809   1.316  1.00  0.00           C  
ATOM    909  H   ALA A  59       2.819  11.526  -1.209  1.00  0.00           H  
ATOM    910  HA  ALA A  59       0.721  13.239  -0.076  1.00  0.00           H  
ATOM    911  HB1 ALA A  59       1.211  12.418   2.174  1.00  0.00           H  
ATOM    912  HB2 ALA A  59       2.371  11.269   1.508  1.00  0.00           H  
ATOM    913  HB3 ALA A  59       0.656  11.109   1.129  1.00  0.00           H  
ATOM    914  N   GLN A  60       2.507  14.956  -0.025  1.00  0.00           N  
ATOM    915  CA  GLN A  60       3.452  16.037   0.220  1.00  0.00           C  
ATOM    916  C   GLN A  60       2.713  17.238   0.799  1.00  0.00           C  
ATOM    917  O   GLN A  60       2.078  17.997   0.068  1.00  0.00           O  
ATOM    918  CB  GLN A  60       4.179  16.422  -1.071  1.00  0.00           C  
ATOM    919  CG  GLN A  60       4.993  15.288  -1.668  1.00  0.00           C  
ATOM    920  CD  GLN A  60       5.723  15.687  -2.934  1.00  0.00           C  
ATOM    921  OE1 GLN A  60       5.274  16.552  -3.686  1.00  0.00           O  
ATOM    922  NE2 GLN A  60       6.864  15.061  -3.174  1.00  0.00           N  
ATOM    923  H   GLN A  60       1.659  15.162  -0.475  1.00  0.00           H  
ATOM    924  HA  GLN A  60       4.174  15.690   0.947  1.00  0.00           H  
ATOM    925  HB2 GLN A  60       3.450  16.737  -1.803  1.00  0.00           H  
ATOM    926  HB3 GLN A  60       4.848  17.246  -0.861  1.00  0.00           H  
ATOM    927  HG2 GLN A  60       5.720  14.960  -0.940  1.00  0.00           H  
ATOM    928  HG3 GLN A  60       4.325  14.468  -1.900  1.00  0.00           H  
ATOM    929 HE21 GLN A  60       7.163  14.386  -2.531  1.00  0.00           H  
ATOM    930 HE22 GLN A  60       7.360  15.290  -3.987  1.00  0.00           H  
ATOM    931  N   PRO A  61       2.769  17.402   2.129  1.00  0.00           N  
ATOM    932  CA  PRO A  61       1.998  18.423   2.846  1.00  0.00           C  
ATOM    933  C   PRO A  61       2.446  19.850   2.535  1.00  0.00           C  
ATOM    934  O   PRO A  61       3.472  20.306   3.041  1.00  0.00           O  
ATOM    935  CB  PRO A  61       2.244  18.100   4.327  1.00  0.00           C  
ATOM    936  CG  PRO A  61       2.860  16.740   4.348  1.00  0.00           C  
ATOM    937  CD  PRO A  61       3.591  16.603   3.046  1.00  0.00           C  
ATOM    938  HA  PRO A  61       0.944  18.334   2.632  1.00  0.00           H  
ATOM    939  HB2 PRO A  61       2.913  18.837   4.746  1.00  0.00           H  
ATOM    940  HB3 PRO A  61       1.305  18.117   4.862  1.00  0.00           H  
ATOM    941  HG2 PRO A  61       3.549  16.663   5.175  1.00  0.00           H  
ATOM    942  HG3 PRO A  61       2.090  15.986   4.428  1.00  0.00           H  
ATOM    943  HD3 PRO A  61       4.590  17.009   3.130  1.00  0.00           H  
ATOM    944  HD2 PRO A  61       3.624  15.571   2.736  1.00  0.00           H  
ATOM    945  N   SER A  62       1.670  20.507   1.667  1.00  0.00           N  
ATOM    946  CA  SER A  62       1.800  21.933   1.337  1.00  0.00           C  
ATOM    947  C   SER A  62       3.242  22.444   1.329  1.00  0.00           C  
ATOM    948  O   SER A  62       3.772  22.880   2.354  1.00  0.00           O  
ATOM    949  CB  SER A  62       0.955  22.763   2.304  1.00  0.00           C  
ATOM    950  OG  SER A  62      -0.406  22.361   2.253  1.00  0.00           O  
ATOM    951  H   SER A  62       0.954  19.999   1.225  1.00  0.00           H  
ATOM    952  HA  SER A  62       1.394  22.065   0.345  1.00  0.00           H  
ATOM    953  HB2 SER A  62       1.324  22.624   3.311  1.00  0.00           H  
ATOM    954  HB3 SER A  62       1.018  23.808   2.035  1.00  0.00           H  
ATOM    955  HG  SER A  62      -0.662  22.227   1.334  1.00  0.00           H  
ATOM    956  N   LEU A  63       3.878  22.396   0.168  1.00  0.00           N  
ATOM    957  CA  LEU A  63       5.202  22.980   0.009  1.00  0.00           C  
ATOM    958  C   LEU A  63       5.058  24.468  -0.259  1.00  0.00           C  
ATOM    959  O   LEU A  63       4.905  24.896  -1.405  1.00  0.00           O  
ATOM    960  CB  LEU A  63       5.991  22.303  -1.122  1.00  0.00           C  
ATOM    961  CG  LEU A  63       6.523  20.895  -0.816  1.00  0.00           C  
ATOM    962  CD1 LEU A  63       5.392  19.885  -0.695  1.00  0.00           C  
ATOM    963  CD2 LEU A  63       7.507  20.461  -1.887  1.00  0.00           C  
ATOM    964  H   LEU A  63       3.447  21.968  -0.601  1.00  0.00           H  
ATOM    965  HA  LEU A  63       5.736  22.847   0.939  1.00  0.00           H  
ATOM    966  HB2 LEU A  63       5.349  22.239  -1.987  1.00  0.00           H  
ATOM    967  HB3 LEU A  63       6.833  22.933  -1.368  1.00  0.00           H  
ATOM    968  HG  LEU A  63       7.050  20.917   0.128  1.00  0.00           H  
ATOM    969 HD11 LEU A  63       4.819  19.876  -1.610  1.00  0.00           H  
ATOM    970 HD12 LEU A  63       4.749  20.161   0.128  1.00  0.00           H  
ATOM    971 HD13 LEU A  63       5.804  18.904  -0.518  1.00  0.00           H  
ATOM    972 HD21 LEU A  63       8.342  21.145  -1.909  1.00  0.00           H  
ATOM    973 HD22 LEU A  63       7.014  20.463  -2.850  1.00  0.00           H  
ATOM    974 HD23 LEU A  63       7.863  19.467  -1.667  1.00  0.00           H  
ATOM    975  N   GLU A  64       5.066  25.242   0.815  1.00  0.00           N  
ATOM    976  CA  GLU A  64       4.795  26.668   0.745  1.00  0.00           C  
ATOM    977  C   GLU A  64       5.444  27.395   1.917  1.00  0.00           C  
ATOM    978  O   GLU A  64       5.549  26.845   3.013  1.00  0.00           O  
ATOM    979  CB  GLU A  64       3.279  26.902   0.765  1.00  0.00           C  
ATOM    980  CG  GLU A  64       2.873  28.366   0.857  1.00  0.00           C  
ATOM    981  CD  GLU A  64       1.399  28.537   1.153  1.00  0.00           C  
ATOM    982  OE1 GLU A  64       0.971  28.201   2.278  1.00  0.00           O  
ATOM    983  OE2 GLU A  64       0.655  29.002   0.267  1.00  0.00           O  
ATOM    984  H   GLU A  64       5.260  24.841   1.690  1.00  0.00           H  
ATOM    985  HA  GLU A  64       5.202  27.047  -0.180  1.00  0.00           H  
ATOM    986  HB2 GLU A  64       2.853  26.492  -0.139  1.00  0.00           H  
ATOM    987  HB3 GLU A  64       2.859  26.382   1.614  1.00  0.00           H  
ATOM    988  HG2 GLU A  64       3.441  28.836   1.646  1.00  0.00           H  
ATOM    989  HG3 GLU A  64       3.096  28.848  -0.083  1.00  0.00           H  
ATOM    990  N   HIS A  65       5.889  28.623   1.677  1.00  0.00           N  
ATOM    991  CA  HIS A  65       6.372  29.475   2.751  1.00  0.00           C  
ATOM    992  C   HIS A  65       5.185  30.214   3.366  1.00  0.00           C  
ATOM    993  O   HIS A  65       4.869  31.348   2.995  1.00  0.00           O  
ATOM    994  CB  HIS A  65       7.427  30.458   2.234  1.00  0.00           C  
ATOM    995  CG  HIS A  65       8.081  31.274   3.307  1.00  0.00           C  
ATOM    996  ND1 HIS A  65       7.992  32.646   3.366  1.00  0.00           N  
ATOM    997  CD2 HIS A  65       8.848  30.904   4.360  1.00  0.00           C  
ATOM    998  CE1 HIS A  65       8.677  33.086   4.402  1.00  0.00           C  
ATOM    999  NE2 HIS A  65       9.205  32.050   5.023  1.00  0.00           N  
ATOM   1000  H   HIS A  65       5.889  28.962   0.756  1.00  0.00           H  
ATOM   1001  HA  HIS A  65       6.813  28.840   3.506  1.00  0.00           H  
ATOM   1002  HB2 HIS A  65       8.203  29.903   1.729  1.00  0.00           H  
ATOM   1003  HB3 HIS A  65       6.964  31.136   1.533  1.00  0.00           H  
ATOM   1004  HD1 HIS A  65       7.510  33.221   2.723  1.00  0.00           H  
ATOM   1005  HD2 HIS A  65       9.123  29.894   4.630  1.00  0.00           H  
ATOM   1006  HE1 HIS A  65       8.783  34.119   4.697  1.00  0.00           H  
ATOM   1007  HE2 HIS A  65       9.853  32.105   5.765  1.00  0.00           H  
ATOM   1008  N   HIS A  66       4.509  29.542   4.279  1.00  0.00           N  
ATOM   1009  CA  HIS A  66       3.267  30.043   4.844  1.00  0.00           C  
ATOM   1010  C   HIS A  66       3.530  30.809   6.132  1.00  0.00           C  
ATOM   1011  O   HIS A  66       4.281  30.352   6.994  1.00  0.00           O  
ATOM   1012  CB  HIS A  66       2.317  28.872   5.105  1.00  0.00           C  
ATOM   1013  CG  HIS A  66       0.940  29.270   5.538  1.00  0.00           C  
ATOM   1014  ND1 HIS A  66       0.529  29.248   6.852  1.00  0.00           N  
ATOM   1015  CD2 HIS A  66      -0.127  29.685   4.819  1.00  0.00           C  
ATOM   1016  CE1 HIS A  66      -0.732  29.627   6.921  1.00  0.00           C  
ATOM   1017  NE2 HIS A  66      -1.153  29.900   5.702  1.00  0.00           N  
ATOM   1018  H   HIS A  66       4.860  28.680   4.596  1.00  0.00           H  
ATOM   1019  HA  HIS A  66       2.818  30.709   4.123  1.00  0.00           H  
ATOM   1020  HB2 HIS A  66       2.220  28.292   4.199  1.00  0.00           H  
ATOM   1021  HB3 HIS A  66       2.738  28.246   5.878  1.00  0.00           H  
ATOM   1022  HD1 HIS A  66       1.088  28.990   7.626  1.00  0.00           H  
ATOM   1023  HD2 HIS A  66      -0.163  29.824   3.748  1.00  0.00           H  
ATOM   1024  HE1 HIS A  66      -1.320  29.707   7.825  1.00  0.00           H  
ATOM   1025  HE2 HIS A  66      -2.091  30.081   5.450  1.00  0.00           H  
ATOM   1026  N   HIS A  67       2.898  31.968   6.259  1.00  0.00           N  
ATOM   1027  CA  HIS A  67       3.045  32.801   7.443  1.00  0.00           C  
ATOM   1028  C   HIS A  67       2.404  32.125   8.654  1.00  0.00           C  
ATOM   1029  O   HIS A  67       1.271  31.652   8.588  1.00  0.00           O  
ATOM   1030  CB  HIS A  67       2.419  34.184   7.195  1.00  0.00           C  
ATOM   1031  CG  HIS A  67       2.351  35.064   8.408  1.00  0.00           C  
ATOM   1032  ND1 HIS A  67       3.321  35.987   8.736  1.00  0.00           N  
ATOM   1033  CD2 HIS A  67       1.406  35.159   9.371  1.00  0.00           C  
ATOM   1034  CE1 HIS A  67       2.973  36.609   9.847  1.00  0.00           C  
ATOM   1035  NE2 HIS A  67       1.814  36.126  10.250  1.00  0.00           N  
ATOM   1036  H   HIS A  67       2.295  32.268   5.541  1.00  0.00           H  
ATOM   1037  HA  HIS A  67       4.101  32.922   7.631  1.00  0.00           H  
ATOM   1038  HB2 HIS A  67       3.001  34.703   6.449  1.00  0.00           H  
ATOM   1039  HB3 HIS A  67       1.412  34.051   6.825  1.00  0.00           H  
ATOM   1040  HD1 HIS A  67       4.139  36.173   8.221  1.00  0.00           H  
ATOM   1041  HD2 HIS A  67       0.496  34.578   9.436  1.00  0.00           H  
ATOM   1042  HE1 HIS A  67       3.543  37.383  10.342  1.00  0.00           H  
ATOM   1043  HE2 HIS A  67       1.249  36.519  10.960  1.00  0.00           H  
ATOM   1044  N   HIS A  68       3.140  32.084   9.753  1.00  0.00           N  
ATOM   1045  CA  HIS A  68       2.655  31.462  10.979  1.00  0.00           C  
ATOM   1046  C   HIS A  68       2.925  32.355  12.185  1.00  0.00           C  
ATOM   1047  O   HIS A  68       3.257  33.533  12.023  1.00  0.00           O  
ATOM   1048  CB  HIS A  68       3.274  30.071  11.180  1.00  0.00           C  
ATOM   1049  CG  HIS A  68       4.761  29.995  10.980  1.00  0.00           C  
ATOM   1050  ND1 HIS A  68       5.673  30.096  12.009  1.00  0.00           N  
ATOM   1051  CD2 HIS A  68       5.489  29.789   9.858  1.00  0.00           C  
ATOM   1052  CE1 HIS A  68       6.893  29.956  11.523  1.00  0.00           C  
ATOM   1053  NE2 HIS A  68       6.811  29.764  10.221  1.00  0.00           N  
ATOM   1054  H   HIS A  68       4.036  32.498   9.744  1.00  0.00           H  
ATOM   1055  HA  HIS A  68       1.584  31.350  10.877  1.00  0.00           H  
ATOM   1056  HB2 HIS A  68       3.065  29.739  12.185  1.00  0.00           H  
ATOM   1057  HB3 HIS A  68       2.813  29.383  10.483  1.00  0.00           H  
ATOM   1058  HD1 HIS A  68       5.463  30.244  12.960  1.00  0.00           H  
ATOM   1059  HD2 HIS A  68       5.098  29.657   8.859  1.00  0.00           H  
ATOM   1060  HE1 HIS A  68       7.806  29.992  12.099  1.00  0.00           H  
ATOM   1061  HE2 HIS A  68       7.534  29.370   9.672  1.00  0.00           H  
ATOM   1062  N   HIS A  69       2.752  31.787  13.383  1.00  0.00           N  
ATOM   1063  CA  HIS A  69       2.921  32.501  14.656  1.00  0.00           C  
ATOM   1064  C   HIS A  69       1.749  33.446  14.921  1.00  0.00           C  
ATOM   1065  O   HIS A  69       1.158  33.428  16.001  1.00  0.00           O  
ATOM   1066  CB  HIS A  69       4.252  33.262  14.702  1.00  0.00           C  
ATOM   1067  CG  HIS A  69       4.575  33.842  16.047  1.00  0.00           C  
ATOM   1068  ND1 HIS A  69       4.874  33.071  17.148  1.00  0.00           N  
ATOM   1069  CD2 HIS A  69       4.648  35.129  16.463  1.00  0.00           C  
ATOM   1070  CE1 HIS A  69       5.118  33.855  18.179  1.00  0.00           C  
ATOM   1071  NE2 HIS A  69       4.991  35.111  17.791  1.00  0.00           N  
ATOM   1072  H   HIS A  69       2.493  30.839  13.416  1.00  0.00           H  
ATOM   1073  HA  HIS A  69       2.927  31.756  15.438  1.00  0.00           H  
ATOM   1074  HB2 HIS A  69       5.053  32.588  14.434  1.00  0.00           H  
ATOM   1075  HB3 HIS A  69       4.220  34.073  13.989  1.00  0.00           H  
ATOM   1076  HD1 HIS A  69       4.893  32.085  17.172  1.00  0.00           H  
ATOM   1077  HD2 HIS A  69       4.464  36.008  15.859  1.00  0.00           H  
ATOM   1078  HE1 HIS A  69       5.375  33.525  19.175  1.00  0.00           H  
ATOM   1079  HE2 HIS A  69       5.328  35.892  18.298  1.00  0.00           H  
ATOM   1080  N   HIS A  70       1.422  34.269  13.941  1.00  0.00           N  
ATOM   1081  CA  HIS A  70       0.290  35.174  14.049  1.00  0.00           C  
ATOM   1082  C   HIS A  70      -0.319  35.389  12.670  1.00  0.00           C  
ATOM   1083  O   HIS A  70      -1.032  34.486  12.194  1.00  0.00           O  
ATOM   1084  CB  HIS A  70       0.723  36.514  14.658  1.00  0.00           C  
ATOM   1085  CG  HIS A  70      -0.420  37.436  14.969  1.00  0.00           C  
ATOM   1086  ND1 HIS A  70      -0.914  38.357  14.070  1.00  0.00           N  
ATOM   1087  CD2 HIS A  70      -1.164  37.575  16.091  1.00  0.00           C  
ATOM   1088  CE1 HIS A  70      -1.908  39.021  14.625  1.00  0.00           C  
ATOM   1089  NE2 HIS A  70      -2.082  38.567  15.850  1.00  0.00           N  
ATOM   1090  OXT HIS A  70      -0.064  36.447  12.061  1.00  0.00           O  
ATOM   1091  H   HIS A  70       1.947  34.259  13.108  1.00  0.00           H  
ATOM   1092  HA  HIS A  70      -0.447  34.713  14.692  1.00  0.00           H  
ATOM   1093  HB2 HIS A  70       1.256  36.327  15.578  1.00  0.00           H  
ATOM   1094  HB3 HIS A  70       1.378  37.021  13.965  1.00  0.00           H  
ATOM   1095  HD1 HIS A  70      -0.591  38.495  13.149  1.00  0.00           H  
ATOM   1096  HD2 HIS A  70      -1.057  37.011  17.006  1.00  0.00           H  
ATOM   1097  HE1 HIS A  70      -2.481  39.807  14.157  1.00  0.00           H  
ATOM   1098  HE2 HIS A  70      -2.662  38.988  16.534  1.00  0.00           H  
TER    1099      HIS A  70                                                      
END
MOLECULE T0464.pdb
ATOM    289  N   LEU    18      -7.017 -12.593  -0.236  1.00 13.35           N 
ATOM    290  CA  LEU    18      -6.481 -11.452   0.518  1.00 23.42           C 
ATOM    291  C   LEU    18      -5.708 -11.929   1.763  1.00 62.24           C 
ATOM    292  O   LEU    18      -6.197 -12.763   2.529  1.00 14.32           O 
ATOM    293  CB  LEU    18      -7.649 -10.515   0.900  1.00 62.52           C 
ATOM    294  CG  LEU    18      -7.287  -9.117   1.464  1.00 41.20           C 
ATOM    295  CD1 LEU    18      -6.932  -9.176   2.950  1.00 70.34           C 
ATOM    296  CD2 LEU    18      -6.151  -8.484   0.661  1.00 64.45           C 
ATOM    297  H   LEU    18      -7.830 -13.038   0.092  1.00 37.77           H 
ATOM    298  HA  LEU    18      -5.800 -10.915  -0.131  1.00 64.31           H 
ATOM    299 3HB  LEU    18      -8.259 -11.025   1.634  1.00 37.77           H 
ATOM    300 2HB  LEU    18      -8.254 -10.364   0.016  1.00 37.77           H 
ATOM    301  HG  LEU    18      -8.151  -8.475   1.369  1.00 30.20           H 
ATOM    302 1HD1 LEU    18      -6.772  -8.173   3.322  1.00 37.77           H 
ATOM    303 2HD1 LEU    18      -6.033  -9.760   3.088  1.00 37.77           H 
ATOM    304 3HD1 LEU    18      -7.745  -9.636   3.498  1.00 37.77           H 
ATOM    305 1HD2 LEU    18      -6.441  -8.406  -0.376  1.00 37.77           H 
ATOM    306 2HD2 LEU    18      -5.262  -9.095   0.741  1.00 37.77           H 
ATOM    307 3HD2 LEU    18      -5.943  -7.497   1.048  1.00 37.77           H 
ATOM    308  N   SER    19      -4.497 -11.402   1.951  1.00 34.02           N 
ATOM    309  CA  SER    19      -3.650 -11.792   3.091  1.00 44.31           C 
ATOM    310  C   SER    19      -2.920 -10.590   3.700  1.00 41.31           C 
ATOM    311  O   SER    19      -3.014  -9.473   3.197  1.00 63.13           O 
ATOM    312  CB  SER    19      -2.614 -12.841   2.656  1.00 31.41           C 
ATOM    313  OG  SER    19      -3.236 -14.032   2.200  1.00  3.31           O 
ATOM    314  H   SER    19      -4.159 -10.743   1.307  1.00 37.77           H 
ATOM    315  HA  SER    19      -4.287 -12.227   3.848  1.00  2.32           H 
ATOM    316 3HB  SER    19      -1.976 -13.085   3.496  1.00 37.77           H 
ATOM    317 2HB  SER    19      -2.010 -12.439   1.856  1.00 37.77           H 
ATOM    318  HG  SER    19      -3.978 -14.247   2.776  1.00 63.25           H 
ATOM    319  N   LEU    20      -2.196 -10.829   4.792  1.00 41.43           N 
ATOM    320  CA  LEU    20      -1.401  -9.783   5.442  1.00 44.25           C 
ATOM    321  C   LEU    20      -0.137  -9.491   4.611  1.00 21.35           C 
ATOM    322  O   LEU    20       0.539 -10.412   4.145  1.00 54.01           O 
ATOM    323  CB  LEU    20      -1.022 -10.224   6.872  1.00 34.34           C 
ATOM    324  CG  LEU    20      -0.823  -9.097   7.907  1.00 45.24           C 
ATOM    325  CD1 LEU    20       0.321  -8.160   7.520  1.00 33.22           C 
ATOM    326  CD2 LEU    20      -2.120  -8.315   8.103  1.00 51.23           C 
ATOM    327  H   LEU    20      -2.201 -11.733   5.179  1.00 37.77           H 
ATOM    328  HA  LEU    20      -2.005  -8.888   5.494  1.00 43.02           H 
ATOM    329 3HB  LEU    20      -0.106 -10.796   6.816  1.00 37.77           H 
ATOM    330 2HB  LEU    20      -1.804 -10.877   7.239  1.00 37.77           H 
ATOM    331  HG  LEU    20      -0.565  -9.543   8.859  1.00 25.34           H 
ATOM    332 1HD1 LEU    20       1.237  -8.727   7.430  1.00 37.77           H 
ATOM    333 2HD1 LEU    20       0.443  -7.405   8.283  1.00 37.77           H 
ATOM    334 3HD1 LEU    20       0.096  -7.683   6.576  1.00 37.77           H 
ATOM    335 1HD2 LEU    20      -2.408  -7.851   7.170  1.00 37.77           H 
ATOM    336 2HD2 LEU    20      -1.974  -7.551   8.851  1.00 37.77           H 
ATOM    337 3HD2 LEU    20      -2.901  -8.988   8.424  1.00 37.77           H 
ATOM    338  N   LEU    21       0.177  -8.210   4.424  1.00 33.43           N 
ATOM    339  CA  LEU    21       1.339  -7.804   3.621  1.00  2.15           C 
ATOM    340  C   LEU    21       2.670  -8.232   4.267  1.00 50.31           C 
ATOM    341  O   LEU    21       2.969  -7.876   5.409  1.00  3.31           O 
ATOM    342  CB  LEU    21       1.315  -6.284   3.392  1.00  2.24           C 
ATOM    343  CG  LEU    21       2.482  -5.710   2.563  1.00 74.00           C 
ATOM    344  CD1 LEU    21       2.597  -6.409   1.209  1.00 75.40           C 
ATOM    345  CD2 LEU    21       2.312  -4.203   2.375  1.00 24.42           C 
ATOM    346  H   LEU    21      -0.381  -7.518   4.838  1.00 37.77           H 
ATOM    347  HA  LEU    21       1.253  -8.298   2.662  1.00 31.23           H 
ATOM    348 3HB  LEU    21       1.318  -5.799   4.358  1.00 37.77           H 
ATOM    349 2HB  LEU    21       0.390  -6.035   2.889  1.00 37.77           H 
ATOM    350  HG  LEU    21       3.407  -5.875   3.099  1.00 73.23           H 
ATOM    351 1HD1 LEU    21       3.442  -6.009   0.667  1.00 37.77           H 
ATOM    352 2HD1 LEU    21       1.695  -6.246   0.638  1.00 37.77           H 
ATOM    353 3HD1 LEU    21       2.737  -7.470   1.362  1.00 37.77           H 
ATOM    354 1HD2 LEU    21       3.130  -3.819   1.781  1.00 37.77           H 
ATOM    355 2HD2 LEU    21       2.311  -3.717   3.338  1.00 37.77           H 
ATOM    356 3HD2 LEU    21       1.377  -4.003   1.870  1.00 37.77           H 
ATOM    357  N   GLU    22       3.453  -9.009   3.520  1.00 23.44           N 
ATOM    358  CA  GLU    22       4.776  -9.459   3.972  1.00 42.51           C 
ATOM    359  C   GLU    22       5.773  -8.288   4.081  1.00 75.03           C 
ATOM    360  O   GLU    22       5.609  -7.256   3.423  1.00 24.24           O 
ATOM    361  CB  GLU    22       5.319 -10.531   3.012  1.00 22.41           C 
ATOM    362  CG  GLU    22       5.319 -10.106   1.544  1.00 34.41           C 
ATOM    363  CD  GLU    22       5.932 -11.151   0.623  1.00 45.23           C 
ATOM    364  OE1 GLU    22       6.842 -10.807  -0.160  1.00 42.22           O 
ATOM    365  OE2 GLU    22       5.513 -12.326   0.679  1.00 33.24           O 
ATOM    366  H   GLU    22       3.130  -9.299   2.644  1.00 37.77           H 
ATOM    367  HA  GLU    22       4.653  -9.901   4.952  1.00 32.12           H 
ATOM    368 3HB  GLU    22       4.715 -11.422   3.108  1.00 37.77           H 
ATOM    369 2HB  GLU    22       6.337 -10.768   3.297  1.00 37.77           H 
ATOM    370 3HG  GLU    22       5.879  -9.186   1.450  1.00 37.77           H 
ATOM    371 2HG  GLU    22       4.297  -9.933   1.234  1.00 37.77           H 
ATOM    372  N   SER    23       6.816  -8.470   4.893  1.00  1.21           N 
ATOM    373  CA  SER    23       7.819  -7.413   5.143  1.00 41.34           C 
ATOM    374  C   SER    23       8.411  -6.862   3.838  1.00 42.04           C 
ATOM    375  O   SER    23       8.589  -5.652   3.690  1.00  1.45           O 
ATOM    376  CB  SER    23       8.956  -7.941   6.030  1.00 11.21           C 
ATOM    377  OG  SER    23       9.718  -8.931   5.353  1.00 25.34           O 
ATOM    378  H   SER    23       6.916  -9.336   5.345  1.00 37.77           H 
ATOM    379  HA  SER    23       7.319  -6.607   5.663  1.00 22.33           H 
ATOM    380 3HB  SER    23       8.538  -8.375   6.926  1.00 37.77           H 
ATOM    381 2HB  SER    23       9.610  -7.125   6.298  1.00 37.77           H 
ATOM    382  HG  SER    23      10.641  -8.639   5.304  1.00 52.15           H 
ATOM    383  N   LYS    24       8.686  -7.760   2.889  1.00 62.33           N 
ATOM    384  CA  LYS    24       9.241  -7.387   1.576  1.00 41.22           C 
ATOM    385  C   LYS    24       8.396  -6.294   0.895  1.00 30.13           C 
ATOM    386  O   LYS    24       8.932  -5.311   0.377  1.00  1.41           O 
ATOM    387  CB  LYS    24       9.318  -8.637   0.681  1.00  2.54           C 
ATOM    388  CG  LYS    24       9.650  -8.355  -0.787  1.00 53.52           C 
ATOM    389  CD  LYS    24      11.029  -7.726  -0.967  1.00 44.52           C 
ATOM    390  CE  LYS    24      12.153  -8.653  -0.519  1.00 54.15           C 
ATOM    391  NZ  LYS    24      13.489  -8.078  -0.820  1.00 43.01           N 
ATOM    392  H   LYS    24       8.524  -8.707   3.081  1.00 37.77           H 
ATOM    393  HA  LYS    24      10.239  -7.006   1.736  1.00 24.35           H 
ATOM    394 3HB  LYS    24       8.366  -9.150   0.717  1.00 37.77           H 
ATOM    395 2HB  LYS    24      10.077  -9.297   1.074  1.00 37.77           H 
ATOM    396 3HG  LYS    24       8.902  -7.682  -1.186  1.00 37.77           H 
ATOM    397 2HG  LYS    24       9.619  -9.285  -1.334  1.00 37.77           H 
ATOM    398 3HD  LYS    24      11.076  -6.816  -0.384  1.00 37.77           H 
ATOM    399 2HD  LYS    24      11.172  -7.489  -2.010  1.00 37.77           H 
ATOM    400 3HE  LYS    24      12.053  -9.598  -1.033  1.00 37.77           H 
ATOM    401 2HE  LYS    24      12.072  -8.815   0.546  1.00 37.77           H 
ATOM    402 1HZ  LYS    24      13.588  -7.918  -1.843  1.00 37.77           H 
ATOM    403 2HZ  LYS    24      14.236  -8.724  -0.507  1.00 37.77           H 
ATOM    404 3HZ  LYS    24      13.607  -7.169  -0.327  1.00 37.77           H 
ATOM    405  N   GLY    25       7.080  -6.478   0.898  1.00 21.50           N 
ATOM    406  CA  GLY    25       6.184  -5.464   0.354  1.00 53.33           C 
ATOM    407  C   GLY    25       6.023  -4.263   1.284  1.00 14.32           C 
ATOM    408  O   GLY    25       6.089  -3.114   0.846  1.00 34.34           O 
ATOM    409  H   GLY    25       6.711  -7.304   1.274  1.00 37.77           H 
ATOM    410 3HA  GLY    25       5.213  -5.908   0.196  1.00 37.77           H 
ATOM    411 2HA  GLY    25       6.573  -5.123  -0.596  1.00 37.77           H 
ATOM    412  N   LEU    26       5.836  -4.538   2.573  1.00  3.24           N 
ATOM    413  CA  LEU    26       5.585  -3.494   3.577  1.00  1.01           C 
ATOM    414  C   LEU    26       6.667  -2.402   3.547  1.00 22.24           C 
ATOM    415  O   LEU    26       6.354  -1.205   3.538  1.00 53.41           O 
ATOM    416  CB  LEU    26       5.506  -4.118   4.977  1.00 50.14           C 
ATOM    417  CG  LEU    26       5.115  -3.151   6.112  1.00 62.53           C 
ATOM    418  CD1 LEU    26       3.724  -2.563   5.878  1.00 44.03           C 
ATOM    419  CD2 LEU    26       5.180  -3.857   7.466  1.00  1.11           C 
ATOM    420  H   LEU    26       5.869  -5.475   2.862  1.00 37.77           H 
ATOM    421  HA  LEU    26       4.634  -3.041   3.343  1.00 45.24           H 
ATOM    422 3HB  LEU    26       6.474  -4.541   5.212  1.00 37.77           H 
ATOM    423 2HB  LEU    26       4.782  -4.920   4.946  1.00 37.77           H 
ATOM    424  HG  LEU    26       5.820  -2.330   6.131  1.00 64.41           H 
ATOM    425 1HD1 LEU    26       3.002  -3.363   5.786  1.00 37.77           H 
ATOM    426 2HD1 LEU    26       3.724  -1.978   4.972  1.00 37.77           H 
ATOM    427 3HD1 LEU    26       3.454  -1.932   6.713  1.00 37.77           H 
ATOM    428 1HD2 LEU    26       4.472  -4.672   7.482  1.00 37.77           H 
ATOM    429 2HD2 LEU    26       4.940  -3.154   8.249  1.00 37.77           H 
ATOM    430 3HD2 LEU    26       6.176  -4.243   7.624  1.00 37.77           H 
ATOM    431  N   GLU    27       7.935  -2.810   3.517  1.00 40.23           N 
ATOM    432  CA  GLU    27       9.045  -1.856   3.430  1.00 72.40           C 
ATOM    433  C   GLU    27       8.974  -1.038   2.128  1.00 11.24           C 
ATOM    434  O   GLU    27       9.292   0.147   2.115  1.00 50.43           O 
ATOM    435  CB  GLU    27      10.399  -2.576   3.531  1.00  1.33           C 
ATOM    436  CG  GLU    27      10.608  -3.654   2.472  1.00 13.53           C 
ATOM    437  CD  GLU    27      11.993  -4.278   2.526  1.00 53.45           C 
ATOM    438  OE1 GLU    27      12.790  -4.047   1.591  1.00 62.44           O 
ATOM    439  OE2 GLU    27      12.298  -4.996   3.504  1.00 12.24           O 
ATOM    440  H   GLU    27       8.132  -3.772   3.551  1.00 37.77           H 
ATOM    441  HA  GLU    27       8.953  -1.173   4.265  1.00 43.30           H 
ATOM    442 3HB  GLU    27      10.473  -3.041   4.504  1.00 37.77           H 
ATOM    443 2HB  GLU    27      11.191  -1.848   3.431  1.00 37.77           H 
ATOM    444 3HG  GLU    27      10.464  -3.211   1.496  1.00 37.77           H 
ATOM    445 2HG  GLU    27       9.872  -4.433   2.619  1.00 37.77           H 
ATOM    446  N   ALA    28       8.520  -1.675   1.044  1.00 12.15           N 
ATOM    447  CA  ALA    28       8.411  -1.006  -0.259  1.00 20.21           C 
ATOM    448  C   ALA    28       7.339   0.092  -0.235  1.00 51.42           C 
ATOM    449  O   ALA    28       7.537   1.183  -0.777  1.00 61.01           O 
ATOM    450  CB  ALA    28       8.112  -2.021  -1.355  1.00 41.51           C 
ATOM    451  H   ALA    28       8.241  -2.613   1.124  1.00 37.77           H 
ATOM    452  HA  ALA    28       9.368  -0.551  -0.477  1.00 21.11           H 
ATOM    453 1HB  ALA    28       8.873  -2.788  -1.355  1.00 37.77           H 
ATOM    454 2HB  ALA    28       8.102  -1.525  -2.315  1.00 37.77           H 
ATOM    455 3HB  ALA    28       7.147  -2.475  -1.176  1.00 37.77           H 
ATOM    456  N   LEU    29       6.203  -0.204   0.401  1.00 50.24           N 
ATOM    457  CA  LEU    29       5.144   0.792   0.592  1.00 12.45           C 
ATOM    458  C   LEU    29       5.663   1.999   1.392  1.00 12.24           C 
ATOM    459  O   LEU    29       5.548   3.138   0.951  1.00 73.53           O 
ATOM    460  CB  LEU    29       3.928   0.168   1.304  1.00  4.23           C 
ATOM    461  CG  LEU    29       2.934  -0.593   0.402  1.00 14.24           C 
ATOM    462  CD1 LEU    29       2.252   0.356  -0.580  1.00  2.02           C 
ATOM    463  CD2 LEU    29       3.621  -1.735  -0.343  1.00 61.11           C 
ATOM    464  H   LEU    29       6.073  -1.115   0.744  1.00 37.77           H 
ATOM    465  HA  LEU    29       4.840   1.134  -0.388  1.00 75.11           H 
ATOM    466 3HB  LEU    29       3.385   0.960   1.802  1.00 37.77           H 
ATOM    467 2HB  LEU    29       4.291  -0.516   2.056  1.00 37.77           H 
ATOM    468  HG  LEU    29       2.162  -1.026   1.027  1.00 33.41           H 
ATOM    469 1HD1 LEU    29       1.551  -0.196  -1.191  1.00 37.77           H 
ATOM    470 2HD1 LEU    29       2.996   0.815  -1.214  1.00 37.77           H 
ATOM    471 3HD1 LEU    29       1.724   1.124  -0.031  1.00 37.77           H 
ATOM    472 1HD2 LEU    29       4.033  -2.435   0.368  1.00 37.77           H 
ATOM    473 2HD2 LEU    29       4.417  -1.339  -0.959  1.00 37.77           H 
ATOM    474 3HD2 LEU    29       2.902  -2.243  -0.969  1.00 37.77           H 
ATOM    475  N   ASN    30       6.258   1.733   2.559  1.00 22.22           N 
ATOM    476  CA  ASN    30       6.824   2.795   3.405  1.00 32.52           C 
ATOM    477  C   ASN    30       7.909   3.606   2.666  1.00 62.34           C 
ATOM    478  O   ASN    30       8.005   4.823   2.835  1.00 41.01           O 
ATOM    479  CB  ASN    30       7.387   2.202   4.705  1.00 35.41           C 
ATOM    480  CG  ASN    30       6.291   1.839   5.693  1.00  3.03           C 
ATOM    481  OD1 ASN    30       5.924   2.633   6.550  1.00 71.15           O 
ATOM    482  ND2 ASN    30       5.748   0.643   5.582  1.00 33.21           N 
ATOM    483  H   ASN    30       6.312   0.802   2.861  1.00 37.77           H 
ATOM    484  HA  ASN    30       6.016   3.470   3.656  1.00 31.31           H 
ATOM    485 3HB  ASN    30       8.040   2.927   5.172  1.00 37.77           H 
ATOM    486 2HB  ASN    30       7.951   1.311   4.475  1.00 37.77           H 
ATOM    487 1HD2 ASN    30       6.072   0.051   4.877  1.00 37.77           H 
ATOM    488 2HD2 ASN    30       5.037   0.403   6.215  1.00 37.77           H 
ATOM    489  N   LYS    31       8.722   2.932   1.852  1.00 11.24           N 
ATOM    490  CA  LYS    31       9.680   3.617   0.970  1.00  4.24           C 
ATOM    491  C   LYS    31       8.956   4.594   0.033  1.00  1.52           C 
ATOM    492  O   LYS    31       9.306   5.773  -0.065  1.00 14.24           O 
ATOM    493  CB  LYS    31      10.467   2.593   0.134  1.00 74.32           C 
ATOM    494  CG  LYS    31      11.504   1.793   0.917  1.00 32.24           C 
ATOM    495  CD  LYS    31      12.075   0.646   0.082  1.00 52.20           C 
ATOM    496  CE  LYS    31      13.200  -0.086   0.806  1.00 73.43           C 
ATOM    497  NZ  LYS    31      14.415   0.761   0.937  1.00 73.10           N 
ATOM    498  H   LYS    31       8.682   1.953   1.844  1.00 37.77           H 
ATOM    499  HA  LYS    31      10.370   4.173   1.589  1.00 64.32           H 
ATOM    500 3HB  LYS    31      10.977   3.115  -0.666  1.00 37.77           H 
ATOM    501 2HB  LYS    31       9.765   1.895  -0.300  1.00 37.77           H 
ATOM    502 3HG  LYS    31      11.037   1.386   1.804  1.00 37.77           H 
ATOM    503 2HG  LYS    31      12.312   2.452   1.204  1.00 37.77           H 
ATOM    504 3HD  LYS    31      12.457   1.047  -0.846  1.00 37.77           H 
ATOM    505 2HD  LYS    31      11.283  -0.059  -0.131  1.00 37.77           H 
ATOM    506 3HE  LYS    31      13.450  -0.975   0.248  1.00 37.77           H 
ATOM    507 2HE  LYS    31      12.859  -0.365   1.792  1.00 37.77           H 
ATOM    508 1HZ  LYS    31      14.182   1.655   1.410  1.00 37.77           H 
ATOM    509 2HZ  LYS    31      14.809   0.974  -0.003  1.00 37.77           H 
ATOM    510 3HZ  LYS    31      15.138   0.265   1.495  1.00 37.77           H 
ATOM    511  N   ALA    32       7.925   4.088  -0.640  1.00 20.01           N 
ATOM    512  CA  ALA    32       7.148   4.879  -1.595  1.00 32.51           C 
ATOM    513  C   ALA    32       6.358   6.009  -0.909  1.00 11.23           C 
ATOM    514  O   ALA    32       6.135   7.067  -1.505  1.00  2.53           O 
ATOM    515  CB  ALA    32       6.212   3.961  -2.369  1.00 31.32           C 
ATOM    516  H   ALA    32       7.676   3.150  -0.488  1.00 37.77           H 
ATOM    517  HA  ALA    32       7.842   5.318  -2.302  1.00 62.34           H 
ATOM    518 1HB  ALA    32       5.506   3.507  -1.689  1.00 37.77           H 
ATOM    519 2HB  ALA    32       6.786   3.188  -2.857  1.00 37.77           H 
ATOM    520 3HB  ALA    32       5.675   4.531  -3.114  1.00 37.77           H 
ATOM    521  N   ILE    33       5.929   5.777   0.331  1.00 22.44           N 
ATOM    522  CA  ILE    33       5.201   6.788   1.108  1.00 62.10           C 
ATOM    523  C   ILE    33       6.112   7.976   1.463  1.00 73.41           C 
ATOM    524  O   ILE    33       5.753   9.131   1.238  1.00 54.24           O 
ATOM    525  CB  ILE    33       4.599   6.180   2.406  1.00 64.04           C 
ATOM    526  CG1 ILE    33       3.531   5.128   2.060  1.00  3.33           C 
ATOM    527  CG2 ILE    33       4.002   7.273   3.294  1.00 30.34           C 
ATOM    528  CD1 ILE    33       2.952   4.412   3.263  1.00 55.55           C 
ATOM    529  H   ILE    33       6.102   4.901   0.735  1.00 37.77           H 
ATOM    530  HA  ILE    33       4.384   7.148   0.494  1.00 10.10           H 
ATOM    531  HB  ILE    33       5.399   5.701   2.955  1.00 22.00           H 
ATOM    532 3HG1 ILE    33       3.966   4.382   1.408  1.00 37.77           H 
ATOM    533 2HG1 ILE    33       2.715   5.610   1.544  1.00 37.77           H 
ATOM    534 1HG2 ILE    33       3.215   7.788   2.759  1.00 37.77           H 
ATOM    535 2HG2 ILE    33       4.773   7.984   3.563  1.00 37.77           H 
ATOM    536 3HG2 ILE    33       3.597   6.830   4.192  1.00 37.77           H 
ATOM    537 1HD1 ILE    33       3.743   3.903   3.795  1.00 37.77           H 
ATOM    538 2HD1 ILE    33       2.217   3.692   2.934  1.00 37.77           H 
ATOM    539 3HD1 ILE    33       2.481   5.131   3.919  1.00 37.77           H 
ATOM    540  N   VAL    34       7.302   7.684   1.995  1.00 52.01           N 
ATOM    541  CA  VAL    34       8.286   8.730   2.296  1.00 31.35           C 
ATOM    542  C   VAL    34       8.704   9.461   1.010  1.00 64.01           C 
ATOM    543  O   VAL    34       9.001  10.656   1.014  1.00 15.40           O 
ATOM    544  CB  VAL    34       9.540   8.138   2.992  1.00  1.50           C 
ATOM    545  CG1 VAL    34      10.582   9.224   3.266  1.00  0.14           C 
ATOM    546  CG2 VAL    34       9.149   7.427   4.288  1.00 14.41           C 
ATOM    547  H   VAL    34       7.524   6.747   2.181  1.00 37.77           H 
ATOM    548  HA  VAL    34       7.822   9.441   2.969  1.00 22.01           H 
ATOM    549  HB  VAL    34       9.984   7.409   2.329  1.00 15.22           H 
ATOM    550 1HG1 VAL    34      11.434   8.790   3.770  1.00 37.77           H 
ATOM    551 2HG1 VAL    34      10.150   9.994   3.889  1.00 37.77           H 
ATOM    552 3HG1 VAL    34      10.904   9.661   2.330  1.00 37.77           H 
ATOM    553 1HG2 VAL    34       8.448   6.638   4.067  1.00 37.77           H 
ATOM    554 2HG2 VAL    34       8.692   8.134   4.967  1.00 37.77           H 
ATOM    555 3HG2 VAL    34      10.030   7.006   4.749  1.00 37.77           H 
ATOM    556  N   SER    35       8.714   8.719  -0.096  1.00 35.22           N 
ATOM    557  CA  SER    35       8.977   9.296  -1.422  1.00 21.31           C 
ATOM    558  C   SER    35       7.790  10.132  -1.920  1.00 63.04           C 
ATOM    559  O   SER    35       7.960  11.063  -2.709  1.00 31.00           O 
ATOM    560  CB  SER    35       9.279   8.189  -2.435  1.00 52.15           C 
ATOM    561  OG  SER    35       9.487   8.724  -3.733  1.00 71.55           O 
ATOM    562  H   SER    35       8.553   7.754  -0.018  1.00 37.77           H 
ATOM    563  HA  SER    35       9.843   9.940  -1.338  1.00 61.42           H 
ATOM    564 3HB  SER    35       8.449   7.498  -2.474  1.00 37.77           H 
ATOM    565 2HB  SER    35      10.169   7.658  -2.129  1.00 37.77           H 
ATOM    566  HG  SER    35      10.194   8.235  -4.172  1.00 53.32           H 
ATOM    567  N   GLY    36       6.589   9.791  -1.462  1.00 61.21           N 
ATOM    568  CA  GLY    36       5.385  10.510  -1.874  1.00 41.15           C 
ATOM    569  C   GLY    36       4.904  10.142  -3.276  1.00 32.33           C 
ATOM    570  O   GLY    36       4.314  10.966  -3.976  1.00 53.32           O 
ATOM    571  H   GLY    36       6.515   9.053  -0.821  1.00 37.77           H 
ATOM    572 3HA  GLY    36       5.589  11.571  -1.845  1.00 37.77           H 
ATOM    573 2HA  GLY    36       4.595  10.293  -1.170  1.00 37.77           H 
ATOM    574  N   THR    37       5.151   8.902  -3.695  1.00  1.41           N 
ATOM    575  CA  THR    37       4.718   8.434  -5.028  1.00 23.43           C 
ATOM    576  C   THR    37       3.472   7.539  -4.941  1.00 42.33           C 
ATOM    577  O   THR    37       2.971   7.055  -5.957  1.00  2.43           O 
ATOM    578  CB  THR    37       5.850   7.667  -5.761  1.00 52.23           C 
ATOM    579  OG1 THR    37       5.422   7.254  -7.073  1.00 63.45           O 
ATOM    580  CG2 THR    37       6.301   6.446  -4.963  1.00 22.13           C 
ATOM    581  H   THR    37       5.641   8.289  -3.105  1.00 37.77           H 
ATOM    582  HA  THR    37       4.469   9.307  -5.621  1.00 41.55           H 
ATOM    583  HB  THR    37       6.696   8.332  -5.868  1.00 11.50           H 
ATOM    584  HG1 THR    37       4.634   6.699  -7.000  1.00 12.23           H 
ATOM    585 1HG2 THR    37       7.086   5.932  -5.501  1.00 37.77           H 
ATOM    586 2HG2 THR    37       5.464   5.778  -4.820  1.00 37.77           H 
ATOM    587 3HG2 THR    37       6.677   6.763  -3.998  1.00 37.77           H 
ATOM    588  N   VAL    38       2.969   7.329  -3.727  1.00  0.22           N 
ATOM    589  CA  VAL    38       1.796   6.471  -3.509  1.00 33.42           C 
ATOM    590  C   VAL    38       0.486   7.239  -3.733  1.00 75.42           C 
ATOM    591  O   VAL    38       0.149   8.146  -2.969  1.00 62.21           O 
ATOM    592  CB  VAL    38       1.771   5.881  -2.078  1.00 55.21           C 
ATOM    593  CG1 VAL    38       0.601   4.915  -1.909  1.00  2.32           C 
ATOM    594  CG2 VAL    38       3.089   5.192  -1.750  1.00  5.34           C 
ATOM    595  H   VAL    38       3.388   7.764  -2.957  1.00 37.77           H 
ATOM    596  HA  VAL    38       1.845   5.650  -4.212  1.00 15.41           H 
ATOM    597  HB  VAL    38       1.636   6.696  -1.379  1.00  4.23           H 
ATOM    598 1HG1 VAL    38      -0.329   5.440  -2.077  1.00 37.77           H 
ATOM    599 2HG1 VAL    38       0.606   4.510  -0.908  1.00 37.77           H 
ATOM    600 3HG1 VAL    38       0.690   4.106  -2.622  1.00 37.77           H 
ATOM    601 1HG2 VAL    38       3.896   5.909  -1.810  1.00 37.77           H 
ATOM    602 2HG2 VAL    38       3.267   4.392  -2.454  1.00 37.77           H 
ATOM    603 3HG2 VAL    38       3.044   4.785  -0.748  1.00 37.77           H 
ATOM    604  N   GLN    39      -0.250   6.869  -4.779  1.00 32.42           N 
ATOM    605  CA  GLN    39      -1.560   7.466  -5.053  1.00 13.34           C 
ATOM    606  C   GLN    39      -2.697   6.512  -4.658  1.00 24.11           C 
ATOM    607  O   GLN    39      -2.919   5.493  -5.313  1.00 61.13           O 
ATOM    608  CB  GLN    39      -1.699   7.834  -6.539  1.00 62.20           C 
ATOM    609  CG  GLN    39      -0.705   8.886  -7.019  1.00 22.54           C 
ATOM    610  CD  GLN    39      -0.977   9.347  -8.444  1.00 32.40           C 
ATOM    611  OE1 GLN    39      -1.486   8.596  -9.272  1.00 13.23           O 
ATOM    612  NE2 GLN    39      -0.639  10.585  -8.741  1.00 61.13           N 
ATOM    613  H   GLN    39       0.094   6.176  -5.378  1.00 37.77           H 
ATOM    614  HA  GLN    39      -1.644   8.369  -4.463  1.00 65.15           H 
ATOM    615 3HB  GLN    39      -2.700   8.209  -6.711  1.00 37.77           H 
ATOM    616 2HB  GLN    39      -1.557   6.940  -7.133  1.00 37.77           H 
ATOM    617 3HG  GLN    39       0.291   8.471  -6.977  1.00 37.77           H 
ATOM    618 2HG  GLN    39      -0.763   9.743  -6.365  1.00 37.77           H 
ATOM    619 1HE2 GLN    39      -0.235  11.137  -8.043  1.00 37.77           H 
ATOM    620 2HE2 GLN    39      -0.812  10.903  -9.652  1.00 37.77           H 
ATOM    621  N   ARG    40      -3.409   6.840  -3.580  1.00 42.25           N 
ATOM    622  CA  ARG    40      -4.592   6.065  -3.183  1.00  1.55           C 
ATOM    623  C   ARG    40      -5.710   6.214  -4.231  1.00 43.23           C 
ATOM    624  O   ARG    40      -5.623   7.067  -5.115  1.00 61.32           O 
ATOM    625  CB  ARG    40      -5.084   6.504  -1.794  1.00 71.14           C 
ATOM    626  CG  ARG    40      -5.356   8.005  -1.669  1.00 32.01           C 
ATOM    627  CD  ARG    40      -5.893   8.365  -0.284  1.00  2.15           C 
ATOM    628  NE  ARG    40      -7.180   7.727  -0.023  1.00  2.43           N 
ATOM    629  CZ  ARG    40      -7.677   7.504   1.162  1.00 60.21           C 
ATOM    630  NH1 ARG    40      -7.050   7.857   2.235  1.00 62.13           N 
ATOM    631  NH2 ARG    40      -8.827   6.931   1.267  1.00 45.23           N 
ATOM    632  H   ARG    40      -3.135   7.615  -3.045  1.00 37.77           H 
ATOM    633  HA  ARG    40      -4.299   5.023  -3.139  1.00 42.44           H 
ATOM    634 3HB  ARG    40      -4.338   6.233  -1.061  1.00 37.77           H 
ATOM    635 2HB  ARG    40      -6.000   5.977  -1.568  1.00 37.77           H 
ATOM    636 3HG  ARG    40      -6.085   8.293  -2.415  1.00 37.77           H 
ATOM    637 2HG  ARG    40      -4.435   8.543  -1.839  1.00 37.77           H 
ATOM    638 3HD  ARG    40      -6.014   9.439  -0.223  1.00 37.77           H 
ATOM    639 2HD  ARG    40      -5.181   8.041   0.463  1.00 37.77           H 
ATOM    640  HE  ARG    40      -7.709   7.444  -0.796  1.00 53.45           H 
ATOM    641 1HH1 ARG    40      -6.170   8.312   2.172  1.00 37.77           H 
ATOM    642 2HH1 ARG    40      -7.453   7.654   3.126  1.00 37.77           H 
ATOM    643 1HH2 ARG    40      -9.324   6.668   0.444  1.00 37.77           H 
ATOM    644 2HH2 ARG    40      -9.214   6.742   2.170  1.00 37.77           H 
ATOM    645  N   ALA    41      -6.759   5.392  -4.127  1.00 45.45           N 
ATOM    646  CA  ALA    41      -7.856   5.381  -5.116  1.00 33.12           C 
ATOM    647  C   ALA    41      -8.412   6.788  -5.422  1.00 62.33           C 
ATOM    648  O   ALA    41      -8.803   7.080  -6.552  1.00 44.42           O 
ATOM    649  CB  ALA    41      -8.978   4.466  -4.638  1.00 64.21           C 
ATOM    650  H   ALA    41      -6.794   4.763  -3.373  1.00 37.77           H 
ATOM    651  HA  ALA    41      -7.460   4.964  -6.032  1.00 30.21           H 
ATOM    652 1HB  ALA    41      -9.437   4.891  -3.760  1.00 37.77           H 
ATOM    653 2HB  ALA    41      -8.576   3.492  -4.399  1.00 37.77           H 
ATOM    654 3HB  ALA    41      -9.720   4.366  -5.417  1.00 37.77           H 
ATOM    655  N   ASP    42      -8.433   7.658  -4.415  1.00 72.23           N 
ATOM    656  CA  ASP    42      -8.941   9.030  -4.574  1.00 54.15           C 
ATOM    657  C   ASP    42      -8.041   9.898  -5.482  1.00  3.35           C 
ATOM    658  O   ASP    42      -8.375  11.046  -5.785  1.00 22.51           O 
ATOM    659  CB  ASP    42      -9.068   9.688  -3.199  1.00 63.02           C 
ATOM    660  CG  ASP    42      -9.870   8.837  -2.237  1.00 53.11           C 
ATOM    661  OD1 ASP    42      -9.316   7.849  -1.723  1.00 64.32           O 
ATOM    662  OD2 ASP    42     -11.053   9.149  -1.993  1.00 15.20           O 
ATOM    663  H   ASP    42      -8.122   7.367  -3.533  1.00 37.77           H 
ATOM    664  HA  ASP    42      -9.925   8.966  -5.019  1.00  1.24           H 
ATOM    665 3HB  ASP    42      -9.557  10.646  -3.305  1.00 37.77           H 
ATOM    666 2HB  ASP    42      -8.080   9.837  -2.782  1.00 37.77           H 
ATOM    667  N   GLY    43      -6.908   9.347  -5.911  1.00 32.33           N 
ATOM    668  CA  GLY    43      -5.950  10.102  -6.717  1.00 53.41           C 
ATOM    669  C   GLY    43      -5.069  11.030  -5.880  1.00 50.23           C 
ATOM    670  O   GLY    43      -4.466  11.966  -6.403  1.00 11.54           O 
ATOM    671  H   GLY    43      -6.723   8.412  -5.694  1.00 37.77           H 
ATOM    672 3HA  GLY    43      -6.490  10.693  -7.443  1.00 37.77           H 
ATOM    673 2HA  GLY    43      -5.313   9.406  -7.243  1.00 37.77           H 
ATOM    674  N   SER    44      -4.993  10.763  -4.577  1.00 10.42           N 
ATOM    675  CA  SER    44      -4.214  11.601  -3.649  1.00  4.34           C 
ATOM    676  C   SER    44      -2.972  10.865  -3.127  1.00  4.33           C 
ATOM    677  O   SER    44      -2.886   9.639  -3.213  1.00 34.41           O 
ATOM    678  CB  SER    44      -5.086  12.041  -2.471  1.00 72.21           C 
ATOM    679  OG  SER    44      -4.354  12.841  -1.558  1.00 15.51           O 
ATOM    680  H   SER    44      -5.463   9.980  -4.227  1.00 37.77           H 
ATOM    681  HA  SER    44      -3.890  12.483  -4.187  1.00 14.43           H 
ATOM    682 3HB  SER    44      -5.452  11.169  -1.948  1.00 37.77           H 
ATOM    683 2HB  SER    44      -5.924  12.616  -2.839  1.00 37.77           H 
ATOM    684  HG  SER    44      -4.930  13.105  -0.831  1.00 32.44           H 
ATOM    685  N   ILE    45      -2.031  11.619  -2.560  1.00 21.25           N 
ATOM    686  CA  ILE    45      -0.742  11.068  -2.116  1.00 63.21           C 
ATOM    687  C   ILE    45      -0.748  10.723  -0.618  1.00 50.21           C 
ATOM    688  O   ILE    45      -1.248  11.489   0.205  1.00 14.21           O 
ATOM    689  CB  ILE    45       0.409  12.071  -2.395  1.00  4.41           C 
ATOM    690  CG1 ILE    45       0.511  12.364  -3.901  1.00 40.44           C 
ATOM    691  CG2 ILE    45       1.740  11.541  -1.855  1.00 32.25           C 
ATOM    692  CD1 ILE    45       0.836  11.147  -4.745  1.00 31.01           C 
ATOM    693  H   ILE    45      -2.212  12.573  -2.417  1.00 37.77           H 
ATOM    694  HA  ILE    45      -0.548  10.167  -2.681  1.00 20.32           H 
ATOM    695  HB  ILE    45       0.184  12.990  -1.875  1.00 74.41           H 
ATOM    696 3HG1 ILE    45       1.284  13.101  -4.068  1.00 37.77           H 
ATOM    697 2HG1 ILE    45      -0.433  12.761  -4.249  1.00 37.77           H 
ATOM    698 1HG2 ILE    45       1.674  11.420  -0.783  1.00 37.77           H 
ATOM    699 2HG2 ILE    45       2.529  12.242  -2.087  1.00 37.77           H 
ATOM    700 3HG2 ILE    45       1.964  10.588  -2.313  1.00 37.77           H 
ATOM    701 1HD1 ILE    45       0.824  11.420  -5.791  1.00 37.77           H 
ATOM    702 2HD1 ILE    45       0.101  10.376  -4.565  1.00 37.77           H 
ATOM    703 3HD1 ILE    45       1.818  10.778  -4.481  1.00 37.77           H 
ATOM    704  N   GLN    46      -0.189   9.563  -0.272  1.00 72.53           N 
ATOM    705  CA  GLN    46      -0.065   9.156   1.133  1.00 74.45           C 
ATOM    706  C   GLN    46       1.277   9.592   1.739  1.00 40.35           C 
ATOM    707  O   GLN    46       2.343   9.243   1.233  1.00  2.54           O 
ATOM    708  CB  GLN    46      -0.215   7.636   1.279  1.00 70.25           C 
ATOM    709  CG  GLN    46      -1.603   7.113   0.939  1.00  5.24           C 
ATOM    710  CD  GLN    46      -1.742   5.621   1.196  1.00  2.45           C 
ATOM    711  OE1 GLN    46      -1.477   4.809   0.328  1.00 54.02           O 
ATOM    712  NE2 GLN    46      -2.153   5.250   2.393  1.00 15.23           N 
ATOM    713  H   GLN    46       0.147   8.967  -0.976  1.00 37.77           H 
ATOM    714  HA  GLN    46      -0.862   9.636   1.685  1.00  1.21           H 
ATOM    715 3HB  GLN    46       0.005   7.361   2.302  1.00 37.77           H 
ATOM    716 2HB  GLN    46       0.497   7.152   0.627  1.00 37.77           H 
ATOM    717 3HG  GLN    46      -1.799   7.300  -0.109  1.00 37.77           H 
ATOM    718 2HG  GLN    46      -2.332   7.636   1.539  1.00 37.77           H 
ATOM    719 1HE2 GLN    46      -2.352   5.945   3.052  1.00 37.77           H 
ATOM    720 2HE2 GLN    46      -2.240   4.293   2.568  1.00 37.77           H 
ATOM    721  N   ASN    47       1.209  10.358   2.826  1.00 72.43           N 
ATOM    722  CA  ASN    47       2.401  10.748   3.590  1.00 61.21           C 
ATOM    723  C   ASN    47       2.430  10.031   4.951  1.00 10.34           C 
ATOM    724  O   ASN    47       3.380  10.164   5.724  1.00 60.34           O 
ATOM    725  CB  ASN    47       2.426  12.268   3.797  1.00 24.03           C 
ATOM    726  CG  ASN    47       2.453  13.030   2.484  1.00 70.21           C 
ATOM    727  OD1 ASN    47       1.416  13.361   1.922  1.00 21.42           O 
ATOM    728  ND2 ASN    47       3.638  13.313   1.984  1.00 22.22           N 
ATOM    729  H   ASN    47       0.334  10.685   3.117  1.00 37.77           H 
ATOM    730  HA  ASN    47       3.275  10.455   3.026  1.00 42.15           H 
ATOM    731 3HB  ASN    47       3.304  12.537   4.367  1.00 37.77           H 
ATOM    732 2HB  ASN    47       1.542  12.566   4.344  1.00 37.77           H 
ATOM    733 1HD2 ASN    47       4.430  13.023   2.475  1.00 37.77           H 
ATOM    734 2HD2 ASN    47       3.673  13.801   1.134  1.00 37.77           H 
ATOM    735  N   GLN    48       1.377   9.266   5.233  1.00  1.14           N 
ATOM    736  CA  GLN    48       1.258   8.524   6.492  1.00  3.50           C 
ATOM    737  C   GLN    48       1.853   7.110   6.359  1.00 22.11           C 
ATOM    738  O   GLN    48       1.254   6.229   5.734  1.00 33.42           O 
ATOM    739  CB  GLN    48      -0.222   8.442   6.900  1.00 72.14           C 
ATOM    740  CG  GLN    48      -0.897   9.808   7.019  1.00 42.12           C 
ATOM    741  CD  GLN    48      -2.390   9.714   7.289  1.00 71.35           C 
ATOM    742  OE1 GLN    48      -2.864   8.772   7.916  1.00 65.53           O 
ATOM    743  NE2 GLN    48      -3.142  10.689   6.823  1.00 72.14           N 
ATOM    744  H   GLN    48       0.657   9.194   4.573  1.00 37.77           H 
ATOM    745  HA  GLN    48       1.803   9.064   7.255  1.00 61.31           H 
ATOM    746 3HB  GLN    48      -0.291   7.945   7.857  1.00 37.77           H 
ATOM    747 2HB  GLN    48      -0.757   7.860   6.162  1.00 37.77           H 
ATOM    748 3HG  GLN    48      -0.745  10.351   6.096  1.00 37.77           H 
ATOM    749 2HG  GLN    48      -0.435  10.353   7.830  1.00 37.77           H 
ATOM    750 1HE2 GLN    48      -2.708  11.418   6.335  1.00 37.77           H 
ATOM    751 2HE2 GLN    48      -4.108  10.643   6.980  1.00 37.77           H 
ATOM    752  N   SER    49       3.040   6.902   6.929  1.00 51.53           N 
ATOM    753  CA  SER    49       3.725   5.601   6.857  1.00  5.42           C 
ATOM    754  C   SER    49       3.041   4.546   7.738  1.00 33.42           C 
ATOM    755  O   SER    49       3.308   4.451   8.940  1.00 33.04           O 
ATOM    756  CB  SER    49       5.204   5.736   7.262  1.00 31.21           C 
ATOM    757  OG  SER    49       5.922   6.557   6.350  1.00 21.44           O 
ATOM    758  H   SER    49       3.468   7.639   7.409  1.00 37.77           H 
ATOM    759  HA  SER    49       3.680   5.268   5.829  1.00  5.01           H 
ATOM    760 3HB  SER    49       5.660   4.756   7.279  1.00 37.77           H 
ATOM    761 2HB  SER    49       5.268   6.176   8.245  1.00 37.77           H 
ATOM    762  HG  SER    49       6.524   6.007   5.834  1.00 53.22           H 
ATOM    763  N   LEU    50       2.149   3.760   7.132  1.00 33.22           N 
ATOM    764  CA  LEU    50       1.419   2.710   7.858  1.00 31.11           C 
ATOM    765  C   LEU    50       2.353   1.590   8.357  1.00 10.45           C 
ATOM    766  O   LEU    50       3.299   1.188   7.672  1.00 11.54           O 
ATOM    767  CB  LEU    50       0.272   2.142   6.989  1.00 32.13           C 
ATOM    768  CG  LEU    50       0.601   1.847   5.506  1.00 62.21           C 
ATOM    769  CD1 LEU    50       1.494   0.614   5.351  1.00 61.10           C 
ATOM    770  CD2 LEU    50      -0.684   1.683   4.696  1.00  3.51           C 
ATOM    771  H   LEU    50       1.973   3.891   6.179  1.00 37.77           H 
ATOM    772  HA  LEU    50       0.978   3.184   8.727  1.00 53.54           H 
ATOM    773 3HB  LEU    50      -0.544   2.855   7.011  1.00 37.77           H 
ATOM    774 2HB  LEU    50      -0.074   1.226   7.445  1.00 37.77           H 
ATOM    775  HG  LEU    50       1.140   2.690   5.098  1.00 43.31           H 
ATOM    776 1HD1 LEU    50       1.682   0.436   4.303  1.00 37.77           H 
ATOM    777 2HD1 LEU    50       1.000  -0.247   5.779  1.00 37.77           H 
ATOM    778 3HD1 LEU    50       2.431   0.780   5.861  1.00 37.77           H 
ATOM    779 1HD2 LEU    50      -0.437   1.506   3.659  1.00 37.77           H 
ATOM    780 2HD2 LEU    50      -1.278   2.582   4.775  1.00 37.77           H 
ATOM    781 3HD2 LEU    50      -1.250   0.844   5.078  1.00 37.77           H 
ATOM    782  N   HIS    51       2.089   1.098   9.566  1.00 51.22           N 
ATOM    783  CA  HIS    51       2.910   0.048  10.177  1.00 12.44           C 
ATOM    784  C   HIS    51       2.525  -1.350   9.666  1.00 74.33           C 
ATOM    785  O   HIS    51       3.315  -2.290   9.750  1.00 65.14           O 
ATOM    786  CB  HIS    51       2.775   0.097  11.705  1.00 50.21           C 
ATOM    787  CG  HIS    51       3.696  -0.843  12.425  1.00 12.54           C 
ATOM    788  ND1 HIS    51       3.330  -2.116  12.805  1.00 43.33           N 
ATOM    789  CD2 HIS    51       4.977  -0.688  12.831  1.00 65.34           C 
ATOM    790  CE1 HIS    51       4.342  -2.699  13.414  1.00  3.11           C 
ATOM    791  NE2 HIS    51       5.353  -1.857  13.445  1.00 22.32           N 
ATOM    792  H   HIS    51       1.329   1.466  10.069  1.00 37.77           H 
ATOM    793  HA  HIS    51       3.942   0.240   9.912  1.00 65.23           H 
ATOM    794 3HB  HIS    51       1.762  -0.157  11.979  1.00 37.77           H 
ATOM    795 2HB  HIS    51       2.993   1.097  12.048  1.00 37.77           H 
ATOM    796  HD1 HIS    51       2.450  -2.532  12.658  1.00 23.42           H 
ATOM    797  HD2 HIS    51       5.589   0.191  12.696  1.00 21.10           H 
ATOM    798  HE1 HIS    51       4.344  -3.702  13.814  1.00 42.44           H 
ATOM    799  HE2 HIS    51       6.144  -1.959  14.019  1.00 37.77           H 
ATOM    800  N   GLU    52       1.311  -1.487   9.145  1.00 73.04           N 
ATOM    801  CA  GLU    52       0.818  -2.784   8.667  1.00 51.21           C 
ATOM    802  C   GLU    52      -0.183  -2.595   7.512  1.00 44.33           C 
ATOM    803  O   GLU    52      -0.827  -1.549   7.402  1.00 22.22           O 
ATOM    804  CB  GLU    52       0.174  -3.553   9.836  1.00 53.44           C 
ATOM    805  CG  GLU    52      -0.211  -4.993   9.511  1.00 14.42           C 
ATOM    806  CD  GLU    52      -0.748  -5.750  10.720  1.00 34.12           C 
ATOM    807  OE1 GLU    52      -1.827  -5.383  11.235  1.00 73.13           O 
ATOM    808  OE2 GLU    52      -0.097  -6.722  11.159  1.00 63.02           O 
ATOM    809  H   GLU    52       0.729  -0.701   9.075  1.00 37.77           H 
ATOM    810  HA  GLU    52       1.667  -3.345   8.300  1.00 10.40           H 
ATOM    811 3HB  GLU    52      -0.719  -3.026  10.149  1.00 37.77           H 
ATOM    812 2HB  GLU    52       0.870  -3.572  10.663  1.00 37.77           H 
ATOM    813 3HG  GLU    52       0.662  -5.509   9.134  1.00 37.77           H 
ATOM    814 2HG  GLU    52      -0.972  -4.981   8.745  1.00 37.77           H 
ATOM    815  N   ALA    53      -0.300  -3.603   6.646  1.00 35.13           N 
ATOM    816  CA  ALA    53      -1.173  -3.519   5.469  1.00 22.14           C 
ATOM    817  C   ALA    53      -1.585  -4.910   4.961  1.00  3.41           C 
ATOM    818  O   ALA    53      -1.136  -5.935   5.480  1.00 62.51           O 
ATOM    819  CB  ALA    53      -0.481  -2.729   4.360  1.00 65.13           C 
ATOM    820  H   ALA    53       0.203  -4.428   6.805  1.00 37.77           H 
ATOM    821  HA  ALA    53      -2.068  -2.981   5.755  1.00 55.12           H 
ATOM    822 1HB  ALA    53      -1.154  -2.615   3.522  1.00 37.77           H 
ATOM    823 2HB  ALA    53       0.407  -3.254   4.039  1.00 37.77           H 
ATOM    824 3HB  ALA    53      -0.203  -1.752   4.731  1.00 37.77           H 
ATOM    825  N   LEU    54      -2.445  -4.933   3.947  1.00 75.43           N 
ATOM    826  CA  LEU    54      -2.945  -6.182   3.350  1.00 50.40           C 
ATOM    827  C   LEU    54      -2.504  -6.307   1.885  1.00 63.45           C 
ATOM    828  O   LEU    54      -2.476  -5.323   1.152  1.00  4.02           O 
ATOM    829  CB  LEU    54      -4.475  -6.210   3.422  1.00 55.02           C 
ATOM    830  CG  LEU    54      -5.069  -6.142   4.835  1.00 71.02           C 
ATOM    831  CD1 LEU    54      -6.563  -5.837   4.776  1.00  1.45           C 
ATOM    832  CD2 LEU    54      -4.813  -7.444   5.591  1.00 64.21           C 
ATOM    833  H   LEU    54      -2.759  -4.080   3.583  1.00 37.77           H 
ATOM    834  HA  LEU    54      -2.547  -7.015   3.912  1.00 40.54           H 
ATOM    835 3HB  LEU    54      -4.822  -7.122   2.956  1.00 37.77           H 
ATOM    836 2HB  LEU    54      -4.853  -5.374   2.851  1.00 37.77           H 
ATOM    837  HG  LEU    54      -4.591  -5.340   5.382  1.00 55.31           H 
ATOM    838 1HD1 LEU    54      -6.718  -4.891   4.278  1.00 37.77           H 
ATOM    839 2HD1 LEU    54      -6.961  -5.782   5.776  1.00 37.77           H 
ATOM    840 3HD1 LEU    54      -7.071  -6.618   4.227  1.00 37.77           H 
ATOM    841 1HD2 LEU    54      -5.258  -8.270   5.054  1.00 37.77           H 
ATOM    842 2HD2 LEU    54      -5.248  -7.381   6.576  1.00 37.77           H 
ATOM    843 3HD2 LEU    54      -3.748  -7.607   5.680  1.00 37.77           H 
ATOM    844  N   ILE    55      -2.181  -7.524   1.459  1.00 35.50           N 
ATOM    845  CA  ILE    55      -1.754  -7.771   0.078  1.00 11.33           C 
ATOM    846  C   ILE    55      -2.630  -8.828  -0.609  1.00  0.21           C 
ATOM    847  O   ILE    55      -2.935  -9.879  -0.039  1.00 24.22           O 
ATOM    848  CB  ILE    55      -0.266  -8.222   0.023  1.00 15.23           C 
ATOM    849  CG1 ILE    55       0.211  -8.385  -1.434  1.00 74.31           C 
ATOM    850  CG2 ILE    55      -0.061  -9.523   0.799  1.00 51.42           C 
ATOM    851  CD1 ILE    55       0.165  -7.107  -2.249  1.00 21.24           C 
ATOM    852  H   ILE    55      -2.230  -8.274   2.084  1.00 37.77           H 
ATOM    853  HA  ILE    55      -1.842  -6.842  -0.468  1.00 23.34           H 
ATOM    854  HB  ILE    55       0.327  -7.458   0.500  1.00 34.23           H 
ATOM    855 3HG1 ILE    55      -0.411  -9.118  -1.932  1.00 37.77           H 
ATOM    856 2HG1 ILE    55       1.233  -8.733  -1.434  1.00 37.77           H 
ATOM    857 1HG2 ILE    55       0.984  -9.797   0.776  1.00 37.77           H 
ATOM    858 2HG2 ILE    55      -0.648 -10.310   0.348  1.00 37.77           H 
ATOM    859 3HG2 ILE    55      -0.374  -9.386   1.825  1.00 37.77           H 
ATOM    860 1HD1 ILE    55      -0.848  -6.735  -2.281  1.00 37.77           H 
ATOM    861 2HD1 ILE    55       0.505  -7.309  -3.253  1.00 37.77           H 
ATOM    862 3HD1 ILE    55       0.807  -6.367  -1.795  1.00 37.77           H 
ATOM    863  N   THR    56      -3.063  -8.525  -1.828  1.00 64.31           N 
ATOM    864  CA  THR    56      -3.711  -9.526  -2.682  1.00 44.40           C 
ATOM    865  C   THR    56      -2.696 -10.592  -3.116  1.00 73.44           C 
ATOM    866  O   THR    56      -1.557 -10.270  -3.435  1.00 61.53           O 
ATOM    867  CB  THR    56      -4.324  -8.879  -3.948  1.00  2.03           C 
ATOM    868  OG1 THR    56      -3.313  -8.139  -4.663  1.00  5.31           O 
ATOM    869  CG2 THR    56      -5.482  -7.953  -3.588  1.00 41.14           C 
ATOM    870  H   THR    56      -2.963  -7.605  -2.153  1.00 37.77           H 
ATOM    871  HA  THR    56      -4.504  -9.996  -2.114  1.00 53.24           H 
ATOM    872  HB  THR    56      -4.699  -9.666  -4.589  1.00 52.34           H 
ATOM    873  HG1 THR    56      -2.514  -8.096  -4.121  1.00 43.14           H 
ATOM    874 1HG2 THR    56      -5.136  -7.183  -2.912  1.00 37.77           H 
ATOM    875 2HG2 THR    56      -6.265  -8.525  -3.107  1.00 37.77           H 
ATOM    876 3HG2 THR    56      -5.872  -7.494  -4.485  1.00 37.77           H 
ATOM    877  N   ARG    57      -3.112 -11.855  -3.137  1.00 10.23           N 
ATOM    878  CA  ARG    57      -2.212 -12.965  -3.487  1.00 41.23           C 
ATOM    879  C   ARG    57      -1.654 -12.825  -4.915  1.00 43.24           C 
ATOM    880  O   ARG    57      -0.513 -13.205  -5.190  1.00 75.13           O 
ATOM    881  CB  ARG    57      -2.946 -14.298  -3.330  1.00 14.31           C 
ATOM    882  CG  ARG    57      -2.060 -15.531  -3.503  1.00 33.52           C 
ATOM    883  CD  ARG    57      -2.796 -16.805  -3.101  1.00 71.21           C 
ATOM    884  NE  ARG    57      -3.312 -16.724  -1.736  1.00 20.22           N 
ATOM    885  CZ  ARG    57      -3.952 -17.683  -1.130  1.00 13.44           C 
ATOM    886  NH1 ARG    57      -4.121 -18.827  -1.704  1.00 34.13           N 
ATOM    887  NH2 ARG    57      -4.428 -17.490   0.057  1.00 53.40           N 
ATOM    888  H   ARG    57      -4.042 -12.051  -2.899  1.00 37.77           H 
ATOM    889  HA  ARG    57      -1.385 -12.942  -2.790  1.00 10.23           H 
ATOM    890 3HB  ARG    57      -3.740 -14.344  -4.063  1.00 37.77           H 
ATOM    891 2HB  ARG    57      -3.384 -14.335  -2.342  1.00 37.77           H 
ATOM    892 3HG  ARG    57      -1.181 -15.424  -2.884  1.00 37.77           H 
ATOM    893 2HG  ARG    57      -1.764 -15.609  -4.540  1.00 37.77           H 
ATOM    894 3HD  ARG    57      -2.111 -17.641  -3.170  1.00 37.77           H 
ATOM    895 2HD  ARG    57      -3.621 -16.962  -3.781  1.00 37.77           H 
ATOM    896  HE  ARG    57      -3.176 -15.883  -1.252  1.00 23.15           H 
ATOM    897 1HH1 ARG    57      -3.760 -18.985  -2.616  1.00 37.77           H 
ATOM    898 2HH1 ARG    57      -4.618 -19.552  -1.231  1.00 37.77           H 
ATOM    899 1HH2 ARG    57      -4.308 -16.603   0.504  1.00 37.77           H 
ATOM    900 2HH2 ARG    57      -4.911 -18.225   0.524  1.00 37.77           H 
ATOM    901  N   ASP    58      -2.467 -12.279  -5.820  1.00 50.40           N 
ATOM    902  CA  ASP    58      -2.031 -11.992  -7.193  1.00 30.15           C 
ATOM    903  C   ASP    58      -1.084 -10.769  -7.216  1.00  3.04           C 
ATOM    904  O   ASP    58      -0.454 -10.465  -8.230  1.00 22.40           O 
ATOM    905  CB  ASP    58      -3.262 -11.749  -8.078  1.00 73.13           C 
ATOM    906  CG  ASP    58      -2.930 -11.771  -9.560  1.00 13.24           C 
ATOM    907  OD1 ASP    58      -2.923 -10.696 -10.190  1.00 32.45           O 
ATOM    908  OD2 ASP    58      -2.673 -12.870 -10.093  1.00 31.14           O 
ATOM    909  H   ASP    58      -3.389 -12.076  -5.561  1.00 37.77           H 
ATOM    910  HA  ASP    58      -1.493 -12.855  -7.560  1.00 45.54           H 
ATOM    911 3HB  ASP    58      -3.691 -10.786  -7.831  1.00 37.77           H 
ATOM    912 2HB  ASP    58      -3.996 -12.521  -7.881  1.00 37.77           H 
ATOM    913  N   ARG    59      -1.001 -10.095  -6.066  1.00  5.01           N 
ATOM    914  CA  ARG    59      -0.108  -8.948  -5.845  1.00 35.32           C 
ATOM    915  C   ARG    59      -0.333  -7.804  -6.850  1.00 64.34           C 
ATOM    916  O   ARG    59       0.522  -7.495  -7.680  1.00  4.52           O 
ATOM    917  CB  ARG    59       1.363  -9.406  -5.803  1.00  2.13           C 
ATOM    918  CG  ARG    59       1.608 -10.462  -4.725  1.00 22.13           C 
ATOM    919  CD  ARG    59       3.083 -10.804  -4.541  1.00 54.44           C 
ATOM    920  NE  ARG    59       3.254 -11.840  -3.521  1.00 15.32           N 
ATOM    921  CZ  ARG    59       4.131 -11.811  -2.555  1.00 72.21           C 
ATOM    922  NH1 ARG    59       5.002 -10.854  -2.466  1.00 32.04           N 
ATOM    923  NH2 ARG    59       4.142 -12.762  -1.679  1.00 73.51           N 
ATOM    924  H   ARG    59      -1.563 -10.388  -5.323  1.00 37.77           H 
ATOM    925  HA  ARG    59      -0.357  -8.561  -4.864  1.00 13.52           H 
ATOM    926 3HB  ARG    59       1.994  -8.552  -5.593  1.00 37.77           H 
ATOM    927 2HB  ARG    59       1.636  -9.822  -6.762  1.00 37.77           H 
ATOM    928 3HG  ARG    59       1.073 -11.361  -4.995  1.00 37.77           H 
ATOM    929 2HG  ARG    59       1.225 -10.091  -3.786  1.00 37.77           H 
ATOM    930 3HD  ARG    59       3.614  -9.912  -4.237  1.00 37.77           H 
ATOM    931 2HD  ARG    59       3.480 -11.160  -5.480  1.00 37.77           H 
ATOM    932  HE  ARG    59       2.646 -12.606  -3.559  1.00 61.20           H 
ATOM    933 1HH1 ARG    59       5.010 -10.123  -3.142  1.00 37.77           H 
ATOM    934 2HH1 ARG    59       5.668 -10.855  -1.721  1.00 37.77           H 
ATOM    935 1HH2 ARG    59       3.484 -13.510  -1.755  1.00 37.77           H 
ATOM    936 2HH2 ARG    59       4.793 -12.737  -0.923  1.00 37.77           H 
ATOM    937  N   LYS    60      -1.512  -7.179  -6.756  1.00 61.24           N 
ATOM    938  CA  LYS    60      -1.836  -5.995  -7.564  1.00 23.05           C 
ATOM    939  C   LYS    60      -2.514  -4.893  -6.724  1.00 63.52           C 
ATOM    940  O   LYS    60      -2.481  -3.715  -7.087  1.00 45.32           O 
ATOM    941  CB  LYS    60      -2.722  -6.386  -8.758  1.00 42.53           C 
ATOM    942  CG  LYS    60      -4.073  -6.997  -8.381  1.00 43.24           C 
ATOM    943  CD  LYS    60      -4.783  -7.573  -9.608  1.00 44.00           C 
ATOM    944  CE  LYS    60      -6.131  -8.201  -9.265  1.00 74.42           C 
ATOM    945  NZ  LYS    60      -7.168  -7.180  -8.942  1.00 11.23           N 
ATOM    946  H   LYS    60      -2.186  -7.537  -6.141  1.00 37.77           H 
ATOM    947  HA  LYS    60      -0.903  -5.598  -7.944  1.00 61.41           H 
ATOM    948 3HB  LYS    60      -2.186  -7.106  -9.362  1.00 37.77           H 
ATOM    949 2HB  LYS    60      -2.908  -5.505  -9.357  1.00 37.77           H 
ATOM    950 3HG  LYS    60      -4.696  -6.228  -7.943  1.00 37.77           H 
ATOM    951 2HG  LYS    60      -3.916  -7.788  -7.663  1.00 37.77           H 
ATOM    952 3HD  LYS    60      -4.148  -8.329 -10.053  1.00 37.77           H 
ATOM    953 2HD  LYS    60      -4.945  -6.779 -10.323  1.00 37.77           H 
ATOM    954 3HE  LYS    60      -6.004  -8.851  -8.412  1.00 37.77           H 
ATOM    955 2HE  LYS    60      -6.469  -8.783 -10.109  1.00 37.77           H 
ATOM    956 1HZ  LYS    60      -8.102  -7.637  -8.848  1.00 37.77           H 
ATOM    957 2HZ  LYS    60      -7.217  -6.470  -9.704  1.00 37.77           H 
ATOM    958 3HZ  LYS    60      -6.937  -6.699  -8.055  1.00 37.77           H 
ATOM    959  N   GLN    61      -3.127  -5.278  -5.603  1.00  5.24           N 
ATOM    960  CA  GLN    61      -3.779  -4.317  -4.697  1.00 32.22           C 
ATOM    961  C   GLN    61      -3.264  -4.465  -3.255  1.00 13.03           C 
ATOM    962  O   GLN    61      -3.025  -5.579  -2.779  1.00 24.21           O 
ATOM    963  CB  GLN    61      -5.303  -4.508  -4.721  1.00 64.10           C 
ATOM    964  CG  GLN    61      -5.949  -4.204  -6.067  1.00 61.43           C 
ATOM    965  CD  GLN    61      -6.006  -2.714  -6.369  1.00 21.34           C 
ATOM    966  OE1 GLN    61      -6.975  -2.044  -6.045  1.00 61.43           O 
ATOM    967  NE2 GLN    61      -4.964  -2.184  -6.978  1.00 34.32           N 
ATOM    968  H   GLN    61      -3.149  -6.230  -5.372  1.00 37.77           H 
ATOM    969  HA  GLN    61      -3.546  -3.319  -5.047  1.00 32.43           H 
ATOM    970 3HB  GLN    61      -5.748  -3.858  -3.979  1.00 37.77           H 
ATOM    971 2HB  GLN    61      -5.530  -5.533  -4.466  1.00 37.77           H 
ATOM    972 3HG  GLN    61      -6.958  -4.593  -6.064  1.00 37.77           H 
ATOM    973 2HG  GLN    61      -5.381  -4.692  -6.846  1.00 37.77           H 
ATOM    974 1HE2 GLN    61      -4.212  -2.766  -7.205  1.00 37.77           H 
ATOM    975 2HE2 GLN    61      -4.991  -1.228  -7.178  1.00 37.77           H 
ATOM    976  N   VAL    62      -3.086  -3.329  -2.582  1.00  1.55           N 
ATOM    977  CA  VAL    62      -2.670  -3.293  -1.174  1.00  4.03           C 
ATOM    978  C   VAL    62      -3.664  -2.470  -0.336  1.00 53.30           C 
ATOM    979  O   VAL    62      -3.902  -1.299  -0.622  1.00  4.54           O 
ATOM    980  CB  VAL    62      -1.253  -2.674  -1.021  1.00  5.14           C 
ATOM    981  CG1 VAL    62      -0.833  -2.622   0.448  1.00  3.31           C 
ATOM    982  CG2 VAL    62      -0.222  -3.444  -1.849  1.00 42.44           C 
ATOM    983  H   VAL    62      -3.235  -2.478  -3.047  1.00 37.77           H 
ATOM    984  HA  VAL    62      -2.644  -4.308  -0.796  1.00 31.03           H 
ATOM    985  HB  VAL    62      -1.288  -1.657  -1.392  1.00  0.44           H 
ATOM    986 1HG1 VAL    62       0.137  -2.152   0.530  1.00 37.77           H 
ATOM    987 2HG1 VAL    62      -0.780  -3.625   0.845  1.00 37.77           H 
ATOM    988 3HG1 VAL    62      -1.559  -2.051   1.011  1.00 37.77           H 
ATOM    989 1HG2 VAL    62       0.755  -3.002  -1.710  1.00 37.77           H 
ATOM    990 2HG2 VAL    62      -0.490  -3.398  -2.894  1.00 37.77           H 
ATOM    991 3HG2 VAL    62      -0.198  -4.476  -1.528  1.00 37.77           H 
ATOM    992  N   PHE    63      -4.242  -3.076   0.697  1.00 42.25           N 
ATOM    993  CA  PHE    63      -5.208  -2.377   1.556  1.00 71.33           C 
ATOM    994  C   PHE    63      -4.551  -1.885   2.854  1.00  4.11           C 
ATOM    995  O   PHE    63      -3.566  -2.454   3.326  1.00 42.33           O 
ATOM    996  CB  PHE    63      -6.407  -3.283   1.872  1.00 53.13           C 
ATOM    997  CG  PHE    63      -7.217  -3.655   0.656  1.00 51.20           C 
ATOM    998  CD1 PHE    63      -8.323  -2.898   0.284  1.00 44.31           C 
ATOM    999  CD2 PHE    63      -6.877  -4.758  -0.115  1.00 43.12           C 
ATOM   1000  CE1 PHE    63      -9.068  -3.236  -0.830  1.00 43.11           C 
ATOM   1001  CE2 PHE    63      -7.619  -5.099  -1.230  1.00 45.12           C 
ATOM   1002  CZ  PHE    63      -8.716  -4.336  -1.588  1.00 41.44           C 
ATOM   1003  H   PHE    63      -4.012  -4.008   0.890  1.00 37.77           H 
ATOM   1004  HA  PHE    63      -5.566  -1.513   1.012  1.00 25.10           H 
ATOM   1005 3HB  PHE    63      -7.061  -2.775   2.567  1.00 37.77           H 
ATOM   1006 2HB  PHE    63      -6.051  -4.195   2.324  1.00 37.77           H 
ATOM   1007  HD1 PHE    63      -8.598  -2.034   0.873  1.00 44.25           H 
ATOM   1008  HD2 PHE    63      -6.019  -5.356   0.162  1.00 73.41           H 
ATOM   1009  HE1 PHE    63      -9.925  -2.641  -1.108  1.00 60.40           H 
ATOM   1010  HE2 PHE    63      -7.343  -5.961  -1.822  1.00 21.40           H 
ATOM   1011  HZ  PHE    63      -9.299  -4.603  -2.456  1.00 53.20           H 
ATOM   1012  N   ARG    64      -5.108  -0.822   3.424  1.00 11.24           N 
ATOM   1013  CA  ARG    64      -4.545  -0.182   4.620  1.00 42.15           C 
ATOM   1014  C   ARG    64      -4.949  -0.913   5.915  1.00 63.23           C 
ATOM   1015  O   ARG    64      -5.977  -1.587   5.973  1.00 11.13           O 
ATOM   1016  CB  ARG    64      -5.019   1.280   4.674  1.00 32.21           C 
ATOM   1017  CG  ARG    64      -4.460   2.091   5.842  1.00  0.31           C 
ATOM   1018  CD  ARG    64      -5.049   3.496   5.865  1.00 62.24           C 
ATOM   1019  NE  ARG    64      -4.447   4.343   6.889  1.00 11.41           N 
ATOM   1020  CZ  ARG    64      -4.594   5.640   6.935  1.00 41.21           C 
ATOM   1021  NH1 ARG    64      -5.328   6.255   6.055  1.00 73.44           N 
ATOM   1022  NH2 ARG    64      -4.016   6.316   7.871  1.00  0.32           N 
ATOM   1023  H   ARG    64      -5.924  -0.451   3.027  1.00 37.77           H 
ATOM   1024  HA  ARG    64      -3.468  -0.195   4.531  1.00 73.15           H 
ATOM   1025 3HB  ARG    64      -6.098   1.291   4.742  1.00 37.77           H 
ATOM   1026 2HB  ARG    64      -4.727   1.770   3.757  1.00 37.77           H 
ATOM   1027 3HG  ARG    64      -3.385   2.162   5.739  1.00 37.77           H 
ATOM   1028 2HG  ARG    64      -4.703   1.592   6.769  1.00 37.77           H 
ATOM   1029 3HD  ARG    64      -6.113   3.421   6.055  1.00 37.77           H 
ATOM   1030 2HD  ARG    64      -4.892   3.954   4.899  1.00 37.77           H 
ATOM   1031  HE  ARG    64      -3.900   3.912   7.578  1.00 41.03           H 
ATOM   1032 1HH1 ARG    64      -5.788   5.731   5.333  1.00 37.77           H 
ATOM   1033 2HH1 ARG    64      -5.431   7.244   6.097  1.00 37.77           H 
ATOM   1034 1HH2 ARG    64      -3.460   5.843   8.552  1.00 37.77           H 
ATOM   1035 2HH2 ARG    64      -4.125   7.306   7.914  1.00 37.77           H 
ATOM   1036  N   ILE    65      -4.116  -0.786   6.948  1.00 50.24           N 
ATOM   1037  CA  ILE    65      -4.452  -1.274   8.290  1.00 61.35           C 
ATOM   1038  C   ILE    65      -4.097  -0.224   9.354  1.00 74.43           C 
ATOM   1039  O   ILE    65      -3.009   0.352   9.329  1.00  4.34           O 
ATOM   1040  CB  ILE    65      -3.725  -2.604   8.631  1.00 64.04           C 
ATOM   1041  CG1 ILE    65      -4.199  -3.731   7.702  1.00 13.51           C 
ATOM   1042  CG2 ILE    65      -3.945  -2.984  10.099  1.00 44.23           C 
ATOM   1043  CD1 ILE    65      -3.644  -5.093   8.054  1.00 44.14           C 
ATOM   1044  H   ILE    65      -3.244  -0.362   6.806  1.00 37.77           H 
ATOM   1045  HA  ILE    65      -5.521  -1.452   8.325  1.00 63.23           H 
ATOM   1046  HB  ILE    65      -2.664  -2.451   8.485  1.00 55.23           H 
ATOM   1047 3HG1 ILE    65      -3.897  -3.501   6.689  1.00 37.77           H 
ATOM   1048 2HG1 ILE    65      -5.274  -3.793   7.741  1.00 37.77           H 
ATOM   1049 1HG2 ILE    65      -5.000  -3.149  10.276  1.00 37.77           H 
ATOM   1050 2HG2 ILE    65      -3.593  -2.186  10.737  1.00 37.77           H 
ATOM   1051 3HG2 ILE    65      -3.398  -3.888  10.322  1.00 37.77           H 
ATOM   1052 1HD1 ILE    65      -2.573  -5.092   7.916  1.00 37.77           H 
ATOM   1053 2HD1 ILE    65      -4.089  -5.839   7.413  1.00 37.77           H 
ATOM   1054 3HD1 ILE    65      -3.873  -5.325   9.084  1.00 37.77           H 
ATOM   1055  N   GLU    66      -5.026   0.021  10.275  1.00  3.24           N 
ATOM   1056  CA  GLU    66      -4.794   0.951  11.389  1.00 35.14           C 
ATOM   1057  C   GLU    66      -5.454   0.432  12.677  1.00 71.53           C 
ATOM   1058  O   GLU    66      -6.574  -0.093  12.642  1.00 21.31           O 
ATOM   1059  CB  GLU    66      -5.310   2.358  11.038  1.00 72.02           C 
ATOM   1060  CG  GLU    66      -6.800   2.420  10.720  1.00 62.13           C 
ATOM   1061  CD  GLU    66      -7.292   3.842  10.499  1.00 52.13           C 
ATOM   1062  OE1 GLU    66      -7.626   4.521  11.497  1.00 61.41           O 
ATOM   1063  OE2 GLU    66      -7.356   4.289   9.334  1.00 73.42           O 
ATOM   1064  H   GLU    66      -5.892  -0.435  10.209  1.00 37.77           H 
ATOM   1065  HA  GLU    66      -3.725   1.004  11.553  1.00 15.33           H 
ATOM   1066 3HB  GLU    66      -4.768   2.719  10.174  1.00 37.77           H 
ATOM   1067 2HB  GLU    66      -5.115   3.018  11.870  1.00 37.77           H 
ATOM   1068 3HG  GLU    66      -7.350   1.986  11.544  1.00 37.77           H 
ATOM   1069 2HG  GLU    66      -6.989   1.843   9.825  1.00 37.77           H 
ATOM   1070  N   ASP    67      -4.747   0.561  13.806  1.00 10.10           N 
ATOM   1071  CA  ASP    67      -5.206   0.025  15.098  1.00 44.44           C 
ATOM   1072  C   ASP    67      -5.361  -1.512  15.009  1.00 71.22           C 
ATOM   1073  O   ASP    67      -6.180  -2.126  15.697  1.00 61.33           O 
ATOM   1074  CB  ASP    67      -6.520   0.707  15.523  1.00 62.33           C 
ATOM   1075  CG  ASP    67      -6.935   0.365  16.946  1.00 22.33           C 
ATOM   1076  OD1 ASP    67      -6.167   0.659  17.885  1.00 62.32           O 
ATOM   1077  OD2 ASP    67      -8.038  -0.183  17.138  1.00 71.12           O 
ATOM   1078  H   ASP    67      -3.882   1.026  13.769  1.00 37.77           H 
ATOM   1079  HA  ASP    67      -4.440   0.247  15.831  1.00 53.03           H 
ATOM   1080 3HB  ASP    67      -7.308   0.401  14.849  1.00 37.77           H 
ATOM   1081 2HB  ASP    67      -6.396   1.780  15.456  1.00 37.77           H 
ATOM   1082  N   SER    68      -4.538  -2.118  14.143  1.00 52.34           N 
ATOM   1083  CA  SER    68      -4.540  -3.573  13.891  1.00 70.01           C 
ATOM   1084  C   SER    68      -5.834  -4.039  13.198  1.00 10.10           C 
ATOM   1085  O   SER    68      -6.096  -5.240  13.085  1.00  4.21           O 
ATOM   1086  CB  SER    68      -4.324  -4.359  15.195  1.00 24.13           C 
ATOM   1087  OG  SER    68      -4.150  -5.749  14.939  1.00 12.33           O 
ATOM   1088  H   SER    68      -3.889  -1.563  13.657  1.00 37.77           H 
ATOM   1089  HA  SER    68      -3.713  -3.781  13.224  1.00  5.34           H 
ATOM   1090 3HB  SER    68      -5.181  -4.230  15.839  1.00 37.77           H 
ATOM   1091 2HB  SER    68      -3.439  -3.988  15.696  1.00 37.77           H 
ATOM   1092  HG  SER    68      -5.010  -6.156  14.780  1.00 51.41           H 
ATOM   1093  N   ILE    69      -6.628  -3.085  12.711  1.00 71.43           N 
ATOM   1094  CA  ILE    69      -7.881  -3.395  12.015  1.00 71.30           C 
ATOM   1095  C   ILE    69      -7.687  -3.400  10.487  1.00 24.04           C 
ATOM   1096  O   ILE    69      -7.264  -2.397   9.908  1.00  4.10           O 
ATOM   1097  CB  ILE    69      -8.992  -2.376  12.388  1.00 31.21           C 
ATOM   1098  CG1 ILE    69      -9.216  -2.360  13.910  1.00 75.43           C 
ATOM   1099  CG2 ILE    69     -10.293  -2.691  11.647  1.00 54.22           C 
ATOM   1100  CD1 ILE    69      -9.649  -3.693  14.485  1.00 23.51           C 
ATOM   1101  H   ILE    69      -6.365  -2.148  12.819  1.00 37.77           H 
ATOM   1102  HA  ILE    69      -8.207  -4.377  12.333  1.00 62.42           H 
ATOM   1103  HB  ILE    69      -8.662  -1.395  12.073  1.00 72.12           H 
ATOM   1104 3HG1 ILE    69      -9.981  -1.634  14.147  1.00 37.77           H 
ATOM   1105 2HG1 ILE    69      -8.297  -2.074  14.400  1.00 37.77           H 
ATOM   1106 1HG2 ILE    69     -10.126  -2.636  10.581  1.00 37.77           H 
ATOM   1107 2HG2 ILE    69     -11.052  -1.975  11.929  1.00 37.77           H 
ATOM   1108 3HG2 ILE    69     -10.624  -3.687  11.908  1.00 37.77           H 
ATOM   1109 1HD1 ILE    69      -8.899  -4.442  14.271  1.00 37.77           H 
ATOM   1110 2HD1 ILE    69     -10.588  -3.991  14.042  1.00 37.77           H 
ATOM   1111 3HD1 ILE    69      -9.769  -3.601  15.554  1.00 37.77           H 
ATOM   1112  N   PRO    70      -7.979  -4.536   9.818  1.00 33.43           N 
ATOM   1113  CA  PRO    70      -7.892  -4.639   8.350  1.00  2.23           C 
ATOM   1114  C   PRO    70      -8.915  -3.738   7.639  1.00 62.42           C 
ATOM   1115  O   PRO    70     -10.122  -3.969   7.728  1.00 65.13           O 
ATOM   1116  CB  PRO    70      -8.191  -6.127   8.069  1.00 14.13           C 
ATOM   1117  CG  PRO    70      -8.006  -6.817   9.379  1.00 61.01           C 
ATOM   1118  CD  PRO    70      -8.397  -5.810  10.426  1.00 20.12           C 
ATOM   1119  HA  PRO    70      -6.901  -4.396   8.000  1.00 12.11           H 
ATOM   1120 3HB  PRO    70      -7.503  -6.501   7.325  1.00 37.77           H 
ATOM   1121 2HB  PRO    70      -9.205  -6.234   7.707  1.00 37.77           H 
ATOM   1122 3HG  PRO    70      -6.970  -7.105   9.504  1.00 37.77           H 
ATOM   1123 2HG  PRO    70      -8.647  -7.687   9.430  1.00 37.77           H 
ATOM   1124 3HD  PRO    70      -7.864  -5.993  11.348  1.00 37.77           H 
ATOM   1125 2HD  PRO    70      -9.464  -5.830  10.592  1.00 37.77           H 
ATOM   1126  N   VAL    71      -8.435  -2.708   6.944  1.00 14.33           N 
ATOM   1127  CA  VAL    71      -9.318  -1.778   6.237  1.00 72.31           C 
ATOM   1128  C   VAL    71      -9.582  -2.244   4.789  1.00 33.31           C 
ATOM   1129  O   VAL    71      -8.839  -1.908   3.864  1.00 14.01           O 
ATOM   1130  CB  VAL    71      -8.727  -0.337   6.233  1.00 20.55           C 
ATOM   1131  CG1 VAL    71      -9.682   0.650   5.565  1.00 33.24           C 
ATOM   1132  CG2 VAL    71      -8.384   0.110   7.661  1.00  2.45           C 
ATOM   1133  H   VAL    71      -7.463  -2.568   6.904  1.00 37.77           H 
ATOM   1134  HA  VAL    71     -10.262  -1.751   6.767  1.00 71.43           H 
ATOM   1135  HB  VAL    71      -7.809  -0.352   5.661  1.00 55.33           H 
ATOM   1136 1HG1 VAL    71     -10.623   0.659   6.098  1.00 37.77           H 
ATOM   1137 2HG1 VAL    71      -9.852   0.350   4.541  1.00 37.77           H 
ATOM   1138 3HG1 VAL    71      -9.250   1.640   5.583  1.00 37.77           H 
ATOM   1139 1HG2 VAL    71      -7.640  -0.551   8.081  1.00 37.77           H 
ATOM   1140 2HG2 VAL    71      -9.273   0.082   8.273  1.00 37.77           H 
ATOM   1141 3HG2 VAL    71      -7.995   1.119   7.642  1.00 37.77           H 
ATOM   1142  N   LEU    72     -10.640  -3.037   4.608  1.00 51.13           N 
ATOM   1143  CA  LEU    72     -11.040  -3.533   3.282  1.00 44.22           C 
ATOM   1144  C   LEU    72     -11.863  -2.486   2.502  1.00 70.13           C 
ATOM   1145  O   LEU    72     -12.726  -2.836   1.690  1.00 13.44           O 
ATOM   1146  CB  LEU    72     -11.865  -4.823   3.446  1.00 60.34           C 
ATOM   1147  CG  LEU    72     -11.180  -5.952   4.236  1.00 44.14           C 
ATOM   1148  CD1 LEU    72     -12.108  -7.158   4.372  1.00 55.21           C 
ATOM   1149  CD2 LEU    72      -9.863  -6.353   3.575  1.00  0.43           C 
ATOM   1150  H   LEU    72     -11.158  -3.321   5.392  1.00 37.77           H 
ATOM   1151  HA  LEU    72     -10.142  -3.759   2.723  1.00 52.41           H 
ATOM   1152 3HB  LEU    72     -12.103  -5.198   2.460  1.00 37.77           H 
ATOM   1153 2HB  LEU    72     -12.788  -4.571   3.948  1.00 37.77           H 
ATOM   1154  HG  LEU    72     -10.956  -5.596   5.233  1.00 52.30           H 
ATOM   1155 1HD1 LEU    72     -11.611  -7.936   4.936  1.00 37.77           H 
ATOM   1156 2HD1 LEU    72     -12.366  -7.531   3.391  1.00 37.77           H 
ATOM   1157 3HD1 LEU    72     -13.008  -6.862   4.892  1.00 37.77           H 
ATOM   1158 1HD2 LEU    72      -9.211  -5.492   3.519  1.00 37.77           H 
ATOM   1159 2HD2 LEU    72     -10.053  -6.724   2.578  1.00 37.77           H 
ATOM   1160 3HD2 LEU    72      -9.385  -7.126   4.162  1.00 37.77           H 
ATOM   1161  N   LEU    73     -11.583  -1.205   2.733  1.00 42.34           N 
ATOM   1162  CA  LEU    73     -12.299  -0.115   2.062  1.00 63.31           C 
ATOM   1163  C   LEU    73     -11.632   0.246   0.722  1.00 14.10           C 
ATOM   1164  O   LEU    73     -10.407   0.283   0.622  1.00 53.44           O 
ATOM   1165  CB  LEU    73     -12.357   1.114   2.976  1.00 22.14           C 
ATOM   1166  CG  LEU    73     -13.118   0.913   4.298  1.00  2.32           C 
ATOM   1167  CD1 LEU    73     -13.094   2.187   5.137  1.00 14.20           C 
ATOM   1168  CD2 LEU    73     -14.558   0.471   4.031  1.00 22.41           C 
ATOM   1169  H   LEU    73     -10.866  -0.983   3.361  1.00 37.77           H 
ATOM   1170  HA  LEU    73     -13.309  -0.453   1.869  1.00 23.32           H 
ATOM   1171 3HB  LEU    73     -12.827   1.922   2.435  1.00 37.77           H 
ATOM   1172 2HB  LEU    73     -11.341   1.408   3.212  1.00 37.77           H 
ATOM   1173  HG  LEU    73     -12.632   0.132   4.868  1.00  0.41           H 
ATOM   1174 1HD1 LEU    73     -12.071   2.443   5.372  1.00 37.77           H 
ATOM   1175 2HD1 LEU    73     -13.643   2.025   6.052  1.00 37.77           H 
ATOM   1176 3HD1 LEU    73     -13.549   2.995   4.582  1.00 37.77           H 
ATOM   1177 1HD2 LEU    73     -15.067   0.317   4.970  1.00 37.77           H 
ATOM   1178 2HD2 LEU    73     -14.555  -0.453   3.468  1.00 37.77           H 
ATOM   1179 3HD2 LEU    73     -15.072   1.235   3.465  1.00 37.77           H 
ATOM   1180  N   PRO    74     -12.437   0.539  -0.321  1.00 45.13           N 
ATOM   1181  CA  PRO    74     -11.922   0.757  -1.691  1.00 55.51           C 
ATOM   1182  C   PRO    74     -11.028   2.001  -1.838  1.00 61.22           C 
ATOM   1183  O   PRO    74     -10.082   2.000  -2.625  1.00 11.30           O 
ATOM   1184  CB  PRO    74     -13.202   0.916  -2.526  1.00 13.31           C 
ATOM   1185  CG  PRO    74     -14.240   1.367  -1.553  1.00 34.00           C 
ATOM   1186  CD  PRO    74     -13.906   0.685  -0.257  1.00 25.53           C 
ATOM   1187  HA  PRO    74     -11.376  -0.108  -2.040  1.00  4.41           H 
ATOM   1188 3HB  PRO    74     -13.464  -0.036  -2.971  1.00 37.77           H 
ATOM   1189 2HB  PRO    74     -13.043   1.647  -3.307  1.00 37.77           H 
ATOM   1190 3HG  PRO    74     -15.222   1.069  -1.893  1.00 37.77           H 
ATOM   1191 2HG  PRO    74     -14.196   2.442  -1.438  1.00 37.77           H 
ATOM   1192 3HD  PRO    74     -14.387  -0.280  -0.199  1.00 37.77           H 
ATOM   1193 2HD  PRO    74     -14.197   1.303   0.583  1.00 37.77           H 
ATOM   1194  N   GLU    75     -11.320   3.063  -1.087  1.00  3.03           N 
ATOM   1195  CA  GLU    75     -10.571   4.319  -1.226  1.00 71.11           C 
ATOM   1196  C   GLU    75      -9.237   4.306  -0.451  1.00 10.34           C 
ATOM   1197  O   GLU    75      -8.301   5.025  -0.807  1.00 12.22           O 
ATOM   1198  CB  GLU    75     -11.440   5.538  -0.849  1.00 20.24           C 
ATOM   1199  CG  GLU    75     -12.403   5.324   0.316  1.00 24.44           C 
ATOM   1200  CD  GLU    75     -11.707   5.134   1.647  1.00 52.51           C 
ATOM   1201  OE1 GLU    75     -11.283   6.144   2.253  1.00 42.42           O 
ATOM   1202  OE2 GLU    75     -11.607   3.984   2.103  1.00 33.11           O 
ATOM   1203  H   GLU    75     -12.042   3.000  -0.426  1.00 37.77           H 
ATOM   1204  HA  GLU    75     -10.323   4.408  -2.276  1.00 73.12           H 
ATOM   1205 3HB  GLU    75     -12.022   5.824  -1.714  1.00 37.77           H 
ATOM   1206 2HB  GLU    75     -10.787   6.361  -0.591  1.00 37.77           H 
ATOM   1207 3HG  GLU    75     -13.001   4.446   0.110  1.00 37.77           H 
ATOM   1208 2HG  GLU    75     -13.054   6.183   0.390  1.00 37.77           H 
ATOM   1209  N   GLU    76      -9.146   3.491   0.603  1.00 63.43           N 
ATOM   1210  CA  GLU    76      -7.869   3.292   1.320  1.00  4.41           C 
ATOM   1211  C   GLU    76      -6.981   2.247   0.615  1.00 44.32           C 
ATOM   1212  O   GLU    76      -5.985   1.789   1.180  1.00 31.13           O 
ATOM   1213  CB  GLU    76      -8.119   2.843   2.773  1.00 65.03           C 
ATOM   1214  CG  GLU    76      -8.795   3.887   3.663  1.00 54.24           C 
ATOM   1215  CD  GLU    76      -7.981   5.164   3.841  1.00 14.12           C 
ATOM   1216  OE1 GLU    76      -6.736   5.094   3.887  1.00  3.42           O 
ATOM   1217  OE2 GLU    76      -8.589   6.249   3.963  1.00 42.50           O 
ATOM   1218  H   GLU    76      -9.951   3.029   0.921  1.00 37.77           H 
ATOM   1219  HA  GLU    76      -7.345   4.237   1.334  1.00 64.50           H 
ATOM   1220 3HB  GLU    76      -7.168   2.585   3.221  1.00 37.77           H 
ATOM   1221 2HB  GLU    76      -8.744   1.961   2.760  1.00 37.77           H 
ATOM   1222 3HG  GLU    76      -8.961   3.449   4.638  1.00 37.77           H 
ATOM   1223 2HG  GLU    76      -9.747   4.145   3.224  1.00 37.77           H 
ATOM   1224  N   ALA    77      -7.340   1.878  -0.618  1.00 12.30           N 
ATOM   1225  CA  ALA    77      -6.594   0.865  -1.380  1.00 42.20           C 
ATOM   1226  C   ALA    77      -5.492   1.489  -2.259  1.00 65.14           C 
ATOM   1227  O   ALA    77      -5.654   2.586  -2.805  1.00 10.33           O 
ATOM   1228  CB  ALA    77      -7.552   0.042  -2.236  1.00 12.44           C 
ATOM   1229  H   ALA    77      -8.123   2.293  -1.029  1.00 37.77           H 
ATOM   1230  HA  ALA    77      -6.126   0.194  -0.668  1.00 54.43           H 
ATOM   1231 1HB  ALA    77      -7.969   0.669  -3.011  1.00 37.77           H 
ATOM   1232 2HB  ALA    77      -8.351  -0.342  -1.619  1.00 37.77           H 
ATOM   1233 3HB  ALA    77      -7.019  -0.782  -2.688  1.00 37.77           H 
ATOM   1234  N   ILE    78      -4.373   0.771  -2.383  1.00  5.01           N 
ATOM   1235  CA  ILE    78      -3.228   1.207  -3.192  1.00 44.14           C 
ATOM   1236  C   ILE    78      -2.954   0.218  -4.342  1.00 22.13           C 
ATOM   1237  O   ILE    78      -3.028  -1.000  -4.157  1.00  0.24           O 
ATOM   1238  CB  ILE    78      -1.930   1.325  -2.335  1.00 34.02           C 
ATOM   1239  CG1 ILE    78      -2.106   2.309  -1.161  1.00 55.34           C 
ATOM   1240  CG2 ILE    78      -0.741   1.743  -3.204  1.00 24.14           C 
ATOM   1241  CD1 ILE    78      -2.879   1.752   0.021  1.00  2.44           C 
ATOM   1242  H   ILE    78      -4.314  -0.080  -1.908  1.00 37.77           H 
ATOM   1243  HA  ILE    78      -3.451   2.180  -3.609  1.00 75.11           H 
ATOM   1244  HB  ILE    78      -1.714   0.341  -1.936  1.00 55.21           H 
ATOM   1245 3HG1 ILE    78      -2.627   3.190  -1.510  1.00 37.77           H 
ATOM   1246 2HG1 ILE    78      -1.131   2.601  -0.795  1.00 37.77           H 
ATOM   1247 1HG2 ILE    78       0.144   1.830  -2.588  1.00 37.77           H 
ATOM   1248 2HG2 ILE    78      -0.949   2.693  -3.671  1.00 37.77           H 
ATOM   1249 3HG2 ILE    78      -0.572   0.996  -3.969  1.00 37.77           H 
ATOM   1250 1HD1 ILE    78      -2.382   0.869   0.394  1.00 37.77           H 
ATOM   1251 2HD1 ILE    78      -3.881   1.496  -0.291  1.00 37.77           H 
ATOM   1252 3HD1 ILE    78      -2.928   2.496   0.802  1.00 37.77           H 
ATOM   1253  N   ALA    79      -2.639   0.738  -5.526  1.00 15.14           N 
ATOM   1254  CA  ALA    79      -2.224  -0.104  -6.651  1.00 73.34           C 
ATOM   1255  C   ALA    79      -0.697  -0.301  -6.658  1.00 54.11           C 
ATOM   1256  O   ALA    79       0.061   0.671  -6.666  1.00 24.43           O 
ATOM   1257  CB  ALA    79      -2.696   0.502  -7.968  1.00  2.31           C 
ATOM   1258  H   ALA    79      -2.698   1.709  -5.650  1.00 37.77           H 
ATOM   1259  HA  ALA    79      -2.699  -1.070  -6.538  1.00 72.32           H 
ATOM   1260 1HB  ALA    79      -2.226   1.464  -8.112  1.00 37.77           H 
ATOM   1261 2HB  ALA    79      -3.769   0.628  -7.942  1.00 37.77           H 
ATOM   1262 3HB  ALA    79      -2.431  -0.153  -8.787  1.00 37.77           H 
ATOM   1263  N   THR    80      -0.249  -1.559  -6.666  1.00  4.33           N 
ATOM   1264  CA  THR    80       1.195  -1.878  -6.639  1.00 13.21           C 
ATOM   1265  C   THR    80       1.947  -1.269  -7.833  1.00 34.14           C 
ATOM   1266  O   THR    80       3.151  -1.015  -7.761  1.00 21.40           O 
ATOM   1267  CB  THR    80       1.441  -3.410  -6.622  1.00 73.25           C 
ATOM   1268  OG1 THR    80       0.821  -4.027  -7.764  1.00 41.45           O 
ATOM   1269  CG2 THR    80       0.894  -4.044  -5.346  1.00 34.24           C 
ATOM   1270  H   THR    80      -0.898  -2.297  -6.690  1.00 37.77           H 
ATOM   1271  HA  THR    80       1.604  -1.464  -5.725  1.00 73.11           H 
ATOM   1272  HB  THR    80       2.507  -3.589  -6.666  1.00 13.33           H 
ATOM   1273  HG1 THR    80       1.048  -4.967  -7.781  1.00 44.43           H 
ATOM   1274 1HG2 THR    80      -0.173  -3.892  -5.295  1.00 37.77           H 
ATOM   1275 2HG2 THR    80       1.364  -3.587  -4.485  1.00 37.77           H 
ATOM   1276 3HG2 THR    80       1.108  -5.104  -5.348  1.00 37.77           H 
ATOM   1277  N   ILE    81       1.229  -1.030  -8.927  1.00 63.00           N 
ATOM   1278  CA  ILE    81       1.813  -0.438 -10.140  1.00 63.35           C 
ATOM   1279  C   ILE    81       2.241   1.029  -9.916  1.00 50.03           C 
ATOM   1280  O   ILE    81       3.022   1.590 -10.686  1.00 22.25           O 
ATOM   1281  CB  ILE    81       0.806  -0.514 -11.319  1.00 63.52           C 
ATOM   1282  CG1 ILE    81       1.447  -0.048 -12.641  1.00 24.13           C 
ATOM   1283  CG2 ILE    81      -0.447   0.308 -11.007  1.00 31.10           C 
ATOM   1284  CD1 ILE    81       2.621  -0.898 -13.089  1.00 43.43           C 
ATOM   1285  H   ILE    81       0.281  -1.270  -8.926  1.00 37.77           H 
ATOM   1286  HA  ILE    81       2.687  -1.017 -10.404  1.00 32.10           H 
ATOM   1287  HB  ILE    81       0.501  -1.547 -11.425  1.00 41.01           H 
ATOM   1288 3HG1 ILE    81       1.799   0.968 -12.521  1.00 37.77           H 
ATOM   1289 2HG1 ILE    81       0.707  -0.075 -13.424  1.00 37.77           H 
ATOM   1290 1HG2 ILE    81      -0.176   1.348 -10.884  1.00 37.77           H 
ATOM   1291 2HG2 ILE    81      -0.899  -0.055 -10.096  1.00 37.77           H 
ATOM   1292 3HG2 ILE    81      -1.153   0.216 -11.821  1.00 37.77           H 
ATOM   1293 1HD1 ILE    81       3.020  -0.503 -14.013  1.00 37.77           H 
ATOM   1294 2HD1 ILE    81       2.291  -1.914 -13.246  1.00 37.77           H 
ATOM   1295 3HD1 ILE    81       3.391  -0.882 -12.330  1.00 37.77           H 
ATOM   1296  N   GLN    82       1.724   1.644  -8.854  1.00 41.52           N 
ATOM   1297  CA  GLN    82       2.045   3.039  -8.531  1.00 64.31           C 
ATOM   1298  C   GLN    82       3.299   3.137  -7.638  1.00 61.24           C 
ATOM   1299  O   GLN    82       3.825   4.226  -7.392  1.00 52.43           O 
ATOM   1300  CB  GLN    82       0.836   3.701  -7.843  1.00 71.10           C 
ATOM   1301  CG  GLN    82       1.000   5.194  -7.573  1.00 32.43           C 
ATOM   1302  CD  GLN    82       1.272   6.006  -8.831  1.00 22.33           C 
ATOM   1303  OE1 GLN    82       0.848   5.645  -9.926  1.00  2.42           O 
ATOM   1304  NE2 GLN    82       1.974   7.110  -8.685  1.00 63.23           N 
ATOM   1305  H   GLN    82       1.109   1.150  -8.272  1.00 37.77           H 
ATOM   1306  HA  GLN    82       2.240   3.557  -9.459  1.00  2.24           H 
ATOM   1307 3HB  GLN    82       0.659   3.203  -6.898  1.00 37.77           H 
ATOM   1308 2HB  GLN    82      -0.035   3.567  -8.470  1.00 37.77           H 
ATOM   1309 3HG  GLN    82       1.823   5.331  -6.887  1.00 37.77           H 
ATOM   1310 2HG  GLN    82       0.093   5.564  -7.118  1.00 37.77           H 
ATOM   1311 1HE2 GLN    82       2.279   7.353  -7.785  1.00 37.77           H 
ATOM   1312 2HE2 GLN    82       2.167   7.640  -9.486  1.00 37.77           H 
ATOM   1313  N   ILE    83       3.784   1.992  -7.162  1.00 40.34           N 
ATOM   1314  CA  ILE    83       4.958   1.968  -6.287  1.00 43.32           C 
ATOM   1315  C   ILE    83       6.263   1.930  -7.102  1.00 41.45           C 
ATOM   1316  O   ILE    83       6.732   0.867  -7.510  1.00  4.20           O 
ATOM   1317  CB  ILE    83       4.918   0.760  -5.316  1.00 64.50           C 
ATOM   1318  CG1 ILE    83       3.587   0.738  -4.540  1.00  1.22           C 
ATOM   1319  CG2 ILE    83       6.106   0.804  -4.353  1.00 33.20           C 
ATOM   1320  CD1 ILE    83       3.315   1.994  -3.736  1.00 33.13           C 
ATOM   1321  H   ILE    83       3.352   1.147  -7.408  1.00 37.77           H 
ATOM   1322  HA  ILE    83       4.948   2.874  -5.694  1.00  1.02           H 
ATOM   1323  HB  ILE    83       4.997  -0.145  -5.902  1.00  0.15           H 
ATOM   1324 3HG1 ILE    83       3.591  -0.099  -3.857  1.00 37.77           H 
ATOM   1325 2HG1 ILE    83       2.775   0.615  -5.241  1.00 37.77           H 
ATOM   1326 1HG2 ILE    83       6.053  -0.036  -3.677  1.00 37.77           H 
ATOM   1327 2HG2 ILE    83       6.081   1.723  -3.787  1.00 37.77           H 
ATOM   1328 3HG2 ILE    83       7.030   0.752  -4.916  1.00 37.77           H 
ATOM   1329 1HD1 ILE    83       2.366   1.898  -3.229  1.00 37.77           H 
ATOM   1330 2HD1 ILE    83       3.282   2.847  -4.398  1.00 37.77           H 
ATOM   1331 3HD1 ILE    83       4.099   2.135  -3.008  1.00 37.77           H 
ATOM   1332  N   ALA    84       6.849   3.108  -7.320  1.00 62.23           N 
ATOM   1333  CA  ALA    84       8.081   3.246  -8.118  1.00 22.50           C 
ATOM   1334  C   ALA    84       9.326   2.665  -7.417  1.00 12.21           C 
ATOM   1335  O   ALA    84      10.454   2.901  -7.853  1.00 75.03           O 
ATOM   1336  CB  ALA    84       8.305   4.717  -8.453  1.00 51.53           C 
ATOM   1337  H   ALA    84       6.430   3.914  -6.959  1.00 37.77           H 
ATOM   1338  HA  ALA    84       7.932   2.716  -9.048  1.00 44.15           H 
ATOM   1339 1HB  ALA    84       8.463   5.275  -7.541  1.00 37.77           H 
ATOM   1340 2HB  ALA    84       7.441   5.106  -8.969  1.00 37.77           H 
ATOM   1341 3HB  ALA    84       9.174   4.813  -9.089  1.00 37.77           H 
ATOM   1342  N   ASN    85       9.124   1.907  -6.339  1.00 71.14           N 
ATOM   1343  CA  ASN    85      10.237   1.283  -5.605  1.00 32.24           C 
ATOM   1344  C   ASN    85      10.236  -0.250  -5.772  1.00 12.12           C 
ATOM   1345  O   ASN    85      11.046  -0.950  -5.167  1.00 32.41           O 
ATOM   1346  CB  ASN    85      10.165   1.660  -4.119  1.00  0.52           C 
ATOM   1347  CG  ASN    85      10.415   3.141  -3.888  1.00 45.11           C 
ATOM   1348  OD1 ASN    85      11.544   3.567  -3.672  1.00 43.23           O 
ATOM   1349  ND2 ASN    85       9.369   3.940  -3.934  1.00 73.35           N 
ATOM   1350  H   ASN    85       8.212   1.759  -6.030  1.00 37.77           H 
ATOM   1351  HA  ASN    85      11.160   1.665  -6.016  1.00 40.53           H 
ATOM   1352 3HB  ASN    85      10.909   1.098  -3.573  1.00 37.77           H 
ATOM   1353 2HB  ASN    85       9.182   1.416  -3.738  1.00 37.77           H 
ATOM   1354 1HD2 ASN    85       8.497   3.549  -4.113  1.00 37.77           H 
ATOM   1355 2HD2 ASN    85       9.522   4.897  -3.794  1.00 37.77           H 
ATOM   1356  N   PHE    86       9.324  -0.761  -6.598  1.00 24.23           N 
ATOM   1357  CA  PHE    86       9.263  -2.198  -6.895  1.00 41.53           C 
ATOM   1358  C   PHE    86      10.334  -2.608  -7.924  1.00 52.22           C 
ATOM   1359  O   PHE    86      10.609  -1.871  -8.876  1.00 30.42           O 
ATOM   1360  CB  PHE    86       7.859  -2.583  -7.402  1.00  3.41           C 
ATOM   1361  CG  PHE    86       6.924  -3.080  -6.323  1.00  2.11           C 
ATOM   1362  CD1 PHE    86       6.796  -2.399  -5.123  1.00 13.41           C 
ATOM   1363  CD2 PHE    86       6.175  -4.235  -6.512  1.00 41.54           C 
ATOM   1364  CE1 PHE    86       5.941  -2.854  -4.136  1.00 11.41           C 
ATOM   1365  CE2 PHE    86       5.319  -4.694  -5.527  1.00 64.53           C 
ATOM   1366  CZ  PHE    86       5.204  -4.003  -4.339  1.00 34.02           C 
ATOM   1367  H   PHE    86       8.678  -0.161  -7.023  1.00 37.77           H 
ATOM   1368  HA  PHE    86       9.457  -2.728  -5.971  1.00 51.22           H 
ATOM   1369 3HB  PHE    86       7.954  -3.360  -8.143  1.00 37.77           H 
ATOM   1370 2HB  PHE    86       7.403  -1.717  -7.858  1.00 37.77           H 
ATOM   1371  HD1 PHE    86       7.372  -1.498  -4.962  1.00 71.15           H 
ATOM   1372  HD2 PHE    86       6.265  -4.780  -7.441  1.00  4.41           H 
ATOM   1373  HE1 PHE    86       5.852  -2.311  -3.205  1.00  2.31           H 
ATOM   1374  HE2 PHE    86       4.743  -5.594  -5.687  1.00 42.13           H 
ATOM   1375  HZ  PHE    86       4.536  -4.361  -3.568  1.00  3.31           H 
END
