
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 (  801),  selected  100 , name 1jos_A
# Molecule2: number of CA atoms   69 ( 1087),  selected   69 , name T0464.pdb
# PARAMETERS: 1jos_A.T0464.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     7_A      L      18           -
LGA    S     8_A      S      19           #
LGA    D     9_A      L      20           #
LGA    R    10_A      -       -           -
LGA    V    11_A      L      21           #
LGA    A    12_A      E      22          2.412
LGA    Q    13_A      S      23          1.548
LGA    E    14_A      K      24          1.842
LGA    I    15_A      G      25          1.781
LGA    Q    16_A      L      26          0.822
LGA    K    17_A      E      27          0.404
LGA    E    18_A      A      28          1.077
LGA    I    19_A      L      29          0.832
LGA    A    20_A      N      30          0.778
LGA    V    21_A      K      31          1.875
LGA    I    22_A      A      32          1.618
LGA    L    23_A      I      33          1.663
LGA    Q    24_A      V      34          2.454
LGA    R    25_A      S      35          2.877
LGA    E    26_A      G      36          1.541
LGA    -       -      T      37           -
LGA    -       -      V      38           -
LGA    -       -      Q      39           -
LGA    -       -      R      40           -
LGA    -       -      A      41           -
LGA    -       -      D      42           -
LGA    -       -      G      43           -
LGA    -       -      S      44           -
LGA    V    27_A      I      45          3.411
LGA    K    28_A      Q      46           #
LGA    D    29_A      -       -           -
LGA    P    30_A      -       -           -
LGA    R    31_A      -       -           -
LGA    I    32_A      -       -           -
LGA    G    33_A      -       -           -
LGA    M    34_A      N      47          4.402
LGA    V    35_A      Q      48          0.323
LGA    T    36_A      S      49          2.044
LGA    V    37_A      L      50          1.058
LGA    S    38_A      H      51          1.532
LGA    D    39_A      E      52          0.752
LGA    V    40_A      A      53          2.256
LGA    E    41_A      L      54          2.837
LGA    V    42_A      I      55          2.535
LGA    S    43_A      T      56          4.245
LGA    S    44_A      -       -           -
LGA    D    45_A      R      57          3.053
LGA    L    46_A      D      58          3.380
LGA    S    47_A      R      59          3.949
LGA    -       -      K      60           -
LGA    Y    48_A      Q      61          4.507
LGA    A    49_A      V      62          3.199
LGA    K    50_A      F      63          2.510
LGA    I    51_A      R      64          2.646
LGA    F    52_A      I      65          1.748
LGA    V    53_A      E      66          4.726
LGA    T    54_A      D      67           -
LGA    F    55_A      S      68           -
LGA    L    56_A      I      69           -
LGA    F    57_A      P      70           -
LGA    D    58_A      V      71           -
LGA    H    59_A      L      72           -
LGA    D    60_A      -       -           -
LGA    E    61_A      -       -           -
LGA    M    62_A      -       -           -
LGA    A    63_A      -       -           -
LGA    I    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    Q    66_A      -       -           -
LGA    G    67_A      -       -           -
LGA    M    68_A      L      73           #
LGA    K    69_A      P      74           -
LGA    G    70_A      -       -           -
LGA    L    71_A      E      75          6.164
LGA    E    72_A      E      76          4.677
LGA    K    73_A      A      77           -
LGA    A    74_A      -       -           -
LGA    S    75_A      I      78          3.796
LGA    P    76_A      A      79          4.615
LGA    Y    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    R    79_A      T      80          2.801
LGA    S    80_A      I      81          2.558
LGA    L    81_A      Q      82          3.350
LGA    L    82_A      I      83          2.190
LGA    G    83_A      -       -           -
LGA    K    84_A      A      84          3.896
LGA    A    85_A      N      85          2.058
LGA    M    86_A      F      86          1.920
LGA    R    87_A      -       -           -
LGA    L    88_A      -       -           -
LGA    R    89_A      -       -           -
LGA    I    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    I    94_A      -       -           -
LGA    R    95_A      -       -           -
LGA    F    96_A      -       -           -
LGA    I    97_A      -       -           -
LGA    Y    98_A      -       -           -
LGA    D    99_A      -       -           -
LGA    Q   100_A      -       -           -
LGA    S   101_A      -       -           -
LGA    L   102_A      -       -           -
LGA    V   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    M   106_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100   69    5.0     46    2.86     2.17     45.326     1.556

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.114937 * X  +   0.963784 * Y  +   0.240644 * Z  + -30.969727
  Y_new =  -0.945166 * X  +   0.031553 * Y  +   0.325062 * Z  +  34.134491
  Z_new =   0.305696 * X  +  -0.264811 * Y  +   0.914563 * Z  + -19.572611 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.281841    2.859751  [ DEG:   -16.1483    163.8517 ]
  Theta =  -0.310669   -2.830923  [ DEG:   -17.8000   -162.2000 ]
  Phi   =  -1.449785    1.691807  [ DEG:   -83.0666     96.9334 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jos_A                                        
REMARK     2: T0464.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jos_A.T0464.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100   69   5.0   46   2.86    2.17  45.326
REMARK  ---------------------------------------------------------- 
MOLECULE 1jos_A
HEADER    RNA BINDING PROTEIN                     30-JUL-01   1JOS              
TITLE     RIBOSOME BINDING FACTOR A(RBFA)                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBOSOME-BINDING FACTOR A;                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: RBFA;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: HI1288;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    RNA BINDING PROTEIN, STRUCTURE 2 FUNCTION PROJECT, S2F,               
KEYWDS   2 STRUCTURAL GENOMICS                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.BONANDER,M.TORDOVA,A.J.HOWARD,E.EISENSTEIN,G.L.GILLILAND,           
AUTHOR   2 STRUCTURE 2 FUNCTION PROJECT (S2F)                                   
REVDAT   1   24-JUN-03 1JOS    0                                                
JRNL        AUTH   N.BONANDER,M.TORDOVA,A.J.HOWARD,E.EISENSTEIN,                
JRNL        AUTH 2 G.L.GILLILAND                                                
JRNL        TITL   THE 1.7-A CRYSTAL STRUCTURE OF HI1288 - RIBOSOME             
JRNL        TITL 2 BINDING FACTOR A (RBFA), A COLD RESPONSE PROTEIN             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1JOS A    1   128  UNP    P45141   RBFA_HAEIN       1    128             
SEQRES   1 A  128  MET ALA ARG GLU PHE LYS ARG SER ASP ARG VAL ALA GLN          
SEQRES   2 A  128  GLU ILE GLN LYS GLU ILE ALA VAL ILE LEU GLN ARG GLU          
SEQRES   3 A  128  VAL LYS ASP PRO ARG ILE GLY MET VAL THR VAL SER ASP          
SEQRES   4 A  128  VAL GLU VAL SER SER ASP LEU SER TYR ALA LYS ILE PHE          
SEQRES   5 A  128  VAL THR PHE LEU PHE ASP HIS ASP GLU MET ALA ILE GLU          
SEQRES   6 A  128  GLN GLY MET LYS GLY LEU GLU LYS ALA SER PRO TYR ILE          
SEQRES   7 A  128  ARG SER LEU LEU GLY LYS ALA MET ARG LEU ARG ILE VAL          
SEQRES   8 A  128  PRO GLU ILE ARG PHE ILE TYR ASP GLN SER LEU VAL GLU          
SEQRES   9 A  128  GLY MET ARG MET SER ASN LEU VAL THR ASN VAL VAL ARG          
SEQRES  10 A  128  GLU ASP GLU LYS LYS HIS VAL GLU GLU SER ASN                  
FORMUL   2  HOH   *169(H2 O)                                                    
CRYST1   46.230   48.090   57.960  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   ARG A   7       3.648 -17.737   0.356  1.00 35.81           N  
ATOM      2  CA  ARG A   7       4.739 -16.841  -0.118  1.00 36.97           C  
ATOM      3  C   ARG A   7       4.261 -15.396  -0.038  1.00 35.44           C  
ATOM      4  O   ARG A   7       4.964 -14.460  -0.464  1.00 35.58           O  
ATOM      5  CB  ARG A   7       5.136 -17.165  -1.576  1.00 39.33           C  
ATOM      6  CG  ARG A   7       5.696 -18.581  -1.835  1.00 42.15           C  
ATOM      7  CD  ARG A   7       6.591 -19.081  -0.687  1.00 43.37           C  
ATOM      8  NE  ARG A   7       7.175 -20.406  -0.910  1.00 45.13           N  
ATOM      9  CZ  ARG A   7       7.875 -21.066   0.017  1.00 46.45           C  
ATOM     10  NH1 ARG A   7       8.066 -20.530   1.212  1.00 47.83           N  
ATOM     11  NH2 ARG A   7       8.402 -22.254  -0.239  1.00 46.05           N  
ATOM     12  N   SER A   8       3.056 -15.215   0.499  1.00 33.95           N  
ATOM     13  CA  SER A   8       2.488 -13.881   0.623  1.00 31.73           C  
ATOM     14  C   SER A   8       3.253 -13.073   1.649  1.00 29.32           C  
ATOM     15  O   SER A   8       3.187 -11.857   1.652  1.00 30.44           O  
ATOM     16  CB  SER A   8       1.016 -13.954   1.019  1.00 32.35           C  
ATOM     17  OG  SER A   8       0.842 -14.643   2.253  1.00 35.37           O  
ATOM     18  N   ASP A   9       3.997 -13.745   2.515  1.00 27.98           N  
ATOM     19  CA  ASP A   9       4.768 -13.043   3.544  1.00 25.16           C  
ATOM     20  C   ASP A   9       5.876 -12.193   2.963  1.00 22.08           C  
ATOM     21  O   ASP A   9       6.126 -11.096   3.444  1.00 21.78           O  
ATOM     22  CB  ASP A   9       5.380 -14.043   4.501  1.00 26.61           C  
ATOM     23  CG  ASP A   9       4.345 -14.735   5.338  1.00 29.33           C  
ATOM     24  OD1 ASP A   9       3.193 -14.241   5.406  1.00 30.33           O  
ATOM     25  OD2 ASP A   9       4.687 -15.766   5.938  1.00 28.62           O  
ATOM     26  N   ARG A  10       6.544 -12.713   1.938  1.00 19.49           N  
ATOM     27  CA  ARG A  10       7.638 -11.998   1.313  1.00 17.22           C  
ATOM     28  C   ARG A  10       7.089 -10.803   0.591  1.00 17.27           C  
ATOM     29  O   ARG A  10       7.687  -9.735   0.654  1.00 17.59           O  
ATOM     30  CB  ARG A  10       8.391 -12.855   0.306  1.00 17.52           C  
ATOM     31  CG  ARG A  10       9.470 -12.072  -0.432  1.00 16.64           C  
ATOM     32  CD  ARG A  10      10.352 -13.000  -1.266  1.00 18.49           C  
ATOM     33  NE  ARG A  10      11.139 -13.901  -0.423  1.00 16.99           N  
ATOM     34  CZ  ARG A  10      12.217 -13.548   0.265  1.00 19.09           C  
ATOM     35  NH1 ARG A  10      12.660 -12.301   0.216  1.00 21.06           N  
ATOM     36  NH2 ARG A  10      12.848 -14.451   1.030  1.00 22.02           N  
ATOM     37  N   VAL A  11       5.970 -10.977  -0.105  1.00 13.63           N  
ATOM     38  CA  VAL A  11       5.388  -9.840  -0.829  1.00 15.48           C  
ATOM     39  C   VAL A  11       4.858  -8.797   0.142  1.00 15.87           C  
ATOM     40  O   VAL A  11       5.128  -7.606  -0.009  1.00 17.87           O  
ATOM     41  CB  VAL A  11       4.305 -10.297  -1.774  1.00 13.51           C  
ATOM     42  CG1 VAL A  11       3.453  -9.083  -2.253  1.00 15.64           C  
ATOM     43  CG2 VAL A  11       4.974 -10.960  -2.959  1.00 15.82           C  
ATOM     44  N   ALA A  12       4.149  -9.251   1.166  1.00 16.91           N  
ATOM     45  CA  ALA A  12       3.626  -8.334   2.175  1.00 15.26           C  
ATOM     46  C   ALA A  12       4.796  -7.580   2.838  1.00 15.13           C  
ATOM     47  O   ALA A  12       4.766  -6.380   2.986  1.00 14.35           O  
ATOM     48  CB  ALA A  12       2.833  -9.117   3.210  1.00 16.76           C  
ATOM     49  N   GLN A  13       5.845  -8.280   3.232  1.00 13.67           N  
ATOM     50  CA  GLN A  13       6.998  -7.618   3.847  1.00 15.50           C  
ATOM     51  C   GLN A  13       7.637  -6.608   2.882  1.00 14.82           C  
ATOM     52  O   GLN A  13       8.018  -5.517   3.280  1.00 16.59           O  
ATOM     53  CB  GLN A  13       8.024  -8.687   4.233  1.00 19.37           C  
ATOM     54  CG  GLN A  13       9.357  -8.229   4.806  1.00 24.87           C  
ATOM     55  CD  GLN A  13      10.200  -9.443   5.240  1.00 27.06           C  
ATOM     56  OE1 GLN A  13      10.469 -10.343   4.439  1.00 29.17           O  
ATOM     57  NE2 GLN A  13      10.593  -9.473   6.509  1.00 30.06           N  
ATOM     58  N   GLU A  14       7.778  -6.979   1.620  1.00 15.29           N  
ATOM     59  CA  GLU A  14       8.370  -6.067   0.633  1.00 13.93           C  
ATOM     60  C   GLU A  14       7.480  -4.845   0.383  1.00 14.11           C  
ATOM     61  O   GLU A  14       7.962  -3.709   0.258  1.00 12.38           O  
ATOM     62  CB  GLU A  14       8.633  -6.809  -0.676  1.00 17.34           C  
ATOM     63  CG  GLU A  14       9.745  -7.874  -0.636  1.00 19.34           C  
ATOM     64  CD  GLU A  14      11.155  -7.335  -0.324  1.00 23.90           C  
ATOM     65  OE1 GLU A  14      11.494  -6.203  -0.742  1.00 20.86           O  
ATOM     66  OE2 GLU A  14      11.935  -8.058   0.343  1.00 23.20           O  
ATOM     67  N   ILE A  15       6.174  -5.061   0.338  1.00 13.54           N  
ATOM     68  CA  ILE A  15       5.269  -3.959   0.088  1.00 10.86           C  
ATOM     69  C   ILE A  15       5.245  -3.013   1.281  1.00 11.46           C  
ATOM     70  O   ILE A  15       5.074  -1.804   1.132  1.00 13.01           O  
ATOM     71  CB  ILE A  15       3.825  -4.473  -0.176  1.00 11.90           C  
ATOM     72  CG1 ILE A  15       3.729  -5.048  -1.595  1.00 10.55           C  
ATOM     73  CG2 ILE A  15       2.820  -3.345   0.093  1.00 15.78           C  
ATOM     74  CD1 ILE A  15       2.335  -5.557  -2.002  1.00 14.91           C  
ATOM     75  N   GLN A  16       5.412  -3.551   2.473  1.00 11.50           N  
ATOM     76  CA  GLN A  16       5.362  -2.705   3.644  1.00 12.29           C  
ATOM     77  C   GLN A  16       6.564  -1.793   3.589  1.00 14.11           C  
ATOM     78  O   GLN A  16       6.441  -0.583   3.801  1.00 14.74           O  
ATOM     79  CB  GLN A  16       5.356  -3.509   4.951  1.00 14.15           C  
ATOM     80  CG  GLN A  16       5.167  -2.560   6.174  1.00 13.89           C  
ATOM     81  CD  GLN A  16       5.007  -3.262   7.550  1.00 16.27           C  
ATOM     82  OE1 GLN A  16       4.990  -2.601   8.578  1.00 19.12           O  
ATOM     83  NE2 GLN A  16       4.885  -4.570   7.551  1.00 15.42           N  
ATOM     84  N   LYS A  17       7.706  -2.372   3.229  1.00 13.31           N  
ATOM     85  CA  LYS A  17       8.937  -1.604   3.133  1.00 15.23           C  
ATOM     86  C   LYS A  17       8.815  -0.489   2.111  1.00 12.99           C  
ATOM     87  O   LYS A  17       9.059   0.682   2.403  1.00 14.95           O  
ATOM     88  CB  LYS A  17      10.105  -2.509   2.726  1.00 16.49           C  
ATOM     89  CG  LYS A  17      10.341  -3.677   3.673  1.00 20.07           C  
ATOM     90  CD  LYS A  17      11.777  -4.273   3.479  1.00 19.00           C  
ATOM     91  CE  LYS A  17      11.866  -5.698   4.042  1.00 21.33           C  
ATOM     92  NZ  LYS A  17      13.229  -6.369   4.005  1.00 21.43           N  
ATOM     93  N   GLU A  18       8.400  -0.866   0.914  1.00 13.81           N  
ATOM     94  CA  GLU A  18       8.312   0.065  -0.203  1.00 13.57           C  
ATOM     95  C   GLU A  18       7.169   1.029  -0.183  1.00 13.89           C  
ATOM     96  O   GLU A  18       7.343   2.182  -0.592  1.00 11.72           O  
ATOM     97  CB  GLU A  18       8.294  -0.724  -1.498  1.00 13.95           C  
ATOM     98  CG  GLU A  18       9.481  -1.679  -1.613  1.00 13.18           C  
ATOM     99  CD  GLU A  18      10.772  -0.976  -1.937  1.00 13.45           C  
ATOM    100  OE1 GLU A  18      10.804   0.271  -2.051  1.00 15.22           O  
ATOM    101  OE2 GLU A  18      11.788  -1.692  -2.072  1.00 18.18           O  
ATOM    102  N   ILE A  19       5.997   0.591   0.277  1.00 12.81           N  
ATOM    103  CA  ILE A  19       4.882   1.529   0.308  1.00 12.00           C  
ATOM    104  C   ILE A  19       5.074   2.595   1.406  1.00 11.98           C  
ATOM    105  O   ILE A  19       4.581   3.712   1.299  1.00 13.65           O  
ATOM    106  CB  ILE A  19       3.551   0.787   0.418  1.00 12.74           C  
ATOM    107  CG1 ILE A  19       2.428   1.673  -0.134  1.00 12.60           C  
ATOM    108  CG2 ILE A  19       3.275   0.394   1.840  1.00 11.02           C  
ATOM    109  CD1 ILE A  19       1.158   0.883  -0.520  1.00  9.61           C  
ATOM    110  N   ALA A  20       5.852   2.273   2.428  1.00 13.65           N  
ATOM    111  CA  ALA A  20       6.173   3.208   3.512  1.00 12.91           C  
ATOM    112  C   ALA A  20       6.895   4.413   2.915  1.00 12.29           C  
ATOM    113  O   ALA A  20       6.544   5.570   3.174  1.00 11.95           O  
ATOM    114  CB  ALA A  20       7.089   2.498   4.545  1.00 15.22           C  
ATOM    115  N   VAL A  21       7.922   4.126   2.127  1.00 12.58           N  
ATOM    116  CA  VAL A  21       8.721   5.152   1.459  1.00 12.33           C  
ATOM    117  C   VAL A  21       7.903   6.052   0.531  1.00 11.61           C  
ATOM    118  O   VAL A  21       8.070   7.259   0.547  1.00 10.55           O  
ATOM    119  CB  VAL A  21       9.888   4.510   0.647  1.00 14.71           C  
ATOM    120  CG1 VAL A  21      10.649   5.596  -0.105  1.00 17.54           C  
ATOM    121  CG2 VAL A  21      10.900   3.797   1.622  1.00 14.30           C  
ATOM    122  N   ILE A  22       7.037   5.440  -0.265  1.00 11.07           N  
ATOM    123  CA  ILE A  22       6.176   6.120  -1.230  1.00 10.21           C  
ATOM    124  C   ILE A  22       5.196   7.010  -0.500  1.00 10.83           C  
ATOM    125  O   ILE A  22       4.979   8.155  -0.878  1.00 12.63           O  
ATOM    126  CB  ILE A  22       5.365   5.075  -2.088  1.00  9.73           C  
ATOM    127  CG1 ILE A  22       6.353   4.282  -2.974  1.00  8.18           C  
ATOM    128  CG2 ILE A  22       4.260   5.797  -2.871  1.00  8.57           C  
ATOM    129  CD1 ILE A  22       5.851   3.023  -3.684  1.00 11.94           C  
ATOM    130  N   LEU A  23       4.611   6.483   0.560  1.00 11.52           N  
ATOM    131  CA  LEU A  23       3.618   7.264   1.298  1.00 12.57           C  
ATOM    132  C   LEU A  23       4.211   8.451   2.006  1.00 13.02           C  
ATOM    133  O   LEU A  23       3.555   9.482   2.135  1.00 15.70           O  
ATOM    134  CB  LEU A  23       2.871   6.378   2.289  1.00 11.42           C  
ATOM    135  CG  LEU A  23       1.901   5.362   1.663  1.00 11.45           C  
ATOM    136  CD1 LEU A  23       1.250   4.580   2.797  1.00 15.04           C  
ATOM    137  CD2 LEU A  23       0.815   6.031   0.782  1.00 13.91           C  
ATOM    138  N   GLN A  24       5.446   8.320   2.477  1.00 15.76           N  
ATOM    139  CA  GLN A  24       6.101   9.418   3.178  1.00 16.74           C  
ATOM    140  C   GLN A  24       6.500  10.530   2.229  1.00 17.44           C  
ATOM    141  O   GLN A  24       6.525  11.710   2.579  1.00 17.36           O  
ATOM    142  CB  GLN A  24       7.342   8.893   3.861  1.00 17.42           C  
ATOM    143  CG  GLN A  24       7.872   9.828   4.886  1.00 25.10           C  
ATOM    144  CD  GLN A  24       8.702   9.086   5.873  1.00 27.90           C  
ATOM    145  OE1 GLN A  24       9.813   8.665   5.560  1.00 31.80           O  
ATOM    146  NE2 GLN A  24       8.162   8.886   7.078  1.00 32.62           N  
ATOM    147  N   ARG A  25       6.826  10.135   1.013  1.00 17.59           N  
ATOM    148  CA  ARG A  25       7.250  11.095   0.013  1.00 18.82           C  
ATOM    149  C   ARG A  25       6.107  11.679  -0.796  1.00 18.66           C  
ATOM    150  O   ARG A  25       6.076  12.889  -1.058  1.00 18.50           O  
ATOM    151  CB  ARG A  25       8.218  10.424  -0.945  1.00 21.20           C  
ATOM    152  CG  ARG A  25       8.746  11.329  -2.033  1.00 24.36           C  
ATOM    153  CD  ARG A  25       9.671  10.549  -2.954  1.00 25.47           C  
ATOM    154  NE  ARG A  25       8.970   9.617  -3.842  1.00 27.01           N  
ATOM    155  CZ  ARG A  25       9.194   8.311  -3.892  1.00 25.36           C  
ATOM    156  NH1 ARG A  25      10.099   7.752  -3.087  1.00 26.44           N  
ATOM    157  NH2 ARG A  25       8.530   7.564  -4.766  1.00 24.37           N  
ATOM    158  N   GLU A  26       5.151  10.843  -1.177  1.00 15.53           N  
ATOM    159  CA  GLU A  26       4.098  11.338  -2.057  1.00 15.48           C  
ATOM    160  C   GLU A  26       2.888  11.993  -1.440  1.00 15.45           C  
ATOM    161  O   GLU A  26       2.277  12.861  -2.069  1.00 15.37           O  
ATOM    162  CB  GLU A  26       3.599  10.226  -2.993  1.00 15.88           C  
ATOM    163  CG  GLU A  26       4.661   9.529  -3.831  1.00 16.22           C  
ATOM    164  CD  GLU A  26       5.414  10.481  -4.763  1.00 15.04           C  
ATOM    165  OE1 GLU A  26       4.797  11.422  -5.316  1.00 15.82           O  
ATOM    166  OE2 GLU A  26       6.645  10.274  -4.946  1.00 21.97           O  
ATOM    167  N   VAL A  27       2.526  11.580  -0.234  1.00 14.19           N  
ATOM    168  CA  VAL A  27       1.335  12.127   0.374  1.00 15.93           C  
ATOM    169  C   VAL A  27       1.680  13.351   1.171  1.00 17.01           C  
ATOM    170  O   VAL A  27       2.351  13.263   2.178  1.00 17.55           O  
ATOM    171  CB  VAL A  27       0.642  11.107   1.319  1.00 13.49           C  
ATOM    172  CG1 VAL A  27      -0.688  11.643   1.749  1.00 14.08           C  
ATOM    173  CG2 VAL A  27       0.444   9.759   0.596  1.00 14.96           C  
ATOM    174  N   LYS A  28       1.210  14.500   0.703  1.00 19.19           N  
ATOM    175  CA  LYS A  28       1.446  15.740   1.395  1.00 20.20           C  
ATOM    176  C   LYS A  28       0.095  16.406   1.669  1.00 20.78           C  
ATOM    177  O   LYS A  28      -0.476  17.068   0.799  1.00 19.27           O  
ATOM    178  CB  LYS A  28       2.306  16.672   0.550  1.00 23.02           C  
ATOM    179  CG  LYS A  28       3.593  16.070   0.054  1.00 23.29           C  
ATOM    180  CD  LYS A  28       4.487  15.721   1.213  1.00 24.92           C  
ATOM    181  CE  LYS A  28       5.889  15.367   0.729  1.00 26.94           C  
ATOM    182  NZ  LYS A  28       6.747  15.017   1.901  1.00 28.08           N  
ATOM    183  N   ASP A  29      -0.410  16.221   2.881  1.00 19.35           N  
ATOM    184  CA  ASP A  29      -1.664  16.833   3.307  1.00 18.16           C  
ATOM    185  C   ASP A  29      -1.411  17.269   4.757  1.00 18.81           C  
ATOM    186  O   ASP A  29      -1.215  16.429   5.636  1.00 18.31           O  
ATOM    187  CB  ASP A  29      -2.805  15.814   3.204  1.00 18.75           C  
ATOM    188  CG  ASP A  29      -4.116  16.331   3.753  1.00 18.23           C  
ATOM    189  OD1 ASP A  29      -4.119  17.416   4.374  1.00 19.38           O  
ATOM    190  OD2 ASP A  29      -5.162  15.647   3.581  1.00 18.25           O  
ATOM    191  N   PRO A  30      -1.363  18.588   5.016  1.00 16.88           N  
ATOM    192  CA  PRO A  30      -1.127  19.108   6.363  1.00 15.38           C  
ATOM    193  C   PRO A  30      -2.163  18.737   7.388  1.00 13.56           C  
ATOM    194  O   PRO A  30      -1.871  18.777   8.611  1.00 11.96           O  
ATOM    195  CB  PRO A  30      -1.049  20.623   6.152  1.00 16.63           C  
ATOM    196  CG  PRO A  30      -1.825  20.857   4.925  1.00 17.66           C  
ATOM    197  CD  PRO A  30      -1.402  19.696   4.049  1.00 18.93           C  
ATOM    198  N   ARG A  31      -3.386  18.418   6.938  1.00 10.42           N  
ATOM    199  CA  ARG A  31      -4.369  18.031   7.939  1.00 10.56           C  
ATOM    200  C   ARG A  31      -4.177  16.622   8.447  1.00 10.51           C  
ATOM    201  O   ARG A  31      -4.794  16.239   9.434  1.00 12.15           O  
ATOM    202  CB  ARG A  31      -5.778  18.098   7.423  1.00  8.91           C  
ATOM    203  CG  ARG A  31      -6.207  19.461   6.990  1.00 12.39           C  
ATOM    204  CD  ARG A  31      -7.742  19.462   7.080  1.00 10.26           C  
ATOM    205  NE  ARG A  31      -8.352  20.709   6.614  1.00 14.07           N  
ATOM    206  CZ  ARG A  31      -8.809  21.656   7.418  1.00 12.05           C  
ATOM    207  NH1 ARG A  31      -8.712  21.518   8.725  1.00 10.63           N  
ATOM    208  NH2 ARG A  31      -9.410  22.714   6.899  1.00 12.67           N  
ATOM    209  N   ILE A  32      -3.392  15.825   7.764  1.00  9.70           N  
ATOM    210  CA  ILE A  32      -3.195  14.470   8.296  1.00  8.51           C  
ATOM    211  C   ILE A  32      -1.731  14.213   8.633  1.00  8.99           C  
ATOM    212  O   ILE A  32      -1.396  13.364   9.441  1.00  8.89           O  
ATOM    213  CB  ILE A  32      -3.681  13.351   7.334  1.00 10.20           C  
ATOM    214  CG1 ILE A  32      -2.875  13.350   6.018  1.00  7.67           C  
ATOM    215  CG2 ILE A  32      -5.141  13.493   7.031  1.00  8.23           C  
ATOM    216  CD1 ILE A  32      -3.347  12.320   4.985  1.00 10.46           C  
ATOM    217  N   GLY A  33      -0.846  14.983   8.029  1.00  9.32           N  
ATOM    218  CA  GLY A  33       0.549  14.784   8.305  1.00  9.44           C  
ATOM    219  C   GLY A  33       1.092  13.482   7.756  1.00 10.71           C  
ATOM    220  O   GLY A  33       0.516  12.903   6.825  1.00 12.41           O  
ATOM    221  N   MET A  34       2.190  13.012   8.331  1.00 11.40           N  
ATOM    222  CA  MET A  34       2.807  11.804   7.844  1.00 11.45           C  
ATOM    223  C   MET A  34       1.886  10.630   7.880  1.00  9.94           C  
ATOM    224  O   MET A  34       1.198  10.408   8.877  1.00  8.88           O  
ATOM    225  CB  MET A  34       4.061  11.446   8.626  1.00 14.90           C  
ATOM    226  CG  MET A  34       4.973  10.515   7.810  1.00 18.40           C  
ATOM    227  SD  MET A  34       6.286   9.983   8.802  1.00 26.39           S  
ATOM    228  CE  MET A  34       5.331   9.117  10.009  1.00 24.37           C  
ATOM    229  N   VAL A  35       1.886   9.883   6.786  1.00  8.55           N  
ATOM    230  CA  VAL A  35       1.079   8.672   6.716  1.00  8.91           C  
ATOM    231  C   VAL A  35       2.051   7.532   7.026  1.00 11.10           C  
ATOM    232  O   VAL A  35       3.062   7.352   6.361  1.00 10.52           O  
ATOM    233  CB  VAL A  35       0.411   8.424   5.333  1.00 12.42           C  
ATOM    234  CG1 VAL A  35      -0.279   7.074   5.336  1.00 12.16           C  
ATOM    235  CG2 VAL A  35      -0.624   9.445   5.062  1.00 13.35           C  
ATOM    236  N   THR A  36       1.751   6.805   8.090  1.00 10.24           N  
ATOM    237  CA  THR A  36       2.567   5.699   8.539  1.00 10.90           C  
ATOM    238  C   THR A  36       1.924   4.373   8.192  1.00 10.26           C  
ATOM    239  O   THR A  36       0.706   4.247   8.227  1.00  9.86           O  
ATOM    240  CB  THR A  36       2.787   5.820  10.079  1.00 11.70           C  
ATOM    241  OG1 THR A  36       3.717   6.887  10.335  1.00 12.27           O  
ATOM    242  CG2 THR A  36       3.349   4.534  10.682  1.00 11.66           C  
ATOM    243  N   VAL A  37       2.738   3.375   7.847  0.50  9.95           N  
ATOM    245  CA  VAL A  37       2.181   2.074   7.493  0.50 10.04           C  
ATOM    247  C   VAL A  37       2.380   1.153   8.665  0.50 10.59           C  
ATOM    249  O   VAL A  37       3.507   0.904   9.062  0.50 11.08           O  
ATOM    251  CB  VAL A  37       2.851   1.486   6.207  0.50  9.33           C  
ATOM    253  CG1 VAL A  37       2.504   2.371   5.024  0.50 11.87           C  
ATOM    255  CG2 VAL A  37       4.363   1.408   6.366  0.50 11.06           C  
ATOM    257  N   SER A  38       1.288   0.658   9.240  1.00 10.12           N  
ATOM    258  CA  SER A  38       1.416  -0.206  10.400  1.00 11.78           C  
ATOM    259  C   SER A  38       1.556  -1.662  10.124  1.00 13.50           C  
ATOM    260  O   SER A  38       2.120  -2.396  10.939  1.00 14.35           O  
ATOM    261  CB  SER A  38       0.259  -0.011  11.366  1.00 14.00           C  
ATOM    262  OG  SER A  38      -0.977  -0.211  10.710  1.00 15.13           O  
ATOM    263  N   ASP A  39       1.033  -2.082   8.983  1.00 13.13           N  
ATOM    264  CA  ASP A  39       1.108  -3.472   8.573  1.00 11.51           C  
ATOM    265  C   ASP A  39       0.562  -3.620   7.170  1.00 10.04           C  
ATOM    266  O   ASP A  39      -0.060  -2.708   6.629  1.00  8.93           O  
ATOM    267  CB  ASP A  39       0.311  -4.352   9.528  1.00 11.73           C  
ATOM    268  CG  ASP A  39       0.846  -5.784   9.578  1.00 20.58           C  
ATOM    269  OD1 ASP A  39       1.953  -6.057   9.016  1.00 20.58           O  
ATOM    270  OD2 ASP A  39       0.156  -6.628  10.174  1.00 19.86           O  
ATOM    271  N   VAL A  40       0.851  -4.779   6.573  1.00 10.15           N  
ATOM    272  CA  VAL A  40       0.402  -5.119   5.249  1.00  9.44           C  
ATOM    273  C   VAL A  40       0.069  -6.597   5.260  1.00 10.56           C  
ATOM    274  O   VAL A  40       0.831  -7.401   5.820  1.00 11.89           O  
ATOM    275  CB  VAL A  40       1.497  -4.898   4.209  1.00  8.26           C  
ATOM    276  CG1 VAL A  40       1.062  -5.487   2.863  1.00 10.92           C  
ATOM    277  CG2 VAL A  40       1.731  -3.365   4.074  1.00  9.69           C  
ATOM    278  N   GLU A  41      -1.092  -6.923   4.710  1.00 10.26           N  
ATOM    279  CA  GLU A  41      -1.521  -8.304   4.582  1.00 12.41           C  
ATOM    280  C   GLU A  41      -1.700  -8.546   3.101  1.00 12.03           C  
ATOM    281  O   GLU A  41      -2.151  -7.671   2.368  1.00 11.95           O  
ATOM    282  CB  GLU A  41      -2.830  -8.541   5.323  1.00 13.24           C  
ATOM    283  CG  GLU A  41      -2.697  -8.354   6.811  1.00 17.51           C  
ATOM    284  CD  GLU A  41      -4.000  -8.576   7.576  1.00 17.79           C  
ATOM    285  OE1 GLU A  41      -5.044  -8.756   6.933  1.00 21.39           O  
ATOM    286  OE2 GLU A  41      -3.974  -8.562   8.831  1.00 20.25           O  
ATOM    287  N   VAL A  42      -1.319  -9.724   2.632  1.00 12.06           N  
ATOM    288  CA  VAL A  42      -1.458 -10.020   1.209  1.00 12.92           C  
ATOM    289  C   VAL A  42      -2.136 -11.368   1.155  1.00 14.63           C  
ATOM    290  O   VAL A  42      -1.791 -12.246   1.935  1.00 14.44           O  
ATOM    291  CB  VAL A  42      -0.101 -10.150   0.520  1.00 13.31           C  
ATOM    292  CG1 VAL A  42      -0.289 -10.713  -0.863  1.00 11.78           C  
ATOM    293  CG2 VAL A  42       0.588  -8.811   0.439  1.00 10.37           C  
ATOM    294  N   SER A  43      -3.079 -11.517   0.229  1.00 16.17           N  
ATOM    295  CA  SER A  43      -3.832 -12.762   0.063  1.00 18.19           C  
ATOM    296  C   SER A  43      -2.928 -13.903  -0.444  1.00 19.36           C  
ATOM    297  O   SER A  43      -1.885 -13.633  -1.029  1.00 18.39           O  
ATOM    298  CB  SER A  43      -5.014 -12.515  -0.897  1.00 16.37           C  
ATOM    299  OG  SER A  43      -4.574 -12.088  -2.174  1.00 15.72           O  
ATOM    300  N   SER A  44      -3.314 -15.165  -0.203  1.00 20.61           N  
ATOM    301  CA  SER A  44      -2.509 -16.338  -0.635  1.00 21.40           C  
ATOM    302  C   SER A  44      -2.187 -16.346  -2.115  1.00 21.02           C  
ATOM    303  O   SER A  44      -1.082 -16.757  -2.509  1.00 23.38           O  
ATOM    304  CB  SER A  44      -3.200 -17.661  -0.256  1.00 22.05           C  
ATOM    305  OG  SER A  44      -4.536 -17.691  -0.720  1.00 23.23           O  
ATOM    306  N   ASP A  45      -3.119 -15.873  -2.931  1.00 21.86           N  
ATOM    307  CA  ASP A  45      -2.908 -15.799  -4.384  1.00 21.90           C  
ATOM    308  C   ASP A  45      -2.132 -14.545  -4.840  1.00 21.34           C  
ATOM    309  O   ASP A  45      -2.058 -14.241  -6.043  1.00 20.96           O  
ATOM    310  CB  ASP A  45      -4.247 -15.900  -5.151  1.00 22.58           C  
ATOM    311  CG  ASP A  45      -5.181 -14.687  -4.949  1.00 24.98           C  
ATOM    312  OD1 ASP A  45      -4.815 -13.704  -4.280  1.00 22.89           O  
ATOM    313  OD2 ASP A  45      -6.312 -14.734  -5.504  1.00 24.71           O  
ATOM    314  N   LEU A  46      -1.558 -13.830  -3.870  1.00 19.53           N  
ATOM    315  CA  LEU A  46      -0.756 -12.619  -4.126  1.00 18.07           C  
ATOM    316  C   LEU A  46      -1.480 -11.565  -4.960  1.00 18.60           C  
ATOM    317  O   LEU A  46      -0.865 -10.648  -5.502  1.00 17.04           O  
ATOM    318  CB  LEU A  46       0.546 -13.019  -4.818  1.00 16.74           C  
ATOM    319  CG  LEU A  46       1.405 -14.047  -4.070  1.00 14.00           C  
ATOM    320  CD1 LEU A  46       2.651 -14.363  -4.861  1.00 16.53           C  
ATOM    321  CD2 LEU A  46       1.794 -13.518  -2.708  1.00 14.05           C  
ATOM    322  N   SER A  47      -2.797 -11.684  -5.021  1.00 18.17           N  
ATOM    323  CA  SER A  47      -3.607 -10.778  -5.830  1.00 19.25           C  
ATOM    324  C   SER A  47      -4.103  -9.514  -5.134  1.00 18.07           C  
ATOM    325  O   SER A  47      -4.373  -8.501  -5.796  1.00 17.52           O  
ATOM    326  CB  SER A  47      -4.812 -11.561  -6.357  1.00 21.39           C  
ATOM    327  OG  SER A  47      -5.823 -10.700  -6.831  1.00 24.93           O  
ATOM    328  N   TYR A  48      -4.248  -9.568  -3.816  1.00 16.51           N  
ATOM    329  CA  TYR A  48      -4.796  -8.408  -3.101  1.00 14.86           C  
ATOM    330  C   TYR A  48      -3.950  -8.047  -1.900  1.00 13.07           C  
ATOM    331  O   TYR A  48      -3.400  -8.917  -1.231  1.00 13.10           O  
ATOM    332  CB  TYR A  48      -6.246  -8.686  -2.610  1.00 16.15           C  
ATOM    333  CG  TYR A  48      -7.125  -9.204  -3.697  1.00 20.11           C  
ATOM    334  CD1 TYR A  48      -7.761  -8.326  -4.600  1.00 20.55           C  
ATOM    335  CD2 TYR A  48      -7.377 -10.558  -3.881  1.00 21.83           C  
ATOM    336  CE1 TYR A  48      -8.550  -8.780  -5.638  1.00 23.93           C  
ATOM    337  CE2 TYR A  48      -8.167 -11.010  -4.921  1.00 23.78           C  
ATOM    338  CZ  TYR A  48      -8.738 -10.139  -5.805  1.00 23.96           C  
ATOM    339  OH  TYR A  48      -9.495 -10.621  -6.851  1.00 29.49           O  
ATOM    340  N   ALA A  49      -3.856  -6.751  -1.609  1.00 10.96           N  
ATOM    341  CA  ALA A  49      -3.121  -6.372  -0.434  1.00 10.12           C  
ATOM    342  C   ALA A  49      -3.903  -5.359   0.339  1.00 10.00           C  
ATOM    343  O   ALA A  49      -4.531  -4.480  -0.253  1.00 12.79           O  
ATOM    344  CB  ALA A  49      -1.779  -5.819  -0.794  1.00  6.61           C  
ATOM    345  N   LYS A  50      -3.845  -5.480   1.669  1.00 10.48           N  
ATOM    346  CA  LYS A  50      -4.519  -4.559   2.586  1.00  8.78           C  
ATOM    347  C   LYS A  50      -3.425  -3.776   3.236  1.00  9.09           C  
ATOM    348  O   LYS A  50      -2.532  -4.360   3.815  1.00  9.99           O  
ATOM    349  CB  LYS A  50      -5.274  -5.307   3.667  1.00 13.13           C  
ATOM    350  CG  LYS A  50      -6.339  -6.177   3.094  1.00 13.34           C  
ATOM    351  CD  LYS A  50      -7.639  -5.946   3.799  1.00 19.75           C  
ATOM    352  CE  LYS A  50      -7.626  -6.573   5.163  1.00 18.08           C  
ATOM    353  NZ  LYS A  50      -7.854  -8.037   4.979  1.00 24.29           N  
ATOM    354  N   ILE A  51      -3.515  -2.445   3.158  1.00  5.90           N  
ATOM    355  CA  ILE A  51      -2.488  -1.578   3.714  1.00  6.67           C  
ATOM    356  C   ILE A  51      -3.074  -0.878   4.945  1.00  6.66           C  
ATOM    357  O   ILE A  51      -3.929  -0.044   4.782  1.00  8.17           O  
ATOM    358  CB  ILE A  51      -2.086  -0.482   2.659  1.00  6.15           C  
ATOM    359  CG1 ILE A  51      -1.722  -1.134   1.319  1.00  9.56           C  
ATOM    360  CG2 ILE A  51      -0.860   0.363   3.206  1.00  8.28           C  
ATOM    361  CD1 ILE A  51      -0.514  -2.065   1.447  1.00 11.18           C  
ATOM    362  N   PHE A  52      -2.610  -1.241   6.155  1.00  6.31           N  
ATOM    363  CA  PHE A  52      -3.095  -0.624   7.400  1.00  6.87           C  
ATOM    364  C   PHE A  52      -2.259   0.608   7.627  1.00  7.88           C  
ATOM    365  O   PHE A  52      -1.044   0.538   7.647  1.00  8.38           O  
ATOM    366  CB  PHE A  52      -2.987  -1.572   8.607  1.00  8.37           C  
ATOM    367  CG  PHE A  52      -4.005  -2.652   8.443  1.00  9.51           C  
ATOM    368  CD1 PHE A  52      -5.274  -2.474   8.947  1.00  8.86           C  
ATOM    369  CD2 PHE A  52      -3.690  -3.811   7.772  1.00 11.72           C  
ATOM    370  CE1 PHE A  52      -6.239  -3.425   8.718  1.00  9.31           C  
ATOM    371  CE2 PHE A  52      -4.667  -4.781   7.542  1.00 11.51           C  
ATOM    372  CZ  PHE A  52      -5.945  -4.575   8.012  1.00  8.50           C  
ATOM    373  N   VAL A  53      -2.923   1.749   7.799  1.00  6.72           N  
ATOM    374  CA  VAL A  53      -2.208   2.988   7.998  1.00  7.44           C  
ATOM    375  C   VAL A  53      -2.696   3.827   9.163  1.00  5.51           C  
ATOM    376  O   VAL A  53      -3.809   3.647   9.679  1.00  5.08           O  
ATOM    377  CB  VAL A  53      -2.318   3.872   6.717  1.00  4.28           C  
ATOM    378  CG1 VAL A  53      -1.841   3.105   5.516  1.00  7.78           C  
ATOM    379  CG2 VAL A  53      -3.781   4.303   6.508  1.00  5.14           C  
ATOM    380  N   THR A  54      -1.817   4.686   9.645  1.00  6.04           N  
ATOM    381  CA  THR A  54      -2.236   5.677  10.630  1.00  6.22           C  
ATOM    382  C   THR A  54      -1.712   7.041  10.152  1.00  7.32           C  
ATOM    383  O   THR A  54      -0.726   7.120   9.379  1.00  8.50           O  
ATOM    384  CB  THR A  54      -1.773   5.407  12.069  1.00  5.61           C  
ATOM    385  OG1 THR A  54      -0.339   5.468  12.153  1.00  7.73           O  
ATOM    386  CG2 THR A  54      -2.295   4.035  12.544  1.00  9.62           C  
ATOM    387  N   PHE A  55      -2.406   8.100  10.547  1.00  8.28           N  
ATOM    388  CA  PHE A  55      -2.012   9.481  10.205  1.00  7.34           C  
ATOM    389  C   PHE A  55      -1.506  10.201  11.467  1.00 10.18           C  
ATOM    390  O   PHE A  55      -2.045  10.019  12.591  1.00  9.85           O  
ATOM    391  CB  PHE A  55      -3.197  10.274   9.682  1.00  7.91           C  
ATOM    392  CG  PHE A  55      -3.900   9.663   8.492  1.00  6.59           C  
ATOM    393  CD1 PHE A  55      -3.229   8.781   7.631  1.00  7.42           C  
ATOM    394  CD2 PHE A  55      -5.196  10.046   8.161  1.00  8.11           C  
ATOM    395  CE1 PHE A  55      -3.845   8.285   6.474  1.00  8.12           C  
ATOM    396  CE2 PHE A  55      -5.829   9.556   6.981  1.00  4.23           C  
ATOM    397  CZ  PHE A  55      -5.148   8.672   6.148  1.00  6.40           C  
ATOM    398  N   LEU A  56      -0.503  11.055  11.292  1.00  7.61           N  
ATOM    399  CA  LEU A  56       0.028  11.790  12.427  1.00  8.26           C  
ATOM    400  C   LEU A  56      -1.084  12.606  13.146  1.00  7.36           C  
ATOM    401  O   LEU A  56      -1.124  12.633  14.374  1.00  8.67           O  
ATOM    402  CB  LEU A  56       1.138  12.754  11.990  1.00 11.47           C  
ATOM    403  CG  LEU A  56       1.672  13.609  13.130  1.00 11.07           C  
ATOM    404  CD1 LEU A  56       2.302  12.740  14.198  1.00 13.55           C  
ATOM    405  CD2 LEU A  56       2.678  14.649  12.583  1.00 14.37           C  
ATOM    406  N   PHE A  57      -1.953  13.281  12.398  1.00  7.84           N  
ATOM    407  CA  PHE A  57      -3.041  14.044  13.023  1.00  8.07           C  
ATOM    408  C   PHE A  57      -4.296  13.204  12.860  1.00  8.95           C  
ATOM    409  O   PHE A  57      -4.780  13.011  11.754  1.00  8.70           O  
ATOM    410  CB  PHE A  57      -3.209  15.451  12.386  1.00  7.79           C  
ATOM    411  CG  PHE A  57      -1.953  16.247  12.532  1.00 12.13           C  
ATOM    412  CD1 PHE A  57      -1.529  16.713  13.780  1.00 12.32           C  
ATOM    413  CD2 PHE A  57      -1.143  16.531  11.437  1.00 10.30           C  
ATOM    414  CE1 PHE A  57      -0.344  17.413  13.941  1.00 12.87           C  
ATOM    415  CE2 PHE A  57       0.051  17.214  11.575  1.00 12.13           C  
ATOM    416  CZ  PHE A  57       0.455  17.669  12.834  1.00 11.78           C  
ATOM    417  N   ASP A  58      -4.831  12.706  13.984  1.00 10.06           N  
ATOM    418  CA  ASP A  58      -6.001  11.817  13.955  1.00  9.97           C  
ATOM    419  C   ASP A  58      -7.171  12.278  14.805  1.00  9.55           C  
ATOM    420  O   ASP A  58      -7.970  11.446  15.233  1.00 12.60           O  
ATOM    421  CB  ASP A  58      -5.614  10.399  14.423  1.00 12.23           C  
ATOM    422  CG  ASP A  58      -4.945  10.379  15.802  1.00 13.11           C  
ATOM    423  OD1 ASP A  58      -4.915  11.395  16.511  1.00 10.43           O  
ATOM    424  OD2 ASP A  58      -4.437   9.308  16.203  1.00 16.59           O  
ATOM    425  N   HIS A  59      -7.282  13.581  15.037  1.00 10.13           N  
ATOM    426  CA  HIS A  59      -8.328  14.109  15.894  1.00 10.54           C  
ATOM    427  C   HIS A  59      -9.565  14.599  15.158  1.00 11.38           C  
ATOM    428  O   HIS A  59     -10.636  14.692  15.743  1.00 15.20           O  
ATOM    429  CB  HIS A  59      -7.771  15.254  16.739  1.00  9.49           C  
ATOM    430  CG  HIS A  59      -7.217  16.373  15.915  1.00 10.15           C  
ATOM    431  ND1 HIS A  59      -5.907  16.416  15.508  1.00 11.76           N  
ATOM    432  CD2 HIS A  59      -7.803  17.492  15.434  1.00 11.46           C  
ATOM    433  CE1 HIS A  59      -5.699  17.527  14.821  1.00 12.31           C  
ATOM    434  NE2 HIS A  59      -6.835  18.193  14.759  1.00 11.15           N  
ATOM    435  N   ASP A  60      -9.403  14.948  13.892  1.00 10.84           N  
ATOM    436  CA  ASP A  60     -10.502  15.440  13.042  1.00 10.70           C  
ATOM    437  C   ASP A  60     -10.962  14.291  12.158  1.00 11.33           C  
ATOM    438  O   ASP A  60     -10.241  13.896  11.210  1.00  9.68           O  
ATOM    439  CB  ASP A  60      -9.974  16.596  12.172  1.00  9.75           C  
ATOM    440  CG  ASP A  60     -11.007  17.171  11.230  1.00 13.97           C  
ATOM    441  OD1 ASP A  60     -12.081  16.526  10.996  1.00  9.63           O  
ATOM    442  OD2 ASP A  60     -10.713  18.288  10.702  1.00 11.03           O  
ATOM    443  N   GLU A  61     -12.168  13.789  12.448  1.00 10.21           N  
ATOM    444  CA  GLU A  61     -12.751  12.653  11.739  1.00 13.80           C  
ATOM    445  C   GLU A  61     -13.006  12.944  10.263  1.00 11.54           C  
ATOM    446  O   GLU A  61     -12.872  12.040   9.426  1.00 12.25           O  
ATOM    447  CB  GLU A  61     -14.045  12.215  12.488  1.00 18.25           C  
ATOM    448  CG  GLU A  61     -14.341  10.726  12.489  1.00 27.69           C  
ATOM    449  CD  GLU A  61     -15.340  10.309  11.400  1.00 31.19           C  
ATOM    450  OE1 GLU A  61     -15.078  10.629  10.216  1.00 35.55           O  
ATOM    451  OE2 GLU A  61     -16.381   9.669  11.731  1.00 34.62           O  
ATOM    452  N   MET A  62     -13.353  14.189   9.932  0.50 11.03           N  
ATOM    454  CA  MET A  62     -13.588  14.524   8.530  0.50 11.55           C  
ATOM    456  C   MET A  62     -12.266  14.563   7.763  0.50  9.98           C  
ATOM    458  O   MET A  62     -12.214  14.220   6.585  0.50 12.06           O  
ATOM    460  CB  MET A  62     -14.305  15.877   8.387  0.50 12.61           C  
ATOM    462  CG  MET A  62     -15.703  15.782   7.778  0.50 14.62           C  
ATOM    464  SD  MET A  62     -16.285  17.358   7.100  0.50 16.02           S  
ATOM    466  CE  MET A  62     -15.007  17.662   5.983  0.50 17.22           C  
ATOM    468  N   ALA A  63     -11.190  14.945   8.443  1.00 11.22           N  
ATOM    469  CA  ALA A  63      -9.858  15.043   7.813  1.00  7.72           C  
ATOM    470  C   ALA A  63      -9.350  13.655   7.546  1.00  8.11           C  
ATOM    471  O   ALA A  63      -8.780  13.398   6.478  1.00  7.40           O  
ATOM    472  CB  ALA A  63      -8.882  15.776   8.730  1.00 10.40           C  
ATOM    473  N   ILE A  64      -9.578  12.752   8.503  1.00  6.96           N  
ATOM    474  CA  ILE A  64      -9.169  11.382   8.310  1.00  8.05           C  
ATOM    475  C   ILE A  64      -9.898  10.807   7.076  1.00  9.87           C  
ATOM    476  O   ILE A  64      -9.292  10.179   6.213  1.00  7.81           O  
ATOM    477  CB  ILE A  64      -9.486  10.542   9.530  1.00  6.21           C  
ATOM    478  CG1 ILE A  64      -8.503  10.887  10.655  1.00 10.23           C  
ATOM    479  CG2 ILE A  64      -9.403   9.085   9.194  1.00  7.89           C  
ATOM    480  CD1 ILE A  64      -8.893  10.258  12.062  1.00 12.95           C  
ATOM    481  N   GLU A  65     -11.204  11.044   6.976  1.00  9.20           N  
ATOM    482  CA  GLU A  65     -11.921  10.529   5.820  1.00 11.00           C  
ATOM    483  C   GLU A  65     -11.355  11.065   4.502  1.00 11.58           C  
ATOM    484  O   GLU A  65     -11.154  10.313   3.556  1.00 11.30           O  
ATOM    485  CB  GLU A  65     -13.397  10.880   5.954  1.00 10.17           C  
ATOM    486  CG  GLU A  65     -14.264  10.480   4.780  1.00 11.20           C  
ATOM    487  CD  GLU A  65     -14.152   8.999   4.402  1.00 14.30           C  
ATOM    488  OE1 GLU A  65     -14.014   8.165   5.304  1.00 11.85           O  
ATOM    489  OE2 GLU A  65     -14.204   8.661   3.180  1.00 14.48           O  
ATOM    490  N   GLN A  66     -11.099  12.367   4.429  1.00 10.88           N  
ATOM    491  CA  GLN A  66     -10.563  12.994   3.231  1.00 12.33           C  
ATOM    492  C   GLN A  66      -9.197  12.386   2.935  1.00 12.43           C  
ATOM    493  O   GLN A  66      -8.845  12.122   1.786  1.00 11.45           O  
ATOM    494  CB  GLN A  66     -10.489  14.517   3.462  1.00 13.75           C  
ATOM    495  CG  GLN A  66      -9.790  15.359   2.398  1.00 16.70           C  
ATOM    496  CD  GLN A  66      -9.965  16.853   2.629  1.00 18.29           C  
ATOM    497  OE1 GLN A  66     -10.731  17.551   1.929  1.00 18.34           O  
ATOM    498  NE2 GLN A  66      -9.275  17.348   3.615  1.00 19.73           N  
ATOM    499  N   GLY A  67      -8.415  12.136   3.971  1.00 11.35           N  
ATOM    500  CA  GLY A  67      -7.121  11.545   3.720  1.00  9.97           C  
ATOM    501  C   GLY A  67      -7.325  10.148   3.142  1.00  9.80           C  
ATOM    502  O   GLY A  67      -6.645   9.812   2.187  1.00  7.56           O  
ATOM    503  N   MET A  68      -8.240   9.338   3.686  1.00  8.60           N  
ATOM    504  CA  MET A  68      -8.488   7.973   3.147  1.00 10.54           C  
ATOM    505  C   MET A  68      -9.049   8.027   1.693  1.00 11.02           C  
ATOM    506  O   MET A  68      -8.772   7.159   0.887  1.00 10.40           O  
ATOM    507  CB  MET A  68      -9.457   7.207   4.056  1.00 10.33           C  
ATOM    508  CG  MET A  68      -8.906   6.926   5.456  1.00 10.76           C  
ATOM    509  SD  MET A  68      -7.437   5.875   5.486  1.00 11.20           S  
ATOM    510  CE  MET A  68      -8.102   4.406   4.947  1.00 14.77           C  
ATOM    511  N   LYS A  69      -9.837   9.046   1.365  1.00 10.37           N  
ATOM    512  CA  LYS A  69     -10.320   9.202  -0.013  1.00 11.79           C  
ATOM    513  C   LYS A  69      -9.160   9.589  -0.935  1.00 10.58           C  
ATOM    514  O   LYS A  69      -9.128   9.175  -2.083  1.00 11.19           O  
ATOM    515  CB  LYS A  69     -11.376  10.305  -0.123  1.00 12.75           C  
ATOM    516  CG  LYS A  69     -12.688   9.944   0.481  1.00 15.73           C  
ATOM    517  CD  LYS A  69     -13.823  10.744  -0.133  1.00 18.55           C  
ATOM    518  CE  LYS A  69     -15.228  10.214   0.280  1.00 18.44           C  
ATOM    519  NZ  LYS A  69     -15.704  10.647   1.653  1.00 19.45           N  
ATOM    520  N   GLY A  70      -8.228  10.399  -0.442  1.00 10.86           N  
ATOM    521  CA  GLY A  70      -7.077  10.829  -1.247  1.00  8.88           C  
ATOM    522  C   GLY A  70      -6.218   9.627  -1.539  1.00 11.41           C  
ATOM    523  O   GLY A  70      -5.682   9.510  -2.646  1.00  9.42           O  
ATOM    524  N   LEU A  71      -6.089   8.743  -0.542  1.00  9.35           N  
ATOM    525  CA  LEU A  71      -5.321   7.506  -0.701  1.00 10.09           C  
ATOM    526  C   LEU A  71      -5.956   6.571  -1.721  1.00 11.65           C  
ATOM    527  O   LEU A  71      -5.239   5.980  -2.529  1.00 11.98           O  
ATOM    528  CB  LEU A  71      -5.096   6.795   0.641  1.00 10.57           C  
ATOM    529  CG  LEU A  71      -4.093   7.496   1.585  1.00  7.32           C  
ATOM    530  CD1 LEU A  71      -3.945   6.716   2.865  1.00 13.95           C  
ATOM    531  CD2 LEU A  71      -2.725   7.578   0.885  1.00 11.90           C  
ATOM    532  N   GLU A  72      -7.285   6.438  -1.710  1.00  9.41           N  
ATOM    533  CA  GLU A  72      -7.909   5.628  -2.732  1.00 12.52           C  
ATOM    534  C   GLU A  72      -7.827   6.248  -4.104  1.00 12.37           C  
ATOM    535  O   GLU A  72      -7.635   5.557  -5.095  1.00 13.25           O  
ATOM    536  CB  GLU A  72      -9.371   5.355  -2.426  1.00 13.07           C  
ATOM    537  CG  GLU A  72     -10.015   6.240  -1.464  1.00 22.18           C  
ATOM    538  CD  GLU A  72     -11.152   5.541  -0.737  1.00 23.39           C  
ATOM    539  OE1 GLU A  72     -11.097   4.306  -0.525  1.00 29.26           O  
ATOM    540  OE2 GLU A  72     -12.096   6.228  -0.363  1.00 24.95           O  
ATOM    541  N   LYS A  73      -8.020   7.558  -4.182  1.00 12.24           N  
ATOM    542  CA  LYS A  73      -7.925   8.207  -5.475  1.00 13.85           C  
ATOM    543  C   LYS A  73      -6.520   8.024  -6.054  1.00 12.16           C  
ATOM    544  O   LYS A  73      -6.397   7.846  -7.230  1.00 10.58           O  
ATOM    545  CB  LYS A  73      -8.193   9.686  -5.358  1.00 16.53           C  
ATOM    546  CG  LYS A  73      -7.796  10.396  -6.640  1.00 20.68           C  
ATOM    547  CD  LYS A  73      -7.970  11.893  -6.536  1.00 23.98           C  
ATOM    548  CE  LYS A  73      -7.515  12.568  -7.809  1.00 26.89           C  
ATOM    549  NZ  LYS A  73      -8.303  13.817  -8.118  1.00 28.99           N  
ATOM    550  N   ALA A  74      -5.499   8.063  -5.196  1.00 10.84           N  
ATOM    551  CA  ALA A  74      -4.089   7.886  -5.563  1.00  9.99           C  
ATOM    552  C   ALA A  74      -3.622   6.435  -5.702  1.00  9.33           C  
ATOM    553  O   ALA A  74      -2.455   6.209  -6.015  1.00 13.53           O  
ATOM    554  CB  ALA A  74      -3.231   8.558  -4.510  1.00 10.97           C  
ATOM    555  N   SER A  75      -4.500   5.468  -5.537  1.00  8.13           N  
ATOM    556  CA  SER A  75      -4.096   4.054  -5.549  1.00  8.54           C  
ATOM    557  C   SER A  75      -3.472   3.584  -6.861  1.00  8.61           C  
ATOM    558  O   SER A  75      -2.436   2.970  -6.807  1.00 10.74           O  
ATOM    559  CB  SER A  75      -5.261   3.183  -5.093  1.00 10.17           C  
ATOM    560  OG  SER A  75      -5.358   3.264  -3.672  1.00 11.89           O  
ATOM    561  N   PRO A  76      -4.053   3.909  -8.043  1.00 11.43           N  
ATOM    562  CA  PRO A  76      -3.434   3.462  -9.317  1.00  9.43           C  
ATOM    563  C   PRO A  76      -1.965   3.957  -9.371  1.00 10.61           C  
ATOM    564  O   PRO A  76      -1.069   3.166  -9.662  1.00 10.22           O  
ATOM    565  CB  PRO A  76      -4.323   4.112 -10.387  1.00 10.84           C  
ATOM    566  CG  PRO A  76      -5.704   4.242  -9.661  1.00 12.02           C  
ATOM    567  CD  PRO A  76      -5.298   4.688  -8.289  1.00 10.45           C  
ATOM    568  N   TYR A  77      -1.721   5.243  -9.083  1.00  9.72           N  
ATOM    569  CA  TYR A  77      -0.356   5.822  -9.095  1.00  9.89           C  
ATOM    570  C   TYR A  77       0.549   5.125  -8.079  1.00 11.36           C  
ATOM    571  O   TYR A  77       1.702   4.797  -8.360  1.00  8.95           O  
ATOM    572  CB  TYR A  77      -0.416   7.312  -8.811  1.00 11.94           C  
ATOM    573  CG  TYR A  77       0.930   7.996  -8.870  1.00 12.89           C  
ATOM    574  CD1 TYR A  77       1.694   7.976 -10.035  1.00 15.03           C  
ATOM    575  CD2 TYR A  77       1.459   8.615  -7.754  1.00 13.05           C  
ATOM    576  CE1 TYR A  77       2.968   8.550 -10.074  1.00 15.80           C  
ATOM    577  CE2 TYR A  77       2.742   9.213  -7.778  1.00 15.92           C  
ATOM    578  CZ  TYR A  77       3.481   9.168  -8.943  1.00 18.73           C  
ATOM    579  OH  TYR A  77       4.748   9.739  -9.000  1.00 21.09           O  
ATOM    580  N   ILE A  78       0.035   4.899  -6.897  1.00 10.90           N  
ATOM    581  CA  ILE A  78       0.830   4.200  -5.881  1.00 10.88           C  
ATOM    582  C   ILE A  78       1.202   2.765  -6.324  1.00 11.40           C  
ATOM    583  O   ILE A  78       2.310   2.292  -6.013  1.00  9.58           O  
ATOM    584  CB  ILE A  78       0.058   4.156  -4.550  1.00 10.66           C  
ATOM    585  CG1 ILE A  78      -0.051   5.568  -3.993  1.00 10.06           C  
ATOM    586  CG2 ILE A  78       0.762   3.201  -3.547  1.00 12.16           C  
ATOM    587  CD1 ILE A  78      -1.030   5.686  -2.813  1.00  7.44           C  
ATOM    588  N   ARG A  79       0.278   2.071  -7.016  1.00  9.72           N  
ATOM    589  CA  ARG A  79       0.541   0.695  -7.533  1.00  8.92           C  
ATOM    590  C   ARG A  79       1.625   0.772  -8.591  1.00  9.53           C  
ATOM    591  O   ARG A  79       2.526  -0.050  -8.628  1.00  8.96           O  
ATOM    592  CB  ARG A  79      -0.716   0.050  -8.153  1.00  9.76           C  
ATOM    593  CG  ARG A  79      -1.673  -0.460  -7.098  1.00  3.64           C  
ATOM    594  CD  ARG A  79      -2.884  -1.030  -7.732  1.00  9.03           C  
ATOM    595  NE  ARG A  79      -2.616  -2.373  -8.291  1.00 10.39           N  
ATOM    596  CZ  ARG A  79      -2.853  -2.731  -9.558  1.00 13.15           C  
ATOM    597  NH1 ARG A  79      -3.357  -1.863 -10.435  1.00 11.06           N  
ATOM    598  NH2 ARG A  79      -2.573  -3.969  -9.961  1.00 12.01           N  
ATOM    599  N   SER A  80       1.580   1.806  -9.411  1.00  7.12           N  
ATOM    600  CA  SER A  80       2.600   1.978 -10.432  1.00  6.93           C  
ATOM    601  C   SER A  80       3.998   2.180  -9.800  1.00  7.01           C  
ATOM    602  O   SER A  80       5.006   1.681 -10.325  1.00  8.63           O  
ATOM    603  CB  SER A  80       2.235   3.156 -11.351  1.00  7.84           C  
ATOM    604  OG  SER A  80       2.595   4.380 -10.740  1.00 14.28           O  
ATOM    605  N   LEU A  81       4.073   2.904  -8.680  1.00  7.68           N  
ATOM    606  CA  LEU A  81       5.353   3.137  -8.006  1.00  7.75           C  
ATOM    607  C   LEU A  81       5.820   1.826  -7.356  1.00  8.97           C  
ATOM    608  O   LEU A  81       7.016   1.501  -7.380  1.00  9.35           O  
ATOM    609  CB  LEU A  81       5.224   4.213  -6.946  1.00  8.97           C  
ATOM    610  CG  LEU A  81       4.945   5.625  -7.487  1.00  9.06           C  
ATOM    611  CD1 LEU A  81       4.869   6.583  -6.292  1.00 10.72           C  
ATOM    612  CD2 LEU A  81       6.017   6.060  -8.460  1.00 13.32           C  
ATOM    613  N   LEU A  82       4.896   1.092  -6.745  1.00  8.19           N  
ATOM    614  CA  LEU A  82       5.277  -0.194  -6.149  1.00  8.35           C  
ATOM    615  C   LEU A  82       5.854  -1.075  -7.238  1.00 12.25           C  
ATOM    616  O   LEU A  82       6.865  -1.729  -7.025  1.00 13.40           O  
ATOM    617  CB  LEU A  82       4.060  -0.928  -5.585  1.00  9.74           C  
ATOM    618  CG  LEU A  82       3.646  -0.485  -4.198  1.00  9.59           C  
ATOM    619  CD1 LEU A  82       2.300  -1.140  -3.910  1.00 11.51           C  
ATOM    620  CD2 LEU A  82       4.709  -0.862  -3.176  1.00 12.45           C  
ATOM    621  N   GLY A  83       5.151  -1.136  -8.369  1.00 11.92           N  
ATOM    622  CA  GLY A  83       5.582  -1.959  -9.484  1.00 14.35           C  
ATOM    623  C   GLY A  83       7.004  -1.617  -9.870  1.00 13.00           C  
ATOM    624  O   GLY A  83       7.817  -2.504 -10.060  1.00 13.53           O  
ATOM    625  N   LYS A  84       7.299  -0.331  -9.983  1.00 12.33           N  
ATOM    626  CA  LYS A  84       8.646   0.098 -10.342  1.00 14.25           C  
ATOM    627  C   LYS A  84       9.663  -0.274  -9.250  1.00 13.53           C  
ATOM    628  O   LYS A  84      10.770  -0.781  -9.544  1.00 15.63           O  
ATOM    629  CB  LYS A  84       8.609   1.599 -10.587  1.00 15.73           C  
ATOM    630  CG  LYS A  84       9.954   2.272 -10.766  1.00 18.26           C  
ATOM    631  CD  LYS A  84       9.758   3.765 -10.981  1.00 18.64           C  
ATOM    632  CE  LYS A  84      11.004   4.537 -10.624  1.00 23.01           C  
ATOM    633  NZ  LYS A  84      12.112   4.447 -11.603  1.00 24.20           N  
ATOM    634  N   ALA A  85       9.292  -0.058  -7.986  1.00 13.36           N  
ATOM    635  CA  ALA A  85      10.171  -0.355  -6.848  1.00 10.76           C  
ATOM    636  C   ALA A  85      10.431  -1.828  -6.621  1.00 11.55           C  
ATOM    637  O   ALA A  85      11.549  -2.230  -6.315  1.00 11.23           O  
ATOM    638  CB  ALA A  85       9.587   0.267  -5.568  1.00 11.16           C  
ATOM    639  N   MET A  86       9.395  -2.640  -6.794  1.00 10.76           N  
ATOM    640  CA  MET A  86       9.504  -4.070  -6.547  1.00 10.65           C  
ATOM    641  C   MET A  86       9.782  -4.911  -7.774  1.00 10.43           C  
ATOM    642  O   MET A  86      10.145  -6.081  -7.660  1.00 10.57           O  
ATOM    643  CB  MET A  86       8.206  -4.547  -5.900  1.00 11.82           C  
ATOM    644  CG  MET A  86       8.082  -4.055  -4.485  1.00 14.08           C  
ATOM    645  SD  MET A  86       6.467  -4.509  -3.826  1.00 17.78           S  
ATOM    646  CE  MET A  86       6.784  -6.192  -3.421  1.00 15.41           C  
ATOM    647  N   ARG A  87       9.575  -4.340  -8.953  1.00  9.49           N  
ATOM    648  CA  ARG A  87       9.776  -5.076 -10.199  1.00 11.36           C  
ATOM    649  C   ARG A  87       8.973  -6.401 -10.225  1.00 12.05           C  
ATOM    650  O   ARG A  87       9.490  -7.443 -10.606  1.00 12.94           O  
ATOM    651  CB  ARG A  87      11.275  -5.313 -10.421  1.00 10.32           C  
ATOM    652  CG  ARG A  87      12.045  -3.973 -10.602  1.00 10.03           C  
ATOM    653  CD  ARG A  87      13.461  -4.255 -11.043  1.00 11.82           C  
ATOM    654  NE  ARG A  87      14.264  -3.068 -10.867  1.00 13.72           N  
ATOM    655  CZ  ARG A  87      15.429  -2.831 -11.452  1.00 14.93           C  
ATOM    656  NH1 ARG A  87      15.982  -3.722 -12.260  1.00 11.45           N  
ATOM    657  NH2 ARG A  87      15.986  -1.620 -11.294  1.00 12.33           N  
ATOM    658  N   LEU A  88       7.717  -6.333  -9.789  1.00 11.52           N  
ATOM    659  CA  LEU A  88       6.800  -7.475  -9.815  1.00 11.38           C  
ATOM    660  C   LEU A  88       6.139  -7.498 -11.169  1.00 12.66           C  
ATOM    661  O   LEU A  88       5.921  -6.448 -11.796  1.00 13.70           O  
ATOM    662  CB  LEU A  88       5.677  -7.317  -8.784  1.00 12.09           C  
ATOM    663  CG  LEU A  88       6.013  -7.493  -7.315  1.00 12.29           C  
ATOM    664  CD1 LEU A  88       4.783  -7.121  -6.503  1.00 12.12           C  
ATOM    665  CD2 LEU A  88       6.426  -8.954  -7.031  1.00 13.91           C  
ATOM    666  N   ARG A  89       5.820  -8.696 -11.632  1.00 14.15           N  
ATOM    667  CA  ARG A  89       5.123  -8.845 -12.893  1.00 14.88           C  
ATOM    668  C   ARG A  89       3.669  -8.504 -12.627  1.00 15.63           C  
ATOM    669  O   ARG A  89       3.042  -7.819 -13.441  1.00 17.58           O  
ATOM    670  CB  ARG A  89       5.235 -10.264 -13.423  1.00 16.60           C  
ATOM    671  CG  ARG A  89       4.140 -10.621 -14.419  1.00 24.44           C  
ATOM    672  CD  ARG A  89       2.907 -11.187 -13.704  1.00 30.00           C  
ATOM    673  NE  ARG A  89       1.780 -11.381 -14.620  1.00 35.98           N  
ATOM    674  CZ  ARG A  89       1.101 -12.520 -14.740  1.00 37.12           C  
ATOM    675  NH1 ARG A  89       1.437 -13.578 -14.003  1.00 38.61           N  
ATOM    676  NH2 ARG A  89       0.077 -12.591 -15.582  1.00 38.57           N  
ATOM    677  N   ILE A  90       3.131  -8.978 -11.509  1.00 14.26           N  
ATOM    678  CA  ILE A  90       1.755  -8.658 -11.183  1.00 16.60           C  
ATOM    679  C   ILE A  90       1.712  -7.924  -9.846  1.00 14.46           C  
ATOM    680  O   ILE A  90       2.053  -8.475  -8.801  1.00 13.89           O  
ATOM    681  CB  ILE A  90       0.864  -9.915 -11.129  1.00 19.93           C  
ATOM    682  CG1 ILE A  90      -0.374  -9.646 -10.287  1.00 18.72           C  
ATOM    683  CG2 ILE A  90       1.608 -11.058 -10.582  1.00 22.47           C  
ATOM    684  CD1 ILE A  90      -1.544  -9.198 -11.083  1.00 22.54           C  
ATOM    685  N   VAL A  91       1.350  -6.643  -9.885  1.00 12.42           N  
ATOM    686  CA  VAL A  91       1.229  -5.842  -8.666  1.00 12.04           C  
ATOM    687  C   VAL A  91      -0.180  -6.044  -8.055  1.00 12.11           C  
ATOM    688  O   VAL A  91      -1.208  -5.841  -8.731  1.00 12.79           O  
ATOM    689  CB  VAL A  91       1.424  -4.339  -8.951  1.00 11.40           C  
ATOM    690  CG1 VAL A  91       1.405  -3.571  -7.632  1.00 11.38           C  
ATOM    691  CG2 VAL A  91       2.748  -4.109  -9.666  1.00 15.50           C  
ATOM    692  N   PRO A  92      -0.249  -6.466  -6.786  1.00 11.97           N  
ATOM    693  CA  PRO A  92      -1.560  -6.683  -6.161  1.00 11.64           C  
ATOM    694  C   PRO A  92      -2.423  -5.455  -6.203  1.00 12.40           C  
ATOM    695  O   PRO A  92      -1.912  -4.339  -6.240  1.00 10.63           O  
ATOM    696  CB  PRO A  92      -1.231  -6.963  -4.710  1.00 11.84           C  
ATOM    697  CG  PRO A  92       0.165  -7.427  -4.725  1.00 13.93           C  
ATOM    698  CD  PRO A  92       0.826  -6.575  -5.788  1.00 12.33           C  
ATOM    699  N   GLU A  93      -3.731  -5.683  -6.154  1.00 12.40           N  
ATOM    700  CA  GLU A  93      -4.665  -4.596  -6.003  1.00 13.54           C  
ATOM    701  C   GLU A  93      -4.397  -4.117  -4.558  1.00 11.95           C  
ATOM    702  O   GLU A  93      -3.894  -4.843  -3.708  1.00 13.43           O  
ATOM    703  CB  GLU A  93      -6.104  -5.111  -6.117  1.00 17.28           C  
ATOM    704  CG  GLU A  93      -6.496  -5.548  -7.508  1.00 22.48           C  
ATOM    705  CD  GLU A  93      -6.491  -4.392  -8.474  1.00 26.48           C  
ATOM    706  OE1 GLU A  93      -7.052  -3.315  -8.139  1.00 29.98           O  
ATOM    707  OE2 GLU A  93      -5.920  -4.542  -9.575  1.00 30.91           O  
ATOM    708  N   ILE A  94      -4.645  -2.850  -4.284  1.00 11.59           N  
ATOM    709  CA  ILE A  94      -4.458  -2.370  -2.938  1.00  8.84           C  
ATOM    710  C   ILE A  94      -5.658  -1.668  -2.312  1.00  9.55           C  
ATOM    711  O   ILE A  94      -6.366  -0.908  -2.994  1.00 10.57           O  
ATOM    712  CB  ILE A  94      -3.216  -1.400  -2.850  1.00 11.85           C  
ATOM    713  CG1 ILE A  94      -3.427  -0.174  -3.757  1.00  9.57           C  
ATOM    714  CG2 ILE A  94      -1.946  -2.141  -3.227  1.00  9.08           C  
ATOM    715  CD1 ILE A  94      -2.202   0.799  -3.697  1.00  9.46           C  
ATOM    716  N   ARG A  95      -5.866  -1.898  -1.009  1.00  8.85           N  
ATOM    717  CA  ARG A  95      -6.914  -1.206  -0.260  1.00  9.64           C  
ATOM    718  C   ARG A  95      -6.304  -0.590   0.985  1.00  9.81           C  
ATOM    719  O   ARG A  95      -5.383  -1.183   1.572  1.00 11.57           O  
ATOM    720  CB  ARG A  95      -8.057  -2.143   0.140  1.00 11.51           C  
ATOM    721  CG  ARG A  95      -7.701  -3.583   0.418  1.00 17.92           C  
ATOM    722  CD  ARG A  95      -8.992  -4.420   0.280  1.00 19.71           C  
ATOM    723  NE  ARG A  95      -9.955  -3.882   1.215  1.00 19.98           N  
ATOM    724  CZ  ARG A  95     -10.570  -4.612   2.122  1.00 21.35           C  
ATOM    725  NH1 ARG A  95     -10.336  -5.911   2.175  1.00 21.11           N  
ATOM    726  NH2 ARG A  95     -11.347  -4.033   3.019  1.00 21.93           N  
ATOM    727  N   PHE A  96      -6.764   0.603   1.396  1.00  6.61           N  
ATOM    728  CA  PHE A  96      -6.184   1.205   2.596  1.00  7.52           C  
ATOM    729  C   PHE A  96      -7.172   1.108   3.710  1.00  7.64           C  
ATOM    730  O   PHE A  96      -8.367   1.387   3.491  1.00  7.75           O  
ATOM    731  CB  PHE A  96      -5.829   2.701   2.403  1.00  6.03           C  
ATOM    732  CG  PHE A  96      -4.645   2.921   1.494  1.00  5.34           C  
ATOM    733  CD1 PHE A  96      -4.808   3.000   0.119  1.00  6.72           C  
ATOM    734  CD2 PHE A  96      -3.370   2.993   2.034  1.00  7.35           C  
ATOM    735  CE1 PHE A  96      -3.684   3.147  -0.749  1.00 10.22           C  
ATOM    736  CE2 PHE A  96      -2.255   3.137   1.209  1.00 10.25           C  
ATOM    737  CZ  PHE A  96      -2.414   3.211  -0.205  1.00  8.33           C  
ATOM    738  N   ILE A  97      -6.677   0.739   4.902  1.00  7.92           N  
ATOM    739  CA  ILE A  97      -7.534   0.624   6.073  1.00  8.54           C  
ATOM    740  C   ILE A  97      -6.947   1.388   7.255  1.00  6.38           C  
ATOM    741  O   ILE A  97      -5.792   1.190   7.641  1.00  6.25           O  
ATOM    742  CB  ILE A  97      -7.736  -0.872   6.456  1.00  7.33           C  
ATOM    743  CG1 ILE A  97      -8.413  -1.610   5.275  1.00 14.73           C  
ATOM    744  CG2 ILE A  97      -8.589  -0.972   7.708  1.00 11.79           C  
ATOM    745  CD1 ILE A  97      -8.377  -3.064   5.374  1.00 16.94           C  
ATOM    746  N   TYR A  98      -7.699   2.273   7.851  1.00  7.02           N  
ATOM    747  CA  TYR A  98      -7.133   2.991   8.980  1.00  9.64           C  
ATOM    748  C   TYR A  98      -7.081   2.087  10.215  1.00  9.87           C  
ATOM    749  O   TYR A  98      -8.125   1.596  10.673  1.00 10.75           O  
ATOM    750  CB  TYR A  98      -7.948   4.257   9.290  1.00 12.15           C  
ATOM    751  CG  TYR A  98      -7.109   5.198  10.110  1.00  9.79           C  
ATOM    752  CD1 TYR A  98      -6.912   4.964  11.492  1.00 11.75           C  
ATOM    753  CD2 TYR A  98      -6.500   6.326   9.547  1.00  7.39           C  
ATOM    754  CE1 TYR A  98      -6.105   5.801  12.270  1.00 11.58           C  
ATOM    755  CE2 TYR A  98      -5.697   7.164  10.319  1.00 11.65           C  
ATOM    756  CZ  TYR A  98      -5.501   6.901  11.652  1.00 11.00           C  
ATOM    757  OH  TYR A  98      -4.680   7.733  12.387  1.00 10.54           O  
ATOM    758  N   ASP A  99      -5.869   1.876  10.739  1.00  5.78           N  
ATOM    759  CA  ASP A  99      -5.607   1.015  11.872  1.00  6.79           C  
ATOM    760  C   ASP A  99      -5.945   1.699  13.224  1.00  6.23           C  
ATOM    761  O   ASP A  99      -5.192   2.561  13.688  1.00  9.73           O  
ATOM    762  CB  ASP A  99      -4.126   0.603  11.802  1.00  8.79           C  
ATOM    763  CG  ASP A  99      -3.782  -0.453  12.774  1.00 10.04           C  
ATOM    764  OD1 ASP A  99      -4.572  -0.642  13.710  1.00  6.89           O  
ATOM    765  OD2 ASP A  99      -2.729  -1.098  12.620  1.00 12.45           O  
ATOM    766  N   GLN A 100      -7.062   1.339  13.858  1.00  5.53           N  
ATOM    767  CA  GLN A 100      -7.380   1.969  15.144  1.00  6.87           C  
ATOM    768  C   GLN A 100      -6.871   1.211  16.423  1.00  7.89           C  
ATOM    769  O   GLN A 100      -7.358   1.441  17.566  1.00  7.51           O  
ATOM    770  CB  GLN A 100      -8.903   2.229  15.228  1.00  7.97           C  
ATOM    771  CG  GLN A 100      -9.460   3.133  14.109  1.00  6.55           C  
ATOM    772  CD  GLN A 100     -10.967   3.389  14.291  1.00 11.77           C  
ATOM    773  OE1 GLN A 100     -11.661   2.555  14.794  1.00 11.88           O  
ATOM    774  NE2 GLN A 100     -11.454   4.566  13.879  1.00 12.75           N  
ATOM    775  N   SER A 101      -5.832   0.392  16.211  1.00  8.32           N  
ATOM    776  CA  SER A 101      -5.165  -0.392  17.263  1.00  9.17           C  
ATOM    777  C   SER A 101      -4.608   0.571  18.325  1.00 10.02           C  
ATOM    778  O   SER A 101      -4.274   1.696  18.030  1.00  7.24           O  
ATOM    779  CB  SER A 101      -3.974  -1.183  16.698  1.00  9.28           C  
ATOM    780  OG  SER A 101      -4.349  -2.157  15.742  1.00 11.04           O  
ATOM    781  N   LEU A 102      -4.507   0.088  19.555  1.00  9.96           N  
ATOM    782  CA  LEU A 102      -4.060   0.864  20.677  1.00 14.13           C  
ATOM    783  C   LEU A 102      -2.603   1.211  20.523  1.00 14.28           C  
ATOM    784  O   LEU A 102      -1.802   0.352  20.197  1.00 16.22           O  
ATOM    785  CB  LEU A 102      -4.314   0.075  21.964  1.00 14.76           C  
ATOM    786  CG  LEU A 102      -4.950   0.669  23.221  1.00 18.80           C  
ATOM    787  CD1 LEU A 102      -4.391  -0.124  24.381  1.00 16.31           C  
ATOM    788  CD2 LEU A 102      -4.694   2.181  23.412  1.00 17.84           C  
ATOM    789  N   VAL A 103      -2.293   2.493  20.746  1.00 17.70           N  
ATOM    790  CA  VAL A 103      -0.950   3.031  20.634  1.00 20.13           C  
ATOM    791  C   VAL A 103      -0.605   3.827  21.882  1.00 22.42           C  
ATOM    792  O   VAL A 103      -1.404   4.635  22.353  1.00 23.82           O  
ATOM    793  CB  VAL A 103      -0.824   4.006  19.426  1.00 19.03           C  
ATOM    794  CG1 VAL A 103       0.481   4.757  19.499  1.00 16.28           C  
ATOM    795  CG2 VAL A 103      -0.873   3.213  18.111  1.00 16.87           C  
ATOM    796  N   GLU A 104       0.582   3.599  22.422  1.00 26.35           N  
ATOM    797  CA  GLU A 104       1.008   4.370  23.577  1.00 30.05           C  
ATOM    798  C   GLU A 104       1.946   5.469  23.078  1.00 31.41           C  
ATOM    799  O   GLU A 104       1.579   6.647  23.054  1.00 31.31           O  
ATOM    800  CB  GLU A 104       1.722   3.493  24.610  1.00 33.24           C  
ATOM    801  CG  GLU A 104       0.819   2.536  25.393  1.00 38.47           C  
ATOM    802  CD  GLU A 104      -0.195   3.232  26.316  1.00 40.68           C  
ATOM    803  OE1 GLU A 104       0.192   3.582  27.461  1.00 40.89           O  
ATOM    804  OE2 GLU A 104      -1.372   3.428  25.898  1.00 42.98           O  
ATOM    805  N   GLY A 105       3.131   5.078  22.619  1.00 33.22           N  
ATOM    806  CA  GLY A 105       4.093   6.063  22.164  1.00 35.86           C  
ATOM    807  C   GLY A 105       4.812   6.493  23.428  1.00 38.43           C  
ATOM    808  O   GLY A 105       5.936   6.050  23.739  1.00 38.80           O  
ATOM    809  N   MET A 106       4.165   7.372  24.176  1.00 38.86           N  
ATOM    810  CA  MET A 106       4.757   7.785  25.432  1.00 39.09           C  
ATOM    811  C   MET A 106       3.620   7.897  26.444  1.00 39.32           C  
ATOM    812  O   MET A 106       2.464   8.066  25.983  1.00 38.85           O  
ATOM    813  CB  MET A 106       5.471   9.107  25.248  1.00 37.62           C  
ATOM    814  CG  MET A 106       4.583  10.300  25.431  1.00 35.73           C  
ATOM    815  SD  MET A 106       5.486  11.790  25.039  1.00 33.82           S  
ATOM    816  CE  MET A 106       7.023  11.494  25.959  1.00 34.26           C  
TER     817      MET A 106                                                      
END
MOLECULE T0464.pdb
ATOM    289  N   LEU    18      -7.017 -12.593  -0.236  1.00 13.35           N 
ATOM    290  CA  LEU    18      -6.481 -11.452   0.518  1.00 23.42           C 
ATOM    291  C   LEU    18      -5.708 -11.929   1.763  1.00 62.24           C 
ATOM    292  O   LEU    18      -6.197 -12.763   2.529  1.00 14.32           O 
ATOM    293  CB  LEU    18      -7.649 -10.515   0.900  1.00 62.52           C 
ATOM    294  CG  LEU    18      -7.287  -9.117   1.464  1.00 41.20           C 
ATOM    295  CD1 LEU    18      -6.932  -9.176   2.950  1.00 70.34           C 
ATOM    296  CD2 LEU    18      -6.151  -8.484   0.661  1.00 64.45           C 
ATOM    297  H   LEU    18      -7.830 -13.038   0.092  1.00 37.77           H 
ATOM    298  HA  LEU    18      -5.800 -10.915  -0.131  1.00 64.31           H 
ATOM    299 3HB  LEU    18      -8.259 -11.025   1.634  1.00 37.77           H 
ATOM    300 2HB  LEU    18      -8.254 -10.364   0.016  1.00 37.77           H 
ATOM    301  HG  LEU    18      -8.151  -8.475   1.369  1.00 30.20           H 
ATOM    302 1HD1 LEU    18      -6.772  -8.173   3.322  1.00 37.77           H 
ATOM    303 2HD1 LEU    18      -6.033  -9.760   3.088  1.00 37.77           H 
ATOM    304 3HD1 LEU    18      -7.745  -9.636   3.498  1.00 37.77           H 
ATOM    305 1HD2 LEU    18      -6.441  -8.406  -0.376  1.00 37.77           H 
ATOM    306 2HD2 LEU    18      -5.262  -9.095   0.741  1.00 37.77           H 
ATOM    307 3HD2 LEU    18      -5.943  -7.497   1.048  1.00 37.77           H 
ATOM    308  N   SER    19      -4.497 -11.402   1.951  1.00 34.02           N 
ATOM    309  CA  SER    19      -3.650 -11.792   3.091  1.00 44.31           C 
ATOM    310  C   SER    19      -2.920 -10.590   3.700  1.00 41.31           C 
ATOM    311  O   SER    19      -3.014  -9.473   3.197  1.00 63.13           O 
ATOM    312  CB  SER    19      -2.614 -12.841   2.656  1.00 31.41           C 
ATOM    313  OG  SER    19      -3.236 -14.032   2.200  1.00  3.31           O 
ATOM    314  H   SER    19      -4.159 -10.743   1.307  1.00 37.77           H 
ATOM    315  HA  SER    19      -4.287 -12.227   3.848  1.00  2.32           H 
ATOM    316 3HB  SER    19      -1.976 -13.085   3.496  1.00 37.77           H 
ATOM    317 2HB  SER    19      -2.010 -12.439   1.856  1.00 37.77           H 
ATOM    318  HG  SER    19      -3.978 -14.247   2.776  1.00 63.25           H 
ATOM    319  N   LEU    20      -2.196 -10.829   4.792  1.00 41.43           N 
ATOM    320  CA  LEU    20      -1.401  -9.783   5.442  1.00 44.25           C 
ATOM    321  C   LEU    20      -0.137  -9.491   4.611  1.00 21.35           C 
ATOM    322  O   LEU    20       0.539 -10.412   4.145  1.00 54.01           O 
ATOM    323  CB  LEU    20      -1.022 -10.224   6.872  1.00 34.34           C 
ATOM    324  CG  LEU    20      -0.823  -9.097   7.907  1.00 45.24           C 
ATOM    325  CD1 LEU    20       0.321  -8.160   7.520  1.00 33.22           C 
ATOM    326  CD2 LEU    20      -2.120  -8.315   8.103  1.00 51.23           C 
ATOM    327  H   LEU    20      -2.201 -11.733   5.179  1.00 37.77           H 
ATOM    328  HA  LEU    20      -2.005  -8.888   5.494  1.00 43.02           H 
ATOM    329 3HB  LEU    20      -0.106 -10.796   6.816  1.00 37.77           H 
ATOM    330 2HB  LEU    20      -1.804 -10.877   7.239  1.00 37.77           H 
ATOM    331  HG  LEU    20      -0.565  -9.543   8.859  1.00 25.34           H 
ATOM    332 1HD1 LEU    20       1.237  -8.727   7.430  1.00 37.77           H 
ATOM    333 2HD1 LEU    20       0.443  -7.405   8.283  1.00 37.77           H 
ATOM    334 3HD1 LEU    20       0.096  -7.683   6.576  1.00 37.77           H 
ATOM    335 1HD2 LEU    20      -2.408  -7.851   7.170  1.00 37.77           H 
ATOM    336 2HD2 LEU    20      -1.974  -7.551   8.851  1.00 37.77           H 
ATOM    337 3HD2 LEU    20      -2.901  -8.988   8.424  1.00 37.77           H 
ATOM    338  N   LEU    21       0.177  -8.210   4.424  1.00 33.43           N 
ATOM    339  CA  LEU    21       1.339  -7.804   3.621  1.00  2.15           C 
ATOM    340  C   LEU    21       2.670  -8.232   4.267  1.00 50.31           C 
ATOM    341  O   LEU    21       2.969  -7.876   5.409  1.00  3.31           O 
ATOM    342  CB  LEU    21       1.315  -6.284   3.392  1.00  2.24           C 
ATOM    343  CG  LEU    21       2.482  -5.710   2.563  1.00 74.00           C 
ATOM    344  CD1 LEU    21       2.597  -6.409   1.209  1.00 75.40           C 
ATOM    345  CD2 LEU    21       2.312  -4.203   2.375  1.00 24.42           C 
ATOM    346  H   LEU    21      -0.381  -7.518   4.838  1.00 37.77           H 
ATOM    347  HA  LEU    21       1.253  -8.298   2.662  1.00 31.23           H 
ATOM    348 3HB  LEU    21       1.318  -5.799   4.358  1.00 37.77           H 
ATOM    349 2HB  LEU    21       0.390  -6.035   2.889  1.00 37.77           H 
ATOM    350  HG  LEU    21       3.407  -5.875   3.099  1.00 73.23           H 
ATOM    351 1HD1 LEU    21       3.442  -6.009   0.667  1.00 37.77           H 
ATOM    352 2HD1 LEU    21       1.695  -6.246   0.638  1.00 37.77           H 
ATOM    353 3HD1 LEU    21       2.737  -7.470   1.362  1.00 37.77           H 
ATOM    354 1HD2 LEU    21       3.130  -3.819   1.781  1.00 37.77           H 
ATOM    355 2HD2 LEU    21       2.311  -3.717   3.338  1.00 37.77           H 
ATOM    356 3HD2 LEU    21       1.377  -4.003   1.870  1.00 37.77           H 
ATOM    357  N   GLU    22       3.453  -9.009   3.520  1.00 23.44           N 
ATOM    358  CA  GLU    22       4.776  -9.459   3.972  1.00 42.51           C 
ATOM    359  C   GLU    22       5.773  -8.288   4.081  1.00 75.03           C 
ATOM    360  O   GLU    22       5.609  -7.256   3.423  1.00 24.24           O 
ATOM    361  CB  GLU    22       5.319 -10.531   3.012  1.00 22.41           C 
ATOM    362  CG  GLU    22       5.319 -10.106   1.544  1.00 34.41           C 
ATOM    363  CD  GLU    22       5.932 -11.151   0.623  1.00 45.23           C 
ATOM    364  OE1 GLU    22       6.842 -10.807  -0.160  1.00 42.22           O 
ATOM    365  OE2 GLU    22       5.513 -12.326   0.679  1.00 33.24           O 
ATOM    366  H   GLU    22       3.130  -9.299   2.644  1.00 37.77           H 
ATOM    367  HA  GLU    22       4.653  -9.901   4.952  1.00 32.12           H 
ATOM    368 3HB  GLU    22       4.715 -11.422   3.108  1.00 37.77           H 
ATOM    369 2HB  GLU    22       6.337 -10.768   3.297  1.00 37.77           H 
ATOM    370 3HG  GLU    22       5.879  -9.186   1.450  1.00 37.77           H 
ATOM    371 2HG  GLU    22       4.297  -9.933   1.234  1.00 37.77           H 
ATOM    372  N   SER    23       6.816  -8.470   4.893  1.00  1.21           N 
ATOM    373  CA  SER    23       7.819  -7.413   5.143  1.00 41.34           C 
ATOM    374  C   SER    23       8.411  -6.862   3.838  1.00 42.04           C 
ATOM    375  O   SER    23       8.589  -5.652   3.690  1.00  1.45           O 
ATOM    376  CB  SER    23       8.956  -7.941   6.030  1.00 11.21           C 
ATOM    377  OG  SER    23       9.718  -8.931   5.353  1.00 25.34           O 
ATOM    378  H   SER    23       6.916  -9.336   5.345  1.00 37.77           H 
ATOM    379  HA  SER    23       7.319  -6.607   5.663  1.00 22.33           H 
ATOM    380 3HB  SER    23       8.538  -8.375   6.926  1.00 37.77           H 
ATOM    381 2HB  SER    23       9.610  -7.125   6.298  1.00 37.77           H 
ATOM    382  HG  SER    23      10.641  -8.639   5.304  1.00 52.15           H 
ATOM    383  N   LYS    24       8.686  -7.760   2.889  1.00 62.33           N 
ATOM    384  CA  LYS    24       9.241  -7.387   1.576  1.00 41.22           C 
ATOM    385  C   LYS    24       8.396  -6.294   0.895  1.00 30.13           C 
ATOM    386  O   LYS    24       8.932  -5.311   0.377  1.00  1.41           O 
ATOM    387  CB  LYS    24       9.318  -8.637   0.681  1.00  2.54           C 
ATOM    388  CG  LYS    24       9.650  -8.355  -0.787  1.00 53.52           C 
ATOM    389  CD  LYS    24      11.029  -7.726  -0.967  1.00 44.52           C 
ATOM    390  CE  LYS    24      12.153  -8.653  -0.519  1.00 54.15           C 
ATOM    391  NZ  LYS    24      13.489  -8.078  -0.820  1.00 43.01           N 
ATOM    392  H   LYS    24       8.524  -8.707   3.081  1.00 37.77           H 
ATOM    393  HA  LYS    24      10.239  -7.006   1.736  1.00 24.35           H 
ATOM    394 3HB  LYS    24       8.366  -9.150   0.717  1.00 37.77           H 
ATOM    395 2HB  LYS    24      10.077  -9.297   1.074  1.00 37.77           H 
ATOM    396 3HG  LYS    24       8.902  -7.682  -1.186  1.00 37.77           H 
ATOM    397 2HG  LYS    24       9.619  -9.285  -1.334  1.00 37.77           H 
ATOM    398 3HD  LYS    24      11.076  -6.816  -0.384  1.00 37.77           H 
ATOM    399 2HD  LYS    24      11.172  -7.489  -2.010  1.00 37.77           H 
ATOM    400 3HE  LYS    24      12.053  -9.598  -1.033  1.00 37.77           H 
ATOM    401 2HE  LYS    24      12.072  -8.815   0.546  1.00 37.77           H 
ATOM    402 1HZ  LYS    24      13.588  -7.918  -1.843  1.00 37.77           H 
ATOM    403 2HZ  LYS    24      14.236  -8.724  -0.507  1.00 37.77           H 
ATOM    404 3HZ  LYS    24      13.607  -7.169  -0.327  1.00 37.77           H 
ATOM    405  N   GLY    25       7.080  -6.478   0.898  1.00 21.50           N 
ATOM    406  CA  GLY    25       6.184  -5.464   0.354  1.00 53.33           C 
ATOM    407  C   GLY    25       6.023  -4.263   1.284  1.00 14.32           C 
ATOM    408  O   GLY    25       6.089  -3.114   0.846  1.00 34.34           O 
ATOM    409  H   GLY    25       6.711  -7.304   1.274  1.00 37.77           H 
ATOM    410 3HA  GLY    25       5.213  -5.908   0.196  1.00 37.77           H 
ATOM    411 2HA  GLY    25       6.573  -5.123  -0.596  1.00 37.77           H 
ATOM    412  N   LEU    26       5.836  -4.538   2.573  1.00  3.24           N 
ATOM    413  CA  LEU    26       5.585  -3.494   3.577  1.00  1.01           C 
ATOM    414  C   LEU    26       6.667  -2.402   3.547  1.00 22.24           C 
ATOM    415  O   LEU    26       6.354  -1.205   3.538  1.00 53.41           O 
ATOM    416  CB  LEU    26       5.506  -4.118   4.977  1.00 50.14           C 
ATOM    417  CG  LEU    26       5.115  -3.151   6.112  1.00 62.53           C 
ATOM    418  CD1 LEU    26       3.724  -2.563   5.878  1.00 44.03           C 
ATOM    419  CD2 LEU    26       5.180  -3.857   7.466  1.00  1.11           C 
ATOM    420  H   LEU    26       5.869  -5.475   2.862  1.00 37.77           H 
ATOM    421  HA  LEU    26       4.634  -3.041   3.343  1.00 45.24           H 
ATOM    422 3HB  LEU    26       6.474  -4.541   5.212  1.00 37.77           H 
ATOM    423 2HB  LEU    26       4.782  -4.920   4.946  1.00 37.77           H 
ATOM    424  HG  LEU    26       5.820  -2.330   6.131  1.00 64.41           H 
ATOM    425 1HD1 LEU    26       3.002  -3.363   5.786  1.00 37.77           H 
ATOM    426 2HD1 LEU    26       3.724  -1.978   4.972  1.00 37.77           H 
ATOM    427 3HD1 LEU    26       3.454  -1.932   6.713  1.00 37.77           H 
ATOM    428 1HD2 LEU    26       4.472  -4.672   7.482  1.00 37.77           H 
ATOM    429 2HD2 LEU    26       4.940  -3.154   8.249  1.00 37.77           H 
ATOM    430 3HD2 LEU    26       6.176  -4.243   7.624  1.00 37.77           H 
ATOM    431  N   GLU    27       7.935  -2.810   3.517  1.00 40.23           N 
ATOM    432  CA  GLU    27       9.045  -1.856   3.430  1.00 72.40           C 
ATOM    433  C   GLU    27       8.974  -1.038   2.128  1.00 11.24           C 
ATOM    434  O   GLU    27       9.292   0.147   2.115  1.00 50.43           O 
ATOM    435  CB  GLU    27      10.399  -2.576   3.531  1.00  1.33           C 
ATOM    436  CG  GLU    27      10.608  -3.654   2.472  1.00 13.53           C 
ATOM    437  CD  GLU    27      11.993  -4.278   2.526  1.00 53.45           C 
ATOM    438  OE1 GLU    27      12.790  -4.047   1.591  1.00 62.44           O 
ATOM    439  OE2 GLU    27      12.298  -4.996   3.504  1.00 12.24           O 
ATOM    440  H   GLU    27       8.132  -3.772   3.551  1.00 37.77           H 
ATOM    441  HA  GLU    27       8.953  -1.173   4.265  1.00 43.30           H 
ATOM    442 3HB  GLU    27      10.473  -3.041   4.504  1.00 37.77           H 
ATOM    443 2HB  GLU    27      11.191  -1.848   3.431  1.00 37.77           H 
ATOM    444 3HG  GLU    27      10.464  -3.211   1.496  1.00 37.77           H 
ATOM    445 2HG  GLU    27       9.872  -4.433   2.619  1.00 37.77           H 
ATOM    446  N   ALA    28       8.520  -1.675   1.044  1.00 12.15           N 
ATOM    447  CA  ALA    28       8.411  -1.006  -0.259  1.00 20.21           C 
ATOM    448  C   ALA    28       7.339   0.092  -0.235  1.00 51.42           C 
ATOM    449  O   ALA    28       7.537   1.183  -0.777  1.00 61.01           O 
ATOM    450  CB  ALA    28       8.112  -2.021  -1.355  1.00 41.51           C 
ATOM    451  H   ALA    28       8.241  -2.613   1.124  1.00 37.77           H 
ATOM    452  HA  ALA    28       9.368  -0.551  -0.477  1.00 21.11           H 
ATOM    453 1HB  ALA    28       8.873  -2.788  -1.355  1.00 37.77           H 
ATOM    454 2HB  ALA    28       8.102  -1.525  -2.315  1.00 37.77           H 
ATOM    455 3HB  ALA    28       7.147  -2.475  -1.176  1.00 37.77           H 
ATOM    456  N   LEU    29       6.203  -0.204   0.401  1.00 50.24           N 
ATOM    457  CA  LEU    29       5.144   0.792   0.592  1.00 12.45           C 
ATOM    458  C   LEU    29       5.663   1.999   1.392  1.00 12.24           C 
ATOM    459  O   LEU    29       5.548   3.138   0.951  1.00 73.53           O 
ATOM    460  CB  LEU    29       3.928   0.168   1.304  1.00  4.23           C 
ATOM    461  CG  LEU    29       2.934  -0.593   0.402  1.00 14.24           C 
ATOM    462  CD1 LEU    29       2.252   0.356  -0.580  1.00  2.02           C 
ATOM    463  CD2 LEU    29       3.621  -1.735  -0.343  1.00 61.11           C 
ATOM    464  H   LEU    29       6.073  -1.115   0.744  1.00 37.77           H 
ATOM    465  HA  LEU    29       4.840   1.134  -0.388  1.00 75.11           H 
ATOM    466 3HB  LEU    29       3.385   0.960   1.802  1.00 37.77           H 
ATOM    467 2HB  LEU    29       4.291  -0.516   2.056  1.00 37.77           H 
ATOM    468  HG  LEU    29       2.162  -1.026   1.027  1.00 33.41           H 
ATOM    469 1HD1 LEU    29       1.551  -0.196  -1.191  1.00 37.77           H 
ATOM    470 2HD1 LEU    29       2.996   0.815  -1.214  1.00 37.77           H 
ATOM    471 3HD1 LEU    29       1.724   1.124  -0.031  1.00 37.77           H 
ATOM    472 1HD2 LEU    29       4.033  -2.435   0.368  1.00 37.77           H 
ATOM    473 2HD2 LEU    29       4.417  -1.339  -0.959  1.00 37.77           H 
ATOM    474 3HD2 LEU    29       2.902  -2.243  -0.969  1.00 37.77           H 
ATOM    475  N   ASN    30       6.258   1.733   2.559  1.00 22.22           N 
ATOM    476  CA  ASN    30       6.824   2.795   3.405  1.00 32.52           C 
ATOM    477  C   ASN    30       7.909   3.606   2.666  1.00 62.34           C 
ATOM    478  O   ASN    30       8.005   4.823   2.835  1.00 41.01           O 
ATOM    479  CB  ASN    30       7.387   2.202   4.705  1.00 35.41           C 
ATOM    480  CG  ASN    30       6.291   1.839   5.693  1.00  3.03           C 
ATOM    481  OD1 ASN    30       5.924   2.633   6.550  1.00 71.15           O 
ATOM    482  ND2 ASN    30       5.748   0.643   5.582  1.00 33.21           N 
ATOM    483  H   ASN    30       6.312   0.802   2.861  1.00 37.77           H 
ATOM    484  HA  ASN    30       6.016   3.470   3.656  1.00 31.31           H 
ATOM    485 3HB  ASN    30       8.040   2.927   5.172  1.00 37.77           H 
ATOM    486 2HB  ASN    30       7.951   1.311   4.475  1.00 37.77           H 
ATOM    487 1HD2 ASN    30       6.072   0.051   4.877  1.00 37.77           H 
ATOM    488 2HD2 ASN    30       5.037   0.403   6.215  1.00 37.77           H 
ATOM    489  N   LYS    31       8.722   2.932   1.852  1.00 11.24           N 
ATOM    490  CA  LYS    31       9.680   3.617   0.970  1.00  4.24           C 
ATOM    491  C   LYS    31       8.956   4.594   0.033  1.00  1.52           C 
ATOM    492  O   LYS    31       9.306   5.773  -0.065  1.00 14.24           O 
ATOM    493  CB  LYS    31      10.467   2.593   0.134  1.00 74.32           C 
ATOM    494  CG  LYS    31      11.504   1.793   0.917  1.00 32.24           C 
ATOM    495  CD  LYS    31      12.075   0.646   0.082  1.00 52.20           C 
ATOM    496  CE  LYS    31      13.200  -0.086   0.806  1.00 73.43           C 
ATOM    497  NZ  LYS    31      14.415   0.761   0.937  1.00 73.10           N 
ATOM    498  H   LYS    31       8.682   1.953   1.844  1.00 37.77           H 
ATOM    499  HA  LYS    31      10.370   4.173   1.589  1.00 64.32           H 
ATOM    500 3HB  LYS    31      10.977   3.115  -0.666  1.00 37.77           H 
ATOM    501 2HB  LYS    31       9.765   1.895  -0.300  1.00 37.77           H 
ATOM    502 3HG  LYS    31      11.037   1.386   1.804  1.00 37.77           H 
ATOM    503 2HG  LYS    31      12.312   2.452   1.204  1.00 37.77           H 
ATOM    504 3HD  LYS    31      12.457   1.047  -0.846  1.00 37.77           H 
ATOM    505 2HD  LYS    31      11.283  -0.059  -0.131  1.00 37.77           H 
ATOM    506 3HE  LYS    31      13.450  -0.975   0.248  1.00 37.77           H 
ATOM    507 2HE  LYS    31      12.859  -0.365   1.792  1.00 37.77           H 
ATOM    508 1HZ  LYS    31      14.182   1.655   1.410  1.00 37.77           H 
ATOM    509 2HZ  LYS    31      14.809   0.974  -0.003  1.00 37.77           H 
ATOM    510 3HZ  LYS    31      15.138   0.265   1.495  1.00 37.77           H 
ATOM    511  N   ALA    32       7.925   4.088  -0.640  1.00 20.01           N 
ATOM    512  CA  ALA    32       7.148   4.879  -1.595  1.00 32.51           C 
ATOM    513  C   ALA    32       6.358   6.009  -0.909  1.00 11.23           C 
ATOM    514  O   ALA    32       6.135   7.067  -1.505  1.00  2.53           O 
ATOM    515  CB  ALA    32       6.212   3.961  -2.369  1.00 31.32           C 
ATOM    516  H   ALA    32       7.676   3.150  -0.488  1.00 37.77           H 
ATOM    517  HA  ALA    32       7.842   5.318  -2.302  1.00 62.34           H 
ATOM    518 1HB  ALA    32       5.506   3.507  -1.689  1.00 37.77           H 
ATOM    519 2HB  ALA    32       6.786   3.188  -2.857  1.00 37.77           H 
ATOM    520 3HB  ALA    32       5.675   4.531  -3.114  1.00 37.77           H 
ATOM    521  N   ILE    33       5.929   5.777   0.331  1.00 22.44           N 
ATOM    522  CA  ILE    33       5.201   6.788   1.108  1.00 62.10           C 
ATOM    523  C   ILE    33       6.112   7.976   1.463  1.00 73.41           C 
ATOM    524  O   ILE    33       5.753   9.131   1.238  1.00 54.24           O 
ATOM    525  CB  ILE    33       4.599   6.180   2.406  1.00 64.04           C 
ATOM    526  CG1 ILE    33       3.531   5.128   2.060  1.00  3.33           C 
ATOM    527  CG2 ILE    33       4.002   7.273   3.294  1.00 30.34           C 
ATOM    528  CD1 ILE    33       2.952   4.412   3.263  1.00 55.55           C 
ATOM    529  H   ILE    33       6.102   4.901   0.735  1.00 37.77           H 
ATOM    530  HA  ILE    33       4.384   7.148   0.494  1.00 10.10           H 
ATOM    531  HB  ILE    33       5.399   5.701   2.955  1.00 22.00           H 
ATOM    532 3HG1 ILE    33       3.966   4.382   1.408  1.00 37.77           H 
ATOM    533 2HG1 ILE    33       2.715   5.610   1.544  1.00 37.77           H 
ATOM    534 1HG2 ILE    33       3.215   7.788   2.759  1.00 37.77           H 
ATOM    535 2HG2 ILE    33       4.773   7.984   3.563  1.00 37.77           H 
ATOM    536 3HG2 ILE    33       3.597   6.830   4.192  1.00 37.77           H 
ATOM    537 1HD1 ILE    33       3.743   3.903   3.795  1.00 37.77           H 
ATOM    538 2HD1 ILE    33       2.217   3.692   2.934  1.00 37.77           H 
ATOM    539 3HD1 ILE    33       2.481   5.131   3.919  1.00 37.77           H 
ATOM    540  N   VAL    34       7.302   7.684   1.995  1.00 52.01           N 
ATOM    541  CA  VAL    34       8.286   8.730   2.296  1.00 31.35           C 
ATOM    542  C   VAL    34       8.704   9.461   1.010  1.00 64.01           C 
ATOM    543  O   VAL    34       9.001  10.656   1.014  1.00 15.40           O 
ATOM    544  CB  VAL    34       9.540   8.138   2.992  1.00  1.50           C 
ATOM    545  CG1 VAL    34      10.582   9.224   3.266  1.00  0.14           C 
ATOM    546  CG2 VAL    34       9.149   7.427   4.288  1.00 14.41           C 
ATOM    547  H   VAL    34       7.524   6.747   2.181  1.00 37.77           H 
ATOM    548  HA  VAL    34       7.822   9.441   2.969  1.00 22.01           H 
ATOM    549  HB  VAL    34       9.984   7.409   2.329  1.00 15.22           H 
ATOM    550 1HG1 VAL    34      11.434   8.790   3.770  1.00 37.77           H 
ATOM    551 2HG1 VAL    34      10.150   9.994   3.889  1.00 37.77           H 
ATOM    552 3HG1 VAL    34      10.904   9.661   2.330  1.00 37.77           H 
ATOM    553 1HG2 VAL    34       8.448   6.638   4.067  1.00 37.77           H 
ATOM    554 2HG2 VAL    34       8.692   8.134   4.967  1.00 37.77           H 
ATOM    555 3HG2 VAL    34      10.030   7.006   4.749  1.00 37.77           H 
ATOM    556  N   SER    35       8.714   8.719  -0.096  1.00 35.22           N 
ATOM    557  CA  SER    35       8.977   9.296  -1.422  1.00 21.31           C 
ATOM    558  C   SER    35       7.790  10.132  -1.920  1.00 63.04           C 
ATOM    559  O   SER    35       7.960  11.063  -2.709  1.00 31.00           O 
ATOM    560  CB  SER    35       9.279   8.189  -2.435  1.00 52.15           C 
ATOM    561  OG  SER    35       9.487   8.724  -3.733  1.00 71.55           O 
ATOM    562  H   SER    35       8.553   7.754  -0.018  1.00 37.77           H 
ATOM    563  HA  SER    35       9.843   9.940  -1.338  1.00 61.42           H 
ATOM    564 3HB  SER    35       8.449   7.498  -2.474  1.00 37.77           H 
ATOM    565 2HB  SER    35      10.169   7.658  -2.129  1.00 37.77           H 
ATOM    566  HG  SER    35      10.194   8.235  -4.172  1.00 53.32           H 
ATOM    567  N   GLY    36       6.589   9.791  -1.462  1.00 61.21           N 
ATOM    568  CA  GLY    36       5.385  10.510  -1.874  1.00 41.15           C 
ATOM    569  C   GLY    36       4.904  10.142  -3.276  1.00 32.33           C 
ATOM    570  O   GLY    36       4.314  10.966  -3.976  1.00 53.32           O 
ATOM    571  H   GLY    36       6.515   9.053  -0.821  1.00 37.77           H 
ATOM    572 3HA  GLY    36       5.589  11.571  -1.845  1.00 37.77           H 
ATOM    573 2HA  GLY    36       4.595  10.293  -1.170  1.00 37.77           H 
ATOM    574  N   THR    37       5.151   8.902  -3.695  1.00  1.41           N 
ATOM    575  CA  THR    37       4.718   8.434  -5.028  1.00 23.43           C 
ATOM    576  C   THR    37       3.472   7.539  -4.941  1.00 42.33           C 
ATOM    577  O   THR    37       2.971   7.055  -5.957  1.00  2.43           O 
ATOM    578  CB  THR    37       5.850   7.667  -5.761  1.00 52.23           C 
ATOM    579  OG1 THR    37       5.422   7.254  -7.073  1.00 63.45           O 
ATOM    580  CG2 THR    37       6.301   6.446  -4.963  1.00 22.13           C 
ATOM    581  H   THR    37       5.641   8.289  -3.105  1.00 37.77           H 
ATOM    582  HA  THR    37       4.469   9.307  -5.621  1.00 41.55           H 
ATOM    583  HB  THR    37       6.696   8.332  -5.868  1.00 11.50           H 
ATOM    584  HG1 THR    37       4.634   6.699  -7.000  1.00 12.23           H 
ATOM    585 1HG2 THR    37       7.086   5.932  -5.501  1.00 37.77           H 
ATOM    586 2HG2 THR    37       5.464   5.778  -4.820  1.00 37.77           H 
ATOM    587 3HG2 THR    37       6.677   6.763  -3.998  1.00 37.77           H 
ATOM    588  N   VAL    38       2.969   7.329  -3.727  1.00  0.22           N 
ATOM    589  CA  VAL    38       1.796   6.471  -3.509  1.00 33.42           C 
ATOM    590  C   VAL    38       0.486   7.239  -3.733  1.00 75.42           C 
ATOM    591  O   VAL    38       0.149   8.146  -2.969  1.00 62.21           O 
ATOM    592  CB  VAL    38       1.771   5.881  -2.078  1.00 55.21           C 
ATOM    593  CG1 VAL    38       0.601   4.915  -1.909  1.00  2.32           C 
ATOM    594  CG2 VAL    38       3.089   5.192  -1.750  1.00  5.34           C 
ATOM    595  H   VAL    38       3.388   7.764  -2.957  1.00 37.77           H 
ATOM    596  HA  VAL    38       1.845   5.650  -4.212  1.00 15.41           H 
ATOM    597  HB  VAL    38       1.636   6.696  -1.379  1.00  4.23           H 
ATOM    598 1HG1 VAL    38      -0.329   5.440  -2.077  1.00 37.77           H 
ATOM    599 2HG1 VAL    38       0.606   4.510  -0.908  1.00 37.77           H 
ATOM    600 3HG1 VAL    38       0.690   4.106  -2.622  1.00 37.77           H 
ATOM    601 1HG2 VAL    38       3.896   5.909  -1.810  1.00 37.77           H 
ATOM    602 2HG2 VAL    38       3.267   4.392  -2.454  1.00 37.77           H 
ATOM    603 3HG2 VAL    38       3.044   4.785  -0.748  1.00 37.77           H 
ATOM    604  N   GLN    39      -0.250   6.869  -4.779  1.00 32.42           N 
ATOM    605  CA  GLN    39      -1.560   7.466  -5.053  1.00 13.34           C 
ATOM    606  C   GLN    39      -2.697   6.512  -4.658  1.00 24.11           C 
ATOM    607  O   GLN    39      -2.919   5.493  -5.313  1.00 61.13           O 
ATOM    608  CB  GLN    39      -1.699   7.834  -6.539  1.00 62.20           C 
ATOM    609  CG  GLN    39      -0.705   8.886  -7.019  1.00 22.54           C 
ATOM    610  CD  GLN    39      -0.977   9.347  -8.444  1.00 32.40           C 
ATOM    611  OE1 GLN    39      -1.486   8.596  -9.272  1.00 13.23           O 
ATOM    612  NE2 GLN    39      -0.639  10.585  -8.741  1.00 61.13           N 
ATOM    613  H   GLN    39       0.094   6.176  -5.378  1.00 37.77           H 
ATOM    614  HA  GLN    39      -1.644   8.369  -4.463  1.00 65.15           H 
ATOM    615 3HB  GLN    39      -2.700   8.209  -6.711  1.00 37.77           H 
ATOM    616 2HB  GLN    39      -1.557   6.940  -7.133  1.00 37.77           H 
ATOM    617 3HG  GLN    39       0.291   8.471  -6.977  1.00 37.77           H 
ATOM    618 2HG  GLN    39      -0.763   9.743  -6.365  1.00 37.77           H 
ATOM    619 1HE2 GLN    39      -0.235  11.137  -8.043  1.00 37.77           H 
ATOM    620 2HE2 GLN    39      -0.812  10.903  -9.652  1.00 37.77           H 
ATOM    621  N   ARG    40      -3.409   6.840  -3.580  1.00 42.25           N 
ATOM    622  CA  ARG    40      -4.592   6.065  -3.183  1.00  1.55           C 
ATOM    623  C   ARG    40      -5.710   6.214  -4.231  1.00 43.23           C 
ATOM    624  O   ARG    40      -5.623   7.067  -5.115  1.00 61.32           O 
ATOM    625  CB  ARG    40      -5.084   6.504  -1.794  1.00 71.14           C 
ATOM    626  CG  ARG    40      -5.356   8.005  -1.669  1.00 32.01           C 
ATOM    627  CD  ARG    40      -5.893   8.365  -0.284  1.00  2.15           C 
ATOM    628  NE  ARG    40      -7.180   7.727  -0.023  1.00  2.43           N 
ATOM    629  CZ  ARG    40      -7.677   7.504   1.162  1.00 60.21           C 
ATOM    630  NH1 ARG    40      -7.050   7.857   2.235  1.00 62.13           N 
ATOM    631  NH2 ARG    40      -8.827   6.931   1.267  1.00 45.23           N 
ATOM    632  H   ARG    40      -3.135   7.615  -3.045  1.00 37.77           H 
ATOM    633  HA  ARG    40      -4.299   5.023  -3.139  1.00 42.44           H 
ATOM    634 3HB  ARG    40      -4.338   6.233  -1.061  1.00 37.77           H 
ATOM    635 2HB  ARG    40      -6.000   5.977  -1.568  1.00 37.77           H 
ATOM    636 3HG  ARG    40      -6.085   8.293  -2.415  1.00 37.77           H 
ATOM    637 2HG  ARG    40      -4.435   8.543  -1.839  1.00 37.77           H 
ATOM    638 3HD  ARG    40      -6.014   9.439  -0.223  1.00 37.77           H 
ATOM    639 2HD  ARG    40      -5.181   8.041   0.463  1.00 37.77           H 
ATOM    640  HE  ARG    40      -7.709   7.444  -0.796  1.00 53.45           H 
ATOM    641 1HH1 ARG    40      -6.170   8.312   2.172  1.00 37.77           H 
ATOM    642 2HH1 ARG    40      -7.453   7.654   3.126  1.00 37.77           H 
ATOM    643 1HH2 ARG    40      -9.324   6.668   0.444  1.00 37.77           H 
ATOM    644 2HH2 ARG    40      -9.214   6.742   2.170  1.00 37.77           H 
ATOM    645  N   ALA    41      -6.759   5.392  -4.127  1.00 45.45           N 
ATOM    646  CA  ALA    41      -7.856   5.381  -5.116  1.00 33.12           C 
ATOM    647  C   ALA    41      -8.412   6.788  -5.422  1.00 62.33           C 
ATOM    648  O   ALA    41      -8.803   7.080  -6.552  1.00 44.42           O 
ATOM    649  CB  ALA    41      -8.978   4.466  -4.638  1.00 64.21           C 
ATOM    650  H   ALA    41      -6.794   4.763  -3.373  1.00 37.77           H 
ATOM    651  HA  ALA    41      -7.460   4.964  -6.032  1.00 30.21           H 
ATOM    652 1HB  ALA    41      -9.437   4.891  -3.760  1.00 37.77           H 
ATOM    653 2HB  ALA    41      -8.576   3.492  -4.399  1.00 37.77           H 
ATOM    654 3HB  ALA    41      -9.720   4.366  -5.417  1.00 37.77           H 
ATOM    655  N   ASP    42      -8.433   7.658  -4.415  1.00 72.23           N 
ATOM    656  CA  ASP    42      -8.941   9.030  -4.574  1.00 54.15           C 
ATOM    657  C   ASP    42      -8.041   9.898  -5.482  1.00  3.35           C 
ATOM    658  O   ASP    42      -8.375  11.046  -5.785  1.00 22.51           O 
ATOM    659  CB  ASP    42      -9.068   9.688  -3.199  1.00 63.02           C 
ATOM    660  CG  ASP    42      -9.870   8.837  -2.237  1.00 53.11           C 
ATOM    661  OD1 ASP    42      -9.316   7.849  -1.723  1.00 64.32           O 
ATOM    662  OD2 ASP    42     -11.053   9.149  -1.993  1.00 15.20           O 
ATOM    663  H   ASP    42      -8.122   7.367  -3.533  1.00 37.77           H 
ATOM    664  HA  ASP    42      -9.925   8.966  -5.019  1.00  1.24           H 
ATOM    665 3HB  ASP    42      -9.557  10.646  -3.305  1.00 37.77           H 
ATOM    666 2HB  ASP    42      -8.080   9.837  -2.782  1.00 37.77           H 
ATOM    667  N   GLY    43      -6.908   9.347  -5.911  1.00 32.33           N 
ATOM    668  CA  GLY    43      -5.950  10.102  -6.717  1.00 53.41           C 
ATOM    669  C   GLY    43      -5.069  11.030  -5.880  1.00 50.23           C 
ATOM    670  O   GLY    43      -4.466  11.966  -6.403  1.00 11.54           O 
ATOM    671  H   GLY    43      -6.723   8.412  -5.694  1.00 37.77           H 
ATOM    672 3HA  GLY    43      -6.490  10.693  -7.443  1.00 37.77           H 
ATOM    673 2HA  GLY    43      -5.313   9.406  -7.243  1.00 37.77           H 
ATOM    674  N   SER    44      -4.993  10.763  -4.577  1.00 10.42           N 
ATOM    675  CA  SER    44      -4.214  11.601  -3.649  1.00  4.34           C 
ATOM    676  C   SER    44      -2.972  10.865  -3.127  1.00  4.33           C 
ATOM    677  O   SER    44      -2.886   9.639  -3.213  1.00 34.41           O 
ATOM    678  CB  SER    44      -5.086  12.041  -2.471  1.00 72.21           C 
ATOM    679  OG  SER    44      -4.354  12.841  -1.558  1.00 15.51           O 
ATOM    680  H   SER    44      -5.463   9.980  -4.227  1.00 37.77           H 
ATOM    681  HA  SER    44      -3.890  12.483  -4.187  1.00 14.43           H 
ATOM    682 3HB  SER    44      -5.452  11.169  -1.948  1.00 37.77           H 
ATOM    683 2HB  SER    44      -5.924  12.616  -2.839  1.00 37.77           H 
ATOM    684  HG  SER    44      -4.930  13.105  -0.831  1.00 32.44           H 
ATOM    685  N   ILE    45      -2.031  11.619  -2.560  1.00 21.25           N 
ATOM    686  CA  ILE    45      -0.742  11.068  -2.116  1.00 63.21           C 
ATOM    687  C   ILE    45      -0.748  10.723  -0.618  1.00 50.21           C 
ATOM    688  O   ILE    45      -1.248  11.489   0.205  1.00 14.21           O 
ATOM    689  CB  ILE    45       0.409  12.071  -2.395  1.00  4.41           C 
ATOM    690  CG1 ILE    45       0.511  12.364  -3.901  1.00 40.44           C 
ATOM    691  CG2 ILE    45       1.740  11.541  -1.855  1.00 32.25           C 
ATOM    692  CD1 ILE    45       0.836  11.147  -4.745  1.00 31.01           C 
ATOM    693  H   ILE    45      -2.212  12.573  -2.417  1.00 37.77           H 
ATOM    694  HA  ILE    45      -0.548  10.167  -2.681  1.00 20.32           H 
ATOM    695  HB  ILE    45       0.184  12.990  -1.875  1.00 74.41           H 
ATOM    696 3HG1 ILE    45       1.284  13.101  -4.068  1.00 37.77           H 
ATOM    697 2HG1 ILE    45      -0.433  12.761  -4.249  1.00 37.77           H 
ATOM    698 1HG2 ILE    45       1.674  11.420  -0.783  1.00 37.77           H 
ATOM    699 2HG2 ILE    45       2.529  12.242  -2.087  1.00 37.77           H 
ATOM    700 3HG2 ILE    45       1.964  10.588  -2.313  1.00 37.77           H 
ATOM    701 1HD1 ILE    45       0.824  11.420  -5.791  1.00 37.77           H 
ATOM    702 2HD1 ILE    45       0.101  10.376  -4.565  1.00 37.77           H 
ATOM    703 3HD1 ILE    45       1.818  10.778  -4.481  1.00 37.77           H 
ATOM    704  N   GLN    46      -0.189   9.563  -0.272  1.00 72.53           N 
ATOM    705  CA  GLN    46      -0.065   9.156   1.133  1.00 74.45           C 
ATOM    706  C   GLN    46       1.277   9.592   1.739  1.00 40.35           C 
ATOM    707  O   GLN    46       2.343   9.243   1.233  1.00  2.54           O 
ATOM    708  CB  GLN    46      -0.215   7.636   1.279  1.00 70.25           C 
ATOM    709  CG  GLN    46      -1.603   7.113   0.939  1.00  5.24           C 
ATOM    710  CD  GLN    46      -1.742   5.621   1.196  1.00  2.45           C 
ATOM    711  OE1 GLN    46      -1.477   4.809   0.328  1.00 54.02           O 
ATOM    712  NE2 GLN    46      -2.153   5.250   2.393  1.00 15.23           N 
ATOM    713  H   GLN    46       0.147   8.967  -0.976  1.00 37.77           H 
ATOM    714  HA  GLN    46      -0.862   9.636   1.685  1.00  1.21           H 
ATOM    715 3HB  GLN    46       0.005   7.361   2.302  1.00 37.77           H 
ATOM    716 2HB  GLN    46       0.497   7.152   0.627  1.00 37.77           H 
ATOM    717 3HG  GLN    46      -1.799   7.300  -0.109  1.00 37.77           H 
ATOM    718 2HG  GLN    46      -2.332   7.636   1.539  1.00 37.77           H 
ATOM    719 1HE2 GLN    46      -2.352   5.945   3.052  1.00 37.77           H 
ATOM    720 2HE2 GLN    46      -2.240   4.293   2.568  1.00 37.77           H 
ATOM    721  N   ASN    47       1.209  10.358   2.826  1.00 72.43           N 
ATOM    722  CA  ASN    47       2.401  10.748   3.590  1.00 61.21           C 
ATOM    723  C   ASN    47       2.430  10.031   4.951  1.00 10.34           C 
ATOM    724  O   ASN    47       3.380  10.164   5.724  1.00 60.34           O 
ATOM    725  CB  ASN    47       2.426  12.268   3.797  1.00 24.03           C 
ATOM    726  CG  ASN    47       2.453  13.030   2.484  1.00 70.21           C 
ATOM    727  OD1 ASN    47       1.416  13.361   1.922  1.00 21.42           O 
ATOM    728  ND2 ASN    47       3.638  13.313   1.984  1.00 22.22           N 
ATOM    729  H   ASN    47       0.334  10.685   3.117  1.00 37.77           H 
ATOM    730  HA  ASN    47       3.275  10.455   3.026  1.00 42.15           H 
ATOM    731 3HB  ASN    47       3.304  12.537   4.367  1.00 37.77           H 
ATOM    732 2HB  ASN    47       1.542  12.566   4.344  1.00 37.77           H 
ATOM    733 1HD2 ASN    47       4.430  13.023   2.475  1.00 37.77           H 
ATOM    734 2HD2 ASN    47       3.673  13.801   1.134  1.00 37.77           H 
ATOM    735  N   GLN    48       1.377   9.266   5.233  1.00  1.14           N 
ATOM    736  CA  GLN    48       1.258   8.524   6.492  1.00  3.50           C 
ATOM    737  C   GLN    48       1.853   7.110   6.359  1.00 22.11           C 
ATOM    738  O   GLN    48       1.254   6.229   5.734  1.00 33.42           O 
ATOM    739  CB  GLN    48      -0.222   8.442   6.900  1.00 72.14           C 
ATOM    740  CG  GLN    48      -0.897   9.808   7.019  1.00 42.12           C 
ATOM    741  CD  GLN    48      -2.390   9.714   7.289  1.00 71.35           C 
ATOM    742  OE1 GLN    48      -2.864   8.772   7.916  1.00 65.53           O 
ATOM    743  NE2 GLN    48      -3.142  10.689   6.823  1.00 72.14           N 
ATOM    744  H   GLN    48       0.657   9.194   4.573  1.00 37.77           H 
ATOM    745  HA  GLN    48       1.803   9.064   7.255  1.00 61.31           H 
ATOM    746 3HB  GLN    48      -0.291   7.945   7.857  1.00 37.77           H 
ATOM    747 2HB  GLN    48      -0.757   7.860   6.162  1.00 37.77           H 
ATOM    748 3HG  GLN    48      -0.745  10.351   6.096  1.00 37.77           H 
ATOM    749 2HG  GLN    48      -0.435  10.353   7.830  1.00 37.77           H 
ATOM    750 1HE2 GLN    48      -2.708  11.418   6.335  1.00 37.77           H 
ATOM    751 2HE2 GLN    48      -4.108  10.643   6.980  1.00 37.77           H 
ATOM    752  N   SER    49       3.040   6.902   6.929  1.00 51.53           N 
ATOM    753  CA  SER    49       3.725   5.601   6.857  1.00  5.42           C 
ATOM    754  C   SER    49       3.041   4.546   7.738  1.00 33.42           C 
ATOM    755  O   SER    49       3.308   4.451   8.940  1.00 33.04           O 
ATOM    756  CB  SER    49       5.204   5.736   7.262  1.00 31.21           C 
ATOM    757  OG  SER    49       5.922   6.557   6.350  1.00 21.44           O 
ATOM    758  H   SER    49       3.468   7.639   7.409  1.00 37.77           H 
ATOM    759  HA  SER    49       3.680   5.268   5.829  1.00  5.01           H 
ATOM    760 3HB  SER    49       5.660   4.756   7.279  1.00 37.77           H 
ATOM    761 2HB  SER    49       5.268   6.176   8.245  1.00 37.77           H 
ATOM    762  HG  SER    49       6.524   6.007   5.834  1.00 53.22           H 
ATOM    763  N   LEU    50       2.149   3.760   7.132  1.00 33.22           N 
ATOM    764  CA  LEU    50       1.419   2.710   7.858  1.00 31.11           C 
ATOM    765  C   LEU    50       2.353   1.590   8.357  1.00 10.45           C 
ATOM    766  O   LEU    50       3.299   1.188   7.672  1.00 11.54           O 
ATOM    767  CB  LEU    50       0.272   2.142   6.989  1.00 32.13           C 
ATOM    768  CG  LEU    50       0.601   1.847   5.506  1.00 62.21           C 
ATOM    769  CD1 LEU    50       1.494   0.614   5.351  1.00 61.10           C 
ATOM    770  CD2 LEU    50      -0.684   1.683   4.696  1.00  3.51           C 
ATOM    771  H   LEU    50       1.973   3.891   6.179  1.00 37.77           H 
ATOM    772  HA  LEU    50       0.978   3.184   8.727  1.00 53.54           H 
ATOM    773 3HB  LEU    50      -0.544   2.855   7.011  1.00 37.77           H 
ATOM    774 2HB  LEU    50      -0.074   1.226   7.445  1.00 37.77           H 
ATOM    775  HG  LEU    50       1.140   2.690   5.098  1.00 43.31           H 
ATOM    776 1HD1 LEU    50       1.682   0.436   4.303  1.00 37.77           H 
ATOM    777 2HD1 LEU    50       1.000  -0.247   5.779  1.00 37.77           H 
ATOM    778 3HD1 LEU    50       2.431   0.780   5.861  1.00 37.77           H 
ATOM    779 1HD2 LEU    50      -0.437   1.506   3.659  1.00 37.77           H 
ATOM    780 2HD2 LEU    50      -1.278   2.582   4.775  1.00 37.77           H 
ATOM    781 3HD2 LEU    50      -1.250   0.844   5.078  1.00 37.77           H 
ATOM    782  N   HIS    51       2.089   1.098   9.566  1.00 51.22           N 
ATOM    783  CA  HIS    51       2.910   0.048  10.177  1.00 12.44           C 
ATOM    784  C   HIS    51       2.525  -1.350   9.666  1.00 74.33           C 
ATOM    785  O   HIS    51       3.315  -2.290   9.750  1.00 65.14           O 
ATOM    786  CB  HIS    51       2.775   0.097  11.705  1.00 50.21           C 
ATOM    787  CG  HIS    51       3.696  -0.843  12.425  1.00 12.54           C 
ATOM    788  ND1 HIS    51       3.330  -2.116  12.805  1.00 43.33           N 
ATOM    789  CD2 HIS    51       4.977  -0.688  12.831  1.00 65.34           C 
ATOM    790  CE1 HIS    51       4.342  -2.699  13.414  1.00  3.11           C 
ATOM    791  NE2 HIS    51       5.353  -1.857  13.445  1.00 22.32           N 
ATOM    792  H   HIS    51       1.329   1.466  10.069  1.00 37.77           H 
ATOM    793  HA  HIS    51       3.942   0.240   9.912  1.00 65.23           H 
ATOM    794 3HB  HIS    51       1.762  -0.157  11.979  1.00 37.77           H 
ATOM    795 2HB  HIS    51       2.993   1.097  12.048  1.00 37.77           H 
ATOM    796  HD1 HIS    51       2.450  -2.532  12.658  1.00 23.42           H 
ATOM    797  HD2 HIS    51       5.589   0.191  12.696  1.00 21.10           H 
ATOM    798  HE1 HIS    51       4.344  -3.702  13.814  1.00 42.44           H 
ATOM    799  HE2 HIS    51       6.144  -1.959  14.019  1.00 37.77           H 
ATOM    800  N   GLU    52       1.311  -1.487   9.145  1.00 73.04           N 
ATOM    801  CA  GLU    52       0.818  -2.784   8.667  1.00 51.21           C 
ATOM    802  C   GLU    52      -0.183  -2.595   7.512  1.00 44.33           C 
ATOM    803  O   GLU    52      -0.827  -1.549   7.402  1.00 22.22           O 
ATOM    804  CB  GLU    52       0.174  -3.553   9.836  1.00 53.44           C 
ATOM    805  CG  GLU    52      -0.211  -4.993   9.511  1.00 14.42           C 
ATOM    806  CD  GLU    52      -0.748  -5.750  10.720  1.00 34.12           C 
ATOM    807  OE1 GLU    52      -1.827  -5.383  11.235  1.00 73.13           O 
ATOM    808  OE2 GLU    52      -0.097  -6.722  11.159  1.00 63.02           O 
ATOM    809  H   GLU    52       0.729  -0.701   9.075  1.00 37.77           H 
ATOM    810  HA  GLU    52       1.667  -3.345   8.300  1.00 10.40           H 
ATOM    811 3HB  GLU    52      -0.719  -3.026  10.149  1.00 37.77           H 
ATOM    812 2HB  GLU    52       0.870  -3.572  10.663  1.00 37.77           H 
ATOM    813 3HG  GLU    52       0.662  -5.509   9.134  1.00 37.77           H 
ATOM    814 2HG  GLU    52      -0.972  -4.981   8.745  1.00 37.77           H 
ATOM    815  N   ALA    53      -0.300  -3.603   6.646  1.00 35.13           N 
ATOM    816  CA  ALA    53      -1.173  -3.519   5.469  1.00 22.14           C 
ATOM    817  C   ALA    53      -1.585  -4.910   4.961  1.00  3.41           C 
ATOM    818  O   ALA    53      -1.136  -5.935   5.480  1.00 62.51           O 
ATOM    819  CB  ALA    53      -0.481  -2.729   4.360  1.00 65.13           C 
ATOM    820  H   ALA    53       0.203  -4.428   6.805  1.00 37.77           H 
ATOM    821  HA  ALA    53      -2.068  -2.981   5.755  1.00 55.12           H 
ATOM    822 1HB  ALA    53      -1.154  -2.615   3.522  1.00 37.77           H 
ATOM    823 2HB  ALA    53       0.407  -3.254   4.039  1.00 37.77           H 
ATOM    824 3HB  ALA    53      -0.203  -1.752   4.731  1.00 37.77           H 
ATOM    825  N   LEU    54      -2.445  -4.933   3.947  1.00 75.43           N 
ATOM    826  CA  LEU    54      -2.945  -6.182   3.350  1.00 50.40           C 
ATOM    827  C   LEU    54      -2.504  -6.307   1.885  1.00 63.45           C 
ATOM    828  O   LEU    54      -2.476  -5.323   1.152  1.00  4.02           O 
ATOM    829  CB  LEU    54      -4.475  -6.210   3.422  1.00 55.02           C 
ATOM    830  CG  LEU    54      -5.069  -6.142   4.835  1.00 71.02           C 
ATOM    831  CD1 LEU    54      -6.563  -5.837   4.776  1.00  1.45           C 
ATOM    832  CD2 LEU    54      -4.813  -7.444   5.591  1.00 64.21           C 
ATOM    833  H   LEU    54      -2.759  -4.080   3.583  1.00 37.77           H 
ATOM    834  HA  LEU    54      -2.547  -7.015   3.912  1.00 40.54           H 
ATOM    835 3HB  LEU    54      -4.822  -7.122   2.956  1.00 37.77           H 
ATOM    836 2HB  LEU    54      -4.853  -5.374   2.851  1.00 37.77           H 
ATOM    837  HG  LEU    54      -4.591  -5.340   5.382  1.00 55.31           H 
ATOM    838 1HD1 LEU    54      -6.718  -4.891   4.278  1.00 37.77           H 
ATOM    839 2HD1 LEU    54      -6.961  -5.782   5.776  1.00 37.77           H 
ATOM    840 3HD1 LEU    54      -7.071  -6.618   4.227  1.00 37.77           H 
ATOM    841 1HD2 LEU    54      -5.258  -8.270   5.054  1.00 37.77           H 
ATOM    842 2HD2 LEU    54      -5.248  -7.381   6.576  1.00 37.77           H 
ATOM    843 3HD2 LEU    54      -3.748  -7.607   5.680  1.00 37.77           H 
ATOM    844  N   ILE    55      -2.181  -7.524   1.459  1.00 35.50           N 
ATOM    845  CA  ILE    55      -1.754  -7.771   0.078  1.00 11.33           C 
ATOM    846  C   ILE    55      -2.630  -8.828  -0.609  1.00  0.21           C 
ATOM    847  O   ILE    55      -2.935  -9.879  -0.039  1.00 24.22           O 
ATOM    848  CB  ILE    55      -0.266  -8.222   0.023  1.00 15.23           C 
ATOM    849  CG1 ILE    55       0.211  -8.385  -1.434  1.00 74.31           C 
ATOM    850  CG2 ILE    55      -0.061  -9.523   0.799  1.00 51.42           C 
ATOM    851  CD1 ILE    55       0.165  -7.107  -2.249  1.00 21.24           C 
ATOM    852  H   ILE    55      -2.230  -8.274   2.084  1.00 37.77           H 
ATOM    853  HA  ILE    55      -1.842  -6.842  -0.468  1.00 23.34           H 
ATOM    854  HB  ILE    55       0.327  -7.458   0.500  1.00 34.23           H 
ATOM    855 3HG1 ILE    55      -0.411  -9.118  -1.932  1.00 37.77           H 
ATOM    856 2HG1 ILE    55       1.233  -8.733  -1.434  1.00 37.77           H 
ATOM    857 1HG2 ILE    55       0.984  -9.797   0.776  1.00 37.77           H 
ATOM    858 2HG2 ILE    55      -0.648 -10.310   0.348  1.00 37.77           H 
ATOM    859 3HG2 ILE    55      -0.374  -9.386   1.825  1.00 37.77           H 
ATOM    860 1HD1 ILE    55      -0.848  -6.735  -2.281  1.00 37.77           H 
ATOM    861 2HD1 ILE    55       0.505  -7.309  -3.253  1.00 37.77           H 
ATOM    862 3HD1 ILE    55       0.807  -6.367  -1.795  1.00 37.77           H 
ATOM    863  N   THR    56      -3.063  -8.525  -1.828  1.00 64.31           N 
ATOM    864  CA  THR    56      -3.711  -9.526  -2.682  1.00 44.40           C 
ATOM    865  C   THR    56      -2.696 -10.592  -3.116  1.00 73.44           C 
ATOM    866  O   THR    56      -1.557 -10.270  -3.435  1.00 61.53           O 
ATOM    867  CB  THR    56      -4.324  -8.879  -3.948  1.00  2.03           C 
ATOM    868  OG1 THR    56      -3.313  -8.139  -4.663  1.00  5.31           O 
ATOM    869  CG2 THR    56      -5.482  -7.953  -3.588  1.00 41.14           C 
ATOM    870  H   THR    56      -2.963  -7.605  -2.153  1.00 37.77           H 
ATOM    871  HA  THR    56      -4.504  -9.996  -2.114  1.00 53.24           H 
ATOM    872  HB  THR    56      -4.699  -9.666  -4.589  1.00 52.34           H 
ATOM    873  HG1 THR    56      -2.514  -8.096  -4.121  1.00 43.14           H 
ATOM    874 1HG2 THR    56      -5.136  -7.183  -2.912  1.00 37.77           H 
ATOM    875 2HG2 THR    56      -6.265  -8.525  -3.107  1.00 37.77           H 
ATOM    876 3HG2 THR    56      -5.872  -7.494  -4.485  1.00 37.77           H 
ATOM    877  N   ARG    57      -3.112 -11.855  -3.137  1.00 10.23           N 
ATOM    878  CA  ARG    57      -2.212 -12.965  -3.487  1.00 41.23           C 
ATOM    879  C   ARG    57      -1.654 -12.825  -4.915  1.00 43.24           C 
ATOM    880  O   ARG    57      -0.513 -13.205  -5.190  1.00 75.13           O 
ATOM    881  CB  ARG    57      -2.946 -14.298  -3.330  1.00 14.31           C 
ATOM    882  CG  ARG    57      -2.060 -15.531  -3.503  1.00 33.52           C 
ATOM    883  CD  ARG    57      -2.796 -16.805  -3.101  1.00 71.21           C 
ATOM    884  NE  ARG    57      -3.312 -16.724  -1.736  1.00 20.22           N 
ATOM    885  CZ  ARG    57      -3.952 -17.683  -1.130  1.00 13.44           C 
ATOM    886  NH1 ARG    57      -4.121 -18.827  -1.704  1.00 34.13           N 
ATOM    887  NH2 ARG    57      -4.428 -17.490   0.057  1.00 53.40           N 
ATOM    888  H   ARG    57      -4.042 -12.051  -2.899  1.00 37.77           H 
ATOM    889  HA  ARG    57      -1.385 -12.942  -2.790  1.00 10.23           H 
ATOM    890 3HB  ARG    57      -3.740 -14.344  -4.063  1.00 37.77           H 
ATOM    891 2HB  ARG    57      -3.384 -14.335  -2.342  1.00 37.77           H 
ATOM    892 3HG  ARG    57      -1.181 -15.424  -2.884  1.00 37.77           H 
ATOM    893 2HG  ARG    57      -1.764 -15.609  -4.540  1.00 37.77           H 
ATOM    894 3HD  ARG    57      -2.111 -17.641  -3.170  1.00 37.77           H 
ATOM    895 2HD  ARG    57      -3.621 -16.962  -3.781  1.00 37.77           H 
ATOM    896  HE  ARG    57      -3.176 -15.883  -1.252  1.00 23.15           H 
ATOM    897 1HH1 ARG    57      -3.760 -18.985  -2.616  1.00 37.77           H 
ATOM    898 2HH1 ARG    57      -4.618 -19.552  -1.231  1.00 37.77           H 
ATOM    899 1HH2 ARG    57      -4.308 -16.603   0.504  1.00 37.77           H 
ATOM    900 2HH2 ARG    57      -4.911 -18.225   0.524  1.00 37.77           H 
ATOM    901  N   ASP    58      -2.467 -12.279  -5.820  1.00 50.40           N 
ATOM    902  CA  ASP    58      -2.031 -11.992  -7.193  1.00 30.15           C 
ATOM    903  C   ASP    58      -1.084 -10.769  -7.216  1.00  3.04           C 
ATOM    904  O   ASP    58      -0.454 -10.465  -8.230  1.00 22.40           O 
ATOM    905  CB  ASP    58      -3.262 -11.749  -8.078  1.00 73.13           C 
ATOM    906  CG  ASP    58      -2.930 -11.771  -9.560  1.00 13.24           C 
ATOM    907  OD1 ASP    58      -2.923 -10.696 -10.190  1.00 32.45           O 
ATOM    908  OD2 ASP    58      -2.673 -12.870 -10.093  1.00 31.14           O 
ATOM    909  H   ASP    58      -3.389 -12.076  -5.561  1.00 37.77           H 
ATOM    910  HA  ASP    58      -1.493 -12.855  -7.560  1.00 45.54           H 
ATOM    911 3HB  ASP    58      -3.691 -10.786  -7.831  1.00 37.77           H 
ATOM    912 2HB  ASP    58      -3.996 -12.521  -7.881  1.00 37.77           H 
ATOM    913  N   ARG    59      -1.001 -10.095  -6.066  1.00  5.01           N 
ATOM    914  CA  ARG    59      -0.108  -8.948  -5.845  1.00 35.32           C 
ATOM    915  C   ARG    59      -0.333  -7.804  -6.850  1.00 64.34           C 
ATOM    916  O   ARG    59       0.522  -7.495  -7.680  1.00  4.52           O 
ATOM    917  CB  ARG    59       1.363  -9.406  -5.803  1.00  2.13           C 
ATOM    918  CG  ARG    59       1.608 -10.462  -4.725  1.00 22.13           C 
ATOM    919  CD  ARG    59       3.083 -10.804  -4.541  1.00 54.44           C 
ATOM    920  NE  ARG    59       3.254 -11.840  -3.521  1.00 15.32           N 
ATOM    921  CZ  ARG    59       4.131 -11.811  -2.555  1.00 72.21           C 
ATOM    922  NH1 ARG    59       5.002 -10.854  -2.466  1.00 32.04           N 
ATOM    923  NH2 ARG    59       4.142 -12.762  -1.679  1.00 73.51           N 
ATOM    924  H   ARG    59      -1.563 -10.388  -5.323  1.00 37.77           H 
ATOM    925  HA  ARG    59      -0.357  -8.561  -4.864  1.00 13.52           H 
ATOM    926 3HB  ARG    59       1.994  -8.552  -5.593  1.00 37.77           H 
ATOM    927 2HB  ARG    59       1.636  -9.822  -6.762  1.00 37.77           H 
ATOM    928 3HG  ARG    59       1.073 -11.361  -4.995  1.00 37.77           H 
ATOM    929 2HG  ARG    59       1.225 -10.091  -3.786  1.00 37.77           H 
ATOM    930 3HD  ARG    59       3.614  -9.912  -4.237  1.00 37.77           H 
ATOM    931 2HD  ARG    59       3.480 -11.160  -5.480  1.00 37.77           H 
ATOM    932  HE  ARG    59       2.646 -12.606  -3.559  1.00 61.20           H 
ATOM    933 1HH1 ARG    59       5.010 -10.123  -3.142  1.00 37.77           H 
ATOM    934 2HH1 ARG    59       5.668 -10.855  -1.721  1.00 37.77           H 
ATOM    935 1HH2 ARG    59       3.484 -13.510  -1.755  1.00 37.77           H 
ATOM    936 2HH2 ARG    59       4.793 -12.737  -0.923  1.00 37.77           H 
ATOM    937  N   LYS    60      -1.512  -7.179  -6.756  1.00 61.24           N 
ATOM    938  CA  LYS    60      -1.836  -5.995  -7.564  1.00 23.05           C 
ATOM    939  C   LYS    60      -2.514  -4.893  -6.724  1.00 63.52           C 
ATOM    940  O   LYS    60      -2.481  -3.715  -7.087  1.00 45.32           O 
ATOM    941  CB  LYS    60      -2.722  -6.386  -8.758  1.00 42.53           C 
ATOM    942  CG  LYS    60      -4.073  -6.997  -8.381  1.00 43.24           C 
ATOM    943  CD  LYS    60      -4.783  -7.573  -9.608  1.00 44.00           C 
ATOM    944  CE  LYS    60      -6.131  -8.201  -9.265  1.00 74.42           C 
ATOM    945  NZ  LYS    60      -7.168  -7.180  -8.942  1.00 11.23           N 
ATOM    946  H   LYS    60      -2.186  -7.537  -6.141  1.00 37.77           H 
ATOM    947  HA  LYS    60      -0.903  -5.598  -7.944  1.00 61.41           H 
ATOM    948 3HB  LYS    60      -2.186  -7.106  -9.362  1.00 37.77           H 
ATOM    949 2HB  LYS    60      -2.908  -5.505  -9.357  1.00 37.77           H 
ATOM    950 3HG  LYS    60      -4.696  -6.228  -7.943  1.00 37.77           H 
ATOM    951 2HG  LYS    60      -3.916  -7.788  -7.663  1.00 37.77           H 
ATOM    952 3HD  LYS    60      -4.148  -8.329 -10.053  1.00 37.77           H 
ATOM    953 2HD  LYS    60      -4.945  -6.779 -10.323  1.00 37.77           H 
ATOM    954 3HE  LYS    60      -6.004  -8.851  -8.412  1.00 37.77           H 
ATOM    955 2HE  LYS    60      -6.469  -8.783 -10.109  1.00 37.77           H 
ATOM    956 1HZ  LYS    60      -8.102  -7.637  -8.848  1.00 37.77           H 
ATOM    957 2HZ  LYS    60      -7.217  -6.470  -9.704  1.00 37.77           H 
ATOM    958 3HZ  LYS    60      -6.937  -6.699  -8.055  1.00 37.77           H 
ATOM    959  N   GLN    61      -3.127  -5.278  -5.603  1.00  5.24           N 
ATOM    960  CA  GLN    61      -3.779  -4.317  -4.697  1.00 32.22           C 
ATOM    961  C   GLN    61      -3.264  -4.465  -3.255  1.00 13.03           C 
ATOM    962  O   GLN    61      -3.025  -5.579  -2.779  1.00 24.21           O 
ATOM    963  CB  GLN    61      -5.303  -4.508  -4.721  1.00 64.10           C 
ATOM    964  CG  GLN    61      -5.949  -4.204  -6.067  1.00 61.43           C 
ATOM    965  CD  GLN    61      -6.006  -2.714  -6.369  1.00 21.34           C 
ATOM    966  OE1 GLN    61      -6.975  -2.044  -6.045  1.00 61.43           O 
ATOM    967  NE2 GLN    61      -4.964  -2.184  -6.978  1.00 34.32           N 
ATOM    968  H   GLN    61      -3.149  -6.230  -5.372  1.00 37.77           H 
ATOM    969  HA  GLN    61      -3.546  -3.319  -5.047  1.00 32.43           H 
ATOM    970 3HB  GLN    61      -5.748  -3.858  -3.979  1.00 37.77           H 
ATOM    971 2HB  GLN    61      -5.530  -5.533  -4.466  1.00 37.77           H 
ATOM    972 3HG  GLN    61      -6.958  -4.593  -6.064  1.00 37.77           H 
ATOM    973 2HG  GLN    61      -5.381  -4.692  -6.846  1.00 37.77           H 
ATOM    974 1HE2 GLN    61      -4.212  -2.766  -7.205  1.00 37.77           H 
ATOM    975 2HE2 GLN    61      -4.991  -1.228  -7.178  1.00 37.77           H 
ATOM    976  N   VAL    62      -3.086  -3.329  -2.582  1.00  1.55           N 
ATOM    977  CA  VAL    62      -2.670  -3.293  -1.174  1.00  4.03           C 
ATOM    978  C   VAL    62      -3.664  -2.470  -0.336  1.00 53.30           C 
ATOM    979  O   VAL    62      -3.902  -1.299  -0.622  1.00  4.54           O 
ATOM    980  CB  VAL    62      -1.253  -2.674  -1.021  1.00  5.14           C 
ATOM    981  CG1 VAL    62      -0.833  -2.622   0.448  1.00  3.31           C 
ATOM    982  CG2 VAL    62      -0.222  -3.444  -1.849  1.00 42.44           C 
ATOM    983  H   VAL    62      -3.235  -2.478  -3.047  1.00 37.77           H 
ATOM    984  HA  VAL    62      -2.644  -4.308  -0.796  1.00 31.03           H 
ATOM    985  HB  VAL    62      -1.288  -1.657  -1.392  1.00  0.44           H 
ATOM    986 1HG1 VAL    62       0.137  -2.152   0.530  1.00 37.77           H 
ATOM    987 2HG1 VAL    62      -0.780  -3.625   0.845  1.00 37.77           H 
ATOM    988 3HG1 VAL    62      -1.559  -2.051   1.011  1.00 37.77           H 
ATOM    989 1HG2 VAL    62       0.755  -3.002  -1.710  1.00 37.77           H 
ATOM    990 2HG2 VAL    62      -0.490  -3.398  -2.894  1.00 37.77           H 
ATOM    991 3HG2 VAL    62      -0.198  -4.476  -1.528  1.00 37.77           H 
ATOM    992  N   PHE    63      -4.242  -3.076   0.697  1.00 42.25           N 
ATOM    993  CA  PHE    63      -5.208  -2.377   1.556  1.00 71.33           C 
ATOM    994  C   PHE    63      -4.551  -1.885   2.854  1.00  4.11           C 
ATOM    995  O   PHE    63      -3.566  -2.454   3.326  1.00 42.33           O 
ATOM    996  CB  PHE    63      -6.407  -3.283   1.872  1.00 53.13           C 
ATOM    997  CG  PHE    63      -7.217  -3.655   0.656  1.00 51.20           C 
ATOM    998  CD1 PHE    63      -8.323  -2.898   0.284  1.00 44.31           C 
ATOM    999  CD2 PHE    63      -6.877  -4.758  -0.115  1.00 43.12           C 
ATOM   1000  CE1 PHE    63      -9.068  -3.236  -0.830  1.00 43.11           C 
ATOM   1001  CE2 PHE    63      -7.619  -5.099  -1.230  1.00 45.12           C 
ATOM   1002  CZ  PHE    63      -8.716  -4.336  -1.588  1.00 41.44           C 
ATOM   1003  H   PHE    63      -4.012  -4.008   0.890  1.00 37.77           H 
ATOM   1004  HA  PHE    63      -5.566  -1.513   1.012  1.00 25.10           H 
ATOM   1005 3HB  PHE    63      -7.061  -2.775   2.567  1.00 37.77           H 
ATOM   1006 2HB  PHE    63      -6.051  -4.195   2.324  1.00 37.77           H 
ATOM   1007  HD1 PHE    63      -8.598  -2.034   0.873  1.00 44.25           H 
ATOM   1008  HD2 PHE    63      -6.019  -5.356   0.162  1.00 73.41           H 
ATOM   1009  HE1 PHE    63      -9.925  -2.641  -1.108  1.00 60.40           H 
ATOM   1010  HE2 PHE    63      -7.343  -5.961  -1.822  1.00 21.40           H 
ATOM   1011  HZ  PHE    63      -9.299  -4.603  -2.456  1.00 53.20           H 
ATOM   1012  N   ARG    64      -5.108  -0.822   3.424  1.00 11.24           N 
ATOM   1013  CA  ARG    64      -4.545  -0.182   4.620  1.00 42.15           C 
ATOM   1014  C   ARG    64      -4.949  -0.913   5.915  1.00 63.23           C 
ATOM   1015  O   ARG    64      -5.977  -1.587   5.973  1.00 11.13           O 
ATOM   1016  CB  ARG    64      -5.019   1.280   4.674  1.00 32.21           C 
ATOM   1017  CG  ARG    64      -4.460   2.091   5.842  1.00  0.31           C 
ATOM   1018  CD  ARG    64      -5.049   3.496   5.865  1.00 62.24           C 
ATOM   1019  NE  ARG    64      -4.447   4.343   6.889  1.00 11.41           N 
ATOM   1020  CZ  ARG    64      -4.594   5.640   6.935  1.00 41.21           C 
ATOM   1021  NH1 ARG    64      -5.328   6.255   6.055  1.00 73.44           N 
ATOM   1022  NH2 ARG    64      -4.016   6.316   7.871  1.00  0.32           N 
ATOM   1023  H   ARG    64      -5.924  -0.451   3.027  1.00 37.77           H 
ATOM   1024  HA  ARG    64      -3.468  -0.195   4.531  1.00 73.15           H 
ATOM   1025 3HB  ARG    64      -6.098   1.291   4.742  1.00 37.77           H 
ATOM   1026 2HB  ARG    64      -4.727   1.770   3.757  1.00 37.77           H 
ATOM   1027 3HG  ARG    64      -3.385   2.162   5.739  1.00 37.77           H 
ATOM   1028 2HG  ARG    64      -4.703   1.592   6.769  1.00 37.77           H 
ATOM   1029 3HD  ARG    64      -6.113   3.421   6.055  1.00 37.77           H 
ATOM   1030 2HD  ARG    64      -4.892   3.954   4.899  1.00 37.77           H 
ATOM   1031  HE  ARG    64      -3.900   3.912   7.578  1.00 41.03           H 
ATOM   1032 1HH1 ARG    64      -5.788   5.731   5.333  1.00 37.77           H 
ATOM   1033 2HH1 ARG    64      -5.431   7.244   6.097  1.00 37.77           H 
ATOM   1034 1HH2 ARG    64      -3.460   5.843   8.552  1.00 37.77           H 
ATOM   1035 2HH2 ARG    64      -4.125   7.306   7.914  1.00 37.77           H 
ATOM   1036  N   ILE    65      -4.116  -0.786   6.948  1.00 50.24           N 
ATOM   1037  CA  ILE    65      -4.452  -1.274   8.290  1.00 61.35           C 
ATOM   1038  C   ILE    65      -4.097  -0.224   9.354  1.00 74.43           C 
ATOM   1039  O   ILE    65      -3.009   0.352   9.329  1.00  4.34           O 
ATOM   1040  CB  ILE    65      -3.725  -2.604   8.631  1.00 64.04           C 
ATOM   1041  CG1 ILE    65      -4.199  -3.731   7.702  1.00 13.51           C 
ATOM   1042  CG2 ILE    65      -3.945  -2.984  10.099  1.00 44.23           C 
ATOM   1043  CD1 ILE    65      -3.644  -5.093   8.054  1.00 44.14           C 
ATOM   1044  H   ILE    65      -3.244  -0.362   6.806  1.00 37.77           H 
ATOM   1045  HA  ILE    65      -5.521  -1.452   8.325  1.00 63.23           H 
ATOM   1046  HB  ILE    65      -2.664  -2.451   8.485  1.00 55.23           H 
ATOM   1047 3HG1 ILE    65      -3.897  -3.501   6.689  1.00 37.77           H 
ATOM   1048 2HG1 ILE    65      -5.274  -3.793   7.741  1.00 37.77           H 
ATOM   1049 1HG2 ILE    65      -5.000  -3.149  10.276  1.00 37.77           H 
ATOM   1050 2HG2 ILE    65      -3.593  -2.186  10.737  1.00 37.77           H 
ATOM   1051 3HG2 ILE    65      -3.398  -3.888  10.322  1.00 37.77           H 
ATOM   1052 1HD1 ILE    65      -2.573  -5.092   7.916  1.00 37.77           H 
ATOM   1053 2HD1 ILE    65      -4.089  -5.839   7.413  1.00 37.77           H 
ATOM   1054 3HD1 ILE    65      -3.873  -5.325   9.084  1.00 37.77           H 
ATOM   1055  N   GLU    66      -5.026   0.021  10.275  1.00  3.24           N 
ATOM   1056  CA  GLU    66      -4.794   0.951  11.389  1.00 35.14           C 
ATOM   1057  C   GLU    66      -5.454   0.432  12.677  1.00 71.53           C 
ATOM   1058  O   GLU    66      -6.574  -0.093  12.642  1.00 21.31           O 
ATOM   1059  CB  GLU    66      -5.310   2.358  11.038  1.00 72.02           C 
ATOM   1060  CG  GLU    66      -6.800   2.420  10.720  1.00 62.13           C 
ATOM   1061  CD  GLU    66      -7.292   3.842  10.499  1.00 52.13           C 
ATOM   1062  OE1 GLU    66      -7.626   4.521  11.497  1.00 61.41           O 
ATOM   1063  OE2 GLU    66      -7.356   4.289   9.334  1.00 73.42           O 
ATOM   1064  H   GLU    66      -5.892  -0.435  10.209  1.00 37.77           H 
ATOM   1065  HA  GLU    66      -3.725   1.004  11.553  1.00 15.33           H 
ATOM   1066 3HB  GLU    66      -4.768   2.719  10.174  1.00 37.77           H 
ATOM   1067 2HB  GLU    66      -5.115   3.018  11.870  1.00 37.77           H 
ATOM   1068 3HG  GLU    66      -7.350   1.986  11.544  1.00 37.77           H 
ATOM   1069 2HG  GLU    66      -6.989   1.843   9.825  1.00 37.77           H 
ATOM   1070  N   ASP    67      -4.747   0.561  13.806  1.00 10.10           N 
ATOM   1071  CA  ASP    67      -5.206   0.025  15.098  1.00 44.44           C 
ATOM   1072  C   ASP    67      -5.361  -1.512  15.009  1.00 71.22           C 
ATOM   1073  O   ASP    67      -6.180  -2.126  15.697  1.00 61.33           O 
ATOM   1074  CB  ASP    67      -6.520   0.707  15.523  1.00 62.33           C 
ATOM   1075  CG  ASP    67      -6.935   0.365  16.946  1.00 22.33           C 
ATOM   1076  OD1 ASP    67      -6.167   0.659  17.885  1.00 62.32           O 
ATOM   1077  OD2 ASP    67      -8.038  -0.183  17.138  1.00 71.12           O 
ATOM   1078  H   ASP    67      -3.882   1.026  13.769  1.00 37.77           H 
ATOM   1079  HA  ASP    67      -4.440   0.247  15.831  1.00 53.03           H 
ATOM   1080 3HB  ASP    67      -7.308   0.401  14.849  1.00 37.77           H 
ATOM   1081 2HB  ASP    67      -6.396   1.780  15.456  1.00 37.77           H 
ATOM   1082  N   SER    68      -4.538  -2.118  14.143  1.00 52.34           N 
ATOM   1083  CA  SER    68      -4.540  -3.573  13.891  1.00 70.01           C 
ATOM   1084  C   SER    68      -5.834  -4.039  13.198  1.00 10.10           C 
ATOM   1085  O   SER    68      -6.096  -5.240  13.085  1.00  4.21           O 
ATOM   1086  CB  SER    68      -4.324  -4.359  15.195  1.00 24.13           C 
ATOM   1087  OG  SER    68      -4.150  -5.749  14.939  1.00 12.33           O 
ATOM   1088  H   SER    68      -3.889  -1.563  13.657  1.00 37.77           H 
ATOM   1089  HA  SER    68      -3.713  -3.781  13.224  1.00  5.34           H 
ATOM   1090 3HB  SER    68      -5.181  -4.230  15.839  1.00 37.77           H 
ATOM   1091 2HB  SER    68      -3.439  -3.988  15.696  1.00 37.77           H 
ATOM   1092  HG  SER    68      -5.010  -6.156  14.780  1.00 51.41           H 
ATOM   1093  N   ILE    69      -6.628  -3.085  12.711  1.00 71.43           N 
ATOM   1094  CA  ILE    69      -7.881  -3.395  12.015  1.00 71.30           C 
ATOM   1095  C   ILE    69      -7.687  -3.400  10.487  1.00 24.04           C 
ATOM   1096  O   ILE    69      -7.264  -2.397   9.908  1.00  4.10           O 
ATOM   1097  CB  ILE    69      -8.992  -2.376  12.388  1.00 31.21           C 
ATOM   1098  CG1 ILE    69      -9.216  -2.360  13.910  1.00 75.43           C 
ATOM   1099  CG2 ILE    69     -10.293  -2.691  11.647  1.00 54.22           C 
ATOM   1100  CD1 ILE    69      -9.649  -3.693  14.485  1.00 23.51           C 
ATOM   1101  H   ILE    69      -6.365  -2.148  12.819  1.00 37.77           H 
ATOM   1102  HA  ILE    69      -8.207  -4.377  12.333  1.00 62.42           H 
ATOM   1103  HB  ILE    69      -8.662  -1.395  12.073  1.00 72.12           H 
ATOM   1104 3HG1 ILE    69      -9.981  -1.634  14.147  1.00 37.77           H 
ATOM   1105 2HG1 ILE    69      -8.297  -2.074  14.400  1.00 37.77           H 
ATOM   1106 1HG2 ILE    69     -10.126  -2.636  10.581  1.00 37.77           H 
ATOM   1107 2HG2 ILE    69     -11.052  -1.975  11.929  1.00 37.77           H 
ATOM   1108 3HG2 ILE    69     -10.624  -3.687  11.908  1.00 37.77           H 
ATOM   1109 1HD1 ILE    69      -8.899  -4.442  14.271  1.00 37.77           H 
ATOM   1110 2HD1 ILE    69     -10.588  -3.991  14.042  1.00 37.77           H 
ATOM   1111 3HD1 ILE    69      -9.769  -3.601  15.554  1.00 37.77           H 
ATOM   1112  N   PRO    70      -7.979  -4.536   9.818  1.00 33.43           N 
ATOM   1113  CA  PRO    70      -7.892  -4.639   8.350  1.00  2.23           C 
ATOM   1114  C   PRO    70      -8.915  -3.738   7.639  1.00 62.42           C 
ATOM   1115  O   PRO    70     -10.122  -3.969   7.728  1.00 65.13           O 
ATOM   1116  CB  PRO    70      -8.191  -6.127   8.069  1.00 14.13           C 
ATOM   1117  CG  PRO    70      -8.006  -6.817   9.379  1.00 61.01           C 
ATOM   1118  CD  PRO    70      -8.397  -5.810  10.426  1.00 20.12           C 
ATOM   1119  HA  PRO    70      -6.901  -4.396   8.000  1.00 12.11           H 
ATOM   1120 3HB  PRO    70      -7.503  -6.501   7.325  1.00 37.77           H 
ATOM   1121 2HB  PRO    70      -9.205  -6.234   7.707  1.00 37.77           H 
ATOM   1122 3HG  PRO    70      -6.970  -7.105   9.504  1.00 37.77           H 
ATOM   1123 2HG  PRO    70      -8.647  -7.687   9.430  1.00 37.77           H 
ATOM   1124 3HD  PRO    70      -7.864  -5.993  11.348  1.00 37.77           H 
ATOM   1125 2HD  PRO    70      -9.464  -5.830  10.592  1.00 37.77           H 
ATOM   1126  N   VAL    71      -8.435  -2.708   6.944  1.00 14.33           N 
ATOM   1127  CA  VAL    71      -9.318  -1.778   6.237  1.00 72.31           C 
ATOM   1128  C   VAL    71      -9.582  -2.244   4.789  1.00 33.31           C 
ATOM   1129  O   VAL    71      -8.839  -1.908   3.864  1.00 14.01           O 
ATOM   1130  CB  VAL    71      -8.727  -0.337   6.233  1.00 20.55           C 
ATOM   1131  CG1 VAL    71      -9.682   0.650   5.565  1.00 33.24           C 
ATOM   1132  CG2 VAL    71      -8.384   0.110   7.661  1.00  2.45           C 
ATOM   1133  H   VAL    71      -7.463  -2.568   6.904  1.00 37.77           H 
ATOM   1134  HA  VAL    71     -10.262  -1.751   6.767  1.00 71.43           H 
ATOM   1135  HB  VAL    71      -7.809  -0.352   5.661  1.00 55.33           H 
ATOM   1136 1HG1 VAL    71     -10.623   0.659   6.098  1.00 37.77           H 
ATOM   1137 2HG1 VAL    71      -9.852   0.350   4.541  1.00 37.77           H 
ATOM   1138 3HG1 VAL    71      -9.250   1.640   5.583  1.00 37.77           H 
ATOM   1139 1HG2 VAL    71      -7.640  -0.551   8.081  1.00 37.77           H 
ATOM   1140 2HG2 VAL    71      -9.273   0.082   8.273  1.00 37.77           H 
ATOM   1141 3HG2 VAL    71      -7.995   1.119   7.642  1.00 37.77           H 
ATOM   1142  N   LEU    72     -10.640  -3.037   4.608  1.00 51.13           N 
ATOM   1143  CA  LEU    72     -11.040  -3.533   3.282  1.00 44.22           C 
ATOM   1144  C   LEU    72     -11.863  -2.486   2.502  1.00 70.13           C 
ATOM   1145  O   LEU    72     -12.726  -2.836   1.690  1.00 13.44           O 
ATOM   1146  CB  LEU    72     -11.865  -4.823   3.446  1.00 60.34           C 
ATOM   1147  CG  LEU    72     -11.180  -5.952   4.236  1.00 44.14           C 
ATOM   1148  CD1 LEU    72     -12.108  -7.158   4.372  1.00 55.21           C 
ATOM   1149  CD2 LEU    72      -9.863  -6.353   3.575  1.00  0.43           C 
ATOM   1150  H   LEU    72     -11.158  -3.321   5.392  1.00 37.77           H 
ATOM   1151  HA  LEU    72     -10.142  -3.759   2.723  1.00 52.41           H 
ATOM   1152 3HB  LEU    72     -12.103  -5.198   2.460  1.00 37.77           H 
ATOM   1153 2HB  LEU    72     -12.788  -4.571   3.948  1.00 37.77           H 
ATOM   1154  HG  LEU    72     -10.956  -5.596   5.233  1.00 52.30           H 
ATOM   1155 1HD1 LEU    72     -11.611  -7.936   4.936  1.00 37.77           H 
ATOM   1156 2HD1 LEU    72     -12.366  -7.531   3.391  1.00 37.77           H 
ATOM   1157 3HD1 LEU    72     -13.008  -6.862   4.892  1.00 37.77           H 
ATOM   1158 1HD2 LEU    72      -9.211  -5.492   3.519  1.00 37.77           H 
ATOM   1159 2HD2 LEU    72     -10.053  -6.724   2.578  1.00 37.77           H 
ATOM   1160 3HD2 LEU    72      -9.385  -7.126   4.162  1.00 37.77           H 
ATOM   1161  N   LEU    73     -11.583  -1.205   2.733  1.00 42.34           N 
ATOM   1162  CA  LEU    73     -12.299  -0.115   2.062  1.00 63.31           C 
ATOM   1163  C   LEU    73     -11.632   0.246   0.722  1.00 14.10           C 
ATOM   1164  O   LEU    73     -10.407   0.283   0.622  1.00 53.44           O 
ATOM   1165  CB  LEU    73     -12.357   1.114   2.976  1.00 22.14           C 
ATOM   1166  CG  LEU    73     -13.118   0.913   4.298  1.00  2.32           C 
ATOM   1167  CD1 LEU    73     -13.094   2.187   5.137  1.00 14.20           C 
ATOM   1168  CD2 LEU    73     -14.558   0.471   4.031  1.00 22.41           C 
ATOM   1169  H   LEU    73     -10.866  -0.983   3.361  1.00 37.77           H 
ATOM   1170  HA  LEU    73     -13.309  -0.453   1.869  1.00 23.32           H 
ATOM   1171 3HB  LEU    73     -12.827   1.922   2.435  1.00 37.77           H 
ATOM   1172 2HB  LEU    73     -11.341   1.408   3.212  1.00 37.77           H 
ATOM   1173  HG  LEU    73     -12.632   0.132   4.868  1.00  0.41           H 
ATOM   1174 1HD1 LEU    73     -12.071   2.443   5.372  1.00 37.77           H 
ATOM   1175 2HD1 LEU    73     -13.643   2.025   6.052  1.00 37.77           H 
ATOM   1176 3HD1 LEU    73     -13.549   2.995   4.582  1.00 37.77           H 
ATOM   1177 1HD2 LEU    73     -15.067   0.317   4.970  1.00 37.77           H 
ATOM   1178 2HD2 LEU    73     -14.555  -0.453   3.468  1.00 37.77           H 
ATOM   1179 3HD2 LEU    73     -15.072   1.235   3.465  1.00 37.77           H 
ATOM   1180  N   PRO    74     -12.437   0.539  -0.321  1.00 45.13           N 
ATOM   1181  CA  PRO    74     -11.922   0.757  -1.691  1.00 55.51           C 
ATOM   1182  C   PRO    74     -11.028   2.001  -1.838  1.00 61.22           C 
ATOM   1183  O   PRO    74     -10.082   2.000  -2.625  1.00 11.30           O 
ATOM   1184  CB  PRO    74     -13.202   0.916  -2.526  1.00 13.31           C 
ATOM   1185  CG  PRO    74     -14.240   1.367  -1.553  1.00 34.00           C 
ATOM   1186  CD  PRO    74     -13.906   0.685  -0.257  1.00 25.53           C 
ATOM   1187  HA  PRO    74     -11.376  -0.108  -2.040  1.00  4.41           H 
ATOM   1188 3HB  PRO    74     -13.464  -0.036  -2.971  1.00 37.77           H 
ATOM   1189 2HB  PRO    74     -13.043   1.647  -3.307  1.00 37.77           H 
ATOM   1190 3HG  PRO    74     -15.222   1.069  -1.893  1.00 37.77           H 
ATOM   1191 2HG  PRO    74     -14.196   2.442  -1.438  1.00 37.77           H 
ATOM   1192 3HD  PRO    74     -14.387  -0.280  -0.199  1.00 37.77           H 
ATOM   1193 2HD  PRO    74     -14.197   1.303   0.583  1.00 37.77           H 
ATOM   1194  N   GLU    75     -11.320   3.063  -1.087  1.00  3.03           N 
ATOM   1195  CA  GLU    75     -10.571   4.319  -1.226  1.00 71.11           C 
ATOM   1196  C   GLU    75      -9.237   4.306  -0.451  1.00 10.34           C 
ATOM   1197  O   GLU    75      -8.301   5.025  -0.807  1.00 12.22           O 
ATOM   1198  CB  GLU    75     -11.440   5.538  -0.849  1.00 20.24           C 
ATOM   1199  CG  GLU    75     -12.403   5.324   0.316  1.00 24.44           C 
ATOM   1200  CD  GLU    75     -11.707   5.134   1.647  1.00 52.51           C 
ATOM   1201  OE1 GLU    75     -11.283   6.144   2.253  1.00 42.42           O 
ATOM   1202  OE2 GLU    75     -11.607   3.984   2.103  1.00 33.11           O 
ATOM   1203  H   GLU    75     -12.042   3.000  -0.426  1.00 37.77           H 
ATOM   1204  HA  GLU    75     -10.323   4.408  -2.276  1.00 73.12           H 
ATOM   1205 3HB  GLU    75     -12.022   5.824  -1.714  1.00 37.77           H 
ATOM   1206 2HB  GLU    75     -10.787   6.361  -0.591  1.00 37.77           H 
ATOM   1207 3HG  GLU    75     -13.001   4.446   0.110  1.00 37.77           H 
ATOM   1208 2HG  GLU    75     -13.054   6.183   0.390  1.00 37.77           H 
ATOM   1209  N   GLU    76      -9.146   3.491   0.603  1.00 63.43           N 
ATOM   1210  CA  GLU    76      -7.869   3.292   1.320  1.00  4.41           C 
ATOM   1211  C   GLU    76      -6.981   2.247   0.615  1.00 44.32           C 
ATOM   1212  O   GLU    76      -5.985   1.789   1.180  1.00 31.13           O 
ATOM   1213  CB  GLU    76      -8.119   2.843   2.773  1.00 65.03           C 
ATOM   1214  CG  GLU    76      -8.795   3.887   3.663  1.00 54.24           C 
ATOM   1215  CD  GLU    76      -7.981   5.164   3.841  1.00 14.12           C 
ATOM   1216  OE1 GLU    76      -6.736   5.094   3.887  1.00  3.42           O 
ATOM   1217  OE2 GLU    76      -8.589   6.249   3.963  1.00 42.50           O 
ATOM   1218  H   GLU    76      -9.951   3.029   0.921  1.00 37.77           H 
ATOM   1219  HA  GLU    76      -7.345   4.237   1.334  1.00 64.50           H 
ATOM   1220 3HB  GLU    76      -7.168   2.585   3.221  1.00 37.77           H 
ATOM   1221 2HB  GLU    76      -8.744   1.961   2.760  1.00 37.77           H 
ATOM   1222 3HG  GLU    76      -8.961   3.449   4.638  1.00 37.77           H 
ATOM   1223 2HG  GLU    76      -9.747   4.145   3.224  1.00 37.77           H 
ATOM   1224  N   ALA    77      -7.340   1.878  -0.618  1.00 12.30           N 
ATOM   1225  CA  ALA    77      -6.594   0.865  -1.380  1.00 42.20           C 
ATOM   1226  C   ALA    77      -5.492   1.489  -2.259  1.00 65.14           C 
ATOM   1227  O   ALA    77      -5.654   2.586  -2.805  1.00 10.33           O 
ATOM   1228  CB  ALA    77      -7.552   0.042  -2.236  1.00 12.44           C 
ATOM   1229  H   ALA    77      -8.123   2.293  -1.029  1.00 37.77           H 
ATOM   1230  HA  ALA    77      -6.126   0.194  -0.668  1.00 54.43           H 
ATOM   1231 1HB  ALA    77      -7.969   0.669  -3.011  1.00 37.77           H 
ATOM   1232 2HB  ALA    77      -8.351  -0.342  -1.619  1.00 37.77           H 
ATOM   1233 3HB  ALA    77      -7.019  -0.782  -2.688  1.00 37.77           H 
ATOM   1234  N   ILE    78      -4.373   0.771  -2.383  1.00  5.01           N 
ATOM   1235  CA  ILE    78      -3.228   1.207  -3.192  1.00 44.14           C 
ATOM   1236  C   ILE    78      -2.954   0.218  -4.342  1.00 22.13           C 
ATOM   1237  O   ILE    78      -3.028  -1.000  -4.157  1.00  0.24           O 
ATOM   1238  CB  ILE    78      -1.930   1.325  -2.335  1.00 34.02           C 
ATOM   1239  CG1 ILE    78      -2.106   2.309  -1.161  1.00 55.34           C 
ATOM   1240  CG2 ILE    78      -0.741   1.743  -3.204  1.00 24.14           C 
ATOM   1241  CD1 ILE    78      -2.879   1.752   0.021  1.00  2.44           C 
ATOM   1242  H   ILE    78      -4.314  -0.080  -1.908  1.00 37.77           H 
ATOM   1243  HA  ILE    78      -3.451   2.180  -3.609  1.00 75.11           H 
ATOM   1244  HB  ILE    78      -1.714   0.341  -1.936  1.00 55.21           H 
ATOM   1245 3HG1 ILE    78      -2.627   3.190  -1.510  1.00 37.77           H 
ATOM   1246 2HG1 ILE    78      -1.131   2.601  -0.795  1.00 37.77           H 
ATOM   1247 1HG2 ILE    78       0.144   1.830  -2.588  1.00 37.77           H 
ATOM   1248 2HG2 ILE    78      -0.949   2.693  -3.671  1.00 37.77           H 
ATOM   1249 3HG2 ILE    78      -0.572   0.996  -3.969  1.00 37.77           H 
ATOM   1250 1HD1 ILE    78      -2.382   0.869   0.394  1.00 37.77           H 
ATOM   1251 2HD1 ILE    78      -3.881   1.496  -0.291  1.00 37.77           H 
ATOM   1252 3HD1 ILE    78      -2.928   2.496   0.802  1.00 37.77           H 
ATOM   1253  N   ALA    79      -2.639   0.738  -5.526  1.00 15.14           N 
ATOM   1254  CA  ALA    79      -2.224  -0.104  -6.651  1.00 73.34           C 
ATOM   1255  C   ALA    79      -0.697  -0.301  -6.658  1.00 54.11           C 
ATOM   1256  O   ALA    79       0.061   0.671  -6.666  1.00 24.43           O 
ATOM   1257  CB  ALA    79      -2.696   0.502  -7.968  1.00  2.31           C 
ATOM   1258  H   ALA    79      -2.698   1.709  -5.650  1.00 37.77           H 
ATOM   1259  HA  ALA    79      -2.699  -1.070  -6.538  1.00 72.32           H 
ATOM   1260 1HB  ALA    79      -2.226   1.464  -8.112  1.00 37.77           H 
ATOM   1261 2HB  ALA    79      -3.769   0.628  -7.942  1.00 37.77           H 
ATOM   1262 3HB  ALA    79      -2.431  -0.153  -8.787  1.00 37.77           H 
ATOM   1263  N   THR    80      -0.249  -1.559  -6.666  1.00  4.33           N 
ATOM   1264  CA  THR    80       1.195  -1.878  -6.639  1.00 13.21           C 
ATOM   1265  C   THR    80       1.947  -1.269  -7.833  1.00 34.14           C 
ATOM   1266  O   THR    80       3.151  -1.015  -7.761  1.00 21.40           O 
ATOM   1267  CB  THR    80       1.441  -3.410  -6.622  1.00 73.25           C 
ATOM   1268  OG1 THR    80       0.821  -4.027  -7.764  1.00 41.45           O 
ATOM   1269  CG2 THR    80       0.894  -4.044  -5.346  1.00 34.24           C 
ATOM   1270  H   THR    80      -0.898  -2.297  -6.690  1.00 37.77           H 
ATOM   1271  HA  THR    80       1.604  -1.464  -5.725  1.00 73.11           H 
ATOM   1272  HB  THR    80       2.507  -3.589  -6.666  1.00 13.33           H 
ATOM   1273  HG1 THR    80       1.048  -4.967  -7.781  1.00 44.43           H 
ATOM   1274 1HG2 THR    80      -0.173  -3.892  -5.295  1.00 37.77           H 
ATOM   1275 2HG2 THR    80       1.364  -3.587  -4.485  1.00 37.77           H 
ATOM   1276 3HG2 THR    80       1.108  -5.104  -5.348  1.00 37.77           H 
ATOM   1277  N   ILE    81       1.229  -1.030  -8.927  1.00 63.00           N 
ATOM   1278  CA  ILE    81       1.813  -0.438 -10.140  1.00 63.35           C 
ATOM   1279  C   ILE    81       2.241   1.029  -9.916  1.00 50.03           C 
ATOM   1280  O   ILE    81       3.022   1.590 -10.686  1.00 22.25           O 
ATOM   1281  CB  ILE    81       0.806  -0.514 -11.319  1.00 63.52           C 
ATOM   1282  CG1 ILE    81       1.447  -0.048 -12.641  1.00 24.13           C 
ATOM   1283  CG2 ILE    81      -0.447   0.308 -11.007  1.00 31.10           C 
ATOM   1284  CD1 ILE    81       2.621  -0.898 -13.089  1.00 43.43           C 
ATOM   1285  H   ILE    81       0.281  -1.270  -8.926  1.00 37.77           H 
ATOM   1286  HA  ILE    81       2.687  -1.017 -10.404  1.00 32.10           H 
ATOM   1287  HB  ILE    81       0.501  -1.547 -11.425  1.00 41.01           H 
ATOM   1288 3HG1 ILE    81       1.799   0.968 -12.521  1.00 37.77           H 
ATOM   1289 2HG1 ILE    81       0.707  -0.075 -13.424  1.00 37.77           H 
ATOM   1290 1HG2 ILE    81      -0.176   1.348 -10.884  1.00 37.77           H 
ATOM   1291 2HG2 ILE    81      -0.899  -0.055 -10.096  1.00 37.77           H 
ATOM   1292 3HG2 ILE    81      -1.153   0.216 -11.821  1.00 37.77           H 
ATOM   1293 1HD1 ILE    81       3.020  -0.503 -14.013  1.00 37.77           H 
ATOM   1294 2HD1 ILE    81       2.291  -1.914 -13.246  1.00 37.77           H 
ATOM   1295 3HD1 ILE    81       3.391  -0.882 -12.330  1.00 37.77           H 
ATOM   1296  N   GLN    82       1.724   1.644  -8.854  1.00 41.52           N 
ATOM   1297  CA  GLN    82       2.045   3.039  -8.531  1.00 64.31           C 
ATOM   1298  C   GLN    82       3.299   3.137  -7.638  1.00 61.24           C 
ATOM   1299  O   GLN    82       3.825   4.226  -7.392  1.00 52.43           O 
ATOM   1300  CB  GLN    82       0.836   3.701  -7.843  1.00 71.10           C 
ATOM   1301  CG  GLN    82       1.000   5.194  -7.573  1.00 32.43           C 
ATOM   1302  CD  GLN    82       1.272   6.006  -8.831  1.00 22.33           C 
ATOM   1303  OE1 GLN    82       0.848   5.645  -9.926  1.00  2.42           O 
ATOM   1304  NE2 GLN    82       1.974   7.110  -8.685  1.00 63.23           N 
ATOM   1305  H   GLN    82       1.109   1.150  -8.272  1.00 37.77           H 
ATOM   1306  HA  GLN    82       2.240   3.557  -9.459  1.00  2.24           H 
ATOM   1307 3HB  GLN    82       0.659   3.203  -6.898  1.00 37.77           H 
ATOM   1308 2HB  GLN    82      -0.035   3.567  -8.470  1.00 37.77           H 
ATOM   1309 3HG  GLN    82       1.823   5.331  -6.887  1.00 37.77           H 
ATOM   1310 2HG  GLN    82       0.093   5.564  -7.118  1.00 37.77           H 
ATOM   1311 1HE2 GLN    82       2.279   7.353  -7.785  1.00 37.77           H 
ATOM   1312 2HE2 GLN    82       2.167   7.640  -9.486  1.00 37.77           H 
ATOM   1313  N   ILE    83       3.784   1.992  -7.162  1.00 40.34           N 
ATOM   1314  CA  ILE    83       4.958   1.968  -6.287  1.00 43.32           C 
ATOM   1315  C   ILE    83       6.263   1.930  -7.102  1.00 41.45           C 
ATOM   1316  O   ILE    83       6.732   0.867  -7.510  1.00  4.20           O 
ATOM   1317  CB  ILE    83       4.918   0.760  -5.316  1.00 64.50           C 
ATOM   1318  CG1 ILE    83       3.587   0.738  -4.540  1.00  1.22           C 
ATOM   1319  CG2 ILE    83       6.106   0.804  -4.353  1.00 33.20           C 
ATOM   1320  CD1 ILE    83       3.315   1.994  -3.736  1.00 33.13           C 
ATOM   1321  H   ILE    83       3.352   1.147  -7.408  1.00 37.77           H 
ATOM   1322  HA  ILE    83       4.948   2.874  -5.694  1.00  1.02           H 
ATOM   1323  HB  ILE    83       4.997  -0.145  -5.902  1.00  0.15           H 
ATOM   1324 3HG1 ILE    83       3.591  -0.099  -3.857  1.00 37.77           H 
ATOM   1325 2HG1 ILE    83       2.775   0.615  -5.241  1.00 37.77           H 
ATOM   1326 1HG2 ILE    83       6.053  -0.036  -3.677  1.00 37.77           H 
ATOM   1327 2HG2 ILE    83       6.081   1.723  -3.787  1.00 37.77           H 
ATOM   1328 3HG2 ILE    83       7.030   0.752  -4.916  1.00 37.77           H 
ATOM   1329 1HD1 ILE    83       2.366   1.898  -3.229  1.00 37.77           H 
ATOM   1330 2HD1 ILE    83       3.282   2.847  -4.398  1.00 37.77           H 
ATOM   1331 3HD1 ILE    83       4.099   2.135  -3.008  1.00 37.77           H 
ATOM   1332  N   ALA    84       6.849   3.108  -7.320  1.00 62.23           N 
ATOM   1333  CA  ALA    84       8.081   3.246  -8.118  1.00 22.50           C 
ATOM   1334  C   ALA    84       9.326   2.665  -7.417  1.00 12.21           C 
ATOM   1335  O   ALA    84      10.454   2.901  -7.853  1.00 75.03           O 
ATOM   1336  CB  ALA    84       8.305   4.717  -8.453  1.00 51.53           C 
ATOM   1337  H   ALA    84       6.430   3.914  -6.959  1.00 37.77           H 
ATOM   1338  HA  ALA    84       7.932   2.716  -9.048  1.00 44.15           H 
ATOM   1339 1HB  ALA    84       8.463   5.275  -7.541  1.00 37.77           H 
ATOM   1340 2HB  ALA    84       7.441   5.106  -8.969  1.00 37.77           H 
ATOM   1341 3HB  ALA    84       9.174   4.813  -9.089  1.00 37.77           H 
ATOM   1342  N   ASN    85       9.124   1.907  -6.339  1.00 71.14           N 
ATOM   1343  CA  ASN    85      10.237   1.283  -5.605  1.00 32.24           C 
ATOM   1344  C   ASN    85      10.236  -0.250  -5.772  1.00 12.12           C 
ATOM   1345  O   ASN    85      11.046  -0.950  -5.167  1.00 32.41           O 
ATOM   1346  CB  ASN    85      10.165   1.660  -4.119  1.00  0.52           C 
ATOM   1347  CG  ASN    85      10.415   3.141  -3.888  1.00 45.11           C 
ATOM   1348  OD1 ASN    85      11.544   3.567  -3.672  1.00 43.23           O 
ATOM   1349  ND2 ASN    85       9.369   3.940  -3.934  1.00 73.35           N 
ATOM   1350  H   ASN    85       8.212   1.759  -6.030  1.00 37.77           H 
ATOM   1351  HA  ASN    85      11.160   1.665  -6.016  1.00 40.53           H 
ATOM   1352 3HB  ASN    85      10.909   1.098  -3.573  1.00 37.77           H 
ATOM   1353 2HB  ASN    85       9.182   1.416  -3.738  1.00 37.77           H 
ATOM   1354 1HD2 ASN    85       8.497   3.549  -4.113  1.00 37.77           H 
ATOM   1355 2HD2 ASN    85       9.522   4.897  -3.794  1.00 37.77           H 
ATOM   1356  N   PHE    86       9.324  -0.761  -6.598  1.00 24.23           N 
ATOM   1357  CA  PHE    86       9.263  -2.198  -6.895  1.00 41.53           C 
ATOM   1358  C   PHE    86      10.334  -2.608  -7.924  1.00 52.22           C 
ATOM   1359  O   PHE    86      10.609  -1.871  -8.876  1.00 30.42           O 
ATOM   1360  CB  PHE    86       7.859  -2.583  -7.402  1.00  3.41           C 
ATOM   1361  CG  PHE    86       6.924  -3.080  -6.323  1.00  2.11           C 
ATOM   1362  CD1 PHE    86       6.796  -2.399  -5.123  1.00 13.41           C 
ATOM   1363  CD2 PHE    86       6.175  -4.235  -6.512  1.00 41.54           C 
ATOM   1364  CE1 PHE    86       5.941  -2.854  -4.136  1.00 11.41           C 
ATOM   1365  CE2 PHE    86       5.319  -4.694  -5.527  1.00 64.53           C 
ATOM   1366  CZ  PHE    86       5.204  -4.003  -4.339  1.00 34.02           C 
ATOM   1367  H   PHE    86       8.678  -0.161  -7.023  1.00 37.77           H 
ATOM   1368  HA  PHE    86       9.457  -2.728  -5.971  1.00 51.22           H 
ATOM   1369 3HB  PHE    86       7.954  -3.360  -8.143  1.00 37.77           H 
ATOM   1370 2HB  PHE    86       7.403  -1.717  -7.858  1.00 37.77           H 
ATOM   1371  HD1 PHE    86       7.372  -1.498  -4.962  1.00 71.15           H 
ATOM   1372  HD2 PHE    86       6.265  -4.780  -7.441  1.00  4.41           H 
ATOM   1373  HE1 PHE    86       5.852  -2.311  -3.205  1.00  2.31           H 
ATOM   1374  HE2 PHE    86       4.743  -5.594  -5.687  1.00 42.13           H 
ATOM   1375  HZ  PHE    86       4.536  -4.361  -3.568  1.00  3.31           H 
END
