
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   97 ( 1483),  selected   97 , name 1bym_A
# Molecule2: number of CA atoms   74 ( 1189),  selected   74 , name T0462_1_74.pdb
# PARAMETERS: 1bym_A.T0462_1_74.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    I   132_A      -       -           -
LGA    P   133_A      -       -           -
LGA    G   134_A      -       -           -
LGA    L   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    L   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    G   141_A      -       -           -
LGA    N   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    D   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    A   146_A      -       -           -
LGA    A   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    T   150_A      M       1          0.308
LGA    R   151_A      K       2          0.919
LGA    V   152_A      L       3          1.307
LGA    I   153_A      S       4          1.499
LGA    D   154_A      R       5          2.090
LGA    A   155_A      L       6          1.601
LGA    A   156_A      V       7          3.094
LGA    T   157_A      -       -           -
LGA    S   158_A      -       -           -
LGA    M   159_A      P       8          3.550
LGA    P   160_A      G       9          2.485
LGA    R   161_A      V      10          2.199
LGA    K   162_A      P      11          1.743
LGA    V   163_A      A      12          1.755
LGA    R   164_A      R      13          2.454
LGA    I   165_A      I      14          1.643
LGA    V   166_A      K      15          0.963
LGA    Q   167_A      R      16          0.599
LGA    I   168_A      L      17          1.064
LGA    N   169_A      E      18          2.674
LGA    E   170_A      V      19          1.749
LGA    I   171_A      S      20           #
LGA    F   172_A      -       -           -
LGA    Q   173_A      -       -           -
LGA    V   174_A      -       -           -
LGA    E   175_A      G      21           #
LGA    T   176_A      E      22          4.032
LGA    D   177_A      L      23          5.158
LGA    Q   178_A      H      24           -
LGA    F   179_A      E      25           #
LGA    T   180_A      K      26          1.834
LGA    Q   181_A      -       -           -
LGA    L   182_A      L      27          2.210
LGA    L   183_A      V      28          1.895
LGA    D   184_A      G      29          2.296
LGA    A   185_A      M      30          3.531
LGA    D   186_A      G      31          4.931
LGA    I   187_A      F      32          4.072
LGA    R   188_A      V      33          1.665
LGA    V   189_A      P      34          3.949
LGA    G   190_A      G      35           #
LGA    S   191_A      E      36          0.830
LGA    E   192_A      E      37          0.644
LGA    V   193_A      I      38          1.908
LGA    E   194_A      E      39          0.931
LGA    I   195_A      I      40          1.659
LGA    -       -      V      41           -
LGA    V   196_A      Q      42          3.286
LGA    D   197_A      V      43          2.697
LGA    R   198_A      A      44          2.192
LGA    D   199_A      P      45          2.255
LGA    -       -      L      46           -
LGA    G   200_A      G      47          1.176
LGA    H   201_A      D      48          1.349
LGA    I   202_A      P      49          3.745
LGA    -       -      I      50           -
LGA    T   203_A      V      51          1.572
LGA    L   204_A      C      52          1.345
LGA    S   205_A      K      53          1.333
LGA    H   206_A      I      54          2.805
LGA    N   207_A      G      55          4.975
LGA    G   208_A      N      56          1.520
LGA    K   209_A      R      57          1.458
LGA    D   210_A      N      58          1.383
LGA    V   211_A      I      59          0.359
LGA    E   212_A      T      60          0.503
LGA    L   213_A      L      61          1.095
LGA    L   214_A      R      62          0.833
LGA    D   215_A      K      63          1.139
LGA    D   216_A      R      64          1.197
LGA    L   217_A      E      65          1.148
LGA    A   218_A      A      66          0.751
LGA    H   219_A      D      67          0.795
LGA    T   220_A      L      68          1.177
LGA    I   221_A      I      69          1.360
LGA    R   222_A      E      70          0.718
LGA    I   223_A      V      71          0.595
LGA    E   224_A      E      72          1.391
LGA    E   225_A      V      73          1.040
LGA    L   226_A      V      74          1.536

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   97   74    5.0     66    2.20    16.67     64.033     2.868

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.583207 * X  +   0.760391 * Y  +   0.285789 * Z  +  11.327766
  Y_new =   0.336891 * X  +  -0.546542 * Y  +   0.766679 * Z  +   0.011223
  Z_new =   0.739171 * X  +  -0.350852 * Y  +  -0.574916 * Z  +  -5.343948 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.593658    0.547935  [ DEG:  -148.6057     31.3944 ]
  Theta =  -0.831839   -2.309753  [ DEG:   -47.6609   -132.3391 ]
  Phi   =   0.523826   -2.617767  [ DEG:    30.0130   -149.9870 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1bym_A                                        
REMARK     2: T0462_1_74.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1bym_A.T0462_1_74.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   97   74   5.0   66   2.20   16.67  64.033
REMARK  ---------------------------------------------------------- 
MOLECULE 1bym_A
HEADER    GENE REGULATION                         17-OCT-98   1BYM              
TITLE     SOLUTION STRUCTURES OF THE C-TERMINAL DOMAIN OF DIPHTHERIA            
TITLE    2 TOXIN REPRESSOR                                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (DIPHTHERIA TOXIN REPRESSOR);                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 130-226;                                          
COMPND   5 SYNONYM: DTXR(130-226);                                              
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM DIPHTHERIAE;                    
SOURCE   3 GENE: DTXR;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: HMS-174;                                   
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PQE-31;                                    
SOURCE   7 OTHER_DETAILS: SWS P33120                                            
KEYWDS    REPRESSOR, DTXR, C-TERMINAL DOMAIN, PROKARYOTIC SH3 DOMAIN,           
KEYWDS   2 TRANSCRIPTION REGULATION, PEPTIDE-BINDING                            
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    G.WANG,G.P.WYLIE,P.D.TWIGG,D.L.D.CASPAR,J.R.MURPHY,T.M.LOGAN          
REVDAT   3   01-APR-03 1BYM    1       JRNL                                     
REVDAT   2   22-DEC-99 1BYM    4       HEADER COMPND REMARK JRNL                
REVDAT   2 2                   4       ATOM   SOURCE SEQRES                     
REVDAT   1   21-OCT-98 1BYM    0                                                
JRNL        AUTH   G.WANG,G.P.WYLIE,P.D.TWIGG,D.L.CASPAR,J.R.MURPHY,            
JRNL        AUTH 2 T.M.LOGAN                                                    
JRNL        TITL   SOLUTION STRUCTURE AND PEPTIDE BINDING STUDIES OF            
JRNL        TITL 2 THE C-TERMINAL SRC HOMOLOGY 3-LIKE DOMAIN OF THE             
JRNL        TITL 3 DIPHTHERIA TOXIN REPRESSOR PROTEIN.                          
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V.  96  6119 1999              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1BYM A  130   226  UNP    P33120   DTXR_CORDI     130    226             
SEQRES   1 A   97  ASN PRO ILE PRO GLY LEU ASP GLU LEU GLY VAL GLY ASN          
SEQRES   2 A   97  SER ASP ALA ALA ALA PRO GLY THR ARG VAL ILE ASP ALA          
SEQRES   3 A   97  ALA THR SER MET PRO ARG LYS VAL ARG ILE VAL GLN ILE          
SEQRES   4 A   97  ASN GLU ILE PHE GLN VAL GLU THR ASP GLN PHE THR GLN          
SEQRES   5 A   97  LEU LEU ASP ALA ASP ILE ARG VAL GLY SER GLU VAL GLU          
SEQRES   6 A   97  ILE VAL ASP ARG ASP GLY HIS ILE THR LEU SER HIS ASN          
SEQRES   7 A   97  GLY LYS ASP VAL GLU LEU LEU ASP ASP LEU ALA HIS THR          
SEQRES   8 A   97  ILE ARG ILE GLU GLU LEU                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ASN A 130     -26.558  -6.934 -12.926  1.00  0.00           N  
ATOM      2  CA  ASN A 130     -26.730  -8.027 -11.926  1.00  0.00           C  
ATOM      3  C   ASN A 130     -27.988  -7.786 -11.089  1.00  0.00           C  
ATOM      4  O   ASN A 130     -27.949  -7.091 -10.094  1.00  0.00           O  
ATOM      5  CB  ASN A 130     -25.479  -7.958 -11.048  1.00  0.00           C  
ATOM      6  CG  ASN A 130     -25.252  -6.514 -10.594  1.00  0.00           C  
ATOM      7  OD1 ASN A 130     -26.104  -5.667 -10.776  1.00  0.00           O  
ATOM      8  ND2 ASN A 130     -24.129  -6.197 -10.008  1.00  0.00           N  
ATOM      9  HA  ASN A 130     -26.781  -8.983 -12.420  1.00  0.00           H  
ATOM     10  HB2 ASN A 130     -25.612  -8.590 -10.183  1.00  0.00           H  
ATOM     11  HB3 ASN A 130     -24.624  -8.294 -11.614  1.00  0.00           H  
ATOM     12 HD21 ASN A 130     -23.443  -6.880  -9.864  1.00  0.00           H  
ATOM     13 HD22 ASN A 130     -23.975  -5.274  -9.716  1.00  0.00           H  
ATOM     14  H1  ASN A 130     -26.601  -6.013 -12.445  1.00  0.00           H  
ATOM     15  H2  ASN A 130     -25.637  -7.034 -13.397  1.00  0.00           H  
ATOM     16  H3  ASN A 130     -27.319  -6.991 -13.636  1.00  0.00           H  
ATOM     17  N   PRO A 131     -29.068  -8.374 -11.527  1.00  0.00           N  
ATOM     18  CA  PRO A 131     -30.360  -8.227 -10.812  1.00  0.00           C  
ATOM     19  C   PRO A 131     -30.346  -9.033  -9.512  1.00  0.00           C  
ATOM     20  O   PRO A 131     -30.688  -8.535  -8.457  1.00  0.00           O  
ATOM     21  CB  PRO A 131     -31.378  -8.798 -11.796  1.00  0.00           C  
ATOM     22  CG  PRO A 131     -30.600  -9.741 -12.657  1.00  0.00           C  
ATOM     23  CD  PRO A 131     -29.185  -9.224 -12.717  1.00  0.00           C  
ATOM     24  HA  PRO A 131     -30.574  -7.189 -10.618  1.00  0.00           H  
ATOM     25  HB2 PRO A 131     -32.158  -9.325 -11.262  1.00  0.00           H  
ATOM     26  HB3 PRO A 131     -31.801  -8.010 -12.401  1.00  0.00           H  
ATOM     27  HG2 PRO A 131     -30.615 -10.732 -12.224  1.00  0.00           H  
ATOM     28  HG3 PRO A 131     -31.019  -9.766 -13.651  1.00  0.00           H  
ATOM     29  HD2 PRO A 131     -28.482 -10.045 -12.671  1.00  0.00           H  
ATOM     30  HD3 PRO A 131     -29.033  -8.638 -13.608  1.00  0.00           H  
ATOM     31  N   ILE A 132     -29.954 -10.277  -9.576  1.00  0.00           N  
ATOM     32  CA  ILE A 132     -29.920 -11.113  -8.343  1.00  0.00           C  
ATOM     33  C   ILE A 132     -29.035 -10.454  -7.281  1.00  0.00           C  
ATOM     34  O   ILE A 132     -28.161  -9.673  -7.598  1.00  0.00           O  
ATOM     35  CB  ILE A 132     -29.319 -12.447  -8.788  1.00  0.00           C  
ATOM     36  CG1 ILE A 132     -28.089 -12.187  -9.660  1.00  0.00           C  
ATOM     37  CG2 ILE A 132     -30.357 -13.232  -9.593  1.00  0.00           C  
ATOM     38  CD1 ILE A 132     -26.939 -13.087  -9.203  1.00  0.00           C  
ATOM     39  H   ILE A 132     -29.683 -10.660 -10.437  1.00  0.00           H  
ATOM     40  HA  ILE A 132     -30.917 -11.266  -7.962  1.00  0.00           H  
ATOM     41  HB  ILE A 132     -29.033 -13.019  -7.918  1.00  0.00           H  
ATOM     42 HG12 ILE A 132     -28.327 -12.402 -10.692  1.00  0.00           H  
ATOM     43 HG13 ILE A 132     -27.793 -11.153  -9.565  1.00  0.00           H  
ATOM     44 HG21 ILE A 132     -31.349 -12.918  -9.305  1.00  0.00           H  
ATOM     45 HG22 ILE A 132     -30.211 -13.043 -10.646  1.00  0.00           H  
ATOM     46 HG23 ILE A 132     -30.242 -14.287  -9.398  1.00  0.00           H  
ATOM     47 HD11 ILE A 132     -27.334 -14.038  -8.878  1.00  0.00           H  
ATOM     48 HD12 ILE A 132     -26.256 -13.244 -10.025  1.00  0.00           H  
ATOM     49 HD13 ILE A 132     -26.416 -12.615  -8.385  1.00  0.00           H  
ATOM     50  N   PRO A 133     -29.297 -10.796  -6.050  1.00  0.00           N  
ATOM     51  CA  PRO A 133     -28.517 -10.233  -4.919  1.00  0.00           C  
ATOM     52  C   PRO A 133     -27.114 -10.845  -4.883  1.00  0.00           C  
ATOM     53  O   PRO A 133     -26.687 -11.503  -5.810  1.00  0.00           O  
ATOM     54  CB  PRO A 133     -29.323 -10.645  -3.690  1.00  0.00           C  
ATOM     55  CG  PRO A 133     -30.089 -11.858  -4.114  1.00  0.00           C  
ATOM     56  CD  PRO A 133     -30.332 -11.730  -5.597  1.00  0.00           C  
ATOM     57  HA  PRO A 133     -28.466  -9.160  -4.987  1.00  0.00           H  
ATOM     58  HB2 PRO A 133     -28.659 -10.882  -2.870  1.00  0.00           H  
ATOM     59  HB3 PRO A 133     -30.005  -9.858  -3.407  1.00  0.00           H  
ATOM     60  HG2 PRO A 133     -29.509 -12.748  -3.909  1.00  0.00           H  
ATOM     61  HG3 PRO A 133     -31.032 -11.900  -3.593  1.00  0.00           H  
ATOM     62  HD2 PRO A 133     -30.220 -12.690  -6.081  1.00  0.00           H  
ATOM     63  HD3 PRO A 133     -31.312 -11.320  -5.786  1.00  0.00           H  
ATOM     64  N   GLY A 134     -26.391 -10.631  -3.816  1.00  0.00           N  
ATOM     65  CA  GLY A 134     -25.017 -11.198  -3.721  1.00  0.00           C  
ATOM     66  C   GLY A 134     -24.936 -12.143  -2.521  1.00  0.00           C  
ATOM     67  O   GLY A 134     -25.800 -12.152  -1.666  1.00  0.00           O  
ATOM     68  H   GLY A 134     -26.753 -10.097  -3.079  1.00  0.00           H  
ATOM     69  HA2 GLY A 134     -24.789 -11.744  -4.627  1.00  0.00           H  
ATOM     70  HA3 GLY A 134     -24.304 -10.398  -3.594  1.00  0.00           H  
ATOM     71  N   LEU A 135     -23.903 -12.938  -2.448  1.00  0.00           N  
ATOM     72  CA  LEU A 135     -23.767 -13.881  -1.301  1.00  0.00           C  
ATOM     73  C   LEU A 135     -23.239 -13.142  -0.068  1.00  0.00           C  
ATOM     74  O   LEU A 135     -22.964 -11.959  -0.113  1.00  0.00           O  
ATOM     75  CB  LEU A 135     -22.760 -14.933  -1.770  1.00  0.00           C  
ATOM     76  CG  LEU A 135     -21.397 -14.275  -1.982  1.00  0.00           C  
ATOM     77  CD1 LEU A 135     -20.315 -15.105  -1.290  1.00  0.00           C  
ATOM     78  CD2 LEU A 135     -21.097 -14.198  -3.482  1.00  0.00           C  
ATOM     79  H   LEU A 135     -23.217 -12.916  -3.147  1.00  0.00           H  
ATOM     80  HA  LEU A 135     -24.715 -14.349  -1.083  1.00  0.00           H  
ATOM     81  HB2 LEU A 135     -22.674 -15.707  -1.021  1.00  0.00           H  
ATOM     82  HB3 LEU A 135     -23.099 -15.366  -2.699  1.00  0.00           H  
ATOM     83  HG  LEU A 135     -21.408 -13.278  -1.564  1.00  0.00           H  
ATOM     84 HD11 LEU A 135     -20.670 -15.422  -0.321  1.00  0.00           H  
ATOM     85 HD12 LEU A 135     -20.087 -15.972  -1.892  1.00  0.00           H  
ATOM     86 HD13 LEU A 135     -19.424 -14.506  -1.169  1.00  0.00           H  
ATOM     87 HD21 LEU A 135     -22.026 -14.167  -4.032  1.00  0.00           H  
ATOM     88 HD22 LEU A 135     -20.526 -13.305  -3.690  1.00  0.00           H  
ATOM     89 HD23 LEU A 135     -20.530 -15.067  -3.780  1.00  0.00           H  
ATOM     90  N   ASP A 136     -23.094 -13.831   1.030  1.00  0.00           N  
ATOM     91  CA  ASP A 136     -22.582 -13.170   2.265  1.00  0.00           C  
ATOM     92  C   ASP A 136     -21.856 -14.187   3.148  1.00  0.00           C  
ATOM     93  O   ASP A 136     -22.068 -14.249   4.342  1.00  0.00           O  
ATOM     94  CB  ASP A 136     -23.827 -12.635   2.973  1.00  0.00           C  
ATOM     95  CG  ASP A 136     -24.880 -13.743   3.059  1.00  0.00           C  
ATOM     96  OD1 ASP A 136     -25.570 -13.956   2.076  1.00  0.00           O  
ATOM     97  OD2 ASP A 136     -24.979 -14.358   4.108  1.00  0.00           O  
ATOM     98  H   ASP A 136     -23.322 -14.785   1.045  1.00  0.00           H  
ATOM     99  HA  ASP A 136     -21.925 -12.352   2.010  1.00  0.00           H  
ATOM    100  HB2 ASP A 136     -23.564 -12.311   3.969  1.00  0.00           H  
ATOM    101  HB3 ASP A 136     -24.230 -11.802   2.417  1.00  0.00           H  
ATOM    102  N   GLU A 137     -21.002 -14.986   2.569  1.00  0.00           N  
ATOM    103  CA  GLU A 137     -20.264 -15.999   3.377  1.00  0.00           C  
ATOM    104  C   GLU A 137     -18.827 -15.533   3.627  1.00  0.00           C  
ATOM    105  O   GLU A 137     -17.922 -16.331   3.773  1.00  0.00           O  
ATOM    106  CB  GLU A 137     -20.274 -17.269   2.524  1.00  0.00           C  
ATOM    107  CG  GLU A 137     -20.282 -18.497   3.437  1.00  0.00           C  
ATOM    108  CD  GLU A 137     -20.591 -19.747   2.609  1.00  0.00           C  
ATOM    109  OE1 GLU A 137     -19.897 -19.971   1.630  1.00  0.00           O  
ATOM    110  OE2 GLU A 137     -21.515 -20.458   2.968  1.00  0.00           O  
ATOM    111  H   GLU A 137     -20.845 -14.920   1.604  1.00  0.00           H  
ATOM    112  HA  GLU A 137     -20.771 -16.179   4.311  1.00  0.00           H  
ATOM    113  HB2 GLU A 137     -21.157 -17.276   1.901  1.00  0.00           H  
ATOM    114  HB3 GLU A 137     -19.393 -17.292   1.902  1.00  0.00           H  
ATOM    115  HG2 GLU A 137     -19.314 -18.604   3.904  1.00  0.00           H  
ATOM    116  HG3 GLU A 137     -21.038 -18.376   4.197  1.00  0.00           H  
ATOM    117  N   LEU A 138     -18.611 -14.248   3.680  1.00  0.00           N  
ATOM    118  CA  LEU A 138     -17.232 -13.733   3.920  1.00  0.00           C  
ATOM    119  C   LEU A 138     -17.014 -13.488   5.416  1.00  0.00           C  
ATOM    120  O   LEU A 138     -17.875 -12.974   6.104  1.00  0.00           O  
ATOM    121  CB  LEU A 138     -17.159 -12.417   3.145  1.00  0.00           C  
ATOM    122  CG  LEU A 138     -15.934 -12.432   2.230  1.00  0.00           C  
ATOM    123  CD1 LEU A 138     -14.667 -12.576   3.074  1.00  0.00           C  
ATOM    124  CD2 LEU A 138     -16.037 -13.612   1.260  1.00  0.00           C  
ATOM    125  H   LEU A 138     -19.354 -13.620   3.559  1.00  0.00           H  
ATOM    126  HA  LEU A 138     -16.499 -14.426   3.541  1.00  0.00           H  
ATOM    127  HB2 LEU A 138     -18.054 -12.301   2.549  1.00  0.00           H  
ATOM    128  HB3 LEU A 138     -17.078 -11.595   3.838  1.00  0.00           H  
ATOM    129  HG  LEU A 138     -15.891 -11.508   1.670  1.00  0.00           H  
ATOM    130 HD11 LEU A 138     -14.599 -11.748   3.765  1.00  0.00           H  
ATOM    131 HD12 LEU A 138     -14.706 -13.504   3.627  1.00  0.00           H  
ATOM    132 HD13 LEU A 138     -13.801 -12.579   2.428  1.00  0.00           H  
ATOM    133 HD21 LEU A 138     -16.880 -14.230   1.532  1.00  0.00           H  
ATOM    134 HD22 LEU A 138     -16.171 -13.243   0.255  1.00  0.00           H  
ATOM    135 HD23 LEU A 138     -15.131 -14.199   1.311  1.00  0.00           H  
ATOM    136  N   GLY A 139     -15.869 -13.850   5.925  1.00  0.00           N  
ATOM    137  CA  GLY A 139     -15.595 -13.637   7.375  1.00  0.00           C  
ATOM    138  C   GLY A 139     -14.308 -12.827   7.539  1.00  0.00           C  
ATOM    139  O   GLY A 139     -13.446 -12.832   6.682  1.00  0.00           O  
ATOM    140  H   GLY A 139     -15.186 -14.263   5.353  1.00  0.00           H  
ATOM    141  HA2 GLY A 139     -16.421 -13.100   7.820  1.00  0.00           H  
ATOM    142  HA3 GLY A 139     -15.480 -14.592   7.863  1.00  0.00           H  
ATOM    143  N   VAL A 140     -14.171 -12.130   8.634  1.00  0.00           N  
ATOM    144  CA  VAL A 140     -12.938 -11.319   8.852  1.00  0.00           C  
ATOM    145  C   VAL A 140     -12.724 -10.357   7.681  1.00  0.00           C  
ATOM    146  O   VAL A 140     -12.247 -10.738   6.630  1.00  0.00           O  
ATOM    147  CB  VAL A 140     -11.801 -12.338   8.922  1.00  0.00           C  
ATOM    148  CG1 VAL A 140     -10.457 -11.613   8.816  1.00  0.00           C  
ATOM    149  CG2 VAL A 140     -11.870 -13.086  10.257  1.00  0.00           C  
ATOM    150  H   VAL A 140     -14.877 -12.139   9.313  1.00  0.00           H  
ATOM    151  HA  VAL A 140     -13.004 -10.775   9.780  1.00  0.00           H  
ATOM    152  HB  VAL A 140     -11.896 -13.041   8.108  1.00  0.00           H  
ATOM    153 HG11 VAL A 140     -10.373 -10.891   9.615  1.00  0.00           H  
ATOM    154 HG12 VAL A 140      -9.654 -12.331   8.893  1.00  0.00           H  
ATOM    155 HG13 VAL A 140     -10.397 -11.106   7.865  1.00  0.00           H  
ATOM    156 HG21 VAL A 140     -11.888 -12.373  11.068  1.00  0.00           H  
ATOM    157 HG22 VAL A 140     -12.767 -13.688  10.285  1.00  0.00           H  
ATOM    158 HG23 VAL A 140     -11.005 -13.723  10.357  1.00  0.00           H  
ATOM    159  N   GLY A 141     -13.074  -9.112   7.851  1.00  0.00           N  
ATOM    160  CA  GLY A 141     -12.889  -8.128   6.747  1.00  0.00           C  
ATOM    161  C   GLY A 141     -11.858  -7.079   7.163  1.00  0.00           C  
ATOM    162  O   GLY A 141     -10.909  -6.809   6.452  1.00  0.00           O  
ATOM    163  H   GLY A 141     -13.458  -8.823   8.706  1.00  0.00           H  
ATOM    164  HA2 GLY A 141     -12.545  -8.643   5.861  1.00  0.00           H  
ATOM    165  HA3 GLY A 141     -13.829  -7.640   6.538  1.00  0.00           H  
ATOM    166  N   ASN A 142     -12.033  -6.483   8.311  1.00  0.00           N  
ATOM    167  CA  ASN A 142     -11.062  -5.450   8.771  1.00  0.00           C  
ATOM    168  C   ASN A 142     -10.845  -4.402   7.678  1.00  0.00           C  
ATOM    169  O   ASN A 142     -11.560  -4.360   6.695  1.00  0.00           O  
ATOM    170  CB  ASN A 142      -9.766  -6.218   9.042  1.00  0.00           C  
ATOM    171  CG  ASN A 142      -9.767  -6.728  10.483  1.00  0.00           C  
ATOM    172  OD1 ASN A 142     -10.754  -7.259  10.952  1.00  0.00           O  
ATOM    173  ND2 ASN A 142      -8.693  -6.591  11.212  1.00  0.00           N  
ATOM    174  H   ASN A 142     -12.804  -6.714   8.870  1.00  0.00           H  
ATOM    175  HA  ASN A 142     -11.408  -4.984   9.679  1.00  0.00           H  
ATOM    176  HB2 ASN A 142      -9.696  -7.055   8.362  1.00  0.00           H  
ATOM    177  HB3 ASN A 142      -8.921  -5.561   8.894  1.00  0.00           H  
ATOM    178 HD21 ASN A 142      -7.896  -6.163  10.834  1.00  0.00           H  
ATOM    179 HD22 ASN A 142      -8.683  -6.915  12.137  1.00  0.00           H  
ATOM    180  N   SER A 143      -9.866  -3.555   7.839  1.00  0.00           N  
ATOM    181  CA  SER A 143      -9.606  -2.509   6.809  1.00  0.00           C  
ATOM    182  C   SER A 143      -8.191  -2.664   6.245  1.00  0.00           C  
ATOM    183  O   SER A 143      -7.218  -2.653   6.972  1.00  0.00           O  
ATOM    184  CB  SER A 143      -9.745  -1.180   7.549  1.00  0.00           C  
ATOM    185  OG  SER A 143     -10.073  -0.157   6.618  1.00  0.00           O  
ATOM    186  H   SER A 143      -9.302  -3.605   8.640  1.00  0.00           H  
ATOM    187  HA  SER A 143     -10.336  -2.570   6.018  1.00  0.00           H  
ATOM    188  HB2 SER A 143     -10.529  -1.255   8.283  1.00  0.00           H  
ATOM    189  HB3 SER A 143      -8.813  -0.946   8.045  1.00  0.00           H  
ATOM    190  HG  SER A 143      -9.268   0.096   6.160  1.00  0.00           H  
ATOM    191  N   ASP A 144      -8.069  -2.809   4.954  1.00  0.00           N  
ATOM    192  CA  ASP A 144      -6.717  -2.965   4.345  1.00  0.00           C  
ATOM    193  C   ASP A 144      -6.006  -4.182   4.942  1.00  0.00           C  
ATOM    194  O   ASP A 144      -6.606  -4.995   5.617  1.00  0.00           O  
ATOM    195  CB  ASP A 144      -5.971  -1.678   4.704  1.00  0.00           C  
ATOM    196  CG  ASP A 144      -5.984  -0.730   3.505  1.00  0.00           C  
ATOM    197  OD1 ASP A 144      -5.769  -1.200   2.400  1.00  0.00           O  
ATOM    198  OD2 ASP A 144      -6.207   0.452   3.712  1.00  0.00           O  
ATOM    199  H   ASP A 144      -8.866  -2.816   4.383  1.00  0.00           H  
ATOM    200  HA  ASP A 144      -6.794  -3.060   3.274  1.00  0.00           H  
ATOM    201  HB2 ASP A 144      -6.457  -1.205   5.545  1.00  0.00           H  
ATOM    202  HB3 ASP A 144      -4.951  -1.915   4.964  1.00  0.00           H  
ATOM    203  N   ALA A 145      -4.731  -4.315   4.699  1.00  0.00           N  
ATOM    204  CA  ALA A 145      -3.983  -5.480   5.253  1.00  0.00           C  
ATOM    205  C   ALA A 145      -4.785  -6.769   5.049  1.00  0.00           C  
ATOM    206  O   ALA A 145      -5.507  -7.207   5.921  1.00  0.00           O  
ATOM    207  CB  ALA A 145      -3.825  -5.177   6.744  1.00  0.00           C  
ATOM    208  H   ALA A 145      -4.264  -3.648   4.153  1.00  0.00           H  
ATOM    209  HA  ALA A 145      -3.014  -5.561   4.790  1.00  0.00           H  
ATOM    210  HB1 ALA A 145      -4.053  -4.137   6.926  1.00  0.00           H  
ATOM    211  HB2 ALA A 145      -4.504  -5.799   7.310  1.00  0.00           H  
ATOM    212  HB3 ALA A 145      -2.810  -5.383   7.048  1.00  0.00           H  
ATOM    213  N   ALA A 146      -4.663  -7.377   3.900  1.00  0.00           N  
ATOM    214  CA  ALA A 146      -5.421  -8.636   3.642  1.00  0.00           C  
ATOM    215  C   ALA A 146      -4.450  -9.792   3.386  1.00  0.00           C  
ATOM    216  O   ALA A 146      -4.852 -10.923   3.199  1.00  0.00           O  
ATOM    217  CB  ALA A 146      -6.251  -8.348   2.391  1.00  0.00           C  
ATOM    218  H   ALA A 146      -4.076  -7.007   3.209  1.00  0.00           H  
ATOM    219  HA  ALA A 146      -6.070  -8.864   4.471  1.00  0.00           H  
ATOM    220  HB1 ALA A 146      -5.605  -7.994   1.602  1.00  0.00           H  
ATOM    221  HB2 ALA A 146      -6.749  -9.251   2.072  1.00  0.00           H  
ATOM    222  HB3 ALA A 146      -6.989  -7.591   2.616  1.00  0.00           H  
ATOM    223  N   ALA A 147      -3.174  -9.518   3.377  1.00  0.00           N  
ATOM    224  CA  ALA A 147      -2.180 -10.602   3.135  1.00  0.00           C  
ATOM    225  C   ALA A 147      -0.769 -10.110   3.470  1.00  0.00           C  
ATOM    226  O   ALA A 147      -0.471  -8.939   3.335  1.00  0.00           O  
ATOM    227  CB  ALA A 147      -2.298 -10.923   1.645  1.00  0.00           C  
ATOM    228  H   ALA A 147      -2.869  -8.599   3.530  1.00  0.00           H  
ATOM    229  HA  ALA A 147      -2.423 -11.475   3.720  1.00  0.00           H  
ATOM    230  HB1 ALA A 147      -3.241 -10.552   1.272  1.00  0.00           H  
ATOM    231  HB2 ALA A 147      -1.487 -10.448   1.110  1.00  0.00           H  
ATOM    232  HB3 ALA A 147      -2.248 -11.991   1.501  1.00  0.00           H  
ATOM    233  N   PRO A 148       0.053 -11.028   3.897  1.00  0.00           N  
ATOM    234  CA  PRO A 148       1.453 -10.690   4.258  1.00  0.00           C  
ATOM    235  C   PRO A 148       2.281 -10.417   2.999  1.00  0.00           C  
ATOM    236  O   PRO A 148       3.003 -11.270   2.522  1.00  0.00           O  
ATOM    237  CB  PRO A 148       1.948 -11.945   4.973  1.00  0.00           C  
ATOM    238  CG  PRO A 148       1.094 -13.054   4.448  1.00  0.00           C  
ATOM    239  CD  PRO A 148      -0.239 -12.453   4.082  1.00  0.00           C  
ATOM    240  HA  PRO A 148       1.482  -9.847   4.927  1.00  0.00           H  
ATOM    241  HB2 PRO A 148       2.990 -12.123   4.737  1.00  0.00           H  
ATOM    242  HB3 PRO A 148       1.814 -11.849   6.039  1.00  0.00           H  
ATOM    243  HG2 PRO A 148       1.556 -13.493   3.574  1.00  0.00           H  
ATOM    244  HG3 PRO A 148       0.956 -13.806   5.209  1.00  0.00           H  
ATOM    245  HD2 PRO A 148      -0.611 -12.890   3.166  1.00  0.00           H  
ATOM    246  HD3 PRO A 148      -0.948 -12.586   4.884  1.00  0.00           H  
ATOM    247  N   GLY A 149       2.179  -9.235   2.457  1.00  0.00           N  
ATOM    248  CA  GLY A 149       2.962  -8.908   1.229  1.00  0.00           C  
ATOM    249  C   GLY A 149       2.245  -7.807   0.445  1.00  0.00           C  
ATOM    250  O   GLY A 149       1.069  -7.903   0.156  1.00  0.00           O  
ATOM    251  H   GLY A 149       1.591  -8.561   2.856  1.00  0.00           H  
ATOM    252  HA2 GLY A 149       3.947  -8.566   1.512  1.00  0.00           H  
ATOM    253  HA3 GLY A 149       3.048  -9.788   0.612  1.00  0.00           H  
ATOM    254  N   THR A 150       2.943  -6.760   0.099  1.00  0.00           N  
ATOM    255  CA  THR A 150       2.298  -5.655  -0.666  1.00  0.00           C  
ATOM    256  C   THR A 150       3.269  -5.086  -1.707  1.00  0.00           C  
ATOM    257  O   THR A 150       2.975  -4.114  -2.373  1.00  0.00           O  
ATOM    258  CB  THR A 150       1.959  -4.595   0.384  1.00  0.00           C  
ATOM    259  OG1 THR A 150       1.240  -5.200   1.449  1.00  0.00           O  
ATOM    260  CG2 THR A 150       1.104  -3.498  -0.254  1.00  0.00           C  
ATOM    261  H   THR A 150       3.890  -6.701   0.342  1.00  0.00           H  
ATOM    262  HA  THR A 150       1.396  -6.002  -1.143  1.00  0.00           H  
ATOM    263  HB  THR A 150       2.870  -4.160   0.764  1.00  0.00           H  
ATOM    264  HG1 THR A 150       1.839  -5.786   1.916  1.00  0.00           H  
ATOM    265 HG21 THR A 150       0.707  -3.851  -1.194  1.00  0.00           H  
ATOM    266 HG22 THR A 150       0.289  -3.246   0.409  1.00  0.00           H  
ATOM    267 HG23 THR A 150       1.712  -2.623  -0.426  1.00  0.00           H  
ATOM    268  N   ARG A 151       4.421  -5.683  -1.851  1.00  0.00           N  
ATOM    269  CA  ARG A 151       5.409  -5.176  -2.847  1.00  0.00           C  
ATOM    270  C   ARG A 151       5.768  -3.718  -2.547  1.00  0.00           C  
ATOM    271  O   ARG A 151       4.912  -2.906  -2.260  1.00  0.00           O  
ATOM    272  CB  ARG A 151       4.703  -5.289  -4.201  1.00  0.00           C  
ATOM    273  CG  ARG A 151       4.815  -6.724  -4.717  1.00  0.00           C  
ATOM    274  CD  ARG A 151       3.762  -7.597  -4.031  1.00  0.00           C  
ATOM    275  NE  ARG A 151       2.812  -7.976  -5.113  1.00  0.00           N  
ATOM    276  CZ  ARG A 151       1.562  -7.606  -5.043  1.00  0.00           C  
ATOM    277  NH1 ARG A 151       0.704  -8.333  -4.383  1.00  0.00           N  
ATOM    278  NH2 ARG A 151       1.173  -6.510  -5.634  1.00  0.00           N  
ATOM    279  H   ARG A 151       4.639  -6.467  -1.302  1.00  0.00           H  
ATOM    280  HA  ARG A 151       6.295  -5.788  -2.844  1.00  0.00           H  
ATOM    281  HB2 ARG A 151       3.662  -5.027  -4.086  1.00  0.00           H  
ATOM    282  HB3 ARG A 151       5.168  -4.617  -4.906  1.00  0.00           H  
ATOM    283  HG2 ARG A 151       4.654  -6.735  -5.786  1.00  0.00           H  
ATOM    284  HG3 ARG A 151       5.800  -7.110  -4.498  1.00  0.00           H  
ATOM    285  HD2 ARG A 151       4.226  -8.478  -3.607  1.00  0.00           H  
ATOM    286  HD3 ARG A 151       3.248  -7.036  -3.267  1.00  0.00           H  
ATOM    287  HE  ARG A 151       3.126  -8.503  -5.877  1.00  0.00           H  
ATOM    288 HH11 ARG A 151       1.002  -9.174  -3.931  1.00  0.00           H  
ATOM    289 HH12 ARG A 151      -0.255  -8.051  -4.330  1.00  0.00           H  
ATOM    290 HH21 ARG A 151       1.831  -5.952  -6.140  1.00  0.00           H  
ATOM    291 HH22 ARG A 151       0.216  -6.227  -5.580  1.00  0.00           H  
ATOM    292  N   VAL A 152       7.028  -3.378  -2.609  1.00  0.00           N  
ATOM    293  CA  VAL A 152       7.434  -1.970  -2.324  1.00  0.00           C  
ATOM    294  C   VAL A 152       6.873  -1.025  -3.395  1.00  0.00           C  
ATOM    295  O   VAL A 152       7.601  -0.294  -4.036  1.00  0.00           O  
ATOM    296  CB  VAL A 152       8.963  -1.981  -2.359  1.00  0.00           C  
ATOM    297  CG1 VAL A 152       9.449  -1.994  -3.812  1.00  0.00           C  
ATOM    298  CG2 VAL A 152       9.498  -0.730  -1.659  1.00  0.00           C  
ATOM    299  H   VAL A 152       7.707  -4.049  -2.839  1.00  0.00           H  
ATOM    300  HA  VAL A 152       7.092  -1.672  -1.345  1.00  0.00           H  
ATOM    301  HB  VAL A 152       9.329  -2.861  -1.853  1.00  0.00           H  
ATOM    302 HG11 VAL A 152       8.637  -2.292  -4.459  1.00  0.00           H  
ATOM    303 HG12 VAL A 152       9.785  -1.007  -4.087  1.00  0.00           H  
ATOM    304 HG13 VAL A 152      10.265  -2.694  -3.911  1.00  0.00           H  
ATOM    305 HG21 VAL A 152       8.954   0.135  -2.003  1.00  0.00           H  
ATOM    306 HG22 VAL A 152       9.373  -0.833  -0.590  1.00  0.00           H  
ATOM    307 HG23 VAL A 152      10.548  -0.610  -1.886  1.00  0.00           H  
ATOM    308  N   ILE A 153       5.582  -1.030  -3.588  1.00  0.00           N  
ATOM    309  CA  ILE A 153       4.974  -0.131  -4.610  1.00  0.00           C  
ATOM    310  C   ILE A 153       3.490   0.080  -4.310  1.00  0.00           C  
ATOM    311  O   ILE A 153       2.956   1.156  -4.490  1.00  0.00           O  
ATOM    312  CB  ILE A 153       5.153  -0.860  -5.943  1.00  0.00           C  
ATOM    313  CG1 ILE A 153       4.886  -2.355  -5.752  1.00  0.00           C  
ATOM    314  CG2 ILE A 153       6.582  -0.658  -6.446  1.00  0.00           C  
ATOM    315  CD1 ILE A 153       4.918  -3.057  -7.110  1.00  0.00           C  
ATOM    316  H   ILE A 153       5.011  -1.623  -3.057  1.00  0.00           H  
ATOM    317  HA  ILE A 153       5.489   0.812  -4.635  1.00  0.00           H  
ATOM    318  HB  ILE A 153       4.458  -0.459  -6.667  1.00  0.00           H  
ATOM    319 HG12 ILE A 153       5.646  -2.776  -5.109  1.00  0.00           H  
ATOM    320 HG13 ILE A 153       3.915  -2.493  -5.300  1.00  0.00           H  
ATOM    321 HG21 ILE A 153       7.005   0.221  -5.983  1.00  0.00           H  
ATOM    322 HG22 ILE A 153       7.179  -1.522  -6.189  1.00  0.00           H  
ATOM    323 HG23 ILE A 153       6.573  -0.534  -7.518  1.00  0.00           H  
ATOM    324 HD11 ILE A 153       4.301  -2.515  -7.810  1.00  0.00           H  
ATOM    325 HD12 ILE A 153       5.935  -3.091  -7.474  1.00  0.00           H  
ATOM    326 HD13 ILE A 153       4.540  -4.064  -7.003  1.00  0.00           H  
ATOM    327  N   ASP A 154       2.823  -0.940  -3.846  1.00  0.00           N  
ATOM    328  CA  ASP A 154       1.375  -0.799  -3.525  1.00  0.00           C  
ATOM    329  C   ASP A 154       1.208  -0.006  -2.227  1.00  0.00           C  
ATOM    330  O   ASP A 154       0.141   0.486  -1.919  1.00  0.00           O  
ATOM    331  CB  ASP A 154       0.866  -2.230  -3.352  1.00  0.00           C  
ATOM    332  CG  ASP A 154      -0.257  -2.497  -4.354  1.00  0.00           C  
ATOM    333  OD1 ASP A 154      -1.194  -1.716  -4.388  1.00  0.00           O  
ATOM    334  OD2 ASP A 154      -0.162  -3.478  -5.074  1.00  0.00           O  
ATOM    335  H   ASP A 154       3.277  -1.795  -3.703  1.00  0.00           H  
ATOM    336  HA  ASP A 154       0.854  -0.315  -4.336  1.00  0.00           H  
ATOM    337  HB2 ASP A 154       1.677  -2.923  -3.524  1.00  0.00           H  
ATOM    338  HB3 ASP A 154       0.488  -2.359  -2.349  1.00  0.00           H  
ATOM    339  N   ALA A 155       2.261   0.121  -1.468  1.00  0.00           N  
ATOM    340  CA  ALA A 155       2.175   0.884  -0.191  1.00  0.00           C  
ATOM    341  C   ALA A 155       2.469   2.364  -0.445  1.00  0.00           C  
ATOM    342  O   ALA A 155       2.113   3.221   0.338  1.00  0.00           O  
ATOM    343  CB  ALA A 155       3.249   0.269   0.705  1.00  0.00           C  
ATOM    344  H   ALA A 155       3.111  -0.283  -1.739  1.00  0.00           H  
ATOM    345  HA  ALA A 155       1.203   0.762   0.258  1.00  0.00           H  
ATOM    346  HB1 ALA A 155       3.141  -0.805   0.712  1.00  0.00           H  
ATOM    347  HB2 ALA A 155       4.226   0.531   0.327  1.00  0.00           H  
ATOM    348  HB3 ALA A 155       3.138   0.648   1.711  1.00  0.00           H  
ATOM    349  N   ALA A 156       3.115   2.669  -1.538  1.00  0.00           N  
ATOM    350  CA  ALA A 156       3.433   4.091  -1.846  1.00  0.00           C  
ATOM    351  C   ALA A 156       2.154   4.854  -2.199  1.00  0.00           C  
ATOM    352  O   ALA A 156       1.416   4.470  -3.085  1.00  0.00           O  
ATOM    353  CB  ALA A 156       4.373   4.036  -3.052  1.00  0.00           C  
ATOM    354  H   ALA A 156       3.393   1.960  -2.155  1.00  0.00           H  
ATOM    355  HA  ALA A 156       3.932   4.556  -1.011  1.00  0.00           H  
ATOM    356  HB1 ALA A 156       4.948   3.120  -3.018  1.00  0.00           H  
ATOM    357  HB2 ALA A 156       3.794   4.062  -3.962  1.00  0.00           H  
ATOM    358  HB3 ALA A 156       5.043   4.882  -3.026  1.00  0.00           H  
ATOM    359  N   THR A 157       1.883   5.931  -1.514  1.00  0.00           N  
ATOM    360  CA  THR A 157       0.655   6.714  -1.812  1.00  0.00           C  
ATOM    361  C   THR A 157       1.014   8.162  -2.146  1.00  0.00           C  
ATOM    362  O   THR A 157       2.148   8.576  -1.999  1.00  0.00           O  
ATOM    363  CB  THR A 157      -0.185   6.649  -0.536  1.00  0.00           C  
ATOM    364  OG1 THR A 157      -0.430   5.290  -0.201  1.00  0.00           O  
ATOM    365  CG2 THR A 157      -1.515   7.368  -0.761  1.00  0.00           C  
ATOM    366  H   THR A 157       2.488   6.226  -0.808  1.00  0.00           H  
ATOM    367  HA  THR A 157       0.121   6.264  -2.624  1.00  0.00           H  
ATOM    368  HB  THR A 157       0.347   7.130   0.270  1.00  0.00           H  
ATOM    369  HG1 THR A 157      -0.516   4.794  -1.018  1.00  0.00           H  
ATOM    370 HG21 THR A 157      -1.929   7.069  -1.713  1.00  0.00           H  
ATOM    371 HG22 THR A 157      -2.205   7.105   0.028  1.00  0.00           H  
ATOM    372 HG23 THR A 157      -1.354   8.436  -0.758  1.00  0.00           H  
ATOM    373  N   SER A 158       0.059   8.937  -2.591  1.00  0.00           N  
ATOM    374  CA  SER A 158       0.351  10.361  -2.927  1.00  0.00           C  
ATOM    375  C   SER A 158       1.329  10.939  -1.902  1.00  0.00           C  
ATOM    376  O   SER A 158       2.233  11.678  -2.238  1.00  0.00           O  
ATOM    377  CB  SER A 158      -0.998  11.073  -2.844  1.00  0.00           C  
ATOM    378  OG  SER A 158      -0.830  12.437  -3.204  1.00  0.00           O  
ATOM    379  H   SER A 158      -0.848   8.584  -2.699  1.00  0.00           H  
ATOM    380  HA  SER A 158       0.754  10.440  -3.924  1.00  0.00           H  
ATOM    381  HB2 SER A 158      -1.694  10.609  -3.525  1.00  0.00           H  
ATOM    382  HB3 SER A 158      -1.382  11.000  -1.835  1.00  0.00           H  
ATOM    383  HG  SER A 158      -1.320  12.973  -2.574  1.00  0.00           H  
ATOM    384  N   MET A 159       1.158  10.595  -0.657  1.00  0.00           N  
ATOM    385  CA  MET A 159       2.077  11.104   0.394  1.00  0.00           C  
ATOM    386  C   MET A 159       3.047   9.995   0.807  1.00  0.00           C  
ATOM    387  O   MET A 159       2.695   8.832   0.806  1.00  0.00           O  
ATOM    388  CB  MET A 159       1.171  11.493   1.562  1.00  0.00           C  
ATOM    389  CG  MET A 159       0.263  10.315   1.919  1.00  0.00           C  
ATOM    390  SD  MET A 159      -0.173  10.399   3.674  1.00  0.00           S  
ATOM    391  CE  MET A 159      -0.775   8.701   3.839  1.00  0.00           C  
ATOM    392  H   MET A 159       0.431   9.992  -0.413  1.00  0.00           H  
ATOM    393  HA  MET A 159       2.614  11.965   0.036  1.00  0.00           H  
ATOM    394  HB2 MET A 159       1.778  11.754   2.417  1.00  0.00           H  
ATOM    395  HB3 MET A 159       0.565  12.340   1.279  1.00  0.00           H  
ATOM    396  HG2 MET A 159      -0.635  10.360   1.321  1.00  0.00           H  
ATOM    397  HG3 MET A 159       0.781   9.389   1.720  1.00  0.00           H  
ATOM    398  HE1 MET A 159      -0.527   8.143   2.947  1.00  0.00           H  
ATOM    399  HE2 MET A 159      -0.313   8.238   4.700  1.00  0.00           H  
ATOM    400  HE3 MET A 159      -1.846   8.709   3.969  1.00  0.00           H  
ATOM    401  N   PRO A 160       4.242  10.391   1.142  1.00  0.00           N  
ATOM    402  CA  PRO A 160       5.277   9.415   1.558  1.00  0.00           C  
ATOM    403  C   PRO A 160       4.949   8.837   2.937  1.00  0.00           C  
ATOM    404  O   PRO A 160       5.482   9.263   3.941  1.00  0.00           O  
ATOM    405  CB  PRO A 160       6.557  10.249   1.604  1.00  0.00           C  
ATOM    406  CG  PRO A 160       6.093  11.653   1.820  1.00  0.00           C  
ATOM    407  CD  PRO A 160       4.738  11.771   1.171  1.00  0.00           C  
ATOM    408  HA  PRO A 160       5.375   8.629   0.827  1.00  0.00           H  
ATOM    409  HB2 PRO A 160       7.184   9.925   2.422  1.00  0.00           H  
ATOM    410  HB3 PRO A 160       7.089  10.174   0.668  1.00  0.00           H  
ATOM    411  HG2 PRO A 160       6.017  11.858   2.879  1.00  0.00           H  
ATOM    412  HG3 PRO A 160       6.779  12.345   1.357  1.00  0.00           H  
ATOM    413  HD2 PRO A 160       4.089  12.401   1.765  1.00  0.00           H  
ATOM    414  HD3 PRO A 160       4.829  12.155   0.166  1.00  0.00           H  
ATOM    415  N   ARG A 161       4.075   7.867   2.994  1.00  0.00           N  
ATOM    416  CA  ARG A 161       3.723   7.269   4.318  1.00  0.00           C  
ATOM    417  C   ARG A 161       4.958   6.603   4.934  1.00  0.00           C  
ATOM    418  O   ARG A 161       6.040   7.154   4.927  1.00  0.00           O  
ATOM    419  CB  ARG A 161       2.641   6.221   4.033  1.00  0.00           C  
ATOM    420  CG  ARG A 161       1.704   6.716   2.923  1.00  0.00           C  
ATOM    421  CD  ARG A 161       2.045   6.047   1.579  1.00  0.00           C  
ATOM    422  NE  ARG A 161       2.931   4.893   1.902  1.00  0.00           N  
ATOM    423  CZ  ARG A 161       4.222   4.991   1.734  1.00  0.00           C  
ATOM    424  NH1 ARG A 161       4.701   5.666   0.725  1.00  0.00           N  
ATOM    425  NH2 ARG A 161       5.035   4.413   2.574  1.00  0.00           N  
ATOM    426  H   ARG A 161       3.656   7.534   2.171  1.00  0.00           H  
ATOM    427  HA  ARG A 161       3.335   8.027   4.981  1.00  0.00           H  
ATOM    428  HB2 ARG A 161       3.109   5.298   3.733  1.00  0.00           H  
ATOM    429  HB3 ARG A 161       2.067   6.051   4.931  1.00  0.00           H  
ATOM    430  HG2 ARG A 161       0.684   6.479   3.188  1.00  0.00           H  
ATOM    431  HG3 ARG A 161       1.805   7.786   2.823  1.00  0.00           H  
ATOM    432  HD2 ARG A 161       1.142   5.700   1.100  1.00  0.00           H  
ATOM    433  HD3 ARG A 161       2.565   6.741   0.939  1.00  0.00           H  
ATOM    434  HE  ARG A 161       2.544   4.059   2.242  1.00  0.00           H  
ATOM    435 HH11 ARG A 161       4.078   6.110   0.079  1.00  0.00           H  
ATOM    436 HH12 ARG A 161       5.689   5.741   0.597  1.00  0.00           H  
ATOM    437 HH21 ARG A 161       4.669   3.897   3.347  1.00  0.00           H  
ATOM    438 HH22 ARG A 161       6.023   4.488   2.445  1.00  0.00           H  
ATOM    439  N   LYS A 162       4.803   5.419   5.462  1.00  0.00           N  
ATOM    440  CA  LYS A 162       5.964   4.713   6.072  1.00  0.00           C  
ATOM    441  C   LYS A 162       5.730   3.201   6.040  1.00  0.00           C  
ATOM    442  O   LYS A 162       4.915   2.675   6.772  1.00  0.00           O  
ATOM    443  CB  LYS A 162       6.027   5.219   7.514  1.00  0.00           C  
ATOM    444  CG  LYS A 162       7.474   5.171   8.006  1.00  0.00           C  
ATOM    445  CD  LYS A 162       7.520   5.536   9.492  1.00  0.00           C  
ATOM    446  CE  LYS A 162       8.780   6.356   9.777  1.00  0.00           C  
ATOM    447  NZ  LYS A 162       9.052   6.149  11.227  1.00  0.00           N  
ATOM    448  H   LYS A 162       3.925   4.990   5.454  1.00  0.00           H  
ATOM    449  HA  LYS A 162       6.871   4.966   5.552  1.00  0.00           H  
ATOM    450  HB2 LYS A 162       5.665   6.236   7.554  1.00  0.00           H  
ATOM    451  HB3 LYS A 162       5.413   4.593   8.142  1.00  0.00           H  
ATOM    452  HG2 LYS A 162       7.867   4.174   7.869  1.00  0.00           H  
ATOM    453  HG3 LYS A 162       8.070   5.874   7.446  1.00  0.00           H  
ATOM    454  HD2 LYS A 162       6.645   6.119   9.745  1.00  0.00           H  
ATOM    455  HD3 LYS A 162       7.537   4.634  10.084  1.00  0.00           H  
ATOM    456  HE2 LYS A 162       9.606   5.992   9.181  1.00  0.00           H  
ATOM    457  HE3 LYS A 162       8.604   7.402   9.581  1.00  0.00           H  
ATOM    458  HZ1 LYS A 162       8.794   5.177  11.493  1.00  0.00           H  
ATOM    459  HZ2 LYS A 162      10.064   6.303  11.415  1.00  0.00           H  
ATOM    460  HZ3 LYS A 162       8.488   6.819  11.785  1.00  0.00           H  
ATOM    461  N   VAL A 163       6.431   2.499   5.192  1.00  0.00           N  
ATOM    462  CA  VAL A 163       6.235   1.023   5.115  1.00  0.00           C  
ATOM    463  C   VAL A 163       7.557   0.285   5.341  1.00  0.00           C  
ATOM    464  O   VAL A 163       8.433   0.744   6.050  1.00  0.00           O  
ATOM    465  CB  VAL A 163       5.712   0.765   3.701  1.00  0.00           C  
ATOM    466  CG1 VAL A 163       4.430   1.570   3.478  1.00  0.00           C  
ATOM    467  CG2 VAL A 163       6.768   1.197   2.681  1.00  0.00           C  
ATOM    468  H   VAL A 163       7.080   2.940   4.606  1.00  0.00           H  
ATOM    469  HA  VAL A 163       5.502   0.703   5.837  1.00  0.00           H  
ATOM    470  HB  VAL A 163       5.501  -0.286   3.582  1.00  0.00           H  
ATOM    471 HG11 VAL A 163       4.328   2.309   4.259  1.00  0.00           H  
ATOM    472 HG12 VAL A 163       4.477   2.063   2.519  1.00  0.00           H  
ATOM    473 HG13 VAL A 163       3.580   0.904   3.498  1.00  0.00           H  
ATOM    474 HG21 VAL A 163       7.746   1.158   3.138  1.00  0.00           H  
ATOM    475 HG22 VAL A 163       6.740   0.530   1.833  1.00  0.00           H  
ATOM    476 HG23 VAL A 163       6.564   2.206   2.355  1.00  0.00           H  
ATOM    477  N   ARG A 164       7.700  -0.865   4.755  1.00  0.00           N  
ATOM    478  CA  ARG A 164       8.951  -1.639   4.949  1.00  0.00           C  
ATOM    479  C   ARG A 164       8.874  -2.956   4.172  1.00  0.00           C  
ATOM    480  O   ARG A 164       7.804  -3.460   3.894  1.00  0.00           O  
ATOM    481  CB  ARG A 164       8.997  -1.885   6.456  1.00  0.00           C  
ATOM    482  CG  ARG A 164       9.917  -3.065   6.774  1.00  0.00           C  
ATOM    483  CD  ARG A 164       9.190  -4.047   7.694  1.00  0.00           C  
ATOM    484  NE  ARG A 164      10.075  -5.243   7.757  1.00  0.00           N  
ATOM    485  CZ  ARG A 164       9.818  -6.202   8.605  1.00  0.00           C  
ATOM    486  NH1 ARG A 164       8.583  -6.547   8.845  1.00  0.00           N  
ATOM    487  NH2 ARG A 164      10.797  -6.816   9.211  1.00  0.00           N  
ATOM    488  H   ARG A 164       6.980  -1.226   4.200  1.00  0.00           H  
ATOM    489  HA  ARG A 164       9.808  -1.062   4.640  1.00  0.00           H  
ATOM    490  HB2 ARG A 164       9.363  -0.999   6.951  1.00  0.00           H  
ATOM    491  HB3 ARG A 164       8.000  -2.102   6.809  1.00  0.00           H  
ATOM    492  HG2 ARG A 164      10.194  -3.564   5.859  1.00  0.00           H  
ATOM    493  HG3 ARG A 164      10.804  -2.704   7.266  1.00  0.00           H  
ATOM    494  HD2 ARG A 164       9.066  -3.616   8.678  1.00  0.00           H  
ATOM    495  HD3 ARG A 164       8.233  -4.317   7.276  1.00  0.00           H  
ATOM    496  HE  ARG A 164      10.851  -5.309   7.161  1.00  0.00           H  
ATOM    497 HH11 ARG A 164       7.833  -6.076   8.381  1.00  0.00           H  
ATOM    498 HH12 ARG A 164       8.386  -7.280   9.495  1.00  0.00           H  
ATOM    499 HH21 ARG A 164      11.744  -6.552   9.027  1.00  0.00           H  
ATOM    500 HH22 ARG A 164      10.600  -7.551   9.861  1.00  0.00           H  
ATOM    501  N   ILE A 165       9.997  -3.516   3.820  1.00  0.00           N  
ATOM    502  CA  ILE A 165       9.977  -4.802   3.060  1.00  0.00           C  
ATOM    503  C   ILE A 165      10.180  -5.976   4.020  1.00  0.00           C  
ATOM    504  O   ILE A 165      10.907  -5.876   4.989  1.00  0.00           O  
ATOM    505  CB  ILE A 165      11.143  -4.710   2.075  1.00  0.00           C  
ATOM    506  CG1 ILE A 165      11.444  -3.240   1.763  1.00  0.00           C  
ATOM    507  CG2 ILE A 165      10.794  -5.443   0.779  1.00  0.00           C  
ATOM    508  CD1 ILE A 165      12.181  -3.131   0.425  1.00  0.00           C  
ATOM    509  H   ILE A 165      10.856  -3.093   4.056  1.00  0.00           H  
ATOM    510  HA  ILE A 165       9.047  -4.910   2.523  1.00  0.00           H  
ATOM    511  HB  ILE A 165      12.005  -5.171   2.514  1.00  0.00           H  
ATOM    512 HG12 ILE A 165      10.517  -2.689   1.709  1.00  0.00           H  
ATOM    513 HG13 ILE A 165      12.062  -2.827   2.546  1.00  0.00           H  
ATOM    514 HG21 ILE A 165      10.060  -6.204   0.983  1.00  0.00           H  
ATOM    515 HG22 ILE A 165      10.399  -4.739   0.063  1.00  0.00           H  
ATOM    516 HG23 ILE A 165      11.686  -5.901   0.376  1.00  0.00           H  
ATOM    517 HD11 ILE A 165      12.942  -3.896   0.371  1.00  0.00           H  
ATOM    518 HD12 ILE A 165      11.478  -3.266  -0.384  1.00  0.00           H  
ATOM    519 HD13 ILE A 165      12.640  -2.159   0.344  1.00  0.00           H  
ATOM    520  N   VAL A 166       9.545  -7.088   3.766  1.00  0.00           N  
ATOM    521  CA  VAL A 166       9.708  -8.259   4.674  1.00  0.00           C  
ATOM    522  C   VAL A 166      10.204  -9.479   3.890  1.00  0.00           C  
ATOM    523  O   VAL A 166      10.282 -10.573   4.414  1.00  0.00           O  
ATOM    524  CB  VAL A 166       8.312  -8.519   5.240  1.00  0.00           C  
ATOM    525  CG1 VAL A 166       7.798  -7.254   5.932  1.00  0.00           C  
ATOM    526  CG2 VAL A 166       7.362  -8.896   4.101  1.00  0.00           C  
ATOM    527  H   VAL A 166       8.960  -7.151   2.981  1.00  0.00           H  
ATOM    528  HA  VAL A 166      10.391  -8.023   5.474  1.00  0.00           H  
ATOM    529  HB  VAL A 166       8.359  -9.327   5.956  1.00  0.00           H  
ATOM    530 HG11 VAL A 166       8.596  -6.812   6.511  1.00  0.00           H  
ATOM    531 HG12 VAL A 166       7.458  -6.550   5.189  1.00  0.00           H  
ATOM    532 HG13 VAL A 166       6.979  -7.511   6.588  1.00  0.00           H  
ATOM    533 HG21 VAL A 166       7.912  -9.423   3.334  1.00  0.00           H  
ATOM    534 HG22 VAL A 166       6.578  -9.534   4.483  1.00  0.00           H  
ATOM    535 HG23 VAL A 166       6.928  -8.001   3.683  1.00  0.00           H  
ATOM    536  N   GLN A 167      10.539  -9.300   2.643  1.00  0.00           N  
ATOM    537  CA  GLN A 167      11.029 -10.454   1.835  1.00  0.00           C  
ATOM    538  C   GLN A 167      11.430  -9.991   0.432  1.00  0.00           C  
ATOM    539  O   GLN A 167      10.604  -9.568  -0.353  1.00  0.00           O  
ATOM    540  CB  GLN A 167       9.845 -11.419   1.763  1.00  0.00           C  
ATOM    541  CG  GLN A 167      10.218 -12.735   2.449  1.00  0.00           C  
ATOM    542  CD  GLN A 167       8.979 -13.627   2.548  1.00  0.00           C  
ATOM    543  OE1 GLN A 167       7.867 -13.161   2.409  1.00  0.00           O  
ATOM    544  NE2 GLN A 167       9.127 -14.903   2.786  1.00  0.00           N  
ATOM    545  H   GLN A 167      10.469  -8.412   2.236  1.00  0.00           H  
ATOM    546  HA  GLN A 167      11.863 -10.932   2.326  1.00  0.00           H  
ATOM    547  HB2 GLN A 167       8.994 -10.979   2.264  1.00  0.00           H  
ATOM    548  HB3 GLN A 167       9.598 -11.611   0.731  1.00  0.00           H  
ATOM    549  HG2 GLN A 167      10.980 -13.238   1.872  1.00  0.00           H  
ATOM    550  HG3 GLN A 167      10.592 -12.530   3.441  1.00  0.00           H  
ATOM    551 HE21 GLN A 167      10.024 -15.279   2.899  1.00  0.00           H  
ATOM    552 HE22 GLN A 167       8.339 -15.482   2.850  1.00  0.00           H  
ATOM    553  N   ILE A 168      12.692 -10.073   0.110  1.00  0.00           N  
ATOM    554  CA  ILE A 168      13.146  -9.641  -1.243  1.00  0.00           C  
ATOM    555  C   ILE A 168      13.416 -10.867  -2.119  1.00  0.00           C  
ATOM    556  O   ILE A 168      14.132 -10.797  -3.099  1.00  0.00           O  
ATOM    557  CB  ILE A 168      14.439  -8.863  -0.998  1.00  0.00           C  
ATOM    558  CG1 ILE A 168      15.064  -8.480  -2.340  1.00  0.00           C  
ATOM    559  CG2 ILE A 168      15.419  -9.733  -0.210  1.00  0.00           C  
ATOM    560  CD1 ILE A 168      15.370  -6.981  -2.353  1.00  0.00           C  
ATOM    561  H   ILE A 168      13.341 -10.419   0.757  1.00  0.00           H  
ATOM    562  HA  ILE A 168      12.410  -9.002  -1.703  1.00  0.00           H  
ATOM    563  HB  ILE A 168      14.218  -7.968  -0.432  1.00  0.00           H  
ATOM    564 HG12 ILE A 168      15.980  -9.036  -2.483  1.00  0.00           H  
ATOM    565 HG13 ILE A 168      14.373  -8.710  -3.139  1.00  0.00           H  
ATOM    566 HG21 ILE A 168      15.090 -10.761  -0.238  1.00  0.00           H  
ATOM    567 HG22 ILE A 168      16.402  -9.657  -0.651  1.00  0.00           H  
ATOM    568 HG23 ILE A 168      15.457  -9.396   0.815  1.00  0.00           H  
ATOM    569 HD11 ILE A 168      14.575  -6.447  -1.855  1.00  0.00           H  
ATOM    570 HD12 ILE A 168      16.304  -6.800  -1.841  1.00  0.00           H  
ATOM    571 HD13 ILE A 168      15.448  -6.637  -3.375  1.00  0.00           H  
ATOM    572  N   ASN A 169      12.849 -11.990  -1.774  1.00  0.00           N  
ATOM    573  CA  ASN A 169      13.072 -13.222  -2.584  1.00  0.00           C  
ATOM    574  C   ASN A 169      12.947 -12.905  -4.076  1.00  0.00           C  
ATOM    575  O   ASN A 169      12.559 -11.820  -4.462  1.00  0.00           O  
ATOM    576  CB  ASN A 169      11.969 -14.187  -2.148  1.00  0.00           C  
ATOM    577  CG  ASN A 169      12.485 -15.626  -2.237  1.00  0.00           C  
ATOM    578  OD1 ASN A 169      12.275 -16.297  -3.228  1.00  0.00           O  
ATOM    579  ND2 ASN A 169      13.156 -16.128  -1.238  1.00  0.00           N  
ATOM    580  H   ASN A 169      12.277 -12.023  -0.978  1.00  0.00           H  
ATOM    581  HA  ASN A 169      14.040 -13.646  -2.367  1.00  0.00           H  
ATOM    582  HB2 ASN A 169      11.683 -13.970  -1.128  1.00  0.00           H  
ATOM    583  HB3 ASN A 169      11.113 -14.073  -2.795  1.00  0.00           H  
ATOM    584 HD21 ASN A 169      13.325 -15.586  -0.438  1.00  0.00           H  
ATOM    585 HD22 ASN A 169      13.490 -17.049  -1.285  1.00  0.00           H  
ATOM    586  N   GLU A 170      13.272 -13.847  -4.921  1.00  0.00           N  
ATOM    587  CA  GLU A 170      13.173 -13.600  -6.388  1.00  0.00           C  
ATOM    588  C   GLU A 170      13.281 -14.919  -7.156  1.00  0.00           C  
ATOM    589  O   GLU A 170      14.359 -15.369  -7.489  1.00  0.00           O  
ATOM    590  CB  GLU A 170      14.357 -12.689  -6.717  1.00  0.00           C  
ATOM    591  CG  GLU A 170      14.540 -12.620  -8.235  1.00  0.00           C  
ATOM    592  CD  GLU A 170      14.513 -11.159  -8.686  1.00  0.00           C  
ATOM    593  OE1 GLU A 170      13.957 -10.346  -7.964  1.00  0.00           O  
ATOM    594  OE2 GLU A 170      15.046 -10.876  -9.745  1.00  0.00           O  
ATOM    595  H   GLU A 170      13.583 -14.715  -4.591  1.00  0.00           H  
ATOM    596  HA  GLU A 170      12.246 -13.100  -6.624  1.00  0.00           H  
ATOM    597  HB2 GLU A 170      14.166 -11.698  -6.331  1.00  0.00           H  
ATOM    598  HB3 GLU A 170      15.253 -13.086  -6.266  1.00  0.00           H  
ATOM    599  HG2 GLU A 170      15.488 -13.061  -8.502  1.00  0.00           H  
ATOM    600  HG3 GLU A 170      13.741 -13.159  -8.719  1.00  0.00           H  
ATOM    601  N   ILE A 171      12.171 -15.546  -7.437  1.00  0.00           N  
ATOM    602  CA  ILE A 171      12.210 -16.836  -8.182  1.00  0.00           C  
ATOM    603  C   ILE A 171      12.296 -16.578  -9.689  1.00  0.00           C  
ATOM    604  O   ILE A 171      12.091 -17.467 -10.492  1.00  0.00           O  
ATOM    605  CB  ILE A 171      10.894 -17.526  -7.830  1.00  0.00           C  
ATOM    606  CG1 ILE A 171       9.735 -16.782  -8.497  1.00  0.00           C  
ATOM    607  CG2 ILE A 171      10.700 -17.515  -6.313  1.00  0.00           C  
ATOM    608  CD1 ILE A 171       9.155 -17.642  -9.623  1.00  0.00           C  
ATOM    609  H   ILE A 171      11.310 -15.169  -7.159  1.00  0.00           H  
ATOM    610  HA  ILE A 171      13.041 -17.437  -7.852  1.00  0.00           H  
ATOM    611  HB  ILE A 171      10.920 -18.545  -8.182  1.00  0.00           H  
ATOM    612 HG12 ILE A 171       8.966 -16.584  -7.763  1.00  0.00           H  
ATOM    613 HG13 ILE A 171      10.091 -15.850  -8.905  1.00  0.00           H  
ATOM    614 HG21 ILE A 171      11.585 -17.907  -5.833  1.00  0.00           H  
ATOM    615 HG22 ILE A 171      10.529 -16.502  -5.979  1.00  0.00           H  
ATOM    616 HG23 ILE A 171       9.850 -18.128  -6.054  1.00  0.00           H  
ATOM    617 HD11 ILE A 171       9.755 -18.532  -9.740  1.00  0.00           H  
ATOM    618 HD12 ILE A 171       8.141 -17.920  -9.378  1.00  0.00           H  
ATOM    619 HD13 ILE A 171       9.161 -17.078 -10.543  1.00  0.00           H  
ATOM    620  N   PHE A 172      12.599 -15.369 -10.080  1.00  0.00           N  
ATOM    621  CA  PHE A 172      12.697 -15.059 -11.534  1.00  0.00           C  
ATOM    622  C   PHE A 172      13.817 -15.881 -12.176  1.00  0.00           C  
ATOM    623  O   PHE A 172      14.902 -15.998 -11.639  1.00  0.00           O  
ATOM    624  CB  PHE A 172      13.021 -13.566 -11.600  1.00  0.00           C  
ATOM    625  CG  PHE A 172      11.747 -12.782 -11.810  1.00  0.00           C  
ATOM    626  CD1 PHE A 172      10.864 -13.146 -12.833  1.00  0.00           C  
ATOM    627  CD2 PHE A 172      11.451 -11.694 -10.982  1.00  0.00           C  
ATOM    628  CE1 PHE A 172       9.683 -12.419 -13.028  1.00  0.00           C  
ATOM    629  CE2 PHE A 172      10.269 -10.968 -11.177  1.00  0.00           C  
ATOM    630  CZ  PHE A 172       9.387 -11.330 -12.200  1.00  0.00           C  
ATOM    631  H   PHE A 172      12.760 -14.667  -9.416  1.00  0.00           H  
ATOM    632  HA  PHE A 172      11.757 -15.253 -12.025  1.00  0.00           H  
ATOM    633  HB2 PHE A 172      13.485 -13.258 -10.674  1.00  0.00           H  
ATOM    634  HB3 PHE A 172      13.697 -13.380 -12.421  1.00  0.00           H  
ATOM    635  HD1 PHE A 172      11.093 -13.985 -13.472  1.00  0.00           H  
ATOM    636  HD2 PHE A 172      12.132 -11.415 -10.192  1.00  0.00           H  
ATOM    637  HE1 PHE A 172       9.002 -12.699 -13.817  1.00  0.00           H  
ATOM    638  HE2 PHE A 172      10.040 -10.128 -10.538  1.00  0.00           H  
ATOM    639  HZ  PHE A 172       8.475 -10.770 -12.352  1.00  0.00           H  
ATOM    640  N   GLN A 173      13.566 -16.452 -13.322  1.00  0.00           N  
ATOM    641  CA  GLN A 173      14.618 -17.267 -13.997  1.00  0.00           C  
ATOM    642  C   GLN A 173      15.852 -16.408 -14.281  1.00  0.00           C  
ATOM    643  O   GLN A 173      16.942 -16.912 -14.466  1.00  0.00           O  
ATOM    644  CB  GLN A 173      13.977 -17.735 -15.304  1.00  0.00           C  
ATOM    645  CG  GLN A 173      13.077 -18.940 -15.029  1.00  0.00           C  
ATOM    646  CD  GLN A 173      13.935 -20.201 -14.900  1.00  0.00           C  
ATOM    647  OE1 GLN A 173      14.920 -20.209 -14.189  1.00  0.00           O  
ATOM    648  NE2 GLN A 173      13.599 -21.275 -15.562  1.00  0.00           N  
ATOM    649  H   GLN A 173      12.686 -16.346 -13.739  1.00  0.00           H  
ATOM    650  HA  GLN A 173      14.881 -18.119 -13.390  1.00  0.00           H  
ATOM    651  HB2 GLN A 173      13.387 -16.932 -15.724  1.00  0.00           H  
ATOM    652  HB3 GLN A 173      14.751 -18.018 -16.002  1.00  0.00           H  
ATOM    653  HG2 GLN A 173      12.532 -18.780 -14.110  1.00  0.00           H  
ATOM    654  HG3 GLN A 173      12.380 -19.065 -15.844  1.00  0.00           H  
ATOM    655 HE21 GLN A 173      12.805 -21.269 -16.135  1.00  0.00           H  
ATOM    656 HE22 GLN A 173      14.143 -22.087 -15.485  1.00  0.00           H  
ATOM    657  N   VAL A 174      15.691 -15.113 -14.318  1.00  0.00           N  
ATOM    658  CA  VAL A 174      16.856 -14.224 -14.592  1.00  0.00           C  
ATOM    659  C   VAL A 174      16.412 -12.758 -14.589  1.00  0.00           C  
ATOM    660  O   VAL A 174      16.034 -12.213 -15.606  1.00  0.00           O  
ATOM    661  CB  VAL A 174      17.349 -14.632 -15.980  1.00  0.00           C  
ATOM    662  CG1 VAL A 174      16.187 -14.578 -16.972  1.00  0.00           C  
ATOM    663  CG2 VAL A 174      18.450 -13.671 -16.431  1.00  0.00           C  
ATOM    664  H   VAL A 174      14.803 -14.725 -14.168  1.00  0.00           H  
ATOM    665  HA  VAL A 174      17.633 -14.385 -13.861  1.00  0.00           H  
ATOM    666  HB  VAL A 174      17.742 -15.638 -15.940  1.00  0.00           H  
ATOM    667 HG11 VAL A 174      15.307 -15.015 -16.521  1.00  0.00           H  
ATOM    668 HG12 VAL A 174      15.983 -13.550 -17.232  1.00  0.00           H  
ATOM    669 HG13 VAL A 174      16.447 -15.130 -17.863  1.00  0.00           H  
ATOM    670 HG21 VAL A 174      18.524 -12.853 -15.728  1.00  0.00           H  
ATOM    671 HG22 VAL A 174      19.392 -14.195 -16.476  1.00  0.00           H  
ATOM    672 HG23 VAL A 174      18.208 -13.280 -17.410  1.00  0.00           H  
ATOM    673  N   GLU A 175      16.458 -12.117 -13.453  1.00  0.00           N  
ATOM    674  CA  GLU A 175      16.040 -10.687 -13.388  1.00  0.00           C  
ATOM    675  C   GLU A 175      16.925  -9.920 -12.403  1.00  0.00           C  
ATOM    676  O   GLU A 175      16.795 -10.051 -11.202  1.00  0.00           O  
ATOM    677  CB  GLU A 175      14.593 -10.721 -12.893  1.00  0.00           C  
ATOM    678  CG  GLU A 175      13.773  -9.665 -13.637  1.00  0.00           C  
ATOM    679  CD  GLU A 175      12.283  -9.975 -13.486  1.00  0.00           C  
ATOM    680  OE1 GLU A 175      11.866 -11.023 -13.949  1.00  0.00           O  
ATOM    681  OE2 GLU A 175      11.585  -9.158 -12.909  1.00  0.00           O  
ATOM    682  H   GLU A 175      16.766 -12.574 -12.644  1.00  0.00           H  
ATOM    683  HA  GLU A 175      16.083 -10.236 -14.365  1.00  0.00           H  
ATOM    684  HB2 GLU A 175      14.173 -11.699 -13.077  1.00  0.00           H  
ATOM    685  HB3 GLU A 175      14.569 -10.512 -11.834  1.00  0.00           H  
ATOM    686  HG2 GLU A 175      13.983  -8.690 -13.223  1.00  0.00           H  
ATOM    687  HG3 GLU A 175      14.037  -9.677 -14.684  1.00  0.00           H  
ATOM    688  N   THR A 176      17.827  -9.119 -12.902  1.00  0.00           N  
ATOM    689  CA  THR A 176      18.721  -8.344 -11.996  1.00  0.00           C  
ATOM    690  C   THR A 176      18.885  -6.913 -12.514  1.00  0.00           C  
ATOM    691  O   THR A 176      18.211  -6.001 -12.077  1.00  0.00           O  
ATOM    692  CB  THR A 176      20.059  -9.083 -12.030  1.00  0.00           C  
ATOM    693  OG1 THR A 176      20.123  -9.889 -13.200  1.00  0.00           O  
ATOM    694  CG2 THR A 176      20.187  -9.969 -10.790  1.00  0.00           C  
ATOM    695  H   THR A 176      17.916  -9.027 -13.873  1.00  0.00           H  
ATOM    696  HA  THR A 176      18.328  -8.339 -10.992  1.00  0.00           H  
ATOM    697  HB  THR A 176      20.866  -8.368 -12.041  1.00  0.00           H  
ATOM    698  HG1 THR A 176      20.810 -10.545 -13.070  1.00  0.00           H  
ATOM    699 HG21 THR A 176      19.746  -9.466  -9.941  1.00  0.00           H  
ATOM    700 HG22 THR A 176      19.672 -10.903 -10.961  1.00  0.00           H  
ATOM    701 HG23 THR A 176      21.230 -10.163 -10.592  1.00  0.00           H  
ATOM    702  N   ASP A 177      19.776  -6.711 -13.445  1.00  0.00           N  
ATOM    703  CA  ASP A 177      19.988  -5.340 -13.998  1.00  0.00           C  
ATOM    704  C   ASP A 177      20.671  -4.446 -12.960  1.00  0.00           C  
ATOM    705  O   ASP A 177      21.298  -4.919 -12.033  1.00  0.00           O  
ATOM    706  CB  ASP A 177      18.585  -4.818 -14.317  1.00  0.00           C  
ATOM    707  CG  ASP A 177      18.595  -4.130 -15.683  1.00  0.00           C  
ATOM    708  OD1 ASP A 177      19.252  -3.108 -15.803  1.00  0.00           O  
ATOM    709  OD2 ASP A 177      17.946  -4.634 -16.584  1.00  0.00           O  
ATOM    710  H   ASP A 177      20.306  -7.462 -13.781  1.00  0.00           H  
ATOM    711  HA  ASP A 177      20.576  -5.388 -14.899  1.00  0.00           H  
ATOM    712  HB2 ASP A 177      17.890  -5.644 -14.334  1.00  0.00           H  
ATOM    713  HB3 ASP A 177      18.284  -4.110 -13.561  1.00  0.00           H  
ATOM    714  N   GLN A 178      20.558  -3.155 -13.114  1.00  0.00           N  
ATOM    715  CA  GLN A 178      21.202  -2.226 -12.142  1.00  0.00           C  
ATOM    716  C   GLN A 178      20.669  -2.472 -10.728  1.00  0.00           C  
ATOM    717  O   GLN A 178      21.278  -2.084  -9.750  1.00  0.00           O  
ATOM    718  CB  GLN A 178      20.815  -0.826 -12.622  1.00  0.00           C  
ATOM    719  CG  GLN A 178      21.853   0.188 -12.137  1.00  0.00           C  
ATOM    720  CD  GLN A 178      21.144   1.464 -11.679  1.00  0.00           C  
ATOM    721  OE1 GLN A 178      19.943   1.582 -11.802  1.00  0.00           O  
ATOM    722  NE2 GLN A 178      21.845   2.431 -11.152  1.00  0.00           N  
ATOM    723  H   GLN A 178      20.049  -2.796 -13.870  1.00  0.00           H  
ATOM    724  HA  GLN A 178      22.274  -2.339 -12.167  1.00  0.00           H  
ATOM    725  HB2 GLN A 178      20.777  -0.815 -13.701  1.00  0.00           H  
ATOM    726  HB3 GLN A 178      19.846  -0.564 -12.225  1.00  0.00           H  
ATOM    727  HG2 GLN A 178      22.408  -0.235 -11.310  1.00  0.00           H  
ATOM    728  HG3 GLN A 178      22.531   0.424 -12.943  1.00  0.00           H  
ATOM    729 HE21 GLN A 178      22.815   2.337 -11.053  1.00  0.00           H  
ATOM    730 HE22 GLN A 178      21.400   3.252 -10.855  1.00  0.00           H  
ATOM    731  N   PHE A 179      19.538  -3.113 -10.609  1.00  0.00           N  
ATOM    732  CA  PHE A 179      18.973  -3.377  -9.254  1.00  0.00           C  
ATOM    733  C   PHE A 179      20.017  -4.071  -8.373  1.00  0.00           C  
ATOM    734  O   PHE A 179      20.096  -3.829  -7.185  1.00  0.00           O  
ATOM    735  CB  PHE A 179      17.765  -4.288  -9.496  1.00  0.00           C  
ATOM    736  CG  PHE A 179      17.769  -5.423  -8.499  1.00  0.00           C  
ATOM    737  CD1 PHE A 179      18.536  -6.568  -8.748  1.00  0.00           C  
ATOM    738  CD2 PHE A 179      17.013  -5.330  -7.324  1.00  0.00           C  
ATOM    739  CE1 PHE A 179      18.545  -7.619  -7.826  1.00  0.00           C  
ATOM    740  CE2 PHE A 179      17.023  -6.383  -6.401  1.00  0.00           C  
ATOM    741  CZ  PHE A 179      17.789  -7.527  -6.653  1.00  0.00           C  
ATOM    742  H   PHE A 179      19.060  -3.418 -11.408  1.00  0.00           H  
ATOM    743  HA  PHE A 179      18.654  -2.457  -8.796  1.00  0.00           H  
ATOM    744  HB2 PHE A 179      16.856  -3.715  -9.383  1.00  0.00           H  
ATOM    745  HB3 PHE A 179      17.813  -4.690 -10.496  1.00  0.00           H  
ATOM    746  HD1 PHE A 179      19.120  -6.638  -9.654  1.00  0.00           H  
ATOM    747  HD2 PHE A 179      16.421  -4.446  -7.129  1.00  0.00           H  
ATOM    748  HE1 PHE A 179      19.137  -8.503  -8.020  1.00  0.00           H  
ATOM    749  HE2 PHE A 179      16.439  -6.312  -5.495  1.00  0.00           H  
ATOM    750  HZ  PHE A 179      17.796  -8.339  -5.939  1.00  0.00           H  
ATOM    751  N   THR A 180      20.816  -4.931  -8.945  1.00  0.00           N  
ATOM    752  CA  THR A 180      21.850  -5.633  -8.132  1.00  0.00           C  
ATOM    753  C   THR A 180      22.483  -4.657  -7.140  1.00  0.00           C  
ATOM    754  O   THR A 180      22.940  -5.040  -6.081  1.00  0.00           O  
ATOM    755  CB  THR A 180      22.883  -6.125  -9.146  1.00  0.00           C  
ATOM    756  OG1 THR A 180      22.891  -5.258 -10.272  1.00  0.00           O  
ATOM    757  CG2 THR A 180      22.522  -7.542  -9.592  1.00  0.00           C  
ATOM    758  H   THR A 180      20.737  -5.113  -9.904  1.00  0.00           H  
ATOM    759  HA  THR A 180      21.414  -6.471  -7.612  1.00  0.00           H  
ATOM    760  HB  THR A 180      23.860  -6.132  -8.690  1.00  0.00           H  
ATOM    761  HG1 THR A 180      23.168  -4.388  -9.975  1.00  0.00           H  
ATOM    762 HG21 THR A 180      21.458  -7.693  -9.486  1.00  0.00           H  
ATOM    763 HG22 THR A 180      22.805  -7.677 -10.626  1.00  0.00           H  
ATOM    764 HG23 THR A 180      23.050  -8.258  -8.979  1.00  0.00           H  
ATOM    765  N   GLN A 181      22.507  -3.395  -7.472  1.00  0.00           N  
ATOM    766  CA  GLN A 181      23.101  -2.391  -6.546  1.00  0.00           C  
ATOM    767  C   GLN A 181      22.298  -2.346  -5.245  1.00  0.00           C  
ATOM    768  O   GLN A 181      22.848  -2.273  -4.165  1.00  0.00           O  
ATOM    769  CB  GLN A 181      23.002  -1.058  -7.287  1.00  0.00           C  
ATOM    770  CG  GLN A 181      23.877  -0.017  -6.586  1.00  0.00           C  
ATOM    771  CD  GLN A 181      23.417   1.387  -6.985  1.00  0.00           C  
ATOM    772  OE1 GLN A 181      22.548   1.956  -6.356  1.00  0.00           O  
ATOM    773  NE2 GLN A 181      23.969   1.975  -8.012  1.00  0.00           N  
ATOM    774  H   GLN A 181      22.128  -3.108  -8.330  1.00  0.00           H  
ATOM    775  HA  GLN A 181      24.131  -2.628  -6.345  1.00  0.00           H  
ATOM    776  HB2 GLN A 181      23.340  -1.187  -8.305  1.00  0.00           H  
ATOM    777  HB3 GLN A 181      21.976  -0.722  -7.288  1.00  0.00           H  
ATOM    778  HG2 GLN A 181      23.788  -0.135  -5.516  1.00  0.00           H  
ATOM    779  HG3 GLN A 181      24.906  -0.153  -6.882  1.00  0.00           H  
ATOM    780 HE21 GLN A 181      24.669   1.515  -8.520  1.00  0.00           H  
ATOM    781 HE22 GLN A 181      23.681   2.874  -8.275  1.00  0.00           H  
ATOM    782  N   LEU A 182      21.000  -2.396  -5.343  1.00  0.00           N  
ATOM    783  CA  LEU A 182      20.156  -2.364  -4.115  1.00  0.00           C  
ATOM    784  C   LEU A 182      20.530  -3.529  -3.201  1.00  0.00           C  
ATOM    785  O   LEU A 182      20.706  -3.370  -2.010  1.00  0.00           O  
ATOM    786  CB  LEU A 182      18.720  -2.522  -4.613  1.00  0.00           C  
ATOM    787  CG  LEU A 182      18.379  -1.386  -5.577  1.00  0.00           C  
ATOM    788  CD1 LEU A 182      17.679  -1.959  -6.809  1.00  0.00           C  
ATOM    789  CD2 LEU A 182      17.446  -0.395  -4.883  1.00  0.00           C  
ATOM    790  H   LEU A 182      20.578  -2.461  -6.225  1.00  0.00           H  
ATOM    791  HA  LEU A 182      20.270  -1.427  -3.601  1.00  0.00           H  
ATOM    792  HB2 LEU A 182      18.618  -3.469  -5.123  1.00  0.00           H  
ATOM    793  HB3 LEU A 182      18.044  -2.492  -3.773  1.00  0.00           H  
ATOM    794  HG  LEU A 182      19.286  -0.883  -5.878  1.00  0.00           H  
ATOM    795 HD11 LEU A 182      18.122  -2.909  -7.067  1.00  0.00           H  
ATOM    796 HD12 LEU A 182      16.629  -2.098  -6.595  1.00  0.00           H  
ATOM    797 HD13 LEU A 182      17.789  -1.274  -7.637  1.00  0.00           H  
ATOM    798 HD21 LEU A 182      17.492  -0.545  -3.815  1.00  0.00           H  
ATOM    799 HD22 LEU A 182      17.753   0.613  -5.118  1.00  0.00           H  
ATOM    800 HD23 LEU A 182      16.434  -0.552  -5.225  1.00  0.00           H  
ATOM    801  N   LEU A 183      20.651  -4.699  -3.758  1.00  0.00           N  
ATOM    802  CA  LEU A 183      21.013  -5.886  -2.930  1.00  0.00           C  
ATOM    803  C   LEU A 183      22.445  -5.748  -2.408  1.00  0.00           C  
ATOM    804  O   LEU A 183      22.769  -6.200  -1.329  1.00  0.00           O  
ATOM    805  CB  LEU A 183      20.902  -7.079  -3.879  1.00  0.00           C  
ATOM    806  CG  LEU A 183      20.582  -8.342  -3.078  1.00  0.00           C  
ATOM    807  CD1 LEU A 183      21.514  -8.431  -1.869  1.00  0.00           C  
ATOM    808  CD2 LEU A 183      19.129  -8.285  -2.599  1.00  0.00           C  
ATOM    809  H   LEU A 183      20.502  -4.798  -4.721  1.00  0.00           H  
ATOM    810  HA  LEU A 183      20.323  -6.000  -2.112  1.00  0.00           H  
ATOM    811  HB2 LEU A 183      20.113  -6.896  -4.596  1.00  0.00           H  
ATOM    812  HB3 LEU A 183      21.838  -7.213  -4.400  1.00  0.00           H  
ATOM    813  HG  LEU A 183      20.722  -9.210  -3.706  1.00  0.00           H  
ATOM    814 HD11 LEU A 183      22.523  -8.202  -2.174  1.00  0.00           H  
ATOM    815 HD12 LEU A 183      21.196  -7.724  -1.116  1.00  0.00           H  
ATOM    816 HD13 LEU A 183      21.479  -9.431  -1.462  1.00  0.00           H  
ATOM    817 HD21 LEU A 183      18.542  -7.704  -3.296  1.00  0.00           H  
ATOM    818 HD22 LEU A 183      18.731  -9.287  -2.540  1.00  0.00           H  
ATOM    819 HD23 LEU A 183      19.090  -7.822  -1.624  1.00  0.00           H  
ATOM    820  N   ASP A 184      23.302  -5.127  -3.168  1.00  0.00           N  
ATOM    821  CA  ASP A 184      24.715  -4.957  -2.718  1.00  0.00           C  
ATOM    822  C   ASP A 184      24.834  -3.743  -1.793  1.00  0.00           C  
ATOM    823  O   ASP A 184      25.902  -3.415  -1.318  1.00  0.00           O  
ATOM    824  CB  ASP A 184      25.515  -4.734  -4.001  1.00  0.00           C  
ATOM    825  CG  ASP A 184      27.010  -4.781  -3.683  1.00  0.00           C  
ATOM    826  OD1 ASP A 184      27.401  -5.621  -2.889  1.00  0.00           O  
ATOM    827  OD2 ASP A 184      27.739  -3.976  -4.240  1.00  0.00           O  
ATOM    828  H   ASP A 184      23.017  -4.771  -4.035  1.00  0.00           H  
ATOM    829  HA  ASP A 184      25.060  -5.849  -2.217  1.00  0.00           H  
ATOM    830  HB2 ASP A 184      25.272  -5.507  -4.716  1.00  0.00           H  
ATOM    831  HB3 ASP A 184      25.267  -3.769  -4.416  1.00  0.00           H  
ATOM    832  N   ALA A 185      23.743  -3.074  -1.533  1.00  0.00           N  
ATOM    833  CA  ALA A 185      23.795  -1.881  -0.641  1.00  0.00           C  
ATOM    834  C   ALA A 185      23.775  -2.317   0.827  1.00  0.00           C  
ATOM    835  O   ALA A 185      23.659  -1.506   1.724  1.00  0.00           O  
ATOM    836  CB  ALA A 185      22.540  -1.079  -0.980  1.00  0.00           C  
ATOM    837  H   ALA A 185      22.890  -3.355  -1.927  1.00  0.00           H  
ATOM    838  HA  ALA A 185      24.674  -1.293  -0.847  1.00  0.00           H  
ATOM    839  HB1 ALA A 185      22.484  -0.930  -2.048  1.00  0.00           H  
ATOM    840  HB2 ALA A 185      21.665  -1.619  -0.646  1.00  0.00           H  
ATOM    841  HB3 ALA A 185      22.579  -0.119  -0.485  1.00  0.00           H  
ATOM    842  N   ASP A 186      23.885  -3.593   1.079  1.00  0.00           N  
ATOM    843  CA  ASP A 186      23.873  -4.080   2.489  1.00  0.00           C  
ATOM    844  C   ASP A 186      22.556  -3.694   3.169  1.00  0.00           C  
ATOM    845  O   ASP A 186      22.545  -3.144   4.252  1.00  0.00           O  
ATOM    846  CB  ASP A 186      25.051  -3.377   3.162  1.00  0.00           C  
ATOM    847  CG  ASP A 186      25.464  -4.156   4.413  1.00  0.00           C  
ATOM    848  OD1 ASP A 186      25.228  -5.353   4.445  1.00  0.00           O  
ATOM    849  OD2 ASP A 186      26.007  -3.542   5.317  1.00  0.00           O  
ATOM    850  H   ASP A 186      23.978  -4.231   0.342  1.00  0.00           H  
ATOM    851  HA  ASP A 186      24.013  -5.149   2.520  1.00  0.00           H  
ATOM    852  HB2 ASP A 186      25.884  -3.334   2.474  1.00  0.00           H  
ATOM    853  HB3 ASP A 186      24.763  -2.376   3.442  1.00  0.00           H  
ATOM    854  N   ILE A 187      21.448  -3.976   2.542  1.00  0.00           N  
ATOM    855  CA  ILE A 187      20.133  -3.624   3.151  1.00  0.00           C  
ATOM    856  C   ILE A 187      19.133  -4.761   2.943  1.00  0.00           C  
ATOM    857  O   ILE A 187      18.790  -5.480   3.860  1.00  0.00           O  
ATOM    858  CB  ILE A 187      19.674  -2.370   2.409  1.00  0.00           C  
ATOM    859  CG1 ILE A 187      20.690  -1.248   2.628  1.00  0.00           C  
ATOM    860  CG2 ILE A 187      18.309  -1.931   2.942  1.00  0.00           C  
ATOM    861  CD1 ILE A 187      20.385  -0.095   1.671  1.00  0.00           C  
ATOM    862  H   ILE A 187      21.480  -4.419   1.669  1.00  0.00           H  
ATOM    863  HA  ILE A 187      20.248  -3.412   4.200  1.00  0.00           H  
ATOM    864  HB  ILE A 187      19.595  -2.587   1.354  1.00  0.00           H  
ATOM    865 HG12 ILE A 187      20.625  -0.898   3.647  1.00  0.00           H  
ATOM    866 HG13 ILE A 187      21.685  -1.619   2.435  1.00  0.00           H  
ATOM    867 HG21 ILE A 187      18.241  -2.166   3.995  1.00  0.00           H  
ATOM    868 HG22 ILE A 187      18.193  -0.867   2.803  1.00  0.00           H  
ATOM    869 HG23 ILE A 187      17.530  -2.452   2.406  1.00  0.00           H  
ATOM    870 HD11 ILE A 187      19.346   0.184   1.763  1.00  0.00           H  
ATOM    871 HD12 ILE A 187      21.009   0.751   1.916  1.00  0.00           H  
ATOM    872 HD13 ILE A 187      20.584  -0.407   0.656  1.00  0.00           H  
ATOM    873  N   ARG A 188      18.661  -4.922   1.739  1.00  0.00           N  
ATOM    874  CA  ARG A 188      17.675  -6.005   1.454  1.00  0.00           C  
ATOM    875  C   ARG A 188      16.318  -5.643   2.060  1.00  0.00           C  
ATOM    876  O   ARG A 188      16.235  -4.858   2.983  1.00  0.00           O  
ATOM    877  CB  ARG A 188      18.246  -7.257   2.121  1.00  0.00           C  
ATOM    878  CG  ARG A 188      18.221  -8.422   1.128  1.00  0.00           C  
ATOM    879  CD  ARG A 188      18.592  -9.718   1.853  1.00  0.00           C  
ATOM    880  NE  ARG A 188      17.750  -9.727   3.082  1.00  0.00           N  
ATOM    881  CZ  ARG A 188      18.299  -9.944   4.245  1.00  0.00           C  
ATOM    882  NH1 ARG A 188      19.477  -9.452   4.513  1.00  0.00           N  
ATOM    883  NH2 ARG A 188      17.668 -10.652   5.143  1.00  0.00           N  
ATOM    884  H   ARG A 188      18.950  -4.321   1.020  1.00  0.00           H  
ATOM    885  HA  ARG A 188      17.582  -6.160   0.390  1.00  0.00           H  
ATOM    886  HB2 ARG A 188      19.264  -7.068   2.429  1.00  0.00           H  
ATOM    887  HB3 ARG A 188      17.650  -7.510   2.985  1.00  0.00           H  
ATOM    888  HG2 ARG A 188      17.230  -8.514   0.708  1.00  0.00           H  
ATOM    889  HG3 ARG A 188      18.931  -8.237   0.339  1.00  0.00           H  
ATOM    890  HD2 ARG A 188      18.364 -10.574   1.230  1.00  0.00           H  
ATOM    891  HD3 ARG A 188      19.637  -9.715   2.120  1.00  0.00           H  
ATOM    892  HE  ARG A 188      16.785  -9.571   3.015  1.00  0.00           H  
ATOM    893 HH11 ARG A 188      19.961  -8.909   3.826  1.00  0.00           H  
ATOM    894 HH12 ARG A 188      19.898  -9.616   5.405  1.00  0.00           H  
ATOM    895 HH21 ARG A 188      16.766 -11.030   4.938  1.00  0.00           H  
ATOM    896 HH22 ARG A 188      18.090 -10.818   6.035  1.00  0.00           H  
ATOM    897  N   VAL A 189      15.254  -6.208   1.551  1.00  0.00           N  
ATOM    898  CA  VAL A 189      13.910  -5.896   2.092  1.00  0.00           C  
ATOM    899  C   VAL A 189      13.844  -4.453   2.572  1.00  0.00           C  
ATOM    900  O   VAL A 189      13.197  -4.150   3.553  1.00  0.00           O  
ATOM    901  CB  VAL A 189      13.709  -6.867   3.250  1.00  0.00           C  
ATOM    902  CG1 VAL A 189      14.112  -8.276   2.809  1.00  0.00           C  
ATOM    903  CG2 VAL A 189      14.571  -6.442   4.441  1.00  0.00           C  
ATOM    904  H   VAL A 189      15.338  -6.836   0.809  1.00  0.00           H  
ATOM    905  HA  VAL A 189      13.162  -6.063   1.347  1.00  0.00           H  
ATOM    906  HB  VAL A 189      12.671  -6.864   3.532  1.00  0.00           H  
ATOM    907 HG11 VAL A 189      13.616  -8.518   1.880  1.00  0.00           H  
ATOM    908 HG12 VAL A 189      15.182  -8.317   2.669  1.00  0.00           H  
ATOM    909 HG13 VAL A 189      13.821  -8.987   3.568  1.00  0.00           H  
ATOM    910 HG21 VAL A 189      15.609  -6.427   4.148  1.00  0.00           H  
ATOM    911 HG22 VAL A 189      14.274  -5.457   4.768  1.00  0.00           H  
ATOM    912 HG23 VAL A 189      14.435  -7.144   5.251  1.00  0.00           H  
ATOM    913  N   GLY A 190      14.502  -3.566   1.879  1.00  0.00           N  
ATOM    914  CA  GLY A 190      14.493  -2.123   2.270  1.00  0.00           C  
ATOM    915  C   GLY A 190      14.277  -1.984   3.780  1.00  0.00           C  
ATOM    916  O   GLY A 190      13.882  -0.942   4.263  1.00  0.00           O  
ATOM    917  H   GLY A 190      14.999  -3.851   1.088  1.00  0.00           H  
ATOM    918  HA2 GLY A 190      15.438  -1.675   2.002  1.00  0.00           H  
ATOM    919  HA3 GLY A 190      13.695  -1.615   1.750  1.00  0.00           H  
ATOM    920  N   SER A 191      14.519  -3.029   4.527  1.00  0.00           N  
ATOM    921  CA  SER A 191      14.310  -2.958   6.000  1.00  0.00           C  
ATOM    922  C   SER A 191      13.060  -2.129   6.308  1.00  0.00           C  
ATOM    923  O   SER A 191      12.084  -2.158   5.571  1.00  0.00           O  
ATOM    924  CB  SER A 191      15.563  -2.270   6.541  1.00  0.00           C  
ATOM    925  OG  SER A 191      15.394  -2.009   7.928  1.00  0.00           O  
ATOM    926  H   SER A 191      14.827  -3.867   4.114  1.00  0.00           H  
ATOM    927  HA  SER A 191      14.221  -3.948   6.418  1.00  0.00           H  
ATOM    928  HB2 SER A 191      16.417  -2.911   6.401  1.00  0.00           H  
ATOM    929  HB3 SER A 191      15.721  -1.342   6.005  1.00  0.00           H  
ATOM    930  HG  SER A 191      15.918  -1.237   8.151  1.00  0.00           H  
ATOM    931  N   GLU A 192      13.090  -1.382   7.379  1.00  0.00           N  
ATOM    932  CA  GLU A 192      11.922  -0.532   7.740  1.00  0.00           C  
ATOM    933  C   GLU A 192      12.089   0.848   7.104  1.00  0.00           C  
ATOM    934  O   GLU A 192      12.986   1.593   7.450  1.00  0.00           O  
ATOM    935  CB  GLU A 192      11.959  -0.433   9.265  1.00  0.00           C  
ATOM    936  CG  GLU A 192      13.352   0.009   9.718  1.00  0.00           C  
ATOM    937  CD  GLU A 192      14.034  -1.139  10.463  1.00  0.00           C  
ATOM    938  OE1 GLU A 192      13.327  -1.962  11.021  1.00  0.00           O  
ATOM    939  OE2 GLU A 192      15.253  -1.177  10.464  1.00  0.00           O  
ATOM    940  H   GLU A 192      13.891  -1.373   7.945  1.00  0.00           H  
ATOM    941  HA  GLU A 192      11.004  -0.990   7.418  1.00  0.00           H  
ATOM    942  HB2 GLU A 192      11.228   0.290   9.594  1.00  0.00           H  
ATOM    943  HB3 GLU A 192      11.731  -1.397   9.695  1.00  0.00           H  
ATOM    944  HG2 GLU A 192      13.942   0.281   8.855  1.00  0.00           H  
ATOM    945  HG3 GLU A 192      13.264   0.861  10.377  1.00  0.00           H  
ATOM    946  N   VAL A 193      11.247   1.191   6.168  1.00  0.00           N  
ATOM    947  CA  VAL A 193      11.379   2.518   5.501  1.00  0.00           C  
ATOM    948  C   VAL A 193      10.055   2.910   4.852  1.00  0.00           C  
ATOM    949  O   VAL A 193       8.996   2.736   5.418  1.00  0.00           O  
ATOM    950  CB  VAL A 193      12.455   2.312   4.430  1.00  0.00           C  
ATOM    951  CG1 VAL A 193      13.772   1.890   5.087  1.00  0.00           C  
ATOM    952  CG2 VAL A 193      12.001   1.221   3.459  1.00  0.00           C  
ATOM    953  H   VAL A 193      10.532   0.573   5.897  1.00  0.00           H  
ATOM    954  HA  VAL A 193      11.695   3.271   6.202  1.00  0.00           H  
ATOM    955  HB  VAL A 193      12.607   3.234   3.890  1.00  0.00           H  
ATOM    956 HG11 VAL A 193      13.987   2.547   5.917  1.00  0.00           H  
ATOM    957 HG12 VAL A 193      13.686   0.874   5.443  1.00  0.00           H  
ATOM    958 HG13 VAL A 193      14.570   1.952   4.362  1.00  0.00           H  
ATOM    959 HG21 VAL A 193      11.810   0.309   4.005  1.00  0.00           H  
ATOM    960 HG22 VAL A 193      11.097   1.538   2.959  1.00  0.00           H  
ATOM    961 HG23 VAL A 193      12.774   1.047   2.725  1.00  0.00           H  
ATOM    962  N   GLU A 194      10.106   3.439   3.666  1.00  0.00           N  
ATOM    963  CA  GLU A 194       8.846   3.834   2.981  1.00  0.00           C  
ATOM    964  C   GLU A 194       9.136   4.209   1.522  1.00  0.00           C  
ATOM    965  O   GLU A 194      10.272   4.376   1.131  1.00  0.00           O  
ATOM    966  CB  GLU A 194       8.334   5.041   3.770  1.00  0.00           C  
ATOM    967  CG  GLU A 194       8.977   6.324   3.235  1.00  0.00           C  
ATOM    968  CD  GLU A 194       8.618   7.495   4.150  1.00  0.00           C  
ATOM    969  OE1 GLU A 194       8.860   7.388   5.340  1.00  0.00           O  
ATOM    970  OE2 GLU A 194       8.106   8.480   3.644  1.00  0.00           O  
ATOM    971  H   GLU A 194      10.970   3.576   3.228  1.00  0.00           H  
ATOM    972  HA  GLU A 194       8.126   3.031   3.031  1.00  0.00           H  
ATOM    973  HB2 GLU A 194       7.262   5.105   3.669  1.00  0.00           H  
ATOM    974  HB3 GLU A 194       8.591   4.920   4.811  1.00  0.00           H  
ATOM    975  HG2 GLU A 194      10.051   6.203   3.207  1.00  0.00           H  
ATOM    976  HG3 GLU A 194       8.612   6.522   2.239  1.00  0.00           H  
ATOM    977  N   ILE A 195       8.119   4.335   0.714  1.00  0.00           N  
ATOM    978  CA  ILE A 195       8.347   4.693  -0.716  1.00  0.00           C  
ATOM    979  C   ILE A 195       7.547   5.944  -1.087  1.00  0.00           C  
ATOM    980  O   ILE A 195       6.758   6.445  -0.309  1.00  0.00           O  
ATOM    981  CB  ILE A 195       7.858   3.487  -1.525  1.00  0.00           C  
ATOM    982  CG1 ILE A 195       6.827   2.694  -0.716  1.00  0.00           C  
ATOM    983  CG2 ILE A 195       9.044   2.581  -1.859  1.00  0.00           C  
ATOM    984  CD1 ILE A 195       6.451   1.423  -1.478  1.00  0.00           C  
ATOM    985  H   ILE A 195       7.208   4.193   1.044  1.00  0.00           H  
ATOM    986  HA  ILE A 195       9.398   4.854  -0.897  1.00  0.00           H  
ATOM    987  HB  ILE A 195       7.406   3.835  -2.443  1.00  0.00           H  
ATOM    988 HG12 ILE A 195       7.248   2.428   0.243  1.00  0.00           H  
ATOM    989 HG13 ILE A 195       5.945   3.297  -0.568  1.00  0.00           H  
ATOM    990 HG21 ILE A 195       9.872   3.183  -2.205  1.00  0.00           H  
ATOM    991 HG22 ILE A 195       9.340   2.036  -0.975  1.00  0.00           H  
ATOM    992 HG23 ILE A 195       8.758   1.884  -2.633  1.00  0.00           H  
ATOM    993 HD11 ILE A 195       6.562   1.593  -2.539  1.00  0.00           H  
ATOM    994 HD12 ILE A 195       7.101   0.615  -1.172  1.00  0.00           H  
ATOM    995 HD13 ILE A 195       5.426   1.163  -1.261  1.00  0.00           H  
ATOM    996  N   VAL A 196       7.745   6.452  -2.273  1.00  0.00           N  
ATOM    997  CA  VAL A 196       6.997   7.669  -2.701  1.00  0.00           C  
ATOM    998  C   VAL A 196       6.688   7.597  -4.199  1.00  0.00           C  
ATOM    999  O   VAL A 196       7.420   8.112  -5.019  1.00  0.00           O  
ATOM   1000  CB  VAL A 196       7.937   8.837  -2.403  1.00  0.00           C  
ATOM   1001  CG1 VAL A 196       7.233  10.157  -2.724  1.00  0.00           C  
ATOM   1002  CG2 VAL A 196       8.324   8.816  -0.921  1.00  0.00           C  
ATOM   1003  H   VAL A 196       8.386   6.031  -2.885  1.00  0.00           H  
ATOM   1004  HA  VAL A 196       6.088   7.773  -2.131  1.00  0.00           H  
ATOM   1005  HB  VAL A 196       8.826   8.748  -3.009  1.00  0.00           H  
ATOM   1006 HG11 VAL A 196       6.587  10.020  -3.580  1.00  0.00           H  
ATOM   1007 HG12 VAL A 196       6.644  10.468  -1.874  1.00  0.00           H  
ATOM   1008 HG13 VAL A 196       7.969  10.914  -2.949  1.00  0.00           H  
ATOM   1009 HG21 VAL A 196       7.449   8.593  -0.326  1.00  0.00           H  
ATOM   1010 HG22 VAL A 196       9.074   8.057  -0.756  1.00  0.00           H  
ATOM   1011 HG23 VAL A 196       8.716   9.780  -0.637  1.00  0.00           H  
ATOM   1012  N   ASP A 197       5.607   6.959  -4.560  1.00  0.00           N  
ATOM   1013  CA  ASP A 197       5.249   6.852  -6.003  1.00  0.00           C  
ATOM   1014  C   ASP A 197       5.521   8.176  -6.721  1.00  0.00           C  
ATOM   1015  O   ASP A 197       5.168   9.236  -6.245  1.00  0.00           O  
ATOM   1016  CB  ASP A 197       3.753   6.533  -6.017  1.00  0.00           C  
ATOM   1017  CG  ASP A 197       2.991   7.633  -5.275  1.00  0.00           C  
ATOM   1018  OD1 ASP A 197       3.437   8.018  -4.207  1.00  0.00           O  
ATOM   1019  OD2 ASP A 197       1.975   8.070  -5.788  1.00  0.00           O  
ATOM   1020  H   ASP A 197       5.030   6.552  -3.880  1.00  0.00           H  
ATOM   1021  HA  ASP A 197       5.799   6.048  -6.469  1.00  0.00           H  
ATOM   1022  HB2 ASP A 197       3.406   6.478  -7.038  1.00  0.00           H  
ATOM   1023  HB3 ASP A 197       3.582   5.586  -5.526  1.00  0.00           H  
ATOM   1024  N   ARG A 198       6.146   8.122  -7.865  1.00  0.00           N  
ATOM   1025  CA  ARG A 198       6.441   9.373  -8.614  1.00  0.00           C  
ATOM   1026  C   ARG A 198       5.847   9.298 -10.024  1.00  0.00           C  
ATOM   1027  O   ARG A 198       6.561   9.247 -11.005  1.00  0.00           O  
ATOM   1028  CB  ARG A 198       7.968   9.451  -8.677  1.00  0.00           C  
ATOM   1029  CG  ARG A 198       8.493  10.191  -7.445  1.00  0.00           C  
ATOM   1030  CD  ARG A 198       8.098  11.668  -7.529  1.00  0.00           C  
ATOM   1031  NE  ARG A 198       8.807  12.320  -6.395  1.00  0.00           N  
ATOM   1032  CZ  ARG A 198      10.103  12.468  -6.434  1.00  0.00           C  
ATOM   1033  NH1 ARG A 198      10.624  13.514  -7.014  1.00  0.00           N  
ATOM   1034  NH2 ARG A 198      10.881  11.570  -5.892  1.00  0.00           N  
ATOM   1035  H   ARG A 198       6.422   7.260  -8.232  1.00  0.00           H  
ATOM   1036  HA  ARG A 198       6.050  10.223  -8.085  1.00  0.00           H  
ATOM   1037  HB2 ARG A 198       8.376   8.451  -8.699  1.00  0.00           H  
ATOM   1038  HB3 ARG A 198       8.265   9.981  -9.568  1.00  0.00           H  
ATOM   1039  HG2 ARG A 198       8.066   9.753  -6.553  1.00  0.00           H  
ATOM   1040  HG3 ARG A 198       9.568  10.110  -7.408  1.00  0.00           H  
ATOM   1041  HD2 ARG A 198       8.421  12.088  -8.472  1.00  0.00           H  
ATOM   1042  HD3 ARG A 198       7.031  11.779  -7.412  1.00  0.00           H  
ATOM   1043  HE  ARG A 198       8.301  12.639  -5.618  1.00  0.00           H  
ATOM   1044 HH11 ARG A 198      10.029  14.204  -7.429  1.00  0.00           H  
ATOM   1045 HH12 ARG A 198      11.617  13.628  -7.044  1.00  0.00           H  
ATOM   1046 HH21 ARG A 198      10.482  10.767  -5.447  1.00  0.00           H  
ATOM   1047 HH22 ARG A 198      11.872  11.683  -5.923  1.00  0.00           H  
ATOM   1048  N   ASP A 199       4.546   9.286 -10.128  1.00  0.00           N  
ATOM   1049  CA  ASP A 199       3.906   9.210 -11.475  1.00  0.00           C  
ATOM   1050  C   ASP A 199       4.668   8.227 -12.367  1.00  0.00           C  
ATOM   1051  O   ASP A 199       5.490   8.614 -13.173  1.00  0.00           O  
ATOM   1052  CB  ASP A 199       3.997  10.628 -12.039  1.00  0.00           C  
ATOM   1053  CG  ASP A 199       2.685  10.985 -12.739  1.00  0.00           C  
ATOM   1054  OD1 ASP A 199       2.034  10.078 -13.233  1.00  0.00           O  
ATOM   1055  OD2 ASP A 199       2.352  12.157 -12.771  1.00  0.00           O  
ATOM   1056  H   ASP A 199       3.989   9.325  -9.325  1.00  0.00           H  
ATOM   1057  HA  ASP A 199       2.873   8.915 -11.384  1.00  0.00           H  
ATOM   1058  HB2 ASP A 199       4.177  11.325 -11.232  1.00  0.00           H  
ATOM   1059  HB3 ASP A 199       4.808  10.682 -12.749  1.00  0.00           H  
ATOM   1060  N   GLY A 200       4.405   6.957 -12.225  1.00  0.00           N  
ATOM   1061  CA  GLY A 200       5.114   5.953 -13.062  1.00  0.00           C  
ATOM   1062  C   GLY A 200       6.413   5.538 -12.369  1.00  0.00           C  
ATOM   1063  O   GLY A 200       6.807   4.389 -12.404  1.00  0.00           O  
ATOM   1064  H   GLY A 200       3.740   6.664 -11.570  1.00  0.00           H  
ATOM   1065  HA2 GLY A 200       4.482   5.085 -13.197  1.00  0.00           H  
ATOM   1066  HA3 GLY A 200       5.345   6.385 -14.022  1.00  0.00           H  
ATOM   1067  N   HIS A 201       7.082   6.464 -11.739  1.00  0.00           N  
ATOM   1068  CA  HIS A 201       8.353   6.121 -11.042  1.00  0.00           C  
ATOM   1069  C   HIS A 201       8.082   5.826  -9.565  1.00  0.00           C  
ATOM   1070  O   HIS A 201       7.033   6.144  -9.041  1.00  0.00           O  
ATOM   1071  CB  HIS A 201       9.233   7.363 -11.189  1.00  0.00           C  
ATOM   1072  CG  HIS A 201      10.532   6.982 -11.845  1.00  0.00           C  
ATOM   1073  ND1 HIS A 201      11.759   7.391 -11.348  1.00  0.00           N  
ATOM   1074  CD2 HIS A 201      10.811   6.227 -12.957  1.00  0.00           C  
ATOM   1075  CE1 HIS A 201      12.711   6.886 -12.154  1.00  0.00           C  
ATOM   1076  NE2 HIS A 201      12.187   6.170 -13.151  1.00  0.00           N  
ATOM   1077  H   HIS A 201       6.749   7.383 -11.720  1.00  0.00           H  
ATOM   1078  HA  HIS A 201       8.823   5.279 -11.516  1.00  0.00           H  
ATOM   1079  HB2 HIS A 201       8.723   8.096 -11.798  1.00  0.00           H  
ATOM   1080  HB3 HIS A 201       9.432   7.780 -10.213  1.00  0.00           H  
ATOM   1081  HD1 HIS A 201      11.908   7.946 -10.554  1.00  0.00           H  
ATOM   1082  HD2 HIS A 201      10.072   5.752 -13.587  1.00  0.00           H  
ATOM   1083  HE1 HIS A 201      13.771   7.044 -12.013  1.00  0.00           H  
ATOM   1084  N   ILE A 202       9.019   5.219  -8.889  1.00  0.00           N  
ATOM   1085  CA  ILE A 202       8.810   4.905  -7.446  1.00  0.00           C  
ATOM   1086  C   ILE A 202      10.134   5.014  -6.683  1.00  0.00           C  
ATOM   1087  O   ILE A 202      11.077   4.296  -6.950  1.00  0.00           O  
ATOM   1088  CB  ILE A 202       8.294   3.466  -7.425  1.00  0.00           C  
ATOM   1089  CG1 ILE A 202       6.801   3.456  -7.765  1.00  0.00           C  
ATOM   1090  CG2 ILE A 202       8.502   2.866  -6.032  1.00  0.00           C  
ATOM   1091  CD1 ILE A 202       6.206   2.091  -7.412  1.00  0.00           C  
ATOM   1092  H   ILE A 202       9.859   4.970  -9.329  1.00  0.00           H  
ATOM   1093  HA  ILE A 202       8.074   5.567  -7.019  1.00  0.00           H  
ATOM   1094  HB  ILE A 202       8.835   2.879  -8.154  1.00  0.00           H  
ATOM   1095 HG12 ILE A 202       6.299   4.227  -7.199  1.00  0.00           H  
ATOM   1096 HG13 ILE A 202       6.671   3.640  -8.820  1.00  0.00           H  
ATOM   1097 HG21 ILE A 202       9.552   2.897  -5.781  1.00  0.00           H  
ATOM   1098 HG22 ILE A 202       7.941   3.436  -5.308  1.00  0.00           H  
ATOM   1099 HG23 ILE A 202       8.162   1.841  -6.027  1.00  0.00           H  
ATOM   1100 HD11 ILE A 202       6.882   1.310  -7.728  1.00  0.00           H  
ATOM   1101 HD12 ILE A 202       6.058   2.028  -6.344  1.00  0.00           H  
ATOM   1102 HD13 ILE A 202       5.257   1.972  -7.914  1.00  0.00           H  
ATOM   1103  N   THR A 203      10.208   5.904  -5.732  1.00  0.00           N  
ATOM   1104  CA  THR A 203      11.467   6.055  -4.948  1.00  0.00           C  
ATOM   1105  C   THR A 203      11.295   5.436  -3.559  1.00  0.00           C  
ATOM   1106  O   THR A 203      10.193   5.192  -3.110  1.00  0.00           O  
ATOM   1107  CB  THR A 203      11.688   7.565  -4.839  1.00  0.00           C  
ATOM   1108  OG1 THR A 203      11.304   8.186  -6.057  1.00  0.00           O  
ATOM   1109  CG2 THR A 203      13.166   7.847  -4.563  1.00  0.00           C  
ATOM   1110  H   THR A 203       9.434   6.471  -5.530  1.00  0.00           H  
ATOM   1111  HA  THR A 203      12.293   5.596  -5.468  1.00  0.00           H  
ATOM   1112  HB  THR A 203      11.092   7.958  -4.030  1.00  0.00           H  
ATOM   1113  HG1 THR A 203      11.434   9.133  -5.961  1.00  0.00           H  
ATOM   1114 HG21 THR A 203      13.530   7.159  -3.815  1.00  0.00           H  
ATOM   1115 HG22 THR A 203      13.733   7.723  -5.472  1.00  0.00           H  
ATOM   1116 HG23 THR A 203      13.277   8.860  -4.204  1.00  0.00           H  
ATOM   1117  N   LEU A 204      12.376   5.179  -2.874  1.00  0.00           N  
ATOM   1118  CA  LEU A 204      12.269   4.576  -1.516  1.00  0.00           C  
ATOM   1119  C   LEU A 204      12.896   5.505  -0.474  1.00  0.00           C  
ATOM   1120  O   LEU A 204      13.941   6.083  -0.691  1.00  0.00           O  
ATOM   1121  CB  LEU A 204      13.047   3.263  -1.599  1.00  0.00           C  
ATOM   1122  CG  LEU A 204      12.269   2.160  -0.880  1.00  0.00           C  
ATOM   1123  CD1 LEU A 204      12.776   0.793  -1.338  1.00  0.00           C  
ATOM   1124  CD2 LEU A 204      12.473   2.298   0.631  1.00  0.00           C  
ATOM   1125  H   LEU A 204      13.258   5.382  -3.252  1.00  0.00           H  
ATOM   1126  HA  LEU A 204      11.237   4.378  -1.273  1.00  0.00           H  
ATOM   1127  HB2 LEU A 204      13.184   2.991  -2.634  1.00  0.00           H  
ATOM   1128  HB3 LEU A 204      14.011   3.386  -1.129  1.00  0.00           H  
ATOM   1129  HG  LEU A 204      11.219   2.251  -1.112  1.00  0.00           H  
ATOM   1130 HD11 LEU A 204      13.775   0.894  -1.738  1.00  0.00           H  
ATOM   1131 HD12 LEU A 204      12.793   0.114  -0.498  1.00  0.00           H  
ATOM   1132 HD13 LEU A 204      12.121   0.405  -2.103  1.00  0.00           H  
ATOM   1133 HD21 LEU A 204      12.768   3.310   0.865  1.00  0.00           H  
ATOM   1134 HD22 LEU A 204      11.550   2.066   1.142  1.00  0.00           H  
ATOM   1135 HD23 LEU A 204      13.244   1.614   0.955  1.00  0.00           H  
ATOM   1136  N   SER A 205      12.262   5.650   0.657  1.00  0.00           N  
ATOM   1137  CA  SER A 205      12.820   6.536   1.716  1.00  0.00           C  
ATOM   1138  C   SER A 205      13.090   5.727   2.985  1.00  0.00           C  
ATOM   1139  O   SER A 205      12.187   5.182   3.590  1.00  0.00           O  
ATOM   1140  CB  SER A 205      11.734   7.583   1.969  1.00  0.00           C  
ATOM   1141  OG  SER A 205      12.108   8.806   1.347  1.00  0.00           O  
ATOM   1142  H   SER A 205      11.420   5.172   0.811  1.00  0.00           H  
ATOM   1143  HA  SER A 205      13.723   7.016   1.372  1.00  0.00           H  
ATOM   1144  HB2 SER A 205      10.801   7.244   1.552  1.00  0.00           H  
ATOM   1145  HB3 SER A 205      11.619   7.730   3.034  1.00  0.00           H  
ATOM   1146  HG  SER A 205      12.805   9.205   1.871  1.00  0.00           H  
ATOM   1147  N   HIS A 206      14.329   5.643   3.390  1.00  0.00           N  
ATOM   1148  CA  HIS A 206      14.661   4.864   4.618  1.00  0.00           C  
ATOM   1149  C   HIS A 206      14.976   5.816   5.776  1.00  0.00           C  
ATOM   1150  O   HIS A 206      15.250   6.983   5.578  1.00  0.00           O  
ATOM   1151  CB  HIS A 206      15.898   4.040   4.252  1.00  0.00           C  
ATOM   1152  CG  HIS A 206      15.790   3.562   2.828  1.00  0.00           C  
ATOM   1153  ND1 HIS A 206      16.841   3.668   1.932  1.00  0.00           N  
ATOM   1154  CD2 HIS A 206      14.763   2.972   2.134  1.00  0.00           C  
ATOM   1155  CE1 HIS A 206      16.428   3.154   0.760  1.00  0.00           C  
ATOM   1156  NE2 HIS A 206      15.168   2.715   0.827  1.00  0.00           N  
ATOM   1157  H   HIS A 206      15.041   6.087   2.885  1.00  0.00           H  
ATOM   1158  HA  HIS A 206      13.846   4.209   4.881  1.00  0.00           H  
ATOM   1159  HB2 HIS A 206      16.782   4.652   4.359  1.00  0.00           H  
ATOM   1160  HB3 HIS A 206      15.970   3.188   4.912  1.00  0.00           H  
ATOM   1161  HD1 HIS A 206      17.726   4.047   2.119  1.00  0.00           H  
ATOM   1162  HD2 HIS A 206      13.789   2.741   2.538  1.00  0.00           H  
ATOM   1163  HE1 HIS A 206      17.041   3.102  -0.128  1.00  0.00           H  
ATOM   1164  N   ASN A 207      14.935   5.325   6.985  1.00  0.00           N  
ATOM   1165  CA  ASN A 207      15.227   6.200   8.157  1.00  0.00           C  
ATOM   1166  C   ASN A 207      16.641   6.780   8.053  1.00  0.00           C  
ATOM   1167  O   ASN A 207      17.556   6.332   8.716  1.00  0.00           O  
ATOM   1168  CB  ASN A 207      15.115   5.280   9.373  1.00  0.00           C  
ATOM   1169  CG  ASN A 207      13.755   5.483  10.045  1.00  0.00           C  
ATOM   1170  OD1 ASN A 207      13.096   6.479   9.818  1.00  0.00           O  
ATOM   1171  ND2 ASN A 207      13.305   4.575  10.865  1.00  0.00           N  
ATOM   1172  H   ASN A 207      14.711   4.381   7.123  1.00  0.00           H  
ATOM   1173  HA  ASN A 207      14.500   6.991   8.226  1.00  0.00           H  
ATOM   1174  HB2 ASN A 207      15.212   4.251   9.056  1.00  0.00           H  
ATOM   1175  HB3 ASN A 207      15.899   5.516  10.077  1.00  0.00           H  
ATOM   1176 HD21 ASN A 207      13.837   3.773  11.048  1.00  0.00           H  
ATOM   1177 HD22 ASN A 207      12.435   4.696  11.300  1.00  0.00           H  
ATOM   1178  N   GLY A 208      16.825   7.777   7.232  1.00  0.00           N  
ATOM   1179  CA  GLY A 208      18.179   8.388   7.095  1.00  0.00           C  
ATOM   1180  C   GLY A 208      18.839   7.904   5.802  1.00  0.00           C  
ATOM   1181  O   GLY A 208      20.048   7.890   5.682  1.00  0.00           O  
ATOM   1182  H   GLY A 208      16.075   8.128   6.710  1.00  0.00           H  
ATOM   1183  HA2 GLY A 208      18.085   9.464   7.071  1.00  0.00           H  
ATOM   1184  HA3 GLY A 208      18.790   8.100   7.936  1.00  0.00           H  
ATOM   1185  N   LYS A 209      18.060   7.508   4.833  1.00  0.00           N  
ATOM   1186  CA  LYS A 209      18.657   7.029   3.553  1.00  0.00           C  
ATOM   1187  C   LYS A 209      17.561   6.759   2.519  1.00  0.00           C  
ATOM   1188  O   LYS A 209      16.641   6.004   2.758  1.00  0.00           O  
ATOM   1189  CB  LYS A 209      19.386   5.734   3.914  1.00  0.00           C  
ATOM   1190  CG  LYS A 209      20.891   5.926   3.721  1.00  0.00           C  
ATOM   1191  CD  LYS A 209      21.631   4.671   4.189  1.00  0.00           C  
ATOM   1192  CE  LYS A 209      21.186   3.473   3.347  1.00  0.00           C  
ATOM   1193  NZ  LYS A 209      22.425   2.676   3.129  1.00  0.00           N  
ATOM   1194  H   LYS A 209      17.087   7.525   4.946  1.00  0.00           H  
ATOM   1195  HA  LYS A 209      19.362   7.752   3.173  1.00  0.00           H  
ATOM   1196  HB2 LYS A 209      19.182   5.482   4.945  1.00  0.00           H  
ATOM   1197  HB3 LYS A 209      19.041   4.936   3.274  1.00  0.00           H  
ATOM   1198  HG2 LYS A 209      21.100   6.099   2.675  1.00  0.00           H  
ATOM   1199  HG3 LYS A 209      21.224   6.774   4.301  1.00  0.00           H  
ATOM   1200  HD2 LYS A 209      22.696   4.817   4.075  1.00  0.00           H  
ATOM   1201  HD3 LYS A 209      21.402   4.483   5.228  1.00  0.00           H  
ATOM   1202  HE2 LYS A 209      20.450   2.890   3.884  1.00  0.00           H  
ATOM   1203  HE3 LYS A 209      20.789   3.804   2.401  1.00  0.00           H  
ATOM   1204  HZ1 LYS A 209      23.231   3.320   2.992  1.00  0.00           H  
ATOM   1205  HZ2 LYS A 209      22.600   2.073   3.958  1.00  0.00           H  
ATOM   1206  HZ3 LYS A 209      22.312   2.079   2.287  1.00  0.00           H  
ATOM   1207  N   ASP A 210      17.654   7.370   1.370  1.00  0.00           N  
ATOM   1208  CA  ASP A 210      16.621   7.150   0.318  1.00  0.00           C  
ATOM   1209  C   ASP A 210      17.270   6.583  -0.948  1.00  0.00           C  
ATOM   1210  O   ASP A 210      18.424   6.839  -1.233  1.00  0.00           O  
ATOM   1211  CB  ASP A 210      16.029   8.533   0.043  1.00  0.00           C  
ATOM   1212  CG  ASP A 210      17.113   9.604   0.194  1.00  0.00           C  
ATOM   1213  OD1 ASP A 210      18.025   9.614  -0.614  1.00  0.00           O  
ATOM   1214  OD2 ASP A 210      17.010  10.396   1.117  1.00  0.00           O  
ATOM   1215  H   ASP A 210      18.404   7.974   1.195  1.00  0.00           H  
ATOM   1216  HA  ASP A 210      15.852   6.484   0.679  1.00  0.00           H  
ATOM   1217  HB2 ASP A 210      15.639   8.560  -0.962  1.00  0.00           H  
ATOM   1218  HB3 ASP A 210      15.232   8.730   0.744  1.00  0.00           H  
ATOM   1219  N   VAL A 211      16.540   5.815  -1.709  1.00  0.00           N  
ATOM   1220  CA  VAL A 211      17.119   5.234  -2.954  1.00  0.00           C  
ATOM   1221  C   VAL A 211      16.107   5.317  -4.099  1.00  0.00           C  
ATOM   1222  O   VAL A 211      14.934   5.556  -3.887  1.00  0.00           O  
ATOM   1223  CB  VAL A 211      17.421   3.775  -2.608  1.00  0.00           C  
ATOM   1224  CG1 VAL A 211      16.111   2.986  -2.534  1.00  0.00           C  
ATOM   1225  CG2 VAL A 211      18.318   3.169  -3.689  1.00  0.00           C  
ATOM   1226  H   VAL A 211      15.613   5.618  -1.463  1.00  0.00           H  
ATOM   1227  HA  VAL A 211      18.031   5.744  -3.220  1.00  0.00           H  
ATOM   1228  HB  VAL A 211      17.922   3.729  -1.652  1.00  0.00           H  
ATOM   1229 HG11 VAL A 211      15.276   3.666  -2.611  1.00  0.00           H  
ATOM   1230 HG12 VAL A 211      16.074   2.274  -3.346  1.00  0.00           H  
ATOM   1231 HG13 VAL A 211      16.062   2.460  -1.592  1.00  0.00           H  
ATOM   1232 HG21 VAL A 211      18.768   3.963  -4.269  1.00  0.00           H  
ATOM   1233 HG22 VAL A 211      19.096   2.581  -3.223  1.00  0.00           H  
ATOM   1234 HG23 VAL A 211      17.728   2.539  -4.337  1.00  0.00           H  
ATOM   1235  N   GLU A 212      16.549   5.123  -5.312  1.00  0.00           N  
ATOM   1236  CA  GLU A 212      15.611   5.194  -6.468  1.00  0.00           C  
ATOM   1237  C   GLU A 212      15.552   3.841  -7.185  1.00  0.00           C  
ATOM   1238  O   GLU A 212      16.299   3.583  -8.107  1.00  0.00           O  
ATOM   1239  CB  GLU A 212      16.197   6.263  -7.391  1.00  0.00           C  
ATOM   1240  CG  GLU A 212      15.068   7.135  -7.943  1.00  0.00           C  
ATOM   1241  CD  GLU A 212      15.345   8.601  -7.609  1.00  0.00           C  
ATOM   1242  OE1 GLU A 212      16.507   8.958  -7.516  1.00  0.00           O  
ATOM   1243  OE2 GLU A 212      14.389   9.344  -7.452  1.00  0.00           O  
ATOM   1244  H   GLU A 212      17.499   4.933  -5.462  1.00  0.00           H  
ATOM   1245  HA  GLU A 212      14.627   5.489  -6.140  1.00  0.00           H  
ATOM   1246  HB2 GLU A 212      16.889   6.878  -6.833  1.00  0.00           H  
ATOM   1247  HB3 GLU A 212      16.716   5.788  -8.209  1.00  0.00           H  
ATOM   1248  HG2 GLU A 212      15.013   7.013  -9.017  1.00  0.00           H  
ATOM   1249  HG3 GLU A 212      14.131   6.837  -7.498  1.00  0.00           H  
ATOM   1250  N   LEU A 213      14.670   2.975  -6.767  1.00  0.00           N  
ATOM   1251  CA  LEU A 213      14.563   1.642  -7.421  1.00  0.00           C  
ATOM   1252  C   LEU A 213      13.829   1.767  -8.759  1.00  0.00           C  
ATOM   1253  O   LEU A 213      13.739   2.834  -9.332  1.00  0.00           O  
ATOM   1254  CB  LEU A 213      13.756   0.789  -6.443  1.00  0.00           C  
ATOM   1255  CG  LEU A 213      12.361   1.392  -6.271  1.00  0.00           C  
ATOM   1256  CD1 LEU A 213      11.380   0.689  -7.210  1.00  0.00           C  
ATOM   1257  CD2 LEU A 213      11.901   1.206  -4.823  1.00  0.00           C  
ATOM   1258  H   LEU A 213      14.077   3.202  -6.019  1.00  0.00           H  
ATOM   1259  HA  LEU A 213      15.542   1.211  -7.565  1.00  0.00           H  
ATOM   1260  HB2 LEU A 213      13.670  -0.214  -6.829  1.00  0.00           H  
ATOM   1261  HB3 LEU A 213      14.255   0.765  -5.487  1.00  0.00           H  
ATOM   1262  HG  LEU A 213      12.393   2.445  -6.509  1.00  0.00           H  
ATOM   1263 HD11 LEU A 213      11.642  -0.357  -7.287  1.00  0.00           H  
ATOM   1264 HD12 LEU A 213      10.378   0.779  -6.818  1.00  0.00           H  
ATOM   1265 HD13 LEU A 213      11.428   1.144  -8.188  1.00  0.00           H  
ATOM   1266 HD21 LEU A 213      12.597   0.564  -4.304  1.00  0.00           H  
ATOM   1267 HD22 LEU A 213      11.863   2.167  -4.331  1.00  0.00           H  
ATOM   1268 HD23 LEU A 213      10.919   0.756  -4.812  1.00  0.00           H  
ATOM   1269  N   LEU A 214      13.304   0.682  -9.261  1.00  0.00           N  
ATOM   1270  CA  LEU A 214      12.575   0.738 -10.561  1.00  0.00           C  
ATOM   1271  C   LEU A 214      11.209   0.057 -10.431  1.00  0.00           C  
ATOM   1272  O   LEU A 214      11.096  -1.030  -9.902  1.00  0.00           O  
ATOM   1273  CB  LEU A 214      13.463  -0.023 -11.546  1.00  0.00           C  
ATOM   1274  CG  LEU A 214      13.867  -1.365 -10.937  1.00  0.00           C  
ATOM   1275  CD1 LEU A 214      14.153  -2.369 -12.055  1.00  0.00           C  
ATOM   1276  CD2 LEU A 214      15.127  -1.179 -10.087  1.00  0.00           C  
ATOM   1277  H   LEU A 214      13.387  -0.169  -8.783  1.00  0.00           H  
ATOM   1278  HA  LEU A 214      12.458   1.761 -10.885  1.00  0.00           H  
ATOM   1279  HB2 LEU A 214      12.918  -0.192 -12.464  1.00  0.00           H  
ATOM   1280  HB3 LEU A 214      14.349   0.557 -11.755  1.00  0.00           H  
ATOM   1281  HG  LEU A 214      13.065  -1.737 -10.316  1.00  0.00           H  
ATOM   1282 HD11 LEU A 214      13.336  -2.364 -12.760  1.00  0.00           H  
ATOM   1283 HD12 LEU A 214      15.067  -2.095 -12.560  1.00  0.00           H  
ATOM   1284 HD13 LEU A 214      14.257  -3.357 -11.633  1.00  0.00           H  
ATOM   1285 HD21 LEU A 214      15.321  -0.125  -9.956  1.00  0.00           H  
ATOM   1286 HD22 LEU A 214      14.982  -1.641  -9.121  1.00  0.00           H  
ATOM   1287 HD23 LEU A 214      15.968  -1.641 -10.584  1.00  0.00           H  
ATOM   1288  N   ASP A 215      10.172   0.689 -10.909  1.00  0.00           N  
ATOM   1289  CA  ASP A 215       8.816   0.077 -10.811  1.00  0.00           C  
ATOM   1290  C   ASP A 215       8.838  -1.349 -11.366  1.00  0.00           C  
ATOM   1291  O   ASP A 215       8.010  -2.171 -11.024  1.00  0.00           O  
ATOM   1292  CB  ASP A 215       7.914   0.971 -11.664  1.00  0.00           C  
ATOM   1293  CG  ASP A 215       6.609   1.243 -10.914  1.00  0.00           C  
ATOM   1294  OD1 ASP A 215       5.820   0.321 -10.786  1.00  0.00           O  
ATOM   1295  OD2 ASP A 215       6.419   2.367 -10.482  1.00  0.00           O  
ATOM   1296  H   ASP A 215      10.285   1.567 -11.332  1.00  0.00           H  
ATOM   1297  HA  ASP A 215       8.475   0.078  -9.788  1.00  0.00           H  
ATOM   1298  HB2 ASP A 215       8.419   1.908 -11.860  1.00  0.00           H  
ATOM   1299  HB3 ASP A 215       7.697   0.476 -12.598  1.00  0.00           H  
ATOM   1300  N   ASP A 216       9.777  -1.649 -12.222  1.00  0.00           N  
ATOM   1301  CA  ASP A 216       9.849  -3.022 -12.799  1.00  0.00           C  
ATOM   1302  C   ASP A 216      10.084  -4.052 -11.690  1.00  0.00           C  
ATOM   1303  O   ASP A 216       9.347  -5.006 -11.547  1.00  0.00           O  
ATOM   1304  CB  ASP A 216      11.039  -2.986 -13.758  1.00  0.00           C  
ATOM   1305  CG  ASP A 216      10.571  -3.356 -15.168  1.00  0.00           C  
ATOM   1306  OD1 ASP A 216      10.591  -4.534 -15.486  1.00  0.00           O  
ATOM   1307  OD2 ASP A 216      10.202  -2.456 -15.902  1.00  0.00           O  
ATOM   1308  H   ASP A 216      10.434  -0.972 -12.485  1.00  0.00           H  
ATOM   1309  HA  ASP A 216       8.946  -3.252 -13.341  1.00  0.00           H  
ATOM   1310  HB2 ASP A 216      11.463  -1.993 -13.768  1.00  0.00           H  
ATOM   1311  HB3 ASP A 216      11.786  -3.695 -13.433  1.00  0.00           H  
ATOM   1312  N   LEU A 217      11.109  -3.866 -10.902  1.00  0.00           N  
ATOM   1313  CA  LEU A 217      11.391  -4.834  -9.804  1.00  0.00           C  
ATOM   1314  C   LEU A 217      10.661  -4.415  -8.525  1.00  0.00           C  
ATOM   1315  O   LEU A 217      10.462  -5.207  -7.626  1.00  0.00           O  
ATOM   1316  CB  LEU A 217      12.905  -4.772  -9.601  1.00  0.00           C  
ATOM   1317  CG  LEU A 217      13.548  -6.041 -10.160  1.00  0.00           C  
ATOM   1318  CD1 LEU A 217      14.377  -5.692 -11.398  1.00  0.00           C  
ATOM   1319  CD2 LEU A 217      14.456  -6.663  -9.097  1.00  0.00           C  
ATOM   1320  H   LEU A 217      11.693  -3.088 -11.034  1.00  0.00           H  
ATOM   1321  HA  LEU A 217      11.099  -5.830 -10.097  1.00  0.00           H  
ATOM   1322  HB2 LEU A 217      13.302  -3.909 -10.115  1.00  0.00           H  
ATOM   1323  HB3 LEU A 217      13.124  -4.694  -8.547  1.00  0.00           H  
ATOM   1324  HG  LEU A 217      12.776  -6.745 -10.432  1.00  0.00           H  
ATOM   1325 HD11 LEU A 217      15.137  -4.973 -11.131  1.00  0.00           H  
ATOM   1326 HD12 LEU A 217      14.846  -6.586 -11.780  1.00  0.00           H  
ATOM   1327 HD13 LEU A 217      13.733  -5.270 -12.155  1.00  0.00           H  
ATOM   1328 HD21 LEU A 217      14.941  -5.878  -8.535  1.00  0.00           H  
ATOM   1329 HD22 LEU A 217      13.865  -7.270  -8.428  1.00  0.00           H  
ATOM   1330 HD23 LEU A 217      15.204  -7.277  -9.577  1.00  0.00           H  
ATOM   1331  N   ALA A 218      10.261  -3.176  -8.438  1.00  0.00           N  
ATOM   1332  CA  ALA A 218       9.543  -2.711  -7.217  1.00  0.00           C  
ATOM   1333  C   ALA A 218       8.348  -3.624  -6.925  1.00  0.00           C  
ATOM   1334  O   ALA A 218       7.827  -3.649  -5.829  1.00  0.00           O  
ATOM   1335  CB  ALA A 218       9.071  -1.295  -7.553  1.00  0.00           C  
ATOM   1336  H   ALA A 218      10.430  -2.551  -9.174  1.00  0.00           H  
ATOM   1337  HA  ALA A 218      10.214  -2.685  -6.372  1.00  0.00           H  
ATOM   1338  HB1 ALA A 218       9.822  -0.797  -8.146  1.00  0.00           H  
ATOM   1339  HB2 ALA A 218       8.148  -1.347  -8.110  1.00  0.00           H  
ATOM   1340  HB3 ALA A 218       8.908  -0.744  -6.639  1.00  0.00           H  
ATOM   1341  N   HIS A 219       7.914  -4.376  -7.898  1.00  0.00           N  
ATOM   1342  CA  HIS A 219       6.756  -5.289  -7.675  1.00  0.00           C  
ATOM   1343  C   HIS A 219       7.244  -6.732  -7.520  1.00  0.00           C  
ATOM   1344  O   HIS A 219       6.747  -7.638  -8.160  1.00  0.00           O  
ATOM   1345  CB  HIS A 219       5.891  -5.146  -8.928  1.00  0.00           C  
ATOM   1346  CG  HIS A 219       4.536  -5.749  -8.673  1.00  0.00           C  
ATOM   1347  ND1 HIS A 219       4.379  -7.037  -8.187  1.00  0.00           N  
ATOM   1348  CD2 HIS A 219       3.268  -5.252  -8.834  1.00  0.00           C  
ATOM   1349  CE1 HIS A 219       3.060  -7.269  -8.072  1.00  0.00           C  
ATOM   1350  NE2 HIS A 219       2.336  -6.213  -8.453  1.00  0.00           N  
ATOM   1351  H   HIS A 219       8.348  -4.342  -8.776  1.00  0.00           H  
ATOM   1352  HA  HIS A 219       6.198  -4.983  -6.805  1.00  0.00           H  
ATOM   1353  HB2 HIS A 219       5.781  -4.099  -9.172  1.00  0.00           H  
ATOM   1354  HB3 HIS A 219       6.364  -5.660  -9.751  1.00  0.00           H  
ATOM   1355  HD1 HIS A 219       5.099  -7.664  -7.964  1.00  0.00           H  
ATOM   1356  HD2 HIS A 219       3.028  -4.264  -9.200  1.00  0.00           H  
ATOM   1357  HE1 HIS A 219       2.636  -8.196  -7.716  1.00  0.00           H  
ATOM   1358  N   THR A 220       8.213  -6.951  -6.675  1.00  0.00           N  
ATOM   1359  CA  THR A 220       8.734  -8.335  -6.478  1.00  0.00           C  
ATOM   1360  C   THR A 220       8.876  -8.639  -4.987  1.00  0.00           C  
ATOM   1361  O   THR A 220       8.247  -9.535  -4.459  1.00  0.00           O  
ATOM   1362  CB  THR A 220      10.104  -8.342  -7.161  1.00  0.00           C  
ATOM   1363  OG1 THR A 220      10.069  -7.489  -8.296  1.00  0.00           O  
ATOM   1364  CG2 THR A 220      10.450  -9.766  -7.598  1.00  0.00           C  
ATOM   1365  H   THR A 220       8.601  -6.207  -6.169  1.00  0.00           H  
ATOM   1366  HA  THR A 220       8.084  -9.052  -6.949  1.00  0.00           H  
ATOM   1367  HB  THR A 220      10.853  -7.991  -6.468  1.00  0.00           H  
ATOM   1368  HG1 THR A 220       9.950  -6.589  -7.987  1.00  0.00           H  
ATOM   1369 HG21 THR A 220       9.701 -10.121  -8.291  1.00  0.00           H  
ATOM   1370 HG22 THR A 220      11.417  -9.769  -8.081  1.00  0.00           H  
ATOM   1371 HG23 THR A 220      10.476 -10.412  -6.733  1.00  0.00           H  
ATOM   1372  N   ILE A 221       9.699  -7.897  -4.306  1.00  0.00           N  
ATOM   1373  CA  ILE A 221       9.891  -8.130  -2.849  1.00  0.00           C  
ATOM   1374  C   ILE A 221       8.569  -7.947  -2.100  1.00  0.00           C  
ATOM   1375  O   ILE A 221       7.761  -7.111  -2.448  1.00  0.00           O  
ATOM   1376  CB  ILE A 221      10.901  -7.068  -2.412  1.00  0.00           C  
ATOM   1377  CG1 ILE A 221      10.216  -5.700  -2.341  1.00  0.00           C  
ATOM   1378  CG2 ILE A 221      12.054  -7.010  -3.416  1.00  0.00           C  
ATOM   1379  CD1 ILE A 221       9.663  -5.316  -3.714  1.00  0.00           C  
ATOM   1380  H   ILE A 221      10.193  -7.181  -4.753  1.00  0.00           H  
ATOM   1381  HA  ILE A 221      10.293  -9.114  -2.672  1.00  0.00           H  
ATOM   1382  HB  ILE A 221      11.289  -7.325  -1.438  1.00  0.00           H  
ATOM   1383 HG12 ILE A 221       9.408  -5.743  -1.627  1.00  0.00           H  
ATOM   1384 HG13 ILE A 221      10.934  -4.961  -2.030  1.00  0.00           H  
ATOM   1385 HG21 ILE A 221      12.180  -7.978  -3.877  1.00  0.00           H  
ATOM   1386 HG22 ILE A 221      11.831  -6.275  -4.177  1.00  0.00           H  
ATOM   1387 HG23 ILE A 221      12.964  -6.733  -2.906  1.00  0.00           H  
ATOM   1388 HD11 ILE A 221      10.439  -5.418  -4.458  1.00  0.00           H  
ATOM   1389 HD12 ILE A 221       8.835  -5.963  -3.963  1.00  0.00           H  
ATOM   1390 HD13 ILE A 221       9.322  -4.292  -3.690  1.00  0.00           H  
ATOM   1391  N   ARG A 222       8.347  -8.717  -1.070  1.00  0.00           N  
ATOM   1392  CA  ARG A 222       7.080  -8.576  -0.296  1.00  0.00           C  
ATOM   1393  C   ARG A 222       7.276  -7.557   0.828  1.00  0.00           C  
ATOM   1394  O   ARG A 222       8.075  -7.753   1.721  1.00  0.00           O  
ATOM   1395  CB  ARG A 222       6.808  -9.968   0.277  1.00  0.00           C  
ATOM   1396  CG  ARG A 222       5.308 -10.263   0.213  1.00  0.00           C  
ATOM   1397  CD  ARG A 222       5.059 -11.433  -0.740  1.00  0.00           C  
ATOM   1398  NE  ARG A 222       5.944 -12.524  -0.246  1.00  0.00           N  
ATOM   1399  CZ  ARG A 222       5.907 -13.702  -0.810  1.00  0.00           C  
ATOM   1400  NH1 ARG A 222       4.820 -14.102  -1.413  1.00  0.00           N  
ATOM   1401  NH2 ARG A 222       6.954 -14.478  -0.772  1.00  0.00           N  
ATOM   1402  H   ARG A 222       9.015  -9.381  -0.801  1.00  0.00           H  
ATOM   1403  HA  ARG A 222       6.272  -8.277  -0.943  1.00  0.00           H  
ATOM   1404  HB2 ARG A 222       7.346 -10.706  -0.299  1.00  0.00           H  
ATOM   1405  HB3 ARG A 222       7.136 -10.004   1.305  1.00  0.00           H  
ATOM   1406  HG2 ARG A 222       4.948 -10.516   1.199  1.00  0.00           H  
ATOM   1407  HG3 ARG A 222       4.786  -9.390  -0.149  1.00  0.00           H  
ATOM   1408  HD2 ARG A 222       4.022 -11.739  -0.697  1.00  0.00           H  
ATOM   1409  HD3 ARG A 222       5.331 -11.165  -1.749  1.00  0.00           H  
ATOM   1410  HE  ARG A 222       6.556 -12.360   0.501  1.00  0.00           H  
ATOM   1411 HH11 ARG A 222       4.017 -13.506  -1.442  1.00  0.00           H  
ATOM   1412 HH12 ARG A 222       4.791 -15.003  -1.845  1.00  0.00           H  
ATOM   1413 HH21 ARG A 222       7.787 -14.172  -0.310  1.00  0.00           H  
ATOM   1414 HH22 ARG A 222       6.925 -15.380  -1.203  1.00  0.00           H  
ATOM   1415  N   ILE A 223       6.562  -6.465   0.789  1.00  0.00           N  
ATOM   1416  CA  ILE A 223       6.728  -5.436   1.856  1.00  0.00           C  
ATOM   1417  C   ILE A 223       5.383  -5.125   2.520  1.00  0.00           C  
ATOM   1418  O   ILE A 223       4.340  -5.541   2.056  1.00  0.00           O  
ATOM   1419  CB  ILE A 223       7.296  -4.200   1.137  1.00  0.00           C  
ATOM   1420  CG1 ILE A 223       6.163  -3.267   0.699  1.00  0.00           C  
ATOM   1421  CG2 ILE A 223       8.085  -4.636  -0.097  1.00  0.00           C  
ATOM   1422  CD1 ILE A 223       6.272  -1.950   1.468  1.00  0.00           C  
ATOM   1423  H   ILE A 223       5.928  -6.318   0.056  1.00  0.00           H  
ATOM   1424  HA  ILE A 223       7.434  -5.781   2.595  1.00  0.00           H  
ATOM   1425  HB  ILE A 223       7.955  -3.670   1.810  1.00  0.00           H  
ATOM   1426 HG12 ILE A 223       6.250  -3.072  -0.361  1.00  0.00           H  
ATOM   1427 HG13 ILE A 223       5.208  -3.724   0.901  1.00  0.00           H  
ATOM   1428 HG21 ILE A 223       8.569  -5.582   0.099  1.00  0.00           H  
ATOM   1429 HG22 ILE A 223       7.410  -4.744  -0.934  1.00  0.00           H  
ATOM   1430 HG23 ILE A 223       8.830  -3.891  -0.330  1.00  0.00           H  
ATOM   1431 HD11 ILE A 223       7.283  -1.830   1.830  1.00  0.00           H  
ATOM   1432 HD12 ILE A 223       6.024  -1.128   0.813  1.00  0.00           H  
ATOM   1433 HD13 ILE A 223       5.590  -1.965   2.304  1.00  0.00           H  
ATOM   1434  N   GLU A 224       5.404  -4.394   3.600  1.00  0.00           N  
ATOM   1435  CA  GLU A 224       4.130  -4.052   4.295  1.00  0.00           C  
ATOM   1436  C   GLU A 224       4.261  -2.698   4.996  1.00  0.00           C  
ATOM   1437  O   GLU A 224       5.209  -1.968   4.784  1.00  0.00           O  
ATOM   1438  CB  GLU A 224       3.926  -5.170   5.318  1.00  0.00           C  
ATOM   1439  CG  GLU A 224       5.231  -5.406   6.082  1.00  0.00           C  
ATOM   1440  CD  GLU A 224       4.955  -5.369   7.587  1.00  0.00           C  
ATOM   1441  OE1 GLU A 224       3.915  -5.861   7.992  1.00  0.00           O  
ATOM   1442  OE2 GLU A 224       5.790  -4.849   8.309  1.00  0.00           O  
ATOM   1443  H   GLU A 224       6.257  -4.069   3.954  1.00  0.00           H  
ATOM   1444  HA  GLU A 224       3.310  -4.038   3.595  1.00  0.00           H  
ATOM   1445  HB2 GLU A 224       3.148  -4.884   6.012  1.00  0.00           H  
ATOM   1446  HB3 GLU A 224       3.640  -6.077   4.808  1.00  0.00           H  
ATOM   1447  HG2 GLU A 224       5.635  -6.371   5.814  1.00  0.00           H  
ATOM   1448  HG3 GLU A 224       5.942  -4.634   5.830  1.00  0.00           H  
ATOM   1449  N   GLU A 225       3.319  -2.357   5.829  1.00  0.00           N  
ATOM   1450  CA  GLU A 225       3.390  -1.048   6.542  1.00  0.00           C  
ATOM   1451  C   GLU A 225       4.135  -1.210   7.870  1.00  0.00           C  
ATOM   1452  O   GLU A 225       4.096  -2.251   8.493  1.00  0.00           O  
ATOM   1453  CB  GLU A 225       1.936  -0.651   6.788  1.00  0.00           C  
ATOM   1454  CG  GLU A 225       1.407   0.123   5.579  1.00  0.00           C  
ATOM   1455  CD  GLU A 225      -0.117   0.006   5.523  1.00  0.00           C  
ATOM   1456  OE1 GLU A 225      -0.647  -0.886   6.163  1.00  0.00           O  
ATOM   1457  OE2 GLU A 225      -0.728   0.812   4.839  1.00  0.00           O  
ATOM   1458  H   GLU A 225       2.561  -2.958   5.988  1.00  0.00           H  
ATOM   1459  HA  GLU A 225       3.875  -0.309   5.925  1.00  0.00           H  
ATOM   1460  HB2 GLU A 225       1.339  -1.541   6.935  1.00  0.00           H  
ATOM   1461  HB3 GLU A 225       1.876  -0.028   7.668  1.00  0.00           H  
ATOM   1462  HG2 GLU A 225       1.687   1.163   5.669  1.00  0.00           H  
ATOM   1463  HG3 GLU A 225       1.832  -0.287   4.676  1.00  0.00           H  
ATOM   1464  N   LEU A 226       4.814  -0.184   8.308  1.00  0.00           N  
ATOM   1465  CA  LEU A 226       5.560  -0.278   9.594  1.00  0.00           C  
ATOM   1466  C   LEU A 226       4.588  -0.203  10.776  1.00  0.00           C  
ATOM   1467  O   LEU A 226       3.393  -0.236  10.536  1.00  0.00           O  
ATOM   1468  CB  LEU A 226       6.501   0.928   9.596  1.00  0.00           C  
ATOM   1469  CG  LEU A 226       7.563   0.747  10.682  1.00  0.00           C  
ATOM   1470  CD1 LEU A 226       8.945   0.661  10.033  1.00  0.00           C  
ATOM   1471  CD2 LEU A 226       7.521   1.942  11.637  1.00  0.00           C  
ATOM   1472  OXT LEU A 226       5.057  -0.114  11.898  1.00  0.00           O  
ATOM   1473  H   LEU A 226       4.832   0.647   7.791  1.00  0.00           H  
ATOM   1474  HA  LEU A 226       6.131  -1.191   9.633  1.00  0.00           H  
ATOM   1475  HB2 LEU A 226       6.979   1.011   8.631  1.00  0.00           H  
ATOM   1476  HB3 LEU A 226       5.935   1.825   9.795  1.00  0.00           H  
ATOM   1477  HG  LEU A 226       7.365  -0.163  11.229  1.00  0.00           H  
ATOM   1478 HD11 LEU A 226       8.836   0.568   8.964  1.00  0.00           H  
ATOM   1479 HD12 LEU A 226       9.506   1.556  10.261  1.00  0.00           H  
ATOM   1480 HD13 LEU A 226       9.471  -0.200  10.419  1.00  0.00           H  
ATOM   1481 HD21 LEU A 226       6.907   2.722  11.211  1.00  0.00           H  
ATOM   1482 HD22 LEU A 226       7.103   1.632  12.584  1.00  0.00           H  
ATOM   1483 HD23 LEU A 226       8.523   2.316  11.790  1.00  0.00           H  
TER    1484      LEU A 226                                                      
END
MOLECULE T0462_1_74.pdb
ATOM      1  C   MET     1       3.518  -5.525  -1.015  1.00 72.54           C 
ATOM      2  O   MET     1       4.514  -5.922  -0.421  1.00 61.43           O 
ATOM      3  N   MET     1       1.797  -7.249  -0.416  1.00 62.03           N 
ATOM      4  CA  MET     1       2.106  -5.791  -0.468  1.00  1.42           C 
ATOM      5  CB  MET     1       1.945  -5.166   0.931  1.00  3.15           C 
ATOM      6  CG  MET     1       2.652  -3.826   1.103  1.00 20.23           C 
ATOM      7  SD  MET     1       2.005  -2.537   0.021  1.00  4.24           S 
ATOM      8  CE  MET     1       0.587  -1.980   0.962  1.00 12.22           C 
ATOM      9 1H   MET     1       2.447  -7.731   0.242  1.00 36.29           H 
ATOM     10 2H   MET     1       1.909  -7.674  -1.357  1.00 36.29           H 
ATOM     11 3H   MET     1       0.818  -7.396  -0.095  1.00 36.29           H 
ATOM     12  HA  MET     1       1.390  -5.330  -1.136  1.00  4.22           H 
ATOM     13 3HB  MET     1       2.337  -5.854   1.668  1.00 36.29           H 
ATOM     14 2HB  MET     1       0.892  -5.015   1.123  1.00 36.29           H 
ATOM     15 3HG  MET     1       3.702  -3.962   0.888  1.00 36.29           H 
ATOM     16 2HG  MET     1       2.538  -3.502   2.127  1.00 36.29           H 
ATOM     17 1HE  MET     1      -0.112  -2.794   1.079  1.00 36.29           H 
ATOM     18 2HE  MET     1       0.108  -1.165   0.439  1.00 36.29           H 
ATOM     19 3HE  MET     1       0.911  -1.640   1.935  1.00 36.29           H 
ATOM     20  N   LYS     2       3.591  -4.846  -2.158  1.00  4.01           N 
ATOM     21  CA  LYS     2       4.874  -4.436  -2.746  1.00 14.04           C 
ATOM     22  C   LYS     2       5.042  -2.911  -2.669  1.00 71.54           C 
ATOM     23  O   LYS     2       4.069  -2.166  -2.787  1.00  5.03           O 
ATOM     24  CB  LYS     2       4.982  -4.912  -4.207  1.00 41.30           C 
ATOM     25  CG  LYS     2       5.651  -6.277  -4.378  1.00 35.55           C 
ATOM     26  CD  LYS     2       4.888  -7.412  -3.703  1.00 24.21           C 
ATOM     27  CE  LYS     2       5.601  -8.746  -3.913  1.00 54.20           C 
ATOM     28  NZ  LYS     2       4.888  -9.880  -3.264  1.00 23.11           N 
ATOM     29  H   LYS     2       2.763  -4.602  -2.617  1.00 36.29           H 
ATOM     30  HA  LYS     2       5.666  -4.897  -2.168  1.00 52.45           H 
ATOM     31 3HB  LYS     2       5.556  -4.188  -4.770  1.00 36.29           H 
ATOM     32 2HB  LYS     2       3.989  -4.969  -4.631  1.00 36.29           H 
ATOM     33 3HG  LYS     2       6.647  -6.227  -3.957  1.00 36.29           H 
ATOM     34 2HG  LYS     2       5.724  -6.494  -5.433  1.00 36.29           H 
ATOM     35 3HD  LYS     2       3.895  -7.473  -4.126  1.00 36.29           H 
ATOM     36 2HD  LYS     2       4.822  -7.212  -2.644  1.00 36.29           H 
ATOM     37 3HE  LYS     2       6.597  -8.675  -3.499  1.00 36.29           H 
ATOM     38 2HE  LYS     2       5.669  -8.940  -4.973  1.00 36.29           H 
ATOM     39 1HZ  LYS     2       4.773  -9.696  -2.246  1.00 36.29           H 
ATOM     40 2HZ  LYS     2       5.434 -10.759  -3.385  1.00 36.29           H 
ATOM     41 3HZ  LYS     2       3.951 -10.007  -3.690  1.00 36.29           H 
ATOM     42  N   LEU     3       6.279  -2.445  -2.492  1.00 54.05           N 
ATOM     43  CA  LEU     3       6.551  -1.006  -2.322  1.00 12.34           C 
ATOM     44  C   LEU     3       6.221  -0.190  -3.591  1.00 75.43           C 
ATOM     45  O   LEU     3       6.193   1.039  -3.556  1.00 30.52           O 
ATOM     46  CB  LEU     3       8.016  -0.794  -1.890  1.00 44.12           C 
ATOM     47  CG  LEU     3       9.093  -1.161  -2.934  1.00 51.02           C 
ATOM     48  CD1 LEU     3       9.466   0.048  -3.795  1.00 31.15           C 
ATOM     49  CD2 LEU     3      10.332  -1.742  -2.258  1.00 12.10           C 
ATOM     50  H   LEU     3       7.028  -3.081  -2.468  1.00 36.29           H 
ATOM     51  HA  LEU     3       5.909  -0.654  -1.524  1.00 75.20           H 
ATOM     52 3HB  LEU     3       8.188  -1.389  -1.004  1.00 36.29           H 
ATOM     53 2HB  LEU     3       8.140   0.246  -1.624  1.00 36.29           H 
ATOM     54  HG  LEU     3       8.695  -1.919  -3.597  1.00 53.15           H 
ATOM     55 1HD1 LEU     3       9.859   0.832  -3.164  1.00 36.29           H 
ATOM     56 2HD1 LEU     3       8.590   0.408  -4.313  1.00 36.29           H 
ATOM     57 3HD1 LEU     3      10.216  -0.241  -4.517  1.00 36.29           H 
ATOM     58 1HD2 LEU     3      11.058  -2.020  -3.009  1.00 36.29           H 
ATOM     59 2HD2 LEU     3      10.056  -2.616  -1.686  1.00 36.29           H 
ATOM     60 3HD2 LEU     3      10.765  -1.004  -1.598  1.00 36.29           H 
ATOM     61  N   SER     4       5.945  -0.883  -4.701  1.00  4.23           N 
ATOM     62  CA  SER     4       5.589  -0.227  -5.974  1.00 32.21           C 
ATOM     63  C   SER     4       4.229   0.480  -5.900  1.00 20.35           C 
ATOM     64  O   SER     4       3.854   1.213  -6.814  1.00 13.44           O 
ATOM     65  CB  SER     4       5.543  -1.258  -7.115  1.00 23.31           C 
ATOM     66  OG  SER     4       4.601  -2.291  -6.849  1.00 33.45           O 
ATOM     67  H   SER     4       5.981  -1.860  -4.667  1.00 36.29           H 
ATOM     68  HA  SER     4       6.351   0.505  -6.197  1.00  2.13           H 
ATOM     69 3HB  SER     4       6.518  -1.702  -7.235  1.00 36.29           H 
ATOM     70 2HB  SER     4       5.263  -0.764  -8.033  1.00 36.29           H 
ATOM     71  HG  SER     4       4.753  -3.024  -7.464  1.00 23.50           H 
ATOM     72  N   ARG     5       3.493   0.245  -4.816  1.00 74.24           N 
ATOM     73  CA  ARG     5       2.136   0.783  -4.660  1.00 65.23           C 
ATOM     74  C   ARG     5       1.911   1.351  -3.250  1.00 50.53           C 
ATOM     75  O   ARG     5       0.779   1.617  -2.853  1.00  3.14           O 
ATOM     76  CB  ARG     5       1.136  -0.345  -4.937  1.00 32.44           C 
ATOM     77  CG  ARG     5       1.216  -1.485  -3.918  1.00 60.24           C 
ATOM     78  CD  ARG     5       0.735  -2.805  -4.499  1.00 44.11           C 
ATOM     79  NE  ARG     5       1.633  -3.289  -5.550  1.00 13.55           N 
ATOM     80  CZ  ARG     5       1.739  -4.539  -5.905  1.00 12.44           C 
ATOM     81  NH1 ARG     5       0.990  -5.444  -5.364  1.00 63.34           N 
ATOM     82  NH2 ARG     5       2.586  -4.888  -6.812  1.00 21.53           N 
ATOM     83  H   ARG     5       3.864  -0.317  -4.107  1.00 36.29           H 
ATOM     84  HA  ARG     5       1.992   1.572  -5.386  1.00 64.21           H 
ATOM     85 3HB  ARG     5       1.332  -0.751  -5.919  1.00 36.29           H 
ATOM     86 2HB  ARG     5       0.133   0.062  -4.919  1.00 36.29           H 
ATOM     87 3HG  ARG     5       0.606  -1.234  -3.062  1.00 36.29           H 
ATOM     88 2HG  ARG     5       2.244  -1.601  -3.602  1.00 36.29           H 
ATOM     89 3HD  ARG     5      -0.252  -2.667  -4.916  1.00 36.29           H 
ATOM     90 2HD  ARG     5       0.692  -3.538  -3.704  1.00 36.29           H 
ATOM     91  HE  ARG     5       2.201  -2.632  -5.999  1.00 75.30           H 
ATOM     92 1HH1 ARG     5       0.323  -5.193  -4.674  1.00 36.29           H 
ATOM     93 2HH1 ARG     5       1.098  -6.403  -5.639  1.00 36.29           H 
ATOM     94 1HH2 ARG     5       3.168  -4.207  -7.248  1.00 36.29           H 
ATOM     95 2HH2 ARG     5       2.657  -5.850  -7.075  1.00 36.29           H 
ATOM     96  N   LEU     6       2.994   1.542  -2.504  1.00 24.41           N 
ATOM     97  CA  LEU     6       2.903   1.977  -1.106  1.00 73.40           C 
ATOM     98  C   LEU     6       2.620   3.487  -1.005  1.00 51.45           C 
ATOM     99  O   LEU     6       3.285   4.299  -1.650  1.00 72.11           O 
ATOM    100  CB  LEU     6       4.204   1.628  -0.365  1.00 50.13           C 
ATOM    101  CG  LEU     6       4.178   1.842   1.158  1.00 51.54           C 
ATOM    102  CD1 LEU     6       3.193   0.885   1.826  1.00 34.05           C 
ATOM    103  CD2 LEU     6       5.578   1.679   1.747  1.00 44.04           C 
ATOM    104  H   LEU     6       3.878   1.408  -2.906  1.00 36.29           H 
ATOM    105  HA  LEU     6       2.084   1.437  -0.646  1.00 14.43           H 
ATOM    106 3HB  LEU     6       5.001   2.232  -0.778  1.00 36.29           H 
ATOM    107 2HB  LEU     6       4.434   0.589  -0.557  1.00 36.29           H 
ATOM    108  HG  LEU     6       3.846   2.847   1.364  1.00 12.14           H 
ATOM    109 1HD1 LEU     6       3.477  -0.136   1.615  1.00 36.29           H 
ATOM    110 2HD1 LEU     6       2.198   1.068   1.446  1.00 36.29           H 
ATOM    111 3HD1 LEU     6       3.202   1.047   2.895  1.00 36.29           H 
ATOM    112 1HD2 LEU     6       6.248   2.391   1.286  1.00 36.29           H 
ATOM    113 2HD2 LEU     6       5.935   0.676   1.561  1.00 36.29           H 
ATOM    114 3HD2 LEU     6       5.545   1.855   2.812  1.00 36.29           H 
ATOM    115  N   VAL     7       1.629   3.852  -0.188  1.00 44.11           N 
ATOM    116  CA  VAL     7       1.229   5.255  -0.013  1.00 52.30           C 
ATOM    117  C   VAL     7       2.399   6.130   0.495  1.00 41.41           C 
ATOM    118  O   VAL     7       2.938   5.888   1.576  1.00 15.11           O 
ATOM    119  CB  VAL     7       0.034   5.378   0.975  1.00 14.11           C 
ATOM    120  CG1 VAL     7      -0.397   6.838   1.141  1.00 51.14           C 
ATOM    121  CG2 VAL     7      -1.143   4.512   0.514  1.00 52.40           C 
ATOM    122  H   VAL     7       1.148   3.158   0.308  1.00 36.29           H 
ATOM    123  HA  VAL     7       0.906   5.628  -0.977  1.00 34.04           H 
ATOM    124  HB  VAL     7       0.357   5.016   1.940  1.00 41.14           H 
ATOM    125 1HG1 VAL     7       0.428   7.416   1.532  1.00 36.29           H 
ATOM    126 2HG1 VAL     7      -1.230   6.895   1.828  1.00 36.29           H 
ATOM    127 3HG1 VAL     7      -0.695   7.239   0.183  1.00 36.29           H 
ATOM    128 1HG2 VAL     7      -1.458   4.821  -0.472  1.00 36.29           H 
ATOM    129 2HG2 VAL     7      -1.969   4.620   1.205  1.00 36.29           H 
ATOM    130 3HG2 VAL     7      -0.837   3.475   0.483  1.00 36.29           H 
ATOM    131  N   PRO     8       2.802   7.162  -0.282  1.00 23.31           N 
ATOM    132  CA  PRO     8       3.902   8.073   0.102  1.00 61.14           C 
ATOM    133  C   PRO     8       3.752   8.648   1.526  1.00 24.12           C 
ATOM    134  O   PRO     8       2.852   9.448   1.798  1.00 15.04           O 
ATOM    135  CB  PRO     8       3.814   9.190  -0.945  1.00 34.35           C 
ATOM    136  CG  PRO     8       3.204   8.534  -2.139  1.00 22.30           C 
ATOM    137  CD  PRO     8       2.231   7.517  -1.600  1.00  0.40           C 
ATOM    138  HA  PRO     8       4.861   7.578   0.020  1.00 12.00           H 
ATOM    139 3HB  PRO     8       4.805   9.565  -1.163  1.00 36.29           H 
ATOM    140 2HB  PRO     8       3.192   9.995  -0.574  1.00 36.29           H 
ATOM    141 3HG  PRO     8       3.972   8.047  -2.723  1.00 36.29           H 
ATOM    142 2HG  PRO     8       2.688   9.271  -2.741  1.00 36.29           H 
ATOM    143 3HD  PRO     8       2.188   6.653  -2.248  1.00 36.29           H 
ATOM    144 2HD  PRO     8       1.247   7.955  -1.487  1.00 36.29           H 
ATOM    145  N   GLY     9       4.646   8.240   2.428  1.00 12.24           N 
ATOM    146  CA  GLY     9       4.576   8.671   3.823  1.00 71.12           C 
ATOM    147  C   GLY     9       4.364   7.512   4.795  1.00 14.14           C 
ATOM    148  O   GLY     9       4.726   7.604   5.970  1.00 53.41           O 
ATOM    149  H   GLY     9       5.370   7.646   2.142  1.00 36.29           H 
ATOM    150 3HA  GLY     9       3.761   9.374   3.939  1.00 36.29           H 
ATOM    151 2HA  GLY     9       5.501   9.170   4.077  1.00 36.29           H 
ATOM    152  N   VAL    10       3.778   6.423   4.305  1.00 64.52           N 
ATOM    153  CA  VAL    10       3.529   5.234   5.129  1.00 45.04           C 
ATOM    154  C   VAL    10       4.758   4.303   5.157  1.00 22.22           C 
ATOM    155  O   VAL    10       5.238   3.867   4.110  1.00 13.40           O 
ATOM    156  CB  VAL    10       2.297   4.444   4.613  1.00 32.21           C 
ATOM    157  CG1 VAL    10       2.049   3.193   5.455  1.00 62.22           C 
ATOM    158  CG2 VAL    10       1.055   5.336   4.592  1.00 12.32           C 
ATOM    159  H   VAL    10       3.505   6.412   3.362  1.00 36.29           H 
ATOM    160  HA  VAL    10       3.317   5.568   6.137  1.00 21.15           H 
ATOM    161  HB  VAL    10       2.500   4.129   3.598  1.00 63.25           H 
ATOM    162 1HG1 VAL    10       2.906   2.536   5.390  1.00 36.29           H 
ATOM    163 2HG1 VAL    10       1.175   2.678   5.086  1.00 36.29           H 
ATOM    164 3HG1 VAL    10       1.891   3.477   6.486  1.00 36.29           H 
ATOM    165 1HG2 VAL    10       1.226   6.180   3.939  1.00 36.29           H 
ATOM    166 2HG2 VAL    10       0.848   5.693   5.591  1.00 36.29           H 
ATOM    167 3HG2 VAL    10       0.208   4.769   4.231  1.00 36.29           H 
ATOM    168  N   PRO    11       5.292   3.994   6.358  1.00 14.03           N 
ATOM    169  CA  PRO    11       6.452   3.097   6.503  1.00  4.53           C 
ATOM    170  C   PRO    11       6.083   1.603   6.412  1.00 14.25           C 
ATOM    171  O   PRO    11       5.083   1.156   6.985  1.00  4.44           O 
ATOM    172  CB  PRO    11       6.970   3.443   7.903  1.00  4.12           C 
ATOM    173  CG  PRO    11       5.750   3.846   8.664  1.00 24.22           C 
ATOM    174  CD  PRO    11       4.824   4.503   7.666  1.00 63.44           C 
ATOM    175  HA  PRO    11       7.216   3.321   5.770  1.00 72.10           H 
ATOM    176 3HB  PRO    11       7.681   4.255   7.839  1.00 36.29           H 
ATOM    177 2HB  PRO    11       7.448   2.577   8.344  1.00 36.29           H 
ATOM    178 3HG  PRO    11       6.016   4.544   9.446  1.00 36.29           H 
ATOM    179 2HG  PRO    11       5.278   2.971   9.091  1.00 36.29           H 
ATOM    180 3HD  PRO    11       4.918   5.580   7.713  1.00 36.29           H 
ATOM    181 2HD  PRO    11       3.801   4.208   7.848  1.00 36.29           H 
ATOM    182  N   ALA    12       6.901   0.833   5.695  1.00 41.23           N 
ATOM    183  CA  ALA    12       6.690  -0.613   5.558  1.00 13.34           C 
ATOM    184  C   ALA    12       7.997  -1.397   5.764  1.00  4.20           C 
ATOM    185  O   ALA    12       9.063  -0.956   5.350  1.00 53.40           O 
ATOM    186  CB  ALA    12       6.088  -0.931   4.194  1.00 41.20           C 
ATOM    187  H   ALA    12       7.663   1.249   5.235  1.00 36.29           H 
ATOM    188  HA  ALA    12       5.982  -0.919   6.316  1.00 70.54           H 
ATOM    189 1HB  ALA    12       5.158  -0.392   4.074  1.00 36.29           H 
ATOM    190 2HB  ALA    12       5.896  -1.992   4.123  1.00 36.29           H 
ATOM    191 3HB  ALA    12       6.777  -0.637   3.414  1.00 36.29           H 
ATOM    192  N   ARG    13       7.913  -2.563   6.401  1.00 12.42           N 
ATOM    193  CA  ARG    13       9.106  -3.379   6.672  1.00 30.40           C 
ATOM    194  C   ARG    13       9.311  -4.451   5.585  1.00 42.44           C 
ATOM    195  O   ARG    13       8.356  -5.085   5.137  1.00 71.15           O 
ATOM    196  CB  ARG    13       8.995  -4.049   8.052  1.00 72.24           C 
ATOM    197  CG  ARG    13      10.269  -4.777   8.486  1.00 32.23           C 
ATOM    198  CD  ARG    13      10.105  -5.477   9.834  1.00 34.44           C 
ATOM    199  NE  ARG    13       9.133  -6.570   9.779  1.00  2.45           N 
ATOM    200  CZ  ARG    13       9.006  -7.486  10.701  1.00 54.22           C 
ATOM    201  NH1 ARG    13       9.728  -7.455  11.775  1.00 63.05           N 
ATOM    202  NH2 ARG    13       8.138  -8.429  10.548  1.00 72.55           N 
ATOM    203  H   ARG    13       7.037  -2.881   6.699  1.00 36.29           H 
ATOM    204  HA  ARG    13       9.964  -2.722   6.673  1.00 11.40           H 
ATOM    205 3HB  ARG    13       8.186  -4.765   8.031  1.00 36.29           H 
ATOM    206 2HB  ARG    13       8.770  -3.290   8.790  1.00 36.29           H 
ATOM    207 3HG  ARG    13      11.071  -4.056   8.562  1.00 36.29           H 
ATOM    208 2HG  ARG    13      10.522  -5.516   7.739  1.00 36.29           H 
ATOM    209 3HD  ARG    13       9.774  -4.752  10.565  1.00 36.29           H 
ATOM    210 2HD  ARG    13      11.064  -5.876  10.137  1.00 36.29           H 
ATOM    211  HE  ARG    13       8.548  -6.622   8.997  1.00 22.44           H 
ATOM    212 1HH1 ARG    13      10.393  -6.725  11.911  1.00 36.29           H 
ATOM    213 2HH1 ARG    13       9.621  -8.166  12.464  1.00 36.29           H 
ATOM    214 1HH2 ARG    13       7.567  -8.450   9.727  1.00 36.29           H 
ATOM    215 2HH2 ARG    13       8.039  -9.133  11.247  1.00 36.29           H 
ATOM    216  N   ILE    14      10.561  -4.637   5.169  1.00  2.55           N 
ATOM    217  CA  ILE    14      10.908  -5.622   4.137  1.00 71.42           C 
ATOM    218  C   ILE    14      10.714  -7.064   4.644  1.00 32.34           C 
ATOM    219  O   ILE    14      11.498  -7.544   5.470  1.00 73.21           O 
ATOM    220  CB  ILE    14      12.389  -5.463   3.688  1.00  2.42           C 
ATOM    221  CG1 ILE    14      12.711  -4.005   3.309  1.00  2.21           C 
ATOM    222  CG2 ILE    14      12.702  -6.398   2.519  1.00 12.31           C 
ATOM    223  CD1 ILE    14      11.972  -3.496   2.095  1.00 64.15           C 
ATOM    224  H   ILE    14      11.275  -4.094   5.564  1.00 36.29           H 
ATOM    225  HA  ILE    14      10.269  -5.456   3.280  1.00 32.01           H 
ATOM    226  HB  ILE    14      13.020  -5.753   4.517  1.00 63.30           H 
ATOM    227 3HG1 ILE    14      13.770  -3.920   3.110  1.00 36.29           H 
ATOM    228 2HG1 ILE    14      12.456  -3.363   4.137  1.00 36.29           H 
ATOM    229 1HG2 ILE    14      13.728  -6.259   2.211  1.00 36.29           H 
ATOM    230 2HG2 ILE    14      12.045  -6.174   1.692  1.00 36.29           H 
ATOM    231 3HG2 ILE    14      12.555  -7.422   2.829  1.00 36.29           H 
ATOM    232 1HD1 ILE    14      12.188  -4.129   1.247  1.00 36.29           H 
ATOM    233 2HD1 ILE    14      12.290  -2.487   1.880  1.00 36.29           H 
ATOM    234 3HD1 ILE    14      10.910  -3.504   2.288  1.00 36.29           H 
ATOM    235  N   LYS    15       9.680  -7.754   4.151  1.00 65.45           N 
ATOM    236  CA  LYS    15       9.479  -9.174   4.480  1.00  5.15           C 
ATOM    237  C   LYS    15      10.547 -10.041   3.798  1.00  4.03           C 
ATOM    238  O   LYS    15      11.325 -10.733   4.452  1.00 71.41           O 
ATOM    239  CB  LYS    15       8.097  -9.690   4.028  1.00  1.11           C 
ATOM    240  CG  LYS    15       6.882  -9.032   4.682  1.00 65.44           C 
ATOM    241  CD  LYS    15       5.621  -9.866   4.421  1.00 23.12           C 
ATOM    242  CE  LYS    15       4.339  -9.190   4.899  1.00 73.24           C 
ATOM    243  NZ  LYS    15       3.909  -8.093   3.990  1.00 33.12           N 
ATOM    244  H   LYS    15       9.045  -7.304   3.555  1.00 36.29           H 
ATOM    245  HA  LYS    15       9.566  -9.286   5.552  1.00 63.34           H 
ATOM    246 3HB  LYS    15       8.050 -10.753   4.233  1.00 36.29           H 
ATOM    247 2HB  LYS    15       8.012  -9.547   2.960  1.00 36.29           H 
ATOM    248 3HG  LYS    15       6.747  -8.043   4.265  1.00 36.29           H 
ATOM    249 2HG  LYS    15       7.047  -8.962   5.748  1.00 36.29           H 
ATOM    250 3HD  LYS    15       5.723 -10.815   4.931  1.00 36.29           H 
ATOM    251 2HD  LYS    15       5.537 -10.042   3.359  1.00 36.29           H 
ATOM    252 3HE  LYS    15       4.506  -8.783   5.886  1.00 36.29           H 
ATOM    253 2HE  LYS    15       3.552  -9.928   4.946  1.00 36.29           H 
ATOM    254 1HZ  LYS    15       3.748  -8.461   3.031  1.00 36.29           H 
ATOM    255 2HZ  LYS    15       4.635  -7.356   3.943  1.00 36.29           H 
ATOM    256 3HZ  LYS    15       3.022  -7.670   4.334  1.00 36.29           H 
ATOM    257  N   ARG    16      10.573  -9.985   2.465  1.00 53.12           N 
ATOM    258  CA  ARG    16      11.427 -10.869   1.666  1.00 72.13           C 
ATOM    259  C   ARG    16      11.640 -10.326   0.242  1.00 25.20           C 
ATOM    260  O   ARG    16      10.906  -9.449  -0.219  1.00 32.24           O 
ATOM    261  CB  ARG    16      10.792 -12.264   1.587  1.00 52.01           C 
ATOM    262  CG  ARG    16       9.361 -12.243   1.052  1.00 71.01           C 
ATOM    263  CD  ARG    16       8.743 -13.634   1.005  1.00 61.23           C 
ATOM    264  NE  ARG    16       9.381 -14.498   0.011  1.00 72.42           N 
ATOM    265  CZ  ARG    16       8.831 -15.579  -0.473  1.00 20.34           C 
ATOM    266  NH1 ARG    16       7.664 -15.966  -0.065  1.00 12.04           N 
ATOM    267  NH2 ARG    16       9.452 -16.283  -1.360  1.00 11.42           N 
ATOM    268  H   ARG    16      10.005  -9.329   2.006  1.00 36.29           H 
ATOM    269  HA  ARG    16      12.385 -10.946   2.160  1.00 73.44           H 
ATOM    270 3HB  ARG    16      10.778 -12.699   2.577  1.00 36.29           H 
ATOM    271 2HB  ARG    16      11.392 -12.887   0.939  1.00 36.29           H 
ATOM    272 3HG  ARG    16       9.370 -11.828   0.052  1.00 36.29           H 
ATOM    273 2HG  ARG    16       8.758 -11.615   1.693  1.00 36.29           H 
ATOM    274 3HD  ARG    16       7.693 -13.536   0.763  1.00 36.29           H 
ATOM    275 2HD  ARG    16       8.843 -14.092   1.980  1.00 36.29           H 
ATOM    276  HE  ARG    16      10.269 -14.246  -0.311  1.00 74.05           H 
ATOM    277 1HH1 ARG    16       7.174 -15.436   0.626  1.00 36.29           H 
ATOM    278 2HH1 ARG    16       7.254 -16.795  -0.444  1.00 36.29           H 
ATOM    279 1HH2 ARG    16      10.355 -16.000  -1.677  1.00 36.29           H 
ATOM    280 2HH2 ARG    16       9.024 -17.104  -1.728  1.00 36.29           H 
ATOM    281  N   LEU    17      12.645 -10.863  -0.450  1.00  0.31           N 
ATOM    282  CA  LEU    17      12.922 -10.490  -1.843  1.00 62.33           C 
ATOM    283  C   LEU    17      12.686 -11.688  -2.778  1.00  3.55           C 
ATOM    284  O   LEU    17      13.438 -12.664  -2.747  1.00  4.43           O 
ATOM    285  CB  LEU    17      14.372  -9.988  -2.007  1.00 34.31           C 
ATOM    286  CG  LEU    17      14.729  -8.668  -1.289  1.00 73.12           C 
ATOM    287  CD1 LEU    17      14.759  -8.844   0.228  1.00 51.21           C 
ATOM    288  CD2 LEU    17      16.067  -8.128  -1.792  1.00 23.23           C 
ATOM    289  H   LEU    17      13.215 -11.534  -0.014  1.00 36.29           H 
ATOM    290  HA  LEU    17      12.243  -9.694  -2.117  1.00  3.45           H 
ATOM    291 3HB  LEU    17      14.560  -9.853  -3.064  1.00 36.29           H 
ATOM    292 2HB  LEU    17      15.036 -10.759  -1.642  1.00 36.29           H 
ATOM    293  HG  LEU    17      13.972  -7.931  -1.516  1.00 55.30           H 
ATOM    294 1HD1 LEU    17      13.784  -9.152   0.573  1.00 36.29           H 
ATOM    295 2HD1 LEU    17      15.023  -7.906   0.694  1.00 36.29           H 
ATOM    296 3HD1 LEU    17      15.490  -9.595   0.493  1.00 36.29           H 
ATOM    297 1HD2 LEU    17      15.995  -7.910  -2.847  1.00 36.29           H 
ATOM    298 2HD2 LEU    17      16.842  -8.865  -1.630  1.00 36.29           H 
ATOM    299 3HD2 LEU    17      16.315  -7.223  -1.255  1.00 36.29           H 
ATOM    300  N   GLU    18      11.650 -11.616  -3.609  1.00 65.14           N 
ATOM    301  CA  GLU    18      11.313 -12.710  -4.532  1.00 61.25           C 
ATOM    302  C   GLU    18      12.190 -12.680  -5.802  1.00 13.35           C 
ATOM    303  O   GLU    18      11.698 -12.836  -6.922  1.00 54.12           O 
ATOM    304  CB  GLU    18       9.818 -12.641  -4.893  1.00 64.31           C 
ATOM    305  CG  GLU    18       8.890 -12.730  -3.680  1.00 30.41           C 
ATOM    306  CD  GLU    18       7.420 -12.882  -4.059  1.00 44.25           C 
ATOM    307  OE1 GLU    18       7.032 -13.991  -4.487  1.00 73.44           O 
ATOM    308  OE2 GLU    18       6.650 -11.903  -3.923  1.00 72.23           O 
ATOM    309  H   GLU    18      11.091 -10.812  -3.602  1.00 36.29           H 
ATOM    310  HA  GLU    18      11.498 -13.643  -4.015  1.00  3.23           H 
ATOM    311 3HB  GLU    18       9.582 -13.460  -5.560  1.00 36.29           H 
ATOM    312 2HB  GLU    18       9.624 -11.706  -5.400  1.00 36.29           H 
ATOM    313 3HG  GLU    18       9.008 -11.830  -3.089  1.00 36.29           H 
ATOM    314 2HG  GLU    18       9.181 -13.584  -3.085  1.00 36.29           H 
ATOM    315  N   VAL    19      13.500 -12.511  -5.610  1.00 61.33           N 
ATOM    316  CA  VAL    19      14.461 -12.464  -6.720  1.00 64.02           C 
ATOM    317  C   VAL    19      15.892 -12.796  -6.248  1.00 51.43           C 
ATOM    318  O   VAL    19      16.281 -12.473  -5.124  1.00 60.45           O 
ATOM    319  CB  VAL    19      14.460 -11.070  -7.404  1.00 21.12           C 
ATOM    320  CG1 VAL    19      14.876  -9.976  -6.420  1.00 20.32           C 
ATOM    321  CG2 VAL    19      15.362 -11.064  -8.642  1.00 35.12           C 
ATOM    322  H   VAL    19      13.833 -12.421  -4.695  1.00 36.29           H 
ATOM    323  HA  VAL    19      14.157 -13.200  -7.452  1.00 71.45           H 
ATOM    324  HB  VAL    19      13.449 -10.857  -7.727  1.00 20.42           H 
ATOM    325 1HG1 VAL    19      14.197  -9.969  -5.579  1.00 36.29           H 
ATOM    326 2HG1 VAL    19      14.844  -9.014  -6.915  1.00 36.29           H 
ATOM    327 3HG1 VAL    19      15.879 -10.166  -6.070  1.00 36.29           H 
ATOM    328 1HG2 VAL    19      15.338 -10.086  -9.102  1.00 36.29           H 
ATOM    329 2HG2 VAL    19      15.010 -11.800  -9.350  1.00 36.29           H 
ATOM    330 3HG2 VAL    19      16.376 -11.300  -8.352  1.00 36.29           H 
ATOM    331  N   SER    20      16.668 -13.440  -7.120  1.00 30.03           N 
ATOM    332  CA  SER    20      18.064 -13.797  -6.819  1.00 25.34           C 
ATOM    333  C   SER    20      18.943 -13.724  -8.080  1.00 44.25           C 
ATOM    334  O   SER    20      18.525 -14.140  -9.162  1.00  1.44           O 
ATOM    335  CB  SER    20      18.143 -15.212  -6.222  1.00 54.34           C 
ATOM    336  OG  SER    20      17.658 -16.194  -7.132  1.00 62.52           O 
ATOM    337  H   SER    20      16.293 -13.691  -7.990  1.00 36.29           H 
ATOM    338  HA  SER    20      18.439 -13.088  -6.092  1.00 21.44           H 
ATOM    339 3HB  SER    20      17.550 -15.253  -5.320  1.00 36.29           H 
ATOM    340 2HB  SER    20      19.173 -15.443  -5.983  1.00 36.29           H 
ATOM    341  HG  SER    20      17.701 -15.848  -8.034  1.00 34.34           H 
ATOM    342  N   GLY    21      20.162 -13.203  -7.936  1.00 43.32           N 
ATOM    343  CA  GLY    21      21.082 -13.104  -9.070  1.00 23.41           C 
ATOM    344  C   GLY    21      20.997 -11.768  -9.811  1.00  2.22           C 
ATOM    345  O   GLY    21      19.912 -11.349 -10.222  1.00 65.42           O 
ATOM    346  H   GLY    21      20.447 -12.890  -7.050  1.00 36.29           H 
ATOM    347 3HA  GLY    21      20.866 -13.902  -9.767  1.00 36.29           H 
ATOM    348 2HA  GLY    21      22.090 -13.233  -8.705  1.00 36.29           H 
ATOM    349  N   GLU    22      22.147 -11.100  -9.970  1.00 25.21           N 
ATOM    350  CA  GLU    22      22.243  -9.823 -10.704  1.00 35.14           C 
ATOM    351  C   GLU    22      21.469  -8.681 -10.015  1.00 50.11           C 
ATOM    352  O   GLU    22      22.065  -7.758  -9.459  1.00 14.41           O 
ATOM    353  CB  GLU    22      21.769  -9.991 -12.160  1.00 34.40           C 
ATOM    354  CG  GLU    22      22.683 -10.870 -13.010  1.00 62.03           C 
ATOM    355  CD  GLU    22      22.176 -11.049 -14.434  1.00 22.45           C 
ATOM    356  OE1 GLU    22      21.874 -12.194 -14.830  1.00 61.44           O 
ATOM    357  OE2 GLU    22      22.061 -10.042 -15.164  1.00 72.20           O 
ATOM    358  H   GLU    22      22.963 -11.474  -9.575  1.00 36.29           H 
ATOM    359  HA  GLU    22      23.290  -9.551 -10.720  1.00 42.54           H 
ATOM    360 3HB  GLU    22      21.711  -9.016 -12.624  1.00 36.29           H 
ATOM    361 2HB  GLU    22      20.782 -10.433 -12.156  1.00 36.29           H 
ATOM    362 3HG  GLU    22      22.762 -11.841 -12.543  1.00 36.29           H 
ATOM    363 2HG  GLU    22      23.663 -10.413 -13.050  1.00 36.29           H 
ATOM    364  N   LEU    23      20.141  -8.738 -10.056  1.00 52.11           N 
ATOM    365  CA  LEU    23      19.307  -7.690  -9.456  1.00 42.43           C 
ATOM    366  C   LEU    23      19.362  -7.725  -7.917  1.00 54.40           C 
ATOM    367  O   LEU    23      19.346  -6.683  -7.260  1.00 31.34           O 
ATOM    368  CB  LEU    23      17.853  -7.829  -9.935  1.00 25.13           C 
ATOM    369  CG  LEU    23      16.890  -6.751  -9.414  1.00 34.53           C 
ATOM    370  CD1 LEU    23      17.379  -5.358  -9.802  1.00 51.22           C 
ATOM    371  CD2 LEU    23      15.476  -6.993  -9.938  1.00  1.54           C 
ATOM    372  H   LEU    23      19.710  -9.498 -10.502  1.00 36.29           H 
ATOM    373  HA  LEU    23      19.692  -6.735  -9.792  1.00 63.41           H 
ATOM    374 3HB  LEU    23      17.483  -8.794  -9.618  1.00 36.29           H 
ATOM    375 2HB  LEU    23      17.848  -7.799 -11.016  1.00 36.29           H 
ATOM    376  HG  LEU    23      16.857  -6.800  -8.334  1.00 11.35           H 
ATOM    377 1HD1 LEU    23      18.367  -5.196  -9.393  1.00 36.29           H 
ATOM    378 2HD1 LEU    23      16.703  -4.616  -9.406  1.00 36.29           H 
ATOM    379 3HD1 LEU    23      17.416  -5.274 -10.879  1.00 36.29           H 
ATOM    380 1HD2 LEU    23      15.480  -6.962 -11.019  1.00 36.29           H 
ATOM    381 2HD2 LEU    23      14.813  -6.227  -9.559  1.00 36.29           H 
ATOM    382 3HD2 LEU    23      15.128  -7.961  -9.606  1.00 36.29           H 
ATOM    383  N   HIS    24      19.440  -8.927  -7.347  1.00  5.44           N 
ATOM    384  CA  HIS    24      19.451  -9.098  -5.887  1.00 21.23           C 
ATOM    385  C   HIS    24      20.626  -8.346  -5.232  1.00 15.23           C 
ATOM    386  O   HIS    24      20.454  -7.677  -4.212  1.00 20.14           O 
ATOM    387  CB  HIS    24      19.509 -10.589  -5.534  1.00 22.14           C 
ATOM    388  CG  HIS    24      19.431 -10.874  -4.061  1.00 74.40           C 
ATOM    389  ND1 HIS    24      20.541 -11.011  -3.257  1.00 22.52           N 
ATOM    390  CD2 HIS    24      18.364 -11.068  -3.253  1.00 72.20           C 
ATOM    391  CE1 HIS    24      20.161 -11.276  -2.025  1.00 11.43           C 
ATOM    392  NE2 HIS    24      18.844 -11.316  -1.993  1.00 72.11           N 
ATOM    393  H   HIS    24      19.496  -9.719  -7.922  1.00 36.29           H 
ATOM    394  HA  HIS    24      18.527  -8.689  -5.504  1.00 73.12           H 
ATOM    395 3HB  HIS    24      20.435 -11.007  -5.904  1.00 36.29           H 
ATOM    396 2HB  HIS    24      18.680 -11.095  -6.008  1.00 36.29           H 
ATOM    397  HD1 HIS    24      21.476 -10.931  -3.549  1.00 43.04           H 
ATOM    398  HD2 HIS    24      17.323 -11.033  -3.547  1.00 22.55           H 
ATOM    399  HE1 HIS    24      20.817 -11.438  -1.182  1.00 34.02           H 
ATOM    400  HE2 HIS    24      18.323 -11.726  -1.267  1.00 36.29           H 
ATOM    401  N   GLU    25      21.814  -8.462  -5.821  1.00  1.01           N 
ATOM    402  CA  GLU    25      23.002  -7.760  -5.313  1.00 20.24           C 
ATOM    403  C   GLU    25      22.894  -6.237  -5.504  1.00 14.42           C 
ATOM    404  O   GLU    25      23.382  -5.464  -4.678  1.00 51.00           O 
ATOM    405  CB  GLU    25      24.270  -8.315  -5.975  1.00 74.25           C 
ATOM    406  CG  GLU    25      24.226  -8.330  -7.499  1.00 60.44           C 
ATOM    407  CD  GLU    25      25.174  -9.357  -8.097  1.00 13.20           C 
ATOM    408  OE1 GLU    25      26.222  -8.969  -8.652  1.00 23.14           O 
ATOM    409  OE2 GLU    25      24.871 -10.565  -8.005  1.00 30.12           O 
ATOM    410  H   GLU    25      21.902  -9.043  -6.607  1.00 36.29           H 
ATOM    411  HA  GLU    25      23.058  -7.960  -4.251  1.00 31.22           H 
ATOM    412 3HB  GLU    25      24.419  -9.330  -5.631  1.00 36.29           H 
ATOM    413 2HB  GLU    25      25.115  -7.716  -5.666  1.00 36.29           H 
ATOM    414 3HG  GLU    25      24.497  -7.348  -7.866  1.00 36.29           H 
ATOM    415 2HG  GLU    25      23.220  -8.565  -7.816  1.00 36.29           H 
ATOM    416  N   LYS    26      22.248  -5.809  -6.587  1.00 33.11           N 
ATOM    417  CA  LYS    26      21.936  -4.388  -6.789  1.00  2.13           C 
ATOM    418  C   LYS    26      21.045  -3.868  -5.647  1.00  1.22           C 
ATOM    419  O   LYS    26      21.283  -2.795  -5.085  1.00 54.51           O 
ATOM    420  CB  LYS    26      21.227  -4.181  -8.138  1.00 23.05           C 
ATOM    421  CG  LYS    26      20.755  -2.747  -8.376  1.00 73.40           C 
ATOM    422  CD  LYS    26      19.990  -2.602  -9.691  1.00 51.53           C 
ATOM    423  CE  LYS    26      19.479  -1.178  -9.894  1.00 32.13           C 
ATOM    424  NZ  LYS    26      20.585  -0.182  -9.921  1.00 65.41           N 
ATOM    425  H   LYS    26      21.984  -6.460  -7.272  1.00 36.29           H 
ATOM    426  HA  LYS    26      22.867  -3.837  -6.788  1.00 21.01           H 
ATOM    427 3HB  LYS    26      20.365  -4.833  -8.184  1.00 36.29           H 
ATOM    428 2HB  LYS    26      21.909  -4.448  -8.933  1.00 36.29           H 
ATOM    429 3HG  LYS    26      21.617  -2.094  -8.398  1.00 36.29           H 
ATOM    430 2HG  LYS    26      20.104  -2.454  -7.564  1.00 36.29           H 
ATOM    431 3HD  LYS    26      19.147  -3.278  -9.682  1.00 36.29           H 
ATOM    432 2HD  LYS    26      20.647  -2.857 -10.511  1.00 36.29           H 
ATOM    433 3HE  LYS    26      18.805  -0.931  -9.085  1.00 36.29           H 
ATOM    434 2HE  LYS    26      18.945  -1.132 -10.832  1.00 36.29           H 
ATOM    435 1HZ  LYS    26      21.194  -0.296  -9.087  1.00 36.29           H 
ATOM    436 2HZ  LYS    26      20.197   0.783  -9.915  1.00 36.29           H 
ATOM    437 3HZ  LYS    26      21.162  -0.304 -10.778  1.00 36.29           H 
ATOM    438  N   LEU    27      20.024  -4.650  -5.307  1.00  4.41           N 
ATOM    439  CA  LEU    27      19.083  -4.291  -4.242  1.00 50.20           C 
ATOM    440  C   LEU    27      19.781  -4.169  -2.873  1.00 51.10           C 
ATOM    441  O   LEU    27      19.699  -3.127  -2.217  1.00  3.54           O 
ATOM    442  CB  LEU    27      17.956  -5.332  -4.174  1.00 34.50           C 
ATOM    443  CG  LEU    27      17.071  -5.423  -5.432  1.00 22.13           C 
ATOM    444  CD1 LEU    27      16.069  -6.569  -5.311  1.00 62.11           C 
ATOM    445  CD2 LEU    27      16.352  -4.096  -5.685  1.00 60.43           C 
ATOM    446  H   LEU    27      19.895  -5.494  -5.790  1.00 36.29           H 
ATOM    447  HA  LEU    27      18.653  -3.331  -4.494  1.00 23.24           H 
ATOM    448 3HB  LEU    27      17.321  -5.093  -3.332  1.00 36.29           H 
ATOM    449 2HB  LEU    27      18.402  -6.302  -4.001  1.00 36.29           H 
ATOM    450  HG  LEU    27      17.700  -5.626  -6.287  1.00 31.34           H 
ATOM    451 1HD1 LEU    27      16.601  -7.500  -5.172  1.00 36.29           H 
ATOM    452 2HD1 LEU    27      15.478  -6.626  -6.213  1.00 36.29           H 
ATOM    453 3HD1 LEU    27      15.419  -6.396  -4.465  1.00 36.29           H 
ATOM    454 1HD2 LEU    27      15.744  -4.180  -6.575  1.00 36.29           H 
ATOM    455 2HD2 LEU    27      17.080  -3.310  -5.821  1.00 36.29           H 
ATOM    456 3HD2 LEU    27      15.720  -3.858  -4.841  1.00 36.29           H 
ATOM    457  N   VAL    28      20.473  -5.227  -2.449  1.00 41.14           N 
ATOM    458  CA  VAL    28      21.202  -5.206  -1.172  1.00 31.54           C 
ATOM    459  C   VAL    28      22.322  -4.151  -1.187  1.00  2.43           C 
ATOM    460  O   VAL    28      22.674  -3.585  -0.151  1.00 42.45           O 
ATOM    461  CB  VAL    28      21.796  -6.596  -0.812  1.00 35.24           C 
ATOM    462  CG1 VAL    28      20.698  -7.656  -0.773  1.00 43.52           C 
ATOM    463  CG2 VAL    28      22.904  -6.994  -1.786  1.00 23.41           C 
ATOM    464  H   VAL    28      20.488  -6.041  -2.998  1.00 36.29           H 
ATOM    465  HA  VAL    28      20.492  -4.937  -0.399  1.00 15.12           H 
ATOM    466  HB  VAL    28      22.227  -6.529   0.179  1.00 34.11           H 
ATOM    467 1HG1 VAL    28      20.237  -7.735  -1.748  1.00 36.29           H 
ATOM    468 2HG1 VAL    28      19.951  -7.378  -0.044  1.00 36.29           H 
ATOM    469 3HG1 VAL    28      21.127  -8.611  -0.500  1.00 36.29           H 
ATOM    470 1HG2 VAL    28      23.708  -6.275  -1.733  1.00 36.29           H 
ATOM    471 2HG2 VAL    28      22.510  -7.017  -2.791  1.00 36.29           H 
ATOM    472 3HG2 VAL    28      23.281  -7.974  -1.525  1.00 36.29           H 
ATOM    473  N   GLY    29      22.883  -3.897  -2.371  1.00 31.42           N 
ATOM    474  CA  GLY    29      23.868  -2.831  -2.532  1.00 51.22           C 
ATOM    475  C   GLY    29      23.289  -1.447  -2.241  1.00 63.34           C 
ATOM    476  O   GLY    29      23.980  -0.569  -1.718  1.00 30.35           O 
ATOM    477  H   GLY    29      22.633  -4.446  -3.146  1.00 36.29           H 
ATOM    478 3HA  GLY    29      24.236  -2.848  -3.549  1.00 36.29           H 
ATOM    479 2HA  GLY    29      24.695  -3.013  -1.860  1.00 36.29           H 
ATOM    480  N   MET    30      22.015  -1.257  -2.582  1.00  3.32           N 
ATOM    481  CA  MET    30      21.309  -0.001  -2.299  1.00  5.23           C 
ATOM    482  C   MET    30      20.713   0.005  -0.878  1.00 22.33           C 
ATOM    483  O   MET    30      20.421   1.066  -0.324  1.00 35.41           O 
ATOM    484  CB  MET    30      20.211   0.242  -3.345  1.00 11.22           C 
ATOM    485  CG  MET    30      20.754   0.455  -4.752  1.00  1.14           C 
ATOM    486  SD  MET    30      19.457   0.812  -5.956  1.00 22.01           S 
ATOM    487  CE  MET    30      18.502  -0.703  -5.889  1.00 63.52           C 
ATOM    488  H   MET    30      21.537  -1.980  -3.043  1.00 36.29           H 
ATOM    489  HA  MET    30      22.032   0.801  -2.367  1.00 44.01           H 
ATOM    490 3HB  MET    30      19.647   1.118  -3.063  1.00 36.29           H 
ATOM    491 2HB  MET    30      19.548  -0.612  -3.363  1.00 36.29           H 
ATOM    492 3HG  MET    30      21.277  -0.440  -5.061  1.00 36.29           H 
ATOM    493 2HG  MET    30      21.444   1.285  -4.736  1.00 36.29           H 
ATOM    494 1HE  MET    30      19.128  -1.537  -6.171  1.00 36.29           H 
ATOM    495 2HE  MET    30      17.667  -0.634  -6.571  1.00 36.29           H 
ATOM    496 3HE  MET    30      18.134  -0.854  -4.885  1.00 36.29           H 
ATOM    497  N   GLY    31      20.529  -1.182  -0.288  1.00 64.43           N 
ATOM    498  CA  GLY    31      20.067  -1.268   1.102  1.00 12.31           C 
ATOM    499  C   GLY    31      18.915  -2.247   1.329  1.00 42.44           C 
ATOM    500  O   GLY    31      18.568  -2.545   2.477  1.00 43.15           O 
ATOM    501  H   GLY    31      20.716  -2.001  -0.793  1.00 36.29           H 
ATOM    502 3HA  GLY    31      19.749  -0.286   1.424  1.00 36.29           H 
ATOM    503 2HA  GLY    31      20.899  -1.575   1.719  1.00 36.29           H 
ATOM    504  N   PHE    32      18.317  -2.750   0.250  1.00 21.02           N 
ATOM    505  CA  PHE    32      17.173  -3.669   0.355  1.00 73.14           C 
ATOM    506  C   PHE    32      17.560  -5.002   1.023  1.00 52.01           C 
ATOM    507  O   PHE    32      18.043  -5.923   0.362  1.00 42.21           O 
ATOM    508  CB  PHE    32      16.568  -3.944  -1.032  1.00 25.00           C 
ATOM    509  CG  PHE    32      15.960  -2.734  -1.696  1.00 31.13           C 
ATOM    510  CD1 PHE    32      16.760  -1.803  -2.344  1.00 24.34           C 
ATOM    511  CD2 PHE    32      14.586  -2.530  -1.675  1.00  5.14           C 
ATOM    512  CE1 PHE    32      16.205  -0.696  -2.953  1.00 73.05           C 
ATOM    513  CE2 PHE    32      14.028  -1.423  -2.283  1.00 61.32           C 
ATOM    514  CZ  PHE    32      14.837  -0.505  -2.923  1.00 40.43           C 
ATOM    515  H   PHE    32      18.647  -2.498  -0.637  1.00 36.29           H 
ATOM    516  HA  PHE    32      16.424  -3.186   0.966  1.00 23.32           H 
ATOM    517 3HB  PHE    32      15.794  -4.695  -0.935  1.00 36.29           H 
ATOM    518 2HB  PHE    32      17.342  -4.323  -1.683  1.00 36.29           H 
ATOM    519  HD1 PHE    32      17.830  -1.950  -2.368  1.00 53.21           H 
ATOM    520  HD2 PHE    32      13.951  -3.248  -1.177  1.00 60.02           H 
ATOM    521  HE1 PHE    32      16.840   0.020  -3.453  1.00 65.40           H 
ATOM    522  HE2 PHE    32      12.957  -1.275  -2.260  1.00 30.52           H 
ATOM    523  HZ  PHE    32      14.403   0.361  -3.398  1.00 72.35           H 
ATOM    524  N   VAL    33      17.362  -5.087   2.339  1.00 62.13           N 
ATOM    525  CA  VAL    33      17.590  -6.332   3.085  1.00 63.03           C 
ATOM    526  C   VAL    33      16.395  -6.650   4.007  1.00 51.44           C 
ATOM    527  O   VAL    33      15.780  -5.740   4.579  1.00 32.15           O 
ATOM    528  CB  VAL    33      18.901  -6.275   3.926  1.00 62.10           C 
ATOM    529  CG1 VAL    33      20.117  -6.065   3.025  1.00 55.24           C 
ATOM    530  CG2 VAL    33      18.826  -5.183   4.994  1.00 52.51           C 
ATOM    531  H   VAL    33      17.064  -4.289   2.823  1.00 36.29           H 
ATOM    532  HA  VAL    33      17.690  -7.135   2.365  1.00 61.15           H 
ATOM    533  HB  VAL    33      19.021  -7.227   4.427  1.00 30.32           H 
ATOM    534 1HG1 VAL    33      21.018  -6.064   3.624  1.00 36.29           H 
ATOM    535 2HG1 VAL    33      20.028  -5.119   2.511  1.00 36.29           H 
ATOM    536 3HG1 VAL    33      20.170  -6.863   2.298  1.00 36.29           H 
ATOM    537 1HG2 VAL    33      18.020  -5.403   5.680  1.00 36.29           H 
ATOM    538 2HG2 VAL    33      18.646  -4.229   4.522  1.00 36.29           H 
ATOM    539 3HG2 VAL    33      19.760  -5.145   5.538  1.00 36.29           H 
ATOM    540  N   PRO    34      16.038  -7.946   4.155  1.00  1.04           N 
ATOM    541  CA  PRO    34      14.906  -8.368   5.006  1.00  2.21           C 
ATOM    542  C   PRO    34      15.015  -7.834   6.446  1.00 34.35           C 
ATOM    543  O   PRO    34      15.907  -8.230   7.205  1.00 23.53           O 
ATOM    544  CB  PRO    34      14.993  -9.901   4.981  1.00 13.00           C 
ATOM    545  CG  PRO    34      15.710 -10.218   3.713  1.00 72.54           C 
ATOM    546  CD  PRO    34      16.696  -9.098   3.506  1.00 32.51           C 
ATOM    547  HA  PRO    34      13.959  -8.052   4.580  1.00 72.01           H 
ATOM    548 3HB  PRO    34      13.997 -10.323   4.988  1.00 36.29           H 
ATOM    549 2HB  PRO    34      15.543 -10.251   5.845  1.00 36.29           H 
ATOM    550 3HG  PRO    34      15.008 -10.258   2.891  1.00 36.29           H 
ATOM    551 2HG  PRO    34      16.228 -11.163   3.808  1.00 36.29           H 
ATOM    552 3HD  PRO    34      16.845  -8.915   2.451  1.00 36.29           H 
ATOM    553 2HD  PRO    34      17.638  -9.326   3.987  1.00 36.29           H 
ATOM    554  N   GLY    35      14.099  -6.939   6.813  1.00 51.52           N 
ATOM    555  CA  GLY    35      14.148  -6.295   8.124  1.00 62.41           C 
ATOM    556  C   GLY    35      14.120  -4.769   8.046  1.00 64.23           C 
ATOM    557  O   GLY    35      13.655  -4.106   8.975  1.00 51.22           O 
ATOM    558  H   GLY    35      13.365  -6.727   6.195  1.00 36.29           H 
ATOM    559 3HA  GLY    35      15.054  -6.599   8.634  1.00 36.29           H 
ATOM    560 2HA  GLY    35      13.300  -6.629   8.702  1.00 36.29           H 
ATOM    561  N   GLU    36      14.620  -4.214   6.940  1.00 53.21           N 
ATOM    562  CA  GLU    36      14.636  -2.756   6.736  1.00 11.03           C 
ATOM    563  C   GLU    36      13.231  -2.144   6.757  1.00 23.31           C 
ATOM    564  O   GLU    36      12.258  -2.761   6.326  1.00 61.20           O 
ATOM    565  CB  GLU    36      15.317  -2.400   5.402  1.00 32.34           C 
ATOM    566  CG  GLU    36      16.838  -2.339   5.469  1.00 13.14           C 
ATOM    567  CD  GLU    36      17.339  -1.243   6.399  1.00 44.42           C 
ATOM    568  OE1 GLU    36      16.727  -0.158   6.436  1.00 42.33           O 
ATOM    569  OE2 GLU    36      18.361  -1.458   7.084  1.00 62.32           O 
ATOM    570  H   GLU    36      14.995  -4.795   6.244  1.00 36.29           H 
ATOM    571  HA  GLU    36      15.209  -2.321   7.542  1.00 60.34           H 
ATOM    572 3HB  GLU    36      14.957  -1.433   5.074  1.00 36.29           H 
ATOM    573 2HB  GLU    36      15.042  -3.139   4.664  1.00 36.29           H 
ATOM    574 3HG  GLU    36      17.220  -2.148   4.475  1.00 36.29           H 
ATOM    575 2HG  GLU    36      17.210  -3.291   5.818  1.00 36.29           H 
ATOM    576  N   GLU    37      13.139  -0.920   7.263  1.00 62.22           N 
ATOM    577  CA  GLU    37      11.895  -0.154   7.219  1.00 65.14           C 
ATOM    578  C   GLU    37      11.964   0.899   6.111  1.00 35.44           C 
ATOM    579  O   GLU    37      12.697   1.881   6.211  1.00 53.53           O 
ATOM    580  CB  GLU    37      11.621   0.500   8.577  1.00 71.21           C 
ATOM    581  CG  GLU    37      11.387  -0.513   9.690  1.00 23.14           C 
ATOM    582  CD  GLU    37      11.247   0.135  11.057  1.00 20.24           C 
ATOM    583  OE1 GLU    37      12.279   0.377  11.714  1.00 53.54           O 
ATOM    584  OE2 GLU    37      10.105   0.406  11.479  1.00 64.04           O 
ATOM    585  H   GLU    37      13.931  -0.519   7.679  1.00 36.29           H 
ATOM    586  HA  GLU    37      11.089  -0.842   6.992  1.00 21.02           H 
ATOM    587 3HB  GLU    37      10.743   1.124   8.497  1.00 36.29           H 
ATOM    588 2HB  GLU    37      12.467   1.118   8.848  1.00 36.29           H 
ATOM    589 3HG  GLU    37      12.221  -1.200   9.713  1.00 36.29           H 
ATOM    590 2HG  GLU    37      10.481  -1.063   9.476  1.00 36.29           H 
ATOM    591  N   ILE    38      11.210   0.671   5.048  1.00 11.41           N 
ATOM    592  CA  ILE    38      11.230   1.539   3.870  1.00 13.12           C 
ATOM    593  C   ILE    38       9.952   2.391   3.775  1.00  2.14           C 
ATOM    594  O   ILE    38       8.836   1.879   3.862  1.00 52.15           O 
ATOM    595  CB  ILE    38      11.396   0.704   2.571  1.00 71.30           C 
ATOM    596  CG1 ILE    38      11.418   1.618   1.333  1.00 34.11           C 
ATOM    597  CG2 ILE    38      10.289  -0.346   2.454  1.00 72.01           C 
ATOM    598  CD1 ILE    38      11.584   0.869   0.025  1.00 73.03           C 
ATOM    599  H   ILE    38      10.618  -0.107   5.055  1.00 36.29           H 
ATOM    600  HA  ILE    38      12.085   2.199   3.957  1.00 43.24           H 
ATOM    601  HB  ILE    38      12.341   0.178   2.634  1.00 61.23           H 
ATOM    602 3HG1 ILE    38      12.240   2.315   1.421  1.00 36.29           H 
ATOM    603 2HG1 ILE    38      10.490   2.169   1.281  1.00 36.29           H 
ATOM    604 1HG2 ILE    38       9.328   0.146   2.379  1.00 36.29           H 
ATOM    605 2HG2 ILE    38      10.298  -0.979   3.330  1.00 36.29           H 
ATOM    606 3HG2 ILE    38      10.452  -0.952   1.575  1.00 36.29           H 
ATOM    607 1HD1 ILE    38      12.510   0.313   0.042  1.00 36.29           H 
ATOM    608 2HD1 ILE    38      11.603   1.573  -0.792  1.00 36.29           H 
ATOM    609 3HD1 ILE    38      10.757   0.186  -0.108  1.00 36.29           H 
ATOM    610  N   GLU    39      10.127   3.698   3.613  1.00 24.21           N 
ATOM    611  CA  GLU    39       8.998   4.623   3.451  1.00  0.11           C 
ATOM    612  C   GLU    39       9.097   5.378   2.114  1.00 74.24           C 
ATOM    613  O   GLU    39      10.150   5.922   1.766  1.00 61.24           O 
ATOM    614  CB  GLU    39       8.943   5.611   4.633  1.00 73.20           C 
ATOM    615  CG  GLU    39      10.230   6.403   4.838  1.00 54.35           C 
ATOM    616  CD  GLU    39      10.175   7.341   6.036  1.00  1.04           C 
ATOM    617  OE1 GLU    39      10.249   6.858   7.187  1.00 44.23           O 
ATOM    618  OE2 GLU    39      10.080   8.569   5.834  1.00 60.15           O 
ATOM    619  H   GLU    39      11.041   4.056   3.605  1.00 36.29           H 
ATOM    620  HA  GLU    39       8.089   4.037   3.445  1.00 25.43           H 
ATOM    621 3HB  GLU    39       8.739   5.056   5.539  1.00 36.29           H 
ATOM    622 2HB  GLU    39       8.135   6.312   4.466  1.00 36.29           H 
ATOM    623 3HG  GLU    39      10.420   6.988   3.948  1.00 36.29           H 
ATOM    624 2HG  GLU    39      11.043   5.708   4.984  1.00 36.29           H 
ATOM    625  N   ILE    40       8.003   5.384   1.354  1.00  4.05           N 
ATOM    626  CA  ILE    40       7.955   6.098   0.075  1.00 72.44           C 
ATOM    627  C   ILE    40       7.859   7.614   0.300  1.00 72.04           C 
ATOM    628  O   ILE    40       7.019   8.085   1.068  1.00 42.01           O 
ATOM    629  CB  ILE    40       6.757   5.631  -0.793  1.00 63.41           C 
ATOM    630  CG1 ILE    40       6.827   4.114  -1.055  1.00 70.43           C 
ATOM    631  CG2 ILE    40       6.713   6.402  -2.114  1.00 72.33           C 
ATOM    632  CD1 ILE    40       8.056   3.674  -1.828  1.00 40.12           C 
ATOM    633  H   ILE    40       7.211   4.896   1.659  1.00 36.29           H 
ATOM    634  HA  ILE    40       8.869   5.881  -0.463  1.00 32.24           H 
ATOM    635  HB  ILE    40       5.847   5.851  -0.252  1.00 54.33           H 
ATOM    636 3HG1 ILE    40       5.954   3.815  -1.622  1.00 36.29           H 
ATOM    637 2HG1 ILE    40       6.829   3.590  -0.111  1.00 36.29           H 
ATOM    638 1HG2 ILE    40       7.632   6.238  -2.658  1.00 36.29           H 
ATOM    639 2HG2 ILE    40       6.600   7.458  -1.914  1.00 36.29           H 
ATOM    640 3HG2 ILE    40       5.877   6.058  -2.706  1.00 36.29           H 
ATOM    641 1HD1 ILE    40       8.946   3.954  -1.282  1.00 36.29           H 
ATOM    642 2HD1 ILE    40       8.064   4.151  -2.796  1.00 36.29           H 
ATOM    643 3HD1 ILE    40       8.036   2.601  -1.956  1.00 36.29           H 
ATOM    644  N   VAL    41       8.728   8.373  -0.362  1.00 65.02           N 
ATOM    645  CA  VAL    41       8.744   9.831  -0.218  1.00 74.12           C 
ATOM    646  C   VAL    41       7.885  10.512  -1.294  1.00 43.23           C 
ATOM    647  O   VAL    41       6.977  11.286  -0.986  1.00 22.33           O 
ATOM    648  CB  VAL    41      10.189  10.386  -0.289  1.00 75.20           C 
ATOM    649  CG1 VAL    41      10.220  11.878   0.039  1.00 21.45           C 
ATOM    650  CG2 VAL    41      11.103   9.604   0.644  1.00 53.13           C 
ATOM    651  H   VAL    41       9.377   7.943  -0.958  1.00 36.29           H 
ATOM    652  HA  VAL    41       8.339  10.071   0.758  1.00 23.52           H 
ATOM    653  HB  VAL    41      10.554  10.257  -1.299  1.00 32.15           H 
ATOM    654 1HG1 VAL    41       9.805  12.038   1.024  1.00 36.29           H 
ATOM    655 2HG1 VAL    41       9.636  12.422  -0.690  1.00 36.29           H 
ATOM    656 3HG1 VAL    41      11.240  12.232   0.018  1.00 36.29           H 
ATOM    657 1HG2 VAL    41      11.114   8.563   0.353  1.00 36.29           H 
ATOM    658 2HG2 VAL    41      10.742   9.689   1.660  1.00 36.29           H 
ATOM    659 3HG2 VAL    41      12.105  10.003   0.587  1.00 36.29           H 
ATOM    660  N   GLN    42       8.182  10.219  -2.561  1.00  3.43           N 
ATOM    661  CA  GLN    42       7.421  10.776  -3.685  1.00 74.24           C 
ATOM    662  C   GLN    42       7.518   9.872  -4.929  1.00 64.11           C 
ATOM    663  O   GLN    42       8.488   9.130  -5.103  1.00 31.14           O 
ATOM    664  CB  GLN    42       7.899  12.213  -3.993  1.00  3.35           C 
ATOM    665  CG  GLN    42       9.315  12.327  -4.573  1.00 33.42           C 
ATOM    666  CD  GLN    42       9.342  12.283  -6.095  1.00 64.51           C 
ATOM    667  OE1 GLN    42       8.383  12.672  -6.753  1.00 10.20           O 
ATOM    668  NE2 GLN    42      10.442  11.846  -6.667  1.00 24.44           N 
ATOM    669  H   GLN    42       8.928   9.611  -2.747  1.00 36.29           H 
ATOM    670  HA  GLN    42       6.383  10.818  -3.383  1.00 54.33           H 
ATOM    671 3HB  GLN    42       7.866  12.785  -3.076  1.00 36.29           H 
ATOM    672 2HB  GLN    42       7.214  12.658  -4.699  1.00 36.29           H 
ATOM    673 3HG  GLN    42       9.912  11.509  -4.194  1.00 36.29           H 
ATOM    674 2HG  GLN    42       9.749  13.263  -4.251  1.00 36.29           H 
ATOM    675 1HE2 GLN    42      11.184  11.571  -6.094  1.00 36.29           H 
ATOM    676 2HE2 GLN    42      10.472  11.823  -7.648  1.00 36.29           H 
ATOM    677  N   VAL    43       6.501   9.937  -5.786  1.00 12.10           N 
ATOM    678  CA  VAL    43       6.417   9.079  -6.978  1.00 22.13           C 
ATOM    679  C   VAL    43       6.363   9.914  -8.265  1.00 21.24           C 
ATOM    680  O   VAL    43       5.746  10.981  -8.297  1.00 40.02           O 
ATOM    681  CB  VAL    43       5.156   8.173  -6.916  1.00 73.42           C 
ATOM    682  CG1 VAL    43       5.002   7.343  -8.195  1.00  5.04           C 
ATOM    683  CG2 VAL    43       5.200   7.273  -5.679  1.00 51.45           C 
ATOM    684  H   VAL    43       5.785  10.585  -5.620  1.00 36.29           H 
ATOM    685  HA  VAL    43       7.292   8.444  -7.006  1.00 12.31           H 
ATOM    686  HB  VAL    43       4.287   8.812  -6.832  1.00 13.50           H 
ATOM    687 1HG1 VAL    43       5.882   6.735  -8.342  1.00 36.29           H 
ATOM    688 2HG1 VAL    43       4.876   8.003  -9.042  1.00 36.29           H 
ATOM    689 3HG1 VAL    43       4.135   6.703  -8.110  1.00 36.29           H 
ATOM    690 1HG2 VAL    43       4.327   6.636  -5.661  1.00 36.29           H 
ATOM    691 2HG2 VAL    43       5.213   7.886  -4.789  1.00 36.29           H 
ATOM    692 3HG2 VAL    43       6.091   6.662  -5.706  1.00 36.29           H 
ATOM    693  N   ALA    44       7.014   9.428  -9.322  1.00 45.22           N 
ATOM    694  CA  ALA    44       6.922  10.066 -10.637  1.00 21.02           C 
ATOM    695  C   ALA    44       5.464  10.070 -11.132  1.00 53.33           C 
ATOM    696  O   ALA    44       4.819   9.021 -11.170  1.00 63.02           O 
ATOM    697  CB  ALA    44       7.823   9.351 -11.638  1.00 30.32           C 
ATOM    698  H   ALA    44       7.566   8.623  -9.217  1.00 36.29           H 
ATOM    699  HA  ALA    44       7.267  11.087 -10.537  1.00 12.11           H 
ATOM    700 1HB  ALA    44       8.840   9.355 -11.271  1.00 36.29           H 
ATOM    701 2HB  ALA    44       7.783   9.861 -12.590  1.00 36.29           H 
ATOM    702 3HB  ALA    44       7.489   8.331 -11.762  1.00 36.29           H 
ATOM    703  N   PRO    45       4.928  11.242 -11.526  1.00 61.12           N 
ATOM    704  CA  PRO    45       3.504  11.387 -11.901  1.00 65.23           C 
ATOM    705  C   PRO    45       3.058  10.429 -13.025  1.00 34.04           C 
ATOM    706  O   PRO    45       1.872  10.125 -13.156  1.00  5.14           O 
ATOM    707  CB  PRO    45       3.394  12.856 -12.354  1.00 52.21           C 
ATOM    708  CG  PRO    45       4.799  13.303 -12.595  1.00 51.52           C 
ATOM    709  CD  PRO    45       5.653  12.521 -11.640  1.00 21.40           C 
ATOM    710  HA  PRO    45       2.865  11.231 -11.043  1.00 60.22           H 
ATOM    711 3HB  PRO    45       2.925  13.438 -11.574  1.00 36.29           H 
ATOM    712 2HB  PRO    45       2.801  12.918 -13.256  1.00 36.29           H 
ATOM    713 3HG  PRO    45       4.886  14.363 -12.396  1.00 36.29           H 
ATOM    714 2HG  PRO    45       5.084  13.091 -13.616  1.00 36.29           H 
ATOM    715 3HD  PRO    45       5.710  13.018 -10.681  1.00 36.29           H 
ATOM    716 2HD  PRO    45       6.643  12.372 -12.050  1.00 36.29           H 
ATOM    717  N   LEU    46       4.012   9.949 -13.821  1.00 24.01           N 
ATOM    718  CA  LEU    46       3.708   9.037 -14.931  1.00 20.22           C 
ATOM    719  C   LEU    46       3.609   7.571 -14.463  1.00 62.34           C 
ATOM    720  O   LEU    46       3.128   6.709 -15.200  1.00  5.34           O 
ATOM    721  CB  LEU    46       4.764   9.166 -16.043  1.00 72.21           C 
ATOM    722  CG  LEU    46       4.808  10.523 -16.775  1.00 55.13           C 
ATOM    723  CD1 LEU    46       5.375  11.624 -15.881  1.00 50.34           C 
ATOM    724  CD2 LEU    46       5.611  10.409 -18.069  1.00 71.50           C 
ATOM    725  H   LEU    46       4.941  10.214 -13.661  1.00 36.29           H 
ATOM    726  HA  LEU    46       2.747   9.325 -15.336  1.00 23.32           H 
ATOM    727 3HB  LEU    46       4.573   8.395 -16.777  1.00 36.29           H 
ATOM    728 2HB  LEU    46       5.737   8.984 -15.607  1.00 36.29           H 
ATOM    729  HG  LEU    46       3.799  10.809 -17.038  1.00 33.23           H 
ATOM    730 1HD1 LEU    46       5.394  12.559 -16.424  1.00 36.29           H 
ATOM    731 2HD1 LEU    46       6.380  11.364 -15.578  1.00 36.29           H 
ATOM    732 3HD1 LEU    46       4.752  11.732 -15.005  1.00 36.29           H 
ATOM    733 1HD2 LEU    46       6.630  10.127 -17.842  1.00 36.29           H 
ATOM    734 2HD2 LEU    46       5.608  11.361 -18.583  1.00 36.29           H 
ATOM    735 3HD2 LEU    46       5.164   9.659 -18.704  1.00 36.29           H 
ATOM    736  N   GLY    47       4.064   7.296 -13.240  1.00 13.15           N 
ATOM    737  CA  GLY    47       3.998   5.941 -12.693  1.00 32.42           C 
ATOM    738  C   GLY    47       5.232   5.558 -11.879  1.00  3.32           C 
ATOM    739  O   GLY    47       5.126   5.220 -10.702  1.00 22.12           O 
ATOM    740  H   GLY    47       4.436   8.020 -12.697  1.00 36.29           H 
ATOM    741 3HA  GLY    47       3.890   5.239 -13.507  1.00 36.29           H 
ATOM    742 2HA  GLY    47       3.128   5.869 -12.057  1.00 36.29           H 
ATOM    743  N   ASP    48       6.401   5.592 -12.514  1.00 13.23           N 
ATOM    744  CA  ASP    48       7.667   5.279 -11.842  1.00 64.04           C 
ATOM    745  C   ASP    48       8.847   5.914 -12.615  1.00 61.24           C 
ATOM    746  O   ASP    48       8.654   6.395 -13.737  1.00 51.03           O 
ATOM    747  CB  ASP    48       7.820   3.754 -11.703  1.00 13.35           C 
ATOM    748  CG  ASP    48       8.158   3.054 -13.008  1.00  0.30           C 
ATOM    749  OD1 ASP    48       7.298   3.021 -13.911  1.00 41.50           O 
ATOM    750  OD2 ASP    48       9.275   2.505 -13.126  1.00 33.25           O 
ATOM    751  H   ASP    48       6.416   5.834 -13.464  1.00 36.29           H 
ATOM    752  HA  ASP    48       7.631   5.721 -10.852  1.00 40.21           H 
ATOM    753 3HB  ASP    48       6.890   3.349 -11.333  1.00 36.29           H 
ATOM    754 2HB  ASP    48       8.599   3.540 -10.988  1.00 36.29           H 
ATOM    755  N   PRO    49      10.088   5.935 -12.063  1.00 61.44           N 
ATOM    756  CA  PRO    49      10.463   5.282 -10.785  1.00 44.01           C 
ATOM    757  C   PRO    49       9.884   5.955  -9.525  1.00 75.40           C 
ATOM    758  O   PRO    49       9.372   7.076  -9.571  1.00 60.01           O 
ATOM    759  CB  PRO    49      11.994   5.387 -10.788  1.00  3.11           C 
ATOM    760  CG  PRO    49      12.279   6.611 -11.586  1.00 14.11           C 
ATOM    761  CD  PRO    49      11.239   6.634 -12.672  1.00 25.10           C 
ATOM    762  HA  PRO    49      10.185   4.239 -10.784  1.00 21.21           H 
ATOM    763 3HB  PRO    49      12.418   4.507 -11.251  1.00 36.29           H 
ATOM    764 2HB  PRO    49      12.361   5.478  -9.774  1.00 36.29           H 
ATOM    765 3HG  PRO    49      13.269   6.553 -12.014  1.00 36.29           H 
ATOM    766 2HG  PRO    49      12.191   7.489 -10.960  1.00 36.29           H 
ATOM    767 3HD  PRO    49      11.592   6.103 -13.547  1.00 36.29           H 
ATOM    768 2HD  PRO    49      10.981   7.652 -12.929  1.00 36.29           H 
ATOM    769  N   ILE    50       9.973   5.244  -8.399  1.00 53.23           N 
ATOM    770  CA  ILE    50       9.529   5.766  -7.102  1.00 62.13           C 
ATOM    771  C   ILE    50      10.734   6.058  -6.192  1.00  4.11           C 
ATOM    772  O   ILE    50      11.699   5.290  -6.156  1.00  2.10           O 
ATOM    773  CB  ILE    50       8.555   4.794  -6.364  1.00 22.25           C 
ATOM    774  CG1 ILE    50       9.205   3.418  -6.074  1.00 73.23           C 
ATOM    775  CG2 ILE    50       7.265   4.617  -7.163  1.00 33.53           C 
ATOM    776  CD1 ILE    50       9.099   2.411  -7.206  1.00 22.32           C 
ATOM    777  H   ILE    50      10.362   4.346  -8.438  1.00 36.29           H 
ATOM    778  HA  ILE    50       9.002   6.697  -7.282  1.00 12.14           H 
ATOM    779  HB  ILE    50       8.289   5.255  -5.421  1.00 55.52           H 
ATOM    780 3HG1 ILE    50       8.731   2.983  -5.204  1.00 36.29           H 
ATOM    781 2HG1 ILE    50      10.255   3.559  -5.864  1.00 36.29           H 
ATOM    782 1HG2 ILE    50       6.756   5.566  -7.239  1.00 36.29           H 
ATOM    783 2HG2 ILE    50       6.625   3.906  -6.663  1.00 36.29           H 
ATOM    784 3HG2 ILE    50       7.499   4.255  -8.155  1.00 36.29           H 
ATOM    785 1HD1 ILE    50       9.542   2.820  -8.101  1.00 36.29           H 
ATOM    786 2HD1 ILE    50       8.059   2.183  -7.391  1.00 36.29           H 
ATOM    787 3HD1 ILE    50       9.619   1.506  -6.930  1.00 36.29           H 
ATOM    788  N   VAL    51      10.682   7.174  -5.466  1.00 71.23           N 
ATOM    789  CA  VAL    51      11.762   7.545  -4.543  1.00 73.25           C 
ATOM    790  C   VAL    51      11.393   7.193  -3.096  1.00  4.52           C 
ATOM    791  O   VAL    51      10.426   7.720  -2.537  1.00 42.01           O 
ATOM    792  CB  VAL    51      12.102   9.054  -4.642  1.00  0.44           C 
ATOM    793  CG1 VAL    51      13.223   9.428  -3.670  1.00 61.10           C 
ATOM    794  CG2 VAL    51      12.486   9.422  -6.075  1.00 12.43           C 
ATOM    795  H   VAL    51       9.901   7.762  -5.548  1.00 36.29           H 
ATOM    796  HA  VAL    51      12.645   6.982  -4.822  1.00 23.14           H 
ATOM    797  HB  VAL    51      11.219   9.620  -4.372  1.00  3.15           H 
ATOM    798 1HG1 VAL    51      12.908   9.223  -2.658  1.00 36.29           H 
ATOM    799 2HG1 VAL    51      13.450  10.480  -3.768  1.00 36.29           H 
ATOM    800 3HG1 VAL    51      14.107   8.847  -3.896  1.00 36.29           H 
ATOM    801 1HG2 VAL    51      12.706  10.477  -6.130  1.00 36.29           H 
ATOM    802 2HG2 VAL    51      11.665   9.191  -6.739  1.00 36.29           H 
ATOM    803 3HG2 VAL    51      13.358   8.855  -6.374  1.00 36.29           H 
ATOM    804  N   CYS    52      12.177   6.304  -2.496  1.00 70.13           N 
ATOM    805  CA  CYS    52      11.915   5.816  -1.136  1.00  4.10           C 
ATOM    806  C   CYS    52      13.096   6.095  -0.198  1.00 50.25           C 
ATOM    807  O   CYS    52      14.147   6.562  -0.630  1.00 43.52           O 
ATOM    808  CB  CYS    52      11.640   4.312  -1.175  1.00 50.52           C 
ATOM    809  SG  CYS    52      12.998   3.330  -1.850  1.00 41.54           S 
ATOM    810  H   CYS    52      12.962   5.964  -2.978  1.00 36.29           H 
ATOM    811  HA  CYS    52      11.039   6.324  -0.755  1.00 31.21           H 
ATOM    812 3HB  CYS    52      10.768   4.126  -1.784  1.00 36.29           H 
ATOM    813 2HB  CYS    52      11.452   3.961  -0.169  1.00 36.29           H 
ATOM    814  HG  CYS    52      13.315   3.821  -3.042  1.00 52.01           H 
ATOM    815  N   LYS    53      12.911   5.811   1.090  1.00 72.54           N 
ATOM    816  CA  LYS    53      13.973   5.985   2.092  1.00 44.35           C 
ATOM    817  C   LYS    53      14.402   4.645   2.705  1.00 65.12           C 
ATOM    818  O   LYS    53      13.600   3.947   3.329  1.00 32.25           O 
ATOM    819  CB  LYS    53      13.507   6.929   3.210  1.00 52.32           C 
ATOM    820  CG  LYS    53      13.434   8.396   2.797  1.00 14.52           C 
ATOM    821  CD  LYS    53      12.721   9.250   3.847  1.00 75.52           C 
ATOM    822  CE  LYS    53      13.407   9.167   5.208  1.00 21.32           C 
ATOM    823  NZ  LYS    53      12.598   9.794   6.286  1.00 20.35           N 
ATOM    824  H   LYS    53      12.035   5.480   1.379  1.00 36.29           H 
ATOM    825  HA  LYS    53      14.828   6.428   1.599  1.00 12.25           H 
ATOM    826 3HB  LYS    53      14.192   6.849   4.043  1.00 36.29           H 
ATOM    827 2HB  LYS    53      12.524   6.620   3.537  1.00 36.29           H 
ATOM    828 3HG  LYS    53      12.898   8.470   1.863  1.00 36.29           H 
ATOM    829 2HG  LYS    53      14.439   8.773   2.665  1.00 36.29           H 
ATOM    830 3HD  LYS    53      11.700   8.903   3.945  1.00 36.29           H 
ATOM    831 2HD  LYS    53      12.719  10.279   3.516  1.00 36.29           H 
ATOM    832 3HE  LYS    53      14.361   9.671   5.148  1.00 36.29           H 
ATOM    833 2HE  LYS    53      13.569   8.127   5.454  1.00 36.29           H 
ATOM    834 1HZ  LYS    53      12.489  10.812   6.116  1.00 36.29           H 
ATOM    835 2HZ  LYS    53      13.065   9.656   7.207  1.00 36.29           H 
ATOM    836 3HZ  LYS    53      11.653   9.357   6.325  1.00 36.29           H 
ATOM    837  N   ILE    54      15.672   4.297   2.514  1.00 51.25           N 
ATOM    838  CA  ILE    54      16.270   3.111   3.134  1.00 23.41           C 
ATOM    839  C   ILE    54      17.572   3.492   3.847  1.00 53.31           C 
ATOM    840  O   ILE    54      18.478   4.059   3.236  1.00 31.01           O 
ATOM    841  CB  ILE    54      16.563   2.000   2.093  1.00 43.32           C 
ATOM    842  CG1 ILE    54      15.263   1.574   1.392  1.00  2.52           C 
ATOM    843  CG2 ILE    54      17.241   0.798   2.756  1.00 24.40           C 
ATOM    844  CD1 ILE    54      15.453   0.476   0.368  1.00 41.13           C 
ATOM    845  H   ILE    54      16.232   4.858   1.933  1.00 36.29           H 
ATOM    846  HA  ILE    54      15.572   2.721   3.864  1.00 73.43           H 
ATOM    847  HB  ILE    54      17.245   2.400   1.355  1.00 72.43           H 
ATOM    848 3HG1 ILE    54      14.840   2.430   0.885  1.00 36.29           H 
ATOM    849 2HG1 ILE    54      14.560   1.218   2.132  1.00 36.29           H 
ATOM    850 1HG2 ILE    54      18.154   1.118   3.239  1.00 36.29           H 
ATOM    851 2HG2 ILE    54      17.476   0.055   2.007  1.00 36.29           H 
ATOM    852 3HG2 ILE    54      16.578   0.367   3.493  1.00 36.29           H 
ATOM    853 1HD1 ILE    54      16.145   0.806  -0.391  1.00 36.29           H 
ATOM    854 2HD1 ILE    54      14.502   0.247  -0.089  1.00 36.29           H 
ATOM    855 3HD1 ILE    54      15.843  -0.408   0.852  1.00 36.29           H 
ATOM    856  N   GLY    55      17.662   3.191   5.137  1.00 43.33           N 
ATOM    857  CA  GLY    55      18.825   3.595   5.916  1.00  4.11           C 
ATOM    858  C   GLY    55      19.059   5.101   5.884  1.00 44.34           C 
ATOM    859  O   GLY    55      20.193   5.558   5.713  1.00 62.45           O 
ATOM    860  H   GLY    55      16.943   2.680   5.562  1.00 36.29           H 
ATOM    861 3HA  GLY    55      19.698   3.098   5.523  1.00 36.29           H 
ATOM    862 2HA  GLY    55      18.681   3.289   6.941  1.00 36.29           H 
ATOM    863  N   ASN    56      17.966   5.859   6.020  1.00 23.43           N 
ATOM    864  CA  ASN    56      17.985   7.332   6.019  1.00 24.01           C 
ATOM    865  C   ASN    56      18.160   7.926   4.601  1.00 44.12           C 
ATOM    866  O   ASN    56      17.672   9.022   4.322  1.00 43.12           O 
ATOM    867  CB  ASN    56      19.075   7.872   6.964  1.00  5.22           C 
ATOM    868  CG  ASN    56      18.955   9.369   7.204  1.00 31.32           C 
ATOM    869  OD1 ASN    56      19.509  10.179   6.468  1.00 62.00           O 
ATOM    870  ND2 ASN    56      18.236   9.752   8.240  1.00  4.13           N 
ATOM    871  H   ASN    56      17.103   5.407   6.132  1.00 36.29           H 
ATOM    872  HA  ASN    56      17.023   7.654   6.395  1.00 23.35           H 
ATOM    873 3HB  ASN    56      20.046   7.671   6.533  1.00 36.29           H 
ATOM    874 2HB  ASN    56      19.000   7.366   7.916  1.00 36.29           H 
ATOM    875 1HD2 ASN    56      17.820   9.061   8.797  1.00 36.29           H 
ATOM    876 2HD2 ASN    56      18.152  10.712   8.415  1.00 36.29           H 
ATOM    877  N   ARG    57      18.831   7.200   3.704  1.00  2.33           N 
ATOM    878  CA  ARG    57      19.129   7.721   2.360  1.00 43.52           C 
ATOM    879  C   ARG    57      17.997   7.417   1.360  1.00 52.21           C 
ATOM    880  O   ARG    57      17.310   6.399   1.466  1.00 63.30           O 
ATOM    881  CB  ARG    57      20.461   7.143   1.852  1.00 74.32           C 
ATOM    882  CG  ARG    57      20.467   5.624   1.703  1.00 64.12           C 
ATOM    883  CD  ARG    57      21.866   5.082   1.432  1.00 25.23           C 
ATOM    884  NE  ARG    57      21.877   3.625   1.305  1.00 41.34           N 
ATOM    885  CZ  ARG    57      21.857   2.794   2.312  1.00  0.11           C 
ATOM    886  NH1 ARG    57      21.805   3.224   3.536  1.00 43.11           N 
ATOM    887  NH2 ARG    57      21.892   1.524   2.089  1.00  4.44           N 
ATOM    888  H   ARG    57      19.122   6.295   3.940  1.00 36.29           H 
ATOM    889  HA  ARG    57      19.231   8.794   2.441  1.00 55.54           H 
ATOM    890 3HB  ARG    57      21.242   7.417   2.547  1.00 36.29           H 
ATOM    891 2HB  ARG    57      20.686   7.579   0.888  1.00 36.29           H 
ATOM    892 3HG  ARG    57      19.818   5.348   0.883  1.00 36.29           H 
ATOM    893 2HG  ARG    57      20.095   5.182   2.617  1.00 36.29           H 
ATOM    894 3HD  ARG    57      22.517   5.369   2.245  1.00 36.29           H 
ATOM    895 2HD  ARG    57      22.232   5.513   0.511  1.00 36.29           H 
ATOM    896  HE  ARG    57      21.916   3.251   0.399  1.00 43.20           H 
ATOM    897 1HH1 ARG    57      21.780   4.201   3.720  1.00 36.29           H 
ATOM    898 2HH1 ARG    57      21.789   2.571   4.291  1.00 36.29           H 
ATOM    899 1HH2 ARG    57      21.937   1.188   1.149  1.00 36.29           H 
ATOM    900 2HH2 ARG    57      21.876   0.883   2.852  1.00 36.29           H 
ATOM    901  N   ASN    58      17.806   8.314   0.392  1.00  2.41           N 
ATOM    902  CA  ASN    58      16.763   8.148  -0.629  1.00  2.41           C 
ATOM    903  C   ASN    58      17.240   7.279  -1.803  1.00  2.33           C 
ATOM    904  O   ASN    58      18.232   7.601  -2.464  1.00 63.11           O 
ATOM    905  CB  ASN    58      16.314   9.515  -1.150  1.00 41.10           C 
ATOM    906  CG  ASN    58      15.650  10.352  -0.075  1.00 13.22           C 
ATOM    907  OD1 ASN    58      16.304  11.093   0.645  1.00 44.15           O 
ATOM    908  ND2 ASN    58      14.343  10.240   0.041  1.00 24.54           N 
ATOM    909  H   ASN    58      18.373   9.114   0.368  1.00 36.29           H 
ATOM    910  HA  ASN    58      15.918   7.660  -0.161  1.00 24.10           H 
ATOM    911 3HB  ASN    58      15.611   9.375  -1.960  1.00 36.29           H 
ATOM    912 2HB  ASN    58      17.174  10.055  -1.521  1.00 36.29           H 
ATOM    913 1HD2 ASN    58      13.876   9.632  -0.565  1.00 36.29           H 
ATOM    914 2HD2 ASN    58      13.897  10.779   0.725  1.00 36.29           H 
ATOM    915  N   ILE    59      16.520   6.190  -2.068  1.00 34.32           N 
ATOM    916  CA  ILE    59      16.845   5.283  -3.179  1.00 73.51           C 
ATOM    917  C   ILE    59      15.782   5.354  -4.293  1.00 70.25           C 
ATOM    918  O   ILE    59      14.581   5.247  -4.028  1.00 22.13           O 
ATOM    919  CB  ILE    59      16.965   3.815  -2.690  1.00 23.45           C 
ATOM    920  CG1 ILE    59      18.032   3.695  -1.584  1.00 74.33           C 
ATOM    921  CG2 ILE    59      17.285   2.875  -3.856  1.00 15.02           C 
ATOM    922  CD1 ILE    59      19.432   4.079  -2.022  1.00 13.53           C 
ATOM    923  H   ILE    59      15.749   5.984  -1.499  1.00 36.29           H 
ATOM    924  HA  ILE    59      17.801   5.584  -3.588  1.00  1.30           H 
ATOM    925  HB  ILE    59      16.007   3.519  -2.283  1.00 64.41           H 
ATOM    926 3HG1 ILE    59      18.065   2.674  -1.232  1.00 36.29           H 
ATOM    927 2HG1 ILE    59      17.758   4.341  -0.763  1.00 36.29           H 
ATOM    928 1HG2 ILE    59      18.205   3.188  -4.332  1.00 36.29           H 
ATOM    929 2HG2 ILE    59      16.479   2.907  -4.577  1.00 36.29           H 
ATOM    930 3HG2 ILE    59      17.397   1.866  -3.488  1.00 36.29           H 
ATOM    931 1HD1 ILE    59      19.444   5.115  -2.326  1.00 36.29           H 
ATOM    932 2HD1 ILE    59      19.737   3.456  -2.851  1.00 36.29           H 
ATOM    933 3HD1 ILE    59      20.116   3.939  -1.198  1.00 36.29           H 
ATOM    934  N   THR    60      16.233   5.539  -5.535  1.00 43.10           N 
ATOM    935  CA  THR    60      15.336   5.545  -6.700  1.00 34.12           C 
ATOM    936  C   THR    60      15.132   4.123  -7.238  1.00 54.15           C 
ATOM    937  O   THR    60      16.057   3.511  -7.776  1.00 51.13           O 
ATOM    938  CB  THR    60      15.885   6.435  -7.843  1.00 74.34           C 
ATOM    939  OG1 THR    60      16.092   7.782  -7.384  1.00 72.30           O 
ATOM    940  CG2 THR    60      14.931   6.456  -9.033  1.00 65.10           C 
ATOM    941  H   THR    60      17.195   5.672  -5.675  1.00 36.29           H 
ATOM    942  HA  THR    60      14.381   5.945  -6.386  1.00 51.21           H 
ATOM    943  HB  THR    60      16.833   6.027  -8.171  1.00 73.51           H 
ATOM    944  HG1 THR    60      16.320   7.772  -6.444  1.00 72.44           H 
ATOM    945 1HG2 THR    60      14.822   5.455  -9.430  1.00 36.29           H 
ATOM    946 2HG2 THR    60      15.328   7.103  -9.801  1.00 36.29           H 
ATOM    947 3HG2 THR    60      13.967   6.826  -8.716  1.00 36.29           H 
ATOM    948  N   LEU    61      13.915   3.606  -7.108  1.00 63.14           N 
ATOM    949  CA  LEU    61      13.625   2.206  -7.443  1.00 44.53           C 
ATOM    950  C   LEU    61      12.578   2.113  -8.578  1.00 20.35           C 
ATOM    951  O   LEU    61      11.699   2.967  -8.695  1.00 64.34           O 
ATOM    952  CB  LEU    61      13.140   1.497  -6.161  1.00 44.33           C 
ATOM    953  CG  LEU    61      13.415  -0.016  -6.057  1.00 34.51           C 
ATOM    954  CD1 LEU    61      12.478  -0.813  -6.944  1.00 22.52           C 
ATOM    955  CD2 LEU    61      14.871  -0.328  -6.396  1.00 62.10           C 
ATOM    956  H   LEU    61      13.189   4.176  -6.775  1.00 36.29           H 
ATOM    957  HA  LEU    61      14.543   1.742  -7.778  1.00 54.23           H 
ATOM    958 3HB  LEU    61      12.072   1.651  -6.075  1.00 36.29           H 
ATOM    959 2HB  LEU    61      13.614   1.977  -5.314  1.00 36.29           H 
ATOM    960  HG  LEU    61      13.241  -0.331  -5.035  1.00 61.22           H 
ATOM    961 1HD1 LEU    61      12.664  -0.570  -7.980  1.00 36.29           H 
ATOM    962 2HD1 LEU    61      11.454  -0.571  -6.697  1.00 36.29           H 
ATOM    963 3HD1 LEU    61      12.644  -1.869  -6.787  1.00 36.29           H 
ATOM    964 1HD2 LEU    61      15.048  -1.387  -6.287  1.00 36.29           H 
ATOM    965 2HD2 LEU    61      15.523   0.215  -5.725  1.00 36.29           H 
ATOM    966 3HD2 LEU    61      15.078  -0.032  -7.415  1.00 36.29           H 
ATOM    967  N   ARG    62      12.687   1.084  -9.426  1.00  5.25           N 
ATOM    968  CA  ARG    62      11.758   0.904 -10.564  1.00  0.12           C 
ATOM    969  C   ARG    62      10.657  -0.116 -10.205  1.00 14.25           C 
ATOM    970  O   ARG    62      10.910  -1.052  -9.452  1.00 12.44           O 
ATOM    971  CB  ARG    62      12.532   0.418 -11.809  1.00 14.05           C 
ATOM    972  CG  ARG    62      13.974   0.922 -11.884  1.00  0.13           C 
ATOM    973  CD  ARG    62      14.068   2.445 -11.941  1.00 64.11           C 
ATOM    974  NE  ARG    62      15.370   2.916 -11.472  1.00 64.20           N 
ATOM    975  CZ  ARG    62      15.885   4.079 -11.755  1.00 11.14           C 
ATOM    976  NH1 ARG    62      15.305   4.866 -12.604  1.00 64.40           N 
ATOM    977  NH2 ARG    62      17.003   4.441 -11.208  1.00  5.21           N 
ATOM    978  H   ARG    62      13.403   0.422  -9.283  1.00 36.29           H 
ATOM    979  HA  ARG    62      11.298   1.859 -10.781  1.00 55.31           H 
ATOM    980 3HB  ARG    62      12.012   0.753 -12.697  1.00 36.29           H 
ATOM    981 2HB  ARG    62      12.555  -0.664 -11.808  1.00 36.29           H 
ATOM    982 3HG  ARG    62      14.442   0.507 -12.768  1.00 36.29           H 
ATOM    983 2HG  ARG    62      14.505   0.577 -11.007  1.00 36.29           H 
ATOM    984 3HD  ARG    62      13.295   2.869 -11.315  1.00 36.29           H 
ATOM    985 2HD  ARG    62      13.922   2.767 -12.962  1.00 36.29           H 
ATOM    986  HE  ARG    62      15.872   2.323 -10.873  1.00 11.33           H 
ATOM    987 1HH1 ARG    62      14.461   4.583 -13.052  1.00 36.29           H 
ATOM    988 2HH1 ARG    62      15.709   5.756 -12.810  1.00 36.29           H 
ATOM    989 1HH2 ARG    62      17.467   3.827 -10.572  1.00 36.29           H 
ATOM    990 2HH2 ARG    62      17.398   5.335 -11.418  1.00 36.29           H 
ATOM    991  N   LYS    63       9.444   0.040 -10.757  1.00 50.11           N 
ATOM    992  CA  LYS    63       8.329  -0.874 -10.418  1.00 15.24           C 
ATOM    993  C   LYS    63       8.701  -2.345 -10.655  1.00  2.52           C 
ATOM    994  O   LYS    63       8.415  -3.199  -9.816  1.00  5.44           O 
ATOM    995  CB  LYS    63       7.044  -0.544 -11.199  1.00 12.43           C 
ATOM    996  CG  LYS    63       6.342   0.734 -10.740  1.00 21.11           C 
ATOM    997  CD  LYS    63       4.849   0.729 -11.083  1.00 33.00           C 
ATOM    998  CE  LYS    63       4.593   0.579 -12.581  1.00 42.00           C 
ATOM    999  NZ  LYS    63       4.997   1.787 -13.349  1.00 30.20           N 
ATOM   1000  H   LYS    63       9.297   0.764 -11.402  1.00 36.29           H 
ATOM   1001  HA  LYS    63       8.127  -0.747  -9.363  1.00 14.34           H 
ATOM   1002 3HB  LYS    63       6.350  -1.367 -11.091  1.00 36.29           H 
ATOM   1003 2HB  LYS    63       7.292  -0.435 -12.246  1.00 36.29           H 
ATOM   1004 3HG  LYS    63       6.808   1.576 -11.224  1.00 36.29           H 
ATOM   1005 2HG  LYS    63       6.450   0.831  -9.669  1.00 36.29           H 
ATOM   1006 3HD  LYS    63       4.413   1.658 -10.746  1.00 36.29           H 
ATOM   1007 2HD  LYS    63       4.377  -0.094 -10.567  1.00 36.29           H 
ATOM   1008 3HE  LYS    63       3.537   0.405 -12.736  1.00 36.29           H 
ATOM   1009 2HE  LYS    63       5.150  -0.269 -12.949  1.00 36.29           H 
ATOM   1010 1HZ  LYS    63       5.989   2.028 -13.153  1.00 36.29           H 
ATOM   1011 2HZ  LYS    63       4.396   2.594 -13.092  1.00 36.29           H 
ATOM   1012 3HZ  LYS    63       4.895   1.610 -14.369  1.00 36.29           H 
ATOM   1013  N   ARG    64       9.357  -2.628 -11.783  1.00  1.34           N 
ATOM   1014  CA  ARG    64       9.785  -3.998 -12.110  1.00 73.25           C 
ATOM   1015  C   ARG    64      10.526  -4.656 -10.924  1.00 60.40           C 
ATOM   1016  O   ARG    64      10.294  -5.819 -10.597  1.00 45.22           O 
ATOM   1017  CB  ARG    64      10.710  -3.987 -13.337  1.00  4.23           C 
ATOM   1018  CG  ARG    64      12.009  -3.221 -13.102  1.00 64.14           C 
ATOM   1019  CD  ARG    64      13.114  -3.634 -14.063  1.00 24.41           C 
ATOM   1020  NE  ARG    64      14.441  -3.279 -13.558  1.00 43.52           N 
ATOM   1021  CZ  ARG    64      15.548  -3.868 -13.929  1.00 14.12           C 
ATOM   1022  NH1 ARG    64      15.524  -4.827 -14.799  1.00 23.40           N 
ATOM   1023  NH2 ARG    64      16.678  -3.515 -13.404  1.00 63.42           N 
ATOM   1024  H   ARG    64       9.545  -1.903 -12.419  1.00 36.29           H 
ATOM   1025  HA  ARG    64       8.901  -4.578 -12.339  1.00  4.42           H 
ATOM   1026 3HB  ARG    64      10.189  -3.529 -14.167  1.00 36.29           H 
ATOM   1027 2HB  ARG    64      10.956  -5.008 -13.598  1.00 36.29           H 
ATOM   1028 3HG  ARG    64      12.337  -3.408 -12.093  1.00 36.29           H 
ATOM   1029 2HG  ARG    64      11.819  -2.164 -13.222  1.00 36.29           H 
ATOM   1030 3HD  ARG    64      12.954  -3.136 -15.010  1.00 36.29           H 
ATOM   1031 2HD  ARG    64      13.069  -4.704 -14.209  1.00 36.29           H 
ATOM   1032  HE  ARG    64      14.499  -2.571 -12.887  1.00 41.34           H 
ATOM   1033 1HH1 ARG    64      14.658  -5.123 -15.190  1.00 36.29           H 
ATOM   1034 2HH1 ARG    64      16.374  -5.269 -15.073  1.00 36.29           H 
ATOM   1035 1HH2 ARG    64      16.702  -2.795 -12.705  1.00 36.29           H 
ATOM   1036 2HH2 ARG    64      17.520  -3.961 -13.693  1.00 36.29           H 
ATOM   1037  N   GLU    65      11.404  -3.880 -10.285  1.00 61.05           N 
ATOM   1038  CA  GLU    65      12.196  -4.349  -9.145  1.00 55.32           C 
ATOM   1039  C   GLU    65      11.343  -4.329  -7.870  1.00  3.51           C 
ATOM   1040  O   GLU    65      11.424  -5.222  -7.029  1.00 44.33           O 
ATOM   1041  CB  GLU    65      13.432  -3.442  -8.974  1.00  1.13           C 
ATOM   1042  CG  GLU    65      14.341  -3.388 -10.209  1.00 41.14           C 
ATOM   1043  CD  GLU    65      15.236  -2.153 -10.271  1.00 41.31           C 
ATOM   1044  OE1 GLU    65      16.203  -2.161 -11.068  1.00  4.52           O 
ATOM   1045  OE2 GLU    65      14.960  -1.162  -9.560  1.00 15.04           O 
ATOM   1046  H   GLU    65      11.512  -2.954 -10.578  1.00 36.29           H 
ATOM   1047  HA  GLU    65      12.518  -5.362  -9.343  1.00  5.33           H 
ATOM   1048 3HB  GLU    65      14.017  -3.802  -8.139  1.00 36.29           H 
ATOM   1049 2HB  GLU    65      13.096  -2.438  -8.757  1.00 36.29           H 
ATOM   1050 3HG  GLU    65      13.725  -3.403 -11.093  1.00 36.29           H 
ATOM   1051 2HG  GLU    65      14.972  -4.264 -10.208  1.00 36.29           H 
ATOM   1052  N   ALA    66      10.501  -3.306  -7.759  1.00 74.01           N 
ATOM   1053  CA  ALA    66       9.648  -3.105  -6.586  1.00 54.13           C 
ATOM   1054  C   ALA    66       8.618  -4.233  -6.402  1.00 62.01           C 
ATOM   1055  O   ALA    66       8.259  -4.570  -5.274  1.00 65.11           O 
ATOM   1056  CB  ALA    66       8.948  -1.759  -6.691  1.00 33.23           C 
ATOM   1057  H   ALA    66      10.452  -2.660  -8.493  1.00 36.29           H 
ATOM   1058  HA  ALA    66      10.289  -3.077  -5.714  1.00  4.22           H 
ATOM   1059 1HB  ALA    66       8.336  -1.741  -7.582  1.00 36.29           H 
ATOM   1060 2HB  ALA    66       9.685  -0.971  -6.747  1.00 36.29           H 
ATOM   1061 3HB  ALA    66       8.324  -1.606  -5.823  1.00 36.29           H 
ATOM   1062  N   ASP    67       8.148  -4.812  -7.509  1.00 12.11           N 
ATOM   1063  CA  ASP    67       7.185  -5.920  -7.452  1.00  0.15           C 
ATOM   1064  C   ASP    67       7.825  -7.206  -6.901  1.00  3.24           C 
ATOM   1065  O   ASP    67       7.137  -8.193  -6.647  1.00 33.51           O 
ATOM   1066  CB  ASP    67       6.581  -6.186  -8.836  1.00  4.12           C 
ATOM   1067  CG  ASP    67       5.732  -5.032  -9.343  1.00 11.24           C 
ATOM   1068  OD1 ASP    67       5.988  -4.550 -10.467  1.00 73.02           O 
ATOM   1069  OD2 ASP    67       4.789  -4.615  -8.630  1.00 34.24           O 
ATOM   1070  H   ASP    67       8.452  -4.485  -8.384  1.00 36.29           H 
ATOM   1071  HA  ASP    67       6.391  -5.623  -6.780  1.00 33.35           H 
ATOM   1072 3HB  ASP    67       5.960  -7.071  -8.786  1.00 36.29           H 
ATOM   1073 2HB  ASP    67       7.382  -6.358  -9.541  1.00 36.29           H 
ATOM   1074  N   LEU    68       9.144  -7.192  -6.731  1.00 24.35           N 
ATOM   1075  CA  LEU    68       9.874  -8.339  -6.185  1.00 61.32           C 
ATOM   1076  C   LEU    68      10.061  -8.228  -4.664  1.00  1.11           C 
ATOM   1077  O   LEU    68      10.298  -9.226  -3.985  1.00 74.44           O 
ATOM   1078  CB  LEU    68      11.237  -8.455  -6.881  1.00 72.30           C 
ATOM   1079  CG  LEU    68      11.162  -8.742  -8.387  1.00 74.11           C 
ATOM   1080  CD1 LEU    68      12.512  -8.513  -9.052  1.00 61.03           C 
ATOM   1081  CD2 LEU    68      10.673 -10.168  -8.626  1.00 22.12           C 
ATOM   1082  H   LEU    68       9.645  -6.389  -6.989  1.00 36.29           H 
ATOM   1083  HA  LEU    68       9.299  -9.232  -6.397  1.00 54.21           H 
ATOM   1084 3HB  LEU    68      11.796  -9.254  -6.412  1.00 36.29           H 
ATOM   1085 2HB  LEU    68      11.774  -7.529  -6.733  1.00 36.29           H 
ATOM   1086  HG  LEU    68      10.451  -8.066  -8.840  1.00 51.12           H 
ATOM   1087 1HD1 LEU    68      12.827  -7.491  -8.889  1.00 36.29           H 
ATOM   1088 2HD1 LEU    68      12.427  -8.695 -10.113  1.00 36.29           H 
ATOM   1089 3HD1 LEU    68      13.245  -9.185  -8.630  1.00 36.29           H 
ATOM   1090 1HD2 LEU    68       9.688 -10.288  -8.197  1.00 36.29           H 
ATOM   1091 2HD2 LEU    68      11.353 -10.868  -8.161  1.00 36.29           H 
ATOM   1092 3HD2 LEU    68      10.627 -10.361  -9.687  1.00 36.29           H 
ATOM   1093  N   ILE    69       9.953  -7.016  -4.126  1.00 32.41           N 
ATOM   1094  CA  ILE    69      10.132  -6.802  -2.685  1.00 63.31           C 
ATOM   1095  C   ILE    69       8.779  -6.750  -1.955  1.00 63.13           C 
ATOM   1096  O   ILE    69       8.015  -5.790  -2.086  1.00 64.30           O 
ATOM   1097  CB  ILE    69      10.945  -5.510  -2.371  1.00 24.51           C 
ATOM   1098  CG1 ILE    69      12.412  -5.639  -2.835  1.00 14.50           C 
ATOM   1099  CG2 ILE    69      10.899  -5.195  -0.876  1.00 21.25           C 
ATOM   1100  CD1 ILE    69      12.599  -5.655  -4.336  1.00  2.34           C 
ATOM   1101  H   ILE    69       9.739  -6.251  -4.703  1.00 36.29           H 
ATOM   1102  HA  ILE    69      10.693  -7.646  -2.300  1.00 72.51           H 
ATOM   1103  HB  ILE    69      10.482  -4.687  -2.898  1.00 43.31           H 
ATOM   1104 3HG1 ILE    69      12.827  -6.556  -2.440  1.00 36.29           H 
ATOM   1105 2HG1 ILE    69      12.979  -4.804  -2.449  1.00 36.29           H 
ATOM   1106 1HG2 ILE    69      11.498  -4.318  -0.674  1.00 36.29           H 
ATOM   1107 2HG2 ILE    69      11.290  -6.033  -0.317  1.00 36.29           H 
ATOM   1108 3HG2 ILE    69       9.878  -5.008  -0.578  1.00 36.29           H 
ATOM   1109 1HD1 ILE    69      12.101  -6.517  -4.753  1.00 36.29           H 
ATOM   1110 2HD1 ILE    69      13.653  -5.703  -4.566  1.00 36.29           H 
ATOM   1111 3HD1 ILE    69      12.179  -4.756  -4.762  1.00 36.29           H 
ATOM   1112  N   GLU    70       8.493  -7.803  -1.192  1.00 51.00           N 
ATOM   1113  CA  GLU    70       7.270  -7.889  -0.385  1.00 21.43           C 
ATOM   1114  C   GLU    70       7.465  -7.194   0.973  1.00  1.31           C 
ATOM   1115  O   GLU    70       8.252  -7.642   1.806  1.00  1.33           O 
ATOM   1116  CB  GLU    70       6.887  -9.371  -0.196  1.00 12.20           C 
ATOM   1117  CG  GLU    70       5.743  -9.638   0.787  1.00 34.43           C 
ATOM   1118  CD  GLU    70       4.419  -8.995   0.395  1.00 23.32           C 
ATOM   1119  OE1 GLU    70       3.749  -8.420   1.280  1.00 75.23           O 
ATOM   1120  OE2 GLU    70       4.032  -9.066  -0.790  1.00 11.32           O 
ATOM   1121  H   GLU    70       9.129  -8.550  -1.169  1.00 36.29           H 
ATOM   1122  HA  GLU    70       6.479  -7.388  -0.924  1.00 40.21           H 
ATOM   1123 3HB  GLU    70       7.760  -9.908   0.153  1.00 36.29           H 
ATOM   1124 2HB  GLU    70       6.597  -9.775  -1.156  1.00 36.29           H 
ATOM   1125 3HG  GLU    70       6.035  -9.264   1.760  1.00 36.29           H 
ATOM   1126 2HG  GLU    70       5.591 -10.705   0.853  1.00 36.29           H 
ATOM   1127  N   VAL    71       6.751  -6.087   1.181  1.00 21.13           N 
ATOM   1128  CA  VAL    71       6.847  -5.305   2.424  1.00  4.42           C 
ATOM   1129  C   VAL    71       5.549  -5.384   3.248  1.00 51.21           C 
ATOM   1130  O   VAL    71       4.533  -5.888   2.774  1.00 71.21           O 
ATOM   1131  CB  VAL    71       7.179  -3.817   2.132  1.00 72.43           C 
ATOM   1132  CG1 VAL    71       8.526  -3.696   1.429  1.00 43.24           C 
ATOM   1133  CG2 VAL    71       6.079  -3.153   1.303  1.00 63.42           C 
ATOM   1134  H   VAL    71       6.138  -5.787   0.480  1.00 36.29           H 
ATOM   1135  HA  VAL    71       7.655  -5.719   3.016  1.00 44.22           H 
ATOM   1136  HB  VAL    71       7.249  -3.296   3.078  1.00 15.34           H 
ATOM   1137 1HG1 VAL    71       8.475  -4.172   0.461  1.00 36.29           H 
ATOM   1138 2HG1 VAL    71       9.287  -4.178   2.027  1.00 36.29           H 
ATOM   1139 3HG1 VAL    71       8.776  -2.652   1.304  1.00 36.29           H 
ATOM   1140 1HG2 VAL    71       5.952  -3.688   0.372  1.00 36.29           H 
ATOM   1141 2HG2 VAL    71       6.351  -2.128   1.094  1.00 36.29           H 
ATOM   1142 3HG2 VAL    71       5.151  -3.169   1.855  1.00 36.29           H 
ATOM   1143  N   GLU    72       5.591  -4.909   4.494  1.00 13.21           N 
ATOM   1144  CA  GLU    72       4.400  -4.901   5.363  1.00 65.30           C 
ATOM   1145  C   GLU    72       4.184  -3.529   6.021  1.00 61.31           C 
ATOM   1146  O   GLU    72       5.122  -2.926   6.542  1.00 33.12           O 
ATOM   1147  CB  GLU    72       4.518  -5.986   6.443  1.00 42.04           C 
ATOM   1148  CG  GLU    72       5.703  -5.806   7.386  1.00 60.42           C 
ATOM   1149  CD  GLU    72       5.798  -6.915   8.420  1.00 64.32           C 
ATOM   1150  OE1 GLU    72       4.933  -6.973   9.319  1.00 14.44           O 
ATOM   1151  OE2 GLU    72       6.733  -7.738   8.334  1.00 13.42           O 
ATOM   1152  H   GLU    72       6.440  -4.563   4.844  1.00 36.29           H 
ATOM   1153  HA  GLU    72       3.541  -5.122   4.744  1.00 12.44           H 
ATOM   1154 3HB  GLU    72       4.616  -6.946   5.957  1.00 36.29           H 
ATOM   1155 2HB  GLU    72       3.613  -5.988   7.036  1.00 36.29           H 
ATOM   1156 3HG  GLU    72       5.599  -4.860   7.901  1.00 36.29           H 
ATOM   1157 2HG  GLU    72       6.613  -5.795   6.800  1.00 36.29           H 
ATOM   1158  N   VAL    73       2.943  -3.048   6.001  1.00 73.32           N 
ATOM   1159  CA  VAL    73       2.608  -1.733   6.556  1.00 54.30           C 
ATOM   1160  C   VAL    73       2.806  -1.678   8.083  1.00  2.11           C 
ATOM   1161  O   VAL    73       2.025  -2.247   8.849  1.00 23.41           O 
ATOM   1162  CB  VAL    73       1.148  -1.340   6.212  1.00 71.11           C 
ATOM   1163  CG1 VAL    73       0.792   0.029   6.795  1.00 61.40           C 
ATOM   1164  CG2 VAL    73       0.931  -1.360   4.699  1.00  2.40           C 
ATOM   1165  H   VAL    73       2.230  -3.593   5.602  1.00 36.29           H 
ATOM   1166  HA  VAL    73       3.266  -1.006   6.097  1.00 74.10           H 
ATOM   1167  HB  VAL    73       0.488  -2.074   6.654  1.00 30.21           H 
ATOM   1168 1HG1 VAL    73       1.472   0.775   6.409  1.00 36.29           H 
ATOM   1169 2HG1 VAL    73       0.870  -0.005   7.873  1.00 36.29           H 
ATOM   1170 3HG1 VAL    73      -0.221   0.288   6.517  1.00 36.29           H 
ATOM   1171 1HG2 VAL    73      -0.095  -1.102   4.478  1.00 36.29           H 
ATOM   1172 2HG2 VAL    73       1.143  -2.348   4.317  1.00 36.29           H 
ATOM   1173 3HG2 VAL    73       1.590  -0.644   4.228  1.00 36.29           H 
ATOM   1174  N   VAL    74       3.851  -0.968   8.515  1.00 21.41           N 
ATOM   1175  CA  VAL    74       4.168  -0.824   9.945  1.00 24.21           C 
ATOM   1176  C   VAL    74       3.105   0.028  10.673  1.00 65.34           C 
ATOM   1177  O   VAL    74       3.011   0.016  11.901  1.00 40.43           O 
ATOM   1178  CB  VAL    74       5.574  -0.184  10.142  1.00 31.32           C 
ATOM   1179  CG1 VAL    74       5.956  -0.116  11.621  1.00  5.25           C 
ATOM   1180  CG2 VAL    74       6.631  -0.953   9.348  1.00 53.13           C 
ATOM   1181  H   VAL    74       4.428  -0.528   7.853  1.00 36.29           H 
ATOM   1182  HA  VAL    74       4.180  -1.813  10.383  1.00 43.12           H 
ATOM   1183  HB  VAL    74       5.538   0.828   9.759  1.00 60.52           H 
ATOM   1184 1HG1 VAL    74       6.930   0.343  11.724  1.00 36.29           H 
ATOM   1185 2HG1 VAL    74       5.985  -1.114  12.034  1.00 36.29           H 
ATOM   1186 3HG1 VAL    74       5.225   0.471  12.157  1.00 36.29           H 
ATOM   1187 1HG2 VAL    74       6.384  -0.926   8.296  1.00 36.29           H 
ATOM   1188 2HG2 VAL    74       6.661  -1.979   9.684  1.00 36.29           H 
ATOM   1189 3HG2 VAL    74       7.601  -0.498   9.500  1.00 36.29           H 
END
