
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 ( 1351),  selected   87 , name 1qvp_A
# Molecule2: number of CA atoms   74 ( 1189),  selected   74 , name T0462_1_74.pdb
# PARAMETERS: 1qvp_A.T0462_1_74.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   140_A      -       -           -
LGA    S   141_A      -       -           -
LGA    H   142_A      -       -           -
LGA    M   143_A      -       -           -
LGA    D   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    A   146_A      -       -           -
LGA    A   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    T   150_A      M       1          2.509
LGA    R   151_A      K       2          2.963
LGA    V   152_A      L       3          2.120
LGA    I   153_A      S       4          2.747
LGA    D   154_A      R       5          2.900
LGA    A   155_A      L       6          2.188
LGA    A   156_A      V       7          3.560
LGA    T   157_A      -       -           -
LGA    S   158_A      -       -           -
LGA    M   159_A      P       8          4.021
LGA    P   160_A      G       9          2.850
LGA    R   161_A      V      10          0.668
LGA    K   162_A      P      11          0.333
LGA    V   163_A      A      12          0.480
LGA    R   164_A      R      13          0.641
LGA    I   165_A      I      14          0.898
LGA    V   166_A      K      15          1.163
LGA    Q   167_A      R      16          0.621
LGA    I   168_A      L      17          0.892
LGA    N   169_A      E      18          1.406
LGA    E   170_A      V      19          3.320
LGA    I   171_A      S      20          3.813
LGA    F   172_A      -       -           -
LGA    Q   173_A      G      21          4.558
LGA    V   174_A      E      22          3.541
LGA    E   175_A      L      23          5.362
LGA    T   176_A      H      24           -
LGA    D   177_A      E      25           -
LGA    Q   178_A      K      26          3.547
LGA    F   179_A      -       -           -
LGA    T   180_A      -       -           -
LGA    Q   181_A      L      27           #
LGA    L   182_A      V      28          4.512
LGA    L   183_A      G      29          1.683
LGA    D   184_A      M      30          5.551
LGA    A   185_A      G      31          3.595
LGA    D   186_A      -       -           -
LGA    I   187_A      F      32          3.655
LGA    R   188_A      V      33          0.890
LGA    V   189_A      P      34          0.952
LGA    G   190_A      G      35          0.574
LGA    S   191_A      E      36          2.050
LGA    E   192_A      E      37          1.044
LGA    V   193_A      I      38          1.689
LGA    E   194_A      E      39          0.565
LGA    I   195_A      I      40          1.675
LGA    V   196_A      V      41          3.704
LGA    -       -      Q      42           -
LGA    D   197_A      V      43          2.727
LGA    R   198_A      A      44          2.365
LGA    D   199_A      P      45          3.281
LGA    -       -      L      46           -
LGA    G   200_A      G      47          4.627
LGA    -       -      D      48           -
LGA    H   201_A      P      49          0.255
LGA    I   202_A      I      50          1.363
LGA    T   203_A      V      51          1.814
LGA    L   204_A      C      52          1.588
LGA    S   205_A      K      53          0.931
LGA    H   206_A      I      54          2.672
LGA    N   207_A      G      55          4.791
LGA    G   208_A      N      56          2.787
LGA    K   209_A      R      57          1.213
LGA    D   210_A      N      58          1.870
LGA    V   211_A      I      59          1.844
LGA    E   212_A      T      60          1.969
LGA    L   213_A      L      61          3.410
LGA    -       -      R      62           -
LGA    -       -      K      63           -
LGA    L   214_A      R      64          5.539
LGA    D   215_A      E      65          2.191
LGA    D   216_A      -       -           -
LGA    L   217_A      -       -           -
LGA    A   218_A      A      66          1.755
LGA    H   219_A      D      67          1.898
LGA    T   220_A      L      68          3.693
LGA    I   221_A      I      69          2.501
LGA    R   222_A      E      70          1.742
LGA    I   223_A      V      71          1.463
LGA    E   224_A      E      72          1.803
LGA    E   225_A      V      73          4.082
LGA    L   226_A      V      74          1.385

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87   74    5.0     66    2.74    19.70     57.231     2.323

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.773158 * X  +   0.631523 * Y  +  -0.058349 * Z  + -91.771271
  Y_new =   0.621681 * X  +  -0.772866 * Y  +  -0.127243 * Z  + -84.206314
  Z_new =  -0.125453 * X  +   0.062105 * Y  +  -0.990154 * Z  +  15.431675 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.078953   -0.062640  [ DEG:   176.4110     -3.5890 ]
  Theta =   0.125785    3.015808  [ DEG:     7.2069    172.7931 ]
  Phi   =   0.677224   -2.464369  [ DEG:    38.8021   -141.1979 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1qvp_A                                        
REMARK     2: T0462_1_74.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1qvp_A.T0462_1_74.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87   74   5.0   66   2.74   19.70  57.231
REMARK  ---------------------------------------------------------- 
MOLECULE 1qvp_A
HEADER    DNA BINDING PROTEIN                     28-AUG-03   1QVP              
TITLE     C TERMINAL SH3-LIKE DOMAIN FROM DIPHTHERIA TOXIN REPRESSOR            
TITLE    2 RESIDUES 144-226.                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DIPHTHERIA TOXIN REPRESSOR;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 144-226;                                          
COMPND   5 SYNONYM: IRON-DEPENDENT DIPHTHERIA TOX REGULATORY ELEMENT,           
COMPND   6 TOX REGULATORY FACTOR;                                               
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM DIPHTHERIAE;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: DTXR;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21(DE3);                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET-15B                               
KEYWDS    REPRESSOR, DTXR, C-TERMINAL DOMAIN, PROKARYOTIC SH3 DOMAIN,           
KEYWDS   2 TRANSCRIPTION REGULATION, PEPTIDE-BINDING, GENE REGULATION           
EXPDTA    NMR, 13 STRUCTURES                                                    
AUTHOR    G.P.WYLIE,V.RANGACHARI,E.A.BIENKIEWICZ,V.MARIN,                       
AUTHOR   2 N.BHATTACHARYA,J.F.LOVE,J.R.MURPHY,T.M.LOGAN                         
REVDAT   2   15-MAR-05 1QVP    1       JRNL                                     
REVDAT   1   02-NOV-04 1QVP    0                                                
JRNL        AUTH   G.P.WYLIE,V.RANGACHARI,E.A.BIENKIEWICZ,V.MARIN,              
JRNL        AUTH 2 N.BHATTACHARYA,J.F.LOVE,J.R.MURPHY,T.M.LOGAN                 
JRNL        TITL   PROLYLPEPTIDE BINDING BY THE PROKARYOTIC SH3-LIKE            
JRNL        TITL 2 DOMAIN OF THE DIPHTHERIA TOXIN REPRESSOR: A                  
JRNL        TITL 3 REGULATORY SWITCH.                                           
JRNL        REF    BIOCHEMISTRY                  V.  44    40 2005              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1QVP A  144   226  UNP    P33120   DTXR_CORDI     144    226             
SEQRES   1 A   87  GLY SER HIS MET ASP ALA ALA ALA PRO GLY THR ARG VAL          
SEQRES   2 A   87  ILE ASP ALA ALA THR SER MET PRO ARG LYS VAL ARG ILE          
SEQRES   3 A   87  VAL GLN ILE ASN GLU ILE PHE GLN VAL GLU THR ASP GLN          
SEQRES   4 A   87  PHE THR GLN LEU LEU ASP ALA ASP ILE ARG VAL GLY SER          
SEQRES   5 A   87  GLU VAL GLU ILE VAL ASP ARG ASP GLY HIS ILE THR LEU          
SEQRES   6 A   87  SER HIS ASN GLY LYS ASP VAL GLU LEU LEU ASP ASP LEU          
SEQRES   7 A   87  ALA HIS THR ILE ARG ILE GLU GLU LEU                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 140      -4.430 -17.263  13.535  1.00 10.47           N  
ATOM      2  CA  GLY A 140      -4.884 -16.294  12.499  1.00 10.56           C  
ATOM      3  C   GLY A 140      -3.944 -16.229  11.312  1.00 10.04           C  
ATOM      4  O   GLY A 140      -3.355 -15.185  11.035  1.00 10.08           O  
ATOM      5  HA2 GLY A 140      -5.864 -16.588  12.152  1.00 10.83           H  
ATOM      6  HA3 GLY A 140      -4.952 -15.313  12.945  1.00 10.96           H  
ATOM      7  H1  GLY A 140      -4.322 -18.209  13.116  1.00 10.29           H  
ATOM      8  H2  GLY A 140      -5.126 -17.315  14.305  1.00 10.45           H  
ATOM      9  H3  GLY A 140      -3.515 -16.962  13.928  1.00 10.82           H  
ATOM     10  N   SER A 141      -3.802 -17.349  10.609  1.00  9.76           N  
ATOM     11  CA  SER A 141      -2.926 -17.416   9.445  1.00  9.42           C  
ATOM     12  C   SER A 141      -3.681 -17.043   8.174  1.00  8.54           C  
ATOM     13  O   SER A 141      -4.675 -17.679   7.821  1.00  8.54           O  
ATOM     14  CB  SER A 141      -2.333 -18.820   9.307  1.00  9.90           C  
ATOM     15  OG  SER A 141      -1.256 -18.830   8.386  1.00 10.72           O  
ATOM     16  H   SER A 141      -4.299 -18.150  10.880  1.00  9.91           H  
ATOM     17  HA  SER A 141      -2.123 -16.709   9.594  1.00  9.69           H  
ATOM     18  HB2 SER A 141      -1.971 -19.152  10.268  1.00  9.80           H  
ATOM     19  HB3 SER A 141      -3.097 -19.497   8.956  1.00  9.94           H  
ATOM     20  HG  SER A 141      -0.472 -19.181   8.813  1.00 10.83           H  
ATOM     21  N   HIS A 142      -3.205 -16.008   7.490  1.00  8.03           N  
ATOM     22  CA  HIS A 142      -3.835 -15.549   6.258  1.00  7.37           C  
ATOM     23  C   HIS A 142      -3.233 -16.250   5.044  1.00  6.35           C  
ATOM     24  O   HIS A 142      -2.038 -16.128   4.773  1.00  6.43           O  
ATOM     25  CB  HIS A 142      -3.678 -14.034   6.114  1.00  7.68           C  
ATOM     26  CG  HIS A 142      -4.806 -13.382   5.375  1.00  8.57           C  
ATOM     27  ND1 HIS A 142      -5.391 -13.934   4.257  1.00  8.98           N  
ATOM     28  CD2 HIS A 142      -5.456 -12.215   5.602  1.00  9.35           C  
ATOM     29  CE1 HIS A 142      -6.353 -13.136   3.826  1.00  9.92           C  
ATOM     30  NE2 HIS A 142      -6.412 -12.087   4.625  1.00 10.14           N  
ATOM     31  H   HIS A 142      -2.409 -15.540   7.822  1.00  8.28           H  
ATOM     32  HA  HIS A 142      -4.886 -15.789   6.314  1.00  7.69           H  
ATOM     33  HB2 HIS A 142      -3.625 -13.589   7.097  1.00  7.85           H  
ATOM     34  HB3 HIS A 142      -2.763 -13.822   5.579  1.00  7.36           H  
ATOM     35  HD1 HIS A 142      -5.140 -14.785   3.839  1.00  8.76           H  
ATOM     36  HD2 HIS A 142      -5.259 -11.516   6.402  1.00  9.48           H  
ATOM     37  HE1 HIS A 142      -6.984 -13.313   2.967  1.00 10.54           H  
ATOM     38  HE2 HIS A 142      -6.977 -11.299   4.481  1.00 10.87           H  
ATOM     39  N   MET A 143      -4.068 -16.987   4.318  1.00  5.69           N  
ATOM     40  CA  MET A 143      -3.617 -17.708   3.132  1.00  4.93           C  
ATOM     41  C   MET A 143      -3.256 -16.738   2.012  1.00  4.49           C  
ATOM     42  O   MET A 143      -2.079 -16.495   1.744  1.00  4.78           O  
ATOM     43  CB  MET A 143      -4.701 -18.678   2.656  1.00  5.11           C  
ATOM     44  CG  MET A 143      -4.765 -19.963   3.467  1.00  5.84           C  
ATOM     45  SD  MET A 143      -3.395 -21.080   3.107  1.00  6.33           S  
ATOM     46  CE  MET A 143      -3.632 -22.324   4.373  1.00  6.97           C  
ATOM     47  H   MET A 143      -5.010 -17.046   4.584  1.00  5.95           H  
ATOM     48  HA  MET A 143      -2.737 -18.271   3.403  1.00  5.02           H  
ATOM     49  HB2 MET A 143      -5.661 -18.188   2.723  1.00  5.46           H  
ATOM     50  HB3 MET A 143      -4.508 -18.937   1.626  1.00  4.76           H  
ATOM     51  HG2 MET A 143      -4.739 -19.713   4.517  1.00  5.89           H  
ATOM     52  HG3 MET A 143      -5.692 -20.468   3.241  1.00  6.40           H  
ATOM     53  HE1 MET A 143      -4.040 -21.862   5.261  1.00  6.91           H  
ATOM     54  HE2 MET A 143      -2.683 -22.783   4.610  1.00  7.42           H  
ATOM     55  HE3 MET A 143      -4.316 -23.078   4.013  1.00  7.27           H  
ATOM     56  N   ASP A 144      -4.276 -16.185   1.362  1.00  4.21           N  
ATOM     57  CA  ASP A 144      -4.068 -15.238   0.269  1.00  4.18           C  
ATOM     58  C   ASP A 144      -3.550 -15.946  -0.979  1.00  4.00           C  
ATOM     59  O   ASP A 144      -4.156 -15.860  -2.048  1.00  4.54           O  
ATOM     60  CB  ASP A 144      -3.087 -14.144   0.693  1.00  4.57           C  
ATOM     61  CG  ASP A 144      -3.272 -12.863  -0.096  1.00  4.73           C  
ATOM     62  OD1 ASP A 144      -2.800 -12.803  -1.251  1.00  5.01           O  
ATOM     63  OD2 ASP A 144      -3.891 -11.919   0.440  1.00  5.01           O  
ATOM     64  H   ASP A 144      -5.191 -16.416   1.623  1.00  4.36           H  
ATOM     65  HA  ASP A 144      -5.021 -14.784   0.041  1.00  4.53           H  
ATOM     66  HB2 ASP A 144      -3.232 -13.923   1.741  1.00  4.73           H  
ATOM     67  HB3 ASP A 144      -2.076 -14.496   0.541  1.00  4.77           H  
ATOM     68  N   ALA A 145      -2.425 -16.641  -0.839  1.00  3.65           N  
ATOM     69  CA  ALA A 145      -1.822 -17.362  -1.955  1.00  4.12           C  
ATOM     70  C   ALA A 145      -1.075 -16.408  -2.882  1.00  4.40           C  
ATOM     71  O   ALA A 145      -0.841 -16.715  -4.051  1.00  5.09           O  
ATOM     72  CB  ALA A 145      -2.887 -18.128  -2.729  1.00  4.56           C  
ATOM     73  H   ALA A 145      -1.987 -16.670   0.038  1.00  3.39           H  
ATOM     74  HA  ALA A 145      -1.122 -18.076  -1.550  1.00  4.48           H  
ATOM     75  HB1 ALA A 145      -3.290 -17.497  -3.507  1.00  4.51           H  
ATOM     76  HB2 ALA A 145      -3.679 -18.421  -2.056  1.00  4.95           H  
ATOM     77  HB3 ALA A 145      -2.445 -19.009  -3.172  1.00  4.98           H  
ATOM     78  N   ALA A 146      -0.700 -15.248  -2.350  1.00  4.14           N  
ATOM     79  CA  ALA A 146       0.023 -14.246  -3.124  1.00  4.78           C  
ATOM     80  C   ALA A 146       0.456 -13.083  -2.239  1.00  4.41           C  
ATOM     81  O   ALA A 146       0.021 -11.947  -2.431  1.00  4.64           O  
ATOM     82  CB  ALA A 146      -0.838 -13.746  -4.275  1.00  5.54           C  
ATOM     83  H   ALA A 146      -0.915 -15.062  -1.412  1.00  3.69           H  
ATOM     84  HA  ALA A 146       0.901 -14.716  -3.540  1.00  5.26           H  
ATOM     85  HB1 ALA A 146      -0.985 -14.543  -4.988  1.00  5.88           H  
ATOM     86  HB2 ALA A 146      -0.345 -12.916  -4.759  1.00  5.78           H  
ATOM     87  HB3 ALA A 146      -1.796 -13.423  -3.893  1.00  5.86           H  
ATOM     88  N   ALA A 147       1.314 -13.375  -1.266  1.00  4.14           N  
ATOM     89  CA  ALA A 147       1.807 -12.356  -0.346  1.00  3.87           C  
ATOM     90  C   ALA A 147       0.688 -11.844   0.555  1.00  3.09           C  
ATOM     91  O   ALA A 147      -0.248 -11.192   0.091  1.00  3.48           O  
ATOM     92  CB  ALA A 147       2.432 -11.203  -1.117  1.00  4.53           C  
ATOM     93  H   ALA A 147       1.623 -14.299  -1.162  1.00  4.34           H  
ATOM     94  HA  ALA A 147       2.573 -12.804   0.267  1.00  4.03           H  
ATOM     95  HB1 ALA A 147       3.099 -11.594  -1.871  1.00  4.89           H  
ATOM     96  HB2 ALA A 147       2.987 -10.575  -0.436  1.00  5.01           H  
ATOM     97  HB3 ALA A 147       1.655 -10.622  -1.589  1.00  4.56           H  
ATOM     98  N   PRO A 148       0.771 -12.136   1.862  1.00  2.31           N  
ATOM     99  CA  PRO A 148      -0.238 -11.706   2.835  1.00  2.16           C  
ATOM    100  C   PRO A 148      -0.210 -10.199   3.072  1.00  1.90           C  
ATOM    101  O   PRO A 148      -1.255  -9.559   3.183  1.00  2.05           O  
ATOM    102  CB  PRO A 148       0.155 -12.456   4.109  1.00  2.11           C  
ATOM    103  CG  PRO A 148       1.614 -12.713   3.963  1.00  2.00           C  
ATOM    104  CD  PRO A 148       1.855 -12.910   2.492  1.00  2.20           C  
ATOM    105  HA  PRO A 148      -1.231 -12.002   2.531  1.00  2.87           H  
ATOM    106  HB2 PRO A 148      -0.054 -11.840   4.971  1.00  2.18           H  
ATOM    107  HB3 PRO A 148      -0.402 -13.377   4.174  1.00  2.75           H  
ATOM    108  HG2 PRO A 148       2.176 -11.863   4.323  1.00  2.24           H  
ATOM    109  HG3 PRO A 148       1.887 -13.603   4.509  1.00  2.36           H  
ATOM    110  HD2 PRO A 148       2.822 -12.518   2.212  1.00  2.42           H  
ATOM    111  HD3 PRO A 148       1.781 -13.956   2.234  1.00  2.68           H  
ATOM    112  N   GLY A 149       0.994  -9.639   3.148  1.00  1.76           N  
ATOM    113  CA  GLY A 149       1.135  -8.213   3.371  1.00  1.80           C  
ATOM    114  C   GLY A 149       0.703  -7.392   2.172  1.00  1.59           C  
ATOM    115  O   GLY A 149       0.329  -7.943   1.137  1.00  1.67           O  
ATOM    116  H   GLY A 149       1.792 -10.199   3.052  1.00  1.84           H  
ATOM    117  HA2 GLY A 149       0.532  -7.931   4.222  1.00  2.01           H  
ATOM    118  HA3 GLY A 149       2.170  -7.994   3.589  1.00  2.03           H  
ATOM    119  N   THR A 150       0.755  -6.070   2.312  1.00  1.65           N  
ATOM    120  CA  THR A 150       0.366  -5.172   1.231  1.00  1.56           C  
ATOM    121  C   THR A 150       1.375  -5.227   0.089  1.00  1.57           C  
ATOM    122  O   THR A 150       2.393  -5.915   0.180  1.00  1.70           O  
ATOM    123  CB  THR A 150       0.242  -3.737   1.751  1.00  1.57           C  
ATOM    124  OG1 THR A 150       0.135  -3.723   3.163  1.00  1.89           O  
ATOM    125  CG2 THR A 150      -0.956  -3.000   1.192  1.00  1.60           C  
ATOM    126  H   THR A 150       1.063  -5.691   3.162  1.00  1.95           H  
ATOM    127  HA  THR A 150      -0.596  -5.496   0.861  1.00  1.75           H  
ATOM    128  HB  THR A 150       1.129  -3.186   1.472  1.00  1.56           H  
ATOM    129  HG1 THR A 150       0.999  -3.565   3.549  1.00  1.86           H  
ATOM    130 HG21 THR A 150      -1.778  -3.067   1.890  1.00  1.71           H  
ATOM    131 HG22 THR A 150      -1.246  -3.444   0.252  1.00  1.86           H  
ATOM    132 HG23 THR A 150      -0.700  -1.962   1.036  1.00  2.10           H  
ATOM    133  N   ARG A 151       1.088  -4.500  -0.986  1.00  1.91           N  
ATOM    134  CA  ARG A 151       1.972  -4.467  -2.146  1.00  2.32           C  
ATOM    135  C   ARG A 151       2.833  -3.209  -2.141  1.00  1.84           C  
ATOM    136  O   ARG A 151       2.495  -2.216  -1.495  1.00  1.63           O  
ATOM    137  CB  ARG A 151       1.156  -4.535  -3.439  1.00  3.22           C  
ATOM    138  CG  ARG A 151       0.017  -5.541  -3.388  1.00  3.87           C  
ATOM    139  CD  ARG A 151      -0.592  -5.763  -4.763  1.00  4.30           C  
ATOM    140  NE  ARG A 151      -1.824  -6.546  -4.697  1.00  4.96           N  
ATOM    141  CZ  ARG A 151      -2.396  -7.113  -5.755  1.00  5.54           C  
ATOM    142  NH1 ARG A 151      -1.850  -6.983  -6.957  1.00  5.82           N  
ATOM    143  NH2 ARG A 151      -3.515  -7.809  -5.611  1.00  6.09           N  
ATOM    144  H   ARG A 151       0.262  -3.973  -1.000  1.00  2.12           H  
ATOM    145  HA  ARG A 151       2.618  -5.331  -2.095  1.00  2.61           H  
ATOM    146  HB2 ARG A 151       0.736  -3.559  -3.638  1.00  3.42           H  
ATOM    147  HB3 ARG A 151       1.812  -4.807  -4.252  1.00  3.55           H  
ATOM    148  HG2 ARG A 151       0.397  -6.482  -3.018  1.00  4.39           H  
ATOM    149  HG3 ARG A 151      -0.747  -5.171  -2.720  1.00  3.88           H  
ATOM    150  HD2 ARG A 151      -0.812  -4.802  -5.205  1.00  4.05           H  
ATOM    151  HD3 ARG A 151       0.124  -6.286  -5.379  1.00  4.72           H  
ATOM    152  HE  ARG A 151      -2.245  -6.655  -3.818  1.00  5.18           H  
ATOM    153 HH11 ARG A 151      -1.006  -6.459  -7.069  1.00  5.64           H  
ATOM    154 HH12 ARG A 151      -2.282  -7.411  -7.750  1.00  6.37           H  
ATOM    155 HH21 ARG A 151      -3.929  -7.909  -4.706  1.00  6.07           H  
ATOM    156 HH22 ARG A 151      -3.944  -8.234  -6.408  1.00  6.65           H  
ATOM    157  N   VAL A 152       3.947  -3.256  -2.864  1.00  1.82           N  
ATOM    158  CA  VAL A 152       4.857  -2.120  -2.942  1.00  1.50           C  
ATOM    159  C   VAL A 152       4.396  -1.112  -3.992  1.00  1.32           C  
ATOM    160  O   VAL A 152       4.922  -0.003  -4.075  1.00  1.28           O  
ATOM    161  CB  VAL A 152       6.292  -2.571  -3.277  1.00  1.78           C  
ATOM    162  CG1 VAL A 152       6.852  -3.442  -2.164  1.00  2.17           C  
ATOM    163  CG2 VAL A 152       6.325  -3.307  -4.608  1.00  2.36           C  
ATOM    164  H   VAL A 152       4.162  -4.075  -3.356  1.00  2.13           H  
ATOM    165  HA  VAL A 152       4.872  -1.637  -1.976  1.00  1.41           H  
ATOM    166  HB  VAL A 152       6.913  -1.691  -3.362  1.00  1.94           H  
ATOM    167 HG11 VAL A 152       7.841  -3.780  -2.435  1.00  2.54           H  
ATOM    168 HG12 VAL A 152       6.207  -4.296  -2.016  1.00  2.62           H  
ATOM    169 HG13 VAL A 152       6.905  -2.868  -1.250  1.00  2.37           H  
ATOM    170 HG21 VAL A 152       5.918  -2.671  -5.381  1.00  2.60           H  
ATOM    171 HG22 VAL A 152       5.735  -4.209  -4.536  1.00  2.77           H  
ATOM    172 HG23 VAL A 152       7.345  -3.563  -4.853  1.00  2.84           H  
ATOM    173  N   ILE A 153       3.408  -1.505  -4.791  1.00  1.51           N  
ATOM    174  CA  ILE A 153       2.876  -0.635  -5.833  1.00  1.59           C  
ATOM    175  C   ILE A 153       1.465  -0.163  -5.494  1.00  1.41           C  
ATOM    176  O   ILE A 153       0.904   0.689  -6.182  1.00  1.73           O  
ATOM    177  CB  ILE A 153       2.853  -1.340  -7.206  1.00  2.05           C  
ATOM    178  CG1 ILE A 153       2.709  -2.854  -7.032  1.00  2.53           C  
ATOM    179  CG2 ILE A 153       4.114  -1.011  -7.991  1.00  2.29           C  
ATOM    180  CD1 ILE A 153       1.367  -3.274  -6.474  1.00  2.76           C  
ATOM    181  H   ILE A 153       3.027  -2.401  -4.676  1.00  1.76           H  
ATOM    182  HA  ILE A 153       3.522   0.227  -5.907  1.00  1.67           H  
ATOM    183  HB  ILE A 153       2.007  -0.967  -7.762  1.00  2.43           H  
ATOM    184 HG12 ILE A 153       2.833  -3.333  -7.991  1.00  3.02           H  
ATOM    185 HG13 ILE A 153       3.476  -3.207  -6.357  1.00  2.89           H  
ATOM    186 HG21 ILE A 153       4.065  -1.477  -8.964  1.00  2.71           H  
ATOM    187 HG22 ILE A 153       4.977  -1.382  -7.458  1.00  2.62           H  
ATOM    188 HG23 ILE A 153       4.195   0.060  -8.108  1.00  2.55           H  
ATOM    189 HD11 ILE A 153       1.353  -4.346  -6.338  1.00  3.06           H  
ATOM    190 HD12 ILE A 153       0.586  -2.988  -7.162  1.00  3.11           H  
ATOM    191 HD13 ILE A 153       1.205  -2.790  -5.522  1.00  2.97           H  
ATOM    192  N   ASP A 154       0.897  -0.721  -4.428  1.00  1.22           N  
ATOM    193  CA  ASP A 154      -0.449  -0.354  -3.999  1.00  1.21           C  
ATOM    194  C   ASP A 154      -0.406   0.471  -2.716  1.00  1.15           C  
ATOM    195  O   ASP A 154      -1.378   1.137  -2.363  1.00  1.30           O  
ATOM    196  CB  ASP A 154      -1.299  -1.608  -3.784  1.00  1.37           C  
ATOM    197  CG  ASP A 154      -1.764  -2.223  -5.089  1.00  1.55           C  
ATOM    198  OD1 ASP A 154      -1.180  -1.892  -6.143  1.00  2.12           O  
ATOM    199  OD2 ASP A 154      -2.712  -3.035  -5.058  1.00  2.02           O  
ATOM    200  H   ASP A 154       1.394  -1.394  -3.918  1.00  1.36           H  
ATOM    201  HA  ASP A 154      -0.894   0.242  -4.780  1.00  1.33           H  
ATOM    202  HB2 ASP A 154      -0.716  -2.343  -3.249  1.00  1.66           H  
ATOM    203  HB3 ASP A 154      -2.169  -1.349  -3.198  1.00  1.58           H  
ATOM    204  N   ALA A 155       0.728   0.422  -2.023  1.00  1.10           N  
ATOM    205  CA  ALA A 155       0.897   1.165  -0.780  1.00  1.18           C  
ATOM    206  C   ALA A 155       1.833   2.354  -0.971  1.00  1.19           C  
ATOM    207  O   ALA A 155       2.118   3.089  -0.025  1.00  1.34           O  
ATOM    208  CB  ALA A 155       1.423   0.248   0.314  1.00  1.27           C  
ATOM    209  H   ALA A 155       1.467  -0.127  -2.355  1.00  1.12           H  
ATOM    210  HA  ALA A 155      -0.073   1.529  -0.475  1.00  1.29           H  
ATOM    211  HB1 ALA A 155       1.519   0.803   1.235  1.00  1.78           H  
ATOM    212  HB2 ALA A 155       2.389  -0.139   0.026  1.00  1.69           H  
ATOM    213  HB3 ALA A 155       0.735  -0.572   0.459  1.00  1.48           H  
ATOM    214  N   ALA A 156       2.300   2.547  -2.201  1.00  1.15           N  
ATOM    215  CA  ALA A 156       3.192   3.657  -2.517  1.00  1.22           C  
ATOM    216  C   ALA A 156       2.470   4.661  -3.397  1.00  1.32           C  
ATOM    217  O   ALA A 156       2.817   5.842  -3.445  1.00  1.62           O  
ATOM    218  CB  ALA A 156       4.452   3.150  -3.203  1.00  1.26           C  
ATOM    219  H   ALA A 156       2.022   1.938  -2.922  1.00  1.14           H  
ATOM    220  HA  ALA A 156       3.474   4.136  -1.591  1.00  1.30           H  
ATOM    221  HB1 ALA A 156       4.924   2.403  -2.581  1.00  1.43           H  
ATOM    222  HB2 ALA A 156       5.134   3.974  -3.356  1.00  1.76           H  
ATOM    223  HB3 ALA A 156       4.193   2.715  -4.156  1.00  1.61           H  
ATOM    224  N   THR A 157       1.460   4.162  -4.092  1.00  1.58           N  
ATOM    225  CA  THR A 157       0.650   4.967  -4.988  1.00  1.75           C  
ATOM    226  C   THR A 157      -0.028   6.110  -4.236  1.00  2.17           C  
ATOM    227  O   THR A 157      -0.099   7.235  -4.730  1.00  2.51           O  
ATOM    228  CB  THR A 157      -0.389   4.065  -5.650  1.00  1.68           C  
ATOM    229  OG1 THR A 157      -0.186   4.008  -7.051  1.00  1.88           O  
ATOM    230  CG2 THR A 157      -1.819   4.500  -5.409  1.00  2.01           C  
ATOM    231  H   THR A 157       1.249   3.211  -3.995  1.00  1.89           H  
ATOM    232  HA  THR A 157       1.296   5.378  -5.747  1.00  1.89           H  
ATOM    233  HB  THR A 157      -0.274   3.063  -5.247  1.00  1.53           H  
ATOM    234  HG1 THR A 157       0.505   3.372  -7.250  1.00  2.19           H  
ATOM    235 HG21 THR A 157      -2.491   3.837  -5.933  1.00  2.12           H  
ATOM    236 HG22 THR A 157      -1.954   5.509  -5.771  1.00  2.50           H  
ATOM    237 HG23 THR A 157      -2.033   4.467  -4.351  1.00  2.35           H  
ATOM    238  N   SER A 158      -0.525   5.811  -3.039  1.00  2.41           N  
ATOM    239  CA  SER A 158      -1.196   6.811  -2.217  1.00  2.97           C  
ATOM    240  C   SER A 158      -0.243   7.380  -1.170  1.00  2.86           C  
ATOM    241  O   SER A 158       0.974   7.359  -1.351  1.00  3.34           O  
ATOM    242  CB  SER A 158      -2.422   6.199  -1.535  1.00  3.64           C  
ATOM    243  OG  SER A 158      -3.093   5.300  -2.401  1.00  4.28           O  
ATOM    244  H   SER A 158      -0.436   4.896  -2.701  1.00  2.36           H  
ATOM    245  HA  SER A 158      -1.519   7.612  -2.867  1.00  3.29           H  
ATOM    246  HB2 SER A 158      -2.110   5.662  -0.653  1.00  3.54           H  
ATOM    247  HB3 SER A 158      -3.106   6.987  -1.255  1.00  4.18           H  
ATOM    248  HG  SER A 158      -3.523   5.792  -3.104  1.00  4.59           H  
ATOM    249  N   MET A 159      -0.803   7.887  -0.075  1.00  2.75           N  
ATOM    250  CA  MET A 159       0.001   8.460   1.000  1.00  2.81           C  
ATOM    251  C   MET A 159       1.146   7.525   1.380  1.00  2.48           C  
ATOM    252  O   MET A 159       0.921   6.383   1.779  1.00  2.51           O  
ATOM    253  CB  MET A 159      -0.872   8.740   2.225  1.00  3.35           C  
ATOM    254  CG  MET A 159      -1.953   9.780   1.977  1.00  4.03           C  
ATOM    255  SD  MET A 159      -3.334   9.635   3.129  1.00  4.68           S  
ATOM    256  CE  MET A 159      -3.400  11.298   3.788  1.00  5.03           C  
ATOM    257  H   MET A 159      -1.779   7.875   0.013  1.00  2.98           H  
ATOM    258  HA  MET A 159       0.414   9.391   0.644  1.00  2.99           H  
ATOM    259  HB2 MET A 159      -1.350   7.820   2.529  1.00  3.61           H  
ATOM    260  HB3 MET A 159      -0.242   9.091   3.028  1.00  3.31           H  
ATOM    261  HG2 MET A 159      -1.518  10.762   2.082  1.00  4.17           H  
ATOM    262  HG3 MET A 159      -2.327   9.657   0.971  1.00  4.33           H  
ATOM    263  HE1 MET A 159      -3.590  11.996   2.988  1.00  5.36           H  
ATOM    264  HE2 MET A 159      -2.457  11.537   4.257  1.00  5.00           H  
ATOM    265  HE3 MET A 159      -4.192  11.363   4.520  1.00  5.32           H  
ATOM    266  N   PRO A 160       2.395   8.002   1.259  1.00  2.75           N  
ATOM    267  CA  PRO A 160       3.582   7.207   1.590  1.00  2.83           C  
ATOM    268  C   PRO A 160       3.701   6.940   3.087  1.00  1.83           C  
ATOM    269  O   PRO A 160       3.541   7.847   3.904  1.00  2.20           O  
ATOM    270  CB  PRO A 160       4.743   8.079   1.107  1.00  3.94           C  
ATOM    271  CG  PRO A 160       4.208   9.468   1.126  1.00  4.45           C  
ATOM    272  CD  PRO A 160       2.747   9.354   0.790  1.00  3.56           C  
ATOM    273  HA  PRO A 160       3.589   6.266   1.057  1.00  3.30           H  
ATOM    274  HB2 PRO A 160       5.584   7.969   1.778  1.00  3.96           H  
ATOM    275  HB3 PRO A 160       5.030   7.781   0.110  1.00  4.60           H  
ATOM    276  HG2 PRO A 160       4.334   9.897   2.110  1.00  5.01           H  
ATOM    277  HG3 PRO A 160       4.717  10.069   0.387  1.00  5.09           H  
ATOM    278  HD2 PRO A 160       2.178  10.106   1.316  1.00  3.43           H  
ATOM    279  HD3 PRO A 160       2.597   9.443  -0.276  1.00  3.99           H  
ATOM    280  N   ARG A 161       3.984   5.690   3.439  1.00  1.37           N  
ATOM    281  CA  ARG A 161       4.126   5.303   4.837  1.00  1.21           C  
ATOM    282  C   ARG A 161       5.308   4.356   5.023  1.00  1.06           C  
ATOM    283  O   ARG A 161       5.899   3.888   4.050  1.00  1.57           O  
ATOM    284  CB  ARG A 161       2.842   4.638   5.337  1.00  2.07           C  
ATOM    285  CG  ARG A 161       1.610   5.519   5.206  1.00  2.81           C  
ATOM    286  CD  ARG A 161       1.647   6.679   6.189  1.00  3.76           C  
ATOM    287  NE  ARG A 161       0.600   7.660   5.917  1.00  4.31           N  
ATOM    288  CZ  ARG A 161       0.534   8.851   6.506  1.00  4.96           C  
ATOM    289  NH1 ARG A 161       1.451   9.206   7.397  1.00  5.52           N  
ATOM    290  NH2 ARG A 161      -0.450   9.687   6.205  1.00  5.25           N  
ATOM    291  H   ARG A 161       4.101   5.011   2.741  1.00  1.96           H  
ATOM    292  HA  ARG A 161       4.304   6.198   5.413  1.00  1.80           H  
ATOM    293  HB2 ARG A 161       2.674   3.735   4.769  1.00  2.43           H  
ATOM    294  HB3 ARG A 161       2.965   4.381   6.379  1.00  2.63           H  
ATOM    295  HG2 ARG A 161       1.565   5.913   4.202  1.00  3.11           H  
ATOM    296  HG3 ARG A 161       0.730   4.922   5.401  1.00  2.99           H  
ATOM    297  HD2 ARG A 161       1.513   6.292   7.188  1.00  3.99           H  
ATOM    298  HD3 ARG A 161       2.610   7.163   6.118  1.00  4.21           H  
ATOM    299  HE  ARG A 161      -0.089   7.420   5.263  1.00  4.41           H  
ATOM    300 HH11 ARG A 161       2.195   8.578   7.627  1.00  5.46           H  
ATOM    301 HH12 ARG A 161       1.398  10.102   7.838  1.00  6.10           H  
ATOM    302 HH21 ARG A 161      -1.143   9.424   5.534  1.00  5.02           H  
ATOM    303 HH22 ARG A 161      -0.499  10.582   6.648  1.00  5.83           H  
ATOM    304  N   LYS A 162       5.647   4.080   6.277  1.00  1.13           N  
ATOM    305  CA  LYS A 162       6.759   3.189   6.591  1.00  0.97           C  
ATOM    306  C   LYS A 162       6.348   1.728   6.436  1.00  0.96           C  
ATOM    307  O   LYS A 162       5.542   1.215   7.213  1.00  1.12           O  
ATOM    308  CB  LYS A 162       7.257   3.443   8.016  1.00  0.96           C  
ATOM    309  CG  LYS A 162       7.654   4.888   8.272  1.00  1.47           C  
ATOM    310  CD  LYS A 162       7.808   5.168   9.758  1.00  1.77           C  
ATOM    311  CE  LYS A 162       7.778   6.660  10.050  1.00  2.44           C  
ATOM    312  NZ  LYS A 162       7.885   6.943  11.508  1.00  2.89           N  
ATOM    313  H   LYS A 162       5.137   4.484   7.011  1.00  1.67           H  
ATOM    314  HA  LYS A 162       7.559   3.401   5.896  1.00  0.98           H  
ATOM    315  HB2 LYS A 162       6.474   3.179   8.711  1.00  1.28           H  
ATOM    316  HB3 LYS A 162       8.117   2.818   8.200  1.00  1.47           H  
ATOM    317  HG2 LYS A 162       8.595   5.085   7.780  1.00  2.20           H  
ATOM    318  HG3 LYS A 162       6.892   5.538   7.869  1.00  1.83           H  
ATOM    319  HD2 LYS A 162       6.998   4.691  10.290  1.00  1.97           H  
ATOM    320  HD3 LYS A 162       8.751   4.762  10.096  1.00  2.25           H  
ATOM    321  HE2 LYS A 162       8.605   7.130   9.540  1.00  2.91           H  
ATOM    322  HE3 LYS A 162       6.849   7.067   9.680  1.00  2.77           H  
ATOM    323  HZ1 LYS A 162       7.168   6.400  12.031  1.00  3.00           H  
ATOM    324  HZ2 LYS A 162       7.734   7.956  11.688  1.00  3.35           H  
ATOM    325  HZ3 LYS A 162       8.828   6.678  11.856  1.00  3.19           H  
ATOM    326  N   VAL A 163       6.907   1.064   5.430  1.00  0.89           N  
ATOM    327  CA  VAL A 163       6.600  -0.339   5.175  1.00  0.91           C  
ATOM    328  C   VAL A 163       7.766  -1.237   5.569  1.00  0.87           C  
ATOM    329  O   VAL A 163       8.910  -0.988   5.190  1.00  0.89           O  
ATOM    330  CB  VAL A 163       6.258  -0.580   3.692  1.00  0.98           C  
ATOM    331  CG1 VAL A 163       4.953   0.108   3.325  1.00  1.09           C  
ATOM    332  CG2 VAL A 163       7.392  -0.102   2.797  1.00  0.94           C  
ATOM    333  H   VAL A 163       7.543   1.528   4.846  1.00  0.93           H  
ATOM    334  HA  VAL A 163       5.736  -0.604   5.769  1.00  0.96           H  
ATOM    335  HB  VAL A 163       6.134  -1.643   3.541  1.00  1.01           H  
ATOM    336 HG11 VAL A 163       4.155  -0.281   3.940  1.00  1.60           H  
ATOM    337 HG12 VAL A 163       4.728  -0.078   2.285  1.00  1.40           H  
ATOM    338 HG13 VAL A 163       5.049   1.171   3.488  1.00  1.46           H  
ATOM    339 HG21 VAL A 163       7.536   0.959   2.933  1.00  1.45           H  
ATOM    340 HG22 VAL A 163       7.145  -0.303   1.765  1.00  1.16           H  
ATOM    341 HG23 VAL A 163       8.302  -0.624   3.057  1.00  1.39           H  
ATOM    342  N   ARG A 164       7.469  -2.283   6.334  1.00  0.88           N  
ATOM    343  CA  ARG A 164       8.495  -3.219   6.781  1.00  0.87           C  
ATOM    344  C   ARG A 164       8.617  -4.394   5.816  1.00  0.85           C  
ATOM    345  O   ARG A 164       7.619  -5.015   5.449  1.00  1.01           O  
ATOM    346  CB  ARG A 164       8.171  -3.731   8.186  1.00  0.99           C  
ATOM    347  CG  ARG A 164       9.372  -4.314   8.913  1.00  1.19           C  
ATOM    348  CD  ARG A 164       8.948  -5.141  10.116  1.00  1.56           C  
ATOM    349  NE  ARG A 164       9.561  -4.664  11.353  1.00  1.98           N  
ATOM    350  CZ  ARG A 164       9.331  -5.204  12.546  1.00  2.17           C  
ATOM    351  NH1 ARG A 164       8.505  -6.235  12.663  1.00  2.36           N  
ATOM    352  NH2 ARG A 164       9.928  -4.713  13.623  1.00  2.62           N  
ATOM    353  H   ARG A 164       6.539  -2.429   6.605  1.00  0.93           H  
ATOM    354  HA  ARG A 164       9.436  -2.691   6.808  1.00  0.83           H  
ATOM    355  HB2 ARG A 164       7.783  -2.912   8.774  1.00  1.00           H  
ATOM    356  HB3 ARG A 164       7.415  -4.498   8.112  1.00  1.16           H  
ATOM    357  HG2 ARG A 164       9.922  -4.944   8.230  1.00  1.46           H  
ATOM    358  HG3 ARG A 164      10.004  -3.505   9.249  1.00  1.32           H  
ATOM    359  HD2 ARG A 164       7.874  -5.087  10.214  1.00  2.10           H  
ATOM    360  HD3 ARG A 164       9.242  -6.168   9.952  1.00  1.75           H  
ATOM    361  HE  ARG A 164      10.175  -3.903  11.290  1.00  2.46           H  
ATOM    362 HH11 ARG A 164       8.054  -6.610  11.853  1.00  2.52           H  
ATOM    363 HH12 ARG A 164       8.335  -6.640  13.561  1.00  2.61           H  
ATOM    364 HH21 ARG A 164      10.551  -3.936  13.539  1.00  2.94           H  
ATOM    365 HH22 ARG A 164       9.754  -5.120  14.521  1.00  2.83           H  
ATOM    366  N   ILE A 165       9.846  -4.694   5.408  1.00  0.87           N  
ATOM    367  CA  ILE A 165      10.099  -5.795   4.487  1.00  0.95           C  
ATOM    368  C   ILE A 165      10.423  -7.079   5.242  1.00  0.96           C  
ATOM    369  O   ILE A 165      11.193  -7.067   6.203  1.00  1.34           O  
ATOM    370  CB  ILE A 165      11.259  -5.470   3.525  1.00  1.53           C  
ATOM    371  CG1 ILE A 165      11.051  -4.098   2.882  1.00  1.92           C  
ATOM    372  CG2 ILE A 165      11.380  -6.548   2.458  1.00  1.97           C  
ATOM    373  CD1 ILE A 165      11.601  -2.954   3.708  1.00  2.47           C  
ATOM    374  H   ILE A 165      10.602  -4.162   5.737  1.00  0.98           H  
ATOM    375  HA  ILE A 165       9.205  -5.950   3.900  1.00  1.12           H  
ATOM    376  HB  ILE A 165      12.176  -5.459   4.095  1.00  1.64           H  
ATOM    377 HG12 ILE A 165      11.543  -4.078   1.922  1.00  2.48           H  
ATOM    378 HG13 ILE A 165       9.993  -3.929   2.743  1.00  1.91           H  
ATOM    379 HG21 ILE A 165      11.611  -7.493   2.925  1.00  2.41           H  
ATOM    380 HG22 ILE A 165      12.169  -6.284   1.768  1.00  2.16           H  
ATOM    381 HG23 ILE A 165      10.446  -6.630   1.921  1.00  2.40           H  
ATOM    382 HD11 ILE A 165      11.891  -2.146   3.054  1.00  2.69           H  
ATOM    383 HD12 ILE A 165      12.461  -3.294   4.265  1.00  2.85           H  
ATOM    384 HD13 ILE A 165      10.841  -2.607   4.393  1.00  3.04           H  
ATOM    385  N   VAL A 166       9.828  -8.185   4.806  1.00  1.19           N  
ATOM    386  CA  VAL A 166      10.053  -9.477   5.445  1.00  1.72           C  
ATOM    387  C   VAL A 166      10.645 -10.486   4.465  1.00  1.87           C  
ATOM    388  O   VAL A 166      11.176 -11.520   4.873  1.00  2.44           O  
ATOM    389  CB  VAL A 166       8.747 -10.049   6.027  1.00  2.25           C  
ATOM    390  CG1 VAL A 166       8.349  -9.299   7.288  1.00  2.38           C  
ATOM    391  CG2 VAL A 166       7.632  -9.998   4.993  1.00  2.44           C  
ATOM    392  H   VAL A 166       9.223  -8.130   4.037  1.00  1.31           H  
ATOM    393  HA  VAL A 166      10.749  -9.329   6.257  1.00  1.87           H  
ATOM    394  HB  VAL A 166       8.917 -11.083   6.290  1.00  2.51           H  
ATOM    395 HG11 VAL A 166       8.112  -8.275   7.038  1.00  2.48           H  
ATOM    396 HG12 VAL A 166       9.169  -9.318   7.992  1.00  2.45           H  
ATOM    397 HG13 VAL A 166       7.484  -9.770   7.731  1.00  2.86           H  
ATOM    398 HG21 VAL A 166       7.375  -8.967   4.793  1.00  2.81           H  
ATOM    399 HG22 VAL A 166       6.765 -10.518   5.373  1.00  2.68           H  
ATOM    400 HG23 VAL A 166       7.965 -10.469   4.081  1.00  2.54           H  
ATOM    401  N   GLN A 167      10.552 -10.182   3.175  1.00  1.46           N  
ATOM    402  CA  GLN A 167      11.080 -11.067   2.142  1.00  1.62           C  
ATOM    403  C   GLN A 167      11.128 -10.362   0.790  1.00  1.42           C  
ATOM    404  O   GLN A 167      10.314  -9.483   0.508  1.00  1.30           O  
ATOM    405  CB  GLN A 167      10.226 -12.332   2.040  1.00  1.84           C  
ATOM    406  CG  GLN A 167      10.960 -13.513   1.427  1.00  2.13           C  
ATOM    407  CD  GLN A 167      10.063 -14.721   1.234  1.00  2.30           C  
ATOM    408  OE1 GLN A 167       9.252 -15.051   2.100  1.00  2.30           O  
ATOM    409  NE2 GLN A 167      10.204 -15.387   0.094  1.00  3.05           N  
ATOM    410  H   GLN A 167      10.119  -9.344   2.911  1.00  1.16           H  
ATOM    411  HA  GLN A 167      12.084 -11.345   2.426  1.00  1.96           H  
ATOM    412  HB2 GLN A 167       9.899 -12.613   3.030  1.00  2.09           H  
ATOM    413  HB3 GLN A 167       9.359 -12.119   1.431  1.00  2.04           H  
ATOM    414  HG2 GLN A 167      11.351 -13.218   0.465  1.00  2.57           H  
ATOM    415  HG3 GLN A 167      11.777 -13.790   2.077  1.00  2.34           H  
ATOM    416 HE21 GLN A 167      10.869 -15.067  -0.550  1.00  3.49           H  
ATOM    417 HE22 GLN A 167       9.636 -16.172  -0.057  1.00  3.37           H  
ATOM    418  N   ILE A 168      12.088 -10.755  -0.042  1.00  1.63           N  
ATOM    419  CA  ILE A 168      12.244 -10.163  -1.365  1.00  1.73           C  
ATOM    420  C   ILE A 168      11.608 -11.041  -2.438  1.00  1.97           C  
ATOM    421  O   ILE A 168      11.052 -12.098  -2.139  1.00  2.41           O  
ATOM    422  CB  ILE A 168      13.730  -9.943  -1.712  1.00  2.50           C  
ATOM    423  CG1 ILE A 168      14.514 -11.247  -1.552  1.00  2.81           C  
ATOM    424  CG2 ILE A 168      14.321  -8.851  -0.832  1.00  3.17           C  
ATOM    425  CD1 ILE A 168      15.838 -11.248  -2.283  1.00  3.72           C  
ATOM    426  H   ILE A 168      12.706 -11.461   0.242  1.00  1.84           H  
ATOM    427  HA  ILE A 168      11.750  -9.202  -1.362  1.00  1.66           H  
ATOM    428  HB  ILE A 168      13.792  -9.616  -2.739  1.00  3.04           H  
ATOM    429 HG12 ILE A 168      14.715 -11.413  -0.504  1.00  3.02           H  
ATOM    430 HG13 ILE A 168      13.921 -12.065  -1.934  1.00  2.89           H  
ATOM    431 HG21 ILE A 168      15.323  -8.624  -1.166  1.00  3.48           H  
ATOM    432 HG22 ILE A 168      14.351  -9.190   0.192  1.00  3.55           H  
ATOM    433 HG23 ILE A 168      13.710  -7.964  -0.900  1.00  3.55           H  
ATOM    434 HD11 ILE A 168      16.441 -12.073  -1.934  1.00  4.25           H  
ATOM    435 HD12 ILE A 168      16.355 -10.319  -2.095  1.00  4.03           H  
ATOM    436 HD13 ILE A 168      15.664 -11.354  -3.344  1.00  4.05           H  
ATOM    437  N   ASN A 169      11.693 -10.596  -3.689  1.00  1.98           N  
ATOM    438  CA  ASN A 169      11.125 -11.344  -4.806  1.00  2.48           C  
ATOM    439  C   ASN A 169      11.711 -10.872  -6.133  1.00  2.44           C  
ATOM    440  O   ASN A 169      12.395  -9.851  -6.191  1.00  2.58           O  
ATOM    441  CB  ASN A 169       9.602 -11.193  -4.824  1.00  3.01           C  
ATOM    442  CG  ASN A 169       8.907 -12.408  -5.407  1.00  3.88           C  
ATOM    443  OD1 ASN A 169       8.666 -12.483  -6.612  1.00  4.38           O  
ATOM    444  ND2 ASN A 169       8.579 -13.369  -4.551  1.00  4.49           N  
ATOM    445  H   ASN A 169      12.148  -9.747  -3.865  1.00  1.85           H  
ATOM    446  HA  ASN A 169      11.372 -12.386  -4.667  1.00  3.11           H  
ATOM    447  HB2 ASN A 169       9.248 -11.049  -3.815  1.00  3.22           H  
ATOM    448  HB3 ASN A 169       9.340 -10.331  -5.421  1.00  3.18           H  
ATOM    449 HD21 ASN A 169       8.801 -13.243  -3.605  1.00  4.45           H  
ATOM    450 HD22 ASN A 169       8.130 -14.167  -4.901  1.00  5.18           H  
ATOM    451  N   GLU A 170      11.436 -11.623  -7.195  1.00  2.90           N  
ATOM    452  CA  GLU A 170      11.936 -11.285  -8.524  1.00  3.24           C  
ATOM    453  C   GLU A 170      13.461 -11.271  -8.547  1.00  2.92           C  
ATOM    454  O   GLU A 170      14.091 -10.360  -8.010  1.00  3.14           O  
ATOM    455  CB  GLU A 170      11.395  -9.922  -8.963  1.00  4.18           C  
ATOM    456  CG  GLU A 170       9.895  -9.914  -9.212  1.00  4.96           C  
ATOM    457  CD  GLU A 170       9.546 -10.124 -10.673  1.00  5.24           C  
ATOM    458  OE1 GLU A 170       9.824  -9.216 -11.485  1.00  5.61           O  
ATOM    459  OE2 GLU A 170       8.994 -11.193 -11.004  1.00  5.45           O  
ATOM    460  H   GLU A 170      10.885 -12.426  -7.084  1.00  3.32           H  
ATOM    461  HA  GLU A 170      11.585 -12.039  -9.211  1.00  3.53           H  
ATOM    462  HB2 GLU A 170      11.614  -9.196  -8.195  1.00  4.33           H  
ATOM    463  HB3 GLU A 170      11.891  -9.628  -9.876  1.00  4.57           H  
ATOM    464  HG2 GLU A 170       9.443 -10.705  -8.634  1.00  5.36           H  
ATOM    465  HG3 GLU A 170       9.496  -8.962  -8.894  1.00  5.30           H  
ATOM    466  N   ILE A 171      14.048 -12.287  -9.173  1.00  2.99           N  
ATOM    467  CA  ILE A 171      15.500 -12.391  -9.267  1.00  3.09           C  
ATOM    468  C   ILE A 171      15.921 -13.038 -10.583  1.00  3.06           C  
ATOM    469  O   ILE A 171      16.367 -12.355 -11.505  1.00  3.39           O  
ATOM    470  CB  ILE A 171      16.084 -13.205  -8.095  1.00  3.86           C  
ATOM    471  CG1 ILE A 171      15.018 -14.127  -7.496  1.00  4.61           C  
ATOM    472  CG2 ILE A 171      16.644 -12.274  -7.029  1.00  4.26           C  
ATOM    473  CD1 ILE A 171      15.593 -15.325  -6.772  1.00  5.46           C  
ATOM    474  H   ILE A 171      13.491 -12.981  -9.582  1.00  3.34           H  
ATOM    475  HA  ILE A 171      15.908 -11.391  -9.222  1.00  3.13           H  
ATOM    476  HB  ILE A 171      16.898 -13.806  -8.473  1.00  4.14           H  
ATOM    477 HG12 ILE A 171      14.423 -13.568  -6.791  1.00  4.98           H  
ATOM    478 HG13 ILE A 171      14.381 -14.491  -8.289  1.00  4.61           H  
ATOM    479 HG21 ILE A 171      17.109 -12.858  -6.250  1.00  4.30           H  
ATOM    480 HG22 ILE A 171      15.843 -11.685  -6.609  1.00  4.62           H  
ATOM    481 HG23 ILE A 171      17.378 -11.618  -7.475  1.00  4.66           H  
ATOM    482 HD11 ILE A 171      16.110 -14.994  -5.883  1.00  5.59           H  
ATOM    483 HD12 ILE A 171      16.285 -15.840  -7.421  1.00  6.01           H  
ATOM    484 HD13 ILE A 171      14.793 -15.995  -6.495  1.00  5.75           H  
ATOM    485  N   PHE A 172      15.775 -14.358 -10.663  1.00  3.20           N  
ATOM    486  CA  PHE A 172      16.140 -15.097 -11.867  1.00  3.66           C  
ATOM    487  C   PHE A 172      17.621 -14.918 -12.191  1.00  3.40           C  
ATOM    488  O   PHE A 172      18.451 -15.749 -11.819  1.00  3.92           O  
ATOM    489  CB  PHE A 172      15.286 -14.640 -13.052  1.00  4.43           C  
ATOM    490  CG  PHE A 172      14.000 -15.403 -13.196  1.00  5.10           C  
ATOM    491  CD1 PHE A 172      12.947 -15.180 -12.324  1.00  5.69           C  
ATOM    492  CD2 PHE A 172      13.845 -16.345 -14.201  1.00  5.46           C  
ATOM    493  CE1 PHE A 172      11.762 -15.880 -12.452  1.00  6.52           C  
ATOM    494  CE2 PHE A 172      12.664 -17.048 -14.335  1.00  6.37           C  
ATOM    495  CZ  PHE A 172      11.620 -16.816 -13.459  1.00  6.85           C  
ATOM    496  H   PHE A 172      15.413 -14.846  -9.895  1.00  3.33           H  
ATOM    497  HA  PHE A 172      15.950 -16.143 -11.682  1.00  4.07           H  
ATOM    498  HB2 PHE A 172      15.040 -13.597 -12.929  1.00  4.70           H  
ATOM    499  HB3 PHE A 172      15.852 -14.766 -13.964  1.00  4.62           H  
ATOM    500  HD1 PHE A 172      13.055 -14.448 -11.537  1.00  5.69           H  
ATOM    501  HD2 PHE A 172      14.661 -16.527 -14.885  1.00  5.23           H  
ATOM    502  HE1 PHE A 172      10.948 -15.697 -11.766  1.00  7.06           H  
ATOM    503  HE2 PHE A 172      12.556 -17.779 -15.122  1.00  6.86           H  
ATOM    504  HZ  PHE A 172      10.696 -17.364 -13.562  1.00  7.63           H  
ATOM    505  N   GLN A 173      17.947 -13.830 -12.883  1.00  3.03           N  
ATOM    506  CA  GLN A 173      19.328 -13.545 -13.253  1.00  3.19           C  
ATOM    507  C   GLN A 173      19.483 -12.095 -13.705  1.00  2.85           C  
ATOM    508  O   GLN A 173      19.631 -11.817 -14.894  1.00  3.40           O  
ATOM    509  CB  GLN A 173      19.788 -14.490 -14.367  1.00  3.78           C  
ATOM    510  CG  GLN A 173      18.671 -14.916 -15.308  1.00  4.50           C  
ATOM    511  CD  GLN A 173      18.090 -13.754 -16.088  1.00  5.27           C  
ATOM    512  OE1 GLN A 173      17.019 -13.244 -15.758  1.00  5.57           O  
ATOM    513  NE2 GLN A 173      18.794 -13.328 -17.130  1.00  5.95           N  
ATOM    514  H   GLN A 173      17.241 -13.205 -13.150  1.00  2.98           H  
ATOM    515  HA  GLN A 173      19.945 -13.705 -12.382  1.00  3.60           H  
ATOM    516  HB2 GLN A 173      20.552 -13.997 -14.951  1.00  3.93           H  
ATOM    517  HB3 GLN A 173      20.209 -15.378 -13.918  1.00  4.09           H  
ATOM    518  HG2 GLN A 173      19.064 -15.638 -16.008  1.00  4.55           H  
ATOM    519  HG3 GLN A 173      17.883 -15.371 -14.726  1.00  4.89           H  
ATOM    520 HE21 GLN A 173      19.639 -13.781 -17.335  1.00  5.97           H  
ATOM    521 HE22 GLN A 173      18.440 -12.577 -17.652  1.00  6.58           H  
ATOM    522  N   VAL A 174      19.448 -11.176 -12.744  1.00  2.39           N  
ATOM    523  CA  VAL A 174      19.584  -9.754 -13.042  1.00  2.41           C  
ATOM    524  C   VAL A 174      20.928  -9.217 -12.559  1.00  2.24           C  
ATOM    525  O   VAL A 174      21.174  -9.123 -11.356  1.00  2.67           O  
ATOM    526  CB  VAL A 174      18.453  -8.932 -12.396  1.00  3.06           C  
ATOM    527  CG1 VAL A 174      17.170  -9.063 -13.201  1.00  3.87           C  
ATOM    528  CG2 VAL A 174      18.231  -9.365 -10.954  1.00  3.63           C  
ATOM    529  H   VAL A 174      19.329 -11.460 -11.815  1.00  2.47           H  
ATOM    530  HA  VAL A 174      19.524  -9.631 -14.113  1.00  2.75           H  
ATOM    531  HB  VAL A 174      18.746  -7.893 -12.395  1.00  3.25           H  
ATOM    532 HG11 VAL A 174      17.315  -8.634 -14.181  1.00  4.23           H  
ATOM    533 HG12 VAL A 174      16.371  -8.542 -12.694  1.00  4.22           H  
ATOM    534 HG13 VAL A 174      16.912 -10.107 -13.300  1.00  4.19           H  
ATOM    535 HG21 VAL A 174      17.839 -10.371 -10.936  1.00  3.88           H  
ATOM    536 HG22 VAL A 174      17.529  -8.695 -10.481  1.00  3.90           H  
ATOM    537 HG23 VAL A 174      19.171  -9.336 -10.421  1.00  4.08           H  
ATOM    538  N   GLU A 175      21.794  -8.867 -13.505  1.00  2.28           N  
ATOM    539  CA  GLU A 175      23.113  -8.338 -13.177  1.00  2.36           C  
ATOM    540  C   GLU A 175      23.260  -6.901 -13.668  1.00  2.18           C  
ATOM    541  O   GLU A 175      24.326  -6.498 -14.131  1.00  2.69           O  
ATOM    542  CB  GLU A 175      24.205  -9.215 -13.795  1.00  3.09           C  
ATOM    543  CG  GLU A 175      24.332 -10.580 -13.140  1.00  3.69           C  
ATOM    544  CD  GLU A 175      25.264 -11.505 -13.897  1.00  3.89           C  
ATOM    545  OE1 GLU A 175      26.465 -11.179 -14.007  1.00  4.25           O  
ATOM    546  OE2 GLU A 175      24.793 -12.558 -14.379  1.00  4.09           O  
ATOM    547  H   GLU A 175      21.539  -8.966 -14.446  1.00  2.65           H  
ATOM    548  HA  GLU A 175      23.218  -8.351 -12.103  1.00  2.63           H  
ATOM    549  HB2 GLU A 175      23.982  -9.362 -14.842  1.00  3.38           H  
ATOM    550  HB3 GLU A 175      25.152  -8.706 -13.706  1.00  3.50           H  
ATOM    551  HG2 GLU A 175      24.715 -10.450 -12.138  1.00  4.07           H  
ATOM    552  HG3 GLU A 175      23.354 -11.036 -13.093  1.00  4.05           H  
ATOM    553  N   THR A 176      22.179  -6.133 -13.564  1.00  2.13           N  
ATOM    554  CA  THR A 176      22.185  -4.740 -13.998  1.00  2.32           C  
ATOM    555  C   THR A 176      22.606  -3.817 -12.858  1.00  2.11           C  
ATOM    556  O   THR A 176      23.196  -4.262 -11.872  1.00  2.16           O  
ATOM    557  CB  THR A 176      20.801  -4.340 -14.512  1.00  2.91           C  
ATOM    558  OG1 THR A 176      20.012  -5.487 -14.776  1.00  3.35           O  
ATOM    559  CG2 THR A 176      20.849  -3.515 -15.781  1.00  3.49           C  
ATOM    560  H   THR A 176      21.358  -6.512 -13.187  1.00  2.43           H  
ATOM    561  HA  THR A 176      22.899  -4.647 -14.802  1.00  2.76           H  
ATOM    562  HB  THR A 176      20.302  -3.752 -13.754  1.00  3.35           H  
ATOM    563  HG1 THR A 176      19.114  -5.333 -14.473  1.00  3.69           H  
ATOM    564 HG21 THR A 176      20.913  -4.173 -16.635  1.00  3.70           H  
ATOM    565 HG22 THR A 176      21.714  -2.869 -15.758  1.00  3.82           H  
ATOM    566 HG23 THR A 176      19.954  -2.915 -15.854  1.00  3.91           H  
ATOM    567  N   ASP A 177      22.299  -2.531 -12.998  1.00  2.26           N  
ATOM    568  CA  ASP A 177      22.646  -1.545 -11.978  1.00  2.29           C  
ATOM    569  C   ASP A 177      21.938  -1.847 -10.661  1.00  2.06           C  
ATOM    570  O   ASP A 177      22.324  -1.338  -9.609  1.00  1.92           O  
ATOM    571  CB  ASP A 177      22.282  -0.138 -12.456  1.00  2.83           C  
ATOM    572  CG  ASP A 177      23.145   0.322 -13.614  1.00  2.93           C  
ATOM    573  OD1 ASP A 177      23.068  -0.299 -14.695  1.00  3.30           O  
ATOM    574  OD2 ASP A 177      23.899   1.302 -13.439  1.00  3.24           O  
ATOM    575  H   ASP A 177      21.829  -2.237 -13.805  1.00  2.57           H  
ATOM    576  HA  ASP A 177      23.713  -1.596 -11.820  1.00  2.32           H  
ATOM    577  HB2 ASP A 177      21.250  -0.130 -12.776  1.00  2.99           H  
ATOM    578  HB3 ASP A 177      22.407   0.556 -11.639  1.00  3.00           H  
ATOM    579  N   GLN A 178      20.900  -2.676 -10.725  1.00  2.15           N  
ATOM    580  CA  GLN A 178      20.138  -3.045  -9.536  1.00  2.12           C  
ATOM    581  C   GLN A 178      21.066  -3.469  -8.401  1.00  1.88           C  
ATOM    582  O   GLN A 178      20.766  -3.253  -7.228  1.00  1.98           O  
ATOM    583  CB  GLN A 178      19.163  -4.177  -9.861  1.00  2.47           C  
ATOM    584  CG  GLN A 178      18.100  -3.792 -10.876  1.00  3.14           C  
ATOM    585  CD  GLN A 178      17.578  -4.984 -11.656  1.00  3.74           C  
ATOM    586  OE1 GLN A 178      17.667  -5.024 -12.883  1.00  4.04           O  
ATOM    587  NE2 GLN A 178      17.029  -5.962 -10.945  1.00  4.40           N  
ATOM    588  H   GLN A 178      20.639  -3.049 -11.593  1.00  2.34           H  
ATOM    589  HA  GLN A 178      19.577  -2.179  -9.221  1.00  2.12           H  
ATOM    590  HB2 GLN A 178      19.720  -5.014 -10.256  1.00  2.63           H  
ATOM    591  HB3 GLN A 178      18.667  -4.483  -8.952  1.00  2.67           H  
ATOM    592  HG2 GLN A 178      17.272  -3.333 -10.355  1.00  3.25           H  
ATOM    593  HG3 GLN A 178      18.523  -3.083 -11.572  1.00  3.68           H  
ATOM    594 HE21 GLN A 178      16.992  -5.862  -9.971  1.00  4.53           H  
ATOM    595 HE22 GLN A 178      16.684  -6.745 -11.425  1.00  4.96           H  
ATOM    596  N   PHE A 179      22.195  -4.072  -8.760  1.00  1.73           N  
ATOM    597  CA  PHE A 179      23.168  -4.526  -7.772  1.00  1.67           C  
ATOM    598  C   PHE A 179      24.369  -3.587  -7.721  1.00  1.57           C  
ATOM    599  O   PHE A 179      25.517  -4.029  -7.745  1.00  1.70           O  
ATOM    600  CB  PHE A 179      23.628  -5.949  -8.096  1.00  1.80           C  
ATOM    601  CG  PHE A 179      23.702  -6.845  -6.893  1.00  2.18           C  
ATOM    602  CD1 PHE A 179      22.551  -7.393  -6.349  1.00  2.59           C  
ATOM    603  CD2 PHE A 179      24.922  -7.140  -6.306  1.00  2.48           C  
ATOM    604  CE1 PHE A 179      22.615  -8.218  -5.242  1.00  3.25           C  
ATOM    605  CE2 PHE A 179      24.992  -7.965  -5.199  1.00  3.12           C  
ATOM    606  CZ  PHE A 179      23.838  -8.504  -4.666  1.00  3.49           C  
ATOM    607  H   PHE A 179      22.379  -4.217  -9.712  1.00  1.79           H  
ATOM    608  HA  PHE A 179      22.684  -4.525  -6.807  1.00  1.74           H  
ATOM    609  HB2 PHE A 179      22.938  -6.393  -8.797  1.00  2.14           H  
ATOM    610  HB3 PHE A 179      24.611  -5.909  -8.543  1.00  1.63           H  
ATOM    611  HD1 PHE A 179      21.595  -7.170  -6.799  1.00  2.56           H  
ATOM    612  HD2 PHE A 179      25.825  -6.718  -6.721  1.00  2.41           H  
ATOM    613  HE1 PHE A 179      21.710  -8.638  -4.828  1.00  3.68           H  
ATOM    614  HE2 PHE A 179      25.950  -8.186  -4.750  1.00  3.46           H  
ATOM    615  HZ  PHE A 179      23.891  -9.148  -3.801  1.00  4.09           H  
ATOM    616  N   THR A 180      24.096  -2.287  -7.651  1.00  1.47           N  
ATOM    617  CA  THR A 180      25.153  -1.285  -7.597  1.00  1.53           C  
ATOM    618  C   THR A 180      24.918  -0.304  -6.452  1.00  1.45           C  
ATOM    619  O   THR A 180      25.728  -0.206  -5.531  1.00  1.46           O  
ATOM    620  CB  THR A 180      25.235  -0.528  -8.924  1.00  1.72           C  
ATOM    621  OG1 THR A 180      25.216  -1.429 -10.017  1.00  2.16           O  
ATOM    622  CG2 THR A 180      26.480   0.323  -9.053  1.00  2.16           C  
ATOM    623  H   THR A 180      23.159  -1.996  -7.635  1.00  1.44           H  
ATOM    624  HA  THR A 180      26.088  -1.799  -7.428  1.00  1.64           H  
ATOM    625  HB  THR A 180      24.378   0.125  -9.008  1.00  2.18           H  
ATOM    626  HG1 THR A 180      25.948  -2.045  -9.938  1.00  2.46           H  
ATOM    627 HG21 THR A 180      26.408   1.169  -8.385  1.00  2.53           H  
ATOM    628 HG22 THR A 180      26.572   0.675 -10.070  1.00  2.69           H  
ATOM    629 HG23 THR A 180      27.347  -0.266  -8.795  1.00  2.45           H  
ATOM    630  N   GLN A 181      23.805   0.419  -6.517  1.00  1.44           N  
ATOM    631  CA  GLN A 181      23.464   1.393  -5.486  1.00  1.41           C  
ATOM    632  C   GLN A 181      23.049   0.697  -4.194  1.00  1.29           C  
ATOM    633  O   GLN A 181      23.288   1.206  -3.099  1.00  1.26           O  
ATOM    634  CB  GLN A 181      22.338   2.308  -5.970  1.00  1.54           C  
ATOM    635  CG  GLN A 181      22.647   3.012  -7.281  1.00  1.77           C  
ATOM    636  CD  GLN A 181      21.713   4.174  -7.553  1.00  1.91           C  
ATOM    637  OE1 GLN A 181      20.656   4.006  -8.162  1.00  2.41           O  
ATOM    638  NE2 GLN A 181      22.098   5.362  -7.102  1.00  2.44           N  
ATOM    639  H   GLN A 181      23.198   0.296  -7.278  1.00  1.51           H  
ATOM    640  HA  GLN A 181      24.343   1.990  -5.291  1.00  1.46           H  
ATOM    641  HB2 GLN A 181      21.443   1.720  -6.104  1.00  1.64           H  
ATOM    642  HB3 GLN A 181      22.154   3.061  -5.217  1.00  1.70           H  
ATOM    643  HG2 GLN A 181      23.660   3.386  -7.244  1.00  2.39           H  
ATOM    644  HG3 GLN A 181      22.557   2.299  -8.087  1.00  2.13           H  
ATOM    645 HE21 GLN A 181      22.953   5.423  -6.626  1.00  2.71           H  
ATOM    646 HE22 GLN A 181      21.512   6.132  -7.265  1.00  2.94           H  
ATOM    647  N   LEU A 182      22.425  -0.470  -4.328  1.00  1.32           N  
ATOM    648  CA  LEU A 182      21.977  -1.235  -3.169  1.00  1.33           C  
ATOM    649  C   LEU A 182      23.163  -1.821  -2.408  1.00  1.38           C  
ATOM    650  O   LEU A 182      23.048  -2.171  -1.234  1.00  1.48           O  
ATOM    651  CB  LEU A 182      21.032  -2.357  -3.604  1.00  1.48           C  
ATOM    652  CG  LEU A 182      19.968  -1.951  -4.627  1.00  1.79           C  
ATOM    653  CD1 LEU A 182      19.056  -3.126  -4.942  1.00  2.43           C  
ATOM    654  CD2 LEU A 182      19.159  -0.768  -4.114  1.00  1.91           C  
ATOM    655  H   LEU A 182      22.263  -0.825  -5.226  1.00  1.41           H  
ATOM    656  HA  LEU A 182      21.444  -0.561  -2.514  1.00  1.30           H  
ATOM    657  HB2 LEU A 182      21.625  -3.154  -4.028  1.00  1.99           H  
ATOM    658  HB3 LEU A 182      20.528  -2.733  -2.727  1.00  1.42           H  
ATOM    659  HG  LEU A 182      20.456  -1.653  -5.544  1.00  2.14           H  
ATOM    660 HD11 LEU A 182      18.384  -2.856  -5.744  1.00  2.56           H  
ATOM    661 HD12 LEU A 182      18.483  -3.383  -4.064  1.00  2.87           H  
ATOM    662 HD13 LEU A 182      19.652  -3.975  -5.243  1.00  2.92           H  
ATOM    663 HD21 LEU A 182      19.789   0.108  -4.075  1.00  2.37           H  
ATOM    664 HD22 LEU A 182      18.787  -0.988  -3.126  1.00  2.19           H  
ATOM    665 HD23 LEU A 182      18.329  -0.586  -4.780  1.00  2.20           H  
ATOM    666  N   LEU A 183      24.303  -1.925  -3.085  1.00  1.42           N  
ATOM    667  CA  LEU A 183      25.510  -2.469  -2.471  1.00  1.53           C  
ATOM    668  C   LEU A 183      25.915  -1.652  -1.248  1.00  1.48           C  
ATOM    669  O   LEU A 183      26.061  -2.191  -0.151  1.00  1.55           O  
ATOM    670  CB  LEU A 183      26.657  -2.494  -3.484  1.00  1.74           C  
ATOM    671  CG  LEU A 183      26.505  -3.519  -4.610  1.00  1.93           C  
ATOM    672  CD1 LEU A 183      27.602  -3.337  -5.647  1.00  2.27           C  
ATOM    673  CD2 LEU A 183      26.528  -4.933  -4.049  1.00  2.15           C  
ATOM    674  H   LEU A 183      24.335  -1.628  -4.019  1.00  1.44           H  
ATOM    675  HA  LEU A 183      25.295  -3.480  -2.159  1.00  1.62           H  
ATOM    676  HB2 LEU A 183      26.739  -1.511  -3.927  1.00  1.76           H  
ATOM    677  HB3 LEU A 183      27.573  -2.709  -2.954  1.00  1.84           H  
ATOM    678  HG  LEU A 183      25.555  -3.367  -5.100  1.00  1.80           H  
ATOM    679 HD11 LEU A 183      28.564  -3.508  -5.187  1.00  2.52           H  
ATOM    680 HD12 LEU A 183      27.565  -2.332  -6.039  1.00  2.64           H  
ATOM    681 HD13 LEU A 183      27.457  -4.043  -6.452  1.00  2.54           H  
ATOM    682 HD21 LEU A 183      27.395  -5.055  -3.417  1.00  2.52           H  
ATOM    683 HD22 LEU A 183      26.573  -5.642  -4.862  1.00  2.52           H  
ATOM    684 HD23 LEU A 183      25.632  -5.104  -3.471  1.00  2.19           H  
ATOM    685  N   ASP A 184      26.094  -0.350  -1.445  1.00  1.47           N  
ATOM    686  CA  ASP A 184      26.481   0.541  -0.356  1.00  1.55           C  
ATOM    687  C   ASP A 184      25.359   0.665   0.670  1.00  1.48           C  
ATOM    688  O   ASP A 184      25.608   0.690   1.876  1.00  1.85           O  
ATOM    689  CB  ASP A 184      26.841   1.924  -0.905  1.00  1.74           C  
ATOM    690  CG  ASP A 184      28.120   1.908  -1.718  1.00  1.99           C  
ATOM    691  OD1 ASP A 184      28.073   1.482  -2.891  1.00  2.35           O  
ATOM    692  OD2 ASP A 184      29.170   2.323  -1.182  1.00  2.40           O  
ATOM    693  H   ASP A 184      25.962   0.021  -2.342  1.00  1.49           H  
ATOM    694  HA  ASP A 184      27.349   0.118   0.126  1.00  1.62           H  
ATOM    695  HB2 ASP A 184      26.039   2.273  -1.537  1.00  1.80           H  
ATOM    696  HB3 ASP A 184      26.968   2.610  -0.080  1.00  1.94           H  
ATOM    697  N   ALA A 185      24.125   0.741   0.183  1.00  1.24           N  
ATOM    698  CA  ALA A 185      22.964   0.860   1.057  1.00  1.20           C  
ATOM    699  C   ALA A 185      22.598  -0.488   1.670  1.00  1.23           C  
ATOM    700  O   ALA A 185      21.922  -1.303   1.042  1.00  1.26           O  
ATOM    701  CB  ALA A 185      21.782   1.431   0.289  1.00  1.20           C  
ATOM    702  H   ALA A 185      23.991   0.714  -0.787  1.00  1.29           H  
ATOM    703  HA  ALA A 185      23.214   1.549   1.852  1.00  1.25           H  
ATOM    704  HB1 ALA A 185      22.048   2.396  -0.117  1.00  1.43           H  
ATOM    705  HB2 ALA A 185      20.939   1.542   0.956  1.00  1.29           H  
ATOM    706  HB3 ALA A 185      21.519   0.762  -0.516  1.00  1.95           H  
ATOM    707  N   ASP A 186      23.047  -0.715   2.900  1.00  1.34           N  
ATOM    708  CA  ASP A 186      22.767  -1.964   3.598  1.00  1.47           C  
ATOM    709  C   ASP A 186      21.292  -2.051   3.981  1.00  1.48           C  
ATOM    710  O   ASP A 186      20.940  -1.991   5.160  1.00  1.64           O  
ATOM    711  CB  ASP A 186      23.638  -2.081   4.850  1.00  1.66           C  
ATOM    712  CG  ASP A 186      25.098  -2.326   4.516  1.00  1.75           C  
ATOM    713  OD1 ASP A 186      25.395  -3.349   3.866  1.00  1.82           O  
ATOM    714  OD2 ASP A 186      25.943  -1.494   4.907  1.00  2.43           O  
ATOM    715  H   ASP A 186      23.580  -0.026   3.350  1.00  1.39           H  
ATOM    716  HA  ASP A 186      23.000  -2.777   2.929  1.00  1.48           H  
ATOM    717  HB2 ASP A 186      23.567  -1.166   5.418  1.00  1.76           H  
ATOM    718  HB3 ASP A 186      23.282  -2.903   5.454  1.00  1.63           H  
ATOM    719  N   ILE A 187      20.433  -2.191   2.976  1.00  1.35           N  
ATOM    720  CA  ILE A 187      18.997  -2.284   3.204  1.00  1.38           C  
ATOM    721  C   ILE A 187      18.482  -3.688   2.902  1.00  1.50           C  
ATOM    722  O   ILE A 187      18.195  -4.022   1.752  1.00  2.13           O  
ATOM    723  CB  ILE A 187      18.224  -1.263   2.345  1.00  1.37           C  
ATOM    724  CG1 ILE A 187      16.733  -1.299   2.685  1.00  1.47           C  
ATOM    725  CG2 ILE A 187      18.443  -1.538   0.863  1.00  1.61           C  
ATOM    726  CD1 ILE A 187      15.948  -0.152   2.086  1.00  1.71           C  
ATOM    727  H   ILE A 187      20.774  -2.230   2.058  1.00  1.28           H  
ATOM    728  HA  ILE A 187      18.810  -2.060   4.245  1.00  1.40           H  
ATOM    729  HB  ILE A 187      18.611  -0.279   2.561  1.00  1.45           H  
ATOM    730 HG12 ILE A 187      16.307  -2.220   2.314  1.00  1.66           H  
ATOM    731 HG13 ILE A 187      16.614  -1.258   3.758  1.00  1.47           H  
ATOM    732 HG21 ILE A 187      19.377  -2.064   0.729  1.00  2.01           H  
ATOM    733 HG22 ILE A 187      18.476  -0.604   0.324  1.00  2.00           H  
ATOM    734 HG23 ILE A 187      17.632  -2.143   0.486  1.00  1.88           H  
ATOM    735 HD11 ILE A 187      14.964  -0.498   1.803  1.00  1.85           H  
ATOM    736 HD12 ILE A 187      16.463   0.220   1.213  1.00  2.08           H  
ATOM    737 HD13 ILE A 187      15.855   0.640   2.813  1.00  2.14           H  
ATOM    738  N   ARG A 188      18.366  -4.507   3.942  1.00  1.20           N  
ATOM    739  CA  ARG A 188      17.886  -5.875   3.790  1.00  1.26           C  
ATOM    740  C   ARG A 188      16.495  -6.034   4.394  1.00  1.32           C  
ATOM    741  O   ARG A 188      15.955  -5.099   4.987  1.00  1.65           O  
ATOM    742  CB  ARG A 188      18.857  -6.856   4.450  1.00  1.24           C  
ATOM    743  CG  ARG A 188      20.108  -7.120   3.629  1.00  1.76           C  
ATOM    744  CD  ARG A 188      20.889  -8.306   4.169  1.00  1.81           C  
ATOM    745  NE  ARG A 188      21.489  -9.101   3.100  1.00  2.14           N  
ATOM    746  CZ  ARG A 188      22.362 -10.082   3.310  1.00  2.47           C  
ATOM    747  NH1 ARG A 188      22.736 -10.387   4.545  1.00  2.99           N  
ATOM    748  NH2 ARG A 188      22.862 -10.757   2.284  1.00  2.79           N  
ATOM    749  H   ARG A 188      18.610  -4.183   4.834  1.00  1.29           H  
ATOM    750  HA  ARG A 188      17.833  -6.092   2.733  1.00  1.43           H  
ATOM    751  HB2 ARG A 188      19.158  -6.455   5.407  1.00  1.46           H  
ATOM    752  HB3 ARG A 188      18.349  -7.797   4.607  1.00  1.58           H  
ATOM    753  HG2 ARG A 188      19.820  -7.328   2.609  1.00  2.30           H  
ATOM    754  HG3 ARG A 188      20.737  -6.243   3.656  1.00  2.20           H  
ATOM    755  HD2 ARG A 188      21.674  -7.941   4.814  1.00  1.86           H  
ATOM    756  HD3 ARG A 188      20.219  -8.934   4.738  1.00  2.20           H  
ATOM    757  HE  ARG A 188      21.228  -8.892   2.179  1.00  2.57           H  
ATOM    758 HH11 ARG A 188      22.362  -9.881   5.321  1.00  3.17           H  
ATOM    759 HH12 ARG A 188      23.393 -11.126   4.699  1.00  3.44           H  
ATOM    760 HH21 ARG A 188      22.583 -10.529   1.352  1.00  2.84           H  
ATOM    761 HH22 ARG A 188      23.519 -11.494   2.443  1.00  3.26           H  
ATOM    762  N   VAL A 189      15.918  -7.222   4.239  1.00  1.27           N  
ATOM    763  CA  VAL A 189      14.590  -7.502   4.770  1.00  1.39           C  
ATOM    764  C   VAL A 189      14.593  -7.489   6.295  1.00  1.68           C  
ATOM    765  O   VAL A 189      15.341  -8.232   6.931  1.00  2.11           O  
ATOM    766  CB  VAL A 189      14.063  -8.864   4.279  1.00  1.43           C  
ATOM    767  CG1 VAL A 189      13.950  -8.878   2.761  1.00  1.54           C  
ATOM    768  CG2 VAL A 189      14.960  -9.993   4.764  1.00  1.61           C  
ATOM    769  H   VAL A 189      16.399  -7.927   3.757  1.00  1.35           H  
ATOM    770  HA  VAL A 189      13.920  -6.732   4.415  1.00  1.53           H  
ATOM    771  HB  VAL A 189      13.076  -9.015   4.691  1.00  1.48           H  
ATOM    772 HG11 VAL A 189      13.260  -9.651   2.459  1.00  1.87           H  
ATOM    773 HG12 VAL A 189      14.921  -9.073   2.330  1.00  1.93           H  
ATOM    774 HG13 VAL A 189      13.590  -7.919   2.419  1.00  1.84           H  
ATOM    775 HG21 VAL A 189      14.757 -10.194   5.804  1.00  1.98           H  
ATOM    776 HG22 VAL A 189      15.995  -9.705   4.649  1.00  1.70           H  
ATOM    777 HG23 VAL A 189      14.769 -10.882   4.181  1.00  2.13           H  
ATOM    778  N   GLY A 190      13.751  -6.641   6.877  1.00  2.12           N  
ATOM    779  CA  GLY A 190      13.672  -6.547   8.322  1.00  2.55           C  
ATOM    780  C   GLY A 190      13.317  -5.149   8.794  1.00  1.98           C  
ATOM    781  O   GLY A 190      12.485  -4.981   9.685  1.00  2.29           O  
ATOM    782  H   GLY A 190      13.179  -6.073   6.318  1.00  2.49           H  
ATOM    783  HA2 GLY A 190      12.921  -7.236   8.677  1.00  3.02           H  
ATOM    784  HA3 GLY A 190      14.627  -6.824   8.743  1.00  3.04           H  
ATOM    785  N   SER A 191      13.950  -4.146   8.195  1.00  1.32           N  
ATOM    786  CA  SER A 191      13.696  -2.757   8.558  1.00  1.13           C  
ATOM    787  C   SER A 191      12.618  -2.149   7.667  1.00  0.88           C  
ATOM    788  O   SER A 191      12.385  -2.615   6.552  1.00  0.99           O  
ATOM    789  CB  SER A 191      14.984  -1.936   8.452  1.00  1.29           C  
ATOM    790  OG  SER A 191      15.998  -2.469   9.286  1.00  1.81           O  
ATOM    791  H   SER A 191      14.603  -4.344   7.491  1.00  1.25           H  
ATOM    792  HA  SER A 191      13.353  -2.739   9.582  1.00  1.51           H  
ATOM    793  HB2 SER A 191      15.333  -1.949   7.430  1.00  1.52           H  
ATOM    794  HB3 SER A 191      14.786  -0.918   8.753  1.00  1.64           H  
ATOM    795  HG  SER A 191      16.858  -2.185   8.967  1.00  2.14           H  
ATOM    796  N   GLU A 192      11.963  -1.106   8.166  1.00  0.84           N  
ATOM    797  CA  GLU A 192      10.909  -0.432   7.417  1.00  0.74           C  
ATOM    798  C   GLU A 192      11.394   0.911   6.881  1.00  0.74           C  
ATOM    799  O   GLU A 192      12.288   1.534   7.455  1.00  0.99           O  
ATOM    800  CB  GLU A 192       9.677  -0.228   8.300  1.00  0.91           C  
ATOM    801  CG  GLU A 192       9.971   0.516   9.593  1.00  1.71           C  
ATOM    802  CD  GLU A 192      10.253  -0.418  10.753  1.00  1.93           C  
ATOM    803  OE1 GLU A 192       9.300  -1.054  11.249  1.00  2.33           O  
ATOM    804  OE2 GLU A 192      11.428  -0.514  11.166  1.00  2.37           O  
ATOM    805  H   GLU A 192      12.195  -0.780   9.061  1.00  1.06           H  
ATOM    806  HA  GLU A 192      10.642  -1.063   6.582  1.00  0.80           H  
ATOM    807  HB2 GLU A 192       8.940   0.335   7.746  1.00  1.24           H  
ATOM    808  HB3 GLU A 192       9.264  -1.193   8.552  1.00  1.45           H  
ATOM    809  HG2 GLU A 192      10.834   1.148   9.441  1.00  2.32           H  
ATOM    810  HG3 GLU A 192       9.117   1.130   9.842  1.00  2.34           H  
ATOM    811  N   VAL A 193      10.796   1.352   5.778  1.00  0.71           N  
ATOM    812  CA  VAL A 193      11.166   2.623   5.164  1.00  0.76           C  
ATOM    813  C   VAL A 193      10.009   3.198   4.353  1.00  0.70           C  
ATOM    814  O   VAL A 193       9.091   2.476   3.965  1.00  0.74           O  
ATOM    815  CB  VAL A 193      12.393   2.468   4.247  1.00  0.93           C  
ATOM    816  CG1 VAL A 193      13.672   2.405   5.069  1.00  1.00           C  
ATOM    817  CG2 VAL A 193      12.254   1.233   3.370  1.00  1.03           C  
ATOM    818  H   VAL A 193      10.089   0.812   5.368  1.00  0.85           H  
ATOM    819  HA  VAL A 193      11.418   3.314   5.955  1.00  0.78           H  
ATOM    820  HB  VAL A 193      12.449   3.335   3.604  1.00  1.01           H  
ATOM    821 HG11 VAL A 193      13.678   3.212   5.787  1.00  1.58           H  
ATOM    822 HG12 VAL A 193      14.526   2.500   4.415  1.00  1.35           H  
ATOM    823 HG13 VAL A 193      13.718   1.460   5.589  1.00  1.35           H  
ATOM    824 HG21 VAL A 193      11.272   1.219   2.921  1.00  1.26           H  
ATOM    825 HG22 VAL A 193      12.388   0.347   3.971  1.00  1.63           H  
ATOM    826 HG23 VAL A 193      13.004   1.257   2.592  1.00  1.48           H  
ATOM    827  N   GLU A 194      10.061   4.502   4.101  1.00  0.69           N  
ATOM    828  CA  GLU A 194       9.017   5.175   3.335  1.00  0.70           C  
ATOM    829  C   GLU A 194       9.357   5.189   1.848  1.00  0.66           C  
ATOM    830  O   GLU A 194      10.433   5.637   1.451  1.00  0.77           O  
ATOM    831  CB  GLU A 194       8.828   6.608   3.839  1.00  0.79           C  
ATOM    832  CG  GLU A 194       8.308   6.687   5.266  1.00  1.44           C  
ATOM    833  CD  GLU A 194       8.232   8.110   5.780  1.00  1.48           C  
ATOM    834  OE1 GLU A 194       7.464   8.910   5.204  1.00  1.63           O  
ATOM    835  OE2 GLU A 194       8.942   8.427   6.758  1.00  2.03           O  
ATOM    836  H   GLU A 194      10.819   5.024   4.437  1.00  0.71           H  
ATOM    837  HA  GLU A 194       8.097   4.629   3.477  1.00  0.74           H  
ATOM    838  HB2 GLU A 194       9.778   7.120   3.797  1.00  1.39           H  
ATOM    839  HB3 GLU A 194       8.126   7.114   3.194  1.00  1.22           H  
ATOM    840  HG2 GLU A 194       7.319   6.255   5.298  1.00  1.99           H  
ATOM    841  HG3 GLU A 194       8.968   6.121   5.907  1.00  2.10           H  
ATOM    842  N   ILE A 195       8.434   4.693   1.030  1.00  0.81           N  
ATOM    843  CA  ILE A 195       8.636   4.648  -0.413  1.00  0.81           C  
ATOM    844  C   ILE A 195       8.193   5.950  -1.072  1.00  0.83           C  
ATOM    845  O   ILE A 195       7.397   6.702  -0.510  1.00  0.97           O  
ATOM    846  CB  ILE A 195       7.867   3.475  -1.055  1.00  1.06           C  
ATOM    847  CG1 ILE A 195       7.849   2.268  -0.115  1.00  0.93           C  
ATOM    848  CG2 ILE A 195       8.490   3.103  -2.393  1.00  1.49           C  
ATOM    849  CD1 ILE A 195       6.542   2.100   0.630  1.00  1.44           C  
ATOM    850  H   ILE A 195       7.596   4.350   1.406  1.00  1.07           H  
ATOM    851  HA  ILE A 195       9.690   4.503  -0.598  1.00  0.74           H  
ATOM    852  HB  ILE A 195       6.853   3.796  -1.238  1.00  1.38           H  
ATOM    853 HG12 ILE A 195       8.020   1.369  -0.690  1.00  1.32           H  
ATOM    854 HG13 ILE A 195       8.637   2.377   0.616  1.00  1.10           H  
ATOM    855 HG21 ILE A 195       9.563   3.031  -2.282  1.00  1.94           H  
ATOM    856 HG22 ILE A 195       8.254   3.862  -3.124  1.00  2.01           H  
ATOM    857 HG23 ILE A 195       8.098   2.152  -2.721  1.00  1.72           H  
ATOM    858 HD11 ILE A 195       6.683   2.363   1.667  1.00  1.70           H  
ATOM    859 HD12 ILE A 195       6.217   1.073   0.558  1.00  1.86           H  
ATOM    860 HD13 ILE A 195       5.793   2.745   0.193  1.00  2.04           H  
ATOM    861  N   VAL A 196       8.714   6.209  -2.268  1.00  0.80           N  
ATOM    862  CA  VAL A 196       8.373   7.420  -3.005  1.00  0.94           C  
ATOM    863  C   VAL A 196       7.937   7.087  -4.428  1.00  1.04           C  
ATOM    864  O   VAL A 196       8.763   6.996  -5.337  1.00  1.39           O  
ATOM    865  CB  VAL A 196       9.561   8.399  -3.059  1.00  1.00           C  
ATOM    866  CG1 VAL A 196       9.119   9.748  -3.605  1.00  1.21           C  
ATOM    867  CG2 VAL A 196      10.190   8.553  -1.682  1.00  1.93           C  
ATOM    868  H   VAL A 196       9.342   5.570  -2.663  1.00  0.75           H  
ATOM    869  HA  VAL A 196       7.556   7.905  -2.492  1.00  1.17           H  
ATOM    870  HB  VAL A 196      10.306   7.993  -3.728  1.00  1.44           H  
ATOM    871 HG11 VAL A 196       9.961  10.424  -3.619  1.00  1.75           H  
ATOM    872 HG12 VAL A 196       8.341  10.154  -2.975  1.00  1.71           H  
ATOM    873 HG13 VAL A 196       8.741   9.624  -4.609  1.00  1.67           H  
ATOM    874 HG21 VAL A 196      10.964   9.305  -1.722  1.00  2.49           H  
ATOM    875 HG22 VAL A 196      10.618   7.611  -1.374  1.00  2.24           H  
ATOM    876 HG23 VAL A 196       9.433   8.854  -0.973  1.00  2.40           H  
ATOM    877  N   ASP A 197       6.633   6.908  -4.615  1.00  1.16           N  
ATOM    878  CA  ASP A 197       6.086   6.584  -5.928  1.00  1.28           C  
ATOM    879  C   ASP A 197       6.185   7.781  -6.869  1.00  1.27           C  
ATOM    880  O   ASP A 197       5.346   8.681  -6.836  1.00  1.71           O  
ATOM    881  CB  ASP A 197       4.628   6.140  -5.801  1.00  1.80           C  
ATOM    882  CG  ASP A 197       4.133   5.420  -7.040  1.00  1.92           C  
ATOM    883  OD1 ASP A 197       4.587   4.283  -7.288  1.00  2.52           O  
ATOM    884  OD2 ASP A 197       3.290   5.993  -7.763  1.00  2.35           O  
ATOM    885  H   ASP A 197       6.024   6.992  -3.852  1.00  1.40           H  
ATOM    886  HA  ASP A 197       6.666   5.771  -6.337  1.00  1.48           H  
ATOM    887  HB2 ASP A 197       4.533   5.472  -4.958  1.00  2.01           H  
ATOM    888  HB3 ASP A 197       4.007   7.008  -5.639  1.00  2.08           H  
ATOM    889  N   ARG A 198       7.216   7.783  -7.709  1.00  1.21           N  
ATOM    890  CA  ARG A 198       7.426   8.868  -8.661  1.00  1.60           C  
ATOM    891  C   ARG A 198       6.902   8.488 -10.041  1.00  1.52           C  
ATOM    892  O   ARG A 198       6.850   7.310 -10.394  1.00  1.63           O  
ATOM    893  CB  ARG A 198       8.911   9.221  -8.745  1.00  2.17           C  
ATOM    894  CG  ARG A 198       9.179  10.582  -9.368  1.00  2.74           C  
ATOM    895  CD  ARG A 198      10.656  10.940  -9.312  1.00  3.44           C  
ATOM    896  NE  ARG A 198      10.886  12.355  -9.591  1.00  4.13           N  
ATOM    897  CZ  ARG A 198      10.602  13.331  -8.735  1.00  4.78           C  
ATOM    898  NH1 ARG A 198      10.078  13.047  -7.549  1.00  5.28           N  
ATOM    899  NH2 ARG A 198      10.841  14.593  -9.062  1.00  5.17           N  
ATOM    900  H   ARG A 198       7.851   7.037  -7.688  1.00  1.21           H  
ATOM    901  HA  ARG A 198       6.880   9.730  -8.306  1.00  1.85           H  
ATOM    902  HB2 ARG A 198       9.328   9.218  -7.748  1.00  2.54           H  
ATOM    903  HB3 ARG A 198       9.415   8.472  -9.338  1.00  2.43           H  
ATOM    904  HG2 ARG A 198       8.863  10.563 -10.400  1.00  2.91           H  
ATOM    905  HG3 ARG A 198       8.616  11.330  -8.831  1.00  3.13           H  
ATOM    906  HD2 ARG A 198      11.031  10.711  -8.326  1.00  3.55           H  
ATOM    907  HD3 ARG A 198      11.184  10.347 -10.045  1.00  3.75           H  
ATOM    908  HE  ARG A 198      11.272  12.589 -10.460  1.00  4.33           H  
ATOM    909 HH11 ARG A 198       9.896  12.096  -7.297  1.00  5.15           H  
ATOM    910 HH12 ARG A 198       9.866  13.783  -6.907  1.00  5.91           H  
ATOM    911 HH21 ARG A 198      11.236  14.812  -9.955  1.00  5.02           H  
ATOM    912 HH22 ARG A 198      10.626  15.328  -8.418  1.00  5.74           H  
ATOM    913  N   ASP A 199       6.514   9.494 -10.819  1.00  1.54           N  
ATOM    914  CA  ASP A 199       5.994   9.265 -12.162  1.00  1.51           C  
ATOM    915  C   ASP A 199       7.089   8.748 -13.089  1.00  1.55           C  
ATOM    916  O   ASP A 199       7.675   9.508 -13.861  1.00  2.34           O  
ATOM    917  CB  ASP A 199       5.398  10.556 -12.728  1.00  1.63           C  
ATOM    918  CG  ASP A 199       4.145  10.986 -11.993  1.00  1.68           C  
ATOM    919  OD1 ASP A 199       3.061  10.445 -12.297  1.00  2.48           O  
ATOM    920  OD2 ASP A 199       4.246  11.863 -11.109  1.00  1.84           O  
ATOM    921  H   ASP A 199       6.579  10.412 -10.482  1.00  1.69           H  
ATOM    922  HA  ASP A 199       5.215   8.521 -12.094  1.00  1.83           H  
ATOM    923  HB2 ASP A 199       6.128  11.348 -12.649  1.00  1.78           H  
ATOM    924  HB3 ASP A 199       5.149  10.405 -13.769  1.00  1.86           H  
ATOM    925  N   GLY A 200       7.362   7.450 -13.007  1.00  1.31           N  
ATOM    926  CA  GLY A 200       8.387   6.851 -13.843  1.00  1.53           C  
ATOM    927  C   GLY A 200       9.313   5.940 -13.063  1.00  1.30           C  
ATOM    928  O   GLY A 200       9.814   4.949 -13.596  1.00  1.69           O  
ATOM    929  H   GLY A 200       6.863   6.892 -12.373  1.00  1.54           H  
ATOM    930  HA2 GLY A 200       7.910   6.278 -14.624  1.00  2.07           H  
ATOM    931  HA3 GLY A 200       8.971   7.638 -14.296  1.00  1.76           H  
ATOM    932  N   HIS A 201       9.542   6.274 -11.796  1.00  1.04           N  
ATOM    933  CA  HIS A 201      10.416   5.478 -10.941  1.00  1.15           C  
ATOM    934  C   HIS A 201       9.900   5.455  -9.506  1.00  0.99           C  
ATOM    935  O   HIS A 201       8.916   6.119  -9.179  1.00  0.96           O  
ATOM    936  CB  HIS A 201      11.841   6.032 -10.974  1.00  1.60           C  
ATOM    937  CG  HIS A 201      12.484   5.951 -12.324  1.00  1.96           C  
ATOM    938  ND1 HIS A 201      13.371   4.954 -12.676  1.00  2.18           N  
ATOM    939  CD2 HIS A 201      12.366   6.748 -13.412  1.00  2.72           C  
ATOM    940  CE1 HIS A 201      13.771   5.143 -13.921  1.00  2.56           C  
ATOM    941  NE2 HIS A 201      13.176   6.224 -14.390  1.00  2.90           N  
ATOM    942  H   HIS A 201       9.115   7.074 -11.428  1.00  1.14           H  
ATOM    943  HA  HIS A 201      10.424   4.467 -11.324  1.00  1.34           H  
ATOM    944  HB2 HIS A 201      11.822   7.071 -10.678  1.00  1.75           H  
ATOM    945  HB3 HIS A 201      12.452   5.477 -10.279  1.00  1.91           H  
ATOM    946  HD1 HIS A 201      13.663   4.218 -12.099  1.00  2.48           H  
ATOM    947  HD2 HIS A 201      11.751   7.632 -13.494  1.00  3.38           H  
ATOM    948  HE1 HIS A 201      14.464   4.519 -14.463  1.00  2.93           H  
ATOM    949  HE2 HIS A 201      13.228   6.542 -15.316  1.00  3.48           H  
ATOM    950  N   ILE A 202      10.571   4.687  -8.653  1.00  1.00           N  
ATOM    951  CA  ILE A 202      10.181   4.578  -7.252  1.00  0.92           C  
ATOM    952  C   ILE A 202      11.398   4.655  -6.337  1.00  0.92           C  
ATOM    953  O   ILE A 202      12.176   3.706  -6.238  1.00  1.22           O  
ATOM    954  CB  ILE A 202       9.428   3.261  -6.975  1.00  1.01           C  
ATOM    955  CG1 ILE A 202      10.080   2.102  -7.736  1.00  1.22           C  
ATOM    956  CG2 ILE A 202       7.962   3.398  -7.358  1.00  1.11           C  
ATOM    957  CD1 ILE A 202       9.687   2.035  -9.196  1.00  1.54           C  
ATOM    958  H   ILE A 202      11.347   4.182  -8.973  1.00  1.14           H  
ATOM    959  HA  ILE A 202       9.520   5.402  -7.025  1.00  0.91           H  
ATOM    960  HB  ILE A 202       9.479   3.060  -5.916  1.00  0.98           H  
ATOM    961 HG12 ILE A 202      11.153   2.208  -7.687  1.00  1.15           H  
ATOM    962 HG13 ILE A 202       9.794   1.170  -7.271  1.00  1.56           H  
ATOM    963 HG21 ILE A 202       7.425   3.884  -6.557  1.00  1.64           H  
ATOM    964 HG22 ILE A 202       7.541   2.418  -7.531  1.00  1.42           H  
ATOM    965 HG23 ILE A 202       7.878   3.989  -8.258  1.00  1.48           H  
ATOM    966 HD11 ILE A 202       9.013   1.205  -9.349  1.00  1.90           H  
ATOM    967 HD12 ILE A 202      10.572   1.896  -9.800  1.00  2.00           H  
ATOM    968 HD13 ILE A 202       9.198   2.954  -9.481  1.00  1.92           H  
ATOM    969  N   THR A 203      11.557   5.793  -5.667  1.00  0.79           N  
ATOM    970  CA  THR A 203      12.680   5.995  -4.758  1.00  0.79           C  
ATOM    971  C   THR A 203      12.330   5.528  -3.349  1.00  0.77           C  
ATOM    972  O   THR A 203      11.156   5.396  -3.002  1.00  0.94           O  
ATOM    973  CB  THR A 203      13.084   7.471  -4.733  1.00  0.84           C  
ATOM    974  OG1 THR A 203      13.090   8.011  -6.042  1.00  0.93           O  
ATOM    975  CG2 THR A 203      14.452   7.707  -4.133  1.00  0.95           C  
ATOM    976  H   THR A 203      10.905   6.514  -5.787  1.00  0.88           H  
ATOM    977  HA  THR A 203      13.511   5.411  -5.123  1.00  0.86           H  
ATOM    978  HB  THR A 203      12.364   8.020  -4.142  1.00  0.87           H  
ATOM    979  HG1 THR A 203      12.223   8.371  -6.245  1.00  1.35           H  
ATOM    980 HG21 THR A 203      15.106   6.885  -4.388  1.00  1.26           H  
ATOM    981 HG22 THR A 203      14.368   7.778  -3.059  1.00  1.44           H  
ATOM    982 HG23 THR A 203      14.863   8.627  -4.524  1.00  1.12           H  
ATOM    983  N   LEU A 204      13.357   5.280  -2.541  1.00  0.73           N  
ATOM    984  CA  LEU A 204      13.157   4.827  -1.168  1.00  0.74           C  
ATOM    985  C   LEU A 204      13.945   5.693  -0.190  1.00  0.74           C  
ATOM    986  O   LEU A 204      15.111   6.012  -0.428  1.00  0.84           O  
ATOM    987  CB  LEU A 204      13.579   3.363  -1.025  1.00  0.85           C  
ATOM    988  CG  LEU A 204      12.464   2.405  -0.600  1.00  1.52           C  
ATOM    989  CD1 LEU A 204      13.004   0.992  -0.444  1.00  2.51           C  
ATOM    990  CD2 LEU A 204      11.821   2.879   0.696  1.00  1.97           C  
ATOM    991  H   LEU A 204      14.270   5.404  -2.875  1.00  0.82           H  
ATOM    992  HA  LEU A 204      12.105   4.913  -0.941  1.00  0.76           H  
ATOM    993  HB2 LEU A 204      13.969   3.028  -1.976  1.00  1.34           H  
ATOM    994  HB3 LEU A 204      14.369   3.307  -0.291  1.00  1.16           H  
ATOM    995  HG  LEU A 204      11.701   2.388  -1.366  1.00  2.10           H  
ATOM    996 HD11 LEU A 204      13.818   0.839  -1.137  1.00  2.84           H  
ATOM    997 HD12 LEU A 204      12.218   0.282  -0.650  1.00  3.23           H  
ATOM    998 HD13 LEU A 204      13.361   0.852   0.566  1.00  2.77           H  
ATOM    999 HD21 LEU A 204      11.159   2.111   1.070  1.00  2.57           H  
ATOM   1000 HD22 LEU A 204      11.258   3.781   0.510  1.00  2.09           H  
ATOM   1001 HD23 LEU A 204      12.590   3.078   1.427  1.00  2.52           H  
ATOM   1002  N   SER A 205      13.301   6.071   0.910  1.00  0.75           N  
ATOM   1003  CA  SER A 205      13.940   6.900   1.925  1.00  0.85           C  
ATOM   1004  C   SER A 205      14.283   6.077   3.162  1.00  0.90           C  
ATOM   1005  O   SER A 205      13.405   5.491   3.794  1.00  0.97           O  
ATOM   1006  CB  SER A 205      13.027   8.066   2.311  1.00  0.99           C  
ATOM   1007  OG  SER A 205      12.863   8.965   1.229  1.00  1.35           O  
ATOM   1008  H   SER A 205      12.372   5.785   1.041  1.00  0.77           H  
ATOM   1009  HA  SER A 205      14.853   7.294   1.504  1.00  0.85           H  
ATOM   1010  HB2 SER A 205      12.059   7.682   2.594  1.00  1.60           H  
ATOM   1011  HB3 SER A 205      13.461   8.598   3.145  1.00  1.49           H  
ATOM   1012  HG  SER A 205      12.893   9.868   1.556  1.00  1.58           H  
ATOM   1013  N   HIS A 206      15.569   6.038   3.503  1.00  0.94           N  
ATOM   1014  CA  HIS A 206      16.029   5.288   4.665  1.00  1.05           C  
ATOM   1015  C   HIS A 206      16.858   6.173   5.591  1.00  1.22           C  
ATOM   1016  O   HIS A 206      18.071   6.298   5.425  1.00  1.23           O  
ATOM   1017  CB  HIS A 206      16.855   4.078   4.223  1.00  1.04           C  
ATOM   1018  CG  HIS A 206      17.195   3.143   5.342  1.00  1.20           C  
ATOM   1019  ND1 HIS A 206      18.356   2.399   5.375  1.00  1.64           N  
ATOM   1020  CD2 HIS A 206      16.520   2.832   6.475  1.00  1.73           C  
ATOM   1021  CE1 HIS A 206      18.379   1.671   6.477  1.00  1.60           C  
ATOM   1022  NE2 HIS A 206      17.277   1.916   7.162  1.00  1.56           N  
ATOM   1023  H   HIS A 206      16.222   6.527   2.960  1.00  0.94           H  
ATOM   1024  HA  HIS A 206      15.159   4.941   5.202  1.00  1.06           H  
ATOM   1025  HB2 HIS A 206      16.297   3.522   3.484  1.00  0.95           H  
ATOM   1026  HB3 HIS A 206      17.780   4.423   3.784  1.00  1.06           H  
ATOM   1027  HD1 HIS A 206      19.058   2.403   4.691  1.00  2.31           H  
ATOM   1028  HD2 HIS A 206      15.563   3.231   6.780  1.00  2.54           H  
ATOM   1029  HE1 HIS A 206      19.166   0.992   6.769  1.00  2.09           H  
ATOM   1030  HE2 HIS A 206      17.002   1.448   7.978  1.00  1.88           H  
ATOM   1031  N   ASN A 207      16.193   6.785   6.567  1.00  1.43           N  
ATOM   1032  CA  ASN A 207      16.865   7.661   7.522  1.00  1.65           C  
ATOM   1033  C   ASN A 207      17.462   8.878   6.821  1.00  1.61           C  
ATOM   1034  O   ASN A 207      16.927   9.982   6.910  1.00  1.77           O  
ATOM   1035  CB  ASN A 207      17.961   6.894   8.266  1.00  1.75           C  
ATOM   1036  CG  ASN A 207      17.500   6.399   9.624  1.00  2.02           C  
ATOM   1037  OD1 ASN A 207      16.416   5.829   9.754  1.00  2.82           O  
ATOM   1038  ND2 ASN A 207      18.324   6.613  10.643  1.00  2.05           N  
ATOM   1039  H   ASN A 207      15.227   6.645   6.647  1.00  1.47           H  
ATOM   1040  HA  ASN A 207      16.128   7.998   8.235  1.00  1.83           H  
ATOM   1041  HB2 ASN A 207      18.261   6.043   7.676  1.00  2.00           H  
ATOM   1042  HB3 ASN A 207      18.812   7.545   8.411  1.00  1.83           H  
ATOM   1043 HD21 ASN A 207      19.171   7.072  10.466  1.00  2.16           H  
ATOM   1044 HD22 ASN A 207      18.050   6.302  11.532  1.00  2.44           H  
ATOM   1045  N   GLY A 208      18.573   8.666   6.122  1.00  1.47           N  
ATOM   1046  CA  GLY A 208      19.224   9.755   5.417  1.00  1.50           C  
ATOM   1047  C   GLY A 208      19.564   9.397   3.982  1.00  1.34           C  
ATOM   1048  O   GLY A 208      19.451  10.231   3.084  1.00  1.47           O  
ATOM   1049  H   GLY A 208      18.955   7.765   6.086  1.00  1.40           H  
ATOM   1050  HA2 GLY A 208      18.567  10.613   5.416  1.00  1.60           H  
ATOM   1051  HA3 GLY A 208      20.135  10.013   5.936  1.00  1.60           H  
ATOM   1052  N   LYS A 209      19.982   8.153   3.767  1.00  1.21           N  
ATOM   1053  CA  LYS A 209      20.339   7.687   2.432  1.00  1.09           C  
ATOM   1054  C   LYS A 209      19.101   7.232   1.664  1.00  0.93           C  
ATOM   1055  O   LYS A 209      18.083   6.882   2.260  1.00  0.90           O  
ATOM   1056  CB  LYS A 209      21.347   6.539   2.523  1.00  1.14           C  
ATOM   1057  CG  LYS A 209      22.715   6.970   3.023  1.00  1.47           C  
ATOM   1058  CD  LYS A 209      23.707   5.817   2.999  1.00  1.54           C  
ATOM   1059  CE  LYS A 209      25.129   6.300   3.231  1.00  2.04           C  
ATOM   1060  NZ  LYS A 209      26.051   5.175   3.550  1.00  2.63           N  
ATOM   1061  H   LYS A 209      20.051   7.534   4.524  1.00  1.29           H  
ATOM   1062  HA  LYS A 209      20.793   8.512   1.904  1.00  1.19           H  
ATOM   1063  HB2 LYS A 209      20.961   5.789   3.196  1.00  1.42           H  
ATOM   1064  HB3 LYS A 209      21.466   6.102   1.542  1.00  1.13           H  
ATOM   1065  HG2 LYS A 209      23.087   7.763   2.390  1.00  1.64           H  
ATOM   1066  HG3 LYS A 209      22.621   7.332   4.036  1.00  1.84           H  
ATOM   1067  HD2 LYS A 209      23.444   5.115   3.776  1.00  1.65           H  
ATOM   1068  HD3 LYS A 209      23.653   5.329   2.037  1.00  1.40           H  
ATOM   1069  HE2 LYS A 209      25.477   6.796   2.338  1.00  2.39           H  
ATOM   1070  HE3 LYS A 209      25.129   6.999   4.054  1.00  2.29           H  
ATOM   1071  HZ1 LYS A 209      25.786   4.741   4.456  1.00  2.80           H  
ATOM   1072  HZ2 LYS A 209      27.029   5.524   3.619  1.00  3.03           H  
ATOM   1073  HZ3 LYS A 209      26.005   4.452   2.804  1.00  3.13           H  
ATOM   1074  N   ASP A 210      19.198   7.242   0.338  1.00  0.91           N  
ATOM   1075  CA  ASP A 210      18.086   6.832  -0.512  1.00  0.80           C  
ATOM   1076  C   ASP A 210      18.577   5.967  -1.669  1.00  0.76           C  
ATOM   1077  O   ASP A 210      19.619   6.243  -2.265  1.00  0.96           O  
ATOM   1078  CB  ASP A 210      17.351   8.059  -1.055  1.00  0.89           C  
ATOM   1079  CG  ASP A 210      16.572   8.790   0.022  1.00  1.08           C  
ATOM   1080  OD1 ASP A 210      17.202   9.262   0.992  1.00  1.93           O  
ATOM   1081  OD2 ASP A 210      15.334   8.890  -0.106  1.00  1.22           O  
ATOM   1082  H   ASP A 210      20.036   7.533  -0.078  1.00  1.04           H  
ATOM   1083  HA  ASP A 210      17.404   6.251   0.090  1.00  0.78           H  
ATOM   1084  HB2 ASP A 210      18.071   8.743  -1.479  1.00  1.15           H  
ATOM   1085  HB3 ASP A 210      16.661   7.746  -1.824  1.00  1.20           H  
ATOM   1086  N   VAL A 211      17.820   4.919  -1.982  1.00  0.66           N  
ATOM   1087  CA  VAL A 211      18.178   4.014  -3.067  1.00  0.73           C  
ATOM   1088  C   VAL A 211      17.002   3.805  -4.017  1.00  0.77           C  
ATOM   1089  O   VAL A 211      15.894   3.484  -3.586  1.00  0.89           O  
ATOM   1090  CB  VAL A 211      18.641   2.645  -2.532  1.00  0.86           C  
ATOM   1091  CG1 VAL A 211      20.086   2.378  -2.923  1.00  0.94           C  
ATOM   1092  CG2 VAL A 211      18.467   2.570  -1.022  1.00  1.10           C  
ATOM   1093  H   VAL A 211      17.002   4.752  -1.470  1.00  0.68           H  
ATOM   1094  HA  VAL A 211      18.996   4.458  -3.616  1.00  0.81           H  
ATOM   1095  HB  VAL A 211      18.025   1.879  -2.981  1.00  1.12           H  
ATOM   1096 HG11 VAL A 211      20.407   1.438  -2.497  1.00  1.28           H  
ATOM   1097 HG12 VAL A 211      20.712   3.174  -2.549  1.00  1.44           H  
ATOM   1098 HG13 VAL A 211      20.165   2.331  -3.998  1.00  1.52           H  
ATOM   1099 HG21 VAL A 211      17.436   2.769  -0.767  1.00  1.41           H  
ATOM   1100 HG22 VAL A 211      19.103   3.304  -0.550  1.00  1.62           H  
ATOM   1101 HG23 VAL A 211      18.739   1.584  -0.676  1.00  1.64           H  
ATOM   1102  N   GLU A 212      17.251   3.991  -5.309  1.00  0.91           N  
ATOM   1103  CA  GLU A 212      16.213   3.824  -6.319  1.00  1.03           C  
ATOM   1104  C   GLU A 212      16.665   2.861  -7.412  1.00  1.19           C  
ATOM   1105  O   GLU A 212      17.458   3.222  -8.282  1.00  1.53           O  
ATOM   1106  CB  GLU A 212      15.848   5.177  -6.934  1.00  1.25           C  
ATOM   1107  CG  GLU A 212      14.609   5.132  -7.813  1.00  1.53           C  
ATOM   1108  CD  GLU A 212      14.650   6.155  -8.932  1.00  1.92           C  
ATOM   1109  OE1 GLU A 212      14.457   7.356  -8.646  1.00  2.29           O  
ATOM   1110  OE2 GLU A 212      14.876   5.756 -10.093  1.00  2.44           O  
ATOM   1111  H   GLU A 212      18.154   4.246  -5.590  1.00  1.05           H  
ATOM   1112  HA  GLU A 212      15.340   3.413  -5.834  1.00  0.98           H  
ATOM   1113  HB2 GLU A 212      15.673   5.886  -6.139  1.00  1.50           H  
ATOM   1114  HB3 GLU A 212      16.677   5.521  -7.535  1.00  1.64           H  
ATOM   1115  HG2 GLU A 212      14.527   4.148  -8.250  1.00  2.01           H  
ATOM   1116  HG3 GLU A 212      13.741   5.325  -7.200  1.00  1.95           H  
ATOM   1117  N   LEU A 213      16.154   1.635  -7.363  1.00  1.18           N  
ATOM   1118  CA  LEU A 213      16.504   0.619  -8.350  1.00  1.41           C  
ATOM   1119  C   LEU A 213      15.362  -0.375  -8.535  1.00  1.59           C  
ATOM   1120  O   LEU A 213      14.354  -0.315  -7.831  1.00  2.24           O  
ATOM   1121  CB  LEU A 213      17.775  -0.118  -7.924  1.00  1.96           C  
ATOM   1122  CG  LEU A 213      19.083   0.615  -8.231  1.00  3.16           C  
ATOM   1123  CD1 LEU A 213      20.247  -0.041  -7.506  1.00  3.97           C  
ATOM   1124  CD2 LEU A 213      19.336   0.646  -9.731  1.00  3.78           C  
ATOM   1125  H   LEU A 213      15.526   1.408  -6.646  1.00  1.19           H  
ATOM   1126  HA  LEU A 213      16.687   1.120  -9.288  1.00  1.76           H  
ATOM   1127  HB2 LEU A 213      17.726  -0.292  -6.858  1.00  2.09           H  
ATOM   1128  HB3 LEU A 213      17.798  -1.073  -8.427  1.00  2.03           H  
ATOM   1129  HG  LEU A 213      19.005   1.635  -7.883  1.00  3.58           H  
ATOM   1130 HD11 LEU A 213      20.213  -1.109  -7.663  1.00  4.29           H  
ATOM   1131 HD12 LEU A 213      20.177   0.169  -6.449  1.00  4.24           H  
ATOM   1132 HD13 LEU A 213      21.177   0.351  -7.890  1.00  4.42           H  
ATOM   1133 HD21 LEU A 213      20.316   1.056  -9.923  1.00  4.27           H  
ATOM   1134 HD22 LEU A 213      18.588   1.260 -10.210  1.00  4.09           H  
ATOM   1135 HD23 LEU A 213      19.283  -0.359 -10.126  1.00  3.95           H  
ATOM   1136  N   LEU A 214      15.525  -1.286  -9.489  1.00  1.68           N  
ATOM   1137  CA  LEU A 214      14.506  -2.292  -9.768  1.00  2.24           C  
ATOM   1138  C   LEU A 214      14.650  -3.489  -8.835  1.00  1.83           C  
ATOM   1139  O   LEU A 214      15.706  -3.701  -8.238  1.00  2.05           O  
ATOM   1140  CB  LEU A 214      14.599  -2.751 -11.225  1.00  3.20           C  
ATOM   1141  CG  LEU A 214      14.691  -1.625 -12.256  1.00  4.22           C  
ATOM   1142  CD1 LEU A 214      14.987  -2.190 -13.637  1.00  5.11           C  
ATOM   1143  CD2 LEU A 214      13.405  -0.814 -12.274  1.00  4.85           C  
ATOM   1144  H   LEU A 214      16.350  -1.283 -10.018  1.00  1.81           H  
ATOM   1145  HA  LEU A 214      13.540  -1.838  -9.604  1.00  2.78           H  
ATOM   1146  HB2 LEU A 214      15.472  -3.379 -11.327  1.00  3.24           H  
ATOM   1147  HB3 LEU A 214      13.724  -3.343 -11.449  1.00  3.52           H  
ATOM   1148  HG  LEU A 214      15.501  -0.964 -11.985  1.00  4.28           H  
ATOM   1149 HD11 LEU A 214      15.845  -2.844 -13.582  1.00  5.46           H  
ATOM   1150 HD12 LEU A 214      15.196  -1.379 -14.319  1.00  5.36           H  
ATOM   1151 HD13 LEU A 214      14.132  -2.747 -13.990  1.00  5.51           H  
ATOM   1152 HD21 LEU A 214      13.480  -0.037 -13.019  1.00  5.29           H  
ATOM   1153 HD22 LEU A 214      13.246  -0.368 -11.303  1.00  5.12           H  
ATOM   1154 HD23 LEU A 214      12.574  -1.461 -12.513  1.00  5.03           H  
ATOM   1155  N   ASP A 215      13.580  -4.270  -8.714  1.00  1.93           N  
ATOM   1156  CA  ASP A 215      13.582  -5.449  -7.853  1.00  1.64           C  
ATOM   1157  C   ASP A 215      13.851  -5.066  -6.401  1.00  1.62           C  
ATOM   1158  O   ASP A 215      14.253  -3.939  -6.110  1.00  2.38           O  
ATOM   1159  CB  ASP A 215      14.633  -6.454  -8.329  1.00  1.83           C  
ATOM   1160  CG  ASP A 215      14.375  -6.933  -9.745  1.00  1.63           C  
ATOM   1161  OD1 ASP A 215      14.295  -6.081 -10.655  1.00  2.20           O  
ATOM   1162  OD2 ASP A 215      14.254  -8.160  -9.944  1.00  1.74           O  
ATOM   1163  H   ASP A 215      12.767  -4.048  -9.215  1.00  2.53           H  
ATOM   1164  HA  ASP A 215      12.606  -5.906  -7.916  1.00  1.77           H  
ATOM   1165  HB2 ASP A 215      15.607  -5.990  -8.298  1.00  1.98           H  
ATOM   1166  HB3 ASP A 215      14.625  -7.311  -7.671  1.00  2.21           H  
ATOM   1167  N   ASP A 216      13.628  -6.012  -5.494  1.00  1.54           N  
ATOM   1168  CA  ASP A 216      13.845  -5.779  -4.070  1.00  1.77           C  
ATOM   1169  C   ASP A 216      12.956  -4.647  -3.560  1.00  1.53           C  
ATOM   1170  O   ASP A 216      11.908  -4.891  -2.962  1.00  1.70           O  
ATOM   1171  CB  ASP A 216      15.316  -5.450  -3.803  1.00  2.53           C  
ATOM   1172  CG  ASP A 216      16.209  -6.670  -3.909  1.00  2.61           C  
ATOM   1173  OD1 ASP A 216      15.926  -7.674  -3.221  1.00  3.12           O  
ATOM   1174  OD2 ASP A 216      17.190  -6.624  -4.680  1.00  2.84           O  
ATOM   1175  H   ASP A 216      13.308  -6.890  -5.789  1.00  1.91           H  
ATOM   1176  HA  ASP A 216      13.588  -6.686  -3.545  1.00  1.92           H  
ATOM   1177  HB2 ASP A 216      15.652  -4.719  -4.524  1.00  3.09           H  
ATOM   1178  HB3 ASP A 216      15.412  -5.041  -2.809  1.00  2.83           H  
ATOM   1179  N   LEU A 217      13.383  -3.411  -3.799  1.00  1.55           N  
ATOM   1180  CA  LEU A 217      12.625  -2.243  -3.363  1.00  1.74           C  
ATOM   1181  C   LEU A 217      12.020  -1.510  -4.556  1.00  1.76           C  
ATOM   1182  O   LEU A 217      12.472  -0.426  -4.927  1.00  2.18           O  
ATOM   1183  CB  LEU A 217      13.523  -1.293  -2.566  1.00  2.16           C  
ATOM   1184  CG  LEU A 217      15.005  -1.330  -2.942  1.00  2.99           C  
ATOM   1185  CD1 LEU A 217      15.211  -0.806  -4.355  1.00  3.78           C  
ATOM   1186  CD2 LEU A 217      15.827  -0.523  -1.948  1.00  3.33           C  
ATOM   1187  H   LEU A 217      14.226  -3.281  -4.281  1.00  1.70           H  
ATOM   1188  HA  LEU A 217      11.825  -2.587  -2.724  1.00  1.87           H  
ATOM   1189  HB2 LEU A 217      13.162  -0.285  -2.709  1.00  2.50           H  
ATOM   1190  HB3 LEU A 217      13.435  -1.542  -1.518  1.00  2.16           H  
ATOM   1191  HG  LEU A 217      15.353  -2.352  -2.912  1.00  3.30           H  
ATOM   1192 HD11 LEU A 217      14.867   0.216  -4.413  1.00  3.99           H  
ATOM   1193 HD12 LEU A 217      14.651  -1.414  -5.049  1.00  4.12           H  
ATOM   1194 HD13 LEU A 217      16.261  -0.847  -4.605  1.00  4.24           H  
ATOM   1195 HD21 LEU A 217      16.876  -0.729  -2.096  1.00  3.05           H  
ATOM   1196 HD22 LEU A 217      15.545  -0.798  -0.942  1.00  3.82           H  
ATOM   1197 HD23 LEU A 217      15.641   0.530  -2.098  1.00  3.89           H  
ATOM   1198  N   ALA A 218      10.993  -2.107  -5.154  1.00  1.74           N  
ATOM   1199  CA  ALA A 218      10.325  -1.510  -6.304  1.00  1.90           C  
ATOM   1200  C   ALA A 218       8.979  -2.177  -6.566  1.00  1.95           C  
ATOM   1201  O   ALA A 218       7.927  -1.613  -6.264  1.00  2.36           O  
ATOM   1202  CB  ALA A 218      11.213  -1.604  -7.536  1.00  2.03           C  
ATOM   1203  H   ALA A 218      10.676  -2.970  -4.811  1.00  1.90           H  
ATOM   1204  HA  ALA A 218      10.161  -0.465  -6.087  1.00  2.08           H  
ATOM   1205  HB1 ALA A 218      11.598  -2.609  -7.628  1.00  2.45           H  
ATOM   1206  HB2 ALA A 218      12.035  -0.910  -7.441  1.00  2.30           H  
ATOM   1207  HB3 ALA A 218      10.635  -1.359  -8.415  1.00  2.21           H  
ATOM   1208  N   HIS A 219       9.019  -3.381  -7.130  1.00  1.89           N  
ATOM   1209  CA  HIS A 219       7.801  -4.125  -7.432  1.00  2.08           C  
ATOM   1210  C   HIS A 219       7.744  -5.422  -6.632  1.00  1.82           C  
ATOM   1211  O   HIS A 219       8.756  -5.881  -6.103  1.00  1.76           O  
ATOM   1212  CB  HIS A 219       7.726  -4.433  -8.929  1.00  2.52           C  
ATOM   1213  CG  HIS A 219       7.079  -3.348  -9.733  1.00  2.88           C  
ATOM   1214  ND1 HIS A 219       7.013  -2.036  -9.313  1.00  3.29           N  
ATOM   1215  CD2 HIS A 219       6.468  -3.385 -10.940  1.00  3.43           C  
ATOM   1216  CE1 HIS A 219       6.387  -1.313 -10.225  1.00  3.73           C  
ATOM   1217  NE2 HIS A 219       6.047  -2.108 -11.223  1.00  3.86           N  
ATOM   1218  H   HIS A 219       9.888  -3.778  -7.347  1.00  1.96           H  
ATOM   1219  HA  HIS A 219       6.959  -3.509  -7.158  1.00  2.36           H  
ATOM   1220  HB2 HIS A 219       8.726  -4.577  -9.311  1.00  2.55           H  
ATOM   1221  HB3 HIS A 219       7.157  -5.339  -9.074  1.00  2.88           H  
ATOM   1222  HD1 HIS A 219       7.371  -1.686  -8.470  1.00  3.56           H  
ATOM   1223  HD2 HIS A 219       6.334  -4.257 -11.566  1.00  3.81           H  
ATOM   1224  HE1 HIS A 219       6.190  -0.253 -10.166  1.00  4.21           H  
ATOM   1225  HE2 HIS A 219       5.648  -1.814 -12.068  1.00  4.45           H  
ATOM   1226  N   THR A 220       6.553  -6.008  -6.546  1.00  2.31           N  
ATOM   1227  CA  THR A 220       6.364  -7.253  -5.810  1.00  2.30           C  
ATOM   1228  C   THR A 220       6.919  -7.137  -4.392  1.00  1.60           C  
ATOM   1229  O   THR A 220       6.810  -6.088  -3.758  1.00  2.19           O  
ATOM   1230  CB  THR A 220       7.033  -8.414  -6.550  1.00  3.06           C  
ATOM   1231  OG1 THR A 220       8.441  -8.364  -6.395  1.00  3.65           O  
ATOM   1232  CG2 THR A 220       6.736  -8.430  -8.034  1.00  4.07           C  
ATOM   1233  H   THR A 220       5.784  -5.593  -6.989  1.00  2.92           H  
ATOM   1234  HA  THR A 220       5.302  -7.442  -5.752  1.00  2.79           H  
ATOM   1235  HB  THR A 220       6.679  -9.345  -6.133  1.00  3.06           H  
ATOM   1236  HG1 THR A 220       8.801  -7.669  -6.951  1.00  3.97           H  
ATOM   1237 HG21 THR A 220       5.672  -8.327  -8.189  1.00  4.43           H  
ATOM   1238 HG22 THR A 220       7.073  -9.363  -8.459  1.00  4.38           H  
ATOM   1239 HG23 THR A 220       7.249  -7.609  -8.513  1.00  4.55           H  
ATOM   1240  N   ILE A 221       7.515  -8.220  -3.897  1.00  1.30           N  
ATOM   1241  CA  ILE A 221       8.086  -8.235  -2.555  1.00  1.43           C  
ATOM   1242  C   ILE A 221       7.000  -8.071  -1.495  1.00  1.38           C  
ATOM   1243  O   ILE A 221       6.040  -7.324  -1.685  1.00  1.78           O  
ATOM   1244  CB  ILE A 221       9.140  -7.121  -2.381  1.00  2.35           C  
ATOM   1245  CG1 ILE A 221      10.483  -7.566  -2.963  1.00  3.31           C  
ATOM   1246  CG2 ILE A 221       9.291  -6.749  -0.913  1.00  2.89           C  
ATOM   1247  CD1 ILE A 221      10.700  -7.122  -4.393  1.00  4.04           C  
ATOM   1248  H   ILE A 221       7.573  -9.028  -4.447  1.00  1.84           H  
ATOM   1249  HA  ILE A 221       8.573  -9.187  -2.411  1.00  1.92           H  
ATOM   1250  HB  ILE A 221       8.797  -6.248  -2.914  1.00  2.71           H  
ATOM   1251 HG12 ILE A 221      11.281  -7.155  -2.365  1.00  3.74           H  
ATOM   1252 HG13 ILE A 221      10.539  -8.645  -2.938  1.00  3.61           H  
ATOM   1253 HG21 ILE A 221       9.306  -7.648  -0.314  1.00  3.11           H  
ATOM   1254 HG22 ILE A 221       8.460  -6.129  -0.610  1.00  3.21           H  
ATOM   1255 HG23 ILE A 221      10.214  -6.207  -0.771  1.00  3.42           H  
ATOM   1256 HD11 ILE A 221      10.015  -7.648  -5.042  1.00  4.25           H  
ATOM   1257 HD12 ILE A 221      11.715  -7.341  -4.687  1.00  4.48           H  
ATOM   1258 HD13 ILE A 221      10.523  -6.059  -4.471  1.00  4.35           H  
ATOM   1259  N   ARG A 222       7.160  -8.775  -0.379  1.00  1.36           N  
ATOM   1260  CA  ARG A 222       6.194  -8.709   0.713  1.00  1.63           C  
ATOM   1261  C   ARG A 222       6.531  -7.570   1.671  1.00  1.46           C  
ATOM   1262  O   ARG A 222       7.702  -7.278   1.916  1.00  1.56           O  
ATOM   1263  CB  ARG A 222       6.162 -10.037   1.473  1.00  2.19           C  
ATOM   1264  CG  ARG A 222       5.997 -11.250   0.573  1.00  2.56           C  
ATOM   1265  CD  ARG A 222       5.508 -12.461   1.354  1.00  2.84           C  
ATOM   1266  NE  ARG A 222       6.322 -13.645   1.095  1.00  3.62           N  
ATOM   1267  CZ  ARG A 222       6.261 -14.351  -0.030  1.00  4.30           C  
ATOM   1268  NH1 ARG A 222       5.429 -13.991  -0.999  1.00  4.99           N  
ATOM   1269  NH2 ARG A 222       7.034 -15.417  -0.187  1.00  4.63           N  
ATOM   1270  H   ARG A 222       7.946  -9.353  -0.286  1.00  1.50           H  
ATOM   1271  HA  ARG A 222       5.221  -8.527   0.283  1.00  1.82           H  
ATOM   1272  HB2 ARG A 222       7.085 -10.145   2.024  1.00  2.44           H  
ATOM   1273  HB3 ARG A 222       5.338 -10.017   2.171  1.00  2.61           H  
ATOM   1274  HG2 ARG A 222       5.280 -11.019  -0.199  1.00  3.10           H  
ATOM   1275  HG3 ARG A 222       6.951 -11.485   0.124  1.00  2.77           H  
ATOM   1276  HD2 ARG A 222       5.546 -12.233   2.409  1.00  2.89           H  
ATOM   1277  HD3 ARG A 222       4.487 -12.667   1.069  1.00  3.01           H  
ATOM   1278  HE  ARG A 222       6.945 -13.929   1.796  1.00  3.96           H  
ATOM   1279 HH11 ARG A 222       4.846 -13.188  -0.884  1.00  4.96           H  
ATOM   1280 HH12 ARG A 222       5.386 -14.525  -1.844  1.00  5.70           H  
ATOM   1281 HH21 ARG A 222       7.663 -15.691   0.540  1.00  4.36           H  
ATOM   1282 HH22 ARG A 222       6.987 -15.948  -1.034  1.00  5.33           H  
ATOM   1283  N   ILE A 223       5.496  -6.931   2.209  1.00  1.34           N  
ATOM   1284  CA  ILE A 223       5.683  -5.824   3.141  1.00  1.20           C  
ATOM   1285  C   ILE A 223       4.545  -5.763   4.155  1.00  1.26           C  
ATOM   1286  O   ILE A 223       3.447  -5.304   3.844  1.00  1.55           O  
ATOM   1287  CB  ILE A 223       5.770  -4.474   2.402  1.00  1.18           C  
ATOM   1288  CG1 ILE A 223       4.638  -4.351   1.379  1.00  1.44           C  
ATOM   1289  CG2 ILE A 223       7.124  -4.328   1.723  1.00  1.12           C  
ATOM   1290  CD1 ILE A 223       4.035  -2.966   1.308  1.00  1.52           C  
ATOM   1291  H   ILE A 223       4.588  -7.211   1.975  1.00  1.45           H  
ATOM   1292  HA  ILE A 223       6.613  -5.984   3.666  1.00  1.15           H  
ATOM   1293  HB  ILE A 223       5.673  -3.685   3.131  1.00  1.24           H  
ATOM   1294 HG12 ILE A 223       5.020  -4.597   0.399  1.00  1.65           H  
ATOM   1295 HG13 ILE A 223       3.851  -5.045   1.638  1.00  1.79           H  
ATOM   1296 HG21 ILE A 223       7.210  -3.338   1.302  1.00  1.16           H  
ATOM   1297 HG22 ILE A 223       7.213  -5.063   0.938  1.00  1.89           H  
ATOM   1298 HG23 ILE A 223       7.908  -4.480   2.450  1.00  1.41           H  
ATOM   1299 HD11 ILE A 223       3.832  -2.610   2.308  1.00  1.49           H  
ATOM   1300 HD12 ILE A 223       3.114  -3.003   0.746  1.00  1.98           H  
ATOM   1301 HD13 ILE A 223       4.727  -2.296   0.821  1.00  2.10           H  
ATOM   1302  N   GLU A 224       4.817  -6.232   5.369  1.00  1.20           N  
ATOM   1303  CA  GLU A 224       3.816  -6.232   6.431  1.00  1.26           C  
ATOM   1304  C   GLU A 224       4.094  -5.120   7.440  1.00  1.29           C  
ATOM   1305  O   GLU A 224       4.879  -4.210   7.175  1.00  1.22           O  
ATOM   1306  CB  GLU A 224       3.796  -7.589   7.140  1.00  1.38           C  
ATOM   1307  CG  GLU A 224       2.396  -8.136   7.365  1.00  1.78           C  
ATOM   1308  CD  GLU A 224       2.369  -9.265   8.377  1.00  2.05           C  
ATOM   1309  OE1 GLU A 224       3.132 -10.238   8.203  1.00  2.27           O  
ATOM   1310  OE2 GLU A 224       1.583  -9.176   9.344  1.00  2.59           O  
ATOM   1311  H   GLU A 224       5.712  -6.586   5.556  1.00  1.26           H  
ATOM   1312  HA  GLU A 224       2.853  -6.058   5.978  1.00  1.39           H  
ATOM   1313  HB2 GLU A 224       4.346  -8.301   6.543  1.00  1.54           H  
ATOM   1314  HB3 GLU A 224       4.280  -7.488   8.100  1.00  1.50           H  
ATOM   1315  HG2 GLU A 224       1.765  -7.337   7.723  1.00  1.99           H  
ATOM   1316  HG3 GLU A 224       2.012  -8.505   6.425  1.00  2.06           H  
ATOM   1317  N   GLU A 225       3.443  -5.201   8.597  1.00  1.94           N  
ATOM   1318  CA  GLU A 225       3.618  -4.202   9.646  1.00  2.33           C  
ATOM   1319  C   GLU A 225       3.035  -2.857   9.220  1.00  1.59           C  
ATOM   1320  O   GLU A 225       2.321  -2.768   8.222  1.00  1.88           O  
ATOM   1321  CB  GLU A 225       5.101  -4.046   9.989  1.00  3.41           C  
ATOM   1322  CG  GLU A 225       5.395  -4.141  11.477  1.00  4.30           C  
ATOM   1323  CD  GLU A 225       6.482  -3.182  11.921  1.00  4.56           C  
ATOM   1324  OE1 GLU A 225       7.407  -2.922  11.123  1.00  4.91           O  
ATOM   1325  OE2 GLU A 225       6.408  -2.690  13.067  1.00  4.77           O  
ATOM   1326  H   GLU A 225       2.829  -5.950   8.749  1.00  2.36           H  
ATOM   1327  HA  GLU A 225       3.090  -4.547  10.522  1.00  2.87           H  
ATOM   1328  HB2 GLU A 225       5.659  -4.820   9.483  1.00  3.55           H  
ATOM   1329  HB3 GLU A 225       5.441  -3.081   9.639  1.00  3.87           H  
ATOM   1330  HG2 GLU A 225       4.492  -3.917  12.025  1.00  4.67           H  
ATOM   1331  HG3 GLU A 225       5.711  -5.150  11.704  1.00  4.73           H  
ATOM   1332  N   LEU A 226       3.346  -1.814   9.984  1.00  1.53           N  
ATOM   1333  CA  LEU A 226       2.853  -0.473   9.686  1.00  1.36           C  
ATOM   1334  C   LEU A 226       3.179  -0.078   8.249  1.00  2.06           C  
ATOM   1335  O   LEU A 226       2.603   0.921   7.767  1.00  2.74           O  
ATOM   1336  CB  LEU A 226       3.458   0.543  10.658  1.00  1.49           C  
ATOM   1337  CG  LEU A 226       4.900   0.956  10.354  1.00  1.23           C  
ATOM   1338  CD1 LEU A 226       5.387   1.980  11.367  1.00  1.91           C  
ATOM   1339  CD2 LEU A 226       5.812  -0.262  10.343  1.00  1.37           C  
ATOM   1340  OXT LEU A 226       4.006  -0.768   7.618  1.00  2.56           O  
ATOM   1341  H   LEU A 226       3.919  -1.949  10.767  1.00  2.16           H  
ATOM   1342  HA  LEU A 226       1.780  -0.481   9.810  1.00  1.72           H  
ATOM   1343  HB2 LEU A 226       2.841   1.430  10.647  1.00  2.10           H  
ATOM   1344  HB3 LEU A 226       3.431   0.120  11.652  1.00  2.09           H  
ATOM   1345  HG  LEU A 226       4.937   1.412   9.375  1.00  1.57           H  
ATOM   1346 HD11 LEU A 226       6.382   2.304  11.101  1.00  2.29           H  
ATOM   1347 HD12 LEU A 226       5.405   1.534  12.350  1.00  2.34           H  
ATOM   1348 HD13 LEU A 226       4.720   2.830  11.370  1.00  2.38           H  
ATOM   1349 HD21 LEU A 226       6.841   0.060  10.291  1.00  1.90           H  
ATOM   1350 HD22 LEU A 226       5.582  -0.875   9.484  1.00  1.80           H  
ATOM   1351 HD23 LEU A 226       5.658  -0.835  11.246  1.00  1.74           H  
TER    1352      LEU A 226                                                      
END
MOLECULE T0462_1_74.pdb
ATOM      1  C   MET     1       3.518  -5.525  -1.015  1.00 72.54           C 
ATOM      2  O   MET     1       4.514  -5.922  -0.421  1.00 61.43           O 
ATOM      3  N   MET     1       1.797  -7.249  -0.416  1.00 62.03           N 
ATOM      4  CA  MET     1       2.106  -5.791  -0.468  1.00  1.42           C 
ATOM      5  CB  MET     1       1.945  -5.166   0.931  1.00  3.15           C 
ATOM      6  CG  MET     1       2.652  -3.826   1.103  1.00 20.23           C 
ATOM      7  SD  MET     1       2.005  -2.537   0.021  1.00  4.24           S 
ATOM      8  CE  MET     1       0.587  -1.980   0.962  1.00 12.22           C 
ATOM      9 1H   MET     1       2.447  -7.731   0.242  1.00 36.29           H 
ATOM     10 2H   MET     1       1.909  -7.674  -1.357  1.00 36.29           H 
ATOM     11 3H   MET     1       0.818  -7.396  -0.095  1.00 36.29           H 
ATOM     12  HA  MET     1       1.390  -5.330  -1.136  1.00  4.22           H 
ATOM     13 3HB  MET     1       2.337  -5.854   1.668  1.00 36.29           H 
ATOM     14 2HB  MET     1       0.892  -5.015   1.123  1.00 36.29           H 
ATOM     15 3HG  MET     1       3.702  -3.962   0.888  1.00 36.29           H 
ATOM     16 2HG  MET     1       2.538  -3.502   2.127  1.00 36.29           H 
ATOM     17 1HE  MET     1      -0.112  -2.794   1.079  1.00 36.29           H 
ATOM     18 2HE  MET     1       0.108  -1.165   0.439  1.00 36.29           H 
ATOM     19 3HE  MET     1       0.911  -1.640   1.935  1.00 36.29           H 
ATOM     20  N   LYS     2       3.591  -4.846  -2.158  1.00  4.01           N 
ATOM     21  CA  LYS     2       4.874  -4.436  -2.746  1.00 14.04           C 
ATOM     22  C   LYS     2       5.042  -2.911  -2.669  1.00 71.54           C 
ATOM     23  O   LYS     2       4.069  -2.166  -2.787  1.00  5.03           O 
ATOM     24  CB  LYS     2       4.982  -4.912  -4.207  1.00 41.30           C 
ATOM     25  CG  LYS     2       5.651  -6.277  -4.378  1.00 35.55           C 
ATOM     26  CD  LYS     2       4.888  -7.412  -3.703  1.00 24.21           C 
ATOM     27  CE  LYS     2       5.601  -8.746  -3.913  1.00 54.20           C 
ATOM     28  NZ  LYS     2       4.888  -9.880  -3.264  1.00 23.11           N 
ATOM     29  H   LYS     2       2.763  -4.602  -2.617  1.00 36.29           H 
ATOM     30  HA  LYS     2       5.666  -4.897  -2.168  1.00 52.45           H 
ATOM     31 3HB  LYS     2       5.556  -4.188  -4.770  1.00 36.29           H 
ATOM     32 2HB  LYS     2       3.989  -4.969  -4.631  1.00 36.29           H 
ATOM     33 3HG  LYS     2       6.647  -6.227  -3.957  1.00 36.29           H 
ATOM     34 2HG  LYS     2       5.724  -6.494  -5.433  1.00 36.29           H 
ATOM     35 3HD  LYS     2       3.895  -7.473  -4.126  1.00 36.29           H 
ATOM     36 2HD  LYS     2       4.822  -7.212  -2.644  1.00 36.29           H 
ATOM     37 3HE  LYS     2       6.597  -8.675  -3.499  1.00 36.29           H 
ATOM     38 2HE  LYS     2       5.669  -8.940  -4.973  1.00 36.29           H 
ATOM     39 1HZ  LYS     2       4.773  -9.696  -2.246  1.00 36.29           H 
ATOM     40 2HZ  LYS     2       5.434 -10.759  -3.385  1.00 36.29           H 
ATOM     41 3HZ  LYS     2       3.951 -10.007  -3.690  1.00 36.29           H 
ATOM     42  N   LEU     3       6.279  -2.445  -2.492  1.00 54.05           N 
ATOM     43  CA  LEU     3       6.551  -1.006  -2.322  1.00 12.34           C 
ATOM     44  C   LEU     3       6.221  -0.190  -3.591  1.00 75.43           C 
ATOM     45  O   LEU     3       6.193   1.039  -3.556  1.00 30.52           O 
ATOM     46  CB  LEU     3       8.016  -0.794  -1.890  1.00 44.12           C 
ATOM     47  CG  LEU     3       9.093  -1.161  -2.934  1.00 51.02           C 
ATOM     48  CD1 LEU     3       9.466   0.048  -3.795  1.00 31.15           C 
ATOM     49  CD2 LEU     3      10.332  -1.742  -2.258  1.00 12.10           C 
ATOM     50  H   LEU     3       7.028  -3.081  -2.468  1.00 36.29           H 
ATOM     51  HA  LEU     3       5.909  -0.654  -1.524  1.00 75.20           H 
ATOM     52 3HB  LEU     3       8.188  -1.389  -1.004  1.00 36.29           H 
ATOM     53 2HB  LEU     3       8.140   0.246  -1.624  1.00 36.29           H 
ATOM     54  HG  LEU     3       8.695  -1.919  -3.597  1.00 53.15           H 
ATOM     55 1HD1 LEU     3       9.859   0.832  -3.164  1.00 36.29           H 
ATOM     56 2HD1 LEU     3       8.590   0.408  -4.313  1.00 36.29           H 
ATOM     57 3HD1 LEU     3      10.216  -0.241  -4.517  1.00 36.29           H 
ATOM     58 1HD2 LEU     3      11.058  -2.020  -3.009  1.00 36.29           H 
ATOM     59 2HD2 LEU     3      10.056  -2.616  -1.686  1.00 36.29           H 
ATOM     60 3HD2 LEU     3      10.765  -1.004  -1.598  1.00 36.29           H 
ATOM     61  N   SER     4       5.945  -0.883  -4.701  1.00  4.23           N 
ATOM     62  CA  SER     4       5.589  -0.227  -5.974  1.00 32.21           C 
ATOM     63  C   SER     4       4.229   0.480  -5.900  1.00 20.35           C 
ATOM     64  O   SER     4       3.854   1.213  -6.814  1.00 13.44           O 
ATOM     65  CB  SER     4       5.543  -1.258  -7.115  1.00 23.31           C 
ATOM     66  OG  SER     4       4.601  -2.291  -6.849  1.00 33.45           O 
ATOM     67  H   SER     4       5.981  -1.860  -4.667  1.00 36.29           H 
ATOM     68  HA  SER     4       6.351   0.505  -6.197  1.00  2.13           H 
ATOM     69 3HB  SER     4       6.518  -1.702  -7.235  1.00 36.29           H 
ATOM     70 2HB  SER     4       5.263  -0.764  -8.033  1.00 36.29           H 
ATOM     71  HG  SER     4       4.753  -3.024  -7.464  1.00 23.50           H 
ATOM     72  N   ARG     5       3.493   0.245  -4.816  1.00 74.24           N 
ATOM     73  CA  ARG     5       2.136   0.783  -4.660  1.00 65.23           C 
ATOM     74  C   ARG     5       1.911   1.351  -3.250  1.00 50.53           C 
ATOM     75  O   ARG     5       0.779   1.617  -2.853  1.00  3.14           O 
ATOM     76  CB  ARG     5       1.136  -0.345  -4.937  1.00 32.44           C 
ATOM     77  CG  ARG     5       1.216  -1.485  -3.918  1.00 60.24           C 
ATOM     78  CD  ARG     5       0.735  -2.805  -4.499  1.00 44.11           C 
ATOM     79  NE  ARG     5       1.633  -3.289  -5.550  1.00 13.55           N 
ATOM     80  CZ  ARG     5       1.739  -4.539  -5.905  1.00 12.44           C 
ATOM     81  NH1 ARG     5       0.990  -5.444  -5.364  1.00 63.34           N 
ATOM     82  NH2 ARG     5       2.586  -4.888  -6.812  1.00 21.53           N 
ATOM     83  H   ARG     5       3.864  -0.317  -4.107  1.00 36.29           H 
ATOM     84  HA  ARG     5       1.992   1.572  -5.386  1.00 64.21           H 
ATOM     85 3HB  ARG     5       1.332  -0.751  -5.919  1.00 36.29           H 
ATOM     86 2HB  ARG     5       0.133   0.062  -4.919  1.00 36.29           H 
ATOM     87 3HG  ARG     5       0.606  -1.234  -3.062  1.00 36.29           H 
ATOM     88 2HG  ARG     5       2.244  -1.601  -3.602  1.00 36.29           H 
ATOM     89 3HD  ARG     5      -0.252  -2.667  -4.916  1.00 36.29           H 
ATOM     90 2HD  ARG     5       0.692  -3.538  -3.704  1.00 36.29           H 
ATOM     91  HE  ARG     5       2.201  -2.632  -5.999  1.00 75.30           H 
ATOM     92 1HH1 ARG     5       0.323  -5.193  -4.674  1.00 36.29           H 
ATOM     93 2HH1 ARG     5       1.098  -6.403  -5.639  1.00 36.29           H 
ATOM     94 1HH2 ARG     5       3.168  -4.207  -7.248  1.00 36.29           H 
ATOM     95 2HH2 ARG     5       2.657  -5.850  -7.075  1.00 36.29           H 
ATOM     96  N   LEU     6       2.994   1.542  -2.504  1.00 24.41           N 
ATOM     97  CA  LEU     6       2.903   1.977  -1.106  1.00 73.40           C 
ATOM     98  C   LEU     6       2.620   3.487  -1.005  1.00 51.45           C 
ATOM     99  O   LEU     6       3.285   4.299  -1.650  1.00 72.11           O 
ATOM    100  CB  LEU     6       4.204   1.628  -0.365  1.00 50.13           C 
ATOM    101  CG  LEU     6       4.178   1.842   1.158  1.00 51.54           C 
ATOM    102  CD1 LEU     6       3.193   0.885   1.826  1.00 34.05           C 
ATOM    103  CD2 LEU     6       5.578   1.679   1.747  1.00 44.04           C 
ATOM    104  H   LEU     6       3.878   1.408  -2.906  1.00 36.29           H 
ATOM    105  HA  LEU     6       2.084   1.437  -0.646  1.00 14.43           H 
ATOM    106 3HB  LEU     6       5.001   2.232  -0.778  1.00 36.29           H 
ATOM    107 2HB  LEU     6       4.434   0.589  -0.557  1.00 36.29           H 
ATOM    108  HG  LEU     6       3.846   2.847   1.364  1.00 12.14           H 
ATOM    109 1HD1 LEU     6       3.477  -0.136   1.615  1.00 36.29           H 
ATOM    110 2HD1 LEU     6       2.198   1.068   1.446  1.00 36.29           H 
ATOM    111 3HD1 LEU     6       3.202   1.047   2.895  1.00 36.29           H 
ATOM    112 1HD2 LEU     6       6.248   2.391   1.286  1.00 36.29           H 
ATOM    113 2HD2 LEU     6       5.935   0.676   1.561  1.00 36.29           H 
ATOM    114 3HD2 LEU     6       5.545   1.855   2.812  1.00 36.29           H 
ATOM    115  N   VAL     7       1.629   3.852  -0.188  1.00 44.11           N 
ATOM    116  CA  VAL     7       1.229   5.255  -0.013  1.00 52.30           C 
ATOM    117  C   VAL     7       2.399   6.130   0.495  1.00 41.41           C 
ATOM    118  O   VAL     7       2.938   5.888   1.576  1.00 15.11           O 
ATOM    119  CB  VAL     7       0.034   5.378   0.975  1.00 14.11           C 
ATOM    120  CG1 VAL     7      -0.397   6.838   1.141  1.00 51.14           C 
ATOM    121  CG2 VAL     7      -1.143   4.512   0.514  1.00 52.40           C 
ATOM    122  H   VAL     7       1.148   3.158   0.308  1.00 36.29           H 
ATOM    123  HA  VAL     7       0.906   5.628  -0.977  1.00 34.04           H 
ATOM    124  HB  VAL     7       0.357   5.016   1.940  1.00 41.14           H 
ATOM    125 1HG1 VAL     7       0.428   7.416   1.532  1.00 36.29           H 
ATOM    126 2HG1 VAL     7      -1.230   6.895   1.828  1.00 36.29           H 
ATOM    127 3HG1 VAL     7      -0.695   7.239   0.183  1.00 36.29           H 
ATOM    128 1HG2 VAL     7      -1.458   4.821  -0.472  1.00 36.29           H 
ATOM    129 2HG2 VAL     7      -1.969   4.620   1.205  1.00 36.29           H 
ATOM    130 3HG2 VAL     7      -0.837   3.475   0.483  1.00 36.29           H 
ATOM    131  N   PRO     8       2.802   7.162  -0.282  1.00 23.31           N 
ATOM    132  CA  PRO     8       3.902   8.073   0.102  1.00 61.14           C 
ATOM    133  C   PRO     8       3.752   8.648   1.526  1.00 24.12           C 
ATOM    134  O   PRO     8       2.852   9.448   1.798  1.00 15.04           O 
ATOM    135  CB  PRO     8       3.814   9.190  -0.945  1.00 34.35           C 
ATOM    136  CG  PRO     8       3.204   8.534  -2.139  1.00 22.30           C 
ATOM    137  CD  PRO     8       2.231   7.517  -1.600  1.00  0.40           C 
ATOM    138  HA  PRO     8       4.861   7.578   0.020  1.00 12.00           H 
ATOM    139 3HB  PRO     8       4.805   9.565  -1.163  1.00 36.29           H 
ATOM    140 2HB  PRO     8       3.192   9.995  -0.574  1.00 36.29           H 
ATOM    141 3HG  PRO     8       3.972   8.047  -2.723  1.00 36.29           H 
ATOM    142 2HG  PRO     8       2.688   9.271  -2.741  1.00 36.29           H 
ATOM    143 3HD  PRO     8       2.188   6.653  -2.248  1.00 36.29           H 
ATOM    144 2HD  PRO     8       1.247   7.955  -1.487  1.00 36.29           H 
ATOM    145  N   GLY     9       4.646   8.240   2.428  1.00 12.24           N 
ATOM    146  CA  GLY     9       4.576   8.671   3.823  1.00 71.12           C 
ATOM    147  C   GLY     9       4.364   7.512   4.795  1.00 14.14           C 
ATOM    148  O   GLY     9       4.726   7.604   5.970  1.00 53.41           O 
ATOM    149  H   GLY     9       5.370   7.646   2.142  1.00 36.29           H 
ATOM    150 3HA  GLY     9       3.761   9.374   3.939  1.00 36.29           H 
ATOM    151 2HA  GLY     9       5.501   9.170   4.077  1.00 36.29           H 
ATOM    152  N   VAL    10       3.778   6.423   4.305  1.00 64.52           N 
ATOM    153  CA  VAL    10       3.529   5.234   5.129  1.00 45.04           C 
ATOM    154  C   VAL    10       4.758   4.303   5.157  1.00 22.22           C 
ATOM    155  O   VAL    10       5.238   3.867   4.110  1.00 13.40           O 
ATOM    156  CB  VAL    10       2.297   4.444   4.613  1.00 32.21           C 
ATOM    157  CG1 VAL    10       2.049   3.193   5.455  1.00 62.22           C 
ATOM    158  CG2 VAL    10       1.055   5.336   4.592  1.00 12.32           C 
ATOM    159  H   VAL    10       3.505   6.412   3.362  1.00 36.29           H 
ATOM    160  HA  VAL    10       3.317   5.568   6.137  1.00 21.15           H 
ATOM    161  HB  VAL    10       2.500   4.129   3.598  1.00 63.25           H 
ATOM    162 1HG1 VAL    10       2.906   2.536   5.390  1.00 36.29           H 
ATOM    163 2HG1 VAL    10       1.175   2.678   5.086  1.00 36.29           H 
ATOM    164 3HG1 VAL    10       1.891   3.477   6.486  1.00 36.29           H 
ATOM    165 1HG2 VAL    10       1.226   6.180   3.939  1.00 36.29           H 
ATOM    166 2HG2 VAL    10       0.848   5.693   5.591  1.00 36.29           H 
ATOM    167 3HG2 VAL    10       0.208   4.769   4.231  1.00 36.29           H 
ATOM    168  N   PRO    11       5.292   3.994   6.358  1.00 14.03           N 
ATOM    169  CA  PRO    11       6.452   3.097   6.503  1.00  4.53           C 
ATOM    170  C   PRO    11       6.083   1.603   6.412  1.00 14.25           C 
ATOM    171  O   PRO    11       5.083   1.156   6.985  1.00  4.44           O 
ATOM    172  CB  PRO    11       6.970   3.443   7.903  1.00  4.12           C 
ATOM    173  CG  PRO    11       5.750   3.846   8.664  1.00 24.22           C 
ATOM    174  CD  PRO    11       4.824   4.503   7.666  1.00 63.44           C 
ATOM    175  HA  PRO    11       7.216   3.321   5.770  1.00 72.10           H 
ATOM    176 3HB  PRO    11       7.681   4.255   7.839  1.00 36.29           H 
ATOM    177 2HB  PRO    11       7.448   2.577   8.344  1.00 36.29           H 
ATOM    178 3HG  PRO    11       6.016   4.544   9.446  1.00 36.29           H 
ATOM    179 2HG  PRO    11       5.278   2.971   9.091  1.00 36.29           H 
ATOM    180 3HD  PRO    11       4.918   5.580   7.713  1.00 36.29           H 
ATOM    181 2HD  PRO    11       3.801   4.208   7.848  1.00 36.29           H 
ATOM    182  N   ALA    12       6.901   0.833   5.695  1.00 41.23           N 
ATOM    183  CA  ALA    12       6.690  -0.613   5.558  1.00 13.34           C 
ATOM    184  C   ALA    12       7.997  -1.397   5.764  1.00  4.20           C 
ATOM    185  O   ALA    12       9.063  -0.956   5.350  1.00 53.40           O 
ATOM    186  CB  ALA    12       6.088  -0.931   4.194  1.00 41.20           C 
ATOM    187  H   ALA    12       7.663   1.249   5.235  1.00 36.29           H 
ATOM    188  HA  ALA    12       5.982  -0.919   6.316  1.00 70.54           H 
ATOM    189 1HB  ALA    12       5.158  -0.392   4.074  1.00 36.29           H 
ATOM    190 2HB  ALA    12       5.896  -1.992   4.123  1.00 36.29           H 
ATOM    191 3HB  ALA    12       6.777  -0.637   3.414  1.00 36.29           H 
ATOM    192  N   ARG    13       7.913  -2.563   6.401  1.00 12.42           N 
ATOM    193  CA  ARG    13       9.106  -3.379   6.672  1.00 30.40           C 
ATOM    194  C   ARG    13       9.311  -4.451   5.585  1.00 42.44           C 
ATOM    195  O   ARG    13       8.356  -5.085   5.137  1.00 71.15           O 
ATOM    196  CB  ARG    13       8.995  -4.049   8.052  1.00 72.24           C 
ATOM    197  CG  ARG    13      10.269  -4.777   8.486  1.00 32.23           C 
ATOM    198  CD  ARG    13      10.105  -5.477   9.834  1.00 34.44           C 
ATOM    199  NE  ARG    13       9.133  -6.570   9.779  1.00  2.45           N 
ATOM    200  CZ  ARG    13       9.006  -7.486  10.701  1.00 54.22           C 
ATOM    201  NH1 ARG    13       9.728  -7.455  11.775  1.00 63.05           N 
ATOM    202  NH2 ARG    13       8.138  -8.429  10.548  1.00 72.55           N 
ATOM    203  H   ARG    13       7.037  -2.881   6.699  1.00 36.29           H 
ATOM    204  HA  ARG    13       9.964  -2.722   6.673  1.00 11.40           H 
ATOM    205 3HB  ARG    13       8.186  -4.765   8.031  1.00 36.29           H 
ATOM    206 2HB  ARG    13       8.770  -3.290   8.790  1.00 36.29           H 
ATOM    207 3HG  ARG    13      11.071  -4.056   8.562  1.00 36.29           H 
ATOM    208 2HG  ARG    13      10.522  -5.516   7.739  1.00 36.29           H 
ATOM    209 3HD  ARG    13       9.774  -4.752  10.565  1.00 36.29           H 
ATOM    210 2HD  ARG    13      11.064  -5.876  10.137  1.00 36.29           H 
ATOM    211  HE  ARG    13       8.548  -6.622   8.997  1.00 22.44           H 
ATOM    212 1HH1 ARG    13      10.393  -6.725  11.911  1.00 36.29           H 
ATOM    213 2HH1 ARG    13       9.621  -8.166  12.464  1.00 36.29           H 
ATOM    214 1HH2 ARG    13       7.567  -8.450   9.727  1.00 36.29           H 
ATOM    215 2HH2 ARG    13       8.039  -9.133  11.247  1.00 36.29           H 
ATOM    216  N   ILE    14      10.561  -4.637   5.169  1.00  2.55           N 
ATOM    217  CA  ILE    14      10.908  -5.622   4.137  1.00 71.42           C 
ATOM    218  C   ILE    14      10.714  -7.064   4.644  1.00 32.34           C 
ATOM    219  O   ILE    14      11.498  -7.544   5.470  1.00 73.21           O 
ATOM    220  CB  ILE    14      12.389  -5.463   3.688  1.00  2.42           C 
ATOM    221  CG1 ILE    14      12.711  -4.005   3.309  1.00  2.21           C 
ATOM    222  CG2 ILE    14      12.702  -6.398   2.519  1.00 12.31           C 
ATOM    223  CD1 ILE    14      11.972  -3.496   2.095  1.00 64.15           C 
ATOM    224  H   ILE    14      11.275  -4.094   5.564  1.00 36.29           H 
ATOM    225  HA  ILE    14      10.269  -5.456   3.280  1.00 32.01           H 
ATOM    226  HB  ILE    14      13.020  -5.753   4.517  1.00 63.30           H 
ATOM    227 3HG1 ILE    14      13.770  -3.920   3.110  1.00 36.29           H 
ATOM    228 2HG1 ILE    14      12.456  -3.363   4.137  1.00 36.29           H 
ATOM    229 1HG2 ILE    14      13.728  -6.259   2.211  1.00 36.29           H 
ATOM    230 2HG2 ILE    14      12.045  -6.174   1.692  1.00 36.29           H 
ATOM    231 3HG2 ILE    14      12.555  -7.422   2.829  1.00 36.29           H 
ATOM    232 1HD1 ILE    14      12.188  -4.129   1.247  1.00 36.29           H 
ATOM    233 2HD1 ILE    14      12.290  -2.487   1.880  1.00 36.29           H 
ATOM    234 3HD1 ILE    14      10.910  -3.504   2.288  1.00 36.29           H 
ATOM    235  N   LYS    15       9.680  -7.754   4.151  1.00 65.45           N 
ATOM    236  CA  LYS    15       9.479  -9.174   4.480  1.00  5.15           C 
ATOM    237  C   LYS    15      10.547 -10.041   3.798  1.00  4.03           C 
ATOM    238  O   LYS    15      11.325 -10.733   4.452  1.00 71.41           O 
ATOM    239  CB  LYS    15       8.097  -9.690   4.028  1.00  1.11           C 
ATOM    240  CG  LYS    15       6.882  -9.032   4.682  1.00 65.44           C 
ATOM    241  CD  LYS    15       5.621  -9.866   4.421  1.00 23.12           C 
ATOM    242  CE  LYS    15       4.339  -9.190   4.899  1.00 73.24           C 
ATOM    243  NZ  LYS    15       3.909  -8.093   3.990  1.00 33.12           N 
ATOM    244  H   LYS    15       9.045  -7.304   3.555  1.00 36.29           H 
ATOM    245  HA  LYS    15       9.566  -9.286   5.552  1.00 63.34           H 
ATOM    246 3HB  LYS    15       8.050 -10.753   4.233  1.00 36.29           H 
ATOM    247 2HB  LYS    15       8.012  -9.547   2.960  1.00 36.29           H 
ATOM    248 3HG  LYS    15       6.747  -8.043   4.265  1.00 36.29           H 
ATOM    249 2HG  LYS    15       7.047  -8.962   5.748  1.00 36.29           H 
ATOM    250 3HD  LYS    15       5.723 -10.815   4.931  1.00 36.29           H 
ATOM    251 2HD  LYS    15       5.537 -10.042   3.359  1.00 36.29           H 
ATOM    252 3HE  LYS    15       4.506  -8.783   5.886  1.00 36.29           H 
ATOM    253 2HE  LYS    15       3.552  -9.928   4.946  1.00 36.29           H 
ATOM    254 1HZ  LYS    15       3.748  -8.461   3.031  1.00 36.29           H 
ATOM    255 2HZ  LYS    15       4.635  -7.356   3.943  1.00 36.29           H 
ATOM    256 3HZ  LYS    15       3.022  -7.670   4.334  1.00 36.29           H 
ATOM    257  N   ARG    16      10.573  -9.985   2.465  1.00 53.12           N 
ATOM    258  CA  ARG    16      11.427 -10.869   1.666  1.00 72.13           C 
ATOM    259  C   ARG    16      11.640 -10.326   0.242  1.00 25.20           C 
ATOM    260  O   ARG    16      10.906  -9.449  -0.219  1.00 32.24           O 
ATOM    261  CB  ARG    16      10.792 -12.264   1.587  1.00 52.01           C 
ATOM    262  CG  ARG    16       9.361 -12.243   1.052  1.00 71.01           C 
ATOM    263  CD  ARG    16       8.743 -13.634   1.005  1.00 61.23           C 
ATOM    264  NE  ARG    16       9.381 -14.498   0.011  1.00 72.42           N 
ATOM    265  CZ  ARG    16       8.831 -15.579  -0.473  1.00 20.34           C 
ATOM    266  NH1 ARG    16       7.664 -15.966  -0.065  1.00 12.04           N 
ATOM    267  NH2 ARG    16       9.452 -16.283  -1.360  1.00 11.42           N 
ATOM    268  H   ARG    16      10.005  -9.329   2.006  1.00 36.29           H 
ATOM    269  HA  ARG    16      12.385 -10.946   2.160  1.00 73.44           H 
ATOM    270 3HB  ARG    16      10.778 -12.699   2.577  1.00 36.29           H 
ATOM    271 2HB  ARG    16      11.392 -12.887   0.939  1.00 36.29           H 
ATOM    272 3HG  ARG    16       9.370 -11.828   0.052  1.00 36.29           H 
ATOM    273 2HG  ARG    16       8.758 -11.615   1.693  1.00 36.29           H 
ATOM    274 3HD  ARG    16       7.693 -13.536   0.763  1.00 36.29           H 
ATOM    275 2HD  ARG    16       8.843 -14.092   1.980  1.00 36.29           H 
ATOM    276  HE  ARG    16      10.269 -14.246  -0.311  1.00 74.05           H 
ATOM    277 1HH1 ARG    16       7.174 -15.436   0.626  1.00 36.29           H 
ATOM    278 2HH1 ARG    16       7.254 -16.795  -0.444  1.00 36.29           H 
ATOM    279 1HH2 ARG    16      10.355 -16.000  -1.677  1.00 36.29           H 
ATOM    280 2HH2 ARG    16       9.024 -17.104  -1.728  1.00 36.29           H 
ATOM    281  N   LEU    17      12.645 -10.863  -0.450  1.00  0.31           N 
ATOM    282  CA  LEU    17      12.922 -10.490  -1.843  1.00 62.33           C 
ATOM    283  C   LEU    17      12.686 -11.688  -2.778  1.00  3.55           C 
ATOM    284  O   LEU    17      13.438 -12.664  -2.747  1.00  4.43           O 
ATOM    285  CB  LEU    17      14.372  -9.988  -2.007  1.00 34.31           C 
ATOM    286  CG  LEU    17      14.729  -8.668  -1.289  1.00 73.12           C 
ATOM    287  CD1 LEU    17      14.759  -8.844   0.228  1.00 51.21           C 
ATOM    288  CD2 LEU    17      16.067  -8.128  -1.792  1.00 23.23           C 
ATOM    289  H   LEU    17      13.215 -11.534  -0.014  1.00 36.29           H 
ATOM    290  HA  LEU    17      12.243  -9.694  -2.117  1.00  3.45           H 
ATOM    291 3HB  LEU    17      14.560  -9.853  -3.064  1.00 36.29           H 
ATOM    292 2HB  LEU    17      15.036 -10.759  -1.642  1.00 36.29           H 
ATOM    293  HG  LEU    17      13.972  -7.931  -1.516  1.00 55.30           H 
ATOM    294 1HD1 LEU    17      13.784  -9.152   0.573  1.00 36.29           H 
ATOM    295 2HD1 LEU    17      15.023  -7.906   0.694  1.00 36.29           H 
ATOM    296 3HD1 LEU    17      15.490  -9.595   0.493  1.00 36.29           H 
ATOM    297 1HD2 LEU    17      15.995  -7.910  -2.847  1.00 36.29           H 
ATOM    298 2HD2 LEU    17      16.842  -8.865  -1.630  1.00 36.29           H 
ATOM    299 3HD2 LEU    17      16.315  -7.223  -1.255  1.00 36.29           H 
ATOM    300  N   GLU    18      11.650 -11.616  -3.609  1.00 65.14           N 
ATOM    301  CA  GLU    18      11.313 -12.710  -4.532  1.00 61.25           C 
ATOM    302  C   GLU    18      12.190 -12.680  -5.802  1.00 13.35           C 
ATOM    303  O   GLU    18      11.698 -12.836  -6.922  1.00 54.12           O 
ATOM    304  CB  GLU    18       9.818 -12.641  -4.893  1.00 64.31           C 
ATOM    305  CG  GLU    18       8.890 -12.730  -3.680  1.00 30.41           C 
ATOM    306  CD  GLU    18       7.420 -12.882  -4.059  1.00 44.25           C 
ATOM    307  OE1 GLU    18       7.032 -13.991  -4.487  1.00 73.44           O 
ATOM    308  OE2 GLU    18       6.650 -11.903  -3.923  1.00 72.23           O 
ATOM    309  H   GLU    18      11.091 -10.812  -3.602  1.00 36.29           H 
ATOM    310  HA  GLU    18      11.498 -13.643  -4.015  1.00  3.23           H 
ATOM    311 3HB  GLU    18       9.582 -13.460  -5.560  1.00 36.29           H 
ATOM    312 2HB  GLU    18       9.624 -11.706  -5.400  1.00 36.29           H 
ATOM    313 3HG  GLU    18       9.008 -11.830  -3.089  1.00 36.29           H 
ATOM    314 2HG  GLU    18       9.181 -13.584  -3.085  1.00 36.29           H 
ATOM    315  N   VAL    19      13.500 -12.511  -5.610  1.00 61.33           N 
ATOM    316  CA  VAL    19      14.461 -12.464  -6.720  1.00 64.02           C 
ATOM    317  C   VAL    19      15.892 -12.796  -6.248  1.00 51.43           C 
ATOM    318  O   VAL    19      16.281 -12.473  -5.124  1.00 60.45           O 
ATOM    319  CB  VAL    19      14.460 -11.070  -7.404  1.00 21.12           C 
ATOM    320  CG1 VAL    19      14.876  -9.976  -6.420  1.00 20.32           C 
ATOM    321  CG2 VAL    19      15.362 -11.064  -8.642  1.00 35.12           C 
ATOM    322  H   VAL    19      13.833 -12.421  -4.695  1.00 36.29           H 
ATOM    323  HA  VAL    19      14.157 -13.200  -7.452  1.00 71.45           H 
ATOM    324  HB  VAL    19      13.449 -10.857  -7.727  1.00 20.42           H 
ATOM    325 1HG1 VAL    19      14.197  -9.969  -5.579  1.00 36.29           H 
ATOM    326 2HG1 VAL    19      14.844  -9.014  -6.915  1.00 36.29           H 
ATOM    327 3HG1 VAL    19      15.879 -10.166  -6.070  1.00 36.29           H 
ATOM    328 1HG2 VAL    19      15.338 -10.086  -9.102  1.00 36.29           H 
ATOM    329 2HG2 VAL    19      15.010 -11.800  -9.350  1.00 36.29           H 
ATOM    330 3HG2 VAL    19      16.376 -11.300  -8.352  1.00 36.29           H 
ATOM    331  N   SER    20      16.668 -13.440  -7.120  1.00 30.03           N 
ATOM    332  CA  SER    20      18.064 -13.797  -6.819  1.00 25.34           C 
ATOM    333  C   SER    20      18.943 -13.724  -8.080  1.00 44.25           C 
ATOM    334  O   SER    20      18.525 -14.140  -9.162  1.00  1.44           O 
ATOM    335  CB  SER    20      18.143 -15.212  -6.222  1.00 54.34           C 
ATOM    336  OG  SER    20      17.658 -16.194  -7.132  1.00 62.52           O 
ATOM    337  H   SER    20      16.293 -13.691  -7.990  1.00 36.29           H 
ATOM    338  HA  SER    20      18.439 -13.088  -6.092  1.00 21.44           H 
ATOM    339 3HB  SER    20      17.550 -15.253  -5.320  1.00 36.29           H 
ATOM    340 2HB  SER    20      19.173 -15.443  -5.983  1.00 36.29           H 
ATOM    341  HG  SER    20      17.701 -15.848  -8.034  1.00 34.34           H 
ATOM    342  N   GLY    21      20.162 -13.203  -7.936  1.00 43.32           N 
ATOM    343  CA  GLY    21      21.082 -13.104  -9.070  1.00 23.41           C 
ATOM    344  C   GLY    21      20.997 -11.768  -9.811  1.00  2.22           C 
ATOM    345  O   GLY    21      19.912 -11.349 -10.222  1.00 65.42           O 
ATOM    346  H   GLY    21      20.447 -12.890  -7.050  1.00 36.29           H 
ATOM    347 3HA  GLY    21      20.866 -13.902  -9.767  1.00 36.29           H 
ATOM    348 2HA  GLY    21      22.090 -13.233  -8.705  1.00 36.29           H 
ATOM    349  N   GLU    22      22.147 -11.100  -9.970  1.00 25.21           N 
ATOM    350  CA  GLU    22      22.243  -9.823 -10.704  1.00 35.14           C 
ATOM    351  C   GLU    22      21.469  -8.681 -10.015  1.00 50.11           C 
ATOM    352  O   GLU    22      22.065  -7.758  -9.459  1.00 14.41           O 
ATOM    353  CB  GLU    22      21.769  -9.991 -12.160  1.00 34.40           C 
ATOM    354  CG  GLU    22      22.683 -10.870 -13.010  1.00 62.03           C 
ATOM    355  CD  GLU    22      22.176 -11.049 -14.434  1.00 22.45           C 
ATOM    356  OE1 GLU    22      21.874 -12.194 -14.830  1.00 61.44           O 
ATOM    357  OE2 GLU    22      22.061 -10.042 -15.164  1.00 72.20           O 
ATOM    358  H   GLU    22      22.963 -11.474  -9.575  1.00 36.29           H 
ATOM    359  HA  GLU    22      23.290  -9.551 -10.720  1.00 42.54           H 
ATOM    360 3HB  GLU    22      21.711  -9.016 -12.624  1.00 36.29           H 
ATOM    361 2HB  GLU    22      20.782 -10.433 -12.156  1.00 36.29           H 
ATOM    362 3HG  GLU    22      22.762 -11.841 -12.543  1.00 36.29           H 
ATOM    363 2HG  GLU    22      23.663 -10.413 -13.050  1.00 36.29           H 
ATOM    364  N   LEU    23      20.141  -8.738 -10.056  1.00 52.11           N 
ATOM    365  CA  LEU    23      19.307  -7.690  -9.456  1.00 42.43           C 
ATOM    366  C   LEU    23      19.362  -7.725  -7.917  1.00 54.40           C 
ATOM    367  O   LEU    23      19.346  -6.683  -7.260  1.00 31.34           O 
ATOM    368  CB  LEU    23      17.853  -7.829  -9.935  1.00 25.13           C 
ATOM    369  CG  LEU    23      16.890  -6.751  -9.414  1.00 34.53           C 
ATOM    370  CD1 LEU    23      17.379  -5.358  -9.802  1.00 51.22           C 
ATOM    371  CD2 LEU    23      15.476  -6.993  -9.938  1.00  1.54           C 
ATOM    372  H   LEU    23      19.710  -9.498 -10.502  1.00 36.29           H 
ATOM    373  HA  LEU    23      19.692  -6.735  -9.792  1.00 63.41           H 
ATOM    374 3HB  LEU    23      17.483  -8.794  -9.618  1.00 36.29           H 
ATOM    375 2HB  LEU    23      17.848  -7.799 -11.016  1.00 36.29           H 
ATOM    376  HG  LEU    23      16.857  -6.800  -8.334  1.00 11.35           H 
ATOM    377 1HD1 LEU    23      18.367  -5.196  -9.393  1.00 36.29           H 
ATOM    378 2HD1 LEU    23      16.703  -4.616  -9.406  1.00 36.29           H 
ATOM    379 3HD1 LEU    23      17.416  -5.274 -10.879  1.00 36.29           H 
ATOM    380 1HD2 LEU    23      15.480  -6.962 -11.019  1.00 36.29           H 
ATOM    381 2HD2 LEU    23      14.813  -6.227  -9.559  1.00 36.29           H 
ATOM    382 3HD2 LEU    23      15.128  -7.961  -9.606  1.00 36.29           H 
ATOM    383  N   HIS    24      19.440  -8.927  -7.347  1.00  5.44           N 
ATOM    384  CA  HIS    24      19.451  -9.098  -5.887  1.00 21.23           C 
ATOM    385  C   HIS    24      20.626  -8.346  -5.232  1.00 15.23           C 
ATOM    386  O   HIS    24      20.454  -7.677  -4.212  1.00 20.14           O 
ATOM    387  CB  HIS    24      19.509 -10.589  -5.534  1.00 22.14           C 
ATOM    388  CG  HIS    24      19.431 -10.874  -4.061  1.00 74.40           C 
ATOM    389  ND1 HIS    24      20.541 -11.011  -3.257  1.00 22.52           N 
ATOM    390  CD2 HIS    24      18.364 -11.068  -3.253  1.00 72.20           C 
ATOM    391  CE1 HIS    24      20.161 -11.276  -2.025  1.00 11.43           C 
ATOM    392  NE2 HIS    24      18.844 -11.316  -1.993  1.00 72.11           N 
ATOM    393  H   HIS    24      19.496  -9.719  -7.922  1.00 36.29           H 
ATOM    394  HA  HIS    24      18.527  -8.689  -5.504  1.00 73.12           H 
ATOM    395 3HB  HIS    24      20.435 -11.007  -5.904  1.00 36.29           H 
ATOM    396 2HB  HIS    24      18.680 -11.095  -6.008  1.00 36.29           H 
ATOM    397  HD1 HIS    24      21.476 -10.931  -3.549  1.00 43.04           H 
ATOM    398  HD2 HIS    24      17.323 -11.033  -3.547  1.00 22.55           H 
ATOM    399  HE1 HIS    24      20.817 -11.438  -1.182  1.00 34.02           H 
ATOM    400  HE2 HIS    24      18.323 -11.726  -1.267  1.00 36.29           H 
ATOM    401  N   GLU    25      21.814  -8.462  -5.821  1.00  1.01           N 
ATOM    402  CA  GLU    25      23.002  -7.760  -5.313  1.00 20.24           C 
ATOM    403  C   GLU    25      22.894  -6.237  -5.504  1.00 14.42           C 
ATOM    404  O   GLU    25      23.382  -5.464  -4.678  1.00 51.00           O 
ATOM    405  CB  GLU    25      24.270  -8.315  -5.975  1.00 74.25           C 
ATOM    406  CG  GLU    25      24.226  -8.330  -7.499  1.00 60.44           C 
ATOM    407  CD  GLU    25      25.174  -9.357  -8.097  1.00 13.20           C 
ATOM    408  OE1 GLU    25      26.222  -8.969  -8.652  1.00 23.14           O 
ATOM    409  OE2 GLU    25      24.871 -10.565  -8.005  1.00 30.12           O 
ATOM    410  H   GLU    25      21.902  -9.043  -6.607  1.00 36.29           H 
ATOM    411  HA  GLU    25      23.058  -7.960  -4.251  1.00 31.22           H 
ATOM    412 3HB  GLU    25      24.419  -9.330  -5.631  1.00 36.29           H 
ATOM    413 2HB  GLU    25      25.115  -7.716  -5.666  1.00 36.29           H 
ATOM    414 3HG  GLU    25      24.497  -7.348  -7.866  1.00 36.29           H 
ATOM    415 2HG  GLU    25      23.220  -8.565  -7.816  1.00 36.29           H 
ATOM    416  N   LYS    26      22.248  -5.809  -6.587  1.00 33.11           N 
ATOM    417  CA  LYS    26      21.936  -4.388  -6.789  1.00  2.13           C 
ATOM    418  C   LYS    26      21.045  -3.868  -5.647  1.00  1.22           C 
ATOM    419  O   LYS    26      21.283  -2.795  -5.085  1.00 54.51           O 
ATOM    420  CB  LYS    26      21.227  -4.181  -8.138  1.00 23.05           C 
ATOM    421  CG  LYS    26      20.755  -2.747  -8.376  1.00 73.40           C 
ATOM    422  CD  LYS    26      19.990  -2.602  -9.691  1.00 51.53           C 
ATOM    423  CE  LYS    26      19.479  -1.178  -9.894  1.00 32.13           C 
ATOM    424  NZ  LYS    26      20.585  -0.182  -9.921  1.00 65.41           N 
ATOM    425  H   LYS    26      21.984  -6.460  -7.272  1.00 36.29           H 
ATOM    426  HA  LYS    26      22.867  -3.837  -6.788  1.00 21.01           H 
ATOM    427 3HB  LYS    26      20.365  -4.833  -8.184  1.00 36.29           H 
ATOM    428 2HB  LYS    26      21.909  -4.448  -8.933  1.00 36.29           H 
ATOM    429 3HG  LYS    26      21.617  -2.094  -8.398  1.00 36.29           H 
ATOM    430 2HG  LYS    26      20.104  -2.454  -7.564  1.00 36.29           H 
ATOM    431 3HD  LYS    26      19.147  -3.278  -9.682  1.00 36.29           H 
ATOM    432 2HD  LYS    26      20.647  -2.857 -10.511  1.00 36.29           H 
ATOM    433 3HE  LYS    26      18.805  -0.931  -9.085  1.00 36.29           H 
ATOM    434 2HE  LYS    26      18.945  -1.132 -10.832  1.00 36.29           H 
ATOM    435 1HZ  LYS    26      21.194  -0.296  -9.087  1.00 36.29           H 
ATOM    436 2HZ  LYS    26      20.197   0.783  -9.915  1.00 36.29           H 
ATOM    437 3HZ  LYS    26      21.162  -0.304 -10.778  1.00 36.29           H 
ATOM    438  N   LEU    27      20.024  -4.650  -5.307  1.00  4.41           N 
ATOM    439  CA  LEU    27      19.083  -4.291  -4.242  1.00 50.20           C 
ATOM    440  C   LEU    27      19.781  -4.169  -2.873  1.00 51.10           C 
ATOM    441  O   LEU    27      19.699  -3.127  -2.217  1.00  3.54           O 
ATOM    442  CB  LEU    27      17.956  -5.332  -4.174  1.00 34.50           C 
ATOM    443  CG  LEU    27      17.071  -5.423  -5.432  1.00 22.13           C 
ATOM    444  CD1 LEU    27      16.069  -6.569  -5.311  1.00 62.11           C 
ATOM    445  CD2 LEU    27      16.352  -4.096  -5.685  1.00 60.43           C 
ATOM    446  H   LEU    27      19.895  -5.494  -5.790  1.00 36.29           H 
ATOM    447  HA  LEU    27      18.653  -3.331  -4.494  1.00 23.24           H 
ATOM    448 3HB  LEU    27      17.321  -5.093  -3.332  1.00 36.29           H 
ATOM    449 2HB  LEU    27      18.402  -6.302  -4.001  1.00 36.29           H 
ATOM    450  HG  LEU    27      17.700  -5.626  -6.287  1.00 31.34           H 
ATOM    451 1HD1 LEU    27      16.601  -7.500  -5.172  1.00 36.29           H 
ATOM    452 2HD1 LEU    27      15.478  -6.626  -6.213  1.00 36.29           H 
ATOM    453 3HD1 LEU    27      15.419  -6.396  -4.465  1.00 36.29           H 
ATOM    454 1HD2 LEU    27      15.744  -4.180  -6.575  1.00 36.29           H 
ATOM    455 2HD2 LEU    27      17.080  -3.310  -5.821  1.00 36.29           H 
ATOM    456 3HD2 LEU    27      15.720  -3.858  -4.841  1.00 36.29           H 
ATOM    457  N   VAL    28      20.473  -5.227  -2.449  1.00 41.14           N 
ATOM    458  CA  VAL    28      21.202  -5.206  -1.172  1.00 31.54           C 
ATOM    459  C   VAL    28      22.322  -4.151  -1.187  1.00  2.43           C 
ATOM    460  O   VAL    28      22.674  -3.585  -0.151  1.00 42.45           O 
ATOM    461  CB  VAL    28      21.796  -6.596  -0.812  1.00 35.24           C 
ATOM    462  CG1 VAL    28      20.698  -7.656  -0.773  1.00 43.52           C 
ATOM    463  CG2 VAL    28      22.904  -6.994  -1.786  1.00 23.41           C 
ATOM    464  H   VAL    28      20.488  -6.041  -2.998  1.00 36.29           H 
ATOM    465  HA  VAL    28      20.492  -4.937  -0.399  1.00 15.12           H 
ATOM    466  HB  VAL    28      22.227  -6.529   0.179  1.00 34.11           H 
ATOM    467 1HG1 VAL    28      20.237  -7.735  -1.748  1.00 36.29           H 
ATOM    468 2HG1 VAL    28      19.951  -7.378  -0.044  1.00 36.29           H 
ATOM    469 3HG1 VAL    28      21.127  -8.611  -0.500  1.00 36.29           H 
ATOM    470 1HG2 VAL    28      23.708  -6.275  -1.733  1.00 36.29           H 
ATOM    471 2HG2 VAL    28      22.510  -7.017  -2.791  1.00 36.29           H 
ATOM    472 3HG2 VAL    28      23.281  -7.974  -1.525  1.00 36.29           H 
ATOM    473  N   GLY    29      22.883  -3.897  -2.371  1.00 31.42           N 
ATOM    474  CA  GLY    29      23.868  -2.831  -2.532  1.00 51.22           C 
ATOM    475  C   GLY    29      23.289  -1.447  -2.241  1.00 63.34           C 
ATOM    476  O   GLY    29      23.980  -0.569  -1.718  1.00 30.35           O 
ATOM    477  H   GLY    29      22.633  -4.446  -3.146  1.00 36.29           H 
ATOM    478 3HA  GLY    29      24.236  -2.848  -3.549  1.00 36.29           H 
ATOM    479 2HA  GLY    29      24.695  -3.013  -1.860  1.00 36.29           H 
ATOM    480  N   MET    30      22.015  -1.257  -2.582  1.00  3.32           N 
ATOM    481  CA  MET    30      21.309  -0.001  -2.299  1.00  5.23           C 
ATOM    482  C   MET    30      20.713   0.005  -0.878  1.00 22.33           C 
ATOM    483  O   MET    30      20.421   1.066  -0.324  1.00 35.41           O 
ATOM    484  CB  MET    30      20.211   0.242  -3.345  1.00 11.22           C 
ATOM    485  CG  MET    30      20.754   0.455  -4.752  1.00  1.14           C 
ATOM    486  SD  MET    30      19.457   0.812  -5.956  1.00 22.01           S 
ATOM    487  CE  MET    30      18.502  -0.703  -5.889  1.00 63.52           C 
ATOM    488  H   MET    30      21.537  -1.980  -3.043  1.00 36.29           H 
ATOM    489  HA  MET    30      22.032   0.801  -2.367  1.00 44.01           H 
ATOM    490 3HB  MET    30      19.647   1.118  -3.063  1.00 36.29           H 
ATOM    491 2HB  MET    30      19.548  -0.612  -3.363  1.00 36.29           H 
ATOM    492 3HG  MET    30      21.277  -0.440  -5.061  1.00 36.29           H 
ATOM    493 2HG  MET    30      21.444   1.285  -4.736  1.00 36.29           H 
ATOM    494 1HE  MET    30      19.128  -1.537  -6.171  1.00 36.29           H 
ATOM    495 2HE  MET    30      17.667  -0.634  -6.571  1.00 36.29           H 
ATOM    496 3HE  MET    30      18.134  -0.854  -4.885  1.00 36.29           H 
ATOM    497  N   GLY    31      20.529  -1.182  -0.288  1.00 64.43           N 
ATOM    498  CA  GLY    31      20.067  -1.268   1.102  1.00 12.31           C 
ATOM    499  C   GLY    31      18.915  -2.247   1.329  1.00 42.44           C 
ATOM    500  O   GLY    31      18.568  -2.545   2.477  1.00 43.15           O 
ATOM    501  H   GLY    31      20.716  -2.001  -0.793  1.00 36.29           H 
ATOM    502 3HA  GLY    31      19.749  -0.286   1.424  1.00 36.29           H 
ATOM    503 2HA  GLY    31      20.899  -1.575   1.719  1.00 36.29           H 
ATOM    504  N   PHE    32      18.317  -2.750   0.250  1.00 21.02           N 
ATOM    505  CA  PHE    32      17.173  -3.669   0.355  1.00 73.14           C 
ATOM    506  C   PHE    32      17.560  -5.002   1.023  1.00 52.01           C 
ATOM    507  O   PHE    32      18.043  -5.923   0.362  1.00 42.21           O 
ATOM    508  CB  PHE    32      16.568  -3.944  -1.032  1.00 25.00           C 
ATOM    509  CG  PHE    32      15.960  -2.734  -1.696  1.00 31.13           C 
ATOM    510  CD1 PHE    32      16.760  -1.803  -2.344  1.00 24.34           C 
ATOM    511  CD2 PHE    32      14.586  -2.530  -1.675  1.00  5.14           C 
ATOM    512  CE1 PHE    32      16.205  -0.696  -2.953  1.00 73.05           C 
ATOM    513  CE2 PHE    32      14.028  -1.423  -2.283  1.00 61.32           C 
ATOM    514  CZ  PHE    32      14.837  -0.505  -2.923  1.00 40.43           C 
ATOM    515  H   PHE    32      18.647  -2.498  -0.637  1.00 36.29           H 
ATOM    516  HA  PHE    32      16.424  -3.186   0.966  1.00 23.32           H 
ATOM    517 3HB  PHE    32      15.794  -4.695  -0.935  1.00 36.29           H 
ATOM    518 2HB  PHE    32      17.342  -4.323  -1.683  1.00 36.29           H 
ATOM    519  HD1 PHE    32      17.830  -1.950  -2.368  1.00 53.21           H 
ATOM    520  HD2 PHE    32      13.951  -3.248  -1.177  1.00 60.02           H 
ATOM    521  HE1 PHE    32      16.840   0.020  -3.453  1.00 65.40           H 
ATOM    522  HE2 PHE    32      12.957  -1.275  -2.260  1.00 30.52           H 
ATOM    523  HZ  PHE    32      14.403   0.361  -3.398  1.00 72.35           H 
ATOM    524  N   VAL    33      17.362  -5.087   2.339  1.00 62.13           N 
ATOM    525  CA  VAL    33      17.590  -6.332   3.085  1.00 63.03           C 
ATOM    526  C   VAL    33      16.395  -6.650   4.007  1.00 51.44           C 
ATOM    527  O   VAL    33      15.780  -5.740   4.579  1.00 32.15           O 
ATOM    528  CB  VAL    33      18.901  -6.275   3.926  1.00 62.10           C 
ATOM    529  CG1 VAL    33      20.117  -6.065   3.025  1.00 55.24           C 
ATOM    530  CG2 VAL    33      18.826  -5.183   4.994  1.00 52.51           C 
ATOM    531  H   VAL    33      17.064  -4.289   2.823  1.00 36.29           H 
ATOM    532  HA  VAL    33      17.690  -7.135   2.365  1.00 61.15           H 
ATOM    533  HB  VAL    33      19.021  -7.227   4.427  1.00 30.32           H 
ATOM    534 1HG1 VAL    33      21.018  -6.064   3.624  1.00 36.29           H 
ATOM    535 2HG1 VAL    33      20.028  -5.119   2.511  1.00 36.29           H 
ATOM    536 3HG1 VAL    33      20.170  -6.863   2.298  1.00 36.29           H 
ATOM    537 1HG2 VAL    33      18.020  -5.403   5.680  1.00 36.29           H 
ATOM    538 2HG2 VAL    33      18.646  -4.229   4.522  1.00 36.29           H 
ATOM    539 3HG2 VAL    33      19.760  -5.145   5.538  1.00 36.29           H 
ATOM    540  N   PRO    34      16.038  -7.946   4.155  1.00  1.04           N 
ATOM    541  CA  PRO    34      14.906  -8.368   5.006  1.00  2.21           C 
ATOM    542  C   PRO    34      15.015  -7.834   6.446  1.00 34.35           C 
ATOM    543  O   PRO    34      15.907  -8.230   7.205  1.00 23.53           O 
ATOM    544  CB  PRO    34      14.993  -9.901   4.981  1.00 13.00           C 
ATOM    545  CG  PRO    34      15.710 -10.218   3.713  1.00 72.54           C 
ATOM    546  CD  PRO    34      16.696  -9.098   3.506  1.00 32.51           C 
ATOM    547  HA  PRO    34      13.959  -8.052   4.580  1.00 72.01           H 
ATOM    548 3HB  PRO    34      13.997 -10.323   4.988  1.00 36.29           H 
ATOM    549 2HB  PRO    34      15.543 -10.251   5.845  1.00 36.29           H 
ATOM    550 3HG  PRO    34      15.008 -10.258   2.891  1.00 36.29           H 
ATOM    551 2HG  PRO    34      16.228 -11.163   3.808  1.00 36.29           H 
ATOM    552 3HD  PRO    34      16.845  -8.915   2.451  1.00 36.29           H 
ATOM    553 2HD  PRO    34      17.638  -9.326   3.987  1.00 36.29           H 
ATOM    554  N   GLY    35      14.099  -6.939   6.813  1.00 51.52           N 
ATOM    555  CA  GLY    35      14.148  -6.295   8.124  1.00 62.41           C 
ATOM    556  C   GLY    35      14.120  -4.769   8.046  1.00 64.23           C 
ATOM    557  O   GLY    35      13.655  -4.106   8.975  1.00 51.22           O 
ATOM    558  H   GLY    35      13.365  -6.727   6.195  1.00 36.29           H 
ATOM    559 3HA  GLY    35      15.054  -6.599   8.634  1.00 36.29           H 
ATOM    560 2HA  GLY    35      13.300  -6.629   8.702  1.00 36.29           H 
ATOM    561  N   GLU    36      14.620  -4.214   6.940  1.00 53.21           N 
ATOM    562  CA  GLU    36      14.636  -2.756   6.736  1.00 11.03           C 
ATOM    563  C   GLU    36      13.231  -2.144   6.757  1.00 23.31           C 
ATOM    564  O   GLU    36      12.258  -2.761   6.326  1.00 61.20           O 
ATOM    565  CB  GLU    36      15.317  -2.400   5.402  1.00 32.34           C 
ATOM    566  CG  GLU    36      16.838  -2.339   5.469  1.00 13.14           C 
ATOM    567  CD  GLU    36      17.339  -1.243   6.399  1.00 44.42           C 
ATOM    568  OE1 GLU    36      16.727  -0.158   6.436  1.00 42.33           O 
ATOM    569  OE2 GLU    36      18.361  -1.458   7.084  1.00 62.32           O 
ATOM    570  H   GLU    36      14.995  -4.795   6.244  1.00 36.29           H 
ATOM    571  HA  GLU    36      15.209  -2.321   7.542  1.00 60.34           H 
ATOM    572 3HB  GLU    36      14.957  -1.433   5.074  1.00 36.29           H 
ATOM    573 2HB  GLU    36      15.042  -3.139   4.664  1.00 36.29           H 
ATOM    574 3HG  GLU    36      17.220  -2.148   4.475  1.00 36.29           H 
ATOM    575 2HG  GLU    36      17.210  -3.291   5.818  1.00 36.29           H 
ATOM    576  N   GLU    37      13.139  -0.920   7.263  1.00 62.22           N 
ATOM    577  CA  GLU    37      11.895  -0.154   7.219  1.00 65.14           C 
ATOM    578  C   GLU    37      11.964   0.899   6.111  1.00 35.44           C 
ATOM    579  O   GLU    37      12.697   1.881   6.211  1.00 53.53           O 
ATOM    580  CB  GLU    37      11.621   0.500   8.577  1.00 71.21           C 
ATOM    581  CG  GLU    37      11.387  -0.513   9.690  1.00 23.14           C 
ATOM    582  CD  GLU    37      11.247   0.135  11.057  1.00 20.24           C 
ATOM    583  OE1 GLU    37      12.279   0.377  11.714  1.00 53.54           O 
ATOM    584  OE2 GLU    37      10.105   0.406  11.479  1.00 64.04           O 
ATOM    585  H   GLU    37      13.931  -0.519   7.679  1.00 36.29           H 
ATOM    586  HA  GLU    37      11.089  -0.842   6.992  1.00 21.02           H 
ATOM    587 3HB  GLU    37      10.743   1.124   8.497  1.00 36.29           H 
ATOM    588 2HB  GLU    37      12.467   1.118   8.848  1.00 36.29           H 
ATOM    589 3HG  GLU    37      12.221  -1.200   9.713  1.00 36.29           H 
ATOM    590 2HG  GLU    37      10.481  -1.063   9.476  1.00 36.29           H 
ATOM    591  N   ILE    38      11.210   0.671   5.048  1.00 11.41           N 
ATOM    592  CA  ILE    38      11.230   1.539   3.870  1.00 13.12           C 
ATOM    593  C   ILE    38       9.952   2.391   3.775  1.00  2.14           C 
ATOM    594  O   ILE    38       8.836   1.879   3.862  1.00 52.15           O 
ATOM    595  CB  ILE    38      11.396   0.704   2.571  1.00 71.30           C 
ATOM    596  CG1 ILE    38      11.418   1.618   1.333  1.00 34.11           C 
ATOM    597  CG2 ILE    38      10.289  -0.346   2.454  1.00 72.01           C 
ATOM    598  CD1 ILE    38      11.584   0.869   0.025  1.00 73.03           C 
ATOM    599  H   ILE    38      10.618  -0.107   5.055  1.00 36.29           H 
ATOM    600  HA  ILE    38      12.085   2.199   3.957  1.00 43.24           H 
ATOM    601  HB  ILE    38      12.341   0.178   2.634  1.00 61.23           H 
ATOM    602 3HG1 ILE    38      12.240   2.315   1.421  1.00 36.29           H 
ATOM    603 2HG1 ILE    38      10.490   2.169   1.281  1.00 36.29           H 
ATOM    604 1HG2 ILE    38       9.328   0.146   2.379  1.00 36.29           H 
ATOM    605 2HG2 ILE    38      10.298  -0.979   3.330  1.00 36.29           H 
ATOM    606 3HG2 ILE    38      10.452  -0.952   1.575  1.00 36.29           H 
ATOM    607 1HD1 ILE    38      12.510   0.313   0.042  1.00 36.29           H 
ATOM    608 2HD1 ILE    38      11.603   1.573  -0.792  1.00 36.29           H 
ATOM    609 3HD1 ILE    38      10.757   0.186  -0.108  1.00 36.29           H 
ATOM    610  N   GLU    39      10.127   3.698   3.613  1.00 24.21           N 
ATOM    611  CA  GLU    39       8.998   4.623   3.451  1.00  0.11           C 
ATOM    612  C   GLU    39       9.097   5.378   2.114  1.00 74.24           C 
ATOM    613  O   GLU    39      10.150   5.922   1.766  1.00 61.24           O 
ATOM    614  CB  GLU    39       8.943   5.611   4.633  1.00 73.20           C 
ATOM    615  CG  GLU    39      10.230   6.403   4.838  1.00 54.35           C 
ATOM    616  CD  GLU    39      10.175   7.341   6.036  1.00  1.04           C 
ATOM    617  OE1 GLU    39      10.249   6.858   7.187  1.00 44.23           O 
ATOM    618  OE2 GLU    39      10.080   8.569   5.834  1.00 60.15           O 
ATOM    619  H   GLU    39      11.041   4.056   3.605  1.00 36.29           H 
ATOM    620  HA  GLU    39       8.089   4.037   3.445  1.00 25.43           H 
ATOM    621 3HB  GLU    39       8.739   5.056   5.539  1.00 36.29           H 
ATOM    622 2HB  GLU    39       8.135   6.312   4.466  1.00 36.29           H 
ATOM    623 3HG  GLU    39      10.420   6.988   3.948  1.00 36.29           H 
ATOM    624 2HG  GLU    39      11.043   5.708   4.984  1.00 36.29           H 
ATOM    625  N   ILE    40       8.003   5.384   1.354  1.00  4.05           N 
ATOM    626  CA  ILE    40       7.955   6.098   0.075  1.00 72.44           C 
ATOM    627  C   ILE    40       7.859   7.614   0.300  1.00 72.04           C 
ATOM    628  O   ILE    40       7.019   8.085   1.068  1.00 42.01           O 
ATOM    629  CB  ILE    40       6.757   5.631  -0.793  1.00 63.41           C 
ATOM    630  CG1 ILE    40       6.827   4.114  -1.055  1.00 70.43           C 
ATOM    631  CG2 ILE    40       6.713   6.402  -2.114  1.00 72.33           C 
ATOM    632  CD1 ILE    40       8.056   3.674  -1.828  1.00 40.12           C 
ATOM    633  H   ILE    40       7.211   4.896   1.659  1.00 36.29           H 
ATOM    634  HA  ILE    40       8.869   5.881  -0.463  1.00 32.24           H 
ATOM    635  HB  ILE    40       5.847   5.851  -0.252  1.00 54.33           H 
ATOM    636 3HG1 ILE    40       5.954   3.815  -1.622  1.00 36.29           H 
ATOM    637 2HG1 ILE    40       6.829   3.590  -0.111  1.00 36.29           H 
ATOM    638 1HG2 ILE    40       7.632   6.238  -2.658  1.00 36.29           H 
ATOM    639 2HG2 ILE    40       6.600   7.458  -1.914  1.00 36.29           H 
ATOM    640 3HG2 ILE    40       5.877   6.058  -2.706  1.00 36.29           H 
ATOM    641 1HD1 ILE    40       8.946   3.954  -1.282  1.00 36.29           H 
ATOM    642 2HD1 ILE    40       8.064   4.151  -2.796  1.00 36.29           H 
ATOM    643 3HD1 ILE    40       8.036   2.601  -1.956  1.00 36.29           H 
ATOM    644  N   VAL    41       8.728   8.373  -0.362  1.00 65.02           N 
ATOM    645  CA  VAL    41       8.744   9.831  -0.218  1.00 74.12           C 
ATOM    646  C   VAL    41       7.885  10.512  -1.294  1.00 43.23           C 
ATOM    647  O   VAL    41       6.977  11.286  -0.986  1.00 22.33           O 
ATOM    648  CB  VAL    41      10.189  10.386  -0.289  1.00 75.20           C 
ATOM    649  CG1 VAL    41      10.220  11.878   0.039  1.00 21.45           C 
ATOM    650  CG2 VAL    41      11.103   9.604   0.644  1.00 53.13           C 
ATOM    651  H   VAL    41       9.377   7.943  -0.958  1.00 36.29           H 
ATOM    652  HA  VAL    41       8.339  10.071   0.758  1.00 23.52           H 
ATOM    653  HB  VAL    41      10.554  10.257  -1.299  1.00 32.15           H 
ATOM    654 1HG1 VAL    41       9.805  12.038   1.024  1.00 36.29           H 
ATOM    655 2HG1 VAL    41       9.636  12.422  -0.690  1.00 36.29           H 
ATOM    656 3HG1 VAL    41      11.240  12.232   0.018  1.00 36.29           H 
ATOM    657 1HG2 VAL    41      11.114   8.563   0.353  1.00 36.29           H 
ATOM    658 2HG2 VAL    41      10.742   9.689   1.660  1.00 36.29           H 
ATOM    659 3HG2 VAL    41      12.105  10.003   0.587  1.00 36.29           H 
ATOM    660  N   GLN    42       8.182  10.219  -2.561  1.00  3.43           N 
ATOM    661  CA  GLN    42       7.421  10.776  -3.685  1.00 74.24           C 
ATOM    662  C   GLN    42       7.518   9.872  -4.929  1.00 64.11           C 
ATOM    663  O   GLN    42       8.488   9.130  -5.103  1.00 31.14           O 
ATOM    664  CB  GLN    42       7.899  12.213  -3.993  1.00  3.35           C 
ATOM    665  CG  GLN    42       9.315  12.327  -4.573  1.00 33.42           C 
ATOM    666  CD  GLN    42       9.342  12.283  -6.095  1.00 64.51           C 
ATOM    667  OE1 GLN    42       8.383  12.672  -6.753  1.00 10.20           O 
ATOM    668  NE2 GLN    42      10.442  11.846  -6.667  1.00 24.44           N 
ATOM    669  H   GLN    42       8.928   9.611  -2.747  1.00 36.29           H 
ATOM    670  HA  GLN    42       6.383  10.818  -3.383  1.00 54.33           H 
ATOM    671 3HB  GLN    42       7.866  12.785  -3.076  1.00 36.29           H 
ATOM    672 2HB  GLN    42       7.214  12.658  -4.699  1.00 36.29           H 
ATOM    673 3HG  GLN    42       9.912  11.509  -4.194  1.00 36.29           H 
ATOM    674 2HG  GLN    42       9.749  13.263  -4.251  1.00 36.29           H 
ATOM    675 1HE2 GLN    42      11.184  11.571  -6.094  1.00 36.29           H 
ATOM    676 2HE2 GLN    42      10.472  11.823  -7.648  1.00 36.29           H 
ATOM    677  N   VAL    43       6.501   9.937  -5.786  1.00 12.10           N 
ATOM    678  CA  VAL    43       6.417   9.079  -6.978  1.00 22.13           C 
ATOM    679  C   VAL    43       6.363   9.914  -8.265  1.00 21.24           C 
ATOM    680  O   VAL    43       5.746  10.981  -8.297  1.00 40.02           O 
ATOM    681  CB  VAL    43       5.156   8.173  -6.916  1.00 73.42           C 
ATOM    682  CG1 VAL    43       5.002   7.343  -8.195  1.00  5.04           C 
ATOM    683  CG2 VAL    43       5.200   7.273  -5.679  1.00 51.45           C 
ATOM    684  H   VAL    43       5.785  10.585  -5.620  1.00 36.29           H 
ATOM    685  HA  VAL    43       7.292   8.444  -7.006  1.00 12.31           H 
ATOM    686  HB  VAL    43       4.287   8.812  -6.832  1.00 13.50           H 
ATOM    687 1HG1 VAL    43       5.882   6.735  -8.342  1.00 36.29           H 
ATOM    688 2HG1 VAL    43       4.876   8.003  -9.042  1.00 36.29           H 
ATOM    689 3HG1 VAL    43       4.135   6.703  -8.110  1.00 36.29           H 
ATOM    690 1HG2 VAL    43       4.327   6.636  -5.661  1.00 36.29           H 
ATOM    691 2HG2 VAL    43       5.213   7.886  -4.789  1.00 36.29           H 
ATOM    692 3HG2 VAL    43       6.091   6.662  -5.706  1.00 36.29           H 
ATOM    693  N   ALA    44       7.014   9.428  -9.322  1.00 45.22           N 
ATOM    694  CA  ALA    44       6.922  10.066 -10.637  1.00 21.02           C 
ATOM    695  C   ALA    44       5.464  10.070 -11.132  1.00 53.33           C 
ATOM    696  O   ALA    44       4.819   9.021 -11.170  1.00 63.02           O 
ATOM    697  CB  ALA    44       7.823   9.351 -11.638  1.00 30.32           C 
ATOM    698  H   ALA    44       7.566   8.623  -9.217  1.00 36.29           H 
ATOM    699  HA  ALA    44       7.267  11.087 -10.537  1.00 12.11           H 
ATOM    700 1HB  ALA    44       8.840   9.355 -11.271  1.00 36.29           H 
ATOM    701 2HB  ALA    44       7.783   9.861 -12.590  1.00 36.29           H 
ATOM    702 3HB  ALA    44       7.489   8.331 -11.762  1.00 36.29           H 
ATOM    703  N   PRO    45       4.928  11.242 -11.526  1.00 61.12           N 
ATOM    704  CA  PRO    45       3.504  11.387 -11.901  1.00 65.23           C 
ATOM    705  C   PRO    45       3.058  10.429 -13.025  1.00 34.04           C 
ATOM    706  O   PRO    45       1.872  10.125 -13.156  1.00  5.14           O 
ATOM    707  CB  PRO    45       3.394  12.856 -12.354  1.00 52.21           C 
ATOM    708  CG  PRO    45       4.799  13.303 -12.595  1.00 51.52           C 
ATOM    709  CD  PRO    45       5.653  12.521 -11.640  1.00 21.40           C 
ATOM    710  HA  PRO    45       2.865  11.231 -11.043  1.00 60.22           H 
ATOM    711 3HB  PRO    45       2.925  13.438 -11.574  1.00 36.29           H 
ATOM    712 2HB  PRO    45       2.801  12.918 -13.256  1.00 36.29           H 
ATOM    713 3HG  PRO    45       4.886  14.363 -12.396  1.00 36.29           H 
ATOM    714 2HG  PRO    45       5.084  13.091 -13.616  1.00 36.29           H 
ATOM    715 3HD  PRO    45       5.710  13.018 -10.681  1.00 36.29           H 
ATOM    716 2HD  PRO    45       6.643  12.372 -12.050  1.00 36.29           H 
ATOM    717  N   LEU    46       4.012   9.949 -13.821  1.00 24.01           N 
ATOM    718  CA  LEU    46       3.708   9.037 -14.931  1.00 20.22           C 
ATOM    719  C   LEU    46       3.609   7.571 -14.463  1.00 62.34           C 
ATOM    720  O   LEU    46       3.128   6.709 -15.200  1.00  5.34           O 
ATOM    721  CB  LEU    46       4.764   9.166 -16.043  1.00 72.21           C 
ATOM    722  CG  LEU    46       4.808  10.523 -16.775  1.00 55.13           C 
ATOM    723  CD1 LEU    46       5.375  11.624 -15.881  1.00 50.34           C 
ATOM    724  CD2 LEU    46       5.611  10.409 -18.069  1.00 71.50           C 
ATOM    725  H   LEU    46       4.941  10.214 -13.661  1.00 36.29           H 
ATOM    726  HA  LEU    46       2.747   9.325 -15.336  1.00 23.32           H 
ATOM    727 3HB  LEU    46       4.573   8.395 -16.777  1.00 36.29           H 
ATOM    728 2HB  LEU    46       5.737   8.984 -15.607  1.00 36.29           H 
ATOM    729  HG  LEU    46       3.799  10.809 -17.038  1.00 33.23           H 
ATOM    730 1HD1 LEU    46       5.394  12.559 -16.424  1.00 36.29           H 
ATOM    731 2HD1 LEU    46       6.380  11.364 -15.578  1.00 36.29           H 
ATOM    732 3HD1 LEU    46       4.752  11.732 -15.005  1.00 36.29           H 
ATOM    733 1HD2 LEU    46       6.630  10.127 -17.842  1.00 36.29           H 
ATOM    734 2HD2 LEU    46       5.608  11.361 -18.583  1.00 36.29           H 
ATOM    735 3HD2 LEU    46       5.164   9.659 -18.704  1.00 36.29           H 
ATOM    736  N   GLY    47       4.064   7.296 -13.240  1.00 13.15           N 
ATOM    737  CA  GLY    47       3.998   5.941 -12.693  1.00 32.42           C 
ATOM    738  C   GLY    47       5.232   5.558 -11.879  1.00  3.32           C 
ATOM    739  O   GLY    47       5.126   5.220 -10.702  1.00 22.12           O 
ATOM    740  H   GLY    47       4.436   8.020 -12.697  1.00 36.29           H 
ATOM    741 3HA  GLY    47       3.890   5.239 -13.507  1.00 36.29           H 
ATOM    742 2HA  GLY    47       3.128   5.869 -12.057  1.00 36.29           H 
ATOM    743  N   ASP    48       6.401   5.592 -12.514  1.00 13.23           N 
ATOM    744  CA  ASP    48       7.667   5.279 -11.842  1.00 64.04           C 
ATOM    745  C   ASP    48       8.847   5.914 -12.615  1.00 61.24           C 
ATOM    746  O   ASP    48       8.654   6.395 -13.737  1.00 51.03           O 
ATOM    747  CB  ASP    48       7.820   3.754 -11.703  1.00 13.35           C 
ATOM    748  CG  ASP    48       8.158   3.054 -13.008  1.00  0.30           C 
ATOM    749  OD1 ASP    48       7.298   3.021 -13.911  1.00 41.50           O 
ATOM    750  OD2 ASP    48       9.275   2.505 -13.126  1.00 33.25           O 
ATOM    751  H   ASP    48       6.416   5.834 -13.464  1.00 36.29           H 
ATOM    752  HA  ASP    48       7.631   5.721 -10.852  1.00 40.21           H 
ATOM    753 3HB  ASP    48       6.890   3.349 -11.333  1.00 36.29           H 
ATOM    754 2HB  ASP    48       8.599   3.540 -10.988  1.00 36.29           H 
ATOM    755  N   PRO    49      10.088   5.935 -12.063  1.00 61.44           N 
ATOM    756  CA  PRO    49      10.463   5.282 -10.785  1.00 44.01           C 
ATOM    757  C   PRO    49       9.884   5.955  -9.525  1.00 75.40           C 
ATOM    758  O   PRO    49       9.372   7.076  -9.571  1.00 60.01           O 
ATOM    759  CB  PRO    49      11.994   5.387 -10.788  1.00  3.11           C 
ATOM    760  CG  PRO    49      12.279   6.611 -11.586  1.00 14.11           C 
ATOM    761  CD  PRO    49      11.239   6.634 -12.672  1.00 25.10           C 
ATOM    762  HA  PRO    49      10.185   4.239 -10.784  1.00 21.21           H 
ATOM    763 3HB  PRO    49      12.418   4.507 -11.251  1.00 36.29           H 
ATOM    764 2HB  PRO    49      12.361   5.478  -9.774  1.00 36.29           H 
ATOM    765 3HG  PRO    49      13.269   6.553 -12.014  1.00 36.29           H 
ATOM    766 2HG  PRO    49      12.191   7.489 -10.960  1.00 36.29           H 
ATOM    767 3HD  PRO    49      11.592   6.103 -13.547  1.00 36.29           H 
ATOM    768 2HD  PRO    49      10.981   7.652 -12.929  1.00 36.29           H 
ATOM    769  N   ILE    50       9.973   5.244  -8.399  1.00 53.23           N 
ATOM    770  CA  ILE    50       9.529   5.766  -7.102  1.00 62.13           C 
ATOM    771  C   ILE    50      10.734   6.058  -6.192  1.00  4.11           C 
ATOM    772  O   ILE    50      11.699   5.290  -6.156  1.00  2.10           O 
ATOM    773  CB  ILE    50       8.555   4.794  -6.364  1.00 22.25           C 
ATOM    774  CG1 ILE    50       9.205   3.418  -6.074  1.00 73.23           C 
ATOM    775  CG2 ILE    50       7.265   4.617  -7.163  1.00 33.53           C 
ATOM    776  CD1 ILE    50       9.099   2.411  -7.206  1.00 22.32           C 
ATOM    777  H   ILE    50      10.362   4.346  -8.438  1.00 36.29           H 
ATOM    778  HA  ILE    50       9.002   6.697  -7.282  1.00 12.14           H 
ATOM    779  HB  ILE    50       8.289   5.255  -5.421  1.00 55.52           H 
ATOM    780 3HG1 ILE    50       8.731   2.983  -5.204  1.00 36.29           H 
ATOM    781 2HG1 ILE    50      10.255   3.559  -5.864  1.00 36.29           H 
ATOM    782 1HG2 ILE    50       6.756   5.566  -7.239  1.00 36.29           H 
ATOM    783 2HG2 ILE    50       6.625   3.906  -6.663  1.00 36.29           H 
ATOM    784 3HG2 ILE    50       7.499   4.255  -8.155  1.00 36.29           H 
ATOM    785 1HD1 ILE    50       9.542   2.820  -8.101  1.00 36.29           H 
ATOM    786 2HD1 ILE    50       8.059   2.183  -7.391  1.00 36.29           H 
ATOM    787 3HD1 ILE    50       9.619   1.506  -6.930  1.00 36.29           H 
ATOM    788  N   VAL    51      10.682   7.174  -5.466  1.00 71.23           N 
ATOM    789  CA  VAL    51      11.762   7.545  -4.543  1.00 73.25           C 
ATOM    790  C   VAL    51      11.393   7.193  -3.096  1.00  4.52           C 
ATOM    791  O   VAL    51      10.426   7.720  -2.537  1.00 42.01           O 
ATOM    792  CB  VAL    51      12.102   9.054  -4.642  1.00  0.44           C 
ATOM    793  CG1 VAL    51      13.223   9.428  -3.670  1.00 61.10           C 
ATOM    794  CG2 VAL    51      12.486   9.422  -6.075  1.00 12.43           C 
ATOM    795  H   VAL    51       9.901   7.762  -5.548  1.00 36.29           H 
ATOM    796  HA  VAL    51      12.645   6.982  -4.822  1.00 23.14           H 
ATOM    797  HB  VAL    51      11.219   9.620  -4.372  1.00  3.15           H 
ATOM    798 1HG1 VAL    51      12.908   9.223  -2.658  1.00 36.29           H 
ATOM    799 2HG1 VAL    51      13.450  10.480  -3.768  1.00 36.29           H 
ATOM    800 3HG1 VAL    51      14.107   8.847  -3.896  1.00 36.29           H 
ATOM    801 1HG2 VAL    51      12.706  10.477  -6.130  1.00 36.29           H 
ATOM    802 2HG2 VAL    51      11.665   9.191  -6.739  1.00 36.29           H 
ATOM    803 3HG2 VAL    51      13.358   8.855  -6.374  1.00 36.29           H 
ATOM    804  N   CYS    52      12.177   6.304  -2.496  1.00 70.13           N 
ATOM    805  CA  CYS    52      11.915   5.816  -1.136  1.00  4.10           C 
ATOM    806  C   CYS    52      13.096   6.095  -0.198  1.00 50.25           C 
ATOM    807  O   CYS    52      14.147   6.562  -0.630  1.00 43.52           O 
ATOM    808  CB  CYS    52      11.640   4.312  -1.175  1.00 50.52           C 
ATOM    809  SG  CYS    52      12.998   3.330  -1.850  1.00 41.54           S 
ATOM    810  H   CYS    52      12.962   5.964  -2.978  1.00 36.29           H 
ATOM    811  HA  CYS    52      11.039   6.324  -0.755  1.00 31.21           H 
ATOM    812 3HB  CYS    52      10.768   4.126  -1.784  1.00 36.29           H 
ATOM    813 2HB  CYS    52      11.452   3.961  -0.169  1.00 36.29           H 
ATOM    814  HG  CYS    52      13.315   3.821  -3.042  1.00 52.01           H 
ATOM    815  N   LYS    53      12.911   5.811   1.090  1.00 72.54           N 
ATOM    816  CA  LYS    53      13.973   5.985   2.092  1.00 44.35           C 
ATOM    817  C   LYS    53      14.402   4.645   2.705  1.00 65.12           C 
ATOM    818  O   LYS    53      13.600   3.947   3.329  1.00 32.25           O 
ATOM    819  CB  LYS    53      13.507   6.929   3.210  1.00 52.32           C 
ATOM    820  CG  LYS    53      13.434   8.396   2.797  1.00 14.52           C 
ATOM    821  CD  LYS    53      12.721   9.250   3.847  1.00 75.52           C 
ATOM    822  CE  LYS    53      13.407   9.167   5.208  1.00 21.32           C 
ATOM    823  NZ  LYS    53      12.598   9.794   6.286  1.00 20.35           N 
ATOM    824  H   LYS    53      12.035   5.480   1.379  1.00 36.29           H 
ATOM    825  HA  LYS    53      14.828   6.428   1.599  1.00 12.25           H 
ATOM    826 3HB  LYS    53      14.192   6.849   4.043  1.00 36.29           H 
ATOM    827 2HB  LYS    53      12.524   6.620   3.537  1.00 36.29           H 
ATOM    828 3HG  LYS    53      12.898   8.470   1.863  1.00 36.29           H 
ATOM    829 2HG  LYS    53      14.439   8.773   2.665  1.00 36.29           H 
ATOM    830 3HD  LYS    53      11.700   8.903   3.945  1.00 36.29           H 
ATOM    831 2HD  LYS    53      12.719  10.279   3.516  1.00 36.29           H 
ATOM    832 3HE  LYS    53      14.361   9.671   5.148  1.00 36.29           H 
ATOM    833 2HE  LYS    53      13.569   8.127   5.454  1.00 36.29           H 
ATOM    834 1HZ  LYS    53      12.489  10.812   6.116  1.00 36.29           H 
ATOM    835 2HZ  LYS    53      13.065   9.656   7.207  1.00 36.29           H 
ATOM    836 3HZ  LYS    53      11.653   9.357   6.325  1.00 36.29           H 
ATOM    837  N   ILE    54      15.672   4.297   2.514  1.00 51.25           N 
ATOM    838  CA  ILE    54      16.270   3.111   3.134  1.00 23.41           C 
ATOM    839  C   ILE    54      17.572   3.492   3.847  1.00 53.31           C 
ATOM    840  O   ILE    54      18.478   4.059   3.236  1.00 31.01           O 
ATOM    841  CB  ILE    54      16.563   2.000   2.093  1.00 43.32           C 
ATOM    842  CG1 ILE    54      15.263   1.574   1.392  1.00  2.52           C 
ATOM    843  CG2 ILE    54      17.241   0.798   2.756  1.00 24.40           C 
ATOM    844  CD1 ILE    54      15.453   0.476   0.368  1.00 41.13           C 
ATOM    845  H   ILE    54      16.232   4.858   1.933  1.00 36.29           H 
ATOM    846  HA  ILE    54      15.572   2.721   3.864  1.00 73.43           H 
ATOM    847  HB  ILE    54      17.245   2.400   1.355  1.00 72.43           H 
ATOM    848 3HG1 ILE    54      14.840   2.430   0.885  1.00 36.29           H 
ATOM    849 2HG1 ILE    54      14.560   1.218   2.132  1.00 36.29           H 
ATOM    850 1HG2 ILE    54      18.154   1.118   3.239  1.00 36.29           H 
ATOM    851 2HG2 ILE    54      17.476   0.055   2.007  1.00 36.29           H 
ATOM    852 3HG2 ILE    54      16.578   0.367   3.493  1.00 36.29           H 
ATOM    853 1HD1 ILE    54      16.145   0.806  -0.391  1.00 36.29           H 
ATOM    854 2HD1 ILE    54      14.502   0.247  -0.089  1.00 36.29           H 
ATOM    855 3HD1 ILE    54      15.843  -0.408   0.852  1.00 36.29           H 
ATOM    856  N   GLY    55      17.662   3.191   5.137  1.00 43.33           N 
ATOM    857  CA  GLY    55      18.825   3.595   5.916  1.00  4.11           C 
ATOM    858  C   GLY    55      19.059   5.101   5.884  1.00 44.34           C 
ATOM    859  O   GLY    55      20.193   5.558   5.713  1.00 62.45           O 
ATOM    860  H   GLY    55      16.943   2.680   5.562  1.00 36.29           H 
ATOM    861 3HA  GLY    55      19.698   3.098   5.523  1.00 36.29           H 
ATOM    862 2HA  GLY    55      18.681   3.289   6.941  1.00 36.29           H 
ATOM    863  N   ASN    56      17.966   5.859   6.020  1.00 23.43           N 
ATOM    864  CA  ASN    56      17.985   7.332   6.019  1.00 24.01           C 
ATOM    865  C   ASN    56      18.160   7.926   4.601  1.00 44.12           C 
ATOM    866  O   ASN    56      17.672   9.022   4.322  1.00 43.12           O 
ATOM    867  CB  ASN    56      19.075   7.872   6.964  1.00  5.22           C 
ATOM    868  CG  ASN    56      18.955   9.369   7.204  1.00 31.32           C 
ATOM    869  OD1 ASN    56      19.509  10.179   6.468  1.00 62.00           O 
ATOM    870  ND2 ASN    56      18.236   9.752   8.240  1.00  4.13           N 
ATOM    871  H   ASN    56      17.103   5.407   6.132  1.00 36.29           H 
ATOM    872  HA  ASN    56      17.023   7.654   6.395  1.00 23.35           H 
ATOM    873 3HB  ASN    56      20.046   7.671   6.533  1.00 36.29           H 
ATOM    874 2HB  ASN    56      19.000   7.366   7.916  1.00 36.29           H 
ATOM    875 1HD2 ASN    56      17.820   9.061   8.797  1.00 36.29           H 
ATOM    876 2HD2 ASN    56      18.152  10.712   8.415  1.00 36.29           H 
ATOM    877  N   ARG    57      18.831   7.200   3.704  1.00  2.33           N 
ATOM    878  CA  ARG    57      19.129   7.721   2.360  1.00 43.52           C 
ATOM    879  C   ARG    57      17.997   7.417   1.360  1.00 52.21           C 
ATOM    880  O   ARG    57      17.310   6.399   1.466  1.00 63.30           O 
ATOM    881  CB  ARG    57      20.461   7.143   1.852  1.00 74.32           C 
ATOM    882  CG  ARG    57      20.467   5.624   1.703  1.00 64.12           C 
ATOM    883  CD  ARG    57      21.866   5.082   1.432  1.00 25.23           C 
ATOM    884  NE  ARG    57      21.877   3.625   1.305  1.00 41.34           N 
ATOM    885  CZ  ARG    57      21.857   2.794   2.312  1.00  0.11           C 
ATOM    886  NH1 ARG    57      21.805   3.224   3.536  1.00 43.11           N 
ATOM    887  NH2 ARG    57      21.892   1.524   2.089  1.00  4.44           N 
ATOM    888  H   ARG    57      19.122   6.295   3.940  1.00 36.29           H 
ATOM    889  HA  ARG    57      19.231   8.794   2.441  1.00 55.54           H 
ATOM    890 3HB  ARG    57      21.242   7.417   2.547  1.00 36.29           H 
ATOM    891 2HB  ARG    57      20.686   7.579   0.888  1.00 36.29           H 
ATOM    892 3HG  ARG    57      19.818   5.348   0.883  1.00 36.29           H 
ATOM    893 2HG  ARG    57      20.095   5.182   2.617  1.00 36.29           H 
ATOM    894 3HD  ARG    57      22.517   5.369   2.245  1.00 36.29           H 
ATOM    895 2HD  ARG    57      22.232   5.513   0.511  1.00 36.29           H 
ATOM    896  HE  ARG    57      21.916   3.251   0.399  1.00 43.20           H 
ATOM    897 1HH1 ARG    57      21.780   4.201   3.720  1.00 36.29           H 
ATOM    898 2HH1 ARG    57      21.789   2.571   4.291  1.00 36.29           H 
ATOM    899 1HH2 ARG    57      21.937   1.188   1.149  1.00 36.29           H 
ATOM    900 2HH2 ARG    57      21.876   0.883   2.852  1.00 36.29           H 
ATOM    901  N   ASN    58      17.806   8.314   0.392  1.00  2.41           N 
ATOM    902  CA  ASN    58      16.763   8.148  -0.629  1.00  2.41           C 
ATOM    903  C   ASN    58      17.240   7.279  -1.803  1.00  2.33           C 
ATOM    904  O   ASN    58      18.232   7.601  -2.464  1.00 63.11           O 
ATOM    905  CB  ASN    58      16.314   9.515  -1.150  1.00 41.10           C 
ATOM    906  CG  ASN    58      15.650  10.352  -0.075  1.00 13.22           C 
ATOM    907  OD1 ASN    58      16.304  11.093   0.645  1.00 44.15           O 
ATOM    908  ND2 ASN    58      14.343  10.240   0.041  1.00 24.54           N 
ATOM    909  H   ASN    58      18.373   9.114   0.368  1.00 36.29           H 
ATOM    910  HA  ASN    58      15.918   7.660  -0.161  1.00 24.10           H 
ATOM    911 3HB  ASN    58      15.611   9.375  -1.960  1.00 36.29           H 
ATOM    912 2HB  ASN    58      17.174  10.055  -1.521  1.00 36.29           H 
ATOM    913 1HD2 ASN    58      13.876   9.632  -0.565  1.00 36.29           H 
ATOM    914 2HD2 ASN    58      13.897  10.779   0.725  1.00 36.29           H 
ATOM    915  N   ILE    59      16.520   6.190  -2.068  1.00 34.32           N 
ATOM    916  CA  ILE    59      16.845   5.283  -3.179  1.00 73.51           C 
ATOM    917  C   ILE    59      15.782   5.354  -4.293  1.00 70.25           C 
ATOM    918  O   ILE    59      14.581   5.247  -4.028  1.00 22.13           O 
ATOM    919  CB  ILE    59      16.965   3.815  -2.690  1.00 23.45           C 
ATOM    920  CG1 ILE    59      18.032   3.695  -1.584  1.00 74.33           C 
ATOM    921  CG2 ILE    59      17.285   2.875  -3.856  1.00 15.02           C 
ATOM    922  CD1 ILE    59      19.432   4.079  -2.022  1.00 13.53           C 
ATOM    923  H   ILE    59      15.749   5.984  -1.499  1.00 36.29           H 
ATOM    924  HA  ILE    59      17.801   5.584  -3.588  1.00  1.30           H 
ATOM    925  HB  ILE    59      16.007   3.519  -2.283  1.00 64.41           H 
ATOM    926 3HG1 ILE    59      18.065   2.674  -1.232  1.00 36.29           H 
ATOM    927 2HG1 ILE    59      17.758   4.341  -0.763  1.00 36.29           H 
ATOM    928 1HG2 ILE    59      18.205   3.188  -4.332  1.00 36.29           H 
ATOM    929 2HG2 ILE    59      16.479   2.907  -4.577  1.00 36.29           H 
ATOM    930 3HG2 ILE    59      17.397   1.866  -3.488  1.00 36.29           H 
ATOM    931 1HD1 ILE    59      19.444   5.115  -2.326  1.00 36.29           H 
ATOM    932 2HD1 ILE    59      19.737   3.456  -2.851  1.00 36.29           H 
ATOM    933 3HD1 ILE    59      20.116   3.939  -1.198  1.00 36.29           H 
ATOM    934  N   THR    60      16.233   5.539  -5.535  1.00 43.10           N 
ATOM    935  CA  THR    60      15.336   5.545  -6.700  1.00 34.12           C 
ATOM    936  C   THR    60      15.132   4.123  -7.238  1.00 54.15           C 
ATOM    937  O   THR    60      16.057   3.511  -7.776  1.00 51.13           O 
ATOM    938  CB  THR    60      15.885   6.435  -7.843  1.00 74.34           C 
ATOM    939  OG1 THR    60      16.092   7.782  -7.384  1.00 72.30           O 
ATOM    940  CG2 THR    60      14.931   6.456  -9.033  1.00 65.10           C 
ATOM    941  H   THR    60      17.195   5.672  -5.675  1.00 36.29           H 
ATOM    942  HA  THR    60      14.381   5.945  -6.386  1.00 51.21           H 
ATOM    943  HB  THR    60      16.833   6.027  -8.171  1.00 73.51           H 
ATOM    944  HG1 THR    60      16.320   7.772  -6.444  1.00 72.44           H 
ATOM    945 1HG2 THR    60      14.822   5.455  -9.430  1.00 36.29           H 
ATOM    946 2HG2 THR    60      15.328   7.103  -9.801  1.00 36.29           H 
ATOM    947 3HG2 THR    60      13.967   6.826  -8.716  1.00 36.29           H 
ATOM    948  N   LEU    61      13.915   3.606  -7.108  1.00 63.14           N 
ATOM    949  CA  LEU    61      13.625   2.206  -7.443  1.00 44.53           C 
ATOM    950  C   LEU    61      12.578   2.113  -8.578  1.00 20.35           C 
ATOM    951  O   LEU    61      11.699   2.967  -8.695  1.00 64.34           O 
ATOM    952  CB  LEU    61      13.140   1.497  -6.161  1.00 44.33           C 
ATOM    953  CG  LEU    61      13.415  -0.016  -6.057  1.00 34.51           C 
ATOM    954  CD1 LEU    61      12.478  -0.813  -6.944  1.00 22.52           C 
ATOM    955  CD2 LEU    61      14.871  -0.328  -6.396  1.00 62.10           C 
ATOM    956  H   LEU    61      13.189   4.176  -6.775  1.00 36.29           H 
ATOM    957  HA  LEU    61      14.543   1.742  -7.778  1.00 54.23           H 
ATOM    958 3HB  LEU    61      12.072   1.651  -6.075  1.00 36.29           H 
ATOM    959 2HB  LEU    61      13.614   1.977  -5.314  1.00 36.29           H 
ATOM    960  HG  LEU    61      13.241  -0.331  -5.035  1.00 61.22           H 
ATOM    961 1HD1 LEU    61      12.664  -0.570  -7.980  1.00 36.29           H 
ATOM    962 2HD1 LEU    61      11.454  -0.571  -6.697  1.00 36.29           H 
ATOM    963 3HD1 LEU    61      12.644  -1.869  -6.787  1.00 36.29           H 
ATOM    964 1HD2 LEU    61      15.048  -1.387  -6.287  1.00 36.29           H 
ATOM    965 2HD2 LEU    61      15.523   0.215  -5.725  1.00 36.29           H 
ATOM    966 3HD2 LEU    61      15.078  -0.032  -7.415  1.00 36.29           H 
ATOM    967  N   ARG    62      12.687   1.084  -9.426  1.00  5.25           N 
ATOM    968  CA  ARG    62      11.758   0.904 -10.564  1.00  0.12           C 
ATOM    969  C   ARG    62      10.657  -0.116 -10.205  1.00 14.25           C 
ATOM    970  O   ARG    62      10.910  -1.052  -9.452  1.00 12.44           O 
ATOM    971  CB  ARG    62      12.532   0.418 -11.809  1.00 14.05           C 
ATOM    972  CG  ARG    62      13.974   0.922 -11.884  1.00  0.13           C 
ATOM    973  CD  ARG    62      14.068   2.445 -11.941  1.00 64.11           C 
ATOM    974  NE  ARG    62      15.370   2.916 -11.472  1.00 64.20           N 
ATOM    975  CZ  ARG    62      15.885   4.079 -11.755  1.00 11.14           C 
ATOM    976  NH1 ARG    62      15.305   4.866 -12.604  1.00 64.40           N 
ATOM    977  NH2 ARG    62      17.003   4.441 -11.208  1.00  5.21           N 
ATOM    978  H   ARG    62      13.403   0.422  -9.283  1.00 36.29           H 
ATOM    979  HA  ARG    62      11.298   1.859 -10.781  1.00 55.31           H 
ATOM    980 3HB  ARG    62      12.012   0.753 -12.697  1.00 36.29           H 
ATOM    981 2HB  ARG    62      12.555  -0.664 -11.808  1.00 36.29           H 
ATOM    982 3HG  ARG    62      14.442   0.507 -12.768  1.00 36.29           H 
ATOM    983 2HG  ARG    62      14.505   0.577 -11.007  1.00 36.29           H 
ATOM    984 3HD  ARG    62      13.295   2.869 -11.315  1.00 36.29           H 
ATOM    985 2HD  ARG    62      13.922   2.767 -12.962  1.00 36.29           H 
ATOM    986  HE  ARG    62      15.872   2.323 -10.873  1.00 11.33           H 
ATOM    987 1HH1 ARG    62      14.461   4.583 -13.052  1.00 36.29           H 
ATOM    988 2HH1 ARG    62      15.709   5.756 -12.810  1.00 36.29           H 
ATOM    989 1HH2 ARG    62      17.467   3.827 -10.572  1.00 36.29           H 
ATOM    990 2HH2 ARG    62      17.398   5.335 -11.418  1.00 36.29           H 
ATOM    991  N   LYS    63       9.444   0.040 -10.757  1.00 50.11           N 
ATOM    992  CA  LYS    63       8.329  -0.874 -10.418  1.00 15.24           C 
ATOM    993  C   LYS    63       8.701  -2.345 -10.655  1.00  2.52           C 
ATOM    994  O   LYS    63       8.415  -3.199  -9.816  1.00  5.44           O 
ATOM    995  CB  LYS    63       7.044  -0.544 -11.199  1.00 12.43           C 
ATOM    996  CG  LYS    63       6.342   0.734 -10.740  1.00 21.11           C 
ATOM    997  CD  LYS    63       4.849   0.729 -11.083  1.00 33.00           C 
ATOM    998  CE  LYS    63       4.593   0.579 -12.581  1.00 42.00           C 
ATOM    999  NZ  LYS    63       4.997   1.787 -13.349  1.00 30.20           N 
ATOM   1000  H   LYS    63       9.297   0.764 -11.402  1.00 36.29           H 
ATOM   1001  HA  LYS    63       8.127  -0.747  -9.363  1.00 14.34           H 
ATOM   1002 3HB  LYS    63       6.350  -1.367 -11.091  1.00 36.29           H 
ATOM   1003 2HB  LYS    63       7.292  -0.435 -12.246  1.00 36.29           H 
ATOM   1004 3HG  LYS    63       6.808   1.576 -11.224  1.00 36.29           H 
ATOM   1005 2HG  LYS    63       6.450   0.831  -9.669  1.00 36.29           H 
ATOM   1006 3HD  LYS    63       4.413   1.658 -10.746  1.00 36.29           H 
ATOM   1007 2HD  LYS    63       4.377  -0.094 -10.567  1.00 36.29           H 
ATOM   1008 3HE  LYS    63       3.537   0.405 -12.736  1.00 36.29           H 
ATOM   1009 2HE  LYS    63       5.150  -0.269 -12.949  1.00 36.29           H 
ATOM   1010 1HZ  LYS    63       5.989   2.028 -13.153  1.00 36.29           H 
ATOM   1011 2HZ  LYS    63       4.396   2.594 -13.092  1.00 36.29           H 
ATOM   1012 3HZ  LYS    63       4.895   1.610 -14.369  1.00 36.29           H 
ATOM   1013  N   ARG    64       9.357  -2.628 -11.783  1.00  1.34           N 
ATOM   1014  CA  ARG    64       9.785  -3.998 -12.110  1.00 73.25           C 
ATOM   1015  C   ARG    64      10.526  -4.656 -10.924  1.00 60.40           C 
ATOM   1016  O   ARG    64      10.294  -5.819 -10.597  1.00 45.22           O 
ATOM   1017  CB  ARG    64      10.710  -3.987 -13.337  1.00  4.23           C 
ATOM   1018  CG  ARG    64      12.009  -3.221 -13.102  1.00 64.14           C 
ATOM   1019  CD  ARG    64      13.114  -3.634 -14.063  1.00 24.41           C 
ATOM   1020  NE  ARG    64      14.441  -3.279 -13.558  1.00 43.52           N 
ATOM   1021  CZ  ARG    64      15.548  -3.868 -13.929  1.00 14.12           C 
ATOM   1022  NH1 ARG    64      15.524  -4.827 -14.799  1.00 23.40           N 
ATOM   1023  NH2 ARG    64      16.678  -3.515 -13.404  1.00 63.42           N 
ATOM   1024  H   ARG    64       9.545  -1.903 -12.419  1.00 36.29           H 
ATOM   1025  HA  ARG    64       8.901  -4.578 -12.339  1.00  4.42           H 
ATOM   1026 3HB  ARG    64      10.189  -3.529 -14.167  1.00 36.29           H 
ATOM   1027 2HB  ARG    64      10.956  -5.008 -13.598  1.00 36.29           H 
ATOM   1028 3HG  ARG    64      12.337  -3.408 -12.093  1.00 36.29           H 
ATOM   1029 2HG  ARG    64      11.819  -2.164 -13.222  1.00 36.29           H 
ATOM   1030 3HD  ARG    64      12.954  -3.136 -15.010  1.00 36.29           H 
ATOM   1031 2HD  ARG    64      13.069  -4.704 -14.209  1.00 36.29           H 
ATOM   1032  HE  ARG    64      14.499  -2.571 -12.887  1.00 41.34           H 
ATOM   1033 1HH1 ARG    64      14.658  -5.123 -15.190  1.00 36.29           H 
ATOM   1034 2HH1 ARG    64      16.374  -5.269 -15.073  1.00 36.29           H 
ATOM   1035 1HH2 ARG    64      16.702  -2.795 -12.705  1.00 36.29           H 
ATOM   1036 2HH2 ARG    64      17.520  -3.961 -13.693  1.00 36.29           H 
ATOM   1037  N   GLU    65      11.404  -3.880 -10.285  1.00 61.05           N 
ATOM   1038  CA  GLU    65      12.196  -4.349  -9.145  1.00 55.32           C 
ATOM   1039  C   GLU    65      11.343  -4.329  -7.870  1.00  3.51           C 
ATOM   1040  O   GLU    65      11.424  -5.222  -7.029  1.00 44.33           O 
ATOM   1041  CB  GLU    65      13.432  -3.442  -8.974  1.00  1.13           C 
ATOM   1042  CG  GLU    65      14.341  -3.388 -10.209  1.00 41.14           C 
ATOM   1043  CD  GLU    65      15.236  -2.153 -10.271  1.00 41.31           C 
ATOM   1044  OE1 GLU    65      16.203  -2.161 -11.068  1.00  4.52           O 
ATOM   1045  OE2 GLU    65      14.960  -1.162  -9.560  1.00 15.04           O 
ATOM   1046  H   GLU    65      11.512  -2.954 -10.578  1.00 36.29           H 
ATOM   1047  HA  GLU    65      12.518  -5.362  -9.343  1.00  5.33           H 
ATOM   1048 3HB  GLU    65      14.017  -3.802  -8.139  1.00 36.29           H 
ATOM   1049 2HB  GLU    65      13.096  -2.438  -8.757  1.00 36.29           H 
ATOM   1050 3HG  GLU    65      13.725  -3.403 -11.093  1.00 36.29           H 
ATOM   1051 2HG  GLU    65      14.972  -4.264 -10.208  1.00 36.29           H 
ATOM   1052  N   ALA    66      10.501  -3.306  -7.759  1.00 74.01           N 
ATOM   1053  CA  ALA    66       9.648  -3.105  -6.586  1.00 54.13           C 
ATOM   1054  C   ALA    66       8.618  -4.233  -6.402  1.00 62.01           C 
ATOM   1055  O   ALA    66       8.259  -4.570  -5.274  1.00 65.11           O 
ATOM   1056  CB  ALA    66       8.948  -1.759  -6.691  1.00 33.23           C 
ATOM   1057  H   ALA    66      10.452  -2.660  -8.493  1.00 36.29           H 
ATOM   1058  HA  ALA    66      10.289  -3.077  -5.714  1.00  4.22           H 
ATOM   1059 1HB  ALA    66       8.336  -1.741  -7.582  1.00 36.29           H 
ATOM   1060 2HB  ALA    66       9.685  -0.971  -6.747  1.00 36.29           H 
ATOM   1061 3HB  ALA    66       8.324  -1.606  -5.823  1.00 36.29           H 
ATOM   1062  N   ASP    67       8.148  -4.812  -7.509  1.00 12.11           N 
ATOM   1063  CA  ASP    67       7.185  -5.920  -7.452  1.00  0.15           C 
ATOM   1064  C   ASP    67       7.825  -7.206  -6.901  1.00  3.24           C 
ATOM   1065  O   ASP    67       7.137  -8.193  -6.647  1.00 33.51           O 
ATOM   1066  CB  ASP    67       6.581  -6.186  -8.836  1.00  4.12           C 
ATOM   1067  CG  ASP    67       5.732  -5.032  -9.343  1.00 11.24           C 
ATOM   1068  OD1 ASP    67       5.988  -4.550 -10.467  1.00 73.02           O 
ATOM   1069  OD2 ASP    67       4.789  -4.615  -8.630  1.00 34.24           O 
ATOM   1070  H   ASP    67       8.452  -4.485  -8.384  1.00 36.29           H 
ATOM   1071  HA  ASP    67       6.391  -5.623  -6.780  1.00 33.35           H 
ATOM   1072 3HB  ASP    67       5.960  -7.071  -8.786  1.00 36.29           H 
ATOM   1073 2HB  ASP    67       7.382  -6.358  -9.541  1.00 36.29           H 
ATOM   1074  N   LEU    68       9.144  -7.192  -6.731  1.00 24.35           N 
ATOM   1075  CA  LEU    68       9.874  -8.339  -6.185  1.00 61.32           C 
ATOM   1076  C   LEU    68      10.061  -8.228  -4.664  1.00  1.11           C 
ATOM   1077  O   LEU    68      10.298  -9.226  -3.985  1.00 74.44           O 
ATOM   1078  CB  LEU    68      11.237  -8.455  -6.881  1.00 72.30           C 
ATOM   1079  CG  LEU    68      11.162  -8.742  -8.387  1.00 74.11           C 
ATOM   1080  CD1 LEU    68      12.512  -8.513  -9.052  1.00 61.03           C 
ATOM   1081  CD2 LEU    68      10.673 -10.168  -8.626  1.00 22.12           C 
ATOM   1082  H   LEU    68       9.645  -6.389  -6.989  1.00 36.29           H 
ATOM   1083  HA  LEU    68       9.299  -9.232  -6.397  1.00 54.21           H 
ATOM   1084 3HB  LEU    68      11.796  -9.254  -6.412  1.00 36.29           H 
ATOM   1085 2HB  LEU    68      11.774  -7.529  -6.733  1.00 36.29           H 
ATOM   1086  HG  LEU    68      10.451  -8.066  -8.840  1.00 51.12           H 
ATOM   1087 1HD1 LEU    68      12.827  -7.491  -8.889  1.00 36.29           H 
ATOM   1088 2HD1 LEU    68      12.427  -8.695 -10.113  1.00 36.29           H 
ATOM   1089 3HD1 LEU    68      13.245  -9.185  -8.630  1.00 36.29           H 
ATOM   1090 1HD2 LEU    68       9.688 -10.288  -8.197  1.00 36.29           H 
ATOM   1091 2HD2 LEU    68      11.353 -10.868  -8.161  1.00 36.29           H 
ATOM   1092 3HD2 LEU    68      10.627 -10.361  -9.687  1.00 36.29           H 
ATOM   1093  N   ILE    69       9.953  -7.016  -4.126  1.00 32.41           N 
ATOM   1094  CA  ILE    69      10.132  -6.802  -2.685  1.00 63.31           C 
ATOM   1095  C   ILE    69       8.779  -6.750  -1.955  1.00 63.13           C 
ATOM   1096  O   ILE    69       8.015  -5.790  -2.086  1.00 64.30           O 
ATOM   1097  CB  ILE    69      10.945  -5.510  -2.371  1.00 24.51           C 
ATOM   1098  CG1 ILE    69      12.412  -5.639  -2.835  1.00 14.50           C 
ATOM   1099  CG2 ILE    69      10.899  -5.195  -0.876  1.00 21.25           C 
ATOM   1100  CD1 ILE    69      12.599  -5.655  -4.336  1.00  2.34           C 
ATOM   1101  H   ILE    69       9.739  -6.251  -4.703  1.00 36.29           H 
ATOM   1102  HA  ILE    69      10.693  -7.646  -2.300  1.00 72.51           H 
ATOM   1103  HB  ILE    69      10.482  -4.687  -2.898  1.00 43.31           H 
ATOM   1104 3HG1 ILE    69      12.827  -6.556  -2.440  1.00 36.29           H 
ATOM   1105 2HG1 ILE    69      12.979  -4.804  -2.449  1.00 36.29           H 
ATOM   1106 1HG2 ILE    69      11.498  -4.318  -0.674  1.00 36.29           H 
ATOM   1107 2HG2 ILE    69      11.290  -6.033  -0.317  1.00 36.29           H 
ATOM   1108 3HG2 ILE    69       9.878  -5.008  -0.578  1.00 36.29           H 
ATOM   1109 1HD1 ILE    69      12.101  -6.517  -4.753  1.00 36.29           H 
ATOM   1110 2HD1 ILE    69      13.653  -5.703  -4.566  1.00 36.29           H 
ATOM   1111 3HD1 ILE    69      12.179  -4.756  -4.762  1.00 36.29           H 
ATOM   1112  N   GLU    70       8.493  -7.803  -1.192  1.00 51.00           N 
ATOM   1113  CA  GLU    70       7.270  -7.889  -0.385  1.00 21.43           C 
ATOM   1114  C   GLU    70       7.465  -7.194   0.973  1.00  1.31           C 
ATOM   1115  O   GLU    70       8.252  -7.642   1.806  1.00  1.33           O 
ATOM   1116  CB  GLU    70       6.887  -9.371  -0.196  1.00 12.20           C 
ATOM   1117  CG  GLU    70       5.743  -9.638   0.787  1.00 34.43           C 
ATOM   1118  CD  GLU    70       4.419  -8.995   0.395  1.00 23.32           C 
ATOM   1119  OE1 GLU    70       3.749  -8.420   1.280  1.00 75.23           O 
ATOM   1120  OE2 GLU    70       4.032  -9.066  -0.790  1.00 11.32           O 
ATOM   1121  H   GLU    70       9.129  -8.550  -1.169  1.00 36.29           H 
ATOM   1122  HA  GLU    70       6.479  -7.388  -0.924  1.00 40.21           H 
ATOM   1123 3HB  GLU    70       7.760  -9.908   0.153  1.00 36.29           H 
ATOM   1124 2HB  GLU    70       6.597  -9.775  -1.156  1.00 36.29           H 
ATOM   1125 3HG  GLU    70       6.035  -9.264   1.760  1.00 36.29           H 
ATOM   1126 2HG  GLU    70       5.591 -10.705   0.853  1.00 36.29           H 
ATOM   1127  N   VAL    71       6.751  -6.087   1.181  1.00 21.13           N 
ATOM   1128  CA  VAL    71       6.847  -5.305   2.424  1.00  4.42           C 
ATOM   1129  C   VAL    71       5.549  -5.384   3.248  1.00 51.21           C 
ATOM   1130  O   VAL    71       4.533  -5.888   2.774  1.00 71.21           O 
ATOM   1131  CB  VAL    71       7.179  -3.817   2.132  1.00 72.43           C 
ATOM   1132  CG1 VAL    71       8.526  -3.696   1.429  1.00 43.24           C 
ATOM   1133  CG2 VAL    71       6.079  -3.153   1.303  1.00 63.42           C 
ATOM   1134  H   VAL    71       6.138  -5.787   0.480  1.00 36.29           H 
ATOM   1135  HA  VAL    71       7.655  -5.719   3.016  1.00 44.22           H 
ATOM   1136  HB  VAL    71       7.249  -3.296   3.078  1.00 15.34           H 
ATOM   1137 1HG1 VAL    71       8.475  -4.172   0.461  1.00 36.29           H 
ATOM   1138 2HG1 VAL    71       9.287  -4.178   2.027  1.00 36.29           H 
ATOM   1139 3HG1 VAL    71       8.776  -2.652   1.304  1.00 36.29           H 
ATOM   1140 1HG2 VAL    71       5.952  -3.688   0.372  1.00 36.29           H 
ATOM   1141 2HG2 VAL    71       6.351  -2.128   1.094  1.00 36.29           H 
ATOM   1142 3HG2 VAL    71       5.151  -3.169   1.855  1.00 36.29           H 
ATOM   1143  N   GLU    72       5.591  -4.909   4.494  1.00 13.21           N 
ATOM   1144  CA  GLU    72       4.400  -4.901   5.363  1.00 65.30           C 
ATOM   1145  C   GLU    72       4.184  -3.529   6.021  1.00 61.31           C 
ATOM   1146  O   GLU    72       5.122  -2.926   6.542  1.00 33.12           O 
ATOM   1147  CB  GLU    72       4.518  -5.986   6.443  1.00 42.04           C 
ATOM   1148  CG  GLU    72       5.703  -5.806   7.386  1.00 60.42           C 
ATOM   1149  CD  GLU    72       5.798  -6.915   8.420  1.00 64.32           C 
ATOM   1150  OE1 GLU    72       4.933  -6.973   9.319  1.00 14.44           O 
ATOM   1151  OE2 GLU    72       6.733  -7.738   8.334  1.00 13.42           O 
ATOM   1152  H   GLU    72       6.440  -4.563   4.844  1.00 36.29           H 
ATOM   1153  HA  GLU    72       3.541  -5.122   4.744  1.00 12.44           H 
ATOM   1154 3HB  GLU    72       4.616  -6.946   5.957  1.00 36.29           H 
ATOM   1155 2HB  GLU    72       3.613  -5.988   7.036  1.00 36.29           H 
ATOM   1156 3HG  GLU    72       5.599  -4.860   7.901  1.00 36.29           H 
ATOM   1157 2HG  GLU    72       6.613  -5.795   6.800  1.00 36.29           H 
ATOM   1158  N   VAL    73       2.943  -3.048   6.001  1.00 73.32           N 
ATOM   1159  CA  VAL    73       2.608  -1.733   6.556  1.00 54.30           C 
ATOM   1160  C   VAL    73       2.806  -1.678   8.083  1.00  2.11           C 
ATOM   1161  O   VAL    73       2.025  -2.247   8.849  1.00 23.41           O 
ATOM   1162  CB  VAL    73       1.148  -1.340   6.212  1.00 71.11           C 
ATOM   1163  CG1 VAL    73       0.792   0.029   6.795  1.00 61.40           C 
ATOM   1164  CG2 VAL    73       0.931  -1.360   4.699  1.00  2.40           C 
ATOM   1165  H   VAL    73       2.230  -3.593   5.602  1.00 36.29           H 
ATOM   1166  HA  VAL    73       3.266  -1.006   6.097  1.00 74.10           H 
ATOM   1167  HB  VAL    73       0.488  -2.074   6.654  1.00 30.21           H 
ATOM   1168 1HG1 VAL    73       1.472   0.775   6.409  1.00 36.29           H 
ATOM   1169 2HG1 VAL    73       0.870  -0.005   7.873  1.00 36.29           H 
ATOM   1170 3HG1 VAL    73      -0.221   0.288   6.517  1.00 36.29           H 
ATOM   1171 1HG2 VAL    73      -0.095  -1.102   4.478  1.00 36.29           H 
ATOM   1172 2HG2 VAL    73       1.143  -2.348   4.317  1.00 36.29           H 
ATOM   1173 3HG2 VAL    73       1.590  -0.644   4.228  1.00 36.29           H 
ATOM   1174  N   VAL    74       3.851  -0.968   8.515  1.00 21.41           N 
ATOM   1175  CA  VAL    74       4.168  -0.824   9.945  1.00 24.21           C 
ATOM   1176  C   VAL    74       3.105   0.028  10.673  1.00 65.34           C 
ATOM   1177  O   VAL    74       3.011   0.016  11.901  1.00 40.43           O 
ATOM   1178  CB  VAL    74       5.574  -0.184  10.142  1.00 31.32           C 
ATOM   1179  CG1 VAL    74       5.956  -0.116  11.621  1.00  5.25           C 
ATOM   1180  CG2 VAL    74       6.631  -0.953   9.348  1.00 53.13           C 
ATOM   1181  H   VAL    74       4.428  -0.528   7.853  1.00 36.29           H 
ATOM   1182  HA  VAL    74       4.180  -1.813  10.383  1.00 43.12           H 
ATOM   1183  HB  VAL    74       5.538   0.828   9.759  1.00 60.52           H 
ATOM   1184 1HG1 VAL    74       6.930   0.343  11.724  1.00 36.29           H 
ATOM   1185 2HG1 VAL    74       5.985  -1.114  12.034  1.00 36.29           H 
ATOM   1186 3HG1 VAL    74       5.225   0.471  12.157  1.00 36.29           H 
ATOM   1187 1HG2 VAL    74       6.384  -0.926   8.296  1.00 36.29           H 
ATOM   1188 2HG2 VAL    74       6.661  -1.979   9.684  1.00 36.29           H 
ATOM   1189 3HG2 VAL    74       7.601  -0.498   9.500  1.00 36.29           H 
END
