
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  137 ( 1068),  selected  137 , name 2fbh_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 2fbh_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     8_A      S       1           -
LGA    F     9_A      N       2           -
LGA    G    10_A      A       3           -
LGA    T    11_A      M       4           -
LGA    L    12_A      L       5           -
LGA    L    13_A      R       6           -
LGA    A    14_A      Y       7           -
LGA    Q    15_A      G       8           -
LGA    T    16_A      D       9           -
LGA    S    17_A      T      10           -
LGA    R    18_A      E      11           -
LGA    A    19_A      I      12           -
LGA    W    20_A      C      13           -
LGA    R    21_A      I      14           -
LGA    A    22_A      D      15           -
LGA    E    23_A      P      16           -
LGA    L    24_A      S      17           -
LGA    D    25_A      E      18           -
LGA    R    26_A      -       -           -
LGA    R    27_A      -       -           -
LGA    L    28_A      -       -           -
LGA    S    29_A      -       -           -
LGA    H    30_A      -       -           -
LGA    L    31_A      S      19           #
LGA    -       -      V      20           -
LGA    G    32_A      L      21          1.690
LGA    -       -      H      22           -
LGA    -       -      L      23           -
LGA    L    33_A      L      24          0.890
LGA    S    34_A      G      25          3.189
LGA    Q    35_A      K      26          2.376
LGA    -       -      K      27           -
LGA    A    36_A      Y      28          1.695
LGA    R    37_A      T      29          1.218
LGA    W    38_A      M      30          1.270
LGA    L    39_A      L      31          1.145
LGA    V    40_A      I      32          0.627
LGA    L    41_A      I      33          0.570
LGA    L    42_A      S      34          1.050
LGA    H    43_A      V      35          1.018
LGA    L    44_A      L      36          0.925
LGA    A    45_A      G      37          1.620
LGA    R    46_A      N      38          2.040
LGA    H    47_A      G      39          2.665
LGA    R    48_A      S      40          2.349
LGA    D    49_A      T      41          2.207
LGA    S    50_A      R      42          1.601
LGA    P    51_A      Q      43          1.226
LGA    T    52_A      N      44          0.709
LGA    Q    53_A      F      45          1.062
LGA    R    54_A      N      46          1.839
LGA    E    55_A      D      47          1.778
LGA    L    56_A      I      48          1.124
LGA    A    57_A      R      49          1.578
LGA    Q    58_A      S      50          2.028
LGA    S    59_A      S      51          1.782
LGA    V    60_A      I      52          1.835
LGA    G    61_A      P      53          3.392
LGA    -       -      G      54           -
LGA    V    62_A      I      55          1.817
LGA    E    63_A      S      56          2.222
LGA    G    64_A      S      57          1.765
LGA    P    65_A      T      58          2.415
LGA    T    66_A      I      59          2.159
LGA    L    67_A      L      60          1.222
LGA    A    68_A      S      61          1.104
LGA    R    69_A      R      62          0.614
LGA    L    70_A      R      63          0.782
LGA    L    71_A      I      64          0.436
LGA    D    72_A      K      65          0.641
LGA    G    73_A      D      66          0.724
LGA    L    74_A      L      67          0.563
LGA    E    75_A      I      68          0.512
LGA    S    76_A      D      69          0.773
LGA    Q    77_A      S      70          0.753
LGA    G    78_A      G      71          0.434
LGA    L    79_A      L      72          0.596
LGA    V    80_A      V      73          0.469
LGA    R    81_A      E      74          0.518
LGA    R    82_A      R      75          0.497
LGA    L    83_A      R      76          0.668
LGA    A    84_A      S      77          4.246
LGA    V    85_A      G      78          6.354
LGA    A    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    D    88_A      -       -           -
LGA    R    89_A      -       -           -
LGA    R    90_A      Q      79          1.539
LGA    A    91_A      I      80          1.853
LGA    K    92_A      T      81          1.330
LGA    H    93_A      T      82          0.130
LGA    I    94_A      Y      83          0.628
LGA    V    95_A      A      84          0.787
LGA    L    96_A      L      85          0.719
LGA    T    97_A      T      86          0.561
LGA    P    98_A      E      87          0.764
LGA    K    99_A      K      88          1.087
LGA    A   100_A      G      89          1.291
LGA    D   101_A      M      90          1.978
LGA    V   102_A      N      91          1.872
LGA    L   103_A      V      92          0.613
LGA    I   104_A      R      93          0.243
LGA    A   105_A      N      94          0.885
LGA    D   106_A      S      95          1.192
LGA    I   107_A      L      96          1.018
LGA    E   108_A      M      97          0.658
LGA    A   109_A      P      98          0.972
LGA    I   110_A      L      99          0.380
LGA    A   111_A      L     100          0.635
LGA    A   112_A      Q     101          0.944
LGA    S   113_A      Y     102          1.282
LGA    V   114_A      I     103          1.487
LGA    R   115_A      S     104          2.082
LGA    N   116_A      V     105          2.825
LGA    D   117_A      L     106          3.376
LGA    V   118_A      D     107          3.405
LGA    L   119_A      R     108          3.573
LGA    T   120_A      N     109          5.219
LGA    G   121_A      -       -           -
LGA    I   122_A      -       -           -
LGA    D   123_A      -       -           -
LGA    E   124_A      -       -           -
LGA    S   125_A      -       -           -
LGA    E   126_A      -       -           -
LGA    Q   127_A      -       -           -
LGA    A   128_A      -       -           -
LGA    L   129_A      -       -           -
LGA    C   130_A      -       -           -
LGA    Q   131_A      -       -           -
LGA    Q   132_A      -       -           -
LGA    V   133_A      -       -           -
LGA    L   134_A      -       -           -
LGA    L   135_A      -       -           -
LGA    R   136_A      -       -           -
LGA    I   137_A      -       -           -
LGA    L   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    N   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    E   142_A      -       -           -
LGA    N   143_A      -       -           -
LGA    R   144_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  137  109    5.0     85    1.84    16.47     71.375     4.384

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.284571 * X  +   0.924565 * Y  +   0.253377 * Z  + -28.315660
  Y_new =  -0.908032 * X  +  -0.344711 * Y  +   0.238016 * Z  +  40.367634
  Z_new =   0.307403 * X  +  -0.162342 * Y  +   0.937629 * Z  + -37.418736 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.171441    2.970151  [ DEG:    -9.8229    170.1771 ]
  Theta =  -0.312462   -2.829130  [ DEG:   -17.9028   -162.0972 ]
  Phi   =  -1.874494    1.267098  [ DEG:  -107.4006     72.5994 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fbh_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fbh_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  137  109   5.0   85   1.84   16.47  71.375
REMARK  ---------------------------------------------------------- 
MOLECULE 2fbh_A
HEADER    TRANSCRIPTION                           09-DEC-05   2FBH              
TITLE     THE CRYSTAL STRUCTURE OF TRANSCRIPTIONAL REGULATOR PA3341             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR PA3341;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: MODIFIED PET15B                           
KEYWDS    MARR, TRANSCRIPTION REGULATOR, APC5857, STRUCTURAL GENOMICS,          
KEYWDS   2 PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, MCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.V.LUNIN,E.EVDOKIMOVA,M.KUDRITSKA,J.OSIPIUK,A.JOACHIMIAK,            
AUTHOR   2 A.SAVCHENKO,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)            
REVDAT   2   09-JAN-07 2FBH    1       AUTHOR JRNL                              
REVDAT   1   20-DEC-05 2FBH    0                                                
JRNL        AUTH   V.V.LUNIN,E.EVDOKIMOVA,M.KUDRITSKA,J.OSIPIUK,                
JRNL        AUTH 2 A.JOACHIMIAK,A.M.EDWARDS,A.SAVCHENKO                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF TRANSCRIPTIONAL REGULATOR           
JRNL        TITL 2 PA3341                                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2FBH A    1   144  UNP    Q9HYQ4   Q9HYQ4_PSEAE     1    144             
SEQRES   1 A  146  GLY HIS MET ALA GLN THR ASP LYS HIS TYR PHE GLY THR          
SEQRES   2 A  146  LEU LEU ALA GLN THR SER ARG ALA TRP ARG ALA GLU LEU          
SEQRES   3 A  146  ASP ARG ARG LEU SER HIS LEU GLY LEU SER GLN ALA ARG          
SEQRES   4 A  146  TRP LEU VAL LEU LEU HIS LEU ALA ARG HIS ARG ASP SER          
SEQRES   5 A  146  PRO THR GLN ARG GLU LEU ALA GLN SER VAL GLY VAL GLU          
SEQRES   6 A  146  GLY PRO THR LEU ALA ARG LEU LEU ASP GLY LEU GLU SER          
SEQRES   7 A  146  GLN GLY LEU VAL ARG ARG LEU ALA VAL ALA GLU ASP ARG          
SEQRES   8 A  146  ARG ALA LYS HIS ILE VAL LEU THR PRO LYS ALA ASP VAL          
SEQRES   9 A  146  LEU ILE ALA ASP ILE GLU ALA ILE ALA ALA SER VAL ARG          
SEQRES  10 A  146  ASN ASP VAL LEU THR GLY ILE ASP GLU SER GLU GLN ALA          
SEQRES  11 A  146  LEU CYS GLN GLN VAL LEU LEU ARG ILE LEU ALA ASN LEU          
SEQRES  12 A  146  GLU ASN ARG                                                  
HET     HG    201       1                                                       
HET     ZN    203       1                                                       
HET     ZN    204       1                                                       
HET    SO4    205       5                                                       
HETNAM      HG MERCURY (II) ION                                                 
HETNAM      ZN ZINC ION                                                         
HETNAM     SO4 SULFATE ION                                                      
FORMUL   2   HG    HG 2+                                                        
FORMUL   3   ZN    2(ZN 2+)                                                     
FORMUL   5  SO4    O4 S 2-                                                      
FORMUL   6  HOH   *129(H2 O)                                                    
CRYST1   82.914   82.914   66.415  90.00  90.00 120.00 P 61 2 2     12          
ATOM      1  N   TYR A   8      24.208  14.683 -15.686  1.00 27.37           N  
ATOM      2  CA  TYR A   8      22.828  14.231 -15.853  1.00 25.07           C  
ATOM      3  C   TYR A   8      22.060  15.551 -15.745  1.00 24.21           C  
ATOM      4  O   TYR A   8      21.478  15.933 -14.715  1.00 22.37           O  
ATOM      5  CB  TYR A   8      22.489  13.266 -14.785  1.00 27.20           C  
ATOM      6  CG  TYR A   8      23.366  12.027 -14.868  1.00 28.34           C  
ATOM      7  CD1 TYR A   8      24.077  11.599 -13.768  1.00 31.92           C  
ATOM      8  CD2 TYR A   8      23.419  11.281 -16.073  1.00 31.88           C  
ATOM      9  CE1 TYR A   8      24.840  10.405 -13.832  1.00 35.76           C  
ATOM     10  CE2 TYR A   8      24.182  10.100 -16.165  1.00 35.15           C  
ATOM     11  CZ  TYR A   8      24.874   9.674 -15.039  1.00 34.23           C  
ATOM     12  OH  TYR A   8      25.612   8.501 -15.119  1.00 37.31           O  
ATOM     13  N   PHE A   9      22.120  16.239 -16.881  1.00 22.55           N  
ATOM     14  CA  PHE A   9      21.505  17.524 -17.017  1.00 19.16           C  
ATOM     15  C   PHE A   9      20.007  17.420 -16.732  1.00 16.67           C  
ATOM     16  O   PHE A   9      19.431  18.335 -16.099  1.00 15.26           O  
ATOM     17  CB  PHE A   9      21.688  17.924 -18.486  1.00 20.97           C  
ATOM     18  CG  PHE A   9      21.248  19.323 -18.782  1.00 21.93           C  
ATOM     19  CD1 PHE A   9      22.175  20.316 -19.024  1.00 32.49           C  
ATOM     20  CD2 PHE A   9      19.921  19.640 -18.883  1.00 27.50           C  
ATOM     21  CE1 PHE A   9      21.754  21.605 -19.325  1.00 30.99           C  
ATOM     22  CE2 PHE A   9      19.508  20.936 -19.156  1.00 32.25           C  
ATOM     23  CZ  PHE A   9      20.433  21.902 -19.359  1.00 27.07           C  
ATOM     24  N   GLY A  10      19.340  16.368 -17.245  1.00 15.23           N  
ATOM     25  CA  GLY A  10      17.896  16.286 -17.062  1.00 15.01           C  
ATOM     26  C   GLY A  10      17.559  16.126 -15.566  1.00 14.75           C  
ATOM     27  O   GLY A  10      16.556  16.661 -15.094  1.00 14.64           O  
ATOM     28  N   THR A  11      18.412  15.398 -14.854  1.00 13.74           N  
ATOM     29  CA  THR A  11      18.191  15.182 -13.438  1.00 14.61           C  
ATOM     30  C   THR A  11      18.353  16.468 -12.665  1.00 15.23           C  
ATOM     31  O   THR A  11      17.560  16.734 -11.769  1.00 12.02           O  
ATOM     32  CB  THR A  11      19.125  14.109 -12.845  1.00 16.27           C  
ATOM     33  OG1 THR A  11      18.751  12.858 -13.422  1.00 18.80           O  
ATOM     34  CG2 THR A  11      18.870  14.036 -11.382  1.00 17.71           C  
ATOM     35  N   LEU A  12      19.340  17.298 -13.035  1.00 13.98           N  
ATOM     36  CA  LEU A  12      19.540  18.595 -12.318  1.00 13.24           C  
ATOM     37  C   LEU A  12      18.293  19.479 -12.555  1.00 12.51           C  
ATOM     38  O   LEU A  12      17.720  20.080 -11.620  1.00 11.47           O  
ATOM     39  CB  LEU A  12      20.782  19.304 -12.831  1.00 15.04           C  
ATOM     40  CG  LEU A  12      20.925  20.740 -12.251  1.00 15.55           C  
ATOM     41  CD1 LEU A  12      21.139  20.788 -10.733  1.00 21.09           C  
ATOM     42  CD2 LEU A  12      22.078  21.405 -13.057  1.00 17.02           C  
ATOM     43  N   LEU A  13      17.761  19.475 -13.783  1.00 11.47           N  
ATOM     44  CA  LEU A  13      16.581  20.266 -14.064  1.00 12.47           C  
ATOM     45  C   LEU A  13      15.378  19.776 -13.243  1.00 13.53           C  
ATOM     46  O   LEU A  13      14.656  20.555 -12.647  1.00 11.71           O  
ATOM     47  CB  LEU A  13      16.278  20.187 -15.593  1.00 12.87           C  
ATOM     48  CG  LEU A  13      14.987  20.711 -16.101  1.00 21.18           C  
ATOM     49  CD1 LEU A  13      14.982  22.188 -15.744  1.00 24.14           C  
ATOM     50  CD2 LEU A  13      15.036  20.566 -17.646  1.00 19.84           C  
ATOM     51  N   ALA A  14      15.226  18.446 -13.182  1.00 11.64           N  
ATOM     52  CA  ALA A  14      14.038  17.912 -12.457  1.00 11.99           C  
ATOM     53  C   ALA A  14      14.136  18.198 -10.979  1.00 10.99           C  
ATOM     54  O   ALA A  14      13.111  18.490 -10.285  1.00 10.69           O  
ATOM     55  CB  ALA A  14      13.985  16.446 -12.701  1.00 12.63           C  
ATOM     56  N   GLN A  15      15.338  18.036 -10.442  1.00 10.90           N  
ATOM     57  CA  GLN A  15      15.555  18.289  -9.004  1.00 12.51           C  
ATOM     58  C   GLN A  15      15.319  19.753  -8.604  1.00 11.27           C  
ATOM     59  O   GLN A  15      14.743  20.014  -7.522  1.00 10.03           O  
ATOM     60  CB  GLN A  15      16.956  17.853  -8.629  1.00 12.34           C  
ATOM     61  CG  GLN A  15      17.094  16.301  -8.609  1.00 19.56           C  
ATOM     62  CD  GLN A  15      18.502  15.871  -8.109  1.00 23.48           C  
ATOM     63  OE1 GLN A  15      19.356  16.719  -7.794  1.00 33.38           O  
ATOM     64  NE2 GLN A  15      18.709  14.522  -7.969  1.00 38.15           N  
ATOM     65  N   THR A  16      15.761  20.679  -9.464  1.00 11.00           N  
ATOM     66  CA  THR A  16      15.616  22.099  -9.206  1.00 10.53           C  
ATOM     67  C   THR A  16      14.129  22.453  -9.274  1.00 10.81           C  
ATOM     68  O   THR A  16      13.623  23.151  -8.420  1.00  8.79           O  
ATOM     69  CB  THR A  16      16.400  22.925 -10.258  1.00 12.51           C  
ATOM     70  OG1 THR A  16      17.786  22.544 -10.250  1.00 13.49           O  
ATOM     71  CG2 THR A  16      16.321  24.406  -9.870  1.00 10.34           C  
ATOM     72  N   SER A  17      13.445  21.944 -10.308  1.00 10.63           N  
ATOM     73  CA  SER A  17      12.000  22.128 -10.456  1.00 11.05           C  
ATOM     74  C   SER A  17      11.250  21.545  -9.234  1.00  9.43           C  
ATOM     75  O   SER A  17      10.383  22.223  -8.711  1.00 10.95           O  
ATOM     76  CB  SER A  17      11.495  21.569 -11.760  1.00 11.88           C  
ATOM     77  OG  SER A  17      10.116  22.081 -11.907  1.00 12.90           O  
ATOM     78  N   ARG A  18      11.554  20.314  -8.833  1.00 11.59           N  
ATOM     79  CA  ARG A  18      10.920  19.711  -7.646  1.00 11.66           C  
ATOM     80  C   ARG A  18      11.159  20.551  -6.420  1.00 11.24           C  
ATOM     81  O   ARG A  18      10.221  20.698  -5.597  1.00 11.24           O  
ATOM     82  CB  ARG A  18      11.478  18.335  -7.401  1.00 14.28           C  
ATOM     83  CG  ARG A  18      10.921  17.584  -6.185  1.00 22.06           C  
ATOM     84  CD  ARG A  18      11.483  16.134  -6.238  1.00 29.02           C  
ATOM     85  NE  ARG A  18      11.668  15.651  -7.628  1.00 36.24           N  
ATOM     86  CZ  ARG A  18      10.685  15.449  -8.524  1.00 40.44           C  
ATOM     87  NH1 ARG A  18       9.403  15.636  -8.188  1.00 46.19           N  
ATOM     88  NH2 ARG A  18      10.978  15.026  -9.760  1.00 36.75           N  
ATOM     89  N   ALA A  19      12.374  21.050  -6.256  1.00 10.45           N  
ATOM     90  CA  ALA A  19      12.705  21.839  -5.021  1.00 11.20           C  
ATOM     91  C   ALA A  19      11.874  23.128  -5.036  1.00 11.01           C  
ATOM     92  O   ALA A  19      11.355  23.554  -3.991  1.00 11.56           O  
ATOM     93  CB  ALA A  19      14.220  22.146  -5.002  1.00 11.55           C  
ATOM     94  N   TRP A  20      11.739  23.774  -6.199  1.00 10.71           N  
ATOM     95  CA  TRP A  20      11.020  25.039  -6.259  1.00 10.43           C  
ATOM     96  C   TRP A  20       9.519  24.779  -5.990  1.00 10.41           C  
ATOM     97  O   TRP A  20       8.881  25.454  -5.159  1.00 11.03           O  
ATOM     98  CB  TRP A  20      11.223  25.641  -7.645  1.00 11.03           C  
ATOM     99  CG  TRP A  20      10.712  26.991  -7.861  1.00 11.51           C  
ATOM    100  CD1 TRP A  20       9.591  27.568  -7.331  1.00 12.85           C  
ATOM    101  CD2 TRP A  20      11.262  27.914  -8.764  1.00 11.73           C  
ATOM    102  NE1 TRP A  20       9.395  28.843  -7.860  1.00 11.46           N  
ATOM    103  CE2 TRP A  20      10.434  29.077  -8.730  1.00 11.36           C  
ATOM    104  CE3 TRP A  20      12.382  27.873  -9.611  1.00 11.68           C  
ATOM    105  CZ2 TRP A  20      10.706  30.217  -9.459  1.00 12.89           C  
ATOM    106  CZ3 TRP A  20      12.652  29.056 -10.398  1.00 14.97           C  
ATOM    107  CH2 TRP A  20      11.810  30.184 -10.310  1.00 13.17           C  
ATOM    108  N   ARG A  21       8.955  23.778  -6.642  0.50 11.52           N  
ATOM    110  CA  ARG A  21       7.539  23.449  -6.340  0.50 12.01           C  
ATOM    112  C   ARG A  21       7.312  22.999  -4.873  0.50 11.78           C  
ATOM    114  O   ARG A  21       6.250  23.281  -4.305  0.50 12.68           O  
ATOM    116  CB  ARG A  21       7.035  22.448  -7.361  0.50 12.16           C  
ATOM    118  CG  ARG A  21       7.161  22.962  -8.818  0.50 17.32           C  
ATOM    120  CD  ARG A  21       6.432  24.293  -9.011  0.50 20.80           C  
ATOM    122  NE  ARG A  21       7.127  25.155  -9.935  0.50 27.73           N  
ATOM    124  CZ  ARG A  21       6.729  26.397 -10.213  0.50 31.65           C  
ATOM    126  NH1 ARG A  21       7.399  27.116 -11.067  0.50 32.32           N  
ATOM    128  NH2 ARG A  21       5.650  26.920  -9.646  0.50 30.24           N  
ATOM    130  N   ALA A  22       8.297  22.369  -4.253  1.00 11.85           N  
ATOM    131  CA  ALA A  22       8.182  21.980  -2.809  1.00 13.45           C  
ATOM    132  C   ALA A  22       8.115  23.231  -1.985  1.00 12.94           C  
ATOM    133  O   ALA A  22       7.359  23.321  -1.001  1.00 11.97           O  
ATOM    134  CB  ALA A  22       9.331  21.143  -2.360  1.00 12.76           C  
ATOM    135  N   GLU A  23       8.972  24.190  -2.338  1.00 10.81           N  
ATOM    136  CA  GLU A  23       9.021  25.438  -1.562  1.00 10.53           C  
ATOM    137  C   GLU A  23       7.700  26.242  -1.712  1.00 10.92           C  
ATOM    138  O   GLU A  23       7.151  26.773  -0.757  1.00 11.37           O  
ATOM    139  CB  GLU A  23      10.223  26.324  -1.998  1.00  9.74           C  
ATOM    140  CG  GLU A  23      10.288  27.649  -1.194  1.00 12.48           C  
ATOM    141  CD  GLU A  23      10.556  27.452   0.353  1.00 12.05           C  
ATOM    142  OE1 GLU A  23      11.042  26.373   0.803  1.00 13.88           O  
ATOM    143  OE2 GLU A  23      10.261  28.439   1.104  1.00 13.27           O  
ATOM    144  N   LEU A  24       7.198  26.310  -2.938  1.00 10.29           N  
ATOM    145  CA  LEU A  24       5.908  26.985  -3.144  1.00 12.46           C  
ATOM    146  C   LEU A  24       4.814  26.214  -2.384  1.00 12.31           C  
ATOM    147  O   LEU A  24       3.948  26.846  -1.741  1.00 12.25           O  
ATOM    148  CB  LEU A  24       5.606  26.999  -4.672  1.00 13.97           C  
ATOM    149  CG  LEU A  24       4.482  27.908  -5.121  1.00 19.59           C  
ATOM    150  CD1 LEU A  24       4.298  29.304  -4.361  1.00 19.37           C  
ATOM    151  CD2 LEU A  24       4.857  28.132  -6.570  1.00 26.79           C  
ATOM    152  N   ASP A  25       4.811  24.885  -2.459  1.00 10.76           N  
ATOM    153  CA  ASP A  25       3.779  24.095  -1.742  1.00 13.30           C  
ATOM    154  C   ASP A  25       3.881  24.369  -0.245  1.00 13.38           C  
ATOM    155  O   ASP A  25       2.860  24.538   0.391  1.00 12.69           O  
ATOM    156  CB  ASP A  25       3.982  22.590  -1.991  1.00 12.22           C  
ATOM    157  CG  ASP A  25       2.818  21.742  -1.438  1.00 16.77           C  
ATOM    158  OD1 ASP A  25       1.661  21.965  -1.854  1.00 18.55           O  
ATOM    159  OD2 ASP A  25       3.106  20.923  -0.573  1.00 16.62           O  
ATOM    160  N   ARG A  26       5.103  24.463   0.290  1.00 10.86           N  
ATOM    161  CA  ARG A  26       5.307  24.874   1.708  1.00 10.94           C  
ATOM    162  C   ARG A  26       4.729  26.258   2.022  1.00  9.85           C  
ATOM    163  O   ARG A  26       3.987  26.424   3.000  1.00 11.97           O  
ATOM    164  CB  ARG A  26       6.806  24.870   2.000  1.00  9.80           C  
ATOM    165  CG  ARG A  26       7.214  25.628   3.287  1.00 10.44           C  
ATOM    166  CD  ARG A  26       8.758  25.608   3.539  1.00 12.97           C  
ATOM    167  NE  ARG A  26       9.103  26.399   4.699  1.00 10.97           N  
ATOM    168  CZ  ARG A  26       9.170  25.886   5.954  1.00 14.88           C  
ATOM    169  NH1 ARG A  26       9.516  26.629   7.004  1.00 15.69           N  
ATOM    170  NH2 ARG A  26       8.890  24.647   6.155  1.00 16.33           N  
ATOM    171  N   ARG A  27       5.028  27.255   1.181  1.00 10.34           N  
ATOM    172  CA  ARG A  27       4.516  28.602   1.465  1.00 11.34           C  
ATOM    173  C   ARG A  27       3.029  28.752   1.277  1.00 12.15           C  
ATOM    174  O   ARG A  27       2.442  29.661   1.891  1.00 12.59           O  
ATOM    175  CB  ARG A  27       5.330  29.702   0.756  1.00 11.14           C  
ATOM    176  CG  ARG A  27       6.860  29.568   1.097  1.00 11.49           C  
ATOM    177  CD  ARG A  27       7.503  30.927   0.781  1.00 17.13           C  
ATOM    178  NE  ARG A  27       8.929  30.693   0.644  1.00 14.32           N  
ATOM    179  CZ  ARG A  27       9.748  31.657   0.289  1.00 14.24           C  
ATOM    180  NH1 ARG A  27       9.202  32.849   0.015  1.00 14.15           N  
ATOM    181  NH2 ARG A  27      11.058  31.388   0.147  1.00 14.13           N  
ATOM    182  N   LEU A  28       2.428  27.830   0.503  1.00  9.43           N  
ATOM    183  CA  LEU A  28       1.010  27.849   0.267  1.00 10.49           C  
ATOM    184  C   LEU A  28       0.196  26.898   1.227  1.00 13.62           C  
ATOM    185  O   LEU A  28      -1.059  26.845   1.088  1.00 14.24           O  
ATOM    186  CB  LEU A  28       0.678  27.477  -1.158  1.00 12.37           C  
ATOM    187  CG  LEU A  28       1.205  28.507  -2.173  1.00 11.61           C  
ATOM    188  CD1 LEU A  28       1.016  28.045  -3.582  1.00 14.61           C  
ATOM    189  CD2 LEU A  28       0.482  29.905  -2.059  1.00 12.20           C  
ATOM    190  N   SER A  29       0.900  26.192   2.129  1.00 12.45           N  
ATOM    191  CA  SER A  29       0.357  25.044   2.845  1.00 15.37           C  
ATOM    192  C   SER A  29      -0.828  25.420   3.791  1.00 16.83           C  
ATOM    193  O   SER A  29      -1.684  24.520   4.174  1.00 18.14           O  
ATOM    194  CB  SER A  29       1.447  24.262   3.587  1.00 14.89           C  
ATOM    195  OG  SER A  29       2.004  25.151   4.540  1.00 12.31           O  
ATOM    196  N   HIS A  30      -0.924  26.699   4.120  1.00 17.27           N  
ATOM    197  CA  HIS A  30      -1.965  27.206   5.041  1.00 17.24           C  
ATOM    198  C   HIS A  30      -3.310  27.276   4.322  1.00 19.07           C  
ATOM    199  O   HIS A  30      -4.372  27.384   4.959  1.00 18.01           O  
ATOM    200  CB  HIS A  30      -1.602  28.523   5.598  1.00 16.36           C  
ATOM    201  CG  HIS A  30      -1.462  29.609   4.584  1.00 17.88           C  
ATOM    202  ND1 HIS A  30      -0.471  29.608   3.624  1.00 18.01           N  
ATOM    203  CD2 HIS A  30      -2.174  30.743   4.394  1.00 21.57           C  
ATOM    204  CE1 HIS A  30      -0.589  30.699   2.884  1.00 19.81           C  
ATOM    205  NE2 HIS A  30      -1.602  31.414   3.342  1.00 16.44           N  
ATOM    206  N   LEU A  31      -3.263  27.228   2.996  1.00 17.78           N  
ATOM    207  CA  LEU A  31      -4.492  27.495   2.217  1.00 20.32           C  
ATOM    208  C   LEU A  31      -5.336  26.236   2.055  1.00 22.19           C  
ATOM    209  O   LEU A  31      -6.464  26.314   1.553  1.00 23.66           O  
ATOM    210  CB  LEU A  31      -4.161  28.140   0.830  1.00 18.82           C  
ATOM    211  CG  LEU A  31      -3.436  29.461   0.962  1.00 20.19           C  
ATOM    212  CD1 LEU A  31      -2.999  29.907  -0.419  1.00 21.41           C  
ATOM    213  CD2 LEU A  31      -4.269  30.587   1.585  1.00 16.97           C  
ATOM    214  N   GLY A  32      -4.785  25.102   2.481  1.00 23.17           N  
ATOM    215  CA  GLY A  32      -5.517  23.788   2.413  1.00 26.50           C  
ATOM    216  C   GLY A  32      -5.790  23.350   0.977  1.00 28.61           C  
ATOM    217  O   GLY A  32      -6.743  22.598   0.696  1.00 29.74           O  
ATOM    218  N   LEU A  33      -4.954  23.780   0.035  1.00 26.42           N  
ATOM    219  CA  LEU A  33      -5.209  23.435  -1.371  1.00 27.72           C  
ATOM    220  C   LEU A  33      -4.288  22.331  -1.753  1.00 30.22           C  
ATOM    221  O   LEU A  33      -3.241  22.569  -2.414  1.00 33.15           O  
ATOM    222  CB  LEU A  33      -4.884  24.606  -2.274  1.00 26.16           C  
ATOM    223  CG  LEU A  33      -5.822  25.787  -2.148  1.00 27.42           C  
ATOM    224  CD1 LEU A  33      -5.193  27.043  -2.719  1.00 22.43           C  
ATOM    225  CD2 LEU A  33      -7.115  25.420  -2.843  1.00 29.18           C  
ATOM    226  N   SER A  34      -4.692  21.124  -1.395  1.00 30.90           N  
ATOM    227  CA  SER A  34      -3.855  19.965  -1.424  1.00 32.50           C  
ATOM    228  C   SER A  34      -3.813  19.398  -2.815  1.00 32.29           C  
ATOM    229  O   SER A  34      -4.582  19.814  -3.701  1.00 30.78           O  
ATOM    230  CB  SER A  34      -4.498  18.903  -0.528  1.00 32.61           C  
ATOM    231  OG  SER A  34      -4.932  19.429   0.745  1.00 38.13           O  
ATOM    232  N   GLN A  35      -2.997  18.368  -2.970  1.00 33.75           N  
ATOM    233  CA  GLN A  35      -2.587  17.870  -4.281  1.00 35.98           C  
ATOM    234  C   GLN A  35      -2.247  19.086  -5.146  1.00 36.52           C  
ATOM    235  O   GLN A  35      -1.840  20.171  -4.609  1.00 37.69           O  
ATOM    236  CB  GLN A  35      -3.585  16.877  -4.930  1.00 36.95           C  
ATOM    237  CG  GLN A  35      -5.046  16.893  -4.418  1.00 42.16           C  
ATOM    238  CD  GLN A  35      -5.203  16.527  -2.934  1.00 45.96           C  
ATOM    239  OE1 GLN A  35      -4.452  15.730  -2.388  1.00 50.20           O  
ATOM    240  NE2 GLN A  35      -6.169  17.136  -2.284  1.00 47.54           N  
ATOM    241  N   ALA A  36      -2.378  18.948  -6.452  1.00 35.13           N  
ATOM    242  CA  ALA A  36      -1.861  20.043  -7.256  1.00 35.09           C  
ATOM    243  C   ALA A  36      -2.719  21.338  -7.167  1.00 33.17           C  
ATOM    244  O   ALA A  36      -2.421  22.304  -7.828  1.00 33.65           O  
ATOM    245  CB  ALA A  36      -1.648  19.582  -8.714  1.00 34.65           C  
ATOM    246  N   ARG A  37      -3.735  21.392  -6.308  1.00 30.20           N  
ATOM    247  CA  ARG A  37      -4.890  22.258  -6.588  1.00 27.03           C  
ATOM    248  C   ARG A  37      -4.540  23.722  -6.730  1.00 25.10           C  
ATOM    249  O   ARG A  37      -5.093  24.415  -7.581  1.00 23.71           O  
ATOM    250  CB  ARG A  37      -5.993  22.052  -5.568  1.00 26.58           C  
ATOM    251  CG  ARG A  37      -6.346  20.620  -5.629  1.00 30.78           C  
ATOM    252  CD  ARG A  37      -7.707  20.353  -5.256  1.00 39.63           C  
ATOM    253  NE  ARG A  37      -7.993  20.646  -3.882  1.00 41.49           N  
ATOM    254  CZ  ARG A  37      -8.936  19.979  -3.217  1.00 50.00           C  
ATOM    255  NH1 ARG A  37      -9.571  18.969  -3.824  1.00 53.37           N  
ATOM    256  NH2 ARG A  37      -9.237  20.291  -1.960  1.00 51.74           N  
ATOM    257  N   TRP A  38      -3.581  24.180  -5.947  1.00 21.87           N  
ATOM    258  CA  TRP A  38      -3.177  25.584  -6.024  1.00 21.39           C  
ATOM    259  C   TRP A  38      -2.519  25.933  -7.385  1.00 21.88           C  
ATOM    260  O   TRP A  38      -2.577  27.100  -7.827  1.00 23.10           O  
ATOM    261  CB  TRP A  38      -2.242  25.960  -4.884  1.00 19.41           C  
ATOM    262  CG  TRP A  38      -0.930  25.146  -4.741  1.00 19.00           C  
ATOM    263  CD1 TRP A  38      -0.676  24.153  -3.803  1.00 19.61           C  
ATOM    264  CD2 TRP A  38       0.286  25.298  -5.492  1.00 20.15           C  
ATOM    265  NE1 TRP A  38       0.605  23.673  -3.972  1.00 19.21           N  
ATOM    266  CE2 TRP A  38       1.214  24.346  -4.995  1.00 19.63           C  
ATOM    267  CE3 TRP A  38       0.687  26.147  -6.532  1.00 20.41           C  
ATOM    268  CZ2 TRP A  38       2.540  24.232  -5.497  1.00 18.11           C  
ATOM    269  CZ3 TRP A  38       2.011  26.013  -7.049  1.00 18.03           C  
ATOM    270  CH2 TRP A  38       2.900  25.100  -6.529  1.00 17.91           C  
ATOM    271  N   LEU A  39      -1.938  24.922  -8.017  0.50 22.27           N  
ATOM    273  CA  LEU A  39      -1.230  25.047  -9.307  0.50 24.09           C  
ATOM    275  C   LEU A  39      -2.196  25.147 -10.513  0.50 23.79           C  
ATOM    277  O   LEU A  39      -1.905  25.787 -11.500  0.50 23.70           O  
ATOM    279  CB  LEU A  39      -0.276  23.872  -9.460  0.50 24.70           C  
ATOM    281  CG  LEU A  39       1.001  23.960 -10.299  0.50 25.94           C  
ATOM    283  CD1 LEU A  39       0.753  23.387 -11.667  0.50 26.47           C  
ATOM    285  CD2 LEU A  39       1.551  25.390 -10.400  0.50 26.55           C  
ATOM    287  N   VAL A  40      -3.359  24.513 -10.384  1.00 23.81           N  
ATOM    288  CA  VAL A  40      -4.488  24.750 -11.266  1.00 22.71           C  
ATOM    289  C   VAL A  40      -4.977  26.207 -11.152  1.00 22.28           C  
ATOM    290  O   VAL A  40      -5.084  26.866 -12.169  1.00 22.77           O  
ATOM    291  CB  VAL A  40      -5.622  23.691 -11.002  1.00 23.81           C  
ATOM    292  CG1 VAL A  40      -6.873  24.031 -11.802  1.00 22.65           C  
ATOM    293  CG2 VAL A  40      -5.107  22.241 -11.381  1.00 24.31           C  
ATOM    294  N   LEU A  41      -5.246  26.712  -9.914  1.00 21.32           N  
ATOM    295  CA  LEU A  41      -5.616  28.091  -9.645  1.00 22.95           C  
ATOM    296  C   LEU A  41      -4.593  29.045 -10.208  1.00 23.81           C  
ATOM    297  O   LEU A  41      -4.921  30.025 -10.859  1.00 22.04           O  
ATOM    298  CB  LEU A  41      -5.688  28.325  -8.143  1.00 23.18           C  
ATOM    299  CG  LEU A  41      -6.917  27.697  -7.485  1.00 21.28           C  
ATOM    300  CD1 LEU A  41      -6.970  28.156  -6.023  1.00 20.22           C  
ATOM    301  CD2 LEU A  41      -8.303  28.136  -8.223  1.00 21.22           C  
ATOM    302  N   LEU A  42      -3.318  28.714  -9.988  1.00 23.64           N  
ATOM    303  CA  LEU A  42      -2.282  29.659 -10.418  1.00 24.66           C  
ATOM    304  C   LEU A  42      -2.340  29.760 -11.932  1.00 24.73           C  
ATOM    305  O   LEU A  42      -2.312  30.863 -12.464  1.00 25.69           O  
ATOM    306  CB  LEU A  42      -0.929  29.160  -9.981  1.00 24.60           C  
ATOM    307  CG  LEU A  42      -0.032  30.167  -9.353  1.00 28.71           C  
ATOM    308  CD1 LEU A  42       1.380  29.637  -9.492  1.00 26.92           C  
ATOM    309  CD2 LEU A  42      -0.245  31.592  -9.894  1.00 28.41           C  
ATOM    310  N   HIS A  43      -2.475  28.627 -12.625  1.00 24.38           N  
ATOM    311  CA  HIS A  43      -2.516  28.644 -14.069  1.00 26.63           C  
ATOM    312  C   HIS A  43      -3.777  29.312 -14.637  1.00 26.52           C  
ATOM    313  O   HIS A  43      -3.726  30.020 -15.653  1.00 24.71           O  
ATOM    314  CB  HIS A  43      -2.312  27.248 -14.592  1.00 26.90           C  
ATOM    315  CG  HIS A  43      -0.880  26.777 -14.469  1.00 33.89           C  
ATOM    316  ND1 HIS A  43      -0.124  26.391 -15.561  1.00 40.71           N  
ATOM    317  CD2 HIS A  43      -0.055  26.685 -13.394  1.00 35.35           C  
ATOM    318  CE1 HIS A  43       1.085  26.020 -15.153  1.00 39.69           C  
ATOM    319  NE2 HIS A  43       1.152  26.191 -13.844  1.00 37.41           N  
ATOM    320  N   LEU A  44      -4.906  29.142 -13.949  1.00 25.30           N  
ATOM    321  CA  LEU A  44      -6.104  29.867 -14.329  1.00 25.31           C  
ATOM    322  C   LEU A  44      -5.917  31.355 -14.181  1.00 24.24           C  
ATOM    323  O   LEU A  44      -6.425  32.144 -14.984  1.00 27.13           O  
ATOM    324  CB  LEU A  44      -7.301  29.401 -13.458  1.00 24.51           C  
ATOM    325  CG  LEU A  44      -7.829  28.064 -13.904  1.00 25.38           C  
ATOM    326  CD1 LEU A  44      -8.883  27.604 -12.823  1.00 27.70           C  
ATOM    327  CD2 LEU A  44      -8.495  28.126 -15.259  1.00 29.13           C  
ATOM    328  N   ALA A  45      -5.230  31.759 -13.129  1.00 24.61           N  
ATOM    329  CA  ALA A  45      -5.046  33.172 -12.842  1.00 26.57           C  
ATOM    330  C   ALA A  45      -4.186  33.804 -13.932  1.00 27.57           C  
ATOM    331  O   ALA A  45      -4.277  35.030 -14.182  1.00 28.55           O  
ATOM    332  CB  ALA A  45      -4.321  33.321 -11.538  1.00 26.89           C  
ATOM    333  N   ARG A  46      -3.316  32.986 -14.501  1.00 26.93           N  
ATOM    334  CA  ARG A  46      -2.266  33.514 -15.399  1.00 29.48           C  
ATOM    335  C   ARG A  46      -2.595  33.551 -16.862  1.00 32.75           C  
ATOM    336  O   ARG A  46      -1.916  34.244 -17.640  1.00 33.34           O  
ATOM    337  CB  ARG A  46      -1.000  32.719 -15.238  1.00 26.51           C  
ATOM    338  CG  ARG A  46      -0.336  33.091 -13.928  1.00 26.52           C  
ATOM    339  CD  ARG A  46       0.926  32.251 -13.705  1.00 25.26           C  
ATOM    340  NE  ARG A  46       1.523  32.698 -12.440  1.00 27.76           N  
ATOM    341  CZ  ARG A  46       2.598  32.138 -11.891  1.00 25.76           C  
ATOM    342  NH1 ARG A  46       3.200  31.130 -12.519  1.00 23.56           N  
ATOM    343  NH2 ARG A  46       3.102  32.635 -10.756  1.00 26.75           N  
ATOM    344  N   HIS A  47      -3.589  32.794 -17.275  1.00 35.68           N  
ATOM    345  CA  HIS A  47      -3.985  32.946 -18.662  1.00 39.56           C  
ATOM    346  C   HIS A  47      -5.205  33.824 -18.831  1.00 40.54           C  
ATOM    347  O   HIS A  47      -6.035  33.909 -17.915  1.00 41.16           O  
ATOM    348  CB  HIS A  47      -3.989  31.579 -19.294  1.00 40.92           C  
ATOM    349  CG  HIS A  47      -2.647  30.935 -19.192  1.00 44.10           C  
ATOM    350  ND1 HIS A  47      -1.615  31.217 -20.064  1.00 47.36           N  
ATOM    351  CD2 HIS A  47      -2.117  30.135 -18.235  1.00 46.52           C  
ATOM    352  CE1 HIS A  47      -0.534  30.557 -19.699  1.00 46.43           C  
ATOM    353  NE2 HIS A  47      -0.812  29.893 -18.592  1.00 47.74           N  
ATOM    354  N   ARG A  48      -5.292  34.608 -19.914  1.00 42.47           N  
ATOM    355  CA  ARG A  48      -6.524  35.443 -20.013  1.00 42.26           C  
ATOM    356  C   ARG A  48      -7.727  34.675 -20.552  1.00 40.85           C  
ATOM    357  O   ARG A  48      -8.871  34.938 -20.147  1.00 40.49           O  
ATOM    358  CB  ARG A  48      -6.361  36.767 -20.752  1.00 43.33           C  
ATOM    359  CG  ARG A  48      -7.380  37.786 -20.232  1.00 46.88           C  
ATOM    360  CD  ARG A  48      -7.913  38.716 -21.330  1.00 54.52           C  
ATOM    361  NE  ARG A  48      -8.899  38.072 -22.196  1.00 59.92           N  
ATOM    362  CZ  ARG A  48      -8.604  37.362 -23.283  1.00 62.28           C  
ATOM    363  NH1 ARG A  48      -7.341  37.194 -23.676  0.50 63.10           N  
ATOM    364  NH2 ARG A  48      -9.577  36.813 -23.986  1.00 62.79           N  
ATOM    365  N   ASP A  49      -7.462  33.744 -21.467  1.00 39.63           N  
ATOM    366  CA  ASP A  49      -8.516  32.853 -21.943  1.00 38.65           C  
ATOM    367  C   ASP A  49      -8.906  31.875 -20.838  1.00 37.40           C  
ATOM    368  O   ASP A  49      -8.105  31.576 -19.965  1.00 37.79           O  
ATOM    369  CB  ASP A  49      -8.085  32.075 -23.179  1.00 38.54           C  
ATOM    370  CG  ASP A  49      -7.765  32.989 -24.341  1.00 39.80           C  
ATOM    371  OD1 ASP A  49      -8.257  34.147 -24.362  1.00 35.19           O  
ATOM    372  OD2 ASP A  49      -6.982  32.547 -25.202  1.00 45.32           O  
ATOM    373  N   SER A  50     -10.150  31.407 -20.901  1.00 35.22           N  
ATOM    374  CA  SER A  50     -10.634  30.356 -20.028  1.00 33.18           C  
ATOM    375  C   SER A  50     -10.348  29.056 -20.736  1.00 32.86           C  
ATOM    376  O   SER A  50     -10.842  28.867 -21.849  1.00 33.38           O  
ATOM    377  CB  SER A  50     -12.133  30.535 -19.824  1.00 32.92           C  
ATOM    378  OG  SER A  50     -12.362  31.755 -19.148  1.00 34.87           O  
ATOM    379  N   PRO A  51      -9.520  28.162 -20.133  1.00 32.04           N  
ATOM    380  CA  PRO A  51      -9.110  26.956 -20.842  1.00 32.38           C  
ATOM    381  C   PRO A  51     -10.175  25.877 -20.846  1.00 32.71           C  
ATOM    382  O   PRO A  51     -11.074  25.841 -19.990  1.00 31.76           O  
ATOM    383  CB  PRO A  51      -7.899  26.460 -20.023  1.00 32.69           C  
ATOM    384  CG  PRO A  51      -8.285  26.862 -18.587  1.00 31.73           C  
ATOM    385  CD  PRO A  51      -8.915  28.244 -18.792  1.00 32.36           C  
ATOM    386  N   THR A  52     -10.073  24.961 -21.786  1.00 32.37           N  
ATOM    387  CA  THR A  52     -10.864  23.746 -21.661  1.00 32.79           C  
ATOM    388  C   THR A  52     -10.111  22.871 -20.649  1.00 33.21           C  
ATOM    389  O   THR A  52      -8.991  23.187 -20.297  1.00 31.96           O  
ATOM    390  CB  THR A  52     -10.909  22.985 -22.969  1.00 32.97           C  
ATOM    391  OG1 THR A  52      -9.575  22.548 -23.326  1.00 32.80           O  
ATOM    392  CG2 THR A  52     -11.468  23.896 -24.062  1.00 34.11           C  
ATOM    393  N   GLN A  53     -10.705  21.747 -20.253  1.00 34.98           N  
ATOM    394  CA  GLN A  53     -10.048  20.786 -19.342  1.00 37.05           C  
ATOM    395  C   GLN A  53      -8.770  20.240 -19.948  1.00 37.06           C  
ATOM    396  O   GLN A  53      -7.756  20.104 -19.266  1.00 36.88           O  
ATOM    397  CB  GLN A  53     -11.020  19.652 -18.927  1.00 36.61           C  
ATOM    398  CG  GLN A  53     -12.109  20.201 -18.027  1.00 40.01           C  
ATOM    399  CD  GLN A  53     -12.773  19.191 -17.019  1.00 39.36           C  
ATOM    400  OE1 GLN A  53     -13.784  19.543 -16.377  1.00 40.61           O  
ATOM    401  NE2 GLN A  53     -12.191  17.985 -16.857  1.00 36.04           N  
ATOM    402  N   ARG A  54      -8.834  19.964 -21.248  0.50 37.30           N  
ATOM    404  CA  ARG A  54      -7.694  19.496 -22.037  0.50 37.99           C  
ATOM    406  C   ARG A  54      -6.516  20.486 -22.044  0.50 37.65           C  
ATOM    408  O   ARG A  54      -5.366  20.084 -21.946  0.50 38.21           O  
ATOM    410  CB  ARG A  54      -8.144  19.168 -23.468  0.50 37.72           C  
ATOM    412  CG  ARG A  54      -9.361  18.239 -23.563  0.50 38.57           C  
ATOM    414  CD  ARG A  54      -9.573  17.687 -24.992  0.50 38.76           C  
ATOM    416  NE  ARG A  54      -8.544  16.714 -25.368  0.50 40.14           N  
ATOM    418  CZ  ARG A  54      -8.713  15.392 -25.353  0.50 39.68           C  
ATOM    420  NH1 ARG A  54      -7.716  14.592 -25.698  0.50 39.82           N  
ATOM    422  NH2 ARG A  54      -9.876  14.865 -25.001  0.50 39.75           N  
ATOM    424  N   GLU A  55      -6.814  21.779 -22.140  1.00 37.24           N  
ATOM    425  CA  GLU A  55      -5.784  22.805 -22.154  1.00 36.49           C  
ATOM    426  C   GLU A  55      -5.123  22.952 -20.775  1.00 36.39           C  
ATOM    427  O   GLU A  55      -3.899  23.076 -20.631  1.00 35.36           O  
ATOM    428  CB  GLU A  55      -6.370  24.142 -22.658  1.00 36.61           C  
ATOM    429  CG  GLU A  55      -6.701  24.154 -24.177  1.00 34.84           C  
ATOM    430  CD  GLU A  55      -7.613  25.337 -24.591  1.00 37.40           C  
ATOM    431  OE1 GLU A  55      -8.302  25.897 -23.706  1.00 34.28           O  
ATOM    432  OE2 GLU A  55      -7.646  25.713 -25.812  1.00 35.89           O  
ATOM    433  N   LEU A  56      -5.957  22.878 -19.745  1.00 35.39           N  
ATOM    434  CA  LEU A  56      -5.488  23.079 -18.380  1.00 35.41           C  
ATOM    435  C   LEU A  56      -4.613  21.907 -17.914  1.00 36.30           C  
ATOM    436  O   LEU A  56      -3.635  22.105 -17.206  1.00 36.93           O  
ATOM    437  CB  LEU A  56      -6.714  23.237 -17.471  1.00 33.99           C  
ATOM    438  CG  LEU A  56      -6.530  23.756 -16.056  1.00 33.16           C  
ATOM    439  CD1 LEU A  56      -5.644  25.040 -15.917  1.00 28.87           C  
ATOM    440  CD2 LEU A  56      -7.969  24.007 -15.481  1.00 34.41           C  
ATOM    441  N   ALA A  57      -4.971  20.705 -18.333  1.00 36.90           N  
ATOM    442  CA  ALA A  57      -4.259  19.499 -17.961  1.00 39.31           C  
ATOM    443  C   ALA A  57      -2.845  19.572 -18.568  1.00 40.87           C  
ATOM    444  O   ALA A  57      -1.840  19.414 -17.860  1.00 41.87           O  
ATOM    445  CB  ALA A  57      -5.011  18.295 -18.483  1.00 38.86           C  
ATOM    446  N   GLN A  58      -2.790  19.861 -19.871  1.00 42.34           N  
ATOM    447  CA  GLN A  58      -1.540  20.152 -20.580  1.00 44.04           C  
ATOM    448  C   GLN A  58      -0.635  21.053 -19.756  1.00 43.80           C  
ATOM    449  O   GLN A  58       0.472  20.642 -19.385  1.00 44.41           O  
ATOM    450  CB  GLN A  58      -1.805  20.729 -21.984  1.00 43.62           C  
ATOM    451  CG  GLN A  58      -2.112  19.645 -23.022  1.00 46.68           C  
ATOM    452  CD  GLN A  58      -2.626  20.158 -24.383  1.00 47.97           C  
ATOM    453  OE1 GLN A  58      -2.798  21.383 -24.616  1.00 50.62           O  
ATOM    454  NE2 GLN A  58      -2.892  19.206 -25.292  1.00 51.23           N  
ATOM    455  N   SER A  59      -1.111  22.243 -19.407  1.00 43.55           N  
ATOM    456  CA  SER A  59      -0.229  23.236 -18.812  1.00 44.26           C  
ATOM    457  C   SER A  59       0.110  23.021 -17.342  1.00 44.72           C  
ATOM    458  O   SER A  59       1.201  23.399 -16.907  1.00 45.52           O  
ATOM    459  CB  SER A  59      -0.726  24.670 -19.085  1.00 44.64           C  
ATOM    460  OG  SER A  59      -1.477  25.248 -18.043  1.00 44.93           O  
ATOM    461  N   VAL A  60      -0.831  22.453 -16.586  1.00 44.66           N  
ATOM    462  CA  VAL A  60      -0.643  22.163 -15.167  1.00 44.94           C  
ATOM    463  C   VAL A  60       0.268  20.946 -14.987  1.00 44.89           C  
ATOM    464  O   VAL A  60       0.982  20.813 -13.967  1.00 44.75           O  
ATOM    465  CB  VAL A  60      -1.993  21.884 -14.511  1.00 45.21           C  
ATOM    466  CG1 VAL A  60      -1.810  21.075 -13.247  1.00 45.29           C  
ATOM    467  CG2 VAL A  60      -2.708  23.195 -14.240  1.00 45.22           C  
ATOM    468  N   GLY A  61       0.134  20.029 -15.947  1.00 44.86           N  
ATOM    469  CA  GLY A  61       1.069  18.954 -16.215  1.00 44.76           C  
ATOM    470  C   GLY A  61       0.602  17.599 -15.752  1.00 44.88           C  
ATOM    471  O   GLY A  61       1.394  16.811 -15.253  1.00 44.55           O  
ATOM    472  N   VAL A  62      -0.690  17.332 -15.920  1.00 44.31           N  
ATOM    473  CA  VAL A  62      -1.343  16.235 -15.227  1.00 43.77           C  
ATOM    474  C   VAL A  62      -2.266  15.632 -16.257  1.00 43.45           C  
ATOM    475  O   VAL A  62      -2.702  16.340 -17.190  1.00 43.42           O  
ATOM    476  CB  VAL A  62      -2.114  16.816 -14.006  1.00 43.49           C  
ATOM    477  CG1 VAL A  62      -3.567  17.072 -14.339  1.00 44.16           C  
ATOM    478  CG2 VAL A  62      -1.957  15.967 -12.753  1.00 45.36           C  
ATOM    479  N   GLU A  63      -2.553  14.333 -16.107  0.50 42.82           N  
ATOM    481  CA  GLU A  63      -3.527  13.604 -16.940  0.50 42.55           C  
ATOM    483  C   GLU A  63      -4.925  14.177 -16.711  0.50 42.08           C  
ATOM    485  O   GLU A  63      -5.202  14.692 -15.629  0.50 42.33           O  
ATOM    487  CB  GLU A  63      -3.527  12.120 -16.557  0.50 42.50           C  
ATOM    489  CG  GLU A  63      -4.166  11.149 -17.564  0.50 42.74           C  
ATOM    491  CD  GLU A  63      -4.340   9.743 -16.983  0.50 42.13           C  
ATOM    493  OE1 GLU A  63      -4.222   9.611 -15.749  0.50 40.20           O  
ATOM    495  OE2 GLU A  63      -4.606   8.780 -17.744  0.50 40.03           O  
ATOM    497  N   GLY A  64      -5.794  14.063 -17.717  1.00 41.68           N  
ATOM    498  CA  GLY A  64      -7.170  14.550 -17.645  1.00 40.60           C  
ATOM    499  C   GLY A  64      -8.014  14.078 -16.471  1.00 40.15           C  
ATOM    500  O   GLY A  64      -8.593  14.909 -15.775  1.00 39.56           O  
ATOM    501  N   PRO A  65      -8.147  12.752 -16.285  1.00 39.30           N  
ATOM    502  CA  PRO A  65      -8.806  12.203 -15.078  1.00 38.20           C  
ATOM    503  C   PRO A  65      -8.279  12.707 -13.712  1.00 36.67           C  
ATOM    504  O   PRO A  65      -9.048  12.798 -12.743  1.00 35.01           O  
ATOM    505  CB  PRO A  65      -8.568  10.685 -15.190  1.00 38.63           C  
ATOM    506  CG  PRO A  65      -7.675  10.480 -16.413  1.00 38.57           C  
ATOM    507  CD  PRO A  65      -7.834  11.696 -17.265  1.00 40.23           C  
ATOM    508  N   THR A  66      -6.973  12.959 -13.628  1.00 35.33           N  
ATOM    509  CA  THR A  66      -6.409  13.562 -12.449  1.00 33.92           C  
ATOM    510  C   THR A  66      -6.935  14.964 -12.325  1.00 32.70           C  
ATOM    511  O   THR A  66      -7.392  15.350 -11.247  1.00 31.44           O  
ATOM    512  CB  THR A  66      -4.868  13.586 -12.475  1.00 33.95           C  
ATOM    513  OG1 THR A  66      -4.413  12.239 -12.471  1.00 36.73           O  
ATOM    514  CG2 THR A  66      -4.331  14.236 -11.239  1.00 34.49           C  
ATOM    515  N   LEU A  67      -6.893  15.736 -13.415  1.00 31.52           N  
ATOM    516  CA  LEU A  67      -7.407  17.120 -13.324  1.00 29.85           C  
ATOM    517  C   LEU A  67      -8.913  17.102 -12.920  1.00 27.53           C  
ATOM    518  O   LEU A  67      -9.339  17.961 -12.203  1.00 25.05           O  
ATOM    519  CB  LEU A  67      -7.204  17.942 -14.631  1.00 27.92           C  
ATOM    520  CG  LEU A  67      -7.542  19.431 -14.537  1.00 31.23           C  
ATOM    521  CD1 LEU A  67      -6.691  20.195 -13.528  1.00 32.30           C  
ATOM    522  CD2 LEU A  67      -7.541  20.107 -15.920  1.00 33.18           C  
ATOM    523  N   ALA A  68      -9.704  16.167 -13.424  1.00 28.56           N  
ATOM    524  CA  ALA A  68     -11.145  16.166 -13.108  1.00 28.43           C  
ATOM    525  C   ALA A  68     -11.366  16.134 -11.592  1.00 27.09           C  
ATOM    526  O   ALA A  68     -12.214  16.859 -11.111  1.00 25.49           O  
ATOM    527  CB  ALA A  68     -11.878  15.018 -13.752  1.00 30.49           C  
ATOM    528  N   ARG A  69     -10.602  15.292 -10.890  1.00 26.75           N  
ATOM    529  CA  ARG A  69     -10.629  15.244  -9.407  1.00 25.47           C  
ATOM    530  C   ARG A  69     -10.203  16.531  -8.747  1.00 23.24           C  
ATOM    531  O   ARG A  69     -10.866  16.963  -7.811  1.00 19.54           O  
ATOM    532  CB  ARG A  69      -9.762  14.115  -8.865  1.00 27.14           C  
ATOM    533  CG  ARG A  69     -10.128  12.751  -9.392  1.00 29.66           C  
ATOM    534  CD  ARG A  69     -11.228  12.114  -8.575  1.00 34.87           C  
ATOM    535  NE  ARG A  69     -11.462  10.710  -8.921  1.00 36.60           N  
ATOM    536  CZ  ARG A  69     -11.054   9.651  -8.217  1.00 34.83           C  
ATOM    537  NH1 ARG A  69     -10.314   9.800  -7.094  1.00 35.39           N  
ATOM    538  NH2 ARG A  69     -11.398   8.435  -8.638  1.00 23.30           N  
ATOM    539  N   LEU A  70      -9.060  17.115  -9.183  1.00 21.82           N  
ATOM    540  CA  LEU A  70      -8.598  18.408  -8.724  1.00 21.53           C  
ATOM    541  C   LEU A  70      -9.662  19.451  -8.906  1.00 21.22           C  
ATOM    542  O   LEU A  70      -9.939  20.191  -7.974  1.00 22.02           O  
ATOM    543  CB  LEU A  70      -7.309  18.845  -9.486  1.00 22.20           C  
ATOM    544  CG  LEU A  70      -6.167  17.877  -9.268  1.00 26.45           C  
ATOM    545  CD1 LEU A  70      -4.968  18.375 -10.100  1.00 31.50           C  
ATOM    546  CD2 LEU A  70      -5.812  17.742  -7.745  1.00 27.74           C  
ATOM    547  N   LEU A  71     -10.294  19.439 -10.091  1.00 19.50           N  
ATOM    548  CA  LEU A  71     -11.311  20.445 -10.391  1.00 20.78           C  
ATOM    549  C   LEU A  71     -12.539  20.236  -9.454  1.00 18.49           C  
ATOM    550  O   LEU A  71     -13.115  21.226  -9.033  1.00 19.40           O  
ATOM    551  CB  LEU A  71     -11.730  20.399 -11.860  1.00 20.27           C  
ATOM    552  CG  LEU A  71     -10.685  20.980 -12.837  1.00 22.71           C  
ATOM    553  CD1 LEU A  71     -11.102  20.649 -14.226  1.00 21.30           C  
ATOM    554  CD2 LEU A  71     -10.525  22.521 -12.658  1.00 24.11           C  
ATOM    555  N   ASP A  72     -12.931  18.979  -9.191  1.00 19.20           N  
ATOM    556  CA  ASP A  72     -14.098  18.718  -8.277  1.00 18.01           C  
ATOM    557  C   ASP A  72     -13.827  19.385  -6.917  1.00 17.66           C  
ATOM    558  O   ASP A  72     -14.684  20.039  -6.323  1.00 18.07           O  
ATOM    559  CB  ASP A  72     -14.286  17.227  -7.960  1.00 18.72           C  
ATOM    560  CG  ASP A  72     -14.874  16.409  -9.134  1.00 24.68           C  
ATOM    561  OD1 ASP A  72     -15.447  17.004 -10.063  1.00 24.98           O  
ATOM    562  OD2 ASP A  72     -14.683  15.159  -9.102  1.00 33.44           O  
ATOM    563  N   GLY A  73     -12.598  19.225  -6.438  1.00 17.32           N  
ATOM    564  CA  GLY A  73     -12.171  19.882  -5.229  1.00 18.36           C  
ATOM    565  C   GLY A  73     -12.315  21.385  -5.263  1.00 17.75           C  
ATOM    566  O   GLY A  73     -12.911  21.957  -4.372  1.00 20.09           O  
ATOM    567  N   LEU A  74     -11.814  22.031  -6.310  1.00 16.76           N  
ATOM    568  CA  LEU A  74     -11.844  23.451  -6.362  1.00 16.69           C  
ATOM    569  C   LEU A  74     -13.319  23.944  -6.540  1.00 16.01           C  
ATOM    570  O   LEU A  74     -13.695  24.942  -6.021  1.00 17.22           O  
ATOM    571  CB  LEU A  74     -11.053  23.875  -7.609  1.00 17.32           C  
ATOM    572  CG  LEU A  74      -9.519  23.721  -7.406  1.00 17.81           C  
ATOM    573  CD1 LEU A  74      -8.836  24.210  -8.693  1.00 22.02           C  
ATOM    574  CD2 LEU A  74      -9.077  24.560  -6.221  1.00 21.38           C  
ATOM    575  N   GLU A  75     -14.070  23.200  -7.335  1.00 17.81           N  
ATOM    576  CA  GLU A  75     -15.490  23.557  -7.649  1.00 17.97           C  
ATOM    577  C   GLU A  75     -16.341  23.436  -6.358  1.00 17.38           C  
ATOM    578  O   GLU A  75     -17.219  24.304  -6.026  1.00 16.79           O  
ATOM    579  CB  GLU A  75     -15.970  22.565  -8.702  1.00 18.68           C  
ATOM    580  CG  GLU A  75     -17.271  22.991  -9.386  1.00 23.90           C  
ATOM    581  CD  GLU A  75     -17.651  22.022 -10.491  1.00 23.04           C  
ATOM    582  OE1 GLU A  75     -18.450  22.474 -11.281  1.00 34.90           O  
ATOM    583  OE2 GLU A  75     -17.242  20.806 -10.540  1.00 32.24           O  
ATOM    584  N   SER A  76     -16.066  22.365  -5.603  1.00 18.22           N  
ATOM    585  CA  SER A  76     -16.704  22.190  -4.285  1.00 19.47           C  
ATOM    586  C   SER A  76     -16.493  23.373  -3.329  1.00 20.74           C  
ATOM    587  O   SER A  76     -17.368  23.699  -2.522  1.00 20.25           O  
ATOM    588  CB  SER A  76     -16.259  20.876  -3.615  1.00 19.63           C  
ATOM    589  OG  SER A  76     -14.933  20.970  -3.091  1.00 23.82           O  
ATOM    590  N   GLN A  77     -15.343  24.029  -3.458  1.00 22.14           N  
ATOM    591  CA  GLN A  77     -14.967  25.170  -2.630  1.00 24.80           C  
ATOM    592  C   GLN A  77     -15.434  26.506  -3.280  1.00 23.86           C  
ATOM    593  O   GLN A  77     -15.169  27.616  -2.763  1.00 26.32           O  
ATOM    594  CB  GLN A  77     -13.428  25.151  -2.343  1.00 25.64           C  
ATOM    595  CG  GLN A  77     -12.781  23.847  -1.691  1.00 29.24           C  
ATOM    596  CD  GLN A  77     -11.176  23.736  -1.784  1.00 29.31           C  
ATOM    597  OE1 GLN A  77     -10.563  23.574  -2.877  1.00 30.10           O  
ATOM    598  NE2 GLN A  77     -10.524  23.775  -0.622  1.00 38.04           N  
ATOM    599  N   GLY A  78     -16.179  26.420  -4.397  1.00 20.30           N  
ATOM    600  CA  GLY A  78     -16.707  27.619  -5.038  1.00 19.38           C  
ATOM    601  C   GLY A  78     -15.619  28.489  -5.705  1.00 19.88           C  
ATOM    602  O   GLY A  78     -15.813  29.695  -5.874  1.00 21.12           O  
ATOM    603  N   LEU A  79     -14.497  27.871  -6.061  1.00 17.34           N  
ATOM    604  CA  LEU A  79     -13.345  28.609  -6.642  1.00 18.53           C  
ATOM    605  C   LEU A  79     -13.357  28.593  -8.178  1.00 19.10           C  
ATOM    606  O   LEU A  79     -12.793  29.506  -8.859  1.00 18.09           O  
ATOM    607  CB  LEU A  79     -12.022  28.062  -6.095  1.00 18.17           C  
ATOM    608  CG  LEU A  79     -11.888  28.206  -4.580  1.00 18.24           C  
ATOM    609  CD1 LEU A  79     -10.607  27.441  -4.063  1.00 21.90           C  
ATOM    610  CD2 LEU A  79     -11.897  29.668  -4.083  1.00 18.77           C  
ATOM    611  N   VAL A  80     -13.933  27.531  -8.751  1.00 16.19           N  
ATOM    612  CA  VAL A  80     -14.062  27.459 -10.193  1.00 18.96           C  
ATOM    613  C   VAL A  80     -15.483  27.080 -10.617  1.00 21.16           C  
ATOM    614  O   VAL A  80     -16.216  26.512  -9.823  1.00 20.12           O  
ATOM    615  CB  VAL A  80     -13.114  26.424 -10.854  1.00 18.60           C  
ATOM    616  CG1 VAL A  80     -11.553  26.742 -10.520  1.00 18.84           C  
ATOM    617  CG2 VAL A  80     -13.399  25.029 -10.444  1.00 19.91           C  
ATOM    618  N   ARG A  81     -15.821  27.401 -11.867  1.00 20.67           N  
ATOM    619  CA  ARG A  81     -17.028  26.889 -12.558  1.00 22.80           C  
ATOM    620  C   ARG A  81     -16.626  26.328 -13.893  1.00 23.76           C  
ATOM    621  O   ARG A  81     -15.564  26.711 -14.460  1.00 22.75           O  
ATOM    622  CB  ARG A  81     -18.069  27.994 -12.726  1.00 23.98           C  
ATOM    623  CG  ARG A  81     -18.565  28.498 -11.385  1.00 25.19           C  
ATOM    624  CD  ARG A  81     -19.630  29.496 -11.573  1.00 30.01           C  
ATOM    625  NE  ARG A  81     -20.891  28.890 -12.050  1.00 30.08           N  
ATOM    626  CZ  ARG A  81     -21.857  29.607 -12.601  1.00 30.44           C  
ATOM    627  NH1 ARG A  81     -22.986  29.039 -13.041  1.00 29.42           N  
ATOM    628  NH2 ARG A  81     -21.657  30.897 -12.745  1.00 33.97           N  
ATOM    629  N   ARG A  82     -17.409  25.352 -14.369  1.00 25.75           N  
ATOM    630  CA  ARG A  82     -17.246  24.854 -15.734  1.00 29.76           C  
ATOM    631  C   ARG A  82     -18.415  25.336 -16.573  1.00 30.99           C  
ATOM    632  O   ARG A  82     -19.563  24.955 -16.298  1.00 32.16           O  
ATOM    633  CB  ARG A  82     -17.166  23.346 -15.705  1.00 30.53           C  
ATOM    634  CG  ARG A  82     -16.090  22.880 -14.764  1.00 32.85           C  
ATOM    635  CD  ARG A  82     -16.294  21.431 -14.623  1.00 35.95           C  
ATOM    636  NE  ARG A  82     -16.120  21.021 -13.248  1.00 40.34           N  
ATOM    637  CZ  ARG A  82     -15.366  20.002 -12.882  1.00 40.14           C  
ATOM    638  NH1 ARG A  82     -14.734  19.313 -13.811  1.00 42.02           N  
ATOM    639  NH2 ARG A  82     -15.269  19.665 -11.599  1.00 40.98           N  
ATOM    640  N   LEU A  83     -18.119  26.179 -17.570  1.00 34.01           N  
ATOM    641  CA  LEU A  83     -19.099  27.040 -18.253  1.00 36.48           C  
ATOM    642  C   LEU A  83     -18.856  27.062 -19.761  1.00 38.40           C  
ATOM    643  O   LEU A  83     -17.757  26.772 -20.205  1.00 38.98           O  
ATOM    644  CB  LEU A  83     -19.044  28.490 -17.745  1.00 36.93           C  
ATOM    645  CG  LEU A  83     -19.718  28.815 -16.404  1.00 37.81           C  
ATOM    646  CD1 LEU A  83     -19.421  30.262 -15.955  1.00 40.02           C  
ATOM    647  CD2 LEU A  83     -21.223  28.623 -16.505  1.00 39.81           C  
ATOM    648  N   ALA A  84     -19.891  27.422 -20.530  1.00 39.68           N  
ATOM    649  CA  ALA A  84     -19.768  27.702 -21.970  1.00 40.83           C  
ATOM    650  C   ALA A  84     -19.378  29.158 -22.074  1.00 41.44           C  
ATOM    651  O   ALA A  84     -19.834  29.995 -21.285  1.00 42.10           O  
ATOM    652  CB  ALA A  84     -21.085  27.461 -22.689  1.00 40.85           C  
ATOM    653  N   VAL A  85     -18.511  29.475 -23.024  1.00 42.03           N  
ATOM    654  CA  VAL A  85     -17.976  30.832 -23.087  1.00 42.51           C  
ATOM    655  C   VAL A  85     -18.256  31.574 -24.409  1.00 43.62           C  
ATOM    656  O   VAL A  85     -17.999  32.766 -24.515  1.00 43.39           O  
ATOM    657  CB  VAL A  85     -16.458  30.855 -22.779  1.00 42.53           C  
ATOM    658  CG1 VAL A  85     -16.220  30.357 -21.365  1.00 41.82           C  
ATOM    659  CG2 VAL A  85     -15.668  30.020 -23.819  1.00 40.69           C  
ATOM    660  N   ALA A  86     -18.771  30.861 -25.409  1.00 44.51           N  
ATOM    661  CA  ALA A  86     -19.136  31.502 -26.679  1.00 45.66           C  
ATOM    662  C   ALA A  86     -20.274  30.755 -27.341  1.00 46.32           C  
ATOM    663  O   ALA A  86     -20.543  29.591 -27.004  1.00 45.88           O  
ATOM    664  CB  ALA A  86     -17.939  31.563 -27.623  1.00 44.97           C  
ATOM    665  N   GLU A  87     -20.910  31.442 -28.292  0.50 46.99           N  
ATOM    667  CA  GLU A  87     -21.917  30.884 -29.190  0.50 47.62           C  
ATOM    669  C   GLU A  87     -21.369  29.669 -29.963  0.50 47.65           C  
ATOM    671  O   GLU A  87     -22.133  28.779 -30.360  0.50 48.17           O  
ATOM    673  CB  GLU A  87     -22.391  31.979 -30.162  0.50 47.85           C  
ATOM    675  CG  GLU A  87     -22.493  33.397 -29.542  0.50 47.99           C  
ATOM    677  CD  GLU A  87     -21.206  34.204 -29.656  0.50 48.70           C  
ATOM    679  OE1 GLU A  87     -20.947  34.742 -30.758  0.50 48.05           O  
ATOM    681  OE2 GLU A  87     -20.462  34.310 -28.647  0.50 48.13           O  
ATOM    683  N   ASP A  88     -20.046  29.639 -30.144  1.00 47.55           N  
ATOM    684  CA  ASP A  88     -19.305  28.544 -30.825  1.00 46.77           C  
ATOM    685  C   ASP A  88     -18.191  27.976 -29.952  1.00 45.93           C  
ATOM    686  O   ASP A  88     -17.212  27.412 -30.456  1.00 45.44           O  
ATOM    687  CB  ASP A  88     -18.717  29.013 -32.177  1.00 47.31           C  
ATOM    688  CG  ASP A  88     -17.774  30.216 -32.037  1.00 48.51           C  
ATOM    689  OD1 ASP A  88     -17.002  30.482 -32.999  1.00 48.84           O  
ATOM    690  OD2 ASP A  88     -17.801  30.894 -30.974  1.00 49.90           O  
ATOM    691  N   ARG A  89     -18.317  28.166 -28.637  1.00 44.68           N  
ATOM    692  CA  ARG A  89     -17.476  27.449 -27.679  1.00 43.50           C  
ATOM    693  C   ARG A  89     -18.400  26.994 -26.570  1.00 43.69           C  
ATOM    694  O   ARG A  89     -18.530  27.623 -25.493  1.00 43.25           O  
ATOM    695  CB  ARG A  89     -16.320  28.301 -27.145  1.00 42.76           C  
ATOM    696  CG  ARG A  89     -15.312  28.762 -28.205  1.00 41.94           C  
ATOM    697  CD  ARG A  89     -14.316  27.647 -28.662  1.00 42.07           C  
ATOM    698  NE  ARG A  89     -13.585  26.975 -27.570  1.00 39.45           N  
ATOM    699  CZ  ARG A  89     -12.776  25.927 -27.769  1.00 41.55           C  
ATOM    700  NH1 ARG A  89     -12.152  25.321 -26.746  1.00 40.17           N  
ATOM    701  NH2 ARG A  89     -12.589  25.475 -29.007  1.00 37.12           N  
ATOM    702  N   ARG A  90     -19.033  25.874 -26.880  1.00 43.49           N  
ATOM    703  CA  ARG A  90     -20.098  25.287 -26.101  1.00 43.44           C  
ATOM    704  C   ARG A  90     -19.601  24.242 -25.112  1.00 42.63           C  
ATOM    705  O   ARG A  90     -20.348  23.876 -24.192  1.00 42.67           O  
ATOM    706  CB  ARG A  90     -21.090  24.618 -27.073  1.00 43.93           C  
ATOM    707  N   ALA A  91     -18.382  23.731 -25.329  1.00 40.93           N  
ATOM    708  CA  ALA A  91     -17.718  22.845 -24.380  1.00 40.87           C  
ATOM    709  C   ALA A  91     -17.535  23.596 -23.074  1.00 40.28           C  
ATOM    710  O   ALA A  91     -17.658  24.822 -23.008  1.00 40.08           O  
ATOM    711  CB  ALA A  91     -16.362  22.368 -24.899  1.00 40.52           C  
ATOM    712  N   LYS A  92     -17.259  22.848 -22.025  1.00 40.55           N  
ATOM    713  CA  LYS A  92     -17.084  23.472 -20.737  1.00 40.39           C  
ATOM    714  C   LYS A  92     -15.659  24.048 -20.689  1.00 39.25           C  
ATOM    715  O   LYS A  92     -14.666  23.373 -21.086  1.00 40.46           O  
ATOM    716  CB  LYS A  92     -17.398  22.490 -19.592  1.00 41.89           C  
ATOM    717  CG  LYS A  92     -18.816  22.630 -19.003  1.00 43.56           C  
ATOM    718  CD  LYS A  92     -19.791  21.673 -19.651  1.00 48.72           C  
ATOM    719  CE  LYS A  92     -19.391  20.218 -19.406  1.00 51.69           C  
ATOM    720  NZ  LYS A  92     -19.702  19.356 -20.600  1.00 53.08           N  
ATOM    721  N   HIS A  93     -15.594  25.313 -20.262  1.00 35.94           N  
ATOM    722  CA  HIS A  93     -14.354  26.001 -20.025  1.00 33.71           C  
ATOM    723  C   HIS A  93     -14.272  26.284 -18.543  1.00 31.96           C  
ATOM    724  O   HIS A  93     -15.308  26.394 -17.864  1.00 30.46           O  
ATOM    725  CB  HIS A  93     -14.310  27.281 -20.837  1.00 34.25           C  
ATOM    726  CG  HIS A  93     -14.195  27.026 -22.310  1.00 37.10           C  
ATOM    727  ND1 HIS A  93     -15.269  26.620 -23.083  1.00 40.49           N  
ATOM    728  CD2 HIS A  93     -13.124  27.057 -23.138  1.00 38.97           C  
ATOM    729  CE1 HIS A  93     -14.863  26.443 -24.332  1.00 40.72           C  
ATOM    730  NE2 HIS A  93     -13.568  26.713 -24.395  1.00 39.40           N  
ATOM    731  N   ILE A  94     -13.055  26.330 -18.028  1.00 28.53           N  
ATOM    732  CA  ILE A  94     -12.909  26.432 -16.582  1.00 26.89           C  
ATOM    733  C   ILE A  94     -12.699  27.885 -16.286  1.00 26.13           C  
ATOM    734  O   ILE A  94     -11.844  28.521 -16.856  1.00 25.31           O  
ATOM    735  CB  ILE A  94     -11.803  25.509 -16.056  1.00 26.68           C  
ATOM    736  CG1 ILE A  94     -12.168  24.067 -16.427  1.00 28.85           C  
ATOM    737  CG2 ILE A  94     -11.742  25.655 -14.533  1.00 24.83           C  
ATOM    738  CD1 ILE A  94     -11.202  23.439 -17.235  1.00 34.33           C  
ATOM    739  N   VAL A  95     -13.525  28.446 -15.436  1.00 24.50           N  
ATOM    740  CA  VAL A  95     -13.472  29.848 -15.151  1.00 25.27           C  
ATOM    741  C   VAL A  95     -13.322  30.022 -13.631  1.00 25.59           C  
ATOM    742  O   VAL A  95     -13.965  29.313 -12.843  1.00 24.70           O  
ATOM    743  CB  VAL A  95     -14.789  30.554 -15.628  1.00 27.57           C  
ATOM    744  CG1 VAL A  95     -14.720  32.045 -15.354  1.00 30.57           C  
ATOM    745  CG2 VAL A  95     -15.042  30.266 -17.124  1.00 28.73           C  
ATOM    746  N   LEU A  96     -12.537  31.006 -13.214  1.00 22.83           N  
ATOM    747  CA  LEU A  96     -12.506  31.388 -11.810  1.00 23.13           C  
ATOM    748  C   LEU A  96     -13.743  32.151 -11.406  1.00 23.37           C  
ATOM    749  O   LEU A  96     -14.318  32.905 -12.211  1.00 24.21           O  
ATOM    750  CB  LEU A  96     -11.307  32.318 -11.529  1.00 24.01           C  
ATOM    751  CG  LEU A  96      -9.942  31.696 -11.795  1.00 23.02           C  
ATOM    752  CD1 LEU A  96      -8.833  32.797 -11.869  1.00 25.66           C  
ATOM    753  CD2 LEU A  96      -9.649  30.786 -10.614  1.00 25.57           C  
ATOM    754  N   THR A  97     -14.061  32.056 -10.130  1.00 23.73           N  
ATOM    755  CA  THR A  97     -15.121  32.855  -9.537  1.00 24.08           C  
ATOM    756  C   THR A  97     -14.567  34.088  -8.819  1.00 27.02           C  
ATOM    757  O   THR A  97     -13.399  34.114  -8.401  1.00 27.28           O  
ATOM    758  CB  THR A  97     -15.883  32.038  -8.460  1.00 24.29           C  
ATOM    759  OG1 THR A  97     -14.972  31.699  -7.411  1.00 22.39           O  
ATOM    760  CG2 THR A  97     -16.506  30.739  -9.020  1.00 21.46           C  
ATOM    761  N   PRO A  98     -15.415  35.113  -8.637  1.00 28.35           N  
ATOM    762  CA  PRO A  98     -15.109  36.265  -7.789  1.00 29.61           C  
ATOM    763  C   PRO A  98     -14.612  35.838  -6.395  1.00 30.53           C  
ATOM    764  O   PRO A  98     -13.649  36.418  -5.902  1.00 31.68           O  
ATOM    765  CB  PRO A  98     -16.461  36.983  -7.722  1.00 28.88           C  
ATOM    766  CG  PRO A  98     -16.936  36.828  -9.105  1.00 29.42           C  
ATOM    767  CD  PRO A  98     -16.719  35.304  -9.314  1.00 28.97           C  
ATOM    768  N   LYS A  99     -15.206  34.791  -5.820  1.00 30.08           N  
ATOM    769  CA  LYS A  99     -14.727  34.238  -4.555  1.00 32.63           C  
ATOM    770  C   LYS A  99     -13.268  33.931  -4.611  1.00 31.09           C  
ATOM    771  O   LYS A  99     -12.588  34.048  -3.594  1.00 33.86           O  
ATOM    772  CB  LYS A  99     -15.437  32.941  -4.148  1.00 33.13           C  
ATOM    773  CG  LYS A  99     -14.951  32.436  -2.761  1.00 37.67           C  
ATOM    774  CD  LYS A  99     -15.688  31.182  -2.237  1.00 35.87           C  
ATOM    775  CE  LYS A  99     -14.866  30.578  -1.053  1.00 37.97           C  
ATOM    776  NZ  LYS A  99     -15.258  29.204  -0.566  1.00 39.91           N  
ATOM    777  N   ALA A 100     -12.798  33.462  -5.759  1.00 29.42           N  
ATOM    778  CA  ALA A 100     -11.435  32.990  -5.856  1.00 28.42           C  
ATOM    779  C   ALA A 100     -10.441  34.151  -5.812  1.00 29.39           C  
ATOM    780  O   ALA A 100      -9.245  33.906  -5.633  1.00 27.75           O  
ATOM    781  CB  ALA A 100     -11.222  32.214  -7.126  1.00 28.32           C  
ATOM    782  N   ASP A 101     -10.891  35.399  -6.008  1.00 30.75           N  
ATOM    783  CA  ASP A 101      -9.879  36.468  -6.246  1.00 29.67           C  
ATOM    784  C   ASP A 101      -9.044  36.792  -5.031  1.00 30.31           C  
ATOM    785  O   ASP A 101      -7.835  37.035  -5.217  1.00 30.41           O  
ATOM    786  CB  ASP A 101     -10.434  37.751  -6.918  1.00 31.58           C  
ATOM    787  CG  ASP A 101      -9.290  38.770  -7.322  1.00 33.67           C  
ATOM    788  OD1 ASP A 101      -8.494  38.458  -8.272  1.00 33.94           O  
ATOM    789  OD2 ASP A 101      -9.176  39.860  -6.686  1.00 35.59           O  
ATOM    790  N   VAL A 102      -9.594  36.820  -3.809  1.00 28.93           N  
ATOM    791  CA  VAL A 102      -8.654  37.122  -2.686  1.00 30.43           C  
ATOM    792  C   VAL A 102      -7.668  35.982  -2.550  1.00 28.29           C  
ATOM    793  O   VAL A 102      -6.515  36.186  -2.163  1.00 29.06           O  
ATOM    794  CB  VAL A 102      -9.269  37.498  -1.260  1.00 30.82           C  
ATOM    795  CG1 VAL A 102     -10.021  38.832  -1.287  1.00 34.75           C  
ATOM    796  CG2 VAL A 102     -10.108  36.398  -0.690  1.00 33.98           C  
ATOM    797  N   LEU A 103      -8.107  34.788  -2.946  1.00 26.02           N  
ATOM    798  CA  LEU A 103      -7.247  33.645  -2.886  1.00 22.32           C  
ATOM    799  C   LEU A 103      -6.114  33.726  -3.919  1.00 20.62           C  
ATOM    800  O   LEU A 103      -4.945  33.553  -3.553  1.00 20.10           O  
ATOM    801  CB  LEU A 103      -8.047  32.339  -3.083  1.00 23.26           C  
ATOM    802  CG  LEU A 103      -7.182  31.099  -3.078  1.00 23.56           C  
ATOM    803  CD1 LEU A 103      -6.463  30.949  -1.669  1.00 26.73           C  
ATOM    804  CD2 LEU A 103      -8.119  29.913  -3.363  1.00 24.09           C  
ATOM    805  N   ILE A 104      -6.451  33.907  -5.187  1.00 19.56           N  
ATOM    806  CA  ILE A 104      -5.429  34.037  -6.240  1.00 19.70           C  
ATOM    807  C   ILE A 104      -4.475  35.177  -5.945  1.00 18.58           C  
ATOM    808  O   ILE A 104      -3.257  35.040  -6.195  1.00 16.67           O  
ATOM    809  CB  ILE A 104      -6.044  34.359  -7.595  1.00 21.87           C  
ATOM    810  CG1 ILE A 104      -6.972  33.214  -8.045  1.00 24.48           C  
ATOM    811  CG2 ILE A 104      -4.942  34.637  -8.652  1.00 24.69           C  
ATOM    812  CD1 ILE A 104      -6.311  32.010  -8.168  1.00 25.93           C  
ATOM    813  N   ALA A 105      -4.993  36.307  -5.459  1.00 17.91           N  
ATOM    814  CA  ALA A 105      -4.057  37.403  -5.108  1.00 19.14           C  
ATOM    815  C   ALA A 105      -2.963  36.931  -4.112  1.00 19.01           C  
ATOM    816  O   ALA A 105      -1.756  37.276  -4.248  1.00 18.30           O  
ATOM    817  CB  ALA A 105      -4.838  38.556  -4.539  1.00 22.37           C  
ATOM    818  N   ASP A 106      -3.378  36.198  -3.072  1.00 15.67           N  
ATOM    819  CA  ASP A 106      -2.451  35.678  -2.115  1.00 18.39           C  
ATOM    820  C   ASP A 106      -1.496  34.657  -2.709  1.00 15.17           C  
ATOM    821  O   ASP A 106      -0.331  34.701  -2.408  1.00 15.56           O  
ATOM    822  CB  ASP A 106      -3.170  35.090  -0.872  1.00 19.35           C  
ATOM    823  CG  ASP A 106      -3.869  36.173  -0.044  1.00 28.32           C  
ATOM    824  OD1 ASP A 106      -3.604  37.366  -0.288  1.00 32.66           O  
ATOM    825  OD2 ASP A 106      -4.718  35.838   0.818  1.00 36.84           O  
ATOM    826  N   ILE A 107      -1.991  33.753  -3.518  1.00 13.23           N  
ATOM    827  CA  ILE A 107      -1.151  32.758  -4.188  1.00 12.71           C  
ATOM    828  C   ILE A 107      -0.111  33.421  -5.105  1.00 13.77           C  
ATOM    829  O   ILE A 107       1.084  33.064  -5.075  1.00 12.15           O  
ATOM    830  CB  ILE A 107      -2.034  31.792  -5.019  1.00 12.86           C  
ATOM    831  CG1 ILE A 107      -2.959  31.025  -4.020  1.00 12.60           C  
ATOM    832  CG2 ILE A 107      -1.148  30.791  -5.851  1.00 12.54           C  
ATOM    833  CD1 ILE A 107      -3.873  30.041  -4.821  1.00 16.89           C  
ATOM    834  N   GLU A 108      -0.535  34.426  -5.875  0.50 12.58           N  
ATOM    836  CA  GLU A 108       0.456  35.111  -6.717  0.50 14.29           C  
ATOM    838  C   GLU A 108       1.504  35.858  -5.900  0.50 13.78           C  
ATOM    840  O   GLU A 108       2.669  35.856  -6.270  0.50 14.44           O  
ATOM    842  CB  GLU A 108      -0.203  36.020  -7.743  0.50 15.38           C  
ATOM    844  CG  GLU A 108      -0.852  35.238  -8.853  0.50 17.00           C  
ATOM    846  CD  GLU A 108       0.147  34.665  -9.845  0.50 22.71           C  
ATOM    848  OE1 GLU A 108      -0.152  34.696 -11.046  0.50 25.75           O  
ATOM    850  OE2 GLU A 108       1.241  34.217  -9.450  0.50 26.41           O  
ATOM    852  N   ALA A 109       1.095  36.487  -4.813  1.00 14.23           N  
ATOM    853  CA  ALA A 109       2.026  37.234  -3.994  1.00 13.94           C  
ATOM    854  C   ALA A 109       3.055  36.222  -3.438  1.00 13.42           C  
ATOM    855  O   ALA A 109       4.278  36.465  -3.417  1.00 12.01           O  
ATOM    856  CB  ALA A 109       1.318  37.970  -2.877  1.00 14.34           C  
ATOM    857  N   ILE A 110       2.543  35.072  -3.006  1.00 11.64           N  
ATOM    858  CA  ILE A 110       3.485  34.069  -2.408  1.00 12.04           C  
ATOM    859  C   ILE A 110       4.394  33.468  -3.488  1.00 12.06           C  
ATOM    860  O   ILE A 110       5.594  33.308  -3.261  1.00 12.29           O  
ATOM    861  CB  ILE A 110       2.667  32.963  -1.639  1.00 13.12           C  
ATOM    862  CG1 ILE A 110       1.994  33.611  -0.418  1.00 14.63           C  
ATOM    863  CG2 ILE A 110       3.547  31.809  -1.254  1.00 14.40           C  
ATOM    864  CD1 ILE A 110       0.896  32.694   0.277  1.00 10.55           C  
ATOM    865  N   ALA A 111       3.854  33.219  -4.686  1.00 12.52           N  
ATOM    866  CA  ALA A 111       4.664  32.707  -5.797  1.00 11.99           C  
ATOM    867  C   ALA A 111       5.760  33.764  -6.209  1.00 12.04           C  
ATOM    868  O   ALA A 111       6.917  33.375  -6.447  1.00 11.22           O  
ATOM    869  CB  ALA A 111       3.810  32.385  -6.983  1.00 11.33           C  
ATOM    870  N   ALA A 112       5.406  35.052  -6.200  1.00 11.64           N  
ATOM    871  CA  ALA A 112       6.404  36.115  -6.404  1.00 12.20           C  
ATOM    872  C   ALA A 112       7.479  36.106  -5.332  1.00 12.38           C  
ATOM    873  O   ALA A 112       8.663  36.281  -5.655  1.00 11.23           O  
ATOM    874  CB  ALA A 112       5.739  37.410  -6.483  1.00 13.36           C  
ATOM    875  N   SER A 113       7.100  35.870  -4.084  0.50 10.62           N  
ATOM    877  CA  SER A 113       8.096  35.791  -3.016  0.50 10.73           C  
ATOM    879  C   SER A 113       9.104  34.630  -3.262  0.50 11.30           C  
ATOM    881  O   SER A 113      10.320  34.774  -3.122  0.50 10.13           O  
ATOM    883  CB  SER A 113       7.401  35.624  -1.665  0.50 10.64           C  
ATOM    885  OG  SER A 113       8.358  35.877  -0.685  0.50  9.26           O  
ATOM    887  N   VAL A 114       8.584  33.461  -3.606  1.00 10.66           N  
ATOM    888  CA  VAL A 114       9.478  32.301  -3.830  1.00 11.24           C  
ATOM    889  C   VAL A 114      10.413  32.658  -5.012  1.00 11.51           C  
ATOM    890  O   VAL A 114      11.599  32.379  -4.966  1.00 12.39           O  
ATOM    891  CB  VAL A 114       8.661  31.036  -4.119  1.00 11.25           C  
ATOM    892  CG1 VAL A 114       9.602  29.892  -4.488  1.00 13.15           C  
ATOM    893  CG2 VAL A 114       7.826  30.649  -2.800  1.00 11.99           C  
ATOM    894  N   ARG A 115       9.846  33.256  -6.062  1.00 12.19           N  
ATOM    895  CA  ARG A 115      10.653  33.609  -7.296  1.00 14.68           C  
ATOM    896  C   ARG A 115      11.745  34.580  -6.917  1.00 15.07           C  
ATOM    897  O   ARG A 115      12.926  34.324  -7.212  1.00 15.94           O  
ATOM    898  CB  ARG A 115       9.688  34.187  -8.385  1.00 13.43           C  
ATOM    899  CG  ARG A 115      10.365  34.374  -9.738  1.00 17.05           C  
ATOM    900  CD  ARG A 115       9.394  35.064 -10.753  1.00 20.78           C  
ATOM    901  NE  ARG A 115       8.080  34.573 -10.577  1.00 24.06           N  
ATOM    902  CZ  ARG A 115       6.984  35.207 -10.144  1.00 23.01           C  
ATOM    903  NH1 ARG A 115       6.886  36.502  -9.871  1.00 25.33           N  
ATOM    904  NH2 ARG A 115       5.924  34.496 -10.027  1.00 20.57           N  
ATOM    905  N   ASN A 116      11.392  35.630  -6.185  1.00 13.67           N  
ATOM    906  CA  ASN A 116      12.417  36.555  -5.642  1.00 17.93           C  
ATOM    907  C   ASN A 116      13.527  35.820  -4.876  1.00 16.45           C  
ATOM    908  O   ASN A 116      14.747  36.043  -5.061  1.00 16.14           O  
ATOM    909  CB  ASN A 116      11.713  37.512  -4.684  1.00 19.15           C  
ATOM    910  CG  ASN A 116      12.586  38.604  -4.245  1.00 29.37           C  
ATOM    911  OD1 ASN A 116      12.907  39.492  -5.050  1.00 36.07           O  
ATOM    912  ND2 ASN A 116      13.017  38.563  -2.963  1.00 34.16           N  
ATOM    913  N   ASP A 117      13.141  34.961  -3.940  1.00 13.42           N  
ATOM    914  CA  ASP A 117      14.136  34.360  -3.125  1.00 12.07           C  
ATOM    915  C   ASP A 117      15.004  33.323  -3.879  1.00 13.16           C  
ATOM    916  O   ASP A 117      16.224  33.246  -3.662  1.00 14.24           O  
ATOM    917  CB  ASP A 117      13.441  33.607  -1.972  1.00 14.13           C  
ATOM    918  CG  ASP A 117      12.769  34.546  -0.974  1.00 16.68           C  
ATOM    919  OD1 ASP A 117      12.973  35.797  -1.075  1.00 15.89           O  
ATOM    920  OD2 ASP A 117      11.983  34.033  -0.124  1.00 15.77           O  
ATOM    921  N   VAL A 118      14.410  32.518  -4.732  1.00 11.16           N  
ATOM    922  CA  VAL A 118      15.190  31.488  -5.433  1.00 14.37           C  
ATOM    923  C   VAL A 118      16.140  32.117  -6.490  1.00 13.97           C  
ATOM    924  O   VAL A 118      17.145  31.513  -6.763  1.00 14.14           O  
ATOM    925  CB  VAL A 118      14.377  30.245  -5.941  1.00 16.44           C  
ATOM    926  CG1 VAL A 118      13.502  29.706  -4.837  1.00 18.55           C  
ATOM    927  CG2 VAL A 118      13.611  30.622  -7.167  1.00 13.92           C  
ATOM    928  N   LEU A 119      15.814  33.317  -6.955  1.00 13.50           N  
ATOM    929  CA  LEU A 119      16.677  34.042  -7.954  1.00 12.55           C  
ATOM    930  C   LEU A 119      17.746  34.848  -7.281  1.00 13.43           C  
ATOM    931  O   LEU A 119      18.528  35.535  -7.972  1.00 13.10           O  
ATOM    932  CB  LEU A 119      15.839  34.891  -8.892  1.00 14.22           C  
ATOM    933  CG  LEU A 119      14.952  33.924  -9.743  1.00 16.28           C  
ATOM    934  CD1 LEU A 119      14.013  34.742 -10.589  1.00 21.96           C  
ATOM    935  CD2 LEU A 119      15.744  32.759 -10.558  1.00 17.82           C  
ATOM    936  N   THR A 120      17.794  34.789  -5.928  1.00 12.51           N  
ATOM    937  CA  THR A 120      18.854  35.566  -5.243  1.00 12.24           C  
ATOM    938  C   THR A 120      20.236  35.260  -5.753  1.00  9.31           C  
ATOM    939  O   THR A 120      20.646  34.105  -5.848  1.00 12.14           O  
ATOM    940  CB  THR A 120      18.840  35.256  -3.721  1.00 14.43           C  
ATOM    941  OG1 THR A 120      17.538  35.677  -3.240  1.00 18.56           O  
ATOM    942  CG2 THR A 120      19.994  36.053  -2.968  1.00 15.09           C  
ATOM    943  N   GLY A 121      20.974  36.347  -6.071  1.00 11.54           N  
ATOM    944  CA  GLY A 121      22.387  36.135  -6.471  1.00 13.04           C  
ATOM    945  C   GLY A 121      22.551  35.830  -7.951  1.00 12.69           C  
ATOM    946  O   GLY A 121      23.658  35.633  -8.401  1.00 14.04           O  
ATOM    947  N   ILE A 122      21.434  35.689  -8.671  1.00 12.16           N  
ATOM    948  CA  ILE A 122      21.553  35.293 -10.117  1.00 10.32           C  
ATOM    949  C   ILE A 122      21.303  36.558 -10.942  1.00 11.10           C  
ATOM    950  O   ILE A 122      20.277  37.220 -10.811  1.00 13.03           O  
ATOM    951  CB  ILE A 122      20.499  34.188 -10.428  1.00 10.90           C  
ATOM    952  CG1 ILE A 122      20.873  32.940  -9.573  1.00 14.70           C  
ATOM    953  CG2 ILE A 122      20.526  33.796 -11.975  1.00 12.98           C  
ATOM    954  CD1 ILE A 122      19.798  31.957  -9.597  1.00 16.42           C  
ATOM    955  N   ASP A 123      22.295  36.871 -11.782  1.00 11.72           N  
ATOM    956  CA  ASP A 123      22.363  37.962 -12.664  1.00 16.22           C  
ATOM    957  C   ASP A 123      21.207  37.936 -13.664  1.00 15.38           C  
ATOM    958  O   ASP A 123      20.845  36.859 -14.107  1.00 13.76           O  
ATOM    959  CB  ASP A 123      23.657  37.581 -13.456  1.00 20.77           C  
ATOM    960  CG  ASP A 123      24.041  38.532 -14.365  1.00 24.65           C  
ATOM    961  OD1 ASP A 123      23.551  38.361 -15.467  1.00 25.16           O  
ATOM    962  OD2 ASP A 123      24.774  39.460 -13.970  1.00 28.73           O  
ATOM    963  N   GLU A 124      20.640  39.099 -13.994  1.00 15.14           N  
ATOM    964  CA  GLU A 124      19.544  39.201 -14.924  1.00 16.53           C  
ATOM    965  C   GLU A 124      19.978  38.605 -16.296  1.00 12.90           C  
ATOM    966  O   GLU A 124      19.144  37.921 -16.983  1.00 14.21           O  
ATOM    967  CB  GLU A 124      19.136  40.638 -15.174  1.00 18.05           C  
ATOM    968  CG  GLU A 124      18.080  41.133 -14.144  1.00 24.41           C  
ATOM    969  CD  GLU A 124      18.185  42.629 -13.833  1.00 33.06           C  
ATOM    970  OE1 GLU A 124      18.141  43.413 -14.820  1.00 31.41           O  
ATOM    971  OE2 GLU A 124      18.259  42.978 -12.608  1.00 36.73           O  
ATOM    972  N   SER A 125      21.198  38.865 -16.697  1.00 14.08           N  
ATOM    973  CA  SER A 125      21.646  38.333 -18.026  1.00 13.37           C  
ATOM    974  C   SER A 125      21.718  36.835 -18.038  1.00 12.32           C  
ATOM    975  O   SER A 125      21.359  36.134 -19.042  1.00 11.94           O  
ATOM    976  CB  SER A 125      23.028  38.865 -18.397  1.00 17.47           C  
ATOM    977  OG  SER A 125      22.803  40.274 -18.622  1.00 24.69           O  
ATOM    978  N   GLU A 126      22.225  36.311 -16.929  1.00  9.70           N  
ATOM    979  CA  GLU A 126      22.330  34.856 -16.825  1.00 10.07           C  
ATOM    980  C   GLU A 126      20.958  34.163 -16.711  1.00 10.16           C  
ATOM    981  O   GLU A 126      20.801  33.101 -17.315  1.00  9.67           O  
ATOM    982  CB  GLU A 126      23.294  34.437 -15.714  1.00 10.51           C  
ATOM    983  CG  GLU A 126      24.696  34.904 -16.056  1.00 10.71           C  
ATOM    984  CD  GLU A 126      25.730  34.496 -15.037  1.00  9.42           C  
ATOM    985  OE1 GLU A 126      25.360  33.904 -13.990  1.00 11.15           O  
ATOM    986  OE2 GLU A 126      26.947  34.694 -15.368  1.00 11.02           O  
ATOM    987  N   GLN A 127      20.013  34.783 -15.999  1.00  8.26           N  
ATOM    988  CA  GLN A 127      18.642  34.325 -15.989  1.00 10.93           C  
ATOM    989  C   GLN A 127      18.128  34.241 -17.450  1.00 11.00           C  
ATOM    990  O   GLN A 127      17.464  33.289 -17.812  1.00  9.74           O  
ATOM    991  CB  GLN A 127      17.760  35.256 -15.183  1.00 11.47           C  
ATOM    992  CG  GLN A 127      16.344  34.684 -15.088  1.00 16.55           C  
ATOM    993  CD  GLN A 127      15.427  35.566 -14.288  1.00 19.32           C  
ATOM    994  OE1 GLN A 127      15.889  36.350 -13.400  1.00 16.91           O  
ATOM    995  NE2 GLN A 127      14.094  35.400 -14.529  1.00 20.05           N  
ATOM    996  N   ALA A 128      18.325  35.327 -18.187  1.00 10.14           N  
ATOM    997  CA  ALA A 128      17.842  35.366 -19.574  1.00 11.10           C  
ATOM    998  C   ALA A 128      18.438  34.272 -20.440  1.00 10.72           C  
ATOM    999  O   ALA A 128      17.721  33.641 -21.284  1.00 12.06           O  
ATOM   1000  CB  ALA A 128      18.152  36.754 -20.108  1.00 13.28           C  
ATOM   1001  N   LEU A 129      19.743  34.036 -20.265  0.50  9.90           N  
ATOM   1003  CA  LEU A 129      20.436  33.002 -20.987  0.50 10.22           C  
ATOM   1005  C   LEU A 129      19.862  31.644 -20.589  0.50  9.87           C  
ATOM   1007  O   LEU A 129      19.595  30.791 -21.449  0.50 10.69           O  
ATOM   1009  CB  LEU A 129      21.945  33.053 -20.687  0.50  8.98           C  
ATOM   1011  CG  LEU A 129      22.778  32.056 -21.518  0.50  6.67           C  
ATOM   1013  CD1 LEU A 129      22.338  31.984 -23.055  0.50  5.30           C  
ATOM   1015  CD2 LEU A 129      24.247  32.292 -21.295  0.50  8.62           C  
ATOM   1017  N   CYS A 130      19.679  31.440 -19.276  1.00  8.80           N  
ATOM   1018  CA  CYS A 130      19.119  30.159 -18.760  1.00  9.80           C  
ATOM   1019  C   CYS A 130      17.747  29.914 -19.427  1.00 10.58           C  
ATOM   1020  O   CYS A 130      17.467  28.851 -19.894  1.00 10.07           O  
ATOM   1021  CB  CYS A 130      18.944  30.282 -17.232  1.00  9.92           C  
ATOM   1022  SG  CYS A 130      18.065  28.883 -16.501  1.00 14.40           S  
ATOM   1023  N   GLN A 131      16.895  30.930 -19.478  1.00 10.62           N  
ATOM   1024  CA  GLN A 131      15.609  30.808 -20.124  1.00 11.20           C  
ATOM   1025  C   GLN A 131      15.702  30.463 -21.574  1.00 12.78           C  
ATOM   1026  O   GLN A 131      14.931  29.600 -22.024  1.00 11.62           O  
ATOM   1027  CB  GLN A 131      14.819  32.076 -19.948  1.00 13.39           C  
ATOM   1028  CG  GLN A 131      14.417  32.255 -18.479  1.00 16.13           C  
ATOM   1029  CD  GLN A 131      13.945  33.759 -18.281  1.00 29.99           C  
ATOM   1030  OE1 GLN A 131      14.275  34.640 -19.080  1.00 32.51           O  
ATOM   1031  NE2 GLN A 131      13.236  34.014 -17.231  1.00 28.41           N  
ATOM   1032  N   GLN A 132      16.652  31.055 -22.307  1.00 13.07           N  
ATOM   1033  CA  GLN A 132      16.807  30.711 -23.749  1.00 13.03           C  
ATOM   1034  C   GLN A 132      17.230  29.233 -23.908  1.00 12.99           C  
ATOM   1035  O   GLN A 132      16.737  28.540 -24.803  1.00 12.00           O  
ATOM   1036  CB  GLN A 132      17.894  31.552 -24.455  1.00 15.52           C  
ATOM   1037  CG  GLN A 132      17.509  32.916 -24.853  1.00 20.93           C  
ATOM   1038  CD  GLN A 132      16.226  32.930 -25.596  1.00 16.24           C  
ATOM   1039  OE1 GLN A 132      16.048  32.280 -26.656  1.00 21.28           O  
ATOM   1040  NE2 GLN A 132      15.348  33.670 -25.097  1.00 16.19           N  
ATOM   1041  N   VAL A 133      18.127  28.733 -23.069  1.00  9.60           N  
ATOM   1042  CA  VAL A 133      18.489  27.287 -23.115  1.00  9.89           C  
ATOM   1043  C   VAL A 133      17.261  26.423 -22.879  1.00 10.14           C  
ATOM   1044  O   VAL A 133      16.986  25.508 -23.640  1.00 10.02           O  
ATOM   1045  CB  VAL A 133      19.604  26.934 -22.107  1.00  7.57           C  
ATOM   1046  CG1 VAL A 133      19.844  25.396 -22.109  1.00  9.74           C  
ATOM   1047  CG2 VAL A 133      20.922  27.677 -22.626  1.00  9.28           C  
ATOM   1048  N   LEU A 134      16.525  26.693 -21.782  1.00  9.55           N  
ATOM   1049  CA  LEU A 134      15.282  25.933 -21.512  1.00  8.96           C  
ATOM   1050  C   LEU A 134      14.256  26.006 -22.665  1.00  9.37           C  
ATOM   1051  O   LEU A 134      13.648  24.990 -23.001  1.00  9.98           O  
ATOM   1052  CB  LEU A 134      14.582  26.491 -20.248  1.00  9.60           C  
ATOM   1053  CG  LEU A 134      15.446  26.220 -18.997  1.00 11.47           C  
ATOM   1054  CD1 LEU A 134      14.769  26.873 -17.763  1.00 12.53           C  
ATOM   1055  CD2 LEU A 134      15.873  24.809 -18.678  1.00 13.30           C  
ATOM   1056  N   LEU A 135      14.093  27.186 -23.280  1.00  8.44           N  
ATOM   1057  CA  LEU A 135      13.135  27.320 -24.402  1.00  9.03           C  
ATOM   1058  C   LEU A 135      13.550  26.444 -25.583  1.00  9.06           C  
ATOM   1059  O   LEU A 135      12.642  25.877 -26.221  1.00  9.96           O  
ATOM   1060  CB  LEU A 135      13.023  28.791 -24.800  1.00  8.44           C  
ATOM   1061  CG  LEU A 135      12.218  29.618 -23.779  1.00 11.05           C  
ATOM   1062  CD1 LEU A 135      12.507  31.066 -24.202  1.00 16.59           C  
ATOM   1063  CD2 LEU A 135      10.758  29.273 -23.984  1.00 13.88           C  
ATOM   1064  N   ARG A 136      14.851  26.313 -25.847  1.00  8.88           N  
ATOM   1065  CA  ARG A 136      15.333  25.452 -26.967  1.00 10.90           C  
ATOM   1066  C   ARG A 136      15.124  24.006 -26.649  1.00 10.52           C  
ATOM   1067  O   ARG A 136      14.683  23.214 -27.494  1.00 10.22           O  
ATOM   1068  CB  ARG A 136      16.788  25.717 -27.350  1.00 10.35           C  
ATOM   1069  CG  ARG A 136      17.209  24.860 -28.565  1.00  8.91           C  
ATOM   1070  CD  ARG A 136      16.287  25.034 -29.799  1.00 11.19           C  
ATOM   1071  NE  ARG A 136      16.623  23.948 -30.740  1.00 12.35           N  
ATOM   1072  CZ  ARG A 136      17.569  24.012 -31.694  1.00 12.76           C  
ATOM   1073  NH1 ARG A 136      17.778  22.938 -32.478  1.00 11.95           N  
ATOM   1074  NH2 ARG A 136      18.293  25.118 -31.885  1.00 11.94           N  
ATOM   1075  N   ILE A 137      15.389  23.636 -25.395  1.00 10.71           N  
ATOM   1076  CA  ILE A 137      15.120  22.227 -24.984  1.00  9.97           C  
ATOM   1077  C   ILE A 137      13.648  21.949 -25.181  1.00 10.60           C  
ATOM   1078  O   ILE A 137      13.223  20.935 -25.772  1.00 10.43           O  
ATOM   1079  CB  ILE A 137      15.569  22.003 -23.488  1.00 10.46           C  
ATOM   1080  CG1 ILE A 137      17.139  22.093 -23.362  1.00  8.05           C  
ATOM   1081  CG2 ILE A 137      14.951  20.650 -22.967  1.00 11.92           C  
ATOM   1082  CD1 ILE A 137      17.601  22.190 -21.892  1.00 12.49           C  
ATOM   1083  N   LEU A 138      12.790  22.823 -24.650  1.00 10.51           N  
ATOM   1084  CA  LEU A 138      11.365  22.609 -24.891  1.00 14.19           C  
ATOM   1085  C   LEU A 138      10.945  22.539 -26.363  1.00 14.79           C  
ATOM   1086  O   LEU A 138      10.108  21.679 -26.723  1.00 12.56           O  
ATOM   1087  CB  LEU A 138      10.584  23.692 -24.160  1.00 14.35           C  
ATOM   1088  CG  LEU A 138       9.101  23.551 -23.890  1.00 18.99           C  
ATOM   1089  CD1 LEU A 138       8.823  22.295 -23.082  1.00 16.02           C  
ATOM   1090  CD2 LEU A 138       8.596  24.915 -23.153  1.00 18.56           C  
ATOM   1091  N   ALA A 139      11.524  23.396 -27.208  1.00 13.59           N  
ATOM   1092  CA  ALA A 139      11.181  23.336 -28.664  1.00 14.08           C  
ATOM   1093  C   ALA A 139      11.668  22.038 -29.234  1.00 14.57           C  
ATOM   1094  O   ALA A 139      10.951  21.435 -30.104  1.00 15.66           O  
ATOM   1095  CB  ALA A 139      11.859  24.500 -29.374  1.00 14.43           C  
ATOM   1096  N   ASN A 140      12.841  21.568 -28.786  1.00 12.56           N  
ATOM   1097  CA  ASN A 140      13.375  20.286 -29.305  1.00 12.13           C  
ATOM   1098  C   ASN A 140      12.419  19.168 -28.949  1.00 16.64           C  
ATOM   1099  O   ASN A 140      12.243  18.177 -29.718  1.00 16.25           O  
ATOM   1100  CB  ASN A 140      14.753  19.962 -28.795  1.00 12.72           C  
ATOM   1101  CG  ASN A 140      15.839  20.838 -29.430  1.00 13.71           C  
ATOM   1102  OD1 ASN A 140      15.657  21.348 -30.539  1.00 13.17           O  
ATOM   1103  ND2 ASN A 140      16.968  20.969 -28.761  1.00 11.47           N  
ATOM   1104  N   LEU A 141      11.836  19.304 -27.779  1.00 14.00           N  
ATOM   1105  CA  LEU A 141      10.891  18.258 -27.331  1.00 18.18           C  
ATOM   1106  C   LEU A 141       9.573  18.368 -28.054  1.00 21.83           C  
ATOM   1107  O   LEU A 141       8.948  17.354 -28.313  1.00 22.44           O  
ATOM   1108  CB  LEU A 141      10.669  18.315 -25.814  1.00 16.51           C  
ATOM   1109  CG  LEU A 141      11.857  17.696 -25.082  1.00 15.53           C  
ATOM   1110  CD1 LEU A 141      12.041  18.240 -23.654  1.00 13.72           C  
ATOM   1111  CD2 LEU A 141      11.684  16.185 -25.025  1.00 18.96           C  
ATOM   1112  N   GLU A 142       9.130  19.588 -28.296  1.00 23.61           N  
ATOM   1113  CA  GLU A 142       7.776  19.851 -28.815  1.00 30.21           C  
ATOM   1114  C   GLU A 142       7.775  19.636 -30.302  1.00 33.58           C  
ATOM   1115  O   GLU A 142       6.808  19.157 -30.849  1.00 35.32           O  
ATOM   1116  CB  GLU A 142       7.305  21.259 -28.423  1.00 30.07           C  
ATOM   1117  CG  GLU A 142       6.928  21.267 -26.889  1.00 31.84           C  
ATOM   1118  CD  GLU A 142       6.365  22.566 -26.321  1.00 33.39           C  
ATOM   1119  OE1 GLU A 142       6.557  23.659 -26.887  1.00 36.50           O  
ATOM   1120  OE2 GLU A 142       5.726  22.462 -25.242  1.00 37.78           O  
ATOM   1121  N   ASN A 143       8.900  19.947 -30.937  1.00 37.82           N  
ATOM   1122  CA  ASN A 143       9.169  19.555 -32.313  1.00 41.09           C  
ATOM   1123  C   ASN A 143       9.654  18.085 -32.421  1.00 43.05           C  
ATOM   1124  O   ASN A 143      10.525  17.768 -33.230  1.00 44.77           O  
ATOM   1125  CB  ASN A 143      10.188  20.527 -32.964  1.00 40.72           C  
ATOM   1126  CG  ASN A 143       9.702  21.996 -32.990  1.00 41.94           C  
ATOM   1127  OD1 ASN A 143       8.522  22.255 -33.185  1.00 43.90           O  
ATOM   1128  ND2 ASN A 143      10.634  22.955 -32.859  1.00 38.75           N  
ATOM   1129  N   ARG A 144       9.076  17.185 -31.622  1.00 46.11           N  
ATOM   1130  CA  ARG A 144       9.302  15.726 -31.783  1.00 47.84           C  
ATOM   1131  C   ARG A 144       8.345  14.988 -32.747  1.00 48.21           C  
ATOM   1132  O   ARG A 144       7.195  15.400 -32.975  1.00 49.08           O  
ATOM   1133  CB  ARG A 144       9.364  14.998 -30.426  1.00 48.53           C  
ATOM   1134  CG  ARG A 144      10.391  15.594 -29.432  1.00 49.64           C  
ATOM   1135  CD  ARG A 144      11.213  14.592 -28.623  1.00 50.01           C  
ATOM   1136  NE  ARG A 144      12.129  13.830 -29.473  1.00 48.22           N  
ATOM   1137  CZ  ARG A 144      13.299  14.262 -29.940  1.00 51.39           C  
ATOM   1138  NH1 ARG A 144      14.004  13.467 -30.733  1.00 53.83           N  
ATOM   1139  NH2 ARG A 144      13.773  15.469 -29.632  1.00 47.97           N  
TER    1140      ARG A 144                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
