
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 (  888),  selected  111 , name 1z7u_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 1z7u_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -2_A      S       1           -
LGA    -       -      N       2           -
LGA    -       -      A       3           -
LGA    -       -      M       4           -
LGA    -       -      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    N    -1_A      T      10          4.402
LGA    A     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    T     2_A      E      11           #
LGA    T     3_A      I      12          5.324
LGA    D     4_A      C      13          1.854
LGA    K     5_A      -       -           -
LGA    Q     6_A      I      14          3.942
LGA    T     7_A      D      15          3.072
LGA    S     8_A      P      16           #
LGA    I     9_A      S      17           -
LGA    -       -      E      18           -
LGA    N    10_A      S      19           #
LGA    L    11_A      -       -           -
LGA    A    12_A      V      20          4.158
LGA    L    13_A      L      21          2.565
LGA    S    14_A      H      22          1.761
LGA    T    15_A      L      23          2.708
LGA    I    16_A      L      24          1.553
LGA    N    17_A      G      25          1.463
LGA    G    18_A      K      26          1.211
LGA    K    19_A      K      27          1.724
LGA    W    20_A      Y      28          1.917
LGA    K    21_A      T      29          1.525
LGA    L    22_A      M      30          2.028
LGA    S    23_A      L      31          2.156
LGA    L    24_A      I      32          1.456
LGA    X    25_A      I      33          1.646
LGA    D    26_A      S      34          2.232
LGA    E    27_A      V      35          1.813
LGA    L    28_A      L      36          0.651
LGA    F    29_A      G      37          0.739
LGA    Q    30_A      N      38          0.856
LGA    -       -      G      39           -
LGA    -       -      S      40           -
LGA    G    31_A      T      41          4.365
LGA    T    32_A      R      42          1.605
LGA    K    33_A      Q      43          0.727
LGA    R    34_A      N      44          0.471
LGA    N    35_A      F      45          1.267
LGA    G    36_A      N      46          2.081
LGA    E    37_A      D      47          1.648
LGA    L    38_A      I      48          2.208
LGA    X    39_A      R      49          3.206
LGA    R    40_A      S      50          2.840
LGA    A    41_A      S      51          2.786
LGA    L    42_A      I      52          3.059
LGA    D    43_A      P      53          3.605
LGA    G    44_A      G      54          3.269
LGA    I    45_A      I      55          2.908
LGA    T    46_A      S      56          2.833
LGA    Q    47_A      S      57          2.325
LGA    R    48_A      T      58          2.102
LGA    V    49_A      I      59          1.972
LGA    L    50_A      L      60          1.820
LGA    T    51_A      S      61          1.262
LGA    D    52_A      R      62          0.925
LGA    R    53_A      R      63          1.144
LGA    L    54_A      I      64          0.549
LGA    R    55_A      K      65          0.258
LGA    E    56_A      D      66          0.577
LGA    X    57_A      L      67          0.721
LGA    E    58_A      I      68          0.640
LGA    K    59_A      D      69          0.725
LGA    D    60_A      S      70          1.037
LGA    G    61_A      G      71          1.267
LGA    L    62_A      L      72          1.165
LGA    V    63_A      V      73          0.655
LGA    H    64_A      E      74          1.150
LGA    R    65_A      R      75          0.953
LGA    E    66_A      R      76          1.146
LGA    S    67_A      S      77          1.234
LGA    F    68_A      G      78          1.333
LGA    N    69_A      -       -           -
LGA    E    70_A      -       -           -
LGA    L    71_A      -       -           -
LGA    P    72_A      -       -           -
LGA    P    73_A      Q      79          3.239
LGA    R    74_A      I      80          1.543
LGA    V    75_A      T      81          1.177
LGA    E    76_A      T      82          1.152
LGA    Y    77_A      Y      83          0.107
LGA    T    78_A      A      84          0.336
LGA    L    79_A      L      85          0.761
LGA    T    80_A      T      86          0.958
LGA    P    81_A      E      87          1.022
LGA    E    82_A      K      88          1.075
LGA    G    83_A      G      89          0.776
LGA    Y    84_A      M      90          1.003
LGA    A    85_A      N      91          0.872
LGA    L    86_A      V      92          0.827
LGA    Y    87_A      R      93          0.935
LGA    D    88_A      N      94          1.415
LGA    A    89_A      S      95          1.088
LGA    L    90_A      L      96          1.371
LGA    S    91_A      M      97          1.444
LGA    S    92_A      P      98          2.376
LGA    L    93_A      L      99          2.400
LGA    C    94_A      L     100          3.033
LGA    H    95_A      Q     101          4.001
LGA    W    96_A      Y     102          4.735
LGA    G    97_A      I     103          4.917
LGA    E    98_A      S     104          5.665
LGA    T    99_A      V     105          6.366
LGA    F   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    Q   102_A      L     106           #
LGA    K   103_A      D     107           -
LGA    K   104_A      R     108           -
LGA    A   105_A      N     109          5.544
LGA    R   106_A      -       -           -
LGA    L   107_A      -       -           -
LGA    N   108_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111  109    5.0     90    2.38    20.00     72.781     3.622

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.613076 * X  +   0.128042 * Y  +  -0.779579 * Z  +  -5.816869
  Y_new =  -0.092015 * X  +   0.991636 * Y  +   0.090510 * Z  +  35.063690
  Z_new =   0.784647 * X  +   0.016244 * Y  +   0.619730 * Z  + -31.753851 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.026205   -3.115388  [ DEG:     1.5014   -178.4986 ]
  Theta =  -0.902127   -2.239466  [ DEG:   -51.6881   -128.3120 ]
  Phi   =  -0.148975    2.992618  [ DEG:    -8.5356    171.4644 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z7u_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z7u_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111  109   5.0   90   2.38   20.00  72.781
REMARK  ---------------------------------------------------------- 
MOLECULE 1z7u_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-MAR-05   1Z7U              
TITLE     CRYSTAL STRUCTURE OF THE PUTITIVE TRANSCRIPTIONAL REGULATOR           
TITLE    2 OF MARR FAMILY FROM ENTEROCOCCUS FAECALIS V583                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN EF0647;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: PUTATIVE TRANSCRIPTIONAL REGULATOR;                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS V583;                     
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    WINGED-HELIX-TURN-HELIX, MARR, STRUCTURAL GENOMICS, PSI,              
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,R.WU,F.COLLART,A.JOACHIMIAK,MIDWEST CENTER FOR                  
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   10-MAY-05 1Z7U    0                                                
JRNL        AUTH   Y.KIM,R.WU,F.COLLART,A.JOACHIMIAK                            
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTITIVE TRANSCRIPTIONAL            
JRNL        TITL 2 REGULATOR OF MARR FAMILY FROM ENTEROCOCCUS FAECALIS          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  1Z7U A    1   109  UNP    Q838C3   Q838C3_ENTFA     1    109             
DBREF  1Z7U B    1   109  UNP    Q838C3   Q838C3_ENTFA     1    109             
SEQRES   1 A  112  SER ASN ALA MSE THR THR ASP LYS GLN THR SER ILE ASN          
SEQRES   2 A  112  LEU ALA LEU SER THR ILE ASN GLY LYS TRP LYS LEU SER          
SEQRES   3 A  112  LEU MSE ASP GLU LEU PHE GLN GLY THR LYS ARG ASN GLY          
SEQRES   4 A  112  GLU LEU MSE ARG ALA LEU ASP GLY ILE THR GLN ARG VAL          
SEQRES   5 A  112  LEU THR ASP ARG LEU ARG GLU MSE GLU LYS ASP GLY LEU          
SEQRES   6 A  112  VAL HIS ARG GLU SER PHE ASN GLU LEU PRO PRO ARG VAL          
SEQRES   7 A  112  GLU TYR THR LEU THR PRO GLU GLY TYR ALA LEU TYR ASP          
SEQRES   8 A  112  ALA LEU SER SER LEU CYS HIS TRP GLY GLU THR PHE ALA          
SEQRES   9 A  112  GLN LYS LYS ALA ARG LEU ASN LYS                              
SEQRES   1 B  112  SER ASN ALA MSE THR THR ASP LYS GLN THR SER ILE ASN          
SEQRES   2 B  112  LEU ALA LEU SER THR ILE ASN GLY LYS TRP LYS LEU SER          
SEQRES   3 B  112  LEU MSE ASP GLU LEU PHE GLN GLY THR LYS ARG ASN GLY          
SEQRES   4 B  112  GLU LEU MSE ARG ALA LEU ASP GLY ILE THR GLN ARG VAL          
SEQRES   5 B  112  LEU THR ASP ARG LEU ARG GLU MSE GLU LYS ASP GLY LEU          
SEQRES   6 B  112  VAL HIS ARG GLU SER PHE ASN GLU LEU PRO PRO ARG VAL          
SEQRES   7 B  112  GLU TYR THR LEU THR PRO GLU GLY TYR ALA LEU TYR ASP          
SEQRES   8 B  112  ALA LEU SER SER LEU CYS HIS TRP GLY GLU THR PHE ALA          
SEQRES   9 B  112  GLN LYS LYS ALA ARG LEU ASN LYS                              
HET    MSE  A   1       8                                                       
HET    MSE  A  25       8                                                       
HET    MSE  A  39       8                                                       
HET    MSE  A  57       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  39       8                                                       
HET    MSE  B  57       8                                                       
HET    FMT    201       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     FMT FORMIC ACID                                                      
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  FMT    C H2 O2                                                      
FORMUL   4  HOH   *195(H2 O)                                                    
CRYST1   63.754   63.754  139.271  90.00  90.00  90.00 P 41 21 2    16          
ATOM      1  N   SER A  -2      -9.526  37.867   8.239  1.00 36.88           N  
ATOM      2  CA  SER A  -2     -10.011  39.264   8.352  1.00 36.63           C  
ATOM      3  C   SER A  -2      -9.259  39.918   9.481  1.00 36.30           C  
ATOM      4  O   SER A  -2      -9.336  41.136   9.678  1.00 35.85           O  
ATOM      5  CB  SER A  -2     -11.502  39.258   8.688  1.00 36.93           C  
ATOM      6  OG  SER A  -2     -11.725  38.623   9.943  1.00 38.41           O  
ATOM      7  N   ASN A  -1      -8.538  39.082  10.229  1.00 35.82           N  
ATOM      8  CA  ASN A  -1      -7.948  39.468  11.509  1.00 35.75           C  
ATOM      9  C   ASN A  -1      -8.969  39.831  12.587  1.00 35.32           C  
ATOM     10  O   ASN A  -1      -8.613  40.489  13.573  1.00 35.29           O  
ATOM     11  CB  ASN A  -1      -6.914  40.594  11.346  1.00 35.73           C  
ATOM     12  CG  ASN A  -1      -5.610  40.106  10.766  1.00 36.83           C  
ATOM     13  OD1 ASN A  -1      -5.055  40.724   9.859  1.00 39.01           O  
ATOM     14  ND2 ASN A  -1      -5.115  38.986  11.276  1.00 37.25           N  
ATOM     15  N   ALA A   0     -10.225  39.409  12.409  1.00 35.33           N  
ATOM     16  CA  ALA A   0     -11.221  39.517  13.483  1.00 35.64           C  
ATOM     17  C   ALA A   0     -10.681  38.789  14.704  1.00 35.91           C  
ATOM     18  O   ALA A   0     -10.154  37.690  14.575  1.00 35.03           O  
ATOM     19  CB  ALA A   0     -12.550  38.929  13.064  1.00 35.17           C  
HETATM   20  N   MSE A   1     -10.794  39.412  15.874  1.00 36.76           N  
HETATM   21  CA  MSE A   1     -10.228  38.852  17.113  1.00 39.54           C  
HETATM   22  C   MSE A   1     -10.838  37.503  17.504  1.00 36.03           C  
HETATM   23  O   MSE A   1     -10.232  36.731  18.249  1.00 36.18           O  
HETATM   24  CB  MSE A   1     -10.359  39.847  18.266  1.00 38.97           C  
HETATM   25  CG  MSE A   1     -11.799  40.312  18.532  1.00 43.37           C  
HETATM   26 SE   MSE A   1     -11.914  41.670  19.986  1.00 51.74          SE  
HETATM   27  CE  MSE A   1     -11.599  40.481  21.544  1.00 47.85           C  
ATOM     28  N   THR A   2     -12.029  37.232  16.979  1.00 33.73           N  
ATOM     29  CA  THR A   2     -12.773  36.005  17.272  1.00 31.66           C  
ATOM     30  C   THR A   2     -12.398  34.847  16.341  1.00 30.84           C  
ATOM     31  O   THR A   2     -12.923  33.755  16.480  1.00 30.71           O  
ATOM     32  CB  THR A   2     -14.285  36.256  17.157  1.00 31.43           C  
ATOM     33  OG1 THR A   2     -14.571  36.774  15.854  1.00 29.86           O  
ATOM     34  CG2 THR A   2     -14.754  37.265  18.207  1.00 29.88           C  
ATOM     35  N   THR A   3     -11.515  35.101  15.378  1.00 29.74           N  
ATOM     36  CA  THR A   3     -11.125  34.088  14.410  1.00 28.99           C  
ATOM     37  C   THR A   3      -9.793  33.451  14.795  1.00 28.76           C  
ATOM     38  O   THR A   3      -8.792  34.149  14.978  1.00 28.87           O  
ATOM     39  CB  THR A   3     -11.057  34.666  12.967  1.00 29.12           C  
ATOM     40  OG1 THR A   3     -12.383  34.989  12.510  1.00 29.02           O  
ATOM     41  CG2 THR A   3     -10.427  33.664  12.002  1.00 28.07           C  
ATOM     42  N   ASP A   4      -9.780  32.129  14.919  1.00 27.90           N  
ATOM     43  CA  ASP A   4      -8.521  31.416  15.111  1.00 27.77           C  
ATOM     44  C   ASP A   4      -7.688  31.392  13.816  1.00 26.76           C  
ATOM     45  O   ASP A   4      -8.059  30.751  12.831  1.00 26.78           O  
ATOM     46  CB  ASP A   4      -8.753  29.998  15.620  1.00 28.05           C  
ATOM     47  CG  ASP A   4      -7.450  29.272  15.887  1.00 30.29           C  
ATOM     48  OD1 ASP A   4      -6.644  29.780  16.694  1.00 35.54           O  
ATOM     49  OD2 ASP A   4      -7.202  28.213  15.283  1.00 32.41           O  
ATOM     50  N   LYS A   5      -6.563  32.089  13.838  1.00 25.81           N  
ATOM     51  CA  LYS A   5      -5.728  32.263  12.661  1.00 25.11           C  
ATOM     52  C   LYS A   5      -5.123  30.972  12.072  1.00 24.93           C  
ATOM     53  O   LYS A   5      -5.138  30.780  10.855  1.00 23.99           O  
ATOM     54  CB  LYS A   5      -4.647  33.298  12.948  1.00 25.37           C  
ATOM     55  CG  LYS A   5      -3.893  33.718  11.705  1.00 26.39           C  
ATOM     56  CD  LYS A   5      -3.032  34.928  11.938  1.00 28.00           C  
ATOM     57  CE  LYS A   5      -3.794  36.179  11.607  1.00 28.76           C  
ATOM     58  NZ  LYS A   5      -2.903  37.339  11.775  1.00 31.13           N  
ATOM     59  N   GLN A   6      -4.600  30.105  12.939  0.50 24.71           N  
ATOM     61  CA  GLN A   6      -3.963  28.861  12.510  0.50 24.75           C  
ATOM     63  C   GLN A   6      -4.967  27.932  11.816  0.50 24.71           C  
ATOM     65  O   GLN A   6      -4.714  27.452  10.706  0.50 24.87           O  
ATOM     67  CB  GLN A   6      -3.283  28.171  13.702  0.50 24.76           C  
ATOM     69  CG  GLN A   6      -2.618  26.829  13.385  0.50 25.10           C  
ATOM     71  CD  GLN A   6      -1.269  26.979  12.694  0.50 25.23           C  
ATOM     73  OE1 GLN A   6      -1.158  26.788  11.483  0.50 25.09           O  
ATOM     75  NE2 GLN A   6      -0.237  27.316  13.466  0.50 24.82           N  
ATOM     77  N   THR A   7      -6.105  27.703  12.468  1.00 24.58           N  
ATOM     78  CA  THR A   7      -7.189  26.887  11.904  1.00 24.05           C  
ATOM     79  C   THR A   7      -7.627  27.397  10.535  1.00 23.82           C  
ATOM     80  O   THR A   7      -7.789  26.607   9.607  1.00 23.43           O  
ATOM     81  CB  THR A   7      -8.407  26.822  12.871  1.00 24.07           C  
ATOM     82  OG1 THR A   7      -7.950  26.386  14.154  1.00 23.95           O  
ATOM     83  CG2 THR A   7      -9.492  25.859  12.377  1.00 22.10           C  
ATOM     84  N   SER A   8      -7.801  28.709  10.392  1.00 23.94           N  
ATOM     85  CA  SER A   8      -8.249  29.217   9.112  1.00 24.51           C  
ATOM     86  C   SER A   8      -7.169  29.379   8.035  1.00 24.39           C  
ATOM     87  O   SER A   8      -7.472  29.231   6.852  1.00 24.09           O  
ATOM     88  CB  SER A   8      -9.214  30.398   9.228  1.00 24.33           C  
ATOM     89  OG  SER A   8      -8.628  31.511   9.788  1.00 27.54           O  
ATOM     90  N   ILE A   9      -5.917  29.625   8.433  1.00 24.20           N  
ATOM     91  CA  ILE A   9      -4.802  29.434   7.504  1.00 24.06           C  
ATOM     92  C   ILE A   9      -4.763  27.986   6.964  1.00 24.80           C  
ATOM     93  O   ILE A   9      -4.732  27.771   5.743  1.00 24.74           O  
ATOM     94  CB  ILE A   9      -3.448  29.859   8.108  1.00 23.72           C  
ATOM     95  CG1 ILE A   9      -3.357  31.393   8.118  1.00 22.69           C  
ATOM     96  CG2 ILE A   9      -2.295  29.250   7.324  1.00 23.21           C  
ATOM     97  CD1 ILE A   9      -2.297  31.970   9.051  1.00 20.18           C  
ATOM     98  N   ASN A  10      -4.790  27.005   7.864  1.00 24.94           N  
ATOM     99  CA  ASN A  10      -4.793  25.595   7.486  1.00 25.47           C  
ATOM    100  C   ASN A  10      -5.932  25.210   6.544  1.00 25.33           C  
ATOM    101  O   ASN A  10      -5.718  24.511   5.572  1.00 25.75           O  
ATOM    102  CB  ASN A  10      -4.841  24.713   8.739  1.00 26.05           C  
ATOM    103  CG  ASN A  10      -3.510  24.657   9.466  1.00 28.26           C  
ATOM    104  OD1 ASN A  10      -2.484  25.124   8.962  1.00 32.22           O  
ATOM    105  ND2 ASN A  10      -3.514  24.064  10.653  1.00 30.87           N  
ATOM    106  N   LEU A  11      -7.137  25.676   6.841  1.00 25.39           N  
ATOM    107  CA  LEU A  11      -8.320  25.380   6.046  1.00 25.62           C  
ATOM    108  C   LEU A  11      -8.190  25.964   4.644  1.00 24.95           C  
ATOM    109  O   LEU A  11      -8.503  25.308   3.655  1.00 25.15           O  
ATOM    110  CB  LEU A  11      -9.563  25.926   6.753  1.00 25.49           C  
ATOM    111  CG  LEU A  11     -10.938  25.248   6.720  1.00 26.98           C  
ATOM    112  CD1 LEU A  11     -10.899  23.713   6.855  1.00 25.67           C  
ATOM    113  CD2 LEU A  11     -11.763  25.848   7.853  1.00 26.36           C  
ATOM    114  N   ALA A  12      -7.696  27.191   4.569  1.00 24.38           N  
ATOM    115  CA  ALA A  12      -7.430  27.849   3.291  1.00 23.55           C  
ATOM    116  C   ALA A  12      -6.404  27.078   2.445  1.00 23.41           C  
ATOM    117  O   ALA A  12      -6.641  26.829   1.262  1.00 23.13           O  
ATOM    118  CB  ALA A  12      -6.988  29.299   3.522  1.00 23.04           C  
ATOM    119  N   LEU A  13      -5.286  26.673   3.056  1.00 22.95           N  
ATOM    120  CA  LEU A  13      -4.238  25.931   2.335  1.00 22.74           C  
ATOM    121  C   LEU A  13      -4.702  24.563   1.835  1.00 22.46           C  
ATOM    122  O   LEU A  13      -4.287  24.112   0.772  1.00 22.16           O  
ATOM    123  CB  LEU A  13      -2.966  25.785   3.181  1.00 21.96           C  
ATOM    124  CG  LEU A  13      -2.086  27.005   3.471  1.00 22.02           C  
ATOM    125  CD1 LEU A  13      -1.106  26.689   4.594  1.00 18.25           C  
ATOM    126  CD2 LEU A  13      -1.335  27.510   2.209  1.00 22.10           C  
ATOM    127  N   SER A  14      -5.552  23.910   2.619  1.00 23.07           N  
ATOM    128  CA  SER A  14      -6.102  22.597   2.277  1.00 23.21           C  
ATOM    129  C   SER A  14      -6.936  22.617   0.996  1.00 23.00           C  
ATOM    130  O   SER A  14      -7.102  21.587   0.346  1.00 23.62           O  
ATOM    131  CB  SER A  14      -6.920  22.030   3.450  1.00 22.71           C  
ATOM    132  OG  SER A  14      -8.239  22.567   3.479  1.00 25.22           O  
ATOM    133  N   THR A  15      -7.471  23.780   0.630  1.00 23.03           N  
ATOM    134  CA  THR A  15      -8.200  23.910  -0.647  1.00 22.61           C  
ATOM    135  C   THR A  15      -7.274  24.037  -1.882  1.00 22.88           C  
ATOM    136  O   THR A  15      -7.741  23.927  -3.029  1.00 23.03           O  
ATOM    137  CB  THR A  15      -9.194  25.099  -0.637  1.00 22.23           C  
ATOM    138  OG1 THR A  15      -8.478  26.347  -0.675  1.00 22.02           O  
ATOM    139  CG2 THR A  15     -10.074  25.047   0.584  1.00 21.90           C  
ATOM    140  N   ILE A  16      -5.974  24.252  -1.658  1.00 22.31           N  
ATOM    141  CA  ILE A  16      -5.069  24.590  -2.748  1.00 22.03           C  
ATOM    142  C   ILE A  16      -3.712  23.855  -2.738  1.00 22.36           C  
ATOM    143  O   ILE A  16      -2.878  24.060  -3.626  1.00 22.14           O  
ATOM    144  CB  ILE A  16      -4.868  26.146  -2.812  1.00 22.79           C  
ATOM    145  CG1 ILE A  16      -4.457  26.604  -4.227  1.00 23.17           C  
ATOM    146  CG2 ILE A  16      -3.901  26.645  -1.693  1.00 21.44           C  
ATOM    147  CD1 ILE A  16      -5.432  26.165  -5.319  1.00 22.40           C  
ATOM    148  N   ASN A  17      -3.488  22.994  -1.751  1.00 22.76           N  
ATOM    149  CA  ASN A  17      -2.170  22.386  -1.577  1.00 23.18           C  
ATOM    150  C   ASN A  17      -2.029  21.026  -2.269  1.00 23.16           C  
ATOM    151  O   ASN A  17      -0.912  20.523  -2.457  1.00 22.77           O  
ATOM    152  CB  ASN A  17      -1.768  22.346  -0.089  1.00 23.37           C  
ATOM    153  CG  ASN A  17      -2.693  21.476   0.754  1.00 24.72           C  
ATOM    154  OD1 ASN A  17      -3.561  20.766   0.234  1.00 23.29           O  
ATOM    155  ND2 ASN A  17      -2.500  21.524   2.077  1.00 26.63           N  
ATOM    156  N   GLY A  18      -3.168  20.464  -2.668  1.00 23.41           N  
ATOM    157  CA  GLY A  18      -3.220  19.210  -3.420  1.00 24.28           C  
ATOM    158  C   GLY A  18      -2.471  19.282  -4.745  1.00 25.04           C  
ATOM    159  O   GLY A  18      -2.312  20.361  -5.330  1.00 24.44           O  
ATOM    160  N   LYS A  19      -1.999  18.126  -5.213  1.00 25.89           N  
ATOM    161  CA  LYS A  19      -1.179  18.060  -6.419  1.00 26.52           C  
ATOM    162  C   LYS A  19      -1.884  18.727  -7.592  1.00 26.04           C  
ATOM    163  O   LYS A  19      -3.091  18.544  -7.777  1.00 25.93           O  
ATOM    164  CB  LYS A  19      -0.845  16.612  -6.759  1.00 26.98           C  
ATOM    165  CG  LYS A  19       0.412  16.466  -7.630  1.00 31.03           C  
ATOM    166  CD  LYS A  19       0.472  15.081  -8.277  1.00 35.76           C  
ATOM    167  CE  LYS A  19       1.881  14.516  -8.280  1.00 36.60           C  
ATOM    168  NZ  LYS A  19       2.106  13.769  -6.990  1.00 40.04           N  
ATOM    169  N   TRP A  20      -1.129  19.517  -8.358  1.00 25.81           N  
ATOM    170  CA  TRP A  20      -1.612  20.184  -9.582  1.00 25.58           C  
ATOM    171  C   TRP A  20      -2.423  21.449  -9.354  1.00 25.08           C  
ATOM    172  O   TRP A  20      -2.543  22.267 -10.265  1.00 25.50           O  
ATOM    173  CB  TRP A  20      -2.398  19.228 -10.499  1.00 26.03           C  
ATOM    174  CG  TRP A  20      -1.565  18.107 -11.059  1.00 26.79           C  
ATOM    175  CD1 TRP A  20      -1.618  16.788 -10.696  1.00 28.40           C  
ATOM    176  CD2 TRP A  20      -0.553  18.205 -12.068  1.00 26.99           C  
ATOM    177  NE1 TRP A  20      -0.692  16.058 -11.414  1.00 29.49           N  
ATOM    178  CE2 TRP A  20      -0.024  16.903 -12.262  1.00 28.19           C  
ATOM    179  CE3 TRP A  20      -0.029  19.268 -12.824  1.00 28.54           C  
ATOM    180  CZ2 TRP A  20       0.994  16.629 -13.194  1.00 27.92           C  
ATOM    181  CZ3 TRP A  20       0.990  18.996 -13.754  1.00 27.87           C  
ATOM    182  CH2 TRP A  20       1.482  17.681 -13.931  1.00 28.33           C  
ATOM    183  N   LYS A  21      -2.958  21.633  -8.148  1.00 24.65           N  
ATOM    184  CA  LYS A  21      -3.967  22.674  -7.920  1.00 23.97           C  
ATOM    185  C   LYS A  21      -3.415  24.066  -8.111  1.00 23.78           C  
ATOM    186  O   LYS A  21      -4.068  24.917  -8.714  1.00 23.26           O  
ATOM    187  CB  LYS A  21      -4.647  22.518  -6.558  1.00 24.26           C  
ATOM    188  CG  LYS A  21      -5.565  21.314  -6.493  1.00 23.89           C  
ATOM    189  CD  LYS A  21      -6.430  21.384  -5.276  1.00 24.01           C  
ATOM    190  CE  LYS A  21      -7.363  20.188  -5.199  1.00 23.51           C  
ATOM    191  NZ  LYS A  21      -8.219  20.340  -3.995  1.00 22.49           N  
ATOM    192  N   LEU A  22      -2.203  24.296  -7.614  1.00 24.16           N  
ATOM    193  CA  LEU A  22      -1.534  25.581  -7.808  1.00 24.33           C  
ATOM    194  C   LEU A  22      -1.277  25.849  -9.293  1.00 24.54           C  
ATOM    195  O   LEU A  22      -1.526  26.950  -9.771  1.00 25.12           O  
ATOM    196  CB  LEU A  22      -0.238  25.666  -6.984  1.00 24.67           C  
ATOM    197  CG  LEU A  22       0.441  27.050  -6.958  1.00 24.21           C  
ATOM    198  CD1 LEU A  22      -0.359  28.018  -6.117  1.00 24.46           C  
ATOM    199  CD2 LEU A  22       1.875  26.957  -6.453  1.00 23.37           C  
ATOM    200  N   SER A  23      -0.808  24.840 -10.025  1.00 25.09           N  
ATOM    201  CA  SER A  23      -0.638  24.964 -11.486  1.00 25.66           C  
ATOM    202  C   SER A  23      -1.954  25.250 -12.207  1.00 25.64           C  
ATOM    203  O   SER A  23      -1.998  26.088 -13.100  1.00 25.58           O  
ATOM    204  CB  SER A  23       0.002  23.710 -12.075  1.00 25.53           C  
ATOM    205  OG  SER A  23       1.334  23.584 -11.625  1.00 27.12           O  
ATOM    206  N   LEU A  24      -3.006  24.540 -11.818  1.00 26.06           N  
ATOM    207  CA  LEU A  24      -4.354  24.760 -12.348  1.00 27.05           C  
ATOM    208  C   LEU A  24      -4.815  26.193 -12.175  1.00 27.94           C  
ATOM    209  O   LEU A  24      -5.322  26.807 -13.115  1.00 27.59           O  
ATOM    210  CB  LEU A  24      -5.345  23.827 -11.661  1.00 26.93           C  
ATOM    211  CG  LEU A  24      -6.008  22.693 -12.447  1.00 28.23           C  
ATOM    212  CD1 LEU A  24      -5.335  22.402 -13.762  1.00 28.13           C  
ATOM    213  CD2 LEU A  24      -6.090  21.433 -11.605  1.00 27.62           C  
HETATM  214  N   MSE A  25      -4.642  26.711 -10.960  1.00 29.04           N  
HETATM  215  CA  MSE A  25      -4.968  28.083 -10.626  1.00 31.33           C  
HETATM  216  C   MSE A  25      -4.174  29.100 -11.465  1.00 29.89           C  
HETATM  217  O   MSE A  25      -4.744  30.108 -11.911  1.00 29.78           O  
HETATM  218  CB  MSE A  25      -4.765  28.314  -9.125  1.00 30.47           C  
HETATM  219  CG  MSE A  25      -4.889  29.756  -8.686  1.00 32.58           C  
HETATM  220 SE   MSE A  25      -4.944  29.969  -6.731  1.00 39.91          SE  
HETATM  221  CE  MSE A  25      -6.884  29.521  -6.450  1.00 33.62           C  
ATOM    222  N   ASP A  26      -2.876  28.836 -11.664  1.00 29.26           N  
ATOM    223  CA  ASP A  26      -2.022  29.656 -12.535  1.00 28.84           C  
ATOM    224  C   ASP A  26      -2.580  29.715 -13.960  1.00 28.92           C  
ATOM    225  O   ASP A  26      -2.625  30.783 -14.566  1.00 28.95           O  
ATOM    226  CB  ASP A  26      -0.589  29.120 -12.583  1.00 28.46           C  
ATOM    227  CG  ASP A  26       0.289  29.625 -11.437  1.00 28.95           C  
ATOM    228  OD1 ASP A  26      -0.069  30.602 -10.759  1.00 27.57           O  
ATOM    229  OD2 ASP A  26       1.366  29.029 -11.216  1.00 31.00           O  
ATOM    230  N   GLU A  27      -3.016  28.568 -14.477  1.00 28.94           N  
ATOM    231  CA  GLU A  27      -3.594  28.492 -15.829  1.00 29.49           C  
ATOM    232  C   GLU A  27      -4.907  29.244 -15.928  1.00 28.98           C  
ATOM    233  O   GLU A  27      -5.144  29.947 -16.894  1.00 28.86           O  
ATOM    234  CB  GLU A  27      -3.807  27.042 -16.268  1.00 29.41           C  
ATOM    235  CG  GLU A  27      -2.524  26.274 -16.545  1.00 32.19           C  
ATOM    236  CD  GLU A  27      -1.673  26.921 -17.631  1.00 35.04           C  
ATOM    237  OE1 GLU A  27      -2.262  27.438 -18.609  1.00 37.39           O  
ATOM    238  OE2 GLU A  27      -0.423  26.916 -17.501  1.00 35.24           O  
ATOM    239  N   LEU A  28      -5.754  29.103 -14.917  1.00 29.06           N  
ATOM    240  CA  LEU A  28      -7.048  29.781 -14.914  1.00 29.15           C  
ATOM    241  C   LEU A  28      -6.934  31.277 -14.676  1.00 29.32           C  
ATOM    242  O   LEU A  28      -7.757  32.055 -15.166  1.00 29.17           O  
ATOM    243  CB  LEU A  28      -8.002  29.133 -13.905  1.00 28.82           C  
ATOM    244  CG  LEU A  28      -8.326  27.659 -14.162  1.00 29.09           C  
ATOM    245  CD1 LEU A  28      -9.303  27.120 -13.128  1.00 28.89           C  
ATOM    246  CD2 LEU A  28      -8.868  27.439 -15.570  1.00 27.71           C  
ATOM    247  N   PHE A  29      -5.924  31.686 -13.912  1.00 30.12           N  
ATOM    248  CA  PHE A  29      -5.682  33.114 -13.721  1.00 30.38           C  
ATOM    249  C   PHE A  29      -5.402  33.846 -15.047  1.00 31.27           C  
ATOM    250  O   PHE A  29      -5.839  34.981 -15.223  1.00 31.25           O  
ATOM    251  CB  PHE A  29      -4.562  33.380 -12.711  1.00 29.72           C  
ATOM    252  CG  PHE A  29      -4.305  34.843 -12.479  1.00 28.18           C  
ATOM    253  CD1 PHE A  29      -5.094  35.565 -11.608  1.00 27.87           C  
ATOM    254  CD2 PHE A  29      -3.279  35.494 -13.152  1.00 27.87           C  
ATOM    255  CE1 PHE A  29      -4.863  36.921 -11.394  1.00 29.40           C  
ATOM    256  CE2 PHE A  29      -3.037  36.836 -12.957  1.00 27.64           C  
ATOM    257  CZ  PHE A  29      -3.834  37.560 -12.075  1.00 28.77           C  
ATOM    258  N   GLN A  30      -4.669  33.242 -15.976  0.50 32.02           N  
ATOM    260  CA  GLN A  30      -4.439  33.939 -17.253  0.50 32.97           C  
ATOM    262  C   GLN A  30      -5.727  34.153 -18.068  0.50 33.26           C  
ATOM    264  O   GLN A  30      -5.794  35.047 -18.918  0.50 32.79           O  
ATOM    266  CB  GLN A  30      -3.321  33.300 -18.096  0.50 33.05           C  
ATOM    268  CG  GLN A  30      -3.345  31.787 -18.244  0.50 33.29           C  
ATOM    270  CD  GLN A  30      -2.080  31.234 -18.905  0.50 33.67           C  
ATOM    272  OE1 GLN A  30      -1.120  31.968 -19.159  0.50 34.25           O  
ATOM    274  NE2 GLN A  30      -2.076  29.931 -19.177  0.50 33.71           N  
ATOM    276  N   GLY A  31      -6.754  33.360 -17.768  1.00 33.65           N  
ATOM    277  CA  GLY A  31      -7.990  33.378 -18.553  1.00 34.69           C  
ATOM    278  C   GLY A  31      -8.762  32.069 -18.603  1.00 35.80           C  
ATOM    279  O   GLY A  31      -8.241  31.002 -18.252  1.00 35.60           O  
ATOM    280  N   THR A  32     -10.012  32.164 -19.061  1.00 36.60           N  
ATOM    281  CA  THR A  32     -10.896  31.011 -19.236  1.00 37.21           C  
ATOM    282  C   THR A  32     -10.225  29.866 -20.008  1.00 37.07           C  
ATOM    283  O   THR A  32      -9.482  30.101 -20.959  1.00 37.51           O  
ATOM    284  CB  THR A  32     -12.213  31.435 -19.912  1.00 37.81           C  
ATOM    285  OG1 THR A  32     -13.156  30.364 -19.818  1.00 39.11           O  
ATOM    286  CG2 THR A  32     -12.005  31.839 -21.404  1.00 38.35           C  
ATOM    287  N   LYS A  33     -10.458  28.631 -19.577  1.00 36.66           N  
ATOM    288  CA  LYS A  33      -9.778  27.486 -20.174  1.00 36.34           C  
ATOM    289  C   LYS A  33     -10.716  26.313 -20.396  1.00 36.40           C  
ATOM    290  O   LYS A  33     -11.621  26.068 -19.599  1.00 36.16           O  
ATOM    291  CB  LYS A  33      -8.612  26.999 -19.300  1.00 36.08           C  
ATOM    292  CG  LYS A  33      -7.418  27.929 -19.177  1.00 36.30           C  
ATOM    293  CD  LYS A  33      -6.523  27.904 -20.409  1.00 34.70           C  
ATOM    294  CE  LYS A  33      -5.437  28.980 -20.315  1.00 35.19           C  
ATOM    295  NZ  LYS A  33      -5.975  30.314 -19.914  1.00 33.79           N  
ATOM    296  N   ARG A  34     -10.484  25.590 -21.491  0.60 36.56           N  
ATOM    298  CA  ARG A  34     -11.184  24.345 -21.764  0.60 36.65           C  
ATOM    300  C   ARG A  34     -10.307  23.191 -21.298  0.60 36.16           C  
ATOM    302  O   ARG A  34      -9.095  23.343 -21.129  0.60 35.74           O  
ATOM    304  CB  ARG A  34     -11.536  24.197 -23.258  0.60 37.05           C  
ATOM    306  CG  ARG A  34     -12.001  25.493 -23.947  0.60 39.02           C  
ATOM    308  CD  ARG A  34     -13.044  25.270 -25.053  0.60 41.83           C  
ATOM    310  NE  ARG A  34     -12.537  24.530 -26.214  0.60 44.17           N  
ATOM    312  CZ  ARG A  34     -13.124  23.453 -26.743  0.60 45.37           C  
ATOM    314  NH1 ARG A  34     -12.585  22.851 -27.801  0.60 45.22           N  
ATOM    316  NH2 ARG A  34     -14.255  22.980 -26.228  0.60 45.50           N  
ATOM    318  N   ASN A  35     -10.936  22.041 -21.090  1.00 35.87           N  
ATOM    319  CA  ASN A  35     -10.257  20.841 -20.621  1.00 35.81           C  
ATOM    320  C   ASN A  35      -8.988  20.495 -21.416  1.00 35.89           C  
ATOM    321  O   ASN A  35      -7.921  20.251 -20.838  1.00 35.61           O  
ATOM    322  CB  ASN A  35     -11.269  19.692 -20.620  1.00 35.72           C  
ATOM    323  CG  ASN A  35     -10.678  18.398 -20.165  1.00 35.87           C  
ATOM    324  OD1 ASN A  35     -10.087  17.654 -20.962  1.00 34.29           O  
ATOM    325  ND2 ASN A  35     -10.846  18.101 -18.879  1.00 34.41           N  
ATOM    326  N   GLY A  36      -9.104  20.519 -22.742  1.00 36.22           N  
ATOM    327  CA  GLY A  36      -7.989  20.200 -23.633  1.00 36.17           C  
ATOM    328  C   GLY A  36      -6.806  21.136 -23.509  1.00 36.24           C  
ATOM    329  O   GLY A  36      -5.657  20.689 -23.554  1.00 36.58           O  
ATOM    330  N   GLU A  37      -7.080  22.432 -23.365  1.00 36.20           N  
ATOM    331  CA  GLU A  37      -6.026  23.423 -23.089  1.00 36.68           C  
ATOM    332  C   GLU A  37      -5.230  23.102 -21.819  1.00 36.34           C  
ATOM    333  O   GLU A  37      -4.000  23.189 -21.811  1.00 36.38           O  
ATOM    334  CB  GLU A  37      -6.617  24.829 -22.982  1.00 36.65           C  
ATOM    335  CG  GLU A  37      -7.628  25.142 -24.067  1.00 38.93           C  
ATOM    336  CD  GLU A  37      -7.972  26.603 -24.134  1.00 40.95           C  
ATOM    337  OE1 GLU A  37      -9.025  27.004 -23.590  1.00 41.17           O  
ATOM    338  OE2 GLU A  37      -7.178  27.353 -24.733  1.00 44.49           O  
ATOM    339  N   LEU A  38      -5.944  22.734 -20.754  1.00 36.38           N  
ATOM    340  CA  LEU A  38      -5.332  22.337 -19.485  1.00 36.10           C  
ATOM    341  C   LEU A  38      -4.555  21.034 -19.613  1.00 37.04           C  
ATOM    342  O   LEU A  38      -3.476  20.895 -19.033  1.00 36.78           O  
ATOM    343  CB  LEU A  38      -6.395  22.209 -18.395  1.00 35.34           C  
ATOM    344  CG  LEU A  38      -7.214  23.462 -18.089  1.00 33.45           C  
ATOM    345  CD1 LEU A  38      -8.402  23.136 -17.199  1.00 30.97           C  
ATOM    346  CD2 LEU A  38      -6.328  24.544 -17.468  1.00 31.85           C  
HETATM  347  N   MSE A  39      -5.113  20.082 -20.367  1.00 38.24           N  
HETATM  348  CA  MSE A  39      -4.426  18.832 -20.690  1.00 39.91           C  
HETATM  349  C   MSE A  39      -3.090  19.099 -21.371  1.00 40.39           C  
HETATM  350  O   MSE A  39      -2.085  18.474 -21.038  1.00 40.05           O  
HETATM  351  CB  MSE A  39      -5.295  17.943 -21.593  1.00 40.62           C  
HETATM  352  CG  MSE A  39      -6.410  17.189 -20.865  1.00 42.53           C  
HETATM  353 SE   MSE A  39      -5.753  15.949 -19.489  1.00 48.22          SE  
HETATM  354  CE  MSE A  39      -4.720  14.678 -20.597  1.00 46.69           C  
ATOM    355  N   ARG A  40      -3.089  20.043 -22.312  1.00 41.31           N  
ATOM    356  CA  ARG A  40      -1.877  20.403 -23.053  1.00 42.56           C  
ATOM    357  C   ARG A  40      -0.864  21.186 -22.215  1.00 42.62           C  
ATOM    358  O   ARG A  40       0.332  20.857 -22.211  1.00 42.98           O  
ATOM    359  CB  ARG A  40      -2.227  21.136 -24.354  1.00 42.31           C  
ATOM    360  CG  ARG A  40      -2.595  20.179 -25.482  1.00 43.91           C  
ATOM    361  CD  ARG A  40      -3.069  20.889 -26.744  1.00 44.10           C  
ATOM    362  NE  ARG A  40      -4.518  21.102 -26.745  1.00 48.77           N  
ATOM    363  CZ  ARG A  40      -5.118  22.298 -26.748  1.00 50.36           C  
ATOM    364  NH1 ARG A  40      -6.446  22.370 -26.746  1.00 51.05           N  
ATOM    365  NH2 ARG A  40      -4.404  23.425 -26.758  1.00 50.77           N  
ATOM    366  N   ALA A  41      -1.348  22.203 -21.501  1.00 42.74           N  
ATOM    367  CA  ALA A  41      -0.504  23.085 -20.694  1.00 42.79           C  
ATOM    368  C   ALA A  41       0.164  22.379 -19.512  1.00 43.06           C  
ATOM    369  O   ALA A  41       1.273  22.727 -19.125  1.00 43.10           O  
ATOM    370  CB  ALA A  41      -1.306  24.276 -20.209  1.00 42.80           C  
ATOM    371  N   LEU A  42      -0.509  21.385 -18.945  1.00 43.38           N  
ATOM    372  CA  LEU A  42      -0.000  20.719 -17.759  1.00 43.60           C  
ATOM    373  C   LEU A  42       0.562  19.359 -18.125  1.00 43.98           C  
ATOM    374  O   LEU A  42      -0.168  18.381 -18.255  1.00 44.18           O  
ATOM    375  CB  LEU A  42      -1.086  20.624 -16.682  1.00 43.70           C  
ATOM    376  CG  LEU A  42      -1.687  21.971 -16.252  1.00 43.12           C  
ATOM    377  CD1 LEU A  42      -2.815  21.763 -15.288  1.00 42.52           C  
ATOM    378  CD2 LEU A  42      -0.623  22.862 -15.635  1.00 43.67           C  
ATOM    379  N   ASP A  43       1.878  19.320 -18.289  1.00 44.46           N  
ATOM    380  CA  ASP A  43       2.569  18.147 -18.809  1.00 44.90           C  
ATOM    381  C   ASP A  43       2.577  16.966 -17.839  1.00 44.11           C  
ATOM    382  O   ASP A  43       3.133  17.047 -16.736  1.00 44.22           O  
ATOM    383  CB  ASP A  43       4.002  18.510 -19.212  1.00 45.59           C  
ATOM    384  CG  ASP A  43       4.376  17.959 -20.579  1.00 48.52           C  
ATOM    385  OD1 ASP A  43       5.135  16.957 -20.645  1.00 51.16           O  
ATOM    386  OD2 ASP A  43       3.893  18.523 -21.592  1.00 51.24           O  
ATOM    387  N   GLY A  44       1.961  15.867 -18.262  1.00 43.05           N  
ATOM    388  CA  GLY A  44       2.000  14.633 -17.490  1.00 41.88           C  
ATOM    389  C   GLY A  44       0.803  14.409 -16.590  1.00 40.94           C  
ATOM    390  O   GLY A  44       0.753  13.409 -15.868  1.00 41.28           O  
ATOM    391  N   ILE A  45      -0.145  15.345 -16.608  1.00 39.96           N  
ATOM    392  CA  ILE A  45      -1.415  15.168 -15.913  1.00 38.89           C  
ATOM    393  C   ILE A  45      -2.328  14.306 -16.777  1.00 38.61           C  
ATOM    394  O   ILE A  45      -2.408  14.489 -17.996  1.00 38.34           O  
ATOM    395  CB  ILE A  45      -2.116  16.525 -15.563  1.00 38.93           C  
ATOM    396  CG1 ILE A  45      -3.130  16.327 -14.423  1.00 38.23           C  
ATOM    397  CG2 ILE A  45      -2.772  17.145 -16.793  1.00 37.92           C  
ATOM    398  CD1 ILE A  45      -3.691  17.617 -13.834  1.00 38.27           C  
ATOM    399  N   THR A  46      -2.998  13.360 -16.137  1.00 38.09           N  
ATOM    400  CA  THR A  46      -3.959  12.517 -16.817  1.00 37.92           C  
ATOM    401  C   THR A  46      -5.333  13.156 -16.674  1.00 37.80           C  
ATOM    402  O   THR A  46      -5.537  13.991 -15.790  1.00 37.69           O  
ATOM    403  CB  THR A  46      -3.952  11.082 -16.245  1.00 37.87           C  
ATOM    404  OG1 THR A  46      -4.327  11.113 -14.864  1.00 39.13           O  
ATOM    405  CG2 THR A  46      -2.558  10.443 -16.375  1.00 37.79           C  
ATOM    406  N   GLN A  47      -6.264  12.778 -17.550  1.00 37.61           N  
ATOM    407  CA  GLN A  47      -7.626  13.306 -17.523  1.00 37.66           C  
ATOM    408  C   GLN A  47      -8.344  12.984 -16.216  1.00 37.54           C  
ATOM    409  O   GLN A  47      -9.171  13.771 -15.732  1.00 37.54           O  
ATOM    410  CB  GLN A  47      -8.427  12.755 -18.700  1.00 37.70           C  
ATOM    411  CG  GLN A  47      -9.847  13.304 -18.789  1.00 38.78           C  
ATOM    412  CD  GLN A  47      -9.877  14.810 -18.998  1.00 39.40           C  
ATOM    413  OE1 GLN A  47     -10.243  15.567 -18.101  1.00 40.08           O  
ATOM    414  NE2 GLN A  47      -9.473  15.248 -20.178  1.00 40.01           N  
ATOM    415  N   ARG A  48      -8.032  11.816 -15.660  1.00 37.60           N  
ATOM    416  CA  ARG A  48      -8.614  11.376 -14.396  1.00 37.51           C  
ATOM    417  C   ARG A  48      -8.170  12.315 -13.261  1.00 36.55           C  
ATOM    418  O   ARG A  48      -8.997  12.808 -12.494  1.00 36.29           O  
ATOM    419  CB  ARG A  48      -8.208   9.932 -14.115  1.00 37.94           C  
ATOM    420  CG  ARG A  48      -9.137   9.192 -13.161  1.00 40.77           C  
ATOM    421  CD  ARG A  48      -8.826   7.693 -13.161  1.00 44.75           C  
ATOM    422  NE  ARG A  48      -9.413   6.997 -14.310  1.00 46.35           N  
ATOM    423  CZ  ARG A  48      -9.041   5.787 -14.731  1.00 47.53           C  
ATOM    424  NH1 ARG A  48      -8.065   5.120 -14.114  1.00 48.05           N  
ATOM    425  NH2 ARG A  48      -9.637   5.249 -15.784  1.00 47.00           N  
ATOM    426  N   VAL A  49      -6.865  12.575 -13.187  1.00 35.48           N  
ATOM    427  CA  VAL A  49      -6.322  13.526 -12.205  1.00 34.69           C  
ATOM    428  C   VAL A  49      -6.878  14.947 -12.412  1.00 33.76           C  
ATOM    429  O   VAL A  49      -7.345  15.569 -11.462  1.00 33.78           O  
ATOM    430  CB  VAL A  49      -4.768  13.471 -12.139  1.00 34.54           C  
ATOM    431  CG1 VAL A  49      -4.210  14.579 -11.261  1.00 34.74           C  
ATOM    432  CG2 VAL A  49      -4.324  12.114 -11.606  1.00 34.14           C  
ATOM    433  N   LEU A  50      -6.894  15.421 -13.657  1.00 32.93           N  
ATOM    434  CA  LEU A  50      -7.441  16.744 -13.988  1.00 31.98           C  
ATOM    435  C   LEU A  50      -8.881  16.973 -13.528  1.00 32.24           C  
ATOM    436  O   LEU A  50      -9.149  17.935 -12.798  1.00 31.72           O  
ATOM    437  CB  LEU A  50      -7.301  17.041 -15.482  1.00 32.05           C  
ATOM    438  CG  LEU A  50      -7.777  18.395 -16.026  1.00 31.84           C  
ATOM    439  CD1 LEU A  50      -7.067  19.592 -15.361  1.00 29.08           C  
ATOM    440  CD2 LEU A  50      -7.594  18.432 -17.525  1.00 31.17           C  
ATOM    441  N   THR A  51      -9.810  16.111 -13.950  1.00 32.35           N  
ATOM    442  CA  THR A  51     -11.214  16.292 -13.566  1.00 32.54           C  
ATOM    443  C   THR A  51     -11.376  16.217 -12.044  1.00 32.01           C  
ATOM    444  O   THR A  51     -12.146  16.993 -11.460  1.00 31.95           O  
ATOM    445  CB  THR A  51     -12.188  15.301 -14.279  1.00 33.24           C  
ATOM    446  OG1 THR A  51     -11.754  13.952 -14.069  1.00 35.45           O  
ATOM    447  CG2 THR A  51     -12.244  15.573 -15.767  1.00 33.38           C  
ATOM    448  N   ASP A  52     -10.638  15.307 -11.415  1.00 31.27           N  
ATOM    449  CA  ASP A  52     -10.628  15.187  -9.950  1.00 31.96           C  
ATOM    450  C   ASP A  52     -10.275  16.517  -9.274  1.00 31.10           C  
ATOM    451  O   ASP A  52     -11.013  16.996  -8.419  1.00 31.53           O  
ATOM    452  CB  ASP A  52      -9.660  14.080  -9.495  1.00 32.01           C  
ATOM    453  CG  ASP A  52      -9.647  13.892  -7.976  1.00 34.59           C  
ATOM    454  OD1 ASP A  52     -10.619  13.316  -7.429  1.00 36.59           O  
ATOM    455  OD2 ASP A  52      -8.656  14.306  -7.327  1.00 36.96           O  
ATOM    456  N   ARG A  53      -9.151  17.107  -9.680  1.00 30.71           N  
ATOM    457  CA  ARG A  53      -8.725  18.426  -9.214  1.00 30.06           C  
ATOM    458  C   ARG A  53      -9.782  19.490  -9.396  1.00 29.61           C  
ATOM    459  O   ARG A  53     -10.100  20.214  -8.451  1.00 29.28           O  
ATOM    460  CB  ARG A  53      -7.458  18.857  -9.937  1.00 29.99           C  
ATOM    461  CG  ARG A  53      -6.183  18.713  -9.124  1.00 31.25           C  
ATOM    462  CD  ARG A  53      -5.709  17.274  -9.042  1.00 31.33           C  
ATOM    463  NE  ARG A  53      -6.494  16.513  -8.085  1.00 31.99           N  
ATOM    464  CZ  ARG A  53      -6.226  16.446  -6.786  1.00 33.65           C  
ATOM    465  NH1 ARG A  53      -5.180  17.097  -6.276  1.00 32.35           N  
ATOM    466  NH2 ARG A  53      -7.006  15.720  -5.997  1.00 33.92           N  
ATOM    467  N   LEU A  54     -10.337  19.576 -10.605  1.00 29.15           N  
ATOM    468  CA  LEU A  54     -11.325  20.615 -10.935  1.00 28.96           C  
ATOM    469  C   LEU A  54     -12.629  20.444 -10.163  1.00 29.20           C  
ATOM    470  O   LEU A  54     -13.297  21.420  -9.825  1.00 28.55           O  
ATOM    471  CB  LEU A  54     -11.595  20.658 -12.441  1.00 28.93           C  
ATOM    472  CG  LEU A  54     -10.441  21.077 -13.367  1.00 29.14           C  
ATOM    473  CD1 LEU A  54     -10.718  20.609 -14.805  1.00 30.23           C  
ATOM    474  CD2 LEU A  54     -10.199  22.581 -13.315  1.00 27.97           C  
ATOM    475  N   ARG A  55     -12.974  19.190  -9.890  1.00 30.05           N  
ATOM    476  CA  ARG A  55     -14.152  18.852  -9.104  1.00 30.94           C  
ATOM    477  C   ARG A  55     -13.977  19.358  -7.679  1.00 30.25           C  
ATOM    478  O   ARG A  55     -14.863  20.002  -7.145  1.00 30.29           O  
ATOM    479  CB  ARG A  55     -14.363  17.339  -9.096  1.00 31.59           C  
ATOM    480  CG  ARG A  55     -15.764  16.913  -9.457  1.00 35.69           C  
ATOM    481  CD  ARG A  55     -15.831  16.239 -10.830  1.00 40.97           C  
ATOM    482  NE  ARG A  55     -15.624  14.784 -10.732  1.00 44.49           N  
ATOM    483  CZ  ARG A  55     -16.115  13.883 -11.590  1.00 46.17           C  
ATOM    484  NH1 ARG A  55     -16.859  14.264 -12.629  1.00 46.51           N  
ATOM    485  NH2 ARG A  55     -15.869  12.589 -11.405  1.00 46.77           N  
ATOM    486  N   GLU A  56     -12.819  19.076  -7.080  1.00 30.03           N  
ATOM    487  CA  GLU A  56     -12.515  19.528  -5.716  1.00 30.09           C  
ATOM    488  C   GLU A  56     -12.495  21.045  -5.631  1.00 30.21           C  
ATOM    489  O   GLU A  56     -13.044  21.622  -4.688  1.00 29.94           O  
ATOM    490  CB  GLU A  56     -11.184  18.959  -5.219  1.00 30.04           C  
ATOM    491  CG  GLU A  56     -11.188  17.446  -4.987  1.00 30.19           C  
ATOM    492  CD  GLU A  56     -10.034  16.987  -4.122  1.00 31.79           C  
ATOM    493  OE1 GLU A  56      -9.978  15.782  -3.781  1.00 32.78           O  
ATOM    494  OE2 GLU A  56      -9.175  17.819  -3.776  1.00 32.08           O  
HETATM  495  N   MSE A  57     -11.885  21.682  -6.628  1.00 29.75           N  
HETATM  496  CA  MSE A  57     -11.760  23.134  -6.648  1.00 31.11           C  
HETATM  497  C   MSE A  57     -13.090  23.839  -6.889  1.00 29.46           C  
HETATM  498  O   MSE A  57     -13.336  24.888  -6.309  1.00 28.90           O  
HETATM  499  CB  MSE A  57     -10.715  23.586  -7.663  1.00 30.11           C  
HETATM  500  CG  MSE A  57      -9.324  23.110  -7.354  1.00 31.35           C  
HETATM  501 SE   MSE A  57      -8.124  23.505  -8.830  1.00 37.51          SE  
HETATM  502  CE  MSE A  57      -7.787  25.481  -8.422  1.00 30.55           C  
ATOM    503  N   GLU A  58     -13.943  23.258  -7.732  1.00 29.23           N  
ATOM    504  CA  GLU A  58     -15.320  23.746  -7.904  1.00 29.12           C  
ATOM    505  C   GLU A  58     -16.127  23.606  -6.604  1.00 28.67           C  
ATOM    506  O   GLU A  58     -16.862  24.513  -6.222  1.00 28.65           O  
ATOM    507  CB  GLU A  58     -16.035  23.025  -9.066  1.00 28.93           C  
ATOM    508  CG  GLU A  58     -17.466  23.564  -9.331  1.00 29.99           C  
ATOM    509  CD  GLU A  58     -18.244  22.822 -10.442  1.00 30.23           C  
ATOM    510  OE1 GLU A  58     -19.223  23.412 -10.956  1.00 31.56           O  
ATOM    511  OE2 GLU A  58     -17.884  21.677 -10.799  1.00 30.09           O  
ATOM    512  N   LYS A  59     -15.972  22.462  -5.938  1.00 28.40           N  
ATOM    513  CA  LYS A  59     -16.628  22.171  -4.657  1.00 28.68           C  
ATOM    514  C   LYS A  59     -16.262  23.207  -3.595  1.00 27.81           C  
ATOM    515  O   LYS A  59     -17.121  23.686  -2.867  1.00 27.01           O  
ATOM    516  CB  LYS A  59     -16.186  20.796  -4.145  1.00 29.11           C  
ATOM    517  CG  LYS A  59     -17.255  20.015  -3.407  1.00 32.50           C  
ATOM    518  CD  LYS A  59     -18.361  19.589  -4.385  1.00 38.74           C  
ATOM    519  CE  LYS A  59     -17.842  18.663  -5.514  1.00 41.24           C  
ATOM    520  NZ  LYS A  59     -18.278  17.221  -5.419  1.00 41.77           N  
ATOM    521  N   ASP A  60     -14.968  23.512  -3.516  1.00 27.17           N  
ATOM    522  CA  ASP A  60     -14.415  24.419  -2.524  1.00 26.96           C  
ATOM    523  C   ASP A  60     -14.714  25.878  -2.833  1.00 26.85           C  
ATOM    524  O   ASP A  60     -14.485  26.740  -1.983  1.00 27.34           O  
ATOM    525  CB  ASP A  60     -12.899  24.199  -2.383  1.00 26.84           C  
ATOM    526  CG  ASP A  60     -12.567  22.885  -1.702  1.00 27.27           C  
ATOM    527  OD1 ASP A  60     -13.481  22.286  -1.098  1.00 28.67           O  
ATOM    528  OD2 ASP A  60     -11.400  22.439  -1.764  1.00 27.96           O  
ATOM    529  N   GLY A  61     -15.214  26.150  -4.042  1.00 26.19           N  
ATOM    530  CA  GLY A  61     -15.639  27.496  -4.431  1.00 25.79           C  
ATOM    531  C   GLY A  61     -14.565  28.315  -5.125  1.00 25.73           C  
ATOM    532  O   GLY A  61     -14.645  29.535  -5.165  1.00 25.28           O  
ATOM    533  N   LEU A  62     -13.559  27.647  -5.680  1.00 25.82           N  
ATOM    534  CA  LEU A  62     -12.419  28.355  -6.277  1.00 26.48           C  
ATOM    535  C   LEU A  62     -12.535  28.449  -7.790  1.00 27.05           C  
ATOM    536  O   LEU A  62     -12.001  29.366  -8.401  1.00 26.87           O  
ATOM    537  CB  LEU A  62     -11.111  27.647  -5.933  1.00 25.78           C  
ATOM    538  CG  LEU A  62     -10.635  27.564  -4.494  1.00 26.39           C  
ATOM    539  CD1 LEU A  62      -9.494  26.568  -4.422  1.00 26.58           C  
ATOM    540  CD2 LEU A  62     -10.193  28.933  -4.050  1.00 25.05           C  
ATOM    541  N   VAL A  63     -13.225  27.470  -8.376  1.00 27.97           N  
ATOM    542  CA  VAL A  63     -13.335  27.328  -9.818  1.00 28.33           C  
ATOM    543  C   VAL A  63     -14.811  27.302 -10.223  1.00 29.06           C  
ATOM    544  O   VAL A  63     -15.629  26.649  -9.576  1.00 28.69           O  
ATOM    545  CB  VAL A  63     -12.586  26.056 -10.294  1.00 28.51           C  
ATOM    546  CG1 VAL A  63     -13.011  25.635 -11.700  1.00 28.29           C  
ATOM    547  CG2 VAL A  63     -11.082  26.280 -10.231  1.00 27.98           C  
ATOM    548  N   HIS A  64     -15.141  28.050 -11.274  1.00 30.06           N  
ATOM    549  CA  HIS A  64     -16.467  28.036 -11.873  1.00 31.06           C  
ATOM    550  C   HIS A  64     -16.416  27.195 -13.145  1.00 31.23           C  
ATOM    551  O   HIS A  64     -15.478  27.311 -13.941  1.00 30.37           O  
ATOM    552  CB  HIS A  64     -16.931  29.462 -12.175  1.00 31.74           C  
ATOM    553  CG  HIS A  64     -18.354  29.555 -12.635  1.00 34.54           C  
ATOM    554  ND1 HIS A  64     -18.704  29.660 -13.967  1.00 37.07           N  
ATOM    555  CD2 HIS A  64     -19.518  29.552 -11.941  1.00 36.27           C  
ATOM    556  CE1 HIS A  64     -20.020  29.724 -14.071  1.00 37.02           C  
ATOM    557  NE2 HIS A  64     -20.538  29.658 -12.857  1.00 36.97           N  
ATOM    558  N   ARG A  65     -17.405  26.319 -13.296  1.00 32.17           N  
ATOM    559  CA  ARG A  65     -17.571  25.517 -14.507  1.00 33.12           C  
ATOM    560  C   ARG A  65     -18.839  25.947 -15.231  1.00 34.21           C  
ATOM    561  O   ARG A  65     -19.939  25.850 -14.675  1.00 34.23           O  
ATOM    562  CB  ARG A  65     -17.651  24.040 -14.173  1.00 32.57           C  
ATOM    563  CG  ARG A  65     -17.345  23.163 -15.353  1.00 32.66           C  
ATOM    564  CD  ARG A  65     -17.643  21.704 -15.075  1.00 34.14           C  
ATOM    565  NE  ARG A  65     -18.938  21.372 -15.642  1.00 36.10           N  
ATOM    566  CZ  ARG A  65     -19.165  20.424 -16.540  1.00 35.41           C  
ATOM    567  NH1 ARG A  65     -20.398  20.258 -16.979  1.00 37.08           N  
ATOM    568  NH2 ARG A  65     -18.189  19.639 -16.979  1.00 35.01           N  
ATOM    569  N   GLU A  66     -18.684  26.452 -16.454  1.00 35.33           N  
ATOM    570  CA  GLU A  66     -19.841  26.865 -17.263  1.00 36.67           C  
ATOM    571  C   GLU A  66     -19.961  26.001 -18.503  1.00 36.50           C  
ATOM    572  O   GLU A  66     -18.992  25.823 -19.249  1.00 36.68           O  
ATOM    573  CB  GLU A  66     -19.760  28.342 -17.660  1.00 36.33           C  
ATOM    574  CG  GLU A  66     -21.085  28.888 -18.215  1.00 38.59           C  
ATOM    575  CD  GLU A  66     -21.021  30.358 -18.613  1.00 39.15           C  
ATOM    576  OE1 GLU A  66     -22.039  30.877 -19.134  1.00 40.70           O  
ATOM    577  OE2 GLU A  66     -19.956  30.995 -18.405  1.00 43.48           O  
ATOM    578  N   SER A  67     -21.147  25.439 -18.703  1.00 36.99           N  
ATOM    579  CA  SER A  67     -21.424  24.667 -19.910  1.00 36.98           C  
ATOM    580  C   SER A  67     -22.165  25.552 -20.901  1.00 36.92           C  
ATOM    581  O   SER A  67     -23.113  26.245 -20.537  1.00 36.72           O  
ATOM    582  CB  SER A  67     -22.243  23.410 -19.599  1.00 37.16           C  
ATOM    583  OG  SER A  67     -22.348  22.586 -20.761  1.00 37.45           O  
ATOM    584  N   PHE A  68     -21.711  25.551 -22.147  1.00 36.90           N  
ATOM    585  CA  PHE A  68     -22.395  26.300 -23.192  1.00 37.05           C  
ATOM    586  C   PHE A  68     -23.221  25.336 -24.056  1.00 36.87           C  
ATOM    587  O   PHE A  68     -22.683  24.352 -24.578  1.00 36.25           O  
ATOM    588  CB  PHE A  68     -21.384  27.078 -24.038  1.00 37.11           C  
ATOM    589  CG  PHE A  68     -20.681  28.179 -23.292  1.00 37.80           C  
ATOM    590  CD1 PHE A  68     -19.617  27.895 -22.435  1.00 37.84           C  
ATOM    591  CD2 PHE A  68     -21.079  29.508 -23.450  1.00 38.31           C  
ATOM    592  CE1 PHE A  68     -18.968  28.922 -21.739  1.00 38.75           C  
ATOM    593  CE2 PHE A  68     -20.428  30.550 -22.763  1.00 37.72           C  
ATOM    594  CZ  PHE A  68     -19.370  30.255 -21.909  1.00 37.73           C  
ATOM    595  N   ASN A  69     -24.527  25.584 -24.182  0.50 36.55           N  
ATOM    597  CA  ASN A  69     -25.396  24.729 -25.010  0.50 36.25           C  
ATOM    599  C   ASN A  69     -25.174  24.940 -26.523  0.50 36.29           C  
ATOM    601  O   ASN A  69     -26.058  25.417 -27.234  0.50 36.16           O  
ATOM    603  CB  ASN A  69     -26.881  24.903 -24.637  0.50 36.14           C  
ATOM    605  CG  ASN A  69     -27.343  23.961 -23.511  0.50 35.50           C  
ATOM    607  OD1 ASN A  69     -26.788  22.883 -23.296  0.50 34.35           O  
ATOM    609  ND2 ASN A  69     -28.387  24.373 -22.804  0.50 34.68           N  
ATOM    611  N   GLU A  70     -23.979  24.570 -26.987  1.00 36.30           N  
ATOM    612  CA  GLU A  70     -23.546  24.706 -28.385  1.00 36.25           C  
ATOM    613  C   GLU A  70     -23.516  23.368 -29.120  1.00 36.06           C  
ATOM    614  O   GLU A  70     -23.870  22.330 -28.559  1.00 36.07           O  
ATOM    615  CB  GLU A  70     -22.160  25.355 -28.463  1.00 36.19           C  
ATOM    616  CG  GLU A  70     -22.131  26.828 -28.084  1.00 37.33           C  
ATOM    617  CD  GLU A  70     -20.722  27.398 -27.982  1.00 36.65           C  
ATOM    618  OE1 GLU A  70     -20.605  28.554 -27.540  1.00 38.82           O  
ATOM    619  OE2 GLU A  70     -19.740  26.709 -28.335  1.00 36.32           O  
ATOM    620  N   LEU A  71     -23.070  23.409 -30.372  1.00 35.60           N  
ATOM    621  CA  LEU A  71     -23.003  22.236 -31.229  1.00 35.46           C  
ATOM    622  C   LEU A  71     -21.557  21.936 -31.671  1.00 35.22           C  
ATOM    623  O   LEU A  71     -21.108  22.434 -32.713  1.00 35.54           O  
ATOM    624  CB  LEU A  71     -23.910  22.431 -32.461  1.00 35.30           C  
ATOM    625  CG  LEU A  71     -25.421  22.138 -32.456  1.00 35.70           C  
ATOM    626  CD1 LEU A  71     -26.116  22.288 -31.105  1.00 36.37           C  
ATOM    627  CD2 LEU A  71     -26.119  22.990 -33.499  1.00 35.57           C  
ATOM    628  N   PRO A  72     -20.822  21.108 -30.893  1.00 34.78           N  
ATOM    629  CA  PRO A  72     -21.208  20.440 -29.649  1.00 34.33           C  
ATOM    630  C   PRO A  72     -21.008  21.325 -28.408  1.00 34.09           C  
ATOM    631  O   PRO A  72     -20.394  22.394 -28.516  1.00 33.79           O  
ATOM    632  CB  PRO A  72     -20.271  19.238 -29.610  1.00 34.10           C  
ATOM    633  CG  PRO A  72     -19.041  19.684 -30.303  1.00 34.42           C  
ATOM    634  CD  PRO A  72     -19.440  20.766 -31.286  1.00 34.92           C  
ATOM    635  N   PRO A  73     -21.531  20.894 -27.233  1.00 33.80           N  
ATOM    636  CA  PRO A  73     -21.378  21.722 -26.037  1.00 33.55           C  
ATOM    637  C   PRO A  73     -19.913  22.031 -25.725  1.00 33.27           C  
ATOM    638  O   PRO A  73     -19.018  21.255 -26.044  1.00 32.71           O  
ATOM    639  CB  PRO A  73     -21.999  20.867 -24.926  1.00 33.33           C  
ATOM    640  CG  PRO A  73     -22.922  19.975 -25.617  1.00 33.62           C  
ATOM    641  CD  PRO A  73     -22.274  19.662 -26.931  1.00 33.41           C  
ATOM    642  N   ARG A  74     -19.696  23.186 -25.119  1.00 33.41           N  
ATOM    643  CA  ARG A  74     -18.369  23.645 -24.788  1.00 33.78           C  
ATOM    644  C   ARG A  74     -18.389  24.001 -23.303  1.00 33.19           C  
ATOM    645  O   ARG A  74     -19.340  24.617 -22.823  1.00 33.30           O  
ATOM    646  CB  ARG A  74     -18.017  24.838 -25.676  1.00 34.02           C  
ATOM    647  CG  ARG A  74     -16.715  25.549 -25.352  1.00 34.90           C  
ATOM    648  CD  ARG A  74     -16.479  26.689 -26.332  1.00 34.54           C  
ATOM    649  NE  ARG A  74     -17.589  27.645 -26.353  1.00 35.89           N  
ATOM    650  CZ  ARG A  74     -17.572  28.831 -25.755  1.00 36.19           C  
ATOM    651  NH1 ARG A  74     -16.501  29.221 -25.062  1.00 37.00           N  
ATOM    652  NH2 ARG A  74     -18.627  29.631 -25.842  1.00 35.16           N  
ATOM    653  N   VAL A  75     -17.364  23.556 -22.578  1.00 32.59           N  
ATOM    654  CA  VAL A  75     -17.290  23.751 -21.126  1.00 32.00           C  
ATOM    655  C   VAL A  75     -16.087  24.629 -20.791  1.00 31.63           C  
ATOM    656  O   VAL A  75     -14.957  24.280 -21.139  1.00 31.71           O  
ATOM    657  CB  VAL A  75     -17.212  22.389 -20.363  1.00 32.42           C  
ATOM    658  CG1 VAL A  75     -17.125  22.613 -18.842  1.00 32.10           C  
ATOM    659  CG2 VAL A  75     -18.417  21.506 -20.705  1.00 31.15           C  
ATOM    660  N   GLU A  76     -16.327  25.752 -20.119  0.40 31.26           N  
ATOM    662  CA  GLU A  76     -15.249  26.685 -19.781  0.40 30.88           C  
ATOM    664  C   GLU A  76     -15.023  26.812 -18.270  0.40 30.65           C  
ATOM    666  O   GLU A  76     -15.959  27.051 -17.495  0.40 30.45           O  
ATOM    668  CB  GLU A  76     -15.495  28.064 -20.408  0.40 30.88           C  
ATOM    670  CG  GLU A  76     -15.573  28.069 -21.945  0.40 30.47           C  
ATOM    672  CD  GLU A  76     -14.221  28.168 -22.638  0.40 30.34           C  
ATOM    674  OE1 GLU A  76     -13.179  28.244 -21.953  0.40 30.06           O  
ATOM    676  OE2 GLU A  76     -14.204  28.173 -23.885  0.40 30.30           O  
ATOM    678  N   TYR A  77     -13.763  26.651 -17.873  1.00 30.40           N  
ATOM    679  CA  TYR A  77     -13.339  26.795 -16.473  1.00 29.49           C  
ATOM    680  C   TYR A  77     -12.712  28.168 -16.206  1.00 28.91           C  
ATOM    681  O   TYR A  77     -11.899  28.660 -16.981  1.00 28.84           O  
ATOM    682  CB  TYR A  77     -12.368  25.693 -16.100  1.00 29.27           C  
ATOM    683  CG  TYR A  77     -12.950  24.300 -16.214  1.00 29.44           C  
ATOM    684  CD1 TYR A  77     -13.673  23.752 -15.166  1.00 29.08           C  
ATOM    685  CD2 TYR A  77     -12.771  23.527 -17.368  1.00 29.58           C  
ATOM    686  CE1 TYR A  77     -14.199  22.483 -15.247  1.00 29.37           C  
ATOM    687  CE2 TYR A  77     -13.310  22.247 -17.464  1.00 28.97           C  
ATOM    688  CZ  TYR A  77     -14.027  21.734 -16.393  1.00 30.45           C  
ATOM    689  OH  TYR A  77     -14.565  20.462 -16.429  1.00 30.07           O  
ATOM    690  N   THR A  78     -13.116  28.786 -15.105  1.00 28.48           N  
ATOM    691  CA  THR A  78     -12.562  30.061 -14.661  1.00 27.97           C  
ATOM    692  C   THR A  78     -12.352  30.037 -13.140  1.00 27.76           C  
ATOM    693  O   THR A  78     -12.840  29.122 -12.459  1.00 27.14           O  
ATOM    694  CB  THR A  78     -13.511  31.231 -14.992  1.00 28.28           C  
ATOM    695  OG1 THR A  78     -14.852  30.833 -14.718  1.00 28.36           O  
ATOM    696  CG2 THR A  78     -13.400  31.643 -16.456  1.00 28.58           C  
ATOM    697  N   LEU A  79     -11.623  31.032 -12.619  1.00 26.61           N  
ATOM    698  CA  LEU A  79     -11.554  31.250 -11.177  1.00 26.40           C  
ATOM    699  C   LEU A  79     -12.788  32.025 -10.725  1.00 26.16           C  
ATOM    700  O   LEU A  79     -13.233  32.945 -11.410  1.00 26.37           O  
ATOM    701  CB  LEU A  79     -10.285  32.026 -10.780  1.00 25.61           C  
ATOM    702  CG  LEU A  79      -8.888  31.408 -10.927  1.00 26.37           C  
ATOM    703  CD1 LEU A  79      -7.803  32.415 -10.501  1.00 25.06           C  
ATOM    704  CD2 LEU A  79      -8.720  30.094 -10.156  1.00 24.48           C  
ATOM    705  N   THR A  80     -13.334  31.663  -9.566  1.00 25.93           N  
ATOM    706  CA  THR A  80     -14.375  32.471  -8.926  1.00 25.89           C  
ATOM    707  C   THR A  80     -13.763  33.756  -8.348  1.00 26.01           C  
ATOM    708  O   THR A  80     -12.538  33.904  -8.358  1.00 25.82           O  
ATOM    709  CB  THR A  80     -15.041  31.698  -7.783  1.00 26.14           C  
ATOM    710  OG1 THR A  80     -14.043  31.318  -6.836  1.00 26.30           O  
ATOM    711  CG2 THR A  80     -15.772  30.461  -8.304  1.00 25.23           C  
ATOM    712  N   PRO A  81     -14.603  34.709  -7.882  1.00 26.08           N  
ATOM    713  CA  PRO A  81     -14.072  35.827  -7.088  1.00 25.92           C  
ATOM    714  C   PRO A  81     -13.204  35.397  -5.899  1.00 25.80           C  
ATOM    715  O   PRO A  81     -12.137  35.967  -5.695  1.00 26.16           O  
ATOM    716  CB  PRO A  81     -15.337  36.547  -6.610  1.00 26.22           C  
ATOM    717  CG  PRO A  81     -16.342  36.262  -7.687  1.00 26.10           C  
ATOM    718  CD  PRO A  81     -16.055  34.856  -8.130  1.00 26.38           C  
ATOM    719  N   GLU A  82     -13.632  34.390  -5.137  1.00 25.63           N  
ATOM    720  CA  GLU A  82     -12.788  33.831  -4.068  1.00 25.40           C  
ATOM    721  C   GLU A  82     -11.548  33.139  -4.625  1.00 24.60           C  
ATOM    722  O   GLU A  82     -10.507  33.126  -3.978  1.00 24.20           O  
ATOM    723  CB  GLU A  82     -13.572  32.872  -3.159  1.00 25.99           C  
ATOM    724  CG  GLU A  82     -14.707  33.508  -2.361  1.00 27.37           C  
ATOM    725  CD  GLU A  82     -14.263  34.632  -1.427  1.00 31.36           C  
ATOM    726  OE1 GLU A  82     -13.085  34.681  -1.020  1.00 31.50           O  
ATOM    727  OE2 GLU A  82     -15.120  35.483  -1.078  1.00 35.53           O  
ATOM    728  N   GLY A  83     -11.666  32.575  -5.826  1.00 23.97           N  
ATOM    729  CA  GLY A  83     -10.530  31.989  -6.543  1.00 23.20           C  
ATOM    730  C   GLY A  83      -9.450  33.027  -6.823  1.00 23.04           C  
ATOM    731  O   GLY A  83      -8.274  32.816  -6.527  1.00 22.47           O  
ATOM    732  N   TYR A  84      -9.858  34.152  -7.398  1.00 22.93           N  
ATOM    733  CA  TYR A  84      -8.983  35.299  -7.596  1.00 23.19           C  
ATOM    734  C   TYR A  84      -8.406  35.860  -6.289  1.00 22.61           C  
ATOM    735  O   TYR A  84      -7.235  36.231  -6.238  1.00 23.16           O  
ATOM    736  CB  TYR A  84      -9.721  36.408  -8.366  1.00 23.83           C  
ATOM    737  CG  TYR A  84      -9.822  36.142  -9.850  1.00 24.57           C  
ATOM    738  CD1 TYR A  84      -8.687  36.201 -10.661  1.00 26.98           C  
ATOM    739  CD2 TYR A  84     -11.034  35.829 -10.440  1.00 24.42           C  
ATOM    740  CE1 TYR A  84      -8.755  35.950 -12.018  1.00 26.82           C  
ATOM    741  CE2 TYR A  84     -11.121  35.582 -11.808  1.00 26.57           C  
ATOM    742  CZ  TYR A  84      -9.976  35.650 -12.588  1.00 26.21           C  
ATOM    743  OH  TYR A  84     -10.038  35.414 -13.938  1.00 25.88           O  
ATOM    744  N   ALA A  85      -9.225  35.937  -5.243  1.00 21.98           N  
ATOM    745  CA  ALA A  85      -8.755  36.421  -3.952  1.00 21.53           C  
ATOM    746  C   ALA A  85      -7.656  35.518  -3.371  1.00 21.40           C  
ATOM    747  O   ALA A  85      -6.677  36.027  -2.840  1.00 21.46           O  
ATOM    748  CB  ALA A  85      -9.916  36.588  -2.956  1.00 21.46           C  
ATOM    749  N   LEU A  86      -7.811  34.192  -3.494  1.00 21.16           N  
ATOM    750  CA  LEU A  86      -6.794  33.249  -2.989  1.00 20.62           C  
ATOM    751  C   LEU A  86      -5.533  33.304  -3.844  1.00 21.21           C  
ATOM    752  O   LEU A  86      -4.411  33.264  -3.326  1.00 20.95           O  
ATOM    753  CB  LEU A  86      -7.331  31.822  -2.914  1.00 20.19           C  
ATOM    754  CG  LEU A  86      -6.446  30.738  -2.257  1.00 20.53           C  
ATOM    755  CD1 LEU A  86      -5.956  31.103  -0.848  1.00 17.21           C  
ATOM    756  CD2 LEU A  86      -7.236  29.447  -2.195  1.00 19.18           C  
ATOM    757  N   TYR A  87      -5.719  33.424  -5.158  1.00 21.99           N  
ATOM    758  CA  TYR A  87      -4.599  33.659  -6.050  1.00 22.48           C  
ATOM    759  C   TYR A  87      -3.738  34.830  -5.574  1.00 22.82           C  
ATOM    760  O   TYR A  87      -2.522  34.713  -5.529  1.00 23.50           O  
ATOM    761  CB  TYR A  87      -5.062  33.876  -7.496  1.00 22.63           C  
ATOM    762  CG  TYR A  87      -3.899  34.132  -8.423  1.00 22.97           C  
ATOM    763  CD1 TYR A  87      -3.292  33.095  -9.108  1.00 22.25           C  
ATOM    764  CD2 TYR A  87      -3.375  35.420  -8.574  1.00 22.50           C  
ATOM    765  CE1 TYR A  87      -2.199  33.331  -9.939  1.00 22.78           C  
ATOM    766  CE2 TYR A  87      -2.297  35.661  -9.388  1.00 22.91           C  
ATOM    767  CZ  TYR A  87      -1.721  34.612 -10.079  1.00 23.06           C  
ATOM    768  OH  TYR A  87      -0.646  34.858 -10.910  1.00 26.03           O  
ATOM    769  N   ASP A  88      -4.376  35.948  -5.224  1.00 23.51           N  
ATOM    770  CA  ASP A  88      -3.695  37.152  -4.721  1.00 23.88           C  
ATOM    771  C   ASP A  88      -2.972  36.964  -3.386  1.00 22.97           C  
ATOM    772  O   ASP A  88      -1.864  37.473  -3.208  1.00 22.99           O  
ATOM    773  CB  ASP A  88      -4.693  38.302  -4.573  1.00 25.06           C  
ATOM    774  CG  ASP A  88      -5.145  38.881  -5.915  1.00 28.53           C  
ATOM    775  OD1 ASP A  88      -4.540  38.566  -6.976  1.00 30.66           O  
ATOM    776  OD2 ASP A  88      -6.112  39.686  -5.893  1.00 33.19           O  
ATOM    777  N   ALA A  89      -3.610  36.258  -2.449  1.00 22.31           N  
ATOM    778  CA  ALA A  89      -2.993  35.913  -1.154  1.00 21.30           C  
ATOM    779  C   ALA A  89      -1.768  35.035  -1.353  1.00 20.92           C  
ATOM    780  O   ALA A  89      -0.741  35.242  -0.711  1.00 20.93           O  
ATOM    781  CB  ALA A  89      -4.003  35.212  -0.226  1.00 20.48           C  
ATOM    782  N   LEU A  90      -1.883  34.048  -2.238  1.00 20.78           N  
ATOM    783  CA  LEU A  90      -0.749  33.174  -2.557  1.00 20.41           C  
ATOM    784  C   LEU A  90       0.393  33.893  -3.276  1.00 20.51           C  
ATOM    785  O   LEU A  90       1.570  33.580  -3.033  1.00 19.77           O  
ATOM    786  CB  LEU A  90      -1.203  31.940  -3.342  1.00 20.38           C  
ATOM    787  CG  LEU A  90      -2.095  30.932  -2.598  1.00 20.64           C  
ATOM    788  CD1 LEU A  90      -2.442  29.757  -3.506  1.00 20.29           C  
ATOM    789  CD2 LEU A  90      -1.456  30.429  -1.319  1.00 20.83           C  
ATOM    790  N   SER A  91       0.052  34.845  -4.153  1.00 20.42           N  
ATOM    791  CA  SER A  91       1.067  35.657  -4.850  1.00 20.69           C  
ATOM    792  C   SER A  91       1.837  36.542  -3.889  1.00 20.25           C  
ATOM    793  O   SER A  91       3.029  36.729  -4.064  1.00 20.09           O  
ATOM    794  CB  SER A  91       0.454  36.538  -5.947  1.00 20.70           C  
ATOM    795  OG  SER A  91      -0.033  35.747  -6.998  1.00 22.79           O  
ATOM    796  N   SER A  92       1.151  37.082  -2.884  1.00 20.57           N  
ATOM    797  CA  SER A  92       1.799  37.859  -1.808  1.00 20.96           C  
ATOM    798  C   SER A  92       2.810  37.039  -1.005  1.00 21.05           C  
ATOM    799  O   SER A  92       3.902  37.520  -0.739  1.00 21.63           O  
ATOM    800  CB  SER A  92       0.753  38.447  -0.868  1.00 20.92           C  
ATOM    801  OG  SER A  92      -0.081  39.346  -1.569  1.00 23.80           O  
ATOM    802  N   LEU A  93       2.439  35.815  -0.622  1.00 20.99           N  
ATOM    803  CA  LEU A  93       3.349  34.862   0.024  1.00 21.67           C  
ATOM    804  C   LEU A  93       4.502  34.476  -0.887  1.00 21.60           C  
ATOM    805  O   LEU A  93       5.660  34.368  -0.462  1.00 21.50           O  
ATOM    806  CB  LEU A  93       2.611  33.562   0.367  1.00 21.45           C  
ATOM    807  CG  LEU A  93       1.701  33.502   1.575  1.00 23.72           C  
ATOM    808  CD1 LEU A  93       1.257  32.067   1.753  1.00 22.80           C  
ATOM    809  CD2 LEU A  93       2.439  33.990   2.829  1.00 24.49           C  
ATOM    810  N   CYS A  94       4.167  34.227  -2.147  1.00 21.43           N  
ATOM    811  CA  CYS A  94       5.179  33.923  -3.122  1.00 20.91           C  
ATOM    812  C   CYS A  94       6.201  35.058  -3.167  1.00 20.62           C  
ATOM    813  O   CYS A  94       7.389  34.812  -3.157  1.00 20.03           O  
ATOM    814  CB  CYS A  94       4.545  33.706  -4.493  1.00 20.57           C  
ATOM    815  SG  CYS A  94       5.758  33.450  -5.752  1.00 22.61           S  
ATOM    816  N   HIS A  95       5.710  36.295  -3.212  1.00 21.14           N  
ATOM    817  CA  HIS A  95       6.546  37.482  -3.303  1.00 22.16           C  
ATOM    818  C   HIS A  95       7.417  37.593  -2.044  1.00 21.92           C  
ATOM    819  O   HIS A  95       8.618  37.823  -2.127  1.00 22.36           O  
ATOM    820  CB  HIS A  95       5.650  38.717  -3.485  1.00 23.03           C  
ATOM    821  CG  HIS A  95       6.365  39.940  -3.973  1.00 26.65           C  
ATOM    822  ND1 HIS A  95       7.647  40.267  -3.586  1.00 32.08           N  
ATOM    823  CD2 HIS A  95       5.950  40.954  -4.768  1.00 30.52           C  
ATOM    824  CE1 HIS A  95       8.003  41.408  -4.148  1.00 31.63           C  
ATOM    825  NE2 HIS A  95       6.989  41.849  -4.868  1.00 30.98           N  
ATOM    826  N   TRP A  96       6.818  37.384  -0.877  1.00 21.40           N  
ATOM    827  CA  TRP A  96       7.590  37.293   0.348  1.00 20.97           C  
ATOM    828  C   TRP A  96       8.731  36.252   0.287  1.00 21.59           C  
ATOM    829  O   TRP A  96       9.894  36.575   0.600  1.00 21.07           O  
ATOM    830  CB  TRP A  96       6.684  37.027   1.562  1.00 19.75           C  
ATOM    831  CG  TRP A  96       7.374  37.434   2.784  1.00 18.87           C  
ATOM    832  CD1 TRP A  96       7.344  38.663   3.361  1.00 18.16           C  
ATOM    833  CD2 TRP A  96       8.294  36.643   3.556  1.00 18.22           C  
ATOM    834  NE1 TRP A  96       8.161  38.683   4.468  1.00 19.49           N  
ATOM    835  CE2 TRP A  96       8.756  37.453   4.606  1.00 19.00           C  
ATOM    836  CE3 TRP A  96       8.761  35.329   3.464  1.00 17.15           C  
ATOM    837  CZ2 TRP A  96       9.664  36.996   5.548  1.00 18.19           C  
ATOM    838  CZ3 TRP A  96       9.654  34.868   4.417  1.00 17.80           C  
ATOM    839  CH2 TRP A  96      10.098  35.700   5.437  1.00 18.75           C  
ATOM    840  N   GLY A  97       8.406  35.013  -0.081  1.00 21.77           N  
ATOM    841  CA  GLY A  97       9.414  33.948  -0.117  1.00 22.95           C  
ATOM    842  C   GLY A  97      10.527  34.169  -1.132  1.00 24.28           C  
ATOM    843  O   GLY A  97      11.644  33.718  -0.950  1.00 25.30           O  
ATOM    844  N   GLU A  98      10.211  34.858  -2.216  1.00 25.46           N  
ATOM    845  CA  GLU A  98      11.173  35.222  -3.247  1.00 26.72           C  
ATOM    846  C   GLU A  98      12.181  36.231  -2.684  1.00 25.82           C  
ATOM    847  O   GLU A  98      13.382  36.059  -2.818  1.00 25.57           O  
ATOM    848  CB  GLU A  98      10.393  35.819  -4.430  1.00 26.67           C  
ATOM    849  CG  GLU A  98      11.199  36.206  -5.645  1.00 29.51           C  
ATOM    850  CD  GLU A  98      10.357  36.968  -6.665  1.00 30.10           C  
ATOM    851  OE1 GLU A  98       9.924  36.349  -7.666  1.00 30.64           O  
ATOM    852  OE2 GLU A  98      10.103  38.184  -6.447  1.00 35.76           O  
ATOM    853  N   THR A  99      11.676  37.282  -2.048  1.00 25.69           N  
ATOM    854  CA  THR A  99      12.525  38.295  -1.434  1.00 25.72           C  
ATOM    855  C   THR A  99      13.440  37.678  -0.368  1.00 25.34           C  
ATOM    856  O   THR A  99      14.648  37.880  -0.379  1.00 25.09           O  
ATOM    857  CB  THR A  99      11.663  39.409  -0.840  1.00 25.83           C  
ATOM    858  OG1 THR A  99      10.876  39.960  -1.894  1.00 26.61           O  
ATOM    859  CG2 THR A  99      12.537  40.527  -0.229  1.00 25.88           C  
ATOM    860  N   PHE A 100      12.842  36.893   0.523  1.00 25.01           N  
ATOM    861  CA  PHE A 100      13.561  36.209   1.586  1.00 24.81           C  
ATOM    862  C   PHE A 100      14.642  35.261   1.070  1.00 25.07           C  
ATOM    863  O   PHE A 100      15.776  35.306   1.549  1.00 24.87           O  
ATOM    864  CB  PHE A 100      12.561  35.482   2.480  1.00 24.85           C  
ATOM    865  CG  PHE A 100      13.175  34.744   3.614  1.00 24.55           C  
ATOM    866  CD1 PHE A 100      13.710  35.423   4.699  1.00 24.77           C  
ATOM    867  CD2 PHE A 100      13.201  33.360   3.608  1.00 23.08           C  
ATOM    868  CE1 PHE A 100      14.278  34.719   5.762  1.00 24.00           C  
ATOM    869  CE2 PHE A 100      13.749  32.664   4.655  1.00 24.23           C  
ATOM    870  CZ  PHE A 100      14.289  33.341   5.740  1.00 24.03           C  
ATOM    871  N   ALA A 101      14.307  34.417   0.089  1.00 24.99           N  
ATOM    872  CA  ALA A 101      15.291  33.486  -0.474  1.00 25.51           C  
ATOM    873  C   ALA A 101      16.476  34.194  -1.122  1.00 26.09           C  
ATOM    874  O   ALA A 101      17.602  33.711  -1.062  1.00 26.01           O  
ATOM    875  CB  ALA A 101      14.644  32.522  -1.464  1.00 24.68           C  
ATOM    876  N   GLN A 102      16.211  35.332  -1.745  1.00 27.72           N  
ATOM    877  CA  GLN A 102      17.269  36.126  -2.357  1.00 29.45           C  
ATOM    878  C   GLN A 102      18.194  36.788  -1.332  1.00 30.39           C  
ATOM    879  O   GLN A 102      19.397  36.879  -1.555  1.00 30.70           O  
ATOM    880  CB  GLN A 102      16.684  37.123  -3.361  1.00 29.18           C  
ATOM    881  CG  GLN A 102      16.375  36.450  -4.698  1.00 30.62           C  
ATOM    882  CD  GLN A 102      15.415  37.230  -5.570  1.00 32.36           C  
ATOM    883  OE1 GLN A 102      15.434  38.460  -5.593  1.00 34.05           O  
ATOM    884  NE2 GLN A 102      14.570  36.510  -6.304  1.00 31.82           N  
ATOM    885  N   LYS A 103      17.632  37.241  -0.218  1.00 32.03           N  
ATOM    886  CA  LYS A 103      18.422  37.744   0.895  1.00 33.58           C  
ATOM    887  C   LYS A 103      19.346  36.652   1.435  1.00 34.49           C  
ATOM    888  O   LYS A 103      20.528  36.912   1.696  1.00 34.09           O  
ATOM    889  CB  LYS A 103      17.504  38.254   2.004  1.00 33.97           C  
ATOM    890  CG  LYS A 103      18.211  38.819   3.242  1.00 36.05           C  
ATOM    891  CD  LYS A 103      17.418  38.485   4.512  1.00 39.80           C  
ATOM    892  CE  LYS A 103      17.666  39.492   5.633  1.00 42.40           C  
ATOM    893  NZ  LYS A 103      16.922  39.101   6.879  1.00 43.97           N  
ATOM    894  N   LYS A 104      18.807  35.440   1.605  1.00 35.47           N  
ATOM    895  CA  LYS A 104      19.588  34.307   2.113  1.00 37.07           C  
ATOM    896  C   LYS A 104      20.754  33.972   1.196  1.00 37.45           C  
ATOM    897  O   LYS A 104      21.859  33.715   1.668  1.00 37.80           O  
ATOM    898  CB  LYS A 104      18.723  33.062   2.305  1.00 36.79           C  
ATOM    899  CG  LYS A 104      17.821  33.100   3.519  1.00 38.44           C  
ATOM    900  CD  LYS A 104      17.016  31.796   3.658  1.00 38.73           C  
ATOM    901  CE  LYS A 104      17.676  30.794   4.614  1.00 41.85           C  
ATOM    902  NZ  LYS A 104      16.741  29.659   4.941  1.00 42.39           N  
ATOM    903  N   ALA A 105      20.503  33.975  -0.109  1.00 38.09           N  
ATOM    904  CA  ALA A 105      21.536  33.681  -1.096  1.00 38.85           C  
ATOM    905  C   ALA A 105      22.639  34.748  -1.062  1.00 39.50           C  
ATOM    906  O   ALA A 105      23.832  34.427  -1.091  1.00 39.52           O  
ATOM    907  CB  ALA A 105      20.914  33.571  -2.480  1.00 38.50           C  
ATOM    908  N   ARG A 106      22.221  36.009  -0.972  0.50 39.88           N  
ATOM    910  CA  ARG A 106      23.123  37.158  -0.942  0.50 40.46           C  
ATOM    912  C   ARG A 106      24.037  37.173   0.294  0.50 41.06           C  
ATOM    914  O   ARG A 106      25.218  37.503   0.186  0.50 40.99           O  
ATOM    916  CB  ARG A 106      22.303  38.449  -1.021  0.50 40.29           C  
ATOM    918  CG  ARG A 106      23.081  39.693  -1.401  0.50 39.94           C  
ATOM    920  CD  ARG A 106      22.136  40.779  -1.914  0.50 38.70           C  
ATOM    922  NE  ARG A 106      22.838  41.996  -2.337  0.50 38.41           N  
ATOM    924  CZ  ARG A 106      23.445  42.163  -3.513  0.50 36.69           C  
ATOM    926  NH1 ARG A 106      23.462  41.183  -4.420  0.50 36.28           N  
ATOM    928  NH2 ARG A 106      24.040  43.314  -3.781  0.50 33.12           N  
ATOM    930  N   LEU A 107      23.488  36.808   1.452  1.00 41.62           N  
ATOM    931  CA  LEU A 107      24.231  36.847   2.720  1.00 43.11           C  
ATOM    932  C   LEU A 107      24.932  35.534   3.091  1.00 44.39           C  
ATOM    933  O   LEU A 107      25.657  35.475   4.089  1.00 45.07           O  
ATOM    934  CB  LEU A 107      23.323  37.318   3.866  1.00 42.95           C  
ATOM    935  CG  LEU A 107      22.635  38.685   3.734  1.00 43.20           C  
ATOM    936  CD1 LEU A 107      21.868  39.011   5.007  1.00 43.31           C  
ATOM    937  CD2 LEU A 107      23.618  39.817   3.390  1.00 43.17           C  
ATOM    938  N   ASN A 108      24.723  34.496   2.289  1.00 45.59           N  
ATOM    939  CA  ASN A 108      25.358  33.203   2.517  1.00 46.75           C  
ATOM    940  C   ASN A 108      26.733  33.107   1.848  1.00 47.02           C  
ATOM    941  O   ASN A 108      26.849  33.054   0.616  1.00 47.53           O  
ATOM    942  CB  ASN A 108      24.439  32.074   2.046  1.00 47.17           C  
ATOM    943  CG  ASN A 108      25.194  30.803   1.724  1.00 49.13           C  
ATOM    944  OD1 ASN A 108      25.673  30.102   2.621  1.00 51.79           O  
ATOM    945  ND2 ASN A 108      25.306  30.495   0.431  1.00 50.90           N  
TER     946      ASN A 108                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
