
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1161),  selected  138 , name 3bpx_B
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 3bpx_B.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     4_B      S       1           -
LGA    I     5_B      N       2           -
LGA    P     6_B      A       3           -
LGA    L     7_B      M       4           -
LGA    K     8_B      L       5           -
LGA    G     9_B      R       6           -
LGA    L    10_B      Y       7           -
LGA    L    11_B      G       8           -
LGA    S    12_B      D       9           -
LGA    I    13_B      T      10           -
LGA    I    14_B      E      11           -
LGA    L    15_B      I      12           -
LGA    R    16_B      C      13           -
LGA    S    17_B      I      14           -
LGA    H    18_B      D      15           -
LGA    R    19_B      -       -           -
LGA    V    20_B      -       -           -
LGA    F    21_B      -       -           -
LGA    I    22_B      -       -           -
LGA    G    23_B      -       -           -
LGA    R    24_B      -       -           -
LGA    E    25_B      -       -           -
LGA    L    26_B      -       -           -
LGA    G    27_B      -       -           -
LGA    H    28_B      P      16           #
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    -       -      S      19           -
LGA    L    29_B      V      20          3.501
LGA    N    30_B      L      21          2.496
LGA    -       -      H      22           -
LGA    -       -      L      23           -
LGA    L    31_B      L      24          0.222
LGA    T    32_B      G      25          2.622
LGA    -       -      K      26           -
LGA    D    33_B      K      27          4.032
LGA    A    34_B      Y      28          0.495
LGA    Q    35_B      T      29          0.901
LGA    V    36_B      M      30          0.886
LGA    A    37_B      L      31          0.628
LGA    C    38_B      I      32          0.935
LGA    L    39_B      I      33          1.012
LGA    L    40_B      S      34          0.877
LGA    R    41_B      V      35          0.713
LGA    I    42_B      L      36          0.977
LGA    H    43_B      G      37          0.603
LGA    R    44_B      N      38          0.614
LGA    E    45_B      G      39          3.329
LGA    -       -      S      40           -
LGA    P    46_B      T      41          3.899
LGA    G    47_B      R      42          0.648
LGA    I    48_B      Q      43          0.275
LGA    K    49_B      N      44          0.172
LGA    Q    50_B      F      45          1.280
LGA    D    51_B      N      46          2.463
LGA    E    52_B      D      47          2.365
LGA    L    53_B      I      48          1.589
LGA    A    54_B      R      49          1.945
LGA    T    55_B      S      50          3.201
LGA    F    56_B      S      51          3.202
LGA    F    57_B      I      52          2.679
LGA    -       -      P      53           -
LGA    H    58_B      G      54          4.216
LGA    V    59_B      I      55          3.039
LGA    D    60_B      S      56          2.669
LGA    K    61_B      S      57          1.885
LGA    G    62_B      T      58          1.591
LGA    T    63_B      I      59          1.658
LGA    I    64_B      L      60          0.987
LGA    A    65_B      S      61          0.219
LGA    R    66_B      R      62          0.481
LGA    T    67_B      R      63          1.307
LGA    L    68_B      I      64          0.761
LGA    R    69_B      K      65          1.143
LGA    R    70_B      D      66          1.780
LGA    L    71_B      L      67          1.446
LGA    E    72_B      I      68          1.419
LGA    E    73_B      D      69          1.766
LGA    S    74_B      S      70          1.683
LGA    G    75_B      G      71          1.240
LGA    F    76_B      L      72          1.091
LGA    I    77_B      V      73          0.835
LGA    E    78_B      E      74          0.555
LGA    R    79_B      R      75          0.625
LGA    E    80_B      R      76          1.223
LGA    Q    81_B      S      77          1.206
LGA    D    82_B      G      78          3.423
LGA    P    83_B      Q      79          2.016
LGA    E    84_B      I      80          4.292
LGA    N    85_B      -       -           -
LGA    R    86_B      -       -           -
LGA    R    87_B      -       -           -
LGA    R    88_B      -       -           -
LGA    Y    89_B      T      81          2.615
LGA    I    90_B      T      82          0.444
LGA    L    91_B      Y      83          0.544
LGA    E    92_B      A      84          0.786
LGA    V    93_B      L      85          0.862
LGA    T    94_B      T      86          0.586
LGA    R    95_B      E      87          0.462
LGA    R    96_B      K      88          0.547
LGA    G    97_B      G      89          0.972
LGA    E    98_B      M      90          1.076
LGA    E    99_B      N      91          1.084
LGA    I   100_B      V      92          1.757
LGA    I   101_B      R      93          1.495
LGA    P   102_B      N      94          2.052
LGA    L   103_B      S      95          1.181
LGA    I   104_B      L      96          0.372
LGA    L   105_B      M      97          0.483
LGA    K   106_B      P      98          0.987
LGA    V   107_B      L      99          0.911
LGA    E   108_B      L     100          0.827
LGA    E   109_B      Q     101          1.671
LGA    R   110_B      Y     102          2.240
LGA    W   111_B      I     103          2.110
LGA    E   112_B      S     104          3.030
LGA    D   113_B      V     105          3.385
LGA    L   114_B      L     106          3.927
LGA    L   115_B      D     107          4.590
LGA    -       -      R     108           -
LGA    F   116_B      N     109          2.514
LGA    R   117_B      -       -           -
LGA    D   118_B      -       -           -
LGA    F   119_B      -       -           -
LGA    T   120_B      -       -           -
LGA    E   121_B      -       -           -
LGA    D   122_B      -       -           -
LGA    E   123_B      -       -           -
LGA    R   124_B      -       -           -
LGA    K   125_B      -       -           -
LGA    L   126_B      -       -           -
LGA    F   127_B      -       -           -
LGA    R   128_B      -       -           -
LGA    K   129_B      -       -           -
LGA    M   130_B      -       -           -
LGA    C   131_B      -       -           -
LGA    R   132_B      -       -           -
LGA    R   133_B      -       -           -
LGA    L   134_B      -       -           -
LGA    A   135_B      -       -           -
LGA    E   136_B      -       -           -
LGA    E   137_B      -       -           -
LGA    A   138_B      -       -           -
LGA    V   139_B      -       -           -
LGA    R   140_B      -       -           -
LGA    M   141_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  109    5.0     84    1.97    11.90     68.512     4.049

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.383144 * X  +   0.413182 * Y  +  -0.826124 * Z  +  13.061206
  Y_new =   0.319198 * X  +   0.780050 * Y  +   0.538177 * Z  +  -3.005863
  Z_new =   0.866783 * X  +  -0.469896 * Y  +   0.166985 * Z  + -36.500248 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.229350    1.912243  [ DEG:   -70.4366    109.5634 ]
  Theta =  -1.048716   -2.092877  [ DEG:   -60.0870   -119.9130 ]
  Phi   =   0.694601   -2.446991  [ DEG:    39.7977   -140.2023 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bpx_B                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bpx_B.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  109   5.0   84   1.97   11.90  68.512
REMARK  ---------------------------------------------------------- 
MOLECULE 3bpx_B
HEADER    TRANSCRIPTION REGULATOR                 19-DEC-07   3BPX              
TITLE     CRYSTAL STRUCTURE OF MARR                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR;                                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOBACTERIUM THERMOAUTOTROPHICUM;           
SOURCE   3 GENE: MT313;                                                         
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: PET15B                                     
KEYWDS    MARR, TRANSCRIPTION FACTOR, WINGED HELIX MOTIF, DNA BINDING,          
KEYWDS   2 DNA-BINDING, TRANSCRIPTION REGULATION, TRANSCRIPTION                 
KEYWDS   3 REGULATOR                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.SARIDAKIS,D.SHAHINAS,X.XU,D.CHRISTENDAT                             
REVDAT   1   20-MAY-08 3BPX    0                                                
JRNL        AUTH   V.SARIDAKIS,D.SHAHINAS,X.XU,D.CHRISTENDAT                    
JRNL        TITL   STRUCTURAL INSIGHT ON THE MECHANISM OF REGULATION            
JRNL        TITL 2 OF THE MARR FAMILY OF PROTEINS: HIGH-RESOLUTION              
JRNL        TITL 3 CRYSTAL STRUCTURE OF A TRANSCRIPTIONAL REPRESSOR             
JRNL        TITL 4 FROM METHANOBACTERIUM THERMOAUTOTROPHICUM.                   
JRNL        REF    J.MOL.BIOL.                   V. 377   655 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  3BPX A    1   145  UNP    O26413   O26413_METTH     1    145             
DBREF  3BPX B    1   145  UNP    O26413   O26413_METTH     1    145             
SEQRES   1 A  148  GLY SER HIS MET ASP ARG ASP ILE PRO LEU LYS GLY LEU          
SEQRES   2 A  148  LEU SER ILE ILE LEU ARG SER HIS ARG VAL PHE ILE GLY          
SEQRES   3 A  148  ARG GLU LEU GLY HIS LEU ASN LEU THR ASP ALA GLN VAL          
SEQRES   4 A  148  ALA CYS LEU LEU ARG ILE HIS ARG GLU PRO GLY ILE LYS          
SEQRES   5 A  148  GLN ASP GLU LEU ALA THR PHE PHE HIS VAL ASP LYS GLY          
SEQRES   6 A  148  THR ILE ALA ARG THR LEU ARG ARG LEU GLU GLU SER GLY          
SEQRES   7 A  148  PHE ILE GLU ARG GLU GLN ASP PRO GLU ASN ARG ARG ARG          
SEQRES   8 A  148  TYR ILE LEU GLU VAL THR ARG ARG GLY GLU GLU ILE ILE          
SEQRES   9 A  148  PRO LEU ILE LEU LYS VAL GLU GLU ARG TRP GLU ASP LEU          
SEQRES  10 A  148  LEU PHE ARG ASP PHE THR GLU ASP GLU ARG LYS LEU PHE          
SEQRES  11 A  148  ARG LYS MET CYS ARG ARG LEU ALA GLU GLU ALA VAL ARG          
SEQRES  12 A  148  MET ARG GLY GLU TRP                                          
SEQRES   1 B  148  GLY SER HIS MET ASP ARG ASP ILE PRO LEU LYS GLY LEU          
SEQRES   2 B  148  LEU SER ILE ILE LEU ARG SER HIS ARG VAL PHE ILE GLY          
SEQRES   3 B  148  ARG GLU LEU GLY HIS LEU ASN LEU THR ASP ALA GLN VAL          
SEQRES   4 B  148  ALA CYS LEU LEU ARG ILE HIS ARG GLU PRO GLY ILE LYS          
SEQRES   5 B  148  GLN ASP GLU LEU ALA THR PHE PHE HIS VAL ASP LYS GLY          
SEQRES   6 B  148  THR ILE ALA ARG THR LEU ARG ARG LEU GLU GLU SER GLY          
SEQRES   7 B  148  PHE ILE GLU ARG GLU GLN ASP PRO GLU ASN ARG ARG ARG          
SEQRES   8 B  148  TYR ILE LEU GLU VAL THR ARG ARG GLY GLU GLU ILE ILE          
SEQRES   9 B  148  PRO LEU ILE LEU LYS VAL GLU GLU ARG TRP GLU ASP LEU          
SEQRES  10 B  148  LEU PHE ARG ASP PHE THR GLU ASP GLU ARG LYS LEU PHE          
SEQRES  11 B  148  ARG LYS MET CYS ARG ARG LEU ALA GLU GLU ALA VAL ARG          
SEQRES  12 B  148  MET ARG GLY GLU TRP                                          
HET     NA  A 146       1                                                       
HET     NA  A 147       1                                                       
HET     NA  A 148       1                                                       
HET     NA  A 149       1                                                       
HET     NA  B 146       1                                                       
HET     NA  B 147       1                                                       
HET    SAL  A 257      10                                                       
HET    SAL  B 258      10                                                       
HETNAM      NA SODIUM ION                                                       
HETNAM     SAL 2-HYDROXYBENZOIC ACID                                            
HETSYN     SAL SALICYLIC ACID                                                   
FORMUL   3   NA    6(NA 1+)                                                     
FORMUL   9  SAL    2(C7 H6 O3)                                                  
FORMUL  11  HOH   *244(H2 O)                                                    
CRYST1   40.109   51.527  139.243  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1341  N   ASP B   4      27.674  10.972  -7.033  1.00 51.68           N  
ATOM   1342  CA  ASP B   4      26.877  11.931  -6.216  1.00 50.56           C  
ATOM   1343  C   ASP B   4      25.385  11.738  -6.435  1.00 48.65           C  
ATOM   1344  O   ASP B   4      24.963  10.901  -7.234  1.00 49.78           O  
ATOM   1345  CB  ASP B   4      27.247  13.373  -6.569  1.00 53.50           C  
ATOM   1346  CG  ASP B   4      28.674  13.714  -6.205  1.00 56.08           C  
ATOM   1347  OD1 ASP B   4      29.030  13.577  -5.015  1.00 57.15           O  
ATOM   1348  OD2 ASP B   4      29.439  14.121  -7.107  1.00 57.83           O  
ATOM   1349  N   ILE B   5      24.592  12.520  -5.714  1.00 45.12           N  
ATOM   1350  CA  ILE B   5      23.145  12.448  -5.824  1.00 40.70           C  
ATOM   1351  C   ILE B   5      22.733  12.801  -7.249  1.00 38.26           C  
ATOM   1352  O   ILE B   5      23.262  13.742  -7.841  1.00 37.68           O  
ATOM   1353  CB  ILE B   5      22.474  13.428  -4.843  1.00 41.07           C  
ATOM   1354  CG1 ILE B   5      20.956  13.374  -5.012  1.00 40.00           C  
ATOM   1355  CG2 ILE B   5      23.005  14.840  -5.075  1.00 39.35           C  
ATOM   1356  CD1 ILE B   5      20.199  14.154  -3.977  1.00 38.79           C  
ATOM   1357  N   PRO B   6      21.797  12.034  -7.830  1.00 34.48           N  
ATOM   1358  CA  PRO B   6      21.374  12.342  -9.194  1.00 31.84           C  
ATOM   1359  C   PRO B   6      20.756  13.732  -9.257  1.00 29.27           C  
ATOM   1360  O   PRO B   6      20.237  14.234  -8.263  1.00 25.92           O  
ATOM   1361  CB  PRO B   6      20.362  11.241  -9.497  1.00 33.85           C  
ATOM   1362  CG  PRO B   6      20.875  10.086  -8.671  1.00 34.65           C  
ATOM   1363  CD  PRO B   6      21.201  10.768  -7.370  1.00 34.11           C  
ATOM   1364  N   LEU B   7      20.825  14.355 -10.426  1.00 28.13           N  
ATOM   1365  CA  LEU B   7      20.257  15.680 -10.605  1.00 26.84           C  
ATOM   1366  C   LEU B   7      18.828  15.710 -10.084  1.00 25.06           C  
ATOM   1367  O   LEU B   7      18.441  16.626  -9.366  1.00 24.97           O  
ATOM   1368  CB  LEU B   7      20.254  16.067 -12.082  1.00 27.39           C  
ATOM   1369  CG  LEU B   7      19.731  17.483 -12.314  1.00 30.05           C  
ATOM   1370  CD1 LEU B   7      20.780  18.466 -11.810  1.00 28.79           C  
ATOM   1371  CD2 LEU B   7      19.441  17.717 -13.791  1.00 31.90           C  
ATOM   1372  N   LYS B   8      18.046  14.697 -10.445  1.00 22.81           N  
ATOM   1373  CA  LYS B   8      16.650  14.622 -10.023  1.00 20.90           C  
ATOM   1374  C   LYS B   8      16.478  14.752  -8.510  1.00 18.39           C  
ATOM   1375  O   LYS B   8      15.487  15.309  -8.037  1.00 16.84           O  
ATOM   1376  CB  LYS B   8      16.028  13.304 -10.513  1.00 22.03           C  
ATOM   1377  CG  LYS B   8      14.535  13.172 -10.253  1.00 18.98           C  
ATOM   1378  CD  LYS B   8      14.241  12.465  -8.941  1.00 20.26           C  
ATOM   1379  CE  LYS B   8      12.749  12.180  -8.802  1.00 21.47           C  
ATOM   1380  NZ  LYS B   8      12.425  11.441  -7.550  1.00 24.44           N  
ATOM   1381  N   GLY B   9      17.445  14.237  -7.760  1.00 17.53           N  
ATOM   1382  CA  GLY B   9      17.372  14.305  -6.314  1.00 17.70           C  
ATOM   1383  C   GLY B   9      17.439  15.738  -5.837  1.00 18.25           C  
ATOM   1384  O   GLY B   9      16.719  16.126  -4.923  1.00 17.16           O  
ATOM   1385  N   LEU B  10      18.307  16.530  -6.461  1.00 18.62           N  
ATOM   1386  CA  LEU B  10      18.453  17.932  -6.095  1.00 16.86           C  
ATOM   1387  C   LEU B  10      17.198  18.731  -6.436  1.00 16.49           C  
ATOM   1388  O   LEU B  10      16.769  19.586  -5.669  1.00 14.96           O  
ATOM   1389  CB  LEU B  10      19.667  18.538  -6.813  1.00 17.39           C  
ATOM   1390  CG  LEU B  10      20.991  17.837  -6.494  1.00 20.20           C  
ATOM   1391  CD1 LEU B  10      22.122  18.385  -7.371  1.00 22.51           C  
ATOM   1392  CD2 LEU B  10      21.303  18.028  -5.027  1.00 19.47           C  
ATOM   1393  N   LEU B  11      16.609  18.450  -7.594  1.00 16.67           N  
ATOM   1394  CA  LEU B  11      15.403  19.156  -8.010  1.00 17.24           C  
ATOM   1395  C   LEU B  11      14.214  18.760  -7.141  1.00 16.80           C  
ATOM   1396  O   LEU B  11      13.360  19.585  -6.833  1.00 15.72           O  
ATOM   1397  CB  LEU B  11      15.107  18.862  -9.481  1.00 16.33           C  
ATOM   1398  CG  LEU B  11      16.257  19.197 -10.446  1.00 21.34           C  
ATOM   1399  CD1 LEU B  11      16.020  18.508 -11.783  1.00 20.65           C  
ATOM   1400  CD2 LEU B  11      16.377  20.715 -10.625  1.00 19.72           C  
ATOM   1401  N   SER B  12      14.162  17.494  -6.743  0.50 16.54           N  
ATOM   1403  CA  SER B  12      13.074  17.011  -5.900  0.50 16.65           C  
ATOM   1405  C   SER B  12      13.131  17.724  -4.556  0.50 15.77           C  
ATOM   1407  O   SER B  12      12.113  18.176  -4.036  0.50 17.11           O  
ATOM   1409  CB  SER B  12      13.194  15.498  -5.685  0.50 17.90           C  
ATOM   1411  OG  SER B  12      13.094  14.801  -6.912  0.50 19.99           O  
ATOM   1413  N   ILE B  13      14.334  17.812  -3.998  1.00 15.70           N  
ATOM   1414  CA  ILE B  13      14.551  18.478  -2.711  1.00 17.45           C  
ATOM   1415  C   ILE B  13      14.036  19.917  -2.784  1.00 16.63           C  
ATOM   1416  O   ILE B  13      13.280  20.365  -1.925  1.00 18.66           O  
ATOM   1417  CB  ILE B  13      16.061  18.459  -2.360  1.00 18.17           C  
ATOM   1418  CG1 ILE B  13      16.462  17.039  -1.947  1.00 22.37           C  
ATOM   1419  CG2 ILE B  13      16.380  19.464  -1.272  1.00 18.91           C  
ATOM   1420  CD1 ILE B  13      17.961  16.816  -1.814  1.00 23.41           C  
ATOM   1421  N   ILE B  14      14.442  20.634  -3.823  1.00 17.92           N  
ATOM   1422  CA  ILE B  14      14.012  22.018  -4.028  1.00 19.11           C  
ATOM   1423  C   ILE B  14      12.486  22.137  -4.159  1.00 20.33           C  
ATOM   1424  O   ILE B  14      11.828  22.891  -3.430  1.00 22.85           O  
ATOM   1425  CB  ILE B  14      14.678  22.582  -5.298  1.00 18.55           C  
ATOM   1426  CG1 ILE B  14      16.198  22.586  -5.107  1.00 17.49           C  
ATOM   1427  CG2 ILE B  14      14.171  23.984  -5.596  1.00 18.28           C  
ATOM   1428  CD1 ILE B  14      16.960  22.911  -6.350  1.00 17.97           C  
ATOM   1429  N   LEU B  15      11.919  21.382  -5.087  1.00 21.66           N  
ATOM   1430  CA  LEU B  15      10.485  21.418  -5.310  1.00 22.41           C  
ATOM   1431  C   LEU B  15       9.723  21.018  -4.050  1.00 21.83           C  
ATOM   1432  O   LEU B  15       8.613  21.492  -3.814  1.00 21.51           O  
ATOM   1433  CB  LEU B  15      10.120  20.482  -6.461  1.00 21.57           C  
ATOM   1434  CG  LEU B  15       8.635  20.427  -6.825  1.00 25.46           C  
ATOM   1435  CD1 LEU B  15       8.117  21.838  -7.119  1.00 23.04           C  
ATOM   1436  CD2 LEU B  15       8.447  19.513  -8.034  1.00 24.22           C  
ATOM   1437  N   ARG B  16      10.328  20.148  -3.242  1.00 20.87           N  
ATOM   1438  CA  ARG B  16       9.703  19.684  -2.004  1.00 21.49           C  
ATOM   1439  C   ARG B  16       9.471  20.824  -1.007  1.00 19.52           C  
ATOM   1440  O   ARG B  16       8.479  20.836  -0.292  1.00 19.34           O  
ATOM   1441  CB  ARG B  16      10.573  18.596  -1.361  1.00 24.09           C  
ATOM   1442  CG  ARG B  16       9.886  17.798  -0.273  1.00 27.33           C  
ATOM   1443  CD  ARG B  16      10.732  16.594   0.117  1.00 29.16           C  
ATOM   1444  NE  ARG B  16      10.972  15.728  -1.035  1.00 33.91           N  
ATOM   1445  CZ  ARG B  16      12.142  15.162  -1.317  1.00 33.02           C  
ATOM   1446  NH1 ARG B  16      13.187  15.366  -0.524  1.00 34.29           N  
ATOM   1447  NH2 ARG B  16      12.269  14.411  -2.404  1.00 31.80           N  
ATOM   1448  N   SER B  17      10.389  21.782  -0.963  0.50 18.54           N  
ATOM   1449  CA  SER B  17      10.238  22.900  -0.041  0.50 19.50           C  
ATOM   1450  C   SER B  17       9.096  23.811  -0.484  0.50 18.02           C  
ATOM   1452  O   SER B  17       8.485  24.496   0.331  0.50 17.50           O  
ATOM   1454  CB  SER B  17      11.542  23.698   0.056  0.50 20.28           C  
ATOM   1456  OG  SER B  17      11.879  24.274  -1.186  0.50 21.54           O  
ATOM   1458  N   HIS B  18       8.811  23.814  -1.780  1.00 18.15           N  
ATOM   1459  CA  HIS B  18       7.738  24.635  -2.309  1.00 18.81           C  
ATOM   1460  C   HIS B  18       6.426  23.982  -1.900  1.00 18.89           C  
ATOM   1461  O   HIS B  18       5.488  24.662  -1.502  1.00 16.72           O  
ATOM   1462  CB  HIS B  18       7.820  24.734  -3.823  1.00 19.35           C  
ATOM   1463  CG  HIS B  18       6.641  25.414  -4.444  1.00 18.72           C  
ATOM   1464  ND1 HIS B  18       5.419  24.795  -4.595  1.00 18.90           N  
ATOM   1465  CD2 HIS B  18       6.490  26.668  -4.936  1.00 16.87           C  
ATOM   1466  CE1 HIS B  18       4.566  25.636  -5.154  1.00 17.53           C  
ATOM   1467  NE2 HIS B  18       5.191  26.779  -5.372  1.00 15.99           N  
ATOM   1468  N   ARG B  19       6.380  22.657  -2.001  0.50 20.28           N  
ATOM   1470  CA  ARG B  19       5.198  21.886  -1.636  0.50 21.95           C  
ATOM   1472  C   ARG B  19       4.891  22.101  -0.154  0.50 22.18           C  
ATOM   1474  O   ARG B  19       3.737  22.281   0.237  0.50 23.58           O  
ATOM   1476  CB  ARG B  19       5.452  20.398  -1.901  0.50 23.05           C  
ATOM   1478  CG  ARG B  19       4.215  19.508  -1.884  0.50 25.86           C  
ATOM   1480  CD  ARG B  19       4.614  18.034  -1.871  0.50 26.13           C  
ATOM   1482  NE  ARG B  19       5.809  17.796  -2.679  0.50 26.33           N  
ATOM   1484  CZ  ARG B  19       5.870  17.955  -3.998  0.50 26.14           C  
ATOM   1486  NH1 ARG B  19       4.797  18.347  -4.673  0.50 27.90           N  
ATOM   1488  NH2 ARG B  19       7.010  17.745  -4.638  0.50 23.57           N  
ATOM   1490  N   VAL B  20       5.936  22.089   0.668  1.00 21.75           N  
ATOM   1491  CA  VAL B  20       5.782  22.277   2.103  1.00 22.21           C  
ATOM   1492  C   VAL B  20       5.399  23.715   2.427  1.00 22.39           C  
ATOM   1493  O   VAL B  20       4.609  23.969   3.337  1.00 21.86           O  
ATOM   1494  CB  VAL B  20       7.079  21.943   2.863  1.00 21.89           C  
ATOM   1495  CG1 VAL B  20       6.945  22.338   4.325  1.00 22.76           C  
ATOM   1496  CG2 VAL B  20       7.378  20.459   2.740  1.00 25.88           C  
ATOM   1497  N   PHE B  21       5.968  24.656   1.682  1.00 20.63           N  
ATOM   1498  CA  PHE B  21       5.683  26.062   1.905  1.00 19.35           C  
ATOM   1499  C   PHE B  21       4.214  26.387   1.596  1.00 18.74           C  
ATOM   1500  O   PHE B  21       3.564  27.080   2.360  1.00 19.63           O  
ATOM   1501  CB  PHE B  21       6.629  26.916   1.049  1.00 17.67           C  
ATOM   1502  CG  PHE B  21       6.560  28.390   1.348  1.00 19.86           C  
ATOM   1503  CD1 PHE B  21       7.044  28.893   2.554  1.00 21.97           C  
ATOM   1504  CD2 PHE B  21       6.014  29.275   0.420  1.00 20.22           C  
ATOM   1505  CE1 PHE B  21       6.985  30.258   2.834  1.00 24.35           C  
ATOM   1506  CE2 PHE B  21       5.952  30.641   0.684  1.00 22.07           C  
ATOM   1507  CZ  PHE B  21       6.438  31.134   1.894  1.00 21.98           C  
ATOM   1508  N   ILE B  22       3.683  25.887   0.484  1.00 20.38           N  
ATOM   1509  CA  ILE B  22       2.283  26.166   0.148  1.00 21.00           C  
ATOM   1510  C   ILE B  22       1.371  25.629   1.251  1.00 22.75           C  
ATOM   1511  O   ILE B  22       0.399  26.284   1.654  1.00 21.79           O  
ATOM   1512  CB  ILE B  22       1.892  25.532  -1.210  1.00 24.13           C  
ATOM   1513  CG1 ILE B  22       2.593  26.277  -2.345  1.00 22.05           C  
ATOM   1514  CG2 ILE B  22       0.380  25.555  -1.401  1.00 21.85           C  
ATOM   1515  CD1 ILE B  22       2.310  27.746  -2.381  1.00 28.55           C  
ATOM   1516  N   GLY B  23       1.693  24.439   1.746  1.00 23.87           N  
ATOM   1517  CA  GLY B  23       0.894  23.856   2.809  1.00 25.68           C  
ATOM   1518  C   GLY B  23       0.818  24.775   4.016  1.00 27.05           C  
ATOM   1519  O   GLY B  23      -0.253  24.967   4.601  1.00 27.63           O  
ATOM   1520  N   ARG B  24       1.955  25.358   4.385  1.00 26.21           N  
ATOM   1521  CA  ARG B  24       2.016  26.258   5.527  1.00 26.34           C  
ATOM   1522  C   ARG B  24       1.302  27.578   5.301  1.00 25.94           C  
ATOM   1523  O   ARG B  24       0.602  28.075   6.181  1.00 27.32           O  
ATOM   1524  CB  ARG B  24       3.464  26.570   5.882  1.00 28.08           C  
ATOM   1525  CG  ARG B  24       4.244  25.422   6.465  1.00 29.81           C  
ATOM   1526  CD  ARG B  24       5.716  25.797   6.494  1.00 32.05           C  
ATOM   1527  NE  ARG B  24       5.971  27.009   7.272  1.00 34.26           N  
ATOM   1528  CZ  ARG B  24       6.045  27.040   8.598  1.00 36.90           C  
ATOM   1529  NH1 ARG B  24       5.880  25.920   9.296  1.00 35.67           N  
ATOM   1530  NH2 ARG B  24       6.306  28.184   9.227  1.00 35.21           N  
ATOM   1531  N   GLU B  25       1.493  28.152   4.121  1.00 24.51           N  
ATOM   1532  CA  GLU B  25       0.902  29.438   3.806  1.00 24.07           C  
ATOM   1533  C   GLU B  25      -0.527  29.417   3.283  1.00 22.87           C  
ATOM   1534  O   GLU B  25      -1.241  30.396   3.431  1.00 25.11           O  
ATOM   1535  CB  GLU B  25       1.800  30.168   2.807  1.00 24.91           C  
ATOM   1536  CG  GLU B  25       3.242  30.273   3.279  1.00 26.35           C  
ATOM   1537  CD  GLU B  25       3.413  31.280   4.403  1.00 28.18           C  
ATOM   1538  OE1 GLU B  25       4.361  31.127   5.196  1.00 28.40           O  
ATOM   1539  OE2 GLU B  25       2.606  32.230   4.481  1.00 26.21           O  
ATOM   1540  N   LEU B  26      -0.957  28.320   2.675  1.00 22.20           N  
ATOM   1541  CA  LEU B  26      -2.311  28.284   2.135  1.00 20.06           C  
ATOM   1542  C   LEU B  26      -3.099  27.054   2.538  1.00 21.80           C  
ATOM   1543  O   LEU B  26      -4.218  26.854   2.070  1.00 18.52           O  
ATOM   1544  CB  LEU B  26      -2.255  28.383   0.606  1.00 20.05           C  
ATOM   1545  CG  LEU B  26      -1.599  29.666   0.079  1.00 19.13           C  
ATOM   1546  CD1 LEU B  26      -1.251  29.510  -1.401  1.00 17.33           C  
ATOM   1547  CD2 LEU B  26      -2.534  30.843   0.292  1.00 19.33           C  
ATOM   1548  N   GLY B  27      -2.514  26.232   3.406  1.00 23.15           N  
ATOM   1549  CA  GLY B  27      -3.192  25.028   3.844  1.00 25.68           C  
ATOM   1550  C   GLY B  27      -4.535  25.324   4.475  1.00 25.37           C  
ATOM   1551  O   GLY B  27      -5.451  24.516   4.397  1.00 26.79           O  
ATOM   1552  N   HIS B  28      -4.663  26.491   5.093  1.00 27.25           N  
ATOM   1553  CA  HIS B  28      -5.922  26.850   5.737  1.00 26.39           C  
ATOM   1554  C   HIS B  28      -7.054  27.020   4.713  1.00 27.74           C  
ATOM   1555  O   HIS B  28      -8.234  27.072   5.076  1.00 26.16           O  
ATOM   1556  CB  HIS B  28      -5.749  28.120   6.577  1.00 23.58           C  
ATOM   1557  CG  HIS B  28      -5.426  29.345   5.778  1.00 21.98           C  
ATOM   1558  ND1 HIS B  28      -4.190  29.560   5.205  1.00 17.72           N  
ATOM   1559  CD2 HIS B  28      -6.185  30.415   5.447  1.00 17.94           C  
ATOM   1560  CE1 HIS B  28      -4.204  30.710   4.555  1.00 21.38           C  
ATOM   1561  NE2 HIS B  28      -5.404  31.249   4.685  1.00 21.70           N  
ATOM   1562  N   LEU B  29      -6.689  27.097   3.433  1.00 27.31           N  
ATOM   1563  CA  LEU B  29      -7.669  27.228   2.359  1.00 24.81           C  
ATOM   1564  C   LEU B  29      -7.799  25.892   1.638  1.00 24.73           C  
ATOM   1565  O   LEU B  29      -8.439  25.808   0.588  1.00 22.37           O  
ATOM   1566  CB  LEU B  29      -7.242  28.299   1.347  1.00 26.42           C  
ATOM   1567  CG  LEU B  29      -7.069  29.733   1.856  1.00 27.33           C  
ATOM   1568  CD1 LEU B  29      -6.659  30.640   0.701  1.00 27.50           C  
ATOM   1569  CD2 LEU B  29      -8.365  30.219   2.481  1.00 26.75           C  
ATOM   1570  N   ASN B  30      -7.194  24.853   2.211  1.00 23.93           N  
ATOM   1571  CA  ASN B  30      -7.213  23.509   1.629  1.00 24.52           C  
ATOM   1572  C   ASN B  30      -6.687  23.539   0.201  1.00 25.44           C  
ATOM   1573  O   ASN B  30      -7.202  22.844  -0.676  1.00 24.31           O  
ATOM   1574  CB  ASN B  30      -8.632  22.928   1.640  1.00 27.73           C  
ATOM   1575  CG  ASN B  30      -9.208  22.826   3.041  1.00 32.05           C  
ATOM   1576  OD1 ASN B  30      -8.605  22.216   3.928  1.00 34.21           O  
ATOM   1577  ND2 ASN B  30     -10.377  23.428   3.248  1.00 31.73           N  
ATOM   1578  N   LEU B  31      -5.659  24.354  -0.023  1.00 23.63           N  
ATOM   1579  CA  LEU B  31      -5.049  24.485  -1.342  1.00 22.80           C  
ATOM   1580  C   LEU B  31      -3.760  23.682  -1.385  1.00 23.20           C  
ATOM   1581  O   LEU B  31      -3.023  23.638  -0.404  1.00 24.23           O  
ATOM   1582  CB  LEU B  31      -4.743  25.961  -1.645  1.00 20.87           C  
ATOM   1583  CG  LEU B  31      -5.937  26.834  -2.050  1.00 20.58           C  
ATOM   1584  CD1 LEU B  31      -5.513  28.295  -2.146  1.00 17.01           C  
ATOM   1585  CD2 LEU B  31      -6.478  26.344  -3.392  1.00 19.86           C  
ATOM   1586  N   THR B  32      -3.506  23.046  -2.524  1.00 21.58           N  
ATOM   1587  CA  THR B  32      -2.306  22.248  -2.734  1.00 20.76           C  
ATOM   1588  C   THR B  32      -1.507  22.883  -3.875  1.00 21.29           C  
ATOM   1589  O   THR B  32      -1.963  23.836  -4.497  1.00 19.17           O  
ATOM   1590  CB  THR B  32      -2.661  20.807  -3.161  1.00 22.23           C  
ATOM   1591  OG1 THR B  32      -3.544  20.843  -4.294  1.00 20.70           O  
ATOM   1592  CG2 THR B  32      -3.329  20.051  -2.015  1.00 22.96           C  
ATOM   1593  N   ASP B  33      -0.322  22.349  -4.143  1.00 20.97           N  
ATOM   1594  CA  ASP B  33       0.512  22.843  -5.237  1.00 22.69           C  
ATOM   1595  C   ASP B  33      -0.262  22.732  -6.536  1.00 20.15           C  
ATOM   1596  O   ASP B  33      -0.339  23.685  -7.312  1.00 19.59           O  
ATOM   1597  CB  ASP B  33       1.788  22.005  -5.361  1.00 27.43           C  
ATOM   1598  CG  ASP B  33       2.914  22.533  -4.506  1.00 32.19           C  
ATOM   1599  OD1 ASP B  33       2.619  23.204  -3.492  1.00 36.37           O  
ATOM   1600  OD2 ASP B  33       4.089  22.270  -4.840  1.00 32.11           O  
ATOM   1601  N   ALA B  34      -0.819  21.549  -6.768  1.00 18.94           N  
ATOM   1602  CA  ALA B  34      -1.576  21.287  -7.976  1.00 19.57           C  
ATOM   1603  C   ALA B  34      -2.728  22.279  -8.127  1.00 19.54           C  
ATOM   1604  O   ALA B  34      -2.934  22.839  -9.209  1.00 18.78           O  
ATOM   1605  CB  ALA B  34      -2.103  19.847  -7.963  1.00 20.95           C  
ATOM   1606  N   GLN B  35      -3.463  22.517  -7.039  1.00 17.06           N  
ATOM   1607  CA  GLN B  35      -4.592  23.449  -7.079  1.00 17.33           C  
ATOM   1608  C   GLN B  35      -4.187  24.889  -7.332  1.00 16.49           C  
ATOM   1609  O   GLN B  35      -4.841  25.589  -8.097  1.00 14.03           O  
ATOM   1610  CB  GLN B  35      -5.399  23.383  -5.779  1.00 15.91           C  
ATOM   1611  CG  GLN B  35      -6.255  22.151  -5.682  1.00 20.19           C  
ATOM   1612  CD  GLN B  35      -7.012  22.096  -4.376  1.00 18.58           C  
ATOM   1613  OE1 GLN B  35      -7.868  22.932  -4.116  1.00 18.12           O  
ATOM   1614  NE2 GLN B  35      -6.691  21.115  -3.548  1.00 19.96           N  
ATOM   1615  N   VAL B  36      -3.129  25.343  -6.665  1.00 15.38           N  
ATOM   1616  CA  VAL B  36      -2.666  26.700  -6.870  1.00 17.42           C  
ATOM   1617  C   VAL B  36      -2.272  26.877  -8.341  1.00 18.38           C  
ATOM   1618  O   VAL B  36      -2.644  27.863  -8.972  1.00 17.21           O  
ATOM   1619  CB  VAL B  36      -1.449  27.027  -5.969  1.00 18.46           C  
ATOM   1620  CG1 VAL B  36      -0.714  28.250  -6.510  1.00 19.48           C  
ATOM   1621  CG2 VAL B  36      -1.912  27.287  -4.533  1.00 19.90           C  
ATOM   1622  N   ALA B  37      -1.527  25.916  -8.877  1.00 18.26           N  
ATOM   1623  CA  ALA B  37      -1.083  25.975 -10.267  1.00 19.33           C  
ATOM   1624  C   ALA B  37      -2.266  26.093 -11.233  1.00 18.93           C  
ATOM   1625  O   ALA B  37      -2.281  26.950 -12.129  1.00 16.80           O  
ATOM   1626  CB  ALA B  37      -0.252  24.735 -10.602  1.00 17.97           C  
ATOM   1627  N   CYS B  38      -3.260  25.227 -11.066  1.00 19.04           N  
ATOM   1628  CA  CYS B  38      -4.424  25.291 -11.943  1.00 20.13           C  
ATOM   1629  C   CYS B  38      -5.160  26.610 -11.780  1.00 19.05           C  
ATOM   1630  O   CYS B  38      -5.554  27.246 -12.766  1.00 18.50           O  
ATOM   1631  CB  CYS B  38      -5.382  24.119 -11.662  1.00 22.07           C  
ATOM   1632  SG  CYS B  38      -4.727  22.525 -12.198  1.00 22.38           S  
ATOM   1633  N   LEU B  39      -5.355  27.017 -10.530  1.00 19.04           N  
ATOM   1634  CA  LEU B  39      -6.055  28.259 -10.237  1.00 19.73           C  
ATOM   1635  C   LEU B  39      -5.374  29.454 -10.885  1.00 21.69           C  
ATOM   1636  O   LEU B  39      -6.037  30.340 -11.429  1.00 21.92           O  
ATOM   1637  CB  LEU B  39      -6.135  28.470  -8.723  1.00 20.08           C  
ATOM   1638  CG  LEU B  39      -6.830  29.748  -8.260  1.00 19.88           C  
ATOM   1639  CD1 LEU B  39      -8.183  29.888  -8.962  1.00 20.19           C  
ATOM   1640  CD2 LEU B  39      -6.998  29.711  -6.739  1.00 20.85           C  
ATOM   1641  N   LEU B  40      -4.048  29.487 -10.822  1.00 21.36           N  
ATOM   1642  CA  LEU B  40      -3.317  30.599 -11.413  1.00 22.03           C  
ATOM   1643  C   LEU B  40      -3.391  30.602 -12.929  1.00 21.55           C  
ATOM   1644  O   LEU B  40      -3.533  31.659 -13.550  1.00 21.32           O  
ATOM   1645  CB  LEU B  40      -1.856  30.572 -10.963  1.00 21.76           C  
ATOM   1646  CG  LEU B  40      -1.651  31.003  -9.507  1.00 21.85           C  
ATOM   1647  CD1 LEU B  40      -0.159  31.093  -9.180  1.00 24.51           C  
ATOM   1648  CD2 LEU B  40      -2.310  32.354  -9.301  1.00 21.76           C  
ATOM   1649  N   ARG B  41      -3.300  29.422 -13.529  1.00 21.64           N  
ATOM   1650  CA  ARG B  41      -3.352  29.327 -14.978  1.00 21.57           C  
ATOM   1651  C   ARG B  41      -4.722  29.730 -15.527  1.00 22.86           C  
ATOM   1652  O   ARG B  41      -4.818  30.374 -16.579  1.00 21.05           O  
ATOM   1653  CB  ARG B  41      -3.017  27.911 -15.425  1.00 23.77           C  
ATOM   1654  CG  ARG B  41      -2.925  27.787 -16.926  1.00 28.04           C  
ATOM   1655  CD  ARG B  41      -1.878  28.746 -17.468  1.00 29.43           C  
ATOM   1656  NE  ARG B  41      -1.800  28.721 -18.926  1.00 34.48           N  
ATOM   1657  CZ  ARG B  41      -0.809  29.269 -19.620  1.00 35.36           C  
ATOM   1658  NH1 ARG B  41       0.181  29.881 -18.981  1.00 35.37           N  
ATOM   1659  NH2 ARG B  41      -0.806  29.206 -20.949  1.00 35.01           N  
ATOM   1660  N   ILE B  42      -5.779  29.350 -14.811  1.00 20.39           N  
ATOM   1661  CA  ILE B  42      -7.136  29.682 -15.224  1.00 19.66           C  
ATOM   1662  C   ILE B  42      -7.311  31.188 -15.089  1.00 20.66           C  
ATOM   1663  O   ILE B  42      -7.990  31.822 -15.895  1.00 19.76           O  
ATOM   1664  CB  ILE B  42      -8.185  28.964 -14.340  1.00 19.97           C  
ATOM   1665  CG1 ILE B  42      -8.035  27.446 -14.490  1.00 21.85           C  
ATOM   1666  CG2 ILE B  42      -9.590  29.399 -14.737  1.00 20.84           C  
ATOM   1667  CD1 ILE B  42      -8.810  26.622 -13.453  1.00 19.41           C  
ATOM   1668  N   HIS B  43      -6.694  31.756 -14.056  1.00 21.66           N  
ATOM   1669  CA  HIS B  43      -6.773  33.190 -13.830  1.00 21.92           C  
ATOM   1670  C   HIS B  43      -6.093  33.941 -14.967  1.00 21.57           C  
ATOM   1671  O   HIS B  43      -6.516  35.031 -15.340  1.00 21.72           O  
ATOM   1672  CB  HIS B  43      -6.110  33.562 -12.504  1.00 23.45           C  
ATOM   1673  CG  HIS B  43      -5.816  35.023 -12.373  1.00 23.56           C  
ATOM   1674  ND1 HIS B  43      -4.578  35.561 -12.655  1.00 24.44           N  
ATOM   1675  CD2 HIS B  43      -6.611  36.065 -12.033  1.00 22.21           C  
ATOM   1676  CE1 HIS B  43      -4.622  36.873 -12.493  1.00 22.24           C  
ATOM   1677  NE2 HIS B  43      -5.845  37.203 -12.117  1.00 26.31           N  
ATOM   1678  N   ARG B  44      -5.037  33.355 -15.518  0.50 21.10           N  
ATOM   1680  CA  ARG B  44      -4.316  33.990 -16.615  0.50 21.70           C  
ATOM   1682  C   ARG B  44      -5.030  33.767 -17.947  0.50 21.60           C  
ATOM   1684  O   ARG B  44      -4.888  34.560 -18.878  0.50 20.32           O  
ATOM   1686  CB  ARG B  44      -2.893  33.441 -16.701  0.50 24.63           C  
ATOM   1688  CG  ARG B  44      -2.094  33.598 -15.421  0.50 27.30           C  
ATOM   1690  CD  ARG B  44      -0.663  33.115 -15.597  0.50 30.08           C  
ATOM   1692  NE  ARG B  44       0.038  33.025 -14.319  0.50 32.77           N  
ATOM   1694  CZ  ARG B  44       0.214  34.043 -13.483  0.50 33.66           C  
ATOM   1696  NH1 ARG B  44      -0.258  35.247 -13.782  0.50 33.62           N  
ATOM   1698  NH2 ARG B  44       0.857  33.855 -12.338  0.50 33.69           N  
ATOM   1700  N   GLU B  45      -5.809  32.693 -18.027  1.00 20.99           N  
ATOM   1701  CA  GLU B  45      -6.525  32.364 -19.254  1.00 23.52           C  
ATOM   1702  C   GLU B  45      -8.011  32.079 -19.023  1.00 24.62           C  
ATOM   1703  O   GLU B  45      -8.467  30.955 -19.197  1.00 22.98           O  
ATOM   1704  CB  GLU B  45      -5.867  31.147 -19.902  1.00 29.20           C  
ATOM   1705  CG  GLU B  45      -6.351  30.819 -21.310  1.00 37.80           C  
ATOM   1706  CD  GLU B  45      -5.355  31.237 -22.380  1.00 41.61           C  
ATOM   1707  OE1 GLU B  45      -5.521  30.814 -23.545  1.00 43.54           O  
ATOM   1708  OE2 GLU B  45      -4.409  31.990 -22.056  1.00 43.62           O  
ATOM   1709  N   PRO B  46      -8.787  33.098 -18.627  1.00 25.18           N  
ATOM   1710  CA  PRO B  46     -10.216  32.861 -18.398  1.00 25.42           C  
ATOM   1711  C   PRO B  46     -10.936  32.232 -19.598  1.00 26.81           C  
ATOM   1712  O   PRO B  46     -10.740  32.643 -20.744  1.00 26.65           O  
ATOM   1713  CB  PRO B  46     -10.751  34.253 -18.043  1.00 25.27           C  
ATOM   1714  CG  PRO B  46      -9.757  35.195 -18.681  1.00 27.99           C  
ATOM   1715  CD  PRO B  46      -8.441  34.513 -18.425  1.00 26.13           C  
ATOM   1716  N   GLY B  47     -11.764  31.226 -19.330  1.00 24.51           N  
ATOM   1717  CA  GLY B  47     -12.479  30.575 -20.408  1.00 24.57           C  
ATOM   1718  C   GLY B  47     -11.702  29.413 -20.995  1.00 24.51           C  
ATOM   1719  O   GLY B  47     -12.172  28.746 -21.916  1.00 22.33           O  
ATOM   1720  N   ILE B  48     -10.507  29.168 -20.465  1.00 23.19           N  
ATOM   1721  CA  ILE B  48      -9.684  28.072 -20.951  1.00 23.12           C  
ATOM   1722  C   ILE B  48     -10.425  26.748 -20.816  1.00 24.20           C  
ATOM   1723  O   ILE B  48     -11.194  26.546 -19.871  1.00 24.52           O  
ATOM   1724  CB  ILE B  48      -8.354  27.989 -20.179  1.00 21.63           C  
ATOM   1725  CG1 ILE B  48      -7.510  26.846 -20.739  1.00 19.48           C  
ATOM   1726  CG2 ILE B  48      -8.620  27.791 -18.684  1.00 23.41           C  
ATOM   1727  CD1 ILE B  48      -6.079  26.874 -20.283  1.00 16.62           C  
ATOM   1728  N   LYS B  49     -10.202  25.847 -21.766  1.00 24.82           N  
ATOM   1729  CA  LYS B  49     -10.856  24.543 -21.736  1.00 26.67           C  
ATOM   1730  C   LYS B  49     -10.168  23.596 -20.765  1.00 26.02           C  
ATOM   1731  O   LYS B  49      -8.957  23.657 -20.570  1.00 27.79           O  
ATOM   1732  CB  LYS B  49     -10.866  23.915 -23.129  1.00 28.95           C  
ATOM   1733  CG  LYS B  49     -11.998  24.372 -24.034  1.00 35.56           C  
ATOM   1734  CD  LYS B  49     -11.920  25.845 -24.369  1.00 39.28           C  
ATOM   1735  CE  LYS B  49     -12.949  26.205 -25.434  1.00 42.57           C  
ATOM   1736  NZ  LYS B  49     -12.735  25.424 -26.693  1.00 43.32           N  
ATOM   1737  N   GLN B  50     -10.944  22.707 -20.161  1.00 25.73           N  
ATOM   1738  CA  GLN B  50     -10.378  21.764 -19.220  1.00 24.89           C  
ATOM   1739  C   GLN B  50      -9.302  20.901 -19.868  1.00 24.92           C  
ATOM   1740  O   GLN B  50      -8.256  20.667 -19.271  1.00 24.68           O  
ATOM   1741  CB  GLN B  50     -11.470  20.878 -18.625  1.00 24.97           C  
ATOM   1742  CG  GLN B  50     -10.992  20.093 -17.420  1.00 23.96           C  
ATOM   1743  CD  GLN B  50     -12.112  19.376 -16.696  1.00 25.81           C  
ATOM   1744  OE1 GLN B  50     -13.157  19.961 -16.416  1.00 25.89           O  
ATOM   1745  NE2 GLN B  50     -11.894  18.111 -16.376  1.00 21.41           N  
ATOM   1746  N   ASP B  51      -9.538  20.433 -21.093  1.00 26.34           N  
ATOM   1747  CA  ASP B  51      -8.535  19.605 -21.751  1.00 25.94           C  
ATOM   1748  C   ASP B  51      -7.310  20.419 -22.170  1.00 26.27           C  
ATOM   1749  O   ASP B  51      -6.195  19.899 -22.189  1.00 24.42           O  
ATOM   1750  CB  ASP B  51      -9.140  18.847 -22.950  1.00 30.74           C  
ATOM   1751  CG  ASP B  51      -9.801  19.760 -23.974  1.00 33.41           C  
ATOM   1752  OD1 ASP B  51     -10.744  20.502 -23.617  1.00 38.23           O  
ATOM   1753  OD2 ASP B  51      -9.388  19.721 -25.149  1.00 38.00           O  
ATOM   1754  N   GLU B  52      -7.506  21.698 -22.486  1.00 26.84           N  
ATOM   1755  CA  GLU B  52      -6.383  22.545 -22.877  1.00 28.32           C  
ATOM   1756  C   GLU B  52      -5.490  22.770 -21.662  1.00 27.54           C  
ATOM   1757  O   GLU B  52      -4.286  22.974 -21.795  1.00 23.62           O  
ATOM   1758  CB  GLU B  52      -6.861  23.902 -23.394  1.00 32.80           C  
ATOM   1759  CG  GLU B  52      -7.830  23.846 -24.562  1.00 37.10           C  
ATOM   1760  CD  GLU B  52      -8.220  25.233 -25.038  1.00 37.92           C  
ATOM   1761  OE1 GLU B  52      -8.484  26.109 -24.185  1.00 38.11           O  
ATOM   1762  OE2 GLU B  52      -8.272  25.445 -26.264  1.00 40.26           O  
ATOM   1763  N   LEU B  53      -6.094  22.740 -20.476  1.00 28.19           N  
ATOM   1764  CA  LEU B  53      -5.351  22.929 -19.238  1.00 27.53           C  
ATOM   1765  C   LEU B  53      -4.528  21.674 -18.949  1.00 26.96           C  
ATOM   1766  O   LEU B  53      -3.372  21.765 -18.524  1.00 25.07           O  
ATOM   1767  CB  LEU B  53      -6.311  23.204 -18.075  1.00 29.32           C  
ATOM   1768  CG  LEU B  53      -5.632  23.564 -16.750  1.00 29.76           C  
ATOM   1769  CD1 LEU B  53      -4.876  24.869 -16.929  1.00 28.82           C  
ATOM   1770  CD2 LEU B  53      -6.662  23.696 -15.642  1.00 29.55           C  
ATOM   1771  N   ALA B  54      -5.123  20.508 -19.187  1.00 26.95           N  
ATOM   1772  CA  ALA B  54      -4.435  19.236 -18.962  1.00 28.10           C  
ATOM   1773  C   ALA B  54      -3.234  19.117 -19.905  1.00 28.89           C  
ATOM   1774  O   ALA B  54      -2.155  18.701 -19.494  1.00 28.94           O  
ATOM   1775  CB  ALA B  54      -5.397  18.068 -19.175  1.00 26.59           C  
ATOM   1776  N   THR B  55      -3.428  19.500 -21.163  1.00 31.75           N  
ATOM   1777  CA  THR B  55      -2.354  19.459 -22.158  1.00 33.06           C  
ATOM   1778  C   THR B  55      -1.263  20.457 -21.766  1.00 33.75           C  
ATOM   1779  O   THR B  55      -0.081  20.235 -22.024  1.00 32.82           O  
ATOM   1780  CB  THR B  55      -2.882  19.827 -23.567  1.00 33.72           C  
ATOM   1781  OG1 THR B  55      -3.910  18.906 -23.950  1.00 35.27           O  
ATOM   1782  CG2 THR B  55      -1.760  19.782 -24.596  1.00 33.86           C  
ATOM   1783  N   PHE B  56      -1.665  21.558 -21.137  1.00 33.75           N  
ATOM   1784  CA  PHE B  56      -0.711  22.579 -20.713  1.00 34.01           C  
ATOM   1785  C   PHE B  56       0.235  22.074 -19.629  1.00 33.56           C  
ATOM   1786  O   PHE B  56       1.444  22.304 -19.688  1.00 34.02           O  
ATOM   1787  CB  PHE B  56      -1.442  23.813 -20.188  1.00 33.17           C  
ATOM   1788  CG  PHE B  56      -0.526  24.876 -19.652  1.00 34.40           C  
ATOM   1789  CD1 PHE B  56       0.224  25.668 -20.515  1.00 34.27           C  
ATOM   1790  CD2 PHE B  56      -0.415  25.090 -18.279  1.00 34.17           C  
ATOM   1791  CE1 PHE B  56       1.070  26.660 -20.017  1.00 34.83           C  
ATOM   1792  CE2 PHE B  56       0.426  26.075 -17.774  1.00 33.70           C  
ATOM   1793  CZ  PHE B  56       1.170  26.863 -18.646  1.00 33.66           C  
ATOM   1794  N   PHE B  57      -0.315  21.393 -18.632  1.00 31.95           N  
ATOM   1795  CA  PHE B  57       0.497  20.878 -17.542  1.00 31.72           C  
ATOM   1796  C   PHE B  57       1.117  19.516 -17.834  1.00 33.69           C  
ATOM   1797  O   PHE B  57       1.952  19.034 -17.064  1.00 32.73           O  
ATOM   1798  CB  PHE B  57      -0.334  20.812 -16.254  1.00 29.75           C  
ATOM   1799  CG  PHE B  57      -0.605  22.158 -15.641  1.00 27.05           C  
ATOM   1800  CD1 PHE B  57       0.442  22.936 -15.151  1.00 26.14           C  
ATOM   1801  CD2 PHE B  57      -1.902  22.656 -15.565  1.00 24.15           C  
ATOM   1802  CE1 PHE B  57       0.204  24.192 -14.593  1.00 25.95           C  
ATOM   1803  CE2 PHE B  57      -2.151  23.907 -15.009  1.00 24.34           C  
ATOM   1804  CZ  PHE B  57      -1.096  24.678 -14.523  1.00 23.93           C  
ATOM   1805  N   HIS B  58       0.728  18.904 -18.950  1.00 34.58           N  
ATOM   1806  CA  HIS B  58       1.264  17.592 -19.304  1.00 36.42           C  
ATOM   1807  C   HIS B  58       0.801  16.557 -18.286  1.00 35.83           C  
ATOM   1808  O   HIS B  58       1.543  15.634 -17.952  1.00 34.99           O  
ATOM   1809  CB  HIS B  58       2.796  17.613 -19.302  1.00 40.11           C  
ATOM   1810  CG  HIS B  58       3.410  18.128 -20.565  1.00 42.30           C  
ATOM   1811  ND1 HIS B  58       2.896  19.199 -21.265  1.00 45.75           N  
ATOM   1812  CD2 HIS B  58       4.533  17.755 -21.223  1.00 43.60           C  
ATOM   1813  CE1 HIS B  58       3.678  19.463 -22.297  1.00 45.82           C  
ATOM   1814  NE2 HIS B  58       4.679  18.602 -22.293  1.00 45.51           N  
ATOM   1815  N   VAL B  59      -0.413  16.717 -17.773  1.00 33.95           N  
ATOM   1816  CA  VAL B  59      -0.935  15.772 -16.800  1.00 32.76           C  
ATOM   1817  C   VAL B  59      -2.175  15.063 -17.352  1.00 32.05           C  
ATOM   1818  O   VAL B  59      -2.866  15.591 -18.229  1.00 30.42           O  
ATOM   1819  CB  VAL B  59      -1.239  16.483 -15.464  1.00 33.59           C  
ATOM   1820  CG1 VAL B  59      -2.090  17.686 -15.708  1.00 34.60           C  
ATOM   1821  CG2 VAL B  59      -1.907  15.531 -14.498  1.00 34.88           C  
ATOM   1822  N   ASP B  60      -2.444  13.871 -16.829  0.50 32.04           N  
ATOM   1824  CA  ASP B  60      -3.574  13.051 -17.256  0.50 33.07           C  
ATOM   1826  C   ASP B  60      -4.937  13.678 -16.956  0.50 32.73           C  
ATOM   1828  O   ASP B  60      -5.114  14.344 -15.936  0.50 32.49           O  
ATOM   1830  CB  ASP B  60      -3.485  11.678 -16.588  0.50 34.37           C  
ATOM   1832  CG  ASP B  60      -4.431  10.675 -17.196  0.50 36.05           C  
ATOM   1834  OD1 ASP B  60      -4.523   9.548 -16.666  0.50 37.26           O  
ATOM   1836  OD2 ASP B  60      -5.081  11.006 -18.209  0.50 37.26           O  
ATOM   1838  N   LYS B  61      -5.896  13.448 -17.849  1.00 32.43           N  
ATOM   1839  CA  LYS B  61      -7.240  13.986 -17.696  1.00 32.04           C  
ATOM   1840  C   LYS B  61      -7.849  13.695 -16.324  1.00 30.19           C  
ATOM   1841  O   LYS B  61      -8.505  14.555 -15.734  1.00 26.83           O  
ATOM   1842  CB  LYS B  61      -8.161  13.425 -18.791  1.00 35.22           C  
ATOM   1843  CG  LYS B  61      -7.822  13.875 -20.216  1.00 40.94           C  
ATOM   1844  CD  LYS B  61      -6.469  13.341 -20.689  1.00 43.22           C  
ATOM   1845  CE  LYS B  61      -6.445  11.819 -20.692  1.00 44.71           C  
ATOM   1846  NZ  LYS B  61      -5.125  11.283 -21.125  1.00 45.22           N  
ATOM   1847  N   GLY B  62      -7.633  12.485 -15.820  1.00 26.95           N  
ATOM   1848  CA  GLY B  62      -8.179  12.125 -14.523  1.00 26.27           C  
ATOM   1849  C   GLY B  62      -7.621  12.958 -13.381  1.00 26.56           C  
ATOM   1850  O   GLY B  62      -8.344  13.299 -12.440  1.00 24.11           O  
ATOM   1851  N   THR B  63      -6.333  13.285 -13.459  1.00 27.28           N  
ATOM   1852  CA  THR B  63      -5.664  14.080 -12.428  1.00 28.44           C  
ATOM   1853  C   THR B  63      -6.128  15.529 -12.447  1.00 27.58           C  
ATOM   1854  O   THR B  63      -6.443  16.104 -11.407  1.00 29.24           O  
ATOM   1855  CB  THR B  63      -4.137  14.050 -12.609  1.00 29.29           C  
ATOM   1856  OG1 THR B  63      -3.668  12.703 -12.459  1.00 34.92           O  
ATOM   1857  CG2 THR B  63      -3.460  14.936 -11.584  1.00 28.44           C  
ATOM   1858  N   ILE B  64      -6.165  16.123 -13.632  1.00 26.65           N  
ATOM   1859  CA  ILE B  64      -6.617  17.498 -13.756  1.00 24.26           C  
ATOM   1860  C   ILE B  64      -8.038  17.620 -13.216  1.00 19.31           C  
ATOM   1861  O   ILE B  64      -8.359  18.575 -12.516  1.00 17.11           O  
ATOM   1862  CB  ILE B  64      -6.596  17.968 -15.229  1.00 25.37           C  
ATOM   1863  CG1 ILE B  64      -5.168  18.304 -15.645  1.00 30.02           C  
ATOM   1864  CG2 ILE B  64      -7.473  19.192 -15.402  1.00 27.53           C  
ATOM   1865  CD1 ILE B  64      -4.616  19.546 -14.950  1.00 31.67           C  
ATOM   1866  N   ALA B  65      -8.876  16.645 -13.553  1.00 19.07           N  
ATOM   1867  CA  ALA B  65     -10.274  16.637 -13.116  1.00 20.55           C  
ATOM   1868  C   ALA B  65     -10.411  16.601 -11.595  1.00 20.21           C  
ATOM   1869  O   ALA B  65     -11.202  17.347 -11.020  1.00 22.43           O  
ATOM   1870  CB  ALA B  65     -11.012  15.439 -13.741  1.00 19.83           C  
ATOM   1871  N   ARG B  66      -9.648  15.732 -10.940  1.00 20.53           N  
ATOM   1872  CA  ARG B  66      -9.702  15.637  -9.482  1.00 20.33           C  
ATOM   1873  C   ARG B  66      -9.213  16.948  -8.854  1.00 19.24           C  
ATOM   1874  O   ARG B  66      -9.734  17.399  -7.836  1.00 17.65           O  
ATOM   1875  CB  ARG B  66      -8.841  14.465  -8.995  1.00 23.14           C  
ATOM   1876  CG  ARG B  66      -8.786  14.314  -7.479  1.00 25.46           C  
ATOM   1877  CD  ARG B  66      -8.289  12.930  -7.054  1.00 28.13           C  
ATOM   1878  NE  ARG B  66      -7.029  12.576  -7.703  1.00 31.54           N  
ATOM   1879  CZ  ARG B  66      -6.931  11.857  -8.817  1.00 29.55           C  
ATOM   1880  NH1 ARG B  66      -8.025  11.401  -9.405  1.00 33.91           N  
ATOM   1881  NH2 ARG B  66      -5.738  11.614  -9.354  1.00 26.93           N  
ATOM   1882  N   THR B  67      -8.215  17.570  -9.473  1.00 18.18           N  
ATOM   1883  CA  THR B  67      -7.693  18.832  -8.951  1.00 18.26           C  
ATOM   1884  C   THR B  67      -8.726  19.951  -9.113  1.00 18.00           C  
ATOM   1885  O   THR B  67      -8.889  20.792  -8.235  1.00 17.80           O  
ATOM   1886  CB  THR B  67      -6.407  19.242  -9.684  1.00 20.13           C  
ATOM   1887  OG1 THR B  67      -5.406  18.244  -9.459  1.00 17.88           O  
ATOM   1888  CG2 THR B  67      -5.912  20.605  -9.179  1.00 19.16           C  
ATOM   1889  N   LEU B  68      -9.422  19.951 -10.240  1.00 17.74           N  
ATOM   1890  CA  LEU B  68     -10.431  20.968 -10.491  1.00 19.46           C  
ATOM   1891  C   LEU B  68     -11.640  20.795  -9.566  1.00 20.76           C  
ATOM   1892  O   LEU B  68     -12.238  21.782  -9.128  1.00 20.32           O  
ATOM   1893  CB  LEU B  68     -10.866  20.931 -11.959  1.00 18.20           C  
ATOM   1894  CG  LEU B  68      -9.801  21.386 -12.966  1.00 18.03           C  
ATOM   1895  CD1 LEU B  68     -10.319  21.142 -14.377  1.00 17.72           C  
ATOM   1896  CD2 LEU B  68      -9.460  22.863 -12.764  1.00 17.75           C  
ATOM   1897  N   ARG B  69     -12.001  19.548  -9.273  1.00 19.29           N  
ATOM   1898  CA  ARG B  69     -13.127  19.296  -8.378  1.00 21.56           C  
ATOM   1899  C   ARG B  69     -12.821  19.875  -7.004  1.00 21.97           C  
ATOM   1900  O   ARG B  69     -13.715  20.381  -6.317  1.00 21.02           O  
ATOM   1901  CB  ARG B  69     -13.397  17.796  -8.238  1.00 23.15           C  
ATOM   1902  CG  ARG B  69     -13.793  17.102  -9.536  1.00 26.43           C  
ATOM   1903  CD  ARG B  69     -14.198  15.649  -9.286  1.00 28.27           C  
ATOM   1904  NE  ARG B  69     -13.966  14.817 -10.468  1.00 29.49           N  
ATOM   1905  CZ  ARG B  69     -12.997  13.913 -10.557  1.00 27.78           C  
ATOM   1906  NH1 ARG B  69     -12.172  13.711  -9.539  1.00 31.28           N  
ATOM   1907  NH2 ARG B  69     -12.842  13.219 -11.668  1.00 35.53           N  
ATOM   1908  N   ARG B  70     -11.557  19.796  -6.595  1.00 20.28           N  
ATOM   1909  CA  ARG B  70     -11.181  20.335  -5.291  1.00 21.93           C  
ATOM   1910  C   ARG B  70     -11.394  21.850  -5.300  1.00 19.96           C  
ATOM   1911  O   ARG B  70     -11.980  22.407  -4.373  1.00 22.54           O  
ATOM   1912  CB  ARG B  70      -9.714  20.033  -4.970  1.00 21.37           C  
ATOM   1913  CG  ARG B  70      -9.366  18.561  -4.727  1.00 27.01           C  
ATOM   1914  CD  ARG B  70     -10.032  17.986  -3.473  1.00 29.70           C  
ATOM   1915  NE  ARG B  70     -11.369  17.452  -3.729  1.00 33.16           N  
ATOM   1916  CZ  ARG B  70     -11.620  16.362  -4.453  1.00 36.20           C  
ATOM   1917  NH1 ARG B  70     -10.621  15.672  -4.999  1.00 34.83           N  
ATOM   1918  NH2 ARG B  70     -12.878  15.966  -4.641  1.00 36.10           N  
ATOM   1919  N   LEU B  71     -10.911  22.512  -6.347  1.00 17.24           N  
ATOM   1920  CA  LEU B  71     -11.061  23.957  -6.449  1.00 17.79           C  
ATOM   1921  C   LEU B  71     -12.514  24.424  -6.527  1.00 18.61           C  
ATOM   1922  O   LEU B  71     -12.873  25.423  -5.911  1.00 18.63           O  
ATOM   1923  CB  LEU B  71     -10.296  24.497  -7.660  1.00 15.54           C  
ATOM   1924  CG  LEU B  71      -8.766  24.553  -7.594  1.00 15.33           C  
ATOM   1925  CD1 LEU B  71      -8.195  24.826  -9.003  1.00 13.39           C  
ATOM   1926  CD2 LEU B  71      -8.335  25.647  -6.614  1.00 11.98           C  
ATOM   1927  N   GLU B  72     -13.352  23.720  -7.281  1.00 18.81           N  
ATOM   1928  CA  GLU B  72     -14.738  24.154  -7.394  1.00 20.19           C  
ATOM   1929  C   GLU B  72     -15.506  23.842  -6.113  1.00 19.75           C  
ATOM   1930  O   GLU B  72     -16.462  24.535  -5.775  1.00 20.01           O  
ATOM   1931  CB  GLU B  72     -15.427  23.529  -8.624  1.00 20.61           C  
ATOM   1932  CG  GLU B  72     -15.803  22.075  -8.515  1.00 24.55           C  
ATOM   1933  CD  GLU B  72     -16.322  21.516  -9.838  1.00 26.71           C  
ATOM   1934  OE1 GLU B  72     -16.532  20.294  -9.930  1.00 23.54           O  
ATOM   1935  OE2 GLU B  72     -16.512  22.304 -10.786  1.00 28.29           O  
ATOM   1936  N   GLU B  73     -15.074  22.813  -5.392  1.00 21.74           N  
ATOM   1937  CA  GLU B  73     -15.721  22.455  -4.132  1.00 22.40           C  
ATOM   1938  C   GLU B  73     -15.469  23.565  -3.107  1.00 22.27           C  
ATOM   1939  O   GLU B  73     -16.311  23.843  -2.259  1.00 23.46           O  
ATOM   1940  CB  GLU B  73     -15.160  21.134  -3.601  1.00 25.91           C  
ATOM   1941  CG  GLU B  73     -15.817  19.885  -4.185  1.00 29.65           C  
ATOM   1942  CD  GLU B  73     -14.958  18.639  -4.021  1.00 31.13           C  
ATOM   1943  OE1 GLU B  73     -14.200  18.562  -3.033  1.00 32.60           O  
ATOM   1944  OE2 GLU B  73     -15.050  17.731  -4.879  1.00 32.59           O  
ATOM   1945  N   SER B  74     -14.302  24.190  -3.196  1.00 18.53           N  
ATOM   1946  CA  SER B  74     -13.926  25.260  -2.286  1.00 20.06           C  
ATOM   1947  C   SER B  74     -14.479  26.593  -2.778  1.00 19.87           C  
ATOM   1948  O   SER B  74     -14.331  27.608  -2.107  1.00 20.51           O  
ATOM   1949  CB  SER B  74     -12.401  25.339  -2.173  1.00 16.11           C  
ATOM   1950  OG  SER B  74     -11.877  24.149  -1.623  1.00 20.60           O  
ATOM   1951  N   GLY B  75     -15.089  26.574  -3.963  1.00 20.68           N  
ATOM   1952  CA  GLY B  75     -15.687  27.768  -4.546  1.00 18.29           C  
ATOM   1953  C   GLY B  75     -14.726  28.712  -5.243  1.00 17.07           C  
ATOM   1954  O   GLY B  75     -15.067  29.864  -5.497  1.00 16.96           O  
ATOM   1955  N   PHE B  76     -13.534  28.232  -5.583  1.00 16.91           N  
ATOM   1956  CA  PHE B  76     -12.548  29.094  -6.215  1.00 16.40           C  
ATOM   1957  C   PHE B  76     -12.705  29.177  -7.727  1.00 19.75           C  
ATOM   1958  O   PHE B  76     -12.270  30.155  -8.347  1.00 17.06           O  
ATOM   1959  CB  PHE B  76     -11.130  28.635  -5.835  1.00 16.97           C  
ATOM   1960  CG  PHE B  76     -10.851  28.676  -4.356  1.00 16.61           C  
ATOM   1961  CD1 PHE B  76     -11.389  29.681  -3.554  1.00 20.78           C  
ATOM   1962  CD2 PHE B  76     -10.035  27.724  -3.764  1.00 16.12           C  
ATOM   1963  CE1 PHE B  76     -11.114  29.728  -2.176  1.00 19.03           C  
ATOM   1964  CE2 PHE B  76      -9.753  27.762  -2.396  1.00 17.30           C  
ATOM   1965  CZ  PHE B  76     -10.292  28.763  -1.601  1.00 18.69           C  
ATOM   1966  N   ILE B  77     -13.311  28.149  -8.322  1.00 19.13           N  
ATOM   1967  CA  ILE B  77     -13.546  28.147  -9.764  1.00 20.69           C  
ATOM   1968  C   ILE B  77     -14.922  27.596 -10.109  1.00 23.23           C  
ATOM   1969  O   ILE B  77     -15.579  26.947  -9.294  1.00 22.96           O  
ATOM   1970  CB  ILE B  77     -12.506  27.309 -10.551  1.00 19.13           C  
ATOM   1971  CG1 ILE B  77     -12.685  25.812 -10.251  1.00 16.27           C  
ATOM   1972  CG2 ILE B  77     -11.089  27.781 -10.212  1.00 19.07           C  
ATOM   1973  CD1 ILE B  77     -11.859  24.909 -11.153  1.00 15.34           C  
ATOM   1974  N   GLU B  78     -15.352  27.867 -11.332  1.00 27.30           N  
ATOM   1975  CA  GLU B  78     -16.640  27.394 -11.809  1.00 29.47           C  
ATOM   1976  C   GLU B  78     -16.435  26.767 -13.176  1.00 29.44           C  
ATOM   1977  O   GLU B  78     -15.602  27.225 -13.962  1.00 29.00           O  
ATOM   1978  CB  GLU B  78     -17.635  28.558 -11.875  1.00 33.83           C  
ATOM   1979  CG  GLU B  78     -17.217  29.731 -12.752  1.00 39.96           C  
ATOM   1980  CD  GLU B  78     -17.669  31.071 -12.178  1.00 46.04           C  
ATOM   1981  OE1 GLU B  78     -18.757  31.125 -11.561  1.00 47.23           O  
ATOM   1982  OE2 GLU B  78     -16.940  32.074 -12.350  1.00 47.68           O  
ATOM   1983  N   ARG B  79     -17.173  25.701 -13.450  1.00 30.42           N  
ATOM   1984  CA  ARG B  79     -17.059  25.006 -14.728  1.00 31.72           C  
ATOM   1985  C   ARG B  79     -18.384  25.016 -15.491  1.00 33.51           C  
ATOM   1986  O   ARG B  79     -19.446  24.773 -14.917  1.00 33.70           O  
ATOM   1987  CB  ARG B  79     -16.598  23.564 -14.484  1.00 31.14           C  
ATOM   1988  CG  ARG B  79     -15.230  23.472 -13.813  1.00 33.08           C  
ATOM   1989  CD  ARG B  79     -15.052  22.166 -13.031  1.00 33.03           C  
ATOM   1990  NE  ARG B  79     -14.837  21.004 -13.878  1.00 32.85           N  
ATOM   1991  CZ  ARG B  79     -14.884  19.745 -13.452  1.00 33.74           C  
ATOM   1992  NH1 ARG B  79     -15.145  19.478 -12.181  1.00 32.14           N  
ATOM   1993  NH2 ARG B  79     -14.669  18.748 -14.300  1.00 33.18           N  
ATOM   1994  N   GLU B  80     -18.315  25.314 -16.785  1.00 33.12           N  
ATOM   1995  CA  GLU B  80     -19.503  25.340 -17.635  1.00 35.30           C  
ATOM   1996  C   GLU B  80     -19.249  24.443 -18.836  1.00 34.80           C  
ATOM   1997  O   GLU B  80     -18.139  24.423 -19.363  1.00 33.26           O  
ATOM   1998  CB  GLU B  80     -19.772  26.753 -18.153  1.00 38.65           C  
ATOM   1999  CG  GLU B  80     -20.014  27.809 -17.096  1.00 46.22           C  
ATOM   2000  CD  GLU B  80     -19.989  29.214 -17.683  1.00 50.30           C  
ATOM   2001  OE1 GLU B  80     -20.815  29.505 -18.579  1.00 52.04           O  
ATOM   2002  OE2 GLU B  80     -19.138  30.025 -17.250  1.00 52.27           O  
ATOM   2003  N   GLN B  81     -20.267  23.705 -19.272  1.00 35.08           N  
ATOM   2004  CA  GLN B  81     -20.105  22.848 -20.439  1.00 36.96           C  
ATOM   2005  C   GLN B  81     -19.744  23.752 -21.605  1.00 36.86           C  
ATOM   2006  O   GLN B  81     -20.296  24.842 -21.737  1.00 38.58           O  
ATOM   2007  CB  GLN B  81     -21.409  22.129 -20.790  1.00 39.20           C  
ATOM   2008  CG  GLN B  81     -21.991  21.251 -19.707  1.00 43.60           C  
ATOM   2009  CD  GLN B  81     -23.204  20.489 -20.201  1.00 45.12           C  
ATOM   2010  OE1 GLN B  81     -24.064  21.050 -20.881  1.00 44.39           O  
ATOM   2011  NE2 GLN B  81     -23.282  19.207 -19.859  1.00 45.11           N  
ATOM   2012  N   ASP B  82     -18.814  23.310 -22.441  1.00 37.26           N  
ATOM   2013  CA  ASP B  82     -18.420  24.078 -23.613  1.00 37.83           C  
ATOM   2014  C   ASP B  82     -19.654  24.131 -24.511  1.00 38.25           C  
ATOM   2015  O   ASP B  82     -20.238  23.098 -24.837  1.00 37.14           O  
ATOM   2016  CB  ASP B  82     -17.257  23.376 -24.326  1.00 38.11           C  
ATOM   2017  CG  ASP B  82     -16.830  24.082 -25.607  1.00 37.35           C  
ATOM   2018  OD1 ASP B  82     -15.747  23.750 -26.120  1.00 38.16           O  
ATOM   2019  OD2 ASP B  82     -17.571  24.950 -26.106  1.00 38.94           O  
ATOM   2020  N   PRO B  83     -20.071  25.340 -24.914  1.00 39.76           N  
ATOM   2021  CA  PRO B  83     -21.246  25.539 -25.771  1.00 40.00           C  
ATOM   2022  C   PRO B  83     -21.256  24.774 -27.093  1.00 39.83           C  
ATOM   2023  O   PRO B  83     -22.321  24.527 -27.661  1.00 41.45           O  
ATOM   2024  CB  PRO B  83     -21.269  27.057 -25.970  1.00 41.12           C  
ATOM   2025  CG  PRO B  83     -19.819  27.430 -25.882  1.00 41.31           C  
ATOM   2026  CD  PRO B  83     -19.371  26.617 -24.692  1.00 41.50           C  
ATOM   2027  N   GLU B  84     -20.082  24.389 -27.582  1.00 39.87           N  
ATOM   2028  CA  GLU B  84     -20.002  23.657 -28.843  1.00 41.01           C  
ATOM   2029  C   GLU B  84     -19.477  22.230 -28.678  1.00 39.53           C  
ATOM   2030  O   GLU B  84     -19.001  21.624 -29.634  1.00 39.53           O  
ATOM   2031  CB  GLU B  84     -19.125  24.422 -29.836  1.00 43.70           C  
ATOM   2032  CG  GLU B  84     -17.703  24.648 -29.360  1.00 46.77           C  
ATOM   2033  CD  GLU B  84     -16.984  25.706 -30.175  1.00 48.61           C  
ATOM   2034  OE1 GLU B  84     -17.537  26.818 -30.316  1.00 51.67           O  
ATOM   2035  OE2 GLU B  84     -15.870  25.431 -30.665  1.00 49.62           O  
ATOM   2036  N   ASN B  85     -19.571  21.707 -27.458  1.00 37.42           N  
ATOM   2037  CA  ASN B  85     -19.128  20.352 -27.138  1.00 34.11           C  
ATOM   2038  C   ASN B  85     -19.424  20.100 -25.659  1.00 33.15           C  
ATOM   2039  O   ASN B  85     -18.564  20.305 -24.800  1.00 31.61           O  
ATOM   2040  CB  ASN B  85     -17.629  20.201 -27.392  1.00 33.25           C  
ATOM   2041  CG  ASN B  85     -17.178  18.760 -27.332  1.00 31.53           C  
ATOM   2042  OD1 ASN B  85     -17.717  17.967 -26.560  1.00 30.15           O  
ATOM   2043  ND2 ASN B  85     -16.180  18.410 -28.143  1.00 31.46           N  
ATOM   2044  N   ARG B  86     -20.643  19.652 -25.372  1.00 33.49           N  
ATOM   2045  CA  ARG B  86     -21.080  19.406 -23.999  1.00 34.67           C  
ATOM   2046  C   ARG B  86     -20.245  18.409 -23.208  1.00 34.87           C  
ATOM   2047  O   ARG B  86     -20.399  18.302 -21.994  1.00 34.51           O  
ATOM   2048  CB  ARG B  86     -22.545  18.971 -23.982  1.00 36.18           C  
ATOM   2049  CG  ARG B  86     -22.816  17.679 -24.714  1.00 37.10           C  
ATOM   2050  CD  ARG B  86     -24.306  17.442 -24.861  1.00 37.15           C  
ATOM   2051  NE  ARG B  86     -24.576  16.560 -25.989  1.00 37.09           N  
ATOM   2052  CZ  ARG B  86     -24.288  15.265 -26.008  1.00 34.64           C  
ATOM   2053  NH1 ARG B  86     -23.725  14.696 -24.952  1.00 35.73           N  
ATOM   2054  NH2 ARG B  86     -24.555  14.545 -27.085  1.00 35.68           N  
ATOM   2055  N   ARG B  87     -19.372  17.673 -23.882  1.00 35.00           N  
ATOM   2056  CA  ARG B  87     -18.529  16.710 -23.182  1.00 37.30           C  
ATOM   2057  C   ARG B  87     -17.244  17.428 -22.804  1.00 37.16           C  
ATOM   2058  O   ARG B  87     -16.279  16.817 -22.354  1.00 39.41           O  
ATOM   2059  CB  ARG B  87     -18.217  15.509 -24.081  1.00 37.77           C  
ATOM   2060  CG  ARG B  87     -19.453  14.698 -24.472  1.00 40.53           C  
ATOM   2061  CD  ARG B  87     -19.100  13.542 -25.402  1.00 41.01           C  
ATOM   2062  NE  ARG B  87     -20.280  12.768 -25.777  1.00 43.00           N  
ATOM   2063  CZ  ARG B  87     -20.265  11.740 -26.620  1.00 42.65           C  
ATOM   2064  NH1 ARG B  87     -19.125  11.354 -27.180  1.00 41.00           N  
ATOM   2065  NH2 ARG B  87     -21.391  11.099 -26.904  1.00 43.65           N  
ATOM   2066  N   ARG B  88     -17.255  18.743 -22.987  1.00 36.26           N  
ATOM   2067  CA  ARG B  88     -16.102  19.582 -22.700  1.00 36.04           C  
ATOM   2068  C   ARG B  88     -16.487  20.629 -21.658  1.00 34.71           C  
ATOM   2069  O   ARG B  88     -17.647  21.029 -21.583  1.00 32.49           O  
ATOM   2070  CB  ARG B  88     -15.663  20.255 -24.004  1.00 39.08           C  
ATOM   2071  CG  ARG B  88     -14.363  21.021 -23.969  1.00 43.27           C  
ATOM   2072  CD  ARG B  88     -13.832  21.094 -25.386  1.00 45.54           C  
ATOM   2073  NE  ARG B  88     -12.501  21.675 -25.482  1.00 47.34           N  
ATOM   2074  CZ  ARG B  88     -11.716  21.534 -26.545  1.00 49.14           C  
ATOM   2075  NH1 ARG B  88     -12.142  20.831 -27.586  1.00 47.48           N  
ATOM   2076  NH2 ARG B  88     -10.511  22.098 -26.570  1.00 50.38           N  
ATOM   2077  N   TYR B  89     -15.517  21.056 -20.851  1.00 32.50           N  
ATOM   2078  CA  TYR B  89     -15.751  22.064 -19.818  1.00 30.59           C  
ATOM   2079  C   TYR B  89     -14.841  23.261 -20.039  1.00 27.84           C  
ATOM   2080  O   TYR B  89     -13.707  23.116 -20.496  1.00 28.03           O  
ATOM   2081  CB  TYR B  89     -15.468  21.495 -18.418  1.00 32.74           C  
ATOM   2082  CG  TYR B  89     -16.472  20.481 -17.921  1.00 34.93           C  
ATOM   2083  CD1 TYR B  89     -17.763  20.866 -17.561  1.00 35.66           C  
ATOM   2084  CD2 TYR B  89     -16.132  19.135 -17.810  1.00 36.62           C  
ATOM   2085  CE1 TYR B  89     -18.693  19.935 -17.101  1.00 37.19           C  
ATOM   2086  CE2 TYR B  89     -17.055  18.193 -17.352  1.00 39.95           C  
ATOM   2087  CZ  TYR B  89     -18.333  18.601 -17.000  1.00 39.43           C  
ATOM   2088  OH  TYR B  89     -19.245  17.669 -16.545  1.00 44.50           O  
ATOM   2089  N   ILE B  90     -15.349  24.445 -19.725  1.00 25.44           N  
ATOM   2090  CA  ILE B  90     -14.574  25.670 -19.839  1.00 26.43           C  
ATOM   2091  C   ILE B  90     -14.426  26.184 -18.412  1.00 27.07           C  
ATOM   2092  O   ILE B  90     -15.376  26.143 -17.624  1.00 25.06           O  
ATOM   2093  CB  ILE B  90     -15.288  26.718 -20.691  1.00 27.69           C  
ATOM   2094  CG1 ILE B  90     -16.707  26.916 -20.177  1.00 29.65           C  
ATOM   2095  CG2 ILE B  90     -15.264  26.288 -22.154  1.00 29.58           C  
ATOM   2096  CD1 ILE B  90     -17.473  27.977 -20.923  1.00 35.50           C  
ATOM   2097  N   LEU B  91     -13.240  26.677 -18.086  1.00 25.51           N  
ATOM   2098  CA  LEU B  91     -12.957  27.130 -16.732  1.00 24.00           C  
ATOM   2099  C   LEU B  91     -12.965  28.648 -16.554  1.00 24.15           C  
ATOM   2100  O   LEU B  91     -12.586  29.391 -17.458  1.00 24.93           O  
ATOM   2101  CB  LEU B  91     -11.602  26.563 -16.299  1.00 21.68           C  
ATOM   2102  CG  LEU B  91     -11.382  25.097 -16.702  1.00 23.00           C  
ATOM   2103  CD1 LEU B  91      -9.987  24.654 -16.310  1.00 23.41           C  
ATOM   2104  CD2 LEU B  91     -12.420  24.209 -16.048  1.00 23.62           C  
ATOM   2105  N   GLU B  92     -13.389  29.085 -15.371  1.00 21.55           N  
ATOM   2106  CA  GLU B  92     -13.447  30.500 -15.015  1.00 24.72           C  
ATOM   2107  C   GLU B  92     -13.128  30.634 -13.520  1.00 22.74           C  
ATOM   2108  O   GLU B  92     -13.560  29.814 -12.713  1.00 21.92           O  
ATOM   2109  CB  GLU B  92     -14.858  31.072 -15.244  1.00 27.73           C  
ATOM   2110  CG  GLU B  92     -15.423  30.999 -16.663  1.00 35.59           C  
ATOM   2111  CD  GLU B  92     -14.899  32.093 -17.585  1.00 39.14           C  
ATOM   2112  OE1 GLU B  92     -14.539  33.179 -17.083  1.00 41.63           O  
ATOM   2113  OE2 GLU B  92     -14.868  31.872 -18.819  1.00 42.29           O  
ATOM   2114  N   VAL B  93     -12.364  31.651 -13.140  1.00 23.36           N  
ATOM   2115  CA  VAL B  93     -12.098  31.850 -11.720  1.00 23.49           C  
ATOM   2116  C   VAL B  93     -13.348  32.560 -11.206  1.00 24.65           C  
ATOM   2117  O   VAL B  93     -13.931  33.382 -11.908  1.00 22.26           O  
ATOM   2118  CB  VAL B  93     -10.867  32.752 -11.463  1.00 23.20           C  
ATOM   2119  CG1 VAL B  93     -10.703  32.979  -9.968  1.00 22.19           C  
ATOM   2120  CG2 VAL B  93      -9.602  32.092 -12.020  1.00 23.64           C  
ATOM   2121  N   THR B  94     -13.776  32.234  -9.996  1.00 24.74           N  
ATOM   2122  CA  THR B  94     -14.960  32.869  -9.437  1.00 26.74           C  
ATOM   2123  C   THR B  94     -14.572  34.128  -8.680  1.00 27.30           C  
ATOM   2124  O   THR B  94     -13.388  34.442  -8.525  1.00 24.56           O  
ATOM   2125  CB  THR B  94     -15.682  31.946  -8.453  1.00 23.79           C  
ATOM   2126  OG1 THR B  94     -14.826  31.699  -7.327  1.00 21.63           O  
ATOM   2127  CG2 THR B  94     -16.050  30.617  -9.129  1.00 23.46           C  
ATOM   2128  N   ARG B  95     -15.585  34.850  -8.219  1.00 28.00           N  
ATOM   2129  CA  ARG B  95     -15.359  36.060  -7.449  1.00 30.33           C  
ATOM   2130  C   ARG B  95     -14.465  35.704  -6.272  1.00 28.43           C  
ATOM   2131  O   ARG B  95     -13.475  36.379  -6.000  1.00 27.58           O  
ATOM   2132  CB  ARG B  95     -16.698  36.611  -6.946  1.00 34.11           C  
ATOM   2133  CG  ARG B  95     -16.582  37.743  -5.938  1.00 39.39           C  
ATOM   2134  CD  ARG B  95     -15.440  38.683  -6.297  1.00 45.89           C  
ATOM   2135  NE  ARG B  95     -15.361  38.953  -7.731  1.00 49.14           N  
ATOM   2136  CZ  ARG B  95     -14.232  39.262  -8.362  1.00 51.00           C  
ATOM   2137  NH1 ARG B  95     -13.092  39.337  -7.682  1.00 51.88           N  
ATOM   2138  NH2 ARG B  95     -14.238  39.488  -9.669  1.00 49.83           N  
ATOM   2139  N   ARG B  96     -14.821  34.627  -5.578  0.50 27.70           N  
ATOM   2141  CA  ARG B  96     -14.059  34.161  -4.425  0.50 27.30           C  
ATOM   2143  C   ARG B  96     -12.618  33.834  -4.804  0.50 26.77           C  
ATOM   2145  O   ARG B  96     -11.682  34.193  -4.090  0.50 25.16           O  
ATOM   2147  CB  ARG B  96     -14.713  32.912  -3.827  0.50 27.52           C  
ATOM   2149  CG  ARG B  96     -13.953  32.316  -2.650  0.50 28.10           C  
ATOM   2151  CD  ARG B  96     -14.162  33.128  -1.386  0.50 28.37           C  
ATOM   2153  NE  ARG B  96     -13.365  32.632  -0.268  0.50 28.49           N  
ATOM   2155  CZ  ARG B  96     -12.099  32.969  -0.045  0.50 29.04           C  
ATOM   2157  NH1 ARG B  96     -11.483  33.811  -0.861  0.50 29.71           N  
ATOM   2159  NH2 ARG B  96     -11.449  32.461   0.992  0.50 28.57           N  
ATOM   2161  N   GLY B  97     -12.444  33.143  -5.926  1.00 27.37           N  
ATOM   2162  CA  GLY B  97     -11.104  32.788  -6.359  1.00 27.29           C  
ATOM   2163  C   GLY B  97     -10.251  34.017  -6.627  1.00 27.77           C  
ATOM   2164  O   GLY B  97      -9.088  34.080  -6.223  1.00 27.12           O  
ATOM   2165  N   GLU B  98     -10.825  35.001  -7.314  1.00 26.78           N  
ATOM   2166  CA  GLU B  98     -10.098  36.223  -7.625  1.00 28.69           C  
ATOM   2167  C   GLU B  98      -9.704  36.967  -6.356  1.00 28.90           C  
ATOM   2168  O   GLU B  98      -8.779  37.766  -6.378  1.00 29.59           O  
ATOM   2169  CB  GLU B  98     -10.940  37.144  -8.520  1.00 31.10           C  
ATOM   2170  CG  GLU B  98     -11.025  36.698  -9.977  1.00 32.76           C  
ATOM   2171  CD  GLU B  98      -9.694  36.800 -10.697  1.00 33.31           C  
ATOM   2172  OE1 GLU B  98      -9.440  35.976 -11.600  1.00 32.33           O  
ATOM   2173  OE2 GLU B  98      -8.904  37.710 -10.368  1.00 34.86           O  
ATOM   2174  N   GLU B  99     -10.397  36.696  -5.249  1.00 28.90           N  
ATOM   2175  CA  GLU B  99     -10.091  37.368  -3.985  1.00 28.50           C  
ATOM   2176  C   GLU B  99      -8.781  36.865  -3.370  1.00 28.43           C  
ATOM   2177  O   GLU B  99      -8.060  37.634  -2.735  1.00 27.32           O  
ATOM   2178  CB  GLU B  99     -11.231  37.184  -2.976  1.00 29.53           C  
ATOM   2179  CG  GLU B  99     -12.612  37.543  -3.514  1.00 30.34           C  
ATOM   2180  CD  GLU B  99     -13.698  37.534  -2.445  1.00 33.13           C  
ATOM   2181  OE1 GLU B  99     -13.558  36.798  -1.443  1.00 32.95           O  
ATOM   2182  OE2 GLU B  99     -14.707  38.258  -2.615  1.00 31.29           O  
ATOM   2183  N   ILE B 100      -8.465  35.585  -3.566  1.00 26.21           N  
ATOM   2184  CA  ILE B 100      -7.239  35.026  -3.005  1.00 26.34           C  
ATOM   2185  C   ILE B 100      -6.041  34.962  -3.949  1.00 25.52           C  
ATOM   2186  O   ILE B 100      -4.960  34.530  -3.544  1.00 26.92           O  
ATOM   2187  CB  ILE B 100      -7.459  33.598  -2.463  1.00 26.55           C  
ATOM   2188  CG1 ILE B 100      -7.851  32.657  -3.609  1.00 26.84           C  
ATOM   2189  CG2 ILE B 100      -8.495  33.622  -1.361  1.00 27.68           C  
ATOM   2190  CD1 ILE B 100      -7.995  31.188  -3.195  1.00 25.82           C  
ATOM   2191  N   ILE B 101      -6.216  35.372  -5.201  1.00 25.22           N  
ATOM   2192  CA  ILE B 101      -5.114  35.325  -6.156  1.00 25.99           C  
ATOM   2193  C   ILE B 101      -3.927  36.172  -5.713  1.00 26.01           C  
ATOM   2194  O   ILE B 101      -2.782  35.722  -5.756  1.00 24.74           O  
ATOM   2195  CB  ILE B 101      -5.557  35.796  -7.553  1.00 26.85           C  
ATOM   2196  CG1 ILE B 101      -6.546  34.791  -8.147  1.00 29.03           C  
ATOM   2197  CG2 ILE B 101      -4.336  35.969  -8.461  1.00 27.56           C  
ATOM   2198  CD1 ILE B 101      -5.950  33.430  -8.410  1.00 27.90           C  
ATOM   2199  N   PRO B 102      -4.180  37.424  -5.298  1.00 25.84           N  
ATOM   2200  CA  PRO B 102      -3.058  38.255  -4.864  1.00 25.12           C  
ATOM   2201  C   PRO B 102      -2.261  37.586  -3.752  1.00 24.76           C  
ATOM   2202  O   PRO B 102      -1.033  37.636  -3.759  1.00 22.89           O  
ATOM   2203  CB  PRO B 102      -3.743  39.543  -4.415  1.00 26.78           C  
ATOM   2204  CG  PRO B 102      -4.890  39.642  -5.383  1.00 27.18           C  
ATOM   2205  CD  PRO B 102      -5.422  38.215  -5.364  1.00 26.43           C  
ATOM   2206  N   LEU B 103      -2.956  36.963  -2.797  1.00 24.12           N  
ATOM   2207  CA  LEU B 103      -2.275  36.280  -1.699  1.00 24.59           C  
ATOM   2208  C   LEU B 103      -1.460  35.124  -2.260  1.00 22.05           C  
ATOM   2209  O   LEU B 103      -0.310  34.942  -1.889  1.00 24.58           O  
ATOM   2210  CB  LEU B 103      -3.277  35.752  -0.652  1.00 25.93           C  
ATOM   2211  CG  LEU B 103      -2.685  34.883   0.479  1.00 27.11           C  
ATOM   2212  CD1 LEU B 103      -1.556  35.634   1.193  1.00 26.75           C  
ATOM   2213  CD2 LEU B 103      -3.781  34.492   1.474  1.00 30.95           C  
ATOM   2214  N   ILE B 104      -2.057  34.351  -3.162  1.00 20.97           N  
ATOM   2215  CA  ILE B 104      -1.356  33.228  -3.773  1.00 18.65           C  
ATOM   2216  C   ILE B 104      -0.099  33.709  -4.503  1.00 21.21           C  
ATOM   2217  O   ILE B 104       0.965  33.111  -4.373  1.00 20.65           O  
ATOM   2218  CB  ILE B 104      -2.254  32.473  -4.776  1.00 15.25           C  
ATOM   2219  CG1 ILE B 104      -3.300  31.635  -4.030  1.00 19.21           C  
ATOM   2220  CG2 ILE B 104      -1.404  31.572  -5.655  1.00 19.35           C  
ATOM   2221  CD1 ILE B 104      -4.292  30.947  -4.968  1.00 20.43           C  
ATOM   2222  N   LEU B 105      -0.212  34.788  -5.266  1.00 22.11           N  
ATOM   2223  CA  LEU B 105       0.955  35.297  -5.983  1.00 26.13           C  
ATOM   2224  C   LEU B 105       2.061  35.737  -5.024  1.00 25.82           C  
ATOM   2225  O   LEU B 105       3.238  35.506  -5.282  1.00 25.89           O  
ATOM   2226  CB  LEU B 105       0.568  36.466  -6.893  1.00 27.13           C  
ATOM   2227  CG  LEU B 105      -0.233  36.129  -8.160  1.00 30.87           C  
ATOM   2228  CD1 LEU B 105      -0.740  37.413  -8.798  1.00 29.42           C  
ATOM   2229  CD2 LEU B 105       0.634  35.350  -9.143  1.00 29.97           C  
ATOM   2230  N   LYS B 106       1.683  36.359  -3.912  1.00 25.98           N  
ATOM   2231  CA  LYS B 106       2.668  36.818  -2.943  1.00 27.23           C  
ATOM   2232  C   LYS B 106       3.384  35.618  -2.353  1.00 24.34           C  
ATOM   2233  O   LYS B 106       4.580  35.668  -2.099  1.00 22.81           O  
ATOM   2234  CB  LYS B 106       1.996  37.612  -1.819  1.00 28.99           C  
ATOM   2235  CG  LYS B 106       1.046  38.681  -2.311  1.00 35.31           C  
ATOM   2236  CD  LYS B 106       1.734  39.662  -3.244  1.00 37.08           C  
ATOM   2237  CE  LYS B 106       0.708  40.546  -3.940  1.00 41.31           C  
ATOM   2238  NZ  LYS B 106      -0.125  39.772  -4.916  1.00 40.11           N  
ATOM   2239  N   VAL B 107       2.636  34.542  -2.127  1.00 23.48           N  
ATOM   2240  CA  VAL B 107       3.208  33.319  -1.573  1.00 22.83           C  
ATOM   2241  C   VAL B 107       4.202  32.673  -2.528  1.00 22.43           C  
ATOM   2242  O   VAL B 107       5.271  32.234  -2.109  1.00 21.17           O  
ATOM   2243  CB  VAL B 107       2.097  32.305  -1.211  1.00 21.55           C  
ATOM   2244  CG1 VAL B 107       2.696  30.924  -0.911  1.00 19.38           C  
ATOM   2245  CG2 VAL B 107       1.342  32.814  -0.006  1.00 20.92           C  
ATOM   2246  N   GLU B 108       3.853  32.613  -3.809  1.00 24.69           N  
ATOM   2247  CA  GLU B 108       4.749  32.028  -4.799  1.00 25.10           C  
ATOM   2248  C   GLU B 108       6.010  32.860  -4.850  1.00 26.10           C  
ATOM   2249  O   GLU B 108       7.118  32.334  -4.821  1.00 27.20           O  
ATOM   2250  CB  GLU B 108       4.108  32.017  -6.187  1.00 27.54           C  
ATOM   2251  CG  GLU B 108       3.180  30.844  -6.447  1.00 32.34           C  
ATOM   2252  CD  GLU B 108       3.853  29.497  -6.219  1.00 34.12           C  
ATOM   2253  OE1 GLU B 108       5.038  29.339  -6.582  1.00 36.14           O  
ATOM   2254  OE2 GLU B 108       3.186  28.591  -5.687  1.00 36.01           O  
ATOM   2255  N   GLU B 109       5.829  34.171  -4.920  1.00 26.53           N  
ATOM   2256  CA  GLU B 109       6.942  35.098  -4.976  1.00 26.59           C  
ATOM   2257  C   GLU B 109       7.847  34.931  -3.758  1.00 25.36           C  
ATOM   2258  O   GLU B 109       9.074  34.930  -3.883  1.00 26.91           O  
ATOM   2259  CB  GLU B 109       6.399  36.525  -5.039  1.00 27.99           C  
ATOM   2260  CG  GLU B 109       7.429  37.605  -5.261  1.00 29.95           C  
ATOM   2261  CD  GLU B 109       6.773  38.969  -5.384  1.00 30.21           C  
ATOM   2262  OE1 GLU B 109       6.316  39.513  -4.359  1.00 30.96           O  
ATOM   2263  OE2 GLU B 109       6.688  39.487  -6.512  1.00 33.76           O  
ATOM   2264  N   ARG B 110       7.247  34.784  -2.580  1.00 25.16           N  
ATOM   2265  CA  ARG B 110       8.028  34.631  -1.356  1.00 24.97           C  
ATOM   2266  C   ARG B 110       8.798  33.308  -1.265  1.00 22.67           C  
ATOM   2267  O   ARG B 110       9.816  33.226  -0.581  1.00 21.05           O  
ATOM   2268  CB  ARG B 110       7.133  34.796  -0.121  1.00 28.78           C  
ATOM   2269  CG  ARG B 110       7.883  34.611   1.190  1.00 33.87           C  
ATOM   2270  CD  ARG B 110       7.155  35.249   2.378  1.00 42.12           C  
ATOM   2271  NE  ARG B 110       5.823  34.688   2.595  1.00 44.89           N  
ATOM   2272  CZ  ARG B 110       5.123  34.837   3.715  1.00 47.60           C  
ATOM   2273  NH1 ARG B 110       5.627  35.526   4.730  1.00 47.97           N  
ATOM   2274  NH2 ARG B 110       3.913  34.304   3.819  1.00 48.86           N  
ATOM   2275  N   TRP B 111       8.316  32.268  -1.936  1.00 21.84           N  
ATOM   2276  CA  TRP B 111       9.034  31.007  -1.894  1.00 20.56           C  
ATOM   2277  C   TRP B 111      10.305  31.165  -2.716  1.00 22.32           C  
ATOM   2278  O   TRP B 111      11.377  30.716  -2.313  1.00 22.43           O  
ATOM   2279  CB  TRP B 111       8.212  29.849  -2.466  1.00 21.38           C  
ATOM   2280  CG  TRP B 111       9.060  28.599  -2.579  1.00 19.40           C  
ATOM   2281  CD1 TRP B 111       9.519  27.825  -1.550  1.00 18.89           C  
ATOM   2282  CD2 TRP B 111       9.643  28.064  -3.771  1.00 20.38           C  
ATOM   2283  NE1 TRP B 111      10.356  26.845  -2.028  1.00 20.20           N  
ATOM   2284  CE2 TRP B 111      10.450  26.969  -3.389  1.00 20.60           C  
ATOM   2285  CE3 TRP B 111       9.565  28.405  -5.126  1.00 20.35           C  
ATOM   2286  CZ2 TRP B 111      11.173  26.212  -4.312  1.00 21.30           C  
ATOM   2287  CZ3 TRP B 111      10.288  27.648  -6.048  1.00 20.89           C  
ATOM   2288  CH2 TRP B 111      11.079  26.566  -5.632  1.00 21.75           C  
ATOM   2289  N   GLU B 112      10.190  31.804  -3.874  1.00 24.19           N  
ATOM   2290  CA  GLU B 112      11.357  32.011  -4.714  1.00 26.23           C  
ATOM   2291  C   GLU B 112      12.382  32.894  -4.016  1.00 27.43           C  
ATOM   2292  O   GLU B 112      13.574  32.578  -4.008  1.00 28.96           O  
ATOM   2293  CB  GLU B 112      10.948  32.606  -6.072  1.00 28.73           C  
ATOM   2294  CG  GLU B 112      10.453  31.552  -7.061  1.00 32.03           C  
ATOM   2295  CD  GLU B 112      10.323  32.059  -8.493  1.00 34.29           C  
ATOM   2296  OE1 GLU B 112      11.117  32.927  -8.905  1.00 36.66           O  
ATOM   2297  OE2 GLU B 112       9.436  31.567  -9.218  1.00 32.69           O  
ATOM   2298  N   ASP B 113      11.933  33.982  -3.396  1.00 28.64           N  
ATOM   2299  CA  ASP B 113      12.867  34.866  -2.704  1.00 27.75           C  
ATOM   2300  C   ASP B 113      13.585  34.138  -1.571  1.00 26.80           C  
ATOM   2301  O   ASP B 113      14.773  34.356  -1.341  1.00 27.03           O  
ATOM   2302  CB  ASP B 113      12.154  36.113  -2.172  1.00 28.92           C  
ATOM   2303  CG  ASP B 113      11.569  36.971  -3.285  1.00 31.59           C  
ATOM   2304  OD1 ASP B 113      12.163  37.019  -4.381  1.00 29.99           O  
ATOM   2305  OD2 ASP B 113      10.516  37.609  -3.063  1.00 34.20           O  
ATOM   2306  N   LEU B 114      12.882  33.258  -0.865  1.00 24.76           N  
ATOM   2307  CA  LEU B 114      13.527  32.512   0.208  1.00 24.48           C  
ATOM   2308  C   LEU B 114      14.608  31.576  -0.361  1.00 24.23           C  
ATOM   2309  O   LEU B 114      15.713  31.487   0.171  1.00 22.35           O  
ATOM   2310  CB  LEU B 114      12.494  31.692   0.998  1.00 25.63           C  
ATOM   2311  CG  LEU B 114      11.442  32.472   1.809  1.00 29.20           C  
ATOM   2312  CD1 LEU B 114      10.564  31.501   2.612  1.00 27.47           C  
ATOM   2313  CD2 LEU B 114      12.134  33.436   2.755  1.00 29.54           C  
ATOM   2314  N   LEU B 115      14.281  30.894  -1.455  1.00 24.07           N  
ATOM   2315  CA  LEU B 115      15.197  29.943  -2.097  1.00 23.57           C  
ATOM   2316  C   LEU B 115      16.450  30.606  -2.674  1.00 24.11           C  
ATOM   2317  O   LEU B 115      17.532  30.026  -2.631  1.00 24.02           O  
ATOM   2318  CB  LEU B 115      14.471  29.197  -3.226  1.00 20.00           C  
ATOM   2319  CG  LEU B 115      15.201  28.003  -3.861  1.00 22.44           C  
ATOM   2320  CD1 LEU B 115      15.113  26.791  -2.928  1.00 19.50           C  
ATOM   2321  CD2 LEU B 115      14.587  27.676  -5.222  1.00 20.68           C  
ATOM   2322  N   PHE B 116      16.287  31.813  -3.211  1.00 23.58           N  
ATOM   2323  CA  PHE B 116      17.385  32.552  -3.833  1.00 26.71           C  
ATOM   2324  C   PHE B 116      18.056  33.569  -2.918  1.00 27.61           C  
ATOM   2325  O   PHE B 116      18.795  34.430  -3.393  1.00 27.28           O  
ATOM   2326  CB  PHE B 116      16.885  33.293  -5.078  1.00 25.61           C  
ATOM   2327  CG  PHE B 116      16.561  32.405  -6.241  1.00 25.66           C  
ATOM   2328  CD1 PHE B 116      17.568  31.741  -6.931  1.00 26.32           C  
ATOM   2329  CD2 PHE B 116      15.248  32.272  -6.681  1.00 28.38           C  
ATOM   2330  CE1 PHE B 116      17.278  30.964  -8.043  1.00 25.07           C  
ATOM   2331  CE2 PHE B 116      14.945  31.491  -7.797  1.00 27.92           C  
ATOM   2332  CZ  PHE B 116      15.963  30.838  -8.478  1.00 28.48           C  
ATOM   2333  N   ARG B 117      17.808  33.480  -1.616  1.00 30.02           N  
ATOM   2334  CA  ARG B 117      18.401  34.433  -0.689  1.00 31.13           C  
ATOM   2335  C   ARG B 117      19.910  34.562  -0.822  1.00 30.48           C  
ATOM   2336  O   ARG B 117      20.448  35.658  -0.676  1.00 30.05           O  
ATOM   2337  CB  ARG B 117      18.030  34.086   0.749  1.00 31.53           C  
ATOM   2338  CG  ARG B 117      16.669  34.622   1.149  1.00 35.27           C  
ATOM   2339  CD  ARG B 117      16.271  34.120   2.516  1.00 37.07           C  
ATOM   2340  NE  ARG B 117      16.148  32.666   2.528  1.00 37.11           N  
ATOM   2341  CZ  ARG B 117      15.833  31.954   3.601  1.00 36.18           C  
ATOM   2342  NH1 ARG B 117      15.611  32.564   4.756  1.00 37.65           N  
ATOM   2343  NH2 ARG B 117      15.731  30.635   3.515  1.00 37.33           N  
ATOM   2344  N   ASP B 118      20.604  33.464  -1.103  1.00 30.12           N  
ATOM   2345  CA  ASP B 118      22.052  33.552  -1.253  1.00 30.07           C  
ATOM   2346  C   ASP B 118      22.501  33.570  -2.712  1.00 27.12           C  
ATOM   2347  O   ASP B 118      23.642  33.230  -3.022  1.00 26.33           O  
ATOM   2348  CB  ASP B 118      22.760  32.416  -0.513  1.00 31.50           C  
ATOM   2349  CG  ASP B 118      24.259  32.655  -0.398  1.00 34.54           C  
ATOM   2350  OD1 ASP B 118      24.633  33.745   0.082  1.00 33.97           O  
ATOM   2351  OD2 ASP B 118      25.058  31.769  -0.785  1.00 37.05           O  
ATOM   2352  N   PHE B 119      21.594  33.971  -3.596  1.00 26.41           N  
ATOM   2353  CA  PHE B 119      21.874  34.077  -5.028  1.00 25.44           C  
ATOM   2354  C   PHE B 119      21.811  35.541  -5.430  1.00 26.47           C  
ATOM   2355  O   PHE B 119      20.957  36.281  -4.955  1.00 28.54           O  
ATOM   2356  CB  PHE B 119      20.829  33.312  -5.846  1.00 25.81           C  
ATOM   2357  CG  PHE B 119      21.221  31.902  -6.183  1.00 23.36           C  
ATOM   2358  CD1 PHE B 119      21.744  31.051  -5.212  1.00 25.45           C  
ATOM   2359  CD2 PHE B 119      21.037  31.413  -7.473  1.00 24.95           C  
ATOM   2360  CE1 PHE B 119      22.078  29.730  -5.523  1.00 23.46           C  
ATOM   2361  CE2 PHE B 119      21.362  30.103  -7.796  1.00 22.04           C  
ATOM   2362  CZ  PHE B 119      21.887  29.255  -6.816  1.00 23.21           C  
ATOM   2363  N   THR B 120      22.717  35.960  -6.305  1.00 28.99           N  
ATOM   2364  CA  THR B 120      22.728  37.338  -6.783  1.00 27.67           C  
ATOM   2365  C   THR B 120      21.632  37.413  -7.840  1.00 29.65           C  
ATOM   2366  O   THR B 120      21.201  36.380  -8.354  1.00 30.02           O  
ATOM   2367  CB  THR B 120      24.059  37.685  -7.457  1.00 26.72           C  
ATOM   2368  OG1 THR B 120      24.202  36.893  -8.639  1.00 26.24           O  
ATOM   2369  CG2 THR B 120      25.223  37.399  -6.527  1.00 25.88           C  
ATOM   2370  N   GLU B 121      21.193  38.625  -8.175  1.00 30.32           N  
ATOM   2371  CA  GLU B 121      20.149  38.801  -9.182  1.00 32.14           C  
ATOM   2372  C   GLU B 121      20.485  38.089 -10.488  1.00 32.30           C  
ATOM   2373  O   GLU B 121      19.623  37.451 -11.087  1.00 32.34           O  
ATOM   2374  CB  GLU B 121      19.916  40.290  -9.459  1.00 33.90           C  
ATOM   2375  CG  GLU B 121      19.456  41.083  -8.242  1.00 40.97           C  
ATOM   2376  CD  GLU B 121      19.303  42.571  -8.525  1.00 46.15           C  
ATOM   2377  OE1 GLU B 121      18.442  42.933  -9.355  1.00 48.03           O  
ATOM   2378  OE2 GLU B 121      20.047  43.378  -7.920  1.00 48.39           O  
ATOM   2379  N   ASP B 122      21.741  38.185 -10.920  1.00 32.92           N  
ATOM   2380  CA  ASP B 122      22.169  37.555 -12.166  1.00 32.66           C  
ATOM   2381  C   ASP B 122      22.178  36.024 -12.135  1.00 32.96           C  
ATOM   2382  O   ASP B 122      21.727  35.379 -13.078  1.00 32.40           O  
ATOM   2383  CB  ASP B 122      23.549  38.075 -12.577  1.00 34.06           C  
ATOM   2384  CG  ASP B 122      23.540  39.563 -12.899  1.00 35.24           C  
ATOM   2385  OD1 ASP B 122      22.545  40.041 -13.487  1.00 35.86           O  
ATOM   2386  OD2 ASP B 122      24.529  40.251 -12.576  1.00 36.08           O  
ATOM   2387  N   GLU B 123      22.703  35.434 -11.069  1.00 32.85           N  
ATOM   2388  CA  GLU B 123      22.710  33.979 -10.980  1.00 32.64           C  
ATOM   2389  C   GLU B 123      21.250  33.537 -10.998  1.00 32.30           C  
ATOM   2390  O   GLU B 123      20.883  32.550 -11.634  1.00 32.64           O  
ATOM   2391  CB  GLU B 123      23.346  33.512  -9.671  1.00 31.06           C  
ATOM   2392  CG  GLU B 123      24.832  33.774  -9.533  1.00 31.14           C  
ATOM   2393  CD  GLU B 123      25.351  33.328  -8.183  1.00 30.77           C  
ATOM   2394  OE1 GLU B 123      24.734  33.694  -7.162  1.00 32.59           O  
ATOM   2395  OE2 GLU B 123      26.376  32.615  -8.138  1.00 34.97           O  
ATOM   2396  N   ARG B 124      20.426  34.292 -10.283  1.00 31.58           N  
ATOM   2397  CA  ARG B 124      19.009  34.008 -10.181  1.00 32.98           C  
ATOM   2398  C   ARG B 124      18.369  34.005 -11.562  1.00 32.82           C  
ATOM   2399  O   ARG B 124      17.631  33.087 -11.907  1.00 32.50           O  
ATOM   2400  CB  ARG B 124      18.360  35.050  -9.268  1.00 32.49           C  
ATOM   2401  CG  ARG B 124      16.899  34.838  -8.995  1.00 32.77           C  
ATOM   2402  CD  ARG B 124      16.451  35.670  -7.804  1.00 31.43           C  
ATOM   2403  NE  ARG B 124      15.000  35.653  -7.663  1.00 31.87           N  
ATOM   2404  CZ  ARG B 124      14.347  36.112  -6.601  1.00 33.97           C  
ATOM   2405  NH1 ARG B 124      15.018  36.626  -5.577  1.00 33.19           N  
ATOM   2406  NH2 ARG B 124      13.021  36.072  -6.568  1.00 34.43           N  
ATOM   2407  N   LYS B 125      18.672  35.019 -12.365  1.00 35.89           N  
ATOM   2408  CA  LYS B 125      18.116  35.119 -13.714  1.00 36.41           C  
ATOM   2409  C   LYS B 125      18.632  33.990 -14.602  1.00 35.03           C  
ATOM   2410  O   LYS B 125      17.897  33.423 -15.409  1.00 33.54           O  
ATOM   2411  CB  LYS B 125      18.492  36.465 -14.340  1.00 40.98           C  
ATOM   2412  CG  LYS B 125      18.145  37.670 -13.477  1.00 45.68           C  
ATOM   2413  CD  LYS B 125      18.673  38.961 -14.084  1.00 47.21           C  
ATOM   2414  CE  LYS B 125      18.452  40.144 -13.150  1.00 50.30           C  
ATOM   2415  NZ  LYS B 125      18.961  41.419 -13.734  1.00 50.36           N  
ATOM   2416  N   LEU B 126      19.907  33.665 -14.454  1.00 34.39           N  
ATOM   2417  CA  LEU B 126      20.491  32.610 -15.257  1.00 32.38           C  
ATOM   2418  C   LEU B 126      19.875  31.264 -14.909  1.00 31.74           C  
ATOM   2419  O   LEU B 126      19.443  30.518 -15.794  1.00 29.05           O  
ATOM   2420  CB  LEU B 126      21.998  32.553 -15.040  1.00 31.78           C  
ATOM   2421  CG  LEU B 126      22.706  31.453 -15.823  1.00 31.97           C  
ATOM   2422  CD1 LEU B 126      22.429  31.610 -17.311  1.00 33.30           C  
ATOM   2423  CD2 LEU B 126      24.197  31.527 -15.548  1.00 31.30           C  
ATOM   2424  N   PHE B 127      19.843  30.948 -13.618  1.00 31.56           N  
ATOM   2425  CA  PHE B 127      19.277  29.679 -13.187  1.00 31.03           C  
ATOM   2426  C   PHE B 127      17.879  29.548 -13.771  1.00 30.66           C  
ATOM   2427  O   PHE B 127      17.510  28.494 -14.289  1.00 28.47           O  
ATOM   2428  CB  PHE B 127      19.194  29.590 -11.665  1.00 30.75           C  
ATOM   2429  CG  PHE B 127      18.730  28.246 -11.175  1.00 29.95           C  
ATOM   2430  CD1 PHE B 127      19.601  27.165 -11.149  1.00 28.61           C  
ATOM   2431  CD2 PHE B 127      17.399  28.045 -10.807  1.00 28.80           C  
ATOM   2432  CE1 PHE B 127      19.157  25.897 -10.766  1.00 28.31           C  
ATOM   2433  CE2 PHE B 127      16.944  26.785 -10.423  1.00 26.84           C  
ATOM   2434  CZ  PHE B 127      17.827  25.707 -10.404  1.00 27.66           C  
ATOM   2435  N   ARG B 128      17.099  30.622 -13.686  0.50 30.50           N  
ATOM   2437  CA  ARG B 128      15.738  30.612 -14.211  0.50 31.88           C  
ATOM   2439  C   ARG B 128      15.733  30.386 -15.719  0.50 32.96           C  
ATOM   2441  O   ARG B 128      14.901  29.639 -16.240  0.50 32.51           O  
ATOM   2443  CB  ARG B 128      15.023  31.929 -13.883  0.50 32.23           C  
ATOM   2445  CG  ARG B 128      14.755  32.133 -12.399  0.50 31.38           C  
ATOM   2447  CD  ARG B 128      14.038  33.447 -12.126  0.50 32.57           C  
ATOM   2449  NE  ARG B 128      13.720  33.609 -10.710  0.50 33.75           N  
ATOM   2451  CZ  ARG B 128      13.152  34.693 -10.186  0.50 34.39           C  
ATOM   2453  NH1 ARG B 128      12.836  35.722 -10.959  0.50 35.21           N  
ATOM   2455  NH2 ARG B 128      12.890  34.746  -8.889  0.50 33.58           N  
ATOM   2457  N   LYS B 129      16.663  31.028 -16.419  1.00 32.81           N  
ATOM   2458  CA  LYS B 129      16.735  30.869 -17.861  1.00 34.44           C  
ATOM   2459  C   LYS B 129      17.061  29.428 -18.212  1.00 33.06           C  
ATOM   2460  O   LYS B 129      16.435  28.843 -19.094  1.00 35.23           O  
ATOM   2461  CB  LYS B 129      17.790  31.799 -18.463  1.00 35.88           C  
ATOM   2462  CG  LYS B 129      17.928  31.640 -19.972  1.00 40.51           C  
ATOM   2463  CD  LYS B 129      17.938  32.987 -20.679  1.00 44.99           C  
ATOM   2464  CE  LYS B 129      17.941  32.820 -22.192  1.00 47.27           C  
ATOM   2465  NZ  LYS B 129      17.819  34.134 -22.895  1.00 49.68           N  
ATOM   2466  N   MET B 130      18.040  28.846 -17.527  1.00 32.77           N  
ATOM   2467  CA  MET B 130      18.405  27.462 -17.804  1.00 32.70           C  
ATOM   2468  C   MET B 130      17.233  26.506 -17.564  1.00 30.88           C  
ATOM   2469  O   MET B 130      16.957  25.647 -18.397  1.00 31.76           O  
ATOM   2470  CB  MET B 130      19.618  27.050 -16.964  1.00 32.42           C  
ATOM   2471  CG  MET B 130      20.901  27.745 -17.395  1.00 34.35           C  
ATOM   2472  SD  MET B 130      22.320  27.380 -16.362  1.00 35.72           S  
ATOM   2473  CE  MET B 130      23.439  26.662 -17.537  1.00 40.85           C  
ATOM   2474  N   CYS B 131      16.531  26.662 -16.444  1.00 28.88           N  
ATOM   2475  CA  CYS B 131      15.394  25.789 -16.155  1.00 27.54           C  
ATOM   2476  C   CYS B 131      14.397  25.807 -17.307  1.00 28.73           C  
ATOM   2477  O   CYS B 131      13.831  24.771 -17.680  1.00 27.65           O  
ATOM   2478  CB  CYS B 131      14.677  26.228 -14.877  1.00 26.87           C  
ATOM   2479  SG  CYS B 131      15.541  25.892 -13.334  1.00 22.09           S  
ATOM   2480  N   ARG B 132      14.177  26.989 -17.871  1.00 28.10           N  
ATOM   2481  CA  ARG B 132      13.234  27.119 -18.972  1.00 28.16           C  
ATOM   2482  C   ARG B 132      13.741  26.312 -20.160  1.00 26.95           C  
ATOM   2483  O   ARG B 132      12.979  25.587 -20.810  1.00 27.57           O  
ATOM   2484  CB  ARG B 132      13.056  28.598 -19.342  1.00 29.62           C  
ATOM   2485  CG  ARG B 132      11.985  28.864 -20.394  1.00 32.10           C  
ATOM   2486  CD  ARG B 132      12.568  28.844 -21.794  1.00 37.71           C  
ATOM   2487  NE  ARG B 132      13.479  29.966 -22.000  1.00 39.17           N  
ATOM   2488  CZ  ARG B 132      14.292  30.088 -23.044  1.00 42.05           C  
ATOM   2489  NH1 ARG B 132      14.314  29.151 -23.985  1.00 41.81           N  
ATOM   2490  NH2 ARG B 132      15.081  31.149 -23.145  1.00 43.81           N  
ATOM   2491  N   ARG B 133      15.036  26.424 -20.428  1.00 26.78           N  
ATOM   2492  CA  ARG B 133      15.644  25.692 -21.531  1.00 30.37           C  
ATOM   2493  C   ARG B 133      15.487  24.193 -21.300  1.00 28.93           C  
ATOM   2494  O   ARG B 133      15.056  23.460 -22.185  1.00 29.96           O  
ATOM   2495  CB  ARG B 133      17.124  26.065 -21.661  1.00 29.63           C  
ATOM   2496  CG  ARG B 133      17.365  27.493 -22.148  1.00 32.79           C  
ATOM   2497  CD  ARG B 133      18.837  27.874 -22.069  1.00 33.15           C  
ATOM   2498  NE  ARG B 133      19.681  26.979 -22.857  1.00 34.10           N  
ATOM   2499  CZ  ARG B 133      21.008  26.931 -22.770  1.00 33.43           C  
ATOM   2500  NH1 ARG B 133      21.655  27.729 -21.930  1.00 33.72           N  
ATOM   2501  NH2 ARG B 133      21.690  26.073 -23.514  1.00 35.21           N  
ATOM   2502  N   LEU B 134      15.823  23.739 -20.097  1.00 28.96           N  
ATOM   2503  CA  LEU B 134      15.705  22.318 -19.775  1.00 26.63           C  
ATOM   2504  C   LEU B 134      14.249  21.873 -19.855  1.00 25.12           C  
ATOM   2505  O   LEU B 134      13.953  20.762 -20.300  1.00 25.58           O  
ATOM   2506  CB  LEU B 134      16.287  22.052 -18.385  1.00 24.71           C  
ATOM   2507  CG  LEU B 134      17.805  22.258 -18.362  1.00 25.89           C  
ATOM   2508  CD1 LEU B 134      18.324  22.275 -16.936  1.00 24.87           C  
ATOM   2509  CD2 LEU B 134      18.472  21.150 -19.162  1.00 25.26           C  
ATOM   2510  N   ALA B 135      13.338  22.751 -19.447  1.00 25.42           N  
ATOM   2511  CA  ALA B 135      11.910  22.438 -19.489  1.00 24.92           C  
ATOM   2512  C   ALA B 135      11.424  22.237 -20.927  1.00 26.57           C  
ATOM   2513  O   ALA B 135      10.713  21.277 -21.228  1.00 24.47           O  
ATOM   2514  CB  ALA B 135      11.110  23.554 -18.818  1.00 23.09           C  
ATOM   2515  N   GLU B 136      11.792  23.147 -21.820  1.00 30.74           N  
ATOM   2516  CA  GLU B 136      11.369  23.013 -23.214  1.00 32.99           C  
ATOM   2517  C   GLU B 136      11.864  21.676 -23.764  1.00 34.03           C  
ATOM   2518  O   GLU B 136      11.134  20.965 -24.450  1.00 31.88           O  
ATOM   2519  CB  GLU B 136      11.895  24.186 -24.060  1.00 34.16           C  
ATOM   2520  CG  GLU B 136      11.188  25.505 -23.742  1.00 37.42           C  
ATOM   2521  CD  GLU B 136      10.999  26.411 -24.955  1.00 40.78           C  
ATOM   2522  OE1 GLU B 136      10.751  25.886 -26.067  1.00 43.04           O  
ATOM   2523  OE2 GLU B 136      11.073  27.652 -24.793  1.00 38.57           O  
ATOM   2524  N   GLU B 137      13.101  21.331 -23.431  1.00 35.26           N  
ATOM   2525  CA  GLU B 137      13.685  20.073 -23.867  1.00 36.56           C  
ATOM   2526  C   GLU B 137      12.839  18.913 -23.336  1.00 37.72           C  
ATOM   2527  O   GLU B 137      12.508  17.975 -24.068  1.00 37.22           O  
ATOM   2528  CB  GLU B 137      15.109  19.948 -23.333  1.00 36.58           C  
ATOM   2529  CG  GLU B 137      15.871  18.777 -23.906  1.00 38.30           C  
ATOM   2530  CD  GLU B 137      16.096  18.936 -25.393  1.00 39.30           C  
ATOM   2531  OE1 GLU B 137      16.752  19.923 -25.786  1.00 39.31           O  
ATOM   2532  OE2 GLU B 137      15.614  18.083 -26.167  1.00 38.94           O  
ATOM   2533  N   ALA B 138      12.495  18.987 -22.053  1.00 35.87           N  
ATOM   2534  CA  ALA B 138      11.698  17.956 -21.405  1.00 35.83           C  
ATOM   2535  C   ALA B 138      10.432  17.678 -22.209  1.00 36.47           C  
ATOM   2536  O   ALA B 138      10.010  16.525 -22.332  1.00 36.26           O  
ATOM   2537  CB  ALA B 138      11.346  18.386 -19.981  1.00 33.38           C  
ATOM   2538  N   VAL B 139       9.830  18.737 -22.747  1.00 36.95           N  
ATOM   2539  CA  VAL B 139       8.622  18.603 -23.558  1.00 40.37           C  
ATOM   2540  C   VAL B 139       8.913  17.807 -24.829  1.00 41.40           C  
ATOM   2541  O   VAL B 139       8.120  16.953 -25.229  1.00 41.00           O  
ATOM   2542  CB  VAL B 139       8.049  19.984 -23.952  1.00 41.05           C  
ATOM   2543  CG1 VAL B 139       7.014  19.830 -25.055  1.00 42.66           C  
ATOM   2544  CG2 VAL B 139       7.409  20.639 -22.741  1.00 42.96           C  
ATOM   2545  N   ARG B 140      10.050  18.093 -25.460  1.00 43.63           N  
ATOM   2546  CA  ARG B 140      10.453  17.391 -26.679  1.00 45.08           C  
ATOM   2547  C   ARG B 140      10.657  15.907 -26.386  1.00 45.13           C  
ATOM   2548  O   ARG B 140      10.105  15.047 -27.071  1.00 46.37           O  
ATOM   2549  CB  ARG B 140      11.745  17.993 -27.236  1.00 45.88           C  
ATOM   2550  CG  ARG B 140      11.570  19.393 -27.815  1.00 49.50           C  
ATOM   2551  CD  ARG B 140      12.878  19.946 -28.380  1.00 51.89           C  
ATOM   2552  NE  ARG B 140      13.815  20.349 -27.333  1.00 54.42           N  
ATOM   2553  CZ  ARG B 140      14.187  21.606 -27.106  1.00 55.63           C  
ATOM   2554  NH1 ARG B 140      13.705  22.592 -27.853  1.00 55.71           N  
ATOM   2555  NH2 ARG B 140      15.044  21.881 -26.132  1.00 56.88           N  
ATOM   2556  N   MET B 141      11.451  15.618 -25.361  1.00 45.62           N  
ATOM   2557  CA  MET B 141      11.722  14.244 -24.952  1.00 45.82           C  
ATOM   2558  C   MET B 141      10.428  13.437 -24.825  1.00 46.12           C  
ATOM   2559  O   MET B 141      10.370  12.318 -25.381  1.00 46.58           O  
ATOM   2560  CB  MET B 141      12.470  14.240 -23.613  1.00 45.74           C  
ATOM   2561  CG  MET B 141      13.936  14.623 -23.714  1.00 43.32           C  
ATOM   2562  SD  MET B 141      14.665  15.111 -22.135  1.00 43.18           S  
ATOM   2563  CE  MET B 141      14.179  13.716 -21.083  1.00 41.48           C  
TER    2564      MET B 141                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
