
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   94 (  788),  selected   94 , name 1tbx_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 1tbx_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_A      S       1           -
LGA    T     4_A      N       2           -
LGA    P     5_A      A       3           -
LGA    F     6_A      M       4           -
LGA    -       -      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    -       -      T      10           -
LGA    -       -      E      11           -
LGA    -       -      I      12           -
LGA    -       -      C      13           -
LGA    -       -      I      14           -
LGA    -       -      D      15           -
LGA    -       -      P      16           -
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    -       -      S      19           -
LGA    -       -      V      20           -
LGA    -       -      L      21           -
LGA    -       -      H      22           -
LGA    -       -      L      23           -
LGA    F     7_A      L      24          6.286
LGA    Y     8_A      G      25          3.200
LGA    -       -      K      26           -
LGA    -       -      K      27           -
LGA    P     9_A      Y      28          2.222
LGA    E    10_A      T      29          1.946
LGA    A    11_A      M      30          1.838
LGA    I    12_A      L      31          1.628
LGA    V    13_A      I      32          0.542
LGA    L    14_A      I      33          0.793
LGA    A    15_A      S      34          1.523
LGA    Y    16_A      V      35          1.495
LGA    L    17_A      L      36          0.873
LGA    Y    18_A      G      37          1.280
LGA    D    19_A      N      38          3.116
LGA    N    20_A      G      39          3.799
LGA    -       -      S      40           -
LGA    E    21_A      T      41          4.777
LGA    G    22_A      R      42          0.455
LGA    I    23_A      Q      43          1.007
LGA    A    24_A      N      44          1.018
LGA    T    25_A      F      45          1.967
LGA    Y    26_A      N      46          1.846
LGA    D    27_A      D      47          0.910
LGA    L    28_A      I      48          0.684
LGA    Y    29_A      R      49          1.148
LGA    K    30_A      S      50          0.907
LGA    K    31_A      S      51          0.099
LGA    V    32_A      I      52          1.625
LGA    N    33_A      P      53          2.286
LGA    A    34_A      -       -           -
LGA    E    35_A      -       -           -
LGA    F    36_A      -       -           -
LGA    P    37_A      G      54          2.924
LGA    X    38_A      I      55          2.453
LGA    S    39_A      S      56          2.041
LGA    T    40_A      S      57          1.925
LGA    A    41_A      T      58          1.571
LGA    T    42_A      I      59          1.461
LGA    F    43_A      L      60          1.425
LGA    Y    44_A      S      61          1.251
LGA    D    45_A      R      62          1.025
LGA    A    46_A      R      63          0.735
LGA    K    47_A      I      64          0.564
LGA    K    48_A      K      65          0.684
LGA    F    49_A      D      66          0.640
LGA    L    50_A      L      67          0.598
LGA    I    51_A      I      68          0.583
LGA    Q    52_A      D      69          0.747
LGA    E    53_A      S      70          0.636
LGA    G    54_A      G      71          0.540
LGA    F    55_A      L      72          0.457
LGA    V    56_A      V      73          0.607
LGA    K    57_A      E      74          0.715
LGA    E    58_A      R      75          0.649
LGA    R    59_A      R      76          0.714
LGA    Q    60_A      S      77          2.139
LGA    E    61_A      G      78          3.232
LGA    R    62_A      Q      79          4.293
LGA    G    63_A      I      80          2.869
LGA    E    64_A      -       -           -
LGA    K    65_A      T      81          1.259
LGA    R    66_A      T      82          0.654
LGA    L    67_A      Y      83          0.878
LGA    Y    68_A      A      84          1.303
LGA    L    69_A      L      85          1.253
LGA    T    70_A      T      86          0.484
LGA    E    71_A      E      87          0.839
LGA    K    72_A      K      88          0.532
LGA    G    73_A      G      89          0.665
LGA    K    74_A      M      90          0.825
LGA    L    75_A      N      91          0.672
LGA    F    76_A      V      92          0.617
LGA    A    77_A      R      93          1.095
LGA    I    78_A      N      94          1.571
LGA    S    79_A      S      95          1.410
LGA    L    80_A      L      96          1.452
LGA    K    81_A      M      97          2.494
LGA    T    82_A      P      98          2.380
LGA    A    83_A      L      99          1.479
LGA    I    84_A      L     100          1.989
LGA    E    85_A      Q     101          2.746
LGA    T    86_A      Y     102          2.001
LGA    Y    87_A      I     103          1.063
LGA    K    88_A      S     104          1.998
LGA    Q    89_A      V     105          2.489
LGA    I    90_A      L     106          1.555
LGA    K    91_A      D     107          0.392
LGA    K    92_A      R     108          2.108
LGA    R    93_A      N     109          3.501
LGA    H    94_A      -       -           -
LGA    H    95_A      -       -           -
LGA    H    96_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   94  109    5.0     83    1.89    19.28     68.964     4.171

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.691361 * X  +  -0.719806 * Y  +   0.062449 * Z  +  97.270218
  Y_new =   0.459369 * X  +  -0.371206 * Y  +   0.806961 * Z  + -16.411400
  Z_new =  -0.557674 * X  +   0.586589 * Y  +   0.587293 * Z  + -12.895896 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.784798   -2.356795  [ DEG:    44.9656   -135.0344 ]
  Theta =   0.591581    2.550012  [ DEG:    33.8951    146.1049 ]
  Phi   =   2.555132   -0.586461  [ DEG:   146.3983    -33.6017 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tbx_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tbx_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   94  109   5.0   83   1.89   19.28  68.964
REMARK  ---------------------------------------------------------- 
MOLECULE 1tbx_A
HEADER    VIRAL PROTEIN                           20-MAY-04   1TBX              
TITLE     CRYSTAL STRUCTURE OF SSV1 F-93                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL 11.0 KDA PROTEIN;                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: ORF F-93;                                                   
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SULFOLOBUS VIRUS-LIKE PARTICLE SSV1;            
SOURCE   3 ORGANISM_COMMON: VIRUS;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    SULFOLOBUS SPINDLE VIRUS, WINGED HELIX, F-93, FUSELLOVIRUS            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.KRAFT,A.OECKINGHAUS,D.KUMMEL,G.H.GAUSS,B.WIEDENHEFT,                
AUTHOR   2 M.YOUNG,C.M.LAWRENCE                                                 
REVDAT   2   19-OCT-04 1TBX    1       JRNL                                     
REVDAT   1   13-JUL-04 1TBX    0                                                
JRNL        AUTH   P.KRAFT,A.OECKINGHAUS,D.KUMMEL,G.H.GAUSS,J.GILMORE,          
JRNL        AUTH 2 B.WIEDENHEFT,M.YOUNG,C.M.LAWRENCE                            
JRNL        TITL   CRYSTAL STRUCTURE OF F-93 FROM SULFOLOBUS                    
JRNL        TITL 2 SPINDLE-SHAPED VIRUS 1, A WINGED-HELIX DNA BINDING           
JRNL        TITL 3 PROTEIN.                                                     
JRNL        REF    J.VIROL.                      V.  78 11544 2004              
JRNL        REFN   ASTM JOVIAM  US ISSN 0022-538X                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1TBX A    1    93  UNP    P20222   Y110_SSV1        1     93             
DBREF  1TBX B    1    93  UNP    P20222   Y110_SSV1        1     93             
SEQRES   1 A   99  MSE LYS SER THR PRO PHE PHE TYR PRO GLU ALA ILE VAL          
SEQRES   2 A   99  LEU ALA TYR LEU TYR ASP ASN GLU GLY ILE ALA THR TYR          
SEQRES   3 A   99  ASP LEU TYR LYS LYS VAL ASN ALA GLU PHE PRO MSE SER          
SEQRES   4 A   99  THR ALA THR PHE TYR ASP ALA LYS LYS PHE LEU ILE GLN          
SEQRES   5 A   99  GLU GLY PHE VAL LYS GLU ARG GLN GLU ARG GLY GLU LYS          
SEQRES   6 A   99  ARG LEU TYR LEU THR GLU LYS GLY LYS LEU PHE ALA ILE          
SEQRES   7 A   99  SER LEU LYS THR ALA ILE GLU THR TYR LYS GLN ILE LYS          
SEQRES   8 A   99  LYS ARG HIS HIS HIS HIS HIS HIS                              
SEQRES   1 B   99  MSE LYS SER THR PRO PHE PHE TYR PRO GLU ALA ILE VAL          
SEQRES   2 B   99  LEU ALA TYR LEU TYR ASP ASN GLU GLY ILE ALA THR TYR          
SEQRES   3 B   99  ASP LEU TYR LYS LYS VAL ASN ALA GLU PHE PRO MSE SER          
SEQRES   4 B   99  THR ALA THR PHE TYR ASP ALA LYS LYS PHE LEU ILE GLN          
SEQRES   5 B   99  GLU GLY PHE VAL LYS GLU ARG GLN GLU ARG GLY GLU LYS          
SEQRES   6 B   99  ARG LEU TYR LEU THR GLU LYS GLY LYS LEU PHE ALA ILE          
SEQRES   7 B   99  SER LEU LYS THR ALA ILE GLU THR TYR LYS GLN ILE LYS          
SEQRES   8 B   99  LYS ARG HIS HIS HIS HIS HIS HIS                              
HET    MSE  A  38       8                                                       
HET    MSE  B  38       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
CRYST1  120.493  120.493  120.493  90.00  90.00  90.00 P 43 3 2     48          
ATOM      1  N   SER A   3       4.330  14.911  -4.054  1.00 51.38           N  
ATOM      2  CA  SER A   3       5.356  15.753  -4.748  1.00 55.26           C  
ATOM      3  C   SER A   3       4.963  17.261  -4.863  1.00 56.19           C  
ATOM      4  O   SER A   3       3.779  17.628  -4.735  1.00 55.89           O  
ATOM      5  CB  SER A   3       5.651  15.175  -6.124  1.00 53.66           C  
ATOM      6  OG  SER A   3       4.697  15.675  -7.034  1.00 56.44           O  
ATOM      7  N   THR A   4       5.964  18.115  -5.124  1.00 51.99           N  
ATOM      8  CA  THR A   4       5.851  19.584  -4.958  1.00 44.07           C  
ATOM      9  C   THR A   4       5.485  19.985  -3.527  1.00 38.00           C  
ATOM     10  O   THR A   4       4.373  19.685  -3.064  1.00 35.83           O  
ATOM     11  CB  THR A   4       4.873  20.210  -5.990  1.00 44.17           C  
ATOM     12  OG1 THR A   4       5.428  20.030  -7.298  1.00 48.47           O  
ATOM     13  CG2 THR A   4       4.796  21.742  -5.859  1.00 29.42           C  
ATOM     14  N   PRO A   5       6.432  20.628  -2.832  1.00 33.94           N  
ATOM     15  CA  PRO A   5       6.163  21.328  -1.545  1.00 35.38           C  
ATOM     16  C   PRO A   5       5.388  22.538  -2.024  1.00 38.13           C  
ATOM     17  O   PRO A   5       5.724  22.999  -3.118  1.00 46.89           O  
ATOM     18  CB  PRO A   5       7.552  21.729  -1.079  1.00 36.83           C  
ATOM     19  CG  PRO A   5       8.535  21.089  -2.067  1.00 31.90           C  
ATOM     20  CD  PRO A   5       7.820  20.790  -3.307  1.00 26.88           C  
ATOM     21  N   PHE A   6       4.405  23.126  -1.379  1.00 36.55           N  
ATOM     22  CA  PHE A   6       4.224  23.618  -0.076  1.00 30.28           C  
ATOM     23  C   PHE A   6       2.720  23.843  -0.378  1.00 35.57           C  
ATOM     24  O   PHE A   6       1.902  24.160   0.500  1.00 39.83           O  
ATOM     25  CB  PHE A   6       4.803  25.032  -0.068  1.00 22.02           C  
ATOM     26  CG  PHE A   6       6.220  25.134   0.435  1.00 26.21           C  
ATOM     27  CD1 PHE A   6       7.293  24.801  -0.374  1.00 26.14           C  
ATOM     28  CD2 PHE A   6       6.485  25.601   1.722  1.00 22.84           C  
ATOM     29  CE1 PHE A   6       8.609  24.893   0.099  1.00 26.44           C  
ATOM     30  CE2 PHE A   6       7.778  25.701   2.183  1.00 24.33           C  
ATOM     31  CZ  PHE A   6       8.850  25.347   1.363  1.00 23.51           C  
ATOM     32  N   PHE A   7       2.404  23.733  -1.685  1.00 34.91           N  
ATOM     33  CA  PHE A   7       1.083  23.913  -2.272  1.00 29.62           C  
ATOM     34  C   PHE A   7       0.552  22.594  -2.794  1.00 31.35           C  
ATOM     35  O   PHE A   7       1.245  21.825  -3.453  1.00 32.04           O  
ATOM     36  CB  PHE A   7       1.137  24.885  -3.463  1.00 30.36           C  
ATOM     37  CG  PHE A   7       2.002  26.096  -3.226  1.00 29.88           C  
ATOM     38  CD1 PHE A   7       3.312  26.124  -3.687  1.00 26.07           C  
ATOM     39  CD2 PHE A   7       1.523  27.189  -2.513  1.00 23.32           C  
ATOM     40  CE1 PHE A   7       4.136  27.250  -3.471  1.00 27.44           C  
ATOM     41  CE2 PHE A   7       2.350  28.320  -2.279  1.00 26.64           C  
ATOM     42  CZ  PHE A   7       3.662  28.344  -2.765  1.00 22.76           C  
ATOM     43  N   TYR A   8      -0.702  22.341  -2.492  1.00 28.20           N  
ATOM     44  CA  TYR A   8      -1.418  21.246  -3.081  1.00 28.84           C  
ATOM     45  C   TYR A   8      -1.825  21.621  -4.508  1.00 28.58           C  
ATOM     46  O   TYR A   8      -1.718  22.792  -4.900  1.00 33.56           O  
ATOM     47  CB  TYR A   8      -2.664  21.016  -2.260  1.00 28.81           C  
ATOM     48  CG  TYR A   8      -2.485  20.161  -1.043  1.00 36.36           C  
ATOM     49  CD1 TYR A   8      -2.340  20.731   0.232  1.00 41.60           C  
ATOM     50  CD2 TYR A   8      -2.504  18.789  -1.141  1.00 35.02           C  
ATOM     51  CE1 TYR A   8      -2.226  19.938   1.359  1.00 36.22           C  
ATOM     52  CE2 TYR A   8      -2.384  18.001  -0.036  1.00 38.51           C  
ATOM     53  CZ  TYR A   8      -2.246  18.565   1.213  1.00 39.46           C  
ATOM     54  OH  TYR A   8      -2.134  17.717   2.307  1.00 41.52           O  
ATOM     55  N   PRO A   9      -2.299  20.646  -5.289  1.00 27.13           N  
ATOM     56  CA  PRO A   9      -2.748  20.923  -6.665  1.00 26.00           C  
ATOM     57  C   PRO A   9      -3.833  21.980  -6.800  1.00 28.80           C  
ATOM     58  O   PRO A   9      -3.771  22.834  -7.698  1.00 29.31           O  
ATOM     59  CB  PRO A   9      -3.243  19.579  -7.141  1.00 23.79           C  
ATOM     60  CG  PRO A   9      -2.303  18.644  -6.414  1.00 25.56           C  
ATOM     61  CD  PRO A   9      -2.342  19.203  -4.968  1.00 18.63           C  
ATOM     62  N   GLU A  10      -4.809  21.937  -5.912  1.00 26.95           N  
ATOM     63  CA  GLU A  10      -5.888  22.907  -5.920  1.00 22.71           C  
ATOM     64  C   GLU A  10      -5.330  24.331  -5.892  1.00 28.01           C  
ATOM     65  O   GLU A  10      -5.827  25.235  -6.592  1.00 25.59           O  
ATOM     66  CB  GLU A  10      -6.710  22.601  -4.699  1.00 24.77           C  
ATOM     67  CG  GLU A  10      -6.268  21.256  -4.125  1.00 32.98           C  
ATOM     68  CD  GLU A  10      -6.027  21.320  -2.641  1.00 36.14           C  
ATOM     69  OE1 GLU A  10      -6.248  22.396  -2.091  1.00 51.72           O  
ATOM     70  OE2 GLU A  10      -5.642  20.315  -1.998  1.00 42.93           O  
ATOM     71  N   ALA A  11      -4.262  24.527  -5.107  1.00 29.65           N  
ATOM     72  CA  ALA A  11      -3.600  25.828  -5.040  1.00 27.55           C  
ATOM     73  C   ALA A  11      -2.939  26.207  -6.368  1.00 27.21           C  
ATOM     74  O   ALA A  11      -3.119  27.316  -6.860  1.00 29.80           O  
ATOM     75  CB  ALA A  11      -2.600  25.869  -3.886  1.00 27.28           C  
ATOM     76  N   ILE A  12      -2.167  25.301  -6.958  1.00 24.73           N  
ATOM     77  CA  ILE A  12      -1.526  25.629  -8.229  1.00 23.51           C  
ATOM     78  C   ILE A  12      -2.571  25.947  -9.313  1.00 26.17           C  
ATOM     79  O   ILE A  12      -2.492  27.011  -9.959  1.00 24.36           O  
ATOM     80  CB  ILE A  12      -0.612  24.502  -8.676  1.00 22.00           C  
ATOM     81  CG1 ILE A  12       0.441  24.287  -7.601  1.00 26.86           C  
ATOM     82  CG2 ILE A  12       0.070  24.864  -9.966  1.00 14.33           C  
ATOM     83  CD1 ILE A  12       1.042  22.923  -7.609  1.00 26.17           C  
ATOM     84  N   VAL A  13      -3.539  25.040  -9.482  1.00 23.31           N  
ATOM     85  CA  VAL A  13      -4.543  25.123 -10.511  1.00 18.14           C  
ATOM     86  C   VAL A  13      -5.264  26.437 -10.317  1.00 24.11           C  
ATOM     87  O   VAL A  13      -5.389  27.220 -11.238  1.00 30.17           O  
ATOM     88  CB  VAL A  13      -5.505  23.960 -10.402  1.00 23.61           C  
ATOM     89  CG1 VAL A  13      -6.677  24.170 -11.363  1.00 14.49           C  
ATOM     90  CG2 VAL A  13      -4.742  22.540 -10.615  1.00  9.55           C  
ATOM     91  N   LEU A  14      -5.657  26.743  -9.097  1.00 23.68           N  
ATOM     92  CA  LEU A  14      -6.311  28.016  -8.845  1.00 24.74           C  
ATOM     93  C   LEU A  14      -5.479  29.251  -9.282  1.00 27.91           C  
ATOM     94  O   LEU A  14      -5.977  30.155  -9.969  1.00 26.44           O  
ATOM     95  CB  LEU A  14      -6.699  28.101  -7.357  1.00 27.60           C  
ATOM     96  CG  LEU A  14      -7.786  29.134  -7.061  1.00 29.11           C  
ATOM     97  CD1 LEU A  14      -8.950  28.883  -7.998  1.00 23.89           C  
ATOM     98  CD2 LEU A  14      -8.211  29.126  -5.574  1.00 23.90           C  
ATOM     99  N   ALA A  15      -4.214  29.286  -8.869  1.00 26.89           N  
ATOM    100  CA  ALA A  15      -3.307  30.381  -9.189  1.00 25.17           C  
ATOM    101  C   ALA A  15      -3.202  30.542 -10.687  1.00 27.88           C  
ATOM    102  O   ALA A  15      -3.274  31.644 -11.203  1.00 34.09           O  
ATOM    103  CB  ALA A  15      -1.944  30.095  -8.627  1.00 22.52           C  
ATOM    104  N   TYR A  16      -3.055  29.430 -11.396  1.00 27.22           N  
ATOM    105  CA  TYR A  16      -2.852  29.488 -12.835  1.00 25.41           C  
ATOM    106  C   TYR A  16      -4.067  29.976 -13.608  1.00 26.16           C  
ATOM    107  O   TYR A  16      -3.943  30.549 -14.707  1.00 27.09           O  
ATOM    108  CB  TYR A  16      -2.367  28.143 -13.337  1.00 26.40           C  
ATOM    109  CG  TYR A  16      -0.884  28.079 -13.175  1.00 33.71           C  
ATOM    110  CD1 TYR A  16      -0.286  27.932 -11.900  1.00 33.18           C  
ATOM    111  CD2 TYR A  16      -0.047  28.254 -14.288  1.00 36.01           C  
ATOM    112  CE1 TYR A  16       1.126  27.921 -11.773  1.00 36.54           C  
ATOM    113  CE2 TYR A  16       1.353  28.237 -14.177  1.00 31.09           C  
ATOM    114  CZ  TYR A  16       1.932  28.071 -12.938  1.00 37.76           C  
ATOM    115  OH  TYR A  16       3.308  28.076 -12.898  1.00 36.73           O  
ATOM    116  N   LEU A  17      -5.243  29.768 -13.034  1.00 24.41           N  
ATOM    117  CA  LEU A  17      -6.466  30.181 -13.695  1.00 24.43           C  
ATOM    118  C   LEU A  17      -6.572  31.718 -13.705  1.00 29.61           C  
ATOM    119  O   LEU A  17      -7.126  32.324 -14.643  1.00 28.32           O  
ATOM    120  CB  LEU A  17      -7.670  29.562 -12.996  1.00 23.46           C  
ATOM    121  CG  LEU A  17      -9.034  29.814 -13.605  1.00 21.21           C  
ATOM    122  CD1 LEU A  17      -8.942  29.618 -15.101  1.00 20.38           C  
ATOM    123  CD2 LEU A  17     -10.027  28.871 -12.990  1.00 22.25           C  
ATOM    124  N   TYR A  18      -6.035  32.337 -12.656  1.00 25.79           N  
ATOM    125  CA  TYR A  18      -6.107  33.746 -12.577  1.00 27.15           C  
ATOM    126  C   TYR A  18      -5.490  34.310 -13.836  1.00 29.98           C  
ATOM    127  O   TYR A  18      -4.422  33.887 -14.269  1.00 37.33           O  
ATOM    128  CB  TYR A  18      -5.445  34.301 -11.320  1.00 25.28           C  
ATOM    129  CG  TYR A  18      -5.690  35.801 -11.219  1.00 24.98           C  
ATOM    130  CD1 TYR A  18      -6.868  36.299 -10.648  1.00 21.10           C  
ATOM    131  CD2 TYR A  18      -4.761  36.730 -11.739  1.00 21.87           C  
ATOM    132  CE1 TYR A  18      -7.116  37.685 -10.567  1.00 25.34           C  
ATOM    133  CE2 TYR A  18      -4.985  38.124 -11.635  1.00 23.01           C  
ATOM    134  CZ  TYR A  18      -6.175  38.602 -11.063  1.00 25.74           C  
ATOM    135  OH  TYR A  18      -6.438  39.984 -10.984  1.00 28.87           O  
ATOM    136  N   ASP A  19      -6.206  35.258 -14.424  1.00 31.51           N  
ATOM    137  CA  ASP A  19      -5.821  35.824 -15.685  1.00 40.95           C  
ATOM    138  C   ASP A  19      -5.924  34.894 -16.903  1.00 39.22           C  
ATOM    139  O   ASP A  19      -5.554  35.317 -18.023  1.00 38.27           O  
ATOM    140  CB  ASP A  19      -4.355  36.327 -15.595  1.00 47.12           C  
ATOM    141  CG  ASP A  19      -4.249  37.849 -15.560  1.00 52.30           C  
ATOM    142  OD1 ASP A  19      -5.202  38.528 -16.018  1.00 49.70           O  
ATOM    143  OD2 ASP A  19      -3.255  38.448 -15.066  1.00 59.69           O  
ATOM    144  N   ASN A  20      -6.371  33.654 -16.711  1.00 36.54           N  
ATOM    145  CA  ASN A  20      -6.590  32.768 -17.841  1.00 32.03           C  
ATOM    146  C   ASN A  20      -8.010  32.315 -17.924  1.00 35.14           C  
ATOM    147  O   ASN A  20      -8.298  31.222 -18.445  1.00 35.62           O  
ATOM    148  CB  ASN A  20      -5.661  31.570 -17.795  1.00 34.59           C  
ATOM    149  CG  ASN A  20      -4.262  31.928 -18.197  1.00 40.28           C  
ATOM    150  OD1 ASN A  20      -3.383  31.080 -18.227  1.00 43.24           O  
ATOM    151  ND2 ASN A  20      -4.037  33.213 -18.496  1.00 47.18           N  
ATOM    152  N   GLU A  21      -8.911  33.138 -17.404  1.00 31.86           N  
ATOM    153  CA  GLU A  21     -10.308  32.777 -17.506  1.00 31.45           C  
ATOM    154  C   GLU A  21     -10.700  32.615 -18.983  1.00 30.77           C  
ATOM    155  O   GLU A  21     -10.202  33.349 -19.835  1.00 31.41           O  
ATOM    156  CB  GLU A  21     -11.156  33.778 -16.766  1.00 30.78           C  
ATOM    157  CG  GLU A  21     -11.004  33.638 -15.265  1.00 27.10           C  
ATOM    158  CD  GLU A  21     -11.629  34.798 -14.550  1.00 31.75           C  
ATOM    159  OE1 GLU A  21     -12.733  35.206 -14.944  1.00 38.15           O  
ATOM    160  OE2 GLU A  21     -10.993  35.341 -13.618  1.00 44.49           O  
ATOM    161  N   GLY A  22     -11.518  31.606 -19.291  1.00 27.92           N  
ATOM    162  CA  GLY A  22     -11.857  31.328 -20.673  1.00 29.22           C  
ATOM    163  C   GLY A  22     -11.117  30.131 -21.231  1.00 30.62           C  
ATOM    164  O   GLY A  22     -11.489  29.551 -22.274  1.00 30.73           O  
ATOM    165  N   ILE A  23     -10.052  29.755 -20.541  1.00 31.05           N  
ATOM    166  CA  ILE A  23      -9.166  28.711 -21.032  1.00 30.29           C  
ATOM    167  C   ILE A  23      -9.946  27.401 -21.040  1.00 28.66           C  
ATOM    168  O   ILE A  23     -10.680  27.110 -20.098  1.00 25.33           O  
ATOM    169  CB  ILE A  23      -7.891  28.631 -20.157  1.00 27.25           C  
ATOM    170  CG1 ILE A  23      -6.906  27.595 -20.719  1.00 29.79           C  
ATOM    171  CG2 ILE A  23      -8.244  28.322 -18.694  1.00 30.70           C  
ATOM    172  CD1 ILE A  23      -5.407  28.016 -20.652  1.00 20.18           C  
ATOM    173  N   ALA A  24      -9.829  26.641 -22.119  1.00 26.98           N  
ATOM    174  CA  ALA A  24     -10.337  25.283 -22.087  1.00 23.53           C  
ATOM    175  C   ALA A  24      -9.583  24.530 -20.988  1.00 24.52           C  
ATOM    176  O   ALA A  24      -8.353  24.566 -20.916  1.00 24.72           O  
ATOM    177  CB  ALA A  24     -10.157  24.598 -23.426  1.00 19.28           C  
ATOM    178  N   THR A  25     -10.351  23.878 -20.117  1.00 25.62           N  
ATOM    179  CA  THR A  25      -9.868  23.058 -19.012  1.00 23.07           C  
ATOM    180  C   THR A  25      -8.587  22.261 -19.320  1.00 24.21           C  
ATOM    181  O   THR A  25      -7.604  22.373 -18.597  1.00 26.25           O  
ATOM    182  CB  THR A  25     -11.021  22.146 -18.574  1.00 26.78           C  
ATOM    183  OG1 THR A  25     -12.139  22.949 -18.139  1.00 25.40           O  
ATOM    184  CG2 THR A  25     -10.630  21.296 -17.369  1.00 29.47           C  
ATOM    185  N   TYR A  26      -8.569  21.501 -20.395  1.00 24.61           N  
ATOM    186  CA  TYR A  26      -7.368  20.737 -20.713  1.00 25.77           C  
ATOM    187  C   TYR A  26      -6.158  21.612 -21.060  1.00 26.16           C  
ATOM    188  O   TYR A  26      -5.011  21.245 -20.752  1.00 23.38           O  
ATOM    189  CB  TYR A  26      -7.602  19.658 -21.787  1.00 26.58           C  
ATOM    190  CG  TYR A  26      -6.398  18.782 -21.959  1.00 28.79           C  
ATOM    191  CD1 TYR A  26      -6.094  17.781 -21.021  1.00 29.48           C  
ATOM    192  CD2 TYR A  26      -5.535  18.970 -23.035  1.00 29.66           C  
ATOM    193  CE1 TYR A  26      -4.967  16.968 -21.170  1.00 29.33           C  
ATOM    194  CE2 TYR A  26      -4.406  18.174 -23.195  1.00 32.26           C  
ATOM    195  CZ  TYR A  26      -4.121  17.178 -22.258  1.00 34.94           C  
ATOM    196  OH  TYR A  26      -3.005  16.382 -22.442  1.00 38.53           O  
ATOM    197  N   ASP A  27      -6.394  22.757 -21.687  1.00 24.66           N  
ATOM    198  CA  ASP A  27      -5.270  23.669 -21.880  1.00 27.73           C  
ATOM    199  C   ASP A  27      -4.745  24.195 -20.572  1.00 27.91           C  
ATOM    200  O   ASP A  27      -3.538  24.422 -20.457  1.00 31.49           O  
ATOM    201  CB  ASP A  27      -5.581  24.830 -22.813  1.00 23.74           C  
ATOM    202  CG  ASP A  27      -5.732  24.367 -24.223  1.00 31.69           C  
ATOM    203  OD1 ASP A  27      -5.147  23.288 -24.510  1.00 30.83           O  
ATOM    204  OD2 ASP A  27      -6.443  24.962 -25.079  1.00 30.57           O  
ATOM    205  N   LEU A  28      -5.633  24.405 -19.592  1.00 26.93           N  
ATOM    206  CA  LEU A  28      -5.166  24.837 -18.282  1.00 25.25           C  
ATOM    207  C   LEU A  28      -4.304  23.730 -17.714  1.00 26.59           C  
ATOM    208  O   LEU A  28      -3.253  23.994 -17.167  1.00 24.98           O  
ATOM    209  CB  LEU A  28      -6.296  25.189 -17.319  1.00 26.75           C  
ATOM    210  CG  LEU A  28      -5.788  25.589 -15.910  1.00 27.71           C  
ATOM    211  CD1 LEU A  28      -5.068  26.969 -15.912  1.00 22.59           C  
ATOM    212  CD2 LEU A  28      -6.843  25.534 -14.780  1.00 19.34           C  
ATOM    213  N   TYR A  29      -4.725  22.489 -17.892  1.00 26.22           N  
ATOM    214  CA  TYR A  29      -3.881  21.411 -17.510  1.00 23.82           C  
ATOM    215  C   TYR A  29      -2.490  21.454 -18.159  1.00 28.48           C  
ATOM    216  O   TYR A  29      -1.494  21.275 -17.452  1.00 30.90           O  
ATOM    217  CB  TYR A  29      -4.514  20.088 -17.844  1.00 23.06           C  
ATOM    218  CG  TYR A  29      -3.511  18.992 -17.615  1.00 21.55           C  
ATOM    219  CD1 TYR A  29      -3.000  18.751 -16.340  1.00 21.83           C  
ATOM    220  CD2 TYR A  29      -3.009  18.265 -18.657  1.00 18.59           C  
ATOM    221  CE1 TYR A  29      -2.087  17.767 -16.124  1.00 19.43           C  
ATOM    222  CE2 TYR A  29      -2.096  17.246 -18.446  1.00 16.83           C  
ATOM    223  CZ  TYR A  29      -1.643  17.018 -17.182  1.00 16.80           C  
ATOM    224  OH  TYR A  29      -0.713  16.068 -16.960  1.00 12.24           O  
ATOM    225  N   LYS A  30      -2.408  21.643 -19.480  1.00 26.13           N  
ATOM    226  CA  LYS A  30      -1.106  21.687 -20.142  1.00 24.34           C  
ATOM    227  C   LYS A  30      -0.180  22.730 -19.531  1.00 26.41           C  
ATOM    228  O   LYS A  30       1.000  22.484 -19.297  1.00 33.34           O  
ATOM    229  CB  LYS A  30      -1.255  21.967 -21.604  1.00 18.12           C  
ATOM    230  CG  LYS A  30      -1.666  20.765 -22.364  1.00 17.78           C  
ATOM    231  CD  LYS A  30      -2.262  21.202 -23.654  1.00 23.18           C  
ATOM    232  CE  LYS A  30      -1.289  20.826 -24.767  1.00 35.70           C  
ATOM    233  NZ  LYS A  30      -1.319  21.770 -25.926  1.00 39.65           N  
ATOM    234  N   LYS A  31      -0.735  23.878 -19.240  1.00 22.98           N  
ATOM    235  CA  LYS A  31       0.003  25.011 -18.736  1.00 25.97           C  
ATOM    236  C   LYS A  31       0.566  24.744 -17.326  1.00 29.06           C  
ATOM    237  O   LYS A  31       1.748  24.978 -17.065  1.00 28.58           O  
ATOM    238  CB  LYS A  31      -0.979  26.165 -18.654  1.00 27.44           C  
ATOM    239  CG  LYS A  31      -0.376  27.499 -18.568  1.00 36.29           C  
ATOM    240  CD  LYS A  31      -1.439  28.547 -18.879  1.00 40.66           C  
ATOM    241  CE  LYS A  31      -1.673  28.676 -20.372  1.00 42.30           C  
ATOM    242  NZ  LYS A  31      -0.674  29.584 -20.985  1.00 42.30           N  
ATOM    243  N   VAL A  32      -0.308  24.290 -16.429  1.00 26.13           N  
ATOM    244  CA  VAL A  32       0.035  23.962 -15.062  1.00 23.50           C  
ATOM    245  C   VAL A  32       1.153  22.932 -15.124  1.00 28.20           C  
ATOM    246  O   VAL A  32       2.245  23.102 -14.536  1.00 30.50           O  
ATOM    247  CB  VAL A  32      -1.205  23.403 -14.287  1.00 22.18           C  
ATOM    248  CG1 VAL A  32      -0.816  22.635 -13.052  1.00 20.78           C  
ATOM    249  CG2 VAL A  32      -2.144  24.543 -13.882  1.00 22.34           C  
ATOM    250  N   ASN A  33       0.899  21.875 -15.880  1.00 27.05           N  
ATOM    251  CA  ASN A  33       1.811  20.776 -15.952  1.00 24.60           C  
ATOM    252  C   ASN A  33       3.225  21.121 -16.479  1.00 24.85           C  
ATOM    253  O   ASN A  33       4.224  20.549 -16.022  1.00 26.12           O  
ATOM    254  CB  ASN A  33       1.151  19.688 -16.743  1.00 19.03           C  
ATOM    255  CG  ASN A  33       2.026  18.515 -16.874  1.00 20.82           C  
ATOM    256  OD1 ASN A  33       2.248  17.779 -15.911  1.00 24.40           O  
ATOM    257  ND2 ASN A  33       2.605  18.358 -18.053  1.00 17.06           N  
ATOM    258  N   ALA A  34       3.279  22.062 -17.423  1.00 23.06           N  
ATOM    259  CA  ALA A  34       4.513  22.655 -17.963  1.00 22.15           C  
ATOM    260  C   ALA A  34       5.410  23.287 -16.892  1.00 26.81           C  
ATOM    261  O   ALA A  34       6.580  23.520 -17.157  1.00 32.54           O  
ATOM    262  CB  ALA A  34       4.168  23.720 -19.036  1.00 14.40           C  
ATOM    263  N   GLU A  35       4.873  23.565 -15.701  1.00 25.30           N  
ATOM    264  CA  GLU A  35       5.630  24.235 -14.645  1.00 28.39           C  
ATOM    265  C   GLU A  35       5.669  23.461 -13.345  1.00 29.05           C  
ATOM    266  O   GLU A  35       6.648  23.499 -12.634  1.00 33.58           O  
ATOM    267  CB  GLU A  35       4.971  25.560 -14.310  1.00 29.11           C  
ATOM    268  CG  GLU A  35       4.900  26.527 -15.462  1.00 34.29           C  
ATOM    269  CD  GLU A  35       5.642  27.809 -15.190  1.00 31.97           C  
ATOM    270  OE1 GLU A  35       6.415  27.867 -14.209  1.00 50.80           O  
ATOM    271  OE2 GLU A  35       5.479  28.757 -15.966  1.00 34.62           O  
ATOM    272  N   PHE A  36       4.560  22.818 -13.021  1.00 29.17           N  
ATOM    273  CA  PHE A  36       4.406  22.030 -11.832  1.00 23.90           C  
ATOM    274  C   PHE A  36       3.837  20.677 -12.228  1.00 25.82           C  
ATOM    275  O   PHE A  36       2.632  20.455 -12.070  1.00 26.92           O  
ATOM    276  CB  PHE A  36       3.401  22.729 -10.948  1.00 24.43           C  
ATOM    277  CG  PHE A  36       3.948  23.920 -10.285  1.00 28.56           C  
ATOM    278  CD1 PHE A  36       3.666  25.185 -10.777  1.00 26.12           C  
ATOM    279  CD2 PHE A  36       4.779  23.787  -9.166  1.00 24.28           C  
ATOM    280  CE1 PHE A  36       4.185  26.298 -10.165  1.00 23.02           C  
ATOM    281  CE2 PHE A  36       5.308  24.890  -8.557  1.00 23.16           C  
ATOM    282  CZ  PHE A  36       5.008  26.166  -9.055  1.00 23.67           C  
ATOM    283  N   PRO A  37       4.665  19.766 -12.742  1.00 27.30           N  
ATOM    284  CA  PRO A  37       4.152  18.481 -13.303  1.00 29.18           C  
ATOM    285  C   PRO A  37       3.153  17.763 -12.382  1.00 29.31           C  
ATOM    286  O   PRO A  37       3.421  17.552 -11.196  1.00 32.21           O  
ATOM    287  CB  PRO A  37       5.399  17.621 -13.440  1.00 20.15           C  
ATOM    288  CG  PRO A  37       6.497  18.634 -13.607  1.00 26.47           C  
ATOM    289  CD  PRO A  37       6.134  19.853 -12.787  1.00 20.30           C  
HETATM  290  N   MSE A  38       1.974  17.464 -12.899  1.00 29.51           N  
HETATM  291  CA  MSE A  38       1.076  16.599 -12.170  1.00 26.53           C  
HETATM  292  C   MSE A  38       0.356  15.710 -13.157  1.00 27.68           C  
HETATM  293  O   MSE A  38       0.440  15.904 -14.387  1.00 27.23           O  
HETATM  294  CB  MSE A  38       0.129  17.394 -11.289  1.00 21.05           C  
HETATM  295  CG  MSE A  38      -1.143  17.821 -11.940  1.00 32.83           C  
HETATM  296 SE   MSE A  38      -1.790  19.531 -11.234  1.00 41.69          SE  
HETATM  297  CE  MSE A  38      -3.386  19.101 -10.311  1.00 47.90           C  
ATOM    298  N   SER A  39      -0.324  14.694 -12.645  1.00 26.48           N  
ATOM    299  CA  SER A  39      -1.044  13.837 -13.562  1.00 18.45           C  
ATOM    300  C   SER A  39      -2.395  14.484 -13.839  1.00 23.72           C  
ATOM    301  O   SER A  39      -2.809  15.460 -13.135  1.00 23.14           O  
ATOM    302  CB  SER A  39      -1.197  12.464 -12.970  1.00 12.70           C  
ATOM    303  OG  SER A  39      -2.083  12.446 -11.871  1.00 13.48           O  
ATOM    304  N   THR A  40      -3.063  13.956 -14.861  1.00 20.81           N  
ATOM    305  CA  THR A  40      -4.426  14.351 -15.193  1.00 23.95           C  
ATOM    306  C   THR A  40      -5.361  13.888 -14.074  1.00 24.05           C  
ATOM    307  O   THR A  40      -6.244  14.632 -13.669  1.00 29.02           O  
ATOM    308  CB  THR A  40      -4.868  13.731 -16.513  1.00 24.11           C  
ATOM    309  OG1 THR A  40      -4.794  12.295 -16.382  1.00 27.68           O  
ATOM    310  CG2 THR A  40      -3.900  14.114 -17.693  1.00 13.36           C  
ATOM    311  N   ALA A  41      -5.169  12.674 -13.564  1.00 23.04           N  
ATOM    312  CA  ALA A  41      -5.902  12.280 -12.363  1.00 22.22           C  
ATOM    313  C   ALA A  41      -5.747  13.398 -11.304  1.00 23.59           C  
ATOM    314  O   ALA A  41      -6.744  14.029 -10.900  1.00 26.47           O  
ATOM    315  CB  ALA A  41      -5.440  10.911 -11.813  1.00 10.62           C  
ATOM    316  N   THR A  42      -4.518  13.680 -10.853  1.00 25.22           N  
ATOM    317  CA  THR A  42      -4.411  14.701  -9.844  1.00 19.29           C  
ATOM    318  C   THR A  42      -5.003  16.063 -10.310  1.00 24.02           C  
ATOM    319  O   THR A  42      -5.728  16.685  -9.539  1.00 26.98           O  
ATOM    320  CB  THR A  42      -3.036  14.732  -8.987  1.00 20.27           C  
ATOM    321  OG1 THR A  42      -2.538  16.092  -8.848  1.00 21.62           O  
ATOM    322  CG2 THR A  42      -1.847  13.854  -9.494  1.00  4.89           C  
ATOM    323  N   PHE A  43      -4.782  16.478 -11.571  1.00 24.91           N  
ATOM    324  CA  PHE A  43      -5.332  17.782 -12.040  1.00 25.19           C  
ATOM    325  C   PHE A  43      -6.842  17.859 -11.976  1.00 26.65           C  
ATOM    326  O   PHE A  43      -7.374  18.852 -11.482  1.00 23.28           O  
ATOM    327  CB  PHE A  43      -4.855  18.172 -13.451  1.00 25.88           C  
ATOM    328  CG  PHE A  43      -5.558  19.383 -14.037  1.00 21.94           C  
ATOM    329  CD1 PHE A  43      -4.978  20.638 -13.974  1.00 20.25           C  
ATOM    330  CD2 PHE A  43      -6.812  19.253 -14.699  1.00 23.58           C  
ATOM    331  CE1 PHE A  43      -5.628  21.797 -14.525  1.00 20.29           C  
ATOM    332  CE2 PHE A  43      -7.492  20.405 -15.242  1.00 17.81           C  
ATOM    333  CZ  PHE A  43      -6.898  21.666 -15.164  1.00 16.85           C  
ATOM    334  N   TYR A  44      -7.517  16.820 -12.488  1.00 24.99           N  
ATOM    335  CA  TYR A  44      -8.987  16.772 -12.508  1.00 26.18           C  
ATOM    336  C   TYR A  44      -9.551  16.671 -11.101  1.00 24.28           C  
ATOM    337  O   TYR A  44     -10.570  17.281 -10.797  1.00 26.59           O  
ATOM    338  CB  TYR A  44      -9.560  15.727 -13.511  1.00 23.99           C  
ATOM    339  CG  TYR A  44      -9.580  16.321 -14.924  1.00 28.80           C  
ATOM    340  CD1 TYR A  44      -8.530  16.119 -15.808  1.00 31.82           C  
ATOM    341  CD2 TYR A  44     -10.606  17.150 -15.339  1.00 30.92           C  
ATOM    342  CE1 TYR A  44      -8.519  16.728 -17.093  1.00 31.29           C  
ATOM    343  CE2 TYR A  44     -10.613  17.730 -16.610  1.00 33.80           C  
ATOM    344  CZ  TYR A  44      -9.559  17.525 -17.476  1.00 31.72           C  
ATOM    345  OH  TYR A  44      -9.570  18.094 -18.729  1.00 36.10           O  
ATOM    346  N   ASP A  45      -8.848  15.987 -10.214  1.00 23.19           N  
ATOM    347  CA  ASP A  45      -9.288  15.959  -8.835  1.00 25.98           C  
ATOM    348  C   ASP A  45      -9.356  17.383  -8.296  1.00 26.97           C  
ATOM    349  O   ASP A  45     -10.333  17.769  -7.642  1.00 26.95           O  
ATOM    350  CB  ASP A  45      -8.348  15.120  -8.014  1.00 28.51           C  
ATOM    351  CG  ASP A  45      -8.886  13.758  -7.767  1.00 35.92           C  
ATOM    352  OD1 ASP A  45      -9.934  13.370  -8.375  1.00 35.68           O  
ATOM    353  OD2 ASP A  45      -8.315  12.993  -6.960  1.00 43.66           O  
ATOM    354  N   ALA A  46      -8.334  18.169  -8.619  1.00 19.75           N  
ATOM    355  CA  ALA A  46      -8.300  19.546  -8.222  1.00 21.35           C  
ATOM    356  C   ALA A  46      -9.413  20.383  -8.896  1.00 26.62           C  
ATOM    357  O   ALA A  46     -10.035  21.242  -8.238  1.00 30.64           O  
ATOM    358  CB  ALA A  46      -6.897  20.141  -8.481  1.00 18.14           C  
ATOM    359  N   LYS A  47      -9.683  20.150 -10.185  1.00 26.15           N  
ATOM    360  CA  LYS A  47     -10.753  20.920 -10.821  1.00 27.06           C  
ATOM    361  C   LYS A  47     -12.042  20.578 -10.069  1.00 25.50           C  
ATOM    362  O   LYS A  47     -12.770  21.480  -9.642  1.00 23.88           O  
ATOM    363  CB  LYS A  47     -10.833  20.696 -12.353  1.00 27.77           C  
ATOM    364  CG  LYS A  47     -12.022  21.346 -13.096  1.00 23.66           C  
ATOM    365  CD  LYS A  47     -12.553  20.386 -14.200  1.00 32.66           C  
ATOM    366  CE  LYS A  47     -13.936  19.744 -13.915  1.00 27.52           C  
ATOM    367  NZ  LYS A  47     -14.145  18.454 -14.647  1.00 34.62           N  
ATOM    368  N   LYS A  48     -12.271  19.285  -9.833  1.00 23.84           N  
ATOM    369  CA  LYS A  48     -13.471  18.843  -9.120  1.00 26.15           C  
ATOM    370  C   LYS A  48     -13.627  19.626  -7.809  1.00 27.51           C  
ATOM    371  O   LYS A  48     -14.685  20.202  -7.522  1.00 27.66           O  
ATOM    372  CB  LYS A  48     -13.413  17.352  -8.829  1.00 24.96           C  
ATOM    373  CG  LYS A  48     -14.750  16.610  -9.049  1.00 31.58           C  
ATOM    374  CD  LYS A  48     -15.196  15.813  -7.823  1.00 32.27           C  
ATOM    375  CE  LYS A  48     -15.679  14.401  -8.184  1.00 43.01           C  
ATOM    376  NZ  LYS A  48     -15.801  13.498  -6.968  1.00 45.72           N  
ATOM    377  N   PHE A  49     -12.545  19.679  -7.044  1.00 26.28           N  
ATOM    378  CA  PHE A  49     -12.603  20.251  -5.724  1.00 26.27           C  
ATOM    379  C   PHE A  49     -12.940  21.765  -5.782  1.00 24.48           C  
ATOM    380  O   PHE A  49     -13.860  22.221  -5.118  1.00 23.78           O  
ATOM    381  CB  PHE A  49     -11.302  19.926  -4.972  1.00 22.91           C  
ATOM    382  CG  PHE A  49     -11.147  20.657  -3.680  1.00 25.78           C  
ATOM    383  CD1 PHE A  49     -11.701  20.156  -2.512  1.00 18.27           C  
ATOM    384  CD2 PHE A  49     -10.438  21.863  -3.631  1.00 29.71           C  
ATOM    385  CE1 PHE A  49     -11.567  20.840  -1.311  1.00 21.90           C  
ATOM    386  CE2 PHE A  49     -10.300  22.568  -2.401  1.00 31.33           C  
ATOM    387  CZ  PHE A  49     -10.859  22.050  -1.247  1.00 24.78           C  
ATOM    388  N   LEU A  50     -12.229  22.523  -6.606  1.00 24.78           N  
ATOM    389  CA  LEU A  50     -12.439  23.963  -6.666  1.00 23.35           C  
ATOM    390  C   LEU A  50     -13.840  24.317  -7.173  1.00 26.22           C  
ATOM    391  O   LEU A  50     -14.412  25.337  -6.755  1.00 26.35           O  
ATOM    392  CB  LEU A  50     -11.384  24.612  -7.532  1.00 20.56           C  
ATOM    393  CG  LEU A  50      -9.922  24.249  -7.238  1.00 22.64           C  
ATOM    394  CD1 LEU A  50      -8.996  24.640  -8.431  1.00 15.14           C  
ATOM    395  CD2 LEU A  50      -9.479  24.936  -5.938  1.00 19.46           C  
ATOM    396  N   ILE A  51     -14.403  23.478  -8.054  1.00 24.70           N  
ATOM    397  CA  ILE A  51     -15.789  23.648  -8.449  1.00 24.36           C  
ATOM    398  C   ILE A  51     -16.671  23.370  -7.246  1.00 24.92           C  
ATOM    399  O   ILE A  51     -17.581  24.146  -6.963  1.00 27.80           O  
ATOM    400  CB  ILE A  51     -16.183  22.712  -9.618  1.00 23.97           C  
ATOM    401  CG1 ILE A  51     -15.842  23.336 -10.957  1.00 28.57           C  
ATOM    402  CG2 ILE A  51     -17.672  22.468  -9.644  1.00 19.07           C  
ATOM    403  CD1 ILE A  51     -15.548  22.327 -12.027  1.00 21.83           C  
ATOM    404  N   GLN A  52     -16.396  22.286  -6.527  1.00 24.38           N  
ATOM    405  CA  GLN A  52     -17.265  21.873  -5.428  1.00 27.56           C  
ATOM    406  C   GLN A  52     -17.245  22.839  -4.278  1.00 28.01           C  
ATOM    407  O   GLN A  52     -18.257  23.015  -3.610  1.00 28.94           O  
ATOM    408  CB  GLN A  52     -16.850  20.538  -4.868  1.00 29.44           C  
ATOM    409  CG  GLN A  52     -17.863  19.455  -5.097  1.00 38.71           C  
ATOM    410  CD  GLN A  52     -17.186  18.187  -5.569  1.00 44.75           C  
ATOM    411  OE1 GLN A  52     -16.097  17.841  -5.085  1.00 53.20           O  
ATOM    412  NE2 GLN A  52     -17.793  17.509  -6.526  1.00 40.51           N  
ATOM    413  N   GLU A  53     -16.079  23.436  -4.031  1.00 27.70           N  
ATOM    414  CA  GLU A  53     -15.921  24.416  -2.964  1.00 25.08           C  
ATOM    415  C   GLU A  53     -16.130  25.854  -3.434  1.00 25.75           C  
ATOM    416  O   GLU A  53     -15.855  26.804  -2.692  1.00 26.63           O  
ATOM    417  CB  GLU A  53     -14.577  24.266  -2.274  1.00 24.55           C  
ATOM    418  CG  GLU A  53     -14.401  22.937  -1.564  1.00 31.63           C  
ATOM    419  CD  GLU A  53     -15.479  22.623  -0.541  1.00 33.07           C  
ATOM    420  OE1 GLU A  53     -15.778  23.476   0.323  1.00 33.92           O  
ATOM    421  OE2 GLU A  53     -16.008  21.495  -0.597  1.00 34.15           O  
ATOM    422  N   GLY A  54     -16.608  26.012  -4.665  1.00 19.26           N  
ATOM    423  CA  GLY A  54     -17.135  27.286  -5.114  1.00 19.38           C  
ATOM    424  C   GLY A  54     -16.130  28.371  -5.457  1.00 23.80           C  
ATOM    425  O   GLY A  54     -16.467  29.567  -5.373  1.00 19.65           O  
ATOM    426  N   PHE A  55     -14.919  27.948  -5.840  1.00 21.09           N  
ATOM    427  CA  PHE A  55     -13.871  28.834  -6.313  1.00 17.72           C  
ATOM    428  C   PHE A  55     -13.840  28.985  -7.826  1.00 22.97           C  
ATOM    429  O   PHE A  55     -13.386  30.010  -8.320  1.00 23.58           O  
ATOM    430  CB  PHE A  55     -12.539  28.292  -5.910  1.00 12.95           C  
ATOM    431  CG  PHE A  55     -12.332  28.238  -4.437  1.00 18.35           C  
ATOM    432  CD1 PHE A  55     -12.436  27.037  -3.751  1.00 18.54           C  
ATOM    433  CD2 PHE A  55     -11.988  29.378  -3.727  1.00 22.19           C  
ATOM    434  CE1 PHE A  55     -12.208  26.960  -2.392  1.00 14.82           C  
ATOM    435  CE2 PHE A  55     -11.774  29.302  -2.353  1.00 23.36           C  
ATOM    436  CZ  PHE A  55     -11.882  28.080  -1.698  1.00 19.01           C  
ATOM    437  N   VAL A  56     -14.324  27.976  -8.558  1.00 24.19           N  
ATOM    438  CA  VAL A  56     -14.206  27.915 -10.020  1.00 19.64           C  
ATOM    439  C   VAL A  56     -15.531  27.484 -10.616  1.00 22.38           C  
ATOM    440  O   VAL A  56     -16.280  26.709 -10.000  1.00 21.00           O  
ATOM    441  CB  VAL A  56     -13.133  26.875 -10.411  1.00 19.57           C  
ATOM    442  CG1 VAL A  56     -13.169  26.506 -11.881  1.00 17.13           C  
ATOM    443  CG2 VAL A  56     -11.738  27.365 -10.020  1.00 24.15           C  
ATOM    444  N   LYS A  57     -15.824  27.982 -11.813  1.00 21.28           N  
ATOM    445  CA  LYS A  57     -16.994  27.522 -12.554  1.00 24.81           C  
ATOM    446  C   LYS A  57     -16.545  26.902 -13.869  1.00 25.54           C  
ATOM    447  O   LYS A  57     -15.638  27.405 -14.505  1.00 27.01           O  
ATOM    448  CB  LYS A  57     -18.002  28.662 -12.779  1.00 24.57           C  
ATOM    449  CG  LYS A  57     -19.102  28.732 -11.687  1.00 29.04           C  
ATOM    450  CD  LYS A  57     -19.736  30.156 -11.492  1.00 31.42           C  
ATOM    451  CE  LYS A  57     -20.780  30.202 -10.313  1.00 32.86           C  
ATOM    452  NZ  LYS A  57     -22.104  30.888 -10.618  1.00 34.30           N  
ATOM    453  N   GLU A  58     -17.150  25.790 -14.263  1.00 26.62           N  
ATOM    454  CA  GLU A  58     -16.855  25.249 -15.571  1.00 29.46           C  
ATOM    455  C   GLU A  58     -18.067  25.302 -16.498  1.00 31.80           C  
ATOM    456  O   GLU A  58     -19.099  24.706 -16.176  1.00 35.93           O  
ATOM    457  CB  GLU A  58     -16.360  23.815 -15.461  1.00 31.13           C  
ATOM    458  CG  GLU A  58     -16.012  23.180 -16.806  1.00 32.09           C  
ATOM    459  CD  GLU A  58     -15.362  21.840 -16.621  1.00 36.51           C  
ATOM    460  OE1 GLU A  58     -14.254  21.624 -17.179  1.00 40.53           O  
ATOM    461  OE2 GLU A  58     -15.960  21.020 -15.880  1.00 32.47           O  
ATOM    462  N   ARG A  59     -17.939  25.989 -17.644  1.00 30.94           N  
ATOM    463  CA  ARG A  59     -18.999  26.020 -18.678  1.00 24.88           C  
ATOM    464  C   ARG A  59     -18.580  25.384 -20.006  1.00 23.15           C  
ATOM    465  O   ARG A  59     -17.410  25.454 -20.406  1.00 24.10           O  
ATOM    466  CB  ARG A  59     -19.482  27.445 -18.946  1.00 26.56           C  
ATOM    467  CG  ARG A  59     -19.814  28.298 -17.703  1.00 35.69           C  
ATOM    468  CD  ARG A  59     -20.270  29.731 -18.036  1.00 39.16           C  
ATOM    469  NE  ARG A  59     -19.363  30.748 -17.502  1.00 39.15           N  
ATOM    470  CZ  ARG A  59     -19.355  32.032 -17.881  1.00 47.30           C  
ATOM    471  NH1 ARG A  59     -20.211  32.475 -18.805  1.00 47.25           N  
ATOM    472  NH2 ARG A  59     -18.494  32.887 -17.318  1.00 47.42           N  
ATOM    473  N   GLN A  60     -19.537  24.745 -20.680  1.00 22.53           N  
ATOM    474  CA  GLN A  60     -19.336  24.291 -22.057  1.00 24.84           C  
ATOM    475  C   GLN A  60     -19.683  25.467 -23.000  1.00 23.56           C  
ATOM    476  O   GLN A  60     -20.831  25.748 -23.267  1.00 25.68           O  
ATOM    477  CB  GLN A  60     -20.121  22.997 -22.353  1.00 23.81           C  
ATOM    478  CG  GLN A  60     -20.148  22.529 -23.819  1.00 26.99           C  
ATOM    479  CD  GLN A  60     -18.978  21.613 -24.231  1.00 34.53           C  
ATOM    480  OE1 GLN A  60     -18.475  20.791 -23.449  1.00 38.49           O  
ATOM    481  NE2 GLN A  60     -18.555  21.754 -25.477  1.00 35.53           N  
ATOM    482  N   GLU A  61     -18.655  26.176 -23.444  1.00 25.37           N  
ATOM    483  CA  GLU A  61     -18.803  27.341 -24.292  1.00 26.84           C  
ATOM    484  C   GLU A  61     -17.911  27.162 -25.515  1.00 30.58           C  
ATOM    485  O   GLU A  61     -16.810  26.592 -25.409  1.00 30.51           O  
ATOM    486  CB  GLU A  61     -18.353  28.584 -23.545  1.00 27.27           C  
ATOM    487  CG  GLU A  61     -19.463  29.330 -22.831  1.00 27.97           C  
ATOM    488  CD  GLU A  61     -18.908  30.418 -21.921  1.00 38.05           C  
ATOM    489  OE1 GLU A  61     -17.720  30.858 -22.102  1.00 33.32           O  
ATOM    490  OE2 GLU A  61     -19.670  30.821 -21.008  1.00 42.21           O  
ATOM    491  N   ARG A  62     -18.407  27.616 -26.674  1.00 31.66           N  
ATOM    492  CA  ARG A  62     -17.637  27.666 -27.926  1.00 30.35           C  
ATOM    493  C   ARG A  62     -16.914  26.309 -28.246  1.00 30.74           C  
ATOM    494  O   ARG A  62     -15.690  26.265 -28.486  1.00 29.38           O  
ATOM    495  CB  ARG A  62     -16.691  28.898 -27.897  1.00 28.71           C  
ATOM    496  CG  ARG A  62     -17.362  30.196 -27.406  1.00 23.99           C  
ATOM    497  CD  ARG A  62     -18.724  30.509 -28.091  1.00 31.75           C  
ATOM    498  NE  ARG A  62     -18.505  31.078 -29.426  1.00 32.03           N  
ATOM    499  CZ  ARG A  62     -19.278  30.917 -30.507  1.00 30.85           C  
ATOM    500  NH1 ARG A  62     -20.419  30.201 -30.485  1.00 26.91           N  
ATOM    501  NH2 ARG A  62     -18.894  31.511 -31.638  1.00 28.98           N  
ATOM    502  N   GLY A  63     -17.694  25.217 -28.222  1.00 26.95           N  
ATOM    503  CA  GLY A  63     -17.226  23.863 -28.511  1.00 21.53           C  
ATOM    504  C   GLY A  63     -16.129  23.291 -27.625  1.00 21.63           C  
ATOM    505  O   GLY A  63     -15.359  22.452 -28.093  1.00 20.83           O  
ATOM    506  N   GLU A  64     -16.085  23.729 -26.361  1.00 18.19           N  
ATOM    507  CA  GLU A  64     -15.100  23.315 -25.370  1.00 23.87           C  
ATOM    508  C   GLU A  64     -15.692  23.503 -23.957  1.00 26.45           C  
ATOM    509  O   GLU A  64     -16.628  24.294 -23.804  1.00 27.59           O  
ATOM    510  CB  GLU A  64     -13.849  24.205 -25.492  1.00 29.31           C  
ATOM    511  CG  GLU A  64     -12.534  23.575 -25.974  1.00 36.01           C  
ATOM    512  CD  GLU A  64     -12.651  22.146 -26.499  1.00 39.61           C  
ATOM    513  OE1 GLU A  64     -12.813  21.202 -25.665  1.00 43.86           O  
ATOM    514  OE2 GLU A  64     -12.541  21.969 -27.736  1.00 31.73           O  
ATOM    515  N   LYS A  65     -15.143  22.795 -22.949  1.00 22.63           N  
ATOM    516  CA  LYS A  65     -15.376  23.074 -21.522  1.00 20.65           C  
ATOM    517  C   LYS A  65     -14.295  24.043 -21.004  1.00 27.05           C  
ATOM    518  O   LYS A  65     -13.076  23.752 -21.082  1.00 25.35           O  
ATOM    519  CB  LYS A  65     -15.338  21.782 -20.697  1.00 20.90           C  
ATOM    520  CG  LYS A  65     -16.658  21.009 -20.635  1.00 28.19           C  
ATOM    521  CD  LYS A  65     -16.456  19.502 -20.634  1.00 27.04           C  
ATOM    522  CE  LYS A  65     -17.786  18.752 -20.805  1.00 33.86           C  
ATOM    523  NZ  LYS A  65     -17.713  17.400 -21.541  1.00 35.18           N  
ATOM    524  N   ARG A  66     -14.741  25.181 -20.463  1.00 25.94           N  
ATOM    525  CA  ARG A  66     -13.845  26.267 -20.049  1.00 24.15           C  
ATOM    526  C   ARG A  66     -14.032  26.626 -18.612  1.00 24.91           C  
ATOM    527  O   ARG A  66     -15.079  26.344 -18.049  1.00 26.32           O  
ATOM    528  CB  ARG A  66     -14.081  27.531 -20.881  1.00 21.71           C  
ATOM    529  CG  ARG A  66     -13.934  27.256 -22.355  1.00 24.91           C  
ATOM    530  CD  ARG A  66     -14.259  28.422 -23.266  1.00 24.00           C  
ATOM    531  NE  ARG A  66     -14.275  27.947 -24.643  1.00 24.92           N  
ATOM    532  CZ  ARG A  66     -13.202  27.552 -25.366  1.00 26.39           C  
ATOM    533  NH1 ARG A  66     -11.956  27.599 -24.900  1.00 23.45           N  
ATOM    534  NH2 ARG A  66     -13.386  27.129 -26.605  1.00 30.42           N  
ATOM    535  N   LEU A  67     -13.026  27.300 -18.056  1.00 23.09           N  
ATOM    536  CA  LEU A  67     -12.949  27.600 -16.639  1.00 26.68           C  
ATOM    537  C   LEU A  67     -13.002  29.085 -16.333  1.00 31.85           C  
ATOM    538  O   LEU A  67     -12.275  29.902 -16.937  1.00 38.84           O  
ATOM    539  CB  LEU A  67     -11.674  26.984 -16.031  1.00 24.91           C  
ATOM    540  CG  LEU A  67     -11.632  25.465 -16.244  1.00 27.70           C  
ATOM    541  CD1 LEU A  67     -10.293  24.939 -15.860  1.00 22.12           C  
ATOM    542  CD2 LEU A  67     -12.773  24.701 -15.503  1.00 25.27           C  
ATOM    543  N   TYR A  68     -13.859  29.443 -15.385  1.00 30.49           N  
ATOM    544  CA  TYR A  68     -13.927  30.819 -14.927  1.00 27.21           C  
ATOM    545  C   TYR A  68     -13.699  30.825 -13.449  1.00 29.83           C  
ATOM    546  O   TYR A  68     -13.810  29.789 -12.773  1.00 29.33           O  
ATOM    547  CB  TYR A  68     -15.241  31.482 -15.353  1.00 24.86           C  
ATOM    548  CG  TYR A  68     -15.378  31.401 -16.868  1.00 24.86           C  
ATOM    549  CD1 TYR A  68     -15.769  30.199 -17.467  1.00 24.34           C  
ATOM    550  CD2 TYR A  68     -15.017  32.478 -17.703  1.00 20.93           C  
ATOM    551  CE1 TYR A  68     -15.843  30.064 -18.847  1.00 28.33           C  
ATOM    552  CE2 TYR A  68     -15.086  32.358 -19.098  1.00 18.42           C  
ATOM    553  CZ  TYR A  68     -15.514  31.142 -19.667  1.00 27.71           C  
ATOM    554  OH  TYR A  68     -15.623  30.943 -21.043  1.00 31.73           O  
ATOM    555  N   LEU A  69     -13.302  31.992 -12.960  1.00 32.85           N  
ATOM    556  CA  LEU A  69     -13.061  32.175 -11.546  1.00 28.66           C  
ATOM    557  C   LEU A  69     -14.318  32.680 -10.930  1.00 29.66           C  
ATOM    558  O   LEU A  69     -15.191  33.233 -11.585  1.00 33.60           O  
ATOM    559  CB  LEU A  69     -11.933  33.154 -11.280  1.00 29.20           C  
ATOM    560  CG  LEU A  69     -10.538  32.548 -11.390  1.00 32.50           C  
ATOM    561  CD1 LEU A  69      -9.522  33.676 -11.298  1.00 35.31           C  
ATOM    562  CD2 LEU A  69     -10.314  31.519 -10.302  1.00 31.29           C  
ATOM    563  N   THR A  70     -14.406  32.472  -9.643  1.00 30.92           N  
ATOM    564  CA  THR A  70     -15.567  32.819  -8.906  1.00 27.53           C  
ATOM    565  C   THR A  70     -15.163  34.089  -8.181  1.00 32.88           C  
ATOM    566  O   THR A  70     -13.975  34.433  -8.173  1.00 41.28           O  
ATOM    567  CB  THR A  70     -15.802  31.633  -8.024  1.00 26.26           C  
ATOM    568  OG1 THR A  70     -17.141  31.183  -8.216  1.00 26.20           O  
ATOM    569  CG2 THR A  70     -15.592  31.922  -6.536  1.00 17.96           C  
ATOM    570  N   GLU A  71     -16.121  34.822  -7.622  1.00 31.96           N  
ATOM    571  CA  GLU A  71     -15.790  35.958  -6.774  1.00 29.76           C  
ATOM    572  C   GLU A  71     -14.720  35.592  -5.729  1.00 27.44           C  
ATOM    573  O   GLU A  71     -13.641  36.205  -5.691  1.00 28.11           O  
ATOM    574  CB  GLU A  71     -17.059  36.441  -6.109  1.00 31.56           C  
ATOM    575  CG  GLU A  71     -17.815  37.438  -6.957  1.00 38.18           C  
ATOM    576  CD  GLU A  71     -18.101  38.738  -6.210  1.00 43.58           C  
ATOM    577  OE1 GLU A  71     -17.343  39.094  -5.269  1.00 43.81           O  
ATOM    578  OE2 GLU A  71     -19.095  39.411  -6.562  1.00 41.91           O  
ATOM    579  N   LYS A  72     -15.007  34.565  -4.922  1.00 25.84           N  
ATOM    580  CA  LYS A  72     -14.054  34.060  -3.912  1.00 24.17           C  
ATOM    581  C   LYS A  72     -12.784  33.393  -4.503  1.00 27.89           C  
ATOM    582  O   LYS A  72     -11.719  33.406  -3.882  1.00 32.96           O  
ATOM    583  CB  LYS A  72     -14.768  33.226  -2.799  1.00 22.43           C  
ATOM    584  CG  LYS A  72     -14.608  31.702  -2.727  1.00 19.16           C  
ATOM    585  CD  LYS A  72     -15.907  31.063  -2.222  1.00 15.20           C  
ATOM    586  CE  LYS A  72     -15.762  29.582  -1.837  1.00 17.09           C  
ATOM    587  NZ  LYS A  72     -16.174  29.211  -0.433  1.00 16.17           N  
ATOM    588  N   GLY A  73     -12.897  32.841  -5.703  1.00 26.89           N  
ATOM    589  CA  GLY A  73     -11.736  32.315  -6.387  1.00 28.42           C  
ATOM    590  C   GLY A  73     -10.818  33.436  -6.837  1.00 29.96           C  
ATOM    591  O   GLY A  73      -9.596  33.327  -6.697  1.00 31.38           O  
ATOM    592  N   LYS A  74     -11.399  34.515  -7.379  1.00 30.78           N  
ATOM    593  CA  LYS A  74     -10.620  35.623  -7.924  1.00 30.11           C  
ATOM    594  C   LYS A  74      -9.802  36.221  -6.806  1.00 31.57           C  
ATOM    595  O   LYS A  74      -8.612  36.471  -6.988  1.00 33.30           O  
ATOM    596  CB  LYS A  74     -11.514  36.699  -8.552  1.00 33.38           C  
ATOM    597  CG  LYS A  74     -11.403  36.895 -10.097  1.00 33.65           C  
ATOM    598  CD  LYS A  74     -12.643  37.659 -10.641  1.00 33.30           C  
ATOM    599  CE  LYS A  74     -12.858  37.490 -12.152  1.00 35.64           C  
ATOM    600  NZ  LYS A  74     -14.282  37.122 -12.583  1.00 34.37           N  
ATOM    601  N   LEU A  75     -10.429  36.417  -5.645  1.00 30.32           N  
ATOM    602  CA  LEU A  75      -9.750  36.964  -4.475  1.00 31.34           C  
ATOM    603  C   LEU A  75      -8.602  36.084  -4.024  1.00 30.24           C  
ATOM    604  O   LEU A  75      -7.457  36.535  -3.917  1.00 34.54           O  
ATOM    605  CB  LEU A  75     -10.762  37.223  -3.359  1.00 32.93           C  
ATOM    606  CG  LEU A  75     -11.495  38.521  -3.759  1.00 37.19           C  
ATOM    607  CD1 LEU A  75     -12.934  38.667  -3.214  1.00 32.05           C  
ATOM    608  CD2 LEU A  75     -10.601  39.775  -3.471  1.00 37.41           C  
ATOM    609  N   PHE A  76      -8.883  34.810  -3.820  1.00 26.57           N  
ATOM    610  CA  PHE A  76      -7.853  33.860  -3.374  1.00 27.86           C  
ATOM    611  C   PHE A  76      -6.738  33.615  -4.391  1.00 30.36           C  
ATOM    612  O   PHE A  76      -5.557  33.657  -4.036  1.00 34.70           O  
ATOM    613  CB  PHE A  76      -8.504  32.533  -3.022  1.00 28.85           C  
ATOM    614  CG  PHE A  76      -7.676  31.656  -2.131  1.00 31.12           C  
ATOM    615  CD1 PHE A  76      -6.652  32.187  -1.344  1.00 30.65           C  
ATOM    616  CD2 PHE A  76      -7.951  30.281  -2.054  1.00 29.57           C  
ATOM    617  CE1 PHE A  76      -5.876  31.339  -0.513  1.00 33.51           C  
ATOM    618  CE2 PHE A  76      -7.200  29.431  -1.224  1.00 31.54           C  
ATOM    619  CZ  PHE A  76      -6.159  29.963  -0.456  1.00 33.04           C  
ATOM    620  N   ALA A  77      -7.111  33.340  -5.642  1.00 29.24           N  
ATOM    621  CA  ALA A  77      -6.146  33.115  -6.711  1.00 26.84           C  
ATOM    622  C   ALA A  77      -4.992  34.158  -6.697  1.00 25.15           C  
ATOM    623  O   ALA A  77      -3.827  33.790  -6.856  1.00 24.65           O  
ATOM    624  CB  ALA A  77      -6.862  33.083  -8.072  1.00 24.05           C  
ATOM    625  N   ILE A  78      -5.319  35.433  -6.460  1.00 25.74           N  
ATOM    626  CA  ILE A  78      -4.305  36.506  -6.479  1.00 24.84           C  
ATOM    627  C   ILE A  78      -3.241  36.274  -5.414  1.00 25.20           C  
ATOM    628  O   ILE A  78      -2.043  36.328  -5.721  1.00 29.03           O  
ATOM    629  CB  ILE A  78      -4.929  37.879  -6.258  1.00 23.02           C  
ATOM    630  CG1 ILE A  78      -5.853  38.268  -7.421  1.00 27.61           C  
ATOM    631  CG2 ILE A  78      -3.848  38.929  -5.994  1.00 24.65           C  
ATOM    632  CD1 ILE A  78      -6.932  39.351  -6.994  1.00 23.54           C  
ATOM    633  N   SER A  79      -3.671  36.012  -4.181  1.00 23.53           N  
ATOM    634  CA  SER A  79      -2.711  35.808  -3.122  1.00 23.06           C  
ATOM    635  C   SER A  79      -1.958  34.478  -3.255  1.00 25.08           C  
ATOM    636  O   SER A  79      -0.807  34.374  -2.855  1.00 32.37           O  
ATOM    637  CB  SER A  79      -3.356  35.936  -1.759  1.00 23.02           C  
ATOM    638  OG  SER A  79      -4.419  35.020  -1.627  1.00 37.01           O  
ATOM    639  N   LEU A  80      -2.597  33.449  -3.793  1.00 23.17           N  
ATOM    640  CA  LEU A  80      -1.861  32.226  -4.117  1.00 23.55           C  
ATOM    641  C   LEU A  80      -0.806  32.455  -5.209  1.00 26.27           C  
ATOM    642  O   LEU A  80       0.296  31.929  -5.101  1.00 31.86           O  
ATOM    643  CB  LEU A  80      -2.801  31.104  -4.551  1.00 21.72           C  
ATOM    644  CG  LEU A  80      -3.756  30.446  -3.526  1.00 27.53           C  
ATOM    645  CD1 LEU A  80      -4.808  29.499  -4.202  1.00 25.26           C  
ATOM    646  CD2 LEU A  80      -3.009  29.751  -2.331  1.00 17.59           C  
ATOM    647  N   LYS A  81      -1.152  33.214  -6.255  1.00 29.15           N  
ATOM    648  CA  LYS A  81      -0.253  33.467  -7.386  1.00 30.50           C  
ATOM    649  C   LYS A  81       1.051  34.071  -6.886  1.00 28.98           C  
ATOM    650  O   LYS A  81       2.146  33.684  -7.342  1.00 30.25           O  
ATOM    651  CB  LYS A  81      -0.911  34.426  -8.399  1.00 30.97           C  
ATOM    652  CG  LYS A  81      -0.092  34.750  -9.659  1.00 40.79           C  
ATOM    653  CD  LYS A  81      -0.392  33.836 -10.897  1.00 51.70           C  
ATOM    654  CE  LYS A  81       0.506  32.484 -10.943  1.00 50.91           C  
ATOM    655  NZ  LYS A  81       1.076  32.027 -12.288  1.00 42.61           N  
ATOM    656  N   THR A  82       0.912  35.021  -5.959  1.00 25.80           N  
ATOM    657  CA  THR A  82       2.016  35.791  -5.402  1.00 26.33           C  
ATOM    658  C   THR A  82       2.961  34.855  -4.601  1.00 27.50           C  
ATOM    659  O   THR A  82       4.166  34.876  -4.792  1.00 27.84           O  
ATOM    660  CB  THR A  82       1.442  37.102  -4.607  1.00 25.68           C  
ATOM    661  OG1 THR A  82       2.447  37.751  -3.830  1.00 33.43           O  
ATOM    662  CG2 THR A  82       0.506  36.790  -3.521  1.00 25.33           C  
ATOM    663  N   ALA A  83       2.376  34.003  -3.760  1.00 24.30           N  
ATOM    664  CA  ALA A  83       3.064  32.913  -3.095  1.00 22.83           C  
ATOM    665  C   ALA A  83       3.821  31.931  -4.045  1.00 23.23           C  
ATOM    666  O   ALA A  83       5.049  31.779  -3.915  1.00 23.15           O  
ATOM    667  CB  ALA A  83       2.103  32.183  -2.187  1.00 17.13           C  
ATOM    668  N   ILE A  84       3.122  31.293  -4.996  1.00 21.18           N  
ATOM    669  CA  ILE A  84       3.769  30.393  -5.980  1.00 22.97           C  
ATOM    670  C   ILE A  84       4.838  31.097  -6.814  1.00 25.84           C  
ATOM    671  O   ILE A  84       5.937  30.564  -7.057  1.00 27.36           O  
ATOM    672  CB  ILE A  84       2.728  29.773  -6.916  1.00 28.63           C  
ATOM    673  CG1 ILE A  84       1.850  28.788  -6.136  1.00 29.18           C  
ATOM    674  CG2 ILE A  84       3.408  29.095  -8.120  1.00 23.02           C  
ATOM    675  CD1 ILE A  84       0.440  28.776  -6.568  1.00 32.75           C  
ATOM    676  N   GLU A  85       4.521  32.306  -7.238  1.00 23.45           N  
ATOM    677  CA  GLU A  85       5.463  33.082  -7.997  1.00 23.55           C  
ATOM    678  C   GLU A  85       6.743  33.379  -7.226  1.00 24.58           C  
ATOM    679  O   GLU A  85       7.840  33.352  -7.807  1.00 23.57           O  
ATOM    680  CB  GLU A  85       4.790  34.349  -8.449  1.00 17.61           C  
ATOM    681  CG  GLU A  85       5.420  34.884  -9.693  1.00 29.68           C  
ATOM    682  CD  GLU A  85       5.052  34.066 -10.935  1.00 40.90           C  
ATOM    683  OE1 GLU A  85       3.978  33.360 -10.910  1.00 37.81           O  
ATOM    684  OE2 GLU A  85       5.852  34.152 -11.932  1.00 42.88           O  
ATOM    685  N   THR A  86       6.590  33.673  -5.926  1.00 21.45           N  
ATOM    686  CA  THR A  86       7.703  34.009  -5.082  1.00 20.36           C  
ATOM    687  C   THR A  86       8.482  32.724  -4.917  1.00 20.56           C  
ATOM    688  O   THR A  86       9.702  32.721  -4.984  1.00 20.72           O  
ATOM    689  CB  THR A  86       7.188  34.523  -3.710  1.00 25.13           C  
ATOM    690  OG1 THR A  86       6.432  35.724  -3.902  1.00 24.61           O  
ATOM    691  CG2 THR A  86       8.361  34.936  -2.769  1.00 15.05           C  
ATOM    692  N   TYR A  87       7.754  31.630  -4.710  1.00 19.57           N  
ATOM    693  CA  TYR A  87       8.367  30.301  -4.676  1.00 23.58           C  
ATOM    694  C   TYR A  87       9.244  30.012  -5.891  1.00 25.58           C  
ATOM    695  O   TYR A  87      10.432  29.705  -5.709  1.00 21.65           O  
ATOM    696  CB  TYR A  87       7.332  29.193  -4.613  1.00 25.03           C  
ATOM    697  CG  TYR A  87       7.954  27.831  -4.396  1.00 28.57           C  
ATOM    698  CD1 TYR A  87       8.990  27.667  -3.476  1.00 30.69           C  
ATOM    699  CD2 TYR A  87       7.517  26.708  -5.109  1.00 25.78           C  
ATOM    700  CE1 TYR A  87       9.575  26.441  -3.261  1.00 30.12           C  
ATOM    701  CE2 TYR A  87       8.104  25.470  -4.897  1.00 28.33           C  
ATOM    702  CZ  TYR A  87       9.132  25.343  -3.973  1.00 30.31           C  
ATOM    703  OH  TYR A  87       9.711  24.121  -3.714  1.00 31.18           O  
ATOM    704  N   LYS A  88       8.652  30.090  -7.101  1.00 20.06           N  
ATOM    705  CA  LYS A  88       9.391  29.974  -8.344  1.00 21.18           C  
ATOM    706  C   LYS A  88      10.653  30.811  -8.352  1.00 22.05           C  
ATOM    707  O   LYS A  88      11.714  30.299  -8.664  1.00 24.42           O  
ATOM    708  CB  LYS A  88       8.543  30.442  -9.476  1.00 26.86           C  
ATOM    709  CG  LYS A  88       7.584  29.455 -10.069  1.00 29.23           C  
ATOM    710  CD  LYS A  88       7.034  30.051 -11.396  1.00 36.27           C  
ATOM    711  CE  LYS A  88       5.508  29.745 -11.533  1.00 50.39           C  
ATOM    712  NZ  LYS A  88       4.499  30.880 -11.753  1.00 50.52           N  
ATOM    713  N   GLN A  89      10.576  32.087  -7.965  1.00 25.42           N  
ATOM    714  CA  GLN A  89      11.773  32.951  -7.959  1.00 23.50           C  
ATOM    715  C   GLN A  89      12.772  32.579  -6.917  1.00 23.73           C  
ATOM    716  O   GLN A  89      13.940  32.920  -7.038  1.00 27.21           O  
ATOM    717  CB  GLN A  89      11.418  34.432  -7.798  1.00 23.15           C  
ATOM    718  CG  GLN A  89      10.752  35.010  -9.009  1.00 32.74           C  
ATOM    719  CD  GLN A  89      11.576  34.787 -10.308  1.00 36.51           C  
ATOM    720  OE1 GLN A  89      12.758  35.189 -10.380  1.00 38.99           O  
ATOM    721  NE2 GLN A  89      10.967  34.140 -11.299  1.00 23.93           N  
ATOM    722  N   ILE A  90      12.315  31.930  -5.852  1.00 27.68           N  
ATOM    723  CA  ILE A  90      13.213  31.511  -4.779  1.00 30.14           C  
ATOM    724  C   ILE A  90      14.003  30.280  -5.280  1.00 29.72           C  
ATOM    725  O   ILE A  90      15.233  30.264  -5.232  1.00 26.19           O  
ATOM    726  CB  ILE A  90      12.396  31.279  -3.475  1.00 30.50           C  
ATOM    727  CG1 ILE A  90      12.405  32.542  -2.617  1.00 27.89           C  
ATOM    728  CG2 ILE A  90      12.920  30.099  -2.691  1.00 33.53           C  
ATOM    729  CD1 ILE A  90      11.412  32.491  -1.486  1.00 33.10           C  
ATOM    730  N   LYS A  91      13.278  29.293  -5.812  1.00 29.14           N  
ATOM    731  CA  LYS A  91      13.882  28.185  -6.536  1.00 27.71           C  
ATOM    732  C   LYS A  91      14.904  28.733  -7.566  1.00 28.68           C  
ATOM    733  O   LYS A  91      16.108  28.567  -7.343  1.00 32.47           O  
ATOM    734  CB  LYS A  91      12.825  27.198  -7.090  1.00 23.06           C  
ATOM    735  CG  LYS A  91      11.922  26.595  -6.003  1.00 27.93           C  
ATOM    736  CD  LYS A  91      12.467  25.280  -5.366  1.00 35.79           C  
ATOM    737  CE  LYS A  91      13.019  25.372  -3.859  1.00 43.07           C  
ATOM    738  NZ  LYS A  91      12.685  24.239  -2.845  1.00 34.69           N  
ATOM    739  N   LYS A  92      14.496  29.474  -8.604  1.00 28.09           N  
ATOM    740  CA  LYS A  92      15.509  30.071  -9.510  1.00 31.22           C  
ATOM    741  C   LYS A  92      16.712  30.708  -8.811  1.00 29.54           C  
ATOM    742  O   LYS A  92      17.833  30.327  -9.089  1.00 33.74           O  
ATOM    743  CB  LYS A  92      14.909  31.039 -10.547  1.00 40.63           C  
ATOM    744  CG  LYS A  92      15.953  32.081 -11.152  1.00 43.68           C  
ATOM    745  CD  LYS A  92      15.617  32.534 -12.606  1.00 48.64           C  
ATOM    746  CE  LYS A  92      14.258  31.989 -13.111  1.00 51.63           C  
ATOM    747  NZ  LYS A  92      13.484  33.068 -13.794  1.00 57.38           N  
ATOM    748  N   ARG A  93      16.487  31.643  -7.891  1.00 31.34           N  
ATOM    749  CA  ARG A  93      17.571  32.329  -7.207  1.00 34.33           C  
ATOM    750  C   ARG A  93      18.602  31.329  -6.679  1.00 37.70           C  
ATOM    751  O   ARG A  93      19.810  31.587  -6.723  1.00 35.28           O  
ATOM    752  CB  ARG A  93      17.027  33.159  -6.038  1.00 40.04           C  
ATOM    753  CG  ARG A  93      16.912  34.683  -6.256  1.00 40.81           C  
ATOM    754  CD  ARG A  93      15.832  35.365  -5.378  1.00 43.09           C  
ATOM    755  NE  ARG A  93      16.073  36.794  -5.197  1.00 48.76           N  
ATOM    756  CZ  ARG A  93      16.916  37.346  -4.299  1.00 58.53           C  
ATOM    757  NH1 ARG A  93      17.637  36.601  -3.458  1.00 60.84           N  
ATOM    758  NH2 ARG A  93      17.052  38.672  -4.240  1.00 63.46           N  
ATOM    759  N   HIS A  94      18.119  30.173  -6.218  1.00 39.85           N  
ATOM    760  CA  HIS A  94      18.934  29.278  -5.379  1.00 40.38           C  
ATOM    761  C   HIS A  94      19.385  27.890  -5.958  1.00 40.40           C  
ATOM    762  O   HIS A  94      19.910  27.068  -5.186  1.00 41.60           O  
ATOM    763  CB  HIS A  94      18.245  29.078  -4.011  1.00 41.63           C  
ATOM    764  CG  HIS A  94      18.138  30.321  -3.173  1.00 42.60           C  
ATOM    765  ND1 HIS A  94      19.228  30.914  -2.567  1.00 44.50           N  
ATOM    766  CD2 HIS A  94      17.060  31.053  -2.798  1.00 42.52           C  
ATOM    767  CE1 HIS A  94      18.829  31.968  -1.878  1.00 41.35           C  
ATOM    768  NE2 HIS A  94      17.517  32.073  -1.999  1.00 43.30           N  
ATOM    769  N   HIS A  95      19.184  27.622  -7.265  1.00 35.03           N  
ATOM    770  CA  HIS A  95      19.809  26.478  -7.951  1.00 30.91           C  
ATOM    771  C   HIS A  95      21.335  26.527  -7.796  1.00 33.35           C  
ATOM    772  O   HIS A  95      22.038  26.574  -8.789  1.00 34.33           O  
ATOM    773  CB  HIS A  95      19.523  26.579  -9.431  1.00 30.38           C  
ATOM    774  CG  HIS A  95      18.556  25.556  -9.962  1.00 35.50           C  
ATOM    775  ND1 HIS A  95      18.703  24.968 -11.207  1.00 35.79           N  
ATOM    776  CD2 HIS A  95      17.406  25.050  -9.453  1.00 34.42           C  
ATOM    777  CE1 HIS A  95      17.707  24.128 -11.427  1.00 32.26           C  
ATOM    778  NE2 HIS A  95      16.904  24.158 -10.377  1.00 32.75           N  
ATOM    779  N   HIS A  96      21.833  26.552  -6.549  1.00 37.57           N  
ATOM    780  CA  HIS A  96      23.271  26.630  -6.195  1.00 37.26           C  
ATOM    781  C   HIS A  96      23.553  25.762  -4.972  1.00 33.11           C  
ATOM    782  O   HIS A  96      23.459  26.239  -3.842  1.00 28.67           O  
ATOM    783  CB  HIS A  96      23.698  28.071  -5.843  1.00 40.36           C  
ATOM    784  CG  HIS A  96      23.638  29.038  -6.992  1.00 42.97           C  
ATOM    785  ND1 HIS A  96      22.576  29.099  -7.872  1.00 43.10           N  
ATOM    786  CD2 HIS A  96      24.499  30.009  -7.378  1.00 42.09           C  
ATOM    787  CE1 HIS A  96      22.797  30.047  -8.765  1.00 43.32           C  
ATOM    788  NE2 HIS A  96      23.957  30.615  -8.487  1.00 46.18           N  
TER     789      HIS A  96                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
