
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  144 ( 1172),  selected  144 , name 1lj9_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 1lj9_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_A      S       1           -
LGA    D     3_A      N       2           -
LGA    I     4_A      A       3           -
LGA    L     5_A      M       4           -
LGA    R     6_A      L       5           -
LGA    E     7_A      R       6           -
LGA    I     8_A      Y       7           -
LGA    G     9_A      G       8           -
LGA    M    10_A      D       9           -
LGA    I    11_A      T      10           -
LGA    A    12_A      E      11           -
LGA    R    13_A      I      12           -
LGA    A    14_A      C      13           -
LGA    L    15_A      I      14           -
LGA    D    16_A      D      15           -
LGA    S    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    S    19_A      -       -           -
LGA    N    20_A      -       -           -
LGA    I    21_A      -       -           -
LGA    E    22_A      -       -           -
LGA    F    23_A      -       -           -
LGA    K    24_A      P      16           #
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    E    25_A      S      19          5.507
LGA    L    26_A      V      20          5.136
LGA    S    27_A      L      21          3.149
LGA    -       -      H      22           -
LGA    -       -      L      23           -
LGA    L    28_A      L      24          0.989
LGA    T    29_A      G      25          1.093
LGA    R    30_A      K      26          1.011
LGA    G    31_A      K      27          2.616
LGA    -       -      Y      28           -
LGA    Q    32_A      T      29          0.781
LGA    Y    33_A      M      30          0.926
LGA    L    34_A      L      31          0.920
LGA    Y    35_A      I      32          0.563
LGA    L    36_A      I      33          0.788
LGA    V    37_A      S      34          0.686
LGA    R    38_A      V      35          0.754
LGA    V    39_A      L      36          0.582
LGA    C    40_A      G      37          0.974
LGA    E    41_A      N      38          1.005
LGA    N    42_A      G      39          3.802
LGA    -       -      S      40           -
LGA    P    43_A      T      41          4.328
LGA    G    44_A      R      42          0.849
LGA    I    45_A      Q      43          0.338
LGA    I    46_A      N      44          0.530
LGA    Q    47_A      F      45          0.911
LGA    E    48_A      N      46          1.731
LGA    K    49_A      D      47          1.779
LGA    I    50_A      I      48          0.993
LGA    A    51_A      R      49          1.164
LGA    E    52_A      S      50          1.630
LGA    L    53_A      S      51          1.549
LGA    I    54_A      I      52          0.943
LGA    K    55_A      P      53          2.822
LGA    V    56_A      G      54          3.849
LGA    -       -      I      55           -
LGA    D    57_A      S      56          2.419
LGA    R    58_A      S      57          1.888
LGA    T    59_A      T      58          2.251
LGA    T    60_A      I      59          2.027
LGA    A    61_A      L      60          1.208
LGA    A    62_A      S      61          1.125
LGA    R    63_A      R      62          1.204
LGA    A    64_A      R      63          1.322
LGA    I    65_A      I      64          0.996
LGA    K    66_A      K      65          1.080
LGA    R    67_A      D      66          1.134
LGA    L    68_A      L      67          0.819
LGA    E    69_A      I      68          0.642
LGA    E    70_A      D      69          0.822
LGA    Q    71_A      S      70          1.000
LGA    G    72_A      G      71          0.907
LGA    F    73_A      L      72          0.712
LGA    I    74_A      V      73          0.582
LGA    Y    75_A      E      74          0.349
LGA    R    76_A      R      75          0.761
LGA    Q    77_A      R      76          0.620
LGA    E    78_A      S      77          0.803
LGA    D    79_A      G      78          1.568
LGA    A    80_A      Q      79          3.257
LGA    S    81_A      -       -           -
LGA    N    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    I    85_A      I      80          3.392
LGA    K    86_A      T      81          1.438
LGA    R    87_A      T      82          0.759
LGA    I    88_A      Y      83          0.410
LGA    Y    89_A      A      84          0.822
LGA    A    90_A      L      85          0.574
LGA    T    91_A      T      86          0.331
LGA    E    92_A      E      87          0.693
LGA    K    93_A      K      88          0.487
LGA    G    94_A      G      89          0.548
LGA    K    95_A      M      90          0.682
LGA    N    96_A      N      91          0.705
LGA    V    97_A      V      92          1.041
LGA    Y    98_A      R      93          0.457
LGA    P    99_A      N      94          1.534
LGA    I   100_A      S      95          1.337
LGA    I   101_A      L      96          1.070
LGA    V   102_A      M      97          0.769
LGA    R   103_A      P      98          0.595
LGA    E   104_A      L      99          0.378
LGA    N   105_A      L     100          0.599
LGA    Q   106_A      Q     101          0.909
LGA    H   107_A      Y     102          1.253
LGA    S   108_A      I     103          1.129
LGA    N   109_A      S     104          1.941
LGA    Q   110_A      V     105          2.254
LGA    V   111_A      L     106          2.469
LGA    A   112_A      D     107          2.902
LGA    L   113_A      R     108          2.721
LGA    Q   114_A      N     109          3.585
LGA    G   115_A      -       -           -
LGA    L   116_A      -       -           -
LGA    S   117_A      -       -           -
LGA    E   118_A      -       -           -
LGA    V   119_A      -       -           -
LGA    E   120_A      -       -           -
LGA    I   121_A      -       -           -
LGA    S   122_A      -       -           -
LGA    Q   123_A      -       -           -
LGA    L   124_A      -       -           -
LGA    A   125_A      -       -           -
LGA    D   126_A      -       -           -
LGA    Y   127_A      -       -           -
LGA    L   128_A      -       -           -
LGA    V   129_A      -       -           -
LGA    R   130_A      -       -           -
LGA    M   131_A      -       -           -
LGA    R   132_A      -       -           -
LGA    K   133_A      -       -           -
LGA    N   134_A      -       -           -
LGA    V   135_A      -       -           -
LGA    S   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    D   138_A      -       -           -
LGA    W   139_A      -       -           -
LGA    E   140_A      -       -           -
LGA    F   141_A      -       -           -
LGA    V   142_A      -       -           -
LGA    K   143_A      -       -           -
LGA    K   144_A      -       -           -
LGA    G   145_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  144  109    5.0     86    1.79    22.09     72.815     4.551

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.339088 * X  +  -0.508820 * Y  +  -0.791278 * Z  +  23.537865
  Y_new =  -0.824758 * X  +  -0.565395 * Y  +   0.010134 * Z  +  36.540081
  Z_new =  -0.452541 * X  +   0.649177 * Y  +  -0.611372 * Z  +   0.869236 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.326213   -0.815380  [ DEG:   133.2822    -46.7178 ]
  Theta =   0.469613    2.671980  [ DEG:    26.9068    153.0932 ]
  Phi   =  -1.180727    1.960865  [ DEG:   -67.6507    112.3493 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lj9_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lj9_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  144  109   5.0   86   1.79   22.09  72.815
REMARK  ---------------------------------------------------------- 
MOLECULE 1lj9_A
HEADER    TRANSCRIPTION                           19-APR-02   1LJ9              
TITLE     THE CRYSTAL STRUCTURE OF THE TRANSCRIPTIONAL REGULATOR SLYA           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR SLYA;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: REF02436;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PPROEX1                                   
KEYWDS    HTH DNA BINDING PROTEIN, STRUCTURAL GENOMICS, PSI, PROTEIN            
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.Y.WU,R.G.ZHANG,P.GORNICKI,A.JOACHIMIAK,MIDWEST CENTER FOR           
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   3   25-JAN-05 1LJ9    1       JRNL                                     
REVDAT   2   18-JAN-05 1LJ9    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   21-JAN-03 1LJ9    0                                                
JRNL        AUTH   R.Y.WU,R.G.ZHANG,O.ZAGNITKO,I.DEMENTIEVA,N.MALTZEV,          
JRNL        AUTH 2 J.D.WATSON,R.LASKOWSKI,P.GORNICKI,A.JOACHIMIAK               
JRNL        TITL   CRYSTAL STRUCTURE OF ENTEROCOCCUS FAECALIS                   
JRNL        TITL 2 SLYA-LIKE TRANSCRIPTIONAL FACTOR                             
JRNL        REF    J.BIOL.CHEM.                  V. 278 20240 2003              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1LJ9 A    2   145  UNP    Q82ZP8   Q82ZP8_ENTFA     2    145             
DBREF  1LJ9 B    2   145  UNP    Q82ZP8   Q82ZP8_ENTFA     2    145             
SEQRES   1 A  144  THR ASP ILE LEU ARG GLU ILE GLY MET ILE ALA ARG ALA          
SEQRES   2 A  144  LEU ASP SER ILE SER ASN ILE GLU PHE LYS GLU LEU SER          
SEQRES   3 A  144  LEU THR ARG GLY GLN TYR LEU TYR LEU VAL ARG VAL CYS          
SEQRES   4 A  144  GLU ASN PRO GLY ILE ILE GLN GLU LYS ILE ALA GLU LEU          
SEQRES   5 A  144  ILE LYS VAL ASP ARG THR THR ALA ALA ARG ALA ILE LYS          
SEQRES   6 A  144  ARG LEU GLU GLU GLN GLY PHE ILE TYR ARG GLN GLU ASP          
SEQRES   7 A  144  ALA SER ASN LYS LYS ILE LYS ARG ILE TYR ALA THR GLU          
SEQRES   8 A  144  LYS GLY LYS ASN VAL TYR PRO ILE ILE VAL ARG GLU ASN          
SEQRES   9 A  144  GLN HIS SER ASN GLN VAL ALA LEU GLN GLY LEU SER GLU          
SEQRES  10 A  144  VAL GLU ILE SER GLN LEU ALA ASP TYR LEU VAL ARG MET          
SEQRES  11 A  144  ARG LYS ASN VAL SER GLU ASP TRP GLU PHE VAL LYS LYS          
SEQRES  12 A  144  GLY                                                          
SEQRES   1 B  144  THR ASP ILE LEU ARG GLU ILE GLY MET ILE ALA ARG ALA          
SEQRES   2 B  144  LEU ASP SER ILE SER ASN ILE GLU PHE LYS GLU LEU SER          
SEQRES   3 B  144  LEU THR ARG GLY GLN TYR LEU TYR LEU VAL ARG VAL CYS          
SEQRES   4 B  144  GLU ASN PRO GLY ILE ILE GLN GLU LYS ILE ALA GLU LEU          
SEQRES   5 B  144  ILE LYS VAL ASP ARG THR THR ALA ALA ARG ALA ILE LYS          
SEQRES   6 B  144  ARG LEU GLU GLU GLN GLY PHE ILE TYR ARG GLN GLU ASP          
SEQRES   7 B  144  ALA SER ASN LYS LYS ILE LYS ARG ILE TYR ALA THR GLU          
SEQRES   8 B  144  LYS GLY LYS ASN VAL TYR PRO ILE ILE VAL ARG GLU ASN          
SEQRES   9 B  144  GLN HIS SER ASN GLN VAL ALA LEU GLN GLY LEU SER GLU          
SEQRES  10 B  144  VAL GLU ILE SER GLN LEU ALA ASP TYR LEU VAL ARG MET          
SEQRES  11 B  144  ARG LYS ASN VAL SER GLU ASP TRP GLU PHE VAL LYS LYS          
SEQRES  12 B  144  GLY                                                          
FORMUL   3  HOH   *289(H2 O)                                                    
CRYST1   43.512   48.429  125.999  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   THR A   2      26.551  15.426 -10.419  1.00 23.78           N  
ATOM      2  CA  THR A   2      25.201  15.762  -9.876  1.00 23.95           C  
ATOM      3  C   THR A   2      24.084  15.277 -10.798  1.00 23.64           C  
ATOM      4  O   THR A   2      24.087  15.569 -11.995  1.00 24.43           O  
ATOM      5  CB  THR A   2      25.038  17.290  -9.689  1.00 23.89           C  
ATOM      6  OG1 THR A   2      26.002  17.764  -8.743  1.00 25.03           O  
ATOM      7  CG2 THR A   2      23.629  17.628  -9.189  1.00 23.81           C  
ATOM      8  N   ASP A   3      23.142  14.523 -10.237  1.00 22.86           N  
ATOM      9  CA  ASP A   3      21.996  14.027 -10.995  1.00 22.01           C  
ATOM     10  C   ASP A   3      21.066  15.226 -11.124  1.00 20.49           C  
ATOM     11  O   ASP A   3      20.385  15.598 -10.166  1.00 20.46           O  
ATOM     12  CB  ASP A   3      21.289  12.905 -10.229  1.00 22.59           C  
ATOM     13  CG  ASP A   3      20.201  12.217 -11.052  1.00 23.39           C  
ATOM     14  OD1 ASP A   3      19.394  12.908 -11.717  1.00 23.24           O  
ATOM     15  OD2 ASP A   3      20.146  10.968 -11.020  1.00 25.18           O  
ATOM     16  N   ILE A   4      21.044  15.835 -12.305  1.00 19.08           N  
ATOM     17  CA  ILE A   4      20.216  17.012 -12.534  1.00 17.73           C  
ATOM     18  C   ILE A   4      18.738  16.830 -12.217  1.00 18.09           C  
ATOM     19  O   ILE A   4      18.152  17.632 -11.478  1.00 17.21           O  
ATOM     20  CB  ILE A   4      20.339  17.506 -13.990  1.00 18.06           C  
ATOM     21  CG1 ILE A   4      21.782  17.944 -14.266  1.00 17.51           C  
ATOM     22  CG2 ILE A   4      19.369  18.656 -14.233  1.00 17.35           C  
ATOM     23  CD1 ILE A   4      22.274  19.063 -13.374  1.00 17.39           C  
ATOM     24  N   LEU A   5      18.129  15.794 -12.783  1.00 16.94           N  
ATOM     25  CA  LEU A   5      16.714  15.552 -12.558  1.00 16.71           C  
ATOM     26  C   LEU A   5      16.403  15.212 -11.112  1.00 16.26           C  
ATOM     27  O   LEU A   5      15.304  15.502 -10.637  1.00 15.51           O  
ATOM     28  CB  LEU A   5      16.196  14.454 -13.484  1.00 15.97           C  
ATOM     29  CG  LEU A   5      16.171  14.888 -14.956  1.00 16.57           C  
ATOM     30  CD1 LEU A   5      15.442  13.836 -15.772  1.00 16.85           C  
ATOM     31  CD2 LEU A   5      15.464  16.239 -15.097  1.00 16.76           C  
ATOM     32  N   ARG A   6      17.366  14.609 -10.419  1.00 15.41           N  
ATOM     33  CA  ARG A   6      17.172  14.271  -9.013  1.00 16.25           C  
ATOM     34  C   ARG A   6      17.006  15.570  -8.228  1.00 15.66           C  
ATOM     35  O   ARG A   6      16.139  15.670  -7.369  1.00 15.02           O  
ATOM     36  CB  ARG A   6      18.368  13.498  -8.457  1.00 17.73           C  
ATOM     37  CG  ARG A   6      18.168  13.077  -7.018  1.00 20.61           C  
ATOM     38  CD  ARG A   6      17.970  11.573  -6.897  1.00 22.96           C  
ATOM     39  NE  ARG A   6      19.098  10.990  -6.186  1.00 24.99           N  
ATOM     40  CZ  ARG A   6      19.252   9.696  -5.929  1.00 24.36           C  
ATOM     41  NH1 ARG A   6      18.341   8.818  -6.328  1.00 25.21           N  
ATOM     42  NH2 ARG A   6      20.324   9.288  -5.268  1.00 25.54           N  
ATOM     43  N   GLU A   7      17.848  16.556  -8.529  1.00 15.57           N  
ATOM     44  CA  GLU A   7      17.778  17.858  -7.863  1.00 15.87           C  
ATOM     45  C   GLU A   7      16.446  18.533  -8.193  1.00 15.31           C  
ATOM     46  O   GLU A   7      15.742  19.016  -7.298  1.00 15.62           O  
ATOM     47  CB  GLU A   7      18.941  18.752  -8.315  1.00 15.39           C  
ATOM     48  CG  GLU A   7      20.335  18.296  -7.859  1.00 16.81           C  
ATOM     49  CD  GLU A   7      20.513  18.312  -6.345  1.00 17.41           C  
ATOM     50  OE1 GLU A   7      19.853  19.126  -5.673  1.00 17.44           O  
ATOM     51  OE2 GLU A   7      21.343  17.527  -5.826  1.00 18.32           O  
ATOM     52  N   ILE A   8      16.101  18.572  -9.478  1.00 15.33           N  
ATOM     53  CA  ILE A   8      14.845  19.180  -9.910  1.00 14.86           C  
ATOM     54  C   ILE A   8      13.678  18.574  -9.134  1.00 14.69           C  
ATOM     55  O   ILE A   8      12.804  19.293  -8.637  1.00 14.26           O  
ATOM     56  CB  ILE A   8      14.611  18.952 -11.419  1.00 15.93           C  
ATOM     57  CG1 ILE A   8      15.551  19.849 -12.239  1.00 17.08           C  
ATOM     58  CG2 ILE A   8      13.138  19.198 -11.769  1.00 14.96           C  
ATOM     59  CD1 ILE A   8      15.109  21.286 -12.348  1.00 20.06           C  
ATOM     60  N   GLY A   9      13.683  17.249  -9.021  1.00 14.58           N  
ATOM     61  CA  GLY A   9      12.618  16.561  -8.315  1.00 14.22           C  
ATOM     62  C   GLY A   9      12.529  16.955  -6.852  1.00 14.27           C  
ATOM     63  O   GLY A   9      11.442  17.221  -6.341  1.00 13.71           O  
ATOM     64  N   MET A  10      13.671  16.979  -6.170  1.00 14.58           N  
ATOM     65  CA  MET A  10      13.692  17.356  -4.753  1.00 14.65           C  
ATOM     66  C   MET A  10      13.202  18.793  -4.570  1.00 14.60           C  
ATOM     67  O   MET A  10      12.438  19.090  -3.640  1.00 13.97           O  
ATOM     68  CB  MET A  10      15.108  17.197  -4.162  1.00 11.98           C  
ATOM     69  CG  MET A  10      15.532  15.710  -3.887  1.00 11.94           C  
ATOM     70  SD  MET A  10      17.105  15.478  -3.077  1.00  3.59           S  
ATOM     71  CE  MET A  10      18.115  16.173  -4.282  1.00 11.08           C  
ATOM     72  N   ILE A  11      13.617  19.692  -5.458  1.00 14.25           N  
ATOM     73  CA  ILE A  11      13.177  21.080  -5.339  1.00 14.59           C  
ATOM     74  C   ILE A  11      11.663  21.172  -5.497  1.00 15.02           C  
ATOM     75  O   ILE A  11      10.987  21.858  -4.725  1.00 14.78           O  
ATOM     76  CB  ILE A  11      13.854  21.970  -6.401  1.00 13.43           C  
ATOM     77  CG1 ILE A  11      15.361  21.994  -6.148  1.00 15.21           C  
ATOM     78  CG2 ILE A  11      13.240  23.384  -6.375  1.00 13.63           C  
ATOM     79  CD1 ILE A  11      16.186  22.632  -7.262  1.00 14.48           C  
ATOM     80  N   ALA A  12      11.131  20.465  -6.489  1.00 15.69           N  
ATOM     81  CA  ALA A  12       9.701  20.480  -6.759  1.00 15.09           C  
ATOM     82  C   ALA A  12       8.882  19.897  -5.604  1.00 15.49           C  
ATOM     83  O   ALA A  12       7.853  20.458  -5.214  1.00 14.52           O  
ATOM     84  CB  ALA A  12       9.417  19.715  -8.039  1.00 14.51           C  
ATOM     85  N   ARG A  13       9.333  18.772  -5.058  1.00 14.87           N  
ATOM     86  CA  ARG A  13       8.616  18.143  -3.963  1.00 15.00           C  
ATOM     87  C   ARG A  13       8.740  18.960  -2.680  1.00 15.16           C  
ATOM     88  O   ARG A  13       7.790  19.038  -1.902  1.00 14.78           O  
ATOM     89  CB  ARG A  13       9.114  16.708  -3.770  1.00 15.76           C  
ATOM     90  CG  ARG A  13       8.763  15.834  -4.973  1.00 17.48           C  
ATOM     91  CD  ARG A  13       9.023  14.360  -4.716  1.00 18.40           C  
ATOM     92  NE  ARG A  13      10.445  14.056  -4.635  1.00 19.36           N  
ATOM     93  CZ  ARG A  13      11.238  13.882  -5.686  1.00 19.89           C  
ATOM     94  NH1 ARG A  13      10.754  13.976  -6.921  1.00 19.78           N  
ATOM     95  NH2 ARG A  13      12.517  13.606  -5.498  1.00 21.25           N  
ATOM     96  N   ALA A  14       9.892  19.586  -2.472  1.00 14.80           N  
ATOM     97  CA  ALA A  14      10.077  20.408  -1.282  1.00 14.88           C  
ATOM     98  C   ALA A  14       9.084  21.572  -1.340  1.00 14.89           C  
ATOM     99  O   ALA A  14       8.436  21.892  -0.342  1.00 14.92           O  
ATOM    100  CB  ALA A  14      11.505  20.948  -1.217  1.00 14.86           C  
ATOM    101  N   LEU A  15       8.975  22.201  -2.511  1.00 14.95           N  
ATOM    102  CA  LEU A  15       8.054  23.321  -2.688  1.00 15.81           C  
ATOM    103  C   LEU A  15       6.614  22.866  -2.476  1.00 16.04           C  
ATOM    104  O   LEU A  15       5.805  23.567  -1.863  1.00 15.71           O  
ATOM    105  CB  LEU A  15       8.220  23.934  -4.082  1.00 16.56           C  
ATOM    106  CG  LEU A  15       9.546  24.688  -4.276  1.00 17.17           C  
ATOM    107  CD1 LEU A  15       9.699  25.111  -5.735  1.00 17.83           C  
ATOM    108  CD2 LEU A  15       9.587  25.903  -3.355  1.00 17.77           C  
ATOM    109  N   ASP A  16       6.292  21.684  -2.985  1.00 16.82           N  
ATOM    110  CA  ASP A  16       4.952  21.147  -2.826  1.00 17.79           C  
ATOM    111  C   ASP A  16       4.648  20.947  -1.346  1.00 18.16           C  
ATOM    112  O   ASP A  16       3.562  21.280  -0.865  1.00 17.34           O  
ATOM    113  CB  ASP A  16       4.833  19.815  -3.564  1.00 19.81           C  
ATOM    114  CG  ASP A  16       3.466  19.192  -3.409  1.00 21.50           C  
ATOM    115  OD1 ASP A  16       3.341  18.221  -2.630  1.00 23.05           O  
ATOM    116  OD2 ASP A  16       2.512  19.687  -4.056  1.00 22.11           O  
ATOM    117  N   SER A  17       5.621  20.403  -0.624  1.00 16.97           N  
ATOM    118  CA  SER A  17       5.467  20.154   0.801  1.00 17.28           C  
ATOM    119  C   SER A  17       5.304  21.449   1.593  1.00 17.64           C  
ATOM    120  O   SER A  17       4.603  21.482   2.600  1.00 17.57           O  
ATOM    121  CB  SER A  17       6.669  19.362   1.313  1.00 17.92           C  
ATOM    122  OG  SER A  17       6.717  18.095   0.673  1.00 18.53           O  
ATOM    123  N   ILE A  18       5.961  22.511   1.140  1.00 17.44           N  
ATOM    124  CA  ILE A  18       5.862  23.802   1.807  1.00 17.50           C  
ATOM    125  C   ILE A  18       4.453  24.341   1.558  1.00 17.70           C  
ATOM    126  O   ILE A  18       3.787  24.810   2.479  1.00 16.92           O  
ATOM    127  CB  ILE A  18       6.930  24.783   1.258  1.00 17.81           C  
ATOM    128  CG1 ILE A  18       8.312  24.373   1.793  1.00 18.55           C  
ATOM    129  CG2 ILE A  18       6.585  26.221   1.641  1.00 17.45           C  
ATOM    130  CD1 ILE A  18       9.478  25.052   1.103  1.00 18.09           C  
ATOM    131  N   SER A  19       3.997  24.242   0.310  1.00 17.44           N  
ATOM    132  CA  SER A  19       2.663  24.709  -0.065  1.00 17.32           C  
ATOM    133  C   SER A  19       1.571  23.985   0.711  1.00 16.78           C  
ATOM    134  O   SER A  19       0.557  24.582   1.064  1.00 17.40           O  
ATOM    135  CB  SER A  19       2.426  24.505  -1.563  1.00 18.10           C  
ATOM    136  OG  SER A  19       3.347  25.267  -2.321  1.00 20.08           O  
ATOM    137  N   ASN A  20       1.771  22.697   0.976  1.00 16.44           N  
ATOM    138  CA  ASN A  20       0.781  21.922   1.721  1.00 17.36           C  
ATOM    139  C   ASN A  20       0.603  22.424   3.140  1.00 17.98           C  
ATOM    140  O   ASN A  20      -0.429  22.180   3.768  1.00 18.79           O  
ATOM    141  CB  ASN A  20       1.160  20.442   1.757  1.00 16.24           C  
ATOM    142  CG  ASN A  20       0.933  19.764   0.430  1.00 17.11           C  
ATOM    143  OD1 ASN A  20       0.238  20.300  -0.430  1.00 17.14           O  
ATOM    144  ND2 ASN A  20       1.508  18.579   0.256  1.00 16.52           N  
ATOM    145  N   ILE A  21       1.613  23.119   3.646  1.00 18.00           N  
ATOM    146  CA  ILE A  21       1.539  23.663   4.990  1.00 18.18           C  
ATOM    147  C   ILE A  21       1.007  25.088   4.928  1.00 18.09           C  
ATOM    148  O   ILE A  21       0.050  25.436   5.613  1.00 18.08           O  
ATOM    149  CB  ILE A  21       2.938  23.660   5.670  1.00 17.74           C  
ATOM    150  CG1 ILE A  21       3.425  22.218   5.850  1.00 18.97           C  
ATOM    151  CG2 ILE A  21       2.870  24.384   7.019  1.00 17.93           C  
ATOM    152  CD1 ILE A  21       4.849  22.108   6.347  1.00 19.95           C  
ATOM    153  N   GLU A  22       1.602  25.901   4.065  1.00 18.43           N  
ATOM    154  CA  GLU A  22       1.202  27.295   3.971  1.00 18.77           C  
ATOM    155  C   GLU A  22      -0.164  27.598   3.350  1.00 17.77           C  
ATOM    156  O   GLU A  22      -0.760  28.633   3.659  1.00 15.94           O  
ATOM    157  CB  GLU A  22       2.295  28.088   3.262  1.00 21.94           C  
ATOM    158  CG  GLU A  22       2.041  29.578   3.244  1.00 26.67           C  
ATOM    159  CD  GLU A  22       1.291  29.998   2.010  1.00 29.13           C  
ATOM    160  OE1 GLU A  22       1.913  29.967   0.928  1.00 31.32           O  
ATOM    161  OE2 GLU A  22       0.088  30.344   2.111  1.00 31.52           O  
ATOM    162  N   PHE A  23      -0.667  26.716   2.489  1.00 16.35           N  
ATOM    163  CA  PHE A  23      -1.970  26.949   1.866  1.00 16.67           C  
ATOM    164  C   PHE A  23      -3.071  26.148   2.546  1.00 16.74           C  
ATOM    165  O   PHE A  23      -4.210  26.139   2.086  1.00 16.72           O  
ATOM    166  CB  PHE A  23      -1.957  26.573   0.379  1.00 17.40           C  
ATOM    167  CG  PHE A  23      -1.039  27.411  -0.461  1.00 17.88           C  
ATOM    168  CD1 PHE A  23      -0.758  28.726  -0.123  1.00 17.45           C  
ATOM    169  CD2 PHE A  23      -0.483  26.891  -1.623  1.00 16.68           C  
ATOM    170  CE1 PHE A  23       0.063  29.509  -0.930  1.00 18.71           C  
ATOM    171  CE2 PHE A  23       0.338  27.667  -2.432  1.00 17.15           C  
ATOM    172  CZ  PHE A  23       0.612  28.976  -2.088  1.00 17.85           C  
ATOM    173  N   LYS A  24      -2.737  25.494   3.651  1.00 16.86           N  
ATOM    174  CA  LYS A  24      -3.714  24.685   4.363  1.00 18.54           C  
ATOM    175  C   LYS A  24      -4.985  25.449   4.731  1.00 19.14           C  
ATOM    176  O   LYS A  24      -6.095  24.943   4.532  1.00 19.24           O  
ATOM    177  CB  LYS A  24      -3.070  24.072   5.609  1.00 20.21           C  
ATOM    178  CG  LYS A  24      -4.007  23.242   6.467  1.00 22.41           C  
ATOM    179  CD  LYS A  24      -3.234  22.456   7.528  1.00 24.30           C  
ATOM    180  CE  LYS A  24      -2.338  23.360   8.368  1.00 25.93           C  
ATOM    181  NZ  LYS A  24      -3.111  24.420   9.090  1.00 28.59           N  
ATOM    182  N   GLU A  25      -4.844  26.671   5.236  1.00 18.99           N  
ATOM    183  CA  GLU A  25      -6.029  27.430   5.607  1.00 20.57           C  
ATOM    184  C   GLU A  25      -6.767  28.018   4.406  1.00 20.95           C  
ATOM    185  O   GLU A  25      -7.906  28.470   4.534  1.00 21.84           O  
ATOM    186  CB  GLU A  25      -5.663  28.534   6.599  1.00 20.87           C  
ATOM    187  CG  GLU A  25      -5.175  28.008   7.949  1.00 22.71           C  
ATOM    188  CD  GLU A  25      -6.131  26.996   8.568  1.00 23.68           C  
ATOM    189  OE1 GLU A  25      -7.358  27.238   8.541  1.00 24.33           O  
ATOM    190  OE2 GLU A  25      -5.656  25.963   9.090  1.00 24.14           O  
ATOM    191  N   LEU A  26      -6.127  27.995   3.238  1.00 20.92           N  
ATOM    192  CA  LEU A  26      -6.719  28.528   2.014  1.00 21.56           C  
ATOM    193  C   LEU A  26      -7.325  27.445   1.124  1.00 21.46           C  
ATOM    194  O   LEU A  26      -7.761  27.738   0.009  1.00 22.35           O  
ATOM    195  CB  LEU A  26      -5.673  29.304   1.203  1.00 21.46           C  
ATOM    196  CG  LEU A  26      -5.069  30.569   1.817  1.00 21.47           C  
ATOM    197  CD1 LEU A  26      -3.910  31.054   0.957  1.00 22.05           C  
ATOM    198  CD2 LEU A  26      -6.141  31.643   1.933  1.00 21.60           C  
ATOM    199  N   SER A  27      -7.344  26.201   1.602  1.00 21.21           N  
ATOM    200  CA  SER A  27      -7.909  25.087   0.832  1.00 21.22           C  
ATOM    201  C   SER A  27      -7.278  24.929  -0.553  1.00 21.15           C  
ATOM    202  O   SER A  27      -7.981  24.659  -1.530  1.00 20.21           O  
ATOM    203  CB  SER A  27      -9.422  25.289   0.660  1.00 20.78           C  
ATOM    204  OG  SER A  27     -10.052  25.506   1.909  1.00 21.02           O  
ATOM    205  N   LEU A  28      -5.960  25.084  -0.646  1.00 20.84           N  
ATOM    206  CA  LEU A  28      -5.287  24.971  -1.931  1.00 19.87           C  
ATOM    207  C   LEU A  28      -4.046  24.088  -1.922  1.00 19.73           C  
ATOM    208  O   LEU A  28      -3.155  24.234  -2.761  1.00 19.28           O  
ATOM    209  CB  LEU A  28      -4.933  26.369  -2.443  1.00 19.81           C  
ATOM    210  CG  LEU A  28      -6.186  27.123  -2.890  1.00 20.05           C  
ATOM    211  CD1 LEU A  28      -5.873  28.586  -3.187  1.00 20.68           C  
ATOM    212  CD2 LEU A  28      -6.746  26.425  -4.132  1.00 19.90           C  
ATOM    213  N   THR A  29      -3.999  23.157  -0.979  1.00 19.37           N  
ATOM    214  CA  THR A  29      -2.871  22.249  -0.875  1.00 19.74           C  
ATOM    215  C   THR A  29      -2.926  21.158  -1.950  1.00 20.16           C  
ATOM    216  O   THR A  29      -3.837  21.132  -2.785  1.00 20.98           O  
ATOM    217  CB  THR A  29      -2.851  21.584   0.503  1.00 19.72           C  
ATOM    218  OG1 THR A  29      -3.988  20.723   0.629  1.00 18.32           O  
ATOM    219  CG2 THR A  29      -2.906  22.653   1.602  1.00 18.80           C  
ATOM    220  N   ARG A  30      -1.934  20.274  -1.925  1.00 20.65           N  
ATOM    221  CA  ARG A  30      -1.836  19.159  -2.863  1.00 21.00           C  
ATOM    222  C   ARG A  30      -1.810  19.595  -4.327  1.00 20.49           C  
ATOM    223  O   ARG A  30      -2.343  18.906  -5.194  1.00 20.35           O  
ATOM    224  CB  ARG A  30      -2.998  18.183  -2.638  1.00 21.67           C  
ATOM    225  CG  ARG A  30      -3.054  17.573  -1.237  1.00 23.23           C  
ATOM    226  CD  ARG A  30      -4.275  16.674  -1.075  1.00 24.09           C  
ATOM    227  NE  ARG A  30      -4.249  15.541  -1.999  1.00 26.17           N  
ATOM    228  CZ  ARG A  30      -5.264  14.701  -2.197  1.00 26.75           C  
ATOM    229  NH1 ARG A  30      -6.404  14.855  -1.532  1.00 27.23           N  
ATOM    230  NH2 ARG A  30      -5.141  13.706  -3.067  1.00 27.69           N  
ATOM    231  N   GLY A  31      -1.197  20.743  -4.594  1.00 20.18           N  
ATOM    232  CA  GLY A  31      -1.103  21.245  -5.954  1.00 18.98           C  
ATOM    233  C   GLY A  31      -2.321  21.988  -6.466  1.00 18.99           C  
ATOM    234  O   GLY A  31      -2.307  22.514  -7.584  1.00 18.93           O  
ATOM    235  N   GLN A  32      -3.380  22.042  -5.666  1.00 18.40           N  
ATOM    236  CA  GLN A  32      -4.596  22.726  -6.085  1.00 18.06           C  
ATOM    237  C   GLN A  32      -4.372  24.171  -6.509  1.00 18.03           C  
ATOM    238  O   GLN A  32      -5.016  24.649  -7.443  1.00 17.12           O  
ATOM    239  CB  GLN A  32      -5.652  22.660  -4.981  1.00 18.56           C  
ATOM    240  CG  GLN A  32      -6.242  21.268  -4.754  1.00 18.37           C  
ATOM    241  CD  GLN A  32      -7.001  20.727  -5.963  1.00 19.14           C  
ATOM    242  OE1 GLN A  32      -6.433  20.040  -6.816  1.00 19.22           O  
ATOM    243  NE2 GLN A  32      -8.288  21.045  -6.042  1.00 18.72           N  
ATOM    244  N   TYR A  33      -3.462  24.867  -5.827  1.00 17.77           N  
ATOM    245  CA  TYR A  33      -3.161  26.262  -6.156  1.00 17.44           C  
ATOM    246  C   TYR A  33      -2.671  26.409  -7.602  1.00 16.28           C  
ATOM    247  O   TYR A  33      -2.921  27.427  -8.246  1.00 16.53           O  
ATOM    248  CB  TYR A  33      -2.107  26.832  -5.198  1.00 18.02           C  
ATOM    249  CG  TYR A  33      -0.733  26.214  -5.339  1.00 19.13           C  
ATOM    250  CD1 TYR A  33      -0.422  25.003  -4.720  1.00 20.42           C  
ATOM    251  CD2 TYR A  33       0.246  26.826  -6.115  1.00 20.00           C  
ATOM    252  CE1 TYR A  33       0.830  24.419  -4.877  1.00 20.49           C  
ATOM    253  CE2 TYR A  33       1.502  26.251  -6.276  1.00 21.23           C  
ATOM    254  CZ  TYR A  33       1.785  25.049  -5.656  1.00 21.29           C  
ATOM    255  OH  TYR A  33       3.025  24.474  -5.827  1.00 23.53           O  
ATOM    256  N   LEU A  34      -1.994  25.380  -8.110  1.00 16.62           N  
ATOM    257  CA  LEU A  34      -1.479  25.381  -9.478  1.00 16.19           C  
ATOM    258  C   LEU A  34      -2.605  25.568 -10.489  1.00 16.12           C  
ATOM    259  O   LEU A  34      -2.468  26.316 -11.456  1.00 15.44           O  
ATOM    260  CB  LEU A  34      -0.767  24.059  -9.793  1.00 17.33           C  
ATOM    261  CG  LEU A  34       0.489  23.685  -9.000  1.00 18.32           C  
ATOM    262  CD1 LEU A  34       0.854  22.236  -9.292  1.00 19.00           C  
ATOM    263  CD2 LEU A  34       1.636  24.615  -9.366  1.00 18.58           C  
ATOM    264  N   TYR A  35      -3.709  24.865 -10.262  1.00 15.57           N  
ATOM    265  CA  TYR A  35      -4.852  24.942 -11.158  1.00 16.00           C  
ATOM    266  C   TYR A  35      -5.577  26.282 -11.044  1.00 15.59           C  
ATOM    267  O   TYR A  35      -5.995  26.858 -12.052  1.00 16.27           O  
ATOM    268  CB  TYR A  35      -5.801  23.774 -10.881  1.00 16.18           C  
ATOM    269  CG  TYR A  35      -5.161  22.416 -11.129  1.00 17.20           C  
ATOM    270  CD1 TYR A  35      -4.410  21.776 -10.138  1.00 17.35           C  
ATOM    271  CD2 TYR A  35      -5.282  21.788 -12.371  1.00 17.30           C  
ATOM    272  CE1 TYR A  35      -3.794  20.542 -10.382  1.00 17.42           C  
ATOM    273  CE2 TYR A  35      -4.678  20.566 -12.621  1.00 17.41           C  
ATOM    274  CZ  TYR A  35      -3.940  19.948 -11.629  1.00 17.40           C  
ATOM    275  OH  TYR A  35      -3.363  18.729 -11.868  1.00 17.07           O  
ATOM    276  N   LEU A  36      -5.726  26.795  -9.828  1.00 15.88           N  
ATOM    277  CA  LEU A  36      -6.391  28.081  -9.661  1.00 15.86           C  
ATOM    278  C   LEU A  36      -5.591  29.167 -10.382  1.00 15.37           C  
ATOM    279  O   LEU A  36      -6.155  30.022 -11.059  1.00 15.37           O  
ATOM    280  CB  LEU A  36      -6.534  28.421  -8.175  1.00 18.06           C  
ATOM    281  CG  LEU A  36      -7.246  29.735  -7.833  1.00 19.66           C  
ATOM    282  CD1 LEU A  36      -8.612  29.798  -8.504  1.00 19.42           C  
ATOM    283  CD2 LEU A  36      -7.402  29.839  -6.319  1.00 19.81           C  
ATOM    284  N   VAL A  37      -4.270  29.123 -10.249  1.00 14.80           N  
ATOM    285  CA  VAL A  37      -3.413  30.104 -10.908  1.00 14.57           C  
ATOM    286  C   VAL A  37      -3.582  30.079 -12.432  1.00 15.00           C  
ATOM    287  O   VAL A  37      -3.764  31.123 -13.067  1.00 13.51           O  
ATOM    288  CB  VAL A  37      -1.930  29.866 -10.536  1.00 14.24           C  
ATOM    289  CG1 VAL A  37      -1.019  30.656 -11.443  1.00 15.12           C  
ATOM    290  CG2 VAL A  37      -1.693  30.281  -9.095  1.00 13.75           C  
ATOM    291  N   ARG A  38      -3.524  28.893 -13.026  1.00 15.02           N  
ATOM    292  CA  ARG A  38      -3.682  28.794 -14.476  1.00 16.09           C  
ATOM    293  C   ARG A  38      -5.074  29.280 -14.930  1.00 16.02           C  
ATOM    294  O   ARG A  38      -5.214  29.879 -16.003  1.00 16.59           O  
ATOM    295  CB  ARG A  38      -3.424  27.350 -14.921  1.00 17.73           C  
ATOM    296  CG  ARG A  38      -2.047  27.079 -15.569  1.00 19.59           C  
ATOM    297  CD  ARG A  38      -0.883  27.797 -14.913  1.00 21.95           C  
ATOM    298  NE  ARG A  38       0.419  27.163 -15.168  1.00 22.59           N  
ATOM    299  CZ  ARG A  38       1.117  27.229 -16.306  1.00 22.74           C  
ATOM    300  NH1 ARG A  38       0.662  27.909 -17.349  1.00 23.68           N  
ATOM    301  NH2 ARG A  38       2.292  26.612 -16.396  1.00 22.02           N  
ATOM    302  N   VAL A  39      -6.098  29.032 -14.118  1.00 15.07           N  
ATOM    303  CA  VAL A  39      -7.455  29.482 -14.448  1.00 16.07           C  
ATOM    304  C   VAL A  39      -7.564  31.018 -14.394  1.00 16.45           C  
ATOM    305  O   VAL A  39      -8.226  31.640 -15.235  1.00 16.25           O  
ATOM    306  CB  VAL A  39      -8.505  28.852 -13.492  1.00 15.75           C  
ATOM    307  CG1 VAL A  39      -9.861  29.547 -13.659  1.00 16.86           C  
ATOM    308  CG2 VAL A  39      -8.665  27.362 -13.809  1.00 16.95           C  
ATOM    309  N   CYS A  40      -6.914  31.631 -13.409  1.00 16.33           N  
ATOM    310  CA  CYS A  40      -6.950  33.085 -13.285  1.00 16.68           C  
ATOM    311  C   CYS A  40      -6.088  33.740 -14.355  1.00 16.96           C  
ATOM    312  O   CYS A  40      -6.354  34.864 -14.773  1.00 17.18           O  
ATOM    313  CB  CYS A  40      -6.496  33.517 -11.885  1.00 16.66           C  
ATOM    314  SG  CYS A  40      -7.714  33.110 -10.605  1.00 19.89           S  
ATOM    315  N   GLU A  41      -5.060  33.028 -14.805  1.00 16.89           N  
ATOM    316  CA  GLU A  41      -4.174  33.542 -15.848  1.00 17.72           C  
ATOM    317  C   GLU A  41      -4.793  33.315 -17.224  1.00 17.59           C  
ATOM    318  O   GLU A  41      -4.469  34.012 -18.181  1.00 16.27           O  
ATOM    319  CB  GLU A  41      -2.823  32.824 -15.819  1.00 18.33           C  
ATOM    320  CG  GLU A  41      -2.022  33.002 -14.551  1.00 20.15           C  
ATOM    321  CD  GLU A  41      -0.696  32.263 -14.605  1.00 20.39           C  
ATOM    322  OE1 GLU A  41      -0.626  31.192 -15.255  1.00 22.34           O  
ATOM    323  OE2 GLU A  41       0.272  32.741 -13.987  1.00 22.03           O  
ATOM    324  N   ASN A  42      -5.678  32.326 -17.313  1.00 17.64           N  
ATOM    325  CA  ASN A  42      -6.316  31.965 -18.578  1.00 18.03           C  
ATOM    326  C   ASN A  42      -7.828  31.778 -18.431  1.00 17.08           C  
ATOM    327  O   ASN A  42      -8.333  30.665 -18.570  1.00 16.64           O  
ATOM    328  CB  ASN A  42      -5.701  30.652 -19.088  1.00 18.25           C  
ATOM    329  CG  ASN A  42      -4.188  30.729 -19.250  1.00 19.65           C  
ATOM    330  OD1 ASN A  42      -3.688  31.201 -20.271  1.00 20.02           O  
ATOM    331  ND2 ASN A  42      -3.453  30.263 -18.234  1.00 19.35           N  
ATOM    332  N   PRO A  43      -8.571  32.860 -18.148  1.00 17.17           N  
ATOM    333  CA  PRO A  43     -10.028  32.775 -17.989  1.00 17.25           C  
ATOM    334  C   PRO A  43     -10.709  32.072 -19.160  1.00 17.27           C  
ATOM    335  O   PRO A  43     -10.453  32.392 -20.324  1.00 17.03           O  
ATOM    336  CB  PRO A  43     -10.444  34.237 -17.877  1.00 18.14           C  
ATOM    337  CG  PRO A  43      -9.258  34.868 -17.212  1.00 17.61           C  
ATOM    338  CD  PRO A  43      -8.098  34.238 -17.929  1.00 18.04           C  
ATOM    339  N   GLY A  44     -11.565  31.108 -18.845  1.00 16.70           N  
ATOM    340  CA  GLY A  44     -12.276  30.385 -19.889  1.00 17.43           C  
ATOM    341  C   GLY A  44     -11.534  29.218 -20.510  1.00 17.36           C  
ATOM    342  O   GLY A  44     -12.035  28.590 -21.448  1.00 17.73           O  
ATOM    343  N   ILE A  45     -10.339  28.925 -20.008  1.00 17.20           N  
ATOM    344  CA  ILE A  45      -9.541  27.822 -20.523  1.00 17.99           C  
ATOM    345  C   ILE A  45     -10.306  26.497 -20.380  1.00 18.74           C  
ATOM    346  O   ILE A  45     -11.142  26.355 -19.493  1.00 19.03           O  
ATOM    347  CB  ILE A  45      -8.191  27.729 -19.765  1.00 17.65           C  
ATOM    348  CG1 ILE A  45      -7.336  26.599 -20.339  1.00 17.01           C  
ATOM    349  CG2 ILE A  45      -8.429  27.520 -18.274  1.00 16.39           C  
ATOM    350  CD1 ILE A  45      -5.900  26.652 -19.875  1.00 16.09           C  
ATOM    351  N   ILE A  46     -10.032  25.538 -21.263  1.00 19.85           N  
ATOM    352  CA  ILE A  46     -10.700  24.237 -21.185  1.00 20.59           C  
ATOM    353  C   ILE A  46      -9.813  23.232 -20.461  1.00 20.62           C  
ATOM    354  O   ILE A  46      -8.590  23.352 -20.473  1.00 20.45           O  
ATOM    355  CB  ILE A  46     -11.044  23.682 -22.593  1.00 21.27           C  
ATOM    356  CG1 ILE A  46      -9.771  23.238 -23.312  1.00 22.25           C  
ATOM    357  CG2 ILE A  46     -11.765  24.742 -23.404  1.00 21.74           C  
ATOM    358  CD1 ILE A  46     -10.010  22.697 -24.712  1.00 24.43           C  
ATOM    359  N   GLN A  47     -10.439  22.240 -19.830  1.00 21.78           N  
ATOM    360  CA  GLN A  47      -9.734  21.203 -19.085  1.00 22.70           C  
ATOM    361  C   GLN A  47      -8.556  20.596 -19.840  1.00 23.49           C  
ATOM    362  O   GLN A  47      -7.477  20.404 -19.280  1.00 23.17           O  
ATOM    363  CB  GLN A  47     -10.730  20.107 -18.685  1.00 24.92           C  
ATOM    364  CG  GLN A  47     -10.117  18.840 -18.124  1.00 25.95           C  
ATOM    365  CD  GLN A  47     -11.170  17.782 -17.832  1.00 26.96           C  
ATOM    366  OE1 GLN A  47     -12.103  18.011 -17.058  1.00 28.23           O  
ATOM    367  NE2 GLN A  47     -11.023  16.619 -18.453  1.00 27.37           N  
ATOM    368  N   GLU A  48      -8.764  20.289 -21.114  1.00 23.34           N  
ATOM    369  CA  GLU A  48      -7.713  19.700 -21.919  1.00 24.25           C  
ATOM    370  C   GLU A  48      -6.466  20.572 -21.909  1.00 23.59           C  
ATOM    371  O   GLU A  48      -5.354  20.079 -21.720  1.00 24.40           O  
ATOM    372  CB  GLU A  48      -8.179  19.522 -23.360  1.00 26.01           C  
ATOM    373  CG  GLU A  48      -7.122  18.911 -24.255  1.00 28.32           C  
ATOM    374  CD  GLU A  48      -7.482  18.999 -25.723  1.00 29.83           C  
ATOM    375  OE1 GLU A  48      -7.342  20.097 -26.304  1.00 30.98           O  
ATOM    376  OE2 GLU A  48      -7.912  17.971 -26.295  1.00 31.05           O  
ATOM    377  N   LYS A  49      -6.651  21.872 -22.107  1.00 22.31           N  
ATOM    378  CA  LYS A  49      -5.512  22.773 -22.135  1.00 20.53           C  
ATOM    379  C   LYS A  49      -4.845  22.954 -20.779  1.00 19.23           C  
ATOM    380  O   LYS A  49      -3.627  23.046 -20.704  1.00 18.73           O  
ATOM    381  CB  LYS A  49      -5.901  24.148 -22.683  1.00 20.47           C  
ATOM    382  CG  LYS A  49      -4.696  25.062 -22.830  1.00 21.63           C  
ATOM    383  CD  LYS A  49      -5.014  26.384 -23.498  1.00 22.97           C  
ATOM    384  CE  LYS A  49      -3.717  27.130 -23.824  1.00 23.95           C  
ATOM    385  NZ  LYS A  49      -3.935  28.415 -24.556  1.00 24.88           N  
ATOM    386  N   ILE A  50      -5.622  22.996 -19.703  1.00 18.27           N  
ATOM    387  CA  ILE A  50      -4.999  23.195 -18.402  1.00 18.06           C  
ATOM    388  C   ILE A  50      -4.052  22.046 -18.052  1.00 16.82           C  
ATOM    389  O   ILE A  50      -2.983  22.275 -17.498  1.00 15.20           O  
ATOM    390  CB  ILE A  50      -6.054  23.405 -17.291  1.00 18.33           C  
ATOM    391  CG1 ILE A  50      -5.388  24.042 -16.069  1.00 19.29           C  
ATOM    392  CG2 ILE A  50      -6.690  22.090 -16.900  1.00 19.82           C  
ATOM    393  CD1 ILE A  50      -6.330  24.887 -15.236  1.00 19.78           C  
ATOM    394  N   ALA A  51      -4.433  20.817 -18.397  1.00 16.74           N  
ATOM    395  CA  ALA A  51      -3.595  19.650 -18.120  1.00 16.86           C  
ATOM    396  C   ALA A  51      -2.298  19.761 -18.924  1.00 16.60           C  
ATOM    397  O   ALA A  51      -1.223  19.377 -18.464  1.00 16.78           O  
ATOM    398  CB  ALA A  51      -4.348  18.355 -18.500  1.00 16.32           C  
ATOM    399  N   GLU A  52      -2.409  20.286 -20.136  1.00 17.16           N  
ATOM    400  CA  GLU A  52      -1.253  20.449 -21.003  1.00 18.46           C  
ATOM    401  C   GLU A  52      -0.249  21.460 -20.431  1.00 18.26           C  
ATOM    402  O   GLU A  52       0.966  21.248 -20.483  1.00 18.39           O  
ATOM    403  CB  GLU A  52      -1.733  20.898 -22.385  1.00 20.47           C  
ATOM    404  CG  GLU A  52      -0.650  21.092 -23.421  1.00 23.44           C  
ATOM    405  CD  GLU A  52      -1.228  21.269 -24.814  1.00 25.11           C  
ATOM    406  OE1 GLU A  52      -2.189  22.050 -24.964  1.00 26.72           O  
ATOM    407  OE2 GLU A  52      -0.723  20.632 -25.764  1.00 27.52           O  
ATOM    408  N   LEU A  53      -0.756  22.560 -19.888  1.00 17.95           N  
ATOM    409  CA  LEU A  53       0.105  23.596 -19.319  1.00 18.67           C  
ATOM    410  C   LEU A  53       0.788  23.130 -18.034  1.00 18.10           C  
ATOM    411  O   LEU A  53       1.991  23.349 -17.840  1.00 18.68           O  
ATOM    412  CB  LEU A  53      -0.716  24.862 -19.032  1.00 18.85           C  
ATOM    413  CG  LEU A  53      -1.345  25.507 -20.268  1.00 20.33           C  
ATOM    414  CD1 LEU A  53      -2.201  26.692 -19.867  1.00 20.51           C  
ATOM    415  CD2 LEU A  53      -0.237  25.933 -21.233  1.00 20.64           C  
ATOM    416  N   ILE A  54       0.016  22.488 -17.166  1.00 17.42           N  
ATOM    417  CA  ILE A  54       0.517  22.002 -15.883  1.00 17.21           C  
ATOM    418  C   ILE A  54       1.358  20.727 -16.000  1.00 17.06           C  
ATOM    419  O   ILE A  54       2.101  20.370 -15.071  1.00 17.00           O  
ATOM    420  CB  ILE A  54      -0.665  21.818 -14.908  1.00 17.27           C  
ATOM    421  CG1 ILE A  54      -1.250  23.197 -14.591  1.00 16.93           C  
ATOM    422  CG2 ILE A  54      -0.208  21.152 -13.617  1.00 17.61           C  
ATOM    423  CD1 ILE A  54      -2.529  23.172 -13.759  1.00 17.08           C  
ATOM    424  N   LYS A  55       1.249  20.072 -17.157  1.00 16.25           N  
ATOM    425  CA  LYS A  55       1.987  18.844 -17.487  1.00 17.14           C  
ATOM    426  C   LYS A  55       1.516  17.588 -16.751  1.00 16.60           C  
ATOM    427  O   LYS A  55       2.333  16.805 -16.251  1.00 16.59           O  
ATOM    428  CB  LYS A  55       3.499  19.038 -17.262  1.00 17.66           C  
ATOM    429  CG  LYS A  55       4.105  20.244 -17.998  1.00 19.09           C  
ATOM    430  CD  LYS A  55       3.859  20.159 -19.493  1.00 20.52           C  
ATOM    431  CE  LYS A  55       4.297  21.404 -20.231  1.00 21.25           C  
ATOM    432  NZ  LYS A  55       3.893  21.345 -21.670  1.00 24.89           N  
ATOM    433  N   VAL A  56       0.201  17.393 -16.695  1.00 16.95           N  
ATOM    434  CA  VAL A  56      -0.381  16.225 -16.037  1.00 17.09           C  
ATOM    435  C   VAL A  56      -1.380  15.540 -16.971  1.00 17.92           C  
ATOM    436  O   VAL A  56      -1.807  16.122 -17.969  1.00 17.49           O  
ATOM    437  CB  VAL A  56      -1.108  16.610 -14.706  1.00 17.44           C  
ATOM    438  CG1 VAL A  56      -0.111  17.188 -13.712  1.00 16.56           C  
ATOM    439  CG2 VAL A  56      -2.230  17.609 -14.974  1.00 16.64           C  
ATOM    440  N   ASP A  57      -1.750  14.301 -16.657  1.00 18.88           N  
ATOM    441  CA  ASP A  57      -2.714  13.606 -17.497  1.00 20.33           C  
ATOM    442  C   ASP A  57      -4.070  14.278 -17.325  1.00 20.44           C  
ATOM    443  O   ASP A  57      -4.339  14.902 -16.292  1.00 20.05           O  
ATOM    444  CB  ASP A  57      -2.806  12.123 -17.130  1.00 22.61           C  
ATOM    445  CG  ASP A  57      -3.442  11.891 -15.777  1.00 24.94           C  
ATOM    446  OD1 ASP A  57      -2.768  12.134 -14.757  1.00 27.43           O  
ATOM    447  OD2 ASP A  57      -4.619  11.467 -15.731  1.00 26.37           O  
ATOM    448  N   ARG A  58      -4.923  14.149 -18.336  1.00 20.64           N  
ATOM    449  CA  ARG A  58      -6.244  14.769 -18.312  1.00 21.15           C  
ATOM    450  C   ARG A  58      -7.140  14.355 -17.145  1.00 21.24           C  
ATOM    451  O   ARG A  58      -7.956  15.148 -16.674  1.00 20.91           O  
ATOM    452  CB  ARG A  58      -6.965  14.516 -19.641  1.00 22.19           C  
ATOM    453  CG  ARG A  58      -6.237  15.128 -20.836  1.00 23.73           C  
ATOM    454  CD  ARG A  58      -7.054  15.027 -22.120  1.00 25.80           C  
ATOM    455  NE  ARG A  58      -6.326  15.587 -23.254  1.00 27.54           N  
ATOM    456  CZ  ARG A  58      -6.782  15.612 -24.503  1.00 28.62           C  
ATOM    457  NH1 ARG A  58      -7.979  15.111 -24.791  1.00 29.48           N  
ATOM    458  NH2 ARG A  58      -6.034  16.132 -25.465  1.00 29.49           N  
ATOM    459  N   THR A  59      -6.992  13.128 -16.664  1.00 21.03           N  
ATOM    460  CA  THR A  59      -7.829  12.691 -15.555  1.00 21.47           C  
ATOM    461  C   THR A  59      -7.383  13.320 -14.236  1.00 20.88           C  
ATOM    462  O   THR A  59      -8.208  13.633 -13.385  1.00 21.44           O  
ATOM    463  CB  THR A  59      -7.840  11.171 -15.437  1.00 21.77           C  
ATOM    464  OG1 THR A  59      -8.319  10.614 -16.669  1.00 23.14           O  
ATOM    465  CG2 THR A  59      -8.764  10.739 -14.321  1.00 22.90           C  
ATOM    466  N   THR A  60      -6.080  13.511 -14.070  1.00 20.60           N  
ATOM    467  CA  THR A  60      -5.575  14.141 -12.853  1.00 20.21           C  
ATOM    468  C   THR A  60      -6.112  15.575 -12.797  1.00 19.80           C  
ATOM    469  O   THR A  60      -6.562  16.049 -11.744  1.00 19.54           O  
ATOM    470  CB  THR A  60      -4.032  14.179 -12.833  1.00 20.14           C  
ATOM    471  OG1 THR A  60      -3.521  12.844 -12.718  1.00 21.10           O  
ATOM    472  CG2 THR A  60      -3.530  15.022 -11.655  1.00 19.81           C  
ATOM    473  N   ALA A  61      -6.061  16.262 -13.935  1.00 18.89           N  
ATOM    474  CA  ALA A  61      -6.544  17.638 -14.017  1.00 18.83           C  
ATOM    475  C   ALA A  61      -8.046  17.690 -13.760  1.00 18.60           C  
ATOM    476  O   ALA A  61      -8.542  18.596 -13.088  1.00 18.26           O  
ATOM    477  CB  ALA A  61      -6.221  18.235 -15.396  1.00 18.40           C  
ATOM    478  N   ALA A  62      -8.778  16.722 -14.302  1.00 18.27           N  
ATOM    479  CA  ALA A  62     -10.221  16.685 -14.110  1.00 18.39           C  
ATOM    480  C   ALA A  62     -10.540  16.586 -12.613  1.00 18.57           C  
ATOM    481  O   ALA A  62     -11.449  17.256 -12.113  1.00 18.41           O  
ATOM    482  CB  ALA A  62     -10.823  15.490 -14.867  1.00 18.45           C  
ATOM    483  N   ARG A  63      -9.776  15.755 -11.905  1.00 18.80           N  
ATOM    484  CA  ARG A  63      -9.957  15.566 -10.466  1.00 18.50           C  
ATOM    485  C   ARG A  63      -9.686  16.855  -9.701  1.00 18.14           C  
ATOM    486  O   ARG A  63     -10.444  17.222  -8.807  1.00 18.27           O  
ATOM    487  CB  ARG A  63      -9.013  14.483  -9.941  1.00 19.16           C  
ATOM    488  CG  ARG A  63      -9.333  13.081 -10.411  1.00 19.70           C  
ATOM    489  CD  ARG A  63     -10.660  12.645  -9.871  1.00 21.18           C  
ATOM    490  NE  ARG A  63     -11.026  11.319 -10.346  1.00 21.40           N  
ATOM    491  CZ  ARG A  63     -12.228  10.786 -10.180  1.00 22.45           C  
ATOM    492  NH1 ARG A  63     -13.172  11.470  -9.544  1.00 22.90           N  
ATOM    493  NH2 ARG A  63     -12.490   9.583 -10.665  1.00 22.37           N  
ATOM    494  N   ALA A  64      -8.599  17.531 -10.056  1.00 17.47           N  
ATOM    495  CA  ALA A  64      -8.216  18.772  -9.398  1.00 17.25           C  
ATOM    496  C   ALA A  64      -9.243  19.854  -9.662  1.00 17.22           C  
ATOM    497  O   ALA A  64      -9.631  20.587  -8.753  1.00 17.01           O  
ATOM    498  CB  ALA A  64      -6.845  19.224  -9.889  1.00 17.21           C  
ATOM    499  N   ILE A  65      -9.672  19.958 -10.917  1.00 16.98           N  
ATOM    500  CA  ILE A  65     -10.658  20.956 -11.303  1.00 17.07           C  
ATOM    501  C   ILE A  65     -11.986  20.672 -10.611  1.00 17.01           C  
ATOM    502  O   ILE A  65     -12.702  21.591 -10.222  1.00 17.31           O  
ATOM    503  CB  ILE A  65     -10.855  20.971 -12.839  1.00 17.45           C  
ATOM    504  CG1 ILE A  65      -9.588  21.510 -13.508  1.00 17.58           C  
ATOM    505  CG2 ILE A  65     -12.044  21.838 -13.218  1.00 17.74           C  
ATOM    506  CD1 ILE A  65      -9.121  22.866 -12.967  1.00 18.08           C  
ATOM    507  N   LYS A  66     -12.303  19.392 -10.454  1.00 17.61           N  
ATOM    508  CA  LYS A  66     -13.538  18.987  -9.795  1.00 18.83           C  
ATOM    509  C   LYS A  66     -13.520  19.404  -8.329  1.00 19.25           C  
ATOM    510  O   LYS A  66     -14.531  19.862  -7.787  1.00 18.12           O  
ATOM    511  CB  LYS A  66     -13.698  17.474  -9.879  1.00 20.10           C  
ATOM    512  CG  LYS A  66     -14.936  16.944  -9.188  1.00 22.14           C  
ATOM    513  CD  LYS A  66     -16.187  17.353  -9.933  1.00 23.99           C  
ATOM    514  CE  LYS A  66     -17.107  16.153 -10.104  1.00 25.00           C  
ATOM    515  NZ  LYS A  66     -16.421  15.033 -10.822  1.00 25.77           N  
ATOM    516  N   ARG A  67     -12.371  19.230  -7.683  1.00 19.26           N  
ATOM    517  CA  ARG A  67     -12.244  19.595  -6.276  1.00 19.36           C  
ATOM    518  C   ARG A  67     -12.330  21.118  -6.107  1.00 19.19           C  
ATOM    519  O   ARG A  67     -12.968  21.611  -5.175  1.00 19.10           O  
ATOM    520  CB  ARG A  67     -10.930  19.050  -5.706  1.00 19.37           C  
ATOM    521  CG  ARG A  67     -10.742  19.276  -4.205  1.00 19.58           C  
ATOM    522  CD  ARG A  67     -11.921  18.727  -3.392  1.00 19.78           C  
ATOM    523  NE  ARG A  67     -11.706  18.909  -1.959  1.00 20.02           N  
ATOM    524  CZ  ARG A  67     -12.652  18.787  -1.030  1.00 18.94           C  
ATOM    525  NH1 ARG A  67     -13.896  18.483  -1.368  1.00 19.34           N  
ATOM    526  NH2 ARG A  67     -12.345  18.965   0.248  1.00 20.35           N  
ATOM    527  N   LEU A  68     -11.704  21.865  -7.011  1.00 18.87           N  
ATOM    528  CA  LEU A  68     -11.747  23.323  -6.940  1.00 18.62           C  
ATOM    529  C   LEU A  68     -13.180  23.819  -7.068  1.00 18.88           C  
ATOM    530  O   LEU A  68     -13.578  24.770  -6.405  1.00 18.15           O  
ATOM    531  CB  LEU A  68     -10.921  23.946  -8.057  1.00 19.52           C  
ATOM    532  CG  LEU A  68      -9.407  23.991  -7.886  1.00 20.02           C  
ATOM    533  CD1 LEU A  68      -8.792  24.597  -9.143  1.00 21.47           C  
ATOM    534  CD2 LEU A  68      -9.047  24.799  -6.632  1.00 19.69           C  
ATOM    535  N   GLU A  69     -13.956  23.176  -7.933  1.00 19.06           N  
ATOM    536  CA  GLU A  69     -15.339  23.578  -8.116  1.00 20.00           C  
ATOM    537  C   GLU A  69     -16.129  23.312  -6.832  1.00 19.84           C  
ATOM    538  O   GLU A  69     -16.916  24.151  -6.393  1.00 19.66           O  
ATOM    539  CB  GLU A  69     -15.941  22.819  -9.295  1.00 21.00           C  
ATOM    540  CG  GLU A  69     -17.357  23.222  -9.649  1.00 23.64           C  
ATOM    541  CD  GLU A  69     -17.763  22.695 -11.008  1.00 25.57           C  
ATOM    542  OE1 GLU A  69     -17.504  21.507 -11.284  1.00 26.73           O  
ATOM    543  OE2 GLU A  69     -18.342  23.468 -11.799  1.00 27.57           O  
ATOM    544  N   GLU A  70     -15.905  22.148  -6.230  1.00 19.83           N  
ATOM    545  CA  GLU A  70     -16.598  21.780  -5.002  1.00 20.77           C  
ATOM    546  C   GLU A  70     -16.233  22.726  -3.868  1.00 20.48           C  
ATOM    547  O   GLU A  70     -17.064  23.027  -3.018  1.00 20.43           O  
ATOM    548  CB  GLU A  70     -16.259  20.340  -4.599  1.00 21.96           C  
ATOM    549  CG  GLU A  70     -16.580  19.305  -5.660  1.00 24.68           C  
ATOM    550  CD  GLU A  70     -16.187  17.892  -5.249  1.00 26.28           C  
ATOM    551  OE1 GLU A  70     -15.243  17.730  -4.439  1.00 26.92           O  
ATOM    552  OE2 GLU A  70     -16.817  16.937  -5.758  1.00 27.43           O  
ATOM    553  N   GLN A  71     -14.988  23.196  -3.845  1.00 20.20           N  
ATOM    554  CA  GLN A  71     -14.579  24.112  -2.789  1.00 19.71           C  
ATOM    555  C   GLN A  71     -14.853  25.578  -3.137  1.00 19.25           C  
ATOM    556  O   GLN A  71     -14.375  26.488  -2.453  1.00 19.96           O  
ATOM    557  CB  GLN A  71     -13.106  23.887  -2.421  1.00 20.01           C  
ATOM    558  CG  GLN A  71     -12.849  22.487  -1.876  1.00 20.80           C  
ATOM    559  CD  GLN A  71     -11.544  22.362  -1.105  1.00 21.52           C  
ATOM    560  OE1 GLN A  71     -11.529  22.390   0.127  1.00 22.53           O  
ATOM    561  NE2 GLN A  71     -10.448  22.225  -1.826  1.00 21.64           N  
ATOM    562  N   GLY A  72     -15.628  25.782  -4.203  1.00 18.55           N  
ATOM    563  CA  GLY A  72     -16.049  27.108  -4.642  1.00 17.08           C  
ATOM    564  C   GLY A  72     -15.058  28.099  -5.223  1.00 17.05           C  
ATOM    565  O   GLY A  72     -15.307  29.307  -5.187  1.00 16.83           O  
ATOM    566  N   PHE A  73     -13.961  27.597  -5.783  1.00 16.49           N  
ATOM    567  CA  PHE A  73     -12.913  28.432  -6.360  1.00 16.46           C  
ATOM    568  C   PHE A  73     -13.121  28.716  -7.839  1.00 16.40           C  
ATOM    569  O   PHE A  73     -12.668  29.737  -8.348  1.00 15.13           O  
ATOM    570  CB  PHE A  73     -11.554  27.752  -6.195  1.00 16.83           C  
ATOM    571  CG  PHE A  73     -11.028  27.766  -4.789  1.00 17.21           C  
ATOM    572  CD1 PHE A  73     -10.545  28.941  -4.229  1.00 16.80           C  
ATOM    573  CD2 PHE A  73     -10.993  26.596  -4.034  1.00 17.10           C  
ATOM    574  CE1 PHE A  73     -10.028  28.949  -2.931  1.00 17.34           C  
ATOM    575  CE2 PHE A  73     -10.478  26.598  -2.734  1.00 17.33           C  
ATOM    576  CZ  PHE A  73      -9.994  27.774  -2.186  1.00 17.19           C  
ATOM    577  N   ILE A  74     -13.802  27.808  -8.525  1.00 16.88           N  
ATOM    578  CA  ILE A  74     -14.037  27.968  -9.951  1.00 17.01           C  
ATOM    579  C   ILE A  74     -15.415  27.471 -10.341  1.00 16.97           C  
ATOM    580  O   ILE A  74     -16.096  26.808  -9.555  1.00 16.22           O  
ATOM    581  CB  ILE A  74     -13.005  27.157 -10.776  1.00 17.14           C  
ATOM    582  CG1 ILE A  74     -13.141  25.663 -10.456  1.00 18.02           C  
ATOM    583  CG2 ILE A  74     -11.589  27.600 -10.440  1.00 16.93           C  
ATOM    584  CD1 ILE A  74     -12.177  24.761 -11.201  1.00 20.17           C  
ATOM    585  N   TYR A  75     -15.834  27.823 -11.551  1.00 16.95           N  
ATOM    586  CA  TYR A  75     -17.096  27.324 -12.081  1.00 17.93           C  
ATOM    587  C   TYR A  75     -16.833  26.990 -13.545  1.00 18.49           C  
ATOM    588  O   TYR A  75     -15.878  27.491 -14.140  1.00 17.37           O  
ATOM    589  CB  TYR A  75     -18.254  28.325 -11.925  1.00 18.62           C  
ATOM    590  CG  TYR A  75     -18.180  29.589 -12.746  1.00 19.46           C  
ATOM    591  CD1 TYR A  75     -17.536  30.725 -12.257  1.00 19.98           C  
ATOM    592  CD2 TYR A  75     -18.795  29.663 -13.996  1.00 20.24           C  
ATOM    593  CE1 TYR A  75     -17.514  31.907 -12.983  1.00 20.40           C  
ATOM    594  CE2 TYR A  75     -18.775  30.845 -14.740  1.00 20.74           C  
ATOM    595  CZ  TYR A  75     -18.135  31.961 -14.227  1.00 20.40           C  
ATOM    596  OH  TYR A  75     -18.118  33.129 -14.952  1.00 21.85           O  
ATOM    597  N   ARG A  76     -17.666  26.126 -14.115  1.00 19.30           N  
ATOM    598  CA  ARG A  76     -17.484  25.704 -15.496  1.00 20.55           C  
ATOM    599  C   ARG A  76     -18.721  25.909 -16.343  1.00 21.60           C  
ATOM    600  O   ARG A  76     -19.791  25.387 -16.027  1.00 23.08           O  
ATOM    601  CB  ARG A  76     -17.094  24.227 -15.538  1.00 20.79           C  
ATOM    602  CG  ARG A  76     -15.796  23.912 -14.820  1.00 21.40           C  
ATOM    603  CD  ARG A  76     -15.417  22.462 -15.012  1.00 23.24           C  
ATOM    604  NE  ARG A  76     -16.386  21.564 -14.393  1.00 24.42           N  
ATOM    605  CZ  ARG A  76     -16.608  20.322 -14.806  1.00 25.90           C  
ATOM    606  NH1 ARG A  76     -15.931  19.834 -15.838  1.00 26.42           N  
ATOM    607  NH2 ARG A  76     -17.514  19.567 -14.196  1.00 26.32           N  
ATOM    608  N   GLN A  77     -18.580  26.657 -17.430  1.00 21.17           N  
ATOM    609  CA  GLN A  77     -19.719  26.892 -18.303  1.00 21.62           C  
ATOM    610  C   GLN A  77     -19.596  26.037 -19.559  1.00 20.86           C  
ATOM    611  O   GLN A  77     -18.550  26.021 -20.213  1.00 19.87           O  
ATOM    612  CB  GLN A  77     -19.825  28.374 -18.673  1.00 23.09           C  
ATOM    613  CG  GLN A  77     -18.749  28.875 -19.598  1.00 25.10           C  
ATOM    614  CD  GLN A  77     -19.055  30.256 -20.152  1.00 25.98           C  
ATOM    615  OE1 GLN A  77     -18.455  30.684 -21.139  1.00 26.21           O  
ATOM    616  NE2 GLN A  77     -19.989  30.963 -19.513  1.00 26.77           N  
ATOM    617  N   GLU A  78     -20.666  25.317 -19.882  1.00 21.40           N  
ATOM    618  CA  GLU A  78     -20.682  24.452 -21.056  1.00 22.37           C  
ATOM    619  C   GLU A  78     -20.817  25.272 -22.328  1.00 21.96           C  
ATOM    620  O   GLU A  78     -21.565  26.253 -22.370  1.00 21.38           O  
ATOM    621  CB  GLU A  78     -21.848  23.459 -20.981  1.00 23.64           C  
ATOM    622  CG  GLU A  78     -21.914  22.655 -19.693  1.00 25.94           C  
ATOM    623  CD  GLU A  78     -23.004  21.603 -19.726  1.00 27.05           C  
ATOM    624  OE1 GLU A  78     -24.064  21.869 -20.328  1.00 29.08           O  
ATOM    625  OE2 GLU A  78     -22.805  20.512 -19.144  1.00 28.56           O  
ATOM    626  N   ASP A  79     -20.092  24.863 -23.361  1.00 22.44           N  
ATOM    627  CA  ASP A  79     -20.133  25.540 -24.651  1.00 21.98           C  
ATOM    628  C   ASP A  79     -21.496  25.274 -25.296  1.00 22.55           C  
ATOM    629  O   ASP A  79     -22.065  24.196 -25.125  1.00 22.54           O  
ATOM    630  CB  ASP A  79     -19.017  25.004 -25.554  1.00 22.93           C  
ATOM    631  CG  ASP A  79     -19.007  25.654 -26.921  1.00 23.77           C  
ATOM    632  OD1 ASP A  79     -18.633  26.845 -27.019  1.00 24.84           O  
ATOM    633  OD2 ASP A  79     -19.387  24.977 -27.904  1.00 25.20           O  
ATOM    634  N   ALA A  80     -22.009  26.255 -26.036  1.00 22.21           N  
ATOM    635  CA  ALA A  80     -23.304  26.126 -26.700  1.00 23.07           C  
ATOM    636  C   ALA A  80     -23.304  25.083 -27.818  1.00 23.37           C  
ATOM    637  O   ALA A  80     -24.244  24.302 -27.956  1.00 23.71           O  
ATOM    638  CB  ALA A  80     -23.727  27.472 -27.259  1.00 23.11           C  
ATOM    639  N   SER A  81     -22.249  25.073 -28.621  1.00 23.61           N  
ATOM    640  CA  SER A  81     -22.153  24.129 -29.727  1.00 24.08           C  
ATOM    641  C   SER A  81     -21.845  22.701 -29.284  1.00 23.90           C  
ATOM    642  O   SER A  81     -22.270  21.740 -29.923  1.00 24.18           O  
ATOM    643  CB  SER A  81     -21.080  24.593 -30.711  1.00 24.91           C  
ATOM    644  OG  SER A  81     -21.354  25.906 -31.169  1.00 27.16           O  
ATOM    645  N   ASN A  82     -21.107  22.559 -28.188  1.00 23.57           N  
ATOM    646  CA  ASN A  82     -20.730  21.240 -27.710  1.00 22.62           C  
ATOM    647  C   ASN A  82     -20.695  21.173 -26.190  1.00 22.53           C  
ATOM    648  O   ASN A  82     -19.694  21.522 -25.560  1.00 21.39           O  
ATOM    649  CB  ASN A  82     -19.367  20.870 -28.298  1.00 22.32           C  
ATOM    650  CG  ASN A  82     -18.872  19.526 -27.822  1.00 22.05           C  
ATOM    651  OD1 ASN A  82     -19.617  18.753 -27.213  1.00 22.79           O  
ATOM    652  ND2 ASN A  82     -17.612  19.229 -28.110  1.00 22.02           N  
ATOM    653  N   LYS A  83     -21.806  20.710 -25.622  1.00 22.43           N  
ATOM    654  CA  LYS A  83     -22.001  20.583 -24.181  1.00 22.94           C  
ATOM    655  C   LYS A  83     -20.828  19.939 -23.430  1.00 22.41           C  
ATOM    656  O   LYS A  83     -20.604  20.227 -22.253  1.00 23.21           O  
ATOM    657  CB  LYS A  83     -23.294  19.786 -23.931  1.00 23.46           C  
ATOM    658  CG  LYS A  83     -23.780  19.751 -22.485  1.00 25.36           C  
ATOM    659  CD  LYS A  83     -23.016  18.740 -21.628  1.00 27.32           C  
ATOM    660  CE  LYS A  83     -23.353  17.300 -22.005  1.00 27.61           C  
ATOM    661  NZ  LYS A  83     -22.755  16.340 -21.030  1.00 28.64           N  
ATOM    662  N   LYS A  84     -20.077  19.080 -24.109  1.00 22.93           N  
ATOM    663  CA  LYS A  84     -18.955  18.385 -23.486  1.00 22.89           C  
ATOM    664  C   LYS A  84     -17.703  19.235 -23.290  1.00 21.96           C  
ATOM    665  O   LYS A  84     -16.760  18.814 -22.622  1.00 22.37           O  
ATOM    666  CB  LYS A  84     -18.608  17.136 -24.299  1.00 23.59           C  
ATOM    667  CG  LYS A  84     -19.785  16.191 -24.477  1.00 24.05           C  
ATOM    668  CD  LYS A  84     -19.380  14.960 -25.253  1.00 24.56           C  
ATOM    669  CE  LYS A  84     -20.522  13.966 -25.333  1.00 24.74           C  
ATOM    670  NZ  LYS A  84     -21.052  13.591 -23.982  1.00 25.52           N  
ATOM    671  N   ILE A  85     -17.688  20.420 -23.889  1.00 21.00           N  
ATOM    672  CA  ILE A  85     -16.564  21.334 -23.745  1.00 20.28           C  
ATOM    673  C   ILE A  85     -16.927  22.325 -22.637  1.00 19.93           C  
ATOM    674  O   ILE A  85     -17.960  22.989 -22.705  1.00 19.55           O  
ATOM    675  CB  ILE A  85     -16.308  22.113 -25.048  1.00 20.93           C  
ATOM    676  CG1 ILE A  85     -15.909  21.140 -26.167  1.00 20.77           C  
ATOM    677  CG2 ILE A  85     -15.215  23.155 -24.825  1.00 21.62           C  
ATOM    678  CD1 ILE A  85     -15.853  21.777 -27.553  1.00 22.56           C  
ATOM    679  N   LYS A  86     -16.088  22.419 -21.611  1.00 18.96           N  
ATOM    680  CA  LYS A  86     -16.358  23.337 -20.511  1.00 19.21           C  
ATOM    681  C   LYS A  86     -15.235  24.352 -20.328  1.00 18.25           C  
ATOM    682  O   LYS A  86     -14.061  23.993 -20.252  1.00 18.07           O  
ATOM    683  CB  LYS A  86     -16.580  22.547 -19.215  1.00 20.14           C  
ATOM    684  CG  LYS A  86     -17.843  21.694 -19.234  1.00 22.34           C  
ATOM    685  CD  LYS A  86     -17.873  20.668 -18.113  1.00 23.68           C  
ATOM    686  CE  LYS A  86     -19.139  19.825 -18.195  1.00 24.51           C  
ATOM    687  NZ  LYS A  86     -19.356  19.282 -19.572  1.00 25.12           N  
ATOM    688  N   ARG A  87     -15.604  25.627 -20.284  1.00 17.22           N  
ATOM    689  CA  ARG A  87     -14.631  26.694 -20.095  1.00 16.73           C  
ATOM    690  C   ARG A  87     -14.625  27.001 -18.607  1.00 16.32           C  
ATOM    691  O   ARG A  87     -15.669  27.215 -18.008  1.00 15.70           O  
ATOM    692  CB  ARG A  87     -15.021  27.921 -20.910  1.00 17.17           C  
ATOM    693  CG  ARG A  87     -14.893  27.700 -22.405  1.00 19.70           C  
ATOM    694  CD  ARG A  87     -15.245  28.960 -23.151  1.00 20.51           C  
ATOM    695  NE  ARG A  87     -16.672  29.250 -23.082  1.00 23.43           N  
ATOM    696  CZ  ARG A  87     -17.588  28.666 -23.851  1.00 23.90           C  
ATOM    697  NH1 ARG A  87     -17.230  27.756 -24.754  1.00 23.24           N  
ATOM    698  NH2 ARG A  87     -18.865  28.998 -23.723  1.00 24.63           N  
ATOM    699  N   ILE A  88     -13.435  27.031 -18.025  1.00 16.05           N  
ATOM    700  CA  ILE A  88     -13.267  27.233 -16.590  1.00 15.58           C  
ATOM    701  C   ILE A  88     -12.965  28.668 -16.196  1.00 14.93           C  
ATOM    702  O   ILE A  88     -12.064  29.286 -16.751  1.00 14.52           O  
ATOM    703  CB  ILE A  88     -12.139  26.318 -16.081  1.00 15.79           C  
ATOM    704  CG1 ILE A  88     -12.419  24.879 -16.525  1.00 15.42           C  
ATOM    705  CG2 ILE A  88     -12.045  26.381 -14.570  1.00 15.26           C  
ATOM    706  CD1 ILE A  88     -11.243  23.934 -16.353  1.00 17.85           C  
ATOM    707  N   TYR A  89     -13.716  29.177 -15.221  1.00 14.93           N  
ATOM    708  CA  TYR A  89     -13.560  30.547 -14.735  1.00 14.49           C  
ATOM    709  C   TYR A  89     -13.469  30.585 -13.224  1.00 14.77           C  
ATOM    710  O   TYR A  89     -14.056  29.755 -12.540  1.00 14.47           O  
ATOM    711  CB  TYR A  89     -14.759  31.402 -15.136  1.00 15.86           C  
ATOM    712  CG  TYR A  89     -14.978  31.517 -16.619  1.00 16.84           C  
ATOM    713  CD1 TYR A  89     -14.327  32.492 -17.363  1.00 17.46           C  
ATOM    714  CD2 TYR A  89     -15.833  30.635 -17.282  1.00 18.14           C  
ATOM    715  CE1 TYR A  89     -14.524  32.592 -18.737  1.00 19.96           C  
ATOM    716  CE2 TYR A  89     -16.031  30.726 -18.657  1.00 19.26           C  
ATOM    717  CZ  TYR A  89     -15.375  31.705 -19.372  1.00 19.98           C  
ATOM    718  OH  TYR A  89     -15.572  31.801 -20.732  1.00 21.81           O  
ATOM    719  N   ALA A  90     -12.751  31.569 -12.706  1.00 14.84           N  
ATOM    720  CA  ALA A  90     -12.631  31.718 -11.266  1.00 14.67           C  
ATOM    721  C   ALA A  90     -13.877  32.385 -10.709  1.00 14.98           C  
ATOM    722  O   ALA A  90     -14.457  33.279 -11.331  1.00 14.75           O  
ATOM    723  CB  ALA A  90     -11.402  32.558 -10.922  1.00 14.17           C  
ATOM    724  N   THR A  91     -14.294  31.921  -9.540  1.00 14.78           N  
ATOM    725  CA  THR A  91     -15.429  32.495  -8.843  1.00 15.79           C  
ATOM    726  C   THR A  91     -14.883  33.719  -8.101  1.00 16.49           C  
ATOM    727  O   THR A  91     -13.688  34.036  -8.195  1.00 16.15           O  
ATOM    728  CB  THR A  91     -15.978  31.528  -7.787  1.00 15.91           C  
ATOM    729  OG1 THR A  91     -14.937  31.219  -6.850  1.00 15.53           O  
ATOM    730  CG2 THR A  91     -16.469  30.231  -8.434  1.00 15.52           C  
ATOM    731  N   GLU A  92     -15.754  34.405  -7.369  1.00 17.67           N  
ATOM    732  CA  GLU A  92     -15.334  35.564  -6.587  1.00 18.63           C  
ATOM    733  C   GLU A  92     -14.267  35.112  -5.586  1.00 18.28           C  
ATOM    734  O   GLU A  92     -13.268  35.805  -5.372  1.00 17.97           O  
ATOM    735  CB  GLU A  92     -16.531  36.172  -5.839  1.00 19.87           C  
ATOM    736  CG  GLU A  92     -16.142  37.235  -4.803  1.00 22.69           C  
ATOM    737  CD  GLU A  92     -17.341  37.836  -4.079  1.00 24.59           C  
ATOM    738  OE1 GLU A  92     -18.292  37.083  -3.775  1.00 25.29           O  
ATOM    739  OE2 GLU A  92     -17.320  39.060  -3.797  1.00 25.36           O  
ATOM    740  N   LYS A  93     -14.476  33.946  -4.978  1.00 17.79           N  
ATOM    741  CA  LYS A  93     -13.521  33.412  -4.003  1.00 17.67           C  
ATOM    742  C   LYS A  93     -12.165  33.144  -4.657  1.00 17.53           C  
ATOM    743  O   LYS A  93     -11.116  33.473  -4.099  1.00 17.44           O  
ATOM    744  CB  LYS A  93     -14.074  32.120  -3.394  1.00 18.45           C  
ATOM    745  CG  LYS A  93     -13.158  31.429  -2.397  1.00 19.66           C  
ATOM    746  CD  LYS A  93     -13.844  30.204  -1.799  1.00 19.95           C  
ATOM    747  CE  LYS A  93     -12.928  29.468  -0.832  1.00 21.87           C  
ATOM    748  NZ  LYS A  93     -13.588  28.260  -0.248  1.00 21.83           N  
ATOM    749  N   GLY A  94     -12.191  32.551  -5.846  1.00 17.00           N  
ATOM    750  CA  GLY A  94     -10.953  32.254  -6.541  1.00 16.30           C  
ATOM    751  C   GLY A  94     -10.173  33.501  -6.879  1.00 16.36           C  
ATOM    752  O   GLY A  94      -8.950  33.538  -6.717  1.00 15.56           O  
ATOM    753  N   LYS A  95     -10.878  34.533  -7.332  1.00 17.01           N  
ATOM    754  CA  LYS A  95     -10.230  35.787  -7.695  1.00 17.45           C  
ATOM    755  C   LYS A  95      -9.655  36.505  -6.481  1.00 18.20           C  
ATOM    756  O   LYS A  95      -8.591  37.132  -6.566  1.00 18.95           O  
ATOM    757  CB  LYS A  95     -11.224  36.693  -8.431  1.00 17.90           C  
ATOM    758  CG  LYS A  95     -11.664  36.112  -9.773  1.00 18.89           C  
ATOM    759  CD  LYS A  95     -12.603  37.028 -10.551  1.00 19.99           C  
ATOM    760  CE  LYS A  95     -14.020  37.005 -10.003  1.00 21.38           C  
ATOM    761  NZ  LYS A  95     -14.983  37.686 -10.933  1.00 21.53           N  
ATOM    762  N   ASN A  96     -10.347  36.405  -5.350  1.00 18.36           N  
ATOM    763  CA  ASN A  96      -9.887  37.055  -4.128  1.00 19.16           C  
ATOM    764  C   ASN A  96      -8.638  36.406  -3.556  1.00 19.25           C  
ATOM    765  O   ASN A  96      -7.792  37.093  -2.982  1.00 18.66           O  
ATOM    766  CB  ASN A  96     -10.983  37.044  -3.050  1.00 21.55           C  
ATOM    767  CG  ASN A  96     -12.048  38.105  -3.276  1.00 23.27           C  
ATOM    768  OD1 ASN A  96     -11.818  39.108  -3.958  1.00 25.26           O  
ATOM    769  ND2 ASN A  96     -13.215  37.902  -2.674  1.00 24.41           N  
ATOM    770  N   VAL A  97      -8.526  35.087  -3.711  1.00 18.26           N  
ATOM    771  CA  VAL A  97      -7.388  34.344  -3.178  1.00 18.39           C  
ATOM    772  C   VAL A  97      -6.184  34.337  -4.114  1.00 17.92           C  
ATOM    773  O   VAL A  97      -5.037  34.324  -3.662  1.00 17.95           O  
ATOM    774  CB  VAL A  97      -7.804  32.890  -2.844  1.00 18.69           C  
ATOM    775  CG1 VAL A  97      -6.602  32.082  -2.383  1.00 19.50           C  
ATOM    776  CG2 VAL A  97      -8.870  32.909  -1.752  1.00 19.02           C  
ATOM    777  N   TYR A  98      -6.451  34.351  -5.415  1.00 17.44           N  
ATOM    778  CA  TYR A  98      -5.399  34.344  -6.428  1.00 17.60           C  
ATOM    779  C   TYR A  98      -4.204  35.270  -6.109  1.00 17.73           C  
ATOM    780  O   TYR A  98      -3.053  34.828  -6.119  1.00 18.10           O  
ATOM    781  CB  TYR A  98      -6.028  34.693  -7.788  1.00 18.82           C  
ATOM    782  CG  TYR A  98      -5.048  34.966  -8.905  1.00 19.68           C  
ATOM    783  CD1 TYR A  98      -4.144  33.992  -9.328  1.00 20.05           C  
ATOM    784  CD2 TYR A  98      -5.011  36.214  -9.525  1.00 20.25           C  
ATOM    785  CE1 TYR A  98      -3.226  34.255 -10.333  1.00 20.56           C  
ATOM    786  CE2 TYR A  98      -4.096  36.489 -10.532  1.00 21.44           C  
ATOM    787  CZ  TYR A  98      -3.204  35.507 -10.929  1.00 21.28           C  
ATOM    788  OH  TYR A  98      -2.268  35.788 -11.897  1.00 24.07           O  
ATOM    789  N   PRO A  99      -4.459  36.553  -5.790  1.00 18.15           N  
ATOM    790  CA  PRO A  99      -3.354  37.474  -5.482  1.00 19.13           C  
ATOM    791  C   PRO A  99      -2.426  36.964  -4.380  1.00 19.44           C  
ATOM    792  O   PRO A  99      -1.202  37.137  -4.448  1.00 19.98           O  
ATOM    793  CB  PRO A  99      -4.078  38.760  -5.068  1.00 18.69           C  
ATOM    794  CG  PRO A  99      -5.391  38.664  -5.796  1.00 19.61           C  
ATOM    795  CD  PRO A  99      -5.756  37.221  -5.612  1.00 18.33           C  
ATOM    796  N   ILE A 100      -3.005  36.348  -3.358  1.00 19.78           N  
ATOM    797  CA  ILE A 100      -2.220  35.807  -2.258  1.00 19.80           C  
ATOM    798  C   ILE A 100      -1.276  34.741  -2.809  1.00 19.47           C  
ATOM    799  O   ILE A 100      -0.078  34.741  -2.519  1.00 19.23           O  
ATOM    800  CB  ILE A 100      -3.127  35.164  -1.177  1.00 20.60           C  
ATOM    801  CG1 ILE A 100      -3.927  36.251  -0.456  1.00 21.48           C  
ATOM    802  CG2 ILE A 100      -2.287  34.374  -0.184  1.00 20.51           C  
ATOM    803  CD1 ILE A 100      -4.940  35.700   0.527  1.00 21.72           C  
ATOM    804  N   ILE A 101      -1.820  33.831  -3.610  1.00 18.91           N  
ATOM    805  CA  ILE A 101      -1.010  32.769  -4.198  1.00 18.15           C  
ATOM    806  C   ILE A 101       0.104  33.357  -5.070  1.00 18.30           C  
ATOM    807  O   ILE A 101       1.248  32.917  -4.993  1.00 18.47           O  
ATOM    808  CB  ILE A 101      -1.875  31.826  -5.062  1.00 17.75           C  
ATOM    809  CG1 ILE A 101      -3.089  31.358  -4.256  1.00 18.12           C  
ATOM    810  CG2 ILE A 101      -1.049  30.633  -5.518  1.00 17.92           C  
ATOM    811  CD1 ILE A 101      -2.749  30.640  -2.982  1.00 17.99           C  
ATOM    812  N   VAL A 102      -0.234  34.355  -5.880  1.00 18.08           N  
ATOM    813  CA  VAL A 102       0.738  35.002  -6.761  1.00 18.89           C  
ATOM    814  C   VAL A 102       1.919  35.540  -5.952  1.00 19.61           C  
ATOM    815  O   VAL A 102       3.086  35.337  -6.312  1.00 19.77           O  
ATOM    816  CB  VAL A 102       0.103  36.183  -7.522  1.00 19.29           C  
ATOM    817  CG1 VAL A 102       1.154  36.884  -8.374  1.00 19.44           C  
ATOM    818  CG2 VAL A 102      -1.040  35.687  -8.392  1.00 19.67           C  
ATOM    819  N   ARG A 103       1.616  36.226  -4.855  1.00 19.67           N  
ATOM    820  CA  ARG A 103       2.670  36.794  -4.022  1.00 19.19           C  
ATOM    821  C   ARG A 103       3.423  35.726  -3.231  1.00 19.36           C  
ATOM    822  O   ARG A 103       4.625  35.858  -2.985  1.00 19.66           O  
ATOM    823  CB  ARG A 103       2.082  37.876  -3.107  1.00 19.19           C  
ATOM    824  CG  ARG A 103       1.584  39.088  -3.898  1.00 19.43           C  
ATOM    825  CD  ARG A 103       1.164  40.230  -2.991  1.00 19.99           C  
ATOM    826  NE  ARG A 103      -0.125  40.020  -2.336  1.00 19.71           N  
ATOM    827  CZ  ARG A 103      -1.295  40.434  -2.820  1.00 19.77           C  
ATOM    828  NH1 ARG A 103      -1.359  41.081  -3.978  1.00 20.62           N  
ATOM    829  NH2 ARG A 103      -2.408  40.220  -2.131  1.00 21.05           N  
ATOM    830  N   GLU A 104       2.739  34.654  -2.847  1.00 19.50           N  
ATOM    831  CA  GLU A 104       3.412  33.588  -2.117  1.00 20.14           C  
ATOM    832  C   GLU A 104       4.398  32.866  -3.039  1.00 20.17           C  
ATOM    833  O   GLU A 104       5.479  32.456  -2.603  1.00 20.06           O  
ATOM    834  CB  GLU A 104       2.395  32.602  -1.539  1.00 20.39           C  
ATOM    835  CG  GLU A 104       1.698  33.117  -0.276  1.00 21.56           C  
ATOM    836  CD  GLU A 104       2.678  33.399   0.861  1.00 22.17           C  
ATOM    837  OE1 GLU A 104       3.326  32.446   1.334  1.00 22.76           O  
ATOM    838  OE2 GLU A 104       2.802  34.571   1.282  1.00 22.77           O  
ATOM    839  N   ASN A 105       4.028  32.722  -4.311  1.00 20.75           N  
ATOM    840  CA  ASN A 105       4.899  32.071  -5.287  1.00 21.74           C  
ATOM    841  C   ASN A 105       6.124  32.956  -5.533  1.00 21.71           C  
ATOM    842  O   ASN A 105       7.247  32.454  -5.657  1.00 21.35           O  
ATOM    843  CB  ASN A 105       4.160  31.829  -6.613  1.00 22.94           C  
ATOM    844  CG  ASN A 105       3.132  30.704  -6.525  1.00 24.93           C  
ATOM    845  OD1 ASN A 105       3.266  29.783  -5.718  1.00 26.15           O  
ATOM    846  ND2 ASN A 105       2.111  30.764  -7.380  1.00 25.79           N  
ATOM    847  N   GLN A 106       5.904  34.269  -5.604  1.00 21.23           N  
ATOM    848  CA  GLN A 106       6.992  35.224  -5.819  1.00 20.92           C  
ATOM    849  C   GLN A 106       7.986  35.121  -4.671  1.00 20.33           C  
ATOM    850  O   GLN A 106       9.201  35.207  -4.871  1.00 20.62           O  
ATOM    851  CB  GLN A 106       6.450  36.660  -5.888  1.00 22.33           C  
ATOM    852  CG  GLN A 106       5.611  36.968  -7.120  1.00 24.38           C  
ATOM    853  CD  GLN A 106       4.969  38.351  -7.071  1.00 24.88           C  
ATOM    854  OE1 GLN A 106       4.392  38.812  -8.056  1.00 26.32           O  
ATOM    855  NE2 GLN A 106       5.055  39.009  -5.919  1.00 25.47           N  
ATOM    856  N   HIS A 107       7.467  34.943  -3.460  1.00 19.71           N  
ATOM    857  CA  HIS A 107       8.328  34.827  -2.294  1.00 19.56           C  
ATOM    858  C   HIS A 107       9.139  33.539  -2.353  1.00 19.10           C  
ATOM    859  O   HIS A 107      10.318  33.512  -1.988  1.00 19.24           O  
ATOM    860  CB  HIS A 107       7.509  34.858  -1.007  1.00 19.93           C  
ATOM    861  CG  HIS A 107       8.330  34.611   0.220  1.00 19.98           C  
ATOM    862  ND1 HIS A 107       8.327  33.406   0.889  1.00 20.43           N  
ATOM    863  CD2 HIS A 107       9.232  35.394   0.857  1.00 19.86           C  
ATOM    864  CE1 HIS A 107       9.194  33.457   1.885  1.00 20.46           C  
ATOM    865  NE2 HIS A 107       9.756  34.652   1.887  1.00 20.85           N  
ATOM    866  N   SER A 108       8.502  32.472  -2.822  1.00 18.90           N  
ATOM    867  CA  SER A 108       9.174  31.189  -2.943  1.00 18.91           C  
ATOM    868  C   SER A 108      10.350  31.291  -3.905  1.00 18.04           C  
ATOM    869  O   SER A 108      11.400  30.713  -3.647  1.00 17.65           O  
ATOM    870  CB  SER A 108       8.186  30.124  -3.420  1.00 20.61           C  
ATOM    871  OG  SER A 108       7.183  29.914  -2.433  1.00 22.67           O  
ATOM    872  N   ASN A 109      10.175  32.019  -5.009  1.00 17.54           N  
ATOM    873  CA  ASN A 109      11.262  32.187  -5.973  1.00 18.13           C  
ATOM    874  C   ASN A 109      12.418  32.938  -5.311  1.00 17.61           C  
ATOM    875  O   ASN A 109      13.587  32.573  -5.485  1.00 16.57           O  
ATOM    876  CB  ASN A 109      10.792  32.958  -7.225  1.00 18.48           C  
ATOM    877  CG  ASN A 109      10.094  32.061  -8.249  1.00 20.10           C  
ATOM    878  OD1 ASN A 109       8.882  31.836  -8.187  1.00 20.60           O  
ATOM    879  ND2 ASN A 109      10.867  31.543  -9.195  1.00 20.13           N  
ATOM    880  N   GLN A 110      12.102  33.980  -4.546  1.00 16.87           N  
ATOM    881  CA  GLN A 110      13.154  34.744  -3.886  1.00 16.97           C  
ATOM    882  C   GLN A 110      13.941  33.891  -2.901  1.00 16.45           C  
ATOM    883  O   GLN A 110      15.158  34.023  -2.792  1.00 17.13           O  
ATOM    884  CB  GLN A 110      12.581  35.968  -3.167  1.00 18.17           C  
ATOM    885  CG  GLN A 110      13.615  36.658  -2.286  1.00 22.14           C  
ATOM    886  CD  GLN A 110      13.199  38.045  -1.858  1.00 24.01           C  
ATOM    887  OE1 GLN A 110      13.180  38.975  -2.665  1.00 25.74           O  
ATOM    888  NE2 GLN A 110      12.863  38.194  -0.581  1.00 24.74           N  
ATOM    889  N   VAL A 111      13.248  33.022  -2.174  1.00 16.44           N  
ATOM    890  CA  VAL A 111      13.911  32.145  -1.223  1.00 16.74           C  
ATOM    891  C   VAL A 111      14.810  31.157  -1.960  1.00 15.91           C  
ATOM    892  O   VAL A 111      15.960  30.948  -1.582  1.00 15.43           O  
ATOM    893  CB  VAL A 111      12.880  31.375  -0.384  1.00 16.97           C  
ATOM    894  CG1 VAL A 111      13.572  30.321   0.461  1.00 18.49           C  
ATOM    895  CG2 VAL A 111      12.115  32.355   0.502  1.00 18.07           C  
ATOM    896  N   ALA A 112      14.283  30.574  -3.031  1.00 16.05           N  
ATOM    897  CA  ALA A 112      15.023  29.603  -3.824  1.00 16.23           C  
ATOM    898  C   ALA A 112      16.274  30.166  -4.492  1.00 16.21           C  
ATOM    899  O   ALA A 112      17.300  29.484  -4.568  1.00 15.68           O  
ATOM    900  CB  ALA A 112      14.101  29.009  -4.893  1.00 16.56           C  
ATOM    901  N   LEU A 113      16.182  31.406  -4.968  1.00 15.77           N  
ATOM    902  CA  LEU A 113      17.272  32.054  -5.687  1.00 15.77           C  
ATOM    903  C   LEU A 113      18.279  32.840  -4.849  1.00 15.18           C  
ATOM    904  O   LEU A 113      19.162  33.505  -5.406  1.00 15.20           O  
ATOM    905  CB  LEU A 113      16.686  32.962  -6.768  1.00 15.93           C  
ATOM    906  CG  LEU A 113      15.824  32.242  -7.819  1.00 16.93           C  
ATOM    907  CD1 LEU A 113      15.195  33.261  -8.754  1.00 16.71           C  
ATOM    908  CD2 LEU A 113      16.676  31.257  -8.602  1.00 16.16           C  
ATOM    909  N   GLN A 114      18.154  32.762  -3.526  1.00 14.53           N  
ATOM    910  CA  GLN A 114      19.078  33.465  -2.633  1.00 16.45           C  
ATOM    911  C   GLN A 114      20.535  33.202  -3.030  1.00 15.88           C  
ATOM    912  O   GLN A 114      20.930  32.047  -3.229  1.00 15.92           O  
ATOM    913  CB  GLN A 114      18.867  33.000  -1.189  1.00 17.84           C  
ATOM    914  CG  GLN A 114      17.570  33.455  -0.551  1.00 21.02           C  
ATOM    915  CD  GLN A 114      17.345  32.810   0.809  1.00 23.25           C  
ATOM    916  OE1 GLN A 114      16.962  31.636   0.907  1.00 23.69           O  
ATOM    917  NE2 GLN A 114      17.600  33.568   1.867  1.00 24.49           N  
ATOM    918  N   GLY A 115      21.318  34.275  -3.156  1.00 15.93           N  
ATOM    919  CA  GLY A 115      22.724  34.149  -3.504  1.00 16.86           C  
ATOM    920  C   GLY A 115      23.091  34.239  -4.975  1.00 17.43           C  
ATOM    921  O   GLY A 115      24.218  34.611  -5.309  1.00 17.02           O  
ATOM    922  N   LEU A 116      22.151  33.906  -5.856  1.00 17.42           N  
ATOM    923  CA  LEU A 116      22.404  33.944  -7.293  1.00 17.81           C  
ATOM    924  C   LEU A 116      22.264  35.344  -7.872  1.00 17.72           C  
ATOM    925  O   LEU A 116      21.331  36.076  -7.545  1.00 17.49           O  
ATOM    926  CB  LEU A 116      21.459  32.981  -8.017  1.00 17.88           C  
ATOM    927  CG  LEU A 116      21.498  31.499  -7.618  1.00 18.24           C  
ATOM    928  CD1 LEU A 116      20.472  30.729  -8.440  1.00 18.43           C  
ATOM    929  CD2 LEU A 116      22.882  30.923  -7.855  1.00 19.09           C  
ATOM    930  N   SER A 117      23.202  35.711  -8.741  1.00 18.73           N  
ATOM    931  CA  SER A 117      23.217  37.032  -9.369  1.00 18.91           C  
ATOM    932  C   SER A 117      22.216  37.123 -10.511  1.00 19.34           C  
ATOM    933  O   SER A 117      21.722  36.112 -11.003  1.00 18.92           O  
ATOM    934  CB  SER A 117      24.608  37.332  -9.924  1.00 19.02           C  
ATOM    935  OG  SER A 117      24.875  36.505 -11.043  1.00 18.99           O  
ATOM    936  N   GLU A 118      21.940  38.343 -10.950  1.00 19.88           N  
ATOM    937  CA  GLU A 118      20.997  38.533 -12.038  1.00 21.31           C  
ATOM    938  C   GLU A 118      21.435  37.743 -13.278  1.00 20.77           C  
ATOM    939  O   GLU A 118      20.623  37.067 -13.916  1.00 20.64           O  
ATOM    940  CB  GLU A 118      20.862  40.028 -12.349  1.00 22.96           C  
ATOM    941  CG  GLU A 118      19.897  40.346 -13.465  1.00 26.69           C  
ATOM    942  CD  GLU A 118      20.567  40.339 -14.823  1.00 28.69           C  
ATOM    943  OE1 GLU A 118      21.484  41.167 -15.034  1.00 30.61           O  
ATOM    944  OE2 GLU A 118      20.179  39.510 -15.678  1.00 30.46           O  
ATOM    945  N   VAL A 119      22.722  37.806 -13.604  1.00 20.10           N  
ATOM    946  CA  VAL A 119      23.233  37.090 -14.765  1.00 20.88           C  
ATOM    947  C   VAL A 119      23.079  35.577 -14.622  1.00 20.72           C  
ATOM    948  O   VAL A 119      22.704  34.896 -15.579  1.00 21.45           O  
ATOM    949  CB  VAL A 119      24.721  37.432 -15.024  1.00 21.75           C  
ATOM    950  CG1 VAL A 119      25.284  36.523 -16.108  1.00 21.21           C  
ATOM    951  CG2 VAL A 119      24.847  38.888 -15.448  1.00 21.98           C  
ATOM    952  N   GLU A 120      23.372  35.042 -13.440  1.00 20.01           N  
ATOM    953  CA  GLU A 120      23.245  33.607 -13.230  1.00 19.58           C  
ATOM    954  C   GLU A 120      21.786  33.167 -13.336  1.00 18.76           C  
ATOM    955  O   GLU A 120      21.479  32.123 -13.920  1.00 17.90           O  
ATOM    956  CB  GLU A 120      23.813  33.223 -11.861  1.00 20.75           C  
ATOM    957  CG  GLU A 120      25.280  33.589 -11.704  1.00 21.50           C  
ATOM    958  CD  GLU A 120      25.816  33.308 -10.310  1.00 23.11           C  
ATOM    959  OE1 GLU A 120      25.131  33.653  -9.313  1.00 23.05           O  
ATOM    960  OE2 GLU A 120      26.934  32.756 -10.216  1.00 23.83           O  
ATOM    961  N   ILE A 121      20.883  33.965 -12.779  1.00 18.56           N  
ATOM    962  CA  ILE A 121      19.467  33.626 -12.834  1.00 18.34           C  
ATOM    963  C   ILE A 121      18.976  33.622 -14.285  1.00 19.31           C  
ATOM    964  O   ILE A 121      18.135  32.799 -14.663  1.00 18.98           O  
ATOM    965  CB  ILE A 121      18.633  34.614 -11.985  1.00 18.28           C  
ATOM    966  CG1 ILE A 121      18.993  34.446 -10.509  1.00 18.10           C  
ATOM    967  CG2 ILE A 121      17.147  34.345 -12.169  1.00 18.53           C  
ATOM    968  CD1 ILE A 121      18.286  35.416  -9.590  1.00 17.92           C  
ATOM    969  N   SER A 122      19.512  34.528 -15.100  1.00 19.67           N  
ATOM    970  CA  SER A 122      19.129  34.608 -16.512  1.00 21.14           C  
ATOM    971  C   SER A 122      19.576  33.359 -17.271  1.00 20.35           C  
ATOM    972  O   SER A 122      18.857  32.858 -18.140  1.00 20.43           O  
ATOM    973  CB  SER A 122      19.746  35.849 -17.162  1.00 22.21           C  
ATOM    974  OG  SER A 122      19.122  37.033 -16.693  1.00 25.67           O  
ATOM    975  N   GLN A 123      20.767  32.862 -16.944  1.00 20.06           N  
ATOM    976  CA  GLN A 123      21.307  31.667 -17.588  1.00 20.15           C  
ATOM    977  C   GLN A 123      20.506  30.450 -17.146  1.00 19.76           C  
ATOM    978  O   GLN A 123      20.208  29.558 -17.944  1.00 19.64           O  
ATOM    979  CB  GLN A 123      22.779  31.466 -17.214  1.00 21.31           C  
ATOM    980  CG  GLN A 123      23.690  32.602 -17.628  1.00 23.37           C  
ATOM    981  CD  GLN A 123      25.148  32.273 -17.398  1.00 25.44           C  
ATOM    982  OE1 GLN A 123      25.491  31.549 -16.459  1.00 26.39           O  
ATOM    983  NE2 GLN A 123      26.021  32.811 -18.248  1.00 26.73           N  
ATOM    984  N   LEU A 124      20.174  30.418 -15.859  1.00 18.81           N  
ATOM    985  CA  LEU A 124      19.395  29.330 -15.287  1.00 18.19           C  
ATOM    986  C   LEU A 124      18.038  29.259 -15.983  1.00 18.00           C  
ATOM    987  O   LEU A 124      17.586  28.182 -16.387  1.00 18.98           O  
ATOM    988  CB  LEU A 124      19.200  29.575 -13.791  1.00 17.44           C  
ATOM    989  CG  LEU A 124      18.368  28.573 -12.999  1.00 17.80           C  
ATOM    990  CD1 LEU A 124      19.050  27.214 -12.997  1.00 16.35           C  
ATOM    991  CD2 LEU A 124      18.196  29.091 -11.580  1.00 17.32           C  
ATOM    992  N   ALA A 125      17.393  30.416 -16.116  1.00 18.35           N  
ATOM    993  CA  ALA A 125      16.091  30.501 -16.766  1.00 18.10           C  
ATOM    994  C   ALA A 125      16.175  29.872 -18.151  1.00 18.60           C  
ATOM    995  O   ALA A 125      15.336  29.047 -18.531  1.00 17.83           O  
ATOM    996  CB  ALA A 125      15.653  31.962 -16.881  1.00 18.33           C  
ATOM    997  N   ASP A 126      17.200  30.259 -18.901  1.00 19.25           N  
ATOM    998  CA  ASP A 126      17.384  29.737 -20.242  1.00 20.35           C  
ATOM    999  C   ASP A 126      17.557  28.225 -20.250  1.00 19.73           C  
ATOM   1000  O   ASP A 126      16.956  27.533 -21.081  1.00 19.98           O  
ATOM   1001  CB  ASP A 126      18.586  30.403 -20.898  1.00 23.27           C  
ATOM   1002  CG  ASP A 126      18.834  29.888 -22.291  1.00 25.76           C  
ATOM   1003  OD1 ASP A 126      17.865  29.841 -23.080  1.00 27.46           O  
ATOM   1004  OD2 ASP A 126      19.989  29.536 -22.598  1.00 27.18           O  
ATOM   1005  N   TYR A 127      18.380  27.708 -19.340  1.00 18.90           N  
ATOM   1006  CA  TYR A 127      18.598  26.266 -19.254  1.00 18.15           C  
ATOM   1007  C   TYR A 127      17.298  25.539 -18.906  1.00 17.35           C  
ATOM   1008  O   TYR A 127      16.987  24.498 -19.479  1.00 17.10           O  
ATOM   1009  CB  TYR A 127      19.637  25.928 -18.181  1.00 19.07           C  
ATOM   1010  CG  TYR A 127      21.034  26.454 -18.440  1.00 20.84           C  
ATOM   1011  CD1 TYR A 127      21.575  26.460 -19.725  1.00 21.93           C  
ATOM   1012  CD2 TYR A 127      21.838  26.895 -17.387  1.00 21.91           C  
ATOM   1013  CE1 TYR A 127      22.883  26.886 -19.959  1.00 22.98           C  
ATOM   1014  CE2 TYR A 127      23.147  27.325 -17.611  1.00 23.18           C  
ATOM   1015  CZ  TYR A 127      23.661  27.315 -18.899  1.00 23.18           C  
ATOM   1016  OH  TYR A 127      24.956  27.734 -19.124  1.00 24.73           O  
ATOM   1017  N   LEU A 128      16.537  26.085 -17.966  1.00 15.83           N  
ATOM   1018  CA  LEU A 128      15.295  25.447 -17.555  1.00 16.07           C  
ATOM   1019  C   LEU A 128      14.228  25.465 -18.644  1.00 16.72           C  
ATOM   1020  O   LEU A 128      13.463  24.508 -18.785  1.00 17.93           O  
ATOM   1021  CB  LEU A 128      14.766  26.094 -16.270  1.00 15.42           C  
ATOM   1022  CG  LEU A 128      15.621  25.876 -15.007  1.00 15.17           C  
ATOM   1023  CD1 LEU A 128      15.079  26.741 -13.875  1.00 14.09           C  
ATOM   1024  CD2 LEU A 128      15.615  24.397 -14.599  1.00 14.27           C  
ATOM   1025  N   VAL A 129      14.162  26.547 -19.411  1.00 16.41           N  
ATOM   1026  CA  VAL A 129      13.177  26.612 -20.488  1.00 17.16           C  
ATOM   1027  C   VAL A 129      13.502  25.515 -21.506  1.00 17.04           C  
ATOM   1028  O   VAL A 129      12.603  24.810 -21.971  1.00 17.27           O  
ATOM   1029  CB  VAL A 129      13.175  27.996 -21.189  1.00 17.68           C  
ATOM   1030  CG1 VAL A 129      12.302  27.959 -22.447  1.00 17.33           C  
ATOM   1031  CG2 VAL A 129      12.624  29.052 -20.231  1.00 18.31           C  
ATOM   1032  N   ARG A 130      14.783  25.360 -21.836  1.00 17.30           N  
ATOM   1033  CA  ARG A 130      15.207  24.337 -22.793  1.00 18.23           C  
ATOM   1034  C   ARG A 130      14.828  22.953 -22.270  1.00 18.18           C  
ATOM   1035  O   ARG A 130      14.266  22.139 -22.996  1.00 17.50           O  
ATOM   1036  CB  ARG A 130      16.719  24.396 -23.014  1.00 19.08           C  
ATOM   1037  CG  ARG A 130      17.250  23.373 -24.015  1.00 22.11           C  
ATOM   1038  CD  ARG A 130      17.187  23.905 -25.440  1.00 24.91           C  
ATOM   1039  NE  ARG A 130      17.950  23.072 -26.367  1.00 26.67           N  
ATOM   1040  CZ  ARG A 130      18.200  23.398 -27.631  1.00 26.92           C  
ATOM   1041  NH1 ARG A 130      17.747  24.545 -28.124  1.00 27.32           N  
ATOM   1042  NH2 ARG A 130      18.891  22.574 -28.407  1.00 27.49           N  
ATOM   1043  N   MET A 131      15.142  22.694 -21.002  1.00 18.30           N  
ATOM   1044  CA  MET A 131      14.833  21.409 -20.383  1.00 17.97           C  
ATOM   1045  C   MET A 131      13.334  21.143 -20.423  1.00 17.59           C  
ATOM   1046  O   MET A 131      12.899  20.057 -20.796  1.00 18.40           O  
ATOM   1047  CB  MET A 131      15.303  21.383 -18.918  1.00 15.46           C  
ATOM   1048  CG  MET A 131      16.819  21.322 -18.716  1.00 15.62           C  
ATOM   1049  SD  MET A 131      17.343  21.235 -16.991  1.00  7.41           S  
ATOM   1050  CE  MET A 131      17.694  22.840 -16.705  1.00 19.95           C  
ATOM   1051  N   ARG A 132      12.541  22.134 -20.029  1.00 17.13           N  
ATOM   1052  CA  ARG A 132      11.096  21.984 -20.015  1.00 16.53           C  
ATOM   1053  C   ARG A 132      10.559  21.662 -21.413  1.00 16.86           C  
ATOM   1054  O   ARG A 132       9.688  20.810 -21.571  1.00 17.09           O  
ATOM   1055  CB  ARG A 132      10.449  23.256 -19.465  1.00 15.83           C  
ATOM   1056  CG  ARG A 132       8.929  23.188 -19.390  1.00 15.81           C  
ATOM   1057  CD  ARG A 132       8.304  23.975 -20.528  1.00 16.77           C  
ATOM   1058  NE  ARG A 132       8.562  25.402 -20.369  1.00 17.52           N  
ATOM   1059  CZ  ARG A 132       8.324  26.323 -21.294  1.00 18.86           C  
ATOM   1060  NH1 ARG A 132       7.816  25.980 -22.471  1.00 19.71           N  
ATOM   1061  NH2 ARG A 132       8.596  27.593 -21.037  1.00 19.74           N  
ATOM   1062  N   LYS A 133      11.078  22.343 -22.426  1.00 16.96           N  
ATOM   1063  CA  LYS A 133      10.646  22.075 -23.792  1.00 18.25           C  
ATOM   1064  C   LYS A 133      11.039  20.636 -24.159  1.00 18.48           C  
ATOM   1065  O   LYS A 133      10.236  19.891 -24.731  1.00 18.83           O  
ATOM   1066  CB  LYS A 133      11.295  23.079 -24.750  1.00 19.26           C  
ATOM   1067  CG  LYS A 133      10.748  24.500 -24.591  1.00 20.05           C  
ATOM   1068  CD  LYS A 133      11.405  25.457 -25.575  1.00 21.19           C  
ATOM   1069  CE  LYS A 133      10.765  26.834 -25.531  1.00 22.17           C  
ATOM   1070  NZ  LYS A 133      11.496  27.806 -26.392  1.00 23.31           N  
ATOM   1071  N   ASN A 134      12.262  20.250 -23.801  1.00 18.45           N  
ATOM   1072  CA  ASN A 134      12.761  18.897 -24.067  1.00 17.92           C  
ATOM   1073  C   ASN A 134      11.825  17.838 -23.485  1.00 18.37           C  
ATOM   1074  O   ASN A 134      11.326  16.979 -24.209  1.00 18.30           O  
ATOM   1075  CB  ASN A 134      14.162  18.700 -23.467  1.00 18.33           C  
ATOM   1076  CG  ASN A 134      15.260  19.352 -24.293  1.00 18.35           C  
ATOM   1077  OD1 ASN A 134      16.388  19.549 -23.816  1.00 18.75           O  
ATOM   1078  ND2 ASN A 134      14.946  19.680 -25.541  1.00 18.86           N  
ATOM   1079  N   VAL A 135      11.571  17.903 -22.179  1.00 17.80           N  
ATOM   1080  CA  VAL A 135      10.714  16.907 -21.537  1.00 18.09           C  
ATOM   1081  C   VAL A 135       9.230  17.000 -21.909  1.00 18.38           C  
ATOM   1082  O   VAL A 135       8.529  15.988 -21.919  1.00 18.14           O  
ATOM   1083  CB  VAL A 135      10.845  16.957 -19.989  1.00 18.66           C  
ATOM   1084  CG1 VAL A 135      12.304  16.709 -19.576  1.00 17.97           C  
ATOM   1085  CG2 VAL A 135      10.341  18.293 -19.470  1.00 19.39           C  
ATOM   1086  N   SER A 136       8.752  18.203 -22.211  1.00 18.09           N  
ATOM   1087  CA  SER A 136       7.351  18.389 -22.580  1.00 18.72           C  
ATOM   1088  C   SER A 136       7.061  17.701 -23.906  1.00 18.17           C  
ATOM   1089  O   SER A 136       6.015  17.071 -24.075  1.00 18.51           O  
ATOM   1090  CB  SER A 136       7.017  19.878 -22.680  1.00 18.88           C  
ATOM   1091  OG  SER A 136       7.148  20.486 -21.407  1.00 20.25           O  
ATOM   1092  N   GLU A 137       7.992  17.822 -24.843  1.00 18.11           N  
ATOM   1093  CA  GLU A 137       7.832  17.185 -26.143  1.00 18.86           C  
ATOM   1094  C   GLU A 137       7.950  15.672 -25.988  1.00 18.98           C  
ATOM   1095  O   GLU A 137       7.290  14.916 -26.706  1.00 18.48           O  
ATOM   1096  CB  GLU A 137       8.887  17.706 -27.122  1.00 20.22           C  
ATOM   1097  CG  GLU A 137       8.756  17.188 -28.559  1.00 21.99           C  
ATOM   1098  CD  GLU A 137       9.082  15.706 -28.703  1.00 23.33           C  
ATOM   1099  OE1 GLU A 137      10.046  15.234 -28.053  1.00 24.11           O  
ATOM   1100  OE2 GLU A 137       8.387  15.014 -29.484  1.00 24.74           O  
ATOM   1101  N   ASP A 138       8.783  15.214 -25.058  1.00 18.62           N  
ATOM   1102  CA  ASP A 138       8.922  13.772 -24.869  1.00 19.01           C  
ATOM   1103  C   ASP A 138       7.627  13.216 -24.295  1.00 18.66           C  
ATOM   1104  O   ASP A 138       7.178  12.131 -24.678  1.00 18.42           O  
ATOM   1105  CB  ASP A 138      10.101  13.448 -23.948  1.00 19.97           C  
ATOM   1106  CG  ASP A 138      10.480  11.982 -23.986  1.00 20.39           C  
ATOM   1107  OD1 ASP A 138      10.515  11.401 -25.091  1.00 21.84           O  
ATOM   1108  OD2 ASP A 138      10.760  11.408 -22.916  1.00 21.04           O  
ATOM   1109  N   TRP A 139       7.021  13.970 -23.380  1.00 18.50           N  
ATOM   1110  CA  TRP A 139       5.761  13.560 -22.770  1.00 18.35           C  
ATOM   1111  C   TRP A 139       4.699  13.493 -23.866  1.00 19.28           C  
ATOM   1112  O   TRP A 139       3.929  12.528 -23.948  1.00 18.41           O  
ATOM   1113  CB  TRP A 139       5.355  14.567 -21.690  1.00 17.36           C  
ATOM   1114  CG  TRP A 139       3.994  14.342 -21.097  1.00 17.22           C  
ATOM   1115  CD1 TRP A 139       3.477  13.159 -20.640  1.00 17.05           C  
ATOM   1116  CD2 TRP A 139       3.001  15.339 -20.835  1.00 17.21           C  
ATOM   1117  NE1 TRP A 139       2.225  13.364 -20.109  1.00 17.10           N  
ATOM   1118  CE2 TRP A 139       1.910  14.694 -20.215  1.00 17.37           C  
ATOM   1119  CE3 TRP A 139       2.929  16.719 -21.066  1.00 17.68           C  
ATOM   1120  CZ2 TRP A 139       0.752  15.385 -19.817  1.00 18.07           C  
ATOM   1121  CZ3 TRP A 139       1.782  17.406 -20.676  1.00 17.63           C  
ATOM   1122  CH2 TRP A 139       0.707  16.733 -20.056  1.00 18.14           C  
ATOM   1123  N   GLU A 140       4.663  14.522 -24.709  1.00 19.34           N  
ATOM   1124  CA  GLU A 140       3.714  14.564 -25.809  1.00 21.03           C  
ATOM   1125  C   GLU A 140       3.881  13.328 -26.681  1.00 21.10           C  
ATOM   1126  O   GLU A 140       2.898  12.703 -27.080  1.00 21.53           O  
ATOM   1127  CB  GLU A 140       3.926  15.823 -26.649  1.00 22.63           C  
ATOM   1128  CG  GLU A 140       3.322  17.069 -26.030  1.00 26.19           C  
ATOM   1129  CD  GLU A 140       1.834  16.913 -25.782  1.00 28.63           C  
ATOM   1130  OE1 GLU A 140       1.121  16.484 -26.719  1.00 31.11           O  
ATOM   1131  OE2 GLU A 140       1.371  17.220 -24.660  1.00 29.80           O  
ATOM   1132  N   PHE A 141       5.126  12.965 -26.967  1.00 21.10           N  
ATOM   1133  CA  PHE A 141       5.380  11.793 -27.796  1.00 21.45           C  
ATOM   1134  C   PHE A 141       4.884  10.523 -27.110  1.00 21.96           C  
ATOM   1135  O   PHE A 141       4.185   9.705 -27.718  1.00 22.13           O  
ATOM   1136  CB  PHE A 141       6.871  11.654 -28.087  1.00 21.89           C  
ATOM   1137  CG  PHE A 141       7.187  10.559 -29.060  1.00 21.49           C  
ATOM   1138  CD1 PHE A 141       6.884  10.709 -30.407  1.00 21.59           C  
ATOM   1139  CD2 PHE A 141       7.750   9.364 -28.624  1.00 21.82           C  
ATOM   1140  CE1 PHE A 141       7.135   9.683 -31.313  1.00 21.50           C  
ATOM   1141  CE2 PHE A 141       8.006   8.333 -29.521  1.00 22.36           C  
ATOM   1142  CZ  PHE A 141       7.697   8.496 -30.870  1.00 22.04           C  
ATOM   1143  N   VAL A 142       5.255  10.360 -25.844  1.00 22.05           N  
ATOM   1144  CA  VAL A 142       4.853   9.189 -25.067  1.00 22.57           C  
ATOM   1145  C   VAL A 142       3.335   9.050 -24.998  1.00 23.21           C  
ATOM   1146  O   VAL A 142       2.807   7.933 -25.000  1.00 24.38           O  
ATOM   1147  CB  VAL A 142       5.439   9.252 -23.637  1.00 22.26           C  
ATOM   1148  CG1 VAL A 142       4.727   8.265 -22.714  1.00 22.07           C  
ATOM   1149  CG2 VAL A 142       6.919   8.933 -23.690  1.00 21.20           C  
ATOM   1150  N   LYS A 143       2.638  10.179 -24.939  1.00 23.01           N  
ATOM   1151  CA  LYS A 143       1.181  10.185 -24.882  1.00 23.85           C  
ATOM   1152  C   LYS A 143       0.523   9.792 -26.197  1.00 24.22           C  
ATOM   1153  O   LYS A 143      -0.562   9.212 -26.198  1.00 25.24           O  
ATOM   1154  CB  LYS A 143       0.656  11.563 -24.494  1.00 23.46           C  
ATOM   1155  CG  LYS A 143       0.556  11.823 -23.005  1.00 22.37           C  
ATOM   1156  CD  LYS A 143      -0.266  13.086 -22.752  1.00 22.23           C  
ATOM   1157  CE  LYS A 143       0.378  14.314 -23.393  1.00 21.91           C  
ATOM   1158  NZ  LYS A 143      -0.449  15.537 -23.202  1.00 21.63           N  
ATOM   1159  N   LYS A 144       1.161  10.137 -27.312  1.00 24.41           N  
ATOM   1160  CA  LYS A 144       0.613   9.828 -28.626  1.00 24.06           C  
ATOM   1161  C   LYS A 144       0.769   8.378 -29.064  1.00 24.36           C  
ATOM   1162  O   LYS A 144       0.745   8.086 -30.261  1.00 24.27           O  
ATOM   1163  CB  LYS A 144       1.220  10.739 -29.692  1.00 23.84           C  
ATOM   1164  CG  LYS A 144       0.638  12.136 -29.698  1.00 23.85           C  
ATOM   1165  CD  LYS A 144       0.837  12.816 -31.055  1.00 24.52           C  
ATOM   1166  CE  LYS A 144       0.108  14.148 -31.097  1.00 24.96           C  
ATOM   1167  NZ  LYS A 144      -1.332  13.987 -30.721  1.00 25.60           N  
ATOM   1168  N   GLY A 145       0.924   7.479 -28.096  1.00 24.72           N  
ATOM   1169  CA  GLY A 145       1.053   6.065 -28.401  1.00 25.30           C  
ATOM   1170  C   GLY A 145      -0.009   5.643 -29.406  1.00 25.28           C  
ATOM   1171  O   GLY A 145       0.298   4.833 -30.307  1.00 25.57           O  
ATOM   1172  OXT GLY A 145      -1.158   6.119 -29.290  1.00 26.10           O  
TER    1173      GLY A 145                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
