
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   80 (  631),  selected   80 , name 2obk_E
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2obk_E.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     5_E      T      12          0.623
LGA    P     6_E      H      13          0.816
LGA    E     7_E      R      14          0.466
LGA    V     8_E      V      15          0.539
LGA    I     9_E      Q      16          0.509
LGA    I    10_E      I      17          0.199
LGA    T    11_E      E      18          0.272
LGA    Y    12_E      Y      19          0.637
LGA    C    13_E      C      20          0.472
LGA    T    14_E      T      21          0.436
LGA    Q    15_E      Q      22          1.072
LGA    C    16_E      C      23          0.275
LGA    Q    17_E      R      24          0.444
LGA    W    18_E      W      25          0.276
LGA    L    19_E      L      26          0.320
LGA    L    20_E      P      27          0.558
LGA    R    21_E      R      28          0.619
LGA    A    22_E      A      29          0.447
LGA    A    23_E      A      30          0.618
LGA    W    24_E      W      31          0.388
LGA    L    25_E      L      32          0.391
LGA    A    26_E      A      33          0.303
LGA    Q    27_E      Q      34          0.405
LGA    E    28_E      E      35          0.192
LGA    L    29_E      L      36          0.387
LGA    L    30_E      L      37          0.490
LGA    S    31_E      T      38          0.553
LGA    T    32_E      T      39          0.971
LGA    F    33_E      F      40          0.969
LGA    S    34_E      E      41          1.139
LGA    D    35_E      T      42          0.460
LGA    D    36_E      E      43          0.624
LGA    L    37_E      L      44          0.511
LGA    G    38_E      T      45          0.671
LGA    K    39_E      E      46          0.517
LGA    V    40_E      L      47          0.588
LGA    S    41_E      A      48          0.333
LGA    L    42_E      L      49          0.389
LGA    E    43_E      K      50          0.377
LGA    P    44_E      P      51          0.286
LGA    A    45_E      G      52          0.829
LGA    T    46_E      T      53          1.206
LGA    G    47_E      G      54          0.878
LGA    G    48_E      G      55          0.544
LGA    A    49_E      V      56          0.574
LGA    F    50_E      F      57          0.543
LGA    R    51_E      V      58          0.889
LGA    I    52_E      V      59          0.734
LGA    T    53_E      R      60          0.342
LGA    C    54_E      V      61          0.108
LGA    D    55_E      D      62          0.255
LGA    G    56_E      D      63          0.781
LGA    V    57_E      E      64          0.845
LGA    Q    58_E      V      65          0.801
LGA    I    59_E      V      66          0.766
LGA    W    60_E      W      67          0.577
LGA    E    61_E      D      68          0.661
LGA    R    62_E      R      69          0.959
LGA    K    63_E      R      70          0.763
LGA    A    64_E      E      71          1.238
LGA    D    65_E      Q      72          1.046
LGA    G    66_E      G      73          2.570
LGA    G    67_E      -       -           -
LGA    F    68_E      F      74          1.219
LGA    P    69_E      P      75          1.237
LGA    E    70_E      E      76          0.997
LGA    A    71_E      P      77          0.802
LGA    K    72_E      T      78          0.870
LGA    V    73_E      A      79          1.142
LGA    L    74_E      V      80          1.289
LGA    K    75_E      K      81          1.029
LGA    Q    76_E      R      82          0.840
LGA    R    77_E      L      83          0.631
LGA    V    78_E      V      84          0.617
LGA    R    79_E      R      85          0.434
LGA    D    80_E      D      86          0.426
LGA    Q    81_E      R      87          0.840
LGA    I    82_E      V      88          0.831
LGA    D    83_E      -       -           -
LGA    P    84_E      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   80   77    5.0     77    0.76    50.65     98.980     8.942

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.384439 * X  +  -0.432362 * Y  +  -0.815641 * Z  +  53.662495
  Y_new =  -0.868027 * X  +   0.470042 * Y  +   0.159966 * Z  + 124.335480
  Z_new =   0.314222 * X  +   0.769496 * Y  +  -0.556004 * Z  +  -2.729630 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.196501   -0.945091  [ DEG:   125.8503    -54.1498 ]
  Theta =  -0.319637   -2.821955  [ DEG:   -18.3139   -161.6861 ]
  Phi   =  -1.987720    1.153872  [ DEG:  -113.8880     66.1120 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2obk_E                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2obk_E.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   80   77   5.0   77   0.76   50.65  98.980
REMARK  ---------------------------------------------------------- 
MOLECULE 2obk_E
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-DEC-06   2OBK              
TITLE     X-RAY STRUCTURE OF THE PUTATIVE SE BINDING PROTEIN FROM               
TITLE    2 PSEUDOMONAS FLUORESCENS. NORTHEAST STRUCTURAL GENOMICS               
TITLE    3 CONSORTIUM TARGET PLR6.                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SELT/SELW/SELH SELENOPROTEIN DOMAIN;                       
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PF-5;                                                        
SOURCE   5 ATCC: BAA-477;                                                       
SOURCE   6 GENE: PFL_1582;                                                      
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    X-RAY NESG PLR6 Q4KGC5, STRUCTURAL GENOMICS, PSI-2, PROTEIN           
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,M.SU,J.SEETHARAMAN,C.X.CHEN,Y.FANG,K.CUNNINGHAM,            
AUTHOR   2 L.C.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,                      
AUTHOR   3 G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   02-JAN-07 2OBK    0                                                
JRNL        AUTH   A.P.KUZIN,M.SU,J.SEETHARAMAN,C.CHEN,Y.FANG,                  
JRNL        AUTH 2 K.CUNNINGHAM,L.C.MA,R.XIAO,J.LIU,M.C.BARAN,                  
JRNL        AUTH 3 T.B.ACTON,B.ROST,G.T.MONTELIONE,L.TONG,J.F.HUNT              
JRNL        TITL   X-RAY STRUCTURE OF THE PUTATIVE SE BINDING PROTEIN           
JRNL        TITL 2 FROM PSEUDOMONAS FLUORESCENS                                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  2OBK A    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK B    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK C    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK D    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK E    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK F    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK G    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
DBREF  2OBK H    1    95  UNP    Q4KGC5   Q4KGC5_PSEF5     1     95             
SEQRES   1 A  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 A  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 A  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 A  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 A  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 A  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 A  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 A  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 B  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 B  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 B  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 B  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 B  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 B  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 B  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 B  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 C  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 C  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 C  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 C  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 C  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 C  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 C  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 C  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 D  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 D  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 D  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 D  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 D  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 D  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 D  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 D  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 E  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 E  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 E  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 E  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 E  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 E  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 E  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 E  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 F  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 F  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 F  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 F  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 F  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 F  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 F  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 F  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 G  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 G  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 G  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 G  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 G  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 G  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 G  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 G  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 H  103  MSE THR GLU ARG LYS PRO GLU VAL ILE ILE THR TYR CYS          
SEQRES   2 H  103  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 H  103  GLN GLU LEU LEU SER THR PHE SER ASP ASP LEU GLY LYS          
SEQRES   4 H  103  VAL SER LEU GLU PRO ALA THR GLY GLY ALA PHE ARG ILE          
SEQRES   5 H  103  THR CYS ASP GLY VAL GLN ILE TRP GLU ARG LYS ALA ASP          
SEQRES   6 H  103  GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL          
SEQRES   7 H  103  ARG ASP GLN ILE ASP PRO GLU ARG ASP LEU GLY HIS ASN          
SEQRES   8 H  103  ASP ARG THR GLN LEU GLU HIS HIS HIS HIS HIS HIS              
FORMUL   9  HOH   *132(H2 O)                                                    
CRYST1   54.311  112.251  148.459  90.00  90.00  90.00 P 21 21 21   32          
ATOM   2674  N   LYS E   5      34.938 111.942 -21.125  1.00 43.66           N  
ATOM   2675  CA  LYS E   5      34.880 111.337 -19.761  1.00 43.21           C  
ATOM   2676  C   LYS E   5      33.516 110.734 -19.522  1.00 42.63           C  
ATOM   2677  O   LYS E   5      32.512 111.279 -19.949  1.00 43.32           O  
ATOM   2678  CB  LYS E   5      35.152 112.392 -18.684  1.00 44.15           C  
ATOM   2679  CG  LYS E   5      36.567 112.939 -18.673  1.00 44.88           C  
ATOM   2680  CD  LYS E   5      36.788 113.932 -17.535  1.00 44.62           C  
ATOM   2681  CE  LYS E   5      38.180 114.534 -17.618  1.00 43.54           C  
ATOM   2682  NZ  LYS E   5      38.435 115.547 -16.572  1.00 45.27           N  
ATOM   2683  N   PRO E   6      33.465 109.603 -18.817  1.00 42.30           N  
ATOM   2684  CA  PRO E   6      32.209 108.909 -18.513  1.00 43.50           C  
ATOM   2685  C   PRO E   6      31.152 109.781 -17.828  1.00 43.38           C  
ATOM   2686  O   PRO E   6      31.471 110.825 -17.263  1.00 45.69           O  
ATOM   2687  CB  PRO E   6      32.672 107.736 -17.642  1.00 42.80           C  
ATOM   2688  CG  PRO E   6      33.914 108.265 -16.994  1.00 42.33           C  
ATOM   2689  CD  PRO E   6      34.597 108.968 -18.126  1.00 41.23           C  
ATOM   2690  N   GLU E   7      29.896 109.352 -17.895  1.00 42.05           N  
ATOM   2691  CA  GLU E   7      28.792 110.092 -17.285  1.00 41.60           C  
ATOM   2692  C   GLU E   7      27.899 109.164 -16.453  1.00 40.93           C  
ATOM   2693  O   GLU E   7      27.787 107.957 -16.724  1.00 40.24           O  
ATOM   2694  CB  GLU E   7      27.927 110.757 -18.361  1.00 43.51           C  
ATOM   2695  CG  GLU E   7      28.642 111.739 -19.278  1.00 48.10           C  
ATOM   2696  CD  GLU E   7      27.675 112.427 -20.234  1.00 49.94           C  
ATOM   2697  OE1 GLU E   7      28.105 113.305 -21.016  1.00 49.70           O  
ATOM   2698  OE2 GLU E   7      26.474 112.084 -20.197  1.00 52.40           O  
ATOM   2699  N   VAL E   8      27.247 109.736 -15.449  1.00 37.90           N  
ATOM   2700  CA  VAL E   8      26.369 108.966 -14.584  1.00 35.99           C  
ATOM   2701  C   VAL E   8      24.992 109.610 -14.525  1.00 35.02           C  
ATOM   2702  O   VAL E   8      24.874 110.827 -14.535  1.00 35.96           O  
ATOM   2703  CB  VAL E   8      26.967 108.885 -13.164  1.00 35.62           C  
ATOM   2704  CG1 VAL E   8      26.052 108.120 -12.225  1.00 33.85           C  
ATOM   2705  CG2 VAL E   8      28.323 108.227 -13.237  1.00 35.46           C  
ATOM   2706  N   ILE E   9      23.943 108.796 -14.507  1.00 33.89           N  
ATOM   2707  CA  ILE E   9      22.598 109.342 -14.400  1.00 33.70           C  
ATOM   2708  C   ILE E   9      21.973 108.681 -13.197  1.00 31.95           C  
ATOM   2709  O   ILE E   9      22.137 107.481 -12.971  1.00 30.36           O  
ATOM   2710  CB  ILE E   9      21.680 109.044 -15.623  1.00 35.22           C  
ATOM   2711  CG1 ILE E   9      21.119 107.617 -15.517  1.00 40.85           C  
ATOM   2712  CG2 ILE E   9      22.435 109.267 -16.927  1.00 33.46           C  
ATOM   2713  CD1 ILE E   9      19.963 107.297 -16.489  1.00 44.21           C  
ATOM   2714  N   ILE E  10      21.269 109.475 -12.412  1.00 30.36           N  
ATOM   2715  CA  ILE E  10      20.604 108.939 -11.246  1.00 27.92           C  
ATOM   2716  C   ILE E  10      19.156 109.265 -11.452  1.00 27.68           C  
ATOM   2717  O   ILE E  10      18.728 110.382 -11.196  1.00 29.41           O  
ATOM   2718  CB  ILE E  10      21.111 109.578  -9.941  1.00 25.86           C  
ATOM   2719  CG1 ILE E  10      22.600 109.294  -9.779  1.00 23.61           C  
ATOM   2720  CG2 ILE E  10      20.358 109.006  -8.757  1.00 25.93           C  
ATOM   2721  CD1 ILE E  10      23.235 110.026  -8.626  1.00 26.08           C  
ATOM   2722  N   THR E  11      18.422 108.284 -11.959  1.00 27.17           N  
ATOM   2723  CA  THR E  11      16.998 108.424 -12.217  1.00 27.63           C  
ATOM   2724  C   THR E  11      16.297 108.301 -10.861  1.00 26.12           C  
ATOM   2725  O   THR E  11      16.664 107.449 -10.061  1.00 26.09           O  
ATOM   2726  CB  THR E  11      16.513 107.300 -13.173  1.00 30.01           C  
ATOM   2727  OG1 THR E  11      17.375 107.237 -14.322  1.00 29.90           O  
ATOM   2728  CG2 THR E  11      15.089 107.567 -13.638  1.00 29.88           C  
ATOM   2729  N   TYR E  12      15.309 109.147 -10.589  1.00 24.20           N  
ATOM   2730  CA  TYR E  12      14.642 109.080  -9.294  1.00 24.34           C  
ATOM   2731  C   TYR E  12      13.156 109.373  -9.319  1.00 25.88           C  
ATOM   2732  O   TYR E  12      12.694 110.246 -10.053  1.00 26.08           O  
ATOM   2733  CB  TYR E  12      15.321 110.036  -8.322  1.00 25.02           C  
ATOM   2734  CG  TYR E  12      15.026 111.491  -8.591  1.00 26.72           C  
ATOM   2735  CD1 TYR E  12      13.962 112.124  -7.969  1.00 26.87           C  
ATOM   2736  CD2 TYR E  12      15.801 112.229  -9.477  1.00 25.79           C  
ATOM   2737  CE1 TYR E  12      13.670 113.454  -8.214  1.00 27.57           C  
ATOM   2738  CE2 TYR E  12      15.518 113.571  -9.732  1.00 28.79           C  
ATOM   2739  CZ  TYR E  12      14.447 114.180  -9.095  1.00 30.17           C  
ATOM   2740  OH  TYR E  12      14.137 115.508  -9.334  1.00 32.63           O  
ATOM   2741  N   CYS E  13      12.404 108.636  -8.506  1.00 26.77           N  
ATOM   2742  CA  CYS E  13      10.963 108.836  -8.429  1.00 28.64           C  
ATOM   2743  C   CYS E  13      10.672 110.182  -7.751  1.00 28.02           C  
ATOM   2744  O   CYS E  13      11.094 110.423  -6.617  1.00 27.61           O  
ATOM   2745  CB  CYS E  13      10.308 107.677  -7.653  1.00 27.55           C  
ATOM   2746  SG  CYS E  13       8.637 108.059  -7.029  1.00 33.13           S  
ATOM   2747  N   THR E  14       9.946 111.052  -8.446  1.00 28.26           N  
ATOM   2748  CA  THR E  14       9.633 112.370  -7.900  1.00 30.40           C  
ATOM   2749  C   THR E  14       8.698 112.407  -6.697  1.00 30.95           C  
ATOM   2750  O   THR E  14       9.070 112.875  -5.629  1.00 32.93           O  
ATOM   2751  CB  THR E  14       9.050 113.300  -8.976  1.00 30.50           C  
ATOM   2752  OG1 THR E  14      10.096 113.705  -9.860  1.00 32.10           O  
ATOM   2753  CG2 THR E  14       8.435 114.534  -8.343  1.00 30.44           C  
ATOM   2754  N   GLN E  15       7.480 111.925  -6.860  1.00 31.99           N  
ATOM   2755  CA  GLN E  15       6.539 111.971  -5.755  1.00 32.95           C  
ATOM   2756  C   GLN E  15       7.037 111.290  -4.500  1.00 31.40           C  
ATOM   2757  O   GLN E  15       6.619 111.656  -3.400  1.00 32.48           O  
ATOM   2758  CB  GLN E  15       5.203 111.375  -6.186  1.00 34.24           C  
ATOM   2759  CG  GLN E  15       4.655 112.107  -7.377  1.00 38.12           C  
ATOM   2760  CD  GLN E  15       4.703 113.605  -7.159  1.00 40.07           C  
ATOM   2761  OE1 GLN E  15       5.114 114.366  -8.039  1.00 39.67           O  
ATOM   2762  NE2 GLN E  15       4.283 114.039  -5.971  1.00 41.55           N  
ATOM   2763  N   CYS E  16       7.936 110.321  -4.671  1.00 28.55           N  
ATOM   2764  CA  CYS E  16       8.494 109.567  -3.556  1.00 29.67           C  
ATOM   2765  C   CYS E  16       9.396 110.446  -2.697  1.00 29.57           C  
ATOM   2766  O   CYS E  16       9.859 110.023  -1.630  1.00 30.25           O  
ATOM   2767  CB  CYS E  16       9.321 108.379  -4.057  1.00 30.91           C  
ATOM   2768  SG  CYS E  16       8.546 107.179  -5.187  1.00 32.29           S  
ATOM   2769  N   GLN E  17       9.658 111.662  -3.173  1.00 30.10           N  
ATOM   2770  CA  GLN E  17      10.507 112.605  -2.454  1.00 30.52           C  
ATOM   2771  C   GLN E  17      11.922 112.054  -2.442  1.00 29.87           C  
ATOM   2772  O   GLN E  17      12.623 112.158  -1.440  1.00 28.09           O  
ATOM   2773  CB  GLN E  17      10.035 112.751  -1.005  1.00 33.61           C  
ATOM   2774  CG  GLN E  17       8.549 112.910  -0.814  1.00 37.51           C  
ATOM   2775  CD  GLN E  17       8.109 114.342  -0.952  1.00 42.06           C  
ATOM   2776  OE1 GLN E  17       8.420 115.002  -1.945  1.00 44.94           O  
ATOM   2777  NE2 GLN E  17       7.378 114.837   0.045  1.00 43.19           N  
ATOM   2778  N   TRP E  18      12.346 111.451  -3.547  1.00 28.93           N  
ATOM   2779  CA  TRP E  18      13.687 110.878  -3.585  1.00 26.85           C  
ATOM   2780  C   TRP E  18      14.763 111.783  -4.174  1.00 24.39           C  
ATOM   2781  O   TRP E  18      15.905 111.377  -4.336  1.00 24.60           O  
ATOM   2782  CB  TRP E  18      13.667 109.530  -4.306  1.00 27.02           C  
ATOM   2783  CG  TRP E  18      12.983 108.445  -3.515  1.00 28.73           C  
ATOM   2784  CD1 TRP E  18      12.608 108.498  -2.200  1.00 30.23           C  
ATOM   2785  CD2 TRP E  18      12.648 107.128  -3.973  1.00 29.35           C  
ATOM   2786  NE1 TRP E  18      12.061 107.293  -1.813  1.00 31.60           N  
ATOM   2787  CE2 TRP E  18      12.075 106.436  -2.883  1.00 30.89           C  
ATOM   2788  CE3 TRP E  18      12.778 106.465  -5.204  1.00 30.25           C  
ATOM   2789  CZ2 TRP E  18      11.634 105.109  -2.985  1.00 30.76           C  
ATOM   2790  CZ3 TRP E  18      12.336 105.143  -5.306  1.00 30.75           C  
ATOM   2791  CH2 TRP E  18      11.771 104.483  -4.200  1.00 29.78           C  
ATOM   2792  N   LEU E  19      14.400 113.015  -4.490  1.00 22.52           N  
ATOM   2793  CA  LEU E  19      15.361 113.969  -5.017  1.00 21.54           C  
ATOM   2794  C   LEU E  19      16.557 114.141  -4.072  1.00 22.87           C  
ATOM   2795  O   LEU E  19      17.698 114.177  -4.515  1.00 23.70           O  
ATOM   2796  CB  LEU E  19      14.682 115.315  -5.224  1.00 16.64           C  
ATOM   2797  CG  LEU E  19      15.585 116.499  -5.532  1.00 14.84           C  
ATOM   2798  CD1 LEU E  19      16.416 116.244  -6.795  1.00 13.84           C  
ATOM   2799  CD2 LEU E  19      14.702 117.716  -5.709  1.00 14.92           C  
ATOM   2800  N   LEU E  20      16.286 114.252  -2.772  1.00 25.71           N  
ATOM   2801  CA  LEU E  20      17.326 114.428  -1.756  1.00 27.84           C  
ATOM   2802  C   LEU E  20      18.463 113.403  -1.798  1.00 29.07           C  
ATOM   2803  O   LEU E  20      19.632 113.778  -1.881  1.00 27.53           O  
ATOM   2804  CB  LEU E  20      16.695 114.409  -0.369  1.00 28.35           C  
ATOM   2805  CG  LEU E  20      16.234 115.760   0.163  1.00 30.19           C  
ATOM   2806  CD1 LEU E  20      15.439 115.548   1.423  1.00 30.03           C  
ATOM   2807  CD2 LEU E  20      17.443 116.639   0.446  1.00 31.06           C  
ATOM   2808  N   ARG E  21      18.119 112.115  -1.726  1.00 30.19           N  
ATOM   2809  CA  ARG E  21      19.121 111.054  -1.758  1.00 29.83           C  
ATOM   2810  C   ARG E  21      19.752 110.952  -3.143  1.00 31.41           C  
ATOM   2811  O   ARG E  21      20.927 110.608  -3.274  1.00 32.55           O  
ATOM   2812  CB  ARG E  21      18.510 109.712  -1.364  1.00 28.31           C  
ATOM   2813  CG  ARG E  21      17.401 109.244  -2.269  1.00 28.09           C  
ATOM   2814  CD  ARG E  21      16.136 109.059  -1.477  1.00 30.29           C  
ATOM   2815  NE  ARG E  21      16.199 107.896  -0.599  1.00 35.36           N  
ATOM   2816  CZ  ARG E  21      15.371 107.676   0.419  1.00 36.16           C  
ATOM   2817  NH1 ARG E  21      14.412 108.548   0.704  1.00 33.85           N  
ATOM   2818  NH2 ARG E  21      15.497 106.574   1.145  1.00 37.69           N  
ATOM   2819  N   ALA E  22      18.976 111.265  -4.176  1.00 31.02           N  
ATOM   2820  CA  ALA E  22      19.490 111.229  -5.542  1.00 30.78           C  
ATOM   2821  C   ALA E  22      20.557 112.312  -5.726  1.00 30.49           C  
ATOM   2822  O   ALA E  22      21.569 112.079  -6.389  1.00 33.25           O  
ATOM   2823  CB  ALA E  22      18.354 111.443  -6.538  1.00 29.81           C  
ATOM   2824  N   ALA E  23      20.333 113.489  -5.140  1.00 28.48           N  
ATOM   2825  CA  ALA E  23      21.279 114.602  -5.239  1.00 26.36           C  
ATOM   2826  C   ALA E  23      22.459 114.414  -4.286  1.00 26.90           C  
ATOM   2827  O   ALA E  23      23.564 114.921  -4.519  1.00 26.56           O  
ATOM   2828  CB  ALA E  23      20.581 115.894  -4.927  1.00 27.03           C  
ATOM   2829  N   TRP E  24      22.209 113.699  -3.195  1.00 25.87           N  
ATOM   2830  CA  TRP E  24      23.239 113.431  -2.213  1.00 23.73           C  
ATOM   2831  C   TRP E  24      24.237 112.504  -2.896  1.00 25.12           C  
ATOM   2832  O   TRP E  24      25.389 112.881  -3.117  1.00 25.93           O  
ATOM   2833  CB  TRP E  24      22.629 112.782  -0.960  1.00 19.15           C  
ATOM   2834  CG  TRP E  24      23.633 112.059  -0.120  1.00 18.39           C  
ATOM   2835  CD1 TRP E  24      24.831 112.546   0.334  1.00 19.52           C  
ATOM   2836  CD2 TRP E  24      23.597 110.674   0.261  1.00 16.32           C  
ATOM   2837  NE1 TRP E  24      25.545 111.546   0.959  1.00 19.05           N  
ATOM   2838  CE2 TRP E  24      24.809 110.388   0.926  1.00 17.07           C  
ATOM   2839  CE3 TRP E  24      22.660 109.647   0.097  1.00 14.11           C  
ATOM   2840  CZ2 TRP E  24      25.107 109.114   1.419  1.00 14.66           C  
ATOM   2841  CZ3 TRP E  24      22.957 108.390   0.585  1.00 11.92           C  
ATOM   2842  CH2 TRP E  24      24.170 108.133   1.237  1.00 13.23           C  
ATOM   2843  N   LEU E  25      23.787 111.304  -3.249  1.00 24.96           N  
ATOM   2844  CA  LEU E  25      24.649 110.355  -3.927  1.00 26.05           C  
ATOM   2845  C   LEU E  25      25.353 111.028  -5.104  1.00 27.71           C  
ATOM   2846  O   LEU E  25      26.477 110.667  -5.456  1.00 28.45           O  
ATOM   2847  CB  LEU E  25      23.833 109.167  -4.426  1.00 24.19           C  
ATOM   2848  CG  LEU E  25      23.380 108.177  -3.350  1.00 25.05           C  
ATOM   2849  CD1 LEU E  25      22.306 107.272  -3.924  1.00 21.57           C  
ATOM   2850  CD2 LEU E  25      24.575 107.369  -2.844  1.00 20.10           C  
ATOM   2851  N   ALA E  26      24.689 112.017  -5.697  1.00 29.06           N  
ATOM   2852  CA  ALA E  26      25.246 112.738  -6.836  1.00 30.27           C  
ATOM   2853  C   ALA E  26      26.455 113.557  -6.432  1.00 31.29           C  
ATOM   2854  O   ALA E  26      27.421 113.649  -7.187  1.00 33.53           O  
ATOM   2855  CB  ALA E  26      24.195 113.639  -7.451  1.00 29.59           C  
ATOM   2856  N   GLN E  27      26.407 114.157  -5.245  1.00 32.52           N  
ATOM   2857  CA  GLN E  27      27.536 114.953  -4.773  1.00 32.01           C  
ATOM   2858  C   GLN E  27      28.619 114.017  -4.242  1.00 32.31           C  
ATOM   2859  O   GLN E  27      29.811 114.240  -4.472  1.00 32.90           O  
ATOM   2860  CB  GLN E  27      27.092 115.927  -3.690  1.00 31.86           C  
ATOM   2861  CG  GLN E  27      25.984 116.846  -4.137  1.00 32.07           C  
ATOM   2862  CD  GLN E  27      25.667 117.907  -3.108  1.00 32.59           C  
ATOM   2863  OE1 GLN E  27      26.343 118.929  -3.030  1.00 32.79           O  
ATOM   2864  NE2 GLN E  27      24.642 117.664  -2.302  1.00 30.46           N  
ATOM   2865  N   GLU E  28      28.213 112.966  -3.534  1.00 31.34           N  
ATOM   2866  CA  GLU E  28      29.189 112.007  -3.046  1.00 29.59           C  
ATOM   2867  C   GLU E  28      30.026 111.545  -4.235  1.00 28.08           C  
ATOM   2868  O   GLU E  28      31.235 111.384  -4.115  1.00 30.70           O  
ATOM   2869  CB  GLU E  28      28.512 110.796  -2.406  1.00 30.61           C  
ATOM   2870  CG  GLU E  28      27.941 111.020  -1.010  1.00 31.08           C  
ATOM   2871  CD  GLU E  28      28.998 111.365   0.033  1.00 32.65           C  
ATOM   2872  OE1 GLU E  28      30.175 110.977  -0.127  1.00 34.45           O  
ATOM   2873  OE2 GLU E  28      28.649 112.014   1.035  1.00 32.65           O  
ATOM   2874  N   LEU E  29      29.387 111.332  -5.380  1.00 25.33           N  
ATOM   2875  CA  LEU E  29      30.113 110.905  -6.562  1.00 24.86           C  
ATOM   2876  C   LEU E  29      31.027 112.011  -7.094  1.00 27.29           C  
ATOM   2877  O   LEU E  29      32.220 111.787  -7.325  1.00 31.08           O  
ATOM   2878  CB  LEU E  29      29.157 110.460  -7.679  1.00 22.08           C  
ATOM   2879  CG  LEU E  29      28.307 109.193  -7.507  1.00 20.00           C  
ATOM   2880  CD1 LEU E  29      27.578 108.873  -8.801  1.00 19.05           C  
ATOM   2881  CD2 LEU E  29      29.177 108.036  -7.118  1.00 19.33           C  
ATOM   2882  N   LEU E  30      30.484 113.206  -7.283  1.00 27.06           N  
ATOM   2883  CA  LEU E  30      31.281 114.315  -7.810  1.00 26.56           C  
ATOM   2884  C   LEU E  30      32.412 114.804  -6.918  1.00 27.92           C  
ATOM   2885  O   LEU E  30      33.385 115.358  -7.410  1.00 29.63           O  
ATOM   2886  CB  LEU E  30      30.371 115.491  -8.177  1.00 25.02           C  
ATOM   2887  CG  LEU E  30      29.475 115.220  -9.390  1.00 24.42           C  
ATOM   2888  CD1 LEU E  30      28.484 116.349  -9.582  1.00 21.03           C  
ATOM   2889  CD2 LEU E  30      30.350 115.033 -10.622  1.00 23.88           C  
ATOM   2890  N   SER E  31      32.301 114.619  -5.611  1.00 29.76           N  
ATOM   2891  CA  SER E  31      33.375 115.065  -4.741  1.00 32.13           C  
ATOM   2892  C   SER E  31      34.596 114.152  -4.879  1.00 34.60           C  
ATOM   2893  O   SER E  31      35.723 114.629  -5.034  1.00 37.87           O  
ATOM   2894  CB  SER E  31      32.904 115.097  -3.293  1.00 32.71           C  
ATOM   2895  OG  SER E  31      32.390 113.842  -2.908  1.00 37.23           O  
ATOM   2896  N   THR E  32      34.374 112.840  -4.843  1.00 35.67           N  
ATOM   2897  CA  THR E  32      35.464 111.878  -4.961  1.00 36.33           C  
ATOM   2898  C   THR E  32      35.963 111.696  -6.403  1.00 34.55           C  
ATOM   2899  O   THR E  32      37.115 111.352  -6.621  1.00 32.97           O  
ATOM   2900  CB  THR E  32      35.047 110.491  -4.375  1.00 38.79           C  
ATOM   2901  OG1 THR E  32      34.081 109.858  -5.230  1.00 42.83           O  
ATOM   2902  CG2 THR E  32      34.420 110.672  -2.997  1.00 40.84           C  
ATOM   2903  N   PHE E  33      35.105 111.945  -7.383  1.00 33.93           N  
ATOM   2904  CA  PHE E  33      35.492 111.777  -8.779  1.00 36.02           C  
ATOM   2905  C   PHE E  33      35.469 113.081  -9.560  1.00 36.43           C  
ATOM   2906  O   PHE E  33      35.086 113.108 -10.726  1.00 36.81           O  
ATOM   2907  CB  PHE E  33      34.571 110.757  -9.466  1.00 37.03           C  
ATOM   2908  CG  PHE E  33      34.721 109.350  -8.951  1.00 37.59           C  
ATOM   2909  CD1 PHE E  33      33.601 108.590  -8.628  1.00 37.44           C  
ATOM   2910  CD2 PHE E  33      35.982 108.781  -8.786  1.00 36.24           C  
ATOM   2911  CE1 PHE E  33      33.734 107.283  -8.149  1.00 38.77           C  
ATOM   2912  CE2 PHE E  33      36.123 107.480  -8.307  1.00 37.78           C  
ATOM   2913  CZ  PHE E  33      34.997 106.728  -7.988  1.00 37.66           C  
ATOM   2914  N   SER E  34      35.893 114.164  -8.928  1.00 38.22           N  
ATOM   2915  CA  SER E  34      35.883 115.461  -9.593  1.00 39.97           C  
ATOM   2916  C   SER E  34      36.646 115.483 -10.907  1.00 41.89           C  
ATOM   2917  O   SER E  34      36.362 116.297 -11.776  1.00 43.00           O  
ATOM   2918  CB  SER E  34      36.451 116.531  -8.661  1.00 38.66           C  
ATOM   2919  OG  SER E  34      37.726 116.160  -8.171  1.00 38.41           O  
ATOM   2920  N   ASP E  35      37.611 114.587 -11.062  1.00 44.41           N  
ATOM   2921  CA  ASP E  35      38.400 114.577 -12.286  1.00 47.50           C  
ATOM   2922  C   ASP E  35      38.056 113.446 -13.228  1.00 47.60           C  
ATOM   2923  O   ASP E  35      38.340 113.522 -14.422  1.00 49.14           O  
ATOM   2924  CB  ASP E  35      39.894 114.508 -11.956  1.00 50.48           C  
ATOM   2925  CG  ASP E  35      40.419 115.796 -11.357  1.00 53.44           C  
ATOM   2926  OD1 ASP E  35      40.181 116.869 -11.962  1.00 56.52           O  
ATOM   2927  OD2 ASP E  35      41.071 115.737 -10.291  1.00 52.66           O  
ATOM   2928  N   ASP E  36      37.432 112.403 -12.702  1.00 46.79           N  
ATOM   2929  CA  ASP E  36      37.099 111.259 -13.532  1.00 46.40           C  
ATOM   2930  C   ASP E  36      35.769 111.282 -14.269  1.00 44.78           C  
ATOM   2931  O   ASP E  36      35.643 110.629 -15.305  1.00 45.11           O  
ATOM   2932  CB  ASP E  36      37.198 109.978 -12.701  1.00 48.07           C  
ATOM   2933  CG  ASP E  36      38.613 109.698 -12.240  1.00 49.70           C  
ATOM   2934  OD1 ASP E  36      39.464 109.334 -13.085  1.00 50.81           O  
ATOM   2935  OD2 ASP E  36      38.880 109.854 -11.033  1.00 49.97           O  
ATOM   2936  N   LEU E  37      34.783 112.023 -13.770  1.00 42.30           N  
ATOM   2937  CA  LEU E  37      33.477 112.037 -14.431  1.00 40.91           C  
ATOM   2938  C   LEU E  37      33.149 113.274 -15.251  1.00 41.35           C  
ATOM   2939  O   LEU E  37      33.353 114.404 -14.805  1.00 42.25           O  
ATOM   2940  CB  LEU E  37      32.363 111.817 -13.406  1.00 38.51           C  
ATOM   2941  CG  LEU E  37      32.387 110.497 -12.630  1.00 38.87           C  
ATOM   2942  CD1 LEU E  37      31.175 110.449 -11.698  1.00 38.50           C  
ATOM   2943  CD2 LEU E  37      32.391 109.310 -13.592  1.00 35.14           C  
ATOM   2944  N   GLY E  38      32.624 113.051 -16.451  1.00 40.98           N  
ATOM   2945  CA  GLY E  38      32.245 114.160 -17.307  1.00 41.27           C  
ATOM   2946  C   GLY E  38      31.084 114.933 -16.705  1.00 41.75           C  
ATOM   2947  O   GLY E  38      31.110 116.167 -16.622  1.00 40.98           O  
ATOM   2948  N   LYS E  39      30.058 114.204 -16.277  1.00 41.59           N  
ATOM   2949  CA  LYS E  39      28.885 114.823 -15.672  1.00 42.39           C  
ATOM   2950  C   LYS E  39      27.970 113.785 -15.021  1.00 41.34           C  
ATOM   2951  O   LYS E  39      27.779 112.688 -15.558  1.00 42.20           O  
ATOM   2952  CB  LYS E  39      28.080 115.592 -16.734  1.00 42.43           C  
ATOM   2953  CG  LYS E  39      27.426 114.680 -17.769  1.00 44.88           C  
ATOM   2954  CD  LYS E  39      26.320 115.348 -18.571  1.00 45.08           C  
ATOM   2955  CE  LYS E  39      26.864 116.319 -19.604  1.00 46.61           C  
ATOM   2956  NZ  LYS E  39      25.755 116.801 -20.469  1.00 44.38           N  
ATOM   2957  N   VAL E  40      27.427 114.129 -13.857  1.00 40.11           N  
ATOM   2958  CA  VAL E  40      26.477 113.262 -13.156  1.00 38.58           C  
ATOM   2959  C   VAL E  40      25.136 113.980 -13.325  1.00 37.37           C  
ATOM   2960  O   VAL E  40      25.015 115.163 -13.005  1.00 35.15           O  
ATOM   2961  CB  VAL E  40      26.798 113.136 -11.654  1.00 39.04           C  
ATOM   2962  CG1 VAL E  40      25.710 112.345 -10.958  1.00 37.68           C  
ATOM   2963  CG2 VAL E  40      28.136 112.461 -11.465  1.00 37.84           C  
ATOM   2964  N   SER E  41      24.134 113.275 -13.837  1.00 37.00           N  
ATOM   2965  CA  SER E  41      22.836 113.893 -14.073  1.00 37.42           C  
ATOM   2966  C   SER E  41      21.695 113.383 -13.192  1.00 36.51           C  
ATOM   2967  O   SER E  41      21.621 112.194 -12.877  1.00 35.20           O  
ATOM   2968  CB  SER E  41      22.445 113.718 -15.550  1.00 38.74           C  
ATOM   2969  OG  SER E  41      23.464 114.173 -16.426  1.00 39.38           O  
ATOM   2970  N   LEU E  42      20.815 114.303 -12.800  1.00 36.54           N  
ATOM   2971  CA  LEU E  42      19.638 113.973 -11.998  1.00 36.34           C  
ATOM   2972  C   LEU E  42      18.461 113.961 -12.964  1.00 38.08           C  
ATOM   2973  O   LEU E  42      18.180 114.975 -13.623  1.00 39.36           O  
ATOM   2974  CB  LEU E  42      19.389 115.023 -10.920  1.00 32.36           C  
ATOM   2975  CG  LEU E  42      20.477 115.216  -9.875  1.00 30.55           C  
ATOM   2976  CD1 LEU E  42      19.953 116.133  -8.813  1.00 28.07           C  
ATOM   2977  CD2 LEU E  42      20.868 113.885  -9.264  1.00 31.69           C  
ATOM   2978  N   GLU E  43      17.777 112.819 -13.042  1.00 39.17           N  
ATOM   2979  CA  GLU E  43      16.645 112.633 -13.947  1.00 38.45           C  
ATOM   2980  C   GLU E  43      15.358 112.207 -13.258  1.00 39.05           C  
ATOM   2981  O   GLU E  43      15.288 111.124 -12.679  1.00 40.40           O  
ATOM   2982  CB  GLU E  43      17.011 111.587 -14.998  1.00 37.31           C  
ATOM   2983  CG  GLU E  43      15.897 111.214 -15.948  1.00 39.83           C  
ATOM   2984  CD  GLU E  43      16.263 110.008 -16.793  1.00 43.41           C  
ATOM   2985  OE1 GLU E  43      16.402 108.897 -16.230  1.00 43.50           O  
ATOM   2986  OE2 GLU E  43      16.422 110.170 -18.020  1.00 44.93           O  
ATOM   2987  N   PRO E  44      14.320 113.053 -13.316  1.00 39.43           N  
ATOM   2988  CA  PRO E  44      13.026 112.747 -12.701  1.00 40.25           C  
ATOM   2989  C   PRO E  44      12.398 111.507 -13.336  1.00 42.19           C  
ATOM   2990  O   PRO E  44      12.612 111.230 -14.519  1.00 42.90           O  
ATOM   2991  CB  PRO E  44      12.209 113.995 -12.989  1.00 37.86           C  
ATOM   2992  CG  PRO E  44      13.227 115.057 -12.968  1.00 38.47           C  
ATOM   2993  CD  PRO E  44      14.344 114.449 -13.773  1.00 39.18           C  
ATOM   2994  N   ALA E  45      11.632 110.765 -12.537  1.00 43.74           N  
ATOM   2995  CA  ALA E  45      10.936 109.554 -12.982  1.00 43.30           C  
ATOM   2996  C   ALA E  45       9.800 109.300 -12.001  1.00 44.91           C  
ATOM   2997  O   ALA E  45       9.569 110.103 -11.093  1.00 46.56           O  
ATOM   2998  CB  ALA E  45      11.883 108.378 -12.997  1.00 40.62           C  
ATOM   2999  N   THR E  46       9.089 108.193 -12.167  1.00 45.76           N  
ATOM   3000  CA  THR E  46       7.983 107.901 -11.264  1.00 47.27           C  
ATOM   3001  C   THR E  46       7.900 106.442 -10.853  1.00 46.91           C  
ATOM   3002  O   THR E  46       8.725 105.620 -11.253  1.00 47.21           O  
ATOM   3003  CB  THR E  46       6.626 108.293 -11.890  1.00 48.60           C  
ATOM   3004  OG1 THR E  46       6.520 107.719 -13.198  1.00 50.03           O  
ATOM   3005  CG2 THR E  46       6.498 109.809 -11.993  1.00 51.66           C  
ATOM   3006  N   GLY E  47       6.888 106.138 -10.048  1.00 45.13           N  
ATOM   3007  CA  GLY E  47       6.673 104.783  -9.590  1.00 44.26           C  
ATOM   3008  C   GLY E  47       7.873 104.118  -8.949  1.00 44.06           C  
ATOM   3009  O   GLY E  47       8.482 103.227  -9.543  1.00 46.20           O  
ATOM   3010  N   GLY E  48       8.204 104.550  -7.733  1.00 41.97           N  
ATOM   3011  CA  GLY E  48       9.322 103.989  -6.997  1.00 37.94           C  
ATOM   3012  C   GLY E  48      10.583 103.684  -7.781  1.00 36.02           C  
ATOM   3013  O   GLY E  48      11.340 102.786  -7.415  1.00 36.04           O  
ATOM   3014  N   ALA E  49      10.830 104.427  -8.851  1.00 33.96           N  
ATOM   3015  CA  ALA E  49      12.022 104.181  -9.646  1.00 32.10           C  
ATOM   3016  C   ALA E  49      13.240 104.866  -9.066  1.00 31.83           C  
ATOM   3017  O   ALA E  49      13.197 106.043  -8.715  1.00 31.56           O  
ATOM   3018  CB  ALA E  49      11.816 104.638 -11.070  1.00 28.81           C  
ATOM   3019  N   PHE E  50      14.311 104.092  -8.943  1.00 32.04           N  
ATOM   3020  CA  PHE E  50      15.600 104.570  -8.466  1.00 32.25           C  
ATOM   3021  C   PHE E  50      16.653 103.673  -9.107  1.00 33.14           C  
ATOM   3022  O   PHE E  50      16.988 102.603  -8.594  1.00 30.53           O  
ATOM   3023  CB  PHE E  50      15.746 104.499  -6.947  1.00 30.26           C  
ATOM   3024  CG  PHE E  50      16.873 105.345  -6.436  1.00 27.33           C  
ATOM   3025  CD1 PHE E  50      16.711 106.718  -6.292  1.00 26.05           C  
ATOM   3026  CD2 PHE E  50      18.125 104.799  -6.218  1.00 26.09           C  
ATOM   3027  CE1 PHE E  50      17.785 107.542  -5.944  1.00 24.84           C  
ATOM   3028  CE2 PHE E  50      19.207 105.614  -5.871  1.00 26.31           C  
ATOM   3029  CZ  PHE E  50      19.031 106.987  -5.737  1.00 25.46           C  
ATOM   3030  N   ARG E  51      17.164 104.134 -10.239  1.00 34.08           N  
ATOM   3031  CA  ARG E  51      18.153 103.407 -11.009  1.00 34.52           C  
ATOM   3032  C   ARG E  51      19.316 104.340 -11.343  1.00 33.83           C  
ATOM   3033  O   ARG E  51      19.101 105.476 -11.765  1.00 36.44           O  
ATOM   3034  CB  ARG E  51      17.463 102.895 -12.281  1.00 35.65           C  
ATOM   3035  CG  ARG E  51      18.314 102.122 -13.277  1.00 34.83           C  
ATOM   3036  CD  ARG E  51      17.424 101.534 -14.378  1.00 33.27           C  
ATOM   3037  NE  ARG E  51      18.196 100.780 -15.354  1.00 31.23           N  
ATOM   3038  CZ  ARG E  51      18.690 101.289 -16.474  1.00 32.04           C  
ATOM   3039  NH1 ARG E  51      18.480 102.567 -16.778  1.00 31.02           N  
ATOM   3040  NH2 ARG E  51      19.434 100.526 -17.266  1.00 31.86           N  
ATOM   3041  N   ILE E  52      20.539 103.860 -11.143  1.00 32.35           N  
ATOM   3042  CA  ILE E  52      21.749 104.635 -11.430  1.00 31.26           C  
ATOM   3043  C   ILE E  52      22.571 103.941 -12.516  1.00 32.76           C  
ATOM   3044  O   ILE E  52      22.704 102.721 -12.511  1.00 34.44           O  
ATOM   3045  CB  ILE E  52      22.645 104.762 -10.180  1.00 29.19           C  
ATOM   3046  CG1 ILE E  52      21.833 105.321  -9.014  1.00 27.96           C  
ATOM   3047  CG2 ILE E  52      23.812 105.681 -10.474  1.00 26.70           C  
ATOM   3048  CD1 ILE E  52      22.545 105.270  -7.679  1.00 28.62           C  
ATOM   3049  N   THR E  53      23.123 104.709 -13.447  1.00 34.03           N  
ATOM   3050  CA  THR E  53      23.937 104.126 -14.506  1.00 35.60           C  
ATOM   3051  C   THR E  53      25.228 104.903 -14.767  1.00 37.36           C  
ATOM   3052  O   THR E  53      25.377 106.053 -14.359  1.00 37.27           O  
ATOM   3053  CB  THR E  53      23.146 104.007 -15.818  1.00 35.10           C  
ATOM   3054  OG1 THR E  53      22.754 105.310 -16.272  1.00 35.37           O  
ATOM   3055  CG2 THR E  53      21.913 103.161 -15.604  1.00 34.75           C  
ATOM   3056  N   CYS E  54      26.168 104.250 -15.436  1.00 40.74           N  
ATOM   3057  CA  CYS E  54      27.463 104.845 -15.757  1.00 44.91           C  
ATOM   3058  C   CYS E  54      27.781 104.445 -17.200  1.00 47.34           C  
ATOM   3059  O   CYS E  54      28.150 103.302 -17.473  1.00 49.60           O  
ATOM   3060  CB  CYS E  54      28.520 104.293 -14.802  1.00 44.23           C  
ATOM   3061  SG  CYS E  54      30.073 105.173 -14.791  1.00 48.68           S  
ATOM   3062  N   ASP E  55      27.629 105.386 -18.125  1.00 48.70           N  
ATOM   3063  CA  ASP E  55      27.855 105.098 -19.534  1.00 47.52           C  
ATOM   3064  C   ASP E  55      26.786 104.130 -19.995  1.00 45.18           C  
ATOM   3065  O   ASP E  55      27.043 103.222 -20.772  1.00 45.70           O  
ATOM   3066  CB  ASP E  55      29.233 104.497 -19.745  1.00 50.38           C  
ATOM   3067  CG  ASP E  55      30.314 105.535 -19.686  1.00 55.72           C  
ATOM   3068  OD1 ASP E  55      30.230 106.412 -18.795  1.00 59.74           O  
ATOM   3069  OD2 ASP E  55      31.243 105.480 -20.523  1.00 57.63           O  
ATOM   3070  N   GLY E  56      25.577 104.334 -19.489  1.00 43.07           N  
ATOM   3071  CA  GLY E  56      24.465 103.488 -19.868  1.00 42.20           C  
ATOM   3072  C   GLY E  56      24.368 102.188 -19.097  1.00 41.07           C  
ATOM   3073  O   GLY E  56      23.312 101.550 -19.083  1.00 41.00           O  
ATOM   3074  N   VAL E  57      25.462 101.791 -18.453  1.00 39.02           N  
ATOM   3075  CA  VAL E  57      25.466 100.554 -17.691  1.00 36.49           C  
ATOM   3076  C   VAL E  57      24.880 100.713 -16.299  1.00 36.54           C  
ATOM   3077  O   VAL E  57      25.258 101.615 -15.556  1.00 38.19           O  
ATOM   3078  CB  VAL E  57      26.873  99.989 -17.573  1.00 33.51           C  
ATOM   3079  CG1 VAL E  57      26.844  98.695 -16.786  1.00 32.25           C  
ATOM   3080  CG2 VAL E  57      27.428  99.750 -18.951  1.00 32.53           C  
ATOM   3081  N   GLN E  58      23.957  99.822 -15.950  1.00 35.84           N  
ATOM   3082  CA  GLN E  58      23.310  99.858 -14.641  1.00 34.96           C  
ATOM   3083  C   GLN E  58      24.268  99.432 -13.533  1.00 33.41           C  
ATOM   3084  O   GLN E  58      24.930  98.395 -13.640  1.00 35.33           O  
ATOM   3085  CB  GLN E  58      22.077  98.939 -14.627  1.00 34.88           C  
ATOM   3086  CG  GLN E  58      21.354  98.892 -13.284  1.00 37.84           C  
ATOM   3087  CD  GLN E  58      20.128  97.977 -13.279  1.00 40.19           C  
ATOM   3088  OE1 GLN E  58      19.158  98.209 -14.003  1.00 41.22           O  
ATOM   3089  NE2 GLN E  58      20.170  96.934 -12.453  1.00 40.80           N  
ATOM   3090  N   ILE E  59      24.358 100.235 -12.480  1.00 29.79           N  
ATOM   3091  CA  ILE E  59      25.210  99.886 -11.357  1.00 27.35           C  
ATOM   3092  C   ILE E  59      24.357  99.856 -10.107  1.00 27.40           C  
ATOM   3093  O   ILE E  59      24.821  99.514  -9.031  1.00 28.16           O  
ATOM   3094  CB  ILE E  59      26.382 100.874 -11.172  1.00 26.55           C  
ATOM   3095  CG1 ILE E  59      25.856 102.295 -10.955  1.00 24.75           C  
ATOM   3096  CG2 ILE E  59      27.315 100.798 -12.380  1.00 27.36           C  
ATOM   3097  CD1 ILE E  59      26.948 103.311 -10.750  1.00 15.63           C  
ATOM   3098  N   TRP E  60      23.095 100.229 -10.254  1.00 28.17           N  
ATOM   3099  CA  TRP E  60      22.177 100.191  -9.130  1.00 27.79           C  
ATOM   3100  C   TRP E  60      20.736 100.392  -9.559  1.00 28.71           C  
ATOM   3101  O   TRP E  60      20.432 101.258 -10.365  1.00 27.68           O  
ATOM   3102  CB  TRP E  60      22.554 101.223  -8.050  1.00 26.46           C  
ATOM   3103  CG  TRP E  60      21.763 101.018  -6.755  1.00 26.93           C  
ATOM   3104  CD1 TRP E  60      20.478 101.421  -6.503  1.00 24.71           C  
ATOM   3105  CD2 TRP E  60      22.171 100.262  -5.600  1.00 24.71           C  
ATOM   3106  NE1 TRP E  60      20.062 100.960  -5.281  1.00 23.07           N  
ATOM   3107  CE2 TRP E  60      21.078 100.248  -4.701  1.00 23.35           C  
ATOM   3108  CE3 TRP E  60      23.347  99.589  -5.242  1.00 25.16           C  
ATOM   3109  CZ2 TRP E  60      21.127  99.591  -3.468  1.00 22.00           C  
ATOM   3110  CZ3 TRP E  60      23.394  98.930  -4.012  1.00 24.33           C  
ATOM   3111  CH2 TRP E  60      22.289  98.939  -3.141  1.00 22.12           C  
ATOM   3112  N   GLU E  61      19.857  99.557  -9.016  1.00 31.62           N  
ATOM   3113  CA  GLU E  61      18.432  99.634  -9.298  1.00 34.75           C  
ATOM   3114  C   GLU E  61      17.659  99.099  -8.088  1.00 36.10           C  
ATOM   3115  O   GLU E  61      17.727  97.913  -7.767  1.00 37.11           O  
ATOM   3116  CB  GLU E  61      18.097  98.843 -10.561  1.00 36.16           C  
ATOM   3117  CG  GLU E  61      16.672  99.023 -11.051  1.00 40.42           C  
ATOM   3118  CD  GLU E  61      15.688  98.198 -10.263  1.00 42.08           C  
ATOM   3119  OE1 GLU E  61      15.825  96.958 -10.293  1.00 44.60           O  
ATOM   3120  OE2 GLU E  61      14.787  98.781  -9.618  1.00 42.93           O  
ATOM   3121  N   ARG E  62      16.945 100.007  -7.421  1.00 36.63           N  
ATOM   3122  CA  ARG E  62      16.140  99.734  -6.229  1.00 35.93           C  
ATOM   3123  C   ARG E  62      15.824  98.281  -5.933  1.00 38.01           C  
ATOM   3124  O   ARG E  62      16.398  97.679  -5.019  1.00 37.82           O  
ATOM   3125  CB  ARG E  62      14.825 100.500  -6.313  1.00 34.35           C  
ATOM   3126  CG  ARG E  62      14.534 101.339  -5.093  1.00 32.24           C  
ATOM   3127  CD  ARG E  62      13.303 100.846  -4.396  1.00 32.73           C  
ATOM   3128  NE  ARG E  62      12.093 101.108  -5.163  1.00 31.00           N  
ATOM   3129  CZ  ARG E  62      11.077 100.259  -5.232  1.00 32.36           C  
ATOM   3130  NH1 ARG E  62      11.143  99.108  -4.586  1.00 32.67           N  
ATOM   3131  NH2 ARG E  62       9.993 100.554  -5.935  1.00 33.68           N  
ATOM   3132  N   LYS E  63      14.894  97.726  -6.702  1.00 39.57           N  
ATOM   3133  CA  LYS E  63      14.478  96.344  -6.511  1.00 40.19           C  
ATOM   3134  C   LYS E  63      15.641  95.355  -6.588  1.00 40.94           C  
ATOM   3135  O   LYS E  63      15.916  94.632  -5.631  1.00 42.27           O  
ATOM   3136  CB  LYS E  63      13.420  95.979  -7.548  1.00 40.45           C  
ATOM   3137  CG  LYS E  63      12.224  96.917  -7.567  1.00 41.19           C  
ATOM   3138  CD  LYS E  63      11.093  96.361  -8.422  1.00 41.89           C  
ATOM   3139  CE  LYS E  63      11.562  95.990  -9.832  1.00 44.15           C  
ATOM   3140  NZ  LYS E  63      12.121  97.143 -10.603  1.00 46.29           N  
ATOM   3141  N   ALA E  64      16.321  95.340  -7.730  1.00 40.46           N  
ATOM   3142  CA  ALA E  64      17.447  94.442  -7.976  1.00 39.86           C  
ATOM   3143  C   ALA E  64      18.538  94.471  -6.917  1.00 39.92           C  
ATOM   3144  O   ALA E  64      19.085  93.431  -6.559  1.00 40.26           O  
ATOM   3145  CB  ALA E  64      18.062  94.743  -9.344  1.00 39.03           C  
ATOM   3146  N   ASP E  65      18.861  95.655  -6.414  1.00 39.60           N  
ATOM   3147  CA  ASP E  65      19.919  95.756  -5.426  1.00 38.62           C  
ATOM   3148  C   ASP E  65      19.415  95.858  -3.994  1.00 37.54           C  
ATOM   3149  O   ASP E  65      20.196  96.039  -3.066  1.00 37.86           O  
ATOM   3150  CB  ASP E  65      20.837  96.922  -5.793  1.00 39.33           C  
ATOM   3151  CG  ASP E  65      21.442  96.760  -7.183  1.00 39.62           C  
ATOM   3152  OD1 ASP E  65      22.251  95.836  -7.382  1.00 39.00           O  
ATOM   3153  OD2 ASP E  65      21.099  97.539  -8.091  1.00 40.53           O  
ATOM   3154  N   GLY E  66      18.101  95.740  -3.828  1.00 37.24           N  
ATOM   3155  CA  GLY E  66      17.489  95.762  -2.509  1.00 36.14           C  
ATOM   3156  C   GLY E  66      17.422  97.046  -1.703  1.00 35.66           C  
ATOM   3157  O   GLY E  66      17.560  97.003  -0.480  1.00 36.42           O  
ATOM   3158  N   GLY E  67      17.205  98.182  -2.359  1.00 34.84           N  
ATOM   3159  CA  GLY E  67      17.108  99.437  -1.628  1.00 33.14           C  
ATOM   3160  C   GLY E  67      17.911 100.603  -2.166  1.00 32.14           C  
ATOM   3161  O   GLY E  67      17.855 100.916  -3.352  1.00 31.31           O  
ATOM   3162  N   PHE E  68      18.650 101.253  -1.274  1.00 32.32           N  
ATOM   3163  CA  PHE E  68      19.474 102.399  -1.637  1.00 33.23           C  
ATOM   3164  C   PHE E  68      20.934 102.132  -1.307  1.00 33.91           C  
ATOM   3165  O   PHE E  68      21.273 101.592  -0.251  1.00 33.97           O  
ATOM   3166  CB  PHE E  68      18.963 103.638  -0.922  1.00 32.16           C  
ATOM   3167  CG  PHE E  68      17.529 103.917  -1.211  1.00 32.25           C  
ATOM   3168  CD1 PHE E  68      17.158 104.552  -2.385  1.00 32.23           C  
ATOM   3169  CD2 PHE E  68      16.539 103.471  -0.348  1.00 32.13           C  
ATOM   3170  CE1 PHE E  68      15.821 104.732  -2.699  1.00 34.46           C  
ATOM   3171  CE2 PHE E  68      15.204 103.644  -0.650  1.00 32.31           C  
ATOM   3172  CZ  PHE E  68      14.840 104.277  -1.828  1.00 34.14           C  
ATOM   3173  N   PRO E  69      21.824 102.517  -2.212  1.00 33.91           N  
ATOM   3174  CA  PRO E  69      23.245 102.290  -1.995  1.00 34.39           C  
ATOM   3175  C   PRO E  69      23.895 103.046  -0.852  1.00 34.99           C  
ATOM   3176  O   PRO E  69      23.401 104.078  -0.401  1.00 35.12           O  
ATOM   3177  CB  PRO E  69      23.845 102.655  -3.343  1.00 33.51           C  
ATOM   3178  CG  PRO E  69      22.999 103.806  -3.750  1.00 33.62           C  
ATOM   3179  CD  PRO E  69      21.601 103.308  -3.432  1.00 32.97           C  
ATOM   3180  N   GLU E  70      25.005 102.478  -0.388  1.00 35.26           N  
ATOM   3181  CA  GLU E  70      25.834 103.040   0.658  1.00 35.53           C  
ATOM   3182  C   GLU E  70      26.780 103.905  -0.138  1.00 36.15           C  
ATOM   3183  O   GLU E  70      27.057 103.609  -1.296  1.00 38.12           O  
ATOM   3184  CB  GLU E  70      26.659 101.956   1.339  1.00 35.49           C  
ATOM   3185  CG  GLU E  70      25.895 101.007   2.214  1.00 37.14           C  
ATOM   3186  CD  GLU E  70      26.743  99.831   2.661  1.00 38.69           C  
ATOM   3187  OE1 GLU E  70      27.833 100.037   3.233  1.00 39.92           O  
ATOM   3188  OE2 GLU E  70      26.319  98.688   2.433  1.00 40.24           O  
ATOM   3189  N   ALA E  71      27.299 104.954   0.473  1.00 35.35           N  
ATOM   3190  CA  ALA E  71      28.215 105.821  -0.237  1.00 33.53           C  
ATOM   3191  C   ALA E  71      29.459 105.067  -0.717  1.00 32.45           C  
ATOM   3192  O   ALA E  71      29.907 105.251  -1.843  1.00 31.61           O  
ATOM   3193  CB  ALA E  71      28.618 106.986   0.655  1.00 34.65           C  
ATOM   3194  N   LYS E  72      30.015 104.215   0.130  1.00 30.84           N  
ATOM   3195  CA  LYS E  72      31.211 103.492  -0.259  1.00 31.73           C  
ATOM   3196  C   LYS E  72      30.942 102.510  -1.388  1.00 32.15           C  
ATOM   3197  O   LYS E  72      31.799 102.292  -2.250  1.00 32.34           O  
ATOM   3198  CB  LYS E  72      31.826 102.778   0.951  1.00 32.99           C  
ATOM   3199  CG  LYS E  72      31.010 101.649   1.546  1.00 36.06           C  
ATOM   3200  CD  LYS E  72      31.688 101.133   2.807  1.00 38.61           C  
ATOM   3201  CE  LYS E  72      30.990  99.898   3.356  1.00 41.39           C  
ATOM   3202  NZ  LYS E  72      31.493  99.559   4.723  1.00 40.77           N  
ATOM   3203  N   VAL E  73      29.746 101.933  -1.403  1.00 31.46           N  
ATOM   3204  CA  VAL E  73      29.385 100.988  -2.452  1.00 31.13           C  
ATOM   3205  C   VAL E  73      29.267 101.645  -3.820  1.00 31.05           C  
ATOM   3206  O   VAL E  73      29.875 101.195  -4.785  1.00 32.19           O  
ATOM   3207  CB  VAL E  73      28.040 100.308  -2.174  1.00 30.92           C  
ATOM   3208  CG1 VAL E  73      27.706  99.355  -3.316  1.00 27.13           C  
ATOM   3209  CG2 VAL E  73      28.091  99.573  -0.846  1.00 31.07           C  
ATOM   3210  N   LEU E  74      28.475 102.703  -3.907  1.00 29.86           N  
ATOM   3211  CA  LEU E  74      28.278 103.378  -5.181  1.00 30.30           C  
ATOM   3212  C   LEU E  74      29.604 103.828  -5.774  1.00 30.81           C  
ATOM   3213  O   LEU E  74      29.845 103.675  -6.973  1.00 32.36           O  
ATOM   3214  CB  LEU E  74      27.363 104.588  -5.004  1.00 27.79           C  
ATOM   3215  CG  LEU E  74      26.880 105.275  -6.275  1.00 25.83           C  
ATOM   3216  CD1 LEU E  74      25.928 104.374  -7.023  1.00 22.72           C  
ATOM   3217  CD2 LEU E  74      26.200 106.556  -5.903  1.00 26.22           C  
ATOM   3218  N   LYS E  75      30.458 104.381  -4.919  1.00 30.96           N  
ATOM   3219  CA  LYS E  75      31.768 104.871  -5.325  1.00 30.78           C  
ATOM   3220  C   LYS E  75      32.632 103.769  -5.913  1.00 31.20           C  
ATOM   3221  O   LYS E  75      33.289 103.961  -6.933  1.00 33.16           O  
ATOM   3222  CB  LYS E  75      32.489 105.496  -4.128  1.00 30.59           C  
ATOM   3223  CG  LYS E  75      31.889 106.816  -3.652  1.00 34.58           C  
ATOM   3224  CD  LYS E  75      32.506 107.308  -2.325  1.00 37.81           C  
ATOM   3225  CE  LYS E  75      31.948 108.678  -1.909  1.00 36.52           C  
ATOM   3226  NZ  LYS E  75      32.473 109.134  -0.597  1.00 34.19           N  
ATOM   3227  N   GLN E  76      32.637 102.611  -5.269  1.00 31.02           N  
ATOM   3228  CA  GLN E  76      33.452 101.509  -5.746  1.00 30.03           C  
ATOM   3229  C   GLN E  76      32.912 100.911  -7.031  1.00 30.27           C  
ATOM   3230  O   GLN E  76      33.673 100.539  -7.924  1.00 31.54           O  
ATOM   3231  CB  GLN E  76      33.551 100.419  -4.683  1.00 29.44           C  
ATOM   3232  CG  GLN E  76      34.556  99.339  -5.046  1.00 29.31           C  
ATOM   3233  CD  GLN E  76      35.868  99.928  -5.529  1.00 28.73           C  
ATOM   3234  OE1 GLN E  76      36.471 100.762  -4.863  1.00 29.42           O  
ATOM   3235  NE2 GLN E  76      36.311  99.496  -6.691  1.00 32.10           N  
ATOM   3236  N   ARG E  77      31.594 100.807  -7.114  1.00 28.47           N  
ATOM   3237  CA  ARG E  77      30.971 100.253  -8.296  1.00 25.82           C  
ATOM   3238  C   ARG E  77      31.286 101.129  -9.508  1.00 25.88           C  
ATOM   3239  O   ARG E  77      31.443 100.628 -10.621  1.00 25.34           O  
ATOM   3240  CB  ARG E  77      29.465 100.158  -8.089  1.00 23.26           C  
ATOM   3241  CG  ARG E  77      28.933  98.862  -7.480  1.00 17.37           C  
ATOM   3242  CD  ARG E  77      27.472  99.119  -7.312  1.00 20.64           C  
ATOM   3243  NE  ARG E  77      26.596  97.972  -7.136  1.00 22.96           N  
ATOM   3244  CZ  ARG E  77      26.700  97.089  -6.159  1.00 26.55           C  
ATOM   3245  NH1 ARG E  77      27.677  97.206  -5.262  1.00 26.13           N  
ATOM   3246  NH2 ARG E  77      25.784  96.130  -6.045  1.00 20.39           N  
ATOM   3247  N   VAL E  78      31.369 102.438  -9.285  1.00 25.94           N  
ATOM   3248  CA  VAL E  78      31.665 103.383 -10.355  1.00 26.23           C  
ATOM   3249  C   VAL E  78      33.140 103.251 -10.660  1.00 27.70           C  
ATOM   3250  O   VAL E  78      33.585 103.424 -11.788  1.00 28.25           O  
ATOM   3251  CB  VAL E  78      31.339 104.841  -9.918  1.00 24.75           C  
ATOM   3252  CG1 VAL E  78      31.904 105.845 -10.896  1.00 21.04           C  
ATOM   3253  CG2 VAL E  78      29.845 105.020  -9.842  1.00 25.16           C  
ATOM   3254  N   ARG E  79      33.897 102.931  -9.626  1.00 31.01           N  
ATOM   3255  CA  ARG E  79      35.334 102.763  -9.747  1.00 33.89           C  
ATOM   3256  C   ARG E  79      35.551 101.591 -10.706  1.00 35.74           C  
ATOM   3257  O   ARG E  79      36.292 101.699 -11.684  1.00 36.96           O  
ATOM   3258  CB  ARG E  79      35.923 102.437  -8.369  1.00 33.24           C  
ATOM   3259  CG  ARG E  79      37.363 102.841  -8.182  1.00 36.64           C  
ATOM   3260  CD  ARG E  79      37.462 104.123  -7.378  1.00 36.68           C  
ATOM   3261  NE  ARG E  79      36.873 103.966  -6.051  1.00 36.98           N  
ATOM   3262  CZ  ARG E  79      36.883 104.908  -5.113  1.00 36.43           C  
ATOM   3263  NH1 ARG E  79      37.458 106.081  -5.353  1.00 38.15           N  
ATOM   3264  NH2 ARG E  79      36.304 104.687  -3.944  1.00 33.54           N  
ATOM   3265  N   ASP E  80      34.881 100.478 -10.421  1.00 36.33           N  
ATOM   3266  CA  ASP E  80      34.994  99.283 -11.238  1.00 38.47           C  
ATOM   3267  C   ASP E  80      34.581  99.554 -12.663  1.00 42.36           C  
ATOM   3268  O   ASP E  80      35.218  99.091 -13.605  1.00 46.37           O  
ATOM   3269  CB  ASP E  80      34.123  98.175 -10.669  1.00 33.74           C  
ATOM   3270  CG  ASP E  80      34.628  97.674  -9.347  1.00 33.92           C  
ATOM   3271  OD1 ASP E  80      33.878  96.944  -8.673  1.00 32.68           O  
ATOM   3272  OD2 ASP E  80      35.779  98.007  -8.989  1.00 33.77           O  
ATOM   3273  N   GLN E  81      33.506 100.308 -12.822  1.00 44.92           N  
ATOM   3274  CA  GLN E  81      33.017 100.623 -14.140  1.00 45.34           C  
ATOM   3275  C   GLN E  81      34.047 101.438 -14.909  1.00 47.20           C  
ATOM   3276  O   GLN E  81      34.404 101.081 -16.021  1.00 48.31           O  
ATOM   3277  CB  GLN E  81      31.709 101.393 -14.029  1.00 46.94           C  
ATOM   3278  CG  GLN E  81      30.998 101.552 -15.357  1.00 48.75           C  
ATOM   3279  CD  GLN E  81      30.459 100.236 -15.880  1.00 48.21           C  
ATOM   3280  OE1 GLN E  81      30.117 100.121 -17.063  1.00 46.93           O  
ATOM   3281  NE2 GLN E  81      30.368  99.235 -14.998  1.00 45.04           N  
ATOM   3282  N   ILE E  82      34.529 102.525 -14.311  1.00 49.75           N  
ATOM   3283  CA  ILE E  82      35.508 103.401 -14.948  1.00 52.91           C  
ATOM   3284  C   ILE E  82      36.759 102.694 -15.472  1.00 55.64           C  
ATOM   3285  O   ILE E  82      37.409 103.191 -16.391  1.00 55.45           O  
ATOM   3286  CB  ILE E  82      35.948 104.519 -13.992  1.00 53.64           C  
ATOM   3287  CG1 ILE E  82      34.755 105.395 -13.639  1.00 53.32           C  
ATOM   3288  CG2 ILE E  82      37.008 105.393 -14.647  1.00 54.86           C  
ATOM   3289  CD1 ILE E  82      35.100 106.460 -12.634  1.00 55.30           C  
ATOM   3290  N   ASP E  83      37.101 101.555 -14.871  1.00 60.56           N  
ATOM   3291  CA  ASP E  83      38.260 100.747 -15.271  1.00 64.87           C  
ATOM   3292  C   ASP E  83      38.647  99.844 -14.111  1.00 67.99           C  
ATOM   3293  O   ASP E  83      38.959 100.324 -13.020  1.00 68.14           O  
ATOM   3294  CB  ASP E  83      39.466 101.615 -15.641  1.00 66.01           C  
ATOM   3295  CG  ASP E  83      40.444 100.888 -16.553  1.00 67.25           C  
ATOM   3296  OD1 ASP E  83      40.769  99.714 -16.262  1.00 68.39           O  
ATOM   3297  OD2 ASP E  83      40.886 101.490 -17.557  1.00 65.99           O  
ATOM   3298  N   PRO E  84      38.636  98.519 -14.335  1.00 70.30           N  
ATOM   3299  CA  PRO E  84      38.986  97.550 -13.285  1.00 71.81           C  
ATOM   3300  C   PRO E  84      40.435  97.646 -12.766  1.00 73.94           C  
ATOM   3301  O   PRO E  84      41.004  96.590 -12.389  1.00 73.93           O  
ATOM   3302  CB  PRO E  84      38.687  96.200 -13.953  1.00 72.19           C  
ATOM   3303  CG  PRO E  84      37.597  96.543 -14.951  1.00 71.35           C  
ATOM   3304  CD  PRO E  84      38.117  97.833 -15.533  1.00 70.97           C  
TER    3305      PRO E  84                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
