
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 (  663),  selected   84 , name 2oka_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2oka_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     4_A      -       -           -
LGA    K     5_A      T      12          0.976
LGA    P     6_A      H      13          1.083
LGA    E     7_A      R      14          0.663
LGA    I     8_A      V      15          0.508
LGA    V     9_A      Q      16          0.639
LGA    I    10_A      I      17          0.312
LGA    T    11_A      E      18          0.395
LGA    Y    12_A      Y      19          0.494
LGA    C    13_A      C      20          0.482
LGA    T    14_A      T      21          0.553
LGA    Q    15_A      Q      22          0.856
LGA    C    16_A      C      23          0.300
LGA    Q    17_A      R      24          0.487
LGA    W    18_A      W      25          0.298
LGA    L    19_A      L      26          0.279
LGA    L    20_A      P      27          0.393
LGA    R    21_A      R      28          0.373
LGA    A    22_A      A      29          0.266
LGA    A    23_A      A      30          0.440
LGA    W    24_A      W      31          0.235
LGA    L    25_A      L      32          0.291
LGA    A    26_A      A      33          0.399
LGA    Q    27_A      Q      34          0.329
LGA    E    28_A      E      35          0.153
LGA    L    29_A      L      36          0.437
LGA    L    30_A      L      37          0.447
LGA    S    31_A      T      38          0.428
LGA    T    32_A      T      39          0.807
LGA    F    33_A      F      40          0.788
LGA    A    34_A      E      41          0.781
LGA    D    35_A      T      42          0.482
LGA    D    36_A      E      43          0.489
LGA    L    37_A      L      44          0.535
LGA    G    38_A      T      45          0.896
LGA    K    39_A      E      46          0.587
LGA    V    40_A      L      47          0.489
LGA    C    41_A      A      48          0.313
LGA    L    42_A      L      49          0.350
LGA    E    43_A      K      50          0.329
LGA    P    44_A      P      51          0.320
LGA    G    45_A      G      52          0.536
LGA    T    46_A      T      53          0.914
LGA    G    47_A      G      54          0.669
LGA    G    48_A      G      55          0.567
LGA    V    49_A      V      56          0.489
LGA    F    50_A      F      57          0.460
LGA    R    51_A      V      58          0.777
LGA    I    52_A      V      59          0.735
LGA    T    53_A      R      60          0.395
LGA    C    54_A      V      61          0.230
LGA    D    55_A      D      62          0.294
LGA    G    56_A      D      63          0.702
LGA    V    57_A      E      64          0.694
LGA    Q    58_A      V      65          0.524
LGA    V    59_A      V      66          0.739
LGA    W    60_A      W      67          0.497
LGA    E    61_A      D      68          0.625
LGA    R    62_A      R      69          0.931
LGA    K    63_A      R      70          1.027
LGA    A    64_A      E      71          1.246
LGA    D    65_A      Q      72          0.885
LGA    G    66_A      G      73          2.546
LGA    G    67_A      -       -           -
LGA    F    68_A      F      74          1.171
LGA    P    69_A      P      75          1.241
LGA    E    70_A      E      76          1.039
LGA    A    71_A      P      77          0.747
LGA    K    72_A      T      78          0.867
LGA    A    73_A      A      79          0.886
LGA    L    74_A      V      80          0.977
LGA    K    75_A      K      81          0.766
LGA    Q    76_A      R      82          0.426
LGA    R    77_A      L      83          0.564
LGA    V    78_A      V      84          0.562
LGA    R    79_A      R      85          0.466
LGA    D    80_A      D      86          0.601
LGA    R    81_A      R      87          0.733
LGA    I    82_A      V      88          0.571
LGA    D    83_A      -       -           -
LGA    P    84_A      -       -           -
LGA    Q    85_A      -       -           -
LGA    R    86_A      -       -           -
LGA    D    87_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   77    5.0     77    0.71    55.84     99.391     9.556

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.314174 * X  +  -0.415375 * Y  +   0.853674 * Z  +  19.553942
  Y_new =   0.871176 * X  +   0.231216 * Y  +   0.433119 * Z  +  95.647942
  Z_new =  -0.377290 * X  +   0.879775 * Y  +   0.289222 * Z  +   0.825157 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.253180   -1.888412  [ DEG:    71.8019   -108.1981 ]
  Theta =   0.386868    2.754725  [ DEG:    22.1659    157.8341 ]
  Phi   =   1.916912   -1.224681  [ DEG:   109.8310    -70.1690 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2oka_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2oka_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   77   5.0   77   0.71   55.84  99.391
REMARK  ---------------------------------------------------------- 
MOLECULE 2oka_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   16-JAN-07   2OKA              
TITLE     CRYSTAL STRUCTURE OF Q9HYQ7_PSEAE FROM PSEUDOMONAS                    
TITLE    2 AERUGINOSA. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
TITLE    3 TARGET PAR82                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PA3338;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    PAR82, NESG, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE            
KEYWDS   2 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.BENACH,H.NEELY,J.SEETHARAMAN,X.C.CHEN,Y.FANG,K.CUNNINGHAM,          
AUTHOR   2 L.OWENS,L.C.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,              
AUTHOR   3 G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   23-JAN-07 2OKA    0                                                
JRNL        AUTH   J.BENACH,H.NEELY,J.SEETHARAMAN,X.C.CHEN,Y.FANG,              
JRNL        AUTH 2 K.CUNNINGHAM,L.OWENS,L.C.MA,R.XIAO,J.LIU,M.C.BARAN,          
JRNL        AUTH 3 T.B.ACTON,B.ROST,G.T.MONTELIONE,J.F.HUNT,L.TONG              
JRNL        TITL   CRYSTAL STRUCTURE OF Q9HYQ7_PSEAE FROM PSEUDOMONAS           
JRNL        TITL 2 AERUGINOSA                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2OKA A    1    96  UNP    Q9HYQ7   Q9HYQ7_PSEAE     1     96             
DBREF  2OKA B    1    96  UNP    Q9HYQ7   Q9HYQ7_PSEAE     1     96             
DBREF  2OKA C    1    96  UNP    Q9HYQ7   Q9HYQ7_PSEAE     1     96             
DBREF  2OKA D    1    96  UNP    Q9HYQ7   Q9HYQ7_PSEAE     1     96             
SEQRES   1 A  104  MET PRO THR ALA LYS PRO GLU ILE VAL ILE THR TYR CYS          
SEQRES   2 A  104  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 A  104  GLN GLU LEU LEU SER THR PHE ALA ASP ASP LEU GLY LYS          
SEQRES   4 A  104  VAL CYS LEU GLU PRO GLY THR GLY GLY VAL PHE ARG ILE          
SEQRES   5 A  104  THR CYS ASP GLY VAL GLN VAL TRP GLU ARG LYS ALA ASP          
SEQRES   6 A  104  GLY GLY PHE PRO GLU ALA LYS ALA LEU LYS GLN ARG VAL          
SEQRES   7 A  104  ARG ASP ARG ILE ASP PRO GLN ARG ASP LEU GLY HIS ASN          
SEQRES   8 A  104  ASP ARG PRO SER ARG LEU GLU HIS HIS HIS HIS HIS HIS          
SEQRES   1 B  104  MET PRO THR ALA LYS PRO GLU ILE VAL ILE THR TYR CYS          
SEQRES   2 B  104  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 B  104  GLN GLU LEU LEU SER THR PHE ALA ASP ASP LEU GLY LYS          
SEQRES   4 B  104  VAL CYS LEU GLU PRO GLY THR GLY GLY VAL PHE ARG ILE          
SEQRES   5 B  104  THR CYS ASP GLY VAL GLN VAL TRP GLU ARG LYS ALA ASP          
SEQRES   6 B  104  GLY GLY PHE PRO GLU ALA LYS ALA LEU LYS GLN ARG VAL          
SEQRES   7 B  104  ARG ASP ARG ILE ASP PRO GLN ARG ASP LEU GLY HIS ASN          
SEQRES   8 B  104  ASP ARG PRO SER ARG LEU GLU HIS HIS HIS HIS HIS HIS          
SEQRES   1 C  104  MET PRO THR ALA LYS PRO GLU ILE VAL ILE THR TYR CYS          
SEQRES   2 C  104  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 C  104  GLN GLU LEU LEU SER THR PHE ALA ASP ASP LEU GLY LYS          
SEQRES   4 C  104  VAL CYS LEU GLU PRO GLY THR GLY GLY VAL PHE ARG ILE          
SEQRES   5 C  104  THR CYS ASP GLY VAL GLN VAL TRP GLU ARG LYS ALA ASP          
SEQRES   6 C  104  GLY GLY PHE PRO GLU ALA LYS ALA LEU LYS GLN ARG VAL          
SEQRES   7 C  104  ARG ASP ARG ILE ASP PRO GLN ARG ASP LEU GLY HIS ASN          
SEQRES   8 C  104  ASP ARG PRO SER ARG LEU GLU HIS HIS HIS HIS HIS HIS          
SEQRES   1 D  104  MET PRO THR ALA LYS PRO GLU ILE VAL ILE THR TYR CYS          
SEQRES   2 D  104  THR GLN CYS GLN TRP LEU LEU ARG ALA ALA TRP LEU ALA          
SEQRES   3 D  104  GLN GLU LEU LEU SER THR PHE ALA ASP ASP LEU GLY LYS          
SEQRES   4 D  104  VAL CYS LEU GLU PRO GLY THR GLY GLY VAL PHE ARG ILE          
SEQRES   5 D  104  THR CYS ASP GLY VAL GLN VAL TRP GLU ARG LYS ALA ASP          
SEQRES   6 D  104  GLY GLY PHE PRO GLU ALA LYS ALA LEU LYS GLN ARG VAL          
SEQRES   7 D  104  ARG ASP ARG ILE ASP PRO GLN ARG ASP LEU GLY HIS ASN          
SEQRES   8 D  104  ASP ARG PRO SER ARG LEU GLU HIS HIS HIS HIS HIS HIS          
FORMUL   5  HOH   *104(H2 O)                                                    
CRYST1   54.161   81.421   92.576  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   ALA A   4      34.954 111.796 -24.713  1.00 72.41           N  
ATOM      2  CA  ALA A   4      34.223 112.294 -23.507  1.00 68.53           C  
ATOM      3  C   ALA A   4      34.434 111.411 -22.275  1.00 64.39           C  
ATOM      4  O   ALA A   4      34.794 110.235 -22.391  1.00 71.55           O  
ATOM      5  CB  ALA A   4      32.719 112.399 -23.807  1.00 63.41           C  
ATOM      6  N   LYS A   5      34.209 111.997 -21.100  1.00 66.11           N  
ATOM      7  CA  LYS A   5      34.335 111.279 -19.836  1.00 60.91           C  
ATOM      8  C   LYS A   5      33.014 110.588 -19.497  1.00 52.72           C  
ATOM      9  O   LYS A   5      31.955 110.971 -19.989  1.00 51.14           O  
ATOM     10  CB  LYS A   5      34.736 112.240 -18.712  1.00 64.57           C  
ATOM     11  CG  LYS A   5      36.153 112.781 -18.842  1.00 70.60           C  
ATOM     12  CD  LYS A   5      36.406 113.938 -17.886  1.00 73.23           C  
ATOM     13  CE  LYS A   5      37.873 114.344 -17.877  1.00 73.08           C  
ATOM     14  NZ  LYS A   5      38.138 115.459 -16.921  1.00 72.88           N  
ATOM     15  N   PRO A   6      33.067 109.550 -18.648  1.00 45.32           N  
ATOM     16  CA  PRO A   6      31.874 108.797 -18.245  1.00 46.38           C  
ATOM     17  C   PRO A   6      30.739 109.659 -17.698  1.00 50.65           C  
ATOM     18  O   PRO A   6      30.960 110.575 -16.907  1.00 50.63           O  
ATOM     19  CB  PRO A   6      32.416 107.826 -17.194  1.00 46.79           C  
ATOM     20  CG  PRO A   6      33.815 107.595 -17.644  1.00 45.10           C  
ATOM     21  CD  PRO A   6      34.272 108.989 -18.008  1.00 47.13           C  
ATOM     22  N   GLU A   7      29.524 109.354 -18.133  1.00 52.95           N  
ATOM     23  CA  GLU A   7      28.350 110.079 -17.682  1.00 54.74           C  
ATOM     24  C   GLU A   7      27.515 109.205 -16.743  1.00 52.04           C  
ATOM     25  O   GLU A   7      27.200 108.055 -17.063  1.00 52.11           O  
ATOM     26  CB  GLU A   7      27.505 110.507 -18.881  1.00 60.82           C  
ATOM     27  CG  GLU A   7      26.168 111.112 -18.496  1.00 63.24           C  
ATOM     28  CD  GLU A   7      25.328 111.481 -19.700  1.00 64.88           C  
ATOM     29  OE1 GLU A   7      25.772 112.345 -20.486  1.00 65.00           O  
ATOM     30  OE2 GLU A   7      24.225 110.907 -19.863  1.00 64.52           O  
ATOM     31  N   ILE A   8      27.177 109.761 -15.581  1.00 48.52           N  
ATOM     32  CA  ILE A   8      26.369 109.069 -14.575  1.00 39.67           C  
ATOM     33  C   ILE A   8      24.941 109.622 -14.610  1.00 40.49           C  
ATOM     34  O   ILE A   8      24.742 110.832 -14.650  1.00 44.46           O  
ATOM     35  CB  ILE A   8      26.933 109.292 -13.152  1.00 37.97           C  
ATOM     36  CG1 ILE A   8      28.323 108.673 -13.025  1.00 35.08           C  
ATOM     37  CG2 ILE A   8      26.002 108.669 -12.111  1.00 35.12           C  
ATOM     38  CD1 ILE A   8      28.336 107.143 -12.935  1.00 33.55           C  
ATOM     39  N   VAL A   9      23.948 108.741 -14.609  1.00 41.38           N  
ATOM     40  CA  VAL A   9      22.561 109.187 -14.608  1.00 35.40           C  
ATOM     41  C   VAL A   9      21.828 108.566 -13.430  1.00 37.76           C  
ATOM     42  O   VAL A   9      21.828 107.350 -13.249  1.00 38.29           O  
ATOM     43  CB  VAL A   9      21.825 108.789 -15.894  1.00 35.04           C  
ATOM     44  CG1 VAL A   9      20.358 109.181 -15.782  1.00 32.25           C  
ATOM     45  CG2 VAL A   9      22.471 109.477 -17.095  1.00 31.80           C  
ATOM     46  N   ILE A  10      21.215 109.415 -12.613  1.00 37.25           N  
ATOM     47  CA  ILE A  10      20.465 108.950 -11.457  1.00 35.39           C  
ATOM     48  C   ILE A  10      18.999 109.270 -11.717  1.00 37.39           C  
ATOM     49  O   ILE A  10      18.607 110.431 -11.740  1.00 38.54           O  
ATOM     50  CB  ILE A  10      20.938 109.653 -10.154  1.00 35.35           C  
ATOM     51  CG1 ILE A  10      22.377 109.254  -9.843  1.00 32.10           C  
ATOM     52  CG2 ILE A  10      20.066 109.242  -8.977  1.00 32.99           C  
ATOM     53  CD1 ILE A  10      22.994 110.044  -8.726  1.00 31.24           C  
ATOM     54  N   THR A  11      18.207 108.226 -11.951  1.00 38.76           N  
ATOM     55  CA  THR A  11      16.782 108.366 -12.218  1.00 37.82           C  
ATOM     56  C   THR A  11      16.073 108.090 -10.900  1.00 36.95           C  
ATOM     57  O   THR A  11      16.200 106.999 -10.339  1.00 39.58           O  
ATOM     58  CB  THR A  11      16.312 107.347 -13.280  1.00 40.67           C  
ATOM     59  OG1 THR A  11      17.122 107.465 -14.459  1.00 39.56           O  
ATOM     60  CG2 THR A  11      14.863 107.610 -13.653  1.00 39.73           C  
ATOM     61  N   TYR A  12      15.324 109.072 -10.411  1.00 36.84           N  
ATOM     62  CA  TYR A  12      14.647 108.931  -9.130  1.00 34.47           C  
ATOM     63  C   TYR A  12      13.165 109.275  -9.205  1.00 35.59           C  
ATOM     64  O   TYR A  12      12.755 110.116  -9.994  1.00 33.60           O  
ATOM     65  CB  TYR A  12      15.304 109.852  -8.104  1.00 31.67           C  
ATOM     66  CG  TYR A  12      15.087 111.309  -8.424  1.00 31.75           C  
ATOM     67  CD1 TYR A  12      15.878 111.965  -9.371  1.00 31.08           C  
ATOM     68  CD2 TYR A  12      14.045 112.025  -7.834  1.00 31.01           C  
ATOM     69  CE1 TYR A  12      15.634 113.294  -9.721  1.00 28.86           C  
ATOM     70  CE2 TYR A  12      13.791 113.353  -8.180  1.00 30.17           C  
ATOM     71  CZ  TYR A  12      14.587 113.975  -9.122  1.00 30.71           C  
ATOM     72  OH  TYR A  12      14.341 115.285  -9.464  1.00 33.00           O  
ATOM     73  N   CYS A  13      12.369 108.628  -8.361  1.00 37.64           N  
ATOM     74  CA  CYS A  13      10.930 108.884  -8.305  1.00 40.99           C  
ATOM     75  C   CYS A  13      10.679 110.237  -7.617  1.00 37.64           C  
ATOM     76  O   CYS A  13      11.012 110.411  -6.449  1.00 37.86           O  
ATOM     77  CB  CYS A  13      10.235 107.740  -7.553  1.00 45.42           C  
ATOM     78  SG  CYS A  13       8.557 108.127  -6.963  1.00 50.76           S  
ATOM     79  N   THR A  14      10.103 111.192  -8.343  1.00 38.51           N  
ATOM     80  CA  THR A  14       9.856 112.519  -7.777  1.00 42.49           C  
ATOM     81  C   THR A  14       8.761 112.563  -6.716  1.00 38.44           C  
ATOM     82  O   THR A  14       8.924 113.216  -5.680  1.00 35.09           O  
ATOM     83  CB  THR A  14       9.534 113.568  -8.882  1.00 43.11           C  
ATOM     84  OG1 THR A  14       8.474 113.092  -9.710  1.00 47.76           O  
ATOM     85  CG2 THR A  14      10.745 113.813  -9.753  1.00 48.26           C  
ATOM     86  N   GLN A  15       7.656 111.875  -6.959  1.00 42.56           N  
ATOM     87  CA  GLN A  15       6.565 111.871  -5.998  1.00 53.30           C  
ATOM     88  C   GLN A  15       7.001 111.223  -4.692  1.00 47.78           C  
ATOM     89  O   GLN A  15       6.491 111.565  -3.627  1.00 42.52           O  
ATOM     90  CB  GLN A  15       5.359 111.137  -6.581  1.00 68.64           C  
ATOM     91  CG  GLN A  15       4.788 111.807  -7.819  1.00 81.77           C  
ATOM     92  CD  GLN A  15       4.175 113.166  -7.523  1.00 86.79           C  
ATOM     93  OE1 GLN A  15       4.824 114.051  -6.962  1.00 86.66           O  
ATOM     94  NE2 GLN A  15       2.913 113.337  -7.904  1.00 86.52           N  
ATOM     95  N   CYS A  16       7.956 110.300  -4.775  1.00 42.76           N  
ATOM     96  CA  CYS A  16       8.467 109.600  -3.597  1.00 43.69           C  
ATOM     97  C   CYS A  16       9.384 110.468  -2.737  1.00 41.75           C  
ATOM     98  O   CYS A  16       9.839 110.029  -1.676  1.00 42.78           O  
ATOM     99  CB  CYS A  16       9.265 108.372  -4.011  1.00 48.66           C  
ATOM    100  SG  CYS A  16       8.479 107.200  -5.155  1.00 51.14           S  
ATOM    101  N   GLN A  17       9.674 111.684  -3.194  1.00 43.65           N  
ATOM    102  CA  GLN A  17      10.559 112.578  -2.455  1.00 43.14           C  
ATOM    103  C   GLN A  17      11.978 112.031  -2.402  1.00 42.26           C  
ATOM    104  O   GLN A  17      12.656 112.140  -1.380  1.00 38.83           O  
ATOM    105  CB  GLN A  17      10.040 112.782  -1.032  1.00 43.23           C  
ATOM    106  CG  GLN A  17       8.824 113.663  -0.947  1.00 46.73           C  
ATOM    107  CD  GLN A  17       9.042 114.987  -1.655  1.00 49.26           C  
ATOM    108  OE1 GLN A  17       8.852 115.097  -2.869  1.00 48.19           O  
ATOM    109  NE2 GLN A  17       9.468 115.998  -0.900  1.00 48.86           N  
ATOM    110  N   TRP A  18      12.438 111.446  -3.503  1.00 39.60           N  
ATOM    111  CA  TRP A  18      13.788 110.891  -3.522  1.00 40.46           C  
ATOM    112  C   TRP A  18      14.843 111.810  -4.144  1.00 36.51           C  
ATOM    113  O   TRP A  18      15.983 111.396  -4.364  1.00 42.41           O  
ATOM    114  CB  TRP A  18      13.777 109.522  -4.210  1.00 46.16           C  
ATOM    115  CG  TRP A  18      12.998 108.483  -3.435  1.00 44.62           C  
ATOM    116  CD1 TRP A  18      12.596 108.566  -2.130  1.00 44.98           C  
ATOM    117  CD2 TRP A  18      12.568 107.197  -3.903  1.00 44.75           C  
ATOM    118  NE1 TRP A  18      11.954 107.411  -1.757  1.00 44.14           N  
ATOM    119  CE2 TRP A  18      11.930 106.550  -2.821  1.00 44.24           C  
ATOM    120  CE3 TRP A  18      12.681 106.516  -5.125  1.00 44.95           C  
ATOM    121  CZ2 TRP A  18      11.380 105.265  -2.930  1.00 44.48           C  
ATOM    122  CZ3 TRP A  18      12.133 105.230  -5.231  1.00 44.81           C  
ATOM    123  CH2 TRP A  18      11.501 104.620  -4.134  1.00 43.61           C  
ATOM    124  N   LEU A  19      14.462 113.056  -4.408  1.00 38.72           N  
ATOM    125  CA  LEU A  19      15.382 114.041  -4.970  1.00 32.69           C  
ATOM    126  C   LEU A  19      16.559 114.225  -4.024  1.00 30.42           C  
ATOM    127  O   LEU A  19      17.714 114.244  -4.450  1.00 28.20           O  
ATOM    128  CB  LEU A  19      14.693 115.405  -5.155  1.00 26.05           C  
ATOM    129  CG  LEU A  19      15.631 116.576  -5.468  1.00 26.67           C  
ATOM    130  CD1 LEU A  19      16.326 116.367  -6.811  1.00 27.44           C  
ATOM    131  CD2 LEU A  19      14.842 117.852  -5.502  1.00 28.36           C  
ATOM    132  N   LEU A  20      16.239 114.371  -2.738  1.00 29.32           N  
ATOM    133  CA  LEU A  20      17.228 114.571  -1.690  1.00 31.14           C  
ATOM    134  C   LEU A  20      18.332 113.532  -1.709  1.00 31.49           C  
ATOM    135  O   LEU A  20      19.507 113.874  -1.823  1.00 32.96           O  
ATOM    136  CB  LEU A  20      16.548 114.552  -0.326  1.00 33.66           C  
ATOM    137  CG  LEU A  20      16.539 115.832   0.502  1.00 33.63           C  
ATOM    138  CD1 LEU A  20      16.301 117.035  -0.399  1.00 35.32           C  
ATOM    139  CD2 LEU A  20      15.450 115.714   1.573  1.00 34.79           C  
ATOM    140  N   ARG A  21      17.964 112.260  -1.592  1.00 33.82           N  
ATOM    141  CA  ARG A  21      18.969 111.205  -1.591  1.00 35.38           C  
ATOM    142  C   ARG A  21      19.675 111.105  -2.949  1.00 31.27           C  
ATOM    143  O   ARG A  21      20.839 110.725  -3.016  1.00 31.35           O  
ATOM    144  CB  ARG A  21      18.338 109.860  -1.222  1.00 39.86           C  
ATOM    145  CG  ARG A  21      17.333 109.320  -2.236  1.00 44.64           C  
ATOM    146  CD  ARG A  21      16.502 108.191  -1.632  1.00 44.63           C  
ATOM    147  NE  ARG A  21      15.712 108.671  -0.502  1.00 44.67           N  
ATOM    148  CZ  ARG A  21      14.899 107.915   0.235  1.00 45.48           C  
ATOM    149  NH1 ARG A  21      14.763 106.625  -0.031  1.00 45.15           N  
ATOM    150  NH2 ARG A  21      14.215 108.457   1.239  1.00 44.70           N  
ATOM    151  N   ALA A  22      18.982 111.451  -4.031  1.00 27.49           N  
ATOM    152  CA  ALA A  22      19.603 111.389  -5.351  1.00 26.86           C  
ATOM    153  C   ALA A  22      20.696 112.452  -5.477  1.00 28.84           C  
ATOM    154  O   ALA A  22      21.783 112.184  -5.998  1.00 26.33           O  
ATOM    155  CB  ALA A  22      18.557 111.582  -6.439  1.00 22.16           C  
ATOM    156  N   ALA A  23      20.406 113.657  -4.988  1.00 30.22           N  
ATOM    157  CA  ALA A  23      21.369 114.755  -5.042  1.00 30.58           C  
ATOM    158  C   ALA A  23      22.507 114.480  -4.073  1.00 32.61           C  
ATOM    159  O   ALA A  23      23.648 114.875  -4.309  1.00 31.16           O  
ATOM    160  CB  ALA A  23      20.687 116.080  -4.704  1.00 26.47           C  
ATOM    161  N   TRP A  24      22.201 113.799  -2.979  1.00 32.32           N  
ATOM    162  CA  TRP A  24      23.239 113.462  -2.012  1.00 34.93           C  
ATOM    163  C   TRP A  24      24.256 112.514  -2.668  1.00 36.99           C  
ATOM    164  O   TRP A  24      25.464 112.756  -2.632  1.00 37.08           O  
ATOM    165  CB  TRP A  24      22.633 112.806  -0.763  1.00 32.72           C  
ATOM    166  CG  TRP A  24      23.664 112.044   0.030  1.00 29.76           C  
ATOM    167  CD1 TRP A  24      24.825 112.535   0.552  1.00 27.70           C  
ATOM    168  CD2 TRP A  24      23.652 110.642   0.324  1.00 27.84           C  
ATOM    169  NE1 TRP A  24      25.535 111.528   1.157  1.00 30.02           N  
ATOM    170  CE2 TRP A  24      24.834 110.354   1.037  1.00 29.34           C  
ATOM    171  CE3 TRP A  24      22.746 109.601   0.069  1.00 28.79           C  
ATOM    172  CZ2 TRP A  24      25.151 109.066   1.476  1.00 28.19           C  
ATOM    173  CZ3 TRP A  24      23.060 108.315   0.509  1.00 28.86           C  
ATOM    174  CH2 TRP A  24      24.248 108.065   1.209  1.00 29.20           C  
ATOM    175  N   LEU A  25      23.761 111.439  -3.271  1.00 36.45           N  
ATOM    176  CA  LEU A  25      24.635 110.484  -3.945  1.00 38.07           C  
ATOM    177  C   LEU A  25      25.401 111.127  -5.111  1.00 38.49           C  
ATOM    178  O   LEU A  25      26.558 110.791  -5.364  1.00 38.45           O  
ATOM    179  CB  LEU A  25      23.827 109.292  -4.461  1.00 39.19           C  
ATOM    180  CG  LEU A  25      23.301 108.323  -3.401  1.00 39.29           C  
ATOM    181  CD1 LEU A  25      22.366 107.302  -4.056  1.00 39.58           C  
ATOM    182  CD2 LEU A  25      24.478 107.647  -2.718  1.00 39.47           C  
ATOM    183  N   ALA A  26      24.756 112.042  -5.829  1.00 36.40           N  
ATOM    184  CA  ALA A  26      25.422 112.711  -6.938  1.00 33.61           C  
ATOM    185  C   ALA A  26      26.623 113.487  -6.401  1.00 33.18           C  
ATOM    186  O   ALA A  26      27.711 113.450  -6.989  1.00 38.09           O  
ATOM    187  CB  ALA A  26      24.457 113.653  -7.646  1.00 31.75           C  
ATOM    188  N   GLN A  27      26.436 114.183  -5.279  1.00 35.31           N  
ATOM    189  CA  GLN A  27      27.527 114.949  -4.694  1.00 31.08           C  
ATOM    190  C   GLN A  27      28.611 114.030  -4.145  1.00 30.34           C  
ATOM    191  O   GLN A  27      29.797 114.350  -4.225  1.00 29.76           O  
ATOM    192  CB  GLN A  27      27.009 115.882  -3.596  1.00 27.12           C  
ATOM    193  CG  GLN A  27      26.079 116.970  -4.106  1.00 24.92           C  
ATOM    194  CD  GLN A  27      25.529 117.806  -2.981  1.00 26.95           C  
ATOM    195  OE1 GLN A  27      26.178 118.747  -2.512  1.00 25.85           O  
ATOM    196  NE2 GLN A  27      24.328 117.450  -2.511  1.00 26.63           N  
ATOM    197  N   GLU A  28      28.212 112.896  -3.575  1.00 30.97           N  
ATOM    198  CA  GLU A  28      29.186 111.949  -3.045  1.00 33.36           C  
ATOM    199  C   GLU A  28      30.096 111.536  -4.196  1.00 36.62           C  
ATOM    200  O   GLU A  28      31.317 111.473  -4.043  1.00 36.06           O  
ATOM    201  CB  GLU A  28      28.492 110.702  -2.487  1.00 33.01           C  
ATOM    202  CG  GLU A  28      27.763 110.897  -1.161  1.00 32.23           C  
ATOM    203  CD  GLU A  28      28.707 111.011   0.021  1.00 31.83           C  
ATOM    204  OE1 GLU A  28      29.941 110.975  -0.193  1.00 31.60           O  
ATOM    205  OE2 GLU A  28      28.215 111.135   1.167  1.00 30.55           O  
ATOM    206  N   LEU A  29      29.494 111.264  -5.351  1.00 34.30           N  
ATOM    207  CA  LEU A  29      30.248 110.852  -6.531  1.00 36.03           C  
ATOM    208  C   LEU A  29      31.112 111.964  -7.126  1.00 40.03           C  
ATOM    209  O   LEU A  29      32.284 111.741  -7.432  1.00 39.23           O  
ATOM    210  CB  LEU A  29      29.298 110.330  -7.621  1.00 34.11           C  
ATOM    211  CG  LEU A  29      28.548 109.011  -7.402  1.00 30.51           C  
ATOM    212  CD1 LEU A  29      27.735 108.673  -8.658  1.00 28.98           C  
ATOM    213  CD2 LEU A  29      29.538 107.908  -7.090  1.00 29.50           C  
ATOM    214  N   LEU A  30      30.534 113.157  -7.297  1.00 40.11           N  
ATOM    215  CA  LEU A  30      31.270 114.277  -7.883  1.00 38.95           C  
ATOM    216  C   LEU A  30      32.423 114.769  -7.029  1.00 44.01           C  
ATOM    217  O   LEU A  30      33.359 115.378  -7.544  1.00 46.23           O  
ATOM    218  CB  LEU A  30      30.330 115.439  -8.187  1.00 35.98           C  
ATOM    219  CG  LEU A  30      29.386 115.199  -9.365  1.00 31.25           C  
ATOM    220  CD1 LEU A  30      28.256 116.216  -9.341  1.00 28.95           C  
ATOM    221  CD2 LEU A  30      30.175 115.265 -10.667  1.00 28.75           C  
ATOM    222  N   SER A  31      32.380 114.503  -5.730  1.00 45.75           N  
ATOM    223  CA  SER A  31      33.462 114.958  -4.875  1.00 49.76           C  
ATOM    224  C   SER A  31      34.607 113.957  -4.796  1.00 54.53           C  
ATOM    225  O   SER A  31      35.736 114.337  -4.485  1.00 49.73           O  
ATOM    226  CB  SER A  31      32.947 115.291  -3.472  1.00 50.31           C  
ATOM    227  OG  SER A  31      32.304 114.180  -2.880  1.00 52.47           O  
ATOM    228  N   THR A  32      34.345 112.681  -5.077  1.00 51.12           N  
ATOM    229  CA  THR A  32      35.439 111.708  -5.038  1.00 54.82           C  
ATOM    230  C   THR A  32      35.990 111.395  -6.443  1.00 51.87           C  
ATOM    231  O   THR A  32      37.110 110.908  -6.570  1.00 58.29           O  
ATOM    232  CB  THR A  32      35.037 110.363  -4.350  1.00 64.04           C  
ATOM    233  OG1 THR A  32      34.520 109.455  -5.331  1.00 63.31           O  
ATOM    234  CG2 THR A  32      33.994 110.594  -3.265  1.00 62.92           C  
ATOM    235  N   PHE A  33      35.208 111.677  -7.485  1.00 53.32           N  
ATOM    236  CA  PHE A  33      35.627 111.431  -8.870  1.00 44.17           C  
ATOM    237  C   PHE A  33      35.556 112.724  -9.703  1.00 41.13           C  
ATOM    238  O   PHE A  33      35.274 112.679 -10.905  1.00 40.19           O  
ATOM    239  CB  PHE A  33      34.723 110.374  -9.539  1.00 43.22           C  
ATOM    240  CG  PHE A  33      34.730 109.023  -8.867  1.00 43.12           C  
ATOM    241  CD1 PHE A  33      35.875 108.226  -8.868  1.00 43.94           C  
ATOM    242  CD2 PHE A  33      33.585 108.549  -8.227  1.00 44.32           C  
ATOM    243  CE1 PHE A  33      35.869 106.961  -8.254  1.00 44.48           C  
ATOM    244  CE2 PHE A  33      33.568 107.288  -7.609  1.00 44.27           C  
ATOM    245  CZ  PHE A  33      34.714 106.495  -7.617  1.00 44.01           C  
ATOM    246  N   ALA A  34      35.808 113.868  -9.075  1.00 38.57           N  
ATOM    247  CA  ALA A  34      35.744 115.155  -9.778  1.00 38.26           C  
ATOM    248  C   ALA A  34      36.484 115.177 -11.111  1.00 43.30           C  
ATOM    249  O   ALA A  34      35.992 115.740 -12.089  1.00 43.22           O  
ATOM    250  CB  ALA A  34      36.284 116.273  -8.885  1.00 28.81           C  
ATOM    251  N   ASP A  35      37.666 114.568 -11.146  1.00 47.59           N  
ATOM    252  CA  ASP A  35      38.483 114.552 -12.356  1.00 49.65           C  
ATOM    253  C   ASP A  35      38.152 113.481 -13.388  1.00 47.52           C  
ATOM    254  O   ASP A  35      38.400 113.666 -14.579  1.00 49.79           O  
ATOM    255  CB  ASP A  35      39.960 114.422 -11.976  1.00 52.81           C  
ATOM    256  CG  ASP A  35      40.453 115.595 -11.161  1.00 54.08           C  
ATOM    257  OD1 ASP A  35      39.818 116.670 -11.220  1.00 54.65           O  
ATOM    258  OD2 ASP A  35      41.486 115.453 -10.477  1.00 54.74           O  
ATOM    259  N   ASP A  36      37.584 112.369 -12.937  1.00 48.09           N  
ATOM    260  CA  ASP A  36      37.272 111.260 -13.831  1.00 44.94           C  
ATOM    261  C   ASP A  36      35.857 111.201 -14.396  1.00 42.09           C  
ATOM    262  O   ASP A  36      35.570 110.346 -15.239  1.00 42.74           O  
ATOM    263  CB  ASP A  36      37.581 109.944 -13.112  1.00 47.06           C  
ATOM    264  CG  ASP A  36      38.961 109.938 -12.471  1.00 50.18           C  
ATOM    265  OD1 ASP A  36      39.966 110.018 -13.205  1.00 51.63           O  
ATOM    266  OD2 ASP A  36      39.043 109.860 -11.229  1.00 51.62           O  
ATOM    267  N   LEU A  37      34.974 112.091 -13.946  1.00 39.18           N  
ATOM    268  CA  LEU A  37      33.591 112.083 -14.406  1.00 41.54           C  
ATOM    269  C   LEU A  37      33.235 113.238 -15.336  1.00 42.16           C  
ATOM    270  O   LEU A  37      33.584 114.390 -15.074  1.00 39.93           O  
ATOM    271  CB  LEU A  37      32.649 112.073 -13.192  1.00 43.77           C  
ATOM    272  CG  LEU A  37      31.936 110.762 -12.830  1.00 47.30           C  
ATOM    273  CD1 LEU A  37      32.832 109.576 -13.096  1.00 49.17           C  
ATOM    274  CD2 LEU A  37      31.516 110.796 -11.376  1.00 48.38           C  
ATOM    275  N   GLY A  38      32.545 112.915 -16.428  1.00 40.91           N  
ATOM    276  CA  GLY A  38      32.130 113.927 -17.383  1.00 42.46           C  
ATOM    277  C   GLY A  38      31.055 114.766 -16.737  1.00 43.42           C  
ATOM    278  O   GLY A  38      31.163 115.992 -16.653  1.00 44.79           O  
ATOM    279  N   LYS A  39      30.006 114.094 -16.280  1.00 44.28           N  
ATOM    280  CA  LYS A  39      28.918 114.764 -15.600  1.00 43.97           C  
ATOM    281  C   LYS A  39      27.923 113.803 -14.977  1.00 45.00           C  
ATOM    282  O   LYS A  39      27.697 112.700 -15.472  1.00 43.53           O  
ATOM    283  CB  LYS A  39      28.203 115.732 -16.542  1.00 40.38           C  
ATOM    284  CG  LYS A  39      27.654 115.164 -17.822  1.00 40.39           C  
ATOM    285  CD  LYS A  39      27.271 116.339 -18.723  1.00 40.19           C  
ATOM    286  CE  LYS A  39      26.499 115.917 -19.958  1.00 40.63           C  
ATOM    287  NZ  LYS A  39      26.072 117.091 -20.780  1.00 40.79           N  
ATOM    288  N   VAL A  40      27.349 114.222 -13.857  1.00 38.79           N  
ATOM    289  CA  VAL A  40      26.361 113.417 -13.166  1.00 36.54           C  
ATOM    290  C   VAL A  40      25.003 114.087 -13.340  1.00 38.08           C  
ATOM    291  O   VAL A  40      24.833 115.261 -13.016  1.00 40.61           O  
ATOM    292  CB  VAL A  40      26.690 113.302 -11.681  1.00 36.79           C  
ATOM    293  CG1 VAL A  40      25.573 112.569 -10.976  1.00 34.98           C  
ATOM    294  CG2 VAL A  40      28.010 112.571 -11.506  1.00 33.72           C  
ATOM    295  N   CYS A  41      24.042 113.340 -13.865  1.00 39.63           N  
ATOM    296  CA  CYS A  41      22.719 113.885 -14.096  1.00 38.99           C  
ATOM    297  C   CYS A  41      21.646 113.313 -13.181  1.00 41.70           C  
ATOM    298  O   CYS A  41      21.646 112.129 -12.841  1.00 38.72           O  
ATOM    299  CB  CYS A  41      22.299 113.646 -15.543  1.00 38.14           C  
ATOM    300  SG  CYS A  41      23.434 114.253 -16.834  1.00 36.66           S  
ATOM    301  N   LEU A  42      20.735 114.186 -12.777  1.00 39.82           N  
ATOM    302  CA  LEU A  42      19.609 113.801 -11.941  1.00 41.03           C  
ATOM    303  C   LEU A  42      18.421 113.831 -12.906  1.00 44.06           C  
ATOM    304  O   LEU A  42      18.140 114.853 -13.550  1.00 45.58           O  
ATOM    305  CB  LEU A  42      19.426 114.800 -10.793  1.00 41.18           C  
ATOM    306  CG  LEU A  42      20.579 114.779  -9.787  1.00 37.29           C  
ATOM    307  CD1 LEU A  42      20.495 115.961  -8.841  1.00 35.20           C  
ATOM    308  CD2 LEU A  42      20.549 113.485  -9.017  1.00 35.11           C  
ATOM    309  N   GLU A  43      17.752 112.692 -13.021  1.00 47.38           N  
ATOM    310  CA  GLU A  43      16.627 112.564 -13.940  1.00 47.60           C  
ATOM    311  C   GLU A  43      15.327 112.195 -13.246  1.00 45.45           C  
ATOM    312  O   GLU A  43      15.163 111.088 -12.743  1.00 43.50           O  
ATOM    313  CB  GLU A  43      16.962 111.532 -15.004  1.00 50.91           C  
ATOM    314  CG  GLU A  43      15.801 111.137 -15.900  1.00 54.67           C  
ATOM    315  CD  GLU A  43      16.185 110.057 -16.888  1.00 55.25           C  
ATOM    316  OE1 GLU A  43      16.560 108.946 -16.452  1.00 54.38           O  
ATOM    317  OE2 GLU A  43      16.109 110.327 -18.105  1.00 56.39           O  
ATOM    318  N   PRO A  44      14.386 113.132 -13.197  1.00 44.27           N  
ATOM    319  CA  PRO A  44      13.086 112.860 -12.574  1.00 47.28           C  
ATOM    320  C   PRO A  44      12.393 111.663 -13.182  1.00 49.50           C  
ATOM    321  O   PRO A  44      12.237 111.596 -14.408  1.00 47.20           O  
ATOM    322  CB  PRO A  44      12.289 114.131 -12.833  1.00 49.21           C  
ATOM    323  CG  PRO A  44      13.137 114.948 -13.795  1.00 50.54           C  
ATOM    324  CD  PRO A  44      14.536 114.555 -13.493  1.00 48.56           C  
ATOM    325  N   GLY A  45      11.975 110.718 -12.346  1.00 48.97           N  
ATOM    326  CA  GLY A  45      11.274 109.539 -12.831  1.00 52.44           C  
ATOM    327  C   GLY A  45       9.985 109.343 -12.048  1.00 55.81           C  
ATOM    328  O   GLY A  45       9.582 110.182 -11.232  1.00 54.00           O  
ATOM    329  N   THR A  46       9.334 108.223 -12.255  1.00 58.35           N  
ATOM    330  CA  THR A  46       8.077 107.920 -11.600  1.00 60.61           C  
ATOM    331  C   THR A  46       8.054 106.580 -10.963  1.00 53.61           C  
ATOM    332  O   THR A  46       8.967 105.797 -11.063  1.00 57.18           O  
ATOM    333  CB  THR A  46       6.926 107.859 -12.661  1.00 67.87           C  
ATOM    334  OG1 THR A  46       7.350 107.035 -13.790  1.00 71.28           O  
ATOM    335  CG2 THR A  46       6.588 109.198 -13.220  1.00 71.48           C  
ATOM    336  N   GLY A  47       7.010 106.314 -10.219  1.00 53.34           N  
ATOM    337  CA  GLY A  47       6.827 105.019  -9.645  1.00 45.67           C  
ATOM    338  C   GLY A  47       7.864 104.113  -9.091  1.00 41.16           C  
ATOM    339  O   GLY A  47       8.240 103.112  -9.690  1.00 41.43           O  
ATOM    340  N   GLY A  48       8.329 104.548  -7.950  1.00 40.29           N  
ATOM    341  CA  GLY A  48       9.323 103.809  -7.224  1.00 40.50           C  
ATOM    342  C   GLY A  48      10.647 103.563  -7.876  1.00 41.48           C  
ATOM    343  O   GLY A  48      11.465 102.794  -7.379  1.00 41.50           O  
ATOM    344  N   VAL A  49      10.869 104.261  -8.954  1.00 42.40           N  
ATOM    345  CA  VAL A  49      12.120 104.124  -9.654  1.00 46.95           C  
ATOM    346  C   VAL A  49      13.333 104.745  -8.992  1.00 44.72           C  
ATOM    347  O   VAL A  49      13.272 105.893  -8.533  1.00 42.64           O  
ATOM    348  CB  VAL A  49      12.008 104.703 -11.100  1.00 49.23           C  
ATOM    349  CG1 VAL A  49      13.260 104.650 -11.746  1.00 53.52           C  
ATOM    350  CG2 VAL A  49      11.075 103.900 -11.938  1.00 52.56           C  
ATOM    351  N   PHE A  50      14.408 103.972  -8.868  1.00 42.33           N  
ATOM    352  CA  PHE A  50      15.661 104.510  -8.372  1.00 43.84           C  
ATOM    353  C   PHE A  50      16.776 103.713  -9.043  1.00 46.32           C  
ATOM    354  O   PHE A  50      17.231 102.677  -8.546  1.00 45.63           O  
ATOM    355  CB  PHE A  50      15.814 104.447  -6.856  1.00 43.88           C  
ATOM    356  CG  PHE A  50      16.876 105.383  -6.368  1.00 42.58           C  
ATOM    357  CD1 PHE A  50      16.609 106.739  -6.197  1.00 41.76           C  
ATOM    358  CD2 PHE A  50      18.150 104.910  -6.075  1.00 41.50           C  
ATOM    359  CE1 PHE A  50      17.599 107.604  -5.740  1.00 41.04           C  
ATOM    360  CE2 PHE A  50      19.138 105.768  -5.620  1.00 41.91           C  
ATOM    361  CZ  PHE A  50      18.859 107.118  -5.446  1.00 41.25           C  
ATOM    362  N   ARG A  51      17.246 104.228 -10.184  1.00 46.80           N  
ATOM    363  CA  ARG A  51      18.260 103.558 -10.993  1.00 47.31           C  
ATOM    364  C   ARG A  51      19.459 104.457 -11.269  1.00 47.12           C  
ATOM    365  O   ARG A  51      19.299 105.655 -11.473  1.00 48.65           O  
ATOM    366  CB  ARG A  51      17.596 103.127 -12.302  1.00 50.98           C  
ATOM    367  CG  ARG A  51      18.342 102.063 -13.080  1.00 51.42           C  
ATOM    368  CD  ARG A  51      17.459 101.370 -14.110  1.00 50.44           C  
ATOM    369  NE  ARG A  51      18.230 100.897 -15.251  1.00 50.39           N  
ATOM    370  CZ  ARG A  51      18.336 101.561 -16.392  1.00 51.13           C  
ATOM    371  NH1 ARG A  51      17.727 102.731 -16.542  1.00 51.01           N  
ATOM    372  NH2 ARG A  51      19.048 101.066 -17.391  1.00 51.65           N  
ATOM    373  N   ILE A  52      20.648 103.871 -11.290  1.00 45.55           N  
ATOM    374  CA  ILE A  52      21.846 104.639 -11.564  1.00 38.23           C  
ATOM    375  C   ILE A  52      22.634 103.955 -12.671  1.00 42.49           C  
ATOM    376  O   ILE A  52      22.927 102.766 -12.582  1.00 45.07           O  
ATOM    377  CB  ILE A  52      22.737 104.755 -10.308  1.00 36.36           C  
ATOM    378  CG1 ILE A  52      21.965 105.436  -9.176  1.00 30.95           C  
ATOM    379  CG2 ILE A  52      23.995 105.561 -10.650  1.00 31.80           C  
ATOM    380  CD1 ILE A  52      22.761 105.605  -7.879  1.00 30.25           C  
ATOM    381  N   THR A  53      22.969 104.705 -13.718  1.00 43.44           N  
ATOM    382  CA  THR A  53      23.732 104.158 -14.835  1.00 42.04           C  
ATOM    383  C   THR A  53      25.055 104.904 -15.063  1.00 46.48           C  
ATOM    384  O   THR A  53      25.189 106.097 -14.764  1.00 44.83           O  
ATOM    385  CB  THR A  53      22.925 104.211 -16.153  1.00 40.01           C  
ATOM    386  OG1 THR A  53      22.484 105.550 -16.390  1.00 37.97           O  
ATOM    387  CG2 THR A  53      21.717 103.293 -16.092  1.00 38.49           C  
ATOM    388  N   CYS A  54      26.035 104.178 -15.587  1.00 46.75           N  
ATOM    389  CA  CYS A  54      27.341 104.737 -15.882  1.00 48.42           C  
ATOM    390  C   CYS A  54      27.560 104.454 -17.370  1.00 50.22           C  
ATOM    391  O   CYS A  54      27.716 103.296 -17.775  1.00 51.17           O  
ATOM    392  CB  CYS A  54      28.397 104.043 -15.028  1.00 49.23           C  
ATOM    393  SG  CYS A  54      29.943 104.805 -15.166  1.00 50.17           S  
ATOM    394  N   ASP A  55      27.565 105.506 -18.184  1.00 50.49           N  
ATOM    395  CA  ASP A  55      27.714 105.349 -19.625  1.00 50.81           C  
ATOM    396  C   ASP A  55      26.704 104.328 -20.150  1.00 52.29           C  
ATOM    397  O   ASP A  55      27.036 103.485 -20.984  1.00 51.38           O  
ATOM    398  CB  ASP A  55      29.137 104.909 -19.999  1.00 50.79           C  
ATOM    399  CG  ASP A  55      30.118 106.071 -20.045  1.00 51.56           C  
ATOM    400  OD1 ASP A  55      29.695 107.210 -20.348  1.00 51.09           O  
ATOM    401  OD2 ASP A  55      31.319 105.840 -19.792  1.00 52.19           O  
ATOM    402  N   GLY A  56      25.472 104.405 -19.647  1.00 50.21           N  
ATOM    403  CA  GLY A  56      24.419 103.502 -20.079  1.00 51.39           C  
ATOM    404  C   GLY A  56      24.305 102.185 -19.328  1.00 54.15           C  
ATOM    405  O   GLY A  56      23.248 101.547 -19.345  1.00 53.07           O  
ATOM    406  N   VAL A  57      25.386 101.773 -18.671  1.00 50.90           N  
ATOM    407  CA  VAL A  57      25.400 100.522 -17.923  1.00 47.71           C  
ATOM    408  C   VAL A  57      24.850 100.705 -16.505  1.00 47.65           C  
ATOM    409  O   VAL A  57      25.363 101.518 -15.722  1.00 52.74           O  
ATOM    410  CB  VAL A  57      26.840  99.931 -17.847  1.00 52.31           C  
ATOM    411  CG1 VAL A  57      26.844  98.642 -17.029  1.00 49.96           C  
ATOM    412  CG2 VAL A  57      27.363  99.669 -19.252  1.00 49.37           C  
ATOM    413  N   GLN A  58      23.815  99.941 -16.178  1.00 50.14           N  
ATOM    414  CA  GLN A  58      23.200 100.014 -14.860  1.00 45.39           C  
ATOM    415  C   GLN A  58      24.192  99.693 -13.744  1.00 41.24           C  
ATOM    416  O   GLN A  58      24.832  98.638 -13.758  1.00 41.56           O  
ATOM    417  CB  GLN A  58      21.996  99.062 -14.780  1.00 45.89           C  
ATOM    418  CG  GLN A  58      21.644  98.627 -13.366  1.00 48.07           C  
ATOM    419  CD  GLN A  58      20.218  98.163 -13.228  1.00 48.61           C  
ATOM    420  OE1 GLN A  58      19.335  98.628 -13.944  1.00 49.16           O  
ATOM    421  NE2 GLN A  58      19.981  97.274 -12.275  1.00 48.49           N  
ATOM    422  N   VAL A  59      24.313 100.606 -12.785  1.00 41.70           N  
ATOM    423  CA  VAL A  59      25.221 100.428 -11.659  1.00 43.71           C  
ATOM    424  C   VAL A  59      24.448 100.213 -10.364  1.00 38.35           C  
ATOM    425  O   VAL A  59      25.021  99.865  -9.324  1.00 37.74           O  
ATOM    426  CB  VAL A  59      26.169 101.643 -11.520  1.00 46.55           C  
ATOM    427  CG1 VAL A  59      26.700 101.734 -10.099  1.00 51.48           C  
ATOM    428  CG2 VAL A  59      27.328 101.488 -12.494  1.00 50.98           C  
ATOM    429  N   TRP A  60      23.148 100.453 -10.447  1.00 38.30           N  
ATOM    430  CA  TRP A  60      22.272 100.284  -9.292  1.00 39.94           C  
ATOM    431  C   TRP A  60      20.822 100.465  -9.634  1.00 43.37           C  
ATOM    432  O   TRP A  60      20.473 101.325 -10.468  1.00 38.32           O  
ATOM    433  CB  TRP A  60      22.613 101.269  -8.183  1.00 38.86           C  
ATOM    434  CG  TRP A  60      21.884 101.045  -6.880  1.00 41.48           C  
ATOM    435  CD1 TRP A  60      20.614 101.433  -6.560  1.00 42.70           C  
ATOM    436  CD2 TRP A  60      22.398 100.356  -5.737  1.00 42.64           C  
ATOM    437  NE1 TRP A  60      20.309 101.025  -5.284  1.00 42.98           N  
ATOM    438  CE2 TRP A  60      21.382 100.368  -4.759  1.00 42.80           C  
ATOM    439  CE3 TRP A  60      23.619  99.736  -5.449  1.00 43.10           C  
ATOM    440  CZ2 TRP A  60      21.555  99.769  -3.506  1.00 43.23           C  
ATOM    441  CZ3 TRP A  60      23.788  99.143  -4.204  1.00 43.60           C  
ATOM    442  CH2 TRP A  60      22.760  99.170  -3.243  1.00 43.44           C  
ATOM    443  N   GLU A  61      19.965  99.590  -9.100  1.00 41.63           N  
ATOM    444  CA  GLU A  61      18.531  99.778  -9.179  1.00 51.07           C  
ATOM    445  C   GLU A  61      17.950  99.226  -7.912  1.00 50.52           C  
ATOM    446  O   GLU A  61      18.471  98.264  -7.308  1.00 51.49           O  
ATOM    447  CB  GLU A  61      17.820  99.244 -10.436  1.00 60.10           C  
ATOM    448  CG  GLU A  61      17.103  98.025 -10.283  1.00 64.11           C  
ATOM    449  CD  GLU A  61      15.734  98.099  -9.695  1.00 65.31           C  
ATOM    450  OE1 GLU A  61      15.091  99.030  -9.857  1.00 65.31           O  
ATOM    451  OE2 GLU A  61      15.219  97.219  -9.098  1.00 65.40           O  
ATOM    452  N   ARG A  62      16.857  99.825  -7.455  1.00 49.68           N  
ATOM    453  CA  ARG A  62      16.249  99.489  -6.187  1.00 50.00           C  
ATOM    454  C   ARG A  62      15.904  98.051  -5.904  1.00 52.72           C  
ATOM    455  O   ARG A  62      16.380  97.472  -4.925  1.00 48.59           O  
ATOM    456  CB  ARG A  62      15.031 100.384  -5.945  1.00 47.31           C  
ATOM    457  CG  ARG A  62      14.776 100.725  -4.484  1.00 47.26           C  
ATOM    458  CD  ARG A  62      13.531 101.592  -4.308  1.00 47.50           C  
ATOM    459  NE  ARG A  62      12.435 101.177  -5.180  1.00 47.86           N  
ATOM    460  CZ  ARG A  62      11.609 100.170  -4.925  1.00 48.02           C  
ATOM    461  NH1 ARG A  62      11.751  99.454  -3.813  1.00 46.67           N  
ATOM    462  NH2 ARG A  62      10.641  99.869  -5.791  1.00 47.08           N  
ATOM    463  N   LYS A  63      15.081  97.494  -6.773  1.00 53.37           N  
ATOM    464  CA  LYS A  63      14.645  96.110  -6.630  1.00 62.01           C  
ATOM    465  C   LYS A  63      15.801  95.140  -6.686  1.00 61.84           C  
ATOM    466  O   LYS A  63      16.025  94.367  -5.756  1.00 61.28           O  
ATOM    467  CB  LYS A  63      13.609  95.755  -7.711  1.00 71.71           C  
ATOM    468  CG  LYS A  63      12.200  96.174  -7.361  1.00 74.86           C  
ATOM    469  CD  LYS A  63      11.565  97.035  -8.406  1.00 76.02           C  
ATOM    470  CE  LYS A  63      11.632  96.544  -9.798  1.00 76.17           C  
ATOM    471  NZ  LYS A  63      12.589  97.187 -10.694  1.00 76.04           N  
ATOM    472  N   ALA A  64      16.520  95.161  -7.777  1.00 58.02           N  
ATOM    473  CA  ALA A  64      17.685  94.317  -7.927  1.00 55.98           C  
ATOM    474  C   ALA A  64      18.576  94.323  -6.718  1.00 57.08           C  
ATOM    475  O   ALA A  64      18.860  93.299  -6.110  1.00 59.26           O  
ATOM    476  CB  ALA A  64      18.491  94.833  -9.053  1.00 52.14           C  
ATOM    477  N   ASP A  65      19.027  95.525  -6.353  1.00 59.33           N  
ATOM    478  CA  ASP A  65      19.972  95.708  -5.262  1.00 57.68           C  
ATOM    479  C   ASP A  65      19.394  95.804  -3.864  1.00 56.06           C  
ATOM    480  O   ASP A  65      20.142  95.915  -2.884  1.00 56.93           O  
ATOM    481  CB  ASP A  65      20.834  96.926  -5.589  1.00 61.39           C  
ATOM    482  CG  ASP A  65      21.802  96.664  -6.761  1.00 61.72           C  
ATOM    483  OD1 ASP A  65      22.735  95.869  -6.561  1.00 62.37           O  
ATOM    484  OD2 ASP A  65      21.630  97.255  -7.855  1.00 60.88           O  
ATOM    485  N   GLY A  66      18.075  95.788  -3.816  1.00 57.59           N  
ATOM    486  CA  GLY A  66      17.367  95.845  -2.552  1.00 55.07           C  
ATOM    487  C   GLY A  66      17.497  97.088  -1.705  1.00 57.71           C  
ATOM    488  O   GLY A  66      18.029  97.029  -0.590  1.00 54.67           O  
ATOM    489  N   GLY A  67      17.001  98.201  -2.220  1.00 56.16           N  
ATOM    490  CA  GLY A  67      17.090  99.434  -1.469  1.00 58.89           C  
ATOM    491  C   GLY A  67      17.955 100.518  -2.079  1.00 60.18           C  
ATOM    492  O   GLY A  67      18.069 100.619  -3.312  1.00 60.22           O  
ATOM    493  N   PHE A  68      18.618 101.282  -1.208  1.00 56.29           N  
ATOM    494  CA  PHE A  68      19.465 102.295  -1.665  1.00 46.91           C  
ATOM    495  C   PHE A  68      20.888 102.184  -1.203  1.00 43.91           C  
ATOM    496  O   PHE A  68      21.197 101.682  -0.113  1.00 54.65           O  
ATOM    497  CB  PHE A  68      18.873 103.668  -1.056  1.00 45.76           C  
ATOM    498  CG  PHE A  68      17.425 103.820  -1.431  1.00 37.69           C  
ATOM    499  CD1 PHE A  68      17.061 104.389  -2.642  1.00 34.69           C  
ATOM    500  CD2 PHE A  68      16.428 103.387  -0.568  1.00 35.62           C  
ATOM    501  CE1 PHE A  68      15.729 104.540  -2.980  1.00 35.90           C  
ATOM    502  CE2 PHE A  68      15.090 103.531  -0.895  1.00 35.24           C  
ATOM    503  CZ  PHE A  68      14.737 104.111  -2.100  1.00 36.21           C  
ATOM    504  N   PRO A  69      21.808 102.546  -2.072  1.00 50.25           N  
ATOM    505  CA  PRO A  69      23.221 102.388  -1.837  1.00 40.61           C  
ATOM    506  C   PRO A  69      23.867 103.181  -0.694  1.00 38.96           C  
ATOM    507  O   PRO A  69      23.421 104.259  -0.364  1.00 40.70           O  
ATOM    508  CB  PRO A  69      23.881 102.804  -3.106  1.00 37.86           C  
ATOM    509  CG  PRO A  69      22.942 103.851  -3.659  1.00 36.15           C  
ATOM    510  CD  PRO A  69      21.579 103.340  -3.326  1.00 39.32           C  
ATOM    511  N   GLU A  70      24.890 102.560  -0.097  1.00 43.14           N  
ATOM    512  CA  GLU A  70      25.666 103.277   0.905  1.00 49.11           C  
ATOM    513  C   GLU A  70      26.656 104.007  -0.060  1.00 46.60           C  
ATOM    514  O   GLU A  70      26.899 103.561  -1.208  1.00 41.15           O  
ATOM    515  CB  GLU A  70      26.454 102.346   1.810  1.00 58.57           C  
ATOM    516  CG  GLU A  70      25.555 101.535   2.716  1.00 67.42           C  
ATOM    517  CD  GLU A  70      25.225 102.246   4.020  1.00 70.57           C  
ATOM    518  OE1 GLU A  70      24.631 103.346   3.981  1.00 69.95           O  
ATOM    519  OE2 GLU A  70      25.571 101.699   5.093  1.00 70.48           O  
ATOM    520  N   ALA A  71      27.240 105.112   0.377  1.00 41.28           N  
ATOM    521  CA  ALA A  71      28.153 105.882  -0.449  1.00 43.83           C  
ATOM    522  C   ALA A  71      29.361 105.072  -0.887  1.00 45.78           C  
ATOM    523  O   ALA A  71      29.724 105.077  -2.065  1.00 46.65           O  
ATOM    524  CB  ALA A  71      28.585 107.147   0.306  1.00 38.82           C  
ATOM    525  N   LYS A  72      29.969 104.376   0.063  1.00 48.36           N  
ATOM    526  CA  LYS A  72      31.136 103.548  -0.223  1.00 52.07           C  
ATOM    527  C   LYS A  72      30.818 102.477  -1.272  1.00 50.78           C  
ATOM    528  O   LYS A  72      31.590 102.251  -2.191  1.00 51.33           O  
ATOM    529  CB  LYS A  72      31.642 102.884   1.065  1.00 58.81           C  
ATOM    530  CG  LYS A  72      32.686 101.802   0.833  1.00 61.03           C  
ATOM    531  CD  LYS A  72      33.514 101.556   2.084  1.00 61.71           C  
ATOM    532  CE  LYS A  72      33.090 100.281   2.783  1.00 61.70           C  
ATOM    533  NZ  LYS A  72      33.473 100.276   4.221  1.00 61.49           N  
ATOM    534  N   ALA A  73      29.670 101.824  -1.138  1.00 58.67           N  
ATOM    535  CA  ALA A  73      29.289 100.789  -2.082  1.00 61.98           C  
ATOM    536  C   ALA A  73      29.111 101.345  -3.500  1.00 54.78           C  
ATOM    537  O   ALA A  73      29.592 100.755  -4.472  1.00 47.42           O  
ATOM    538  CB  ALA A  73      28.000 100.109  -1.609  1.00 92.17           C  
ATOM    539  N   LEU A  74      28.423 102.479  -3.618  1.00 46.45           N  
ATOM    540  CA  LEU A  74      28.188 103.086  -4.922  1.00 43.65           C  
ATOM    541  C   LEU A  74      29.481 103.576  -5.559  1.00 46.13           C  
ATOM    542  O   LEU A  74      29.657 103.463  -6.767  1.00 44.41           O  
ATOM    543  CB  LEU A  74      27.204 104.256  -4.803  1.00 38.35           C  
ATOM    544  CG  LEU A  74      26.883 104.968  -6.118  1.00 36.13           C  
ATOM    545  CD1 LEU A  74      26.239 103.996  -7.077  1.00 36.02           C  
ATOM    546  CD2 LEU A  74      25.951 106.145  -5.863  1.00 35.10           C  
ATOM    547  N   LYS A  75      30.380 104.127  -4.747  1.00 46.46           N  
ATOM    548  CA  LYS A  75      31.650 104.636  -5.257  1.00 51.68           C  
ATOM    549  C   LYS A  75      32.482 103.480  -5.778  1.00 57.61           C  
ATOM    550  O   LYS A  75      33.171 103.608  -6.789  1.00 55.08           O  
ATOM    551  CB  LYS A  75      32.437 105.352  -4.158  1.00 51.63           C  
ATOM    552  CG  LYS A  75      31.791 106.604  -3.601  1.00 49.34           C  
ATOM    553  CD  LYS A  75      32.678 107.204  -2.521  1.00 48.75           C  
ATOM    554  CE  LYS A  75      31.969 108.302  -1.764  1.00 49.93           C  
ATOM    555  NZ  LYS A  75      32.866 108.955  -0.770  1.00 49.67           N  
ATOM    556  N   GLN A  76      32.422 102.356  -5.069  1.00 56.73           N  
ATOM    557  CA  GLN A  76      33.166 101.162  -5.451  1.00 57.20           C  
ATOM    558  C   GLN A  76      32.694 100.665  -6.817  1.00 53.98           C  
ATOM    559  O   GLN A  76      33.507 100.306  -7.672  1.00 60.96           O  
ATOM    560  CB  GLN A  76      32.979 100.069  -4.387  1.00 64.48           C  
ATOM    561  CG  GLN A  76      33.705 100.347  -3.070  1.00 62.02           C  
ATOM    562  CD  GLN A  76      33.384  99.325  -1.986  1.00 61.58           C  
ATOM    563  OE1 GLN A  76      34.049  99.272  -0.954  1.00 61.93           O  
ATOM    564  NE2 GLN A  76      32.356  98.514  -2.215  1.00 61.48           N  
ATOM    565  N   ARG A  77      31.381 100.660  -7.017  1.00 55.93           N  
ATOM    566  CA  ARG A  77      30.797 100.213  -8.276  1.00 49.30           C  
ATOM    567  C   ARG A  77      31.165 101.135  -9.444  1.00 47.53           C  
ATOM    568  O   ARG A  77      31.330 100.669 -10.581  1.00 45.50           O  
ATOM    569  CB  ARG A  77      29.270 100.115  -8.149  1.00 46.75           C  
ATOM    570  CG  ARG A  77      28.816  99.021  -7.193  1.00 48.01           C  
ATOM    571  CD  ARG A  77      27.473  98.455  -7.613  1.00 48.58           C  
ATOM    572  NE  ARG A  77      26.957  97.499  -6.631  1.00 48.99           N  
ATOM    573  CZ  ARG A  77      25.761  96.926  -6.718  1.00 49.55           C  
ATOM    574  NH1 ARG A  77      24.957  97.214  -7.748  1.00 48.90           N  
ATOM    575  NH2 ARG A  77      25.356  96.072  -5.780  1.00 48.37           N  
ATOM    576  N   VAL A  78      31.272 102.443  -9.179  1.00 45.05           N  
ATOM    577  CA  VAL A  78      31.631 103.405 -10.227  1.00 45.84           C  
ATOM    578  C   VAL A  78      33.128 103.258 -10.471  1.00 50.86           C  
ATOM    579  O   VAL A  78      33.602 103.322 -11.610  1.00 51.04           O  
ATOM    580  CB  VAL A  78      31.275 104.837  -9.809  1.00 45.38           C  
ATOM    581  CG1 VAL A  78      31.796 105.812 -10.853  1.00 39.77           C  
ATOM    582  CG2 VAL A  78      29.759 104.937  -9.702  1.00 41.19           C  
ATOM    583  N   ARG A  79      33.881 103.104  -9.398  1.00 56.08           N  
ATOM    584  CA  ARG A  79      35.315 102.882  -9.452  1.00 64.57           C  
ATOM    585  C   ARG A  79      35.556 101.721 -10.446  1.00 64.75           C  
ATOM    586  O   ARG A  79      36.229 101.855 -11.456  1.00 56.73           O  
ATOM    587  CB  ARG A  79      35.794 102.412  -8.091  1.00 72.30           C  
ATOM    588  CG  ARG A  79      37.258 102.587  -7.830  1.00 80.28           C  
ATOM    589  CD  ARG A  79      37.540 102.655  -6.398  1.00 83.78           C  
ATOM    590  NE  ARG A  79      37.044 101.608  -5.549  1.00 84.07           N  
ATOM    591  CZ  ARG A  79      37.510 100.395  -5.511  1.00 83.68           C  
ATOM    592  NH1 ARG A  79      38.450 100.073  -6.272  1.00 83.66           N  
ATOM    593  NH2 ARG A  79      37.027  99.511  -4.712  1.00 83.82           N  
ATOM    594  N   ASP A  80      35.025 100.592 -10.168  1.00 58.26           N  
ATOM    595  CA  ASP A  80      35.277  99.403 -10.977  1.00 58.97           C  
ATOM    596  C   ASP A  80      35.050  99.616 -12.473  1.00 60.33           C  
ATOM    597  O   ASP A  80      35.727  99.005 -13.303  1.00 66.87           O  
ATOM    598  CB  ASP A  80      34.408  98.230 -10.510  1.00 61.54           C  
ATOM    599  CG  ASP A  80      34.812  97.702  -9.141  1.00 56.42           C  
ATOM    600  OD1 ASP A  80      35.983  97.888  -8.745  1.00 54.58           O  
ATOM    601  OD2 ASP A  80      33.957  97.083  -8.467  1.00 54.90           O  
ATOM    602  N   ARG A  81      34.111 100.486 -12.822  1.00 67.12           N  
ATOM    603  CA  ARG A  81      33.811 100.726 -14.225  1.00 67.31           C  
ATOM    604  C   ARG A  81      34.584 101.873 -14.847  1.00 65.19           C  
ATOM    605  O   ARG A  81      34.825 101.887 -16.054  1.00 57.44           O  
ATOM    606  CB  ARG A  81      32.319 101.010 -14.404  1.00 69.91           C  
ATOM    607  CG  ARG A  81      31.419  99.889 -13.951  1.00 77.63           C  
ATOM    608  CD  ARG A  81      30.053 100.058 -14.561  1.00 80.82           C  
ATOM    609  NE  ARG A  81      30.141 100.126 -16.018  1.00 80.14           N  
ATOM    610  CZ  ARG A  81      30.506  99.109 -16.792  1.00 80.71           C  
ATOM    611  NH1 ARG A  81      30.814  97.937 -16.248  1.00 80.89           N  
ATOM    612  NH2 ARG A  81      30.569  99.265 -18.109  1.00 80.43           N  
ATOM    613  N   ILE A  82      34.982 102.822 -14.015  1.00 61.65           N  
ATOM    614  CA  ILE A  82      35.671 104.017 -14.487  1.00 76.21           C  
ATOM    615  C   ILE A  82      37.171 104.036 -14.306  1.00 87.94           C  
ATOM    616  O   ILE A  82      37.887 104.649 -15.070  1.00 77.10           O  
ATOM    617  CB  ILE A  82      35.067 105.276 -13.789  1.00 77.63           C  
ATOM    618  CG1 ILE A  82      34.193 106.018 -14.790  1.00 79.44           C  
ATOM    619  CG2 ILE A  82      36.155 106.178 -13.217  1.00 79.38           C  
ATOM    620  CD1 ILE A  82      33.153 105.138 -15.427  1.00 80.03           C  
ATOM    621  N   ASP A  83      37.639 103.350 -13.284  1.00 88.12           N  
ATOM    622  CA  ASP A  83      39.052 103.305 -12.953  1.00106.02           C  
ATOM    623  C   ASP A  83      39.217 102.029 -12.132  1.00111.12           C  
ATOM    624  O   ASP A  83      39.401 102.080 -10.929  1.00113.22           O  
ATOM    625  CB  ASP A  83      39.419 104.535 -12.095  1.00114.82           C  
ATOM    626  CG  ASP A  83      40.911 104.766 -11.995  1.00114.17           C  
ATOM    627  OD1 ASP A  83      41.662 103.898 -12.456  1.00114.04           O  
ATOM    628  OD2 ASP A  83      41.330 105.812 -11.455  1.00113.60           O  
ATOM    629  N   PRO A  84      39.155 100.865 -12.784  1.00100.48           N  
ATOM    630  CA  PRO A  84      39.288  99.543 -12.159  1.00111.08           C  
ATOM    631  C   PRO A  84      40.273  99.511 -10.995  1.00139.78           C  
ATOM    632  O   PRO A  84      39.949  99.067  -9.894  1.00134.97           O  
ATOM    633  CB  PRO A  84      39.737  98.669 -13.328  1.00 97.30           C  
ATOM    634  CG  PRO A  84      38.981  99.264 -14.470  1.00 87.38           C  
ATOM    635  CD  PRO A  84      39.160 100.754 -14.250  1.00 95.79           C  
ATOM    636  N   GLN A  85      41.483  99.980 -11.263  1.00145.18           N  
ATOM    637  CA  GLN A  85      42.543 100.025 -10.269  1.00152.10           C  
ATOM    638  C   GLN A  85      42.547 101.386  -9.583  1.00149.30           C  
ATOM    639  O   GLN A  85      42.954 102.355 -10.139  1.00163.33           O  
ATOM    640  CB  GLN A  85      43.894  99.735 -10.950  1.00162.92           C  
ATOM    641  CG  GLN A  85      44.003 100.287 -12.337  1.00157.90           C  
ATOM    642  CD  GLN A  85      45.251  99.877 -13.058  1.00156.07           C  
ATOM    643  OE1 GLN A  85      45.371 100.032 -14.277  1.00156.08           O  
ATOM    644  NE2 GLN A  85      46.196  99.361 -12.315  1.00156.10           N  
ATOM    645  N   ARG A  86      42.081 101.441  -8.351  1.00147.35           N  
ATOM    646  CA  ARG A  86      42.010 102.681  -7.592  1.00122.90           C  
ATOM    647  C   ARG A  86      41.432 102.367  -6.213  1.00118.64           C  
ATOM    648  O   ARG A  86      40.435 101.670  -6.088  1.00123.37           O  
ATOM    649  CB  ARG A  86      41.092 103.670  -8.323  1.00111.13           C  
ATOM    650  CG  ARG A  86      41.401 105.139  -8.089  1.00104.23           C  
ATOM    651  CD  ARG A  86      40.750 105.714  -6.855  1.00101.38           C  
ATOM    652  NE  ARG A  86      40.114 106.995  -7.139  1.00101.48           N  
ATOM    653  CZ  ARG A  86      39.747 107.890  -6.233  1.00101.36           C  
ATOM    654  NH1 ARG A  86      39.945 107.666  -4.982  1.00101.25           N  
ATOM    655  NH2 ARG A  86      39.173 109.017  -6.577  1.00100.87           N  
ATOM    656  N   ASP A  87      42.029 102.921  -5.173  1.00127.97           N  
ATOM    657  CA  ASP A  87      41.528 102.676  -3.829  1.00140.96           C  
ATOM    658  C   ASP A  87      40.586 103.770  -3.330  1.00133.71           C  
ATOM    659  O   ASP A  87      39.445 103.426  -2.948  1.00123.63           O  
ATOM    660  CB  ASP A  87      42.700 102.518  -2.863  1.00151.73           C  
ATOM    661  CG  ASP A  87      43.590 101.355  -3.229  1.00168.01           C  
ATOM    662  OD1 ASP A  87      43.094 100.208  -3.250  1.00174.11           O  
ATOM    663  OD2 ASP A  87      44.783 101.589  -3.503  1.00174.15           O  
TER     664      ASP A  87                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
