
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   79 (  626),  selected   79 , name 2ojl_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2ojl_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     7_A      -       -           -
LGA    P     8_A      T      12          1.039
LGA    P     9_A      H      13          1.229
LGA    R    10_A      R      14          0.958
LGA    I    11_A      V      15          0.490
LGA    A    12_A      Q      16          0.531
LGA    I    13_A      I      17          0.187
LGA    Q    14_A      E      18          0.149
LGA    Y    15_A      Y      19          0.350
LGA    C    16_A      C      20          0.318
LGA    T    17_A      T      21          0.286
LGA    Q    18_A      Q      22          0.945
LGA    C    19_A      C      23          0.523
LGA    Q    20_A      R      24          0.608
LGA    W    21_A      W      25          0.395
LGA    L    22_A      L      26          0.410
LGA    L    23_A      P      27          0.411
LGA    R    24_A      R      28          0.415
LGA    A    25_A      A      29          0.403
LGA    A    26_A      A      30          0.513
LGA    W    27_A      W      31          0.362
LGA    X    28_A      L      32          0.401
LGA    A    29_A      A      33          0.464
LGA    Q    30_A      Q      34          0.462
LGA    E    31_A      E      35          0.422
LGA    L    32_A      L      36          0.670
LGA    L    33_A      L      37          0.684
LGA    S    34_A      T      38          0.698
LGA    T    35_A      T      39          0.939
LGA    F    36_A      F      40          1.212
LGA    G    37_A      E      41          0.840
LGA    A    38_A      T      42          2.427
LGA    D    39_A      E      43          0.841
LGA    L    40_A      L      44          0.553
LGA    G    41_A      T      45          1.107
LGA    E    42_A      E      46          0.878
LGA    V    43_A      L      47          0.702
LGA    A    44_A      A      48          0.379
LGA    L    45_A      L      49          0.551
LGA    V    46_A      K      50          0.457
LGA    P    47_A      P      51          0.240
LGA    G    48_A      G      52          0.406
LGA    T    49_A      T      53          0.507
LGA    G    50_A      G      54          0.626
LGA    G    51_A      G      55          0.439
LGA    V    52_A      V      56          0.378
LGA    F    53_A      F      57          0.348
LGA    R    54_A      V      58          0.558
LGA    I    55_A      V      59          0.557
LGA    H    56_A      R      60          0.452
LGA    Y    57_A      V      61          0.414
LGA    N    58_A      D      62          0.702
LGA    G    59_A      D      63          0.946
LGA    A    60_A      E      64          0.721
LGA    P    61_A      V      65          1.262
LGA    L    62_A      V      66          0.632
LGA    W    63_A      W      67          0.363
LGA    D    64_A      D      68          0.492
LGA    R    65_A      R      69          0.894
LGA    E    66_A      R      70          1.851
LGA    V    67_A      E      71          1.585
LGA    D    68_A      Q      72          1.200
LGA    G    69_A      G      73          2.553
LGA    G    70_A      -       -           -
LGA    F    71_A      F      74          1.262
LGA    P    72_A      P      75          1.031
LGA    E    73_A      E      76          0.720
LGA    A    74_A      P      77          0.648
LGA    K    75_A      T      78          0.663
LGA    V    76_A      A      79          0.861
LGA    L    77_A      V      80          1.212
LGA    K    78_A      K      81          0.913
LGA    Q    79_A      R      82          0.535
LGA    R    80_A      L      83          0.656
LGA    V    81_A      V      84          0.671
LGA    R    82_A      R      85          0.632
LGA    D    83_A      D      86          0.606
LGA    H    84_A      R      87          0.629
LGA    L    85_A      V      88          0.523

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   79   77    5.0     77    0.83    54.55     98.690     8.255

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.719077 * X  +   0.694622 * Y  +   0.020703 * Z  +  42.970337
  Y_new =   0.282997 * X  +   0.265491 * Y  +   0.921644 * Z  +  65.620186
  Z_new =   0.634697 * X  +   0.668592 * Y  +  -0.387485 * Z  + -27.804972 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.096046   -1.045547  [ DEG:   120.0946    -59.9054 ]
  Theta =  -0.687617   -2.453976  [ DEG:   -39.3975   -140.6025 ]
  Phi   =   2.766654   -0.374939  [ DEG:   158.5176    -21.4824 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ojl_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ojl_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   79   77   5.0   77   0.83   54.55  98.690
REMARK  ---------------------------------------------------------- 
MOLECULE 2ojl_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   12-JAN-07   2OJL              
TITLE     CRYSTAL STRUCTURE OF Q7WAF1_BORPA FROM BORDETELLA                     
TITLE    2 PARAPERTUSSIS. NORTHEAST STRUCTURAL GENOMICS TARGET BPR68.           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BORDETELLA PARAPERTUSSIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 12822;                                                       
SOURCE   5 ATCC: BAA-587;                                                       
SOURCE   6 GENE: BPP1426;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    BPR68, NESG, Q7WAF1, STRUCTURAL GENOMICS, PSI-2, PROTEIN              
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.BENACH,H.NEELY,J.SEETHARAMAN,H.WANG,Y.FANG,K.CUNNINGHAM,            
AUTHOR   2 L.C.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,                      
AUTHOR   3 G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   23-JAN-07 2OJL    0                                                
JRNL        AUTH   J.BENACH,H.NEELY,J.SEETHARAMAN,H.WANG,Y.FANG,                
JRNL        AUTH 2 K.CUNNINGHAM,L.C.MA,R.XIAO,J.LIU,M.C.BARAN,                  
JRNL        AUTH 3 T.B.ACTON,B.ROST,G.T.MONTELIONE,J.F.HUNT,L.TONG              
JRNL        TITL   CRYSTAL STRUCTURE OF Q7WAF1_BORPA FROM BORDETELLA            
JRNL        TITL 2 PARAPERTUSSIS                                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2OJL A    1   100  UNP    Q7WAF1   Q7WAF1_BORPA     1    100             
DBREF  2OJL B    1   100  UNP    Q7WAF1   Q7WAF1_BORPA     1    100             
SEQRES   1 A  108  MSE ILE THR PRO PRO ASP HIS PRO PRO ARG ILE ALA ILE          
SEQRES   2 A  108  GLN TYR CYS THR GLN CYS GLN TRP LEU LEU ARG ALA ALA          
SEQRES   3 A  108  TRP MSE ALA GLN GLU LEU LEU SER THR PHE GLY ALA ASP          
SEQRES   4 A  108  LEU GLY GLU VAL ALA LEU VAL PRO GLY THR GLY GLY VAL          
SEQRES   5 A  108  PHE ARG ILE HIS TYR ASN GLY ALA PRO LEU TRP ASP ARG          
SEQRES   6 A  108  GLU VAL ASP GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS          
SEQRES   7 A  108  GLN ARG VAL ARG ASP HIS LEU ASP PRO GLY ARG PRO LEU          
SEQRES   8 A  108  GLY HIS ILE ASP GLY ARG PRO LYS PRO LEU GLU HIS HIS          
SEQRES   9 A  108  HIS HIS HIS HIS                                              
SEQRES   1 B  108  MSE ILE THR PRO PRO ASP HIS PRO PRO ARG ILE ALA ILE          
SEQRES   2 B  108  GLN TYR CYS THR GLN CYS GLN TRP LEU LEU ARG ALA ALA          
SEQRES   3 B  108  TRP MSE ALA GLN GLU LEU LEU SER THR PHE GLY ALA ASP          
SEQRES   4 B  108  LEU GLY GLU VAL ALA LEU VAL PRO GLY THR GLY GLY VAL          
SEQRES   5 B  108  PHE ARG ILE HIS TYR ASN GLY ALA PRO LEU TRP ASP ARG          
SEQRES   6 B  108  GLU VAL ASP GLY GLY PHE PRO GLU ALA LYS VAL LEU LYS          
SEQRES   7 B  108  GLN ARG VAL ARG ASP HIS LEU ASP PRO GLY ARG PRO LEU          
SEQRES   8 B  108  GLY HIS ILE ASP GLY ARG PRO LYS PRO LEU GLU HIS HIS          
SEQRES   9 B  108  HIS HIS HIS HIS                                              
HET    MSE  A  28       8                                                       
HET    MSE  B  28       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *128(H2 O)                                                    
CRYST1   65.671   65.671   76.783  90.00  90.00  90.00 P 42 21 2    16          
ATOM      1  N   HIS A   7      36.394 109.573 -23.826  1.00 57.74           N  
ATOM      2  CA  HIS A   7      35.166 110.290 -23.370  1.00 57.23           C  
ATOM      3  C   HIS A   7      34.871 110.085 -21.887  1.00 50.70           C  
ATOM      4  O   HIS A   7      34.676 108.951 -21.439  1.00 49.43           O  
ATOM      5  CB  HIS A   7      33.954 109.842 -24.182  1.00 66.11           C  
ATOM      6  CG  HIS A   7      33.807 110.535 -25.499  1.00 78.30           C  
ATOM      7  ND1 HIS A   7      33.674 111.897 -25.612  1.00 83.44           N  
ATOM      8  CD2 HIS A   7      33.758 110.046 -26.763  1.00 83.44           C  
ATOM      9  CE1 HIS A   7      33.544 112.226 -26.881  1.00 86.34           C  
ATOM     10  NE2 HIS A   7      33.595 111.123 -27.603  1.00 86.36           N  
ATOM     11  N   PRO A   8      34.832 111.173 -21.105  1.00 44.17           N  
ATOM     12  CA  PRO A   8      34.537 111.029 -19.672  1.00 38.67           C  
ATOM     13  C   PRO A   8      33.142 110.440 -19.531  1.00 32.34           C  
ATOM     14  O   PRO A   8      32.248 110.732 -20.330  1.00 31.81           O  
ATOM     15  CB  PRO A   8      34.639 112.474 -19.160  1.00 38.53           C  
ATOM     16  CG  PRO A   8      34.244 113.290 -20.361  1.00 40.13           C  
ATOM     17  CD  PRO A   8      34.974 112.595 -21.484  1.00 41.74           C  
ATOM     18  N   PRO A   9      32.927 109.581 -18.518  1.00 28.55           N  
ATOM     19  CA  PRO A   9      31.638 108.928 -18.275  1.00 25.20           C  
ATOM     20  C   PRO A   9      30.486 109.779 -17.789  1.00 24.48           C  
ATOM     21  O   PRO A   9      30.646 110.741 -17.033  1.00 24.34           O  
ATOM     22  CB  PRO A   9      32.006 107.844 -17.256  1.00 24.91           C  
ATOM     23  CG  PRO A   9      33.062 108.519 -16.452  1.00 27.77           C  
ATOM     24  CD  PRO A   9      33.924 109.172 -17.507  1.00 27.10           C  
ATOM     25  N   ARG A  10      29.288 109.409 -18.258  1.00 21.75           N  
ATOM     26  CA  ARG A  10      28.068 110.078 -17.849  1.00 23.22           C  
ATOM     27  C   ARG A  10      27.366 109.161 -16.857  1.00 22.86           C  
ATOM     28  O   ARG A  10      26.992 108.023 -17.190  1.00 20.42           O  
ATOM     29  CB  ARG A  10      27.137 110.344 -19.034  1.00 23.41           C  
ATOM     30  CG  ARG A  10      25.684 110.646 -18.634  1.00 27.04           C  
ATOM     31  CD  ARG A  10      24.806 110.896 -19.844  1.00 29.29           C  
ATOM     32  NE  ARG A  10      23.358 110.661 -19.586  1.00 31.69           N  
ATOM     33  CZ  ARG A  10      22.538 111.646 -19.153  1.00 31.76           C  
ATOM     34  NH1 ARG A  10      23.046 112.841 -18.964  1.00 31.63           N  
ATOM     35  NH2 ARG A  10      21.256 111.476 -18.931  1.00 29.78           N  
ATOM     36  N   ILE A  11      27.186 109.641 -15.637  1.00 19.35           N  
ATOM     37  CA  ILE A  11      26.485 108.867 -14.620  1.00 19.83           C  
ATOM     38  C   ILE A  11      25.092 109.467 -14.498  1.00 19.63           C  
ATOM     39  O   ILE A  11      24.926 110.676 -14.362  1.00 19.15           O  
ATOM     40  CB  ILE A  11      27.218 108.924 -13.268  1.00 19.01           C  
ATOM     41  CG1 ILE A  11      28.569 108.229 -13.394  1.00 20.11           C  
ATOM     42  CG2 ILE A  11      26.367 108.255 -12.202  1.00 19.18           C  
ATOM     43  CD1 ILE A  11      29.397 108.230 -12.133  1.00 22.13           C  
ATOM     44  N   ALA A  12      24.075 108.612 -14.556  1.00 16.93           N  
ATOM     45  CA  ALA A  12      22.707 109.069 -14.465  1.00 14.43           C  
ATOM     46  C   ALA A  12      22.003 108.472 -13.260  1.00 14.53           C  
ATOM     47  O   ALA A  12      22.046 107.256 -13.052  1.00 11.39           O  
ATOM     48  CB  ALA A  12      21.942 108.719 -15.743  1.00 13.88           C  
ATOM     49  N   ILE A  13      21.362 109.306 -12.481  1.00 14.21           N  
ATOM     50  CA  ILE A  13      20.630 108.846 -11.317  1.00 16.46           C  
ATOM     51  C   ILE A  13      19.178 109.203 -11.524  1.00 17.65           C  
ATOM     52  O   ILE A  13      18.805 110.376 -11.494  1.00 17.10           O  
ATOM     53  CB  ILE A  13      21.122 109.500 -10.019  1.00 17.59           C  
ATOM     54  CG1 ILE A  13      22.619 109.192  -9.817  1.00 17.94           C  
ATOM     55  CG2 ILE A  13      20.306 109.001  -8.828  1.00 19.28           C  
ATOM     56  CD1 ILE A  13      23.293 110.032  -8.750  1.00 20.18           C  
ATOM     57  N   GLN A  14      18.349 108.188 -11.760  1.00 15.35           N  
ATOM     58  CA  GLN A  14      16.934 108.390 -11.992  1.00 18.12           C  
ATOM     59  C   GLN A  14      16.216 108.072 -10.679  1.00 18.20           C  
ATOM     60  O   GLN A  14      16.388 106.992 -10.099  1.00 16.63           O  
ATOM     61  CB  GLN A  14      16.463 107.466 -13.102  1.00 20.84           C  
ATOM     62  CG  GLN A  14      15.072 107.745 -13.588  1.00 29.19           C  
ATOM     63  CD  GLN A  14      14.695 106.874 -14.781  1.00 33.52           C  
ATOM     64  OE1 GLN A  14      13.583 106.961 -15.292  1.00 35.86           O  
ATOM     65  NE2 GLN A  14      15.627 106.035 -15.214  1.00 33.95           N  
ATOM     66  N   TYR A  15      15.387 109.019 -10.214  1.00 15.75           N  
ATOM     67  CA  TYR A  15      14.693 108.875  -8.939  1.00 15.78           C  
ATOM     68  C   TYR A  15      13.200 109.184  -9.029  1.00 15.77           C  
ATOM     69  O   TYR A  15      12.756 110.052  -9.782  1.00 13.79           O  
ATOM     70  CB  TYR A  15      15.322 109.804  -7.898  1.00 14.52           C  
ATOM     71  CG  TYR A  15      15.134 111.281  -8.228  1.00 12.61           C  
ATOM     72  CD1 TYR A  15      15.943 111.926  -9.168  1.00 14.39           C  
ATOM     73  CD2 TYR A  15      14.073 112.007  -7.678  1.00 14.57           C  
ATOM     74  CE1 TYR A  15      15.699 113.246  -9.550  1.00 13.60           C  
ATOM     75  CE2 TYR A  15      13.815 113.323  -8.058  1.00 13.86           C  
ATOM     76  CZ  TYR A  15      14.637 113.928  -8.996  1.00 14.33           C  
ATOM     77  OH  TYR A  15      14.370 115.229  -9.377  1.00 16.98           O  
ATOM     78  N   CYS A  16      12.422 108.480  -8.222  1.00 15.00           N  
ATOM     79  CA  CYS A  16      10.979 108.702  -8.165  1.00 18.73           C  
ATOM     80  C   CYS A  16      10.754 110.113  -7.608  1.00 21.26           C  
ATOM     81  O   CYS A  16      11.109 110.412  -6.471  1.00 18.89           O  
ATOM     82  CB  CYS A  16      10.313 107.651  -7.278  1.00 19.79           C  
ATOM     83  SG  CYS A  16       8.667 108.136  -6.734  1.00 21.65           S  
ATOM     84  N   THR A  17      10.157 110.973  -8.426  1.00 24.73           N  
ATOM     85  CA  THR A  17       9.888 112.345  -8.050  1.00 28.20           C  
ATOM     86  C   THR A  17       8.892 112.492  -6.905  1.00 28.40           C  
ATOM     87  O   THR A  17       9.182 113.154  -5.894  1.00 25.82           O  
ATOM     88  CB  THR A  17       9.351 113.144  -9.270  1.00 31.70           C  
ATOM     89  OG1 THR A  17      10.299 113.034 -10.345  1.00 38.61           O  
ATOM     90  CG2 THR A  17       9.172 114.600  -8.926  1.00 37.43           C  
ATOM     91  N   GLN A  18       7.734 111.878  -7.035  1.00 29.90           N  
ATOM     92  CA  GLN A  18       6.700 111.964  -6.002  1.00 32.43           C  
ATOM     93  C   GLN A  18       7.079 111.316  -4.678  1.00 30.57           C  
ATOM     94  O   GLN A  18       6.452 111.592  -3.652  1.00 29.87           O  
ATOM     95  CB  GLN A  18       5.395 111.358  -6.522  1.00 37.31           C  
ATOM     96  CG  GLN A  18       4.823 112.060  -7.747  1.00 49.17           C  
ATOM     97  CD  GLN A  18       4.690 113.578  -7.569  1.00 55.14           C  
ATOM     98  OE1 GLN A  18       4.383 114.045  -6.504  1.00 58.37           O  
ATOM     99  NE2 GLN A  18       4.907 114.275  -8.623  1.00 58.73           N  
ATOM    100  N   CYS A  19       8.103 110.455  -4.681  1.00 28.46           N  
ATOM    101  CA  CYS A  19       8.522 109.794  -3.453  1.00 27.16           C  
ATOM    102  C   CYS A  19       9.452 110.703  -2.649  1.00 26.65           C  
ATOM    103  O   CYS A  19       9.801 110.398  -1.503  1.00 26.30           O  
ATOM    104  CB  CYS A  19       9.297 108.513  -3.772  1.00 26.06           C  
ATOM    105  SG  CYS A  19       8.461 107.302  -4.878  1.00 27.26           S  
ATOM    106  N   GLN A  20       9.843 111.821  -3.251  1.00 26.04           N  
ATOM    107  CA  GLN A  20      10.732 112.782  -2.597  1.00 26.19           C  
ATOM    108  C   GLN A  20      12.134 112.217  -2.474  1.00 23.59           C  
ATOM    109  O   GLN A  20      12.822 112.458  -1.477  1.00 23.55           O  
ATOM    110  CB  GLN A  20      10.193 113.153  -1.219  1.00 31.20           C  
ATOM    111  CG  GLN A  20       8.790 113.729  -1.224  1.00 39.76           C  
ATOM    112  CD  GLN A  20       8.714 115.042  -1.972  1.00 45.16           C  
ATOM    113  OE1 GLN A  20       9.408 116.001  -1.640  1.00 48.95           O  
ATOM    114  NE2 GLN A  20       7.856 115.103  -2.990  1.00 49.10           N  
ATOM    115  N   TRP A  21      12.582 111.449  -3.470  1.00 18.36           N  
ATOM    116  CA  TRP A  21      13.911 110.875  -3.404  1.00 15.65           C  
ATOM    117  C   TRP A  21      14.961 111.766  -4.065  1.00 13.78           C  
ATOM    118  O   TRP A  21      16.085 111.360  -4.287  1.00 12.97           O  
ATOM    119  CB  TRP A  21      13.938 109.480  -4.043  1.00 13.48           C  
ATOM    120  CG  TRP A  21      13.134 108.453  -3.292  1.00 15.35           C  
ATOM    121  CD1 TRP A  21      12.611 108.583  -2.029  1.00 13.54           C  
ATOM    122  CD2 TRP A  21      12.731 107.159  -3.757  1.00 15.57           C  
ATOM    123  NE1 TRP A  21      11.917 107.454  -1.680  1.00 13.71           N  
ATOM    124  CE2 TRP A  21      11.970 106.565  -2.724  1.00 17.20           C  
ATOM    125  CE3 TRP A  21      12.947 106.441  -4.943  1.00 18.91           C  
ATOM    126  CZ2 TRP A  21      11.418 105.272  -2.848  1.00 15.40           C  
ATOM    127  CZ3 TRP A  21      12.396 105.169  -5.063  1.00 17.32           C  
ATOM    128  CH2 TRP A  21      11.641 104.598  -4.023  1.00 15.89           C  
ATOM    129  N   LEU A  22      14.574 113.014  -4.357  1.00 15.08           N  
ATOM    130  CA  LEU A  22      15.497 113.969  -4.937  1.00 15.80           C  
ATOM    131  C   LEU A  22      16.667 114.219  -3.989  1.00 16.68           C  
ATOM    132  O   LEU A  22      17.819 114.239  -4.410  1.00 17.07           O  
ATOM    133  CB  LEU A  22      14.784 115.290  -5.236  1.00 15.21           C  
ATOM    134  CG  LEU A  22      15.681 116.479  -5.582  1.00 17.51           C  
ATOM    135  CD1 LEU A  22      16.589 116.142  -6.771  1.00 16.23           C  
ATOM    136  CD2 LEU A  22      14.811 117.681  -5.903  1.00 14.68           C  
ATOM    137  N   LEU A  23      16.361 114.424  -2.714  1.00 15.41           N  
ATOM    138  CA  LEU A  23      17.422 114.688  -1.724  1.00 16.24           C  
ATOM    139  C   LEU A  23      18.483 113.610  -1.721  1.00 15.64           C  
ATOM    140  O   LEU A  23      19.685 113.916  -1.738  1.00 12.15           O  
ATOM    141  CB  LEU A  23      16.860 114.819  -0.310  1.00 21.83           C  
ATOM    142  CG  LEU A  23      16.131 116.105   0.107  1.00 27.81           C  
ATOM    143  CD1 LEU A  23      15.741 115.991   1.575  1.00 30.43           C  
ATOM    144  CD2 LEU A  23      17.034 117.314  -0.116  1.00 30.54           C  
ATOM    145  N   ARG A  24      18.077 112.350  -1.683  1.00 14.81           N  
ATOM    146  CA  ARG A  24      19.067 111.272  -1.667  1.00 15.90           C  
ATOM    147  C   ARG A  24      19.798 111.136  -2.994  1.00 13.62           C  
ATOM    148  O   ARG A  24      20.975 110.751  -3.016  1.00 14.30           O  
ATOM    149  CB  ARG A  24      18.415 109.945  -1.239  1.00 16.42           C  
ATOM    150  CG  ARG A  24      17.343 109.402  -2.157  1.00 20.01           C  
ATOM    151  CD  ARG A  24      16.599 108.250  -1.454  1.00 21.65           C  
ATOM    152  NE  ARG A  24      15.793 108.758  -0.347  1.00 22.09           N  
ATOM    153  CZ  ARG A  24      15.053 107.999   0.461  1.00 23.73           C  
ATOM    154  NH1 ARG A  24      15.004 106.683   0.303  1.00 23.83           N  
ATOM    155  NH2 ARG A  24      14.338 108.575   1.422  1.00 22.23           N  
ATOM    156  N   ALA A  25      19.124 111.446  -4.097  1.00 13.14           N  
ATOM    157  CA  ALA A  25      19.764 111.371  -5.395  1.00 12.29           C  
ATOM    158  C   ALA A  25      20.834 112.448  -5.491  1.00 12.26           C  
ATOM    159  O   ALA A  25      21.962 112.184  -5.912  1.00 11.76           O  
ATOM    160  CB  ALA A  25      18.729 111.570  -6.529  1.00  9.59           C  
ATOM    161  N   ALA A  26      20.490 113.670  -5.097  1.00 12.30           N  
ATOM    162  CA  ALA A  26      21.420 114.791  -5.135  1.00 13.68           C  
ATOM    163  C   ALA A  26      22.589 114.598  -4.172  1.00 14.92           C  
ATOM    164  O   ALA A  26      23.701 115.079  -4.433  1.00 16.51           O  
ATOM    165  CB  ALA A  26      20.692 116.096  -4.822  1.00 13.63           C  
ATOM    166  N   TRP A  27      22.350 113.923  -3.066  1.00 11.34           N  
ATOM    167  CA  TRP A  27      23.413 113.672  -2.101  1.00 12.62           C  
ATOM    168  C   TRP A  27      24.435 112.710  -2.726  1.00 13.30           C  
ATOM    169  O   TRP A  27      25.636 112.930  -2.662  1.00 12.85           O  
ATOM    170  CB  TRP A  27      22.849 113.067  -0.803  1.00 12.88           C  
ATOM    171  CG  TRP A  27      23.879 112.304  -0.014  1.00 14.68           C  
ATOM    172  CD1 TRP A  27      25.018 112.816   0.561  1.00 15.59           C  
ATOM    173  CD2 TRP A  27      23.872 110.914   0.296  1.00 15.82           C  
ATOM    174  NE1 TRP A  27      25.704 111.816   1.202  1.00 16.04           N  
ATOM    175  CE2 TRP A  27      25.029 110.639   1.053  1.00 15.74           C  
ATOM    176  CE3 TRP A  27      22.992 109.860   0.000  1.00 16.25           C  
ATOM    177  CZ2 TRP A  27      25.333 109.354   1.520  1.00 16.31           C  
ATOM    178  CZ3 TRP A  27      23.293 108.578   0.469  1.00 18.23           C  
ATOM    179  CH2 TRP A  27      24.453 108.341   1.226  1.00 15.16           C  
HETATM  180  N   MSE A  28      23.930 111.638  -3.308  1.00 15.27           N  
HETATM  181  CA  MSE A  28      24.810 110.657  -3.939  1.00 17.22           C  
HETATM  182  C   MSE A  28      25.586 111.278  -5.089  1.00 15.41           C  
HETATM  183  O   MSE A  28      26.761 110.970  -5.280  1.00 17.43           O  
HETATM  184  CB  MSE A  28      23.988 109.474  -4.437  1.00 22.63           C  
HETATM  185  CG  MSE A  28      23.461 108.619  -3.309  1.00 31.65           C  
HETATM  186 SE   MSE A  28      22.183 107.338  -3.952  1.00 42.20          SE  
HETATM  187  CE  MSE A  28      20.957 107.368  -2.439  1.00 42.83           C  
ATOM    188  N   ALA A  29      24.930 112.153  -5.866  1.00 14.10           N  
ATOM    189  CA  ALA A  29      25.612 112.806  -6.969  1.00 14.88           C  
ATOM    190  C   ALA A  29      26.813 113.575  -6.443  1.00 14.70           C  
ATOM    191  O   ALA A  29      27.909 113.540  -7.026  1.00 14.54           O  
ATOM    192  CB  ALA A  29      24.648 113.779  -7.680  1.00 12.18           C  
ATOM    193  N   GLN A  30      26.626 114.286  -5.333  1.00 16.96           N  
ATOM    194  CA  GLN A  30      27.726 115.051  -4.743  1.00 16.83           C  
ATOM    195  C   GLN A  30      28.817 114.147  -4.185  1.00 16.12           C  
ATOM    196  O   GLN A  30      29.982 114.486  -4.277  1.00 15.19           O  
ATOM    197  CB  GLN A  30      27.178 115.971  -3.636  1.00 17.94           C  
ATOM    198  CG  GLN A  30      26.235 117.033  -4.164  1.00 20.53           C  
ATOM    199  CD  GLN A  30      25.584 117.855  -3.065  1.00 21.57           C  
ATOM    200  OE1 GLN A  30      26.207 118.753  -2.507  1.00 22.00           O  
ATOM    201  NE2 GLN A  30      24.344 117.527  -2.745  1.00 19.03           N  
ATOM    202  N   GLU A  31      28.429 113.009  -3.610  1.00 14.98           N  
ATOM    203  CA  GLU A  31      29.421 112.079  -3.073  1.00 15.47           C  
ATOM    204  C   GLU A  31      30.332 111.585  -4.203  1.00 17.42           C  
ATOM    205  O   GLU A  31      31.534 111.440  -4.031  1.00 17.24           O  
ATOM    206  CB  GLU A  31      28.736 110.866  -2.428  1.00 17.15           C  
ATOM    207  CG  GLU A  31      28.066 111.137  -1.092  1.00 18.07           C  
ATOM    208  CD  GLU A  31      29.057 111.266   0.070  1.00 20.30           C  
ATOM    209  OE1 GLU A  31      30.267 111.010  -0.132  1.00 22.42           O  
ATOM    210  OE2 GLU A  31      28.611 111.603   1.179  1.00 18.90           O  
ATOM    211  N   LEU A  32      29.744 111.330  -5.381  1.00 17.30           N  
ATOM    212  CA  LEU A  32      30.517 110.857  -6.510  1.00 17.17           C  
ATOM    213  C   LEU A  32      31.385 111.960  -7.112  1.00 16.02           C  
ATOM    214  O   LEU A  32      32.557 111.731  -7.435  1.00 15.16           O  
ATOM    215  CB  LEU A  32      29.597 110.293  -7.595  1.00 14.83           C  
ATOM    216  CG  LEU A  32      28.810 109.049  -7.217  1.00 16.04           C  
ATOM    217  CD1 LEU A  32      27.956 108.595  -8.404  1.00 17.27           C  
ATOM    218  CD2 LEU A  32      29.766 107.937  -6.802  1.00 19.17           C  
ATOM    219  N   LEU A  33      30.817 113.148  -7.265  1.00 16.09           N  
ATOM    220  CA  LEU A  33      31.577 114.234  -7.849  1.00 18.86           C  
ATOM    221  C   LEU A  33      32.652 114.778  -6.917  1.00 19.76           C  
ATOM    222  O   LEU A  33      33.706 115.239  -7.389  1.00 17.88           O  
ATOM    223  CB  LEU A  33      30.626 115.360  -8.297  1.00 14.84           C  
ATOM    224  CG  LEU A  33      29.865 115.019  -9.562  1.00 15.63           C  
ATOM    225  CD1 LEU A  33      28.684 115.973  -9.760  1.00 16.48           C  
ATOM    226  CD2 LEU A  33      30.817 115.077 -10.763  1.00 18.81           C  
ATOM    227  N   SER A  34      32.432 114.711  -5.616  1.00 19.11           N  
ATOM    228  CA  SER A  34      33.435 115.178  -4.666  1.00 23.00           C  
ATOM    229  C   SER A  34      34.585 114.169  -4.596  1.00 23.24           C  
ATOM    230  O   SER A  34      35.725 114.535  -4.310  1.00 23.96           O  
ATOM    231  CB  SER A  34      32.829 115.394  -3.272  1.00 22.01           C  
ATOM    232  OG  SER A  34      32.434 114.162  -2.689  1.00 28.45           O  
ATOM    233  N   THR A  35      34.275 112.907  -4.857  1.00 23.91           N  
ATOM    234  CA  THR A  35      35.290 111.849  -4.815  1.00 25.05           C  
ATOM    235  C   THR A  35      36.044 111.670  -6.124  1.00 24.24           C  
ATOM    236  O   THR A  35      37.270 111.556  -6.133  1.00 24.81           O  
ATOM    237  CB  THR A  35      34.659 110.489  -4.437  1.00 25.48           C  
ATOM    238  OG1 THR A  35      34.326 110.493  -3.045  1.00 29.61           O  
ATOM    239  CG2 THR A  35      35.623 109.341  -4.723  1.00 26.49           C  
ATOM    240  N   PHE A  36      35.328 111.641  -7.242  1.00 22.71           N  
ATOM    241  CA  PHE A  36      35.960 111.442  -8.534  1.00 22.02           C  
ATOM    242  C   PHE A  36      36.249 112.720  -9.309  1.00 23.31           C  
ATOM    243  O   PHE A  36      37.080 112.722 -10.213  1.00 24.45           O  
ATOM    244  CB  PHE A  36      35.093 110.511  -9.374  1.00 21.52           C  
ATOM    245  CG  PHE A  36      34.982 109.128  -8.802  1.00 19.64           C  
ATOM    246  CD1 PHE A  36      36.060 108.262  -8.830  1.00 21.68           C  
ATOM    247  CD2 PHE A  36      33.793 108.718  -8.211  1.00 19.77           C  
ATOM    248  CE1 PHE A  36      35.970 106.988  -8.271  1.00 21.35           C  
ATOM    249  CE2 PHE A  36      33.691 107.449  -7.639  1.00 20.22           C  
ATOM    250  CZ  PHE A  36      34.774 106.584  -7.664  1.00 21.39           C  
ATOM    251  N   GLY A  37      35.558 113.790  -8.947  1.00 24.18           N  
ATOM    252  CA  GLY A  37      35.772 115.060  -9.621  1.00 23.66           C  
ATOM    253  C   GLY A  37      35.684 114.999 -11.121  1.00 24.49           C  
ATOM    254  O   GLY A  37      34.746 114.428 -11.685  1.00 24.81           O  
ATOM    255  N   ALA A  38      36.685 115.577 -11.795  1.00 25.18           N  
ATOM    256  CA  ALA A  38      36.740 115.625 -13.249  1.00 26.16           C  
ATOM    257  C   ALA A  38      36.908 114.281 -13.946  1.00 26.73           C  
ATOM    258  O   ALA A  38      36.876 114.214 -15.179  1.00 25.10           O  
ATOM    259  CB  ALA A  38      37.841 116.592 -13.696  1.00 27.75           C  
ATOM    260  N   ASP A  39      37.097 113.201 -13.187  1.00 26.58           N  
ATOM    261  CA  ASP A  39      37.224 111.892 -13.810  1.00 27.95           C  
ATOM    262  C   ASP A  39      35.854 111.495 -14.379  1.00 25.54           C  
ATOM    263  O   ASP A  39      35.748 110.557 -15.146  1.00 25.83           O  
ATOM    264  CB  ASP A  39      37.671 110.829 -12.813  1.00 30.42           C  
ATOM    265  CG  ASP A  39      39.095 111.033 -12.360  1.00 35.29           C  
ATOM    266  OD1 ASP A  39      39.892 111.587 -13.143  1.00 36.81           O  
ATOM    267  OD2 ASP A  39      39.431 110.626 -11.231  1.00 37.47           O  
ATOM    268  N   LEU A  40      34.829 112.228 -13.971  1.00 23.72           N  
ATOM    269  CA  LEU A  40      33.487 111.971 -14.459  1.00 21.88           C  
ATOM    270  C   LEU A  40      33.086 113.079 -15.414  1.00 21.98           C  
ATOM    271  O   LEU A  40      33.393 114.250 -15.177  1.00 22.60           O  
ATOM    272  CB  LEU A  40      32.477 111.927 -13.303  1.00 19.76           C  
ATOM    273  CG  LEU A  40      32.676 110.915 -12.187  1.00 21.81           C  
ATOM    274  CD1 LEU A  40      31.525 111.066 -11.196  1.00 21.33           C  
ATOM    275  CD2 LEU A  40      32.722 109.493 -12.748  1.00 20.69           C  
ATOM    276  N   GLY A  41      32.414 112.729 -16.499  1.00 20.33           N  
ATOM    277  CA  GLY A  41      31.991 113.741 -17.441  1.00 21.54           C  
ATOM    278  C   GLY A  41      30.870 114.555 -16.815  1.00 23.24           C  
ATOM    279  O   GLY A  41      30.813 115.773 -16.947  1.00 21.39           O  
ATOM    280  N   GLU A  42      29.971 113.853 -16.123  1.00 22.81           N  
ATOM    281  CA  GLU A  42      28.860 114.514 -15.459  1.00 22.30           C  
ATOM    282  C   GLU A  42      28.027 113.514 -14.648  1.00 19.58           C  
ATOM    283  O   GLU A  42      28.202 112.293 -14.739  1.00 17.99           O  
ATOM    284  CB  GLU A  42      27.944 115.170 -16.486  1.00 23.92           C  
ATOM    285  CG  GLU A  42      27.307 114.174 -17.444  1.00 29.63           C  
ATOM    286  CD  GLU A  42      26.346 114.789 -18.422  1.00 32.24           C  
ATOM    287  OE1 GLU A  42      26.755 115.709 -19.168  1.00 33.29           O  
ATOM    288  OE2 GLU A  42      25.168 114.361 -18.460  1.00 34.32           O  
ATOM    289  N   VAL A  43      27.148 114.061 -13.819  1.00 18.84           N  
ATOM    290  CA  VAL A  43      26.235 113.267 -13.044  1.00 18.68           C  
ATOM    291  C   VAL A  43      24.900 113.940 -13.245  1.00 17.52           C  
ATOM    292  O   VAL A  43      24.735 115.112 -12.888  1.00 16.83           O  
ATOM    293  CB  VAL A  43      26.577 113.232 -11.548  1.00 17.56           C  
ATOM    294  CG1 VAL A  43      25.493 112.471 -10.794  1.00 14.58           C  
ATOM    295  CG2 VAL A  43      27.925 112.554 -11.331  1.00 14.07           C  
ATOM    296  N   ALA A  44      23.964 113.225 -13.848  1.00 16.25           N  
ATOM    297  CA  ALA A  44      22.645 113.789 -14.098  1.00 16.95           C  
ATOM    298  C   ALA A  44      21.580 113.273 -13.141  1.00 17.93           C  
ATOM    299  O   ALA A  44      21.528 112.081 -12.818  1.00 15.88           O  
ATOM    300  CB  ALA A  44      22.236 113.477 -15.521  1.00 16.45           C  
ATOM    301  N   LEU A  45      20.757 114.200 -12.674  1.00 17.30           N  
ATOM    302  CA  LEU A  45      19.653 113.895 -11.762  1.00 16.51           C  
ATOM    303  C   LEU A  45      18.446 113.850 -12.701  1.00 16.51           C  
ATOM    304  O   LEU A  45      18.065 114.869 -13.301  1.00 14.71           O  
ATOM    305  CB  LEU A  45      19.538 114.966 -10.683  1.00 15.24           C  
ATOM    306  CG  LEU A  45      20.756 115.036  -9.735  1.00 18.28           C  
ATOM    307  CD1 LEU A  45      20.780 116.326  -8.905  1.00 13.47           C  
ATOM    308  CD2 LEU A  45      20.731 113.815  -8.827  1.00 16.25           C  
ATOM    309  N   VAL A  46      17.861 112.664 -12.847  1.00 15.13           N  
ATOM    310  CA  VAL A  46      16.740 112.461 -13.761  1.00 14.11           C  
ATOM    311  C   VAL A  46      15.412 112.092 -13.081  1.00 15.71           C  
ATOM    312  O   VAL A  46      15.249 110.995 -12.547  1.00 15.69           O  
ATOM    313  CB  VAL A  46      17.108 111.312 -14.776  1.00 15.56           C  
ATOM    314  CG1 VAL A  46      16.009 111.141 -15.811  1.00 12.37           C  
ATOM    315  CG2 VAL A  46      18.453 111.656 -15.446  1.00 13.39           C  
ATOM    316  N   PRO A  47      14.445 113.032 -13.086  1.00 17.54           N  
ATOM    317  CA  PRO A  47      13.134 112.777 -12.474  1.00 16.92           C  
ATOM    318  C   PRO A  47      12.507 111.529 -13.059  1.00 17.81           C  
ATOM    319  O   PRO A  47      12.522 111.337 -14.278  1.00 19.85           O  
ATOM    320  CB  PRO A  47      12.346 114.043 -12.819  1.00 17.71           C  
ATOM    321  CG  PRO A  47      13.422 115.100 -12.891  1.00 18.53           C  
ATOM    322  CD  PRO A  47      14.522 114.391 -13.635  1.00 15.43           C  
ATOM    323  N   GLY A  48      11.941 110.684 -12.213  1.00 17.39           N  
ATOM    324  CA  GLY A  48      11.330 109.461 -12.675  1.00 19.03           C  
ATOM    325  C   GLY A  48       9.980 109.186 -12.052  1.00 20.75           C  
ATOM    326  O   GLY A  48       9.450 110.001 -11.294  1.00 18.18           O  
ATOM    327  N   THR A  49       9.425 108.022 -12.364  1.00 22.10           N  
ATOM    328  CA  THR A  49       8.107 107.614 -11.890  1.00 26.23           C  
ATOM    329  C   THR A  49       8.135 106.726 -10.647  1.00 26.23           C  
ATOM    330  O   THR A  49       9.176 106.489 -10.047  1.00 24.97           O  
ATOM    331  CB  THR A  49       7.345 106.895 -12.998  1.00 27.15           C  
ATOM    332  OG1 THR A  49       8.181 105.874 -13.579  1.00 30.92           O  
ATOM    333  CG2 THR A  49       6.950 107.876 -14.090  1.00 30.72           C  
ATOM    334  N   GLY A  50       6.946 106.224 -10.284  1.00 26.57           N  
ATOM    335  CA  GLY A  50       6.797 105.366  -9.113  1.00 26.88           C  
ATOM    336  C   GLY A  50       7.887 104.370  -8.778  1.00 26.88           C  
ATOM    337  O   GLY A  50       8.337 103.590  -9.609  1.00 28.78           O  
ATOM    338  N   GLY A  51       8.302 104.414  -7.504  1.00 27.25           N  
ATOM    339  CA  GLY A  51       9.309 103.499  -6.986  1.00 25.64           C  
ATOM    340  C   GLY A  51      10.602 103.341  -7.748  1.00 26.21           C  
ATOM    341  O   GLY A  51      11.344 102.381  -7.516  1.00 25.85           O  
ATOM    342  N   VAL A  52      10.910 104.265  -8.647  1.00 23.25           N  
ATOM    343  CA  VAL A  52      12.138 104.155  -9.411  1.00 22.38           C  
ATOM    344  C   VAL A  52      13.363 104.791  -8.741  1.00 21.89           C  
ATOM    345  O   VAL A  52      13.291 105.862  -8.155  1.00 19.27           O  
ATOM    346  CB  VAL A  52      11.985 104.814 -10.809  1.00 26.36           C  
ATOM    347  CG1 VAL A  52      13.310 104.752 -11.550  1.00 28.13           C  
ATOM    348  CG2 VAL A  52      10.893 104.110 -11.603  1.00 28.28           C  
ATOM    349  N   PHE A  53      14.478 104.079  -8.828  1.00 18.76           N  
ATOM    350  CA  PHE A  53      15.744 104.581  -8.326  1.00 18.84           C  
ATOM    351  C   PHE A  53      16.822 103.738  -8.968  1.00 19.19           C  
ATOM    352  O   PHE A  53      17.137 102.642  -8.502  1.00 20.22           O  
ATOM    353  CB  PHE A  53      15.872 104.496  -6.805  1.00 17.78           C  
ATOM    354  CG  PHE A  53      16.903 105.435  -6.254  1.00 17.01           C  
ATOM    355  CD1 PHE A  53      16.546 106.695  -5.816  1.00 16.68           C  
ATOM    356  CD2 PHE A  53      18.255 105.081  -6.270  1.00 17.78           C  
ATOM    357  CE1 PHE A  53      17.519 107.609  -5.387  1.00 18.36           C  
ATOM    358  CE2 PHE A  53      19.228 105.981  -5.842  1.00 17.09           C  
ATOM    359  CZ  PHE A  53      18.860 107.251  -5.403  1.00 17.83           C  
ATOM    360  N   ARG A  54      17.379 104.264 -10.054  1.00 20.43           N  
ATOM    361  CA  ARG A  54      18.392 103.563 -10.814  1.00 21.22           C  
ATOM    362  C   ARG A  54      19.599 104.460 -11.078  1.00 20.63           C  
ATOM    363  O   ARG A  54      19.474 105.673 -11.192  1.00 19.54           O  
ATOM    364  CB  ARG A  54      17.824 103.103 -12.169  1.00 22.35           C  
ATOM    365  CG  ARG A  54      16.594 102.209 -12.076  1.00 26.67           C  
ATOM    366  CD  ARG A  54      16.202 101.604 -13.408  1.00 26.93           C  
ATOM    367  NE  ARG A  54      15.418 102.585 -14.268  1.00 29.30           N  
ATOM    368  CZ  ARG A  54      14.113 102.587 -14.313  1.00 30.41           C  
ATOM    369  NH1 ARG A  54      13.353 101.750 -13.638  1.00 31.04           N  
ATOM    370  NH2 ARG A  54      13.456 103.445 -15.042  1.00 30.71           N  
ATOM    371  N   ILE A  55      20.757 103.837 -11.165  1.00 16.42           N  
ATOM    372  CA  ILE A  55      21.980 104.585 -11.439  1.00 17.57           C  
ATOM    373  C   ILE A  55      22.703 103.866 -12.571  1.00 18.86           C  
ATOM    374  O   ILE A  55      22.940 102.646 -12.511  1.00 17.19           O  
ATOM    375  CB  ILE A  55      22.879 104.677 -10.187  1.00 18.13           C  
ATOM    376  CG1 ILE A  55      22.082 105.354  -9.043  1.00 17.11           C  
ATOM    377  CG2 ILE A  55      24.142 105.468 -10.495  1.00 18.89           C  
ATOM    378  CD1 ILE A  55      22.851 105.552  -7.763  1.00 15.52           C  
ATOM    379  N   HIS A  56      23.017 104.607 -13.621  1.00 18.77           N  
ATOM    380  CA  HIS A  56      23.718 104.051 -14.776  1.00 20.36           C  
ATOM    381  C   HIS A  56      25.062 104.702 -14.987  1.00 19.44           C  
ATOM    382  O   HIS A  56      25.274 105.862 -14.606  1.00 18.74           O  
ATOM    383  CB  HIS A  56      22.870 104.213 -16.033  1.00 22.78           C  
ATOM    384  CG  HIS A  56      21.691 103.297 -16.068  1.00 27.57           C  
ATOM    385  ND1 HIS A  56      20.520 103.627 -16.834  1.00 30.82           N  
ATOM    386  CD2 HIS A  56      21.502 102.061 -15.456  1.00 31.40           C  
ATOM    387  CE1 HIS A  56      19.659 102.619 -16.682  1.00 31.87           C  
ATOM    388  NE2 HIS A  56      20.226 101.665 -15.874  1.00 32.06           N  
ATOM    389  N   TYR A  57      25.979 103.959 -15.587  1.00 20.20           N  
ATOM    390  CA  TYR A  57      27.324 104.440 -15.908  1.00 21.16           C  
ATOM    391  C   TYR A  57      27.427 104.241 -17.411  1.00 21.26           C  
ATOM    392  O   TYR A  57      27.662 103.128 -17.881  1.00 19.98           O  
ATOM    393  CB  TYR A  57      28.380 103.586 -15.184  1.00 21.61           C  
ATOM    394  CG  TYR A  57      29.797 104.031 -15.397  1.00 23.21           C  
ATOM    395  CD1 TYR A  57      30.483 103.758 -16.594  1.00 23.24           C  
ATOM    396  CD2 TYR A  57      30.496 104.712 -14.392  1.00 23.47           C  
ATOM    397  CE1 TYR A  57      31.801 104.144 -16.774  1.00 22.39           C  
ATOM    398  CE2 TYR A  57      31.811 105.101 -14.570  1.00 25.06           C  
ATOM    399  CZ  TYR A  57      32.463 104.826 -15.755  1.00 24.11           C  
ATOM    400  OH  TYR A  57      33.768 105.222 -15.918  1.00 26.92           O  
ATOM    401  N   ASN A  58      27.238 105.317 -18.156  1.00 20.50           N  
ATOM    402  CA  ASN A  58      27.258 105.265 -19.613  1.00 22.14           C  
ATOM    403  C   ASN A  58      26.185 104.253 -20.061  1.00 22.93           C  
ATOM    404  O   ASN A  58      26.447 103.405 -20.916  1.00 23.90           O  
ATOM    405  CB  ASN A  58      28.616 104.838 -20.166  1.00 21.50           C  
ATOM    406  CG  ASN A  58      29.641 105.965 -20.128  1.00 22.40           C  
ATOM    407  OD1 ASN A  58      29.296 107.140 -20.261  1.00 24.13           O  
ATOM    408  ND2 ASN A  58      30.915 105.607 -19.971  1.00 21.60           N  
ATOM    409  N   GLY A  59      25.002 104.336 -19.468  1.00 23.07           N  
ATOM    410  CA  GLY A  59      23.929 103.426 -19.825  1.00 22.53           C  
ATOM    411  C   GLY A  59      23.998 102.079 -19.152  1.00 23.63           C  
ATOM    412  O   GLY A  59      22.984 101.389 -19.008  1.00 25.60           O  
ATOM    413  N   ALA A  60      25.188 101.671 -18.734  1.00 25.41           N  
ATOM    414  CA  ALA A  60      25.365 100.386 -18.083  1.00 27.95           C  
ATOM    415  C   ALA A  60      24.779 100.446 -16.663  1.00 30.25           C  
ATOM    416  O   ALA A  60      24.904 101.445 -15.976  1.00 26.01           O  
ATOM    417  CB  ALA A  60      26.840 100.026 -18.026  1.00 25.42           C  
ATOM    418  N   PRO A  61      24.124  99.366 -16.248  1.00 32.87           N  
ATOM    419  CA  PRO A  61      23.513  99.290 -14.905  1.00 33.56           C  
ATOM    420  C   PRO A  61      24.580  99.349 -13.810  1.00 32.78           C  
ATOM    421  O   PRO A  61      25.592  98.660 -13.887  1.00 33.16           O  
ATOM    422  CB  PRO A  61      22.779  97.965 -14.938  1.00 36.09           C  
ATOM    423  CG  PRO A  61      23.629  97.145 -15.878  1.00 38.50           C  
ATOM    424  CD  PRO A  61      23.899  98.118 -16.975  1.00 35.25           C  
ATOM    425  N   LEU A  62      24.338 100.164 -12.785  1.00 30.14           N  
ATOM    426  CA  LEU A  62      25.274 100.311 -11.689  1.00 27.27           C  
ATOM    427  C   LEU A  62      24.503  99.995 -10.403  1.00 26.46           C  
ATOM    428  O   LEU A  62      25.028  99.378  -9.466  1.00 24.87           O  
ATOM    429  CB  LEU A  62      25.822 101.729 -11.683  1.00 29.65           C  
ATOM    430  CG  LEU A  62      27.131 102.007 -10.996  1.00 33.70           C  
ATOM    431  CD1 LEU A  62      27.629 103.291 -11.395  1.00 36.78           C  
ATOM    432  CD2 LEU A  62      26.950 102.028  -9.573  1.00 37.25           C  
ATOM    433  N   TRP A  63      23.243 100.409 -10.382  1.00 20.79           N  
ATOM    434  CA  TRP A  63      22.377 100.181  -9.241  1.00 20.10           C  
ATOM    435  C   TRP A  63      20.910 100.350  -9.649  1.00 19.50           C  
ATOM    436  O   TRP A  63      20.586 101.175 -10.510  1.00 16.97           O  
ATOM    437  CB  TRP A  63      22.726 101.134  -8.096  1.00 22.87           C  
ATOM    438  CG  TRP A  63      21.876 100.925  -6.868  1.00 24.16           C  
ATOM    439  CD1 TRP A  63      20.595 101.370  -6.670  1.00 21.79           C  
ATOM    440  CD2 TRP A  63      22.205 100.147  -5.716  1.00 24.39           C  
ATOM    441  NE1 TRP A  63      20.118 100.906  -5.460  1.00 24.09           N  
ATOM    442  CE2 TRP A  63      21.083 100.152  -4.852  1.00 24.66           C  
ATOM    443  CE3 TRP A  63      23.348  99.429  -5.326  1.00 24.81           C  
ATOM    444  CZ2 TRP A  63      21.069  99.477  -3.637  1.00 26.31           C  
ATOM    445  CZ3 TRP A  63      23.335  98.755  -4.104  1.00 26.10           C  
ATOM    446  CH2 TRP A  63      22.199  98.788  -3.274  1.00 26.39           C  
ATOM    447  N   ASP A  64      20.047  99.546  -9.041  1.00 19.70           N  
ATOM    448  CA  ASP A  64      18.624  99.597  -9.317  1.00 20.92           C  
ATOM    449  C   ASP A  64      17.920  99.056  -8.081  1.00 22.75           C  
ATOM    450  O   ASP A  64      18.153  97.916  -7.676  1.00 22.04           O  
ATOM    451  CB  ASP A  64      18.279  98.743 -10.533  1.00 19.36           C  
ATOM    452  CG  ASP A  64      16.870  98.934 -11.014  1.00 21.62           C  
ATOM    453  OD1 ASP A  64      15.954  99.058 -10.168  1.00 22.32           O  
ATOM    454  OD2 ASP A  64      16.646  98.965 -12.241  1.00 24.77           O  
ATOM    455  N   ARG A  65      17.075  99.879  -7.477  1.00 21.73           N  
ATOM    456  CA  ARG A  65      16.354  99.466  -6.279  1.00 25.05           C  
ATOM    457  C   ARG A  65      15.645  98.122  -6.497  1.00 25.65           C  
ATOM    458  O   ARG A  65      15.610  97.287  -5.602  1.00 22.19           O  
ATOM    459  CB  ARG A  65      15.340 100.552  -5.885  1.00 26.93           C  
ATOM    460  CG  ARG A  65      14.659 100.302  -4.555  1.00 34.33           C  
ATOM    461  CD  ARG A  65      13.592 101.329  -4.242  1.00 38.53           C  
ATOM    462  NE  ARG A  65      12.436 101.292  -5.186  1.00 42.57           N  
ATOM    463  CZ  ARG A  65      11.626 100.234  -5.292  1.00 44.65           C  
ATOM    464  NH1 ARG A  65      11.825  99.152  -4.564  1.00 45.72           N  
ATOM    465  NH2 ARG A  65      10.600 100.221  -6.117  1.00 45.49           N  
ATOM    466  N   GLU A  66      15.103  97.927  -7.691  1.00 28.78           N  
ATOM    467  CA  GLU A  66      14.395  96.698  -8.035  1.00 32.52           C  
ATOM    468  C   GLU A  66      15.290  95.454  -8.054  1.00 31.17           C  
ATOM    469  O   GLU A  66      14.823  94.337  -7.852  1.00 31.18           O  
ATOM    470  CB  GLU A  66      13.727  96.848  -9.396  1.00 36.44           C  
ATOM    471  CG  GLU A  66      12.455  97.684  -9.374  1.00 45.33           C  
ATOM    472  CD  GLU A  66      11.782  97.704 -10.702  1.00 48.75           C  
ATOM    473  OE1 GLU A  66      12.291  98.308 -11.660  1.00 51.10           O  
ATOM    474  OE2 GLU A  66      10.712  97.128 -10.909  1.00 51.52           O  
ATOM    475  N   VAL A  67      16.592  95.643  -8.292  1.00 29.00           N  
ATOM    476  CA  VAL A  67      17.507  94.518  -8.340  1.00 27.28           C  
ATOM    477  C   VAL A  67      18.318  94.373  -7.065  1.00 27.73           C  
ATOM    478  O   VAL A  67      18.322  93.327  -6.425  1.00 25.96           O  
ATOM    479  CB  VAL A  67      18.477  94.649  -9.523  1.00 26.99           C  
ATOM    480  CG1 VAL A  67      19.297  93.381  -9.659  1.00 27.59           C  
ATOM    481  CG2 VAL A  67      17.712  94.937 -10.800  1.00 25.80           C  
ATOM    482  N   ASP A  68      19.018  95.460  -6.688  1.00 27.16           N  
ATOM    483  CA  ASP A  68      19.838  95.450  -5.482  1.00 27.53           C  
ATOM    484  C   ASP A  68      19.025  95.613  -4.221  1.00 27.74           C  
ATOM    485  O   ASP A  68      19.486  95.279  -3.131  1.00 28.41           O  
ATOM    486  CB  ASP A  68      20.861  96.577  -5.555  1.00 28.72           C  
ATOM    487  CG  ASP A  68      21.743  96.500  -6.770  1.00 29.10           C  
ATOM    488  OD1 ASP A  68      22.630  95.624  -6.800  1.00 30.01           O  
ATOM    489  OD2 ASP A  68      21.521  97.280  -7.714  1.00 28.00           O  
ATOM    490  N   GLY A  69      17.811  96.135  -4.367  1.00 26.22           N  
ATOM    491  CA  GLY A  69      16.964  96.339  -3.209  1.00 25.39           C  
ATOM    492  C   GLY A  69      17.418  97.544  -2.407  1.00 25.59           C  
ATOM    493  O   GLY A  69      18.625  97.753  -2.221  1.00 24.65           O  
ATOM    494  N   GLY A  70      16.472  98.348  -1.951  1.00 25.39           N  
ATOM    495  CA  GLY A  70      16.801  99.525  -1.177  1.00 25.22           C  
ATOM    496  C   GLY A  70      17.637 100.564  -1.912  1.00 24.41           C  
ATOM    497  O   GLY A  70      17.610 100.646  -3.137  1.00 26.03           O  
ATOM    498  N   PHE A  71      18.385 101.345  -1.145  1.00 23.53           N  
ATOM    499  CA  PHE A  71      19.235 102.394  -1.703  1.00 22.34           C  
ATOM    500  C   PHE A  71      20.694 102.104  -1.397  1.00 23.62           C  
ATOM    501  O   PHE A  71      21.018 101.489  -0.385  1.00 23.03           O  
ATOM    502  CB  PHE A  71      18.800 103.742  -1.134  1.00 22.73           C  
ATOM    503  CG  PHE A  71      17.350 104.030  -1.356  1.00 22.73           C  
ATOM    504  CD1 PHE A  71      16.916 104.615  -2.541  1.00 22.24           C  
ATOM    505  CD2 PHE A  71      16.396 103.617  -0.434  1.00 21.72           C  
ATOM    506  CE1 PHE A  71      15.555 104.781  -2.804  1.00 23.01           C  
ATOM    507  CE2 PHE A  71      15.038 103.773  -0.682  1.00 24.48           C  
ATOM    508  CZ  PHE A  71      14.621 104.356  -1.877  1.00 22.13           C  
ATOM    509  N   PRO A  72      21.597 102.544  -2.275  1.00 21.95           N  
ATOM    510  CA  PRO A  72      23.031 102.321  -2.113  1.00 24.04           C  
ATOM    511  C   PRO A  72      23.718 103.129  -1.012  1.00 26.40           C  
ATOM    512  O   PRO A  72      23.385 104.292  -0.778  1.00 23.96           O  
ATOM    513  CB  PRO A  72      23.598 102.659  -3.478  1.00 22.87           C  
ATOM    514  CG  PRO A  72      22.705 103.802  -3.911  1.00 22.65           C  
ATOM    515  CD  PRO A  72      21.330 103.298  -3.514  1.00 21.80           C  
ATOM    516  N   GLU A  73      24.671 102.495  -0.335  1.00 29.92           N  
ATOM    517  CA  GLU A  73      25.443 103.164   0.695  1.00 33.44           C  
ATOM    518  C   GLU A  73      26.525 103.902  -0.099  1.00 29.67           C  
ATOM    519  O   GLU A  73      26.968 103.408  -1.132  1.00 24.35           O  
ATOM    520  CB  GLU A  73      26.055 102.080   1.578  1.00 43.38           C  
ATOM    521  CG  GLU A  73      26.877 102.589   2.659  1.00 64.65           C  
ATOM    522  CD  GLU A  73      27.575 101.460   3.365  1.00 75.10           C  
ATOM    523  OE1 GLU A  73      28.409 101.788   4.233  1.00 80.13           O  
ATOM    524  OE2 GLU A  73      27.322 100.267   3.091  1.00 79.93           O  
ATOM    525  N   ALA A  74      26.928 105.073   0.371  1.00 26.76           N  
ATOM    526  CA  ALA A  74      27.941 105.849  -0.344  1.00 25.58           C  
ATOM    527  C   ALA A  74      29.167 104.991  -0.658  1.00 24.79           C  
ATOM    528  O   ALA A  74      29.715 105.045  -1.754  1.00 24.44           O  
ATOM    529  CB  ALA A  74      28.345 107.074   0.476  1.00 26.14           C  
ATOM    530  N   LYS A  75      29.589 104.194   0.315  1.00 26.66           N  
ATOM    531  CA  LYS A  75      30.758 103.341   0.137  1.00 28.87           C  
ATOM    532  C   LYS A  75      30.607 102.386  -1.052  1.00 26.31           C  
ATOM    533  O   LYS A  75      31.517 102.269  -1.882  1.00 25.63           O  
ATOM    534  CB  LYS A  75      30.965 102.550   1.426  1.00 33.12           C  
ATOM    535  CG  LYS A  75      32.225 101.804   1.450  1.00 41.09           C  
ATOM    536  CD  LYS A  75      32.368 101.119   2.774  1.00 47.27           C  
ATOM    537  CE  LYS A  75      33.612 100.336   2.772  1.00 50.13           C  
ATOM    538  NZ  LYS A  75      33.785  99.596   4.042  1.00 52.90           N  
ATOM    539  N   VAL A  76      29.462 101.715  -1.144  1.00 23.90           N  
ATOM    540  CA  VAL A  76      29.224 100.783  -2.233  1.00 21.83           C  
ATOM    541  C   VAL A  76      29.142 101.459  -3.601  1.00 22.51           C  
ATOM    542  O   VAL A  76      29.720 100.986  -4.576  1.00 21.52           O  
ATOM    543  CB  VAL A  76      27.918  99.990  -2.005  1.00 21.05           C  
ATOM    544  CG1 VAL A  76      27.596  99.141  -3.229  1.00 20.23           C  
ATOM    545  CG2 VAL A  76      28.067  99.115  -0.776  1.00 19.76           C  
ATOM    546  N   LEU A  77      28.405 102.562  -3.662  1.00 22.93           N  
ATOM    547  CA  LEU A  77      28.258 103.311  -4.911  1.00 23.72           C  
ATOM    548  C   LEU A  77      29.619 103.709  -5.461  1.00 23.13           C  
ATOM    549  O   LEU A  77      29.870 103.562  -6.661  1.00 23.07           O  
ATOM    550  CB  LEU A  77      27.411 104.559  -4.671  1.00 24.87           C  
ATOM    551  CG  LEU A  77      27.102 105.378  -5.926  1.00 27.27           C  
ATOM    552  CD1 LEU A  77      26.258 104.545  -6.869  1.00 27.64           C  
ATOM    553  CD2 LEU A  77      26.375 106.654  -5.550  1.00 28.93           C  
ATOM    554  N   LYS A  78      30.483 104.219  -4.599  1.00 22.59           N  
ATOM    555  CA  LYS A  78      31.828 104.646  -5.006  1.00 21.91           C  
ATOM    556  C   LYS A  78      32.648 103.480  -5.548  1.00 22.69           C  
ATOM    557  O   LYS A  78      33.375 103.632  -6.533  1.00 20.69           O  
ATOM    558  CB  LYS A  78      32.569 105.277  -3.832  1.00 20.22           C  
ATOM    559  CG  LYS A  78      32.054 106.640  -3.432  1.00 21.40           C  
ATOM    560  CD  LYS A  78      32.680 107.096  -2.127  1.00 23.75           C  
ATOM    561  CE  LYS A  78      32.111 108.423  -1.666  1.00 25.74           C  
ATOM    562  NZ  LYS A  78      32.510 108.740  -0.264  1.00 27.86           N  
ATOM    563  N   GLN A  79      32.550 102.322  -4.899  1.00 24.28           N  
ATOM    564  CA  GLN A  79      33.289 101.150  -5.343  1.00 25.93           C  
ATOM    565  C   GLN A  79      32.798 100.674  -6.706  1.00 24.33           C  
ATOM    566  O   GLN A  79      33.597 100.312  -7.573  1.00 25.03           O  
ATOM    567  CB  GLN A  79      33.160 100.013  -4.328  1.00 28.38           C  
ATOM    568  CG  GLN A  79      33.671 100.383  -2.948  1.00 34.76           C  
ATOM    569  CD  GLN A  79      33.720  99.200  -1.997  1.00 37.41           C  
ATOM    570  OE1 GLN A  79      32.733  98.491  -1.821  1.00 39.10           O  
ATOM    571  NE2 GLN A  79      34.877  98.994  -1.376  1.00 38.87           N  
ATOM    572  N   ARG A  80      31.485 100.682  -6.898  1.00 22.33           N  
ATOM    573  CA  ARG A  80      30.906 100.241  -8.164  1.00 22.57           C  
ATOM    574  C   ARG A  80      31.303 101.169  -9.320  1.00 22.45           C  
ATOM    575  O   ARG A  80      31.531 100.710 -10.431  1.00 24.18           O  
ATOM    576  CB  ARG A  80      29.385 100.123  -8.054  1.00 22.25           C  
ATOM    577  CG  ARG A  80      28.922  98.966  -7.164  1.00 20.44           C  
ATOM    578  CD  ARG A  80      27.480  98.574  -7.442  1.00 21.32           C  
ATOM    579  NE  ARG A  80      27.006  97.543  -6.524  1.00 22.38           N  
ATOM    580  CZ  ARG A  80      25.804  96.976  -6.582  1.00 22.16           C  
ATOM    581  NH1 ARG A  80      24.940  97.334  -7.517  1.00 20.29           N  
ATOM    582  NH2 ARG A  80      25.463  96.059  -5.689  1.00 20.98           N  
ATOM    583  N   VAL A  81      31.369 102.465  -9.047  1.00 21.74           N  
ATOM    584  CA  VAL A  81      31.764 103.414 -10.083  1.00 21.84           C  
ATOM    585  C   VAL A  81      33.257 103.202 -10.347  1.00 23.65           C  
ATOM    586  O   VAL A  81      33.701 103.230 -11.496  1.00 22.78           O  
ATOM    587  CB  VAL A  81      31.527 104.875  -9.627  1.00 20.64           C  
ATOM    588  CG1 VAL A  81      32.201 105.821 -10.614  1.00 19.93           C  
ATOM    589  CG2 VAL A  81      30.034 105.162  -9.567  1.00 16.91           C  
ATOM    590  N   ARG A  82      34.010 102.968  -9.298  1.00 26.29           N  
ATOM    591  CA  ARG A  82      35.449 102.723  -9.432  1.00 29.89           C  
ATOM    592  C   ARG A  82      35.681 101.533 -10.351  1.00 29.77           C  
ATOM    593  O   ARG A  82      36.590 101.551 -11.184  1.00 28.86           O  
ATOM    594  CB  ARG A  82      36.049 102.428  -8.067  1.00 33.08           C  
ATOM    595  CG  ARG A  82      37.525 102.719  -7.982  1.00 42.20           C  
ATOM    596  CD  ARG A  82      37.931 102.884  -6.521  1.00 46.64           C  
ATOM    597  NE  ARG A  82      37.360 104.118  -5.976  1.00 50.05           N  
ATOM    598  CZ  ARG A  82      37.103 104.293  -4.671  1.00 51.45           C  
ATOM    599  NH1 ARG A  82      37.357 103.311  -3.823  1.00 52.27           N  
ATOM    600  NH2 ARG A  82      36.590 105.425  -4.225  1.00 51.43           N  
ATOM    601  N   ASP A  83      34.870 100.488 -10.179  1.00 29.27           N  
ATOM    602  CA  ASP A  83      34.948  99.267 -11.015  1.00 30.35           C  
ATOM    603  C   ASP A  83      34.944  99.608 -12.488  1.00 31.70           C  
ATOM    604  O   ASP A  83      35.667  99.000 -13.277  1.00 30.72           O  
ATOM    605  CB  ASP A  83      33.814  98.315 -10.744  1.00 31.50           C  
ATOM    606  CG  ASP A  83      33.883  97.601  -9.428  1.00 33.94           C  
ATOM    607  OD1 ASP A  83      32.931  96.874  -9.061  1.00 36.87           O  
ATOM    608  OD2 ASP A  83      34.911  97.777  -8.748  1.00 35.95           O  
ATOM    609  N   HIS A  84      34.072 100.540 -12.859  1.00 31.00           N  
ATOM    610  CA  HIS A  84      33.878 100.933 -14.270  1.00 32.36           C  
ATOM    611  C   HIS A  84      34.874 101.930 -14.725  1.00 33.30           C  
ATOM    612  O   HIS A  84      35.271 101.989 -15.898  1.00 34.63           O  
ATOM    613  CB  HIS A  84      32.492 101.521 -14.510  1.00 32.02           C  
ATOM    614  CG  HIS A  84      31.375 100.541 -14.318  1.00 32.97           C  
ATOM    615  ND1 HIS A  84      30.752  99.887 -15.377  1.00 33.16           N  
ATOM    616  CD2 HIS A  84      30.747 100.104 -13.190  1.00 33.31           C  
ATOM    617  CE1 HIS A  84      29.813  99.085 -14.898  1.00 33.52           C  
ATOM    618  NE2 HIS A  84      29.783  99.195 -13.564  1.00 32.83           N  
ATOM    619  N   LEU A  85      35.290 102.841 -13.820  1.00 34.72           N  
ATOM    620  CA  LEU A  85      36.238 103.845 -14.171  1.00 36.96           C  
ATOM    621  C   LEU A  85      37.639 103.228 -14.329  1.00 38.30           C  
ATOM    622  O   LEU A  85      37.874 102.130 -13.776  1.00 40.55           O  
ATOM    623  CB  LEU A  85      36.250 104.908 -13.088  1.00 36.92           C  
ATOM    624  CG  LEU A  85      36.748 106.303 -13.485  1.00 38.13           C  
ATOM    625  CD1 LEU A  85      35.917 106.848 -14.640  1.00 37.59           C  
ATOM    626  CD2 LEU A  85      36.646 107.228 -12.279  1.00 37.71           C  
TER     627      LEU A  85                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
