
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  275 ( 2182),  selected  275 , name 3bqr_A
# Molecule2: number of CA atoms  265 ( 2104),  selected  265 , name T0456.pdb
# PARAMETERS: 3bqr_A.T0456.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     7_A      Y      15           -
LGA    -       -      F      16           -
LGA    -       -      Q      17           -
LGA    M     8_A      G      18          6.159
LGA    V     9_A      T      19          3.700
LGA    E    10_A      F      20          1.803
LGA    D    11_A      A      21          3.150
LGA    -       -      E      22           -
LGA    H    12_A      R      23          2.144
LGA    Y    13_A      Y      24          1.244
LGA    E    14_A      N      25          1.691
LGA    M    15_A      I      26          0.671
LGA    G    16_A      V      27          2.779
LGA    E    17_A      C      28          2.448
LGA    E    18_A      M      29          2.146
LGA    L    19_A      L      30          1.853
LGA    G    20_A      G      31          2.261
LGA    S    21_A      K      32          1.911
LGA    G    22_A      G      33          4.232
LGA    Q    23_A      S      34           #
LGA    F    24_A      F      35          3.950
LGA    A    25_A      G      36          1.607
LGA    I    26_A      E      37          1.173
LGA    V    27_A      V      38          0.640
LGA    R    28_A      L      39          0.964
LGA    K    29_A      K      40          1.132
LGA    C    30_A      C      41          1.212
LGA    R    31_A      K      42          1.353
LGA    Q    32_A      D      43          1.484
LGA    K    33_A      R      44          2.294
LGA    G    34_A      I      45          2.451
LGA    T    35_A      T      46          2.492
LGA    G    36_A      Q      47          2.370
LGA    K    37_A      Q      48          1.541
LGA    E    38_A      E      49          1.211
LGA    Y    39_A      Y      50          0.767
LGA    A    40_A      A      51          0.563
LGA    A    41_A      V      52          0.843
LGA    K    42_A      K      53          0.306
LGA    F    43_A      V      54          0.441
LGA    I    44_A      I      55          0.614
LGA    K    45_A      N      56          0.178
LGA    K    46_A      K      57          0.743
LGA    R    47_A      A      58          1.537
LGA    R    48_A      -       -           -
LGA    L    49_A      -       -           -
LGA    S    50_A      -       -           -
LGA    S    51_A      -       -           -
LGA    S    52_A      -       -           -
LGA    R    53_A      -       -           -
LGA    R    54_A      -       -           -
LGA    G    55_A      S      59          2.770
LGA    V    56_A      A      60          2.474
LGA    S    57_A      K      61          3.812
LGA    R    58_A      N      62          4.443
LGA    -       -      K      63           -
LGA    -       -      D      64           -
LGA    -       -      T      65           -
LGA    -       -      S      66           -
LGA    E    59_A      T      67           #
LGA    E    60_A      -       -           -
LGA    I    61_A      -       -           -
LGA    E    62_A      I      68          0.931
LGA    R    63_A      L      69           #
LGA    E    64_A      -       -           -
LGA    V    65_A      R      70           #
LGA    N    66_A      E      71          1.779
LGA    I    67_A      V      72          4.396
LGA    -       -      E      73           -
LGA    -       -      L      74           -
LGA    L    68_A      L      75          2.418
LGA    R    69_A      K      76          2.102
LGA    E    70_A      K      77          3.730
LGA    I    71_A      L      78          2.109
LGA    R    72_A      D      79          1.408
LGA    H    73_A      H      80          1.088
LGA    P    74_A      P      81          1.267
LGA    N    75_A      N      82          0.918
LGA    I    76_A      I      83          0.733
LGA    I    77_A      M      84          1.049
LGA    T    78_A      K      85          0.941
LGA    L    79_A      L      86          1.521
LGA    H    80_A      F      87          1.840
LGA    D    81_A      E      88          2.501
LGA    I    82_A      I      89          2.361
LGA    F    83_A      L      90          1.448
LGA    E    84_A      E      91          0.665
LGA    N    85_A      D      92          0.780
LGA    K    86_A      S      93          1.144
LGA    T    87_A      S      94          0.641
LGA    D    88_A      S      95          0.456
LGA    V    89_A      F      96          0.695
LGA    V    90_A      Y      97          0.504
LGA    L    91_A      I      98          0.890
LGA    I    92_A      V      99          0.934
LGA    L    93_A      G     100          0.656
LGA    E    94_A      E     101          0.850
LGA    L    95_A      L     102          0.379
LGA    V    96_A      Y     103          1.027
LGA    S    97_A      T     104          1.146
LGA    G    98_A      -       -           -
LGA    G    99_A      G     106          1.045
LGA    E   100_A      E     107          1.012
LGA    L   101_A      L     108          0.845
LGA    F   102_A      F     109          0.821
LGA    D   103_A      D     110          1.018
LGA    F   104_A      E     111          1.526
LGA    L   105_A      I     112          1.696
LGA    A   106_A      I     113          1.330
LGA    E   107_A      K     114          1.192
LGA    K   108_A      R     115          1.224
LGA    E   109_A      K     116          1.119
LGA    S   110_A      R     117          1.124
LGA    L   111_A      F     118          0.771
LGA    T   112_A      S     119          0.605
LGA    E   113_A      E     120          0.682
LGA    D   114_A      H     121          0.698
LGA    E   115_A      D     122          0.578
LGA    A   116_A      A     123          0.529
LGA    T   117_A      A     124          0.706
LGA    Q   118_A      R     125          0.629
LGA    F   119_A      I     126          0.773
LGA    L   120_A      I     127          1.031
LGA    K   121_A      K     128          1.036
LGA    Q   122_A      Q     129          0.588
LGA    I   123_A      V     130          0.619
LGA    L   124_A      F     131          0.565
LGA    D   125_A      S     132          0.631
LGA    G   126_A      G     133          0.507
LGA    V   127_A      I     134          0.590
LGA    H   128_A      T     135          0.596
LGA    Y   129_A      Y     136          0.516
LGA    L   130_A      M     137          0.967
LGA    H   131_A      H     138          0.989
LGA    S   132_A      K     139          0.653
LGA    K   133_A      H     140          0.867
LGA    R   134_A      N     141          1.372
LGA    I   135_A      I     142          1.457
LGA    A   136_A      V     143          1.385
LGA    H   137_A      H     144          1.124
LGA    F   138_A      R     145          0.882
LGA    D   139_A      D     146          0.881
LGA    L   140_A      L     147          0.881
LGA    K   141_A      K     148          1.089
LGA    P   142_A      P     149          0.659
LGA    E   143_A      E     150          0.763
LGA    N   144_A      N     151          0.786
LGA    I   145_A      I     152          0.839
LGA    M   146_A      L     153          1.218
LGA    L   147_A      L     154          1.685
LGA    L   148_A      -       -           -
LGA    D   149_A      -       -           -
LGA    K   150_A      -       -           -
LGA    N   151_A      K     159          2.783
LGA    V   152_A      D     160          1.735
LGA    P   153_A      -       -           -
LGA    N   154_A      -       -           -
LGA    P   155_A      C     161          1.472
LGA    R   156_A      D     162          0.791
LGA    I   157_A      I     163          1.272
LGA    K   158_A      K     164          1.161
LGA    L   159_A      I     165          0.982
LGA    I   160_A      I     166          0.950
LGA    D   161_A      D     167          1.903
LGA    F   162_A      F     168          3.364
LGA    -       -      G     169           -
LGA    -       -      L     170           -
LGA    G   163_A      S     171          1.922
LGA    I   164_A      T     172          3.377
LGA    A   165_A      C     173           #
LGA    H   166_A      F     174           -
LGA    K   167_A      Q     175           -
LGA    I   168_A      Q     176           -
LGA    E   169_A      N     177           -
LGA    A   170_A      T     178           -
LGA    G   171_A      K     179           -
LGA    N   172_A      M     180           -
LGA    N   176_A      K     181           -
LGA    I   177_A      D     182           -
LGA    F   178_A      R     183           -
LGA    G   179_A      I     184           -
LGA    T   180_A      G     185           -
LGA    P   181_A      T     186           -
LGA    E   182_A      A     187           -
LGA    F   183_A      Y     188           -
LGA    V   184_A      Y     189           -
LGA    A   185_A      I     190           -
LGA    P   186_A      A     191           -
LGA    E   187_A      P     192           -
LGA    I   188_A      E     193           -
LGA    V   189_A      V     194           -
LGA    N   190_A      L     195           -
LGA    Y   191_A      R     196           -
LGA    E   192_A      -       -           -
LGA    P   193_A      G     197           #
LGA    L   194_A      T     198          3.494
LGA    -       -      Y     199           -
LGA    G   195_A      D     200          0.925
LGA    L   196_A      E     201          1.071
LGA    E   197_A      K     202          1.046
LGA    A   198_A      C     203          0.941
LGA    D   199_A      D     204          0.979
LGA    M   200_A      V     205          1.060
LGA    W   201_A      W     206          0.796
LGA    S   202_A      S     207          0.851
LGA    I   203_A      A     208          1.252
LGA    G   204_A      G     209          0.797
LGA    V   205_A      V     210          0.448
LGA    I   206_A      I     211          0.869
LGA    T   207_A      L     212          0.468
LGA    Y   208_A      Y     213          0.357
LGA    I   209_A      I     214          0.492
LGA    L   210_A      L     215          0.780
LGA    L   211_A      L     216          0.832
LGA    S   212_A      S     217          1.488
LGA    G   213_A      G     218          1.320
LGA    A   214_A      T     219          0.735
LGA    S   215_A      P     220          1.042
LGA    P   216_A      P     221          1.037
LGA    F   217_A      F     222          0.278
LGA    L   218_A      Y     223          1.748
LGA    G   219_A      G     224          1.011
LGA    E   220_A      K     225          1.636
LGA    T   221_A      N     226          1.844
LGA    K   222_A      E     227          0.974
LGA    Q   223_A      Y     228          1.141
LGA    E   224_A      D     229          1.059
LGA    T   225_A      I     230          0.676
LGA    L   226_A      L     231          0.772
LGA    T   227_A      K     232          0.911
LGA    N   228_A      R     233          0.479
LGA    I   229_A      V     234          0.594
LGA    S   230_A      E     235          1.264
LGA    A   231_A      T     236          0.916
LGA    V   232_A      G     237          1.512
LGA    N   233_A      K     238          2.328
LGA    Y   234_A      Y     239          1.566
LGA    D   235_A      A     240          1.153
LGA    F   236_A      F     241          1.718
LGA    D   237_A      D     242          3.415
LGA    E   238_A      L     243          2.679
LGA    E   239_A      P     244          3.558
LGA    Y   240_A      Q     245          2.179
LGA    F   241_A      W     246          1.625
LGA    S   242_A      R     247          2.206
LGA    N   243_A      T     248          1.611
LGA    T   244_A      I     249          0.868
LGA    S   245_A      S     250          0.847
LGA    E   246_A      D     251          0.926
LGA    L   247_A      D     252          0.663
LGA    A   248_A      A     253          0.543
LGA    K   249_A      K     254          0.688
LGA    D   250_A      D     255          0.767
LGA    F   251_A      L     256          0.549
LGA    I   252_A      I     257          0.355
LGA    R   253_A      R     258          0.748
LGA    R   254_A      K     259          0.980
LGA    L   255_A      M     260          0.970
LGA    L   256_A      L     261          0.800
LGA    V   257_A      T     262          1.318
LGA    K   258_A      F     263          1.109
LGA    D   259_A      H     264          0.954
LGA    P   260_A      P     265          0.985
LGA    K   261_A      S     266          1.211
LGA    R   262_A      L     267          1.145
LGA    R   263_A      R     268          0.961
LGA    M   264_A      I     269          0.990
LGA    T   265_A      T     270          1.101
LGA    I   266_A      A     271          1.452
LGA    A   267_A      T     272          2.087
LGA    Q   268_A      Q     273          1.674
LGA    S   269_A      C     274          1.524
LGA    L   270_A      L     275          1.999
LGA    E   271_A      E     276          2.144
LGA    H   272_A      H     277          1.190
LGA    S   273_A      P     278          0.737
LGA    W   274_A      W     279          0.332
LGA    I   275_A      I     280          0.988
LGA    K   276_A      Q     281          1.488
LGA    A   277_A      K     282          1.202
LGA    I   278_A      Y     283          4.443
LGA    R   279_A      S     284          4.814
LGA    R   280_A      -       -           -
LGA    R   281_A      -       -           -
LGA    N   282_A      -       -           -
LGA    V   283_A      -       -           -
LGA    R   284_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  275  265    5.0    223    1.66    39.01     78.269    12.686

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.385218 * X  +  -0.798416 * Y  +  -0.462752 * Z  +  66.821075
  Y_new =   0.018158 * X  +   0.494796 * Y  +  -0.868819 * Z  +  -5.400375
  Z_new =   0.922647 * X  +  -0.343087 * Y  +  -0.176107 * Z  +   7.873749 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.045028    1.096565  [ DEG:  -117.1715     62.8285 ]
  Theta =  -1.174889   -1.966704  [ DEG:   -67.3162   -112.6838 ]
  Phi   =   3.094492   -0.047101  [ DEG:   177.3013     -2.6987 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bqr_A                                        
REMARK     2: T0456.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bqr_A.T0456.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  275  265   5.0  223   1.66   39.01  78.269
REMARK  ---------------------------------------------------------- 
MOLECULE 3bqr_A
HEADER    TRANSFERASE                             20-DEC-07   3BQR              
TITLE     CRYSTAL STRUCTURE OF HUMAN DEATH ASSOCIATED PROTEIN KINASE            
TITLE    2 3 (DAPK3) IN COMPLEX WITH AN IMIDAZO-PYRIDAZINE LIGAND               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEATH-ASSOCIATED PROTEIN KINASE 3;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PROTEIN KINASE DOMAIN: RESIDUES 9-289;                     
COMPND   5 SYNONYM: DAP KINASE 3, DAP-LIKE KINASE, DLK, ZIP-KINASE;             
COMPND   6 EC: 2.7.11.1;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DAPK3, ZIPK;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)(R3);                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    DEATH ASSOCIATED KINASE, DAPK3, ZIP KINASE, ZIPK, DAP                 
KEYWDS   2 KINASE 3, DAP LIKE KINASE, DLK, STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, SGC, APOPTOSIS, ATP-BINDING, CHROMATIN                   
KEYWDS   4 REGULATOR, CYTOPLASM, NUCLEOTIDE-BINDING, NUCLEUS,                   
KEYWDS   5 SERINE/THREONINE-PROTEIN KINASE, TRANSFERASE                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.FILIPPAKOPOULOS,P.RELLOS,O.FEDOROV,F.NIESEN,A.C.W.PIKE,             
AUTHOR   2 E.S.PILKA,F.VON DELFT,C.H.ARROWSMITH,A.M.EDWARDS,J.WEIGELT,          
AUTHOR   3 S.KNAPP,STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
REVDAT   1   26-FEB-08 3BQR    0                                                
JRNL        AUTH   P.FILIPPAKOPOULOS,P.RELLOS,O.FEDOROV,F.NIESEN,               
JRNL        AUTH 2 A.C.W.PIKE,E.S.PILKA,F.VON DELFT,C.H.ARROWSMITH,             
JRNL        AUTH 3 A.M.EDWARDS,J.WEIGELT,S.KNAPP                                
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN DEATH ASSOCIATED                  
JRNL        TITL 2 PROTEIN KINASE 3 (DAPK3) IN COMPLEX WITH AN                  
JRNL        TITL 3 IMIDAZO-PYRIDAZINE LIGAND.                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  3BQR A    9   289  UNP    O43293   DAPK3_HUMAN      9    289             
SEQRES   1 A  283  SER MET VAL GLU ASP HIS TYR GLU MET GLY GLU GLU LEU          
SEQRES   2 A  283  GLY SER GLY GLN PHE ALA ILE VAL ARG LYS CYS ARG GLN          
SEQRES   3 A  283  LYS GLY THR GLY LYS GLU TYR ALA ALA LYS PHE ILE LYS          
SEQRES   4 A  283  LYS ARG ARG LEU SER SER SER ARG ARG GLY VAL SER ARG          
SEQRES   5 A  283  GLU GLU ILE GLU ARG GLU VAL ASN ILE LEU ARG GLU ILE          
SEQRES   6 A  283  ARG HIS PRO ASN ILE ILE THR LEU HIS ASP ILE PHE GLU          
SEQRES   7 A  283  ASN LYS THR ASP VAL VAL LEU ILE LEU GLU LEU VAL SER          
SEQRES   8 A  283  GLY GLY GLU LEU PHE ASP PHE LEU ALA GLU LYS GLU SER          
SEQRES   9 A  283  LEU THR GLU ASP GLU ALA THR GLN PHE LEU LYS GLN ILE          
SEQRES  10 A  283  LEU ASP GLY VAL HIS TYR LEU HIS SER LYS ARG ILE ALA          
SEQRES  11 A  283  HIS PHE ASP LEU LYS PRO GLU ASN ILE MET LEU LEU ASP          
SEQRES  12 A  283  LYS ASN VAL PRO ASN PRO ARG ILE LYS LEU ILE ASP PHE          
SEQRES  13 A  283  GLY ILE ALA HIS LYS ILE GLU ALA GLY ASN GLU PHE LYS          
SEQRES  14 A  283  ASN ILE PHE GLY THR PRO GLU PHE VAL ALA PRO GLU ILE          
SEQRES  15 A  283  VAL ASN TYR GLU PRO LEU GLY LEU GLU ALA ASP MET TRP          
SEQRES  16 A  283  SER ILE GLY VAL ILE THR TYR ILE LEU LEU SER GLY ALA          
SEQRES  17 A  283  SER PRO PHE LEU GLY GLU THR LYS GLN GLU THR LEU THR          
SEQRES  18 A  283  ASN ILE SER ALA VAL ASN TYR ASP PHE ASP GLU GLU TYR          
SEQRES  19 A  283  PHE SER ASN THR SER GLU LEU ALA LYS ASP PHE ILE ARG          
SEQRES  20 A  283  ARG LEU LEU VAL LYS ASP PRO LYS ARG ARG MET THR ILE          
SEQRES  21 A  283  ALA GLN SER LEU GLU HIS SER TRP ILE LYS ALA ILE ARG          
SEQRES  22 A  283  ARG ARG ASN VAL ARG GLY GLU ASP SER GLY                      
HET    4RB  A 401      24                                                       
HET    PGO  A 501       5                                                       
HET    PGO  A 502       5                                                       
HET    GOL  A 503       6                                                       
HETNAM     4RB 4-(6-{[(1R)-1-(HYDROXYMETHYL)PROPYL]AMINO}IMIDAZO[1,2-           
HETNAM   2 4RB  B]PYRIDAZIN-3-YL)BENZOIC ACID                                   
HETNAM     PGO S-1,2-PROPANEDIOL                                                
HETNAM     GOL GLYCEROL                                                         
FORMUL   2  4RB    C17 H18 N4 O3                                                
FORMUL   3  PGO    2(C3 H8 O2)                                                  
FORMUL   5  GOL    C3 H8 O3                                                     
FORMUL   6  HOH   *304(H2 O)                                                    
CRYST1   83.533   83.533  113.693  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   SER A   7       0.949  -6.191 -30.675  1.00 70.59           N  
ATOM      2  CA  SER A   7       0.017  -5.159 -30.128  1.00 70.61           C  
ATOM      3  C   SER A   7      -0.282  -5.411 -28.651  1.00 68.44           C  
ATOM      4  O   SER A   7      -0.132  -4.507 -27.819  1.00 71.39           O  
ATOM      5  CB  SER A   7      -1.288  -5.146 -30.928  1.00 70.96           C  
ATOM      6  OG  SER A   7      -2.081  -4.028 -30.579  1.00 71.25           O  
ATOM      7  N   MET A   8      -0.720  -6.635 -28.342  1.00 61.15           N  
ATOM      8  CA  MET A   8      -0.877  -7.099 -26.954  1.00 55.77           C  
ATOM      9  C   MET A   8       0.526  -7.258 -26.365  1.00 42.27           C  
ATOM     10  O   MET A   8       1.374  -7.922 -26.978  1.00 38.66           O  
ATOM     11  CB  MET A   8      -1.595  -8.455 -26.938  1.00 58.18           C  
ATOM     12  CG  MET A   8      -2.550  -8.691 -25.796  1.00 66.47           C  
ATOM     13  SD  MET A   8      -3.594 -10.145 -26.089  1.00 92.59           S  
ATOM     14  CE  MET A   8      -2.528 -11.502 -25.572  1.00 67.93           C  
ATOM     15  N   VAL A   9       0.785  -6.646 -25.207  1.00 40.16           N  
ATOM     16  CA  VAL A   9       2.101  -6.779 -24.540  1.00 34.97           C  
ATOM     17  C   VAL A   9       2.484  -8.247 -24.325  1.00 34.58           C  
ATOM     18  O   VAL A   9       3.648  -8.620 -24.506  1.00 30.04           O  
ATOM     19  CB  VAL A   9       2.168  -6.012 -23.199  1.00 37.60           C  
ATOM     20  CG1 VAL A   9       3.497  -6.311 -22.438  1.00 27.76           C  
ATOM     21  CG2 VAL A   9       2.001  -4.507 -23.430  1.00 38.95           C  
ATOM     22  N   GLU A  10       1.513  -9.076 -23.943  1.00 31.14           N  
ATOM     23  CA  GLU A  10       1.748 -10.523 -23.731  1.00 35.63           C  
ATOM     24  C   GLU A  10       2.356 -11.199 -24.946  1.00 33.62           C  
ATOM     25  O   GLU A  10       3.201 -12.085 -24.812  1.00 31.50           O  
ATOM     26  CB  GLU A  10       0.449 -11.241 -23.375  1.00 28.92           C  
ATOM     27  CG  GLU A  10       0.600 -12.739 -23.152  1.00 34.89           C  
ATOM     28  CD  GLU A  10      -0.625 -13.365 -22.463  1.00 55.94           C  
ATOM     29  OE1 GLU A  10      -1.740 -12.832 -22.652  1.00 48.77           O  
ATOM     30  OE2 GLU A  10      -0.473 -14.381 -21.732  1.00 44.49           O  
ATOM     31  N   ASP A  11       1.915 -10.766 -26.129  1.00 34.58           N  
ATOM     32  CA  ASP A  11       2.373 -11.336 -27.398  1.00 33.83           C  
ATOM     33  C   ASP A  11       3.787 -10.916 -27.781  1.00 28.68           C  
ATOM     34  O   ASP A  11       4.349 -11.456 -28.717  1.00 36.13           O  
ATOM     35  CB  ASP A  11       1.422 -10.953 -28.539  1.00 31.74           C  
ATOM     36  CG  ASP A  11       0.001 -11.449 -28.317  1.00 56.40           C  
ATOM     37  OD1 ASP A  11      -0.185 -12.524 -27.682  1.00 60.07           O  
ATOM     38  OD2 ASP A  11      -0.924 -10.755 -28.791  1.00 55.98           O  
ATOM     39  N   HIS A  12       4.363  -9.964 -27.050  1.00 31.96           N  
ATOM     40  CA  HIS A  12       5.739  -9.550 -27.297  1.00 29.42           C  
ATOM     41  C   HIS A  12       6.768 -10.411 -26.576  1.00 27.14           C  
ATOM     42  O   HIS A  12       7.954 -10.199 -26.774  1.00 29.72           O  
ATOM     43  CB  HIS A  12       5.943  -8.083 -26.905  1.00 35.46           C  
ATOM     44  CG  HIS A  12       5.293  -7.105 -27.837  1.00 43.61           C  
ATOM     45  ND1 HIS A  12       4.003  -6.648 -27.661  1.00 51.21           N  
ATOM     46  CD2 HIS A  12       5.762  -6.488 -28.950  1.00 55.14           C  
ATOM     47  CE1 HIS A  12       3.708  -5.789 -28.621  1.00 59.82           C  
ATOM     48  NE2 HIS A  12       4.757  -5.675 -29.420  1.00 46.61           N  
ATOM     49  N   TYR A  13       6.337 -11.375 -25.746  1.00 27.37           N  
ATOM     50  CA  TYR A  13       7.278 -12.238 -25.008  1.00 29.47           C  
ATOM     51  C   TYR A  13       7.024 -13.711 -25.295  1.00 31.06           C  
ATOM     52  O   TYR A  13       5.891 -14.186 -25.229  1.00 33.75           O  
ATOM     53  CB  TYR A  13       7.179 -11.970 -23.501  1.00 29.41           C  
ATOM     54  CG  TYR A  13       7.566 -10.556 -23.170  1.00 25.25           C  
ATOM     55  CD1 TYR A  13       8.897 -10.226 -22.981  1.00 27.54           C  
ATOM     56  CD2 TYR A  13       6.617  -9.557 -23.053  1.00 25.17           C  
ATOM     57  CE1 TYR A  13       9.293  -8.934 -22.698  1.00 24.72           C  
ATOM     58  CE2 TYR A  13       7.012  -8.230 -22.793  1.00 31.05           C  
ATOM     59  CZ  TYR A  13       8.367  -7.949 -22.607  1.00 24.98           C  
ATOM     60  OH  TYR A  13       8.801  -6.690 -22.331  1.00 29.17           O  
ATOM     61  N   GLU A  14       8.082 -14.416 -25.649  1.00 26.39           N  
ATOM     62  CA  GLU A  14       8.032 -15.852 -25.832  1.00 27.68           C  
ATOM     63  C   GLU A  14       8.443 -16.540 -24.528  1.00 25.84           C  
ATOM     64  O   GLU A  14       9.602 -16.480 -24.133  1.00 26.23           O  
ATOM     65  CB  GLU A  14       8.956 -16.267 -26.958  1.00 31.28           C  
ATOM     66  CG  GLU A  14       8.885 -17.743 -27.268  1.00 41.31           C  
ATOM     67  CD  GLU A  14       9.962 -18.188 -28.226  1.00 64.67           C  
ATOM     68  OE1 GLU A  14      10.895 -17.393 -28.498  1.00 82.50           O  
ATOM     69  OE2 GLU A  14       9.877 -19.342 -28.701  1.00 84.06           O  
ATOM     70  N   MET A  15       7.499 -17.214 -23.881  1.00 29.08           N  
ATOM     71  CA  MET A  15       7.783 -17.869 -22.610  1.00 26.25           C  
ATOM     72  C   MET A  15       8.614 -19.132 -22.778  1.00 29.56           C  
ATOM     73  O   MET A  15       8.413 -19.905 -23.702  1.00 28.09           O  
ATOM     74  CB  MET A  15       6.481 -18.213 -21.879  1.00 26.12           C  
ATOM     75  CG  MET A  15       5.691 -16.979 -21.455  1.00 38.14           C  
ATOM     76  SD  MET A  15       6.671 -15.874 -20.372  1.00 31.62           S  
ATOM     77  CE  MET A  15       5.757 -14.351 -20.496  1.00 29.12           C  
ATOM     78  N   GLY A  16       9.554 -19.337 -21.868  1.00 23.84           N  
ATOM     79  CA  GLY A  16      10.361 -20.528 -21.860  1.00 27.19           C  
ATOM     80  C   GLY A  16      10.165 -21.345 -20.604  1.00 26.25           C  
ATOM     81  O   GLY A  16       9.089 -21.413 -20.055  1.00 23.19           O  
ATOM     82  N   GLU A  17      11.240 -21.951 -20.130  1.00 25.04           N  
ATOM     83  CA  GLU A  17      11.149 -22.914 -19.046  1.00 26.98           C  
ATOM     84  C   GLU A  17      10.926 -22.278 -17.694  1.00 24.70           C  
ATOM     85  O   GLU A  17      11.253 -21.078 -17.475  1.00 23.45           O  
ATOM     86  CB  GLU A  17      12.436 -23.760 -18.994  1.00 31.72           C  
ATOM     87  CG  GLU A  17      13.670 -22.988 -18.532  1.00 28.69           C  
ATOM     88  CD  GLU A  17      14.444 -22.303 -19.647  1.00 45.34           C  
ATOM     89  OE1 GLU A  17      13.903 -22.063 -20.779  1.00 34.84           O  
ATOM     90  OE2 GLU A  17      15.616 -21.974 -19.355  1.00 34.62           O  
ATOM     91  N   GLU A  18      10.387 -23.079 -16.772  1.00 24.35           N  
ATOM     92  CA  GLU A  18      10.288 -22.692 -15.377  1.00 21.74           C  
ATOM     93  C   GLU A  18      11.664 -22.479 -14.732  1.00 25.15           C  
ATOM     94  O   GLU A  18      12.574 -23.290 -14.897  1.00 24.50           O  
ATOM     95  CB  GLU A  18       9.573 -23.776 -14.601  1.00 26.21           C  
ATOM     96  CG  GLU A  18       9.415 -23.426 -13.202  1.00 26.57           C  
ATOM     97  CD  GLU A  18       8.807 -24.514 -12.351  1.00 40.16           C  
ATOM     98  OE1 GLU A  18       8.394 -25.550 -12.889  1.00 35.89           O  
ATOM     99  OE2 GLU A  18       8.753 -24.311 -11.121  1.00 36.59           O  
ATOM    100  N   LEU A  19      11.801 -21.396 -13.988  1.00 24.64           N  
ATOM    101  CA  LEU A  19      13.001 -21.116 -13.197  1.00 23.48           C  
ATOM    102  C   LEU A  19      12.753 -21.499 -11.742  1.00 27.32           C  
ATOM    103  O   LEU A  19      13.648 -21.971 -11.042  1.00 26.42           O  
ATOM    104  CB  LEU A  19      13.416 -19.641 -13.338  1.00 25.35           C  
ATOM    105  CG  LEU A  19      13.897 -19.275 -14.727  1.00 25.72           C  
ATOM    106  CD1 LEU A  19      14.063 -17.735 -14.841  1.00 24.17           C  
ATOM    107  CD2 LEU A  19      15.161 -20.025 -15.161  1.00 27.59           C  
ATOM    108  N   GLY A  20      11.533 -21.284 -11.273  1.00 22.45           N  
ATOM    109  CA  GLY A  20      11.161 -21.677  -9.954  1.00 26.81           C  
ATOM    110  C   GLY A  20       9.717 -21.348  -9.629  1.00 30.05           C  
ATOM    111  O   GLY A  20       9.020 -20.744 -10.421  1.00 27.86           O  
ATOM    112  N   SER A  21       9.274 -21.746  -8.446  1.00 28.24           N  
ATOM    113  CA  SER A  21       7.878 -21.603  -8.075  1.00 35.61           C  
ATOM    114  C   SER A  21       7.743 -21.365  -6.580  1.00 42.38           C  
ATOM    115  O   SER A  21       8.533 -21.881  -5.786  1.00 36.75           O  
ATOM    116  CB  SER A  21       7.089 -22.895  -8.401  1.00 38.00           C  
ATOM    117  OG  SER A  21       6.892 -23.061  -9.783  1.00 53.77           O  
ATOM    118  N   GLY A  22       6.712 -20.621  -6.207  1.00 35.62           N  
ATOM    119  CA  GLY A  22       6.346 -20.474  -4.809  1.00 44.19           C  
ATOM    120  C   GLY A  22       4.870 -20.733  -4.663  1.00 39.46           C  
ATOM    121  O   GLY A  22       4.219 -21.226  -5.592  1.00 34.26           O  
ATOM    122  N   GLN A  23       4.345 -20.346  -3.503  1.00 41.36           N  
ATOM    123  CA  GLN A  23       2.940 -20.539  -3.152  1.00 48.80           C  
ATOM    124  C   GLN A  23       2.027 -19.847  -4.165  1.00 44.13           C  
ATOM    125  O   GLN A  23       1.062 -20.428  -4.641  1.00 43.34           O  
ATOM    126  CB  GLN A  23       2.685 -19.940  -1.761  1.00 53.08           C  
ATOM    127  CG  GLN A  23       1.328 -20.269  -1.139  1.00 61.45           C  
ATOM    128  CD  GLN A  23       1.235 -19.806   0.325  1.00 79.76           C  
ATOM    129  OE1 GLN A  23       1.931 -18.873   0.753  1.00 62.02           O  
ATOM    130  NE2 GLN A  23       0.383 -20.464   1.094  1.00 59.20           N  
ATOM    131  N   PHE A  24       2.404 -18.623  -4.516  1.00 38.05           N  
ATOM    132  CA  PHE A  24       1.547 -17.678  -5.233  1.00 42.69           C  
ATOM    133  C   PHE A  24       2.022 -17.287  -6.652  1.00 32.97           C  
ATOM    134  O   PHE A  24       1.310 -16.586  -7.381  1.00 34.58           O  
ATOM    135  CB  PHE A  24       1.448 -16.424  -4.367  1.00 39.29           C  
ATOM    136  CG  PHE A  24       0.672 -16.649  -3.089  1.00 56.07           C  
ATOM    137  CD1 PHE A  24      -0.660 -17.070  -3.135  1.00 35.27           C  
ATOM    138  CD2 PHE A  24       1.274 -16.473  -1.844  1.00 62.49           C  
ATOM    139  CE1 PHE A  24      -1.392 -17.307  -1.947  1.00 38.54           C  
ATOM    140  CE2 PHE A  24       0.555 -16.707  -0.655  1.00 51.18           C  
ATOM    141  CZ  PHE A  24      -0.777 -17.117  -0.709  1.00 49.43           C  
ATOM    142  N   ALA A  25       3.198 -17.766  -7.038  1.00 33.96           N  
ATOM    143  CA  ALA A  25       3.860 -17.258  -8.227  1.00 26.26           C  
ATOM    144  C   ALA A  25       4.746 -18.341  -8.866  1.00 27.90           C  
ATOM    145  O   ALA A  25       5.362 -19.164  -8.172  1.00 32.45           O  
ATOM    146  CB  ALA A  25       4.696 -16.013  -7.872  1.00 29.59           C  
ATOM    147  N   ILE A  26       4.823 -18.320 -10.186  1.00 26.46           N  
ATOM    148  CA  ILE A  26       5.772 -19.141 -10.933  1.00 22.93           C  
ATOM    149  C   ILE A  26       6.632 -18.198 -11.765  1.00 25.23           C  
ATOM    150  O   ILE A  26       6.087 -17.264 -12.332  1.00 24.67           O  
ATOM    151  CB  ILE A  26       5.090 -20.210 -11.882  1.00 26.89           C  
ATOM    152  CG1 ILE A  26       3.810 -20.754 -11.216  0.50 35.06           C  
ATOM    154  CG2 ILE A  26       6.093 -21.264 -12.311  0.50 34.00           C  
ATOM    156  CD1 ILE A  26       2.944 -21.658 -12.102  0.50 26.28           C  
ATOM    158  N   VAL A  27       7.955 -18.417 -11.777  1.00 21.11           N  
ATOM    159  CA  VAL A  27       8.889 -17.592 -12.560  1.00 20.08           C  
ATOM    160  C   VAL A  27       9.356 -18.425 -13.735  1.00 24.09           C  
ATOM    161  O   VAL A  27       9.827 -19.550 -13.535  1.00 23.20           O  
ATOM    162  CB  VAL A  27      10.076 -17.148 -11.745  1.00 22.78           C  
ATOM    163  CG1 VAL A  27      11.048 -16.309 -12.586  1.00 23.10           C  
ATOM    164  CG2 VAL A  27       9.616 -16.381 -10.450  1.00 23.65           C  
ATOM    165  N   ARG A  28       9.272 -17.868 -14.942  1.00 23.53           N  
ATOM    166  CA  ARG A  28       9.689 -18.552 -16.171  1.00 22.97           C  
ATOM    167  C   ARG A  28      10.724 -17.678 -16.852  1.00 23.12           C  
ATOM    168  O   ARG A  28      10.685 -16.440 -16.742  1.00 25.42           O  
ATOM    169  CB  ARG A  28       8.524 -18.824 -17.158  1.00 24.74           C  
ATOM    170  CG  ARG A  28       7.512 -19.827 -16.649  0.50 29.73           C  
ATOM    172  CD  ARG A  28       6.252 -19.903 -17.495  0.50 26.66           C  
ATOM    174  NE  ARG A  28       5.394 -20.984 -17.019  0.50 31.68           N  
ATOM    176  CZ  ARG A  28       4.193 -20.827 -16.458  0.50 34.44           C  
ATOM    178  NH1 ARG A  28       3.662 -19.620 -16.317  0.50 29.49           N  
ATOM    180  NH2 ARG A  28       3.515 -21.891 -16.062  0.50 39.69           N  
ATOM    182  N   LYS A  29      11.659 -18.287 -17.558  1.00 22.00           N  
ATOM    183  CA  LYS A  29      12.534 -17.514 -18.421  1.00 22.83           C  
ATOM    184  C   LYS A  29      11.706 -17.082 -19.640  1.00 26.06           C  
ATOM    185  O   LYS A  29      10.844 -17.820 -20.094  1.00 25.08           O  
ATOM    186  CB  LYS A  29      13.776 -18.307 -18.874  1.00 29.58           C  
ATOM    187  CG  LYS A  29      14.891 -17.369 -19.405  1.00 31.45           C  
ATOM    188  CD  LYS A  29      16.177 -18.023 -19.920  1.00 35.29           C  
ATOM    189  CE  LYS A  29      16.955 -18.741 -18.841  1.00 58.05           C  
ATOM    190  NZ  LYS A  29      17.979 -19.657 -19.431  1.00 49.38           N  
ATOM    191  N   CYS A  30      11.982 -15.894 -20.171  1.00 24.03           N  
ATOM    192  CA  CYS A  30      11.339 -15.464 -21.400  1.00 22.61           C  
ATOM    193  C   CYS A  30      12.235 -14.579 -22.264  1.00 25.39           C  
ATOM    194  O   CYS A  30      13.314 -14.146 -21.852  1.00 24.77           O  
ATOM    195  CB  CYS A  30       9.993 -14.798 -21.125  1.00 26.76           C  
ATOM    196  SG  CYS A  30      10.185 -13.133 -20.485  1.00 27.21           S  
ATOM    197  N   ARG A  31      11.803 -14.382 -23.502  1.00 25.49           N  
ATOM    198  CA  ARG A  31      12.580 -13.606 -24.469  1.00 24.61           C  
ATOM    199  C   ARG A  31      11.685 -12.584 -25.097  1.00 28.93           C  
ATOM    200  O   ARG A  31      10.610 -12.945 -25.576  1.00 26.82           O  
ATOM    201  CB  ARG A  31      13.144 -14.513 -25.552  1.00 27.43           C  
ATOM    202  CG  ARG A  31      14.073 -13.819 -26.528  1.00 36.70           C  
ATOM    203  CD  ARG A  31      14.520 -14.798 -27.611  1.00 49.83           C  
ATOM    204  NE  ARG A  31      15.365 -15.857 -27.049  1.00 67.52           N  
ATOM    205  CZ  ARG A  31      16.675 -15.755 -26.807  1.00 69.44           C  
ATOM    206  NH1 ARG A  31      17.339 -14.626 -27.062  1.00 63.95           N  
ATOM    207  NH2 ARG A  31      17.328 -16.798 -26.296  1.00 61.20           N  
ATOM    208  N   GLN A  32      12.137 -11.321 -25.132  1.00 25.73           N  
ATOM    209  CA  GLN A  32      11.389 -10.283 -25.847  1.00 26.32           C  
ATOM    210  C   GLN A  32      11.563 -10.484 -27.356  1.00 28.93           C  
ATOM    211  O   GLN A  32      12.687 -10.541 -27.865  1.00 25.95           O  
ATOM    212  CB  GLN A  32      11.817  -8.892 -25.423  1.00 25.63           C  
ATOM    213  CG  GLN A  32      10.831  -7.797 -25.781  1.00 29.98           C  
ATOM    214  CD  GLN A  32      11.221  -6.443 -25.217  1.00 46.57           C  
ATOM    215  OE1 GLN A  32      11.626  -6.333 -24.066  1.00 44.08           O  
ATOM    216  NE2 GLN A  32      11.100  -5.405 -26.032  1.00 53.14           N  
ATOM    217  N   LYS A  33      10.438 -10.645 -28.053  1.00 34.69           N  
ATOM    218  CA  LYS A  33      10.471 -11.117 -29.454  1.00 37.25           C  
ATOM    219  C   LYS A  33      11.304 -10.193 -30.366  1.00 39.98           C  
ATOM    220  O   LYS A  33      12.121 -10.663 -31.161  1.00 45.55           O  
ATOM    221  CB  LYS A  33       9.045 -11.327 -29.996  1.00 36.60           C  
ATOM    222  CG  LYS A  33       8.414 -12.653 -29.541  1.00 38.29           C  
ATOM    223  CD  LYS A  33       6.986 -12.841 -30.039  1.00 37.89           C  
ATOM    224  CE  LYS A  33       6.304 -14.012 -29.315  1.00 45.96           C  
ATOM    225  NZ  LYS A  33       4.839 -14.096 -29.549  1.00 44.16           N  
ATOM    226  N   GLY A  34      11.150  -8.889 -30.195  1.00 34.56           N  
ATOM    227  CA  GLY A  34      11.768  -7.944 -31.110  1.00 39.20           C  
ATOM    228  C   GLY A  34      13.240  -7.721 -30.861  1.00 39.02           C  
ATOM    229  O   GLY A  34      14.032  -7.699 -31.793  1.00 37.60           O  
ATOM    230  N   THR A  35      13.620  -7.581 -29.594  1.00 30.46           N  
ATOM    231  CA  THR A  35      15.019  -7.297 -29.251  1.00 31.10           C  
ATOM    232  C   THR A  35      15.829  -8.567 -29.041  1.00 33.63           C  
ATOM    233  O   THR A  35      17.049  -8.516 -29.087  1.00 35.12           O  
ATOM    234  CB  THR A  35      15.104  -6.477 -27.963  1.00 36.06           C  
ATOM    235  OG1 THR A  35      14.659  -7.290 -26.864  1.00 32.23           O  
ATOM    236  CG2 THR A  35      14.235  -5.224 -28.060  1.00 33.68           C  
ATOM    237  N   GLY A  36      15.166  -9.699 -28.768  1.00 33.42           N  
ATOM    238  CA  GLY A  36      15.879 -10.934 -28.426  1.00 30.00           C  
ATOM    239  C   GLY A  36      16.420 -10.951 -26.990  1.00 28.33           C  
ATOM    240  O   GLY A  36      17.054 -11.919 -26.574  1.00 31.33           O  
ATOM    241  N   LYS A  37      16.160  -9.912 -26.208  1.00 30.26           N  
ATOM    242  CA  LYS A  37      16.714  -9.849 -24.863  1.00 29.06           C  
ATOM    243  C   LYS A  37      15.903 -10.768 -23.950  1.00 27.35           C  
ATOM    244  O   LYS A  37      14.696 -10.888 -24.119  1.00 23.05           O  
ATOM    245  CB  LYS A  37      16.722  -8.416 -24.328  1.00 26.73           C  
ATOM    246  CG  LYS A  37      17.492  -8.285 -22.986  1.00 33.89           C  
ATOM    247  CD  LYS A  37      18.199  -6.936 -22.812  1.00 48.71           C  
ATOM    248  CE  LYS A  37      18.217  -6.446 -21.353  1.00 50.86           C  
ATOM    249  NZ  LYS A  37      17.044  -5.553 -21.048  1.00 59.05           N  
ATOM    250  N   GLU A  38      16.577 -11.451 -23.023  1.00 25.60           N  
ATOM    251  CA  GLU A  38      15.896 -12.339 -22.066  1.00 24.44           C  
ATOM    252  C   GLU A  38      15.590 -11.671 -20.738  1.00 24.78           C  
ATOM    253  O   GLU A  38      16.305 -10.787 -20.272  1.00 24.56           O  
ATOM    254  CB  GLU A  38      16.695 -13.622 -21.846  1.00 25.16           C  
ATOM    255  CG  GLU A  38      16.657 -14.522 -23.088  1.00 37.34           C  
ATOM    256  CD  GLU A  38      17.315 -15.855 -22.869  1.00 48.62           C  
ATOM    257  OE1 GLU A  38      18.405 -15.878 -22.255  1.00 39.31           O  
ATOM    258  OE2 GLU A  38      16.740 -16.877 -23.314  1.00 48.08           O  
ATOM    259  N   TYR A  39      14.519 -12.158 -20.128  1.00 23.51           N  
ATOM    260  CA  TYR A  39      13.980 -11.627 -18.904  1.00 21.04           C  
ATOM    261  C   TYR A  39      13.456 -12.780 -18.078  1.00 23.57           C  
ATOM    262  O   TYR A  39      13.366 -13.915 -18.563  1.00 22.15           O  
ATOM    263  CB  TYR A  39      12.815 -10.654 -19.208  1.00 24.72           C  
ATOM    264  CG  TYR A  39      13.269  -9.407 -19.931  1.00 20.16           C  
ATOM    265  CD1 TYR A  39      13.816  -8.355 -19.219  1.00 21.95           C  
ATOM    266  CD2 TYR A  39      13.194  -9.312 -21.314  1.00 20.09           C  
ATOM    267  CE1 TYR A  39      14.284  -7.215 -19.858  1.00 28.26           C  
ATOM    268  CE2 TYR A  39      13.607  -8.179 -21.962  1.00 22.61           C  
ATOM    269  CZ  TYR A  39      14.171  -7.138 -21.234  1.00 25.72           C  
ATOM    270  OH  TYR A  39      14.613  -6.024 -21.893  1.00 28.35           O  
ATOM    271  N   ALA A  40      13.121 -12.476 -16.827  1.00 22.42           N  
ATOM    272  CA  ALA A  40      12.429 -13.393 -15.924  1.00 19.73           C  
ATOM    273  C   ALA A  40      10.985 -12.939 -15.869  1.00 23.95           C  
ATOM    274  O   ALA A  40      10.709 -11.769 -15.641  1.00 28.07           O  
ATOM    275  CB  ALA A  40      13.038 -13.371 -14.495  1.00 21.53           C  
ATOM    276  N   ALA A  41      10.055 -13.855 -16.060  1.00 21.55           N  
ATOM    277  CA  ALA A  41       8.625 -13.520 -16.047  1.00 21.97           C  
ATOM    278  C   ALA A  41       8.029 -14.147 -14.799  1.00 24.96           C  
ATOM    279  O   ALA A  41       7.925 -15.399 -14.708  1.00 21.42           O  
ATOM    280  CB  ALA A  41       7.906 -14.060 -17.277  1.00 22.66           C  
ATOM    281  N   LYS A  42       7.603 -13.290 -13.886  1.00 20.33           N  
ATOM    282  CA  LYS A  42       6.926 -13.731 -12.648  1.00 18.92           C  
ATOM    283  C   LYS A  42       5.406 -13.695 -12.796  1.00 22.99           C  
ATOM    284  O   LYS A  42       4.817 -12.624 -12.902  1.00 23.99           O  
ATOM    285  CB  LYS A  42       7.350 -12.882 -11.481  1.00 20.69           C  
ATOM    286  CG  LYS A  42       6.783 -13.305 -10.131  1.00 22.55           C  
ATOM    287  CD  LYS A  42       7.268 -12.238  -9.089  1.00 25.74           C  
ATOM    288  CE  LYS A  42       6.895 -12.607  -7.701  1.00 31.56           C  
ATOM    289  NZ  LYS A  42       7.298 -11.593  -6.700  1.00 25.27           N  
ATOM    290  N   PHE A  43       4.802 -14.876 -12.847  1.00 22.59           N  
ATOM    291  CA  PHE A  43       3.342 -15.043 -12.998  1.00 23.25           C  
ATOM    292  C   PHE A  43       2.715 -15.083 -11.627  1.00 24.33           C  
ATOM    293  O   PHE A  43       2.973 -16.008 -10.860  1.00 24.57           O  
ATOM    294  CB  PHE A  43       3.004 -16.327 -13.740  1.00 22.61           C  
ATOM    295  CG  PHE A  43       3.339 -16.311 -15.200  1.00 22.85           C  
ATOM    296  CD1 PHE A  43       2.319 -16.302 -16.145  1.00 27.09           C  
ATOM    297  CD2 PHE A  43       4.670 -16.373 -15.635  1.00 25.80           C  
ATOM    298  CE1 PHE A  43       2.604 -16.365 -17.488  1.00 29.53           C  
ATOM    299  CE2 PHE A  43       4.948 -16.415 -16.990  1.00 25.66           C  
ATOM    300  CZ  PHE A  43       3.905 -16.391 -17.913  1.00 31.53           C  
ATOM    301  N   ILE A  44       1.920 -14.061 -11.303  1.00 19.68           N  
ATOM    302  CA  ILE A  44       1.230 -13.976  -9.999  1.00 21.30           C  
ATOM    303  C   ILE A  44      -0.217 -14.347 -10.233  1.00 24.80           C  
ATOM    304  O   ILE A  44      -0.943 -13.677 -10.980  1.00 25.55           O  
ATOM    305  CB  ILE A  44       1.288 -12.579  -9.328  1.00 22.05           C  
ATOM    306  CG1 ILE A  44       2.740 -12.108  -9.228  1.00 22.37           C  
ATOM    307  CG2 ILE A  44       0.600 -12.598  -7.938  1.00 21.26           C  
ATOM    308  CD1 ILE A  44       2.937 -10.647  -8.741  1.00 23.28           C  
ATOM    309  N   LYS A  45      -0.632 -15.432  -9.601  1.00 24.66           N  
ATOM    310  CA  LYS A  45      -2.005 -15.934  -9.745  1.00 23.29           C  
ATOM    311  C   LYS A  45      -2.988 -15.035  -9.035  1.00 20.77           C  
ATOM    312  O   LYS A  45      -2.899 -14.846  -7.805  1.00 24.08           O  
ATOM    313  CB  LYS A  45      -2.110 -17.361  -9.167  1.00 33.38           C  
ATOM    314  CG  LYS A  45      -3.406 -18.110  -9.542  1.00 33.80           C  
ATOM    315  CD  LYS A  45      -3.492 -18.376 -11.006  1.00 39.46           C  
ATOM    316  CE  LYS A  45      -2.482 -19.424 -11.475  1.00 46.66           C  
ATOM    317  NZ  LYS A  45      -2.526 -19.577 -12.942  1.00 36.72           N  
ATOM    318  N   LYS A  46      -3.955 -14.521  -9.784  1.00 21.23           N  
ATOM    319  CA  LYS A  46      -4.941 -13.569  -9.253  1.00 24.08           C  
ATOM    320  C   LYS A  46      -5.993 -14.280  -8.413  1.00 29.72           C  
ATOM    321  O   LYS A  46      -6.488 -15.347  -8.788  1.00 26.23           O  
ATOM    322  CB  LYS A  46      -5.680 -12.844 -10.379  1.00 29.37           C  
ATOM    323  CG  LYS A  46      -4.881 -11.820 -11.158  1.00 27.63           C  
ATOM    324  CD  LYS A  46      -5.775 -11.079 -12.132  1.00 26.51           C  
ATOM    325  CE  LYS A  46      -5.970 -11.847 -13.426  1.00 26.21           C  
ATOM    326  NZ  LYS A  46      -6.841 -11.087 -14.374  1.00 23.04           N  
ATOM    327  N   ARG A  47      -6.365 -13.638  -7.310  1.00 26.03           N  
ATOM    328  CA  ARG A  47      -7.449 -14.107  -6.482  1.00 27.52           C  
ATOM    329  C   ARG A  47      -8.746 -13.931  -7.277  1.00 30.42           C  
ATOM    330  O   ARG A  47      -8.888 -12.960  -8.024  1.00 29.17           O  
ATOM    331  CB  ARG A  47      -7.478 -13.311  -5.199  1.00 28.44           C  
ATOM    332  CG  ARG A  47      -8.614 -13.714  -4.283  1.00 26.48           C  
ATOM    333  CD  ARG A  47      -8.396 -13.207  -2.894  1.00 29.16           C  
ATOM    334  NE  ARG A  47      -7.296 -13.905  -2.247  1.00 33.91           N  
ATOM    335  CZ  ARG A  47      -6.746 -13.549  -1.099  1.00 36.55           C  
ATOM    336  NH1 ARG A  47      -5.743 -14.256  -0.601  1.00 32.55           N  
ATOM    337  NH2 ARG A  47      -7.181 -12.487  -0.448  1.00 34.20           N  
ATOM    338  N   ARG A  48      -9.663 -14.887  -7.158  1.00 22.95           N  
ATOM    339  CA  ARG A  48     -10.891 -14.877  -7.993  1.00 25.49           C  
ATOM    340  C   ARG A  48     -12.098 -14.159  -7.377  1.00 34.83           C  
ATOM    341  O   ARG A  48     -12.974 -13.655  -8.106  1.00 39.30           O  
ATOM    342  CB  ARG A  48     -11.283 -16.306  -8.366  1.00 29.09           C  
ATOM    343  CG  ARG A  48     -10.275 -17.024  -9.258  1.00 30.04           C  
ATOM    344  CD  ARG A  48     -10.726 -18.416  -9.598  1.00 45.41           C  
ATOM    345  N   LEU A  49     -12.202 -14.171  -6.062  1.00 30.92           N  
ATOM    346  CA  LEU A  49     -13.245 -13.427  -5.382  1.00 31.80           C  
ATOM    347  C   LEU A  49     -12.599 -12.808  -4.181  1.00 33.08           C  
ATOM    348  O   LEU A  49     -11.738 -13.430  -3.547  1.00 33.25           O  
ATOM    349  CB  LEU A  49     -14.371 -14.338  -4.898  1.00 30.61           C  
ATOM    350  CG  LEU A  49     -15.296 -15.039  -5.874  1.00 30.55           C  
ATOM    351  CD1 LEU A  49     -16.138 -16.036  -5.086  1.00 26.39           C  
ATOM    352  CD2 LEU A  49     -16.181 -14.036  -6.616  1.00 40.52           C  
ATOM    353  N   SER A  50     -13.022 -11.585  -3.852  1.00 33.72           N  
ATOM    354  CA  SER A  50     -12.572 -10.884  -2.645  1.00 30.31           C  
ATOM    355  C   SER A  50     -12.587 -11.781  -1.438  1.00 31.40           C  
ATOM    356  O   SER A  50     -11.762 -11.653  -0.548  1.00 39.76           O  
ATOM    357  CB  SER A  50     -13.432  -9.642  -2.362  0.50 41.11           C  
ATOM    359  OG  SER A  50     -13.119  -9.085  -1.090  0.50 41.86           O  
ATOM    361  N   SER A  51     -13.580 -12.661  -1.382  1.00 33.78           N  
ATOM    362  CA  SER A  51     -13.790 -13.495  -0.209  1.00 32.65           C  
ATOM    363  C   SER A  51     -12.930 -14.755  -0.232  1.00 33.84           C  
ATOM    364  O   SER A  51     -12.853 -15.465   0.772  1.00 29.09           O  
ATOM    365  CB  SER A  51     -15.281 -13.849  -0.093  1.00 32.83           C  
ATOM    366  OG  SER A  51     -15.885 -14.057  -1.358  1.00 33.98           O  
ATOM    367  N   SER A  52     -12.269 -15.025  -1.367  1.00 38.01           N  
ATOM    368  CA  SER A  52     -11.391 -16.204  -1.472  1.00 32.53           C  
ATOM    369  C   SER A  52     -10.152 -16.020  -0.632  1.00 35.06           C  
ATOM    370  O   SER A  52      -9.708 -14.876  -0.379  1.00 32.93           O  
ATOM    371  CB  SER A  52     -10.984 -16.467  -2.928  1.00 34.33           C  
ATOM    372  OG  SER A  52      -9.921 -17.415  -3.008  1.00 29.30           O  
ATOM    373  N   ARG A  53      -9.579 -17.150  -0.216  1.00 27.30           N  
ATOM    374  CA  ARG A  53      -8.315 -17.148   0.498  1.00 29.45           C  
ATOM    375  C   ARG A  53      -7.156 -17.669  -0.338  1.00 32.32           C  
ATOM    376  O   ARG A  53      -6.062 -17.899   0.175  1.00 32.87           O  
ATOM    377  CB  ARG A  53      -8.447 -17.957   1.790  1.00 35.27           C  
ATOM    378  CG  ARG A  53      -9.272 -17.261   2.864  1.00 41.07           C  
ATOM    379  CD  ARG A  53      -8.717 -15.867   3.202  1.00 54.21           C  
ATOM    380  NE  ARG A  53      -9.396 -15.276   4.351  1.00 72.96           N  
ATOM    381  N   ARG A  54      -7.375 -17.802  -1.630  1.00 28.83           N  
ATOM    382  CA  ARG A  54      -6.347 -18.268  -2.553  1.00 31.25           C  
ATOM    383  C   ARG A  54      -5.954 -17.185  -3.560  1.00 28.59           C  
ATOM    384  O   ARG A  54      -6.738 -16.254  -3.885  1.00 26.59           O  
ATOM    385  CB  ARG A  54      -6.844 -19.509  -3.303  1.00 29.89           C  
ATOM    386  CG  ARG A  54      -7.332 -20.616  -2.351  1.00 31.04           C  
ATOM    387  CD  ARG A  54      -7.609 -21.919  -3.068  1.00 28.35           C  
ATOM    388  NE  ARG A  54      -7.849 -23.023  -2.122  1.00 36.15           N  
ATOM    389  CZ  ARG A  54      -8.202 -24.261  -2.472  1.00 27.80           C  
ATOM    390  NH1 ARG A  54      -8.406 -24.582  -3.750  1.00 47.09           N  
ATOM    391  NH2 ARG A  54      -8.358 -25.188  -1.530  1.00 34.94           N  
ATOM    392  N   GLY A  55      -4.768 -17.347  -4.128  1.00 30.71           N  
ATOM    393  CA  GLY A  55      -4.240 -16.335  -4.997  1.00 25.18           C  
ATOM    394  C   GLY A  55      -3.929 -15.071  -4.244  1.00 24.96           C  
ATOM    395  O   GLY A  55      -3.920 -15.034  -3.007  1.00 26.49           O  
ATOM    396  N   VAL A  56      -3.626 -14.039  -5.029  1.00 25.31           N  
ATOM    397  CA  VAL A  56      -3.188 -12.762  -4.496  1.00 23.43           C  
ATOM    398  C   VAL A  56      -4.220 -11.723  -4.908  1.00 25.06           C  
ATOM    399  O   VAL A  56      -4.622 -11.641  -6.089  1.00 23.96           O  
ATOM    400  CB  VAL A  56      -1.762 -12.411  -5.001  1.00 24.33           C  
ATOM    401  CG1 VAL A  56      -1.248 -11.111  -4.363  1.00 25.68           C  
ATOM    402  CG2 VAL A  56      -0.761 -13.597  -4.702  1.00 27.39           C  
ATOM    403  N   SER A  57      -4.632 -10.917  -3.941  1.00 27.37           N  
ATOM    404  CA  SER A  57      -5.642  -9.904  -4.175  1.00 29.62           C  
ATOM    405  C   SER A  57      -5.085  -8.801  -5.070  1.00 29.90           C  
ATOM    406  O   SER A  57      -3.878  -8.560  -5.099  1.00 27.67           O  
ATOM    407  CB  SER A  57      -6.087  -9.275  -2.842  1.00 31.81           C  
ATOM    408  OG  SER A  57      -5.073  -8.388  -2.374  1.00 33.57           O  
ATOM    409  N   ARG A  58      -5.972  -8.122  -5.786  1.00 28.79           N  
ATOM    410  CA  ARG A  58      -5.610  -6.969  -6.610  1.00 26.81           C  
ATOM    411  C   ARG A  58      -4.771  -5.943  -5.844  1.00 26.94           C  
ATOM    412  O   ARG A  58      -3.765  -5.435  -6.347  1.00 29.93           O  
ATOM    413  CB  ARG A  58      -6.886  -6.297  -7.161  1.00 32.57           C  
ATOM    414  CG  ARG A  58      -6.624  -4.984  -7.875  1.00 36.94           C  
ATOM    415  CD  ARG A  58      -5.986  -5.178  -9.216  1.00 34.98           C  
ATOM    416  NE  ARG A  58      -6.857  -5.953 -10.127  1.00 48.11           N  
ATOM    417  CZ  ARG A  58      -6.441  -6.544 -11.251  1.00 44.08           C  
ATOM    418  NH1 ARG A  58      -5.179  -6.447 -11.655  1.00 44.18           N  
ATOM    419  NH2 ARG A  58      -7.283  -7.241 -11.990  1.00 33.74           N  
ATOM    420  N   GLU A  59      -5.190  -5.672  -4.612  1.00 25.02           N  
ATOM    421  CA  GLU A  59      -4.555  -4.673  -3.780  1.00 30.37           C  
ATOM    422  C   GLU A  59      -3.122  -5.114  -3.437  1.00 24.10           C  
ATOM    423  O   GLU A  59      -2.228  -4.288  -3.435  1.00 27.30           O  
ATOM    424  CB  GLU A  59      -5.368  -4.442  -2.490  1.00 31.52           C  
ATOM    425  CG  GLU A  59      -4.749  -3.418  -1.532  1.00 52.50           C  
ATOM    426  CD  GLU A  59      -5.685  -3.056  -0.372  1.00 73.02           C  
ATOM    427  OE1 GLU A  59      -6.130  -3.980   0.346  1.00 60.14           O  
ATOM    428  OE2 GLU A  59      -5.969  -1.851  -0.180  1.00 69.41           O  
ATOM    429  N   GLU A  60      -2.932  -6.407  -3.178  1.00 25.52           N  
ATOM    430  CA  GLU A  60      -1.585  -6.925  -2.834  1.00 24.98           C  
ATOM    431  C   GLU A  60      -0.649  -6.889  -4.081  1.00 26.84           C  
ATOM    432  O   GLU A  60       0.563  -6.625  -3.969  1.00 25.42           O  
ATOM    433  CB  GLU A  60      -1.672  -8.352  -2.254  1.00 30.68           C  
ATOM    434  CG  GLU A  60      -2.373  -8.516  -0.901  1.00 39.15           C  
ATOM    435  CD  GLU A  60      -2.724 -10.026  -0.582  1.00 66.29           C  
ATOM    436  OE1 GLU A  60      -3.442 -10.749  -1.359  1.00 40.24           O  
ATOM    437  OE2 GLU A  60      -2.267 -10.499   0.480  1.00 66.70           O  
ATOM    438  N   ILE A  61      -1.178  -7.205  -5.252  1.00 23.53           N  
ATOM    439  CA  ILE A  61      -0.424  -7.114  -6.547  1.00 24.08           C  
ATOM    440  C   ILE A  61      -0.020  -5.675  -6.826  1.00 26.43           C  
ATOM    441  O   ILE A  61       1.141  -5.381  -7.106  1.00 25.05           O  
ATOM    442  CB  ILE A  61      -1.253  -7.694  -7.726  1.00 26.08           C  
ATOM    443  CG1 ILE A  61      -1.510  -9.193  -7.540  1.00 26.62           C  
ATOM    444  CG2 ILE A  61      -0.523  -7.533  -9.068  1.00 28.83           C  
ATOM    445  CD1 ILE A  61      -2.389  -9.838  -8.708  1.00 26.51           C  
ATOM    446  N   GLU A  62      -0.975  -4.761  -6.708  1.00 24.68           N  
ATOM    447  CA  GLU A  62      -0.705  -3.339  -6.940  1.00 26.21           C  
ATOM    448  C   GLU A  62       0.352  -2.809  -5.958  1.00 22.45           C  
ATOM    449  O   GLU A  62       1.169  -1.983  -6.340  1.00 26.10           O  
ATOM    450  CB  GLU A  62      -1.990  -2.505  -6.823  1.00 25.26           C  
ATOM    451  CG  GLU A  62      -2.846  -2.613  -8.055  1.00 31.60           C  
ATOM    452  CD  GLU A  62      -4.216  -1.937  -7.923  1.00 55.04           C  
ATOM    453  OE1 GLU A  62      -4.719  -1.722  -6.791  1.00 47.95           O  
ATOM    454  OE2 GLU A  62      -4.797  -1.636  -8.983  1.00 50.57           O  
ATOM    455  N   ARG A  63       0.352  -3.320  -4.730  1.00 26.52           N  
ATOM    456  CA  ARG A  63       1.294  -2.850  -3.716  1.00 25.01           C  
ATOM    457  C   ARG A  63       2.722  -3.170  -4.195  1.00 27.99           C  
ATOM    458  O   ARG A  63       3.591  -2.300  -4.217  1.00 26.54           O  
ATOM    459  CB  ARG A  63       0.978  -3.505  -2.392  1.00 28.63           C  
ATOM    460  CG  ARG A  63       1.888  -3.117  -1.250  0.50 29.81           C  
ATOM    462  CD  ARG A  63       1.533  -3.901  -0.001  0.50 39.51           C  
ATOM    464  NE  ARG A  63       0.300  -3.415   0.623  0.50 42.68           N  
ATOM    466  CZ  ARG A  63      -0.815  -4.128   0.766  0.50 39.93           C  
ATOM    468  NH1 ARG A  63      -0.888  -5.384   0.333  0.50 56.29           N  
ATOM    470  NH2 ARG A  63      -1.857  -3.584   1.366  0.50 28.12           N  
ATOM    472  N   GLU A  64       2.934  -4.421  -4.608  1.00 26.05           N  
ATOM    473  CA  GLU A  64       4.255  -4.867  -5.077  1.00 21.02           C  
ATOM    474  C   GLU A  64       4.674  -4.122  -6.347  1.00 22.20           C  
ATOM    475  O   GLU A  64       5.839  -3.665  -6.485  1.00 22.93           O  
ATOM    476  CB  GLU A  64       4.252  -6.422  -5.287  1.00 22.42           C  
ATOM    477  CG  GLU A  64       5.430  -6.997  -6.006  1.00 23.28           C  
ATOM    478  CD  GLU A  64       5.445  -8.544  -6.075  1.00 25.67           C  
ATOM    479  OE1 GLU A  64       4.446  -9.192  -5.648  1.00 24.87           O  
ATOM    480  OE2 GLU A  64       6.480  -9.085  -6.543  1.00 30.02           O  
ATOM    481  N   VAL A  65       3.752  -4.007  -7.302  1.00 22.94           N  
ATOM    482  CA  VAL A  65       4.062  -3.414  -8.603  1.00 21.22           C  
ATOM    483  C   VAL A  65       4.340  -1.918  -8.400  1.00 21.95           C  
ATOM    484  O   VAL A  65       5.308  -1.403  -8.923  1.00 22.98           O  
ATOM    485  CB  VAL A  65       2.958  -3.691  -9.638  1.00 24.61           C  
ATOM    486  CG1 VAL A  65       3.120  -2.813 -10.888  1.00 31.17           C  
ATOM    487  CG2 VAL A  65       2.911  -5.164 -10.032  1.00 24.37           C  
ATOM    488  N   ASN A  66       3.571  -1.248  -7.555  1.00 25.40           N  
ATOM    489  CA  ASN A  66       3.811   0.180  -7.313  1.00 25.13           C  
ATOM    490  C   ASN A  66       5.190   0.421  -6.677  1.00 24.39           C  
ATOM    491  O   ASN A  66       5.876   1.380  -7.024  1.00 27.15           O  
ATOM    492  CB  ASN A  66       2.691   0.778  -6.469  1.00 29.81           C  
ATOM    493  CG  ASN A  66       1.389   0.952  -7.271  1.00 29.13           C  
ATOM    494  OD1 ASN A  66       1.426   1.039  -8.493  1.00 31.11           O  
ATOM    495  ND2 ASN A  66       0.258   0.973  -6.582  1.00 35.37           N  
ATOM    496  N   ILE A  67       5.575  -0.428  -5.741  1.00 21.83           N  
ATOM    497  CA  ILE A  67       6.914  -0.385  -5.126  1.00 21.38           C  
ATOM    498  C   ILE A  67       8.003  -0.640  -6.189  1.00 20.81           C  
ATOM    499  O   ILE A  67       8.950   0.119  -6.271  1.00 24.63           O  
ATOM    500  CB  ILE A  67       7.017  -1.335  -3.912  1.00 22.21           C  
ATOM    501  CG1 ILE A  67       6.242  -0.707  -2.725  1.00 25.21           C  
ATOM    502  CG2 ILE A  67       8.487  -1.618  -3.517  1.00 24.92           C  
ATOM    503  CD1 ILE A  67       6.008  -1.648  -1.558  1.00 28.04           C  
ATOM    504  N   LEU A  68       7.858  -1.677  -7.007  1.00 23.86           N  
ATOM    505  CA  LEU A  68       8.857  -1.972  -8.038  1.00 27.54           C  
ATOM    506  C   LEU A  68       9.002  -0.829  -9.030  1.00 25.75           C  
ATOM    507  O   LEU A  68      10.097  -0.499  -9.527  1.00 25.33           O  
ATOM    508  CB  LEU A  68       8.482  -3.247  -8.789  1.00 26.05           C  
ATOM    509  CG  LEU A  68       8.696  -4.588  -8.069  1.00 24.54           C  
ATOM    510  CD1 LEU A  68       7.950  -5.694  -8.815  1.00 25.25           C  
ATOM    511  CD2 LEU A  68      10.197  -4.888  -7.937  1.00 29.95           C  
ATOM    512  N   ARG A  69       7.888  -0.199  -9.339  1.00 25.81           N  
ATOM    513  CA  ARG A  69       7.938   0.921 -10.265  1.00 26.41           C  
ATOM    514  C   ARG A  69       8.635   2.130  -9.696  1.00 26.64           C  
ATOM    515  O   ARG A  69       9.205   2.916 -10.442  1.00 34.92           O  
ATOM    516  CB  ARG A  69       6.537   1.338 -10.690  1.00 35.07           C  
ATOM    517  CG  ARG A  69       5.983   0.476 -11.752  1.00 33.22           C  
ATOM    518  CD  ARG A  69       4.625   0.977 -12.119  1.00 43.59           C  
ATOM    519  NE  ARG A  69       4.088   0.209 -13.233  1.00 44.11           N  
ATOM    520  CZ  ARG A  69       2.807  -0.098 -13.387  1.00 42.79           C  
ATOM    521  NH1 ARG A  69       1.879   0.302 -12.503  1.00 49.46           N  
ATOM    522  NH2 ARG A  69       2.448  -0.809 -14.445  1.00 54.49           N  
ATOM    523  N   GLU A  70       8.527   2.354  -8.393  1.00 26.81           N  
ATOM    524  CA  GLU A  70       9.164   3.531  -7.794  1.00 25.34           C  
ATOM    525  C   GLU A  70      10.670   3.381  -7.642  1.00 30.95           C  
ATOM    526  O   GLU A  70      11.410   4.354  -7.689  1.00 31.42           O  
ATOM    527  CB  GLU A  70       8.547   3.844  -6.429  1.00 30.59           C  
ATOM    528  CG  GLU A  70       9.259   5.010  -5.713  1.00 40.95           C  
ATOM    529  CD  GLU A  70       8.652   5.359  -4.360  1.00 51.32           C  
ATOM    530  OE1 GLU A  70       7.757   4.624  -3.902  1.00 39.69           O  
ATOM    531  OE2 GLU A  70       9.076   6.379  -3.771  1.00 45.83           O  
ATOM    532  N   ILE A  71      11.150   2.163  -7.471  1.00 23.88           N  
ATOM    533  CA  ILE A  71      12.508   1.999  -6.971  1.00 26.64           C  
ATOM    534  C   ILE A  71      13.475   1.825  -8.153  1.00 30.26           C  
ATOM    535  O   ILE A  71      13.175   1.118  -9.127  1.00 28.35           O  
ATOM    536  CB  ILE A  71      12.599   0.826  -5.910  1.00 28.53           C  
ATOM    537  CG1 ILE A  71      12.162  -0.496  -6.514  1.00 30.28           C  
ATOM    538  CG2 ILE A  71      11.756   1.141  -4.601  1.00 24.69           C  
ATOM    539  CD1 ILE A  71      11.995  -1.609  -5.478  1.00 26.93           C  
ATOM    540  N   ARG A  72      14.633   2.475  -8.054  1.00 26.58           N  
ATOM    541  CA  ARG A  72      15.705   2.414  -9.057  1.00 25.59           C  
ATOM    542  C   ARG A  72      17.022   2.538  -8.328  1.00 23.84           C  
ATOM    543  O   ARG A  72      17.373   3.607  -7.834  1.00 24.87           O  
ATOM    544  CB  ARG A  72      15.613   3.554 -10.095  0.50 31.83           C  
ATOM    546  CG  ARG A  72      16.623   3.406 -11.238  0.50 31.07           C  
ATOM    548  CD  ARG A  72      16.580   4.568 -12.244  0.50 47.74           C  
ATOM    550  NE  ARG A  72      16.973   5.836 -11.637  0.50 33.65           N  
ATOM    552  CZ  ARG A  72      16.387   6.995 -11.908  0.50 55.92           C  
ATOM    554  NH1 ARG A  72      15.381   7.046 -12.768  0.50 59.57           N  
ATOM    556  NH2 ARG A  72      16.802   8.101 -11.310  0.50 63.07           N  
ATOM    558  N   HIS A  73      17.739   1.449  -8.257  1.00 20.31           N  
ATOM    559  CA  HIS A  73      19.022   1.425  -7.533  1.00 24.37           C  
ATOM    560  C   HIS A  73      19.829   0.270  -8.065  1.00 19.75           C  
ATOM    561  O   HIS A  73      19.276  -0.783  -8.356  1.00 23.39           O  
ATOM    562  CB  HIS A  73      18.792   1.265  -6.041  1.00 22.97           C  
ATOM    563  CG  HIS A  73      20.036   1.374  -5.210  1.00 23.27           C  
ATOM    564  ND1 HIS A  73      20.867   0.297  -4.968  1.00 22.34           N  
ATOM    565  CD2 HIS A  73      20.577   2.427  -4.549  1.00 27.90           C  
ATOM    566  CE1 HIS A  73      21.863   0.680  -4.180  1.00 27.68           C  
ATOM    567  NE2 HIS A  73      21.716   1.974  -3.915  1.00 24.71           N  
ATOM    568  N   PRO A  74      21.179   0.438  -8.181  1.00 21.86           N  
ATOM    569  CA  PRO A  74      21.978  -0.671  -8.731  1.00 24.51           C  
ATOM    570  C   PRO A  74      21.839  -2.013  -8.021  1.00 21.83           C  
ATOM    571  O   PRO A  74      22.013  -3.038  -8.642  1.00 23.14           O  
ATOM    572  CB  PRO A  74      23.411  -0.188  -8.580  1.00 26.47           C  
ATOM    573  CG  PRO A  74      23.322   1.294  -8.456  1.00 31.42           C  
ATOM    574  CD  PRO A  74      21.994   1.631  -7.882  1.00 26.05           C  
ATOM    575  N   ASN A  75      21.550  -2.022  -6.722  1.00 22.08           N  
ATOM    576  CA  ASN A  75      21.436  -3.280  -5.967  1.00 20.62           C  
ATOM    577  C   ASN A  75      19.998  -3.749  -5.745  1.00 22.28           C  
ATOM    578  O   ASN A  75      19.752  -4.544  -4.842  1.00 24.66           O  
ATOM    579  CB  ASN A  75      22.114  -3.126  -4.592  1.00 23.89           C  
ATOM    580  CG  ASN A  75      23.588  -2.917  -4.699  1.00 25.33           C  
ATOM    581  OD1 ASN A  75      24.099  -1.853  -4.358  1.00 23.88           O  
ATOM    582  ND2 ASN A  75      24.293  -3.938  -5.141  1.00 24.82           N  
ATOM    583  N   ILE A  76      19.067  -3.256  -6.559  1.00 21.16           N  
ATOM    584  CA  ILE A  76      17.653  -3.600  -6.509  1.00 21.23           C  
ATOM    585  C   ILE A  76      17.192  -4.021  -7.915  1.00 20.94           C  
ATOM    586  O   ILE A  76      17.540  -3.370  -8.918  1.00 21.97           O  
ATOM    587  CB  ILE A  76      16.772  -2.466  -5.970  1.00 24.56           C  
ATOM    588  CG1 ILE A  76      17.168  -2.143  -4.527  1.00 23.95           C  
ATOM    589  CG2 ILE A  76      15.274  -2.893  -5.988  1.00 25.95           C  
ATOM    590  CD1 ILE A  76      16.416  -0.995  -3.983  1.00 27.42           C  
ATOM    591  N   ILE A  77      16.451  -5.139  -7.959  1.00 20.73           N  
ATOM    592  CA  ILE A  77      15.909  -5.688  -9.209  1.00 20.42           C  
ATOM    593  C   ILE A  77      15.104  -4.656  -9.979  1.00 21.41           C  
ATOM    594  O   ILE A  77      14.387  -3.877  -9.376  1.00 23.95           O  
ATOM    595  CB  ILE A  77      15.041  -6.952  -8.976  1.00 20.67           C  
ATOM    596  CG1 ILE A  77      14.931  -7.787 -10.242  1.00 22.86           C  
ATOM    597  CG2 ILE A  77      13.680  -6.634  -8.342  1.00 22.59           C  
ATOM    598  CD1 ILE A  77      16.242  -8.494 -10.633  1.00 24.30           C  
ATOM    599  N   THR A  78      15.207  -4.687 -11.313  1.00 21.82           N  
ATOM    600  CA  THR A  78      14.425  -3.813 -12.169  1.00 23.96           C  
ATOM    601  C   THR A  78      13.233  -4.487 -12.853  1.00 21.32           C  
ATOM    602  O   THR A  78      13.362  -5.557 -13.452  1.00 22.48           O  
ATOM    603  CB  THR A  78      15.300  -3.185 -13.298  1.00 31.24           C  
ATOM    604  OG1 THR A  78      16.335  -2.405 -12.698  1.00 32.01           O  
ATOM    605  CG2 THR A  78      14.460  -2.260 -14.168  1.00 29.26           C  
ATOM    606  N   LEU A  79      12.078  -3.836 -12.721  1.00 24.16           N  
ATOM    607  CA  LEU A  79      10.894  -4.165 -13.467  1.00 21.40           C  
ATOM    608  C   LEU A  79      10.935  -3.578 -14.861  1.00 23.51           C  
ATOM    609  O   LEU A  79      10.977  -2.343 -15.047  1.00 25.11           O  
ATOM    610  CB  LEU A  79       9.640  -3.690 -12.728  1.00 19.93           C  
ATOM    611  CG  LEU A  79       8.288  -4.107 -13.355  1.00 23.89           C  
ATOM    612  CD1 LEU A  79       8.022  -5.605 -13.260  1.00 22.38           C  
ATOM    613  CD2 LEU A  79       7.082  -3.344 -12.736  1.00 31.56           C  
ATOM    614  N   HIS A  80      10.859  -4.445 -15.856  1.00 23.69           N  
ATOM    615  CA  HIS A  80      10.926  -4.017 -17.259  1.00 23.52           C  
ATOM    616  C   HIS A  80       9.562  -3.772 -17.913  1.00 27.34           C  
ATOM    617  O   HIS A  80       9.384  -2.811 -18.671  1.00 25.04           O  
ATOM    618  CB  HIS A  80      11.743  -5.037 -18.041  1.00 25.54           C  
ATOM    619  CG  HIS A  80      11.759  -4.803 -19.509  1.00 31.93           C  
ATOM    620  ND1 HIS A  80      12.497  -3.797 -20.080  1.00 31.16           N  
ATOM    621  CD2 HIS A  80      11.117  -5.432 -20.524  1.00 31.48           C  
ATOM    622  CE1 HIS A  80      12.327  -3.822 -21.391  1.00 39.86           C  
ATOM    623  NE2 HIS A  80      11.511  -4.818 -21.689  1.00 31.84           N  
ATOM    624  N   ASP A  81       8.595  -4.627 -17.628  1.00 22.21           N  
ATOM    625  CA  ASP A  81       7.298  -4.529 -18.224  1.00 21.69           C  
ATOM    626  C   ASP A  81       6.321  -5.338 -17.355  1.00 24.11           C  
ATOM    627  O   ASP A  81       6.713  -5.980 -16.355  1.00 23.74           O  
ATOM    628  CB  ASP A  81       7.353  -5.110 -19.640  1.00 23.41           C  
ATOM    629  CG  ASP A  81       6.335  -4.491 -20.616  1.00 31.08           C  
ATOM    630  OD1 ASP A  81       5.413  -3.748 -20.200  1.00 27.70           O  
ATOM    631  OD2 ASP A  81       6.457  -4.816 -21.827  1.00 35.36           O  
ATOM    632  N   ILE A  82       5.053  -5.263 -17.727  1.00 24.89           N  
ATOM    633  CA  ILE A  82       3.978  -5.910 -16.996  1.00 23.52           C  
ATOM    634  C   ILE A  82       2.845  -6.188 -17.966  1.00 26.19           C  
ATOM    635  O   ILE A  82       2.564  -5.373 -18.843  1.00 24.62           O  
ATOM    636  CB  ILE A  82       3.504  -5.056 -15.822  1.00 24.75           C  
ATOM    637  CG1 ILE A  82       2.468  -5.795 -14.969  1.00 32.52           C  
ATOM    638  CG2 ILE A  82       2.857  -3.768 -16.315  1.00 32.99           C  
ATOM    639  CD1 ILE A  82       2.360  -5.240 -13.560  1.00 34.11           C  
ATOM    640  N   PHE A  83       2.194  -7.339 -17.824  1.00 23.66           N  
ATOM    641  CA  PHE A  83       0.907  -7.547 -18.477  1.00 22.97           C  
ATOM    642  C   PHE A  83      -0.001  -8.396 -17.616  1.00 27.56           C  
ATOM    643  O   PHE A  83       0.394  -8.897 -16.582  1.00 25.01           O  
ATOM    644  CB  PHE A  83       1.058  -8.128 -19.889  1.00 25.90           C  
ATOM    645  CG  PHE A  83       1.647  -9.511 -19.945  1.00 24.53           C  
ATOM    646  CD1 PHE A  83       3.016  -9.679 -20.141  1.00 26.35           C  
ATOM    647  CD2 PHE A  83       0.830 -10.651 -19.886  1.00 29.22           C  
ATOM    648  CE1 PHE A  83       3.577 -10.954 -20.216  1.00 27.61           C  
ATOM    649  CE2 PHE A  83       1.382 -11.946 -19.957  1.00 29.39           C  
ATOM    650  CZ  PHE A  83       2.769 -12.092 -20.130  1.00 31.98           C  
ATOM    651  N   GLU A  84      -1.243  -8.536 -18.047  1.00 24.65           N  
ATOM    652  CA  GLU A  84      -2.200  -9.299 -17.307  1.00 20.73           C  
ATOM    653  C   GLU A  84      -3.044 -10.108 -18.277  1.00 28.82           C  
ATOM    654  O   GLU A  84      -3.332  -9.661 -19.363  1.00 29.36           O  
ATOM    655  CB  GLU A  84      -3.054  -8.353 -16.470  1.00 25.13           C  
ATOM    656  CG  GLU A  84      -4.232  -9.005 -15.769  1.00 26.94           C  
ATOM    657  CD  GLU A  84      -5.003  -8.049 -14.875  1.00 39.72           C  
ATOM    658  OE1 GLU A  84      -4.545  -6.907 -14.619  1.00 30.98           O  
ATOM    659  OE2 GLU A  84      -6.072  -8.467 -14.392  1.00 32.41           O  
ATOM    660  N   ASN A  85      -3.400 -11.325 -17.889  1.00 25.12           N  
ATOM    661  CA  ASN A  85      -4.326 -12.127 -18.682  1.00 27.13           C  
ATOM    662  C   ASN A  85      -5.459 -12.561 -17.760  1.00 23.92           C  
ATOM    663  O   ASN A  85      -5.640 -11.984 -16.712  1.00 31.85           O  
ATOM    664  CB  ASN A  85      -3.587 -13.294 -19.361  1.00 26.33           C  
ATOM    665  CG  ASN A  85      -2.892 -14.205 -18.383  1.00 30.60           C  
ATOM    666  OD1 ASN A  85      -3.282 -14.293 -17.233  1.00 30.94           O  
ATOM    667  ND2 ASN A  85      -1.848 -14.871 -18.827  1.00 31.03           N  
ATOM    668  N   LYS A  86      -6.218 -13.572 -18.153  1.00 27.79           N  
ATOM    669  CA  LYS A  86      -7.397 -14.003 -17.404  1.00 26.12           C  
ATOM    670  C   LYS A  86      -7.082 -14.439 -15.990  1.00 26.41           C  
ATOM    671  O   LYS A  86      -7.857 -14.153 -15.058  1.00 30.57           O  
ATOM    672  CB  LYS A  86      -8.146 -15.126 -18.169  1.00 31.91           C  
ATOM    673  CG  LYS A  86      -9.073 -14.610 -19.285  1.00 42.93           C  
ATOM    674  N   THR A  87      -5.925 -15.092 -15.814  1.00 27.96           N  
ATOM    675  CA  THR A  87      -5.603 -15.776 -14.579  1.00 28.48           C  
ATOM    676  C   THR A  87      -4.486 -15.136 -13.764  1.00 21.81           C  
ATOM    677  O   THR A  87      -4.485 -15.263 -12.557  1.00 23.98           O  
ATOM    678  CB  THR A  87      -5.236 -17.239 -14.861  1.00 29.09           C  
ATOM    679  OG1 THR A  87      -4.213 -17.304 -15.858  1.00 30.76           O  
ATOM    680  CG2 THR A  87      -6.460 -17.991 -15.369  1.00 33.84           C  
ATOM    681  N   ASP A  88      -3.562 -14.459 -14.441  1.00 24.53           N  
ATOM    682  CA  ASP A  88      -2.299 -13.968 -13.818  1.00 23.54           C  
ATOM    683  C   ASP A  88      -2.011 -12.519 -14.164  1.00 26.38           C  
ATOM    684  O   ASP A  88      -2.426 -12.036 -15.202  1.00 26.80           O  
ATOM    685  CB  ASP A  88      -1.122 -14.825 -14.307  1.00 28.37           C  
ATOM    686  CG  ASP A  88      -1.212 -16.304 -13.850  1.00 27.69           C  
ATOM    687  OD1 ASP A  88      -0.739 -16.658 -12.745  1.00 29.84           O  
ATOM    688  OD2 ASP A  88      -1.667 -17.138 -14.652  1.00 40.00           O  
ATOM    689  N   VAL A  89      -1.290 -11.835 -13.281  1.00 22.86           N  
ATOM    690  CA  VAL A  89      -0.548 -10.612 -13.618  1.00 19.50           C  
ATOM    691  C   VAL A  89       0.919 -11.019 -13.768  1.00 25.88           C  
ATOM    692  O   VAL A  89       1.436 -11.725 -12.900  1.00 24.89           O  
ATOM    693  CB  VAL A  89      -0.645  -9.602 -12.486  1.00 21.17           C  
ATOM    694  CG1 VAL A  89       0.227  -8.363 -12.752  1.00 25.45           C  
ATOM    695  CG2 VAL A  89      -2.092  -9.181 -12.291  1.00 22.31           C  
ATOM    696  N   VAL A  90       1.558 -10.601 -14.865  1.00 22.19           N  
ATOM    697  CA  VAL A  90       2.893 -11.090 -15.185  1.00 22.40           C  
ATOM    698  C   VAL A  90       3.861  -9.934 -15.102  1.00 25.04           C  
ATOM    699  O   VAL A  90       3.723  -8.964 -15.861  1.00 23.56           O  
ATOM    700  CB  VAL A  90       2.909 -11.776 -16.539  1.00 20.90           C  
ATOM    701  CG1 VAL A  90       4.286 -12.430 -16.817  1.00 20.33           C  
ATOM    702  CG2 VAL A  90       1.736 -12.846 -16.582  1.00 24.99           C  
ATOM    703  N   LEU A  91       4.835 -10.050 -14.187  1.00 24.29           N  
ATOM    704  CA  LEU A  91       5.875  -9.078 -14.064  1.00 19.49           C  
ATOM    705  C   LEU A  91       7.074  -9.521 -14.891  1.00 23.25           C  
ATOM    706  O   LEU A  91       7.592 -10.635 -14.712  1.00 22.20           O  
ATOM    707  CB  LEU A  91       6.297  -8.892 -12.605  1.00 24.31           C  
ATOM    708  CG  LEU A  91       5.381  -8.086 -11.695  1.00 32.20           C  
ATOM    709  CD1 LEU A  91       3.961  -8.362 -11.908  1.00 29.67           C  
ATOM    710  CD2 LEU A  91       5.807  -8.333 -10.281  1.00 25.83           C  
ATOM    711  N   ILE A  92       7.503  -8.659 -15.796  1.00 20.65           N  
ATOM    712  CA  ILE A  92       8.696  -8.938 -16.602  1.00 20.31           C  
ATOM    713  C   ILE A  92       9.878  -8.228 -15.956  1.00 20.93           C  
ATOM    714  O   ILE A  92       9.963  -7.003 -15.976  1.00 20.73           O  
ATOM    715  CB  ILE A  92       8.536  -8.482 -18.082  1.00 22.55           C  
ATOM    716  CG1 ILE A  92       7.290  -9.102 -18.756  1.00 21.49           C  
ATOM    717  CG2 ILE A  92       9.782  -8.872 -18.929  1.00 21.52           C  
ATOM    718  CD1 ILE A  92       7.255 -10.634 -18.692  1.00 23.51           C  
ATOM    719  N   LEU A  93      10.779  -9.025 -15.390  1.00 19.92           N  
ATOM    720  CA  LEU A  93      11.892  -8.541 -14.585  1.00 20.98           C  
ATOM    721  C   LEU A  93      13.221  -8.811 -15.264  1.00 22.25           C  
ATOM    722  O   LEU A  93      13.364  -9.781 -16.005  1.00 23.33           O  
ATOM    723  CB  LEU A  93      11.855  -9.249 -13.219  1.00 22.86           C  
ATOM    724  CG  LEU A  93      10.642  -8.862 -12.365  1.00 24.78           C  
ATOM    725  CD1 LEU A  93      10.106 -10.108 -11.661  1.00 23.94           C  
ATOM    726  CD2 LEU A  93      11.027  -7.689 -11.402  1.00 21.00           C  
ATOM    727  N   GLU A  94      14.192  -7.942 -14.988  1.00 22.47           N  
ATOM    728  CA  GLU A  94      15.601  -8.144 -15.310  1.00 23.35           C  
ATOM    729  C   GLU A  94      16.028  -9.583 -15.006  1.00 23.58           C  
ATOM    730  O   GLU A  94      15.785 -10.074 -13.890  1.00 22.74           O  
ATOM    731  CB  GLU A  94      16.372  -7.195 -14.380  1.00 28.49           C  
ATOM    732  CG  GLU A  94      17.817  -7.342 -14.293  1.00 39.67           C  
ATOM    733  CD  GLU A  94      18.443  -6.253 -13.449  1.00 33.52           C  
ATOM    734  OE1 GLU A  94      17.780  -5.647 -12.524  1.00 27.11           O  
ATOM    735  OE2 GLU A  94      19.627  -6.033 -13.698  1.00 46.43           O  
ATOM    736  N   LEU A  95      16.654 -10.250 -15.979  1.00 22.23           N  
ATOM    737  CA  LEU A  95      17.183 -11.606 -15.750  1.00 22.86           C  
ATOM    738  C   LEU A  95      18.521 -11.534 -15.058  1.00 22.75           C  
ATOM    739  O   LEU A  95      19.433 -10.827 -15.504  1.00 27.21           O  
ATOM    740  CB  LEU A  95      17.331 -12.384 -17.059  1.00 22.60           C  
ATOM    741  CG  LEU A  95      17.762 -13.868 -16.924  1.00 23.15           C  
ATOM    742  CD1 LEU A  95      16.672 -14.692 -16.340  1.00 23.00           C  
ATOM    743  CD2 LEU A  95      18.175 -14.414 -18.279  1.00 22.70           C  
ATOM    744  N   VAL A  96      18.624 -12.235 -13.945  1.00 21.23           N  
ATOM    745  CA  VAL A  96      19.820 -12.317 -13.107  1.00 21.27           C  
ATOM    746  C   VAL A  96      20.237 -13.791 -13.011  1.00 25.67           C  
ATOM    747  O   VAL A  96      19.490 -14.637 -12.501  1.00 26.93           O  
ATOM    748  CB  VAL A  96      19.585 -11.716 -11.699  1.00 25.13           C  
ATOM    749  CG1 VAL A  96      20.864 -11.745 -10.854  1.00 26.68           C  
ATOM    750  CG2 VAL A  96      19.093 -10.296 -11.827  1.00 26.30           C  
ATOM    751  N   SER A  97      21.446 -14.086 -13.497  1.00 25.82           N  
ATOM    752  CA  SER A  97      21.842 -15.487 -13.751  1.00 27.29           C  
ATOM    753  C   SER A  97      22.864 -16.086 -12.806  1.00 26.04           C  
ATOM    754  O   SER A  97      23.242 -17.250 -13.012  1.00 26.17           O  
ATOM    755  CB  SER A  97      22.364 -15.603 -15.187  1.00 32.84           C  
ATOM    756  OG  SER A  97      21.354 -15.158 -16.054  1.00 32.25           O  
ATOM    757  N   GLY A  98      23.292 -15.360 -11.759  1.00 23.12           N  
ATOM    758  CA  GLY A  98      24.298 -15.907 -10.828  1.00 23.20           C  
ATOM    759  C   GLY A  98      23.790 -16.595  -9.589  1.00 25.74           C  
ATOM    760  O   GLY A  98      24.561 -16.888  -8.698  1.00 26.85           O  
ATOM    761  N   GLY A  99      22.507 -16.916  -9.544  1.00 23.54           N  
ATOM    762  CA  GLY A  99      21.940 -17.658  -8.415  1.00 25.45           C  
ATOM    763  C   GLY A  99      21.658 -16.732  -7.259  1.00 23.58           C  
ATOM    764  O   GLY A  99      21.709 -15.528  -7.426  1.00 23.59           O  
ATOM    765  N   GLU A 100      21.298 -17.321  -6.111  1.00 24.08           N  
ATOM    766  CA  GLU A 100      20.956 -16.593  -4.893  1.00 24.16           C  
ATOM    767  C   GLU A 100      22.148 -16.614  -3.957  1.00 22.65           C  
ATOM    768  O   GLU A 100      23.022 -17.485  -4.048  1.00 25.15           O  
ATOM    769  CB  GLU A 100      19.761 -17.266  -4.177  1.00 27.77           C  
ATOM    770  CG  GLU A 100      18.531 -17.514  -4.998  1.00 29.84           C  
ATOM    771  CD  GLU A 100      17.519 -18.462  -4.381  1.00 45.74           C  
ATOM    772  OE1 GLU A 100      17.807 -19.145  -3.351  1.00 33.73           O  
ATOM    773  OE2 GLU A 100      16.409 -18.511  -4.965  1.00 47.41           O  
ATOM    774  N   LEU A 101      22.150 -15.711  -3.009  1.00 24.83           N  
ATOM    775  CA  LEU A 101      23.190 -15.691  -1.970  1.00 24.79           C  
ATOM    776  C   LEU A 101      23.086 -16.983  -1.148  1.00 22.71           C  
ATOM    777  O   LEU A 101      24.081 -17.460  -0.642  1.00 24.22           O  
ATOM    778  CB  LEU A 101      23.044 -14.454  -1.080  1.00 26.22           C  
ATOM    779  CG  LEU A 101      24.099 -14.177   0.003  1.00 23.46           C  
ATOM    780  CD1 LEU A 101      25.533 -14.269  -0.580  1.00 25.72           C  
ATOM    781  CD2 LEU A 101      23.793 -12.761   0.664  1.00 24.00           C  
ATOM    782  N   PHE A 102      21.859 -17.509  -1.029  1.00 26.40           N  
ATOM    783  CA  PHE A 102      21.574 -18.781  -0.377  1.00 28.51           C  
ATOM    784  C   PHE A 102      22.440 -19.926  -0.957  1.00 28.54           C  
ATOM    785  O   PHE A 102      23.128 -20.673  -0.214  1.00 26.06           O  
ATOM    786  CB  PHE A 102      20.076 -19.079  -0.513  1.00 29.63           C  
ATOM    787  CG  PHE A 102      19.670 -20.397   0.030  1.00 25.31           C  
ATOM    788  CD1 PHE A 102      19.433 -20.571   1.389  1.00 35.23           C  
ATOM    789  CD2 PHE A 102      19.568 -21.527  -0.829  1.00 35.26           C  
ATOM    790  CE1 PHE A 102      19.101 -21.830   1.906  1.00 37.28           C  
ATOM    791  CE2 PHE A 102      19.232 -22.780  -0.313  1.00 48.13           C  
ATOM    792  CZ  PHE A 102      19.001 -22.933   1.059  1.00 33.08           C  
ATOM    793  N   ASP A 103      22.427 -20.017  -2.281  1.00 28.14           N  
ATOM    794  CA  ASP A 103      23.227 -21.024  -3.029  1.00 27.90           C  
ATOM    795  C   ASP A 103      24.749 -20.801  -2.847  1.00 22.69           C  
ATOM    796  O   ASP A 103      25.537 -21.724  -2.684  1.00 28.27           O  
ATOM    797  CB  ASP A 103      22.938 -20.921  -4.522  1.00 29.67           C  
ATOM    798  CG  ASP A 103      21.450 -21.042  -4.886  1.00 47.06           C  
ATOM    799  OD1 ASP A 103      20.800 -21.989  -4.403  1.00 36.28           O  
ATOM    800  OD2 ASP A 103      20.954 -20.223  -5.727  1.00 40.47           O  
ATOM    801  N   PHE A 104      25.154 -19.538  -2.930  1.00 26.33           N  
ATOM    802  CA  PHE A 104      26.562 -19.156  -2.851  1.00 27.91           C  
ATOM    803  C   PHE A 104      27.143 -19.553  -1.502  1.00 28.18           C  
ATOM    804  O   PHE A 104      28.219 -20.159  -1.427  1.00 27.73           O  
ATOM    805  CB  PHE A 104      26.697 -17.652  -3.084  1.00 28.99           C  
ATOM    806  CG  PHE A 104      28.105 -17.178  -3.252  1.00 28.23           C  
ATOM    807  CD1 PHE A 104      28.710 -17.204  -4.503  1.00 27.17           C  
ATOM    808  CD2 PHE A 104      28.831 -16.710  -2.171  1.00 27.03           C  
ATOM    809  CE1 PHE A 104      30.003 -16.760  -4.680  1.00 30.36           C  
ATOM    810  CE2 PHE A 104      30.137 -16.279  -2.345  1.00 30.57           C  
ATOM    811  CZ  PHE A 104      30.706 -16.285  -3.619  1.00 27.03           C  
ATOM    812  N   LEU A 105      26.427 -19.199  -0.442  1.00 27.12           N  
ATOM    813  CA  LEU A 105      26.821 -19.544   0.925  1.00 29.55           C  
ATOM    814  C   LEU A 105      26.874 -21.081   1.146  1.00 28.62           C  
ATOM    815  O   LEU A 105      27.820 -21.586   1.759  1.00 27.97           O  
ATOM    816  CB  LEU A 105      25.883 -18.856   1.951  1.00 28.98           C  
ATOM    817  CG  LEU A 105      26.075 -19.168   3.465  1.00 29.67           C  
ATOM    818  CD1 LEU A 105      27.436 -18.673   4.045  1.00 28.67           C  
ATOM    819  CD2 LEU A 105      24.893 -18.619   4.282  1.00 33.09           C  
ATOM    820  N   ALA A 106      25.892 -21.796   0.609  1.00 29.00           N  
ATOM    821  CA  ALA A 106      25.806 -23.256   0.720  1.00 26.26           C  
ATOM    822  C   ALA A 106      27.046 -23.874   0.097  1.00 29.82           C  
ATOM    823  O   ALA A 106      27.568 -24.826   0.640  1.00 34.24           O  
ATOM    824  CB  ALA A 106      24.546 -23.777   0.082  1.00 30.32           C  
ATOM    825  N   GLU A 107      27.572 -23.273  -0.979  1.00 25.84           N  
ATOM    826  CA  GLU A 107      28.780 -23.795  -1.648  1.00 29.54           C  
ATOM    827  C   GLU A 107      30.061 -23.457  -0.857  1.00 32.56           C  
ATOM    828  O   GLU A 107      30.984 -24.261  -0.766  1.00 31.10           O  
ATOM    829  CB  GLU A 107      28.905 -23.192  -3.052  1.00 32.49           C  
ATOM    830  CG  GLU A 107      27.773 -23.485  -3.988  1.00 50.43           C  
ATOM    831  CD  GLU A 107      28.023 -24.692  -4.877  1.00 52.40           C  
ATOM    832  OE1 GLU A 107      28.782 -25.605  -4.485  1.00 45.28           O  
ATOM    833  OE2 GLU A 107      27.450 -24.707  -5.978  1.00 45.32           O  
ATOM    834  N   LYS A 108      30.119 -22.260  -0.298  1.00 28.96           N  
ATOM    835  CA  LYS A 108      31.295 -21.814   0.451  1.00 30.56           C  
ATOM    836  C   LYS A 108      31.307 -22.324   1.891  1.00 27.15           C  
ATOM    837  O   LYS A 108      32.369 -22.315   2.526  1.00 33.48           O  
ATOM    838  CB  LYS A 108      31.362 -20.280   0.493  1.00 38.43           C  
ATOM    839  CG  LYS A 108      31.328 -19.591  -0.890  1.00 39.83           C  
ATOM    840  CD  LYS A 108      32.713 -19.288  -1.405  1.00 47.80           C  
ATOM    841  CE  LYS A 108      33.290 -18.042  -0.748  1.00 50.06           C  
ATOM    842  NZ  LYS A 108      34.675 -17.808  -1.219  1.00 43.36           N  
ATOM    843  N   GLU A 109      30.153 -22.772   2.393  1.00 29.27           N  
ATOM    844  CA  GLU A 109      29.934 -23.168   3.811  1.00 26.84           C  
ATOM    845  C   GLU A 109      29.795 -21.965   4.753  1.00 32.73           C  
ATOM    846  O   GLU A 109      28.784 -21.839   5.466  1.00 28.42           O  
ATOM    847  CB  GLU A 109      31.010 -24.093   4.344  1.00 30.80           C  
ATOM    848  CG  GLU A 109      31.297 -25.272   3.431  1.00 51.17           C  
ATOM    849  CD  GLU A 109      32.397 -26.189   3.975  1.00 60.19           C  
ATOM    850  OE1 GLU A 109      32.282 -26.631   5.144  1.00 56.02           O  
ATOM    851  OE2 GLU A 109      33.364 -26.466   3.223  1.00 58.18           O  
ATOM    852  N   SER A 110      30.828 -21.112   4.764  1.00 28.17           N  
ATOM    853  CA  SER A 110      30.784 -19.817   5.456  1.00 29.21           C  
ATOM    854  C   SER A 110      31.731 -18.834   4.778  1.00 32.36           C  
ATOM    855  O   SER A 110      32.618 -19.209   3.974  1.00 27.37           O  
ATOM    856  CB  SER A 110      31.160 -19.964   6.937  1.00 30.78           C  
ATOM    857  OG  SER A 110      32.486 -20.440   7.064  1.00 28.77           O  
ATOM    858  N   LEU A 111      31.523 -17.566   5.076  1.00 26.69           N  
ATOM    859  CA  LEU A 111      32.343 -16.504   4.488  1.00 24.64           C  
ATOM    860  C   LEU A 111      33.275 -15.906   5.526  1.00 27.48           C  
ATOM    861  O   LEU A 111      32.953 -15.855   6.724  1.00 27.21           O  
ATOM    862  CB  LEU A 111      31.457 -15.367   3.942  1.00 27.02           C  
ATOM    863  CG  LEU A 111      30.417 -15.738   2.908  1.00 28.57           C  
ATOM    864  CD1 LEU A 111      29.806 -14.464   2.370  1.00 25.47           C  
ATOM    865  CD2 LEU A 111      31.021 -16.566   1.800  1.00 27.44           C  
ATOM    866  N   THR A 112      34.404 -15.401   5.045  1.00 26.16           N  
ATOM    867  CA  THR A 112      35.300 -14.659   5.885  1.00 22.98           C  
ATOM    868  C   THR A 112      34.654 -13.312   6.135  1.00 28.09           C  
ATOM    869  O   THR A 112      33.687 -12.955   5.458  1.00 25.47           O  
ATOM    870  CB  THR A 112      36.686 -14.429   5.224  1.00 26.11           C  
ATOM    871  OG1 THR A 112      36.543 -13.556   4.086  1.00 28.07           O  
ATOM    872  CG2 THR A 112      37.383 -15.753   4.853  1.00 24.37           C  
ATOM    873  N   GLU A 113      35.192 -12.558   7.094  1.00 25.78           N  
ATOM    874  CA  GLU A 113      34.662 -11.239   7.399  1.00 26.12           C  
ATOM    875  C   GLU A 113      34.815 -10.282   6.220  1.00 26.13           C  
ATOM    876  O   GLU A 113      33.913  -9.460   5.978  1.00 26.54           O  
ATOM    877  CB  GLU A 113      35.274 -10.659   8.688  1.00 33.65           C  
ATOM    878  CG  GLU A 113      34.830 -11.451   9.917  1.00 28.84           C  
ATOM    879  CD  GLU A 113      35.237 -10.833  11.257  1.00 33.53           C  
ATOM    880  OE1 GLU A 113      35.260  -9.575  11.406  1.00 26.35           O  
ATOM    881  OE2 GLU A 113      35.476 -11.631  12.199  1.00 36.85           O  
ATOM    882  N   ASP A 114      35.921 -10.394   5.484  1.00 25.01           N  
ATOM    883  CA  ASP A 114      36.117  -9.542   4.296  1.00 28.68           C  
ATOM    884  C   ASP A 114      35.078  -9.894   3.219  1.00 26.02           C  
ATOM    885  O   ASP A 114      34.481  -9.005   2.614  1.00 28.44           O  
ATOM    886  CB  ASP A 114      37.518  -9.707   3.699  1.00 27.14           C  
ATOM    887  CG  ASP A 114      38.618  -8.947   4.478  1.00 47.39           C  
ATOM    888  OD1 ASP A 114      38.359  -8.288   5.520  1.00 36.02           O  
ATOM    889  OD2 ASP A 114      39.773  -9.023   4.008  1.00 42.28           O  
ATOM    890  N   GLU A 115      34.852 -11.191   2.990  1.00 24.95           N  
ATOM    891  CA  GLU A 115      33.824 -11.645   2.033  1.00 26.89           C  
ATOM    892  C   GLU A 115      32.405 -11.234   2.466  1.00 24.35           C  
ATOM    893  O   GLU A 115      31.627 -10.740   1.670  1.00 23.26           O  
ATOM    894  CB  GLU A 115      33.872 -13.165   1.840  1.00 29.15           C  
ATOM    895  CG  GLU A 115      35.067 -13.672   1.045  1.00 34.61           C  
ATOM    896  CD  GLU A 115      35.316 -15.209   1.160  1.00 36.22           C  
ATOM    897  OE1 GLU A 115      34.800 -15.907   2.071  1.00 28.76           O  
ATOM    898  OE2 GLU A 115      36.055 -15.721   0.302  1.00 43.54           O  
ATOM    899  N   ALA A 116      32.109 -11.407   3.757  1.00 25.39           N  
ATOM    900  CA  ALA A 116      30.802 -11.048   4.316  1.00 23.04           C  
ATOM    901  C   ALA A 116      30.531  -9.560   4.157  1.00 25.14           C  
ATOM    902  O   ALA A 116      29.463  -9.194   3.709  1.00 24.76           O  
ATOM    903  CB  ALA A 116      30.663 -11.509   5.783  1.00 23.83           C  
ATOM    904  N   THR A 117      31.503  -8.705   4.496  1.00 24.01           N  
ATOM    905  CA  THR A 117      31.306  -7.278   4.396  1.00 24.10           C  
ATOM    906  C   THR A 117      31.160  -6.781   2.954  1.00 24.39           C  
ATOM    907  O   THR A 117      30.434  -5.800   2.714  1.00 23.70           O  
ATOM    908  CB  THR A 117      32.429  -6.492   5.137  1.00 22.74           C  
ATOM    909  OG1 THR A 117      33.681  -6.946   4.655  1.00 27.66           O  
ATOM    910  CG2 THR A 117      32.368  -6.787   6.622  1.00 25.54           C  
ATOM    911  N   GLN A 118      31.848  -7.416   2.002  1.00 24.55           N  
ATOM    912  CA  GLN A 118      31.653  -7.053   0.587  1.00 26.96           C  
ATOM    913  C   GLN A 118      30.188  -7.245   0.146  1.00 25.91           C  
ATOM    914  O   GLN A 118      29.651  -6.442  -0.621  1.00 25.93           O  
ATOM    915  CB  GLN A 118      32.616  -7.796  -0.343  1.00 26.32           C  
ATOM    916  CG  GLN A 118      34.067  -7.290  -0.271  1.00 37.40           C  
ATOM    917  N   PHE A 119      29.550  -8.316   0.599  1.00 23.13           N  
ATOM    918  CA  PHE A 119      28.118  -8.494   0.355  1.00 22.10           C  
ATOM    919  C   PHE A 119      27.262  -7.509   1.166  1.00 20.01           C  
ATOM    920  O   PHE A 119      26.331  -6.866   0.664  1.00 23.35           O  
ATOM    921  CB  PHE A 119      27.705  -9.913   0.705  1.00 21.74           C  
ATOM    922  CG  PHE A 119      28.030 -10.945  -0.358  1.00 19.87           C  
ATOM    923  CD1 PHE A 119      27.449 -10.893  -1.617  1.00 29.10           C  
ATOM    924  CD2 PHE A 119      28.907 -11.989  -0.086  1.00 23.92           C  
ATOM    925  CE1 PHE A 119      27.726 -11.856  -2.567  1.00 32.21           C  
ATOM    926  CE2 PHE A 119      29.202 -12.944  -1.054  1.00 26.00           C  
ATOM    927  CZ  PHE A 119      28.589 -12.880  -2.284  1.00 26.88           C  
ATOM    928  N   LEU A 120      27.544  -7.430   2.446  1.00 22.04           N  
ATOM    929  CA  LEU A 120      26.770  -6.574   3.339  1.00 23.04           C  
ATOM    930  C   LEU A 120      26.777  -5.121   2.968  1.00 21.56           C  
ATOM    931  O   LEU A 120      25.740  -4.482   3.066  1.00 24.95           O  
ATOM    932  CB  LEU A 120      27.169  -6.789   4.795  1.00 23.13           C  
ATOM    933  CG  LEU A 120      26.661  -8.164   5.324  1.00 29.42           C  
ATOM    934  CD1 LEU A 120      27.410  -8.552   6.589  1.00 35.13           C  
ATOM    935  CD2 LEU A 120      25.094  -8.128   5.562  1.00 32.29           C  
ATOM    936  N   LYS A 121      27.913  -4.589   2.536  1.00 23.11           N  
ATOM    937  CA  LYS A 121      27.929  -3.177   2.079  1.00 21.84           C  
ATOM    938  C   LYS A 121      26.865  -2.931   1.021  1.00 26.62           C  
ATOM    939  O   LYS A 121      26.138  -1.932   1.028  1.00 25.92           O  
ATOM    940  CB  LYS A 121      29.332  -2.806   1.568  1.00 25.99           C  
ATOM    941  CG  LYS A 121      30.214  -2.182   2.668  0.50 33.88           C  
ATOM    943  CD  LYS A 121      31.664  -1.891   2.217  0.50 34.91           C  
ATOM    945  CE  LYS A 121      32.421  -1.062   3.245  0.50 42.77           C  
ATOM    947  NZ  LYS A 121      32.013   0.384   3.324  0.50 37.96           N  
ATOM    949  N   GLN A 122      26.752  -3.863   0.097  1.00 23.27           N  
ATOM    950  CA  GLN A 122      25.750  -3.753  -0.972  1.00 23.45           C  
ATOM    951  C   GLN A 122      24.335  -3.894  -0.474  1.00 22.02           C  
ATOM    952  O   GLN A 122      23.444  -3.152  -0.893  1.00 23.84           O  
ATOM    953  CB  GLN A 122      25.990  -4.831  -2.029  1.00 22.45           C  
ATOM    954  CG  GLN A 122      27.287  -4.623  -2.811  1.00 27.15           C  
ATOM    955  CD  GLN A 122      27.442  -5.691  -3.823  1.00 26.19           C  
ATOM    956  OE1 GLN A 122      26.776  -5.652  -4.840  1.00 23.34           O  
ATOM    957  NE2 GLN A 122      28.263  -6.690  -3.528  1.00 22.82           N  
ATOM    958  N   ILE A 123      24.097  -4.880   0.374  1.00 23.41           N  
ATOM    959  CA  ILE A 123      22.780  -5.040   0.956  1.00 23.11           C  
ATOM    960  C   ILE A 123      22.359  -3.792   1.755  1.00 25.24           C  
ATOM    961  O   ILE A 123      21.222  -3.309   1.626  1.00 24.75           O  
ATOM    962  CB  ILE A 123      22.763  -6.297   1.883  1.00 23.96           C  
ATOM    963  CG1 ILE A 123      22.991  -7.575   1.047  1.00 23.27           C  
ATOM    964  CG2 ILE A 123      21.432  -6.363   2.639  1.00 25.64           C  
ATOM    965  CD1 ILE A 123      23.441  -8.779   1.906  1.00 22.44           C  
ATOM    966  N   LEU A 124      23.296  -3.253   2.546  1.00 23.32           N  
ATOM    967  CA  LEU A 124      23.068  -2.048   3.322  1.00 24.57           C  
ATOM    968  C   LEU A 124      22.739  -0.817   2.423  1.00 23.58           C  
ATOM    969  O   LEU A 124      21.841  -0.053   2.740  1.00 23.62           O  
ATOM    970  CB  LEU A 124      24.285  -1.737   4.213  1.00 25.05           C  
ATOM    971  CG  LEU A 124      24.596  -2.725   5.335  1.00 23.04           C  
ATOM    972  CD1 LEU A 124      25.751  -2.194   6.201  1.00 23.97           C  
ATOM    973  CD2 LEU A 124      23.378  -3.003   6.190  1.00 26.24           C  
ATOM    974  N   ASP A 125      23.466  -0.654   1.314  1.00 21.86           N  
ATOM    975  CA  ASP A 125      23.211   0.406   0.326  1.00 24.34           C  
ATOM    976  C   ASP A 125      21.818   0.294  -0.257  1.00 23.22           C  
ATOM    977  O   ASP A 125      21.064   1.267  -0.302  1.00 23.99           O  
ATOM    978  CB  ASP A 125      24.251   0.392  -0.790  0.50 19.89           C  
ATOM    980  CG  ASP A 125      25.561   1.006  -0.374  0.50 26.91           C  
ATOM    982  OD1 ASP A 125      25.623   1.698   0.675  0.50 29.07           O  
ATOM    984  OD2 ASP A 125      26.522   0.806  -1.126  0.50 21.41           O  
ATOM    986  N   GLY A 126      21.437  -0.920  -0.642  1.00 24.55           N  
ATOM    987  CA  GLY A 126      20.102  -1.174  -1.188  1.00 26.09           C  
ATOM    988  C   GLY A 126      18.987  -0.918  -0.188  1.00 25.00           C  
ATOM    989  O   GLY A 126      17.981  -0.265  -0.523  1.00 23.24           O  
ATOM    990  N   VAL A 127      19.179  -1.394   1.048  1.00 21.56           N  
ATOM    991  CA  VAL A 127      18.188  -1.149   2.130  1.00 22.26           C  
ATOM    992  C   VAL A 127      18.167   0.350   2.509  1.00 23.38           C  
ATOM    993  O   VAL A 127      17.087   0.917   2.771  1.00 23.95           O  
ATOM    994  CB  VAL A 127      18.432  -2.112   3.334  1.00 22.98           C  
ATOM    995  CG1 VAL A 127      17.537  -1.734   4.534  1.00 22.45           C  
ATOM    996  CG2 VAL A 127      18.153  -3.560   2.877  1.00 25.56           C  
ATOM    997  N   HIS A 128      19.340   1.003   2.493  1.00 22.61           N  
ATOM    998  CA  HIS A 128      19.407   2.439   2.762  1.00 24.64           C  
ATOM    999  C   HIS A 128      18.485   3.160   1.796  1.00 22.83           C  
ATOM   1000  O   HIS A 128      17.693   4.021   2.191  1.00 23.71           O  
ATOM   1001  CB  HIS A 128      20.824   3.016   2.657  1.00 21.84           C  
ATOM   1002  CG  HIS A 128      20.889   4.487   2.955  1.00 26.96           C  
ATOM   1003  ND1 HIS A 128      20.709   5.463   1.987  1.00 30.94           N  
ATOM   1004  CD2 HIS A 128      21.074   5.146   4.121  1.00 27.18           C  
ATOM   1005  CE1 HIS A 128      20.813   6.658   2.542  1.00 28.55           C  
ATOM   1006  NE2 HIS A 128      21.047   6.498   3.834  1.00 31.51           N  
ATOM   1007  N   TYR A 129      18.572   2.777   0.525  1.00 22.66           N  
ATOM   1008  CA  TYR A 129      17.725   3.372  -0.486  1.00 25.19           C  
ATOM   1009  C   TYR A 129      16.243   3.152  -0.201  1.00 21.96           C  
ATOM   1010  O   TYR A 129      15.462   4.100  -0.255  1.00 23.73           O  
ATOM   1011  CB  TYR A 129      18.126   2.852  -1.860  1.00 23.00           C  
ATOM   1012  CG  TYR A 129      17.218   3.313  -2.992  1.00 25.31           C  
ATOM   1013  CD1 TYR A 129      17.422   4.526  -3.638  1.00 25.81           C  
ATOM   1014  CD2 TYR A 129      16.166   2.523  -3.410  1.00 26.39           C  
ATOM   1015  CE1 TYR A 129      16.592   4.935  -4.665  1.00 25.98           C  
ATOM   1016  CE2 TYR A 129      15.320   2.936  -4.428  1.00 27.21           C  
ATOM   1017  CZ  TYR A 129      15.553   4.123  -5.060  1.00 23.40           C  
ATOM   1018  OH  TYR A 129      14.730   4.518  -6.085  1.00 25.97           O  
ATOM   1019  N   LEU A 130      15.848   1.912   0.037  1.00 23.12           N  
ATOM   1020  CA  LEU A 130      14.473   1.542   0.341  1.00 21.01           C  
ATOM   1021  C   LEU A 130      13.970   2.298   1.527  1.00 22.08           C  
ATOM   1022  O   LEU A 130      12.898   2.906   1.463  1.00 22.66           O  
ATOM   1023  CB  LEU A 130      14.373   0.025   0.590  1.00 20.08           C  
ATOM   1024  CG  LEU A 130      14.567  -0.897  -0.603  1.00 23.58           C  
ATOM   1025  CD1 LEU A 130      14.421  -2.372  -0.158  1.00 23.52           C  
ATOM   1026  CD2 LEU A 130      13.502  -0.556  -1.649  1.00 26.94           C  
ATOM   1027  N   HIS A 131      14.769   2.332   2.590  1.00 22.37           N  
ATOM   1028  CA  HIS A 131      14.342   3.042   3.800  1.00 21.55           C  
ATOM   1029  C   HIS A 131      14.194   4.545   3.587  1.00 29.57           C  
ATOM   1030  O   HIS A 131      13.294   5.153   4.151  1.00 24.38           O  
ATOM   1031  CB  HIS A 131      15.253   2.669   4.940  1.00 21.35           C  
ATOM   1032  CG  HIS A 131      15.064   1.248   5.409  1.00 23.04           C  
ATOM   1033  ND1 HIS A 131      15.650   0.774   6.564  1.00 24.90           N  
ATOM   1034  CD2 HIS A 131      14.332   0.219   4.908  1.00 19.85           C  
ATOM   1035  CE1 HIS A 131      15.299  -0.485   6.757  1.00 24.38           C  
ATOM   1036  NE2 HIS A 131      14.512  -0.857   5.755  1.00 23.12           N  
ATOM   1037  N   SER A 132      15.017   5.123   2.707  1.00 26.16           N  
ATOM   1038  CA  SER A 132      14.910   6.546   2.350  1.00 27.75           C  
ATOM   1039  C   SER A 132      13.547   6.877   1.705  1.00 24.66           C  
ATOM   1040  O   SER A 132      13.070   8.013   1.780  1.00 26.98           O  
ATOM   1041  CB  SER A 132      16.073   6.956   1.453  1.00 25.63           C  
ATOM   1042  OG  SER A 132      15.860   6.581   0.096  1.00 27.45           O  
ATOM   1043  N   LYS A 133      12.956   5.896   1.036  1.00 22.53           N  
ATOM   1044  CA  LYS A 133      11.651   5.982   0.414  1.00 24.11           C  
ATOM   1045  C   LYS A 133      10.523   5.435   1.281  1.00 28.26           C  
ATOM   1046  O   LYS A 133       9.374   5.250   0.810  1.00 26.71           O  
ATOM   1047  CB  LYS A 133      11.708   5.248  -0.924  1.00 27.45           C  
ATOM   1048  CG  LYS A 133      12.605   5.992  -1.934  1.00 32.80           C  
ATOM   1049  CD  LYS A 133      12.534   5.369  -3.300  1.00 52.71           C  
ATOM   1050  CE  LYS A 133      13.063   6.331  -4.372  1.00 60.70           C  
ATOM   1051  NZ  LYS A 133      12.236   7.553  -4.598  1.00 65.40           N  
ATOM   1052  N   ARG A 134      10.845   5.190   2.552  1.00 26.98           N  
ATOM   1053  CA  ARG A 134       9.893   4.671   3.552  1.00 27.11           C  
ATOM   1054  C   ARG A 134       9.358   3.278   3.206  1.00 26.20           C  
ATOM   1055  O   ARG A 134       8.252   2.919   3.603  1.00 29.65           O  
ATOM   1056  CB  ARG A 134       8.746   5.652   3.781  1.00 32.19           C  
ATOM   1057  CG  ARG A 134       9.170   6.993   4.364  1.00 35.69           C  
ATOM   1058  CD  ARG A 134       7.972   7.971   4.391  1.00 42.92           C  
ATOM   1059  NE  ARG A 134       7.503   8.251   3.024  1.00 57.95           N  
ATOM   1060  CZ  ARG A 134       6.352   7.830   2.484  1.00 58.66           C  
ATOM   1061  NH1 ARG A 134       5.465   7.110   3.178  1.00 47.45           N  
ATOM   1062  NH2 ARG A 134       6.079   8.139   1.218  1.00 61.34           N  
ATOM   1063  N   ILE A 135      10.158   2.496   2.483  1.00 25.24           N  
ATOM   1064  CA  ILE A 135       9.767   1.156   2.064  1.00 25.69           C  
ATOM   1065  C   ILE A 135      10.507   0.135   2.944  1.00 23.49           C  
ATOM   1066  O   ILE A 135      11.738   0.158   3.012  1.00 25.05           O  
ATOM   1067  CB  ILE A 135      10.079   0.864   0.568  1.00 22.71           C  
ATOM   1068  CG1 ILE A 135       9.247   1.772  -0.340  1.00 26.83           C  
ATOM   1069  CG2 ILE A 135       9.811  -0.631   0.245  1.00 23.63           C  
ATOM   1070  CD1 ILE A 135       9.803   1.894  -1.773  1.00 32.82           C  
ATOM   1071  N   ALA A 136       9.736  -0.700   3.625  1.00 25.23           N  
ATOM   1072  CA  ALA A 136      10.257  -1.841   4.373  1.00 26.64           C  
ATOM   1073  C   ALA A 136      10.104  -3.036   3.459  1.00 28.10           C  
ATOM   1074  O   ALA A 136       9.035  -3.255   2.909  1.00 24.54           O  
ATOM   1075  CB  ALA A 136       9.495  -2.047   5.682  1.00 27.99           C  
ATOM   1076  N   HIS A 137      11.175  -3.805   3.278  1.00 24.62           N  
ATOM   1077  CA  HIS A 137      11.084  -5.004   2.424  1.00 22.67           C  
ATOM   1078  C   HIS A 137      10.307  -6.138   3.099  1.00 22.35           C  
ATOM   1079  O   HIS A 137       9.481  -6.831   2.454  1.00 23.74           O  
ATOM   1080  CB  HIS A 137      12.493  -5.480   2.079  1.00 24.82           C  
ATOM   1081  CG  HIS A 137      12.555  -6.649   1.144  1.00 22.83           C  
ATOM   1082  ND1 HIS A 137      12.260  -7.942   1.515  1.00 23.66           N  
ATOM   1083  CD2 HIS A 137      12.937  -6.710  -0.160  1.00 22.75           C  
ATOM   1084  CE1 HIS A 137      12.456  -8.747   0.479  1.00 28.63           C  
ATOM   1085  NE2 HIS A 137      12.873  -8.017  -0.548  1.00 22.08           N  
ATOM   1086  N   PHE A 138      10.593  -6.336   4.384  1.00 24.00           N  
ATOM   1087  CA  PHE A 138       9.926  -7.325   5.268  1.00 25.31           C  
ATOM   1088  C   PHE A 138      10.192  -8.832   4.972  1.00 24.73           C  
ATOM   1089  O   PHE A 138       9.677  -9.709   5.684  1.00 26.34           O  
ATOM   1090  CB  PHE A 138       8.389  -7.107   5.347  1.00 23.45           C  
ATOM   1091  CG  PHE A 138       7.956  -5.918   6.171  1.00 22.64           C  
ATOM   1092  CD1 PHE A 138       8.554  -5.630   7.383  1.00 22.62           C  
ATOM   1093  CD2 PHE A 138       6.933  -5.112   5.737  1.00 24.16           C  
ATOM   1094  CE1 PHE A 138       8.131  -4.515   8.142  1.00 25.11           C  
ATOM   1095  CE2 PHE A 138       6.491  -4.014   6.497  1.00 23.92           C  
ATOM   1096  CZ  PHE A 138       7.086  -3.731   7.676  1.00 25.53           C  
ATOM   1097  N   ASP A 139      11.011  -9.148   3.967  1.00 23.26           N  
ATOM   1098  CA  ASP A 139      11.363 -10.549   3.705  1.00 23.47           C  
ATOM   1099  C   ASP A 139      12.802 -10.666   3.213  1.00 24.30           C  
ATOM   1100  O   ASP A 139      13.114 -11.417   2.301  1.00 27.33           O  
ATOM   1101  CB  ASP A 139      10.377 -11.167   2.714  1.00 26.77           C  
ATOM   1102  CG  ASP A 139      10.385 -12.703   2.714  1.00 37.84           C  
ATOM   1103  OD1 ASP A 139      10.795 -13.362   3.706  1.00 28.96           O  
ATOM   1104  OD2 ASP A 139       9.926 -13.247   1.695  1.00 31.65           O  
ATOM   1105  N   LEU A 140      13.690  -9.932   3.845  1.00 21.55           N  
ATOM   1106  CA  LEU A 140      15.114 -10.066   3.565  1.00 23.36           C  
ATOM   1107  C   LEU A 140      15.610 -11.393   4.081  1.00 25.92           C  
ATOM   1108  O   LEU A 140      15.412 -11.732   5.251  1.00 25.12           O  
ATOM   1109  CB  LEU A 140      15.910  -8.955   4.217  1.00 23.87           C  
ATOM   1110  CG  LEU A 140      15.603  -7.575   3.653  1.00 23.40           C  
ATOM   1111  CD1 LEU A 140      16.345  -6.516   4.487  1.00 25.14           C  
ATOM   1112  CD2 LEU A 140      15.993  -7.448   2.123  1.00 25.81           C  
ATOM   1113  N   LYS A 141      16.268 -12.112   3.187  1.00 23.22           N  
ATOM   1114  CA  LYS A 141      16.916 -13.354   3.509  1.00 22.82           C  
ATOM   1115  C   LYS A 141      17.813 -13.746   2.356  1.00 23.11           C  
ATOM   1116  O   LYS A 141      17.691 -13.178   1.250  1.00 22.71           O  
ATOM   1117  CB  LYS A 141      15.851 -14.419   3.728  1.00 20.22           C  
ATOM   1118  CG  LYS A 141      14.914 -14.621   2.589  1.00 23.14           C  
ATOM   1119  CD  LYS A 141      13.789 -15.586   2.885  1.00 26.93           C  
ATOM   1120  CE  LYS A 141      12.830 -15.669   1.714  1.00 33.46           C  
ATOM   1121  NZ  LYS A 141      11.735 -16.740   1.844  1.00 34.94           N  
ATOM   1122  N   PRO A 142      18.707 -14.719   2.576  1.00 22.26           N  
ATOM   1123  CA  PRO A 142      19.648 -15.014   1.480  1.00 23.92           C  
ATOM   1124  C   PRO A 142      19.000 -15.500   0.176  1.00 20.64           C  
ATOM   1125  O   PRO A 142      19.554 -15.201  -0.913  1.00 23.17           O  
ATOM   1126  CB  PRO A 142      20.579 -16.063   2.074  1.00 25.32           C  
ATOM   1127  CG  PRO A 142      20.472 -15.912   3.500  1.00 24.84           C  
ATOM   1128  CD  PRO A 142      19.026 -15.505   3.765  1.00 22.29           C  
ATOM   1129  N   GLU A 143      17.822 -16.103   0.243  1.00 23.50           N  
ATOM   1130  CA  GLU A 143      17.110 -16.523  -0.961  1.00 22.57           C  
ATOM   1131  C   GLU A 143      16.587 -15.344  -1.789  1.00 26.07           C  
ATOM   1132  O   GLU A 143      16.312 -15.503  -2.979  1.00 27.07           O  
ATOM   1133  CB  GLU A 143      15.922 -17.434  -0.600  1.00 27.16           C  
ATOM   1134  CG  GLU A 143      16.365 -18.768   0.037  0.50 35.09           C  
ATOM   1136  CD  GLU A 143      15.199 -19.623   0.489  0.50 37.57           C  
ATOM   1138  OE1 GLU A 143      14.575 -20.266  -0.380  0.50 42.17           O  
ATOM   1140  OE2 GLU A 143      14.914 -19.650   1.711  0.50 27.48           O  
ATOM   1142  N   ASN A 144      16.468 -14.175  -1.162  1.00 23.89           N  
ATOM   1143  CA  ASN A 144      15.931 -12.988  -1.836  1.00 23.28           C  
ATOM   1144  C   ASN A 144      17.027 -12.018  -2.203  1.00 23.08           C  
ATOM   1145  O   ASN A 144      16.766 -10.844  -2.418  1.00 24.42           O  
ATOM   1146  CB  ASN A 144      14.835 -12.326  -0.971  1.00 23.31           C  
ATOM   1147  CG  ASN A 144      13.517 -13.034  -1.044  1.00 26.89           C  
ATOM   1148  OD1 ASN A 144      13.273 -13.844  -1.947  1.00 26.93           O  
ATOM   1149  ND2 ASN A 144      12.645 -12.745  -0.079  1.00 23.74           N  
ATOM   1150  N   ILE A 145      18.251 -12.524  -2.341  1.00 24.98           N  
ATOM   1151  CA  ILE A 145      19.377 -11.731  -2.732  1.00 24.38           C  
ATOM   1152  C   ILE A 145      20.060 -12.488  -3.849  1.00 23.90           C  
ATOM   1153  O   ILE A 145      20.610 -13.529  -3.626  1.00 26.45           O  
ATOM   1154  CB  ILE A 145      20.346 -11.540  -1.560  1.00 26.55           C  
ATOM   1155  CG1 ILE A 145      19.694 -10.700  -0.447  1.00 24.20           C  
ATOM   1156  CG2 ILE A 145      21.624 -10.849  -2.029  1.00 26.85           C  
ATOM   1157  CD1 ILE A 145      20.422 -10.809   0.848  1.00 24.53           C  
ATOM   1158  N   MET A 146      19.978 -11.959  -5.061  1.00 20.49           N  
ATOM   1159  CA  MET A 146      20.566 -12.603  -6.239  1.00 22.78           C  
ATOM   1160  C   MET A 146      21.918 -12.031  -6.603  1.00 22.87           C  
ATOM   1161  O   MET A 146      22.195 -10.888  -6.338  1.00 25.61           O  
ATOM   1162  CB  MET A 146      19.596 -12.456  -7.427  1.00 25.36           C  
ATOM   1163  CG  MET A 146      18.268 -13.065  -7.148  1.00 34.21           C  
ATOM   1164  SD  MET A 146      17.282 -13.372  -8.668  0.70 25.98           S  
ATOM   1166  CE  MET A 146      18.288 -14.644  -9.501  1.00 29.52           C  
ATOM   1167  N   LEU A 147      22.746 -12.850  -7.233  1.00 21.85           N  
ATOM   1168  CA  LEU A 147      24.050 -12.468  -7.727  1.00 22.96           C  
ATOM   1169  C   LEU A 147      24.025 -12.300  -9.252  1.00 24.73           C  
ATOM   1170  O   LEU A 147      23.483 -13.132  -9.977  1.00 23.93           O  
ATOM   1171  CB  LEU A 147      25.074 -13.577  -7.383  1.00 22.49           C  
ATOM   1172  CG  LEU A 147      25.597 -13.608  -5.928  1.00 24.94           C  
ATOM   1173  CD1 LEU A 147      24.458 -13.795  -4.916  1.00 25.25           C  
ATOM   1174  CD2 LEU A 147      26.686 -14.664  -5.736  1.00 24.96           C  
ATOM   1175  N   LEU A 148      24.635 -11.238  -9.743  1.00 24.60           N  
ATOM   1176  CA  LEU A 148      24.799 -11.066 -11.186  1.00 23.47           C  
ATOM   1177  C   LEU A 148      25.690 -12.140 -11.807  1.00 24.25           C  
ATOM   1178  O   LEU A 148      25.390 -12.695 -12.877  1.00 24.91           O  
ATOM   1179  CB  LEU A 148      25.340  -9.685 -11.491  1.00 27.02           C  
ATOM   1180  CG  LEU A 148      24.417  -8.533 -11.114  1.00 29.01           C  
ATOM   1181  CD1 LEU A 148      25.043  -7.238 -11.547  1.00 28.39           C  
ATOM   1182  CD2 LEU A 148      23.048  -8.744 -11.796  1.00 33.76           C  
ATOM   1183  N   ASP A 149      26.785 -12.417 -11.132  1.00 23.47           N  
ATOM   1184  CA  ASP A 149      27.761 -13.404 -11.613  1.00 25.09           C  
ATOM   1185  C   ASP A 149      28.485 -13.958 -10.398  1.00 26.65           C  
ATOM   1186  O   ASP A 149      29.165 -13.218  -9.648  1.00 27.16           O  
ATOM   1187  CB  ASP A 149      28.728 -12.744 -12.564  1.00 28.13           C  
ATOM   1188  CG  ASP A 149      29.799 -13.697 -13.110  1.00 31.20           C  
ATOM   1189  OD1 ASP A 149      29.948 -14.864 -12.674  1.00 30.94           O  
ATOM   1190  OD2 ASP A 149      30.525 -13.217 -13.996  1.00 35.99           O  
ATOM   1191  N   LYS A 150      28.324 -15.257 -10.208  1.00 23.95           N  
ATOM   1192  CA  LYS A 150      28.872 -15.914  -9.020  1.00 23.75           C  
ATOM   1193  C   LYS A 150      30.339 -16.274  -9.152  1.00 29.15           C  
ATOM   1194  O   LYS A 150      30.976 -16.642  -8.165  1.00 30.00           O  
ATOM   1195  CB  LYS A 150      28.073 -17.163  -8.708  1.00 24.65           C  
ATOM   1196  CG  LYS A 150      28.329 -18.329  -9.634  1.00 32.63           C  
ATOM   1197  CD  LYS A 150      27.310 -19.396  -9.360  1.00 33.19           C  
ATOM   1198  CE  LYS A 150      27.782 -20.747  -9.812  1.00 48.04           C  
ATOM   1199  NZ  LYS A 150      26.609 -21.641  -9.894  1.00 57.52           N  
ATOM   1200  N   ASN A 151      30.865 -16.232 -10.372  1.00 30.73           N  
ATOM   1201  CA  ASN A 151      32.245 -16.664 -10.613  1.00 30.79           C  
ATOM   1202  C   ASN A 151      33.228 -15.492 -10.633  1.00 36.40           C  
ATOM   1203  O   ASN A 151      34.202 -15.526 -11.367  1.00 43.09           O  
ATOM   1204  CB  ASN A 151      32.341 -17.439 -11.944  1.00 34.34           C  
ATOM   1205  CG  ASN A 151      31.394 -18.621 -12.007  1.00 33.83           C  
ATOM   1206  OD1 ASN A 151      30.564 -18.720 -12.917  1.00 43.71           O  
ATOM   1207  ND2 ASN A 151      31.478 -19.493 -11.023  1.00 38.23           N  
ATOM   1208  N   VAL A 152      32.953 -14.442  -9.861  1.00 32.80           N  
ATOM   1209  CA  VAL A 152      33.901 -13.356  -9.619  1.00 30.16           C  
ATOM   1210  C   VAL A 152      34.237 -13.338  -8.122  1.00 35.93           C  
ATOM   1211  O   VAL A 152      33.517 -13.929  -7.303  1.00 32.70           O  
ATOM   1212  CB  VAL A 152      33.387 -11.968 -10.056  1.00 31.34           C  
ATOM   1213  CG1 VAL A 152      33.281 -11.875 -11.579  1.00 30.55           C  
ATOM   1214  CG2 VAL A 152      32.032 -11.630  -9.386  1.00 31.46           C  
ATOM   1215  N   PRO A 153      35.341 -12.682  -7.748  1.00 34.26           N  
ATOM   1216  CA  PRO A 153      35.673 -12.741  -6.325  1.00 33.51           C  
ATOM   1217  C   PRO A 153      34.788 -11.876  -5.419  1.00 30.31           C  
ATOM   1218  O   PRO A 153      34.625 -12.207  -4.252  1.00 41.99           O  
ATOM   1219  CB  PRO A 153      37.110 -12.236  -6.288  1.00 38.79           C  
ATOM   1220  CG  PRO A 153      37.645 -12.511  -7.645  1.00 45.44           C  
ATOM   1221  CD  PRO A 153      36.495 -12.257  -8.557  1.00 41.66           C  
ATOM   1222  N   ASN A 154      34.252 -10.784  -5.965  1.00 36.08           N  
ATOM   1223  CA  ASN A 154      33.396  -9.819  -5.220  1.00 38.86           C  
ATOM   1224  C   ASN A 154      32.002  -9.685  -5.904  1.00 26.21           C  
ATOM   1225  O   ASN A 154      31.767  -8.716  -6.588  1.00 36.82           O  
ATOM   1226  CB  ASN A 154      34.106  -8.446  -5.196  1.00 40.99           C  
ATOM   1227  CG  ASN A 154      35.586  -8.539  -4.726  1.00 51.29           C  
ATOM   1228  OD1 ASN A 154      35.845  -8.893  -3.570  1.00 45.24           O  
ATOM   1229  ND2 ASN A 154      36.548  -8.224  -5.627  1.00 42.22           N  
ATOM   1230  N   PRO A 155      31.142 -10.720  -5.806  1.00 30.53           N  
ATOM   1231  CA  PRO A 155      29.930 -10.692  -6.671  1.00 24.56           C  
ATOM   1232  C   PRO A 155      28.992  -9.516  -6.353  1.00 26.27           C  
ATOM   1233  O   PRO A 155      28.885  -9.101  -5.193  1.00 32.31           O  
ATOM   1234  CB  PRO A 155      29.262 -12.026  -6.370  1.00 26.13           C  
ATOM   1235  CG  PRO A 155      30.324 -12.879  -5.774  1.00 27.91           C  
ATOM   1236  CD  PRO A 155      31.171 -11.935  -4.994  1.00 28.99           C  
ATOM   1237  N   ARG A 156      28.340  -8.995  -7.388  1.00 21.40           N  
ATOM   1238  CA  ARG A 156      27.362  -7.907  -7.251  1.00 25.98           C  
ATOM   1239  C   ARG A 156      26.000  -8.509  -6.976  1.00 23.32           C  
ATOM   1240  O   ARG A 156      25.654  -9.568  -7.535  1.00 25.64           O  
ATOM   1241  CB  ARG A 156      27.288  -7.088  -8.531  1.00 28.01           C  
ATOM   1242  CG  ARG A 156      28.620  -6.480  -9.011  1.00 30.05           C  
ATOM   1243  CD  ARG A 156      29.376  -5.826  -7.902  1.00 27.02           C  
ATOM   1244  NE  ARG A 156      28.701  -4.611  -7.426  1.00 32.79           N  
ATOM   1245  CZ  ARG A 156      29.119  -3.907  -6.382  1.00 36.14           C  
ATOM   1246  NH1 ARG A 156      28.439  -2.838  -6.016  1.00 36.20           N  
ATOM   1247  NH2 ARG A 156      30.220  -4.268  -5.723  1.00 42.85           N  
ATOM   1248  N   ILE A 157      25.196  -7.831  -6.166  1.00 22.23           N  
ATOM   1249  CA  ILE A 157      23.908  -8.379  -5.793  1.00 24.96           C  
ATOM   1250  C   ILE A 157      22.734  -7.490  -6.119  1.00 22.32           C  
ATOM   1251  O   ILE A 157      22.859  -6.285  -6.279  1.00 25.12           O  
ATOM   1252  CB  ILE A 157      23.848  -8.822  -4.303  1.00 23.82           C  
ATOM   1253  CG1 ILE A 157      24.002  -7.631  -3.329  1.00 28.88           C  
ATOM   1254  CG2 ILE A 157      24.919  -9.885  -4.049  1.00 22.85           C  
ATOM   1255  CD1 ILE A 157      22.694  -6.885  -2.950  1.00 24.53           C  
ATOM   1256  N   LYS A 158      21.586  -8.141  -6.211  1.00 23.15           N  
ATOM   1257  CA  LYS A 158      20.293  -7.490  -6.427  1.00 23.69           C  
ATOM   1258  C   LYS A 158      19.282  -8.049  -5.403  1.00 22.11           C  
ATOM   1259  O   LYS A 158      19.054  -9.260  -5.328  1.00 25.00           O  
ATOM   1260  CB  LYS A 158      19.779  -7.811  -7.833  1.00 26.51           C  
ATOM   1261  CG  LYS A 158      20.631  -7.227  -8.988  1.00 32.58           C  
ATOM   1262  CD  LYS A 158      19.955  -6.093  -9.647  1.00 29.32           C  
ATOM   1263  CE  LYS A 158      20.775  -5.237 -10.635  1.00 30.15           C  
ATOM   1264  NZ  LYS A 158      19.931  -3.970 -10.841  1.00 29.34           N  
ATOM   1265  N   LEU A 159      18.643  -7.146  -4.671  1.00 20.86           N  
ATOM   1266  CA  LEU A 159      17.501  -7.503  -3.837  1.00 22.27           C  
ATOM   1267  C   LEU A 159      16.300  -7.795  -4.713  1.00 22.19           C  
ATOM   1268  O   LEU A 159      15.989  -7.029  -5.662  1.00 22.36           O  
ATOM   1269  CB  LEU A 159      17.164  -6.375  -2.880  1.00 22.09           C  
ATOM   1270  CG  LEU A 159      18.270  -5.823  -1.965  1.00 26.99           C  
ATOM   1271  CD1 LEU A 159      17.685  -4.759  -1.107  1.00 26.24           C  
ATOM   1272  CD2 LEU A 159      18.896  -6.901  -1.102  1.00 27.43           C  
ATOM   1273  N   ILE A 160      15.601  -8.886  -4.390  1.00 24.02           N  
ATOM   1274  CA  ILE A 160      14.381  -9.271  -5.085  1.00 22.36           C  
ATOM   1275  C   ILE A 160      13.236  -9.541  -4.106  1.00 23.13           C  
ATOM   1276  O   ILE A 160      13.399  -9.474  -2.890  1.00 24.11           O  
ATOM   1277  CB  ILE A 160      14.582 -10.530  -6.018  1.00 22.39           C  
ATOM   1278  CG1 ILE A 160      14.895 -11.794  -5.204  1.00 21.04           C  
ATOM   1279  CG2 ILE A 160      15.723 -10.217  -7.077  1.00 21.69           C  
ATOM   1280  CD1 ILE A 160      14.550 -13.156  -5.881  1.00 24.58           C  
ATOM   1281  N   ASP A 161      12.083  -9.839  -4.687  1.00 23.37           N  
ATOM   1282  CA  ASP A 161      10.877 -10.251  -3.986  1.00 22.92           C  
ATOM   1283  C   ASP A 161      10.320  -9.203  -3.013  1.00 22.08           C  
ATOM   1284  O   ASP A 161      10.446  -9.297  -1.778  1.00 24.92           O  
ATOM   1285  CB  ASP A 161      11.037 -11.596  -3.309  1.00 21.75           C  
ATOM   1286  CG  ASP A 161       9.703 -12.217  -2.902  1.00 34.17           C  
ATOM   1287  OD1 ASP A 161       8.642 -11.625  -3.102  1.00 28.99           O  
ATOM   1288  OD2 ASP A 161       9.742 -13.310  -2.356  1.00 36.26           O  
ATOM   1289  N   PHE A 162       9.568  -8.291  -3.620  1.00 21.20           N  
ATOM   1290  CA  PHE A 162       8.836  -7.223  -2.932  1.00 20.41           C  
ATOM   1291  C   PHE A 162       7.379  -7.581  -2.628  1.00 24.72           C  
ATOM   1292  O   PHE A 162       6.544  -6.719  -2.415  1.00 25.82           O  
ATOM   1293  CB  PHE A 162       9.015  -5.974  -3.733  1.00 21.18           C  
ATOM   1294  CG  PHE A 162      10.426  -5.448  -3.648  1.00 22.48           C  
ATOM   1295  CD1 PHE A 162      11.407  -5.912  -4.493  1.00 28.11           C  
ATOM   1296  CD2 PHE A 162      10.781  -4.534  -2.656  1.00 22.90           C  
ATOM   1297  CE1 PHE A 162      12.722  -5.438  -4.347  1.00 23.96           C  
ATOM   1298  CE2 PHE A 162      12.064  -4.045  -2.517  1.00 22.50           C  
ATOM   1299  CZ  PHE A 162      13.047  -4.509  -3.362  1.00 24.94           C  
ATOM   1300  N   GLY A 163       7.146  -8.890  -2.538  1.00 23.27           N  
ATOM   1301  CA  GLY A 163       5.846  -9.486  -2.308  1.00 26.26           C  
ATOM   1302  C   GLY A 163       5.164  -9.043  -1.017  1.00 24.69           C  
ATOM   1303  O   GLY A 163       3.937  -9.025  -0.955  1.00 27.44           O  
ATOM   1304  N   ILE A 164       5.914  -8.723   0.030  1.00 23.18           N  
ATOM   1305  CA  ILE A 164       5.300  -8.243   1.248  1.00 27.42           C  
ATOM   1306  C   ILE A 164       5.860  -6.899   1.679  1.00 22.42           C  
ATOM   1307  O   ILE A 164       5.616  -6.437   2.784  1.00 26.30           O  
ATOM   1308  CB  ILE A 164       5.346  -9.292   2.401  1.00 29.63           C  
ATOM   1309  CG1 ILE A 164       6.759  -9.586   2.884  1.00 30.35           C  
ATOM   1310  CG2 ILE A 164       4.620 -10.586   1.945  1.00 39.19           C  
ATOM   1311  CD1 ILE A 164       6.759 -10.448   4.148  1.00 34.44           C  
ATOM   1312  N   ALA A 165       6.603  -6.248   0.787  1.00 21.61           N  
ATOM   1313  CA  ALA A 165       7.120  -4.933   1.060  1.00 21.77           C  
ATOM   1314  C   ALA A 165       5.961  -3.950   1.227  1.00 22.77           C  
ATOM   1315  O   ALA A 165       4.909  -4.089   0.551  1.00 24.99           O  
ATOM   1316  CB  ALA A 165       8.057  -4.510  -0.090  1.00 21.19           C  
ATOM   1317  N   HIS A 166       6.124  -2.984   2.140  1.00 24.63           N  
ATOM   1318  CA  HIS A 166       5.110  -1.930   2.371  1.00 23.78           C  
ATOM   1319  C   HIS A 166       5.784  -0.567   2.522  1.00 25.64           C  
ATOM   1320  O   HIS A 166       6.879  -0.426   3.124  1.00 25.43           O  
ATOM   1321  CB  HIS A 166       4.307  -2.158   3.683  1.00 27.56           C  
ATOM   1322  CG  HIS A 166       3.300  -3.263   3.622  1.00 29.14           C  
ATOM   1323  ND1 HIS A 166       3.643  -4.592   3.498  1.00 32.21           N  
ATOM   1324  CD2 HIS A 166       1.946  -3.230   3.720  1.00 36.15           C  
ATOM   1325  CE1 HIS A 166       2.537  -5.325   3.468  1.00 34.18           C  
ATOM   1326  NE2 HIS A 166       1.495  -4.521   3.607  1.00 33.09           N  
ATOM   1327  N   LYS A 167       5.061   0.460   2.072  1.00 27.19           N  
ATOM   1328  CA  LYS A 167       5.345   1.829   2.538  1.00 31.07           C  
ATOM   1329  C   LYS A 167       4.926   1.993   3.992  1.00 34.98           C  
ATOM   1330  O   LYS A 167       3.833   1.572   4.398  1.00 37.79           O  
ATOM   1331  CB  LYS A 167       4.579   2.834   1.702  1.00 35.66           C  
ATOM   1332  CG  LYS A 167       5.211   3.072   0.387  1.00 35.03           C  
ATOM   1333  CD  LYS A 167       6.137   4.265   0.405  1.00 50.84           C  
ATOM   1334  CE  LYS A 167       6.508   4.643  -1.017  1.00 44.44           C  
ATOM   1335  NZ  LYS A 167       7.520   5.762  -1.077  1.00 49.23           N  
ATOM   1336  N   ILE A 168       5.803   2.603   4.775  1.00 34.87           N  
ATOM   1337  CA  ILE A 168       5.557   2.867   6.173  1.00 35.32           C  
ATOM   1338  C   ILE A 168       5.158   4.339   6.246  1.00 43.97           C  
ATOM   1339  O   ILE A 168       5.929   5.209   5.873  1.00 38.72           O  
ATOM   1340  CB  ILE A 168       6.821   2.640   7.050  1.00 38.98           C  
ATOM   1341  CG1 ILE A 168       7.422   1.255   6.796  1.00 36.32           C  
ATOM   1342  CG2 ILE A 168       6.479   2.780   8.528  1.00 40.40           C  
ATOM   1343  CD1 ILE A 168       6.417   0.120   6.871  1.00 40.61           C  
ATOM   1344  N   GLU A 169       3.941   4.615   6.670  1.00 44.69           N  
ATOM   1345  CA  GLU A 169       3.559   6.013   6.945  1.00 54.58           C  
ATOM   1346  C   GLU A 169       4.111   6.430   8.316  1.00 61.81           C  
ATOM   1347  O   GLU A 169       4.420   5.576   9.161  1.00 68.99           O  
ATOM   1348  CB  GLU A 169       2.038   6.171   6.915  1.00 55.72           C  
ATOM   1349  N   ALA A 170       4.262   7.730   8.545  1.00 67.14           N  
ATOM   1350  CA  ALA A 170       4.355   8.226   9.930  1.00 68.33           C  
ATOM   1351  C   ALA A 170       2.903   8.432  10.399  1.00 70.50           C  
ATOM   1352  O   ALA A 170       2.177   9.236   9.808  1.00 72.77           O  
ATOM   1353  CB  ALA A 170       5.156   9.509   9.994  1.00 66.06           C  
ATOM   1354  N   GLY A 171       2.457   7.673  11.407  1.00 69.70           N  
ATOM   1355  CA  GLY A 171       1.041   7.704  11.820  1.00 73.40           C  
ATOM   1356  C   GLY A 171       0.693   7.176  13.215  1.00 74.50           C  
ATOM   1357  O   GLY A 171       1.420   6.370  13.792  1.00 78.12           O  
ATOM   1358  N   ASN A 172      -0.433   7.645  13.753  1.00 71.02           N  
ATOM   1359  CA  ASN A 172      -0.929   7.205  15.055  1.00 72.10           C  
ATOM   1360  C   ASN A 172      -2.389   6.756  14.948  1.00 71.15           C  
ATOM   1361  O   ASN A 172      -3.067   7.047  13.957  1.00 62.16           O  
ATOM   1362  CB  ASN A 172      -0.803   8.333  16.087  1.00 72.17           C  
ATOM   1363  N   ASN A 176      -7.388   8.483  17.436  1.00 57.71           N  
ATOM   1364  CA  ASN A 176      -7.703   9.900  17.710  1.00 55.51           C  
ATOM   1365  C   ASN A 176      -6.844  10.419  18.853  1.00 51.78           C  
ATOM   1366  O   ASN A 176      -7.278  10.429  20.001  1.00 50.23           O  
ATOM   1367  CB  ASN A 176      -9.192  10.093  18.041  1.00 51.29           C  
ATOM   1368  N   ILE A 177      -5.618  10.838  18.534  1.00 55.00           N  
ATOM   1369  CA  ILE A 177      -4.679  11.338  19.544  1.00 56.04           C  
ATOM   1370  C   ILE A 177      -5.181  12.632  20.221  1.00 54.14           C  
ATOM   1371  O   ILE A 177      -4.698  13.013  21.283  1.00 56.83           O  
ATOM   1372  CB  ILE A 177      -3.259  11.557  18.945  1.00 55.93           C  
ATOM   1373  N   PHE A 178      -6.158  13.291  19.604  1.00 53.15           N  
ATOM   1374  CA  PHE A 178      -6.742  14.518  20.132  1.00 54.19           C  
ATOM   1375  C   PHE A 178      -7.921  14.195  21.069  1.00 52.30           C  
ATOM   1376  O   PHE A 178      -8.110  14.874  22.085  1.00 50.07           O  
ATOM   1377  CB  PHE A 178      -7.199  15.396  18.955  1.00 55.37           C  
ATOM   1378  CG  PHE A 178      -7.391  16.852  19.291  1.00 71.82           C  
ATOM   1379  CD1 PHE A 178      -6.295  17.667  19.571  1.00 82.21           C  
ATOM   1380  CD2 PHE A 178      -8.666  17.425  19.274  1.00 79.34           C  
ATOM   1381  CE1 PHE A 178      -6.470  19.021  19.864  1.00 82.96           C  
ATOM   1382  CE2 PHE A 178      -8.848  18.774  19.565  1.00 80.51           C  
ATOM   1383  CZ  PHE A 178      -7.746  19.572  19.860  1.00 83.81           C  
ATOM   1384  N   GLY A 179      -8.702  13.163  20.738  1.00 40.58           N  
ATOM   1385  CA  GLY A 179      -9.856  12.770  21.561  1.00 43.08           C  
ATOM   1386  C   GLY A 179      -9.526  12.123  22.916  1.00 40.51           C  
ATOM   1387  O   GLY A 179      -8.363  11.888  23.265  1.00 40.63           O  
ATOM   1388  N   THR A 180     -10.559  11.838  23.697  1.00 37.35           N  
ATOM   1389  CA  THR A 180     -10.369  11.034  24.900  1.00 30.43           C  
ATOM   1390  C   THR A 180      -9.875   9.612  24.553  1.00 25.18           C  
ATOM   1391  O   THR A 180     -10.301   9.024  23.566  1.00 27.40           O  
ATOM   1392  CB  THR A 180     -11.664  11.002  25.791  1.00 31.03           C  
ATOM   1393  OG1 THR A 180     -11.424  10.161  26.923  1.00 28.86           O  
ATOM   1394  CG2 THR A 180     -12.911  10.515  25.007  1.00 26.69           C  
ATOM   1395  N   PRO A 181      -8.932   9.058  25.349  1.00 19.10           N  
ATOM   1396  CA  PRO A 181      -8.555   7.664  25.232  1.00 17.38           C  
ATOM   1397  C   PRO A 181      -9.408   6.718  26.090  1.00 14.28           C  
ATOM   1398  O   PRO A 181      -9.150   5.503  26.066  1.00 18.68           O  
ATOM   1399  CB  PRO A 181      -7.144   7.661  25.783  1.00 23.91           C  
ATOM   1400  CG  PRO A 181      -7.195   8.678  26.826  1.00 21.75           C  
ATOM   1401  CD  PRO A 181      -8.160   9.719  26.413  1.00 28.66           C  
ATOM   1402  N   GLU A 182     -10.368   7.267  26.803  1.00 14.87           N  
ATOM   1403  CA  GLU A 182     -11.212   6.520  27.775  1.00 14.97           C  
ATOM   1404  C   GLU A 182     -11.873   5.243  27.247  1.00 18.11           C  
ATOM   1405  O   GLU A 182     -12.113   4.337  28.037  1.00 14.67           O  
ATOM   1406  CB  GLU A 182     -12.259   7.402  28.385  1.00 14.58           C  
ATOM   1407  CG  GLU A 182     -11.740   8.377  29.452  1.00 21.86           C  
ATOM   1408  CD  GLU A 182     -12.750   9.424  29.770  1.00 25.23           C  
ATOM   1409  OE1 GLU A 182     -12.741  10.467  29.084  1.00 27.38           O  
ATOM   1410  OE2 GLU A 182     -13.591   9.214  30.675  1.00 20.21           O  
ATOM   1411  N   PHE A 183     -12.182   5.197  25.947  1.00 16.59           N  
ATOM   1412  CA  PHE A 183     -12.947   4.071  25.320  1.00 14.54           C  
ATOM   1413  C   PHE A 183     -12.115   3.230  24.434  1.00 17.01           C  
ATOM   1414  O   PHE A 183     -12.625   2.283  23.843  1.00 18.03           O  
ATOM   1415  CB  PHE A 183     -14.209   4.617  24.572  1.00 14.98           C  
ATOM   1416  CG  PHE A 183     -15.108   5.402  25.425  1.00 14.28           C  
ATOM   1417  CD1 PHE A 183     -16.227   4.823  26.066  1.00 13.58           C  
ATOM   1418  CD2 PHE A 183     -14.868   6.764  25.677  1.00 10.01           C  
ATOM   1419  CE1 PHE A 183     -17.006   5.535  26.929  1.00 16.02           C  
ATOM   1420  CE2 PHE A 183     -15.645   7.468  26.515  1.00  9.40           C  
ATOM   1421  CZ  PHE A 183     -16.724   6.884  27.184  1.00 12.82           C  
ATOM   1422  N   VAL A 184     -10.812   3.522  24.358  1.00 15.10           N  
ATOM   1423  CA  VAL A 184      -9.910   2.853  23.466  1.00 18.35           C  
ATOM   1424  C   VAL A 184      -9.429   1.527  24.033  1.00 17.71           C  
ATOM   1425  O   VAL A 184      -9.036   1.465  25.210  1.00 19.98           O  
ATOM   1426  CB  VAL A 184      -8.701   3.762  23.143  1.00 24.11           C  
ATOM   1427  CG1 VAL A 184      -7.701   3.057  22.253  1.00 24.63           C  
ATOM   1428  CG2 VAL A 184      -9.176   5.068  22.491  1.00 18.47           C  
ATOM   1429  N   ALA A 185      -9.442   0.488  23.195  1.00 17.11           N  
ATOM   1430  CA  ALA A 185      -8.983  -0.861  23.594  1.00 17.93           C  
ATOM   1431  C   ALA A 185      -7.475  -0.922  23.888  1.00 19.30           C  
ATOM   1432  O   ALA A 185      -6.671  -0.155  23.307  1.00 19.54           O  
ATOM   1433  CB  ALA A 185      -9.313  -1.881  22.521  1.00 22.44           C  
ATOM   1434  N   PRO A 186      -7.067  -1.833  24.786  1.00 20.78           N  
ATOM   1435  CA  PRO A 186      -5.651  -1.937  25.148  1.00 20.27           C  
ATOM   1436  C   PRO A 186      -4.728  -2.220  23.950  1.00 22.76           C  
ATOM   1437  O   PRO A 186      -3.617  -1.694  23.905  1.00 22.76           O  
ATOM   1438  CB  PRO A 186      -5.636  -3.072  26.174  1.00 23.29           C  
ATOM   1439  CG  PRO A 186      -6.912  -3.777  25.987  1.00 25.33           C  
ATOM   1440  CD  PRO A 186      -7.895  -2.779  25.543  1.00 19.70           C  
ATOM   1441  N   GLU A 187      -5.187  -2.982  22.955  1.00 24.96           N  
ATOM   1442  CA  GLU A 187      -4.337  -3.276  21.797  1.00 24.89           C  
ATOM   1443  C   GLU A 187      -4.047  -2.027  20.973  1.00 25.54           C  
ATOM   1444  O   GLU A 187      -3.017  -1.925  20.281  1.00 24.50           O  
ATOM   1445  CB  GLU A 187      -4.925  -4.396  20.927  1.00 27.72           C  
ATOM   1446  CG  GLU A 187      -6.300  -4.093  20.291  1.00 23.88           C  
ATOM   1447  CD  GLU A 187      -7.476  -4.561  21.113  1.00 24.57           C  
ATOM   1448  OE1 GLU A 187      -7.392  -4.645  22.369  1.00 21.94           O  
ATOM   1449  OE2 GLU A 187      -8.495  -4.868  20.486  1.00 22.01           O  
ATOM   1450  N   ILE A 188      -4.969  -1.083  21.023  1.00 20.36           N  
ATOM   1451  CA  ILE A 188      -4.751   0.206  20.424  1.00 24.20           C  
ATOM   1452  C   ILE A 188      -3.834   1.094  21.301  1.00 26.75           C  
ATOM   1453  O   ILE A 188      -2.904   1.707  20.790  1.00 23.68           O  
ATOM   1454  CB  ILE A 188      -6.076   0.941  20.118  1.00 24.00           C  
ATOM   1455  CG1 ILE A 188      -6.850   0.222  19.006  1.00 26.15           C  
ATOM   1456  CG2 ILE A 188      -5.788   2.371  19.672  1.00 24.46           C  
ATOM   1457  CD1 ILE A 188      -8.226   0.861  18.690  1.00 20.89           C  
ATOM   1458  N   VAL A 189      -4.109   1.170  22.603  1.00 23.90           N  
ATOM   1459  CA  VAL A 189      -3.211   1.858  23.543  1.00 23.92           C  
ATOM   1460  C   VAL A 189      -1.736   1.440  23.347  1.00 25.59           C  
ATOM   1461  O   VAL A 189      -0.852   2.274  23.285  1.00 28.29           O  
ATOM   1462  CB  VAL A 189      -3.649   1.566  25.002  1.00 23.92           C  
ATOM   1463  CG1 VAL A 189      -2.595   2.058  25.992  1.00 27.97           C  
ATOM   1464  CG2 VAL A 189      -5.033   2.231  25.273  1.00 21.62           C  
ATOM   1465  N   ASN A 190      -1.511   0.145  23.187  1.00 21.95           N  
ATOM   1466  CA  ASN A 190      -0.162  -0.443  23.063  1.00 26.75           C  
ATOM   1467  C   ASN A 190       0.282  -0.700  21.623  1.00 29.61           C  
ATOM   1468  O   ASN A 190       1.308  -1.351  21.389  1.00 28.47           O  
ATOM   1469  CB  ASN A 190      -0.136  -1.775  23.792  1.00 25.52           C  
ATOM   1470  CG  ASN A 190      -0.358  -1.647  25.299  1.00 33.84           C  
ATOM   1471  OD1 ASN A 190      -1.116  -2.411  25.875  1.00 36.40           O  
ATOM   1472  ND2 ASN A 190       0.330  -0.709  25.933  1.00 29.36           N  
ATOM   1473  N   TYR A 191      -0.497  -0.216  20.655  1.00 26.70           N  
ATOM   1474  CA  TYR A 191      -0.181  -0.404  19.242  1.00 24.91           C  
ATOM   1475  C   TYR A 191       1.148   0.206  18.857  1.00 26.44           C  
ATOM   1476  O   TYR A 191       1.396   1.398  19.076  1.00 27.20           O  
ATOM   1477  CB  TYR A 191      -1.252   0.231  18.358  1.00 25.30           C  
ATOM   1478  CG  TYR A 191      -0.967   0.063  16.875  1.00 29.68           C  
ATOM   1479  CD1 TYR A 191      -0.927  -1.197  16.296  1.00 35.81           C  
ATOM   1480  CD2 TYR A 191      -0.749   1.166  16.063  1.00 36.23           C  
ATOM   1481  CE1 TYR A 191      -0.654  -1.357  14.921  1.00 32.29           C  
ATOM   1482  CE2 TYR A 191      -0.493   1.020  14.698  1.00 38.15           C  
ATOM   1483  CZ  TYR A 191      -0.439  -0.239  14.144  1.00 37.38           C  
ATOM   1484  OH  TYR A 191      -0.173  -0.363  12.798  1.00 48.63           O  
ATOM   1485  N   GLU A 192       1.979  -0.619  18.241  1.00 29.56           N  
ATOM   1486  CA  GLU A 192       3.220  -0.169  17.603  1.00 30.38           C  
ATOM   1487  C   GLU A 192       3.235  -0.733  16.167  1.00 27.26           C  
ATOM   1488  O   GLU A 192       3.194  -1.964  15.970  1.00 27.49           O  
ATOM   1489  CB  GLU A 192       4.422  -0.688  18.396  1.00 37.40           C  
ATOM   1490  CG  GLU A 192       4.654   0.027  19.734  1.00 40.82           C  
ATOM   1491  CD  GLU A 192       4.962   1.532  19.563  1.00 57.96           C  
ATOM   1492  OE1 GLU A 192       5.290   1.964  18.424  1.00 59.67           O  
ATOM   1493  OE2 GLU A 192       4.880   2.280  20.569  1.00 69.81           O  
ATOM   1494  N   PRO A 193       3.257   0.149  15.169  1.00 30.02           N  
ATOM   1495  CA  PRO A 193       3.184  -0.373  13.804  1.00 31.81           C  
ATOM   1496  C   PRO A 193       4.474  -1.099  13.413  1.00 26.65           C  
ATOM   1497  O   PRO A 193       5.561  -0.781  13.942  1.00 27.39           O  
ATOM   1498  CB  PRO A 193       3.000   0.881  12.950  1.00 34.48           C  
ATOM   1499  CG  PRO A 193       3.545   1.991  13.766  1.00 40.47           C  
ATOM   1500  CD  PRO A 193       3.328   1.620  15.211  1.00 33.75           C  
ATOM   1501  N   LEU A 194       4.375  -2.046  12.499  1.00 26.77           N  
ATOM   1502  CA  LEU A 194       5.589  -2.650  11.929  1.00 27.14           C  
ATOM   1503  C   LEU A 194       6.300  -1.566  11.090  1.00 29.75           C  
ATOM   1504  O   LEU A 194       5.663  -0.698  10.487  1.00 31.36           O  
ATOM   1505  CB  LEU A 194       5.236  -3.879  11.090  1.00 25.82           C  
ATOM   1506  CG  LEU A 194       4.492  -5.030  11.762  1.00 25.25           C  
ATOM   1507  CD1 LEU A 194       4.133  -6.171  10.788  1.00 29.42           C  
ATOM   1508  CD2 LEU A 194       5.300  -5.599  12.938  1.00 25.62           C  
ATOM   1509  N   GLY A 195       7.629  -1.554  11.096  1.00 30.58           N  
ATOM   1510  CA  GLY A 195       8.328  -0.562  10.313  1.00 32.10           C  
ATOM   1511  C   GLY A 195       9.704  -1.011   9.845  1.00 30.72           C  
ATOM   1512  O   GLY A 195      10.007  -2.203   9.753  1.00 24.98           O  
ATOM   1513  N   LEU A 196      10.530  -0.020   9.558  1.00 25.30           N  
ATOM   1514  CA  LEU A 196      11.829  -0.231   8.955  1.00 24.32           C  
ATOM   1515  C   LEU A 196      12.793  -1.064   9.808  1.00 28.26           C  
ATOM   1516  O   LEU A 196      13.685  -1.783   9.300  1.00 25.23           O  
ATOM   1517  CB  LEU A 196      12.419   1.146   8.654  1.00 24.83           C  
ATOM   1518  CG  LEU A 196      11.613   2.051   7.736  1.00 24.24           C  
ATOM   1519  CD1 LEU A 196      12.386   3.369   7.564  1.00 25.98           C  
ATOM   1520  CD2 LEU A 196      11.201   1.452   6.322  1.00 26.89           C  
ATOM   1521  N   GLU A 197      12.620  -0.994  11.118  1.00 25.15           N  
ATOM   1522  CA  GLU A 197      13.448  -1.776  12.034  1.00 26.62           C  
ATOM   1523  C   GLU A 197      13.416  -3.290  11.772  1.00 23.80           C  
ATOM   1524  O   GLU A 197      14.371  -3.966  12.108  1.00 25.43           O  
ATOM   1525  CB  GLU A 197      13.015  -1.577  13.472  1.00 26.20           C  
ATOM   1526  CG  GLU A 197      12.817  -0.125  13.849  1.00 26.81           C  
ATOM   1527  CD  GLU A 197      11.395   0.379  13.670  1.00 38.43           C  
ATOM   1528  OE1 GLU A 197      10.592  -0.256  12.924  1.00 31.15           O  
ATOM   1529  OE2 GLU A 197      11.091   1.442  14.294  1.00 41.97           O  
ATOM   1530  N   ALA A 198      12.308  -3.830  11.291  1.00 23.38           N  
ATOM   1531  CA  ALA A 198      12.253  -5.271  11.004  1.00 26.60           C  
ATOM   1532  C   ALA A 198      13.348  -5.715  10.002  1.00 25.66           C  
ATOM   1533  O   ALA A 198      13.951  -6.783  10.129  1.00 22.68           O  
ATOM   1534  CB  ALA A 198      10.848  -5.692  10.497  1.00 26.12           C  
ATOM   1535  N   ASP A 199      13.615  -4.868   9.005  1.00 22.53           N  
ATOM   1536  CA  ASP A 199      14.665  -5.163   8.016  1.00 23.04           C  
ATOM   1537  C   ASP A 199      16.031  -5.196   8.671  1.00 24.56           C  
ATOM   1538  O   ASP A 199      16.866  -5.995   8.292  1.00 23.31           O  
ATOM   1539  CB  ASP A 199      14.688  -4.113   6.893  1.00 22.47           C  
ATOM   1540  CG  ASP A 199      13.544  -4.274   5.901  1.00 22.68           C  
ATOM   1541  OD1 ASP A 199      12.929  -5.345   5.828  1.00 24.03           O  
ATOM   1542  OD2 ASP A 199      13.299  -3.311   5.160  1.00 23.42           O  
ATOM   1543  N   MET A 200      16.246  -4.316   9.651  1.00 24.33           N  
ATOM   1544  CA  MET A 200      17.516  -4.267  10.376  1.00 24.75           C  
ATOM   1545  C   MET A 200      17.789  -5.556  11.166  1.00 22.30           C  
ATOM   1546  O   MET A 200      18.894  -6.096  11.111  1.00 22.66           O  
ATOM   1547  CB  MET A 200      17.586  -3.002  11.228  1.00 23.21           C  
ATOM   1548  CG  MET A 200      17.475  -1.688  10.387  1.00 26.34           C  
ATOM   1549  SD  MET A 200      18.486  -1.644   8.878  1.00 24.88           S  
ATOM   1550  CE  MET A 200      20.117  -1.985   9.608  1.00 26.19           C  
ATOM   1551  N   TRP A 201      16.746  -6.076  11.800  1.00 23.17           N  
ATOM   1552  CA  TRP A 201      16.815  -7.378  12.477  1.00 20.82           C  
ATOM   1553  C   TRP A 201      17.254  -8.434  11.463  1.00 22.03           C  
ATOM   1554  O   TRP A 201      18.164  -9.203  11.724  1.00 22.80           O  
ATOM   1555  CB  TRP A 201      15.462  -7.767  13.063  1.00 24.14           C  
ATOM   1556  CG  TRP A 201      15.414  -9.177  13.564  1.00 29.90           C  
ATOM   1557  CD1 TRP A 201      15.266 -10.297  12.828  1.00 23.18           C  
ATOM   1558  CD2 TRP A 201      15.566  -9.621  14.930  1.00 25.03           C  
ATOM   1559  NE1 TRP A 201      15.284 -11.400  13.625  1.00 26.51           N  
ATOM   1560  CE2 TRP A 201      15.468 -11.017  14.919  1.00 25.02           C  
ATOM   1561  CE3 TRP A 201      15.736  -8.958  16.149  1.00 27.83           C  
ATOM   1562  CZ2 TRP A 201      15.532 -11.757  16.060  1.00 24.74           C  
ATOM   1563  CZ3 TRP A 201      15.803  -9.678  17.279  1.00 32.11           C  
ATOM   1564  CH2 TRP A 201      15.705 -11.071  17.246  1.00 27.96           C  
ATOM   1565  N   SER A 202      16.599  -8.437  10.291  1.00 21.29           N  
ATOM   1566  CA  SER A 202      16.871  -9.462   9.231  1.00 20.91           C  
ATOM   1567  C   SER A 202      18.333  -9.425   8.772  1.00 21.38           C  
ATOM   1568  O   SER A 202      18.959 -10.453   8.587  1.00 22.79           O  
ATOM   1569  CB  SER A 202      15.918  -9.273   8.038  1.00 21.54           C  
ATOM   1570  OG  SER A 202      14.537  -9.507   8.373  1.00 24.14           O  
ATOM   1571  N   ILE A 203      18.874  -8.221   8.652  1.00 22.03           N  
ATOM   1572  CA  ILE A 203      20.259  -7.972   8.277  1.00 23.61           C  
ATOM   1573  C   ILE A 203      21.207  -8.533   9.335  1.00 26.03           C  
ATOM   1574  O   ILE A 203      22.247  -9.093   9.001  1.00 20.62           O  
ATOM   1575  CB  ILE A 203      20.538  -6.475   8.028  1.00 24.23           C  
ATOM   1576  CG1 ILE A 203      19.800  -5.998   6.741  1.00 23.92           C  
ATOM   1577  CG2 ILE A 203      22.070  -6.233   7.921  1.00 25.13           C  
ATOM   1578  CD1 ILE A 203      19.721  -4.490   6.562  1.00 27.58           C  
ATOM   1579  N   GLY A 204      20.837  -8.417  10.607  1.00 24.02           N  
ATOM   1580  CA  GLY A 204      21.613  -9.073  11.668  1.00 24.23           C  
ATOM   1581  C   GLY A 204      21.661 -10.598  11.520  1.00 23.67           C  
ATOM   1582  O   GLY A 204      22.738 -11.219  11.656  1.00 23.72           O  
ATOM   1583  N   VAL A 205      20.519 -11.200  11.172  1.00 22.15           N  
ATOM   1584  CA  VAL A 205      20.434 -12.652  10.996  1.00 21.79           C  
ATOM   1585  C   VAL A 205      21.252 -13.080   9.754  1.00 20.93           C  
ATOM   1586  O   VAL A 205      22.006 -14.054   9.802  1.00 23.86           O  
ATOM   1587  CB  VAL A 205      18.985 -13.159  10.952  1.00 24.34           C  
ATOM   1588  CG1 VAL A 205      18.963 -14.683  10.691  1.00 23.86           C  
ATOM   1589  CG2 VAL A 205      18.221 -12.795  12.242  1.00 22.68           C  
ATOM   1590  N   ILE A 206      21.114 -12.321   8.645  1.00 22.49           N  
ATOM   1591  CA  ILE A 206      21.898 -12.568   7.428  1.00 19.89           C  
ATOM   1592  C   ILE A 206      23.395 -12.510   7.735  1.00 20.92           C  
ATOM   1593  O   ILE A 206      24.197 -13.354   7.334  1.00 22.11           O  
ATOM   1594  CB  ILE A 206      21.521 -11.563   6.314  1.00 21.50           C  
ATOM   1595  CG1 ILE A 206      20.117 -11.857   5.761  1.00 21.79           C  
ATOM   1596  CG2 ILE A 206      22.539 -11.667   5.169  1.00 26.21           C  
ATOM   1597  CD1 ILE A 206      19.566 -10.754   4.921  1.00 21.05           C  
ATOM   1598  N   THR A 207      23.782 -11.516   8.515  1.00 20.61           N  
ATOM   1599  CA  THR A 207      25.194 -11.382   8.872  1.00 21.05           C  
ATOM   1600  C   THR A 207      25.696 -12.594   9.643  1.00 22.25           C  
ATOM   1601  O   THR A 207      26.734 -13.152   9.335  1.00 23.20           O  
ATOM   1602  CB  THR A 207      25.475 -10.079   9.664  1.00 22.75           C  
ATOM   1603  OG1 THR A 207      25.022  -8.938   8.920  1.00 22.46           O  
ATOM   1604  CG2 THR A 207      27.006  -9.927   9.970  1.00 24.31           C  
ATOM   1605  N   TYR A 208      24.953 -12.984  10.662  1.00 20.30           N  
ATOM   1606  CA  TYR A 208      25.298 -14.136  11.467  1.00 25.34           C  
ATOM   1607  C   TYR A 208      25.505 -15.371  10.592  1.00 23.51           C  
ATOM   1608  O   TYR A 208      26.516 -16.082  10.716  1.00 21.80           O  
ATOM   1609  CB  TYR A 208      24.173 -14.355  12.473  1.00 24.75           C  
ATOM   1610  CG  TYR A 208      24.394 -15.432  13.487  1.00 22.24           C  
ATOM   1611  CD1 TYR A 208      24.684 -15.119  14.823  1.00 23.21           C  
ATOM   1612  CD2 TYR A 208      24.278 -16.764  13.149  1.00 21.23           C  
ATOM   1613  CE1 TYR A 208      24.888 -16.144  15.781  1.00 23.41           C  
ATOM   1614  CE2 TYR A 208      24.428 -17.779  14.109  1.00 20.96           C  
ATOM   1615  CZ  TYR A 208      24.719 -17.449  15.422  1.00 25.27           C  
ATOM   1616  OH  TYR A 208      24.911 -18.428  16.358  1.00 24.17           O  
ATOM   1617  N   ILE A 209      24.526 -15.654   9.732  1.00 22.85           N  
ATOM   1618  CA  ILE A 209      24.589 -16.867   8.891  1.00 21.67           C  
ATOM   1619  C   ILE A 209      25.720 -16.810   7.841  1.00 22.50           C  
ATOM   1620  O   ILE A 209      26.366 -17.826   7.552  1.00 23.18           O  
ATOM   1621  CB  ILE A 209      23.194 -17.220   8.310  1.00 20.20           C  
ATOM   1622  CG1 ILE A 209      23.097 -18.715   7.959  1.00 26.57           C  
ATOM   1623  CG2 ILE A 209      22.857 -16.397   7.104  1.00 25.26           C  
ATOM   1624  CD1 ILE A 209      21.695 -19.166   7.657  1.00 28.05           C  
ATOM   1625  N   LEU A 210      26.023 -15.618   7.339  1.00 22.65           N  
ATOM   1626  CA  LEU A 210      27.093 -15.485   6.358  1.00 21.62           C  
ATOM   1627  C   LEU A 210      28.433 -15.874   6.997  1.00 24.06           C  
ATOM   1628  O   LEU A 210      29.273 -16.494   6.351  1.00 26.22           O  
ATOM   1629  CB  LEU A 210      27.187 -14.075   5.809  1.00 26.62           C  
ATOM   1630  CG  LEU A 210      26.115 -13.624   4.801  1.00 31.50           C  
ATOM   1631  CD1 LEU A 210      26.378 -12.166   4.434  1.00 27.93           C  
ATOM   1632  CD2 LEU A 210      26.139 -14.540   3.584  1.00 30.77           C  
ATOM   1633  N   LEU A 211      28.636 -15.445   8.250  1.00 26.66           N  
ATOM   1634  CA  LEU A 211      29.888 -15.720   8.977  1.00 23.25           C  
ATOM   1635  C   LEU A 211      30.060 -17.167   9.473  1.00 22.23           C  
ATOM   1636  O   LEU A 211      31.179 -17.622   9.691  1.00 23.36           O  
ATOM   1637  CB  LEU A 211      30.012 -14.754  10.169  1.00 24.48           C  
ATOM   1638  CG  LEU A 211      30.072 -13.238   9.871  1.00 22.22           C  
ATOM   1639  CD1 LEU A 211      30.097 -12.358  11.120  1.00 25.98           C  
ATOM   1640  CD2 LEU A 211      31.308 -12.939   8.971  1.00 26.77           C  
ATOM   1641  N   SER A 212      28.978 -17.899   9.627  1.00 25.34           N  
ATOM   1642  CA  SER A 212      28.999 -19.204  10.315  1.00 25.19           C  
ATOM   1643  C   SER A 212      28.415 -20.381   9.510  1.00 26.04           C  
ATOM   1644  O   SER A 212      28.786 -21.527   9.724  1.00 26.07           O  
ATOM   1645  CB  SER A 212      28.229 -19.081  11.618  1.00 26.39           C  
ATOM   1646  OG  SER A 212      26.864 -18.751  11.396  1.00 24.15           O  
ATOM   1647  N   GLY A 213      27.498 -20.100   8.602  1.00 23.09           N  
ATOM   1648  CA  GLY A 213      26.641 -21.134   8.011  1.00 25.38           C  
ATOM   1649  C   GLY A 213      25.564 -21.630   8.950  1.00 26.75           C  
ATOM   1650  O   GLY A 213      24.779 -22.509   8.584  1.00 30.24           O  
ATOM   1651  N   ALA A 214      25.514 -21.060  10.157  1.00 21.72           N  
ATOM   1652  CA  ALA A 214      24.546 -21.406  11.195  1.00 25.33           C  
ATOM   1653  C   ALA A 214      23.396 -20.395  11.276  1.00 25.07           C  
ATOM   1654  O   ALA A 214      23.620 -19.198  11.296  1.00 26.11           O  
ATOM   1655  CB  ALA A 214      25.264 -21.504  12.562  1.00 24.19           C  
ATOM   1656  N   SER A 215      22.157 -20.895  11.321  1.00 27.70           N  
ATOM   1657  CA  SER A 215      21.000 -20.076  11.569  1.00 26.81           C  
ATOM   1658  C   SER A 215      20.818 -19.850  13.075  1.00 26.85           C  
ATOM   1659  O   SER A 215      20.691 -20.820  13.835  1.00 29.07           O  
ATOM   1660  CB  SER A 215      19.773 -20.738  10.988  1.00 28.18           C  
ATOM   1661  OG  SER A 215      18.693 -19.855  11.042  1.00 27.16           O  
ATOM   1662  N   PRO A 216      20.807 -18.576  13.528  1.00 21.70           N  
ATOM   1663  CA  PRO A 216      20.849 -18.300  14.978  1.00 25.88           C  
ATOM   1664  C   PRO A 216      19.626 -18.723  15.818  1.00 24.45           C  
ATOM   1665  O   PRO A 216      19.766 -19.021  17.008  1.00 24.82           O  
ATOM   1666  CB  PRO A 216      21.022 -16.786  15.051  1.00 25.32           C  
ATOM   1667  CG  PRO A 216      20.526 -16.262  13.698  1.00 23.46           C  
ATOM   1668  CD  PRO A 216      20.879 -17.338  12.722  1.00 22.25           C  
ATOM   1669  N   PHE A 217      18.441 -18.692  15.229  1.00 24.04           N  
ATOM   1670  CA  PHE A 217      17.212 -19.015  15.978  1.00 26.32           C  
ATOM   1671  C   PHE A 217      16.547 -20.321  15.594  1.00 28.23           C  
ATOM   1672  O   PHE A 217      15.495 -20.692  16.152  1.00 29.34           O  
ATOM   1673  CB  PHE A 217      16.229 -17.883  15.791  1.00 24.28           C  
ATOM   1674  CG  PHE A 217      16.754 -16.579  16.277  1.00 19.69           C  
ATOM   1675  CD1 PHE A 217      16.934 -16.366  17.634  1.00 26.08           C  
ATOM   1676  CD2 PHE A 217      17.169 -15.572  15.370  1.00 24.89           C  
ATOM   1677  CE1 PHE A 217      17.438 -15.185  18.096  1.00 23.14           C  
ATOM   1678  CE2 PHE A 217      17.675 -14.403  15.821  1.00 25.17           C  
ATOM   1679  CZ  PHE A 217      17.813 -14.187  17.192  1.00 25.99           C  
ATOM   1680  N   LEU A 218      17.139 -21.028  14.647  1.00 25.22           N  
ATOM   1681  CA  LEU A 218      16.495 -22.196  14.099  1.00 24.89           C  
ATOM   1682  C   LEU A 218      16.333 -23.243  15.172  1.00 25.46           C  
ATOM   1683  O   LEU A 218      17.322 -23.597  15.838  1.00 27.15           O  
ATOM   1684  CB  LEU A 218      17.299 -22.779  12.939  1.00 27.75           C  
ATOM   1685  CG  LEU A 218      16.724 -24.028  12.257  1.00 32.94           C  
ATOM   1686  CD1 LEU A 218      15.295 -23.799  11.684  1.00 29.76           C  
ATOM   1687  CD2 LEU A 218      17.668 -24.558  11.166  1.00 30.19           C  
ATOM   1688  N   GLY A 219      15.098 -23.742  15.339  1.00 29.61           N  
ATOM   1689  CA  GLY A 219      14.815 -24.864  16.224  1.00 28.68           C  
ATOM   1690  C   GLY A 219      14.466 -26.135  15.474  1.00 26.42           C  
ATOM   1691  O   GLY A 219      14.472 -26.206  14.240  1.00 28.87           O  
ATOM   1692  N   GLU A 220      14.159 -27.169  16.229  1.00 28.77           N  
ATOM   1693  CA  GLU A 220      13.812 -28.454  15.620  1.00 33.17           C  
ATOM   1694  C   GLU A 220      12.451 -28.432  14.923  1.00 34.34           C  
ATOM   1695  O   GLU A 220      12.214 -29.230  14.017  1.00 37.18           O  
ATOM   1696  CB  GLU A 220      13.821 -29.549  16.669  1.00 37.33           C  
ATOM   1697  CG  GLU A 220      15.159 -30.153  16.913  1.00 44.76           C  
ATOM   1698  CD  GLU A 220      15.047 -31.363  17.806  1.00 54.65           C  
ATOM   1699  OE1 GLU A 220      15.352 -32.487  17.361  1.00 42.89           O  
ATOM   1700  OE2 GLU A 220      14.615 -31.179  18.958  1.00 42.33           O  
ATOM   1701  N   THR A 221      11.580 -27.518  15.358  1.00 33.60           N  
ATOM   1702  CA  THR A 221      10.240 -27.322  14.785  1.00 36.24           C  
ATOM   1703  C   THR A 221      10.074 -25.842  14.456  1.00 36.90           C  
ATOM   1704  O   THR A 221      10.728 -25.007  15.078  1.00 29.38           O  
ATOM   1705  CB  THR A 221       9.129 -27.687  15.800  1.00 39.33           C  
ATOM   1706  OG1 THR A 221       9.202 -26.818  16.950  1.00 35.58           O  
ATOM   1707  CG2 THR A 221       9.243 -29.143  16.251  1.00 46.78           C  
ATOM   1708  N   LYS A 222       9.219 -25.522  13.483  1.00 35.02           N  
ATOM   1709  CA  LYS A 222       8.855 -24.116  13.230  1.00 42.17           C  
ATOM   1710  C   LYS A 222       8.426 -23.404  14.524  1.00 39.34           C  
ATOM   1711  O   LYS A 222       8.814 -22.275  14.748  1.00 36.26           O  
ATOM   1712  CB  LYS A 222       7.781 -24.004  12.139  0.50 42.80           C  
ATOM   1714  CG  LYS A 222       8.327 -24.133  10.716  0.50 49.46           C  
ATOM   1716  N   GLN A 223       7.649 -24.043  15.395  1.00 35.47           N  
ATOM   1717  CA  GLN A 223       7.275 -23.350  16.637  1.00 38.69           C  
ATOM   1718  C   GLN A 223       8.464 -23.008  17.514  1.00 37.29           C  
ATOM   1719  O   GLN A 223       8.483 -21.968  18.164  1.00 36.42           O  
ATOM   1720  CB  GLN A 223       6.275 -24.140  17.485  1.00 38.19           C  
ATOM   1721  CG  GLN A 223       5.712 -23.330  18.673  1.00 44.73           C  
ATOM   1722  CD  GLN A 223       5.199 -21.934  18.277  1.00 50.22           C  
ATOM   1723  OE1 GLN A 223       5.645 -20.917  18.817  1.00 48.90           O  
ATOM   1724  NE2 GLN A 223       4.273 -21.890  17.312  1.00 45.25           N  
ATOM   1725  N   GLU A 224       9.437 -23.915  17.572  1.00 31.37           N  
ATOM   1726  CA  GLU A 224      10.630 -23.644  18.351  1.00 32.77           C  
ATOM   1727  C   GLU A 224      11.393 -22.450  17.784  1.00 24.88           C  
ATOM   1728  O   GLU A 224      11.874 -21.615  18.557  1.00 29.67           O  
ATOM   1729  CB  GLU A 224      11.544 -24.865  18.384  1.00 32.93           C  
ATOM   1730  CG  GLU A 224      11.086 -25.948  19.315  1.00 51.90           C  
ATOM   1731  CD  GLU A 224      11.977 -27.159  19.192  1.00 55.28           C  
ATOM   1732  OE1 GLU A 224      13.217 -27.007  19.373  1.00 63.08           O  
ATOM   1733  OE2 GLU A 224      11.443 -28.237  18.876  1.00 51.43           O  
ATOM   1734  N   THR A 225      11.503 -22.372  16.465  1.00 24.20           N  
ATOM   1735  CA  THR A 225      12.148 -21.203  15.824  1.00 24.76           C  
ATOM   1736  C   THR A 225      11.438 -19.914  16.205  1.00 26.37           C  
ATOM   1737  O   THR A 225      12.074 -18.923  16.607  1.00 24.87           O  
ATOM   1738  CB  THR A 225      12.188 -21.350  14.274  1.00 28.54           C  
ATOM   1739  OG1 THR A 225      12.778 -22.610  13.932  1.00 28.01           O  
ATOM   1740  CG2 THR A 225      12.945 -20.140  13.579  1.00 27.75           C  
ATOM   1741  N   LEU A 226      10.109 -19.906  16.112  1.00 30.97           N  
ATOM   1742  CA  LEU A 226       9.361 -18.688  16.477  1.00 29.24           C  
ATOM   1743  C   LEU A 226       9.580 -18.273  17.933  1.00 27.62           C  
ATOM   1744  O   LEU A 226       9.783 -17.099  18.246  1.00 28.57           O  
ATOM   1745  CB  LEU A 226       7.877 -18.878  16.174  1.00 29.04           C  
ATOM   1746  CG  LEU A 226       7.501 -19.187  14.710  1.00 28.58           C  
ATOM   1747  CD1 LEU A 226       5.979 -19.392  14.636  1.00 41.85           C  
ATOM   1748  CD2 LEU A 226       7.958 -18.137  13.703  1.00 29.12           C  
ATOM   1749  N   THR A 227       9.566 -19.259  18.831  1.00 30.90           N  
ATOM   1750  CA  THR A 227       9.839 -19.049  20.245  1.00 29.67           C  
ATOM   1751  C   THR A 227      11.240 -18.498  20.509  1.00 31.50           C  
ATOM   1752  O   THR A 227      11.413 -17.580  21.331  1.00 28.90           O  
ATOM   1753  CB  THR A 227       9.615 -20.366  21.014  1.00 35.26           C  
ATOM   1754  OG1 THR A 227       8.242 -20.735  20.859  1.00 36.06           O  
ATOM   1755  CG2 THR A 227       9.977 -20.220  22.515  1.00 33.85           C  
ATOM   1756  N   ASN A 228      12.226 -19.032  19.794  1.00 26.60           N  
ATOM   1757  CA  ASN A 228      13.592 -18.552  19.911  1.00 27.66           C  
ATOM   1758  C   ASN A 228      13.698 -17.107  19.419  1.00 29.20           C  
ATOM   1759  O   ASN A 228      14.374 -16.283  20.046  1.00 24.54           O  
ATOM   1760  CB  ASN A 228      14.570 -19.438  19.119  1.00 27.98           C  
ATOM   1761  CG  ASN A 228      14.735 -20.837  19.699  1.00 28.67           C  
ATOM   1762  OD1 ASN A 228      14.479 -21.060  20.880  1.00 30.73           O  
ATOM   1763  ND2 ASN A 228      15.193 -21.778  18.874  1.00 26.06           N  
ATOM   1764  N   ILE A 229      13.024 -16.784  18.309  1.00 24.96           N  
ATOM   1765  CA  ILE A 229      13.082 -15.416  17.771  1.00 25.19           C  
ATOM   1766  C   ILE A 229      12.522 -14.432  18.811  1.00 27.42           C  
ATOM   1767  O   ILE A 229      13.159 -13.432  19.149  1.00 29.19           O  
ATOM   1768  CB  ILE A 229      12.309 -15.270  16.457  1.00 30.82           C  
ATOM   1769  CG1 ILE A 229      13.011 -16.103  15.374  1.00 24.45           C  
ATOM   1770  CG2 ILE A 229      12.220 -13.761  16.080  1.00 26.39           C  
ATOM   1771  CD1 ILE A 229      12.255 -16.305  13.999  1.00 23.14           C  
ATOM   1772  N   SER A 230      11.324 -14.742  19.306  1.00 30.49           N  
ATOM   1773  CA  SER A 230      10.620 -13.883  20.278  1.00 31.73           C  
ATOM   1774  C   SER A 230      11.463 -13.650  21.516  1.00 30.12           C  
ATOM   1775  O   SER A 230      11.452 -12.556  22.094  1.00 32.31           O  
ATOM   1776  CB  SER A 230       9.270 -14.465  20.663  0.50 27.81           C  
ATOM   1778  OG  SER A 230       8.515 -13.493  21.363  0.50 27.72           O  
ATOM   1780  N   ALA A 231      12.180 -14.681  21.947  1.00 30.88           N  
ATOM   1781  CA  ALA A 231      12.985 -14.586  23.171  1.00 34.70           C  
ATOM   1782  C   ALA A 231      14.394 -14.033  22.906  1.00 36.14           C  
ATOM   1783  O   ALA A 231      15.189 -13.859  23.844  1.00 34.39           O  
ATOM   1784  CB  ALA A 231      13.091 -15.954  23.834  1.00 34.92           C  
ATOM   1785  N   VAL A 232      14.714 -13.786  21.632  1.00 33.05           N  
ATOM   1786  CA  VAL A 232      16.101 -13.478  21.211  1.00 29.12           C  
ATOM   1787  C   VAL A 232      17.089 -14.510  21.793  1.00 29.52           C  
ATOM   1788  O   VAL A 232      18.114 -14.183  22.397  1.00 28.54           O  
ATOM   1789  CB  VAL A 232      16.490 -12.013  21.531  1.00 32.41           C  
ATOM   1790  CG1 VAL A 232      17.698 -11.620  20.745  1.00 26.17           C  
ATOM   1791  CG2 VAL A 232      15.350 -11.080  21.202  1.00 40.00           C  
ATOM   1792  N   ASN A 233      16.724 -15.778  21.628  1.00 28.76           N  
ATOM   1793  CA  ASN A 233      17.492 -16.867  22.173  1.00 33.72           C  
ATOM   1794  C   ASN A 233      18.516 -17.344  21.140  1.00 27.51           C  
ATOM   1795  O   ASN A 233      18.216 -18.196  20.309  1.00 28.68           O  
ATOM   1796  CB  ASN A 233      16.546 -18.002  22.594  1.00 31.76           C  
ATOM   1797  CG  ASN A 233      17.280 -19.154  23.234  1.00 33.78           C  
ATOM   1798  OD1 ASN A 233      18.292 -18.964  23.909  1.00 33.10           O  
ATOM   1799  ND2 ASN A 233      16.772 -20.355  23.029  1.00 37.64           N  
ATOM   1800  N   TYR A 234      19.716 -16.771  21.192  1.00 27.12           N  
ATOM   1801  CA  TYR A 234      20.826 -17.200  20.340  1.00 26.38           C  
ATOM   1802  C   TYR A 234      22.144 -16.954  21.081  1.00 25.54           C  
ATOM   1803  O   TYR A 234      22.185 -16.257  22.102  1.00 29.14           O  
ATOM   1804  CB  TYR A 234      20.820 -16.417  19.022  1.00 30.32           C  
ATOM   1805  CG  TYR A 234      21.434 -15.038  19.135  1.00 31.27           C  
ATOM   1806  CD1 TYR A 234      22.743 -14.787  18.682  1.00 26.51           C  
ATOM   1807  CD2 TYR A 234      20.717 -13.978  19.699  1.00 30.59           C  
ATOM   1808  CE1 TYR A 234      23.294 -13.508  18.763  1.00 29.01           C  
ATOM   1809  CE2 TYR A 234      21.280 -12.710  19.816  1.00 25.98           C  
ATOM   1810  CZ  TYR A 234      22.565 -12.484  19.349  1.00 30.33           C  
ATOM   1811  OH  TYR A 234      23.102 -11.240  19.473  1.00 27.39           O  
ATOM   1812  N   ASP A 235      23.217 -17.535  20.569  1.00 24.36           N  
ATOM   1813  CA  ASP A 235      24.567 -17.239  21.075  1.00 28.68           C  
ATOM   1814  C   ASP A 235      25.559 -17.326  19.940  1.00 26.72           C  
ATOM   1815  O   ASP A 235      25.175 -17.659  18.839  1.00 30.84           O  
ATOM   1816  CB  ASP A 235      24.941 -18.164  22.246  1.00 31.92           C  
ATOM   1817  CG  ASP A 235      25.221 -19.613  21.824  1.00 37.36           C  
ATOM   1818  OD1 ASP A 235      24.949 -20.006  20.684  1.00 34.94           O  
ATOM   1819  OD2 ASP A 235      25.720 -20.372  22.667  1.00 53.17           O  
ATOM   1820  N   PHE A 236      26.813 -16.998  20.219  1.00 25.98           N  
ATOM   1821  CA  PHE A 236      27.911 -17.077  19.262  1.00 28.58           C  
ATOM   1822  C   PHE A 236      28.706 -18.358  19.562  1.00 29.32           C  
ATOM   1823  O   PHE A 236      29.811 -18.359  20.138  1.00 29.35           O  
ATOM   1824  CB  PHE A 236      28.786 -15.827  19.334  1.00 30.62           C  
ATOM   1825  CG  PHE A 236      28.099 -14.567  18.866  1.00 25.64           C  
ATOM   1826  CD1 PHE A 236      27.813 -14.374  17.513  1.00 26.19           C  
ATOM   1827  CD2 PHE A 236      27.751 -13.570  19.746  1.00 29.76           C  
ATOM   1828  CE1 PHE A 236      27.215 -13.211  17.069  1.00 22.66           C  
ATOM   1829  CE2 PHE A 236      27.130 -12.379  19.294  1.00 28.59           C  
ATOM   1830  CZ  PHE A 236      26.866 -12.213  17.955  1.00 28.91           C  
ATOM   1831  N   ASP A 237      28.107 -19.464  19.165  1.00 25.88           N  
ATOM   1832  CA  ASP A 237      28.649 -20.762  19.451  1.00 26.45           C  
ATOM   1833  C   ASP A 237      30.100 -20.861  19.007  1.00 27.59           C  
ATOM   1834  O   ASP A 237      30.435 -20.529  17.871  1.00 27.26           O  
ATOM   1835  CB  ASP A 237      27.784 -21.857  18.798  1.00 26.10           C  
ATOM   1836  CG  ASP A 237      28.105 -23.257  19.350  1.00 31.38           C  
ATOM   1837  OD1 ASP A 237      29.302 -23.626  19.445  1.00 33.06           O  
ATOM   1838  OD2 ASP A 237      27.145 -23.992  19.693  1.00 38.44           O  
ATOM   1839  N   GLU A 238      30.963 -21.307  19.919  1.00 32.25           N  
ATOM   1840  CA  GLU A 238      32.400 -21.486  19.635  1.00 28.60           C  
ATOM   1841  C   GLU A 238      32.711 -22.414  18.475  1.00 28.02           C  
ATOM   1842  O   GLU A 238      33.792 -22.318  17.909  1.00 26.66           O  
ATOM   1843  CB  GLU A 238      33.139 -21.999  20.889  1.00 37.54           C  
ATOM   1844  CG  GLU A 238      33.314 -20.943  21.969  1.00 46.44           C  
ATOM   1845  CD  GLU A 238      34.376 -19.932  21.598  1.00 49.06           C  
ATOM   1846  OE1 GLU A 238      35.570 -20.322  21.515  1.00 45.31           O  
ATOM   1847  OE2 GLU A 238      34.012 -18.764  21.357  1.00 45.90           O  
ATOM   1848  N   GLU A 239      31.786 -23.317  18.116  1.00 27.60           N  
ATOM   1849  CA  GLU A 239      31.975 -24.175  16.938  1.00 25.25           C  
ATOM   1850  C   GLU A 239      32.222 -23.332  15.688  1.00 26.27           C  
ATOM   1851  O   GLU A 239      32.926 -23.788  14.781  1.00 23.82           O  
ATOM   1852  CB  GLU A 239      30.752 -25.068  16.689  1.00 23.45           C  
ATOM   1853  CG  GLU A 239      30.996 -26.223  15.634  1.00 29.46           C  
ATOM   1854  CD  GLU A 239      29.828 -27.190  15.488  1.00 43.34           C  
ATOM   1855  OE1 GLU A 239      28.894 -27.130  16.333  1.00 28.51           O  
ATOM   1856  OE2 GLU A 239      29.850 -27.999  14.512  1.00 30.13           O  
ATOM   1857  N   TYR A 240      31.575 -22.159  15.614  1.00 22.84           N  
ATOM   1858  CA  TYR A 240      31.636 -21.326  14.410  1.00 23.85           C  
ATOM   1859  C   TYR A 240      32.342 -19.992  14.631  1.00 26.77           C  
ATOM   1860  O   TYR A 240      32.880 -19.418  13.673  1.00 23.64           O  
ATOM   1861  CB  TYR A 240      30.241 -21.040  13.868  1.00 24.69           C  
ATOM   1862  CG  TYR A 240      29.291 -22.216  13.940  1.00 25.79           C  
ATOM   1863  CD1 TYR A 240      29.458 -23.315  13.126  1.00 30.40           C  
ATOM   1864  CD2 TYR A 240      28.222 -22.216  14.843  1.00 25.61           C  
ATOM   1865  CE1 TYR A 240      28.599 -24.406  13.208  1.00 30.13           C  
ATOM   1866  CE2 TYR A 240      27.367 -23.307  14.942  1.00 27.90           C  
ATOM   1867  CZ  TYR A 240      27.563 -24.392  14.112  1.00 29.26           C  
ATOM   1868  OH  TYR A 240      26.721 -25.469  14.189  1.00 29.44           O  
ATOM   1869  N   PHE A 241      32.255 -19.448  15.836  1.00 25.76           N  
ATOM   1870  CA  PHE A 241      32.657 -18.050  16.062  1.00 26.54           C  
ATOM   1871  C   PHE A 241      33.915 -17.879  16.890  1.00 30.56           C  
ATOM   1872  O   PHE A 241      34.203 -16.765  17.348  1.00 27.36           O  
ATOM   1873  CB  PHE A 241      31.521 -17.259  16.727  1.00 25.56           C  
ATOM   1874  CG  PHE A 241      30.320 -17.073  15.843  1.00 23.66           C  
ATOM   1875  CD1 PHE A 241      30.237 -15.996  14.972  1.00 28.77           C  
ATOM   1876  CD2 PHE A 241      29.277 -17.995  15.887  1.00 22.91           C  
ATOM   1877  CE1 PHE A 241      29.138 -15.816  14.171  1.00 24.05           C  
ATOM   1878  CE2 PHE A 241      28.169 -17.832  15.121  1.00 21.48           C  
ATOM   1879  CZ  PHE A 241      28.080 -16.743  14.232  1.00 23.61           C  
ATOM   1880  N   SER A 242      34.678 -18.947  17.098  1.00 28.85           N  
ATOM   1881  CA  SER A 242      35.830 -18.843  17.992  1.00 30.06           C  
ATOM   1882  C   SER A 242      36.838 -17.774  17.550  1.00 35.78           C  
ATOM   1883  O   SER A 242      37.501 -17.161  18.402  1.00 40.22           O  
ATOM   1884  CB  SER A 242      36.556 -20.180  18.143  1.00 29.96           C  
ATOM   1885  OG  SER A 242      37.059 -20.649  16.896  1.00 34.66           O  
ATOM   1886  N   ASN A 243      36.951 -17.569  16.235  1.00 32.18           N  
ATOM   1887  CA  ASN A 243      37.872 -16.594  15.655  1.00 29.63           C  
ATOM   1888  C   ASN A 243      37.201 -15.352  15.034  1.00 38.13           C  
ATOM   1889  O   ASN A 243      37.866 -14.559  14.361  1.00 32.60           O  
ATOM   1890  CB  ASN A 243      38.756 -17.283  14.650  1.00 35.98           C  
ATOM   1891  CG  ASN A 243      39.719 -18.287  15.327  1.00 35.61           C  
ATOM   1892  OD1 ASN A 243      40.254 -18.023  16.418  1.00 56.85           O  
ATOM   1893  ND2 ASN A 243      39.928 -19.433  14.684  1.00 54.84           N  
ATOM   1894  N   THR A 244      35.910 -15.154  15.306  1.00 26.67           N  
ATOM   1895  CA  THR A 244      35.205 -13.963  14.827  1.00 23.99           C  
ATOM   1896  C   THR A 244      35.562 -12.715  15.640  1.00 26.62           C  
ATOM   1897  O   THR A 244      35.629 -12.762  16.879  1.00 32.29           O  
ATOM   1898  CB  THR A 244      33.676 -14.204  14.839  1.00 24.87           C  
ATOM   1899  OG1 THR A 244      33.386 -15.386  14.071  1.00 27.51           O  
ATOM   1900  CG2 THR A 244      32.932 -13.004  14.243  1.00 23.05           C  
ATOM   1901  N   SER A 245      35.767 -11.591  14.944  1.00 27.94           N  
ATOM   1902  CA  SER A 245      36.119 -10.320  15.593  1.00 28.16           C  
ATOM   1903  C   SER A 245      35.057  -9.785  16.544  1.00 28.28           C  
ATOM   1904  O   SER A 245      33.854  -9.998  16.389  1.00 26.32           O  
ATOM   1905  CB  SER A 245      36.478  -9.228  14.563  1.00 27.77           C  
ATOM   1906  OG  SER A 245      35.317  -8.702  13.938  1.00 24.77           O  
ATOM   1907  N   GLU A 246      35.516  -9.056  17.547  1.00 28.72           N  
ATOM   1908  CA  GLU A 246      34.580  -8.403  18.458  1.00 29.68           C  
ATOM   1909  C   GLU A 246      33.688  -7.391  17.736  1.00 24.18           C  
ATOM   1910  O   GLU A 246      32.500  -7.274  18.049  1.00 26.84           O  
ATOM   1911  CB  GLU A 246      35.321  -7.749  19.631  1.00 32.44           C  
ATOM   1912  CG  GLU A 246      35.897  -8.793  20.601  1.00 43.37           C  
ATOM   1913  CD  GLU A 246      34.829  -9.723  21.167  1.00 42.27           C  
ATOM   1914  OE1 GLU A 246      33.757  -9.234  21.575  1.00 46.70           O  
ATOM   1915  OE2 GLU A 246      35.077 -10.947  21.208  1.00 60.06           O  
ATOM   1916  N   LEU A 247      34.243  -6.702  16.749  1.00 25.41           N  
ATOM   1917  CA  LEU A 247      33.449  -5.757  15.968  1.00 25.04           C  
ATOM   1918  C   LEU A 247      32.314  -6.452  15.199  1.00 27.69           C  
ATOM   1919  O   LEU A 247      31.224  -5.933  15.133  1.00 26.24           O  
ATOM   1920  CB  LEU A 247      34.345  -4.988  14.996  1.00 28.05           C  
ATOM   1921  CG  LEU A 247      35.067  -3.777  15.610  1.00 29.38           C  
ATOM   1922  CD1 LEU A 247      36.099  -3.300  14.617  1.00 27.27           C  
ATOM   1923  CD2 LEU A 247      34.089  -2.672  15.986  1.00 34.34           C  
ATOM   1924  N   ALA A 248      32.579  -7.620  14.621  1.00 25.86           N  
ATOM   1925  CA  ALA A 248      31.525  -8.363  13.864  1.00 23.98           C  
ATOM   1926  C   ALA A 248      30.441  -8.782  14.842  1.00 25.79           C  
ATOM   1927  O   ALA A 248      29.254  -8.612  14.565  1.00 27.75           O  
ATOM   1928  CB  ALA A 248      32.119  -9.580  13.142  1.00 22.39           C  
ATOM   1929  N   LYS A 249      30.838  -9.269  16.019  1.00 21.80           N  
ATOM   1930  CA  LYS A 249      29.838  -9.643  17.055  1.00 28.27           C  
ATOM   1931  C   LYS A 249      29.037  -8.438  17.538  1.00 28.72           C  
ATOM   1932  O   LYS A 249      27.848  -8.521  17.754  1.00 25.76           O  
ATOM   1933  CB  LYS A 249      30.490 -10.384  18.240  1.00 27.08           C  
ATOM   1934  CG  LYS A 249      31.002 -11.756  17.842  1.00 25.48           C  
ATOM   1935  CD  LYS A 249      31.482 -12.619  19.002  1.00 29.33           C  
ATOM   1936  CE  LYS A 249      32.891 -12.258  19.413  1.00 48.28           C  
ATOM   1937  NZ  LYS A 249      33.352 -13.085  20.579  1.00 45.38           N  
ATOM   1938  N   ASP A 250      29.695  -7.306  17.730  1.00 25.97           N  
ATOM   1939  CA  ASP A 250      28.988  -6.110  18.139  1.00 25.43           C  
ATOM   1940  C   ASP A 250      27.937  -5.649  17.110  1.00 22.65           C  
ATOM   1941  O   ASP A 250      26.857  -5.178  17.468  1.00 26.13           O  
ATOM   1942  CB  ASP A 250      29.998  -4.964  18.360  1.00 24.28           C  
ATOM   1943  CG  ASP A 250      29.359  -3.739  18.919  1.00 32.40           C  
ATOM   1944  OD1 ASP A 250      28.863  -3.808  20.069  1.00 31.17           O  
ATOM   1945  OD2 ASP A 250      29.363  -2.699  18.218  1.00 29.37           O  
ATOM   1946  N   PHE A 251      28.301  -5.708  15.843  1.00 22.89           N  
ATOM   1947  CA  PHE A 251      27.398  -5.353  14.734  1.00 24.86           C  
ATOM   1948  C   PHE A 251      26.098  -6.192  14.814  1.00 24.18           C  
ATOM   1949  O   PHE A 251      24.955  -5.672  14.773  1.00 23.99           O  
ATOM   1950  CB  PHE A 251      28.152  -5.553  13.410  1.00 24.49           C  
ATOM   1951  CG  PHE A 251      27.352  -5.211  12.168  1.00 25.46           C  
ATOM   1952  CD1 PHE A 251      27.261  -3.880  11.735  1.00 29.51           C  
ATOM   1953  CD2 PHE A 251      26.691  -6.185  11.435  1.00 29.57           C  
ATOM   1954  CE1 PHE A 251      26.516  -3.564  10.590  1.00 23.24           C  
ATOM   1955  CE2 PHE A 251      25.977  -5.867  10.303  1.00 24.30           C  
ATOM   1956  CZ  PHE A 251      25.889  -4.555   9.862  1.00 27.45           C  
ATOM   1957  N   ILE A 252      26.270  -7.489  15.000  1.00 21.49           N  
ATOM   1958  CA  ILE A 252      25.144  -8.412  15.065  1.00 25.41           C  
ATOM   1959  C   ILE A 252      24.343  -8.131  16.335  1.00 23.38           C  
ATOM   1960  O   ILE A 252      23.126  -8.027  16.296  1.00 24.49           O  
ATOM   1961  CB  ILE A 252      25.647  -9.878  15.023  1.00 23.40           C  
ATOM   1962  CG1 ILE A 252      26.247 -10.178  13.641  1.00 25.42           C  
ATOM   1963  CG2 ILE A 252      24.551 -10.820  15.397  1.00 25.70           C  
ATOM   1964  CD1 ILE A 252      27.058 -11.524  13.565  1.00 22.23           C  
ATOM   1965  N   ARG A 253      25.026  -7.956  17.473  1.00 25.50           N  
ATOM   1966  CA  ARG A 253      24.288  -7.732  18.741  1.00 26.54           C  
ATOM   1967  C   ARG A 253      23.434  -6.493  18.683  1.00 27.55           C  
ATOM   1968  O   ARG A 253      22.364  -6.443  19.275  1.00 29.00           O  
ATOM   1969  CB  ARG A 253      25.241  -7.572  19.943  1.00 29.20           C  
ATOM   1970  CG  ARG A 253      25.810  -8.825  20.461  1.00 35.15           C  
ATOM   1971  CD  ARG A 253      26.445  -8.596  21.845  1.00 34.00           C  
ATOM   1972  NE  ARG A 253      27.349  -9.699  22.113  1.00 35.54           N  
ATOM   1973  CZ  ARG A 253      28.647  -9.692  21.813  1.00 34.35           C  
ATOM   1974  NH1 ARG A 253      29.224  -8.602  21.312  1.00 39.67           N  
ATOM   1975  NH2 ARG A 253      29.375 -10.775  22.043  1.00 35.51           N  
ATOM   1976  N   ARG A 254      23.947  -5.456  18.030  1.00 24.39           N  
ATOM   1977  CA  ARG A 254      23.246  -4.169  17.951  1.00 28.30           C  
ATOM   1978  C   ARG A 254      22.043  -4.191  16.984  1.00 27.69           C  
ATOM   1979  O   ARG A 254      21.205  -3.271  16.987  1.00 25.39           O  
ATOM   1980  CB  ARG A 254      24.249  -3.080  17.604  1.00 29.05           C  
ATOM   1981  CG  ARG A 254      25.111  -2.733  18.837  1.00 30.79           C  
ATOM   1982  CD  ARG A 254      26.193  -1.679  18.574  1.00 37.34           C  
ATOM   1983  NE  ARG A 254      25.611  -0.394  18.198  1.00 55.37           N  
ATOM   1984  CZ  ARG A 254      26.312   0.658  17.788  1.00 63.08           C  
ATOM   1985  NH1 ARG A 254      27.639   0.599  17.698  1.00 72.97           N  
ATOM   1986  NH2 ARG A 254      25.676   1.775  17.456  1.00 77.49           N  
ATOM   1987  N   LEU A 255      21.947  -5.255  16.192  1.00 24.24           N  
ATOM   1988  CA  LEU A 255      20.792  -5.513  15.326  1.00 21.50           C  
ATOM   1989  C   LEU A 255      19.786  -6.533  15.873  1.00 26.16           C  
ATOM   1990  O   LEU A 255      18.577  -6.376  15.653  1.00 26.59           O  
ATOM   1991  CB  LEU A 255      21.271  -5.993  13.959  1.00 25.80           C  
ATOM   1992  CG  LEU A 255      22.043  -4.958  13.150  1.00 26.19           C  
ATOM   1993  CD1 LEU A 255      22.775  -5.707  11.997  1.00 27.35           C  
ATOM   1994  CD2 LEU A 255      21.107  -3.858  12.637  1.00 28.20           C  
ATOM   1995  N   LEU A 256      20.282  -7.566  16.558  1.00 26.43           N  
ATOM   1996  CA  LEU A 256      19.421  -8.600  17.131  1.00 25.15           C  
ATOM   1997  C   LEU A 256      18.901  -8.193  18.525  1.00 27.33           C  
ATOM   1998  O   LEU A 256      19.275  -8.769  19.554  1.00 31.94           O  
ATOM   1999  CB  LEU A 256      20.141  -9.947  17.122  1.00 26.57           C  
ATOM   2000  CG  LEU A 256      20.598 -10.448  15.742  1.00 21.12           C  
ATOM   2001  CD1 LEU A 256      21.140 -11.898  15.853  1.00 21.64           C  
ATOM   2002  CD2 LEU A 256      19.440 -10.382  14.775  1.00 26.26           C  
ATOM   2003  N   VAL A 257      18.038  -7.184  18.520  1.00 28.03           N  
ATOM   2004  CA  VAL A 257      17.494  -6.551  19.743  1.00 29.95           C  
ATOM   2005  C   VAL A 257      15.979  -6.675  19.686  1.00 31.94           C  
ATOM   2006  O   VAL A 257      15.383  -6.358  18.662  1.00 31.02           O  
ATOM   2007  CB  VAL A 257      17.896  -5.049  19.825  1.00 33.96           C  
ATOM   2008  CG1 VAL A 257      17.390  -4.420  21.121  1.00 28.20           C  
ATOM   2009  CG2 VAL A 257      19.428  -4.892  19.699  1.00 32.65           C  
ATOM   2010  N   LYS A 258      15.364  -7.163  20.766  1.00 29.49           N  
ATOM   2011  CA  LYS A 258      13.930  -7.400  20.823  1.00 30.59           C  
ATOM   2012  C   LYS A 258      13.158  -6.115  20.541  1.00 28.67           C  
ATOM   2013  O   LYS A 258      12.241  -6.094  19.701  1.00 32.61           O  
ATOM   2014  CB  LYS A 258      13.553  -7.935  22.206  1.00 36.51           C  
ATOM   2015  CG  LYS A 258      12.076  -8.171  22.482  1.00 41.88           C  
ATOM   2016  CD  LYS A 258      11.582  -9.482  21.982  1.00 47.13           C  
ATOM   2017  CE  LYS A 258      10.228  -9.852  22.634  1.00 48.96           C  
ATOM   2018  NZ  LYS A 258       9.422 -10.830  21.797  1.00 44.30           N  
ATOM   2019  N   ASP A 259      13.513  -5.059  21.257  1.00 29.29           N  
ATOM   2020  CA  ASP A 259      12.849  -3.768  21.109  1.00 32.92           C  
ATOM   2021  C   ASP A 259      13.281  -3.092  19.808  1.00 30.15           C  
ATOM   2022  O   ASP A 259      14.421  -2.684  19.684  1.00 27.33           O  
ATOM   2023  CB  ASP A 259      13.179  -2.849  22.277  1.00 30.79           C  
ATOM   2024  CG  ASP A 259      12.391  -1.541  22.243  1.00 37.67           C  
ATOM   2025  OD1 ASP A 259      11.647  -1.289  21.262  1.00 32.53           O  
ATOM   2026  OD2 ASP A 259      12.522  -0.752  23.215  1.00 38.03           O  
ATOM   2027  N   PRO A 260      12.358  -2.983  18.833  1.00 30.00           N  
ATOM   2028  CA  PRO A 260      12.752  -2.391  17.535  1.00 30.62           C  
ATOM   2029  C   PRO A 260      13.360  -1.026  17.667  1.00 28.50           C  
ATOM   2030  O   PRO A 260      14.278  -0.684  16.901  1.00 32.49           O  
ATOM   2031  CB  PRO A 260      11.434  -2.281  16.766  1.00 28.02           C  
ATOM   2032  CG  PRO A 260      10.502  -3.210  17.471  1.00 35.13           C  
ATOM   2033  CD  PRO A 260      10.943  -3.357  18.865  1.00 29.72           C  
ATOM   2034  N   LYS A 261      12.844  -0.235  18.624  1.00 30.54           N  
ATOM   2035  CA  LYS A 261      13.324   1.125  18.837  1.00 32.89           C  
ATOM   2036  C   LYS A 261      14.753   1.173  19.353  1.00 32.74           C  
ATOM   2037  O   LYS A 261      15.356   2.221  19.328  1.00 34.09           O  
ATOM   2038  CB  LYS A 261      12.415   1.892  19.818  1.00 34.61           C  
ATOM   2039  CG  LYS A 261      10.996   2.062  19.321  1.00 39.95           C  
ATOM   2040  CD  LYS A 261      10.117   2.722  20.396  1.00 46.47           C  
ATOM   2041  N   ARG A 262      15.302   0.056  19.815  1.00 29.43           N  
ATOM   2042  CA  ARG A 262      16.708   0.049  20.296  1.00 27.61           C  
ATOM   2043  C   ARG A 262      17.696  -0.556  19.297  1.00 32.99           C  
ATOM   2044  O   ARG A 262      18.926  -0.598  19.567  1.00 30.13           O  
ATOM   2045  CB  ARG A 262      16.830  -0.681  21.649  1.00 36.75           C  
ATOM   2046  CG  ARG A 262      15.997  -0.070  22.796  1.00 44.46           C  
ATOM   2047  CD  ARG A 262      16.436   1.363  23.147  1.00 63.38           C  
ATOM   2048  NE  ARG A 262      17.388   1.407  24.259  1.00 82.17           N  
ATOM   2049  CZ  ARG A 262      17.061   1.490  25.555  1.00100.54           C  
ATOM   2050  NH1 ARG A 262      15.787   1.532  25.955  1.00 97.05           N  
ATOM   2051  NH2 ARG A 262      18.026   1.527  26.471  1.00109.92           N  
ATOM   2052  N   ARG A 263      17.189  -1.013  18.148  1.00 29.36           N  
ATOM   2053  CA  ARG A 263      18.070  -1.553  17.071  1.00 31.05           C  
ATOM   2054  C   ARG A 263      18.778  -0.446  16.320  1.00 30.08           C  
ATOM   2055  O   ARG A 263      18.220   0.638  16.125  1.00 29.42           O  
ATOM   2056  CB  ARG A 263      17.272  -2.313  16.022  1.00 34.58           C  
ATOM   2057  CG  ARG A 263      16.948  -3.670  16.338  1.00 34.79           C  
ATOM   2058  CD  ARG A 263      16.057  -4.307  15.292  1.00 27.55           C  
ATOM   2059  NE  ARG A 263      15.134  -5.082  16.072  1.00 25.67           N  
ATOM   2060  CZ  ARG A 263      13.886  -5.390  15.774  1.00 27.95           C  
ATOM   2061  NH1 ARG A 263      13.381  -5.050  14.620  1.00 26.58           N  
ATOM   2062  NH2 ARG A 263      13.162  -6.068  16.669  1.00 27.13           N  
ATOM   2063  N   MET A 264      19.990  -0.738  15.837  1.00 28.59           N  
ATOM   2064  CA  MET A 264      20.657   0.163  14.907  1.00 29.79           C  
ATOM   2065  C   MET A 264      19.751   0.413  13.708  1.00 25.26           C  
ATOM   2066  O   MET A 264      19.117  -0.519  13.183  1.00 27.96           O  
ATOM   2067  CB  MET A 264      21.977  -0.405  14.390  1.00 31.41           C  
ATOM   2068  CG  MET A 264      23.125  -0.257  15.283  1.00 34.89           C  
ATOM   2069  SD  MET A 264      24.705  -0.502  14.468  1.00 29.16           S  
ATOM   2070  CE  MET A 264      24.566  -2.216  13.842  1.00 27.58           C  
ATOM   2071  N   THR A 265      19.701   1.677  13.299  1.00 29.15           N  
ATOM   2072  CA  THR A 265      19.059   2.107  12.059  1.00 27.49           C  
ATOM   2073  C   THR A 265      19.993   1.811  10.885  1.00 21.76           C  
ATOM   2074  O   THR A 265      21.177   1.472  11.065  1.00 25.33           O  
ATOM   2075  CB  THR A 265      18.827   3.642  12.078  1.00 26.21           C  
ATOM   2076  OG1 THR A 265      20.105   4.307  12.146  1.00 28.27           O  
ATOM   2077  CG2 THR A 265      17.900   4.058  13.241  1.00 27.03           C  
ATOM   2078  N   ILE A 266      19.471   1.949   9.665  1.00 23.76           N  
ATOM   2079  CA  ILE A 266      20.308   1.678   8.490  1.00 24.98           C  
ATOM   2080  C   ILE A 266      21.505   2.679   8.453  1.00 24.62           C  
ATOM   2081  O   ILE A 266      22.660   2.310   8.143  1.00 23.75           O  
ATOM   2082  CB  ILE A 266      19.444   1.672   7.190  1.00 24.55           C  
ATOM   2083  CG1 ILE A 266      20.286   1.180   5.999  1.00 28.21           C  
ATOM   2084  CG2 ILE A 266      18.732   3.037   6.955  1.00 22.93           C  
ATOM   2085  CD1 ILE A 266      20.793  -0.222   6.196  1.00 27.05           C  
ATOM   2086  N   ALA A 267      21.254   3.950   8.790  1.00 26.60           N  
ATOM   2087  CA  ALA A 267      22.352   4.952   8.861  1.00 28.79           C  
ATOM   2088  C   ALA A 267      23.420   4.543   9.888  1.00 26.33           C  
ATOM   2089  O   ALA A 267      24.631   4.624   9.631  1.00 26.93           O  
ATOM   2090  CB  ALA A 267      21.791   6.347   9.170  1.00 31.17           C  
ATOM   2091  N   GLN A 268      22.976   4.113  11.059  1.00 28.50           N  
ATOM   2092  CA  GLN A 268      23.924   3.677  12.094  1.00 27.27           C  
ATOM   2093  C   GLN A 268      24.739   2.455  11.651  1.00 26.80           C  
ATOM   2094  O   GLN A 268      25.952   2.361  11.943  1.00 26.01           O  
ATOM   2095  CB  GLN A 268      23.185   3.395  13.384  1.00 29.97           C  
ATOM   2096  CG  GLN A 268      22.663   4.710  13.982  1.00 26.94           C  
ATOM   2097  CD  GLN A 268      21.753   4.512  15.162  1.00 36.89           C  
ATOM   2098  OE1 GLN A 268      21.014   3.533  15.251  1.00 32.52           O  
ATOM   2099  NE2 GLN A 268      21.778   5.471  16.070  1.00 36.13           N  
ATOM   2100  N   SER A 269      24.081   1.537  10.958  1.00 26.83           N  
ATOM   2101  CA  SER A 269      24.742   0.314  10.493  1.00 23.58           C  
ATOM   2102  C   SER A 269      25.870   0.641   9.523  1.00 23.49           C  
ATOM   2103  O   SER A 269      26.958   0.053   9.570  1.00 24.93           O  
ATOM   2104  CB  SER A 269      23.730  -0.602   9.819  0.50 25.52           C  
ATOM   2106  OG  SER A 269      22.783  -1.041  10.773  0.50 33.45           O  
ATOM   2108  N   LEU A 270      25.605   1.595   8.625  1.00 25.61           N  
ATOM   2109  CA  LEU A 270      26.605   2.012   7.630  1.00 26.06           C  
ATOM   2110  C   LEU A 270      27.799   2.731   8.276  1.00 30.07           C  
ATOM   2111  O   LEU A 270      28.876   2.778   7.686  1.00 30.55           O  
ATOM   2112  CB  LEU A 270      25.960   2.912   6.568  1.00 23.81           C  
ATOM   2113  CG  LEU A 270      25.083   2.189   5.526  1.00 28.12           C  
ATOM   2114  CD1 LEU A 270      24.176   3.226   4.860  1.00 31.77           C  
ATOM   2115  CD2 LEU A 270      25.967   1.481   4.498  1.00 30.37           C  
ATOM   2116  N   GLU A 271      27.591   3.321   9.451  1.00 29.02           N  
ATOM   2117  CA  GLU A 271      28.676   4.004  10.193  1.00 27.47           C  
ATOM   2118  C   GLU A 271      29.381   3.126  11.233  1.00 26.84           C  
ATOM   2119  O   GLU A 271      30.369   3.539  11.866  1.00 29.49           O  
ATOM   2120  CB  GLU A 271      28.154   5.261  10.898  1.00 33.99           C  
ATOM   2121  CG  GLU A 271      27.737   6.394   9.941  1.00 35.56           C  
ATOM   2122  CD  GLU A 271      28.783   6.666   8.839  1.00 57.79           C  
ATOM   2123  OE1 GLU A 271      29.965   6.844   9.197  1.00 49.13           O  
ATOM   2124  OE2 GLU A 271      28.420   6.688   7.626  1.00 58.66           O  
ATOM   2125  N   HIS A 272      28.893   1.913  11.411  1.00 26.10           N  
ATOM   2126  CA  HIS A 272      29.531   0.977  12.311  1.00 26.91           C  
ATOM   2127  C   HIS A 272      30.965   0.663  11.873  1.00 25.61           C  
ATOM   2128  O   HIS A 272      31.249   0.488  10.703  1.00 28.34           O  
ATOM   2129  CB  HIS A 272      28.684  -0.302  12.417  1.00 32.74           C  
ATOM   2130  CG  HIS A 272      29.078  -1.193  13.556  1.00 29.84           C  
ATOM   2131  ND1 HIS A 272      30.197  -1.997  13.519  1.00 28.73           N  
ATOM   2132  CD2 HIS A 272      28.498  -1.411  14.756  1.00 37.79           C  
ATOM   2133  CE1 HIS A 272      30.283  -2.673  14.647  1.00 28.19           C  
ATOM   2134  NE2 HIS A 272      29.266  -2.338  15.417  1.00 29.07           N  
ATOM   2135  N   SER A 273      31.870   0.592  12.848  1.00 28.28           N  
ATOM   2136  CA  SER A 273      33.270   0.330  12.583  1.00 28.31           C  
ATOM   2137  C   SER A 273      33.564  -0.917  11.777  1.00 27.01           C  
ATOM   2138  O   SER A 273      34.503  -0.926  10.958  1.00 29.48           O  
ATOM   2139  CB  SER A 273      34.026   0.291  13.908  1.00 29.19           C  
ATOM   2140  OG  SER A 273      33.980   1.573  14.473  1.00 36.94           O  
ATOM   2141  N   TRP A 274      32.759  -1.962  11.951  1.00 30.06           N  
ATOM   2142  CA  TRP A 274      32.968  -3.193  11.207  1.00 24.39           C  
ATOM   2143  C   TRP A 274      32.742  -2.965   9.713  1.00 27.68           C  
ATOM   2144  O   TRP A 274      33.451  -3.525   8.872  1.00 28.77           O  
ATOM   2145  CB  TRP A 274      32.027  -4.292  11.731  1.00 29.22           C  
ATOM   2146  CG  TRP A 274      32.350  -5.643  11.185  1.00 28.61           C  
ATOM   2147  CD1 TRP A 274      33.552  -6.297  11.271  1.00 29.25           C  
ATOM   2148  CD2 TRP A 274      31.472  -6.515  10.462  1.00 25.60           C  
ATOM   2149  NE1 TRP A 274      33.463  -7.524  10.653  1.00 25.76           N  
ATOM   2150  CE2 TRP A 274      32.205  -7.676  10.145  1.00 22.72           C  
ATOM   2151  CE3 TRP A 274      30.140  -6.431  10.069  1.00 24.48           C  
ATOM   2152  CZ2 TRP A 274      31.649  -8.752   9.426  1.00 27.73           C  
ATOM   2153  CZ3 TRP A 274      29.579  -7.496   9.359  1.00 29.84           C  
ATOM   2154  CH2 TRP A 274      30.341  -8.650   9.052  1.00 24.24           C  
ATOM   2155  N   ILE A 275      31.752  -2.125   9.379  1.00 25.97           N  
ATOM   2156  CA  ILE A 275      31.449  -1.797   7.990  1.00 26.94           C  
ATOM   2157  C   ILE A 275      32.357  -0.710   7.424  1.00 31.83           C  
ATOM   2158  O   ILE A 275      32.781  -0.786   6.284  1.00 30.58           O  
ATOM   2159  CB  ILE A 275      29.967  -1.362   7.867  1.00 26.49           C  
ATOM   2160  CG1 ILE A 275      29.058  -2.546   8.256  1.00 27.02           C  
ATOM   2161  CG2 ILE A 275      29.660  -0.930   6.480  1.00 28.20           C  
ATOM   2162  CD1 ILE A 275      29.149  -3.753   7.287  1.00 31.14           C  
ATOM   2163  N   LYS A 276      32.621   0.304   8.226  1.00 30.93           N  
ATOM   2164  CA  LYS A 276      33.583   1.373   7.863  1.00 43.55           C  
ATOM   2165  C   LYS A 276      35.011   0.870   7.593  1.00 48.25           C  
ATOM   2166  O   LYS A 276      35.704   1.429   6.741  1.00 48.71           O  
ATOM   2167  CB  LYS A 276      33.631   2.426   8.964  1.00 42.50           C  
ATOM   2168  CG  LYS A 276      32.321   3.147   9.175  1.00 51.06           C  
ATOM   2169  CD  LYS A 276      32.095   4.178   8.094  1.00 57.07           C  
ATOM   2170  CE  LYS A 276      32.754   5.510   8.427  1.00 60.20           C  
ATOM   2171  NZ  LYS A 276      32.451   6.474   7.346  1.00 48.92           N  
ATOM   2172  N   ALA A 277      35.430  -0.182   8.309  1.00 50.77           N  
ATOM   2173  CA  ALA A 277      36.805  -0.697   8.259  1.00 52.26           C  
ATOM   2174  C   ALA A 277      37.360  -0.858   6.835  1.00 54.58           C  
ATOM   2175  O   ALA A 277      36.690  -1.394   5.944  1.00 52.42           O  
ATOM   2176  CB  ALA A 277      36.909  -2.023   9.020  1.00 53.94           C  
ATOM   2177  N   ILE A 278      38.587  -0.366   6.640  1.00 60.96           N  
ATOM   2178  CA  ILE A 278      39.299  -0.475   5.364  1.00 61.83           C  
ATOM   2179  C   ILE A 278      39.766  -1.925   5.179  1.00 61.74           C  
ATOM   2180  O   ILE A 278      40.446  -2.480   6.055  1.00 59.05           O  
ATOM   2181  CB  ILE A 278      40.507   0.510   5.290  1.00 61.72           C  
ATOM   2182  CG1 ILE A 278      40.022   1.967   5.219  1.00 68.07           C  
ATOM   2183  CG2 ILE A 278      41.393   0.203   4.083  1.00 59.07           C  
ATOM   2184  CD1 ILE A 278      39.367   2.356   3.877  1.00 55.56           C  
ATOM   2185  N   ARG A 279      39.362  -2.533   4.055  1.00 62.44           N  
ATOM   2186  CA  ARG A 279      39.659  -3.940   3.727  1.00 58.66           C  
ATOM   2187  C   ARG A 279      40.120  -4.057   2.278  1.00 62.57           C  
ATOM   2188  O   ARG A 279      39.793  -3.198   1.446  1.00 63.34           O  
ATOM   2189  CB  ARG A 279      38.404  -4.810   3.893  1.00 55.01           C  
ATOM   2190  CG  ARG A 279      37.929  -4.994   5.322  1.00 55.16           C  
ATOM   2191  CD  ARG A 279      36.486  -5.517   5.394  1.00 40.97           C  
ATOM   2192  NE  ARG A 279      35.906  -5.210   6.703  1.00 44.84           N  
ATOM   2193  CZ  ARG A 279      36.002  -5.979   7.779  1.00 43.94           C  
ATOM   2194  NH1 ARG A 279      35.470  -5.561   8.917  1.00 32.49           N  
ATOM   2195  NH2 ARG A 279      36.650  -7.141   7.734  1.00 41.23           N  
ATOM   2196  N   ARG A 280      40.863  -5.126   1.978  1.00 62.39           N  
ATOM   2197  CA  ARG A 280      41.201  -5.478   0.585  1.00 66.40           C  
ATOM   2198  C   ARG A 280      40.008  -6.167  -0.133  1.00 66.48           C  
ATOM   2199  O   ARG A 280      39.287  -6.986   0.474  1.00 60.14           O  
ATOM   2200  CB  ARG A 280      42.452  -6.373   0.531  1.00 63.33           C  
ATOM   2201  N   ARG A 281      39.790  -5.794  -1.406  1.00 65.72           N  
ATOM   2202  CA  ARG A 281      38.853  -6.501  -2.302  1.00 61.78           C  
ATOM   2203  C   ARG A 281      39.393  -7.922  -2.461  1.00 65.03           C  
ATOM   2204  O   ARG A 281      40.612  -8.106  -2.537  1.00 68.04           O  
ATOM   2205  CB  ARG A 281      38.772  -5.801  -3.664  1.00 55.87           C  
ATOM   2206  N   ASN A 282      38.520  -8.930  -2.487  1.00 66.56           N  
ATOM   2207  CA  ASN A 282      39.013 -10.316  -2.441  1.00 73.55           C  
ATOM   2208  C   ASN A 282      39.572 -10.790  -3.788  1.00 76.75           C  
ATOM   2209  O   ASN A 282      39.084 -10.395  -4.852  1.00 77.86           O  
ATOM   2210  CB  ASN A 282      37.961 -11.294  -1.889  1.00 74.31           C  
ATOM   2211  CG  ASN A 282      37.709 -11.104  -0.385  1.00 75.15           C  
ATOM   2212  OD1 ASN A 282      38.508 -11.523   0.493  1.00 42.79           O  
ATOM   2213  ND2 ASN A 282      36.597 -10.464  -0.085  1.00 34.98           N  
ATOM   2214  N   VAL A 283      40.621 -11.611  -3.715  1.00 78.49           N  
ATOM   2215  CA  VAL A 283      41.316 -12.139  -4.888  1.00 77.93           C  
ATOM   2216  C   VAL A 283      40.772 -13.549  -5.207  1.00 83.43           C  
ATOM   2217  O   VAL A 283      40.107 -14.162  -4.367  1.00 85.97           O  
ATOM   2218  CB  VAL A 283      42.859 -12.140  -4.662  1.00 77.26           C  
ATOM   2219  CG1 VAL A 283      43.319 -10.776  -4.164  1.00 67.47           C  
ATOM   2220  CG2 VAL A 283      43.284 -13.227  -3.679  1.00 74.59           C  
ATOM   2221  N   ARG A 284      41.028 -14.046  -6.419  1.00 86.41           N  
ATOM   2222  CA  ARG A 284      40.514 -15.355  -6.848  1.00 87.71           C  
ATOM   2223  C   ARG A 284      41.504 -16.475  -6.525  1.00 88.03           C  
ATOM   2224  O   ARG A 284      42.220 -16.419  -5.522  1.00 87.24           O  
ATOM   2225  CB  ARG A 284      40.204 -15.343  -8.348  1.00 88.10           C  
TER    2226      ARG A 284                                                      
END
MOLECULE T0456.pdb
ATOM      1  N   TYR    15      -8.528 -16.941 -28.683  1.00 32.70           N
ATOM      2  CA  TYR    15      -7.549 -17.202 -27.583  1.00 32.76           C
ATOM      3  CB  TYR    15      -6.142 -17.430 -28.151  1.00 32.76           C
ATOM      4  CG  TYR    15      -5.905 -18.852 -28.611  1.00 32.74           C
ATOM      5  CD1 TYR    15      -5.266 -19.775 -27.781  1.00 32.73           C
ATOM      6  CE1 TYR    15      -5.050 -21.089 -28.196  1.00 32.87           C
ATOM      7  CZ  TYR    15      -5.483 -21.489 -29.454  1.00 32.91           C
ATOM      8  OH  TYR    15      -5.276 -22.784 -29.874  1.00 32.88           O
ATOM      9  CE2 TYR    15      -6.124 -20.591 -30.294  1.00 32.90           C
ATOM     10  CD2 TYR    15      -6.332 -19.280 -29.869  1.00 32.82           C
ATOM     11  C   TYR    15      -7.535 -16.113 -26.506  1.00 32.75           C
ATOM     12  O   TYR    15      -6.929 -16.296 -25.446  1.00 32.76           O
ATOM     13  N   PHE    16      -8.206 -14.992 -26.789  1.00 32.74           N
ATOM     14  CA  PHE    16      -8.354 -13.855 -25.863  1.00 32.72           C
ATOM     15  CB  PHE    16      -9.652 -13.975 -25.047  1.00 32.54           C
ATOM     16  CG  PHE    16     -10.905 -13.868 -25.873  1.00 32.23           C
ATOM     17  CD1 PHE    16     -11.621 -15.008 -26.221  1.00 31.82           C
ATOM     18  CE1 PHE    16     -12.782 -14.917 -26.986  1.00 31.83           C
ATOM     19  CZ  PHE    16     -13.235 -13.672 -27.411  1.00 32.10           C
ATOM     20  CE2 PHE    16     -12.527 -12.524 -27.068  1.00 31.82           C
ATOM     21  CD2 PHE    16     -11.370 -12.627 -26.302  1.00 31.90           C
ATOM     22  C   PHE    16      -7.152 -13.637 -24.939  1.00 32.93           C
ATOM     23  O   PHE    16      -7.300 -13.533 -23.717  1.00 32.92           O
ATOM     24  N   GLN    17      -5.966 -13.576 -25.541  1.00 33.17           N
ATOM     25  CA  GLN    17      -4.715 -13.408 -24.806  1.00 33.34           C
ATOM     26  CB  GLN    17      -3.528 -13.756 -25.699  1.00 33.35           C
ATOM     27  C   GLN    17      -4.591 -11.984 -24.263  1.00 33.46           C
ATOM     28  O   GLN    17      -5.263 -11.067 -24.746  1.00 33.47           O
ATOM     29  N   GLY    18      -3.737 -11.810 -23.257  1.00 33.55           N
ATOM     30  CA  GLY    18      -3.571 -10.516 -22.595  1.00 33.66           C
ATOM     31  C   GLY    18      -2.540  -9.611 -23.244  1.00 33.70           C
ATOM     32  O   GLY    18      -2.092  -9.863 -24.369  1.00 33.70           O
ATOM     33  N   THR    19      -2.168  -8.553 -22.525  1.00 33.69           N
ATOM     34  CA  THR    19      -1.147  -7.605 -22.973  1.00 33.69           C
ATOM     35  CB  THR    19      -1.157  -6.323 -22.113  1.00 33.65           C
ATOM     38  C   THR    19       0.251  -8.233 -22.948  1.00 33.68           C
ATOM     39  O   THR    19       1.166  -7.772 -23.644  1.00 33.76           O
ATOM     40  N   PHE    20       0.396  -9.289 -22.148  1.00 33.56           N
ATOM     41  CA  PHE    20       1.654 -10.016 -22.004  1.00 33.45           C
ATOM     42  CB  PHE    20       1.632 -10.882 -20.734  1.00 33.44           C
ATOM     43  CG  PHE    20       2.713 -11.927 -20.688  1.00 33.35           C
ATOM     44  CD1 PHE    20       4.033 -11.573 -20.422  1.00 33.33           C
ATOM     45  CE1 PHE    20       5.036 -12.540 -20.384  1.00 33.46           C
ATOM     46  CZ  PHE    20       4.721 -13.877 -20.608  1.00 33.34           C
ATOM     47  CE2 PHE    20       3.406 -14.243 -20.872  1.00 33.27           C
ATOM     48  CD2 PHE    20       2.410 -13.268 -20.910  1.00 33.40           C
ATOM     49  C   PHE    20       1.993 -10.864 -23.230  1.00 33.42           C
ATOM     50  O   PHE    20       3.088 -10.742 -23.778  1.00 33.51           O
ATOM     51  N   ALA    21       1.057 -11.718 -23.647  1.00 33.36           N
ATOM     52  CA  ALA    21       1.281 -12.658 -24.756  1.00 33.30           C
ATOM     53  CB  ALA    21       0.125 -13.646 -24.862  1.00 33.26           C
ATOM     54  C   ALA    21       1.532 -11.973 -26.104  1.00 33.23           C
ATOM     55  O   ALA    21       2.216 -12.526 -26.969  1.00 33.17           O
ATOM     56  N   GLU    22       0.977 -10.774 -26.270  1.00 33.16           N
ATOM     57  CA  GLU    22       1.190  -9.975 -27.475  1.00 33.18           C
ATOM     58  CB  GLU    22       0.113  -8.892 -27.604  1.00 33.18           C
ATOM     59  CG  GLU    22      -1.252  -9.411 -28.056  1.00 33.35           C
ATOM     60  CD  GLU    22      -2.260  -8.296 -28.306  1.00 33.36           C
ATOM     61  OE1 GLU    22      -2.712  -8.150 -29.463  1.00 33.59           O
ATOM     62  OE2 GLU    22      -2.598  -7.563 -27.351  1.00 33.58           O
ATOM     63  C   GLU    22       2.576  -9.335 -27.481  1.00 33.09           C
ATOM     64  O   GLU    22       3.156  -9.097 -28.542  1.00 33.03           O
ATOM     65  N   ARG    23       3.098  -9.067 -26.287  1.00 32.99           N
ATOM     66  CA  ARG    23       4.376  -8.383 -26.125  1.00 33.04           C
ATOM     67  CB  ARG    23       4.281  -7.387 -24.962  1.00 33.10           C
ATOM     68  CG  ARG    23       5.382  -6.336 -24.906  1.00 33.00           C
ATOM     69  CD  ARG    23       5.055  -5.270 -23.873  1.00 32.94           C
ATOM     70  NE  ARG    23       6.239  -4.523 -23.466  1.00 32.63           N
ATOM     74  C   ARG    23       5.541  -9.365 -25.920  1.00 33.08           C
ATOM     75  O   ARG    23       6.666  -9.098 -26.350  1.00 33.12           O
ATOM     76  N   TYR    24       5.257 -10.495 -25.271  1.00 33.02           N
ATOM     77  CA  TYR    24       6.263 -11.520 -24.976  1.00 32.96           C
ATOM     78  CB  TYR    24       6.617 -11.515 -23.484  1.00 33.02           C
ATOM     79  CG  TYR    24       7.131 -10.205 -22.920  1.00 33.19           C
ATOM     80  CD1 TYR    24       6.250  -9.210 -22.494  1.00 33.49           C
ATOM     81  CE1 TYR    24       6.720  -8.012 -21.962  1.00 33.55           C
ATOM     82  CZ  TYR    24       8.084  -7.806 -21.839  1.00 33.33           C
ATOM     83  OH  TYR    24       8.547  -6.623 -21.310  1.00 33.21           O
ATOM     84  CE2 TYR    24       8.979  -8.783 -22.242  1.00 33.01           C
ATOM     85  CD2 TYR    24       8.499  -9.977 -22.773  1.00 33.15           C
ATOM     86  C   TYR    24       5.787 -12.928 -25.347  1.00 32.89           C
ATOM     87  O   TYR    24       4.584 -13.191 -25.419  1.00 32.96           O
ATOM     88  N   ASN    25       6.740 -13.829 -25.584  1.00 32.74           N
ATOM     89  CA  ASN    25       6.457 -15.266 -25.640  1.00 32.60           C
ATOM     90  CB  ASN    25       6.155 -15.752 -27.072  1.00 32.60           C
ATOM     91  CG  ASN    25       7.328 -15.573 -28.032  1.00 32.53           C
ATOM     92  OD1 ASN    25       8.144 -14.663 -27.885  1.00 32.44           O
ATOM     93  ND2 ASN    25       7.401 -16.444 -29.034  1.00 32.19           N
ATOM     94  C   ASN    25       7.569 -16.074 -24.969  1.00 32.47           C
ATOM     95  O   ASN    25       8.747 -15.914 -25.294  1.00 32.51           O
ATOM     96  N   ILE    26       7.176 -16.924 -24.022  1.00 32.31           N
ATOM     97  CA  ILE    26       8.111 -17.635 -23.147  1.00 32.15           C
ATOM     98  CB  ILE    26       7.370 -18.566 -22.166  1.00 32.08           C
ATOM    102  C   ILE    26       9.152 -18.450 -23.907  1.00 32.12           C
ATOM    103  O   ILE    26       8.833 -19.129 -24.884  1.00 32.01           O
ATOM    104  N   VAL    27      10.399 -18.359 -23.453  1.00 32.10           N
ATOM    105  CA  VAL    27      11.493 -19.162 -23.999  1.00 32.06           C
ATOM    106  CB  VAL    27      12.862 -18.422 -23.910  1.00 32.04           C
ATOM    107  CG1 VAL    27      14.018 -19.348 -24.270  1.00 31.86           C
ATOM    108  CG2 VAL    27      12.872 -17.198 -24.815  1.00 32.06           C
ATOM    109  C   VAL    27      11.547 -20.508 -23.269  1.00 32.05           C
ATOM    110  O   VAL    27      11.557 -21.565 -23.905  1.00 32.08           O
ATOM    111  N   CYS    28      11.567 -20.453 -21.936  1.00 31.98           N
ATOM    112  CA  CYS    28      11.621 -21.647 -21.087  1.00 31.88           C
ATOM    113  CB  CYS    28      13.032 -22.249 -21.094  1.00 31.93           C
ATOM    114  SG  CYS    28      14.333 -21.125 -20.527  1.00 31.78           S
ATOM    115  C   CYS    28      11.196 -21.336 -19.652  1.00 31.81           C
ATOM    116  O   CYS    28      11.034 -20.171 -19.282  1.00 31.76           O
ATOM    117  N   MET    29      11.012 -22.386 -18.853  1.00 31.72           N
ATOM    118  CA  MET    29      10.733 -22.244 -17.428  1.00 31.66           C
ATOM    119  CB  MET    29       9.953 -23.458 -16.912  1.00 31.61           C
ATOM    120  CG  MET    29       9.391 -23.300 -15.505  1.00 31.65           C
ATOM    123  C   MET    29      12.046 -22.079 -16.662  1.00 31.66           C
ATOM    124  O   MET    29      12.990 -22.847 -16.862  1.00 31.68           O
ATOM    125  N   LEU    30      12.103 -21.070 -15.794  1.00 31.67           N
ATOM    126  CA  LEU    30      13.302 -20.794 -14.997  1.00 31.67           C
ATOM    127  CB  LEU    30      13.486 -19.287 -14.789  1.00 31.69           C
ATOM    128  CG  LEU    30      14.039 -18.481 -15.965  1.00 31.40           C
ATOM    131  C   LEU    30      13.293 -21.512 -13.647  1.00 31.68           C
ATOM    132  O   LEU    30      14.348 -21.751 -13.059  1.00 31.78           O
ATOM    133  N   GLY    31      12.101 -21.852 -13.165  1.00 31.65           N
ATOM    134  CA  GLY    31      11.951 -22.541 -11.888  1.00 31.62           C
ATOM    135  C   GLY    31      10.887 -21.908 -11.014  1.00 31.66           C
ATOM    136  O   GLY    31      10.558 -20.733 -11.177  1.00 31.56           O
ATOM    137  N   LYS    32      10.349 -22.697 -10.086  1.00 31.68           N
ATOM    138  CA  LYS    32       9.332 -22.227  -9.146  1.00 31.65           C
ATOM    139  CB  LYS    32       8.777 -23.386  -8.300  1.00 31.65           C
ATOM    140  CG  LYS    32       8.286 -24.609  -9.080  1.00 31.64           C
ATOM    141  CD  LYS    32       9.358 -25.699  -9.169  1.00 31.72           C
ATOM    144  C   LYS    32       9.911 -21.147  -8.230  1.00 31.63           C
ATOM    145  O   LYS    32      11.032 -21.280  -7.733  1.00 31.65           O
ATOM    146  N   GLY    33       9.148 -20.079  -8.021  1.00 31.58           N
ATOM    147  CA  GLY    33       9.558 -18.994  -7.133  1.00 31.56           C
ATOM    148  C   GLY    33       8.705 -18.914  -5.882  1.00 31.63           C
ATOM    149  O   GLY    33       7.869 -19.784  -5.625  1.00 31.46           O
ATOM    150  N   SER    34       8.919 -17.861  -5.102  1.00 31.85           N
ATOM    151  CA  SER    34       8.162 -17.645  -3.877  1.00 32.12           C
ATOM    152  CB  SER    34       8.864 -16.610  -2.994  1.00 31.98           C
ATOM    154  C   SER    34       6.716 -17.221  -4.159  1.00 32.48           C
ATOM    155  O   SER    34       5.845 -17.400  -3.307  1.00 32.29           O
ATOM    156  N   PHE    35       6.470 -16.679  -5.356  1.00 32.93           N
ATOM    157  CA  PHE    35       5.150 -16.139  -5.737  1.00 33.86           C
ATOM    158  CB  PHE    35       5.267 -14.687  -6.227  1.00 33.87           C
ATOM    159  CG  PHE    35       5.760 -13.721  -5.184  1.00 34.30           C
ATOM    160  CD1 PHE    35       7.121 -13.441  -5.065  1.00 34.45           C
ATOM    161  CE1 PHE    35       7.582 -12.540  -4.109  1.00 35.04           C
ATOM    162  CZ  PHE    35       6.675 -11.906  -3.260  1.00 34.57           C
ATOM    163  CE2 PHE    35       5.312 -12.180  -3.372  1.00 34.57           C
ATOM    164  CD2 PHE    35       4.864 -13.082  -4.331  1.00 34.24           C
ATOM    165  C   PHE    35       4.406 -16.948  -6.806  1.00 34.30           C
ATOM    166  O   PHE    35       3.219 -16.714  -7.050  1.00 34.50           O
ATOM    167  N   GLY    36       5.106 -17.884  -7.441  1.00 34.80           N
ATOM    168  CA  GLY    36       4.539 -18.685  -8.521  1.00 35.28           C
ATOM    169  C   GLY    36       5.635 -19.194  -9.432  1.00 35.72           C
ATOM    170  O   GLY    36       6.785 -19.330  -9.011  1.00 35.60           O
ATOM    171  N   GLU    37       5.282 -19.482 -10.682  1.00 36.11           N
ATOM    172  CA  GLU    37       6.266 -19.901 -11.677  1.00 36.52           C
ATOM    173  CB  GLU    37       5.578 -20.575 -12.868  1.00 36.44           C
ATOM    178  C   GLU    37       7.100 -18.703 -12.142  1.00 36.86           C
ATOM    179  O   GLU    37       6.586 -17.585 -12.256  1.00 36.96           O
ATOM    180  N   VAL    38       8.388 -18.940 -12.381  1.00 37.19           N
ATOM    181  CA  VAL    38       9.284 -17.924 -12.938  1.00 37.62           C
ATOM    182  CB  VAL    38      10.534 -17.684 -12.045  1.00 37.60           C
ATOM    183  CG1 VAL    38      11.388 -16.537 -12.588  1.00 37.37           C
ATOM    184  CG2 VAL    38      10.119 -17.400 -10.604  1.00 37.81           C
ATOM    185  C   VAL    38       9.699 -18.354 -14.348  1.00 37.88           C
ATOM    186  O   VAL    38      10.199 -19.465 -14.547  1.00 37.99           O
ATOM    187  N   LEU    39       9.475 -17.469 -15.317  1.00 38.09           N
ATOM    188  CA  LEU    39       9.718 -17.765 -16.727  1.00 38.31           C
ATOM    189  CB  LEU    39       8.418 -17.608 -17.529  1.00 38.29           C
ATOM    190  CG  LEU    39       7.505 -18.808 -17.816  1.00 38.75           C
ATOM    191  CD1 LEU    39       7.194 -19.645 -16.576  1.00 39.53           C
ATOM    192  CD2 LEU    39       6.214 -18.329 -18.465  1.00 38.53           C
ATOM    193  C   LEU    39      10.808 -16.885 -17.336  1.00 38.40           C
ATOM    194  O   LEU    39      11.014 -15.746 -16.913  1.00 38.27           O
ATOM    195  N   LYS    40      11.507 -17.436 -18.325  1.00 38.73           N
ATOM    196  CA  LYS    40      12.422 -16.665 -19.160  1.00 39.05           C
ATOM    197  CB  LYS    40      13.677 -17.481 -19.492  1.00 38.96           C
ATOM    198  CG  LYS    40      14.738 -16.746 -20.303  1.00 38.79           C
ATOM    199  CD  LYS    40      15.905 -17.672 -20.605  1.00 39.03           C
ATOM    200  CE  LYS    40      16.760 -17.156 -21.748  1.00 39.13           C
ATOM    201  NZ  LYS    40      17.728 -18.186 -22.230  1.00 38.99           N
ATOM    202  C   LYS    40      11.667 -16.283 -20.426  1.00 39.30           C
ATOM    203  O   LYS    40      11.205 -17.152 -21.173  1.00 39.31           O
ATOM    204  N   CYS    41      11.532 -14.979 -20.649  1.00 39.62           N
ATOM    205  CA  CYS    41      10.764 -14.465 -21.776  1.00 40.02           C
ATOM    206  CB  CYS    41       9.539 -13.712 -21.273  1.00 40.01           C
ATOM    207  SG  CYS    41       8.408 -14.756 -20.360  1.00 41.20           S
ATOM    208  C   CYS    41      11.581 -13.557 -22.675  1.00 40.08           C
ATOM    209  O   CYS    41      12.505 -12.883 -22.219  1.00 40.12           O
ATOM    210  N   LYS    42      11.228 -13.555 -23.958  1.00 40.18           N
ATOM    211  CA  LYS    42      11.782 -12.609 -24.916  1.00 40.28           C
ATOM    212  CB  LYS    42      12.303 -13.335 -26.160  1.00 40.21           C
ATOM    217  C   LYS    42      10.720 -11.586 -25.308  1.00 40.36           C
ATOM    218  O   LYS    42       9.545 -11.927 -25.476  1.00 40.30           O
ATOM    219  N   ASP    43      11.141 -10.330 -25.426  1.00 40.47           N
ATOM    220  CA  ASP    43      10.310  -9.275 -25.992  1.00 40.55           C
ATOM    221  CB  ASP    43      10.985  -7.915 -25.787  1.00 40.54           C
ATOM    222  CG  ASP    43      10.085  -6.744 -26.150  1.00 40.65           C
ATOM    223  OD1 ASP    43       9.804  -6.549 -27.351  1.00 40.58           O
ATOM    224  OD2 ASP    43       9.676  -6.002 -25.231  1.00 40.79           O
ATOM    225  C   ASP    43      10.136  -9.575 -27.478  1.00 40.62           C
ATOM    226  O   ASP    43      11.098  -9.931 -28.155  1.00 40.63           O
ATOM    227  N   ARG    44       8.908  -9.452 -27.975  1.00 40.78           N
ATOM    228  CA  ARG    44       8.609  -9.779 -29.375  1.00 40.93           C
ATOM    229  CB  ARG    44       7.104  -9.987 -29.586  1.00 41.02           C
ATOM    230  CG  ARG    44       6.580 -11.331 -29.090  1.00 41.16           C
ATOM    231  CD  ARG    44       5.168 -11.595 -29.591  1.00 41.15           C
ATOM    232  NE  ARG    44       4.695 -12.922 -29.210  1.00 41.27           N
ATOM    236  C   ARG    44       9.149  -8.743 -30.362  1.00 40.95           C
ATOM    237  O   ARG    44       9.359  -9.048 -31.537  1.00 40.92           O
ATOM    238  N   ILE    45       9.380  -7.525 -29.878  1.00 41.02           N
ATOM    239  CA  ILE    45       9.873  -6.437 -30.724  1.00 41.06           C
ATOM    240  CB  ILE    45       9.088  -5.115 -30.482  1.00 41.08           C
ATOM    241  CG1 ILE    45       7.579  -5.387 -30.424  1.00 41.08           C
ATOM    242  CD1 ILE    45       6.812  -4.480 -29.473  1.00 41.08           C
ATOM    243  CG2 ILE    45       9.405  -4.089 -31.570  1.00 40.95           C
ATOM    244  C   ILE    45      11.386  -6.233 -30.546  1.00 41.08           C
ATOM    245  O   ILE    45      12.148  -6.419 -31.498  1.00 41.08           O
ATOM    246  N   THR    46      11.814  -5.875 -29.333  1.00 41.06           N
ATOM    247  CA  THR    46      13.230  -5.573 -29.060  1.00 41.04           C
ATOM    248  CB  THR    46      13.423  -4.719 -27.773  1.00 41.02           C
ATOM    249  OG1 THR    46      13.138  -5.507 -26.611  1.00 41.15           O
ATOM    250  CG2 THR    46      12.524  -3.483 -27.787  1.00 41.03           C
ATOM    251  C   THR    46      14.120  -6.822 -28.990  1.00 41.04           C
ATOM    252  O   THR    46      15.328  -6.739 -29.231  1.00 40.98           O
ATOM    253  N   GLN    47      13.514  -7.963 -28.656  1.00 41.04           N
ATOM    254  CA  GLN    47      14.194  -9.276 -28.588  1.00 41.02           C
ATOM    255  CB  GLN    47      14.920  -9.618 -29.906  1.00 41.04           C
ATOM    256  CG  GLN    47      13.994  -9.871 -31.104  1.00 41.19           C
ATOM    257  CD  GLN    47      13.309 -11.239 -31.083  1.00 41.43           C
ATOM    258  OE1 GLN    47      13.259 -11.921 -30.056  1.00 41.69           O
ATOM    259  NE2 GLN    47      12.772 -11.638 -32.229  1.00 41.42           N
ATOM    260  C   GLN    47      15.119  -9.472 -27.377  1.00 40.96           C
ATOM    261  O   GLN    47      15.850 -10.465 -27.303  1.00 40.99           O
ATOM    262  N   GLN    48      15.073  -8.532 -26.434  1.00 40.81           N
ATOM    263  CA  GLN    48      15.812  -8.640 -25.178  1.00 40.76           C
ATOM    264  CB  GLN    48      15.884  -7.274 -24.494  1.00 40.79           C
ATOM    265  CG  GLN    48      16.842  -7.202 -23.310  1.00 41.21           C
ATOM    266  CD  GLN    48      16.893  -5.819 -22.683  1.00 41.33           C
ATOM    267  OE1 GLN    48      16.538  -5.638 -21.512  1.00 41.70           O
ATOM    268  NE2 GLN    48      17.331  -4.831 -23.462  1.00 41.78           N
ATOM    269  C   GLN    48      15.129  -9.658 -24.267  1.00 40.44           C
ATOM    270  O   GLN    48      13.915  -9.854 -24.352  1.00 40.41           O
ATOM    271  N   GLU    49      15.905 -10.299 -23.398  1.00 40.13           N
ATOM    272  CA  GLU    49      15.373 -11.351 -22.530  1.00 39.94           C
ATOM    273  CB  GLU    49      16.266 -12.593 -22.585  1.00 39.95           C
ATOM    274  CG  GLU    49      16.288 -13.260 -23.954  1.00 40.05           C
ATOM    275  CD  GLU    49      17.167 -14.493 -24.006  1.00 40.21           C
ATOM    276  OE1 GLU    49      18.249 -14.495 -23.375  1.00 40.42           O
ATOM    277  OE2 GLU    49      16.775 -15.464 -24.691  1.00 40.63           O
ATOM    278  C   GLU    49      15.154 -10.899 -21.086  1.00 39.66           C
ATOM    279  O   GLU    49      15.946 -10.133 -20.539  1.00 39.82           O
ATOM    280  N   TYR    50      14.068 -11.376 -20.480  1.00 39.28           N
ATOM    281  CA  TYR    50      13.676 -10.962 -19.134  1.00 38.91           C
ATOM    282  CB  TYR    50      12.545  -9.933 -19.198  1.00 38.78           C
ATOM    283  CG  TYR    50      12.919  -8.615 -19.836  1.00 38.67           C
ATOM    284  CD1 TYR    50      13.337  -7.536 -19.057  1.00 38.48           C
ATOM    285  CE1 TYR    50      13.676  -6.320 -19.639  1.00 38.27           C
ATOM    286  CZ  TYR    50      13.594  -6.176 -21.014  1.00 38.51           C
ATOM    287  OH  TYR    50      13.931  -4.976 -21.597  1.00 38.64           O
ATOM    288  CE2 TYR    50      13.182  -7.232 -21.810  1.00 38.43           C
ATOM    289  CD2 TYR    50      12.842  -8.440 -21.219  1.00 38.41           C
ATOM    290  C   TYR    50      13.212 -12.142 -18.294  1.00 38.79           C
ATOM    291  O   TYR    50      12.768 -13.161 -18.832  1.00 38.84           O
ATOM    292  N   ALA    51      13.308 -11.989 -16.973  1.00 38.50           N
ATOM    293  CA  ALA    51      12.797 -12.980 -16.030  1.00 38.21           C
ATOM    294  CB  ALA    51      13.767 -13.172 -14.870  1.00 38.24           C
ATOM    295  C   ALA    51      11.430 -12.536 -15.525  1.00 37.99           C
ATOM    296  O   ALA    51      11.321 -11.557 -14.780  1.00 37.84           O
ATOM    297  N   VAL    52      10.393 -13.265 -15.933  1.00 37.78           N
ATOM    298  CA  VAL    52       9.008 -12.878 -15.656  1.00 37.65           C
ATOM    299  CB  VAL    52       8.153 -12.837 -16.953  1.00 37.62           C
ATOM    300  CG1 VAL    52       6.704 -12.486 -16.643  1.00 37.42           C
ATOM    301  CG2 VAL    52       8.740 -11.840 -17.951  1.00 37.61           C
ATOM    302  C   VAL    52       8.345 -13.775 -14.610  1.00 37.66           C
ATOM    303  O   VAL    52       8.280 -14.997 -14.769  1.00 37.69           O
ATOM    304  N   LYS    53       7.850 -13.156 -13.544  1.00 37.57           N
ATOM    305  CA  LYS    53       7.143 -13.885 -12.497  1.00 37.65           C
ATOM    306  CB  LYS    53       7.471 -13.306 -11.114  1.00 37.58           C
ATOM    307  CG  LYS    53       8.936 -12.937 -10.964  1.00 38.35           C
ATOM    308  CD  LYS    53       9.522 -13.368  -9.627  1.00 39.55           C
ATOM    309  CE  LYS    53      11.055 -13.503  -9.698  1.00 39.64           C
ATOM    310  NZ  LYS    53      11.747 -12.210 -10.027  1.00 39.13           N
ATOM    311  C   LYS    53       5.635 -13.895 -12.765  1.00 37.50           C
ATOM    312  O   LYS    53       4.989 -12.843 -12.788  1.00 37.40           O
ATOM    313  N   VAL    54       5.097 -15.089 -13.000  1.00 37.37           N
ATOM    314  CA  VAL    54       3.662 -15.278 -13.190  1.00 37.46           C
ATOM    315  CB  VAL    54       3.340 -16.522 -14.063  1.00 37.46           C
ATOM    316  CG1 VAL    54       1.852 -16.582 -14.381  1.00 36.89           C
ATOM    317  CG2 VAL    54       4.167 -16.525 -15.349  1.00 37.23           C
ATOM    318  C   VAL    54       3.010 -15.434 -11.818  1.00 37.57           C
ATOM    319  O   VAL    54       3.315 -16.368 -11.079  1.00 37.64           O
ATOM    320  N   ILE    55       2.127 -14.502 -11.475  1.00 37.86           N
ATOM    321  CA  ILE    55       1.481 -14.511 -10.167  1.00 37.94           C
ATOM    322  CB  ILE    55       1.872 -13.277  -9.317  1.00 37.75           C
ATOM    323  CG1 ILE    55       3.395 -13.167  -9.206  1.00 37.62           C
ATOM    324  CD1 ILE    55       3.882 -11.925  -8.498  1.00 37.90           C
ATOM    325  CG2 ILE    55       1.243 -13.365  -7.925  1.00 37.98           C
ATOM    326  C   ILE    55      -0.030 -14.578 -10.324  1.00 38.02           C
ATOM    327  O   ILE    55      -0.636 -13.672 -10.893  1.00 38.10           O
ATOM    328  N   ASN    56      -0.629 -15.651  -9.817  1.00 38.25           N
ATOM    329  CA  ASN    56      -2.080 -15.818  -9.857  1.00 38.55           C
ATOM    330  CB  ASN    56      -2.486 -17.127  -9.176  1.00 38.64           C
ATOM    331  CG  ASN    56      -3.935 -17.500  -9.446  1.00 39.08           C
ATOM    332  OD1 ASN    56      -4.856 -16.754  -9.108  1.00 39.45           O
ATOM    333  ND2 ASN    56      -4.141 -18.662 -10.054  1.00 39.06           N
ATOM    334  C   ASN    56      -2.807 -14.635  -9.215  1.00 38.61           C
ATOM    335  O   ASN    56      -2.439 -14.191  -8.123  1.00 38.52           O
ATOM    336  N   LYS    57      -3.838 -14.132  -9.891  1.00 38.62           N
ATOM    337  CA  LYS    57      -4.561 -12.951  -9.412  1.00 38.82           C
ATOM    338  CB  LYS    57      -5.561 -12.448 -10.456  1.00 38.84           C
ATOM    339  CG  LYS    57      -4.889 -11.660 -11.555  1.00 39.27           C
ATOM    340  CD  LYS    57      -5.869 -10.963 -12.476  1.00 39.70           C
ATOM    341  CE  LYS    57      -5.113 -10.034 -13.418  1.00 39.31           C
ATOM    342  NZ  LYS    57      -5.991  -9.498 -14.478  1.00 39.20           N
ATOM    343  C   LYS    57      -5.229 -13.132  -8.047  1.00 38.81           C
ATOM    344  O   LYS    57      -5.472 -12.151  -7.342  1.00 39.09           O
ATOM    345  N   ALA    58      -5.504 -14.381  -7.676  1.00 38.64           N
ATOM    346  CA  ALA    58      -6.040 -14.707  -6.355  1.00 38.54           C
ATOM    347  CB  ALA    58      -6.532 -16.154  -6.317  1.00 38.51           C
ATOM    348  C   ALA    58      -5.019 -14.459  -5.241  1.00 38.43           C
ATOM    349  O   ALA    58      -5.386 -14.370  -4.069  1.00 38.56           O
ATOM    350  N   SER    59      -3.744 -14.352  -5.612  1.00 38.27           N
ATOM    351  CA  SER    59      -2.676 -14.076  -4.652  1.00 38.08           C
ATOM    352  CB  SER    59      -1.345 -14.668  -5.136  1.00 38.04           C
ATOM    354  C   SER    59      -2.534 -12.578  -4.340  1.00 37.98           C
ATOM    355  O   SER    59      -1.745 -12.191  -3.474  1.00 38.03           O
ATOM    356  N   ALA    60      -3.306 -11.746  -5.038  1.00 37.84           N
ATOM    357  CA  ALA    60      -3.345 -10.309  -4.775  1.00 37.84           C
ATOM    358  CB  ALA    60      -4.227  -9.600  -5.795  1.00 37.85           C
ATOM    359  C   ALA    60      -3.841 -10.034  -3.363  1.00 37.80           C
ATOM    360  O   ALA    60      -4.845 -10.606  -2.935  1.00 37.90           O
ATOM    361  N   LYS    61      -3.125  -9.168  -2.646  1.00 37.79           N
ATOM    362  CA  LYS    61      -3.439  -8.847  -1.249  1.00 37.72           C
ATOM    363  CB  LYS    61      -2.178  -8.421  -0.497  1.00 37.70           C
ATOM    364  CG  LYS    61      -1.275  -9.556  -0.058  1.00 37.20           C
ATOM    365  CD  LYS    61      -0.420  -9.092   1.100  1.00 36.43           C
ATOM    366  CE  LYS    61       0.442 -10.185   1.647  1.00 35.78           C
ATOM    367  NZ  LYS    61       1.341  -9.607   2.675  1.00 36.82           N
ATOM    368  C   LYS    61      -4.470  -7.733  -1.155  1.00 37.93           C
ATOM    369  O   LYS    61      -5.130  -7.561  -0.122  1.00 38.09           O
ATOM    370  N   ASN    62      -4.588  -6.969  -2.236  1.00 37.86           N
ATOM    371  CA  ASN    62      -5.523  -5.864  -2.307  1.00 37.94           C
ATOM    372  CB  ASN    62      -4.767  -4.546  -2.498  1.00 37.95           C
ATOM    373  CG  ASN    62      -5.626  -3.330  -2.197  1.00 37.82           C
ATOM    374  OD1 ASN    62      -6.673  -3.125  -2.809  1.00 36.82           O
ATOM    375  ND2 ASN    62      -5.181  -2.517  -1.248  1.00 37.70           N
ATOM    376  C   ASN    62      -6.540  -6.082  -3.426  1.00 38.02           C
ATOM    377  O   ASN    62      -6.171  -6.317  -4.577  1.00 37.99           O
ATOM    378  N   LYS    63      -7.820  -6.016  -3.070  1.00 38.23           N
ATOM    379  CA  LYS    63      -8.916  -6.233  -4.020  1.00 38.24           C
ATOM    380  CB  LYS    63     -10.257  -6.378  -3.283  1.00 38.57           C
ATOM    381  CG  LYS    63     -10.430  -5.483  -2.045  1.00 38.80           C
ATOM    382  CD  LYS    63     -11.611  -5.947  -1.184  1.00 38.51           C
ATOM    385  C   LYS    63      -8.981  -5.144  -5.094  1.00 37.93           C
ATOM    386  O   LYS    63      -9.442  -5.387  -6.210  1.00 37.85           O
ATOM    387  N   ASP    64      -8.498  -3.954  -4.743  1.00 37.52           N
ATOM    388  CA  ASP    64      -8.361  -2.841  -5.674  1.00 37.09           C
ATOM    389  CB  ASP    64      -8.380  -1.517  -4.901  1.00 37.06           C
ATOM    390  CG  ASP    64      -8.392  -0.297  -5.805  1.00 37.29           C
ATOM    391  OD1 ASP    64      -8.374   0.821  -5.251  1.00 36.69           O
ATOM    392  OD2 ASP    64      -8.430  -0.442  -7.051  1.00 37.41           O
ATOM    393  C   ASP    64      -7.051  -2.979  -6.441  1.00 36.70           C
ATOM    394  O   ASP    64      -5.991  -2.597  -5.947  1.00 36.76           O
ATOM    395  N   THR    65      -7.134  -3.527  -7.649  1.00 36.42           N
ATOM    396  CA  THR    65      -5.967  -3.731  -8.505  1.00 36.06           C
ATOM    397  CB  THR    65      -6.367  -4.398  -9.847  1.00 35.97           C
ATOM    398  OG1 THR    65      -6.942  -5.686  -9.583  1.00 35.57           O
ATOM    399  CG2 THR    65      -5.163  -4.580 -10.766  1.00 35.27           C
ATOM    400  C   THR    65      -5.166  -2.443  -8.745  1.00 36.34           C
ATOM    401  O   THR    65      -3.932  -2.484  -8.795  1.00 36.51           O
ATOM    402  N   SER    66      -5.856  -1.308  -8.872  1.00 36.27           N
ATOM    403  CA  SER    66      -5.191  -0.046  -9.211  1.00 36.36           C
ATOM    404  CB  SER    66      -6.206   1.080  -9.445  1.00 36.32           C
ATOM    405  OG  SER    66      -6.913   1.399  -8.261  1.00 36.54           O
ATOM    406  C   SER    66      -4.173   0.350  -8.149  1.00 36.54           C
ATOM    407  O   SER    66      -3.121   0.919  -8.466  1.00 36.62           O
ATOM    408  N   THR    67      -4.490   0.037  -6.895  1.00 36.48           N
ATOM    409  CA  THR    67      -3.576   0.268  -5.781  1.00 36.72           C
ATOM    410  CB  THR    67      -4.248  -0.060  -4.421  1.00 36.71           C
ATOM    411  OG1 THR    67      -5.224   0.952  -4.122  1.00 36.83           O
ATOM    412  CG2 THR    67      -3.231  -0.098  -3.306  1.00 36.48           C
ATOM    413  C   THR    67      -2.270  -0.507  -5.969  1.00 36.82           C
ATOM    414  O   THR    67      -1.187   0.044  -5.778  1.00 37.27           O
ATOM    415  N   ILE    68      -2.383  -1.774  -6.360  1.00 36.97           N
ATOM    416  CA  ILE    68      -1.229  -2.616  -6.676  1.00 36.85           C
ATOM    417  CB  ILE    68      -1.653  -4.095  -6.895  1.00 36.92           C
ATOM    418  CG1 ILE    68      -1.912  -4.776  -5.538  1.00 36.87           C
ATOM    419  CD1 ILE    68      -2.726  -6.053  -5.614  1.00 35.79           C
ATOM    420  CG2 ILE    68      -0.590  -4.862  -7.689  1.00 37.05           C
ATOM    421  C   ILE    68      -0.428  -2.082  -7.874  1.00 37.11           C
ATOM    422  O   ILE    68       0.805  -2.042  -7.826  1.00 37.30           O
ATOM    423  N   LEU    69      -1.118  -1.662  -8.934  1.00 36.90           N
ATOM    424  CA  LEU    69      -0.435  -1.119 -10.109  1.00 37.22           C
ATOM    425  CB  LEU    69      -1.420  -0.869 -11.261  1.00 37.15           C
ATOM    426  CG  LEU    69      -2.185  -2.098 -11.784  1.00 37.19           C
ATOM    427  CD1 LEU    69      -3.063  -1.726 -12.969  1.00 37.38           C
ATOM    428  CD2 LEU    69      -1.245  -3.258 -12.152  1.00 35.51           C
ATOM    429  C   LEU    69       0.357   0.149  -9.777  1.00 37.56           C
ATOM    430  O   LEU    69       1.370   0.447 -10.421  1.00 37.40           O
ATOM    431  N   ARG    70      -0.113   0.872  -8.757  1.00 37.85           N
ATOM    432  CA  ARG    70       0.520   2.089  -8.263  1.00 37.92           C
ATOM    433  CB  ARG    70      -0.488   2.913  -7.452  1.00 37.89           C
ATOM    434  CG  ARG    70       0.106   3.921  -6.466  1.00 36.81           C
ATOM    435  CD  ARG    70       0.614   5.170  -7.156  1.00 35.82           C
ATOM    436  NE  ARG    70       1.164   6.123  -6.199  1.00 34.69           N
ATOM    437  CZ  ARG    70       1.794   7.248  -6.525  1.00 35.53           C
ATOM    438  NH1 ARG    70       1.962   7.582  -7.802  1.00 35.22           N
ATOM    439  NH2 ARG    70       2.253   8.048  -5.567  1.00 35.81           N
ATOM    440  C   ARG    70       1.777   1.796  -7.439  1.00 38.65           C
ATOM    441  O   ARG    70       2.796   2.481  -7.609  1.00 38.94           O
ATOM    442  N   GLU    71       1.703   0.806  -6.540  1.00 38.76           N
ATOM    443  CA  GLU    71       2.885   0.351  -5.803  1.00 39.10           C
ATOM    444  CB  GLU    71       2.573  -0.852  -4.902  1.00 39.27           C
ATOM    445  CG  GLU    71       2.316  -0.544  -3.428  1.00 40.39           C
ATOM    446  CD  GLU    71       3.468   0.174  -2.736  1.00 40.72           C
ATOM    447  OE1 GLU    71       3.471   1.423  -2.747  1.00 41.51           O
ATOM    448  OE2 GLU    71       4.343  -0.499  -2.148  1.00 40.19           O
ATOM    449  C   GLU    71       3.988  -0.047  -6.773  1.00 39.04           C
ATOM    450  O   GLU    71       5.130   0.410  -6.644  1.00 39.31           O
ATOM    451  N   VAL    72       3.639  -0.904  -7.737  1.00 38.61           N
ATOM    452  CA  VAL    72       4.598  -1.405  -8.720  1.00 38.10           C
ATOM    453  CB  VAL    72       3.986  -2.482  -9.654  1.00 37.97           C
ATOM    454  CG1 VAL    72       4.999  -2.931 -10.691  1.00 37.90           C
ATOM    455  CG2 VAL    72       3.500  -3.679  -8.854  1.00 37.92           C
ATOM    456  C   VAL    72       5.170  -0.239  -9.526  1.00 37.83           C
ATOM    457  O   VAL    72       6.377  -0.172  -9.751  1.00 37.66           O
ATOM    458  N   GLU    73       4.306   0.688  -9.932  1.00 37.66           N
ATOM    459  CA  GLU    73       4.748   1.869 -10.679  1.00 37.61           C
ATOM    460  CB  GLU    73       3.568   2.790 -10.999  1.00 37.43           C
ATOM    461  CG  GLU    73       3.848   3.817 -12.103  1.00 38.45           C
ATOM    462  CD  GLU    73       4.145   3.189 -13.465  1.00 38.72           C
ATOM    463  OE1 GLU    73       3.715   2.039 -13.714  1.00 38.11           O
ATOM    464  OE2 GLU    73       4.802   3.859 -14.293  1.00 39.33           O
ATOM    465  C   GLU    73       5.851   2.623  -9.929  1.00 37.42           C
ATOM    466  O   GLU    73       6.877   2.966 -10.514  1.00 37.30           O
ATOM    467  N   LEU    74       5.642   2.849  -8.632  1.00 37.37           N
ATOM    468  CA  LEU    74       6.653   3.455  -7.769  1.00 37.33           C
ATOM    469  CB  LEU    74       6.117   3.628  -6.343  1.00 37.39           C
ATOM    470  CG  LEU    74       5.054   4.694  -6.047  1.00 37.62           C
ATOM    471  CD1 LEU    74       4.347   4.392  -4.722  1.00 37.71           C
ATOM    472  CD2 LEU    74       5.658   6.100  -6.024  1.00 37.43           C
ATOM    473  C   LEU    74       7.962   2.649  -7.753  1.00 37.23           C
ATOM    474  O   LEU    74       9.045   3.229  -7.769  1.00 37.03           O
ATOM    475  N   LEU    75       7.849   1.321  -7.735  1.00 37.11           N
ATOM    476  CA  LEU    75       9.016   0.426  -7.776  1.00 37.23           C
ATOM    477  CB  LEU    75       8.610  -1.017  -7.452  1.00 37.16           C
ATOM    478  CG  LEU    75       8.007  -1.295  -6.070  1.00 36.80           C
ATOM    479  CD1 LEU    75       7.466  -2.716  -5.993  1.00 36.87           C
ATOM    480  CD2 LEU    75       9.011  -1.031  -4.947  1.00 35.24           C
ATOM    481  C   LEU    75       9.752   0.466  -9.117  1.00 37.44           C
ATOM    482  O   LEU    75      10.974   0.306  -9.163  1.00 37.61           O
ATOM    483  N   LYS    76       9.011   0.690 -10.201  1.00 37.58           N
ATOM    484  CA  LYS    76       9.607   0.771 -11.535  1.00 37.67           C
ATOM    485  CB  LYS    76       8.533   0.776 -12.625  1.00 37.54           C
ATOM    486  CG  LYS    76       7.541  -0.392 -12.549  1.00 37.63           C
ATOM    487  CD  LYS    76       6.830  -0.665 -13.870  1.00 37.67           C
ATOM    488  CE  LYS    76       6.530   0.608 -14.644  1.00 38.19           C
ATOM    489  NZ  LYS    76       5.612   0.367 -15.791  1.00 39.15           N
ATOM    490  C   LYS    76      10.503   1.998 -11.672  1.00 37.79           C
ATOM    491  O   LYS    76      11.485   1.974 -12.411  1.00 37.92           O
ATOM    492  N   LYS    77      10.163   3.058 -10.945  1.00 37.88           N
ATOM    493  CA  LYS    77      10.892   4.318 -11.004  1.00 38.08           C
ATOM    494  CB  LYS    77      10.006   5.466 -10.499  1.00 38.19           C
ATOM    495  CG  LYS    77       9.133   6.128 -11.578  1.00 38.52           C
ATOM    496  CD  LYS    77       7.987   5.231 -12.044  1.00 39.40           C
ATOM    497  CE  LYS    77       7.449   5.636 -13.411  1.00 40.16           C
ATOM    498  NZ  LYS    77       6.783   6.975 -13.411  1.00 39.99           N
ATOM    499  C   LYS    77      12.208   4.256 -10.227  1.00 38.20           C
ATOM    500  O   LYS    77      13.122   5.032 -10.484  1.00 38.22           O
ATOM    501  N   LEU    78      12.298   3.315  -9.292  1.00 38.52           N
ATOM    502  CA  LEU    78      13.487   3.134  -8.455  1.00 38.59           C
ATOM    503  CB  LEU    78      13.139   2.348  -7.185  1.00 38.40           C
ATOM    504  CG  LEU    78      12.214   3.078  -6.209  1.00 38.35           C
ATOM    505  CD1 LEU    78      11.886   2.208  -5.017  1.00 38.70           C
ATOM    506  CD2 LEU    78      12.820   4.401  -5.760  1.00 38.40           C
ATOM    507  C   LEU    78      14.642   2.461  -9.185  1.00 38.70           C
ATOM    508  O   LEU    78      14.434   1.684 -10.123  1.00 38.81           O
ATOM    509  N   ASP    79      15.858   2.758  -8.732  1.00 38.79           N
ATOM    510  CA  ASP    79      17.066   2.291  -9.396  1.00 39.09           C
ATOM    511  CB  ASP    79      17.365   3.174 -10.616  1.00 39.43           C
ATOM    512  CG  ASP    79      17.778   2.366 -11.830  1.00 40.90           C
ATOM    513  OD1 ASP    79      18.091   1.163 -11.675  1.00 42.91           O
ATOM    514  OD2 ASP    79      17.784   2.933 -12.945  1.00 42.47           O
ATOM    515  C   ASP    79      18.270   2.275  -8.451  1.00 38.81           C
ATOM    516  O   ASP    79      18.722   3.326  -7.980  1.00 38.89           O
ATOM    517  N   HIS    80      18.785   1.077  -8.180  1.00 38.36           N
ATOM    518  CA  HIS    80      19.958   0.914  -7.321  1.00 37.81           C
ATOM    519  CB  HIS    80      19.540   0.849  -5.853  1.00 37.64           C
ATOM    520  CG  HIS    80      20.692   0.837  -4.904  1.00 37.22           C
ATOM    521  ND1 HIS    80      21.260  -0.330  -4.439  1.00 36.55           N
ATOM    522  CE1 HIS    80      22.262  -0.035  -3.629  1.00 36.58           C
ATOM    523  NE2 HIS    80      22.364   1.279  -3.553  1.00 36.64           N
ATOM    524  CD2 HIS    80      21.399   1.849  -4.348  1.00 36.63           C
ATOM    525  C   HIS    80      20.749  -0.339  -7.698  1.00 37.62           C
ATOM    526  O   HIS    80      20.160  -1.408  -7.855  1.00 37.72           O
ATOM    527  N   PRO    81      22.088  -0.213  -7.833  1.00 37.35           N
ATOM    528  CA  PRO    81      22.955  -1.324  -8.257  1.00 37.10           C
ATOM    529  CB  PRO    81      24.361  -0.823  -7.903  1.00 37.12           C
ATOM    530  CG  PRO    81      24.267   0.650  -7.992  1.00 37.10           C
ATOM    531  CD  PRO    81      22.863   1.021  -7.590  1.00 37.36           C
ATOM    532  C   PRO    81      22.681  -2.671  -7.565  1.00 36.87           C
ATOM    533  O   PRO    81      22.861  -3.722  -8.182  1.00 36.75           O
ATOM    534  N   ASN    82      22.244  -2.628  -6.306  1.00 36.60           N
ATOM    535  CA  ASN    82      22.006  -3.832  -5.506  1.00 36.39           C
ATOM    536  CB  ASN    82      22.615  -3.667  -4.108  1.00 36.25           C
ATOM    537  CG  ASN    82      24.104  -3.365  -4.143  1.00 36.00           C
ATOM    538  OD1 ASN    82      24.559  -2.388  -3.550  1.00 35.86           O
ATOM    539  ND2 ASN    82      24.869  -4.204  -4.834  1.00 35.32           N
ATOM    540  C   ASN    82      20.521  -4.221  -5.394  1.00 36.48           C
ATOM    541  O   ASN    82      20.139  -5.042  -4.552  1.00 36.11           O
ATOM    542  N   ILE    83      19.694  -3.626  -6.248  1.00 36.60           N
ATOM    543  CA  ILE    83      18.269  -3.924  -6.278  1.00 36.73           C
ATOM    544  CB  ILE    83      17.409  -2.698  -5.852  1.00 36.61           C
ATOM    545  CG1 ILE    83      17.736  -2.262  -4.413  1.00 36.44           C
ATOM    546  CD1 ILE    83      17.455  -3.312  -3.334  1.00 36.21           C
ATOM    547  CG2 ILE    83      15.902  -2.992  -6.021  1.00 36.54           C
ATOM    548  C   ILE    83      17.854  -4.405  -7.665  1.00 36.96           C
ATOM    549  O   ILE    83      18.030  -3.693  -8.659  1.00 36.76           O
ATOM    550  N   MET    84      17.303  -5.618  -7.719  1.00 37.34           N
ATOM    551  CA  MET    84      16.803  -6.182  -8.968  1.00 37.66           C
ATOM    552  CB  MET    84      16.173  -7.553  -8.732  1.00 37.89           C
ATOM    553  CG  MET    84      16.402  -8.549  -9.868  1.00 38.38           C
ATOM    554  SD  MET    84      18.149  -8.954 -10.150  1.00 39.13           S
ATOM    555  CE  MET    84      17.998 -10.661 -10.650  1.00 38.84           C
ATOM    556  C   MET    84      15.787  -5.232  -9.581  1.00 37.67           C
ATOM    557  O   MET    84      14.897  -4.727  -8.891  1.00 37.66           O
ATOM    558  N   LYS    85      15.950  -4.967 -10.872  1.00 37.62           N
ATOM    559  CA  LYS    85      15.128  -3.993 -11.570  1.00 37.56           C
ATOM    560  CB  LYS    85      15.851  -3.489 -12.823  1.00 37.73           C
ATOM    561  CG  LYS    85      15.208  -2.290 -13.498  1.00 38.32           C
ATOM    562  CD  LYS    85      15.765  -0.977 -12.967  1.00 39.30           C
ATOM    563  CE  LYS    85      15.280   0.200 -13.809  1.00 38.77           C
ATOM    564  NZ  LYS    85      13.821   0.438 -13.621  1.00 38.51           N
ATOM    565  C   LYS    85      13.792  -4.606 -11.943  1.00 37.35           C
ATOM    566  O   LYS    85      13.729  -5.711 -12.475  1.00 37.17           O
ATOM    567  N   LEU    86      12.725  -3.880 -11.637  1.00 37.39           N
ATOM    568  CA  LEU    86      11.387  -4.271 -12.032  1.00 37.27           C
ATOM    569  CB  LEU    86      10.442  -4.181 -10.824  1.00 37.26           C
ATOM    570  CG  LEU    86       8.902  -4.240 -10.821  1.00 37.70           C
ATOM    571  CD1 LEU    86       8.230  -4.646 -12.140  1.00 37.81           C
ATOM    572  CD2 LEU    86       8.456  -5.145  -9.681  1.00 38.16           C
ATOM    573  C   LEU    86      10.984  -3.375 -13.202  1.00 37.06           C
ATOM    574  O   LEU    86      10.870  -2.159 -13.057  1.00 36.96           O
ATOM    575  N   PHE    87      10.802  -3.992 -14.369  1.00 37.03           N
ATOM    576  CA  PHE    87      10.583  -3.257 -15.619  1.00 37.03           C
ATOM    577  CB  PHE    87      11.182  -4.008 -16.816  1.00 36.86           C
ATOM    578  CG  PHE    87      12.684  -4.027 -16.829  1.00 36.68           C
ATOM    579  CD1 PHE    87      13.382  -5.139 -16.369  1.00 36.65           C
ATOM    580  CE1 PHE    87      14.776  -5.164 -16.378  1.00 36.33           C
ATOM    581  CZ  PHE    87      15.485  -4.065 -16.842  1.00 36.49           C
ATOM    582  CE2 PHE    87      14.798  -2.944 -17.299  1.00 36.73           C
ATOM    583  CD2 PHE    87      13.403  -2.931 -17.291  1.00 36.52           C
ATOM    584  C   PHE    87       9.120  -2.901 -15.874  1.00 37.09           C
ATOM    585  O   PHE    87       8.805  -1.739 -16.126  1.00 37.14           O
ATOM    586  N   GLU    88       8.237  -3.898 -15.823  1.00 37.20           N
ATOM    587  CA  GLU    88       6.796  -3.654 -15.935  1.00 37.37           C
ATOM    588  CB  GLU    88       6.383  -3.342 -17.387  1.00 37.52           C
ATOM    589  CG  GLU    88       6.623  -4.448 -18.404  1.00 37.49           C
ATOM    590  CD  GLU    88       6.315  -4.002 -19.827  1.00 37.94           C
ATOM    591  OE1 GLU    88       6.461  -2.794 -20.131  1.00 38.37           O
ATOM    592  OE2 GLU    88       5.927  -4.861 -20.648  1.00 39.16           O
ATOM    593  C   GLU    88       5.922  -4.753 -15.333  1.00 37.15           C
ATOM    594  O   GLU    88       6.412  -5.824 -14.965  1.00 37.10           O
ATOM    595  N   ILE    89       4.630  -4.452 -15.218  1.00 37.16           N
ATOM    596  CA  ILE    89       3.621  -5.389 -14.721  1.00 37.09           C
ATOM    597  CB  ILE    89       3.060  -4.970 -13.311  1.00 37.12           C
ATOM    598  CG1 ILE    89       2.010  -5.964 -12.799  1.00 36.67           C
ATOM    600  CG2 ILE    89       2.492  -3.542 -13.319  1.00 37.01           C
ATOM    601  C   ILE    89       2.512  -5.512 -15.762  1.00 37.14           C
ATOM    602  O   ILE    89       1.964  -4.505 -16.214  1.00 37.09           O
ATOM    603  N   LEU    90       2.206  -6.744 -16.162  1.00 37.27           N
ATOM    604  CA  LEU    90       1.164  -6.991 -17.165  1.00 37.31           C
ATOM    605  CB  LEU    90       1.778  -7.474 -18.488  1.00 37.16           C
ATOM    606  CG  LEU    90       2.685  -6.482 -19.233  1.00 36.68           C
ATOM    607  CD1 LEU    90       3.563  -7.191 -20.238  1.00 36.06           C
ATOM    608  CD2 LEU    90       1.890  -5.370 -19.913  1.00 36.77           C
ATOM    609  C   LEU    90       0.113  -7.967 -16.640  1.00 37.53           C
ATOM    610  O   LEU    90       0.325  -8.612 -15.613  1.00 37.64           O
ATOM    611  N   GLU    91      -1.017  -8.065 -17.339  1.00 37.79           N
ATOM    612  CA  GLU    91      -2.171  -8.819 -16.847  1.00 38.13           C
ATOM    613  CB  GLU    91      -3.290  -7.871 -16.399  1.00 38.09           C
ATOM    614  CG  GLU    91      -2.996  -7.103 -15.113  1.00 38.39           C
ATOM    615  CD  GLU    91      -4.174  -6.264 -14.638  1.00 38.34           C
ATOM    616  OE1 GLU    91      -3.963  -5.067 -14.346  1.00 38.50           O
ATOM    617  OE2 GLU    91      -5.305  -6.798 -14.556  1.00 37.70           O
ATOM    618  C   GLU    91      -2.752  -9.813 -17.845  1.00 38.42           C
ATOM    619  O   GLU    91      -2.810  -9.551 -19.052  1.00 38.58           O
ATOM    620  N   ASP    92      -3.172 -10.957 -17.307  1.00 38.43           N
ATOM    621  CA  ASP    92      -4.020 -11.916 -17.996  1.00 38.26           C
ATOM    622  CB  ASP    92      -3.524 -13.336 -17.720  1.00 38.52           C
ATOM    623  CG  ASP    92      -2.786 -13.944 -18.892  1.00 39.09           C
ATOM    624  OD1 ASP    92      -2.831 -13.385 -20.011  1.00 40.80           O
ATOM    625  OD2 ASP    92      -2.165 -15.003 -18.689  1.00 39.16           O
ATOM    626  C   ASP    92      -5.424 -11.790 -17.434  1.00 38.06           C
ATOM    627  O   ASP    92      -5.708 -10.887 -16.650  1.00 37.96           O
ATOM    628  N   SER    93      -6.303 -12.702 -17.834  1.00 37.92           N
ATOM    629  CA  SER    93      -7.557 -12.904 -17.127  1.00 37.81           C
ATOM    630  CB  SER    93      -8.508 -13.771 -17.959  1.00 37.80           C
ATOM    631  OG  SER    93      -9.232 -12.996 -18.900  1.00 37.71           O
ATOM    632  C   SER    93      -7.276 -13.568 -15.772  1.00 37.69           C
ATOM    633  O   SER    93      -7.967 -13.306 -14.782  1.00 37.53           O
ATOM    634  N   SER    94      -6.238 -14.402 -15.736  1.00 37.51           N
ATOM    635  CA  SER    94      -5.946 -15.234 -14.573  1.00 37.51           C
ATOM    636  CB  SER    94      -5.663 -16.672 -15.018  1.00 37.61           C
ATOM    637  OG  SER    94      -6.738 -17.201 -15.790  1.00 38.14           O
ATOM    638  C   SER    94      -4.801 -14.732 -13.683  1.00 37.50           C
ATOM    639  O   SER    94      -4.810 -14.970 -12.474  1.00 37.51           O
ATOM    640  N   SER    95      -3.822 -14.039 -14.267  1.00 37.26           N
ATOM    641  CA  SER    95      -2.585 -13.749 -13.538  1.00 37.08           C
ATOM    642  CB  SER    95      -1.591 -14.923 -13.660  1.00 37.18           C
ATOM    643  OG  SER    95      -1.698 -15.598 -14.903  1.00 37.35           O
ATOM    644  C   SER    95      -1.892 -12.429 -13.863  1.00 36.91           C
ATOM    645  O   SER    95      -2.181 -11.785 -14.873  1.00 36.94           O
ATOM    646  N   PHE    96      -0.996 -12.028 -12.963  1.00 36.65           N
ATOM    647  CA  PHE    96      -0.093 -10.898 -13.177  1.00 36.39           C
ATOM    648  CB  PHE    96       0.133 -10.122 -11.878  1.00 36.25           C
ATOM    649  CG  PHE    96      -1.059  -9.328 -11.421  1.00 35.96           C
ATOM    650  CD1 PHE    96      -1.338  -8.083 -11.976  1.00 35.75           C
ATOM    651  CE1 PHE    96      -2.443  -7.339 -11.551  1.00 35.77           C
ATOM    652  CZ  PHE    96      -3.270  -7.840 -10.553  1.00 35.92           C
ATOM    653  CE2 PHE    96      -2.993  -9.081  -9.984  1.00 36.03           C
ATOM    654  CD2 PHE    96      -1.894  -9.818 -10.423  1.00 35.66           C
ATOM    655  C   PHE    96       1.250 -11.392 -13.694  1.00 36.33           C
ATOM    656  O   PHE    96       1.651 -12.531 -13.434  1.00 36.25           O
ATOM    657  N   TYR    97       1.943 -10.524 -14.420  1.00 36.35           N
ATOM    658  CA  TYR    97       3.258 -10.833 -14.952  1.00 36.30           C
ATOM    659  CB  TYR    97       3.192 -10.992 -16.469  1.00 36.50           C
ATOM    660  CG  TYR    97       2.346 -12.151 -16.912  1.00 36.66           C
ATOM    661  CD1 TYR    97       0.996 -11.980 -17.208  1.00 36.85           C
ATOM    662  CE1 TYR    97       0.209 -13.051 -17.609  1.00 37.00           C
ATOM    663  CZ  TYR    97       0.774 -14.311 -17.720  1.00 36.93           C
ATOM    664  OH  TYR    97       0.008 -15.381 -18.122  1.00 36.89           O
ATOM    665  CE2 TYR    97       2.112 -14.505 -17.431  1.00 37.02           C
ATOM    666  CD2 TYR    97       2.890 -13.427 -17.028  1.00 37.08           C
ATOM    667  C   TYR    97       4.235  -9.735 -14.578  1.00 36.23           C
ATOM    668  O   TYR    97       4.147  -8.612 -15.088  1.00 36.22           O
ATOM    669  N   ILE    98       5.153 -10.065 -13.674  1.00 36.23           N
ATOM    670  CA  ILE    98       6.181  -9.127 -13.229  1.00 36.16           C
ATOM    671  CB  ILE    98       6.538  -9.319 -11.732  1.00 36.20           C
ATOM    672  CG1 ILE    98       5.282  -9.276 -10.844  1.00 36.21           C
ATOM    673  CD1 ILE    98       4.464  -7.983 -10.914  1.00 36.31           C
ATOM    674  CG2 ILE    98       7.600  -8.308 -11.291  1.00 36.10           C
ATOM    675  C   ILE    98       7.427  -9.300 -14.087  1.00 36.14           C
ATOM    676  O   ILE    98       8.144 -10.293 -13.965  1.00 36.14           O
ATOM    677  N   VAL    99       7.667  -8.334 -14.964  1.00 36.22           N
ATOM    678  CA  VAL    99       8.810  -8.382 -15.861  1.00 36.31           C
ATOM    679  CB  VAL    99       8.511  -7.673 -17.201  1.00 36.28           C
ATOM    680  CG1 VAL    99       9.641  -7.898 -18.191  1.00 36.08           C
ATOM    681  CG2 VAL    99       7.197  -8.175 -17.785  1.00 36.36           C
ATOM    682  C   VAL    99      10.016  -7.752 -15.169  1.00 36.46           C
ATOM    683  O   VAL    99      10.031  -6.547 -14.900  1.00 36.48           O
ATOM    684  N   GLY   100      11.016  -8.580 -14.873  1.00 36.62           N
ATOM    685  CA  GLY   100      12.243  -8.114 -14.232  1.00 36.87           C
ATOM    686  C   GLY   100      13.536  -8.547 -14.904  1.00 37.09           C
ATOM    687  O   GLY   100      13.525  -9.162 -15.975  1.00 36.96           O
ATOM    688  N   GLU   101      14.650  -8.212 -14.251  1.00 37.49           N
ATOM    689  CA  GLU   101      16.002  -8.568 -14.691  1.00 37.86           C
ATOM    690  CB  GLU   101      17.035  -7.968 -13.737  1.00 37.93           C
ATOM    691  CG  GLU   101      17.468  -6.553 -14.046  1.00 38.36           C
ATOM    692  CD  GLU   101      18.699  -6.152 -13.253  1.00 38.60           C
ATOM    693  OE1 GLU   101      19.813  -6.599 -13.607  1.00 38.92           O
ATOM    694  OE2 GLU   101      18.553  -5.391 -12.274  1.00 38.75           O
ATOM    695  C   GLU   101      16.250 -10.071 -14.744  1.00 38.02           C
ATOM    696  O   GLU   101      15.879 -10.806 -13.824  1.00 38.21           O
ATOM    697  N   LEU   102      16.895 -10.512 -15.818  1.00 38.12           N
ATOM    698  CA  LEU   102      17.386 -11.876 -15.922  1.00 38.32           C
ATOM    699  CB  LEU   102      17.420 -12.300 -17.394  1.00 38.26           C
ATOM    700  CG  LEU   102      17.501 -13.778 -17.781  1.00 38.19           C
ATOM    701  CD1 LEU   102      16.282 -14.555 -17.308  1.00 38.27           C
ATOM    702  CD2 LEU   102      17.654 -13.909 -19.286  1.00 38.27           C
ATOM    703  C   LEU   102      18.785 -11.906 -15.308  1.00 38.61           C
ATOM    704  O   LEU   102      19.610 -11.039 -15.609  1.00 38.57           O
ATOM    705  N   TYR   103      19.049 -12.882 -14.438  1.00 38.99           N
ATOM    706  CA  TYR   103      20.336 -12.954 -13.727  1.00 39.46           C
ATOM    707  CB  TYR   103      20.271 -12.132 -12.430  1.00 39.67           C
ATOM    708  CG  TYR   103      21.609 -11.628 -11.910  1.00 40.14           C
ATOM    709  CD1 TYR   103      22.018 -10.312 -12.136  1.00 40.32           C
ATOM    710  CE1 TYR   103      23.248  -9.847 -11.658  1.00 40.34           C
ATOM    711  CZ  TYR   103      24.074 -10.702 -10.942  1.00 40.18           C
ATOM    712  OH  TYR   103      25.281 -10.254 -10.464  1.00 40.20           O
ATOM    713  CE2 TYR   103      23.691 -12.008 -10.702  1.00 40.40           C
ATOM    714  CD2 TYR   103      22.462 -12.464 -11.180  1.00 40.73           C
ATOM    715  C   TYR   103      20.779 -14.389 -13.415  1.00 39.53           C
ATOM    716  O   TYR   103      19.951 -15.251 -13.116  1.00 39.69           O
ATOM    717  N   THR   104      22.089 -14.628 -13.486  1.00 39.57           N
ATOM    718  CA  THR   104      22.690 -15.913 -13.109  1.00 39.61           C
ATOM    719  CB  THR   104      23.042 -16.782 -14.339  1.00 39.67           C
ATOM    720  OG1 THR   104      23.551 -15.951 -15.392  1.00 39.48           O
ATOM    721  CG2 THR   104      21.816 -17.540 -14.842  1.00 39.86           C
ATOM    722  C   THR   104      23.953 -15.703 -12.281  1.00 39.65           C
ATOM    723  O   THR   104      23.885 -15.438 -11.079  1.00 39.64           O
ATOM    724  N   GLY   106      23.261 -17.538  -9.332  1.00 33.49           N
ATOM    725  CA  GLY   106      22.701 -18.357  -8.257  1.00 33.63           C
ATOM    726  C   GLY   106      22.431 -17.577  -6.980  1.00 33.48           C
ATOM    727  O   GLY   106      22.877 -16.443  -6.833  1.00 33.62           O
ATOM    728  N   GLU   107      21.701 -18.190  -6.052  1.00 33.52           N
ATOM    729  CA  GLU   107      21.319 -17.533  -4.797  1.00 33.48           C
ATOM    730  CB  GLU   107      20.104 -18.228  -4.179  1.00 33.55           C
ATOM    731  CG  GLU   107      18.865 -18.275  -5.060  1.00 33.79           C
ATOM    732  CD  GLU   107      17.904 -19.382  -4.665  1.00 34.37           C
ATOM    733  OE1 GLU   107      18.279 -20.252  -3.848  1.00 34.44           O
ATOM    734  OE2 GLU   107      16.769 -19.386  -5.183  1.00 35.08           O
ATOM    735  C   GLU   107      22.454 -17.530  -3.777  1.00 33.49           C
ATOM    736  O   GLU   107      23.302 -18.424  -3.783  1.00 33.49           O
ATOM    737  N   LEU   108      22.451 -16.533  -2.891  1.00 33.49           N
ATOM    738  CA  LEU   108      23.377 -16.489  -1.761  1.00 33.54           C
ATOM    739  CB  LEU   108      23.170 -15.211  -0.942  1.00 33.42           C
ATOM    740  CG  LEU   108      23.974 -15.053   0.358  1.00 33.34           C
ATOM    741  CD1 LEU   108      25.475 -14.959   0.088  1.00 32.85           C
ATOM    742  CD2 LEU   108      23.501 -13.857   1.166  1.00 33.16           C
ATOM    743  C   LEU   108      23.233 -17.728  -0.873  1.00 34.17           C
ATOM    744  O   LEU   108      24.202 -18.158  -0.236  1.00 34.01           O
ATOM    745  N   PHE   109      22.024 -18.293  -0.843  1.00 34.89           N
ATOM    746  CA  PHE   109      21.749 -19.548  -0.139  1.00 35.64           C
ATOM    747  CB  PHE   109      20.267 -19.935  -0.267  1.00 36.02           C
ATOM    748  CG  PHE   109      19.936 -21.299   0.296  1.00 36.63           C
ATOM    749  CD1 PHE   109      20.035 -21.549   1.668  1.00 37.40           C
ATOM    750  CE1 PHE   109      19.728 -22.810   2.193  1.00 37.93           C
ATOM    751  CZ  PHE   109      19.308 -23.840   1.338  1.00 37.98           C
ATOM    752  CE2 PHE   109      19.202 -23.602  -0.036  1.00 38.23           C
ATOM    753  CD2 PHE   109      19.518 -22.330  -0.547  1.00 37.77           C
ATOM    754  C   PHE   109      22.634 -20.685  -0.633  1.00 35.90           C
ATOM    755  O   PHE   109      23.195 -21.429   0.173  1.00 36.23           O
ATOM    756  N   ASP   110      22.753 -20.816  -1.955  1.00 36.15           N
ATOM    757  CA  ASP   110      23.589 -21.853  -2.561  1.00 36.28           C
ATOM    758  CB  ASP   110      23.398 -21.887  -4.078  1.00 36.23           C
ATOM    759  CG  ASP   110      22.042 -22.437  -4.483  1.00 36.64           C
ATOM    760  OD1 ASP   110      21.417 -21.852  -5.392  1.00 37.74           O
ATOM    761  OD2 ASP   110      21.593 -23.445  -3.891  1.00 36.09           O
ATOM    762  C   ASP   110      25.061 -21.664  -2.208  1.00 36.30           C
ATOM    763  O   ASP   110      25.805 -22.638  -2.073  1.00 36.12           O
ATOM    764  N   GLU   111      25.464 -20.407  -2.046  1.00 36.37           N
ATOM    765  CA  GLU   111      26.830 -20.081  -1.667  1.00 36.60           C
ATOM    766  CB  GLU   111      27.132 -18.608  -1.950  1.00 36.54           C
ATOM    767  CG  GLU   111      28.625 -18.269  -1.994  1.00 37.31           C
ATOM    768  CD  GLU   111      29.389 -19.047  -3.057  1.00 38.10           C
ATOM    769  OE1 GLU   111      30.522 -19.490  -2.770  1.00 38.38           O
ATOM    770  OE2 GLU   111      28.859 -19.218  -4.177  1.00 38.84           O
ATOM    771  C   GLU   111      27.102 -20.429  -0.205  1.00 36.61           C
ATOM    772  O   GLU   111      28.206 -20.854   0.133  1.00 36.67           O
ATOM    773  N   ILE   112      26.097 -20.250   0.653  1.00 36.70           N
ATOM    774  CA  ILE   112      26.201 -20.643   2.059  1.00 36.50           C
ATOM    775  CB  ILE   112      24.973 -20.191   2.883  1.00 36.47           C
ATOM    776  CG1 ILE   112      25.011 -18.674   3.086  1.00 36.37           C
ATOM    777  CD1 ILE   112      23.685 -18.073   3.524  1.00 36.16           C
ATOM    778  CG2 ILE   112      24.929 -20.892   4.242  1.00 36.56           C
ATOM    779  C   ILE   112      26.443 -22.148   2.176  1.00 36.50           C
ATOM    780  O   ILE   112      27.347 -22.569   2.894  1.00 36.44           O
ATOM    781  N   ILE   113      25.659 -22.946   1.451  1.00 36.66           N
ATOM    782  CA  ILE   113      25.867 -24.400   1.396  1.00 36.69           C
ATOM    783  CB  ILE   113      24.861 -25.122   0.445  1.00 36.66           C
ATOM    784  CG1 ILE   113      23.413 -24.901   0.897  1.00 36.88           C
ATOM    785  CD1 ILE   113      22.359 -25.417  -0.091  1.00 36.70           C
ATOM    786  CG2 ILE   113      25.164 -26.629   0.358  1.00 36.32           C
ATOM    787  C   ILE   113      27.294 -24.743   0.969  1.00 36.84           C
ATOM    788  O   ILE   113      27.923 -25.612   1.571  1.00 36.89           O
ATOM    789  N   LYS   114      27.796 -24.049  -0.054  1.00 37.07           N
ATOM    790  CA  LYS   114      29.108 -24.347  -0.644  1.00 37.48           C
ATOM    791  CB  LYS   114      29.271 -23.658  -2.009  1.00 37.43           C
ATOM    792  CG  LYS   114      30.544 -24.048  -2.765  1.00 37.61           C
ATOM    793  CD  LYS   114      30.754 -23.186  -4.004  1.00 37.66           C
ATOM    796  C   LYS   114      30.279 -23.992   0.276  1.00 37.69           C
ATOM    797  O   LYS   114      31.138 -24.835   0.535  1.00 37.73           O
ATOM    798  N   ARG   115      30.309 -22.751   0.758  1.00 37.97           N
ATOM    799  CA  ARG   115      31.419 -22.266   1.582  1.00 38.30           C
ATOM    800  CB  ARG   115      31.552 -20.747   1.482  1.00 38.46           C
ATOM    801  CG  ARG   115      32.084 -20.230   0.163  1.00 39.08           C
ATOM    802  CD  ARG   115      32.802 -18.912   0.385  1.00 40.50           C
ATOM    803  NE  ARG   115      32.388 -17.880  -0.564  1.00 41.66           N
ATOM    804  CZ  ARG   115      32.840 -16.628  -0.556  1.00 42.14           C
ATOM    805  NH1 ARG   115      33.735 -16.242   0.347  1.00 42.55           N
ATOM    806  NH2 ARG   115      32.398 -15.760  -1.456  1.00 42.51           N
ATOM    807  C   ARG   115      31.304 -22.650   3.054  1.00 38.39           C
ATOM    808  O   ARG   115      32.311 -22.670   3.767  1.00 38.33           O
ATOM    809  N   LYS   116      30.079 -22.944   3.501  1.00 38.47           N
ATOM    810  CA  LYS   116      29.766 -23.235   4.916  1.00 38.51           C
ATOM    811  CB  LYS   116      30.640 -24.369   5.493  1.00 38.50           C
ATOM    812  CG  LYS   116      30.640 -25.674   4.688  1.00 39.20           C
ATOM    813  CD  LYS   116      29.309 -26.418   4.779  1.00 40.13           C
ATOM    814  CE  LYS   116      29.247 -27.577   3.791  1.00 40.55           C
ATOM    815  NZ  LYS   116      30.306 -28.599   4.027  1.00 40.66           N
ATOM    816  C   LYS   116      29.853 -21.985   5.793  1.00 38.28           C
ATOM    817  O   LYS   116      28.910 -21.657   6.509  1.00 38.31           O
ATOM    818  N   ARG   117      30.997 -21.305   5.734  1.00 38.17           N
ATOM    819  CA  ARG   117      31.236 -20.058   6.457  1.00 38.04           C
ATOM    820  CB  ARG   117      32.042 -20.308   7.741  1.00 38.13           C
ATOM    821  CG  ARG   117      31.334 -21.167   8.781  1.00 38.77           C
ATOM    822  CD  ARG   117      31.927 -20.994  10.172  1.00 39.99           C
ATOM    823  NE  ARG   117      33.217 -21.659  10.333  1.00 41.28           N
ATOM    824  CZ  ARG   117      33.373 -22.950  10.625  1.00 42.06           C
ATOM    825  NH1 ARG   117      34.592 -23.458  10.751  1.00 41.84           N
ATOM    826  NH2 ARG   117      32.315 -23.738  10.782  1.00 42.52           N
ATOM    827  C   ARG   117      31.981 -19.064   5.563  1.00 37.86           C
ATOM    828  O   ARG   117      32.629 -19.446   4.582  1.00 37.76           O
ATOM    829  N   PHE   118      31.879 -17.786   5.910  1.00 37.62           N
ATOM    830  CA  PHE   118      32.569 -16.725   5.191  1.00 37.36           C
ATOM    831  CB  PHE   118      31.562 -15.696   4.662  1.00 37.23           C
ATOM    832  CG  PHE   118      30.636 -16.234   3.603  1.00 37.48           C
ATOM    833  CD1 PHE   118      29.620 -17.134   3.928  1.00 37.66           C
ATOM    834  CE1 PHE   118      28.763 -17.634   2.943  1.00 37.56           C
ATOM    835  CZ  PHE   118      28.914 -17.227   1.620  1.00 36.86           C
ATOM    836  CE2 PHE   118      29.918 -16.328   1.286  1.00 37.08           C
ATOM    837  CD2 PHE   118      30.773 -15.833   2.276  1.00 37.60           C
ATOM    838  C   PHE   118      33.541 -16.045   6.134  1.00 37.18           C
ATOM    839  O   PHE   118      33.249 -15.891   7.321  1.00 37.34           O
ATOM    840  N   SER   119      34.697 -15.645   5.612  1.00 36.91           N
ATOM    841  CA  SER   119      35.624 -14.812   6.372  1.00 36.85           C
ATOM    842  CB  SER   119      36.961 -14.660   5.635  1.00 36.88           C
ATOM    843  OG  SER   119      36.800 -13.946   4.420  1.00 36.81           O
ATOM    844  C   SER   119      34.989 -13.443   6.616  1.00 36.70           C
ATOM    845  O   SER   119      34.089 -13.032   5.875  1.00 36.71           O
ATOM    846  N   GLU   120      35.449 -12.748   7.654  1.00 36.56           N
ATOM    847  CA  GLU   120      34.903 -11.433   8.007  1.00 36.56           C
ATOM    848  CB  GLU   120      35.581 -10.876   9.263  1.00 36.52           C
ATOM    849  CG  GLU   120      35.304 -11.677  10.535  1.00 36.21           C
ATOM    850  CD  GLU   120      35.610 -10.899  11.807  1.00 36.20           C
ATOM    851  OE1 GLU   120      35.161  -9.739  11.915  1.00 35.47           O
ATOM    852  OE2 GLU   120      36.284 -11.449  12.704  1.00 35.08           O
ATOM    853  C   GLU   120      35.001 -10.439   6.845  1.00 36.72           C
ATOM    854  O   GLU   120      34.075  -9.662   6.606  1.00 36.78           O
ATOM    855  N   HIS   121      36.117 -10.503   6.122  1.00 36.79           N
ATOM    856  CA  HIS   121      36.375  -9.699   4.925  1.00 37.00           C
ATOM    857  CB  HIS   121      37.817  -9.948   4.447  1.00 37.26           C
ATOM    858  CG  HIS   121      38.141  -9.348   3.113  1.00 38.32           C
ATOM    859  ND1 HIS   121      37.564  -9.781   1.937  1.00 39.06           N
ATOM    860  CE1 HIS   121      38.053  -9.086   0.925  1.00 39.93           C
ATOM    861  NE2 HIS   121      38.941  -8.230   1.399  1.00 40.12           N
ATOM    862  CD2 HIS   121      39.019  -8.377   2.763  1.00 39.74           C
ATOM    863  C   HIS   121      35.366  -9.982   3.806  1.00 36.79           C
ATOM    864  O   HIS   121      34.743  -9.055   3.289  1.00 36.83           O
ATOM    865  N   ASP   122      35.217 -11.255   3.436  1.00 36.68           N
ATOM    866  CA  ASP   122      34.287 -11.669   2.379  1.00 36.37           C
ATOM    867  CB  ASP   122      34.475 -13.148   2.033  1.00 36.39           C
ATOM    868  CG  ASP   122      35.711 -13.409   1.173  1.00 36.34           C
ATOM    869  OD1 ASP   122      36.258 -12.455   0.571  1.00 35.80           O
ATOM    870  OD2 ASP   122      36.128 -14.586   1.092  1.00 35.41           O
ATOM    871  C   ASP   122      32.832 -11.415   2.756  1.00 36.45           C
ATOM    872  O   ASP   122      32.026 -11.011   1.910  1.00 36.51           O
ATOM    873  N   ALA   123      32.496 -11.655   4.023  1.00 36.22           N
ATOM    874  CA  ALA   123      31.146 -11.397   4.515  1.00 36.04           C
ATOM    875  CB  ALA   123      30.962 -11.954   5.926  1.00 35.90           C
ATOM    876  C   ALA   123      30.822  -9.904   4.476  1.00 36.00           C
ATOM    877  O   ALA   123      29.725  -9.515   4.067  1.00 36.35           O
ATOM    878  N   ALA   124      31.782  -9.076   4.886  1.00 35.66           N
ATOM    879  CA  ALA   124      31.590  -7.628   4.939  1.00 35.34           C
ATOM    880  CB  ALA   124      32.799  -6.945   5.567  1.00 35.44           C
ATOM    881  C   ALA   124      31.292  -7.031   3.573  1.00 35.16           C
ATOM    882  O   ALA   124      30.430  -6.169   3.456  1.00 34.99           O
ATOM    883  N   ARG   125      32.005  -7.489   2.547  1.00 35.21           N
ATOM    884  CA  ARG   125      31.808  -6.977   1.192  1.00 35.45           C
ATOM    885  CB  ARG   125      32.883  -7.502   0.242  1.00 35.29           C
ATOM    886  CG  ARG   125      34.236  -6.817   0.419  1.00 36.30           C
ATOM    887  CD  ARG   125      35.146  -7.044  -0.779  1.00 36.79           C
ATOM    888  NE  ARG   125      36.217  -6.054  -0.838  1.00 37.72           N
ATOM    892  C   ARG   125      30.409  -7.308   0.674  1.00 35.51           C
ATOM    893  O   ARG   125      29.740  -6.456   0.089  1.00 35.59           O
ATOM    894  N   ILE   126      29.978  -8.544   0.917  1.00 35.54           N
ATOM    895  CA  ILE   126      28.656  -9.022   0.528  1.00 35.88           C
ATOM    896  CB  ILE   126      28.496 -10.548   0.816  1.00 36.07           C
ATOM    897  CG1 ILE   126      29.344 -11.382  -0.156  1.00 35.58           C
ATOM    899  CG2 ILE   126      27.025 -10.971   0.750  1.00 35.70           C
ATOM    900  C   ILE   126      27.529  -8.253   1.224  1.00 35.87           C
ATOM    901  O   ILE   126      26.607  -7.763   0.569  1.00 35.90           O
ATOM    902  N   ILE   127      27.609  -8.148   2.548  1.00 36.00           N
ATOM    903  CA  ILE   127      26.514  -7.573   3.332  1.00 36.12           C
ATOM    904  CB  ILE   127      26.524  -8.082   4.809  1.00 35.91           C
ATOM    905  CG1 ILE   127      25.123  -8.010   5.433  1.00 36.32           C
ATOM    906  CD1 ILE   127      24.123  -9.036   4.901  1.00 35.52           C
ATOM    907  CG2 ILE   127      27.564  -7.338   5.658  1.00 35.44           C
ATOM    908  C   ILE   127      26.450  -6.039   3.231  1.00 36.39           C
ATOM    909  O   ILE   127      25.380  -5.455   3.405  1.00 36.55           O
ATOM    910  N   LYS   128      27.582  -5.401   2.931  1.00 36.57           N
ATOM    911  CA  LYS   128      27.619  -3.957   2.687  1.00 37.02           C
ATOM    912  CB  LYS   128      29.048  -3.466   2.436  1.00 36.87           C
ATOM    913  CG  LYS   128      29.160  -1.947   2.383  1.00 37.58           C
ATOM    914  CD  LYS   128      30.522  -1.451   1.924  1.00 37.09           C
ATOM    915  CE  LYS   128      30.477   0.051   1.651  1.00 37.69           C
ATOM    916  NZ  LYS   128      31.823   0.654   1.370  1.00 37.93           N
ATOM    917  C   LYS   128      26.729  -3.601   1.500  1.00 37.24           C
ATOM    918  O   LYS   128      25.963  -2.634   1.551  1.00 37.25           O
ATOM    919  N   GLN   129      26.839  -4.396   0.437  1.00 37.54           N
ATOM    920  CA  GLN   129      26.002  -4.233  -0.745  1.00 37.86           C
ATOM    921  CB  GLN   129      26.434  -5.191  -1.850  1.00 37.70           C
ATOM    922  CG  GLN   129      27.671  -4.724  -2.583  1.00 38.27           C
ATOM    923  CD  GLN   129      28.219  -5.773  -3.522  1.00 39.02           C
ATOM    924  OE1 GLN   129      28.055  -5.677  -4.738  1.00 39.16           O
ATOM    925  NE2 GLN   129      28.871  -6.788  -2.962  1.00 39.43           N
ATOM    926  C   GLN   129      24.530  -4.428  -0.402  1.00 38.06           C
ATOM    927  O   GLN   129      23.680  -3.685  -0.894  1.00 38.16           O
ATOM    928  N   VAL   130      24.245  -5.414   0.454  1.00 38.16           N
ATOM    929  CA  VAL   130      22.891  -5.648   0.974  1.00 38.26           C
ATOM    930  CB  VAL   130      22.827  -6.910   1.895  1.00 38.23           C
ATOM    931  CG1 VAL   130      21.446  -7.087   2.503  1.00 37.91           C
ATOM    932  CG2 VAL   130      23.209  -8.162   1.120  1.00 38.57           C
ATOM    933  C   VAL   130      22.377  -4.414   1.720  1.00 38.44           C
ATOM    934  O   VAL   130      21.217  -4.027   1.544  1.00 38.76           O
ATOM    935  N   PHE   131      23.243  -3.801   2.534  1.00 38.51           N
ATOM    936  CA  PHE   131      22.902  -2.588   3.291  1.00 38.50           C
ATOM    937  CB  PHE   131      24.013  -2.201   4.281  1.00 38.56           C
ATOM    938  CG  PHE   131      24.243  -3.201   5.383  1.00 38.34           C
ATOM    939  CD1 PHE   131      23.247  -4.097   5.768  1.00 38.39           C
ATOM    940  CE1 PHE   131      23.470  -5.017   6.789  1.00 38.38           C
ATOM    941  CZ  PHE   131      24.688  -5.033   7.456  1.00 38.10           C
ATOM    942  CE2 PHE   131      25.683  -4.135   7.091  1.00 38.61           C
ATOM    943  CD2 PHE   131      25.457  -3.225   6.060  1.00 38.32           C
ATOM    944  C   PHE   131      22.648  -1.410   2.363  1.00 38.56           C
ATOM    945  O   PHE   131      21.714  -0.631   2.574  1.00 38.51           O
ATOM    946  N   SER   132      23.486  -1.284   1.338  1.00 38.55           N
ATOM    947  CA  SER   132      23.352  -0.207   0.374  1.00 38.70           C
ATOM    948  CB  SER   132      24.447  -0.297  -0.683  1.00 38.79           C
ATOM    949  OG  SER   132      24.417   0.844  -1.525  1.00 39.77           O
ATOM    950  C   SER   132      21.974  -0.248  -0.281  1.00 38.66           C
ATOM    951  O   SER   132      21.317   0.789  -0.422  1.00 39.01           O
ATOM    952  N   GLY   133      21.541  -1.450  -0.664  1.00 38.31           N
ATOM    953  CA  GLY   133      20.230  -1.655  -1.279  1.00 37.83           C
ATOM    954  C   GLY   133      19.086  -1.346  -0.330  1.00 37.66           C
ATOM    955  O   GLY   133      18.174  -0.592  -0.676  1.00 37.42           O
ATOM    956  N   ILE   134      19.145  -1.929   0.867  1.00 37.33           N
ATOM    957  CA  ILE   134      18.147  -1.697   1.914  1.00 37.04           C
ATOM    958  CB  ILE   134      18.474  -2.505   3.194  1.00 37.18           C
ATOM    959  CG1 ILE   134      18.214  -3.992   2.967  1.00 37.31           C
ATOM    960  CD1 ILE   134      18.740  -4.860   4.090  1.00 38.64           C
ATOM    961  CG2 ILE   134      17.636  -2.036   4.377  1.00 37.43           C
ATOM    962  C   ILE   134      18.014  -0.211   2.243  1.00 36.65           C
ATOM    963  O   ILE   134      16.903   0.321   2.270  1.00 36.84           O
ATOM    964  N   THR   135      19.147   0.448   2.480  1.00 36.30           N
ATOM    965  CA  THR   135      19.186   1.886   2.741  1.00 35.98           C
ATOM    966  CB  THR   135      20.656   2.404   2.827  1.00 36.00           C
ATOM    967  OG1 THR   135      21.331   1.754   3.910  1.00 35.31           O
ATOM    968  CG2 THR   135      20.715   3.920   3.035  1.00 35.30           C
ATOM    969  C   THR   135      18.406   2.665   1.673  1.00 36.03           C
ATOM    970  O   THR   135      17.551   3.497   2.000  1.00 35.98           O
ATOM    971  N   TYR   136      18.705   2.381   0.405  1.00 35.86           N
ATOM    972  CA  TYR   136      18.094   3.091  -0.711  1.00 35.85           C
ATOM    973  CB  TYR   136      18.751   2.689  -2.039  1.00 35.59           C
ATOM    974  CG  TYR   136      18.043   3.217  -3.269  1.00 35.22           C
ATOM    975  CD1 TYR   136      18.323   4.484  -3.768  1.00 34.60           C
ATOM    976  CE1 TYR   136      17.673   4.972  -4.898  1.00 34.44           C
ATOM    977  CZ  TYR   136      16.733   4.183  -5.542  1.00 34.97           C
ATOM    978  OH  TYR   136      16.090   4.659  -6.661  1.00 34.87           O
ATOM    979  CE2 TYR   136      16.435   2.921  -5.068  1.00 34.41           C
ATOM    980  CD2 TYR   136      17.088   2.443  -3.936  1.00 35.11           C
ATOM    981  C   TYR   136      16.585   2.870  -0.763  1.00 36.15           C
ATOM    982  O   TYR   136      15.831   3.812  -1.019  1.00 36.25           O
ATOM    983  N   MET   137      16.149   1.633  -0.528  1.00 36.19           N
ATOM    984  CA  MET   137      14.726   1.318  -0.565  1.00 36.60           C
ATOM    985  CB  MET   137      14.484  -0.194  -0.659  1.00 36.57           C
ATOM    986  CG  MET   137      15.080  -0.882  -1.889  1.00 36.67           C
ATOM    987  SD  MET   137      14.485  -0.279  -3.490  1.00 39.34           S
ATOM    988  CE  MET   137      12.859  -1.052  -3.570  1.00 37.93           C
ATOM    989  C   MET   137      13.998   1.921   0.640  1.00 36.77           C
ATOM    990  O   MET   137      12.875   2.409   0.508  1.00 36.50           O
ATOM    991  N   HIS   138      14.660   1.910   1.799  1.00 37.07           N
ATOM    992  CA  HIS   138      14.099   2.460   3.039  1.00 37.48           C
ATOM    993  CB  HIS   138      14.950   2.046   4.239  1.00 37.56           C
ATOM    994  CG  HIS   138      14.751   0.619   4.646  1.00 37.99           C
ATOM    995  ND1 HIS   138      15.144   0.133   5.873  1.00 38.22           N
ATOM    996  CE1 HIS   138      14.825  -1.146   5.959  1.00 38.06           C
ATOM    997  NE2 HIS   138      14.241  -1.507   4.830  1.00 38.16           N
ATOM    998  CD2 HIS   138      14.179  -0.421   3.994  1.00 37.57           C
ATOM    999  C   HIS   138      13.935   3.973   3.000  1.00 37.78           C
ATOM   1000  O   HIS   138      13.043   4.525   3.656  1.00 37.97           O
ATOM   1001  N   LYS   139      14.798   4.633   2.228  1.00 37.85           N
ATOM   1002  CA  LYS   139      14.692   6.064   1.967  1.00 38.05           C
ATOM   1003  CB  LYS   139      15.876   6.528   1.121  1.00 38.01           C
ATOM   1004  CG  LYS   139      16.333   7.946   1.395  1.00 38.54           C
ATOM   1005  CD  LYS   139      17.494   8.349   0.481  1.00 38.59           C
ATOM   1006  CE  LYS   139      17.005   8.808  -0.896  1.00 39.38           C
ATOM   1007  NZ  LYS   139      18.119   9.260  -1.778  0.50 38.90           N
ATOM   1008  C   LYS   139      13.387   6.359   1.234  1.00 37.83           C
ATOM   1009  O   LYS   139      12.820   7.443   1.372  1.00 37.81           O
ATOM   1010  N   HIS   140      12.923   5.380   0.462  1.00 37.76           N
ATOM   1011  CA  HIS   140      11.685   5.488  -0.297  1.00 37.84           C
ATOM   1012  CB  HIS   140      11.904   4.999  -1.727  1.00 37.68           C
ATOM   1013  CG  HIS   140      12.732   5.926  -2.561  1.00 37.65           C
ATOM   1014  ND1 HIS   140      14.085   5.750  -2.750  1.00 37.51           N
ATOM   1015  CE1 HIS   140      14.548   6.715  -3.526  1.00 38.12           C
ATOM   1016  NE2 HIS   140      13.542   7.506  -3.853  1.00 37.89           N
ATOM   1017  CD2 HIS   140      12.394   7.035  -3.262  1.00 37.76           C
ATOM   1018  C   HIS   140      10.528   4.728   0.365  1.00 38.12           C
ATOM   1019  O   HIS   140       9.542   4.386  -0.297  1.00 38.03           O
ATOM   1020  N   ASN   141      10.665   4.468   1.669  1.00 38.34           N
ATOM   1021  CA  ASN   141       9.613   3.846   2.492  1.00 38.41           C
ATOM   1022  CB  ASN   141       8.352   4.719   2.526  1.00 38.42           C
ATOM   1023  CG  ASN   141       8.635   6.144   2.955  1.00 38.82           C
ATOM   1024  OD1 ASN   141       9.148   6.388   4.046  1.00 39.07           O
ATOM   1025  ND2 ASN   141       8.290   7.097   2.098  1.00 39.44           N
ATOM   1026  C   ASN   141       9.241   2.414   2.100  1.00 38.55           C
ATOM   1027  O   ASN   141       8.202   1.888   2.541  1.00 38.39           O
ATOM   1028  N   ILE   142      10.087   1.778   1.289  1.00 38.47           N
ATOM   1029  CA  ILE   142       9.802   0.427   0.803  1.00 38.44           C
ATOM   1030  CB  ILE   142      10.140   0.258  -0.700  1.00 38.55           C
ATOM   1031  CG1 ILE   142       9.294   1.209  -1.554  1.00 38.43           C
ATOM   1033  CG2 ILE   142       9.892  -1.188  -1.150  1.00 38.79           C
ATOM   1034  C   ILE   142      10.498  -0.631   1.658  1.00 38.24           C
ATOM   1035  O   ILE   142      11.726  -0.674   1.736  1.00 38.21           O
ATOM   1036  N   VAL   143       9.687  -1.470   2.301  1.00 38.06           N
ATOM   1037  CA  VAL   143      10.165  -2.535   3.178  1.00 37.80           C
ATOM   1038  CB  VAL   143       9.337  -2.593   4.493  1.00 37.85           C
ATOM   1039  CG1 VAL   143       9.975  -3.561   5.499  1.00 37.17           C
ATOM   1040  CG2 VAL   143       9.185  -1.194   5.106  1.00 37.28           C
ATOM   1041  C   VAL   143      10.079  -3.891   2.463  1.00 38.00           C
ATOM   1042  O   VAL   143       9.041  -4.230   1.883  1.00 38.14           O
ATOM   1043  N   HIS   144      11.159  -4.666   2.508  1.00 37.82           N
ATOM   1044  CA  HIS   144      11.163  -5.976   1.864  1.00 37.95           C
ATOM   1045  CB  HIS   144      12.582  -6.543   1.718  1.00 37.73           C
ATOM   1046  CG  HIS   144      12.660  -7.720   0.793  1.00 38.01           C
ATOM   1047  ND1 HIS   144      12.079  -8.938   1.082  1.00 37.54           N
ATOM   1048  CE1 HIS   144      12.300  -9.778   0.086  1.00 37.75           C
ATOM   1049  NE2 HIS   144      12.997  -9.149  -0.843  1.00 38.13           N
ATOM   1050  CD2 HIS   144      13.236  -7.861  -0.427  1.00 38.48           C
ATOM   1051  C   HIS   144      10.256  -6.970   2.589  1.00 37.91           C
ATOM   1052  O   HIS   144       9.370  -7.561   1.968  1.00 37.73           O
ATOM   1053  N   ARG   145      10.504  -7.153   3.890  1.00 37.97           N
ATOM   1054  CA  ARG   145       9.711  -8.026   4.779  1.00 37.97           C
ATOM   1055  CB  ARG   145       8.199  -7.848   4.572  1.00 37.80           C
ATOM   1056  CG  ARG   145       7.640  -6.462   4.881  1.00 37.93           C
ATOM   1057  CD  ARG   145       6.160  -6.369   4.470  1.00 38.06           C
ATOM   1058  NE  ARG   145       5.302  -7.227   5.296  1.00 37.67           N
ATOM   1059  CZ  ARG   145       4.033  -7.519   5.031  1.00 36.50           C
ATOM   1060  NH1 ARG   145       3.357  -8.309   5.846  1.00 35.78           N
ATOM   1061  NH2 ARG   145       3.437  -7.028   3.954  1.00 37.40           N
ATOM   1062  C   ARG   145      10.057  -9.512   4.687  1.00 38.14           C
ATOM   1063  O   ARG   145       9.674 -10.293   5.563  1.00 38.05           O
ATOM   1064  N   ASP   146      10.753  -9.914   3.629  1.00 38.34           N
ATOM   1065  CA  ASP   146      11.065 -11.331   3.429  1.00 38.90           C
ATOM   1066  CB  ASP   146      10.087 -11.976   2.440  1.00 39.10           C
ATOM   1067  CG  ASP   146       8.720 -12.219   3.043  1.00 40.68           C
ATOM   1068  OD1 ASP   146       7.830 -11.361   2.861  1.00 43.27           O
ATOM   1069  OD2 ASP   146       8.521 -13.264   3.703  1.00 43.42           O
ATOM   1070  C   ASP   146      12.513 -11.536   2.979  1.00 38.86           C
ATOM   1071  O   ASP   146      12.801 -12.404   2.153  1.00 38.69           O
ATOM   1072  N   LEU   147      13.416 -10.726   3.530  1.00 38.87           N
ATOM   1073  CA  LEU   147      14.839 -10.839   3.243  1.00 39.04           C
ATOM   1074  CB  LEU   147      15.611  -9.696   3.896  1.00 39.26           C
ATOM   1075  CG  LEU   147      16.114  -8.513   3.075  1.00 40.03           C
ATOM   1076  CD1 LEU   147      17.281  -7.917   3.817  1.00 40.42           C
ATOM   1077  CD2 LEU   147      16.562  -8.928   1.676  1.00 41.79           C
ATOM   1078  C   LEU   147      15.423 -12.179   3.699  1.00 38.92           C
ATOM   1079  O   LEU   147      15.436 -12.488   4.890  1.00 38.67           O
ATOM   1080  N   LYS   148      15.895 -12.964   2.731  1.00 38.75           N
ATOM   1081  CA  LYS   148      16.563 -14.242   2.986  1.00 38.66           C
ATOM   1082  CB  LYS   148      15.556 -15.409   3.007  1.00 38.38           C
ATOM   1083  CG  LYS   148      14.406 -15.315   1.997  1.00 39.21           C
ATOM   1084  CD  LYS   148      13.594 -16.612   1.912  1.00 39.48           C
ATOM   1085  CE  LYS   148      12.572 -16.753   3.040  1.00 42.02           C
ATOM   1086  NZ  LYS   148      11.274 -16.044   2.773  1.00 43.81           N
ATOM   1087  C   LYS   148      17.673 -14.460   1.948  1.00 38.28           C
ATOM   1088  O   LYS   148      17.683 -13.787   0.911  1.00 38.13           O
ATOM   1089  N   PRO   149      18.622 -15.383   2.224  1.00 38.05           N
ATOM   1090  CA  PRO   149      19.702 -15.637   1.271  1.00 38.02           C
ATOM   1091  CB  PRO   149      20.534 -16.729   1.957  1.00 38.16           C
ATOM   1092  CG  PRO   149      20.180 -16.641   3.403  1.00 37.85           C
ATOM   1093  CD  PRO   149      18.750 -16.229   3.426  1.00 38.04           C
ATOM   1094  C   PRO   149      19.183 -16.121  -0.085  1.00 38.07           C
ATOM   1095  O   PRO   149      19.845 -15.902  -1.105  1.00 37.99           O
ATOM   1096  N   GLU   150      18.003 -16.751  -0.090  1.00 37.92           N
ATOM   1097  CA  GLU   150      17.317 -17.161  -1.325  1.00 37.89           C
ATOM   1098  CB  GLU   150      16.091 -18.028  -1.014  1.00 38.04           C
ATOM   1099  CG  GLU   150      16.400 -19.395  -0.411  1.00 38.38           C
ATOM   1100  CD  GLU   150      16.369 -19.405   1.111  1.00 38.74           C
ATOM   1101  OE1 GLU   150      16.829 -18.432   1.749  1.00 38.30           O
ATOM   1102  OE2 GLU   150      15.879 -20.407   1.675  1.00 39.93           O
ATOM   1103  C   GLU   150      16.884 -15.965  -2.175  1.00 37.77           C
ATOM   1104  O   GLU   150      16.699 -16.095  -3.387  1.00 37.60           O
ATOM   1105  N   ASN   151      16.722 -14.811  -1.529  1.00 37.70           N
ATOM   1106  CA  ASN   151      16.319 -13.569  -2.198  1.00 38.03           C
ATOM   1107  CB  ASN   151      15.286 -12.821  -1.346  1.00 38.05           C
ATOM   1108  CG  ASN   151      13.906 -13.430  -1.434  1.00 38.59           C
ATOM   1109  OD1 ASN   151      13.578 -14.124  -2.396  1.00 39.49           O
ATOM   1110  ND2 ASN   151      13.078 -13.158  -0.434  1.00 38.97           N
ATOM   1111  C   ASN   151      17.487 -12.632  -2.539  1.00 38.09           C
ATOM   1112  O   ASN   151      17.280 -11.470  -2.900  1.00 37.79           O
ATOM   1113  N   ILE   152      18.709 -13.139  -2.407  1.00 38.47           N
ATOM   1114  CA  ILE   152      19.906 -12.383  -2.757  1.00 38.76           C
ATOM   1115  CB  ILE   152      20.795 -12.092  -1.527  1.00 38.70           C
ATOM   1116  CG1 ILE   152      19.985 -11.371  -0.440  1.00 38.20           C
ATOM   1117  CD1 ILE   152      20.587 -11.437   0.941  1.00 37.23           C
ATOM   1118  CG2 ILE   152      22.017 -11.262  -1.942  1.00 38.69           C
ATOM   1119  C   ILE   152      20.691 -13.170  -3.788  1.00 39.20           C
ATOM   1120  O   ILE   152      21.098 -14.307  -3.530  1.00 39.32           O
ATOM   1121  N   LEU   153      20.901 -12.563  -4.952  1.00 39.70           N
ATOM   1122  CA  LEU   153      21.590 -13.234  -6.046  1.00 40.26           C
ATOM   1123  CB  LEU   153      20.797 -13.083  -7.347  1.00 40.20           C
ATOM   1124  CG  LEU   153      19.712 -14.133  -7.623  1.00 40.26           C
ATOM   1125  CD1 LEU   153      18.552 -14.062  -6.629  1.00 40.60           C
ATOM   1126  CD2 LEU   153      19.196 -13.984  -9.039  1.00 40.44           C
ATOM   1127  C   LEU   153      23.041 -12.777  -6.220  1.00 40.67           C
ATOM   1128  O   LEU   153      23.398 -11.658  -5.838  1.00 40.83           O
ATOM   1129  N   LEU   154      23.862 -13.665  -6.786  1.00 41.11           N
ATOM   1130  CA  LEU   154      25.279 -13.408  -7.061  1.00 41.29           C
ATOM   1131  CB  LEU   154      26.182 -14.322  -6.219  1.00 41.31           C
ATOM   1132  CG  LEU   154      26.104 -14.399  -4.691  1.00 41.80           C
ATOM   1133  CD1 LEU   154      27.351 -15.101  -4.184  1.00 42.11           C
ATOM   1134  CD2 LEU   154      25.977 -13.029  -4.035  1.00 42.39           C
ATOM   1135  C   LEU   154      25.580 -13.627  -8.543  1.00 41.48           C
ATOM   1136  O   LEU   154      26.740 -13.769  -8.951  1.00 41.64           O
ATOM   1137  N   LYS   159      30.107 -16.087 -11.893  1.00 38.12           N
ATOM   1138  CA  LYS   159      29.925 -15.137 -10.800  1.00 38.20           C
ATOM   1139  CB  LYS   159      29.233 -15.814  -9.612  1.00 38.23           C
ATOM   1144  C   LYS   159      31.255 -14.514 -10.365  1.00 38.16           C
ATOM   1145  O   LYS   159      32.324 -15.073 -10.615  1.00 38.04           O
ATOM   1146  N   ASP   160      31.175 -13.352  -9.715  1.00 38.22           N
ATOM   1147  CA  ASP   160      32.366 -12.636  -9.253  1.00 38.15           C
ATOM   1148  CB  ASP   160      32.810 -11.594 -10.292  1.00 38.13           C
ATOM   1149  CG  ASP   160      34.142 -10.954  -9.948  1.00 38.28           C
ATOM   1150  OD1 ASP   160      34.182 -10.136  -9.004  1.00 38.23           O
ATOM   1151  OD2 ASP   160      35.146 -11.259 -10.630  1.00 38.14           O
ATOM   1152  C   ASP   160      32.213 -12.013  -7.849  1.00 38.09           C
ATOM   1153  O   ASP   160      32.832 -12.500  -6.900  1.00 38.29           O
ATOM   1154  N   CYS   161      31.402 -10.955  -7.720  1.00 37.75           N
ATOM   1155  CA  CYS   161      31.299 -10.194  -6.458  1.00 37.35           C
ATOM   1156  CB  CYS   161      32.422  -9.143  -6.362  1.00 37.35           C
ATOM   1157  SG  CYS   161      34.038  -9.730  -5.757  0.50 37.23           S
ATOM   1158  C   CYS   161      29.950  -9.499  -6.203  1.00 37.18           C
ATOM   1159  O   CYS   161      29.635  -9.185  -5.053  1.00 36.88           O
ATOM   1160  N   ASP   162      29.171  -9.264  -7.263  1.00 36.97           N
ATOM   1161  CA  ASP   162      27.985  -8.391  -7.207  1.00 36.80           C
ATOM   1162  CB  ASP   162      27.684  -7.809  -8.592  1.00 36.90           C
ATOM   1163  CG  ASP   162      28.818  -6.968  -9.137  1.00 37.34           C
ATOM   1164  OD1 ASP   162      29.017  -6.988 -10.371  1.00 37.88           O
ATOM   1165  OD2 ASP   162      29.510  -6.288  -8.345  1.00 37.33           O
ATOM   1166  C   ASP   162      26.724  -9.068  -6.679  1.00 36.66           C
ATOM   1167  O   ASP   162      26.345 -10.136  -7.159  1.00 36.97           O
ATOM   1168  N   ILE   163      26.064  -8.428  -5.711  1.00 36.22           N
ATOM   1169  CA  ILE   163      24.827  -8.952  -5.126  1.00 35.77           C
ATOM   1170  CB  ILE   163      24.908  -9.026  -3.583  1.00 35.74           C
ATOM   1174  C   ILE   163      23.616  -8.109  -5.521  1.00 35.51           C
ATOM   1175  O   ILE   163      23.707  -6.884  -5.608  1.00 35.54           O
ATOM   1176  N   LYS   164      22.484  -8.765  -5.761  1.00 35.04           N
ATOM   1177  CA  LYS   164      21.239  -8.055  -6.061  1.00 34.70           C
ATOM   1178  CB  LYS   164      20.983  -8.015  -7.576  1.00 34.79           C
ATOM   1179  CG  LYS   164      21.775  -6.920  -8.301  1.00 34.67           C
ATOM   1180  CD  LYS   164      21.802  -7.114  -9.808  1.00 34.72           C
ATOM   1183  C   LYS   164      20.057  -8.665  -5.316  1.00 34.38           C
ATOM   1184  O   LYS   164      19.853  -9.878  -5.356  1.00 34.43           O
ATOM   1185  N   ILE   165      19.298  -7.821  -4.621  1.00 34.12           N
ATOM   1186  CA  ILE   165      18.123  -8.263  -3.865  1.00 33.72           C
ATOM   1187  CB  ILE   165      17.842  -7.366  -2.638  1.00 33.72           C
ATOM   1188  CG1 ILE   165      19.109  -7.162  -1.799  1.00 33.32           C
ATOM   1189  CD1 ILE   165      18.971  -6.104  -0.728  1.00 33.19           C
ATOM   1190  CG2 ILE   165      16.701  -7.954  -1.800  1.00 33.22           C
ATOM   1191  C   ILE   165      16.882  -8.269  -4.752  1.00 33.98           C
ATOM   1192  O   ILE   165      16.545  -7.245  -5.354  1.00 33.96           O
ATOM   1193  N   ILE   166      16.203  -9.417  -4.817  1.00 34.12           N
ATOM   1194  CA  ILE   166      15.036  -9.587  -5.696  1.00 34.31           C
ATOM   1195  CB  ILE   166      15.028 -10.961  -6.431  1.00 34.24           C
ATOM   1196  CG1 ILE   166      14.757 -12.116  -5.456  1.00 34.23           C
ATOM   1197  CD1 ILE   166      14.203 -13.367  -6.124  1.00 34.30           C
ATOM   1198  CG2 ILE   166      16.325 -11.164  -7.212  1.00 34.38           C
ATOM   1199  C   ILE   166      13.697  -9.376  -4.991  1.00 34.54           C
ATOM   1200  O   ILE   166      13.611  -9.437  -3.758  1.00 34.52           O
ATOM   1201  N   ASP   167      12.666  -9.119  -5.799  1.00 34.74           N
ATOM   1202  CA  ASP   167      11.280  -8.975  -5.340  1.00 34.80           C
ATOM   1203  CB  ASP   167      10.724 -10.330  -4.888  1.00 34.87           C
ATOM   1204  CG  ASP   167      10.837 -11.388  -5.958  1.00 35.57           C
ATOM   1205  OD1 ASP   167      10.837 -12.588  -5.610  1.00 36.86           O
ATOM   1206  OD2 ASP   167      10.939 -11.020  -7.148  1.00 36.39           O
ATOM   1207  C   ASP   167      11.089  -7.933  -4.241  1.00 34.56           C
ATOM   1208  O   ASP   167      10.157  -8.036  -3.432  1.00 34.55           O
ATOM   1209  N   PHE   168      11.959  -6.927  -4.221  1.00 34.33           N
ATOM   1210  CA  PHE   168      11.928  -5.919  -3.161  1.00 34.15           C
ATOM   1211  CB  PHE   168      13.165  -5.009  -3.203  1.00 33.90           C
ATOM   1212  CG  PHE   168      13.570  -4.474  -1.851  1.00 33.72           C
ATOM   1213  CD1 PHE   168      12.705  -3.668  -1.112  1.00 33.22           C
ATOM   1214  CE1 PHE   168      13.077  -3.177   0.142  1.00 33.30           C
ATOM   1215  CZ  PHE   168      14.326  -3.493   0.664  1.00 33.77           C
ATOM   1216  CE2 PHE   168      15.197  -4.300  -0.065  1.00 33.06           C
ATOM   1217  CD2 PHE   168      14.814  -4.785  -1.314  1.00 33.34           C
ATOM   1218  C   PHE   168      10.642  -5.097  -3.211  1.00 34.08           C
ATOM   1219  O   PHE   168      10.421  -4.327  -4.142  1.00 33.93           O
ATOM   1220  N   GLY   169       9.797  -5.292  -2.203  1.00 34.33           N
ATOM   1221  CA  GLY   169       8.536  -4.565  -2.084  1.00 34.49           C
ATOM   1222  C   GLY   169       7.308  -5.308  -2.575  1.00 34.63           C
ATOM   1223  O   GLY   169       6.182  -4.831  -2.395  1.00 34.62           O
ATOM   1224  N   LEU   170       7.515  -6.469  -3.196  1.00 34.82           N
ATOM   1225  CA  LEU   170       6.414  -7.233  -3.788  1.00 35.04           C
ATOM   1226  CB  LEU   170       6.936  -8.273  -4.788  1.00 35.13           C
ATOM   1227  CG  LEU   170       7.441  -7.840  -6.172  1.00 35.16           C
ATOM   1228  CD1 LEU   170       7.729  -9.063  -7.011  1.00 34.43           C
ATOM   1229  CD2 LEU   170       6.445  -6.935  -6.900  1.00 35.71           C
ATOM   1230  C   LEU   170       5.489  -7.905  -2.767  1.00 35.19           C
ATOM   1231  O   LEU   170       4.301  -8.100  -3.043  1.00 35.21           O
ATOM   1232  N   SER   171       6.029  -8.245  -1.596  1.00 35.45           N
ATOM   1233  CA  SER   171       5.276  -8.954  -0.552  1.00 35.77           C
ATOM   1234  CB  SER   171       6.199  -9.368   0.588  1.00 35.75           C
ATOM   1235  OG  SER   171       6.638  -8.217   1.287  1.00 37.47           O
ATOM   1236  C   SER   171       4.077  -8.182   0.019  1.00 35.71           C
ATOM   1237  O   SER   171       3.174  -8.791   0.594  1.00 35.82           O
ATOM   1238  N   THR   172       4.063  -6.855  -0.123  1.00 35.52           N
ATOM   1239  CA  THR   172       2.884  -6.086   0.291  1.00 35.69           C
ATOM   1240  CB  THR   172       3.191  -4.598   0.649  1.00 35.74           C
ATOM   1241  OG1 THR   172       3.613  -3.881  -0.520  1.00 36.13           O
ATOM   1242  CG2 THR   172       4.261  -4.499   1.736  1.00 35.49           C
ATOM   1243  C   THR   172       1.772  -6.171  -0.760  1.00 35.73           C
ATOM   1244  O   THR   172       0.592  -6.016  -0.435  1.00 36.05           O
ATOM   1245  N   CYS   173       2.154  -6.437  -2.008  1.00 35.48           N
ATOM   1246  CA  CYS   173       1.199  -6.563  -3.104  1.00 35.45           C
ATOM   1247  CB  CYS   173       1.844  -6.146  -4.425  1.00 35.58           C
ATOM   1248  SG  CYS   173       2.446  -4.452  -4.468  1.00 35.57           S
ATOM   1249  C   CYS   173       0.647  -7.973  -3.250  1.00 35.34           C
ATOM   1250  O   CYS   173      -0.538  -8.154  -3.526  1.00 35.43           O
ATOM   1251  N   PHE   174       1.513  -8.967  -3.070  1.00 35.34           N
ATOM   1252  CA  PHE   174       1.174 -10.349  -3.379  1.00 35.18           C
ATOM   1253  CB  PHE   174       1.861 -10.779  -4.675  1.00 34.71           C
ATOM   1254  CG  PHE   174       1.563  -9.888  -5.850  1.00 34.28           C
ATOM   1255  CD1 PHE   174       0.312  -9.916  -6.466  1.00 34.11           C
ATOM   1256  CE1 PHE   174       0.037  -9.088  -7.557  1.00 33.46           C
ATOM   1257  CZ  PHE   174       1.018  -8.227  -8.040  1.00 33.32           C
ATOM   1258  CE2 PHE   174       2.265  -8.194  -7.433  1.00 32.69           C
ATOM   1259  CD2 PHE   174       2.533  -9.023  -6.346  1.00 32.90           C
ATOM   1260  C   PHE   174       1.512 -11.327  -2.256  1.00 35.54           C
ATOM   1261  O   PHE   174       2.541 -11.204  -1.589  1.00 35.49           O
ATOM   1262  N   GLN   175       0.623 -12.297  -2.073  1.00 36.06           N
ATOM   1263  CA  GLN   175       0.786 -13.374  -1.107  1.00 36.86           C
ATOM   1264  CB  GLN   175      -0.584 -13.981  -0.780  1.00 37.09           C
ATOM   1265  CG  GLN   175      -0.635 -14.741   0.536  1.00 38.88           C
ATOM   1266  CD  GLN   175      -0.791 -13.820   1.735  1.00 40.93           C
ATOM   1267  OE1 GLN   175       0.191 -13.488   2.413  1.00 41.26           O
ATOM   1268  NE2 GLN   175      -2.030 -13.389   1.995  1.00 41.04           N
ATOM   1269  C   GLN   175       1.719 -14.460  -1.655  1.00 36.95           C
ATOM   1270  O   GLN   175       1.607 -14.858  -2.817  1.00 36.84           O
ATOM   1271  N   GLN   176       2.630 -14.937  -0.810  1.00 37.34           N
ATOM   1272  CA  GLN   176       3.631 -15.934  -1.206  1.00 37.90           C
ATOM   1273  CB  GLN   176       4.929 -15.716  -0.426  1.00 37.96           C
ATOM   1274  CG  GLN   176       5.533 -14.347  -0.613  1.00 39.55           C
ATOM   1275  CD  GLN   176       6.461 -13.969   0.514  1.00 41.39           C
ATOM   1276  OE1 GLN   176       7.436 -14.672   0.798  1.00 42.73           O
ATOM   1277  NE2 GLN   176       6.167 -12.849   1.168  1.00 41.94           N
ATOM   1278  C   GLN   176       3.156 -17.370  -0.991  1.00 37.88           C
ATOM   1279  O   GLN   176       2.075 -17.599  -0.446  1.00 37.91           O
ATOM   1280  N   ASN   177       3.972 -18.328  -1.432  1.00 38.05           N
ATOM   1281  CA  ASN   177       3.774 -19.738  -1.100  1.00 38.30           C
ATOM   1282  CB  ASN   177       4.692 -20.640  -1.938  1.00 38.37           C
ATOM   1283  CG  ASN   177       4.340 -20.641  -3.424  1.00 38.40           C
ATOM   1284  OD1 ASN   177       3.218 -20.318  -3.820  1.00 38.55           O
ATOM   1285  ND2 ASN   177       5.308 -21.019  -4.252  1.00 38.16           N
ATOM   1286  C   ASN   177       4.043 -19.960   0.386  1.00 38.27           C
ATOM   1287  O   ASN   177       4.979 -19.383   0.949  1.00 38.31           O
ATOM   1288  N   THR   178       3.214 -20.787   1.017  1.00 38.31           N
ATOM   1289  CA  THR   178       3.335 -21.063   2.450  1.00 38.29           C
ATOM   1290  CB  THR   178       2.262 -20.299   3.272  1.00 38.36           C
ATOM   1291  OG1 THR   178       0.981 -20.442   2.644  1.00 37.83           O
ATOM   1292  CG2 THR   178       2.608 -18.816   3.384  1.00 38.27           C
ATOM   1293  C   THR   178       3.282 -22.562   2.778  1.00 38.35           C
ATOM   1294  O   THR   178       2.639 -22.973   3.747  1.00 38.25           O
ATOM   1295  N   LYS   179       3.965 -23.372   1.969  1.00 38.47           N
ATOM   1296  CA  LYS   179       4.131 -24.797   2.262  1.00 38.63           C
ATOM   1297  CB  LYS   179       4.611 -25.569   1.023  1.00 38.63           C
ATOM   1298  CG  LYS   179       3.685 -25.507  -0.200  1.00 38.96           C
ATOM   1299  CD  LYS   179       2.469 -26.438  -0.094  1.00 39.55           C
ATOM   1300  CE  LYS   179       2.773 -27.872  -0.544  1.00 39.79           C
ATOM   1301  NZ  LYS   179       3.418 -28.702   0.519  1.00 39.98           N
ATOM   1302  C   LYS   179       5.136 -24.946   3.405  1.00 38.75           C
ATOM   1303  O   LYS   179       5.796 -23.973   3.780  1.00 38.59           O
ATOM   1304  N   MET   180       5.250 -26.156   3.955  1.00 38.84           N
ATOM   1305  CA  MET   180       6.173 -26.425   5.059  1.00 38.95           C
ATOM   1306  CB  MET   180       6.262 -27.929   5.344  1.00 39.03           C
ATOM   1310  C   MET   180       7.563 -25.852   4.786  1.00 39.06           C
ATOM   1311  O   MET   180       8.142 -25.180   5.641  1.00 39.05           O
ATOM   1312  N   LYS   181       8.073 -26.105   3.582  1.00 39.14           N
ATOM   1313  CA  LYS   181       9.388 -25.628   3.153  1.00 39.16           C
ATOM   1314  CB  LYS   181       9.698 -26.162   1.750  1.00 39.22           C
ATOM   1315  CG  LYS   181      11.100 -25.853   1.233  1.00 39.32           C
ATOM   1316  CD  LYS   181      11.249 -26.210  -0.249  1.00 39.38           C
ATOM   1317  CE  LYS   181      10.400 -25.316  -1.159  1.00 39.68           C
ATOM   1318  NZ  LYS   181      10.813 -23.876  -1.134  1.00 39.91           N
ATOM   1319  C   LYS   181       9.498 -24.097   3.190  1.00 39.08           C
ATOM   1320  O   LYS   181      10.511 -23.552   3.641  1.00 39.00           O
ATOM   1321  N   ASP   182       8.452 -23.416   2.718  1.00 38.99           N
ATOM   1322  CA  ASP   182       8.389 -21.950   2.725  1.00 38.81           C
ATOM   1323  CB  ASP   182       7.118 -21.455   2.026  1.00 38.89           C
ATOM   1324  CG  ASP   182       7.026 -21.899   0.580  1.00 39.26           C
ATOM   1325  OD1 ASP   182       6.147 -22.737   0.273  1.00 39.26           O
ATOM   1326  OD2 ASP   182       7.824 -21.407  -0.247  1.00 39.73           O
ATOM   1327  C   ASP   182       8.411 -21.389   4.144  1.00 38.69           C
ATOM   1328  O   ASP   182       9.150 -20.437   4.436  1.00 38.60           O
ATOM   1329  N   ARG   183       7.595 -21.990   5.012  1.00 38.43           N
ATOM   1330  CA  ARG   183       7.393 -21.509   6.378  1.00 38.36           C
ATOM   1331  CB  ARG   183       6.173 -22.186   7.026  1.00 38.34           C
ATOM   1332  CG  ARG   183       4.839 -21.848   6.348  1.00 38.39           C
ATOM   1333  CD  ARG   183       3.694 -21.754   7.354  1.00 38.41           C
ATOM   1334  NE  ARG   183       3.094 -23.049   7.680  1.00 38.67           N
ATOM   1335  CZ  ARG   183       1.829 -23.379   7.422  1.00 39.68           C
ATOM   1336  NH1 ARG   183       1.012 -22.514   6.829  1.00 39.89           N
ATOM   1337  NH2 ARG   183       1.370 -24.578   7.761  1.00 39.79           N
ATOM   1338  C   ARG   183       8.639 -21.635   7.267  1.00 38.33           C
ATOM   1339  O   ARG   183       8.947 -20.713   8.021  1.00 38.18           O
ATOM   1340  N   ILE   184       9.344 -22.765   7.175  1.00 38.35           N
ATOM   1341  CA  ILE   184      10.594 -22.965   7.919  1.00 38.51           C
ATOM   1342  CB  ILE   184      11.162 -24.414   7.762  1.00 38.50           C
ATOM   1343  CG1 ILE   184      10.196 -25.457   8.335  1.00 38.68           C
ATOM   1345  CG2 ILE   184      12.500 -24.565   8.475  1.00 38.39           C
ATOM   1346  C   ILE   184      11.642 -21.919   7.502  1.00 38.64           C
ATOM   1347  O   ILE   184      12.329 -21.346   8.353  1.00 38.57           O
ATOM   1348  N   GLY   185      11.741 -21.665   6.197  1.00 38.67           N
ATOM   1349  CA  GLY   185      12.692 -20.695   5.659  1.00 38.79           C
ATOM   1350  C   GLY   185      12.403 -19.286   6.136  1.00 38.98           C
ATOM   1351  O   GLY   185      13.311 -18.556   6.524  1.00 39.10           O
ATOM   1352  N   THR   186      11.128 -18.912   6.104  1.00 39.16           N
ATOM   1353  CA  THR   186      10.660 -17.630   6.615  1.00 39.20           C
ATOM   1354  CB  THR   186       9.143 -17.451   6.317  1.00 39.34           C
ATOM   1355  OG1 THR   186       8.951 -17.312   4.904  1.00 39.99           O
ATOM   1356  CG2 THR   186       8.564 -16.223   7.010  1.00 39.73           C
ATOM   1357  C   THR   186      10.948 -17.491   8.116  1.00 38.96           C
ATOM   1358  O   THR   186      11.318 -16.411   8.582  1.00 39.21           O
ATOM   1359  N   ALA   187      10.805 -18.595   8.850  1.00 38.56           N
ATOM   1360  CA  ALA   187      10.900 -18.608  10.314  1.00 38.22           C
ATOM   1361  CB  ALA   187      10.521 -19.974  10.854  1.00 37.99           C
ATOM   1362  C   ALA   187      12.253 -18.166  10.877  1.00 38.12           C
ATOM   1363  O   ALA   187      12.298 -17.484  11.900  1.00 38.04           O
ATOM   1364  N   TYR   188      13.341 -18.550  10.209  1.00 38.01           N
ATOM   1365  CA  TYR   188      14.696 -18.176  10.632  1.00 37.85           C
ATOM   1366  CB  TYR   188      15.751 -18.811   9.721  1.00 37.48           C
ATOM   1367  CG  TYR   188      15.918 -20.306   9.862  1.00 37.38           C
ATOM   1368  CD1 TYR   188      15.657 -21.159   8.788  1.00 36.60           C
ATOM   1369  CE1 TYR   188      15.816 -22.536   8.905  1.00 36.75           C
ATOM   1370  CZ  TYR   188      16.244 -23.079  10.107  1.00 37.09           C
ATOM   1371  OH  TYR   188      16.399 -24.441  10.225  1.00 37.16           O
ATOM   1372  CE2 TYR   188      16.516 -22.258  11.191  1.00 37.20           C
ATOM   1373  CD2 TYR   188      16.357 -20.874  11.063  1.00 37.59           C
ATOM   1374  C   TYR   188      14.934 -16.664  10.664  1.00 37.94           C
ATOM   1375  O   TYR   188      15.634 -16.165  11.544  1.00 38.22           O
ATOM   1376  N   TYR   189      14.341 -15.943   9.714  1.00 37.90           N
ATOM   1377  CA  TYR   189      14.725 -14.554   9.442  1.00 37.75           C
ATOM   1378  CB  TYR   189      15.012 -14.377   7.942  1.00 37.83           C
ATOM   1379  CG  TYR   189      15.978 -15.403   7.401  1.00 38.55           C
ATOM   1380  CD1 TYR   189      17.361 -15.208   7.488  1.00 38.58           C
ATOM   1381  CE1 TYR   189      18.252 -16.161   7.002  1.00 38.67           C
ATOM   1382  CZ  TYR   189      17.760 -17.326   6.420  1.00 38.87           C
ATOM   1383  OH  TYR   189      18.633 -18.277   5.933  1.00 39.29           O
ATOM   1384  CE2 TYR   189      16.396 -17.544   6.325  1.00 38.57           C
ATOM   1385  CD2 TYR   189      15.514 -16.583   6.813  1.00 38.67           C
ATOM   1386  C   TYR   189      13.712 -13.511   9.918  1.00 37.50           C
ATOM   1387  O   TYR   189      14.003 -12.306   9.918  1.00 37.64           O
ATOM   1388  N   ILE   190      12.533 -13.971  10.323  1.00 37.02           N
ATOM   1389  CA  ILE   190      11.438 -13.075  10.691  1.00 36.88           C
ATOM   1390  CB  ILE   190      10.067 -13.819  10.680  1.00 36.67           C
ATOM   1391  CG1 ILE   190       8.903 -12.839  10.817  1.00 36.08           C
ATOM   1392  CD1 ILE   190       7.590 -13.391  10.272  1.00 35.62           C
ATOM   1393  CG2 ILE   190      10.009 -14.933  11.735  1.00 36.63           C
ATOM   1394  C   ILE   190      11.708 -12.361  12.019  1.00 37.11           C
ATOM   1395  O   ILE   190      12.157 -12.982  12.983  1.00 37.09           O
ATOM   1396  N   ALA   191      11.458 -11.052  12.043  1.00 37.29           N
ATOM   1397  CA  ALA   191      11.612 -10.233  13.249  1.00 37.76           C
ATOM   1398  CB  ALA   191      11.666  -8.750  12.883  1.00 37.44           C
ATOM   1399  C   ALA   191      10.484 -10.494  14.243  1.00 38.09           C
ATOM   1400  O   ALA   191       9.365 -10.810  13.835  1.00 38.61           O
ATOM   1401  N   PRO   192      10.761 -10.339  15.553  1.00 38.50           N
ATOM   1402  CA  PRO   192       9.735 -10.586  16.573  1.00 38.60           C
ATOM   1403  CB  PRO   192      10.441 -10.223  17.886  1.00 38.52           C
ATOM   1404  CG  PRO   192      11.892 -10.355  17.591  1.00 38.67           C
ATOM   1405  CD  PRO   192      12.044  -9.932  16.158  1.00 38.56           C
ATOM   1406  C   PRO   192       8.454  -9.758  16.393  1.00 38.87           C
ATOM   1407  O   PRO   192       7.364 -10.290  16.607  1.00 39.53           O
ATOM   1408  N   GLU   193       8.573  -8.489  15.995  1.00 39.06           N
ATOM   1409  CA  GLU   193       7.399  -7.617  15.799  1.00 39.15           C
ATOM   1410  CB  GLU   193       7.768  -6.196  15.349  1.00 39.40           C
ATOM   1411  CG  GLU   193       9.014  -5.606  15.910  1.00 40.73           C
ATOM   1412  CD  GLU   193      10.248  -5.958  15.106  1.00 41.29           C
ATOM   1413  OE1 GLU   193      11.119  -6.630  15.676  1.00 41.60           O
ATOM   1414  OE2 GLU   193      10.351  -5.569  13.921  1.00 42.28           O
ATOM   1415  C   GLU   193       6.483  -8.160  14.730  1.00 38.99           C
ATOM   1416  O   GLU   193       5.266  -8.009  14.826  1.00 39.34           O
ATOM   1417  N   VAL   194       7.076  -8.742  13.688  1.00 38.93           N
ATOM   1418  CA  VAL   194       6.317  -9.243  12.543  1.00 38.97           C
ATOM   1419  CB  VAL   194       7.230  -9.658  11.361  1.00 38.93           C
ATOM   1420  CG1 VAL   194       6.407 -10.114  10.161  1.00 38.01           C
ATOM   1421  CG2 VAL   194       8.112  -8.499  10.951  1.00 39.04           C
ATOM   1422  C   VAL   194       5.391 -10.372  12.984  1.00 39.06           C
ATOM   1423  O   VAL   194       4.275 -10.478  12.490  1.00 39.13           O
ATOM   1424  N   LEU   195       5.848 -11.182  13.940  1.00 39.54           N
ATOM   1425  CA  LEU   195       5.001 -12.204  14.569  1.00 39.81           C
ATOM   1426  CB  LEU   195       5.820 -13.148  15.449  1.00 39.85           C
ATOM   1427  CG  LEU   195       6.984 -13.902  14.803  1.00 40.14           C
ATOM   1428  CD1 LEU   195       7.819 -14.597  15.871  1.00 39.60           C
ATOM   1429  CD2 LEU   195       6.480 -14.898  13.758  1.00 40.10           C
ATOM   1430  C   LEU   195       3.896 -11.570  15.396  1.00 40.01           C
ATOM   1431  O   LEU   195       2.747 -11.994  15.311  1.00 40.62           O
ATOM   1432  N   ARG   196       4.239 -10.551  16.187  1.00 40.17           N
ATOM   1433  CA  ARG   196       3.248  -9.844  17.020  1.00 40.09           C
ATOM   1434  CB  ARG   196       3.927  -8.933  18.055  1.00 40.28           C
ATOM   1435  CG  ARG   196       4.812  -9.650  19.082  1.00 40.42           C
ATOM   1436  CD  ARG   196       5.222  -8.721  20.235  1.00 40.22           C
ATOM   1437  NE  ARG   196       5.908  -7.507  19.783  0.50 40.39           N
ATOM   1438  CZ  ARG   196       7.229  -7.335  19.773  0.50 40.68           C
ATOM   1439  NH1 ARG   196       8.044  -8.298  20.191  0.50 40.57           N
ATOM   1440  NH2 ARG   196       7.741  -6.188  19.342  0.50 40.87           N
ATOM   1441  C   ARG   196       2.228  -9.043  16.194  1.00 39.80           C
ATOM   1442  O   ARG   196       1.225  -8.565  16.731  1.00 39.73           O
ATOM   1443  N   GLY   197       2.492  -8.888  14.896  1.00 39.59           N
ATOM   1444  CA  GLY   197       1.502  -8.318  13.971  1.00 38.99           C
ATOM   1445  C   GLY   197       1.788  -6.938  13.398  1.00 38.83           C
ATOM   1446  O   GLY   197       0.897  -6.308  12.819  1.00 38.70           O
ATOM   1447  N   THR   198       3.017  -6.453  13.558  1.00 38.52           N
ATOM   1448  CA  THR   198       3.406  -5.169  12.975  1.00 38.47           C
ATOM   1449  CB  THR   198       3.360  -3.979  13.986  1.00 38.47           C
ATOM   1450  OG1 THR   198       4.479  -4.052  14.877  1.00 39.33           O
ATOM   1451  CG2 THR   198       2.055  -3.949  14.787  1.00 38.74           C
ATOM   1452  C   THR   198       4.805  -5.254  12.387  1.00 38.23           C
ATOM   1453  O   THR   198       5.608  -6.104  12.777  1.00 38.18           O
ATOM   1454  N   TYR   199       5.080  -4.364  11.443  1.00 37.74           N
ATOM   1455  CA  TYR   199       6.381  -4.265  10.814  1.00 37.25           C
ATOM   1456  CB  TYR   199       6.467  -5.198   9.596  1.00 36.96           C
ATOM   1457  CG  TYR   199       5.760  -4.689   8.342  1.00 36.09           C
ATOM   1458  CD1 TYR   199       4.441  -5.042   8.068  1.00 35.65           C
ATOM   1459  CE1 TYR   199       3.795  -4.577   6.927  1.00 36.00           C
ATOM   1460  CZ  TYR   199       4.479  -3.751   6.041  1.00 36.12           C
ATOM   1461  OH  TYR   199       3.858  -3.287   4.903  1.00 35.49           O
ATOM   1462  CE2 TYR   199       5.792  -3.390   6.296  1.00 35.39           C
ATOM   1463  CD2 TYR   199       6.420  -3.858   7.434  1.00 35.67           C
ATOM   1464  C   TYR   199       6.609  -2.822  10.392  1.00 37.31           C
ATOM   1465  O   TYR   199       5.659  -2.077  10.154  1.00 37.34           O
ATOM   1466  N   ASP   200       7.875  -2.437  10.326  1.00 37.58           N
ATOM   1467  CA  ASP   200       8.303  -1.216   9.660  1.00 37.84           C
ATOM   1468  CB  ASP   200       8.379  -0.026  10.642  1.00 37.99           C
ATOM   1469  CG  ASP   200       9.367  -0.250  11.791  1.00 38.44           C
ATOM   1470  OD1 ASP   200      10.121  -1.243  11.773  1.00 39.06           O
ATOM   1471  OD2 ASP   200       9.389   0.581  12.720  1.00 38.97           O
ATOM   1472  C   ASP   200       9.643  -1.551   9.003  1.00 37.79           C
ATOM   1473  O   ASP   200       9.937  -2.725   8.796  1.00 37.94           O
ATOM   1474  N   GLU   201      10.452  -0.544   8.685  1.00 37.98           N
ATOM   1475  CA  GLU   201      11.746  -0.763   8.029  1.00 38.11           C
ATOM   1476  CB  GLU   201      12.453   0.568   7.745  1.00 37.92           C
ATOM   1477  CG  GLU   201      11.551   1.782   7.736  1.00 39.38           C
ATOM   1478  CD  GLU   201      11.419   2.415   9.105  1.00 40.05           C
ATOM   1479  OE1 GLU   201      12.459   2.786   9.695  1.00 40.01           O
ATOM   1480  OE2 GLU   201      10.275   2.549   9.581  1.00 39.78           O
ATOM   1481  C   GLU   201      12.681  -1.649   8.858  1.00 37.99           C
ATOM   1482  O   GLU   201      13.502  -2.385   8.308  1.00 38.38           O
ATOM   1483  N   LYS   202      12.551  -1.569  10.179  1.00 37.92           N
ATOM   1484  CA  LYS   202      13.461  -2.245  11.100  1.00 37.83           C
ATOM   1485  CB  LYS   202      13.204  -1.789  12.544  1.00 37.68           C
ATOM   1486  CG  LYS   202      13.509  -0.308  12.816  1.00 37.08           C
ATOM   1487  CD  LYS   202      15.016  -0.031  12.840  1.00 36.55           C
ATOM   1488  CE  LYS   202      15.312   1.456  12.917  1.00 35.99           C
ATOM   1489  NZ  LYS   202      15.267   1.965  14.309  1.00 35.74           N
ATOM   1490  C   LYS   202      13.438  -3.772  11.001  1.00 38.01           C
ATOM   1491  O   LYS   202      14.342  -4.437  11.502  1.00 38.58           O
ATOM   1492  N   CYS   203      12.420  -4.335  10.356  1.00 38.11           N
ATOM   1493  CA  CYS   203      12.345  -5.790  10.224  1.00 38.04           C
ATOM   1494  CB  CYS   203      10.905  -6.275   9.987  1.00 37.71           C
ATOM   1495  SG  CYS   203      10.220  -6.068   8.318  1.00 39.04           S
ATOM   1496  C   CYS   203      13.315  -6.285   9.150  1.00 37.79           C
ATOM   1497  O   CYS   203      13.733  -7.443   9.174  1.00 37.79           O
ATOM   1498  N   ASP   204      13.680  -5.397   8.224  1.00 37.43           N
ATOM   1499  CA  ASP   204      14.686  -5.713   7.206  1.00 37.34           C
ATOM   1500  CB  ASP   204      14.642  -4.718   6.041  1.00 37.02           C
ATOM   1501  CG  ASP   204      13.502  -4.987   5.061  1.00 37.07           C
ATOM   1502  OD1 ASP   204      12.889  -6.086   5.074  1.00 36.17           O
ATOM   1503  OD2 ASP   204      13.222  -4.074   4.258  1.00 37.74           O
ATOM   1504  C   ASP   204      16.088  -5.732   7.807  1.00 37.19           C
ATOM   1505  O   ASP   204      16.945  -6.469   7.345  1.00 37.44           O
ATOM   1506  N   VAL   205      16.315  -4.913   8.830  1.00 37.21           N
ATOM   1507  CA  VAL   205      17.605  -4.876   9.512  1.00 37.01           C
ATOM   1508  CB  VAL   205      17.812  -3.561  10.326  1.00 37.10           C
ATOM   1509  CG1 VAL   205      19.024  -3.665  11.250  1.00 36.49           C
ATOM   1510  CG2 VAL   205      17.967  -2.362   9.386  1.00 36.12           C
ATOM   1511  C   VAL   205      17.773  -6.115  10.386  1.00 37.14           C
ATOM   1512  O   VAL   205      18.871  -6.674  10.467  1.00 37.29           O
ATOM   1513  N   TRP   206      16.689  -6.550  11.026  1.00 36.96           N
ATOM   1514  CA  TRP   206      16.715  -7.788  11.803  1.00 36.69           C
ATOM   1515  CB  TRP   206      15.363  -8.059  12.465  1.00 36.43           C
ATOM   1516  CG  TRP   206      15.296  -9.379  13.209  1.00 36.43           C
ATOM   1517  CD1 TRP   206      15.077 -10.617  12.669  1.00 36.64           C
ATOM   1518  NE1 TRP   206      15.086 -11.579  13.657  1.00 36.52           N
ATOM   1519  CE2 TRP   206      15.299 -10.968  14.864  1.00 36.03           C
ATOM   1520  CD2 TRP   206      15.441  -9.582  14.622  1.00 35.58           C
ATOM   1521  CE3 TRP   206      15.676  -8.727  15.705  1.00 35.05           C
ATOM   1522  CZ3 TRP   206      15.758  -9.272  16.978  1.00 35.89           C
ATOM   1523  CH2 TRP   206      15.617 -10.658  17.186  1.00 36.23           C
ATOM   1524  CZ2 TRP   206      15.387 -11.517  16.144  1.00 35.60           C
ATOM   1525  C   TRP   206      17.088  -8.948  10.891  1.00 36.91           C
ATOM   1526  O   TRP   206      18.028  -9.705  11.184  1.00 37.29           O
ATOM   1527  N   SER   207      16.360  -9.070   9.780  1.00 36.66           N
ATOM   1528  CA  SER   207      16.571 -10.153   8.836  1.00 36.59           C
ATOM   1529  CB  SER   207      15.553 -10.081   7.700  1.00 36.62           C
ATOM   1530  OG  SER   207      14.231 -10.092   8.219  1.00 36.87           O
ATOM   1531  C   SER   207      18.006 -10.171   8.309  1.00 36.77           C
ATOM   1532  O   SER   207      18.640 -11.230   8.285  1.00 37.17           O
ATOM   1533  N   ALA   208      18.528  -9.007   7.916  1.00 36.58           N
ATOM   1534  CA  ALA   208      19.937  -8.890   7.489  1.00 36.35           C
ATOM   1535  CB  ALA   208      20.236  -7.483   6.998  1.00 36.28           C
ATOM   1536  C   ALA   208      20.924  -9.287   8.591  1.00 36.13           C
ATOM   1537  O   ALA   208      21.998  -9.822   8.307  1.00 36.25           O
ATOM   1538  N   GLY   209      20.558  -9.012   9.841  1.00 35.92           N
ATOM   1539  CA  GLY   209      21.357  -9.416  10.995  1.00 36.05           C
ATOM   1540  C   GLY   209      21.459 -10.926  11.115  1.00 36.18           C
ATOM   1541  O   GLY   209      22.536 -11.455  11.370  1.00 36.56           O
ATOM   1542  N   VAL   210      20.335 -11.613  10.922  1.00 36.06           N
ATOM   1543  CA  VAL   210      20.295 -13.074  10.939  1.00 36.00           C
ATOM   1544  CB  VAL   210      18.834 -13.609  10.814  1.00 36.00           C
ATOM   1545  CG1 VAL   210      18.811 -15.120  10.614  1.00 35.47           C
ATOM   1546  CG2 VAL   210      18.018 -13.221  12.040  1.00 35.53           C
ATOM   1547  C   VAL   210      21.173 -13.628   9.822  1.00 36.19           C
ATOM   1548  O   VAL   210      21.987 -14.536  10.057  1.00 36.53           O
ATOM   1549  N   ILE   211      21.020 -13.069   8.619  1.00 36.01           N
ATOM   1550  CA  ILE   211      21.868 -13.435   7.478  1.00 35.89           C
ATOM   1551  CB  ILE   211      21.524 -12.638   6.186  1.00 35.69           C
ATOM   1552  CG1 ILE   211      20.063 -12.873   5.784  1.00 35.66           C
ATOM   1553  CD1 ILE   211      19.590 -12.062   4.583  1.00 35.85           C
ATOM   1554  CG2 ILE   211      22.456 -13.049   5.043  1.00 35.09           C
ATOM   1555  C   ILE   211      23.342 -13.247   7.826  1.00 36.02           C
ATOM   1556  O   ILE   211      24.158 -14.132   7.568  1.00 36.24           O
ATOM   1557  N   LEU   212      23.675 -12.104   8.422  1.00 35.97           N
ATOM   1558  CA  LEU   212      25.061 -11.820   8.775  1.00 36.26           C
ATOM   1559  CB  LEU   212      25.219 -10.398   9.325  1.00 36.17           C
ATOM   1560  CG  LEU   212      26.638  -9.963   9.710  1.00 36.17           C
ATOM   1561  CD1 LEU   212      27.666 -10.214   8.577  1.00 36.07           C
ATOM   1562  CD2 LEU   212      26.647  -8.510  10.148  1.00 36.05           C
ATOM   1563  C   LEU   212      25.583 -12.846   9.768  1.00 36.39           C
ATOM   1564  O   LEU   212      26.694 -13.347   9.621  1.00 36.50           O
ATOM   1565  N   TYR   213      24.763 -13.160  10.766  1.00 36.87           N
ATOM   1566  CA  TYR   213      25.083 -14.189  11.747  1.00 37.27           C
ATOM   1567  CB  TYR   213      23.921 -14.335  12.735  1.00 37.32           C
ATOM   1568  CG  TYR   213      24.184 -15.220  13.941  1.00 37.38           C
ATOM   1569  CD1 TYR   213      24.279 -14.675  15.220  1.00 36.88           C
ATOM   1570  CE1 TYR   213      24.505 -15.484  16.330  1.00 37.09           C
ATOM   1571  CZ  TYR   213      24.638 -16.857  16.164  1.00 37.13           C
ATOM   1572  OH  TYR   213      24.861 -17.671  17.250  1.00 37.08           O
ATOM   1573  CE2 TYR   213      24.548 -17.419  14.903  1.00 37.36           C
ATOM   1574  CD2 TYR   213      24.316 -16.603  13.805  1.00 37.28           C
ATOM   1575  C   TYR   213      25.393 -15.521  11.050  1.00 37.40           C
ATOM   1576  O   TYR   213      26.323 -16.221  11.440  1.00 37.80           O
ATOM   1577  N   ILE   214      24.628 -15.852  10.011  1.00 37.69           N
ATOM   1578  CA  ILE   214      24.836 -17.092   9.253  1.00 37.78           C
ATOM   1579  CB  ILE   214      23.598 -17.475   8.400  1.00 37.93           C
ATOM   1580  CG1 ILE   214      22.410 -17.816   9.317  1.00 37.51           C
ATOM   1581  CD1 ILE   214      21.063 -17.800   8.631  1.00 37.10           C
ATOM   1582  CG2 ILE   214      23.915 -18.662   7.481  1.00 37.73           C
ATOM   1583  C   ILE   214      26.102 -17.048   8.398  1.00 37.97           C
ATOM   1584  O   ILE   214      26.851 -18.027   8.348  1.00 37.97           O
ATOM   1585  N   LEU   215      26.357 -15.913   7.749  1.00 38.19           N
ATOM   1586  CA  LEU   215      27.560 -15.759   6.919  1.00 38.35           C
ATOM   1587  CB  LEU   215      27.666 -14.342   6.335  1.00 38.20           C
ATOM   1588  CG  LEU   215      26.618 -13.900   5.297  1.00 38.04           C
ATOM   1589  CD1 LEU   215      26.883 -12.481   4.823  1.00 37.26           C
ATOM   1590  CD2 LEU   215      26.569 -14.840   4.109  1.00 37.70           C
ATOM   1591  C   LEU   215      28.826 -16.105   7.690  1.00 38.58           C
ATOM   1592  O   LEU   215      29.728 -16.750   7.157  1.00 38.72           O
ATOM   1593  N   LEU   216      28.869 -15.699   8.955  1.00 38.99           N
ATOM   1594  CA  LEU   216      30.064 -15.848   9.780  1.00 39.33           C
ATOM   1595  CB  LEU   216      30.159 -14.705  10.800  1.00 39.43           C
ATOM   1596  CG  LEU   216      30.218 -13.268  10.275  1.00 39.31           C
ATOM   1597  CD1 LEU   216      30.029 -12.288  11.420  1.00 39.01           C
ATOM   1598  CD2 LEU   216      31.537 -13.006   9.549  1.00 39.26           C
ATOM   1599  C   LEU   216      30.167 -17.191  10.497  1.00 39.54           C
ATOM   1600  O   LEU   216      31.263 -17.739  10.615  1.00 39.71           O
ATOM   1601  N   SER   217      29.039 -17.714  10.983  1.00 39.73           N
ATOM   1602  CA  SER   217      29.045 -18.953  11.781  1.00 39.59           C
ATOM   1603  CB  SER   217      28.218 -18.780  13.060  1.00 39.57           C
ATOM   1604  OG  SER   217      26.829 -18.728  12.770  1.00 39.90           O
ATOM   1605  C   SER   217      28.562 -20.190  11.022  1.00 39.53           C
ATOM   1606  O   SER   217      28.912 -21.315  11.382  1.00 39.72           O
ATOM   1607  N   GLY   218      27.752 -19.979   9.985  1.00 39.30           N
ATOM   1608  CA  GLY   218      27.160 -21.079   9.224  1.00 39.01           C
ATOM   1609  C   GLY   218      26.030 -21.725   9.997  1.00 38.80           C
ATOM   1610  O   GLY   218      25.651 -22.864   9.720  1.00 38.68           O
ATOM   1611  N   THR   219      25.492 -20.969  10.954  1.00 38.69           N
ATOM   1612  CA  THR   219      24.509 -21.442  11.928  1.00 38.70           C
ATOM   1613  CB  THR   219      25.218 -21.849  13.256  1.00 38.61           C
ATOM   1614  OG1 THR   219      25.629 -23.216  13.167  1.00 39.25           O
ATOM   1615  CG2 THR   219      24.319 -21.690  14.477  1.00 39.27           C
ATOM   1616  C   THR   219      23.464 -20.348  12.175  1.00 38.45           C
ATOM   1617  O   THR   219      23.823 -19.182  12.307  1.00 38.52           O
ATOM   1618  N   PRO   220      22.167 -20.723  12.219  1.00 38.37           N
ATOM   1619  CA  PRO   220      21.089 -19.784  12.566  1.00 38.06           C
ATOM   1620  CB  PRO   220      19.812 -20.620  12.402  1.00 37.90           C
ATOM   1621  CG  PRO   220      20.201 -21.837  11.670  1.00 38.15           C
ATOM   1622  CD  PRO   220      21.650 -22.076  11.937  1.00 38.42           C
ATOM   1623  C   PRO   220      21.184 -19.313  14.016  1.00 37.85           C
ATOM   1624  O   PRO   220      21.410 -20.133  14.913  1.00 37.87           O
ATOM   1625  N   PRO   221      21.020 -18.000  14.249  1.00 37.63           N
ATOM   1626  CA  PRO   221      20.913 -17.483  15.614  1.00 37.53           C
ATOM   1627  CB  PRO   221      20.721 -15.971  15.414  1.00 37.54           C
ATOM   1628  CG  PRO   221      20.311 -15.800  13.984  1.00 37.26           C
ATOM   1629  CD  PRO   221      20.942 -16.931  13.236  1.00 37.51           C
ATOM   1630  C   PRO   221      19.707 -18.081  16.334  1.00 37.84           C
ATOM   1631  O   PRO   221      19.788 -18.374  17.529  1.00 38.10           O
ATOM   1632  N   PHE   222      18.609 -18.266  15.600  1.00 37.67           N
ATOM   1633  CA  PHE   222      17.393 -18.866  16.127  1.00 37.75           C
ATOM   1634  CB  PHE   222      16.217 -17.882  16.008  1.00 37.80           C
ATOM   1635  CG  PHE   222      16.524 -16.532  16.590  1.00 37.77           C
ATOM   1636  CD1 PHE   222      16.941 -15.487  15.770  1.00 37.48           C
ATOM   1637  CE1 PHE   222      17.263 -14.250  16.313  1.00 37.79           C
ATOM   1638  CZ  PHE   222      17.179 -14.050  17.692  1.00 38.18           C
ATOM   1639  CE2 PHE   222      16.773 -15.092  18.522  1.00 37.76           C
ATOM   1640  CD2 PHE   222      16.458 -16.324  17.969  1.00 37.41           C
ATOM   1641  C   PHE   222      17.122 -20.178  15.404  1.00 37.76           C
ATOM   1642  O   PHE   222      16.789 -20.192  14.218  1.00 37.61           O
ATOM   1643  N   TYR   223      17.271 -21.274  16.143  1.00 37.84           N
ATOM   1644  CA  TYR   223      17.334 -22.616  15.574  1.00 37.98           C
ATOM   1645  CB  TYR   223      18.695 -23.239  15.903  1.00 37.91           C
ATOM   1646  CG  TYR   223      19.077 -23.213  17.372  1.00 38.04           C
ATOM   1647  CD1 TYR   223      18.635 -24.205  18.252  1.00 38.15           C
ATOM   1648  CE1 TYR   223      18.997 -24.186  19.600  1.00 37.91           C
ATOM   1649  CZ  TYR   223      19.814 -23.170  20.073  1.00 38.01           C
ATOM   1650  OH  TYR   223      20.180 -23.142  21.400  1.00 38.38           O
ATOM   1651  CE2 TYR   223      20.268 -22.179  19.220  1.00 37.76           C
ATOM   1652  CD2 TYR   223      19.902 -22.207  17.877  1.00 38.29           C
ATOM   1653  C   TYR   223      16.207 -23.546  16.037  1.00 38.10           C
ATOM   1654  O   TYR   223      15.464 -23.220  16.965  1.00 38.35           O
ATOM   1655  N   GLY   224      16.105 -24.711  15.395  1.00 38.08           N
ATOM   1656  CA  GLY   224      15.075 -25.696  15.712  1.00 38.24           C
ATOM   1657  C   GLY   224      14.800 -26.708  14.609  1.00 38.49           C
ATOM   1658  O   GLY   224      15.005 -26.430  13.425  1.00 38.44           O
ATOM   1659  N   LYS   225      14.318 -27.885  15.010  1.00 38.73           N
ATOM   1660  CA  LYS   225      14.047 -28.994  14.093  1.00 38.85           C
ATOM   1661  CB  LYS   225      14.081 -30.328  14.848  1.00 38.78           C
ATOM   1666  C   LYS   225      12.721 -28.846  13.333  1.00 38.88           C
ATOM   1667  O   LYS   225      12.411 -29.651  12.447  1.00 38.93           O
ATOM   1668  N   ASN   226      11.941 -27.826  13.688  1.00 38.80           N
ATOM   1669  CA  ASN   226      10.677 -27.533  13.006  1.00 38.66           C
ATOM   1670  CB  ASN   226       9.528 -28.393  13.562  1.00 38.54           C
ATOM   1671  CG  ASN   226       9.294 -28.180  15.052  1.00 38.57           C
ATOM   1672  OD1 ASN   226       9.191 -27.047  15.530  1.00 37.97           O
ATOM   1673  ND2 ASN   226       9.189 -29.281  15.792  1.00 38.45           N
ATOM   1674  C   ASN   226      10.319 -26.056  13.073  1.00 38.55           C
ATOM   1675  O   ASN   226      10.945 -25.296  13.811  1.00 38.60           O
ATOM   1676  N   GLU   227       9.301 -25.665  12.309  1.00 38.50           N
ATOM   1677  CA  GLU   227       8.824 -24.282  12.271  1.00 38.28           C
ATOM   1678  CB  GLU   227       7.601 -24.161  11.357  1.00 38.37           C
ATOM   1679  CG  GLU   227       7.245 -22.721  11.018  1.00 38.89           C
ATOM   1680  CD  GLU   227       5.787 -22.521  10.617  1.00 39.55           C
ATOM   1681  OE1 GLU   227       5.432 -21.363  10.311  1.00 39.16           O
ATOM   1682  OE2 GLU   227       5.001 -23.500  10.611  1.00 40.40           O
ATOM   1683  C   GLU   227       8.483 -23.730  13.658  1.00 38.05           C
ATOM   1684  O   GLU   227       8.889 -22.616  14.004  1.00 38.10           O
ATOM   1685  N   TYR   228       7.730 -24.508  14.437  1.00 37.68           N
ATOM   1686  CA  TYR   228       7.290 -24.085  15.765  1.00 37.17           C
ATOM   1687  CB  TYR   228       6.419 -25.161  16.414  1.00 36.93           C
ATOM   1688  CG  TYR   228       5.981 -24.831  17.826  1.00 36.71           C
ATOM   1689  CD1 TYR   228       4.913 -23.959  18.062  1.00 36.21           C
ATOM   1690  CE1 TYR   228       4.504 -23.654  19.356  1.00 35.79           C
ATOM   1691  CZ  TYR   228       5.159 -24.231  20.434  1.00 36.67           C
ATOM   1692  OH  TYR   228       4.757 -23.934  21.717  1.00 36.85           O
ATOM   1693  CE2 TYR   228       6.223 -25.102  20.230  1.00 36.60           C
ATOM   1694  CD2 TYR   228       6.627 -25.396  18.928  1.00 36.59           C
ATOM   1695  C   TYR   228       8.456 -23.723  16.684  1.00 37.01           C
ATOM   1696  O   TYR   228       8.450 -22.653  17.298  1.00 36.92           O
ATOM   1697  N   ASP   229       9.444 -24.616  16.766  1.00 36.82           N
ATOM   1698  CA  ASP   229      10.586 -24.453  17.668  1.00 36.71           C
ATOM   1699  CB  ASP   229      11.474 -25.697  17.646  1.00 36.74           C
ATOM   1700  CG  ASP   229      10.900 -26.848  18.458  1.00 36.74           C
ATOM   1701  OD1 ASP   229       9.786 -26.725  19.013  1.00 36.28           O
ATOM   1702  OD2 ASP   229      11.581 -27.886  18.551  1.00 37.23           O
ATOM   1703  C   ASP   229      11.416 -23.219  17.351  1.00 36.73           C
ATOM   1704  O   ASP   229      11.839 -22.503  18.261  1.00 36.65           O
ATOM   1705  N   ILE   230      11.642 -22.981  16.061  1.00 36.74           N
ATOM   1706  CA  ILE   230      12.366 -21.802  15.598  1.00 36.94           C
ATOM   1707  CB  ILE   230      12.530 -21.795  14.061  1.00 37.02           C
ATOM   1708  CG1 ILE   230      13.388 -22.985  13.614  1.00 37.06           C
ATOM   1709  CD1 ILE   230      13.156 -23.401  12.161  1.00 37.72           C
ATOM   1710  CG2 ILE   230      13.139 -20.470  13.590  1.00 36.88           C
ATOM   1711  C   ILE   230      11.635 -20.538  16.032  1.00 36.99           C
ATOM   1712  O   ILE   230      12.246 -19.627  16.599  1.00 36.78           O
ATOM   1713  N   LEU   231      10.325 -20.504  15.784  1.00 37.16           N
ATOM   1714  CA  LEU   231       9.511 -19.311  16.047  1.00 37.26           C
ATOM   1715  CB  LEU   231       8.113 -19.446  15.433  1.00 37.04           C
ATOM   1716  CG  LEU   231       8.033 -19.409  13.902  1.00 36.84           C
ATOM   1717  CD1 LEU   231       6.616 -19.620  13.428  1.00 36.22           C
ATOM   1718  CD2 LEU   231       8.588 -18.108  13.342  1.00 37.39           C
ATOM   1719  C   LEU   231       9.424 -18.963  17.531  1.00 37.47           C
ATOM   1720  O   LEU   231       9.308 -17.791  17.883  1.00 37.55           O
ATOM   1721  N   LYS   232       9.494 -19.983  18.386  1.00 37.63           N
ATOM   1722  CA  LYS   232       9.508 -19.794  19.839  1.00 37.84           C
ATOM   1723  CB  LYS   232       9.348 -21.134  20.557  1.00 37.91           C
ATOM   1724  CG  LYS   232       7.969 -21.772  20.419  1.00 38.77           C
ATOM   1725  CD  LYS   232       7.144 -21.694  21.710  1.00 41.10           C
ATOM   1726  CE  LYS   232       6.538 -20.315  21.972  1.00 42.57           C
ATOM   1727  NZ  LYS   232       5.640 -19.825  20.879  1.00 43.95           N
ATOM   1728  C   LYS   232      10.785 -19.100  20.313  1.00 37.87           C
ATOM   1729  O   LYS   232      10.742 -18.284  21.233  1.00 38.04           O
ATOM   1730  N   ARG   233      11.914 -19.425  19.684  1.00 37.78           N
ATOM   1731  CA  ARG   233      13.189 -18.790  20.013  1.00 37.73           C
ATOM   1732  CB  ARG   233      14.372 -19.622  19.514  1.00 37.75           C
ATOM   1733  CG  ARG   233      14.723 -20.779  20.434  1.00 37.93           C
ATOM   1734  CD  ARG   233      15.958 -21.532  19.964  1.00 38.50           C
ATOM   1735  NE  ARG   233      16.307 -22.611  20.892  1.00 40.42           N
ATOM   1736  CZ  ARG   233      15.689 -23.793  20.954  1.00 40.76           C
ATOM   1737  NH1 ARG   233      16.086 -24.698  21.838  1.00 41.16           N
ATOM   1738  NH2 ARG   233      14.674 -24.077  20.140  1.00 40.70           N
ATOM   1739  C   ARG   233      13.269 -17.363  19.482  1.00 37.72           C
ATOM   1740  O   ARG   233      13.817 -16.482  20.149  1.00 37.82           O
ATOM   1741  N   VAL   234      12.728 -17.140  18.285  1.00 37.49           N
ATOM   1742  CA  VAL   234      12.622 -15.790  17.723  1.00 37.57           C
ATOM   1743  CB  VAL   234      11.967 -15.789  16.308  1.00 37.51           C
ATOM   1744  CG1 VAL   234      11.822 -14.371  15.789  1.00 37.59           C
ATOM   1745  CG2 VAL   234      12.790 -16.605  15.326  1.00 37.38           C
ATOM   1746  C   VAL   234      11.807 -14.908  18.673  1.00 37.59           C
ATOM   1747  O   VAL   234      12.203 -13.789  19.003  1.00 37.67           O
ATOM   1748  N   GLU   235      10.680 -15.447  19.122  1.00 37.49           N
ATOM   1749  CA  GLU   235       9.755 -14.767  20.020  1.00 37.61           C
ATOM   1750  CB  GLU   235       8.643 -15.737  20.399  1.00 37.30           C
ATOM   1751  CG  GLU   235       7.437 -15.103  21.025  1.00 37.36           C
ATOM   1752  CD  GLU   235       6.330 -16.103  21.226  1.00 37.27           C
ATOM   1753  OE1 GLU   235       6.567 -17.130  21.897  1.00 37.92           O
ATOM   1754  OE2 GLU   235       5.226 -15.868  20.703  1.00 37.53           O
ATOM   1755  C   GLU   235      10.428 -14.224  21.284  1.00 37.67           C
ATOM   1756  O   GLU   235      10.114 -13.119  21.735  1.00 37.71           O
ATOM   1757  N   THR   236      11.344 -15.009  21.847  1.00 37.60           N
ATOM   1758  CA  THR   236      12.078 -14.627  23.049  1.00 37.73           C
ATOM   1759  CB  THR   236      12.667 -15.871  23.755  1.00 37.87           C
ATOM   1760  OG1 THR   236      11.644 -16.866  23.897  1.00 38.30           O
ATOM   1761  CG2 THR   236      13.196 -15.521  25.139  1.00 38.37           C
ATOM   1762  C   THR   236      13.181 -13.617  22.712  1.00 37.60           C
ATOM   1763  O   THR   236      13.539 -12.774  23.536  1.00 37.46           O
ATOM   1764  N   GLY   237      13.705 -13.705  21.492  1.00 37.51           N
ATOM   1765  CA  GLY   237      14.756 -12.810  21.035  1.00 37.46           C
ATOM   1766  C   GLY   237      16.128 -13.138  21.594  1.00 37.52           C
ATOM   1767  O   GLY   237      17.071 -12.373  21.410  1.00 37.63           O
ATOM   1768  N   LYS   238      16.245 -14.277  22.270  1.00 37.54           N
ATOM   1769  CA  LYS   238      17.502 -14.660  22.916  1.00 37.42           C
ATOM   1770  CB  LYS   238      17.254 -15.338  24.273  1.00 37.27           C
ATOM   1771  CG  LYS   238      16.883 -14.370  25.389  1.00 37.23           C
ATOM   1772  CD  LYS   238      16.542 -15.100  26.683  1.00 37.37           C
ATOM   1775  C   LYS   238      18.371 -15.533  22.012  1.00 37.37           C
ATOM   1776  O   LYS   238      17.919 -16.539  21.456  1.00 37.31           O
ATOM   1777  N   TYR   239      19.623 -15.119  21.869  1.00 37.27           N
ATOM   1778  CA  TYR   239      20.594 -15.825  21.053  1.00 37.31           C
ATOM   1779  CB  TYR   239      20.593 -15.267  19.623  1.00 37.06           C
ATOM   1780  CG  TYR   239      21.088 -13.847  19.525  1.00 37.03           C
ATOM   1781  CD1 TYR   239      22.396 -13.580  19.131  1.00 36.53           C
ATOM   1782  CE1 TYR   239      22.864 -12.289  19.048  1.00 36.42           C
ATOM   1783  CZ  TYR   239      22.028 -11.238  19.358  1.00 36.81           C
ATOM   1784  OH  TYR   239      22.514  -9.956  19.267  1.00 37.64           O
ATOM   1785  CE2 TYR   239      20.719 -11.466  19.759  1.00 36.69           C
ATOM   1786  CD2 TYR   239      20.257 -12.769  19.840  1.00 36.65           C
ATOM   1787  C   TYR   239      21.962 -15.679  21.718  1.00 37.41           C
ATOM   1788  O   TYR   239      22.113 -14.902  22.664  1.00 37.27           O
ATOM   1789  N   ALA   240      22.951 -16.421  21.226  1.00 37.63           N
ATOM   1790  CA  ALA   240      24.266 -16.451  21.861  1.00 37.85           C
ATOM   1791  CB  ALA   240      24.377 -17.668  22.760  1.00 38.03           C
ATOM   1792  C   ALA   240      25.424 -16.425  20.867  1.00 38.01           C
ATOM   1793  O   ALA   240      25.284 -16.861  19.721  1.00 37.97           O
ATOM   1794  N   PHE   241      26.561 -15.898  21.321  1.00 38.18           N
ATOM   1795  CA  PHE   241      27.824 -15.996  20.594  1.00 38.26           C
ATOM   1796  CB  PHE   241      28.564 -14.652  20.598  1.00 37.95           C
ATOM   1797  CG  PHE   241      27.912 -13.581  19.762  1.00 37.70           C
ATOM   1798  CD1 PHE   241      27.503 -12.384  20.346  1.00 37.03           C
ATOM   1799  CE1 PHE   241      26.910 -11.386  19.584  1.00 36.73           C
ATOM   1800  CZ  PHE   241      26.718 -11.578  18.214  1.00 37.02           C
ATOM   1801  CE2 PHE   241      27.126 -12.767  17.620  1.00 36.41           C
ATOM   1802  CD2 PHE   241      27.720 -13.760  18.393  1.00 36.82           C
ATOM   1803  C   PHE   241      28.682 -17.064  21.264  1.00 38.53           C
ATOM   1804  O   PHE   241      29.892 -16.888  21.451  1.00 38.56           O
ATOM   1805  N   ASP   242      28.051 -18.177  21.623  1.00 38.92           N
ATOM   1806  CA  ASP   242      28.693 -19.178  22.476  1.00 39.33           C
ATOM   1807  CB  ASP   242      27.671 -19.783  23.444  1.00 39.76           C
ATOM   1808  CG  ASP   242      27.562 -18.998  24.744  1.00 40.63           C
ATOM   1809  OD1 ASP   242      28.534 -18.295  25.106  1.00 41.10           O
ATOM   1810  OD2 ASP   242      26.505 -19.093  25.408  1.00 42.12           O
ATOM   1811  C   ASP   242      29.439 -20.278  21.734  1.00 39.12           C
ATOM   1812  O   ASP   242      30.298 -20.950  22.314  1.00 39.27           O
ATOM   1813  N   LEU   243      29.107 -20.458  20.461  1.00 38.99           N
ATOM   1814  CA  LEU   243      29.721 -21.487  19.630  1.00 39.00           C
ATOM   1815  CB  LEU   243      28.988 -21.585  18.290  1.00 39.03           C
ATOM   1816  CG  LEU   243      27.614 -22.266  18.174  1.00 39.61           C
ATOM   1817  CD1 LEU   243      26.898 -22.527  19.508  1.00 40.20           C
ATOM   1818  CD2 LEU   243      26.732 -21.452  17.242  1.00 39.67           C
ATOM   1819  C   LEU   243      31.194 -21.164  19.403  1.00 38.94           C
ATOM   1820  O   LEU   243      31.530 -20.002  19.158  1.00 38.87           O
ATOM   1821  N   PRO   244      32.077 -22.187  19.488  1.00 38.86           N
ATOM   1822  CA  PRO   244      33.527 -22.017  19.303  1.00 38.83           C
ATOM   1823  CB  PRO   244      34.037 -23.458  19.132  1.00 38.84           C
ATOM   1824  CG  PRO   244      32.803 -24.325  19.030  1.00 38.83           C
ATOM   1825  CD  PRO   244      31.736 -23.592  19.761  1.00 38.81           C
ATOM   1826  C   PRO   244      33.869 -21.169  18.071  1.00 38.85           C
ATOM   1827  O   PRO   244      34.774 -20.339  18.118  1.00 38.72           O
ATOM   1828  N   GLN   245      33.115 -21.378  16.995  1.00 38.99           N
ATOM   1829  CA  GLN   245      33.170 -20.579  15.765  1.00 39.05           C
ATOM   1830  CB  GLN   245      31.967 -20.943  14.884  1.00 39.31           C
ATOM   1831  CG  GLN   245      31.830 -22.439  14.644  1.00 40.23           C
ATOM   1832  CD  GLN   245      30.399 -22.901  14.686  1.00 41.43           C
ATOM   1833  OE1 GLN   245      30.013 -23.684  15.557  1.00 42.47           O
ATOM   1834  NE2 GLN   245      29.594 -22.414  13.753  1.00 42.00           N
ATOM   1835  C   GLN   245      33.185 -19.057  15.983  1.00 38.65           C
ATOM   1836  O   GLN   245      33.688 -18.313  15.140  1.00 38.81           O
ATOM   1837  N   TRP   246      32.615 -18.601  17.097  1.00 37.87           N
ATOM   1838  CA  TRP   246      32.605 -17.176  17.431  1.00 37.11           C
ATOM   1839  CB  TRP   246      31.332 -16.819  18.207  1.00 36.67           C
ATOM   1840  CG  TRP   246      30.113 -16.887  17.346  1.00 36.36           C
ATOM   1841  CD1 TRP   246      29.208 -17.909  17.278  1.00 35.93           C
ATOM   1842  NE1 TRP   246      28.229 -17.616  16.354  1.00 35.83           N
ATOM   1843  CE2 TRP   246      28.492 -16.389  15.803  1.00 35.55           C
ATOM   1844  CD2 TRP   246      29.678 -15.903  16.398  1.00 35.88           C
ATOM   1845  CE3 TRP   246      30.167 -14.648  16.006  1.00 35.50           C
ATOM   1846  CZ3 TRP   246      29.472 -13.933  15.040  1.00 35.55           C
ATOM   1847  CH2 TRP   246      28.300 -14.448  14.460  1.00 35.89           C
ATOM   1848  CZ2 TRP   246      27.794 -15.669  14.829  1.00 35.87           C
ATOM   1849  C   TRP   246      33.856 -16.699  18.183  1.00 36.98           C
ATOM   1850  O   TRP   246      34.112 -15.495  18.246  1.00 37.09           O
ATOM   1851  N   ARG   247      34.634 -17.638  18.725  1.00 36.65           N
ATOM   1852  CA  ARG   247      35.781 -17.326  19.593  1.00 36.51           C
ATOM   1853  CB  ARG   247      36.447 -18.620  20.102  1.00 36.43           C
ATOM   1854  CG  ARG   247      37.706 -18.442  20.949  1.00 36.68           C
ATOM   1855  CD  ARG   247      37.413 -18.029  22.392  1.00 36.88           C
ATOM   1856  NE  ARG   247      38.636 -17.694  23.134  1.00 36.15           N
ATOM   1857  CZ  ARG   247      39.203 -18.472  24.056  1.00 36.35           C
ATOM   1858  NH1 ARG   247      40.310 -18.072  24.671  1.00 35.59           N
ATOM   1859  NH2 ARG   247      38.666 -19.649  24.372  1.00 36.90           N
ATOM   1860  C   ARG   247      36.815 -16.384  18.965  1.00 36.38           C
ATOM   1861  O   ARG   247      37.383 -15.541  19.664  1.00 36.55           O
ATOM   1862  N   THR   248      37.050 -16.514  17.658  1.00 36.20           N
ATOM   1863  CA  THR   248      38.044 -15.674  16.966  1.00 35.91           C
ATOM   1864  CB  THR   248      39.133 -16.510  16.254  1.00 35.83           C
ATOM   1865  OG1 THR   248      38.539 -17.251  15.180  1.00 35.25           O
ATOM   1866  CG2 THR   248      39.829 -17.453  17.229  1.00 35.75           C
ATOM   1867  C   THR   248      37.439 -14.692  15.956  1.00 35.86           C
ATOM   1868  O   THR   248      38.122 -14.240  15.030  1.00 35.73           O
ATOM   1869  N   ILE   249      36.161 -14.374  16.133  1.00 35.76           N
ATOM   1870  CA  ILE   249      35.513 -13.336  15.342  1.00 35.77           C
ATOM   1871  CB  ILE   249      34.075 -13.743  14.939  1.00 35.99           C
ATOM   1872  CG1 ILE   249      34.122 -15.049  14.134  1.00 36.24           C
ATOM   1873  CD1 ILE   249      32.801 -15.496  13.573  1.00 36.55           C
ATOM   1874  CG2 ILE   249      33.396 -12.637  14.126  1.00 35.85           C
ATOM   1875  C   ILE   249      35.562 -12.025  16.129  1.00 35.74           C
ATOM   1876  O   ILE   249      35.485 -12.033  17.361  1.00 35.61           O
ATOM   1877  N   SER   250      35.711 -10.911  15.412  1.00 35.81           N
ATOM   1878  CA  SER   250      35.985  -9.600  16.018  1.00 35.97           C
ATOM   1879  CB  SER   250      36.333  -8.583  14.931  1.00 35.91           C
ATOM   1880  OG  SER   250      35.218  -8.356  14.087  1.00 35.93           O
ATOM   1881  C   SER   250      34.847  -9.050  16.878  1.00 36.23           C
ATOM   1882  O   SER   250      33.671  -9.306  16.606  1.00 35.81           O
ATOM   1883  N   ASP   251      35.213  -8.284  17.908  1.00 36.56           N
ATOM   1884  CA  ASP   251      34.237  -7.595  18.755  1.00 36.87           C
ATOM   1885  CB  ASP   251      34.939  -6.765  19.838  1.00 36.75           C
ATOM   1886  CG  ASP   251      35.608  -7.625  20.908  1.00 36.45           C
ATOM   1887  OD1 ASP   251      35.124  -8.741  21.197  1.00 35.39           O
ATOM   1888  OD2 ASP   251      36.622  -7.171  21.478  1.00 36.42           O
ATOM   1889  C   ASP   251      33.308  -6.707  17.923  1.00 37.25           C
ATOM   1890  O   ASP   251      32.109  -6.630  18.198  1.00 37.54           O
ATOM   1891  N   ASP   252      33.869  -6.063  16.898  1.00 37.73           N
ATOM   1892  CA  ASP   252      33.122  -5.181  15.994  1.00 38.29           C
ATOM   1893  CB  ASP   252      34.065  -4.524  14.984  1.00 38.31           C
ATOM   1894  CG  ASP   252      34.966  -3.480  15.614  1.00 39.51           C
ATOM   1895  OD1 ASP   252      34.627  -2.964  16.705  1.00 40.68           O
ATOM   1896  OD2 ASP   252      36.016  -3.169  15.008  1.00 40.32           O
ATOM   1897  C   ASP   252      31.997  -5.893  15.245  1.00 38.40           C
ATOM   1898  O   ASP   252      30.908  -5.347  15.097  1.00 38.56           O
ATOM   1899  N   ALA   253      32.276  -7.103  14.767  1.00 38.64           N
ATOM   1900  CA  ALA   253      31.294  -7.908  14.049  1.00 38.68           C
ATOM   1901  CB  ALA   253      31.947  -9.150  13.475  1.00 38.72           C
ATOM   1902  C   ALA   253      30.158  -8.296  14.974  1.00 38.80           C
ATOM   1903  O   ALA   253      28.985  -8.246  14.589  1.00 39.01           O
ATOM   1904  N   LYS   254      30.516  -8.681  16.195  1.00 38.74           N
ATOM   1905  CA  LYS   254      29.540  -9.043  17.213  1.00 38.72           C
ATOM   1906  CB  LYS   254      30.239  -9.649  18.433  1.00 38.73           C
ATOM   1907  CG  LYS   254      30.852 -11.022  18.177  1.00 38.48           C
ATOM   1908  CD  LYS   254      31.647 -11.507  19.373  1.00 39.46           C
ATOM   1909  CE  LYS   254      32.538 -12.683  18.994  1.00 39.65           C
ATOM   1910  NZ  LYS   254      33.341 -13.181  20.143  1.00 39.55           N
ATOM   1911  C   LYS   254      28.706  -7.828  17.609  1.00 38.74           C
ATOM   1912  O   LYS   254      27.493  -7.939  17.835  1.00 38.81           O
ATOM   1913  N   ASP   255      29.361  -6.670  17.679  1.00 38.61           N
ATOM   1914  CA  ASP   255      28.688  -5.418  17.999  1.00 38.42           C
ATOM   1915  CB  ASP   255      29.698  -4.274  18.077  1.00 38.45           C
ATOM   1916  CG  ASP   255      29.056  -2.961  18.469  1.00 38.86           C
ATOM   1917  OD1 ASP   255      28.618  -2.836  19.632  1.00 39.77           O
ATOM   1918  OD2 ASP   255      28.989  -2.057  17.613  1.00 38.67           O
ATOM   1919  C   ASP   255      27.610  -5.102  16.965  1.00 38.20           C
ATOM   1920  O   ASP   255      26.471  -4.785  17.318  1.00 37.99           O
ATOM   1921  N   LEU   256      27.978  -5.197  15.691  1.00 38.04           N
ATOM   1922  CA  LEU   256      27.044  -4.957  14.596  1.00 37.96           C
ATOM   1923  CB  LEU   256      27.733  -5.170  13.245  1.00 38.08           C
ATOM   1924  CG  LEU   256      26.912  -4.952  11.970  1.00 38.33           C
ATOM   1925  CD1 LEU   256      26.171  -3.614  11.979  1.00 38.93           C
ATOM   1926  CD2 LEU   256      27.823  -5.035  10.766  1.00 38.19           C
ATOM   1927  C   LEU   256      25.813  -5.846  14.716  1.00 37.67           C
ATOM   1928  O   LEU   256      24.682  -5.349  14.765  1.00 37.65           O
ATOM   1929  N   ILE   257      26.044  -7.154  14.784  1.00 37.49           N
ATOM   1930  CA  ILE   257      24.967  -8.132  14.937  1.00 37.66           C
ATOM   1931  CB  ILE   257      25.513  -9.578  14.969  1.00 37.46           C
ATOM   1932  CG1 ILE   257      26.203  -9.909  13.640  1.00 37.24           C
ATOM   1933  CD1 ILE   257      27.106 -11.132  13.683  1.00 36.69           C
ATOM   1934  CG2 ILE   257      24.392 -10.571  15.246  1.00 37.31           C
ATOM   1935  C   ILE   257      24.082  -7.849  16.163  1.00 37.71           C
ATOM   1936  O   ILE   257      22.864  -7.972  16.078  1.00 37.97           O
ATOM   1937  N   ARG   258      24.698  -7.458  17.280  1.00 37.80           N
ATOM   1938  CA  ARG   258      23.969  -7.098  18.505  1.00 37.84           C
ATOM   1939  CB  ARG   258      24.939  -6.754  19.646  1.00 37.95           C
ATOM   1940  CG  ARG   258      25.290  -7.932  20.540  1.00 39.17           C
ATOM   1941  CD  ARG   258      25.998  -7.489  21.811  1.00 40.51           C
ATOM   1942  NE  ARG   258      27.446  -7.599  21.678  1.00 43.18           N
ATOM   1943  CZ  ARG   258      28.155  -8.650  22.085  1.00 44.28           C
ATOM   1944  NH1 ARG   258      27.552  -9.683  22.662  1.00 45.78           N
ATOM   1945  NH2 ARG   258      29.467  -8.670  21.919  1.00 44.33           N
ATOM   1946  C   ARG   258      23.003  -5.937  18.287  1.00 37.66           C
ATOM   1947  O   ARG   258      21.858  -5.963  18.763  1.00 37.57           O
ATOM   1948  N   LYS   259      23.473  -4.922  17.569  1.00 37.36           N
ATOM   1949  CA  LYS   259      22.669  -3.738  17.286  1.00 37.12           C
ATOM   1950  CB  LYS   259      23.550  -2.616  16.744  1.00 37.26           C
ATOM   1951  CG  LYS   259      24.498  -2.005  17.768  1.00 37.00           C
ATOM   1952  CD  LYS   259      25.279  -0.866  17.137  1.00 37.51           C
ATOM   1953  CE  LYS   259      25.799   0.124  18.179  1.00 38.31           C
ATOM   1954  NZ  LYS   259      27.021  -0.365  18.862  1.00 37.62           N
ATOM   1955  C   LYS   259      21.544  -4.053  16.302  1.00 36.92           C
ATOM   1956  O   LYS   259      20.450  -3.482  16.389  1.00 36.93           O
ATOM   1957  N   MET   260      21.819  -4.972  15.377  1.00 36.50           N
ATOM   1958  CA  MET   260      20.846  -5.374  14.367  1.00 36.12           C
ATOM   1959  CB  MET   260      21.553  -5.982  13.158  1.00 36.03           C
ATOM   1960  CG  MET   260      22.546  -5.074  12.483  1.00 35.11           C
ATOM   1961  SD  MET   260      23.408  -5.982  11.192  1.00 36.43           S
ATOM   1962  CE  MET   260      22.167  -5.991   9.900  1.00 34.16           C
ATOM   1963  C   MET   260      19.829  -6.374  14.907  1.00 36.11           C
ATOM   1964  O   MET   260      18.690  -6.416  14.448  1.00 36.26           O
ATOM   1965  N   LEU   261      20.242  -7.203  15.859  1.00 36.02           N
ATOM   1966  CA  LEU   261      19.312  -8.130  16.493  1.00 36.06           C
ATOM   1967  CB  LEU   261      19.946  -9.518  16.650  1.00 35.91           C
ATOM   1968  CG  LEU   261      20.336 -10.273  15.372  1.00 35.93           C
ATOM   1969  CD1 LEU   261      20.792 -11.679  15.724  1.00 36.12           C
ATOM   1970  CD2 LEU   261      19.191 -10.335  14.340  1.00 35.78           C
ATOM   1971  C   LEU   261      18.771  -7.591  17.831  1.00 36.14           C
ATOM   1972  O   LEU   261      18.379  -8.367  18.716  1.00 35.99           O
ATOM   1973  N   THR   262      18.751  -6.261  17.963  1.00 35.95           N
ATOM   1974  CA  THR   262      18.139  -5.592  19.111  1.00 36.27           C
ATOM   1975  CB  THR   262      18.344  -4.052  19.062  1.00 36.34           C
ATOM   1976  OG1 THR   262      19.746  -3.747  19.023  1.00 36.64           O
ATOM   1977  CG2 THR   262      17.734  -3.384  20.281  1.00 36.20           C
ATOM   1978  C   THR   262      16.647  -5.922  19.135  1.00 36.37           C
ATOM   1979  O   THR   262      15.968  -5.829  18.106  1.00 36.17           O
ATOM   1980  N   PHE   263      16.148  -6.313  20.307  1.00 36.60           N
ATOM   1981  CA  PHE   263      14.777  -6.802  20.429  1.00 36.83           C
ATOM   1982  CB  PHE   263      14.470  -7.287  21.856  1.00 37.09           C
ATOM   1983  CG  PHE   263      13.177  -8.059  21.964  1.00 37.43           C
ATOM   1984  CD1 PHE   263      13.082  -9.360  21.465  1.00 37.91           C
ATOM   1985  CE1 PHE   263      11.891 -10.076  21.549  1.00 37.54           C
ATOM   1986  CZ  PHE   263      10.776  -9.491  22.134  1.00 37.93           C
ATOM   1987  CE2 PHE   263      10.856  -8.188  22.633  1.00 38.30           C
ATOM   1988  CD2 PHE   263      12.054  -7.482  22.544  1.00 37.90           C
ATOM   1989  C   PHE   263      13.734  -5.791  19.938  1.00 36.84           C
ATOM   1990  O   PHE   263      13.006  -6.079  18.988  1.00 36.64           O
ATOM   1991  N   HIS   264      13.679  -4.614  20.567  1.00 36.77           N
ATOM   1992  CA  HIS   264      12.716  -3.573  20.185  1.00 36.84           C
ATOM   1993  CB  HIS   264      12.517  -2.565  21.319  1.00 36.91           C
ATOM   1994  CG  HIS   264      12.011  -3.172  22.589  1.00 37.26           C
ATOM   1995  ND1 HIS   264      10.804  -3.832  22.670  1.00 37.78           N
ATOM   1996  CE1 HIS   264      10.619  -4.255  23.908  1.00 38.24           C
ATOM   1997  NE2 HIS   264      11.661  -3.892  24.633  1.00 38.11           N
ATOM   1998  CD2 HIS   264      12.545  -3.211  23.833  1.00 38.01           C
ATOM   1999  C   HIS   264      13.132  -2.838  18.906  1.00 36.89           C
ATOM   2000  O   HIS   264      14.234  -2.287  18.839  1.00 36.77           O
ATOM   2001  N   PRO   265      12.240  -2.814  17.891  1.00 37.06           N
ATOM   2002  CA  PRO   265      12.532  -2.193  16.596  1.00 37.06           C
ATOM   2003  CB  PRO   265      11.203  -2.319  15.838  1.00 37.06           C
ATOM   2004  CG  PRO   265      10.172  -2.548  16.901  1.00 36.73           C
ATOM   2005  CD  PRO   265      10.874  -3.365  17.925  1.00 36.82           C
ATOM   2006  C   PRO   265      12.957  -0.728  16.724  1.00 37.35           C
ATOM   2007  O   PRO   265      13.883  -0.299  16.032  1.00 37.41           O
ATOM   2008  N   SER   266      12.304   0.019  17.616  1.00 37.60           N
ATOM   2009  CA  SER   266      12.649   1.423  17.877  1.00 38.00           C
ATOM   2010  CB  SER   266      11.651   2.051  18.852  1.00 38.00           C
ATOM   2011  OG  SER   266      11.596   1.311  20.061  1.00 38.23           O
ATOM   2012  C   SER   266      14.069   1.597  18.423  1.00 38.16           C
ATOM   2013  O   SER   266      14.690   2.644  18.225  1.00 38.33           O
ATOM   2014  N   LEU   267      14.568   0.578  19.120  1.00 38.30           N
ATOM   2015  CA  LEU   267      15.921   0.608  19.682  1.00 38.34           C
ATOM   2016  CB  LEU   267      15.968  -0.064  21.063  1.00 38.31           C
ATOM   2017  CG  LEU   267      15.284   0.643  22.250  1.00 38.53           C
ATOM   2018  CD1 LEU   267      15.223  -0.263  23.476  1.00 38.21           C
ATOM   2019  CD2 LEU   267      15.954   1.967  22.605  1.00 38.29           C
ATOM   2020  C   LEU   267      16.919  -0.043  18.732  1.00 38.41           C
ATOM   2021  O   LEU   267      18.128   0.066  18.917  1.00 38.47           O
ATOM   2022  N   ARG   268      16.395  -0.718  17.712  1.00 38.59           N
ATOM   2023  CA  ARG   268      17.216  -1.341  16.685  1.00 38.52           C
ATOM   2024  CB  ARG   268      16.374  -2.297  15.853  1.00 38.42           C
ATOM   2025  CG  ARG   268      17.181  -3.292  15.040  1.00 38.33           C
ATOM   2026  CD  ARG   268      16.267  -4.331  14.446  1.00 38.14           C
ATOM   2027  NE  ARG   268      15.405  -4.908  15.474  1.00 36.86           N
ATOM   2028  CZ  ARG   268      14.164  -5.326  15.259  1.00 36.50           C
ATOM   2029  NH1 ARG   268      13.466  -5.836  16.262  1.00 36.11           N
ATOM   2030  NH2 ARG   268      13.622  -5.231  14.049  1.00 35.73           N
ATOM   2031  C   ARG   268      17.843  -0.290  15.777  1.00 38.52           C
ATOM   2032  O   ARG   268      17.261   0.762  15.528  1.00 38.66           O
ATOM   2033  N   ILE   269      19.027  -0.603  15.274  1.00 38.59           N
ATOM   2034  CA  ILE   269      19.793   0.313  14.447  1.00 38.59           C
ATOM   2035  CB  ILE   269      21.296  -0.126  14.442  1.00 38.81           C
ATOM   2036  CG1 ILE   269      22.203   1.015  14.896  1.00 38.61           C
ATOM   2038  CG2 ILE   269      21.728  -0.775  13.115  1.00 39.47           C
ATOM   2039  C   ILE   269      19.158   0.410  13.047  1.00 38.19           C
ATOM   2040  O   ILE   269      18.491  -0.530  12.595  1.00 38.29           O
ATOM   2041  N   THR   270      19.324   1.561  12.394  1.00 37.66           N
ATOM   2042  CA  THR   270      18.815   1.781  11.037  1.00 37.11           C
ATOM   2043  CB  THR   270      18.745   3.278  10.687  1.00 37.16           C
ATOM   2044  OG1 THR   270      20.064   3.840  10.734  1.00 36.61           O
ATOM   2045  CG2 THR   270      17.835   4.033  11.649  1.00 37.16           C
ATOM   2046  C   THR   270      19.711   1.112   9.999  1.00 37.04           C
ATOM   2047  O   THR   270      20.811   0.655  10.317  1.00 37.18           O
ATOM   2048  N   ALA   271      19.245   1.066   8.754  1.00 36.71           N
ATOM   2049  CA  ALA   271      20.043   0.520   7.654  1.00 36.56           C
ATOM   2050  CB  ALA   271      19.185   0.325   6.424  1.00 36.48           C
ATOM   2051  C   ALA   271      21.268   1.379   7.318  1.00 36.47           C
ATOM   2052  O   ALA   271      22.296   0.845   6.903  1.00 36.42           O
ATOM   2053  N   THR   272      21.143   2.698   7.485  1.00 36.30           N
ATOM   2054  CA  THR   272      22.243   3.630   7.250  1.00 36.41           C
ATOM   2055  CB  THR   272      21.774   5.112   7.282  1.00 36.27           C
ATOM   2056  OG1 THR   272      20.750   5.317   6.306  1.00 36.02           O
ATOM   2057  CG2 THR   272      22.927   6.064   6.970  1.00 36.59           C
ATOM   2058  C   THR   272      23.330   3.409   8.298  1.00 36.74           C
ATOM   2059  O   THR   272      24.522   3.470   7.992  1.00 36.73           O
ATOM   2060  N   GLN   273      22.902   3.141   9.531  1.00 37.14           N
ATOM   2061  CA  GLN   273      23.815   2.862  10.635  1.00 37.37           C
ATOM   2062  CB  GLN   273      23.067   2.886  11.970  1.00 37.22           C
ATOM   2063  CG  GLN   273      22.714   4.291  12.463  1.00 37.20           C
ATOM   2064  CD  GLN   273      21.738   4.296  13.637  1.00 37.26           C
ATOM   2065  OE1 GLN   273      20.723   3.603  13.625  1.00 37.60           O
ATOM   2066  NE2 GLN   273      22.040   5.095  14.649  1.00 36.68           N
ATOM   2067  C   GLN   273      24.561   1.536  10.430  1.00 37.84           C
ATOM   2068  O   GLN   273      25.704   1.393  10.869  1.00 37.97           O
ATOM   2069  N   CYS   274      23.918   0.581   9.756  1.00 38.35           N
ATOM   2070  CA  CYS   274      24.586  -0.654   9.326  1.00 38.88           C
ATOM   2071  CB  CYS   274      23.584  -1.640   8.730  1.00 38.78           C
ATOM   2072  SG  CYS   274      22.440  -2.315   9.907  1.00 40.23           S
ATOM   2073  C   CYS   274      25.658  -0.352   8.287  1.00 38.92           C
ATOM   2074  O   CYS   274      26.808  -0.768   8.430  1.00 38.95           O
ATOM   2075  N   LEU   275      25.267   0.388   7.250  1.00 39.12           N
ATOM   2076  CA  LEU   275      26.159   0.743   6.151  1.00 39.17           C
ATOM   2077  CB  LEU   275      25.415   1.627   5.144  1.00 39.08           C
ATOM   2078  CG  LEU   275      25.483   1.359   3.633  1.00 39.29           C
ATOM   2079  CD1 LEU   275      25.244   2.654   2.865  1.00 39.20           C
ATOM   2080  CD2 LEU   275      26.792   0.719   3.185  1.00 38.99           C
ATOM   2081  C   LEU   275      27.393   1.481   6.664  1.00 39.32           C
ATOM   2082  O   LEU   275      28.440   1.476   6.019  1.00 39.60           O
ATOM   2083  N   GLU   276      27.270   2.102   7.833  1.00 39.30           N
ATOM   2084  CA  GLU   276      28.321   2.965   8.352  1.00 39.41           C
ATOM   2085  CB  GLU   276      27.790   4.395   8.507  1.00 39.63           C
ATOM   2086  CG  GLU   276      27.779   5.192   7.197  1.00 40.58           C
ATOM   2087  CD  GLU   276      26.794   6.356   7.197  1.00 41.51           C
ATOM   2088  OE1 GLU   276      26.034   6.511   8.179  1.00 42.08           O
ATOM   2089  OE2 GLU   276      26.776   7.113   6.203  1.00 41.37           O
ATOM   2090  C   GLU   276      28.964   2.463   9.649  1.00 39.18           C
ATOM   2091  O   GLU   276      29.749   3.181  10.274  1.00 39.01           O
ATOM   2092  N   HIS   277      28.641   1.232  10.044  1.00 38.95           N
ATOM   2093  CA  HIS   277      29.266   0.606  11.212  1.00 38.72           C
ATOM   2094  CB  HIS   277      28.594  -0.732  11.524  1.00 38.45           C
ATOM   2095  CG  HIS   277      28.964  -1.307  12.859  1.00 37.76           C
ATOM   2096  ND1 HIS   277      30.120  -2.028  13.066  1.00 36.70           N
ATOM   2097  CE1 HIS   277      30.181  -2.407  14.330  1.00 36.35           C
ATOM   2098  NE2 HIS   277      29.104  -1.964  14.950  1.00 36.59           N
ATOM   2099  CD2 HIS   277      28.325  -1.273  14.053  1.00 37.12           C
ATOM   2100  C   HIS   277      30.770   0.402  10.973  1.00 38.87           C
ATOM   2101  O   HIS   277      31.166   0.004   9.870  1.00 38.82           O
ATOM   2102  N   PRO   278      31.610   0.678  11.999  1.00 38.94           N
ATOM   2103  CA  PRO   278      33.074   0.516  11.897  1.00 39.06           C
ATOM   2104  CB  PRO   278      33.544   0.610  13.353  1.00 39.02           C
ATOM   2105  CG  PRO   278      32.524   1.457  14.023  1.00 39.02           C
ATOM   2106  CD  PRO   278      31.209   1.193  13.325  1.00 38.93           C
ATOM   2107  C   PRO   278      33.533  -0.812  11.284  1.00 39.18           C
ATOM   2108  O   PRO   278      34.606  -0.864  10.682  1.00 39.17           O
ATOM   2109  N   TRP   279      32.726  -1.864  11.434  1.00 39.42           N
ATOM   2110  CA  TRP   279      33.043  -3.184  10.883  1.00 39.78           C
ATOM   2111  CB  TRP   279      32.133  -4.270  11.477  1.00 39.82           C
ATOM   2112  CG  TRP   279      32.551  -5.671  11.075  1.00 39.89           C
ATOM   2113  CD1 TRP   279      33.632  -6.367  11.537  1.00 39.46           C
ATOM   2114  NE1 TRP   279      33.696  -7.599  10.937  1.00 39.10           N
ATOM   2115  CE2 TRP   279      32.651  -7.724  10.063  1.00 39.53           C
ATOM   2116  CD2 TRP   279      31.906  -6.524  10.120  1.00 39.50           C
ATOM   2117  CE3 TRP   279      30.771  -6.396   9.313  1.00 38.90           C
ATOM   2118  CZ3 TRP   279      30.415  -7.456   8.485  1.00 39.25           C
ATOM   2119  CH2 TRP   279      31.175  -8.639   8.451  1.00 39.36           C
ATOM   2120  CZ2 TRP   279      32.293  -8.792   9.229  1.00 39.60           C
ATOM   2121  C   TRP   279      32.974  -3.223   9.355  1.00 40.06           C
ATOM   2122  O   TRP   279      33.823  -3.842   8.712  1.00 40.06           O
ATOM   2123  N   ILE   280      31.956  -2.573   8.790  1.00 40.41           N
ATOM   2124  CA  ILE   280      31.809  -2.443   7.336  1.00 40.78           C
ATOM   2125  CB  ILE   280      30.375  -1.941   6.944  1.00 40.78           C
ATOM   2126  CG1 ILE   280      29.515  -3.103   6.443  1.00 40.79           C
ATOM   2127  CD1 ILE   280      29.080  -4.057   7.502  1.00 41.07           C
ATOM   2128  CG2 ILE   280      30.416  -0.904   5.839  1.00 40.63           C
ATOM   2129  C   ILE   280      32.907  -1.570   6.723  1.00 41.05           C
ATOM   2130  O   ILE   280      33.396  -1.857   5.627  1.00 41.21           O
ATOM   2131  N   GLN   281      33.296  -0.521   7.445  1.00 41.47           N
ATOM   2132  CA  GLN   281      34.310   0.428   6.973  1.00 41.91           C
ATOM   2133  CB  GLN   281      34.285   1.705   7.811  1.00 41.87           C
ATOM   2134  CG  GLN   281      32.952   2.444   7.769  1.00 42.15           C
ATOM   2135  CD  GLN   281      32.956   3.730   8.581  1.00 42.28           C
ATOM   2136  OE1 GLN   281      34.005   4.201   9.031  1.00 42.41           O
ATOM   2137  NE2 GLN   281      31.774   4.308   8.768  1.00 42.75           N
ATOM   2138  C   GLN   281      35.718  -0.167   6.958  1.00 42.01           C
ATOM   2139  O   GLN   281      36.540   0.203   6.122  1.00 41.90           O
ATOM   2140  N   LYS   282      35.980  -1.093   7.878  1.00 42.34           N
ATOM   2141  CA  LYS   282      37.279  -1.761   7.963  1.00 42.74           C
ATOM   2142  CB  LYS   282      37.391  -2.569   9.260  1.00 42.63           C
ATOM   2147  C   LYS   282      37.584  -2.649   6.750  1.00 43.06           C
ATOM   2148  O   LYS   282      38.750  -2.829   6.397  1.00 43.05           O
ATOM   2149  N   TYR   283      36.547  -3.193   6.110  1.00 43.54           N
ATOM   2150  CA  TYR   283      36.750  -4.092   4.960  1.00 43.80           C
ATOM   2151  CB  TYR   283      36.098  -5.459   5.218  1.00 43.57           C
ATOM   2152  CG  TYR   283      36.623  -6.126   6.475  1.00 43.49           C
ATOM   2153  CD1 TYR   283      37.888  -6.725   6.502  1.00 44.00           C
ATOM   2154  CE1 TYR   283      38.382  -7.329   7.668  1.00 44.11           C
ATOM   2155  CZ  TYR   283      37.601  -7.329   8.821  1.00 43.93           C
ATOM   2156  OH  TYR   283      38.071  -7.916   9.980  1.00 43.43           O
ATOM   2157  CE2 TYR   283      36.347  -6.732   8.815  1.00 43.35           C
ATOM   2158  CD2 TYR   283      35.869  -6.132   7.648  1.00 43.24           C
ATOM   2159  C   TYR   283      36.341  -3.491   3.603  1.00 44.02           C
ATOM   2160  O   TYR   283      36.228  -4.207   2.599  1.00 44.17           O
ATOM   2161  N   SER   284      36.160  -2.171   3.580  1.00 44.15           N
ATOM   2162  CA  SER   284      35.769  -1.450   2.370  1.00 44.18           C
ATOM   2163  CB  SER   284      34.509  -0.631   2.633  1.00 44.21           C
ATOM   2164  C   SER   284      36.896  -0.556   1.857  1.00 44.08           C
ATOM   2165  O   SER   284      37.955  -1.040   1.452  0.50 44.05           O
END
