
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   85 (  678),  selected   85 , name 2p13_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2p13_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E   431_A      -       -           -
LGA    K   432_A      -       -           -
LGA    V   433_A      D       5          6.464
LGA    V   434_A      E       6          1.086
LGA    A   435_A      I       7          0.857
LGA    E   436_A      V       8          1.070
LGA    Q   437_A      Q       9          1.553
LGA    Q   438_A      R      10          2.495
LGA    A   439_A      E      11          3.489
LGA    D   440_A      D      12          2.598
LGA    G   441_A      G      13          1.667
LGA    T   442_A      S      14          0.942
LGA    W   443_A      W      15          0.986
LGA    L   444_A      L      16          0.810
LGA    X   445_A      V      17          0.381
LGA    D   446_A      D      18          0.159
LGA    G   447_A      G      19          0.311
LGA    W   448_A      M      20          0.348
LGA    I   449_A      V      21          0.353
LGA    S   450_A      S      22          0.483
LGA    I   451_A      L      23          1.476
LGA    R   452_A      D      24          1.741
LGA    K   453_A      R      25          1.467
LGA    A   454_A      F      26          1.636
LGA    S   455_A      R      27          1.568
LGA    N   456_A      E      28          1.957
LGA    L   457_A      F      29          2.229
LGA    L   458_A      F      30          2.146
LGA    E   459_A      E      31          2.059
LGA    H   460_A      L      32          1.621
LGA    -       -      E      33           -
LGA    D   461_A      A      34          3.470
LGA    L   462_A      P      35          3.214
LGA    V   463_A      L      36          4.752
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    D   464_A      E      39          1.979
LGA    E   465_A      A      40          2.598
LGA    A   466_A      G      41          2.051
LGA    E   467_A      G      42          1.363
LGA    R   468_A      N      43          2.649
LGA    Y   469_A      I      44          1.076
LGA    S   470_A      H      45          0.989
LGA    T   471_A      T      46          0.290
LGA    L   472_A      L      47          0.149
LGA    G   473_A      A      48          0.218
LGA    G   474_A      G      49          0.475
LGA    Y   475_A      V      50          0.748
LGA    L   476_A      M      51          0.775
LGA    L   477_A      L      52          0.290
LGA    W   478_A      Y      53          0.425
LGA    Q   479_A      Q      54          0.768
LGA    F   480_A      L      55          1.024
LGA    G   481_A      G      56          2.260
LGA    Y   482_A      R      57          2.954
LGA    I   483_A      V      58          1.293
LGA    P   484_A      P      59          1.042
LGA    A   485_A      S      60          0.843
LGA    A   486_A      V      61          0.849
LGA    G   487_A      T      62          0.728
LGA    E   488_A      D      63          1.030
LGA    Q   489_A      R      64          0.313
LGA    I   490_A      F      65          1.103
LGA    T   491_A      E      66          0.726
LGA    V   492_A      W      67          0.444
LGA    D   493_A      N      68          0.871
LGA    G   494_A      G      69          1.308
LGA    L   495_A      F      70          0.542
LGA    I   496_A      S      71          0.522
LGA    F   497_A      F      72          0.347
LGA    E   498_A      E      73          0.759
LGA    I   499_A      V      74          0.514
LGA    V   500_A      V      75          0.514
LGA    S   501_A      D      76          0.516
LGA    V   502_A      M      77          1.058
LGA    N   503_A      D      78          1.581
LGA    K   504_A      R      79          3.189
LGA    H   505_A      T      80          4.827
LGA    N   506_A      R      81          2.248
LGA    I   507_A      V      82          0.449
LGA    G   508_A      D      83          0.603
LGA    K   509_A      K      84          0.689
LGA    V   510_A      I      85          0.447
LGA    R   511_A      L      86          0.485
LGA    V   512_A      V      87          0.762
LGA    H   513_A      Q      88          0.968
LGA    R   514_A      R      89          2.297
LGA    T   515_A      H      90          3.281
LGA    -       -      H      91           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   85   87    5.0     83    1.81    27.71     87.250     4.338

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.078338 * X  +   0.445888 * Y  +   0.891654 * Z  +  23.930019
  Y_new =   0.985368 * X  +   0.101173 * Y  +  -0.137165 * Z  +  25.376062
  Z_new =  -0.151372 * X  +   0.889352 * Y  +  -0.431438 * Z  +   5.221735 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.022465   -1.119127  [ DEG:   115.8787    -64.1213 ]
  Theta =   0.151956    2.989637  [ DEG:     8.7064    171.2936 ]
  Phi   =   1.491462   -1.650131  [ DEG:    85.4545    -94.5455 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p13_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p13_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   85   87   5.0   83   1.81   27.71  87.250
REMARK  ---------------------------------------------------------- 
MOLECULE 2p13_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   01-MAR-07   2P13              
TITLE     TRANSPORTER ASSOCIATED DOMAIN CORC_HLYC FROM NITROSOMONAS             
TITLE    2 EUROPAEA                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CBS DOMAIN;                                                
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CORC_HLYC DOMAIN;                                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NITROSOMONAS EUROPAEA;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: IFO 14298;                                                   
SOURCE   5 ATCC: 19718;                                                         
SOURCE   6 GENE: NE2227;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPHA-BETA STRUCTURE, STRUCTURAL GENOMICS, PSI-2, PROTEIN             
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,C.HATZOS,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR               
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   03-APR-07 2P13    0                                                
JRNL        AUTH   Y.KIM,C.HATZOS,S.CLANCY,A.JOACHIMIAK                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE TRANSPORTER                     
JRNL        TITL 2 ASSOCIATED DOMAIN CORC_HLYC FROM NITROSOMONAS                
JRNL        TITL 3 EUROPAEA                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  2P13 A  430   516  UNP    Q82SS8   Q82SS8_NITEU   430    516             
DBREF  2P13 B  430   516  UNP    Q82SS8   Q82SS8_NITEU   430    516             
SEQRES   1 A   90  SER ASN ALA GLU GLU LYS VAL VAL ALA GLU GLN GLN ALA          
SEQRES   2 A   90  ASP GLY THR TRP LEU MSE ASP GLY TRP ILE SER ILE ARG          
SEQRES   3 A   90  LYS ALA SER ASN LEU LEU GLU HIS ASP LEU VAL ASP GLU          
SEQRES   4 A   90  ALA GLU ARG TYR SER THR LEU GLY GLY TYR LEU LEU TRP          
SEQRES   5 A   90  GLN PHE GLY TYR ILE PRO ALA ALA GLY GLU GLN ILE THR          
SEQRES   6 A   90  VAL ASP GLY LEU ILE PHE GLU ILE VAL SER VAL ASN LYS          
SEQRES   7 A   90  HIS ASN ILE GLY LYS VAL ARG VAL HIS ARG THR GLN              
SEQRES   1 B   90  SER ASN ALA GLU GLU LYS VAL VAL ALA GLU GLN GLN ALA          
SEQRES   2 B   90  ASP GLY THR TRP LEU MSE ASP GLY TRP ILE SER ILE ARG          
SEQRES   3 B   90  LYS ALA SER ASN LEU LEU GLU HIS ASP LEU VAL ASP GLU          
SEQRES   4 B   90  ALA GLU ARG TYR SER THR LEU GLY GLY TYR LEU LEU TRP          
SEQRES   5 B   90  GLN PHE GLY TYR ILE PRO ALA ALA GLY GLU GLN ILE THR          
SEQRES   6 B   90  VAL ASP GLY LEU ILE PHE GLU ILE VAL SER VAL ASN LYS          
SEQRES   7 B   90  HIS ASN ILE GLY LYS VAL ARG VAL HIS ARG THR GLN              
HET    MSE  A 445       8                                                       
HET    MSE  B 445       8                                                       
HET    ACY    201       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACY ACETIC ACID                                                      
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   3  ACY    C2 H4 O2                                                     
FORMUL   4  HOH   *179(H2 O)                                                    
CRYST1   49.397   49.397  127.094  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   GLU A 431       5.731   4.368  31.166  1.00 63.46           N  
ATOM      2  CA  GLU A 431       5.955   2.951  31.592  1.00 63.24           C  
ATOM      3  C   GLU A 431       6.824   2.172  30.595  1.00 61.98           C  
ATOM      4  O   GLU A 431       7.051   0.972  30.774  1.00 62.73           O  
ATOM      5  CB  GLU A 431       4.606   2.239  31.752  1.00 63.54           C  
ATOM      6  CG  GLU A 431       3.815   2.614  33.002  1.00 64.57           C  
ATOM      7  CD  GLU A 431       2.461   1.926  33.066  1.00 64.87           C  
ATOM      8  OE1 GLU A 431       1.702   1.989  32.063  1.00 66.68           O  
ATOM      9  OE2 GLU A 431       2.156   1.325  34.125  1.00 67.23           O  
ATOM     10  N   LYS A 432       7.305   2.854  29.551  1.00 59.93           N  
ATOM     11  CA  LYS A 432       7.995   2.190  28.443  1.00 57.60           C  
ATOM     12  C   LYS A 432       9.374   2.815  28.184  1.00 55.00           C  
ATOM     13  O   LYS A 432       9.620   3.970  28.587  1.00 54.51           O  
ATOM     14  CB  LYS A 432       7.131   2.225  27.175  1.00 57.83           C  
ATOM     15  CG  LYS A 432       7.350   1.042  26.215  1.00 59.06           C  
ATOM     16  CD  LYS A 432       6.221   0.922  25.184  1.00 59.11           C  
ATOM     17  CE  LYS A 432       4.824   0.840  25.831  1.00 60.90           C  
ATOM     18  NZ  LYS A 432       4.584  -0.410  26.609  1.00 61.46           N  
ATOM     19  N   VAL A 433      10.224   2.051  27.492  1.00 51.93           N  
ATOM     20  CA  VAL A 433      11.658   2.366  27.242  1.00 49.35           C  
ATOM     21  C   VAL A 433      11.917   3.285  26.034  1.00 47.09           C  
ATOM     22  O   VAL A 433      11.601   2.947  24.886  1.00 48.90           O  
ATOM     23  CB  VAL A 433      12.527   1.058  27.093  1.00 49.97           C  
ATOM     24  CG1 VAL A 433      13.986   1.373  26.754  1.00 50.66           C  
ATOM     25  CG2 VAL A 433      12.461   0.204  28.368  1.00 49.56           C  
ATOM     26  N   VAL A 434      12.528   4.430  26.311  1.00 42.28           N  
ATOM     27  CA  VAL A 434      12.850   5.410  25.293  1.00 39.12           C  
ATOM     28  C   VAL A 434      14.309   5.364  24.828  1.00 35.52           C  
ATOM     29  O   VAL A 434      14.648   5.843  23.757  1.00 35.38           O  
ATOM     30  CB  VAL A 434      12.456   6.842  25.764  1.00 40.21           C  
ATOM     31  CG1 VAL A 434      10.955   6.870  26.178  1.00 39.29           C  
ATOM     32  CG2 VAL A 434      13.324   7.354  26.856  1.00 42.14           C  
ATOM     33  N   ALA A 435      15.186   4.809  25.670  1.00 34.27           N  
ATOM     34  CA  ALA A 435      16.600   4.816  25.371  1.00 33.55           C  
ATOM     35  C   ALA A 435      17.236   3.703  26.160  1.00 33.10           C  
ATOM     36  O   ALA A 435      16.948   3.546  27.349  1.00 33.60           O  
ATOM     37  CB  ALA A 435      17.271   6.144  25.779  1.00 33.94           C  
ATOM     38  N   GLU A 436      18.072   2.930  25.493  1.00 33.04           N  
ATOM     39  CA  GLU A 436      18.823   1.909  26.238  1.00 34.34           C  
ATOM     40  C   GLU A 436      20.217   1.736  25.721  1.00 34.14           C  
ATOM     41  O   GLU A 436      20.472   1.858  24.533  1.00 33.48           O  
ATOM     42  CB  GLU A 436      18.072   0.584  26.250  1.00 35.54           C  
ATOM     43  CG  GLU A 436      17.969  -0.133  24.944  1.00 37.61           C  
ATOM     44  CD  GLU A 436      17.080  -1.387  25.026  1.00 40.77           C  
ATOM     45  OE1 GLU A 436      16.808  -1.981  23.959  1.00 50.93           O  
ATOM     46  OE2 GLU A 436      16.621  -1.764  26.143  1.00 47.09           O  
ATOM     47  N   GLN A 437      21.115   1.446  26.658  1.00 33.83           N  
ATOM     48  CA  GLN A 437      22.515   1.313  26.303  1.00 34.32           C  
ATOM     49  C   GLN A 437      22.997  -0.108  26.572  1.00 35.14           C  
ATOM     50  O   GLN A 437      22.754  -0.652  27.651  1.00 33.55           O  
ATOM     51  CB  GLN A 437      23.358   2.302  27.083  1.00 34.93           C  
ATOM     52  CG  GLN A 437      24.817   2.266  26.574  1.00 36.34           C  
ATOM     53  CD  GLN A 437      25.750   3.302  27.175  1.00 41.13           C  
ATOM     54  OE1 GLN A 437      25.672   3.633  28.360  1.00 42.97           O  
ATOM     55  NE2 GLN A 437      26.685   3.789  26.342  1.00 43.86           N  
ATOM     56  N   GLN A 438      23.649  -0.696  25.567  1.00 35.86           N  
ATOM     57  CA  GLN A 438      24.220  -2.061  25.687  1.00 39.23           C  
ATOM     58  C   GLN A 438      25.587  -1.996  26.323  1.00 38.80           C  
ATOM     59  O   GLN A 438      26.157  -0.921  26.474  1.00 38.56           O  
ATOM     60  CB  GLN A 438      24.343  -2.710  24.306  1.00 38.78           C  
ATOM     61  CG  GLN A 438      23.073  -2.701  23.475  1.00 41.14           C  
ATOM     62  CD  GLN A 438      23.293  -3.244  22.073  1.00 42.70           C  
ATOM     63  OE1 GLN A 438      24.437  -3.481  21.649  1.00 51.02           O  
ATOM     64  NE2 GLN A 438      22.208  -3.474  21.358  1.00 46.84           N  
ATOM     65  N   ALA A 439      26.091  -3.169  26.738  1.00 40.23           N  
ATOM     66  CA  ALA A 439      27.409  -3.315  27.353  1.00 41.17           C  
ATOM     67  C   ALA A 439      28.505  -2.762  26.448  1.00 41.83           C  
ATOM     68  O   ALA A 439      29.466  -2.157  26.946  1.00 42.25           O  
ATOM     69  CB  ALA A 439      27.670  -4.760  27.662  1.00 41.76           C  
ATOM     70  N   ASP A 440      28.357  -2.977  25.137  1.00 41.24           N  
ATOM     71  CA  ASP A 440      29.321  -2.470  24.141  1.00 42.01           C  
ATOM     72  C   ASP A 440      29.219  -0.972  23.858  1.00 41.51           C  
ATOM     73  O   ASP A 440      30.040  -0.424  23.125  1.00 41.71           O  
ATOM     74  CB  ASP A 440      29.337  -3.298  22.834  1.00 42.51           C  
ATOM     75  CG  ASP A 440      28.125  -3.069  21.927  1.00 44.36           C  
ATOM     76  OD1 ASP A 440      27.129  -2.390  22.292  1.00 41.82           O  
ATOM     77  OD2 ASP A 440      28.178  -3.609  20.801  1.00 45.87           O  
ATOM     78  N   GLY A 441      28.241  -0.316  24.488  1.00 40.24           N  
ATOM     79  CA  GLY A 441      28.169   1.137  24.452  1.00 39.85           C  
ATOM     80  C   GLY A 441      27.169   1.664  23.441  1.00 38.45           C  
ATOM     81  O   GLY A 441      26.848   2.843  23.429  1.00 38.87           O  
ATOM     82  N   THR A 442      26.696   0.779  22.578  1.00 37.53           N  
ATOM     83  CA  THR A 442      25.694   1.157  21.592  1.00 36.49           C  
ATOM     84  C   THR A 442      24.386   1.522  22.283  1.00 35.13           C  
ATOM     85  O   THR A 442      23.987   0.882  23.249  1.00 34.85           O  
ATOM     86  CB  THR A 442      25.486   0.018  20.591  1.00 37.66           C  
ATOM     87  OG1 THR A 442      26.741  -0.228  19.917  1.00 38.70           O  
ATOM     88  CG2 THR A 442      24.440   0.324  19.575  1.00 36.85           C  
ATOM     89  N   TRP A 443      23.760   2.553  21.729  1.00 34.93           N  
ATOM     90  CA  TRP A 443      22.435   2.991  22.155  1.00 33.07           C  
ATOM     91  C   TRP A 443      21.344   2.531  21.187  1.00 34.24           C  
ATOM     92  O   TRP A 443      21.565   2.512  19.954  1.00 33.55           O  
ATOM     93  CB  TRP A 443      22.408   4.528  22.207  1.00 34.92           C  
ATOM     94  CG  TRP A 443      23.085   5.099  23.398  1.00 34.04           C  
ATOM     95  CD1 TRP A 443      24.386   5.538  23.455  1.00 33.89           C  
ATOM     96  CD2 TRP A 443      22.537   5.268  24.710  1.00 34.64           C  
ATOM     97  NE1 TRP A 443      24.680   5.984  24.722  1.00 33.96           N  
ATOM     98  CE2 TRP A 443      23.570   5.813  25.527  1.00 33.91           C  
ATOM     99  CE3 TRP A 443      21.280   4.985  25.295  1.00 34.10           C  
ATOM    100  CZ2 TRP A 443      23.369   6.119  26.882  1.00 34.44           C  
ATOM    101  CZ3 TRP A 443      21.091   5.280  26.674  1.00 34.74           C  
ATOM    102  CH2 TRP A 443      22.143   5.821  27.451  1.00 35.93           C  
ATOM    103  N   LEU A 444      20.176   2.174  21.725  0.50 33.17           N  
ATOM    105  CA  LEU A 444      18.972   2.096  20.906  0.50 33.60           C  
ATOM    107  C   LEU A 444      17.991   3.092  21.498  0.50 33.37           C  
ATOM    109  O   LEU A 444      17.634   3.013  22.690  0.50 32.44           O  
ATOM    111  CB  LEU A 444      18.383   0.688  20.916  0.50 34.11           C  
ATOM    113  CG  LEU A 444      17.222   0.364  19.964  0.50 34.28           C  
ATOM    115  CD1 LEU A 444      17.671   0.371  18.494  0.50 35.94           C  
ATOM    117  CD2 LEU A 444      16.627  -0.989  20.324  0.50 34.64           C  
HETATM  119  N   MSE A 445      17.539   4.020  20.659  1.00 33.26           N  
HETATM  120  CA  MSE A 445      16.727   5.128  21.124  1.00 33.95           C  
HETATM  121  C   MSE A 445      15.470   5.245  20.289  1.00 34.18           C  
HETATM  122  O   MSE A 445      15.503   4.959  19.072  1.00 34.56           O  
HETATM  123  CB  MSE A 445      17.488   6.426  20.974  1.00 34.88           C  
HETATM  124  CG  MSE A 445      18.701   6.552  21.906  1.00 35.74           C  
HETATM  125 SE   MSE A 445      19.688   8.134  21.533  0.74 40.99          SE  
HETATM  126  CE  MSE A 445      20.719   8.129  23.251  1.00 34.32           C  
ATOM    127  N   ASP A 446      14.426   5.739  20.929  1.00 33.31           N  
ATOM    128  CA  ASP A 446      13.164   5.965  20.198  1.00 33.15           C  
ATOM    129  C   ASP A 446      13.211   7.317  19.481  1.00 33.19           C  
ATOM    130  O   ASP A 446      13.749   8.272  20.024  1.00 33.01           O  
ATOM    131  CB  ASP A 446      11.989   5.946  21.140  1.00 34.48           C  
ATOM    132  CG  ASP A 446      10.701   6.047  20.384  1.00 37.08           C  
ATOM    133  OD1 ASP A 446      10.401   5.121  19.565  1.00 40.92           O  
ATOM    134  OD2 ASP A 446      10.017   7.073  20.521  1.00 34.60           O  
ATOM    135  N   GLY A 447      12.546   7.424  18.311  1.00 31.95           N  
ATOM    136  CA  GLY A 447      12.517   8.656  17.510  1.00 31.04           C  
ATOM    137  C   GLY A 447      11.890   9.830  18.274  1.00 30.44           C  
ATOM    138  O   GLY A 447      12.134  11.006  17.921  1.00 31.97           O  
ATOM    139  N   TRP A 448      11.056   9.529  19.254  1.00 30.82           N  
ATOM    140  CA  TRP A 448      10.400  10.642  19.980  1.00 30.67           C  
ATOM    141  C   TRP A 448      11.184  11.133  21.171  1.00 31.13           C  
ATOM    142  O   TRP A 448      10.706  12.020  21.880  1.00 31.14           O  
ATOM    143  CB  TRP A 448       8.986  10.272  20.439  1.00 30.29           C  
ATOM    144  CG  TRP A 448       8.024  10.091  19.278  1.00 29.98           C  
ATOM    145  CD1 TRP A 448       7.701   8.925  18.628  1.00 30.68           C  
ATOM    146  CD2 TRP A 448       7.249  11.137  18.650  1.00 28.94           C  
ATOM    147  NE1 TRP A 448       6.744   9.186  17.650  1.00 30.95           N  
ATOM    148  CE2 TRP A 448       6.484  10.535  17.608  1.00 31.28           C  
ATOM    149  CE3 TRP A 448       7.149  12.548  18.849  1.00 32.22           C  
ATOM    150  CZ2 TRP A 448       5.633  11.263  16.777  1.00 31.07           C  
ATOM    151  CZ3 TRP A 448       6.310  13.296  17.994  1.00 31.49           C  
ATOM    152  CH2 TRP A 448       5.503  12.637  16.994  1.00 28.55           C  
ATOM    153  N   ILE A 449      12.385  10.606  21.407  0.50 29.42           N  
ATOM    155  CA  ILE A 449      13.248  11.177  22.447  0.50 28.81           C  
ATOM    157  C   ILE A 449      13.593  12.641  22.079  0.50 27.77           C  
ATOM    159  O   ILE A 449      13.914  12.911  20.928  0.50 28.41           O  
ATOM    161  CB  ILE A 449      14.532  10.317  22.622  0.50 28.20           C  
ATOM    163  CG1 ILE A 449      15.158  10.580  24.011  0.50 27.80           C  
ATOM    165  CG2 ILE A 449      15.518  10.479  21.439  0.50 27.62           C  
ATOM    167  CD1 ILE A 449      16.379   9.644  24.323  0.50 28.07           C  
ATOM    169  N   SER A 450      13.549  13.585  23.042  0.60 28.70           N  
ATOM    171  CA  SER A 450      13.971  14.948  22.710  0.60 27.02           C  
ATOM    173  C   SER A 450      15.463  14.953  22.225  0.60 27.80           C  
ATOM    175  O   SER A 450      16.311  14.182  22.715  0.60 27.96           O  
ATOM    177  CB  SER A 450      13.835  15.842  23.974  0.60 27.64           C  
ATOM    179  OG  SER A 450      14.878  15.621  24.917  0.60 23.88           O  
ATOM    181  N   ILE A 451      15.757  15.858  21.298  1.00 29.56           N  
ATOM    182  CA  ILE A 451      17.115  16.031  20.743  1.00 29.63           C  
ATOM    183  C   ILE A 451      18.098  16.433  21.836  1.00 29.69           C  
ATOM    184  O   ILE A 451      19.251  16.023  21.820  1.00 30.45           O  
ATOM    185  CB  ILE A 451      17.136  16.993  19.510  1.00 28.74           C  
ATOM    186  CG1 ILE A 451      18.466  16.885  18.755  1.00 31.55           C  
ATOM    187  CG2 ILE A 451      16.833  18.392  19.958  1.00 30.20           C  
ATOM    188  CD1 ILE A 451      18.734  15.472  18.288  1.00 34.08           C  
ATOM    189  N   ARG A 452      17.627  17.166  22.858  1.00 29.36           N  
ATOM    190  CA  ARG A 452      18.498  17.521  23.996  1.00 31.07           C  
ATOM    191  C   ARG A 452      18.830  16.249  24.784  1.00 30.95           C  
ATOM    192  O   ARG A 452      19.979  16.032  25.145  1.00 31.80           O  
ATOM    193  CB  ARG A 452      17.780  18.551  24.881  1.00 33.23           C  
ATOM    194  CG  ARG A 452      18.432  18.924  26.176  1.00 38.14           C  
ATOM    195  CD  ARG A 452      19.281  20.211  25.977  1.00 48.56           C  
ATOM    196  NE  ARG A 452      18.526  21.243  25.246  1.00 55.70           N  
ATOM    197  CZ  ARG A 452      19.051  22.174  24.438  1.00 58.75           C  
ATOM    198  NH1 ARG A 452      20.366  22.245  24.225  1.00 59.86           N  
ATOM    199  NH2 ARG A 452      18.246  23.040  23.823  1.00 60.82           N  
ATOM    200  N   LYS A 453      17.815  15.415  25.046  1.00 30.98           N  
ATOM    201  CA  LYS A 453      18.122  14.177  25.806  1.00 31.79           C  
ATOM    202  C   LYS A 453      19.069  13.259  25.045  1.00 32.32           C  
ATOM    203  O   LYS A 453      20.063  12.768  25.626  1.00 33.06           O  
ATOM    204  CB  LYS A 453      16.858  13.467  26.215  1.00 31.76           C  
ATOM    205  CG  LYS A 453      17.132  12.145  26.951  1.00 33.82           C  
ATOM    206  CD  LYS A 453      15.829  11.481  27.450  1.00 36.38           C  
ATOM    207  CE  LYS A 453      15.112  12.306  28.501  1.00 40.41           C  
ATOM    208  NZ  LYS A 453      16.010  12.614  29.665  1.00 45.79           N  
ATOM    209  N   ALA A 454      18.815  13.089  23.744  1.00 32.19           N  
ATOM    210  CA  ALA A 454      19.732  12.304  22.893  1.00 33.13           C  
ATOM    211  C   ALA A 454      21.148  12.862  22.965  1.00 33.57           C  
ATOM    212  O   ALA A 454      22.075  12.097  23.120  1.00 33.47           O  
ATOM    213  CB  ALA A 454      19.230  12.273  21.442  1.00 32.97           C  
ATOM    214  N   SER A 455      21.293  14.181  22.806  1.00 34.08           N  
ATOM    215  CA  SER A 455      22.597  14.870  22.898  1.00 34.29           C  
ATOM    216  C   SER A 455      23.304  14.576  24.232  1.00 34.80           C  
ATOM    217  O   SER A 455      24.505  14.309  24.269  1.00 34.32           O  
ATOM    218  CB  SER A 455      22.405  16.378  22.730  1.00 33.85           C  
ATOM    219  OG  SER A 455      21.934  16.659  21.435  1.00 33.90           O  
ATOM    220  N   ASN A 456      22.557  14.638  25.331  1.00 33.62           N  
ATOM    221  CA  ASN A 456      23.109  14.432  26.652  1.00 35.92           C  
ATOM    222  C   ASN A 456      23.631  13.010  26.788  1.00 36.15           C  
ATOM    223  O   ASN A 456      24.753  12.808  27.233  1.00 36.54           O  
ATOM    224  CB  ASN A 456      22.054  14.722  27.707  1.00 35.90           C  
ATOM    225  CG  ASN A 456      21.798  16.217  27.908  1.00 38.91           C  
ATOM    226  OD1 ASN A 456      20.746  16.607  28.426  1.00 45.12           O  
ATOM    227  ND2 ASN A 456      22.759  17.047  27.538  1.00 42.55           N  
ATOM    228  N   LEU A 457      22.820  12.033  26.374  1.00 35.66           N  
ATOM    229  CA  LEU A 457      23.172  10.613  26.495  1.00 36.05           C  
ATOM    230  C   LEU A 457      24.331  10.224  25.572  1.00 35.98           C  
ATOM    231  O   LEU A 457      25.177   9.428  25.974  1.00 37.48           O  
ATOM    232  CB  LEU A 457      21.954   9.742  26.199  1.00 35.82           C  
ATOM    233  CG  LEU A 457      20.828   9.894  27.217  1.00 34.99           C  
ATOM    234  CD1 LEU A 457      19.641   9.010  26.742  1.00 34.45           C  
ATOM    235  CD2 LEU A 457      21.284   9.561  28.649  1.00 38.62           C  
ATOM    236  N   LEU A 458      24.386  10.836  24.397  0.50 35.17           N  
ATOM    238  CA  LEU A 458      25.408  10.527  23.396  0.50 34.35           C  
ATOM    240  C   LEU A 458      26.660  11.374  23.559  0.50 35.33           C  
ATOM    242  O   LEU A 458      27.642  11.190  22.810  0.50 35.24           O  
ATOM    244  CB  LEU A 458      24.827  10.778  22.016  0.50 34.14           C  
ATOM    246  CG  LEU A 458      23.715   9.807  21.611  0.50 28.99           C  
ATOM    248  CD1 LEU A 458      22.950  10.343  20.420  0.50 31.82           C  
ATOM    250  CD2 LEU A 458      24.344   8.393  21.348  0.50 29.94           C  
ATOM    252  N   GLU A 459      26.597  12.312  24.505  1.00 36.19           N  
ATOM    253  CA  GLU A 459      27.720  13.202  24.857  1.00 36.99           C  
ATOM    254  C   GLU A 459      28.214  13.958  23.632  1.00 38.65           C  
ATOM    255  O   GLU A 459      29.402  14.029  23.321  1.00 38.89           O  
ATOM    256  CB  GLU A 459      28.844  12.430  25.570  1.00 37.28           C  
ATOM    257  CG  GLU A 459      28.326  11.740  26.799  1.00 37.96           C  
ATOM    258  CD  GLU A 459      29.429  11.117  27.605  1.00 42.11           C  
ATOM    259  OE1 GLU A 459      30.206  10.324  27.026  1.00 42.98           O  
ATOM    260  OE2 GLU A 459      29.517  11.440  28.802  1.00 46.82           O  
ATOM    261  N   HIS A 460      27.248  14.498  22.915  1.00 39.24           N  
ATOM    262  CA  HIS A 460      27.536  15.310  21.765  1.00 41.41           C  
ATOM    263  C   HIS A 460      26.368  16.220  21.495  1.00 41.70           C  
ATOM    264  O   HIS A 460      25.236  15.762  21.389  1.00 39.50           O  
ATOM    265  CB  HIS A 460      27.849  14.473  20.535  1.00 41.59           C  
ATOM    266  CG  HIS A 460      28.359  15.295  19.396  1.00 45.54           C  
ATOM    267  ND1 HIS A 460      29.612  15.871  19.398  1.00 49.83           N  
ATOM    268  CD2 HIS A 460      27.767  15.685  18.247  1.00 49.83           C  
ATOM    269  CE1 HIS A 460      29.779  16.562  18.284  1.00 49.64           C  
ATOM    270  NE2 HIS A 460      28.676  16.457  17.563  1.00 50.72           N  
ATOM    271  N   ASP A 461      26.673  17.514  21.406  1.00 43.17           N  
ATOM    272  CA  ASP A 461      25.648  18.523  21.154  1.00 44.15           C  
ATOM    273  C   ASP A 461      25.109  18.457  19.734  1.00 44.13           C  
ATOM    274  O   ASP A 461      25.780  18.865  18.778  1.00 43.91           O  
ATOM    275  CB  ASP A 461      26.166  19.930  21.485  1.00 45.17           C  
ATOM    276  CG  ASP A 461      25.037  20.936  21.702  1.00 47.07           C  
ATOM    277  OD1 ASP A 461      23.878  20.650  21.306  1.00 47.45           O  
ATOM    278  OD2 ASP A 461      25.313  22.016  22.277  1.00 48.13           O  
ATOM    279  N   LEU A 462      23.889  17.940  19.608  1.00 43.39           N  
ATOM    280  CA  LEU A 462      23.184  17.856  18.324  1.00 43.74           C  
ATOM    281  C   LEU A 462      22.167  18.982  18.127  1.00 44.58           C  
ATOM    282  O   LEU A 462      21.453  19.020  17.111  1.00 45.44           O  
ATOM    283  CB  LEU A 462      22.494  16.482  18.189  1.00 42.57           C  
ATOM    284  CG  LEU A 462      23.393  15.242  18.431  1.00 41.77           C  
ATOM    285  CD1 LEU A 462      22.556  13.983  18.519  1.00 40.85           C  
ATOM    286  CD2 LEU A 462      24.402  15.081  17.311  1.00 43.64           C  
ATOM    287  N   VAL A 463      22.086  19.894  19.088  1.00 46.32           N  
ATOM    288  CA  VAL A 463      20.986  20.867  19.132  1.00 48.20           C  
ATOM    289  C   VAL A 463      21.153  22.036  18.147  1.00 50.12           C  
ATOM    290  O   VAL A 463      22.202  22.695  18.135  1.00 50.53           O  
ATOM    291  CB  VAL A 463      20.735  21.365  20.571  1.00 48.78           C  
ATOM    292  CG1 VAL A 463      19.652  22.432  20.620  1.00 48.83           C  
ATOM    293  CG2 VAL A 463      20.400  20.194  21.499  1.00 46.91           C  
ATOM    294  N   ASP A 464      20.103  22.258  17.338  1.00 52.29           N  
ATOM    295  CA  ASP A 464      19.975  23.371  16.365  1.00 53.70           C  
ATOM    296  C   ASP A 464      19.790  24.720  17.054  1.00 54.54           C  
ATOM    297  O   ASP A 464      18.902  24.868  17.902  1.00 55.17           O  
ATOM    298  CB  ASP A 464      18.749  23.121  15.473  1.00 54.34           C  
ATOM    299  CG  ASP A 464      18.745  23.956  14.191  1.00 55.39           C  
ATOM    300  OD1 ASP A 464      19.823  24.399  13.727  1.00 56.58           O  
ATOM    301  OD2 ASP A 464      17.639  24.149  13.627  1.00 55.41           O  
ATOM    302  N   GLU A 465      20.616  25.703  16.689  1.00 54.82           N  
ATOM    303  CA  GLU A 465      20.449  27.086  17.179  1.00 54.84           C  
ATOM    304  C   GLU A 465      19.044  27.663  16.890  1.00 54.01           C  
ATOM    305  O   GLU A 465      18.471  28.352  17.746  1.00 54.62           O  
ATOM    306  CB  GLU A 465      21.511  28.019  16.574  1.00 54.96           C  
ATOM    307  CG  GLU A 465      22.680  28.404  17.494  1.00 55.54           C  
ATOM    308  CD  GLU A 465      23.532  29.556  16.936  1.00 56.14           C  
ATOM    309  OE1 GLU A 465      23.741  29.622  15.699  1.00 58.08           O  
ATOM    310  OE2 GLU A 465      24.004  30.400  17.741  1.00 56.02           O  
ATOM    311  N   ALA A 466      18.506  27.379  15.696  1.00 52.47           N  
ATOM    312  CA  ALA A 466      17.231  27.951  15.220  1.00 51.04           C  
ATOM    313  C   ALA A 466      15.987  27.063  15.478  1.00 49.98           C  
ATOM    314  O   ALA A 466      14.867  27.373  15.018  1.00 50.34           O  
ATOM    315  CB  ALA A 466      17.343  28.337  13.731  1.00 51.28           C  
ATOM    316  N   GLU A 467      16.157  25.981  16.238  0.50 49.21           N  
ATOM    318  CA  GLU A 467      15.035  25.119  16.681  0.50 47.78           C  
ATOM    320  C   GLU A 467      14.206  24.474  15.558  0.50 47.38           C  
ATOM    322  O   GLU A 467      12.983  24.320  15.690  0.50 47.40           O  
ATOM    324  CB  GLU A 467      14.114  25.852  17.692  0.50 48.24           C  
ATOM    326  CG  GLU A 467      14.682  25.979  19.111  0.50 47.50           C  
ATOM    328  CD  GLU A 467      13.663  26.460  20.169  0.50 46.92           C  
ATOM    330  OE1 GLU A 467      12.446  26.469  19.922  0.50 45.64           O  
ATOM    332  OE2 GLU A 467      14.092  26.827  21.272  0.50 46.70           O  
ATOM    334  N   ARG A 468      14.860  24.069  14.468  1.00 45.65           N  
ATOM    335  CA  ARG A 468      14.136  23.433  13.373  1.00 44.33           C  
ATOM    336  C   ARG A 468      13.695  22.002  13.677  1.00 41.26           C  
ATOM    337  O   ARG A 468      12.756  21.466  13.045  1.00 41.83           O  
ATOM    338  CB  ARG A 468      14.970  23.474  12.097  1.00 45.98           C  
ATOM    339  CG  ARG A 468      14.895  24.844  11.424  1.00 48.40           C  
ATOM    340  CD  ARG A 468      16.004  25.098  10.399  1.00 52.84           C  
ATOM    341  NE  ARG A 468      17.338  24.905  10.977  1.00 54.86           N  
ATOM    342  CZ  ARG A 468      18.477  25.248  10.379  1.00 55.26           C  
ATOM    343  NH1 ARG A 468      18.464  25.832   9.177  1.00 56.06           N  
ATOM    344  NH2 ARG A 468      19.631  25.012  10.992  1.00 54.79           N  
ATOM    345  N   TYR A 469      14.326  21.398  14.672  1.00 37.58           N  
ATOM    346  CA  TYR A 469      13.931  20.064  15.056  1.00 34.18           C  
ATOM    347  C   TYR A 469      13.980  19.949  16.586  1.00 31.59           C  
ATOM    348  O   TYR A 469      14.681  20.720  17.302  1.00 32.44           O  
ATOM    349  CB  TYR A 469      14.812  18.993  14.411  1.00 35.28           C  
ATOM    350  CG  TYR A 469      16.286  19.304  14.536  1.00 33.91           C  
ATOM    351  CD1 TYR A 469      16.990  19.844  13.456  1.00 34.58           C  
ATOM    352  CD2 TYR A 469      16.980  19.056  15.734  1.00 36.39           C  
ATOM    353  CE1 TYR A 469      18.320  20.156  13.561  1.00 34.30           C  
ATOM    354  CE2 TYR A 469      18.323  19.363  15.845  1.00 36.02           C  
ATOM    355  CZ  TYR A 469      18.990  19.907  14.731  1.00 37.75           C  
ATOM    356  OH  TYR A 469      20.341  20.216  14.829  1.00 40.15           O  
ATOM    357  N   SER A 470      13.180  19.004  17.083  1.00 30.87           N  
ATOM    358  CA  SER A 470      12.984  18.928  18.519  1.00 30.69           C  
ATOM    359  C   SER A 470      13.213  17.516  19.078  1.00 30.73           C  
ATOM    360  O   SER A 470      13.465  17.365  20.296  1.00 30.64           O  
ATOM    361  CB  SER A 470      11.536  19.381  18.783  1.00 30.77           C  
ATOM    362  OG  SER A 470      11.297  19.553  20.146  1.00 33.43           O  
ATOM    363  N   THR A 471      13.066  16.522  18.192  1.00 30.59           N  
ATOM    364  CA  THR A 471      13.223  15.106  18.638  1.00 30.72           C  
ATOM    365  C   THR A 471      14.330  14.455  17.822  1.00 31.14           C  
ATOM    366  O   THR A 471      14.786  15.012  16.787  1.00 30.60           O  
ATOM    367  CB  THR A 471      11.925  14.278  18.414  1.00 31.32           C  
ATOM    368  OG1 THR A 471      11.532  14.323  17.004  1.00 32.07           O  
ATOM    369  CG2 THR A 471      10.784  14.850  19.234  1.00 35.15           C  
ATOM    370  N   LEU A 472      14.771  13.279  18.245  1.00 30.87           N  
ATOM    371  CA  LEU A 472      15.840  12.601  17.497  1.00 30.82           C  
ATOM    372  C   LEU A 472      15.271  12.266  16.117  1.00 32.32           C  
ATOM    373  O   LEU A 472      15.970  12.405  15.126  1.00 30.82           O  
ATOM    374  CB  LEU A 472      16.151  11.287  18.211  1.00 32.30           C  
ATOM    375  CG  LEU A 472      17.169  10.413  17.541  1.00 30.94           C  
ATOM    376  CD1 LEU A 472      18.502  11.093  17.300  1.00 34.57           C  
ATOM    377  CD2 LEU A 472      17.391   9.080  18.327  1.00 33.06           C  
ATOM    378  N   GLY A 473      14.027  11.781  16.083  1.00 32.79           N  
ATOM    379  CA  GLY A 473      13.405  11.418  14.751  1.00 31.23           C  
ATOM    380  C   GLY A 473      13.346  12.674  13.867  1.00 31.64           C  
ATOM    381  O   GLY A 473      13.663  12.612  12.665  1.00 32.84           O  
ATOM    382  N   GLY A 474      12.926  13.827  14.443  1.00 30.58           N  
ATOM    383  CA  GLY A 474      12.883  15.080  13.651  1.00 30.96           C  
ATOM    384  C   GLY A 474      14.257  15.493  13.153  1.00 31.49           C  
ATOM    385  O   GLY A 474      14.404  15.909  11.997  1.00 33.62           O  
ATOM    386  N   TYR A 475      15.240  15.391  14.038  1.00 31.08           N  
ATOM    387  CA  TYR A 475      16.617  15.632  13.657  1.00 32.15           C  
ATOM    388  C   TYR A 475      17.060  14.765  12.478  1.00 32.02           C  
ATOM    389  O   TYR A 475      17.663  15.276  11.532  1.00 31.80           O  
ATOM    390  CB  TYR A 475      17.498  15.379  14.863  1.00 32.24           C  
ATOM    391  CG  TYR A 475      18.958  15.440  14.560  1.00 32.26           C  
ATOM    392  CD1 TYR A 475      19.569  16.643  14.308  1.00 35.64           C  
ATOM    393  CD2 TYR A 475      19.718  14.281  14.562  1.00 35.85           C  
ATOM    394  CE1 TYR A 475      20.946  16.700  14.076  1.00 37.73           C  
ATOM    395  CE2 TYR A 475      21.100  14.307  14.329  1.00 36.88           C  
ATOM    396  CZ  TYR A 475      21.695  15.522  14.083  1.00 35.86           C  
ATOM    397  OH  TYR A 475      23.066  15.578  13.845  1.00 38.70           O  
ATOM    398  N   LEU A 476      16.783  13.471  12.523  0.70 30.79           N  
ATOM    400  CA  LEU A 476      17.203  12.592  11.414  0.70 30.65           C  
ATOM    402  C   LEU A 476      16.437  12.885  10.129  0.70 31.95           C  
ATOM    404  O   LEU A 476      17.027  12.905   9.050  0.70 31.53           O  
ATOM    406  CB  LEU A 476      17.071  11.127  11.873  0.70 30.29           C  
ATOM    408  CG  LEU A 476      18.025  10.775  13.041  0.70 28.61           C  
ATOM    410  CD1 LEU A 476      17.599   9.438  13.624  0.70 32.89           C  
ATOM    412  CD2 LEU A 476      19.500  10.691  12.525  0.70 32.15           C  
ATOM    414  N   LEU A 477      15.136  13.143  10.243  1.00 30.95           N  
ATOM    415  CA  LEU A 477      14.355  13.509   9.046  1.00 33.39           C  
ATOM    416  C   LEU A 477      14.929  14.769   8.433  1.00 32.80           C  
ATOM    417  O   LEU A 477      14.953  14.939   7.198  1.00 34.45           O  
ATOM    418  CB  LEU A 477      12.870  13.711   9.365  1.00 33.44           C  
ATOM    419  CG  LEU A 477      12.194  12.398   9.690  1.00 34.29           C  
ATOM    420  CD1 LEU A 477      10.856  12.634  10.404  1.00 34.66           C  
ATOM    421  CD2 LEU A 477      11.977  11.534   8.397  1.00 33.72           C  
ATOM    422  N   TRP A 478      15.392  15.687   9.296  1.00 32.74           N  
ATOM    423  CA  TRP A 478      16.019  16.928   8.793  1.00 33.49           C  
ATOM    424  C   TRP A 478      17.382  16.632   8.112  1.00 33.09           C  
ATOM    425  O   TRP A 478      17.694  17.223   7.046  1.00 32.37           O  
ATOM    426  CB  TRP A 478      16.149  17.925   9.943  1.00 34.89           C  
ATOM    427  CG  TRP A 478      16.847  19.182   9.633  1.00 34.96           C  
ATOM    428  CD1 TRP A 478      16.325  20.315   9.061  1.00 41.06           C  
ATOM    429  CD2 TRP A 478      18.209  19.446   9.892  1.00 39.35           C  
ATOM    430  NE1 TRP A 478      17.304  21.279   8.974  1.00 41.80           N  
ATOM    431  CE2 TRP A 478      18.467  20.771   9.479  1.00 40.11           C  
ATOM    432  CE3 TRP A 478      19.235  18.711  10.496  1.00 39.41           C  
ATOM    433  CZ2 TRP A 478      19.736  21.361   9.604  1.00 40.25           C  
ATOM    434  CZ3 TRP A 478      20.495  19.290  10.611  1.00 39.67           C  
ATOM    435  CH2 TRP A 478      20.730  20.607  10.175  1.00 38.99           C  
ATOM    436  N   GLN A 479      18.169  15.745   8.729  1.00 32.92           N  
ATOM    437  CA  GLN A 479      19.440  15.276   8.187  1.00 33.54           C  
ATOM    438  C   GLN A 479      19.263  14.593   6.830  1.00 34.47           C  
ATOM    439  O   GLN A 479      19.980  14.933   5.870  1.00 35.59           O  
ATOM    440  CB  GLN A 479      20.185  14.348   9.172  1.00 35.13           C  
ATOM    441  CG  GLN A 479      20.736  15.111  10.369  1.00 33.24           C  
ATOM    442  CD  GLN A 479      21.956  15.935  10.029  1.00 37.80           C  
ATOM    443  OE1 GLN A 479      22.263  16.168   8.851  1.00 39.50           O  
ATOM    444  NE2 GLN A 479      22.707  16.333  11.053  1.00 38.63           N  
ATOM    445  N   PHE A 480      18.317  13.657   6.734  1.00 33.66           N  
ATOM    446  CA  PHE A 480      18.114  12.972   5.456  1.00 34.22           C  
ATOM    447  C   PHE A 480      17.414  13.857   4.409  1.00 33.17           C  
ATOM    448  O   PHE A 480      17.780  13.793   3.229  1.00 34.19           O  
ATOM    449  CB  PHE A 480      17.299  11.690   5.608  1.00 33.51           C  
ATOM    450  CG  PHE A 480      18.052  10.581   6.170  1.00 33.26           C  
ATOM    451  CD1 PHE A 480      18.888   9.835   5.361  1.00 34.68           C  
ATOM    452  CD2 PHE A 480      17.856  10.200   7.503  1.00 33.99           C  
ATOM    453  CE1 PHE A 480      19.599   8.764   5.873  1.00 38.60           C  
ATOM    454  CE2 PHE A 480      18.552   9.116   8.021  1.00 35.41           C  
ATOM    455  CZ  PHE A 480      19.444   8.404   7.197  1.00 34.80           C  
ATOM    456  N   GLY A 481      16.435  14.681   4.835  1.00 33.25           N  
ATOM    457  CA  GLY A 481      15.537  15.443   3.951  1.00 34.02           C  
ATOM    458  C   GLY A 481      14.496  14.598   3.214  1.00 33.11           C  
ATOM    459  O   GLY A 481      13.934  15.031   2.222  1.00 34.74           O  
ATOM    460  N   TYR A 482      14.319  13.349   3.700  1.00 33.23           N  
ATOM    461  CA  TYR A 482      13.264  12.454   3.206  1.00 31.93           C  
ATOM    462  C   TYR A 482      13.050  11.435   4.348  1.00 32.52           C  
ATOM    463  O   TYR A 482      13.774  11.451   5.362  1.00 32.31           O  
ATOM    464  CB  TYR A 482      13.655  11.722   1.923  1.00 32.62           C  
ATOM    465  CG  TYR A 482      14.949  10.946   1.978  1.00 32.35           C  
ATOM    466  CD1 TYR A 482      16.135  11.536   1.567  1.00 32.24           C  
ATOM    467  CD2 TYR A 482      15.001   9.627   2.455  1.00 34.56           C  
ATOM    468  CE1 TYR A 482      17.334  10.842   1.631  1.00 33.14           C  
ATOM    469  CE2 TYR A 482      16.229   8.914   2.500  1.00 34.87           C  
ATOM    470  CZ  TYR A 482      17.381   9.534   2.063  1.00 34.16           C  
ATOM    471  OH  TYR A 482      18.621   8.870   2.067  1.00 35.05           O  
ATOM    472  N   ILE A 483      12.061  10.570   4.135  1.00 32.16           N  
ATOM    473  CA  ILE A 483      11.768   9.511   5.094  1.00 32.00           C  
ATOM    474  C   ILE A 483      12.648   8.276   4.794  1.00 31.93           C  
ATOM    475  O   ILE A 483      12.477   7.639   3.742  1.00 31.84           O  
ATOM    476  CB  ILE A 483      10.273   9.128   5.026  1.00 32.36           C  
ATOM    477  CG1 ILE A 483       9.400  10.343   5.241  1.00 32.27           C  
ATOM    478  CG2 ILE A 483       9.960   8.102   6.164  1.00 35.15           C  
ATOM    479  CD1 ILE A 483       7.913  10.026   4.924  1.00 32.01           C  
ATOM    480  N   PRO A 484      13.649   8.007   5.654  1.00 33.44           N  
ATOM    481  CA  PRO A 484      14.632   6.975   5.280  1.00 34.00           C  
ATOM    482  C   PRO A 484      14.047   5.591   5.458  1.00 35.16           C  
ATOM    483  O   PRO A 484      12.979   5.435   6.150  1.00 35.63           O  
ATOM    484  CB  PRO A 484      15.783   7.196   6.290  1.00 34.15           C  
ATOM    485  CG  PRO A 484      15.046   7.741   7.576  1.00 35.18           C  
ATOM    486  CD  PRO A 484      13.961   8.652   6.960  1.00 33.74           C  
ATOM    487  N   ALA A 485      14.753   4.618   4.857  1.00 36.73           N  
ATOM    488  CA  ALA A 485      14.547   3.212   5.125  1.00 37.04           C  
ATOM    489  C   ALA A 485      15.417   2.682   6.270  1.00 37.19           C  
ATOM    490  O   ALA A 485      16.504   3.204   6.570  1.00 38.03           O  
ATOM    491  CB  ALA A 485      14.826   2.409   3.815  1.00 35.91           C  
ATOM    492  N   ALA A 486      14.995   1.590   6.884  1.00 39.06           N  
ATOM    493  CA  ALA A 486      15.951   0.763   7.668  1.00 37.94           C  
ATOM    494  C   ALA A 486      17.352   0.525   7.046  1.00 37.65           C  
ATOM    495  O   ALA A 486      17.507   0.145   5.863  1.00 39.27           O  
ATOM    496  CB  ALA A 486      15.337  -0.531   8.064  1.00 36.90           C  
ATOM    497  N   GLY A 487      18.366   0.731   7.870  1.00 37.05           N  
ATOM    498  CA  GLY A 487      19.746   0.507   7.445  1.00 37.21           C  
ATOM    499  C   GLY A 487      20.471   1.771   7.044  1.00 37.53           C  
ATOM    500  O   GLY A 487      21.724   1.803   7.075  1.00 38.87           O  
ATOM    501  N   GLU A 488      19.713   2.805   6.665  1.00 37.57           N  
ATOM    502  CA  GLU A 488      20.348   4.049   6.258  1.00 37.94           C  
ATOM    503  C   GLU A 488      20.971   4.659   7.489  1.00 38.66           C  
ATOM    504  O   GLU A 488      20.486   4.475   8.610  1.00 37.30           O  
ATOM    505  CB  GLU A 488      19.350   5.020   5.618  1.00 38.03           C  
ATOM    506  CG  GLU A 488      18.638   4.467   4.398  1.00 37.69           C  
ATOM    507  CD  GLU A 488      18.109   5.581   3.524  1.00 37.93           C  
ATOM    508  OE1 GLU A 488      18.930   6.421   3.103  1.00 38.83           O  
ATOM    509  OE2 GLU A 488      16.879   5.639   3.285  1.00 37.44           O  
ATOM    510  N   GLN A 489      22.036   5.410   7.269  1.00 39.71           N  
ATOM    511  CA  GLN A 489      22.816   5.906   8.357  1.00 40.53           C  
ATOM    512  C   GLN A 489      23.265   7.301   8.054  1.00 42.33           C  
ATOM    513  O   GLN A 489      23.474   7.683   6.874  1.00 43.07           O  
ATOM    514  CB  GLN A 489      24.027   5.004   8.566  1.00 42.88           C  
ATOM    515  CG  GLN A 489      23.639   3.563   8.933  1.00 46.23           C  
ATOM    516  CD  GLN A 489      24.727   2.525   8.638  1.00 49.27           C  
ATOM    517  OE1 GLN A 489      24.556   1.658   7.768  1.00 50.96           O  
ATOM    518  NE2 GLN A 489      25.837   2.591   9.380  1.00 50.84           N  
ATOM    519  N   ILE A 490      23.468   8.053   9.114  1.00 44.76           N  
ATOM    520  CA  ILE A 490      24.100   9.344   9.029  1.00 46.93           C  
ATOM    521  C   ILE A 490      25.247   9.359  10.020  1.00 47.25           C  
ATOM    522  O   ILE A 490      25.130   8.815  11.121  1.00 44.71           O  
ATOM    523  CB  ILE A 490      23.063  10.451   9.234  1.00 49.04           C  
ATOM    524  CG1 ILE A 490      22.818  11.136   7.889  1.00 50.03           C  
ATOM    525  CG2 ILE A 490      23.438  11.437  10.351  1.00 50.06           C  
ATOM    526  CD1 ILE A 490      21.406  11.339   7.562  1.00 53.86           C  
ATOM    527  N   THR A 491      26.371   9.920   9.604  1.00 46.91           N  
ATOM    528  CA  THR A 491      27.467  10.108  10.527  1.00 48.65           C  
ATOM    529  C   THR A 491      27.601  11.598  10.827  1.00 49.56           C  
ATOM    530  O   THR A 491      27.675  12.428   9.902  1.00 49.32           O  
ATOM    531  CB  THR A 491      28.807   9.482   9.980  1.00 48.82           C  
ATOM    532  OG1 THR A 491      28.532   8.222   9.340  1.00 48.33           O  
ATOM    533  CG2 THR A 491      29.805   9.265  11.103  1.00 50.50           C  
ATOM    534  N   VAL A 492      27.642  11.938  12.112  1.00 51.24           N  
ATOM    535  CA  VAL A 492      27.785  13.320  12.547  1.00 52.84           C  
ATOM    536  C   VAL A 492      28.854  13.363  13.627  1.00 54.23           C  
ATOM    537  O   VAL A 492      28.682  12.762  14.693  1.00 55.16           O  
ATOM    538  CB  VAL A 492      26.441  13.915  13.093  1.00 53.88           C  
ATOM    539  CG1 VAL A 492      26.512  15.447  13.135  1.00 54.18           C  
ATOM    540  CG2 VAL A 492      25.279  13.513  12.213  1.00 52.96           C  
ATOM    541  N   ASP A 493      29.962  14.041  13.331  1.00 54.49           N  
ATOM    542  CA  ASP A 493      31.047  14.230  14.310  1.00 55.44           C  
ATOM    543  C   ASP A 493      31.491  12.928  15.015  1.00 54.52           C  
ATOM    544  O   ASP A 493      31.792  12.926  16.223  1.00 54.91           O  
ATOM    545  CB  ASP A 493      30.657  15.296  15.350  1.00 55.79           C  
ATOM    546  CG  ASP A 493      30.065  16.564  14.718  1.00 58.48           C  
ATOM    547  OD1 ASP A 493      30.553  17.017  13.652  1.00 61.04           O  
ATOM    548  OD2 ASP A 493      29.102  17.111  15.302  1.00 60.62           O  
ATOM    549  N   GLY A 494      31.559  11.836  14.247  1.00 53.45           N  
ATOM    550  CA  GLY A 494      31.995  10.538  14.768  1.00 51.24           C  
ATOM    551  C   GLY A 494      30.905   9.734  15.478  1.00 49.60           C  
ATOM    552  O   GLY A 494      31.216   8.835  16.245  1.00 49.78           O  
ATOM    553  N   LEU A 495      29.640  10.064  15.229  1.00 47.80           N  
ATOM    554  CA  LEU A 495      28.513   9.236  15.692  1.00 45.88           C  
ATOM    555  C   LEU A 495      27.782   8.669  14.468  1.00 44.26           C  
ATOM    556  O   LEU A 495      27.482   9.402  13.515  1.00 44.53           O  
ATOM    557  CB  LEU A 495      27.533  10.053  16.543  1.00 46.14           C  
ATOM    558  CG  LEU A 495      27.877  10.409  17.992  1.00 47.26           C  
ATOM    559  CD1 LEU A 495      26.930  11.496  18.498  1.00 48.14           C  
ATOM    560  CD2 LEU A 495      27.807   9.181  18.907  1.00 47.93           C  
ATOM    561  N   ILE A 496      27.502   7.369  14.493  1.00 41.51           N  
ATOM    562  CA  ILE A 496      26.749   6.720  13.427  1.00 40.04           C  
ATOM    563  C   ILE A 496      25.350   6.484  13.955  1.00 39.28           C  
ATOM    564  O   ILE A 496      25.195   5.834  15.000  1.00 39.20           O  
ATOM    565  CB  ILE A 496      27.353   5.349  13.032  1.00 40.75           C  
ATOM    566  CG1 ILE A 496      28.722   5.543  12.361  1.00 39.13           C  
ATOM    567  CG2 ILE A 496      26.438   4.633  12.039  1.00 40.18           C  
ATOM    568  CD1 ILE A 496      29.515   4.232  12.131  1.00 40.04           C  
ATOM    569  N   PHE A 497      24.363   7.015  13.231  1.00 38.97           N  
ATOM    570  CA  PHE A 497      22.933   6.840  13.575  1.00 38.68           C  
ATOM    571  C   PHE A 497      22.349   5.916  12.493  1.00 39.17           C  
ATOM    572  O   PHE A 497      22.296   6.277  11.272  1.00 40.63           O  
ATOM    573  CB  PHE A 497      22.158   8.174  13.504  1.00 38.07           C  
ATOM    574  CG  PHE A 497      22.585   9.183  14.493  1.00 39.43           C  
ATOM    575  CD1 PHE A 497      21.855   9.369  15.681  1.00 35.50           C  
ATOM    576  CD2 PHE A 497      23.713   9.957  14.266  1.00 38.66           C  
ATOM    577  CE1 PHE A 497      22.279  10.313  16.609  1.00 40.61           C  
ATOM    578  CE2 PHE A 497      24.134  10.897  15.201  1.00 41.53           C  
ATOM    579  CZ  PHE A 497      23.425  11.082  16.353  1.00 40.36           C  
ATOM    580  N   GLU A 498      21.919   4.731  12.911  1.00 36.89           N  
ATOM    581  CA  GLU A 498      21.312   3.767  11.988  1.00 37.75           C  
ATOM    582  C   GLU A 498      19.806   3.643  12.188  1.00 37.38           C  
ATOM    583  O   GLU A 498      19.296   3.415  13.298  1.00 36.70           O  
ATOM    584  CB  GLU A 498      21.993   2.381  12.099  1.00 39.53           C  
ATOM    585  CG  GLU A 498      21.742   1.454  10.900  1.00 44.35           C  
ATOM    586  CD  GLU A 498      21.334   0.032  11.296  1.00 53.05           C  
ATOM    587  OE1 GLU A 498      22.184  -0.700  11.857  1.00 54.40           O  
ATOM    588  OE2 GLU A 498      20.163  -0.360  11.032  1.00 54.05           O  
ATOM    589  N   ILE A 499      19.069   3.800  11.102  1.00 36.61           N  
ATOM    590  CA  ILE A 499      17.630   3.656  11.229  1.00 35.31           C  
ATOM    591  C   ILE A 499      17.329   2.183  11.373  1.00 35.55           C  
ATOM    592  O   ILE A 499      17.782   1.359  10.549  1.00 36.49           O  
ATOM    593  CB  ILE A 499      16.917   4.208   9.930  1.00 34.55           C  
ATOM    594  CG1 ILE A 499      17.356   5.642   9.696  1.00 34.25           C  
ATOM    595  CG2 ILE A 499      15.455   4.018  10.061  1.00 35.07           C  
ATOM    596  CD1 ILE A 499      16.999   6.605  10.863  1.00 35.99           C  
ATOM    597  N   VAL A 500      16.620   1.848  12.451  1.00 35.37           N  
ATOM    598  CA  VAL A 500      16.173   0.474  12.732  1.00 35.80           C  
ATOM    599  C   VAL A 500      14.719   0.267  12.284  1.00 35.49           C  
ATOM    600  O   VAL A 500      14.432  -0.743  11.611  1.00 35.25           O  
ATOM    601  CB  VAL A 500      16.380   0.055  14.220  1.00 36.25           C  
ATOM    602  CG1 VAL A 500      15.853  -1.371  14.456  1.00 35.60           C  
ATOM    603  CG2 VAL A 500      17.857   0.076  14.553  1.00 36.98           C  
ATOM    604  N   SER A 501      13.831   1.216  12.588  1.00 35.21           N  
ATOM    605  CA  SER A 501      12.436   1.123  12.149  1.00 34.20           C  
ATOM    606  C   SER A 501      11.858   2.522  11.899  1.00 35.46           C  
ATOM    607  O   SER A 501      12.351   3.481  12.498  1.00 33.36           O  
ATOM    608  CB  SER A 501      11.566   0.348  13.146  1.00 35.42           C  
ATOM    609  OG  SER A 501      11.367   1.028  14.388  1.00 37.41           O  
ATOM    610  N   VAL A 502      10.843   2.601  11.040  1.00 34.58           N  
ATOM    611  CA  VAL A 502      10.135   3.863  10.814  1.00 33.47           C  
ATOM    612  C   VAL A 502       8.636   3.567  10.821  1.00 33.13           C  
ATOM    613  O   VAL A 502       8.177   2.486  10.360  1.00 34.87           O  
ATOM    614  CB  VAL A 502      10.498   4.447   9.443  1.00 34.17           C  
ATOM    615  CG1 VAL A 502       9.799   5.765   9.204  1.00 35.18           C  
ATOM    616  CG2 VAL A 502      12.026   4.583   9.307  1.00 35.02           C  
ATOM    617  N   ASN A 503       7.880   4.488  11.394  1.00 33.90           N  
ATOM    618  CA  ASN A 503       6.441   4.318  11.402  1.00 32.87           C  
ATOM    619  C   ASN A 503       5.754   5.477  10.708  1.00 32.70           C  
ATOM    620  O   ASN A 503       6.409   6.281  10.025  1.00 34.52           O  
ATOM    621  CB  ASN A 503       5.949   4.090  12.835  1.00 33.46           C  
ATOM    622  CG  ASN A 503       6.238   5.249  13.712  1.00 33.24           C  
ATOM    623  OD1 ASN A 503       5.677   6.332  13.516  1.00 34.98           O  
ATOM    624  ND2 ASN A 503       7.120   5.042  14.666  1.00 37.14           N  
ATOM    625  N   LYS A 504       4.431   5.533  10.852  0.50 31.65           N  
ATOM    627  CA  LYS A 504       3.661   6.443  10.055  0.50 31.92           C  
ATOM    629  C   LYS A 504       3.886   7.916  10.457  0.50 30.60           C  
ATOM    631  O   LYS A 504       3.694   8.808   9.637  0.50 32.18           O  
ATOM    633  CB  LYS A 504       2.174   6.127  10.113  0.50 32.07           C  
ATOM    635  CG  LYS A 504       1.487   6.896   8.988  0.50 33.72           C  
ATOM    637  CD  LYS A 504      -0.026   6.817   8.921  0.50 35.88           C  
ATOM    639  CE  LYS A 504      -0.564   8.125   8.314  0.50 35.55           C  
ATOM    641  NZ  LYS A 504      -0.401   9.119   9.393  0.50 30.62           N  
ATOM    643  N   HIS A 505       4.284   8.127  11.693  1.00 31.36           N  
ATOM    644  CA  HIS A 505       4.350   9.492  12.268  1.00 30.88           C  
ATOM    645  C   HIS A 505       5.749   9.969  12.569  1.00 32.34           C  
ATOM    646  O   HIS A 505       5.952  11.157  12.776  1.00 30.69           O  
ATOM    647  CB  HIS A 505       3.489   9.567  13.551  1.00 31.40           C  
ATOM    648  CG  HIS A 505       2.238   8.733  13.447  1.00 31.55           C  
ATOM    649  ND1 HIS A 505       1.261   8.964  12.512  1.00 28.75           N  
ATOM    650  CD2 HIS A 505       1.864   7.608  14.111  1.00 33.20           C  
ATOM    651  CE1 HIS A 505       0.328   8.026  12.594  1.00 31.63           C  
ATOM    652  NE2 HIS A 505       0.671   7.204  13.568  1.00 30.87           N  
ATOM    653  N   ASN A 506       6.707   9.045  12.608  1.00 31.84           N  
ATOM    654  CA  ASN A 506       8.094   9.428  12.938  1.00 31.59           C  
ATOM    655  C   ASN A 506       9.006   8.251  12.648  1.00 32.91           C  
ATOM    656  O   ASN A 506       8.560   7.091  12.489  1.00 33.99           O  
ATOM    657  CB  ASN A 506       8.177   9.826  14.438  1.00 33.22           C  
ATOM    658  CG  ASN A 506       9.401  10.697  14.798  1.00 33.96           C  
ATOM    659  OD1 ASN A 506      10.189  11.136  13.965  1.00 30.68           O  
ATOM    660  ND2 ASN A 506       9.492  10.999  16.097  1.00 37.09           N  
ATOM    661  N   ILE A 507      10.305   8.543  12.663  1.00 31.80           N  
ATOM    662  CA  ILE A 507      11.302   7.485  12.771  1.00 34.54           C  
ATOM    663  C   ILE A 507      11.002   6.752  14.082  1.00 32.77           C  
ATOM    664  O   ILE A 507      10.540   7.383  15.076  1.00 33.60           O  
ATOM    665  CB  ILE A 507      12.690   8.126  12.703  1.00 35.16           C  
ATOM    666  CG1 ILE A 507      12.928   8.495  11.193  1.00 37.18           C  
ATOM    667  CG2 ILE A 507      13.730   7.119  13.138  1.00 35.33           C  
ATOM    668  CD1 ILE A 507      14.173   9.367  10.868  1.00 39.87           C  
ATOM    669  N   GLY A 508      11.200   5.450  14.065  1.00 31.95           N  
ATOM    670  CA  GLY A 508      10.929   4.539  15.193  1.00 34.22           C  
ATOM    671  C   GLY A 508      12.228   4.355  15.951  1.00 35.45           C  
ATOM    672  O   GLY A 508      12.739   5.290  16.574  1.00 37.29           O  
ATOM    673  N   LYS A 509      12.784   3.157  15.881  0.50 34.58           N  
ATOM    675  CA  LYS A 509      13.986   2.819  16.627  0.50 35.06           C  
ATOM    677  C   LYS A 509      15.239   3.274  15.868  0.50 34.32           C  
ATOM    679  O   LYS A 509      15.330   3.058  14.647  0.50 34.19           O  
ATOM    681  CB  LYS A 509      14.049   1.303  16.828  0.50 35.46           C  
ATOM    683  CG  LYS A 509      12.946   0.706  17.734  0.50 37.30           C  
ATOM    685  CD  LYS A 509      13.579  -0.186  18.818  0.50 41.11           C  
ATOM    687  CE  LYS A 509      14.605  -1.164  18.252  0.50 42.70           C  
ATOM    689  NZ  LYS A 509      14.017  -2.503  17.976  0.50 45.79           N  
ATOM    691  N   VAL A 510      16.194   3.885  16.586  1.00 33.95           N  
ATOM    692  CA  VAL A 510      17.513   4.310  16.023  1.00 34.44           C  
ATOM    693  C   VAL A 510      18.652   3.652  16.844  1.00 33.91           C  
ATOM    694  O   VAL A 510      18.612   3.693  18.060  1.00 34.58           O  
ATOM    695  CB  VAL A 510      17.669   5.838  16.140  1.00 34.64           C  
ATOM    696  CG1 VAL A 510      18.951   6.381  15.457  1.00 35.85           C  
ATOM    697  CG2 VAL A 510      16.452   6.481  15.453  1.00 38.59           C  
ATOM    698  N   ARG A 511      19.585   3.006  16.153  0.50 34.28           N  
ATOM    700  CA  ARG A 511      20.818   2.508  16.756  0.50 33.94           C  
ATOM    702  C   ARG A 511      21.883   3.603  16.632  0.50 34.55           C  
ATOM    704  O   ARG A 511      22.020   4.226  15.569  0.50 33.95           O  
ATOM    706  CB  ARG A 511      21.267   1.220  16.040  0.50 33.79           C  
ATOM    708  CG  ARG A 511      22.587   0.634  16.524  0.50 34.33           C  
ATOM    710  CD  ARG A 511      22.888  -0.724  15.879  0.50 35.63           C  
ATOM    712  NE  ARG A 511      21.858  -1.717  16.185  0.50 41.05           N  
ATOM    714  CZ  ARG A 511      20.907  -2.117  15.340  0.50 42.84           C  
ATOM    716  NH1 ARG A 511      20.024  -3.029  15.727  0.50 44.15           N  
ATOM    718  NH2 ARG A 511      20.841  -1.627  14.108  0.50 43.86           N  
ATOM    720  N   VAL A 512      22.644   3.839  17.704  1.00 34.68           N  
ATOM    721  CA  VAL A 512      23.678   4.863  17.647  1.00 35.98           C  
ATOM    722  C   VAL A 512      24.964   4.289  18.218  1.00 37.55           C  
ATOM    723  O   VAL A 512      24.977   3.722  19.312  1.00 36.74           O  
ATOM    724  CB  VAL A 512      23.273   6.189  18.389  1.00 37.49           C  
ATOM    725  CG1 VAL A 512      24.181   7.313  17.926  1.00 38.00           C  
ATOM    726  CG2 VAL A 512      21.828   6.605  18.046  1.00 36.70           C  
ATOM    727  N   HIS A 513      26.041   4.409  17.449  1.00 38.06           N  
ATOM    728  CA  HIS A 513      27.343   3.997  17.992  1.00 40.08           C  
ATOM    729  C   HIS A 513      28.421   4.935  17.449  1.00 41.53           C  
ATOM    730  O   HIS A 513      28.185   5.648  16.466  1.00 41.68           O  
ATOM    731  CB  HIS A 513      27.637   2.512  17.714  1.00 40.68           C  
ATOM    732  CG  HIS A 513      27.983   2.201  16.292  1.00 41.59           C  
ATOM    733  ND1 HIS A 513      27.031   2.113  15.299  1.00 44.51           N  
ATOM    734  CD2 HIS A 513      29.172   1.927  15.699  1.00 44.91           C  
ATOM    735  CE1 HIS A 513      27.619   1.809  14.154  1.00 44.65           C  
ATOM    736  NE2 HIS A 513      28.919   1.696  14.369  1.00 47.36           N  
ATOM    737  N   ARG A 514      29.577   4.976  18.109  1.00 43.81           N  
ATOM    738  CA  ARG A 514      30.629   5.896  17.669  1.00 47.42           C  
ATOM    739  C   ARG A 514      31.409   5.336  16.499  1.00 48.49           C  
ATOM    740  O   ARG A 514      31.486   4.121  16.342  1.00 49.65           O  
ATOM    741  CB  ARG A 514      31.563   6.269  18.821  1.00 47.30           C  
ATOM    742  CG  ARG A 514      31.006   7.355  19.731  1.00 49.05           C  
ATOM    743  CD  ARG A 514      32.006   7.677  20.818  1.00 53.48           C  
ATOM    744  NE  ARG A 514      31.477   8.570  21.854  1.00 58.04           N  
ATOM    745  CZ  ARG A 514      31.230   8.222  23.122  1.00 59.44           C  
ATOM    746  NH1 ARG A 514      31.424   6.972  23.552  1.00 60.76           N  
ATOM    747  NH2 ARG A 514      30.769   9.131  23.974  1.00 60.89           N  
ATOM    748  N   THR A 515      31.923   6.245  15.665  1.00 49.94           N  
ATOM    749  CA  THR A 515      32.895   5.954  14.593  1.00 51.49           C  
ATOM    750  C   THR A 515      32.245   5.678  13.245  1.00 51.79           C  
ATOM    751  O   THR A 515      31.854   6.604  12.516  1.00 53.05           O  
ATOM    752  CB  THR A 515      33.813   4.779  14.980  1.00 51.37           C  
ATOM    753  OG1 THR A 515      34.432   5.061  16.240  1.00 51.77           O  
ATOM    754  CG2 THR A 515      34.860   4.558  13.922  1.00 52.63           C  
TER     755      THR A 515                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
