
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   77 (  664),  selected   77 , name 2p4p_B
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2p4p_B.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      D       5           -
LGA    -       -      E       6           -
LGA    -       -      I       7           -
LGA    -       -      V       8           -
LGA    -       -      Q       9           -
LGA    -       -      R      10           -
LGA    -       -      E      11           -
LGA    -       -      D      12           -
LGA    D     6_B      G      13          1.583
LGA    S     7_B      S      14          0.718
LGA    W     8_B      W      15          0.588
LGA    L     9_B      L      16          0.793
LGA    I    10_B      V      17          0.678
LGA    D    11_B      D      18          0.231
LGA    G    12_B      G      19          0.386
LGA    A    13_B      M      20          0.610
LGA    T    14_B      V      21          0.462
LGA    P    15_B      S      22          0.553
LGA    L    16_B      L      23          1.657
LGA    E    17_B      D      24          2.140
LGA    D    18_B      R      25          1.429
LGA    V    19_B      F      26          1.141
LGA    X    20_B      R      27          1.809
LGA    R    21_B      E      28          1.877
LGA    A    22_B      F      29          1.214
LGA    L    23_B      F      30          1.165
LGA    N    24_B      E      31          1.100
LGA    I    25_B      L      32          0.946
LGA    H    26_B      E      33          1.551
LGA    T    27_B      A      34          1.153
LGA    F    28_B      P      35          0.622
LGA    -       -      L      36           -
LGA    -       -      P      37           -
LGA    P    29_B      G      38          3.810
LGA    R    30_B      E      39          1.889
LGA    -       -      A      40           -
LGA    D    31_B      G      41          2.068
LGA    E    32_B      G      42          3.291
LGA    N    33_B      N      43          2.091
LGA    Y    34_B      I      44          4.497
LGA    E    35_B      H      45          1.558
LGA    T    36_B      T      46          0.398
LGA    I    37_B      L      47          0.412
LGA    G    38_B      A      48          0.852
LGA    G    39_B      G      49          0.680
LGA    F    40_B      V      50          0.570
LGA    X    41_B      M      51          1.283
LGA    X    42_B      L      52          1.149
LGA    Y    43_B      Y      53          0.346
LGA    X    44_B      Q      54          1.014
LGA    L    45_B      L      55          1.241
LGA    R    46_B      G      56          2.655
LGA    X    47_B      R      57          5.799
LGA    I    48_B      V      58          2.295
LGA    P    49_B      P      59          0.701
LGA    X    50_B      S      60          0.767
LGA    X    51_B      V      61          0.651
LGA    T    52_B      T      62          0.497
LGA    D    53_B      D      63          0.471
LGA    F    54_B      R      64          0.929
LGA    V    55_B      F      65          2.303
LGA    L    56_B      E      66          1.357
LGA    Y    57_B      W      67          1.201
LGA    D    58_B      N      68          1.181
LGA    X    59_B      G      69          1.205
LGA    Y    60_B      F      70          0.479
LGA    X    61_B      S      71          0.373
LGA    F    62_B      F      72          0.667
LGA    E    63_B      E      73          0.683
LGA    I    64_B      V      74          0.596
LGA    I    65_B      V      75          0.957
LGA    D    66_B      D      76          0.414
LGA    T    67_B      M      77          0.710
LGA    E    68_B      D      78          0.993
LGA    N    69_B      R      79          3.760
LGA    F    70_B      T      80          1.041
LGA    R    71_B      R      81          1.686
LGA    I    72_B      V      82          0.648
LGA    D    73_B      D      83          0.263
LGA    Q    74_B      K      84          0.517
LGA    L    75_B      I      85          0.788
LGA    X    76_B      L      86          0.825
LGA    V    77_B      V      87          0.765
LGA    S    78_B      Q      88          1.367
LGA    F    79_B      R      89          2.954
LGA    -       -      H      90           -
LGA    R    80_B      H      91           #
LGA    X    81_B      -       -           -
LGA    D    82_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   77   87    5.0     74    1.63    27.03     79.835     4.289

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.844814 * X  +  -0.258610 * Y  +  -0.468412 * Z  +  15.753993
  Y_new =  -0.090430 * X  +   0.793835 * Y  +  -0.601372 * Z  + -42.164627
  Z_new =   0.527363 * X  +   0.550406 * Y  +   0.647257 * Z  + -26.197535 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.704708   -2.436885  [ DEG:    40.3768   -139.6232 ]
  Theta =  -0.555494   -2.586099  [ DEG:   -31.8275   -148.1725 ]
  Phi   =  -0.106635    3.034958  [ DEG:    -6.1097    173.8903 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p4p_B                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p4p_B.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   77   87   5.0   74   1.63   27.03  79.835
REMARK  ---------------------------------------------------------- 
MOLECULE 2p4p_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   12-MAR-07   2P4P              
TITLE     CRYSTAL STRUCTURE OF A CORC_HLYC DOMAIN FROM HAEMOPHILUS              
TITLE    2 DUCREYI                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN HD1797;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CORC_HLYC DOMAIN, RESIDUES 347-429;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS DUCREYI;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 35000HP;                                                     
SOURCE   5 ATCC: 700724;                                                        
SOURCE   6 GENE: TLYC, HD_1797;                                                 
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    HAEMOPHILUS DUCREYI, CORC_HLYC, PFAM: PF03471, STRUCTURAL             
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, MCSG                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,L.VOLKART,S.MOY,A.JOACHIMIAK,MIDWEST CENTER FOR              
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   22-MAY-07 2P4P    0                                                
JRNL        AUTH   M.E.CUFF,L.VOLKART,S.MOY,A.JOACHIMIAK                        
JRNL        TITL   THE STRUCTURE OF A CORC_HLYC DOMAIN FROM                     
JRNL        TITL 2 HAEMOPHILUS DUCREYI                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2P4P A    1    83  UNP    Q7VKS4   Q7VKS4_HAEDU   347    429             
DBREF  2P4P B    1    83  UNP    Q7VKS4   Q7VKS4_HAEDU   347    429             
SEQRES   1 A   86  SER ASN ALA MSE ARG ARG ASN GLU ASP SER TRP LEU ILE          
SEQRES   2 A   86  ASP GLY ALA THR PRO LEU GLU ASP VAL MSE ARG ALA LEU          
SEQRES   3 A   86  ASN ILE HIS THR PHE PRO ARG ASP GLU ASN TYR GLU THR          
SEQRES   4 A   86  ILE GLY GLY PHE MSE MSE TYR MSE LEU ARG MLY ILE PRO          
SEQRES   5 A   86  MLY MLY THR ASP PHE VAL LEU TYR ASP MLY TYR MLY PHE          
SEQRES   6 A   86  GLU ILE ILE ASP THR GLU ASN PHE ARG ILE ASP GLN LEU          
SEQRES   7 A   86  MSE VAL SER PHE ARG MLY ASP VAL                              
SEQRES   1 B   86  SER ASN ALA MSE ARG ARG ASN GLU ASP SER TRP LEU ILE          
SEQRES   2 B   86  ASP GLY ALA THR PRO LEU GLU ASP VAL MSE ARG ALA LEU          
SEQRES   3 B   86  ASN ILE HIS THR PHE PRO ARG ASP GLU ASN TYR GLU THR          
SEQRES   4 B   86  ILE GLY GLY PHE MSE MSE TYR MSE LEU ARG MLY ILE PRO          
SEQRES   5 B   86  MLY MLY THR ASP PHE VAL LEU TYR ASP MLY TYR MLY PHE          
SEQRES   6 B   86  GLU ILE ILE ASP THR GLU ASN PHE ARG ILE ASP GLN LEU          
SEQRES   7 B   86  MSE VAL SER PHE ARG MLY ASP VAL                              
HET    MSE  A   1       8                                                       
HET    MSE  A  20       8                                                       
HET    MSE  A  41       8                                                       
HET    MSE  A  42       8                                                       
HET    MSE  A  44       8                                                       
HET    MLY  A  47      11                                                       
HET    MLY  A  50      11                                                       
HET    MLY  A  51      11                                                       
HET    MLY  A  59      11                                                       
HET    MLY  A  61      11                                                       
HET    MSE  A  76       8                                                       
HET    MLY  A  81      11                                                       
HET    MSE  B  20       8                                                       
HET    MSE  B  41       8                                                       
HET    MSE  B  42      16                                                       
HET    MSE  B  44       8                                                       
HET    MLY  B  47      11                                                       
HET    MLY  B  50      11                                                       
HET    MLY  B  51      11                                                       
HET    MLY  B  59      11                                                       
HET    MLY  B  61      11                                                       
HET    MSE  B  76      13                                                       
HET    MLY  B  81      11                                                       
HET     CA    201       1                                                       
HET     MG    301       1                                                       
HET    GOL    401       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     MLY N-DIMETHYL-LYSINE                                                
HETNAM      CA CALCIUM ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   1  MLY    12(C8 H18 N2 O2)                                             
FORMUL   3   CA    CA 2+                                                        
FORMUL   4   MG    MG 2+                                                        
FORMUL   5  GOL    C3 H8 O3                                                     
FORMUL   6  HOH   *98(H2 O)                                                     
CRYST1   29.552   58.667   87.434  90.00  90.00  90.00 P 21 21 21    8          
ATOM    731  N   ASP B   6      29.081   0.303  23.492  1.00 40.62           N  
ATOM    732  CA  ASP B   6      29.079  -0.252  22.106  1.00 40.17           C  
ATOM    733  C   ASP B   6      27.948   0.278  21.199  1.00 38.90           C  
ATOM    734  O   ASP B   6      28.227   1.025  20.259  1.00 38.67           O  
ATOM    735  CB  ASP B   6      29.033  -1.771  22.144  1.00 41.09           C  
ATOM    736  CG  ASP B   6      28.899  -2.369  20.779  1.00 43.09           C  
ATOM    737  OD1 ASP B   6      29.885  -2.333  20.015  1.00 47.33           O  
ATOM    738  OD2 ASP B   6      27.802  -2.877  20.469  1.00 47.82           O  
ATOM    739  N   SER B   7      26.701  -0.149  21.452  1.00 37.11           N  
ATOM    740  CA  SER B   7      25.531   0.318  20.687  1.00 35.36           C  
ATOM    741  C   SER B   7      24.305   0.538  21.559  1.00 33.44           C  
ATOM    742  O   SER B   7      24.000  -0.271  22.426  1.00 33.72           O  
ATOM    743  CB  SER B   7      25.176  -0.644  19.558  1.00 35.93           C  
ATOM    744  OG  SER B   7      26.253  -0.771  18.644  1.00 37.22           O  
ATOM    745  N   TRP B   8      23.581   1.619  21.297  1.00 30.58           N  
ATOM    746  CA  TRP B   8      22.469   2.010  22.147  1.00 27.46           C  
ATOM    747  C   TRP B   8      21.152   2.175  21.351  1.00 27.11           C  
ATOM    748  O   TRP B   8      21.115   2.896  20.370  1.00 26.50           O  
ATOM    749  CB  TRP B   8      22.874   3.301  22.841  1.00 27.43           C  
ATOM    750  CG  TRP B   8      21.990   3.801  23.912  1.00 28.27           C  
ATOM    751  CD1 TRP B   8      21.068   3.092  24.647  1.00 29.57           C  
ATOM    752  CD2 TRP B   8      22.021   5.117  24.468  1.00 26.98           C  
ATOM    753  NE1 TRP B   8      20.484   3.912  25.592  1.00 27.66           N  
ATOM    754  CE2 TRP B   8      21.051   5.161  25.500  1.00 29.07           C  
ATOM    755  CE3 TRP B   8      22.750   6.271  24.171  1.00 28.91           C  
ATOM    756  CZ2 TRP B   8      20.793   6.322  26.238  1.00 29.21           C  
ATOM    757  CZ3 TRP B   8      22.487   7.431  24.898  1.00 28.30           C  
ATOM    758  CH2 TRP B   8      21.516   7.440  25.927  1.00 30.34           C  
ATOM    759  N   LEU B   9      20.098   1.508  21.804  1.00 25.67           N  
ATOM    760  CA  LEU B   9      18.763   1.596  21.214  1.00 25.96           C  
ATOM    761  C   LEU B   9      17.910   2.694  21.823  1.00 25.70           C  
ATOM    762  O   LEU B   9      17.652   2.671  23.024  1.00 25.83           O  
ATOM    763  CB  LEU B   9      18.014   0.300  21.434  1.00 26.53           C  
ATOM    764  CG  LEU B   9      17.765  -0.706  20.325  1.00 29.48           C  
ATOM    765  CD1 LEU B   9      17.031  -0.094  19.129  1.00 30.77           C  
ATOM    766  CD2 LEU B   9      19.081  -1.338  19.946  1.00 31.50           C  
ATOM    767  N   ILE B  10      17.407   3.598  20.984  1.00 24.87           N  
ATOM    768  CA  ILE B  10      16.731   4.833  21.453  1.00 26.28           C  
ATOM    769  C   ILE B  10      15.449   5.035  20.637  1.00 25.68           C  
ATOM    770  O   ILE B  10      15.389   4.684  19.448  1.00 25.51           O  
ATOM    771  CB  ILE B  10      17.676   6.075  21.277  1.00 25.62           C  
ATOM    772  CG1 ILE B  10      18.878   5.947  22.233  1.00 28.69           C  
ATOM    773  CG2 ILE B  10      16.946   7.422  21.560  1.00 28.02           C  
ATOM    774  CD1 ILE B  10      20.052   6.910  21.943  1.00 28.14           C  
ATOM    775  N   ASP B  11      14.432   5.600  21.271  1.00 25.81           N  
ATOM    776  CA  ASP B  11      13.180   5.914  20.575  1.00 26.66           C  
ATOM    777  C   ASP B  11      13.337   7.188  19.751  1.00 26.11           C  
ATOM    778  O   ASP B  11      13.923   8.185  20.218  1.00 25.60           O  
ATOM    779  CB  ASP B  11      12.062   6.131  21.579  1.00 27.81           C  
ATOM    780  CG  ASP B  11      11.599   4.863  22.208  1.00 30.55           C  
ATOM    781  OD1 ASP B  11      12.253   3.810  22.033  1.00 36.13           O  
ATOM    782  OD2 ASP B  11      10.572   4.926  22.902  1.00 36.58           O  
ATOM    783  N   GLY B  12      12.799   7.182  18.535  1.00 25.55           N  
ATOM    784  CA  GLY B  12      12.896   8.358  17.659  1.00 24.26           C  
ATOM    785  C   GLY B  12      12.221   9.591  18.237  1.00 24.66           C  
ATOM    786  O   GLY B  12      12.582  10.710  17.925  1.00 24.34           O  
ATOM    787  N   ALA B  13      11.224   9.391  19.087  1.00 24.81           N  
ATOM    788  CA  ALA B  13      10.506  10.525  19.673  1.00 24.99           C  
ATOM    789  C   ALA B  13      11.225  11.180  20.856  1.00 25.03           C  
ATOM    790  O   ALA B  13      10.717  12.158  21.413  1.00 24.56           O  
ATOM    791  CB  ALA B  13       9.068  10.107  20.056  1.00 24.09           C  
ATOM    792  N   THR B  14      12.386  10.634  21.247  1.00 26.75           N  
ATOM    793  CA  THR B  14      13.150  11.149  22.404  1.00 25.84           C  
ATOM    794  C   THR B  14      13.565  12.588  22.085  1.00 25.29           C  
ATOM    795  O   THR B  14      14.087  12.866  21.000  1.00 24.79           O  
ATOM    796  CB  THR B  14      14.456  10.313  22.688  1.00 27.68           C  
ATOM    797  OG1 THR B  14      14.177   8.900  22.710  1.00 27.44           O  
ATOM    798  CG2 THR B  14      15.106  10.731  23.997  1.00 26.00           C  
ATOM    799  N   PRO B  15      13.312  13.523  23.011  1.00 23.23           N  
ATOM    800  CA  PRO B  15      13.724  14.901  22.713  1.00 22.56           C  
ATOM    801  C   PRO B  15      15.186  15.007  22.292  1.00 22.22           C  
ATOM    802  O   PRO B  15      16.056  14.384  22.916  1.00 22.17           O  
ATOM    803  CB  PRO B  15      13.487  15.645  24.028  1.00 21.82           C  
ATOM    804  CG  PRO B  15      12.379  14.846  24.738  1.00 22.44           C  
ATOM    805  CD  PRO B  15      12.630  13.385  24.314  1.00 23.88           C  
ATOM    806  N   LEU B  16      15.451  15.775  21.239  1.00 22.01           N  
ATOM    807  CA  LEU B  16      16.802  15.891  20.670  1.00 22.49           C  
ATOM    808  C   LEU B  16      17.828  16.242  21.732  1.00 23.00           C  
ATOM    809  O   LEU B  16      18.814  15.564  21.896  1.00 21.23           O  
ATOM    810  CB  LEU B  16      16.866  16.950  19.559  1.00 23.25           C  
ATOM    811  CG  LEU B  16      18.290  17.226  19.026  1.00 22.48           C  
ATOM    812  CD1 LEU B  16      18.774  15.999  18.251  1.00 22.86           C  
ATOM    813  CD2 LEU B  16      18.296  18.395  18.106  1.00 25.06           C  
ATOM    814  N   GLU B  17      17.570  17.320  22.462  1.00 23.31           N  
ATOM    815  CA  GLU B  17      18.480  17.804  23.496  1.00 24.69           C  
ATOM    816  C   GLU B  17      18.915  16.769  24.532  1.00 24.06           C  
ATOM    817  O   GLU B  17      20.017  16.875  25.080  1.00 22.47           O  
ATOM    818  CB  GLU B  17      17.826  18.973  24.241  1.00 25.11           C  
ATOM    819  CG  GLU B  17      17.904  20.291  23.497  1.00 31.06           C  
ATOM    820  CD  GLU B  17      17.060  20.302  22.228  1.00 37.40           C  
ATOM    821  OE1 GLU B  17      17.098  21.311  21.470  1.00 38.06           O  
ATOM    822  OE2 GLU B  17      16.339  19.307  22.002  1.00 40.74           O  
ATOM    823  N   ASP B  18      18.020  15.820  24.822  1.00 24.12           N  
ATOM    824  CA  ASP B  18      18.248  14.752  25.796  1.00 24.26           C  
ATOM    825  C   ASP B  18      19.266  13.759  25.264  1.00 23.61           C  
ATOM    826  O   ASP B  18      20.149  13.292  26.007  1.00 22.39           O  
ATOM    827  CB  ASP B  18      16.940  14.002  26.053  1.00 25.23           C  
ATOM    828  CG  ASP B  18      16.024  14.734  27.035  1.00 27.25           C  
ATOM    829  OD1 ASP B  18      16.419  15.801  27.500  1.00 29.32           O  
ATOM    830  OD2 ASP B  18      14.928  14.227  27.328  1.00 28.04           O  
ATOM    831  N   VAL B  19      19.109  13.397  24.003  1.00 23.24           N  
ATOM    832  CA  VAL B  19      20.012  12.429  23.395  1.00 23.64           C  
ATOM    833  C   VAL B  19      21.379  13.095  23.229  1.00 24.25           C  
ATOM    834  O   VAL B  19      22.409  12.507  23.548  1.00 25.35           O  
ATOM    835  CB  VAL B  19      19.494  11.922  21.992  1.00 24.30           C  
ATOM    836  CG1 VAL B  19      20.473  10.952  21.368  1.00 26.09           C  
ATOM    837  CG2 VAL B  19      18.108  11.259  22.119  1.00 24.52           C  
HETATM  838  N   MSE B  20      21.388  14.331  22.732  1.00 24.76           N  
HETATM  839  CA  MSE B  20      22.645  15.055  22.494  1.00 24.70           C  
HETATM  840  C   MSE B  20      23.478  15.109  23.752  1.00 24.67           C  
HETATM  841  O   MSE B  20      24.662  14.793  23.709  1.00 23.93           O  
HETATM  842  CB  MSE B  20      22.383  16.481  22.004  1.00 25.34           C  
HETATM  843  CG  MSE B  20      21.745  16.583  20.623  1.00 27.70           C  
HETATM  844 SE   MSE B  20      22.834  15.876  19.168  1.00 36.18          SE  
HETATM  845  CE  MSE B  20      22.109  14.057  19.047  1.00 25.95           C  
ATOM    846  N   ARG B  21      22.849  15.473  24.877  1.00 23.73           N  
ATOM    847  CA  ARG B  21      23.555  15.618  26.150  1.00 24.56           C  
ATOM    848  C   ARG B  21      24.036  14.276  26.694  1.00 24.82           C  
ATOM    849  O   ARG B  21      25.119  14.200  27.263  1.00 24.76           O  
ATOM    850  CB  ARG B  21      22.694  16.316  27.221  1.00 24.21           C  
ATOM    851  CG  ARG B  21      23.455  16.600  28.518  1.00 22.88           C  
ATOM    852  CD  ARG B  21      24.657  17.547  28.239  1.00 21.74           C  
ATOM    853  NE  ARG B  21      25.536  17.754  29.396  1.00 23.31           N  
ATOM    854  CZ  ARG B  21      26.545  16.958  29.724  1.00 25.25           C  
ATOM    855  NH1 ARG B  21      27.295  17.254  30.766  1.00 25.79           N  
ATOM    856  NH2 ARG B  21      26.803  15.859  29.008  1.00 27.13           N  
ATOM    857  N   ALA B  22      23.203  13.245  26.568  1.00 24.40           N  
ATOM    858  CA  ALA B  22      23.593  11.885  26.961  1.00 24.65           C  
ATOM    859  C   ALA B  22      24.847  11.407  26.236  1.00 24.65           C  
ATOM    860  O   ALA B  22      25.648  10.634  26.816  1.00 25.12           O  
ATOM    861  CB  ALA B  22      22.452  10.895  26.760  1.00 23.65           C  
ATOM    862  N   LEU B  23      25.024  11.875  24.997  1.00 24.63           N  
ATOM    863  CA  LEU B  23      26.175  11.512  24.136  1.00 25.00           C  
ATOM    864  C   LEU B  23      27.343  12.484  24.231  1.00 24.64           C  
ATOM    865  O   LEU B  23      28.384  12.318  23.564  1.00 24.24           O  
ATOM    866  CB  LEU B  23      25.729  11.393  22.670  1.00 24.61           C  
ATOM    867  CG  LEU B  23      24.709  10.293  22.441  1.00 26.04           C  
ATOM    868  CD1 LEU B  23      24.215  10.300  21.005  1.00 25.54           C  
ATOM    869  CD2 LEU B  23      25.354   8.954  22.826  1.00 22.90           C  
ATOM    870  N   ASN B  24      27.158  13.505  25.062  1.00 24.79           N  
ATOM    871  CA  ASN B  24      28.135  14.565  25.252  1.00 25.86           C  
ATOM    872  C   ASN B  24      28.417  15.406  24.004  1.00 25.24           C  
ATOM    873  O   ASN B  24      29.549  15.872  23.769  1.00 26.11           O  
ATOM    874  CB  ASN B  24      29.401  13.996  25.893  1.00 26.99           C  
ATOM    875  CG  ASN B  24      29.129  13.453  27.270  1.00 29.39           C  
ATOM    876  OD1 ASN B  24      28.858  14.205  28.205  1.00 32.48           O  
ATOM    877  ND2 ASN B  24      29.136  12.125  27.392  1.00 33.24           N  
ATOM    878  N   ILE B  25      27.363  15.608  23.223  1.00 25.46           N  
ATOM    879  CA  ILE B  25      27.428  16.403  22.003  1.00 25.22           C  
ATOM    880  C   ILE B  25      26.943  17.805  22.352  1.00 25.84           C  
ATOM    881  O   ILE B  25      25.755  18.026  22.610  1.00 26.44           O  
ATOM    882  CB  ILE B  25      26.564  15.807  20.884  1.00 25.00           C  
ATOM    883  CG1 ILE B  25      27.027  14.391  20.528  1.00 24.83           C  
ATOM    884  CG2 ILE B  25      26.601  16.700  19.638  1.00 24.44           C  
ATOM    885  CD1 ILE B  25      25.972  13.603  19.747  1.00 23.59           C  
ATOM    886  N   HIS B  26      27.867  18.750  22.388  1.00 25.81           N  
ATOM    887  CA  HIS B  26      27.524  20.082  22.851  1.00 27.30           C  
ATOM    888  C   HIS B  26      27.230  21.036  21.698  1.00 27.45           C  
ATOM    889  O   HIS B  26      26.637  22.103  21.899  1.00 28.45           O  
ATOM    890  CB  HIS B  26      28.616  20.589  23.793  1.00 28.21           C  
ATOM    891  CG  HIS B  26      28.763  19.740  25.022  1.00 31.71           C  
ATOM    892  ND1 HIS B  26      27.916  19.845  26.109  1.00 33.21           N  
ATOM    893  CD2 HIS B  26      29.638  18.747  25.320  1.00 34.67           C  
ATOM    894  CE1 HIS B  26      28.267  18.958  27.025  1.00 34.11           C  
ATOM    895  NE2 HIS B  26      29.315  18.287  26.576  1.00 35.41           N  
ATOM    896  N   THR B  27      27.630  20.651  20.491  0.50 26.29           N  
ATOM    898  CA  THR B  27      27.391  21.486  19.314  0.50 25.99           C  
ATOM    900  C   THR B  27      26.544  20.764  18.285  0.50 26.16           C  
ATOM    902  O   THR B  27      27.024  19.853  17.596  0.50 26.05           O  
ATOM    904  CB  THR B  27      28.720  22.039  18.724  0.50 25.98           C  
ATOM    906  OG1 THR B  27      29.270  22.986  19.646  0.50 25.84           O  
ATOM    908  CG2 THR B  27      28.502  22.718  17.351  0.50 24.31           C  
ATOM    910  N   PHE B  28      25.277  21.166  18.191  1.00 26.10           N  
ATOM    911  CA  PHE B  28      24.320  20.495  17.300  1.00 26.53           C  
ATOM    912  C   PHE B  28      23.313  21.424  16.629  1.00 25.52           C  
ATOM    913  O   PHE B  28      23.001  22.486  17.160  1.00 25.68           O  
ATOM    914  CB  PHE B  28      23.600  19.314  18.001  1.00 26.53           C  
ATOM    915  CG  PHE B  28      22.855  19.707  19.231  1.00 28.94           C  
ATOM    916  CD1 PHE B  28      21.491  20.021  19.165  1.00 29.47           C  
ATOM    917  CD2 PHE B  28      23.505  19.760  20.464  1.00 27.13           C  
ATOM    918  CE1 PHE B  28      20.795  20.385  20.305  1.00 29.73           C  
ATOM    919  CE2 PHE B  28      22.819  20.129  21.600  1.00 29.16           C  
ATOM    920  CZ  PHE B  28      21.455  20.443  21.527  1.00 29.75           C  
ATOM    921  N   PRO B  29      22.810  21.018  15.459  1.00 26.67           N  
ATOM    922  CA  PRO B  29      21.890  21.841  14.686  1.00 26.69           C  
ATOM    923  C   PRO B  29      20.535  22.033  15.352  1.00 27.49           C  
ATOM    924  O   PRO B  29      19.945  21.090  15.867  1.00 26.79           O  
ATOM    925  CB  PRO B  29      21.719  21.038  13.403  1.00 27.80           C  
ATOM    926  CG  PRO B  29      22.957  20.190  13.319  1.00 26.90           C  
ATOM    927  CD  PRO B  29      23.083  19.759  14.746  1.00 25.87           C  
ATOM    928  N   ARG B  30      20.048  23.265  15.343  1.00 27.38           N  
ATOM    929  CA  ARG B  30      18.681  23.486  15.733  1.00 27.46           C  
ATOM    930  C   ARG B  30      18.047  24.655  14.983  1.00 26.96           C  
ATOM    931  O   ARG B  30      18.737  25.489  14.372  1.00 24.47           O  
ATOM    932  CB  ARG B  30      18.580  23.653  17.257  1.00 28.95           C  
ATOM    933  CG  ARG B  30      19.205  24.906  17.787  1.00 29.76           C  
ATOM    934  CD  ARG B  30      19.461  24.771  19.256  1.00 36.39           C  
ATOM    935  NE  ARG B  30      18.352  25.285  20.039  1.00 40.30           N  
ATOM    936  CZ  ARG B  30      18.340  26.470  20.630  1.00 42.28           C  
ATOM    937  NH1 ARG B  30      17.281  26.839  21.332  1.00 42.83           N  
ATOM    938  NH2 ARG B  30      19.389  27.280  20.532  1.00 45.23           N  
ATOM    939  N   ASP B  31      16.718  24.705  15.040  1.00 27.34           N  
ATOM    940  CA  ASP B  31      15.974  25.859  14.542  1.00 28.26           C  
ATOM    941  C   ASP B  31      15.055  26.361  15.650  1.00 28.34           C  
ATOM    942  O   ASP B  31      15.360  26.199  16.841  1.00 29.01           O  
ATOM    943  CB  ASP B  31      15.187  25.511  13.268  1.00 28.19           C  
ATOM    944  CG  ASP B  31      14.486  24.177  13.355  1.00 30.31           C  
ATOM    945  OD1 ASP B  31      13.724  23.939  14.316  1.00 31.67           O  
ATOM    946  OD2 ASP B  31      14.708  23.339  12.458  1.00 31.94           O  
ATOM    947  N   GLU B  32      13.936  26.970  15.274  1.00 28.48           N  
ATOM    948  CA  GLU B  32      13.014  27.509  16.268  1.00 28.85           C  
ATOM    949  C   GLU B  32      11.949  26.491  16.674  1.00 28.11           C  
ATOM    950  O   GLU B  32      11.096  26.777  17.501  1.00 27.54           O  
ATOM    951  CB  GLU B  32      12.365  28.794  15.757  1.00 28.65           C  
ATOM    952  CG  GLU B  32      13.145  30.053  16.122  1.00 31.67           C  
ATOM    953  CD  GLU B  32      12.744  31.257  15.287  1.00 34.75           C  
ATOM    954  OE1 GLU B  32      12.095  32.182  15.827  1.00 34.90           O  
ATOM    955  OE2 GLU B  32      13.072  31.269  14.079  1.00 37.53           O  
ATOM    956  N   ASN B  33      11.996  25.305  16.075  1.00 27.58           N  
ATOM    957  CA  ASN B  33      11.012  24.284  16.405  1.00 27.28           C  
ATOM    958  C   ASN B  33      11.529  23.256  17.388  1.00 26.85           C  
ATOM    959  O   ASN B  33      12.712  22.901  17.381  1.00 26.57           O  
ATOM    960  CB  ASN B  33      10.509  23.582  15.144  1.00 27.95           C  
ATOM    961  CG  ASN B  33       9.962  24.562  14.101  1.00 27.73           C  
ATOM    962  OD1 ASN B  33       9.241  25.489  14.428  1.00 27.50           O  
ATOM    963  ND2 ASN B  33      10.328  24.352  12.840  1.00 29.15           N  
ATOM    964  N   TYR B  34      10.620  22.777  18.236  1.00 26.05           N  
ATOM    965  CA  TYR B  34      10.907  21.665  19.132  1.00 25.13           C  
ATOM    966  C   TYR B  34      11.384  20.498  18.263  1.00 25.23           C  
ATOM    967  O   TYR B  34      10.813  20.264  17.189  1.00 25.76           O  
ATOM    968  CB  TYR B  34       9.640  21.294  19.925  1.00 25.53           C  
ATOM    969  CG  TYR B  34       9.834  20.069  20.740  1.00 25.66           C  
ATOM    970  CD1 TYR B  34      10.582  20.105  21.919  1.00 26.05           C  
ATOM    971  CD2 TYR B  34       9.338  18.846  20.298  1.00 25.39           C  
ATOM    972  CE1 TYR B  34      10.794  18.947  22.658  1.00 27.84           C  
ATOM    973  CE2 TYR B  34       9.531  17.706  21.034  1.00 27.90           C  
ATOM    974  CZ  TYR B  34      10.266  17.755  22.202  1.00 25.98           C  
ATOM    975  OH  TYR B  34      10.456  16.598  22.907  1.00 24.37           O  
ATOM    976  N   GLU B  35      12.438  19.799  18.696  1.00 23.63           N  
ATOM    977  CA  GLU B  35      13.033  18.733  17.899  1.00 23.36           C  
ATOM    978  C   GLU B  35      13.248  17.434  18.670  1.00 23.38           C  
ATOM    979  O   GLU B  35      13.475  17.428  19.881  1.00 20.30           O  
ATOM    980  CB  GLU B  35      14.362  19.183  17.286  1.00 24.47           C  
ATOM    981  CG  GLU B  35      14.823  18.308  16.113  1.00 25.31           C  
ATOM    982  CD  GLU B  35      13.736  18.165  15.054  1.00 29.27           C  
ATOM    983  OE1 GLU B  35      12.801  17.344  15.248  1.00 27.87           O  
ATOM    984  OE2 GLU B  35      13.831  18.878  14.029  1.00 28.02           O  
ATOM    985  N   THR B  36      13.225  16.329  17.919  1.00 23.50           N  
ATOM    986  CA  THR B  36      13.421  15.007  18.461  1.00 23.67           C  
ATOM    987  C   THR B  36      14.587  14.399  17.733  1.00 24.85           C  
ATOM    988  O   THR B  36      15.045  14.902  16.709  1.00 24.42           O  
ATOM    989  CB  THR B  36      12.142  14.088  18.267  1.00 23.92           C  
ATOM    990  OG1 THR B  36      11.898  13.841  16.861  1.00 22.78           O  
ATOM    991  CG2 THR B  36      10.914  14.742  18.883  1.00 24.17           C  
ATOM    992  N   ILE B  37      15.082  13.304  18.261  1.00 24.49           N  
ATOM    993  CA  ILE B  37      16.233  12.715  17.650  1.00 24.77           C  
ATOM    994  C   ILE B  37      15.812  12.232  16.268  1.00 24.23           C  
ATOM    995  O   ILE B  37      16.484  12.566  15.299  1.00 24.32           O  
ATOM    996  CB  ILE B  37      16.929  11.674  18.584  1.00 25.12           C  
ATOM    997  CG1 ILE B  37      18.096  11.023  17.855  1.00 25.17           C  
ATOM    998  CG2 ILE B  37      15.933  10.610  19.114  1.00 26.92           C  
ATOM    999  CD1 ILE B  37      19.280  11.951  17.666  1.00 29.25           C  
ATOM   1000  N   GLY B  38      14.678  11.520  16.167  1.00 24.46           N  
ATOM   1001  CA  GLY B  38      14.066  11.156  14.868  1.00 23.34           C  
ATOM   1002  C   GLY B  38      13.912  12.319  13.908  1.00 22.80           C  
ATOM   1003  O   GLY B  38      14.249  12.201  12.760  1.00 22.08           O  
ATOM   1004  N   GLY B  39      13.435  13.463  14.395  1.00 21.31           N  
ATOM   1005  CA  GLY B  39      13.301  14.674  13.583  1.00 22.60           C  
ATOM   1006  C   GLY B  39      14.623  15.192  13.048  1.00 21.91           C  
ATOM   1007  O   GLY B  39      14.714  15.569  11.880  1.00 22.64           O  
ATOM   1008  N   PHE B  40      15.646  15.182  13.895  1.00 22.98           N  
ATOM   1009  CA  PHE B  40      16.949  15.666  13.526  1.00 23.59           C  
ATOM   1010  C   PHE B  40      17.501  14.751  12.444  1.00 25.07           C  
ATOM   1011  O   PHE B  40      18.044  15.214  11.437  1.00 24.78           O  
ATOM   1012  CB  PHE B  40      17.856  15.617  14.741  1.00 26.11           C  
ATOM   1013  CG  PHE B  40      19.317  15.735  14.423  1.00 28.18           C  
ATOM   1014  CD1 PHE B  40      19.841  16.937  13.957  1.00 29.99           C  
ATOM   1015  CD2 PHE B  40      20.172  14.637  14.604  1.00 31.63           C  
ATOM   1016  CE1 PHE B  40      21.205  17.042  13.673  1.00 31.92           C  
ATOM   1017  CE2 PHE B  40      21.537  14.731  14.325  1.00 33.69           C  
ATOM   1018  CZ  PHE B  40      22.048  15.937  13.859  1.00 31.25           C  
HETATM 1019  N   MSE B  41      17.327  13.459  12.644  1.00 23.74           N  
HETATM 1020  CA  MSE B  41      17.836  12.482  11.676  1.00 27.15           C  
HETATM 1021  C   MSE B  41      17.151  12.637  10.335  1.00 26.06           C  
HETATM 1022  O   MSE B  41      17.800  12.541   9.292  1.00 26.50           O  
HETATM 1023  CB  MSE B  41      17.685  11.049  12.175  1.00 25.04           C  
HETATM 1024  CG  MSE B  41      18.670  10.647  13.282  1.00 27.37           C  
HETATM 1025 SE   MSE B  41      18.090   8.934  14.062  1.00 35.79          SE  
HETATM 1026  CE  MSE B  41      18.665   7.691  12.729  1.00 22.91           C  
HETATM 1027  N   MSE B  42      15.849  12.880  10.344  0.50 26.08           N  
HETATM 1029  CA  MSE B  42      15.150  13.123   9.089  0.50 26.93           C  
HETATM 1031  C   MSE B  42      15.622  14.393   8.375  0.50 25.85           C  
HETATM 1033  O   MSE B  42      15.737  14.412   7.151  0.50 25.41           O  
HETATM 1035  CB  MSE B  42      13.637  13.076   9.281  0.50 26.23           C  
HETATM 1037  CG  MSE B  42      13.132  11.637   9.301  0.50 26.63           C  
HETATM 1039 SE   MSE B  42      11.245  11.437   9.656  0.50 32.47          SE  
HETATM 1041  CE  MSE B  42      10.544  12.103   7.963  0.50 26.60           C  
ATOM   1043  N   TYR B  43      15.916  15.438   9.146  1.00 25.46           N  
ATOM   1044  CA  TYR B  43      16.551  16.628   8.582  1.00 25.66           C  
ATOM   1045  C   TYR B  43      17.901  16.304   7.925  1.00 25.61           C  
ATOM   1046  O   TYR B  43      18.142  16.692   6.768  1.00 25.07           O  
ATOM   1047  CB  TYR B  43      16.729  17.737   9.636  1.00 25.70           C  
ATOM   1048  CG  TYR B  43      17.675  18.799   9.114  1.00 25.45           C  
ATOM   1049  CD1 TYR B  43      17.257  19.696   8.128  1.00 25.28           C  
ATOM   1050  CD2 TYR B  43      19.009  18.863   9.564  1.00 25.20           C  
ATOM   1051  CE1 TYR B  43      18.142  20.673   7.615  1.00 24.85           C  
ATOM   1052  CE2 TYR B  43      19.891  19.830   9.063  1.00 26.39           C  
ATOM   1053  CZ  TYR B  43      19.448  20.716   8.080  1.00 25.09           C  
ATOM   1054  OH  TYR B  43      20.326  21.654   7.586  1.00 25.91           O  
HETATM 1055  N   MSE B  44      18.767  15.588   8.654  1.00 25.34           N  
HETATM 1056  CA  MSE B  44      20.113  15.206   8.143  1.00 25.53           C  
HETATM 1057  C   MSE B  44      20.104  14.232   6.960  1.00 25.41           C  
HETATM 1058  O   MSE B  44      20.967  14.298   6.103  1.00 24.44           O  
HETATM 1059  CB  MSE B  44      20.978  14.621   9.271  1.00 25.58           C  
HETATM 1060  CG  MSE B  44      21.238  15.565  10.416  1.00 27.49           C  
HETATM 1061 SE   MSE B  44      22.451  17.064   9.978  1.00 36.09          SE  
HETATM 1062  CE  MSE B  44      24.047  16.029   9.520  1.00 30.92           C  
ATOM   1063  N   LEU B  45      19.125  13.330   6.917  1.00 25.82           N  
ATOM   1064  CA  LEU B  45      18.963  12.371   5.799  1.00 26.57           C  
ATOM   1065  C   LEU B  45      18.439  13.019   4.522  1.00 26.77           C  
ATOM   1066  O   LEU B  45      18.838  12.638   3.425  1.00 26.49           O  
ATOM   1067  CB  LEU B  45      17.979  11.259   6.189  1.00 26.64           C  
ATOM   1068  CG  LEU B  45      18.540  10.111   7.012  1.00 29.47           C  
ATOM   1069  CD1 LEU B  45      17.377   9.426   7.718  1.00 32.31           C  
ATOM   1070  CD2 LEU B  45      19.296   9.141   6.113  1.00 32.13           C  
ATOM   1071  N   ARG B  46      17.517  13.966   4.695  1.00 27.72           N  
ATOM   1072  CA  ARG B  46      16.826  14.721   3.618  1.00 29.33           C  
ATOM   1073  C   ARG B  46      15.870  13.866   2.803  1.00 30.51           C  
ATOM   1074  O   ARG B  46      14.724  14.275   2.553  1.00 31.45           O  
ATOM   1075  CB  ARG B  46      17.813  15.477   2.710  1.00 29.53           C  
ATOM   1076  CG  ARG B  46      18.679  16.487   3.461  1.00 29.39           C  
ATOM   1077  CD  ARG B  46      19.331  17.473   2.528  1.00 27.14           C  
ATOM   1078  NE  ARG B  46      18.348  18.365   1.937  1.00 31.13           N  
ATOM   1079  CZ  ARG B  46      17.782  19.386   2.575  1.00 30.59           C  
ATOM   1080  NH1 ARG B  46      16.874  20.121   1.949  1.00 33.31           N  
ATOM   1081  NH2 ARG B  46      18.121  19.667   3.828  1.00 30.28           N  
HETATM 1082  N   MLY B  47      16.365  12.700   2.384  1.00 30.84           N  
HETATM 1083  CA  MLY B  47      15.590  11.626   1.785  1.00 31.69           C  
HETATM 1084  CB  MLY B  47      16.594  10.532   1.425  1.00 32.23           C  
HETATM 1085  CG  MLY B  47      16.842  10.408  -0.062  1.00 33.74           C  
HETATM 1086  CD  MLY B  47      16.053   9.240  -0.637  1.00 37.93           C  
HETATM 1087  CE  MLY B  47      15.017   9.757  -1.636  1.00 39.29           C  
HETATM 1088  NZ  MLY B  47      13.598   9.510  -1.272  1.00 40.28           N  
HETATM 1089  CH1 MLY B  47      13.414   8.349  -0.391  1.00 40.35           C  
HETATM 1090  CH2 MLY B  47      13.001  10.734  -0.699  1.00 39.18           C  
HETATM 1091  C   MLY B  47      14.610  11.024   2.761  1.00 31.27           C  
HETATM 1092  O   MLY B  47      14.825  11.051   3.969  1.00 31.62           O  
ATOM   1093  N   ILE B  48      13.516  10.477   2.237  1.00 30.15           N  
ATOM   1094  CA  ILE B  48      12.548   9.749   3.058  1.00 29.38           C  
ATOM   1095  C   ILE B  48      13.208   8.539   3.751  1.00 28.71           C  
ATOM   1096  O   ILE B  48      13.911   7.748   3.090  1.00 29.24           O  
ATOM   1097  CB  ILE B  48      11.284   9.385   2.241  1.00 29.55           C  
ATOM   1098  CG1 ILE B  48      10.452  10.654   2.016  1.00 28.38           C  
ATOM   1099  CG2 ILE B  48      10.475   8.312   2.921  1.00 30.02           C  
ATOM   1100  CD1 ILE B  48       9.502  10.574   0.886  1.00 30.19           C  
ATOM   1101  N   PRO B  49      12.990   8.414   5.079  1.00 27.75           N  
ATOM   1102  CA  PRO B  49      13.623   7.433   5.985  1.00 27.75           C  
ATOM   1103  C   PRO B  49      13.205   5.985   5.711  1.00 27.77           C  
ATOM   1104  O   PRO B  49      12.012   5.692   5.542  1.00 28.33           O  
ATOM   1105  CB  PRO B  49      13.160   7.896   7.386  1.00 27.72           C  
ATOM   1106  CG  PRO B  49      11.855   8.603   7.123  1.00 27.84           C  
ATOM   1107  CD  PRO B  49      12.096   9.330   5.822  1.00 26.56           C  
HETATM 1108  N   MLY B  50      14.194   5.101   5.658  1.00 26.79           N  
HETATM 1109  CA  MLY B  50      13.999   3.663   5.431  1.00 26.77           C  
HETATM 1110  CB  MLY B  50      14.328   3.279   3.968  1.00 27.13           C  
HETATM 1111  CG  MLY B  50      15.428   2.225   3.745  1.00 30.30           C  
HETATM 1112  CD  MLY B  50      15.002   0.916   3.051  1.00 34.29           C  
HETATM 1113  CE  MLY B  50      15.093  -0.326   3.950  1.00 37.29           C  
HETATM 1114  NZ  MLY B  50      15.483  -1.543   3.200  1.00 40.48           N  
HETATM 1115  CH1 MLY B  50      16.816  -1.996   3.625  1.00 40.44           C  
HETATM 1116  CH2 MLY B  50      14.512  -2.630   3.415  1.00 39.53           C  
HETATM 1117  C   MLY B  50      14.874   2.964   6.431  1.00 26.41           C  
HETATM 1118  O   MLY B  50      15.967   3.429   6.705  1.00 25.21           O  
HETATM 1119  N   MLY B  51      14.398   1.862   7.011  1.00 25.98           N  
HETATM 1120  CA  MLY B  51      15.267   0.975   7.790  1.00 26.23           C  
HETATM 1121  CB  MLY B  51      14.555  -0.380   7.863  1.00 26.34           C  
HETATM 1122  CG  MLY B  51      15.261  -1.359   8.790  1.00 29.95           C  
HETATM 1123  CD  MLY B  51      14.452  -2.636   9.046  1.00 34.69           C  
HETATM 1124  CE  MLY B  51      13.524  -3.081   7.914  1.00 37.54           C  
HETATM 1125  NZ  MLY B  51      13.465  -4.555   7.836  1.00 39.80           N  
HETATM 1126  CH1 MLY B  51      12.561  -5.095   8.867  1.00 40.79           C  
HETATM 1127  CH2 MLY B  51      12.979  -4.980   6.510  1.00 40.82           C  
HETATM 1128  C   MLY B  51      16.626   0.829   7.130  1.00 25.77           C  
HETATM 1129  O   MLY B  51      16.712   0.684   5.903  1.00 24.76           O  
ATOM   1130  N   THR B  52      17.681   0.847   7.945  1.00 25.35           N  
ATOM   1131  CA  THR B  52      19.096   0.793   7.542  1.00 25.91           C  
ATOM   1132  C   THR B  52      19.699   2.132   7.142  1.00 25.37           C  
ATOM   1133  O   THR B  52      20.905   2.272   7.218  1.00 25.72           O  
ATOM   1134  CB  THR B  52      19.441  -0.273   6.466  1.00 25.94           C  
ATOM   1135  OG1 THR B  52      19.096   0.236   5.170  1.00 27.74           O  
ATOM   1136  CG2 THR B  52      18.746  -1.600   6.752  1.00 26.39           C  
ATOM   1137  N   ASP B  53      18.896   3.102   6.699  1.00 25.50           N  
ATOM   1138  CA  ASP B  53      19.429   4.460   6.465  1.00 25.11           C  
ATOM   1139  C   ASP B  53      20.190   4.908   7.744  1.00 25.11           C  
ATOM   1140  O   ASP B  53      19.815   4.524   8.866  1.00 24.97           O  
ATOM   1141  CB  ASP B  53      18.325   5.486   6.173  1.00 25.37           C  
ATOM   1142  CG  ASP B  53      17.679   5.345   4.793  1.00 28.53           C  
ATOM   1143  OD1 ASP B  53      18.121   4.539   3.940  1.00 29.65           O  
ATOM   1144  OD2 ASP B  53      16.678   6.073   4.578  1.00 31.64           O  
ATOM   1145  N   PHE B  54      21.246   5.698   7.576  1.00 24.09           N  
ATOM   1146  CA  PHE B  54      22.015   6.212   8.737  1.00 23.70           C  
ATOM   1147  C   PHE B  54      22.475   7.668   8.591  1.00 23.83           C  
ATOM   1148  O   PHE B  54      22.607   8.187   7.462  1.00 23.69           O  
ATOM   1149  CB  PHE B  54      23.204   5.293   9.109  1.00 23.43           C  
ATOM   1150  CG  PHE B  54      24.303   5.233   8.084  1.00 23.99           C  
ATOM   1151  CD1 PHE B  54      25.324   6.197   8.062  1.00 21.63           C  
ATOM   1152  CD2 PHE B  54      24.357   4.177   7.189  1.00 24.24           C  
ATOM   1153  CE1 PHE B  54      26.338   6.152   7.143  1.00 25.82           C  
ATOM   1154  CE2 PHE B  54      25.385   4.103   6.252  1.00 27.46           C  
ATOM   1155  CZ  PHE B  54      26.388   5.093   6.230  1.00 25.14           C  
ATOM   1156  N   VAL B  55      22.715   8.291   9.740  1.00 22.74           N  
ATOM   1157  CA  VAL B  55      23.224   9.652   9.854  1.00 23.68           C  
ATOM   1158  C   VAL B  55      24.547   9.580  10.630  1.00 23.36           C  
ATOM   1159  O   VAL B  55      24.639   8.924  11.656  1.00 23.02           O  
ATOM   1160  CB  VAL B  55      22.221  10.568  10.660  1.00 23.67           C  
ATOM   1161  CG1 VAL B  55      22.815  11.970  10.961  1.00 24.88           C  
ATOM   1162  CG2 VAL B  55      20.915  10.696   9.936  1.00 26.63           C  
ATOM   1163  N   LEU B  56      25.565  10.278  10.149  1.00 23.17           N  
ATOM   1164  CA  LEU B  56      26.798  10.403  10.913  1.00 23.77           C  
ATOM   1165  C   LEU B  56      26.836  11.812  11.459  1.00 24.27           C  
ATOM   1166  O   LEU B  56      26.676  12.806  10.698  1.00 25.96           O  
ATOM   1167  CB  LEU B  56      28.014  10.197  10.047  1.00 22.11           C  
ATOM   1168  CG  LEU B  56      28.037   8.864   9.295  1.00 22.18           C  
ATOM   1169  CD1 LEU B  56      29.222   8.891   8.426  1.00 21.96           C  
ATOM   1170  CD2 LEU B  56      28.103   7.703  10.259  1.00 21.37           C  
ATOM   1171  N   TYR B  57      27.012  11.910  12.769  1.00 23.93           N  
ATOM   1172  CA  TYR B  57      27.167  13.221  13.439  1.00 23.11           C  
ATOM   1173  C   TYR B  57      28.084  13.116  14.660  1.00 22.48           C  
ATOM   1174  O   TYR B  57      27.948  12.175  15.454  1.00 21.91           O  
ATOM   1175  CB  TYR B  57      25.840  13.822  13.879  1.00 24.10           C  
ATOM   1176  CG  TYR B  57      25.984  15.277  14.191  1.00 24.94           C  
ATOM   1177  CD1 TYR B  57      26.029  16.210  13.163  1.00 24.39           C  
ATOM   1178  CD2 TYR B  57      26.114  15.723  15.518  1.00 25.16           C  
ATOM   1179  CE1 TYR B  57      26.185  17.557  13.451  1.00 25.78           C  
ATOM   1180  CE2 TYR B  57      26.310  17.051  15.808  1.00 25.56           C  
ATOM   1181  CZ  TYR B  57      26.335  17.961  14.753  1.00 25.93           C  
ATOM   1182  OH  TYR B  57      26.509  19.290  15.006  1.00 25.75           O  
ATOM   1183  N   ASP B  58      28.952  14.115  14.842  1.00 22.49           N  
ATOM   1184  CA  ASP B  58      29.937  14.108  15.941  1.00 21.85           C  
ATOM   1185  C   ASP B  58      30.650  12.749  15.928  1.00 22.12           C  
ATOM   1186  O   ASP B  58      31.114  12.320  14.862  1.00 21.89           O  
ATOM   1187  CB  ASP B  58      29.256  14.407  17.297  1.00 21.82           C  
ATOM   1188  CG  ASP B  58      30.256  14.654  18.424  1.00 23.94           C  
ATOM   1189  OD1 ASP B  58      30.610  15.817  18.642  1.00 25.42           O  
ATOM   1190  OD2 ASP B  58      30.661  13.679  19.092  1.00 24.11           O  
HETATM 1191  N   MLY B  59      30.725  12.057  17.065  1.00 23.03           N  
HETATM 1192  CA  MLY B  59      31.453  10.764  17.110  1.00 23.83           C  
HETATM 1193  CB  MLY B  59      31.955  10.535  18.537  1.00 24.05           C  
HETATM 1194  CG  MLY B  59      33.158  11.413  18.840  1.00 25.84           C  
HETATM 1195  CD  MLY B  59      33.580  11.324  20.301  1.00 26.76           C  
HETATM 1196  CE  MLY B  59      32.561  11.936  21.252  1.00 26.90           C  
HETATM 1197  NZ  MLY B  59      32.326  13.385  21.110  1.00 27.90           N  
HETATM 1198  CH1 MLY B  59      31.439  13.801  22.202  1.00 29.71           C  
HETATM 1199  CH2 MLY B  59      33.542  14.226  21.168  1.00 29.01           C  
HETATM 1200  C   MLY B  59      30.648   9.546  16.717  1.00 23.48           C  
HETATM 1201  O   MLY B  59      31.127   8.390  16.812  1.00 22.75           O  
ATOM   1202  N   TYR B  60      29.424   9.779  16.253  1.00 23.60           N  
ATOM   1203  CA  TYR B  60      28.399   8.735  16.231  1.00 24.41           C  
ATOM   1204  C   TYR B  60      27.689   8.485  14.896  1.00 25.07           C  
ATOM   1205  O   TYR B  60      27.484   9.405  14.081  1.00 24.65           O  
ATOM   1206  CB  TYR B  60      27.326   9.071  17.256  1.00 24.79           C  
ATOM   1207  CG  TYR B  60      27.874   9.361  18.647  1.00 24.62           C  
ATOM   1208  CD1 TYR B  60      28.303   8.332  19.490  1.00 25.71           C  
ATOM   1209  CD2 TYR B  60      27.938  10.667  19.124  1.00 26.63           C  
ATOM   1210  CE1 TYR B  60      28.814   8.615  20.777  1.00 23.33           C  
ATOM   1211  CE2 TYR B  60      28.434  10.953  20.376  1.00 25.94           C  
ATOM   1212  CZ  TYR B  60      28.852   9.931  21.213  1.00 26.84           C  
ATOM   1213  OH  TYR B  60      29.331  10.256  22.468  1.00 24.15           O  
HETATM 1214  N   MLY B  61      27.237   7.237  14.767  1.00 23.64           N  
HETATM 1215  CA  MLY B  61      26.343   6.764  13.722  1.00 24.30           C  
HETATM 1216  CB  MLY B  61      26.883   5.462  13.089  1.00 23.06           C  
HETATM 1217  CG  MLY B  61      25.987   4.733  12.072  1.00 22.57           C  
HETATM 1218  CD  MLY B  61      26.653   3.440  11.531  1.00 25.60           C  
HETATM 1219  CE  MLY B  61      25.839   2.753  10.436  1.00 22.47           C  
HETATM 1220  NZ  MLY B  61      26.301   1.381  10.019  1.00 24.92           N  
HETATM 1221  CH1 MLY B  61      25.172   0.669   9.408  1.00 27.19           C  
HETATM 1222  CH2 MLY B  61      27.324   1.489   8.983  1.00 24.97           C  
HETATM 1223  C   MLY B  61      24.998   6.548  14.351  1.00 24.76           C  
HETATM 1224  O   MLY B  61      24.874   5.949  15.439  1.00 25.30           O  
ATOM   1225  N   PHE B  62      23.985   7.106  13.701  1.00 24.72           N  
ATOM   1226  CA  PHE B  62      22.611   7.000  14.143  1.00 25.48           C  
ATOM   1227  C   PHE B  62      21.915   6.211  13.026  1.00 24.80           C  
ATOM   1228  O   PHE B  62      21.707   6.766  11.964  1.00 24.80           O  
ATOM   1229  CB  PHE B  62      22.023   8.389  14.244  1.00 26.44           C  
ATOM   1230  CG  PHE B  62      22.665   9.262  15.302  1.00 25.17           C  
ATOM   1231  CD1 PHE B  62      23.813  10.039  15.014  1.00 26.85           C  
ATOM   1232  CD2 PHE B  62      22.140   9.306  16.591  1.00 26.34           C  
ATOM   1233  CE1 PHE B  62      24.412  10.837  16.009  1.00 25.28           C  
ATOM   1234  CE2 PHE B  62      22.720  10.136  17.593  1.00 26.16           C  
ATOM   1235  CZ  PHE B  62      23.871  10.891  17.294  1.00 26.53           C  
ATOM   1236  N   GLU B  63      21.609   4.927  13.250  1.00 24.79           N  
ATOM   1237  CA  GLU B  63      20.955   4.048  12.234  1.00 23.36           C  
ATOM   1238  C   GLU B  63      19.457   3.807  12.497  1.00 22.84           C  
ATOM   1239  O   GLU B  63      19.072   3.474  13.606  1.00 22.18           O  
ATOM   1240  CB  GLU B  63      21.683   2.698  12.136  1.00 23.92           C  
ATOM   1241  CG  GLU B  63      21.060   1.734  11.131  1.00 23.14           C  
ATOM   1242  CD  GLU B  63      21.786   0.414  11.070  1.00 25.23           C  
ATOM   1243  OE1 GLU B  63      22.864   0.332  11.664  1.00 28.20           O  
ATOM   1244  OE2 GLU B  63      21.283  -0.545  10.446  1.00 31.63           O  
ATOM   1245  N   ILE B  64      18.634   3.916  11.448  1.00 22.34           N  
ATOM   1246  CA  ILE B  64      17.209   3.636  11.533  1.00 21.42           C  
ATOM   1247  C   ILE B  64      16.975   2.153  11.706  1.00 21.87           C  
ATOM   1248  O   ILE B  64      17.336   1.352  10.829  1.00 21.54           O  
ATOM   1249  CB  ILE B  64      16.441   4.162  10.300  1.00 20.21           C  
ATOM   1250  CG1 ILE B  64      16.692   5.677  10.107  1.00 21.45           C  
ATOM   1251  CG2 ILE B  64      14.941   3.894  10.469  1.00 21.01           C  
ATOM   1252  CD1 ILE B  64      16.029   6.283   8.831  1.00 23.22           C  
ATOM   1253  N   ILE B  65      16.369   1.798  12.841  1.00 22.68           N  
ATOM   1254  CA  ILE B  65      15.963   0.399  13.116  1.00 23.08           C  
ATOM   1255  C   ILE B  65      14.511   0.150  12.717  1.00 23.50           C  
ATOM   1256  O   ILE B  65      14.194  -0.902  12.184  1.00 23.27           O  
ATOM   1257  CB  ILE B  65      16.192   0.024  14.617  1.00 23.33           C  
ATOM   1258  CG1 ILE B  65      17.690   0.122  14.970  1.00 23.67           C  
ATOM   1259  CG2 ILE B  65      15.606  -1.391  14.972  1.00 23.83           C  
ATOM   1260  CD1 ILE B  65      18.671  -0.829  14.158  1.00 26.63           C  
ATOM   1261  N   ASP B  66      13.633   1.118  12.974  1.00 23.36           N  
ATOM   1262  CA  ASP B  66      12.259   1.001  12.506  1.00 24.98           C  
ATOM   1263  C   ASP B  66      11.663   2.343  12.196  1.00 25.00           C  
ATOM   1264  O   ASP B  66      11.949   3.331  12.905  1.00 25.68           O  
ATOM   1265  CB  ASP B  66      11.389   0.272  13.550  1.00 23.93           C  
ATOM   1266  CG  ASP B  66       9.958   0.023  13.054  1.00 26.92           C  
ATOM   1267  OD1 ASP B  66       9.764  -0.503  11.925  1.00 29.11           O  
ATOM   1268  OD2 ASP B  66       9.014   0.336  13.808  1.00 29.28           O  
ATOM   1269  N   THR B  67      10.865   2.385  11.130  1.00 24.89           N  
ATOM   1270  CA  THR B  67       9.984   3.515  10.900  1.00 26.12           C  
ATOM   1271  C   THR B  67       8.572   3.041  11.180  1.00 26.20           C  
ATOM   1272  O   THR B  67       8.172   1.925  10.796  1.00 25.60           O  
ATOM   1273  CB  THR B  67      10.020   4.049   9.455  1.00 26.32           C  
ATOM   1274  OG1 THR B  67       9.683   2.993   8.544  1.00 28.16           O  
ATOM   1275  CG2 THR B  67      11.404   4.621   9.114  1.00 27.13           C  
ATOM   1276  N   GLU B  68       7.808   3.901  11.828  1.00 26.20           N  
ATOM   1277  CA  GLU B  68       6.431   3.587  12.138  1.00 27.63           C  
ATOM   1278  C   GLU B  68       5.698   4.907  12.083  1.00 26.61           C  
ATOM   1279  O   GLU B  68       6.193   5.919  12.615  1.00 26.54           O  
ATOM   1280  CB  GLU B  68       6.320   2.917  13.526  1.00 28.08           C  
ATOM   1281  CG  GLU B  68       5.221   1.837  13.629  1.00 32.14           C  
ATOM   1282  CD  GLU B  68       5.679   0.437  13.177  1.00 35.67           C  
ATOM   1283  OE1 GLU B  68       6.667   0.342  12.407  1.00 38.49           O  
ATOM   1284  OE2 GLU B  68       5.051  -0.574  13.584  1.00 37.96           O  
ATOM   1285  N   ASN B  69       4.568   4.917  11.377  1.00 26.28           N  
ATOM   1286  CA  ASN B  69       3.729   6.116  11.290  1.00 25.53           C  
ATOM   1287  C   ASN B  69       4.471   7.339  10.725  1.00 24.04           C  
ATOM   1288  O   ASN B  69       4.324   8.444  11.224  1.00 23.39           O  
ATOM   1289  CB  ASN B  69       3.160   6.449  12.679  1.00 25.78           C  
ATOM   1290  CG  ASN B  69       2.150   7.570  12.649  1.00 29.00           C  
ATOM   1291  OD1 ASN B  69       1.287   7.647  11.754  1.00 26.31           O  
ATOM   1292  ND2 ASN B  69       2.242   8.461  13.641  1.00 32.35           N  
ATOM   1293  N   PHE B  70       5.254   7.135   9.675  1.00 23.22           N  
ATOM   1294  CA  PHE B  70       5.882   8.251   8.941  1.00 23.31           C  
ATOM   1295  C   PHE B  70       6.985   8.963   9.717  1.00 24.68           C  
ATOM   1296  O   PHE B  70       7.494  10.009   9.294  1.00 24.84           O  
ATOM   1297  CB  PHE B  70       4.840   9.228   8.336  1.00 23.01           C  
ATOM   1298  CG  PHE B  70       3.739   8.529   7.607  1.00 21.56           C  
ATOM   1299  CD1 PHE B  70       4.024   7.708   6.500  1.00 22.63           C  
ATOM   1300  CD2 PHE B  70       2.434   8.624   8.059  1.00 19.79           C  
ATOM   1301  CE1 PHE B  70       2.975   7.028   5.818  1.00 20.39           C  
ATOM   1302  CE2 PHE B  70       1.390   7.956   7.404  1.00 21.20           C  
ATOM   1303  CZ  PHE B  70       1.664   7.154   6.275  1.00 21.26           C  
ATOM   1304  N   ARG B  71       7.366   8.365  10.842  1.00 26.08           N  
ATOM   1305  CA  ARG B  71       8.466   8.904  11.626  0.60 26.73           C  
ATOM   1307  C   ARG B  71       9.494   7.791  11.872  1.00 26.59           C  
ATOM   1308  O   ARG B  71       9.215   6.601  11.676  1.00 26.07           O  
ATOM   1309  CB  ARG B  71       7.970   9.513  12.951  0.60 27.50           C  
ATOM   1311  CG  ARG B  71       6.861  10.561  12.841  0.60 30.03           C  
ATOM   1313  CD  ARG B  71       7.347  11.984  12.516  0.60 33.59           C  
ATOM   1315  NE  ARG B  71       8.035  12.649  13.631  0.60 37.38           N  
ATOM   1317  CZ  ARG B  71       8.097  13.973  13.798  0.60 37.52           C  
ATOM   1319  NH1 ARG B  71       7.502  14.783  12.932  0.60 38.06           N  
ATOM   1321  NH2 ARG B  71       8.740  14.492  14.837  0.60 36.57           N  
ATOM   1323  N   ILE B  72      10.715   8.186  12.233  1.00 26.33           N  
ATOM   1324  CA  ILE B  72      11.743   7.216  12.656  1.00 24.87           C  
ATOM   1325  C   ILE B  72      11.342   6.787  14.053  1.00 25.50           C  
ATOM   1326  O   ILE B  72      11.234   7.637  14.958  1.00 24.57           O  
ATOM   1327  CB  ILE B  72      13.152   7.828  12.696  1.00 23.63           C  
ATOM   1328  CG1 ILE B  72      13.587   8.236  11.285  1.00 24.73           C  
ATOM   1329  CG2 ILE B  72      14.165   6.835  13.407  1.00 21.28           C  
ATOM   1330  CD1 ILE B  72      14.847   9.130  11.252  1.00 25.06           C  
ATOM   1331  N   ASP B  73      11.064   5.488  14.226  1.00 25.02           N  
ATOM   1332  CA  ASP B  73      10.452   5.060  15.474  1.00 26.49           C  
ATOM   1333  C   ASP B  73      11.517   4.626  16.478  1.00 26.62           C  
ATOM   1334  O   ASP B  73      11.463   5.024  17.646  1.00 26.88           O  
ATOM   1335  CB  ASP B  73       9.453   3.931  15.253  1.00 26.44           C  
ATOM   1336  CG  ASP B  73       8.630   3.640  16.499  1.00 30.87           C  
ATOM   1337  OD1 ASP B  73       7.957   4.563  17.024  1.00 32.99           O  
ATOM   1338  OD2 ASP B  73       8.677   2.500  16.959  1.00 33.84           O  
ATOM   1339  N   GLN B  74      12.444   3.798  16.004  1.00 25.33           N  
ATOM   1340  CA  GLN B  74      13.588   3.326  16.795  1.00 25.84           C  
ATOM   1341  C   GLN B  74      14.898   3.530  16.040  1.00 25.06           C  
ATOM   1342  O   GLN B  74      14.989   3.298  14.815  1.00 25.32           O  
ATOM   1343  CB  GLN B  74      13.463   1.829  17.126  1.00 25.76           C  
ATOM   1344  CG  GLN B  74      12.152   1.391  17.806  1.00 30.58           C  
ATOM   1345  CD  GLN B  74      12.141   1.581  19.313  1.00 35.44           C  
ATOM   1346  OE1 GLN B  74      13.129   2.005  19.921  1.00 37.45           O  
ATOM   1347  NE2 GLN B  74      11.000   1.260  19.929  1.00 40.24           N  
ATOM   1348  N   LEU B  75      15.944   3.857  16.776  1.00 25.09           N  
ATOM   1349  CA  LEU B  75      17.239   4.026  16.167  1.00 25.51           C  
ATOM   1350  C   LEU B  75      18.295   3.360  17.033  1.00 26.27           C  
ATOM   1351  O   LEU B  75      18.053   3.104  18.207  1.00 26.42           O  
ATOM   1352  CB  LEU B  75      17.578   5.498  15.987  1.00 26.02           C  
ATOM   1353  CG  LEU B  75      17.709   6.345  17.270  1.00 27.08           C  
ATOM   1354  CD1 LEU B  75      19.045   7.082  17.315  1.00 29.26           C  
ATOM   1355  CD2 LEU B  75      16.549   7.285  17.405  1.00 30.25           C  
HETATM 1356  N   MSE B  76      19.448   3.089  16.436  1.00 25.24           N  
HETATM 1357  CA  MSE B  76      20.585   2.542  17.150  0.70 26.50           C  
HETATM 1359  C   MSE B  76      21.706   3.572  17.092  1.00 25.63           C  
HETATM 1360  O   MSE B  76      22.034   4.070  16.016  1.00 25.55           O  
HETATM 1361  CB  MSE B  76      21.075   1.265  16.473  0.70 27.59           C  
HETATM 1363  CG  MSE B  76      22.281   0.670  17.122  0.70 31.93           C  
HETATM 1365 SE   MSE B  76      21.646  -0.435  18.573  0.70 46.10          SE  
HETATM 1367  CE  MSE B  76      21.858  -2.162  17.672  0.70 40.30           C  
ATOM   1369  N   VAL B  77      22.293   3.888  18.239  1.00 24.65           N  
ATOM   1370  CA  VAL B  77      23.488   4.758  18.255  1.00 24.00           C  
ATOM   1371  C   VAL B  77      24.757   3.881  18.378  1.00 22.77           C  
ATOM   1372  O   VAL B  77      24.793   2.953  19.165  1.00 23.32           O  
ATOM   1373  CB  VAL B  77      23.452   5.787  19.425  1.00 24.24           C  
ATOM   1374  CG1 VAL B  77      24.747   6.634  19.455  1.00 24.18           C  
ATOM   1375  CG2 VAL B  77      22.245   6.683  19.325  1.00 23.20           C  
ATOM   1376  N   SER B  78      25.787   4.149  17.585  1.00 22.62           N  
ATOM   1377  CA  SER B  78      27.066   3.480  17.771  1.00 22.59           C  
ATOM   1378  C   SER B  78      28.175   4.476  17.466  1.00 23.27           C  
ATOM   1379  O   SER B  78      27.922   5.539  16.905  1.00 21.87           O  
ATOM   1380  CB  SER B  78      27.180   2.276  16.826  1.00 23.79           C  
ATOM   1381  OG  SER B  78      27.064   2.713  15.474  1.00 25.32           O  
ATOM   1382  N   PHE B  79      29.400   4.137  17.845  1.00 23.28           N  
ATOM   1383  CA  PHE B  79      30.543   4.906  17.411  1.00 24.16           C  
ATOM   1384  C   PHE B  79      30.732   4.831  15.916  1.00 24.39           C  
ATOM   1385  O   PHE B  79      30.706   3.750  15.337  1.00 23.66           O  
ATOM   1386  CB  PHE B  79      31.806   4.375  18.079  1.00 24.25           C  
ATOM   1387  CG  PHE B  79      32.114   5.010  19.396  1.00 23.25           C  
ATOM   1388  CD1 PHE B  79      31.867   6.363  19.618  1.00 25.19           C  
ATOM   1389  CD2 PHE B  79      32.716   4.265  20.402  1.00 24.85           C  
ATOM   1390  CE1 PHE B  79      32.206   6.950  20.824  1.00 27.12           C  
ATOM   1391  CE2 PHE B  79      33.050   4.842  21.610  1.00 26.00           C  
ATOM   1392  CZ  PHE B  79      32.813   6.187  21.825  1.00 25.15           C  
ATOM   1393  N   ARG B  80      30.989   5.974  15.286  1.00 26.85           N  
ATOM   1394  CA  ARG B  80      31.389   5.932  13.874  1.00 28.78           C  
ATOM   1395  C   ARG B  80      32.788   5.343  13.660  1.00 29.89           C  
ATOM   1396  O   ARG B  80      33.587   5.264  14.585  1.00 30.14           O  
ATOM   1397  CB  ARG B  80      31.221   7.291  13.187  1.00 28.68           C  
ATOM   1398  CG  ARG B  80      32.228   8.317  13.558  1.00 29.65           C  
ATOM   1399  CD  ARG B  80      31.669   9.682  13.184  1.00 28.79           C  
ATOM   1400  NE  ARG B  80      31.758   9.887  11.738  1.00 25.21           N  
ATOM   1401  CZ  ARG B  80      31.553  11.059  11.177  1.00 24.50           C  
ATOM   1402  NH1 ARG B  80      31.229  12.085  11.932  1.00 21.67           N  
ATOM   1403  NH2 ARG B  80      31.667  11.205   9.870  1.00 23.83           N  
HETATM 1404  N   MLY B  81      33.060   4.914  12.428  1.00 30.98           N  
HETATM 1405  CA  MLY B  81      34.286   4.210  12.085  1.00 31.99           C  
HETATM 1406  CB  MLY B  81      33.850   2.789  11.733  1.00 31.85           C  
HETATM 1407  CG  MLY B  81      33.201   2.076  12.916  1.00 33.54           C  
HETATM 1408  CD  MLY B  81      32.447   0.807  12.524  1.00 35.63           C  
HETATM 1409  CE  MLY B  81      33.387  -0.276  11.989  1.00 36.49           C  
HETATM 1410  NZ  MLY B  81      32.719  -1.575  11.787  1.00 37.27           N  
HETATM 1411  CH1 MLY B  81      31.492  -1.430  10.986  1.00 37.37           C  
HETATM 1412  CH2 MLY B  81      33.645  -2.476  11.075  1.00 35.79           C  
HETATM 1413  C   MLY B  81      34.973   4.792  10.873  1.00 32.19           C  
HETATM 1414  O   MLY B  81      35.759   4.115  10.210  1.00 31.95           O  
ATOM   1415  N   ASP B  82      34.656   6.039  10.536  1.00 32.81           N  
ATOM   1416  CA  ASP B  82      35.239   6.679   9.359  1.00 32.49           C  
ATOM   1417  C   ASP B  82      36.225   7.798   9.741  1.00 33.15           C  
ATOM   1418  O   ASP B  82      36.240   8.276  10.897  1.00 34.33           O  
ATOM   1419  CB  ASP B  82      34.124   7.191   8.422  1.00 32.03           C  
ATOM   1420  CG  ASP B  82      33.149   8.173   9.120  1.00 30.99           C  
ATOM   1421  OD1 ASP B  82      32.702   7.873  10.244  1.00 29.93           O  
ATOM   1422  OD2 ASP B  82      32.802   9.220   8.521  1.00 30.67           O  
TER    1423      ASP B  82                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
