
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 (  724),  selected   84 , name 2p4p_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2p4p_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N    -1_A      D       5           -
LGA    A     0_A      E       6           -
LGA    X     1_A      I       7           -
LGA    R     2_A      V       8           -
LGA    R     3_A      Q       9           -
LGA    -       -      R      10           -
LGA    N     4_A      E      11           #
LGA    E     5_A      D      12          2.592
LGA    D     6_A      G      13          1.143
LGA    S     7_A      S      14          0.784
LGA    W     8_A      W      15          0.843
LGA    L     9_A      L      16          0.848
LGA    I    10_A      V      17          0.704
LGA    D    11_A      D      18          0.474
LGA    G    12_A      G      19          0.290
LGA    A    13_A      M      20          0.483
LGA    T    14_A      V      21          0.402
LGA    P    15_A      S      22          0.495
LGA    L    16_A      L      23          1.581
LGA    E    17_A      D      24          2.071
LGA    D    18_A      R      25          1.317
LGA    V    19_A      F      26          0.968
LGA    X    20_A      R      27          1.492
LGA    R    21_A      E      28          1.403
LGA    A    22_A      F      29          0.861
LGA    L    23_A      F      30          0.842
LGA    N    24_A      E      31          0.768
LGA    I    25_A      L      32          0.717
LGA    H    26_A      E      33          1.235
LGA    T    27_A      A      34          1.008
LGA    F    28_A      P      35          0.282
LGA    -       -      L      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    P    29_A      E      39          2.301
LGA    R    30_A      A      40          3.525
LGA    D    31_A      G      41          3.032
LGA    E    32_A      G      42          2.855
LGA    N    33_A      N      43          1.622
LGA    Y    34_A      I      44          1.618
LGA    E    35_A      H      45          1.487
LGA    T    36_A      T      46          0.390
LGA    I    37_A      L      47          0.454
LGA    G    38_A      A      48          0.963
LGA    G    39_A      G      49          0.792
LGA    F    40_A      V      50          0.767
LGA    X    41_A      M      51          1.244
LGA    X    42_A      L      52          1.217
LGA    Y    43_A      Y      53          0.496
LGA    X    44_A      Q      54          0.784
LGA    L    45_A      L      55          1.148
LGA    R    46_A      G      56          2.686
LGA    X    47_A      R      57          5.808
LGA    I    48_A      V      58          2.376
LGA    P    49_A      P      59          0.558
LGA    X    50_A      S      60          1.125
LGA    X    51_A      V      61          0.824
LGA    T    52_A      T      62          0.685
LGA    D    53_A      D      63          0.670
LGA    F    54_A      R      64          1.143
LGA    V    55_A      F      65          2.233
LGA    L    56_A      E      66          1.153
LGA    Y    57_A      W      67          1.336
LGA    D    58_A      N      68          1.401
LGA    X    59_A      G      69          1.421
LGA    Y    60_A      F      70          0.451
LGA    X    61_A      S      71          0.257
LGA    F    62_A      F      72          0.714
LGA    E    63_A      E      73          0.788
LGA    I    64_A      V      74          0.715
LGA    I    65_A      V      75          1.030
LGA    D    66_A      D      76          0.527
LGA    T    67_A      M      77          0.868
LGA    E    68_A      D      78          1.033
LGA    N    69_A      R      79          3.872
LGA    F    70_A      T      80          0.875
LGA    R    71_A      R      81          1.584
LGA    I    72_A      V      82          0.646
LGA    D    73_A      D      83          0.329
LGA    Q    74_A      K      84          0.634
LGA    L    75_A      I      85          0.778
LGA    X    76_A      L      86          1.033
LGA    V    77_A      V      87          0.706
LGA    S    78_A      Q      88          1.049
LGA    F    79_A      R      89          2.436
LGA    R    80_A      H      90          3.932
LGA    X    81_A      H      91           -
LGA    D    82_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   87    5.0     76    1.59    26.32     82.466     4.491

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.834091 * X  +   0.396418 * Y  +   0.383595 * Z  + -23.641134
  Y_new =  -0.068374 * X  +  -0.615730 * Y  +   0.784985 * Z  +  30.286110
  Z_new =   0.547374 * X  +  -0.680977 * Y  +  -0.486470 * Z  +  46.844036 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.191103    0.950490  [ DEG:  -125.5409     54.4591 ]
  Theta =  -0.579223   -2.562370  [ DEG:   -33.1870   -146.8130 ]
  Phi   =  -0.081791    3.059801  [ DEG:    -4.6863    175.3137 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p4p_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p4p_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   87   5.0   76   1.59   26.32  82.466
REMARK  ---------------------------------------------------------- 
MOLECULE 2p4p_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   12-MAR-07   2P4P              
TITLE     CRYSTAL STRUCTURE OF A CORC_HLYC DOMAIN FROM HAEMOPHILUS              
TITLE    2 DUCREYI                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN HD1797;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CORC_HLYC DOMAIN, RESIDUES 347-429;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS DUCREYI;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 35000HP;                                                     
SOURCE   5 ATCC: 700724;                                                        
SOURCE   6 GENE: TLYC, HD_1797;                                                 
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    HAEMOPHILUS DUCREYI, CORC_HLYC, PFAM: PF03471, STRUCTURAL             
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, MCSG                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,L.VOLKART,S.MOY,A.JOACHIMIAK,MIDWEST CENTER FOR              
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   22-MAY-07 2P4P    0                                                
JRNL        AUTH   M.E.CUFF,L.VOLKART,S.MOY,A.JOACHIMIAK                        
JRNL        TITL   THE STRUCTURE OF A CORC_HLYC DOMAIN FROM                     
JRNL        TITL 2 HAEMOPHILUS DUCREYI                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2P4P A    1    83  UNP    Q7VKS4   Q7VKS4_HAEDU   347    429             
DBREF  2P4P B    1    83  UNP    Q7VKS4   Q7VKS4_HAEDU   347    429             
SEQRES   1 A   86  SER ASN ALA MSE ARG ARG ASN GLU ASP SER TRP LEU ILE          
SEQRES   2 A   86  ASP GLY ALA THR PRO LEU GLU ASP VAL MSE ARG ALA LEU          
SEQRES   3 A   86  ASN ILE HIS THR PHE PRO ARG ASP GLU ASN TYR GLU THR          
SEQRES   4 A   86  ILE GLY GLY PHE MSE MSE TYR MSE LEU ARG MLY ILE PRO          
SEQRES   5 A   86  MLY MLY THR ASP PHE VAL LEU TYR ASP MLY TYR MLY PHE          
SEQRES   6 A   86  GLU ILE ILE ASP THR GLU ASN PHE ARG ILE ASP GLN LEU          
SEQRES   7 A   86  MSE VAL SER PHE ARG MLY ASP VAL                              
SEQRES   1 B   86  SER ASN ALA MSE ARG ARG ASN GLU ASP SER TRP LEU ILE          
SEQRES   2 B   86  ASP GLY ALA THR PRO LEU GLU ASP VAL MSE ARG ALA LEU          
SEQRES   3 B   86  ASN ILE HIS THR PHE PRO ARG ASP GLU ASN TYR GLU THR          
SEQRES   4 B   86  ILE GLY GLY PHE MSE MSE TYR MSE LEU ARG MLY ILE PRO          
SEQRES   5 B   86  MLY MLY THR ASP PHE VAL LEU TYR ASP MLY TYR MLY PHE          
SEQRES   6 B   86  GLU ILE ILE ASP THR GLU ASN PHE ARG ILE ASP GLN LEU          
SEQRES   7 B   86  MSE VAL SER PHE ARG MLY ASP VAL                              
HET    MSE  A   1       8                                                       
HET    MSE  A  20       8                                                       
HET    MSE  A  41       8                                                       
HET    MSE  A  42       8                                                       
HET    MSE  A  44       8                                                       
HET    MLY  A  47      11                                                       
HET    MLY  A  50      11                                                       
HET    MLY  A  51      11                                                       
HET    MLY  A  59      11                                                       
HET    MLY  A  61      11                                                       
HET    MSE  A  76       8                                                       
HET    MLY  A  81      11                                                       
HET    MSE  B  20       8                                                       
HET    MSE  B  41       8                                                       
HET    MSE  B  42      16                                                       
HET    MSE  B  44       8                                                       
HET    MLY  B  47      11                                                       
HET    MLY  B  50      11                                                       
HET    MLY  B  51      11                                                       
HET    MLY  B  59      11                                                       
HET    MLY  B  61      11                                                       
HET    MSE  B  76      13                                                       
HET    MLY  B  81      11                                                       
HET     CA    201       1                                                       
HET     MG    301       1                                                       
HET    GOL    401       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     MLY N-DIMETHYL-LYSINE                                                
HETNAM      CA CALCIUM ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   1  MLY    12(C8 H18 N2 O2)                                             
FORMUL   3   CA    CA 2+                                                        
FORMUL   4   MG    MG 2+                                                        
FORMUL   5  GOL    C3 H8 O3                                                     
FORMUL   6  HOH   *98(H2 O)                                                     
CRYST1   29.552   58.667   87.434  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   ASN A  -1      21.543  -4.912   5.215  1.00 37.95           N  
ATOM      2  CA  ASN A  -1      22.980  -4.940   5.624  1.00 37.52           C  
ATOM      3  C   ASN A  -1      23.369  -6.334   6.114  1.00 36.91           C  
ATOM      4  O   ASN A  -1      22.501  -7.126   6.486  1.00 36.66           O  
ATOM      5  CB  ASN A  -1      23.239  -3.882   6.695  1.00 37.95           C  
ATOM      6  CG  ASN A  -1      23.127  -2.438   6.147  1.00 39.08           C  
ATOM      7  OD1 ASN A  -1      23.109  -2.224   4.934  1.00 39.46           O  
ATOM      8  ND2 ASN A  -1      23.065  -1.452   7.050  1.00 38.86           N  
ATOM      9  N   ALA A   0      24.663  -6.653   6.100  1.00 36.18           N  
ATOM     10  CA  ALA A   0      25.119  -7.918   6.690  1.00 35.06           C  
ATOM     11  C   ALA A   0      25.047  -7.785   8.209  1.00 34.12           C  
ATOM     12  O   ALA A   0      24.802  -6.693   8.725  1.00 33.74           O  
ATOM     13  CB  ALA A   0      26.523  -8.264   6.235  1.00 35.05           C  
HETATM   14  N   MSE A   1      25.249  -8.895   8.911  1.00 32.93           N  
HETATM   15  CA  MSE A   1      25.242  -8.904  10.354  1.00 33.18           C  
HETATM   16  C   MSE A   1      26.303  -7.941  10.867  1.00 31.23           C  
HETATM   17  O   MSE A   1      27.450  -7.974  10.429  1.00 29.76           O  
HETATM   18  CB  MSE A   1      25.484 -10.328  10.848  1.00 33.14           C  
HETATM   19  CG  MSE A   1      25.279 -10.535  12.330  1.00 33.97           C  
HETATM   20 SE   MSE A   1      24.944 -12.427  12.723  1.00 39.59          SE  
HETATM   21  CE  MSE A   1      25.859 -13.312  11.258  1.00 31.11           C  
ATOM     22  N   ARG A   2      25.890  -7.047  11.755  1.00 30.46           N  
ATOM     23  CA  ARG A   2      26.776  -6.019  12.262  1.00 30.19           C  
ATOM     24  C   ARG A   2      27.662  -6.601  13.339  1.00 29.47           C  
ATOM     25  O   ARG A   2      27.246  -7.505  14.070  1.00 28.02           O  
ATOM     26  CB  ARG A   2      25.976  -4.856  12.848  1.00 29.67           C  
ATOM     27  CG  ARG A   2      25.326  -5.151  14.193  1.00 30.67           C  
ATOM     28  CD  ARG A   2      24.690  -3.922  14.819  1.00 30.79           C  
ATOM     29  NE  ARG A   2      23.346  -3.702  14.293  1.00 34.65           N  
ATOM     30  CZ  ARG A   2      23.046  -2.824  13.346  1.00 36.53           C  
ATOM     31  NH1 ARG A   2      23.993  -2.050  12.833  1.00 38.57           N  
ATOM     32  NH2 ARG A   2      21.794  -2.705  12.932  1.00 37.74           N  
ATOM     33  N   ARG A   3      28.879  -6.067  13.433  1.00 31.07           N  
ATOM     34  CA  ARG A   3      29.715  -6.266  14.618  1.00 32.31           C  
ATOM     35  C   ARG A   3      29.013  -5.708  15.849  1.00 32.82           C  
ATOM     36  O   ARG A   3      28.486  -4.581  15.852  1.00 33.14           O  
ATOM     37  CB  ARG A   3      31.081  -5.614  14.469  1.00 32.53           C  
ATOM     38  CG  ARG A   3      32.087  -6.506  13.799  1.00 34.96           C  
ATOM     39  CD  ARG A   3      33.325  -5.743  13.321  1.00 36.25           C  
ATOM     40  NE  ARG A   3      34.129  -6.617  12.465  1.00 37.79           N  
ATOM     41  CZ  ARG A   3      35.115  -7.388  12.908  1.00 38.68           C  
ATOM     42  NH1 ARG A   3      35.781  -8.172  12.071  1.00 37.83           N  
ATOM     43  NH2 ARG A   3      35.429  -7.380  14.202  1.00 40.34           N  
ATOM     44  N   ASN A   4      29.008  -6.533  16.882  1.00 32.74           N  
ATOM     45  CA  ASN A   4      28.514  -6.185  18.197  1.00 32.47           C  
ATOM     46  C   ASN A   4      29.481  -5.239  18.913  1.00 32.69           C  
ATOM     47  O   ASN A   4      30.526  -5.656  19.404  1.00 33.21           O  
ATOM     48  CB  ASN A   4      28.330  -7.492  18.984  1.00 32.38           C  
ATOM     49  CG  ASN A   4      27.639  -7.300  20.304  1.00 32.05           C  
ATOM     50  OD1 ASN A   4      26.982  -6.289  20.542  1.00 34.96           O  
ATOM     51  ND2 ASN A   4      27.764  -8.292  21.173  1.00 32.74           N  
ATOM     52  N   GLU A   5      29.111  -3.962  18.982  1.00 33.21           N  
ATOM     53  CA  GLU A   5      29.893  -2.920  19.661  1.00 33.12           C  
ATOM     54  C   GLU A   5      28.939  -2.175  20.620  1.00 32.45           C  
ATOM     55  O   GLU A   5      27.719  -2.367  20.545  1.00 31.30           O  
ATOM     56  CB  GLU A   5      30.486  -1.949  18.622  1.00 33.87           C  
ATOM     57  CG  GLU A   5      31.271  -2.633  17.481  1.00 36.78           C  
ATOM     58  CD  GLU A   5      31.130  -1.925  16.105  1.00 43.06           C  
ATOM     59  OE1 GLU A   5      30.460  -0.865  16.024  1.00 45.56           O  
ATOM     60  OE2 GLU A   5      31.687  -2.438  15.092  1.00 44.13           O  
ATOM     61  N   ASP A   6      29.462  -1.368  21.540  1.00 31.77           N  
ATOM     62  CA  ASP A   6      28.562  -0.677  22.475  1.00 32.63           C  
ATOM     63  C   ASP A   6      27.564   0.159  21.699  1.00 31.31           C  
ATOM     64  O   ASP A   6      27.926   0.827  20.736  1.00 31.31           O  
ATOM     65  CB  ASP A   6      29.272   0.135  23.586  1.00 33.60           C  
ATOM     66  CG  ASP A   6      30.281   1.172  23.074  1.00 37.85           C  
ATOM     67  OD1 ASP A   6      31.357   0.820  22.498  1.00 40.09           O  
ATOM     68  OD2 ASP A   6      30.038   2.377  23.352  1.00 41.86           O  
ATOM     69  N   SER A   7      26.306   0.101  22.102  1.00 30.68           N  
ATOM     70  CA  SER A   7      25.290   0.870  21.405  1.00 30.18           C  
ATOM     71  C   SER A   7      24.097   1.114  22.296  1.00 29.60           C  
ATOM     72  O   SER A   7      23.905   0.420  23.318  1.00 29.79           O  
ATOM     73  CB  SER A   7      24.875   0.153  20.126  1.00 29.71           C  
ATOM     74  OG  SER A   7      24.055  -0.945  20.434  1.00 32.63           O  
ATOM     75  N   TRP A   8      23.283   2.087  21.912  1.00 28.35           N  
ATOM     76  CA  TRP A   8      22.051   2.310  22.602  1.00 27.33           C  
ATOM     77  C   TRP A   8      20.909   2.236  21.608  1.00 26.58           C  
ATOM     78  O   TRP A   8      21.015   2.745  20.492  1.00 25.89           O  
ATOM     79  CB  TRP A   8      22.005   3.703  23.219  1.00 28.00           C  
ATOM     80  CG  TRP A   8      22.953   4.026  24.315  1.00 28.90           C  
ATOM     81  CD1 TRP A   8      23.756   3.162  25.036  1.00 29.52           C  
ATOM     82  CD2 TRP A   8      23.165   5.330  24.877  1.00 29.73           C  
ATOM     83  NE1 TRP A   8      24.474   3.867  25.978  1.00 29.99           N  
ATOM     84  CE2 TRP A   8      24.130   5.195  25.904  1.00 28.99           C  
ATOM     85  CE3 TRP A   8      22.651   6.605  24.591  1.00 31.29           C  
ATOM     86  CZ2 TRP A   8      24.573   6.293  26.676  1.00 29.66           C  
ATOM     87  CZ3 TRP A   8      23.102   7.701  25.347  1.00 30.33           C  
ATOM     88  CH2 TRP A   8      24.057   7.532  26.369  1.00 29.76           C  
ATOM     89  N   LEU A   9      19.807   1.640  22.042  1.00 25.42           N  
ATOM     90  CA  LEU A   9      18.569   1.683  21.292  1.00 25.74           C  
ATOM     91  C   LEU A   9      17.691   2.761  21.889  1.00 24.97           C  
ATOM     92  O   LEU A   9      17.373   2.728  23.090  1.00 26.61           O  
ATOM     93  CB  LEU A   9      17.882   0.325  21.340  1.00 25.96           C  
ATOM     94  CG  LEU A   9      16.621   0.164  20.492  1.00 27.18           C  
ATOM     95  CD1 LEU A   9      16.989  -0.009  19.025  1.00 31.12           C  
ATOM     96  CD2 LEU A   9      15.845  -1.038  20.980  1.00 29.52           C  
ATOM     97  N   ILE A  10      17.259   3.694  21.034  1.00 25.34           N  
ATOM     98  CA  ILE A  10      16.582   4.939  21.442  0.50 24.62           C  
ATOM    100  C   ILE A  10      15.279   5.173  20.662  1.00 24.24           C  
ATOM    101  O   ILE A  10      15.234   4.896  19.476  1.00 24.19           O  
ATOM    102  CB  ILE A  10      17.560   6.145  21.249  0.50 24.27           C  
ATOM    104  CG1 ILE A  10      18.660   6.098  22.321  0.50 23.97           C  
ATOM    106  CG2 ILE A  10      16.833   7.488  21.293  0.50 24.79           C  
ATOM    108  CD1 ILE A  10      19.811   7.050  22.066  0.50 24.58           C  
ATOM    110  N   ASP A  11      14.239   5.673  21.339  1.00 24.81           N  
ATOM    111  CA  ASP A  11      12.949   6.022  20.730  1.00 25.14           C  
ATOM    112  C   ASP A  11      13.134   7.271  19.869  1.00 24.83           C  
ATOM    113  O   ASP A  11      13.756   8.227  20.302  1.00 24.02           O  
ATOM    114  CB  ASP A  11      11.911   6.272  21.837  1.00 26.06           C  
ATOM    115  CG  ASP A  11      10.534   6.704  21.310  1.00 28.39           C  
ATOM    116  OD1 ASP A  11      10.334   6.838  20.080  1.00 33.57           O  
ATOM    117  OD2 ASP A  11       9.628   6.927  22.152  1.00 34.52           O  
ATOM    118  N   GLY A  12      12.581   7.265  18.654  1.00 24.68           N  
ATOM    119  CA  GLY A  12      12.751   8.402  17.732  1.00 24.48           C  
ATOM    120  C   GLY A  12      12.142   9.685  18.293  1.00 23.68           C  
ATOM    121  O   GLY A  12      12.516  10.786  17.902  1.00 24.47           O  
ATOM    122  N   ALA A  13      11.246   9.534  19.250  1.00 22.67           N  
ATOM    123  CA  ALA A  13      10.504  10.656  19.804  1.00 22.68           C  
ATOM    124  C   ALA A  13      11.221  11.300  21.002  1.00 22.18           C  
ATOM    125  O   ALA A  13      10.690  12.239  21.598  1.00 22.03           O  
ATOM    126  CB  ALA A  13       9.104  10.199  20.231  1.00 22.68           C  
ATOM    127  N   THR A  14      12.390  10.789  21.365  1.00 22.41           N  
ATOM    128  CA  THR A  14      13.174  11.366  22.454  1.00 23.15           C  
ATOM    129  C   THR A  14      13.555  12.786  22.089  1.00 22.69           C  
ATOM    130  O   THR A  14      14.036  13.015  21.007  1.00 21.65           O  
ATOM    131  CB  THR A  14      14.463  10.581  22.681  1.00 23.14           C  
ATOM    132  OG1 THR A  14      14.150   9.198  22.908  1.00 26.30           O  
ATOM    133  CG2 THR A  14      15.266  11.151  23.860  1.00 24.54           C  
ATOM    134  N   PRO A  15      13.327  13.760  23.001  1.00 22.91           N  
ATOM    135  CA  PRO A  15      13.807  15.116  22.740  1.00 22.53           C  
ATOM    136  C   PRO A  15      15.269  15.136  22.266  1.00 22.30           C  
ATOM    137  O   PRO A  15      16.123  14.420  22.805  1.00 21.92           O  
ATOM    138  CB  PRO A  15      13.653  15.801  24.103  1.00 22.52           C  
ATOM    139  CG  PRO A  15      12.465  15.110  24.705  1.00 23.39           C  
ATOM    140  CD  PRO A  15      12.568  13.674  24.264  1.00 23.92           C  
ATOM    141  N   LEU A  16      15.536  15.941  21.247  1.00 22.19           N  
ATOM    142  CA  LEU A  16      16.852  16.079  20.664  1.00 23.18           C  
ATOM    143  C   LEU A  16      17.925  16.444  21.700  1.00 23.99           C  
ATOM    144  O   LEU A  16      18.996  15.837  21.739  1.00 24.09           O  
ATOM    145  CB  LEU A  16      16.802  17.121  19.547  1.00 22.58           C  
ATOM    146  CG  LEU A  16      18.134  17.531  18.941  1.00 23.18           C  
ATOM    147  CD1 LEU A  16      18.814  16.304  18.289  1.00 18.85           C  
ATOM    148  CD2 LEU A  16      17.907  18.645  17.930  1.00 21.29           C  
ATOM    149  N   GLU A  17      17.616  17.433  22.528  1.00 25.02           N  
ATOM    150  CA  GLU A  17      18.526  17.953  23.566  1.00 26.05           C  
ATOM    151  C   GLU A  17      18.903  16.905  24.606  1.00 25.68           C  
ATOM    152  O   GLU A  17      20.027  16.878  25.058  1.00 25.42           O  
ATOM    153  CB  GLU A  17      17.869  19.122  24.298  1.00 26.39           C  
ATOM    154  CG  GLU A  17      17.648  20.359  23.431  1.00 32.04           C  
ATOM    155  CD  GLU A  17      16.699  20.100  22.268  1.00 38.06           C  
ATOM    156  OE1 GLU A  17      15.549  19.656  22.514  1.00 40.49           O  
ATOM    157  OE2 GLU A  17      17.126  20.316  21.110  1.00 40.83           O  
ATOM    158  N   ASP A  18      17.938  16.070  24.983  1.00 25.92           N  
ATOM    159  CA  ASP A  18      18.146  14.959  25.916  1.00 24.69           C  
ATOM    160  C   ASP A  18      19.181  13.953  25.403  1.00 24.79           C  
ATOM    161  O   ASP A  18      20.010  13.476  26.173  1.00 23.85           O  
ATOM    162  CB  ASP A  18      16.814  14.251  26.168  1.00 24.57           C  
ATOM    163  CG  ASP A  18      15.905  15.044  27.100  1.00 25.22           C  
ATOM    164  OD1 ASP A  18      16.319  16.143  27.491  1.00 28.51           O  
ATOM    165  OD2 ASP A  18      14.800  14.565  27.428  1.00 25.56           O  
ATOM    166  N   VAL A  19      19.094  13.633  24.114  1.00 23.92           N  
ATOM    167  CA  VAL A  19      20.043  12.730  23.428  1.00 24.16           C  
ATOM    168  C   VAL A  19      21.421  13.348  23.297  1.00 24.13           C  
ATOM    169  O   VAL A  19      22.408  12.730  23.675  1.00 23.32           O  
ATOM    170  CB  VAL A  19      19.523  12.335  22.021  1.00 24.13           C  
ATOM    171  CG1 VAL A  19      20.548  11.457  21.254  1.00 23.44           C  
ATOM    172  CG2 VAL A  19      18.199  11.608  22.149  1.00 25.26           C  
HETATM  173  N   MSE A  20      21.479  14.573  22.786  1.00 24.06           N  
HETATM  174  CA  MSE A  20      22.749  15.330  22.732  1.00 23.39           C  
HETATM  175  C   MSE A  20      23.424  15.386  24.100  1.00 23.87           C  
HETATM  176  O   MSE A  20      24.620  15.180  24.196  1.00 23.89           O  
HETATM  177  CB  MSE A  20      22.552  16.783  22.232  1.00 23.65           C  
HETATM  178  CG  MSE A  20      21.915  17.017  20.890  1.00 20.69           C  
HETATM  179 SE   MSE A  20      22.855  16.250  19.374  1.00 33.18          SE  
HETATM  180  CE  MSE A  20      22.198  14.417  19.397  1.00 26.67           C  
ATOM    181  N   ARG A  21      22.674  15.753  25.145  1.00 24.68           N  
ATOM    182  CA  ARG A  21      23.210  15.816  26.508  1.00 26.53           C  
ATOM    183  C   ARG A  21      23.787  14.478  26.975  1.00 25.59           C  
ATOM    184  O   ARG A  21      24.928  14.412  27.432  1.00 24.96           O  
ATOM    185  CB  ARG A  21      22.154  16.330  27.505  1.00 26.03           C  
ATOM    186  CG  ARG A  21      22.419  15.979  28.961  1.00 29.07           C  
ATOM    187  CD  ARG A  21      21.328  16.521  29.915  1.00 30.22           C  
ATOM    188  NE  ARG A  21      20.633  17.708  29.389  1.00 37.27           N  
ATOM    189  CZ  ARG A  21      19.396  17.704  28.886  1.00 38.73           C  
ATOM    190  NH1 ARG A  21      18.696  16.576  28.823  1.00 41.18           N  
ATOM    191  NH2 ARG A  21      18.851  18.830  28.454  1.00 40.16           N  
ATOM    192  N   ALA A  22      23.003  13.416  26.848  1.00 24.77           N  
ATOM    193  CA  ALA A  22      23.456  12.096  27.256  1.00 24.60           C  
ATOM    194  C   ALA A  22      24.695  11.612  26.482  1.00 24.23           C  
ATOM    195  O   ALA A  22      25.473  10.833  27.011  1.00 25.37           O  
ATOM    196  CB  ALA A  22      22.340  11.111  27.147  1.00 25.05           C  
ATOM    197  N   LEU A  23      24.889  12.104  25.256  1.00 24.39           N  
ATOM    198  CA  LEU A  23      26.027  11.686  24.427  1.00 23.77           C  
ATOM    199  C   LEU A  23      27.168  12.701  24.485  1.00 23.55           C  
ATOM    200  O   LEU A  23      28.141  12.564  23.754  1.00 21.71           O  
ATOM    201  CB  LEU A  23      25.592  11.515  22.982  1.00 23.38           C  
ATOM    202  CG  LEU A  23      24.644  10.343  22.615  1.00 25.59           C  
ATOM    203  CD1 LEU A  23      24.166  10.488  21.172  1.00 24.38           C  
ATOM    204  CD2 LEU A  23      25.356   9.005  22.796  1.00 24.30           C  
ATOM    205  N   ASN A  24      27.006  13.726  25.322  1.00 23.07           N  
ATOM    206  CA  ASN A  24      28.006  14.761  25.573  1.00 24.02           C  
ATOM    207  C   ASN A  24      28.366  15.539  24.304  1.00 22.95           C  
ATOM    208  O   ASN A  24      29.533  15.907  24.109  1.00 22.25           O  
ATOM    209  CB  ASN A  24      29.252  14.164  26.264  1.00 24.72           C  
ATOM    210  CG  ASN A  24      30.149  15.210  26.905  1.00 26.68           C  
ATOM    211  OD1 ASN A  24      29.693  16.151  27.567  1.00 24.41           O  
ATOM    212  ND2 ASN A  24      31.446  15.033  26.729  1.00 26.80           N  
ATOM    213  N   ILE A  25      27.346  15.776  23.464  1.00 22.47           N  
ATOM    214  CA  ILE A  25      27.462  16.596  22.257  1.00 22.47           C  
ATOM    215  C   ILE A  25      27.140  18.023  22.612  1.00 24.33           C  
ATOM    216  O   ILE A  25      26.069  18.302  23.128  1.00 23.34           O  
ATOM    217  CB  ILE A  25      26.551  16.087  21.113  1.00 22.99           C  
ATOM    218  CG1 ILE A  25      26.792  14.582  20.889  1.00 21.56           C  
ATOM    219  CG2 ILE A  25      26.823  16.864  19.792  1.00 21.62           C  
ATOM    220  CD1 ILE A  25      25.696  13.854  20.099  1.00 21.47           C  
ATOM    221  N   HIS A  26      28.079  18.921  22.333  1.00 25.46           N  
ATOM    222  CA  HIS A  26      27.923  20.309  22.704  1.00 27.12           C  
ATOM    223  C   HIS A  26      27.751  21.230  21.492  1.00 26.91           C  
ATOM    224  O   HIS A  26      27.551  22.425  21.638  1.00 28.27           O  
ATOM    225  CB  HIS A  26      29.101  20.712  23.581  1.00 28.13           C  
ATOM    226  CG  HIS A  26      29.068  20.062  24.930  1.00 32.68           C  
ATOM    227  ND1 HIS A  26      28.209  20.478  25.929  1.00 37.51           N  
ATOM    228  CD2 HIS A  26      29.753  19.008  25.436  1.00 35.16           C  
ATOM    229  CE1 HIS A  26      28.375  19.714  26.996  1.00 38.59           C  
ATOM    230  NE2 HIS A  26      29.300  18.809  26.719  1.00 37.88           N  
ATOM    231  N   THR A  27      27.834  20.660  20.306  1.00 26.86           N  
ATOM    232  CA  THR A  27      27.624  21.393  19.071  1.00 26.60           C  
ATOM    233  C   THR A  27      26.471  20.748  18.299  1.00 26.79           C  
ATOM    234  O   THR A  27      26.602  19.676  17.738  1.00 27.27           O  
ATOM    235  CB  THR A  27      28.920  21.433  18.234  1.00 26.86           C  
ATOM    236  OG1 THR A  27      29.923  22.155  18.965  1.00 27.87           O  
ATOM    237  CG2 THR A  27      28.694  22.086  16.892  1.00 24.68           C  
ATOM    238  N   PHE A  28      25.328  21.417  18.294  1.00 27.64           N  
ATOM    239  CA  PHE A  28      24.148  20.906  17.606  1.00 27.69           C  
ATOM    240  C   PHE A  28      23.141  22.046  17.371  1.00 27.97           C  
ATOM    241  O   PHE A  28      23.252  23.111  17.999  1.00 28.06           O  
ATOM    242  CB  PHE A  28      23.509  19.758  18.417  1.00 28.10           C  
ATOM    243  CG  PHE A  28      23.088  20.172  19.794  1.00 29.49           C  
ATOM    244  CD1 PHE A  28      23.972  20.059  20.863  1.00 29.68           C  
ATOM    245  CD2 PHE A  28      21.831  20.699  20.010  1.00 28.94           C  
ATOM    246  CE1 PHE A  28      23.585  20.478  22.137  1.00 32.68           C  
ATOM    247  CE2 PHE A  28      21.428  21.135  21.282  1.00 31.03           C  
ATOM    248  CZ  PHE A  28      22.302  21.016  22.340  1.00 31.14           C  
ATOM    249  N   PRO A  29      22.175  21.837  16.453  1.00 28.16           N  
ATOM    250  CA  PRO A  29      21.131  22.814  16.163  1.00 28.43           C  
ATOM    251  C   PRO A  29      20.306  23.219  17.391  1.00 29.08           C  
ATOM    252  O   PRO A  29      19.833  22.341  18.118  1.00 28.16           O  
ATOM    253  CB  PRO A  29      20.272  22.086  15.130  1.00 28.70           C  
ATOM    254  CG  PRO A  29      21.228  21.144  14.427  1.00 29.01           C  
ATOM    255  CD  PRO A  29      22.075  20.646  15.575  1.00 28.08           C  
ATOM    256  N   ARG A  30      20.171  24.533  17.615  1.00 29.48           N  
ATOM    257  CA  ARG A  30      19.538  25.120  18.800  1.00 30.87           C  
ATOM    258  C   ARG A  30      18.231  25.861  18.467  1.00 31.41           C  
ATOM    259  O   ARG A  30      17.556  26.364  19.363  1.00 30.62           O  
ATOM    260  CB  ARG A  30      20.468  26.138  19.494  1.00 30.72           C  
ATOM    261  CG  ARG A  30      21.931  25.745  19.681  1.00 32.52           C  
ATOM    262  CD  ARG A  30      22.060  24.577  20.615  1.00 33.59           C  
ATOM    263  NE  ARG A  30      23.437  24.117  20.808  1.00 37.10           N  
ATOM    264  CZ  ARG A  30      24.063  24.109  21.983  1.00 36.93           C  
ATOM    265  NH1 ARG A  30      23.449  24.556  23.069  1.00 36.13           N  
ATOM    266  NH2 ARG A  30      25.305  23.656  22.074  1.00 36.08           N  
ATOM    267  N   ASP A  31      17.907  25.919  17.178  1.00 31.99           N  
ATOM    268  CA  ASP A  31      16.703  26.592  16.646  1.00 33.33           C  
ATOM    269  C   ASP A  31      15.357  25.939  17.017  1.00 33.76           C  
ATOM    270  O   ASP A  31      14.304  26.580  16.924  1.00 33.21           O  
ATOM    271  CB  ASP A  31      16.814  26.620  15.129  1.00 33.34           C  
ATOM    272  CG  ASP A  31      17.231  25.290  14.581  1.00 34.16           C  
ATOM    273  OD1 ASP A  31      18.435  24.956  14.686  1.00 36.23           O  
ATOM    274  OD2 ASP A  31      16.353  24.560  14.091  1.00 35.03           O  
ATOM    275  N   GLU A  32      15.403  24.665  17.405  1.00 34.60           N  
ATOM    276  CA  GLU A  32      14.214  23.893  17.813  1.00 35.70           C  
ATOM    277  C   GLU A  32      13.195  23.613  16.691  1.00 35.97           C  
ATOM    278  O   GLU A  32      12.027  23.328  16.968  1.00 35.87           O  
ATOM    279  CB  GLU A  32      13.536  24.513  19.060  1.00 35.35           C  
ATOM    280  CG  GLU A  32      13.834  23.730  20.333  1.00 37.25           C  
ATOM    281  CD  GLU A  32      13.691  24.549  21.617  1.00 40.65           C  
ATOM    282  OE1 GLU A  32      14.577  24.400  22.491  1.00 42.19           O  
ATOM    283  OE2 GLU A  32      12.716  25.329  21.756  1.00 39.81           O  
ATOM    284  N   ASN A  33      13.630  23.673  15.431  1.00 36.83           N  
ATOM    285  CA  ASN A  33      12.757  23.266  14.317  1.00 37.38           C  
ATOM    286  C   ASN A  33      12.465  21.758  14.313  1.00 37.37           C  
ATOM    287  O   ASN A  33      11.408  21.329  13.832  1.00 38.43           O  
ATOM    288  CB  ASN A  33      13.293  23.742  12.952  1.00 37.40           C  
ATOM    289  CG  ASN A  33      13.044  25.237  12.700  1.00 39.46           C  
ATOM    290  OD1 ASN A  33      11.919  25.733  12.835  1.00 41.86           O  
ATOM    291  ND2 ASN A  33      14.098  25.955  12.319  1.00 39.38           N  
ATOM    292  N   TYR A  34      13.391  20.972  14.858  1.00 36.34           N  
ATOM    293  CA  TYR A  34      13.227  19.517  15.018  1.00 35.73           C  
ATOM    294  C   TYR A  34      13.427  19.177  16.471  1.00 35.01           C  
ATOM    295  O   TYR A  34      14.563  19.127  16.956  1.00 35.69           O  
ATOM    296  CB  TYR A  34      14.211  18.742  14.135  1.00 36.13           C  
ATOM    297  CG  TYR A  34      14.131  19.192  12.715  1.00 36.49           C  
ATOM    298  CD1 TYR A  34      13.082  18.776  11.893  1.00 36.60           C  
ATOM    299  CD2 TYR A  34      15.084  20.064  12.188  1.00 35.81           C  
ATOM    300  CE1 TYR A  34      12.986  19.209  10.578  1.00 37.18           C  
ATOM    301  CE2 TYR A  34      14.999  20.505  10.881  1.00 38.26           C  
ATOM    302  CZ  TYR A  34      13.944  20.074  10.079  1.00 38.54           C  
ATOM    303  OH  TYR A  34      13.858  20.506   8.778  1.00 39.97           O  
ATOM    304  N   GLU A  35      12.303  18.981  17.152  1.00 33.58           N  
ATOM    305  CA  GLU A  35      12.219  18.823  18.602  1.00 32.50           C  
ATOM    306  C   GLU A  35      12.788  17.497  19.057  1.00 30.53           C  
ATOM    307  O   GLU A  35      13.172  17.352  20.226  1.00 29.46           O  
ATOM    308  CB  GLU A  35      10.756  18.886  19.053  1.00 32.73           C  
ATOM    309  CG  GLU A  35       9.994  20.092  18.553  1.00 35.55           C  
ATOM    310  CD  GLU A  35       9.777  21.160  19.621  1.00 39.89           C  
ATOM    311  OE1 GLU A  35      10.157  20.949  20.802  1.00 40.72           O  
ATOM    312  OE2 GLU A  35       9.213  22.223  19.271  1.00 41.96           O  
ATOM    313  N   THR A  36      12.812  16.520  18.147  1.00 27.71           N  
ATOM    314  CA  THR A  36      13.163  15.165  18.538  1.00 25.87           C  
ATOM    315  C   THR A  36      14.333  14.640  17.736  1.00 25.38           C  
ATOM    316  O   THR A  36      14.628  15.103  16.618  1.00 25.19           O  
ATOM    317  CB  THR A  36      11.987  14.165  18.395  1.00 25.57           C  
ATOM    318  OG1 THR A  36      11.729  13.927  17.015  1.00 23.83           O  
ATOM    319  CG2 THR A  36      10.683  14.677  19.066  1.00 24.11           C  
ATOM    320  N   ILE A  37      14.979  13.639  18.308  1.00 25.03           N  
ATOM    321  CA  ILE A  37      16.116  13.007  17.662  1.00 24.95           C  
ATOM    322  C   ILE A  37      15.785  12.452  16.261  1.00 24.83           C  
ATOM    323  O   ILE A  37      16.582  12.605  15.323  1.00 25.12           O  
ATOM    324  CB  ILE A  37      16.774  11.929  18.584  1.00 24.78           C  
ATOM    325  CG1 ILE A  37      18.056  11.380  17.923  1.00 24.63           C  
ATOM    326  CG2 ILE A  37      15.760  10.805  19.010  1.00 25.67           C  
ATOM    327  CD1 ILE A  37      19.122  12.506  17.671  1.00 23.49           C  
ATOM    328  N   GLY A  38      14.638  11.798  16.126  1.00 25.31           N  
ATOM    329  CA  GLY A  38      14.236  11.222  14.848  1.00 25.23           C  
ATOM    330  C   GLY A  38      13.932  12.338  13.857  1.00 25.23           C  
ATOM    331  O   GLY A  38      14.191  12.191  12.683  1.00 25.02           O  
ATOM    332  N   GLY A  39      13.369  13.444  14.337  1.00 24.98           N  
ATOM    333  CA  GLY A  39      13.065  14.613  13.485  1.00 24.91           C  
ATOM    334  C   GLY A  39      14.338  15.180  12.886  1.00 24.94           C  
ATOM    335  O   GLY A  39      14.406  15.438  11.701  1.00 25.00           O  
ATOM    336  N   PHE A  40      15.345  15.371  13.728  1.00 25.23           N  
ATOM    337  CA  PHE A  40      16.669  15.832  13.300  1.00 25.53           C  
ATOM    338  C   PHE A  40      17.331  14.827  12.319  1.00 25.89           C  
ATOM    339  O   PHE A  40      17.908  15.212  11.300  1.00 24.93           O  
ATOM    340  CB  PHE A  40      17.514  16.140  14.557  1.00 26.25           C  
ATOM    341  CG  PHE A  40      18.951  16.508  14.254  1.00 27.81           C  
ATOM    342  CD1 PHE A  40      19.250  17.683  13.586  1.00 30.28           C  
ATOM    343  CD2 PHE A  40      19.987  15.640  14.587  1.00 31.07           C  
ATOM    344  CE1 PHE A  40      20.581  18.005  13.277  1.00 31.06           C  
ATOM    345  CE2 PHE A  40      21.306  15.968  14.295  1.00 32.63           C  
ATOM    346  CZ  PHE A  40      21.588  17.155  13.638  1.00 29.26           C  
HETATM  347  N   MSE A  41      17.216  13.526  12.600  1.00 26.26           N  
HETATM  348  CA  MSE A  41      17.767  12.513  11.688  1.00 28.03           C  
HETATM  349  C   MSE A  41      17.126  12.593  10.308  1.00 26.01           C  
HETATM  350  O   MSE A  41      17.822  12.527   9.293  1.00 25.87           O  
HETATM  351  CB  MSE A  41      17.583  11.098  12.265  1.00 27.20           C  
HETATM  352  CG  MSE A  41      18.515  10.790  13.414  1.00 26.86           C  
HETATM  353 SE   MSE A  41      18.129   8.947  13.978  1.00 38.98          SE  
HETATM  354  CE  MSE A  41      18.862   7.983  12.469  1.00 25.03           C  
HETATM  355  N   MSE A  42      15.798  12.693  10.266  1.00 26.49           N  
HETATM  356  CA  MSE A  42      15.087  12.892   8.998  1.00 27.69           C  
HETATM  357  C   MSE A  42      15.583  14.129   8.227  1.00 25.57           C  
HETATM  358  O   MSE A  42      15.852  14.060   7.027  1.00 24.53           O  
HETATM  359  CB  MSE A  42      13.564  12.929   9.225  1.00 28.24           C  
HETATM  360  CG  MSE A  42      12.999  11.537   9.401  1.00 28.57           C  
HETATM  361 SE   MSE A  42      11.052  11.555   9.725  1.00 37.58          SE  
HETATM  362  CE  MSE A  42      10.449  12.197   7.971  1.00 32.87           C  
ATOM    363  N   TYR A  43      15.733  15.251   8.919  1.00 24.97           N  
ATOM    364  CA  TYR A  43      16.342  16.412   8.269  1.00 24.65           C  
ATOM    365  C   TYR A  43      17.700  16.078   7.632  1.00 24.55           C  
ATOM    366  O   TYR A  43      17.960  16.415   6.477  1.00 26.10           O  
ATOM    367  CB  TYR A  43      16.514  17.532   9.262  1.00 24.22           C  
ATOM    368  CG  TYR A  43      17.391  18.640   8.746  1.00 22.83           C  
ATOM    369  CD1 TYR A  43      16.973  19.440   7.682  1.00 24.34           C  
ATOM    370  CD2 TYR A  43      18.642  18.873   9.306  1.00 23.68           C  
ATOM    371  CE1 TYR A  43      17.771  20.445   7.203  1.00 23.84           C  
ATOM    372  CE2 TYR A  43      19.452  19.897   8.829  1.00 24.42           C  
ATOM    373  CZ  TYR A  43      18.995  20.674   7.782  1.00 22.72           C  
ATOM    374  OH  TYR A  43      19.773  21.692   7.304  1.00 25.52           O  
HETATM  375  N   MSE A  44      18.572  15.435   8.402  1.00 24.05           N  
HETATM  376  CA  MSE A  44      19.947  15.185   7.949  1.00 23.46           C  
HETATM  377  C   MSE A  44      19.974  14.205   6.818  1.00 23.74           C  
HETATM  378  O   MSE A  44      20.914  14.180   6.038  1.00 23.42           O  
HETATM  379  CB  MSE A  44      20.812  14.647   9.085  1.00 24.46           C  
HETATM  380  CG  MSE A  44      20.969  15.587  10.248  1.00 24.64           C  
HETATM  381 SE   MSE A  44      22.204  17.074   9.862  1.00 35.93          SE  
HETATM  382  CE  MSE A  44      23.768  16.024   9.402  1.00 30.09           C  
ATOM    383  N   LEU A  45      18.964  13.349   6.765  1.00 23.74           N  
ATOM    384  CA  LEU A  45      18.898  12.330   5.706  1.00 23.96           C  
ATOM    385  C   LEU A  45      18.426  12.987   4.414  1.00 25.29           C  
ATOM    386  O   LEU A  45      18.829  12.586   3.327  1.00 24.15           O  
ATOM    387  CB  LEU A  45      17.923  11.212   6.112  1.00 23.11           C  
ATOM    388  CG  LEU A  45      18.528  10.144   7.013  1.00 22.32           C  
ATOM    389  CD1 LEU A  45      17.413   9.266   7.560  1.00 21.49           C  
ATOM    390  CD2 LEU A  45      19.500   9.311   6.139  1.00 25.24           C  
ATOM    391  N   ARG A  46      17.586  14.016   4.562  1.00 26.62           N  
ATOM    392  CA  ARG A  46      16.860  14.652   3.454  1.00 28.89           C  
ATOM    393  C   ARG A  46      15.834  13.720   2.737  1.00 30.84           C  
ATOM    394  O   ARG A  46      14.611  14.017   2.665  1.00 31.78           O  
ATOM    395  CB  ARG A  46      17.842  15.270   2.458  1.00 29.44           C  
ATOM    396  CG  ARG A  46      18.855  16.208   3.072  1.00 29.37           C  
ATOM    397  CD  ARG A  46      19.419  17.212   2.063  1.00 27.78           C  
ATOM    398  NE  ARG A  46      18.410  18.139   1.547  1.00 29.02           N  
ATOM    399  CZ  ARG A  46      17.898  19.194   2.188  1.00 29.41           C  
ATOM    400  NH1 ARG A  46      16.958  19.932   1.600  1.00 31.21           N  
ATOM    401  NH2 ARG A  46      18.290  19.525   3.391  1.00 26.95           N  
HETATM  402  N   MLY A  47      16.325  12.591   2.225  1.00 30.57           N  
HETATM  403  CA  MLY A  47      15.480  11.563   1.632  1.00 30.72           C  
HETATM  404  CB  MLY A  47      16.381  10.495   1.029  1.00 31.11           C  
HETATM  405  CG  MLY A  47      17.277  11.075  -0.054  1.00 32.33           C  
HETATM  406  CD  MLY A  47      18.037   9.938  -0.724  1.00 37.10           C  
HETATM  407  CE  MLY A  47      18.316  10.262  -2.189  1.00 40.14           C  
HETATM  408  NZ  MLY A  47      18.201   9.058  -3.030  1.00 42.42           N  
HETATM  409  CH1 MLY A  47      16.775   8.771  -3.282  1.00 42.10           C  
HETATM  410  CH2 MLY A  47      18.881   9.316  -4.310  1.00 41.90           C  
HETATM  411  C   MLY A  47      14.557  10.894   2.615  1.00 30.00           C  
HETATM  412  O   MLY A  47      14.796  10.908   3.824  1.00 30.39           O  
ATOM    413  N   ILE A  48      13.464  10.359   2.086  1.00 28.63           N  
ATOM    414  CA  ILE A  48      12.497   9.543   2.828  1.00 28.60           C  
ATOM    415  C   ILE A  48      13.232   8.481   3.679  1.00 28.59           C  
ATOM    416  O   ILE A  48      14.066   7.760   3.143  1.00 28.58           O  
ATOM    417  CB  ILE A  48      11.583   8.786   1.821  1.00 28.89           C  
ATOM    418  CG1 ILE A  48      10.804   9.753   0.923  1.00 29.57           C  
ATOM    419  CG2 ILE A  48      10.688   7.822   2.536  1.00 28.28           C  
ATOM    420  CD1 ILE A  48      10.010  10.770   1.673  1.00 30.68           C  
ATOM    421  N   PRO A  49      12.927   8.389   4.998  1.00 28.13           N  
ATOM    422  CA  PRO A  49      13.679   7.454   5.845  1.00 28.04           C  
ATOM    423  C   PRO A  49      13.268   6.011   5.671  1.00 28.22           C  
ATOM    424  O   PRO A  49      12.087   5.704   5.439  1.00 27.19           O  
ATOM    425  CB  PRO A  49      13.329   7.889   7.263  1.00 28.33           C  
ATOM    426  CG  PRO A  49      12.009   8.515   7.137  1.00 28.13           C  
ATOM    427  CD  PRO A  49      11.926   9.135   5.776  1.00 28.12           C  
HETATM  428  N   MLY A  50      14.243   5.126   5.799  1.00 27.33           N  
HETATM  429  CA  MLY A  50      13.949   3.694   5.844  1.00 27.29           C  
HETATM  430  CB  MLY A  50      13.912   3.077   4.460  1.00 27.76           C  
HETATM  431  CG  MLY A  50      15.109   3.404   3.590  1.00 31.16           C  
HETATM  432  CD  MLY A  50      14.965   2.676   2.250  1.00 34.18           C  
HETATM  433  CE  MLY A  50      16.304   2.323   1.607  1.00 36.73           C  
HETATM  434  NZ  MLY A  50      17.367   3.276   1.974  1.00 40.46           N  
HETATM  435  CH1 MLY A  50      18.661   2.576   2.064  1.00 42.24           C  
HETATM  436  CH2 MLY A  50      17.506   4.362   0.979  1.00 42.64           C  
HETATM  437  C   MLY A  50      14.946   3.002   6.723  1.00 26.59           C  
HETATM  438  O   MLY A  50      16.035   3.526   6.935  1.00 25.81           O  
HETATM  439  N   MLY A  51      14.591   1.814   7.219  1.00 26.10           N  
HETATM  440  CA  MLY A  51      15.464   1.022   8.089  1.00 26.87           C  
HETATM  441  CB  MLY A  51      14.809  -0.321   8.482  1.00 26.49           C  
HETATM  442  CG  MLY A  51      14.660  -1.251   7.292  1.00 29.40           C  
HETATM  443  CD  MLY A  51      13.985  -2.585   7.611  1.00 33.68           C  
HETATM  444  CE  MLY A  51      14.646  -3.634   6.719  1.00 35.91           C  
HETATM  445  NZ  MLY A  51      14.181  -4.991   7.033  1.00 36.82           N  
HETATM  446  CH1 MLY A  51      13.612  -5.603   5.826  1.00 37.12           C  
HETATM  447  CH2 MLY A  51      15.314  -5.766   7.571  1.00 38.20           C  
HETATM  448  C   MLY A  51      16.805   0.831   7.428  1.00 27.04           C  
HETATM  449  O   MLY A  51      16.870   0.634   6.208  1.00 27.70           O  
ATOM    450  N   THR A  52      17.859   0.887   8.246  1.00 27.33           N  
ATOM    451  CA  THR A  52      19.270   0.828   7.850  1.00 27.74           C  
ATOM    452  C   THR A  52      19.882   2.180   7.443  1.00 27.97           C  
ATOM    453  O   THR A  52      21.102   2.344   7.495  1.00 27.62           O  
ATOM    454  CB  THR A  52      19.608  -0.267   6.770  1.00 28.15           C  
ATOM    455  OG1 THR A  52      19.237   0.194   5.469  1.00 30.21           O  
ATOM    456  CG2 THR A  52      18.923  -1.586   7.076  1.00 26.30           C  
ATOM    457  N   ASP A  53      19.057   3.158   7.063  1.00 27.80           N  
ATOM    458  CA  ASP A  53      19.613   4.483   6.765  1.00 27.54           C  
ATOM    459  C   ASP A  53      20.293   4.974   8.039  1.00 26.82           C  
ATOM    460  O   ASP A  53      19.854   4.646   9.149  1.00 25.91           O  
ATOM    461  CB  ASP A  53      18.538   5.512   6.394  1.00 27.49           C  
ATOM    462  CG  ASP A  53      17.901   5.264   5.041  1.00 28.15           C  
ATOM    463  OD1 ASP A  53      18.371   4.393   4.273  1.00 29.90           O  
ATOM    464  OD2 ASP A  53      16.910   5.957   4.742  1.00 27.18           O  
ATOM    465  N   PHE A  54      21.331   5.783   7.873  1.00 26.14           N  
ATOM    466  CA  PHE A  54      22.062   6.303   9.027  1.00 26.32           C  
ATOM    467  C   PHE A  54      22.606   7.695   8.784  1.00 25.89           C  
ATOM    468  O   PHE A  54      22.857   8.085   7.639  1.00 24.74           O  
ATOM    469  CB  PHE A  54      23.216   5.352   9.356  1.00 26.01           C  
ATOM    470  CG  PHE A  54      24.327   5.357   8.336  1.00 24.55           C  
ATOM    471  CD1 PHE A  54      25.393   6.274   8.448  1.00 24.91           C  
ATOM    472  CD2 PHE A  54      24.342   4.435   7.305  1.00 27.80           C  
ATOM    473  CE1 PHE A  54      26.433   6.282   7.530  1.00 29.29           C  
ATOM    474  CE2 PHE A  54      25.365   4.433   6.378  1.00 28.51           C  
ATOM    475  CZ  PHE A  54      26.428   5.365   6.484  1.00 25.93           C  
ATOM    476  N   VAL A  55      22.797   8.427   9.878  1.00 25.22           N  
ATOM    477  CA  VAL A  55      23.395   9.771   9.887  1.00 24.68           C  
ATOM    478  C   VAL A  55      24.674   9.677  10.734  1.00 23.99           C  
ATOM    479  O   VAL A  55      24.670   9.073  11.799  1.00 23.49           O  
ATOM    480  CB  VAL A  55      22.436  10.803  10.545  1.00 25.01           C  
ATOM    481  CG1 VAL A  55      23.066  12.181  10.596  1.00 25.09           C  
ATOM    482  CG2 VAL A  55      21.102  10.881   9.771  1.00 25.84           C  
ATOM    483  N   LEU A  56      25.760  10.261  10.246  1.00 23.42           N  
ATOM    484  CA  LEU A  56      27.015  10.355  10.998  1.00 22.95           C  
ATOM    485  C   LEU A  56      26.988  11.748  11.556  1.00 23.80           C  
ATOM    486  O   LEU A  56      26.823  12.692  10.798  1.00 24.69           O  
ATOM    487  CB  LEU A  56      28.208  10.141  10.068  1.00 22.93           C  
ATOM    488  CG  LEU A  56      28.261   8.821   9.302  1.00 21.30           C  
ATOM    489  CD1 LEU A  56      29.532   8.869   8.494  1.00 25.95           C  
ATOM    490  CD2 LEU A  56      28.250   7.601  10.247  1.00 19.93           C  
ATOM    491  N   TYR A  57      27.033  11.890  12.892  1.00 23.49           N  
ATOM    492  CA  TYR A  57      27.059  13.214  13.525  1.00 23.44           C  
ATOM    493  C   TYR A  57      27.900  13.183  14.805  1.00 23.00           C  
ATOM    494  O   TYR A  57      27.750  12.274  15.632  1.00 23.61           O  
ATOM    495  CB  TYR A  57      25.667  13.671  13.896  1.00 22.48           C  
ATOM    496  CG  TYR A  57      25.678  15.097  14.305  1.00 22.92           C  
ATOM    497  CD1 TYR A  57      25.826  16.101  13.348  1.00 22.93           C  
ATOM    498  CD2 TYR A  57      25.575  15.459  15.648  1.00 23.48           C  
ATOM    499  CE1 TYR A  57      25.871  17.436  13.711  1.00 25.43           C  
ATOM    500  CE2 TYR A  57      25.602  16.802  16.013  1.00 23.91           C  
ATOM    501  CZ  TYR A  57      25.766  17.774  15.030  1.00 23.80           C  
ATOM    502  OH  TYR A  57      25.807  19.109  15.359  1.00 24.84           O  
ATOM    503  N   ASP A  58      28.772  14.163  14.967  1.00 22.63           N  
ATOM    504  CA  ASP A  58      29.754  14.140  16.082  1.00 22.33           C  
ATOM    505  C   ASP A  58      30.538  12.822  16.061  1.00 22.51           C  
ATOM    506  O   ASP A  58      31.053  12.409  14.992  1.00 21.74           O  
ATOM    507  CB  ASP A  58      29.046  14.378  17.424  1.00 22.81           C  
ATOM    508  CG  ASP A  58      29.972  14.880  18.516  1.00 25.92           C  
ATOM    509  OD1 ASP A  58      30.309  16.100  18.551  1.00 25.69           O  
ATOM    510  OD2 ASP A  58      30.334  14.049  19.371  1.00 26.85           O  
HETATM  511  N   MLY A  59      30.692  12.188  17.224  1.00 21.45           N  
HETATM  512  CA  MLY A  59      31.441  10.935  17.341  1.00 22.71           C  
HETATM  513  CB  MLY A  59      31.856  10.779  18.802  1.00 22.78           C  
HETATM  514  CG  MLY A  59      32.960  11.793  19.095  1.00 24.96           C  
HETATM  515  CD  MLY A  59      33.490  11.697  20.505  1.00 28.49           C  
HETATM  516  CE  MLY A  59      32.444  12.208  21.503  1.00 26.62           C  
HETATM  517  NZ  MLY A  59      32.092  13.616  21.311  1.00 28.87           N  
HETATM  518  CH1 MLY A  59      31.245  14.038  22.433  1.00 28.95           C  
HETATM  519  CH2 MLY A  59      33.288  14.493  21.297  1.00 32.14           C  
HETATM  520  C   MLY A  59      30.632   9.706  16.944  1.00 22.26           C  
HETATM  521  O   MLY A  59      31.122   8.574  17.061  1.00 21.86           O  
ATOM    522  N   TYR A  60      29.423   9.893  16.418  1.00 21.21           N  
ATOM    523  CA  TYR A  60      28.426   8.806  16.434  1.00 22.94           C  
ATOM    524  C   TYR A  60      27.781   8.487  15.088  1.00 23.94           C  
ATOM    525  O   TYR A  60      27.770   9.323  14.183  1.00 25.25           O  
ATOM    526  CB  TYR A  60      27.305   9.163  17.406  1.00 23.27           C  
ATOM    527  CG  TYR A  60      27.817   9.442  18.776  1.00 25.44           C  
ATOM    528  CD1 TYR A  60      28.224   8.401  19.624  1.00 25.11           C  
ATOM    529  CD2 TYR A  60      27.980  10.743  19.204  1.00 25.28           C  
ATOM    530  CE1 TYR A  60      28.717   8.681  20.898  1.00 27.07           C  
ATOM    531  CE2 TYR A  60      28.474  11.029  20.440  1.00 27.94           C  
ATOM    532  CZ  TYR A  60      28.822  10.001  21.292  1.00 23.93           C  
ATOM    533  OH  TYR A  60      29.303  10.361  22.509  1.00 26.80           O  
HETATM  534  N   MLY A  61      27.274   7.252  14.970  1.00 23.76           N  
HETATM  535  CA  MLY A  61      26.452   6.805  13.866  1.00 23.49           C  
HETATM  536  CB  MLY A  61      27.020   5.488  13.340  1.00 23.62           C  
HETATM  537  CG  MLY A  61      26.242   4.922  12.157  1.00 24.75           C  
HETATM  538  CD  MLY A  61      26.976   3.727  11.528  1.00 30.51           C  
HETATM  539  CE  MLY A  61      26.220   3.129  10.327  1.00 32.58           C  
HETATM  540  NZ  MLY A  61      26.815   1.867   9.821  1.00 35.49           N  
HETATM  541  CH1 MLY A  61      25.761   0.958   9.340  1.00 35.34           C  
HETATM  542  CH2 MLY A  61      27.710   2.139   8.683  1.00 34.90           C  
HETATM  543  C   MLY A  61      25.096   6.539  14.451  1.00 24.37           C  
HETATM  544  O   MLY A  61      24.959   5.778  15.416  1.00 24.39           O  
ATOM    545  N   PHE A  62      24.101   7.213  13.889  1.00 25.21           N  
ATOM    546  CA  PHE A  62      22.715   7.069  14.230  1.00 25.06           C  
ATOM    547  C   PHE A  62      22.019   6.278  13.099  1.00 25.15           C  
ATOM    548  O   PHE A  62      21.901   6.799  11.989  1.00 25.04           O  
ATOM    549  CB  PHE A  62      22.111   8.476  14.346  1.00 25.06           C  
ATOM    550  CG  PHE A  62      22.709   9.339  15.448  1.00 24.81           C  
ATOM    551  CD1 PHE A  62      23.888  10.090  15.236  1.00 24.32           C  
ATOM    552  CD2 PHE A  62      22.061   9.454  16.676  1.00 26.07           C  
ATOM    553  CE1 PHE A  62      24.411  10.884  16.219  1.00 26.49           C  
ATOM    554  CE2 PHE A  62      22.608  10.245  17.693  1.00 24.19           C  
ATOM    555  CZ  PHE A  62      23.769  10.965  17.467  1.00 24.43           C  
ATOM    556  N   GLU A  63      21.546   5.056  13.390  1.00 24.93           N  
ATOM    557  CA  GLU A  63      20.961   4.149  12.393  1.00 25.60           C  
ATOM    558  C   GLU A  63      19.465   3.949  12.644  1.00 24.24           C  
ATOM    559  O   GLU A  63      19.067   3.571  13.754  1.00 24.60           O  
ATOM    560  CB  GLU A  63      21.668   2.794  12.414  1.00 26.04           C  
ATOM    561  CG  GLU A  63      21.202   1.823  11.325  1.00 27.87           C  
ATOM    562  CD  GLU A  63      21.999   0.526  11.263  1.00 28.40           C  
ATOM    563  OE1 GLU A  63      23.206   0.523  11.600  1.00 29.96           O  
ATOM    564  OE2 GLU A  63      21.406  -0.505  10.861  1.00 30.60           O  
ATOM    565  N   ILE A  64      18.632   4.175  11.630  1.00 23.62           N  
ATOM    566  CA  ILE A  64      17.183   3.858  11.762  1.00 22.70           C  
ATOM    567  C   ILE A  64      16.932   2.348  11.927  1.00 23.35           C  
ATOM    568  O   ILE A  64      17.331   1.536  11.083  1.00 22.94           O  
ATOM    569  CB  ILE A  64      16.337   4.380  10.564  1.00 22.67           C  
ATOM    570  CG1 ILE A  64      16.410   5.901  10.438  1.00 22.30           C  
ATOM    571  CG2 ILE A  64      14.868   3.857  10.671  1.00 22.62           C  
ATOM    572  CD1 ILE A  64      15.716   6.417   9.133  1.00 22.00           C  
ATOM    573  N   ILE A  65      16.286   1.958  13.025  1.00 23.89           N  
ATOM    574  CA  ILE A  65      15.956   0.550  13.203  1.00 25.14           C  
ATOM    575  C   ILE A  65      14.603   0.256  12.560  1.00 25.58           C  
ATOM    576  O   ILE A  65      14.431  -0.741  11.844  1.00 24.65           O  
ATOM    577  CB  ILE A  65      16.052   0.102  14.705  1.00 25.68           C  
ATOM    578  CG1 ILE A  65      17.524   0.155  15.157  1.00 26.60           C  
ATOM    579  CG2 ILE A  65      15.386  -1.300  14.952  1.00 26.51           C  
ATOM    580  CD1 ILE A  65      18.534  -0.530  14.163  1.00 26.08           C  
ATOM    581  N   ASP A  66      13.653   1.141  12.804  1.00 26.43           N  
ATOM    582  CA  ASP A  66      12.371   1.066  12.124  1.00 28.19           C  
ATOM    583  C   ASP A  66      11.637   2.417  12.055  1.00 28.20           C  
ATOM    584  O   ASP A  66      11.837   3.302  12.895  1.00 27.79           O  
ATOM    585  CB  ASP A  66      11.509  -0.027  12.760  1.00 28.24           C  
ATOM    586  CG  ASP A  66      10.899   0.393  14.085  1.00 31.45           C  
ATOM    587  OD1 ASP A  66       9.670   0.571  14.114  1.00 34.16           O  
ATOM    588  OD2 ASP A  66      11.623   0.543  15.094  1.00 33.53           O  
ATOM    589  N   THR A  67      10.803   2.558  11.032  1.00 27.65           N  
ATOM    590  CA  THR A  67       9.888   3.671  10.937  1.00 28.20           C  
ATOM    591  C   THR A  67       8.464   3.155  11.220  1.00 27.98           C  
ATOM    592  O   THR A  67       8.162   1.969  11.026  1.00 28.20           O  
ATOM    593  CB  THR A  67       9.934   4.389   9.553  1.00 28.88           C  
ATOM    594  OG1 THR A  67       9.428   3.516   8.534  1.00 29.73           O  
ATOM    595  CG2 THR A  67      11.374   4.849   9.194  1.00 28.11           C  
ATOM    596  N   GLU A  68       7.632   4.031  11.755  1.00 26.92           N  
ATOM    597  CA  GLU A  68       6.216   3.767  11.863  1.00 27.73           C  
ATOM    598  C   GLU A  68       5.468   5.094  11.902  1.00 26.41           C  
ATOM    599  O   GLU A  68       5.962   6.089  12.472  1.00 25.04           O  
ATOM    600  CB  GLU A  68       5.891   2.860  13.050  1.00 28.89           C  
ATOM    601  CG  GLU A  68       5.975   3.495  14.438  1.00 33.49           C  
ATOM    602  CD  GLU A  68       5.005   2.865  15.427  1.00 39.27           C  
ATOM    603  OE1 GLU A  68       5.244   2.964  16.653  1.00 40.51           O  
ATOM    604  OE2 GLU A  68       3.998   2.272  14.982  1.00 40.46           O  
ATOM    605  N   ASN A  69       4.307   5.116  11.241  1.00 24.33           N  
ATOM    606  CA  ASN A  69       3.487   6.304  11.197  1.00 23.45           C  
ATOM    607  C   ASN A  69       4.275   7.468  10.613  1.00 22.17           C  
ATOM    608  O   ASN A  69       4.143   8.610  11.048  1.00 20.54           O  
ATOM    609  CB  ASN A  69       2.905   6.605  12.584  1.00 23.70           C  
ATOM    610  CG  ASN A  69       1.841   5.600  13.001  1.00 27.00           C  
ATOM    611  OD1 ASN A  69       1.089   5.072  12.168  1.00 27.24           O  
ATOM    612  ND2 ASN A  69       1.770   5.323  14.307  1.00 29.18           N  
ATOM    613  N   PHE A  70       5.119   7.131   9.631  1.00 21.23           N  
ATOM    614  CA  PHE A  70       5.932   8.095   8.871  1.00 22.09           C  
ATOM    615  C   PHE A  70       6.984   8.873   9.671  1.00 21.96           C  
ATOM    616  O   PHE A  70       7.402   9.960   9.282  1.00 21.87           O  
ATOM    617  CB  PHE A  70       5.019   8.967   7.990  1.00 21.48           C  
ATOM    618  CG  PHE A  70       3.969   8.161   7.284  1.00 22.55           C  
ATOM    619  CD1 PHE A  70       4.325   7.270   6.265  1.00 20.66           C  
ATOM    620  CD2 PHE A  70       2.638   8.221   7.688  1.00 18.41           C  
ATOM    621  CE1 PHE A  70       3.352   6.483   5.634  1.00 19.42           C  
ATOM    622  CE2 PHE A  70       1.671   7.441   7.058  1.00 18.17           C  
ATOM    623  CZ  PHE A  70       2.035   6.578   6.027  1.00 20.53           C  
ATOM    624  N   ARG A  71       7.409   8.265  10.778  1.00 22.51           N  
ATOM    625  CA  ARG A  71       8.436   8.799  11.651  1.00 23.42           C  
ATOM    626  C   ARG A  71       9.433   7.713  11.951  1.00 23.99           C  
ATOM    627  O   ARG A  71       9.120   6.513  11.803  1.00 23.40           O  
ATOM    628  CB  ARG A  71       7.811   9.254  12.978  1.00 24.76           C  
ATOM    629  CG  ARG A  71       6.676  10.285  12.835  1.00 28.47           C  
ATOM    630  CD  ARG A  71       7.170  11.554  12.159  1.00 37.49           C  
ATOM    631  NE  ARG A  71       7.673  12.559  13.102  1.00 42.13           N  
ATOM    632  CZ  ARG A  71       8.685  13.391  12.847  1.00 44.32           C  
ATOM    633  NH1 ARG A  71       9.347  13.316  11.695  1.00 44.15           N  
ATOM    634  NH2 ARG A  71       9.065  14.275  13.765  1.00 45.30           N  
ATOM    635  N   ILE A  72      10.610   8.129  12.421  1.00 23.47           N  
ATOM    636  CA  ILE A  72      11.611   7.217  12.942  1.00 25.24           C  
ATOM    637  C   ILE A  72      11.101   6.802  14.312  1.00 25.77           C  
ATOM    638  O   ILE A  72      10.891   7.640  15.203  1.00 27.80           O  
ATOM    639  CB  ILE A  72      13.030   7.870  12.997  1.00 25.00           C  
ATOM    640  CG1 ILE A  72      13.481   8.227  11.569  1.00 25.31           C  
ATOM    641  CG2 ILE A  72      14.010   6.963  13.731  1.00 25.40           C  
ATOM    642  CD1 ILE A  72      14.785   9.027  11.436  1.00 25.37           C  
ATOM    643  N   ASP A  73      10.817   5.515  14.447  1.00 26.39           N  
ATOM    644  CA  ASP A  73      10.232   4.940  15.658  1.00 26.81           C  
ATOM    645  C   ASP A  73      11.368   4.564  16.644  1.00 26.61           C  
ATOM    646  O   ASP A  73      11.358   4.980  17.824  1.00 26.04           O  
ATOM    647  CB  ASP A  73       9.377   3.734  15.231  1.00 27.68           C  
ATOM    648  CG  ASP A  73       8.834   2.930  16.383  1.00 30.33           C  
ATOM    649  OD1 ASP A  73       8.369   3.510  17.388  1.00 33.80           O  
ATOM    650  OD2 ASP A  73       8.833   1.691  16.262  1.00 35.19           O  
ATOM    651  N   GLN A  74      12.330   3.790  16.147  1.00 25.98           N  
ATOM    652  CA  GLN A  74      13.530   3.417  16.922  1.00 26.50           C  
ATOM    653  C   GLN A  74      14.805   3.600  16.137  1.00 25.72           C  
ATOM    654  O   GLN A  74      14.844   3.328  14.943  1.00 26.15           O  
ATOM    655  CB  GLN A  74      13.468   1.965  17.360  1.00 26.32           C  
ATOM    656  CG  GLN A  74      12.424   1.698  18.396  1.00 29.23           C  
ATOM    657  CD  GLN A  74      12.367   0.241  18.768  1.00 31.89           C  
ATOM    658  OE1 GLN A  74      12.599  -0.118  19.905  1.00 36.45           O  
ATOM    659  NE2 GLN A  74      12.075  -0.601  17.804  1.00 33.81           N  
ATOM    660  N   LEU A  75      15.864   4.011  16.831  1.00 26.05           N  
ATOM    661  CA  LEU A  75      17.175   4.135  16.246  1.00 25.81           C  
ATOM    662  C   LEU A  75      18.236   3.527  17.172  1.00 25.76           C  
ATOM    663  O   LEU A  75      18.000   3.320  18.358  1.00 26.00           O  
ATOM    664  CB  LEU A  75      17.512   5.605  16.004  1.00 25.76           C  
ATOM    665  CG  LEU A  75      17.422   6.481  17.259  1.00 25.64           C  
ATOM    666  CD1 LEU A  75      18.741   7.214  17.529  1.00 27.34           C  
ATOM    667  CD2 LEU A  75      16.217   7.434  17.185  1.00 25.31           C  
HETATM  668  N   MSE A  76      19.395   3.237  16.611  1.00 25.23           N  
HETATM  669  CA  MSE A  76      20.533   2.801  17.383  1.00 28.83           C  
HETATM  670  C   MSE A  76      21.649   3.801  17.217  1.00 25.53           C  
HETATM  671  O   MSE A  76      21.849   4.334  16.130  1.00 24.54           O  
HETATM  672  CB  MSE A  76      21.031   1.459  16.854  1.00 27.37           C  
HETATM  673  CG  MSE A  76      21.970   0.756  17.810  1.00 30.77           C  
HETATM  674 SE   MSE A  76      22.692  -0.809  16.926  1.00 45.65          SE  
HETATM  675  CE  MSE A  76      22.182  -0.388  15.125  1.00 31.46           C  
ATOM    676  N   VAL A  77      22.373   4.044  18.306  1.00 25.84           N  
ATOM    677  CA  VAL A  77      23.513   4.967  18.332  1.00 24.68           C  
ATOM    678  C   VAL A  77      24.711   4.097  18.685  1.00 24.48           C  
ATOM    679  O   VAL A  77      24.605   3.287  19.592  1.00 23.97           O  
ATOM    680  CB  VAL A  77      23.345   6.054  19.457  1.00 24.24           C  
ATOM    681  CG1 VAL A  77      24.448   7.140  19.356  1.00 25.62           C  
ATOM    682  CG2 VAL A  77      22.004   6.704  19.342  1.00 27.71           C  
ATOM    683  N   SER A  78      25.828   4.286  17.995  1.00 24.50           N  
ATOM    684  CA  SER A  78      27.075   3.621  18.303  1.00 24.80           C  
ATOM    685  C   SER A  78      28.189   4.623  17.972  1.00 24.15           C  
ATOM    686  O   SER A  78      27.920   5.694  17.381  1.00 23.25           O  
ATOM    687  CB  SER A  78      27.172   2.354  17.436  1.00 24.93           C  
ATOM    688  OG  SER A  78      26.956   2.716  16.085  1.00 28.51           O  
ATOM    689  N   PHE A  79      29.434   4.331  18.350  1.00 22.00           N  
ATOM    690  CA  PHE A  79      30.532   5.177  17.885  1.00 22.47           C  
ATOM    691  C   PHE A  79      30.725   5.015  16.394  1.00 23.15           C  
ATOM    692  O   PHE A  79      30.617   3.903  15.870  1.00 21.07           O  
ATOM    693  CB  PHE A  79      31.845   4.799  18.568  1.00 21.42           C  
ATOM    694  CG  PHE A  79      32.105   5.503  19.882  1.00 23.65           C  
ATOM    695  CD1 PHE A  79      31.842   6.854  20.037  1.00 22.26           C  
ATOM    696  CD2 PHE A  79      32.709   4.812  20.931  1.00 24.51           C  
ATOM    697  CE1 PHE A  79      32.101   7.500  21.232  1.00 27.09           C  
ATOM    698  CE2 PHE A  79      33.028   5.460  22.143  1.00 23.79           C  
ATOM    699  CZ  PHE A  79      32.722   6.799  22.296  1.00 23.73           C  
ATOM    700  N   ARG A  80      31.044   6.102  15.697  1.00 25.10           N  
ATOM    701  CA  ARG A  80      31.312   5.998  14.277  1.00 25.96           C  
ATOM    702  C   ARG A  80      32.665   5.381  14.046  1.00 27.06           C  
ATOM    703  O   ARG A  80      33.576   5.527  14.868  1.00 27.13           O  
ATOM    704  CB  ARG A  80      31.223   7.351  13.582  1.00 25.61           C  
ATOM    705  CG  ARG A  80      32.381   8.270  13.891  1.00 24.99           C  
ATOM    706  CD  ARG A  80      32.001   9.645  13.468  1.00 30.61           C  
ATOM    707  NE  ARG A  80      32.101   9.828  12.016  1.00 27.48           N  
ATOM    708  CZ  ARG A  80      31.768  10.963  11.408  1.00 27.36           C  
ATOM    709  NH1 ARG A  80      31.288  11.997  12.128  1.00 24.40           N  
ATOM    710  NH2 ARG A  80      31.906  11.065  10.097  1.00 26.95           N  
HETATM  711  N   MLY A  81      32.805   4.699  12.915  1.00 29.53           N  
HETATM  712  CA  MLY A  81      34.007   3.936  12.637  1.00 31.37           C  
HETATM  713  CB  MLY A  81      33.651   2.461  12.391  1.00 31.18           C  
HETATM  714  CG  MLY A  81      33.153   1.770  13.672  1.00 33.15           C  
HETATM  715  CD  MLY A  81      33.995   2.055  14.910  1.00 34.89           C  
HETATM  716  CE  MLY A  81      34.400   0.809  15.691  1.00 38.49           C  
HETATM  717  NZ  MLY A  81      34.297   1.105  17.133  1.00 40.92           N  
HETATM  718  CH1 MLY A  81      34.161  -0.151  17.876  1.00 41.20           C  
HETATM  719  CH2 MLY A  81      35.488   1.802  17.646  1.00 40.05           C  
HETATM  720  C   MLY A  81      34.861   4.459  11.524  1.00 32.59           C  
HETATM  721  O   MLY A  81      35.972   3.963  11.308  1.00 33.51           O  
ATOM    722  N   ASP A  82      34.353   5.441  10.788  1.00 33.93           N  
ATOM    723  CA  ASP A  82      35.185   6.281   9.925  1.00 34.69           C  
ATOM    724  C   ASP A  82      35.887   7.281  10.859  1.00 35.10           C  
ATOM    725  O   ASP A  82      36.891   7.907  10.504  1.00 36.17           O  
ATOM    726  CB  ASP A  82      34.299   7.027   8.917  1.00 34.79           C  
ATOM    727  CG  ASP A  82      33.397   8.075   9.587  1.00 34.80           C  
ATOM    728  OD1 ASP A  82      33.048   7.906  10.772  1.00 33.30           O  
ATOM    729  OD2 ASP A  82      33.062   9.087   8.945  1.00 35.54           O  
TER     730      ASP A  82                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
