
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  305 ( 2406),  selected  305 , name 2ho5_A
# Molecule2: number of CA atoms  320 ( 2378),  selected  320 , name T0452.pdb
# PARAMETERS: 2ho5_A.T0452.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      M       1          3.207
LGA    L     2_A      I       2          1.593
LGA    K     3_A      K       3          1.203
LGA    L     4_A      I       4          0.883
LGA    G     5_A      A       5          0.663
LGA    V     6_A      I       6          0.973
LGA    I     7_A      V       7          0.949
LGA    G     8_A      G       8          0.719
LGA    T     9_A      F       9          1.431
LGA    G    10_A      G      10          0.967
LGA    A    11_A      T      11          0.777
LGA    I    12_A      V      12          0.725
LGA    S    13_A      G      13          0.961
LGA    H    14_A      Q      14          1.973
LGA    H    15_A      G      15          1.916
LGA    F    16_A      V      16          2.202
LGA    I    17_A      A      17          2.764
LGA    E    18_A      E      18          3.127
LGA    A    19_A      L      19          3.336
LGA    A    20_A      L      20          3.834
LGA    H    21_A      I      21          4.463
LGA    T    22_A      R      22           #
LGA    -       -      K      23           -
LGA    -       -      R      24           -
LGA    -       -      E      25           -
LGA    -       -      E      26           -
LGA    S    23_A      I      27          1.982
LGA    G    24_A      E      28          2.532
LGA    -       -      K      29           -
LGA    -       -      A      30           -
LGA    E    25_A      I      31          4.024
LGA    -       -      G      32           -
LGA    -       -      E      33           -
LGA    Y    26_A      F      34          3.806
LGA    Q    27_A      K      35          2.501
LGA    L    28_A      V      36          1.769
LGA    V    29_A      T      37          1.898
LGA    A    30_A      A      38          0.753
LGA    I    31_A      V      39          1.084
LGA    Y    32_A      A      40          1.848
LGA    S    33_A      D      41          3.104
LGA    R    34_A      S      42          4.381
LGA    K    35_A      K      43          2.528
LGA    L    36_A      S      44          2.613
LGA    E    37_A      -       -           -
LGA    T    38_A      S      45           #
LGA    A    39_A      I      46           #
LGA    A    40_A      S      47           #
LGA    T    41_A      G      48           -
LGA    F    42_A      D      49           -
LGA    -       -      F      50           -
LGA    -       -      S      51           -
LGA    -       -      L      52           -
LGA    A    43_A      V      53           #
LGA    -       -      E      54           -
LGA    S    44_A      A      55          3.588
LGA    R    45_A      L      56          3.137
LGA    Y    46_A      R      57           #
LGA    Q    47_A      M      58           -
LGA    N    48_A      K      59           -
LGA    I    49_A      R      60           -
LGA    Q    50_A      E      61           -
LGA    -       -      T      62           -
LGA    -       -      G      63           -
LGA    -       -      M      64           -
LGA    -       -      L      65           -
LGA    L    51_A      R      66          5.075
LGA    F    52_A      D      67          4.858
LGA    D    53_A      D      68          3.749
LGA    Q    54_A      A      69          3.322
LGA    -       -      K      70           -
LGA    L    55_A      A      71          4.313
LGA    E    56_A      I      72           #
LGA    V    57_A      E      73          3.805
LGA    F    58_A      V      74          1.545
LGA    F    59_A      V      75          3.291
LGA    -       -      R      76           -
LGA    K    60_A      S      77          1.636
LGA    S    61_A      A      78          2.050
LGA    S    62_A      D      79          1.115
LGA    F    63_A      Y      80          1.351
LGA    D    64_A      D      81          0.803
LGA    L    65_A      V      82          1.127
LGA    V    66_A      L      83          1.012
LGA    Y    67_A      I      84          0.845
LGA    I    68_A      E      85          0.892
LGA    A    69_A      A      86          1.376
LGA    S    70_A      S      87          1.364
LGA    P    71_A      V      88          3.782
LGA    N    72_A      T      89          4.451
LGA    S    73_A      R      90           -
LGA    L    74_A      E      95          2.000
LGA    H    75_A      G      96          1.592
LGA    F    76_A      V      97          0.993
LGA    A    77_A      N      98          1.413
LGA    Q    78_A      Y      99          1.513
LGA    A    79_A      I     100          1.173
LGA    K    80_A      R     101          1.442
LGA    A    81_A      E     102          1.652
LGA    A    82_A      A     103          1.758
LGA    L    83_A      L     104          2.038
LGA    S    84_A      K     105          2.405
LGA    A    85_A      R     106          2.778
LGA    G    86_A      G     107          3.239
LGA    K    87_A      K     108          2.360
LGA    H    88_A      H     109          1.806
LGA    V    89_A      V     110          1.569
LGA    I    90_A      V     111          1.552
LGA    L    91_A      T     112          1.659
LGA    E    92_A      S     113          1.142
LGA    K    93_A      N     114          3.327
LGA    P    94_A      K     115          1.176
LGA    A    95_A      G     116          5.355
LGA    V    96_A      P     117          1.549
LGA    S    97_A      L     118           #
LGA    Q    98_A      V     119          3.193
LGA    P    99_A      A     120          4.330
LGA    Q   100_A      E     121          3.184
LGA    E   101_A      -       -           -
LGA    W   102_A      F     122          2.419
LGA    F   103_A      H     123          2.544
LGA    D   104_A      G     124          2.537
LGA    L   105_A      L     125          2.176
LGA    I   106_A      M     126          2.938
LGA    Q   107_A      S     127          3.469
LGA    T   108_A      L     128          2.924
LGA    A   109_A      A     129          2.510
LGA    E   110_A      E     130          3.348
LGA    K   111_A      R     131          3.612
LGA    N   112_A      N     132          3.310
LGA    N   113_A      G     133          2.814
LGA    C   114_A      V     134          2.703
LGA    F   115_A      R     135          2.273
LGA    I   116_A      L     136          1.912
LGA    F   117_A      M     137          1.735
LGA    E   118_A      Y     138          1.605
LGA    A   119_A      E     139          3.360
LGA    A   120_A      A     140          3.457
LGA    -       -      T     141           -
LGA    -       -      V     142           -
LGA    -       -      G     143           -
LGA    -       -      G     144           -
LGA    R   121_A      A     145           #
LGA    N   122_A      M     146          3.035
LGA    Y   123_A      P     147          3.366
LGA    -       -      V     148           -
LGA    H   124_A      V     149          5.767
LGA    E   125_A      K     150           #
LGA    K   126_A      -       -           -
LGA    A   127_A      -       -           -
LGA    F   128_A      L     151          4.667
LGA    -       -      A     152           -
LGA    -       -      K     153           -
LGA    -       -      R     154           -
LGA    T   129_A      Y     155          4.353
LGA    T   130_A      -       -           -
LGA    I   131_A      -       -           -
LGA    K   132_A      L     156          5.860
LGA    N   133_A      A     157           -
LGA    F   134_A      L     158           -
LGA    L   135_A      -       -           -
LGA    A   136_A      C     159           #
LGA    D   137_A      E     160           -
LGA    K   138_A      I     161           -
LGA    Q   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    L   141_A      E     162           #
LGA    G   142_A      S     163           #
LGA    A   143_A      V     164           #
LGA    D   144_A      K     165          4.940
LGA    F   145_A      G     166          2.142
LGA    N   146_A      I     167          1.481
LGA    Y   147_A      F     168          3.646
LGA    A   148_A      N     169          3.537
LGA    K   149_A      G     170          2.783
LGA    Y   150_A      T     171          3.226
LGA    -       -      C     172           -
LGA    -       -      N     173           -
LGA    -       -      Y     174           -
LGA    -       -      I     175           -
LGA    -       -      L     176           -
LGA    -       -      S     177           -
LGA    -       -      R     178           -
LGA    -       -      M     179           -
LGA    -       -      E     180           -
LGA    -       -      E     181           -
LGA    -       -      E     182           -
LGA    -       -      R     183           -
LGA    -       -      L     184           -
LGA    -       -      P     185           -
LGA    -       -      Y     186           -
LGA    -       -      E     187           -
LGA    -       -      H     188           -
LGA    -       -      I     189           -
LGA    -       -      L     190           -
LGA    -       -      K     191           -
LGA    -       -      E     192           -
LGA    -       -      A     193           -
LGA    -       -      Q     194           -
LGA    -       -      E     195           -
LGA    -       -      L     196           -
LGA    -       -      G     197           -
LGA    S   151_A      Y     198          1.857
LGA    S   152_A      A     199          3.818
LGA    K   153_A      E     200          3.198
LGA    G   172_A      A     201           -
LGA    -       -      D     202           -
LGA    -       -      P     203           -
LGA    -       -      S     204           -
LGA    G   173_A      Y     205          2.302
LGA    A   174_A      D     206          3.260
LGA    -       -      V     207           -
LGA    -       -      E     208           -
LGA    -       -      G     209           -
LGA    -       -      I     210           -
LGA    L   175_A      D     211          2.555
LGA    -       -      A     212           -
LGA    -       -      A     213           -
LGA    X   176_A      L     214          3.048
LGA    D   177_A      -       -           -
LGA    L   178_A      -       -           -
LGA    G   179_A      -       -           -
LGA    I   180_A      K     215          2.075
LGA    Y   181_A      -       -           -
LGA    P   182_A      -       -           -
LGA    L   183_A      -       -           -
LGA    Y   184_A      L     216           #
LGA    A   185_A      V     217           -
LGA    A   186_A      I     218           -
LGA    V   187_A      I     219          5.062
LGA    R   188_A      A     220           -
LGA    L   189_A      N     221           -
LGA    F   190_A      T     222           -
LGA    G   191_A      I     223          3.538
LGA    -       -      G     224           -
LGA    K   192_A      V     225          4.094
LGA    A   193_A      K     226           #
LGA    N   194_A      -       -           -
LGA    D   195_A      A     227           #
LGA    -       -      S     228           -
LGA    -       -      Y     229           -
LGA    -       -      E     230           -
LGA    -       -      D     231           -
LGA    -       -      V     232           -
LGA    -       -      E     233           -
LGA    -       -      V     234           -
LGA    -       -      T     235           -
LGA    -       -      G     236           -
LGA    -       -      I     237           -
LGA    -       -      T     238           -
LGA    -       -      Q     239           -
LGA    -       -      I     240           -
LGA    -       -      T     241           -
LGA    -       -      P     242           -
LGA    -       -      E     243           -
LGA    -       -      A     244           -
LGA    -       -      F     245           -
LGA    -       -      Q     246           -
LGA    -       -      V     247           -
LGA    -       -      A     248           -
LGA    -       -      A     249           -
LGA    -       -      E     250           -
LGA    -       -      K     251           -
LGA    -       -      G     252           -
LGA    -       -      Y     253           -
LGA    -       -      T     254           -
LGA    -       -      I     255           -
LGA    -       -      R     256           -
LGA    -       -      L     257           -
LGA    -       -      I     258           -
LGA    -       -      A     259           -
LGA    -       -      E     260           -
LGA    -       -      V     261           -
LGA    -       -      S     262           -
LGA    -       -      R     263           -
LGA    -       -      E     264           -
LGA    A   196_A      K     265          3.108
LGA    T   197_A      L     266          3.391
LGA    Y   198_A      K     267          2.982
LGA    H   199_A      V     268           #
LGA    A   200_A      -       -           -
LGA    Q   201_A      -       -           -
LGA    Q   202_A      -       -           -
LGA    L   203_A      -       -           -
LGA    D   204_A      -       -           -
LGA    N   205_A      -       -           -
LGA    S   206_A      -       -           -
LGA    I   207_A      -       -           -
LGA    D   208_A      -       -           -
LGA    L   209_A      -       -           -
LGA    N   210_A      -       -           -
LGA    G   211_A      -       -           -
LGA    D   212_A      -       -           -
LGA    G   213_A      -       -           -
LGA    I   214_A      -       -           -
LGA    L   215_A      -       -           -
LGA    F   216_A      -       -           -
LGA    Y   217_A      -       -           -
LGA    P   218_A      -       -           -
LGA    D   219_A      -       -           -
LGA    Y   220_A      -       -           -
LGA    Q   221_A      -       -           -
LGA    V   222_A      -       -           -
LGA    H   223_A      -       -           -
LGA    I   224_A      S     269           #
LGA    K   225_A      P     270           #
LGA    A   226_A      R     271           -
LGA    G   227_A      L     272           -
LGA    K   228_A      V     273           -
LGA    N   229_A      P     274           -
LGA    I   230_A      F     275           -
LGA    T   231_A      H     276           -
LGA    -       -      H     277           -
LGA    -       -      P     278           -
LGA    -       -      L     279           -
LGA    -       -      A     280           -
LGA    -       -      I     281           -
LGA    S   232_A      K     282          4.230
LGA    N   233_A      G     283          2.883
LGA    L   234_A      T     284           -
LGA    P   235_A      M     285           -
LGA    -       -      N     286           -
LGA    C   236_A      A     287          4.814
LGA    E   237_A      A     288           #
LGA    I   238_A      M     289          4.978
LGA    Y   239_A      F     290           -
LGA    -       -      K     291           -
LGA    -       -      T     292           -
LGA    -       -      D     293           -
LGA    -       -      T     294           -
LGA    -       -      A     295           -
LGA    -       -      G     296           -
LGA    T   240_A      S     297           #
LGA    T   241_A      -       -           -
LGA    D   242_A      -       -           -
LGA    G   243_A      -       -           -
LGA    T   244_A      -       -           -
LGA    L   245_A      -       -           -
LGA    T   246_A      I     298           #
LGA    L   247_A      F     299          5.535
LGA    N   248_A      V     300           #
LGA    T   249_A      A     301          2.138
LGA    I   250_A      -       -           -
LGA    E   251_A      G     302          3.446
LGA    H   252_A      R     303          5.087
LGA    I   253_A      G     304           -
LGA    R   254_A      A     305           -
LGA    S   255_A      G     306           -
LGA    A   256_A      K     307           -
LGA    I   257_A      E     308           -
LGA    F   258_A      -       -           -
LGA    T   259_A      -       -           -
LGA    D   260_A      -       -           -
LGA    H   261_A      -       -           -
LGA    Q   262_A      -       -           -
LGA    G   263_A      -       -           -
LGA    N   264_A      -       -           -
LGA    Q   265_A      -       -           -
LGA    V   266_A      -       -           -
LGA    Q   267_A      -       -           -
LGA    L   268_A      -       -           -
LGA    P   269_A      -       -           -
LGA    I   270_A      -       -           -
LGA    Q   271_A      -       -           -
LGA    Q   272_A      -       -           -
LGA    A   273_A      -       -           -
LGA    P   274_A      -       -           -
LGA    H   275_A      E     309          5.590
LGA    T   276_A      T     310          5.662
LGA    -       -      A     311           -
LGA    X   277_A      S     312          1.430
LGA    -       -      A     313           -
LGA    -       -      I     314           -
LGA    T   278_A      L     315          4.818
LGA    E   279_A      S     316          2.885
LGA    E   280_A      D     317          2.994
LGA    V   281_A      L     318          3.424
LGA    A   282_A      Y     319          1.614
LGA    A   283_A      E     320          1.333
LGA    F   284_A      I     321          2.893
LGA    A   285_A      Y     322          2.643
LGA    H   286_A      A     323          2.575
LGA    X   287_A      -       -           -
LGA    I   288_A      -       -           -
LGA    Q   289_A      -       -           -
LGA    Q   290_A      G     324           #
LGA    P   291_A      -       -           -
LGA    D   292_A      -       -           -
LGA    L   293_A      -       -           -
LGA    N   294_A      -       -           -
LGA    L   295_A      -       -           -
LGA    Y   296_A      -       -           -
LGA    Q   297_A      -       -           -
LGA    T   298_A      -       -           -
LGA    W   299_A      -       -           -
LGA    L   300_A      -       -           -
LGA    Y   301_A      -       -           -
LGA    D   302_A      -       -           -
LGA    A   303_A      -       -           -
LGA    G   304_A      -       -           -
LGA    S   305_A      -       -           -
LGA    V   306_A      -       -           -
LGA    H   307_A      -       -           -
LGA    E   308_A      -       -           -
LGA    L   309_A      -       -           -
LGA    L   310_A      -       -           -
LGA    Y   311_A      -       -           -
LGA    T   312_A      -       -           -
LGA    X   313_A      -       -           -
LGA    R   314_A      -       -           -
LGA    Q   315_A      -       -           -
LGA    T   316_A      -       -           -
LGA    A   317_A      -       -           -
LGA    G   318_A      -       -           -
LGA    I   319_A      -       -           -
LGA    R   320_A      -       -           -
LGA    F   321_A      -       -           -
LGA    E   322_A      -       -           -
LGA    A   323_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  305  320    5.0    150    2.98    14.67     29.066     4.862

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.554888 * X  +   0.823393 * Y  +  -0.118844 * Z  +   8.723478
  Y_new =   0.269216 * X  +   0.042555 * Y  +  -0.962139 * Z  +  26.370327
  Z_new =  -0.787161 * X  +  -0.565874 * Y  +  -0.245284 * Z  +  19.415701 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.979811    1.161782  [ DEG:  -113.4348     66.5652 ]
  Theta =   0.906192    2.235400  [ DEG:    51.9210    128.0790 ]
  Phi   =   2.689878   -0.451715  [ DEG:   154.1186    -25.8814 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ho5_A                                        
REMARK     2: T0452.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ho5_A.T0452.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  305  320   5.0  150   2.98   14.67  29.066
REMARK  ---------------------------------------------------------- 
MOLECULE 2ho5_A
HEADER    OXIDOREDUCTASE                          13-JUL-06   2HO5              
TITLE     CRYSTAL STRUCTURE OF OXIDOREDUCTASE, GFO/IDH/MOCA FAMILY              
TITLE    2 FROM STREPTOCOCCUS PNEUMONIAE                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: OXIDOREDUCTASE, GFO/IDH/MOCA FAMILY;                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) DERIVATIVE;                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PMCSG                                     
KEYWDS    OXIDOREDUCTASE, GFO/IDH/MOCA FAMILY, STREPTOCOCCUS                    
KEYWDS   2 PNEUMONIAE, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE            
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR           
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   12-SEP-06 2HO5    0                                                
JRNL        AUTH   C.CHANG,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK                     
JRNL        TITL   CRYSTAL STRUCTURE OF OXIDOREDUCTASE, GFO/IDH/MOCA            
JRNL        TITL 2 FAMILY FROM STREPTOCOCCUS PNEUMONIAE                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.56 ANGSTROMS.                                          
DBREF  2HO5 A    1   325  UNP    Q97PV8   Q97PV8_STRPN     1    325             
DBREF  2HO5 B    1   325  UNP    Q97PV8   Q97PV8_STRPN     1    325             
SEQRES   1 A  325  MSE LEU LYS LEU GLY VAL ILE GLY THR GLY ALA ILE SER          
SEQRES   2 A  325  HIS HIS PHE ILE GLU ALA ALA HIS THR SER GLY GLU TYR          
SEQRES   3 A  325  GLN LEU VAL ALA ILE TYR SER ARG LYS LEU GLU THR ALA          
SEQRES   4 A  325  ALA THR PHE ALA SER ARG TYR GLN ASN ILE GLN LEU PHE          
SEQRES   5 A  325  ASP GLN LEU GLU VAL PHE PHE LYS SER SER PHE ASP LEU          
SEQRES   6 A  325  VAL TYR ILE ALA SER PRO ASN SER LEU HIS PHE ALA GLN          
SEQRES   7 A  325  ALA LYS ALA ALA LEU SER ALA GLY LYS HIS VAL ILE LEU          
SEQRES   8 A  325  GLU LYS PRO ALA VAL SER GLN PRO GLN GLU TRP PHE ASP          
SEQRES   9 A  325  LEU ILE GLN THR ALA GLU LYS ASN ASN CYS PHE ILE PHE          
SEQRES  10 A  325  GLU ALA ALA ARG ASN TYR HIS GLU LYS ALA PHE THR THR          
SEQRES  11 A  325  ILE LYS ASN PHE LEU ALA ASP LYS GLN VAL LEU GLY ALA          
SEQRES  12 A  325  ASP PHE ASN TYR ALA LYS TYR SER SER LYS MSE PRO ASP          
SEQRES  13 A  325  LEU LEU ALA GLY GLN THR PRO ASN VAL PHE SER ASP ARG          
SEQRES  14 A  325  PHE ALA GLY GLY ALA LEU MSE ASP LEU GLY ILE TYR PRO          
SEQRES  15 A  325  LEU TYR ALA ALA VAL ARG LEU PHE GLY LYS ALA ASN ASP          
SEQRES  16 A  325  ALA THR TYR HIS ALA GLN GLN LEU ASP ASN SER ILE ASP          
SEQRES  17 A  325  LEU ASN GLY ASP GLY ILE LEU PHE TYR PRO ASP TYR GLN          
SEQRES  18 A  325  VAL HIS ILE LYS ALA GLY LYS ASN ILE THR SER ASN LEU          
SEQRES  19 A  325  PRO CYS GLU ILE TYR THR THR ASP GLY THR LEU THR LEU          
SEQRES  20 A  325  ASN THR ILE GLU HIS ILE ARG SER ALA ILE PHE THR ASP          
SEQRES  21 A  325  HIS GLN GLY ASN GLN VAL GLN LEU PRO ILE GLN GLN ALA          
SEQRES  22 A  325  PRO HIS THR MSE THR GLU GLU VAL ALA ALA PHE ALA HIS          
SEQRES  23 A  325  MSE ILE GLN GLN PRO ASP LEU ASN LEU TYR GLN THR TRP          
SEQRES  24 A  325  LEU TYR ASP ALA GLY SER VAL HIS GLU LEU LEU TYR THR          
SEQRES  25 A  325  MSE ARG GLN THR ALA GLY ILE ARG PHE GLU ALA GLU LYS          
SEQRES   1 B  325  MSE LEU LYS LEU GLY VAL ILE GLY THR GLY ALA ILE SER          
SEQRES   2 B  325  HIS HIS PHE ILE GLU ALA ALA HIS THR SER GLY GLU TYR          
SEQRES   3 B  325  GLN LEU VAL ALA ILE TYR SER ARG LYS LEU GLU THR ALA          
SEQRES   4 B  325  ALA THR PHE ALA SER ARG TYR GLN ASN ILE GLN LEU PHE          
SEQRES   5 B  325  ASP GLN LEU GLU VAL PHE PHE LYS SER SER PHE ASP LEU          
SEQRES   6 B  325  VAL TYR ILE ALA SER PRO ASN SER LEU HIS PHE ALA GLN          
SEQRES   7 B  325  ALA LYS ALA ALA LEU SER ALA GLY LYS HIS VAL ILE LEU          
SEQRES   8 B  325  GLU LYS PRO ALA VAL SER GLN PRO GLN GLU TRP PHE ASP          
SEQRES   9 B  325  LEU ILE GLN THR ALA GLU LYS ASN ASN CYS PHE ILE PHE          
SEQRES  10 B  325  GLU ALA ALA ARG ASN TYR HIS GLU LYS ALA PHE THR THR          
SEQRES  11 B  325  ILE LYS ASN PHE LEU ALA ASP LYS GLN VAL LEU GLY ALA          
SEQRES  12 B  325  ASP PHE ASN TYR ALA LYS TYR SER SER LYS MSE PRO ASP          
SEQRES  13 B  325  LEU LEU ALA GLY GLN THR PRO ASN VAL PHE SER ASP ARG          
SEQRES  14 B  325  PHE ALA GLY GLY ALA LEU MSE ASP LEU GLY ILE TYR PRO          
SEQRES  15 B  325  LEU TYR ALA ALA VAL ARG LEU PHE GLY LYS ALA ASN ASP          
SEQRES  16 B  325  ALA THR TYR HIS ALA GLN GLN LEU ASP ASN SER ILE ASP          
SEQRES  17 B  325  LEU ASN GLY ASP GLY ILE LEU PHE TYR PRO ASP TYR GLN          
SEQRES  18 B  325  VAL HIS ILE LYS ALA GLY LYS ASN ILE THR SER ASN LEU          
SEQRES  19 B  325  PRO CYS GLU ILE TYR THR THR ASP GLY THR LEU THR LEU          
SEQRES  20 B  325  ASN THR ILE GLU HIS ILE ARG SER ALA ILE PHE THR ASP          
SEQRES  21 B  325  HIS GLN GLY ASN GLN VAL GLN LEU PRO ILE GLN GLN ALA          
SEQRES  22 B  325  PRO HIS THR MSE THR GLU GLU VAL ALA ALA PHE ALA HIS          
SEQRES  23 B  325  MSE ILE GLN GLN PRO ASP LEU ASN LEU TYR GLN THR TRP          
SEQRES  24 B  325  LEU TYR ASP ALA GLY SER VAL HIS GLU LEU LEU TYR THR          
SEQRES  25 B  325  MSE ARG GLN THR ALA GLY ILE ARG PHE GLU ALA GLU LYS          
HET    MSE  A   1       8                                                       
HET    MSE  A 176       8                                                       
HET    MSE  A 277       8                                                       
HET    MSE  A 287       8                                                       
HET    MSE  A 313       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B 154       8                                                       
HET    MSE  B 176       8                                                       
HET    MSE  B 277       8                                                       
HET    MSE  B 287       8                                                       
HET    MSE  B 313       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *13(H2 O)                                                     
CRYST1  117.113  117.113  102.917  90.00  90.00  90.00 P 43 21 2    16          
HETATM    1  N   MSE A   1      50.495  11.320  10.135  1.00 96.78           N  
HETATM    2  CA  MSE A   1      49.070  11.760   9.933  1.00 98.09           C  
HETATM    3  C   MSE A   1      48.823  12.979   8.981  1.00 94.81           C  
HETATM    4  O   MSE A   1      49.622  13.910   8.901  1.00 94.75           O  
HETATM    5  CB  MSE A   1      48.378  11.985  11.281  1.00 97.97           C  
HETATM    6  CG  MSE A   1      47.290  13.090  11.229  1.00100.37           C  
HETATM    7 SE   MSE A   1      46.362  13.369  12.931  1.00106.24          SE  
HETATM    8  CE  MSE A   1      47.862  13.119  14.233  1.00102.87           C  
ATOM      9  N   LEU A   2      47.673  12.965   8.315  1.00 91.89           N  
ATOM     10  CA  LEU A   2      47.467  13.714   7.096  1.00 89.00           C  
ATOM     11  C   LEU A   2      47.105  15.192   7.276  1.00 88.24           C  
ATOM     12  O   LEU A   2      46.093  15.546   7.891  1.00 88.22           O  
ATOM     13  CB  LEU A   2      46.380  13.035   6.281  1.00 88.77           C  
ATOM     14  CG  LEU A   2      46.668  11.813   5.430  1.00 85.51           C  
ATOM     15  CD1 LEU A   2      45.378  11.387   4.792  1.00 81.96           C  
ATOM     16  CD2 LEU A   2      47.662  12.197   4.380  1.00 84.19           C  
ATOM     17  N   LYS A   3      47.919  16.053   6.684  1.00 86.53           N  
ATOM     18  CA  LYS A   3      47.796  17.477   6.901  1.00 84.83           C  
ATOM     19  C   LYS A   3      46.963  18.099   5.777  1.00 83.86           C  
ATOM     20  O   LYS A   3      47.316  17.973   4.598  1.00 83.48           O  
ATOM     21  CB  LYS A   3      49.195  18.093   7.070  1.00 85.15           C  
ATOM     22  CG  LYS A   3      49.966  17.557   8.314  1.00 83.67           C  
ATOM     23  CD  LYS A   3      51.305  18.231   8.517  1.00 84.61           C  
ATOM     24  CE  LYS A   3      52.311  17.192   9.119  1.00 87.34           C  
ATOM     25  NZ  LYS A   3      53.776  17.558   9.014  1.00 84.75           N  
ATOM     26  N   LEU A   4      45.864  18.755   6.171  1.00 82.20           N  
ATOM     27  CA  LEU A   4      44.766  19.146   5.282  1.00 81.09           C  
ATOM     28  C   LEU A   4      44.614  20.664   5.032  1.00 81.05           C  
ATOM     29  O   LEU A   4      44.552  21.492   5.968  1.00 80.34           O  
ATOM     30  CB  LEU A   4      43.451  18.585   5.839  1.00 80.94           C  
ATOM     31  CG  LEU A   4      42.069  18.816   5.186  1.00 81.67           C  
ATOM     32  CD1 LEU A   4      41.971  18.153   3.838  1.00 83.15           C  
ATOM     33  CD2 LEU A   4      40.920  18.308   6.069  1.00 80.59           C  
ATOM     34  N   GLY A   5      44.535  21.018   3.752  1.00 80.67           N  
ATOM     35  CA  GLY A   5      44.161  22.359   3.349  1.00 80.22           C  
ATOM     36  C   GLY A   5      42.683  22.348   3.016  1.00 80.45           C  
ATOM     37  O   GLY A   5      42.159  21.315   2.615  1.00 80.11           O  
ATOM     38  N   VAL A   6      41.991  23.473   3.165  1.00 80.19           N  
ATOM     39  CA  VAL A   6      40.594  23.490   2.742  1.00 80.60           C  
ATOM     40  C   VAL A   6      40.361  24.717   1.885  1.00 81.00           C  
ATOM     41  O   VAL A   6      40.872  25.794   2.186  1.00 82.54           O  
ATOM     42  CB  VAL A   6      39.591  23.453   3.942  1.00 80.34           C  
ATOM     43  CG1 VAL A   6      38.197  23.535   3.464  1.00 79.05           C  
ATOM     44  CG2 VAL A   6      39.752  22.194   4.758  1.00 79.54           C  
ATOM     45  N   ILE A   7      39.597  24.554   0.812  1.00 80.55           N  
ATOM     46  CA  ILE A   7      39.108  25.691   0.025  1.00 78.49           C  
ATOM     47  C   ILE A   7      37.611  25.534   0.110  1.00 79.18           C  
ATOM     48  O   ILE A   7      37.110  24.407   0.137  1.00 80.96           O  
ATOM     49  CB  ILE A   7      39.573  25.603  -1.460  1.00 78.21           C  
ATOM     50  CG1 ILE A   7      41.072  25.905  -1.588  1.00 76.83           C  
ATOM     51  CG2 ILE A   7      38.760  26.501  -2.353  1.00 73.55           C  
ATOM     52  CD1 ILE A   7      41.710  25.383  -2.856  1.00 77.18           C  
ATOM     53  N   GLY A   8      36.885  26.634   0.170  1.00 78.79           N  
ATOM     54  CA  GLY A   8      35.467  26.556   0.340  1.00 77.80           C  
ATOM     55  C   GLY A   8      35.195  26.729   1.804  1.00 77.41           C  
ATOM     56  O   GLY A   8      35.668  25.924   2.654  1.00 76.83           O  
ATOM     57  N   THR A   9      34.421  27.775   2.076  1.00 75.80           N  
ATOM     58  CA  THR A   9      34.126  28.202   3.431  1.00 75.19           C  
ATOM     59  C   THR A   9      32.635  28.012   3.738  1.00 75.21           C  
ATOM     60  O   THR A   9      32.169  28.330   4.825  1.00 73.81           O  
ATOM     61  CB  THR A   9      34.614  29.698   3.732  1.00 75.22           C  
ATOM     62  OG1 THR A   9      34.035  30.654   2.809  1.00 71.82           O  
ATOM     63  CG2 THR A   9      36.138  29.803   3.750  1.00 72.83           C  
ATOM     64  N   GLY A  10      31.894  27.466   2.773  1.00 75.86           N  
ATOM     65  CA  GLY A  10      30.520  26.967   3.039  1.00 75.15           C  
ATOM     66  C   GLY A  10      30.448  25.947   4.187  1.00 73.70           C  
ATOM     67  O   GLY A  10      31.455  25.438   4.588  1.00 72.79           O  
ATOM     68  N   ALA A  11      29.242  25.720   4.714  1.00 73.84           N  
ATOM     69  CA  ALA A  11      28.893  24.725   5.738  1.00 74.02           C  
ATOM     70  C   ALA A  11      29.516  23.366   5.503  1.00 74.61           C  
ATOM     71  O   ALA A  11      30.059  22.768   6.454  1.00 74.91           O  
ATOM     72  CB  ALA A  11      27.355  24.542   5.807  1.00 73.30           C  
ATOM     73  N   ILE A  12      29.417  22.879   4.262  1.00 73.88           N  
ATOM     74  CA  ILE A  12      29.854  21.517   3.922  1.00 74.37           C  
ATOM     75  C   ILE A  12      31.301  21.247   4.289  1.00 73.98           C  
ATOM     76  O   ILE A  12      31.614  20.135   4.767  1.00 74.45           O  
ATOM     77  CB  ILE A  12      29.607  21.155   2.408  1.00 74.71           C  
ATOM     78  CG1 ILE A  12      29.744  19.631   2.157  1.00 75.18           C  
ATOM     79  CG2 ILE A  12      30.519  21.980   1.497  1.00 72.89           C  
ATOM     80  CD1 ILE A  12      28.810  19.087   0.953  1.00 75.95           C  
ATOM     81  N   SER A  13      32.176  22.241   4.085  1.00 72.95           N  
ATOM     82  CA  SER A  13      33.568  22.117   4.469  1.00 72.53           C  
ATOM     83  C   SER A  13      33.645  21.788   5.958  1.00 73.25           C  
ATOM     84  O   SER A  13      34.499  21.024   6.393  1.00 73.38           O  
ATOM     85  CB  SER A  13      34.338  23.393   4.163  1.00 72.52           C  
ATOM     86  OG  SER A  13      34.490  23.615   2.765  1.00 72.39           O  
ATOM     87  N   HIS A  14      32.733  22.341   6.751  1.00 73.54           N  
ATOM     88  CA  HIS A  14      32.743  22.072   8.189  1.00 73.65           C  
ATOM     89  C   HIS A  14      32.371  20.639   8.456  1.00 74.05           C  
ATOM     90  O   HIS A  14      32.960  19.995   9.347  1.00 74.54           O  
ATOM     91  CB  HIS A  14      31.778  22.977   8.962  1.00 73.34           C  
ATOM     92  CG  HIS A  14      32.335  24.327   9.306  1.00 72.60           C  
ATOM     93  ND1 HIS A  14      33.577  24.505   9.889  1.00 74.78           N  
ATOM     94  CD2 HIS A  14      31.786  25.555   9.214  1.00 67.06           C  
ATOM     95  CE1 HIS A  14      33.778  25.793  10.103  1.00 71.51           C  
ATOM     96  NE2 HIS A  14      32.711  26.448   9.692  1.00 67.67           N  
ATOM     97  N   HIS A  15      31.373  20.156   7.715  1.00 73.91           N  
ATOM     98  CA  HIS A  15      30.970  18.782   7.847  0.50 74.60           C  
ATOM    100  C   HIS A  15      32.127  17.866   7.420  1.00 75.04           C  
ATOM    101  O   HIS A  15      32.384  16.844   8.062  1.00 74.45           O  
ATOM    102  CB  HIS A  15      29.664  18.528   7.097  0.50 74.20           C  
ATOM    104  CG  HIS A  15      28.528  19.378   7.583  0.50 75.71           C  
ATOM    106  ND1 HIS A  15      28.393  19.758   8.907  0.50 76.25           N  
ATOM    108  CD2 HIS A  15      27.472  19.924   6.927  0.50 75.39           C  
ATOM    110  CE1 HIS A  15      27.306  20.497   9.044  0.50 75.27           C  
ATOM    112  NE2 HIS A  15      26.729  20.611   7.859  0.50 75.60           N  
ATOM    114  N   PHE A  16      32.874  18.262   6.376  1.00 76.08           N  
ATOM    115  CA  PHE A  16      34.041  17.462   5.980  1.00 76.60           C  
ATOM    116  C   PHE A  16      35.107  17.459   7.033  1.00 76.51           C  
ATOM    117  O   PHE A  16      35.700  16.423   7.300  1.00 77.06           O  
ATOM    118  CB  PHE A  16      34.656  17.872   4.637  1.00 77.15           C  
ATOM    119  CG  PHE A  16      35.821  16.996   4.229  1.00 76.49           C  
ATOM    120  CD1 PHE A  16      35.607  15.760   3.639  1.00 76.40           C  
ATOM    121  CD2 PHE A  16      37.122  17.395   4.468  1.00 78.73           C  
ATOM    122  CE1 PHE A  16      36.673  14.927   3.280  1.00 79.29           C  
ATOM    123  CE2 PHE A  16      38.219  16.571   4.114  1.00 80.23           C  
ATOM    124  CZ  PHE A  16      38.000  15.338   3.521  1.00 79.39           C  
ATOM    125  N   ILE A  17      35.357  18.603   7.649  1.00 77.14           N  
ATOM    126  CA  ILE A  17      36.470  18.705   8.587  1.00 76.99           C  
ATOM    127  C   ILE A  17      36.084  17.926   9.820  1.00 77.69           C  
ATOM    128  O   ILE A  17      36.834  17.064  10.254  1.00 78.19           O  
ATOM    129  CB  ILE A  17      36.840  20.164   8.832  1.00 77.01           C  
ATOM    130  CG1 ILE A  17      37.418  20.763   7.549  1.00 77.85           C  
ATOM    131  CG2 ILE A  17      37.861  20.352   9.923  1.00 75.38           C  
ATOM    132  CD1 ILE A  17      37.020  22.260   7.357  1.00 76.17           C  
ATOM    133  N   GLU A  18      34.882  18.186  10.333  1.00 78.88           N  
ATOM    134  CA  GLU A  18      34.272  17.437  11.465  1.00 79.56           C  
ATOM    135  C   GLU A  18      34.554  15.950  11.371  1.00 78.94           C  
ATOM    136  O   GLU A  18      35.050  15.332  12.326  1.00 79.56           O  
ATOM    137  CB  GLU A  18      32.748  17.605  11.449  1.00 80.50           C  
ATOM    138  CG  GLU A  18      32.086  18.351  12.632  1.00 84.06           C  
ATOM    139  CD  GLU A  18      30.787  17.609  13.045  1.00 89.89           C  
ATOM    140  OE1 GLU A  18      30.825  16.793  14.023  1.00 88.76           O  
ATOM    141  OE2 GLU A  18      29.754  17.785  12.333  1.00 91.90           O  
ATOM    142  N   ALA A  19      34.227  15.398  10.207  1.00 77.83           N  
ATOM    143  CA  ALA A  19      34.346  13.985   9.926  1.00 77.44           C  
ATOM    144  C   ALA A  19      35.831  13.570   9.854  1.00 76.81           C  
ATOM    145  O   ALA A  19      36.239  12.591  10.479  1.00 76.85           O  
ATOM    146  CB  ALA A  19      33.582  13.629   8.622  1.00 76.89           C  
ATOM    147  N   ALA A  20      36.628  14.339   9.121  1.00 75.92           N  
ATOM    148  CA  ALA A  20      38.055  14.082   9.020  1.00 75.23           C  
ATOM    149  C   ALA A  20      38.807  14.203  10.348  1.00 74.97           C  
ATOM    150  O   ALA A  20      39.799  13.506  10.567  1.00 75.36           O  
ATOM    151  CB  ALA A  20      38.672  14.962   7.973  1.00 74.97           C  
ATOM    152  N   HIS A  21      38.354  15.045  11.264  1.00 74.61           N  
ATOM    153  CA  HIS A  21      39.039  15.018  12.567  1.00 74.99           C  
ATOM    154  C   HIS A  21      38.689  13.771  13.379  1.00 74.08           C  
ATOM    155  O   HIS A  21      39.531  13.241  14.050  1.00 73.40           O  
ATOM    156  CB  HIS A  21      38.865  16.320  13.387  1.00 75.40           C  
ATOM    157  CG  HIS A  21      39.671  17.474  12.862  1.00 76.71           C  
ATOM    158  ND1 HIS A  21      39.310  18.790  13.065  1.00 79.45           N  
ATOM    159  CD2 HIS A  21      40.799  17.504  12.111  1.00 76.75           C  
ATOM    160  CE1 HIS A  21      40.193  19.581  12.477  1.00 79.23           C  
ATOM    161  NE2 HIS A  21      41.105  18.824  11.889  1.00 78.41           N  
ATOM    162  N   THR A  22      37.449  13.304  13.252  1.00 74.08           N  
ATOM    163  CA  THR A  22      36.894  12.226  14.046  1.00 73.22           C  
ATOM    164  C   THR A  22      37.533  10.901  13.692  1.00 73.52           C  
ATOM    165  O   THR A  22      37.588   9.989  14.518  1.00 72.58           O  
ATOM    166  CB  THR A  22      35.400  12.096  13.770  1.00 73.36           C  
ATOM    167  OG1 THR A  22      34.787  13.354  14.016  1.00 71.72           O  
ATOM    168  CG2 THR A  22      34.732  10.991  14.651  1.00 72.21           C  
ATOM    169  N   SER A  23      37.999  10.790  12.455  1.00 73.45           N  
ATOM    170  CA  SER A  23      38.632   9.554  12.034  1.00 74.09           C  
ATOM    171  C   SER A  23      40.059   9.479  12.555  1.00 74.16           C  
ATOM    172  O   SER A  23      40.660   8.427  12.534  1.00 74.72           O  
ATOM    173  CB  SER A  23      38.591   9.431  10.511  1.00 74.02           C  
ATOM    174  OG  SER A  23      39.674  10.100   9.901  1.00 75.81           O  
ATOM    175  N   GLY A  24      40.595  10.600  13.036  1.00 74.84           N  
ATOM    176  CA  GLY A  24      41.964  10.681  13.558  1.00 75.28           C  
ATOM    177  C   GLY A  24      43.078  10.508  12.528  1.00 75.87           C  
ATOM    178  O   GLY A  24      44.228  10.266  12.900  1.00 75.96           O  
ATOM    179  N   GLU A  25      42.753  10.627  11.240  1.00 76.29           N  
ATOM    180  CA  GLU A  25      43.765  10.517  10.175  1.00 77.27           C  
ATOM    181  C   GLU A  25      44.067  11.846   9.465  1.00 77.56           C  
ATOM    182  O   GLU A  25      44.939  11.898   8.598  1.00 78.01           O  
ATOM    183  CB  GLU A  25      43.361   9.456   9.157  1.00 77.67           C  
ATOM    184  CG  GLU A  25      43.006   8.128   9.786  1.00 79.88           C  
ATOM    185  CD  GLU A  25      44.207   7.267  10.041  1.00 83.42           C  
ATOM    186  OE1 GLU A  25      45.181   7.394   9.272  1.00 85.65           O  
ATOM    187  OE2 GLU A  25      44.183   6.446  10.990  1.00 86.35           O  
ATOM    188  N   TYR A  26      43.386  12.917   9.882  1.00 77.38           N  
ATOM    189  CA  TYR A  26      43.516  14.243   9.291  1.00 77.30           C  
ATOM    190  C   TYR A  26      43.787  15.297  10.347  1.00 77.53           C  
ATOM    191  O   TYR A  26      43.337  15.162  11.482  1.00 78.76           O  
ATOM    192  CB  TYR A  26      42.215  14.637   8.572  1.00 76.90           C  
ATOM    193  CG  TYR A  26      41.833  13.734   7.408  1.00 76.79           C  
ATOM    194  CD1 TYR A  26      41.995  14.171   6.115  1.00 77.21           C  
ATOM    195  CD2 TYR A  26      41.326  12.432   7.611  1.00 75.04           C  
ATOM    196  CE1 TYR A  26      41.648  13.382   5.042  1.00 76.29           C  
ATOM    197  CE2 TYR A  26      40.985  11.644   6.558  1.00 74.44           C  
ATOM    198  CZ  TYR A  26      41.140  12.128   5.267  1.00 76.83           C  
ATOM    199  OH  TYR A  26      40.818  11.372   4.158  1.00 77.83           O  
ATOM    200  N   GLN A  27      44.519  16.346   9.970  1.00 76.22           N  
ATOM    201  CA  GLN A  27      44.577  17.552  10.769  1.00 74.96           C  
ATOM    202  C   GLN A  27      44.397  18.703   9.804  1.00 74.19           C  
ATOM    203  O   GLN A  27      45.072  18.765   8.765  1.00 73.55           O  
ATOM    204  CB  GLN A  27      45.909  17.682  11.452  1.00 75.00           C  
ATOM    205  CG  GLN A  27      45.844  18.191  12.867  1.00 75.24           C  
ATOM    206  CD  GLN A  27      47.231  18.471  13.379  1.00 75.13           C  
ATOM    207  OE1 GLN A  27      47.779  19.511  13.055  1.00 76.96           O  
ATOM    208  NE2 GLN A  27      47.823  17.540  14.137  1.00 71.40           N  
ATOM    209  N   LEU A  28      43.458  19.584  10.122  1.00 72.65           N  
ATOM    210  CA  LEU A  28      43.308  20.754   9.321  1.00 72.40           C  
ATOM    211  C   LEU A  28      44.496  21.694   9.599  1.00 72.78           C  
ATOM    212  O   LEU A  28      44.837  21.962  10.770  1.00 72.51           O  
ATOM    213  CB  LEU A  28      41.968  21.419   9.588  1.00 72.63           C  
ATOM    214  CG  LEU A  28      41.730  22.779   8.924  1.00 72.71           C  
ATOM    215  CD1 LEU A  28      41.650  22.587   7.409  1.00 73.47           C  
ATOM    216  CD2 LEU A  28      40.485  23.509   9.522  1.00 70.52           C  
ATOM    217  N   VAL A  29      45.146  22.162   8.533  1.00 72.54           N  
ATOM    218  CA  VAL A  29      46.229  23.113   8.706  1.00 72.75           C  
ATOM    219  C   VAL A  29      46.064  24.432   7.952  1.00 73.04           C  
ATOM    220  O   VAL A  29      46.785  25.379   8.215  1.00 74.14           O  
ATOM    221  CB  VAL A  29      47.645  22.497   8.464  1.00 72.68           C  
ATOM    222  CG1 VAL A  29      47.990  21.474   9.545  1.00 70.43           C  
ATOM    223  CG2 VAL A  29      47.746  21.917   7.061  1.00 74.16           C  
ATOM    224  N   ALA A  30      45.127  24.544   7.039  1.00 73.33           N  
ATOM    225  CA  ALA A  30      45.182  25.696   6.180  1.00 74.31           C  
ATOM    226  C   ALA A  30      43.875  25.966   5.481  1.00 75.20           C  
ATOM    227  O   ALA A  30      43.190  25.044   5.031  1.00 75.12           O  
ATOM    228  CB  ALA A  30      46.319  25.521   5.154  1.00 74.35           C  
ATOM    229  N   ILE A  31      43.524  27.238   5.372  1.00 75.77           N  
ATOM    230  CA  ILE A  31      42.299  27.579   4.694  1.00 76.67           C  
ATOM    231  C   ILE A  31      42.556  28.696   3.712  1.00 77.78           C  
ATOM    232  O   ILE A  31      43.317  29.627   3.996  1.00 78.94           O  
ATOM    233  CB  ILE A  31      41.231  27.947   5.712  1.00 76.78           C  
ATOM    234  CG1 ILE A  31      40.711  26.670   6.336  1.00 77.08           C  
ATOM    235  CG2 ILE A  31      40.058  28.710   5.074  1.00 76.55           C  
ATOM    236  CD1 ILE A  31      40.656  26.765   7.791  1.00 81.44           C  
ATOM    237  N   TYR A  32      41.936  28.627   2.553  1.00 78.26           N  
ATOM    238  CA  TYR A  32      42.124  29.695   1.619  1.00 79.06           C  
ATOM    239  C   TYR A  32      40.771  30.332   1.315  1.00 80.30           C  
ATOM    240  O   TYR A  32      39.729  29.646   1.223  1.00 81.46           O  
ATOM    241  CB  TYR A  32      42.826  29.194   0.336  1.00 79.31           C  
ATOM    242  CG  TYR A  32      42.466  30.052  -0.835  1.00 79.03           C  
ATOM    243  CD1 TYR A  32      43.255  31.137  -1.187  1.00 78.85           C  
ATOM    244  CD2 TYR A  32      41.273  29.825  -1.551  1.00 79.93           C  
ATOM    245  CE1 TYR A  32      42.900  31.978  -2.253  1.00 79.62           C  
ATOM    246  CE2 TYR A  32      40.901  30.661  -2.592  1.00 80.76           C  
ATOM    247  CZ  TYR A  32      41.725  31.739  -2.936  1.00 79.55           C  
ATOM    248  OH  TYR A  32      41.377  32.558  -3.971  1.00 79.38           O  
ATOM    249  N   SER A  33      40.768  31.642   1.114  1.00 80.36           N  
ATOM    250  CA  SER A  33      39.579  32.284   0.638  1.00 80.84           C  
ATOM    251  C   SER A  33      39.988  33.583   0.002  1.00 81.50           C  
ATOM    252  O   SER A  33      40.982  34.177   0.445  1.00 82.08           O  
ATOM    253  CB  SER A  33      38.628  32.486   1.789  1.00 80.63           C  
ATOM    254  OG  SER A  33      37.590  33.356   1.392  1.00 82.93           O  
ATOM    255  N   ARG A  34      39.267  34.028  -1.032  1.00 81.87           N  
ATOM    256  CA  ARG A  34      39.704  35.216  -1.790  1.00 82.93           C  
ATOM    257  C   ARG A  34      39.886  36.412  -0.862  1.00 81.50           C  
ATOM    258  O   ARG A  34      40.802  37.211  -1.044  1.00 80.25           O  
ATOM    259  CB  ARG A  34      38.802  35.556  -2.994  1.00 83.21           C  
ATOM    260  CG  ARG A  34      39.637  35.996  -4.266  1.00 86.41           C  
ATOM    261  CD  ARG A  34      38.796  36.315  -5.583  1.00 86.87           C  
ATOM    262  NE  ARG A  34      38.633  37.765  -5.897  1.00 92.91           N  
ATOM    263  CZ  ARG A  34      37.913  38.646  -5.175  1.00 94.36           C  
ATOM    264  NH1 ARG A  34      37.275  38.264  -4.065  1.00 95.68           N  
ATOM    265  NH2 ARG A  34      37.828  39.922  -5.554  1.00 92.22           N  
ATOM    266  N   LYS A  35      39.028  36.465   0.157  1.00 80.92           N  
ATOM    267  CA  LYS A  35      39.147  37.408   1.276  1.00 80.23           C  
ATOM    268  C   LYS A  35      39.567  36.695   2.559  1.00 79.43           C  
ATOM    269  O   LYS A  35      38.943  35.715   2.999  1.00 78.81           O  
ATOM    270  CB  LYS A  35      37.845  38.195   1.500  1.00 80.25           C  
ATOM    271  CG  LYS A  35      37.499  39.114   0.345  1.00 81.71           C  
ATOM    272  CD  LYS A  35      36.034  38.986  -0.040  1.00 84.87           C  
ATOM    273  CE  LYS A  35      35.219  40.236   0.328  1.00 89.52           C  
ATOM    274  NZ  LYS A  35      33.764  39.889   0.359  1.00 90.38           N  
ATOM    275  N   LEU A  36      40.629  37.229   3.154  1.00 78.68           N  
ATOM    276  CA  LEU A  36      41.216  36.713   4.362  1.00 77.76           C  
ATOM    277  C   LEU A  36      40.212  36.658   5.507  1.00 77.92           C  
ATOM    278  O   LEU A  36      40.257  35.720   6.336  1.00 77.28           O  
ATOM    279  CB  LEU A  36      42.390  37.618   4.762  1.00 77.86           C  
ATOM    280  CG  LEU A  36      43.504  36.995   5.605  1.00 76.80           C  
ATOM    281  CD1 LEU A  36      44.256  35.883   4.799  1.00 75.96           C  
ATOM    282  CD2 LEU A  36      44.425  38.037   6.099  1.00 72.88           C  
ATOM    283  N   GLU A  37      39.325  37.665   5.552  1.00 78.08           N  
ATOM    284  CA  GLU A  37      38.398  37.846   6.673  1.00 78.75           C  
ATOM    285  C   GLU A  37      37.275  36.788   6.661  1.00 78.52           C  
ATOM    286  O   GLU A  37      36.739  36.445   7.705  1.00 79.27           O  
ATOM    287  CB  GLU A  37      37.811  39.268   6.739  1.00 79.14           C  
ATOM    288  CG  GLU A  37      38.622  40.422   6.076  1.00 82.96           C  
ATOM    289  CD  GLU A  37      38.188  40.794   4.618  1.00 86.70           C  
ATOM    290  OE1 GLU A  37      36.965  40.904   4.298  1.00 84.69           O  
ATOM    291  OE2 GLU A  37      39.116  41.007   3.791  1.00 89.07           O  
ATOM    292  N   THR A  38      36.903  36.291   5.488  1.00 78.01           N  
ATOM    293  CA  THR A  38      36.067  35.096   5.384  1.00 77.63           C  
ATOM    294  C   THR A  38      36.781  33.819   5.922  1.00 78.70           C  
ATOM    295  O   THR A  38      36.181  33.016   6.653  1.00 79.55           O  
ATOM    296  CB  THR A  38      35.718  34.814   3.908  1.00 77.46           C  
ATOM    297  OG1 THR A  38      35.154  35.987   3.334  1.00 73.60           O  
ATOM    298  CG2 THR A  38      34.763  33.627   3.790  1.00 75.50           C  
ATOM    299  N   ALA A  39      38.039  33.615   5.536  1.00 77.94           N  
ATOM    300  CA  ALA A  39      38.775  32.478   6.027  1.00 77.50           C  
ATOM    301  C   ALA A  39      38.916  32.573   7.546  1.00 77.65           C  
ATOM    302  O   ALA A  39      38.886  31.545   8.263  1.00 77.08           O  
ATOM    303  CB  ALA A  39      40.131  32.438   5.379  1.00 77.84           C  
ATOM    304  N   ALA A  40      39.077  33.802   8.047  1.00 76.89           N  
ATOM    305  CA  ALA A  40      39.288  33.966   9.475  1.00 76.95           C  
ATOM    306  C   ALA A  40      38.074  33.505  10.276  1.00 76.70           C  
ATOM    307  O   ALA A  40      38.210  32.637  11.161  1.00 76.63           O  
ATOM    308  CB  ALA A  40      39.711  35.414   9.843  1.00 77.38           C  
ATOM    309  N   THR A  41      36.894  34.032   9.953  1.00 76.16           N  
ATOM    310  CA  THR A  41      35.682  33.522  10.599  1.00 77.21           C  
ATOM    311  C   THR A  41      35.424  32.039  10.375  1.00 77.70           C  
ATOM    312  O   THR A  41      34.887  31.398  11.268  1.00 78.56           O  
ATOM    313  CB  THR A  41      34.392  34.224  10.221  1.00 76.75           C  
ATOM    314  OG1 THR A  41      34.581  34.960   9.014  1.00 77.31           O  
ATOM    315  CG2 THR A  41      33.949  35.140  11.356  1.00 78.63           C  
ATOM    316  N   PHE A  42      35.781  31.496   9.212  1.00 77.16           N  
ATOM    317  CA  PHE A  42      35.661  30.071   9.067  1.00 77.96           C  
ATOM    318  C   PHE A  42      36.537  29.332  10.079  1.00 77.90           C  
ATOM    319  O   PHE A  42      36.075  28.357  10.676  1.00 77.30           O  
ATOM    320  CB  PHE A  42      35.990  29.588   7.651  1.00 78.43           C  
ATOM    321  CG  PHE A  42      35.641  28.145   7.431  1.00 79.31           C  
ATOM    322  CD1 PHE A  42      34.311  27.761   7.188  1.00 80.67           C  
ATOM    323  CD2 PHE A  42      36.632  27.162   7.486  1.00 80.10           C  
ATOM    324  CE1 PHE A  42      33.981  26.433   6.987  1.00 79.69           C  
ATOM    325  CE2 PHE A  42      36.323  25.827   7.289  1.00 77.06           C  
ATOM    326  CZ  PHE A  42      34.987  25.459   7.039  1.00 78.38           C  
ATOM    327  N   ALA A  43      37.773  29.826  10.276  1.00 78.03           N  
ATOM    328  CA  ALA A  43      38.776  29.172  11.144  1.00 78.36           C  
ATOM    329  C   ALA A  43      38.561  29.353  12.636  1.00 78.69           C  
ATOM    330  O   ALA A  43      39.077  28.571  13.401  1.00 79.25           O  
ATOM    331  CB  ALA A  43      40.183  29.622  10.787  1.00 78.05           C  
ATOM    332  N   SER A  44      37.798  30.361  13.054  1.00 79.14           N  
ATOM    333  CA  SER A  44      37.663  30.697  14.483  1.00 79.49           C  
ATOM    334  C   SER A  44      37.471  29.504  15.428  1.00 79.55           C  
ATOM    335  O   SER A  44      37.975  29.515  16.564  1.00 80.24           O  
ATOM    336  CB  SER A  44      36.562  31.749  14.726  1.00 79.27           C  
ATOM    337  OG  SER A  44      35.310  31.321  14.224  1.00 80.56           O  
ATOM    338  N   ARG A  45      36.756  28.484  14.963  1.00 79.41           N  
ATOM    339  CA  ARG A  45      36.455  27.306  15.781  1.00 78.73           C  
ATOM    340  C   ARG A  45      37.557  26.246  15.768  1.00 78.65           C  
ATOM    341  O   ARG A  45      37.428  25.225  16.417  1.00 78.87           O  
ATOM    342  CB  ARG A  45      35.119  26.684  15.360  1.00 78.01           C  
ATOM    343  CG  ARG A  45      35.268  25.655  14.268  1.00 77.95           C  
ATOM    344  CD  ARG A  45      33.942  25.177  13.727  1.00 79.09           C  
ATOM    345  NE  ARG A  45      33.135  26.326  13.372  1.00 79.03           N  
ATOM    346  CZ  ARG A  45      31.880  26.284  12.968  1.00 76.61           C  
ATOM    347  NH1 ARG A  45      31.251  25.125  12.832  1.00 71.38           N  
ATOM    348  NH2 ARG A  45      31.267  27.433  12.718  1.00 76.26           N  
ATOM    349  N   TYR A  46      38.623  26.465  15.015  1.00 79.23           N  
ATOM    350  CA  TYR A  46      39.754  25.520  14.986  1.00 80.08           C  
ATOM    351  C   TYR A  46      41.035  26.257  15.403  1.00 80.98           C  
ATOM    352  O   TYR A  46      41.031  27.496  15.554  1.00 81.08           O  
ATOM    353  CB  TYR A  46      39.933  24.889  13.594  1.00 79.96           C  
ATOM    354  CG  TYR A  46      38.676  24.396  12.875  1.00 79.12           C  
ATOM    355  CD1 TYR A  46      37.983  23.269  13.319  1.00 79.49           C  
ATOM    356  CD2 TYR A  46      38.208  25.041  11.737  1.00 80.52           C  
ATOM    357  CE1 TYR A  46      36.841  22.807  12.669  1.00 78.44           C  
ATOM    358  CE2 TYR A  46      37.061  24.585  11.062  1.00 80.71           C  
ATOM    359  CZ  TYR A  46      36.382  23.464  11.537  1.00 80.14           C  
ATOM    360  OH  TYR A  46      35.252  23.011  10.887  1.00 78.76           O  
ATOM    361  N   GLN A  47      42.133  25.529  15.596  1.00 81.98           N  
ATOM    362  CA  GLN A  47      43.390  26.185  16.004  1.00 83.53           C  
ATOM    363  C   GLN A  47      44.593  25.710  15.199  1.00 83.79           C  
ATOM    364  O   GLN A  47      44.564  24.616  14.669  1.00 84.25           O  
ATOM    365  CB  GLN A  47      43.668  25.960  17.495  1.00 84.12           C  
ATOM    366  CG  GLN A  47      42.448  26.028  18.418  1.00 86.26           C  
ATOM    367  CD  GLN A  47      42.450  24.867  19.411  1.00 88.51           C  
ATOM    368  OE1 GLN A  47      42.062  23.728  19.072  1.00 89.03           O  
ATOM    369  NE2 GLN A  47      42.910  25.141  20.637  1.00 88.18           N  
ATOM    370  N   ASN A  48      45.655  26.522  15.141  1.00 84.27           N  
ATOM    371  CA  ASN A  48      46.916  26.205  14.419  1.00 84.19           C  
ATOM    372  C   ASN A  48      46.640  26.211  12.944  1.00 84.12           C  
ATOM    373  O   ASN A  48      47.036  25.290  12.210  1.00 85.14           O  
ATOM    374  CB  ASN A  48      47.544  24.843  14.828  1.00 84.28           C  
ATOM    375  CG  ASN A  48      49.063  24.700  14.408  1.00 84.51           C  
ATOM    376  OD1 ASN A  48      49.736  25.681  14.050  1.00 85.81           O  
ATOM    377  ND2 ASN A  48      49.585  23.477  14.487  1.00 79.99           N  
ATOM    378  N   ILE A  49      45.944  27.238  12.503  1.00 83.26           N  
ATOM    379  CA  ILE A  49      45.510  27.270  11.130  1.00 82.62           C  
ATOM    380  C   ILE A  49      46.034  28.463  10.374  1.00 82.38           C  
ATOM    381  O   ILE A  49      45.773  29.591  10.733  1.00 83.41           O  
ATOM    382  CB  ILE A  49      43.980  27.152  11.038  1.00 82.43           C  
ATOM    383  CG1 ILE A  49      43.632  25.664  11.233  1.00 84.07           C  
ATOM    384  CG2 ILE A  49      43.526  27.504   9.659  1.00 79.86           C  
ATOM    385  CD1 ILE A  49      42.732  25.368  12.359  1.00 84.65           C  
ATOM    386  N   GLN A  50      46.792  28.205   9.325  1.00 81.86           N  
ATOM    387  CA  GLN A  50      47.179  29.269   8.389  1.00 81.59           C  
ATOM    388  C   GLN A  50      46.070  29.754   7.448  1.00 80.03           C  
ATOM    389  O   GLN A  50      45.417  28.946   6.757  1.00 79.84           O  
ATOM    390  CB  GLN A  50      48.321  28.783   7.528  1.00 81.82           C  
ATOM    391  CG  GLN A  50      49.129  27.739   8.213  1.00 84.47           C  
ATOM    392  CD  GLN A  50      50.569  28.045   8.096  1.00 87.93           C  
ATOM    393  OE1 GLN A  50      51.362  27.187   7.693  1.00 87.86           O  
ATOM    394  NE2 GLN A  50      50.938  29.307   8.430  1.00 90.42           N  
ATOM    395  N   LEU A  51      45.916  31.077   7.396  1.00 78.67           N  
ATOM    396  CA  LEU A  51      44.976  31.738   6.474  1.00 77.39           C  
ATOM    397  C   LEU A  51      45.662  32.235   5.205  1.00 76.41           C  
ATOM    398  O   LEU A  51      46.779  32.710   5.245  1.00 75.82           O  
ATOM    399  CB  LEU A  51      44.245  32.872   7.189  1.00 76.76           C  
ATOM    400  CG  LEU A  51      43.697  32.371   8.538  1.00 77.47           C  
ATOM    401  CD1 LEU A  51      43.022  33.505   9.284  1.00 75.18           C  
ATOM    402  CD2 LEU A  51      42.758  31.083   8.394  1.00 74.99           C  
ATOM    403  N   PHE A  52      44.996  32.090   4.071  1.00 75.78           N  
ATOM    404  CA  PHE A  52      45.617  32.442   2.819  1.00 75.69           C  
ATOM    405  C   PHE A  52      44.649  33.193   1.918  1.00 76.15           C  
ATOM    406  O   PHE A  52      43.491  32.848   1.843  1.00 75.92           O  
ATOM    407  CB  PHE A  52      46.066  31.180   2.104  1.00 74.69           C  
ATOM    408  CG  PHE A  52      47.243  30.511   2.720  1.00 73.84           C  
ATOM    409  CD1 PHE A  52      47.086  29.587   3.736  1.00 73.04           C  
ATOM    410  CD2 PHE A  52      48.531  30.765   2.247  1.00 73.41           C  
ATOM    411  CE1 PHE A  52      48.214  28.939   4.294  1.00 72.27           C  
ATOM    412  CE2 PHE A  52      49.644  30.115   2.791  1.00 71.82           C  
ATOM    413  CZ  PHE A  52      49.477  29.200   3.811  1.00 71.70           C  
ATOM    414  N   ASP A  53      45.119  34.225   1.234  1.00 77.20           N  
ATOM    415  CA  ASP A  53      44.269  34.895   0.251  1.00 78.57           C  
ATOM    416  C   ASP A  53      44.901  34.898  -1.125  1.00 78.83           C  
ATOM    417  O   ASP A  53      44.469  35.612  -1.985  1.00 79.14           O  
ATOM    418  CB  ASP A  53      43.801  36.326   0.703  1.00 77.72           C  
ATOM    419  CG  ASP A  53      44.958  37.331   0.853  1.00 78.74           C  
ATOM    420  OD1 ASP A  53      44.688  38.534   1.176  1.00 78.11           O  
ATOM    421  OD2 ASP A  53      46.134  36.938   0.641  1.00 77.10           O  
ATOM    422  N   GLN A  54      45.937  34.102  -1.321  1.00 80.31           N  
ATOM    423  CA  GLN A  54      46.557  33.964  -2.640  1.00 81.52           C  
ATOM    424  C   GLN A  54      46.778  32.484  -2.867  1.00 81.55           C  
ATOM    425  O   GLN A  54      47.448  31.816  -2.066  1.00 81.34           O  
ATOM    426  CB  GLN A  54      47.912  34.676  -2.693  1.00 82.36           C  
ATOM    427  CG  GLN A  54      47.895  36.181  -2.407  1.00 84.43           C  
ATOM    428  CD  GLN A  54      48.136  37.009  -3.659  1.00 87.25           C  
ATOM    429  OE1 GLN A  54      49.230  36.980  -4.242  1.00 87.22           O  
ATOM    430  NE2 GLN A  54      47.119  37.774  -4.067  1.00 87.21           N  
ATOM    431  N   LEU A  55      46.231  31.966  -3.962  1.00 81.82           N  
ATOM    432  CA  LEU A  55      46.238  30.520  -4.186  1.00 81.62           C  
ATOM    433  C   LEU A  55      47.627  29.898  -4.299  1.00 81.34           C  
ATOM    434  O   LEU A  55      47.871  28.795  -3.793  1.00 81.51           O  
ATOM    435  CB  LEU A  55      45.376  30.158  -5.376  1.00 81.20           C  
ATOM    436  CG  LEU A  55      44.669  28.821  -5.167  1.00 82.78           C  
ATOM    437  CD1 LEU A  55      43.667  28.952  -4.061  1.00 82.39           C  
ATOM    438  CD2 LEU A  55      44.002  28.238  -6.449  1.00 82.30           C  
ATOM    439  N   GLU A  56      48.539  30.596  -4.954  1.00 80.97           N  
ATOM    440  CA  GLU A  56      49.858  30.043  -5.153  1.00 81.03           C  
ATOM    441  C   GLU A  56      50.648  29.962  -3.856  1.00 80.25           C  
ATOM    442  O   GLU A  56      51.307  28.952  -3.588  1.00 80.03           O  
ATOM    443  CB  GLU A  56      50.617  30.800  -6.234  1.00 82.02           C  
ATOM    444  CG  GLU A  56      50.478  30.137  -7.623  1.00 85.61           C  
ATOM    445  CD  GLU A  56      51.040  28.678  -7.689  1.00 90.38           C  
ATOM    446  OE1 GLU A  56      50.281  27.741  -8.095  1.00 92.10           O  
ATOM    447  OE2 GLU A  56      52.230  28.471  -7.331  1.00 90.89           O  
ATOM    448  N   VAL A  57      50.568  31.008  -3.036  1.00 79.22           N  
ATOM    449  CA  VAL A  57      51.135  30.950  -1.682  1.00 77.85           C  
ATOM    450  C   VAL A  57      50.596  29.717  -0.915  1.00 77.09           C  
ATOM    451  O   VAL A  57      51.379  28.950  -0.334  1.00 75.56           O  
ATOM    452  CB  VAL A  57      50.880  32.274  -0.929  1.00 78.02           C  
ATOM    453  CG1 VAL A  57      51.445  32.253   0.506  1.00 76.94           C  
ATOM    454  CG2 VAL A  57      51.460  33.422  -1.722  1.00 78.02           C  
ATOM    455  N   PHE A  58      49.270  29.535  -0.972  1.00 76.52           N  
ATOM    456  CA  PHE A  58      48.551  28.392  -0.379  1.00 76.58           C  
ATOM    457  C   PHE A  58      49.094  26.994  -0.774  1.00 76.84           C  
ATOM    458  O   PHE A  58      49.484  26.152   0.079  1.00 76.60           O  
ATOM    459  CB  PHE A  58      47.078  28.501  -0.721  1.00 75.80           C  
ATOM    460  CG  PHE A  58      46.231  27.373  -0.194  1.00 75.93           C  
ATOM    461  CD1 PHE A  58      46.049  27.196   1.179  1.00 75.56           C  
ATOM    462  CD2 PHE A  58      45.574  26.515  -1.072  1.00 75.35           C  
ATOM    463  CE1 PHE A  58      45.229  26.190   1.689  1.00 74.65           C  
ATOM    464  CE2 PHE A  58      44.737  25.476  -0.581  1.00 76.32           C  
ATOM    465  CZ  PHE A  58      44.561  25.317   0.815  1.00 75.24           C  
ATOM    466  N   PHE A  59      49.155  26.782  -2.077  1.00 76.89           N  
ATOM    467  CA  PHE A  59      49.794  25.607  -2.646  1.00 76.49           C  
ATOM    468  C   PHE A  59      51.302  25.440  -2.422  1.00 77.26           C  
ATOM    469  O   PHE A  59      51.788  24.307  -2.419  1.00 78.64           O  
ATOM    470  CB  PHE A  59      49.439  25.531  -4.112  1.00 75.93           C  
ATOM    471  CG  PHE A  59      48.007  25.227  -4.337  1.00 74.62           C  
ATOM    472  CD1 PHE A  59      47.363  24.322  -3.530  1.00 71.84           C  
ATOM    473  CD2 PHE A  59      47.295  25.853  -5.339  1.00 76.33           C  
ATOM    474  CE1 PHE A  59      46.041  24.038  -3.719  1.00 74.30           C  
ATOM    475  CE2 PHE A  59      45.936  25.563  -5.559  1.00 75.25           C  
ATOM    476  CZ  PHE A  59      45.309  24.664  -4.738  1.00 75.17           C  
ATOM    477  N   LYS A  60      52.055  26.513  -2.219  1.00 77.50           N  
ATOM    478  CA  LYS A  60      53.460  26.326  -1.877  1.00 77.98           C  
ATOM    479  C   LYS A  60      53.689  25.894  -0.438  1.00 78.64           C  
ATOM    480  O   LYS A  60      54.793  25.476  -0.098  1.00 78.96           O  
ATOM    481  CB  LYS A  60      54.283  27.564  -2.189  1.00 78.11           C  
ATOM    482  CG  LYS A  60      54.651  27.646  -3.643  1.00 78.21           C  
ATOM    483  CD  LYS A  60      56.003  28.311  -3.822  1.00 79.22           C  
ATOM    484  CE  LYS A  60      56.168  28.772  -5.250  1.00 78.90           C  
ATOM    485  NZ  LYS A  60      55.500  27.843  -6.205  1.00 77.55           N  
ATOM    486  N   SER A  61      52.649  26.011   0.391  1.00 79.86           N  
ATOM    487  CA  SER A  61      52.661  25.640   1.817  1.00 81.11           C  
ATOM    488  C   SER A  61      52.695  24.150   1.937  1.00 81.83           C  
ATOM    489  O   SER A  61      52.263  23.447   1.025  1.00 81.63           O  
ATOM    490  CB  SER A  61      51.373  26.106   2.510  1.00 81.65           C  
ATOM    491  OG  SER A  61      50.908  25.121   3.434  1.00 83.44           O  
ATOM    492  N   SER A  62      53.152  23.639   3.072  1.00 82.94           N  
ATOM    493  CA  SER A  62      53.214  22.172   3.155  1.00 84.13           C  
ATOM    494  C   SER A  62      52.145  21.509   4.024  1.00 84.36           C  
ATOM    495  O   SER A  62      52.171  21.570   5.275  1.00 85.03           O  
ATOM    496  CB  SER A  62      54.629  21.655   3.419  1.00 83.43           C  
ATOM    497  OG  SER A  62      55.042  22.030   4.696  1.00 83.81           O  
ATOM    498  N   PHE A  63      51.165  20.969   3.298  1.00 83.72           N  
ATOM    499  CA  PHE A  63      50.197  19.984   3.751  1.00 82.90           C  
ATOM    500  C   PHE A  63      50.103  18.983   2.600  1.00 82.51           C  
ATOM    501  O   PHE A  63      50.427  19.327   1.466  1.00 81.85           O  
ATOM    502  CB  PHE A  63      48.840  20.620   4.066  1.00 82.82           C  
ATOM    503  CG  PHE A  63      48.332  21.567   3.018  1.00 82.43           C  
ATOM    504  CD1 PHE A  63      47.826  21.099   1.817  1.00 82.73           C  
ATOM    505  CD2 PHE A  63      48.314  22.949   3.261  1.00 83.81           C  
ATOM    506  CE1 PHE A  63      47.336  21.991   0.846  1.00 84.40           C  
ATOM    507  CE2 PHE A  63      47.832  23.844   2.306  1.00 82.79           C  
ATOM    508  CZ  PHE A  63      47.335  23.361   1.089  1.00 82.18           C  
ATOM    509  N   ASP A  64      49.678  17.755   2.873  1.00 82.52           N  
ATOM    510  CA  ASP A  64      49.740  16.695   1.850  1.00 82.72           C  
ATOM    511  C   ASP A  64      48.597  16.746   0.879  1.00 83.01           C  
ATOM    512  O   ASP A  64      48.788  16.376  -0.279  1.00 84.04           O  
ATOM    513  CB  ASP A  64      49.722  15.308   2.477  1.00 82.55           C  
ATOM    514  CG  ASP A  64      50.745  15.153   3.557  1.00 82.22           C  
ATOM    515  OD1 ASP A  64      51.966  15.057   3.246  1.00 80.26           O  
ATOM    516  OD2 ASP A  64      50.303  15.127   4.719  1.00 82.26           O  
ATOM    517  N   LEU A  65      47.439  17.236   1.349  1.00 82.82           N  
ATOM    518  CA  LEU A  65      46.113  16.964   0.779  1.00 82.23           C  
ATOM    519  C   LEU A  65      45.212  18.192   0.867  1.00 82.32           C  
ATOM    520  O   LEU A  65      45.048  18.764   1.957  1.00 83.13           O  
ATOM    521  CB  LEU A  65      45.468  15.866   1.614  1.00 82.20           C  
ATOM    522  CG  LEU A  65      44.400  15.013   0.961  1.00 83.98           C  
ATOM    523  CD1 LEU A  65      43.563  14.355   2.029  1.00 87.13           C  
ATOM    524  CD2 LEU A  65      43.516  15.840   0.121  1.00 87.22           C  
ATOM    525  N   VAL A  66      44.595  18.589  -0.251  1.00 81.36           N  
ATOM    526  CA  VAL A  66      43.655  19.692  -0.244  1.00 79.55           C  
ATOM    527  C   VAL A  66      42.234  19.237  -0.569  1.00 79.55           C  
ATOM    528  O   VAL A  66      42.025  18.579  -1.544  1.00 79.18           O  
ATOM    529  CB  VAL A  66      44.106  20.908  -1.154  1.00 79.79           C  
ATOM    530  CG1 VAL A  66      44.187  20.561  -2.660  1.00 77.43           C  
ATOM    531  CG2 VAL A  66      43.178  22.069  -0.948  1.00 78.34           C  
ATOM    532  N   TYR A  67      41.273  19.617   0.276  1.00 79.47           N  
ATOM    533  CA  TYR A  67      39.854  19.398   0.068  1.00 77.97           C  
ATOM    534  C   TYR A  67      39.216  20.653  -0.534  1.00 78.97           C  
ATOM    535  O   TYR A  67      39.282  21.787   0.048  1.00 80.39           O  
ATOM    536  CB  TYR A  67      39.186  19.031   1.377  1.00 77.01           C  
ATOM    537  CG  TYR A  67      37.693  18.954   1.275  1.00 77.73           C  
ATOM    538  CD1 TYR A  67      37.065  17.860   0.684  1.00 78.65           C  
ATOM    539  CD2 TYR A  67      36.895  19.999   1.732  1.00 80.54           C  
ATOM    540  CE1 TYR A  67      35.683  17.809   0.568  1.00 79.43           C  
ATOM    541  CE2 TYR A  67      35.511  19.971   1.623  1.00 80.89           C  
ATOM    542  CZ  TYR A  67      34.913  18.867   1.057  1.00 80.30           C  
ATOM    543  OH  TYR A  67      33.559  18.832   0.969  1.00 79.03           O  
ATOM    544  N   ILE A  68      38.577  20.473  -1.696  1.00 78.10           N  
ATOM    545  CA  ILE A  68      38.075  21.593  -2.457  1.00 76.31           C  
ATOM    546  C   ILE A  68      36.551  21.574  -2.441  1.00 77.56           C  
ATOM    547  O   ILE A  68      35.938  20.628  -2.927  1.00 77.55           O  
ATOM    548  CB  ILE A  68      38.642  21.536  -3.894  1.00 75.57           C  
ATOM    549  CG1 ILE A  68      40.182  21.372  -3.834  1.00 73.23           C  
ATOM    550  CG2 ILE A  68      38.143  22.727  -4.705  1.00 72.73           C  
ATOM    551  CD1 ILE A  68      40.957  21.766  -5.073  1.00 67.35           C  
ATOM    552  N   ALA A  69      35.917  22.605  -1.878  1.00 78.06           N  
ATOM    553  CA  ALA A  69      34.454  22.691  -1.980  1.00 78.40           C  
ATOM    554  C   ALA A  69      34.029  24.062  -2.405  1.00 79.88           C  
ATOM    555  O   ALA A  69      33.048  24.572  -1.901  1.00 80.46           O  
ATOM    556  CB  ALA A  69      33.787  22.329  -0.710  1.00 77.91           C  
ATOM    557  N   SER A  70      34.780  24.662  -3.321  1.00 81.06           N  
ATOM    558  CA  SER A  70      34.414  25.940  -3.881  1.00 83.36           C  
ATOM    559  C   SER A  70      33.210  25.769  -4.833  1.00 84.43           C  
ATOM    560  O   SER A  70      32.647  24.671  -4.948  1.00 84.18           O  
ATOM    561  CB  SER A  70      35.611  26.550  -4.613  1.00 83.59           C  
ATOM    562  OG  SER A  70      36.362  25.534  -5.269  1.00 84.91           O  
ATOM    563  N   PRO A  71      32.740  26.873  -5.438  1.00 85.24           N  
ATOM    564  CA  PRO A  71      31.754  26.730  -6.533  1.00 86.15           C  
ATOM    565  C   PRO A  71      32.265  25.881  -7.703  1.00 87.52           C  
ATOM    566  O   PRO A  71      33.417  26.061  -8.169  1.00 87.96           O  
ATOM    567  CB  PRO A  71      31.491  28.168  -6.963  1.00 85.60           C  
ATOM    568  CG  PRO A  71      31.782  28.969  -5.681  1.00 85.85           C  
ATOM    569  CD  PRO A  71      32.968  28.280  -5.060  1.00 84.83           C  
ATOM    570  N   ASN A  72      31.409  24.955  -8.159  1.00 88.29           N  
ATOM    571  CA  ASN A  72      31.768  23.984  -9.211  1.00 88.56           C  
ATOM    572  C   ASN A  72      32.740  24.446 -10.297  1.00 87.59           C  
ATOM    573  O   ASN A  72      33.683  23.718 -10.617  1.00 87.65           O  
ATOM    574  CB  ASN A  72      30.543  23.395  -9.909  1.00 88.44           C  
ATOM    575  CG  ASN A  72      30.949  22.296 -10.919  1.00 93.25           C  
ATOM    576  OD1 ASN A  72      31.425  21.219 -10.531  1.00 94.15           O  
ATOM    577  ND2 ASN A  72      30.804  22.586 -12.222  1.00 99.01           N  
ATOM    578  N   SER A  73      32.495  25.630 -10.870  1.00 86.70           N  
ATOM    579  CA  SER A  73      33.233  26.101 -12.057  1.00 85.60           C  
ATOM    580  C   SER A  73      34.682  26.434 -11.724  1.00 85.08           C  
ATOM    581  O   SER A  73      35.560  26.435 -12.593  1.00 84.79           O  
ATOM    582  CB  SER A  73      32.538  27.297 -12.662  1.00 85.53           C  
ATOM    583  OG  SER A  73      31.819  27.961 -11.639  1.00 84.76           O  
ATOM    584  N   LEU A  74      34.943  26.665 -10.444  1.00 84.35           N  
ATOM    585  CA  LEU A  74      36.320  26.800  -9.995  1.00 82.77           C  
ATOM    586  C   LEU A  74      37.032  25.461  -9.814  1.00 82.23           C  
ATOM    587  O   LEU A  74      38.262  25.424  -9.804  1.00 82.25           O  
ATOM    588  CB  LEU A  74      36.380  27.644  -8.715  1.00 82.52           C  
ATOM    589  CG  LEU A  74      35.798  29.061  -8.811  1.00 82.21           C  
ATOM    590  CD1 LEU A  74      35.792  29.701  -7.412  1.00 82.38           C  
ATOM    591  CD2 LEU A  74      36.613  29.927  -9.786  1.00 80.54           C  
ATOM    592  N   HIS A  75      36.294  24.360  -9.666  1.00 81.58           N  
ATOM    593  CA  HIS A  75      36.952  23.086  -9.325  1.00 81.49           C  
ATOM    594  C   HIS A  75      38.117  22.685 -10.248  1.00 81.52           C  
ATOM    595  O   HIS A  75      39.218  22.359  -9.785  1.00 81.72           O  
ATOM    596  CB  HIS A  75      35.970  21.936  -9.274  1.00 81.01           C  
ATOM    597  CG  HIS A  75      35.076  21.959  -8.093  1.00 81.68           C  
ATOM    598  ND1 HIS A  75      33.977  21.138  -7.988  1.00 85.05           N  
ATOM    599  CD2 HIS A  75      35.071  22.738  -6.988  1.00 83.95           C  
ATOM    600  CE1 HIS A  75      33.357  21.374  -6.846  1.00 86.50           C  
ATOM    601  NE2 HIS A  75      33.990  22.356  -6.229  1.00 86.23           N  
ATOM    602  N   PHE A  76      37.873  22.705 -11.552  1.00 81.67           N  
ATOM    603  CA  PHE A  76      38.885  22.286 -12.478  1.00 81.25           C  
ATOM    604  C   PHE A  76      40.153  23.091 -12.314  1.00 80.90           C  
ATOM    605  O   PHE A  76      41.214  22.526 -12.074  1.00 81.37           O  
ATOM    606  CB  PHE A  76      38.390  22.395 -13.900  1.00 81.38           C  
ATOM    607  CG  PHE A  76      39.449  22.083 -14.911  1.00 82.26           C  
ATOM    608  CD1 PHE A  76      40.028  20.816 -14.958  1.00 79.22           C  
ATOM    609  CD2 PHE A  76      39.883  23.061 -15.807  1.00 82.77           C  
ATOM    610  CE1 PHE A  76      41.000  20.530 -15.871  1.00 79.31           C  
ATOM    611  CE2 PHE A  76      40.873  22.764 -16.739  1.00 83.80           C  
ATOM    612  CZ  PHE A  76      41.430  21.489 -16.766  1.00 81.66           C  
ATOM    613  N   ALA A  77      40.074  24.408 -12.430  1.00 80.72           N  
ATOM    614  CA  ALA A  77      41.321  25.188 -12.442  1.00 80.29           C  
ATOM    615  C   ALA A  77      42.103  24.991 -11.164  1.00 80.24           C  
ATOM    616  O   ALA A  77      43.330  24.940 -11.176  1.00 81.23           O  
ATOM    617  CB  ALA A  77      41.048  26.619 -12.676  1.00 79.94           C  
ATOM    618  N   GLN A  78      41.380  24.822 -10.066  1.00 80.67           N  
ATOM    619  CA  GLN A  78      41.982  24.767  -8.722  1.00 80.38           C  
ATOM    620  C   GLN A  78      42.576  23.409  -8.470  1.00 80.31           C  
ATOM    621  O   GLN A  78      43.726  23.325  -7.969  1.00 80.33           O  
ATOM    622  CB  GLN A  78      40.989  25.164  -7.603  1.00 80.66           C  
ATOM    623  CG  GLN A  78      40.626  26.660  -7.524  1.00 78.37           C  
ATOM    624  CD  GLN A  78      39.563  26.936  -6.452  1.00 80.46           C  
ATOM    625  OE1 GLN A  78      38.813  26.023  -6.055  1.00 81.60           O  
ATOM    626  NE2 GLN A  78      39.495  28.192  -5.970  1.00 77.19           N  
ATOM    627  N   ALA A  79      41.835  22.351  -8.829  1.00 79.50           N  
ATOM    628  CA  ALA A  79      42.448  21.022  -8.819  1.00 79.37           C  
ATOM    629  C   ALA A  79      43.698  21.071  -9.648  1.00 79.84           C  
ATOM    630  O   ALA A  79      44.773  20.785  -9.144  1.00 80.55           O  
ATOM    631  CB  ALA A  79      41.538  19.997  -9.338  1.00 79.09           C  
ATOM    632  N   LYS A  80      43.596  21.486 -10.907  1.00 80.47           N  
ATOM    633  CA  LYS A  80      44.791  21.460 -11.766  1.00 81.11           C  
ATOM    634  C   LYS A  80      45.975  22.056 -11.049  1.00 80.97           C  
ATOM    635  O   LYS A  80      47.061  21.489 -11.094  1.00 81.43           O  
ATOM    636  CB  LYS A  80      44.611  22.184 -13.100  1.00 81.02           C  
ATOM    637  CG  LYS A  80      45.650  21.773 -14.142  1.00 81.36           C  
ATOM    638  CD  LYS A  80      45.605  22.656 -15.400  1.00 81.79           C  
ATOM    639  CE  LYS A  80      46.604  22.207 -16.475  1.00 81.78           C  
ATOM    640  NZ  LYS A  80      46.331  20.821 -16.982  1.00 83.13           N  
ATOM    641  N   ALA A  81      45.772  23.193 -10.382  1.00 80.95           N  
ATOM    642  CA  ALA A  81      46.909  23.871  -9.734  1.00 80.92           C  
ATOM    643  C   ALA A  81      47.384  23.023  -8.574  1.00 80.40           C  
ATOM    644  O   ALA A  81      48.578  22.743  -8.466  1.00 80.43           O  
ATOM    645  CB  ALA A  81      46.551  25.299  -9.279  1.00 80.61           C  
ATOM    646  N   ALA A  82      46.424  22.572  -7.762  1.00 79.99           N  
ATOM    647  CA  ALA A  82      46.687  21.737  -6.594  1.00 79.33           C  
ATOM    648  C   ALA A  82      47.547  20.549  -6.917  1.00 79.24           C  
ATOM    649  O   ALA A  82      48.531  20.336  -6.231  1.00 80.30           O  
ATOM    650  CB  ALA A  82      45.421  21.295  -5.976  1.00 79.49           C  
ATOM    651  N   LEU A  83      47.215  19.800  -7.969  1.00 78.72           N  
ATOM    652  CA  LEU A  83      48.011  18.616  -8.373  1.00 77.79           C  
ATOM    653  C   LEU A  83      49.354  19.006  -8.939  1.00 77.80           C  
ATOM    654  O   LEU A  83      50.338  18.316  -8.692  1.00 77.50           O  
ATOM    655  CB  LEU A  83      47.264  17.736  -9.390  1.00 77.09           C  
ATOM    656  CG  LEU A  83      45.873  17.250  -9.002  1.00 76.78           C  
ATOM    657  CD1 LEU A  83      45.141  16.729 -10.226  1.00 78.87           C  
ATOM    658  CD2 LEU A  83      45.892  16.186  -7.886  1.00 75.23           C  
ATOM    659  N   SER A  84      49.401  20.112  -9.692  1.00 78.22           N  
ATOM    660  CA  SER A  84      50.692  20.639 -10.205  1.00 79.20           C  
ATOM    661  C   SER A  84      51.593  21.081  -9.079  1.00 78.79           C  
ATOM    662  O   SER A  84      52.778  21.256  -9.271  1.00 79.21           O  
ATOM    663  CB  SER A  84      50.526  21.804 -11.200  1.00 79.18           C  
ATOM    664  OG  SER A  84      49.604  21.477 -12.237  1.00 81.49           O  
ATOM    665  N   ALA A  85      51.030  21.248  -7.895  1.00 78.83           N  
ATOM    666  CA  ALA A  85      51.812  21.714  -6.771  1.00 79.10           C  
ATOM    667  C   ALA A  85      52.123  20.567  -5.803  1.00 79.06           C  
ATOM    668  O   ALA A  85      52.742  20.783  -4.753  1.00 79.29           O  
ATOM    669  CB  ALA A  85      51.114  22.900  -6.073  1.00 78.79           C  
ATOM    670  N   GLY A  86      51.730  19.345  -6.184  1.00 78.91           N  
ATOM    671  CA  GLY A  86      52.126  18.139  -5.452  1.00 78.45           C  
ATOM    672  C   GLY A  86      51.210  17.777  -4.294  1.00 78.64           C  
ATOM    673  O   GLY A  86      51.555  16.972  -3.413  1.00 78.74           O  
ATOM    674  N   LYS A  87      50.032  18.375  -4.285  1.00 78.46           N  
ATOM    675  CA  LYS A  87      49.023  18.022  -3.305  1.00 78.59           C  
ATOM    676  C   LYS A  87      48.101  16.963  -3.903  1.00 78.52           C  
ATOM    677  O   LYS A  87      47.720  17.076  -5.064  1.00 78.15           O  
ATOM    678  CB  LYS A  87      48.207  19.273  -2.892  1.00 78.39           C  
ATOM    679  CG  LYS A  87      49.059  20.509  -2.414  1.00 79.01           C  
ATOM    680  CD  LYS A  87      50.175  20.116  -1.398  1.00 78.96           C  
ATOM    681  CE  LYS A  87      51.158  21.227  -1.137  1.00 76.88           C  
ATOM    682  NZ  LYS A  87      52.521  20.637  -1.147  1.00 77.80           N  
ATOM    683  N   HIS A  88      47.749  15.942  -3.120  1.00 78.29           N  
ATOM    684  CA  HIS A  88      46.569  15.157  -3.450  1.00 78.80           C  
ATOM    685  C   HIS A  88      45.371  16.068  -3.338  1.00 78.31           C  
ATOM    686  O   HIS A  88      45.371  17.021  -2.561  1.00 78.30           O  
ATOM    687  CB  HIS A  88      46.376  13.963  -2.515  1.00 79.32           C  
ATOM    688  CG  HIS A  88      47.593  13.109  -2.377  1.00 81.11           C  
ATOM    689  ND1 HIS A  88      48.191  12.486  -3.451  1.00 83.19           N  
ATOM    690  CD2 HIS A  88      48.339  12.786  -1.294  1.00 83.66           C  
ATOM    691  CE1 HIS A  88      49.254  11.821  -3.041  1.00 83.40           C  
ATOM    692  NE2 HIS A  88      49.364  11.981  -1.732  1.00 83.83           N  
ATOM    693  N   VAL A  89      44.337  15.752  -4.095  1.00 78.05           N  
ATOM    694  CA  VAL A  89      43.150  16.594  -4.169  1.00 77.66           C  
ATOM    695  C   VAL A  89      41.906  15.726  -3.910  1.00 77.11           C  
ATOM    696  O   VAL A  89      41.859  14.577  -4.289  1.00 78.32           O  
ATOM    697  CB  VAL A  89      43.100  17.293  -5.560  1.00 77.80           C  
ATOM    698  CG1 VAL A  89      41.758  17.920  -5.844  1.00 77.17           C  
ATOM    699  CG2 VAL A  89      44.207  18.321  -5.657  1.00 77.19           C  
ATOM    700  N   ILE A  90      40.924  16.268  -3.236  1.00 75.91           N  
ATOM    701  CA  ILE A  90      39.675  15.590  -3.029  1.00 75.37           C  
ATOM    702  C   ILE A  90      38.672  16.657  -3.394  1.00 76.06           C  
ATOM    703  O   ILE A  90      38.772  17.826  -2.868  1.00 77.07           O  
ATOM    704  CB  ILE A  90      39.411  15.301  -1.580  1.00 74.73           C  
ATOM    705  CG1 ILE A  90      40.377  14.272  -1.011  1.00 72.93           C  
ATOM    706  CG2 ILE A  90      37.979  14.896  -1.437  1.00 73.99           C  
ATOM    707  CD1 ILE A  90      40.160  14.038   0.490  1.00 70.56           C  
ATOM    708  N   LEU A  91      37.727  16.296  -4.268  1.00 74.56           N  
ATOM    709  CA  LEU A  91      36.882  17.271  -4.904  1.00 75.27           C  
ATOM    710  C   LEU A  91      35.463  17.018  -4.468  1.00 75.92           C  
ATOM    711  O   LEU A  91      34.960  15.940  -4.593  1.00 75.86           O  
ATOM    712  CB  LEU A  91      37.034  17.159  -6.414  1.00 75.00           C  
ATOM    713  CG  LEU A  91      38.036  18.013  -7.171  1.00 74.88           C  
ATOM    714  CD1 LEU A  91      37.740  17.945  -8.594  1.00 73.67           C  
ATOM    715  CD2 LEU A  91      37.759  19.432  -6.763  1.00 79.42           C  
ATOM    716  N   GLU A  92      34.810  17.994  -3.902  1.00 77.75           N  
ATOM    717  CA  GLU A  92      33.453  17.760  -3.461  1.00 80.14           C  
ATOM    718  C   GLU A  92      32.452  17.598  -4.604  1.00 81.46           C  
ATOM    719  O   GLU A  92      32.792  17.727  -5.751  1.00 81.34           O  
ATOM    720  CB  GLU A  92      33.017  18.899  -2.557  1.00 78.56           C  
ATOM    721  CG  GLU A  92      31.574  18.768  -2.059  1.00 82.13           C  
ATOM    722  CD  GLU A  92      31.290  17.440  -1.313  1.00 85.21           C  
ATOM    723  OE1 GLU A  92      30.299  16.738  -1.672  1.00 87.25           O  
ATOM    724  OE2 GLU A  92      32.070  17.096  -0.386  1.00 86.03           O  
ATOM    725  N   LYS A  93      31.206  17.299  -4.242  1.00 85.04           N  
ATOM    726  CA  LYS A  93      29.939  17.754  -4.966  1.00 87.09           C  
ATOM    727  C   LYS A  93      29.968  17.011  -6.218  1.00 86.33           C  
ATOM    728  O   LYS A  93      30.230  15.753  -6.119  1.00 86.75           O  
ATOM    729  CB  LYS A  93      29.826  19.276  -5.209  1.00 86.94           C  
ATOM    730  CG  LYS A  93      28.917  20.086  -4.146  1.00 92.44           C  
ATOM    731  CD  LYS A  93      29.126  21.701  -4.079  1.00 91.76           C  
ATOM    732  CE  LYS A  93      28.437  22.528  -5.264  1.00 97.80           C  
ATOM    733  NZ  LYS A  93      28.949  22.164  -6.701  1.00 98.73           N  
ATOM    734  N   PRO A  94      29.673  17.711  -7.379  1.00 85.00           N  
ATOM    735  CA  PRO A  94      30.157  17.278  -8.711  1.00 83.39           C  
ATOM    736  C   PRO A  94      31.577  17.728  -8.881  1.00 82.04           C  
ATOM    737  O   PRO A  94      31.840  18.928  -8.910  1.00 82.12           O  
ATOM    738  CB  PRO A  94      29.251  18.007  -9.690  1.00 82.83           C  
ATOM    739  CG  PRO A  94      28.663  19.077  -8.997  1.00 82.36           C  
ATOM    740  CD  PRO A  94      28.776  18.867  -7.510  1.00 85.24           C  
ATOM    741  N   ALA A  95      32.501  16.770  -8.923  1.00 80.59           N  
ATOM    742  CA  ALA A  95      33.937  17.096  -9.039  1.00 78.32           C  
ATOM    743  C   ALA A  95      34.145  18.117 -10.166  1.00 77.05           C  
ATOM    744  O   ALA A  95      34.814  19.089  -9.981  1.00 76.99           O  
ATOM    745  CB  ALA A  95      34.768  15.858  -9.249  1.00 76.55           C  
ATOM    746  N   VAL A  96      33.521  17.919 -11.319  1.00 76.18           N  
ATOM    747  CA  VAL A  96      33.772  18.777 -12.463  1.00 74.26           C  
ATOM    748  C   VAL A  96      32.525  19.155 -13.211  1.00 74.71           C  
ATOM    749  O   VAL A  96      31.443  18.575 -13.056  1.00 75.12           O  
ATOM    750  CB  VAL A  96      34.693  18.113 -13.480  1.00 73.70           C  
ATOM    751  CG1 VAL A  96      36.112  18.021 -12.944  1.00 72.06           C  
ATOM    752  CG2 VAL A  96      34.128  16.740 -13.898  1.00 72.63           C  
ATOM    753  N   SER A  97      32.725  20.122 -14.087  1.00 75.22           N  
ATOM    754  CA  SER A  97      31.694  20.719 -14.915  1.00 74.98           C  
ATOM    755  C   SER A  97      31.433  19.891 -16.173  1.00 74.26           C  
ATOM    756  O   SER A  97      30.347  19.926 -16.733  1.00 75.22           O  
ATOM    757  CB  SER A  97      32.169  22.129 -15.256  1.00 75.05           C  
ATOM    758  OG  SER A  97      31.352  22.735 -16.220  1.00 77.83           O  
ATOM    759  N   GLN A  98      32.420  19.136 -16.635  1.00 74.05           N  
ATOM    760  CA  GLN A  98      32.209  18.253 -17.786  1.00 73.20           C  
ATOM    761  C   GLN A  98      33.235  17.143 -17.858  1.00 73.16           C  
ATOM    762  O   GLN A  98      34.274  17.217 -17.190  1.00 72.89           O  
ATOM    763  CB  GLN A  98      32.110  19.031 -19.103  1.00 73.00           C  
ATOM    764  CG  GLN A  98      33.092  20.151 -19.319  1.00 73.29           C  
ATOM    765  CD  GLN A  98      33.144  20.583 -20.765  1.00 73.77           C  
ATOM    766  OE1 GLN A  98      32.107  20.869 -21.398  1.00 75.18           O  
ATOM    767  NE2 GLN A  98      34.355  20.617 -21.315  1.00 72.30           N  
ATOM    768  N   PRO A  99      32.948  16.090 -18.666  1.00 73.03           N  
ATOM    769  CA  PRO A  99      33.713  14.845 -18.607  1.00 72.46           C  
ATOM    770  C   PRO A  99      35.204  15.043 -18.861  1.00 72.53           C  
ATOM    771  O   PRO A  99      36.025  14.572 -18.059  1.00 72.04           O  
ATOM    772  CB  PRO A  99      33.118  14.006 -19.740  1.00 72.45           C  
ATOM    773  CG  PRO A  99      31.799  14.573 -19.994  1.00 72.71           C  
ATOM    774  CD  PRO A  99      31.909  16.033 -19.709  1.00 72.85           C  
ATOM    775  N   GLN A 100      35.564  15.720 -19.958  1.00 72.42           N  
ATOM    776  CA  GLN A 100      36.987  15.879 -20.254  1.00 72.79           C  
ATOM    777  C   GLN A 100      37.769  16.390 -19.078  1.00 73.02           C  
ATOM    778  O   GLN A 100      38.883  15.908 -18.862  1.00 73.80           O  
ATOM    779  CB  GLN A 100      37.271  16.789 -21.432  1.00 73.31           C  
ATOM    780  CG  GLN A 100      38.713  16.641 -21.919  1.00 74.53           C  
ATOM    781  CD  GLN A 100      39.029  15.206 -22.442  1.00 76.94           C  
ATOM    782  OE1 GLN A 100      38.449  14.728 -23.436  1.00 74.46           O  
ATOM    783  NE2 GLN A 100      39.957  14.537 -21.765  1.00 77.62           N  
ATOM    784  N   GLU A 101      37.197  17.362 -18.337  1.00 72.40           N  
ATOM    785  CA  GLU A 101      37.840  17.974 -17.191  1.00 71.51           C  
ATOM    786  C   GLU A 101      38.342  16.957 -16.200  1.00 71.25           C  
ATOM    787  O   GLU A 101      39.478  17.076 -15.726  1.00 71.68           O  
ATOM    788  CB  GLU A 101      36.912  18.929 -16.489  1.00 71.69           C  
ATOM    789  CG  GLU A 101      36.856  20.335 -17.074  1.00 71.85           C  
ATOM    790  CD  GLU A 101      35.731  21.175 -16.446  1.00 73.11           C  
ATOM    791  OE1 GLU A 101      35.433  21.022 -15.234  1.00 71.69           O  
ATOM    792  OE2 GLU A 101      35.124  21.992 -17.180  1.00 77.71           O  
ATOM    793  N   TRP A 102      37.520  15.946 -15.901  1.00 71.25           N  
ATOM    794  CA  TRP A 102      37.929  14.792 -15.059  1.00 70.63           C  
ATOM    795  C   TRP A 102      39.157  14.122 -15.609  1.00 71.01           C  
ATOM    796  O   TRP A 102      40.081  13.755 -14.854  1.00 70.24           O  
ATOM    797  CB  TRP A 102      36.822  13.741 -14.935  1.00 70.14           C  
ATOM    798  CG  TRP A 102      37.078  12.638 -13.921  1.00 69.38           C  
ATOM    799  CD1 TRP A 102      37.122  11.294 -14.164  1.00 66.47           C  
ATOM    800  CD2 TRP A 102      37.294  12.796 -12.489  1.00 69.49           C  
ATOM    801  NE1 TRP A 102      37.367  10.599 -12.990  1.00 65.49           N  
ATOM    802  CE2 TRP A 102      37.496  11.490 -11.952  1.00 68.19           C  
ATOM    803  CE3 TRP A 102      37.385  13.906 -11.627  1.00 67.32           C  
ATOM    804  CZ2 TRP A 102      37.764  11.270 -10.585  1.00 67.81           C  
ATOM    805  CZ3 TRP A 102      37.632  13.685 -10.259  1.00 67.33           C  
ATOM    806  CH2 TRP A 102      37.825  12.375  -9.763  1.00 69.23           C  
ATOM    807  N   PHE A 103      39.193  13.984 -16.924  1.00 71.57           N  
ATOM    808  CA  PHE A 103      40.323  13.275 -17.534  1.00 72.86           C  
ATOM    809  C   PHE A 103      41.620  14.080 -17.637  1.00 73.06           C  
ATOM    810  O   PHE A 103      42.708  13.494 -17.555  1.00 72.90           O  
ATOM    811  CB  PHE A 103      39.909  12.627 -18.842  1.00 73.08           C  
ATOM    812  CG  PHE A 103      38.863  11.557 -18.666  1.00 74.84           C  
ATOM    813  CD1 PHE A 103      39.215  10.290 -18.167  1.00 78.16           C  
ATOM    814  CD2 PHE A 103      37.537  11.800 -18.989  1.00 74.61           C  
ATOM    815  CE1 PHE A 103      38.253   9.278 -17.991  1.00 77.33           C  
ATOM    816  CE2 PHE A 103      36.567  10.795 -18.840  1.00 76.87           C  
ATOM    817  CZ  PHE A 103      36.919   9.530 -18.336  1.00 76.23           C  
ATOM    818  N   ASP A 104      41.519  15.404 -17.777  1.00 73.52           N  
ATOM    819  CA  ASP A 104      42.708  16.249 -17.692  1.00 74.55           C  
ATOM    820  C   ASP A 104      43.255  16.163 -16.300  1.00 74.72           C  
ATOM    821  O   ASP A 104      44.450  15.992 -16.098  1.00 75.98           O  
ATOM    822  CB  ASP A 104      42.397  17.700 -17.967  1.00 74.96           C  
ATOM    823  CG  ASP A 104      42.130  17.973 -19.422  1.00 77.72           C  
ATOM    824  OD1 ASP A 104      42.489  17.130 -20.305  1.00 77.75           O  
ATOM    825  OD2 ASP A 104      41.561  19.071 -19.668  1.00 80.96           O  
ATOM    826  N   LEU A 105      42.363  16.269 -15.334  1.00 74.58           N  
ATOM    827  CA  LEU A 105      42.720  16.108 -13.949  1.00 74.28           C  
ATOM    828  C   LEU A 105      43.450  14.812 -13.715  1.00 74.17           C  
ATOM    829  O   LEU A 105      44.520  14.819 -13.139  1.00 74.84           O  
ATOM    830  CB  LEU A 105      41.480  16.261 -13.056  1.00 74.55           C  
ATOM    831  CG  LEU A 105      41.053  17.739 -12.987  1.00 73.89           C  
ATOM    832  CD1 LEU A 105      39.807  17.921 -12.168  1.00 75.66           C  
ATOM    833  CD2 LEU A 105      42.185  18.636 -12.424  1.00 74.14           C  
ATOM    834  N   ILE A 106      42.925  13.709 -14.221  1.00 74.53           N  
ATOM    835  CA  ILE A 106      43.605  12.430 -14.044  1.00 74.96           C  
ATOM    836  C   ILE A 106      45.045  12.457 -14.619  1.00 75.65           C  
ATOM    837  O   ILE A 106      46.003  12.158 -13.892  1.00 76.19           O  
ATOM    838  CB  ILE A 106      42.755  11.231 -14.527  1.00 74.49           C  
ATOM    839  CG1 ILE A 106      41.655  10.949 -13.505  1.00 74.76           C  
ATOM    840  CG2 ILE A 106      43.591   9.974 -14.654  1.00 74.49           C  
ATOM    841  CD1 ILE A 106      40.488  10.045 -14.063  1.00 74.92           C  
ATOM    842  N   GLN A 107      45.202  12.858 -15.883  1.00 75.82           N  
ATOM    843  CA  GLN A 107      46.531  13.038 -16.456  1.00 75.76           C  
ATOM    844  C   GLN A 107      47.368  13.887 -15.516  1.00 75.95           C  
ATOM    845  O   GLN A 107      48.426  13.459 -15.064  1.00 75.83           O  
ATOM    846  CB  GLN A 107      46.455  13.706 -17.817  1.00 75.71           C  
ATOM    847  CG  GLN A 107      45.991  12.778 -18.921  1.00 76.66           C  
ATOM    848  CD  GLN A 107      46.906  11.566 -19.117  1.00 77.76           C  
ATOM    849  OE1 GLN A 107      46.440  10.425 -19.000  1.00 75.88           O  
ATOM    850  NE2 GLN A 107      48.218  11.803 -19.422  1.00 75.21           N  
ATOM    851  N   THR A 108      46.869  15.077 -15.187  1.00 76.26           N  
ATOM    852  CA  THR A 108      47.599  15.999 -14.303  1.00 76.65           C  
ATOM    853  C   THR A 108      48.014  15.284 -13.005  1.00 76.67           C  
ATOM    854  O   THR A 108      49.125  15.465 -12.502  1.00 75.70           O  
ATOM    855  CB  THR A 108      46.767  17.283 -14.014  1.00 76.73           C  
ATOM    856  OG1 THR A 108      46.237  17.798 -15.244  1.00 76.99           O  
ATOM    857  CG2 THR A 108      47.612  18.375 -13.351  1.00 76.64           C  
ATOM    858  N   ALA A 109      47.113  14.448 -12.491  1.00 77.30           N  
ATOM    859  CA  ALA A 109      47.345  13.742 -11.238  1.00 77.43           C  
ATOM    860  C   ALA A 109      48.446  12.747 -11.449  1.00 78.06           C  
ATOM    861  O   ALA A 109      49.421  12.741 -10.686  1.00 78.26           O  
ATOM    862  CB  ALA A 109      46.087  13.036 -10.790  1.00 77.18           C  
ATOM    863  N   GLU A 110      48.279  11.907 -12.478  1.00 78.15           N  
ATOM    864  CA  GLU A 110      49.283  10.935 -12.850  1.00 79.09           C  
ATOM    865  C   GLU A 110      50.688  11.538 -13.027  1.00 79.48           C  
ATOM    866  O   GLU A 110      51.621  11.118 -12.354  1.00 79.69           O  
ATOM    867  CB  GLU A 110      48.863  10.165 -14.092  1.00 78.98           C  
ATOM    868  CG  GLU A 110      48.451   8.769 -13.726  1.00 80.58           C  
ATOM    869  CD  GLU A 110      47.542   8.124 -14.743  1.00 82.91           C  
ATOM    870  OE1 GLU A 110      48.054   7.609 -15.784  1.00 84.57           O  
ATOM    871  OE2 GLU A 110      46.315   8.100 -14.472  1.00 81.87           O  
ATOM    872  N   LYS A 111      50.816  12.529 -13.905  1.00 79.65           N  
ATOM    873  CA  LYS A 111      52.085  13.185 -14.190  1.00 80.03           C  
ATOM    874  C   LYS A 111      52.803  13.669 -12.922  1.00 79.89           C  
ATOM    875  O   LYS A 111      54.033  13.582 -12.812  1.00 78.36           O  
ATOM    876  CB  LYS A 111      51.820  14.371 -15.119  1.00 80.73           C  
ATOM    877  CG  LYS A 111      53.058  15.135 -15.593  1.00 82.18           C  
ATOM    878  CD  LYS A 111      52.680  16.569 -15.943  1.00 83.52           C  
ATOM    879  CE  LYS A 111      53.912  17.450 -16.166  1.00 83.06           C  
ATOM    880  NZ  LYS A 111      53.513  18.866 -15.871  1.00 82.16           N  
ATOM    881  N   ASN A 112      52.012  14.183 -11.980  1.00 80.27           N  
ATOM    882  CA  ASN A 112      52.531  14.772 -10.749  1.00 80.60           C  
ATOM    883  C   ASN A 112      52.539  13.793  -9.580  1.00 80.93           C  
ATOM    884  O   ASN A 112      52.829  14.177  -8.459  1.00 81.13           O  
ATOM    885  CB  ASN A 112      51.764  16.047 -10.402  1.00 80.15           C  
ATOM    886  CG  ASN A 112      52.208  17.242 -11.244  1.00 80.46           C  
ATOM    887  OD1 ASN A 112      53.289  17.793 -11.030  1.00 79.66           O  
ATOM    888  ND2 ASN A 112      51.372  17.648 -12.200  1.00 79.48           N  
ATOM    889  N   ASN A 113      52.232  12.527  -9.855  1.00 81.15           N  
ATOM    890  CA  ASN A 113      52.250  11.464  -8.838  1.00 81.45           C  
ATOM    891  C   ASN A 113      51.418  11.741  -7.573  1.00 81.50           C  
ATOM    892  O   ASN A 113      51.923  11.564  -6.468  1.00 81.70           O  
ATOM    893  CB  ASN A 113      53.696  11.086  -8.459  1.00 81.40           C  
ATOM    894  CG  ASN A 113      54.328  10.141  -9.453  1.00 82.75           C  
ATOM    895  OD1 ASN A 113      55.023  10.565 -10.379  1.00 83.27           O  
ATOM    896  ND2 ASN A 113      54.071   8.841  -9.282  1.00 84.50           N  
ATOM    897  N   CYS A 114      50.155  12.155  -7.738  1.00 81.04           N  
ATOM    898  CA  CYS A 114      49.239  12.360  -6.613  1.00 81.30           C  
ATOM    899  C   CYS A 114      47.898  11.720  -6.883  1.00 80.82           C  
ATOM    900  O   CYS A 114      47.580  11.432  -8.021  1.00 80.60           O  
ATOM    901  CB  CYS A 114      48.945  13.854  -6.410  1.00 81.78           C  
ATOM    902  SG  CYS A 114      50.360  14.878  -6.355  1.00 85.29           S  
ATOM    903  N   PHE A 115      47.087  11.577  -5.837  1.00 80.71           N  
ATOM    904  CA  PHE A 115      45.678  11.161  -5.968  1.00 80.82           C  
ATOM    905  C   PHE A 115      44.684  12.297  -6.211  1.00 80.08           C  
ATOM    906  O   PHE A 115      44.878  13.439  -5.812  1.00 80.34           O  
ATOM    907  CB  PHE A 115      45.200  10.339  -4.745  1.00 81.21           C  
ATOM    908  CG  PHE A 115      46.056   9.120  -4.435  1.00 80.07           C  
ATOM    909  CD1 PHE A 115      45.808   7.903  -5.058  1.00 79.28           C  
ATOM    910  CD2 PHE A 115      47.080   9.198  -3.499  1.00 80.06           C  
ATOM    911  CE1 PHE A 115      46.606   6.766  -4.779  1.00 81.90           C  
ATOM    912  CE2 PHE A 115      47.889   8.065  -3.210  1.00 82.72           C  
ATOM    913  CZ  PHE A 115      47.642   6.845  -3.855  1.00 80.57           C  
ATOM    914  N   ILE A 116      43.592  11.932  -6.860  1.00 79.29           N  
ATOM    915  CA  ILE A 116      42.471  12.820  -7.142  1.00 77.37           C  
ATOM    916  C   ILE A 116      41.244  11.941  -6.829  1.00 77.70           C  
ATOM    917  O   ILE A 116      41.071  10.875  -7.421  1.00 77.61           O  
ATOM    918  CB  ILE A 116      42.515  13.324  -8.624  1.00 76.72           C  
ATOM    919  CG1 ILE A 116      41.328  14.213  -8.949  1.00 75.89           C  
ATOM    920  CG2 ILE A 116      42.518  12.175  -9.637  1.00 75.58           C  
ATOM    921  CD1 ILE A 116      41.060  15.226  -7.912  1.00 71.99           C  
ATOM    922  N   PHE A 117      40.454  12.336  -5.837  1.00 77.92           N  
ATOM    923  CA  PHE A 117      39.295  11.558  -5.430  1.00 78.09           C  
ATOM    924  C   PHE A 117      38.059  12.412  -5.608  1.00 78.11           C  
ATOM    925  O   PHE A 117      38.145  13.589  -5.377  1.00 78.76           O  
ATOM    926  CB  PHE A 117      39.381  11.217  -3.944  1.00 78.16           C  
ATOM    927  CG  PHE A 117      40.605  10.449  -3.540  1.00 77.72           C  
ATOM    928  CD1 PHE A 117      40.993   9.300  -4.215  1.00 77.38           C  
ATOM    929  CD2 PHE A 117      41.349  10.859  -2.427  1.00 79.22           C  
ATOM    930  CE1 PHE A 117      42.122   8.580  -3.805  1.00 77.45           C  
ATOM    931  CE2 PHE A 117      42.493  10.144  -2.004  1.00 78.78           C  
ATOM    932  CZ  PHE A 117      42.866   9.012  -2.693  1.00 78.62           C  
ATOM    933  N   GLU A 118      36.918  11.851  -6.011  1.00 77.73           N  
ATOM    934  CA  GLU A 118      35.679  12.610  -5.923  1.00 76.67           C  
ATOM    935  C   GLU A 118      35.014  12.289  -4.587  1.00 78.00           C  
ATOM    936  O   GLU A 118      34.834  11.137  -4.243  1.00 77.03           O  
ATOM    937  CB  GLU A 118      34.720  12.333  -7.078  1.00 75.66           C  
ATOM    938  CG  GLU A 118      33.493  13.311  -6.997  1.00 74.85           C  
ATOM    939  CD  GLU A 118      32.566  13.327  -8.261  1.00 75.31           C  
ATOM    940  OE1 GLU A 118      32.594  12.375  -9.103  1.00 71.15           O  
ATOM    941  OE2 GLU A 118      31.803  14.316  -8.400  1.00 72.07           O  
ATOM    942  N   ALA A 119      34.614  13.306  -3.837  1.00 79.14           N  
ATOM    943  CA  ALA A 119      34.057  13.061  -2.520  1.00 80.90           C  
ATOM    944  C   ALA A 119      32.606  12.628  -2.643  1.00 82.03           C  
ATOM    945  O   ALA A 119      31.691  13.260  -2.122  1.00 83.20           O  
ATOM    946  CB  ALA A 119      34.218  14.288  -1.597  1.00 80.97           C  
ATOM    947  N   ALA A 120      32.430  11.510  -3.325  1.00 83.64           N  
ATOM    948  CA  ALA A 120      31.153  10.819  -3.499  1.00 84.23           C  
ATOM    949  C   ALA A 120      30.867   9.999  -2.232  1.00 84.27           C  
ATOM    950  O   ALA A 120      31.242   8.838  -2.164  1.00 84.00           O  
ATOM    951  CB  ALA A 120      31.303   9.854  -4.689  1.00 83.64           C  
ATOM    952  N   ARG A 121      30.196  10.576  -1.238  1.00 84.13           N  
ATOM    953  CA  ARG A 121      30.038   9.876   0.050  1.00 82.77           C  
ATOM    954  C   ARG A 121      29.304   8.524  -0.026  1.00 82.64           C  
ATOM    955  O   ARG A 121      29.617   7.618   0.718  1.00 81.84           O  
ATOM    956  CB  ARG A 121      29.393  10.792   1.100  1.00 82.81           C  
ATOM    957  CG  ARG A 121      28.063  11.457   0.680  1.00 82.76           C  
ATOM    958  CD  ARG A 121      27.517  12.433   1.786  1.00 81.05           C  
ATOM    959  NE  ARG A 121      26.234  13.032   1.421  1.00 79.69           N  
ATOM    960  CZ  ARG A 121      25.026  12.537   1.722  1.00 80.64           C  
ATOM    961  NH1 ARG A 121      24.908  11.410   2.406  1.00 81.49           N  
ATOM    962  NH2 ARG A 121      23.909  13.171   1.334  1.00 79.78           N  
ATOM    963  N   ASN A 122      28.310   8.405  -0.902  1.00 82.97           N  
ATOM    964  CA  ASN A 122      27.413   7.279  -0.835  1.00 83.05           C  
ATOM    965  C   ASN A 122      28.085   6.068  -1.477  1.00 83.68           C  
ATOM    966  O   ASN A 122      27.990   4.916  -0.985  1.00 83.69           O  
ATOM    967  CB  ASN A 122      25.976   7.631  -1.320  1.00 82.67           C  
ATOM    968  CG  ASN A 122      25.857   7.862  -2.844  1.00 83.77           C  
ATOM    969  OD1 ASN A 122      26.806   8.240  -3.530  1.00 81.82           O  
ATOM    970  ND2 ASN A 122      24.656   7.633  -3.369  1.00 84.67           N  
ATOM    971  N   TYR A 123      28.873   6.379  -2.503  1.00 83.84           N  
ATOM    972  CA  TYR A 123      29.766   5.422  -3.173  1.00 84.28           C  
ATOM    973  C   TYR A 123      30.708   4.648  -2.258  1.00 84.68           C  
ATOM    974  O   TYR A 123      30.970   3.475  -2.506  1.00 86.96           O  
ATOM    975  CB  TYR A 123      30.544   6.163  -4.242  1.00 84.06           C  
ATOM    976  CG  TYR A 123      31.455   5.364  -5.095  1.00 81.88           C  
ATOM    977  CD1 TYR A 123      30.995   4.739  -6.250  1.00 81.68           C  
ATOM    978  CD2 TYR A 123      32.804   5.313  -4.807  1.00 82.42           C  
ATOM    979  CE1 TYR A 123      31.867   4.033  -7.092  1.00 82.74           C  
ATOM    980  CE2 TYR A 123      33.686   4.608  -5.616  1.00 83.40           C  
ATOM    981  CZ  TYR A 123      33.212   3.963  -6.762  1.00 84.84           C  
ATOM    982  OH  TYR A 123      34.114   3.261  -7.547  1.00 86.41           O  
ATOM    983  N   HIS A 124      31.202   5.252  -1.197  1.00 84.49           N  
ATOM    984  CA  HIS A 124      32.095   4.517  -0.285  1.00 84.70           C  
ATOM    985  C   HIS A 124      31.360   3.878   0.884  1.00 84.74           C  
ATOM    986  O   HIS A 124      31.982   3.307   1.756  1.00 86.34           O  
ATOM    987  CB  HIS A 124      33.253   5.414   0.205  1.00 84.19           C  
ATOM    988  CG  HIS A 124      34.073   5.975  -0.916  1.00 84.51           C  
ATOM    989  ND1 HIS A 124      35.185   5.331  -1.427  1.00 80.86           N  
ATOM    990  CD2 HIS A 124      33.889   7.077  -1.687  1.00 83.22           C  
ATOM    991  CE1 HIS A 124      35.685   6.037  -2.422  1.00 81.41           C  
ATOM    992  NE2 HIS A 124      34.900   7.089  -2.620  1.00 85.51           N  
ATOM    993  N   GLU A 125      30.044   3.940   0.914  1.00 84.58           N  
ATOM    994  CA  GLU A 125      29.312   3.240   1.973  1.00 85.24           C  
ATOM    995  C   GLU A 125      29.494   1.689   1.980  1.00 84.89           C  
ATOM    996  O   GLU A 125      29.516   1.015   0.931  1.00 83.81           O  
ATOM    997  CB  GLU A 125      27.828   3.645   1.964  1.00 85.17           C  
ATOM    998  CG  GLU A 125      27.579   5.108   2.373  1.00 84.89           C  
ATOM    999  CD  GLU A 125      26.137   5.526   2.158  1.00 87.91           C  
ATOM   1000  OE1 GLU A 125      25.223   4.682   2.363  1.00 87.82           O  
ATOM   1001  OE2 GLU A 125      25.896   6.719   1.798  1.00 93.77           O  
ATOM   1002  N   LYS A 126      29.657   1.153   3.185  1.00 85.50           N  
ATOM   1003  CA  LYS A 126      29.824  -0.289   3.400  1.00 86.01           C  
ATOM   1004  C   LYS A 126      28.608  -0.963   2.771  1.00 86.32           C  
ATOM   1005  O   LYS A 126      28.758  -1.955   2.054  1.00 87.62           O  
ATOM   1006  CB  LYS A 126      29.934  -0.599   4.894  1.00 85.44           C  
ATOM   1007  CG  LYS A 126      31.084  -1.535   5.273  1.00 88.20           C  
ATOM   1008  CD  LYS A 126      30.765  -3.094   5.033  1.00 88.86           C  
ATOM   1009  CE  LYS A 126      31.582  -4.010   5.927  1.00 87.29           C  
ATOM   1010  NZ  LYS A 126      33.048  -3.730   5.861  1.00 85.80           N  
ATOM   1011  N   ALA A 127      27.432  -0.360   2.979  1.00 86.15           N  
ATOM   1012  CA  ALA A 127      26.136  -0.797   2.448  1.00 85.93           C  
ATOM   1013  C   ALA A 127      26.117  -1.207   0.990  1.00 86.38           C  
ATOM   1014  O   ALA A 127      25.537  -2.241   0.657  1.00 87.08           O  
ATOM   1015  CB  ALA A 127      25.105   0.266   2.674  1.00 86.63           C  
ATOM   1016  N   PHE A 128      26.746  -0.423   0.117  1.00 86.09           N  
ATOM   1017  CA  PHE A 128      26.828  -0.811  -1.299  1.00 86.00           C  
ATOM   1018  C   PHE A 128      27.474  -2.166  -1.514  1.00 86.22           C  
ATOM   1019  O   PHE A 128      26.844  -3.062  -2.057  1.00 86.77           O  
ATOM   1020  CB  PHE A 128      27.449   0.280  -2.184  1.00 85.73           C  
ATOM   1021  CG  PHE A 128      26.482   1.325  -2.526  1.00 84.65           C  
ATOM   1022  CD1 PHE A 128      25.529   1.098  -3.471  1.00 86.00           C  
ATOM   1023  CD2 PHE A 128      26.414   2.476  -1.805  1.00 85.86           C  
ATOM   1024  CE1 PHE A 128      24.572   2.046  -3.738  1.00 85.08           C  
ATOM   1025  CE2 PHE A 128      25.467   3.407  -2.075  1.00 83.92           C  
ATOM   1026  CZ  PHE A 128      24.550   3.177  -3.047  1.00 84.03           C  
ATOM   1027  N   THR A 129      28.703  -2.341  -1.066  1.00 86.19           N  
ATOM   1028  CA  THR A 129      29.293  -3.649  -1.182  1.00 86.32           C  
ATOM   1029  C   THR A 129      28.294  -4.716  -0.718  1.00 86.93           C  
ATOM   1030  O   THR A 129      28.186  -5.795  -1.334  1.00 87.70           O  
ATOM   1031  CB  THR A 129      30.572  -3.780  -0.353  1.00 86.52           C  
ATOM   1032  OG1 THR A 129      31.386  -2.613  -0.537  1.00 83.37           O  
ATOM   1033  CG2 THR A 129      31.339  -5.037  -0.776  1.00 85.81           C  
ATOM   1034  N   THR A 130      27.556  -4.427   0.355  1.00 86.55           N  
ATOM   1035  CA  THR A 130      26.679  -5.465   0.918  1.00 85.70           C  
ATOM   1036  C   THR A 130      25.567  -5.760  -0.085  1.00 85.70           C  
ATOM   1037  O   THR A 130      25.291  -6.912  -0.392  1.00 86.14           O  
ATOM   1038  CB  THR A 130      26.079  -5.035   2.254  1.00 85.55           C  
ATOM   1039  OG1 THR A 130      27.115  -4.533   3.100  1.00 84.24           O  
ATOM   1040  CG2 THR A 130      25.373  -6.185   2.907  1.00 82.86           C  
ATOM   1041  N   ILE A 131      24.971  -4.696  -0.613  1.00 84.83           N  
ATOM   1042  CA  ILE A 131      23.933  -4.785  -1.615  1.00 84.44           C  
ATOM   1043  C   ILE A 131      24.508  -5.385  -2.874  1.00 84.71           C  
ATOM   1044  O   ILE A 131      23.879  -6.256  -3.511  1.00 85.43           O  
ATOM   1045  CB  ILE A 131      23.333  -3.376  -1.909  1.00 84.60           C  
ATOM   1046  CG1 ILE A 131      22.580  -2.869  -0.693  1.00 83.05           C  
ATOM   1047  CG2 ILE A 131      22.419  -3.338  -3.157  1.00 83.23           C  
ATOM   1048  CD1 ILE A 131      22.729  -1.401  -0.552  1.00 83.14           C  
ATOM   1049  N   LYS A 132      25.700  -4.939  -3.250  1.00 84.35           N  
ATOM   1050  CA  LYS A 132      26.279  -5.424  -4.497  1.00 83.89           C  
ATOM   1051  C   LYS A 132      26.434  -6.929  -4.449  1.00 82.65           C  
ATOM   1052  O   LYS A 132      26.208  -7.590  -5.442  1.00 82.00           O  
ATOM   1053  CB  LYS A 132      27.597  -4.717  -4.874  1.00 83.96           C  
ATOM   1054  CG  LYS A 132      28.141  -5.207  -6.215  1.00 84.86           C  
ATOM   1055  CD  LYS A 132      28.734  -4.145  -7.097  1.00 87.69           C  
ATOM   1056  CE  LYS A 132      28.950  -4.744  -8.489  1.00 90.77           C  
ATOM   1057  NZ  LYS A 132      30.076  -4.128  -9.262  1.00 93.87           N  
ATOM   1058  N   ASN A 133      26.800  -7.444  -3.281  1.00 82.77           N  
ATOM   1059  CA  ASN A 133      27.009  -8.890  -3.089  1.00 83.30           C  
ATOM   1060  C   ASN A 133      25.733  -9.627  -3.267  1.00 83.03           C  
ATOM   1061  O   ASN A 133      25.700 -10.700  -3.886  1.00 82.71           O  
ATOM   1062  CB  ASN A 133      27.466  -9.227  -1.673  1.00 83.25           C  
ATOM   1063  CG  ASN A 133      28.916  -9.141  -1.524  1.00 83.65           C  
ATOM   1064  OD1 ASN A 133      29.594  -8.678  -2.434  1.00 84.49           O  
ATOM   1065  ND2 ASN A 133      29.429  -9.566  -0.369  1.00 82.91           N  
ATOM   1066  N   PHE A 134      24.707  -9.046  -2.661  1.00 82.23           N  
ATOM   1067  CA  PHE A 134      23.437  -9.666  -2.563  1.00 83.05           C  
ATOM   1068  C   PHE A 134      22.839  -9.847  -3.959  1.00 83.68           C  
ATOM   1069  O   PHE A 134      22.107 -10.822  -4.208  1.00 84.17           O  
ATOM   1070  CB  PHE A 134      22.533  -8.850  -1.638  1.00 83.32           C  
ATOM   1071  CG  PHE A 134      21.168  -9.429  -1.477  1.00 83.16           C  
ATOM   1072  CD1 PHE A 134      20.938 -10.440  -0.550  1.00 80.84           C  
ATOM   1073  CD2 PHE A 134      20.111  -8.982  -2.275  1.00 83.45           C  
ATOM   1074  CE1 PHE A 134      19.693 -11.004  -0.409  1.00 80.61           C  
ATOM   1075  CE2 PHE A 134      18.843  -9.547  -2.145  1.00 84.27           C  
ATOM   1076  CZ  PHE A 134      18.639 -10.576  -1.207  1.00 83.00           C  
ATOM   1077  N   LEU A 135      23.209  -8.953  -4.874  1.00 84.27           N  
ATOM   1078  CA  LEU A 135      22.684  -8.966  -6.254  1.00 85.01           C  
ATOM   1079  C   LEU A 135      23.597  -9.713  -7.265  1.00 85.78           C  
ATOM   1080  O   LEU A 135      23.222  -9.890  -8.446  1.00 86.17           O  
ATOM   1081  CB  LEU A 135      22.392  -7.543  -6.757  1.00 84.41           C  
ATOM   1082  CG  LEU A 135      21.518  -6.682  -5.862  1.00 83.61           C  
ATOM   1083  CD1 LEU A 135      21.778  -5.220  -6.094  1.00 81.46           C  
ATOM   1084  CD2 LEU A 135      20.093  -7.026  -6.130  1.00 81.79           C  
ATOM   1085  N   ALA A 136      24.784 -10.126  -6.821  1.00 85.48           N  
ATOM   1086  CA  ALA A 136      25.609 -10.993  -7.646  1.00 85.70           C  
ATOM   1087  C   ALA A 136      24.825 -12.239  -8.128  1.00 85.42           C  
ATOM   1088  O   ALA A 136      24.869 -12.611  -9.308  1.00 85.39           O  
ATOM   1089  CB  ALA A 136      26.866 -11.395  -6.903  1.00 86.16           C  
ATOM   1090  N   ASP A 137      24.073 -12.874  -7.243  1.00 85.10           N  
ATOM   1091  CA  ASP A 137      23.341 -14.070  -7.690  1.00 84.52           C  
ATOM   1092  C   ASP A 137      21.878 -13.861  -8.055  1.00 84.09           C  
ATOM   1093  O   ASP A 137      21.175 -14.841  -8.257  1.00 84.15           O  
ATOM   1094  CB  ASP A 137      23.507 -15.260  -6.735  1.00 84.69           C  
ATOM   1095  CG  ASP A 137      23.434 -14.873  -5.282  1.00 85.38           C  
ATOM   1096  OD1 ASP A 137      23.914 -15.677  -4.446  1.00 86.37           O  
ATOM   1097  OD2 ASP A 137      22.942 -13.762  -4.965  1.00 88.61           O  
ATOM   1098  N   LYS A 138      21.423 -12.602  -8.125  1.00 83.31           N  
ATOM   1099  CA  LYS A 138      20.105 -12.303  -8.667  1.00 82.21           C  
ATOM   1100  C   LYS A 138      20.225 -11.946 -10.146  1.00 81.46           C  
ATOM   1101  O   LYS A 138      21.326 -11.714 -10.653  1.00 81.03           O  
ATOM   1102  CB  LYS A 138      19.421 -11.112  -7.951  1.00 82.33           C  
ATOM   1103  CG  LYS A 138      19.244 -11.158  -6.424  1.00 82.23           C  
ATOM   1104  CD  LYS A 138      18.643 -12.466  -5.886  1.00 83.96           C  
ATOM   1105  CE  LYS A 138      18.438 -12.351  -4.374  1.00 83.44           C  
ATOM   1106  NZ  LYS A 138      17.789 -13.525  -3.732  1.00 81.57           N  
ATOM   1107  N   GLN A 139      19.075 -11.912 -10.821  1.00 80.49           N  
ATOM   1108  CA  GLN A 139      18.943 -11.271 -12.112  1.00 79.73           C  
ATOM   1109  C   GLN A 139      18.124  -9.965 -12.004  1.00 79.10           C  
ATOM   1110  O   GLN A 139      16.877  -9.944 -11.837  1.00 78.91           O  
ATOM   1111  CB  GLN A 139      18.314 -12.229 -13.115  1.00 79.65           C  
ATOM   1112  CG  GLN A 139      18.584 -11.844 -14.578  1.00 80.37           C  
ATOM   1113  CD  GLN A 139      17.642 -12.541 -15.574  1.00 80.91           C  
ATOM   1114  OE1 GLN A 139      17.471 -13.783 -15.568  1.00 82.90           O  
ATOM   1115  NE2 GLN A 139      17.042 -11.743 -16.452  1.00 81.55           N  
ATOM   1116  N   VAL A 140      18.836  -8.856 -12.117  1.00 78.03           N  
ATOM   1117  CA  VAL A 140      18.219  -7.565 -11.970  1.00 75.96           C  
ATOM   1118  C   VAL A 140      17.367  -7.219 -13.176  1.00 75.76           C  
ATOM   1119  O   VAL A 140      17.879  -7.193 -14.304  1.00 74.31           O  
ATOM   1120  CB  VAL A 140      19.276  -6.499 -11.774  1.00 75.90           C  
ATOM   1121  CG1 VAL A 140      18.667  -5.088 -11.882  1.00 76.57           C  
ATOM   1122  CG2 VAL A 140      19.969  -6.686 -10.441  1.00 76.27           C  
ATOM   1123  N   LEU A 141      16.090  -6.896 -12.910  1.00 75.69           N  
ATOM   1124  CA  LEU A 141      15.164  -6.403 -13.938  1.00 76.08           C  
ATOM   1125  C   LEU A 141      14.908  -4.913 -14.079  1.00 75.91           C  
ATOM   1126  O   LEU A 141      14.311  -4.500 -15.058  1.00 76.19           O  
ATOM   1127  CB  LEU A 141      13.795  -7.047 -13.815  1.00 76.10           C  
ATOM   1128  CG  LEU A 141      13.750  -8.542 -13.895  1.00 74.35           C  
ATOM   1129  CD1 LEU A 141      12.356  -8.919 -13.442  1.00 72.65           C  
ATOM   1130  CD2 LEU A 141      14.099  -8.984 -15.313  1.00 74.79           C  
ATOM   1131  N   GLY A 142      15.337  -4.104 -13.125  1.00 76.71           N  
ATOM   1132  CA  GLY A 142      15.029  -2.646 -13.146  1.00 74.24           C  
ATOM   1133  C   GLY A 142      15.455  -2.034 -11.845  1.00 73.71           C  
ATOM   1134  O   GLY A 142      15.854  -2.745 -10.895  1.00 72.88           O  
ATOM   1135  N   ALA A 143      15.373  -0.714 -11.788  1.00 73.90           N  
ATOM   1136  CA  ALA A 143      15.534   0.008 -10.530  1.00 73.77           C  
ATOM   1137  C   ALA A 143      14.973   1.445 -10.544  1.00 73.92           C  
ATOM   1138  O   ALA A 143      14.849   2.052 -11.599  1.00 72.93           O  
ATOM   1139  CB  ALA A 143      16.989   0.007 -10.149  1.00 73.39           C  
ATOM   1140  N   ASP A 144      14.649   1.979  -9.367  1.00 74.93           N  
ATOM   1141  CA  ASP A 144      14.129   3.335  -9.262  1.00 76.81           C  
ATOM   1142  C   ASP A 144      14.793   4.008  -8.109  1.00 76.43           C  
ATOM   1143  O   ASP A 144      14.704   3.541  -6.974  1.00 76.82           O  
ATOM   1144  CB  ASP A 144      12.645   3.368  -9.025  1.00 77.71           C  
ATOM   1145  CG  ASP A 144      12.043   4.702  -9.412  1.00 84.27           C  
ATOM   1146  OD1 ASP A 144      12.376   5.745  -8.767  1.00 93.40           O  
ATOM   1147  OD2 ASP A 144      11.247   4.736 -10.394  1.00 88.16           O  
ATOM   1148  N   PHE A 145      15.432   5.128  -8.418  1.00 75.91           N  
ATOM   1149  CA  PHE A 145      16.421   5.766  -7.552  1.00 75.82           C  
ATOM   1150  C   PHE A 145      16.039   7.228  -7.516  1.00 76.69           C  
ATOM   1151  O   PHE A 145      15.784   7.838  -8.581  1.00 76.76           O  
ATOM   1152  CB  PHE A 145      17.826   5.622  -8.173  1.00 74.94           C  
ATOM   1153  CG  PHE A 145      18.465   4.307  -7.921  1.00 73.47           C  
ATOM   1154  CD1 PHE A 145      17.743   3.245  -7.299  1.00 72.50           C  
ATOM   1155  CD2 PHE A 145      19.760   4.087  -8.318  1.00 73.76           C  
ATOM   1156  CE1 PHE A 145      18.332   2.009  -7.003  1.00 69.36           C  
ATOM   1157  CE2 PHE A 145      20.397   2.809  -8.038  1.00 75.70           C  
ATOM   1158  CZ  PHE A 145      19.661   1.776  -7.374  1.00 72.68           C  
ATOM   1159  N   ASN A 146      15.938   7.788  -6.301  1.00 76.79           N  
ATOM   1160  CA  ASN A 146      15.547   9.169  -6.180  1.00 76.70           C  
ATOM   1161  C   ASN A 146      16.345   9.821  -5.079  1.00 76.52           C  
ATOM   1162  O   ASN A 146      16.824   9.161  -4.163  1.00 74.89           O  
ATOM   1163  CB  ASN A 146      14.052   9.334  -5.928  1.00 76.66           C  
ATOM   1164  CG  ASN A 146      13.708   9.136  -4.457  1.00 79.80           C  
ATOM   1165  OD1 ASN A 146      13.460   8.003  -4.020  1.00 82.06           O  
ATOM   1166  ND2 ASN A 146      13.703  10.247  -3.668  1.00 81.84           N  
ATOM   1167  N   TYR A 147      16.457  11.143  -5.199  1.00 76.45           N  
ATOM   1168  CA  TYR A 147      16.958  11.997  -4.163  1.00 76.42           C  
ATOM   1169  C   TYR A 147      16.440  13.390  -4.496  1.00 76.41           C  
ATOM   1170  O   TYR A 147      16.874  14.041  -5.438  1.00 75.70           O  
ATOM   1171  CB  TYR A 147      18.482  11.924  -4.075  1.00 76.63           C  
ATOM   1172  CG  TYR A 147      18.996  12.551  -2.811  1.00 77.21           C  
ATOM   1173  CD1 TYR A 147      18.173  12.678  -1.719  1.00 76.24           C  
ATOM   1174  CD2 TYR A 147      20.317  13.022  -2.705  1.00 78.13           C  
ATOM   1175  CE1 TYR A 147      18.627  13.289  -0.538  1.00 80.01           C  
ATOM   1176  CE2 TYR A 147      20.783  13.611  -1.534  1.00 77.83           C  
ATOM   1177  CZ  TYR A 147      19.925  13.748  -0.456  1.00 78.93           C  
ATOM   1178  OH  TYR A 147      20.321  14.327   0.731  1.00 79.50           O  
ATOM   1179  N   ALA A 148      15.449  13.809  -3.722  1.00 76.87           N  
ATOM   1180  CA  ALA A 148      14.712  15.008  -3.972  1.00 76.33           C  
ATOM   1181  C   ALA A 148      14.357  15.558  -2.623  1.00 77.70           C  
ATOM   1182  O   ALA A 148      13.483  15.039  -1.938  1.00 78.37           O  
ATOM   1183  CB  ALA A 148      13.471  14.689  -4.713  1.00 75.16           C  
ATOM   1184  N   LYS A 149      15.039  16.629  -2.243  1.00 79.41           N  
ATOM   1185  CA  LYS A 149      14.708  17.380  -1.018  1.00 80.06           C  
ATOM   1186  C   LYS A 149      14.605  18.880  -1.274  1.00 80.04           C  
ATOM   1187  O   LYS A 149      15.467  19.493  -1.911  1.00 80.12           O  
ATOM   1188  CB  LYS A 149      15.690  17.043   0.117  1.00 79.24           C  
ATOM   1189  CG  LYS A 149      15.852  15.493   0.335  1.00 81.01           C  
ATOM   1190  CD  LYS A 149      14.577  14.844   0.944  1.00 80.28           C  
ATOM   1191  CE  LYS A 149      14.752  13.395   1.455  1.00 77.77           C  
ATOM   1192  NZ  LYS A 149      13.369  12.777   1.613  1.00 73.15           N  
ATOM   1193  N   TYR A 150      13.523  19.453  -0.779  1.00 80.76           N  
ATOM   1194  CA  TYR A 150      13.345  20.902  -0.736  1.00 81.81           C  
ATOM   1195  C   TYR A 150      14.523  21.571  -0.060  1.00 82.57           C  
ATOM   1196  O   TYR A 150      14.715  21.359   1.121  1.00 81.85           O  
ATOM   1197  CB  TYR A 150      12.096  21.217   0.075  1.00 80.91           C  
ATOM   1198  CG  TYR A 150      11.631  22.624  -0.067  1.00 79.25           C  
ATOM   1199  CD1 TYR A 150      10.982  23.057  -1.236  1.00 76.55           C  
ATOM   1200  CD2 TYR A 150      11.819  23.532   0.980  1.00 75.89           C  
ATOM   1201  CE1 TYR A 150      10.525  24.401  -1.332  1.00 79.61           C  
ATOM   1202  CE2 TYR A 150      11.413  24.841   0.883  1.00 74.27           C  
ATOM   1203  CZ  TYR A 150      10.776  25.282  -0.265  1.00 78.33           C  
ATOM   1204  OH  TYR A 150      10.347  26.600  -0.309  1.00 79.75           O  
ATOM   1205  N   SER A 151      15.291  22.366  -0.812  1.00 84.63           N  
ATOM   1206  CA  SER A 151      16.470  23.099  -0.276  1.00 86.85           C  
ATOM   1207  C   SER A 151      16.081  24.275   0.609  1.00 88.76           C  
ATOM   1208  O   SER A 151      14.948  24.395   1.091  1.00 88.73           O  
ATOM   1209  CB  SER A 151      17.322  23.643  -1.440  1.00 86.47           C  
ATOM   1210  OG  SER A 151      18.709  23.640  -1.125  1.00 85.05           O  
ATOM   1211  N   SER A 152      17.043  25.162   0.820  1.00 91.73           N  
ATOM   1212  CA  SER A 152      16.743  26.548   1.224  1.00 93.31           C  
ATOM   1213  C   SER A 152      16.931  27.467  -0.024  1.00 94.20           C  
ATOM   1214  O   SER A 152      18.093  27.726  -0.406  1.00 94.35           O  
ATOM   1215  CB  SER A 152      17.610  26.981   2.415  1.00 92.85           C  
ATOM   1216  N   LYS A 153      15.840  27.973  -0.654  1.00 95.03           N  
ATOM   1217  CA  LYS A 153      14.397  27.946  -0.203  1.00 95.52           C  
ATOM   1218  C   LYS A 153      13.659  29.280  -0.411  1.00 95.61           C  
ATOM   1219  O   LYS A 153      13.738  30.191   0.448  1.00 95.84           O  
ATOM   1220  CB  LYS A 153      14.222  27.553   1.281  1.00 95.72           C  
ATOM   1221  N   GLY A 172      25.403  23.878 -10.645  1.00 88.43           N  
ATOM   1222  CA  GLY A 172      24.156  23.824  -9.873  1.00 89.31           C  
ATOM   1223  C   GLY A 172      23.002  23.156 -10.652  1.00 89.47           C  
ATOM   1224  O   GLY A 172      23.193  22.653 -11.778  1.00 88.74           O  
ATOM   1225  N   GLY A 173      21.802  23.211 -10.069  1.00 88.24           N  
ATOM   1226  CA  GLY A 173      20.664  22.465 -10.581  1.00 87.74           C  
ATOM   1227  C   GLY A 173      20.514  21.115  -9.914  1.00 86.93           C  
ATOM   1228  O   GLY A 173      21.496  20.574  -9.363  1.00 87.25           O  
ATOM   1229  N   ALA A 174      19.316  20.537 -10.000  1.00 85.75           N  
ATOM   1230  CA  ALA A 174      19.002  19.337  -9.195  1.00 84.66           C  
ATOM   1231  C   ALA A 174      19.768  18.107  -9.645  1.00 84.58           C  
ATOM   1232  O   ALA A 174      20.216  17.308  -8.813  1.00 84.94           O  
ATOM   1233  CB  ALA A 174      17.515  19.078  -9.155  1.00 84.51           C  
ATOM   1234  N   LEU A 175      19.965  17.962 -10.955  1.00 84.60           N  
ATOM   1235  CA  LEU A 175      20.797  16.895 -11.465  1.00 84.99           C  
ATOM   1236  C   LEU A 175      22.192  16.855 -10.877  1.00 86.27           C  
ATOM   1237  O   LEU A 175      22.650  15.816 -10.376  1.00 86.07           O  
ATOM   1238  CB  LEU A 175      20.915  16.986 -12.970  1.00 85.02           C  
ATOM   1239  CG  LEU A 175      21.533  15.717 -13.597  1.00 84.65           C  
ATOM   1240  CD1 LEU A 175      20.945  14.453 -12.965  1.00 84.34           C  
ATOM   1241  CD2 LEU A 175      21.279  15.766 -15.056  1.00 81.70           C  
HETATM 1242  N   MSE A 176      22.865  17.990 -10.971  1.00 88.59           N  
HETATM 1243  CA  MSE A 176      24.265  18.147 -10.567  1.00 91.26           C  
HETATM 1244  C   MSE A 176      24.476  18.155  -9.059  1.00 91.44           C  
HETATM 1245  O   MSE A 176      25.527  17.788  -8.620  1.00 92.27           O  
HETATM 1246  CB  MSE A 176      24.831  19.461 -11.141  1.00 92.25           C  
HETATM 1247  CG  MSE A 176      24.981  19.450 -12.639  1.00 96.76           C  
HETATM 1248 SE   MSE A 176      26.546  18.344 -13.048  1.00111.63          SE  
HETATM 1249  CE  MSE A 176      27.982  19.614 -12.559  1.00106.90           C  
ATOM   1250  N   ASP A 177      23.503  18.593  -8.272  1.00 91.67           N  
ATOM   1251  CA  ASP A 177      23.707  18.715  -6.847  1.00 92.35           C  
ATOM   1252  C   ASP A 177      23.159  17.502  -6.149  1.00 91.94           C  
ATOM   1253  O   ASP A 177      23.744  17.025  -5.190  1.00 91.78           O  
ATOM   1254  CB  ASP A 177      23.050  20.004  -6.310  1.00 93.51           C  
ATOM   1255  CG  ASP A 177      23.171  20.176  -4.736  1.00 98.83           C  
ATOM   1256  OD1 ASP A 177      24.164  19.704  -4.113  1.00102.23           O  
ATOM   1257  OD2 ASP A 177      22.269  20.830  -4.114  1.00102.54           O  
ATOM   1258  N   LEU A 178      22.009  17.016  -6.592  1.00 92.12           N  
ATOM   1259  CA  LEU A 178      21.382  15.857  -5.933  1.00 91.33           C  
ATOM   1260  C   LEU A 178      21.267  14.608  -6.796  1.00 91.20           C  
ATOM   1261  O   LEU A 178      21.442  13.497  -6.282  1.00 90.99           O  
ATOM   1262  CB  LEU A 178      20.013  16.210  -5.358  1.00 90.81           C  
ATOM   1263  CG  LEU A 178      19.910  17.132  -4.131  1.00 88.73           C  
ATOM   1264  CD1 LEU A 178      18.517  17.049  -3.591  1.00 86.64           C  
ATOM   1265  CD2 LEU A 178      20.864  16.778  -3.007  1.00 88.76           C  
ATOM   1266  N   GLY A 179      20.972  14.774  -8.090  1.00 90.75           N  
ATOM   1267  CA  GLY A 179      20.789  13.614  -8.983  1.00 90.08           C  
ATOM   1268  C   GLY A 179      22.067  12.807  -9.095  1.00 90.31           C  
ATOM   1269  O   GLY A 179      22.070  11.621  -9.476  1.00 91.40           O  
ATOM   1270  N   ILE A 180      23.184  13.447  -8.780  1.00 89.78           N  
ATOM   1271  CA  ILE A 180      24.469  12.760  -8.837  1.00 88.27           C  
ATOM   1272  C   ILE A 180      24.517  11.608  -7.840  1.00 88.26           C  
ATOM   1273  O   ILE A 180      25.303  10.714  -8.030  1.00 90.33           O  
ATOM   1274  CB  ILE A 180      25.645  13.745  -8.560  1.00 88.34           C  
ATOM   1275  CG1 ILE A 180      27.000  13.128  -8.933  1.00 87.12           C  
ATOM   1276  CG2 ILE A 180      25.637  14.234  -7.069  1.00 86.48           C  
ATOM   1277  CD1 ILE A 180      28.122  14.166  -9.191  1.00 87.68           C  
ATOM   1278  N   TYR A 181      23.736  11.641  -6.761  1.00 87.63           N  
ATOM   1279  CA  TYR A 181      23.735  10.558  -5.766  1.00 86.99           C  
ATOM   1280  C   TYR A 181      23.116   9.271  -6.350  1.00 86.92           C  
ATOM   1281  O   TYR A 181      23.780   8.222  -6.346  1.00 88.01           O  
ATOM   1282  CB  TYR A 181      23.052  10.981  -4.430  1.00 87.74           C  
ATOM   1283  CG  TYR A 181      23.891  11.919  -3.611  1.00 86.66           C  
ATOM   1284  CD1 TYR A 181      24.860  11.428  -2.759  1.00 86.84           C  
ATOM   1285  CD2 TYR A 181      23.752  13.308  -3.730  1.00 89.11           C  
ATOM   1286  CE1 TYR A 181      25.666  12.274  -2.009  1.00 91.32           C  
ATOM   1287  CE2 TYR A 181      24.557  14.197  -2.987  1.00 89.57           C  
ATOM   1288  CZ  TYR A 181      25.528  13.663  -2.127  1.00 91.87           C  
ATOM   1289  OH  TYR A 181      26.364  14.473  -1.395  1.00 89.18           O  
ATOM   1290  N   PRO A 182      21.855   9.330  -6.852  1.00 85.38           N  
ATOM   1291  CA  PRO A 182      21.285   8.207  -7.575  1.00 84.23           C  
ATOM   1292  C   PRO A 182      22.238   7.714  -8.635  1.00 83.83           C  
ATOM   1293  O   PRO A 182      22.502   6.538  -8.665  1.00 82.91           O  
ATOM   1294  CB  PRO A 182      20.063   8.808  -8.283  1.00 84.99           C  
ATOM   1295  CG  PRO A 182      19.710  10.029  -7.585  1.00 85.08           C  
ATOM   1296  CD  PRO A 182      20.906  10.446  -6.722  1.00 85.81           C  
ATOM   1297  N   LEU A 183      22.774   8.605  -9.479  1.00 83.60           N  
ATOM   1298  CA  LEU A 183      23.698   8.173 -10.527  1.00 84.54           C  
ATOM   1299  C   LEU A 183      24.885   7.386 -10.001  1.00 84.50           C  
ATOM   1300  O   LEU A 183      25.206   6.327 -10.542  1.00 84.60           O  
ATOM   1301  CB  LEU A 183      24.239   9.341 -11.328  1.00 84.81           C  
ATOM   1302  CG  LEU A 183      23.204  10.025 -12.171  1.00 87.49           C  
ATOM   1303  CD1 LEU A 183      23.660  11.448 -12.384  1.00 91.32           C  
ATOM   1304  CD2 LEU A 183      23.126   9.329 -13.464  1.00 88.61           C  
ATOM   1305  N   TYR A 184      25.556   7.901  -8.972  1.00 83.96           N  
ATOM   1306  CA  TYR A 184      26.657   7.148  -8.357  1.00 84.18           C  
ATOM   1307  C   TYR A 184      26.198   5.787  -7.780  1.00 84.61           C  
ATOM   1308  O   TYR A 184      26.964   4.821  -7.642  1.00 84.66           O  
ATOM   1309  CB  TYR A 184      27.324   7.998  -7.274  1.00 83.67           C  
ATOM   1310  CG  TYR A 184      28.736   8.497  -7.612  1.00 83.03           C  
ATOM   1311  CD1 TYR A 184      29.796   7.601  -7.792  1.00 80.57           C  
ATOM   1312  CD2 TYR A 184      29.016   9.868  -7.716  1.00 83.91           C  
ATOM   1313  CE1 TYR A 184      31.085   8.044  -8.092  1.00 79.33           C  
ATOM   1314  CE2 TYR A 184      30.323  10.333  -8.026  1.00 81.33           C  
ATOM   1315  CZ  TYR A 184      31.348   9.394  -8.206  1.00 81.15           C  
ATOM   1316  OH  TYR A 184      32.639   9.811  -8.479  1.00 82.35           O  
ATOM   1317  N   ALA A 185      24.931   5.687  -7.410  1.00 85.19           N  
ATOM   1318  CA  ALA A 185      24.520   4.434  -6.816  1.00 84.32           C  
ATOM   1319  C   ALA A 185      24.311   3.481  -7.962  1.00 83.76           C  
ATOM   1320  O   ALA A 185      24.763   2.355  -7.892  1.00 83.88           O  
ATOM   1321  CB  ALA A 185      23.285   4.597  -5.979  1.00 83.96           C  
ATOM   1322  N   ALA A 186      23.635   3.936  -9.016  1.00 83.59           N  
ATOM   1323  CA  ALA A 186      23.402   3.104 -10.221  1.00 83.33           C  
ATOM   1324  C   ALA A 186      24.751   2.634 -10.754  1.00 83.98           C  
ATOM   1325  O   ALA A 186      24.940   1.458 -11.046  1.00 83.62           O  
ATOM   1326  CB  ALA A 186      22.703   3.858 -11.254  1.00 82.59           C  
ATOM   1327  N   VAL A 187      25.715   3.544 -10.808  1.00 83.86           N  
ATOM   1328  CA  VAL A 187      27.014   3.176 -11.332  1.00 83.92           C  
ATOM   1329  C   VAL A 187      27.778   2.208 -10.434  1.00 84.26           C  
ATOM   1330  O   VAL A 187      28.486   1.313 -10.926  1.00 83.48           O  
ATOM   1331  CB  VAL A 187      27.815   4.431 -11.727  1.00 83.75           C  
ATOM   1332  CG1 VAL A 187      29.327   4.111 -11.971  1.00 80.37           C  
ATOM   1333  CG2 VAL A 187      27.113   5.062 -12.957  1.00 82.53           C  
ATOM   1334  N   ARG A 188      27.563   2.365  -9.133  1.00 84.73           N  
ATOM   1335  CA  ARG A 188      28.271   1.603  -8.112  1.00 85.84           C  
ATOM   1336  C   ARG A 188      27.872   0.153  -8.258  1.00 85.98           C  
ATOM   1337  O   ARG A 188      28.697  -0.681  -8.582  1.00 87.24           O  
ATOM   1338  CB  ARG A 188      27.955   2.164  -6.712  1.00 85.54           C  
ATOM   1339  CG  ARG A 188      28.504   1.380  -5.552  1.00 85.42           C  
ATOM   1340  CD  ARG A 188      30.042   1.398  -5.539  1.00 88.57           C  
ATOM   1341  NE  ARG A 188      30.561   0.749  -4.336  1.00 88.90           N  
ATOM   1342  CZ  ARG A 188      30.863  -0.541  -4.253  1.00 87.97           C  
ATOM   1343  NH1 ARG A 188      30.720  -1.335  -5.319  1.00 88.07           N  
ATOM   1344  NH2 ARG A 188      31.309  -1.028  -3.102  1.00 86.05           N  
ATOM   1345  N   LEU A 189      26.608  -0.156  -8.025  1.00 86.63           N  
ATOM   1346  CA  LEU A 189      26.009  -1.398  -8.551  1.00 87.84           C  
ATOM   1347  C   LEU A 189      26.107  -1.176 -10.085  1.00 88.43           C  
ATOM   1348  O   LEU A 189      26.531  -0.088 -10.507  1.00 91.63           O  
ATOM   1349  CB  LEU A 189      24.545  -1.502  -8.065  1.00 87.37           C  
ATOM   1350  CG  LEU A 189      24.333  -1.099  -6.583  1.00 86.76           C  
ATOM   1351  CD1 LEU A 189      22.869  -0.778  -6.210  1.00 84.81           C  
ATOM   1352  CD2 LEU A 189      24.981  -2.078  -5.587  1.00 84.83           C  
ATOM   1353  N   PHE A 190      25.723  -2.122 -10.916  1.00 86.13           N  
ATOM   1354  CA  PHE A 190      25.440  -1.828 -12.346  1.00 84.75           C  
ATOM   1355  C   PHE A 190      26.499  -1.304 -13.332  1.00 84.81           C  
ATOM   1356  O   PHE A 190      26.453  -1.664 -14.506  1.00 85.52           O  
ATOM   1357  CB  PHE A 190      24.207  -0.964 -12.574  1.00 83.54           C  
ATOM   1358  CG  PHE A 190      23.041  -1.202 -11.631  1.00 82.97           C  
ATOM   1359  CD1 PHE A 190      22.861  -2.400 -10.947  1.00 78.76           C  
ATOM   1360  CD2 PHE A 190      22.061  -0.185 -11.478  1.00 81.88           C  
ATOM   1361  CE1 PHE A 190      21.768  -2.598 -10.096  1.00 76.30           C  
ATOM   1362  CE2 PHE A 190      20.953  -0.389 -10.625  1.00 81.05           C  
ATOM   1363  CZ  PHE A 190      20.800  -1.613  -9.962  1.00 79.88           C  
ATOM   1364  N   GLY A 191      27.414  -0.439 -12.926  1.00 85.52           N  
ATOM   1365  CA  GLY A 191      28.361   0.154 -13.906  1.00 85.66           C  
ATOM   1366  C   GLY A 191      27.788   1.189 -14.889  1.00 85.43           C  
ATOM   1367  O   GLY A 191      26.728   1.736 -14.682  1.00 84.89           O  
ATOM   1368  N   LYS A 192      28.483   1.447 -15.981  1.00 85.88           N  
ATOM   1369  CA  LYS A 192      28.032   2.476 -16.877  1.00 86.28           C  
ATOM   1370  C   LYS A 192      26.824   2.021 -17.662  1.00 86.12           C  
ATOM   1371  O   LYS A 192      26.760   0.896 -18.135  1.00 87.06           O  
ATOM   1372  CB  LYS A 192      29.137   2.942 -17.825  1.00 86.15           C  
ATOM   1373  CG  LYS A 192      28.954   4.446 -18.169  1.00 88.14           C  
ATOM   1374  CD  LYS A 192      29.827   4.934 -19.359  1.00 88.00           C  
ATOM   1375  CE  LYS A 192      29.304   6.285 -19.867  1.00 86.03           C  
ATOM   1376  NZ  LYS A 192      27.794   6.363 -19.739  1.00 85.79           N  
ATOM   1377  N   ALA A 193      25.852   2.907 -17.794  1.00 85.75           N  
ATOM   1378  CA  ALA A 193      24.682   2.629 -18.579  1.00 84.84           C  
ATOM   1379  C   ALA A 193      25.040   2.895 -20.037  1.00 84.23           C  
ATOM   1380  O   ALA A 193      26.042   3.540 -20.310  1.00 83.82           O  
ATOM   1381  CB  ALA A 193      23.574   3.504 -18.109  1.00 84.96           C  
ATOM   1382  N   ASN A 194      24.251   2.382 -20.972  1.00 84.10           N  
ATOM   1383  CA  ASN A 194      24.656   2.427 -22.368  1.00 84.91           C  
ATOM   1384  C   ASN A 194      24.369   3.755 -22.975  1.00 85.19           C  
ATOM   1385  O   ASN A 194      25.043   4.167 -23.934  1.00 86.03           O  
ATOM   1386  CB  ASN A 194      23.941   1.370 -23.181  1.00 84.93           C  
ATOM   1387  CG  ASN A 194      24.517  -0.011 -22.950  1.00 87.37           C  
ATOM   1388  OD1 ASN A 194      25.742  -0.195 -22.952  1.00 87.06           O  
ATOM   1389  ND2 ASN A 194      23.633  -0.992 -22.724  1.00 89.56           N  
ATOM   1390  N   ASP A 195      23.345   4.394 -22.400  1.00 84.26           N  
ATOM   1391  CA  ASP A 195      22.724   5.597 -22.882  1.00 83.20           C  
ATOM   1392  C   ASP A 195      21.879   6.075 -21.693  1.00 82.10           C  
ATOM   1393  O   ASP A 195      21.630   5.303 -20.767  1.00 80.69           O  
ATOM   1394  CB  ASP A 195      21.847   5.284 -24.091  1.00 83.36           C  
ATOM   1395  CG  ASP A 195      21.412   6.554 -24.891  1.00 85.97           C  
ATOM   1396  OD1 ASP A 195      21.785   7.723 -24.558  1.00 83.89           O  
ATOM   1397  OD2 ASP A 195      20.650   6.345 -25.872  1.00 88.08           O  
ATOM   1398  N   ALA A 196      21.495   7.351 -21.691  1.00 80.85           N  
ATOM   1399  CA  ALA A 196      20.631   7.886 -20.615  1.00 80.94           C  
ATOM   1400  C   ALA A 196      19.817   9.069 -21.129  1.00 80.47           C  
ATOM   1401  O   ALA A 196      20.167   9.691 -22.125  1.00 81.28           O  
ATOM   1402  CB  ALA A 196      21.449   8.271 -19.398  1.00 80.00           C  
ATOM   1403  N   THR A 197      18.704   9.363 -20.507  1.00 80.20           N  
ATOM   1404  CA  THR A 197      17.996  10.573 -20.917  1.00 81.03           C  
ATOM   1405  C   THR A 197      17.586  11.310 -19.653  1.00 79.95           C  
ATOM   1406  O   THR A 197      17.703  10.727 -18.537  1.00 79.93           O  
ATOM   1407  CB  THR A 197      16.851  10.261 -21.959  1.00 81.56           C  
ATOM   1408  OG1 THR A 197      16.661  11.372 -22.840  1.00 84.75           O  
ATOM   1409  CG2 THR A 197      15.547   9.914 -21.303  1.00 83.12           C  
ATOM   1410  N   TYR A 198      17.201  12.585 -19.795  1.00 79.02           N  
ATOM   1411  CA  TYR A 198      16.795  13.431 -18.653  1.00 78.56           C  
ATOM   1412  C   TYR A 198      15.869  14.529 -19.106  1.00 78.05           C  
ATOM   1413  O   TYR A 198      16.127  15.154 -20.121  1.00 78.43           O  
ATOM   1414  CB  TYR A 198      18.031  14.036 -17.948  1.00 79.34           C  
ATOM   1415  CG  TYR A 198      17.727  14.704 -16.594  1.00 80.31           C  
ATOM   1416  CD1 TYR A 198      17.256  13.966 -15.493  1.00 80.44           C  
ATOM   1417  CD2 TYR A 198      17.935  16.061 -16.414  1.00 78.67           C  
ATOM   1418  CE1 TYR A 198      16.963  14.593 -14.257  1.00 80.37           C  
ATOM   1419  CE2 TYR A 198      17.673  16.663 -15.203  1.00 79.66           C  
ATOM   1420  CZ  TYR A 198      17.176  15.944 -14.146  1.00 79.83           C  
ATOM   1421  OH  TYR A 198      16.928  16.615 -12.975  1.00 80.31           O  
ATOM   1422  N   HIS A 199      14.760  14.740 -18.407  1.00 77.91           N  
ATOM   1423  CA  HIS A 199      13.827  15.824 -18.767  1.00 78.46           C  
ATOM   1424  C   HIS A 199      13.482  16.526 -17.480  1.00 77.08           C  
ATOM   1425  O   HIS A 199      13.051  15.857 -16.504  1.00 78.29           O  
ATOM   1426  CB  HIS A 199      12.579  15.283 -19.451  1.00 79.15           C  
ATOM   1427  CG  HIS A 199      12.892  14.509 -20.684  1.00 87.13           C  
ATOM   1428  ND1 HIS A 199      12.720  15.025 -21.954  1.00 92.91           N  
ATOM   1429  CD2 HIS A 199      13.443  13.277 -20.848  1.00 92.18           C  
ATOM   1430  CE1 HIS A 199      13.129  14.132 -22.845  1.00 95.39           C  
ATOM   1431  NE2 HIS A 199      13.585  13.068 -22.199  1.00 93.63           N  
ATOM   1432  N   ALA A 200      13.710  17.834 -17.459  1.00 74.51           N  
ATOM   1433  CA  ALA A 200      13.707  18.603 -16.216  1.00 74.38           C  
ATOM   1434  C   ALA A 200      12.705  19.720 -16.231  1.00 73.99           C  
ATOM   1435  O   ALA A 200      12.292  20.119 -17.277  1.00 74.66           O  
ATOM   1436  CB  ALA A 200      15.052  19.182 -16.013  1.00 74.32           C  
ATOM   1437  N   GLN A 201      12.272  20.217 -15.080  1.00 74.50           N  
ATOM   1438  CA  GLN A 201      11.589  21.521 -15.052  1.00 73.41           C  
ATOM   1439  C   GLN A 201      12.673  22.532 -14.876  1.00 73.14           C  
ATOM   1440  O   GLN A 201      13.573  22.349 -14.061  1.00 72.53           O  
ATOM   1441  CB  GLN A 201      10.633  21.652 -13.902  1.00 73.09           C  
ATOM   1442  CG  GLN A 201       9.397  20.832 -14.059  1.00 75.81           C  
ATOM   1443  CD  GLN A 201       8.619  21.077 -15.347  1.00 76.89           C  
ATOM   1444  OE1 GLN A 201       8.048  22.159 -15.543  1.00 74.92           O  
ATOM   1445  NE2 GLN A 201       8.583  20.046 -16.239  1.00 73.94           N  
ATOM   1446  N   GLN A 202      12.617  23.594 -15.667  1.00 73.16           N  
ATOM   1447  CA  GLN A 202      13.752  24.473 -15.730  1.00 73.36           C  
ATOM   1448  C   GLN A 202      13.424  25.924 -15.437  1.00 73.66           C  
ATOM   1449  O   GLN A 202      12.317  26.394 -15.685  1.00 73.13           O  
ATOM   1450  CB  GLN A 202      14.384  24.354 -17.096  1.00 72.95           C  
ATOM   1451  CG  GLN A 202      15.071  23.067 -17.315  1.00 73.95           C  
ATOM   1452  CD  GLN A 202      15.503  22.978 -18.724  1.00 75.56           C  
ATOM   1453  OE1 GLN A 202      16.680  23.143 -19.026  1.00 77.07           O  
ATOM   1454  NE2 GLN A 202      14.556  22.800 -19.615  1.00 75.15           N  
ATOM   1455  N   LEU A 203      14.411  26.640 -14.919  1.00 74.43           N  
ATOM   1456  CA  LEU A 203      14.242  28.076 -14.787  1.00 75.41           C  
ATOM   1457  C   LEU A 203      14.505  28.665 -16.159  1.00 76.07           C  
ATOM   1458  O   LEU A 203      14.735  27.918 -17.140  1.00 76.70           O  
ATOM   1459  CB  LEU A 203      15.181  28.668 -13.733  1.00 74.93           C  
ATOM   1460  CG  LEU A 203      14.972  28.106 -12.334  1.00 73.55           C  
ATOM   1461  CD1 LEU A 203      16.228  28.324 -11.504  1.00 75.46           C  
ATOM   1462  CD2 LEU A 203      13.711  28.681 -11.675  1.00 71.04           C  
ATOM   1463  N   ASP A 204      14.425  29.987 -16.230  1.00 76.11           N  
ATOM   1464  CA  ASP A 204      14.859  30.735 -17.404  1.00 76.81           C  
ATOM   1465  C   ASP A 204      16.349  30.544 -17.739  1.00 76.24           C  
ATOM   1466  O   ASP A 204      16.716  30.342 -18.907  1.00 76.26           O  
ATOM   1467  CB  ASP A 204      14.483  32.194 -17.214  1.00 77.77           C  
ATOM   1468  CG  ASP A 204      13.023  32.425 -17.531  1.00 81.78           C  
ATOM   1469  OD1 ASP A 204      12.353  31.407 -17.844  1.00 89.51           O  
ATOM   1470  OD2 ASP A 204      12.538  33.576 -17.505  1.00 87.39           O  
ATOM   1471  N   ASN A 205      17.204  30.533 -16.717  1.00 75.15           N  
ATOM   1472  CA  ASN A 205      18.606  30.326 -16.980  1.00 74.80           C  
ATOM   1473  C   ASN A 205      18.949  28.926 -17.570  1.00 75.18           C  
ATOM   1474  O   ASN A 205      20.104  28.681 -17.931  1.00 75.14           O  
ATOM   1475  CB  ASN A 205      19.430  30.670 -15.736  1.00 74.51           C  
ATOM   1476  CG  ASN A 205      19.137  29.767 -14.564  1.00 76.69           C  
ATOM   1477  OD1 ASN A 205      18.471  28.712 -14.693  1.00 81.24           O  
ATOM   1478  ND2 ASN A 205      19.667  30.141 -13.404  1.00 74.40           N  
ATOM   1479  N   SER A 206      17.937  28.043 -17.673  1.00 74.58           N  
ATOM   1480  CA  SER A 206      18.074  26.613 -18.070  1.00 74.24           C  
ATOM   1481  C   SER A 206      18.437  25.616 -16.948  1.00 74.28           C  
ATOM   1482  O   SER A 206      18.436  24.436 -17.176  1.00 74.82           O  
ATOM   1483  CB  SER A 206      18.985  26.414 -19.285  1.00 73.22           C  
ATOM   1484  OG  SER A 206      20.321  26.191 -18.871  1.00 71.28           O  
ATOM   1485  N   ILE A 207      18.712  26.087 -15.738  1.00 75.19           N  
ATOM   1486  CA  ILE A 207      18.984  25.216 -14.580  1.00 75.35           C  
ATOM   1487  C   ILE A 207      17.714  24.449 -14.143  1.00 75.86           C  
ATOM   1488  O   ILE A 207      16.593  24.956 -14.280  1.00 76.65           O  
ATOM   1489  CB  ILE A 207      19.660  26.038 -13.378  1.00 75.46           C  
ATOM   1490  CG1 ILE A 207      21.057  26.510 -13.758  1.00 74.99           C  
ATOM   1491  CG2 ILE A 207      19.811  25.208 -12.099  1.00 75.56           C  
ATOM   1492  CD1 ILE A 207      21.972  25.354 -14.305  1.00 78.16           C  
ATOM   1493  N   ASP A 208      17.880  23.238 -13.623  1.00 76.02           N  
ATOM   1494  CA  ASP A 208      16.740  22.360 -13.337  1.00 76.04           C  
ATOM   1495  C   ASP A 208      16.323  22.336 -11.848  1.00 76.16           C  
ATOM   1496  O   ASP A 208      17.159  22.182 -10.970  1.00 77.81           O  
ATOM   1497  CB  ASP A 208      17.049  20.967 -13.859  1.00 75.87           C  
ATOM   1498  CG  ASP A 208      18.310  20.386 -13.288  1.00 77.13           C  
ATOM   1499  OD1 ASP A 208      19.377  21.043 -13.273  1.00 78.70           O  
ATOM   1500  OD2 ASP A 208      18.239  19.228 -12.847  1.00 80.33           O  
ATOM   1501  N   LEU A 209      15.048  22.540 -11.563  1.00 75.23           N  
ATOM   1502  CA  LEU A 209      14.536  22.505 -10.220  1.00 74.24           C  
ATOM   1503  C   LEU A 209      14.315  21.059  -9.778  1.00 74.95           C  
ATOM   1504  O   LEU A 209      14.530  20.676  -8.594  1.00 76.86           O  
ATOM   1505  CB  LEU A 209      13.225  23.243 -10.208  1.00 74.36           C  
ATOM   1506  CG  LEU A 209      13.291  24.754 -10.504  1.00 75.31           C  
ATOM   1507  CD1 LEU A 209      11.904  25.410 -10.729  1.00 69.65           C  
ATOM   1508  CD2 LEU A 209      14.049  25.451  -9.389  1.00 71.37           C  
ATOM   1509  N   ASN A 210      13.910  20.228 -10.732  1.00 74.31           N  
ATOM   1510  CA  ASN A 210      13.675  18.782 -10.522  1.00 74.08           C  
ATOM   1511  C   ASN A 210      13.657  18.111 -11.894  1.00 74.32           C  
ATOM   1512  O   ASN A 210      13.449  18.800 -12.924  1.00 76.39           O  
ATOM   1513  CB  ASN A 210      12.354  18.522  -9.762  1.00 72.69           C  
ATOM   1514  CG  ASN A 210      11.153  19.138 -10.452  1.00 72.51           C  
ATOM   1515  OD1 ASN A 210      10.724  18.681 -11.499  1.00 75.71           O  
ATOM   1516  ND2 ASN A 210      10.617  20.186  -9.882  1.00 66.79           N  
ATOM   1517  N   GLY A 211      13.854  16.806 -11.950  1.00 73.20           N  
ATOM   1518  CA  GLY A 211      13.710  16.109 -13.221  1.00 72.47           C  
ATOM   1519  C   GLY A 211      13.559  14.601 -13.031  1.00 73.12           C  
ATOM   1520  O   GLY A 211      13.775  14.075 -11.941  1.00 72.93           O  
ATOM   1521  N   ASP A 212      13.196  13.911 -14.114  1.00 73.95           N  
ATOM   1522  CA  ASP A 212      13.178  12.452 -14.165  1.00 74.59           C  
ATOM   1523  C   ASP A 212      14.077  11.976 -15.275  1.00 74.72           C  
ATOM   1524  O   ASP A 212      13.909  12.397 -16.401  1.00 76.59           O  
ATOM   1525  CB  ASP A 212      11.743  11.999 -14.408  1.00 73.63           C  
ATOM   1526  CG  ASP A 212      10.870  12.305 -13.220  1.00 75.88           C  
ATOM   1527  OD1 ASP A 212      11.137  11.634 -12.187  1.00 77.12           O  
ATOM   1528  OD2 ASP A 212       9.982  13.224 -13.280  1.00 74.46           O  
ATOM   1529  N   GLY A 213      15.057  11.143 -14.961  1.00 75.21           N  
ATOM   1530  CA  GLY A 213      15.886  10.497 -15.988  1.00 75.36           C  
ATOM   1531  C   GLY A 213      15.771   8.944 -16.077  1.00 75.20           C  
ATOM   1532  O   GLY A 213      15.182   8.275 -15.225  1.00 73.79           O  
ATOM   1533  N   ILE A 214      16.374   8.376 -17.114  1.00 75.13           N  
ATOM   1534  CA  ILE A 214      16.377   6.932 -17.265  1.00 75.76           C  
ATOM   1535  C   ILE A 214      17.760   6.484 -17.678  1.00 75.51           C  
ATOM   1536  O   ILE A 214      18.340   7.041 -18.588  1.00 75.91           O  
ATOM   1537  CB  ILE A 214      15.351   6.473 -18.363  1.00 75.57           C  
ATOM   1538  CG1 ILE A 214      14.002   7.123 -18.136  1.00 73.96           C  
ATOM   1539  CG2 ILE A 214      15.229   4.977 -18.377  1.00 75.57           C  
ATOM   1540  CD1 ILE A 214      12.796   6.290 -18.487  1.00 72.39           C  
ATOM   1541  N   LEU A 215      18.299   5.482 -17.026  1.00 75.93           N  
ATOM   1542  CA  LEU A 215      19.531   4.934 -17.515  1.00 76.93           C  
ATOM   1543  C   LEU A 215      19.192   3.619 -18.210  1.00 77.79           C  
ATOM   1544  O   LEU A 215      18.474   2.796 -17.662  1.00 79.85           O  
ATOM   1545  CB  LEU A 215      20.514   4.744 -16.385  1.00 76.83           C  
ATOM   1546  CG  LEU A 215      20.896   5.958 -15.520  1.00 78.57           C  
ATOM   1547  CD1 LEU A 215      21.321   5.468 -14.154  1.00 78.43           C  
ATOM   1548  CD2 LEU A 215      21.984   6.844 -16.146  1.00 80.05           C  
ATOM   1549  N   PHE A 216      19.657   3.452 -19.444  1.00 77.60           N  
ATOM   1550  CA  PHE A 216      19.340   2.307 -20.245  1.00 76.53           C  
ATOM   1551  C   PHE A 216      20.469   1.326 -20.131  1.00 77.31           C  
ATOM   1552  O   PHE A 216      21.615   1.679 -20.404  1.00 78.47           O  
ATOM   1553  CB  PHE A 216      19.096   2.744 -21.685  1.00 75.31           C  
ATOM   1554  CG  PHE A 216      17.899   3.686 -21.837  1.00 74.63           C  
ATOM   1555  CD1 PHE A 216      16.598   3.232 -21.602  1.00 71.49           C  
ATOM   1556  CD2 PHE A 216      18.083   5.052 -22.164  1.00 73.57           C  
ATOM   1557  CE1 PHE A 216      15.493   4.112 -21.704  1.00 68.74           C  
ATOM   1558  CE2 PHE A 216      17.000   5.911 -22.269  1.00 66.94           C  
ATOM   1559  CZ  PHE A 216      15.716   5.435 -22.059  1.00 68.09           C  
ATOM   1560  N   TYR A 217      20.144   0.107 -19.704  1.00 77.18           N  
ATOM   1561  CA  TYR A 217      21.107  -0.984 -19.571  1.00 78.59           C  
ATOM   1562  C   TYR A 217      20.656  -2.177 -20.480  1.00 79.43           C  
ATOM   1563  O   TYR A 217      19.500  -2.275 -20.832  1.00 78.81           O  
ATOM   1564  CB  TYR A 217      21.195  -1.440 -18.099  1.00 78.04           C  
ATOM   1565  CG  TYR A 217      21.959  -0.546 -17.175  1.00 77.68           C  
ATOM   1566  CD1 TYR A 217      23.311  -0.772 -16.918  1.00 75.45           C  
ATOM   1567  CD2 TYR A 217      21.319   0.557 -16.531  1.00 77.72           C  
ATOM   1568  CE1 TYR A 217      24.017   0.068 -16.051  1.00 76.36           C  
ATOM   1569  CE2 TYR A 217      22.006   1.402 -15.660  1.00 72.72           C  
ATOM   1570  CZ  TYR A 217      23.346   1.165 -15.418  1.00 77.54           C  
ATOM   1571  OH  TYR A 217      24.034   2.014 -14.546  1.00 76.68           O  
ATOM   1572  N   PRO A 218      21.555  -3.104 -20.842  1.00 80.79           N  
ATOM   1573  CA  PRO A 218      21.059  -3.878 -21.989  1.00 82.00           C  
ATOM   1574  C   PRO A 218      19.758  -4.637 -21.662  1.00 83.60           C  
ATOM   1575  O   PRO A 218      18.872  -4.723 -22.516  1.00 84.50           O  
ATOM   1576  CB  PRO A 218      22.202  -4.831 -22.313  1.00 80.93           C  
ATOM   1577  CG  PRO A 218      23.420  -4.249 -21.604  1.00 80.53           C  
ATOM   1578  CD  PRO A 218      22.889  -3.550 -20.389  1.00 80.93           C  
ATOM   1579  N   ASP A 219      19.616  -5.104 -20.426  1.00 84.22           N  
ATOM   1580  CA  ASP A 219      18.429  -5.842 -20.038  1.00 85.19           C  
ATOM   1581  C   ASP A 219      17.350  -5.089 -19.264  1.00 84.93           C  
ATOM   1582  O   ASP A 219      16.261  -5.610 -19.069  1.00 85.96           O  
ATOM   1583  CB  ASP A 219      18.878  -7.025 -19.212  1.00 86.65           C  
ATOM   1584  CG  ASP A 219      19.534  -8.089 -20.068  1.00 90.56           C  
ATOM   1585  OD1 ASP A 219      18.903  -8.471 -21.113  1.00 89.11           O  
ATOM   1586  OD2 ASP A 219      20.677  -8.514 -19.692  1.00 94.09           O  
ATOM   1587  N   TYR A 220      17.635  -3.869 -18.825  1.00 83.79           N  
ATOM   1588  CA  TYR A 220      16.760  -3.185 -17.920  1.00 83.13           C  
ATOM   1589  C   TYR A 220      17.068  -1.730 -17.991  1.00 82.97           C  
ATOM   1590  O   TYR A 220      17.993  -1.365 -18.698  1.00 83.62           O  
ATOM   1591  CB  TYR A 220      16.913  -3.702 -16.488  1.00 82.95           C  
ATOM   1592  CG  TYR A 220      18.321  -3.656 -15.892  1.00 82.53           C  
ATOM   1593  CD1 TYR A 220      18.793  -2.529 -15.187  1.00 79.04           C  
ATOM   1594  CD2 TYR A 220      19.157  -4.769 -15.997  1.00 79.28           C  
ATOM   1595  CE1 TYR A 220      20.071  -2.540 -14.630  1.00 78.43           C  
ATOM   1596  CE2 TYR A 220      20.400  -4.787 -15.472  1.00 77.46           C  
ATOM   1597  CZ  TYR A 220      20.864  -3.698 -14.783  1.00 81.32           C  
ATOM   1598  OH  TYR A 220      22.147  -3.808 -14.290  1.00 84.16           O  
ATOM   1599  N   GLN A 221      16.273  -0.906 -17.296  1.00 82.45           N  
ATOM   1600  CA  GLN A 221      16.510   0.546 -17.188  1.00 81.81           C  
ATOM   1601  C   GLN A 221      16.411   0.920 -15.749  1.00 81.50           C  
ATOM   1602  O   GLN A 221      15.906   0.150 -14.947  1.00 82.61           O  
ATOM   1603  CB  GLN A 221      15.485   1.341 -17.992  1.00 82.51           C  
ATOM   1604  CG  GLN A 221      13.994   1.087 -17.671  1.00 82.49           C  
ATOM   1605  CD  GLN A 221      13.119   1.489 -18.840  1.00 85.74           C  
ATOM   1606  OE1 GLN A 221      13.467   1.225 -19.998  1.00 87.60           O  
ATOM   1607  NE2 GLN A 221      11.994   2.157 -18.562  1.00 86.49           N  
ATOM   1608  N   VAL A 222      16.942   2.074 -15.388  1.00 81.07           N  
ATOM   1609  CA  VAL A 222      16.841   2.574 -14.030  1.00 80.10           C  
ATOM   1610  C   VAL A 222      16.247   3.971 -14.157  1.00 79.85           C  
ATOM   1611  O   VAL A 222      16.761   4.740 -14.964  1.00 80.48           O  
ATOM   1612  CB  VAL A 222      18.227   2.668 -13.402  1.00 80.57           C  
ATOM   1613  CG1 VAL A 222      18.163   3.248 -11.976  1.00 78.61           C  
ATOM   1614  CG2 VAL A 222      18.889   1.288 -13.377  1.00 81.04           C  
ATOM   1615  N   HIS A 223      15.165   4.279 -13.415  1.00 78.64           N  
ATOM   1616  CA  HIS A 223      14.620   5.641 -13.304  1.00 78.31           C  
ATOM   1617  C   HIS A 223      15.389   6.434 -12.261  1.00 78.67           C  
ATOM   1618  O   HIS A 223      15.702   5.926 -11.172  1.00 79.43           O  
ATOM   1619  CB  HIS A 223      13.117   5.599 -13.013  1.00 78.06           C  
ATOM   1620  CG  HIS A 223      12.502   6.910 -12.590  1.00 81.83           C  
ATOM   1621  ND1 HIS A 223      12.533   8.052 -13.375  1.00 82.59           N  
ATOM   1622  CD2 HIS A 223      11.790   7.244 -11.478  1.00 80.17           C  
ATOM   1623  CE1 HIS A 223      11.905   9.033 -12.748  1.00 78.31           C  
ATOM   1624  NE2 HIS A 223      11.445   8.569 -11.601  1.00 79.81           N  
ATOM   1625  N   ILE A 224      15.720   7.677 -12.589  1.00 78.60           N  
ATOM   1626  CA  ILE A 224      16.389   8.555 -11.646  1.00 78.32           C  
ATOM   1627  C   ILE A 224      15.450   9.720 -11.434  1.00 78.42           C  
ATOM   1628  O   ILE A 224      15.064  10.357 -12.407  1.00 78.83           O  
ATOM   1629  CB  ILE A 224      17.667   9.151 -12.255  1.00 78.14           C  
ATOM   1630  CG1 ILE A 224      18.636   8.100 -12.780  1.00 78.56           C  
ATOM   1631  CG2 ILE A 224      18.405   9.894 -11.236  1.00 80.31           C  
ATOM   1632  CD1 ILE A 224      19.038   7.027 -11.827  1.00 74.30           C  
ATOM   1633  N   LYS A 225      15.064  10.022 -10.194  1.00 77.97           N  
ATOM   1634  CA  LYS A 225      14.391  11.302  -9.918  1.00 77.63           C  
ATOM   1635  C   LYS A 225      15.303  12.222  -9.106  1.00 78.29           C  
ATOM   1636  O   LYS A 225      15.858  11.802  -8.098  1.00 79.47           O  
ATOM   1637  CB  LYS A 225      13.091  11.131  -9.163  1.00 76.80           C  
ATOM   1638  CG  LYS A 225      12.263  12.424  -9.181  1.00 77.49           C  
ATOM   1639  CD  LYS A 225      11.049  12.341  -8.262  1.00 80.17           C  
ATOM   1640  CE  LYS A 225       9.821  12.919  -8.931  1.00 82.09           C  
ATOM   1641  NZ  LYS A 225       9.425  12.252 -10.256  1.00 82.68           N  
ATOM   1642  N   ALA A 226      15.466  13.455  -9.552  1.00 77.26           N  
ATOM   1643  CA  ALA A 226      16.211  14.444  -8.808  1.00 76.82           C  
ATOM   1644  C   ALA A 226      15.261  15.629  -8.514  1.00 77.14           C  
ATOM   1645  O   ALA A 226      14.395  15.969  -9.379  1.00 76.96           O  
ATOM   1646  CB  ALA A 226      17.367  14.920  -9.638  1.00 76.32           C  
ATOM   1647  N   GLY A 227      15.377  16.229  -7.321  1.00 75.89           N  
ATOM   1648  CA  GLY A 227      14.685  17.498  -7.060  1.00 75.56           C  
ATOM   1649  C   GLY A 227      15.181  18.331  -5.887  1.00 75.42           C  
ATOM   1650  O   GLY A 227      15.586  17.758  -4.860  1.00 73.79           O  
ATOM   1651  N   LYS A 228      15.127  19.675  -6.055  1.00 75.04           N  
ATOM   1652  CA  LYS A 228      15.390  20.707  -4.973  1.00 74.11           C  
ATOM   1653  C   LYS A 228      14.225  21.644  -4.555  1.00 72.78           C  
ATOM   1654  O   LYS A 228      14.255  22.260  -3.459  1.00 72.60           O  
ATOM   1655  CB  LYS A 228      16.559  21.600  -5.399  1.00 74.52           C  
ATOM   1656  CG  LYS A 228      17.804  20.782  -5.734  1.00 78.73           C  
ATOM   1657  CD  LYS A 228      18.900  21.686  -6.265  1.00 83.86           C  
ATOM   1658  CE  LYS A 228      19.861  22.143  -5.174  1.00 85.64           C  
ATOM   1659  NZ  LYS A 228      21.087  22.700  -5.852  1.00 89.72           N  
ATOM   1660  N   ASN A 229      13.260  21.832  -5.451  1.00 70.70           N  
ATOM   1661  CA  ASN A 229      12.034  22.526  -5.123  1.00 69.47           C  
ATOM   1662  C   ASN A 229      10.946  21.498  -4.715  1.00 69.60           C  
ATOM   1663  O   ASN A 229       9.780  21.838  -4.634  1.00 69.91           O  
ATOM   1664  CB  ASN A 229      11.561  23.324  -6.320  1.00 67.88           C  
ATOM   1665  CG  ASN A 229      11.123  22.422  -7.466  1.00 69.44           C  
ATOM   1666  OD1 ASN A 229      11.657  21.321  -7.639  1.00 71.29           O  
ATOM   1667  ND2 ASN A 229      10.155  22.860  -8.232  1.00 66.11           N  
ATOM   1668  N   ILE A 230      11.319  20.256  -4.448  1.00 68.63           N  
ATOM   1669  CA  ILE A 230      10.331  19.266  -4.025  1.00 69.68           C  
ATOM   1670  C   ILE A 230      10.952  18.228  -3.124  1.00 71.40           C  
ATOM   1671  O   ILE A 230      12.151  17.883  -3.238  1.00 71.72           O  
ATOM   1672  CB  ILE A 230       9.693  18.471  -5.240  1.00 69.33           C  
ATOM   1673  CG1 ILE A 230      10.781  17.638  -5.965  1.00 68.25           C  
ATOM   1674  CG2 ILE A 230       8.828  19.413  -6.203  1.00 65.43           C  
ATOM   1675  CD1 ILE A 230      10.315  16.824  -7.198  1.00 69.93           C  
ATOM   1676  N   THR A 231      10.121  17.650  -2.266  1.00 73.76           N  
ATOM   1677  CA  THR A 231      10.574  16.560  -1.385  1.00 74.61           C  
ATOM   1678  C   THR A 231       9.881  15.242  -1.685  1.00 75.84           C  
ATOM   1679  O   THR A 231       8.640  15.139  -1.594  1.00 76.31           O  
ATOM   1680  CB  THR A 231      10.374  17.007   0.053  1.00 74.60           C  
ATOM   1681  OG1 THR A 231      11.359  18.017   0.303  1.00 77.47           O  
ATOM   1682  CG2 THR A 231      10.558  15.916   1.063  1.00 73.00           C  
ATOM   1683  N   SER A 232      10.694  14.241  -2.046  1.00 76.71           N  
ATOM   1684  CA  SER A 232      10.249  12.858  -2.158  1.00 77.49           C  
ATOM   1685  C   SER A 232      10.724  12.024  -0.982  1.00 78.72           C  
ATOM   1686  O   SER A 232      11.920  12.031  -0.670  1.00 79.55           O  
ATOM   1687  CB  SER A 232      10.829  12.237  -3.427  1.00 77.76           C  
ATOM   1688  OG  SER A 232      10.446  10.877  -3.561  1.00 76.45           O  
ATOM   1689  N   ASN A 233       9.815  11.293  -0.339  1.00 79.36           N  
ATOM   1690  CA  ASN A 233      10.226  10.286   0.675  1.00 80.52           C  
ATOM   1691  C   ASN A 233      10.121   8.837   0.131  1.00 80.72           C  
ATOM   1692  O   ASN A 233       9.967   7.873   0.886  1.00 81.16           O  
ATOM   1693  CB  ASN A 233       9.421  10.418   1.964  1.00 80.11           C  
ATOM   1694  CG  ASN A 233       9.358  11.855   2.474  1.00 82.72           C  
ATOM   1695  OD1 ASN A 233       8.262  12.428   2.624  1.00 82.47           O  
ATOM   1696  ND2 ASN A 233      10.535  12.449   2.743  1.00 83.89           N  
ATOM   1697  N   LEU A 234      10.181   8.704  -1.189  1.00 80.71           N  
ATOM   1698  CA  LEU A 234      10.145   7.399  -1.837  1.00 81.05           C  
ATOM   1699  C   LEU A 234      11.405   6.589  -1.557  1.00 80.12           C  
ATOM   1700  O   LEU A 234      12.504   7.067  -1.727  1.00 79.48           O  
ATOM   1701  CB  LEU A 234       9.951   7.521  -3.353  1.00 80.74           C  
ATOM   1702  CG  LEU A 234       8.628   8.075  -3.832  1.00 81.52           C  
ATOM   1703  CD1 LEU A 234       8.564   7.889  -5.335  1.00 83.69           C  
ATOM   1704  CD2 LEU A 234       7.459   7.427  -3.082  1.00 77.36           C  
ATOM   1705  N   PRO A 235      11.211   5.358  -1.118  1.00 80.00           N  
ATOM   1706  CA  PRO A 235      12.166   4.275  -1.016  1.00 80.54           C  
ATOM   1707  C   PRO A 235      12.870   4.086  -2.358  1.00 80.41           C  
ATOM   1708  O   PRO A 235      12.319   4.484  -3.375  1.00 80.42           O  
ATOM   1709  CB  PRO A 235      11.245   3.064  -0.775  1.00 81.35           C  
ATOM   1710  CG  PRO A 235      10.167   3.625   0.064  1.00 81.60           C  
ATOM   1711  CD  PRO A 235       9.882   4.952  -0.643  1.00 80.12           C  
ATOM   1712  N   CYS A 236      14.046   3.465  -2.380  1.00 79.91           N  
ATOM   1713  CA  CYS A 236      14.642   3.104  -3.648  1.00 80.02           C  
ATOM   1714  C   CYS A 236      14.584   1.607  -3.779  1.00 80.61           C  
ATOM   1715  O   CYS A 236      14.810   0.894  -2.787  1.00 81.43           O  
ATOM   1716  CB  CYS A 236      16.062   3.615  -3.736  1.00 80.33           C  
ATOM   1717  SG  CYS A 236      16.163   5.434  -3.482  1.00 81.00           S  
ATOM   1718  N   GLU A 237      14.250   1.138  -4.995  1.00 80.30           N  
ATOM   1719  CA  GLU A 237      13.971  -0.274  -5.302  1.00 79.23           C  
ATOM   1720  C   GLU A 237      14.874  -0.812  -6.416  1.00 79.54           C  
ATOM   1721  O   GLU A 237      15.148  -0.114  -7.414  1.00 80.06           O  
ATOM   1722  CB  GLU A 237      12.530  -0.440  -5.770  1.00 78.37           C  
ATOM   1723  CG  GLU A 237      11.460  -0.251  -4.688  1.00 78.60           C  
ATOM   1724  CD  GLU A 237      10.031  -0.269  -5.248  1.00 81.03           C  
ATOM   1725  OE1 GLU A 237       9.836   0.201  -6.403  1.00 85.50           O  
ATOM   1726  OE2 GLU A 237       9.093  -0.722  -4.543  1.00 80.76           O  
ATOM   1727  N   ILE A 238      15.320  -2.064  -6.245  1.00 78.59           N  
ATOM   1728  CA  ILE A 238      15.921  -2.865  -7.309  1.00 76.86           C  
ATOM   1729  C   ILE A 238      15.044  -4.119  -7.512  1.00 77.99           C  
ATOM   1730  O   ILE A 238      14.886  -4.972  -6.598  1.00 78.84           O  
ATOM   1731  CB  ILE A 238      17.367  -3.216  -6.929  1.00 76.95           C  
ATOM   1732  CG1 ILE A 238      18.015  -1.934  -6.345  1.00 76.44           C  
ATOM   1733  CG2 ILE A 238      18.140  -3.812  -8.110  1.00 71.96           C  
ATOM   1734  CD1 ILE A 238      19.367  -2.102  -5.669  1.00 74.69           C  
ATOM   1735  N   TYR A 239      14.460  -4.234  -8.703  1.00 77.30           N  
ATOM   1736  CA  TYR A 239      13.694  -5.392  -9.051  1.00 76.59           C  
ATOM   1737  C   TYR A 239      14.645  -6.464  -9.521  1.00 76.96           C  
ATOM   1738  O   TYR A 239      15.617  -6.155 -10.210  1.00 77.50           O  
ATOM   1739  CB  TYR A 239      12.751  -5.016 -10.158  1.00 76.21           C  
ATOM   1740  CG  TYR A 239      12.129  -3.680  -9.857  1.00 78.22           C  
ATOM   1741  CD1 TYR A 239      11.286  -3.536  -8.742  1.00 75.19           C  
ATOM   1742  CD2 TYR A 239      12.419  -2.531 -10.634  1.00 76.96           C  
ATOM   1743  CE1 TYR A 239      10.740  -2.342  -8.437  1.00 74.89           C  
ATOM   1744  CE2 TYR A 239      11.856  -1.292 -10.297  1.00 75.73           C  
ATOM   1745  CZ  TYR A 239      11.002  -1.235  -9.207  1.00 74.75           C  
ATOM   1746  OH  TYR A 239      10.409  -0.071  -8.816  1.00 76.41           O  
ATOM   1747  N   THR A 240      14.371  -7.713  -9.129  1.00 76.18           N  
ATOM   1748  CA  THR A 240      15.099  -8.914  -9.585  1.00 75.20           C  
ATOM   1749  C   THR A 240      14.013  -9.949  -9.995  1.00 75.16           C  
ATOM   1750  O   THR A 240      12.816  -9.782  -9.672  1.00 75.06           O  
ATOM   1751  CB  THR A 240      15.966  -9.551  -8.466  1.00 74.70           C  
ATOM   1752  OG1 THR A 240      15.121 -10.316  -7.603  1.00 74.60           O  
ATOM   1753  CG2 THR A 240      16.714  -8.525  -7.617  1.00 73.92           C  
ATOM   1754  N   THR A 241      14.407 -10.994 -10.711  1.00 73.92           N  
ATOM   1755  CA  THR A 241      13.428 -11.950 -11.221  1.00 73.98           C  
ATOM   1756  C   THR A 241      12.622 -12.585 -10.087  1.00 74.86           C  
ATOM   1757  O   THR A 241      11.487 -12.991 -10.289  1.00 74.15           O  
ATOM   1758  CB  THR A 241      14.068 -13.037 -12.101  1.00 73.57           C  
ATOM   1759  OG1 THR A 241      15.173 -13.653 -11.412  1.00 72.21           O  
ATOM   1760  CG2 THR A 241      14.546 -12.428 -13.374  1.00 72.50           C  
ATOM   1761  N   ASP A 242      13.205 -12.627  -8.889  1.00 76.14           N  
ATOM   1762  CA  ASP A 242      12.552 -13.210  -7.722  1.00 76.79           C  
ATOM   1763  C   ASP A 242      12.001 -12.212  -6.708  1.00 76.88           C  
ATOM   1764  O   ASP A 242      11.453 -12.628  -5.691  1.00 77.04           O  
ATOM   1765  CB  ASP A 242      13.499 -14.161  -7.023  1.00 76.93           C  
ATOM   1766  CG  ASP A 242      14.820 -13.539  -6.744  1.00 79.36           C  
ATOM   1767  OD1 ASP A 242      15.300 -12.761  -7.593  1.00 80.98           O  
ATOM   1768  OD2 ASP A 242      15.396 -13.836  -5.680  1.00 83.48           O  
ATOM   1769  N   GLY A 243      12.138 -10.909  -6.974  1.00 77.13           N  
ATOM   1770  CA  GLY A 243      11.522  -9.889  -6.114  1.00 76.80           C  
ATOM   1771  C   GLY A 243      12.127  -8.497  -6.137  1.00 77.44           C  
ATOM   1772  O   GLY A 243      12.844  -8.113  -7.082  1.00 77.03           O  
ATOM   1773  N   THR A 244      11.835  -7.740  -5.075  1.00 77.32           N  
ATOM   1774  CA  THR A 244      12.187  -6.345  -5.009  1.00 77.01           C  
ATOM   1775  C   THR A 244      13.065  -6.060  -3.794  1.00 76.73           C  
ATOM   1776  O   THR A 244      12.633  -6.202  -2.645  1.00 77.10           O  
ATOM   1777  CB  THR A 244      10.929  -5.470  -4.917  1.00 76.99           C  
ATOM   1778  OG1 THR A 244       9.956  -5.911  -5.858  1.00 77.61           O  
ATOM   1779  CG2 THR A 244      11.270  -3.992  -5.183  1.00 78.05           C  
ATOM   1780  N   LEU A 245      14.294  -5.638  -4.035  1.00 75.97           N  
ATOM   1781  CA  LEU A 245      15.100  -5.170  -2.923  1.00 75.97           C  
ATOM   1782  C   LEU A 245      14.694  -3.721  -2.601  1.00 77.11           C  
ATOM   1783  O   LEU A 245      14.594  -2.880  -3.510  1.00 77.94           O  
ATOM   1784  CB  LEU A 245      16.581  -5.285  -3.253  1.00 75.39           C  
ATOM   1785  CG  LEU A 245      17.561  -4.796  -2.187  1.00 74.54           C  
ATOM   1786  CD1 LEU A 245      17.478  -5.600  -0.894  1.00 71.34           C  
ATOM   1787  CD2 LEU A 245      18.982  -4.780  -2.735  1.00 74.09           C  
ATOM   1788  N   THR A 246      14.429  -3.430  -1.326  1.00 77.68           N  
ATOM   1789  CA  THR A 246      14.001  -2.089  -0.910  1.00 78.09           C  
ATOM   1790  C   THR A 246      15.043  -1.382  -0.030  1.00 78.07           C  
ATOM   1791  O   THR A 246      15.326  -1.847   1.094  1.00 78.31           O  
ATOM   1792  CB  THR A 246      12.554  -2.083  -0.317  1.00 78.63           C  
ATOM   1793  OG1 THR A 246      11.649  -2.548  -1.337  1.00 80.42           O  
ATOM   1794  CG2 THR A 246      12.101  -0.628   0.104  1.00 77.62           C  
ATOM   1795  N   LEU A 247      15.625  -0.292  -0.549  1.00 77.15           N  
ATOM   1796  CA  LEU A 247      16.555   0.544   0.248  1.00 77.58           C  
ATOM   1797  C   LEU A 247      15.844   1.799   0.654  1.00 77.48           C  
ATOM   1798  O   LEU A 247      15.265   2.464  -0.202  1.00 78.94           O  
ATOM   1799  CB  LEU A 247      17.787   0.983  -0.542  1.00 76.39           C  
ATOM   1800  CG  LEU A 247      18.450  -0.022  -1.451  1.00 76.45           C  
ATOM   1801  CD1 LEU A 247      19.363   0.731  -2.391  1.00 76.54           C  
ATOM   1802  CD2 LEU A 247      19.215  -1.006  -0.610  1.00 74.91           C  
ATOM   1803  N   ASN A 248      15.900   2.153   1.929  1.00 77.05           N  
ATOM   1804  CA  ASN A 248      15.202   3.338   2.384  1.00 76.66           C  
ATOM   1805  C   ASN A 248      15.643   4.600   1.612  1.00 77.11           C  
ATOM   1806  O   ASN A 248      14.811   5.497   1.335  1.00 76.05           O  
ATOM   1807  CB  ASN A 248      15.359   3.506   3.886  1.00 76.82           C  
ATOM   1808  CG  ASN A 248      16.682   4.141   4.275  1.00 77.33           C  
ATOM   1809  OD1 ASN A 248      17.752   3.625   3.958  1.00 78.01           O  
ATOM   1810  ND2 ASN A 248      16.613   5.244   4.992  1.00 76.11           N  
ATOM   1811  N   THR A 249      16.935   4.668   1.263  1.00 76.93           N  
ATOM   1812  CA  THR A 249      17.450   5.759   0.417  1.00 77.78           C  
ATOM   1813  C   THR A 249      18.620   5.195  -0.346  1.00 78.59           C  
ATOM   1814  O   THR A 249      18.997   4.070  -0.095  1.00 79.93           O  
ATOM   1815  CB  THR A 249      18.032   6.974   1.237  1.00 77.54           C  
ATOM   1816  OG1 THR A 249      19.145   6.536   2.032  1.00 77.25           O  
ATOM   1817  CG2 THR A 249      16.994   7.652   2.106  1.00 75.52           C  
ATOM   1818  N   ILE A 250      19.238   5.979  -1.226  1.00 79.01           N  
ATOM   1819  CA  ILE A 250      20.523   5.572  -1.805  1.00 78.58           C  
ATOM   1820  C   ILE A 250      21.737   6.388  -1.336  1.00 77.66           C  
ATOM   1821  O   ILE A 250      22.782   6.382  -1.986  1.00 77.15           O  
ATOM   1822  CB  ILE A 250      20.462   5.520  -3.340  1.00 78.77           C  
ATOM   1823  CG1 ILE A 250      19.763   6.738  -3.901  1.00 79.12           C  
ATOM   1824  CG2 ILE A 250      19.693   4.282  -3.760  1.00 80.92           C  
ATOM   1825  CD1 ILE A 250      20.632   7.955  -3.969  1.00 84.56           C  
ATOM   1826  N   GLU A 251      21.594   7.084  -0.211  1.00 76.96           N  
ATOM   1827  CA  GLU A 251      22.703   7.831   0.389  1.00 76.37           C  
ATOM   1828  C   GLU A 251      22.589   7.711   1.890  1.00 76.03           C  
ATOM   1829  O   GLU A 251      21.490   7.591   2.393  1.00 75.70           O  
ATOM   1830  CB  GLU A 251      22.687   9.277  -0.067  1.00 75.73           C  
ATOM   1831  CG  GLU A 251      21.366  10.023   0.140  1.00 76.70           C  
ATOM   1832  CD  GLU A 251      21.196  10.496   1.566  1.00 77.62           C  
ATOM   1833  OE1 GLU A 251      20.076  10.388   2.071  1.00 78.71           O  
ATOM   1834  OE2 GLU A 251      22.187  10.926   2.208  1.00 78.09           O  
ATOM   1835  N   HIS A 252      23.708   7.690   2.605  1.00 76.29           N  
ATOM   1836  CA  HIS A 252      23.673   7.417   4.048  1.00 77.00           C  
ATOM   1837  C   HIS A 252      22.711   6.268   4.375  1.00 78.22           C  
ATOM   1838  O   HIS A 252      21.924   6.356   5.320  1.00 78.50           O  
ATOM   1839  CB  HIS A 252      23.221   8.684   4.804  1.00 77.18           C  
ATOM   1840  CG  HIS A 252      23.620   8.710   6.243  1.00 73.58           C  
ATOM   1841  ND1 HIS A 252      24.690   7.985   6.732  1.00 71.96           N  
ATOM   1842  CD2 HIS A 252      23.111   9.391   7.293  1.00 70.86           C  
ATOM   1843  CE1 HIS A 252      24.831   8.219   8.024  1.00 70.37           C  
ATOM   1844  NE2 HIS A 252      23.893   9.079   8.387  1.00 71.34           N  
ATOM   1845  N   ILE A 253      22.780   5.198   3.582  1.00 79.28           N  
ATOM   1846  CA  ILE A 253      21.772   4.157   3.566  1.00 79.84           C  
ATOM   1847  C   ILE A 253      21.587   3.545   4.949  1.00 81.26           C  
ATOM   1848  O   ILE A 253      22.575   3.317   5.677  1.00 81.03           O  
ATOM   1849  CB  ILE A 253      22.108   3.054   2.515  1.00 80.26           C  
ATOM   1850  CG1 ILE A 253      22.367   3.714   1.158  1.00 80.83           C  
ATOM   1851  CG2 ILE A 253      20.990   1.980   2.422  1.00 77.48           C  
ATOM   1852  CD1 ILE A 253      23.039   2.822   0.112  1.00 79.98           C  
ATOM   1853  N   ARG A 254      20.311   3.281   5.278  1.00 82.21           N  
ATOM   1854  CA  ARG A 254      19.899   2.843   6.609  1.00 82.99           C  
ATOM   1855  C   ARG A 254      19.312   1.414   6.629  1.00 83.01           C  
ATOM   1856  O   ARG A 254      19.591   0.676   7.566  1.00 83.50           O  
ATOM   1857  CB  ARG A 254      18.955   3.873   7.288  1.00 82.33           C  
ATOM   1858  CG  ARG A 254      18.929   3.783   8.846  1.00 82.35           C  
ATOM   1859  CD  ARG A 254      17.624   4.304   9.505  1.00 83.23           C  
ATOM   1860  NE  ARG A 254      16.459   3.769   8.798  1.00 88.32           N  
ATOM   1861  CZ  ARG A 254      15.554   4.500   8.142  1.00 89.79           C  
ATOM   1862  NH1 ARG A 254      15.615   5.831   8.171  1.00 90.60           N  
ATOM   1863  NH2 ARG A 254      14.566   3.898   7.479  1.00 88.68           N  
ATOM   1864  N   SER A 255      18.533   1.021   5.616  1.00 83.12           N  
ATOM   1865  CA  SER A 255      17.839  -0.291   5.648  1.00 83.39           C  
ATOM   1866  C   SER A 255      17.568  -0.979   4.305  1.00 83.87           C  
ATOM   1867  O   SER A 255      16.815  -0.466   3.466  1.00 85.19           O  
ATOM   1868  CB  SER A 255      16.531  -0.187   6.411  1.00 82.71           C  
ATOM   1869  OG  SER A 255      15.725   0.796   5.825  1.00 84.18           O  
ATOM   1870  N   ALA A 256      18.181  -2.141   4.101  1.00 83.91           N  
ATOM   1871  CA  ALA A 256      17.956  -2.900   2.869  1.00 84.28           C  
ATOM   1872  C   ALA A 256      17.164  -4.158   3.140  1.00 84.28           C  
ATOM   1873  O   ALA A 256      17.687  -5.144   3.700  1.00 84.47           O  
ATOM   1874  CB  ALA A 256      19.284  -3.261   2.179  1.00 84.60           C  
ATOM   1875  N   ILE A 257      15.903  -4.151   2.749  1.00 83.64           N  
ATOM   1876  CA  ILE A 257      15.160  -5.374   2.926  1.00 83.36           C  
ATOM   1877  C   ILE A 257      14.636  -5.966   1.620  1.00 82.69           C  
ATOM   1878  O   ILE A 257      14.007  -5.297   0.823  1.00 82.66           O  
ATOM   1879  CB  ILE A 257      14.141  -5.340   4.148  1.00 83.41           C  
ATOM   1880  CG1 ILE A 257      12.811  -5.984   3.782  1.00 84.66           C  
ATOM   1881  CG2 ILE A 257      13.897  -3.947   4.708  1.00 83.90           C  
ATOM   1882  CD1 ILE A 257      12.874  -7.469   3.748  1.00 81.88           C  
ATOM   1883  N   PHE A 258      14.937  -7.234   1.388  1.00 82.11           N  
ATOM   1884  CA  PHE A 258      14.527  -7.834   0.127  1.00 81.35           C  
ATOM   1885  C   PHE A 258      13.241  -8.572   0.354  1.00 80.91           C  
ATOM   1886  O   PHE A 258      13.089  -9.218   1.367  1.00 80.84           O  
ATOM   1887  CB  PHE A 258      15.611  -8.763  -0.440  1.00 80.42           C  
ATOM   1888  CG  PHE A 258      15.199  -9.481  -1.702  1.00 79.93           C  
ATOM   1889  CD1 PHE A 258      15.303  -8.867  -2.934  1.00 78.76           C  
ATOM   1890  CD2 PHE A 258      14.712 -10.784  -1.654  1.00 80.50           C  
ATOM   1891  CE1 PHE A 258      14.906  -9.524  -4.099  1.00 77.85           C  
ATOM   1892  CE2 PHE A 258      14.337 -11.463  -2.822  1.00 80.26           C  
ATOM   1893  CZ  PHE A 258      14.432 -10.835  -4.032  1.00 80.51           C  
ATOM   1894  N   THR A 259      12.312  -8.471  -0.585  1.00 80.80           N  
ATOM   1895  CA  THR A 259      11.086  -9.238  -0.489  1.00 80.67           C  
ATOM   1896  C   THR A 259      10.721  -9.987  -1.804  1.00 81.59           C  
ATOM   1897  O   THR A 259      10.585  -9.366  -2.878  1.00 82.41           O  
ATOM   1898  CB  THR A 259       9.908  -8.443   0.223  1.00 80.31           C  
ATOM   1899  OG1 THR A 259       8.656  -8.764  -0.374  1.00 79.95           O  
ATOM   1900  CG2 THR A 259      10.076  -6.921   0.202  1.00 79.68           C  
ATOM   1901  N   ASP A 260      10.594 -11.320  -1.712  1.00 81.51           N  
ATOM   1902  CA  ASP A 260      10.284 -12.178  -2.878  1.00 81.86           C  
ATOM   1903  C   ASP A 260       8.812 -12.140  -3.273  1.00 81.79           C  
ATOM   1904  O   ASP A 260       7.992 -11.661  -2.495  1.00 81.70           O  
ATOM   1905  CB  ASP A 260      10.791 -13.649  -2.694  1.00 81.62           C  
ATOM   1906  CG  ASP A 260      10.119 -14.406  -1.532  1.00 81.30           C  
ATOM   1907  OD1 ASP A 260       8.909 -14.247  -1.271  1.00 80.43           O  
ATOM   1908  OD2 ASP A 260      10.824 -15.206  -0.885  1.00 82.18           O  
ATOM   1909  N   HIS A 261       8.483 -12.659  -4.459  1.00 81.90           N  
ATOM   1910  CA  HIS A 261       7.077 -12.695  -4.934  1.00 82.88           C  
ATOM   1911  C   HIS A 261       6.097 -13.395  -3.991  1.00 82.94           C  
ATOM   1912  O   HIS A 261       4.889 -13.319  -4.192  1.00 82.79           O  
ATOM   1913  CB  HIS A 261       6.954 -13.299  -6.344  1.00 82.74           C  
ATOM   1914  CG  HIS A 261       7.911 -12.713  -7.329  1.00 84.58           C  
ATOM   1915  ND1 HIS A 261       8.068 -11.349  -7.499  1.00 86.50           N  
ATOM   1916  CD2 HIS A 261       8.775 -13.299  -8.187  1.00 85.01           C  
ATOM   1917  CE1 HIS A 261       8.993 -11.121  -8.413  1.00 85.98           C  
ATOM   1918  NE2 HIS A 261       9.440 -12.288  -8.845  1.00 87.33           N  
ATOM   1919  N   GLN A 262       6.618 -14.051  -2.958  1.00 83.50           N  
ATOM   1920  CA  GLN A 262       5.787 -14.781  -1.989  1.00 84.14           C  
ATOM   1921  C   GLN A 262       5.605 -14.030  -0.678  1.00 84.16           C  
ATOM   1922  O   GLN A 262       4.888 -14.504   0.203  1.00 84.06           O  
ATOM   1923  CB  GLN A 262       6.377 -16.173  -1.706  1.00 84.17           C  
ATOM   1924  CG  GLN A 262       5.794 -17.298  -2.551  1.00 85.22           C  
ATOM   1925  CD  GLN A 262       5.930 -17.083  -4.069  1.00 86.81           C  
ATOM   1926  OE1 GLN A 262       7.042 -17.137  -4.632  1.00 85.49           O  
ATOM   1927  NE2 GLN A 262       4.784 -16.872  -4.740  1.00 86.07           N  
ATOM   1928  N   GLY A 263       6.260 -12.873  -0.556  1.00 84.35           N  
ATOM   1929  CA  GLY A 263       6.285 -12.104   0.688  1.00 84.73           C  
ATOM   1930  C   GLY A 263       7.208 -12.605   1.806  1.00 85.51           C  
ATOM   1931  O   GLY A 263       6.991 -12.260   2.966  1.00 85.82           O  
ATOM   1932  N   ASN A 264       8.211 -13.433   1.483  1.00 85.75           N  
ATOM   1933  CA  ASN A 264       9.308 -13.735   2.405  1.00 85.67           C  
ATOM   1934  C   ASN A 264      10.294 -12.595   2.360  1.00 85.39           C  
ATOM   1935  O   ASN A 264      10.514 -12.016   1.299  1.00 86.04           O  
ATOM   1936  CB  ASN A 264      10.082 -14.965   1.963  1.00 86.46           C  
ATOM   1937  CG  ASN A 264       9.339 -16.237   2.199  1.00 87.36           C  
ATOM   1938  OD1 ASN A 264       9.020 -16.587   3.341  1.00 88.76           O  
ATOM   1939  ND2 ASN A 264       9.075 -16.964   1.117  1.00 87.91           N  
ATOM   1940  N   GLN A 265      10.923 -12.297   3.491  1.00 84.57           N  
ATOM   1941  CA  GLN A 265      11.770 -11.127   3.578  1.00 83.42           C  
ATOM   1942  C   GLN A 265      13.126 -11.426   4.155  1.00 83.40           C  
ATOM   1943  O   GLN A 265      13.270 -12.292   5.023  1.00 83.85           O  
ATOM   1944  CB  GLN A 265      11.094 -10.089   4.448  1.00 83.19           C  
ATOM   1945  CG  GLN A 265       9.766  -9.627   3.935  1.00 83.10           C  
ATOM   1946  CD  GLN A 265       9.346  -8.327   4.584  1.00 83.53           C  
ATOM   1947  OE1 GLN A 265       9.338  -8.222   5.804  1.00 84.38           O  
ATOM   1948  NE2 GLN A 265       8.990  -7.331   3.770  1.00 81.61           N  
ATOM   1949  N   VAL A 266      14.122 -10.694   3.684  1.00 83.37           N  
ATOM   1950  CA  VAL A 266      15.458 -10.712   4.274  1.00 83.88           C  
ATOM   1951  C   VAL A 266      15.963  -9.283   4.585  1.00 84.09           C  
ATOM   1952  O   VAL A 266      16.170  -8.493   3.670  1.00 84.11           O  
ATOM   1953  CB  VAL A 266      16.455 -11.418   3.330  1.00 83.77           C  
ATOM   1954  CG1 VAL A 266      17.845 -11.447   3.942  1.00 83.75           C  
ATOM   1955  CG2 VAL A 266      15.979 -12.854   2.996  1.00 84.22           C  
ATOM   1956  N   GLN A 267      16.130  -8.940   5.865  1.00 84.49           N  
ATOM   1957  CA  GLN A 267      16.948  -7.777   6.223  1.00 85.33           C  
ATOM   1958  C   GLN A 267      18.373  -8.053   5.805  1.00 85.18           C  
ATOM   1959  O   GLN A 267      18.886  -9.139   6.057  1.00 85.38           O  
ATOM   1960  CB  GLN A 267      16.981  -7.539   7.736  1.00 85.79           C  
ATOM   1961  CG  GLN A 267      16.161  -6.352   8.242  1.00 87.49           C  
ATOM   1962  CD  GLN A 267      14.818  -6.790   8.823  1.00 88.80           C  
ATOM   1963  OE1 GLN A 267      14.735  -7.741   9.638  1.00 88.29           O  
ATOM   1964  NE2 GLN A 267      13.758  -6.101   8.407  1.00 86.64           N  
ATOM   1965  N   LEU A 268      19.017  -7.081   5.185  1.00 85.07           N  
ATOM   1966  CA  LEU A 268      20.452  -7.163   4.955  1.00 85.63           C  
ATOM   1967  C   LEU A 268      21.214  -6.470   6.118  1.00 86.11           C  
ATOM   1968  O   LEU A 268      20.699  -5.540   6.725  1.00 86.86           O  
ATOM   1969  CB  LEU A 268      20.799  -6.559   3.597  1.00 85.45           C  
ATOM   1970  CG  LEU A 268      20.531  -7.433   2.367  1.00 85.40           C  
ATOM   1971  CD1 LEU A 268      19.056  -7.651   2.130  1.00 84.81           C  
ATOM   1972  CD2 LEU A 268      21.167  -6.841   1.118  1.00 85.58           C  
ATOM   1973  N   PRO A 269      22.415  -6.959   6.474  1.00 86.29           N  
ATOM   1974  CA  PRO A 269      23.202  -6.269   7.524  1.00 85.88           C  
ATOM   1975  C   PRO A 269      23.687  -4.889   7.074  1.00 85.70           C  
ATOM   1976  O   PRO A 269      24.760  -4.777   6.468  1.00 85.70           O  
ATOM   1977  CB  PRO A 269      24.413  -7.190   7.726  1.00 85.93           C  
ATOM   1978  CG  PRO A 269      24.519  -7.987   6.439  1.00 86.47           C  
ATOM   1979  CD  PRO A 269      23.091  -8.172   5.961  1.00 86.08           C  
ATOM   1980  N   ILE A 270      22.885  -3.861   7.358  1.00 84.85           N  
ATOM   1981  CA  ILE A 270      23.242  -2.493   7.051  1.00 84.03           C  
ATOM   1982  C   ILE A 270      23.486  -1.735   8.338  1.00 83.55           C  
ATOM   1983  O   ILE A 270      22.628  -1.734   9.212  1.00 84.13           O  
ATOM   1984  CB  ILE A 270      22.106  -1.763   6.326  1.00 84.26           C  
ATOM   1985  CG1 ILE A 270      21.793  -2.405   4.956  1.00 83.38           C  
ATOM   1986  CG2 ILE A 270      22.423  -0.241   6.239  1.00 84.49           C  
ATOM   1987  CD1 ILE A 270      22.977  -2.602   4.043  1.00 82.05           C  
ATOM   1988  N   GLN A 271      24.643  -1.103   8.471  1.00 82.05           N  
ATOM   1989  CA  GLN A 271      24.823  -0.232   9.606  1.00 81.65           C  
ATOM   1990  C   GLN A 271      25.339   1.138   9.173  1.00 80.47           C  
ATOM   1991  O   GLN A 271      26.505   1.324   8.789  1.00 79.37           O  
ATOM   1992  CB  GLN A 271      25.672  -0.854  10.712  1.00 82.06           C  
ATOM   1993  CG  GLN A 271      24.944  -0.954  12.109  1.00 86.05           C  
ATOM   1994  CD  GLN A 271      24.487   0.408  12.776  1.00 89.49           C  
ATOM   1995  OE1 GLN A 271      24.670   0.606  13.992  1.00 90.37           O  
ATOM   1996  NE2 GLN A 271      23.876   1.303  11.993  1.00 88.68           N  
ATOM   1997  N   GLN A 272      24.424   2.096   9.224  1.00 79.40           N  
ATOM   1998  CA  GLN A 272      24.740   3.442   8.827  1.00 78.34           C  
ATOM   1999  C   GLN A 272      25.826   4.068   9.734  1.00 78.02           C  
ATOM   2000  O   GLN A 272      25.796   3.939  10.967  1.00 78.06           O  
ATOM   2001  CB  GLN A 272      23.466   4.281   8.623  1.00 78.22           C  
ATOM   2002  CG  GLN A 272      22.793   4.858   9.836  1.00 77.71           C  
ATOM   2003  CD  GLN A 272      21.681   5.842   9.472  1.00 77.83           C  
ATOM   2004  OE1 GLN A 272      21.689   6.484   8.400  1.00 74.39           O  
ATOM   2005  NE2 GLN A 272      20.717   5.969  10.373  1.00 77.22           N  
ATOM   2006  N   ALA A 273      26.818   4.680   9.098  1.00 77.35           N  
ATOM   2007  CA  ALA A 273      27.884   5.344   9.811  1.00 76.56           C  
ATOM   2008  C   ALA A 273      27.349   6.446  10.761  1.00 76.49           C  
ATOM   2009  O   ALA A 273      26.189   6.883  10.655  1.00 75.74           O  
ATOM   2010  CB  ALA A 273      28.895   5.870   8.831  1.00 75.86           C  
ATOM   2011  N   PRO A 274      28.166   6.847  11.746  1.00 76.96           N  
ATOM   2012  CA  PRO A 274      27.674   7.966  12.559  1.00 77.97           C  
ATOM   2013  C   PRO A 274      27.574   9.327  11.821  1.00 78.39           C  
ATOM   2014  O   PRO A 274      27.004  10.252  12.360  1.00 79.08           O  
ATOM   2015  CB  PRO A 274      28.682   8.030  13.731  1.00 78.00           C  
ATOM   2016  CG  PRO A 274      29.930   7.365  13.210  1.00 77.59           C  
ATOM   2017  CD  PRO A 274      29.478   6.339  12.197  1.00 76.66           C  
ATOM   2018  N   HIS A 275      28.106   9.420  10.607  1.00 78.78           N  
ATOM   2019  CA  HIS A 275      28.218  10.655   9.861  1.00 79.21           C  
ATOM   2020  C   HIS A 275      28.226  10.286   8.375  1.00 80.66           C  
ATOM   2021  O   HIS A 275      28.820   9.275   7.974  1.00 80.04           O  
ATOM   2022  CB  HIS A 275      29.539  11.330  10.276  1.00 79.01           C  
ATOM   2023  CG  HIS A 275      29.829  12.644   9.601  1.00 77.39           C  
ATOM   2024  ND1 HIS A 275      30.009  13.817  10.309  1.00 75.85           N  
ATOM   2025  CD2 HIS A 275      30.030  12.960   8.301  1.00 73.69           C  
ATOM   2026  CE1 HIS A 275      30.291  14.798   9.474  1.00 72.97           C  
ATOM   2027  NE2 HIS A 275      30.298  14.305   8.248  1.00 73.94           N  
ATOM   2028  N   THR A 276      27.576  11.109   7.550  1.00 82.71           N  
ATOM   2029  CA  THR A 276      27.470  10.836   6.102  1.00 84.79           C  
ATOM   2030  C   THR A 276      28.820  10.748   5.375  1.00 86.29           C  
ATOM   2031  O   THR A 276      28.886  10.290   4.235  1.00 86.47           O  
ATOM   2032  CB  THR A 276      26.652  11.886   5.398  1.00 84.14           C  
ATOM   2033  OG1 THR A 276      27.240  13.152   5.686  1.00 87.15           O  
ATOM   2034  CG2 THR A 276      25.262  11.897   5.912  1.00 83.47           C  
HETATM 2035  N   MSE A 277      29.892  11.183   6.029  1.00 87.94           N  
HETATM 2036  CA  MSE A 277      31.201  11.167   5.418  1.00 90.51           C  
HETATM 2037  C   MSE A 277      32.216  10.266   6.128  1.00 88.85           C  
HETATM 2038  O   MSE A 277      33.365  10.147   5.668  1.00 89.70           O  
HETATM 2039  CB  MSE A 277      31.689  12.591   5.278  1.00 89.21           C  
HETATM 2040  CG  MSE A 277      30.799  13.419   4.336  1.00 92.38           C  
HETATM 2041 SE   MSE A 277      31.175  15.362   4.343  1.00101.97          SE  
HETATM 2042  CE  MSE A 277      32.968  15.216   3.611  1.00100.56           C  
ATOM   2043  N   THR A 278      31.812   9.618   7.228  1.00 87.02           N  
ATOM   2044  CA  THR A 278      32.683   8.659   7.877  1.00 85.98           C  
ATOM   2045  C   THR A 278      33.402   7.724   6.862  1.00 85.78           C  
ATOM   2046  O   THR A 278      34.632   7.542   6.923  1.00 85.74           O  
ATOM   2047  CB  THR A 278      31.917   7.750   8.948  1.00 86.37           C  
ATOM   2048  OG1 THR A 278      31.080   8.542   9.816  1.00 84.88           O  
ATOM   2049  CG2 THR A 278      32.896   6.943   9.754  1.00 82.77           C  
ATOM   2050  N   GLU A 279      32.630   7.155   5.937  1.00 84.69           N  
ATOM   2051  CA  GLU A 279      33.133   6.094   5.079  1.00 84.57           C  
ATOM   2052  C   GLU A 279      34.040   6.551   3.943  1.00 83.96           C  
ATOM   2053  O   GLU A 279      35.076   5.932   3.687  1.00 85.00           O  
ATOM   2054  CB  GLU A 279      31.991   5.205   4.575  1.00 84.85           C  
ATOM   2055  CG  GLU A 279      31.446   4.257   5.654  1.00 85.78           C  
ATOM   2056  CD  GLU A 279      29.971   3.939   5.456  1.00 89.53           C  
ATOM   2057  OE1 GLU A 279      29.148   4.898   5.317  1.00 87.10           O  
ATOM   2058  OE2 GLU A 279      29.643   2.708   5.426  1.00 91.79           O  
ATOM   2059  N   GLU A 280      33.706   7.637   3.275  1.00 82.82           N  
ATOM   2060  CA  GLU A 280      34.603   8.107   2.238  1.00 82.30           C  
ATOM   2061  C   GLU A 280      35.870   8.669   2.867  1.00 81.56           C  
ATOM   2062  O   GLU A 280      36.944   8.592   2.271  1.00 82.08           O  
ATOM   2063  CB  GLU A 280      33.917   9.135   1.359  1.00 82.80           C  
ATOM   2064  CG  GLU A 280      33.937  10.537   1.979  1.00 85.67           C  
ATOM   2065  CD  GLU A 280      33.171  11.566   1.205  1.00 87.32           C  
ATOM   2066  OE1 GLU A 280      32.849  11.331   0.003  1.00 85.18           O  
ATOM   2067  OE2 GLU A 280      32.907  12.619   1.832  1.00 89.72           O  
ATOM   2068  N   VAL A 281      35.756   9.195   4.083  1.00 80.12           N  
ATOM   2069  CA  VAL A 281      36.889   9.846   4.712  1.00 79.57           C  
ATOM   2070  C   VAL A 281      37.937   8.825   5.114  1.00 79.77           C  
ATOM   2071  O   VAL A 281      39.154   9.090   5.002  1.00 80.41           O  
ATOM   2072  CB  VAL A 281      36.467  10.744   5.940  1.00 79.37           C  
ATOM   2073  CG1 VAL A 281      37.600  10.871   6.910  1.00 78.37           C  
ATOM   2074  CG2 VAL A 281      35.981  12.159   5.495  1.00 78.89           C  
ATOM   2075  N   ALA A 282      37.478   7.661   5.610  1.00 79.76           N  
ATOM   2076  CA  ALA A 282      38.405   6.512   5.922  1.00 78.19           C  
ATOM   2077  C   ALA A 282      39.050   6.012   4.610  1.00 77.14           C  
ATOM   2078  O   ALA A 282      40.262   5.866   4.535  1.00 76.51           O  
ATOM   2079  CB  ALA A 282      37.669   5.367   6.648  1.00 77.61           C  
ATOM   2080  N   ALA A 283      38.228   5.852   3.567  1.00 76.27           N  
ATOM   2081  CA  ALA A 283      38.687   5.403   2.252  1.00 75.98           C  
ATOM   2082  C   ALA A 283      39.809   6.264   1.680  1.00 76.36           C  
ATOM   2083  O   ALA A 283      40.799   5.740   1.223  1.00 76.21           O  
ATOM   2084  CB  ALA A 283      37.519   5.291   1.278  1.00 74.11           C  
ATOM   2085  N   PHE A 284      39.674   7.593   1.733  1.00 78.05           N  
ATOM   2086  CA  PHE A 284      40.674   8.472   1.104  1.00 78.24           C  
ATOM   2087  C   PHE A 284      41.967   8.348   1.847  1.00 78.71           C  
ATOM   2088  O   PHE A 284      43.058   8.293   1.248  1.00 78.54           O  
ATOM   2089  CB  PHE A 284      40.191   9.929   1.039  1.00 77.95           C  
ATOM   2090  CG  PHE A 284      38.930  10.099   0.241  1.00 77.35           C  
ATOM   2091  CD1 PHE A 284      38.682   9.280  -0.867  1.00 76.90           C  
ATOM   2092  CD2 PHE A 284      37.985  11.061   0.600  1.00 74.44           C  
ATOM   2093  CE1 PHE A 284      37.502   9.420  -1.603  1.00 77.64           C  
ATOM   2094  CE2 PHE A 284      36.811  11.200  -0.096  1.00 72.69           C  
ATOM   2095  CZ  PHE A 284      36.552  10.382  -1.214  1.00 75.47           C  
ATOM   2096  N   ALA A 285      41.828   8.281   3.162  1.00 79.54           N  
ATOM   2097  CA  ALA A 285      42.976   8.165   4.042  1.00 80.81           C  
ATOM   2098  C   ALA A 285      43.693   6.822   3.896  1.00 81.41           C  
ATOM   2099  O   ALA A 285      44.932   6.781   3.718  1.00 81.48           O  
ATOM   2100  CB  ALA A 285      42.540   8.381   5.484  1.00 81.21           C  
ATOM   2101  N   HIS A 286      42.918   5.734   3.976  1.00 81.94           N  
ATOM   2102  CA  HIS A 286      43.461   4.371   3.818  1.00 82.77           C  
ATOM   2103  C   HIS A 286      44.168   4.262   2.447  1.00 82.64           C  
ATOM   2104  O   HIS A 286      45.255   3.682   2.376  1.00 82.47           O  
ATOM   2105  CB  HIS A 286      42.374   3.273   4.063  1.00 82.99           C  
ATOM   2106  CG  HIS A 286      42.838   1.874   3.802  1.00 84.98           C  
ATOM   2107  ND1 HIS A 286      43.841   1.269   4.544  1.00 86.34           N  
ATOM   2108  CD2 HIS A 286      42.447   0.960   2.880  1.00 85.16           C  
ATOM   2109  CE1 HIS A 286      44.056   0.050   4.081  1.00 85.24           C  
ATOM   2110  NE2 HIS A 286      43.225  -0.162   3.074  1.00 88.65           N  
HETATM 2111  N   MSE A 287      43.596   4.879   1.398  1.00 82.16           N  
HETATM 2112  CA  MSE A 287      44.189   4.865   0.059  1.00 82.68           C  
HETATM 2113  C   MSE A 287      45.554   5.536  -0.073  1.00 82.74           C  
HETATM 2114  O   MSE A 287      46.443   5.019  -0.725  1.00 82.55           O  
HETATM 2115  CB  MSE A 287      43.242   5.505  -0.917  1.00 83.87           C  
HETATM 2116  CG  MSE A 287      43.760   5.601  -2.358  1.00 87.34           C  
HETATM 2117 SE   MSE A 287      44.139   3.867  -3.198  1.00 93.70          SE  
HETATM 2118  CE  MSE A 287      42.310   3.150  -3.163  1.00 85.23           C  
ATOM   2119  N   ILE A 288      45.727   6.693   0.548  1.00 83.20           N  
ATOM   2120  CA  ILE A 288      47.017   7.390   0.518  1.00 82.81           C  
ATOM   2121  C   ILE A 288      48.058   6.652   1.336  1.00 83.39           C  
ATOM   2122  O   ILE A 288      49.244   6.554   0.942  1.00 83.39           O  
ATOM   2123  CB  ILE A 288      46.875   8.825   1.053  1.00 83.04           C  
ATOM   2124  CG1 ILE A 288      45.985   9.642   0.091  1.00 81.55           C  
ATOM   2125  CG2 ILE A 288      48.275   9.467   1.335  1.00 80.69           C  
ATOM   2126  CD1 ILE A 288      45.302  10.795   0.751  1.00 79.15           C  
ATOM   2127  N   GLN A 289      47.614   6.119   2.471  1.00 83.57           N  
ATOM   2128  CA  GLN A 289      48.533   5.425   3.361  1.00 83.70           C  
ATOM   2129  C   GLN A 289      48.869   3.987   2.984  1.00 83.05           C  
ATOM   2130  O   GLN A 289      50.022   3.626   3.066  1.00 83.79           O  
ATOM   2131  CB  GLN A 289      48.131   5.600   4.826  1.00 84.01           C  
ATOM   2132  CG  GLN A 289      49.006   6.685   5.538  1.00 86.13           C  
ATOM   2133  CD  GLN A 289      48.203   7.635   6.418  1.00 87.22           C  
ATOM   2134  OE1 GLN A 289      46.980   7.800   6.218  1.00 88.53           O  
ATOM   2135  NE2 GLN A 289      48.882   8.278   7.390  1.00 84.55           N  
ATOM   2136  N   GLN A 290      47.882   3.197   2.554  1.00 82.81           N  
ATOM   2137  CA  GLN A 290      48.065   1.799   2.075  1.00 82.00           C  
ATOM   2138  C   GLN A 290      47.428   1.637   0.671  1.00 81.32           C  
ATOM   2139  O   GLN A 290      46.381   0.992   0.519  1.00 80.70           O  
ATOM   2140  CB  GLN A 290      47.410   0.796   3.038  1.00 81.96           C  
ATOM   2141  CG  GLN A 290      47.470   1.173   4.506  1.00 83.23           C  
ATOM   2142  CD  GLN A 290      48.375   0.248   5.317  1.00 87.16           C  
ATOM   2143  OE1 GLN A 290      49.529   0.589   5.657  1.00 87.25           O  
ATOM   2144  NE2 GLN A 290      47.849  -0.931   5.644  1.00 88.19           N  
ATOM   2145  N   PRO A 291      48.091   2.172  -0.371  1.00 80.76           N  
ATOM   2146  CA  PRO A 291      47.449   2.368  -1.668  1.00 80.06           C  
ATOM   2147  C   PRO A 291      47.209   1.081  -2.456  1.00 80.27           C  
ATOM   2148  O   PRO A 291      48.156   0.361  -2.779  1.00 81.32           O  
ATOM   2149  CB  PRO A 291      48.423   3.286  -2.424  1.00 79.83           C  
ATOM   2150  CG  PRO A 291      49.616   3.496  -1.546  1.00 79.31           C  
ATOM   2151  CD  PRO A 291      49.522   2.531  -0.399  1.00 80.37           C  
ATOM   2152  N   ASP A 292      45.942   0.801  -2.747  1.00 80.16           N  
ATOM   2153  CA  ASP A 292      45.528  -0.243  -3.675  1.00 79.43           C  
ATOM   2154  C   ASP A 292      45.172   0.414  -5.031  1.00 78.73           C  
ATOM   2155  O   ASP A 292      44.079   0.924  -5.189  1.00 75.97           O  
ATOM   2156  CB  ASP A 292      44.327  -0.991  -3.053  1.00 79.98           C  
ATOM   2157  CG  ASP A 292      43.634  -1.949  -4.021  1.00 80.90           C  
ATOM   2158  OD1 ASP A 292      44.052  -2.067  -5.194  1.00 82.05           O  
ATOM   2159  OD2 ASP A 292      42.638  -2.572  -3.597  1.00 81.48           O  
ATOM   2160  N   LEU A 293      46.087   0.358  -6.003  1.00 78.69           N  
ATOM   2161  CA  LEU A 293      45.965   1.138  -7.259  1.00 79.24           C  
ATOM   2162  C   LEU A 293      44.917   0.690  -8.285  1.00 80.08           C  
ATOM   2163  O   LEU A 293      44.284   1.533  -8.971  1.00 79.44           O  
ATOM   2164  CB  LEU A 293      47.315   1.259  -7.937  1.00 79.01           C  
ATOM   2165  CG  LEU A 293      48.352   1.883  -6.995  1.00 79.08           C  
ATOM   2166  CD1 LEU A 293      49.763   1.786  -7.568  1.00 76.58           C  
ATOM   2167  CD2 LEU A 293      47.968   3.353  -6.602  1.00 78.64           C  
ATOM   2168  N   ASN A 294      44.734  -0.625  -8.407  1.00 80.43           N  
ATOM   2169  CA  ASN A 294      43.570  -1.141  -9.148  1.00 80.46           C  
ATOM   2170  C   ASN A 294      42.221  -0.619  -8.677  1.00 80.27           C  
ATOM   2171  O   ASN A 294      41.300  -0.412  -9.475  1.00 79.55           O  
ATOM   2172  CB  ASN A 294      43.585  -2.654  -9.131  1.00 80.02           C  
ATOM   2173  CG  ASN A 294      44.606  -3.199 -10.080  1.00 81.38           C  
ATOM   2174  OD1 ASN A 294      45.682  -3.659  -9.675  1.00 79.54           O  
ATOM   2175  ND2 ASN A 294      44.300  -3.106 -11.372  1.00 81.67           N  
ATOM   2176  N   LEU A 295      42.108  -0.454  -7.364  1.00 80.92           N  
ATOM   2177  CA  LEU A 295      40.913   0.128  -6.746  1.00 81.46           C  
ATOM   2178  C   LEU A 295      40.850   1.632  -7.020  1.00 81.39           C  
ATOM   2179  O   LEU A 295      39.783   2.208  -7.164  1.00 82.13           O  
ATOM   2180  CB  LEU A 295      40.887  -0.155  -5.232  1.00 81.17           C  
ATOM   2181  CG  LEU A 295      39.665   0.377  -4.473  1.00 81.65           C  
ATOM   2182  CD1 LEU A 295      38.362  -0.318  -4.995  1.00 79.58           C  
ATOM   2183  CD2 LEU A 295      39.834   0.249  -2.931  1.00 81.42           C  
ATOM   2184  N   TYR A 296      42.006   2.257  -7.109  1.00 81.64           N  
ATOM   2185  CA  TYR A 296      42.063   3.638  -7.463  1.00 82.39           C  
ATOM   2186  C   TYR A 296      41.549   3.823  -8.882  1.00 82.53           C  
ATOM   2187  O   TYR A 296      40.810   4.791  -9.143  1.00 82.82           O  
ATOM   2188  CB  TYR A 296      43.487   4.167  -7.281  1.00 83.06           C  
ATOM   2189  CG  TYR A 296      43.675   5.608  -7.704  1.00 84.28           C  
ATOM   2190  CD1 TYR A 296      42.841   6.627  -7.198  1.00 82.34           C  
ATOM   2191  CD2 TYR A 296      44.691   5.958  -8.613  1.00 83.49           C  
ATOM   2192  CE1 TYR A 296      43.008   7.934  -7.593  1.00 82.49           C  
ATOM   2193  CE2 TYR A 296      44.861   7.270  -9.020  1.00 83.70           C  
ATOM   2194  CZ  TYR A 296      44.011   8.250  -8.512  1.00 83.98           C  
ATOM   2195  OH  TYR A 296      44.197   9.563  -8.892  1.00 85.24           O  
ATOM   2196  N   GLN A 297      41.903   2.888  -9.774  1.00 82.68           N  
ATOM   2197  CA  GLN A 297      41.469   2.892 -11.202  1.00 82.65           C  
ATOM   2198  C   GLN A 297      39.995   2.817 -11.306  1.00 82.15           C  
ATOM   2199  O   GLN A 297      39.371   3.552 -12.094  1.00 82.62           O  
ATOM   2200  CB  GLN A 297      42.069   1.743 -12.035  1.00 83.23           C  
ATOM   2201  CG  GLN A 297      43.584   1.865 -12.297  1.00 84.60           C  
ATOM   2202  CD  GLN A 297      44.010   3.325 -12.457  1.00 87.94           C  
ATOM   2203  OE1 GLN A 297      43.287   4.158 -13.058  1.00 87.70           O  
ATOM   2204  NE2 GLN A 297      45.174   3.653 -11.899  1.00 87.24           N  
ATOM   2205  N   THR A 298      39.431   1.945 -10.488  1.00 81.19           N  
ATOM   2206  CA  THR A 298      37.989   1.803 -10.428  1.00 80.99           C  
ATOM   2207  C   THR A 298      37.323   3.117  -9.948  1.00 80.30           C  
ATOM   2208  O   THR A 298      36.271   3.503 -10.460  1.00 80.45           O  
ATOM   2209  CB  THR A 298      37.615   0.584  -9.566  1.00 80.88           C  
ATOM   2210  OG1 THR A 298      38.212  -0.575 -10.150  1.00 82.24           O  
ATOM   2211  CG2 THR A 298      36.113   0.381  -9.490  1.00 80.62           C  
ATOM   2212  N   TRP A 299      37.931   3.821  -8.998  1.00 79.39           N  
ATOM   2213  CA  TRP A 299      37.312   5.090  -8.551  1.00 79.55           C  
ATOM   2214  C   TRP A 299      37.375   6.117  -9.675  1.00 78.63           C  
ATOM   2215  O   TRP A 299      36.381   6.709 -10.013  1.00 78.20           O  
ATOM   2216  CB  TRP A 299      37.888   5.627  -7.228  1.00 78.62           C  
ATOM   2217  CG  TRP A 299      37.742   4.661  -6.047  1.00 80.09           C  
ATOM   2218  CD1 TRP A 299      37.000   3.502  -6.004  1.00 80.22           C  
ATOM   2219  CD2 TRP A 299      38.376   4.768  -4.758  1.00 80.45           C  
ATOM   2220  NE1 TRP A 299      37.131   2.891  -4.765  1.00 79.30           N  
ATOM   2221  CE2 TRP A 299      37.953   3.659  -3.982  1.00 79.54           C  
ATOM   2222  CE3 TRP A 299      39.241   5.707  -4.175  1.00 79.71           C  
ATOM   2223  CZ2 TRP A 299      38.352   3.478  -2.659  1.00 78.60           C  
ATOM   2224  CZ3 TRP A 299      39.644   5.515  -2.850  1.00 78.75           C  
ATOM   2225  CH2 TRP A 299      39.192   4.419  -2.113  1.00 78.01           C  
ATOM   2226  N   LEU A 300      38.527   6.260 -10.298  1.00 78.57           N  
ATOM   2227  CA  LEU A 300      38.621   7.113 -11.462  1.00 78.91           C  
ATOM   2228  C   LEU A 300      37.614   6.701 -12.520  1.00 80.53           C  
ATOM   2229  O   LEU A 300      36.900   7.519 -13.115  1.00 80.91           O  
ATOM   2230  CB  LEU A 300      40.014   6.997 -12.045  1.00 78.14           C  
ATOM   2231  CG  LEU A 300      41.089   7.473 -11.080  1.00 75.02           C  
ATOM   2232  CD1 LEU A 300      42.388   7.620 -11.840  1.00 67.68           C  
ATOM   2233  CD2 LEU A 300      40.609   8.809 -10.420  1.00 71.04           C  
ATOM   2234  N   TYR A 301      37.553   5.400 -12.744  1.00 82.20           N  
ATOM   2235  CA  TYR A 301      36.734   4.883 -13.799  1.00 83.16           C  
ATOM   2236  C   TYR A 301      35.286   5.325 -13.592  1.00 83.02           C  
ATOM   2237  O   TYR A 301      34.688   5.957 -14.480  1.00 82.55           O  
ATOM   2238  CB  TYR A 301      36.894   3.360 -13.895  1.00 83.59           C  
ATOM   2239  CG  TYR A 301      36.247   2.806 -15.126  1.00 85.19           C  
ATOM   2240  CD1 TYR A 301      36.879   2.888 -16.358  1.00 86.65           C  
ATOM   2241  CD2 TYR A 301      34.981   2.236 -15.074  1.00 87.29           C  
ATOM   2242  CE1 TYR A 301      36.281   2.385 -17.505  1.00 87.34           C  
ATOM   2243  CE2 TYR A 301      34.355   1.749 -16.235  1.00 87.40           C  
ATOM   2244  CZ  TYR A 301      35.020   1.823 -17.434  1.00 86.91           C  
ATOM   2245  OH  TYR A 301      34.438   1.331 -18.572  1.00 87.23           O  
ATOM   2246  N   ASP A 302      34.767   5.031 -12.397  1.00 83.50           N  
ATOM   2247  CA  ASP A 302      33.353   5.213 -12.072  1.00 84.16           C  
ATOM   2248  C   ASP A 302      32.978   6.693 -12.053  1.00 84.38           C  
ATOM   2249  O   ASP A 302      31.857   7.092 -12.505  1.00 85.44           O  
ATOM   2250  CB  ASP A 302      33.035   4.572 -10.723  1.00 84.20           C  
ATOM   2251  CG  ASP A 302      33.085   3.027 -10.754  1.00 86.93           C  
ATOM   2252  OD1 ASP A 302      33.293   2.399 -11.837  1.00 89.67           O  
ATOM   2253  OD2 ASP A 302      32.896   2.427  -9.673  1.00 85.09           O  
ATOM   2254  N   ALA A 303      33.908   7.508 -11.537  1.00 83.50           N  
ATOM   2255  CA  ALA A 303      33.723   8.960 -11.466  1.00 82.69           C  
ATOM   2256  C   ALA A 303      33.597   9.471 -12.912  1.00 82.57           C  
ATOM   2257  O   ALA A 303      32.660  10.192 -13.242  1.00 82.32           O  
ATOM   2258  CB  ALA A 303      34.868   9.574 -10.764  1.00 81.98           C  
ATOM   2259  N   GLY A 304      34.496   9.005 -13.782  1.00 81.86           N  
ATOM   2260  CA  GLY A 304      34.354   9.192 -15.214  1.00 81.50           C  
ATOM   2261  C   GLY A 304      33.004   8.818 -15.839  1.00 81.68           C  
ATOM   2262  O   GLY A 304      32.485   9.560 -16.667  1.00 82.38           O  
ATOM   2263  N   SER A 305      32.421   7.683 -15.459  1.00 80.72           N  
ATOM   2264  CA  SER A 305      31.139   7.285 -16.019  1.00 79.69           C  
ATOM   2265  C   SER A 305      30.036   8.215 -15.521  1.00 79.77           C  
ATOM   2266  O   SER A 305      29.168   8.688 -16.310  1.00 78.86           O  
ATOM   2267  CB  SER A 305      30.839   5.829 -15.664  1.00 79.64           C  
ATOM   2268  OG  SER A 305      31.774   4.936 -16.311  1.00 82.05           O  
ATOM   2269  N   VAL A 306      30.078   8.505 -14.207  1.00 80.21           N  
ATOM   2270  CA  VAL A 306      29.052   9.371 -13.591  1.00 79.39           C  
ATOM   2271  C   VAL A 306      29.033  10.712 -14.332  1.00 80.24           C  
ATOM   2272  O   VAL A 306      27.983  11.141 -14.774  1.00 79.93           O  
ATOM   2273  CB  VAL A 306      29.266   9.600 -12.088  1.00 78.98           C  
ATOM   2274  CG1 VAL A 306      28.293  10.648 -11.605  1.00 77.76           C  
ATOM   2275  CG2 VAL A 306      29.100   8.321 -11.287  1.00 76.95           C  
ATOM   2276  N   HIS A 307      30.212  11.329 -14.527  1.00 81.30           N  
ATOM   2277  CA  HIS A 307      30.319  12.615 -15.270  1.00 81.79           C  
ATOM   2278  C   HIS A 307      29.879  12.589 -16.710  1.00 81.83           C  
ATOM   2279  O   HIS A 307      29.092  13.475 -17.107  1.00 81.54           O  
ATOM   2280  CB  HIS A 307      31.636  13.307 -15.000  1.00 81.16           C  
ATOM   2281  CG  HIS A 307      31.779  13.574 -13.547  1.00 85.69           C  
ATOM   2282  ND1 HIS A 307      30.988  14.505 -12.895  1.00 87.04           N  
ATOM   2283  CD2 HIS A 307      32.469  12.919 -12.585  1.00 87.33           C  
ATOM   2284  CE1 HIS A 307      31.240  14.458 -11.605  1.00 88.78           C  
ATOM   2285  NE2 HIS A 307      32.132  13.502 -11.389  1.00 91.14           N  
ATOM   2286  N   GLU A 308      30.302  11.546 -17.435  1.00 81.31           N  
ATOM   2287  CA  GLU A 308      29.713  11.209 -18.758  1.00 82.81           C  
ATOM   2288  C   GLU A 308      28.184  11.219 -18.809  1.00 82.31           C  
ATOM   2289  O   GLU A 308      27.592  11.785 -19.744  1.00 80.96           O  
ATOM   2290  CB  GLU A 308      30.248   9.876 -19.310  1.00 81.70           C  
ATOM   2291  CG  GLU A 308      31.679  10.018 -19.857  1.00 84.05           C  
ATOM   2292  CD  GLU A 308      32.445   8.701 -20.028  1.00 85.13           C  
ATOM   2293  OE1 GLU A 308      31.819   7.619 -20.060  1.00 89.18           O  
ATOM   2294  OE2 GLU A 308      33.690   8.767 -20.150  1.00 88.41           O  
ATOM   2295  N   LEU A 309      27.548  10.609 -17.801  1.00 83.38           N  
ATOM   2296  CA  LEU A 309      26.081  10.530 -17.790  1.00 83.77           C  
ATOM   2297  C   LEU A 309      25.504  11.871 -17.363  1.00 84.16           C  
ATOM   2298  O   LEU A 309      24.502  12.331 -17.912  1.00 84.14           O  
ATOM   2299  CB  LEU A 309      25.577   9.389 -16.905  1.00 83.48           C  
ATOM   2300  CG  LEU A 309      26.055   7.980 -17.317  1.00 84.04           C  
ATOM   2301  CD1 LEU A 309      26.138   7.000 -16.112  1.00 83.85           C  
ATOM   2302  CD2 LEU A 309      25.247   7.327 -18.480  1.00 83.32           C  
ATOM   2303  N   LEU A 310      26.132  12.525 -16.396  1.00 85.00           N  
ATOM   2304  CA  LEU A 310      25.668  13.861 -16.049  1.00 85.46           C  
ATOM   2305  C   LEU A 310      25.675  14.708 -17.326  1.00 86.06           C  
ATOM   2306  O   LEU A 310      24.698  15.429 -17.598  1.00 85.38           O  
ATOM   2307  CB  LEU A 310      26.537  14.519 -14.987  1.00 84.95           C  
ATOM   2308  CG  LEU A 310      26.288  14.005 -13.591  1.00 84.66           C  
ATOM   2309  CD1 LEU A 310      27.508  14.309 -12.776  1.00 85.40           C  
ATOM   2310  CD2 LEU A 310      25.014  14.578 -12.967  1.00 82.31           C  
ATOM   2311  N   TYR A 311      26.754  14.596 -18.117  1.00 86.02           N  
ATOM   2312  CA  TYR A 311      26.894  15.452 -19.292  1.00 86.28           C  
ATOM   2313  C   TYR A 311      25.853  15.136 -20.300  1.00 86.22           C  
ATOM   2314  O   TYR A 311      25.281  16.060 -20.837  1.00 86.37           O  
ATOM   2315  CB  TYR A 311      28.261  15.354 -19.927  1.00 86.84           C  
ATOM   2316  CG  TYR A 311      28.543  16.428 -20.941  1.00 87.97           C  
ATOM   2317  CD1 TYR A 311      28.187  17.755 -20.714  1.00 91.13           C  
ATOM   2318  CD2 TYR A 311      29.195  16.125 -22.128  1.00 88.53           C  
ATOM   2319  CE1 TYR A 311      28.475  18.756 -21.658  1.00 90.99           C  
ATOM   2320  CE2 TYR A 311      29.482  17.095 -23.064  1.00 88.08           C  
ATOM   2321  CZ  TYR A 311      29.127  18.404 -22.836  1.00 90.37           C  
ATOM   2322  OH  TYR A 311      29.401  19.344 -23.819  1.00 91.44           O  
ATOM   2323  N   THR A 312      25.612  13.842 -20.553  1.00 86.38           N  
ATOM   2324  CA  THR A 312      24.582  13.361 -21.537  1.00 86.83           C  
ATOM   2325  C   THR A 312      23.180  13.831 -21.155  1.00 87.25           C  
ATOM   2326  O   THR A 312      22.404  14.352 -21.968  1.00 86.42           O  
ATOM   2327  CB  THR A 312      24.644  11.789 -21.720  1.00 86.46           C  
ATOM   2328  OG1 THR A 312      25.903  11.441 -22.300  1.00 87.36           O  
ATOM   2329  CG2 THR A 312      23.536  11.249 -22.624  1.00 84.86           C  
HETATM 2330  N   MSE A 313      22.880  13.651 -19.886  1.00 88.41           N  
HETATM 2331  CA  MSE A 313      21.592  14.015 -19.375  1.00 91.61           C  
HETATM 2332  C   MSE A 313      21.298  15.517 -19.412  1.00 89.39           C  
HETATM 2333  O   MSE A 313      20.213  15.899 -19.844  1.00 89.64           O  
HETATM 2334  CB  MSE A 313      21.382  13.383 -18.014  1.00 90.86           C  
HETATM 2335  CG  MSE A 313      21.428  11.871 -18.102  1.00 92.24           C  
HETATM 2336 SE   MSE A 313      21.508  11.132 -16.295  1.00101.87          SE  
HETATM 2337  CE  MSE A 313      19.592  11.035 -15.852  1.00 91.64           C  
ATOM   2338  N   ARG A 314      22.262  16.354 -19.017  1.00 88.25           N  
ATOM   2339  CA  ARG A 314      22.148  17.822 -19.210  1.00 87.29           C  
ATOM   2340  C   ARG A 314      21.886  18.163 -20.651  1.00 87.04           C  
ATOM   2341  O   ARG A 314      21.042  18.999 -20.953  1.00 87.55           O  
ATOM   2342  CB  ARG A 314      23.368  18.574 -18.715  1.00 86.40           C  
ATOM   2343  CG  ARG A 314      23.698  18.237 -17.266  1.00 87.24           C  
ATOM   2344  CD  ARG A 314      24.521  19.310 -16.555  1.00 87.27           C  
ATOM   2345  NE  ARG A 314      25.377  20.043 -17.474  1.00 88.76           N  
ATOM   2346  CZ  ARG A 314      26.679  19.843 -17.598  1.00 91.21           C  
ATOM   2347  NH1 ARG A 314      27.310  18.898 -16.853  1.00 88.71           N  
ATOM   2348  NH2 ARG A 314      27.339  20.584 -18.485  1.00 89.49           N  
ATOM   2349  N   GLN A 315      22.549  17.459 -21.551  1.00 86.82           N  
ATOM   2350  CA  GLN A 315      22.332  17.691 -22.959  1.00 87.06           C  
ATOM   2351  C   GLN A 315      20.913  17.348 -23.446  1.00 86.11           C  
ATOM   2352  O   GLN A 315      20.312  18.152 -24.180  1.00 86.61           O  
ATOM   2353  CB  GLN A 315      23.351  16.946 -23.774  1.00 87.85           C  
ATOM   2354  CG  GLN A 315      24.770  17.405 -23.594  1.00 90.82           C  
ATOM   2355  CD  GLN A 315      25.675  16.639 -24.522  1.00 95.71           C  
ATOM   2356  OE1 GLN A 315      25.193  15.805 -25.304  1.00 98.49           O  
ATOM   2357  NE2 GLN A 315      26.980  16.915 -24.469  1.00 95.79           N  
ATOM   2358  N   THR A 316      20.361  16.208 -23.028  1.00 83.77           N  
ATOM   2359  CA  THR A 316      19.042  15.856 -23.509  1.00 82.44           C  
ATOM   2360  C   THR A 316      18.029  16.800 -22.869  1.00 82.74           C  
ATOM   2361  O   THR A 316      16.939  17.010 -23.413  1.00 82.63           O  
ATOM   2362  CB  THR A 316      18.660  14.385 -23.215  1.00 82.59           C  
ATOM   2363  OG1 THR A 316      18.577  14.176 -21.795  1.00 83.90           O  
ATOM   2364  CG2 THR A 316      19.684  13.402 -23.832  1.00 80.79           C  
ATOM   2365  N   ALA A 317      18.405  17.394 -21.726  1.00 82.24           N  
ATOM   2366  CA  ALA A 317      17.493  18.219 -20.936  1.00 81.32           C  
ATOM   2367  C   ALA A 317      17.577  19.712 -21.281  1.00 82.16           C  
ATOM   2368  O   ALA A 317      16.735  20.523 -20.808  1.00 83.11           O  
ATOM   2369  CB  ALA A 317      17.710  17.993 -19.446  1.00 79.78           C  
ATOM   2370  N   GLY A 318      18.578  20.083 -22.095  1.00 81.69           N  
ATOM   2371  CA  GLY A 318      18.839  21.490 -22.419  1.00 80.18           C  
ATOM   2372  C   GLY A 318      19.356  22.280 -21.233  1.00 80.31           C  
ATOM   2373  O   GLY A 318      19.016  23.421 -21.103  1.00 80.99           O  
ATOM   2374  N   ILE A 319      20.176  21.684 -20.367  1.00 79.93           N  
ATOM   2375  CA  ILE A 319      20.769  22.375 -19.254  1.00 79.80           C  
ATOM   2376  C   ILE A 319      22.215  22.829 -19.579  1.00 81.42           C  
ATOM   2377  O   ILE A 319      23.178  22.084 -19.396  1.00 80.01           O  
ATOM   2378  CB  ILE A 319      20.787  21.457 -18.029  1.00 80.57           C  
ATOM   2379  CG1 ILE A 319      19.375  21.019 -17.635  1.00 79.54           C  
ATOM   2380  CG2 ILE A 319      21.536  22.079 -16.843  1.00 79.56           C  
ATOM   2381  CD1 ILE A 319      19.409  19.786 -16.641  1.00 77.84           C  
ATOM   2382  N   ARG A 320      22.371  24.069 -20.049  1.00 83.41           N  
ATOM   2383  CA  ARG A 320      23.719  24.644 -20.230  1.00 84.78           C  
ATOM   2384  C   ARG A 320      24.123  25.573 -19.074  1.00 85.07           C  
ATOM   2385  O   ARG A 320      23.300  26.342 -18.554  1.00 85.56           O  
ATOM   2386  CB  ARG A 320      23.894  25.393 -21.572  1.00 84.65           C  
ATOM   2387  CG  ARG A 320      23.569  24.646 -22.872  1.00 86.44           C  
ATOM   2388  CD  ARG A 320      22.302  25.295 -23.441  1.00 92.40           C  
ATOM   2389  NE  ARG A 320      21.785  24.800 -24.719  1.00 94.48           N  
ATOM   2390  CZ  ARG A 320      21.877  25.458 -25.887  1.00 98.39           C  
ATOM   2391  NH1 ARG A 320      22.524  26.644 -25.949  1.00 98.50           N  
ATOM   2392  NH2 ARG A 320      21.330  24.929 -27.005  1.00 95.49           N  
ATOM   2393  N   PHE A 321      25.400  25.503 -18.693  1.00 84.81           N  
ATOM   2394  CA  PHE A 321      26.010  26.515 -17.833  1.00 84.34           C  
ATOM   2395  C   PHE A 321      26.610  27.675 -18.660  1.00 84.46           C  
ATOM   2396  O   PHE A 321      26.858  27.534 -19.869  1.00 84.10           O  
ATOM   2397  CB  PHE A 321      27.102  25.870 -16.983  1.00 84.06           C  
ATOM   2398  CG  PHE A 321      26.677  24.595 -16.254  1.00 84.00           C  
ATOM   2399  CD1 PHE A 321      25.484  24.538 -15.514  1.00 83.05           C  
ATOM   2400  CD2 PHE A 321      27.516  23.470 -16.254  1.00 82.88           C  
ATOM   2401  CE1 PHE A 321      25.118  23.371 -14.831  1.00 82.66           C  
ATOM   2402  CE2 PHE A 321      27.178  22.317 -15.548  1.00 81.49           C  
ATOM   2403  CZ  PHE A 321      25.975  22.265 -14.840  1.00 82.54           C  
ATOM   2404  N   GLU A 322      26.831  28.818 -18.006  1.00 85.25           N  
ATOM   2405  CA  GLU A 322      27.640  29.943 -18.561  1.00 86.03           C  
ATOM   2406  C   GLU A 322      28.992  29.452 -19.195  1.00 86.58           C  
ATOM   2407  O   GLU A 322      29.923  28.992 -18.494  1.00 86.37           O  
ATOM   2408  CB  GLU A 322      27.852  31.001 -17.471  1.00 86.03           C  
ATOM   2409  N   ALA A 323      29.057  29.538 -20.531  1.00 87.04           N  
ATOM   2410  CA  ALA A 323      29.925  28.698 -21.423  1.00 86.60           C  
ATOM   2411  C   ALA A 323      29.151  27.532 -22.078  1.00 86.57           C  
ATOM   2412  O   ALA A 323      28.067  27.716 -22.663  1.00 86.04           O  
ATOM   2413  CB  ALA A 323      31.172  28.187 -20.702  1.00 86.47           C  
TER    2414      ALA A 323                                                      
END
MOLECULE T0452.pdb
ATOM      1  N   MET     1      52.780  12.131   9.830  1.00 64.27           N  
ATOM      2  CA  MET     1      51.866  13.329   9.884  1.00 62.83           C  
ATOM      3  C   MET     1      51.173  13.643   8.544  1.00 60.55           C  
ATOM      4  O   MET     1      51.817  14.126   7.602  1.00 57.92           O  
ATOM      5  CB  MET     1      52.673  14.551  10.319  1.00 66.08           C  
ATOM      6  CG  MET     1      51.875  15.808  10.723  1.00 68.81           C  
ATOM      7  SD  MET     1      50.702  15.464  12.236  0.75 84.58          SE  
ATOM      8  CE  MET     1      51.122  17.040  13.324  1.00 62.48           C  
ATOM      9  N   ILE     2      49.865  13.365   8.474  1.00 58.05           N  
ATOM     10  CA  ILE     2      49.049  13.668   7.280  1.00 58.01           C  
ATOM     11  C   ILE     2      48.619  15.140   7.290  1.00 55.65           C  
ATOM     12  O   ILE     2      47.911  15.582   8.206  1.00 53.04           O  
ATOM     13  CB  ILE     2      47.760  12.805   7.198  1.00 58.03           C  
ATOM     14  CG1 ILE     2      48.102  11.309   7.195  1.00 54.77           C  
ATOM     15  CG2 ILE     2      46.954  13.201   5.952  1.00 57.20           C  
ATOM     16  CD1 ILE     2      46.907  10.395   7.282  1.00 57.93           C  
ATOM     17  N   LYS     3      49.008  15.877   6.251  1.00 55.60           N  
ATOM     18  CA  LYS     3      48.740  17.321   6.172  1.00 56.35           C  
ATOM     19  C   LYS     3      47.600  17.604   5.221  1.00 55.84           C  
ATOM     20  O   LYS     3      47.654  17.245   4.049  1.00 55.14           O  
ATOM     21  CB  LYS     3      50.035  18.069   5.816  1.00 57.38           C  
ATOM     22  CG  LYS     3      51.033  17.984   6.990  1.00 58.52           C  
ATOM     23  CD  LYS     3      52.475  17.739   6.602  1.00 60.97           C  
ATOM     24  CE  LYS     3      53.207  18.959   6.163  1.00 63.65           C  
ATOM     25  NZ  LYS     3      54.708  18.695   6.249  1.00 66.08           N  
ATOM     26  N   ILE     4      46.562  18.239   5.765  1.00 53.56           N  
ATOM     27  CA  ILE     4      45.340  18.514   5.056  1.00 53.76           C  
ATOM     28  C   ILE     4      45.113  20.003   4.818  1.00 53.93           C  
ATOM     29  O   ILE     4      45.241  20.810   5.741  1.00 53.51           O  
ATOM     30  CB  ILE     4      44.105  18.015   5.905  1.00 55.30           C  
ATOM     31  CG1 ILE     4      44.159  16.496   6.186  1.00 55.04           C  
ATOM     32  CG2 ILE     4      42.821  18.376   5.214  1.00 50.36           C  
ATOM     33  CD1 ILE     4      43.204  16.037   7.255  1.00 53.20           C  
ATOM     34  N   ALA     5      44.778  20.365   3.584  1.00 52.17           N  
ATOM     35  CA  ALA     5      44.327  21.720   3.286  1.00 51.01           C  
ATOM     36  C   ALA     5      42.835  21.602   3.012  1.00 50.72           C  
ATOM     37  O   ALA     5      42.402  20.614   2.424  1.00 50.92           O  
ATOM     38  CB  ALA     5      45.041  22.295   2.077  1.00 51.38           C  
ATOM     39  N   ILE     6      42.053  22.567   3.502  1.00 49.77           N  
ATOM     40  CA  ILE     6      40.637  22.647   3.226  1.00 47.38           C  
ATOM     41  C   ILE     6      40.416  23.919   2.411  1.00 48.11           C  
ATOM     42  O   ILE     6      40.780  24.992   2.841  1.00 47.01           O  
ATOM     43  CB  ILE     6      39.782  22.717   4.472  1.00 47.03           C  
ATOM     44  CG1 ILE     6      39.970  21.496   5.353  1.00 51.49           C  
ATOM     45  CG2 ILE     6      38.311  22.816   4.072  1.00 46.79           C  
ATOM     46  CD1 ILE     6      39.234  21.618   6.720  1.00 41.91           C  
ATOM     47  N   VAL     7      39.830  23.789   1.228  1.00 47.88           N  
ATOM     48  CA  VAL     7      39.543  24.920   0.368  1.00 47.35           C  
ATOM     49  C   VAL     7      38.056  24.961   0.193  1.00 49.39           C  
ATOM     50  O   VAL     7      37.452  24.018  -0.300  1.00 50.39           O  
ATOM     51  CB  VAL     7      40.252  24.813  -0.981  1.00 49.31           C  
ATOM     52  CG1 VAL     7      39.610  25.733  -1.959  1.00 53.41           C  
ATOM     53  CG2 VAL     7      41.722  25.158  -0.807  1.00 43.12           C  
ATOM     54  N   GLY     8      37.456  26.063   0.593  1.00 50.03           N  
ATOM     55  CA  GLY     8      36.004  26.154   0.599  1.00 50.42           C  
ATOM     56  C   GLY     8      35.642  26.000   2.054  1.00 47.71           C  
ATOM     57  O   GLY     8      35.959  24.985   2.672  1.00 47.68           O  
ATOM     58  N   PHE     9      35.050  27.038   2.614  1.00 45.40           N  
ATOM     59  CA  PHE     9      34.735  27.048   4.020  1.00 44.91           C  
ATOM     60  C   PHE     9      33.347  27.619   4.296  1.00 44.43           C  
ATOM     61  O   PHE     9      33.143  28.367   5.264  1.00 44.10           O  
ATOM     62  CB  PHE     9      35.832  27.773   4.797  1.00 44.89           C  
ATOM     63  CG  PHE     9      36.080  27.213   6.187  1.00 46.74           C  
ATOM     64  CD1 PHE     9      36.321  25.852   6.367  1.00 45.28           C  
ATOM     65  CD2 PHE     9      36.171  28.053   7.293  1.00 44.41           C  
ATOM     66  CE1 PHE     9      36.605  25.329   7.622  1.00 46.75           C  
ATOM     67  CE2 PHE     9      36.465  27.547   8.553  1.00 40.55           C  
ATOM     68  CZ  PHE     9      36.696  26.169   8.720  1.00 40.87           C  
ATOM     69  N   GLY    10      32.401  27.246   3.429  1.00 43.72           N  
ATOM     70  CA  GLY    10      30.998  27.527   3.667  1.00 44.66           C  
ATOM     71  C   GLY    10      30.510  26.334   4.482  1.00 48.29           C  
ATOM     72  O   GLY    10      31.269  25.749   5.241  1.00 49.37           O  
ATOM     73  N   THR    11      29.254  25.953   4.292  1.00 50.86           N  
ATOM     74  CA  THR    11      28.627  24.852   5.019  1.00 51.81           C  
ATOM     75  C   THR    11      29.371  23.522   5.011  1.00 49.50           C  
ATOM     76  O   THR    11      29.564  22.923   6.059  1.00 51.59           O  
ATOM     77  CB  THR    11      27.191  24.637   4.490  1.00 53.76           C  
ATOM     78  OG1 THR    11      26.379  25.748   4.915  1.00 53.97           O  
ATOM     79  CG2 THR    11      26.590  23.379   5.041  1.00 57.42           C  
ATOM     80  N   VAL    12      29.827  23.082   3.851  1.00 46.51           N  
ATOM     81  CA  VAL    12      30.500  21.800   3.752  1.00 47.29           C  
ATOM     82  C   VAL    12      31.869  21.826   4.436  1.00 50.52           C  
ATOM     83  O   VAL    12      32.173  20.965   5.268  1.00 51.91           O  
ATOM     84  CB  VAL    12      30.693  21.382   2.287  1.00 49.55           C  
ATOM     85  CG1 VAL    12      31.536  20.094   2.183  1.00 40.83           C  
ATOM     86  CG2 VAL    12      29.302  21.256   1.548  1.00 42.52           C  
ATOM     87  N   GLY    13      32.683  22.820   4.075  1.00 49.44           N  
ATOM     88  CA  GLY    13      34.035  22.947   4.600  1.00 46.72           C  
ATOM     89  C   GLY    13      34.013  23.103   6.086  1.00 44.10           C  
ATOM     90  O   GLY    13      34.875  22.570   6.754  1.00 46.40           O  
ATOM     91  N   GLN    14      33.056  23.861   6.614  1.00 45.08           N  
ATOM     92  CA  GLN    14      32.964  24.028   8.061  1.00 46.74           C  
ATOM     93  C   GLN    14      32.542  22.687   8.684  1.00 47.58           C  
ATOM     94  O   GLN    14      33.015  22.328   9.756  1.00 51.45           O  
ATOM     95  CB  GLN    14      32.006  25.147   8.437  1.00 46.08           C  
ATOM     96  CG  GLN    14      32.486  26.525   8.017  1.00 47.44           C  
ATOM     97  CD  GLN    14      31.468  27.593   8.266  1.00 46.95           C  
ATOM     98  OE1 GLN    14      30.745  27.562   9.275  1.00 51.27           O  
ATOM     99  NE2 GLN    14      31.409  28.578   7.358  1.00 42.84           N  
ATOM    100  N   GLY    15      31.663  21.962   7.995  1.00 47.70           N  
ATOM    101  CA  GLY    15      31.237  20.600   8.388  1.00 46.12           C  
ATOM    102  C   GLY    15      32.400  19.637   8.510  1.00 46.71           C  
ATOM    103  O   GLY    15      32.479  18.855   9.460  1.00 49.04           O  
ATOM    104  N   VAL    16      33.327  19.707   7.564  1.00 46.53           N  
ATOM    105  CA  VAL    16      34.524  18.879   7.594  1.00 45.65           C  
ATOM    106  C   VAL    16      35.404  19.222   8.804  1.00 48.76           C  
ATOM    107  O   VAL    16      35.902  18.321   9.483  1.00 52.31           O  
ATOM    108  CB  VAL    16      35.329  19.006   6.247  1.00 47.14           C  
ATOM    109  CG1 VAL    16      36.711  18.302   6.347  1.00 42.27           C  
ATOM    110  CG2 VAL    16      34.473  18.477   5.045  1.00 42.69           C  
ATOM    111  N   ALA    17      35.568  20.510   9.108  1.00 45.69           N  
ATOM    112  CA  ALA    17      36.354  20.909  10.251  1.00 45.90           C  
ATOM    113  C   ALA    17      35.674  20.444  11.546  1.00 46.43           C  
ATOM    114  O   ALA    17      36.327  19.942  12.456  1.00 45.17           O  
ATOM    115  CB  ALA    17      36.590  22.427  10.243  1.00 43.86           C  
ATOM    116  N   GLU    18      34.365  20.612  11.648  1.00 47.89           N  
ATOM    117  CA  GLU    18      33.655  20.172  12.850  1.00 51.23           C  
ATOM    118  C   GLU    18      33.869  18.667  13.098  1.00 52.35           C  
ATOM    119  O   GLU    18      34.136  18.234  14.223  1.00 50.83           O  
ATOM    120  CB  GLU    18      32.166  20.422  12.710  1.00 48.26           C  
ATOM    121  CG  GLU    18      31.747  21.852  12.867  1.00 56.31           C  
ATOM    122  CD  GLU    18      30.335  22.104  12.327  1.00 60.70           C  
ATOM    123  OE1 GLU    18      29.628  21.141  11.892  1.00 72.28           O  
ATOM    124  OE2 GLU    18      29.938  23.278  12.321  1.00 67.63           O  
ATOM    125  N   LEU    19      33.766  17.883  12.030  1.00 52.89           N  
ATOM    126  CA  LEU    19      33.887  16.439  12.139  1.00 54.26           C  
ATOM    127  C   LEU    19      35.334  16.029  12.471  1.00 53.09           C  
ATOM    128  O   LEU    19      35.555  15.184  13.342  1.00 53.03           O  
ATOM    129  CB  LEU    19      33.392  15.798  10.846  1.00 55.45           C  
ATOM    130  CG  LEU    19      32.420  14.642  11.012  1.00 63.13           C  
ATOM    131  CD1 LEU    19      31.289  15.037  12.018  1.00 59.21           C  
ATOM    132  CD2 LEU    19      31.879  14.292   9.621  1.00 58.38           C  
ATOM    133  N   LEU    20      36.310  16.628  11.791  1.00 51.90           N  
ATOM    134  CA  LEU    20      37.719  16.374  12.075  1.00 51.88           C  
ATOM    135  C   LEU    20      38.049  16.642  13.536  1.00 53.28           C  
ATOM    136  O   LEU    20      38.901  15.943  14.115  1.00 51.85           O  
ATOM    137  CB  LEU    20      38.645  17.239  11.219  1.00 51.14           C  
ATOM    138  CG  LEU    20      38.829  16.884   9.745  1.00 53.15           C  
ATOM    139  CD1 LEU    20      39.788  17.894   9.182  1.00 43.05           C  
ATOM    140  CD2 LEU    20      39.342  15.459   9.496  1.00 48.98           C  
ATOM    141  N   ILE    21      37.402  17.666  14.118  1.00 54.64           N  
ATOM    142  CA  ILE    21      37.587  18.017  15.536  1.00 54.55           C  
ATOM    143  C   ILE    21      36.880  16.988  16.421  1.00 56.62           C  
ATOM    144  O   ILE    21      37.502  16.361  17.271  1.00 56.43           O  
ATOM    145  CB  ILE    21      37.038  19.436  15.877  1.00 55.74           C  
ATOM    146  CG1 ILE    21      37.904  20.531  15.229  1.00 53.49           C  
ATOM    147  CG2 ILE    21      37.002  19.660  17.408  1.00 51.22           C  
ATOM    148  CD1 ILE    21      37.263  21.896  15.245  1.00 51.16           C  
ATOM    149  N   ARG    22      35.578  16.846  16.215  1.00 57.54           N  
ATOM    150  CA  ARG    22      34.734  15.925  16.976  1.00 59.75           C  
ATOM    151  C   ARG    22      35.217  14.442  16.971  1.00 58.99           C  
ATOM    152  O   ARG    22      35.242  13.781  18.020  1.00 56.93           O  
ATOM    153  CB  ARG    22      33.289  16.101  16.478  1.00 59.84           C  
ATOM    154  CG  ARG    22      32.304  14.970  16.713  1.00 65.23           C  
ATOM    155  CD  ARG    22      30.893  15.451  16.313  1.00 66.81           C  
ATOM    156  NE  ARG    22      29.973  14.389  15.896  1.00 72.65           N  
ATOM    157  CZ  ARG    22      29.467  13.450  16.697  1.00 78.63           C  
ATOM    158  NH1 ARG    22      29.832  13.374  17.981  1.00 85.78           N  
ATOM    159  NH2 ARG    22      28.620  12.546  16.206  1.00 74.42           N  
ATOM    160  N   LYS    23      35.620  13.938  15.807  1.00 59.10           N  
ATOM    161  CA  LYS    23      36.115  12.562  15.660  1.00 58.67           C  
ATOM    162  C   LYS    23      37.656  12.477  15.597  1.00 56.52           C  
ATOM    163  O   LYS    23      38.190  11.561  15.005  1.00 57.54           O  
ATOM    164  CB  LYS    23      35.542  11.946  14.373  1.00 59.36           C  
ATOM    165  CG  LYS    23      33.995  11.816  14.279  1.00 61.86           C  
ATOM    166  CD  LYS    23      33.474  10.645  15.084  1.00 67.73           C  
ATOM    167  CE  LYS    23      32.043  10.279  14.717  1.00 68.93           C  
ATOM    168  NZ  LYS    23      31.620   9.080  15.497  1.00 69.41           N  
ATOM    169  N   ARG    24      38.382  13.392  16.215  1.00 56.81           N  
ATOM    170  CA  ARG    24      39.857  13.360  16.122  1.00 58.96           C  
ATOM    171  C   ARG    24      40.510  12.061  16.670  1.00 60.92           C  
ATOM    172  O   ARG    24      41.434  11.509  16.045  1.00 57.97           O  
ATOM    173  CB  ARG    24      40.481  14.576  16.825  1.00 58.10           C  
ATOM    174  CG  ARG    24      42.014  14.698  16.650  1.00 59.47           C  
ATOM    175  CD  ARG    24      42.603  15.885  17.417  1.00 56.47           C  
ATOM    176  N   GLU    25      40.052  11.584  17.831  1.00 62.93           N  
ATOM    177  CA  GLU    25      40.651  10.379  18.429  1.00 63.11           C  
ATOM    178  C   GLU    25      40.434   9.182  17.486  1.00 62.24           C  
ATOM    179  O   GLU    25      41.389   8.502  17.107  1.00 62.51           O  
ATOM    180  CB  GLU    25      40.136  10.106  19.865  1.00 63.51           C  
ATOM    181  CG  GLU    25      41.118   9.248  20.728  1.00 65.66           C  
ATOM    182  CD  GLU    25      40.757   9.175  22.216  1.00 63.61           C  
ATOM    183  N   GLU    26      39.200   8.966  17.055  1.00 61.11           N  
ATOM    184  CA  GLU    26      38.902   7.833  16.165  1.00 61.23           C  
ATOM    185  C   GLU    26      39.605   7.940  14.799  1.00 60.58           C  
ATOM    186  O   GLU    26      40.126   6.939  14.291  1.00 63.12           O  
ATOM    187  CB  GLU    26      37.391   7.521  16.058  1.00 60.40           C  
ATOM    188  CG  GLU    26      36.428   8.692  16.135  1.00 65.99           C  
ATOM    189  CD  GLU    26      36.232   9.259  17.550  1.00 69.89           C  
ATOM    190  OE1 GLU    26      37.204   9.779  18.145  1.00 73.11           O  
ATOM    191  OE2 GLU    26      35.086   9.227  18.053  1.00 74.67           O  
ATOM    192  N   ILE    27      39.670   9.140  14.232  1.00 57.22           N  
ATOM    193  CA  ILE    27      40.368   9.316  12.960  1.00 55.95           C  
ATOM    194  C   ILE    27      41.849   8.995  13.113  1.00 57.56           C  
ATOM    195  O   ILE    27      42.430   8.329  12.268  1.00 56.95           O  
ATOM    196  CB  ILE    27      40.261  10.769  12.399  1.00 55.02           C  
ATOM    197  CG1 ILE    27      38.821  11.132  12.039  1.00 49.34           C  
ATOM    198  CG2 ILE    27      41.133  10.922  11.165  1.00 50.75           C  
ATOM    199  CD1 ILE    27      38.624  12.577  11.770  1.00 52.22           C  
ATOM    200  N   GLU    28      42.465   9.479  14.184  1.00 61.32           N  
ATOM    201  CA  GLU    28      43.903   9.271  14.373  1.00 64.28           C  
ATOM    202  C   GLU    28      44.266   7.807  14.654  1.00 64.22           C  
ATOM    203  O   GLU    28      45.319   7.331  14.211  1.00 62.93           O  
ATOM    204  CB  GLU    28      44.489  10.218  15.439  1.00 64.78           C  
ATOM    205  CG  GLU    28      44.654  11.679  14.954  1.00 68.38           C  
ATOM    206  CD  GLU    28      45.433  12.572  15.939  1.00 68.30           C  
ATOM    207  OE1 GLU    28      45.742  12.102  17.058  1.00 70.55           O  
ATOM    208  OE2 GLU    28      45.730  13.744  15.587  1.00 73.13           O  
ATOM    209  N   LYS    29      43.405   7.086  15.367  1.00 64.63           N  
ATOM    210  CA  LYS    29      43.688   5.674  15.625  1.00 66.71           C  
ATOM    211  C   LYS    29      43.320   4.792  14.440  1.00 64.27           C  
ATOM    212  O   LYS    29      43.488   3.590  14.516  1.00 66.43           O  
ATOM    213  CB  LYS    29      43.073   5.170  16.949  1.00 68.44           C  
ATOM    214  CG  LYS    29      41.549   5.216  17.117  1.00 71.38           C  
ATOM    215  CD  LYS    29      41.198   5.127  18.641  1.00 71.88           C  
ATOM    216  CE  LYS    29      39.729   5.491  18.956  1.00 76.70           C  
ATOM    217  NZ  LYS    29      39.490   5.736  20.420  1.00 78.05           N  
ATOM    218  N   ALA    30      42.842   5.401  13.350  1.00 62.35           N  
ATOM    219  CA  ALA    30      42.498   4.704  12.117  1.00 59.58           C  
ATOM    220  C   ALA    30      43.511   4.999  10.990  1.00 59.19           C  
ATOM    221  O   ALA    30      43.926   4.084  10.282  1.00 58.82           O  
ATOM    222  CB  ALA    30      41.104   5.089  11.679  1.00 58.95           C  
ATOM    223  N   ILE    31      43.905   6.264  10.824  1.00 58.50           N  
ATOM    224  CA  ILE    31      44.836   6.662   9.747  1.00 58.25           C  
ATOM    225  C   ILE    31      46.124   7.324  10.230  1.00 56.93           C  
ATOM    226  O   ILE    31      46.986   7.654   9.415  1.00 56.58           O  
ATOM    227  CB  ILE    31      44.148   7.616   8.698  1.00 60.03           C  
ATOM    228  CG1 ILE    31      43.729   8.952   9.327  1.00 63.44           C  
ATOM    229  CG2 ILE    31      42.920   6.948   8.083  1.00 59.44           C  
ATOM    230  CD1 ILE    31      43.310  10.005   8.313  1.00 57.81           C  
ATOM    231  N   GLY    32      46.265   7.504  11.544  1.00 56.22           N  
ATOM    232  CA  GLY    32      47.450   8.154  12.123  1.00 56.26           C  
ATOM    233  C   GLY    32      47.259   9.639  12.384  1.00 56.15           C  
ATOM    234  O   GLY    32      46.173  10.193  12.194  1.00 54.12           O  
ATOM    235  N   GLU    33      48.332  10.296  12.799  1.00 57.20           N  
ATOM    236  CA  GLU    33      48.274  11.730  13.117  1.00 57.41           C  
ATOM    237  C   GLU    33      47.980  12.615  11.898  1.00 56.42           C  
ATOM    238  O   GLU    33      48.489  12.381  10.791  1.00 55.32           O  
ATOM    239  CB  GLU    33      49.571  12.202  13.797  1.00 54.88           C  
ATOM    240  N   PHE    34      47.153  13.635  12.122  1.00 56.05           N  
ATOM    241  CA  PHE    34      46.853  14.621  11.082  1.00 55.66           C  
ATOM    242  C   PHE    34      46.741  16.029  11.657  1.00 54.59           C  
ATOM    243  O   PHE    34      46.352  16.223  12.810  1.00 52.19           O  
ATOM    244  CB  PHE    34      45.539  14.293  10.356  1.00 53.22           C  
ATOM    245  CG  PHE    34      44.307  14.535  11.191  1.00 51.30           C  
ATOM    246  CD1 PHE    34      43.696  15.778  11.207  1.00 52.89           C  
ATOM    247  CD2 PHE    34      43.764  13.525  11.972  1.00 52.61           C  
ATOM    248  CE1 PHE    34      42.561  16.004  11.992  1.00 56.64           C  
ATOM    249  CE2 PHE    34      42.622  13.754  12.749  1.00 52.83           C  
ATOM    250  CZ  PHE    34      42.030  14.997  12.759  1.00 49.58           C  
ATOM    251  N   LYS    35      47.048  16.999  10.806  1.00 55.52           N  
ATOM    252  CA  LYS    35      46.903  18.402  11.119  1.00 55.01           C  
ATOM    253  C   LYS    35      46.397  19.124   9.852  1.00 53.92           C  
ATOM    254  O   LYS    35      46.825  18.822   8.738  1.00 52.95           O  
ATOM    255  CB  LYS    35      48.248  18.998  11.581  1.00 55.35           C  
ATOM    256  N   VAL    36      45.463  20.052  10.021  1.00 53.85           N  
ATOM    257  CA  VAL    36      45.023  20.896   8.912  1.00 51.19           C  
ATOM    258  C   VAL    36      46.012  22.068   8.889  1.00 50.76           C  
ATOM    259  O   VAL    36      46.081  22.869   9.825  1.00 51.72           O  
ATOM    260  CB  VAL    36      43.595  21.377   9.116  1.00 51.26           C  
ATOM    261  CG1 VAL    36      43.214  22.449   8.086  1.00 50.58           C  
ATOM    262  CG2 VAL    36      42.643  20.177   9.107  1.00 51.69           C  
ATOM    263  N   THR    37      46.798  22.142   7.825  1.00 49.63           N  
ATOM    264  CA  THR    37      47.828  23.154   7.685  1.00 48.79           C  
ATOM    265  C   THR    37      47.379  24.424   6.954  1.00 49.33           C  
ATOM    266  O   THR    37      48.097  25.425   6.971  1.00 48.55           O  
ATOM    267  CB  THR    37      49.039  22.547   6.963  1.00 51.11           C  
ATOM    268  OG1 THR    37      48.633  22.053   5.675  1.00 49.84           O  
ATOM    269  CG2 THR    37      49.661  21.384   7.816  1.00 47.18           C  
ATOM    270  N   ALA    38      46.211  24.385   6.303  1.00 48.85           N  
ATOM    271  CA  ALA    38      45.661  25.561   5.615  1.00 48.33           C  
ATOM    272  C   ALA    38      44.151  25.472   5.443  1.00 47.20           C  
ATOM    273  O   ALA    38      43.596  24.393   5.295  1.00 47.14           O  
ATOM    274  CB  ALA    38      46.319  25.748   4.256  1.00 48.10           C  
ATOM    275  N   VAL    39      43.474  26.614   5.516  1.00 46.50           N  
ATOM    276  CA  VAL    39      42.029  26.679   5.235  1.00 41.88           C  
ATOM    277  C   VAL    39      41.837  27.944   4.433  1.00 42.19           C  
ATOM    278  O   VAL    39      42.487  28.952   4.705  1.00 42.21           O  
ATOM    279  CB  VAL    39      41.134  26.697   6.499  1.00 41.10           C  
ATOM    280  CG1 VAL    39      39.640  26.750   6.099  1.00 34.79           C  
ATOM    281  CG2 VAL    39      41.379  25.436   7.334  1.00 37.90           C  
ATOM    282  N   ALA    40      40.965  27.891   3.438  1.00 42.83           N  
ATOM    283  CA  ALA    40      40.698  29.054   2.605  1.00 43.95           C  
ATOM    284  C   ALA    40      39.229  29.118   2.235  1.00 44.80           C  
ATOM    285  O   ALA    40      38.595  28.097   2.022  1.00 45.76           O  
ATOM    286  CB  ALA    40      41.583  29.062   1.350  1.00 41.09           C  
ATOM    287  N   ASP    41      38.678  30.332   2.260  1.00 47.12           N  
ATOM    288  CA  ASP    41      37.309  30.548   1.849  1.00 48.13           C  
ATOM    289  C   ASP    41      37.362  31.268   0.495  1.00 48.80           C  
ATOM    290  O   ASP    41      38.365  31.177  -0.211  1.00 46.41           O  
ATOM    291  CB  ASP    41      36.437  31.219   2.935  1.00 47.62           C  
ATOM    292  CG  ASP    41      36.796  32.655   3.226  1.00 49.98           C  
ATOM    293  OD1 ASP    41      37.592  33.291   2.504  1.00 58.19           O  
ATOM    294  OD2 ASP    41      36.230  33.163   4.208  1.00 51.58           O  
ATOM    295  N   SER    42      36.302  31.967   0.120  1.00 49.95           N  
ATOM    296  CA  SER    42      36.264  32.567  -1.204  1.00 52.64           C  
ATOM    297  C   SER    42      37.116  33.819  -1.333  1.00 52.63           C  
ATOM    298  O   SER    42      37.251  34.311  -2.423  1.00 55.48           O  
ATOM    299  CB  SER    42      34.820  32.904  -1.582  1.00 52.96           C  
ATOM    300  OG  SER    42      34.336  34.013  -0.823  1.00 58.23           O  
ATOM    301  N   LYS    43      37.665  34.347  -0.241  1.00 51.92           N  
ATOM    302  CA  LYS    43      38.480  35.552  -0.305  1.00 52.93           C  
ATOM    303  C   LYS    43      39.599  35.700   0.718  1.00 47.85           C  
ATOM    304  O   LYS    43      40.298  36.685   0.689  1.00 45.16           O  
ATOM    305  CB  LYS    43      37.585  36.781  -0.203  1.00 55.82           C  
ATOM    306  CG  LYS    43      36.657  36.790   0.999  1.00 60.82           C  
ATOM    307  CD  LYS    43      35.892  38.100   1.051  1.00 61.10           C  
ATOM    308  CE  LYS    43      34.742  38.052   2.059  1.00 71.03           C  
ATOM    309  NZ  LYS    43      34.194  39.422   2.317  1.00 69.35           N  
ATOM    310  N   SER    44      39.796  34.718   1.583  1.00 47.19           N  
ATOM    311  CA  SER    44      40.817  34.796   2.632  1.00 44.50           C  
ATOM    312  C   SER    44      41.304  33.408   3.011  1.00 43.16           C  
ATOM    313  O   SER    44      40.816  32.381   2.497  1.00 43.03           O  
ATOM    314  CB  SER    44      40.216  35.482   3.859  1.00 43.90           C  
ATOM    315  OG  SER    44      39.006  34.830   4.247  1.00 40.74           O  
ATOM    316  N   SER    45      42.257  33.361   3.929  1.00 43.34           N  
ATOM    317  CA  SER    45      42.822  32.086   4.339  1.00 44.16           C  
ATOM    318  C   SER    45      43.499  32.135   5.691  1.00 43.92           C  
ATOM    319  O   SER    45      43.653  33.190   6.280  1.00 45.20           O  
ATOM    320  CB  SER    45      43.819  31.603   3.276  1.00 43.89           C  
ATOM    321  OG  SER    45      44.824  32.582   3.070  1.00 44.61           O  
ATOM    322  N   ILE    46      43.822  30.958   6.207  1.00 44.82           N  
ATOM    323  CA  ILE    46      44.567  30.829   7.448  1.00 45.74           C  
ATOM    324  C   ILE    46      45.498  29.626   7.232  1.00 48.74           C  
ATOM    325  O   ILE    46      45.074  28.574   6.760  1.00 48.63           O  
ATOM    326  CB  ILE    46      43.651  30.702   8.698  1.00 45.65           C  
ATOM    327  CG1 ILE    46      44.485  30.784   9.991  1.00 46.96           C  
ATOM    328  CG2 ILE    46      42.820  29.444   8.634  1.00 39.08           C  
ATOM    329  CD1 ILE    46      43.657  30.960  11.292  1.00 44.17           C  
ATOM    330  N   SER    47      46.772  29.825   7.533  1.00 51.76           N  
ATOM    331  CA  SER    47      47.810  28.828   7.336  1.00 55.63           C  
ATOM    332  C   SER    47      48.871  28.999   8.418  1.00 59.36           C  
ATOM    333  O   SER    47      48.792  29.920   9.232  1.00 59.41           O  
ATOM    334  CB  SER    47      48.405  28.970   5.934  1.00 55.81           C  
ATOM    335  OG  SER    47      48.695  30.327   5.660  1.00 60.76           O  
ATOM    336  N   GLY    48      49.858  28.113   8.438  1.00 62.08           N  
ATOM    337  CA  GLY    48      50.859  28.117   9.496  1.00 64.35           C  
ATOM    338  C   GLY    48      50.278  27.283  10.621  1.00 66.48           C  
ATOM    339  O   GLY    48      49.457  26.385  10.379  1.00 68.53           O  
ATOM    340  N   ASP    49      50.707  27.547  11.849  1.00 69.50           N  
ATOM    341  CA  ASP    49      50.151  26.823  12.986  1.00 69.13           C  
ATOM    342  C   ASP    49      48.987  27.680  13.482  1.00 66.46           C  
ATOM    343  O   ASP    49      49.128  28.880  13.721  1.00 64.46           O  
ATOM    344  CB  ASP    49      51.192  26.564  14.094  1.00 71.09           C  
ATOM    345  CG  ASP    49      50.708  25.533  15.149  1.00 73.05           C  
ATOM    346  OD1 ASP    49      49.573  25.006  15.036  1.00 77.90           O  
ATOM    347  OD2 ASP    49      51.474  25.243  16.099  1.00 84.77           O  
ATOM    348  N   PHE    50      47.829  27.042  13.569  1.00 63.84           N  
ATOM    349  CA  PHE    50      46.599  27.667  14.005  1.00 61.11           C  
ATOM    350  C   PHE    50      45.774  26.477  14.406  1.00 61.21           C  
ATOM    351  O   PHE    50      46.136  25.360  14.054  1.00 65.03           O  
ATOM    352  CB  PHE    50      45.944  28.441  12.845  1.00 60.61           C  
ATOM    353  CG  PHE    50      45.450  27.562  11.718  1.00 56.00           C  
ATOM    354  CD1 PHE    50      46.296  27.183  10.687  1.00 57.36           C  
ATOM    355  CD2 PHE    50      44.134  27.104  11.698  1.00 60.04           C  
ATOM    356  CE1 PHE    50      45.838  26.367   9.652  1.00 54.45           C  
ATOM    357  CE2 PHE    50      43.683  26.282  10.679  1.00 53.05           C  
ATOM    358  CZ  PHE    50      44.542  25.922   9.658  1.00 54.95           C  
ATOM    359  N   SER    51      44.685  26.657  15.137  1.00 61.52           N  
ATOM    360  CA  SER    51      43.842  25.505  15.454  1.00 61.50           C  
ATOM    361  C   SER    51      42.601  25.509  14.543  1.00 62.12           C  
ATOM    362  O   SER    51      42.165  26.569  14.080  1.00 62.67           O  
ATOM    363  CB  SER    51      43.459  25.482  16.943  1.00 61.95           C  
ATOM    364  OG  SER    51      42.527  26.486  17.308  1.00 60.44           O  
ATOM    365  N   LEU    52      42.052  24.331  14.263  1.00 60.09           N  
ATOM    366  CA  LEU    52      40.833  24.252  13.472  1.00 60.05           C  
ATOM    367  C   LEU    52      39.696  24.966  14.153  1.00 59.93           C  
ATOM    368  O   LEU    52      38.865  25.578  13.482  1.00 60.87           O  
ATOM    369  CB  LEU    52      40.377  22.809  13.213  1.00 61.30           C  
ATOM    370  CG  LEU    52      40.904  22.097  11.981  1.00 58.66           C  
ATOM    371  CD1 LEU    52      40.284  20.695  11.921  1.00 53.94           C  
ATOM    372  CD2 LEU    52      40.584  22.906  10.726  1.00 52.52           C  
ATOM    373  N   VAL    53      39.638  24.874  15.475  1.00 58.86           N  
ATOM    374  CA  VAL    53      38.578  25.528  16.212  1.00 59.32           C  
ATOM    375  C   VAL    53      38.797  27.061  16.134  1.00 59.34           C  
ATOM    376  O   VAL    53      37.839  27.826  16.222  1.00 58.98           O  
ATOM    377  CB  VAL    53      38.498  25.009  17.680  1.00 60.99           C  
ATOM    378  CG1 VAL    53      39.747  25.416  18.481  1.00 59.44           C  
ATOM    379  CG2 VAL    53      37.251  25.532  18.356  1.00 63.08           C  
ATOM    380  N   GLU    54      40.053  27.491  15.970  1.00 58.08           N  
ATOM    381  CA  GLU    54      40.382  28.916  15.783  1.00 58.11           C  
ATOM    382  C   GLU    54      39.791  29.372  14.453  1.00 54.78           C  
ATOM    383  O   GLU    54      39.060  30.351  14.393  1.00 51.96           O  
ATOM    384  CB  GLU    54      41.911  29.142  15.808  1.00 57.95           C  
ATOM    385  CG  GLU    54      42.433  30.512  15.286  1.00 60.54           C  
ATOM    386  CD  GLU    54      43.974  30.637  15.312  1.00 63.57           C  
ATOM    387  OE1 GLU    54      44.645  29.639  15.675  1.00 69.48           O  
ATOM    388  OE2 GLU    54      44.511  31.734  14.978  1.00 64.98           O  
ATOM    389  N   ALA    55      40.106  28.628  13.397  1.00 52.28           N  
ATOM    390  CA  ALA    55      39.628  28.928  12.057  1.00 50.48           C  
ATOM    391  C   ALA    55      38.105  29.014  12.006  1.00 50.08           C  
ATOM    392  O   ALA    55      37.523  29.899  11.369  1.00 48.20           O  
ATOM    393  CB  ALA    55      40.128  27.854  11.084  1.00 47.73           C  
ATOM    394  N   LEU    56      37.479  28.089  12.715  1.00 50.68           N  
ATOM    395  CA  LEU    56      36.040  27.925  12.734  1.00 48.42           C  
ATOM    396  C   LEU    56      35.405  29.084  13.485  1.00 48.89           C  
ATOM    397  O   LEU    56      34.422  29.675  13.027  1.00 49.34           O  
ATOM    398  CB  LEU    56      35.749  26.567  13.386  1.00 49.56           C  
ATOM    399  CG  LEU    56      34.499  25.721  13.144  1.00 52.04           C  
ATOM    400  CD1 LEU    56      34.203  25.561  11.685  1.00 38.31           C  
ATOM    401  CD2 LEU    56      34.698  24.344  13.791  1.00 47.26           C  
ATOM    402  N   ARG    57      35.973  29.419  14.637  1.00 46.37           N  
ATOM    403  CA  ARG    57      35.474  30.521  15.430  1.00 48.89           C  
ATOM    404  C   ARG    57      35.549  31.828  14.619  1.00 46.79           C  
ATOM    405  O   ARG    57      34.608  32.605  14.544  1.00 46.32           O  
ATOM    406  CB  ARG    57      36.298  30.654  16.742  1.00 51.31           C  
ATOM    407  CG  ARG    57      36.110  29.490  17.783  1.00 56.80           C  
ATOM    408  CD  ARG    57      37.030  29.595  19.028  1.00 49.52           C  
ATOM    409  N   MET    58      36.694  32.040  14.000  1.00 45.43           N  
ATOM    410  CA  MET    58      36.952  33.231  13.205  1.00 47.00           C  
ATOM    411  C   MET    58      35.968  33.370  12.026  1.00 44.58           C  
ATOM    412  O   MET    58      35.461  34.448  11.784  1.00 44.79           O  
ATOM    413  CB  MET    58      38.398  33.160  12.703  1.00 46.90           C  
ATOM    414  CG  MET    58      38.910  34.397  12.064  1.00 47.83           C  
ATOM    415  SD  MET    58      40.713  34.060  11.481  0.75 49.26          SE  
ATOM    416  CE  MET    58      41.667  34.170  13.280  1.00 37.49           C  
ATOM    417  N   LYS    59      35.692  32.285  11.313  1.00 45.02           N  
ATOM    418  CA  LYS    59      34.772  32.318  10.170  1.00 44.70           C  
ATOM    419  C   LYS    59      33.356  32.681  10.611  1.00 48.20           C  
ATOM    420  O   LYS    59      32.692  33.542  10.016  1.00 49.01           O  
ATOM    421  CB  LYS    59      34.811  30.975   9.455  1.00 43.78           C  
ATOM    422  CG  LYS    59      33.941  30.862   8.201  1.00 46.14           C  
ATOM    423  CD  LYS    59      34.236  31.951   7.144  1.00 42.99           C  
ATOM    424  CE  LYS    59      33.424  31.659   5.852  1.00 41.18           C  
ATOM    425  NZ  LYS    59      33.477  32.781   4.910  1.00 42.03           N  
ATOM    426  N   ARG    60      32.914  32.073  11.702  1.00 51.20           N  
ATOM    427  CA  ARG    60      31.569  32.311  12.219  1.00 53.26           C  
ATOM    428  C   ARG    60      31.456  33.712  12.766  1.00 50.92           C  
ATOM    429  O   ARG    60      30.478  34.414  12.503  1.00 49.06           O  
ATOM    430  CB  ARG    60      31.236  31.290  13.306  1.00 54.29           C  
ATOM    431  CG  ARG    60      31.258  29.845  12.781  1.00 60.02           C  
ATOM    432  CD  ARG    60      31.161  28.754  13.885  1.00 61.47           C  
ATOM    433  NE  ARG    60      31.138  27.446  13.233  1.00 72.90           N  
ATOM    434  CZ  ARG    60      30.086  26.940  12.579  1.00 79.62           C  
ATOM    435  NH1 ARG    60      28.925  27.591  12.512  1.00 89.86           N  
ATOM    436  NH2 ARG    60      30.186  25.765  11.989  1.00 71.49           N  
ATOM    437  N   GLU    61      32.479  34.114  13.518  1.00 52.25           N  
ATOM    438  CA  GLU    61      32.532  35.431  14.158  1.00 50.35           C  
ATOM    439  C   GLU    61      32.672  36.615  13.194  1.00 47.88           C  
ATOM    440  O   GLU    61      32.191  37.705  13.494  1.00 49.25           O  
ATOM    441  CB  GLU    61      33.737  35.503  15.129  1.00 51.84           C  
ATOM    442  CG  GLU    61      33.666  34.671  16.443  1.00 59.20           C  
ATOM    443  CD  GLU    61      35.045  34.509  17.193  1.00 59.29           C  
ATOM    444  OE1 GLU    61      36.086  35.085  16.766  1.00 61.69           O  
ATOM    445  OE2 GLU    61      35.076  33.780  18.225  1.00 72.24           O  
ATOM    446  N   THR    62      33.389  36.428  12.085  1.00 42.88           N  
ATOM    447  CA  THR    62      33.716  37.549  11.186  1.00 43.33           C  
ATOM    448  C   THR    62      33.312  37.384   9.719  1.00 40.36           C  
ATOM    449  O   THR    62      33.360  38.340   8.954  1.00 42.65           O  
ATOM    450  CB  THR    62      35.255  37.824  11.195  1.00 40.65           C  
ATOM    451  OG1 THR    62      35.926  36.769  10.495  1.00 35.15           O  
ATOM    452  CG2 THR    62      35.833  37.990  12.648  1.00 34.73           C  
ATOM    453  N   GLY    63      32.923  36.184   9.336  1.00 40.64           N  
ATOM    454  CA  GLY    63      32.560  35.872   7.952  1.00 41.41           C  
ATOM    455  C   GLY    63      33.742  35.592   7.044  1.00 43.27           C  
ATOM    456  O   GLY    63      33.561  35.358   5.845  1.00 45.21           O  
ATOM    457  N   MET    64      34.953  35.619   7.603  1.00 44.51           N  
ATOM    458  CA  MET    64      36.175  35.382   6.839  1.00 45.50           C  
ATOM    459  C   MET    64      37.294  34.864   7.728  1.00 44.26           C  
ATOM    460  O   MET    64      37.122  34.693   8.941  1.00 41.59           O  
ATOM    461  CB  MET    64      36.605  36.663   6.121  1.00 45.04           C  
ATOM    462  CG  MET    64      36.613  37.860   6.986  1.00 47.01           C  
ATOM    463  SD  MET    64      37.029  39.482   6.004  0.75 47.90          SE  
ATOM    464  CE  MET    64      38.901  38.862   5.439  1.00 59.66           C  
ATOM    465  N   LEU    65      38.448  34.626   7.115  1.00 44.77           N  
ATOM    466  CA  LEU    65      39.608  34.125   7.841  1.00 43.33           C  
ATOM    467  C   LEU    65      40.633  35.227   8.089  1.00 42.87           C  
ATOM    468  O   LEU    65      40.295  36.395   8.095  1.00 44.04           O  
ATOM    469  CB  LEU    65      40.167  32.869   7.154  1.00 42.69           C  
ATOM    470  CG  LEU    65      39.144  31.724   7.110  1.00 44.17           C  
ATOM    471  CD1 LEU    65      39.490  30.693   6.027  1.00 35.33           C  
ATOM    472  CD2 LEU    65      38.968  31.084   8.505  1.00 39.69           C  
ATOM    473  N   ARG    66      41.884  34.845   8.293  1.00 43.65           N  
ATOM    474  CA  ARG    66      42.884  35.734   8.801  1.00 44.40           C  
ATOM    475  C   ARG    66      43.758  36.465   7.784  1.00 45.38           C  
ATOM    476  O   ARG    66      44.102  37.626   7.979  1.00 44.47           O  
ATOM    477  CB  ARG    66      43.789  34.898   9.713  1.00 43.61           C  
ATOM    478  CG  ARG    66      44.744  35.697  10.608  1.00 48.49           C  
ATOM    479  CD  ARG    66      45.695  34.730  11.281  1.00 47.22           C  
ATOM    480  NE  ARG    66      46.594  34.150  10.295  1.00 45.47           N  
ATOM    481  CZ  ARG    66      47.396  33.103  10.502  1.00 50.34           C  
ATOM    482  NH1 ARG    66      47.450  32.484  11.683  1.00 48.62           N  
ATOM    483  NH2 ARG    66      48.155  32.672   9.502  1.00 48.61           N  
ATOM    484  N   ASP    67      44.128  35.766   6.730  1.00 46.81           N  
ATOM    485  CA  ASP    67      45.040  36.281   5.741  1.00 47.75           C  
ATOM    486  C   ASP    67      44.333  36.578   4.453  1.00 49.32           C  
ATOM    487  O   ASP    67      43.305  36.007   4.133  1.00 47.49           O  
ATOM    488  CB  ASP    67      46.117  35.235   5.482  1.00 48.48           C  
ATOM    489  CG  ASP    67      46.804  34.797   6.752  1.00 47.99           C  
ATOM    490  OD1 ASP    67      46.953  35.636   7.668  1.00 44.98           O  
ATOM    491  OD2 ASP    67      47.179  33.620   6.840  1.00 48.00           O  
ATOM    492  N   ASP    68      44.976  37.423   3.679  1.00 51.15           N  
ATOM    493  CA  ASP    68      44.436  37.930   2.447  1.00 52.86           C  
ATOM    494  C   ASP    68      44.663  36.946   1.300  1.00 51.66           C  
ATOM    495  O   ASP    68      43.905  36.955   0.329  1.00 52.78           O  
ATOM    496  CB  ASP    68      45.090  39.285   2.168  1.00 55.83           C  
ATOM    497  CG  ASP    68      44.094  40.319   1.731  1.00 63.82           C  
ATOM    498  OD1 ASP    68      43.435  40.113   0.679  1.00 74.55           O  
ATOM    499  OD2 ASP    68      43.973  41.326   2.465  1.00 63.73           O  
ATOM    500  N   ALA    69      45.687  36.101   1.432  1.00 48.53           N  
ATOM    501  CA  ALA    69      45.999  35.066   0.444  1.00 48.57           C  
ATOM    502  C   ALA    69      44.772  34.204   0.079  1.00 48.52           C  
ATOM    503  O   ALA    69      44.108  33.618   0.943  1.00 48.23           O  
ATOM    504  CB  ALA    69      47.113  34.187   0.943  1.00 48.89           C  
ATOM    505  N   LYS    70      44.518  34.119  -1.226  1.00 47.87           N  
ATOM    506  CA  LYS    70      43.378  33.426  -1.768  1.00 47.57           C  
ATOM    507  C   LYS    70      43.628  31.917  -1.869  1.00 48.60           C  
ATOM    508  O   LYS    70      44.767  31.449  -1.745  1.00 49.21           O  
ATOM    509  CB  LYS    70      43.005  34.016  -3.129  1.00 44.83           C  
ATOM    510  CG  LYS    70      42.774  35.545  -3.104  1.00 49.98           C  
ATOM    511  CD  LYS    70      41.537  35.965  -2.297  1.00 48.83           C  
ATOM    512  CE  LYS    70      41.353  37.514  -2.246  1.00 44.39           C  
ATOM    513  NZ  LYS    70      42.399  38.226  -1.427  1.00 45.46           N  
ATOM    514  N   ALA    71      42.526  31.188  -2.046  1.00 46.47           N  
ATOM    515  CA  ALA    71      42.513  29.729  -2.160  1.00 48.77           C  
ATOM    516  C   ALA    71      43.544  29.228  -3.176  1.00 48.96           C  
ATOM    517  O   ALA    71      44.238  28.233  -2.930  1.00 48.08           O  
ATOM    518  CB  ALA    71      41.104  29.246  -2.554  1.00 45.13           C  
ATOM    519  N   ILE    72      43.668  29.938  -4.298  1.00 49.21           N  
ATOM    520  CA  ILE    72      44.594  29.502  -5.340  1.00 49.29           C  
ATOM    521  C   ILE    72      46.038  29.493  -4.796  1.00 49.91           C  
ATOM    522  O   ILE    72      46.765  28.530  -5.020  1.00 49.57           O  
ATOM    523  CB  ILE    72      44.416  30.310  -6.659  1.00 50.44           C  
ATOM    524  CG1 ILE    72      45.048  29.560  -7.851  1.00 54.22           C  
ATOM    525  CG2 ILE    72      44.959  31.731  -6.521  1.00 43.02           C  
ATOM    526  CD1 ILE    72      44.386  28.211  -8.196  1.00 52.07           C  
ATOM    527  N   GLU    73      46.424  30.516  -4.025  1.00 48.92           N  
ATOM    528  CA  GLU    73      47.773  30.575  -3.422  1.00 48.38           C  
ATOM    529  C   GLU    73      47.994  29.436  -2.412  1.00 49.08           C  
ATOM    530  O   GLU    73      49.084  28.844  -2.353  1.00 51.64           O  
ATOM    531  CB  GLU    73      48.056  31.960  -2.789  1.00 44.72           C  
ATOM    532  N   VAL    74      46.982  29.133  -1.606  1.00 48.95           N  
ATOM    533  CA  VAL    74      47.082  28.009  -0.667  1.00 48.44           C  
ATOM    534  C   VAL    74      47.245  26.694  -1.431  1.00 49.47           C  
ATOM    535  O   VAL    74      48.026  25.811  -1.033  1.00 46.63           O  
ATOM    536  CB  VAL    74      45.847  27.929   0.247  1.00 48.50           C  
ATOM    537  CG1 VAL    74      45.675  26.519   0.870  1.00 42.05           C  
ATOM    538  CG2 VAL    74      45.918  29.060   1.306  1.00 50.41           C  
ATOM    539  N   VAL    75      46.495  26.553  -2.523  1.00 50.49           N  
ATOM    540  CA  VAL    75      46.587  25.340  -3.336  1.00 50.30           C  
ATOM    541  C   VAL    75      47.957  25.175  -3.988  1.00 51.72           C  
ATOM    542  O   VAL    75      48.516  24.091  -3.968  1.00 49.57           O  
ATOM    543  CB  VAL    75      45.533  25.289  -4.436  1.00 50.92           C  
ATOM    544  CG1 VAL    75      45.860  24.141  -5.398  1.00 48.68           C  
ATOM    545  CG2 VAL    75      44.119  25.153  -3.812  1.00 47.79           C  
ATOM    546  N   ARG    76      48.495  26.253  -4.550  1.00 54.91           N  
ATOM    547  CA  ARG    76      49.776  26.162  -5.238  1.00 57.13           C  
ATOM    548  C   ARG    76      50.999  26.330  -4.351  1.00 55.63           C  
ATOM    549  O   ARG    76      52.078  25.993  -4.788  1.00 56.56           O  
ATOM    550  CB  ARG    76      49.841  27.044  -6.514  1.00 57.62           C  
ATOM    551  CG  ARG    76      49.219  28.414  -6.426  1.00 62.82           C  
ATOM    552  CD  ARG    76      49.329  29.243  -7.718  1.00 61.44           C  
ATOM    553  NE  ARG    76      48.558  28.687  -8.827  1.00 68.70           N  
ATOM    554  CZ  ARG    76      48.114  29.388  -9.876  1.00 72.60           C  
ATOM    555  NH1 ARG    76      48.301  30.707  -9.949  1.00 71.64           N  
ATOM    556  NH2 ARG    76      47.428  28.771 -10.839  1.00 74.37           N  
ATOM    557  N   SER    77      50.841  26.766  -3.102  1.00 56.55           N  
ATOM    558  CA  SER    77      52.011  26.999  -2.230  1.00 56.57           C  
ATOM    559  C   SER    77      51.990  26.386  -0.839  1.00 56.05           C  
ATOM    560  O   SER    77      53.052  26.152  -0.275  1.00 58.37           O  
ATOM    561  CB  SER    77      52.242  28.499  -2.049  1.00 55.87           C  
ATOM    562  OG  SER    77      52.404  29.148  -3.298  1.00 60.87           O  
ATOM    563  N   ALA    78      50.816  26.152  -0.264  1.00 53.72           N  
ATOM    564  CA  ALA    78      50.739  25.637   1.102  1.00 51.81           C  
ATOM    565  C   ALA    78      51.302  24.229   1.200  1.00 52.20           C  
ATOM    566  O   ALA    78      51.362  23.489   0.203  1.00 49.94           O  
ATOM    567  CB  ALA    78      49.297  25.683   1.616  1.00 50.36           C  
ATOM    568  N   ASP    79      51.708  23.862   2.413  1.00 54.01           N  
ATOM    569  CA  ASP    79      52.279  22.537   2.670  1.00 55.96           C  
ATOM    570  C   ASP    79      51.217  21.544   3.152  1.00 55.20           C  
ATOM    571  O   ASP    79      50.816  21.537   4.330  1.00 57.13           O  
ATOM    572  CB  ASP    79      53.413  22.632   3.691  1.00 57.64           C  
ATOM    573  CG  ASP    79      54.084  21.292   3.941  1.00 63.21           C  
ATOM    574  OD1 ASP    79      53.813  20.320   3.183  1.00 72.09           O  
ATOM    575  OD2 ASP    79      54.875  21.211   4.904  1.00 70.17           O  
ATOM    576  N   TYR    80      50.770  20.704   2.226  1.00 52.70           N  
ATOM    577  CA  TYR    80      49.740  19.707   2.511  1.00 50.65           C  
ATOM    578  C   TYR    80      49.966  18.467   1.647  1.00 50.59           C  
ATOM    579  O   TYR    80      50.675  18.507   0.631  1.00 48.13           O  
ATOM    580  CB  TYR    80      48.336  20.285   2.275  1.00 49.01           C  
ATOM    581  CG  TYR    80      48.087  20.691   0.838  1.00 48.83           C  
ATOM    582  CD1 TYR    80      48.447  21.950   0.376  1.00 46.01           C  
ATOM    583  CD2 TYR    80      47.512  19.806  -0.066  1.00 50.85           C  
ATOM    584  CE1 TYR    80      48.244  22.306  -0.956  1.00 48.56           C  
ATOM    585  CE2 TYR    80      47.298  20.160  -1.389  1.00 49.09           C  
ATOM    586  CZ  TYR    80      47.664  21.405  -1.827  1.00 45.04           C  
ATOM    587  OH  TYR    80      47.448  21.760  -3.136  1.00 46.31           O  
ATOM    588  N   ASP    81      49.359  17.372   2.094  1.00 50.85           N  
ATOM    589  CA  ASP    81      49.426  16.077   1.445  1.00 50.80           C  
ATOM    590  C   ASP    81      48.141  15.778   0.682  1.00 49.39           C  
ATOM    591  O   ASP    81      48.193  15.248  -0.423  1.00 48.44           O  
ATOM    592  CB  ASP    81      49.680  15.009   2.504  1.00 51.60           C  
ATOM    593  CG  ASP    81      51.024  15.184   3.165  1.00 52.29           C  
ATOM    594  OD1 ASP    81      51.983  15.436   2.413  1.00 50.80           O  
ATOM    595  OD2 ASP    81      51.114  15.094   4.405  1.00 52.87           O  
ATOM    596  N   VAL    82      47.005  16.131   1.280  1.00 48.04           N  
ATOM    597  CA  VAL    82      45.679  15.929   0.673  1.00 49.37           C  
ATOM    598  C   VAL    82      44.902  17.249   0.701  1.00 51.01           C  
ATOM    599  O   VAL    82      44.898  17.942   1.713  1.00 49.19           O  
ATOM    600  CB  VAL    82      44.861  14.815   1.432  1.00 50.01           C  
ATOM    601  CG1 VAL    82      44.888  15.036   2.950  1.00 45.54           C  
ATOM    602  CG2 VAL    82      43.413  14.695   0.911  1.00 45.57           C  
ATOM    603  N   LEU    83      44.281  17.601  -0.431  1.00 51.29           N  
ATOM    604  CA  LEU    83      43.392  18.753  -0.515  1.00 49.17           C  
ATOM    605  C   LEU    83      41.920  18.317  -0.411  1.00 49.00           C  
ATOM    606  O   LEU    83      41.450  17.460  -1.165  1.00 48.75           O  
ATOM    607  CB  LEU    83      43.555  19.471  -1.847  1.00 46.98           C  
ATOM    608  CG  LEU    83      42.636  20.677  -2.069  1.00 48.83           C  
ATOM    609  CD1 LEU    83      42.959  21.779  -1.048  1.00 42.31           C  
ATOM    610  CD2 LEU    83      42.764  21.161  -3.508  1.00 42.84           C  
ATOM    611  N   ILE    84      41.197  18.934   0.516  1.00 48.92           N  
ATOM    612  CA  ILE    84      39.746  18.767   0.619  1.00 46.97           C  
ATOM    613  C   ILE    84      39.160  19.989  -0.089  1.00 45.43           C  
ATOM    614  O   ILE    84      39.314  21.113   0.354  1.00 44.83           O  
ATOM    615  CB  ILE    84      39.276  18.666   2.071  1.00 46.15           C  
ATOM    616  CG1 ILE    84      39.852  17.365   2.668  1.00 47.29           C  
ATOM    617  CG2 ILE    84      37.762  18.689   2.092  1.00 46.24           C  
ATOM    618  CD1 ILE    84      39.445  17.067   4.080  1.00 50.14           C  
ATOM    619  N   GLU    85      38.522  19.748  -1.216  1.00 46.60           N  
ATOM    620  CA  GLU    85      38.039  20.784  -2.084  1.00 47.89           C  
ATOM    621  C   GLU    85      36.520  20.804  -2.013  1.00 49.62           C  
ATOM    622  O   GLU    85      35.832  20.028  -2.692  1.00 51.63           O  
ATOM    623  CB  GLU    85      38.573  20.475  -3.490  1.00 51.71           C  
ATOM    624  CG  GLU    85      38.765  21.692  -4.368  1.00 57.75           C  
ATOM    625  CD  GLU    85      37.511  22.140  -5.000  1.00 60.03           C  
ATOM    626  OE1 GLU    85      37.080  21.474  -5.960  1.00 68.42           O  
ATOM    627  OE2 GLU    85      36.983  23.178  -4.569  1.00 72.90           O  
ATOM    628  N   ALA    86      36.025  21.714  -1.175  1.00 50.24           N  
ATOM    629  CA  ALA    86      34.621  21.906  -0.862  1.00 51.22           C  
ATOM    630  C   ALA    86      34.248  23.339  -1.231  1.00 51.93           C  
ATOM    631  O   ALA    86      33.511  24.004  -0.489  1.00 47.88           O  
ATOM    632  CB  ALA    86      34.436  21.671   0.646  1.00 42.93           C  
ATOM    633  N   SER    87      34.774  23.845  -2.363  1.00 55.52           N  
ATOM    634  CA  SER    87      34.591  25.281  -2.700  1.00 57.00           C  
ATOM    635  C   SER    87      33.147  25.630  -3.017  1.00 61.90           C  
ATOM    636  O   SER    87      32.398  24.811  -3.514  1.00 59.30           O  
ATOM    637  CB  SER    87      35.575  25.809  -3.754  1.00 55.15           C  
ATOM    638  OG  SER    87      35.372  25.244  -5.030  1.00 56.86           O  
ATOM    639  N   VAL    88      32.775  26.852  -2.642  1.00 69.20           N  
ATOM    640  CA  VAL    88      31.417  27.390  -2.824  1.00 73.90           C  
ATOM    641  C   VAL    88      31.318  27.964  -4.261  1.00 76.16           C  
ATOM    642  O   VAL    88      31.702  29.098  -4.513  1.00 73.54           O  
ATOM    643  CB  VAL    88      31.120  28.461  -1.715  1.00 73.08           C  
ATOM    644  CG1 VAL    88      29.731  29.066  -1.894  1.00 69.80           C  
ATOM    645  CG2 VAL    88      31.289  27.840  -0.312  1.00 61.02           C  
ATOM    646  N   THR    89      30.828  27.137  -5.190  1.00 81.00           N  
ATOM    647  CA  THR    89      30.745  27.468  -6.637  1.00 82.65           C  
ATOM    648  C   THR    89      30.000  28.772  -6.989  1.00 85.93           C  
ATOM    649  O   THR    89      30.596  29.691  -7.569  1.00 87.51           O  
ATOM    650  CB  THR    89      30.105  26.289  -7.430  1.00 83.25           C  
ATOM    651  OG1 THR    89      30.674  25.064  -6.969  1.00 82.01           O  
ATOM    652  CG2 THR    89      30.323  26.436  -8.944  1.00 80.95           C  
ATOM    653  N   ARG    90      28.711  28.843  -6.654  1.00 87.96           N  
ATOM    654  CA  ARG    90      27.909  30.034  -6.955  1.00 90.26           C  
ATOM    655  C   ARG    90      28.283  31.197  -6.028  1.00 91.70           C  
ATOM    656  O   ARG    90      29.381  31.757  -6.132  1.00 92.21           O  
ATOM    657  CB  ARG    90      26.401  29.730  -6.884  1.00 90.72           C  
ATOM    658  CG  ARG    90      25.902  28.808  -7.988  1.00 88.44           C  
ATOM    659  N   GLU    95      36.980  27.853 -10.944  1.00 71.42           N  
ATOM    660  CA  GLU    95      37.985  27.902  -9.881  1.00 70.39           C  
ATOM    661  C   GLU    95      38.234  26.504  -9.345  1.00 67.32           C  
ATOM    662  O   GLU    95      39.382  26.078  -9.244  1.00 66.47           O  
ATOM    663  CB  GLU    95      37.552  28.843  -8.747  1.00 70.36           C  
ATOM    664  CG  GLU    95      37.322  30.293  -9.198  1.00 74.88           C  
ATOM    665  CD  GLU    95      37.005  31.238  -8.055  1.00 74.03           C  
ATOM    666  N   GLY    96      37.146  25.793  -9.032  1.00 64.05           N  
ATOM    667  CA  GLY    96      37.204  24.430  -8.510  1.00 61.48           C  
ATOM    668  C   GLY    96      38.060  23.472  -9.322  1.00 59.51           C  
ATOM    669  O   GLY    96      38.877  22.737  -8.755  1.00 56.52           O  
ATOM    670  N   VAL    97      37.863  23.492 -10.646  1.00 56.94           N  
ATOM    671  CA  VAL    97      38.614  22.650 -11.595  1.00 55.26           C  
ATOM    672  C   VAL    97      40.127  22.928 -11.513  1.00 56.32           C  
ATOM    673  O   VAL    97      40.927  21.991 -11.518  1.00 55.09           O  
ATOM    674  CB  VAL    97      38.070  22.803 -13.045  1.00 53.78           C  
ATOM    675  CG1 VAL    97      38.066  24.261 -13.494  1.00 58.74           C  
ATOM    676  CG2 VAL    97      38.864  21.960 -14.008  1.00 59.11           C  
ATOM    677  N   ASN    98      40.480  24.214 -11.389  1.00 54.22           N  
ATOM    678  CA  ASN    98      41.857  24.660 -11.246  1.00 54.30           C  
ATOM    679  C   ASN    98      42.453  24.285  -9.882  1.00 51.57           C  
ATOM    680  O   ASN    98      43.645  23.998  -9.795  1.00 47.91           O  
ATOM    681  CB  ASN    98      41.962  26.177 -11.474  1.00 55.52           C  
ATOM    682  CG  ASN    98      41.589  26.593 -12.901  1.00 61.57           C  
ATOM    683  OD1 ASN    98      41.665  25.800 -13.848  1.00 71.44           O  
ATOM    684  ND2 ASN    98      41.197  27.849 -13.056  1.00 66.79           N  
ATOM    685  N   TYR    99      41.643  24.288  -8.820  1.00 48.54           N  
ATOM    686  CA  TYR    99      42.161  23.863  -7.522  1.00 49.64           C  
ATOM    687  C   TYR    99      42.500  22.371  -7.569  1.00 49.05           C  
ATOM    688  O   TYR    99      43.541  21.952  -7.053  1.00 51.64           O  
ATOM    689  CB  TYR    99      41.194  24.121  -6.350  1.00 48.05           C  
ATOM    690  CG  TYR    99      40.754  25.556  -6.162  1.00 46.23           C  
ATOM    691  CD1 TYR    99      41.623  26.625  -6.348  1.00 46.50           C  
ATOM    692  CD2 TYR    99      39.490  25.832  -5.724  1.00 45.42           C  
ATOM    693  CE1 TYR    99      41.192  27.936  -6.155  1.00 46.16           C  
ATOM    694  CE2 TYR    99      39.064  27.119  -5.519  1.00 46.77           C  
ATOM    695  CZ  TYR    99      39.904  28.166  -5.733  1.00 45.70           C  
ATOM    696  OH  TYR    99      39.402  29.434  -5.514  1.00 51.84           O  
ATOM    697  N   ILE   100      41.628  21.574  -8.179  1.00 47.86           N  
ATOM    698  CA  ILE   100      41.874  20.132  -8.314  1.00 49.67           C  
ATOM    699  C   ILE   100      43.122  19.875  -9.195  1.00 51.71           C  
ATOM    700  O   ILE   100      44.067  19.252  -8.743  1.00 51.29           O  
ATOM    701  CB  ILE   100      40.659  19.376  -8.896  1.00 48.81           C  
ATOM    702  CG1 ILE   100      39.469  19.386  -7.930  1.00 48.30           C  
ATOM    703  CG2 ILE   100      41.003  17.910  -9.176  1.00 44.61           C  
ATOM    704  CD1 ILE   100      38.199  18.752  -8.519  1.00 49.51           C  
ATOM    705  N   ARG   101      43.108  20.369 -10.431  1.00 52.51           N  
ATOM    706  CA  ARG   101      44.230  20.194 -11.364  1.00 55.14           C  
ATOM    707  C   ARG   101      45.554  20.601 -10.734  1.00 54.85           C  
ATOM    708  O   ARG   101      46.535  19.874 -10.839  1.00 55.38           O  
ATOM    709  CB  ARG   101      44.035  21.011 -12.650  1.00 55.82           C  
ATOM    710  CG  ARG   101      42.778  20.674 -13.456  1.00 58.03           C  
ATOM    711  CD  ARG   101      42.829  21.241 -14.900  1.00 62.37           C  
ATOM    712  NE  ARG   101      43.768  20.500 -15.761  1.00 74.76           N  
ATOM    713  CZ  ARG   101      43.525  19.324 -16.364  1.00 73.10           C  
ATOM    714  NH1 ARG   101      42.371  18.678 -16.211  1.00 82.89           N  
ATOM    715  NH2 ARG   101      44.462  18.763 -17.113  1.00 77.93           N  
ATOM    716  N   GLU   102      45.570  21.741 -10.047  1.00 55.06           N  
ATOM    717  CA  GLU   102      46.809  22.249  -9.432  1.00 52.94           C  
ATOM    718  C   GLU   102      47.251  21.434  -8.207  1.00 50.92           C  
ATOM    719  O   GLU   102      48.438  21.306  -7.962  1.00 50.71           O  
ATOM    720  CB  GLU   102      46.692  23.751  -9.127  1.00 53.31           C  
ATOM    721  CG  GLU   102      47.894  24.396  -8.412  1.00 59.26           C  
ATOM    722  CD  GLU   102      49.247  24.233  -9.132  1.00 73.51           C  
ATOM    723  OE1 GLU   102      49.290  23.801 -10.310  1.00 79.16           O  
ATOM    724  OE2 GLU   102      50.281  24.545  -8.500  1.00 74.49           O  
ATOM    725  N   ALA   103      46.331  20.875  -7.431  1.00 48.87           N  
ATOM    726  CA  ALA   103      46.771  20.000  -6.334  1.00 49.59           C  
ATOM    727  C   ALA   103      47.291  18.658  -6.928  1.00 50.34           C  
ATOM    728  O   ALA   103      48.342  18.160  -6.523  1.00 49.72           O  
ATOM    729  CB  ALA   103      45.681  19.771  -5.339  1.00 49.73           C  
ATOM    730  N   LEU   104      46.581  18.114  -7.920  1.00 49.91           N  
ATOM    731  CA  LEU   104      46.985  16.867  -8.575  1.00 51.67           C  
ATOM    732  C   LEU   104      48.338  17.020  -9.279  1.00 52.40           C  
ATOM    733  O   LEU   104      49.191  16.145  -9.171  1.00 50.76           O  
ATOM    734  CB  LEU   104      45.928  16.407  -9.568  1.00 49.76           C  
ATOM    735  CG  LEU   104      44.547  16.002  -9.041  1.00 53.38           C  
ATOM    736  CD1 LEU   104      43.662  15.662 -10.233  1.00 37.65           C  
ATOM    737  CD2 LEU   104      44.609  14.837  -8.066  1.00 50.22           C  
ATOM    738  N   LYS   105      48.533  18.144  -9.976  1.00 56.09           N  
ATOM    739  CA  LYS   105      49.814  18.446 -10.655  1.00 57.24           C  
ATOM    740  C   LYS   105      50.963  18.669  -9.692  1.00 57.39           C  
ATOM    741  O   LYS   105      52.103  18.672 -10.107  1.00 59.78           O  
ATOM    742  CB  LYS   105      49.703  19.640 -11.618  1.00 57.94           C  
ATOM    743  CG  LYS   105      49.032  19.267 -12.935  1.00 61.88           C  
ATOM    744  CD  LYS   105      49.179  20.332 -14.006  1.00 62.50           C  
ATOM    745  CE  LYS   105      48.876  19.739 -15.402  1.00 70.85           C  
ATOM    746  NZ  LYS   105      49.886  18.699 -15.892  1.00 70.98           N  
ATOM    747  N   ARG   106      50.658  18.892  -8.420  1.00 58.13           N  
ATOM    748  CA  ARG   106      51.672  19.005  -7.369  1.00 56.77           C  
ATOM    749  C   ARG   106      51.905  17.619  -6.740  1.00 56.15           C  
ATOM    750  O   ARG   106      52.762  17.458  -5.857  1.00 54.66           O  
ATOM    751  CB  ARG   106      51.227  19.993  -6.282  1.00 56.17           C  
ATOM    752  CG  ARG   106      51.323  21.464  -6.672  1.00 56.67           C  
ATOM    753  CD  ARG   106      51.087  22.367  -5.465  1.00 55.82           C  
ATOM    754  NE  ARG   106      52.073  22.124  -4.405  1.00 53.50           N  
ATOM    755  CZ  ARG   106      51.980  22.577  -3.155  1.00 56.94           C  
ATOM    756  NH1 ARG   106      50.933  23.294  -2.762  1.00 58.09           N  
ATOM    757  NH2 ARG   106      52.925  22.285  -2.278  1.00 50.02           N  
ATOM    758  N   GLY   107      51.131  16.628  -7.195  1.00 55.48           N  
ATOM    759  CA  GLY   107      51.208  15.275  -6.654  1.00 55.17           C  
ATOM    760  C   GLY   107      50.539  15.197  -5.295  1.00 54.21           C  
ATOM    761  O   GLY   107      51.081  14.619  -4.345  1.00 54.11           O  
ATOM    762  N   LYS   108      49.371  15.816  -5.186  1.00 51.69           N  
ATOM    763  CA  LYS   108      48.619  15.784  -3.935  1.00 51.31           C  
ATOM    764  C   LYS   108      47.323  15.041  -4.178  1.00 48.74           C  
ATOM    765  O   LYS   108      46.741  15.138  -5.251  1.00 48.93           O  
ATOM    766  CB  LYS   108      48.273  17.194  -3.456  1.00 51.38           C  
ATOM    767  CG  LYS   108      49.419  18.169  -3.456  1.00 56.15           C  
ATOM    768  CD  LYS   108      50.515  17.765  -2.520  1.00 58.85           C  
ATOM    769  CE  LYS   108      51.599  18.829  -2.498  1.00 60.63           C  
ATOM    770  NZ  LYS   108      52.697  18.433  -1.593  1.00 62.62           N  
ATOM    771  N   HIS   109      46.874  14.297  -3.182  1.00 49.47           N  
ATOM    772  CA  HIS   109      45.569  13.666  -3.256  1.00 49.40           C  
ATOM    773  C   HIS   109      44.517  14.758  -3.203  1.00 50.51           C  
ATOM    774  O   HIS   109      44.791  15.847  -2.689  1.00 47.92           O  
ATOM    775  CB  HIS   109      45.343  12.730  -2.073  1.00 49.59           C  
ATOM    776  CG  HIS   109      46.234  11.536  -2.078  1.00 48.32           C  
ATOM    777  ND1 HIS   109      46.214  10.603  -3.090  1.00 46.44           N  
ATOM    778  CD2 HIS   109      47.148  11.101  -1.183  1.00 56.19           C  
ATOM    779  CE1 HIS   109      47.073   9.642  -2.817  1.00 46.97           C  
ATOM    780  NE2 HIS   109      47.665   9.927  -1.671  1.00 52.45           N  
ATOM    781  N   VAL   110      43.330  14.473  -3.752  1.00 50.11           N  
ATOM    782  CA  VAL   110      42.217  15.417  -3.717  1.00 48.52           C  
ATOM    783  C   VAL   110      40.909  14.683  -3.375  1.00 49.34           C  
ATOM    784  O   VAL   110      40.607  13.641  -3.948  1.00 48.90           O  
ATOM    785  CB  VAL   110      42.041  16.184  -5.047  1.00 48.35           C  
ATOM    786  CG1 VAL   110      40.770  17.073  -5.010  1.00 44.89           C  
ATOM    787  CG2 VAL   110      43.297  17.022  -5.380  1.00 49.41           C  
ATOM    788  N   VAL   111      40.183  15.217  -2.388  1.00 49.95           N  
ATOM    789  CA  VAL   111      38.847  14.747  -2.023  1.00 47.72           C  
ATOM    790  C   VAL   111      37.955  15.932  -2.284  1.00 47.79           C  
ATOM    791  O   VAL   111      38.155  16.980  -1.698  1.00 48.65           O  
ATOM    792  CB  VAL   111      38.744  14.330  -0.539  1.00 50.88           C  
ATOM    793  CG1 VAL   111      37.274  13.885  -0.179  1.00 43.38           C  
ATOM    794  CG2 VAL   111      39.822  13.221  -0.211  1.00 37.10           C  
ATOM    795  N   THR   112      36.975  15.786  -3.170  1.00 48.71           N  
ATOM    796  CA  THR   112      36.090  16.889  -3.497  1.00 48.68           C  
ATOM    797  C   THR   112      34.581  16.600  -3.306  1.00 47.62           C  
ATOM    798  O   THR   112      34.144  15.451  -3.292  1.00 46.68           O  
ATOM    799  CB  THR   112      36.337  17.321  -4.968  1.00 50.41           C  
ATOM    800  OG1 THR   112      35.673  18.561  -5.241  1.00 47.66           O  
ATOM    801  CG2 THR   112      35.852  16.241  -5.934  1.00 45.32           C  
ATOM    802  N   SER   113      33.820  17.681  -3.147  1.00 45.75           N  
ATOM    803  CA  SER   113      32.375  17.659  -3.096  1.00 46.09           C  
ATOM    804  C   SER   113      31.789  18.458  -4.240  1.00 47.40           C  
ATOM    805  O   SER   113      30.560  18.580  -4.317  1.00 45.48           O  
ATOM    806  CB  SER   113      31.875  18.236  -1.788  1.00 45.43           C  
ATOM    807  OG  SER   113      32.284  19.584  -1.646  1.00 48.74           O  
ATOM    808  N   ASN   114      32.644  19.035  -5.109  1.00 50.21           N  
ATOM    809  CA  ASN   114      32.192  19.825  -6.272  1.00 48.59           C  
ATOM    810  C   ASN   114      31.952  18.966  -7.482  1.00 50.23           C  
ATOM    811  O   ASN   114      32.851  18.267  -7.955  1.00 53.11           O  
ATOM    812  CB  ASN   114      33.234  20.855  -6.728  1.00 53.83           C  
ATOM    813  CG  ASN   114      33.505  21.943  -5.724  1.00 55.30           C  
ATOM    814  OD1 ASN   114      32.666  22.306  -4.903  1.00 62.72           O  
ATOM    815  ND2 ASN   114      34.684  22.520  -5.836  1.00 64.14           N  
ATOM    816  N   LYS   115      30.766  19.082  -8.045  1.00 50.56           N  
ATOM    817  CA  LYS   115      30.398  18.316  -9.208  1.00 51.29           C  
ATOM    818  C   LYS   115      30.955  18.846 -10.506  1.00 51.41           C  
ATOM    819  O   LYS   115      31.316  18.065 -11.374  1.00 51.72           O  
ATOM    820  CB  LYS   115      28.881  18.263  -9.341  1.00 49.65           C  
ATOM    821  CG  LYS   115      28.202  17.499  -8.226  1.00 52.75           C  
ATOM    822  CD  LYS   115      26.694  17.359  -8.422  1.00 53.62           C  
ATOM    823  CE  LYS   115      25.950  18.662  -8.349  1.00 50.26           C  
ATOM    824  NZ  LYS   115      26.141  19.356  -7.059  1.00 50.30           N  
ATOM    825  N   GLY   116      30.971  20.166 -10.651  1.00 52.85           N  
ATOM    826  CA  GLY   116      31.371  20.831 -11.893  1.00 53.63           C  
ATOM    827  C   GLY   116      32.590  20.334 -12.641  1.00 52.17           C  
ATOM    828  O   GLY   116      32.525  20.138 -13.850  1.00 52.80           O  
ATOM    829  N   PRO   117      33.732  20.230 -11.942  1.00 54.21           N  
ATOM    830  CA  PRO   117      34.969  19.755 -12.567  1.00 54.55           C  
ATOM    831  C   PRO   117      34.874  18.330 -13.110  1.00 54.36           C  
ATOM    832  O   PRO   117      35.433  18.031 -14.153  1.00 53.77           O  
ATOM    833  CB  PRO   117      36.012  19.857 -11.431  1.00 55.95           C  
ATOM    834  CG  PRO   117      35.430  20.794 -10.416  1.00 56.94           C  
ATOM    835  CD  PRO   117      33.940  20.671 -10.539  1.00 53.64           C  
ATOM    836  N   LEU   118      34.183  17.465 -12.378  1.00 55.23           N  
ATOM    837  CA  LEU   118      33.987  16.075 -12.757  1.00 55.96           C  
ATOM    838  C   LEU   118      33.057  15.968 -13.965  1.00 55.80           C  
ATOM    839  O   LEU   118      33.257  15.138 -14.825  1.00 58.23           O  
ATOM    840  CB  LEU   118      33.446  15.262 -11.545  1.00 58.62           C  
ATOM    841  CG  LEU   118      34.500  15.044 -10.441  1.00 61.54           C  
ATOM    842  CD1 LEU   118      33.928  14.742  -9.107  1.00 71.04           C  
ATOM    843  CD2 LEU   118      35.406  13.924 -10.859  1.00 68.06           C  
ATOM    844  N   VAL   119      32.046  16.817 -14.035  1.00 54.86           N  
ATOM    845  CA  VAL   119      31.113  16.814 -15.154  1.00 53.09           C  
ATOM    846  C   VAL   119      31.791  17.310 -16.443  1.00 55.58           C  
ATOM    847  O   VAL   119      31.652  16.694 -17.498  1.00 56.38           O  
ATOM    848  CB  VAL   119      29.889  17.628 -14.764  1.00 54.44           C  
ATOM    849  CG1 VAL   119      28.941  17.805 -15.914  1.00 52.88           C  
ATOM    850  CG2 VAL   119      29.207  16.909 -13.621  1.00 44.67           C  
ATOM    851  N   ALA   120      32.582  18.373 -16.318  1.00 54.44           N  
ATOM    852  CA  ALA   120      33.290  18.992 -17.435  1.00 54.29           C  
ATOM    853  C   ALA   120      34.518  18.235 -17.921  1.00 55.34           C  
ATOM    854  O   ALA   120      34.811  18.247 -19.105  1.00 57.54           O  
ATOM    855  CB  ALA   120      33.737  20.410 -17.029  1.00 51.93           C  
ATOM    856  N   GLU   121      35.213  17.545 -17.025  1.00 56.00           N  
ATOM    857  CA  GLU   121      36.541  17.038 -17.323  1.00 58.35           C  
ATOM    858  C   GLU   121      36.841  15.724 -16.611  1.00 55.53           C  
ATOM    859  O   GLU   121      37.940  15.530 -16.113  1.00 56.64           O  
ATOM    860  CB  GLU   121      37.464  18.167 -16.815  1.00 59.18           C  
ATOM    861  CG  GLU   121      38.830  18.362 -17.439  1.00 70.74           C  
ATOM    862  CD  GLU   121      39.409  19.783 -17.142  1.00 65.74           C  
ATOM    863  OE1 GLU   121      38.645  20.684 -16.743  1.00 79.01           O  
ATOM    864  OE2 GLU   121      40.619  20.015 -17.355  1.00 85.72           O  
ATOM    865  N   PHE   122      35.876  14.802 -16.601  1.00 56.63           N  
ATOM    866  CA  PHE   122      36.010  13.547 -15.844  1.00 55.23           C  
ATOM    867  C   PHE   122      37.264  12.738 -16.151  1.00 54.15           C  
ATOM    868  O   PHE   122      38.086  12.516 -15.264  1.00 52.49           O  
ATOM    869  CB  PHE   122      34.777  12.655 -16.018  1.00 54.88           C  
ATOM    870  CG  PHE   122      34.693  11.521 -15.020  1.00 50.49           C  
ATOM    871  CD1 PHE   122      35.355  10.327 -15.244  1.00 55.24           C  
ATOM    872  CD2 PHE   122      33.935  11.644 -13.876  1.00 50.51           C  
ATOM    873  CE1 PHE   122      35.289   9.278 -14.335  1.00 51.72           C  
ATOM    874  CE2 PHE   122      33.841  10.587 -12.970  1.00 51.01           C  
ATOM    875  CZ  PHE   122      34.524   9.416 -13.196  1.00 52.74           C  
ATOM    876  N   HIS   123      37.401  12.272 -17.392  1.00 56.63           N  
ATOM    877  CA  HIS   123      38.563  11.450 -17.733  0.50 55.39           C  
ATOM    879  C   HIS   123      39.863  12.266 -17.699  1.00 54.42           C  
ATOM    880  O   HIS   123      40.909  11.736 -17.299  1.00 53.57           O  
ATOM    881  CB  HIS   123      38.302  10.658 -19.024  0.50 56.22           C  
ATOM    883  CG  HIS   123      37.164   9.680 -18.890  0.50 57.00           C  
ATOM    885  ND1 HIS   123      37.353   8.347 -18.593  0.50 58.87           N  
ATOM    887  CD2 HIS   123      35.821   9.859 -18.951  0.50 55.15           C  
ATOM    889  CE1 HIS   123      36.178   7.744 -18.505  0.50 56.16           C  
ATOM    891  NE2 HIS   123      35.233   8.640 -18.717  0.50 47.93           N  
ATOM    893  N   GLY   124      39.796  13.550 -18.054  1.00 53.91           N  
ATOM    894  CA  GLY   124      40.978  14.415 -17.976  1.00 53.04           C  
ATOM    895  C   GLY   124      41.543  14.511 -16.555  1.00 51.96           C  
ATOM    896  O   GLY   124      42.753  14.529 -16.351  1.00 50.24           O  
ATOM    897  N   LEU   125      40.664  14.563 -15.559  1.00 53.43           N  
ATOM    898  CA  LEU   125      41.097  14.673 -14.155  1.00 52.48           C  
ATOM    899  C   LEU   125      41.531  13.328 -13.551  1.00 50.24           C  
ATOM    900  O   LEU   125      42.487  13.275 -12.777  1.00 49.73           O  
ATOM    901  CB  LEU   125      40.000  15.344 -13.308  1.00 53.01           C  
ATOM    902  CG  LEU   125      39.695  16.826 -13.543  1.00 54.32           C  
ATOM    903  CD1 LEU   125      38.510  17.280 -12.725  1.00 55.94           C  
ATOM    904  CD2 LEU   125      40.916  17.652 -13.194  1.00 52.48           C  
ATOM    905  N   MET   126      40.808  12.256 -13.865  1.00 52.81           N  
ATOM    906  CA  MET   126      41.185  10.893 -13.402  1.00 54.54           C  
ATOM    907  C   MET   126      42.575  10.517 -13.924  1.00 53.83           C  
ATOM    908  O   MET   126      43.378   9.944 -13.184  1.00 53.10           O  
ATOM    909  CB  MET   126      40.189   9.807 -13.835  1.00 54.20           C  
ATOM    910  CG  MET   126      38.795   9.855 -13.183  1.00 58.18           C  
ATOM    911  SD  MET   126      38.751  10.091 -11.219  0.75 60.16          SE  
ATOM    912  CE  MET   126      39.752   8.577 -10.538  1.00 78.54           C  
ATOM    913  N   SER   127      42.844  10.862 -15.186  1.00 54.62           N  
ATOM    914  CA  SER   127      44.147  10.597 -15.831  1.00 54.86           C  
ATOM    915  C   SER   127      45.267  11.425 -15.241  1.00 53.47           C  
ATOM    916  O   SER   127      46.381  10.950 -15.131  1.00 55.47           O  
ATOM    917  CB  SER   127      44.094  10.894 -17.332  1.00 54.90           C  
ATOM    918  OG  SER   127      43.186  10.041 -17.993  1.00 61.83           O  
ATOM    919  N   LEU   128      44.978  12.684 -14.919  1.00 52.40           N  
ATOM    920  CA  LEU   128      45.966  13.574 -14.325  1.00 50.90           C  
ATOM    921  C   LEU   128      46.372  13.016 -12.972  1.00 51.93           C  
ATOM    922  O   LEU   128      47.555  12.994 -12.633  1.00 53.62           O  
ATOM    923  CB  LEU   128      45.395  14.980 -14.198  1.00 51.03           C  
ATOM    924  CG  LEU   128      46.234  16.105 -13.596  1.00 49.96           C  
ATOM    925  CD1 LEU   128      47.568  16.259 -14.343  1.00 56.86           C  
ATOM    926  CD2 LEU   128      45.413  17.380 -13.639  1.00 50.06           C  
ATOM    927  N   ALA   129      45.385  12.556 -12.208  1.00 51.61           N  
ATOM    928  CA  ALA   129      45.632  11.936 -10.915  1.00 51.88           C  
ATOM    929  C   ALA   129      46.487  10.673 -11.099  1.00 52.40           C  
ATOM    930  O   ALA   129      47.434  10.443 -10.339  1.00 50.89           O  
ATOM    931  CB  ALA   129      44.296  11.596 -10.207  1.00 50.63           C  
ATOM    932  N   GLU   130      46.137   9.856 -12.094  1.00 53.27           N  
ATOM    933  CA  GLU   130      46.895   8.632 -12.398  1.00 54.20           C  
ATOM    934  C   GLU   130      48.324   8.963 -12.851  1.00 54.83           C  
ATOM    935  O   GLU   130      49.264   8.333 -12.362  1.00 54.37           O  
ATOM    936  CB  GLU   130      46.193   7.791 -13.462  1.00 52.41           C  
ATOM    937  N   ARG   131      48.492   9.955 -13.743  1.00 55.42           N  
ATOM    938  CA  ARG   131      49.840  10.356 -14.250  1.00 56.32           C  
ATOM    939  C   ARG   131      50.738  10.829 -13.114  1.00 55.67           C  
ATOM    940  O   ARG   131      51.926  10.576 -13.118  1.00 56.70           O  
ATOM    941  CB  ARG   131      49.758  11.431 -15.348  1.00 56.34           C  
ATOM    942  CG  ARG   131      49.050  10.967 -16.660  1.00 62.98           C  
ATOM    943  CD  ARG   131      48.982  12.092 -17.710  1.00 61.66           C  
ATOM    944  NE  ARG   131      48.426  13.344 -17.177  1.00 64.09           N  
ATOM    945  N   ASN   132      50.177  11.568 -12.168  1.00 56.65           N  
ATOM    946  CA  ASN   132      50.895  11.901 -10.943  1.00 56.97           C  
ATOM    947  C   ASN   132      50.559  10.651 -10.117  1.00 58.00           C  
ATOM    948  O   ASN   132      49.869   9.779 -10.637  1.00 59.78           O  
ATOM    949  CB  ASN   132      50.415  13.238 -10.413  1.00 57.33           C  
ATOM    950  CG  ASN   132      50.664  14.355 -11.420  1.00 57.24           C  
ATOM    951  OD1 ASN   132      51.786  14.816 -11.570  1.00 61.01           O  
ATOM    952  ND2 ASN   132      49.626  14.760 -12.140  1.00 60.01           N  
ATOM    953  N   GLY   133      51.018  10.477  -8.889  1.00 57.07           N  
ATOM    954  CA  GLY   133      50.747   9.159  -8.251  1.00 56.86           C  
ATOM    955  C   GLY   133      49.713   9.238  -7.162  1.00 56.82           C  
ATOM    956  O   GLY   133      49.919   8.703  -6.070  1.00 58.77           O  
ATOM    957  N   VAL   134      48.579   9.858  -7.474  1.00 53.08           N  
ATOM    958  CA  VAL   134      47.616  10.206  -6.441  1.00 51.32           C  
ATOM    959  C   VAL   134      46.175   9.874  -6.828  1.00 50.72           C  
ATOM    960  O   VAL   134      45.910   9.435  -7.945  1.00 48.58           O  
ATOM    961  CB  VAL   134      47.796  11.703  -6.057  1.00 51.01           C  
ATOM    962  CG1 VAL   134      49.012  11.872  -5.150  1.00 54.40           C  
ATOM    963  CG2 VAL   134      47.930  12.580  -7.305  1.00 45.88           C  
ATOM    964  N   ARG   135      45.268  10.139  -5.895  0.50 49.42           N  
ATOM    966  CA  ARG   135      43.865   9.791  -6.030  0.50 48.64           C  
ATOM    968  C   ARG   135      42.945  11.001  -6.034  0.50 49.96           C  
ATOM    970  O   ARG   135      43.253  12.019  -5.408  0.50 49.55           O  
ATOM    972  CB  ARG   135      43.520   8.818  -4.889  0.50 49.07           C  
ATOM    974  CG  ARG   135      44.238   7.447  -5.089  0.50 42.86           C  
ATOM    976  CD  ARG   135      44.600   6.726  -3.784  0.50 47.77           C  
ATOM    978  NE  ARG   135      43.639   5.901  -3.034  0.50 45.67           N  
ATOM    980  CZ  ARG   135      42.520   5.335  -3.464  0.50 34.61           C  
ATOM    982  NH1 ARG   135      42.107   5.428  -4.715  0.50 49.68           N  
ATOM    984  NH2 ARG   135      41.807   4.612  -2.611  0.50 41.15           N  
ATOM    986  N   LEU   136      41.850  10.901  -6.803  1.00 51.89           N  
ATOM    987  CA  LEU   136      40.819  11.910  -6.827  1.00 50.18           C  
ATOM    988  C   LEU   136      39.542  11.204  -6.338  1.00 49.36           C  
ATOM    989  O   LEU   136      38.971  10.354  -7.025  1.00 47.37           O  
ATOM    990  CB  LEU   136      40.644  12.459  -8.244  1.00 48.45           C  
ATOM    991  CG  LEU   136      39.474  13.415  -8.427  1.00 52.91           C  
ATOM    992  CD1 LEU   136      39.544  14.575  -7.432  1.00 49.89           C  
ATOM    993  CD2 LEU   136      39.446  13.914  -9.835  1.00 50.66           C  
ATOM    994  N   MET   137      39.124  11.584  -5.133  1.00 49.57           N  
ATOM    995  CA  MET   137      37.985  11.000  -4.440  1.00 47.97           C  
ATOM    996  C   MET   137      36.838  11.987  -4.519  1.00 47.50           C  
ATOM    997  O   MET   137      37.051  13.185  -4.449  1.00 47.68           O  
ATOM    998  CB  MET   137      38.368  10.700  -2.991  1.00 48.53           C  
ATOM    999  CG  MET   137      39.656   9.905  -2.862  1.00 42.73           C  
ATOM   1000  SD  MET   137      39.679   8.179  -3.673  0.75 46.98          SE  
ATOM   1001  CE  MET   137      38.432   7.168  -2.288  1.00 38.10           C  
ATOM   1002  N   TYR   138      35.630  11.460  -4.661  1.00 48.91           N  
ATOM   1003  CA  TYR   138      34.475  12.256  -4.923  1.00 47.22           C  
ATOM   1004  C   TYR   138      33.151  11.698  -4.424  1.00 47.83           C  
ATOM   1005  O   TYR   138      32.087  12.015  -4.959  1.00 45.61           O  
ATOM   1006  CB  TYR   138      34.424  12.553  -6.412  1.00 44.71           C  
ATOM   1007  CG  TYR   138      34.385  11.379  -7.364  1.00 46.33           C  
ATOM   1008  CD1 TYR   138      35.546  10.696  -7.704  1.00 52.94           C  
ATOM   1009  CD2 TYR   138      33.214  11.025  -8.019  1.00 44.16           C  
ATOM   1010  CE1 TYR   138      35.532   9.650  -8.594  1.00 43.58           C  
ATOM   1011  CE2 TYR   138      33.201  10.003  -8.915  1.00 46.47           C  
ATOM   1012  CZ  TYR   138      34.374   9.332  -9.212  1.00 48.02           C  
ATOM   1013  OH  TYR   138      34.369   8.298 -10.104  1.00 46.71           O  
ATOM   1014  N   GLU   139      33.216  10.954  -3.334  1.00 45.83           N  
ATOM   1015  CA  GLU   139      32.017  10.400  -2.731  1.00 47.57           C  
ATOM   1016  C   GLU   139      30.970  11.444  -2.426  1.00 49.18           C  
ATOM   1017  O   GLU   139      29.768  11.190  -2.572  1.00 50.54           O  
ATOM   1018  CB  GLU   139      32.335   9.668  -1.414  1.00 48.35           C  
ATOM   1019  CG  GLU   139      31.164   8.835  -0.884  1.00 47.00           C  
ATOM   1020  CD  GLU   139      30.758   7.711  -1.860  1.00 43.98           C  
ATOM   1021  OE1 GLU   139      31.478   6.693  -1.942  1.00 46.77           O  
ATOM   1022  OE2 GLU   139      29.693   7.834  -2.501  1.00 51.48           O  
ATOM   1023  N   ALA   140      31.410  12.632  -2.008  1.00 47.25           N  
ATOM   1024  CA  ALA   140      30.466  13.630  -1.608  1.00 46.58           C  
ATOM   1025  C   ALA   140      29.757  14.314  -2.779  1.00 47.40           C  
ATOM   1026  O   ALA   140      28.847  15.054  -2.526  1.00 48.49           O  
ATOM   1027  CB  ALA   140      31.140  14.651  -0.721  1.00 44.92           C  
ATOM   1028  N   THR   141      30.195  14.090  -4.022  1.00 46.91           N  
ATOM   1029  CA  THR   141      29.588  14.714  -5.207  1.00 48.12           C  
ATOM   1030  C   THR   141      28.202  14.200  -5.568  1.00 50.80           C  
ATOM   1031  O   THR   141      27.416  14.944  -6.177  1.00 51.29           O  
ATOM   1032  CB  THR   141      30.478  14.659  -6.488  1.00 47.24           C  
ATOM   1033  OG1 THR   141      30.723  13.294  -6.859  1.00 48.28           O  
ATOM   1034  CG2 THR   141      31.825  15.414  -6.262  1.00 43.30           C  
ATOM   1035  N   VAL   142      27.914  12.957  -5.200  1.00 53.48           N  
ATOM   1036  CA  VAL   142      26.622  12.313  -5.469  1.00 53.95           C  
ATOM   1037  C   VAL   142      26.171  11.369  -4.346  1.00 54.69           C  
ATOM   1038  O   VAL   142      26.930  10.513  -3.878  1.00 55.37           O  
ATOM   1039  CB  VAL   142      26.618  11.611  -6.854  1.00 54.18           C  
ATOM   1040  CG1 VAL   142      27.955  10.999  -7.161  1.00 57.67           C  
ATOM   1041  CG2 VAL   142      25.479  10.619  -6.943  1.00 52.95           C  
ATOM   1042  N   GLY   143      24.958  11.600  -3.856  1.00 52.14           N  
ATOM   1043  CA  GLY   143      24.374  10.750  -2.838  1.00 50.98           C  
ATOM   1044  C   GLY   143      24.609  11.204  -1.432  1.00 51.28           C  
ATOM   1045  O   GLY   143      24.085  10.613  -0.496  1.00 55.26           O  
ATOM   1046  N   GLY   144      25.396  12.256  -1.251  1.00 52.65           N  
ATOM   1047  CA  GLY   144      25.723  12.698   0.083  1.00 51.40           C  
ATOM   1048  C   GLY   144      26.376  11.565   0.871  1.00 50.65           C  
ATOM   1049  O   GLY   144      27.388  11.001   0.447  1.00 48.18           O  
ATOM   1050  N   ALA   145      25.768  11.212   2.002  1.00 51.56           N  
ATOM   1051  CA  ALA   145      26.327  10.204   2.909  1.00 52.26           C  
ATOM   1052  C   ALA   145      26.139   8.777   2.348  1.00 53.05           C  
ATOM   1053  O   ALA   145      26.863   7.857   2.708  1.00 53.99           O  
ATOM   1054  CB  ALA   145      25.677  10.322   4.270  1.00 50.99           C  
ATOM   1055  N   MET   146      25.158   8.618   1.462  1.00 50.60           N  
ATOM   1056  CA  MET   146      24.891   7.368   0.851  1.00 50.52           C  
ATOM   1057  C   MET   146      26.084   6.894   0.012  1.00 50.64           C  
ATOM   1058  O   MET   146      26.504   7.577  -0.892  1.00 48.54           O  
ATOM   1059  CB  MET   146      23.694   7.542  -0.055  1.00 51.68           C  
ATOM   1060  CG  MET   146      23.106   6.288  -0.514  1.00 53.42           C  
ATOM   1061  SD  MET   146      21.639   6.652  -1.726  0.75 51.40          SE  
ATOM   1062  CE  MET   146      22.421   7.137  -3.397  1.00 41.76           C  
ATOM   1063  N   PRO   147      26.590   5.680   0.272  1.00 55.27           N  
ATOM   1064  CA  PRO   147      27.666   5.168  -0.554  1.00 59.57           C  
ATOM   1065  C   PRO   147      27.109   4.969  -1.970  1.00 62.01           C  
ATOM   1066  O   PRO   147      26.020   4.430  -2.168  1.00 69.27           O  
ATOM   1067  CB  PRO   147      27.996   3.825   0.115  1.00 62.74           C  
ATOM   1068  CG  PRO   147      26.726   3.399   0.712  1.00 58.36           C  
ATOM   1069  CD  PRO   147      26.153   4.675   1.262  1.00 57.17           C  
ATOM   1070  N   VAL   148      27.811   5.458  -2.944  1.00 58.57           N  
ATOM   1071  CA  VAL   148      27.372   5.354  -4.306  1.00 57.54           C  
ATOM   1072  C   VAL   148      28.616   5.216  -5.127  1.00 54.59           C  
ATOM   1073  O   VAL   148      28.723   4.308  -5.944  1.00 52.23           O  
ATOM   1074  CB  VAL   148      26.547   6.614  -4.724  1.00 60.30           C  
ATOM   1075  CG1 VAL   148      26.965   7.147  -6.068  1.00 66.42           C  
ATOM   1076  CG2 VAL   148      25.075   6.275  -4.725  1.00 68.44           C  
ATOM   1077  N   VAL   149      29.574   6.114  -4.890  1.00 52.03           N  
ATOM   1078  CA  VAL   149      30.798   6.115  -5.672  1.00 51.15           C  
ATOM   1079  C   VAL   149      31.675   4.920  -5.288  1.00 50.57           C  
ATOM   1080  O   VAL   149      32.071   4.145  -6.167  1.00 45.42           O  
ATOM   1081  CB  VAL   149      31.546   7.468  -5.571  1.00 53.38           C  
ATOM   1082  CG1 VAL   149      32.893   7.384  -6.303  1.00 49.14           C  
ATOM   1083  CG2 VAL   149      30.649   8.600  -6.096  1.00 47.53           C  
ATOM   1084  N   LYS   150      31.952   4.755  -3.989  1.00 48.79           N  
ATOM   1085  CA  LYS   150      32.784   3.626  -3.512  1.00 49.43           C  
ATOM   1086  C   LYS   150      32.095   2.320  -3.764  1.00 47.11           C  
ATOM   1087  O   LYS   150      32.760   1.332  -4.023  1.00 46.70           O  
ATOM   1088  CB  LYS   150      33.287   3.796  -2.039  1.00 47.93           C  
ATOM   1089  CG  LYS   150      34.373   4.877  -1.975  1.00 54.17           C  
ATOM   1090  CD  LYS   150      35.164   5.020  -0.677  1.00 51.38           C  
ATOM   1091  CE  LYS   150      34.367   5.564   0.440  1.00 49.40           C  
ATOM   1092  NZ  LYS   150      33.730   6.839   0.047  1.00 45.36           N  
ATOM   1093  N   LEU   151      30.766   2.343  -3.813  1.00 47.45           N  
ATOM   1094  CA  LEU   151      29.981   1.164  -4.115  1.00 50.05           C  
ATOM   1095  C   LEU   151      30.137   0.788  -5.590  1.00 50.80           C  
ATOM   1096  O   LEU   151      30.518  -0.323  -5.894  1.00 50.90           O  
ATOM   1097  CB  LEU   151      28.510   1.423  -3.788  1.00 50.10           C  
ATOM   1098  CG  LEU   151      27.572   0.282  -3.453  1.00 53.83           C  
ATOM   1099  CD1 LEU   151      28.191  -0.557  -2.376  1.00 52.95           C  
ATOM   1100  CD2 LEU   151      26.256   0.818  -2.940  1.00 51.54           C  
ATOM   1101  N   ALA   152      29.828   1.712  -6.498  1.00 51.01           N  
ATOM   1102  CA  ALA   152      30.003   1.494  -7.945  1.00 51.04           C  
ATOM   1103  C   ALA   152      31.442   1.116  -8.305  1.00 53.77           C  
ATOM   1104  O   ALA   152      31.685   0.143  -9.005  1.00 60.02           O  
ATOM   1105  CB  ALA   152      29.575   2.740  -8.712  1.00 52.32           C  
ATOM   1106  N   LYS   153      32.398   1.805  -7.706  1.00 54.40           N  
ATOM   1107  CA  LYS   153      33.807   1.695  -8.037  1.00 53.36           C  
ATOM   1108  C   LYS   153      34.665   0.702  -7.258  1.00 55.14           C  
ATOM   1109  O   LYS   153      35.620   0.158  -7.812  1.00 57.79           O  
ATOM   1110  CB  LYS   153      34.377   3.115  -7.900  1.00 54.63           C  
ATOM   1111  CG  LYS   153      35.746   3.330  -8.418  1.00 58.39           C  
ATOM   1112  CD  LYS   153      36.106   4.819  -8.468  1.00 52.71           C  
ATOM   1113  CE  LYS   153      37.502   4.973  -9.105  1.00 61.35           C  
ATOM   1114  NZ  LYS   153      37.926   6.379  -9.270  1.00 66.54           N  
ATOM   1115  N   ARG   154      34.395   0.477  -5.980  1.00 54.31           N  
ATOM   1116  CA  ARG   154      35.188  -0.505  -5.228  1.00 54.23           C  
ATOM   1117  C   ARG   154      34.476  -1.840  -4.948  1.00 55.81           C  
ATOM   1118  O   ARG   154      34.992  -2.916  -5.324  1.00 57.05           O  
ATOM   1119  CB  ARG   154      35.708   0.073  -3.925  1.00 54.10           C  
ATOM   1120  CG  ARG   154      36.583   1.271  -4.109  1.00 57.75           C  
ATOM   1121  CD  ARG   154      37.445   1.469  -2.909  1.00 70.09           C  
ATOM   1122  NE  ARG   154      38.334   0.318  -2.732  1.00 74.67           N  
ATOM   1123  CZ  ARG   154      39.451   0.100  -3.430  1.00 77.44           C  
ATOM   1124  NH1 ARG   154      39.846   0.949  -4.379  1.00 81.46           N  
ATOM   1125  NH2 ARG   154      40.178  -0.983  -3.187  1.00 76.63           N  
ATOM   1126  N   TYR   155      33.295  -1.785  -4.322  0.50 54.71           N  
ATOM   1128  CA  TYR   155      32.536  -3.010  -4.014  0.50 53.40           C  
ATOM   1130  C   TYR   155      32.141  -3.747  -5.269  0.50 54.30           C  
ATOM   1132  O   TYR   155      32.419  -4.925  -5.428  0.50 53.99           O  
ATOM   1134  CB  TYR   155      31.255  -2.734  -3.218  0.50 51.83           C  
ATOM   1136  CG  TYR   155      30.583  -4.021  -2.795  0.50 43.29           C  
ATOM   1138  CD1 TYR   155      31.041  -4.726  -1.709  0.50 41.08           C  
ATOM   1140  CD2 TYR   155      29.518  -4.539  -3.500  0.50 48.09           C  
ATOM   1142  CE1 TYR   155      30.462  -5.905  -1.330  0.50 48.06           C  
ATOM   1144  CE2 TYR   155      28.924  -5.719  -3.138  0.50 42.41           C  
ATOM   1146  CZ  TYR   155      29.397  -6.402  -2.040  0.50 45.37           C  
ATOM   1148  OH  TYR   155      28.828  -7.589  -1.643  0.50 44.65           O  
ATOM   1150  N   LEU   156      31.501  -3.034  -6.177  1.00 55.32           N  
ATOM   1151  CA  LEU   156      31.031  -3.657  -7.435  1.00 56.06           C  
ATOM   1152  C   LEU   156      32.119  -3.608  -8.588  1.00 57.02           C  
ATOM   1153  O   LEU   156      31.785  -3.715  -9.780  1.00 59.87           O  
ATOM   1154  CB  LEU   156      29.713  -2.989  -7.882  1.00 55.67           C  
ATOM   1155  CG  LEU   156      28.350  -3.341  -7.236  1.00 60.67           C  
ATOM   1156  CD1 LEU   156      28.451  -3.636  -5.794  1.00 66.28           C  
ATOM   1157  CD2 LEU   156      27.290  -2.228  -7.457  1.00 57.19           C  
ATOM   1158  N   ALA   157      33.400  -3.468  -8.226  1.00 56.54           N  
ATOM   1159  CA  ALA   157      34.521  -3.350  -9.184  1.00 56.55           C  
ATOM   1160  C   ALA   157      34.622  -4.450 -10.263  1.00 59.66           C  
ATOM   1161  O   ALA   157      34.781  -4.134 -11.446  1.00 61.89           O  
ATOM   1162  CB  ALA   157      35.839  -3.295  -8.418  1.00 55.50           C  
ATOM   1163  N   LEU   158      34.555  -5.728  -9.864  1.00 56.71           N  
ATOM   1164  CA  LEU   158      34.674  -6.827 -10.825  1.00 55.58           C  
ATOM   1165  C   LEU   158      33.330  -7.304 -11.373  1.00 53.88           C  
ATOM   1166  O   LEU   158      33.243  -8.387 -11.927  1.00 54.06           O  
ATOM   1167  CB  LEU   158      35.522  -7.974 -10.251  1.00 52.64           C  
ATOM   1168  CG  LEU   158      36.933  -7.510  -9.841  1.00 55.52           C  
ATOM   1169  CD1 LEU   158      37.710  -8.657  -9.185  1.00 48.73           C  
ATOM   1170  CD2 LEU   158      37.732  -6.940 -11.023  1.00 52.52           C  
ATOM   1171  N   CYS   159      32.288  -6.496 -11.200  1.00 56.59           N  
ATOM   1172  CA  CYS   159      30.969  -6.723 -11.822  1.00 59.68           C  
ATOM   1173  C   CYS   159      30.829  -5.783 -12.996  1.00 61.90           C  
ATOM   1174  O   CYS   159      31.402  -4.686 -13.006  1.00 62.77           O  
ATOM   1175  CB  CYS   159      29.800  -6.251 -10.943  1.00 61.49           C  
ATOM   1176  SG  CYS   159      29.435  -7.136  -9.519  1.00 64.20           S  
ATOM   1177  N   GLU   160      29.971  -6.169 -13.921  1.00 61.80           N  
ATOM   1178  CA  GLU   160      29.610  -5.314 -15.002  1.00 63.32           C  
ATOM   1179  C   GLU   160      28.327  -4.673 -14.491  1.00 59.95           C  
ATOM   1180  O   GLU   160      27.312  -5.341 -14.330  1.00 58.39           O  
ATOM   1181  CB  GLU   160      29.344  -6.146 -16.256  1.00 65.37           C  
ATOM   1182  CG  GLU   160      29.285  -5.391 -17.590  1.00 70.26           C  
ATOM   1183  CD  GLU   160      28.942  -6.339 -18.739  1.00 72.53           C  
ATOM   1184  OE1 GLU   160      27.785  -6.829 -18.776  1.00 88.10           O  
ATOM   1185  OE2 GLU   160      29.825  -6.598 -19.602  1.00 88.52           O  
ATOM   1186  N   ILE   161      28.384  -3.387 -14.175  1.00 59.80           N  
ATOM   1187  CA  ILE   161      27.187  -2.659 -13.768  1.00 57.54           C  
ATOM   1188  C   ILE   161      26.499  -2.299 -15.053  1.00 58.17           C  
ATOM   1189  O   ILE   161      27.023  -1.517 -15.833  1.00 60.25           O  
ATOM   1190  CB  ILE   161      27.495  -1.412 -12.991  1.00 56.04           C  
ATOM   1191  CG1 ILE   161      28.227  -1.781 -11.711  1.00 52.54           C  
ATOM   1192  CG2 ILE   161      26.190  -0.668 -12.657  1.00 55.86           C  
ATOM   1193  CD1 ILE   161      28.695  -0.602 -10.903  1.00 50.27           C  
ATOM   1194  N   GLU   162      25.334  -2.887 -15.275  1.00 57.24           N  
ATOM   1195  CA  GLU   162      24.576  -2.677 -16.487  1.00 58.11           C  
ATOM   1196  C   GLU   162      23.718  -1.408 -16.454  1.00 57.49           C  
ATOM   1197  O   GLU   162      23.480  -0.797 -17.494  1.00 59.56           O  
ATOM   1198  CB  GLU   162      23.697  -3.889 -16.727  1.00 57.98           C  
ATOM   1199  CG  GLU   162      24.499  -5.191 -16.812  1.00 62.57           C  
ATOM   1200  CD  GLU   162      23.610  -6.411 -16.803  1.00 64.20           C  
ATOM   1201  OE1 GLU   162      22.363  -6.256 -16.710  1.00 79.58           O  
ATOM   1202  OE2 GLU   162      24.159  -7.536 -16.893  1.00 79.67           O  
ATOM   1203  N   SER   163      23.227  -1.024 -15.281  1.00 55.55           N  
ATOM   1204  CA  SER   163      22.434   0.196 -15.163  1.00 53.26           C  
ATOM   1205  C   SER   163      22.339   0.681 -13.745  1.00 53.60           C  
ATOM   1206  O   SER   163      22.535  -0.078 -12.796  1.00 51.06           O  
ATOM   1207  CB  SER   163      21.015  -0.012 -15.689  1.00 54.07           C  
ATOM   1208  OG  SER   163      20.234  -0.788 -14.798  1.00 55.86           O  
ATOM   1209  N   VAL   164      22.066   1.972 -13.619  1.00 53.90           N  
ATOM   1210  CA  VAL   164      21.791   2.593 -12.351  1.00 52.14           C  
ATOM   1211  C   VAL   164      20.548   3.461 -12.555  1.00 53.15           C  
ATOM   1212  O   VAL   164      20.476   4.212 -13.504  1.00 53.64           O  
ATOM   1213  CB  VAL   164      22.943   3.463 -11.847  1.00 53.97           C  
ATOM   1214  CG1 VAL   164      22.580   4.024 -10.475  1.00 47.02           C  
ATOM   1215  CG2 VAL   164      24.252   2.669 -11.801  1.00 49.17           C  
ATOM   1216  N   LYS   165      19.550   3.286 -11.700  1.00 50.54           N  
ATOM   1217  CA  LYS   165      18.361   4.096 -11.694  1.00 50.85           C  
ATOM   1218  C   LYS   165      18.305   4.638 -10.285  1.00 49.44           C  
ATOM   1219  O   LYS   165      18.298   3.869  -9.361  1.00 51.81           O  
ATOM   1220  CB  LYS   165      17.078   3.267 -11.907  1.00 48.82           C  
ATOM   1221  CG  LYS   165      16.852   2.702 -13.298  1.00 58.14           C  
ATOM   1222  CD  LYS   165      15.757   1.614 -13.278  1.00 56.98           C  
ATOM   1223  CE  LYS   165      15.609   0.870 -14.656  1.00 62.75           C  
ATOM   1224  N   GLY   166      18.215   5.940 -10.096  1.00 50.52           N  
ATOM   1225  CA  GLY   166      18.076   6.433  -8.737  1.00 52.09           C  
ATOM   1226  C   GLY   166      17.413   7.776  -8.608  1.00 50.03           C  
ATOM   1227  O   GLY   166      16.976   8.384  -9.574  1.00 50.54           O  
ATOM   1228  N   ILE   167      17.360   8.196  -7.363  1.00 50.68           N  
ATOM   1229  CA  ILE   167      16.806   9.440  -6.913  1.00 48.61           C  
ATOM   1230  C   ILE   167      18.001  10.209  -6.380  1.00 47.71           C  
ATOM   1231  O   ILE   167      18.515   9.831  -5.339  1.00 48.18           O  
ATOM   1232  CB  ILE   167      15.807   9.155  -5.766  1.00 48.07           C  
ATOM   1233  CG1 ILE   167      14.529   8.498  -6.338  1.00 50.59           C  
ATOM   1234  CG2 ILE   167      15.538  10.450  -4.952  1.00 43.73           C  
ATOM   1235  CD1 ILE   167      13.550   8.006  -5.275  1.00 50.03           C  
ATOM   1236  N   PHE   168      18.457  11.255  -7.076  1.00 49.17           N  
ATOM   1237  CA  PHE   168      19.643  11.994  -6.629  1.00 53.28           C  
ATOM   1238  C   PHE   168      19.449  13.446  -6.169  1.00 53.86           C  
ATOM   1239  O   PHE   168      20.428  14.171  -5.955  1.00 56.61           O  
ATOM   1240  CB  PHE   168      20.742  11.946  -7.665  1.00 55.25           C  
ATOM   1241  CG  PHE   168      21.126  10.555  -8.061  1.00 60.38           C  
ATOM   1242  CD1 PHE   168      21.444   9.618  -7.095  1.00 55.13           C  
ATOM   1243  CD2 PHE   168      21.242  10.209  -9.403  1.00 64.34           C  
ATOM   1244  CE1 PHE   168      21.818   8.343  -7.445  1.00 62.51           C  
ATOM   1245  CE2 PHE   168      21.631   8.925  -9.766  1.00 65.66           C  
ATOM   1246  CZ  PHE   168      21.889   7.986  -8.783  1.00 61.09           C  
ATOM   1247  N   ASN   169      18.208  13.835  -5.936  1.00 50.08           N  
ATOM   1248  CA  ASN   169      17.913  15.167  -5.468  1.00 49.52           C  
ATOM   1249  C   ASN   169      16.835  15.097  -4.392  1.00 49.88           C  
ATOM   1250  O   ASN   169      15.668  14.786  -4.680  1.00 47.54           O  
ATOM   1251  CB  ASN   169      17.444  16.047  -6.615  1.00 50.62           C  
ATOM   1252  CG  ASN   169      17.304  17.487  -6.203  1.00 56.69           C  
ATOM   1253  OD1 ASN   169      16.187  17.970  -5.928  1.00 59.40           O  
ATOM   1254  ND2 ASN   169      18.438  18.169  -6.081  1.00 49.38           N  
ATOM   1255  N   GLY   170      17.250  15.344  -3.149  1.00 49.57           N  
ATOM   1256  CA  GLY   170      16.328  15.345  -2.010  1.00 48.89           C  
ATOM   1257  C   GLY   170      15.186  16.344  -2.083  1.00 50.94           C  
ATOM   1258  O   GLY   170      14.064  16.056  -1.634  1.00 54.52           O  
ATOM   1259  N   THR   171      15.461  17.532  -2.608  1.00 51.55           N  
ATOM   1260  CA  THR   171      14.452  18.594  -2.699  1.00 51.75           C  
ATOM   1261  C   THR   171      13.273  18.219  -3.600  1.00 48.23           C  
ATOM   1262  O   THR   171      12.120  18.396  -3.208  1.00 51.94           O  
ATOM   1263  CB  THR   171      15.096  19.923  -3.121  1.00 51.47           C  
ATOM   1264  OG1 THR   171      16.043  20.287  -2.117  1.00 54.73           O  
ATOM   1265  CG2 THR   171      14.038  21.044  -3.258  1.00 49.75           C  
ATOM   1266  N   CYS   172      13.551  17.705  -4.788  1.00 47.31           N  
ATOM   1267  CA  CYS   172      12.497  17.214  -5.672  1.00 50.28           C  
ATOM   1268  C   CYS   172      11.789  16.024  -5.055  1.00 50.89           C  
ATOM   1269  O   CYS   172      10.593  15.883  -5.205  1.00 52.21           O  
ATOM   1270  CB  CYS   172      13.058  16.770  -7.016  1.00 51.40           C  
ATOM   1271  SG  CYS   172      13.781  18.090  -7.952  1.00 62.23           S  
ATOM   1272  N   ASN   173      12.520  15.163  -4.345  1.00 51.55           N  
ATOM   1273  CA  ASN   173      11.874  14.014  -3.749  1.00 50.79           C  
ATOM   1274  C   ASN   173      10.907  14.494  -2.683  1.00 49.78           C  
ATOM   1275  O   ASN   173       9.780  14.000  -2.573  1.00 51.45           O  
ATOM   1276  CB  ASN   173      12.862  12.977  -3.160  1.00 48.42           C  
ATOM   1277  CG  ASN   173      12.263  11.591  -3.178  1.00 49.97           C  
ATOM   1278  OD1 ASN   173      12.061  11.052  -4.259  1.00 50.87           O  
ATOM   1279  ND2 ASN   173      11.912  11.032  -2.010  1.00 48.67           N  
ATOM   1280  N   TYR   174      11.345  15.473  -1.910  1.00 48.66           N  
ATOM   1281  CA  TYR   174      10.493  16.058  -0.873  1.00 49.81           C  
ATOM   1282  C   TYR   174       9.258  16.724  -1.488  1.00 48.59           C  
ATOM   1283  O   TYR   174       8.148  16.559  -1.001  1.00 48.45           O  
ATOM   1284  CB  TYR   174      11.280  17.093  -0.040  1.00 50.52           C  
ATOM   1285  CG  TYR   174      10.400  17.838   0.950  1.00 54.37           C  
ATOM   1286  CD1 TYR   174      10.127  17.311   2.196  1.00 49.94           C  
ATOM   1287  CD2 TYR   174       9.821  19.058   0.610  1.00 54.64           C  
ATOM   1288  CE1 TYR   174       9.282  17.977   3.083  1.00 58.48           C  
ATOM   1289  CE2 TYR   174       9.005  19.735   1.476  1.00 51.60           C  
ATOM   1290  CZ  TYR   174       8.726  19.194   2.719  1.00 57.19           C  
ATOM   1291  OH  TYR   174       7.888  19.867   3.593  1.00 55.85           O  
ATOM   1292  N   ILE   175       9.463  17.510  -2.541  1.00 50.25           N  
ATOM   1293  CA  ILE   175       8.360  18.244  -3.157  1.00 51.12           C  
ATOM   1294  C   ILE   175       7.298  17.276  -3.693  1.00 49.03           C  
ATOM   1295  O   ILE   175       6.111  17.472  -3.486  1.00 47.68           O  
ATOM   1296  CB  ILE   175       8.845  19.265  -4.238  1.00 50.51           C  
ATOM   1297  CG1 ILE   175       9.587  20.428  -3.556  1.00 56.75           C  
ATOM   1298  CG2 ILE   175       7.646  19.785  -5.041  1.00 50.40           C  
ATOM   1299  CD1 ILE   175      10.293  21.433  -4.496  1.00 52.24           C  
ATOM   1300  N   LEU   176       7.746  16.224  -4.356  1.00 50.24           N  
ATOM   1301  CA  LEU   176       6.846  15.197  -4.892  1.00 48.11           C  
ATOM   1302  C   LEU   176       6.146  14.396  -3.775  1.00 47.17           C  
ATOM   1303  O   LEU   176       4.947  14.184  -3.846  1.00 47.47           O  
ATOM   1304  CB  LEU   176       7.610  14.299  -5.857  1.00 46.39           C  
ATOM   1305  CG  LEU   176       8.149  14.968  -7.122  1.00 50.90           C  
ATOM   1306  CD1 LEU   176       9.070  14.008  -7.864  1.00 47.93           C  
ATOM   1307  CD2 LEU   176       6.983  15.471  -8.048  1.00 40.04           C  
ATOM   1308  N   SER   177       6.876  13.961  -2.747  1.00 48.51           N  
ATOM   1309  CA  SER   177       6.260  13.258  -1.586  1.00 50.08           C  
ATOM   1310  C   SER   177       5.239  14.115  -0.880  1.00 47.81           C  
ATOM   1311  O   SER   177       4.202  13.645  -0.454  1.00 48.79           O  
ATOM   1312  CB  SER   177       7.300  12.921  -0.525  1.00 50.57           C  
ATOM   1313  OG  SER   177       8.221  12.006  -1.027  1.00 61.77           O  
ATOM   1314  N   ARG   178       5.583  15.380  -0.719  1.00 48.42           N  
ATOM   1315  CA  ARG   178       4.713  16.333  -0.051  1.00 47.43           C  
ATOM   1316  C   ARG   178       3.465  16.603  -0.904  1.00 46.52           C  
ATOM   1317  O   ARG   178       2.338  16.681  -0.393  1.00 45.49           O  
ATOM   1318  CB  ARG   178       5.493  17.621   0.221  1.00 47.04           C  
ATOM   1319  CG  ARG   178       4.848  18.508   1.208  1.00 56.97           C  
ATOM   1320  CD  ARG   178       5.183  18.038   2.594  1.00 68.09           C  
ATOM   1321  NE  ARG   178       4.508  18.837   3.606  1.00 68.53           N  
ATOM   1322  CZ  ARG   178       3.527  18.390   4.384  1.00 75.35           C  
ATOM   1323  NH1 ARG   178       3.128  17.121   4.313  1.00 77.00           N  
ATOM   1324  NH2 ARG   178       2.968  19.210   5.274  1.00 71.97           N  
ATOM   1325  N   MET   179       3.658  16.766  -2.208  1.00 47.62           N  
ATOM   1326  CA  MET   179       2.519  16.939  -3.122  1.00 48.36           C  
ATOM   1327  C   MET   179       1.618  15.713  -3.112  1.00 48.14           C  
ATOM   1328  O   MET   179       0.399  15.833  -3.217  1.00 51.18           O  
ATOM   1329  CB  MET   179       3.000  17.205  -4.542  1.00 45.91           C  
ATOM   1330  CG  MET   179       1.840  17.597  -5.483  1.00 56.49           C  
ATOM   1331  SD  MET   179       2.441  18.167  -7.258  0.75 54.81          SE  
ATOM   1332  CE  MET   179       3.997  19.219  -6.628  1.00 45.84           C  
ATOM   1333  N   GLU   180       2.210  14.528  -3.009  1.00 50.05           N  
ATOM   1334  CA  GLU   180       1.427  13.294  -2.941  1.00 51.64           C  
ATOM   1335  C   GLU   180       0.542  13.294  -1.715  1.00 49.64           C  
ATOM   1336  O   GLU   180      -0.611  12.941  -1.776  1.00 52.27           O  
ATOM   1337  CB  GLU   180       2.357  12.069  -2.866  1.00 51.90           C  
ATOM   1338  CG  GLU   180       1.658  10.718  -2.586  1.00 55.71           C  
ATOM   1339  CD  GLU   180       0.995  10.086  -3.817  1.00 66.02           C  
ATOM   1340  OE1 GLU   180      -0.195  10.339  -4.091  1.00 63.96           O  
ATOM   1341  OE2 GLU   180       1.665   9.268  -4.479  1.00 73.52           O  
ATOM   1342  N   GLU   181       1.101  13.697  -0.590  1.00 51.44           N  
ATOM   1343  CA  GLU   181       0.395  13.645   0.684  1.00 52.99           C  
ATOM   1344  C   GLU   181      -0.657  14.751   0.851  1.00 50.86           C  
ATOM   1345  O   GLU   181      -1.810  14.491   1.236  1.00 51.34           O  
ATOM   1346  CB  GLU   181       1.436  13.741   1.807  1.00 52.57           C  
ATOM   1347  CG  GLU   181       0.877  13.620   3.202  1.00 57.00           C  
ATOM   1348  CD  GLU   181       1.872  14.069   4.266  1.00 61.56           C  
ATOM   1349  OE1 GLU   181       3.071  14.272   3.921  1.00 76.08           O  
ATOM   1350  OE2 GLU   181       1.440  14.230   5.443  1.00 74.24           O  
ATOM   1351  N   GLU   182      -0.250  15.985   0.578  1.00 48.88           N  
ATOM   1352  CA  GLU   182      -1.125  17.139   0.748  1.00 47.99           C  
ATOM   1353  C   GLU   182      -2.036  17.408  -0.428  1.00 45.65           C  
ATOM   1354  O   GLU   182      -3.071  17.995  -0.243  1.00 43.85           O  
ATOM   1355  CB  GLU   182      -0.299  18.401   0.986  1.00 48.49           C  
ATOM   1356  CG  GLU   182       0.459  18.450   2.284  1.00 49.55           C  
ATOM   1357  CD  GLU   182       1.087  19.809   2.486  1.00 49.39           C  
ATOM   1358  OE1 GLU   182       2.133  20.060   1.866  1.00 57.73           O  
ATOM   1359  OE2 GLU   182       0.523  20.637   3.252  1.00 63.87           O  
ATOM   1360  N   ARG   183      -1.627  17.016  -1.635  1.00 47.50           N  
ATOM   1361  CA  ARG   183      -2.409  17.260  -2.848  1.00 46.60           C  
ATOM   1362  C   ARG   183      -2.627  18.761  -3.060  1.00 46.49           C  
ATOM   1363  O   ARG   183      -3.739  19.197  -3.345  1.00 45.39           O  
ATOM   1364  CB  ARG   183      -3.746  16.526  -2.785  1.00 46.84           C  
ATOM   1365  CG  ARG   183      -3.667  14.996  -2.917  1.00 50.98           C  
ATOM   1366  CD  ARG   183      -3.969  14.539  -4.367  1.00 60.13           C  
ATOM   1367  NE  ARG   183      -4.200  13.094  -4.504  1.00 49.76           N  
ATOM   1368  CZ  ARG   183      -3.221  12.221  -4.391  1.00 47.02           C  
ATOM   1369  NH1 ARG   183      -2.019  12.672  -4.106  1.00 42.53           N  
ATOM   1370  NH2 ARG   183      -3.439  10.925  -4.523  1.00 48.32           N  
ATOM   1371  N   LEU   184      -1.560  19.549  -2.937  1.00 46.90           N  
ATOM   1372  CA  LEU   184      -1.668  20.996  -3.130  1.00 48.03           C  
ATOM   1373  C   LEU   184      -0.774  21.392  -4.292  1.00 47.57           C  
ATOM   1374  O   LEU   184       0.155  20.676  -4.603  1.00 46.62           O  
ATOM   1375  CB  LEU   184      -1.320  21.766  -1.847  1.00 48.11           C  
ATOM   1376  CG  LEU   184      -2.272  21.591  -0.657  1.00 45.33           C  
ATOM   1377  CD1 LEU   184      -1.624  22.116   0.616  1.00 46.80           C  
ATOM   1378  CD2 LEU   184      -3.630  22.262  -0.909  1.00 42.37           C  
ATOM   1379  N   PRO   185      -1.075  22.524  -4.956  1.00 49.82           N  
ATOM   1380  CA  PRO   185      -0.326  22.941  -6.135  1.00 49.73           C  
ATOM   1381  C   PRO   185       1.167  23.068  -5.930  1.00 50.62           C  
ATOM   1382  O   PRO   185       1.633  23.337  -4.819  1.00 52.62           O  
ATOM   1383  CB  PRO   185      -0.927  24.310  -6.469  1.00 49.87           C  
ATOM   1384  CG  PRO   185      -2.269  24.269  -5.920  1.00 49.71           C  
ATOM   1385  CD  PRO   185      -2.161  23.473  -4.657  1.00 49.76           C  
ATOM   1386  N   TYR   186       1.906  22.900  -7.019  1.00 49.39           N  
ATOM   1387  CA  TYR   186       3.342  23.010  -6.975  1.00 49.71           C  
ATOM   1388  C   TYR   186       3.824  24.304  -6.315  1.00 48.74           C  
ATOM   1389  O   TYR   186       4.752  24.261  -5.496  1.00 49.05           O  
ATOM   1390  CB  TYR   186       3.951  22.845  -8.398  1.00 50.69           C  
ATOM   1391  CG  TYR   186       5.397  23.260  -8.475  1.00 51.42           C  
ATOM   1392  CD1 TYR   186       6.405  22.412  -8.061  1.00 51.78           C  
ATOM   1393  CD2 TYR   186       5.748  24.536  -8.926  1.00 54.64           C  
ATOM   1394  CE1 TYR   186       7.726  22.810  -8.111  1.00 56.91           C  
ATOM   1395  CE2 TYR   186       7.056  24.945  -8.961  1.00 49.56           C  
ATOM   1396  CZ  TYR   186       8.039  24.084  -8.555  1.00 52.76           C  
ATOM   1397  OH  TYR   186       9.349  24.487  -8.606  1.00 57.36           O  
ATOM   1398  N   GLU   187       3.229  25.443  -6.692  1.00 49.83           N  
ATOM   1399  CA  GLU   187       3.615  26.773  -6.155  1.00 50.15           C  
ATOM   1400  C   GLU   187       3.642  26.798  -4.611  1.00 50.21           C  
ATOM   1401  O   GLU   187       4.594  27.299  -4.002  1.00 50.99           O  
ATOM   1402  CB  GLU   187       2.692  27.871  -6.712  1.00 49.73           C  
ATOM   1403  N   HIS   188       2.601  26.220  -4.009  1.00 50.31           N  
ATOM   1404  CA  HIS   188       2.453  26.097  -2.565  1.00 50.29           C  
ATOM   1405  C   HIS   188       3.445  25.125  -1.913  1.00 50.89           C  
ATOM   1406  O   HIS   188       4.006  25.447  -0.865  1.00 49.57           O  
ATOM   1407  CB  HIS   188       1.049  25.611  -2.243  1.00 51.54           C  
ATOM   1408  CG  HIS   188       0.729  25.625  -0.782  1.00 57.63           C  
ATOM   1409  ND1 HIS   188       1.225  24.686   0.098  1.00 61.10           N  
ATOM   1410  CD2 HIS   188      -0.056  26.450  -0.049  1.00 58.91           C  
ATOM   1411  CE1 HIS   188       0.774  24.943   1.312  1.00 57.63           C  
ATOM   1412  NE2 HIS   188      -0.012  26.003   1.250  1.00 60.26           N  
ATOM   1413  N   ILE   189       3.653  23.941  -2.506  1.00 50.32           N  
ATOM   1414  CA  ILE   189       4.562  22.950  -1.921  1.00 50.34           C  
ATOM   1415  C   ILE   189       5.993  23.477  -2.014  1.00 53.25           C  
ATOM   1416  O   ILE   189       6.816  23.219  -1.131  1.00 54.26           O  
ATOM   1417  CB  ILE   189       4.474  21.550  -2.589  1.00 50.20           C  
ATOM   1418  CG1 ILE   189       3.048  20.984  -2.564  1.00 53.02           C  
ATOM   1419  CG2 ILE   189       5.414  20.583  -1.911  1.00 48.21           C  
ATOM   1420  CD1 ILE   189       2.486  20.718  -1.189  1.00 50.90           C  
ATOM   1421  N   LEU   190       6.301  24.195  -3.094  1.00 54.47           N  
ATOM   1422  CA  LEU   190       7.611  24.836  -3.241  1.00 54.56           C  
ATOM   1423  C   LEU   190       7.853  25.850  -2.119  1.00 56.21           C  
ATOM   1424  O   LEU   190       8.951  25.913  -1.591  1.00 55.77           O  
ATOM   1425  CB  LEU   190       7.738  25.529  -4.594  1.00 53.43           C  
ATOM   1426  CG  LEU   190       8.984  26.378  -4.847  1.00 53.95           C  
ATOM   1427  CD1 LEU   190      10.191  25.499  -4.858  1.00 54.46           C  
ATOM   1428  CD2 LEU   190       8.878  27.181  -6.145  1.00 53.20           C  
ATOM   1429  N   LYS   191       6.836  26.643  -1.764  1.00 59.35           N  
ATOM   1430  CA  LYS   191       6.970  27.625  -0.664  1.00 59.85           C  
ATOM   1431  C   LYS   191       7.256  26.942   0.675  1.00 62.71           C  
ATOM   1432  O   LYS   191       8.009  27.478   1.487  1.00 65.04           O  
ATOM   1433  CB  LYS   191       5.760  28.544  -0.565  1.00 59.39           C  
ATOM   1434  CG  LYS   191       5.594  29.462  -1.764  1.00 62.81           C  
ATOM   1435  N   GLU   192       6.667  25.766   0.901  1.00 64.24           N  
ATOM   1436  CA  GLU   192       6.983  24.973   2.093  1.00 65.95           C  
ATOM   1437  C   GLU   192       8.445  24.528   2.004  1.00 65.32           C  
ATOM   1438  O   GLU   192       9.215  24.662   2.951  1.00 66.59           O  
ATOM   1439  CB  GLU   192       6.114  23.722   2.189  1.00 66.21           C  
ATOM   1440  CG  GLU   192       4.627  23.967   2.325  1.00 68.09           C  
ATOM   1441  CD  GLU   192       3.848  22.657   2.393  1.00 68.34           C  
ATOM   1442  OE1 GLU   192       4.186  21.795   3.237  1.00 68.68           O  
ATOM   1443  OE2 GLU   192       2.892  22.493   1.604  1.00 72.99           O  
ATOM   1444  N   ALA   193       8.822  23.990   0.850  1.00 64.18           N  
ATOM   1445  CA  ALA   193      10.191  23.554   0.631  1.00 64.49           C  
ATOM   1446  C   ALA   193      11.188  24.699   0.926  1.00 65.36           C  
ATOM   1447  O   ALA   193      12.274  24.479   1.480  1.00 66.60           O  
ATOM   1448  CB  ALA   193      10.356  23.036  -0.788  1.00 63.88           C  
ATOM   1449  N   GLN   194      10.806  25.913   0.556  1.00 64.64           N  
ATOM   1450  CA  GLN   194      11.630  27.088   0.789  1.00 64.41           C  
ATOM   1451  C   GLN   194      11.662  27.458   2.279  1.00 65.12           C  
ATOM   1452  O   GLN   194      12.744  27.704   2.823  1.00 61.97           O  
ATOM   1453  CB  GLN   194      11.180  28.244  -0.123  1.00 63.16           C  
ATOM   1454  CG  GLN   194      11.572  27.983  -1.600  1.00 61.72           C  
ATOM   1455  CD  GLN   194      10.958  28.958  -2.585  1.00 58.96           C  
ATOM   1456  OE1 GLN   194       9.811  29.344  -2.449  1.00 49.46           O  
ATOM   1457  NE2 GLN   194      11.717  29.329  -3.605  1.00 50.16           N  
ATOM   1458  N   GLU   195      10.498  27.457   2.935  1.00 67.33           N  
ATOM   1459  CA  GLU   195      10.419  27.725   4.380  1.00 68.56           C  
ATOM   1460  C   GLU   195      11.315  26.735   5.150  1.00 70.71           C  
ATOM   1461  O   GLU   195      12.058  27.136   6.042  1.00 73.46           O  
ATOM   1462  CB  GLU   195       8.969  27.668   4.888  1.00 67.50           C  
ATOM   1463  N   LEU   196      11.272  25.456   4.781  1.00 72.16           N  
ATOM   1464  CA  LEU   196      12.104  24.409   5.424  1.00 71.93           C  
ATOM   1465  C   LEU   196      13.613  24.514   5.119  1.00 72.29           C  
ATOM   1466  O   LEU   196      14.428  23.867   5.782  1.00 72.44           O  
ATOM   1467  CB  LEU   196      11.602  23.001   5.032  1.00 72.75           C  
ATOM   1468  CG  LEU   196      10.386  22.463   5.785  1.00 73.55           C  
ATOM   1469  CD1 LEU   196      10.794  22.218   7.234  1.00 71.91           C  
ATOM   1470  CD2 LEU   196       9.164  23.396   5.711  1.00 80.49           C  
ATOM   1471  N   GLY   197      13.974  25.299   4.103  1.00 71.91           N  
ATOM   1472  CA  GLY   197      15.365  25.504   3.721  1.00 69.37           C  
ATOM   1473  C   GLY   197      15.841  24.542   2.662  1.00 71.28           C  
ATOM   1474  O   GLY   197      17.023  24.568   2.284  1.00 71.05           O  
ATOM   1475  N   TYR   198      14.943  23.690   2.158  1.00 71.91           N  
ATOM   1476  CA  TYR   198      15.350  22.701   1.151  1.00 70.29           C  
ATOM   1477  C   TYR   198      15.620  23.320  -0.211  1.00 68.90           C  
ATOM   1478  O   TYR   198      16.493  22.848  -0.935  1.00 69.01           O  
ATOM   1479  CB  TYR   198      14.334  21.569   1.003  1.00 70.32           C  
ATOM   1480  CG  TYR   198      14.013  20.843   2.282  1.00 71.40           C  
ATOM   1481  CD1 TYR   198      14.969  20.670   3.280  1.00 71.74           C  
ATOM   1482  CD2 TYR   198      12.770  20.255   2.460  1.00 70.09           C  
ATOM   1483  CE1 TYR   198      14.658  19.993   4.454  1.00 73.66           C  
ATOM   1484  CE2 TYR   198      12.463  19.571   3.610  1.00 69.46           C  
ATOM   1485  CZ  TYR   198      13.404  19.438   4.607  1.00 71.92           C  
ATOM   1486  OH  TYR   198      13.069  18.758   5.765  1.00 73.80           O  
ATOM   1487  N   ALA   199      14.862  24.357  -0.556  1.00 68.19           N  
ATOM   1488  CA  ALA   199      15.021  25.035  -1.829  1.00 66.85           C  
ATOM   1489  C   ALA   199      15.321  26.524  -1.634  1.00 66.32           C  
ATOM   1490  O   ALA   199      14.768  27.161  -0.738  1.00 64.86           O  
ATOM   1491  CB  ALA   199      13.753  24.841  -2.687  1.00 67.08           C  
ATOM   1492  N   GLU   200      16.197  27.053  -2.488  1.00 65.83           N  
ATOM   1493  CA  GLU   200      16.566  28.461  -2.496  1.00 67.83           C  
ATOM   1494  C   GLU   200      15.466  29.277  -3.185  1.00 68.19           C  
ATOM   1495  O   GLU   200      14.520  28.705  -3.757  1.00 65.69           O  
ATOM   1496  CB  GLU   200      17.908  28.669  -3.225  1.00 67.97           C  
ATOM   1497  CG  GLU   200      19.120  27.995  -2.549  1.00 72.33           C  
ATOM   1498  CD  GLU   200      20.349  27.924  -3.451  1.00 69.69           C  
ATOM   1499  N   ALA   201      15.607  30.610  -3.111  1.00 68.46           N  
ATOM   1500  CA  ALA   201      14.672  31.576  -3.717  1.00 68.54           C  
ATOM   1501  C   ALA   201      14.496  31.297  -5.200  1.00 68.47           C  
ATOM   1502  O   ALA   201      13.428  31.519  -5.758  1.00 68.13           O  
ATOM   1503  CB  ALA   201      15.165  33.006  -3.506  1.00 68.07           C  
ATOM   1504  N   ASP   202      15.586  30.866  -5.831  1.00 69.18           N  
ATOM   1505  CA  ASP   202      15.580  30.368  -7.202  1.00 68.04           C  
ATOM   1506  C   ASP   202      15.849  28.869  -7.019  1.00 64.63           C  
ATOM   1507  O   ASP   202      16.992  28.476  -6.817  1.00 62.25           O  
ATOM   1508  CB  ASP   202      16.676  31.025  -8.048  1.00 70.21           C  
ATOM   1509  CG  ASP   202      16.945  30.266  -9.352  1.00 79.05           C  
ATOM   1510  OD1 ASP   202      15.961  29.692  -9.892  1.00 78.98           O  
ATOM   1511  OD2 ASP   202      18.133  30.242  -9.813  1.00 76.93           O  
ATOM   1512  N   PRO   203      14.789  28.034  -7.056  1.00 63.72           N  
ATOM   1513  CA  PRO   203      14.898  26.580  -6.832  1.00 61.75           C  
ATOM   1514  C   PRO   203      15.229  25.740  -8.078  1.00 59.45           C  
ATOM   1515  O   PRO   203      15.237  24.521  -7.998  1.00 59.32           O  
ATOM   1516  CB  PRO   203      13.482  26.233  -6.353  1.00 61.07           C  
ATOM   1517  CG  PRO   203      12.622  27.105  -7.172  1.00 59.95           C  
ATOM   1518  CD  PRO   203      13.390  28.413  -7.351  1.00 63.64           C  
ATOM   1519  N   SER   204      15.447  26.412  -9.201  1.00 58.82           N  
ATOM   1520  CA  SER   204      15.723  25.858 -10.537  1.00 60.32           C  
ATOM   1521  C   SER   204      16.726  24.693 -10.641  1.00 58.74           C  
ATOM   1522  O   SER   204      16.479  23.682 -11.315  1.00 57.35           O  
ATOM   1523  CB  SER   204      16.203  27.042 -11.401  1.00 61.40           C  
ATOM   1524  OG  SER   204      16.597  26.650 -12.692  1.00 74.01           O  
ATOM   1525  N   TYR   205      17.871  24.859  -9.996  1.00 58.63           N  
ATOM   1526  CA  TYR   205      18.929  23.844  -9.958  1.00 58.51           C  
ATOM   1527  C   TYR   205      18.345  22.511  -9.489  1.00 56.16           C  
ATOM   1528  O   TYR   205      18.691  21.463 -10.007  1.00 52.02           O  
ATOM   1529  CB  TYR   205      20.009  24.334  -9.021  1.00 59.98           C  
ATOM   1530  CG  TYR   205      21.303  23.546  -8.918  1.00 66.63           C  
ATOM   1531  CD1 TYR   205      22.284  23.633  -9.926  1.00 58.78           C  
ATOM   1532  CD2 TYR   205      21.608  22.819  -7.744  1.00 69.11           C  
ATOM   1533  CE1 TYR   205      23.504  22.973  -9.798  1.00 64.53           C  
ATOM   1534  CE2 TYR   205      22.837  22.125  -7.610  1.00 68.87           C  
ATOM   1535  CZ  TYR   205      23.773  22.215  -8.639  1.00 71.51           C  
ATOM   1536  OH  TYR   205      24.970  21.573  -8.495  1.00 70.59           O  
ATOM   1537  N   ASP   206      17.409  22.570  -8.543  1.00 55.98           N  
ATOM   1538  CA  ASP   206      16.725  21.382  -8.071  1.00 54.69           C  
ATOM   1539  C   ASP   206      15.564  21.016  -8.983  1.00 54.42           C  
ATOM   1540  O   ASP   206      15.590  19.965  -9.606  1.00 54.38           O  
ATOM   1541  CB  ASP   206      16.173  21.563  -6.643  1.00 54.91           C  
ATOM   1542  CG  ASP   206      17.258  21.735  -5.592  1.00 55.86           C  
ATOM   1543  OD1 ASP   206      18.302  21.060  -5.674  1.00 61.04           O  
ATOM   1544  OD2 ASP   206      17.034  22.521  -4.645  1.00 64.32           O  
ATOM   1545  N   VAL   207      14.548  21.884  -9.040  1.00 52.94           N  
ATOM   1546  CA  VAL   207      13.286  21.567  -9.714  1.00 51.67           C  
ATOM   1547  C   VAL   207      13.301  21.354 -11.232  1.00 52.00           C  
ATOM   1548  O   VAL   207      12.367  20.748 -11.769  1.00 52.24           O  
ATOM   1549  CB  VAL   207      12.123  22.512  -9.272  1.00 52.21           C  
ATOM   1550  CG1 VAL   207      12.009  22.472  -7.741  1.00 45.97           C  
ATOM   1551  CG2 VAL   207      12.271  23.948  -9.823  1.00 47.72           C  
ATOM   1552  N   GLU   208      14.331  21.858 -11.911  1.00 52.85           N  
ATOM   1553  CA  GLU   208      14.482  21.642 -13.345  1.00 54.65           C  
ATOM   1554  C   GLU   208      15.363  20.399 -13.623  1.00 54.89           C  
ATOM   1555  O   GLU   208      15.709  20.113 -14.770  1.00 54.82           O  
ATOM   1556  CB  GLU   208      15.072  22.879 -14.037  1.00 52.72           C  
ATOM   1557  CG  GLU   208      14.282  24.159 -13.869  1.00 52.72           C  
ATOM   1558  CD  GLU   208      12.881  24.099 -14.478  1.00 53.88           C  
ATOM   1559  OE1 GLU   208      12.543  23.109 -15.164  1.00 50.07           O  
ATOM   1560  OE2 GLU   208      12.117  25.068 -14.280  1.00 57.93           O  
ATOM   1561  N   GLY   209      15.743  19.687 -12.565  1.00 56.82           N  
ATOM   1562  CA  GLY   209      16.528  18.452 -12.688  1.00 55.27           C  
ATOM   1563  C   GLY   209      18.003  18.604 -12.995  1.00 54.85           C  
ATOM   1564  O   GLY   209      18.652  17.625 -13.323  1.00 55.73           O  
ATOM   1565  N   ILE   210      18.542  19.821 -12.861  1.00 54.76           N  
ATOM   1566  CA  ILE   210      19.938  20.078 -13.186  1.00 54.36           C  
ATOM   1567  C   ILE   210      20.869  19.337 -12.215  1.00 53.25           C  
ATOM   1568  O   ILE   210      21.816  18.673 -12.622  1.00 52.64           O  
ATOM   1569  CB  ILE   210      20.291  21.605 -13.141  1.00 52.69           C  
ATOM   1570  CG1 ILE   210      19.380  22.462 -14.046  1.00 59.17           C  
ATOM   1571  CG2 ILE   210      21.751  21.828 -13.472  1.00 49.21           C  
ATOM   1572  CD1 ILE   210      19.444  22.148 -15.502  1.00 66.10           C  
ATOM   1573  N   ASP   211      20.618  19.479 -10.921  1.00 54.09           N  
ATOM   1574  CA  ASP   211      21.428  18.807  -9.892  1.00 51.97           C  
ATOM   1575  C   ASP   211      21.493  17.301 -10.113  1.00 49.67           C  
ATOM   1576  O   ASP   211      22.586  16.702 -10.113  1.00 51.24           O  
ATOM   1577  CB  ASP   211      20.846  19.123  -8.512  1.00 53.71           C  
ATOM   1578  CG  ASP   211      21.631  18.481  -7.370  1.00 55.47           C  
ATOM   1579  OD1 ASP   211      22.812  18.853  -7.180  1.00 55.59           O  
ATOM   1580  OD2 ASP   211      21.033  17.648  -6.633  1.00 58.46           O  
ATOM   1581  N   ALA   212      20.327  16.679 -10.309  1.00 48.11           N  
ATOM   1582  CA  ALA   212      20.238  15.237 -10.529  1.00 45.99           C  
ATOM   1583  C   ALA   212      21.009  14.799 -11.795  1.00 46.22           C  
ATOM   1584  O   ALA   212      21.658  13.743 -11.797  1.00 48.01           O  
ATOM   1585  CB  ALA   212      18.789  14.778 -10.612  1.00 43.79           C  
ATOM   1586  N   ALA   213      20.930  15.613 -12.836  1.00 43.54           N  
ATOM   1587  CA  ALA   213      21.603  15.326 -14.133  1.00 45.45           C  
ATOM   1588  C   ALA   213      23.138  15.428 -14.047  1.00 45.51           C  
ATOM   1589  O   ALA   213      23.840  14.670 -14.675  1.00 48.79           O  
ATOM   1590  CB  ALA   213      21.073  16.230 -15.185  1.00 42.66           C  
ATOM   1591  N   LEU   214      23.642  16.435 -13.335  1.00 46.63           N  
ATOM   1592  CA  LEU   214      25.075  16.566 -13.043  1.00 45.43           C  
ATOM   1593  C   LEU   214      25.588  15.300 -12.366  1.00 46.14           C  
ATOM   1594  O   LEU   214      26.591  14.722 -12.778  1.00 49.16           O  
ATOM   1595  CB  LEU   214      25.324  17.796 -12.168  1.00 48.56           C  
ATOM   1596  CG  LEU   214      25.104  19.180 -12.854  1.00 53.32           C  
ATOM   1597  CD1 LEU   214      25.037  20.368 -11.881  1.00 43.38           C  
ATOM   1598  CD2 LEU   214      26.140  19.444 -13.913  1.00 50.20           C  
ATOM   1599  N   LYS   215      24.876  14.864 -11.331  1.00 46.82           N  
ATOM   1600  CA  LYS   215      25.162  13.647 -10.580  1.00 45.75           C  
ATOM   1601  C   LYS   215      25.074  12.405 -11.442  1.00 47.88           C  
ATOM   1602  O   LYS   215      25.912  11.521 -11.321  1.00 49.56           O  
ATOM   1603  CB  LYS   215      24.183  13.547  -9.403  1.00 45.01           C  
ATOM   1604  CG  LYS   215      24.509  14.589  -8.295  1.00 50.10           C  
ATOM   1605  CD  LYS   215      23.415  14.675  -7.203  1.00 47.84           C  
ATOM   1606  CE  LYS   215      23.750  15.716  -6.145  1.00 48.71           C  
ATOM   1607  NZ  LYS   215      22.596  15.971  -5.201  1.00 46.57           N  
ATOM   1608  N   LEU   216      24.074  12.350 -12.327  1.00 47.48           N  
ATOM   1609  CA  LEU   216      23.907  11.245 -13.264  1.00 45.00           C  
ATOM   1610  C   LEU   216      25.121  11.167 -14.163  1.00 45.39           C  
ATOM   1611  O   LEU   216      25.597  10.072 -14.432  1.00 45.92           O  
ATOM   1612  CB  LEU   216      22.619  11.407 -14.114  1.00 43.78           C  
ATOM   1613  CG  LEU   216      22.337  10.265 -15.126  1.00 49.21           C  
ATOM   1614  CD1 LEU   216      22.286   8.883 -14.438  1.00 48.68           C  
ATOM   1615  CD2 LEU   216      21.096  10.551 -15.976  1.00 46.60           C  
ATOM   1616  N   VAL   217      25.642  12.313 -14.619  1.00 45.94           N  
ATOM   1617  CA  VAL   217      26.867  12.291 -15.450  1.00 47.16           C  
ATOM   1618  C   VAL   217      28.091  11.698 -14.696  1.00 47.12           C  
ATOM   1619  O   VAL   217      28.905  10.941 -15.254  1.00 45.73           O  
ATOM   1620  CB  VAL   217      27.214  13.691 -16.050  1.00 50.11           C  
ATOM   1621  CG1 VAL   217      28.552  13.659 -16.786  1.00 47.66           C  
ATOM   1622  CG2 VAL   217      26.103  14.167 -17.012  1.00 49.14           C  
ATOM   1623  N   ILE   218      28.220  12.056 -13.433  1.00 47.15           N  
ATOM   1624  CA  ILE   218      29.319  11.568 -12.622  1.00 48.08           C  
ATOM   1625  C   ILE   218      29.211  10.046 -12.488  1.00 47.79           C  
ATOM   1626  O   ILE   218      30.167   9.343 -12.742  1.00 48.88           O  
ATOM   1627  CB  ILE   218      29.338  12.277 -11.269  1.00 45.60           C  
ATOM   1628  CG1 ILE   218      29.710  13.744 -11.498  1.00 49.59           C  
ATOM   1629  CG2 ILE   218      30.280  11.563 -10.283  1.00 49.52           C  
ATOM   1630  CD1 ILE   218      29.738  14.603 -10.283  1.00 46.99           C  
ATOM   1631  N   ILE   219      28.019   9.559 -12.152  1.00 47.86           N  
ATOM   1632  CA  ILE   219      27.752   8.136 -12.022  1.00 47.51           C  
ATOM   1633  C   ILE   219      27.966   7.329 -13.304  1.00 48.65           C  
ATOM   1634  O   ILE   219      28.525   6.247 -13.254  1.00 46.75           O  
ATOM   1635  CB  ILE   219      26.325   7.884 -11.565  1.00 47.39           C  
ATOM   1636  CG1 ILE   219      26.167   8.369 -10.142  1.00 54.24           C  
ATOM   1637  CG2 ILE   219      26.008   6.405 -11.579  1.00 46.64           C  
ATOM   1638  CD1 ILE   219      24.762   8.300  -9.693  1.00 67.32           C  
ATOM   1639  N   ALA   220      27.448   7.840 -14.420  1.00 49.50           N  
ATOM   1640  CA  ALA   220      27.589   7.210 -15.733  1.00 47.31           C  
ATOM   1641  C   ALA   220      29.053   6.992 -15.974  1.00 46.34           C  
ATOM   1642  O   ALA   220      29.476   5.900 -16.280  1.00 48.33           O  
ATOM   1643  CB  ALA   220      26.996   8.113 -16.830  1.00 46.80           C  
ATOM   1644  N   ASN   221      29.841   8.045 -15.835  1.00 49.27           N  
ATOM   1645  CA  ASN   221      31.275   7.937 -16.036  1.00 49.43           C  
ATOM   1646  C   ASN   221      31.992   6.989 -15.073  1.00 48.47           C  
ATOM   1647  O   ASN   221      32.946   6.296 -15.464  1.00 48.69           O  
ATOM   1648  CB  ASN   221      31.919   9.332 -15.988  1.00 52.71           C  
ATOM   1649  CG  ASN   221      31.734  10.109 -17.297  1.00 54.77           C  
ATOM   1650  OD1 ASN   221      32.409   9.834 -18.299  1.00 55.54           O  
ATOM   1651  ND2 ASN   221      30.865  11.117 -17.269  1.00 51.91           N  
ATOM   1652  N   THR   222      31.556   6.979 -13.818  1.00 49.74           N  
ATOM   1653  CA  THR   222      32.152   6.126 -12.781  1.00 48.37           C  
ATOM   1654  C   THR   222      31.970   4.642 -13.142  1.00 47.02           C  
ATOM   1655  O   THR   222      32.849   3.842 -12.910  1.00 50.70           O  
ATOM   1656  CB  THR   222      31.548   6.442 -11.365  1.00 49.83           C  
ATOM   1657  OG1 THR   222      31.871   7.791 -10.976  1.00 47.96           O  
ATOM   1658  CG2 THR   222      32.084   5.501 -10.322  1.00 47.19           C  
ATOM   1659  N   ILE   223      30.841   4.296 -13.743  1.00 48.55           N  
ATOM   1660  CA  ILE   223      30.549   2.926 -14.121  1.00 48.58           C  
ATOM   1661  C   ILE   223      31.020   2.587 -15.542  1.00 49.45           C  
ATOM   1662  O   ILE   223      30.683   1.518 -16.068  1.00 50.54           O  
ATOM   1663  CB  ILE   223      29.035   2.536 -13.963  1.00 49.21           C  
ATOM   1664  CG1 ILE   223      28.150   3.202 -15.036  1.00 53.85           C  
ATOM   1665  CG2 ILE   223      28.507   2.838 -12.521  1.00 42.11           C  
ATOM   1666  CD1 ILE   223      26.711   2.618 -15.127  1.00 44.95           C  
ATOM   1667  N   GLY   224      31.784   3.468 -16.171  1.00 48.78           N  
ATOM   1668  CA  GLY   224      32.353   3.156 -17.506  1.00 47.84           C  
ATOM   1669  C   GLY   224      31.582   3.624 -18.721  1.00 49.39           C  
ATOM   1670  O   GLY   224      31.932   3.253 -19.834  1.00 50.20           O  
ATOM   1671  N   VAL   225      30.521   4.409 -18.523  1.00 50.37           N  
ATOM   1672  CA  VAL   225      29.749   4.972 -19.631  1.00 51.28           C  
ATOM   1673  C   VAL   225      30.218   6.425 -19.850  1.00 53.00           C  
ATOM   1674  O   VAL   225      29.899   7.310 -19.063  1.00 53.69           O  
ATOM   1675  CB  VAL   225      28.242   4.906 -19.342  1.00 52.17           C  
ATOM   1676  CG1 VAL   225      27.435   5.576 -20.441  1.00 52.80           C  
ATOM   1677  CG2 VAL   225      27.783   3.424 -19.177  1.00 48.22           C  
ATOM   1678  N   LYS   226      31.046   6.658 -20.870  1.00 52.56           N  
ATOM   1679  CA  LYS   226      31.503   8.019 -21.182  1.00 52.99           C  
ATOM   1680  C   LYS   226      30.235   8.850 -21.450  1.00 54.80           C  
ATOM   1681  O   LYS   226      29.377   8.462 -22.244  1.00 59.18           O  
ATOM   1682  CB  LYS   226      32.445   8.028 -22.396  1.00 48.62           C  
ATOM   1683  N   ALA   227      30.079   9.956 -20.747  1.00 53.19           N  
ATOM   1684  CA  ALA   227      28.902  10.780 -20.915  1.00 51.60           C  
ATOM   1685  C   ALA   227      29.222  12.223 -20.595  1.00 50.01           C  
ATOM   1686  O   ALA   227      30.017  12.500 -19.713  1.00 47.38           O  
ATOM   1687  CB  ALA   227      27.754  10.282 -19.982  1.00 48.88           C  
ATOM   1688  N   SER   228      28.600  13.137 -21.337  1.00 51.41           N  
ATOM   1689  CA  SER   228      28.678  14.567 -21.064  1.00 51.50           C  
ATOM   1690  C   SER   228      27.276  15.047 -20.658  1.00 48.76           C  
ATOM   1691  O   SER   228      26.305  14.323 -20.819  1.00 47.86           O  
ATOM   1692  CB  SER   228      29.170  15.301 -22.300  1.00 52.99           C  
ATOM   1693  OG  SER   228      28.314  15.003 -23.387  1.00 69.90           O  
ATOM   1694  N   TYR   229      27.171  16.252 -20.107  1.00 48.74           N  
ATOM   1695  CA  TYR   229      25.865  16.800 -19.734  1.00 48.29           C  
ATOM   1696  C   TYR   229      24.890  16.855 -20.940  1.00 48.25           C  
ATOM   1697  O   TYR   229      23.708  16.575 -20.798  1.00 47.01           O  
ATOM   1698  CB  TYR   229      26.006  18.203 -19.101  1.00 48.01           C  
ATOM   1699  CG  TYR   229      24.718  18.650 -18.473  1.00 49.61           C  
ATOM   1700  CD1 TYR   229      23.719  19.281 -19.229  1.00 48.16           C  
ATOM   1701  CD2 TYR   229      24.476  18.403 -17.128  1.00 47.46           C  
ATOM   1702  CE1 TYR   229      22.505  19.635 -18.642  1.00 47.96           C  
ATOM   1703  CE2 TYR   229      23.302  18.771 -16.549  1.00 46.96           C  
ATOM   1704  CZ  TYR   229      22.322  19.384 -17.303  1.00 47.60           C  
ATOM   1705  OH  TYR   229      21.150  19.690 -16.687  1.00 48.70           O  
ATOM   1706  N   GLU   230      25.390  17.199 -22.125  1.00 46.91           N  
ATOM   1707  CA  GLU   230      24.523  17.360 -23.279  1.00 51.69           C  
ATOM   1708  C   GLU   230      23.897  16.068 -23.740  1.00 51.62           C  
ATOM   1709  O   GLU   230      22.951  16.115 -24.529  1.00 52.91           O  
ATOM   1710  CB  GLU   230      25.267  17.991 -24.449  1.00 52.98           C  
ATOM   1711  CG  GLU   230      26.377  17.113 -25.003  1.00 59.12           C  
ATOM   1712  CD  GLU   230      27.116  17.758 -26.156  1.00 60.66           C  
ATOM   1713  OE1 GLU   230      26.703  18.862 -26.588  1.00 64.84           O  
ATOM   1714  OE2 GLU   230      28.104  17.141 -26.621  1.00 73.65           O  
ATOM   1715  N   ASP   231      24.432  14.936 -23.271  1.00 49.16           N  
ATOM   1716  CA  ASP   231      23.905  13.619 -23.603  1.00 48.16           C  
ATOM   1717  C   ASP   231      22.683  13.247 -22.771  1.00 47.73           C  
ATOM   1718  O   ASP   231      21.976  12.344 -23.136  1.00 48.39           O  
ATOM   1719  CB  ASP   231      24.976  12.526 -23.385  1.00 46.15           C  
ATOM   1720  CG  ASP   231      26.167  12.665 -24.301  1.00 51.11           C  
ATOM   1721  OD1 ASP   231      25.989  13.031 -25.473  1.00 60.41           O  
ATOM   1722  OD2 ASP   231      27.292  12.419 -23.848  1.00 54.74           O  
ATOM   1723  N   VAL   232      22.452  13.914 -21.642  1.00 48.20           N  
ATOM   1724  CA  VAL   232      21.338  13.577 -20.752  1.00 47.24           C  
ATOM   1725  C   VAL   232      20.055  14.265 -21.206  1.00 49.91           C  
ATOM   1726  O   VAL   232      20.080  15.431 -21.577  1.00 51.25           O  
ATOM   1727  CB  VAL   232      21.631  14.023 -19.295  1.00 50.55           C  
ATOM   1728  CG1 VAL   232      20.552  13.483 -18.336  1.00 41.85           C  
ATOM   1729  CG2 VAL   232      23.044  13.579 -18.852  1.00 47.15           C  
ATOM   1730  N   GLU   233      18.944  13.537 -21.239  1.00 48.85           N  
ATOM   1731  CA  GLU   233      17.648  14.149 -21.527  1.00 53.13           C  
ATOM   1732  C   GLU   233      17.132  14.530 -20.160  1.00 49.36           C  
ATOM   1733  O   GLU   233      16.885  13.648 -19.330  1.00 47.10           O  
ATOM   1734  CB  GLU   233      16.668  13.170 -22.132  1.00 54.59           C  
ATOM   1735  CG  GLU   233      16.961  12.735 -23.549  1.00 65.54           C  
ATOM   1736  CD  GLU   233      15.904  11.725 -24.068  1.00 65.50           C  
ATOM   1737  OE1 GLU   233      15.341  10.954 -23.234  1.00 66.60           O  
ATOM   1738  OE2 GLU   233      15.659  11.718 -25.308  1.00 74.23           O  
ATOM   1739  N   VAL   234      17.018  15.829 -19.910  1.00 49.46           N  
ATOM   1740  CA  VAL   234      16.619  16.350 -18.595  1.00 51.05           C  
ATOM   1741  C   VAL   234      15.191  16.925 -18.609  1.00 51.67           C  
ATOM   1742  O   VAL   234      14.884  17.749 -19.432  1.00 49.34           O  
ATOM   1743  CB  VAL   234      17.574  17.477 -18.150  1.00 51.02           C  
ATOM   1744  CG1 VAL   234      17.289  17.869 -16.680  1.00 53.81           C  
ATOM   1745  CG2 VAL   234      19.054  17.058 -18.306  1.00 47.25           C  
ATOM   1746  N   THR   235      14.339  16.479 -17.691  1.00 53.01           N  
ATOM   1747  CA  THR   235      12.985  17.024 -17.508  1.00 52.97           C  
ATOM   1748  C   THR   235      12.769  17.196 -16.000  1.00 51.14           C  
ATOM   1749  O   THR   235      13.036  16.296 -15.235  1.00 52.16           O  
ATOM   1750  CB  THR   235      11.902  16.077 -18.040  1.00 54.80           C  
ATOM   1751  OG1 THR   235      12.152  15.813 -19.409  1.00 51.05           O  
ATOM   1752  CG2 THR   235      10.514  16.681 -17.896  1.00 55.94           C  
ATOM   1753  N   GLY   236      12.313  18.374 -15.598  1.00 51.80           N  
ATOM   1754  CA  GLY   236      12.066  18.716 -14.194  1.00 53.90           C  
ATOM   1755  C   GLY   236      10.688  18.305 -13.707  1.00 52.14           C  
ATOM   1756  O   GLY   236       9.980  17.518 -14.380  1.00 51.12           O  
ATOM   1757  N   ILE   237      10.312  18.844 -12.550  1.00 51.45           N  
ATOM   1758  CA  ILE   237       9.046  18.470 -11.882  1.00 50.57           C  
ATOM   1759  C   ILE   237       7.962  19.527 -11.830  1.00 50.30           C  
ATOM   1760  O   ILE   237       6.879  19.296 -11.274  1.00 47.12           O  
ATOM   1761  CB  ILE   237       9.289  18.041 -10.404  1.00 50.11           C  
ATOM   1762  CG1 ILE   237       9.712  19.221  -9.521  1.00 52.04           C  
ATOM   1763  CG2 ILE   237      10.299  16.904 -10.330  1.00 47.51           C  
ATOM   1764  CD1 ILE   237       9.653  18.912  -7.994  1.00 47.30           C  
ATOM   1765  N   THR   238       8.227  20.676 -12.428  1.00 51.91           N  
ATOM   1766  CA  THR   238       7.322  21.804 -12.310  1.00 52.06           C  
ATOM   1767  C   THR   238       5.966  21.616 -12.996  1.00 51.29           C  
ATOM   1768  O   THR   238       5.079  22.411 -12.750  1.00 49.88           O  
ATOM   1769  CB  THR   238       7.992  23.079 -12.835  1.00 53.51           C  
ATOM   1770  OG1 THR   238       8.062  23.024 -14.263  1.00 53.36           O  
ATOM   1771  CG2 THR   238       9.384  23.208 -12.261  1.00 52.87           C  
ATOM   1772  N   GLN   239       5.806  20.593 -13.852  1.00 51.70           N  
ATOM   1773  CA  GLN   239       4.500  20.332 -14.506  1.00 51.14           C  
ATOM   1774  C   GLN   239       3.770  19.083 -13.956  1.00 50.90           C  
ATOM   1775  O   GLN   239       2.852  18.542 -14.606  1.00 50.87           O  
ATOM   1776  CB  GLN   239       4.651  20.213 -16.025  1.00 50.95           C  
ATOM   1777  CG  GLN   239       5.346  21.370 -16.684  1.00 49.53           C  
ATOM   1778  CD  GLN   239       4.687  22.714 -16.431  1.00 53.21           C  
ATOM   1779  OE1 GLN   239       3.488  22.914 -16.677  1.00 52.14           O  
ATOM   1780  NE2 GLN   239       5.489  23.661 -15.965  1.00 60.22           N  
ATOM   1781  N   ILE   240       4.187  18.627 -12.774  1.00 50.50           N  
ATOM   1782  CA  ILE   240       3.534  17.526 -12.068  1.00 49.76           C  
ATOM   1783  C   ILE   240       2.551  18.217 -11.127  1.00 49.62           C  
ATOM   1784  O   ILE   240       2.916  19.113 -10.366  1.00 50.34           O  
ATOM   1785  CB  ILE   240       4.531  16.637 -11.289  1.00 51.40           C  
ATOM   1786  CG1 ILE   240       5.580  16.030 -12.240  1.00 50.23           C  
ATOM   1787  CG2 ILE   240       3.794  15.516 -10.526  1.00 51.15           C  
ATOM   1788  CD1 ILE   240       5.047  15.071 -13.283  1.00 40.36           C  
ATOM   1789  N   THR   241       1.287  17.826 -11.231  1.00 48.18           N  
ATOM   1790  CA  THR   241       0.218  18.419 -10.464  1.00 44.92           C  
ATOM   1791  C   THR   241      -0.417  17.385  -9.522  1.00 45.39           C  
ATOM   1792  O   THR   241      -0.223  16.160  -9.666  1.00 48.75           O  
ATOM   1793  CB  THR   241      -0.903  18.900 -11.423  1.00 45.41           C  
ATOM   1794  OG1 THR   241      -1.461  17.762 -12.093  1.00 42.33           O  
ATOM   1795  CG2 THR   241      -0.385  19.906 -12.461  1.00 39.55           C  
ATOM   1796  N   PRO   242      -1.178  17.862  -8.540  1.00 43.72           N  
ATOM   1797  CA  PRO   242      -1.898  16.935  -7.697  1.00 42.02           C  
ATOM   1798  C   PRO   242      -2.739  15.965  -8.512  1.00 40.79           C  
ATOM   1799  O   PRO   242      -2.818  14.793  -8.167  1.00 40.36           O  
ATOM   1800  CB  PRO   242      -2.789  17.855  -6.875  1.00 45.16           C  
ATOM   1801  CG  PRO   242      -1.977  19.111  -6.759  1.00 40.89           C  
ATOM   1802  CD  PRO   242      -1.351  19.257  -8.098  1.00 43.85           C  
ATOM   1803  N   GLU   243      -3.326  16.439  -9.607  1.00 41.11           N  
ATOM   1804  CA  GLU   243      -4.181  15.595 -10.436  1.00 40.13           C  
ATOM   1805  C   GLU   243      -3.392  14.439 -11.052  1.00 40.44           C  
ATOM   1806  O   GLU   243      -3.890  13.332 -11.171  1.00 39.81           O  
ATOM   1807  CB  GLU   243      -4.916  16.436 -11.483  1.00 43.04           C  
ATOM   1808  CG  GLU   243      -5.965  15.667 -12.266  1.00 43.85           C  
ATOM   1809  CD  GLU   243      -6.988  14.994 -11.381  1.00 45.41           C  
ATOM   1810  OE1 GLU   243      -7.357  15.601 -10.365  1.00 41.82           O  
ATOM   1811  OE2 GLU   243      -7.443  13.874 -11.714  1.00 55.23           O  
ATOM   1812  N   ALA   244      -2.142  14.685 -11.401  1.00 40.95           N  
ATOM   1813  CA  ALA   244      -1.283  13.629 -11.875  1.00 42.78           C  
ATOM   1814  C   ALA   244      -1.108  12.543 -10.786  1.00 40.92           C  
ATOM   1815  O   ALA   244      -1.111  11.358 -11.086  1.00 41.81           O  
ATOM   1816  CB  ALA   244       0.125  14.216 -12.341  1.00 40.76           C  
ATOM   1817  N   PHE   245      -0.923  12.949  -9.537  1.00 42.02           N  
ATOM   1818  CA  PHE   245      -0.764  11.996  -8.432  1.00 41.77           C  
ATOM   1819  C   PHE   245      -2.051  11.208  -8.199  1.00 42.19           C  
ATOM   1820  O   PHE   245      -2.029  10.038  -7.840  1.00 47.13           O  
ATOM   1821  CB  PHE   245      -0.344  12.695  -7.121  1.00 42.89           C  
ATOM   1822  CG  PHE   245       1.125  12.972  -7.017  1.00 40.18           C  
ATOM   1823  CD1 PHE   245       1.991  11.972  -6.609  1.00 39.79           C  
ATOM   1824  CD2 PHE   245       1.640  14.247  -7.280  1.00 42.93           C  
ATOM   1825  CE1 PHE   245       3.358  12.220  -6.490  1.00 42.20           C  
ATOM   1826  CE2 PHE   245       2.994  14.499  -7.176  1.00 45.15           C  
ATOM   1827  CZ  PHE   245       3.860  13.478  -6.792  1.00 47.39           C  
ATOM   1828  N   GLN   246      -3.181  11.842  -8.408  1.00 41.99           N  
ATOM   1829  CA  GLN   246      -4.450  11.162  -8.233  1.00 41.40           C  
ATOM   1830  C   GLN   246      -4.657  10.066  -9.283  1.00 42.17           C  
ATOM   1831  O   GLN   246      -5.041   8.964  -8.938  1.00 44.25           O  
ATOM   1832  CB  GLN   246      -5.586  12.155  -8.301  1.00 38.86           C  
ATOM   1833  CG  GLN   246      -6.995  11.535  -8.182  1.00 39.79           C  
ATOM   1834  CD  GLN   246      -7.226  10.792  -6.872  1.00 39.15           C  
ATOM   1835  OE1 GLN   246      -6.626  11.101  -5.848  1.00 43.01           O  
ATOM   1836  NE2 GLN   246      -8.108   9.803  -6.909  1.00 40.19           N  
ATOM   1837  N   VAL   247      -4.403  10.354 -10.554  1.00 43.07           N  
ATOM   1838  CA  VAL   247      -4.644   9.347 -11.614  1.00 40.38           C  
ATOM   1839  C   VAL   247      -3.631   8.202 -11.505  1.00 40.18           C  
ATOM   1840  O   VAL   247      -3.953   7.047 -11.779  1.00 40.19           O  
ATOM   1841  CB  VAL   247      -4.683   9.963 -13.031  1.00 39.05           C  
ATOM   1842  CG1 VAL   247      -5.787  10.993 -13.100  1.00 35.51           C  
ATOM   1843  CG2 VAL   247      -3.361  10.586 -13.417  1.00 35.10           C  
ATOM   1844  N   ALA   248      -2.418   8.524 -11.081  1.00 41.55           N  
ATOM   1845  CA  ALA   248      -1.380   7.504 -10.858  1.00 43.61           C  
ATOM   1846  C   ALA   248      -1.725   6.612  -9.628  1.00 44.76           C  
ATOM   1847  O   ALA   248      -1.574   5.389  -9.671  1.00 45.16           O  
ATOM   1848  CB  ALA   248      -0.031   8.158 -10.698  1.00 39.93           C  
ATOM   1849  N   ALA   249      -2.221   7.231  -8.558  1.00 46.58           N  
ATOM   1850  CA  ALA   249      -2.593   6.516  -7.324  1.00 45.65           C  
ATOM   1851  C   ALA   249      -3.641   5.455  -7.600  1.00 45.82           C  
ATOM   1852  O   ALA   249      -3.556   4.343  -7.109  1.00 48.91           O  
ATOM   1853  CB  ALA   249      -3.098   7.493  -6.272  1.00 44.69           C  
ATOM   1854  N   GLU   250      -4.604   5.790  -8.442  1.00 46.64           N  
ATOM   1855  CA  GLU   250      -5.681   4.892  -8.778  1.00 44.96           C  
ATOM   1856  C   GLU   250      -5.190   3.582  -9.409  1.00 43.24           C  
ATOM   1857  O   GLU   250      -5.881   2.579  -9.352  1.00 43.54           O  
ATOM   1858  CB  GLU   250      -6.685   5.625  -9.684  1.00 44.73           C  
ATOM   1859  CG  GLU   250      -7.422   6.787  -8.970  1.00 46.14           C  
ATOM   1860  CD  GLU   250      -8.346   7.599  -9.889  1.00 49.43           C  
ATOM   1861  OE1 GLU   250      -8.366   7.356 -11.120  1.00 45.92           O  
ATOM   1862  OE2 GLU   250      -9.068   8.486  -9.372  1.00 59.08           O  
ATOM   1863  N   LYS   251      -3.984   3.578  -9.961  1.00 44.52           N  
ATOM   1864  CA  LYS   251      -3.406   2.384 -10.600  1.00 45.68           C  
ATOM   1865  C   LYS   251      -2.169   1.837  -9.853  1.00 48.30           C  
ATOM   1866  O   LYS   251      -1.402   1.056 -10.409  1.00 50.79           O  
ATOM   1867  CB  LYS   251      -3.034   2.707 -12.066  1.00 43.07           C  
ATOM   1868  CG  LYS   251      -4.193   3.318 -12.900  1.00 43.05           C  
ATOM   1869  CD  LYS   251      -5.392   2.388 -13.003  1.00 45.17           C  
ATOM   1870  CE  LYS   251      -6.557   2.995 -13.834  1.00 48.14           C  
ATOM   1871  N   GLY   252      -1.955   2.291  -8.622  1.00 48.48           N  
ATOM   1872  CA  GLY   252      -0.867   1.797  -7.782  1.00 47.58           C  
ATOM   1873  C   GLY   252       0.466   2.488  -7.861  1.00 48.28           C  
ATOM   1874  O   GLY   252       1.452   1.972  -7.316  1.00 47.63           O  
ATOM   1875  N   TYR   253       0.497   3.673  -8.473  1.00 46.78           N  
ATOM   1876  CA  TYR   253       1.734   4.393  -8.659  1.00 47.90           C  
ATOM   1877  C   TYR   253       1.828   5.714  -7.926  1.00 47.46           C  
ATOM   1878  O   TYR   253       0.847   6.393  -7.699  1.00 46.82           O  
ATOM   1879  CB  TYR   253       1.936   4.728 -10.139  1.00 49.96           C  
ATOM   1880  CG  TYR   253       1.994   3.555 -11.078  1.00 49.64           C  
ATOM   1881  CD1 TYR   253       3.191   2.906 -11.319  1.00 52.34           C  
ATOM   1882  CD2 TYR   253       0.861   3.108 -11.735  1.00 50.30           C  
ATOM   1883  CE1 TYR   253       3.265   1.824 -12.168  1.00 52.09           C  
ATOM   1884  CE2 TYR   253       0.915   2.030 -12.591  1.00 59.56           C  
ATOM   1885  CZ  TYR   253       2.127   1.382 -12.812  1.00 63.02           C  
ATOM   1886  OH  TYR   253       2.213   0.304 -13.682  1.00 58.75           O  
ATOM   1887  N   THR   254       3.054   6.059  -7.571  1.00 48.76           N  
ATOM   1888  CA  THR   254       3.372   7.392  -7.097  1.00 47.08           C  
ATOM   1889  C   THR   254       4.245   7.928  -8.228  1.00 49.16           C  
ATOM   1890  O   THR   254       4.402   7.259  -9.259  1.00 48.78           O  
ATOM   1891  CB  THR   254       4.072   7.429  -5.731  1.00 46.40           C  
ATOM   1892  OG1 THR   254       4.178   8.792  -5.330  1.00 42.73           O  
ATOM   1893  CG2 THR   254       5.444   6.781  -5.772  1.00 41.30           C  
ATOM   1894  N   ILE   255       4.780   9.130  -8.066  1.00 51.63           N  
ATOM   1895  CA  ILE   255       5.599   9.773  -9.103  1.00 49.60           C  
ATOM   1896  C   ILE   255       6.888  10.243  -8.454  1.00 50.49           C  
ATOM   1897  O   ILE   255       6.858  10.837  -7.367  1.00 47.75           O  
ATOM   1898  CB  ILE   255       4.891  11.000  -9.715  1.00 48.87           C  
ATOM   1899  CG1 ILE   255       3.530  10.607 -10.320  1.00 47.92           C  
ATOM   1900  CG2 ILE   255       5.777  11.660 -10.774  1.00 46.19           C  
ATOM   1901  CD1 ILE   255       2.656  11.771 -10.677  1.00 47.03           C  
ATOM   1902  N   ARG   256       8.011   9.986  -9.125  1.00 50.08           N  
ATOM   1903  CA  ARG   256       9.330  10.376  -8.613  1.00 50.31           C  
ATOM   1904  C   ARG   256      10.209  10.882  -9.721  1.00 49.70           C  
ATOM   1905  O   ARG   256      10.014  10.517 -10.874  1.00 50.83           O  
ATOM   1906  CB  ARG   256      10.002   9.153  -7.995  1.00 51.89           C  
ATOM   1907  CG  ARG   256       9.358   8.667  -6.706  1.00 53.29           C  
ATOM   1908  CD  ARG   256       9.722   9.572  -5.582  1.00 55.52           C  
ATOM   1909  NE  ARG   256       9.123   9.135  -4.334  1.00 55.85           N  
ATOM   1910  CZ  ARG   256       7.874   9.391  -3.947  1.00 54.21           C  
ATOM   1911  NH1 ARG   256       7.025  10.085  -4.709  1.00 56.43           N  
ATOM   1912  NH2 ARG   256       7.465   8.921  -2.780  1.00 59.54           N  
ATOM   1913  N   LEU   257      11.207  11.697  -9.383  1.00 51.04           N  
ATOM   1914  CA  LEU   257      12.173  12.161 -10.376  1.00 47.61           C  
ATOM   1915  C   LEU   257      13.278  11.112 -10.339  1.00 49.86           C  
ATOM   1916  O   LEU   257      13.995  10.959  -9.340  1.00 50.23           O  
ATOM   1917  CB  LEU   257      12.722  13.556 -10.073  1.00 47.72           C  
ATOM   1918  CG  LEU   257      13.746  14.106 -11.093  1.00 49.63           C  
ATOM   1919  CD1 LEU   257      13.060  14.484 -12.363  1.00 52.20           C  
ATOM   1920  CD2 LEU   257      14.508  15.303 -10.533  1.00 50.78           C  
ATOM   1921  N   ILE   258      13.407  10.392 -11.443  1.00 49.48           N  
ATOM   1922  CA  ILE   258      14.334   9.305 -11.546  1.00 50.05           C  
ATOM   1923  C   ILE   258      15.436   9.615 -12.550  1.00 50.57           C  
ATOM   1924  O   ILE   258      15.166  10.017 -13.692  1.00 50.24           O  
ATOM   1925  CB  ILE   258      13.600   7.972 -11.984  1.00 48.16           C  
ATOM   1926  CG1 ILE   258      12.490   7.570 -10.985  1.00 49.81           C  
ATOM   1927  CG2 ILE   258      14.567   6.829 -12.134  1.00 44.38           C  
ATOM   1928  CD1 ILE   258      12.970   7.197  -9.627  1.00 44.62           C  
ATOM   1929  N   ALA   259      16.674   9.393 -12.107  1.00 49.90           N  
ATOM   1930  CA  ALA   259      17.877   9.530 -12.937  1.00 50.69           C  
ATOM   1931  C   ALA   259      18.273   8.100 -13.356  1.00 50.89           C  
ATOM   1932  O   ALA   259      18.341   7.205 -12.511  1.00 50.11           O  
ATOM   1933  CB  ALA   259      19.039  10.257 -12.136  1.00 47.55           C  
ATOM   1934  N   GLU   260      18.501   7.880 -14.651  1.00 51.07           N  
ATOM   1935  CA  GLU   260      18.846   6.576 -15.138  1.00 52.95           C  
ATOM   1936  C   GLU   260      19.957   6.562 -16.149  1.00 50.27           C  
ATOM   1937  O   GLU   260      19.947   7.360 -17.070  1.00 54.09           O  
ATOM   1938  CB  GLU   260      17.610   5.915 -15.801  1.00 54.66           C  
ATOM   1939  CG  GLU   260      17.984   4.637 -16.571  1.00 56.10           C  
ATOM   1940  CD  GLU   260      16.811   3.823 -17.087  1.00 61.73           C  
ATOM   1941  OE1 GLU   260      15.656   4.100 -16.697  1.00 61.72           O  
ATOM   1942  OE2 GLU   260      17.063   2.893 -17.898  1.00 69.02           O  
ATOM   1943  N   VAL   261      20.909   5.639 -15.990  1.00 48.24           N  
ATOM   1944  CA  VAL   261      21.954   5.381 -16.989  1.00 48.31           C  
ATOM   1945  C   VAL   261      21.846   3.876 -17.266  1.00 51.87           C  
ATOM   1946  O   VAL   261      21.948   3.070 -16.352  1.00 51.60           O  
ATOM   1947  CB  VAL   261      23.425   5.795 -16.585  1.00 48.63           C  
ATOM   1948  CG1 VAL   261      23.837   5.279 -15.231  1.00 48.90           C  
ATOM   1949  CG2 VAL   261      24.421   5.316 -17.661  1.00 41.92           C  
ATOM   1950  N   SER   262      21.544   3.520 -18.506  1.00 53.92           N  
ATOM   1951  CA  SER   262      21.405   2.117 -18.961  1.00 54.45           C  
ATOM   1952  C   SER   262      21.855   2.099 -20.380  1.00 55.86           C  
ATOM   1953  O   SER   262      22.365   3.111 -20.863  1.00 57.01           O  
ATOM   1954  CB  SER   262      19.957   1.623 -18.892  1.00 54.67           C  
ATOM   1955  OG  SER   262      19.077   2.430 -19.661  1.00 59.40           O  
ATOM   1956  N   ARG   263      21.672   0.964 -21.045  1.00 59.14           N  
ATOM   1957  CA  ARG   263      22.034   0.802 -22.459  1.00 59.93           C  
ATOM   1958  C   ARG   263      21.059   1.632 -23.301  1.00 62.30           C  
ATOM   1959  O   ARG   263      21.455   2.339 -24.218  1.00 63.10           O  
ATOM   1960  CB  ARG   263      21.976  -0.692 -22.855  1.00 59.62           C  
ATOM   1961  CG  ARG   263      22.596  -1.039 -24.229  1.00 60.73           C  
ATOM   1962  N   GLU   264      19.781   1.566 -22.939  1.00 65.99           N  
ATOM   1963  CA  GLU   264      18.722   2.291 -23.633  1.00 68.06           C  
ATOM   1964  C   GLU   264      18.665   3.813 -23.330  1.00 69.57           C  
ATOM   1965  O   GLU   264      18.291   4.616 -24.199  1.00 70.88           O  
ATOM   1966  CB  GLU   264      17.363   1.661 -23.250  1.00 68.88           C  
ATOM   1967  N   LYS   265      19.079   4.206 -22.123  1.00 67.14           N  
ATOM   1968  CA  LYS   265      18.847   5.557 -21.641  1.00 65.36           C  
ATOM   1969  C   LYS   265      19.928   6.290 -20.858  1.00 60.82           C  
ATOM   1970  O   LYS   265      20.834   5.712 -20.273  1.00 56.75           O  
ATOM   1971  CB  LYS   265      17.634   5.474 -20.694  1.00 65.07           C  
ATOM   1972  CG  LYS   265      16.370   5.080 -21.410  1.00 67.60           C  
ATOM   1973  CD  LYS   265      15.201   4.860 -20.482  1.00 73.63           C  
ATOM   1974  CE  LYS   265      13.889   4.905 -21.267  1.00 79.42           C  
ATOM   1975  NZ  LYS   265      13.993   4.235 -22.594  1.00 74.09           N  
ATOM   1976  N   LEU   266      19.769   7.606 -20.862  1.00 56.90           N  
ATOM   1977  CA  LEU   266      20.560   8.522 -20.069  1.00 52.32           C  
ATOM   1978  C   LEU   266      19.590   9.686 -19.842  1.00 49.93           C  
ATOM   1979  O   LEU   266      19.467  10.576 -20.674  1.00 46.28           O  
ATOM   1980  CB  LEU   266      21.845   8.934 -20.793  1.00 49.25           C  
ATOM   1981  CG  LEU   266      22.812   9.786 -19.974  1.00 53.47           C  
ATOM   1982  CD1 LEU   266      23.260   9.026 -18.727  1.00 52.75           C  
ATOM   1983  CD2 LEU   266      24.012  10.263 -20.800  1.00 51.30           C  
ATOM   1984  N   LYS   267      18.834   9.633 -18.758  1.00 47.82           N  
ATOM   1985  CA  LYS   267      17.887  10.660 -18.510  1.00 51.06           C  
ATOM   1986  C   LYS   267      17.526  10.887 -17.072  1.00 49.84           C  
ATOM   1987  O   LYS   267      17.724  10.027 -16.200  1.00 49.24           O  
ATOM   1988  CB  LYS   267      16.598  10.390 -19.297  1.00 53.67           C  
ATOM   1989  CG  LYS   267      15.810   9.149 -18.924  1.00 60.78           C  
ATOM   1990  CD  LYS   267      14.541   8.944 -19.815  1.00 60.18           C  
ATOM   1991  CE  LYS   267      13.575  10.193 -19.966  1.00 76.63           C  
ATOM   1992  NZ  LYS   267      13.784  11.228 -21.118  1.00 67.91           N  
ATOM   1993  N   VAL   268      17.003  12.087 -16.860  1.00 49.68           N  
ATOM   1994  CA  VAL   268      16.426  12.519 -15.606  1.00 51.35           C  
ATOM   1995  C   VAL   268      15.037  13.025 -15.979  1.00 51.93           C  
ATOM   1996  O   VAL   268      14.903  13.866 -16.867  1.00 48.66           O  
ATOM   1997  CB  VAL   268      17.234  13.667 -14.963  1.00 52.83           C  
ATOM   1998  CG1 VAL   268      16.513  14.203 -13.740  1.00 49.39           C  
ATOM   1999  CG2 VAL   268      18.658  13.167 -14.599  1.00 47.14           C  
ATOM   2000  N   SER   269      14.010  12.457 -15.359  1.00 51.69           N  
ATOM   2001  CA  SER   269      12.653  12.879 -15.592  1.00 53.24           C  
ATOM   2002  C   SER   269      11.710  12.306 -14.563  1.00 53.14           C  
ATOM   2003  O   SER   269      12.048  11.354 -13.829  1.00 54.67           O  
ATOM   2004  CB  SER   269      12.152  12.423 -16.965  1.00 53.66           C  
ATOM   2005  OG  SER   269      12.163  11.010 -17.043  1.00 57.01           O  
ATOM   2006  N   PRO   270      10.522  12.919 -14.450  1.00 51.63           N  
ATOM   2007  CA  PRO   270       9.501  12.260 -13.627  1.00 52.74           C  
ATOM   2008  C   PRO   270       9.123  10.884 -14.204  1.00 51.85           C  
ATOM   2009  O   PRO   270       9.159  10.691 -15.414  1.00 53.70           O  
ATOM   2010  CB  PRO   270       8.330  13.226 -13.689  1.00 52.28           C  
ATOM   2011  CG  PRO   270       9.016  14.589 -13.893  1.00 53.95           C  
ATOM   2012  CD  PRO   270      10.110  14.258 -14.872  1.00 48.97           C  
ATOM   2013  N   ARG   271       8.723   9.969 -13.335  1.00 49.90           N  
ATOM   2014  CA  ARG   271       8.358   8.651 -13.730  1.00 53.06           C  
ATOM   2015  C   ARG   271       7.373   8.023 -12.742  1.00 50.72           C  
ATOM   2016  O   ARG   271       7.444   8.310 -11.557  1.00 50.11           O  
ATOM   2017  CB  ARG   271       9.624   7.817 -13.760  1.00 54.71           C  
ATOM   2018  CG  ARG   271       9.445   6.443 -14.341  1.00 60.14           C  
ATOM   2019  CD  ARG   271      10.752   5.656 -14.346  1.00 60.69           C  
ATOM   2020  NE  ARG   271      11.780   6.259 -15.198  1.00 63.06           N  
ATOM   2021  CZ  ARG   271      12.936   5.661 -15.502  1.00 68.10           C  
ATOM   2022  NH1 ARG   271      13.195   4.432 -15.042  1.00 61.75           N  
ATOM   2023  NH2 ARG   271      13.827   6.274 -16.296  1.00 63.05           N  
ATOM   2024  N   LEU   272       6.461   7.173 -13.243  1.00 49.75           N  
ATOM   2025  CA  LEU   272       5.549   6.418 -12.381  1.00 50.07           C  
ATOM   2026  C   LEU   272       6.342   5.288 -11.692  1.00 52.05           C  
ATOM   2027  O   LEU   272       7.090   4.570 -12.348  1.00 56.31           O  
ATOM   2028  CB  LEU   272       4.385   5.853 -13.165  1.00 47.30           C  
ATOM   2029  CG  LEU   272       3.434   6.882 -13.793  1.00 46.63           C  
ATOM   2030  CD1 LEU   272       2.246   6.223 -14.527  1.00 40.52           C  
ATOM   2031  CD2 LEU   272       2.954   7.860 -12.713  1.00 40.96           C  
ATOM   2032  N   VAL   273       6.201   5.181 -10.374  1.00 51.42           N  
ATOM   2033  CA  VAL   273       6.858   4.165  -9.560  1.00 51.89           C  
ATOM   2034  C   VAL   273       5.812   3.483  -8.666  1.00 53.90           C  
ATOM   2035  O   VAL   273       5.110   4.174  -7.912  1.00 55.96           O  
ATOM   2036  CB  VAL   273       7.916   4.799  -8.620  1.00 53.50           C  
ATOM   2037  CG1 VAL   273       8.583   3.717  -7.749  1.00 49.92           C  
ATOM   2038  CG2 VAL   273       8.955   5.633  -9.421  1.00 47.84           C  
ATOM   2039  N   PRO   274       5.675   2.135  -8.755  1.00 52.64           N  
ATOM   2040  CA  PRO   274       4.728   1.432  -7.891  1.00 53.96           C  
ATOM   2041  C   PRO   274       4.977   1.737  -6.425  1.00 54.64           C  
ATOM   2042  O   PRO   274       6.127   1.797  -6.004  1.00 54.38           O  
ATOM   2043  CB  PRO   274       4.995  -0.035  -8.194  1.00 53.52           C  
ATOM   2044  CG  PRO   274       5.512  -0.028  -9.586  1.00 51.92           C  
ATOM   2045  CD  PRO   274       6.332   1.208  -9.692  1.00 53.02           C  
ATOM   2046  N   PHE   275       3.899   1.932  -5.675  1.00 54.72           N  
ATOM   2047  CA  PHE   275       3.974   2.293  -4.272  1.00 55.62           C  
ATOM   2048  C   PHE   275       4.891   1.449  -3.413  1.00 58.81           C  
ATOM   2049  O   PHE   275       5.520   1.943  -2.483  1.00 60.70           O  
ATOM   2050  CB  PHE   275       2.588   2.209  -3.655  1.00 57.01           C  
ATOM   2051  CG  PHE   275       1.686   3.318  -4.045  1.00 55.28           C  
ATOM   2052  CD1 PHE   275       2.029   4.624  -3.764  1.00 56.36           C  
ATOM   2053  CD2 PHE   275       0.454   3.057  -4.604  1.00 55.16           C  
ATOM   2054  CE1 PHE   275       1.184   5.657  -4.092  1.00 59.77           C  
ATOM   2055  CE2 PHE   275      -0.402   4.086  -4.922  1.00 58.80           C  
ATOM   2056  CZ  PHE   275      -0.037   5.391  -4.666  1.00 54.00           C  
ATOM   2057  N   HIS   276       4.944   0.160  -3.681  1.00 63.00           N  
ATOM   2058  CA  HIS   276       5.792  -0.693  -2.857  1.00 66.83           C  
ATOM   2059  C   HIS   276       7.177  -0.994  -3.461  1.00 66.08           C  
ATOM   2060  O   HIS   276       7.884  -1.870  -2.970  1.00 68.94           O  
ATOM   2061  CB  HIS   276       5.045  -1.990  -2.492  1.00 69.40           C  
ATOM   2062  CG  HIS   276       3.897  -1.777  -1.545  1.00 77.16           C  
ATOM   2063  ND1 HIS   276       2.577  -1.957  -1.910  1.00 84.07           N  
ATOM   2064  CD2 HIS   276       3.879  -1.381  -0.251  1.00 76.56           C  
ATOM   2065  CE1 HIS   276       1.800  -1.695  -0.873  1.00 86.57           C  
ATOM   2066  NE2 HIS   276       2.565  -1.339   0.143  1.00 82.10           N  
ATOM   2067  N   HIS   277       7.551  -0.272  -4.528  0.50 63.14           N  
ATOM   2069  CA  HIS   277       8.868  -0.436  -5.158  0.50 61.64           C  
ATOM   2071  C   HIS   277       9.907   0.297  -4.304  0.50 59.06           C  
ATOM   2073  O   HIS   277       9.579   1.288  -3.648  0.50 57.93           O  
ATOM   2075  CB  HIS   277       8.892   0.092  -6.606  0.50 60.27           C  
ATOM   2077  CG  HIS   277      10.214  -0.095  -7.300  0.50 60.02           C  
ATOM   2079  ND1 HIS   277      11.153   0.911  -7.410  0.50 40.88           N  
ATOM   2081  CD2 HIS   277      10.760  -1.182  -7.896  0.50 56.22           C  
ATOM   2083  CE1 HIS   277      12.226   0.446  -8.026  0.50 44.71           C  
ATOM   2085  NE2 HIS   277      12.015  -0.820  -8.332  0.50 55.69           N  
ATOM   2087  N   PRO   278      11.150  -0.214  -4.260  1.00 57.57           N  
ATOM   2088  CA  PRO   278      12.187   0.488  -3.504  1.00 55.58           C  
ATOM   2089  C   PRO   278      12.443   1.954  -3.879  1.00 53.90           C  
ATOM   2090  O   PRO   278      12.796   2.721  -3.013  1.00 55.60           O  
ATOM   2091  CB  PRO   278      13.427  -0.369  -3.747  1.00 54.22           C  
ATOM   2092  CG  PRO   278      12.895  -1.721  -3.973  1.00 54.80           C  
ATOM   2093  CD  PRO   278      11.685  -1.478  -4.812  1.00 57.70           C  
ATOM   2094  N   LEU   279      12.219   2.352  -5.123  1.00 52.42           N  
ATOM   2095  CA  LEU   279      12.427   3.737  -5.518  1.00 53.39           C  
ATOM   2096  C   LEU   279      11.205   4.624  -5.231  1.00 54.49           C  
ATOM   2097  O   LEU   279      11.191   5.766  -5.658  1.00 55.60           O  
ATOM   2098  CB  LEU   279      12.864   3.842  -6.983  1.00 52.72           C  
ATOM   2099  CG  LEU   279      14.279   3.350  -7.343  1.00 59.22           C  
ATOM   2100  CD1 LEU   279      14.465   3.288  -8.857  1.00 50.14           C  
ATOM   2101  CD2 LEU   279      15.331   4.266  -6.687  1.00 47.94           C  
ATOM   2102  N   ALA   280      10.207   4.121  -4.489  1.00 57.24           N  
ATOM   2103  CA  ALA   280       9.030   4.925  -4.056  1.00 56.16           C  
ATOM   2104  C   ALA   280       9.281   5.644  -2.719  1.00 57.69           C  
ATOM   2105  O   ALA   280       8.379   6.213  -2.131  1.00 58.14           O  
ATOM   2106  CB  ALA   280       7.779   4.045  -3.936  1.00 56.25           C  
ATOM   2107  N   ILE   281      10.508   5.582  -2.235  1.00 59.74           N  
ATOM   2108  CA  ILE   281      10.947   6.265  -1.016  1.00 60.78           C  
ATOM   2109  C   ILE   281      10.517   7.750  -0.945  1.00 60.99           C  
ATOM   2110  O   ILE   281      10.586   8.508  -1.927  1.00 58.34           O  
ATOM   2111  CB  ILE   281      12.498   6.161  -0.924  1.00 60.10           C  
ATOM   2112  CG1 ILE   281      12.971   6.338   0.509  1.00 66.46           C  
ATOM   2113  CG2 ILE   281      13.189   7.127  -1.969  1.00 57.81           C  
ATOM   2114  CD1 ILE   281      14.303   5.653   0.779  1.00 67.85           C  
ATOM   2115  N   LYS   282      10.080   8.173   0.229  1.00 61.35           N  
ATOM   2116  CA  LYS   282       9.619   9.539   0.388  1.00 63.67           C  
ATOM   2117  C   LYS   282      10.551  10.419   1.229  1.00 61.25           C  
ATOM   2118  O   LYS   282      11.502   9.933   1.803  1.00 61.51           O  
ATOM   2119  CB  LYS   282       8.141   9.570   0.846  1.00 64.98           C  
ATOM   2120  CG  LYS   282       7.766   8.583   1.882  1.00 67.64           C  
ATOM   2121  CD  LYS   282       6.285   8.645   2.238  1.00 67.61           C  
ATOM   2122  CE  LYS   282       5.385   8.048   1.180  1.00 67.77           C  
ATOM   2123  NZ  LYS   282       4.075   7.599   1.782  1.00 67.80           N  
ATOM   2124  N   GLY   283      10.295  11.729   1.221  1.00 60.05           N  
ATOM   2125  CA  GLY   283      11.082  12.711   1.977  1.00 56.85           C  
ATOM   2126  C   GLY   283      12.323  13.165   1.249  1.00 55.49           C  
ATOM   2127  O   GLY   283      12.490  12.857   0.075  1.00 56.61           O  
ATOM   2128  N   THR   284      13.186  13.922   1.937  1.00 55.16           N  
ATOM   2129  CA  THR   284      14.458  14.352   1.366  1.00 58.60           C  
ATOM   2130  C   THR   284      15.396  13.158   1.510  1.00 58.29           C  
ATOM   2131  O   THR   284      16.127  13.025   2.498  1.00 64.26           O  
ATOM   2132  CB  THR   284      15.068  15.562   2.103  1.00 58.81           C  
ATOM   2133  OG1 THR   284      15.282  15.184   3.465  1.00 61.42           O  
ATOM   2134  CG2 THR   284      14.130  16.791   2.063  1.00 54.55           C  
ATOM   2135  N   MET   285      15.348  12.279   0.533  1.00 55.74           N  
ATOM   2136  CA  MET   285      16.149  11.090   0.542  1.00 54.80           C  
ATOM   2137  C   MET   285      16.820  10.866  -0.798  1.00 53.76           C  
ATOM   2138  O   MET   285      16.468  11.517  -1.812  1.00 51.16           O  
ATOM   2139  CB  MET   285      15.254   9.895   0.817  1.00 59.08           C  
ATOM   2140  CG  MET   285      16.023   8.803   1.486  1.00 70.72           C  
ATOM   2141  SD  MET   285      15.988   9.191   3.365  0.75 72.71          SE  
ATOM   2142  CE  MET   285      14.036   7.971   3.245  1.00 55.49           C  
ATOM   2143  N   ASN   286      17.863  10.041  -0.795  1.00 50.19           N  
ATOM   2144  CA  ASN   286      18.458   9.596  -2.055  1.00 50.76           C  
ATOM   2145  C   ASN   286      18.290   8.081  -2.142  1.00 50.97           C  
ATOM   2146  O   ASN   286      17.978   7.440  -1.131  1.00 44.71           O  
ATOM   2147  CB  ASN   286      19.923   9.981  -2.224  1.00 49.58           C  
ATOM   2148  CG  ASN   286      20.112  11.403  -2.696  1.00 50.93           C  
ATOM   2149  OD1 ASN   286      21.105  11.690  -3.318  1.00 57.81           O  
ATOM   2150  ND2 ASN   286      19.143  12.297  -2.415  1.00 52.94           N  
ATOM   2151  N   ALA   287      18.425   7.550  -3.367  1.00 47.85           N  
ATOM   2152  CA  ALA   287      18.376   6.142  -3.571  1.00 50.04           C  
ATOM   2153  C   ALA   287      18.981   5.740  -4.931  1.00 48.49           C  
ATOM   2154  O   ALA   287      19.136   6.564  -5.846  1.00 49.11           O  
ATOM   2155  CB  ALA   287      16.931   5.601  -3.350  1.00 50.22           C  
ATOM   2156  N   ALA   288      19.445   4.498  -5.024  1.00 45.47           N  
ATOM   2157  CA  ALA   288      20.031   4.040  -6.281  1.00 47.90           C  
ATOM   2158  C   ALA   288      19.895   2.544  -6.375  1.00 48.41           C  
ATOM   2159  O   ALA   288      20.132   1.835  -5.394  1.00 49.24           O  
ATOM   2160  CB  ALA   288      21.514   4.466  -6.395  1.00 45.62           C  
ATOM   2161  N   MET   289      19.483   2.070  -7.545  1.00 48.34           N  
ATOM   2162  CA  MET   289      19.390   0.672  -7.800  1.00 48.98           C  
ATOM   2163  C   MET   289      20.462   0.335  -8.825  1.00 48.97           C  
ATOM   2164  O   MET   289      20.379   0.806  -9.935  1.00 48.56           O  
ATOM   2165  CB  MET   289      17.991   0.333  -8.359  1.00 52.88           C  
ATOM   2166  CG  MET   289      17.745  -1.165  -8.616  1.00 52.27           C  
ATOM   2167  SD  MET   289      17.752  -2.323  -7.100  0.75 51.82          SE  
ATOM   2168  CE  MET   289      15.943  -2.000  -6.436  1.00 70.48           C  
ATOM   2169  N   PHE   290      21.442  -0.498  -8.466  1.00 49.09           N  
ATOM   2170  CA  PHE   290      22.459  -0.980  -9.434  1.00 48.88           C  
ATOM   2171  C   PHE   290      22.062  -2.356  -9.940  1.00 50.07           C  
ATOM   2172  O   PHE   290      21.818  -3.239  -9.154  1.00 49.92           O  
ATOM   2173  CB  PHE   290      23.842  -1.103  -8.779  1.00 48.79           C  
ATOM   2174  CG  PHE   290      24.349   0.158  -8.204  1.00 48.96           C  
ATOM   2175  CD1 PHE   290      23.896   0.613  -6.969  1.00 46.94           C  
ATOM   2176  CD2 PHE   290      25.285   0.908  -8.884  1.00 55.03           C  
ATOM   2177  CE1 PHE   290      24.328   1.791  -6.463  1.00 52.75           C  
ATOM   2178  CE2 PHE   290      25.744   2.085  -8.363  1.00 56.17           C  
ATOM   2179  CZ  PHE   290      25.264   2.539  -7.158  1.00 55.13           C  
ATOM   2180  N   LYS   291      21.959  -2.515 -11.248  1.00 51.01           N  
ATOM   2181  CA  LYS   291      21.694  -3.786 -11.860  1.00 52.81           C  
ATOM   2182  C   LYS   291      23.043  -4.249 -12.413  1.00 51.70           C  
ATOM   2183  O   LYS   291      23.681  -3.528 -13.179  1.00 46.61           O  
ATOM   2184  CB  LYS   291      20.655  -3.672 -12.988  1.00 55.77           C  
ATOM   2185  CG  LYS   291      20.211  -5.026 -13.568  1.00 60.53           C  
ATOM   2186  CD  LYS   291      19.325  -4.887 -14.824  1.00 60.07           C  
ATOM   2187  CE  LYS   291      19.053  -6.265 -15.511  1.00 65.73           C  
ATOM   2188  N   THR   292      23.471  -5.450 -12.003  1.00 51.30           N  
ATOM   2189  CA  THR   292      24.770  -5.989 -12.373  1.00 49.62           C  
ATOM   2190  C   THR   292      24.610  -7.333 -12.985  1.00 49.16           C  
ATOM   2191  O   THR   292      23.529  -7.930 -12.921  1.00 48.79           O  
ATOM   2192  CB  THR   292      25.703  -6.186 -11.143  1.00 48.95           C  
ATOM   2193  OG1 THR   292      25.250  -7.297 -10.356  1.00 50.84           O  
ATOM   2194  CG2 THR   292      25.770  -4.949 -10.307  1.00 46.35           C  
ATOM   2195  N   ASP   293      25.702  -7.828 -13.561  1.00 50.04           N  
ATOM   2196  CA  ASP   293      25.686  -9.165 -14.146  1.00 51.52           C  
ATOM   2197  C   ASP   293      25.922 -10.287 -13.124  1.00 49.74           C  
ATOM   2198  O   ASP   293      25.258 -11.309 -13.205  1.00 48.01           O  
ATOM   2199  CB  ASP   293      26.698  -9.294 -15.298  1.00 54.21           C  
ATOM   2200  CG  ASP   293      28.150  -9.077 -14.857  1.00 59.78           C  
ATOM   2201  OD1 ASP   293      28.405  -8.547 -13.750  1.00 65.09           O  
ATOM   2202  OD2 ASP   293      29.048  -9.430 -15.645  1.00 72.52           O  
ATOM   2203  N   THR   294      26.840 -10.111 -12.170  1.00 49.18           N  
ATOM   2204  CA  THR   294      27.170 -11.225 -11.231  1.00 51.89           C  
ATOM   2205  C   THR   294      26.646 -11.106  -9.783  1.00 50.82           C  
ATOM   2206  O   THR   294      26.422 -12.115  -9.128  1.00 53.77           O  
ATOM   2207  CB  THR   294      28.695 -11.537 -11.205  1.00 51.02           C  
ATOM   2208  OG1 THR   294      29.416 -10.394 -10.734  1.00 55.62           O  
ATOM   2209  CG2 THR   294      29.192 -11.907 -12.592  1.00 48.56           C  
ATOM   2210  N   ALA   295      26.447  -9.891  -9.299  1.00 50.60           N  
ATOM   2211  CA  ALA   295      25.931  -9.652  -7.943  1.00 51.30           C  
ATOM   2212  C   ALA   295      24.421  -9.398  -7.876  1.00 51.09           C  
ATOM   2213  O   ALA   295      23.939  -8.902  -6.864  1.00 55.53           O  
ATOM   2214  CB  ALA   295      26.662  -8.445  -7.319  1.00 46.14           C  
ATOM   2215  N   GLY   296      23.684  -9.701  -8.938  1.00 50.47           N  
ATOM   2216  CA  GLY   296      22.274  -9.345  -9.021  1.00 47.00           C  
ATOM   2217  C   GLY   296      22.038  -7.833  -9.002  1.00 46.99           C  
ATOM   2218  O   GLY   296      22.866  -7.023  -9.452  1.00 47.94           O  
ATOM   2219  N   SER   297      20.890  -7.462  -8.447  1.00 45.29           N  
ATOM   2220  CA  SER   297      20.485  -6.093  -8.245  1.00 47.70           C  
ATOM   2221  C   SER   297      20.820  -5.625  -6.796  1.00 46.66           C  
ATOM   2222  O   SER   297      20.489  -6.288  -5.816  1.00 44.07           O  
ATOM   2223  CB  SER   297      18.998  -5.935  -8.600  1.00 49.61           C  
ATOM   2224  OG  SER   297      18.838  -5.667  -9.996  1.00 52.39           O  
ATOM   2225  N   ILE   298      21.514  -4.502  -6.693  1.00 45.48           N  
ATOM   2226  CA  ILE   298      21.926  -3.930  -5.421  1.00 47.62           C  
ATOM   2227  C   ILE   298      21.326  -2.541  -5.248  1.00 48.50           C  
ATOM   2228  O   ILE   298      21.430  -1.691  -6.129  1.00 46.75           O  
ATOM   2229  CB  ILE   298      23.437  -3.863  -5.292  1.00 48.14           C  
ATOM   2230  CG1 ILE   298      24.008  -5.275  -5.412  1.00 52.40           C  
ATOM   2231  CG2 ILE   298      23.839  -3.298  -3.937  1.00 46.53           C  
ATOM   2232  CD1 ILE   298      25.442  -5.340  -5.113  1.00 58.92           C  
ATOM   2233  N   PHE   299      20.665  -2.360  -4.103  1.00 47.41           N  
ATOM   2234  CA  PHE   299      19.949  -1.156  -3.780  1.00 46.70           C  
ATOM   2235  C   PHE   299      20.528  -0.494  -2.544  1.00 46.08           C  
ATOM   2236  O   PHE   299      20.912  -1.168  -1.560  1.00 43.64           O  
ATOM   2237  CB  PHE   299      18.478  -1.497  -3.523  1.00 48.44           C  
ATOM   2238  CG  PHE   299      17.602  -0.290  -3.232  1.00 47.77           C  
ATOM   2239  CD1 PHE   299      17.231   0.577  -4.250  1.00 54.31           C  
ATOM   2240  CD2 PHE   299      17.121  -0.051  -1.962  1.00 51.44           C  
ATOM   2241  CE1 PHE   299      16.429   1.664  -3.983  1.00 58.81           C  
ATOM   2242  CE2 PHE   299      16.302   1.044  -1.694  1.00 53.15           C  
ATOM   2243  CZ  PHE   299      15.966   1.892  -2.684  1.00 50.25           C  
ATOM   2244  N   VAL   300      20.611   0.835  -2.631  1.00 45.97           N  
ATOM   2245  CA  VAL   300      21.075   1.669  -1.543  1.00 48.52           C  
ATOM   2246  C   VAL   300      20.181   2.923  -1.440  1.00 47.59           C  
ATOM   2247  O   VAL   300      19.665   3.417  -2.434  1.00 46.65           O  
ATOM   2248  CB  VAL   300      22.596   2.002  -1.680  1.00 46.77           C  
ATOM   2249  CG1 VAL   300      22.890   2.751  -2.965  1.00 43.95           C  
ATOM   2250  CG2 VAL   300      23.089   2.794  -0.501  1.00 60.08           C  
ATOM   2251  N   ALA   301      19.992   3.392  -0.208  1.00 50.33           N  
ATOM   2252  CA  ALA   301      19.200   4.567   0.119  1.00 51.53           C  
ATOM   2253  C   ALA   301      19.778   5.233   1.390  1.00 53.33           C  
ATOM   2254  O   ALA   301      20.325   4.544   2.281  1.00 51.18           O  
ATOM   2255  CB  ALA   301      17.762   4.175   0.341  1.00 49.38           C  
ATOM   2256  N   GLY   302      19.701   6.569   1.436  1.00 53.20           N  
ATOM   2257  CA  GLY   302      20.105   7.365   2.605  1.00 55.07           C  
ATOM   2258  C   GLY   302      19.862   8.871   2.399  1.00 58.52           C  
ATOM   2259  O   GLY   302      19.121   9.260   1.513  1.00 56.23           O  
ATOM   2260  N   ARG   303      20.488   9.717   3.224  1.00 59.94           N  
ATOM   2261  CA  ARG   303      20.404  11.197   3.094  1.00 62.24           C  
ATOM   2262  C   ARG   303      21.276  11.642   1.924  1.00 64.44           C  
ATOM   2263  O   ARG   303      22.448  11.243   1.845  1.00 68.05           O  
ATOM   2264  CB  ARG   303      20.869  11.921   4.391  1.00 63.46           C  
ATOM   2265  CG  ARG   303      19.777  12.296   5.367  1.00 65.42           C  
ATOM   2266  CD  ARG   303      18.777  11.215   5.621  1.00 63.53           C  
ATOM   2267  NE  ARG   303      17.603  11.763   6.311  1.00 68.32           N  
ATOM   2268  N   GLY   304      20.724  12.474   1.041  1.00 61.92           N  
ATOM   2269  CA  GLY   304      21.473  12.933  -0.135  1.00 62.60           C  
ATOM   2270  C   GLY   304      22.240  14.246  -0.001  1.00 64.51           C  
ATOM   2271  O   GLY   304      22.921  14.670  -0.953  1.00 64.41           O  
ATOM   2272  N   ALA   305      22.127  14.880   1.170  1.00 64.80           N  
ATOM   2273  CA  ALA   305      22.749  16.192   1.444  1.00 67.40           C  
ATOM   2274  C   ALA   305      22.657  16.541   2.944  1.00 69.25           C  
ATOM   2275  O   ALA   305      22.008  15.827   3.739  1.00 71.21           O  
ATOM   2276  CB  ALA   305      22.084  17.306   0.597  1.00 64.41           C  
ATOM   2277  N   GLY   306      23.261  17.669   3.312  1.00 68.12           N  
ATOM   2278  CA  GLY   306      23.350  18.082   4.708  1.00 65.78           C  
ATOM   2279  C   GLY   306      24.808  18.328   5.029  1.00 64.76           C  
ATOM   2280  O   GLY   306      25.708  17.837   4.332  1.00 63.93           O  
ATOM   2281  N   LYS   307      25.046  19.108   6.073  1.00 62.64           N  
ATOM   2282  CA  LYS   307      26.399  19.476   6.443  1.00 62.49           C  
ATOM   2283  C   LYS   307      27.186  18.288   6.978  1.00 59.09           C  
ATOM   2284  O   LYS   307      28.273  17.993   6.470  1.00 59.47           O  
ATOM   2285  CB  LYS   307      26.409  20.646   7.456  1.00 61.25           C  
ATOM   2286  CG  LYS   307      27.799  20.931   7.994  1.00 64.49           C  
ATOM   2287  CD  LYS   307      27.953  22.314   8.630  1.00 66.08           C  
ATOM   2288  CE  LYS   307      27.276  22.452   9.964  1.00 72.37           C  
ATOM   2289  NZ  LYS   307      27.655  23.784  10.595  1.00 74.14           N  
ATOM   2290  N   GLU   308      26.636  17.617   7.989  1.00 59.41           N  
ATOM   2291  CA  GLU   308      27.331  16.507   8.639  1.00 60.01           C  
ATOM   2292  C   GLU   308      27.386  15.318   7.665  1.00 58.28           C  
ATOM   2293  O   GLU   308      28.396  14.646   7.582  1.00 57.19           O  
ATOM   2294  CB  GLU   308      26.672  16.146   9.994  1.00 62.01           C  
ATOM   2295  CG  GLU   308      27.710  15.741  11.112  1.00 64.45           C  
ATOM   2296  CD  GLU   308      27.100  15.204  12.438  1.00 66.17           C  
ATOM   2297  OE1 GLU   308      26.057  14.504  12.406  1.00 74.01           O  
ATOM   2298  OE2 GLU   308      27.705  15.442  13.523  1.00 82.29           O  
ATOM   2299  N   GLU   309      26.323  15.131   6.884  1.00 56.89           N  
ATOM   2300  CA  GLU   309      26.215  14.060   5.906  1.00 57.35           C  
ATOM   2301  C   GLU   309      27.263  14.198   4.803  1.00 57.25           C  
ATOM   2302  O   GLU   309      27.924  13.219   4.446  1.00 56.95           O  
ATOM   2303  CB  GLU   309      24.797  14.007   5.285  1.00 59.26           C  
ATOM   2304  CG  GLU   309      23.674  13.493   6.241  1.00 63.49           C  
ATOM   2305  CD  GLU   309      23.312  14.466   7.369  1.00 73.49           C  
ATOM   2306  OE1 GLU   309      23.256  15.706   7.132  1.00 72.66           O  
ATOM   2307  OE2 GLU   309      23.080  13.975   8.495  1.00 76.48           O  
ATOM   2308  N   THR   310      27.432  15.404   4.266  1.00 54.46           N  
ATOM   2309  CA  THR   310      28.431  15.620   3.229  1.00 51.76           C  
ATOM   2310  C   THR   310      29.824  15.483   3.822  1.00 52.76           C  
ATOM   2311  O   THR   310      30.729  14.912   3.197  1.00 55.41           O  
ATOM   2312  CB  THR   310      28.256  16.986   2.567  1.00 53.49           C  
ATOM   2313  OG1 THR   310      26.956  17.041   1.990  1.00 55.20           O  
ATOM   2314  CG2 THR   310      29.285  17.211   1.444  1.00 52.64           C  
ATOM   2315  N   ALA   311      30.008  16.034   5.019  1.00 50.52           N  
ATOM   2316  CA  ALA   311      31.277  15.932   5.720  1.00 49.19           C  
ATOM   2317  C   ALA   311      31.689  14.452   5.889  1.00 48.65           C  
ATOM   2318  O   ALA   311      32.884  14.124   5.745  1.00 49.41           O  
ATOM   2319  CB  ALA   311      31.169  16.616   7.114  1.00 47.13           C  
ATOM   2320  N   SER   312      30.723  13.599   6.263  1.00 46.95           N  
ATOM   2321  CA  SER   312      30.915  12.131   6.434  1.00 50.66           C  
ATOM   2322  C   SER   312      31.468  11.472   5.178  1.00 46.93           C  
ATOM   2323  O   SER   312      32.356  10.659   5.257  1.00 50.54           O  
ATOM   2324  CB  SER   312      29.588  11.393   6.731  1.00 51.96           C  
ATOM   2325  OG  SER   312      29.093  11.705   8.000  1.00 67.21           O  
ATOM   2326  N   ALA   313      30.857  11.775   4.046  1.00 44.96           N  
ATOM   2327  CA  ALA   313      31.306  11.265   2.741  1.00 46.84           C  
ATOM   2328  C   ALA   313      32.756  11.664   2.510  1.00 45.11           C  
ATOM   2329  O   ALA   313      33.556  10.848   2.101  1.00 48.10           O  
ATOM   2330  CB  ALA   313      30.397  11.801   1.619  1.00 44.44           C  
ATOM   2331  N   ILE   314      33.097  12.925   2.792  1.00 47.45           N  
ATOM   2332  CA  ILE   314      34.449  13.394   2.616  1.00 46.75           C  
ATOM   2333  C   ILE   314      35.403  12.565   3.491  1.00 47.25           C  
ATOM   2334  O   ILE   314      36.446  12.090   3.020  1.00 45.24           O  
ATOM   2335  CB  ILE   314      34.558  14.915   2.895  1.00 47.78           C  
ATOM   2336  CG1 ILE   314      33.914  15.679   1.745  1.00 48.95           C  
ATOM   2337  CG2 ILE   314      36.023  15.318   3.057  1.00 44.35           C  
ATOM   2338  CD1 ILE   314      33.797  17.158   1.936  1.00 51.85           C  
ATOM   2339  N   LEU   315      35.031  12.368   4.753  1.00 48.16           N  
ATOM   2340  CA  LEU   315      35.822  11.560   5.653  1.00 49.56           C  
ATOM   2341  C   LEU   315      35.978  10.110   5.207  1.00 49.36           C  
ATOM   2342  O   LEU   315      37.047   9.538   5.409  1.00 47.25           O  
ATOM   2343  CB  LEU   315      35.255  11.563   7.078  1.00 51.04           C  
ATOM   2344  CG  LEU   315      35.854  12.567   8.060  1.00 59.62           C  
ATOM   2345  CD1 LEU   315      35.674  14.044   7.569  1.00 51.16           C  
ATOM   2346  CD2 LEU   315      35.221  12.282   9.446  1.00 52.56           C  
ATOM   2347  N   SER   316      34.923   9.512   4.640  1.00 49.02           N  
ATOM   2348  CA  SER   316      34.996   8.106   4.182  1.00 47.88           C  
ATOM   2349  C   SER   316      36.082   8.026   3.098  1.00 47.56           C  
ATOM   2350  O   SER   316      36.860   7.078   3.063  1.00 49.39           O  
ATOM   2351  CB  SER   316      33.642   7.620   3.698  1.00 48.36           C  
ATOM   2352  OG  SER   316      33.242   8.292   2.495  1.00 55.46           O  
ATOM   2353  N   ASP   317      36.191   9.078   2.273  1.00 46.72           N  
ATOM   2354  CA  ASP   317      37.227   9.137   1.230  1.00 46.53           C  
ATOM   2355  C   ASP   317      38.627   9.292   1.807  1.00 50.16           C  
ATOM   2356  O   ASP   317      39.573   8.696   1.312  1.00 53.23           O  
ATOM   2357  CB  ASP   317      36.938  10.256   0.239  1.00 41.60           C  
ATOM   2358  CG  ASP   317      35.834   9.908  -0.751  1.00 43.80           C  
ATOM   2359  OD1 ASP   317      35.538   8.695  -0.958  1.00 52.19           O  
ATOM   2360  OD2 ASP   317      35.326  10.862  -1.390  1.00 50.91           O  
ATOM   2361  N   LEU   318      38.760  10.086   2.862  1.00 52.68           N  
ATOM   2362  CA  LEU   318      40.060  10.306   3.503  1.00 52.67           C  
ATOM   2363  C   LEU   318      40.528   8.961   4.104  1.00 50.21           C  
ATOM   2364  O   LEU   318      41.663   8.570   3.915  1.00 48.06           O  
ATOM   2365  CB  LEU   318      39.920  11.404   4.559  1.00 54.71           C  
ATOM   2366  CG  LEU   318      41.133  12.145   5.091  1.00 58.12           C  
ATOM   2367  CD1 LEU   318      41.863  12.903   3.970  1.00 62.27           C  
ATOM   2368  CD2 LEU   318      40.626  13.101   6.178  1.00 56.81           C  
ATOM   2369  N   TYR   319      39.620   8.261   4.789  1.00 48.95           N  
ATOM   2370  CA  TYR   319      39.844   6.910   5.310  1.00 50.03           C  
ATOM   2371  C   TYR   319      40.305   5.925   4.213  1.00 49.32           C  
ATOM   2372  O   TYR   319      41.253   5.163   4.388  1.00 49.39           O  
ATOM   2373  CB  TYR   319      38.543   6.354   5.911  1.00 49.58           C  
ATOM   2374  CG  TYR   319      38.735   5.000   6.509  1.00 50.71           C  
ATOM   2375  CD1 TYR   319      39.209   4.868   7.816  1.00 53.95           C  
ATOM   2376  CD2 TYR   319      38.503   3.839   5.769  1.00 49.76           C  
ATOM   2377  CE1 TYR   319      39.417   3.611   8.382  1.00 50.20           C  
ATOM   2378  CE2 TYR   319      38.715   2.570   6.332  1.00 50.70           C  
ATOM   2379  CZ  TYR   319      39.181   2.473   7.636  1.00 48.87           C  
ATOM   2380  OH  TYR   319      39.412   1.243   8.222  1.00 55.17           O  
ATOM   2381  N   GLU   320      39.610   5.942   3.087  1.00 48.44           N  
ATOM   2382  CA  GLU   320      39.949   5.081   1.969  1.00 47.40           C  
ATOM   2383  C   GLU   320      41.382   5.376   1.478  1.00 47.27           C  
ATOM   2384  O   GLU   320      42.144   4.470   1.218  1.00 47.01           O  
ATOM   2385  CB  GLU   320      38.899   5.230   0.862  1.00 48.25           C  
ATOM   2386  CG  GLU   320      39.146   4.413  -0.404  1.00 53.06           C  
ATOM   2387  CD  GLU   320      39.248   2.937  -0.131  1.00 60.01           C  
ATOM   2388  OE1 GLU   320      38.389   2.421   0.625  1.00 62.46           O  
ATOM   2389  OE2 GLU   320      40.173   2.300  -0.683  1.00 64.07           O  
ATOM   2390  N   ILE   321      41.783   6.634   1.401  1.00 47.78           N  
ATOM   2391  CA  ILE   321      43.124   6.945   0.927  1.00 46.61           C  
ATOM   2392  C   ILE   321      44.188   6.472   1.918  1.00 49.20           C  
ATOM   2393  O   ILE   321      45.181   5.905   1.503  1.00 49.99           O  
ATOM   2394  CB  ILE   321      43.345   8.474   0.697  1.00 46.65           C  
ATOM   2395  CG1 ILE   321      42.435   9.044  -0.399  1.00 47.24           C  
ATOM   2396  CG2 ILE   321      44.833   8.770   0.354  1.00 46.81           C  
ATOM   2397  CD1 ILE   321      42.475  10.581  -0.480  1.00 44.25           C  
ATOM   2398  N   TYR   322      43.944   6.659   3.217  1.00 51.37           N  
ATOM   2399  CA  TYR   322      44.955   6.426   4.255  1.00 52.11           C  
ATOM   2400  C   TYR   322      44.790   5.294   5.274  1.00 52.84           C  
ATOM   2401  O   TYR   322      45.648   5.158   6.141  1.00 52.73           O  
ATOM   2402  CB  TYR   322      45.131   7.731   5.054  1.00 52.56           C  
ATOM   2403  CG  TYR   322      45.728   8.878   4.272  1.00 50.98           C  
ATOM   2404  CD1 TYR   322      47.060   8.846   3.839  1.00 48.79           C  
ATOM   2405  CD2 TYR   322      44.983  10.011   4.001  1.00 45.02           C  
ATOM   2406  CE1 TYR   322      47.617   9.924   3.125  1.00 52.27           C  
ATOM   2407  CE2 TYR   322      45.528  11.084   3.301  1.00 45.41           C  
ATOM   2408  CZ  TYR   322      46.823  11.035   2.861  1.00 48.21           C  
ATOM   2409  OH  TYR   322      47.315  12.106   2.173  1.00 52.00           O  
ATOM   2410  N   ALA   323      43.736   4.487   5.217  1.00 53.51           N  
ATOM   2411  CA  ALA   323      43.591   3.392   6.196  1.00 53.48           C  
ATOM   2412  C   ALA   323      44.597   2.246   5.980  1.00 58.30           C  
ATOM   2413  O   ALA   323      44.793   1.789   4.856  1.00 59.82           O  
ATOM   2414  CB  ALA   323      42.200   2.847   6.174  1.00 53.05           C  
ATOM   2415  N   GLY   324      45.207   1.768   7.069  1.00 60.94           N  
ATOM   2416  CA  GLY   324      46.171   0.668   7.002  1.00 63.08           C  
ATOM   2417  C   GLY   324      46.514   0.095   8.376  1.00 65.62           C  
ATOM   2418  O   GLY   324      47.440  -0.725   8.525  1.00 67.71           O  
END
