
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  125 (  956),  selected  125 , name 3bb9_D
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 3bb9_D.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    23_D      M       1           -
LGA    F    24_D      M       2           -
LGA    I    25_D      T       3          4.427
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    -       -      D       7           -
LGA    -       -      N       8           -
LGA    G    26_D      T       9           #
LGA    V    27_D      L      10          4.576
LGA    D    28_D      -       -           -
LGA    S    29_D      -       -           -
LGA    A    30_D      K      11          3.084
LGA    A    31_D      V      12          1.609
LGA    G    32_D      A      13          3.335
LGA    N    33_D      H      14          3.612
LGA    V    34_D      Q      15          2.781
LGA    V    35_D      G      16          2.253
LGA    K    36_D      F      17          2.668
LGA    Q    37_D      E      18          3.230
LGA    F    38_D      F      19          2.937
LGA    H    39_D      F      20          1.444
LGA    A    40_D      T      21          2.906
LGA    A    41_D      Q      22          3.593
LGA    L    42_D      G      23          1.595
LGA    Q    43_D      L      24          2.071
LGA    -       -      A      25           -
LGA    X    44_D      T      26          2.452
LGA    G    45_D      G      27          2.661
LGA    N    46_D      E      28          2.703
LGA    E    47_D      W      29          2.883
LGA    A    48_D      Q      30          2.287
LGA    I    49_D      K      31          0.563
LGA    V    50_D      F      32          1.924
LGA    R    51_D      L      33          1.870
LGA    Q    52_D      D      34          1.249
LGA    S    53_D      M      35          1.534
LGA    L    54_D      L      36          1.032
LGA    A    55_D      T      37          1.065
LGA    A    56_D      E      38          1.403
LGA    N    57_D      D      39          1.409
LGA    V    58_D      F      40          0.812
LGA    Q    59_D      T      41          0.711
LGA    I    60_D      F      42          0.923
LGA    Y    61_D      W      43          0.634
LGA    E    62_D      F      44          0.641
LGA    G    63_D      P      45          2.226
LGA    G    64_D      M      46          3.887
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    -       -      H      50           -
LGA    K    65_D      G      51          2.806
LGA    V    66_D      L      52          2.479
LGA    E    67_D      N      53          1.394
LGA    R    68_D      V      54          0.398
LGA    S    69_D      G      55          0.365
LGA    L    70_D      K      56          0.575
LGA    T    71_D      E      57          1.182
LGA    E    72_D      R      58          1.617
LGA    Y    73_D      A      59          1.686
LGA    A    74_D      K      60          1.199
LGA    N    75_D      E      61          3.328
LGA    H    76_D      -       -           -
LGA    H    77_D      F      62          1.156
LGA    X    78_D      F      63          1.515
LGA    L    79_D      T      64          0.560
LGA    A    80_D      Y      65          1.262
LGA    D    81_D      V      66          1.779
LGA    X    82_D      S      67          2.619
LGA    A    83_D      E      68          3.015
LGA    Y    84_D      S      69          4.738
LGA    L    85_D      F      70          5.241
LGA    K    86_D      H      71          5.104
LGA    G    87_D      T      72          3.613
LGA    -       -      G      73           -
LGA    L    88_D      I      74          2.461
LGA    T    89_D      Q      75          1.950
LGA    I    90_D      I      76          1.283
LGA    T    91_D      S      77          2.178
LGA    P    92_D      S      78          2.985
LGA    -       -      L      79           -
LGA    K    93_D      D      80          1.630
LGA    E    94_D      R      81          1.349
LGA    H    95_D      V      82          1.236
LGA    Q    96_D      T      83          1.537
LGA    I    97_D      S      84          2.408
LGA    T    98_D      N      85          2.289
LGA    I    99_D      E      86          3.254
LGA    T   100_D      -       -           -
LGA    G   101_D      -       -           -
LGA    D   102_D      -       -           -
LGA    I   103_D      -       -           -
LGA    A   104_D      T      87          2.130
LGA    I   105_D      T      88          0.662
LGA    S   106_D      V      89          0.878
LGA    T   107_D      V      90          0.660
LGA    S   108_D      F      91          1.223
LGA    I   109_D      E      92          1.142
LGA    S   110_D      F      93          1.009
LGA    H   111_D      R      94          0.813
LGA    A   112_D      D      95          1.283
LGA    Q   113_D      E      96          1.911
LGA    G   114_D      G      97          2.787
LGA    E   115_D      L      98          2.190
LGA    Y   116_D      F      99          0.376
LGA    K   117_D      L     100          1.353
LGA    G   118_D      G     101          2.376
LGA    K   119_D      K     102          2.157
LGA    S   120_D      P     103          2.078
LGA    I   121_D      Y     104          1.051
LGA    D   122_D      K     105          1.749
LGA    S   123_D      N     106          1.200
LGA    X   124_D      R     107          0.588
LGA    T   125_D      V     108          1.013
LGA    X   126_D      A     109          1.197
LGA    E   127_D      V     110          0.845
LGA    T   128_D      S     111          1.096
LGA    L   129_D      F     112          0.984
LGA    V   130_D      D     113          0.782
LGA    L   131_D      V     114          1.097
LGA    I   132_D      R     115          0.788
LGA    K   133_D      G     116          0.951
LGA    Q   134_D      -       -           -
LGA    A   135_D      -       -           -
LGA    D   136_D      -       -           -
LGA    G   137_D      -       -           -
LGA    R   138_D      -       -           -
LGA    W   139_D      D     117          1.913
LGA    K   140_D      K     118          1.432
LGA    I   141_D      I     119          1.315
LGA    T   142_D      C     120          1.194
LGA    H   143_D      S     121          1.210
LGA    V   144_D      Y     122          0.701
LGA    H   145_D      R     123          0.745
LGA    W   146_D      E     124          0.769
LGA    S   147_D      Y     125          2.011
LGA    -       -      F     126           -
LGA    -       -      G     127           -
LGA    -       -      S     128           -
LGA    -       -      D     129           -
LGA    -       -      G     130           -
LGA    -       -      K     131           -
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  125  133    5.0    110    2.13     8.18     69.145     4.923

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.278747 * X  +  -0.943361 * Y  +   0.179915 * Z  +  80.254486
  Y_new =   0.442353 * X  +   0.040164 * Y  +   0.895941 * Z  + -32.897003
  Z_new =  -0.852422 * X  +   0.329327 * Y  +   0.406103 * Z  + -48.415207 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.681378   -2.460214  [ DEG:    39.0401   -140.9599 ]
  Theta =   1.020601    2.120992  [ DEG:    58.4761    121.5239 ]
  Phi   =   2.133087   -1.008505  [ DEG:   122.2169    -57.7831 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bb9_D                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bb9_D.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  125  133   5.0  110   2.13    8.18  69.145
REMARK  ---------------------------------------------------------- 
MOLECULE 3bb9_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   09-NOV-07   3BB9              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE KETOSTEROID ISOMERASE                   
TITLE    2 (YP_750657.1) FROM SHEWANELLA FRIGIDIMARINA NCIMB 400 AT             
TITLE    3 1.80 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE ORPHAN PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHEWANELLA FRIGIDIMARINA NCIMB 400;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: NCIMB 400;                                                   
SOURCE   5 GENE: YP_750657.1, SFRI_1973;                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_750657.1, PUTATIVE KETOSTEROID ISOMERASE, STRUCTURAL               
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2, STRUCTURAL GENOMICS,            
KEYWDS   4 UNKNOWN FUNCTION                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   20-NOV-07 3BB9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE KETOSTEROID                    
JRNL        TITL 2 ISOMERASE (YP_750657.1) FROM SHEWANELLA                      
JRNL        TITL 3 FRIGIDIMARINA NCIMB 400 AT 1.80 A RESOLUTION                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  3BB9 A    1   147  UNP    Q082J6   Q082J6_SHEFN     1    147             
DBREF  3BB9 B    1   147  UNP    Q082J6   Q082J6_SHEFN     1    147             
DBREF  3BB9 C    1   147  UNP    Q082J6   Q082J6_SHEFN     1    147             
DBREF  3BB9 D    1   147  UNP    Q082J6   Q082J6_SHEFN     1    147             
DBREF  3BB9 E    1   147  UNP    Q082J6   Q082J6_SHEFN     1    147             
DBREF  3BB9 F    1   147  UNP    Q082J6   Q082J6_SHEFN     1    147             
SEQRES   1 A  148  GLY MSE SER ALA GLY GLN SER SER LEU SER PHE ALA HIS          
SEQRES   2 A  148  GLY ASP GLU THR HIS PRO ILE GLU GLN LYS ALA PHE ILE          
SEQRES   3 A  148  GLY VAL ASP SER ALA ALA GLY ASN VAL VAL LYS GLN PHE          
SEQRES   4 A  148  HIS ALA ALA LEU GLN MSE GLY ASN GLU ALA ILE VAL ARG          
SEQRES   5 A  148  GLN SER LEU ALA ALA ASN VAL GLN ILE TYR GLU GLY GLY          
SEQRES   6 A  148  LYS VAL GLU ARG SER LEU THR GLU TYR ALA ASN HIS HIS          
SEQRES   7 A  148  MSE LEU ALA ASP MSE ALA TYR LEU LYS GLY LEU THR ILE          
SEQRES   8 A  148  THR PRO LYS GLU HIS GLN ILE THR ILE THR GLY ASP ILE          
SEQRES   9 A  148  ALA ILE SER THR SER ILE SER HIS ALA GLN GLY GLU TYR          
SEQRES  10 A  148  LYS GLY LYS SER ILE ASP SER MSE THR MSE GLU THR LEU          
SEQRES  11 A  148  VAL LEU ILE LYS GLN ALA ASP GLY ARG TRP LYS ILE THR          
SEQRES  12 A  148  HIS VAL HIS TRP SER                                          
SEQRES   1 B  148  GLY MSE SER ALA GLY GLN SER SER LEU SER PHE ALA HIS          
SEQRES   2 B  148  GLY ASP GLU THR HIS PRO ILE GLU GLN LYS ALA PHE ILE          
SEQRES   3 B  148  GLY VAL ASP SER ALA ALA GLY ASN VAL VAL LYS GLN PHE          
SEQRES   4 B  148  HIS ALA ALA LEU GLN MSE GLY ASN GLU ALA ILE VAL ARG          
SEQRES   5 B  148  GLN SER LEU ALA ALA ASN VAL GLN ILE TYR GLU GLY GLY          
SEQRES   6 B  148  LYS VAL GLU ARG SER LEU THR GLU TYR ALA ASN HIS HIS          
SEQRES   7 B  148  MSE LEU ALA ASP MSE ALA TYR LEU LYS GLY LEU THR ILE          
SEQRES   8 B  148  THR PRO LYS GLU HIS GLN ILE THR ILE THR GLY ASP ILE          
SEQRES   9 B  148  ALA ILE SER THR SER ILE SER HIS ALA GLN GLY GLU TYR          
SEQRES  10 B  148  LYS GLY LYS SER ILE ASP SER MSE THR MSE GLU THR LEU          
SEQRES  11 B  148  VAL LEU ILE LYS GLN ALA ASP GLY ARG TRP LYS ILE THR          
SEQRES  12 B  148  HIS VAL HIS TRP SER                                          
SEQRES   1 C  148  GLY MSE SER ALA GLY GLN SER SER LEU SER PHE ALA HIS          
SEQRES   2 C  148  GLY ASP GLU THR HIS PRO ILE GLU GLN LYS ALA PHE ILE          
SEQRES   3 C  148  GLY VAL ASP SER ALA ALA GLY ASN VAL VAL LYS GLN PHE          
SEQRES   4 C  148  HIS ALA ALA LEU GLN MSE GLY ASN GLU ALA ILE VAL ARG          
SEQRES   5 C  148  GLN SER LEU ALA ALA ASN VAL GLN ILE TYR GLU GLY GLY          
SEQRES   6 C  148  LYS VAL GLU ARG SER LEU THR GLU TYR ALA ASN HIS HIS          
SEQRES   7 C  148  MSE LEU ALA ASP MSE ALA TYR LEU LYS GLY LEU THR ILE          
SEQRES   8 C  148  THR PRO LYS GLU HIS GLN ILE THR ILE THR GLY ASP ILE          
SEQRES   9 C  148  ALA ILE SER THR SER ILE SER HIS ALA GLN GLY GLU TYR          
SEQRES  10 C  148  LYS GLY LYS SER ILE ASP SER MSE THR MSE GLU THR LEU          
SEQRES  11 C  148  VAL LEU ILE LYS GLN ALA ASP GLY ARG TRP LYS ILE THR          
SEQRES  12 C  148  HIS VAL HIS TRP SER                                          
SEQRES   1 D  148  GLY MSE SER ALA GLY GLN SER SER LEU SER PHE ALA HIS          
SEQRES   2 D  148  GLY ASP GLU THR HIS PRO ILE GLU GLN LYS ALA PHE ILE          
SEQRES   3 D  148  GLY VAL ASP SER ALA ALA GLY ASN VAL VAL LYS GLN PHE          
SEQRES   4 D  148  HIS ALA ALA LEU GLN MSE GLY ASN GLU ALA ILE VAL ARG          
SEQRES   5 D  148  GLN SER LEU ALA ALA ASN VAL GLN ILE TYR GLU GLY GLY          
SEQRES   6 D  148  LYS VAL GLU ARG SER LEU THR GLU TYR ALA ASN HIS HIS          
SEQRES   7 D  148  MSE LEU ALA ASP MSE ALA TYR LEU LYS GLY LEU THR ILE          
SEQRES   8 D  148  THR PRO LYS GLU HIS GLN ILE THR ILE THR GLY ASP ILE          
SEQRES   9 D  148  ALA ILE SER THR SER ILE SER HIS ALA GLN GLY GLU TYR          
SEQRES  10 D  148  LYS GLY LYS SER ILE ASP SER MSE THR MSE GLU THR LEU          
SEQRES  11 D  148  VAL LEU ILE LYS GLN ALA ASP GLY ARG TRP LYS ILE THR          
SEQRES  12 D  148  HIS VAL HIS TRP SER                                          
SEQRES   1 E  148  GLY MSE SER ALA GLY GLN SER SER LEU SER PHE ALA HIS          
SEQRES   2 E  148  GLY ASP GLU THR HIS PRO ILE GLU GLN LYS ALA PHE ILE          
SEQRES   3 E  148  GLY VAL ASP SER ALA ALA GLY ASN VAL VAL LYS GLN PHE          
SEQRES   4 E  148  HIS ALA ALA LEU GLN MSE GLY ASN GLU ALA ILE VAL ARG          
SEQRES   5 E  148  GLN SER LEU ALA ALA ASN VAL GLN ILE TYR GLU GLY GLY          
SEQRES   6 E  148  LYS VAL GLU ARG SER LEU THR GLU TYR ALA ASN HIS HIS          
SEQRES   7 E  148  MSE LEU ALA ASP MSE ALA TYR LEU LYS GLY LEU THR ILE          
SEQRES   8 E  148  THR PRO LYS GLU HIS GLN ILE THR ILE THR GLY ASP ILE          
SEQRES   9 E  148  ALA ILE SER THR SER ILE SER HIS ALA GLN GLY GLU TYR          
SEQRES  10 E  148  LYS GLY LYS SER ILE ASP SER MSE THR MSE GLU THR LEU          
SEQRES  11 E  148  VAL LEU ILE LYS GLN ALA ASP GLY ARG TRP LYS ILE THR          
SEQRES  12 E  148  HIS VAL HIS TRP SER                                          
SEQRES   1 F  148  GLY MSE SER ALA GLY GLN SER SER LEU SER PHE ALA HIS          
SEQRES   2 F  148  GLY ASP GLU THR HIS PRO ILE GLU GLN LYS ALA PHE ILE          
SEQRES   3 F  148  GLY VAL ASP SER ALA ALA GLY ASN VAL VAL LYS GLN PHE          
SEQRES   4 F  148  HIS ALA ALA LEU GLN MSE GLY ASN GLU ALA ILE VAL ARG          
SEQRES   5 F  148  GLN SER LEU ALA ALA ASN VAL GLN ILE TYR GLU GLY GLY          
SEQRES   6 F  148  LYS VAL GLU ARG SER LEU THR GLU TYR ALA ASN HIS HIS          
SEQRES   7 F  148  MSE LEU ALA ASP MSE ALA TYR LEU LYS GLY LEU THR ILE          
SEQRES   8 F  148  THR PRO LYS GLU HIS GLN ILE THR ILE THR GLY ASP ILE          
SEQRES   9 F  148  ALA ILE SER THR SER ILE SER HIS ALA GLN GLY GLU TYR          
SEQRES  10 F  148  LYS GLY LYS SER ILE ASP SER MSE THR MSE GLU THR LEU          
SEQRES  11 F  148  VAL LEU ILE LYS GLN ALA ASP GLY ARG TRP LYS ILE THR          
SEQRES  12 F  148  HIS VAL HIS TRP SER                                          
HET    MSE  A  44       8                                                       
HET    MSE  A  78       8                                                       
HET    MSE  A  82       8                                                       
HET    MSE  A 124       8                                                       
HET    MSE  A 126       8                                                       
HET    MSE  B  44       8                                                       
HET    MSE  B  78       8                                                       
HET    MSE  B  82       8                                                       
HET    MSE  B 124       8                                                       
HET    MSE  B 126       8                                                       
HET    MSE  C  44       8                                                       
HET    MSE  C  78       8                                                       
HET    MSE  C  82       8                                                       
HET    MSE  C 124       8                                                       
HET    MSE  C 126       8                                                       
HET    MSE  D  44      16                                                       
HET    MSE  D  78       8                                                       
HET    MSE  D  82       8                                                       
HET    MSE  D 124       8                                                       
HET    MSE  D 126       8                                                       
HET    MSE  E  44      16                                                       
HET    MSE  E  78       8                                                       
HET    MSE  E  82       8                                                       
HET    MSE  E 124       8                                                       
HET    MSE  E 126       8                                                       
HET    MSE  F  44       8                                                       
HET    MSE  F  78       8                                                       
HET    MSE  F  82       8                                                       
HET    MSE  F 124       8                                                       
HET    MSE  F 126       8                                                       
HET    EDO  A 148       4                                                       
HET    EDO  B 148       4                                                       
HET    EDO  C 148       4                                                       
HET    EDO  F 148       4                                                       
HET    EDO  B 149       4                                                       
HET    EDO  C 149       4                                                       
HET    EDO  C 150       4                                                       
HET    EDO  B 150       4                                                       
HET    EDO  C 151       4                                                       
HET    EDO  D 148       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    30(C5 H11 N O2 SE)                                           
FORMUL   7  EDO    10(C2 H6 O2)                                                 
FORMUL  17  HOH   *611(H2 O)                                                    
CRYST1   42.558  113.820  137.132  90.00  90.00  90.00 P 21 21 21   24          
ATOM   2889  N   ALA D  23      38.643   5.666  18.201  1.00 22.21           N  
ATOM   2890  CA  ALA D  23      37.795   6.446  17.270  1.00 24.59           C  
ATOM   2891  C   ALA D  23      37.765   5.781  15.897  1.00 22.19           C  
ATOM   2892  O   ALA D  23      38.749   5.212  15.467  1.00 22.05           O  
ATOM   2893  CB  ALA D  23      38.292   7.929  17.132  1.00 21.82           C  
ATOM   2894  N   PHE D  24      36.618   5.871  15.232  1.00 24.07           N  
ATOM   2895  CA  PHE D  24      36.437   5.350  13.863  1.00 23.14           C  
ATOM   2896  C   PHE D  24      36.496   6.466  12.833  1.00 22.92           C  
ATOM   2897  O   PHE D  24      36.021   7.562  13.070  1.00 21.77           O  
ATOM   2898  CB  PHE D  24      35.076   4.608  13.733  1.00 25.14           C  
ATOM   2899  CG  PHE D  24      35.033   3.313  14.487  1.00 24.65           C  
ATOM   2900  CD1 PHE D  24      35.832   2.233  14.094  1.00 24.97           C  
ATOM   2901  CD2 PHE D  24      34.231   3.172  15.613  1.00 23.44           C  
ATOM   2902  CE1 PHE D  24      35.805   1.025  14.819  1.00 30.10           C  
ATOM   2903  CE2 PHE D  24      34.221   1.973  16.338  1.00 27.81           C  
ATOM   2904  CZ  PHE D  24      34.989   0.917  15.934  1.00 24.77           C  
ATOM   2905  N   ILE D  25      37.074   6.183  11.680  1.00 19.95           N  
ATOM   2906  CA  ILE D  25      37.129   7.181  10.616  1.00 20.06           C  
ATOM   2907  C   ILE D  25      35.758   7.782  10.275  1.00 22.71           C  
ATOM   2908  O   ILE D  25      34.749   7.077  10.107  1.00 21.72           O  
ATOM   2909  CB  ILE D  25      37.797   6.651   9.321  1.00 15.34           C  
ATOM   2910  CG1 ILE D  25      39.219   6.225   9.669  1.00 12.56           C  
ATOM   2911  CG2 ILE D  25      37.773   7.809   8.230  1.00 14.73           C  
ATOM   2912  CD1 ILE D  25      39.901   5.194   8.785  1.00 15.09           C  
ATOM   2913  N   GLY D  26      35.746   9.111  10.191  1.00 20.40           N  
ATOM   2914  CA  GLY D  26      34.619   9.865   9.721  1.00 22.40           C  
ATOM   2915  C   GLY D  26      33.528  10.035  10.753  1.00 23.10           C  
ATOM   2916  O   GLY D  26      33.191  11.167  11.140  1.00 24.70           O  
ATOM   2917  N   VAL D  27      32.945   8.915  11.180  1.00 23.71           N  
ATOM   2918  CA  VAL D  27      31.827   8.971  12.135  1.00 23.17           C  
ATOM   2919  C   VAL D  27      32.284   9.586  13.481  1.00 24.78           C  
ATOM   2920  O   VAL D  27      31.455  10.128  14.206  1.00 26.51           O  
ATOM   2921  CB  VAL D  27      31.173   7.590  12.322  1.00 25.99           C  
ATOM   2922  CG1 VAL D  27      30.557   7.123  10.974  1.00 23.04           C  
ATOM   2923  CG2 VAL D  27      32.185   6.572  12.889  1.00 21.43           C  
ATOM   2924  N   ASP D  28      33.591   9.554  13.766  0.50 22.16           N  
ATOM   2926  CA  ASP D  28      34.142  10.106  15.023  0.50 24.54           C  
ATOM   2928  C   ASP D  28      35.070  11.322  14.858  0.50 21.81           C  
ATOM   2930  O   ASP D  28      35.931  11.569  15.698  0.50 22.07           O  
ATOM   2932  CB  ASP D  28      34.857   9.000  15.805  1.00 25.04           C  
ATOM   2933  CG  ASP D  28      33.889   7.930  16.291  1.00 28.36           C  
ATOM   2934  OD1 ASP D  28      32.709   8.246  16.561  1.00 27.71           O  
ATOM   2935  OD2 ASP D  28      34.344   6.780  16.455  1.00 24.68           O  
ATOM   2936  N   SER D  29      34.797  12.129  13.840  1.00 26.01           N  
ATOM   2937  CA  SER D  29      35.598  13.297  13.495  1.00 24.17           C  
ATOM   2938  C   SER D  29      34.926  14.505  14.134  1.00 23.31           C  
ATOM   2939  O   SER D  29      33.835  14.356  14.715  1.00 23.57           O  
ATOM   2940  CB  SER D  29      35.610  13.466  11.990  1.00 21.39           C  
ATOM   2941  OG  SER D  29      34.315  13.629  11.467  1.00 20.49           O  
ATOM   2942  N   ALA D  30      35.525  15.688  14.017  1.00 19.54           N  
ATOM   2943  CA  ALA D  30      34.874  16.900  14.482  1.00 21.15           C  
ATOM   2944  C   ALA D  30      33.497  17.020  13.748  1.00 20.92           C  
ATOM   2945  O   ALA D  30      32.481  17.279  14.392  1.00 18.58           O  
ATOM   2946  CB  ALA D  30      35.770  18.124  14.265  1.00 17.17           C  
ATOM   2947  N   ALA D  31      33.430  16.779  12.428  1.00 19.70           N  
ATOM   2948  CA  ALA D  31      32.107  16.811  11.719  1.00 19.69           C  
ATOM   2949  C   ALA D  31      31.151  15.734  12.247  1.00 18.47           C  
ATOM   2950  O   ALA D  31      29.946  15.993  12.531  1.00 18.66           O  
ATOM   2951  CB  ALA D  31      32.255  16.693  10.154  1.00 17.73           C  
ATOM   2952  N   GLY D  32      31.700  14.538  12.446  1.00 17.98           N  
ATOM   2953  CA  GLY D  32      30.913  13.437  12.966  1.00 19.35           C  
ATOM   2954  C   GLY D  32      30.340  13.786  14.323  1.00 17.04           C  
ATOM   2955  O   GLY D  32      29.201  13.403  14.638  1.00 21.06           O  
ATOM   2956  N   ASN D  33      31.119  14.485  15.124  1.00 19.17           N  
ATOM   2957  CA  ASN D  33      30.645  14.868  16.487  1.00 19.96           C  
ATOM   2958  C   ASN D  33      29.460  15.838  16.482  1.00 18.64           C  
ATOM   2959  O   ASN D  33      28.534  15.700  17.285  1.00 18.13           O  
ATOM   2960  CB  ASN D  33      31.804  15.365  17.338  1.00 22.80           C  
ATOM   2961  CG  ASN D  33      32.766  14.224  17.727  1.00 31.21           C  
ATOM   2962  OD1 ASN D  33      32.452  13.049  17.551  1.00 28.13           O  
ATOM   2963  ND2 ASN D  33      33.932  14.580  18.245  1.00 34.51           N  
ATOM   2964  N   VAL D  34      29.433  16.759  15.528  1.00 17.68           N  
ATOM   2965  CA  VAL D  34      28.278  17.660  15.367  1.00 16.55           C  
ATOM   2966  C   VAL D  34      27.017  16.853  15.019  1.00 20.48           C  
ATOM   2967  O   VAL D  34      25.958  17.145  15.540  1.00 18.99           O  
ATOM   2968  CB  VAL D  34      28.572  18.772  14.362  1.00 14.32           C  
ATOM   2969  CG1 VAL D  34      27.374  19.606  14.150  1.00 18.24           C  
ATOM   2970  CG2 VAL D  34      29.829  19.608  14.816  1.00 16.69           C  
ATOM   2971  N   VAL D  35      27.126  15.874  14.125  1.00 18.34           N  
ATOM   2972  CA  VAL D  35      26.013  15.011  13.792  1.00 17.26           C  
ATOM   2973  C   VAL D  35      25.535  14.299  15.051  1.00 15.12           C  
ATOM   2974  O   VAL D  35      24.375  14.345  15.358  1.00 16.83           O  
ATOM   2975  CB  VAL D  35      26.396  13.955  12.686  1.00 17.57           C  
ATOM   2976  CG1 VAL D  35      25.214  13.059  12.319  1.00 18.59           C  
ATOM   2977  CG2 VAL D  35      26.974  14.662  11.448  1.00 20.87           C  
ATOM   2978  N   LYS D  36      26.429  13.693  15.805  1.00 18.07           N  
ATOM   2979  CA  LYS D  36      26.020  13.029  17.015  1.00 20.86           C  
ATOM   2980  C   LYS D  36      25.324  13.921  18.005  1.00 20.32           C  
ATOM   2981  O   LYS D  36      24.329  13.514  18.591  1.00 20.63           O  
ATOM   2982  CB  LYS D  36      27.236  12.478  17.722  1.00 19.84           C  
ATOM   2983  CG  LYS D  36      27.827  11.311  17.043  1.00 26.68           C  
ATOM   2984  CD  LYS D  36      29.006  10.837  17.895  1.00 25.77           C  
ATOM   2985  CE  LYS D  36      30.136  10.315  17.053  1.00 32.79           C  
ATOM   2986  NZ  LYS D  36      31.317  10.064  17.890  1.00 27.35           N  
ATOM   2987  N   GLN D  37      25.888  15.107  18.226  1.00 19.07           N  
ATOM   2988  CA  GLN D  37      25.320  16.090  19.119  1.00 21.52           C  
ATOM   2989  C   GLN D  37      23.957  16.541  18.679  1.00 19.80           C  
ATOM   2990  O   GLN D  37      23.093  16.750  19.527  1.00 20.01           O  
ATOM   2991  CB  GLN D  37      26.229  17.315  19.172  1.00 22.77           C  
ATOM   2992  CG  GLN D  37      27.465  17.027  19.961  1.00 27.72           C  
ATOM   2993  CD  GLN D  37      28.613  17.998  19.660  1.00 42.89           C  
ATOM   2994  OE1 GLN D  37      28.400  19.079  19.096  1.00 47.21           O  
ATOM   2995  NE2 GLN D  37      29.841  17.602  20.031  1.00 48.72           N  
ATOM   2996  N   PHE D  38      23.789  16.736  17.377  1.00 17.07           N  
ATOM   2997  CA  PHE D  38      22.516  17.159  16.787  1.00 17.89           C  
ATOM   2998  C   PHE D  38      21.429  16.107  17.066  1.00 18.61           C  
ATOM   2999  O   PHE D  38      20.334  16.401  17.565  1.00 16.93           O  
ATOM   3000  CB  PHE D  38      22.739  17.410  15.284  1.00 18.86           C  
ATOM   3001  CG  PHE D  38      21.477  17.773  14.493  1.00 18.12           C  
ATOM   3002  CD1 PHE D  38      20.677  18.836  14.862  1.00 16.78           C  
ATOM   3003  CD2 PHE D  38      21.133  17.033  13.359  1.00 21.11           C  
ATOM   3004  CE1 PHE D  38      19.533  19.151  14.132  1.00 20.71           C  
ATOM   3005  CE2 PHE D  38      20.003  17.328  12.620  1.00 22.82           C  
ATOM   3006  CZ  PHE D  38      19.207  18.385  12.983  1.00 20.10           C  
ATOM   3007  N   HIS D  39      21.757  14.857  16.797  1.00 15.91           N  
ATOM   3008  CA  HIS D  39      20.827  13.794  17.000  1.00 21.26           C  
ATOM   3009  C   HIS D  39      20.455  13.706  18.467  1.00 19.44           C  
ATOM   3010  O   HIS D  39      19.283  13.633  18.806  1.00 19.17           O  
ATOM   3011  CB  HIS D  39      21.430  12.465  16.576  1.00 20.30           C  
ATOM   3012  CG  HIS D  39      21.581  12.320  15.095  1.00 23.87           C  
ATOM   3013  ND1 HIS D  39      22.484  11.449  14.535  1.00 31.28           N  
ATOM   3014  CD2 HIS D  39      20.984  12.960  14.063  1.00 29.02           C  
ATOM   3015  CE1 HIS D  39      22.392  11.519  13.214  1.00 23.38           C  
ATOM   3016  NE2 HIS D  39      21.498  12.430  12.906  1.00 20.53           N  
ATOM   3017  N   ALA D  40      21.462  13.732  19.338  1.00 18.60           N  
ATOM   3018  CA  ALA D  40      21.184  13.613  20.771  1.00 17.97           C  
ATOM   3019  C   ALA D  40      20.335  14.770  21.302  1.00 20.04           C  
ATOM   3020  O   ALA D  40      19.471  14.562  22.166  1.00 21.75           O  
ATOM   3021  CB  ALA D  40      22.516  13.473  21.579  1.00 20.04           C  
ATOM   3022  N   ALA D  41      20.623  15.984  20.835  1.00 17.33           N  
ATOM   3023  CA  ALA D  41      19.954  17.196  21.270  1.00 20.46           C  
ATOM   3024  C   ALA D  41      18.477  17.164  20.861  1.00 19.30           C  
ATOM   3025  O   ALA D  41      17.607  17.601  21.634  1.00 18.27           O  
ATOM   3026  CB  ALA D  41      20.645  18.399  20.683  1.00 18.59           C  
ATOM   3027  N   LEU D  42      18.199  16.677  19.652  1.00 19.88           N  
ATOM   3028  CA  LEU D  42      16.795  16.505  19.217  1.00 21.45           C  
ATOM   3029  C   LEU D  42      16.056  15.479  20.064  1.00 20.54           C  
ATOM   3030  O   LEU D  42      14.933  15.696  20.466  1.00 21.11           O  
ATOM   3031  CB  LEU D  42      16.672  16.090  17.743  1.00 22.12           C  
ATOM   3032  CG  LEU D  42      16.783  17.208  16.706  1.00 16.84           C  
ATOM   3033  CD1 LEU D  42      16.979  16.611  15.317  1.00 27.47           C  
ATOM   3034  CD2 LEU D  42      15.625  18.223  16.728  1.00 16.15           C  
ATOM   3035  N   GLN D  43      16.715  14.354  20.307  1.00 22.18           N  
ATOM   3036  CA  GLN D  43      16.147  13.273  21.102  1.00 24.69           C  
ATOM   3037  C   GLN D  43      15.924  13.628  22.580  1.00 24.22           C  
ATOM   3038  O   GLN D  43      15.017  13.093  23.189  1.00 25.13           O  
ATOM   3039  CB  GLN D  43      17.018  12.001  20.971  1.00 23.82           C  
ATOM   3040  CG  GLN D  43      16.991  11.401  19.549  1.00 28.88           C  
ATOM   3041  CD  GLN D  43      18.096  10.369  19.252  1.00 27.85           C  
ATOM   3042  OE1 GLN D  43      18.637   9.763  20.158  1.00 31.84           O  
ATOM   3043  NE2 GLN D  43      18.395  10.159  17.966  1.00 33.05           N  
HETATM 3044  N   MSE D  44      16.756  14.518  23.127  0.50 23.37           N  
HETATM 3046  CA  MSE D  44      16.697  14.888  24.544  0.50 23.81           C  
HETATM 3048  C   MSE D  44      16.042  16.246  24.806  0.50 23.50           C  
HETATM 3050  O   MSE D  44      15.807  16.613  25.963  0.50 23.02           O  
HETATM 3052  CB  MSE D  44      18.115  14.869  25.131  0.50 24.16           C  
HETATM 3054  CG  MSE D  44      18.733  13.480  25.176  0.50 23.86           C  
HETATM 3056 SE   MSE D  44      20.647  13.442  25.538  0.38 19.23          SE  
HETATM 3058  CE  MSE D  44      20.783  14.955  26.749  0.50 17.77           C  
ATOM   3060  N   GLY D  45      15.719  16.977  23.746  1.00 23.50           N  
ATOM   3061  CA  GLY D  45      15.090  18.290  23.869  1.00 22.75           C  
ATOM   3062  C   GLY D  45      15.983  19.435  24.312  1.00 23.62           C  
ATOM   3063  O   GLY D  45      15.572  20.269  25.137  1.00 24.33           O  
ATOM   3064  N   ASN D  46      17.200  19.466  23.779  1.00 22.83           N  
ATOM   3065  CA  ASN D  46      18.161  20.528  24.046  1.00 20.43           C  
ATOM   3066  C   ASN D  46      18.254  21.464  22.849  1.00 23.20           C  
ATOM   3067  O   ASN D  46      19.036  21.248  21.918  1.00 19.27           O  
ATOM   3068  CB  ASN D  46      19.513  19.934  24.390  1.00 19.61           C  
ATOM   3069  CG  ASN D  46      20.490  20.972  24.949  1.00 20.12           C  
ATOM   3070  OD1 ASN D  46      20.511  22.114  24.513  1.00 19.83           O  
ATOM   3071  ND2 ASN D  46      21.326  20.552  25.891  1.00 14.50           N  
ATOM   3072  N   GLU D  47      17.495  22.547  22.896  1.00 21.26           N  
ATOM   3073  CA  GLU D  47      17.422  23.446  21.771  1.00 22.52           C  
ATOM   3074  C   GLU D  47      18.702  24.286  21.623  1.00 22.46           C  
ATOM   3075  O   GLU D  47      19.044  24.669  20.518  1.00 19.73           O  
ATOM   3076  CB  GLU D  47      16.137  24.312  21.847  1.00 31.03           C  
ATOM   3077  CG  GLU D  47      16.259  25.627  22.569  1.00 27.23           C  
ATOM   3078  CD  GLU D  47      15.088  26.560  22.231  1.00 32.22           C  
ATOM   3079  OE1 GLU D  47      13.912  26.174  22.451  1.00 40.80           O  
ATOM   3080  OE2 GLU D  47      15.364  27.661  21.726  1.00 42.72           O  
ATOM   3081  N   ALA D  48      19.439  24.513  22.723  1.00 22.57           N  
ATOM   3082  CA  ALA D  48      20.733  25.205  22.675  1.00 20.93           C  
ATOM   3083  C   ALA D  48      21.727  24.456  21.776  1.00 20.28           C  
ATOM   3084  O   ALA D  48      22.390  25.056  20.915  1.00 18.25           O  
ATOM   3085  CB  ALA D  48      21.337  25.379  24.119  1.00 18.42           C  
ATOM   3086  N   ILE D  49      21.820  23.148  21.969  1.00 17.57           N  
ATOM   3087  CA  ILE D  49      22.767  22.339  21.208  1.00 17.64           C  
ATOM   3088  C   ILE D  49      22.238  22.120  19.770  1.00 18.71           C  
ATOM   3089  O   ILE D  49      23.001  22.083  18.859  1.00 16.61           O  
ATOM   3090  CB  ILE D  49      23.049  20.973  21.835  1.00 17.72           C  
ATOM   3091  CG1 ILE D  49      23.771  21.108  23.174  1.00 23.07           C  
ATOM   3092  CG2 ILE D  49      23.892  20.146  20.890  1.00 19.75           C  
ATOM   3093  CD1 ILE D  49      23.935  19.784  23.877  1.00 26.31           C  
ATOM   3094  N   VAL D  50      20.934  22.089  19.580  1.00 19.50           N  
ATOM   3095  CA  VAL D  50      20.417  22.083  18.193  1.00 23.42           C  
ATOM   3096  C   VAL D  50      20.846  23.356  17.462  1.00 22.92           C  
ATOM   3097  O   VAL D  50      21.398  23.299  16.354  1.00 20.60           O  
ATOM   3098  CB  VAL D  50      18.864  21.856  18.123  1.00 25.55           C  
ATOM   3099  CG1 VAL D  50      18.352  22.119  16.695  1.00 25.06           C  
ATOM   3100  CG2 VAL D  50      18.493  20.479  18.634  1.00 21.92           C  
ATOM   3101  N   ARG D  51      20.648  24.516  18.087  0.50 25.33           N  
ATOM   3103  CA  ARG D  51      21.018  25.805  17.481  0.50 25.15           C  
ATOM   3105  C   ARG D  51      22.518  26.012  17.256  0.50 25.80           C  
ATOM   3107  O   ARG D  51      22.913  26.827  16.424  0.50 30.29           O  
ATOM   3109  CB  ARG D  51      20.445  26.973  18.308  0.50 25.40           C  
ATOM   3111  CG  ARG D  51      18.933  27.146  18.144  0.50 26.69           C  
ATOM   3113  CD  ARG D  51      18.366  28.097  19.204  0.50 27.33           C  
ATOM   3115  NE  ARG D  51      17.072  28.662  18.828  0.50 28.47           N  
ATOM   3117  CZ  ARG D  51      16.903  29.629  17.921  0.50 26.72           C  
ATOM   3119  NH1 ARG D  51      17.939  30.122  17.245  0.50 16.50           N  
ATOM   3121  NH2 ARG D  51      15.681  30.092  17.668  0.50 28.76           N  
ATOM   3123  N   GLN D  52      23.346  25.326  18.034  1.00 23.81           N  
ATOM   3124  CA  GLN D  52      24.772  25.315  17.841  1.00 23.73           C  
ATOM   3125  C   GLN D  52      25.214  24.456  16.658  1.00 22.08           C  
ATOM   3126  O   GLN D  52      26.240  24.710  16.047  1.00 23.01           O  
ATOM   3127  CB  GLN D  52      25.389  24.718  19.096  1.00 27.08           C  
ATOM   3128  CG  GLN D  52      26.859  24.814  19.179  1.00 39.49           C  
ATOM   3129  CD  GLN D  52      27.304  24.872  20.615  1.00 50.76           C  
ATOM   3130  OE1 GLN D  52      28.168  25.675  20.965  1.00 58.41           O  
ATOM   3131  NE2 GLN D  52      26.674  24.060  21.473  1.00 51.12           N  
ATOM   3132  N   SER D  53      24.429  23.432  16.365  1.00 20.26           N  
ATOM   3133  CA  SER D  53      24.772  22.424  15.327  1.00 17.80           C  
ATOM   3134  C   SER D  53      24.364  22.882  13.931  1.00 19.76           C  
ATOM   3135  O   SER D  53      24.904  22.427  12.948  1.00 16.80           O  
ATOM   3136  CB  SER D  53      24.063  21.117  15.656  1.00 20.81           C  
ATOM   3137  OG  SER D  53      24.520  20.575  16.893  1.00 21.30           O  
ATOM   3138  N   LEU D  54      23.410  23.788  13.861  1.00 17.56           N  
ATOM   3139  CA  LEU D  54      22.859  24.268  12.588  1.00 18.51           C  
ATOM   3140  C   LEU D  54      23.300  25.687  12.169  1.00 18.30           C  
ATOM   3141  O   LEU D  54      23.318  26.606  12.967  1.00 17.70           O  
ATOM   3142  CB  LEU D  54      21.336  24.264  12.727  1.00 13.71           C  
ATOM   3143  CG  LEU D  54      20.598  22.980  13.089  1.00 21.01           C  
ATOM   3144  CD1 LEU D  54      19.092  23.290  13.278  1.00 27.89           C  
ATOM   3145  CD2 LEU D  54      20.814  21.922  11.988  1.00 16.49           C  
ATOM   3146  N   ALA D  55      23.605  25.853  10.892  1.00 15.80           N  
ATOM   3147  CA  ALA D  55      23.955  27.132  10.313  1.00 13.25           C  
ATOM   3148  C   ALA D  55      22.738  28.037  10.443  1.00 13.31           C  
ATOM   3149  O   ALA D  55      21.577  27.582  10.351  1.00 17.49           O  
ATOM   3150  CB  ALA D  55      24.384  26.954   8.865  1.00 12.86           C  
ATOM   3151  N   ALA D  56      22.979  29.309  10.657  1.00 17.36           N  
ATOM   3152  CA  ALA D  56      21.882  30.284  10.687  1.00 16.11           C  
ATOM   3153  C   ALA D  56      21.013  30.153   9.424  1.00 16.74           C  
ATOM   3154  O   ALA D  56      19.810  30.359   9.466  1.00 16.93           O  
ATOM   3155  CB  ALA D  56      22.432  31.760  10.854  1.00 16.34           C  
ATOM   3156  N   ASN D  57      21.605  29.806   8.284  1.00 15.24           N  
ATOM   3157  CA  ASN D  57      20.795  29.682   7.035  1.00 19.00           C  
ATOM   3158  C   ASN D  57      20.560  28.233   6.577  1.00 19.75           C  
ATOM   3159  O   ASN D  57      20.421  27.932   5.381  1.00 19.34           O  
ATOM   3160  CB  ASN D  57      21.402  30.527   5.910  1.00 22.89           C  
ATOM   3161  CG  ASN D  57      22.767  30.038   5.494  1.00 25.75           C  
ATOM   3162  OD1 ASN D  57      23.357  29.167   6.147  1.00 28.47           O  
ATOM   3163  ND2 ASN D  57      23.278  30.588   4.385  1.00 29.66           N  
ATOM   3164  N   VAL D  58      20.526  27.334   7.548  1.00 17.23           N  
ATOM   3165  CA  VAL D  58      20.263  25.943   7.291  1.00 16.73           C  
ATOM   3166  C   VAL D  58      18.974  25.790   6.440  1.00 15.26           C  
ATOM   3167  O   VAL D  58      17.965  26.515   6.609  1.00 13.40           O  
ATOM   3168  CB  VAL D  58      20.200  25.062   8.582  1.00 18.17           C  
ATOM   3169  CG1 VAL D  58      19.017  25.442   9.535  1.00 16.22           C  
ATOM   3170  CG2 VAL D  58      20.268  23.527   8.204  1.00 13.86           C  
ATOM   3171  N   GLN D  59      19.065  24.835   5.517  1.00 16.06           N  
ATOM   3172  CA  GLN D  59      17.939  24.365   4.714  1.00 16.13           C  
ATOM   3173  C   GLN D  59      17.470  22.985   5.196  1.00 15.72           C  
ATOM   3174  O   GLN D  59      18.278  22.055   5.391  1.00 17.53           O  
ATOM   3175  CB  GLN D  59      18.360  24.289   3.270  1.00 16.45           C  
ATOM   3176  CG  GLN D  59      17.285  23.793   2.385  1.00 22.68           C  
ATOM   3177  CD  GLN D  59      17.630  23.907   0.925  1.00 24.26           C  
ATOM   3178  OE1 GLN D  59      17.132  24.806   0.244  1.00 21.68           O  
ATOM   3179  NE2 GLN D  59      18.437  22.956   0.412  1.00 14.49           N  
ATOM   3180  N   ILE D  60      16.172  22.860   5.439  1.00 13.08           N  
ATOM   3181  CA  ILE D  60      15.584  21.633   5.969  1.00 16.92           C  
ATOM   3182  C   ILE D  60      14.531  21.109   4.997  1.00 15.73           C  
ATOM   3183  O   ILE D  60      13.574  21.805   4.687  1.00 16.28           O  
ATOM   3184  CB  ILE D  60      14.881  21.810   7.384  1.00 18.10           C  
ATOM   3185  CG1 ILE D  60      15.700  22.620   8.364  1.00 23.78           C  
ATOM   3186  CG2 ILE D  60      14.493  20.450   7.997  1.00 20.10           C  
ATOM   3187  CD1 ILE D  60      16.743  21.886   8.957  1.00 13.87           C  
ATOM   3188  N   TYR D  61      14.756  19.882   4.492  1.00 14.84           N  
ATOM   3189  CA  TYR D  61      13.830  19.182   3.662  1.00 15.03           C  
ATOM   3190  C   TYR D  61      13.151  18.019   4.428  1.00 15.87           C  
ATOM   3191  O   TYR D  61      13.819  17.050   4.897  1.00 13.82           O  
ATOM   3192  CB  TYR D  61      14.545  18.558   2.474  1.00 14.41           C  
ATOM   3193  CG  TYR D  61      14.791  19.404   1.267  1.00 15.47           C  
ATOM   3194  CD1 TYR D  61      14.747  20.804   1.296  1.00 13.77           C  
ATOM   3195  CD2 TYR D  61      15.196  18.794   0.087  1.00 14.65           C  
ATOM   3196  CE1 TYR D  61      15.032  21.539   0.129  1.00 16.88           C  
ATOM   3197  CE2 TYR D  61      15.453  19.508  -1.045  1.00 12.55           C  
ATOM   3198  CZ  TYR D  61      15.355  20.876  -1.031  1.00 15.30           C  
ATOM   3199  OH  TYR D  61      15.653  21.581  -2.195  1.00 12.77           O  
ATOM   3200  N   GLU D  62      11.827  18.039   4.476  1.00 15.66           N  
ATOM   3201  CA  GLU D  62      11.080  16.919   5.043  1.00 17.47           C  
ATOM   3202  C   GLU D  62       9.612  17.005   4.647  1.00 16.42           C  
ATOM   3203  O   GLU D  62       8.999  18.066   4.727  1.00 16.01           O  
ATOM   3204  CB  GLU D  62      11.154  16.862   6.577  1.00 15.87           C  
ATOM   3205  CG  GLU D  62      10.572  15.578   7.172  1.00 18.50           C  
ATOM   3206  CD  GLU D  62      10.675  15.529   8.705  1.00 22.77           C  
ATOM   3207  OE1 GLU D  62      10.461  16.567   9.326  1.00 22.65           O  
ATOM   3208  OE2 GLU D  62      11.010  14.474   9.274  1.00 27.53           O  
ATOM   3209  N   GLY D  63       9.056  15.884   4.250  1.00 19.02           N  
ATOM   3210  CA  GLY D  63       7.623  15.802   3.963  1.00 21.23           C  
ATOM   3211  C   GLY D  63       7.095  16.723   2.894  1.00 20.90           C  
ATOM   3212  O   GLY D  63       5.954  17.176   2.961  1.00 20.20           O  
ATOM   3213  N   GLY D  64       7.926  16.987   1.890  1.00 20.30           N  
ATOM   3214  CA  GLY D  64       7.574  17.875   0.816  1.00 22.47           C  
ATOM   3215  C   GLY D  64       7.699  19.360   1.111  1.00 24.18           C  
ATOM   3216  O   GLY D  64       7.397  20.166   0.259  1.00 26.03           O  
ATOM   3217  N   LYS D  65       8.155  19.730   2.305  1.00 23.27           N  
ATOM   3218  CA  LYS D  65       8.206  21.126   2.701  1.00 22.09           C  
ATOM   3219  C   LYS D  65       9.640  21.509   2.984  1.00 21.53           C  
ATOM   3220  O   LYS D  65      10.457  20.665   3.326  1.00 17.98           O  
ATOM   3221  CB  LYS D  65       7.354  21.345   3.960  1.00 25.49           C  
ATOM   3222  CG  LYS D  65       5.819  21.028   3.793  1.00 30.47           C  
ATOM   3223  CD  LYS D  65       5.074  22.024   2.900  1.00 37.58           C  
ATOM   3224  N   VAL D  66       9.932  22.782   2.835  1.00 22.15           N  
ATOM   3225  CA  VAL D  66      11.264  23.280   3.092  1.00 21.03           C  
ATOM   3226  C   VAL D  66      11.231  24.463   4.055  1.00 21.66           C  
ATOM   3227  O   VAL D  66      10.372  25.338   3.967  1.00 20.75           O  
ATOM   3228  CB  VAL D  66      12.040  23.624   1.760  1.00 18.24           C  
ATOM   3229  CG1 VAL D  66      11.227  24.556   0.866  1.00 25.93           C  
ATOM   3230  CG2 VAL D  66      13.417  24.208   2.054  1.00 11.95           C  
ATOM   3231  N   GLU D  67      12.149  24.435   5.014  1.00 18.11           N  
ATOM   3232  CA  GLU D  67      12.481  25.579   5.833  1.00 20.70           C  
ATOM   3233  C   GLU D  67      13.845  26.084   5.412  1.00 20.48           C  
ATOM   3234  O   GLU D  67      14.736  25.276   5.029  1.00 17.97           O  
ATOM   3235  CB  GLU D  67      12.499  25.243   7.306  1.00 22.07           C  
ATOM   3236  CG  GLU D  67      11.139  25.184   7.896  1.00 30.71           C  
ATOM   3237  CD  GLU D  67      10.728  23.806   8.197  1.00 38.45           C  
ATOM   3238  OE1 GLU D  67      11.604  23.062   8.675  1.00 27.27           O  
ATOM   3239  OE2 GLU D  67       9.553  23.481   7.974  1.00 43.37           O  
ATOM   3240  N   ARG D  68      13.981  27.407   5.428  1.00 20.24           N  
ATOM   3241  CA  ARG D  68      15.151  28.101   4.863  1.00 20.51           C  
ATOM   3242  C   ARG D  68      16.083  28.772   5.832  1.00 20.49           C  
ATOM   3243  O   ARG D  68      17.051  29.375   5.401  1.00 21.14           O  
ATOM   3244  CB  ARG D  68      14.672  29.165   3.889  1.00 24.85           C  
ATOM   3245  CG  ARG D  68      13.824  28.583   2.828  1.00 29.46           C  
ATOM   3246  CD  ARG D  68      13.648  29.566   1.714  1.00 32.98           C  
ATOM   3247  NE  ARG D  68      12.553  29.091   0.900  1.00 36.12           N  
ATOM   3248  CZ  ARG D  68      12.631  28.106   0.017  1.00 31.63           C  
ATOM   3249  NH1 ARG D  68      13.772  27.458  -0.190  1.00 37.19           N  
ATOM   3250  NH2 ARG D  68      11.535  27.758  -0.636  1.00 29.37           N  
ATOM   3251  N   SER D  69      15.839  28.641   7.130  1.00 17.79           N  
ATOM   3252  CA  SER D  69      16.723  29.263   8.129  1.00 19.56           C  
ATOM   3253  C   SER D  69      16.590  28.607   9.490  1.00 16.92           C  
ATOM   3254  O   SER D  69      15.602  27.970   9.773  1.00 14.59           O  
ATOM   3255  CB  SER D  69      16.379  30.745   8.271  1.00 21.02           C  
ATOM   3256  OG  SER D  69      15.197  30.942   9.059  1.00 21.26           O  
ATOM   3257  N   LEU D  70      17.574  28.771  10.342  1.00 18.68           N  
ATOM   3258  CA  LEU D  70      17.506  28.221  11.689  1.00 19.34           C  
ATOM   3259  C   LEU D  70      16.313  28.795  12.499  1.00 23.42           C  
ATOM   3260  O   LEU D  70      15.646  28.033  13.203  1.00 22.08           O  
ATOM   3261  CB  LEU D  70      18.819  28.491  12.440  1.00 20.01           C  
ATOM   3262  CG  LEU D  70      18.876  28.104  13.921  1.00 20.10           C  
ATOM   3263  CD1 LEU D  70      18.361  26.673  14.104  1.00 25.53           C  
ATOM   3264  CD2 LEU D  70      20.289  28.267  14.528  1.00 18.90           C  
ATOM   3265  N   THR D  71      16.058  30.101  12.398  0.50 24.40           N  
ATOM   3267  CA  THR D  71      14.941  30.718  13.136  0.50 25.94           C  
ATOM   3269  C   THR D  71      13.603  30.138  12.641  0.50 24.87           C  
ATOM   3271  O   THR D  71      12.734  29.788  13.443  0.50 21.72           O  
ATOM   3273  CB  THR D  71      14.956  32.265  13.074  0.50 24.99           C  
ATOM   3275  OG1 THR D  71      14.821  32.720  11.717  0.50 28.99           O  
ATOM   3277  CG2 THR D  71      16.256  32.816  13.684  0.50 27.56           C  
ATOM   3279  N   GLU D  72      13.466  29.951  11.330  1.00 25.13           N  
ATOM   3280  CA  GLU D  72      12.270  29.340  10.811  1.00 20.92           C  
ATOM   3281  C   GLU D  72      12.061  27.923  11.380  1.00 23.08           C  
ATOM   3282  O   GLU D  72      11.023  27.623  11.986  1.00 18.95           O  
ATOM   3283  CB  GLU D  72      12.323  29.324   9.293  1.00 23.20           C  
ATOM   3284  CG  GLU D  72      11.089  28.749   8.714  1.00 21.57           C  
ATOM   3285  CD  GLU D  72      11.047  28.808   7.211  1.00 30.93           C  
ATOM   3286  OE1 GLU D  72      12.016  29.247   6.569  1.00 22.71           O  
ATOM   3287  OE2 GLU D  72      10.014  28.400   6.680  1.00 29.46           O  
ATOM   3288  N   TYR D  73      13.062  27.058  11.221  1.00 21.13           N  
ATOM   3289  CA  TYR D  73      13.005  25.698  11.794  1.00 19.00           C  
ATOM   3290  C   TYR D  73      12.733  25.694  13.309  1.00 21.14           C  
ATOM   3291  O   TYR D  73      11.845  24.949  13.790  1.00 20.49           O  
ATOM   3292  CB  TYR D  73      14.297  24.943  11.478  1.00 19.22           C  
ATOM   3293  CG  TYR D  73      14.361  23.565  12.118  1.00 19.53           C  
ATOM   3294  CD1 TYR D  73      13.484  22.562  11.748  1.00 21.37           C  
ATOM   3295  CD2 TYR D  73      15.311  23.274  13.074  1.00 14.34           C  
ATOM   3296  CE1 TYR D  73      13.528  21.299  12.366  1.00 17.85           C  
ATOM   3297  CE2 TYR D  73      15.372  22.016  13.681  1.00 22.38           C  
ATOM   3298  CZ  TYR D  73      14.477  21.029  13.292  1.00 15.45           C  
ATOM   3299  OH  TYR D  73      14.544  19.785  13.900  1.00 20.80           O  
ATOM   3300  N   ALA D  74      13.469  26.537  14.052  1.00 20.82           N  
ATOM   3301  CA  ALA D  74      13.381  26.557  15.508  1.00 23.56           C  
ATOM   3302  C   ALA D  74      12.051  27.042  16.053  1.00 22.51           C  
ATOM   3303  O   ALA D  74      11.699  26.649  17.129  1.00 24.85           O  
ATOM   3304  CB  ALA D  74      14.507  27.401  16.135  1.00 25.64           C  
ATOM   3305  N   ASN D  75      11.341  27.876  15.270  0.50 22.11           N  
ATOM   3307  CA  ASN D  75      10.029  28.511  15.605  0.50 23.28           C  
ATOM   3309  C   ASN D  75       8.939  27.474  15.899  0.50 24.12           C  
ATOM   3311  O   ASN D  75       8.107  27.645  16.783  0.50 23.79           O  
ATOM   3313  CB  ASN D  75       9.600  29.441  14.425  0.50 23.50           C  
ATOM   3315  CG  ASN D  75       8.308  30.307  14.696  0.50 21.46           C  
ATOM   3317  OD1 ASN D  75       8.180  31.009  15.709  0.50 16.14           O  
ATOM   3319  ND2 ASN D  75       7.385  30.286  13.730  0.50 11.19           N  
ATOM   3321  N   HIS D  76       8.999  26.362  15.182  1.00 24.51           N  
ATOM   3322  CA  HIS D  76       7.920  25.371  15.201  1.00 23.45           C  
ATOM   3323  C   HIS D  76       8.402  23.926  14.942  1.00 21.07           C  
ATOM   3324  O   HIS D  76       8.253  23.063  15.782  1.00 19.62           O  
ATOM   3325  CB  HIS D  76       6.861  25.765  14.167  1.00 23.18           C  
ATOM   3326  CG  HIS D  76       5.566  24.995  14.279  1.00 23.96           C  
ATOM   3327  ND1 HIS D  76       4.381  25.446  13.724  1.00 29.37           N  
ATOM   3328  CD2 HIS D  76       5.265  23.818  14.888  1.00 32.11           C  
ATOM   3329  CE1 HIS D  76       3.423  24.566  13.956  1.00 35.36           C  
ATOM   3330  NE2 HIS D  76       3.934  23.563  14.655  1.00 22.13           N  
ATOM   3331  N   HIS D  77       8.943  23.676  13.766  1.00 22.15           N  
ATOM   3332  CA  HIS D  77       9.276  22.336  13.315  1.00 21.21           C  
ATOM   3333  C   HIS D  77      10.215  21.650  14.302  1.00 19.77           C  
ATOM   3334  O   HIS D  77       9.997  20.508  14.660  1.00 20.22           O  
ATOM   3335  CB  HIS D  77       9.827  22.387  11.877  1.00 22.08           C  
ATOM   3336  CG  HIS D  77      10.168  21.050  11.260  1.00 18.34           C  
ATOM   3337  ND1 HIS D  77      10.714  20.952   9.994  1.00 24.73           N  
ATOM   3338  CD2 HIS D  77      10.071  19.777  11.715  1.00 22.26           C  
ATOM   3339  CE1 HIS D  77      10.929  19.681   9.700  1.00 19.10           C  
ATOM   3340  NE2 HIS D  77      10.559  18.944  10.729  1.00 21.60           N  
HETATM 3341  N   MSE D  78      11.203  22.348  14.811  1.00 19.03           N  
HETATM 3342  CA  MSE D  78      12.117  21.756  15.800  1.00 19.01           C  
HETATM 3343  C   MSE D  78      11.401  21.235  17.065  1.00 18.51           C  
HETATM 3344  O   MSE D  78      11.631  20.103  17.545  1.00 16.54           O  
HETATM 3345  CB  MSE D  78      13.124  22.812  16.230  1.00 18.11           C  
HETATM 3346  CG  MSE D  78      14.188  22.293  17.170  1.00 23.52           C  
HETATM 3347 SE   MSE D  78      15.270  23.708  17.923  0.75 19.52          SE  
HETATM 3348  CE  MSE D  78      13.989  24.375  19.184  1.00 18.58           C  
ATOM   3349  N   LEU D  79      10.503  22.057  17.584  1.00 18.71           N  
ATOM   3350  CA  LEU D  79       9.731  21.701  18.768  1.00 19.13           C  
ATOM   3351  C   LEU D  79       8.835  20.496  18.498  1.00 19.27           C  
ATOM   3352  O   LEU D  79       8.716  19.577  19.334  1.00 20.39           O  
ATOM   3353  CB  LEU D  79       8.925  22.922  19.221  1.00 18.17           C  
ATOM   3354  CG  LEU D  79       9.737  24.139  19.690  1.00 23.78           C  
ATOM   3355  CD1 LEU D  79       8.758  25.205  20.148  1.00 23.74           C  
ATOM   3356  CD2 LEU D  79      10.696  23.796  20.840  1.00 19.90           C  
ATOM   3357  N   ALA D  80       8.250  20.462  17.306  1.00 19.46           N  
ATOM   3358  CA  ALA D  80       7.483  19.320  16.868  1.00 18.85           C  
ATOM   3359  C   ALA D  80       8.333  18.050  16.820  1.00 18.75           C  
ATOM   3360  O   ALA D  80       7.947  17.017  17.348  1.00 18.62           O  
ATOM   3361  CB  ALA D  80       6.827  19.591  15.472  1.00 17.77           C  
ATOM   3362  N   ASP D  81       9.502  18.124  16.191  1.00 18.85           N  
ATOM   3363  CA  ASP D  81      10.422  16.979  16.096  1.00 15.75           C  
ATOM   3364  C   ASP D  81      10.775  16.452  17.486  1.00 16.47           C  
ATOM   3365  O   ASP D  81      10.822  15.254  17.690  1.00 18.15           O  
ATOM   3366  CB  ASP D  81      11.691  17.345  15.333  1.00 16.84           C  
ATOM   3367  CG  ASP D  81      11.437  17.632  13.851  1.00 21.65           C  
ATOM   3368  OD1 ASP D  81      10.332  17.237  13.353  1.00 20.16           O  
ATOM   3369  OD2 ASP D  81      12.320  18.291  13.220  1.00 20.28           O  
HETATM 3370  N   MSE D  82      11.051  17.349  18.431  1.00 19.22           N  
HETATM 3371  CA  MSE D  82      11.446  16.904  19.790  1.00 20.34           C  
HETATM 3372  C   MSE D  82      10.308  16.176  20.465  1.00 21.31           C  
HETATM 3373  O   MSE D  82      10.521  15.168  21.090  1.00 18.62           O  
HETATM 3374  CB  MSE D  82      11.931  18.072  20.636  1.00 20.79           C  
HETATM 3375  CG  MSE D  82      13.255  18.662  20.192  1.00 23.67           C  
HETATM 3376 SE   MSE D  82      13.544  20.425  21.087  0.75 20.69          SE  
HETATM 3377  CE  MSE D  82      15.306  20.751  20.406  1.00 20.08           C  
ATOM   3378  N   ALA D  83       9.086  16.681  20.299  1.00 20.70           N  
ATOM   3379  CA  ALA D  83       7.892  16.055  20.857  1.00 19.74           C  
ATOM   3380  C   ALA D  83       7.670  14.661  20.252  1.00 20.17           C  
ATOM   3381  O   ALA D  83       7.364  13.726  20.985  1.00 22.05           O  
ATOM   3382  CB  ALA D  83       6.670  16.978  20.646  1.00 17.31           C  
ATOM   3383  N   TYR D  84       7.807  14.545  18.924  1.00 18.00           N  
ATOM   3384  CA  TYR D  84       7.758  13.270  18.186  1.00 17.99           C  
ATOM   3385  C   TYR D  84       8.810  12.250  18.670  1.00 17.96           C  
ATOM   3386  O   TYR D  84       8.513  11.084  18.806  1.00 18.33           O  
ATOM   3387  CB  TYR D  84       7.962  13.499  16.693  1.00 18.62           C  
ATOM   3388  CG  TYR D  84       8.026  12.232  15.857  1.00 19.50           C  
ATOM   3389  CD1 TYR D  84       6.871  11.509  15.578  1.00 25.34           C  
ATOM   3390  CD2 TYR D  84       9.235  11.791  15.305  1.00 26.05           C  
ATOM   3391  CE1 TYR D  84       6.927  10.372  14.810  1.00 24.42           C  
ATOM   3392  CE2 TYR D  84       9.299  10.645  14.541  1.00 24.83           C  
ATOM   3393  CZ  TYR D  84       8.129   9.944  14.312  1.00 22.06           C  
ATOM   3394  OH  TYR D  84       8.171   8.801  13.564  1.00 36.05           O  
ATOM   3395  N   LEU D  85      10.031  12.691  18.929  1.00 18.17           N  
ATOM   3396  CA  LEU D  85      11.089  11.774  19.380  1.00 21.69           C  
ATOM   3397  C   LEU D  85      11.017  11.328  20.845  1.00 25.76           C  
ATOM   3398  O   LEU D  85      11.666  10.340  21.264  1.00 22.60           O  
ATOM   3399  CB  LEU D  85      12.444  12.449  19.165  1.00 21.06           C  
ATOM   3400  CG  LEU D  85      12.839  12.634  17.714  1.00 21.33           C  
ATOM   3401  CD1 LEU D  85      14.009  13.617  17.576  1.00 19.62           C  
ATOM   3402  CD2 LEU D  85      13.185  11.279  17.101  1.00 21.38           C  
ATOM   3403  N   LYS D  86      10.247  12.064  21.630  1.00 25.83           N  
ATOM   3404  CA  LYS D  86      10.229  11.857  23.068  1.00 28.99           C  
ATOM   3405  C   LYS D  86       9.890  10.408  23.365  1.00 29.11           C  
ATOM   3406  O   LYS D  86      10.563   9.768  24.160  1.00 28.63           O  
ATOM   3407  CB  LYS D  86       9.226  12.805  23.717  1.00 28.77           C  
ATOM   3408  CG  LYS D  86       9.220  12.787  25.239  1.00 40.30           C  
ATOM   3409  CD  LYS D  86      10.319  13.644  25.834  1.00 48.52           C  
ATOM   3410  CE  LYS D  86      10.265  13.649  27.367  1.00 48.27           C  
ATOM   3411  NZ  LYS D  86       8.944  14.116  27.908  1.00 49.41           N  
ATOM   3412  N   GLY D  87       8.873   9.876  22.699  1.00 27.87           N  
ATOM   3413  CA  GLY D  87       8.479   8.494  22.955  1.00 29.34           C  
ATOM   3414  C   GLY D  87       9.129   7.408  22.111  1.00 29.85           C  
ATOM   3415  O   GLY D  87       8.670   6.270  22.146  1.00 31.70           O  
ATOM   3416  N   LEU D  88      10.190   7.720  21.364  1.00 25.61           N  
ATOM   3417  CA  LEU D  88      10.762   6.731  20.452  1.00 24.53           C  
ATOM   3418  C   LEU D  88      12.141   6.201  20.826  1.00 25.11           C  
ATOM   3419  O   LEU D  88      12.907   6.853  21.528  1.00 25.72           O  
ATOM   3420  CB  LEU D  88      10.864   7.343  19.046  1.00 25.39           C  
ATOM   3421  CG  LEU D  88       9.606   7.946  18.445  1.00 26.74           C  
ATOM   3422  CD1 LEU D  88       9.851   8.395  16.979  1.00 17.98           C  
ATOM   3423  CD2 LEU D  88       8.436   6.968  18.495  1.00 27.27           C  
ATOM   3424  N   THR D  89      12.463   5.016  20.316  1.00 24.41           N  
ATOM   3425  CA  THR D  89      13.850   4.568  20.286  1.00 25.30           C  
ATOM   3426  C   THR D  89      14.337   4.621  18.828  1.00 25.71           C  
ATOM   3427  O   THR D  89      13.668   4.101  17.909  1.00 23.31           O  
ATOM   3428  CB  THR D  89      14.055   3.171  20.875  1.00 29.07           C  
ATOM   3429  OG1 THR D  89      13.414   2.203  20.046  1.00 35.64           O  
ATOM   3430  CG2 THR D  89      13.481   3.091  22.312  1.00 30.46           C  
ATOM   3431  N   ILE D  90      15.472   5.303  18.646  1.00 23.57           N  
ATOM   3432  CA  ILE D  90      16.123   5.489  17.349  1.00 25.58           C  
ATOM   3433  C   ILE D  90      17.395   4.649  17.326  1.00 26.76           C  
ATOM   3434  O   ILE D  90      18.397   5.079  17.894  1.00 28.78           O  
ATOM   3435  CB  ILE D  90      16.517   6.965  17.105  1.00 26.57           C  
ATOM   3436  CG1 ILE D  90      15.339   7.902  17.400  1.00 27.33           C  
ATOM   3437  CG2 ILE D  90      17.101   7.169  15.662  1.00 19.73           C  
ATOM   3438  CD1 ILE D  90      14.151   7.705  16.565  1.00 23.54           C  
ATOM   3439  N   THR D  91      17.354   3.468  16.698  1.00 23.07           N  
ATOM   3440  CA  THR D  91      18.496   2.560  16.669  1.00 23.45           C  
ATOM   3441  C   THR D  91      19.264   2.707  15.365  1.00 22.73           C  
ATOM   3442  O   THR D  91      18.752   2.403  14.316  1.00 19.49           O  
ATOM   3443  CB  THR D  91      18.063   1.104  16.797  1.00 22.85           C  
ATOM   3444  OG1 THR D  91      17.255   0.960  17.990  1.00 21.07           O  
ATOM   3445  CG2 THR D  91      19.296   0.189  16.809  1.00 20.29           C  
ATOM   3446  N   PRO D  92      20.487   3.221  15.427  1.00 24.08           N  
ATOM   3447  CA  PRO D  92      21.315   3.412  14.225  1.00 21.42           C  
ATOM   3448  C   PRO D  92      21.613   2.117  13.489  1.00 20.79           C  
ATOM   3449  O   PRO D  92      21.931   1.071  14.105  1.00 20.57           O  
ATOM   3450  CB  PRO D  92      22.610   4.002  14.782  1.00 22.85           C  
ATOM   3451  CG  PRO D  92      22.205   4.651  16.069  1.00 25.75           C  
ATOM   3452  CD  PRO D  92      21.152   3.725  16.631  1.00 23.77           C  
ATOM   3453  N   LYS D  93      21.514   2.161  12.169  1.00 21.11           N  
ATOM   3454  CA  LYS D  93      21.685   0.960  11.392  1.00 19.49           C  
ATOM   3455  C   LYS D  93      22.897   1.119  10.490  1.00 21.84           C  
ATOM   3456  O   LYS D  93      23.751   0.239  10.435  1.00 20.29           O  
ATOM   3457  CB  LYS D  93      20.412   0.648  10.630  1.00 20.49           C  
ATOM   3458  CG  LYS D  93      19.223   0.151  11.521  1.00 25.90           C  
ATOM   3459  CD  LYS D  93      19.523  -1.206  12.201  1.00 29.95           C  
ATOM   3460  CE  LYS D  93      18.461  -1.651  13.165  1.00 30.99           C  
ATOM   3461  NZ  LYS D  93      18.953  -2.838  13.951  1.00 29.68           N  
ATOM   3462  N   GLU D  94      22.994   2.253   9.803  1.00 20.16           N  
ATOM   3463  CA  GLU D  94      24.218   2.571   9.082  1.00 22.92           C  
ATOM   3464  C   GLU D  94      24.447   4.024   9.024  1.00 22.16           C  
ATOM   3465  O   GLU D  94      23.489   4.807   9.169  1.00 15.44           O  
ATOM   3466  CB  GLU D  94      24.212   2.034   7.680  1.00 27.61           C  
ATOM   3467  CG  GLU D  94      22.959   2.101   6.940  1.00 32.76           C  
ATOM   3468  CD  GLU D  94      23.107   1.200   5.717  1.00 42.99           C  
ATOM   3469  OE1 GLU D  94      23.880   1.631   4.816  1.00 36.06           O  
ATOM   3470  OE2 GLU D  94      22.522   0.068   5.704  1.00 40.61           O  
ATOM   3471  N   HIS D  95      25.724   4.356   8.857  1.00 20.66           N  
ATOM   3472  CA  HIS D  95      26.171   5.725   8.854  1.00 19.38           C  
ATOM   3473  C   HIS D  95      27.499   5.785   8.100  1.00 22.71           C  
ATOM   3474  O   HIS D  95      28.395   4.984   8.347  1.00 22.11           O  
ATOM   3475  CB  HIS D  95      26.291   6.241  10.267  1.00 22.25           C  
ATOM   3476  CG  HIS D  95      26.625   7.688  10.354  1.00 26.29           C  
ATOM   3477  ND1 HIS D  95      27.178   8.254  11.478  1.00 35.45           N  
ATOM   3478  CD2 HIS D  95      26.485   8.690   9.461  1.00 18.34           C  
ATOM   3479  CE1 HIS D  95      27.348   9.546  11.275  1.00 25.40           C  
ATOM   3480  NE2 HIS D  95      26.981   9.828  10.045  1.00 22.56           N  
ATOM   3481  N   GLN D  96      27.552   6.675   7.122  1.00 16.57           N  
ATOM   3482  CA  GLN D  96      28.745   6.975   6.320  1.00 22.46           C  
ATOM   3483  C   GLN D  96      28.955   8.457   6.318  1.00 20.69           C  
ATOM   3484  O   GLN D  96      28.011   9.258   6.336  1.00 19.05           O  
ATOM   3485  CB  GLN D  96      28.618   6.582   4.864  1.00 23.60           C  
ATOM   3486  CG  GLN D  96      28.579   5.122   4.558  1.00 38.07           C  
ATOM   3487  CD  GLN D  96      29.178   4.811   3.175  1.00 47.89           C  
ATOM   3488  OE1 GLN D  96      29.080   5.619   2.223  1.00 54.91           O  
ATOM   3489  NE2 GLN D  96      29.823   3.639   3.068  1.00 47.75           N  
ATOM   3490  N   ILE D  97      30.210   8.877   6.320  0.50 19.15           N  
ATOM   3492  CA  ILE D  97      30.468  10.309   6.221  0.50 16.00           C  
ATOM   3494  C   ILE D  97      31.632  10.480   5.276  0.50 17.92           C  
ATOM   3496  O   ILE D  97      32.520   9.615   5.200  0.50 17.04           O  
ATOM   3498  CB  ILE D  97      30.763  10.922   7.575  0.50 16.95           C  
ATOM   3500  CG1 ILE D  97      30.851  12.448   7.500  0.50 15.38           C  
ATOM   3502  CG2 ILE D  97      32.052  10.364   8.115  0.50 17.92           C  
ATOM   3504  CD1 ILE D  97      30.734  13.100   8.873  0.50 16.70           C  
ATOM   3506  N   THR D  98      31.579  11.570   4.529  1.00 18.06           N  
ATOM   3507  CA  THR D  98      32.592  11.936   3.545  1.00 18.82           C  
ATOM   3508  C   THR D  98      33.059  13.281   4.020  1.00 18.30           C  
ATOM   3509  O   THR D  98      32.210  14.145   4.281  1.00 13.82           O  
ATOM   3510  CB  THR D  98      32.013  12.021   2.140  1.00 22.27           C  
ATOM   3511  OG1 THR D  98      31.729  10.682   1.685  1.00 24.32           O  
ATOM   3512  CG2 THR D  98      33.000  12.765   1.100  1.00 21.27           C  
ATOM   3513  N   ILE D  99      34.370  13.466   4.170  1.00 17.38           N  
ATOM   3514  CA  ILE D  99      34.909  14.758   4.640  1.00 19.80           C  
ATOM   3515  C   ILE D  99      35.985  15.122   3.634  1.00 22.45           C  
ATOM   3516  O   ILE D  99      36.880  14.324   3.319  1.00 20.46           O  
ATOM   3517  CB  ILE D  99      35.455  14.733   6.073  1.00 22.33           C  
ATOM   3518  CG1 ILE D  99      34.363  14.379   7.095  1.00 18.67           C  
ATOM   3519  CG2 ILE D  99      36.034  16.060   6.412  1.00 16.04           C  
ATOM   3520  CD1 ILE D  99      34.890  13.895   8.400  1.00 21.09           C  
ATOM   3521  N   THR D 100      35.845  16.287   3.044  1.00 21.47           N  
ATOM   3522  CA  THR D 100      36.831  16.715   2.085  1.00 24.44           C  
ATOM   3523  C   THR D 100      36.927  18.220   2.130  1.00 22.97           C  
ATOM   3524  O   THR D 100      35.955  18.927   1.939  1.00 20.71           O  
ATOM   3525  CB  THR D 100      36.555  16.168   0.663  1.00 24.12           C  
ATOM   3526  OG1 THR D 100      37.637  16.571  -0.200  1.00 24.35           O  
ATOM   3527  CG2 THR D 100      35.229  16.646   0.121  1.00 27.60           C  
ATOM   3528  N   GLY D 101      38.123  18.718   2.428  1.00 23.16           N  
ATOM   3529  CA  GLY D 101      38.297  20.156   2.584  1.00 22.18           C  
ATOM   3530  C   GLY D 101      37.310  20.676   3.620  1.00 20.68           C  
ATOM   3531  O   GLY D 101      37.204  20.142   4.720  1.00 22.43           O  
ATOM   3532  N   ASP D 102      36.552  21.684   3.231  1.00 18.25           N  
ATOM   3533  CA  ASP D 102      35.620  22.369   4.146  1.00 20.36           C  
ATOM   3534  C   ASP D 102      34.185  21.850   4.120  1.00 17.25           C  
ATOM   3535  O   ASP D 102      33.305  22.456   4.734  1.00 19.39           O  
ATOM   3536  CB  ASP D 102      35.569  23.848   3.801  1.00 21.11           C  
ATOM   3537  CG  ASP D 102      36.861  24.565   4.104  1.00 29.10           C  
ATOM   3538  OD1 ASP D 102      37.574  24.208   5.088  1.00 31.99           O  
ATOM   3539  OD2 ASP D 102      37.160  25.480   3.326  1.00 38.14           O  
ATOM   3540  N   ILE D 103      33.972  20.737   3.443  1.00 17.04           N  
ATOM   3541  CA  ILE D 103      32.644  20.160   3.303  1.00 19.62           C  
ATOM   3542  C   ILE D 103      32.596  18.724   3.782  1.00 16.99           C  
ATOM   3543  O   ILE D 103      33.539  17.938   3.558  1.00 14.74           O  
ATOM   3544  CB  ILE D 103      32.102  20.323   1.841  1.00 19.59           C  
ATOM   3545  CG1 ILE D 103      30.635  19.849   1.738  1.00 23.08           C  
ATOM   3546  CG2 ILE D 103      32.961  19.572   0.824  1.00 21.04           C  
ATOM   3547  CD1 ILE D 103      29.909  20.371   0.463  1.00 23.98           C  
ATOM   3548  N   ALA D 104      31.493  18.394   4.458  1.00 15.65           N  
ATOM   3549  CA  ALA D 104      31.217  17.020   4.900  1.00 17.52           C  
ATOM   3550  C   ALA D 104      29.794  16.594   4.545  1.00 16.69           C  
ATOM   3551  O   ALA D 104      28.884  17.406   4.586  1.00 17.25           O  
ATOM   3552  CB  ALA D 104      31.446  16.873   6.372  1.00 16.77           C  
ATOM   3553  N   ILE D 105      29.623  15.335   4.160  1.00 17.26           N  
ATOM   3554  CA  ILE D 105      28.299  14.801   3.897  1.00 17.25           C  
ATOM   3555  C   ILE D 105      28.133  13.578   4.773  1.00 18.37           C  
ATOM   3556  O   ILE D 105      28.938  12.645   4.725  1.00 20.37           O  
ATOM   3557  CB  ILE D 105      28.034  14.430   2.443  1.00 15.61           C  
ATOM   3558  CG1 ILE D 105      28.330  15.600   1.506  1.00 16.74           C  
ATOM   3559  CG2 ILE D 105      26.596  13.927   2.282  1.00 17.73           C  
ATOM   3560  CD1 ILE D 105      29.620  15.513   0.891  1.00 21.48           C  
ATOM   3561  N   SER D 106      27.081  13.597   5.588  1.00 16.22           N  
ATOM   3562  CA  SER D 106      26.705  12.481   6.459  1.00 15.37           C  
ATOM   3563  C   SER D 106      25.408  11.831   5.963  1.00 18.13           C  
ATOM   3564  O   SER D 106      24.409  12.535   5.808  1.00 17.31           O  
ATOM   3565  CB  SER D 106      26.500  13.019   7.887  1.00 15.06           C  
ATOM   3566  OG  SER D 106      26.007  12.026   8.774  1.00 16.05           O  
ATOM   3567  N   THR D 107      25.421  10.514   5.752  1.00 16.77           N  
ATOM   3568  CA  THR D 107      24.249   9.727   5.309  1.00 14.52           C  
ATOM   3569  C   THR D 107      24.020   8.624   6.328  1.00 16.88           C  
ATOM   3570  O   THR D 107      24.940   7.867   6.657  1.00 16.17           O  
ATOM   3571  CB  THR D 107      24.383   9.165   3.864  1.00 12.96           C  
ATOM   3572  OG1 THR D 107      25.506   8.268   3.724  1.00 13.18           O  
ATOM   3573  CG2 THR D 107      24.576  10.324   2.879  1.00 15.38           C  
ATOM   3574  N   SER D 108      22.811   8.578   6.859  1.00 18.56           N  
ATOM   3575  CA  SER D 108      22.511   7.597   7.879  1.00 16.30           C  
ATOM   3576  C   SER D 108      21.099   7.025   7.759  1.00 17.61           C  
ATOM   3577  O   SER D 108      20.217   7.606   7.168  1.00 18.09           O  
ATOM   3578  CB  SER D 108      22.778   8.184   9.257  1.00 18.50           C  
ATOM   3579  OG  SER D 108      21.942   9.244   9.556  1.00 23.71           O  
ATOM   3580  N   ILE D 109      20.971   5.801   8.226  1.00 18.00           N  
ATOM   3581  CA  ILE D 109      19.713   5.102   8.257  1.00 17.69           C  
ATOM   3582  C   ILE D 109      19.553   4.584   9.706  1.00 17.45           C  
ATOM   3583  O   ILE D 109      20.477   4.011  10.249  1.00 19.13           O  
ATOM   3584  CB  ILE D 109      19.663   3.921   7.264  1.00 15.58           C  
ATOM   3585  CG1 ILE D 109      19.854   4.393   5.798  1.00 17.49           C  
ATOM   3586  CG2 ILE D 109      18.361   3.084   7.509  1.00 18.87           C  
ATOM   3587  CD1 ILE D 109      20.148   3.314   4.801  1.00 20.66           C  
ATOM   3588  N   SER D 110      18.394   4.857  10.310  1.00 20.66           N  
ATOM   3589  CA  SER D 110      18.066   4.420  11.643  1.00 21.03           C  
ATOM   3590  C   SER D 110      16.699   3.747  11.678  1.00 21.25           C  
ATOM   3591  O   SER D 110      15.892   3.863  10.774  1.00 23.02           O  
ATOM   3592  CB  SER D 110      18.134   5.567  12.637  1.00 20.98           C  
ATOM   3593  OG  SER D 110      19.453   6.056  12.709  1.00 23.63           O  
ATOM   3594  N   HIS D 111      16.481   2.993  12.738  1.00 19.32           N  
ATOM   3595  CA  HIS D 111      15.233   2.300  12.956  1.00 22.65           C  
ATOM   3596  C   HIS D 111      14.555   2.989  14.125  1.00 18.89           C  
ATOM   3597  O   HIS D 111      15.017   2.918  15.254  1.00 18.45           O  
ATOM   3598  CB  HIS D 111      15.504   0.817  13.236  1.00 24.11           C  
ATOM   3599  CG  HIS D 111      14.280  -0.035  13.340  1.00 27.33           C  
ATOM   3600  ND1 HIS D 111      14.311  -1.294  13.909  1.00 28.53           N  
ATOM   3601  CD2 HIS D 111      13.000   0.178  12.954  1.00 21.20           C  
ATOM   3602  CE1 HIS D 111      13.099  -1.818  13.867  1.00 27.91           C  
ATOM   3603  NE2 HIS D 111      12.284  -0.948  13.289  1.00 22.69           N  
ATOM   3604  N   ALA D 112      13.442   3.634  13.825  1.00 20.22           N  
ATOM   3605  CA  ALA D 112      12.624   4.313  14.819  1.00 22.26           C  
ATOM   3606  C   ALA D 112      11.486   3.405  15.279  1.00 21.36           C  
ATOM   3607  O   ALA D 112      10.713   2.889  14.457  1.00 24.62           O  
ATOM   3608  CB  ALA D 112      12.064   5.600  14.249  1.00 20.29           C  
ATOM   3609  N   GLN D 113      11.384   3.213  16.585  1.00 20.77           N  
ATOM   3610  CA  GLN D 113      10.365   2.361  17.178  1.00 22.73           C  
ATOM   3611  C   GLN D 113       9.748   3.033  18.375  1.00 22.95           C  
ATOM   3612  O   GLN D 113      10.437   3.641  19.156  1.00 24.89           O  
ATOM   3613  CB  GLN D 113      10.954   1.035  17.658  1.00 23.89           C  
ATOM   3614  CG  GLN D 113      11.450   0.140  16.562  1.00 23.83           C  
ATOM   3615  CD  GLN D 113      12.069  -1.097  17.107  1.00 26.47           C  
ATOM   3616  OE1 GLN D 113      13.184  -1.074  17.636  1.00 40.36           O  
ATOM   3617  NE2 GLN D 113      11.362  -2.196  16.990  1.00 27.05           N  
ATOM   3618  N   GLY D 114       8.441   2.901  18.517  1.00 24.78           N  
ATOM   3619  CA  GLY D 114       7.738   3.391  19.691  1.00 26.69           C  
ATOM   3620  C   GLY D 114       6.339   3.728  19.292  1.00 27.48           C  
ATOM   3621  O   GLY D 114       5.755   3.071  18.417  1.00 28.14           O  
ATOM   3622  N   GLU D 115       5.793   4.756  19.920  1.00 27.38           N  
ATOM   3623  CA  GLU D 115       4.532   5.267  19.476  1.00 31.76           C  
ATOM   3624  C   GLU D 115       4.454   6.784  19.639  1.00 27.57           C  
ATOM   3625  O   GLU D 115       5.255   7.409  20.338  1.00 27.33           O  
ATOM   3626  CB  GLU D 115       3.340   4.537  20.113  1.00 34.83           C  
ATOM   3627  CG  GLU D 115       3.473   4.067  21.541  1.00 41.11           C  
ATOM   3628  CD  GLU D 115       2.331   3.115  21.903  1.00 40.75           C  
ATOM   3629  OE1 GLU D 115       1.247   3.216  21.267  1.00 61.55           O  
ATOM   3630  OE2 GLU D 115       2.517   2.274  22.814  1.00 57.28           O  
ATOM   3631  N   TYR D 116       3.515   7.348  18.903  1.00 28.97           N  
ATOM   3632  CA  TYR D 116       3.293   8.765  18.900  1.00 27.05           C  
ATOM   3633  C   TYR D 116       1.794   8.989  18.895  1.00 27.69           C  
ATOM   3634  O   TYR D 116       1.093   8.434  18.033  1.00 24.74           O  
ATOM   3635  CB  TYR D 116       3.956   9.399  17.663  1.00 26.73           C  
ATOM   3636  CG  TYR D 116       3.791  10.876  17.636  1.00 25.50           C  
ATOM   3637  CD1 TYR D 116       4.241  11.674  18.683  1.00 27.04           C  
ATOM   3638  CD2 TYR D 116       3.161  11.489  16.578  1.00 26.37           C  
ATOM   3639  CE1 TYR D 116       4.067  13.052  18.643  1.00 26.53           C  
ATOM   3640  CE2 TYR D 116       2.968  12.837  16.533  1.00 24.35           C  
ATOM   3641  CZ  TYR D 116       3.421  13.627  17.557  1.00 29.11           C  
ATOM   3642  OH  TYR D 116       3.198  14.980  17.463  1.00 32.31           O  
ATOM   3643  N   LYS D 117       1.323   9.808  19.852  1.00 29.85           N  
ATOM   3644  CA  LYS D 117      -0.093  10.071  20.026  1.00 31.09           C  
ATOM   3645  C   LYS D 117      -0.905   8.775  20.196  1.00 33.48           C  
ATOM   3646  O   LYS D 117      -2.009   8.666  19.649  1.00 32.88           O  
ATOM   3647  CB  LYS D 117      -0.633  10.820  18.819  1.00 31.85           C  
ATOM   3648  CG  LYS D 117      -0.090  12.192  18.656  1.00 32.18           C  
ATOM   3649  CD  LYS D 117      -0.674  12.779  17.428  1.00 23.19           C  
ATOM   3650  CE  LYS D 117      -0.832  14.256  17.576  1.00 26.18           C  
ATOM   3651  NZ  LYS D 117      -2.076  14.594  18.329  1.00 23.60           N  
ATOM   3652  N   GLY D 118      -0.341   7.793  20.910  1.00 35.70           N  
ATOM   3653  CA  GLY D 118      -1.003   6.495  21.091  1.00 38.99           C  
ATOM   3654  C   GLY D 118      -0.934   5.451  19.966  1.00 40.38           C  
ATOM   3655  O   GLY D 118      -1.352   4.297  20.194  1.00 41.23           O  
ATOM   3656  N   LYS D 119      -0.439   5.831  18.773  1.00 39.47           N  
ATOM   3657  CA  LYS D 119      -0.297   4.906  17.611  1.00 38.06           C  
ATOM   3658  C   LYS D 119       1.160   4.415  17.361  1.00 39.56           C  
ATOM   3659  O   LYS D 119       2.119   5.121  17.651  1.00 37.79           O  
ATOM   3660  CB  LYS D 119      -0.824   5.557  16.336  1.00 37.12           C  
ATOM   3661  N   SER D 120       1.300   3.223  16.780  1.00 39.07           N  
ATOM   3662  CA  SER D 120       2.607   2.576  16.599  1.00 38.62           C  
ATOM   3663  C   SER D 120       3.525   3.196  15.535  1.00 35.82           C  
ATOM   3664  O   SER D 120       3.105   3.440  14.413  1.00 36.14           O  
ATOM   3665  CB  SER D 120       2.419   1.082  16.273  1.00 39.01           C  
ATOM   3666  OG  SER D 120       3.505   0.575  15.504  1.00 49.38           O  
ATOM   3667  N   ILE D 121       4.791   3.404  15.909  1.00 32.05           N  
ATOM   3668  CA  ILE D 121       5.852   3.863  14.987  1.00 30.93           C  
ATOM   3669  C   ILE D 121       6.831   2.722  14.775  1.00 28.83           C  
ATOM   3670  O   ILE D 121       7.352   2.149  15.734  1.00 26.72           O  
ATOM   3671  CB  ILE D 121       6.666   5.050  15.563  1.00 32.98           C  
ATOM   3672  CG1 ILE D 121       5.759   6.263  15.780  1.00 30.99           C  
ATOM   3673  CG2 ILE D 121       7.906   5.352  14.660  1.00 29.23           C  
ATOM   3674  CD1 ILE D 121       5.032   6.700  14.540  1.00 25.02           C  
ATOM   3675  N   ASP D 122       7.032   2.334  13.529  1.00 26.87           N  
ATOM   3676  CA  ASP D 122       8.043   1.348  13.211  1.00 29.54           C  
ATOM   3677  C   ASP D 122       8.458   1.640  11.808  1.00 30.37           C  
ATOM   3678  O   ASP D 122       7.856   1.136  10.863  1.00 33.38           O  
ATOM   3679  CB  ASP D 122       7.517  -0.075  13.340  1.00 31.14           C  
ATOM   3680  CG  ASP D 122       8.630  -1.090  13.277  1.00 39.19           C  
ATOM   3681  OD1 ASP D 122       9.429  -1.023  12.317  1.00 43.97           O  
ATOM   3682  OD2 ASP D 122       8.715  -1.944  14.188  1.00 50.02           O  
ATOM   3683  N   SER D 123       9.488   2.475  11.675  1.00 28.91           N  
ATOM   3684  CA  SER D 123       9.962   2.940  10.382  1.00 27.91           C  
ATOM   3685  C   SER D 123      11.493   2.987  10.333  1.00 25.88           C  
ATOM   3686  O   SER D 123      12.141   3.154  11.372  1.00 20.60           O  
ATOM   3687  CB  SER D 123       9.375   4.323  10.081  1.00 31.65           C  
ATOM   3688  OG  SER D 123       9.505   5.184  11.201  1.00 39.50           O  
HETATM 3689  N   MSE D 124      12.022   2.761   9.127  1.00 24.09           N  
HETATM 3690  CA  MSE D 124      13.438   2.945   8.802  1.00 27.02           C  
HETATM 3691  C   MSE D 124      13.551   4.373   8.309  1.00 25.48           C  
HETATM 3692  O   MSE D 124      12.983   4.748   7.277  1.00 27.56           O  
HETATM 3693  CB  MSE D 124      13.912   1.968   7.707  1.00 27.19           C  
HETATM 3694  CG  MSE D 124      14.055   0.566   8.173  1.00 37.21           C  
HETATM 3695 SE   MSE D 124      15.571   0.542   9.366  0.75 29.32          SE  
HETATM 3696  CE  MSE D 124      15.241  -1.160  10.247  1.00 41.26           C  
ATOM   3697  N   THR D 125      14.289   5.176   9.055  1.00 23.47           N  
ATOM   3698  CA  THR D 125      14.377   6.585   8.782  1.00 20.29           C  
ATOM   3699  C   THR D 125      15.697   6.865   8.083  1.00 20.97           C  
ATOM   3700  O   THR D 125      16.668   6.127   8.256  1.00 21.43           O  
ATOM   3701  CB  THR D 125      14.245   7.404  10.040  1.00 21.65           C  
ATOM   3702  OG1 THR D 125      15.329   7.136  10.928  1.00 29.80           O  
ATOM   3703  CG2 THR D 125      12.922   7.061  10.777  1.00 28.95           C  
HETATM 3704  N   MSE D 126      15.700   7.901   7.247  1.00 19.36           N  
HETATM 3705  CA  MSE D 126      16.871   8.230   6.470  1.00 18.49           C  
HETATM 3706  C   MSE D 126      17.186   9.696   6.599  1.00 16.46           C  
HETATM 3707  O   MSE D 126      16.290  10.544   6.720  1.00 18.67           O  
HETATM 3708  CB  MSE D 126      16.716   7.860   4.992  1.00 20.76           C  
HETATM 3709  CG  MSE D 126      15.987   6.552   4.732  1.00 17.59           C  
HETATM 3710 SE   MSE D 126      16.043   6.102   2.822  0.75 16.38          SE  
HETATM 3711  CE  MSE D 126      17.598   4.991   2.860  1.00 20.60           C  
ATOM   3712  N   GLU D 127      18.480   9.965   6.624  1.00 16.33           N  
ATOM   3713  CA  GLU D 127      19.010  11.305   6.758  1.00 16.12           C  
ATOM   3714  C   GLU D 127      20.249  11.582   5.915  1.00 17.97           C  
ATOM   3715  O   GLU D 127      21.234  10.865   5.961  1.00 15.13           O  
ATOM   3716  CB  GLU D 127      19.373  11.582   8.211  1.00 17.47           C  
ATOM   3717  CG  GLU D 127      19.954  12.994   8.465  1.00 15.05           C  
ATOM   3718  CD  GLU D 127      20.403  13.092   9.911  1.00 19.39           C  
ATOM   3719  OE1 GLU D 127      21.493  12.594  10.220  1.00 20.05           O  
ATOM   3720  OE2 GLU D 127      19.636  13.619  10.751  1.00 17.93           O  
ATOM   3721  N   THR D 128      20.176  12.637   5.120  1.00 14.20           N  
ATOM   3722  CA  THR D 128      21.375  13.212   4.491  1.00 15.73           C  
ATOM   3723  C   THR D 128      21.626  14.600   5.099  1.00 16.50           C  
ATOM   3724  O   THR D 128      20.731  15.473   5.135  1.00 15.36           O  
ATOM   3725  CB  THR D 128      21.186  13.304   2.961  1.00 17.58           C  
ATOM   3726  OG1 THR D 128      20.925  12.006   2.469  1.00 17.29           O  
ATOM   3727  CG2 THR D 128      22.420  13.931   2.270  1.00 13.41           C  
ATOM   3728  N   LEU D 129      22.841  14.817   5.582  1.00 14.38           N  
ATOM   3729  CA  LEU D 129      23.256  16.110   6.134  1.00 16.02           C  
ATOM   3730  C   LEU D 129      24.501  16.596   5.396  1.00 18.11           C  
ATOM   3731  O   LEU D 129      25.380  15.796   5.086  1.00 16.81           O  
ATOM   3732  CB  LEU D 129      23.631  16.047   7.616  1.00 16.68           C  
ATOM   3733  CG  LEU D 129      22.676  15.491   8.658  1.00 16.59           C  
ATOM   3734  CD1 LEU D 129      23.408  15.471  10.077  1.00 16.45           C  
ATOM   3735  CD2 LEU D 129      21.324  16.232   8.652  1.00 14.97           C  
ATOM   3736  N   VAL D 130      24.525  17.891   5.092  1.00 14.37           N  
ATOM   3737  CA  VAL D 130      25.675  18.582   4.575  1.00 14.32           C  
ATOM   3738  C   VAL D 130      26.183  19.477   5.706  1.00 13.31           C  
ATOM   3739  O   VAL D 130      25.388  20.216   6.323  1.00 14.36           O  
ATOM   3740  CB  VAL D 130      25.391  19.436   3.315  1.00 15.78           C  
ATOM   3741  CG1 VAL D 130      26.675  20.172   2.846  1.00 16.87           C  
ATOM   3742  CG2 VAL D 130      24.782  18.537   2.184  1.00 14.93           C  
ATOM   3743  N   LEU D 131      27.471  19.414   5.957  1.00 15.11           N  
ATOM   3744  CA  LEU D 131      28.102  20.259   6.931  1.00 14.57           C  
ATOM   3745  C   LEU D 131      29.263  21.049   6.292  1.00 16.65           C  
ATOM   3746  O   LEU D 131      29.959  20.557   5.406  1.00 14.12           O  
ATOM   3747  CB  LEU D 131      28.653  19.446   8.113  1.00 12.99           C  
ATOM   3748  CG  LEU D 131      27.732  18.550   8.932  1.00 19.17           C  
ATOM   3749  CD1 LEU D 131      27.815  17.136   8.413  1.00 22.76           C  
ATOM   3750  CD2 LEU D 131      28.115  18.618  10.442  1.00 15.33           C  
ATOM   3751  N   ILE D 132      29.451  22.275   6.753  1.00 17.28           N  
ATOM   3752  CA  ILE D 132      30.499  23.159   6.290  1.00 18.06           C  
ATOM   3753  C   ILE D 132      31.298  23.643   7.487  1.00 19.03           C  
ATOM   3754  O   ILE D 132      30.749  24.023   8.506  1.00 15.41           O  
ATOM   3755  CB  ILE D 132      29.913  24.377   5.503  1.00 20.94           C  
ATOM   3756  CG1 ILE D 132      29.201  23.903   4.241  1.00 19.51           C  
ATOM   3757  CG2 ILE D 132      30.984  25.397   5.225  1.00 22.39           C  
ATOM   3758  CD1 ILE D 132      30.117  23.250   3.202  1.00 22.60           C  
ATOM   3759  N   LYS D 133      32.611  23.615   7.348  1.00 20.75           N  
ATOM   3760  CA  LYS D 133      33.511  24.059   8.389  1.00 22.34           C  
ATOM   3761  C   LYS D 133      33.578  25.584   8.377  1.00 21.57           C  
ATOM   3762  O   LYS D 133      33.808  26.204   7.336  1.00 19.42           O  
ATOM   3763  CB  LYS D 133      34.886  23.467   8.164  1.00 22.41           C  
ATOM   3764  CG  LYS D 133      35.881  23.673   9.363  1.00 27.06           C  
ATOM   3765  CD  LYS D 133      37.267  22.917   9.132  1.00 26.79           C  
ATOM   3766  CE  LYS D 133      37.844  23.013   7.686  1.00 32.52           C  
ATOM   3767  NZ  LYS D 133      39.017  22.056   7.277  1.00 33.85           N  
ATOM   3768  N   GLN D 134      33.308  26.160   9.545  1.00 18.95           N  
ATOM   3769  CA  GLN D 134      33.311  27.607   9.739  1.00 23.37           C  
ATOM   3770  C   GLN D 134      34.739  28.147   9.998  1.00 20.16           C  
ATOM   3771  O   GLN D 134      35.674  27.392  10.314  1.00 17.83           O  
ATOM   3772  CB  GLN D 134      32.355  27.950  10.872  1.00 22.68           C  
ATOM   3773  CG  GLN D 134      30.992  27.286  10.751  1.00 28.83           C  
ATOM   3774  CD  GLN D 134      30.233  27.757   9.549  1.00 33.13           C  
ATOM   3775  OE1 GLN D 134      29.826  28.909   9.506  1.00 30.11           O  
ATOM   3776  NE2 GLN D 134      30.010  26.867   8.565  1.00 26.52           N  
ATOM   3777  N   ALA D 135      34.920  29.457   9.798  1.00 25.27           N  
ATOM   3778  CA  ALA D 135      36.199  30.127  10.105  1.00 26.00           C  
ATOM   3779  C   ALA D 135      36.738  29.813  11.527  1.00 24.54           C  
ATOM   3780  O   ALA D 135      37.945  29.640  11.698  1.00 24.79           O  
ATOM   3781  CB  ALA D 135      36.065  31.621   9.929  1.00 27.05           C  
ATOM   3782  N   ASP D 136      35.850  29.714  12.529  1.00 24.68           N  
ATOM   3783  CA  ASP D 136      36.303  29.387  13.891  1.00 26.22           C  
ATOM   3784  C   ASP D 136      36.628  27.901  14.077  1.00 26.52           C  
ATOM   3785  O   ASP D 136      36.930  27.472  15.214  1.00 27.54           O  
ATOM   3786  CB  ASP D 136      35.314  29.856  14.961  1.00 26.09           C  
ATOM   3787  CG  ASP D 136      33.990  29.147  14.909  1.00 35.04           C  
ATOM   3788  OD1 ASP D 136      33.780  28.335  13.982  1.00 29.63           O  
ATOM   3789  OD2 ASP D 136      33.152  29.397  15.812  1.00 40.58           O  
ATOM   3790  N   GLY D 137      36.550  27.135  12.979  1.00 25.11           N  
ATOM   3791  CA  GLY D 137      36.818  25.678  12.980  1.00 24.93           C  
ATOM   3792  C   GLY D 137      35.648  24.787  13.374  1.00 22.06           C  
ATOM   3793  O   GLY D 137      35.735  23.565  13.285  1.00 23.05           O  
ATOM   3794  N   ARG D 138      34.528  25.397  13.774  1.00 22.45           N  
ATOM   3795  CA  ARG D 138      33.327  24.664  14.074  1.00 22.54           C  
ATOM   3796  C   ARG D 138      32.673  24.178  12.780  1.00 21.68           C  
ATOM   3797  O   ARG D 138      32.670  24.903  11.815  1.00 21.38           O  
ATOM   3798  CB  ARG D 138      32.298  25.560  14.744  1.00 24.56           C  
ATOM   3799  CG  ARG D 138      32.514  25.923  16.226  1.00 30.06           C  
ATOM   3800  CD  ARG D 138      31.206  26.496  16.765  1.00 32.20           C  
ATOM   3801  NE  ARG D 138      31.354  27.073  18.101  1.00 47.76           N  
ATOM   3802  CZ  ARG D 138      31.224  26.411  19.258  1.00 50.72           C  
ATOM   3803  NH1 ARG D 138      30.923  25.111  19.286  1.00 55.17           N  
ATOM   3804  NH2 ARG D 138      31.396  27.061  20.412  1.00 50.76           N  
ATOM   3805  N   TRP D 139      32.166  22.951  12.753  1.00 19.50           N  
ATOM   3806  CA  TRP D 139      31.344  22.457  11.651  1.00 15.63           C  
ATOM   3807  C   TRP D 139      29.869  22.773  11.963  1.00 16.71           C  
ATOM   3808  O   TRP D 139      29.399  22.582  13.104  1.00 18.29           O  
ATOM   3809  CB  TRP D 139      31.523  20.937  11.463  1.00 15.64           C  
ATOM   3810  CG  TRP D 139      32.851  20.522  10.927  1.00 14.31           C  
ATOM   3811  CD1 TRP D 139      33.974  20.303  11.652  1.00 18.44           C  
ATOM   3812  CD2 TRP D 139      33.188  20.256   9.557  1.00 16.67           C  
ATOM   3813  NE1 TRP D 139      34.990  19.907  10.833  1.00 21.58           N  
ATOM   3814  CE2 TRP D 139      34.541  19.888   9.532  1.00 23.22           C  
ATOM   3815  CE3 TRP D 139      32.471  20.316   8.344  1.00 16.49           C  
ATOM   3816  CZ2 TRP D 139      35.203  19.560   8.342  1.00 19.59           C  
ATOM   3817  CZ3 TRP D 139      33.135  20.023   7.151  1.00 20.39           C  
ATOM   3818  CH2 TRP D 139      34.479  19.629   7.150  1.00 17.04           C  
ATOM   3819  N   LYS D 140      29.148  23.296  10.972  1.00 16.26           N  
ATOM   3820  CA  LYS D 140      27.730  23.521  11.062  1.00 17.09           C  
ATOM   3821  C   LYS D 140      26.959  22.853   9.901  1.00 16.30           C  
ATOM   3822  O   LYS D 140      27.420  22.842   8.765  1.00 17.22           O  
ATOM   3823  CB  LYS D 140      27.381  25.017  11.072  1.00 21.20           C  
ATOM   3824  CG  LYS D 140      27.911  25.687  12.293  1.00 16.04           C  
ATOM   3825  CD  LYS D 140      27.084  26.805  12.807  1.00 23.98           C  
ATOM   3826  CE  LYS D 140      27.598  27.140  14.194  1.00 27.53           C  
ATOM   3827  NZ  LYS D 140      26.815  28.201  14.832  1.00 33.24           N  
ATOM   3828  N   ILE D 141      25.789  22.316  10.224  1.00 17.08           N  
ATOM   3829  CA  ILE D 141      24.910  21.673   9.284  1.00 13.87           C  
ATOM   3830  C   ILE D 141      24.227  22.740   8.434  1.00 14.95           C  
ATOM   3831  O   ILE D 141      23.574  23.604   8.992  1.00 16.57           O  
ATOM   3832  CB  ILE D 141      23.877  20.805  10.024  1.00 14.91           C  
ATOM   3833  CG1 ILE D 141      24.554  19.652  10.770  1.00 14.87           C  
ATOM   3834  CG2 ILE D 141      22.762  20.356   9.019  1.00 12.49           C  
ATOM   3835  CD1 ILE D 141      23.684  19.020  11.913  1.00 15.69           C  
ATOM   3836  N   THR D 142      24.379  22.654   7.108  1.00 15.71           N  
ATOM   3837  CA  THR D 142      23.774  23.623   6.159  1.00 15.55           C  
ATOM   3838  C   THR D 142      22.561  23.082   5.372  1.00 15.06           C  
ATOM   3839  O   THR D 142      21.790  23.849   4.792  1.00 14.71           O  
ATOM   3840  CB  THR D 142      24.836  24.153   5.200  1.00 18.38           C  
ATOM   3841  OG1 THR D 142      25.405  23.051   4.476  1.00 15.39           O  
ATOM   3842  CG2 THR D 142      25.961  24.979   6.013  1.00 14.02           C  
ATOM   3843  N   HIS D 143      22.397  21.758   5.389  1.00 14.87           N  
ATOM   3844  CA  HIS D 143      21.310  21.103   4.706  1.00 14.13           C  
ATOM   3845  C   HIS D 143      20.953  19.850   5.401  1.00 14.62           C  
ATOM   3846  O   HIS D 143      21.834  19.050   5.778  1.00 15.49           O  
ATOM   3847  CB  HIS D 143      21.634  20.821   3.243  1.00 12.97           C  
ATOM   3848  CG  HIS D 143      20.562  20.067   2.500  1.00 15.22           C  
ATOM   3849  ND1 HIS D 143      19.354  20.633   2.185  1.00 15.05           N  
ATOM   3850  CD2 HIS D 143      20.497  18.782   2.074  1.00 14.34           C  
ATOM   3851  CE1 HIS D 143      18.586  19.734   1.585  1.00 16.39           C  
ATOM   3852  NE2 HIS D 143      19.260  18.604   1.496  1.00 12.99           N  
ATOM   3853  N   VAL D 144      19.661  19.655   5.556  1.00 15.02           N  
ATOM   3854  CA  VAL D 144      19.114  18.441   6.179  1.00 13.38           C  
ATOM   3855  C   VAL D 144      18.031  17.875   5.273  1.00 16.13           C  
ATOM   3856  O   VAL D 144      17.154  18.646   4.813  1.00 17.85           O  
ATOM   3857  CB  VAL D 144      18.456  18.707   7.572  1.00 14.97           C  
ATOM   3858  CG1 VAL D 144      17.797  17.430   8.043  1.00 15.17           C  
ATOM   3859  CG2 VAL D 144      19.458  19.307   8.658  1.00 13.07           C  
ATOM   3860  N   HIS D 145      18.105  16.581   4.959  1.00 14.71           N  
ATOM   3861  CA  HIS D 145      17.030  15.900   4.215  1.00 16.38           C  
ATOM   3862  C   HIS D 145      16.627  14.685   5.031  1.00 15.77           C  
ATOM   3863  O   HIS D 145      17.426  13.766   5.261  1.00 13.53           O  
ATOM   3864  CB  HIS D 145      17.520  15.481   2.837  1.00 14.58           C  
ATOM   3865  CG  HIS D 145      16.462  15.015   1.880  1.00 18.60           C  
ATOM   3866  ND1 HIS D 145      16.671  15.046   0.526  1.00 13.87           N  
ATOM   3867  CD2 HIS D 145      15.223  14.474   2.054  1.00 13.45           C  
ATOM   3868  CE1 HIS D 145      15.618  14.552  -0.093  1.00 11.99           C  
ATOM   3869  NE2 HIS D 145      14.733  14.167   0.809  1.00 13.97           N  
ATOM   3870  N   TRP D 146      15.404  14.705   5.520  1.00 15.27           N  
ATOM   3871  CA  TRP D 146      14.840  13.572   6.252  1.00 15.98           C  
ATOM   3872  C   TRP D 146      13.702  12.896   5.484  1.00 18.40           C  
ATOM   3873  O   TRP D 146      12.877  13.545   4.854  1.00 13.26           O  
ATOM   3874  CB  TRP D 146      14.280  14.053   7.607  1.00 18.26           C  
ATOM   3875  CG  TRP D 146      15.253  14.434   8.617  1.00 18.55           C  
ATOM   3876  CD1 TRP D 146      16.414  13.765   8.926  1.00 18.09           C  
ATOM   3877  CD2 TRP D 146      15.150  15.511   9.577  1.00 15.67           C  
ATOM   3878  NE1 TRP D 146      17.052  14.391   9.993  1.00 18.13           N  
ATOM   3879  CE2 TRP D 146      16.273  15.449  10.405  1.00 16.19           C  
ATOM   3880  CE3 TRP D 146      14.205  16.513   9.820  1.00 19.81           C  
ATOM   3881  CZ2 TRP D 146      16.489  16.371  11.418  1.00 18.26           C  
ATOM   3882  CZ3 TRP D 146      14.408  17.393  10.821  1.00 21.16           C  
ATOM   3883  CH2 TRP D 146      15.538  17.345  11.611  1.00 19.26           C  
ATOM   3884  N   SER D 147      13.666  11.573   5.567  1.00 16.60           N  
ATOM   3885  CA  SER D 147      12.588  10.740   5.066  1.00 19.52           C  
ATOM   3886  C   SER D 147      12.488   9.433   5.871  1.00 19.50           C  
ATOM   3887  O   SER D 147      13.284   9.137   6.783  1.00 21.40           O  
ATOM   3888  CB  SER D 147      12.813  10.409   3.588  1.00 20.78           C  
ATOM   3889  OG  SER D 147      13.947   9.601   3.469  1.00 17.51           O  
ATOM   3890  OXT SER D 147      11.575   8.633   5.613  1.00 20.67           O  
TER    3891      SER D 147                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
