
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 1063),  selected  133 , name 2gey_D
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 2gey_D.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      M       2           -
LGA    -       -      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    -       -      D       7           -
LGA    S     2_D      N       8          2.328
LGA    M     3_D      T       9          3.977
LGA    A     4_D      L      10          4.004
LGA    E     5_D      K      11          1.433
LGA    R     6_D      V      12          2.500
LGA    K     7_D      A      13          4.013
LGA    A     8_D      H      14          2.905
LGA    L     9_D      Q      15          1.378
LGA    C    10_D      G      16          2.806
LGA    L    11_D      F      17          3.077
LGA    E    12_D      E      18          2.094
LGA    M    13_D      F      19          2.124
LGA    V    14_D      F      20          3.112
LGA    A    15_D      T      21          3.523
LGA    A    16_D      Q      22          2.231
LGA    W    17_D      G      23          2.031
LGA    -       -      L      24           -
LGA    N    18_D      A      25          2.697
LGA    R    19_D      T      26          3.176
LGA    W    20_D      G      27          2.543
LGA    D    21_D      E      28          1.471
LGA    L    22_D      W      29          0.970
LGA    S    23_D      Q      30          0.827
LGA    G    24_D      K      31          1.606
LGA    I    25_D      F      32          1.189
LGA    I    26_D      L      33          0.750
LGA    K    27_D      D      34          0.859
LGA    H    28_D      M      35          0.783
LGA    W    29_D      L      36          0.477
LGA    S    30_D      T      37          0.209
LGA    P    31_D      E      38          0.561
LGA    D    32_D      D      39          1.104
LGA    I    33_D      F      40          1.029
LGA    V    34_D      T      41          1.640
LGA    H    35_D      F      42          1.501
LGA    Y    36_D      W      43          2.094
LGA    S    37_D      F      44          2.934
LGA    E    38_D      P      45          4.379
LGA    D    39_D      M      46           -
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    -       -      H      50           -
LGA    N    40_D      G      51          3.179
LGA    E    41_D      L      52          1.258
LGA    V    42_D      N      53          1.511
LGA    S    43_D      V      54          3.078
LGA    S    44_D      G      55          3.595
LGA    -       -      K      56           -
LGA    A    45_D      E      57          3.982
LGA    D    46_D      R      58          4.043
LGA    M    47_D      A      59          3.747
LGA    V    48_D      K      60          2.713
LGA    K    49_D      E      61          2.406
LGA    L    50_D      F      62          2.917
LGA    M    51_D      F      63          1.844
LGA    E    52_D      T      64          1.243
LGA    G    53_D      Y      65          2.095
LGA    G    54_D      V      66          2.261
LGA    L    55_D      S      67          0.971
LGA    K    56_D      E      68          1.593
LGA    A    57_D      S      69          0.614
LGA    F    58_D      F      70          1.014
LGA    P    59_D      H      71          2.309
LGA    D    60_D      T      72          2.077
LGA    L    61_D      G      73          2.569
LGA    -       -      I      74           -
LGA    Q    62_D      Q      75          1.167
LGA    L    63_D      I      76          2.128
LGA    E    64_D      S      77          3.393
LGA    V    65_D      S      78          4.269
LGA    K    66_D      L      79          2.387
LGA    -       -      D      80           -
LGA    S    67_D      R      81          1.980
LGA    I    68_D      V      82          1.562
LGA    M    69_D      T      83          1.730
LGA    A    70_D      S      84          2.010
LGA    E    71_D      N      85          1.566
LGA    E    72_D      E      86          0.764
LGA    D    73_D      T      87          1.493
LGA    R    74_D      T      88          1.241
LGA    V    75_D      V      89          0.957
LGA    A    76_D      V      90          0.681
LGA    L    77_D      F      91          0.575
LGA    R    78_D      E      92          1.104
LGA    I    79_D      F      93          2.042
LGA    T    80_D      R      94          1.813
LGA    V    81_D      D      95          1.949
LGA    T    82_D      E      96          0.668
LGA    A    83_D      G      97          0.627
LGA    T    84_D      L      98          1.184
LGA    H    85_D      F      99          2.234
LGA    Q    86_D      L     100          2.400
LGA    G    87_D      -       -           -
LGA    E    88_D      -       -           -
LGA    F    89_D      -       -           -
LGA    M    90_D      -       -           -
LGA    G    91_D      -       -           -
LGA    V    92_D      -       -           -
LGA    Q    93_D      -       -           -
LGA    P    94_D      -       -           -
LGA    T    95_D      -       -           -
LGA    G    96_D      G     101          2.049
LGA    Q    97_D      K     102          2.513
LGA    R    98_D      P     103          2.099
LGA    V    99_D      Y     104          1.720
LGA    S   100_D      K     105          1.041
LGA    W   101_D      N     106          1.918
LGA    H   102_D      R     107          2.187
LGA    L   103_D      V     108          1.397
LGA    V   104_D      A     109          0.800
LGA    E   105_D      V     110          0.766
LGA    E   106_D      S     111          0.603
LGA    L   107_D      F     112          0.622
LGA    R   108_D      D     113          0.736
LGA    F   109_D      V     114          0.930
LGA    V   110_D      R     115          0.932
LGA    D   111_D      G     116          1.408
LGA    G   112_D      D     117          1.096
LGA    K   113_D      K     118          0.935
LGA    V   114_D      I     119          0.866
LGA    V   115_D      C     120          1.018
LGA    E   116_D      S     121          1.644
LGA    H   117_D      Y     122          1.328
LGA    W   118_D      R     123          1.311
LGA    D   119_D      E     124          1.306
LGA    V   120_D      Y     125          0.963
LGA    I   121_D      F     126          2.633
LGA    N   122_D      G     127          4.350
LGA    M   123_D      S     128          6.219
LGA    R   124_D      D     129          2.042
LGA    P   125_D      G     130          2.467
LGA    L   126_D      K     131          4.544
LGA    L   127_D      S     132           #
LGA    V   128_D      N     133           -
LGA    R   129_D      -       -           -
LGA    L   130_D      -       -           -
LGA    G   131_D      -       -           -
LGA    K   132_D      -       -           -
LGA    L   133_D      -       -           -
LGA    P   134_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  133    5.0    115    2.24     6.96     70.772     4.922

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.225802 * X  +   0.030371 * Y  +   0.973700 * Z  +  11.483953
  Y_new =  -0.076762 * X  +  -0.996961 * Y  +   0.013295 * Z  +  39.180195
  Z_new =   0.971144 * X  +  -0.071741 * Y  +   0.227447 * Z  +  -3.387248 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.305541    2.836051  [ DEG:   -17.5062    162.4938 ]
  Theta =  -1.329983   -1.811610  [ DEG:   -76.2024   -103.7976 ]
  Phi   =  -2.813897    0.327696  [ DEG:  -161.2244     18.7756 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gey_D                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gey_D.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  133   5.0  115   2.24    6.96  70.772
REMARK  ---------------------------------------------------------- 
MOLECULE 2gey_D
HEADER    OXIDOREDUCTASE                          21-MAR-06   2GEY              
TITLE     CRYSTAL STRUCTURE OF ACLR A PUTATIVE HYDROXYLASE FROM                 
TITLE    2 STREPTOMYCES GALILAEUS                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACLR PROTEIN;                                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PUTATIVE HYDROXYLASE;                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES GALILAEUS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: ATCC31133;                                                   
SOURCE   5 GENE: ACLR;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET30B                                    
KEYWDS    ALPHA+BETA BARREL                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.BEINKER,B.LOHKAMP,G.SCHNEIDER                                       
REVDAT   1   18-JUL-06 2GEY    0                                                
JRNL        AUTH   P.BEINKER,B.LOHKAMP,T.PELTONEN,J.NIEMI,P.MANTSALA,           
JRNL        AUTH 2 G.SCHNEIDER                                                  
JRNL        TITL   CRYSTAL STRUCTURES OF SNOAL2 AND ACLR: TWO                   
JRNL        TITL 2 PUTATIVE HYDROXYLASES IN THE BIOSYNTHESIS OF                 
JRNL        TITL 3 AROMATIC POLYKETIDE ANTIBIOTICS                              
JRNL        REF    J.MOL.BIOL.                   V. 359   728 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2GEY A    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY B    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY C    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY D    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
SEQRES   1 A  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 A  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 A  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 A  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 A  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 A  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 A  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 A  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 A  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 A  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 A  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 A  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 A  158  HIS HIS                                                      
SEQRES   1 B  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 B  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 B  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 B  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 B  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 B  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 B  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 B  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 B  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 B  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 B  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 B  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 B  158  HIS HIS                                                      
SEQRES   1 C  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 C  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 C  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 C  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 C  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 C  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 C  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 C  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 C  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 C  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 C  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 C  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 C  158  HIS HIS                                                      
SEQRES   1 D  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 D  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 D  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 D  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 D  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 D  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 D  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 D  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 D  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 D  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 D  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 D  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 D  158  HIS HIS                                                      
HET    PG4   1001      13                                                       
HET    PG4   1002      13                                                       
HET    PG4   1003      13                                                       
HET    PG4   1004      13                                                       
HET    GOL   2001       6                                                       
HET    GOL   2002       6                                                       
HET    GOL   2003       6                                                       
HET    GOL   2004       6                                                       
HET    GOL   2005       6                                                       
HET    PEG   3001       7                                                       
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
HETNAM     GOL GLYCEROL                                                         
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
FORMUL   5  PG4    4(C8 H18 O5)                                                 
FORMUL   9  GOL    5(C3 H8 O3)                                                  
FORMUL  14  PEG    C4 H10 O3                                                    
FORMUL  15  HOH   *548(H2 O)                                                    
CRYST1   80.908   81.724  136.640  90.00  90.00  90.00 P 21 21 21   16          
ATOM   3653  N   SER D   2      37.715  16.648  10.043  1.00 25.49           N  
ATOM   3654  CA  SER D   2      37.819  15.294   9.426  1.00 25.54           C  
ATOM   3655  C   SER D   2      36.469  14.594   9.422  1.00 25.04           C  
ATOM   3656  O   SER D   2      35.538  14.995  10.132  1.00 24.29           O  
ATOM   3657  CB  SER D   2      38.816  14.435  10.201  1.00 25.71           C  
ATOM   3658  OG  SER D   2      38.277  14.022  11.451  1.00 25.87           O  
ATOM   3659  N   MET D   3      36.371  13.530   8.630  1.00 24.69           N  
ATOM   3660  CA  MET D   3      35.165  12.716   8.601  1.00 25.28           C  
ATOM   3661  C   MET D   3      34.831  12.175   9.989  1.00 24.89           C  
ATOM   3662  O   MET D   3      33.670  12.183  10.402  1.00 25.25           O  
ATOM   3663  CB  MET D   3      35.334  11.572   7.604  1.00 25.17           C  
ATOM   3664  CG  MET D   3      35.364  12.051   6.166  1.00 25.37           C  
ATOM   3665  SD  MET D   3      35.557  10.690   4.996  1.00 27.19           S  
ATOM   3666  CE  MET D   3      37.303  10.333   5.159  1.00 28.34           C  
ATOM   3667  N   ALA D   4      35.853  11.731  10.716  1.00 24.99           N  
ATOM   3668  CA  ALA D   4      35.661  11.195  12.062  1.00 24.57           C  
ATOM   3669  C   ALA D   4      35.041  12.229  12.999  1.00 24.05           C  
ATOM   3670  O   ALA D   4      34.133  11.914  13.765  1.00 23.81           O  
ATOM   3671  CB  ALA D   4      36.968  10.692  12.621  1.00 24.88           C  
ATOM   3672  N   GLU D   5      35.538  13.463  12.933  1.00 24.00           N  
ATOM   3673  CA  GLU D   5      35.019  14.545  13.768  1.00 24.24           C  
ATOM   3674  C   GLU D   5      33.601  14.940  13.389  1.00 23.92           C  
ATOM   3675  O   GLU D   5      32.775  15.184  14.266  1.00 23.67           O  
ATOM   3676  CB  GLU D   5      35.953  15.756  13.708  1.00 24.24           C  
ATOM   3677  CG  GLU D   5      37.284  15.455  14.355  1.00 24.45           C  
ATOM   3678  CD  GLU D   5      38.411  16.365  13.921  1.00 26.11           C  
ATOM   3679  OE1 GLU D   5      38.254  17.143  12.947  1.00 29.75           O  
ATOM   3680  OE2 GLU D   5      39.466  16.295  14.576  1.00 26.02           O  
ATOM   3681  N   ARG D   6      33.314  14.995  12.089  1.00 23.65           N  
ATOM   3682  CA  ARG D   6      31.966  15.318  11.623  1.00 23.97           C  
ATOM   3683  C   ARG D   6      30.962  14.218  11.983  1.00 24.25           C  
ATOM   3684  O   ARG D   6      29.838  14.518  12.391  1.00 23.75           O  
ATOM   3685  CB  ARG D   6      31.971  15.626  10.125  1.00 24.32           C  
ATOM   3686  CG  ARG D   6      32.653  16.947   9.823  1.00 23.18           C  
ATOM   3687  CD  ARG D   6      32.573  17.322   8.356  1.00 24.97           C  
ATOM   3688  NE  ARG D   6      33.468  16.529   7.505  1.00 25.02           N  
ATOM   3689  CZ  ARG D   6      34.766  16.782   7.299  1.00 26.73           C  
ATOM   3690  NH1 ARG D   6      35.373  17.798   7.885  1.00 27.64           N  
ATOM   3691  NH2 ARG D   6      35.472  15.997   6.490  1.00 27.22           N  
ATOM   3692  N   LYS D   7      31.387  12.958  11.925  1.00 24.21           N  
ATOM   3693  CA  LYS D   7      30.530  11.866  12.417  1.00 25.10           C  
ATOM   3694  C   LYS D   7      30.232  12.033  13.907  1.00 25.02           C  
ATOM   3695  O   LYS D   7      29.089  11.872  14.343  1.00 25.32           O  
ATOM   3696  CB  LYS D   7      31.172  10.505  12.168  1.00 25.11           C  
ATOM   3697  CG  LYS D   7      31.061  10.031  10.744  1.00 27.62           C  
ATOM   3698  CD  LYS D   7      31.395   8.553  10.718  1.00 27.94           C  
ATOM   3699  CE  LYS D   7      32.097   8.139   9.484  1.00 32.84           C  
ATOM   3700  NZ  LYS D   7      32.854   6.857   9.747  1.00 32.03           N  
ATOM   3701  N   ALA D   8      31.259  12.386  14.679  1.00 25.05           N  
ATOM   3702  CA  ALA D   8      31.111  12.591  16.115  1.00 25.25           C  
ATOM   3703  C   ALA D   8      30.118  13.714  16.407  1.00 25.29           C  
ATOM   3704  O   ALA D   8      29.271  13.582  17.298  1.00 25.91           O  
ATOM   3705  CB  ALA D   8      32.450  12.874  16.757  1.00 25.49           C  
ATOM   3706  N   LEU D   9      30.200  14.804  15.648  1.00 25.15           N  
ATOM   3707  CA  LEU D   9      29.267  15.914  15.823  1.00 25.49           C  
ATOM   3708  C   LEU D   9      27.831  15.491  15.501  1.00 25.62           C  
ATOM   3709  O   LEU D   9      26.903  15.812  16.239  1.00 25.72           O  
ATOM   3710  CB  LEU D   9      29.694  17.125  14.990  1.00 25.52           C  
ATOM   3711  CG  LEU D   9      30.918  17.840  15.567  1.00 25.84           C  
ATOM   3712  CD1 LEU D   9      31.526  18.769  14.518  1.00 27.45           C  
ATOM   3713  CD2 LEU D   9      30.570  18.607  16.838  1.00 25.60           C  
ATOM   3714  N   CYS D  10      27.641  14.742  14.421  1.00 25.69           N  
ATOM   3715  CA  CYS D  10      26.303  14.240  14.090  1.00 26.07           C  
ATOM   3716  C   CYS D  10      25.753  13.329  15.177  1.00 26.03           C  
ATOM   3717  O   CYS D  10      24.572  13.394  15.480  1.00 26.09           O  
ATOM   3718  CB  CYS D  10      26.300  13.501  12.760  1.00 26.27           C  
ATOM   3719  SG  CYS D  10      26.610  14.610  11.381  1.00 28.96           S  
ATOM   3720  N   LEU D  11      26.598  12.490  15.769  1.00 25.75           N  
ATOM   3721  CA  LEU D  11      26.144  11.640  16.855  1.00 26.06           C  
ATOM   3722  C   LEU D  11      25.783  12.435  18.127  1.00 26.16           C  
ATOM   3723  O   LEU D  11      24.928  12.006  18.917  1.00 25.59           O  
ATOM   3724  CB  LEU D  11      27.165  10.543  17.142  1.00 26.47           C  
ATOM   3725  CG  LEU D  11      27.336   9.530  16.007  1.00 26.79           C  
ATOM   3726  CD1 LEU D  11      28.403   8.497  16.359  1.00 29.93           C  
ATOM   3727  CD2 LEU D  11      26.008   8.849  15.655  1.00 27.41           C  
ATOM   3728  N   GLU D  12      26.406  13.595  18.327  1.00 26.05           N  
ATOM   3729  CA  GLU D  12      25.981  14.490  19.413  1.00 26.57           C  
ATOM   3730  C   GLU D  12      24.593  15.065  19.146  1.00 26.46           C  
ATOM   3731  O   GLU D  12      23.820  15.310  20.079  1.00 26.63           O  
ATOM   3732  CB  GLU D  12      26.993  15.627  19.630  1.00 27.53           C  
ATOM   3733  CG  GLU D  12      28.303  15.154  20.216  1.00 30.77           C  
ATOM   3734  CD  GLU D  12      28.114  14.408  21.511  1.00 36.54           C  
ATOM   3735  OE1 GLU D  12      27.640  15.028  22.479  1.00 40.54           O  
ATOM   3736  OE2 GLU D  12      28.397  13.188  21.550  1.00 40.99           O  
ATOM   3737  N   MET D  13      24.282  15.304  17.874  1.00 26.16           N  
ATOM   3738  CA  MET D  13      22.960  15.789  17.482  0.50 26.43           C  
ATOM   3740  C   MET D  13      21.923  14.697  17.756  1.00 26.12           C  
ATOM   3741  O   MET D  13      20.847  14.972  18.268  1.00 25.97           O  
ATOM   3742  CB  MET D  13      22.945  16.212  16.008  0.50 26.52           C  
ATOM   3744  CG  MET D  13      24.008  17.256  15.654  0.50 26.98           C  
ATOM   3746  SD  MET D  13      24.131  17.568  13.887  0.50 28.35           S  
ATOM   3748  CE  MET D  13      22.783  18.743  13.692  0.50 28.88           C  
ATOM   3750  N   VAL D  14      22.278  13.449  17.443  1.00 25.57           N  
ATOM   3751  CA  VAL D  14      21.425  12.286  17.765  1.00 25.50           C  
ATOM   3752  C   VAL D  14      21.231  12.181  19.282  1.00 25.19           C  
ATOM   3753  O   VAL D  14      20.113  11.970  19.752  1.00 24.40           O  
ATOM   3754  CB  VAL D  14      22.011  10.973  17.198  1.00 25.74           C  
ATOM   3755  CG1 VAL D  14      21.231   9.755  17.696  1.00 26.06           C  
ATOM   3756  CG2 VAL D  14      22.006  11.008  15.673  1.00 26.54           C  
ATOM   3757  N   ALA D  15      22.311  12.365  20.046  1.00 24.55           N  
ATOM   3758  CA  ALA D  15      22.222  12.329  21.504  1.00 24.45           C  
ATOM   3759  C   ALA D  15      21.277  13.416  22.023  1.00 24.37           C  
ATOM   3760  O   ALA D  15      20.531  13.185  22.973  1.00 24.84           O  
ATOM   3761  CB  ALA D  15      23.587  12.472  22.136  1.00 24.63           C  
ATOM   3762  N   ALA D  16      21.316  14.589  21.396  1.00 24.16           N  
ATOM   3763  CA  ALA D  16      20.428  15.704  21.758  1.00 24.28           C  
ATOM   3764  C   ALA D  16      18.964  15.327  21.539  1.00 24.47           C  
ATOM   3765  O   ALA D  16      18.117  15.594  22.399  1.00 24.44           O  
ATOM   3766  CB  ALA D  16      20.775  16.945  20.962  1.00 24.82           C  
ATOM   3767  N   TRP D  17      18.667  14.715  20.395  1.00 24.10           N  
ATOM   3768  CA  TRP D  17      17.320  14.186  20.147  1.00 24.58           C  
ATOM   3769  C   TRP D  17      16.917  13.220  21.252  1.00 24.24           C  
ATOM   3770  O   TRP D  17      15.804  13.282  21.759  1.00 23.89           O  
ATOM   3771  CB  TRP D  17      17.235  13.460  18.815  1.00 25.51           C  
ATOM   3772  CG  TRP D  17      16.832  14.315  17.689  1.00 27.01           C  
ATOM   3773  CD1 TRP D  17      17.577  14.636  16.605  1.00 28.11           C  
ATOM   3774  CD2 TRP D  17      15.572  14.965  17.524  1.00 26.96           C  
ATOM   3775  NE1 TRP D  17      16.856  15.445  15.759  1.00 28.76           N  
ATOM   3776  CE2 TRP D  17      15.622  15.665  16.304  1.00 27.08           C  
ATOM   3777  CE3 TRP D  17      14.407  15.024  18.291  1.00 27.58           C  
ATOM   3778  CZ2 TRP D  17      14.549  16.422  15.832  1.00 28.47           C  
ATOM   3779  CZ3 TRP D  17      13.338  15.776  17.820  1.00 28.68           C  
ATOM   3780  CH2 TRP D  17      13.424  16.469  16.602  1.00 28.14           C  
ATOM   3781  N   ASN D  18      17.842  12.339  21.620  1.00 24.09           N  
ATOM   3782  CA  ASN D  18      17.560  11.275  22.571  1.00 24.57           C  
ATOM   3783  C   ASN D  18      17.413  11.739  24.018  1.00 24.66           C  
ATOM   3784  O   ASN D  18      16.966  10.972  24.869  1.00 24.31           O  
ATOM   3785  CB  ASN D  18      18.595  10.154  22.437  1.00 25.07           C  
ATOM   3786  CG  ASN D  18      18.332   9.273  21.231  1.00 26.39           C  
ATOM   3787  OD1 ASN D  18      17.191   9.188  20.761  1.00 26.48           O  
ATOM   3788  ND2 ASN D  18      19.375   8.605  20.723  1.00 23.77           N  
ATOM   3789  N   ARG D  19      17.772  12.989  24.298  1.00 24.70           N  
ATOM   3790  CA  ARG D  19      17.404  13.603  25.580  1.00 24.96           C  
ATOM   3791  C   ARG D  19      16.384  14.734  25.395  1.00 25.24           C  
ATOM   3792  O   ARG D  19      16.144  15.523  26.320  1.00 24.35           O  
ATOM   3793  CB  ARG D  19      18.653  14.073  26.337  1.00 25.39           C  
ATOM   3794  CG  ARG D  19      19.451  15.144  25.634  1.00 25.28           C  
ATOM   3795  CD  ARG D  19      20.530  15.782  26.531  1.00 25.98           C  
ATOM   3796  NE  ARG D  19      21.149  16.875  25.789  1.00 26.65           N  
ATOM   3797  CZ  ARG D  19      22.151  16.731  24.925  1.00 27.79           C  
ATOM   3798  NH1 ARG D  19      22.731  15.560  24.742  1.00 27.31           N  
ATOM   3799  NH2 ARG D  19      22.594  17.781  24.250  1.00 29.22           N  
ATOM   3800  N   TRP D  20      15.776  14.785  24.210  1.00 25.12           N  
ATOM   3801  CA  TRP D  20      14.661  15.694  23.899  1.00 25.49           C  
ATOM   3802  C   TRP D  20      15.049  17.166  24.052  1.00 25.74           C  
ATOM   3803  O   TRP D  20      14.276  17.996  24.566  1.00 25.82           O  
ATOM   3804  CB  TRP D  20      13.422  15.312  24.726  1.00 25.65           C  
ATOM   3805  CG  TRP D  20      13.219  13.824  24.692  1.00 25.75           C  
ATOM   3806  CD1 TRP D  20      12.902  13.070  23.602  1.00 25.92           C  
ATOM   3807  CD2 TRP D  20      13.392  12.907  25.773  1.00 26.03           C  
ATOM   3808  NE1 TRP D  20      12.847  11.749  23.938  1.00 25.41           N  
ATOM   3809  CE2 TRP D  20      13.145  11.614  25.265  1.00 26.36           C  
ATOM   3810  CE3 TRP D  20      13.726  13.051  27.125  1.00 26.59           C  
ATOM   3811  CZ2 TRP D  20      13.213  10.471  26.060  1.00 26.25           C  
ATOM   3812  CZ3 TRP D  20      13.799  11.914  27.914  1.00 26.38           C  
ATOM   3813  CH2 TRP D  20      13.542  10.640  27.377  1.00 26.37           C  
ATOM   3814  N   ASP D  21      16.259  17.463  23.566  1.00 25.96           N  
ATOM   3815  CA  ASP D  21      16.887  18.767  23.690  1.00 26.17           C  
ATOM   3816  C   ASP D  21      17.068  19.398  22.299  1.00 26.46           C  
ATOM   3817  O   ASP D  21      18.108  19.239  21.662  1.00 25.89           O  
ATOM   3818  CB  ASP D  21      18.232  18.606  24.393  1.00 26.06           C  
ATOM   3819  CG  ASP D  21      18.986  19.922  24.532  1.00 27.52           C  
ATOM   3820  OD1 ASP D  21      18.371  21.005  24.380  1.00 29.34           O  
ATOM   3821  OD2 ASP D  21      20.202  19.856  24.780  1.00 31.19           O  
ATOM   3822  N   LEU D  22      16.054  20.114  21.824  1.00 26.87           N  
ATOM   3823  CA  LEU D  22      16.120  20.667  20.463  1.00 27.73           C  
ATOM   3824  C   LEU D  22      17.245  21.690  20.308  1.00 27.74           C  
ATOM   3825  O   LEU D  22      17.859  21.793  19.243  1.00 27.73           O  
ATOM   3826  CB  LEU D  22      14.789  21.281  20.056  1.00 28.28           C  
ATOM   3827  CG  LEU D  22      13.619  20.299  19.954  1.00 29.36           C  
ATOM   3828  CD1 LEU D  22      12.409  21.007  19.360  1.00 31.12           C  
ATOM   3829  CD2 LEU D  22      13.972  19.072  19.148  1.00 30.30           C  
ATOM   3830  N   SER D  23      17.526  22.420  21.378  1.00 28.00           N  
ATOM   3831  CA  SER D  23      18.584  23.421  21.345  0.50 28.18           C  
ATOM   3833  C   SER D  23      19.949  22.780  21.079  1.00 28.37           C  
ATOM   3834  O   SER D  23      20.812  23.397  20.449  1.00 28.33           O  
ATOM   3835  CB  SER D  23      18.587  24.244  22.635  0.50 28.15           C  
ATOM   3837  OG  SER D  23      17.448  25.088  22.681  0.50 28.35           O  
ATOM   3839  N   GLY D  24      20.126  21.529  21.527  1.00 28.25           N  
ATOM   3840  CA  GLY D  24      21.356  20.775  21.304  1.00 28.43           C  
ATOM   3841  C   GLY D  24      21.582  20.341  19.866  1.00 28.76           C  
ATOM   3842  O   GLY D  24      22.680  19.901  19.504  1.00 29.53           O  
ATOM   3843  N   ILE D  25      20.535  20.432  19.047  1.00 28.49           N  
ATOM   3844  CA  ILE D  25      20.630  20.179  17.617  1.00 28.24           C  
ATOM   3845  C   ILE D  25      20.848  21.500  16.888  1.00 27.84           C  
ATOM   3846  O   ILE D  25      21.774  21.641  16.083  1.00 28.01           O  
ATOM   3847  CB  ILE D  25      19.340  19.516  17.098  1.00 28.16           C  
ATOM   3848  CG1 ILE D  25      19.164  18.138  17.756  1.00 30.34           C  
ATOM   3849  CG2 ILE D  25      19.359  19.401  15.575  1.00 29.07           C  
ATOM   3850  CD1 ILE D  25      17.774  17.829  18.152  1.00 31.43           C  
ATOM   3851  N   ILE D  26      19.985  22.466  17.195  1.00 27.12           N  
ATOM   3852  CA  ILE D  26      19.945  23.737  16.490  1.00 27.07           C  
ATOM   3853  C   ILE D  26      21.236  24.531  16.674  1.00 27.07           C  
ATOM   3854  O   ILE D  26      21.622  25.305  15.802  1.00 26.34           O  
ATOM   3855  CB  ILE D  26      18.720  24.568  16.960  1.00 26.81           C  
ATOM   3856  CG1 ILE D  26      17.422  23.852  16.548  1.00 26.38           C  
ATOM   3857  CG2 ILE D  26      18.773  25.976  16.406  1.00 27.28           C  
ATOM   3858  CD1 ILE D  26      16.182  24.314  17.288  1.00 27.87           C  
ATOM   3859  N   LYS D  27      21.911  24.337  17.803  1.00 26.85           N  
ATOM   3860  CA  LYS D  27      23.161  25.048  18.048  1.00 27.66           C  
ATOM   3861  C   LYS D  27      24.246  24.730  17.012  1.00 27.54           C  
ATOM   3862  O   LYS D  27      25.172  25.517  16.845  1.00 27.21           O  
ATOM   3863  CB  LYS D  27      23.683  24.761  19.452  1.00 27.77           C  
ATOM   3864  CG  LYS D  27      24.190  23.363  19.695  1.00 28.76           C  
ATOM   3865  CD  LYS D  27      24.563  23.223  21.149  1.00 29.43           C  
ATOM   3866  CE  LYS D  27      25.148  21.880  21.470  1.00 32.30           C  
ATOM   3867  NZ  LYS D  27      25.758  21.948  22.835  1.00 33.44           N  
ATOM   3868  N   HIS D  28      24.128  23.590  16.332  1.00 27.44           N  
ATOM   3869  CA  HIS D  28      25.096  23.198  15.297  1.00 28.07           C  
ATOM   3870  C   HIS D  28      24.762  23.719  13.901  1.00 28.25           C  
ATOM   3871  O   HIS D  28      25.525  23.509  12.948  1.00 28.55           O  
ATOM   3872  CB  HIS D  28      25.226  21.690  15.260  1.00 28.96           C  
ATOM   3873  CG  HIS D  28      25.735  21.111  16.541  1.00 30.50           C  
ATOM   3874  ND1 HIS D  28      27.008  21.359  17.014  1.00 34.00           N  
ATOM   3875  CD2 HIS D  28      25.131  20.333  17.469  1.00 31.82           C  
ATOM   3876  CE1 HIS D  28      27.174  20.729  18.166  1.00 33.25           C  
ATOM   3877  NE2 HIS D  28      26.050  20.102  18.465  1.00 31.98           N  
ATOM   3878  N   TRP D  29      23.618  24.379  13.775  1.00 27.76           N  
ATOM   3879  CA  TRP D  29      23.195  24.936  12.504  1.00 27.30           C  
ATOM   3880  C   TRP D  29      23.933  26.232  12.215  1.00 27.44           C  
ATOM   3881  O   TRP D  29      24.086  27.085  13.097  1.00 27.21           O  
ATOM   3882  CB  TRP D  29      21.697  25.235  12.537  1.00 27.30           C  
ATOM   3883  CG  TRP D  29      20.788  24.032  12.597  1.00 26.62           C  
ATOM   3884  CD1 TRP D  29      21.148  22.725  12.690  1.00 27.24           C  
ATOM   3885  CD2 TRP D  29      19.359  24.057  12.584  1.00 26.63           C  
ATOM   3886  NE1 TRP D  29      20.028  21.923  12.723  1.00 27.53           N  
ATOM   3887  CE2 TRP D  29      18.916  22.721  12.662  1.00 27.25           C  
ATOM   3888  CE3 TRP D  29      18.410  25.079  12.509  1.00 27.62           C  
ATOM   3889  CZ2 TRP D  29      17.560  22.381  12.670  1.00 27.97           C  
ATOM   3890  CZ3 TRP D  29      17.057  24.735  12.512  1.00 27.64           C  
ATOM   3891  CH2 TRP D  29      16.652  23.405  12.594  1.00 26.87           C  
ATOM   3892  N   SER D  30      24.385  26.389  10.975  1.00 27.32           N  
ATOM   3893  CA  SER D  30      24.890  27.665  10.511  0.70 27.31           C  
ATOM   3895  C   SER D  30      23.726  28.659  10.458  1.00 27.81           C  
ATOM   3896  O   SER D  30      22.583  28.256  10.215  1.00 27.61           O  
ATOM   3897  CB  SER D  30      25.514  27.534   9.119  0.70 27.34           C  
ATOM   3899  OG  SER D  30      25.678  28.799   8.505  0.70 24.62           O  
ATOM   3901  N   PRO D  31      24.005  29.954  10.673  1.00 28.27           N  
ATOM   3902  CA  PRO D  31      22.944  30.946  10.457  1.00 28.59           C  
ATOM   3903  C   PRO D  31      22.412  30.920   9.025  1.00 28.74           C  
ATOM   3904  O   PRO D  31      21.279  31.345   8.776  1.00 29.66           O  
ATOM   3905  CB  PRO D  31      23.639  32.286  10.710  1.00 28.75           C  
ATOM   3906  CG  PRO D  31      24.907  31.982  11.379  1.00 29.52           C  
ATOM   3907  CD  PRO D  31      25.268  30.573  11.115  1.00 28.62           C  
ATOM   3908  N   ASP D  32      23.246  30.456   8.098  1.00 28.48           N  
ATOM   3909  CA  ASP D  32      22.907  30.381   6.686  1.00 28.39           C  
ATOM   3910  C   ASP D  32      22.458  28.988   6.250  1.00 27.66           C  
ATOM   3911  O   ASP D  32      22.429  28.693   5.052  1.00 27.44           O  
ATOM   3912  CB  ASP D  32      24.124  30.786   5.856  1.00 29.19           C  
ATOM   3913  CG  ASP D  32      24.582  32.195   6.150  1.00 31.54           C  
ATOM   3914  OD1 ASP D  32      23.723  33.096   6.293  1.00 35.58           O  
ATOM   3915  OD2 ASP D  32      25.809  32.404   6.234  1.00 36.35           O  
ATOM   3916  N   ILE D  33      22.112  28.130   7.209  1.00 26.79           N  
ATOM   3917  CA  ILE D  33      21.675  26.770   6.897  1.00 25.87           C  
ATOM   3918  C   ILE D  33      20.485  26.770   5.943  1.00 25.55           C  
ATOM   3919  O   ILE D  33      19.607  27.653   6.006  1.00 24.65           O  
ATOM   3920  CB  ILE D  33      21.328  25.960   8.183  1.00 25.57           C  
ATOM   3921  CG1 ILE D  33      21.083  24.484   7.856  1.00 25.86           C  
ATOM   3922  CG2 ILE D  33      20.123  26.564   8.900  1.00 26.00           C  
ATOM   3923  CD1 ILE D  33      21.059  23.564   9.059  1.00 25.68           C  
ATOM   3924  N   VAL D  34      20.478  25.792   5.041  1.00 25.09           N  
ATOM   3925  CA  VAL D  34      19.324  25.530   4.179  1.00 25.00           C  
ATOM   3926  C   VAL D  34      18.873  24.095   4.404  1.00 24.34           C  
ATOM   3927  O   VAL D  34      19.705  23.179   4.445  1.00 24.63           O  
ATOM   3928  CB  VAL D  34      19.647  25.756   2.689  1.00 24.93           C  
ATOM   3929  CG1 VAL D  34      18.395  25.540   1.832  1.00 25.50           C  
ATOM   3930  CG2 VAL D  34      20.191  27.154   2.481  1.00 26.36           C  
ATOM   3931  N   HIS D  35      17.566  23.899   4.585  1.00 24.15           N  
ATOM   3932  CA  HIS D  35      17.000  22.559   4.761  1.00 24.23           C  
ATOM   3933  C   HIS D  35      16.246  22.184   3.505  1.00 24.01           C  
ATOM   3934  O   HIS D  35      15.577  23.028   2.897  1.00 23.11           O  
ATOM   3935  CB  HIS D  35      16.003  22.498   5.926  1.00 24.70           C  
ATOM   3936  CG  HIS D  35      16.515  23.090   7.197  1.00 25.89           C  
ATOM   3937  ND1 HIS D  35      17.180  22.348   8.145  1.00 27.56           N  
ATOM   3938  CD2 HIS D  35      16.460  24.354   7.675  1.00 28.79           C  
ATOM   3939  CE1 HIS D  35      17.512  23.130   9.156  1.00 27.54           C  
ATOM   3940  NE2 HIS D  35      17.092  24.351   8.893  1.00 28.28           N  
ATOM   3941  N   TYR D  36      16.324  20.908   3.152  1.00 23.85           N  
ATOM   3942  CA  TYR D  36      15.594  20.383   2.014  1.00 24.33           C  
ATOM   3943  C   TYR D  36      14.849  19.112   2.386  1.00 24.32           C  
ATOM   3944  O   TYR D  36      15.403  18.221   3.044  1.00 25.12           O  
ATOM   3945  CB  TYR D  36      16.531  20.054   0.863  1.00 24.94           C  
ATOM   3946  CG  TYR D  36      17.545  21.110   0.501  1.00 25.03           C  
ATOM   3947  CD1 TYR D  36      18.790  21.124   1.101  1.00 25.49           C  
ATOM   3948  CD2 TYR D  36      17.281  22.059  -0.480  1.00 26.68           C  
ATOM   3949  CE1 TYR D  36      19.747  22.074   0.757  1.00 25.81           C  
ATOM   3950  CE2 TYR D  36      18.240  23.020  -0.835  1.00 26.41           C  
ATOM   3951  CZ  TYR D  36      19.472  23.007  -0.213  1.00 25.92           C  
ATOM   3952  OH  TYR D  36      20.431  23.947  -0.552  1.00 26.97           O  
ATOM   3953  N   SER D  37      13.603  19.019   1.937  1.00 24.50           N  
ATOM   3954  CA  SER D  37      12.828  17.795   2.079  1.00 24.50           C  
ATOM   3955  C   SER D  37      11.980  17.602   0.829  1.00 23.94           C  
ATOM   3956  O   SER D  37      11.302  18.532   0.364  1.00 22.84           O  
ATOM   3957  CB  SER D  37      11.960  17.837   3.334  1.00 25.27           C  
ATOM   3958  OG  SER D  37      11.256  16.621   3.501  1.00 27.71           O  
ATOM   3959  N   GLU D  38      12.041  16.392   0.274  1.00 23.73           N  
ATOM   3960  CA  GLU D  38      11.364  16.074  -0.979  1.00 23.95           C  
ATOM   3961  C   GLU D  38      11.812  17.023  -2.099  1.00 23.86           C  
ATOM   3962  O   GLU D  38      11.029  17.381  -2.982  1.00 23.80           O  
ATOM   3963  CB  GLU D  38       9.841  16.075  -0.783  1.00 23.77           C  
ATOM   3964  CG  GLU D  38       9.395  15.206   0.393  1.00 23.22           C  
ATOM   3965  CD  GLU D  38       7.895  15.137   0.587  1.00 24.80           C  
ATOM   3966  OE1 GLU D  38       7.157  15.904  -0.073  1.00 25.91           O  
ATOM   3967  OE2 GLU D  38       7.453  14.290   1.389  1.00 26.42           O  
ATOM   3968  N   ASP D  39      13.063  17.445  -2.032  1.00 24.35           N  
ATOM   3969  CA  ASP D  39      13.694  18.272  -3.029  1.00 24.70           C  
ATOM   3970  C   ASP D  39      13.231  19.730  -2.982  1.00 24.90           C  
ATOM   3971  O   ASP D  39      13.567  20.494  -3.815  1.00 25.81           O  
ATOM   3972  CB  ASP D  39      13.635  17.696  -4.449  1.00 25.07           C  
ATOM   3973  CG  ASP D  39      14.339  16.368  -4.585  1.00 25.29           C  
ATOM   3974  OD1 ASP D  39      15.200  16.061  -3.779  1.00 26.50           O  
ATOM   3975  OD2 ASP D  39      14.006  15.648  -5.508  1.00 27.47           O  
ATOM   3976  N   ASN D  40      12.485  20.069  -1.955  1.00 20.00           N  
ATOM   3977  CA  ASN D  40      12.019  21.419  -1.759  1.00 20.00           C  
ATOM   3978  C   ASN D  40      12.679  22.048  -0.537  1.00 20.00           C  
ATOM   3979  O   ASN D  40      12.823  21.409   0.440  1.00 24.32           O  
ATOM   3980  CB  ASN D  40      10.511  21.430  -1.588  1.00 20.00           C  
ATOM   3981  CG  ASN D  40       9.785  20.782  -2.746  1.00 20.00           C  
ATOM   3982  OD1 ASN D  40       8.960  19.941  -2.553  1.00 20.00           O  
ATOM   3983  ND2 ASN D  40      10.130  21.144  -3.924  1.00 20.00           N  
ATOM   3984  N   GLU D  41      13.053  23.307  -0.645  1.00 25.10           N  
ATOM   3985  CA  GLU D  41      13.488  24.118   0.484  0.50 25.59           C  
ATOM   3987  C   GLU D  41      12.447  24.163   1.581  1.00 25.47           C  
ATOM   3988  O   GLU D  41      11.310  24.310   1.270  1.00 25.65           O  
ATOM   3989  CB  GLU D  41      13.821  25.559   0.086  0.50 25.59           C  
ATOM   3991  CG  GLU D  41      14.948  25.720  -0.921  0.50 26.24           C  
ATOM   3993  CD  GLU D  41      14.966  27.102  -1.543  0.50 26.91           C  
ATOM   3995  OE1 GLU D  41      14.517  28.068  -0.882  0.50 29.27           O  
ATOM   3997  OE2 GLU D  41      15.417  27.227  -2.700  0.50 28.60           O  
ATOM   3999  N   VAL D  42      12.857  24.049   2.826  1.00 25.25           N  
ATOM   4000  CA  VAL D  42      11.996  24.183   3.997  1.00 25.37           C  
ATOM   4001  C   VAL D  42      12.659  25.218   4.895  1.00 25.26           C  
ATOM   4002  O   VAL D  42      13.839  25.098   5.195  1.00 25.29           O  
ATOM   4003  CB  VAL D  42      11.869  22.858   4.771  1.00 25.49           C  
ATOM   4004  CG1 VAL D  42      11.040  23.050   6.054  1.00 26.35           C  
ATOM   4005  CG2 VAL D  42      11.260  21.773   3.885  1.00 25.73           C  
ATOM   4006  N   SER D  43      11.905  26.230   5.319  1.00 25.62           N  
ATOM   4007  CA  SER D  43      12.464  27.297   6.154  1.00 25.73           C  
ATOM   4008  C   SER D  43      12.904  26.756   7.506  1.00 25.62           C  
ATOM   4009  O   SER D  43      12.350  25.779   8.008  1.00 24.76           O  
ATOM   4010  CB  SER D  43      11.446  28.422   6.355  1.00 25.89           C  
ATOM   4011  OG  SER D  43      10.378  28.020   7.200  1.00 25.97           O  
ATOM   4012  N   SER D  44      13.908  27.387   8.106  1.00 26.30           N  
ATOM   4013  CA  SER D  44      14.315  27.004   9.463  1.00 26.54           C  
ATOM   4014  C   SER D  44      13.142  27.110  10.431  1.00 26.42           C  
ATOM   4015  O   SER D  44      12.949  26.235  11.280  1.00 26.80           O  
ATOM   4016  CB  SER D  44      15.489  27.852   9.953  1.00 26.99           C  
ATOM   4017  OG  SER D  44      16.704  27.375   9.395  1.00 28.46           O  
ATOM   4018  N   ALA D  45      12.348  28.165  10.291  1.00 26.77           N  
ATOM   4019  CA  ALA D  45      11.171  28.350  11.139  1.00 26.82           C  
ATOM   4020  C   ALA D  45      10.221  27.154  11.047  1.00 26.98           C  
ATOM   4021  O   ALA D  45       9.775  26.632  12.073  1.00 26.75           O  
ATOM   4022  CB  ALA D  45      10.447  29.627  10.770  1.00 27.14           C  
ATOM   4023  N   ASP D  46       9.934  26.709   9.822  1.00 26.86           N  
ATOM   4024  CA  ASP D  46       9.042  25.557   9.607  1.00 27.06           C  
ATOM   4025  C   ASP D  46       9.662  24.257  10.123  1.00 26.88           C  
ATOM   4026  O   ASP D  46       8.969  23.419  10.686  1.00 26.29           O  
ATOM   4027  CB  ASP D  46       8.658  25.417   8.121  1.00 27.07           C  
ATOM   4028  CG  ASP D  46       7.644  26.476   7.666  1.00 28.77           C  
ATOM   4029  OD1 ASP D  46       7.009  27.124   8.521  1.00 28.38           O  
ATOM   4030  OD2 ASP D  46       7.482  26.667   6.443  1.00 29.70           O  
ATOM   4031  N   MET D  47      10.967  24.096   9.931  1.00 27.42           N  
ATOM   4032  CA  MET D  47      11.673  22.913  10.432  1.00 27.90           C  
ATOM   4033  C   MET D  47      11.568  22.822  11.953  1.00 27.64           C  
ATOM   4034  O   MET D  47      11.281  21.759  12.500  1.00 28.13           O  
ATOM   4035  CB  MET D  47      13.146  22.956  10.013  1.00 28.05           C  
ATOM   4036  CG  MET D  47      13.940  21.703  10.333  1.00 30.19           C  
ATOM   4037  SD  MET D  47      13.247  20.193   9.621  1.00 38.40           S  
ATOM   4038  CE  MET D  47      13.206  20.635   7.901  1.00 35.95           C  
ATOM   4039  N   VAL D  48      11.803  23.934  12.634  1.00 27.81           N  
ATOM   4040  CA  VAL D  48      11.754  23.944  14.095  1.00 27.98           C  
ATOM   4041  C   VAL D  48      10.342  23.618  14.592  1.00 27.69           C  
ATOM   4042  O   VAL D  48      10.185  22.886  15.563  1.00 27.61           O  
ATOM   4043  CB  VAL D  48      12.261  25.275  14.674  1.00 28.10           C  
ATOM   4044  CG1 VAL D  48      12.020  25.345  16.181  1.00 29.00           C  
ATOM   4045  CG2 VAL D  48      13.755  25.454  14.357  1.00 28.52           C  
ATOM   4046  N   LYS D  49       9.322  24.147  13.923  1.00 27.70           N  
ATOM   4047  CA  LYS D  49       7.931  23.819  14.265  1.00 28.05           C  
ATOM   4048  C   LYS D  49       7.646  22.320  14.149  1.00 27.83           C  
ATOM   4049  O   LYS D  49       6.949  21.751  14.991  1.00 27.40           O  
ATOM   4050  CB  LYS D  49       6.947  24.594  13.379  1.00 28.02           C  
ATOM   4051  CG  LYS D  49       6.795  26.039  13.759  1.00 28.93           C  
ATOM   4052  CD  LYS D  49       5.925  26.796  12.756  1.00 29.05           C  
ATOM   4053  CE  LYS D  49       5.960  28.288  13.010  0.50 29.20           C  
ATOM   4054  NZ  LYS D  49       5.264  29.044  11.937  0.50 29.40           N  
ATOM   4055  N   LEU D  50       8.176  21.694  13.102  1.00 28.07           N  
ATOM   4056  CA  LEU D  50       8.000  20.257  12.896  1.00 28.73           C  
ATOM   4057  C   LEU D  50       8.713  19.470  13.989  1.00 28.37           C  
ATOM   4058  O   LEU D  50       8.190  18.474  14.490  1.00 27.89           O  
ATOM   4059  CB  LEU D  50       8.540  19.825  11.530  1.00 29.08           C  
ATOM   4060  CG  LEU D  50       7.768  20.296  10.298  1.00 31.33           C  
ATOM   4061  CD1 LEU D  50       8.583  20.014   9.043  1.00 33.17           C  
ATOM   4062  CD2 LEU D  50       6.394  19.644  10.218  1.00 32.48           C  
ATOM   4063  N   MET D  51       9.904  19.921  14.363  1.00 28.73           N  
ATOM   4064  CA  MET D  51      10.671  19.261  15.424  1.00 29.20           C  
ATOM   4065  C   MET D  51       9.925  19.356  16.761  1.00 29.23           C  
ATOM   4066  O   MET D  51       9.762  18.349  17.458  1.00 29.49           O  
ATOM   4067  CB  MET D  51      12.074  19.873  15.532  1.00 29.12           C  
ATOM   4068  CG  MET D  51      12.968  19.635  14.304  1.00 29.64           C  
ATOM   4069  SD  MET D  51      14.360  20.787  14.220  1.00 31.26           S  
ATOM   4070  CE  MET D  51      15.337  20.266  15.627  1.00 33.36           C  
ATOM   4071  N   GLU D  52       9.462  20.562  17.092  1.00 29.27           N  
ATOM   4072  CA  GLU D  52       8.668  20.825  18.304  1.00 29.90           C  
ATOM   4073  C   GLU D  52       7.379  19.996  18.328  1.00 29.50           C  
ATOM   4074  O   GLU D  52       7.058  19.368  19.337  1.00 29.74           O  
ATOM   4075  CB  GLU D  52       8.342  22.324  18.419  1.00 29.97           C  
ATOM   4076  CG  GLU D  52       9.552  23.207  18.782  1.00 31.29           C  
ATOM   4077  CD  GLU D  52       9.278  24.710  18.682  1.00 32.76           C  
ATOM   4078  OE1 GLU D  52       8.299  25.124  18.010  1.00 37.22           O  
ATOM   4079  OE2 GLU D  52      10.053  25.496  19.279  1.00 37.09           O  
ATOM   4080  N   GLY D  53       6.655  19.985  17.209  1.00 29.41           N  
ATOM   4081  CA  GLY D  53       5.411  19.216  17.093  1.00 29.38           C  
ATOM   4082  C   GLY D  53       5.587  17.714  17.228  1.00 29.37           C  
ATOM   4083  O   GLY D  53       4.780  17.042  17.881  1.00 29.29           O  
ATOM   4084  N   GLY D  54       6.637  17.179  16.608  1.00 29.18           N  
ATOM   4085  CA  GLY D  54       6.972  15.760  16.731  1.00 29.43           C  
ATOM   4086  C   GLY D  54       7.282  15.369  18.160  1.00 29.09           C  
ATOM   4087  O   GLY D  54       6.819  14.342  18.656  1.00 28.83           O  
ATOM   4088  N   LEU D  55       8.057  16.211  18.827  1.00 29.39           N  
ATOM   4089  CA  LEU D  55       8.420  15.992  20.220  1.00 29.47           C  
ATOM   4090  C   LEU D  55       7.192  16.010  21.141  1.00 29.24           C  
ATOM   4091  O   LEU D  55       7.118  15.245  22.108  1.00 29.85           O  
ATOM   4092  CB  LEU D  55       9.440  17.052  20.646  1.00 29.75           C  
ATOM   4093  CG  LEU D  55      10.368  16.760  21.815  1.00 30.43           C  
ATOM   4094  CD1 LEU D  55      11.005  15.395  21.680  1.00 29.97           C  
ATOM   4095  CD2 LEU D  55      11.441  17.864  21.899  1.00 30.62           C  
ATOM   4096  N   LYS D  56       6.223  16.867  20.837  1.00 28.40           N  
ATOM   4097  CA  LYS D  56       4.982  16.916  21.611  1.00 27.84           C  
ATOM   4098  C   LYS D  56       4.138  15.658  21.418  1.00 27.33           C  
ATOM   4099  O   LYS D  56       3.553  15.144  22.371  1.00 27.46           O  
ATOM   4100  CB  LYS D  56       4.165  18.159  21.249  1.00 27.89           C  
ATOM   4101  CG  LYS D  56       4.774  19.452  21.761  0.50 27.88           C  
ATOM   4102  CD  LYS D  56       3.980  20.678  21.326  0.50 28.29           C  
ATOM   4103  CE  LYS D  56       4.776  21.960  21.549  0.50 28.00           C  
ATOM   4104  NZ  LYS D  56       3.945  23.184  21.348  0.50 28.37           N  
ATOM   4105  N   ALA D  57       4.070  15.176  20.183  1.00 26.70           N  
ATOM   4106  CA  ALA D  57       3.267  14.002  19.841  1.00 26.32           C  
ATOM   4107  C   ALA D  57       3.902  12.701  20.351  1.00 25.85           C  
ATOM   4108  O   ALA D  57       3.193  11.776  20.759  1.00 25.62           O  
ATOM   4109  CB  ALA D  57       3.070  13.939  18.335  1.00 26.27           C  
ATOM   4110  N   PHE D  58       5.235  12.666  20.350  1.00 25.42           N  
ATOM   4111  CA  PHE D  58       6.023  11.464  20.647  1.00 25.64           C  
ATOM   4112  C   PHE D  58       7.118  11.832  21.663  1.00 25.50           C  
ATOM   4113  O   PHE D  58       8.304  11.846  21.333  1.00 25.59           O  
ATOM   4114  CB  PHE D  58       6.621  10.932  19.341  1.00 25.39           C  
ATOM   4115  CG  PHE D  58       5.585  10.679  18.282  1.00 25.20           C  
ATOM   4116  CD1 PHE D  58       4.665   9.646  18.439  1.00 25.33           C  
ATOM   4117  CD2 PHE D  58       5.482  11.505  17.173  1.00 25.47           C  
ATOM   4118  CE1 PHE D  58       3.670   9.421  17.487  1.00 25.45           C  
ATOM   4119  CE2 PHE D  58       4.497  11.284  16.216  1.00 25.51           C  
ATOM   4120  CZ  PHE D  58       3.588  10.243  16.377  1.00 25.29           C  
ATOM   4121  N   PRO D  59       6.707  12.146  22.905  1.00 25.60           N  
ATOM   4122  CA  PRO D  59       7.612  12.752  23.879  1.00 25.47           C  
ATOM   4123  C   PRO D  59       8.747  11.840  24.358  1.00 25.56           C  
ATOM   4124  O   PRO D  59       9.739  12.342  24.882  1.00 25.90           O  
ATOM   4125  CB  PRO D  59       6.683  13.141  25.034  1.00 25.85           C  
ATOM   4126  CG  PRO D  59       5.504  12.229  24.904  1.00 26.32           C  
ATOM   4127  CD  PRO D  59       5.347  11.965  23.443  1.00 25.73           C  
ATOM   4128  N   ASP D  60       8.605  10.527  24.171  1.00 24.74           N  
ATOM   4129  CA  ASP D  60       9.637   9.563  24.586  1.00 24.71           C  
ATOM   4130  C   ASP D  60      10.419   9.023  23.405  1.00 24.48           C  
ATOM   4131  O   ASP D  60      11.080   7.985  23.525  1.00 25.09           O  
ATOM   4132  CB  ASP D  60       9.002   8.394  25.355  1.00 24.66           C  
ATOM   4133  CG  ASP D  60       8.046   7.570  24.504  1.00 25.07           C  
ATOM   4134  OD1 ASP D  60       7.709   7.993  23.366  1.00 24.83           O  
ATOM   4135  OD2 ASP D  60       7.629   6.484  24.980  1.00 26.93           O  
ATOM   4136  N   LEU D  61      10.369   9.714  22.267  1.00 24.63           N  
ATOM   4137  CA  LEU D  61      10.994   9.192  21.066  1.00 24.66           C  
ATOM   4138  C   LEU D  61      12.478   8.898  21.280  1.00 24.79           C  
ATOM   4139  O   LEU D  61      13.162   9.597  22.039  1.00 23.93           O  
ATOM   4140  CB  LEU D  61      10.786  10.116  19.873  1.00 25.12           C  
ATOM   4141  CG  LEU D  61      11.405  11.515  19.875  1.00 25.13           C  
ATOM   4142  CD1 LEU D  61      12.831  11.502  19.341  1.00 26.76           C  
ATOM   4143  CD2 LEU D  61      10.556  12.444  19.022  1.00 25.71           C  
ATOM   4144  N   GLN D  62      12.952   7.839  20.634  1.00 24.49           N  
ATOM   4145  CA  GLN D  62      14.364   7.465  20.669  1.00 24.96           C  
ATOM   4146  C   GLN D  62      14.840   7.130  19.263  1.00 25.52           C  
ATOM   4147  O   GLN D  62      14.140   6.430  18.512  1.00 25.28           O  
ATOM   4148  CB  GLN D  62      14.588   6.256  21.574  1.00 25.14           C  
ATOM   4149  CG  GLN D  62      14.273   6.501  23.024  1.00 25.00           C  
ATOM   4150  CD  GLN D  62      15.361   7.276  23.729  1.00 26.37           C  
ATOM   4151  OE1 GLN D  62      16.334   6.688  24.207  1.00 27.03           O  
ATOM   4152  NE2 GLN D  62      15.204   8.601  23.805  1.00 24.37           N  
ATOM   4153  N   LEU D  63      16.024   7.633  18.923  1.00 25.12           N  
ATOM   4154  CA  LEU D  63      16.663   7.414  17.621  1.00 25.86           C  
ATOM   4155  C   LEU D  63      17.724   6.330  17.747  1.00 26.28           C  
ATOM   4156  O   LEU D  63      18.580   6.399  18.627  1.00 25.43           O  
ATOM   4157  CB  LEU D  63      17.351   8.692  17.140  1.00 25.95           C  
ATOM   4158  CG  LEU D  63      16.496   9.805  16.518  1.00 27.12           C  
ATOM   4159  CD1 LEU D  63      15.420  10.270  17.462  1.00 27.79           C  
ATOM   4160  CD2 LEU D  63      17.380  10.965  16.110  1.00 27.00           C  
ATOM   4161  N   GLU D  64      17.645   5.324  16.888  1.00 26.29           N  
ATOM   4162  CA  GLU D  64      18.692   4.324  16.760  1.00 26.81           C  
ATOM   4163  C   GLU D  64      19.393   4.529  15.426  1.00 26.71           C  
ATOM   4164  O   GLU D  64      18.762   4.444  14.367  1.00 26.09           O  
ATOM   4165  CB  GLU D  64      18.110   2.910  16.822  1.00 27.06           C  
ATOM   4166  CG  GLU D  64      19.193   1.844  16.824  1.00 27.81           C  
ATOM   4167  CD  GLU D  64      18.673   0.432  16.692  1.00 30.44           C  
ATOM   4168  OE1 GLU D  64      17.442   0.219  16.733  1.00 35.34           O  
ATOM   4169  OE2 GLU D  64      19.519  -0.478  16.532  1.00 35.58           O  
ATOM   4170  N   VAL D  65      20.680   4.791  15.467  1.00 26.14           N  
ATOM   4171  CA  VAL D  65      21.441   4.927  14.262  1.00 26.21           C  
ATOM   4172  C   VAL D  65      21.776   3.555  13.701  1.00 26.02           C  
ATOM   4173  O   VAL D  65      22.497   2.837  14.297  1.00 25.16           O  
ATOM   4174  CB  VAL D  65      22.721   5.756  14.462  1.00 26.21           C  
ATOM   4175  CG1 VAL D  65      23.473   5.910  13.172  1.00 26.38           C  
ATOM   4176  CG2 VAL D  65      22.372   7.077  15.053  1.00 26.32           C  
ATOM   4177  N   LYS D  66      21.192   3.214  12.570  1.00 20.00           N  
ATOM   4178  CA  LYS D  66      21.469   1.959  11.925  1.00 20.00           C  
ATOM   4179  C   LYS D  66      22.746   1.966  11.104  1.00 20.00           C  
ATOM   4180  O   LYS D  66      23.383   0.978  10.982  1.00 26.12           O  
ATOM   4181  CB  LYS D  66      20.321   1.482  11.036  1.00 20.00           C  
ATOM   4182  CG  LYS D  66      18.980   1.487  11.669  1.00 20.00           C  
ATOM   4183  CD  LYS D  66      18.868   0.600  12.850  1.00 20.00           C  
ATOM   4184  CE  LYS D  66      18.804  -0.813  12.496  1.00 20.00           C  
ATOM   4185  NZ  LYS D  66      18.514  -1.686  13.655  1.00 20.00           N  
ATOM   4186  N   SER D  67      23.053   3.106  10.515  1.00 26.46           N  
ATOM   4187  CA  SER D  67      24.291   3.280   9.825  1.00 26.77           C  
ATOM   4188  C   SER D  67      24.696   4.732   9.745  1.00 26.40           C  
ATOM   4189  O   SER D  67      23.884   5.580   9.788  1.00 25.86           O  
ATOM   4190  CB  SER D  67      24.238   2.671   8.447  1.00 27.30           C  
ATOM   4191  OG  SER D  67      23.554   3.461   7.547  1.00 29.67           O  
ATOM   4192  N   ILE D  68      25.984   4.947   9.647  1.00 26.68           N  
ATOM   4193  CA  ILE D  68      26.509   6.291   9.501  1.00 26.79           C  
ATOM   4194  C   ILE D  68      27.632   6.223   8.477  1.00 27.49           C  
ATOM   4195  O   ILE D  68      28.410   5.256   8.441  1.00 27.68           O  
ATOM   4196  CB  ILE D  68      26.932   6.913  10.865  1.00 26.96           C  
ATOM   4197  CG1 ILE D  68      27.384   8.369  10.690  1.00 26.59           C  
ATOM   4198  CG2 ILE D  68      27.982   6.051  11.580  1.00 28.13           C  
ATOM   4199  CD1 ILE D  68      27.432   9.136  11.985  1.00 28.00           C  
ATOM   4200  N   MET D  69      27.660   7.209   7.592  1.00 26.89           N  
ATOM   4201  CA  MET D  69      28.638   7.250   6.519  1.00 27.43           C  
ATOM   4202  C   MET D  69      29.085   8.689   6.360  1.00 26.69           C  
ATOM   4203  O   MET D  69      28.276   9.607   6.543  1.00 25.68           O  
ATOM   4204  CB  MET D  69      27.987   6.755   5.221  1.00 27.70           C  
ATOM   4205  CG  MET D  69      28.900   6.721   4.027  1.00 29.26           C  
ATOM   4206  SD  MET D  69      28.034   6.193   2.531  1.00 34.21           S  
ATOM   4207  CE  MET D  69      27.538   4.565   3.021  1.00 32.20           C  
ATOM   4208  N   ALA D  70      30.359   8.881   6.036  1.00 25.71           N  
ATOM   4209  CA  ALA D  70      30.894  10.209   5.764  1.00 25.95           C  
ATOM   4210  C   ALA D  70      31.818  10.200   4.552  1.00 26.21           C  
ATOM   4211  O   ALA D  70      32.558   9.233   4.338  1.00 25.85           O  
ATOM   4212  CB  ALA D  70      31.627  10.733   6.974  1.00 26.01           C  
ATOM   4213  N   GLU D  71      31.745  11.272   3.767  1.00 26.45           N  
ATOM   4214  CA  GLU D  71      32.627  11.502   2.620  1.00 26.52           C  
ATOM   4215  C   GLU D  71      32.704  12.998   2.373  1.00 26.15           C  
ATOM   4216  O   GLU D  71      31.701  13.713   2.506  1.00 25.13           O  
ATOM   4217  CB  GLU D  71      32.143  10.773   1.359  1.00 26.71           C  
ATOM   4218  CG  GLU D  71      33.160  10.788   0.220  1.00 27.69           C  
ATOM   4219  CD  GLU D  71      32.724   9.984  -1.002  1.00 28.81           C  
ATOM   4220  OE1 GLU D  71      31.543   9.656  -1.099  1.00 29.40           O  
ATOM   4221  OE2 GLU D  71      33.581   9.662  -1.855  1.00 34.62           O  
ATOM   4222  N   GLU D  72      33.897  13.466   2.015  1.00 26.04           N  
ATOM   4223  CA  GLU D  72      34.216  14.890   1.919  0.50 26.44           C  
ATOM   4225  C   GLU D  72      33.596  15.652   3.095  1.00 26.29           C  
ATOM   4226  O   GLU D  72      33.936  15.319   4.235  1.00 26.32           O  
ATOM   4227  CB  GLU D  72      33.879  15.444   0.534  0.50 26.81           C  
ATOM   4229  CG  GLU D  72      34.787  14.865  -0.569  0.50 28.19           C  
ATOM   4231  CD  GLU D  72      36.278  15.116  -0.317  0.50 30.62           C  
ATOM   4233  OE1 GLU D  72      37.095  14.185  -0.525  0.50 31.94           O  
ATOM   4235  OE2 GLU D  72      36.635  16.246   0.090  0.50 32.80           O  
ATOM   4237  N   ASP D  73      32.729  16.641   2.869  1.00 25.89           N  
ATOM   4238  CA  ASP D  73      32.179  17.471   3.952  1.00 26.06           C  
ATOM   4239  C   ASP D  73      30.784  17.036   4.404  1.00 25.75           C  
ATOM   4240  O   ASP D  73      30.106  17.778   5.121  1.00 25.76           O  
ATOM   4241  CB  ASP D  73      32.170  18.955   3.534  1.00 26.60           C  
ATOM   4242  CG  ASP D  73      31.496  19.207   2.176  1.00 27.47           C  
ATOM   4243  OD1 ASP D  73      31.041  18.248   1.515  1.00 27.84           O  
ATOM   4244  OD2 ASP D  73      31.433  20.392   1.757  1.00 29.68           O  
ATOM   4245  N   ARG D  74      30.372  15.828   4.007  1.00 25.27           N  
ATOM   4246  CA  ARG D  74      29.027  15.342   4.293  0.50 25.27           C  
ATOM   4248  C   ARG D  74      29.022  14.124   5.211  1.00 25.17           C  
ATOM   4249  O   ARG D  74      29.992  13.360   5.265  1.00 25.01           O  
ATOM   4250  CB  ARG D  74      28.294  15.015   2.993  0.50 25.14           C  
ATOM   4252  CG  ARG D  74      27.927  16.246   2.173  0.50 25.57           C  
ATOM   4254  CD  ARG D  74      27.337  15.879   0.821  0.50 26.21           C  
ATOM   4256  NE  ARG D  74      28.301  15.185  -0.026  0.50 26.36           N  
ATOM   4258  CZ  ARG D  74      28.124  13.994  -0.605  0.50 27.15           C  
ATOM   4260  NH1 ARG D  74      26.999  13.297  -0.468  0.50 27.41           N  
ATOM   4262  NH2 ARG D  74      29.098  13.496  -1.347  0.50 27.75           N  
ATOM   4264  N   VAL D  75      27.905  13.955   5.918  1.00 24.86           N  
ATOM   4265  CA  VAL D  75      27.650  12.790   6.751  1.00 25.02           C  
ATOM   4266  C   VAL D  75      26.200  12.402   6.509  1.00 25.11           C  
ATOM   4267  O   VAL D  75      25.334  13.283   6.407  1.00 25.22           O  
ATOM   4268  CB  VAL D  75      27.838  13.095   8.240  1.00 24.96           C  
ATOM   4269  CG1 VAL D  75      27.588  11.848   9.082  1.00 25.25           C  
ATOM   4270  CG2 VAL D  75      29.237  13.661   8.498  1.00 25.91           C  
ATOM   4271  N   ALA D  76      25.945  11.104   6.394  1.00 25.08           N  
ATOM   4272  CA  ALA D  76      24.583  10.586   6.278  1.00 24.99           C  
ATOM   4273  C   ALA D  76      24.331   9.543   7.352  1.00 25.27           C  
ATOM   4274  O   ALA D  76      25.193   8.695   7.622  1.00 25.18           O  
ATOM   4275  CB  ALA D  76      24.352   9.983   4.902  1.00 25.07           C  
ATOM   4276  N   LEU D  77      23.146   9.603   7.946  1.00 25.59           N  
ATOM   4277  CA  LEU D  77      22.738   8.675   8.992  1.00 25.69           C  
ATOM   4278  C   LEU D  77      21.407   8.045   8.631  1.00 25.59           C  
ATOM   4279  O   LEU D  77      20.442   8.753   8.327  1.00 26.00           O  
ATOM   4280  CB  LEU D  77      22.575   9.395  10.331  1.00 26.13           C  
ATOM   4281  CG  LEU D  77      23.779  10.180  10.860  1.00 27.21           C  
ATOM   4282  CD1 LEU D  77      23.779  11.618  10.361  1.00 29.39           C  
ATOM   4283  CD2 LEU D  77      23.771  10.152  12.363  1.00 26.99           C  
ATOM   4284  N   ARG D  78      21.367   6.722   8.672  1.00 25.26           N  
ATOM   4285  CA  ARG D  78      20.120   5.967   8.561  1.00 25.28           C  
ATOM   4286  C   ARG D  78      19.664   5.624   9.971  1.00 25.20           C  
ATOM   4287  O   ARG D  78      20.382   4.956  10.720  1.00 24.91           O  
ATOM   4288  CB  ARG D  78      20.310   4.700   7.739  1.00 25.13           C  
ATOM   4289  CG  ARG D  78      19.046   3.856   7.615  1.00 24.89           C  
ATOM   4290  CD  ARG D  78      19.134   2.823   6.485  1.00 26.04           C  
ATOM   4291  NE  ARG D  78      20.320   1.960   6.592  1.00 26.18           N  
ATOM   4292  CZ  ARG D  78      20.412   0.860   7.333  1.00 26.94           C  
ATOM   4293  NH1 ARG D  78      19.397   0.421   8.063  1.00 26.00           N  
ATOM   4294  NH2 ARG D  78      21.548   0.176   7.334  1.00 29.00           N  
ATOM   4295  N   ILE D  79      18.457   6.082  10.309  1.00 25.65           N  
ATOM   4296  CA  ILE D  79      17.957   6.093  11.670  1.00 25.86           C  
ATOM   4297  C   ILE D  79      16.568   5.464  11.754  1.00 25.94           C  
ATOM   4298  O   ILE D  79      15.723   5.679  10.877  1.00 25.54           O  
ATOM   4299  CB  ILE D  79      17.908   7.553  12.155  1.00 25.91           C  
ATOM   4300  CG1 ILE D  79      19.337   8.083  12.327  1.00 26.22           C  
ATOM   4301  CG2 ILE D  79      17.084   7.720  13.445  1.00 26.65           C  
ATOM   4302  CD1 ILE D  79      19.418   9.589  12.415  1.00 26.61           C  
ATOM   4303  N   THR D  80      16.341   4.686  12.807  1.00 25.58           N  
ATOM   4304  CA  THR D  80      15.008   4.195  13.127  1.00 25.59           C  
ATOM   4305  C   THR D  80      14.549   4.906  14.394  1.00 25.45           C  
ATOM   4306  O   THR D  80      15.285   4.948  15.394  1.00 25.40           O  
ATOM   4307  CB  THR D  80      15.015   2.675  13.321  1.00 25.46           C  
ATOM   4308  OG1 THR D  80      15.408   2.052  12.091  1.00 27.65           O  
ATOM   4309  CG2 THR D  80      13.640   2.150  13.745  1.00 26.02           C  
ATOM   4310  N   VAL D  81      13.355   5.491  14.337  1.00 24.70           N  
ATOM   4311  CA  VAL D  81      12.757   6.144  15.488  1.00 24.98           C  
ATOM   4312  C   VAL D  81      11.688   5.234  16.092  1.00 24.64           C  
ATOM   4313  O   VAL D  81      10.888   4.638  15.368  1.00 24.26           O  
ATOM   4314  CB  VAL D  81      12.110   7.496  15.113  1.00 25.27           C  
ATOM   4315  CG1 VAL D  81      11.583   8.190  16.374  1.00 26.08           C  
ATOM   4316  CG2 VAL D  81      13.122   8.409  14.373  1.00 26.38           C  
ATOM   4317  N   THR D  82      11.702   5.109  17.416  1.00 24.44           N  
ATOM   4318  CA  THR D  82      10.646   4.419  18.139  1.00 24.61           C  
ATOM   4319  C   THR D  82      10.123   5.337  19.236  1.00 24.32           C  
ATOM   4320  O   THR D  82      10.875   6.135  19.810  1.00 23.48           O  
ATOM   4321  CB  THR D  82      11.117   3.071  18.715  1.00 24.98           C  
ATOM   4322  OG1 THR D  82      12.251   3.267  19.570  1.00 26.96           O  
ATOM   4323  CG2 THR D  82      11.495   2.122  17.586  1.00 25.57           C  
ATOM   4324  N   ALA D  83       8.825   5.246  19.493  1.00 24.08           N  
ATOM   4325  CA  ALA D  83       8.167   6.139  20.433  1.00 24.30           C  
ATOM   4326  C   ALA D  83       6.794   5.623  20.817  1.00 24.28           C  
ATOM   4327  O   ALA D  83       6.308   4.640  20.260  1.00 23.98           O  
ATOM   4328  CB  ALA D  83       8.035   7.517  19.828  1.00 24.31           C  
ATOM   4329  N   THR D  84       6.172   6.322  21.764  1.00 24.61           N  
ATOM   4330  CA  THR D  84       4.787   6.090  22.127  1.00 24.66           C  
ATOM   4331  C   THR D  84       3.976   7.303  21.655  1.00 24.76           C  
ATOM   4332  O   THR D  84       4.404   8.443  21.822  1.00 23.85           O  
ATOM   4333  CB  THR D  84       4.628   5.940  23.648  1.00 24.95           C  
ATOM   4334  OG1 THR D  84       5.565   4.970  24.131  1.00 25.84           O  
ATOM   4335  CG2 THR D  84       3.217   5.503  24.010  1.00 24.96           C  
ATOM   4336  N   HIS D  85       2.817   7.040  21.060  1.00 24.88           N  
ATOM   4337  CA  HIS D  85       1.907   8.100  20.624  1.00 25.36           C  
ATOM   4338  C   HIS D  85       1.137   8.658  21.827  1.00 25.59           C  
ATOM   4339  O   HIS D  85       0.132   8.085  22.253  1.00 25.13           O  
ATOM   4340  CB  HIS D  85       0.957   7.558  19.548  1.00 25.30           C  
ATOM   4341  CG  HIS D  85       0.066   8.599  18.949  1.00 25.23           C  
ATOM   4342  ND1 HIS D  85      -1.187   8.311  18.456  1.00 25.63           N  
ATOM   4343  CD2 HIS D  85       0.244   9.929  18.771  1.00 25.42           C  
ATOM   4344  CE1 HIS D  85      -1.740   9.418  17.992  1.00 25.77           C  
ATOM   4345  NE2 HIS D  85      -0.892  10.414  18.171  1.00 25.74           N  
ATOM   4346  N   GLN D  86       1.628   9.771  22.375  1.00 26.08           N  
ATOM   4347  CA  GLN D  86       1.054  10.384  23.574  1.00 27.21           C  
ATOM   4348  C   GLN D  86       0.433  11.760  23.351  1.00 27.44           C  
ATOM   4349  O   GLN D  86      -0.297  12.245  24.219  1.00 27.13           O  
ATOM   4350  CB  GLN D  86       2.110  10.474  24.678  1.00 27.27           C  
ATOM   4351  CG  GLN D  86       2.718   9.117  25.014  1.00 28.63           C  
ATOM   4352  CD  GLN D  86       3.369   9.046  26.385  1.00 29.74           C  
ATOM   4353  OE1 GLN D  86       3.492  10.050  27.095  1.00 33.48           O  
ATOM   4354  NE2 GLN D  86       3.797   7.845  26.764  1.00 32.05           N  
ATOM   4355  N   GLY D  87       0.703  12.385  22.208  1.00 27.81           N  
ATOM   4356  CA  GLY D  87       0.047  13.647  21.852  1.00 28.60           C  
ATOM   4357  C   GLY D  87      -0.601  13.579  20.480  1.00 29.01           C  
ATOM   4358  O   GLY D  87      -0.209  12.761  19.640  1.00 28.75           O  
ATOM   4359  N   GLU D  88      -1.596  14.440  20.256  1.00 29.55           N  
ATOM   4360  CA  GLU D  88      -2.280  14.491  18.973  0.50 29.81           C  
ATOM   4362  C   GLU D  88      -1.259  14.631  17.845  1.00 29.91           C  
ATOM   4363  O   GLU D  88      -0.312  15.402  17.948  1.00 30.23           O  
ATOM   4364  CB  GLU D  88      -3.278  15.654  18.941  0.50 29.82           C  
ATOM   4366  CG  GLU D  88      -4.210  15.651  17.732  0.50 30.03           C  
ATOM   4368  CD  GLU D  88      -5.246  16.764  17.779  0.50 30.46           C  
ATOM   4370  OE1 GLU D  88      -5.749  17.077  18.879  0.50 32.02           O  
ATOM   4372  OE2 GLU D  88      -5.564  17.328  16.711  0.50 32.17           O  
ATOM   4374  N   PHE D  89      -1.456  13.867  16.777  1.00 30.20           N  
ATOM   4375  CA  PHE D  89      -0.584  13.948  15.603  1.00 30.58           C  
ATOM   4376  C   PHE D  89      -1.383  13.685  14.342  1.00 30.91           C  
ATOM   4377  O   PHE D  89      -2.075  12.674  14.243  1.00 30.74           O  
ATOM   4378  CB  PHE D  89       0.563  12.949  15.697  1.00 30.53           C  
ATOM   4379  CG  PHE D  89       1.671  13.211  14.718  1.00 30.39           C  
ATOM   4380  CD1 PHE D  89       2.504  14.314  14.874  1.00 30.59           C  
ATOM   4381  CD2 PHE D  89       1.889  12.357  13.645  1.00 30.65           C  
ATOM   4382  CE1 PHE D  89       3.540  14.558  13.982  1.00 30.81           C  
ATOM   4383  CE2 PHE D  89       2.922  12.597  12.744  1.00 30.36           C  
ATOM   4384  CZ  PHE D  89       3.743  13.701  12.912  1.00 30.56           C  
ATOM   4385  N   MET D  90      -1.273  14.604  13.385  1.00 31.71           N  
ATOM   4386  CA  MET D  90      -2.043  14.555  12.138  1.00 32.43           C  
ATOM   4387  C   MET D  90      -3.537  14.385  12.383  1.00 32.17           C  
ATOM   4388  O   MET D  90      -4.219  13.640  11.674  1.00 32.42           O  
ATOM   4389  CB  MET D  90      -1.510  13.444  11.235  1.00 32.66           C  
ATOM   4390  CG  MET D  90      -0.107  13.697  10.770  1.00 33.67           C  
ATOM   4391  SD  MET D  90       0.520  12.334   9.790  1.00 36.29           S  
ATOM   4392  CE  MET D  90      -0.638  12.358   8.420  1.00 36.38           C  
ATOM   4393  N   GLY D  91      -4.041  15.084  13.397  1.00 31.98           N  
ATOM   4394  CA  GLY D  91      -5.455  15.051  13.744  1.00 31.58           C  
ATOM   4395  C   GLY D  91      -5.919  13.793  14.458  1.00 31.39           C  
ATOM   4396  O   GLY D  91      -7.106  13.657  14.752  1.00 31.23           O  
ATOM   4397  N   VAL D  92      -4.995  12.874  14.744  1.00 30.99           N  
ATOM   4398  CA  VAL D  92      -5.327  11.620  15.415  1.00 30.88           C  
ATOM   4399  C   VAL D  92      -5.015  11.748  16.897  1.00 30.74           C  
ATOM   4400  O   VAL D  92      -3.878  12.021  17.268  1.00 30.68           O  
ATOM   4401  CB  VAL D  92      -4.528  10.434  14.832  1.00 30.68           C  
ATOM   4402  CG1 VAL D  92      -4.946   9.127  15.490  1.00 30.78           C  
ATOM   4403  CG2 VAL D  92      -4.716  10.365  13.324  1.00 30.80           C  
ATOM   4404  N   GLN D  93      -6.025  11.537  17.736  1.00 30.76           N  
ATOM   4405  CA  GLN D  93      -5.856  11.619  19.183  1.00 30.79           C  
ATOM   4406  C   GLN D  93      -4.914  10.523  19.672  1.00 30.40           C  
ATOM   4407  O   GLN D  93      -4.858   9.446  19.085  1.00 29.89           O  
ATOM   4408  CB  GLN D  93      -7.204  11.516  19.901  1.00 31.10           C  
ATOM   4409  CG  GLN D  93      -8.147  12.690  19.637  1.00 32.48           C  
ATOM   4410  CD  GLN D  93      -7.557  14.026  20.061  1.00 34.26           C  
ATOM   4411  OE1 GLN D  93      -7.024  14.164  21.165  1.00 35.30           O  
ATOM   4412  NE2 GLN D  93      -7.645  15.017  19.182  1.00 36.12           N  
ATOM   4413  N   PRO D  94      -4.157  10.803  20.746  1.00 30.40           N  
ATOM   4414  CA  PRO D  94      -3.167   9.823  21.195  1.00 30.53           C  
ATOM   4415  C   PRO D  94      -3.795   8.494  21.598  1.00 30.31           C  
ATOM   4416  O   PRO D  94      -4.849   8.465  22.226  1.00 30.27           O  
ATOM   4417  CB  PRO D  94      -2.485  10.513  22.380  1.00 30.49           C  
ATOM   4418  CG  PRO D  94      -3.376  11.614  22.781  1.00 30.68           C  
ATOM   4419  CD  PRO D  94      -4.156  12.018  21.576  1.00 30.44           C  
ATOM   4420  N   THR D  95      -3.150   7.409  21.189  1.00 30.35           N  
ATOM   4421  CA  THR D  95      -3.627   6.054  21.434  1.00 30.67           C  
ATOM   4422  C   THR D  95      -2.825   5.368  22.531  1.00 30.58           C  
ATOM   4423  O   THR D  95      -3.269   4.373  23.102  1.00 30.89           O  
ATOM   4424  CB  THR D  95      -3.495   5.205  20.157  1.00 31.01           C  
ATOM   4425  OG1 THR D  95      -2.137   5.215  19.718  1.00 32.24           O  
ATOM   4426  CG2 THR D  95      -4.350   5.767  19.048  1.00 31.58           C  
ATOM   4427  N   GLY D  96      -1.635   5.897  22.816  1.00 30.28           N  
ATOM   4428  CA  GLY D  96      -0.690   5.242  23.703  1.00 29.95           C  
ATOM   4429  C   GLY D  96       0.012   4.068  23.042  1.00 29.76           C  
ATOM   4430  O   GLY D  96       0.716   3.315  23.718  1.00 30.43           O  
ATOM   4431  N   GLN D  97      -0.171   3.909  21.728  1.00 29.05           N  
ATOM   4432  CA  GLN D  97       0.460   2.827  20.970  1.00 28.98           C  
ATOM   4433  C   GLN D  97       1.941   3.097  20.791  1.00 27.74           C  
ATOM   4434  O   GLN D  97       2.342   4.246  20.643  1.00 26.89           O  
ATOM   4435  CB  GLN D  97      -0.102   2.749  19.548  1.00 29.27           C  
ATOM   4436  CG  GLN D  97      -1.408   2.050  19.350  1.00 31.10           C  
ATOM   4437  CD  GLN D  97      -1.768   1.991  17.866  1.00 31.56           C  
ATOM   4438  OE1 GLN D  97      -2.017   0.917  17.318  1.00 35.86           O  
ATOM   4439  NE2 GLN D  97      -1.763   3.152  17.204  1.00 34.17           N  
ATOM   4440  N   ARG D  98       2.740   2.035  20.758  1.00 26.87           N  
ATOM   4441  CA  ARG D  98       4.116   2.146  20.285  1.00 26.81           C  
ATOM   4442  C   ARG D  98       4.100   2.357  18.773  1.00 26.39           C  
ATOM   4443  O   ARG D  98       3.314   1.736  18.066  1.00 26.03           O  
ATOM   4444  CB  ARG D  98       4.926   0.891  20.633  1.00 26.87           C  
ATOM   4445  CG  ARG D  98       5.130   0.672  22.118  1.00 27.25           C  
ATOM   4446  CD  ARG D  98       6.020   1.754  22.730  1.00 28.59           C  
ATOM   4447  NE  ARG D  98       7.412   1.605  22.321  1.00 28.85           N  
ATOM   4448  CZ  ARG D  98       8.370   2.512  22.511  1.00 29.39           C  
ATOM   4449  NH1 ARG D  98       8.110   3.674  23.096  1.00 29.49           N  
ATOM   4450  NH2 ARG D  98       9.603   2.250  22.112  1.00 29.54           N  
ATOM   4451  N   VAL D  99       4.969   3.236  18.283  1.00 25.71           N  
ATOM   4452  CA  VAL D  99       5.072   3.503  16.858  1.00 25.71           C  
ATOM   4453  C   VAL D  99       6.537   3.511  16.462  1.00 25.60           C  
ATOM   4454  O   VAL D  99       7.431   3.546  17.316  1.00 24.61           O  
ATOM   4455  CB  VAL D  99       4.428   4.854  16.462  1.00 25.64           C  
ATOM   4456  CG1 VAL D  99       2.938   4.868  16.813  1.00 26.38           C  
ATOM   4457  CG2 VAL D  99       5.156   6.032  17.118  1.00 26.67           C  
ATOM   4458  N   SER D 100       6.775   3.470  15.158  1.00 25.55           N  
ATOM   4459  CA  SER D 100       8.119   3.550  14.640  1.00 25.48           C  
ATOM   4460  C   SER D 100       8.101   4.191  13.268  1.00 25.52           C  
ATOM   4461  O   SER D 100       7.085   4.169  12.560  1.00 25.42           O  
ATOM   4462  CB  SER D 100       8.744   2.161  14.551  1.00 25.89           C  
ATOM   4463  OG  SER D 100       8.048   1.353  13.609  1.00 26.43           O  
ATOM   4464  N   TRP D 101       9.229   4.768  12.895  1.00 25.22           N  
ATOM   4465  CA  TRP D 101       9.434   5.185  11.519  1.00 25.15           C  
ATOM   4466  C   TRP D 101      10.924   5.214  11.194  1.00 24.94           C  
ATOM   4467  O   TRP D 101      11.764   4.926  12.050  1.00 23.93           O  
ATOM   4468  CB  TRP D 101       8.721   6.513  11.219  1.00 25.91           C  
ATOM   4469  CG  TRP D 101       9.229   7.732  11.898  1.00 26.42           C  
ATOM   4470  CD1 TRP D 101      10.149   8.612  11.418  1.00 27.74           C  
ATOM   4471  CD2 TRP D 101       8.810   8.243  13.168  1.00 27.41           C  
ATOM   4472  NE1 TRP D 101      10.340   9.634  12.308  1.00 27.81           N  
ATOM   4473  CE2 TRP D 101       9.525   9.436  13.392  1.00 27.80           C  
ATOM   4474  CE3 TRP D 101       7.890   7.809  14.134  1.00 27.71           C  
ATOM   4475  CZ2 TRP D 101       9.359  10.209  14.554  1.00 28.25           C  
ATOM   4476  CZ3 TRP D 101       7.730   8.569  15.292  1.00 27.97           C  
ATOM   4477  CH2 TRP D 101       8.460   9.762  15.486  1.00 27.72           C  
ATOM   4478  N   HIS D 102      11.246   5.529   9.947  1.00 24.36           N  
ATOM   4479  CA  HIS D 102      12.609   5.362   9.463  1.00 24.72           C  
ATOM   4480  C   HIS D 102      12.968   6.561   8.630  1.00 25.05           C  
ATOM   4481  O   HIS D 102      12.118   7.119   7.934  1.00 25.17           O  
ATOM   4482  CB  HIS D 102      12.717   4.088   8.620  1.00 24.83           C  
ATOM   4483  CG  HIS D 102      12.179   2.868   9.297  1.00 24.34           C  
ATOM   4484  ND1 HIS D 102      12.946   2.080  10.128  1.00 24.42           N  
ATOM   4485  CD2 HIS D 102      10.947   2.303   9.272  1.00 25.67           C  
ATOM   4486  CE1 HIS D 102      12.206   1.087  10.591  1.00 26.36           C  
ATOM   4487  NE2 HIS D 102      10.991   1.196  10.084  1.00 26.16           N  
ATOM   4488  N   LEU D 103      14.223   6.972   8.694  1.00 24.80           N  
ATOM   4489  CA  LEU D 103      14.665   8.115   7.908  0.50 25.04           C  
ATOM   4491  C   LEU D 103      16.156   8.081   7.640  1.00 25.09           C  
ATOM   4492  O   LEU D 103      16.899   7.361   8.297  1.00 24.17           O  
ATOM   4493  CB  LEU D 103      14.293   9.426   8.605  0.50 25.46           C  
ATOM   4495  CG  LEU D 103      14.991   9.822   9.915  0.50 26.17           C  
ATOM   4497  CD1 LEU D 103      15.256  11.315   9.931  0.50 27.20           C  
ATOM   4499  CD2 LEU D 103      14.166   9.442  11.150  0.50 27.28           C  
ATOM   4501  N   VAL D 104      16.568   8.867   6.655  1.00 24.82           N  
ATOM   4502  CA  VAL D 104      17.964   9.160   6.419  1.00 25.96           C  
ATOM   4503  C   VAL D 104      18.119  10.683   6.474  1.00 26.05           C  
ATOM   4504  O   VAL D 104      17.370  11.418   5.813  1.00 26.15           O  
ATOM   4505  CB  VAL D 104      18.458   8.633   5.072  1.00 25.78           C  
ATOM   4506  CG1 VAL D 104      19.910   9.077   4.818  1.00 27.30           C  
ATOM   4507  CG2 VAL D 104      18.328   7.124   5.016  1.00 26.29           C  
ATOM   4508  N   GLU D 105      19.050  11.139   7.307  1.00 26.56           N  
ATOM   4509  CA  GLU D 105      19.442  12.545   7.380  1.00 27.50           C  
ATOM   4510  C   GLU D 105      20.817  12.675   6.743  1.00 27.34           C  
ATOM   4511  O   GLU D 105      21.713  11.873   7.036  1.00 27.26           O  
ATOM   4512  CB  GLU D 105      19.536  12.995   8.832  1.00 28.98           C  
ATOM   4513  CG  GLU D 105      18.229  12.903   9.565  1.00 34.28           C  
ATOM   4514  CD  GLU D 105      17.608  14.239   9.864  1.00 40.45           C  
ATOM   4515  OE1 GLU D 105      18.118  14.961  10.758  1.00 44.02           O  
ATOM   4516  OE2 GLU D 105      16.586  14.555   9.219  1.00 46.06           O  
ATOM   4517  N   GLU D 106      20.978  13.676   5.879  1.00 26.79           N  
ATOM   4518  CA  GLU D 106      22.263  14.002   5.281  1.00 26.67           C  
ATOM   4519  C   GLU D 106      22.610  15.447   5.638  1.00 26.33           C  
ATOM   4520  O   GLU D 106      21.768  16.337   5.516  1.00 25.78           O  
ATOM   4521  CB  GLU D 106      22.205  13.803   3.768  1.00 26.54           C  
ATOM   4522  CG  GLU D 106      23.548  13.947   3.078  1.00 27.07           C  
ATOM   4523  CD  GLU D 106      23.477  13.796   1.565  1.00 29.10           C  
ATOM   4524  OE1 GLU D 106      22.447  13.334   1.015  1.00 30.53           O  
ATOM   4525  OE2 GLU D 106      24.497  14.107   0.929  1.00 32.73           O  
ATOM   4526  N   LEU D 107      23.847  15.659   6.079  1.00 25.99           N  
ATOM   4527  CA  LEU D 107      24.302  16.966   6.551  0.50 26.06           C  
ATOM   4529  C   LEU D 107      25.607  17.333   5.862  1.00 26.04           C  
ATOM   4530  O   LEU D 107      26.458  16.474   5.677  1.00 25.88           O  
ATOM   4531  CB  LEU D 107      24.520  16.940   8.065  0.50 26.25           C  
ATOM   4533  CG  LEU D 107      23.336  16.523   8.953  0.50 26.90           C  
ATOM   4535  CD1 LEU D 107      23.755  16.527  10.411  0.50 28.03           C  
ATOM   4537  CD2 LEU D 107      22.135  17.435   8.748  0.50 27.60           C  
ATOM   4539  N   ARG D 108      25.745  18.608   5.482  1.00 25.31           N  
ATOM   4540  CA  ARG D 108      26.988  19.140   4.926  1.00 25.28           C  
ATOM   4541  C   ARG D 108      27.497  20.206   5.884  1.00 24.90           C  
ATOM   4542  O   ARG D 108      26.719  21.051   6.351  1.00 24.73           O  
ATOM   4543  CB  ARG D 108      26.800  19.717   3.521  1.00 25.16           C  
ATOM   4544  CG  ARG D 108      28.129  20.160   2.887  1.00 25.41           C  
ATOM   4545  CD  ARG D 108      27.996  20.533   1.427  1.00 26.54           C  
ATOM   4546  NE  ARG D 108      27.418  21.851   1.251  1.00 28.17           N  
ATOM   4547  CZ  ARG D 108      28.101  22.994   1.264  1.00 29.77           C  
ATOM   4548  NH1 ARG D 108      29.405  23.022   1.521  1.00 31.04           N  
ATOM   4549  NH2 ARG D 108      27.455  24.137   1.068  1.00 29.96           N  
ATOM   4550  N   PHE D 109      28.790  20.146   6.185  1.00 24.82           N  
ATOM   4551  CA  PHE D 109      29.436  21.036   7.145  1.00 25.22           C  
ATOM   4552  C   PHE D 109      30.346  22.057   6.483  1.00 25.55           C  
ATOM   4553  O   PHE D 109      31.053  21.743   5.513  1.00 25.30           O  
ATOM   4554  CB  PHE D 109      30.290  20.233   8.128  1.00 25.62           C  
ATOM   4555  CG  PHE D 109      29.496  19.444   9.111  1.00 25.73           C  
ATOM   4556  CD1 PHE D 109      28.947  18.222   8.750  1.00 25.85           C  
ATOM   4557  CD2 PHE D 109      29.276  19.934  10.394  1.00 26.24           C  
ATOM   4558  CE1 PHE D 109      28.191  17.489   9.660  1.00 26.73           C  
ATOM   4559  CE2 PHE D 109      28.527  19.203  11.309  1.00 27.01           C  
ATOM   4560  CZ  PHE D 109      27.983  17.983  10.939  1.00 27.00           C  
ATOM   4561  N   VAL D 110      30.340  23.266   7.041  1.00 25.09           N  
ATOM   4562  CA  VAL D 110      31.377  24.269   6.787  1.00 26.24           C  
ATOM   4563  C   VAL D 110      31.786  24.867   8.128  1.00 26.64           C  
ATOM   4564  O   VAL D 110      30.926  25.302   8.901  1.00 26.72           O  
ATOM   4565  CB  VAL D 110      30.880  25.401   5.876  1.00 26.07           C  
ATOM   4566  CG1 VAL D 110      31.954  26.496   5.729  1.00 26.94           C  
ATOM   4567  CG2 VAL D 110      30.463  24.856   4.525  1.00 26.86           C  
ATOM   4568  N   ASP D 111      33.087  24.871   8.409  1.00 27.34           N  
ATOM   4569  CA  ASP D 111      33.618  25.410   9.670  1.00 28.02           C  
ATOM   4570  C   ASP D 111      32.906  24.838  10.903  1.00 27.92           C  
ATOM   4571  O   ASP D 111      32.583  25.565  11.835  1.00 27.88           O  
ATOM   4572  CB  ASP D 111      33.530  26.939   9.667  1.00 28.90           C  
ATOM   4573  CG  ASP D 111      34.443  27.579   8.636  1.00 31.70           C  
ATOM   4574  OD1 ASP D 111      35.455  26.945   8.247  1.00 35.72           O  
ATOM   4575  OD2 ASP D 111      34.156  28.722   8.219  1.00 35.50           O  
ATOM   4576  N   GLY D 112      32.632  23.541  10.880  1.00 27.87           N  
ATOM   4577  CA  GLY D 112      32.022  22.853  12.014  1.00 28.07           C  
ATOM   4578  C   GLY D 112      30.531  23.087  12.219  1.00 28.06           C  
ATOM   4579  O   GLY D 112      29.963  22.567  13.176  1.00 29.29           O  
ATOM   4580  N   LYS D 113      29.885  23.813  11.306  1.00 27.49           N  
ATOM   4581  CA  LYS D 113      28.445  24.088  11.390  1.00 26.92           C  
ATOM   4582  C   LYS D 113      27.725  23.477  10.186  1.00 26.21           C  
ATOM   4583  O   LYS D 113      28.291  23.379   9.096  1.00 25.20           O  
ATOM   4584  CB  LYS D 113      28.185  25.595  11.442  1.00 27.88           C  
ATOM   4585  CG  LYS D 113      28.690  26.278  12.725  1.00 29.79           C  
ATOM   4586  CD  LYS D 113      27.697  26.097  13.878  1.00 32.84           C  
ATOM   4587  CE  LYS D 113      28.193  26.708  15.201  1.00 33.75           C  
ATOM   4588  NZ  LYS D 113      28.823  25.664  16.077  1.00 38.55           N  
ATOM   4589  N   VAL D 114      26.483  23.054  10.399  1.00 24.72           N  
ATOM   4590  CA  VAL D 114      25.687  22.446   9.334  1.00 24.65           C  
ATOM   4591  C   VAL D 114      25.152  23.563   8.445  1.00 24.09           C  
ATOM   4592  O   VAL D 114      24.420  24.434   8.920  1.00 23.94           O  
ATOM   4593  CB  VAL D 114      24.498  21.657   9.917  1.00 24.51           C  
ATOM   4594  CG1 VAL D 114      23.654  21.056   8.813  1.00 24.59           C  
ATOM   4595  CG2 VAL D 114      24.997  20.580  10.865  1.00 26.02           C  
ATOM   4596  N   VAL D 115      25.512  23.533   7.167  1.00 23.67           N  
ATOM   4597  CA  VAL D 115      25.034  24.529   6.198  1.00 24.15           C  
ATOM   4598  C   VAL D 115      23.945  24.012   5.255  1.00 23.84           C  
ATOM   4599  O   VAL D 115      23.210  24.814   4.659  1.00 23.95           O  
ATOM   4600  CB  VAL D 115      26.187  25.120   5.353  1.00 23.88           C  
ATOM   4601  CG1 VAL D 115      27.126  25.905   6.235  1.00 25.05           C  
ATOM   4602  CG2 VAL D 115      26.933  24.033   4.570  1.00 24.40           C  
ATOM   4603  N   GLU D 116      23.881  22.700   5.071  1.00 24.46           N  
ATOM   4604  CA  GLU D 116      22.812  22.070   4.310  1.00 24.98           C  
ATOM   4605  C   GLU D 116      22.368  20.805   5.013  1.00 25.29           C  
ATOM   4606  O   GLU D 116      23.189  20.056   5.551  1.00 24.42           O  
ATOM   4607  CB  GLU D 116      23.241  21.751   2.876  1.00 24.96           C  
ATOM   4608  CG  GLU D 116      23.386  22.978   2.005  1.00 25.52           C  
ATOM   4609  CD  GLU D 116      23.707  22.645   0.555  1.00 26.85           C  
ATOM   4610  OE1 GLU D 116      24.840  22.188   0.287  1.00 28.40           O  
ATOM   4611  OE2 GLU D 116      22.831  22.854  -0.319  1.00 27.85           O  
ATOM   4612  N   HIS D 117      21.063  20.568   4.965  1.00 25.33           N  
ATOM   4613  CA  HIS D 117      20.450  19.424   5.615  0.50 25.47           C  
ATOM   4615  C   HIS D 117      19.370  18.865   4.689  1.00 25.61           C  
ATOM   4616  O   HIS D 117      18.467  19.600   4.266  1.00 25.12           O  
ATOM   4617  CB  HIS D 117      19.897  19.875   6.972  0.50 25.79           C  
ATOM   4619  CG  HIS D 117      18.806  19.014   7.524  0.50 26.12           C  
ATOM   4621  ND1 HIS D 117      17.586  19.530   7.910  0.50 27.14           N  
ATOM   4623  CD2 HIS D 117      18.747  17.684   7.770  0.50 27.10           C  
ATOM   4625  CE1 HIS D 117      16.823  18.555   8.371  0.50 28.13           C  
ATOM   4627  NE2 HIS D 117      17.503  17.425   8.299  0.50 27.97           N  
ATOM   4629  N   TRP D 118      19.475  17.580   4.374  1.00 25.49           N  
ATOM   4630  CA  TRP D 118      18.483  16.887   3.548  1.00 25.86           C  
ATOM   4631  C   TRP D 118      17.911  15.732   4.359  1.00 26.56           C  
ATOM   4632  O   TRP D 118      18.651  15.038   5.073  1.00 27.43           O  
ATOM   4633  CB  TRP D 118      19.116  16.296   2.287  1.00 26.00           C  
ATOM   4634  CG  TRP D 118      19.812  17.243   1.370  1.00 25.44           C  
ATOM   4635  CD1 TRP D 118      19.293  17.819   0.252  1.00 25.49           C  
ATOM   4636  CD2 TRP D 118      21.175  17.671   1.447  1.00 24.87           C  
ATOM   4637  NE1 TRP D 118      20.235  18.604  -0.358  1.00 25.05           N  
ATOM   4638  CE2 TRP D 118      21.404  18.526   0.353  1.00 24.91           C  
ATOM   4639  CE3 TRP D 118      22.223  17.422   2.335  1.00 25.80           C  
ATOM   4640  CZ2 TRP D 118      22.636  19.144   0.133  1.00 25.66           C  
ATOM   4641  CZ3 TRP D 118      23.454  18.037   2.112  1.00 25.56           C  
ATOM   4642  CH2 TRP D 118      23.650  18.876   1.015  1.00 25.42           C  
ATOM   4643  N   ASP D 119      16.606  15.505   4.246  1.00 26.61           N  
ATOM   4644  CA  ASP D 119      16.016  14.313   4.847  1.00 26.28           C  
ATOM   4645  C   ASP D 119      15.200  13.510   3.848  1.00 25.80           C  
ATOM   4646  O   ASP D 119      14.668  14.053   2.878  1.00 26.12           O  
ATOM   4647  CB  ASP D 119      15.166  14.654   6.083  1.00 27.40           C  
ATOM   4648  CG  ASP D 119      13.956  15.526   5.768  1.00 30.39           C  
ATOM   4649  OD1 ASP D 119      13.146  15.195   4.867  1.00 34.25           O  
ATOM   4650  OD2 ASP D 119      13.787  16.555   6.465  1.00 36.46           O  
ATOM   4651  N   VAL D 120      15.158  12.201   4.081  1.00 24.76           N  
ATOM   4652  CA  VAL D 120      14.231  11.304   3.412  1.00 24.49           C  
ATOM   4653  C   VAL D 120      13.551  10.545   4.526  1.00 24.40           C  
ATOM   4654  O   VAL D 120      14.188   9.727   5.201  1.00 24.27           O  
ATOM   4655  CB  VAL D 120      14.948  10.326   2.449  1.00 24.05           C  
ATOM   4656  CG1 VAL D 120      13.955   9.325   1.886  1.00 23.87           C  
ATOM   4657  CG2 VAL D 120      15.638  11.116   1.320  1.00 24.19           C  
ATOM   4658  N   ILE D 121      12.271  10.829   4.739  1.00 24.13           N  
ATOM   4659  CA  ILE D 121      11.549  10.260   5.874  0.50 24.35           C  
ATOM   4661  C   ILE D 121      10.458   9.300   5.412  1.00 24.20           C  
ATOM   4662  O   ILE D 121       9.545   9.685   4.681  1.00 24.46           O  
ATOM   4663  CB  ILE D 121      10.924  11.366   6.756  0.50 24.33           C  
ATOM   4665  CG1 ILE D 121      12.021  12.234   7.384  0.50 24.42           C  
ATOM   4667  CG2 ILE D 121      10.054  10.750   7.844  0.50 24.45           C  
ATOM   4669  CD1 ILE D 121      11.509  13.522   8.003  0.50 24.64           C  
ATOM   4671  N   ASN D 122      10.560   8.042   5.856  1.00 24.03           N  
ATOM   4672  CA  ASN D 122       9.532   7.051   5.626  1.00 24.36           C  
ATOM   4673  C   ASN D 122       8.629   6.915   6.851  1.00 24.57           C  
ATOM   4674  O   ASN D 122       8.990   6.239   7.816  1.00 24.36           O  
ATOM   4675  CB  ASN D 122      10.123   5.679   5.314  1.00 24.22           C  
ATOM   4676  CG  ASN D 122       9.042   4.614   5.186  1.00 23.75           C  
ATOM   4677  OD1 ASN D 122       7.891   4.936   4.862  1.00 23.20           O  
ATOM   4678  ND2 ASN D 122       9.391   3.350   5.445  1.00 24.31           N  
ATOM   4679  N   MET D 123       7.456   7.541   6.780  1.00 25.15           N  
ATOM   4680  CA  MET D 123       6.462   7.488   7.860  0.50 25.62           C  
ATOM   4682  C   MET D 123       5.426   6.379   7.653  1.00 25.51           C  
ATOM   4683  O   MET D 123       4.460   6.278   8.423  1.00 25.20           O  
ATOM   4684  CB  MET D 123       5.726   8.826   7.978  0.50 25.81           C  
ATOM   4686  CG  MET D 123       6.626  10.034   8.214  0.50 25.95           C  
ATOM   4688  SD  MET D 123       6.112  10.976   9.668  0.50 28.03           S  
ATOM   4690  CE  MET D 123       6.811   9.912  10.913  0.50 29.06           C  
ATOM   4692  N   ARG D 124       5.601   5.545   6.630  1.00 25.47           N  
ATOM   4693  CA  ARG D 124       4.594   4.506   6.338  1.00 25.83           C  
ATOM   4694  C   ARG D 124       4.123   3.718   7.569  1.00 25.87           C  
ATOM   4695  O   ARG D 124       2.911   3.608   7.796  1.00 25.84           O  
ATOM   4696  CB  ARG D 124       5.082   3.537   5.260  1.00 25.61           C  
ATOM   4697  CG  ARG D 124       3.995   2.624   4.713  1.00 26.29           C  
ATOM   4698  CD  ARG D 124       4.573   1.366   4.079  1.00 27.02           C  
ATOM   4699  NE  ARG D 124       5.108   0.454   5.085  1.00 27.67           N  
ATOM   4700  CZ  ARG D 124       4.369  -0.325   5.877  1.00 30.07           C  
ATOM   4701  NH1 ARG D 124       3.044  -0.351   5.782  1.00 30.41           N  
ATOM   4702  NH2 ARG D 124       4.961  -1.103   6.769  1.00 30.12           N  
ATOM   4703  N   PRO D 125       5.059   3.163   8.362  1.00 26.24           N  
ATOM   4704  CA  PRO D 125       4.609   2.345   9.496  1.00 26.73           C  
ATOM   4705  C   PRO D 125       3.795   3.145  10.508  1.00 27.02           C  
ATOM   4706  O   PRO D 125       2.845   2.620  11.089  1.00 27.04           O  
ATOM   4707  CB  PRO D 125       5.913   1.853  10.138  1.00 27.10           C  
ATOM   4708  CG  PRO D 125       6.990   2.131   9.163  1.00 26.65           C  
ATOM   4709  CD  PRO D 125       6.527   3.265   8.313  1.00 26.79           C  
ATOM   4710  N   LEU D 126       4.170   4.405  10.711  1.00 27.35           N  
ATOM   4711  CA  LEU D 126       3.439   5.300  11.604  1.00 27.72           C  
ATOM   4712  C   LEU D 126       2.045   5.620  11.078  1.00 27.90           C  
ATOM   4713  O   LEU D 126       1.064   5.575  11.833  1.00 27.78           O  
ATOM   4714  CB  LEU D 126       4.222   6.595  11.811  1.00 27.64           C  
ATOM   4715  CG  LEU D 126       3.562   7.688  12.660  1.00 28.07           C  
ATOM   4716  CD1 LEU D 126       3.219   7.169  14.039  1.00 29.30           C  
ATOM   4717  CD2 LEU D 126       4.487   8.875  12.777  1.00 28.73           C  
ATOM   4718  N   LEU D 127       1.962   5.946   9.789  1.00 27.62           N  
ATOM   4719  CA  LEU D 127       0.688   6.268   9.144  1.00 28.25           C  
ATOM   4720  C   LEU D 127      -0.295   5.105   9.227  1.00 28.29           C  
ATOM   4721  O   LEU D 127      -1.500   5.318   9.372  1.00 28.35           O  
ATOM   4722  CB  LEU D 127       0.906   6.655   7.680  1.00 28.01           C  
ATOM   4723  CG  LEU D 127       1.594   8.012   7.474  1.00 28.24           C  
ATOM   4724  CD1 LEU D 127       2.118   8.116   6.055  1.00 28.50           C  
ATOM   4725  CD2 LEU D 127       0.647   9.170   7.766  1.00 28.86           C  
ATOM   4726  N   VAL D 128       0.227   3.884   9.136  1.00 28.84           N  
ATOM   4727  CA  VAL D 128      -0.584   2.682   9.314  1.00 29.67           C  
ATOM   4728  C   VAL D 128      -1.086   2.562  10.756  1.00 30.16           C  
ATOM   4729  O   VAL D 128      -2.259   2.258  10.972  1.00 29.84           O  
ATOM   4730  CB  VAL D 128       0.181   1.401   8.886  1.00 29.62           C  
ATOM   4731  CG1 VAL D 128      -0.593   0.136   9.277  1.00 30.07           C  
ATOM   4732  CG2 VAL D 128       0.424   1.414   7.379  1.00 29.66           C  
ATOM   4733  N   ARG D 129      -0.216   2.805  11.736  1.00 30.97           N  
ATOM   4734  CA  ARG D 129      -0.635   2.782  13.149  1.00 31.68           C  
ATOM   4735  C   ARG D 129      -1.631   3.900  13.488  1.00 31.77           C  
ATOM   4736  O   ARG D 129      -2.535   3.696  14.301  1.00 31.90           O  
ATOM   4737  CB  ARG D 129       0.564   2.874  14.097  1.00 32.38           C  
ATOM   4738  CG  ARG D 129       1.545   1.712  14.020  1.00 35.07           C  
ATOM   4739  CD  ARG D 129       0.984   0.448  14.634  1.00 40.30           C  
ATOM   4740  NE  ARG D 129       1.130   0.409  16.089  1.00 42.70           N  
ATOM   4741  CZ  ARG D 129       1.761  -0.550  16.777  1.00 44.55           C  
ATOM   4742  NH1 ARG D 129       2.326  -1.594  16.161  1.00 45.28           N  
ATOM   4743  NH2 ARG D 129       1.819  -0.475  18.105  1.00 44.14           N  
ATOM   4744  N   LEU D 130      -1.467   5.068  12.873  1.00 31.70           N  
ATOM   4745  CA  LEU D 130      -2.389   6.193  13.075  1.00 32.31           C  
ATOM   4746  C   LEU D 130      -3.720   6.036  12.328  1.00 32.22           C  
ATOM   4747  O   LEU D 130      -4.630   6.840  12.529  1.00 31.85           O  
ATOM   4748  CB  LEU D 130      -1.740   7.515  12.650  1.00 32.31           C  
ATOM   4749  CG  LEU D 130      -0.535   8.008  13.451  1.00 33.17           C  
ATOM   4750  CD1 LEU D 130       0.082   9.211  12.771  1.00 33.32           C  
ATOM   4751  CD2 LEU D 130      -0.902   8.350  14.877  1.00 33.48           C  
ATOM   4752  N   GLY D 131      -3.822   5.029  11.461  1.00 32.34           N  
ATOM   4753  CA  GLY D 131      -5.057   4.752  10.723  1.00 32.84           C  
ATOM   4754  C   GLY D 131      -5.199   5.549   9.437  1.00 33.03           C  
ATOM   4755  O   GLY D 131      -6.268   5.555   8.826  1.00 32.88           O  
ATOM   4756  N   LYS D 132      -4.116   6.206   9.022  1.00 33.38           N  
ATOM   4757  CA  LYS D 132      -4.100   7.033   7.812  1.00 33.95           C  
ATOM   4758  C   LYS D 132      -3.893   6.210   6.538  1.00 34.17           C  
ATOM   4759  O   LYS D 132      -4.246   6.653   5.443  1.00 34.16           O  
ATOM   4760  CB  LYS D 132      -2.997   8.091   7.915  1.00 34.11           C  
ATOM   4761  CG  LYS D 132      -3.195   9.112   9.024  1.00 35.03           C  
ATOM   4762  CD  LYS D 132      -4.400  10.003   8.756  1.00 36.08           C  
ATOM   4763  CE  LYS D 132      -4.399  11.220   9.657  1.00 36.15           C  
ATOM   4764  NZ  LYS D 132      -5.636  12.031   9.505  1.00 37.00           N  
ATOM   4765  N   LEU D 133      -3.290   5.034   6.688  1.00 34.53           N  
ATOM   4766  CA  LEU D 133      -3.107   4.083   5.594  1.00 34.90           C  
ATOM   4767  C   LEU D 133      -3.504   2.706   6.099  1.00 35.42           C  
ATOM   4768  O   LEU D 133      -3.393   2.437   7.293  1.00 35.84           O  
ATOM   4769  CB  LEU D 133      -1.646   4.034   5.149  1.00 34.67           C  
ATOM   4770  CG  LEU D 133      -1.034   5.249   4.458  1.00 34.52           C  
ATOM   4771  CD1 LEU D 133       0.468   5.026   4.297  1.00 34.73           C  
ATOM   4772  CD2 LEU D 133      -1.684   5.520   3.117  1.00 34.20           C  
ATOM   4773  N   PRO D 134      -3.957   1.821   5.197  1.00 35.96           N  
ATOM   4774  CA  PRO D 134      -4.401   0.492   5.626  1.00 36.08           C  
ATOM   4775  C   PRO D 134      -3.237  -0.463   5.917  1.00 36.42           C  
ATOM   4776  O   PRO D 134      -2.161  -0.329   5.329  1.00 37.06           O  
ATOM   4777  CB  PRO D 134      -5.224   0.002   4.433  1.00 36.26           C  
ATOM   4778  CG  PRO D 134      -4.609   0.670   3.255  1.00 36.10           C  
ATOM   4779  CD  PRO D 134      -4.083   2.000   3.738  1.00 36.15           C  
TER    4780      PRO D 134                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
