
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  131 ( 1049),  selected  131 , name 1tuh_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1tuh_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      M       2           -
LGA    -       -      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    N    19_A      D       7          1.906
LGA    E    20_A      N       8          1.909
LGA    A    21_A      T       9          2.641
LGA    E    22_A      L      10          2.651
LGA    Q    23_A      K      11          1.786
LGA    N    24_A      V      12          2.549
LGA    A    25_A      A      13          3.399
LGA    E    26_A      H      14          2.709
LGA    T    27_A      Q      15          2.133
LGA    V    28_A      G      16          3.012
LGA    R    29_A      F      17          3.160
LGA    R    30_A      E      18          2.485
LGA    G    31_A      F      19          2.260
LGA    Y    32_A      F      20          2.630
LGA    A    33_A      T      21          3.455
LGA    A    34_A      Q      22          2.995
LGA    F    35_A      G      23          1.510
LGA    N    36_A      L      24          3.365
LGA    -       -      A      25           -
LGA    S    37_A      T      26          3.331
LGA    G    38_A      G      27          3.397
LGA    D    39_A      E      28          3.566
LGA    M    40_A      W      29          2.514
LGA    K    41_A      Q      30          2.717
LGA    T    42_A      K      31          1.457
LGA    L    43_A      F      32          1.313
LGA    T    44_A      L      33          2.283
LGA    E    45_A      D      34          2.170
LGA    L    46_A      M      35          1.314
LGA    F    47_A      L      36          1.019
LGA    D    48_A      T      37          1.133
LGA    E    49_A      E      38          2.334
LGA    N    50_A      D      39          2.065
LGA    A    51_A      F      40          1.124
LGA    S    52_A      T      41          1.643
LGA    W    53_A      F      42          1.860
LGA    H    54_A      W      43          1.495
LGA    T    55_A      F      44          1.397
LGA    P    56_A      P      45          0.735
LGA    G    57_A      M      46          3.171
LGA    R    58_A      -       -           -
LGA    S    59_A      -       -           -
LGA    R    60_A      G      47          3.283
LGA    I    61_A      E      48          3.958
LGA    A    62_A      F      49          3.915
LGA    G    63_A      H      50          1.128
LGA    D    64_A      G      51          3.144
LGA    -       -      L      52           -
LGA    H    65_A      N      53          2.655
LGA    K    66_A      V      54          1.718
LGA    G    67_A      G      55          1.096
LGA    R    68_A      K      56          1.566
LGA    E    69_A      E      57          1.688
LGA    A    70_A      R      58          1.226
LGA    I    71_A      A      59          1.518
LGA    F    72_A      K      60          1.809
LGA    A    73_A      E      61          1.237
LGA    Q    74_A      F      62          1.217
LGA    F    75_A      F      63          1.117
LGA    G    76_A      T      64          0.739
LGA    R    77_A      Y      65          1.205
LGA    Y    78_A      V      66          1.418
LGA    G    79_A      S      67          1.199
LGA    G    80_A      E      68          0.954
LGA    E    81_A      S      69          1.794
LGA    T    82_A      F      70          2.270
LGA    G    83_A      H      71          1.694
LGA    G    84_A      T      72          3.592
LGA    T    85_A      G      73          2.683
LGA    F    86_A      I      74          2.789
LGA    K    87_A      Q      75          3.246
LGA    A    88_A      I      76          3.758
LGA    V    89_A      S      77          3.917
LGA    L    90_A      S      78          4.754
LGA    L    91_A      L      79          0.652
LGA    H    92_A      D      80          3.495
LGA    V    93_A      R      81          5.064
LGA    L    94_A      V      82          2.040
LGA    K    95_A      T      83          3.541
LGA    S    96_A      S      84          2.334
LGA    D    97_A      N      85          3.313
LGA    D    98_A      E      86          0.365
LGA    G    99_A      T      87          2.923
LGA    R   100_A      T      88          0.865
LGA    V   101_A      V      89          0.557
LGA    I   102_A      V      90          0.844
LGA    G   103_A      F      91          1.278
LGA    I   104_A      E      92          1.475
LGA    H   105_A      F      93          1.668
LGA    R   106_A      R      94          1.982
LGA    N   107_A      D      95          2.780
LGA    T   108_A      E      96          1.588
LGA    A   109_A      G      97          2.235
LGA    E   110_A      L      98          1.963
LGA    R   111_A      F      99          2.547
LGA    G   112_A      L     100          3.625
LGA    G   113_A      G     101          4.538
LGA    K   114_A      K     102          2.814
LGA    R   115_A      P     103          1.735
LGA    L   116_A      Y     104          0.828
LGA    D   117_A      K     105          0.326
LGA    V   118_A      N     106          0.629
LGA    G   119_A      R     107          0.317
LGA    C   120_A      V     108          0.474
LGA    C   121_A      A     109          0.738
LGA    I   122_A      V     110          0.632
LGA    V   123_A      S     111          1.049
LGA    F   124_A      F     112          0.783
LGA    E   125_A      D     113          0.965
LGA    F   126_A      V     114          1.641
LGA    K   127_A      R     115          1.976
LGA    N   128_A      G     116          2.220
LGA    G   129_A      D     117          2.808
LGA    R   130_A      K     118          1.300
LGA    V   131_A      I     119          1.341
LGA    I   132_A      C     120          1.227
LGA    D   133_A      S     121          1.166
LGA    G   134_A      Y     122          0.971
LGA    R   135_A      R     123          0.853
LGA    E   136_A      E     124          0.884
LGA    H   137_A      Y     125          1.035
LGA    F   138_A      F     126          0.847
LGA    Y   139_A      G     127          0.980
LGA    D   140_A      S     128          2.175
LGA    L   141_A      -       -           -
LGA    Y   142_A      D     129          4.563
LGA    A   143_A      G     130          3.372
LGA    W   144_A      K     131           #
LGA    D   145_A      S     132           -
LGA    E   146_A      N     133           -
LGA    F   147_A      -       -           -
LGA    W   148_A      -       -           -
LGA    R   149_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  131  133    5.0    122    2.31    13.93     67.641     5.068

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.795290 * X  +   0.599503 * Y  +  -0.090052 * Z  +  11.332035
  Y_new =  -0.383188 * X  +   0.382006 * Y  +  -0.840974 * Z  +  45.026180
  Z_new =  -0.469766 * X  +   0.703326 * Y  +   0.533529 * Z  + -23.326412 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.921827   -2.219766  [ DEG:    52.8168   -127.1832 ]
  Theta =   0.489026    2.652566  [ DEG:    28.0191    151.9809 ]
  Phi   =  -0.449000    2.692593  [ DEG:   -25.7258    154.2742 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tuh_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tuh_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  131  133   5.0  122   2.31   13.93  67.641
REMARK  ---------------------------------------------------------- 
MOLECULE 1tuh_A
HEADER    UNKNOWN FUNCTION                        25-JUN-04   1TUH              
TITLE     STRUCTURE OF BAL32A FROM A SOIL-DERIVED MOBILE GENE CASSETTE          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN EGC068;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: BAL32A;                                                     
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: UNCULTURED BACTERIUM;                           
SOURCE   3 GENE: EGC068;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PETMCIII                                  
KEYWDS    UNCULTURED                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.ROBINSON,P.S.-C.WU,S.J.HARROP,P.M.SCHAEFFER,N.E.DIXON,              
AUTHOR   2 M.R.GILLINGS,A.J.HOLMES,K.M.H.NEVALAINEN,G.OTTING,                   
AUTHOR   3 H.W.STOKES,P.M.G.CURMI,B.C.MABBUTT                                   
REVDAT   2   01-MAR-05 1TUH    1       JRNL                                     
REVDAT   1   06-JUL-04 1TUH    0                                                
JRNL        AUTH   A.ROBINSON,P.S.-C.WU,S.J.HARROP,P.M.SCHAEFFER,               
JRNL        AUTH 2 Z.DOSZTANYI,M.R.GILLINGS,A.J.HOLMES,                         
JRNL        AUTH 3 K.M.H.NEVALAINEN,H.W.STOKES,G.OTTING,N.E.DIXON,              
JRNL        AUTH 4 P.M.G.CURMI,B.C.MABBUTT                                      
JRNL        TITL   INTEGRON-ASSOCIATED MOBILE GENE CASSETTES CODE FOR           
JRNL        TITL 2 FOLDED PROTEINS: THE STRUCTURE OF BAL32A, A NEW              
JRNL        TITL 3 MEMBER OF THE ADAPTABLE ALPHA+BETA BARREL FAMILY             
JRNL        REF    J.MOL.BIOL.                   V. 346  1229 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  1TUH A    1   149  UNP    Q99IU3   Q99IU3_9ZZZZ     1    149             
SEQRES   1 A  156  MET HIS HIS HIS HIS HIS HIS MET GLY ILE VAL THR GLY          
SEQRES   2 A  156  PRO ILE ILE ASP HIS SER LYS GLU ASN ASP VAL MET ASN          
SEQRES   3 A  156  GLU ALA GLU GLN ASN ALA GLU THR VAL ARG ARG GLY TYR          
SEQRES   4 A  156  ALA ALA PHE ASN SER GLY ASP MET LYS THR LEU THR GLU          
SEQRES   5 A  156  LEU PHE ASP GLU ASN ALA SER TRP HIS THR PRO GLY ARG          
SEQRES   6 A  156  SER ARG ILE ALA GLY ASP HIS LYS GLY ARG GLU ALA ILE          
SEQRES   7 A  156  PHE ALA GLN PHE GLY ARG TYR GLY GLY GLU THR GLY GLY          
SEQRES   8 A  156  THR PHE LYS ALA VAL LEU LEU HIS VAL LEU LYS SER ASP          
SEQRES   9 A  156  ASP GLY ARG VAL ILE GLY ILE HIS ARG ASN THR ALA GLU          
SEQRES  10 A  156  ARG GLY GLY LYS ARG LEU ASP VAL GLY CYS CYS ILE VAL          
SEQRES  11 A  156  PHE GLU PHE LYS ASN GLY ARG VAL ILE ASP GLY ARG GLU          
SEQRES  12 A  156  HIS PHE TYR ASP LEU TYR ALA TRP ASP GLU PHE TRP ARG          
HET    ACT    501       4                                                       
HETNAM     ACT ACETATE ION                                                      
FORMUL   2  ACT    C2 H3 O2 1-                                                  
FORMUL   3  HOH   *75(H2 O)                                                     
CRYST1   60.728   60.728   89.910  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   ASN A  19      40.263  14.035  10.474  1.00 45.03           N  
ATOM      2  CA  ASN A  19      39.790  14.723   9.231  1.00 44.21           C  
ATOM      3  C   ASN A  19      38.433  15.446   9.360  1.00 42.10           C  
ATOM      4  O   ASN A  19      37.698  15.256  10.320  1.00 39.35           O  
ATOM      5  CB  ASN A  19      39.862  13.798   7.995  1.00 45.44           C  
ATOM      6  CG  ASN A  19      38.834  12.636   7.988  1.00 47.05           C  
ATOM      7  OD1 ASN A  19      37.833  12.641   8.643  1.00 47.59           O  
ATOM      8  ND2 ASN A  19      39.112  11.653   7.154  1.00 49.92           N  
ATOM      9  N   GLU A  20      38.165  16.310   8.398  1.00 40.68           N  
ATOM     10  CA  GLU A  20      36.922  17.021   8.301  1.00 40.23           C  
ATOM     11  C   GLU A  20      35.753  16.051   8.335  1.00 35.83           C  
ATOM     12  O   GLU A  20      34.768  16.290   9.046  1.00 34.32           O  
ATOM     13  CB  GLU A  20      36.850  17.781   6.964  1.00 40.63           C  
ATOM     14  CG  GLU A  20      35.552  18.550   6.715  1.00 43.75           C  
ATOM     15  CD  GLU A  20      35.515  19.278   5.342  1.00 46.53           C  
ATOM     16  OE1 GLU A  20      35.848  18.701   4.267  1.00 52.64           O  
ATOM     17  OE2 GLU A  20      35.160  20.477   5.356  1.00 58.55           O  
ATOM     18  N   ALA A  21      35.852  14.997   7.542  1.00 34.00           N  
ATOM     19  CA  ALA A  21      34.721  14.076   7.412  1.00 33.84           C  
ATOM     20  C   ALA A  21      34.427  13.440   8.771  1.00 32.93           C  
ATOM     21  O   ALA A  21      33.271  13.333   9.170  1.00 29.79           O  
ATOM     22  CB  ALA A  21      34.981  13.036   6.408  1.00 34.01           C  
ATOM     23  N   GLU A  22      35.459  13.041   9.520  1.00 31.40           N  
ATOM     24  CA  GLU A  22      35.185  12.475  10.826  1.00 30.32           C  
ATOM     25  C   GLU A  22      34.708  13.467  11.844  1.00 28.41           C  
ATOM     26  O   GLU A  22      33.877  13.148  12.675  1.00 26.65           O  
ATOM     27  CB  GLU A  22      36.389  11.641  11.366  1.00 32.64           C  
ATOM     28  CG  GLU A  22      36.027  10.893  12.637  1.00 35.08           C  
ATOM     29  CD  GLU A  22      34.754  10.020  12.559  1.00 39.60           C  
ATOM     30  OE1 GLU A  22      34.560   9.309  11.504  1.00 37.66           O  
ATOM     31  OE2 GLU A  22      33.966  10.029  13.566  1.00 33.37           O  
ATOM     32  N   GLN A  23      35.171  14.714  11.785  1.00 28.10           N  
ATOM     33  CA  GLN A  23      34.619  15.741  12.678  1.00 27.48           C  
ATOM     34  C   GLN A  23      33.120  15.946  12.405  1.00 25.96           C  
ATOM     35  O   GLN A  23      32.339  16.039  13.294  1.00 25.46           O  
ATOM     36  CB  GLN A  23      35.267  17.095  12.426  1.00 29.80           C  
ATOM     37  CG  GLN A  23      34.714  18.155  13.417  1.00 35.25           C  
ATOM     38  CD  GLN A  23      35.161  17.971  14.846  1.00 50.39           C  
ATOM     39  OE1 GLN A  23      34.402  17.402  15.720  1.00 58.29           O  
ATOM     40  NE2 GLN A  23      36.400  18.464  15.131  1.00 54.21           N  
ATOM     41  N   ASN A  24      32.761  15.917  11.143  1.00 24.93           N  
ATOM     42  CA  ASN A  24      31.326  16.066  10.795  1.00 25.49           C  
ATOM     43  C   ASN A  24      30.533  14.869  11.272  1.00 23.95           C  
ATOM     44  O   ASN A  24      29.423  15.024  11.756  1.00 25.17           O  
ATOM     45  CB  ASN A  24      31.222  16.266   9.279  1.00 25.99           C  
ATOM     46  CG  ASN A  24      31.727  17.618   8.826  1.00 27.52           C  
ATOM     47  OD1 ASN A  24      32.039  18.508   9.646  1.00 28.27           O  
ATOM     48  ND2 ASN A  24      31.784  17.801   7.501  1.00 27.38           N  
ATOM     49  N   ALA A  25      31.113  13.656  11.215  1.00 24.77           N  
ATOM     50  CA  ALA A  25      30.479  12.472  11.765  1.00 25.17           C  
ATOM     51  C   ALA A  25      30.280  12.620  13.265  1.00 24.39           C  
ATOM     52  O   ALA A  25      29.222  12.252  13.788  1.00 23.58           O  
ATOM     53  CB  ALA A  25      31.254  11.176  11.376  1.00 26.39           C  
ATOM     54  N   GLU A  26      31.311  13.112  13.994  1.00 25.16           N  
ATOM     55  CA  GLU A  26      31.183  13.374  15.403  1.00 26.56           C  
ATOM     56  C   GLU A  26      30.068  14.369  15.707  1.00 25.72           C  
ATOM     57  O   GLU A  26      29.348  14.242  16.682  1.00 26.13           O  
ATOM     58  CB  GLU A  26      32.484  13.889  16.008  1.00 27.05           C  
ATOM     59  CG  GLU A  26      33.569  12.868  15.946  1.00 29.81           C  
ATOM     60  CD  GLU A  26      34.731  13.161  16.861  1.00 36.33           C  
ATOM     61  OE1 GLU A  26      34.851  14.320  17.353  1.00 45.30           O  
ATOM     62  OE2 GLU A  26      35.468  12.191  17.090  1.00 42.08           O  
ATOM     63  N   THR A  27      29.952  15.382  14.866  1.00 26.34           N  
ATOM     64  CA  THR A  27      28.915  16.403  15.073  1.00 25.73           C  
ATOM     65  C   THR A  27      27.514  15.733  14.910  1.00 25.24           C  
ATOM     66  O   THR A  27      26.594  16.008  15.679  1.00 24.31           O  
ATOM     67  CB  THR A  27      29.119  17.462  14.068  1.00 27.53           C  
ATOM     68  OG1 THR A  27      30.340  18.175  14.434  1.00 27.37           O  
ATOM     69  CG2 THR A  27      27.931  18.449  14.067  1.00 29.40           C  
ATOM     70  N   VAL A  28      27.385  14.847  13.907  1.00 24.27           N  
ATOM     71  CA  VAL A  28      26.078  14.135  13.716  1.00 23.88           C  
ATOM     72  C   VAL A  28      25.760  13.318  14.950  1.00 23.80           C  
ATOM     73  O   VAL A  28      24.613  13.297  15.419  1.00 23.43           O  
ATOM     74  CB  VAL A  28      26.067  13.349  12.419  1.00 24.05           C  
ATOM     75  CG1 VAL A  28      24.992  12.199  12.363  1.00 26.76           C  
ATOM     76  CG2 VAL A  28      25.988  14.380  11.205  1.00 26.25           C  
ATOM     77  N   ARG A  29      26.758  12.587  15.488  1.00 23.35           N  
ATOM     78  CA  ARG A  29      26.484  11.790  16.661  1.00 25.00           C  
ATOM     79  C   ARG A  29      26.039  12.620  17.874  1.00 24.57           C  
ATOM     80  O   ARG A  29      25.107  12.219  18.605  1.00 28.25           O  
ATOM     81  CB  ARG A  29      27.690  10.958  16.982  1.00 24.77           C  
ATOM     82  CG  ARG A  29      28.011   9.900  15.921  1.00 25.57           C  
ATOM     83  CD  ARG A  29      29.072   8.887  16.393  1.00 26.36           C  
ATOM     84  NE  ARG A  29      29.556   8.083  15.281  1.00 26.01           N  
ATOM     85  CZ  ARG A  29      30.625   8.343  14.565  1.00 27.82           C  
ATOM     86  NH1 ARG A  29      31.395   9.415  14.752  1.00 29.44           N  
ATOM     87  NH2 ARG A  29      30.944   7.481  13.644  1.00 28.94           N  
ATOM     88  N   ARG A  30      26.698  13.747  18.067  1.00 27.90           N  
ATOM     89  CA  ARG A  30      26.371  14.717  19.114  1.00 29.25           C  
ATOM     90  C   ARG A  30      24.957  15.238  18.910  1.00 28.58           C  
ATOM     91  O   ARG A  30      24.222  15.415  19.863  1.00 27.02           O  
ATOM     92  CB  ARG A  30      27.318  15.895  19.078  1.00 29.06           C  
ATOM     93  CG  ARG A  30      28.585  15.653  19.680  1.00 35.07           C  
ATOM     94  CD  ARG A  30      29.507  16.816  19.602  1.00 37.67           C  
ATOM     95  NE  ARG A  30      29.009  17.917  20.401  1.00 43.30           N  
ATOM     96  CZ  ARG A  30      29.371  19.183  20.244  1.00 46.53           C  
ATOM     97  NH1 ARG A  30      30.212  19.576  19.252  1.00 47.13           N  
ATOM     98  NH2 ARG A  30      28.858  20.069  21.065  1.00 45.66           N  
ATOM     99  N   GLY A  31      24.587  15.478  17.654  1.00 28.20           N  
ATOM    100  CA  GLY A  31      23.242  15.968  17.364  1.00 28.04           C  
ATOM    101  C   GLY A  31      22.141  14.971  17.604  1.00 27.16           C  
ATOM    102  O   GLY A  31      21.121  15.311  18.166  1.00 27.28           O  
ATOM    103  N   TYR A  32      22.342  13.701  17.252  1.00 27.77           N  
ATOM    104  CA  TYR A  32      21.286  12.730  17.586  1.00 26.57           C  
ATOM    105  C   TYR A  32      21.095  12.639  19.133  1.00 28.31           C  
ATOM    106  O   TYR A  32      19.964  12.512  19.636  1.00 27.43           O  
ATOM    107  CB  TYR A  32      21.619  11.335  17.061  1.00 26.21           C  
ATOM    108  CG  TYR A  32      21.186  11.024  15.639  1.00 25.00           C  
ATOM    109  CD1 TYR A  32      22.015  11.406  14.560  1.00 23.32           C  
ATOM    110  CD2 TYR A  32      20.018  10.335  15.380  1.00 26.42           C  
ATOM    111  CE1 TYR A  32      21.678  11.147  13.224  1.00 23.36           C  
ATOM    112  CE2 TYR A  32      19.643  10.020  14.015  1.00 27.11           C  
ATOM    113  CZ  TYR A  32      20.466  10.425  12.959  1.00 24.66           C  
ATOM    114  OH  TYR A  32      20.144  10.146  11.637  1.00 24.61           O  
ATOM    115  N   ALA A  33      22.224  12.655  19.859  1.00 30.01           N  
ATOM    116  CA  ALA A  33      22.203  12.568  21.350  1.00 30.21           C  
ATOM    117  C   ALA A  33      21.491  13.766  21.947  1.00 29.76           C  
ATOM    118  O   ALA A  33      20.611  13.607  22.782  1.00 30.34           O  
ATOM    119  CB  ALA A  33      23.613  12.448  21.905  1.00 31.61           C  
ATOM    120  N   ALA A  34      21.809  14.941  21.449  1.00 31.37           N  
ATOM    121  CA  ALA A  34      21.155  16.192  21.901  1.00 31.58           C  
ATOM    122  C   ALA A  34      19.669  16.283  21.493  1.00 32.95           C  
ATOM    123  O   ALA A  34      18.824  16.704  22.282  1.00 32.69           O  
ATOM    124  CB  ALA A  34      21.946  17.403  21.414  1.00 32.23           C  
ATOM    125  N   PHE A  35      19.339  15.794  20.307  1.00 32.84           N  
ATOM    126  CA  PHE A  35      17.957  15.646  19.925  1.00 33.28           C  
ATOM    127  C   PHE A  35      17.243  14.712  20.874  1.00 34.02           C  
ATOM    128  O   PHE A  35      16.197  15.061  21.388  1.00 32.74           O  
ATOM    129  CB  PHE A  35      17.826  15.119  18.490  1.00 32.96           C  
ATOM    130  CG  PHE A  35      16.393  14.873  18.089  1.00 32.48           C  
ATOM    131  CD1 PHE A  35      15.631  15.914  17.605  1.00 30.96           C  
ATOM    132  CD2 PHE A  35      15.793  13.636  18.254  1.00 31.64           C  
ATOM    133  CE1 PHE A  35      14.269  15.732  17.257  1.00 34.27           C  
ATOM    134  CE2 PHE A  35      14.455  13.440  17.918  1.00 32.80           C  
ATOM    135  CZ  PHE A  35      13.686  14.490  17.421  1.00 34.49           C  
ATOM    136  N   ASN A  36      17.812  13.535  21.121  1.00 33.71           N  
ATOM    137  CA  ASN A  36      17.111  12.530  21.906  1.00 35.73           C  
ATOM    138  C   ASN A  36      16.932  12.984  23.373  1.00 39.28           C  
ATOM    139  O   ASN A  36      15.954  12.590  24.021  1.00 40.69           O  
ATOM    140  CB  ASN A  36      17.839  11.189  21.839  1.00 34.85           C  
ATOM    141  CG  ASN A  36      17.500  10.420  20.595  1.00 34.63           C  
ATOM    142  OD1 ASN A  36      16.394  10.528  20.090  1.00 33.80           O  
ATOM    143  ND2 ASN A  36      18.459   9.679  20.058  1.00 33.76           N  
ATOM    144  N   SER A  37      17.818  13.854  23.861  1.00 40.60           N  
ATOM    145  CA  SER A  37      17.699  14.332  25.243  1.00 41.16           C  
ATOM    146  C   SER A  37      17.004  15.676  25.358  1.00 42.95           C  
ATOM    147  O   SER A  37      16.802  16.174  26.465  1.00 42.99           O  
ATOM    148  CB  SER A  37      19.069  14.341  25.889  1.00 41.84           C  
ATOM    149  OG  SER A  37      19.880  15.341  25.341  1.00 43.57           O  
ATOM    150  N   GLY A  38      16.613  16.265  24.228  1.00 42.90           N  
ATOM    151  CA  GLY A  38      15.971  17.584  24.211  1.00 42.83           C  
ATOM    152  C   GLY A  38      16.888  18.748  24.467  1.00 43.72           C  
ATOM    153  O   GLY A  38      16.444  19.811  24.911  1.00 44.89           O  
ATOM    154  N   ASP A  39      18.167  18.572  24.203  1.00 42.74           N  
ATOM    155  CA  ASP A  39      19.169  19.549  24.540  1.00 43.27           C  
ATOM    156  C   ASP A  39      19.330  20.483  23.361  1.00 43.52           C  
ATOM    157  O   ASP A  39      20.217  20.364  22.564  1.00 42.20           O  
ATOM    158  CB  ASP A  39      20.463  18.842  24.949  1.00 43.44           C  
ATOM    159  CG  ASP A  39      21.658  19.765  25.113  1.00 43.40           C  
ATOM    160  OD1 ASP A  39      21.551  21.023  25.089  1.00 46.79           O  
ATOM    161  OD2 ASP A  39      22.796  19.281  25.245  1.00 44.42           O  
ATOM    162  N   MET A  40      18.431  21.461  23.305  1.00 45.35           N  
ATOM    163  CA  MET A  40      18.349  22.368  22.156  1.00 45.31           C  
ATOM    164  C   MET A  40      19.456  23.402  22.188  1.00 45.33           C  
ATOM    165  O   MET A  40      19.877  23.916  21.147  1.00 45.26           O  
ATOM    166  CB  MET A  40      16.907  22.948  22.038  1.00 46.62           C  
ATOM    167  CG  MET A  40      15.765  21.883  21.812  1.00 45.02           C  
ATOM    168  SD  MET A  40      15.546  20.695  20.406  1.00 50.91           S  
ATOM    169  CE  MET A  40      16.168  19.104  20.953  1.00 51.11           C  
ATOM    170  N   LYS A  41      20.030  23.675  23.353  1.00 46.45           N  
ATOM    171  CA  LYS A  41      21.227  24.505  23.385  1.00 45.62           C  
ATOM    172  C   LYS A  41      22.447  23.917  22.620  1.00 45.02           C  
ATOM    173  O   LYS A  41      23.142  24.612  21.836  1.00 44.27           O  
ATOM    174  CB  LYS A  41      21.608  24.765  24.848  1.00 47.52           C  
ATOM    175  CG  LYS A  41      22.664  25.869  25.047  1.00 49.49           C  
ATOM    176  CD  LYS A  41      22.307  26.794  26.284  1.00 51.18           C  
ATOM    177  CE  LYS A  41      23.561  27.200  27.108  1.00 55.65           C  
ATOM    178  NZ  LYS A  41      24.695  27.692  26.246  1.00 60.59           N  
ATOM    179  N   THR A  42      22.758  22.638  22.866  1.00 42.22           N  
ATOM    180  CA  THR A  42      23.808  22.014  22.086  1.00 41.31           C  
ATOM    181  C   THR A  42      23.392  21.934  20.628  1.00 37.99           C  
ATOM    182  O   THR A  42      24.143  22.240  19.722  1.00 36.48           O  
ATOM    183  CB  THR A  42      24.080  20.559  22.609  1.00 41.37           C  
ATOM    184  OG1 THR A  42      24.614  20.602  23.937  1.00 45.59           O  
ATOM    185  CG2 THR A  42      25.114  19.919  21.836  1.00 39.23           C  
ATOM    186  N   LEU A  43      22.165  21.509  20.398  1.00 39.60           N  
ATOM    187  CA  LEU A  43      21.694  21.322  19.017  1.00 40.23           C  
ATOM    188  C   LEU A  43      21.881  22.623  18.175  1.00 40.94           C  
ATOM    189  O   LEU A  43      22.321  22.601  17.008  1.00 40.48           O  
ATOM    190  CB  LEU A  43      20.272  20.708  19.097  1.00 40.15           C  
ATOM    191  CG  LEU A  43      19.772  19.721  18.066  1.00 39.36           C  
ATOM    192  CD1 LEU A  43      20.756  18.653  17.730  1.00 36.25           C  
ATOM    193  CD2 LEU A  43      18.407  19.171  18.487  1.00 42.07           C  
ATOM    194  N   THR A  44      21.679  23.794  18.792  1.00 41.56           N  
ATOM    195  CA  THR A  44      22.028  25.122  18.188  1.00 41.08           C  
ATOM    196  C   THR A  44      23.400  25.372  17.706  1.00 40.91           C  
ATOM    197  O   THR A  44      23.615  25.962  16.633  1.00 42.59           O  
ATOM    198  CB  THR A  44      21.755  26.255  19.276  1.00 42.09           C  
ATOM    199  OG1 THR A  44      20.351  26.295  19.465  1.00 39.55           O  
ATOM    200  CG2 THR A  44      22.214  27.724  18.846  1.00 42.29           C  
ATOM    201  N   GLU A  45      24.344  24.990  18.524  1.00 39.07           N  
ATOM    202  CA  GLU A  45      25.719  25.126  18.189  1.00 40.36           C  
ATOM    203  C   GLU A  45      26.000  24.343  16.923  1.00 38.12           C  
ATOM    204  O   GLU A  45      26.963  24.634  16.250  1.00 40.41           O  
ATOM    205  CB  GLU A  45      26.629  24.581  19.305  1.00 41.47           C  
ATOM    206  CG  GLU A  45      26.840  25.568  20.470  1.00 47.14           C  
ATOM    207  CD  GLU A  45      26.971  24.857  21.808  1.00 48.22           C  
ATOM    208  OE1 GLU A  45      27.457  23.678  21.846  1.00 59.37           O  
ATOM    209  OE2 GLU A  45      26.559  25.465  22.837  1.00 59.14           O  
ATOM    210  N   LEU A  46      25.255  23.272  16.664  1.00 34.44           N  
ATOM    211  CA  LEU A  46      25.646  22.359  15.557  1.00 31.76           C  
ATOM    212  C   LEU A  46      25.069  22.699  14.205  1.00 29.83           C  
ATOM    213  O   LEU A  46      25.439  22.050  13.206  1.00 29.13           O  
ATOM    214  CB  LEU A  46      25.196  20.914  15.901  1.00 31.38           C  
ATOM    215  CG  LEU A  46      25.564  20.419  17.335  1.00 32.24           C  
ATOM    216  CD1 LEU A  46      25.111  19.009  17.602  1.00 34.50           C  
ATOM    217  CD2 LEU A  46      26.986  20.625  17.529  1.00 32.60           C  
ATOM    218  N   PHE A  47      24.091  23.605  14.167  1.00 28.90           N  
ATOM    219  CA  PHE A  47      23.396  23.980  12.921  1.00 28.15           C  
ATOM    220  C   PHE A  47      23.716  25.434  12.555  1.00 27.33           C  
ATOM    221  O   PHE A  47      23.730  26.290  13.430  1.00 27.36           O  
ATOM    222  CB  PHE A  47      21.869  23.932  13.087  1.00 28.66           C  
ATOM    223  CG  PHE A  47      21.273  22.561  12.957  1.00 27.56           C  
ATOM    224  CD1 PHE A  47      20.711  22.130  11.760  1.00 28.94           C  
ATOM    225  CD2 PHE A  47      21.292  21.687  14.068  1.00 26.45           C  
ATOM    226  CE1 PHE A  47      20.148  20.863  11.665  1.00 29.63           C  
ATOM    227  CE2 PHE A  47      20.735  20.377  13.959  1.00 28.39           C  
ATOM    228  CZ  PHE A  47      20.175  19.995  12.742  1.00 27.78           C  
ATOM    229  N   ASP A  48      23.931  25.671  11.290  1.00 26.33           N  
ATOM    230  CA  ASP A  48      24.073  27.002  10.749  1.00 27.94           C  
ATOM    231  C   ASP A  48      22.707  27.673  10.935  1.00 28.16           C  
ATOM    232  O   ASP A  48      21.684  27.043  10.765  1.00 26.85           O  
ATOM    233  CB  ASP A  48      24.410  26.851   9.270  1.00 26.66           C  
ATOM    234  CG  ASP A  48      24.808  28.173   8.617  1.00 29.98           C  
ATOM    235  OD1 ASP A  48      23.895  28.973   8.236  1.00 26.15           O  
ATOM    236  OD2 ASP A  48      25.999  28.436   8.385  1.00 31.67           O  
ATOM    237  N   GLU A  49      22.712  28.976  11.242  1.00 28.46           N  
ATOM    238  CA  GLU A  49      21.458  29.710  11.340  1.00 28.17           C  
ATOM    239  C   GLU A  49      20.567  29.673  10.080  1.00 27.61           C  
ATOM    240  O   GLU A  49      19.387  29.933  10.215  1.00 29.27           O  
ATOM    241  CB  GLU A  49      21.760  31.187  11.775  1.00 28.61           C  
ATOM    242  CG  GLU A  49      22.516  31.973  10.749  1.00 29.13           C  
ATOM    243  CD  GLU A  49      24.023  31.932  10.889  1.00 34.59           C  
ATOM    244  OE1 GLU A  49      24.571  31.001  11.540  1.00 31.71           O  
ATOM    245  OE2 GLU A  49      24.651  32.849  10.300  1.00 34.88           O  
ATOM    246  N   ASN A  50      21.157  29.486   8.880  1.00 26.91           N  
ATOM    247  CA  ASN A  50      20.449  29.353   7.593  1.00 25.65           C  
ATOM    248  C   ASN A  50      20.330  27.908   7.066  1.00 25.72           C  
ATOM    249  O   ASN A  50      19.988  27.725   5.908  1.00 24.86           O  
ATOM    250  CB  ASN A  50      21.100  30.219   6.554  1.00 26.74           C  
ATOM    251  CG  ASN A  50      20.589  31.688   6.625  1.00 28.45           C  
ATOM    252  OD1 ASN A  50      21.385  32.656   6.813  1.00 28.57           O  
ATOM    253  ND2 ASN A  50      19.294  31.823   6.528  1.00 23.58           N  
ATOM    254  N   ALA A  51      20.488  26.926   7.974  1.00 25.83           N  
ATOM    255  CA  ALA A  51      20.274  25.485   7.647  1.00 25.12           C  
ATOM    256  C   ALA A  51      18.815  25.260   7.210  1.00 25.54           C  
ATOM    257  O   ALA A  51      17.892  25.931   7.715  1.00 25.75           O  
ATOM    258  CB  ALA A  51      20.586  24.619   8.822  1.00 26.45           C  
ATOM    259  N   SER A  52      18.628  24.258   6.364  1.00 25.34           N  
ATOM    260  CA  SER A  52      17.318  23.711   6.017  1.00 25.74           C  
ATOM    261  C   SER A  52      17.146  22.254   6.417  1.00 26.92           C  
ATOM    262  O   SER A  52      18.113  21.470   6.472  1.00 24.54           O  
ATOM    263  CB  SER A  52      17.125  23.788   4.518  1.00 27.58           C  
ATOM    264  OG  SER A  52      17.104  25.131   4.041  1.00 30.59           O  
ATOM    265  N   TRP A  53      15.905  21.870   6.656  1.00 25.48           N  
ATOM    266  CA  TRP A  53      15.522  20.521   6.947  1.00 26.03           C  
ATOM    267  C   TRP A  53      14.378  20.075   6.036  1.00 27.91           C  
ATOM    268  O   TRP A  53      13.398  20.799   5.847  1.00 30.05           O  
ATOM    269  CB  TRP A  53      15.144  20.397   8.406  1.00 27.98           C  
ATOM    270  CG  TRP A  53      15.163  19.000   8.924  1.00 28.66           C  
ATOM    271  CD1 TRP A  53      14.098  18.131   9.067  1.00 30.24           C  
ATOM    272  CD2 TRP A  53      16.308  18.323   9.429  1.00 28.43           C  
ATOM    273  NE1 TRP A  53      14.535  16.942   9.607  1.00 31.06           N  
ATOM    274  CE2 TRP A  53      15.884  17.033   9.843  1.00 29.12           C  
ATOM    275  CE3 TRP A  53      17.677  18.668   9.555  1.00 27.07           C  
ATOM    276  CZ2 TRP A  53      16.770  16.087  10.365  1.00 27.44           C  
ATOM    277  CZ3 TRP A  53      18.535  17.753  10.125  1.00 28.58           C  
ATOM    278  CH2 TRP A  53      18.080  16.476  10.520  1.00 27.09           C  
ATOM    279  N   HIS A  54      14.549  18.940   5.373  1.00 27.00           N  
ATOM    280  CA  HIS A  54      13.629  18.506   4.346  1.00 27.64           C  
ATOM    281  C   HIS A  54      12.918  17.227   4.780  1.00 28.74           C  
ATOM    282  O   HIS A  54      13.512  16.198   4.976  1.00 26.76           O  
ATOM    283  CB  HIS A  54      14.352  18.316   3.031  1.00 26.49           C  
ATOM    284  CG  HIS A  54      15.185  19.462   2.590  1.00 26.19           C  
ATOM    285  ND1 HIS A  54      14.688  20.485   1.810  1.00 26.62           N  
ATOM    286  CD2 HIS A  54      16.507  19.717   2.745  1.00 26.83           C  
ATOM    287  CE1 HIS A  54      15.673  21.330   1.525  1.00 30.46           C  
ATOM    288  NE2 HIS A  54      16.792  20.888   2.086  1.00 26.96           N  
ATOM    289  N   THR A  55      11.615  17.331   4.998  1.00 28.46           N  
ATOM    290  CA  THR A  55      10.797  16.217   5.358  1.00 28.95           C  
ATOM    291  C   THR A  55       9.896  15.827   4.187  1.00 29.80           C  
ATOM    292  O   THR A  55       9.072  16.655   3.681  1.00 28.79           O  
ATOM    293  CB  THR A  55       9.929  16.604   6.574  1.00 28.83           C  
ATOM    294  OG1 THR A  55      10.725  16.908   7.689  1.00 29.03           O  
ATOM    295  CG2 THR A  55       9.046  15.500   7.068  1.00 29.07           C  
ATOM    296  N   PRO A  56      10.006  14.594   3.743  1.00 30.61           N  
ATOM    297  CA  PRO A  56       9.250  14.180   2.591  1.00 30.23           C  
ATOM    298  C   PRO A  56       7.793  13.872   3.005  1.00 30.17           C  
ATOM    299  O   PRO A  56       7.458  13.800   4.201  1.00 28.81           O  
ATOM    300  CB  PRO A  56       9.962  12.929   2.115  1.00 30.67           C  
ATOM    301  CG  PRO A  56      10.446  12.320   3.444  1.00 31.56           C  
ATOM    302  CD  PRO A  56      10.847  13.501   4.293  1.00 28.88           C  
ATOM    303  N   GLY A  57       6.981  13.613   1.990  1.00 32.43           N  
ATOM    304  CA  GLY A  57       5.654  13.069   2.231  1.00 32.25           C  
ATOM    305  C   GLY A  57       4.550  14.091   2.160  1.00 35.46           C  
ATOM    306  O   GLY A  57       4.741  15.201   1.687  1.00 32.52           O  
ATOM    307  N   ARG A  58       3.393  13.666   2.627  1.00 37.48           N  
ATOM    308  CA  ARG A  58       2.184  14.459   2.427  1.00 40.79           C  
ATOM    309  C   ARG A  58       1.493  14.821   3.715  1.00 42.02           C  
ATOM    310  O   ARG A  58       0.379  15.271   3.676  1.00 45.95           O  
ATOM    311  CB  ARG A  58       1.260  13.702   1.475  1.00 40.93           C  
ATOM    312  CG  ARG A  58       1.731  13.900   0.031  1.00 42.31           C  
ATOM    313  CD  ARG A  58       1.103  12.995  -0.986  1.00 43.61           C  
ATOM    314  NE  ARG A  58       1.793  13.108  -2.274  1.00 45.63           N  
ATOM    315  CZ  ARG A  58       1.368  12.552  -3.409  1.00 47.41           C  
ATOM    316  NH1 ARG A  58       0.234  11.870  -3.425  1.00 48.14           N  
ATOM    317  NH2 ARG A  58       2.077  12.676  -4.524  1.00 47.33           N  
ATOM    318  N   SER A  59       2.134  14.658   4.853  1.00 41.28           N  
ATOM    319  CA  SER A  59       1.546  14.991   6.124  1.00 41.13           C  
ATOM    320  C   SER A  59       1.598  16.499   6.357  1.00 41.59           C  
ATOM    321  O   SER A  59       2.249  17.270   5.599  1.00 41.01           O  
ATOM    322  CB  SER A  59       2.308  14.280   7.265  1.00 40.10           C  
ATOM    323  OG  SER A  59       3.474  15.024   7.612  1.00 37.45           O  
ATOM    324  N   ARG A  60       0.961  16.904   7.445  1.00 44.01           N  
ATOM    325  CA  ARG A  60       0.937  18.311   7.831  1.00 44.56           C  
ATOM    326  C   ARG A  60       2.340  18.785   8.274  1.00 44.27           C  
ATOM    327  O   ARG A  60       2.600  19.996   8.316  1.00 44.57           O  
ATOM    328  CB  ARG A  60      -0.063  18.562   8.959  1.00 46.55           C  
ATOM    329  CG  ARG A  60      -0.561  20.059   9.000  1.00 49.36           C  
ATOM    330  CD  ARG A  60      -2.032  20.258   9.483  1.00 51.53           C  
ATOM    331  NE  ARG A  60      -2.322  21.621   9.966  1.00 57.58           N  
ATOM    332  CZ  ARG A  60      -2.498  22.680   9.174  1.00 60.41           C  
ATOM    333  NH1 ARG A  60      -2.380  22.567   7.854  1.00 64.73           N  
ATOM    334  NH2 ARG A  60      -2.762  23.853   9.695  1.00 59.26           N  
ATOM    335  N   ILE A  61       3.236  17.857   8.587  1.00 42.59           N  
ATOM    336  CA  ILE A  61       4.621  18.288   8.908  1.00 41.23           C  
ATOM    337  C   ILE A  61       5.677  18.126   7.803  1.00 39.59           C  
ATOM    338  O   ILE A  61       6.857  18.431   8.031  1.00 37.34           O  
ATOM    339  CB  ILE A  61       5.091  17.774  10.291  1.00 41.63           C  
ATOM    340  CG1 ILE A  61       5.091  16.245  10.454  1.00 41.22           C  
ATOM    341  CG2 ILE A  61       4.186  18.386  11.384  1.00 41.78           C  
ATOM    342  CD1 ILE A  61       6.149  15.475   9.679  1.00 42.32           C  
ATOM    343  N   ALA A  62       5.240  17.774   6.597  1.00 38.52           N  
ATOM    344  CA  ALA A  62       6.100  17.734   5.448  1.00 38.36           C  
ATOM    345  C   ALA A  62       6.591  19.092   5.005  1.00 38.35           C  
ATOM    346  O   ALA A  62       5.947  20.101   5.262  1.00 38.32           O  
ATOM    347  CB  ALA A  62       5.390  17.098   4.291  1.00 39.05           C  
ATOM    348  N   GLY A  63       7.699  19.091   4.269  1.00 35.02           N  
ATOM    349  CA  GLY A  63       8.170  20.251   3.542  1.00 35.61           C  
ATOM    350  C   GLY A  63       9.619  20.589   3.778  1.00 33.99           C  
ATOM    351  O   GLY A  63      10.303  19.909   4.558  1.00 31.64           O  
ATOM    352  N   ASP A  64      10.020  21.675   3.152  1.00 32.76           N  
ATOM    353  CA  ASP A  64      11.327  22.269   3.303  1.00 32.83           C  
ATOM    354  C   ASP A  64      11.175  23.315   4.378  1.00 33.54           C  
ATOM    355  O   ASP A  64      10.448  24.300   4.194  1.00 36.34           O  
ATOM    356  CB  ASP A  64      11.774  22.822   1.984  0.50 32.89           C  
ATOM    358  CG  ASP A  64      11.628  21.814   0.864  0.50 32.17           C  
ATOM    360  OD1 ASP A  64      12.080  20.599   0.973  0.50 26.03           O  
ATOM    362  OD2 ASP A  64      11.090  22.192  -0.202  0.50 31.32           O  
ATOM    364  N   HIS A  65      11.735  23.036   5.539  1.00 30.15           N  
ATOM    365  CA  HIS A  65      11.786  24.006   6.637  1.00 31.69           C  
ATOM    366  C   HIS A  65      13.131  24.758   6.513  1.00 31.24           C  
ATOM    367  O   HIS A  65      14.188  24.208   6.868  1.00 29.62           O  
ATOM    368  CB  HIS A  65      11.574  23.275   7.919  1.00 33.08           C  
ATOM    369  CG  HIS A  65      10.196  22.640   7.993  1.00 35.62           C  
ATOM    370  ND1 HIS A  65       9.960  21.308   7.716  1.00 40.96           N  
ATOM    371  CD2 HIS A  65       8.978  23.207   8.161  1.00 41.47           C  
ATOM    372  CE1 HIS A  65       8.658  21.065   7.796  1.00 38.27           C  
ATOM    373  NE2 HIS A  65       8.041  22.204   8.074  1.00 41.79           N  
ATOM    374  N   LYS A  66      13.084  25.999   6.033  1.00 31.80           N  
ATOM    375  CA  LYS A  66      14.287  26.822   5.812  1.00 31.34           C  
ATOM    376  C   LYS A  66      14.542  27.758   6.978  1.00 32.10           C  
ATOM    377  O   LYS A  66      13.625  28.541   7.413  1.00 30.34           O  
ATOM    378  CB  LYS A  66      14.131  27.596   4.512  1.00 33.27           C  
ATOM    379  CG  LYS A  66      15.229  28.667   4.273  1.00 34.72           C  
ATOM    380  CD  LYS A  66      16.605  28.113   4.029  1.00 36.56           C  
ATOM    381  CE  LYS A  66      17.690  29.242   3.889  1.00 37.48           C  
ATOM    382  NZ  LYS A  66      17.405  30.082   2.682  1.00 32.49           N  
ATOM    383  N   GLY A  67      15.777  27.718   7.486  1.00 30.31           N  
ATOM    384  CA  GLY A  67      16.208  28.466   8.645  1.00 29.46           C  
ATOM    385  C   GLY A  67      16.246  27.588   9.857  1.00 29.15           C  
ATOM    386  O   GLY A  67      15.310  26.815  10.130  1.00 28.67           O  
ATOM    387  N   ARG A  68      17.315  27.718  10.628  1.00 29.53           N  
ATOM    388  CA  ARG A  68      17.467  26.971  11.861  1.00 29.40           C  
ATOM    389  C   ARG A  68      16.278  27.085  12.816  1.00 29.99           C  
ATOM    390  O   ARG A  68      15.824  26.134  13.430  1.00 27.99           O  
ATOM    391  CB  ARG A  68      18.750  27.423  12.527  1.00 29.00           C  
ATOM    392  CG  ARG A  68      19.125  26.647  13.761  1.00 29.97           C  
ATOM    393  CD  ARG A  68      20.488  27.069  14.325  1.00 31.20           C  
ATOM    394  NE  ARG A  68      20.486  28.461  14.814  1.00 29.48           N  
ATOM    395  CZ  ARG A  68      21.588  29.139  15.106  1.00 31.75           C  
ATOM    396  NH1 ARG A  68      22.770  28.579  15.007  1.00 30.42           N  
ATOM    397  NH2 ARG A  68      21.518  30.391  15.525  1.00 28.94           N  
ATOM    398  N   GLU A  69      15.708  28.281  12.901  1.00 30.04           N  
ATOM    399  CA  GLU A  69      14.480  28.438  13.710  1.00 28.28           C  
ATOM    400  C   GLU A  69      13.306  27.548  13.246  1.00 28.41           C  
ATOM    401  O   GLU A  69      12.557  27.038  14.094  1.00 27.09           O  
ATOM    402  CB  GLU A  69      14.090  29.951  13.824  1.00 28.68           C  
ATOM    403  CG  GLU A  69      13.421  30.577  12.609  1.00 25.48           C  
ATOM    404  CD  GLU A  69      14.311  30.818  11.404  1.00 26.40           C  
ATOM    405  OE1 GLU A  69      15.556  30.749  11.522  1.00 29.81           O  
ATOM    406  OE2 GLU A  69      13.740  31.016  10.310  1.00 28.40           O  
ATOM    407  N   ALA A  70      13.159  27.363  11.922  1.00 28.57           N  
ATOM    408  CA  ALA A  70      12.097  26.554  11.317  1.00 28.55           C  
ATOM    409  C   ALA A  70      12.431  25.087  11.560  1.00 29.59           C  
ATOM    410  O   ALA A  70      11.561  24.286  11.863  1.00 28.87           O  
ATOM    411  CB  ALA A  70      12.024  26.825   9.859  1.00 28.53           C  
ATOM    412  N   ILE A  71      13.725  24.768  11.562  1.00 29.19           N  
ATOM    413  CA  ILE A  71      14.153  23.369  11.865  1.00 28.11           C  
ATOM    414  C   ILE A  71      13.759  23.027  13.265  1.00 28.06           C  
ATOM    415  O   ILE A  71      13.215  21.965  13.548  1.00 26.93           O  
ATOM    416  CB  ILE A  71      15.675  23.225  11.633  1.00 28.18           C  
ATOM    417  CG1 ILE A  71      16.005  23.496  10.139  1.00 26.02           C  
ATOM    418  CG2 ILE A  71      16.178  21.851  12.118  1.00 32.09           C  
ATOM    419  CD1 ILE A  71      17.477  23.291   9.820  1.00 26.88           C  
ATOM    420  N   PHE A  72      14.113  23.885  14.194  1.00 27.79           N  
ATOM    421  CA  PHE A  72      13.867  23.623  15.594  1.00 30.14           C  
ATOM    422  C   PHE A  72      12.370  23.637  15.972  1.00 30.51           C  
ATOM    423  O   PHE A  72      11.955  22.911  16.909  1.00 32.26           O  
ATOM    424  CB  PHE A  72      14.712  24.539  16.480  0.50 30.23           C  
ATOM    426  CG  PHE A  72      16.212  24.283  16.400  0.50 30.28           C  
ATOM    428  CD1 PHE A  72      16.759  23.190  15.698  0.50 32.11           C  
ATOM    430  CD2 PHE A  72      17.073  25.157  17.021  0.50 31.14           C  
ATOM    432  CE1 PHE A  72      18.128  22.995  15.675  0.50 30.95           C  
ATOM    434  CE2 PHE A  72      18.401  24.984  16.998  0.50 31.36           C  
ATOM    436  CZ  PHE A  72      18.961  23.911  16.341  0.50 30.71           C  
ATOM    438  N   ALA A  73      11.586  24.401  15.229  1.00 31.32           N  
ATOM    439  CA  ALA A  73      10.098  24.278  15.305  1.00 31.58           C  
ATOM    440  C   ALA A  73       9.632  22.884  14.864  1.00 31.64           C  
ATOM    441  O   ALA A  73       8.788  22.254  15.518  1.00 32.17           O  
ATOM    442  CB  ALA A  73       9.447  25.290  14.438  1.00 30.96           C  
ATOM    443  N   GLN A  74      10.196  22.394  13.771  1.00 31.14           N  
ATOM    444  CA  GLN A  74       9.913  21.002  13.342  1.00 31.14           C  
ATOM    445  C   GLN A  74      10.257  20.050  14.422  1.00 30.25           C  
ATOM    446  O   GLN A  74       9.457  19.154  14.756  1.00 31.33           O  
ATOM    447  CB  GLN A  74      10.658  20.657  12.039  1.00 30.64           C  
ATOM    448  CG  GLN A  74      10.387  19.295  11.394  1.00 30.46           C  
ATOM    449  CD  GLN A  74       9.015  19.165  10.731  1.00 34.25           C  
ATOM    450  OE1 GLN A  74       8.098  19.984  10.990  1.00 33.96           O  
ATOM    451  NE2 GLN A  74       8.904  18.248   9.773  1.00 27.98           N  
ATOM    452  N   PHE A  75      11.491  20.106  14.902  1.00 30.13           N  
ATOM    453  CA  PHE A  75      11.906  19.247  16.012  1.00 32.20           C  
ATOM    454  C   PHE A  75      10.965  19.360  17.239  1.00 34.36           C  
ATOM    455  O   PHE A  75      10.592  18.347  17.864  1.00 34.44           O  
ATOM    456  CB  PHE A  75      13.350  19.499  16.429  1.00 31.67           C  
ATOM    457  CG  PHE A  75      14.403  19.191  15.342  1.00 30.72           C  
ATOM    458  CD1 PHE A  75      14.087  18.467  14.195  1.00 31.82           C  
ATOM    459  CD2 PHE A  75      15.761  19.563  15.560  1.00 29.65           C  
ATOM    460  CE1 PHE A  75      15.064  18.190  13.207  1.00 29.56           C  
ATOM    461  CE2 PHE A  75      16.699  19.301  14.621  1.00 27.84           C  
ATOM    462  CZ  PHE A  75      16.383  18.591  13.430  1.00 30.20           C  
ATOM    463  N   GLY A  76      10.551  20.586  17.545  1.00 35.78           N  
ATOM    464  CA  GLY A  76       9.601  20.813  18.626  1.00 36.35           C  
ATOM    465  C   GLY A  76       8.270  20.126  18.382  1.00 37.19           C  
ATOM    466  O   GLY A  76       7.639  19.664  19.357  1.00 40.60           O  
ATOM    467  N   ARG A  77       7.840  20.017  17.129  1.00 37.65           N  
ATOM    468  CA  ARG A  77       6.604  19.279  16.810  1.00 38.23           C  
ATOM    469  C   ARG A  77       6.813  17.775  16.952  1.00 37.66           C  
ATOM    470  O   ARG A  77       5.921  17.049  17.416  1.00 37.97           O  
ATOM    471  CB  ARG A  77       6.076  19.604  15.416  1.00 37.84           C  
ATOM    472  CG  ARG A  77       5.509  21.014  15.267  1.00 40.85           C  
ATOM    473  CD  ARG A  77       4.816  21.239  13.988  1.00 43.28           C  
ATOM    474  NE  ARG A  77       5.762  21.439  12.906  1.00 47.95           N  
ATOM    475  CZ  ARG A  77       6.375  22.601  12.602  1.00 48.40           C  
ATOM    476  NH1 ARG A  77       6.114  23.738  13.279  1.00 48.89           N  
ATOM    477  NH2 ARG A  77       7.258  22.626  11.611  1.00 41.77           N  
ATOM    478  N   TYR A  78       7.976  17.279  16.524  1.00 36.55           N  
ATOM    479  CA  TYR A  78       8.303  15.873  16.705  1.00 36.07           C  
ATOM    480  C   TYR A  78       8.116  15.438  18.166  1.00 37.45           C  
ATOM    481  O   TYR A  78       7.464  14.450  18.446  1.00 37.16           O  
ATOM    482  CB  TYR A  78       9.746  15.549  16.234  1.00 33.62           C  
ATOM    483  CG  TYR A  78       9.987  15.582  14.744  1.00 29.26           C  
ATOM    484  CD1 TYR A  78       8.965  15.718  13.818  1.00 27.92           C  
ATOM    485  CD2 TYR A  78      11.274  15.476  14.255  1.00 31.05           C  
ATOM    486  CE1 TYR A  78       9.224  15.698  12.421  1.00 30.97           C  
ATOM    487  CE2 TYR A  78      11.531  15.504  12.920  1.00 29.89           C  
ATOM    488  CZ  TYR A  78      10.514  15.597  11.998  1.00 29.75           C  
ATOM    489  OH  TYR A  78      10.791  15.603  10.648  1.00 28.59           O  
ATOM    490  N   GLY A  79       8.738  16.143  19.083  1.00 38.44           N  
ATOM    491  CA  GLY A  79       8.616  15.841  20.505  1.00 40.05           C  
ATOM    492  C   GLY A  79       7.281  16.274  21.086  1.00 41.86           C  
ATOM    493  O   GLY A  79       6.634  15.487  21.785  1.00 42.16           O  
ATOM    494  N   GLY A  80       6.862  17.494  20.751  1.00 42.80           N  
ATOM    495  CA  GLY A  80       5.618  18.087  21.281  1.00 43.71           C  
ATOM    496  C   GLY A  80       4.383  17.258  21.029  1.00 44.65           C  
ATOM    497  O   GLY A  80       3.605  16.978  21.956  1.00 45.72           O  
ATOM    498  N   GLU A  81       4.235  16.822  19.787  1.00 44.53           N  
ATOM    499  CA  GLU A  81       3.060  16.106  19.335  1.00 44.77           C  
ATOM    500  C   GLU A  81       3.021  14.618  19.674  1.00 44.38           C  
ATOM    501  O   GLU A  81       2.058  13.947  19.319  1.00 45.01           O  
ATOM    502  CB  GLU A  81       2.886  16.285  17.839  1.00 44.31           C  
ATOM    503  CG  GLU A  81       2.632  17.724  17.476  1.00 47.06           C  
ATOM    504  CD  GLU A  81       2.197  17.897  16.050  1.00 47.78           C  
ATOM    505  OE1 GLU A  81       1.718  16.921  15.432  1.00 56.37           O  
ATOM    506  OE2 GLU A  81       2.350  19.023  15.535  1.00 55.23           O  
ATOM    507  N   THR A  82       4.040  14.116  20.358  1.00 43.00           N  
ATOM    508  CA  THR A  82       4.091  12.703  20.745  1.00 43.00           C  
ATOM    509  C   THR A  82       4.327  12.560  22.242  1.00 43.38           C  
ATOM    510  O   THR A  82       4.765  11.517  22.706  1.00 44.96           O  
ATOM    511  CB  THR A  82       5.224  11.966  19.971  1.00 41.75           C  
ATOM    512  OG1 THR A  82       6.495  12.486  20.370  1.00 37.72           O  
ATOM    513  CG2 THR A  82       5.131  12.232  18.487  1.00 38.45           C  
ATOM    514  N   GLY A  83       4.037  13.616  23.001  1.00 45.19           N  
ATOM    515  CA  GLY A  83       4.210  13.615  24.458  1.00 44.43           C  
ATOM    516  C   GLY A  83       5.620  13.285  24.819  1.00 44.55           C  
ATOM    517  O   GLY A  83       5.884  12.625  25.836  1.00 44.60           O  
ATOM    518  N   GLY A  84       6.550  13.751  23.972  1.00 43.03           N  
ATOM    519  CA  GLY A  84       7.949  13.496  24.184  1.00 41.73           C  
ATOM    520  C   GLY A  84       8.436  12.071  24.011  1.00 40.09           C  
ATOM    521  O   GLY A  84       9.529  11.756  24.440  1.00 40.87           O  
ATOM    522  N   THR A  85       7.651  11.221  23.368  1.00 40.55           N  
ATOM    523  CA  THR A  85       8.061   9.828  23.114  1.00 39.43           C  
ATOM    524  C   THR A  85       8.952   9.665  21.845  1.00 38.78           C  
ATOM    525  O   THR A  85       9.625   8.681  21.691  1.00 37.63           O  
ATOM    526  CB  THR A  85       6.857   8.908  22.951  1.00 39.37           C  
ATOM    527  OG1 THR A  85       6.008   9.343  21.883  1.00 38.20           O  
ATOM    528  CG2 THR A  85       5.943   8.882  24.230  1.00 41.37           C  
ATOM    529  N   PHE A  86       8.866  10.605  20.930  1.00 37.57           N  
ATOM    530  CA  PHE A  86       9.625  10.527  19.685  1.00 37.00           C  
ATOM    531  C   PHE A  86      11.118  10.369  19.986  1.00 36.76           C  
ATOM    532  O   PHE A  86      11.702  11.152  20.720  1.00 35.69           O  
ATOM    533  CB  PHE A  86       9.384  11.779  18.868  1.00 36.64           C  
ATOM    534  CG  PHE A  86       9.868  11.713  17.460  1.00 36.32           C  
ATOM    535  CD1 PHE A  86       9.003  11.423  16.452  1.00 33.59           C  
ATOM    536  CD2 PHE A  86      11.185  11.997  17.157  1.00 35.62           C  
ATOM    537  CE1 PHE A  86       9.418  11.382  15.138  1.00 35.93           C  
ATOM    538  CE2 PHE A  86      11.635  11.937  15.856  1.00 31.94           C  
ATOM    539  CZ  PHE A  86      10.742  11.659  14.830  1.00 33.56           C  
ATOM    540  N   LYS A  87      11.705   9.352  19.358  1.00 36.51           N  
ATOM    541  CA  LYS A  87      13.131   9.030  19.440  1.00 37.00           C  
ATOM    542  C   LYS A  87      13.712   8.734  18.085  1.00 35.47           C  
ATOM    543  O   LYS A  87      13.059   8.179  17.202  1.00 36.15           O  
ATOM    544  CB  LYS A  87      13.368   7.773  20.263  1.00 37.52           C  
ATOM    545  CG  LYS A  87      12.921   7.883  21.687  1.00 44.38           C  
ATOM    546  CD  LYS A  87      13.845   8.849  22.473  1.00 52.29           C  
ATOM    547  CE  LYS A  87      13.169  10.147  22.958  1.00 54.91           C  
ATOM    548  NZ  LYS A  87      12.169   9.921  24.064  1.00 55.29           N  
ATOM    549  N   ALA A  88      14.982   9.076  17.949  1.00 35.13           N  
ATOM    550  CA  ALA A  88      15.789   8.662  16.799  1.00 35.06           C  
ATOM    551  C   ALA A  88      16.899   7.747  17.247  1.00 35.73           C  
ATOM    552  O   ALA A  88      17.927   8.220  17.721  1.00 38.39           O  
ATOM    553  CB  ALA A  88      16.394   9.882  16.096  1.00 34.71           C  
ATOM    554  N   VAL A  89      16.713   6.444  17.070  1.00 35.29           N  
ATOM    555  CA  VAL A  89      17.715   5.450  17.473  1.00 33.67           C  
ATOM    556  C   VAL A  89      18.768   5.299  16.394  1.00 31.33           C  
ATOM    557  O   VAL A  89      18.504   4.723  15.358  1.00 30.22           O  
ATOM    558  CB  VAL A  89      17.042   4.089  17.750  1.00 35.95           C  
ATOM    559  CG1 VAL A  89      18.089   3.080  18.142  1.00 37.17           C  
ATOM    560  CG2 VAL A  89      16.029   4.291  18.885  1.00 39.92           C  
ATOM    561  N   LEU A  90      19.947   5.808  16.646  1.00 28.93           N  
ATOM    562  CA  LEU A  90      20.994   5.830  15.633  1.00 28.02           C  
ATOM    563  C   LEU A  90      21.639   4.461  15.454  1.00 27.81           C  
ATOM    564  O   LEU A  90      22.089   3.841  16.435  1.00 27.46           O  
ATOM    565  CB  LEU A  90      22.040   6.880  16.030  1.00 26.91           C  
ATOM    566  CG  LEU A  90      23.154   7.093  15.062  1.00 27.86           C  
ATOM    567  CD1 LEU A  90      22.675   7.572  13.619  1.00 28.72           C  
ATOM    568  CD2 LEU A  90      24.183   8.064  15.631  1.00 29.36           C  
ATOM    569  N   LEU A  91      21.679   3.992  14.228  1.00 26.94           N  
ATOM    570  CA  LEU A  91      22.187   2.694  13.934  1.00 29.58           C  
ATOM    571  C   LEU A  91      23.566   2.737  13.282  1.00 28.41           C  
ATOM    572  O   LEU A  91      24.437   1.993  13.649  1.00 27.92           O  
ATOM    573  CB  LEU A  91      21.201   1.986  13.007  1.00 29.43           C  
ATOM    574  CG  LEU A  91      19.845   1.666  13.604  1.00 32.70           C  
ATOM    575  CD1 LEU A  91      18.935   1.056  12.501  1.00 36.24           C  
ATOM    576  CD2 LEU A  91      19.910   0.723  14.799  1.00 36.51           C  
ATOM    577  N   HIS A  92      23.758   3.614  12.288  1.00 28.61           N  
ATOM    578  CA  HIS A  92      25.011   3.743  11.595  1.00 27.84           C  
ATOM    579  C   HIS A  92      25.267   5.160  11.115  1.00 26.02           C  
ATOM    580  O   HIS A  92      24.331   5.939  10.876  1.00 26.91           O  
ATOM    581  CB  HIS A  92      25.112   2.828  10.376  1.00 29.47           C  
ATOM    582  CG  HIS A  92      24.659   1.421  10.631  1.00 32.07           C  
ATOM    583  ND1 HIS A  92      25.484   0.487  11.186  1.00 33.86           N  
ATOM    584  CD2 HIS A  92      23.457   0.805  10.433  1.00 34.70           C  
ATOM    585  CE1 HIS A  92      24.818  -0.656  11.325  1.00 37.52           C  
ATOM    586  NE2 HIS A  92      23.595  -0.490  10.855  1.00 33.93           N  
ATOM    587  N   VAL A  93      26.545   5.502  11.048  1.00 25.47           N  
ATOM    588  CA  VAL A  93      26.982   6.802  10.533  1.00 26.35           C  
ATOM    589  C   VAL A  93      27.982   6.570   9.384  1.00 27.51           C  
ATOM    590  O   VAL A  93      28.991   5.895   9.541  1.00 27.83           O  
ATOM    591  CB  VAL A  93      27.595   7.710  11.594  1.00 26.39           C  
ATOM    592  CG1 VAL A  93      28.088   8.982  10.967  1.00 28.21           C  
ATOM    593  CG2 VAL A  93      26.660   7.978  12.686  1.00 28.03           C  
ATOM    594  N   LEU A  94      27.661   7.116   8.222  1.00 24.89           N  
ATOM    595  CA  LEU A  94      28.484   7.044   7.049  1.00 26.97           C  
ATOM    596  C   LEU A  94      28.985   8.433   6.597  1.00 26.96           C  
ATOM    597  O   LEU A  94      28.316   9.461   6.855  1.00 26.11           O  
ATOM    598  CB  LEU A  94      27.800   6.311   5.936  1.00 25.85           C  
ATOM    599  CG  LEU A  94      27.419   4.822   6.089  1.00 27.32           C  
ATOM    600  CD1 LEU A  94      26.180   4.753   6.971  1.00 32.37           C  
ATOM    601  CD2 LEU A  94      27.156   4.155   4.720  1.00 27.60           C  
ATOM    602  N   LYS A  95      30.136   8.454   5.912  1.00 26.68           N  
ATOM    603  CA  LYS A  95      30.840   9.689   5.523  1.00 29.26           C  
ATOM    604  C   LYS A  95      31.281   9.607   4.114  1.00 29.08           C  
ATOM    605  O   LYS A  95      31.777   8.553   3.644  1.00 29.28           O  
ATOM    606  CB  LYS A  95      32.200   9.855   6.306  1.00 31.39           C  
ATOM    607  CG  LYS A  95      32.101   9.934   7.734  1.00 34.94           C  
ATOM    608  CD  LYS A  95      33.519   9.807   8.399  1.00 33.49           C  
ATOM    609  CE  LYS A  95      33.953   8.348   8.616  1.00 41.43           C  
ATOM    610  NZ  LYS A  95      35.311   8.330   9.228  1.00 36.85           N  
ATOM    611  N   SER A  96      31.263  10.739   3.431  1.00 29.39           N  
ATOM    612  CA  SER A  96      31.969  10.833   2.190  1.00 32.22           C  
ATOM    613  C   SER A  96      33.306  11.491   2.510  1.00 34.52           C  
ATOM    614  O   SER A  96      33.493  12.167   3.547  1.00 33.67           O  
ATOM    615  CB  SER A  96      31.219  11.643   1.134  1.00 31.86           C  
ATOM    616  OG  SER A  96      31.050  12.977   1.567  1.00 36.13           O  
ATOM    617  N   ASP A  97      34.211  11.353   1.566  1.00 37.09           N  
ATOM    618  CA  ASP A  97      35.555  11.833   1.776  1.00 40.18           C  
ATOM    619  C   ASP A  97      35.442  13.324   1.918  1.00 41.37           C  
ATOM    620  O   ASP A  97      36.212  13.905   2.691  1.00 42.05           O  
ATOM    621  CB  ASP A  97      36.516  11.438   0.609  1.00 39.31           C  
ATOM    622  CG  ASP A  97      36.722   9.880   0.502  1.00 41.84           C  
ATOM    623  OD1 ASP A  97      36.638   9.140   1.557  1.00 40.34           O  
ATOM    624  OD2 ASP A  97      36.999   9.302  -0.582  1.00 38.46           O  
ATOM    625  N   ASP A  98      34.481  13.934   1.193  1.00 41.73           N  
ATOM    626  CA  ASP A  98      34.232  15.382   1.233  1.00 43.04           C  
ATOM    627  C   ASP A  98      33.387  15.957   2.442  1.00 42.26           C  
ATOM    628  O   ASP A  98      33.052  17.145   2.438  1.00 43.24           O  
ATOM    629  CB  ASP A  98      33.643  15.868  -0.109  1.00 43.53           C  
ATOM    630  CG  ASP A  98      32.201  15.394  -0.354  1.00 50.17           C  
ATOM    631  OD1 ASP A  98      31.472  14.880   0.534  1.00 56.62           O  
ATOM    632  OD2 ASP A  98      31.707  15.493  -1.497  1.00 51.31           O  
ATOM    633  N   GLY A  99      33.119  15.144   3.460  1.00 38.92           N  
ATOM    634  CA  GLY A  99      32.463  15.600   4.676  1.00 37.62           C  
ATOM    635  C   GLY A  99      30.919  15.561   4.747  1.00 35.02           C  
ATOM    636  O   GLY A  99      30.367  15.972   5.767  1.00 31.49           O  
ATOM    637  N   ARG A 100      30.242  15.124   3.668  1.00 31.94           N  
ATOM    638  CA  ARG A 100      28.815  14.755   3.756  1.00 31.31           C  
ATOM    639  C   ARG A 100      28.730  13.611   4.738  1.00 28.16           C  
ATOM    640  O   ARG A 100      29.631  12.743   4.771  1.00 25.32           O  
ATOM    641  CB  ARG A 100      28.294  14.247   2.430  1.00 32.00           C  
ATOM    642  CG  ARG A 100      27.051  14.839   1.888  1.00 37.75           C  
ATOM    643  CD  ARG A 100      26.940  14.803   0.286  1.00 37.51           C  
ATOM    644  NE  ARG A 100      26.379  16.024  -0.335  1.00 43.38           N  
ATOM    645  CZ  ARG A 100      27.072  16.948  -0.992  1.00 45.67           C  
ATOM    646  NH1 ARG A 100      28.387  16.843  -1.173  1.00 46.77           N  
ATOM    647  NH2 ARG A 100      26.442  17.974  -1.514  1.00 48.83           N  
ATOM    648  N   VAL A 101      27.614  13.522   5.462  1.00 24.68           N  
ATOM    649  CA  VAL A 101      27.412  12.452   6.446  1.00 24.68           C  
ATOM    650  C   VAL A 101      25.991  11.942   6.285  1.00 24.08           C  
ATOM    651  O   VAL A 101      25.090  12.751   6.015  1.00 23.57           O  
ATOM    652  CB  VAL A 101      27.598  12.958   7.864  1.00 25.55           C  
ATOM    653  CG1 VAL A 101      27.341  11.885   8.940  1.00 23.26           C  
ATOM    654  CG2 VAL A 101      29.026  13.519   8.078  1.00 26.78           C  
ATOM    655  N   ILE A 102      25.802  10.642   6.407  1.00 22.80           N  
ATOM    656  CA  ILE A 102      24.453  10.093   6.611  1.00 24.09           C  
ATOM    657  C   ILE A 102      24.362   9.428   7.979  1.00 24.81           C  
ATOM    658  O   ILE A 102      25.255   8.654   8.392  1.00 24.42           O  
ATOM    659  CB  ILE A 102      24.089   9.110   5.499  1.00 23.69           C  
ATOM    660  CG1 ILE A 102      23.811   9.890   4.227  1.00 22.61           C  
ATOM    661  CG2 ILE A 102      22.880   8.212   5.852  1.00 25.05           C  
ATOM    662  CD1 ILE A 102      23.696   8.993   2.949  1.00 24.43           C  
ATOM    663  N   GLY A 103      23.241   9.702   8.623  1.00 24.59           N  
ATOM    664  CA  GLY A 103      22.808   8.946   9.797  1.00 24.27           C  
ATOM    665  C   GLY A 103      21.722   7.967   9.324  1.00 24.86           C  
ATOM    666  O   GLY A 103      20.785   8.371   8.657  1.00 25.05           O  
ATOM    667  N   ILE A 104      21.914   6.674   9.581  1.00 24.39           N  
ATOM    668  CA  ILE A 104      20.828   5.656   9.452  1.00 24.18           C  
ATOM    669  C   ILE A 104      20.281   5.443  10.831  1.00 24.38           C  
ATOM    670  O   ILE A 104      21.018   5.062  11.762  1.00 25.74           O  
ATOM    671  CB  ILE A 104      21.335   4.299   8.903  1.00 24.71           C  
ATOM    672  CG1 ILE A 104      22.170   4.458   7.632  1.00 24.53           C  
ATOM    673  CG2 ILE A 104      20.166   3.331   8.677  1.00 25.80           C  
ATOM    674  CD1 ILE A 104      22.686   3.163   7.022  1.00 24.57           C  
ATOM    675  N   HIS A 105      18.979   5.580  10.969  1.00 26.42           N  
ATOM    676  CA  HIS A 105      18.295   5.479  12.258  1.00 26.86           C  
ATOM    677  C   HIS A 105      16.886   4.864  12.120  1.00 27.72           C  
ATOM    678  O   HIS A 105      16.376   4.657  11.015  1.00 28.52           O  
ATOM    679  CB  HIS A 105      18.252   6.782  13.015  1.00 26.76           C  
ATOM    680  CG  HIS A 105      17.261   7.787  12.458  1.00 27.26           C  
ATOM    681  ND1 HIS A 105      17.634   8.827  11.621  1.00 28.48           N  
ATOM    682  CD2 HIS A 105      15.928   7.919  12.643  1.00 30.48           C  
ATOM    683  CE1 HIS A 105      16.556   9.509  11.251  1.00 29.48           C  
ATOM    684  NE2 HIS A 105      15.506   8.998  11.885  1.00 29.53           N  
ATOM    685  N   ARG A 106      16.302   4.583  13.275  1.00 29.75           N  
ATOM    686  CA  ARG A 106      14.870   4.245  13.368  1.00 31.65           C  
ATOM    687  C   ARG A 106      14.186   5.274  14.264  1.00 31.21           C  
ATOM    688  O   ARG A 106      14.673   5.562  15.365  1.00 32.38           O  
ATOM    689  CB  ARG A 106      14.736   2.841  13.999  1.00 32.93           C  
ATOM    690  CG  ARG A 106      15.183   1.732  13.075  1.00 39.11           C  
ATOM    691  CD  ARG A 106      14.457   0.409  13.248  1.00 38.18           C  
ATOM    692  NE  ARG A 106      13.073   0.435  12.815  1.00 41.46           N  
ATOM    693  CZ  ARG A 106      12.632   0.216  11.569  1.00 39.63           C  
ATOM    694  NH1 ARG A 106      13.456   0.025  10.542  1.00 40.89           N  
ATOM    695  NH2 ARG A 106      11.366   0.235  11.342  1.00 41.14           N  
ATOM    696  N   ASN A 107      13.065   5.822  13.809  1.00 31.49           N  
ATOM    697  CA  ASN A 107      12.233   6.691  14.602  1.00 31.27           C  
ATOM    698  C   ASN A 107      11.092   5.867  15.206  1.00 33.23           C  
ATOM    699  O   ASN A 107      10.442   5.085  14.496  1.00 33.10           O  
ATOM    700  CB  ASN A 107      11.632   7.839  13.776  1.00 30.58           C  
ATOM    701  CG  ASN A 107      12.685   8.876  13.337  1.00 28.87           C  
ATOM    702  OD1 ASN A 107      12.733   9.276  12.177  1.00 31.03           O  
ATOM    703  ND2 ASN A 107      13.433   9.365  14.266  1.00 30.91           N  
ATOM    704  N   THR A 108      10.950   6.008  16.507  1.00 33.44           N  
ATOM    705  CA  THR A 108       9.827   5.435  17.236  1.00 35.90           C  
ATOM    706  C   THR A 108       9.115   6.518  18.011  1.00 36.83           C  
ATOM    707  O   THR A 108       9.702   7.536  18.405  1.00 35.42           O  
ATOM    708  CB  THR A 108      10.248   4.324  18.151  1.00 36.18           C  
ATOM    709  OG1 THR A 108      11.157   4.782  19.113  1.00 36.89           O  
ATOM    710  CG2 THR A 108      11.021   3.198  17.409  1.00 35.99           C  
ATOM    711  N   ALA A 109       7.815   6.325  18.219  1.00 38.81           N  
ATOM    712  CA  ALA A 109       7.031   7.337  18.923  1.00 39.94           C  
ATOM    713  C   ALA A 109       5.599   6.816  19.110  1.00 41.80           C  
ATOM    714  O   ALA A 109       5.208   5.878  18.436  1.00 40.70           O  
ATOM    715  CB  ALA A 109       6.963   8.593  18.101  1.00 39.15           C  
ATOM    716  N   GLU A 110       4.839   7.497  19.976  1.00 44.33           N  
ATOM    717  CA  GLU A 110       3.406   7.248  20.135  1.00 47.44           C  
ATOM    718  C   GLU A 110       2.648   8.554  20.041  1.00 48.04           C  
ATOM    719  O   GLU A 110       3.102   9.600  20.515  1.00 47.07           O  
ATOM    720  CB  GLU A 110       3.144   6.633  21.504  1.00 47.88           C  
ATOM    721  CG  GLU A 110       3.969   5.396  21.784  1.00 50.77           C  
ATOM    722  CD  GLU A 110       3.939   4.981  23.253  1.00 53.42           C  
ATOM    723  OE1 GLU A 110       4.437   3.846  23.522  1.00 60.56           O  
ATOM    724  OE2 GLU A 110       3.425   5.766  24.118  1.00 56.75           O  
ATOM    725  N   ARG A 111       1.474   8.474  19.449  1.00 49.79           N  
ATOM    726  CA  ARG A 111       0.617   9.637  19.304  1.00 51.98           C  
ATOM    727  C   ARG A 111      -0.834   9.181  19.194  1.00 52.62           C  
ATOM    728  O   ARG A 111      -1.216   8.529  18.209  1.00 54.47           O  
ATOM    729  CB  ARG A 111       1.000  10.381  18.046  1.00 52.02           C  
ATOM    730  CG  ARG A 111       0.536  11.762  18.023  1.00 55.07           C  
ATOM    731  CD  ARG A 111       0.988  12.515  16.796  1.00 55.20           C  
ATOM    732  NE  ARG A 111       0.147  12.121  15.683  1.00 57.82           N  
ATOM    733  CZ  ARG A 111      -0.727  12.900  15.069  1.00 57.62           C  
ATOM    734  NH1 ARG A 111      -0.887  14.177  15.407  1.00 59.93           N  
ATOM    735  NH2 ARG A 111      -1.421  12.402  14.066  1.00 59.27           N  
ATOM    736  N   GLY A 112      -1.635   9.524  20.195  1.00 53.61           N  
ATOM    737  CA  GLY A 112      -3.061   9.172  20.189  1.00 53.23           C  
ATOM    738  C   GLY A 112      -3.318   7.720  19.838  1.00 53.07           C  
ATOM    739  O   GLY A 112      -3.978   7.426  18.856  1.00 54.72           O  
ATOM    740  N   GLY A 113      -2.762   6.802  20.605  1.00 52.75           N  
ATOM    741  CA  GLY A 113      -2.958   5.375  20.302  1.00 52.26           C  
ATOM    742  C   GLY A 113      -2.317   4.800  19.029  1.00 52.39           C  
ATOM    743  O   GLY A 113      -2.481   3.592  18.743  1.00 53.00           O  
ATOM    744  N   LYS A 114      -1.579   5.609  18.262  1.00 50.83           N  
ATOM    745  CA  LYS A 114      -0.805   5.062  17.143  1.00 49.47           C  
ATOM    746  C   LYS A 114       0.654   4.983  17.534  1.00 47.83           C  
ATOM    747  O   LYS A 114       1.102   5.756  18.367  1.00 45.90           O  
ATOM    748  CB  LYS A 114      -0.909   5.924  15.893  1.00 50.76           C  
ATOM    749  CG  LYS A 114      -2.304   6.427  15.568  1.00 51.05           C  
ATOM    750  CD  LYS A 114      -2.480   6.600  14.057  1.00 51.27           C  
ATOM    751  CE  LYS A 114      -2.532   8.038  13.614  1.00 51.86           C  
ATOM    752  NZ  LYS A 114      -3.193   8.106  12.252  1.00 53.26           N  
ATOM    753  N   ARG A 115       1.370   4.039  16.916  1.00 46.55           N  
ATOM    754  CA  ARG A 115       2.772   3.812  17.201  1.00 44.99           C  
ATOM    755  C   ARG A 115       3.575   4.039  15.901  1.00 42.58           C  
ATOM    756  O   ARG A 115       3.141   3.690  14.814  1.00 41.18           O  
ATOM    757  CB  ARG A 115       2.950   2.429  17.820  1.00 47.10           C  
ATOM    758  CG  ARG A 115       4.376   1.849  17.940  1.00 50.40           C  
ATOM    759  CD  ARG A 115       5.537   2.840  18.258  1.00 58.40           C  
ATOM    760  NE  ARG A 115       6.628   2.251  19.063  1.00 59.21           N  
ATOM    761  CZ  ARG A 115       7.125   2.780  20.219  1.00 62.35           C  
ATOM    762  NH1 ARG A 115       6.725   3.962  20.690  1.00 63.92           N  
ATOM    763  NH2 ARG A 115       8.086   2.145  20.883  1.00 63.37           N  
ATOM    764  N   LEU A 116       4.704   4.732  16.036  1.00 39.82           N  
ATOM    765  CA  LEU A 116       5.637   4.936  14.919  1.00 38.39           C  
ATOM    766  C   LEU A 116       6.796   3.990  15.032  1.00 34.65           C  
ATOM    767  O   LEU A 116       7.345   3.807  16.095  1.00 33.47           O  
ATOM    768  CB  LEU A 116       6.176   6.363  14.941  1.00 37.50           C  
ATOM    769  CG  LEU A 116       7.089   6.705  13.762  1.00 37.01           C  
ATOM    770  CD1 LEU A 116       6.374   6.553  12.437  1.00 35.93           C  
ATOM    771  CD2 LEU A 116       7.547   8.141  13.980  1.00 38.69           C  
ATOM    772  N   ASP A 117       7.195   3.422  13.922  1.00 35.68           N  
ATOM    773  CA  ASP A 117       8.429   2.604  13.875  1.00 35.96           C  
ATOM    774  C   ASP A 117       8.855   2.513  12.438  1.00 35.26           C  
ATOM    775  O   ASP A 117       8.376   1.676  11.658  1.00 34.64           O  
ATOM    776  CB  ASP A 117       8.213   1.222  14.450  1.00 36.67           C  
ATOM    777  CG  ASP A 117       9.506   0.489  14.760  1.00 38.49           C  
ATOM    778  OD1 ASP A 117      10.619   0.795  14.249  1.00 41.07           O  
ATOM    779  OD2 ASP A 117       9.483  -0.449  15.565  1.00 48.99           O  
ATOM    780  N   VAL A 118       9.763   3.424  12.054  1.00 32.62           N  
ATOM    781  CA  VAL A 118      10.143   3.535  10.656  1.00 31.09           C  
ATOM    782  C   VAL A 118      11.658   3.746  10.537  1.00 28.88           C  
ATOM    783  O   VAL A 118      12.290   4.237  11.460  1.00 28.44           O  
ATOM    784  CB  VAL A 118       9.462   4.710   9.936  1.00 31.92           C  
ATOM    785  CG1 VAL A 118       7.992   4.463   9.754  1.00 37.92           C  
ATOM    786  CG2 VAL A 118       9.748   6.015  10.607  1.00 30.77           C  
ATOM    787  N   GLY A 119      12.232   3.283   9.443  1.00 26.99           N  
ATOM    788  CA  GLY A 119      13.683   3.447   9.248  1.00 28.34           C  
ATOM    789  C   GLY A 119      13.882   4.689   8.405  1.00 26.69           C  
ATOM    790  O   GLY A 119      13.058   5.029   7.548  1.00 25.80           O  
ATOM    791  N   CYS A 120      15.036   5.335   8.576  1.00 27.04           N  
ATOM    792  CA  CYS A 120      15.314   6.583   7.856  1.00 25.41           C  
ATOM    793  C   CYS A 120      16.819   6.731   7.610  1.00 24.00           C  
ATOM    794  O   CYS A 120      17.601   6.297   8.455  1.00 23.34           O  
ATOM    795  CB  CYS A 120      14.801   7.755   8.719  1.00 25.87           C  
ATOM    796  SG  CYS A 120      14.981   9.383   7.936  1.00 26.79           S  
ATOM    797  N   CYS A 121      17.197   7.271   6.450  1.00 22.92           N  
ATOM    798  CA  CYS A 121      18.555   7.849   6.231  1.00 24.06           C  
ATOM    799  C   CYS A 121      18.449   9.363   6.106  1.00 25.21           C  
ATOM    800  O   CYS A 121      17.706   9.873   5.243  1.00 25.11           O  
ATOM    801  CB  CYS A 121      19.154   7.317   4.972  1.00 23.62           C  
ATOM    802  SG  CYS A 121      19.394   5.522   4.898  1.00 27.12           S  
ATOM    803  N   ILE A 122      19.151  10.078   6.998  1.00 24.31           N  
ATOM    804  CA  ILE A 122      19.268  11.523   6.841  1.00 24.13           C  
ATOM    805  C   ILE A 122      20.554  11.858   6.201  1.00 23.98           C  
ATOM    806  O   ILE A 122      21.608  11.432   6.700  1.00 21.91           O  
ATOM    807  CB  ILE A 122      19.153  12.271   8.166  1.00 23.15           C  
ATOM    808  CG1 ILE A 122      17.816  11.996   8.866  1.00 25.96           C  
ATOM    809  CG2 ILE A 122      19.318  13.757   7.938  1.00 23.56           C  
ATOM    810  CD1 ILE A 122      17.799  12.573  10.275  1.00 26.25           C  
ATOM    811  N   VAL A 123      20.490  12.595   5.091  1.00 23.69           N  
ATOM    812  CA  VAL A 123      21.707  13.164   4.445  1.00 24.18           C  
ATOM    813  C   VAL A 123      21.967  14.535   5.050  1.00 24.83           C  
ATOM    814  O   VAL A 123      21.129  15.378   5.007  1.00 23.52           O  
ATOM    815  CB  VAL A 123      21.548  13.271   2.919  1.00 24.71           C  
ATOM    816  CG1 VAL A 123      22.761  13.909   2.285  1.00 25.26           C  
ATOM    817  CG2 VAL A 123      21.203  11.873   2.316  1.00 26.51           C  
ATOM    818  N   PHE A 124      23.146  14.712   5.653  1.00 23.90           N  
ATOM    819  CA  PHE A 124      23.645  15.962   6.236  1.00 24.82           C  
ATOM    820  C   PHE A 124      24.736  16.561   5.343  1.00 25.90           C  
ATOM    821  O   PHE A 124      25.731  15.918   4.982  1.00 25.79           O  
ATOM    822  CB  PHE A 124      24.273  15.696   7.599  1.00 25.23           C  
ATOM    823  CG  PHE A 124      23.328  15.129   8.631  1.00 26.23           C  
ATOM    824  CD1 PHE A 124      22.630  15.963   9.457  1.00 25.99           C  
ATOM    825  CD2 PHE A 124      23.205  13.740   8.845  1.00 23.06           C  
ATOM    826  CE1 PHE A 124      21.751  15.446  10.478  1.00 26.45           C  
ATOM    827  CE2 PHE A 124      22.358  13.262   9.804  1.00 23.30           C  
ATOM    828  CZ  PHE A 124      21.672  14.116  10.667  1.00 24.57           C  
ATOM    829  N   GLU A 125      24.555  17.835   5.057  1.00 26.43           N  
ATOM    830  CA  GLU A 125      25.551  18.648   4.378  1.00 28.12           C  
ATOM    831  C   GLU A 125      26.004  19.679   5.383  1.00 27.29           C  
ATOM    832  O   GLU A 125      25.182  20.203   6.187  1.00 24.90           O  
ATOM    833  CB  GLU A 125      24.878  19.339   3.169  1.00 29.73           C  
ATOM    834  CG  GLU A 125      24.401  18.424   2.089  1.00 30.84           C  
ATOM    835  CD  GLU A 125      23.743  19.181   0.919  1.00 36.80           C  
ATOM    836  OE1 GLU A 125      23.580  20.428   1.008  1.00 42.53           O  
ATOM    837  OE2 GLU A 125      23.431  18.514  -0.082  1.00 45.30           O  
ATOM    838  N   PHE A 126      27.291  20.025   5.295  1.00 26.90           N  
ATOM    839  CA  PHE A 126      27.971  20.882   6.226  1.00 28.70           C  
ATOM    840  C   PHE A 126      28.511  22.151   5.601  1.00 28.55           C  
ATOM    841  O   PHE A 126      28.920  22.132   4.429  1.00 27.86           O  
ATOM    842  CB  PHE A 126      29.109  20.049   6.863  1.00 28.72           C  
ATOM    843  CG  PHE A 126      28.591  19.017   7.819  1.00 25.53           C  
ATOM    844  CD1 PHE A 126      28.498  19.298   9.146  1.00 26.69           C  
ATOM    845  CD2 PHE A 126      28.107  17.783   7.360  1.00 31.53           C  
ATOM    846  CE1 PHE A 126      27.981  18.375  10.050  1.00 30.99           C  
ATOM    847  CE2 PHE A 126      27.588  16.887   8.266  1.00 30.06           C  
ATOM    848  CZ  PHE A 126      27.472  17.239   9.572  1.00 28.71           C  
ATOM    849  N   LYS A 127      28.549  23.203   6.399  1.00 31.68           N  
ATOM    850  CA  LYS A 127      29.241  24.446   6.071  1.00 32.15           C  
ATOM    851  C   LYS A 127      30.018  24.859   7.267  1.00 31.41           C  
ATOM    852  O   LYS A 127      29.495  25.127   8.346  1.00 29.26           O  
ATOM    853  CB  LYS A 127      28.268  25.549   5.644  1.00 33.57           C  
ATOM    854  CG  LYS A 127      28.921  26.866   5.244  1.00 36.05           C  
ATOM    855  CD  LYS A 127      27.866  27.983   5.152  1.00 37.96           C  
ATOM    856  CE  LYS A 127      28.528  29.365   4.843  1.00 44.16           C  
ATOM    857  NZ  LYS A 127      27.521  30.463   4.979  1.00 45.06           N  
ATOM    858  N   ASN A 128      31.324  24.921   7.094  1.00 34.65           N  
ATOM    859  CA  ASN A 128      32.199  25.295   8.232  1.00 34.50           C  
ATOM    860  C   ASN A 128      31.930  24.484   9.469  1.00 33.46           C  
ATOM    861  O   ASN A 128      31.877  24.973  10.580  1.00 33.81           O  
ATOM    862  CB  ASN A 128      32.102  26.780   8.487  1.00 36.23           C  
ATOM    863  CG  ASN A 128      32.700  27.574   7.314  1.00 40.09           C  
ATOM    864  OD1 ASN A 128      33.609  27.099   6.605  1.00 43.51           O  
ATOM    865  ND2 ASN A 128      32.120  28.700   7.043  1.00 45.24           N  
ATOM    866  N   GLY A 129      31.737  23.189   9.255  1.00 32.56           N  
ATOM    867  CA  GLY A 129      31.590  22.288  10.421  1.00 31.88           C  
ATOM    868  C   GLY A 129      30.223  22.233  11.065  1.00 31.46           C  
ATOM    869  O   GLY A 129      29.994  21.451  12.007  1.00 29.66           O  
ATOM    870  N   ARG A 130      29.298  23.071  10.578  1.00 29.44           N  
ATOM    871  CA  ARG A 130      27.939  23.033  11.089  1.00 29.19           C  
ATOM    872  C   ARG A 130      26.988  22.483  10.038  1.00 25.44           C  
ATOM    873  O   ARG A 130      27.234  22.577   8.880  1.00 25.66           O  
ATOM    874  CB  ARG A 130      27.485  24.431  11.486  1.00 28.61           C  
ATOM    875  CG  ARG A 130      28.260  24.984  12.668  1.00 32.92           C  
ATOM    876  CD  ARG A 130      27.670  26.305  13.254  1.00 33.98           C  
ATOM    877  NE  ARG A 130      27.613  27.350  12.265  1.00 37.20           N  
ATOM    878  CZ  ARG A 130      27.061  28.566  12.461  1.00 35.32           C  
ATOM    879  NH1 ARG A 130      26.456  28.841  13.581  1.00 36.12           N  
ATOM    880  NH2 ARG A 130      27.069  29.462  11.493  1.00 36.55           N  
ATOM    881  N   VAL A 131      25.861  21.937  10.456  1.00 25.94           N  
ATOM    882  CA  VAL A 131      24.891  21.388   9.471  1.00 25.19           C  
ATOM    883  C   VAL A 131      24.229  22.562   8.704  1.00 25.04           C  
ATOM    884  O   VAL A 131      23.741  23.523   9.356  1.00 25.99           O  
ATOM    885  CB  VAL A 131      23.796  20.557  10.216  1.00 24.30           C  
ATOM    886  CG1 VAL A 131      22.733  20.095   9.229  1.00 25.10           C  
ATOM    887  CG2 VAL A 131      24.407  19.334  10.863  1.00 26.85           C  
ATOM    888  N   ILE A 132      24.262  22.509   7.377  1.00 24.91           N  
ATOM    889  CA  ILE A 132      23.567  23.492   6.550  1.00 26.74           C  
ATOM    890  C   ILE A 132      22.279  22.897   5.946  1.00 26.40           C  
ATOM    891  O   ILE A 132      21.398  23.627   5.512  1.00 23.68           O  
ATOM    892  CB  ILE A 132      24.529  24.114   5.532  1.00 26.66           C  
ATOM    893  CG1 ILE A 132      23.894  25.298   4.796  1.00 31.14           C  
ATOM    894  CG2 ILE A 132      24.954  23.143   4.447  1.00 27.97           C  
ATOM    895  CD1 ILE A 132      23.622  26.449   5.653  1.00 29.67           C  
ATOM    896  N   ASP A 133      22.203  21.553   5.850  1.00 24.76           N  
ATOM    897  CA  ASP A 133      21.084  20.894   5.238  1.00 25.73           C  
ATOM    898  C   ASP A 133      20.937  19.462   5.729  1.00 26.27           C  
ATOM    899  O   ASP A 133      21.956  18.754   5.854  1.00 24.93           O  
ATOM    900  CB  ASP A 133      21.272  20.820   3.743  1.00 26.91           C  
ATOM    901  CG  ASP A 133      19.982  20.554   3.030  1.00 30.64           C  
ATOM    902  OD1 ASP A 133      19.258  21.557   2.720  1.00 26.63           O  
ATOM    903  OD2 ASP A 133      19.611  19.381   2.739  1.00 26.28           O  
ATOM    904  N   GLY A 134      19.724  19.092   6.083  1.00 24.48           N  
ATOM    905  CA  GLY A 134      19.384  17.738   6.436  1.00 24.62           C  
ATOM    906  C   GLY A 134      18.168  17.303   5.642  1.00 25.82           C  
ATOM    907  O   GLY A 134      17.224  18.060   5.470  1.00 24.82           O  
ATOM    908  N   ARG A 135      18.239  16.080   5.106  1.00 25.61           N  
ATOM    909  CA  ARG A 135      17.179  15.540   4.255  1.00 25.15           C  
ATOM    910  C   ARG A 135      16.847  14.160   4.678  1.00 24.54           C  
ATOM    911  O   ARG A 135      17.664  13.260   4.507  1.00 23.70           O  
ATOM    912  CB  ARG A 135      17.615  15.550   2.806  1.00 25.23           C  
ATOM    913  CG  ARG A 135      16.481  15.123   1.838  1.00 26.49           C  
ATOM    914  CD  ARG A 135      16.864  15.169   0.352  1.00 28.75           C  
ATOM    915  NE  ARG A 135      16.998  16.544  -0.082  1.00 30.78           N  
ATOM    916  CZ  ARG A 135      15.990  17.301  -0.561  1.00 33.18           C  
ATOM    917  NH1 ARG A 135      14.776  16.811  -0.703  1.00 29.35           N  
ATOM    918  NH2 ARG A 135      16.228  18.563  -0.890  1.00 32.19           N  
ATOM    919  N   GLU A 136      15.648  14.010   5.232  1.00 24.77           N  
ATOM    920  CA  GLU A 136      15.096  12.706   5.658  1.00 25.68           C  
ATOM    921  C   GLU A 136      14.679  11.850   4.448  1.00 26.28           C  
ATOM    922  O   GLU A 136      13.848  12.312   3.597  1.00 25.89           O  
ATOM    923  CB  GLU A 136      13.871  12.974   6.534  1.00 26.23           C  
ATOM    924  CG  GLU A 136      14.148  13.489   7.949  1.00 26.11           C  
ATOM    925  CD  GLU A 136      12.969  14.206   8.609  1.00 27.73           C  
ATOM    926  OE1 GLU A 136      12.053  14.611   7.915  1.00 28.82           O  
ATOM    927  OE2 GLU A 136      13.008  14.420   9.822  1.00 26.64           O  
ATOM    928  N   HIS A 137      15.115  10.580   4.433  1.00 24.67           N  
ATOM    929  CA  HIS A 137      14.670   9.623   3.481  1.00 26.69           C  
ATOM    930  C   HIS A 137      14.120   8.406   4.264  1.00 26.90           C  
ATOM    931  O   HIS A 137      14.881   7.539   4.701  1.00 23.89           O  
ATOM    932  CB  HIS A 137      15.797   9.084   2.571  1.00 26.85           C  
ATOM    933  CG  HIS A 137      16.513  10.123   1.762  1.00 24.33           C  
ATOM    934  ND1 HIS A 137      17.295  11.101   2.327  1.00 25.50           N  
ATOM    935  CD2 HIS A 137      16.581  10.304   0.425  1.00 24.65           C  
ATOM    936  CE1 HIS A 137      17.794  11.862   1.366  1.00 25.24           C  
ATOM    937  NE2 HIS A 137      17.378  11.395   0.199  1.00 27.40           N  
ATOM    938  N   PHE A 138      12.816   8.339   4.456  1.00 28.29           N  
ATOM    939  CA  PHE A 138      12.188   7.211   5.138  1.00 28.26           C  
ATOM    940  C   PHE A 138      12.049   6.053   4.167  1.00 28.62           C  
ATOM    941  O   PHE A 138      11.961   6.239   2.950  1.00 29.93           O  
ATOM    942  CB  PHE A 138      10.807   7.589   5.679  1.00 28.82           C  
ATOM    943  CG  PHE A 138      10.849   8.643   6.673  1.00 26.63           C  
ATOM    944  CD1 PHE A 138      11.160   8.324   7.983  1.00 25.45           C  
ATOM    945  CD2 PHE A 138      10.652   9.971   6.310  1.00 27.75           C  
ATOM    946  CE1 PHE A 138      11.253   9.304   8.980  1.00 28.09           C  
ATOM    947  CE2 PHE A 138      10.764  10.946   7.270  1.00 27.65           C  
ATOM    948  CZ  PHE A 138      11.048  10.609   8.622  1.00 28.10           C  
ATOM    949  N   TYR A 139      12.175   4.836   4.663  1.00 27.68           N  
ATOM    950  CA  TYR A 139      11.980   3.683   3.834  1.00 28.17           C  
ATOM    951  C   TYR A 139      10.474   3.585   3.594  1.00 28.42           C  
ATOM    952  O   TYR A 139      10.042   3.822   2.518  1.00 30.05           O  
ATOM    953  CB  TYR A 139      12.522   2.402   4.515  1.00 27.91           C  
ATOM    954  CG  TYR A 139      12.360   1.157   3.640  1.00 27.57           C  
ATOM    955  CD1 TYR A 139      13.189   0.911   2.557  1.00 25.94           C  
ATOM    956  CD2 TYR A 139      11.332   0.230   3.897  1.00 29.99           C  
ATOM    957  CE1 TYR A 139      13.022  -0.181   1.764  1.00 29.02           C  
ATOM    958  CE2 TYR A 139      11.152  -0.892   3.111  1.00 29.22           C  
ATOM    959  CZ  TYR A 139      11.992  -1.112   2.052  1.00 28.01           C  
ATOM    960  OH  TYR A 139      11.858  -2.207   1.251  1.00 29.42           O  
ATOM    961  N   ASP A 140       9.722   3.332   4.641  1.00 29.59           N  
ATOM    962  CA  ASP A 140       8.212   3.298   4.482  1.00 30.01           C  
ATOM    963  C   ASP A 140       7.596   4.683   4.796  1.00 29.12           C  
ATOM    964  O   ASP A 140       7.171   4.956   5.907  1.00 29.68           O  
ATOM    965  CB  ASP A 140       7.652   2.205   5.330  1.00 30.54           C  
ATOM    966  CG  ASP A 140       6.134   2.031   5.108  1.00 32.52           C  
ATOM    967  OD1 ASP A 140       5.583   2.740   4.261  1.00 32.99           O  
ATOM    968  OD2 ASP A 140       5.502   1.180   5.730  1.00 37.42           O  
ATOM    969  N   LEU A 141       7.615   5.544   3.800  1.00 29.70           N  
ATOM    970  CA  LEU A 141       7.116   6.933   3.947  1.00 30.99           C  
ATOM    971  C   LEU A 141       5.614   6.907   4.284  1.00 31.91           C  
ATOM    972  O   LEU A 141       5.116   7.724   5.022  1.00 31.92           O  
ATOM    973  CB  LEU A 141       7.346   7.678   2.646  1.00 30.18           C  
ATOM    974  CG  LEU A 141       6.935   9.162   2.611  1.00 30.91           C  
ATOM    975  CD1 LEU A 141       7.572   9.898   3.744  1.00 31.75           C  
ATOM    976  CD2 LEU A 141       7.229   9.743   1.287  1.00 31.02           C  
ATOM    977  N   TYR A 142       4.925   5.898   3.767  1.00 33.41           N  
ATOM    978  CA  TYR A 142       3.475   5.757   4.071  1.00 33.49           C  
ATOM    979  C   TYR A 142       3.204   5.567   5.546  1.00 33.46           C  
ATOM    980  O   TYR A 142       2.253   6.141   6.103  1.00 35.80           O  
ATOM    981  CB  TYR A 142       2.865   4.521   3.383  0.50 33.18           C  
ATOM    983  CG  TYR A 142       2.725   4.637   1.912  0.50 33.10           C  
ATOM    985  CD1 TYR A 142       1.523   5.075   1.326  0.50 33.45           C  
ATOM    987  CD2 TYR A 142       3.762   4.265   1.075  0.50 33.04           C  
ATOM    989  CE1 TYR A 142       1.397   5.160  -0.049  0.50 31.71           C  
ATOM    991  CE2 TYR A 142       3.652   4.354  -0.263  0.50 31.72           C  
ATOM    993  CZ  TYR A 142       2.472   4.788  -0.838  0.50 34.25           C  
ATOM    995  OH  TYR A 142       2.439   4.845  -2.210  0.50 32.82           O  
ATOM    997  N   ALA A 143       4.008   4.764   6.225  1.00 32.45           N  
ATOM    998  CA  ALA A 143       3.912   4.607   7.646  1.00 32.93           C  
ATOM    999  C   ALA A 143       4.121   5.883   8.409  1.00 33.19           C  
ATOM   1000  O   ALA A 143       3.434   6.171   9.434  1.00 31.40           O  
ATOM   1001  CB  ALA A 143       4.887   3.544   8.168  1.00 32.82           C  
ATOM   1002  N   TRP A 144       5.115   6.674   7.948  1.00 32.22           N  
ATOM   1003  CA  TRP A 144       5.354   7.957   8.623  1.00 32.87           C  
ATOM   1004  C   TRP A 144       4.146   8.854   8.443  1.00 32.27           C  
ATOM   1005  O   TRP A 144       3.662   9.459   9.414  1.00 34.74           O  
ATOM   1006  CB  TRP A 144       6.605   8.590   7.999  1.00 31.77           C  
ATOM   1007  CG  TRP A 144       6.899  10.015   8.254  1.00 28.65           C  
ATOM   1008  CD1 TRP A 144       6.603  11.035   7.455  1.00 31.04           C  
ATOM   1009  CD2 TRP A 144       7.664  10.541   9.321  1.00 32.47           C  
ATOM   1010  NE1 TRP A 144       7.118  12.208   7.954  1.00 31.47           N  
ATOM   1011  CE2 TRP A 144       7.761  11.941   9.121  1.00 29.72           C  
ATOM   1012  CE3 TRP A 144       8.282   9.984  10.435  1.00 30.19           C  
ATOM   1013  CZ2 TRP A 144       8.484  12.785   9.974  1.00 31.73           C  
ATOM   1014  CZ3 TRP A 144       8.965  10.824  11.300  1.00 31.91           C  
ATOM   1015  CH2 TRP A 144       9.044  12.206  11.081  1.00 30.79           C  
ATOM   1016  N   ASP A 145       3.676   8.952   7.223  1.00 33.49           N  
ATOM   1017  CA  ASP A 145       2.517   9.813   6.960  1.00 35.62           C  
ATOM   1018  C   ASP A 145       1.254   9.362   7.695  1.00 38.39           C  
ATOM   1019  O   ASP A 145       0.487  10.218   8.207  1.00 37.73           O  
ATOM   1020  CB  ASP A 145       2.224   9.956   5.501  1.00 34.60           C  
ATOM   1021  CG  ASP A 145       3.125  10.955   4.818  1.00 36.39           C  
ATOM   1022  OD1 ASP A 145       3.851  11.697   5.519  1.00 38.17           O  
ATOM   1023  OD2 ASP A 145       3.132  11.092   3.593  1.00 40.93           O  
ATOM   1024  N   GLU A 146       1.030   8.055   7.698  1.00 40.02           N  
ATOM   1025  CA  GLU A 146      -0.050   7.488   8.501  1.00 40.79           C  
ATOM   1026  C   GLU A 146       0.024   7.875   9.975  1.00 42.12           C  
ATOM   1027  O   GLU A 146      -0.988   8.306  10.529  1.00 42.97           O  
ATOM   1028  CB  GLU A 146      -0.123   5.981   8.356  1.00 41.80           C  
ATOM   1029  CG  GLU A 146      -1.024   5.302   9.396  1.00 44.59           C  
ATOM   1030  CD  GLU A 146      -2.497   5.712   9.328  1.00 52.17           C  
ATOM   1031  OE1 GLU A 146      -2.981   6.113   8.225  1.00 52.56           O  
ATOM   1032  OE2 GLU A 146      -3.178   5.593  10.393  1.00 57.54           O  
ATOM   1033  N   PHE A 147       1.190   7.736  10.624  1.00 40.75           N  
ATOM   1034  CA  PHE A 147       1.359   8.161  12.012  1.00 40.33           C  
ATOM   1035  C   PHE A 147       0.995   9.631  12.274  1.00 40.37           C  
ATOM   1036  O   PHE A 147       0.494   9.951  13.360  1.00 40.23           O  
ATOM   1037  CB  PHE A 147       2.823   7.926  12.454  1.00 39.78           C  
ATOM   1038  CG  PHE A 147       3.145   8.347  13.856  1.00 39.43           C  
ATOM   1039  CD1 PHE A 147       2.829   7.530  14.926  1.00 36.39           C  
ATOM   1040  CD2 PHE A 147       3.816   9.535  14.111  1.00 38.23           C  
ATOM   1041  CE1 PHE A 147       3.120   7.878  16.209  1.00 37.45           C  
ATOM   1042  CE2 PHE A 147       4.125   9.895  15.423  1.00 39.51           C  
ATOM   1043  CZ  PHE A 147       3.774   9.051  16.477  1.00 39.22           C  
ATOM   1044  N   TRP A 148       1.322  10.514  11.326  1.00 40.48           N  
ATOM   1045  CA  TRP A 148       1.161  11.958  11.483  1.00 42.70           C  
ATOM   1046  C   TRP A 148      -0.201  12.449  11.031  1.00 44.96           C  
ATOM   1047  O   TRP A 148      -0.492  13.645  11.095  1.00 46.22           O  
ATOM   1048  CB  TRP A 148       2.236  12.729  10.681  1.00 41.49           C  
ATOM   1049  CG  TRP A 148       3.624  12.615  11.371  1.00 39.87           C  
ATOM   1050  CD1 TRP A 148       4.688  11.937  10.920  1.00 40.47           C  
ATOM   1051  CD2 TRP A 148       3.986  13.117  12.652  1.00 40.45           C  
ATOM   1052  NE1 TRP A 148       5.722  11.994  11.823  1.00 39.73           N  
ATOM   1053  CE2 TRP A 148       5.326  12.726  12.899  1.00 38.85           C  
ATOM   1054  CE3 TRP A 148       3.338  13.901  13.618  1.00 42.47           C  
ATOM   1055  CZ2 TRP A 148       6.021  13.091  14.037  1.00 37.77           C  
ATOM   1056  CZ3 TRP A 148       4.038  14.260  14.775  1.00 41.74           C  
ATOM   1057  CH2 TRP A 148       5.369  13.866  14.972  1.00 40.67           C  
ATOM   1058  N   ARG A 149      -0.984  11.559  10.458  1.00 47.52           N  
ATOM   1059  CA  ARG A 149      -2.295  11.916   9.911  1.00 49.51           C  
ATOM   1060  C   ARG A 149      -3.160  12.554  11.010  1.00 49.75           C  
ATOM   1061  O   ARG A 149      -3.188  12.012  12.132  1.00 50.47           O  
ATOM   1062  CB  ARG A 149      -2.939  10.629   9.415  1.00 50.14           C  
ATOM   1063  CG  ARG A 149      -4.115  10.810   8.524  1.00 53.05           C  
ATOM   1064  CD  ARG A 149      -5.040   9.586   8.546  1.00 56.80           C  
ATOM   1065  NE  ARG A 149      -4.679   8.630   7.515  1.00 64.12           N  
ATOM   1066  CZ  ARG A 149      -5.238   8.581   6.303  1.00 68.00           C  
ATOM   1067  NH1 ARG A 149      -6.200   9.451   5.947  1.00 70.05           N  
ATOM   1068  NH2 ARG A 149      -4.818   7.647   5.430  1.00 68.03           N  
TER    1069      ARG A 149                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
