
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  121 (  926),  selected  121 , name 1k41_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1k41_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     2_A      M       1           -
LGA    L     3_A      M       2           -
LGA    P     4_A      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    T     5_A      S       6          5.458
LGA    A     6_A      D       7          3.900
LGA    Q     7_A      -       -           -
LGA    E     8_A      N       8          2.845
LGA    V     9_A      T       9          2.654
LGA    Q    10_A      L      10          2.623
LGA    G    11_A      K      11          2.554
LGA    L    12_A      V      12          2.543
LGA    M    13_A      A      13          2.547
LGA    A    14_A      H      14          2.563
LGA    R    15_A      Q      15          2.717
LGA    Y    16_A      G      16          2.461
LGA    I    17_A      F      17          2.811
LGA    E    18_A      E      18          1.981
LGA    L    19_A      F      19          1.901
LGA    V    20_A      F      20          2.703
LGA    D    21_A      T      21          2.966
LGA    V    22_A      Q      22          2.686
LGA    G    23_A      G      23          2.615
LGA    -       -      L      24           -
LGA    -       -      A      25           -
LGA    -       -      T      26           -
LGA    -       -      G      27           -
LGA    D    24_A      E      28          3.170
LGA    I    25_A      W      29          0.558
LGA    E    26_A      Q      30          0.296
LGA    A    27_A      K      31          0.564
LGA    I    28_A      F      32          0.552
LGA    V    29_A      L      33          0.531
LGA    Q    30_A      D      34          1.185
LGA    M    31_A      M      35          1.429
LGA    Y    32_A      L      36          1.085
LGA    A    33_A      T      37          0.814
LGA    D    34_A      E      38          1.022
LGA    D    35_A      D      39          1.127
LGA    A    36_A      F      40          0.768
LGA    T    37_A      T      41          0.298
LGA    V    38_A      F      42          0.213
LGA    E    39_A      W      43          0.491
LGA    D    40_A      F      44          1.575
LGA    P    41_A      P      45          2.399
LGA    F    42_A      M      46           -
LGA    G    43_A      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    Q    44_A      H      50          2.761
LGA    P    45_A      G      51          2.003
LGA    P    46_A      L      52          1.834
LGA    I    47_A      N      53          1.769
LGA    H    48_A      V      54          0.977
LGA    G    49_A      G      55          0.672
LGA    R    50_A      K      56          0.801
LGA    E    51_A      E      57          0.830
LGA    Q    52_A      R      58          0.654
LGA    I    53_A      A      59          0.512
LGA    A    54_A      K      60          0.909
LGA    A    55_A      E      61          1.050
LGA    F    56_A      F      62          0.699
LGA    S    57_A      F      63          0.817
LGA    R    58_A      T      64          1.377
LGA    Q    59_A      Y      65          1.640
LGA    G    60_A      V      66          1.061
LGA    -       -      S      67           -
LGA    -       -      E      68           -
LGA    -       -      S      69           -
LGA    -       -      F      70           -
LGA    -       -      H      71           -
LGA    -       -      T      72           -
LGA    K    65_A      G      73          1.618
LGA    V    66_A      I      74          1.574
LGA    R    67_A      Q      75          1.876
LGA    A    68_A      I      76          2.772
LGA    C    69_A      S      77          4.536
LGA    L    70_A      S      78          4.591
LGA    T    71_A      L      79          1.983
LGA    G    72_A      D      80          1.797
LGA    P    73_A      R      81          3.721
LGA    V    74_A      V      82          1.764
LGA    R    75_A      T      83          0.871
LGA    A    76_A      S      84          1.632
LGA    S    77_A      N      85          0.825
LGA    H    78_A      E      86          2.424
LGA    N    79_A      -       -           -
LGA    G    80_A      T      87          1.420
LGA    C    81_A      T      88          1.247
LGA    G    82_A      V      89          1.150
LGA    A    83_A      V      90          0.884
LGA    M    84_A      F      91          1.135
LGA    P    85_A      E      92          0.791
LGA    F    86_A      F      93          1.574
LGA    R    87_A      R      94          2.369
LGA    V    88_A      D      95          2.570
LGA    E    89_A      E      96          1.196
LGA    M    90_A      G      97          1.646
LGA    V    91_A      L      98          1.399
LGA    W    92_A      F      99          2.999
LGA    N    93_A      L     100          2.241
LGA    G    94_A      G     101          1.420
LGA    Q    95_A      K     102          1.699
LGA    P    96_A      P     103          1.857
LGA    C    97_A      Y     104          1.619
LGA    A    98_A      K     105          1.143
LGA    L    99_A      N     106          1.622
LGA    D   100_A      R     107          0.978
LGA    V   101_A      V     108          0.625
LGA    I   102_A      A     109          0.647
LGA    D   103_A      V     110          1.081
LGA    V   104_A      S     111          1.410
LGA    M   105_A      F     112          1.264
LGA    R   106_A      D     113          1.087
LGA    F   107_A      V     114          1.035
LGA    D   108_A      R     115          1.374
LGA    E   109_A      G     116          3.465
LGA    H   110_A      -       -           -
LGA    G   111_A      D     117          2.567
LGA    R   112_A      K     118          1.666
LGA    I   113_A      I     119          1.379
LGA    Q   114_A      C     120          1.253
LGA    T   115_A      S     121          1.174
LGA    M   116_A      Y     122          1.038
LGA    Q   117_A      R     123          0.715
LGA    A   118_A      E     124          0.690
LGA    Y   119_A      Y     125          0.875
LGA    W   120_A      F     126          1.041
LGA    S   121_A      -       -           -
LGA    E   122_A      G     127           #
LGA    V   123_A      S     128          3.413
LGA    N   124_A      D     129          4.019
LGA    L   125_A      G     130          1.873
LGA    S   126_A      K     131          2.483
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  121  133    5.0    111    1.99    16.22     72.870     5.319

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.126575 * X  +   0.985712 * Y  +   0.111133 * Z  + -21.153193
  Y_new =   0.548862 * X  +   0.023727 * Y  +  -0.835576 * Z  +  12.108827
  Z_new =  -0.826275 * X  +   0.166760 * Y  +  -0.538016 * Z  +  31.981745 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.841029   -0.300563  [ DEG:   162.7790    -17.2210 ]
  Theta =   0.972461    2.169132  [ DEG:    55.7179    124.2821 ]
  Phi   =   1.344144   -1.797448  [ DEG:    77.0138   -102.9862 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k41_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k41_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  121  133   5.0  111   1.99   16.22  72.870
REMARK  ---------------------------------------------------------- 
MOLECULE 1k41_A
HEADER    ISOMERASE                               05-OCT-01   1K41              
TITLE     CRYSTAL STRUCTURE OF KSI Y57S MUTANT                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: KETOSTEROID ISOMERASE;                                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: STEROID DELTA-ISOMERASE;                                    
COMPND   5 EC: 5.3.3.1;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    KSI Y57S HELIX                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.S.CHA,B.H.OH,G.H.NAM,D.S.JANG,T.H.LEE,K.Y.CHOI                      
REVDAT   1   16-OCT-02 1K41    0                                                
JRNL        AUTH   G.H.NAM,D.S.JANG,S.S.CHA,T.H.LEE,D.H.KIM,B.H.HONG,           
JRNL        AUTH 2 Y.S.YUN,B.H.OH,K.Y.CHOI                                      
JRNL        TITL   MAINTENANCE OF ALPHA-HELICAL STRUCTURES BY PHENYL            
JRNL        TITL 2 RINGS IN THE ACTIVE-SITE TYROSINE TRIAD                      
JRNL        TITL 3 CONTRIBUTES TO CATALYSIS AND STABILITY OF                    
JRNL        TITL 4 KETOSTEROID ISOMERASE FROM PSEUDOMONAS PUTIDA                
JRNL        TITL 5 BIOTYPE B                                                    
JRNL        REF    BIOCHEMISTRY                  V.  40 13529 2001              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  1K41 A    1   131  UNP    P07445   SDIS_PSEPU       1    131             
DBREF  1K41 B  201   331  UNP    P07445   SDIS_PSEPU       1    131             
SEQRES   1 A  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 A  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 A  131  ALA ILE VAL GLN MET TYR ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 A  131  ASP PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 A  131  ILE ALA ALA PHE SER ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 A  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 A  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 A  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 A  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 A  131  ALA TYR TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 A  131  GLN                                                          
SEQRES   1 B  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 B  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 B  131  ALA ILE VAL GLN MET TYR ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 B  131  ASP PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 B  131  ILE ALA ALA PHE SER ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 B  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 B  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 B  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 B  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 B  131  ALA TYR TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 B  131  GLN                                                          
FORMUL   3  HOH   *41(H2 O)                                                     
CRYST1   88.889   73.135   51.156  90.00  89.85  90.00 C 1 2 1       8          
ATOM      1  N   ASN A   2      34.332  23.104   1.745  1.00 89.57           N  
ATOM      2  CA  ASN A   2      34.374  21.737   2.344  1.00 88.93           C  
ATOM      3  C   ASN A   2      34.777  21.792   3.819  1.00 85.10           C  
ATOM      4  O   ASN A   2      33.924  21.952   4.688  1.00 87.46           O  
ATOM      5  CB  ASN A   2      35.349  20.851   1.558  1.00 88.15           C  
ATOM      6  N   LEU A   3      36.076  21.655   4.081  1.00 81.88           N  
ATOM      7  CA  LEU A   3      36.651  21.687   5.428  1.00 74.81           C  
ATOM      8  C   LEU A   3      36.570  20.385   6.247  1.00 64.44           C  
ATOM      9  O   LEU A   3      37.537  19.620   6.267  1.00 67.14           O  
ATOM     10  CB  LEU A   3      36.077  22.864   6.230  1.00 79.33           C  
ATOM     11  N   PRO A   4      35.440  20.109   6.933  1.00 51.35           N  
ATOM     12  CA  PRO A   4      35.455  18.850   7.691  1.00 41.71           C  
ATOM     13  C   PRO A   4      35.937  17.633   6.901  1.00 37.25           C  
ATOM     14  O   PRO A   4      35.518  17.401   5.766  1.00 34.23           O  
ATOM     15  CB  PRO A   4      34.009  18.698   8.183  1.00 35.35           C  
ATOM     16  CG  PRO A   4      33.213  19.711   7.419  1.00 41.09           C  
ATOM     17  CD  PRO A   4      34.156  20.813   7.098  1.00 42.11           C  
ATOM     18  N   THR A   5      36.836  16.871   7.515  1.00 29.95           N  
ATOM     19  CA  THR A   5      37.382  15.673   6.900  1.00 29.14           C  
ATOM     20  C   THR A   5      36.339  14.582   7.044  1.00 35.17           C  
ATOM     21  O   THR A   5      35.434  14.709   7.865  1.00 39.98           O  
ATOM     22  CB  THR A   5      38.704  15.207   7.597  1.00 27.94           C  
ATOM     23  OG1 THR A   5      38.426  14.742   8.928  1.00 18.15           O  
ATOM     24  CG2 THR A   5      39.712  16.347   7.663  1.00 36.02           C  
ATOM     25  N   ALA A   6      36.455  13.521   6.245  1.00 26.87           N  
ATOM     26  CA  ALA A   6      35.515  12.406   6.307  1.00 19.29           C  
ATOM     27  C   ALA A   6      35.364  11.899   7.735  1.00 12.70           C  
ATOM     28  O   ALA A   6      34.259  11.615   8.178  1.00 14.33           O  
ATOM     29  CB  ALA A   6      35.996  11.280   5.419  1.00 19.47           C  
ATOM     30  N   GLN A   7      36.484  11.786   8.444  1.00 20.59           N  
ATOM     31  CA  GLN A   7      36.502  11.309   9.828  1.00 30.69           C  
ATOM     32  C   GLN A   7      35.802  12.275  10.769  1.00 37.62           C  
ATOM     33  O   GLN A   7      35.284  11.879  11.812  1.00 34.03           O  
ATOM     34  CB  GLN A   7      37.942  11.121  10.300  1.00 38.68           C  
ATOM     35  CG  GLN A   7      38.493   9.725  10.090  1.00 51.35           C  
ATOM     36  CD  GLN A   7      39.998   9.679  10.249  1.00 61.77           C  
ATOM     37  OE1 GLN A   7      40.744   9.756   9.269  1.00 51.67           O  
ATOM     38  NE2 GLN A   7      40.457   9.560  11.493  1.00 68.97           N  
ATOM     39  N   GLU A   8      35.815  13.552  10.401  1.00 43.38           N  
ATOM     40  CA  GLU A   8      35.171  14.588  11.192  1.00 38.05           C  
ATOM     41  C   GLU A   8      33.668  14.506  10.958  1.00 33.11           C  
ATOM     42  O   GLU A   8      32.892  14.500  11.907  1.00 41.87           O  
ATOM     43  CB  GLU A   8      35.704  15.964  10.791  1.00 51.94           C  
ATOM     44  CG  GLU A   8      36.952  16.386  11.559  1.00 68.20           C  
ATOM     45  CD  GLU A   8      37.820  17.364  10.787  1.00 82.66           C  
ATOM     46  OE1 GLU A   8      39.061  17.206  10.817  1.00 94.92           O  
ATOM     47  OE2 GLU A   8      37.266  18.290  10.154  1.00 87.40           O  
ATOM     48  N   VAL A   9      33.261  14.430   9.694  1.00 14.29           N  
ATOM     49  CA  VAL A   9      31.848  14.309   9.350  1.00 11.81           C  
ATOM     50  C   VAL A   9      31.225  13.238  10.222  1.00 14.48           C  
ATOM     51  O   VAL A   9      30.224  13.470  10.886  1.00 26.25           O  
ATOM     52  CB  VAL A   9      31.662  13.890   7.879  1.00 17.15           C  
ATOM     53  CG1 VAL A   9      30.362  13.137   7.710  1.00 18.64           C  
ATOM     54  CG2 VAL A   9      31.698  15.112   6.980  1.00 24.45           C  
ATOM     55  N   GLN A  10      31.824  12.055  10.210  1.00 20.32           N  
ATOM     56  CA  GLN A  10      31.336  10.936  11.009  1.00 22.01           C  
ATOM     57  C   GLN A  10      31.197  11.354  12.467  1.00 20.58           C  
ATOM     58  O   GLN A  10      30.259  10.945  13.156  1.00 21.95           O  
ATOM     59  CB  GLN A  10      32.299   9.753  10.900  1.00  6.53           C  
ATOM     60  CG  GLN A  10      32.415   9.224   9.498  1.00 24.19           C  
ATOM     61  CD  GLN A  10      33.432   8.114   9.379  1.00 28.30           C  
ATOM     62  OE1 GLN A  10      33.079   6.943   9.349  1.00 28.91           O  
ATOM     63  NE2 GLN A  10      34.704   8.479   9.311  1.00 41.81           N  
ATOM     64  N   GLY A  11      32.144  12.161  12.937  1.00 21.94           N  
ATOM     65  CA  GLY A  11      32.098  12.635  14.310  1.00  4.71           C  
ATOM     66  C   GLY A  11      30.872  13.503  14.516  1.00  2.00           C  
ATOM     67  O   GLY A  11      30.037  13.226  15.370  1.00 15.74           O  
ATOM     68  N   LEU A  12      30.767  14.553  13.712  1.00  9.21           N  
ATOM     69  CA  LEU A  12      29.657  15.483  13.765  1.00  3.28           C  
ATOM     70  C   LEU A  12      28.307  14.793  13.659  1.00  9.28           C  
ATOM     71  O   LEU A  12      27.473  14.911  14.555  1.00 22.89           O  
ATOM     72  CB  LEU A  12      29.812  16.526  12.647  1.00  9.02           C  
ATOM     73  CG  LEU A  12      31.238  17.048  12.440  1.00 19.72           C  
ATOM     74  CD1 LEU A  12      31.444  17.497  10.998  1.00 23.16           C  
ATOM     75  CD2 LEU A  12      31.500  18.191  13.403  1.00 26.14           C  
ATOM     76  N   MET A  13      28.096  14.058  12.570  1.00 19.70           N  
ATOM     77  CA  MET A  13      26.835  13.362  12.332  1.00  6.15           C  
ATOM     78  C   MET A  13      26.450  12.412  13.458  1.00 14.21           C  
ATOM     79  O   MET A  13      25.281  12.320  13.826  1.00 20.18           O  
ATOM     80  CB  MET A  13      26.918  12.634  10.992  1.00  8.48           C  
ATOM     81  CG  MET A  13      27.544  13.522   9.925  1.00 16.45           C  
ATOM     82  SD  MET A  13      27.108  13.140   8.229  1.00 17.55           S  
ATOM     83  CE  MET A  13      25.516  12.438   8.395  1.00  6.43           C  
ATOM     84  N   ALA A  14      27.430  11.723  14.022  1.00 17.82           N  
ATOM     85  CA  ALA A  14      27.159  10.814  15.125  1.00 18.47           C  
ATOM     86  C   ALA A  14      26.571  11.612  16.274  1.00 24.44           C  
ATOM     87  O   ALA A  14      25.540  11.235  16.824  1.00 39.42           O  
ATOM     88  CB  ALA A  14      28.437  10.129  15.567  1.00 22.23           C  
ATOM     89  N   ARG A  15      27.226  12.721  16.624  1.00 26.15           N  
ATOM     90  CA  ARG A  15      26.766  13.577  17.714  1.00 14.60           C  
ATOM     91  C   ARG A  15      25.369  14.101  17.478  1.00 19.71           C  
ATOM     92  O   ARG A  15      24.540  14.044  18.378  1.00 23.47           O  
ATOM     93  CB  ARG A  15      27.712  14.750  17.912  1.00 17.76           C  
ATOM     94  CG  ARG A  15      28.146  14.920  19.357  1.00 50.65           C  
ATOM     95  CD  ARG A  15      28.647  16.331  19.644  1.00 68.07           C  
ATOM     96  NE  ARG A  15      27.874  17.002  20.693  1.00 66.12           N  
ATOM     97  CZ  ARG A  15      27.565  18.297  20.684  1.00 63.20           C  
ATOM     98  NH1 ARG A  15      27.959  19.077  19.683  1.00 47.03           N  
ATOM     99  NH2 ARG A  15      26.861  18.816  21.680  1.00 59.55           N  
ATOM    100  N   TYR A  16      25.093  14.595  16.272  1.00 13.64           N  
ATOM    101  CA  TYR A  16      23.759  15.118  15.955  1.00  4.20           C  
ATOM    102  C   TYR A  16      22.643  14.153  16.315  1.00 10.27           C  
ATOM    103  O   TYR A  16      21.577  14.574  16.760  1.00 12.45           O  
ATOM    104  CB  TYR A  16      23.662  15.464  14.475  1.00  5.36           C  
ATOM    105  CG  TYR A  16      22.288  15.885  14.030  1.00 10.55           C  
ATOM    106  CD1 TYR A  16      22.027  17.206  13.686  1.00 15.94           C  
ATOM    107  CD2 TYR A  16      21.250  14.960  13.918  1.00 16.55           C  
ATOM    108  CE1 TYR A  16      20.768  17.595  13.239  1.00  9.62           C  
ATOM    109  CE2 TYR A  16      19.986  15.343  13.471  1.00  3.29           C  
ATOM    110  CZ  TYR A  16      19.754  16.657  13.130  1.00  5.26           C  
ATOM    111  OH  TYR A  16      18.520  17.030  12.646  1.00 20.80           O  
ATOM    112  N   ILE A  17      22.866  12.862  16.089  1.00  8.76           N  
ATOM    113  CA  ILE A  17      21.860  11.871  16.439  1.00 20.96           C  
ATOM    114  C   ILE A  17      21.946  11.626  17.948  1.00 25.69           C  
ATOM    115  O   ILE A  17      21.026  11.095  18.568  1.00 25.45           O  
ATOM    116  CB  ILE A  17      22.087  10.540  15.672  1.00 25.21           C  
ATOM    117  CG1 ILE A  17      21.597  10.692  14.226  1.00 11.81           C  
ATOM    118  CG2 ILE A  17      21.357   9.387  16.362  1.00 29.00           C  
ATOM    119  CD1 ILE A  17      20.099  10.631  14.065  1.00 12.17           C  
ATOM    120  N   GLU A  18      23.068  12.028  18.536  1.00 38.60           N  
ATOM    121  CA  GLU A  18      23.286  11.875  19.971  1.00 42.65           C  
ATOM    122  C   GLU A  18      22.498  12.933  20.760  1.00 43.91           C  
ATOM    123  O   GLU A  18      21.968  12.636  21.836  1.00 48.11           O  
ATOM    124  CB  GLU A  18      24.785  11.981  20.289  1.00 35.03           C  
ATOM    125  CG  GLU A  18      25.289  10.946  21.298  1.00 50.90           C  
ATOM    126  CD  GLU A  18      26.658  10.361  20.946  1.00 51.84           C  
ATOM    127  OE1 GLU A  18      27.672  11.092  21.005  1.00 54.90           O  
ATOM    128  OE2 GLU A  18      26.720   9.158  20.619  1.00 46.68           O  
ATOM    129  N   LEU A  19      22.428  14.155  20.222  1.00 41.07           N  
ATOM    130  CA  LEU A  19      21.702  15.271  20.854  1.00 27.36           C  
ATOM    131  C   LEU A  19      20.197  15.100  20.672  1.00 23.82           C  
ATOM    132  O   LEU A  19      19.402  15.448  21.542  1.00 21.74           O  
ATOM    133  CB  LEU A  19      22.115  16.611  20.225  1.00 20.33           C  
ATOM    134  CG  LEU A  19      23.588  16.834  19.903  1.00  2.00           C  
ATOM    135  CD1 LEU A  19      23.759  18.102  19.100  1.00  6.24           C  
ATOM    136  CD2 LEU A  19      24.381  16.889  21.187  1.00 12.23           C  
ATOM    137  N   VAL A  20      19.819  14.565  19.520  1.00 19.67           N  
ATOM    138  CA  VAL A  20      18.427  14.340  19.198  1.00 22.06           C  
ATOM    139  C   VAL A  20      17.826  13.358  20.182  1.00 25.72           C  
ATOM    140  O   VAL A  20      16.651  13.447  20.530  1.00 35.91           O  
ATOM    141  CB  VAL A  20      18.278  13.784  17.760  1.00 27.49           C  
ATOM    142  CG1 VAL A  20      16.834  13.379  17.491  1.00 25.39           C  
ATOM    143  CG2 VAL A  20      18.722  14.833  16.755  1.00 29.03           C  
ATOM    144  N   ASP A  21      18.637  12.418  20.643  1.00 20.80           N  
ATOM    145  CA  ASP A  21      18.137  11.431  21.586  1.00 25.00           C  
ATOM    146  C   ASP A  21      17.849  12.054  22.947  1.00 30.78           C  
ATOM    147  O   ASP A  21      16.721  11.985  23.440  1.00 27.40           O  
ATOM    148  CB  ASP A  21      19.135  10.280  21.733  1.00 23.18           C  
ATOM    149  CG  ASP A  21      18.476   9.003  22.215  1.00 27.56           C  
ATOM    150  OD1 ASP A  21      17.360   8.701  21.749  1.00 34.38           O  
ATOM    151  OD2 ASP A  21      19.069   8.303  23.062  1.00 37.99           O  
ATOM    152  N   VAL A  22      18.868  12.668  23.547  1.00 32.70           N  
ATOM    153  CA  VAL A  22      18.713  13.311  24.847  1.00 40.26           C  
ATOM    154  C   VAL A  22      17.771  14.518  24.754  1.00 44.94           C  
ATOM    155  O   VAL A  22      17.517  15.191  25.753  1.00 47.06           O  
ATOM    156  CB  VAL A  22      20.073  13.777  25.422  1.00 32.26           C  
ATOM    157  CG1 VAL A  22      20.957  12.579  25.721  1.00 27.91           C  
ATOM    158  CG2 VAL A  22      20.754  14.706  24.444  1.00 50.92           C  
ATOM    159  N   GLY A  23      17.265  14.779  23.548  1.00 48.55           N  
ATOM    160  CA  GLY A  23      16.333  15.876  23.319  1.00 38.96           C  
ATOM    161  C   GLY A  23      16.836  17.290  23.538  1.00 38.79           C  
ATOM    162  O   GLY A  23      16.094  18.136  24.031  1.00 39.79           O  
ATOM    163  N   ASP A  24      18.080  17.558  23.151  1.00 38.28           N  
ATOM    164  CA  ASP A  24      18.692  18.876  23.318  1.00 28.25           C  
ATOM    165  C   ASP A  24      18.413  19.822  22.155  1.00 27.12           C  
ATOM    166  O   ASP A  24      19.308  20.116  21.368  1.00 35.40           O  
ATOM    167  CB  ASP A  24      20.208  18.710  23.481  1.00 33.30           C  
ATOM    168  CG  ASP A  24      20.899  19.994  23.896  1.00 44.64           C  
ATOM    169  OD1 ASP A  24      20.370  21.079  23.583  1.00 47.64           O  
ATOM    170  OD2 ASP A  24      21.974  19.917  24.536  1.00 52.10           O  
ATOM    171  N   ILE A  25      17.188  20.326  22.059  1.00 27.95           N  
ATOM    172  CA  ILE A  25      16.840  21.225  20.963  1.00 27.25           C  
ATOM    173  C   ILE A  25      17.848  22.354  20.789  1.00 32.88           C  
ATOM    174  O   ILE A  25      18.134  22.779  19.669  1.00 35.22           O  
ATOM    175  CB  ILE A  25      15.448  21.863  21.170  1.00 32.43           C  
ATOM    176  CG1 ILE A  25      14.351  20.849  20.835  1.00 28.63           C  
ATOM    177  CG2 ILE A  25      15.298  23.094  20.272  1.00 22.38           C  
ATOM    178  CD1 ILE A  25      14.231  19.721  21.837  1.00 32.69           C  
ATOM    179  N   GLU A  26      18.378  22.837  21.904  1.00 38.17           N  
ATOM    180  CA  GLU A  26      19.337  23.935  21.900  1.00 34.44           C  
ATOM    181  C   GLU A  26      20.643  23.636  21.148  1.00 35.68           C  
ATOM    182  O   GLU A  26      21.077  24.409  20.288  1.00 25.08           O  
ATOM    183  CB  GLU A  26      19.648  24.328  23.351  1.00 43.72           C  
ATOM    184  CG  GLU A  26      18.440  24.230  24.287  1.00 59.20           C  
ATOM    185  CD  GLU A  26      18.773  23.613  25.643  1.00 69.11           C  
ATOM    186  OE1 GLU A  26      19.330  24.327  26.506  1.00 71.07           O  
ATOM    187  OE2 GLU A  26      18.472  22.416  25.853  1.00 64.54           O  
ATOM    188  N   ALA A  27      21.259  22.505  21.478  1.00 33.91           N  
ATOM    189  CA  ALA A  27      22.522  22.092  20.883  1.00 26.04           C  
ATOM    190  C   ALA A  27      22.445  21.795  19.388  1.00 26.56           C  
ATOM    191  O   ALA A  27      23.317  22.221  18.625  1.00 24.58           O  
ATOM    192  CB  ALA A  27      23.058  20.895  21.632  1.00  2.00           C  
ATOM    193  N   ILE A  28      21.410  21.075  18.966  1.00 28.17           N  
ATOM    194  CA  ILE A  28      21.250  20.746  17.544  1.00 26.90           C  
ATOM    195  C   ILE A  28      21.323  22.022  16.709  1.00 27.17           C  
ATOM    196  O   ILE A  28      22.157  22.152  15.816  1.00 25.80           O  
ATOM    197  CB  ILE A  28      19.877  20.062  17.255  1.00 29.23           C  
ATOM    198  CG1 ILE A  28      19.885  18.612  17.743  1.00 23.42           C  
ATOM    199  CG2 ILE A  28      19.567  20.119  15.757  1.00 23.19           C  
ATOM    200  CD1 ILE A  28      18.786  18.290  18.732  1.00 29.05           C  
ATOM    201  N   VAL A  29      20.439  22.962  17.028  1.00 35.58           N  
ATOM    202  CA  VAL A  29      20.344  24.229  16.322  1.00 32.76           C  
ATOM    203  C   VAL A  29      21.669  24.968  16.256  1.00 32.62           C  
ATOM    204  O   VAL A  29      21.839  25.868  15.435  1.00 36.91           O  
ATOM    205  CB  VAL A  29      19.272  25.136  16.978  1.00 32.07           C  
ATOM    206  CG1 VAL A  29      19.263  26.506  16.324  1.00 32.99           C  
ATOM    207  CG2 VAL A  29      17.904  24.490  16.849  1.00 16.68           C  
ATOM    208  N   GLN A  30      22.612  24.588  17.108  1.00 36.50           N  
ATOM    209  CA  GLN A  30      23.912  25.249  17.106  1.00 43.51           C  
ATOM    210  C   GLN A  30      24.865  24.603  16.118  1.00 38.12           C  
ATOM    211  O   GLN A  30      25.933  25.146  15.830  1.00 34.31           O  
ATOM    212  CB  GLN A  30      24.541  25.234  18.497  1.00 60.79           C  
ATOM    213  CG  GLN A  30      25.196  26.554  18.875  1.00 67.95           C  
ATOM    214  CD  GLN A  30      24.177  27.634  19.177  1.00 77.17           C  
ATOM    215  OE1 GLN A  30      23.515  27.602  20.215  1.00 84.71           O  
ATOM    216  NE2 GLN A  30      24.044  28.597  18.272  1.00 73.22           N  
ATOM    217  N   MET A  31      24.480  23.435  15.609  1.00 34.14           N  
ATOM    218  CA  MET A  31      25.297  22.724  14.632  1.00 23.20           C  
ATOM    219  C   MET A  31      24.937  23.235  13.243  1.00 21.78           C  
ATOM    220  O   MET A  31      25.751  23.195  12.311  1.00 16.24           O  
ATOM    221  CB  MET A  31      25.059  21.223  14.739  1.00 20.44           C  
ATOM    222  CG  MET A  31      25.885  20.574  15.836  1.00 26.69           C  
ATOM    223  SD  MET A  31      25.642  18.796  16.021  1.00 38.67           S  
ATOM    224  CE  MET A  31      26.910  18.178  14.866  1.00 22.60           C  
ATOM    225  N   TYR A  32      23.716  23.755  13.137  1.00 20.88           N  
ATOM    226  CA  TYR A  32      23.203  24.310  11.893  1.00 16.78           C  
ATOM    227  C   TYR A  32      23.801  25.674  11.593  1.00 22.02           C  
ATOM    228  O   TYR A  32      24.377  26.325  12.464  1.00 27.58           O  
ATOM    229  CB  TYR A  32      21.681  24.435  11.963  1.00 12.60           C  
ATOM    230  CG  TYR A  32      20.954  23.137  11.721  1.00 21.09           C  
ATOM    231  CD1 TYR A  32      20.511  22.354  12.785  1.00 24.48           C  
ATOM    232  CD2 TYR A  32      20.704  22.695  10.423  1.00 21.90           C  
ATOM    233  CE1 TYR A  32      19.829  21.153  12.561  1.00 33.32           C  
ATOM    234  CE2 TYR A  32      20.026  21.499  10.182  1.00 32.81           C  
ATOM    235  CZ  TYR A  32      19.588  20.731  11.253  1.00 36.27           C  
ATOM    236  OH  TYR A  32      18.904  19.554  11.009  1.00 30.21           O  
ATOM    237  N   ALA A  33      23.682  26.097  10.344  1.00 19.01           N  
ATOM    238  CA  ALA A  33      24.187  27.393   9.967  1.00 22.46           C  
ATOM    239  C   ALA A  33      22.993  28.309  10.177  1.00 36.44           C  
ATOM    240  O   ALA A  33      21.853  27.842  10.210  1.00 35.47           O  
ATOM    241  CB  ALA A  33      24.603  27.390   8.529  1.00 10.22           C  
ATOM    242  N   ASP A  34      23.249  29.602  10.343  1.00 40.66           N  
ATOM    243  CA  ASP A  34      22.160  30.546  10.543  1.00 39.17           C  
ATOM    244  C   ASP A  34      21.247  30.527   9.319  1.00 39.17           C  
ATOM    245  O   ASP A  34      20.030  30.707   9.443  1.00 43.73           O  
ATOM    246  CB  ASP A  34      22.695  31.964  10.790  1.00 21.75           C  
ATOM    247  CG  ASP A  34      24.134  32.134  10.366  1.00 18.21           C  
ATOM    248  OD1 ASP A  34      25.022  31.463  10.936  1.00 11.32           O  
ATOM    249  OD2 ASP A  34      24.379  32.956   9.461  1.00 17.63           O  
ATOM    250  N   ASP A  35      21.841  30.300   8.145  1.00 38.46           N  
ATOM    251  CA  ASP A  35      21.094  30.238   6.885  1.00 29.47           C  
ATOM    252  C   ASP A  35      21.145  28.836   6.261  1.00 35.39           C  
ATOM    253  O   ASP A  35      21.299  28.676   5.043  1.00 31.95           O  
ATOM    254  CB  ASP A  35      21.641  31.257   5.892  1.00 23.13           C  
ATOM    255  CG  ASP A  35      23.060  30.958   5.473  1.00 27.93           C  
ATOM    256  OD1 ASP A  35      23.555  29.858   5.788  1.00 30.22           O  
ATOM    257  OD2 ASP A  35      23.685  31.825   4.825  1.00 53.81           O  
ATOM    258  N   ALA A  36      21.022  27.830   7.122  1.00 26.63           N  
ATOM    259  CA  ALA A  36      21.025  26.440   6.718  1.00 23.17           C  
ATOM    260  C   ALA A  36      19.622  26.106   6.231  1.00 28.59           C  
ATOM    261  O   ALA A  36      18.665  26.807   6.561  1.00 20.46           O  
ATOM    262  CB  ALA A  36      21.389  25.563   7.915  1.00 19.12           C  
ATOM    263  N   THR A  37      19.494  25.046   5.440  1.00 34.76           N  
ATOM    264  CA  THR A  37      18.180  24.634   4.953  1.00 29.10           C  
ATOM    265  C   THR A  37      17.885  23.171   5.306  1.00 16.12           C  
ATOM    266  O   THR A  37      18.783  22.362   5.558  1.00 11.83           O  
ATOM    267  CB  THR A  37      18.034  24.879   3.435  1.00 34.09           C  
ATOM    268  OG1 THR A  37      18.291  23.670   2.718  1.00 39.98           O  
ATOM    269  CG2 THR A  37      19.008  25.971   2.984  1.00 37.34           C  
ATOM    270  N   VAL A  38      16.612  22.836   5.346  1.00 10.79           N  
ATOM    271  CA  VAL A  38      16.239  21.500   5.726  1.00 16.30           C  
ATOM    272  C   VAL A  38      14.951  21.019   5.080  1.00 23.16           C  
ATOM    273  O   VAL A  38      13.880  21.600   5.250  1.00 26.43           O  
ATOM    274  CB  VAL A  38      16.146  21.411   7.255  1.00  2.05           C  
ATOM    275  CG1 VAL A  38      15.171  20.323   7.674  1.00 11.20           C  
ATOM    276  CG2 VAL A  38      17.526  21.155   7.806  1.00 14.92           C  
ATOM    277  N   GLU A  39      15.085  19.946   4.315  1.00 26.01           N  
ATOM    278  CA  GLU A  39      13.961  19.343   3.635  1.00 10.55           C  
ATOM    279  C   GLU A  39      13.761  18.008   4.339  1.00  6.30           C  
ATOM    280  O   GLU A  39      14.604  17.116   4.256  1.00 16.18           O  
ATOM    281  CB  GLU A  39      14.302  19.176   2.154  1.00 11.75           C  
ATOM    282  CG  GLU A  39      14.871  20.450   1.536  1.00 19.92           C  
ATOM    283  CD  GLU A  39      15.523  20.228   0.182  1.00 29.78           C  
ATOM    284  OE1 GLU A  39      16.249  19.229   0.028  1.00 31.59           O  
ATOM    285  OE2 GLU A  39      15.311  21.058  -0.728  1.00 36.61           O  
ATOM    286  N   ASP A  40      12.652  17.897   5.061  1.00 14.27           N  
ATOM    287  CA  ASP A  40      12.340  16.689   5.812  1.00 18.54           C  
ATOM    288  C   ASP A  40      10.833  16.582   6.091  1.00 29.61           C  
ATOM    289  O   ASP A  40      10.289  17.346   6.894  1.00 37.95           O  
ATOM    290  CB  ASP A  40      13.127  16.705   7.126  1.00  9.03           C  
ATOM    291  CG  ASP A  40      12.667  15.643   8.109  1.00 17.24           C  
ATOM    292  OD1 ASP A  40      11.544  15.121   7.953  1.00 18.89           O  
ATOM    293  OD2 ASP A  40      13.435  15.335   9.051  1.00 29.53           O  
ATOM    294  N   PRO A  41      10.140  15.615   5.451  1.00 31.33           N  
ATOM    295  CA  PRO A  41      10.623  14.607   4.497  1.00 21.89           C  
ATOM    296  C   PRO A  41      11.180  15.217   3.221  1.00 19.55           C  
ATOM    297  O   PRO A  41      10.565  16.116   2.640  1.00 19.56           O  
ATOM    298  CB  PRO A  41       9.383  13.766   4.221  1.00 30.53           C  
ATOM    299  CG  PRO A  41       8.254  14.695   4.466  1.00 30.61           C  
ATOM    300  CD  PRO A  41       8.686  15.498   5.649  1.00 32.04           C  
ATOM    301  N   PHE A  42      12.338  14.724   2.783  1.00 25.19           N  
ATOM    302  CA  PHE A  42      12.976  15.239   1.572  1.00 26.74           C  
ATOM    303  C   PHE A  42      11.919  15.398   0.478  1.00 31.04           C  
ATOM    304  O   PHE A  42      10.985  14.597   0.365  1.00 20.75           O  
ATOM    305  CB  PHE A  42      14.115  14.319   1.087  1.00  6.75           C  
ATOM    306  CG  PHE A  42      14.566  14.622  -0.318  1.00 20.45           C  
ATOM    307  CD1 PHE A  42      15.464  15.642  -0.567  1.00 18.55           C  
ATOM    308  CD2 PHE A  42      14.003  13.958  -1.404  1.00 22.68           C  
ATOM    309  CE1 PHE A  42      15.784  16.005  -1.880  1.00 30.80           C  
ATOM    310  CE2 PHE A  42      14.320  14.319  -2.716  1.00 14.79           C  
ATOM    311  CZ  PHE A  42      15.205  15.341  -2.953  1.00 17.54           C  
ATOM    312  N   GLY A  43      12.071  16.446  -0.321  1.00 46.52           N  
ATOM    313  CA  GLY A  43      11.116  16.720  -1.375  1.00 47.37           C  
ATOM    314  C   GLY A  43      10.286  17.896  -0.916  1.00 54.41           C  
ATOM    315  O   GLY A  43      10.343  18.965  -1.523  1.00 64.21           O  
ATOM    316  N   GLN A  44       9.535  17.689   0.168  1.00 50.15           N  
ATOM    317  CA  GLN A  44       8.674  18.710   0.771  1.00 45.27           C  
ATOM    318  C   GLN A  44       9.375  20.069   0.813  1.00 46.35           C  
ATOM    319  O   GLN A  44      10.601  20.129   0.783  1.00 50.77           O  
ATOM    320  CB  GLN A  44       8.314  18.283   2.194  1.00 42.03           C  
ATOM    321  CG  GLN A  44       6.844  18.424   2.560  1.00 57.66           C  
ATOM    322  CD  GLN A  44       5.918  18.068   1.421  1.00 63.52           C  
ATOM    323  OE1 GLN A  44       5.854  16.917   0.997  1.00 75.65           O  
ATOM    324  NE2 GLN A  44       5.188  19.056   0.919  1.00 76.83           N  
ATOM    325  N   PRO A  45       8.607  21.180   0.869  1.00 50.86           N  
ATOM    326  CA  PRO A  45       9.243  22.507   0.914  1.00 45.99           C  
ATOM    327  C   PRO A  45      10.163  22.619   2.122  1.00 38.41           C  
ATOM    328  O   PRO A  45       9.828  22.153   3.219  1.00 44.75           O  
ATOM    329  CB  PRO A  45       8.070  23.484   0.989  1.00 47.11           C  
ATOM    330  CG  PRO A  45       6.901  22.657   1.430  1.00 60.00           C  
ATOM    331  CD  PRO A  45       7.138  21.276   0.892  1.00 57.95           C  
ATOM    332  N   PRO A  46      11.331  23.252   1.940  1.00 31.40           N  
ATOM    333  CA  PRO A  46      12.325  23.426   3.002  1.00 34.69           C  
ATOM    334  C   PRO A  46      12.112  24.571   3.991  1.00 43.44           C  
ATOM    335  O   PRO A  46      11.580  25.623   3.627  1.00 49.28           O  
ATOM    336  CB  PRO A  46      13.621  23.616   2.229  1.00 30.87           C  
ATOM    337  CG  PRO A  46      13.190  24.338   0.983  1.00 22.27           C  
ATOM    338  CD  PRO A  46      11.780  23.864   0.672  1.00 28.65           C  
ATOM    339  N   ILE A  47      12.527  24.353   5.242  1.00 39.12           N  
ATOM    340  CA  ILE A  47      12.468  25.398   6.265  1.00 32.91           C  
ATOM    341  C   ILE A  47      13.916  25.850   6.426  1.00 30.15           C  
ATOM    342  O   ILE A  47      14.788  25.076   6.818  1.00 29.43           O  
ATOM    343  CB  ILE A  47      11.923  24.902   7.622  1.00 24.82           C  
ATOM    344  CG1 ILE A  47      12.629  23.615   8.058  1.00 26.30           C  
ATOM    345  CG2 ILE A  47      10.426  24.717   7.520  1.00 23.16           C  
ATOM    346  CD1 ILE A  47      12.553  23.331   9.558  1.00 23.25           C  
ATOM    347  N   HIS A  48      14.153  27.108   6.090  1.00 26.08           N  
ATOM    348  CA  HIS A  48      15.470  27.719   6.121  1.00 34.93           C  
ATOM    349  C   HIS A  48      15.688  28.556   7.397  1.00 30.60           C  
ATOM    350  O   HIS A  48      14.733  28.927   8.081  1.00 35.41           O  
ATOM    351  CB  HIS A  48      15.573  28.556   4.837  1.00 47.22           C  
ATOM    352  CG  HIS A  48      16.725  29.509   4.787  1.00 60.38           C  
ATOM    353  ND1 HIS A  48      17.841  29.279   4.008  1.00 66.31           N  
ATOM    354  CD2 HIS A  48      16.884  30.745   5.316  1.00 63.81           C  
ATOM    355  CE1 HIS A  48      18.635  30.333   4.060  1.00 69.92           C  
ATOM    356  NE2 HIS A  48      18.078  31.238   4.844  1.00 67.92           N  
ATOM    357  N   GLY A  49      16.949  28.821   7.729  1.00 24.59           N  
ATOM    358  CA  GLY A  49      17.270  29.627   8.902  1.00 21.14           C  
ATOM    359  C   GLY A  49      17.067  28.997  10.271  1.00 16.76           C  
ATOM    360  O   GLY A  49      16.094  28.277  10.496  1.00 21.88           O  
ATOM    361  N   ARG A  50      17.981  29.288  11.191  1.00 11.34           N  
ATOM    362  CA  ARG A  50      17.929  28.747  12.550  1.00  9.59           C  
ATOM    363  C   ARG A  50      16.621  28.816  13.346  1.00 16.34           C  
ATOM    364  O   ARG A  50      16.336  27.898  14.121  1.00 19.64           O  
ATOM    365  CB  ARG A  50      19.003  29.396  13.391  1.00 15.66           C  
ATOM    366  CG  ARG A  50      20.348  29.252  12.830  1.00 18.48           C  
ATOM    367  CD  ARG A  50      21.286  28.800  13.908  1.00 15.43           C  
ATOM    368  NE  ARG A  50      22.648  28.851  13.417  1.00 30.80           N  
ATOM    369  CZ  ARG A  50      23.703  28.992  14.195  1.00 30.47           C  
ATOM    370  NH1 ARG A  50      23.541  29.092  15.506  1.00 35.40           N  
ATOM    371  NH2 ARG A  50      24.913  29.061  13.656  1.00 34.39           N  
ATOM    372  N   GLU A  51      15.842  29.887  13.208  1.00 10.47           N  
ATOM    373  CA  GLU A  51      14.588  29.969  13.966  1.00 23.17           C  
ATOM    374  C   GLU A  51      13.584  28.957  13.439  1.00 21.49           C  
ATOM    375  O   GLU A  51      13.011  28.183  14.201  1.00 27.58           O  
ATOM    376  CB  GLU A  51      13.981  31.367  13.891  1.00 28.04           C  
ATOM    377  CG  GLU A  51      12.971  31.660  14.997  1.00 39.90           C  
ATOM    378  CD  GLU A  51      11.648  32.207  14.465  1.00 66.85           C  
ATOM    379  OE1 GLU A  51      11.582  32.561  13.265  1.00 72.99           O  
ATOM    380  OE2 GLU A  51      10.671  32.283  15.248  1.00 73.02           O  
ATOM    381  N   GLN A  52      13.363  28.968  12.130  1.00 24.46           N  
ATOM    382  CA  GLN A  52      12.447  28.020  11.515  1.00 23.00           C  
ATOM    383  C   GLN A  52      12.951  26.619  11.792  1.00 11.90           C  
ATOM    384  O   GLN A  52      12.175  25.725  12.087  1.00 25.23           O  
ATOM    385  CB  GLN A  52      12.375  28.253  10.019  1.00 25.74           C  
ATOM    386  CG  GLN A  52      11.525  29.438   9.666  1.00 26.14           C  
ATOM    387  CD  GLN A  52      11.621  29.799   8.209  1.00 40.26           C  
ATOM    388  OE1 GLN A  52      11.415  28.954   7.335  1.00 61.63           O  
ATOM    389  NE2 GLN A  52      11.937  31.060   7.929  1.00 45.60           N  
ATOM    390  N   ILE A  53      14.260  26.435  11.707  1.00 18.50           N  
ATOM    391  CA  ILE A  53      14.850  25.134  11.981  1.00 19.73           C  
ATOM    392  C   ILE A  53      14.678  24.761  13.464  1.00 27.48           C  
ATOM    393  O   ILE A  53      14.716  23.578  13.824  1.00 30.97           O  
ATOM    394  CB  ILE A  53      16.356  25.118  11.628  1.00 13.83           C  
ATOM    395  CG1 ILE A  53      16.528  25.092  10.111  1.00  3.11           C  
ATOM    396  CG2 ILE A  53      17.035  23.902  12.263  1.00 12.57           C  
ATOM    397  CD1 ILE A  53      17.927  25.445   9.659  1.00 16.27           C  
ATOM    398  N   ALA A  54      14.493  25.763  14.319  1.00 28.01           N  
ATOM    399  CA  ALA A  54      14.315  25.514  15.750  1.00 28.08           C  
ATOM    400  C   ALA A  54      12.839  25.333  16.082  1.00 22.18           C  
ATOM    401  O   ALA A  54      12.490  24.796  17.134  1.00 19.74           O  
ATOM    402  CB  ALA A  54      14.905  26.655  16.568  1.00 35.12           C  
ATOM    403  N   ALA A  55      11.981  25.786  15.174  1.00 21.82           N  
ATOM    404  CA  ALA A  55      10.536  25.665  15.334  1.00 26.23           C  
ATOM    405  C   ALA A  55      10.125  24.224  15.043  1.00 36.68           C  
ATOM    406  O   ALA A  55       9.454  23.579  15.849  1.00 33.39           O  
ATOM    407  CB  ALA A  55       9.831  26.610  14.383  1.00 23.28           C  
ATOM    408  N   PHE A  56      10.536  23.726  13.881  1.00 48.38           N  
ATOM    409  CA  PHE A  56      10.231  22.356  13.485  1.00 55.93           C  
ATOM    410  C   PHE A  56      10.825  21.398  14.511  1.00 50.78           C  
ATOM    411  O   PHE A  56      10.157  20.476  14.977  1.00 48.76           O  
ATOM    412  CB  PHE A  56      10.826  22.047  12.107  1.00 59.64           C  
ATOM    413  CG  PHE A  56      11.430  20.673  12.008  1.00 65.41           C  
ATOM    414  CD1 PHE A  56      10.621  19.565  11.768  1.00 67.96           C  
ATOM    415  CD2 PHE A  56      12.799  20.484  12.193  1.00 68.84           C  
ATOM    416  CE1 PHE A  56      11.160  18.287  11.720  1.00 67.30           C  
ATOM    417  CE2 PHE A  56      13.353  19.205  12.147  1.00 74.64           C  
ATOM    418  CZ  PHE A  56      12.530  18.103  11.911  1.00 73.49           C  
ATOM    419  N   SER A  57      12.095  21.625  14.839  1.00 44.78           N  
ATOM    420  CA  SER A  57      12.805  20.792  15.791  1.00 34.14           C  
ATOM    421  C   SER A  57      12.104  20.806  17.140  1.00 34.63           C  
ATOM    422  O   SER A  57      12.059  19.790  17.833  1.00 41.10           O  
ATOM    423  CB  SER A  57      14.249  21.280  15.942  1.00 35.04           C  
ATOM    424  OG  SER A  57      14.981  21.096  14.741  1.00 31.43           O  
ATOM    425  N   ARG A  58      11.553  21.955  17.514  1.00 27.50           N  
ATOM    426  CA  ARG A  58      10.861  22.062  18.790  1.00 34.84           C  
ATOM    427  C   ARG A  58       9.493  21.424  18.671  1.00 38.95           C  
ATOM    428  O   ARG A  58       9.021  20.759  19.593  1.00 42.20           O  
ATOM    429  CB  ARG A  58      10.699  23.530  19.203  1.00 34.89           C  
ATOM    430  CG  ARG A  58      10.786  23.759  20.711  1.00 36.52           C  
ATOM    431  CD  ARG A  58      11.555  25.049  21.050  1.00 54.43           C  
ATOM    432  NE  ARG A  58      12.674  24.822  21.971  1.00 49.13           N  
ATOM    433  CZ  ARG A  58      12.540  24.463  23.247  1.00 48.46           C  
ATOM    434  NH1 ARG A  58      11.332  24.285  23.765  1.00 53.34           N  
ATOM    435  NH2 ARG A  58      13.613  24.280  24.007  1.00 44.09           N  
ATOM    436  N   GLN A  59       8.875  21.618  17.513  1.00 36.59           N  
ATOM    437  CA  GLN A  59       7.545  21.098  17.238  1.00 50.55           C  
ATOM    438  C   GLN A  59       7.484  19.571  17.166  1.00 49.37           C  
ATOM    439  O   GLN A  59       6.536  18.960  17.662  1.00 52.44           O  
ATOM    440  CB  GLN A  59       7.029  21.707  15.933  1.00 64.38           C  
ATOM    441  CG  GLN A  59       5.583  21.389  15.620  1.00 81.24           C  
ATOM    442  CD  GLN A  59       4.626  22.412  16.187  1.00 89.66           C  
ATOM    443  OE1 GLN A  59       3.824  22.102  17.071  1.00 92.29           O  
ATOM    444  NE2 GLN A  59       4.700  23.638  15.682  1.00 94.43           N  
ATOM    445  N   GLY A  60       8.493  18.958  16.556  1.00 43.91           N  
ATOM    446  CA  GLY A  60       8.514  17.513  16.436  1.00 31.97           C  
ATOM    447  C   GLY A  60       9.823  16.910  16.896  1.00 36.17           C  
ATOM    448  O   GLY A  60       9.892  16.288  17.957  1.00 42.49           O  
ATOM    449  N   LYS A  65       9.548  12.268  24.281  1.00 43.15           N  
ATOM    450  CA  LYS A  65       9.545  10.768  24.179  1.00 40.73           C  
ATOM    451  C   LYS A  65       9.727  10.220  22.740  1.00 47.52           C  
ATOM    452  O   LYS A  65       8.845   9.535  22.190  1.00 68.78           O  
ATOM    453  CB  LYS A  65       8.282  10.171  24.834  1.00 50.02           C  
ATOM    454  CG  LYS A  65       8.553   9.405  26.152  1.00 66.30           C  
ATOM    455  CD  LYS A  65       7.858   8.033  26.156  1.00 74.53           C  
ATOM    456  CE  LYS A  65       8.817   6.848  25.880  1.00 76.81           C  
ATOM    457  NZ  LYS A  65       8.050   5.579  25.630  1.00 91.73           N  
ATOM    458  N   VAL A  66      10.335  10.465  21.925  1.00 37.89           N  
ATOM    459  CA  VAL A  66      11.031  10.025  20.718  1.00 46.17           C  
ATOM    460  C   VAL A  66      12.533   9.786  20.968  1.00 48.72           C  
ATOM    461  O   VAL A  66      13.254  10.683  21.419  1.00 47.47           O  
ATOM    462  CB  VAL A  66      10.853  11.062  19.578  1.00 45.85           C  
ATOM    463  CG1 VAL A  66      12.060  11.052  18.657  1.00 42.72           C  
ATOM    464  CG2 VAL A  66       9.588  10.765  18.797  1.00 36.62           C  
ATOM    465  N   ARG A  67      12.985   8.567  20.673  1.00 42.64           N  
ATOM    466  CA  ARG A  67      14.380   8.167  20.849  1.00 30.21           C  
ATOM    467  C   ARG A  67      15.000   7.901  19.476  1.00 27.20           C  
ATOM    468  O   ARG A  67      14.342   7.350  18.592  1.00 21.84           O  
ATOM    469  CB  ARG A  67      14.448   6.919  21.718  1.00 25.25           C  
ATOM    470  N   ALA A  68      16.255   8.311  19.303  1.00 26.69           N  
ATOM    471  CA  ALA A  68      16.969   8.149  18.040  1.00 21.76           C  
ATOM    472  C   ALA A  68      18.116   7.163  18.179  1.00 30.18           C  
ATOM    473  O   ALA A  68      18.752   7.103  19.226  1.00 30.74           O  
ATOM    474  CB  ALA A  68      17.487   9.496  17.575  1.00 15.70           C  
ATOM    475  N   CYS A  69      18.376   6.396  17.113  1.00 35.86           N  
ATOM    476  CA  CYS A  69      19.437   5.380  17.096  1.00 27.79           C  
ATOM    477  C   CYS A  69      20.152   5.287  15.752  1.00 27.98           C  
ATOM    478  O   CYS A  69      19.516   5.330  14.709  1.00 25.02           O  
ATOM    479  CB  CYS A  69      18.846   4.009  17.437  1.00 24.54           C  
ATOM    480  N   LEU A  70      21.474   5.144  15.786  1.00 22.70           N  
ATOM    481  CA  LEU A  70      22.268   5.017  14.566  1.00 30.53           C  
ATOM    482  C   LEU A  70      22.305   3.527  14.202  1.00 28.89           C  
ATOM    483  O   LEU A  70      22.974   2.744  14.874  1.00 36.32           O  
ATOM    484  CB  LEU A  70      23.692   5.539  14.809  1.00 26.92           C  
ATOM    485  CG  LEU A  70      24.121   6.877  14.184  1.00 31.84           C  
ATOM    486  CD1 LEU A  70      25.621   7.089  14.344  1.00 20.89           C  
ATOM    487  CD2 LEU A  70      23.761   6.886  12.714  1.00 26.13           C  
ATOM    488  N   THR A  71      21.599   3.128  13.147  1.00 26.52           N  
ATOM    489  CA  THR A  71      21.574   1.710  12.769  1.00 28.47           C  
ATOM    490  C   THR A  71      22.776   1.224  11.953  1.00 28.36           C  
ATOM    491  O   THR A  71      22.984   0.024  11.807  1.00 26.65           O  
ATOM    492  CB  THR A  71      20.271   1.336  12.016  1.00 23.97           C  
ATOM    493  OG1 THR A  71      19.812   2.446  11.233  1.00 23.26           O  
ATOM    494  CG2 THR A  71      19.191   0.942  13.016  1.00 24.95           C  
ATOM    495  N   GLY A  72      23.570   2.154  11.433  1.00 34.08           N  
ATOM    496  CA  GLY A  72      24.741   1.777  10.663  1.00 27.22           C  
ATOM    497  C   GLY A  72      25.805   2.861  10.684  1.00 23.43           C  
ATOM    498  O   GLY A  72      25.523   3.987  11.074  1.00 26.45           O  
ATOM    499  N   PRO A  73      27.040   2.552  10.268  1.00 19.27           N  
ATOM    500  CA  PRO A  73      28.133   3.531  10.251  1.00 12.85           C  
ATOM    501  C   PRO A  73      27.790   4.769   9.431  1.00 14.11           C  
ATOM    502  O   PRO A  73      26.951   4.724   8.548  1.00 10.29           O  
ATOM    503  CB  PRO A  73      29.302   2.752   9.638  1.00 22.40           C  
ATOM    504  CG  PRO A  73      28.652   1.598   8.907  1.00  2.10           C  
ATOM    505  CD  PRO A  73      27.484   1.237   9.773  1.00 13.44           C  
ATOM    506  N   VAL A  74      28.444   5.882   9.715  1.00 14.50           N  
ATOM    507  CA  VAL A  74      28.170   7.088   8.969  1.00  5.81           C  
ATOM    508  C   VAL A  74      29.080   7.086   7.736  1.00 18.65           C  
ATOM    509  O   VAL A  74      30.288   6.855   7.859  1.00  7.80           O  
ATOM    510  CB  VAL A  74      28.415   8.369   9.871  1.00 12.07           C  
ATOM    511  CG1 VAL A  74      28.618   9.611   9.026  1.00  3.49           C  
ATOM    512  CG2 VAL A  74      27.221   8.593  10.768  1.00  2.00           C  
ATOM    513  N   ARG A  75      28.489   7.329   6.560  1.00 12.91           N  
ATOM    514  CA  ARG A  75      29.218   7.363   5.288  1.00 21.29           C  
ATOM    515  C   ARG A  75      29.707   8.772   4.972  1.00 22.73           C  
ATOM    516  O   ARG A  75      28.946   9.600   4.488  1.00 36.66           O  
ATOM    517  CB  ARG A  75      28.319   6.884   4.139  1.00 13.96           C  
ATOM    518  CG  ARG A  75      28.263   5.386   3.962  1.00  5.58           C  
ATOM    519  CD  ARG A  75      27.595   4.759   5.158  1.00  4.06           C  
ATOM    520  NE  ARG A  75      26.985   3.479   4.835  1.00 11.72           N  
ATOM    521  CZ  ARG A  75      26.216   2.791   5.672  1.00  8.78           C  
ATOM    522  NH1 ARG A  75      25.965   3.264   6.871  1.00 27.01           N  
ATOM    523  NH2 ARG A  75      25.703   1.619   5.318  1.00 26.67           N  
ATOM    524  N   ALA A  76      30.981   9.039   5.235  1.00 25.26           N  
ATOM    525  CA  ALA A  76      31.545  10.355   4.976  1.00 24.33           C  
ATOM    526  C   ALA A  76      32.324  10.426   3.663  1.00 30.41           C  
ATOM    527  O   ALA A  76      33.077   9.509   3.309  1.00 25.88           O  
ATOM    528  CB  ALA A  76      32.448  10.769   6.132  1.00 15.44           C  
ATOM    529  N   SER A  77      32.138  11.531   2.951  1.00 31.25           N  
ATOM    530  CA  SER A  77      32.820  11.764   1.684  1.00 30.17           C  
ATOM    531  C   SER A  77      34.016  12.672   1.946  1.00 28.99           C  
ATOM    532  O   SER A  77      34.274  13.064   3.092  1.00 21.41           O  
ATOM    533  CB  SER A  77      31.876  12.432   0.685  1.00 29.81           C  
ATOM    534  OG  SER A  77      31.942  13.838   0.827  1.00 23.28           O  
ATOM    535  N   HIS A  78      34.730  13.022   0.881  1.00 25.02           N  
ATOM    536  CA  HIS A  78      35.911  13.863   0.999  1.00 29.53           C  
ATOM    537  C   HIS A  78      35.636  15.342   0.780  1.00 27.18           C  
ATOM    538  O   HIS A  78      36.548  16.154   0.913  1.00 33.44           O  
ATOM    539  CB  HIS A  78      36.995  13.417   0.005  1.00 46.01           C  
ATOM    540  CG  HIS A  78      37.811  12.248   0.468  1.00 56.69           C  
ATOM    541  ND1 HIS A  78      38.093  12.012   1.796  1.00 62.57           N  
ATOM    542  CD2 HIS A  78      38.409  11.249  -0.225  1.00 58.97           C  
ATOM    543  CE1 HIS A  78      38.827  10.916   1.903  1.00 62.83           C  
ATOM    544  NE2 HIS A  78      39.033  10.436   0.690  1.00 60.36           N  
ATOM    545  N   ASN A  79      34.403  15.707   0.435  1.00 25.33           N  
ATOM    546  CA  ASN A  79      34.106  17.123   0.217  1.00 21.81           C  
ATOM    547  C   ASN A  79      33.170  17.737   1.255  1.00 15.65           C  
ATOM    548  O   ASN A  79      32.451  18.690   0.974  1.00 15.05           O  
ATOM    549  CB  ASN A  79      33.574  17.371  -1.204  1.00 22.11           C  
ATOM    550  CG  ASN A  79      32.361  16.531  -1.540  1.00 28.59           C  
ATOM    551  OD1 ASN A  79      31.694  16.763  -2.554  1.00 31.17           O  
ATOM    552  ND2 ASN A  79      32.063  15.553  -0.699  1.00 19.36           N  
ATOM    553  N   GLY A  80      33.197  17.174   2.457  1.00 15.92           N  
ATOM    554  CA  GLY A  80      32.405  17.696   3.548  1.00 22.52           C  
ATOM    555  C   GLY A  80      31.006  17.168   3.687  1.00 30.02           C  
ATOM    556  O   GLY A  80      30.239  17.734   4.464  1.00 31.21           O  
ATOM    557  N   CYS A  81      30.667  16.107   2.950  1.00 23.77           N  
ATOM    558  CA  CYS A  81      29.324  15.533   3.021  1.00 14.28           C  
ATOM    559  C   CYS A  81      29.274  14.221   3.784  1.00 10.10           C  
ATOM    560  O   CYS A  81      30.294  13.603   4.053  1.00 22.67           O  
ATOM    561  CB  CYS A  81      28.750  15.329   1.628  1.00  7.06           C  
ATOM    562  SG  CYS A  81      28.375  16.864   0.802  1.00 25.18           S  
ATOM    563  N   GLY A  82      28.069  13.796   4.137  1.00 12.63           N  
ATOM    564  CA  GLY A  82      27.926  12.565   4.886  1.00 14.05           C  
ATOM    565  C   GLY A  82      26.507  12.061   4.830  1.00  4.98           C  
ATOM    566  O   GLY A  82      25.594  12.790   4.458  1.00 14.25           O  
ATOM    567  N   ALA A  83      26.320  10.799   5.180  1.00 15.43           N  
ATOM    568  CA  ALA A  83      24.999  10.211   5.162  1.00  8.12           C  
ATOM    569  C   ALA A  83      25.019   9.083   6.162  1.00  8.43           C  
ATOM    570  O   ALA A  83      25.930   8.260   6.168  1.00 10.71           O  
ATOM    571  CB  ALA A  83      24.669   9.697   3.775  1.00 11.84           C  
ATOM    572  N   MET A  84      24.008   9.057   7.014  1.00 16.83           N  
ATOM    573  CA  MET A  84      23.925   8.049   8.046  1.00 14.11           C  
ATOM    574  C   MET A  84      22.555   7.405   8.120  1.00 22.36           C  
ATOM    575  O   MET A  84      21.537   8.019   7.798  1.00 18.04           O  
ATOM    576  CB  MET A  84      24.235   8.680   9.406  1.00 25.80           C  
ATOM    577  CG  MET A  84      23.068   9.476   9.986  1.00 20.84           C  
ATOM    578  SD  MET A  84      23.571  10.663  11.248  1.00 27.85           S  
ATOM    579  CE  MET A  84      22.403  11.949  11.004  1.00  9.41           C  
ATOM    580  N   PRO A  85      22.518   6.136   8.527  1.00 20.35           N  
ATOM    581  CA  PRO A  85      21.268   5.401   8.659  1.00 22.83           C  
ATOM    582  C   PRO A  85      20.870   5.419  10.132  1.00 18.15           C  
ATOM    583  O   PRO A  85      21.676   5.099  11.006  1.00 12.79           O  
ATOM    584  CB  PRO A  85      21.649   4.006   8.203  1.00 19.70           C  
ATOM    585  CG  PRO A  85      23.114   3.876   8.603  1.00  2.00           C  
ATOM    586  CD  PRO A  85      23.670   5.273   8.828  1.00 13.42           C  
ATOM    587  N   PHE A  86      19.640   5.804  10.424  1.00 13.16           N  
ATOM    588  CA  PHE A  86      19.233   5.810  11.809  1.00 18.53           C  
ATOM    589  C   PHE A  86      17.759   5.508  11.880  1.00 14.09           C  
ATOM    590  O   PHE A  86      17.111   5.420  10.850  1.00 17.85           O  
ATOM    591  CB  PHE A  86      19.605   7.152  12.474  1.00  2.00           C  
ATOM    592  CG  PHE A  86      18.698   8.282  12.124  1.00  6.98           C  
ATOM    593  CD1 PHE A  86      17.527   8.488  12.829  1.00  9.46           C  
ATOM    594  CD2 PHE A  86      19.030   9.163  11.103  1.00  4.09           C  
ATOM    595  CE1 PHE A  86      16.699   9.560  12.521  1.00 10.02           C  
ATOM    596  CE2 PHE A  86      18.213  10.222  10.797  1.00  2.00           C  
ATOM    597  CZ  PHE A  86      17.043  10.421  11.507  1.00  7.06           C  
ATOM    598  N   ARG A  87      17.243   5.309  13.088  1.00 26.01           N  
ATOM    599  CA  ARG A  87      15.834   4.993  13.279  1.00 34.56           C  
ATOM    600  C   ARG A  87      15.274   5.654  14.545  1.00 41.67           C  
ATOM    601  O   ARG A  87      15.846   5.538  15.632  1.00 40.75           O  
ATOM    602  CB  ARG A  87      15.649   3.464  13.329  1.00 36.16           C  
ATOM    603  CG  ARG A  87      15.026   2.917  14.605  1.00 40.53           C  
ATOM    604  CD  ARG A  87      14.900   1.399  14.559  1.00 47.80           C  
ATOM    605  NE  ARG A  87      14.037   0.953  13.468  1.00 65.79           N  
ATOM    606  CZ  ARG A  87      13.531  -0.275  13.361  1.00 70.96           C  
ATOM    607  NH1 ARG A  87      13.802  -1.191  14.284  1.00 72.77           N  
ATOM    608  NH2 ARG A  87      12.745  -0.582  12.333  1.00 63.04           N  
ATOM    609  N   VAL A  88      14.145   6.343  14.383  1.00 37.85           N  
ATOM    610  CA  VAL A  88      13.475   7.048  15.472  1.00 25.51           C  
ATOM    611  C   VAL A  88      12.299   6.261  16.042  1.00 17.55           C  
ATOM    612  O   VAL A  88      11.356   5.948  15.327  1.00 27.44           O  
ATOM    613  CB  VAL A  88      12.934   8.410  14.969  1.00 27.47           C  
ATOM    614  CG1 VAL A  88      12.257   9.163  16.096  1.00 20.50           C  
ATOM    615  CG2 VAL A  88      14.065   9.227  14.386  1.00 23.86           C  
ATOM    616  N   GLU A  89      12.347   5.931  17.324  1.00 15.29           N  
ATOM    617  CA  GLU A  89      11.235   5.219  17.938  1.00 27.92           C  
ATOM    618  C   GLU A  89      10.325   6.251  18.586  1.00 39.71           C  
ATOM    619  O   GLU A  89      10.783   7.081  19.368  1.00 45.35           O  
ATOM    620  CB  GLU A  89      11.724   4.241  18.998  1.00 19.21           C  
ATOM    621  CG  GLU A  89      12.627   3.179  18.444  1.00 36.80           C  
ATOM    622  CD  GLU A  89      13.100   2.231  19.508  1.00 48.62           C  
ATOM    623  OE1 GLU A  89      14.210   2.441  20.042  1.00 60.54           O  
ATOM    624  OE2 GLU A  89      12.356   1.276  19.811  1.00 66.14           O  
ATOM    625  N   MET A  90       9.043   6.209  18.249  1.00 44.02           N  
ATOM    626  CA  MET A  90       8.086   7.149  18.808  1.00 38.82           C  
ATOM    627  C   MET A  90       6.915   6.437  19.455  1.00 35.79           C  
ATOM    628  O   MET A  90       7.079   5.406  20.115  1.00 40.28           O  
ATOM    629  CB  MET A  90       7.564   8.083  17.721  1.00 47.66           C  
ATOM    630  CG  MET A  90       7.190   7.382  16.433  1.00 38.41           C  
ATOM    631  SD  MET A  90       7.649   8.346  14.988  1.00 45.80           S  
ATOM    632  CE  MET A  90       8.676   9.655  15.694  1.00 43.64           C  
ATOM    633  N   VAL A  91       5.734   7.007  19.263  1.00 39.75           N  
ATOM    634  CA  VAL A  91       4.503   6.465  19.814  1.00 53.93           C  
ATOM    635  C   VAL A  91       3.347   7.159  19.093  1.00 59.56           C  
ATOM    636  O   VAL A  91       3.050   8.328  19.341  1.00 57.22           O  
ATOM    637  CB  VAL A  91       4.425   6.709  21.362  1.00 56.04           C  
ATOM    638  CG1 VAL A  91       2.995   6.930  21.799  1.00 53.74           C  
ATOM    639  CG2 VAL A  91       5.008   5.516  22.117  1.00 51.06           C  
ATOM    640  N   TRP A  92       2.724   6.439  18.168  1.00 65.96           N  
ATOM    641  CA  TRP A  92       1.602   6.972  17.416  1.00 74.11           C  
ATOM    642  C   TRP A  92       0.418   7.098  18.375  1.00 81.26           C  
ATOM    643  O   TRP A  92      -0.525   6.304  18.320  1.00 88.81           O  
ATOM    644  CB  TRP A  92       1.261   6.026  16.261  1.00 78.39           C  
ATOM    645  CG  TRP A  92       0.225   6.549  15.310  1.00 89.48           C  
ATOM    646  CD1 TRP A  92      -0.814   7.388  15.604  1.00 90.53           C  
ATOM    647  CD2 TRP A  92       0.109   6.241  13.913  1.00 94.08           C  
ATOM    648  NE1 TRP A  92      -1.568   7.617  14.481  1.00 96.92           N  
ATOM    649  CE2 TRP A  92      -1.027   6.927  13.428  1.00 98.05           C  
ATOM    650  CE3 TRP A  92       0.854   5.451  13.027  1.00 97.63           C  
ATOM    651  CZ2 TRP A  92      -1.438   6.847  12.090  1.00 98.71           C  
ATOM    652  CZ3 TRP A  92       0.444   5.372  11.695  1.00 99.11           C  
ATOM    653  CH2 TRP A  92      -0.693   6.066  11.243  1.00 96.89           C  
ATOM    654  N   ASN A  93       0.467   8.100  19.248  1.00 81.63           N  
ATOM    655  CA  ASN A  93      -0.593   8.316  20.227  1.00 80.36           C  
ATOM    656  C   ASN A  93      -0.836   7.011  20.964  1.00 78.64           C  
ATOM    657  O   ASN A  93      -1.853   6.352  20.764  1.00 78.79           O  
ATOM    658  CB  ASN A  93      -1.884   8.757  19.537  1.00 87.90           C  
ATOM    659  CG  ASN A  93      -2.423  10.064  20.092  1.00 98.96           C  
ATOM    660  OD1 ASN A  93      -3.242  10.081  21.018  1.00 96.34           O  
ATOM    661  ND2 ASN A  93      -1.964  11.174  19.523  1.00100.00           N  
ATOM    662  N   GLY A  94       0.109   6.640  21.820  1.00 79.93           N  
ATOM    663  CA  GLY A  94      -0.013   5.401  22.565  1.00 84.39           C  
ATOM    664  C   GLY A  94       0.230   4.172  21.700  1.00 85.80           C  
ATOM    665  O   GLY A  94      -0.114   3.052  22.086  1.00 89.82           O  
ATOM    666  N   GLN A  95       0.827   4.374  20.529  1.00 82.56           N  
ATOM    667  CA  GLN A  95       1.109   3.269  19.621  1.00 75.29           C  
ATOM    668  C   GLN A  95       2.552   3.270  19.106  1.00 68.02           C  
ATOM    669  O   GLN A  95       2.815   3.635  17.961  1.00 57.00           O  
ATOM    670  CB  GLN A  95       0.125   3.298  18.449  1.00 80.15           C  
ATOM    671  CG  GLN A  95      -1.276   2.811  18.819  1.00 87.68           C  
ATOM    672  CD  GLN A  95      -2.041   2.265  17.624  1.00 92.85           C  
ATOM    673  OE1 GLN A  95      -2.688   1.220  17.710  1.00 93.71           O  
ATOM    674  NE2 GLN A  95      -1.969   2.973  16.502  1.00 88.45           N  
ATOM    675  N   PRO A  96       3.502   2.854  19.964  1.00 70.85           N  
ATOM    676  CA  PRO A  96       4.943   2.771  19.694  1.00 71.51           C  
ATOM    677  C   PRO A  96       5.305   2.365  18.271  1.00 64.62           C  
ATOM    678  O   PRO A  96       5.252   1.189  17.916  1.00 60.06           O  
ATOM    679  CB  PRO A  96       5.454   1.752  20.722  1.00 80.10           C  
ATOM    680  CG  PRO A  96       4.270   1.426  21.624  1.00 80.20           C  
ATOM    681  CD  PRO A  96       3.193   2.425  21.337  1.00 77.32           C  
ATOM    682  N   CYS A  97       5.689   3.349  17.468  1.00 59.69           N  
ATOM    683  CA  CYS A  97       6.061   3.109  16.084  1.00 52.20           C  
ATOM    684  C   CYS A  97       7.487   3.558  15.810  1.00 44.89           C  
ATOM    685  O   CYS A  97       7.980   4.513  16.404  1.00 44.71           O  
ATOM    686  CB  CYS A  97       5.106   3.852  15.150  1.00 54.70           C  
ATOM    687  SG  CYS A  97       4.308   5.276  15.920  1.00 62.12           S  
ATOM    688  N   ALA A  98       8.150   2.856  14.904  1.00 34.12           N  
ATOM    689  CA  ALA A  98       9.511   3.196  14.545  1.00 32.06           C  
ATOM    690  C   ALA A  98       9.508   3.848  13.178  1.00 29.59           C  
ATOM    691  O   ALA A  98       8.564   3.698  12.405  1.00 40.06           O  
ATOM    692  CB  ALA A  98      10.371   1.948  14.523  1.00 37.88           C  
ATOM    693  N   LEU A  99      10.555   4.597  12.888  1.00 19.88           N  
ATOM    694  CA  LEU A  99      10.663   5.235  11.595  1.00 19.47           C  
ATOM    695  C   LEU A  99      12.107   5.024  11.157  1.00 25.00           C  
ATOM    696  O   LEU A  99      13.033   5.284  11.921  1.00 29.06           O  
ATOM    697  CB  LEU A  99      10.336   6.719  11.715  1.00 14.82           C  
ATOM    698  CG  LEU A  99       9.313   7.372  10.782  1.00 14.41           C  
ATOM    699  CD1 LEU A  99       9.828   8.738  10.360  1.00 13.17           C  
ATOM    700  CD2 LEU A  99       9.086   6.529   9.562  1.00 32.08           C  
ATOM    701  N   ASP A 100      12.310   4.506   9.951  1.00 29.66           N  
ATOM    702  CA  ASP A 100      13.668   4.306   9.476  1.00 15.74           C  
ATOM    703  C   ASP A 100      13.980   5.537   8.651  1.00 17.28           C  
ATOM    704  O   ASP A 100      13.212   5.916   7.780  1.00 15.13           O  
ATOM    705  CB  ASP A 100      13.778   3.044   8.618  1.00 17.14           C  
ATOM    706  CG  ASP A 100      13.208   1.820   9.304  1.00 23.79           C  
ATOM    707  OD1 ASP A 100      13.483   1.632  10.509  1.00 38.01           O  
ATOM    708  OD2 ASP A 100      12.479   1.043   8.644  1.00 41.81           O  
ATOM    709  N   VAL A 101      15.104   6.177   8.950  1.00 27.37           N  
ATOM    710  CA  VAL A 101      15.513   7.379   8.234  1.00 19.03           C  
ATOM    711  C   VAL A 101      16.975   7.351   7.869  1.00  2.00           C  
ATOM    712  O   VAL A 101      17.768   6.596   8.437  1.00 11.40           O  
ATOM    713  CB  VAL A 101      15.301   8.673   9.081  1.00 10.59           C  
ATOM    714  CG1 VAL A 101      15.312   9.902   8.167  1.00  3.26           C  
ATOM    715  CG2 VAL A 101      14.006   8.581   9.857  1.00  4.32           C  
ATOM    716  N   ILE A 102      17.322   8.186   6.904  1.00  6.41           N  
ATOM    717  CA  ILE A 102      18.697   8.328   6.502  1.00 12.27           C  
ATOM    718  C   ILE A 102      18.861   9.817   6.243  1.00  5.54           C  
ATOM    719  O   ILE A 102      18.117  10.381   5.457  1.00  2.00           O  
ATOM    720  CB  ILE A 102      19.016   7.531   5.227  1.00 20.88           C  
ATOM    721  CG1 ILE A 102      19.380   6.085   5.595  1.00 16.76           C  
ATOM    722  CG2 ILE A 102      20.181   8.196   4.474  1.00 14.26           C  
ATOM    723  CD1 ILE A 102      19.603   5.181   4.388  1.00 25.28           C  
ATOM    724  N   ASP A 103      19.828  10.437   6.922  1.00 11.21           N  
ATOM    725  CA  ASP A 103      20.090  11.859   6.766  1.00 13.56           C  
ATOM    726  C   ASP A 103      21.340  12.115   5.968  1.00  5.29           C  
ATOM    727  O   ASP A 103      22.388  11.572   6.270  1.00  6.70           O  
ATOM    728  CB  ASP A 103      20.243  12.539   8.122  1.00 19.45           C  
ATOM    729  CG  ASP A 103      18.921  12.978   8.701  1.00 24.98           C  
ATOM    730  OD1 ASP A 103      17.911  12.980   7.964  1.00 20.05           O  
ATOM    731  OD2 ASP A 103      18.893  13.318   9.901  1.00 37.84           O  
ATOM    732  N   VAL A 104      21.195  12.971   4.961  1.00  9.09           N  
ATOM    733  CA  VAL A 104      22.264  13.371   4.061  1.00 11.64           C  
ATOM    734  C   VAL A 104      22.638  14.858   4.316  1.00 17.43           C  
ATOM    735  O   VAL A 104      21.985  15.775   3.785  1.00 12.37           O  
ATOM    736  CB  VAL A 104      21.796  13.162   2.578  1.00  8.42           C  
ATOM    737  CG1 VAL A 104      22.917  13.488   1.612  1.00 12.35           C  
ATOM    738  CG2 VAL A 104      21.313  11.718   2.380  1.00  2.00           C  
ATOM    739  N   MET A 105      23.684  15.075   5.127  1.00  5.58           N  
ATOM    740  CA  MET A 105      24.170  16.417   5.489  1.00 13.66           C  
ATOM    741  C   MET A 105      25.440  16.906   4.789  1.00  2.51           C  
ATOM    742  O   MET A 105      26.347  16.139   4.519  1.00 19.97           O  
ATOM    743  CB  MET A 105      24.435  16.504   6.996  1.00 11.17           C  
ATOM    744  CG  MET A 105      23.216  16.558   7.868  1.00  2.00           C  
ATOM    745  SD  MET A 105      23.575  15.895   9.497  1.00 22.33           S  
ATOM    746  CE  MET A 105      21.953  15.461  10.033  1.00 24.82           C  
ATOM    747  N   ARG A 106      25.497  18.208   4.533  1.00 19.86           N  
ATOM    748  CA  ARG A 106      26.653  18.851   3.911  1.00 14.95           C  
ATOM    749  C   ARG A 106      27.140  19.941   4.862  1.00 26.79           C  
ATOM    750  O   ARG A 106      26.406  20.889   5.144  1.00 17.59           O  
ATOM    751  CB  ARG A 106      26.274  19.507   2.590  1.00 25.62           C  
ATOM    752  CG  ARG A 106      27.223  20.630   2.184  1.00 25.88           C  
ATOM    753  CD  ARG A 106      27.074  20.981   0.710  1.00 41.68           C  
ATOM    754  NE  ARG A 106      28.178  20.460  -0.099  1.00 57.51           N  
ATOM    755  CZ  ARG A 106      28.043  19.552  -1.065  1.00 59.82           C  
ATOM    756  NH1 ARG A 106      26.846  19.052  -1.352  1.00 52.47           N  
ATOM    757  NH2 ARG A 106      29.105  19.150  -1.755  1.00 53.68           N  
ATOM    758  N   PHE A 107      28.373  19.814   5.339  1.00 22.70           N  
ATOM    759  CA  PHE A 107      28.928  20.783   6.272  1.00 26.07           C  
ATOM    760  C   PHE A 107      29.695  21.910   5.574  1.00 36.40           C  
ATOM    761  O   PHE A 107      30.147  21.754   4.436  1.00 37.62           O  
ATOM    762  CB  PHE A 107      29.835  20.061   7.275  1.00 16.44           C  
ATOM    763  CG  PHE A 107      29.108  19.056   8.131  1.00 19.61           C  
ATOM    764  CD1 PHE A 107      28.558  17.908   7.570  1.00  9.52           C  
ATOM    765  CD2 PHE A 107      28.948  19.275   9.496  1.00 19.82           C  
ATOM    766  CE1 PHE A 107      27.858  16.995   8.349  1.00  6.78           C  
ATOM    767  CE2 PHE A 107      28.250  18.370  10.285  1.00 15.36           C  
ATOM    768  CZ  PHE A 107      27.701  17.225   9.707  1.00 12.76           C  
ATOM    769  N   ASP A 108      29.823  23.045   6.263  1.00 36.22           N  
ATOM    770  CA  ASP A 108      30.531  24.207   5.726  1.00 27.54           C  
ATOM    771  C   ASP A 108      31.961  24.255   6.246  1.00 28.95           C  
ATOM    772  O   ASP A 108      32.368  23.422   7.062  1.00 17.62           O  
ATOM    773  CB  ASP A 108      29.797  25.519   6.077  1.00 26.22           C  
ATOM    774  CG  ASP A 108      29.657  25.748   7.583  1.00 17.65           C  
ATOM    775  OD1 ASP A 108      28.672  26.383   7.996  1.00 20.41           O  
ATOM    776  OD2 ASP A 108      30.522  25.307   8.359  1.00 15.29           O  
ATOM    777  N   GLU A 109      32.717  25.237   5.769  1.00 33.19           N  
ATOM    778  CA  GLU A 109      34.106  25.393   6.165  1.00 35.85           C  
ATOM    779  C   GLU A 109      34.296  25.715   7.644  1.00 35.49           C  
ATOM    780  O   GLU A 109      35.428  25.849   8.110  1.00 43.87           O  
ATOM    781  CB  GLU A 109      34.784  26.460   5.303  1.00 40.37           C  
ATOM    782  CG  GLU A 109      34.389  27.873   5.639  1.00 56.74           C  
ATOM    783  CD  GLU A 109      33.077  28.260   5.011  1.00 64.68           C  
ATOM    784  OE1 GLU A 109      32.932  28.073   3.783  1.00 74.81           O  
ATOM    785  OE2 GLU A 109      32.193  28.747   5.745  1.00 66.54           O  
ATOM    786  N   HIS A 110      33.194  25.840   8.384  1.00 22.94           N  
ATOM    787  CA  HIS A 110      33.270  26.118   9.819  1.00 26.90           C  
ATOM    788  C   HIS A 110      32.676  24.946  10.560  1.00 26.86           C  
ATOM    789  O   HIS A 110      32.367  25.047  11.748  1.00 30.10           O  
ATOM    790  CB  HIS A 110      32.488  27.380  10.199  1.00 19.42           C  
ATOM    791  CG  HIS A 110      32.934  28.610   9.475  1.00 31.83           C  
ATOM    792  ND1 HIS A 110      32.075  29.391   8.731  1.00 32.11           N  
ATOM    793  CD2 HIS A 110      34.154  29.187   9.367  1.00 34.70           C  
ATOM    794  CE1 HIS A 110      32.745  30.396   8.196  1.00 40.56           C  
ATOM    795  NE2 HIS A 110      34.009  30.296   8.566  1.00 41.86           N  
ATOM    796  N   GLY A 111      32.491  23.841   9.846  1.00 24.15           N  
ATOM    797  CA  GLY A 111      31.928  22.646  10.455  1.00 22.90           C  
ATOM    798  C   GLY A 111      30.453  22.721  10.817  1.00 16.13           C  
ATOM    799  O   GLY A 111      30.008  22.042  11.741  1.00 15.16           O  
ATOM    800  N   ARG A 112      29.688  23.517  10.075  1.00 22.53           N  
ATOM    801  CA  ARG A 112      28.255  23.678  10.323  1.00 31.04           C  
ATOM    802  C   ARG A 112      27.419  23.035   9.216  1.00 30.14           C  
ATOM    803  O   ARG A 112      27.796  23.073   8.045  1.00 26.54           O  
ATOM    804  CB  ARG A 112      27.883  25.170  10.394  1.00 45.80           C  
ATOM    805  CG  ARG A 112      28.645  25.993  11.411  1.00 40.80           C  
ATOM    806  CD  ARG A 112      27.714  26.553  12.465  1.00 47.84           C  
ATOM    807  NE  ARG A 112      28.204  26.268  13.812  1.00 64.49           N  
ATOM    808  CZ  ARG A 112      28.875  27.136  14.565  1.00 72.52           C  
ATOM    809  NH1 ARG A 112      29.144  28.352  14.108  1.00 67.99           N  
ATOM    810  NH2 ARG A 112      29.284  26.786  15.777  1.00 76.48           N  
ATOM    811  N   ILE A 113      26.278  22.459   9.589  1.00 28.41           N  
ATOM    812  CA  ILE A 113      25.376  21.844   8.620  1.00 13.71           C  
ATOM    813  C   ILE A 113      24.792  22.979   7.791  1.00  8.22           C  
ATOM    814  O   ILE A 113      23.993  23.760   8.277  1.00 10.05           O  
ATOM    815  CB  ILE A 113      24.223  21.079   9.329  1.00 15.24           C  
ATOM    816  CG1 ILE A 113      24.794  20.125  10.395  1.00  3.34           C  
ATOM    817  CG2 ILE A 113      23.388  20.312   8.296  1.00 26.79           C  
ATOM    818  CD1 ILE A 113      23.743  19.456  11.273  1.00  2.00           C  
ATOM    819  N   GLN A 114      25.210  23.090   6.543  1.00 15.81           N  
ATOM    820  CA  GLN A 114      24.702  24.149   5.673  1.00 17.72           C  
ATOM    821  C   GLN A 114      23.400  23.693   5.000  1.00 20.06           C  
ATOM    822  O   GLN A 114      22.621  24.496   4.465  1.00 10.75           O  
ATOM    823  CB  GLN A 114      25.767  24.489   4.630  1.00 26.82           C  
ATOM    824  CG  GLN A 114      25.401  25.580   3.651  1.00 37.52           C  
ATOM    825  CD  GLN A 114      25.902  25.267   2.254  1.00 55.09           C  
ATOM    826  OE1 GLN A 114      25.167  24.735   1.417  1.00 66.04           O  
ATOM    827  NE2 GLN A 114      27.166  25.587   1.997  1.00 52.75           N  
ATOM    828  N   THR A 115      23.167  22.384   5.054  1.00 33.99           N  
ATOM    829  CA  THR A 115      21.986  21.772   4.457  1.00 26.95           C  
ATOM    830  C   THR A 115      21.839  20.327   4.903  1.00 17.91           C  
ATOM    831  O   THR A 115      22.833  19.623   5.061  1.00  8.91           O  
ATOM    832  CB  THR A 115      22.070  21.774   2.920  1.00 29.43           C  
ATOM    833  OG1 THR A 115      20.893  21.165   2.378  1.00 36.99           O  
ATOM    834  CG2 THR A 115      23.289  21.003   2.454  1.00 40.13           C  
ATOM    835  N   MET A 116      20.594  19.911   5.130  1.00 24.16           N  
ATOM    836  CA  MET A 116      20.261  18.542   5.527  1.00 26.88           C  
ATOM    837  C   MET A 116      19.004  18.094   4.753  1.00 27.38           C  
ATOM    838  O   MET A 116      18.102  18.899   4.503  1.00 18.76           O  
ATOM    839  CB  MET A 116      19.997  18.464   7.042  1.00 31.11           C  
ATOM    840  CG  MET A 116      19.475  17.095   7.545  1.00 20.53           C  
ATOM    841  SD  MET A 116      17.649  16.939   7.396  1.00 26.00           S  
ATOM    842  CE  MET A 116      17.183  16.558   9.032  1.00 17.51           C  
ATOM    843  N   GLN A 117      18.972  16.828   4.342  1.00 21.57           N  
ATOM    844  CA  GLN A 117      17.812  16.272   3.646  1.00 13.77           C  
ATOM    845  C   GLN A 117      17.530  14.901   4.228  1.00 18.50           C  
ATOM    846  O   GLN A 117      18.398  14.027   4.236  1.00 25.71           O  
ATOM    847  CB  GLN A 117      18.064  16.110   2.163  1.00  7.06           C  
ATOM    848  CG  GLN A 117      18.596  17.312   1.505  1.00 12.77           C  
ATOM    849  CD  GLN A 117      19.725  16.967   0.593  1.00 14.44           C  
ATOM    850  OE1 GLN A 117      19.614  17.121  -0.616  1.00 24.86           O  
ATOM    851  NE2 GLN A 117      20.830  16.491   1.167  1.00 18.85           N  
ATOM    852  N   ALA A 118      16.312  14.717   4.724  1.00 28.18           N  
ATOM    853  CA  ALA A 118      15.921  13.443   5.310  1.00 31.13           C  
ATOM    854  C   ALA A 118      15.152  12.607   4.288  1.00 35.48           C  
ATOM    855  O   ALA A 118      14.264  13.108   3.591  1.00 30.10           O  
ATOM    856  CB  ALA A 118      15.056  13.677   6.547  1.00 13.26           C  
ATOM    857  N   TYR A 119      15.505  11.333   4.185  1.00 30.74           N  
ATOM    858  CA  TYR A 119      14.809  10.468   3.261  1.00  8.39           C  
ATOM    859  C   TYR A 119      13.947   9.506   4.071  1.00  2.95           C  
ATOM    860  O   TYR A 119      14.423   8.758   4.922  1.00 11.96           O  
ATOM    861  CB  TYR A 119      15.808   9.725   2.372  1.00 21.48           C  
ATOM    862  CG  TYR A 119      16.471  10.615   1.339  1.00  6.34           C  
ATOM    863  CD1 TYR A 119      17.668  11.259   1.618  1.00  6.62           C  
ATOM    864  CD2 TYR A 119      15.901  10.806   0.080  1.00  6.78           C  
ATOM    865  CE1 TYR A 119      18.292  12.071   0.673  1.00  8.51           C  
ATOM    866  CE2 TYR A 119      16.522  11.627  -0.884  1.00 11.70           C  
ATOM    867  CZ  TYR A 119      17.719  12.254  -0.577  1.00  2.98           C  
ATOM    868  OH  TYR A 119      18.349  13.064  -1.507  1.00 10.46           O  
ATOM    869  N   TRP A 120      12.653   9.570   3.823  1.00  6.23           N  
ATOM    870  CA  TRP A 120      11.719   8.716   4.514  1.00 10.43           C  
ATOM    871  C   TRP A 120      10.312   9.057   4.055  1.00  4.17           C  
ATOM    872  O   TRP A 120      10.077  10.094   3.431  1.00 16.68           O  
ATOM    873  CB  TRP A 120      11.851   8.885   6.032  1.00 18.44           C  
ATOM    874  CG  TRP A 120      11.471  10.233   6.534  1.00 34.04           C  
ATOM    875  CD1 TRP A 120      12.297  11.306   6.724  1.00 33.82           C  
ATOM    876  CD2 TRP A 120      10.152  10.676   6.870  1.00 36.19           C  
ATOM    877  NE1 TRP A 120      11.568  12.388   7.151  1.00 36.58           N  
ATOM    878  CE2 TRP A 120      10.250  12.029   7.249  1.00 34.80           C  
ATOM    879  CE3 TRP A 120       8.895  10.057   6.882  1.00 42.01           C  
ATOM    880  CZ2 TRP A 120       9.135  12.778   7.638  1.00 43.40           C  
ATOM    881  CZ3 TRP A 120       7.788  10.801   7.267  1.00 29.67           C  
ATOM    882  CH2 TRP A 120       7.917  12.149   7.639  1.00 44.59           C  
ATOM    883  N   SER A 121       9.394   8.143   4.335  1.00 19.28           N  
ATOM    884  CA  SER A 121       7.993   8.285   3.978  1.00 18.06           C  
ATOM    885  C   SER A 121       7.252   7.269   4.838  1.00 18.03           C  
ATOM    886  O   SER A 121       7.781   6.820   5.861  1.00 22.16           O  
ATOM    887  CB  SER A 121       7.786   8.006   2.474  1.00  9.16           C  
ATOM    888  OG  SER A 121       8.017   6.647   2.135  1.00 21.73           O  
ATOM    889  N   GLU A 122       6.043   6.897   4.434  1.00 22.16           N  
ATOM    890  CA  GLU A 122       5.265   5.938   5.205  1.00 25.76           C  
ATOM    891  C   GLU A 122       5.790   4.517   5.052  1.00 29.03           C  
ATOM    892  O   GLU A 122       5.580   3.684   5.931  1.00 35.21           O  
ATOM    893  CB  GLU A 122       3.807   5.978   4.776  1.00 30.31           C  
ATOM    894  CG  GLU A 122       3.278   7.374   4.608  1.00 53.57           C  
ATOM    895  CD  GLU A 122       3.835   8.058   3.384  1.00 52.95           C  
ATOM    896  OE1 GLU A 122       3.989   7.362   2.354  1.00 44.79           O  
ATOM    897  OE2 GLU A 122       4.116   9.281   3.463  1.00 56.39           O  
ATOM    898  N   VAL A 123       6.462   4.237   3.937  1.00 22.04           N  
ATOM    899  CA  VAL A 123       7.002   2.897   3.695  1.00 24.19           C  
ATOM    900  C   VAL A 123       8.141   2.565   4.668  1.00 28.42           C  
ATOM    901  O   VAL A 123       8.540   1.405   4.818  1.00 34.15           O  
ATOM    902  CB  VAL A 123       7.480   2.752   2.220  1.00 10.12           C  
ATOM    903  CG1 VAL A 123       6.521   3.487   1.297  1.00 15.25           C  
ATOM    904  CG2 VAL A 123       8.881   3.282   2.053  1.00  8.02           C  
ATOM    905  N   ASN A 124       8.640   3.596   5.349  1.00 36.78           N  
ATOM    906  CA  ASN A 124       9.724   3.451   6.317  1.00 19.40           C  
ATOM    907  C   ASN A 124       9.181   3.432   7.753  1.00 20.18           C  
ATOM    908  O   ASN A 124       9.912   3.234   8.726  1.00 11.05           O  
ATOM    909  CB  ASN A 124      10.717   4.582   6.114  1.00 10.36           C  
ATOM    910  CG  ASN A 124      11.363   4.530   4.747  1.00  9.19           C  
ATOM    911  OD1 ASN A 124      11.145   5.399   3.895  1.00  2.76           O  
ATOM    912  ND2 ASN A 124      12.158   3.496   4.524  1.00 16.08           N  
ATOM    913  N   LEU A 125       7.875   3.623   7.863  1.00 25.67           N  
ATOM    914  CA  LEU A 125       7.190   3.596   9.148  1.00 30.95           C  
ATOM    915  C   LEU A 125       6.724   2.148   9.371  1.00 39.33           C  
ATOM    916  O   LEU A 125       5.974   1.602   8.556  1.00 43.19           O  
ATOM    917  CB  LEU A 125       5.986   4.541   9.093  1.00 25.37           C  
ATOM    918  CG  LEU A 125       5.204   4.810  10.372  1.00 30.64           C  
ATOM    919  CD1 LEU A 125       6.047   5.674  11.326  1.00 21.43           C  
ATOM    920  CD2 LEU A 125       3.892   5.504  10.001  1.00 22.33           C  
ATOM    921  N   SER A 126       7.177   1.520  10.457  1.00 44.41           N  
ATOM    922  CA  SER A 126       6.796   0.137  10.750  1.00 40.81           C  
ATOM    923  C   SER A 126       5.598   0.082  11.694  1.00 49.62           C  
ATOM    924  O   SER A 126       5.604   0.691  12.763  1.00 49.61           O  
ATOM    925  CB  SER A 126       7.965  -0.643  11.373  1.00 40.28           C  
ATOM    926  OG  SER A 126       9.203   0.046  11.264  1.00 31.84           O  
TER     927      SER A 126                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
