
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  139 ( 1104),  selected  139 , name 1jkg_A
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1jkg_A.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      M       1           -
LGA    S     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    D     5_A      -       -           -
LGA    F     6_A      -       -           -
LGA    K     7_A      M       2           #
LGA    T     8_A      -       -           -
LGA    Y     9_A      -       -           -
LGA    V    10_A      T       3          4.044
LGA    D    11_A      H       4          2.294
LGA    -       -      Y       5           -
LGA    Q    12_A      S       6          2.684
LGA    A    13_A      D       7          2.577
LGA    -       -      N       8           -
LGA    -       -      T       9           -
LGA    C    14_A      L      10          3.198
LGA    R    15_A      K      11          2.967
LGA    A    16_A      V      12          3.021
LGA    A    17_A      A      13          3.172
LGA    E    18_A      H      14          3.015
LGA    E    19_A      Q      15          3.270
LGA    F    20_A      G      16          3.173
LGA    V    21_A      F      17          2.122
LGA    N    22_A      E      18          2.224
LGA    V    23_A      F      19          2.929
LGA    Y    24_A      F      20          2.697
LGA    Y    25_A      T      21          1.584
LGA    T    26_A      Q      22          2.135
LGA    T    27_A      G      23          3.279
LGA    M    28_A      L      24          3.318
LGA    D    29_A      A      25          2.171
LGA    K    30_A      T      26          2.314
LGA    R    31_A      G      27          4.702
LGA    R    32_A      E      28          2.625
LGA    R    33_A      W      29          3.249
LGA    L    34_A      Q      30          1.026
LGA    -       -      K      31           -
LGA    L    35_A      F      32          3.052
LGA    S    36_A      L      33          2.284
LGA    R    37_A      D      34          2.151
LGA    L    38_A      M      35          2.398
LGA    Y    39_A      L      36          1.514
LGA    M    40_A      T      37          1.340
LGA    G    41_A      E      38          1.682
LGA    T    42_A      D      39          1.450
LGA    A    43_A      F      40          0.886
LGA    T    44_A      T      41          1.081
LGA    L    45_A      F      42          0.905
LGA    V    46_A      W      43          0.735
LGA    W    47_A      F      44          1.307
LGA    N    48_A      P      45          1.772
LGA    G    49_A      M      46          4.779
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    N    50_A      H      50          1.449
LGA    A    51_A      G      51          2.710
LGA    -       -      L      52           -
LGA    V    52_A      N      53          2.180
LGA    S    53_A      V      54          1.621
LGA    G    54_A      G      55          0.947
LGA    Q    55_A      K      56          0.353
LGA    E    56_A      E      57          0.129
LGA    S    57_A      R      58          0.625
LGA    L    58_A      A      59          0.737
LGA    S    59_A      K      60          0.162
LGA    E    60_A      E      61          0.829
LGA    F    61_A      F      62          1.045
LGA    F    62_A      F      63          0.805
LGA    E    63_A      T      64          0.643
LGA    M    64_A      Y      65          1.153
LGA    L    65_A      V      66          1.433
LGA    P    66_A      S      67          3.103
LGA    S    67_A      E      68          5.785
LGA    -       -      S      69           -
LGA    -       -      F      70           -
LGA    -       -      H      71           -
LGA    -       -      T      72           -
LGA    S    68_A      G      73          3.380
LGA    E    69_A      I      74          2.102
LGA    -       -      Q      75           -
LGA    F    70_A      I      76          2.175
LGA    Q    71_A      S      77          3.112
LGA    -       -      S      78           -
LGA    I    72_A      L      79          2.283
LGA    S    73_A      D      80          2.644
LGA    V    74_A      R      81          2.053
LGA    V    75_A      V      82          1.538
LGA    D    76_A      T      83          1.902
LGA    C    77_A      S      84          1.866
LGA    Q    78_A      N      85          1.926
LGA    P    79_A      E      86          1.520
LGA    V    80_A      T      87          3.332
LGA    H    81_A      -       -           -
LGA    D    82_A      -       -           -
LGA    E    83_A      -       -           -
LGA    A    84_A      -       -           -
LGA    T    85_A      -       -           -
LGA    P    86_A      -       -           -
LGA    S    87_A      -       -           -
LGA    Q    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    T    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    L    92_A      T      88          0.775
LGA    V    93_A      V      89          0.618
LGA    V    94_A      V      90          0.473
LGA    I    95_A      F      91          0.414
LGA    C    96_A      E      92          0.693
LGA    G    97_A      F      93          0.768
LGA    S    98_A      R      94          1.278
LGA    V    99_A      D      95          1.846
LGA    K   100_A      E      96          2.128
LGA    F   101_A      G      97          4.261
LGA    E   102_A      L      98          2.953
LGA    G   103_A      F      99          1.277
LGA    -       -      L     100           -
LGA    -       -      G     101           -
LGA    -       -      K     102           -
LGA    N   104_A      P     103          4.147
LGA    K   105_A      Y     104          1.862
LGA    Q   106_A      K     105          0.945
LGA    R   107_A      N     106          0.868
LGA    D   108_A      R     107          0.750
LGA    F   109_A      V     108          0.707
LGA    N   110_A      A     109          0.773
LGA    Q   111_A      V     110          0.929
LGA    N   112_A      S     111          0.547
LGA    F   113_A      F     112          1.092
LGA    I   114_A      D     113          0.211
LGA    L   115_A      V     114          1.237
LGA    T   116_A      R     115          0.943
LGA    A   117_A      G     116          0.468
LGA    Q   118_A      -       -           -
LGA    A   119_A      -       -           -
LGA    S   120_A      -       -           -
LGA    P   121_A      -       -           -
LGA    S   122_A      -       -           -
LGA    N   123_A      -       -           -
LGA    T   124_A      -       -           -
LGA    V   125_A      -       -           -
LGA    W   126_A      D     117          2.349
LGA    K   127_A      K     118          1.846
LGA    I   128_A      I     119          1.597
LGA    A   129_A      C     120          0.582
LGA    S   130_A      S     121          1.010
LGA    D   131_A      Y     122          0.570
LGA    C   132_A      R     123          0.301
LGA    F   133_A      E     124          0.535
LGA    R   134_A      Y     125          1.539
LGA    F   135_A      F     126          1.374
LGA    Q   136_A      G     127          0.777
LGA    D   137_A      S     128          2.599
LGA    W   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    S   140_A      D     129          4.577
LGA    -       -      G     130           -
LGA    -       -      K     131           -
LGA    -       -      S     132           -
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  139  133    5.0    110    2.20    13.64     66.621     4.792

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.024080 * X  +   0.176816 * Y  +   0.983949 * Z  + -21.151258
  Y_new =   0.074333 * X  +  -0.981827 * Y  +   0.174616 * Z  +  16.143250
  Z_new =   0.996943 * X  +   0.068935 * Y  +  -0.036786 * Z  + -27.777256 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.060983   -1.080609  [ DEG:   118.0857    -61.9143 ]
  Theta =  -1.492580   -1.649012  [ DEG:   -85.5186    -94.4814 ]
  Phi   =   1.257516   -1.884077  [ DEG:    72.0503   -107.9497 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jkg_A                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jkg_A.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  139  133   5.0  110   2.20   13.64  66.621
REMARK  ---------------------------------------------------------- 
MOLECULE 1jkg_A
HEADER    TRANSPORT PROTEIN                       12-JUL-01   1JKG              
TITLE     STRUCTURAL BASIS FOR THE RECOGNITION OF A NUCLEOPORIN FG-             
TITLE    2 REPEAT BY THE NTF2-LIKE DOMAIN OF TAP-P15 MRNA NUCLEAR               
TITLE    3 EXPORT FACTOR                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P15;                                                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: NTF2-RELATED EXPORT PROTEIN 1;                              
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: TAP;                                                       
COMPND   8 CHAIN: B;                                                            
COMPND   9 FRAGMENT: RESIDUES 371-619;                                          
COMPND  10 SYNONYM: TIP ASSOCIATING PROTEIN;                                    
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-28C;                                  
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  11 ORGANISM_COMMON: HUMAN;                                              
SOURCE  12 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  13 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  15 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PGEX-CS                                   
KEYWDS    NTF2-LIKE DOMAIN                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.FRIBOURG,I.C.BRAUN,E.IZAURRALDE,E.CONTI                             
REVDAT   3   01-APR-03 1JKG    1       JRNL                                     
REVDAT   2   18-DEC-02 1JKG    1       REMARK                                   
REVDAT   1   17-OCT-01 1JKG    0                                                
JRNL        AUTH   S.FRIBOURG,I.C.BRAUN,E.IZAURRALDE,E.CONTI                    
JRNL        TITL   STRUCTURAL BASIS FOR THE RECOGNITION OF A                    
JRNL        TITL 2 NUCLEOPORIN FG REPEAT BY THE NTF2-LIKE DOMAIN OF             
JRNL        TITL 3 THE TAP/P15 MRNA NUCLEAR EXPORT FACTOR.                      
JRNL        REF    MOL.CELL                      V.   8   645 2001              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1JKG A    1   140  UNP    Q9UKK6   NXT1_HUMAN       1    140             
DBREF  1JKG B  371   619  UNP    Q9UBU9   NXF1_HUMAN     371    619             
SEQRES   1 A  140  MET ALA SER VAL ASP PHE LYS THR TYR VAL ASP GLN ALA          
SEQRES   2 A  140  CYS ARG ALA ALA GLU GLU PHE VAL ASN VAL TYR TYR THR          
SEQRES   3 A  140  THR MET ASP LYS ARG ARG ARG LEU LEU SER ARG LEU TYR          
SEQRES   4 A  140  MET GLY THR ALA THR LEU VAL TRP ASN GLY ASN ALA VAL          
SEQRES   5 A  140  SER GLY GLN GLU SER LEU SER GLU PHE PHE GLU MET LEU          
SEQRES   6 A  140  PRO SER SER GLU PHE GLN ILE SER VAL VAL ASP CYS GLN          
SEQRES   7 A  140  PRO VAL HIS ASP GLU ALA THR PRO SER GLN THR THR VAL          
SEQRES   8 A  140  LEU VAL VAL ILE CYS GLY SER VAL LYS PHE GLU GLY ASN          
SEQRES   9 A  140  LYS GLN ARG ASP PHE ASN GLN ASN PHE ILE LEU THR ALA          
SEQRES  10 A  140  GLN ALA SER PRO SER ASN THR VAL TRP LYS ILE ALA SER          
SEQRES  11 A  140  ASP CYS PHE ARG PHE GLN ASP TRP ALA SER                      
SEQRES   1 B  250  ALA PRO PRO CYS LYS GLY SER TYR PHE GLY THR GLU ASN          
SEQRES   2 B  250  LEU LYS SER LEU VAL LEU HIS PHE LEU GLN GLN TYR TYR          
SEQRES   3 B  250  ALA ILE TYR ASP SER GLY ASP ARG GLN GLY LEU LEU ASP          
SEQRES   4 B  250  ALA TYR HIS ASP GLY ALA CYS CYS SER LEU SER ILE PRO          
SEQRES   5 B  250  PHE ILE PRO GLN ASN PRO ALA ARG SER SER LEU ALA GLU          
SEQRES   6 B  250  TYR PHE LYS ASP SER ARG ASN VAL LYS LYS LEU LYS ASP          
SEQRES   7 B  250  PRO THR LEU ARG PHE ARG LEU LEU LYS HIS THR ARG LEU          
SEQRES   8 B  250  ASN VAL VAL ALA PHE LEU ASN GLU LEU PRO LYS THR GLN          
SEQRES   9 B  250  HIS ASP VAL ASN SER PHE VAL VAL ASP ILE SER ALA GLN          
SEQRES  10 B  250  THR SER THR LEU LEU CYS PHE SER VAL ASN GLY VAL PHE          
SEQRES  11 B  250  LYS GLU VAL ASP GLY LYS SER ARG ASP SER LEU ARG ALA          
SEQRES  12 B  250  PHE THR ARG THR PHE ILE ALA VAL PRO ALA SER ASN SER          
SEQRES  13 B  250  GLY LEU CYS ILE VAL ASN ASP GLU LEU PHE VAL ARG ASN          
SEQRES  14 B  250  ALA SER SER GLU GLU ILE GLN ARG ALA PHE ALA MET PRO          
SEQRES  15 B  250  ALA PRO THR PRO SER SER SER PRO VAL PRO THR LEU SER          
SEQRES  16 B  250  PRO GLU GLN GLN GLU MET LEU GLN ALA PHE SER THR GLN          
SEQRES  17 B  250  SER GLY MET ASN LEU GLU TRP SER GLN LYS CYS LEU GLN          
SEQRES  18 B  250  ASP ASN ASN TRP ASP TYR THR ARG SER ALA GLN ALA PHE          
SEQRES  19 B  250  THR HIS LEU LYS ALA LYS GLY GLU ILE PRO GLU VAL ALA          
SEQRES  20 B  250  PHE MET LYS                                                  
FORMUL   3  HOH   *235(H2 O)                                                    
CRYST1  104.340  104.340  170.344  90.00  90.00 120.00 P 65 2 2     12          
ATOM      1  N   ALA A   2      47.954  18.784  -3.640  1.00 47.06           N  
ATOM      2  CA  ALA A   2      47.108  19.521  -2.707  1.00 46.39           C  
ATOM      3  C   ALA A   2      47.934  20.106  -1.567  1.00 45.80           C  
ATOM      4  O   ALA A   2      48.953  19.542  -1.172  1.00 46.27           O  
ATOM      5  CB  ALA A   2      46.022  18.606  -2.150  1.00 46.80           C  
ATOM      6  N   SER A   3      47.481  21.239  -1.040  1.00 44.46           N  
ATOM      7  CA  SER A   3      48.173  21.905   0.056  1.00 43.78           C  
ATOM      8  C   SER A   3      48.081  21.087   1.342  1.00 42.69           C  
ATOM      9  O   SER A   3      48.885  21.264   2.259  1.00 42.90           O  
ATOM     10  CB  SER A   3      47.575  23.295   0.285  1.00 43.60           C  
ATOM     11  OG  SER A   3      46.187  23.209   0.556  1.00 44.29           O  
ATOM     12  N   VAL A   4      47.096  20.195   1.406  1.00 41.02           N  
ATOM     13  CA  VAL A   4      46.906  19.336   2.576  1.00 39.15           C  
ATOM     14  C   VAL A   4      46.654  17.900   2.119  1.00 37.22           C  
ATOM     15  O   VAL A   4      45.927  17.664   1.157  1.00 36.28           O  
ATOM     16  CB  VAL A   4      45.711  19.808   3.436  1.00 39.36           C  
ATOM     17  CG1 VAL A   4      45.497  18.858   4.611  1.00 39.62           C  
ATOM     18  CG2 VAL A   4      45.963  21.215   3.948  1.00 39.88           C  
ATOM     19  N   ASP A   5      47.268  16.950   2.814  1.00 35.01           N  
ATOM     20  CA  ASP A   5      47.138  15.537   2.490  1.00 33.62           C  
ATOM     21  C   ASP A   5      45.663  15.123   2.529  1.00 30.95           C  
ATOM     22  O   ASP A   5      44.926  15.502   3.440  1.00 28.70           O  
ATOM     23  CB  ASP A   5      47.961  14.723   3.491  1.00 37.46           C  
ATOM     24  CG  ASP A   5      48.174  13.290   3.050  1.00 43.31           C  
ATOM     25  OD1 ASP A   5      48.268  13.048   1.827  1.00 45.81           O  
ATOM     26  OD2 ASP A   5      48.266  12.406   3.932  1.00 46.13           O  
ATOM     27  N   PHE A   6      45.236  14.348   1.538  1.00 28.00           N  
ATOM     28  CA  PHE A   6      43.846  13.900   1.468  1.00 26.50           C  
ATOM     29  C   PHE A   6      43.439  13.098   2.699  1.00 26.31           C  
ATOM     30  O   PHE A   6      42.334  13.270   3.220  1.00 23.99           O  
ATOM     31  CB  PHE A   6      43.622  13.052   0.213  1.00 27.04           C  
ATOM     32  CG  PHE A   6      42.191  12.642   0.009  1.00 25.28           C  
ATOM     33  CD1 PHE A   6      41.201  13.601  -0.176  1.00 26.34           C  
ATOM     34  CD2 PHE A   6      41.832  11.298   0.011  1.00 25.95           C  
ATOM     35  CE1 PHE A   6      39.867  13.229  -0.355  1.00 25.36           C  
ATOM     36  CE2 PHE A   6      40.501  10.915  -0.167  1.00 26.22           C  
ATOM     37  CZ  PHE A   6      39.518  11.883  -0.350  1.00 26.07           C  
ATOM     38  N   LYS A   7      44.323  12.225   3.172  1.00 24.87           N  
ATOM     39  CA  LYS A   7      43.989  11.420   4.339  1.00 27.27           C  
ATOM     40  C   LYS A   7      43.648  12.304   5.531  1.00 25.53           C  
ATOM     41  O   LYS A   7      42.854  11.919   6.388  1.00 24.27           O  
ATOM     42  CB  LYS A   7      45.133  10.473   4.709  1.00 30.13           C  
ATOM     43  CG  LYS A   7      44.774   9.582   5.893  1.00 34.36           C  
ATOM     44  CD  LYS A   7      45.719   8.409   6.058  1.00 36.30           C  
ATOM     45  CE  LYS A   7      45.237   7.497   7.179  1.00 36.92           C  
ATOM     46  NZ  LYS A   7      45.138   8.224   8.476  1.00 37.98           N  
ATOM     47  N   THR A   8      44.251  13.488   5.587  1.00 24.25           N  
ATOM     48  CA  THR A   8      43.975  14.413   6.681  1.00 24.69           C  
ATOM     49  C   THR A   8      42.506  14.820   6.650  1.00 23.09           C  
ATOM     50  O   THR A   8      41.848  14.889   7.691  1.00 21.25           O  
ATOM     51  CB  THR A   8      44.862  15.670   6.586  1.00 25.91           C  
ATOM     52  OG1 THR A   8      46.232  15.291   6.773  1.00 25.62           O  
ATOM     53  CG2 THR A   8      44.472  16.688   7.656  1.00 26.76           C  
ATOM     54  N   TYR A   9      41.994  15.085   5.453  1.00 22.94           N  
ATOM     55  CA  TYR A   9      40.596  15.471   5.296  1.00 23.29           C  
ATOM     56  C   TYR A   9      39.662  14.312   5.614  1.00 21.46           C  
ATOM     57  O   TYR A   9      38.596  14.505   6.200  1.00 20.45           O  
ATOM     58  CB  TYR A   9      40.320  15.939   3.868  1.00 24.67           C  
ATOM     59  CG  TYR A   9      40.874  17.304   3.544  1.00 29.61           C  
ATOM     60  CD1 TYR A   9      42.042  17.447   2.795  1.00 30.10           C  
ATOM     61  CD2 TYR A   9      40.217  18.455   3.969  1.00 31.16           C  
ATOM     62  CE1 TYR A   9      42.539  18.704   2.474  1.00 32.45           C  
ATOM     63  CE2 TYR A   9      40.706  19.715   3.656  1.00 33.60           C  
ATOM     64  CZ  TYR A   9      41.865  19.835   2.908  1.00 34.15           C  
ATOM     65  OH  TYR A   9      42.350  21.084   2.593  1.00 36.82           O  
ATOM     66  N   VAL A  10      40.055  13.109   5.208  1.00 18.98           N  
ATOM     67  CA  VAL A  10      39.230  11.932   5.453  1.00 19.17           C  
ATOM     68  C   VAL A  10      39.153  11.623   6.946  1.00 20.76           C  
ATOM     69  O   VAL A  10      38.081  11.317   7.464  1.00 20.50           O  
ATOM     70  CB  VAL A  10      39.774  10.700   4.703  1.00 20.75           C  
ATOM     71  CG1 VAL A  10      38.929   9.479   5.029  1.00 18.55           C  
ATOM     72  CG2 VAL A  10      39.760  10.968   3.198  1.00 19.69           C  
ATOM     73  N   ASP A  11      40.289  11.700   7.635  1.00 21.42           N  
ATOM     74  CA  ASP A  11      40.306  11.441   9.074  1.00 23.81           C  
ATOM     75  C   ASP A  11      39.457  12.487   9.794  1.00 21.44           C  
ATOM     76  O   ASP A  11      38.640  12.159  10.653  1.00 22.05           O  
ATOM     77  CB  ASP A  11      41.735  11.496   9.627  1.00 25.75           C  
ATOM     78  CG  ASP A  11      42.609  10.374   9.109  1.00 31.52           C  
ATOM     79  OD1 ASP A  11      42.061   9.363   8.624  1.00 35.49           O  
ATOM     80  OD2 ASP A  11      43.851  10.496   9.198  1.00 34.48           O  
ATOM     81  N   GLN A  12      39.666  13.752   9.442  1.00 20.99           N  
ATOM     82  CA  GLN A  12      38.916  14.845  10.053  1.00 21.80           C  
ATOM     83  C   GLN A  12      37.419  14.677   9.832  1.00 21.40           C  
ATOM     84  O   GLN A  12      36.621  14.914  10.741  1.00 19.15           O  
ATOM     85  CB  GLN A  12      39.357  16.191   9.473  1.00 24.09           C  
ATOM     86  CG  GLN A  12      38.521  17.363   9.969  1.00 27.61           C  
ATOM     87  CD  GLN A  12      38.953  18.685   9.371  1.00 30.01           C  
ATOM     88  OE1 GLN A  12      38.839  18.904   8.163  1.00 28.84           O  
ATOM     89  NE2 GLN A  12      39.461  19.574  10.217  1.00 32.29           N  
ATOM     90  N   ALA A  13      37.046  14.276   8.618  1.00 20.65           N  
ATOM     91  CA  ALA A  13      35.637  14.076   8.274  1.00 20.31           C  
ATOM     92  C   ALA A  13      34.997  13.001   9.155  1.00 20.29           C  
ATOM     93  O   ALA A  13      33.886  13.182   9.660  1.00 18.95           O  
ATOM     94  CB  ALA A  13      35.507  13.692   6.790  1.00 20.17           C  
ATOM     95  N   CYS A  14      35.695  11.885   9.341  1.00 20.01           N  
ATOM     96  CA  CYS A  14      35.164  10.804  10.164  1.00 21.45           C  
ATOM     97  C   CYS A  14      34.974  11.223  11.615  1.00 21.69           C  
ATOM     98  O   CYS A  14      33.951  10.916  12.223  1.00 20.90           O  
ATOM     99  CB  CYS A  14      36.084   9.586  10.118  1.00 22.60           C  
ATOM    100  SG  CYS A  14      36.086   8.724   8.544  1.00 23.84           S  
ATOM    101  N   ARG A  15      35.967  11.907  12.170  1.00 22.35           N  
ATOM    102  CA  ARG A  15      35.894  12.352  13.560  1.00 25.24           C  
ATOM    103  C   ARG A  15      34.764  13.361  13.759  1.00 23.93           C  
ATOM    104  O   ARG A  15      33.987  13.260  14.709  1.00 23.54           O  
ATOM    105  CB  ARG A  15      37.222  12.984  13.988  1.00 28.82           C  
ATOM    106  CG  ARG A  15      37.247  13.399  15.450  1.00 37.90           C  
ATOM    107  CD  ARG A  15      38.556  14.080  15.820  1.00 44.55           C  
ATOM    108  NE  ARG A  15      38.607  14.407  17.242  1.00 49.80           N  
ATOM    109  CZ  ARG A  15      39.616  15.047  17.828  1.00 52.51           C  
ATOM    110  NH1 ARG A  15      40.666  15.434  17.114  1.00 52.93           N  
ATOM    111  NH2 ARG A  15      39.575  15.298  19.131  1.00 54.07           N  
ATOM    112  N   ALA A  16      34.685  14.335  12.861  1.00 21.84           N  
ATOM    113  CA  ALA A  16      33.653  15.361  12.937  1.00 21.43           C  
ATOM    114  C   ALA A  16      32.267  14.743  12.810  1.00 21.03           C  
ATOM    115  O   ALA A  16      31.335  15.134  13.517  1.00 20.83           O  
ATOM    116  CB  ALA A  16      33.861  16.393  11.836  1.00 21.70           C  
ATOM    117  N   ALA A  17      32.132  13.780  11.904  1.00 19.91           N  
ATOM    118  CA  ALA A  17      30.851  13.126  11.673  1.00 20.36           C  
ATOM    119  C   ALA A  17      30.411  12.233  12.830  1.00 20.17           C  
ATOM    120  O   ALA A  17      29.266  12.312  13.274  1.00 21.70           O  
ATOM    121  CB  ALA A  17      30.907  12.310  10.387  1.00 21.63           C  
ATOM    122  N   GLU A  18      31.310  11.384  13.317  1.00 20.38           N  
ATOM    123  CA  GLU A  18      30.945  10.487  14.407  1.00 22.72           C  
ATOM    124  C   GLU A  18      30.532  11.261  15.651  1.00 22.12           C  
ATOM    125  O   GLU A  18      29.540  10.922  16.300  1.00 21.39           O  
ATOM    126  CB  GLU A  18      32.099   9.527  14.739  1.00 25.81           C  
ATOM    127  CG  GLU A  18      33.418  10.193  15.100  1.00 30.14           C  
ATOM    128  CD  GLU A  18      34.518   9.182  15.415  1.00 34.81           C  
ATOM    129  OE1 GLU A  18      34.318   7.972  15.159  1.00 33.80           O  
ATOM    130  OE2 GLU A  18      35.586   9.599  15.912  1.00 36.12           O  
ATOM    131  N   GLU A  19      31.281  12.309  15.978  1.00 22.05           N  
ATOM    132  CA  GLU A  19      30.966  13.104  17.157  1.00 22.70           C  
ATOM    133  C   GLU A  19      29.693  13.906  16.963  1.00 22.03           C  
ATOM    134  O   GLU A  19      28.843  13.950  17.853  1.00 21.39           O  
ATOM    135  CB  GLU A  19      32.124  14.037  17.502  1.00 24.94           C  
ATOM    136  CG  GLU A  19      33.425  13.297  17.753  1.00 31.83           C  
ATOM    137  CD  GLU A  19      34.436  14.128  18.513  1.00 35.78           C  
ATOM    138  OE1 GLU A  19      34.318  15.372  18.495  1.00 37.91           O  
ATOM    139  OE2 GLU A  19      35.354  13.535  19.117  1.00 39.12           O  
ATOM    140  N   PHE A  20      29.549  14.538  15.800  1.00 19.49           N  
ATOM    141  CA  PHE A  20      28.356  15.328  15.544  1.00 18.92           C  
ATOM    142  C   PHE A  20      27.089  14.474  15.572  1.00 19.66           C  
ATOM    143  O   PHE A  20      26.062  14.890  16.114  1.00 19.48           O  
ATOM    144  CB  PHE A  20      28.437  16.038  14.191  1.00 18.06           C  
ATOM    145  CG  PHE A  20      27.282  16.958  13.944  1.00 18.83           C  
ATOM    146  CD1 PHE A  20      27.330  18.284  14.362  1.00 18.25           C  
ATOM    147  CD2 PHE A  20      26.106  16.476  13.379  1.00 18.16           C  
ATOM    148  CE1 PHE A  20      26.218  19.116  14.226  1.00 18.45           C  
ATOM    149  CE2 PHE A  20      24.993  17.298  13.240  1.00 18.29           C  
ATOM    150  CZ  PHE A  20      25.048  18.621  13.666  1.00 16.81           C  
ATOM    151  N   VAL A  21      27.150  13.289  14.975  1.00 18.89           N  
ATOM    152  CA  VAL A  21      25.985  12.413  14.954  1.00 20.04           C  
ATOM    153  C   VAL A  21      25.558  12.063  16.375  1.00 20.17           C  
ATOM    154  O   VAL A  21      24.364  12.049  16.693  1.00 20.61           O  
ATOM    155  CB  VAL A  21      26.277  11.119  14.159  1.00 20.15           C  
ATOM    156  CG1 VAL A  21      25.187  10.085  14.414  1.00 19.07           C  
ATOM    157  CG2 VAL A  21      26.340  11.449  12.666  1.00 19.92           C  
ATOM    158  N   ASN A  22      26.537  11.780  17.226  1.00 19.77           N  
ATOM    159  CA  ASN A  22      26.254  11.448  18.617  1.00 21.92           C  
ATOM    160  C   ASN A  22      25.495  12.608  19.263  1.00 22.12           C  
ATOM    161  O   ASN A  22      24.441  12.413  19.880  1.00 21.70           O  
ATOM    162  CB  ASN A  22      27.561  11.187  19.367  1.00 25.64           C  
ATOM    163  CG  ASN A  22      27.338  10.844  20.831  1.00 30.08           C  
ATOM    164  OD1 ASN A  22      28.290  10.719  21.598  1.00 35.41           O  
ATOM    165  ND2 ASN A  22      26.081  10.685  21.221  1.00 32.13           N  
ATOM    166  N   VAL A  23      26.030  13.816  19.105  1.00 20.55           N  
ATOM    167  CA  VAL A  23      25.412  15.015  19.663  1.00 20.34           C  
ATOM    168  C   VAL A  23      24.033  15.295  19.066  1.00 20.17           C  
ATOM    169  O   VAL A  23      23.080  15.608  19.787  1.00 18.50           O  
ATOM    170  CB  VAL A  23      26.298  16.268  19.422  1.00 21.00           C  
ATOM    171  CG1 VAL A  23      25.569  17.524  19.884  1.00 19.86           C  
ATOM    172  CG2 VAL A  23      27.625  16.126  20.159  1.00 20.60           C  
ATOM    173  N   TYR A  24      23.933  15.187  17.745  1.00 17.64           N  
ATOM    174  CA  TYR A  24      22.684  15.458  17.052  1.00 18.56           C  
ATOM    175  C   TYR A  24      21.485  14.643  17.536  1.00 18.40           C  
ATOM    176  O   TYR A  24      20.462  15.209  17.927  1.00 19.13           O  
ATOM    177  CB  TYR A  24      22.854  15.235  15.544  1.00 17.57           C  
ATOM    178  CG  TYR A  24      21.638  15.635  14.744  1.00 18.78           C  
ATOM    179  CD1 TYR A  24      21.447  16.959  14.342  1.00 17.93           C  
ATOM    180  CD2 TYR A  24      20.665  14.694  14.402  1.00 18.88           C  
ATOM    181  CE1 TYR A  24      20.322  17.332  13.615  1.00 18.25           C  
ATOM    182  CE2 TYR A  24      19.530  15.059  13.677  1.00 19.00           C  
ATOM    183  CZ  TYR A  24      19.368  16.379  13.286  1.00 19.68           C  
ATOM    184  OH  TYR A  24      18.253  16.743  12.558  1.00 20.32           O  
ATOM    185  N   TYR A  25      21.598  13.321  17.511  1.00 18.85           N  
ATOM    186  CA  TYR A  25      20.471  12.499  17.925  1.00 19.54           C  
ATOM    187  C   TYR A  25      20.238  12.488  19.434  1.00 20.35           C  
ATOM    188  O   TYR A  25      19.104  12.324  19.885  1.00 21.74           O  
ATOM    189  CB  TYR A  25      20.623  11.089  17.354  1.00 19.22           C  
ATOM    190  CG  TYR A  25      20.551  11.101  15.839  1.00 19.41           C  
ATOM    191  CD1 TYR A  25      21.708  11.024  15.059  1.00 19.91           C  
ATOM    192  CD2 TYR A  25      19.330  11.271  15.186  1.00 20.46           C  
ATOM    193  CE1 TYR A  25      21.646  11.120  13.665  1.00 18.50           C  
ATOM    194  CE2 TYR A  25      19.259  11.371  13.794  1.00 19.37           C  
ATOM    195  CZ  TYR A  25      20.417  11.295  13.043  1.00 19.33           C  
ATOM    196  OH  TYR A  25      20.339  11.393  11.670  1.00 20.06           O  
ATOM    197  N   THR A  26      21.297  12.682  20.213  1.00 21.18           N  
ATOM    198  CA  THR A  26      21.144  12.738  21.666  1.00 22.16           C  
ATOM    199  C   THR A  26      20.289  13.971  21.953  1.00 22.24           C  
ATOM    200  O   THR A  26      19.325  13.922  22.725  1.00 22.78           O  
ATOM    201  CB  THR A  26      22.506  12.902  22.378  1.00 22.36           C  
ATOM    202  OG1 THR A  26      23.289  11.717  22.191  1.00 21.48           O  
ATOM    203  CG2 THR A  26      22.307  13.137  23.876  1.00 23.82           C  
ATOM    204  N   THR A  27      20.645  15.074  21.305  1.00 21.51           N  
ATOM    205  CA  THR A  27      19.937  16.334  21.466  1.00 21.81           C  
ATOM    206  C   THR A  27      18.508  16.229  20.942  1.00 22.91           C  
ATOM    207  O   THR A  27      17.568  16.705  21.580  1.00 22.15           O  
ATOM    208  CB  THR A  27      20.679  17.469  20.731  1.00 20.65           C  
ATOM    209  OG1 THR A  27      21.992  17.609  21.290  1.00 21.07           O  
ATOM    210  CG2 THR A  27      19.932  18.790  20.875  1.00 22.26           C  
ATOM    211  N   MET A  28      18.347  15.601  19.780  1.00 21.33           N  
ATOM    212  CA  MET A  28      17.028  15.424  19.185  1.00 21.78           C  
ATOM    213  C   MET A  28      16.074  14.719  20.150  1.00 21.56           C  
ATOM    214  O   MET A  28      14.915  15.117  20.300  1.00 22.45           O  
ATOM    215  CB  MET A  28      17.141  14.590  17.906  1.00 22.83           C  
ATOM    216  CG  MET A  28      15.805  14.169  17.310  1.00 25.09           C  
ATOM    217  SD  MET A  28      14.937  15.526  16.527  1.00 28.70           S  
ATOM    218  CE  MET A  28      15.666  15.452  14.871  1.00 30.45           C  
ATOM    219  N   ASP A  29      16.571  13.674  20.800  1.00 22.03           N  
ATOM    220  CA  ASP A  29      15.766  12.879  21.725  1.00 22.84           C  
ATOM    221  C   ASP A  29      15.632  13.419  23.146  1.00 23.96           C  
ATOM    222  O   ASP A  29      14.570  13.308  23.757  1.00 23.27           O  
ATOM    223  CB  ASP A  29      16.330  11.459  21.833  1.00 23.18           C  
ATOM    224  CG  ASP A  29      16.149  10.651  20.569  1.00 23.89           C  
ATOM    225  OD1 ASP A  29      15.437  11.115  19.655  1.00 25.00           O  
ATOM    226  OD2 ASP A  29      16.715   9.541  20.501  1.00 23.24           O  
ATOM    227  N   LYS A  30      16.703  14.003  23.672  1.00 23.61           N  
ATOM    228  CA  LYS A  30      16.681  14.461  25.055  1.00 24.55           C  
ATOM    229  C   LYS A  30      16.815  15.954  25.315  1.00 24.78           C  
ATOM    230  O   LYS A  30      16.712  16.388  26.461  1.00 25.86           O  
ATOM    231  CB  LYS A  30      17.762  13.706  25.826  1.00 24.73           C  
ATOM    232  CG  LYS A  30      17.773  12.214  25.526  1.00 28.74           C  
ATOM    233  CD  LYS A  30      18.957  11.512  26.169  1.00 30.62           C  
ATOM    234  CE  LYS A  30      19.100  10.094  25.640  1.00 33.85           C  
ATOM    235  NZ  LYS A  30      17.852   9.307  25.801  1.00 37.16           N  
ATOM    236  N   ARG A  31      17.043  16.741  24.272  1.00 23.67           N  
ATOM    237  CA  ARG A  31      17.182  18.182  24.449  1.00 23.53           C  
ATOM    238  C   ARG A  31      16.733  18.870  23.167  1.00 23.42           C  
ATOM    239  O   ARG A  31      17.438  19.720  22.625  1.00 22.08           O  
ATOM    240  CB  ARG A  31      18.643  18.539  24.751  1.00 22.08           C  
ATOM    241  CG  ARG A  31      18.818  19.837  25.528  1.00 24.74           C  
ATOM    242  CD  ARG A  31      18.372  19.650  26.969  1.00 24.62           C  
ATOM    243  NE  ARG A  31      18.426  20.885  27.746  1.00 24.09           N  
ATOM    244  CZ  ARG A  31      18.277  20.936  29.066  1.00 22.40           C  
ATOM    245  NH1 ARG A  31      18.067  19.819  29.750  1.00 21.23           N  
ATOM    246  NH2 ARG A  31      18.331  22.103  29.698  1.00 22.69           N  
ATOM    247  N   ARG A  32      15.540  18.501  22.704  1.00 23.52           N  
ATOM    248  CA  ARG A  32      14.962  19.018  21.463  1.00 23.90           C  
ATOM    249  C   ARG A  32      15.099  20.521  21.225  1.00 23.80           C  
ATOM    250  O   ARG A  32      15.422  20.955  20.123  1.00 22.53           O  
ATOM    251  CB  ARG A  32      13.479  18.619  21.389  1.00 24.75           C  
ATOM    252  CG  ARG A  32      12.776  18.959  20.074  1.00 27.36           C  
ATOM    253  CD  ARG A  32      13.309  18.113  18.921  1.00 25.84           C  
ATOM    254  NE  ARG A  32      12.995  16.694  19.082  1.00 24.66           N  
ATOM    255  CZ  ARG A  32      11.810  16.146  18.821  1.00 26.38           C  
ATOM    256  NH1 ARG A  32      10.802  16.890  18.380  1.00 25.87           N  
ATOM    257  NH2 ARG A  32      11.631  14.845  19.001  1.00 24.76           N  
ATOM    258  N   ARG A  33      14.855  21.320  22.257  1.00 25.09           N  
ATOM    259  CA  ARG A  33      14.924  22.773  22.125  1.00 26.49           C  
ATOM    260  C   ARG A  33      16.287  23.337  21.780  1.00 25.27           C  
ATOM    261  O   ARG A  33      16.407  24.503  21.402  1.00 25.86           O  
ATOM    262  CB  ARG A  33      14.435  23.434  23.408  1.00 31.14           C  
ATOM    263  CG  ARG A  33      12.983  23.129  23.707  1.00 38.47           C  
ATOM    264  CD  ARG A  33      12.482  23.880  24.925  1.00 44.33           C  
ATOM    265  NE  ARG A  33      11.079  23.597  25.208  1.00 49.10           N  
ATOM    266  CZ  ARG A  33      10.388  24.178  26.184  1.00 52.18           C  
ATOM    267  NH1 ARG A  33      10.979  25.077  26.967  1.00 52.85           N  
ATOM    268  NH2 ARG A  33       9.113  23.855  26.381  1.00 52.52           N  
ATOM    269  N   LEU A  34      17.312  22.512  21.922  1.00 24.62           N  
ATOM    270  CA  LEU A  34      18.669  22.945  21.635  1.00 25.58           C  
ATOM    271  C   LEU A  34      19.116  22.536  20.232  1.00 23.88           C  
ATOM    272  O   LEU A  34      20.133  23.017  19.729  1.00 24.06           O  
ATOM    273  CB  LEU A  34      19.608  22.340  22.673  1.00 28.98           C  
ATOM    274  CG  LEU A  34      21.034  22.865  22.796  1.00 33.99           C  
ATOM    275  CD1 LEU A  34      21.050  24.348  23.180  1.00 36.45           C  
ATOM    276  CD2 LEU A  34      21.726  22.038  23.864  1.00 36.05           C  
ATOM    277  N   LEU A  35      18.340  21.667  19.592  1.00 22.29           N  
ATOM    278  CA  LEU A  35      18.695  21.160  18.268  1.00 22.31           C  
ATOM    279  C   LEU A  35      18.969  22.203  17.185  1.00 22.08           C  
ATOM    280  O   LEU A  35      19.922  22.059  16.416  1.00 22.18           O  
ATOM    281  CB  LEU A  35      17.623  20.191  17.763  1.00 22.05           C  
ATOM    282  CG  LEU A  35      18.114  19.274  16.634  1.00 22.92           C  
ATOM    283  CD1 LEU A  35      19.088  18.250  17.212  1.00 22.45           C  
ATOM    284  CD2 LEU A  35      16.947  18.564  15.976  1.00 24.07           C  
ATOM    285  N   SER A  36      18.144  23.243  17.109  1.00 20.56           N  
ATOM    286  CA  SER A  36      18.328  24.264  16.080  1.00 21.83           C  
ATOM    287  C   SER A  36      19.666  24.994  16.179  1.00 22.16           C  
ATOM    288  O   SER A  36      20.118  25.609  15.211  1.00 21.60           O  
ATOM    289  CB  SER A  36      17.182  25.280  16.122  1.00 23.46           C  
ATOM    290  OG  SER A  36      17.193  26.012  17.332  1.00 25.64           O  
ATOM    291  N   ARG A  37      20.305  24.934  17.343  1.00 21.76           N  
ATOM    292  CA  ARG A  37      21.593  25.595  17.508  1.00 24.03           C  
ATOM    293  C   ARG A  37      22.700  24.827  16.795  1.00 22.54           C  
ATOM    294  O   ARG A  37      23.806  25.339  16.609  1.00 22.83           O  
ATOM    295  CB  ARG A  37      21.929  25.757  18.994  1.00 26.79           C  
ATOM    296  CG  ARG A  37      21.092  26.833  19.673  1.00 31.25           C  
ATOM    297  CD  ARG A  37      21.536  27.092  21.104  1.00 37.59           C  
ATOM    298  NE  ARG A  37      20.790  28.198  21.703  1.00 43.46           N  
ATOM    299  CZ  ARG A  37      20.869  29.464  21.299  1.00 45.74           C  
ATOM    300  NH1 ARG A  37      21.669  29.794  20.293  1.00 47.41           N  
ATOM    301  NH2 ARG A  37      20.141  30.401  21.893  1.00 47.17           N  
ATOM    302  N   LEU A  38      22.397  23.602  16.384  1.00 20.98           N  
ATOM    303  CA  LEU A  38      23.376  22.788  15.675  1.00 20.41           C  
ATOM    304  C   LEU A  38      23.323  23.111  14.184  1.00 20.80           C  
ATOM    305  O   LEU A  38      24.092  22.561  13.396  1.00 19.78           O  
ATOM    306  CB  LEU A  38      23.089  21.300  15.884  1.00 20.40           C  
ATOM    307  CG  LEU A  38      23.071  20.760  17.315  1.00 20.80           C  
ATOM    308  CD1 LEU A  38      22.809  19.258  17.282  1.00 19.85           C  
ATOM    309  CD2 LEU A  38      24.400  21.051  17.998  1.00 21.84           C  
ATOM    310  N   TYR A  39      22.411  24.002  13.806  1.00 20.02           N  
ATOM    311  CA  TYR A  39      22.250  24.401  12.409  1.00 20.63           C  
ATOM    312  C   TYR A  39      22.744  25.816  12.137  1.00 21.67           C  
ATOM    313  O   TYR A  39      22.756  26.668  13.029  1.00 21.72           O  
ATOM    314  CB  TYR A  39      20.778  24.344  11.987  1.00 20.45           C  
ATOM    315  CG  TYR A  39      20.183  22.961  11.847  1.00 20.61           C  
ATOM    316  CD1 TYR A  39      19.854  22.201  12.969  1.00 20.99           C  
ATOM    317  CD2 TYR A  39      19.913  22.429  10.587  1.00 20.96           C  
ATOM    318  CE1 TYR A  39      19.260  20.944  12.838  1.00 21.64           C  
ATOM    319  CE2 TYR A  39      19.321  21.173  10.443  1.00 19.83           C  
ATOM    320  CZ  TYR A  39      18.996  20.438  11.573  1.00 21.45           C  
ATOM    321  OH  TYR A  39      18.392  19.206  11.444  1.00 21.87           O  
ATOM    322  N   MET A  40      23.137  26.058  10.890  1.00 22.19           N  
ATOM    323  CA  MET A  40      23.577  27.379  10.459  1.00 22.24           C  
ATOM    324  C   MET A  40      22.317  28.235  10.333  1.00 22.68           C  
ATOM    325  O   MET A  40      21.219  27.708  10.139  1.00 21.90           O  
ATOM    326  CB  MET A  40      24.273  27.289   9.099  1.00 21.78           C  
ATOM    327  CG  MET A  40      25.630  26.589   9.126  1.00 23.06           C  
ATOM    328  SD  MET A  40      26.874  27.550  10.012  1.00 23.99           S  
ATOM    329  CE  MET A  40      27.184  28.862   8.820  1.00 23.26           C  
ATOM    330  N   GLY A  41      22.470  29.551  10.439  1.00 23.32           N  
ATOM    331  CA  GLY A  41      21.322  30.434  10.334  1.00 24.35           C  
ATOM    332  C   GLY A  41      20.530  30.290   9.047  1.00 24.70           C  
ATOM    333  O   GLY A  41      19.302  30.386   9.053  1.00 26.77           O  
ATOM    334  N   THR A  42      21.229  30.050   7.942  1.00 23.69           N  
ATOM    335  CA  THR A  42      20.585  29.912   6.641  1.00 24.99           C  
ATOM    336  C   THR A  42      20.256  28.465   6.277  1.00 23.93           C  
ATOM    337  O   THR A  42      19.748  28.198   5.190  1.00 23.29           O  
ATOM    338  CB  THR A  42      21.481  30.469   5.517  1.00 26.23           C  
ATOM    339  OG1 THR A  42      22.670  29.674   5.424  1.00 28.21           O  
ATOM    340  CG2 THR A  42      21.870  31.916   5.802  1.00 27.51           C  
ATOM    341  N   ALA A  43      20.542  27.533   7.179  1.00 23.09           N  
ATOM    342  CA  ALA A  43      20.290  26.122   6.905  1.00 22.29           C  
ATOM    343  C   ALA A  43      18.843  25.803   6.569  1.00 22.14           C  
ATOM    344  O   ALA A  43      17.914  26.471   7.029  1.00 21.27           O  
ATOM    345  CB  ALA A  43      20.735  25.268   8.092  1.00 22.40           C  
ATOM    346  N   THR A  44      18.667  24.766   5.758  1.00 22.03           N  
ATOM    347  CA  THR A  44      17.348  24.302   5.364  1.00 21.40           C  
ATOM    348  C   THR A  44      17.275  22.806   5.624  1.00 22.22           C  
ATOM    349  O   THR A  44      18.299  22.137   5.773  1.00 20.96           O  
ATOM    350  CB  THR A  44      17.083  24.516   3.867  1.00 23.49           C  
ATOM    351  OG1 THR A  44      18.065  23.801   3.108  1.00 23.59           O  
ATOM    352  CG2 THR A  44      17.129  25.993   3.515  1.00 23.63           C  
ATOM    353  N   LEU A  45      16.055  22.292   5.673  1.00 21.94           N  
ATOM    354  CA  LEU A  45      15.810  20.876   5.890  1.00 23.08           C  
ATOM    355  C   LEU A  45      14.685  20.425   4.972  1.00 23.71           C  
ATOM    356  O   LEU A  45      13.639  21.074   4.902  1.00 24.85           O  
ATOM    357  CB  LEU A  45      15.401  20.616   7.349  1.00 23.19           C  
ATOM    358  CG  LEU A  45      14.622  19.322   7.645  1.00 24.62           C  
ATOM    359  CD1 LEU A  45      15.488  18.102   7.350  1.00 21.16           C  
ATOM    360  CD2 LEU A  45      14.178  19.313   9.104  1.00 25.17           C  
ATOM    361  N   VAL A  46      14.914  19.342   4.232  1.00 21.42           N  
ATOM    362  CA  VAL A  46      13.869  18.788   3.388  1.00 21.11           C  
ATOM    363  C   VAL A  46      13.467  17.545   4.176  1.00 21.93           C  
ATOM    364  O   VAL A  46      14.181  16.541   4.188  1.00 19.96           O  
ATOM    365  CB  VAL A  46      14.375  18.395   1.987  1.00 20.91           C  
ATOM    366  CG1 VAL A  46      13.228  17.776   1.184  1.00 20.81           C  
ATOM    367  CG2 VAL A  46      14.902  19.627   1.261  1.00 20.14           C  
ATOM    368  N   TRP A  47      12.331  17.646   4.858  1.00 22.33           N  
ATOM    369  CA  TRP A  47      11.820  16.578   5.704  1.00 23.31           C  
ATOM    370  C   TRP A  47      10.677  15.865   4.993  1.00 23.21           C  
ATOM    371  O   TRP A  47       9.584  16.413   4.863  1.00 22.89           O  
ATOM    372  CB  TRP A  47      11.318  17.182   7.017  1.00 24.39           C  
ATOM    373  CG  TRP A  47      11.115  16.202   8.132  1.00 25.59           C  
ATOM    374  CD1 TRP A  47      12.060  15.743   9.007  1.00 25.83           C  
ATOM    375  CD2 TRP A  47       9.884  15.571   8.499  1.00 26.95           C  
ATOM    376  NE1 TRP A  47      11.489  14.863   9.898  1.00 28.05           N  
ATOM    377  CE2 TRP A  47      10.157  14.740   9.608  1.00 26.16           C  
ATOM    378  CE3 TRP A  47       8.578  15.627   7.998  1.00 26.98           C  
ATOM    379  CZ2 TRP A  47       9.166  13.970  10.227  1.00 28.19           C  
ATOM    380  CZ3 TRP A  47       7.592  14.860   8.614  1.00 28.83           C  
ATOM    381  CH2 TRP A  47       7.894  14.042   9.717  1.00 27.95           C  
ATOM    382  N   ASN A  48      10.936  14.643   4.544  1.00 22.65           N  
ATOM    383  CA  ASN A  48       9.932  13.869   3.828  1.00 23.55           C  
ATOM    384  C   ASN A  48       9.269  14.714   2.747  1.00 23.99           C  
ATOM    385  O   ASN A  48       8.046  14.763   2.644  1.00 25.02           O  
ATOM    386  CB  ASN A  48       8.882  13.335   4.803  1.00 22.82           C  
ATOM    387  CG  ASN A  48       9.420  12.226   5.674  1.00 23.73           C  
ATOM    388  OD1 ASN A  48       9.762  11.145   5.183  1.00 21.50           O  
ATOM    389  ND2 ASN A  48       9.509  12.484   6.976  1.00 24.83           N  
ATOM    390  N   GLY A  49      10.091  15.390   1.947  1.00 23.60           N  
ATOM    391  CA  GLY A  49       9.568  16.204   0.865  1.00 23.77           C  
ATOM    392  C   GLY A  49       9.080  17.589   1.242  1.00 24.67           C  
ATOM    393  O   GLY A  49       8.599  18.322   0.381  1.00 25.80           O  
ATOM    394  N   ASN A  50       9.202  17.952   2.515  1.00 24.57           N  
ATOM    395  CA  ASN A  50       8.766  19.266   2.992  1.00 25.67           C  
ATOM    396  C   ASN A  50       9.976  20.140   3.310  1.00 25.13           C  
ATOM    397  O   ASN A  50      10.782  19.792   4.171  1.00 24.79           O  
ATOM    398  CB  ASN A  50       7.924  19.112   4.262  1.00 25.61           C  
ATOM    399  CG  ASN A  50       6.629  18.358   4.019  1.00 27.74           C  
ATOM    400  OD1 ASN A  50       5.656  18.919   3.515  1.00 29.48           O  
ATOM    401  ND2 ASN A  50       6.615  17.078   4.374  1.00 26.21           N  
ATOM    402  N   ALA A  51      10.093  21.277   2.632  1.00 25.84           N  
ATOM    403  CA  ALA A  51      11.217  22.176   2.862  1.00 26.39           C  
ATOM    404  C   ALA A  51      10.965  23.127   4.026  1.00 27.53           C  
ATOM    405  O   ALA A  51       9.915  23.768   4.105  1.00 27.11           O  
ATOM    406  CB  ALA A  51      11.522  22.975   1.595  1.00 25.97           C  
ATOM    407  N   VAL A  52      11.933  23.196   4.932  1.00 26.38           N  
ATOM    408  CA  VAL A  52      11.871  24.075   6.095  1.00 27.55           C  
ATOM    409  C   VAL A  52      13.117  24.943   5.979  1.00 28.24           C  
ATOM    410  O   VAL A  52      14.232  24.422   5.937  1.00 28.31           O  
ATOM    411  CB  VAL A  52      11.914  23.272   7.413  1.00 27.18           C  
ATOM    412  CG1 VAL A  52      11.806  24.220   8.608  1.00 27.58           C  
ATOM    413  CG2 VAL A  52      10.780  22.257   7.442  1.00 27.49           C  
ATOM    414  N   SER A  53      12.931  26.260   5.920  1.00 27.94           N  
ATOM    415  CA  SER A  53      14.057  27.178   5.755  1.00 29.29           C  
ATOM    416  C   SER A  53      14.320  28.151   6.902  1.00 29.73           C  
ATOM    417  O   SER A  53      13.407  28.802   7.410  1.00 28.43           O  
ATOM    418  CB  SER A  53      13.872  27.982   4.465  1.00 29.49           C  
ATOM    419  OG  SER A  53      13.750  27.128   3.341  1.00 35.21           O  
ATOM    420  N   GLY A  54      15.588  28.260   7.288  1.00 29.31           N  
ATOM    421  CA  GLY A  54      15.954  29.175   8.350  1.00 29.78           C  
ATOM    422  C   GLY A  54      15.930  28.561   9.731  1.00 28.96           C  
ATOM    423  O   GLY A  54      15.022  27.810  10.085  1.00 28.05           O  
ATOM    424  N   GLN A  55      16.945  28.897  10.517  1.00 29.88           N  
ATOM    425  CA  GLN A  55      17.080  28.391  11.875  1.00 31.10           C  
ATOM    426  C   GLN A  55      15.825  28.633  12.719  1.00 30.99           C  
ATOM    427  O   GLN A  55      15.457  27.796  13.546  1.00 31.25           O  
ATOM    428  CB  GLN A  55      18.307  29.038  12.524  1.00 31.25           C  
ATOM    429  CG  GLN A  55      18.652  28.538  13.908  1.00 32.48           C  
ATOM    430  CD  GLN A  55      19.937  29.153  14.418  1.00 33.78           C  
ATOM    431  OE1 GLN A  55      20.109  30.370  14.376  1.00 34.97           O  
ATOM    432  NE2 GLN A  55      20.848  28.318  14.899  1.00 32.17           N  
ATOM    433  N   GLU A  56      15.163  29.767  12.511  1.00 32.04           N  
ATOM    434  CA  GLU A  56      13.950  30.076  13.269  1.00 33.02           C  
ATOM    435  C   GLU A  56      12.828  29.101  12.918  1.00 31.51           C  
ATOM    436  O   GLU A  56      12.159  28.566  13.802  1.00 30.09           O  
ATOM    437  CB  GLU A  56      13.486  31.506  12.988  1.00 37.39           C  
ATOM    438  CG  GLU A  56      14.472  32.589  13.404  1.00 45.19           C  
ATOM    439  CD  GLU A  56      14.785  32.568  14.890  1.00 49.37           C  
ATOM    440  OE1 GLU A  56      13.842  32.710  15.700  1.00 52.82           O  
ATOM    441  OE2 GLU A  56      15.974  32.414  15.249  1.00 51.21           O  
ATOM    442  N   SER A  57      12.621  28.874  11.624  1.00 29.96           N  
ATOM    443  CA  SER A  57      11.583  27.951  11.187  1.00 28.85           C  
ATOM    444  C   SER A  57      11.948  26.532  11.595  1.00 26.68           C  
ATOM    445  O   SER A  57      11.076  25.720  11.895  1.00 26.27           O  
ATOM    446  CB  SER A  57      11.403  28.018   9.670  1.00 30.69           C  
ATOM    447  OG  SER A  57      10.941  29.295   9.272  1.00 34.79           O  
ATOM    448  N   LEU A  58      13.244  26.232  11.600  1.00 25.45           N  
ATOM    449  CA  LEU A  58      13.705  24.900  11.982  1.00 25.08           C  
ATOM    450  C   LEU A  58      13.392  24.642  13.451  1.00 24.79           C  
ATOM    451  O   LEU A  58      12.932  23.559  13.820  1.00 24.69           O  
ATOM    452  CB  LEU A  58      15.213  24.766  11.740  1.00 23.07           C  
ATOM    453  CG  LEU A  58      15.636  24.633  10.273  1.00 23.44           C  
ATOM    454  CD1 LEU A  58      17.148  24.798  10.145  1.00 23.08           C  
ATOM    455  CD2 LEU A  58      15.187  23.277   9.741  1.00 22.46           C  
ATOM    456  N   SER A  59      13.640  25.644  14.285  1.00 25.99           N  
ATOM    457  CA  SER A  59      13.378  25.528  15.713  1.00 26.20           C  
ATOM    458  C   SER A  59      11.902  25.210  15.956  1.00 26.65           C  
ATOM    459  O   SER A  59      11.565  24.318  16.736  1.00 24.77           O  
ATOM    460  CB  SER A  59      13.757  26.831  16.419  1.00 28.96           C  
ATOM    461  OG  SER A  59      13.497  26.744  17.807  1.00 31.97           O  
ATOM    462  N   GLU A  60      11.025  25.939  15.274  1.00 26.70           N  
ATOM    463  CA  GLU A  60       9.589  25.731  15.414  1.00 28.92           C  
ATOM    464  C   GLU A  60       9.176  24.354  14.908  1.00 28.11           C  
ATOM    465  O   GLU A  60       8.308  23.701  15.489  1.00 26.68           O  
ATOM    466  CB  GLU A  60       8.832  26.818  14.651  1.00 31.34           C  
ATOM    467  CG  GLU A  60       8.784  28.146  15.386  1.00 37.49           C  
ATOM    468  CD  GLU A  60       8.540  29.319  14.459  1.00 41.14           C  
ATOM    469  OE1 GLU A  60       7.684  29.207  13.557  1.00 43.23           O  
ATOM    470  OE2 GLU A  60       9.204  30.362  14.641  1.00 43.78           O  
ATOM    471  N   PHE A  61       9.808  23.916  13.825  1.00 28.30           N  
ATOM    472  CA  PHE A  61       9.507  22.617  13.239  1.00 28.57           C  
ATOM    473  C   PHE A  61       9.850  21.502  14.221  1.00 28.90           C  
ATOM    474  O   PHE A  61       9.067  20.572  14.430  1.00 28.60           O  
ATOM    475  CB  PHE A  61      10.313  22.422  11.950  1.00 29.61           C  
ATOM    476  CG  PHE A  61      10.021  21.130  11.245  1.00 31.37           C  
ATOM    477  CD1 PHE A  61       8.863  20.982  10.485  1.00 32.92           C  
ATOM    478  CD2 PHE A  61      10.892  20.051  11.355  1.00 33.06           C  
ATOM    479  CE1 PHE A  61       8.576  19.777   9.846  1.00 33.73           C  
ATOM    480  CE2 PHE A  61      10.615  18.840  10.721  1.00 33.84           C  
ATOM    481  CZ  PHE A  61       9.455  18.704   9.966  1.00 33.11           C  
ATOM    482  N   PHE A  62      11.033  21.604  14.822  1.00 28.69           N  
ATOM    483  CA  PHE A  62      11.504  20.610  15.782  1.00 30.35           C  
ATOM    484  C   PHE A  62      10.655  20.553  17.048  1.00 30.88           C  
ATOM    485  O   PHE A  62      10.417  19.476  17.595  1.00 29.09           O  
ATOM    486  CB  PHE A  62      12.960  20.900  16.149  1.00 29.32           C  
ATOM    487  CG  PHE A  62      13.920  20.721  15.008  1.00 30.72           C  
ATOM    488  CD1 PHE A  62      15.077  21.492  14.930  1.00 31.94           C  
ATOM    489  CD2 PHE A  62      13.676  19.773  14.018  1.00 29.83           C  
ATOM    490  CE1 PHE A  62      15.979  21.324  13.875  1.00 32.95           C  
ATOM    491  CE2 PHE A  62      14.573  19.597  12.959  1.00 32.24           C  
ATOM    492  CZ  PHE A  62      15.725  20.374  12.891  1.00 30.39           C  
ATOM    493  N   GLU A  63      10.209  21.707  17.530  1.00 34.40           N  
ATOM    494  CA  GLU A  63       9.386  21.716  18.729  1.00 37.95           C  
ATOM    495  C   GLU A  63       7.990  21.203  18.384  1.00 37.61           C  
ATOM    496  O   GLU A  63       7.281  20.679  19.240  1.00 38.17           O  
ATOM    497  CB  GLU A  63       9.318  23.123  19.333  1.00 41.98           C  
ATOM    498  CG  GLU A  63       8.752  24.196  18.426  1.00 48.41           C  
ATOM    499  CD  GLU A  63       8.666  25.544  19.121  1.00 51.93           C  
ATOM    500  OE1 GLU A  63       9.713  26.040  19.597  1.00 54.46           O  
ATOM    501  OE2 GLU A  63       7.554  26.112  19.192  1.00 53.50           O  
ATOM    502  N   MET A  64       7.621  21.345  17.116  1.00 38.19           N  
ATOM    503  CA  MET A  64       6.326  20.897  16.606  1.00 39.14           C  
ATOM    504  C   MET A  64       6.248  19.369  16.576  1.00 38.07           C  
ATOM    505  O   MET A  64       5.215  18.781  16.901  1.00 36.63           O  
ATOM    506  CB  MET A  64       6.119  21.450  15.192  1.00 42.91           C  
ATOM    507  CG  MET A  64       4.928  20.882  14.440  1.00 47.55           C  
ATOM    508  SD  MET A  64       5.019  21.251  12.662  1.00 53.71           S  
ATOM    509  CE  MET A  64       4.480  22.952  12.635  1.00 52.10           C  
ATOM    510  N   LEU A  65       7.349  18.734  16.178  1.00 36.41           N  
ATOM    511  CA  LEU A  65       7.419  17.280  16.091  1.00 35.14           C  
ATOM    512  C   LEU A  65       7.285  16.587  17.441  1.00 34.89           C  
ATOM    513  O   LEU A  65       7.727  17.107  18.467  1.00 33.42           O  
ATOM    514  CB  LEU A  65       8.740  16.848  15.446  1.00 36.27           C  
ATOM    515  CG  LEU A  65       8.938  17.133  13.957  1.00 37.51           C  
ATOM    516  CD1 LEU A  65      10.331  16.682  13.542  1.00 36.77           C  
ATOM    517  CD2 LEU A  65       7.874  16.407  13.144  1.00 37.65           C  
ATOM    518  N   PRO A  66       6.678  15.389  17.452  1.00 34.36           N  
ATOM    519  CA  PRO A  66       6.479  14.601  18.672  1.00 34.32           C  
ATOM    520  C   PRO A  66       7.820  14.190  19.276  1.00 34.53           C  
ATOM    521  O   PRO A  66       8.859  14.284  18.618  1.00 33.38           O  
ATOM    522  CB  PRO A  66       5.700  13.381  18.178  1.00 34.04           C  
ATOM    523  CG  PRO A  66       4.989  13.887  16.958  1.00 34.39           C  
ATOM    524  CD  PRO A  66       6.051  14.724  16.298  1.00 35.09           C  
ATOM    525  N   SER A  67       7.790  13.736  20.526  1.00 33.57           N  
ATOM    526  CA  SER A  67       9.000  13.284  21.208  1.00 34.81           C  
ATOM    527  C   SER A  67       9.563  12.129  20.393  1.00 32.69           C  
ATOM    528  O   SER A  67       8.813  11.406  19.733  1.00 32.33           O  
ATOM    529  CB  SER A  67       8.669  12.807  22.619  1.00 36.12           C  
ATOM    530  OG  SER A  67       8.119  13.863  23.387  1.00 42.01           O  
ATOM    531  N   SER A  68      10.876  11.943  20.438  1.00 30.53           N  
ATOM    532  CA  SER A  68      11.487  10.885  19.648  1.00 28.75           C  
ATOM    533  C   SER A  68      12.477   9.990  20.369  1.00 28.01           C  
ATOM    534  O   SER A  68      13.002  10.322  21.431  1.00 26.59           O  
ATOM    535  CB  SER A  68      12.193  11.502  18.439  1.00 28.81           C  
ATOM    536  OG  SER A  68      13.258  12.338  18.865  1.00 26.46           O  
ATOM    537  N   GLU A  69      12.732   8.849  19.745  1.00 26.30           N  
ATOM    538  CA  GLU A  69      13.682   7.865  20.232  1.00 27.11           C  
ATOM    539  C   GLU A  69      14.383   7.323  18.989  1.00 26.52           C  
ATOM    540  O   GLU A  69      13.812   6.521  18.251  1.00 24.41           O  
ATOM    541  CB  GLU A  69      12.956   6.742  20.974  1.00 31.44           C  
ATOM    542  CG  GLU A  69      13.852   5.585  21.371  1.00 39.73           C  
ATOM    543  CD  GLU A  69      13.352   4.857  22.603  1.00 44.17           C  
ATOM    544  OE1 GLU A  69      12.133   4.588  22.685  1.00 48.09           O  
ATOM    545  OE2 GLU A  69      14.180   4.549  23.487  1.00 47.82           O  
ATOM    546  N   PHE A  70      15.607   7.787  18.750  1.00 24.66           N  
ATOM    547  CA  PHE A  70      16.387   7.358  17.592  1.00 24.04           C  
ATOM    548  C   PHE A  70      17.392   6.267  17.933  1.00 24.95           C  
ATOM    549  O   PHE A  70      18.000   6.280  19.001  1.00 24.88           O  
ATOM    550  CB  PHE A  70      17.164   8.536  16.983  1.00 23.91           C  
ATOM    551  CG  PHE A  70      16.358   9.393  16.049  1.00 21.57           C  
ATOM    552  CD1 PHE A  70      15.518  10.388  16.535  1.00 22.52           C  
ATOM    553  CD2 PHE A  70      16.458   9.214  14.670  1.00 21.05           C  
ATOM    554  CE1 PHE A  70      14.790  11.200  15.661  1.00 24.26           C  
ATOM    555  CE2 PHE A  70      15.736  10.015  13.787  1.00 19.84           C  
ATOM    556  CZ  PHE A  70      14.901  11.011  14.278  1.00 22.34           C  
ATOM    557  N   GLN A  71      17.561   5.328  17.009  1.00 24.47           N  
ATOM    558  CA  GLN A  71      18.516   4.243  17.165  1.00 26.87           C  
ATOM    559  C   GLN A  71      19.349   4.314  15.888  1.00 25.23           C  
ATOM    560  O   GLN A  71      18.868   3.980  14.807  1.00 23.25           O  
ATOM    561  CB  GLN A  71      17.798   2.892  17.246  1.00 30.95           C  
ATOM    562  CG  GLN A  71      18.592   1.794  17.955  1.00 40.86           C  
ATOM    563  CD  GLN A  71      19.917   1.475  17.280  1.00 46.07           C  
ATOM    564  OE1 GLN A  71      19.952   1.059  16.120  1.00 49.32           O  
ATOM    565  NE2 GLN A  71      21.015   1.661  18.010  1.00 47.56           N  
ATOM    566  N   ILE A  72      20.590   4.767  16.012  1.00 24.45           N  
ATOM    567  CA  ILE A  72      21.465   4.902  14.851  1.00 24.34           C  
ATOM    568  C   ILE A  72      22.352   3.675  14.677  1.00 24.35           C  
ATOM    569  O   ILE A  72      23.049   3.269  15.603  1.00 25.40           O  
ATOM    570  CB  ILE A  72      22.359   6.149  14.988  1.00 23.87           C  
ATOM    571  CG1 ILE A  72      21.504   7.370  15.349  1.00 23.84           C  
ATOM    572  CG2 ILE A  72      23.128   6.382  13.695  1.00 24.99           C  
ATOM    573  CD1 ILE A  72      20.400   7.689  14.353  1.00 22.65           C  
ATOM    574  N   SER A  73      22.339   3.092  13.483  1.00 23.37           N  
ATOM    575  CA  SER A  73      23.143   1.902  13.232  1.00 23.78           C  
ATOM    576  C   SER A  73      24.169   2.057  12.116  1.00 22.88           C  
ATOM    577  O   SER A  73      25.154   1.317  12.070  1.00 22.69           O  
ATOM    578  CB  SER A  73      22.229   0.721  12.913  1.00 25.65           C  
ATOM    579  OG  SER A  73      21.359   1.044  11.845  1.00 24.89           O  
ATOM    580  N   VAL A  74      23.942   3.011  11.219  1.00 20.51           N  
ATOM    581  CA  VAL A  74      24.864   3.222  10.111  1.00 20.44           C  
ATOM    582  C   VAL A  74      25.210   4.693   9.916  1.00 17.74           C  
ATOM    583  O   VAL A  74      24.323   5.537   9.855  1.00 19.27           O  
ATOM    584  CB  VAL A  74      24.268   2.705   8.778  1.00 21.53           C  
ATOM    585  CG1 VAL A  74      25.310   2.809   7.668  1.00 22.65           C  
ATOM    586  CG2 VAL A  74      23.787   1.267   8.935  1.00 21.54           C  
ATOM    587  N   VAL A  75      26.503   4.984   9.834  1.00 17.60           N  
ATOM    588  CA  VAL A  75      26.981   6.341   9.591  1.00 18.15           C  
ATOM    589  C   VAL A  75      28.145   6.261   8.610  1.00 17.44           C  
ATOM    590  O   VAL A  75      29.060   5.460   8.789  1.00 18.21           O  
ATOM    591  CB  VAL A  75      27.499   7.042  10.880  1.00 18.20           C  
ATOM    592  CG1 VAL A  75      28.049   8.428  10.529  1.00 17.89           C  
ATOM    593  CG2 VAL A  75      26.373   7.184  11.897  1.00 19.38           C  
ATOM    594  N   ASP A  76      28.096   7.074   7.560  1.00 17.76           N  
ATOM    595  CA  ASP A  76      29.183   7.118   6.593  1.00 16.83           C  
ATOM    596  C   ASP A  76      29.386   8.603   6.320  1.00 16.84           C  
ATOM    597  O   ASP A  76      28.475   9.398   6.528  1.00 18.12           O  
ATOM    598  CB  ASP A  76      28.808   6.363   5.312  1.00 17.42           C  
ATOM    599  CG  ASP A  76      29.989   6.185   4.366  1.00 18.51           C  
ATOM    600  OD1 ASP A  76      31.151   6.327   4.806  1.00 19.25           O  
ATOM    601  OD2 ASP A  76      29.756   5.886   3.176  1.00 19.50           O  
ATOM    602  N   CYS A  77      30.574   8.990   5.875  1.00 16.99           N  
ATOM    603  CA  CYS A  77      30.826  10.401   5.625  1.00 17.05           C  
ATOM    604  C   CYS A  77      31.955  10.580   4.626  1.00 16.90           C  
ATOM    605  O   CYS A  77      32.742   9.662   4.398  1.00 18.24           O  
ATOM    606  CB  CYS A  77      31.195  11.099   6.935  1.00 17.50           C  
ATOM    607  SG  CYS A  77      32.733  10.479   7.652  1.00 23.14           S  
ATOM    608  N   GLN A  78      32.026  11.766   4.032  1.00 15.32           N  
ATOM    609  CA  GLN A  78      33.064  12.060   3.057  1.00 17.24           C  
ATOM    610  C   GLN A  78      33.407  13.538   3.070  1.00 17.08           C  
ATOM    611  O   GLN A  78      32.540  14.385   3.282  1.00 15.94           O  
ATOM    612  CB  GLN A  78      32.596  11.733   1.633  1.00 18.70           C  
ATOM    613  CG  GLN A  78      31.955  10.376   1.416  1.00 17.61           C  
ATOM    614  CD  GLN A  78      31.481  10.198  -0.021  1.00 21.06           C  
ATOM    615  OE1 GLN A  78      31.371  11.167  -0.779  1.00 20.02           O  
ATOM    616  NE2 GLN A  78      31.188   8.958  -0.399  1.00 20.78           N  
ATOM    617  N   PRO A  79      34.684  13.867   2.846  1.00 18.01           N  
ATOM    618  CA  PRO A  79      35.052  15.284   2.825  1.00 18.28           C  
ATOM    619  C   PRO A  79      34.511  15.791   1.482  1.00 19.19           C  
ATOM    620  O   PRO A  79      34.657  15.113   0.464  1.00 19.07           O  
ATOM    621  CB  PRO A  79      36.577  15.242   2.877  1.00 18.95           C  
ATOM    622  CG  PRO A  79      36.910  13.946   2.176  1.00 20.84           C  
ATOM    623  CD  PRO A  79      35.867  12.998   2.731  1.00 19.25           C  
ATOM    624  N   VAL A  80      33.862  16.953   1.473  1.00 17.64           N  
ATOM    625  CA  VAL A  80      33.306  17.485   0.231  1.00 17.00           C  
ATOM    626  C   VAL A  80      34.384  18.204  -0.584  1.00 17.92           C  
ATOM    627  O   VAL A  80      35.156  18.992  -0.045  1.00 17.21           O  
ATOM    628  CB  VAL A  80      32.129  18.447   0.525  1.00 17.87           C  
ATOM    629  CG1 VAL A  80      31.536  18.977  -0.781  1.00 18.05           C  
ATOM    630  CG2 VAL A  80      31.050  17.704   1.334  1.00 16.09           C  
ATOM    631  N   HIS A  81      34.438  17.920  -1.882  1.00 18.58           N  
ATOM    632  CA  HIS A  81      35.451  18.525  -2.749  1.00 19.99           C  
ATOM    633  C   HIS A  81      35.416  20.051  -2.725  1.00 20.93           C  
ATOM    634  O   HIS A  81      34.344  20.654  -2.721  1.00 19.12           O  
ATOM    635  CB  HIS A  81      35.284  18.019  -4.187  1.00 20.58           C  
ATOM    636  CG  HIS A  81      36.463  18.301  -5.064  1.00 22.04           C  
ATOM    637  ND1 HIS A  81      36.744  19.561  -5.546  1.00 22.38           N  
ATOM    638  CD2 HIS A  81      37.460  17.497  -5.503  1.00 23.59           C  
ATOM    639  CE1 HIS A  81      37.865  19.521  -6.244  1.00 24.66           C  
ATOM    640  NE2 HIS A  81      38.321  18.281  -6.232  1.00 24.95           N  
ATOM    641  N   ASP A  82      36.602  20.663  -2.713  1.00 22.09           N  
ATOM    642  CA  ASP A  82      36.759  22.127  -2.684  1.00 26.08           C  
ATOM    643  C   ASP A  82      35.991  22.866  -3.769  1.00 25.62           C  
ATOM    644  O   ASP A  82      35.547  23.998  -3.559  1.00 25.26           O  
ATOM    645  CB  ASP A  82      38.230  22.529  -2.837  1.00 31.74           C  
ATOM    646  CG  ASP A  82      39.071  22.134  -1.656  1.00 37.51           C  
ATOM    647  OD1 ASP A  82      38.569  22.232  -0.515  1.00 41.29           O  
ATOM    648  OD2 ASP A  82      40.250  21.761  -1.858  1.00 42.14           O  
ATOM    649  N   GLU A  83      35.850  22.243  -4.934  1.00 24.86           N  
ATOM    650  CA  GLU A  83      35.157  22.893  -6.036  1.00 25.71           C  
ATOM    651  C   GLU A  83      33.680  23.129  -5.743  1.00 24.32           C  
ATOM    652  O   GLU A  83      33.086  24.078  -6.250  1.00 24.33           O  
ATOM    653  CB  GLU A  83      35.319  22.079  -7.320  1.00 28.18           C  
ATOM    654  CG  GLU A  83      34.928  22.850  -8.568  1.00 34.82           C  
ATOM    655  CD  GLU A  83      35.339  22.146  -9.844  1.00 36.26           C  
ATOM    656  OE1 GLU A  83      36.554  21.920 -10.040  1.00 39.40           O  
ATOM    657  OE2 GLU A  83      34.446  21.823 -10.653  1.00 40.69           O  
ATOM    658  N   ALA A  84      33.088  22.272  -4.920  1.00 21.62           N  
ATOM    659  CA  ALA A  84      31.678  22.410  -4.569  1.00 20.09           C  
ATOM    660  C   ALA A  84      31.488  23.466  -3.478  1.00 19.09           C  
ATOM    661  O   ALA A  84      30.492  24.190  -3.480  1.00 18.83           O  
ATOM    662  CB  ALA A  84      31.119  21.068  -4.108  1.00 18.65           C  
ATOM    663  N   THR A  85      32.434  23.552  -2.547  1.00 18.91           N  
ATOM    664  CA  THR A  85      32.346  24.532  -1.464  1.00 19.73           C  
ATOM    665  C   THR A  85      33.667  25.281  -1.309  1.00 19.83           C  
ATOM    666  O   THR A  85      34.421  25.061  -0.361  1.00 19.56           O  
ATOM    667  CB  THR A  85      31.977  23.860  -0.123  1.00 20.38           C  
ATOM    668  OG1 THR A  85      32.994  22.923   0.246  1.00 20.57           O  
ATOM    669  CG2 THR A  85      30.645  23.134  -0.244  1.00 20.92           C  
ATOM    670  N   PRO A  86      33.956  26.190  -2.248  1.00 20.32           N  
ATOM    671  CA  PRO A  86      35.190  26.985  -2.237  1.00 20.79           C  
ATOM    672  C   PRO A  86      35.387  27.710  -0.908  1.00 20.93           C  
ATOM    673  O   PRO A  86      34.440  28.278  -0.364  1.00 19.95           O  
ATOM    674  CB  PRO A  86      34.977  27.973  -3.385  1.00 21.69           C  
ATOM    675  CG  PRO A  86      34.049  27.248  -4.309  1.00 23.41           C  
ATOM    676  CD  PRO A  86      33.077  26.599  -3.355  1.00 20.58           C  
ATOM    677  N   SER A  87      36.613  27.678  -0.394  1.00 19.72           N  
ATOM    678  CA  SER A  87      36.959  28.358   0.854  1.00 20.43           C  
ATOM    679  C   SER A  87      36.085  27.959   2.031  1.00 21.07           C  
ATOM    680  O   SER A  87      35.930  28.729   2.978  1.00 19.59           O  
ATOM    681  CB  SER A  87      36.856  29.876   0.663  1.00 20.47           C  
ATOM    682  OG  SER A  87      37.629  30.299  -0.444  1.00 21.17           O  
ATOM    683  N   GLN A  88      35.524  26.758   1.985  1.00 20.05           N  
ATOM    684  CA  GLN A  88      34.650  26.296   3.055  1.00 21.37           C  
ATOM    685  C   GLN A  88      34.849  24.798   3.259  1.00 21.74           C  
ATOM    686  O   GLN A  88      34.624  24.014   2.343  1.00 24.89           O  
ATOM    687  CB  GLN A  88      33.190  26.582   2.679  1.00 20.40           C  
ATOM    688  CG  GLN A  88      32.154  26.137   3.715  1.00 19.77           C  
ATOM    689  CD  GLN A  88      30.719  26.268   3.215  1.00 19.19           C  
ATOM    690  OE1 GLN A  88      29.763  26.057   3.971  1.00 19.57           O  
ATOM    691  NE2 GLN A  88      30.562  26.609   1.942  1.00 15.85           N  
ATOM    692  N   THR A  89      35.278  24.404   4.454  1.00 20.58           N  
ATOM    693  CA  THR A  89      35.491  22.990   4.744  1.00 19.32           C  
ATOM    694  C   THR A  89      34.153  22.350   5.092  1.00 18.64           C  
ATOM    695  O   THR A  89      33.528  22.711   6.090  1.00 18.86           O  
ATOM    696  CB  THR A  89      36.459  22.800   5.926  1.00 19.97           C  
ATOM    697  OG1 THR A  89      37.709  23.428   5.615  1.00 20.58           O  
ATOM    698  CG2 THR A  89      36.700  21.305   6.193  1.00 21.72           C  
ATOM    699  N   THR A  90      33.711  21.408   4.263  1.00 17.09           N  
ATOM    700  CA  THR A  90      32.442  20.742   4.509  1.00 16.69           C  
ATOM    701  C   THR A  90      32.562  19.222   4.456  1.00 17.01           C  
ATOM    702  O   THR A  90      33.476  18.669   3.836  1.00 16.44           O  
ATOM    703  CB  THR A  90      31.365  21.209   3.512  1.00 17.35           C  
ATOM    704  OG1 THR A  90      31.779  20.909   2.177  1.00 20.08           O  
ATOM    705  CG2 THR A  90      31.156  22.715   3.634  1.00 16.79           C  
ATOM    706  N   VAL A  91      31.622  18.555   5.114  1.00 16.70           N  
ATOM    707  CA  VAL A  91      31.609  17.103   5.195  1.00 15.41           C  
ATOM    708  C   VAL A  91      30.197  16.579   4.985  1.00 16.62           C  
ATOM    709  O   VAL A  91      29.250  17.065   5.602  1.00 16.81           O  
ATOM    710  CB  VAL A  91      32.109  16.634   6.588  1.00 16.55           C  
ATOM    711  CG1 VAL A  91      31.887  15.130   6.760  1.00 17.40           C  
ATOM    712  CG2 VAL A  91      33.587  16.978   6.749  1.00 18.24           C  
ATOM    713  N   LEU A  92      30.066  15.601   4.095  1.00 15.45           N  
ATOM    714  CA  LEU A  92      28.780  14.978   3.821  1.00 16.38           C  
ATOM    715  C   LEU A  92      28.623  13.832   4.812  1.00 16.02           C  
ATOM    716  O   LEU A  92      29.536  13.022   4.982  1.00 16.70           O  
ATOM    717  CB  LEU A  92      28.748  14.425   2.390  1.00 16.83           C  
ATOM    718  CG  LEU A  92      27.546  13.545   2.026  1.00 17.11           C  
ATOM    719  CD1 LEU A  92      26.254  14.336   2.162  1.00 16.85           C  
ATOM    720  CD2 LEU A  92      27.712  13.018   0.598  1.00 16.72           C  
ATOM    721  N   VAL A  93      27.471  13.771   5.470  1.00 15.83           N  
ATOM    722  CA  VAL A  93      27.208  12.713   6.436  1.00 16.15           C  
ATOM    723  C   VAL A  93      25.918  12.015   6.041  1.00 16.24           C  
ATOM    724  O   VAL A  93      24.924  12.670   5.729  1.00 15.90           O  
ATOM    725  CB  VAL A  93      27.047  13.278   7.866  1.00 15.76           C  
ATOM    726  CG1 VAL A  93      26.916  12.133   8.863  1.00 17.30           C  
ATOM    727  CG2 VAL A  93      28.240  14.171   8.219  1.00 15.54           C  
ATOM    728  N   VAL A  94      25.942  10.686   6.028  1.00 17.52           N  
ATOM    729  CA  VAL A  94      24.749   9.920   5.686  1.00 17.97           C  
ATOM    730  C   VAL A  94      24.476   8.972   6.842  1.00 18.41           C  
ATOM    731  O   VAL A  94      25.375   8.288   7.329  1.00 19.71           O  
ATOM    732  CB  VAL A  94      24.929   9.129   4.372  1.00 21.38           C  
ATOM    733  CG1 VAL A  94      25.225  10.101   3.238  1.00 21.23           C  
ATOM    734  CG2 VAL A  94      26.042   8.112   4.511  1.00 23.97           C  
ATOM    735  N   ILE A  95      23.224   8.948   7.282  1.00 19.35           N  
ATOM    736  CA  ILE A  95      22.827   8.139   8.425  1.00 18.29           C  
ATOM    737  C   ILE A  95      21.636   7.240   8.130  1.00 19.08           C  
ATOM    738  O   ILE A  95      20.758   7.599   7.351  1.00 18.33           O  
ATOM    739  CB  ILE A  95      22.428   9.057   9.611  1.00 18.53           C  
ATOM    740  CG1 ILE A  95      23.576  10.013   9.942  1.00 17.89           C  
ATOM    741  CG2 ILE A  95      22.039   8.227  10.831  1.00 17.73           C  
ATOM    742  CD1 ILE A  95      23.321  11.433   9.489  1.00 19.19           C  
ATOM    743  N   CYS A  96      21.627   6.070   8.756  1.00 20.23           N  
ATOM    744  CA  CYS A  96      20.521   5.134   8.626  1.00 21.08           C  
ATOM    745  C   CYS A  96      20.248   4.567  10.009  1.00 20.73           C  
ATOM    746  O   CYS A  96      21.172   4.294  10.775  1.00 18.83           O  
ATOM    747  CB  CYS A  96      20.849   3.986   7.670  1.00 23.83           C  
ATOM    748  SG  CYS A  96      19.434   2.855   7.460  1.00 31.73           S  
ATOM    749  N   GLY A  97      18.972   4.400  10.327  1.00 21.18           N  
ATOM    750  CA  GLY A  97      18.606   3.853  11.616  1.00 22.26           C  
ATOM    751  C   GLY A  97      17.104   3.753  11.712  1.00 21.95           C  
ATOM    752  O   GLY A  97      16.409   3.716  10.696  1.00 20.42           O  
ATOM    753  N   SER A  98      16.597   3.705  12.938  1.00 22.51           N  
ATOM    754  CA  SER A  98      15.163   3.628  13.151  1.00 23.48           C  
ATOM    755  C   SER A  98      14.792   4.745  14.106  1.00 24.09           C  
ATOM    756  O   SER A  98      15.642   5.267  14.826  1.00 23.02           O  
ATOM    757  CB  SER A  98      14.779   2.279  13.764  1.00 24.71           C  
ATOM    758  OG  SER A  98      15.300   2.155  15.074  1.00 29.34           O  
ATOM    759  N   VAL A  99      13.521   5.118  14.103  1.00 24.26           N  
ATOM    760  CA  VAL A  99      13.062   6.167  14.989  1.00 25.62           C  
ATOM    761  C   VAL A  99      11.615   5.929  15.362  1.00 27.38           C  
ATOM    762  O   VAL A  99      10.814   5.471  14.544  1.00 26.45           O  
ATOM    763  CB  VAL A  99      13.166   7.557  14.329  1.00 25.93           C  
ATOM    764  CG1 VAL A  99      12.340   7.593  13.052  1.00 24.66           C  
ATOM    765  CG2 VAL A  99      12.678   8.629  15.300  1.00 26.52           C  
ATOM    766  N   LYS A 100      11.284   6.228  16.608  1.00 28.12           N  
ATOM    767  CA  LYS A 100       9.913   6.080  17.047  1.00 29.10           C  
ATOM    768  C   LYS A 100       9.434   7.424  17.551  1.00 28.26           C  
ATOM    769  O   LYS A 100       9.932   7.930  18.554  1.00 28.59           O  
ATOM    770  CB  LYS A 100       9.793   5.039  18.160  1.00 31.05           C  
ATOM    771  CG  LYS A 100       8.344   4.760  18.543  1.00 33.82           C  
ATOM    772  CD  LYS A 100       8.230   3.686  19.606  1.00 36.63           C  
ATOM    773  CE  LYS A 100       6.775   3.298  19.823  1.00 37.65           C  
ATOM    774  NZ  LYS A 100       5.934   4.483  20.154  1.00 40.60           N  
ATOM    775  N   PHE A 101       8.501   8.030  16.825  1.00 28.37           N  
ATOM    776  CA  PHE A 101       7.942   9.298  17.256  1.00 30.20           C  
ATOM    777  C   PHE A 101       6.711   8.947  18.080  1.00 32.52           C  
ATOM    778  O   PHE A 101       5.944   8.056  17.710  1.00 30.26           O  
ATOM    779  CB  PHE A 101       7.523  10.169  16.067  1.00 29.96           C  
ATOM    780  CG  PHE A 101       8.670  10.856  15.384  1.00 30.22           C  
ATOM    781  CD1 PHE A 101       9.289  10.281  14.279  1.00 29.91           C  
ATOM    782  CD2 PHE A 101       9.147  12.075  15.861  1.00 30.20           C  
ATOM    783  CE1 PHE A 101      10.368  10.909  13.658  1.00 29.64           C  
ATOM    784  CE2 PHE A 101      10.226  12.712  15.246  1.00 31.00           C  
ATOM    785  CZ  PHE A 101      10.837  12.125  14.142  1.00 29.90           C  
ATOM    786  N   GLU A 102       6.535   9.632  19.203  1.00 35.42           N  
ATOM    787  CA  GLU A 102       5.389   9.388  20.070  1.00 38.60           C  
ATOM    788  C   GLU A 102       4.110   9.473  19.245  1.00 38.66           C  
ATOM    789  O   GLU A 102       3.881  10.455  18.542  1.00 37.57           O  
ATOM    790  CB  GLU A 102       5.353  10.433  21.188  1.00 41.81           C  
ATOM    791  CG  GLU A 102       4.283  10.201  22.244  1.00 47.06           C  
ATOM    792  CD  GLU A 102       4.491   8.911  23.008  1.00 51.02           C  
ATOM    793  OE1 GLU A 102       4.341   7.825  22.405  1.00 54.25           O  
ATOM    794  OE2 GLU A 102       4.807   8.980  24.216  1.00 53.99           O  
ATOM    795  N   GLY A 103       3.281   8.437  19.319  1.00 40.72           N  
ATOM    796  CA  GLY A 103       2.037   8.447  18.569  1.00 42.07           C  
ATOM    797  C   GLY A 103       2.061   7.628  17.293  1.00 43.29           C  
ATOM    798  O   GLY A 103       1.078   7.595  16.554  1.00 43.75           O  
ATOM    799  N   ASN A 104       3.184   6.969  17.024  1.00 43.97           N  
ATOM    800  CA  ASN A 104       3.311   6.136  15.834  1.00 43.50           C  
ATOM    801  C   ASN A 104       4.318   5.019  16.066  1.00 41.61           C  
ATOM    802  O   ASN A 104       5.121   5.077  16.997  1.00 40.66           O  
ATOM    803  CB  ASN A 104       3.719   6.984  14.627  1.00 46.81           C  
ATOM    804  CG  ASN A 104       4.826   7.957  14.950  1.00 50.90           C  
ATOM    805  OD1 ASN A 104       5.929   7.559  15.321  1.00 54.23           O  
ATOM    806  ND2 ASN A 104       4.538   9.247  14.810  1.00 52.24           N  
ATOM    807  N   LYS A 105       4.264   3.994  15.223  1.00 39.79           N  
ATOM    808  CA  LYS A 105       5.161   2.855  15.358  1.00 38.70           C  
ATOM    809  C   LYS A 105       6.579   3.189  14.914  1.00 36.64           C  
ATOM    810  O   LYS A 105       6.808   4.175  14.215  1.00 34.10           O  
ATOM    811  CB  LYS A 105       4.638   1.669  14.543  1.00 41.47           C  
ATOM    812  CG  LYS A 105       4.575   1.917  13.040  1.00 45.49           C  
ATOM    813  CD  LYS A 105       4.015   0.711  12.281  1.00 48.59           C  
ATOM    814  CE  LYS A 105       4.954  -0.491  12.319  1.00 50.69           C  
ATOM    815  NZ  LYS A 105       5.147  -1.056  13.687  1.00 52.03           N  
ATOM    816  N   GLN A 106       7.523   2.355  15.336  1.00 34.63           N  
ATOM    817  CA  GLN A 106       8.926   2.527  14.989  1.00 34.58           C  
ATOM    818  C   GLN A 106       9.088   2.306  13.488  1.00 33.35           C  
ATOM    819  O   GLN A 106       8.489   1.392  12.920  1.00 32.57           O  
ATOM    820  CB  GLN A 106       9.777   1.514  15.758  1.00 36.03           C  
ATOM    821  CG  GLN A 106      11.255   1.540  15.409  1.00 39.26           C  
ATOM    822  CD  GLN A 106      12.032   0.432  16.092  1.00 41.09           C  
ATOM    823  OE1 GLN A 106      12.061   0.343  17.318  1.00 43.64           O  
ATOM    824  NE2 GLN A 106      12.667  -0.422  15.298  1.00 43.07           N  
ATOM    825  N   ARG A 107       9.894   3.147  12.846  1.00 31.16           N  
ATOM    826  CA  ARG A 107      10.117   3.022  11.413  1.00 28.48           C  
ATOM    827  C   ARG A 107      11.564   3.364  11.075  1.00 27.12           C  
ATOM    828  O   ARG A 107      12.229   4.085  11.817  1.00 25.38           O  
ATOM    829  CB  ARG A 107       9.157   3.943  10.654  1.00 30.52           C  
ATOM    830  CG  ARG A 107       9.316   5.417  10.973  1.00 31.02           C  
ATOM    831  CD  ARG A 107       8.012   6.187  10.763  1.00 33.06           C  
ATOM    832  NE  ARG A 107       7.504   6.082   9.398  1.00 33.25           N  
ATOM    833  CZ  ARG A 107       6.505   6.816   8.918  1.00 32.03           C  
ATOM    834  NH1 ARG A 107       5.906   7.711   9.694  1.00 33.17           N  
ATOM    835  NH2 ARG A 107       6.114   6.666   7.661  1.00 33.16           N  
ATOM    836  N   ASP A 108      12.053   2.829   9.961  1.00 24.35           N  
ATOM    837  CA  ASP A 108      13.425   3.089   9.549  1.00 24.02           C  
ATOM    838  C   ASP A 108      13.483   4.389   8.769  1.00 22.43           C  
ATOM    839  O   ASP A 108      12.477   4.831   8.212  1.00 22.12           O  
ATOM    840  CB  ASP A 108      13.957   1.939   8.691  1.00 25.98           C  
ATOM    841  CG  ASP A 108      13.940   0.612   9.425  1.00 29.00           C  
ATOM    842  OD1 ASP A 108      14.320   0.580  10.614  1.00 30.02           O  
ATOM    843  OD2 ASP A 108      13.555  -0.398   8.806  1.00 31.54           O  
ATOM    844  N   PHE A 109      14.662   5.000   8.729  1.00 21.15           N  
ATOM    845  CA  PHE A 109      14.824   6.269   8.036  1.00 19.48           C  
ATOM    846  C   PHE A 109      16.238   6.410   7.502  1.00 19.58           C  
ATOM    847  O   PHE A 109      17.134   5.646   7.852  1.00 18.45           O  
ATOM    848  CB  PHE A 109      14.572   7.421   9.014  1.00 20.55           C  
ATOM    849  CG  PHE A 109      15.719   7.660   9.967  1.00 20.31           C  
ATOM    850  CD1 PHE A 109      16.744   8.550   9.636  1.00 20.46           C  
ATOM    851  CD2 PHE A 109      15.816   6.944  11.156  1.00 20.93           C  
ATOM    852  CE1 PHE A 109      17.850   8.718  10.475  1.00 20.80           C  
ATOM    853  CE2 PHE A 109      16.920   7.104  12.006  1.00 21.03           C  
ATOM    854  CZ  PHE A 109      17.938   7.992  11.661  1.00 22.59           C  
ATOM    855  N   ASN A 110      16.422   7.411   6.654  1.00 19.72           N  
ATOM    856  CA  ASN A 110      17.730   7.730   6.111  1.00 20.47           C  
ATOM    857  C   ASN A 110      17.800   9.240   6.216  1.00 19.52           C  
ATOM    858  O   ASN A 110      16.811   9.937   5.976  1.00 19.66           O  
ATOM    859  CB  ASN A 110      17.865   7.302   4.644  1.00 22.94           C  
ATOM    860  CG  ASN A 110      17.911   5.791   4.474  1.00 25.74           C  
ATOM    861  OD1 ASN A 110      16.885   5.117   4.531  1.00 27.89           O  
ATOM    862  ND2 ASN A 110      19.111   5.253   4.275  1.00 28.44           N  
ATOM    863  N   GLN A 111      18.959   9.750   6.602  1.00 19.19           N  
ATOM    864  CA  GLN A 111      19.122  11.185   6.722  1.00 19.23           C  
ATOM    865  C   GLN A 111      20.507  11.523   6.221  1.00 18.32           C  
ATOM    866  O   GLN A 111      21.439  10.737   6.367  1.00 18.17           O  
ATOM    867  CB  GLN A 111      18.959  11.633   8.184  1.00 19.61           C  
ATOM    868  CG  GLN A 111      19.146  13.142   8.400  1.00 19.78           C  
ATOM    869  CD  GLN A 111      18.703  13.614   9.779  1.00 22.48           C  
ATOM    870  OE1 GLN A 111      18.406  12.808  10.664  1.00 21.48           O  
ATOM    871  NE2 GLN A 111      18.663  14.933   9.967  1.00 20.58           N  
ATOM    872  N   ASN A 112      20.634  12.679   5.589  1.00 19.16           N  
ATOM    873  CA  ASN A 112      21.933  13.100   5.107  1.00 19.29           C  
ATOM    874  C   ASN A 112      22.019  14.601   5.247  1.00 18.37           C  
ATOM    875  O   ASN A 112      21.045  15.319   5.026  1.00 20.02           O  
ATOM    876  CB  ASN A 112      22.161  12.647   3.648  1.00 19.47           C  
ATOM    877  CG  ASN A 112      21.197  13.289   2.656  1.00 24.35           C  
ATOM    878  OD1 ASN A 112      21.463  14.365   2.120  1.00 24.17           O  
ATOM    879  ND2 ASN A 112      20.076  12.623   2.403  1.00 25.06           N  
ATOM    880  N   PHE A 113      23.173  15.077   5.684  1.00 17.79           N  
ATOM    881  CA  PHE A 113      23.348  16.502   5.811  1.00 17.49           C  
ATOM    882  C   PHE A 113      24.776  16.885   5.533  1.00 17.20           C  
ATOM    883  O   PHE A 113      25.677  16.040   5.546  1.00 17.40           O  
ATOM    884  CB  PHE A 113      22.889  17.013   7.192  1.00 18.74           C  
ATOM    885  CG  PHE A 113      23.373  16.199   8.363  1.00 20.97           C  
ATOM    886  CD1 PHE A 113      24.725  16.131   8.682  1.00 23.04           C  
ATOM    887  CD2 PHE A 113      22.458  15.555   9.193  1.00 24.44           C  
ATOM    888  CE1 PHE A 113      25.159  15.438   9.816  1.00 23.49           C  
ATOM    889  CE2 PHE A 113      22.882  14.859  10.329  1.00 24.65           C  
ATOM    890  CZ  PHE A 113      24.236  14.803  10.640  1.00 24.95           C  
ATOM    891  N   ILE A 114      24.968  18.159   5.231  1.00 16.46           N  
ATOM    892  CA  ILE A 114      26.296  18.665   4.959  1.00 17.09           C  
ATOM    893  C   ILE A 114      26.690  19.552   6.122  1.00 16.95           C  
ATOM    894  O   ILE A 114      25.989  20.519   6.442  1.00 17.06           O  
ATOM    895  CB  ILE A 114      26.330  19.467   3.644  1.00 16.53           C  
ATOM    896  CG1 ILE A 114      26.043  18.522   2.470  1.00 17.48           C  
ATOM    897  CG2 ILE A 114      27.698  20.133   3.476  1.00 16.86           C  
ATOM    898  CD1 ILE A 114      25.937  19.206   1.116  1.00 17.33           C  
ATOM    899  N   LEU A 115      27.795  19.191   6.768  1.00 16.38           N  
ATOM    900  CA  LEU A 115      28.318  19.942   7.904  1.00 17.60           C  
ATOM    901  C   LEU A 115      29.367  20.912   7.397  1.00 18.02           C  
ATOM    902  O   LEU A 115      30.101  20.603   6.460  1.00 18.25           O  
ATOM    903  CB  LEU A 115      28.973  19.003   8.920  1.00 17.65           C  
ATOM    904  CG  LEU A 115      28.073  17.989   9.632  1.00 17.67           C  
ATOM    905  CD1 LEU A 115      28.923  17.106  10.539  1.00 18.77           C  
ATOM    906  CD2 LEU A 115      27.005  18.733  10.442  1.00 19.20           C  
ATOM    907  N   THR A 116      29.444  22.079   8.027  1.00 18.13           N  
ATOM    908  CA  THR A 116      30.421  23.082   7.633  1.00 19.36           C  
ATOM    909  C   THR A 116      31.250  23.475   8.858  1.00 20.81           C  
ATOM    910  O   THR A 116      30.713  23.652   9.957  1.00 18.61           O  
ATOM    911  CB  THR A 116      29.729  24.321   7.008  1.00 20.46           C  
ATOM    912  OG1 THR A 116      30.723  25.276   6.618  1.00 21.94           O  
ATOM    913  CG2 THR A 116      28.761  24.957   7.993  1.00 19.93           C  
ATOM    914  N   ALA A 117      32.561  23.591   8.659  1.00 20.18           N  
ATOM    915  CA  ALA A 117      33.481  23.924   9.738  1.00 22.72           C  
ATOM    916  C   ALA A 117      33.545  25.417  10.018  1.00 25.55           C  
ATOM    917  O   ALA A 117      33.782  26.225   9.124  1.00 24.25           O  
ATOM    918  CB  ALA A 117      34.873  23.402   9.412  1.00 22.01           C  
ATOM    919  N   GLN A 118      33.347  25.776  11.279  1.00 28.18           N  
ATOM    920  CA  GLN A 118      33.385  27.173  11.697  1.00 33.75           C  
ATOM    921  C   GLN A 118      34.551  27.333  12.662  1.00 34.01           C  
ATOM    922  O   GLN A 118      34.490  26.859  13.794  1.00 33.03           O  
ATOM    923  CB  GLN A 118      32.071  27.539  12.390  1.00 37.90           C  
ATOM    924  CG  GLN A 118      31.856  29.029  12.663  1.00 46.36           C  
ATOM    925  CD  GLN A 118      32.711  29.561  13.797  1.00 50.87           C  
ATOM    926  OE1 GLN A 118      32.850  28.923  14.847  1.00 53.88           O  
ATOM    927  NE2 GLN A 118      33.276  30.746  13.600  1.00 51.37           N  
ATOM    928  N   ALA A 119      35.624  27.965  12.201  1.00 36.14           N  
ATOM    929  CA  ALA A 119      36.799  28.185  13.038  1.00 40.21           C  
ATOM    930  C   ALA A 119      36.409  29.179  14.121  1.00 43.27           C  
ATOM    931  O   ALA A 119      35.491  29.965  13.929  1.00 43.98           O  
ATOM    932  CB  ALA A 119      37.933  28.729  12.200  1.00 39.14           C  
ATOM    933  N   SER A 120      37.109  29.161  15.248  1.00 47.43           N  
ATOM    934  CA  SER A 120      36.771  30.059  16.350  1.00 51.95           C  
ATOM    935  C   SER A 120      37.830  30.075  17.455  1.00 53.92           C  
ATOM    936  O   SER A 120      38.805  29.325  17.395  1.00 54.47           O  
ATOM    937  CB  SER A 120      35.420  29.630  16.932  1.00 52.36           C  
ATOM    938  OG  SER A 120      35.266  28.214  16.869  1.00 55.93           O  
ATOM    939  N   PRO A 121      37.646  30.932  18.483  1.00 55.76           N  
ATOM    940  CA  PRO A 121      38.591  31.034  19.600  1.00 56.07           C  
ATOM    941  C   PRO A 121      39.058  29.661  20.061  1.00 55.90           C  
ATOM    942  O   PRO A 121      40.248  29.348  20.006  1.00 56.21           O  
ATOM    943  CB  PRO A 121      37.776  31.749  20.668  1.00 57.02           C  
ATOM    944  CG  PRO A 121      36.970  32.701  19.856  1.00 57.12           C  
ATOM    945  CD  PRO A 121      36.499  31.835  18.701  1.00 56.62           C  
ATOM    946  N   SER A 122      38.115  28.841  20.518  1.00 54.86           N  
ATOM    947  CA  SER A 122      38.452  27.499  20.971  1.00 53.86           C  
ATOM    948  C   SER A 122      38.541  26.555  19.777  1.00 52.99           C  
ATOM    949  O   SER A 122      39.147  26.889  18.756  1.00 53.73           O  
ATOM    950  CB  SER A 122      37.418  26.995  21.988  1.00 54.51           C  
ATOM    951  OG  SER A 122      36.093  27.107  21.499  1.00 55.05           O  
ATOM    952  N   ASN A 123      37.927  25.385  19.898  1.00 50.58           N  
ATOM    953  CA  ASN A 123      37.961  24.389  18.834  1.00 48.03           C  
ATOM    954  C   ASN A 123      37.018  24.706  17.674  1.00 44.75           C  
ATOM    955  O   ASN A 123      36.146  25.574  17.773  1.00 43.92           O  
ATOM    956  CB  ASN A 123      37.622  23.010  19.408  1.00 50.55           C  
ATOM    957  CG  ASN A 123      38.574  22.586  20.517  1.00 53.17           C  
ATOM    958  OD1 ASN A 123      38.419  21.517  21.109  1.00 55.25           O  
ATOM    959  ND2 ASN A 123      39.564  23.424  20.803  1.00 53.92           N  
ATOM    960  N   THR A 124      37.213  23.997  16.569  1.00 41.02           N  
ATOM    961  CA  THR A 124      36.378  24.166  15.389  1.00 36.89           C  
ATOM    962  C   THR A 124      34.984  23.632  15.698  1.00 33.29           C  
ATOM    963  O   THR A 124      34.840  22.593  16.337  1.00 31.46           O  
ATOM    964  CB  THR A 124      36.964  23.396  14.194  1.00 39.16           C  
ATOM    965  OG1 THR A 124      38.174  24.037  13.767  1.00 42.27           O  
ATOM    966  CG2 THR A 124      35.973  23.353  13.035  1.00 38.68           C  
ATOM    967  N   VAL A 125      33.966  24.355  15.247  1.00 28.51           N  
ATOM    968  CA  VAL A 125      32.576  23.975  15.471  1.00 27.54           C  
ATOM    969  C   VAL A 125      31.927  23.548  14.155  1.00 24.33           C  
ATOM    970  O   VAL A 125      31.960  24.293  13.180  1.00 22.31           O  
ATOM    971  CB  VAL A 125      31.777  25.170  16.057  1.00 28.83           C  
ATOM    972  CG1 VAL A 125      30.294  24.850  16.095  1.00 30.31           C  
ATOM    973  CG2 VAL A 125      32.284  25.496  17.457  1.00 30.63           C  
ATOM    974  N   TRP A 126      31.350  22.351  14.123  1.00 22.71           N  
ATOM    975  CA  TRP A 126      30.692  21.881  12.909  1.00 21.26           C  
ATOM    976  C   TRP A 126      29.189  22.089  13.019  1.00 21.22           C  
ATOM    977  O   TRP A 126      28.574  21.711  14.019  1.00 21.10           O  
ATOM    978  CB  TRP A 126      30.989  20.400  12.664  1.00 22.00           C  
ATOM    979  CG  TRP A 126      32.433  20.123  12.401  1.00 21.96           C  
ATOM    980  CD1 TRP A 126      33.418  19.950  13.330  1.00 23.31           C  
ATOM    981  CD2 TRP A 126      33.064  20.018  11.120  1.00 22.54           C  
ATOM    982  NE1 TRP A 126      34.629  19.742  12.705  1.00 23.55           N  
ATOM    983  CE2 TRP A 126      34.438  19.779  11.348  1.00 22.80           C  
ATOM    984  CE3 TRP A 126      32.600  20.105   9.798  1.00 21.57           C  
ATOM    985  CZ2 TRP A 126      35.356  19.622  10.302  1.00 22.28           C  
ATOM    986  CZ3 TRP A 126      33.513  19.949   8.756  1.00 21.01           C  
ATOM    987  CH2 TRP A 126      34.877  19.710   9.018  1.00 22.51           C  
ATOM    988  N   LYS A 127      28.601  22.697  11.995  1.00 20.22           N  
ATOM    989  CA  LYS A 127      27.166  22.946  11.979  1.00 19.89           C  
ATOM    990  C   LYS A 127      26.540  22.479  10.678  1.00 19.98           C  
ATOM    991  O   LYS A 127      27.200  22.425   9.648  1.00 18.54           O  
ATOM    992  CB  LYS A 127      26.879  24.435  12.169  1.00 21.22           C  
ATOM    993  CG  LYS A 127      27.188  24.949  13.569  1.00 25.42           C  
ATOM    994  CD  LYS A 127      26.705  26.377  13.746  1.00 27.48           C  
ATOM    995  CE  LYS A 127      26.924  26.855  15.168  1.00 31.93           C  
ATOM    996  NZ  LYS A 127      26.437  28.248  15.352  1.00 35.57           N  
ATOM    997  N   ILE A 128      25.256  22.148  10.734  1.00 18.74           N  
ATOM    998  CA  ILE A 128      24.540  21.692   9.550  1.00 18.00           C  
ATOM    999  C   ILE A 128      24.209  22.875   8.643  1.00 18.39           C  
ATOM   1000  O   ILE A 128      23.604  23.857   9.079  1.00 19.05           O  
ATOM   1001  CB  ILE A 128      23.226  20.968   9.937  1.00 17.55           C  
ATOM   1002  CG1 ILE A 128      23.552  19.667  10.675  1.00 19.09           C  
ATOM   1003  CG2 ILE A 128      22.400  20.677   8.690  1.00 16.55           C  
ATOM   1004  CD1 ILE A 128      22.347  18.999  11.332  1.00 19.99           C  
ATOM   1005  N   ALA A 129      24.616  22.784   7.383  1.00 17.49           N  
ATOM   1006  CA  ALA A 129      24.339  23.846   6.425  1.00 17.76           C  
ATOM   1007  C   ALA A 129      23.126  23.449   5.587  1.00 18.71           C  
ATOM   1008  O   ALA A 129      22.358  24.301   5.134  1.00 18.76           O  
ATOM   1009  CB  ALA A 129      25.551  24.073   5.525  1.00 17.61           C  
ATOM   1010  N   SER A 130      22.954  22.142   5.402  1.00 18.86           N  
ATOM   1011  CA  SER A 130      21.851  21.602   4.611  1.00 20.65           C  
ATOM   1012  C   SER A 130      21.499  20.235   5.194  1.00 20.09           C  
ATOM   1013  O   SER A 130      22.389  19.468   5.551  1.00 19.58           O  
ATOM   1014  CB  SER A 130      22.290  21.446   3.154  1.00 22.04           C  
ATOM   1015  OG  SER A 130      21.261  20.860   2.380  1.00 29.98           O  
ATOM   1016  N   ASP A 131      20.207  19.927   5.264  1.00 19.77           N  
ATOM   1017  CA  ASP A 131      19.749  18.669   5.851  1.00 19.77           C  
ATOM   1018  C   ASP A 131      18.625  18.039   5.025  1.00 19.10           C  
ATOM   1019  O   ASP A 131      17.847  18.743   4.384  1.00 18.00           O  
ATOM   1020  CB  ASP A 131      19.265  18.960   7.279  1.00 21.43           C  
ATOM   1021  CG  ASP A 131      19.039  17.710   8.110  1.00 23.13           C  
ATOM   1022  OD1 ASP A 131      19.464  16.604   7.705  1.00 22.42           O  
ATOM   1023  OD2 ASP A 131      18.439  17.849   9.202  1.00 25.42           O  
ATOM   1024  N   CYS A 132      18.551  16.711   5.049  1.00 18.93           N  
ATOM   1025  CA  CYS A 132      17.524  15.969   4.313  1.00 19.90           C  
ATOM   1026  C   CYS A 132      17.173  14.713   5.107  1.00 20.24           C  
ATOM   1027  O   CYS A 132      18.054  13.929   5.448  1.00 19.27           O  
ATOM   1028  CB  CYS A 132      18.048  15.580   2.926  1.00 21.23           C  
ATOM   1029  SG  CYS A 132      16.855  14.683   1.901  1.00 24.54           S  
ATOM   1030  N   PHE A 133      15.887  14.527   5.394  1.00 18.43           N  
ATOM   1031  CA  PHE A 133      15.415  13.385   6.172  1.00 19.41           C  
ATOM   1032  C   PHE A 133      14.203  12.754   5.494  1.00 17.70           C  
ATOM   1033  O   PHE A 133      13.317  13.460   5.024  1.00 17.87           O  
ATOM   1034  CB  PHE A 133      15.011  13.852   7.580  1.00 19.72           C  
ATOM   1035  CG  PHE A 133      14.403  12.770   8.443  1.00 21.23           C  
ATOM   1036  CD1 PHE A 133      15.186  12.058   9.346  1.00 20.29           C  
ATOM   1037  CD2 PHE A 133      13.044  12.465   8.346  1.00 22.88           C  
ATOM   1038  CE1 PHE A 133      14.629  11.054  10.143  1.00 22.97           C  
ATOM   1039  CE2 PHE A 133      12.476  11.464   9.138  1.00 22.79           C  
ATOM   1040  CZ  PHE A 133      13.270  10.757  10.038  1.00 21.00           C  
ATOM   1041  N   ARG A 134      14.163  11.429   5.451  1.00 19.34           N  
ATOM   1042  CA  ARG A 134      13.029  10.739   4.848  1.00 19.79           C  
ATOM   1043  C   ARG A 134      12.854   9.333   5.414  1.00 20.15           C  
ATOM   1044  O   ARG A 134      13.818   8.572   5.531  1.00 20.10           O  
ATOM   1045  CB  ARG A 134      13.197  10.669   3.324  1.00 20.52           C  
ATOM   1046  CG  ARG A 134      12.022  10.028   2.593  1.00 21.99           C  
ATOM   1047  CD  ARG A 134      12.236  10.055   1.081  1.00 20.07           C  
ATOM   1048  NE  ARG A 134      12.007  11.374   0.493  1.00 20.30           N  
ATOM   1049  CZ  ARG A 134      10.804  11.912   0.309  1.00 21.71           C  
ATOM   1050  NH1 ARG A 134       9.712  11.246   0.670  1.00 21.31           N  
ATOM   1051  NH2 ARG A 134      10.688  13.108  -0.252  1.00 19.90           N  
ATOM   1052  N   PHE A 135      11.617   9.003   5.780  1.00 20.76           N  
ATOM   1053  CA  PHE A 135      11.291   7.680   6.303  1.00 20.86           C  
ATOM   1054  C   PHE A 135      11.360   6.717   5.124  1.00 23.12           C  
ATOM   1055  O   PHE A 135      10.941   7.060   4.017  1.00 23.67           O  
ATOM   1056  CB  PHE A 135       9.859   7.640   6.848  1.00 22.22           C  
ATOM   1057  CG  PHE A 135       9.636   8.473   8.075  1.00 22.76           C  
ATOM   1058  CD1 PHE A 135       8.640   9.443   8.093  1.00 23.58           C  
ATOM   1059  CD2 PHE A 135      10.382   8.256   9.228  1.00 23.22           C  
ATOM   1060  CE1 PHE A 135       8.384  10.187   9.245  1.00 23.63           C  
ATOM   1061  CE2 PHE A 135      10.134   8.994  10.386  1.00 23.40           C  
ATOM   1062  CZ  PHE A 135       9.131   9.961  10.392  1.00 23.91           C  
ATOM   1063  N   GLN A 136      11.867   5.512   5.355  1.00 23.52           N  
ATOM   1064  CA  GLN A 136      11.945   4.531   4.282  1.00 26.25           C  
ATOM   1065  C   GLN A 136      10.529   4.154   3.835  1.00 28.40           C  
ATOM   1066  O   GLN A 136      10.318   3.748   2.691  1.00 28.57           O  
ATOM   1067  CB  GLN A 136      12.713   3.290   4.748  1.00 26.20           C  
ATOM   1068  CG  GLN A 136      14.154   3.588   5.162  1.00 25.62           C  
ATOM   1069  CD  GLN A 136      14.978   2.338   5.399  1.00 26.54           C  
ATOM   1070  OE1 GLN A 136      14.450   1.222   5.416  1.00 26.73           O  
ATOM   1071  NE2 GLN A 136      16.282   2.518   5.590  1.00 23.93           N  
ATOM   1072  N   ASP A 137       9.560   4.310   4.738  1.00 28.46           N  
ATOM   1073  CA  ASP A 137       8.161   3.992   4.441  1.00 30.36           C  
ATOM   1074  C   ASP A 137       7.292   5.247   4.511  1.00 30.73           C  
ATOM   1075  O   ASP A 137       6.156   5.205   4.991  1.00 30.66           O  
ATOM   1076  CB  ASP A 137       7.642   2.945   5.437  1.00 31.56           C  
ATOM   1077  CG  ASP A 137       7.525   3.490   6.852  1.00 33.39           C  
ATOM   1078  OD1 ASP A 137       8.258   4.441   7.188  1.00 32.03           O  
ATOM   1079  OD2 ASP A 137       6.707   2.958   7.632  1.00 36.20           O  
ATOM   1080  N   TRP A 138       7.821   6.361   4.015  1.00 30.37           N  
ATOM   1081  CA  TRP A 138       7.101   7.631   4.049  1.00 31.65           C  
ATOM   1082  C   TRP A 138       5.736   7.603   3.362  1.00 34.06           C  
ATOM   1083  O   TRP A 138       4.818   8.319   3.766  1.00 34.08           O  
ATOM   1084  CB  TRP A 138       7.948   8.737   3.414  1.00 29.68           C  
ATOM   1085  CG  TRP A 138       8.150   8.559   1.939  1.00 29.17           C  
ATOM   1086  CD1 TRP A 138       9.146   7.858   1.323  1.00 28.01           C  
ATOM   1087  CD2 TRP A 138       7.298   9.050   0.895  1.00 27.63           C  
ATOM   1088  NE1 TRP A 138       8.967   7.881  -0.043  1.00 27.52           N  
ATOM   1089  CE2 TRP A 138       7.841   8.605  -0.331  1.00 27.93           C  
ATOM   1090  CE3 TRP A 138       6.127   9.821   0.877  1.00 27.67           C  
ATOM   1091  CZ2 TRP A 138       7.251   8.907  -1.566  1.00 27.42           C  
ATOM   1092  CZ3 TRP A 138       5.540  10.120  -0.349  1.00 27.30           C  
ATOM   1093  CH2 TRP A 138       6.105   9.663  -1.555  1.00 27.70           C  
ATOM   1094  N   ALA A 139       5.608   6.783   2.323  1.00 36.21           N  
ATOM   1095  CA  ALA A 139       4.362   6.684   1.567  1.00 40.25           C  
ATOM   1096  C   ALA A 139       3.197   6.101   2.364  1.00 42.92           C  
ATOM   1097  O   ALA A 139       2.036   6.273   1.991  1.00 44.05           O  
ATOM   1098  CB  ALA A 139       4.591   5.864   0.303  1.00 38.80           C  
ATOM   1099  N   SER A 140       3.501   5.410   3.457  1.00 45.60           N  
ATOM   1100  CA  SER A 140       2.454   4.813   4.282  1.00 48.05           C  
ATOM   1101  C   SER A 140       2.468   5.374   5.699  1.00 49.07           C  
ATOM   1102  O   SER A 140       3.099   4.811   6.593  1.00 51.27           O  
ATOM   1103  CB  SER A 140       2.621   3.292   4.326  1.00 48.81           C  
ATOM   1104  OG  SER A 140       3.890   2.930   4.843  1.00 50.27           O  
TER    1105      SER A 140                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
