
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  129 ( 1197),  selected  129 , name 1e3v_B
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1e3v_B.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     2_B      M       1           -
LGA    L     3_B      M       2           -
LGA    P     4_B      T       3           -
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    T     5_B      S       6          5.107
LGA    A     6_B      D       7          3.069
LGA    Q     7_B      -       -           -
LGA    E     8_B      N       8          2.719
LGA    V     9_B      T       9          2.382
LGA    Q    10_B      L      10          2.307
LGA    G    11_B      K      11          2.820
LGA    L    12_B      V      12          2.539
LGA    M    13_B      A      13          2.404
LGA    A    14_B      H      14          2.531
LGA    R    15_B      Q      15          2.602
LGA    Y    16_B      G      16          2.509
LGA    I    17_B      F      17          2.787
LGA    E    18_B      E      18          2.367
LGA    L    19_B      F      19          2.003
LGA    V    20_B      F      20          2.570
LGA    D    21_B      T      21          2.537
LGA    V    22_B      Q      22          2.257
LGA    G    23_B      G      23          2.066
LGA    -       -      L      24           -
LGA    -       -      A      25           -
LGA    -       -      T      26           -
LGA    -       -      G      27           -
LGA    D    24_B      E      28          2.677
LGA    I    25_B      W      29          0.664
LGA    E    26_B      Q      30          0.618
LGA    A    27_B      K      31          0.744
LGA    I    28_B      F      32          1.069
LGA    V    29_B      L      33          0.860
LGA    Q    30_B      D      34          0.905
LGA    M    31_B      M      35          1.378
LGA    Y    32_B      L      36          0.769
LGA    A    33_B      T      37          0.407
LGA    D    34_B      E      38          0.500
LGA    D    35_B      D      39          0.620
LGA    A    36_B      F      40          0.960
LGA    T    37_B      T      41          0.359
LGA    V    38_B      F      42          0.284
LGA    E    39_B      W      43          0.295
LGA    D    40_B      F      44          1.548
LGA    P    41_B      P      45          2.580
LGA    F    42_B      -       -           -
LGA    G    43_B      -       -           -
LGA    Q    44_B      M      46           #
LGA    -       -      G      47           -
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    -       -      H      50           -
LGA    P    45_B      G      51          1.927
LGA    P    46_B      L      52          0.900
LGA    I    47_B      N      53          0.885
LGA    H    48_B      V      54          0.867
LGA    G    49_B      G      55          1.000
LGA    R    50_B      K      56          1.086
LGA    E    51_B      E      57          0.630
LGA    Q    52_B      R      58          0.277
LGA    I    53_B      A      59          0.399
LGA    A    54_B      K      60          0.593
LGA    A    55_B      E      61          0.588
LGA    F    56_B      F      62          0.456
LGA    Y    57_B      F      63          0.447
LGA    R    58_B      T      64          0.713
LGA    Q    59_B      Y      65          0.718
LGA    G    60_B      V      66          0.326
LGA    L    61_B      S      67          1.800
LGA    G    62_B      E      68          5.961
LGA    G    63_B      S      69          5.714
LGA    G    64_B      F      70          2.667
LGA    -       -      H      71           -
LGA    -       -      T      72           -
LGA    K    65_B      G      73          1.512
LGA    V    66_B      I      74          1.183
LGA    R    67_B      Q      75          1.471
LGA    A    68_B      I      76          2.304
LGA    -       -      S      77           -
LGA    C    69_B      S      78          4.192
LGA    L    70_B      L      79          1.765
LGA    T    71_B      D      80          1.950
LGA    G    72_B      R      81          2.260
LGA    P    73_B      V      82          3.132
LGA    V    74_B      -       -           -
LGA    R    75_B      T      83          1.403
LGA    A    76_B      S      84          1.987
LGA    S    77_B      N      85          1.446
LGA    H    78_B      E      86          2.435
LGA    N    79_B      T      87          3.922
LGA    G    80_B      -       -           -
LGA    C    81_B      T      88          1.776
LGA    G    82_B      V      89          1.581
LGA    A    83_B      V      90          1.571
LGA    M    84_B      F      91          1.716
LGA    P    85_B      E      92          0.722
LGA    F    86_B      F      93          1.205
LGA    R    87_B      R      94          1.717
LGA    V    88_B      D      95          2.178
LGA    E    89_B      E      96          1.207
LGA    M    90_B      G      97          2.151
LGA    V    91_B      L      98          1.994
LGA    W    92_B      F      99          2.285
LGA    N    93_B      L     100          2.722
LGA    G    94_B      G     101          0.838
LGA    Q    95_B      K     102          1.268
LGA    P    96_B      P     103          1.202
LGA    C    97_B      Y     104          1.205
LGA    A    98_B      K     105          1.186
LGA    L    99_B      N     106          1.439
LGA    D   100_B      R     107          0.886
LGA    V   101_B      V     108          1.179
LGA    I   102_B      A     109          1.302
LGA    D   103_B      V     110          1.665
LGA    V   104_B      S     111          1.842
LGA    M   105_B      F     112          1.580
LGA    R   106_B      D     113          1.239
LGA    F   107_B      V     114          1.300
LGA    D   108_B      R     115          1.631
LGA    E   109_B      G     116          3.511
LGA    H   110_B      -       -           -
LGA    G   111_B      D     117          1.975
LGA    R   112_B      K     118          1.246
LGA    I   113_B      I     119          1.147
LGA    Q   114_B      C     120          1.075
LGA    T   115_B      S     121          1.289
LGA    M   116_B      Y     122          1.032
LGA    Q   117_B      R     123          1.037
LGA    A   118_B      E     124          1.291
LGA    Y   119_B      Y     125          1.709
LGA    W   120_B      F     126          1.666
LGA    S   121_B      -       -           -
LGA    E   122_B      -       -           -
LGA    V   123_B      G     127          5.565
LGA    N   124_B      S     128          1.212
LGA    L   125_B      D     129          2.132
LGA    S   126_B      G     130          2.990
LGA    V   127_B      K     131          2.541
LGA    R   128_B      -       -           -
LGA    E   129_B      -       -           -
LGA    P   130_B      S     132          4.123
LGA    -       -      N     133           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  129  133    5.0    115    2.08    15.65     75.615     5.268

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.024963 * X  +   0.985222 * Y  +   0.169454 * Z  +  28.579485
  Y_new =   0.849706 * X  +   0.110212 * Y  +  -0.515610 * Z  +  43.300652
  Z_new =  -0.526666 * X  +   0.131115 * Y  +  -0.839900 * Z  +  67.662903 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.986734   -0.154858  [ DEG:   171.1273     -8.8727 ]
  Theta =   0.554674    2.586919  [ DEG:    31.7805    148.2195 ]
  Phi   =   1.600166   -1.541427  [ DEG:    91.6828    -88.3172 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1e3v_B                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1e3v_B.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  129  133   5.0  115   2.08   15.65  75.615
REMARK  ---------------------------------------------------------- 
MOLECULE 1e3v_B
HEADER    ISOMERASE                               23-JUN-00   1E3V              
TITLE     CRYSTAL STRUCTURE OF KETOSTEROID ISOMERASE FROM PSEDOMONAS            
TITLE    2 PUTIDA COMPLEXED WITH DEOXYCHOLATE                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STEROID DELTA-ISOMERASE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: DELTA-5-3-KETOSTEROID ISOMERASE;                            
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: DEOXYCHOLATE                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    DEOXYCHLATE, KSI, LBHB, REVERSE BINDING                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.-C.HA,M.-S.KIM,J.-S.KIM,B.-H.OH                                     
REVDAT   2   01-APR-03 1E3V    1       JRNL                                     
REVDAT   1   12-MAR-01 1E3V    0                                                
JRNL        AUTH   N.C.HA,M.S.KIM,W.LEE,K.Y.CHOI,B.H.OH                         
JRNL        TITL   DETECTION OF LARGE PKA PERTURBATIONS OF AN                   
JRNL        TITL 2 INHIBITOR AND A CATALYTIC GROUP AT AN ENZYME                 
JRNL        TITL 3 ACTIVE SITE, A MECHANISTIC BASIS FOR CATALYTIC               
JRNL        TITL 4 POWER OF MANY ENZYMES.                                       
JRNL        REF    J.BIOL.CHEM.                  V. 275 41100 2000              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1E3V A    1   131  UNP    P07445   SDIS_PSEPU       1    131             
DBREF  1E3V B    1   131  UNP    P07445   SDIS_PSEPU       1    131             
SEQRES   1 A  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 A  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 A  131  ALA ILE VAL GLN MET TYR ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 A  131  ASP PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 A  131  ILE ALA ALA PHE TYR ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 A  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 A  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 A  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 A  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 A  131  ALA TYR TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 A  131  GLN                                                          
SEQRES   1 B  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 B  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 B  131  ALA ILE VAL GLN MET TYR ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 B  131  ASP PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 B  131  ILE ALA ALA PHE TYR ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 B  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 B  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 B  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 B  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 B  131  ALA TYR TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 B  131  GLN                                                          
HET    DXC  A 801      28                                                       
HET    DXC  B 801      28                                                       
HETNAM     DXC (3ALPHA,5ALPHA,12ALPHA)-3,12-DIHYDROXYCHOLAN-24-OIC              
HETNAM   2 DXC  ACID                                                            
HETSYN     DXC DEOXYCHOLIC ACID                                                 
FORMUL   3  DXC    2(C24 H40 O4)                                                
FORMUL   5  HOH   *104(H2 O)                                                    
CRYST1   36.580   75.210   96.130  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1192  N   ASN B   2      32.730  21.533   3.793  1.00 47.58           N  
ATOM   1193  CA  ASN B   2      33.933  22.357   3.483  1.00 43.54           C  
ATOM   1194  C   ASN B   2      35.139  21.983   4.340  1.00 40.10           C  
ATOM   1195  O   ASN B   2      35.863  21.050   4.011  1.00 40.14           O  
ATOM   1196  CB  ASN B   2      33.610  23.841   3.631  1.00 45.31           C  
ATOM   1197  H1  ASN B   2      32.438  21.590   4.786  1.00  0.00           H  
ATOM   1198  H2  ASN B   2      31.914  21.846   3.226  1.00  0.00           H  
ATOM   1199  H3  ASN B   2      32.940  20.553   3.524  1.00  0.00           H  
ATOM   1200  N   LEU B   3      35.305  22.677   5.467  1.00 37.24           N  
ATOM   1201  CA  LEU B   3      36.422  22.471   6.388  1.00 31.53           C  
ATOM   1202  C   LEU B   3      36.540  21.149   7.156  1.00 27.46           C  
ATOM   1203  O   LEU B   3      37.637  20.595   7.257  1.00 28.13           O  
ATOM   1204  CB  LEU B   3      36.525  23.664   7.355  1.00 32.32           C  
ATOM   1205  CG  LEU B   3      36.878  23.450   8.834  1.00 33.77           C  
ATOM   1206  CD1 LEU B   3      37.753  24.594   9.340  1.00 32.02           C  
ATOM   1207  CD2 LEU B   3      35.603  23.318   9.670  1.00 28.91           C  
ATOM   1208  H   LEU B   3      34.672  23.361   5.748  1.00  0.00           H  
ATOM   1209  N   PRO B   4      35.436  20.644   7.741  1.00 22.51           N  
ATOM   1210  CA  PRO B   4      35.595  19.380   8.468  1.00 17.69           C  
ATOM   1211  C   PRO B   4      36.121  18.245   7.592  1.00 16.81           C  
ATOM   1212  O   PRO B   4      35.699  18.084   6.445  1.00 13.98           O  
ATOM   1213  CB  PRO B   4      34.180  19.104   8.981  1.00 17.10           C  
ATOM   1214  CG  PRO B   4      33.319  19.767   7.961  1.00 19.83           C  
ATOM   1215  CD  PRO B   4      34.026  21.072   7.755  1.00 21.30           C  
ATOM   1216  N   THR B   5      37.068  17.486   8.130  1.00 14.88           N  
ATOM   1217  CA  THR B   5      37.663  16.359   7.429  1.00 13.40           C  
ATOM   1218  C   THR B   5      36.678  15.197   7.509  1.00 12.47           C  
ATOM   1219  O   THR B   5      35.747  15.240   8.317  1.00 13.48           O  
ATOM   1220  CB  THR B   5      38.991  15.944   8.094  1.00 10.41           C  
ATOM   1221  OG1 THR B   5      38.738  15.482   9.428  1.00  7.90           O  
ATOM   1222  CG2 THR B   5      39.965  17.132   8.138  1.00 10.64           C  
ATOM   1223  H   THR B   5      37.385  17.670   9.031  1.00  0.00           H  
ATOM   1224  HG1 THR B   5      38.693  14.521   9.450  1.00  0.00           H  
ATOM   1225  N   ALA B   6      36.933  14.133   6.749  1.00 11.19           N  
ATOM   1226  CA  ALA B   6      36.058  12.963   6.729  1.00  9.71           C  
ATOM   1227  C   ALA B   6      35.835  12.411   8.130  1.00  9.91           C  
ATOM   1228  O   ALA B   6      34.707  12.096   8.505  1.00 10.29           O  
ATOM   1229  CB  ALA B   6      36.621  11.880   5.804  1.00  6.85           C  
ATOM   1230  H   ALA B   6      37.753  14.082   6.223  1.00  0.00           H  
ATOM   1231  N   GLN B   7      36.904  12.313   8.913  1.00 11.41           N  
ATOM   1232  CA  GLN B   7      36.806  11.813  10.284  1.00 14.72           C  
ATOM   1233  C   GLN B   7      35.978  12.721  11.181  1.00 13.95           C  
ATOM   1234  O   GLN B   7      35.286  12.249  12.080  1.00 13.76           O  
ATOM   1235  CB  GLN B   7      38.195  11.624  10.880  1.00 18.72           C  
ATOM   1236  CG  GLN B   7      38.840  10.325  10.449  1.00 34.74           C  
ATOM   1237  CD  GLN B   7      40.352  10.365  10.492  1.00 40.26           C  
ATOM   1238  OE1 GLN B   7      41.014   9.895   9.563  1.00 42.27           O  
ATOM   1239  NE2 GLN B   7      40.912  10.925  11.564  1.00 41.88           N  
ATOM   1240  H   GLN B   7      37.784  12.537   8.545  1.00  0.00           H  
ATOM   1241 HE21 GLN B   7      41.890  10.957  11.586  1.00  0.00           H  
ATOM   1242 HE22 GLN B   7      40.362  11.301  12.285  1.00  0.00           H  
ATOM   1243  N   GLU B   8      36.071  14.023  10.943  1.00 13.51           N  
ATOM   1244  CA  GLU B   8      35.319  14.997  11.713  1.00 14.31           C  
ATOM   1245  C   GLU B   8      33.837  14.962  11.322  1.00 14.84           C  
ATOM   1246  O   GLU B   8      32.965  15.101  12.182  1.00 14.21           O  
ATOM   1247  CB  GLU B   8      35.925  16.384  11.522  1.00 13.73           C  
ATOM   1248  CG  GLU B   8      37.364  16.427  12.013  1.00 24.52           C  
ATOM   1249  CD  GLU B   8      38.047  17.762  11.811  1.00 25.76           C  
ATOM   1250  OE1 GLU B   8      37.703  18.492  10.859  1.00 27.73           O  
ATOM   1251  OE2 GLU B   8      38.951  18.075  12.610  1.00 35.06           O  
ATOM   1252  H   GLU B   8      36.653  14.347  10.229  1.00  0.00           H  
ATOM   1253  N   VAL B   9      33.556  14.725  10.040  1.00 12.57           N  
ATOM   1254  CA  VAL B   9      32.178  14.642   9.563  1.00 11.57           C  
ATOM   1255  C   VAL B   9      31.502  13.466  10.273  1.00 12.23           C  
ATOM   1256  O   VAL B   9      30.360  13.585  10.739  1.00 10.96           O  
ATOM   1257  CB  VAL B   9      32.114  14.452   8.022  1.00 12.93           C  
ATOM   1258  CG1 VAL B   9      30.693  14.123   7.574  1.00 13.14           C  
ATOM   1259  CG2 VAL B   9      32.588  15.717   7.317  1.00 12.38           C  
ATOM   1260  H   VAL B   9      34.279  14.592   9.394  1.00  0.00           H  
ATOM   1261  N   GLN B  10      32.226  12.353  10.404  1.00 10.30           N  
ATOM   1262  CA  GLN B  10      31.695  11.172  11.082  1.00  9.80           C  
ATOM   1263  C   GLN B  10      31.307  11.491  12.527  1.00 12.76           C  
ATOM   1264  O   GLN B  10      30.293  11.001  13.027  1.00 10.36           O  
ATOM   1265  CB  GLN B  10      32.712  10.032  11.094  1.00 10.73           C  
ATOM   1266  CG  GLN B  10      32.968   9.369   9.752  1.00 10.15           C  
ATOM   1267  CD  GLN B  10      33.695   8.046   9.911  1.00 13.17           C  
ATOM   1268  OE1 GLN B  10      33.198   6.989   9.505  1.00 14.46           O  
ATOM   1269  NE2 GLN B  10      34.871   8.091  10.530  1.00 13.09           N  
ATOM   1270  H   GLN B  10      33.127  12.319  10.014  1.00  0.00           H  
ATOM   1271 HE21 GLN B  10      35.311   7.224  10.623  1.00  0.00           H  
ATOM   1272 HE22 GLN B  10      35.226   8.935  10.858  1.00  0.00           H  
ATOM   1273  N   GLY B  11      32.144  12.275  13.206  1.00 12.29           N  
ATOM   1274  CA  GLY B  11      31.867  12.641  14.584  1.00 12.81           C  
ATOM   1275  C   GLY B  11      30.696  13.598  14.731  1.00 10.23           C  
ATOM   1276  O   GLY B  11      29.842  13.422  15.605  1.00 11.66           O  
ATOM   1277  H   GLY B  11      32.956  12.606  12.770  1.00  0.00           H  
ATOM   1278  N   LEU B  12      30.662  14.619  13.887  1.00  7.11           N  
ATOM   1279  CA  LEU B  12      29.599  15.613  13.908  1.00  9.84           C  
ATOM   1280  C   LEU B  12      28.235  14.986  13.664  1.00 11.24           C  
ATOM   1281  O   LEU B  12      27.273  15.259  14.393  1.00  9.62           O  
ATOM   1282  CB  LEU B  12      29.869  16.683  12.859  1.00  8.20           C  
ATOM   1283  CG  LEU B  12      30.976  17.661  13.246  1.00 16.72           C  
ATOM   1284  CD1 LEU B  12      31.502  18.350  12.021  1.00 15.11           C  
ATOM   1285  CD2 LEU B  12      30.460  18.664  14.252  1.00 15.00           C  
ATOM   1286  H   LEU B  12      31.388  14.702  13.233  1.00  0.00           H  
ATOM   1287  N   MET B  13      28.158  14.149  12.632  1.00 10.09           N  
ATOM   1288  CA  MET B  13      26.912  13.477  12.291  1.00 10.78           C  
ATOM   1289  C   MET B  13      26.473  12.484  13.368  1.00  9.71           C  
ATOM   1290  O   MET B  13      25.275  12.335  13.616  1.00 12.03           O  
ATOM   1291  CB  MET B  13      27.020  12.819  10.912  1.00 11.17           C  
ATOM   1292  CG  MET B  13      27.138  13.838   9.800  1.00  8.01           C  
ATOM   1293  SD  MET B  13      27.190  13.142   8.142  1.00 13.36           S  
ATOM   1294  CE  MET B  13      25.427  12.867   7.838  1.00  9.53           C  
ATOM   1295  H   MET B  13      28.954  14.004  12.081  1.00  0.00           H  
ATOM   1296  N   ALA B  14      27.430  11.838  14.033  1.00  6.00           N  
ATOM   1297  CA  ALA B  14      27.104  10.904  15.106  1.00  6.00           C  
ATOM   1298  C   ALA B  14      26.599  11.701  16.321  1.00  9.27           C  
ATOM   1299  O   ALA B  14      25.691  11.252  17.051  1.00  8.51           O  
ATOM   1300  CB  ALA B  14      28.318  10.083  15.482  1.00  7.94           C  
ATOM   1301  H   ALA B  14      28.369  11.981  13.791  1.00  0.00           H  
ATOM   1302  N   ARG B  15      27.155  12.897  16.517  1.00  9.44           N  
ATOM   1303  CA  ARG B  15      26.742  13.743  17.628  1.00 10.41           C  
ATOM   1304  C   ARG B  15      25.325  14.241  17.382  1.00 10.05           C  
ATOM   1305  O   ARG B  15      24.525  14.347  18.314  1.00  9.78           O  
ATOM   1306  CB  ARG B  15      27.679  14.933  17.820  1.00 14.88           C  
ATOM   1307  CG  ARG B  15      27.343  15.705  19.086  1.00 20.62           C  
ATOM   1308  CD  ARG B  15      28.092  17.011  19.227  1.00 26.92           C  
ATOM   1309  NE  ARG B  15      27.736  17.664  20.488  1.00 34.89           N  
ATOM   1310  CZ  ARG B  15      27.243  18.895  20.581  1.00 36.81           C  
ATOM   1311  NH1 ARG B  15      27.045  19.623  19.489  1.00 40.79           N  
ATOM   1312  NH2 ARG B  15      26.931  19.396  21.769  1.00 37.83           N  
ATOM   1313  H   ARG B  15      27.861  13.211  15.914  1.00  0.00           H  
ATOM   1314  HE  ARG B  15      27.862  17.160  21.319  1.00  0.00           H  
ATOM   1315 HH11 ARG B  15      27.267  19.249  18.588  1.00  0.00           H  
ATOM   1316 HH12 ARG B  15      26.680  20.549  19.566  1.00  0.00           H  
ATOM   1317 HH21 ARG B  15      27.081  18.850  22.590  1.00  0.00           H  
ATOM   1318 HH22 ARG B  15      26.564  20.320  21.840  1.00  0.00           H  
ATOM   1319  N   TYR B  16      25.030  14.579  16.131  1.00  9.73           N  
ATOM   1320  CA  TYR B  16      23.698  15.033  15.756  1.00 10.51           C  
ATOM   1321  C   TYR B  16      22.643  13.989  16.176  1.00  9.69           C  
ATOM   1322  O   TYR B  16      21.632  14.342  16.785  1.00 12.20           O  
ATOM   1323  CB  TYR B  16      23.637  15.299  14.251  1.00 10.15           C  
ATOM   1324  CG  TYR B  16      22.237  15.506  13.728  1.00 11.42           C  
ATOM   1325  CD1 TYR B  16      21.630  16.758  13.785  1.00 10.44           C  
ATOM   1326  CD2 TYR B  16      21.498  14.431  13.209  1.00  8.07           C  
ATOM   1327  CE1 TYR B  16      20.322  16.937  13.343  1.00 12.07           C  
ATOM   1328  CE2 TYR B  16      20.187  14.601  12.764  1.00  8.00           C  
ATOM   1329  CZ  TYR B  16      19.610  15.854  12.839  1.00  8.50           C  
ATOM   1330  OH  TYR B  16      18.318  16.043  12.432  1.00  8.94           O  
ATOM   1331  H   TYR B  16      25.729  14.537  15.445  1.00  0.00           H  
ATOM   1332  HH  TYR B  16      18.115  16.950  12.715  1.00  0.00           H  
ATOM   1333  N   ILE B  17      22.882  12.713  15.872  1.00  9.53           N  
ATOM   1334  CA  ILE B  17      21.948  11.644  16.250  1.00 10.22           C  
ATOM   1335  C   ILE B  17      21.804  11.565  17.780  1.00 11.95           C  
ATOM   1336  O   ILE B  17      20.706  11.336  18.299  1.00  8.63           O  
ATOM   1337  CB  ILE B  17      22.403  10.247  15.702  1.00 10.70           C  
ATOM   1338  CG1 ILE B  17      22.290  10.202  14.179  1.00 12.41           C  
ATOM   1339  CG2 ILE B  17      21.569   9.125  16.309  1.00 11.37           C  
ATOM   1340  CD1 ILE B  17      20.902  10.435  13.661  1.00 14.35           C  
ATOM   1341  H   ILE B  17      23.693  12.486  15.373  1.00  0.00           H  
ATOM   1342  N   GLU B  18      22.912  11.738  18.500  1.00 10.43           N  
ATOM   1343  CA  GLU B  18      22.873  11.696  19.959  1.00 13.33           C  
ATOM   1344  C   GLU B  18      21.970  12.799  20.523  1.00 10.91           C  
ATOM   1345  O   GLU B  18      21.205  12.572  21.457  1.00  9.85           O  
ATOM   1346  CB  GLU B  18      24.280  11.843  20.542  1.00 20.46           C  
ATOM   1347  CG  GLU B  18      25.239  10.715  20.205  1.00 36.02           C  
ATOM   1348  CD  GLU B  18      26.670  11.008  20.663  1.00 45.74           C  
ATOM   1349  OE1 GLU B  18      26.859  11.434  21.828  1.00 48.09           O  
ATOM   1350  OE2 GLU B  18      27.606  10.819  19.851  1.00 50.31           O  
ATOM   1351  H   GLU B  18      23.765  11.900  18.042  1.00  0.00           H  
ATOM   1352  N   LEU B  19      22.072  13.995  19.956  1.00  9.30           N  
ATOM   1353  CA  LEU B  19      21.268  15.125  20.396  1.00  8.03           C  
ATOM   1354  C   LEU B  19      19.788  14.922  20.078  1.00  9.07           C  
ATOM   1355  O   LEU B  19      18.925  15.358  20.846  1.00  7.10           O  
ATOM   1356  CB  LEU B  19      21.772  16.414  19.764  1.00  7.07           C  
ATOM   1357  CG  LEU B  19      23.182  16.848  20.153  1.00  8.66           C  
ATOM   1358  CD1 LEU B  19      23.557  18.101  19.374  1.00  7.01           C  
ATOM   1359  CD2 LEU B  19      23.253  17.092  21.644  1.00  6.02           C  
ATOM   1360  H   LEU B  19      22.722  14.126  19.230  1.00  0.00           H  
ATOM   1361  N   VAL B  20      19.501  14.287  18.941  1.00  9.64           N  
ATOM   1362  CA  VAL B  20      18.127  14.000  18.536  1.00  9.19           C  
ATOM   1363  C   VAL B  20      17.566  12.957  19.500  1.00  8.58           C  
ATOM   1364  O   VAL B  20      16.444  13.080  19.978  1.00 10.33           O  
ATOM   1365  CB  VAL B  20      18.048  13.442  17.088  1.00  9.92           C  
ATOM   1366  CG1 VAL B  20      16.636  12.944  16.793  1.00  8.22           C  
ATOM   1367  CG2 VAL B  20      18.433  14.517  16.079  1.00  6.00           C  
ATOM   1368  H   VAL B  20      20.243  14.027  18.353  1.00  0.00           H  
ATOM   1369  N   ASP B  21      18.375  11.953  19.812  1.00  9.28           N  
ATOM   1370  CA  ASP B  21      17.972  10.898  20.730  1.00 10.04           C  
ATOM   1371  C   ASP B  21      17.630  11.443  22.134  1.00 14.18           C  
ATOM   1372  O   ASP B  21      16.672  10.987  22.758  1.00 13.82           O  
ATOM   1373  CB  ASP B  21      19.077   9.837  20.818  1.00 10.76           C  
ATOM   1374  CG  ASP B  21      18.682   8.654  21.677  1.00 13.00           C  
ATOM   1375  OD1 ASP B  21      17.702   7.971  21.330  1.00 16.55           O  
ATOM   1376  OD2 ASP B  21      19.344   8.399  22.701  1.00 18.27           O  
ATOM   1377  H   ASP B  21      19.269  11.914  19.412  1.00  0.00           H  
ATOM   1378  N   VAL B  22      18.421  12.390  22.645  1.00 15.94           N  
ATOM   1379  CA  VAL B  22      18.145  12.955  23.972  1.00 17.71           C  
ATOM   1380  C   VAL B  22      17.122  14.090  23.924  1.00 17.85           C  
ATOM   1381  O   VAL B  22      16.614  14.512  24.960  1.00 20.68           O  
ATOM   1382  CB  VAL B  22      19.431  13.434  24.730  1.00 17.97           C  
ATOM   1383  CG1 VAL B  22      20.381  12.268  24.962  1.00 19.49           C  
ATOM   1384  CG2 VAL B  22      20.118  14.572  23.986  1.00 16.26           C  
ATOM   1385  H   VAL B  22      19.197  12.696  22.129  1.00  0.00           H  
ATOM   1386  N   GLY B  23      16.839  14.590  22.727  1.00 13.81           N  
ATOM   1387  CA  GLY B  23      15.868  15.655  22.570  1.00 11.06           C  
ATOM   1388  C   GLY B  23      16.304  17.056  22.966  1.00 14.28           C  
ATOM   1389  O   GLY B  23      15.473  17.860  23.387  1.00 15.15           O  
ATOM   1390  H   GLY B  23      17.271  14.246  21.915  1.00  0.00           H  
ATOM   1391  N   ASP B  24      17.588  17.369  22.816  1.00 13.53           N  
ATOM   1392  CA  ASP B  24      18.076  18.697  23.165  1.00 12.37           C  
ATOM   1393  C   ASP B  24      17.940  19.601  21.948  1.00 11.89           C  
ATOM   1394  O   ASP B  24      18.842  19.683  21.114  1.00 11.87           O  
ATOM   1395  CB  ASP B  24      19.534  18.635  23.633  1.00 13.19           C  
ATOM   1396  CG  ASP B  24      19.964  19.901  24.363  1.00 15.56           C  
ATOM   1397  OD1 ASP B  24      19.725  21.018  23.855  1.00 16.74           O  
ATOM   1398  OD2 ASP B  24      20.541  19.784  25.459  1.00 17.09           O  
ATOM   1399  H   ASP B  24      18.189  16.697  22.426  1.00  0.00           H  
ATOM   1400  N   ILE B  25      16.831  20.326  21.887  1.00 11.30           N  
ATOM   1401  CA  ILE B  25      16.539  21.207  20.773  1.00 12.26           C  
ATOM   1402  C   ILE B  25      17.504  22.380  20.605  1.00 14.43           C  
ATOM   1403  O   ILE B  25      17.953  22.650  19.486  1.00 15.42           O  
ATOM   1404  CB  ILE B  25      15.064  21.666  20.824  1.00 15.97           C  
ATOM   1405  CG1 ILE B  25      14.161  20.433  20.751  1.00 14.62           C  
ATOM   1406  CG2 ILE B  25      14.746  22.612  19.667  1.00 15.68           C  
ATOM   1407  CD1 ILE B  25      12.790  20.635  21.359  1.00 23.93           C  
ATOM   1408  H   ILE B  25      16.180  20.258  22.623  1.00  0.00           H  
ATOM   1409  N   GLU B  26      17.857  23.054  21.698  1.00 14.88           N  
ATOM   1410  CA  GLU B  26      18.786  24.184  21.621  1.00 16.46           C  
ATOM   1411  C   GLU B  26      20.135  23.724  21.057  1.00 14.70           C  
ATOM   1412  O   GLU B  26      20.708  24.389  20.200  1.00 14.22           O  
ATOM   1413  CB  GLU B  26      18.978  24.833  23.003  1.00 25.80           C  
ATOM   1414  CG  GLU B  26      19.946  26.036  23.029  1.00 42.85           C  
ATOM   1415  CD  GLU B  26      20.152  26.638  24.431  1.00 52.02           C  
ATOM   1416  OE1 GLU B  26      20.575  25.893  25.344  1.00 57.90           O  
ATOM   1417  OE2 GLU B  26      19.908  27.858  24.616  1.00 52.90           O  
ATOM   1418  H   GLU B  26      17.469  22.804  22.563  1.00  0.00           H  
ATOM   1419  N   ALA B  27      20.609  22.561  21.512  1.00 14.48           N  
ATOM   1420  CA  ALA B  27      21.883  22.001  21.060  1.00 13.59           C  
ATOM   1421  C   ALA B  27      21.870  21.670  19.566  1.00 13.52           C  
ATOM   1422  O   ALA B  27      22.832  21.977  18.851  1.00 11.83           O  
ATOM   1423  CB  ALA B  27      22.244  20.772  21.882  1.00  9.22           C  
ATOM   1424  H   ALA B  27      20.071  22.065  22.149  1.00  0.00           H  
ATOM   1425  N   ILE B  28      20.777  21.071  19.089  1.00 13.84           N  
ATOM   1426  CA  ILE B  28      20.636  20.731  17.667  1.00 11.57           C  
ATOM   1427  C   ILE B  28      20.629  21.991  16.807  1.00 11.31           C  
ATOM   1428  O   ILE B  28      21.376  22.093  15.833  1.00 11.92           O  
ATOM   1429  CB  ILE B  28      19.337  19.939  17.387  1.00 13.31           C  
ATOM   1430  CG1 ILE B  28      19.382  18.586  18.105  1.00 14.09           C  
ATOM   1431  CG2 ILE B  28      19.160  19.737  15.884  1.00 12.90           C  
ATOM   1432  CD1 ILE B  28      18.065  17.818  18.094  1.00 15.40           C  
ATOM   1433  H   ILE B  28      20.047  20.843  19.703  1.00  0.00           H  
ATOM   1434  N   VAL B  29      19.806  22.964  17.182  1.00  9.93           N  
ATOM   1435  CA  VAL B  29      19.722  24.209  16.433  1.00 12.04           C  
ATOM   1436  C   VAL B  29      21.088  24.901  16.348  1.00 14.96           C  
ATOM   1437  O   VAL B  29      21.408  25.545  15.342  1.00 13.89           O  
ATOM   1438  CB  VAL B  29      18.682  25.176  17.057  1.00 16.85           C  
ATOM   1439  CG1 VAL B  29      18.601  26.463  16.243  1.00 20.33           C  
ATOM   1440  CG2 VAL B  29      17.309  24.513  17.108  1.00 19.01           C  
ATOM   1441  H   VAL B  29      19.246  22.837  17.980  1.00  0.00           H  
ATOM   1442  N   GLN B  30      21.888  24.761  17.400  1.00 16.57           N  
ATOM   1443  CA  GLN B  30      23.223  25.357  17.447  1.00 19.91           C  
ATOM   1444  C   GLN B  30      24.176  24.733  16.422  1.00 17.13           C  
ATOM   1445  O   GLN B  30      25.190  25.335  16.067  1.00 19.81           O  
ATOM   1446  CB  GLN B  30      23.832  25.209  18.846  1.00 27.05           C  
ATOM   1447  CG  GLN B  30      23.139  26.002  19.942  1.00 40.70           C  
ATOM   1448  CD  GLN B  30      23.520  27.477  19.963  1.00 49.62           C  
ATOM   1449  OE1 GLN B  30      24.073  28.018  18.997  1.00 53.50           O  
ATOM   1450  NE2 GLN B  30      23.234  28.136  21.081  1.00 54.17           N  
ATOM   1451  H   GLN B  30      21.559  24.265  18.183  1.00  0.00           H  
ATOM   1452 HE21 GLN B  30      23.457  29.086  21.128  1.00  0.00           H  
ATOM   1453 HE22 GLN B  30      22.809  27.642  21.811  1.00  0.00           H  
ATOM   1454  N   MET B  31      23.879  23.516  15.979  1.00 13.88           N  
ATOM   1455  CA  MET B  31      24.724  22.842  14.998  1.00 10.83           C  
ATOM   1456  C   MET B  31      24.541  23.396  13.594  1.00 11.43           C  
ATOM   1457  O   MET B  31      25.353  23.129  12.704  1.00 14.24           O  
ATOM   1458  CB  MET B  31      24.439  21.341  14.977  1.00  9.84           C  
ATOM   1459  CG  MET B  31      24.920  20.610  16.197  1.00 11.79           C  
ATOM   1460  SD  MET B  31      24.892  18.832  15.970  1.00 16.21           S  
ATOM   1461  CE  MET B  31      26.301  18.584  14.924  1.00 15.35           C  
ATOM   1462  H   MET B  31      23.081  23.057  16.313  1.00  0.00           H  
ATOM   1463  N   TYR B  32      23.485  24.176  13.398  1.00 10.90           N  
ATOM   1464  CA  TYR B  32      23.175  24.733  12.089  1.00 11.66           C  
ATOM   1465  C   TYR B  32      23.727  26.117  11.820  1.00 12.79           C  
ATOM   1466  O   TYR B  32      23.893  26.914  12.734  1.00 13.33           O  
ATOM   1467  CB  TYR B  32      21.654  24.761  11.875  1.00  9.95           C  
ATOM   1468  CG  TYR B  32      21.053  23.419  11.519  1.00  9.08           C  
ATOM   1469  CD1 TYR B  32      20.950  23.015  10.188  1.00  6.48           C  
ATOM   1470  CD2 TYR B  32      20.584  22.555  12.510  1.00 11.00           C  
ATOM   1471  CE1 TYR B  32      20.395  21.789   9.850  1.00  8.28           C  
ATOM   1472  CE2 TYR B  32      20.027  21.320  12.182  1.00  8.99           C  
ATOM   1473  CZ  TYR B  32      19.937  20.946  10.850  1.00  8.88           C  
ATOM   1474  OH  TYR B  32      19.392  19.723  10.517  1.00  9.80           O  
ATOM   1475  H   TYR B  32      22.912  24.435  14.148  1.00  0.00           H  
ATOM   1476  HH  TYR B  32      19.287  19.681   9.566  1.00  0.00           H  
ATOM   1477  N   ALA B  33      24.025  26.380  10.550  1.00 14.55           N  
ATOM   1478  CA  ALA B  33      24.519  27.680  10.111  1.00 17.60           C  
ATOM   1479  C   ALA B  33      23.295  28.590  10.019  1.00 21.03           C  
ATOM   1480  O   ALA B  33      22.166  28.106   9.925  1.00 20.93           O  
ATOM   1481  CB  ALA B  33      25.190  27.555   8.744  1.00 13.27           C  
ATOM   1482  H   ALA B  33      23.882  25.670   9.887  1.00  0.00           H  
ATOM   1483  N   ASP B  34      23.508  29.900  10.040  1.00 25.75           N  
ATOM   1484  CA  ASP B  34      22.393  30.847   9.956  1.00 32.05           C  
ATOM   1485  C   ASP B  34      21.595  30.764   8.655  1.00 30.96           C  
ATOM   1486  O   ASP B  34      20.378  30.976   8.645  1.00 31.51           O  
ATOM   1487  CB  ASP B  34      22.889  32.277  10.168  1.00 39.13           C  
ATOM   1488  CG  ASP B  34      23.007  32.632  11.632  1.00 47.91           C  
ATOM   1489  OD1 ASP B  34      21.976  32.591  12.341  1.00 54.16           O  
ATOM   1490  OD2 ASP B  34      24.129  32.944  12.078  1.00 54.51           O  
ATOM   1491  H   ASP B  34      24.421  30.226  10.154  1.00  0.00           H  
ATOM   1492  N   ASP B  35      22.286  30.465   7.560  1.00 28.79           N  
ATOM   1493  CA  ASP B  35      21.641  30.362   6.255  1.00 28.62           C  
ATOM   1494  C   ASP B  35      21.373  28.911   5.832  1.00 23.38           C  
ATOM   1495  O   ASP B  35      21.167  28.620   4.652  1.00 23.95           O  
ATOM   1496  CB  ASP B  35      22.460  31.119   5.190  1.00 33.96           C  
ATOM   1497  CG  ASP B  35      23.870  30.556   5.004  1.00 40.97           C  
ATOM   1498  OD1 ASP B  35      24.496  30.128   6.002  1.00 42.48           O  
ATOM   1499  OD2 ASP B  35      24.355  30.557   3.847  1.00 45.52           O  
ATOM   1500  H   ASP B  35      23.240  30.295   7.657  1.00  0.00           H  
ATOM   1501  N   ALA B  36      21.315  28.019   6.812  1.00 17.95           N  
ATOM   1502  CA  ALA B  36      21.080  26.610   6.556  1.00 15.00           C  
ATOM   1503  C   ALA B  36      19.668  26.331   6.051  1.00 16.85           C  
ATOM   1504  O   ALA B  36      18.755  27.145   6.239  1.00 17.23           O  
ATOM   1505  CB  ALA B  36      21.339  25.810   7.817  1.00 11.88           C  
ATOM   1506  H   ALA B  36      21.391  28.300   7.748  1.00  0.00           H  
ATOM   1507  N   THR B  37      19.514  25.195   5.370  1.00 13.90           N  
ATOM   1508  CA  THR B  37      18.221  24.746   4.859  1.00 15.24           C  
ATOM   1509  C   THR B  37      18.027  23.282   5.250  1.00 14.65           C  
ATOM   1510  O   THR B  37      18.992  22.508   5.309  1.00 13.88           O  
ATOM   1511  CB  THR B  37      18.107  24.866   3.318  1.00 16.88           C  
ATOM   1512  OG1 THR B  37      19.143  24.103   2.688  1.00 22.30           O  
ATOM   1513  CG2 THR B  37      18.207  26.305   2.878  1.00 19.81           C  
ATOM   1514  H   THR B  37      20.299  24.626   5.209  1.00  0.00           H  
ATOM   1515  HG1 THR B  37      19.980  24.560   2.855  1.00  0.00           H  
ATOM   1516  N   VAL B  38      16.789  22.910   5.549  1.00 12.99           N  
ATOM   1517  CA  VAL B  38      16.467  21.541   5.918  1.00 11.82           C  
ATOM   1518  C   VAL B  38      15.391  21.072   4.957  1.00 12.99           C  
ATOM   1519  O   VAL B  38      14.459  21.817   4.670  1.00 11.15           O  
ATOM   1520  CB  VAL B  38      15.922  21.466   7.361  1.00 12.24           C  
ATOM   1521  CG1 VAL B  38      15.341  20.093   7.652  1.00  9.08           C  
ATOM   1522  CG2 VAL B  38      17.031  21.785   8.352  1.00 14.21           C  
ATOM   1523  H   VAL B  38      16.056  23.560   5.482  1.00  0.00           H  
ATOM   1524  N   GLU B  39      15.570  19.876   4.405  1.00 11.96           N  
ATOM   1525  CA  GLU B  39      14.590  19.279   3.496  1.00 13.56           C  
ATOM   1526  C   GLU B  39      14.236  17.936   4.116  1.00 11.49           C  
ATOM   1527  O   GLU B  39      15.011  16.983   4.037  1.00  9.27           O  
ATOM   1528  CB  GLU B  39      15.176  19.104   2.091  1.00 14.08           C  
ATOM   1529  CG  GLU B  39      15.339  20.415   1.353  1.00 13.21           C  
ATOM   1530  CD  GLU B  39      16.084  20.272   0.047  1.00 16.65           C  
ATOM   1531  OE1 GLU B  39      17.322  20.397   0.050  1.00 18.03           O  
ATOM   1532  OE2 GLU B  39      15.437  20.052  -0.992  1.00 19.33           O  
ATOM   1533  H   GLU B  39      16.380  19.358   4.595  1.00  0.00           H  
ATOM   1534  N   ASP B  40      13.085  17.881   4.776  1.00 10.16           N  
ATOM   1535  CA  ASP B  40      12.647  16.673   5.458  1.00  9.97           C  
ATOM   1536  C   ASP B  40      11.117  16.536   5.424  1.00 12.38           C  
ATOM   1537  O   ASP B  40      10.402  17.305   6.063  1.00 15.81           O  
ATOM   1538  CB  ASP B  40      13.143  16.738   6.906  1.00  8.54           C  
ATOM   1539  CG  ASP B  40      12.926  15.456   7.676  1.00  8.59           C  
ATOM   1540  OD1 ASP B  40      12.133  14.601   7.264  1.00 13.14           O  
ATOM   1541  OD2 ASP B  40      13.551  15.309   8.738  1.00 15.45           O  
ATOM   1542  H   ASP B  40      12.501  18.669   4.784  1.00  0.00           H  
ATOM   1543  HD2 ASP B  40      13.178  15.895   9.402  1.00  0.00           H  
ATOM   1544  N   PRO B  41      10.600  15.549   4.677  1.00 13.25           N  
ATOM   1545  CA  PRO B  41      11.386  14.600   3.885  1.00 10.92           C  
ATOM   1546  C   PRO B  41      11.849  15.245   2.582  1.00  9.56           C  
ATOM   1547  O   PRO B  41      11.297  16.266   2.158  1.00 11.36           O  
ATOM   1548  CB  PRO B  41      10.388  13.467   3.641  1.00 11.29           C  
ATOM   1549  CG  PRO B  41       9.101  14.183   3.538  1.00 10.51           C  
ATOM   1550  CD  PRO B  41       9.177  15.164   4.685  1.00 13.03           C  
ATOM   1551  N   PHE B  42      12.889  14.687   1.976  1.00  9.64           N  
ATOM   1552  CA  PHE B  42      13.392  15.214   0.719  1.00 10.34           C  
ATOM   1553  C   PHE B  42      12.225  15.143  -0.271  1.00 11.62           C  
ATOM   1554  O   PHE B  42      11.524  14.126  -0.348  1.00 13.62           O  
ATOM   1555  CB  PHE B  42      14.576  14.383   0.221  1.00 11.23           C  
ATOM   1556  CG  PHE B  42      15.201  14.920  -1.034  1.00 11.46           C  
ATOM   1557  CD1 PHE B  42      15.961  16.081  -1.002  1.00 11.97           C  
ATOM   1558  CD2 PHE B  42      15.010  14.276  -2.253  1.00 12.45           C  
ATOM   1559  CE1 PHE B  42      16.519  16.592  -2.169  1.00 16.28           C  
ATOM   1560  CE2 PHE B  42      15.564  14.779  -3.427  1.00 11.91           C  
ATOM   1561  CZ  PHE B  42      16.318  15.936  -3.387  1.00 11.24           C  
ATOM   1562  H   PHE B  42      13.293  13.890   2.351  1.00  0.00           H  
ATOM   1563  N   GLY B  43      11.995  16.237  -0.985  1.00 11.98           N  
ATOM   1564  CA  GLY B  43      10.885  16.302  -1.922  1.00 15.27           C  
ATOM   1565  C   GLY B  43       9.918  17.405  -1.496  1.00 18.12           C  
ATOM   1566  O   GLY B  43       9.154  17.932  -2.311  1.00 17.52           O  
ATOM   1567  H   GLY B  43      12.563  17.025  -0.872  1.00  0.00           H  
ATOM   1568  N   GLN B  44       9.943  17.737  -0.205  1.00 17.18           N  
ATOM   1569  CA  GLN B  44       9.104  18.790   0.361  1.00 19.31           C  
ATOM   1570  C   GLN B  44       9.847  20.115   0.260  1.00 17.56           C  
ATOM   1571  O   GLN B  44      11.061  20.133   0.073  1.00 19.08           O  
ATOM   1572  CB  GLN B  44       8.810  18.500   1.833  1.00 20.00           C  
ATOM   1573  CG  GLN B  44       8.009  17.249   2.062  1.00 30.51           C  
ATOM   1574  CD  GLN B  44       6.626  17.324   1.449  1.00 37.04           C  
ATOM   1575  OE1 GLN B  44       6.290  16.554   0.549  1.00 38.13           O  
ATOM   1576  NE2 GLN B  44       5.812  18.254   1.938  1.00 40.25           N  
ATOM   1577  H   GLN B  44      10.553  17.270   0.404  1.00  0.00           H  
ATOM   1578 HE21 GLN B  44       4.915  18.299   1.545  1.00  0.00           H  
ATOM   1579 HE22 GLN B  44       6.140  18.834   2.654  1.00  0.00           H  
ATOM   1580  N   PRO B  45       9.120  21.244   0.324  1.00 19.06           N  
ATOM   1581  CA  PRO B  45       9.766  22.559   0.244  1.00 20.97           C  
ATOM   1582  C   PRO B  45      10.741  22.699   1.412  1.00 19.57           C  
ATOM   1583  O   PRO B  45      10.419  22.328   2.541  1.00 17.94           O  
ATOM   1584  CB  PRO B  45       8.589  23.522   0.394  1.00 20.97           C  
ATOM   1585  CG  PRO B  45       7.463  22.757  -0.228  1.00 24.11           C  
ATOM   1586  CD  PRO B  45       7.655  21.387   0.363  1.00 21.14           C  
ATOM   1587  N   PRO B  46      11.952  23.210   1.146  1.00 21.17           N  
ATOM   1588  CA  PRO B  46      12.974  23.385   2.184  1.00 22.05           C  
ATOM   1589  C   PRO B  46      12.678  24.507   3.164  1.00 22.94           C  
ATOM   1590  O   PRO B  46      12.151  25.546   2.779  1.00 26.86           O  
ATOM   1591  CB  PRO B  46      14.224  23.700   1.368  1.00 23.33           C  
ATOM   1592  CG  PRO B  46      13.676  24.429   0.186  1.00 22.25           C  
ATOM   1593  CD  PRO B  46      12.465  23.619  -0.174  1.00 20.86           C  
ATOM   1594  N   ILE B  47      12.982  24.288   4.439  1.00 22.16           N  
ATOM   1595  CA  ILE B  47      12.778  25.335   5.433  1.00 22.57           C  
ATOM   1596  C   ILE B  47      14.138  26.003   5.608  1.00 23.21           C  
ATOM   1597  O   ILE B  47      15.177  25.365   5.414  1.00 21.31           O  
ATOM   1598  CB  ILE B  47      12.237  24.795   6.780  1.00 21.86           C  
ATOM   1599  CG1 ILE B  47      13.255  23.892   7.455  1.00 23.18           C  
ATOM   1600  CG2 ILE B  47      10.942  24.029   6.559  1.00 24.04           C  
ATOM   1601  CD1 ILE B  47      12.729  23.273   8.716  1.00 28.64           C  
ATOM   1602  H   ILE B  47      13.363  23.424   4.690  1.00  0.00           H  
ATOM   1603  N   HIS B  48      14.135  27.287   5.939  1.00 26.30           N  
ATOM   1604  CA  HIS B  48      15.380  28.024   6.095  1.00 31.04           C  
ATOM   1605  C   HIS B  48      15.383  28.980   7.289  1.00 27.94           C  
ATOM   1606  O   HIS B  48      14.347  29.514   7.671  1.00 28.30           O  
ATOM   1607  CB  HIS B  48      15.675  28.790   4.797  1.00 40.78           C  
ATOM   1608  CG  HIS B  48      16.668  29.899   4.959  1.00 53.89           C  
ATOM   1609  ND1 HIS B  48      18.031  29.690   4.939  1.00 58.13           N  
ATOM   1610  CD2 HIS B  48      16.495  31.227   5.168  1.00 58.66           C  
ATOM   1611  CE1 HIS B  48      18.654  30.840   5.130  1.00 60.35           C  
ATOM   1612  NE2 HIS B  48      17.745  31.788   5.272  1.00 61.42           N  
ATOM   1613  H   HIS B  48      13.280  27.750   6.100  1.00  0.00           H  
ATOM   1614  HD1 HIS B  48      18.499  28.823   4.819  1.00  0.00           H  
ATOM   1615  HE2 HIS B  48      17.935  32.738   5.427  1.00  0.00           H  
ATOM   1616  N   GLY B  49      16.558  29.207   7.860  1.00 26.75           N  
ATOM   1617  CA  GLY B  49      16.659  30.123   8.981  1.00 26.73           C  
ATOM   1618  C   GLY B  49      16.458  29.459  10.325  1.00 23.69           C  
ATOM   1619  O   GLY B  49      15.647  28.538  10.454  1.00 22.27           O  
ATOM   1620  H   GLY B  49      17.351  28.700   7.579  1.00  0.00           H  
ATOM   1621  N   ARG B  50      17.188  29.950  11.327  1.00 23.65           N  
ATOM   1622  CA  ARG B  50      17.129  29.422  12.694  1.00 23.61           C  
ATOM   1623  C   ARG B  50      15.726  29.269  13.286  1.00 19.19           C  
ATOM   1624  O   ARG B  50      15.406  28.225  13.849  1.00 21.58           O  
ATOM   1625  CB  ARG B  50      17.977  30.282  13.642  1.00 29.34           C  
ATOM   1626  CG  ARG B  50      19.460  30.333  13.315  1.00 32.54           C  
ATOM   1627  CD  ARG B  50      20.103  28.969  13.409  1.00 36.87           C  
ATOM   1628  NE  ARG B  50      21.546  29.076  13.251  1.00 41.53           N  
ATOM   1629  CZ  ARG B  50      22.416  28.962  14.248  1.00 43.43           C  
ATOM   1630  NH1 ARG B  50      21.999  28.721  15.483  1.00 45.53           N  
ATOM   1631  NH2 ARG B  50      23.707  29.140  14.015  1.00 46.47           N  
ATOM   1632  H   ARG B  50      17.824  30.665  11.122  1.00  0.00           H  
ATOM   1633  HE  ARG B  50      21.901  29.237  12.352  1.00  0.00           H  
ATOM   1634 HH11 ARG B  50      21.023  28.625  15.676  1.00  0.00           H  
ATOM   1635 HH12 ARG B  50      22.663  28.634  16.225  1.00  0.00           H  
ATOM   1636 HH21 ARG B  50      24.019  29.355  13.090  1.00  0.00           H  
ATOM   1637 HH22 ARG B  50      24.367  29.050  14.759  1.00  0.00           H  
ATOM   1638  N   GLU B  51      14.893  30.300  13.169  1.00 15.96           N  
ATOM   1639  CA  GLU B  51      13.538  30.239  13.724  1.00 17.32           C  
ATOM   1640  C   GLU B  51      12.715  29.083  13.146  1.00 14.04           C  
ATOM   1641  O   GLU B  51      12.087  28.329  13.887  1.00 12.34           O  
ATOM   1642  CB  GLU B  51      12.785  31.560  13.520  1.00 20.29           C  
ATOM   1643  CG  GLU B  51      11.401  31.558  14.185  1.00 26.75           C  
ATOM   1644  CD  GLU B  51      10.515  32.743  13.812  1.00 30.02           C  
ATOM   1645  OE1 GLU B  51      10.748  33.393  12.766  1.00 32.61           O  
ATOM   1646  OE2 GLU B  51       9.556  33.005  14.572  1.00 33.10           O  
ATOM   1647  H   GLU B  51      15.222  31.064  12.702  1.00  0.00           H  
ATOM   1648  N   GLN B  52      12.716  28.949  11.825  1.00 12.90           N  
ATOM   1649  CA  GLN B  52      11.969  27.878  11.174  1.00 13.13           C  
ATOM   1650  C   GLN B  52      12.556  26.522  11.519  1.00 11.60           C  
ATOM   1651  O   GLN B  52      11.817  25.567  11.764  1.00 12.85           O  
ATOM   1652  CB  GLN B  52      11.970  28.063   9.662  1.00 16.97           C  
ATOM   1653  CG  GLN B  52      11.132  29.229   9.178  1.00 26.88           C  
ATOM   1654  CD  GLN B  52      11.136  29.367   7.660  1.00 35.77           C  
ATOM   1655  OE1 GLN B  52      11.187  28.372   6.923  1.00 38.65           O  
ATOM   1656  NE2 GLN B  52      11.084  30.608   7.182  1.00 39.80           N  
ATOM   1657  H   GLN B  52      13.239  29.562  11.270  1.00  0.00           H  
ATOM   1658 HE21 GLN B  52      11.072  30.712   6.211  1.00  0.00           H  
ATOM   1659 HE22 GLN B  52      11.059  31.349   7.815  1.00  0.00           H  
ATOM   1660  N   ILE B  53      13.884  26.442  11.573  1.00 10.15           N  
ATOM   1661  CA  ILE B  53      14.550  25.185  11.888  1.00  9.74           C  
ATOM   1662  C   ILE B  53      14.304  24.786  13.331  1.00  8.61           C  
ATOM   1663  O   ILE B  53      14.103  23.608  13.624  1.00 10.17           O  
ATOM   1664  CB  ILE B  53      16.058  25.234  11.561  1.00 10.42           C  
ATOM   1665  CG1 ILE B  53      16.240  25.423  10.055  1.00 13.09           C  
ATOM   1666  CG2 ILE B  53      16.745  23.950  12.003  1.00 10.10           C  
ATOM   1667  CD1 ILE B  53      17.670  25.535   9.607  1.00 15.40           C  
ATOM   1668  H   ILE B  53      14.436  27.228  11.383  1.00  0.00           H  
ATOM   1669  N   ALA B  54      14.258  25.770  14.224  1.00  9.33           N  
ATOM   1670  CA  ALA B  54      13.996  25.499  15.634  1.00 10.06           C  
ATOM   1671  C   ALA B  54      12.553  24.999  15.779  1.00 10.53           C  
ATOM   1672  O   ALA B  54      12.291  24.032  16.502  1.00  8.56           O  
ATOM   1673  CB  ALA B  54      14.213  26.767  16.468  1.00 10.42           C  
ATOM   1674  H   ALA B  54      14.401  26.688  13.936  1.00  0.00           H  
ATOM   1675  N   ALA B  55      11.630  25.642  15.061  1.00 10.24           N  
ATOM   1676  CA  ALA B  55      10.215  25.257  15.088  1.00  9.91           C  
ATOM   1677  C   ALA B  55      10.060  23.816  14.610  1.00  9.49           C  
ATOM   1678  O   ALA B  55       9.350  23.018  15.230  1.00 12.12           O  
ATOM   1679  CB  ALA B  55       9.399  26.193  14.217  1.00  6.98           C  
ATOM   1680  H   ALA B  55      11.909  26.408  14.516  1.00  0.00           H  
ATOM   1681  N   PHE B  56      10.756  23.480  13.525  1.00  9.27           N  
ATOM   1682  CA  PHE B  56      10.735  22.134  12.967  1.00  7.48           C  
ATOM   1683  C   PHE B  56      11.077  21.095  14.036  1.00 10.34           C  
ATOM   1684  O   PHE B  56      10.329  20.137  14.243  1.00 12.91           O  
ATOM   1685  CB  PHE B  56      11.732  22.044  11.802  1.00 11.26           C  
ATOM   1686  CG  PHE B  56      11.988  20.634  11.303  1.00 13.48           C  
ATOM   1687  CD1 PHE B  56      11.046  19.970  10.511  1.00 12.66           C  
ATOM   1688  CD2 PHE B  56      13.173  19.974  11.625  1.00 12.68           C  
ATOM   1689  CE1 PHE B  56      11.286  18.665  10.052  1.00 12.75           C  
ATOM   1690  CE2 PHE B  56      13.418  18.672  11.170  1.00 14.46           C  
ATOM   1691  CZ  PHE B  56      12.475  18.021  10.387  1.00 11.01           C  
ATOM   1692  H   PHE B  56      11.303  24.169  13.089  1.00  0.00           H  
ATOM   1693  N   TYR B  57      12.201  21.285  14.721  1.00 11.65           N  
ATOM   1694  CA  TYR B  57      12.631  20.348  15.755  1.00 11.54           C  
ATOM   1695  C   TYR B  57      11.747  20.334  16.994  1.00 14.16           C  
ATOM   1696  O   TYR B  57      11.519  19.280  17.593  1.00 12.73           O  
ATOM   1697  CB  TYR B  57      14.094  20.601  16.144  1.00 11.76           C  
ATOM   1698  CG  TYR B  57      15.071  20.089  15.109  1.00  9.67           C  
ATOM   1699  CD1 TYR B  57      15.355  18.733  15.018  1.00  9.61           C  
ATOM   1700  CD2 TYR B  57      15.660  20.955  14.180  1.00  9.34           C  
ATOM   1701  CE1 TYR B  57      16.198  18.245  14.022  1.00 10.13           C  
ATOM   1702  CE2 TYR B  57      16.510  20.475  13.178  1.00  8.45           C  
ATOM   1703  CZ  TYR B  57      16.768  19.120  13.108  1.00  8.14           C  
ATOM   1704  OH  TYR B  57      17.570  18.623  12.108  1.00  9.33           O  
ATOM   1705  H   TYR B  57      12.767  22.063  14.522  1.00  0.00           H  
ATOM   1706  HH  TYR B  57      17.265  17.742  11.821  1.00  0.00           H  
ATOM   1707  N   ARG B  58      11.253  21.501  17.385  1.00 14.21           N  
ATOM   1708  CA  ARG B  58      10.385  21.590  18.549  1.00 19.92           C  
ATOM   1709  C   ARG B  58       9.106  20.809  18.265  1.00 19.21           C  
ATOM   1710  O   ARG B  58       8.621  20.059  19.108  1.00 18.34           O  
ATOM   1711  CB  ARG B  58      10.059  23.050  18.835  1.00 22.87           C  
ATOM   1712  CG  ARG B  58       9.295  23.292  20.116  1.00 31.53           C  
ATOM   1713  CD  ARG B  58       9.943  24.427  20.904  1.00 40.11           C  
ATOM   1714  NE  ARG B  58      10.450  25.492  20.035  1.00 48.29           N  
ATOM   1715  CZ  ARG B  58      11.660  26.039  20.143  1.00 51.28           C  
ATOM   1716  NH1 ARG B  58      12.503  25.630  21.086  1.00 54.55           N  
ATOM   1717  NH2 ARG B  58      12.035  26.996  19.304  1.00 52.11           N  
ATOM   1718  H   ARG B  58      11.473  22.309  16.879  1.00  0.00           H  
ATOM   1719  HE  ARG B  58       9.861  25.823  19.326  1.00  0.00           H  
ATOM   1720 HH11 ARG B  58      12.230  24.907  21.720  1.00  0.00           H  
ATOM   1721 HH12 ARG B  58      13.409  26.047  21.164  1.00  0.00           H  
ATOM   1722 HH21 ARG B  58      11.408  27.303  18.588  1.00  0.00           H  
ATOM   1723 HH22 ARG B  58      12.942  27.408  19.385  1.00  0.00           H  
ATOM   1724  N   GLN B  59       8.606  20.958  17.043  1.00 19.41           N  
ATOM   1725  CA  GLN B  59       7.397  20.285  16.604  1.00 20.56           C  
ATOM   1726  C   GLN B  59       7.566  18.775  16.515  1.00 20.10           C  
ATOM   1727  O   GLN B  59       6.684  18.030  16.919  1.00 19.25           O  
ATOM   1728  CB  GLN B  59       6.970  20.835  15.248  1.00 24.87           C  
ATOM   1729  CG  GLN B  59       5.485  21.059  15.139  1.00 36.22           C  
ATOM   1730  CD  GLN B  59       4.952  21.976  16.228  1.00 41.82           C  
ATOM   1731  OE1 GLN B  59       5.709  22.683  16.902  1.00 44.98           O  
ATOM   1732  NE2 GLN B  59       3.635  21.974  16.400  1.00 46.98           N  
ATOM   1733  H   GLN B  59       9.055  21.557  16.419  1.00  0.00           H  
ATOM   1734 HE21 GLN B  59       3.304  22.560  17.110  1.00  0.00           H  
ATOM   1735 HE22 GLN B  59       3.077  21.411  15.834  1.00  0.00           H  
ATOM   1736  N   GLY B  60       8.702  18.332  15.984  1.00 19.56           N  
ATOM   1737  CA  GLY B  60       8.956  16.912  15.846  1.00 18.12           C  
ATOM   1738  C   GLY B  60       9.381  16.186  17.107  1.00 20.31           C  
ATOM   1739  O   GLY B  60       8.987  15.038  17.319  1.00 22.70           O  
ATOM   1740  H   GLY B  60       9.367  18.982  15.682  1.00  0.00           H  
ATOM   1741  N   LEU B  61      10.193  16.831  17.941  1.00 19.40           N  
ATOM   1742  CA  LEU B  61      10.672  16.205  19.171  1.00 20.89           C  
ATOM   1743  C   LEU B  61       9.834  16.562  20.396  1.00 23.19           C  
ATOM   1744  O   LEU B  61       9.530  17.729  20.642  1.00 28.71           O  
ATOM   1745  CB  LEU B  61      12.145  16.552  19.411  1.00 16.30           C  
ATOM   1746  CG  LEU B  61      13.098  16.187  18.266  1.00 17.45           C  
ATOM   1747  CD1 LEU B  61      14.527  16.575  18.620  1.00 13.84           C  
ATOM   1748  CD2 LEU B  61      12.996  14.705  17.965  1.00 13.25           C  
ATOM   1749  H   LEU B  61      10.432  17.761  17.771  1.00  0.00           H  
ATOM   1750  N   GLY B  62      10.220  15.901  21.453  1.00 38.53           N  
ATOM   1751  CA  GLY B  62      10.556  15.906  22.867  1.00 19.95           C  
ATOM   1752  C   GLY B  62       9.617  15.139  23.779  1.00 31.84           C  
ATOM   1753  O   GLY B  62      10.064  14.528  24.753  1.00 22.22           O  
ATOM   1754  H   GLY B  62      10.280  14.994  21.189  1.00  0.00           H  
ATOM   1755  N   GLY B  63       8.323  15.179  23.474  1.00 33.85           N  
ATOM   1756  CA  GLY B  63       7.335  14.492  24.290  1.00 64.37           C  
ATOM   1757  C   GLY B  63       7.364  12.977  24.202  1.00 57.78           C  
ATOM   1758  O   GLY B  63       8.363  12.338  24.534  1.00 28.53           O  
ATOM   1759  H   GLY B  63       8.030  15.680  22.684  1.00  0.00           H  
ATOM   1760  N   GLY B  64       6.247  12.396  23.776  1.00 67.88           N  
ATOM   1761  CA  GLY B  64       6.162  10.952  23.658  1.00 54.89           C  
ATOM   1762  C   GLY B  64       7.091  10.418  22.585  1.00 43.41           C  
ATOM   1763  O   GLY B  64       7.496  11.153  21.682  1.00 32.24           O  
ATOM   1764  H   GLY B  64       5.473  12.948  23.539  1.00  0.00           H  
ATOM   1765  N   LYS B  65       8.179  10.884  23.103  1.00 36.77           N  
ATOM   1766  CA  LYS B  65       9.359  10.065  23.367  1.00 39.00           C  
ATOM   1767  C   LYS B  65      10.032   9.571  22.084  1.00 35.32           C  
ATOM   1768  O   LYS B  65       9.715   8.489  21.584  1.00 36.92           O  
ATOM   1769  CB  LYS B  65       8.999   8.864  24.246  1.00 42.36           C  
ATOM   1770  CG  LYS B  65       8.689   9.198  25.692  1.00 48.61           C  
ATOM   1771  CD  LYS B  65       7.328   9.851  25.854  1.00 53.40           C  
ATOM   1772  CE  LYS B  65       6.983   9.997  27.326  1.00 55.41           C  
ATOM   1773  NZ  LYS B  65       6.969   8.670  28.011  1.00 57.58           N  
ATOM   1774  H   LYS B  65       8.181  11.812  23.413  1.00  0.00           H  
ATOM   1775  HZ1 LYS B  65       6.266   8.056  27.550  1.00  0.00           H  
ATOM   1776  HZ2 LYS B  65       7.908   8.230  27.939  1.00  0.00           H  
ATOM   1777  HZ3 LYS B  65       6.719   8.788  29.014  1.00  0.00           H  
ATOM   1778  N   VAL B  66      10.957  10.368  21.560  1.00 29.88           N  
ATOM   1779  CA  VAL B  66      11.678  10.009  20.345  1.00 25.96           C  
ATOM   1780  C   VAL B  66      13.059   9.473  20.688  1.00 25.00           C  
ATOM   1781  O   VAL B  66      13.744   9.999  21.568  1.00 24.23           O  
ATOM   1782  CB  VAL B  66      11.847  11.228  19.391  1.00 24.94           C  
ATOM   1783  CG1 VAL B  66      12.724  10.861  18.197  1.00 23.78           C  
ATOM   1784  CG2 VAL B  66      10.499  11.712  18.904  1.00 24.53           C  
ATOM   1785  H   VAL B  66      11.194  11.206  21.997  1.00  0.00           H  
ATOM   1786  N   ARG B  67      13.429   8.372  20.048  1.00 23.61           N  
ATOM   1787  CA  ARG B  67      14.748   7.790  20.231  1.00 22.32           C  
ATOM   1788  C   ARG B  67      15.298   7.489  18.838  1.00 20.82           C  
ATOM   1789  O   ARG B  67      14.564   7.052  17.944  1.00 18.69           O  
ATOM   1790  CB  ARG B  67      14.718   6.549  21.129  1.00 28.09           C  
ATOM   1791  CG  ARG B  67      13.596   5.575  20.869  1.00 40.63           C  
ATOM   1792  CD  ARG B  67      13.677   4.377  21.815  1.00 48.65           C  
ATOM   1793  NE  ARG B  67      14.804   3.497  21.505  1.00 56.17           N  
ATOM   1794  CZ  ARG B  67      15.006   2.305  22.066  1.00 60.20           C  
ATOM   1795  NH1 ARG B  67      14.161   1.839  22.980  1.00 64.42           N  
ATOM   1796  NH2 ARG B  67      16.044   1.566  21.697  1.00 61.03           N  
ATOM   1797  H   ARG B  67      12.797   7.948  19.423  1.00  0.00           H  
ATOM   1798  HE  ARG B  67      15.455   3.797  20.837  1.00  0.00           H  
ATOM   1799 HH11 ARG B  67      13.366   2.378  23.257  1.00  0.00           H  
ATOM   1800 HH12 ARG B  67      14.325   0.943  23.393  1.00  0.00           H  
ATOM   1801 HH21 ARG B  67      16.676   1.899  20.999  1.00  0.00           H  
ATOM   1802 HH22 ARG B  67      16.193   0.671  22.120  1.00  0.00           H  
ATOM   1803  N   ALA B  68      16.559   7.834  18.620  1.00 16.65           N  
ATOM   1804  CA  ALA B  68      17.185   7.617  17.324  1.00 13.92           C  
ATOM   1805  C   ALA B  68      18.510   6.903  17.521  1.00 14.34           C  
ATOM   1806  O   ALA B  68      19.206   7.122  18.517  1.00 15.42           O  
ATOM   1807  CB  ALA B  68      17.385   8.953  16.607  1.00  8.11           C  
ATOM   1808  H   ALA B  68      17.108   8.232  19.322  1.00  0.00           H  
ATOM   1809  N   CYS B  69      18.834   6.017  16.591  1.00 13.39           N  
ATOM   1810  CA  CYS B  69      20.070   5.260  16.668  1.00 16.83           C  
ATOM   1811  C   CYS B  69      20.669   4.995  15.298  1.00 14.95           C  
ATOM   1812  O   CYS B  69      19.951   4.631  14.358  1.00 15.16           O  
ATOM   1813  CB  CYS B  69      19.826   3.927  17.394  1.00 19.53           C  
ATOM   1814  SG  CYS B  69      18.233   3.140  17.031  1.00 36.21           S  
ATOM   1815  H   CYS B  69      18.228   5.843  15.834  1.00  0.00           H  
ATOM   1816  N   LEU B  70      21.977   5.213  15.177  1.00 11.29           N  
ATOM   1817  CA  LEU B  70      22.677   4.957  13.934  1.00  8.75           C  
ATOM   1818  C   LEU B  70      22.543   3.476  13.679  1.00  8.75           C  
ATOM   1819  O   LEU B  70      22.704   2.675  14.587  1.00 10.88           O  
ATOM   1820  CB  LEU B  70      24.158   5.287  14.072  1.00  8.70           C  
ATOM   1821  CG  LEU B  70      24.592   6.697  13.693  1.00 10.26           C  
ATOM   1822  CD1 LEU B  70      26.071   6.876  14.017  1.00 12.81           C  
ATOM   1823  CD2 LEU B  70      24.354   6.917  12.210  1.00 10.22           C  
ATOM   1824  H   LEU B  70      22.488   5.525  15.946  1.00  0.00           H  
ATOM   1825  N   THR B  71      22.205   3.104  12.457  1.00  9.17           N  
ATOM   1826  CA  THR B  71      22.066   1.690  12.151  1.00 11.68           C  
ATOM   1827  C   THR B  71      23.235   1.196  11.295  1.00  9.10           C  
ATOM   1828  O   THR B  71      23.322   0.015  10.967  1.00 11.57           O  
ATOM   1829  CB  THR B  71      20.716   1.406  11.479  1.00 12.35           C  
ATOM   1830  OG1 THR B  71      20.522   2.316  10.389  1.00 13.17           O  
ATOM   1831  CG2 THR B  71      19.586   1.572  12.493  1.00 12.49           C  
ATOM   1832  H   THR B  71      22.076   3.766  11.753  1.00  0.00           H  
ATOM   1833  HG1 THR B  71      20.531   3.213  10.718  1.00  0.00           H  
ATOM   1834  N   GLY B  72      24.149   2.112  10.986  1.00 10.61           N  
ATOM   1835  CA  GLY B  72      25.316   1.779  10.196  1.00  9.13           C  
ATOM   1836  C   GLY B  72      26.336   2.901  10.282  1.00 12.33           C  
ATOM   1837  O   GLY B  72      26.042   3.954  10.858  1.00  9.96           O  
ATOM   1838  H   GLY B  72      24.033   3.051  11.296  1.00  0.00           H  
ATOM   1839  N   PRO B  73      27.536   2.708   9.708  1.00 11.99           N  
ATOM   1840  CA  PRO B  73      28.623   3.695   9.707  1.00 11.32           C  
ATOM   1841  C   PRO B  73      28.266   4.949   8.936  1.00  7.87           C  
ATOM   1842  O   PRO B  73      27.548   4.891   7.929  1.00  8.02           O  
ATOM   1843  CB  PRO B  73      29.754   2.957   8.972  1.00 11.29           C  
ATOM   1844  CG  PRO B  73      29.453   1.522   9.158  1.00 12.70           C  
ATOM   1845  CD  PRO B  73      27.963   1.469   9.033  1.00 11.68           C  
ATOM   1846  N   VAL B  74      28.774   6.082   9.405  1.00  7.42           N  
ATOM   1847  CA  VAL B  74      28.549   7.347   8.719  1.00  8.34           C  
ATOM   1848  C   VAL B  74      29.509   7.300   7.524  1.00 11.10           C  
ATOM   1849  O   VAL B  74      30.686   6.934   7.662  1.00  7.24           O  
ATOM   1850  CB  VAL B  74      28.913   8.574   9.613  1.00  6.65           C  
ATOM   1851  CG1 VAL B  74      28.861   9.874   8.793  1.00  6.00           C  
ATOM   1852  CG2 VAL B  74      27.979   8.670  10.811  1.00  6.77           C  
ATOM   1853  H   VAL B  74      29.396   6.084  10.159  1.00  0.00           H  
ATOM   1854  N   ARG B  75      28.985   7.585   6.344  1.00 11.39           N  
ATOM   1855  CA  ARG B  75      29.807   7.616   5.133  1.00 10.60           C  
ATOM   1856  C   ARG B  75      30.231   9.066   4.961  1.00 10.56           C  
ATOM   1857  O   ARG B  75      29.387   9.946   4.803  1.00 11.68           O  
ATOM   1858  CB  ARG B  75      29.007   7.134   3.920  1.00  6.79           C  
ATOM   1859  CG  ARG B  75      28.985   5.626   3.747  1.00  6.00           C  
ATOM   1860  CD  ARG B  75      28.189   4.899   4.805  1.00  6.00           C  
ATOM   1861  NE  ARG B  75      27.907   3.544   4.348  1.00  6.95           N  
ATOM   1862  CZ  ARG B  75      27.146   2.651   4.976  1.00  6.35           C  
ATOM   1863  NH1 ARG B  75      26.571   2.947   6.137  1.00  6.00           N  
ATOM   1864  NH2 ARG B  75      26.916   1.476   4.413  1.00  6.00           N  
ATOM   1865  H   ARG B  75      28.026   7.762   6.335  1.00  0.00           H  
ATOM   1866  HE  ARG B  75      28.311   3.255   3.511  1.00  0.00           H  
ATOM   1867 HH11 ARG B  75      26.707   3.851   6.539  1.00  0.00           H  
ATOM   1868 HH12 ARG B  75      25.998   2.271   6.602  1.00  0.00           H  
ATOM   1869 HH21 ARG B  75      27.309   1.249   3.522  1.00  0.00           H  
ATOM   1870 HH22 ARG B  75      26.348   0.805   4.883  1.00  0.00           H  
ATOM   1871  N   ALA B  76      31.531   9.330   5.016  1.00 11.01           N  
ATOM   1872  CA  ALA B  76      32.000  10.700   4.903  1.00  9.40           C  
ATOM   1873  C   ALA B  76      32.878  10.918   3.694  1.00 10.22           C  
ATOM   1874  O   ALA B  76      33.587  10.008   3.270  1.00 11.25           O  
ATOM   1875  CB  ALA B  76      32.732  11.096   6.170  1.00 10.10           C  
ATOM   1876  H   ALA B  76      32.211   8.614   5.116  1.00  0.00           H  
ATOM   1877  N   SER B  77      32.786  12.102   3.101  1.00 10.19           N  
ATOM   1878  CA  SER B  77      33.597  12.429   1.937  1.00 13.12           C  
ATOM   1879  C   SER B  77      34.682  13.409   2.370  1.00 14.55           C  
ATOM   1880  O   SER B  77      34.793  13.742   3.551  1.00 14.09           O  
ATOM   1881  CB  SER B  77      32.725  13.037   0.843  1.00 13.46           C  
ATOM   1882  OG  SER B  77      32.249  14.317   1.222  1.00 20.77           O  
ATOM   1883  H   SER B  77      32.213  12.804   3.461  1.00  0.00           H  
ATOM   1884  HG  SER B  77      31.440  14.446   0.710  1.00  0.00           H  
ATOM   1885  N   HIS B  78      35.498  13.853   1.422  1.00 14.50           N  
ATOM   1886  CA  HIS B  78      36.574  14.796   1.725  1.00 13.88           C  
ATOM   1887  C   HIS B  78      36.190  16.249   1.498  1.00 15.05           C  
ATOM   1888  O   HIS B  78      36.994  17.147   1.733  1.00 18.58           O  
ATOM   1889  CB  HIS B  78      37.817  14.468   0.898  1.00 12.54           C  
ATOM   1890  CG  HIS B  78      38.457  13.174   1.276  1.00  9.75           C  
ATOM   1891  ND1 HIS B  78      38.880  12.899   2.557  1.00 14.39           N  
ATOM   1892  CD2 HIS B  78      38.729  12.070   0.546  1.00 14.12           C  
ATOM   1893  CE1 HIS B  78      39.388  11.683   2.603  1.00 13.51           C  
ATOM   1894  NE2 HIS B  78      39.311  11.158   1.392  1.00 12.49           N  
ATOM   1895  H   HIS B  78      35.411  13.504   0.503  1.00  0.00           H  
ATOM   1896  HD1 HIS B  78      38.845  13.489   3.325  1.00  0.00           H  
ATOM   1897  HE2 HIS B  78      39.657  10.314   1.059  1.00  0.00           H  
ATOM   1898  N   ASN B  79      34.971  16.491   1.032  1.00 12.57           N  
ATOM   1899  CA  ASN B  79      34.542  17.858   0.790  1.00 12.66           C  
ATOM   1900  C   ASN B  79      33.518  18.360   1.814  1.00 12.84           C  
ATOM   1901  O   ASN B  79      32.709  19.245   1.533  1.00 12.68           O  
ATOM   1902  CB  ASN B  79      34.084  18.054  -0.668  1.00 17.25           C  
ATOM   1903  CG  ASN B  79      32.709  17.469  -0.961  1.00 18.16           C  
ATOM   1904  OD1 ASN B  79      31.950  18.044  -1.735  1.00 25.56           O  
ATOM   1905  ND2 ASN B  79      32.407  16.311  -0.399  1.00 15.57           N  
ATOM   1906  H   ASN B  79      34.381  15.726   0.906  1.00  0.00           H  
ATOM   1907 HD21 ASN B  79      31.500  16.041  -0.657  1.00  0.00           H  
ATOM   1908 HD22 ASN B  79      33.001  15.809   0.180  1.00  0.00           H  
ATOM   1909  N   GLY B  80      33.604  17.808   3.023  1.00 12.32           N  
ATOM   1910  CA  GLY B  80      32.730  18.206   4.108  1.00 12.47           C  
ATOM   1911  C   GLY B  80      31.292  17.753   4.002  1.00 14.46           C  
ATOM   1912  O   GLY B  80      30.391  18.450   4.466  1.00 12.87           O  
ATOM   1913  H   GLY B  80      34.261  17.105   3.194  1.00  0.00           H  
ATOM   1914  N   CYS B  81      31.081  16.576   3.435  1.00 11.31           N  
ATOM   1915  CA  CYS B  81      29.748  16.041   3.287  1.00  9.13           C  
ATOM   1916  C   CYS B  81      29.727  14.624   3.821  1.00 10.66           C  
ATOM   1917  O   CYS B  81      30.760  13.947   3.849  1.00 10.38           O  
ATOM   1918  CB  CYS B  81      29.338  16.038   1.815  1.00 11.36           C  
ATOM   1919  SG  CYS B  81      29.168  17.655   1.065  1.00 15.20           S  
ATOM   1920  H   CYS B  81      31.830  16.013   3.160  1.00  0.00           H  
ATOM   1921  N   GLY B  82      28.547  14.175   4.239  1.00  6.78           N  
ATOM   1922  CA  GLY B  82      28.417  12.831   4.758  1.00  7.63           C  
ATOM   1923  C   GLY B  82      27.004  12.312   4.606  1.00  6.97           C  
ATOM   1924  O   GLY B  82      26.087  13.076   4.293  1.00  8.34           O  
ATOM   1925  H   GLY B  82      27.743  14.742   4.207  1.00  0.00           H  
ATOM   1926  N   ALA B  83      26.829  11.015   4.835  1.00  6.00           N  
ATOM   1927  CA  ALA B  83      25.522  10.384   4.734  1.00  6.00           C  
ATOM   1928  C   ALA B  83      25.473   9.291   5.782  1.00  6.00           C  
ATOM   1929  O   ALA B  83      26.465   8.604   6.017  1.00  6.00           O  
ATOM   1930  CB  ALA B  83      25.310   9.803   3.337  1.00  7.39           C  
ATOM   1931  H   ALA B  83      27.574  10.437   5.097  1.00  0.00           H  
ATOM   1932  N   MET B  84      24.319   9.124   6.414  1.00  6.25           N  
ATOM   1933  CA  MET B  84      24.190   8.123   7.463  1.00  6.63           C  
ATOM   1934  C   MET B  84      22.813   7.495   7.531  1.00  6.00           C  
ATOM   1935  O   MET B  84      21.811   8.137   7.225  1.00  6.00           O  
ATOM   1936  CB  MET B  84      24.499   8.753   8.826  1.00  7.24           C  
ATOM   1937  CG  MET B  84      23.522   9.856   9.223  1.00 10.02           C  
ATOM   1938  SD  MET B  84      23.843  10.573  10.841  1.00 12.26           S  
ATOM   1939  CE  MET B  84      23.006  12.130  10.666  1.00  6.00           C  
ATOM   1940  H   MET B  84      23.536   9.677   6.174  1.00  0.00           H  
ATOM   1941  N   PRO B  85      22.763   6.200   7.871  1.00  8.04           N  
ATOM   1942  CA  PRO B  85      21.521   5.440   7.999  1.00  9.41           C  
ATOM   1943  C   PRO B  85      21.150   5.390   9.488  1.00  9.02           C  
ATOM   1944  O   PRO B  85      22.024   5.262  10.349  1.00  9.70           O  
ATOM   1945  CB  PRO B  85      21.929   4.065   7.480  1.00  8.54           C  
ATOM   1946  CG  PRO B  85      23.321   3.914   8.032  1.00  6.16           C  
ATOM   1947  CD  PRO B  85      23.937   5.304   7.931  1.00  6.00           C  
ATOM   1948  N   PHE B  86      19.875   5.542   9.810  1.00  7.35           N  
ATOM   1949  CA  PHE B  86      19.471   5.479  11.207  1.00  7.60           C  
ATOM   1950  C   PHE B  86      18.002   5.158  11.342  1.00  8.90           C  
ATOM   1951  O   PHE B  86      17.248   5.242  10.373  1.00  8.27           O  
ATOM   1952  CB  PHE B  86      19.817   6.780  11.954  1.00  7.58           C  
ATOM   1953  CG  PHE B  86      19.113   8.005  11.436  1.00  9.00           C  
ATOM   1954  CD1 PHE B  86      19.581   8.670  10.305  1.00  6.00           C  
ATOM   1955  CD2 PHE B  86      18.007   8.520  12.105  1.00  8.90           C  
ATOM   1956  CE1 PHE B  86      18.965   9.826   9.849  1.00  6.09           C  
ATOM   1957  CE2 PHE B  86      17.382   9.681  11.655  1.00  9.47           C  
ATOM   1958  CZ  PHE B  86      17.861  10.333  10.526  1.00  7.65           C  
ATOM   1959  H   PHE B  86      19.193   5.695   9.111  1.00  0.00           H  
ATOM   1960  N   ARG B  87      17.625   4.685  12.520  1.00  9.90           N  
ATOM   1961  CA  ARG B  87      16.235   4.365  12.798  1.00 11.45           C  
ATOM   1962  C   ARG B  87      15.696   5.298  13.882  1.00 11.53           C  
ATOM   1963  O   ARG B  87      16.414   5.675  14.815  1.00 11.73           O  
ATOM   1964  CB  ARG B  87      16.073   2.907  13.231  1.00 13.80           C  
ATOM   1965  CG  ARG B  87      14.757   2.646  13.958  1.00 24.15           C  
ATOM   1966  CD  ARG B  87      14.433   1.174  14.088  1.00 31.47           C  
ATOM   1967  NE  ARG B  87      13.898   0.646  12.838  1.00 38.99           N  
ATOM   1968  CZ  ARG B  87      12.843  -0.156  12.753  1.00 41.06           C  
ATOM   1969  NH1 ARG B  87      12.190  -0.533  13.843  1.00 42.72           N  
ATOM   1970  NH2 ARG B  87      12.444  -0.586  11.566  1.00 46.38           N  
ATOM   1971  H   ARG B  87      18.282   4.567  13.239  1.00  0.00           H  
ATOM   1972  HE  ARG B  87      14.338   0.899  11.999  1.00  0.00           H  
ATOM   1973 HH11 ARG B  87      12.466  -0.210  14.747  1.00  0.00           H  
ATOM   1974 HH12 ARG B  87      11.396  -1.135  13.762  1.00  0.00           H  
ATOM   1975 HH21 ARG B  87      12.952  -0.305  10.752  1.00  0.00           H  
ATOM   1976 HH22 ARG B  87      11.648  -1.186  11.494  1.00  0.00           H  
ATOM   1977  N   VAL B  88      14.446   5.710  13.717  1.00 11.33           N  
ATOM   1978  CA  VAL B  88      13.788   6.585  14.673  1.00 11.53           C  
ATOM   1979  C   VAL B  88      12.587   5.833  15.227  1.00 13.14           C  
ATOM   1980  O   VAL B  88      11.867   5.159  14.488  1.00 12.68           O  
ATOM   1981  CB  VAL B  88      13.304   7.899  14.006  1.00 12.89           C  
ATOM   1982  CG1 VAL B  88      12.579   8.768  15.027  1.00 17.96           C  
ATOM   1983  CG2 VAL B  88      14.480   8.661  13.414  1.00 16.04           C  
ATOM   1984  H   VAL B  88      13.940   5.411  12.935  1.00  0.00           H  
ATOM   1985  N   GLU B  89      12.416   5.883  16.538  1.00 11.50           N  
ATOM   1986  CA  GLU B  89      11.290   5.231  17.174  1.00 14.31           C  
ATOM   1987  C   GLU B  89      10.525   6.316  17.891  1.00 16.39           C  
ATOM   1988  O   GLU B  89      11.103   7.106  18.642  1.00 14.73           O  
ATOM   1989  CB  GLU B  89      11.749   4.188  18.189  1.00 15.63           C  
ATOM   1990  CG  GLU B  89      12.229   2.885  17.595  1.00 22.41           C  
ATOM   1991  CD  GLU B  89      12.638   1.877  18.657  1.00 28.47           C  
ATOM   1992  OE1 GLU B  89      12.109   1.932  19.790  1.00 36.40           O  
ATOM   1993  OE2 GLU B  89      13.494   1.023  18.360  1.00 35.07           O  
ATOM   1994  H   GLU B  89      13.041   6.373  17.105  1.00  0.00           H  
ATOM   1995  N   MET B  90       9.233   6.393  17.619  1.00 17.68           N  
ATOM   1996  CA  MET B  90       8.405   7.388  18.267  1.00 18.11           C  
ATOM   1997  C   MET B  90       7.012   6.831  18.504  1.00 19.06           C  
ATOM   1998  O   MET B  90       6.761   5.638  18.304  1.00 15.84           O  
ATOM   1999  CB  MET B  90       8.370   8.708  17.474  1.00 20.06           C  
ATOM   2000  CG  MET B  90       7.645   8.679  16.143  1.00 22.56           C  
ATOM   2001  SD  MET B  90       8.763   8.712  14.744  1.00 33.58           S  
ATOM   2002  CE  MET B  90       8.906   6.999  14.438  1.00 16.84           C  
ATOM   2003  H   MET B  90       8.813   5.722  17.042  1.00  0.00           H  
ATOM   2004  N   VAL B  91       6.113   7.698  18.944  1.00 20.33           N  
ATOM   2005  CA  VAL B  91       4.749   7.306  19.241  1.00 21.32           C  
ATOM   2006  C   VAL B  91       3.746   8.177  18.487  1.00 19.48           C  
ATOM   2007  O   VAL B  91       4.039   9.324  18.128  1.00 21.24           O  
ATOM   2008  CB  VAL B  91       4.511   7.390  20.773  1.00 21.48           C  
ATOM   2009  CG1 VAL B  91       3.071   7.192  21.103  1.00 26.82           C  
ATOM   2010  CG2 VAL B  91       5.348   6.340  21.492  1.00 24.46           C  
ATOM   2011  H   VAL B  91       6.364   8.640  19.070  1.00  0.00           H  
ATOM   2012  N   TRP B  92       2.589   7.595  18.192  1.00 18.82           N  
ATOM   2013  CA  TRP B  92       1.499   8.293  17.519  1.00 14.97           C  
ATOM   2014  C   TRP B  92       0.259   7.881  18.308  1.00 15.95           C  
ATOM   2015  O   TRP B  92      -0.122   6.710  18.296  1.00 13.55           O  
ATOM   2016  CB  TRP B  92       1.380   7.838  16.065  1.00 14.37           C  
ATOM   2017  CG  TRP B  92       0.498   8.711  15.215  1.00 13.90           C  
ATOM   2018  CD1 TRP B  92      -0.160   9.850  15.599  1.00 13.78           C  
ATOM   2019  CD2 TRP B  92       0.216   8.535  13.823  1.00 15.75           C  
ATOM   2020  NE1 TRP B  92      -0.829  10.393  14.526  1.00 16.22           N  
ATOM   2021  CE2 TRP B  92      -0.614   9.609  13.424  1.00 14.55           C  
ATOM   2022  CE3 TRP B  92       0.593   7.575  12.868  1.00 13.14           C  
ATOM   2023  CZ2 TRP B  92      -1.079   9.747  12.111  1.00 16.63           C  
ATOM   2024  CZ3 TRP B  92       0.130   7.714  11.565  1.00 11.60           C  
ATOM   2025  CH2 TRP B  92      -0.696   8.794  11.197  1.00 11.31           C  
ATOM   2026  H   TRP B  92       2.460   6.650  18.403  1.00  0.00           H  
ATOM   2027  HE1 TRP B  92      -1.374  11.217  14.557  1.00  0.00           H  
ATOM   2028  N   ASN B  93      -0.310   8.825  19.060  1.00 19.41           N  
ATOM   2029  CA  ASN B  93      -1.498   8.571  19.891  1.00 20.24           C  
ATOM   2030  C   ASN B  93      -1.281   7.344  20.783  1.00 22.39           C  
ATOM   2031  O   ASN B  93      -2.121   6.439  20.831  1.00 22.86           O  
ATOM   2032  CB  ASN B  93      -2.756   8.363  19.028  1.00 20.60           C  
ATOM   2033  CG  ASN B  93      -3.288   9.657  18.420  1.00 25.43           C  
ATOM   2034  OD1 ASN B  93      -2.597  10.676  18.371  1.00 27.73           O  
ATOM   2035  ND2 ASN B  93      -4.522   9.614  17.942  1.00 31.10           N  
ATOM   2036  H   ASN B  93       0.052   9.733  19.020  1.00  0.00           H  
ATOM   2037 HD21 ASN B  93      -4.907  10.423  17.539  1.00  0.00           H  
ATOM   2038 HD22 ASN B  93      -5.005   8.770  18.017  1.00  0.00           H  
ATOM   2039  N   GLY B  94      -0.122   7.290  21.436  1.00 21.58           N  
ATOM   2040  CA  GLY B  94       0.182   6.174  22.316  1.00 21.66           C  
ATOM   2041  C   GLY B  94       0.684   4.913  21.632  1.00 23.56           C  
ATOM   2042  O   GLY B  94       1.171   4.004  22.304  1.00 26.10           O  
ATOM   2043  H   GLY B  94       0.527   8.005  21.321  1.00  0.00           H  
ATOM   2044  N   GLN B  95       0.608   4.867  20.307  1.00 20.74           N  
ATOM   2045  CA  GLN B  95       1.056   3.704  19.555  1.00 21.13           C  
ATOM   2046  C   GLN B  95       2.486   3.843  19.033  1.00 18.13           C  
ATOM   2047  O   GLN B  95       2.835   4.845  18.410  1.00 18.13           O  
ATOM   2048  CB  GLN B  95       0.114   3.452  18.381  1.00 28.39           C  
ATOM   2049  CG  GLN B  95      -0.495   2.052  18.355  1.00 40.39           C  
ATOM   2050  CD  GLN B  95       0.545   0.950  18.191  1.00 44.95           C  
ATOM   2051  OE1 GLN B  95       0.576  -0.008  18.964  1.00 49.73           O  
ATOM   2052  NE2 GLN B  95       1.407   1.086  17.190  1.00 45.03           N  
ATOM   2053  H   GLN B  95       0.201   5.602  19.816  1.00  0.00           H  
ATOM   2054 HE21 GLN B  95       2.076   0.379  17.111  1.00  0.00           H  
ATOM   2055 HE22 GLN B  95       1.356   1.862  16.584  1.00  0.00           H  
ATOM   2056  N   PRO B  96       3.335   2.841  19.299  1.00 16.85           N  
ATOM   2057  CA  PRO B  96       4.736   2.817  18.864  1.00 14.92           C  
ATOM   2058  C   PRO B  96       4.848   2.729  17.345  1.00 12.57           C  
ATOM   2059  O   PRO B  96       4.119   1.971  16.695  1.00 11.13           O  
ATOM   2060  CB  PRO B  96       5.273   1.540  19.510  1.00 16.50           C  
ATOM   2061  CG  PRO B  96       4.437   1.390  20.724  1.00 20.77           C  
ATOM   2062  CD  PRO B  96       3.059   1.708  20.198  1.00 17.16           C  
ATOM   2063  N   CYS B  97       5.784   3.488  16.796  1.00 12.64           N  
ATOM   2064  CA  CYS B  97       6.042   3.531  15.364  1.00 13.22           C  
ATOM   2065  C   CYS B  97       7.562   3.532  15.144  1.00 14.54           C  
ATOM   2066  O   CYS B  97       8.327   3.774  16.080  1.00 16.23           O  
ATOM   2067  CB  CYS B  97       5.465   4.820  14.770  1.00 10.19           C  
ATOM   2068  SG  CYS B  97       3.705   5.090  15.067  1.00 12.02           S  
ATOM   2069  H   CYS B  97       6.355   4.025  17.389  1.00  0.00           H  
ATOM   2070  N   ALA B  98       7.998   3.271  13.917  1.00 14.05           N  
ATOM   2071  CA  ALA B  98       9.422   3.289  13.578  1.00 11.12           C  
ATOM   2072  C   ALA B  98       9.584   3.771  12.159  1.00 10.78           C  
ATOM   2073  O   ALA B  98       8.731   3.505  11.318  1.00 11.52           O  
ATOM   2074  CB  ALA B  98      10.016   1.942  13.694  1.00 11.32           C  
ATOM   2075  H   ALA B  98       7.365   3.077  13.191  1.00  0.00           H  
ATOM   2076  N   LEU B  99      10.699   4.442  11.888  1.00 10.41           N  
ATOM   2077  CA  LEU B  99      10.994   4.960  10.560  1.00  8.44           C  
ATOM   2078  C   LEU B  99      12.489   4.817  10.279  1.00 10.65           C  
ATOM   2079  O   LEU B  99      13.321   5.166  11.126  1.00 10.22           O  
ATOM   2080  CB  LEU B  99      10.611   6.437  10.484  1.00  6.92           C  
ATOM   2081  CG  LEU B  99      10.838   7.147   9.152  1.00  8.23           C  
ATOM   2082  CD1 LEU B  99       9.793   6.722   8.137  1.00  6.00           C  
ATOM   2083  CD2 LEU B  99      10.791   8.644   9.366  1.00 11.96           C  
ATOM   2084  H   LEU B  99      11.378   4.595  12.584  1.00  0.00           H  
ATOM   2085  N   ASP B 100      12.823   4.258   9.117  1.00  9.94           N  
ATOM   2086  CA  ASP B 100      14.211   4.088   8.686  1.00  8.76           C  
ATOM   2087  C   ASP B 100      14.518   5.300   7.821  1.00  7.84           C  
ATOM   2088  O   ASP B 100      13.764   5.610   6.896  1.00  7.49           O  
ATOM   2089  CB  ASP B 100      14.371   2.803   7.888  1.00  7.57           C  
ATOM   2090  CG  ASP B 100      14.124   1.586   8.718  1.00 11.47           C  
ATOM   2091  OD1 ASP B 100      14.642   1.531   9.850  1.00 12.42           O  
ATOM   2092  OD2 ASP B 100      13.398   0.690   8.252  1.00 14.54           O  
ATOM   2093  H   ASP B 100      12.104   3.974   8.511  1.00  0.00           H  
ATOM   2094  N   VAL B 101      15.607   5.996   8.136  1.00  7.50           N  
ATOM   2095  CA  VAL B 101      15.967   7.218   7.426  1.00  7.85           C  
ATOM   2096  C   VAL B 101      17.435   7.285   7.025  1.00  7.17           C  
ATOM   2097  O   VAL B 101      18.289   6.617   7.607  1.00  6.00           O  
ATOM   2098  CB  VAL B 101      15.727   8.458   8.346  1.00  7.16           C  
ATOM   2099  CG1 VAL B 101      15.844   9.760   7.558  1.00  6.00           C  
ATOM   2100  CG2 VAL B 101      14.393   8.352   9.069  1.00 10.24           C  
ATOM   2101  H   VAL B 101      16.204   5.686   8.851  1.00  0.00           H  
ATOM   2102  N   ILE B 102      17.708   8.095   6.012  1.00  7.71           N  
ATOM   2103  CA  ILE B 102      19.070   8.353   5.586  1.00  6.91           C  
ATOM   2104  C   ILE B 102      19.163   9.863   5.459  1.00  6.00           C  
ATOM   2105  O   ILE B 102      18.357  10.474   4.766  1.00  6.16           O  
ATOM   2106  CB  ILE B 102      19.447   7.691   4.229  1.00  6.67           C  
ATOM   2107  CG1 ILE B 102      19.803   6.220   4.435  1.00  6.00           C  
ATOM   2108  CG2 ILE B 102      20.665   8.407   3.620  1.00 10.28           C  
ATOM   2109  CD1 ILE B 102      20.334   5.532   3.199  1.00  6.56           C  
ATOM   2110  H   ILE B 102      16.977   8.529   5.521  1.00  0.00           H  
ATOM   2111  N   ASP B 103      20.085  10.469   6.201  1.00  6.00           N  
ATOM   2112  CA  ASP B 103      20.300  11.915   6.141  1.00  6.64           C  
ATOM   2113  C   ASP B 103      21.598  12.186   5.375  1.00  6.09           C  
ATOM   2114  O   ASP B 103      22.586  11.467   5.548  1.00  6.78           O  
ATOM   2115  CB  ASP B 103      20.464  12.518   7.548  1.00  6.00           C  
ATOM   2116  CG  ASP B 103      19.148  12.846   8.223  1.00  8.51           C  
ATOM   2117  OD1 ASP B 103      18.076  12.504   7.700  1.00  6.29           O  
ATOM   2118  OD2 ASP B 103      19.193  13.455   9.311  1.00  6.00           O  
ATOM   2119  H   ASP B 103      20.656   9.912   6.775  1.00  0.00           H  
ATOM   2120  HD2 ASP B 103      19.462  14.364   9.176  1.00  0.00           H  
ATOM   2121  N   VAL B 104      21.583  13.217   4.541  1.00  7.44           N  
ATOM   2122  CA  VAL B 104      22.754  13.644   3.787  1.00  8.86           C  
ATOM   2123  C   VAL B 104      23.002  15.064   4.282  1.00  9.33           C  
ATOM   2124  O   VAL B 104      22.080  15.882   4.296  1.00  7.33           O  
ATOM   2125  CB  VAL B 104      22.483  13.661   2.269  1.00 10.91           C  
ATOM   2126  CG1 VAL B 104      23.639  14.331   1.531  1.00 11.61           C  
ATOM   2127  CG2 VAL B 104      22.297  12.240   1.768  1.00  9.19           C  
ATOM   2128  H   VAL B 104      20.758  13.729   4.414  1.00  0.00           H  
ATOM   2129  N   MET B 105      24.218  15.338   4.754  1.00  8.96           N  
ATOM   2130  CA  MET B 105      24.545  16.661   5.279  1.00  9.00           C  
ATOM   2131  C   MET B 105      25.800  17.258   4.678  1.00 10.96           C  
ATOM   2132  O   MET B 105      26.776  16.558   4.436  1.00  8.93           O  
ATOM   2133  CB  MET B 105      24.737  16.610   6.802  1.00 11.68           C  
ATOM   2134  CG  MET B 105      23.481  16.348   7.627  1.00 13.02           C  
ATOM   2135  SD  MET B 105      23.868  16.204   9.390  1.00 15.65           S  
ATOM   2136  CE  MET B 105      22.266  15.958  10.060  1.00 13.56           C  
ATOM   2137  H   MET B 105      24.913  14.645   4.722  1.00  0.00           H  
ATOM   2138  N   ARG B 106      25.762  18.569   4.472  1.00 13.44           N  
ATOM   2139  CA  ARG B 106      26.885  19.334   3.947  1.00 13.87           C  
ATOM   2140  C   ARG B 106      27.243  20.363   5.015  1.00 13.49           C  
ATOM   2141  O   ARG B 106      26.376  21.112   5.476  1.00 12.32           O  
ATOM   2142  CB  ARG B 106      26.496  20.059   2.664  1.00 16.09           C  
ATOM   2143  CG  ARG B 106      27.574  20.988   2.154  1.00 23.94           C  
ATOM   2144  CD  ARG B 106      27.154  21.676   0.872  1.00 33.80           C  
ATOM   2145  NE  ARG B 106      28.276  21.716  -0.059  1.00 45.63           N  
ATOM   2146  CZ  ARG B 106      28.517  20.791  -0.985  1.00 48.68           C  
ATOM   2147  NH1 ARG B 106      27.704  19.747  -1.127  1.00 49.07           N  
ATOM   2148  NH2 ARG B 106      29.615  20.874  -1.726  1.00 52.23           N  
ATOM   2149  H   ARG B 106      24.940  19.053   4.705  1.00  0.00           H  
ATOM   2150  HE  ARG B 106      28.901  22.469   0.002  1.00  0.00           H  
ATOM   2151 HH11 ARG B 106      26.899  19.647  -0.543  1.00  0.00           H  
ATOM   2152 HH12 ARG B 106      27.902  19.060  -1.828  1.00  0.00           H  
ATOM   2153 HH21 ARG B 106      30.258  21.627  -1.588  1.00  0.00           H  
ATOM   2154 HH22 ARG B 106      29.805  20.176  -2.415  1.00  0.00           H  
ATOM   2155  N   PHE B 107      28.495  20.353   5.456  1.00 13.81           N  
ATOM   2156  CA  PHE B 107      28.956  21.291   6.477  1.00 14.31           C  
ATOM   2157  C   PHE B 107      29.711  22.446   5.835  1.00 14.81           C  
ATOM   2158  O   PHE B 107      30.324  22.279   4.770  1.00 17.08           O  
ATOM   2159  CB  PHE B 107      29.855  20.576   7.488  1.00 10.26           C  
ATOM   2160  CG  PHE B 107      29.153  19.490   8.263  1.00  9.95           C  
ATOM   2161  CD1 PHE B 107      28.990  18.221   7.721  1.00  6.93           C  
ATOM   2162  CD2 PHE B 107      28.655  19.739   9.541  1.00  9.78           C  
ATOM   2163  CE1 PHE B 107      28.338  17.211   8.442  1.00 11.86           C  
ATOM   2164  CE2 PHE B 107      28.004  18.740  10.270  1.00 10.21           C  
ATOM   2165  CZ  PHE B 107      27.844  17.473   9.720  1.00  9.50           C  
ATOM   2166  H   PHE B 107      29.121  19.709   5.070  1.00  0.00           H  
ATOM   2167  N   ASP B 108      29.644  23.618   6.458  1.00 14.92           N  
ATOM   2168  CA  ASP B 108      30.338  24.789   5.944  1.00 16.92           C  
ATOM   2169  C   ASP B 108      31.773  24.865   6.464  1.00 19.06           C  
ATOM   2170  O   ASP B 108      32.225  23.995   7.213  1.00 16.72           O  
ATOM   2171  CB  ASP B 108      29.563  26.090   6.247  1.00 17.27           C  
ATOM   2172  CG  ASP B 108      29.460  26.419   7.743  1.00 16.36           C  
ATOM   2173  OD1 ASP B 108      30.076  25.756   8.591  1.00 17.30           O  
ATOM   2174  OD2 ASP B 108      28.746  27.381   8.078  1.00 19.66           O  
ATOM   2175  H   ASP B 108      29.113  23.683   7.272  1.00  0.00           H  
ATOM   2176  N   GLU B 109      32.480  25.921   6.083  1.00 21.72           N  
ATOM   2177  CA  GLU B 109      33.865  26.120   6.502  1.00 27.69           C  
ATOM   2178  C   GLU B 109      34.016  26.482   7.984  1.00 27.60           C  
ATOM   2179  O   GLU B 109      35.050  27.001   8.401  1.00 29.63           O  
ATOM   2180  CB  GLU B 109      34.525  27.200   5.633  1.00 32.56           C  
ATOM   2181  CG  GLU B 109      33.989  28.628   5.831  1.00 42.88           C  
ATOM   2182  CD  GLU B 109      32.603  28.855   5.242  1.00 50.60           C  
ATOM   2183  OE1 GLU B 109      32.211  28.132   4.297  1.00 56.02           O  
ATOM   2184  OE2 GLU B 109      31.904  29.774   5.717  1.00 55.05           O  
ATOM   2185  H   GLU B 109      32.025  26.558   5.506  1.00  0.00           H  
ATOM   2186  N   HIS B 110      32.979  26.225   8.773  1.00 27.89           N  
ATOM   2187  CA  HIS B 110      32.988  26.531  10.197  1.00 25.47           C  
ATOM   2188  C   HIS B 110      32.497  25.344  10.997  1.00 22.63           C  
ATOM   2189  O   HIS B 110      32.226  25.464  12.192  1.00 24.97           O  
ATOM   2190  CB  HIS B 110      32.092  27.737  10.497  1.00 31.63           C  
ATOM   2191  CG  HIS B 110      32.599  29.022   9.926  1.00 38.38           C  
ATOM   2192  ND1 HIS B 110      31.933  29.713   8.936  1.00 40.93           N  
ATOM   2193  CD2 HIS B 110      33.711  29.744  10.207  1.00 41.07           C  
ATOM   2194  CE1 HIS B 110      32.614  30.804   8.629  1.00 43.65           C  
ATOM   2195  NE2 HIS B 110      33.695  30.846   9.385  1.00 44.54           N  
ATOM   2196  H   HIS B 110      32.187  25.788   8.429  1.00  0.00           H  
ATOM   2197  HD1 HIS B 110      31.065  29.484   8.532  1.00  0.00           H  
ATOM   2198  HE2 HIS B 110      34.370  31.555   9.387  1.00  0.00           H  
ATOM   2199  N   GLY B 111      32.333  24.208  10.331  1.00 19.26           N  
ATOM   2200  CA  GLY B 111      31.882  23.020  11.029  1.00 17.11           C  
ATOM   2201  C   GLY B 111      30.398  22.953  11.338  1.00 13.26           C  
ATOM   2202  O   GLY B 111      29.967  22.080  12.091  1.00 14.89           O  
ATOM   2203  H   GLY B 111      32.519  24.132   9.373  1.00  0.00           H  
ATOM   2204  N   ARG B 112      29.614  23.838  10.735  1.00 13.77           N  
ATOM   2205  CA  ARG B 112      28.163  23.880  10.961  1.00 16.90           C  
ATOM   2206  C   ARG B 112      27.424  23.276   9.766  1.00 12.86           C  
ATOM   2207  O   ARG B 112      27.931  23.318   8.648  1.00 10.23           O  
ATOM   2208  CB  ARG B 112      27.701  25.331  11.160  1.00 21.60           C  
ATOM   2209  CG  ARG B 112      28.577  26.145  12.108  1.00 30.68           C  
ATOM   2210  CD  ARG B 112      28.122  27.593  12.202  1.00 38.23           C  
ATOM   2211  NE  ARG B 112      27.014  27.752  13.139  1.00 47.19           N  
ATOM   2212  CZ  ARG B 112      27.161  27.903  14.453  1.00 52.61           C  
ATOM   2213  NH1 ARG B 112      28.373  27.920  14.994  1.00 56.54           N  
ATOM   2214  NH2 ARG B 112      26.096  28.028  15.234  1.00 53.19           N  
ATOM   2215  H   ARG B 112      30.026  24.451  10.117  1.00  0.00           H  
ATOM   2216  HE  ARG B 112      26.102  27.748  12.781  1.00  0.00           H  
ATOM   2217 HH11 ARG B 112      29.184  27.823  14.419  1.00  0.00           H  
ATOM   2218 HH12 ARG B 112      28.474  28.031  15.982  1.00  0.00           H  
ATOM   2219 HH21 ARG B 112      25.179  28.003  14.837  1.00  0.00           H  
ATOM   2220 HH22 ARG B 112      26.213  28.134  16.221  1.00  0.00           H  
ATOM   2221  N   ILE B 113      26.219  22.749  10.000  1.00 12.89           N  
ATOM   2222  CA  ILE B 113      25.406  22.146   8.935  1.00  9.25           C  
ATOM   2223  C   ILE B 113      24.801  23.246   8.080  1.00  9.93           C  
ATOM   2224  O   ILE B 113      24.067  24.103   8.576  1.00  9.01           O  
ATOM   2225  CB  ILE B 113      24.229  21.301   9.490  1.00  9.74           C  
ATOM   2226  CG1 ILE B 113      24.722  20.280  10.514  1.00  9.75           C  
ATOM   2227  CG2 ILE B 113      23.540  20.570   8.349  1.00  9.61           C  
ATOM   2228  CD1 ILE B 113      23.602  19.608  11.296  1.00 11.15           C  
ATOM   2229  H   ILE B 113      25.861  22.781  10.910  1.00  0.00           H  
ATOM   2230  N   GLN B 114      25.135  23.239   6.800  1.00  8.51           N  
ATOM   2231  CA  GLN B 114      24.616  24.235   5.884  1.00 11.44           C  
ATOM   2232  C   GLN B 114      23.355  23.693   5.219  1.00 12.42           C  
ATOM   2233  O   GLN B 114      22.424  24.446   4.922  1.00 10.73           O  
ATOM   2234  CB  GLN B 114      25.669  24.593   4.841  1.00 15.70           C  
ATOM   2235  CG  GLN B 114      25.338  25.823   4.037  1.00 25.21           C  
ATOM   2236  CD  GLN B 114      26.494  26.273   3.162  1.00 37.93           C  
ATOM   2237  OE1 GLN B 114      27.481  25.549   2.981  1.00 41.39           O  
ATOM   2238  NE2 GLN B 114      26.382  27.479   2.610  1.00 42.75           N  
ATOM   2239  H   GLN B 114      25.751  22.555   6.475  1.00  0.00           H  
ATOM   2240 HE21 GLN B 114      27.125  27.765   2.041  1.00  0.00           H  
ATOM   2241 HE22 GLN B 114      25.575  28.003   2.786  1.00  0.00           H  
ATOM   2242  N   THR B 115      23.325  22.389   4.974  1.00 12.14           N  
ATOM   2243  CA  THR B 115      22.159  21.773   4.360  1.00 15.11           C  
ATOM   2244  C   THR B 115      21.966  20.368   4.896  1.00 12.75           C  
ATOM   2245  O   THR B 115      22.934  19.637   5.114  1.00  9.69           O  
ATOM   2246  CB  THR B 115      22.280  21.679   2.808  1.00 17.77           C  
ATOM   2247  OG1 THR B 115      23.384  20.839   2.462  1.00 27.09           O  
ATOM   2248  CG2 THR B 115      22.493  23.047   2.176  1.00 21.61           C  
ATOM   2249  H   THR B 115      24.092  21.813   5.181  1.00  0.00           H  
ATOM   2250  HG1 THR B 115      23.202  19.935   2.742  1.00  0.00           H  
ATOM   2251  N   MET B 116      20.713  20.005   5.131  1.00 13.60           N  
ATOM   2252  CA  MET B 116      20.367  18.671   5.599  1.00 13.46           C  
ATOM   2253  C   MET B 116      19.199  18.192   4.749  1.00 12.96           C  
ATOM   2254  O   MET B 116      18.268  18.955   4.473  1.00 14.79           O  
ATOM   2255  CB  MET B 116      19.978  18.686   7.076  1.00 13.22           C  
ATOM   2256  CG  MET B 116      19.699  17.301   7.659  1.00 11.86           C  
ATOM   2257  SD  MET B 116      18.052  16.668   7.295  1.00 17.02           S  
ATOM   2258  CE  MET B 116      17.160  17.139   8.771  1.00  9.58           C  
ATOM   2259  H   MET B 116      19.983  20.645   4.973  1.00  0.00           H  
ATOM   2260  N   GLN B 117      19.278  16.950   4.296  1.00  9.50           N  
ATOM   2261  CA  GLN B 117      18.233  16.362   3.476  1.00 10.98           C  
ATOM   2262  C   GLN B 117      17.961  14.985   4.035  1.00  9.10           C  
ATOM   2263  O   GLN B 117      18.893  14.217   4.253  1.00  9.77           O  
ATOM   2264  CB  GLN B 117      18.705  16.251   2.028  1.00 10.15           C  
ATOM   2265  CG  GLN B 117      19.013  17.586   1.396  1.00 14.99           C  
ATOM   2266  CD  GLN B 117      19.746  17.451   0.078  1.00 24.38           C  
ATOM   2267  OE1 GLN B 117      20.876  16.956   0.031  1.00 25.99           O  
ATOM   2268  NE2 GLN B 117      19.117  17.898  -0.998  1.00 25.07           N  
ATOM   2269  H   GLN B 117      20.062  16.398   4.512  1.00  0.00           H  
ATOM   2270 HE21 GLN B 117      19.577  17.772  -1.851  1.00  0.00           H  
ATOM   2271 HE22 GLN B 117      18.236  18.305  -0.888  1.00  0.00           H  
ATOM   2272  N   ALA B 118      16.699  14.693   4.318  1.00  6.00           N  
ATOM   2273  CA  ALA B 118      16.338  13.394   4.863  1.00  7.67           C  
ATOM   2274  C   ALA B 118      15.521  12.583   3.859  1.00  7.48           C  
ATOM   2275  O   ALA B 118      14.497  13.042   3.365  1.00  9.20           O  
ATOM   2276  CB  ALA B 118      15.567  13.570   6.162  1.00  6.00           C  
ATOM   2277  H   ALA B 118      15.998  15.351   4.148  1.00  0.00           H  
ATOM   2278  N   TYR B 119      16.004  11.392   3.538  1.00  7.19           N  
ATOM   2279  CA  TYR B 119      15.334  10.501   2.604  1.00  8.34           C  
ATOM   2280  C   TYR B 119      14.517   9.467   3.342  1.00  6.71           C  
ATOM   2281  O   TYR B 119      15.038   8.727   4.180  1.00  7.84           O  
ATOM   2282  CB  TYR B 119      16.356   9.790   1.720  1.00  8.88           C  
ATOM   2283  CG  TYR B 119      17.053  10.724   0.775  1.00 10.37           C  
ATOM   2284  CD1 TYR B 119      18.116  11.518   1.204  1.00  7.21           C  
ATOM   2285  CD2 TYR B 119      16.625  10.846  -0.546  1.00  9.31           C  
ATOM   2286  CE1 TYR B 119      18.730  12.408   0.342  1.00  8.64           C  
ATOM   2287  CE2 TYR B 119      17.234  11.730  -1.414  1.00  9.69           C  
ATOM   2288  CZ  TYR B 119      18.283  12.508  -0.965  1.00 10.49           C  
ATOM   2289  OH  TYR B 119      18.886  13.381  -1.831  1.00 14.21           O  
ATOM   2290  H   TYR B 119      16.833  11.097   3.952  1.00  0.00           H  
ATOM   2291  HH  TYR B 119      18.367  13.533  -2.628  1.00  0.00           H  
ATOM   2292  N   TRP B 120      13.225   9.446   3.043  1.00  9.85           N  
ATOM   2293  CA  TRP B 120      12.289   8.496   3.629  1.00  8.05           C  
ATOM   2294  C   TRP B 120      10.893   8.813   3.119  1.00  8.54           C  
ATOM   2295  O   TRP B 120      10.641   9.910   2.608  1.00  9.38           O  
ATOM   2296  CB  TRP B 120      12.304   8.566   5.167  1.00  7.57           C  
ATOM   2297  CG  TRP B 120      11.792   9.867   5.745  1.00 11.17           C  
ATOM   2298  CD1 TRP B 120      12.531  10.962   6.068  1.00  6.70           C  
ATOM   2299  CD2 TRP B 120      10.431  10.182   6.094  1.00 10.06           C  
ATOM   2300  NE1 TRP B 120      11.724  11.937   6.602  1.00 10.54           N  
ATOM   2301  CE2 TRP B 120      10.433  11.491   6.629  1.00 10.37           C  
ATOM   2302  CE3 TRP B 120       9.213   9.488   6.005  1.00 11.50           C  
ATOM   2303  CZ2 TRP B 120       9.263  12.124   7.078  1.00  8.34           C  
ATOM   2304  CZ3 TRP B 120       8.044  10.118   6.452  1.00 11.85           C  
ATOM   2305  CH2 TRP B 120       8.083  11.425   6.981  1.00 11.31           C  
ATOM   2306  H   TRP B 120      12.868  10.095   2.399  1.00  0.00           H  
ATOM   2307  HE1 TRP B 120      12.066  12.736   7.004  1.00  0.00           H  
ATOM   2308  N   SER B 121      10.012   7.824   3.192  1.00  9.80           N  
ATOM   2309  CA  SER B 121       8.618   7.992   2.808  1.00  8.09           C  
ATOM   2310  C   SER B 121       7.868   6.901   3.558  1.00  7.91           C  
ATOM   2311  O   SER B 121       8.466   6.162   4.347  1.00  8.96           O  
ATOM   2312  CB  SER B 121       8.420   7.877   1.292  1.00  6.00           C  
ATOM   2313  OG  SER B 121       8.566   6.546   0.846  1.00  7.17           O  
ATOM   2314  H   SER B 121      10.308   6.937   3.490  1.00  0.00           H  
ATOM   2315  HG  SER B 121       7.935   5.942   1.208  1.00  0.00           H  
ATOM   2316  N   GLU B 122       6.574   6.767   3.295  1.00  8.82           N  
ATOM   2317  CA  GLU B 122       5.758   5.770   3.977  1.00  6.12           C  
ATOM   2318  C   GLU B 122       6.226   4.336   3.777  1.00  6.00           C  
ATOM   2319  O   GLU B 122       5.886   3.461   4.566  1.00  6.74           O  
ATOM   2320  CB  GLU B 122       4.282   5.915   3.593  1.00 10.86           C  
ATOM   2321  CG  GLU B 122       3.627   7.216   4.059  1.00  8.91           C  
ATOM   2322  CD  GLU B 122       3.854   8.390   3.105  1.00 15.10           C  
ATOM   2323  OE1 GLU B 122       4.587   8.248   2.106  1.00 14.49           O  
ATOM   2324  OE2 GLU B 122       3.278   9.470   3.344  1.00 17.82           O  
ATOM   2325  H   GLU B 122       6.192   7.355   2.639  1.00  0.00           H  
ATOM   2326  N   VAL B 123       7.019   4.086   2.737  1.00  7.35           N  
ATOM   2327  CA  VAL B 123       7.527   2.731   2.506  1.00  7.68           C  
ATOM   2328  C   VAL B 123       8.546   2.355   3.598  1.00  8.94           C  
ATOM   2329  O   VAL B 123       8.806   1.177   3.841  1.00 13.31           O  
ATOM   2330  CB  VAL B 123       8.157   2.563   1.080  1.00  9.04           C  
ATOM   2331  CG1 VAL B 123       7.131   2.922  -0.001  1.00  6.88           C  
ATOM   2332  CG2 VAL B 123       9.418   3.414   0.929  1.00  7.33           C  
ATOM   2333  H   VAL B 123       7.241   4.797   2.126  1.00  0.00           H  
ATOM   2334  N   ASN B 124       9.090   3.368   4.270  1.00  8.20           N  
ATOM   2335  CA  ASN B 124      10.079   3.181   5.338  1.00  9.15           C  
ATOM   2336  C   ASN B 124       9.450   3.304   6.725  1.00 10.38           C  
ATOM   2337  O   ASN B 124      10.141   3.202   7.743  1.00  7.78           O  
ATOM   2338  CB  ASN B 124      11.183   4.237   5.205  1.00  7.12           C  
ATOM   2339  CG  ASN B 124      11.907   4.147   3.888  1.00  6.00           C  
ATOM   2340  OD1 ASN B 124      11.895   5.088   3.092  1.00  8.90           O  
ATOM   2341  ND2 ASN B 124      12.512   2.993   3.625  1.00  8.20           N  
ATOM   2342  H   ASN B 124       8.834   4.281   4.053  1.00  0.00           H  
ATOM   2343 HD21 ASN B 124      12.978   2.871   2.765  1.00  0.00           H  
ATOM   2344 HD22 ASN B 124      12.456   2.289   4.310  1.00  0.00           H  
ATOM   2345  N   LEU B 125       8.127   3.453   6.747  1.00 12.22           N  
ATOM   2346  CA  LEU B 125       7.374   3.654   7.976  1.00  8.69           C  
ATOM   2347  C   LEU B 125       6.624   2.444   8.502  1.00  9.04           C  
ATOM   2348  O   LEU B 125       6.167   1.601   7.740  1.00 11.60           O  
ATOM   2349  CB  LEU B 125       6.406   4.825   7.766  1.00  9.53           C  
ATOM   2350  CG  LEU B 125       5.507   5.375   8.875  1.00 13.19           C  
ATOM   2351  CD1 LEU B 125       6.331   5.909  10.029  1.00  9.38           C  
ATOM   2352  CD2 LEU B 125       4.640   6.491   8.290  1.00 13.00           C  
ATOM   2353  H   LEU B 125       7.607   3.359   5.926  1.00  0.00           H  
ATOM   2354  N   SER B 126       6.533   2.353   9.824  1.00  8.86           N  
ATOM   2355  CA  SER B 126       5.817   1.280  10.493  1.00 10.54           C  
ATOM   2356  C   SER B 126       5.070   1.898  11.662  1.00 15.74           C  
ATOM   2357  O   SER B 126       5.686   2.366  12.620  1.00 15.13           O  
ATOM   2358  CB  SER B 126       6.777   0.214  10.984  1.00 13.26           C  
ATOM   2359  OG  SER B 126       6.082  -0.802  11.663  1.00 14.04           O  
ATOM   2360  H   SER B 126       7.013   3.011  10.366  1.00  0.00           H  
ATOM   2361  HG  SER B 126       5.474  -1.177  11.024  1.00  0.00           H  
ATOM   2362  N   VAL B 127       3.745   1.963  11.549  1.00 17.96           N  
ATOM   2363  CA  VAL B 127       2.910   2.547  12.602  1.00 19.12           C  
ATOM   2364  C   VAL B 127       2.275   1.436  13.445  1.00 22.86           C  
ATOM   2365  O   VAL B 127       1.235   1.618  14.059  1.00 23.40           O  
ATOM   2366  CB  VAL B 127       1.793   3.428  12.006  1.00 18.89           C  
ATOM   2367  CG1 VAL B 127       2.375   4.616  11.285  1.00 14.87           C  
ATOM   2368  CG2 VAL B 127       0.919   2.622  11.071  1.00 18.93           C  
ATOM   2369  H   VAL B 127       3.347   1.717  10.712  1.00  0.00           H  
ATOM   2370  N   ARG B 128       2.968   0.315  13.536  1.00 26.50           N  
ATOM   2371  CA  ARG B 128       2.443  -0.823  14.268  1.00 34.75           C  
ATOM   2372  C   ARG B 128       3.485  -1.480  15.165  1.00 39.56           C  
ATOM   2373  O   ARG B 128       3.687  -2.691  15.096  1.00 42.39           O  
ATOM   2374  CB  ARG B 128       1.875  -1.844  13.305  1.00 39.13           C  
ATOM   2375  H   ARG B 128       3.897   0.250  13.319  1.00  0.00           H  
ATOM   2376  N   GLU B 129       4.173  -0.657  15.952  1.00 43.37           N  
ATOM   2377  CA  GLU B 129       5.180  -1.077  16.941  1.00 46.29           C  
ATOM   2378  C   GLU B 129       6.687  -0.925  16.672  1.00 47.92           C  
ATOM   2379  O   GLU B 129       7.367  -0.319  17.500  1.00 51.57           O  
ATOM   2380  CB  GLU B 129       4.866  -2.461  17.512  1.00 43.89           C  
ATOM   2381  H   GLU B 129       3.975   0.291  15.835  1.00  0.00           H  
ATOM   2382  N   PRO B 130       7.229  -1.428  15.535  1.00 49.13           N  
ATOM   2383  CA  PRO B 130       8.672  -1.324  15.230  1.00 47.95           C  
ATOM   2384  C   PRO B 130       9.366  -0.064  15.695  1.00 49.88           C  
ATOM   2385  O   PRO B 130      10.549  -0.169  16.068  1.00 51.56           O  
ATOM   2386  CB  PRO B 130       8.702  -1.499  13.721  1.00 45.69           C  
ATOM   2387  CG  PRO B 130       7.696  -2.587  13.574  1.00 47.73           C  
ATOM   2388  CD  PRO B 130       6.536  -2.117  14.442  1.00 49.13           C  
TER    2389      PRO B 130                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
