
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1148),  selected  147 , name 1nu3_B
# Molecule2: number of CA atoms  133 ( 1086),  selected  133 , name T0451.pdb
# PARAMETERS: 1nu3_B.T0451.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_B      -       -           -
LGA    K     4_B      -       -           -
LGA    I     5_B      -       -           -
LGA    E     6_B      -       -           -
LGA    Q     7_B      -       -           -
LGA    P     8_B      -       -           -
LGA    R     9_B      -       -           -
LGA    W    10_B      -       -           -
LGA    A    11_B      -       -           -
LGA    S    12_B      -       -           -
LGA    K    13_B      -       -           -
LGA    D    14_B      -       -           -
LGA    S    15_B      -       -           -
LGA    A    16_B      M       1           #
LGA    A    17_B      M       2           -
LGA    G    18_B      -       -           -
LGA    A    19_B      -       -           -
LGA    A    20_B      -       -           -
LGA    S    21_B      T       3          4.549
LGA    -       -      H       4           -
LGA    -       -      Y       5           -
LGA    -       -      S       6           -
LGA    T    22_B      D       7          2.783
LGA    P    23_B      N       8          2.482
LGA    D    24_B      T       9          2.019
LGA    E    25_B      L      10          1.713
LGA    K    26_B      K      11          2.541
LGA    I    27_B      V      12          2.572
LGA    V    28_B      A      13          2.153
LGA    L    29_B      H      14          2.389
LGA    E    30_B      Q      15          2.570
LGA    F    31_B      G      16          2.445
LGA    X    32_B      F      17          2.387
LGA    D    33_B      E      18          2.507
LGA    A    34_B      F      19          2.307
LGA    L    35_B      F      20          2.742
LGA    -       -      T      21           -
LGA    T    36_B      Q      22          2.902
LGA    S    37_B      G      23          3.461
LGA    -       -      L      24           -
LGA    -       -      A      25           -
LGA    -       -      T      26           -
LGA    N    38_B      G      27          1.684
LGA    D    39_B      E      28          1.260
LGA    A    40_B      W      29          2.553
LGA    A    41_B      Q      30          2.643
LGA    K    42_B      K      31          2.963
LGA    L    43_B      F      32          2.183
LGA    I    44_B      L      33          0.811
LGA    E    45_B      D      34          0.781
LGA    Y    46_B      M      35          1.693
LGA    F    47_B      L      36          0.664
LGA    A    48_B      T      37          0.622
LGA    E    49_B      E      38          0.709
LGA    D    50_B      D      39          0.393
LGA    T    51_B      F      40          0.797
LGA    X    52_B      T      41          0.925
LGA    Y    53_B      F      42          1.547
LGA    Q    54_B      W      43          2.252
LGA    N    55_B      F      44          2.352
LGA    X    56_B      P      45          2.266
LGA    P    57_B      M      46          3.094
LGA    L    58_B      G      47          4.153
LGA    -       -      E      48           -
LGA    -       -      F      49           -
LGA    P    59_B      H      50          1.335
LGA    P    60_B      G      51          3.507
LGA    -       -      L      52           -
LGA    A    61_B      N      53          1.885
LGA    Y    62_B      V      54          0.783
LGA    G    63_B      G      55          0.772
LGA    R    64_B      K      56          1.072
LGA    D    65_B      E      57          0.916
LGA    A    66_B      R      58          0.638
LGA    V    67_B      A      59          0.747
LGA    E    68_B      K      60          1.014
LGA    Q    69_B      E      61          1.098
LGA    T    70_B      F      62          0.963
LGA    L    71_B      F      63          0.714
LGA    A    72_B      T      64          1.066
LGA    G    73_B      Y      65          1.475
LGA    L    74_B      V      66          1.371
LGA    F    75_B      S      67          1.184
LGA    T    76_B      E      68          0.935
LGA    V    77_B      S      69          1.478
LGA    X    78_B      F      70          2.203
LGA    -       -      H      71           -
LGA    S    79_B      T      72          5.085
LGA    I    80_B      G      73          4.101
LGA    D    81_B      I      74          2.992
LGA    A    82_B      Q      75          2.004
LGA    V    83_B      I      76          2.011
LGA    -       -      S      77           -
LGA    E    84_B      S      78          2.751
LGA    T    85_B      L      79          1.720
LGA    F    86_B      D      80          1.157
LGA    H    87_B      R      81          1.102
LGA    I    88_B      V      82          0.937
LGA    G    89_B      T      83          1.640
LGA    S    90_B      S      84          1.062
LGA    S    91_B      N      85          1.414
LGA    N    92_B      E      86          3.787
LGA    G    93_B      T      87          1.231
LGA    L    94_B      T      88          1.139
LGA    V    95_B      V      89          0.998
LGA    Y    96_B      V      90          1.426
LGA    T    97_B      F      91          1.405
LGA    E    98_B      E      92          1.171
LGA    R    99_B      F      93          0.991
LGA    V   100_B      R      94          1.199
LGA    D   101_B      D      95          2.226
LGA    V   102_B      E      96          1.992
LGA    L   103_B      G      97          3.009
LGA    R   104_B      L      98          2.396
LGA    A   105_B      F      99          1.079
LGA    L   106_B      L     100          3.444
LGA    P   107_B      -       -           -
LGA    T   108_B      -       -           -
LGA    G   109_B      G     101          1.615
LGA    K   110_B      K     102          2.321
LGA    S   111_B      P     103          2.755
LGA    Y   112_B      Y     104          2.621
LGA    N   113_B      K     105          2.590
LGA    L   114_B      N     106          1.129
LGA    S   115_B      R     107          0.538
LGA    I   116_B      V     108          1.028
LGA    L   117_B      A     109          1.754
LGA    G   118_B      V     110          2.071
LGA    V   119_B      S     111          1.267
LGA    F   120_B      F     112          0.805
LGA    Q   121_B      D     113          0.476
LGA    L   122_B      V     114          0.932
LGA    T   123_B      R     115          0.722
LGA    E   124_B      G     116          0.898
LGA    G   125_B      D     117          2.166
LGA    K   126_B      K     118          1.079
LGA    I   127_B      I     119          1.211
LGA    T   128_B      C     120          0.793
LGA    G   129_B      S     121          0.692
LGA    W   130_B      Y     122          0.585
LGA    R   131_B      R     123          0.362
LGA    D   132_B      E     124          1.114
LGA    Y   133_B      Y     125          0.451
LGA    F   134_B      F     126          0.287
LGA    D   135_B      G     127          5.069
LGA    L   136_B      S     128           #
LGA    R   137_B      -       -           -
LGA    E   138_B      D     129          2.242
LGA    F   139_B      G     130          1.826
LGA    E   140_B      -       -           -
LGA    E   141_B      -       -           -
LGA    A   142_B      K     131          3.656
LGA    V   143_B      S     132           -
LGA    D   144_B      N     133           -
LGA    L   145_B      -       -           -
LGA    P   146_B      -       -           -
LGA    L   147_B      -       -           -
LGA    R   148_B      -       -           -
LGA    G   149_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  133    5.0    116    2.06    16.38     75.479     5.381

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.056421 * X  +   0.006717 * Y  +   0.998384 * Z  +   1.035398
  Y_new =  -0.998373 * X  +  -0.007839 * Y  +   0.056473 * Z  +  18.739460
  Z_new =   0.008206 * X  +  -0.999947 * Y  +   0.006264 * Z  +  14.692110 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.564533    1.577060  [ DEG:   -89.6411     90.3589 ]
  Theta =  -0.008206   -3.133387  [ DEG:    -0.4702   -179.5298 ]
  Phi   =  -1.514344    1.627249  [ DEG:   -86.7655     93.2345 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1nu3_B                                        
REMARK     2: T0451.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1nu3_B.T0451.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  133   5.0  116   2.06   16.38  75.479
REMARK  ---------------------------------------------------------- 
MOLECULE 1nu3_B
HEADER    HYDROLASE                               30-JAN-03   1NU3              
TITLE     LIMONENE-1,2-EPOXIDE HYDROLASE IN COMPLEX WITH VALPROMIDE             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LIMONENE-1,2-EPOXIDE HYDROLASE;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 3.3.2.8;                                                         
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOCOCCUS ERYTHROPOLIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: LIMA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PGEF-LEH                                  
KEYWDS    PROTEIN-LIGAND COMPLEX                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.ARAND,B.M.HALLBERG,J.ZOU,T.BERGFORS,F.OESCH,M.J.VAN DER             
AUTHOR   2 WERF,J.A.M.DE BONT,T.A.JONES,S.L.MOWBRAY                             
REVDAT   1   10-JUN-03 1NU3    0                                                
JRNL        AUTH   M.ARAND,B.M.HALLBERG,J.ZOU,T.BERGFORS,F.OESCH,               
JRNL        AUTH 2 M.J.VAN DER WERF,J.A.M.DE BONT,T.A.JONES,                    
JRNL        AUTH 3 S.L.MOWBRAY                                                  
JRNL        TITL   STRUCTURE OF RHODOCOCCUS ERYTHROPOLIS                        
JRNL        TITL 2 LIMONENE-1,2-EPOXIDE HYDROLASE REVEALS A NOVEL               
JRNL        TITL 3 ACTIVE SITE                                                  
JRNL        REF    EMBO J.                       V.  22  2583 2003              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  1NU3 A    1   149  UNP    Q9ZAG3   LIMA_RHOER       0    148             
DBREF  1NU3 B    1   149  UNP    Q9ZAG3   LIMA_RHOER       0    148             
SEQRES   1 A  149  MET ALA SER LYS ILE GLU GLN PRO ARG TRP ALA SER LYS          
SEQRES   2 A  149  ASP SER ALA ALA GLY ALA ALA SER THR PRO ASP GLU LYS          
SEQRES   3 A  149  ILE VAL LEU GLU PHE MSE ASP ALA LEU THR SER ASN ASP          
SEQRES   4 A  149  ALA ALA LYS LEU ILE GLU TYR PHE ALA GLU ASP THR MSE          
SEQRES   5 A  149  TYR GLN ASN MSE PRO LEU PRO PRO ALA TYR GLY ARG ASP          
SEQRES   6 A  149  ALA VAL GLU GLN THR LEU ALA GLY LEU PHE THR VAL MSE          
SEQRES   7 A  149  SER ILE ASP ALA VAL GLU THR PHE HIS ILE GLY SER SER          
SEQRES   8 A  149  ASN GLY LEU VAL TYR THR GLU ARG VAL ASP VAL LEU ARG          
SEQRES   9 A  149  ALA LEU PRO THR GLY LYS SER TYR ASN LEU SER ILE LEU          
SEQRES  10 A  149  GLY VAL PHE GLN LEU THR GLU GLY LYS ILE THR GLY TRP          
SEQRES  11 A  149  ARG ASP TYR PHE ASP LEU ARG GLU PHE GLU GLU ALA VAL          
SEQRES  12 A  149  ASP LEU PRO LEU ARG GLY                                      
SEQRES   1 B  149  MET ALA SER LYS ILE GLU GLN PRO ARG TRP ALA SER LYS          
SEQRES   2 B  149  ASP SER ALA ALA GLY ALA ALA SER THR PRO ASP GLU LYS          
SEQRES   3 B  149  ILE VAL LEU GLU PHE MSE ASP ALA LEU THR SER ASN ASP          
SEQRES   4 B  149  ALA ALA LYS LEU ILE GLU TYR PHE ALA GLU ASP THR MSE          
SEQRES   5 B  149  TYR GLN ASN MSE PRO LEU PRO PRO ALA TYR GLY ARG ASP          
SEQRES   6 B  149  ALA VAL GLU GLN THR LEU ALA GLY LEU PHE THR VAL MSE          
SEQRES   7 B  149  SER ILE ASP ALA VAL GLU THR PHE HIS ILE GLY SER SER          
SEQRES   8 B  149  ASN GLY LEU VAL TYR THR GLU ARG VAL ASP VAL LEU ARG          
SEQRES   9 B  149  ALA LEU PRO THR GLY LYS SER TYR ASN LEU SER ILE LEU          
SEQRES  10 B  149  GLY VAL PHE GLN LEU THR GLU GLY LYS ILE THR GLY TRP          
SEQRES  11 B  149  ARG ASP TYR PHE ASP LEU ARG GLU PHE GLU GLU ALA VAL          
SEQRES  12 B  149  ASP LEU PRO LEU ARG GLY                                      
HET    MSE  A  32       8                                                       
HET    MSE  A  52       8                                                       
HET    MSE  A  56       8                                                       
HET    MSE  A  78       8                                                       
HET    MSE  B  32       8                                                       
HET    MSE  B  52       8                                                       
HET    MSE  B  56       8                                                       
HET    MSE  B  78       8                                                       
HET    MES   3001      12                                                       
HET    VPR   4001      10                                                       
HET    VPR   5001      10                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
HETNAM     VPR 2-PROPYLPENTANAMIDE                                              
HETSYN     VPR VALPROMIDE                                                       
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  MES    C6 H13 N O4 S                                                
FORMUL   4  VPR    2(C8 H17 N O)                                                
FORMUL   6  HOH   *330(H2 O)                                                    
CRYST1   45.596   47.656  129.244  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1135  N   SER B   3      11.748  -0.816  23.080  1.00 34.01           N  
ATOM   1136  CA  SER B   3      12.042  -0.179  21.749  1.00 32.43           C  
ATOM   1137  C   SER B   3      13.441  -0.633  21.236  1.00 31.19           C  
ATOM   1138  O   SER B   3      14.350   0.178  20.913  1.00 30.26           O  
ATOM   1139  CB  SER B   3      11.851   1.336  21.812  1.00 32.84           C  
ATOM   1140  OG  SER B   3      12.109   1.906  23.081  1.00 36.43           O  
ATOM   1141  N   LYS B   4      13.578  -1.966  21.203  1.00 29.05           N  
ATOM   1142  CA  LYS B   4      14.754  -2.656  20.679  1.00 28.55           C  
ATOM   1143  C   LYS B   4      14.944  -2.323  19.188  1.00 27.33           C  
ATOM   1144  O   LYS B   4      13.973  -2.216  18.441  1.00 26.79           O  
ATOM   1145  CB  LYS B   4      14.574  -4.165  20.845  1.00 28.97           C  
ATOM   1146  CG  LYS B   4      15.833  -4.991  20.566  1.00 31.72           C  
ATOM   1147  CD  LYS B   4      15.479  -6.500  20.363  1.00 33.56           C  
ATOM   1148  CE  LYS B   4      16.555  -7.244  19.536  1.00 34.47           C  
ATOM   1149  NZ  LYS B   4      16.325  -8.751  19.403  1.00 36.67           N  
ATOM   1150  N   ILE B   5      16.194  -2.144  18.772  1.00 26.24           N  
ATOM   1151  CA  ILE B   5      16.493  -2.014  17.350  1.00 26.00           C  
ATOM   1152  C   ILE B   5      17.232  -3.239  16.872  1.00 27.59           C  
ATOM   1153  O   ILE B   5      18.319  -3.553  17.358  1.00 28.02           O  
ATOM   1154  CB  ILE B   5      17.304  -0.745  17.094  1.00 24.53           C  
ATOM   1155  CG1 ILE B   5      16.432   0.459  17.470  1.00 21.85           C  
ATOM   1156  CG2 ILE B   5      17.716  -0.640  15.610  1.00 23.28           C  
ATOM   1157  CD1 ILE B   5      17.176   1.744  17.469  1.00 24.10           C  
ATOM   1158  N   GLU B   6      16.653  -3.874  15.862  1.00 29.31           N  
ATOM   1159  CA  GLU B   6      17.246  -5.059  15.266  1.00 30.59           C  
ATOM   1160  C   GLU B   6      18.359  -4.684  14.262  1.00 29.24           C  
ATOM   1161  O   GLU B   6      18.159  -3.797  13.394  1.00 29.41           O  
ATOM   1162  CB  GLU B   6      16.160  -5.870  14.559  1.00 31.60           C  
ATOM   1163  CG  GLU B   6      16.157  -7.351  14.950  1.00 35.38           C  
ATOM   1164  CD  GLU B   6      15.169  -7.681  16.066  1.00 40.91           C  
ATOM   1165  OE1 GLU B   6      14.707  -6.754  16.796  1.00 46.38           O  
ATOM   1166  OE2 GLU B   6      14.859  -8.884  16.233  1.00 45.15           O  
ATOM   1167  N   GLN B   7      19.503  -5.357  14.398  1.00 27.64           N  
ATOM   1168  CA  GLN B   7      20.580  -5.270  13.418  1.00 26.18           C  
ATOM   1169  C   GLN B   7      20.158  -5.967  12.117  1.00 23.13           C  
ATOM   1170  O   GLN B   7      19.858  -7.161  12.089  1.00 21.91           O  
ATOM   1171  CB  GLN B   7      21.875  -5.868  13.951  1.00 26.37           C  
ATOM   1172  CG  GLN B   7      23.133  -5.325  13.230  1.00 30.43           C  
ATOM   1173  CD  GLN B   7      23.605  -3.960  13.752  1.00 32.25           C  
ATOM   1174  OE1 GLN B   7      22.970  -3.369  14.659  1.00 36.53           O  
ATOM   1175  NE2 GLN B   7      24.705  -3.450  13.182  1.00 34.48           N  
ATOM   1176  N   PRO B   8      20.096  -5.197  11.033  1.00 19.45           N  
ATOM   1177  CA  PRO B   8      19.613  -5.739   9.760  1.00 17.00           C  
ATOM   1178  C   PRO B   8      20.478  -6.809   9.141  1.00 15.40           C  
ATOM   1179  O   PRO B   8      21.706  -6.818   9.315  1.00 14.65           O  
ATOM   1180  CB  PRO B   8      19.549  -4.511   8.853  1.00 17.20           C  
ATOM   1181  CG  PRO B   8      20.439  -3.565   9.448  1.00 19.17           C  
ATOM   1182  CD  PRO B   8      20.463  -3.773  10.931  1.00 19.02           C  
ATOM   1183  N   ARG B   9      19.843  -7.716   8.405  1.00 14.36           N  
ATOM   1184  CA  ARG B   9      20.586  -8.768   7.686  1.00 14.88           C  
ATOM   1185  C   ARG B   9      21.550  -8.176   6.697  1.00 14.47           C  
ATOM   1186  O   ARG B   9      22.529  -8.821   6.346  1.00 15.64           O  
ATOM   1187  CB  ARG B   9      19.627  -9.738   6.942  1.00 14.60           C  
ATOM   1188  CG  ARG B   9      18.952 -10.713   7.850  1.00 16.16           C  
ATOM   1189  CD  ARG B   9      17.686 -11.353   7.281  1.00 16.48           C  
ATOM   1190  NE  ARG B   9      18.002 -12.280   6.205  1.00 14.82           N  
ATOM   1191  CZ  ARG B   9      17.121 -12.742   5.319  1.00 16.61           C  
ATOM   1192  NH1 ARG B   9      15.848 -12.415   5.420  1.00 18.75           N  
ATOM   1193  NH2 ARG B   9      17.499 -13.570   4.366  1.00 15.87           N  
ATOM   1194  N   TRP B  10      21.231  -6.961   6.217  1.00 14.08           N  
ATOM   1195  CA  TRP B  10      22.014  -6.257   5.253  1.00 13.29           C  
ATOM   1196  C   TRP B  10      23.096  -5.333   5.760  1.00 13.42           C  
ATOM   1197  O   TRP B  10      23.827  -4.730   4.952  1.00 15.30           O  
ATOM   1198  CB  TRP B  10      21.105  -5.491   4.260  1.00 13.67           C  
ATOM   1199  CG  TRP B  10      20.033  -4.705   4.858  1.00  9.56           C  
ATOM   1200  CD1 TRP B  10      18.738  -5.025   4.860  1.00 11.32           C  
ATOM   1201  CD2 TRP B  10      20.125  -3.417   5.494  1.00 10.28           C  
ATOM   1202  NE1 TRP B  10      17.995  -4.055   5.461  1.00 12.65           N  
ATOM   1203  CE2 TRP B  10      18.825  -3.051   5.870  1.00 11.30           C  
ATOM   1204  CE3 TRP B  10      21.176  -2.558   5.808  1.00 10.78           C  
ATOM   1205  CZ2 TRP B  10      18.535  -1.889   6.529  1.00  9.21           C  
ATOM   1206  CZ3 TRP B  10      20.887  -1.382   6.456  1.00 11.20           C  
ATOM   1207  CH2 TRP B  10      19.555  -1.050   6.820  1.00 10.09           C  
ATOM   1208  N   ALA B  11      23.268  -5.251   7.072  1.00 14.40           N  
ATOM   1209  CA  ALA B  11      24.346  -4.452   7.665  1.00 14.75           C  
ATOM   1210  C   ALA B  11      25.716  -4.801   7.086  1.00 16.88           C  
ATOM   1211  O   ALA B  11      26.076  -6.000   6.876  1.00 16.34           O  
ATOM   1212  CB  ALA B  11      24.366  -4.601   9.144  1.00 15.43           C  
ATOM   1213  N   SER B  12      26.489  -3.756   6.798  1.00 15.94           N  
ATOM   1214  CA  SER B  12      27.842  -3.950   6.288  1.00 16.86           C  
ATOM   1215  C   SER B  12      28.693  -4.657   7.356  1.00 17.02           C  
ATOM   1216  O   SER B  12      28.560  -4.363   8.539  1.00 16.69           O  
ATOM   1217  CB  SER B  12      28.497  -2.603   5.991  1.00 16.86           C  
ATOM   1218  OG  SER B  12      29.874  -2.834   5.707  1.00 21.27           O  
ATOM   1219  N   LYS B  13      29.590  -5.566   6.918  1.00 18.82           N  
ATOM   1220  CA  LYS B  13      30.541  -6.243   7.831  1.00 21.15           C  
ATOM   1221  C   LYS B  13      31.912  -5.519   7.858  1.00 22.43           C  
ATOM   1222  O   LYS B  13      32.882  -5.955   8.489  1.00 22.00           O  
ATOM   1223  CB  LYS B  13      30.664  -7.718   7.425  1.00 22.39           C  
ATOM   1224  CG  LYS B  13      29.364  -8.522   7.720  1.00 23.86           C  
ATOM   1225  CD  LYS B  13      29.075  -9.597   6.675  1.00 29.86           C  
ATOM   1226  CE  LYS B  13      28.023 -10.636   7.168  1.00 30.48           C  
ATOM   1227  NZ  LYS B  13      28.597 -12.051   7.419  1.00 30.37           N  
ATOM   1228  N   ASP B  14      31.962  -4.349   7.222  1.00 23.50           N  
ATOM   1229  CA  ASP B  14      33.124  -3.460   7.315  1.00 23.74           C  
ATOM   1230  C   ASP B  14      32.945  -2.549   8.558  1.00 23.76           C  
ATOM   1231  O   ASP B  14      32.069  -1.681   8.572  1.00 24.08           O  
ATOM   1232  CB  ASP B  14      33.166  -2.710   5.972  1.00 24.48           C  
ATOM   1233  CG  ASP B  14      34.452  -1.921   5.740  1.00 25.24           C  
ATOM   1234  OD1 ASP B  14      34.886  -1.210   6.652  1.00 30.23           O  
ATOM   1235  OD2 ASP B  14      35.064  -1.964   4.657  1.00 29.91           O  
ATOM   1236  N   SER B  15      33.768  -2.707   9.609  1.00 24.72           N  
ATOM   1237  CA  SER B  15      33.665  -1.831  10.832  1.00 24.93           C  
ATOM   1238  C   SER B  15      33.724  -0.325  10.616  1.00 24.91           C  
ATOM   1239  O   SER B  15      33.057   0.461  11.339  1.00 26.20           O  
ATOM   1240  CB  SER B  15      34.734  -2.173  11.870  1.00 24.92           C  
ATOM   1241  OG  SER B  15      34.176  -3.118  12.796  1.00 26.40           O  
ATOM   1242  N   ALA B  16      34.517   0.086   9.635  1.00 23.72           N  
ATOM   1243  CA  ALA B  16      34.651   1.499   9.351  1.00 23.23           C  
ATOM   1244  C   ALA B  16      33.328   2.034   8.819  1.00 22.67           C  
ATOM   1245  O   ALA B  16      33.063   3.224   8.970  1.00 24.20           O  
ATOM   1246  CB  ALA B  16      35.792   1.786   8.384  1.00 22.36           C  
ATOM   1247  N   ALA B  17      32.541   1.163   8.188  1.00 22.90           N  
ATOM   1248  CA  ALA B  17      31.220   1.552   7.663  1.00 22.18           C  
ATOM   1249  C   ALA B  17      30.282   2.043   8.761  1.00 21.24           C  
ATOM   1250  O   ALA B  17      29.418   2.868   8.473  1.00 20.61           O  
ATOM   1251  CB  ALA B  17      30.564   0.412   6.849  1.00 22.98           C  
ATOM   1252  N   GLY B  18      30.422   1.500   9.971  1.00 19.80           N  
ATOM   1253  CA  GLY B  18      29.560   1.804  11.093  1.00 19.83           C  
ATOM   1254  C   GLY B  18      30.140   2.810  12.067  1.00 20.82           C  
ATOM   1255  O   GLY B  18      29.512   3.146  13.078  1.00 24.08           O  
ATOM   1256  N   ALA B  19      31.334   3.304  11.791  1.00 18.74           N  
ATOM   1257  CA  ALA B  19      31.963   4.264  12.691  1.00 18.03           C  
ATOM   1258  C   ALA B  19      32.331   5.572  11.941  1.00 16.42           C  
ATOM   1259  O   ALA B  19      32.559   5.592  10.731  1.00 17.01           O  
ATOM   1260  CB  ALA B  19      33.212   3.632  13.371  1.00 18.57           C  
ATOM   1261  N   ALA B  20      32.297   6.687  12.669  1.00 17.22           N  
ATOM   1262  CA  ALA B  20      32.715   7.976  12.068  1.00 17.73           C  
ATOM   1263  C   ALA B  20      34.213   7.937  11.751  1.00 18.54           C  
ATOM   1264  O   ALA B  20      35.017   7.579  12.617  1.00 18.71           O  
ATOM   1265  CB  ALA B  20      32.415   9.123  13.004  1.00 18.08           C  
ATOM   1266  N   SER B  21      34.537   8.270  10.504  1.00 16.63           N  
ATOM   1267  CA  SER B  21      35.883   8.244   9.950  1.00 17.36           C  
ATOM   1268  C   SER B  21      36.468   9.571   9.541  1.00 16.92           C  
ATOM   1269  O   SER B  21      37.602   9.617   9.029  1.00 17.12           O  
ATOM   1270  CB  SER B  21      35.941   7.270   8.783  1.00 17.20           C  
ATOM   1271  OG  SER B  21      35.512   6.017   9.235  1.00 18.34           O  
ATOM   1272  N   THR B  22      35.703  10.658   9.705  1.00 16.48           N  
ATOM   1273  CA  THR B  22      36.177  12.006   9.446  1.00 15.25           C  
ATOM   1274  C   THR B  22      35.656  12.944  10.519  1.00 16.15           C  
ATOM   1275  O   THR B  22      34.707  12.594  11.236  1.00 14.86           O  
ATOM   1276  CB  THR B  22      35.703  12.571   8.092  1.00 16.02           C  
ATOM   1277  OG1 THR B  22      34.314  12.884   8.186  1.00 13.37           O  
ATOM   1278  CG2 THR B  22      35.861  11.586   6.948  1.00 16.72           C  
ATOM   1279  N   PRO B  23      36.279  14.111  10.687  1.00 16.25           N  
ATOM   1280  CA  PRO B  23      35.744  15.082  11.640  1.00 16.71           C  
ATOM   1281  C   PRO B  23      34.228  15.416  11.405  1.00 15.20           C  
ATOM   1282  O   PRO B  23      33.505  15.467  12.368  1.00 15.65           O  
ATOM   1283  CB  PRO B  23      36.608  16.313  11.395  1.00 17.23           C  
ATOM   1284  CG  PRO B  23      37.952  15.750  11.068  1.00 17.87           C  
ATOM   1285  CD  PRO B  23      37.587  14.559  10.145  1.00 17.47           C  
ATOM   1286  N   ASP B  24      33.811  15.641  10.181  1.00 15.45           N  
ATOM   1287  CA  ASP B  24      32.379  15.942   9.892  1.00 14.95           C  
ATOM   1288  C   ASP B  24      31.497  14.760  10.262  1.00 14.74           C  
ATOM   1289  O   ASP B  24      30.388  14.933  10.817  1.00 14.20           O  
ATOM   1290  CB  ASP B  24      32.161  16.244   8.433  1.00 15.64           C  
ATOM   1291  CG  ASP B  24      32.530  17.654   8.028  1.00 17.80           C  
ATOM   1292  OD1 ASP B  24      32.895  18.498   8.892  1.00 18.83           O  
ATOM   1293  OD2 ASP B  24      32.460  17.959   6.804  1.00 17.77           O  
ATOM   1294  N   GLU B  25      31.963  13.546   9.986  1.00 13.00           N  
ATOM   1295  CA  GLU B  25      31.150  12.383  10.359  1.00 13.14           C  
ATOM   1296  C   GLU B  25      31.028  12.291  11.857  1.00 13.54           C  
ATOM   1297  O   GLU B  25      30.013  11.891  12.351  1.00 14.06           O  
ATOM   1298  CB  GLU B  25      31.706  11.070   9.773  1.00 12.61           C  
ATOM   1299  CG  GLU B  25      31.635  10.991   8.253  1.00 14.55           C  
ATOM   1300  CD  GLU B  25      32.280   9.767   7.686  1.00 10.61           C  
ATOM   1301  OE1 GLU B  25      32.543   8.809   8.455  1.00 12.27           O  
ATOM   1302  OE2 GLU B  25      32.500   9.740   6.463  1.00 14.37           O  
ATOM   1303  N   LYS B  26      32.072  12.688  12.606  1.00 13.50           N  
ATOM   1304  CA  LYS B  26      31.998  12.613  14.055  1.00 15.46           C  
ATOM   1305  C   LYS B  26      30.960  13.574  14.612  1.00 14.05           C  
ATOM   1306  O   LYS B  26      30.243  13.227  15.519  1.00 14.39           O  
ATOM   1307  CB  LYS B  26      33.386  12.903  14.678  1.00 17.19           C  
ATOM   1308  CG  LYS B  26      34.288  11.707  14.500  1.00 21.94           C  
ATOM   1309  CD  LYS B  26      35.678  11.870  15.236  1.00 27.65           C  
ATOM   1310  CE  LYS B  26      36.441  10.538  15.262  1.00 30.82           C  
ATOM   1311  NZ  LYS B  26      36.581   9.873  13.898  1.00 33.57           N  
ATOM   1312  N   ILE B  27      30.865  14.767  14.040  1.00 13.97           N  
ATOM   1313  CA  ILE B  27      29.889  15.730  14.527  1.00 13.95           C  
ATOM   1314  C   ILE B  27      28.473  15.199  14.231  1.00 13.25           C  
ATOM   1315  O   ILE B  27      27.581  15.300  15.076  1.00 13.11           O  
ATOM   1316  CB  ILE B  27      30.077  17.068  13.837  1.00 14.37           C  
ATOM   1317  CG1 ILE B  27      31.378  17.723  14.303  1.00 16.53           C  
ATOM   1318  CG2 ILE B  27      28.895  18.028  14.101  1.00 14.72           C  
ATOM   1319  CD1 ILE B  27      31.946  18.579  13.260  1.00 19.79           C  
ATOM   1320  N   VAL B  28      28.292  14.647  13.033  1.00 13.63           N  
ATOM   1321  CA  VAL B  28      26.968  14.075  12.680  1.00 12.80           C  
ATOM   1322  C   VAL B  28      26.540  13.020  13.710  1.00 12.60           C  
ATOM   1323  O   VAL B  28      25.379  13.013  14.140  1.00 12.69           O  
ATOM   1324  CB  VAL B  28      26.953  13.537  11.240  1.00 13.21           C  
ATOM   1325  CG1 VAL B  28      25.729  12.711  10.997  1.00 13.54           C  
ATOM   1326  CG2 VAL B  28      27.036  14.706  10.274  1.00 13.09           C  
ATOM   1327  N   LEU B  29      27.438  12.119  14.103  1.00 12.47           N  
ATOM   1328  CA  LEU B  29      27.114  11.120  15.123  1.00 12.76           C  
ATOM   1329  C   LEU B  29      26.853  11.733  16.520  1.00 13.73           C  
ATOM   1330  O   LEU B  29      25.992  11.245  17.275  1.00 13.32           O  
ATOM   1331  CB  LEU B  29      28.153   9.996  15.194  1.00 12.53           C  
ATOM   1332  CG  LEU B  29      28.275   9.097  13.955  1.00 13.06           C  
ATOM   1333  CD1 LEU B  29      29.249   7.920  14.225  1.00 14.00           C  
ATOM   1334  CD2 LEU B  29      26.911   8.543  13.603  1.00 15.07           C  
ATOM   1335  N   GLU B  30      27.578  12.811  16.857  1.00 14.64           N  
ATOM   1336  CA  GLU B  30      27.297  13.530  18.098  1.00 15.99           C  
ATOM   1337  C   GLU B  30      25.881  14.076  18.033  1.00 14.54           C  
ATOM   1338  O   GLU B  30      25.123  14.021  19.016  1.00 14.70           O  
ATOM   1339  CB  GLU B  30      28.280  14.690  18.299  1.00 16.32           C  
ATOM   1340  CG  GLU B  30      29.652  14.250  18.730  1.00 21.18           C  
ATOM   1341  CD  GLU B  30      30.718  15.359  18.597  1.00 27.30           C  
ATOM   1342  OE1 GLU B  30      30.363  16.561  18.379  1.00 32.52           O  
ATOM   1343  OE2 GLU B  30      31.927  15.009  18.681  1.00 30.37           O  
ATOM   1344  N   PHE B  31      25.535  14.600  16.866  1.00 14.14           N  
ATOM   1345  CA  PHE B  31      24.209  15.185  16.647  1.00 13.49           C  
ATOM   1346  C   PHE B  31      23.106  14.123  16.748  1.00 13.33           C  
ATOM   1347  O   PHE B  31      22.071  14.373  17.377  1.00 12.93           O  
ATOM   1348  CB  PHE B  31      24.171  15.959  15.317  1.00 11.69           C  
ATOM   1349  CG  PHE B  31      22.847  16.619  15.028  1.00 12.23           C  
ATOM   1350  CD1 PHE B  31      22.324  17.559  15.883  1.00 14.26           C  
ATOM   1351  CD2 PHE B  31      22.135  16.319  13.885  1.00 13.62           C  
ATOM   1352  CE1 PHE B  31      21.118  18.193  15.621  1.00 16.17           C  
ATOM   1353  CE2 PHE B  31      20.930  16.960  13.614  1.00 12.39           C  
ATOM   1354  CZ  PHE B  31      20.412  17.897  14.479  1.00 15.26           C  
HETATM 1355  N   MSE B  32      23.367  12.913  16.224  1.00 12.81           N  
HETATM 1356  CA  MSE B  32      22.407  11.816  16.317  1.00 13.92           C  
HETATM 1357  C   MSE B  32      22.190  11.433  17.800  1.00 14.52           C  
HETATM 1358  O   MSE B  32      21.058  11.211  18.213  1.00 13.97           O  
HETATM 1359  CB  MSE B  32      22.852  10.591  15.516  1.00 13.83           C  
HETATM 1360  CG  MSE B  32      22.949  10.834  14.040  1.00 15.03           C  
HETATM 1361 SE   MSE B  32      21.232  11.208  13.227  1.00 16.49          SE  
HETATM 1362  CE  MSE B  32      21.331  12.976  13.100  1.00 11.44           C  
ATOM   1363  N   ASP B  33      23.281  11.416  18.583  1.00 14.10           N  
ATOM   1364  CA  ASP B  33      23.201  11.171  20.036  1.00 16.06           C  
ATOM   1365  C   ASP B  33      22.350  12.228  20.719  1.00 15.95           C  
ATOM   1366  O   ASP B  33      21.562  11.900  21.611  1.00 17.08           O  
ATOM   1367  CB  ASP B  33      24.583  11.149  20.704  1.00 16.43           C  
ATOM   1368  CG  ASP B  33      25.358   9.876  20.429  1.00 22.86           C  
ATOM   1369  OD1 ASP B  33      24.770   8.874  19.905  1.00 25.86           O  
ATOM   1370  OD2 ASP B  33      26.603   9.806  20.655  1.00 28.93           O  
ATOM   1371  N   ALA B  34      22.481  13.463  20.288  1.00 14.93           N  
ATOM   1372  CA  ALA B  34      21.766  14.588  20.892  1.00 15.79           C  
ATOM   1373  C   ALA B  34      20.273  14.576  20.615  1.00 15.97           C  
ATOM   1374  O   ALA B  34      19.499  15.099  21.399  1.00 16.88           O  
ATOM   1375  CB  ALA B  34      22.370  15.913  20.405  1.00 15.40           C  
ATOM   1376  N   LEU B  35      19.861  13.958  19.513  1.00 14.90           N  
ATOM   1377  CA  LEU B  35      18.426  13.994  19.109  1.00 14.52           C  
ATOM   1378  C   LEU B  35      17.494  13.511  20.205  1.00 14.56           C  
ATOM   1379  O   LEU B  35      16.384  13.998  20.287  1.00 13.51           O  
ATOM   1380  CB  LEU B  35      18.193  13.163  17.866  1.00 14.34           C  
ATOM   1381  CG  LEU B  35      18.628  13.792  16.536  1.00 15.32           C  
ATOM   1382  CD1 LEU B  35      18.258  12.855  15.403  1.00 16.46           C  
ATOM   1383  CD2 LEU B  35      18.075  15.134  16.298  1.00 18.76           C  
ATOM   1384  N   THR B  36      17.952  12.572  21.049  1.00 13.68           N  
ATOM   1385  CA  THR B  36      17.122  12.008  22.133  1.00 14.11           C  
ATOM   1386  C   THR B  36      16.836  13.003  23.272  1.00 13.21           C  
ATOM   1387  O   THR B  36      15.985  12.729  24.178  1.00 15.03           O  
ATOM   1388  CB  THR B  36      17.699  10.707  22.722  1.00 14.36           C  
ATOM   1389  OG1 THR B  36      19.095  10.858  23.012  1.00 14.87           O  
ATOM   1390  CG2 THR B  36      17.660   9.549  21.712  1.00 17.19           C  
ATOM   1391  N   SER B  37      17.487  14.148  23.205  1.00 12.43           N  
ATOM   1392  CA  SER B  37      17.199  15.282  24.089  1.00 13.26           C  
ATOM   1393  C   SER B  37      15.789  15.816  23.891  1.00 13.99           C  
ATOM   1394  O   SER B  37      15.227  16.441  24.784  1.00 12.36           O  
ATOM   1395  CB  SER B  37      18.213  16.406  23.874  1.00 14.22           C  
ATOM   1396  OG  SER B  37      18.031  17.185  22.670  1.00 14.90           O  
ATOM   1397  N   ASN B  38      15.223  15.614  22.701  1.00 13.56           N  
ATOM   1398  CA  ASN B  38      13.945  16.229  22.334  1.00 13.91           C  
ATOM   1399  C   ASN B  38      13.891  17.739  22.570  1.00 13.76           C  
ATOM   1400  O   ASN B  38      12.837  18.300  22.896  1.00 13.54           O  
ATOM   1401  CB  ASN B  38      12.788  15.539  23.036  1.00 13.70           C  
ATOM   1402  CG  ASN B  38      12.678  14.092  22.676  1.00 15.33           C  
ATOM   1403  OD1 ASN B  38      12.649  13.728  21.491  1.00 12.89           O  
ATOM   1404  ND2 ASN B  38      12.536  13.251  23.697  1.00 17.07           N  
ATOM   1405  N   ASP B  39      15.027  18.388  22.369  1.00 13.68           N  
ATOM   1406  CA  ASP B  39      15.206  19.771  22.792  1.00 14.22           C  
ATOM   1407  C   ASP B  39      15.673  20.653  21.630  1.00 13.66           C  
ATOM   1408  O   ASP B  39      16.843  20.673  21.297  1.00 13.41           O  
ATOM   1409  CB  ASP B  39      16.187  19.852  23.980  1.00 14.26           C  
ATOM   1410  CG  ASP B  39      16.297  21.263  24.556  1.00 18.00           C  
ATOM   1411  OD1 ASP B  39      15.887  22.259  23.923  1.00 15.79           O  
ATOM   1412  OD2 ASP B  39      16.794  21.446  25.679  1.00 23.75           O  
ATOM   1413  N   ALA B  40      14.748  21.363  21.007  1.00 14.24           N  
ATOM   1414  CA  ALA B  40      15.030  22.105  19.818  1.00 14.36           C  
ATOM   1415  C   ALA B  40      16.031  23.228  20.064  1.00 16.04           C  
ATOM   1416  O   ALA B  40      16.887  23.520  19.216  1.00 15.17           O  
ATOM   1417  CB  ALA B  40      13.732  22.641  19.189  1.00 14.63           C  
ATOM   1418  N   ALA B  41      15.916  23.879  21.209  1.00 17.83           N  
ATOM   1419  CA  ALA B  41      16.878  24.935  21.608  1.00 19.05           C  
ATOM   1420  C   ALA B  41      18.317  24.423  21.705  1.00 19.28           C  
ATOM   1421  O   ALA B  41      19.269  25.105  21.271  1.00 21.02           O  
ATOM   1422  CB  ALA B  41      16.414  25.575  22.945  1.00 20.46           C  
ATOM   1423  N   LYS B  42      18.499  23.227  22.244  1.00 18.57           N  
ATOM   1424  CA  LYS B  42      19.817  22.609  22.330  1.00 20.39           C  
ATOM   1425  C   LYS B  42      20.301  22.238  20.916  1.00 18.97           C  
ATOM   1426  O   LYS B  42      21.440  22.538  20.515  1.00 19.78           O  
ATOM   1427  CB  LYS B  42      19.711  21.346  23.218  1.00 20.76           C  
ATOM   1428  CG  LYS B  42      20.900  20.422  23.223  1.00 24.66           C  
ATOM   1429  CD  LYS B  42      20.588  19.132  23.994  1.00 28.10           C  
ATOM   1430  CE  LYS B  42      21.774  18.219  23.957  1.00 30.61           C  
ATOM   1431  NZ  LYS B  42      21.655  17.103  24.908  1.00 32.65           N  
ATOM   1432  N   LEU B  43      19.417  21.589  20.162  1.00 17.34           N  
ATOM   1433  CA  LEU B  43      19.768  20.989  18.879  1.00 16.04           C  
ATOM   1434  C   LEU B  43      20.110  22.034  17.822  1.00 14.79           C  
ATOM   1435  O   LEU B  43      20.956  21.805  16.967  1.00 13.97           O  
ATOM   1436  CB  LEU B  43      18.637  20.056  18.412  1.00 15.48           C  
ATOM   1437  CG  LEU B  43      18.509  18.803  19.286  1.00 17.68           C  
ATOM   1438  CD1 LEU B  43      17.205  18.122  19.051  1.00 19.40           C  
ATOM   1439  CD2 LEU B  43      19.637  17.858  19.009  1.00 16.58           C  
ATOM   1440  N   ILE B  44      19.479  23.200  17.903  1.00 13.48           N  
ATOM   1441  CA  ILE B  44      19.688  24.241  16.945  1.00 13.66           C  
ATOM   1442  C   ILE B  44      21.124  24.804  16.974  1.00 13.76           C  
ATOM   1443  O   ILE B  44      21.572  25.354  15.978  1.00 13.76           O  
ATOM   1444  CB  ILE B  44      18.645  25.385  17.105  1.00 14.46           C  
ATOM   1445  CG1 ILE B  44      18.516  26.151  15.817  1.00 14.23           C  
ATOM   1446  CG2 ILE B  44      19.016  26.342  18.240  1.00 14.44           C  
ATOM   1447  CD1 ILE B  44      17.990  25.316  14.653  1.00 17.08           C  
ATOM   1448  N   GLU B  45      21.829  24.645  18.096  1.00 14.40           N  
ATOM   1449  CA  GLU B  45      23.245  25.082  18.181  1.00 15.70           C  
ATOM   1450  C   GLU B  45      24.143  24.352  17.148  1.00 15.93           C  
ATOM   1451  O   GLU B  45      25.172  24.877  16.737  1.00 16.00           O  
ATOM   1452  CB  GLU B  45      23.766  24.887  19.613  1.00 17.35           C  
ATOM   1453  CG  GLU B  45      22.973  25.643  20.688  1.00 20.92           C  
ATOM   1454  CD  GLU B  45      23.026  27.152  20.492  1.00 28.48           C  
ATOM   1455  OE1 GLU B  45      23.983  27.607  19.859  1.00 31.97           O  
ATOM   1456  OE2 GLU B  45      22.099  27.902  20.914  1.00 33.32           O  
ATOM   1457  N   TYR B  46      23.721  23.158  16.686  1.00 13.71           N  
ATOM   1458  CA  TYR B  46      24.439  22.442  15.634  1.00 13.72           C  
ATOM   1459  C   TYR B  46      24.346  23.091  14.252  1.00 12.88           C  
ATOM   1460  O   TYR B  46      25.112  22.728  13.361  1.00 15.67           O  
ATOM   1461  CB  TYR B  46      23.954  20.982  15.579  1.00 12.95           C  
ATOM   1462  CG  TYR B  46      24.458  20.103  16.703  1.00 13.47           C  
ATOM   1463  CD1 TYR B  46      23.769  19.999  17.884  1.00 15.70           C  
ATOM   1464  CD2 TYR B  46      25.618  19.340  16.560  1.00 16.00           C  
ATOM   1465  CE1 TYR B  46      24.214  19.184  18.932  1.00 18.35           C  
ATOM   1466  CE2 TYR B  46      26.066  18.510  17.576  1.00 18.40           C  
ATOM   1467  CZ  TYR B  46      25.376  18.456  18.775  1.00 18.93           C  
ATOM   1468  OH  TYR B  46      25.774  17.639  19.796  1.00 20.20           O  
ATOM   1469  N   PHE B  47      23.406  24.018  14.049  1.00 12.10           N  
ATOM   1470  CA  PHE B  47      23.093  24.571  12.737  1.00 12.16           C  
ATOM   1471  C   PHE B  47      23.754  25.919  12.502  1.00 13.94           C  
ATOM   1472  O   PHE B  47      23.834  26.746  13.405  1.00 14.04           O  
ATOM   1473  CB  PHE B  47      21.576  24.718  12.498  1.00 13.48           C  
ATOM   1474  CG  PHE B  47      20.859  23.416  12.496  1.00 10.65           C  
ATOM   1475  CD1 PHE B  47      20.697  22.703  13.662  1.00 13.15           C  
ATOM   1476  CD2 PHE B  47      20.379  22.900  11.313  1.00 10.79           C  
ATOM   1477  CE1 PHE B  47      20.057  21.483  13.694  1.00 12.10           C  
ATOM   1478  CE2 PHE B  47      19.737  21.696  11.304  1.00  9.86           C  
ATOM   1479  CZ  PHE B  47      19.539  20.979  12.501  1.00 12.15           C  
ATOM   1480  N   ALA B  48      24.177  26.132  11.271  1.00 13.87           N  
ATOM   1481  CA  ALA B  48      24.589  27.460  10.815  1.00 14.10           C  
ATOM   1482  C   ALA B  48      23.366  28.381  10.715  1.00 15.61           C  
ATOM   1483  O   ALA B  48      22.251  27.918  10.616  1.00 13.12           O  
ATOM   1484  CB  ALA B  48      25.225  27.356   9.497  1.00 15.08           C  
ATOM   1485  N   GLU B  49      23.586  29.706  10.675  1.00 16.48           N  
ATOM   1486  CA  GLU B  49      22.464  30.645  10.426  1.00 17.54           C  
ATOM   1487  C   GLU B  49      21.821  30.420   9.083  1.00 16.09           C  
ATOM   1488  O   GLU B  49      20.599  30.433   8.983  1.00 16.87           O  
ATOM   1489  CB  GLU B  49      22.906  32.135  10.505  1.00 18.18           C  
ATOM   1490  CG  GLU B  49      23.396  32.633  11.845  1.00 23.84           C  
ATOM   1491  CD  GLU B  49      23.945  34.069  11.763  1.00 30.79           C  
ATOM   1492  OE1 GLU B  49      24.727  34.381  10.815  1.00 34.67           O  
ATOM   1493  OE2 GLU B  49      23.611  34.897  12.648  1.00 35.19           O  
ATOM   1494  N   ASP B  50      22.631  30.193   8.046  1.00 15.40           N  
ATOM   1495  CA  ASP B  50      22.117  29.914   6.701  1.00 15.01           C  
ATOM   1496  C   ASP B  50      22.122  28.396   6.582  1.00 14.60           C  
ATOM   1497  O   ASP B  50      23.184  27.759   6.567  1.00 13.05           O  
ATOM   1498  CB  ASP B  50      22.980  30.529   5.623  1.00 15.90           C  
ATOM   1499  CG  ASP B  50      22.994  32.063   5.671  1.00 19.83           C  
ATOM   1500  OD1 ASP B  50      22.100  32.683   6.275  1.00 20.67           O  
ATOM   1501  OD2 ASP B  50      23.942  32.703   5.173  1.00 21.70           O  
ATOM   1502  N   THR B  51      20.941  27.829   6.571  1.00 12.83           N  
ATOM   1503  CA  THR B  51      20.804  26.372   6.687  1.00 11.78           C  
ATOM   1504  C   THR B  51      19.442  25.944   6.171  1.00 11.73           C  
ATOM   1505  O   THR B  51      18.606  26.764   5.812  1.00 12.30           O  
ATOM   1506  CB  THR B  51      21.011  25.971   8.148  1.00 13.55           C  
ATOM   1507  OG1 THR B  51      21.140  24.545   8.284  1.00 10.66           O  
ATOM   1508  CG2 THR B  51      19.845  26.380   9.020  1.00 11.82           C  
HETATM 1509  N   MSE B  52      19.211  24.641   6.140  1.00 11.91           N  
HETATM 1510  CA  MSE B  52      17.903  24.123   5.770  1.00 10.75           C  
HETATM 1511  C   MSE B  52      17.772  22.718   6.299  1.00 10.51           C  
HETATM 1512  O   MSE B  52      18.766  22.034   6.483  1.00 11.09           O  
HETATM 1513  CB  MSE B  52      17.669  24.128   4.249  1.00 10.12           C  
HETATM 1514  CG  MSE B  52      18.545  23.196   3.376  1.00 10.74           C  
HETATM 1515 SE   MSE B  52      17.909  21.294   3.314  1.00 13.63          SE  
HETATM 1516  CE  MSE B  52      16.270  21.576   2.715  1.00 10.21           C  
ATOM   1517  N   TYR B  53      16.529  22.331   6.560  1.00 10.52           N  
ATOM   1518  CA  TYR B  53      16.183  21.009   7.094  1.00  9.60           C  
ATOM   1519  C   TYR B  53      14.916  20.546   6.399  1.00  8.86           C  
ATOM   1520  O   TYR B  53      13.946  21.305   6.299  1.00  9.05           O  
ATOM   1521  CB  TYR B  53      15.871  21.156   8.590  1.00  9.32           C  
ATOM   1522  CG  TYR B  53      15.275  19.955   9.290  1.00 10.27           C  
ATOM   1523  CD1 TYR B  53      15.850  18.687   9.159  1.00 10.89           C  
ATOM   1524  CD2 TYR B  53      14.175  20.104  10.139  1.00 10.16           C  
ATOM   1525  CE1 TYR B  53      15.311  17.583   9.788  1.00  9.89           C  
ATOM   1526  CE2 TYR B  53      13.609  18.978  10.787  1.00 11.30           C  
ATOM   1527  CZ  TYR B  53      14.207  17.748  10.648  1.00  9.53           C  
ATOM   1528  OH  TYR B  53      13.692  16.669  11.321  1.00 10.37           O  
ATOM   1529  N   GLN B  54      14.898  19.298   5.951  1.00  8.64           N  
ATOM   1530  CA  GLN B  54      13.656  18.774   5.402  1.00  8.48           C  
ATOM   1531  C   GLN B  54      13.537  17.282   5.696  1.00  8.47           C  
ATOM   1532  O   GLN B  54      14.449  16.500   5.392  1.00  8.36           O  
ATOM   1533  CB  GLN B  54      13.601  18.997   3.889  1.00  8.84           C  
ATOM   1534  CG  GLN B  54      12.299  18.582   3.258  1.00  8.36           C  
ATOM   1535  CD  GLN B  54      12.207  18.810   1.729  1.00  8.19           C  
ATOM   1536  OE1 GLN B  54      13.145  19.316   1.072  1.00  9.99           O  
ATOM   1537  NE2 GLN B  54      11.057  18.423   1.153  1.00  8.19           N  
ATOM   1538  N   ASN B  55      12.387  16.924   6.266  1.00  8.79           N  
ATOM   1539  CA  ASN B  55      11.912  15.556   6.238  1.00  9.91           C  
ATOM   1540  C   ASN B  55      11.238  15.439   4.908  1.00  9.00           C  
ATOM   1541  O   ASN B  55      10.284  16.137   4.646  1.00 10.39           O  
ATOM   1542  CB  ASN B  55      10.945  15.292   7.353  1.00  9.27           C  
ATOM   1543  CG  ASN B  55      11.613  15.263   8.657  1.00 11.75           C  
ATOM   1544  OD1 ASN B  55      12.455  14.392   8.903  1.00 11.29           O  
ATOM   1545  ND2 ASN B  55      11.308  16.248   9.510  1.00 11.37           N  
HETATM 1546  N   MSE B  56      11.789  14.623   4.031  1.00  8.32           N  
HETATM 1547  CA  MSE B  56      11.413  14.685   2.626  1.00  8.13           C  
HETATM 1548  C   MSE B  56       9.927  14.495   2.271  1.00  8.27           C  
HETATM 1549  O   MSE B  56       9.498  15.042   1.255  1.00  8.44           O  
HETATM 1550  CB  MSE B  56      12.327  13.837   1.720  1.00  8.70           C  
HETATM 1551  CG  MSE B  56      13.802  14.206   1.730  1.00  7.15           C  
HETATM 1552 SE   MSE B  56      14.123  16.063   1.201  1.00 11.45          SE  
HETATM 1553  CE  MSE B  56      13.557  15.992  -0.606  1.00 11.48           C  
ATOM   1554  N   PRO B  57       9.137  13.752   3.037  1.00  8.36           N  
ATOM   1555  CA  PRO B  57       7.680  13.738   2.824  1.00  8.75           C  
ATOM   1556  C   PRO B  57       6.962  15.068   3.069  1.00 10.16           C  
ATOM   1557  O   PRO B  57       5.751  15.190   2.751  1.00 10.07           O  
ATOM   1558  CB  PRO B  57       7.176  12.707   3.846  1.00  9.04           C  
ATOM   1559  CG  PRO B  57       8.356  11.867   4.148  1.00  8.32           C  
ATOM   1560  CD  PRO B  57       9.539  12.805   4.076  1.00  8.75           C  
ATOM   1561  N   LEU B  58       7.671  16.019   3.683  1.00 11.13           N  
ATOM   1562  CA  LEU B  58       7.056  17.271   4.152  1.00 11.03           C  
ATOM   1563  C   LEU B  58       7.856  18.469   3.616  1.00 10.81           C  
ATOM   1564  O   LEU B  58       8.981  18.329   3.216  1.00  9.60           O  
ATOM   1565  CB  LEU B  58       7.069  17.318   5.677  1.00 11.31           C  
ATOM   1566  CG  LEU B  58       6.359  16.125   6.363  1.00 14.58           C  
ATOM   1567  CD1 LEU B  58       6.662  16.112   7.834  1.00 16.69           C  
ATOM   1568  CD2 LEU B  58       4.905  16.195   6.107  1.00 13.78           C  
ATOM   1569  N   PRO B  59       7.266  19.673   3.627  1.00 10.97           N  
ATOM   1570  CA  PRO B  59       7.964  20.850   3.077  1.00 10.42           C  
ATOM   1571  C   PRO B  59       9.258  21.188   3.812  1.00 10.54           C  
ATOM   1572  O   PRO B  59       9.347  20.938   5.029  1.00 10.45           O  
ATOM   1573  CB  PRO B  59       6.923  21.975   3.233  1.00 11.00           C  
ATOM   1574  CG  PRO B  59       5.648  21.245   3.124  1.00 12.69           C  
ATOM   1575  CD  PRO B  59       5.868  19.986   3.996  1.00 12.28           C  
ATOM   1576  N   PRO B  60      10.223  21.765   3.111  1.00 10.35           N  
ATOM   1577  CA  PRO B  60      11.498  22.161   3.727  1.00 10.93           C  
ATOM   1578  C   PRO B  60      11.360  23.431   4.555  1.00 12.09           C  
ATOM   1579  O   PRO B  60      10.466  24.223   4.332  1.00 12.10           O  
ATOM   1580  CB  PRO B  60      12.399  22.466   2.523  1.00 11.60           C  
ATOM   1581  CG  PRO B  60      11.448  22.908   1.500  1.00 11.82           C  
ATOM   1582  CD  PRO B  60      10.180  22.136   1.702  1.00 12.28           C  
ATOM   1583  N   ALA B  61      12.261  23.568   5.497  1.00 11.10           N  
ATOM   1584  CA  ALA B  61      12.441  24.738   6.327  1.00 12.10           C  
ATOM   1585  C   ALA B  61      13.739  25.389   5.903  1.00 11.02           C  
ATOM   1586  O   ALA B  61      14.790  24.730   5.960  1.00 10.44           O  
ATOM   1587  CB  ALA B  61      12.563  24.282   7.822  1.00 12.33           C  
ATOM   1588  N   TYR B  62      13.725  26.677   5.546  1.00 11.60           N  
ATOM   1589  CA  TYR B  62      14.940  27.393   5.177  1.00 11.47           C  
ATOM   1590  C   TYR B  62      15.261  28.464   6.194  1.00 10.94           C  
ATOM   1591  O   TYR B  62      14.361  29.221   6.591  1.00 12.08           O  
ATOM   1592  CB  TYR B  62      14.802  28.036   3.777  1.00 12.21           C  
ATOM   1593  CG  TYR B  62      15.022  27.030   2.688  1.00  9.92           C  
ATOM   1594  CD1 TYR B  62      16.257  26.786   2.177  1.00 14.11           C  
ATOM   1595  CD2 TYR B  62      13.978  26.314   2.177  1.00 13.46           C  
ATOM   1596  CE1 TYR B  62      16.455  25.837   1.159  1.00 14.32           C  
ATOM   1597  CE2 TYR B  62      14.172  25.361   1.200  1.00 13.92           C  
ATOM   1598  CZ  TYR B  62      15.412  25.126   0.699  1.00 13.86           C  
ATOM   1599  OH  TYR B  62      15.569  24.163  -0.292  1.00 19.96           O  
ATOM   1600  N   GLY B  63      16.513  28.486   6.629  1.00 11.75           N  
ATOM   1601  CA  GLY B  63      16.981  29.370   7.690  1.00 12.48           C  
ATOM   1602  C   GLY B  63      16.836  28.792   9.073  1.00 12.24           C  
ATOM   1603  O   GLY B  63      15.910  28.026   9.349  1.00 12.68           O  
ATOM   1604  N   ARG B  64      17.770  29.169   9.945  1.00 13.85           N  
ATOM   1605  CA  ARG B  64      17.895  28.574  11.261  1.00 14.35           C  
ATOM   1606  C   ARG B  64      16.622  28.745  12.082  1.00 13.89           C  
ATOM   1607  O   ARG B  64      16.199  27.794  12.756  1.00 13.31           O  
ATOM   1608  CB  ARG B  64      19.143  29.127  11.956  1.00 15.02           C  
ATOM   1609  CG  ARG B  64      19.585  28.476  13.242  1.00 17.20           C  
ATOM   1610  CD  ARG B  64      20.842  29.246  13.738  1.00 20.58           C  
ATOM   1611  NE  ARG B  64      21.597  28.703  14.866  1.00 26.58           N  
ATOM   1612  CZ  ARG B  64      21.300  28.915  16.141  1.00 27.10           C  
ATOM   1613  NH1 ARG B  64      20.202  29.599  16.488  1.00 29.04           N  
ATOM   1614  NH2 ARG B  64      22.106  28.438  17.088  1.00 26.41           N  
ATOM   1615  N   ASP B  65      15.938  29.886  11.988  1.00 14.01           N  
ATOM   1616  CA  ASP B  65      14.706  30.066  12.772  1.00 14.74           C  
ATOM   1617  C   ASP B  65      13.564  29.115  12.349  1.00 14.25           C  
ATOM   1618  O   ASP B  65      12.905  28.514  13.206  1.00 13.72           O  
ATOM   1619  CB  ASP B  65      14.208  31.510  12.701  1.00 16.59           C  
ATOM   1620  CG  ASP B  65      15.066  32.482  13.505  1.00 19.35           C  
ATOM   1621  OD1 ASP B  65      15.867  32.081  14.406  1.00 21.49           O  
ATOM   1622  OD2 ASP B  65      14.968  33.702  13.290  1.00 23.05           O  
ATOM   1623  N   ALA B  66      13.354  28.970  11.041  1.00 13.02           N  
ATOM   1624  CA  ALA B  66      12.366  28.053  10.500  1.00 12.40           C  
ATOM   1625  C   ALA B  66      12.721  26.637  10.936  1.00 11.92           C  
ATOM   1626  O   ALA B  66      11.828  25.878  11.301  1.00 11.50           O  
ATOM   1627  CB  ALA B  66      12.327  28.127   8.948  1.00 12.03           C  
ATOM   1628  N   VAL B  67      14.020  26.315  10.968  1.00 11.40           N  
ATOM   1629  CA  VAL B  67      14.443  24.971  11.329  1.00 11.33           C  
ATOM   1630  C   VAL B  67      14.084  24.725  12.805  1.00 12.65           C  
ATOM   1631  O   VAL B  67      13.507  23.713  13.153  1.00 12.30           O  
ATOM   1632  CB  VAL B  67      15.962  24.730  11.109  1.00 10.96           C  
ATOM   1633  CG1 VAL B  67      16.382  23.423  11.722  1.00 12.32           C  
ATOM   1634  CG2 VAL B  67      16.269  24.740   9.619  1.00 11.91           C  
ATOM   1635  N   GLU B  68      14.420  25.697  13.643  1.00 11.82           N  
ATOM   1636  CA  GLU B  68      14.186  25.558  15.055  1.00 12.69           C  
ATOM   1637  C   GLU B  68      12.695  25.414  15.340  1.00 12.54           C  
ATOM   1638  O   GLU B  68      12.297  24.617  16.187  1.00 12.83           O  
ATOM   1639  CB  GLU B  68      14.765  26.745  15.802  1.00 13.18           C  
ATOM   1640  CG  GLU B  68      14.772  26.468  17.301  1.00 13.60           C  
ATOM   1641  CD  GLU B  68      15.334  27.596  18.160  1.00 18.29           C  
ATOM   1642  OE1 GLU B  68      15.844  28.553  17.612  1.00 15.68           O  
ATOM   1643  OE2 GLU B  68      15.239  27.487  19.403  1.00 18.75           O  
ATOM   1644  N   GLN B  69      11.884  26.186  14.630  1.00 12.08           N  
ATOM   1645  CA  GLN B  69      10.446  26.167  14.810  1.00 11.89           C  
ATOM   1646  C   GLN B  69       9.841  24.833  14.393  1.00 12.02           C  
ATOM   1647  O   GLN B  69       8.907  24.349  15.021  1.00 11.30           O  
ATOM   1648  CB  GLN B  69       9.794  27.324  14.072  1.00 12.23           C  
ATOM   1649  CG  GLN B  69      10.074  28.662  14.696  1.00 13.54           C  
ATOM   1650  CD  GLN B  69       9.857  29.773  13.746  1.00 16.12           C  
ATOM   1651  OE1 GLN B  69       9.211  29.596  12.717  1.00 19.36           O  
ATOM   1652  NE2 GLN B  69      10.357  30.929  14.087  1.00 19.69           N  
ATOM   1653  N   THR B  70      10.392  24.246  13.335  1.00 11.17           N  
ATOM   1654  CA  THR B  70       9.959  22.952  12.874  1.00 11.25           C  
ATOM   1655  C   THR B  70      10.325  21.861  13.883  1.00 11.71           C  
ATOM   1656  O   THR B  70       9.507  21.039  14.203  1.00 11.12           O  
ATOM   1657  CB  THR B  70      10.644  22.647  11.545  1.00 11.43           C  
ATOM   1658  OG1 THR B  70      10.143  23.525  10.551  1.00 11.92           O  
ATOM   1659  CG2 THR B  70      10.284  21.267  11.045  1.00 12.06           C  
ATOM   1660  N   LEU B  71      11.559  21.843  14.343  1.00 11.01           N  
ATOM   1661  CA  LEU B  71      11.999  20.884  15.377  1.00 11.10           C  
ATOM   1662  C   LEU B  71      11.132  21.012  16.651  1.00 11.10           C  
ATOM   1663  O   LEU B  71      10.709  20.027  17.219  1.00  9.94           O  
ATOM   1664  CB  LEU B  71      13.475  21.069  15.715  1.00 12.12           C  
ATOM   1665  CG  LEU B  71      14.455  20.677  14.634  1.00 12.33           C  
ATOM   1666  CD1 LEU B  71      15.850  21.196  14.982  1.00 15.51           C  
ATOM   1667  CD2 LEU B  71      14.448  19.168  14.410  1.00 12.29           C  
ATOM   1668  N   ALA B  72      10.868  22.243  17.070  1.00 11.37           N  
ATOM   1669  CA  ALA B  72      10.031  22.471  18.240  1.00 11.66           C  
ATOM   1670  C   ALA B  72       8.616  21.905  18.090  1.00 11.37           C  
ATOM   1671  O   ALA B  72       8.041  21.376  19.035  1.00 12.21           O  
ATOM   1672  CB  ALA B  72       9.972  23.972  18.586  1.00 12.79           C  
ATOM   1673  N   GLY B  73       8.044  22.049  16.918  1.00 10.44           N  
ATOM   1674  CA  GLY B  73       6.761  21.473  16.611  1.00  9.91           C  
ATOM   1675  C   GLY B  73       6.860  19.963  16.632  1.00 10.24           C  
ATOM   1676  O   GLY B  73       5.989  19.314  17.216  1.00 11.40           O  
ATOM   1677  N   LEU B  74       7.882  19.387  15.982  1.00 10.97           N  
ATOM   1678  CA  LEU B  74       7.999  17.926  15.964  1.00 11.70           C  
ATOM   1679  C   LEU B  74       8.105  17.357  17.398  1.00 11.78           C  
ATOM   1680  O   LEU B  74       7.418  16.360  17.715  1.00 10.31           O  
ATOM   1681  CB  LEU B  74       9.139  17.462  15.072  1.00 13.59           C  
ATOM   1682  CG  LEU B  74       8.875  17.724  13.574  1.00 14.96           C  
ATOM   1683  CD1 LEU B  74      10.174  17.672  12.771  1.00 17.05           C  
ATOM   1684  CD2 LEU B  74       7.863  16.728  13.016  1.00 17.45           C  
ATOM   1685  N   PHE B  75       8.895  18.007  18.263  1.00 10.55           N  
ATOM   1686  CA  PHE B  75       9.095  17.523  19.632  1.00 10.73           C  
ATOM   1687  C   PHE B  75       7.889  17.809  20.533  1.00 10.80           C  
ATOM   1688  O   PHE B  75       7.844  17.337  21.658  1.00 11.49           O  
ATOM   1689  CB  PHE B  75      10.364  18.088  20.256  1.00  9.84           C  
ATOM   1690  CG  PHE B  75      11.634  17.583  19.624  1.00 10.43           C  
ATOM   1691  CD1 PHE B  75      11.802  16.203  19.388  1.00 11.70           C  
ATOM   1692  CD2 PHE B  75      12.633  18.476  19.218  1.00 14.29           C  
ATOM   1693  CE1 PHE B  75      12.960  15.725  18.806  1.00 12.84           C  
ATOM   1694  CE2 PHE B  75      13.792  18.000  18.604  1.00 12.34           C  
ATOM   1695  CZ  PHE B  75      13.954  16.631  18.416  1.00 12.73           C  
ATOM   1696  N   THR B  76       6.901  18.528  20.021  1.00  9.73           N  
ATOM   1697  CA  THR B  76       5.600  18.666  20.712  1.00 10.41           C  
ATOM   1698  C   THR B  76       4.710  17.442  20.527  1.00  9.73           C  
ATOM   1699  O   THR B  76       3.835  17.169  21.360  1.00  9.29           O  
ATOM   1700  CB  THR B  76       4.912  19.920  20.237  1.00 10.28           C  
ATOM   1701  OG1 THR B  76       5.768  21.036  20.497  1.00 11.21           O  
ATOM   1702  CG2 THR B  76       3.648  20.257  20.978  1.00 11.77           C  
ATOM   1703  N   VAL B  77       4.910  16.719  19.418  1.00 11.11           N  
ATOM   1704  CA  VAL B  77       4.099  15.581  19.125  1.00 10.58           C  
ATOM   1705  C   VAL B  77       4.767  14.233  19.233  1.00 10.41           C  
ATOM   1706  O   VAL B  77       4.052  13.243  19.266  1.00 10.63           O  
ATOM   1707  CB  VAL B  77       3.352  15.712  17.757  1.00 10.96           C  
ATOM   1708  CG1 VAL B  77       2.438  16.950  17.819  1.00 12.67           C  
ATOM   1709  CG2 VAL B  77       4.275  15.772  16.543  1.00 11.61           C  
HETATM 1710  N   MSE B  78       6.102  14.171  19.218  1.00 10.51           N  
HETATM 1711  CA  MSE B  78       6.787  12.893  19.287  1.00  9.81           C  
HETATM 1712  C   MSE B  78       8.047  13.029  20.112  1.00 10.68           C  
HETATM 1713  O   MSE B  78       8.584  14.108  20.226  1.00 11.20           O  
HETATM 1714  CB  MSE B  78       7.173  12.351  17.925  1.00 10.10           C  
HETATM 1715  CG  MSE B  78       8.186  13.158  17.239  1.00 11.21           C  
HETATM 1716 SE   MSE B  78       8.418  12.529  15.365  1.00 16.29          SE  
HETATM 1717  CE  MSE B  78       6.803  13.089  14.745  1.00 12.34           C  
ATOM   1718  N   SER B  79       8.486  11.918  20.706  1.00  9.67           N  
ATOM   1719  CA  SER B  79       9.802  11.786  21.310  1.00  9.21           C  
ATOM   1720  C   SER B  79      10.663  10.877  20.437  1.00  9.64           C  
ATOM   1721  O   SER B  79      10.197   9.830  19.994  1.00  9.67           O  
ATOM   1722  CB  SER B  79       9.696  11.173  22.732  1.00 10.51           C  
ATOM   1723  OG  SER B  79      10.971  10.801  23.253  1.00 11.70           O  
ATOM   1724  N   ILE B  80      11.904  11.281  20.197  1.00 10.72           N  
ATOM   1725  CA  ILE B  80      12.908  10.368  19.616  1.00 12.14           C  
ATOM   1726  C   ILE B  80      13.498   9.621  20.815  1.00 12.87           C  
ATOM   1727  O   ILE B  80      14.210  10.222  21.637  1.00 13.13           O  
ATOM   1728  CB  ILE B  80      13.990  11.102  18.857  1.00 12.54           C  
ATOM   1729  CG1 ILE B  80      13.375  11.938  17.721  1.00 13.87           C  
ATOM   1730  CG2 ILE B  80      15.031  10.078  18.278  1.00 12.60           C  
ATOM   1731  CD1 ILE B  80      14.346  12.935  17.067  1.00 13.91           C  
ATOM   1732  N   ASP B  81      13.130   8.360  20.949  1.00 12.70           N  
ATOM   1733  CA  ASP B  81      13.550   7.561  22.092  1.00 13.48           C  
ATOM   1734  C   ASP B  81      14.918   6.916  21.878  1.00 14.06           C  
ATOM   1735  O   ASP B  81      15.626   6.587  22.847  1.00 14.97           O  
ATOM   1736  CB  ASP B  81      12.491   6.515  22.395  1.00 13.74           C  
ATOM   1737  CG  ASP B  81      11.272   7.073  23.117  1.00 13.35           C  
ATOM   1738  OD1 ASP B  81      11.315   8.187  23.662  1.00 12.38           O  
ATOM   1739  OD2 ASP B  81      10.242   6.402  23.230  1.00 15.05           O  
ATOM   1740  N   ALA B  82      15.310   6.706  20.624  1.00 12.51           N  
ATOM   1741  CA  ALA B  82      16.613   6.107  20.314  1.00 13.61           C  
ATOM   1742  C   ALA B  82      16.964   6.384  18.845  1.00 13.76           C  
ATOM   1743  O   ALA B  82      16.064   6.519  18.001  1.00 12.37           O  
ATOM   1744  CB  ALA B  82      16.559   4.586  20.560  1.00 13.48           C  
ATOM   1745  N   VAL B  83      18.265   6.413  18.554  1.00 13.53           N  
ATOM   1746  CA  VAL B  83      18.772   6.510  17.200  1.00 13.21           C  
ATOM   1747  C   VAL B  83      19.876   5.486  17.063  1.00 14.37           C  
ATOM   1748  O   VAL B  83      20.810   5.513  17.857  1.00 17.32           O  
ATOM   1749  CB  VAL B  83      19.279   7.942  16.847  1.00 13.24           C  
ATOM   1750  CG1 VAL B  83      19.873   7.999  15.435  1.00 14.55           C  
ATOM   1751  CG2 VAL B  83      18.169   8.952  16.917  1.00 11.85           C  
ATOM   1752  N   GLU B  84      19.794   4.580  16.088  1.00 13.27           N  
ATOM   1753  CA  GLU B  84      20.943   3.774  15.745  1.00 14.23           C  
ATOM   1754  C   GLU B  84      21.345   3.944  14.300  1.00 12.92           C  
ATOM   1755  O   GLU B  84      20.511   3.854  13.395  1.00 13.57           O  
ATOM   1756  CB  GLU B  84      20.711   2.311  16.032  1.00 15.22           C  
ATOM   1757  CG  GLU B  84      21.944   1.513  15.598  1.00 20.11           C  
ATOM   1758  CD  GLU B  84      22.145   0.199  16.279  1.00 28.00           C  
ATOM   1759  OE1 GLU B  84      21.158  -0.325  16.843  1.00 33.68           O  
ATOM   1760  OE2 GLU B  84      23.293  -0.321  16.175  1.00 29.40           O  
ATOM   1761  N   THR B  85      22.631   4.242  14.083  1.00 12.62           N  
ATOM   1762  CA  THR B  85      23.156   4.520  12.782  1.00 12.77           C  
ATOM   1763  C   THR B  85      23.983   3.311  12.431  1.00 13.15           C  
ATOM   1764  O   THR B  85      25.021   3.054  13.048  1.00 13.67           O  
ATOM   1765  CB  THR B  85      24.072   5.775  12.786  1.00 12.97           C  
ATOM   1766  OG1 THR B  85      23.320   6.930  13.169  1.00 13.22           O  
ATOM   1767  CG2 THR B  85      24.603   6.090  11.405  1.00 13.08           C  
ATOM   1768  N   PHE B  86      23.485   2.526  11.504  1.00 11.53           N  
ATOM   1769  CA  PHE B  86      24.220   1.382  10.971  1.00 11.05           C  
ATOM   1770  C   PHE B  86      25.399   1.734  10.100  1.00 10.97           C  
ATOM   1771  O   PHE B  86      26.443   1.069  10.152  1.00 10.29           O  
ATOM   1772  CB  PHE B  86      23.263   0.475  10.151  1.00 11.88           C  
ATOM   1773  CG  PHE B  86      21.971   0.189  10.830  1.00 10.36           C  
ATOM   1774  CD1 PHE B  86      21.940  -0.491  12.050  1.00 12.71           C  
ATOM   1775  CD2 PHE B  86      20.787   0.592  10.248  1.00 13.91           C  
ATOM   1776  CE1 PHE B  86      20.759  -0.756  12.674  1.00 13.96           C  
ATOM   1777  CE2 PHE B  86      19.558   0.336  10.873  1.00 13.34           C  
ATOM   1778  CZ  PHE B  86      19.537  -0.344  12.067  1.00 14.51           C  
ATOM   1779  N   HIS B  87      25.235   2.740   9.238  1.00 10.35           N  
ATOM   1780  CA  HIS B  87      26.220   3.062   8.226  1.00 10.77           C  
ATOM   1781  C   HIS B  87      26.373   4.567   8.161  1.00 11.01           C  
ATOM   1782  O   HIS B  87      25.408   5.299   8.217  1.00 10.21           O  
ATOM   1783  CB  HIS B  87      25.768   2.611   6.838  1.00 10.18           C  
ATOM   1784  CG  HIS B  87      25.513   1.139   6.735  1.00 11.82           C  
ATOM   1785  ND1 HIS B  87      24.429   0.613   6.078  1.00 11.16           N  
ATOM   1786  CD2 HIS B  87      26.237   0.082   7.188  1.00 12.49           C  
ATOM   1787  CE1 HIS B  87      24.474  -0.712   6.164  1.00 12.37           C  
ATOM   1788  NE2 HIS B  87      25.566  -1.055   6.824  1.00 11.76           N  
ATOM   1789  N   ILE B  88      27.608   5.025   8.015  1.00 10.34           N  
ATOM   1790  CA  ILE B  88      27.876   6.442   7.827  1.00 10.34           C  
ATOM   1791  C   ILE B  88      29.055   6.546   6.860  1.00 11.21           C  
ATOM   1792  O   ILE B  88      30.009   5.776   6.961  1.00 11.62           O  
ATOM   1793  CB  ILE B  88      28.171   7.179   9.194  1.00 10.85           C  
ATOM   1794  CG1 ILE B  88      28.393   8.664   8.963  1.00 12.14           C  
ATOM   1795  CG2 ILE B  88      29.376   6.536   9.935  1.00 11.63           C  
ATOM   1796  CD1 ILE B  88      28.268   9.488  10.214  1.00 12.42           C  
ATOM   1797  N   GLY B  89      28.970   7.462   5.920  1.00 10.35           N  
ATOM   1798  CA  GLY B  89      30.053   7.710   5.013  1.00 11.59           C  
ATOM   1799  C   GLY B  89      29.963   9.104   4.464  1.00 12.14           C  
ATOM   1800  O   GLY B  89      29.041   9.843   4.775  1.00 12.71           O  
ATOM   1801  N   SER B  90      30.963   9.504   3.703  1.00 12.65           N  
ATOM   1802  CA  SER B  90      30.971  10.861   3.170  1.00 14.67           C  
ATOM   1803  C   SER B  90      31.832  11.026   1.925  1.00 16.46           C  
ATOM   1804  O   SER B  90      32.774  10.268   1.713  1.00 16.49           O  
ATOM   1805  CB  SER B  90      31.375  11.844   4.256  1.00 15.08           C  
ATOM   1806  OG  SER B  90      32.699  11.574   4.687  1.00 14.19           O  
ATOM   1807  N   SER B  91      31.482  12.047   1.127  1.00 18.84           N  
ATOM   1808  CA  SER B  91      32.178  12.486  -0.093  1.00 20.12           C  
ATOM   1809  C   SER B  91      31.663  13.899  -0.425  1.00 21.19           C  
ATOM   1810  O   SER B  91      30.472  14.212  -0.268  1.00 20.72           O  
ATOM   1811  CB  SER B  91      31.937  11.592  -1.344  1.00 20.61           C  
ATOM   1812  OG  SER B  91      32.464  10.239  -1.337  1.00 18.68           O  
ATOM   1813  N   ASN B  92      32.548  14.779  -0.895  1.00 21.44           N  
ATOM   1814  CA  ASN B  92      32.118  16.011  -1.534  1.00 22.27           C  
ATOM   1815  C   ASN B  92      31.369  16.951  -0.623  1.00 21.19           C  
ATOM   1816  O   ASN B  92      30.513  17.723  -1.069  1.00 23.25           O  
ATOM   1817  CB  ASN B  92      31.303  15.709  -2.805  1.00 22.16           C  
ATOM   1818  CG  ASN B  92      32.041  14.788  -3.739  1.00 26.89           C  
ATOM   1819  OD1 ASN B  92      33.247  14.961  -3.951  1.00 30.99           O  
ATOM   1820  ND2 ASN B  92      31.356  13.778  -4.273  1.00 24.82           N  
ATOM   1821  N   GLY B  93      31.708  16.900   0.648  1.00 19.57           N  
ATOM   1822  CA  GLY B  93      31.154  17.788   1.630  1.00 19.42           C  
ATOM   1823  C   GLY B  93      29.803  17.300   2.126  1.00 18.38           C  
ATOM   1824  O   GLY B  93      29.175  18.052   2.876  1.00 19.53           O  
ATOM   1825  N   LEU B  94      29.409  16.050   1.783  1.00 15.36           N  
ATOM   1826  CA  LEU B  94      28.136  15.481   2.289  1.00 13.05           C  
ATOM   1827  C   LEU B  94      28.385  14.211   3.085  1.00 12.52           C  
ATOM   1828  O   LEU B  94      29.176  13.376   2.669  1.00 13.01           O  
ATOM   1829  CB  LEU B  94      27.180  15.196   1.134  1.00 12.92           C  
ATOM   1830  CG  LEU B  94      26.758  16.380   0.330  1.00 12.46           C  
ATOM   1831  CD1 LEU B  94      25.832  15.941  -0.807  1.00 13.63           C  
ATOM   1832  CD2 LEU B  94      26.028  17.395   1.182  1.00 12.69           C  
ATOM   1833  N   VAL B  95      27.718  14.098   4.221  1.00  9.88           N  
ATOM   1834  CA  VAL B  95      27.721  12.935   5.076  1.00 10.57           C  
ATOM   1835  C   VAL B  95      26.373  12.196   4.949  1.00 10.37           C  
ATOM   1836  O   VAL B  95      25.329  12.817   5.066  1.00 10.09           O  
ATOM   1837  CB  VAL B  95      27.882  13.365   6.567  1.00 10.93           C  
ATOM   1838  CG1 VAL B  95      27.770  12.197   7.505  1.00 11.47           C  
ATOM   1839  CG2 VAL B  95      29.233  14.042   6.750  1.00 11.41           C  
ATOM   1840  N   TYR B  96      26.409  10.888   4.758  1.00 10.61           N  
ATOM   1841  CA  TYR B  96      25.188  10.091   4.616  1.00 10.32           C  
ATOM   1842  C   TYR B  96      25.062   9.167   5.828  1.00 10.28           C  
ATOM   1843  O   TYR B  96      26.044   8.596   6.309  1.00 10.09           O  
ATOM   1844  CB  TYR B  96      25.272   9.243   3.364  1.00 10.44           C  
ATOM   1845  CG  TYR B  96      25.446  10.058   2.129  1.00 11.49           C  
ATOM   1846  CD1 TYR B  96      26.743  10.422   1.660  1.00 10.86           C  
ATOM   1847  CD2 TYR B  96      24.330  10.523   1.418  1.00  8.20           C  
ATOM   1848  CE1 TYR B  96      26.895  11.197   0.531  1.00  9.48           C  
ATOM   1849  CE2 TYR B  96      24.478  11.306   0.312  1.00 10.29           C  
ATOM   1850  CZ  TYR B  96      25.769  11.634  -0.160  1.00  9.83           C  
ATOM   1851  OH  TYR B  96      25.865  12.407  -1.304  1.00 11.34           O  
ATOM   1852  N   THR B  97      23.858   9.000   6.358  1.00  9.83           N  
ATOM   1853  CA  THR B  97      23.658   8.098   7.486  1.00 10.06           C  
ATOM   1854  C   THR B  97      22.503   7.163   7.187  1.00 10.10           C  
ATOM   1855  O   THR B  97      21.445   7.651   6.824  1.00  9.87           O  
ATOM   1856  CB  THR B  97      23.295   8.814   8.808  1.00 10.83           C  
ATOM   1857  OG1 THR B  97      22.108   9.603   8.646  1.00 11.48           O  
ATOM   1858  CG2 THR B  97      24.360   9.773   9.255  1.00 11.99           C  
ATOM   1859  N   GLU B  98      22.705   5.863   7.377  1.00  9.08           N  
ATOM   1860  CA  GLU B  98      21.608   4.896   7.261  1.00  9.08           C  
ATOM   1861  C   GLU B  98      21.257   4.481   8.659  1.00  9.89           C  
ATOM   1862  O   GLU B  98      22.104   3.917   9.347  1.00 10.20           O  
ATOM   1863  CB  GLU B  98      22.008   3.669   6.423  1.00  8.66           C  
ATOM   1864  CG  GLU B  98      20.786   2.811   6.077  1.00  8.14           C  
ATOM   1865  CD  GLU B  98      21.039   1.766   5.035  1.00  7.90           C  
ATOM   1866  OE1 GLU B  98      22.191   1.408   4.752  1.00  8.20           O  
ATOM   1867  OE2 GLU B  98      20.051   1.297   4.455  1.00  8.00           O  
ATOM   1868  N   ARG B  99      20.022   4.756   9.105  1.00  9.51           N  
ATOM   1869  CA  ARG B  99      19.658   4.488  10.491  1.00  9.58           C  
ATOM   1870  C   ARG B  99      18.248   4.039  10.751  1.00  9.99           C  
ATOM   1871  O   ARG B  99      17.452   3.888   9.808  1.00  9.31           O  
ATOM   1872  CB  ARG B  99      19.949   5.718  11.306  1.00 12.84           C  
ATOM   1873  CG  ARG B  99      19.275   6.848  11.003  1.00 12.78           C  
ATOM   1874  CD  ARG B  99      20.066   8.162  11.473  1.00 15.39           C  
ATOM   1875  NE  ARG B  99      18.961   9.045  11.737  1.00 11.36           N  
ATOM   1876  CZ  ARG B  99      18.584  10.047  10.944  1.00 11.22           C  
ATOM   1877  NH1 ARG B  99      19.306  10.443   9.920  1.00  9.41           N  
ATOM   1878  NH2 ARG B  99      17.515  10.687  11.249  1.00  9.98           N  
ATOM   1879  N   VAL B 100      17.970   3.785  12.028  1.00  9.03           N  
ATOM   1880  CA  VAL B 100      16.606   3.636  12.544  1.00  9.58           C  
ATOM   1881  C   VAL B 100      16.449   4.636  13.677  1.00 10.10           C  
ATOM   1882  O   VAL B 100      17.314   4.707  14.550  1.00  8.76           O  
ATOM   1883  CB  VAL B 100      16.330   2.209  13.082  1.00 10.32           C  
ATOM   1884  CG1 VAL B 100      15.038   2.153  13.864  1.00 11.18           C  
ATOM   1885  CG2 VAL B 100      16.188   1.252  11.915  1.00 13.33           C  
ATOM   1886  N   ASP B 101      15.373   5.438  13.657  1.00 10.08           N  
ATOM   1887  CA  ASP B 101      15.003   6.294  14.781  1.00  9.93           C  
ATOM   1888  C   ASP B 101      13.778   5.649  15.407  1.00 11.07           C  
ATOM   1889  O   ASP B 101      12.834   5.350  14.719  1.00  9.68           O  
ATOM   1890  CB  ASP B 101      14.660   7.742  14.355  1.00 10.91           C  
ATOM   1891  CG  ASP B 101      15.820   8.511  13.814  1.00 13.14           C  
ATOM   1892  OD1 ASP B 101      16.907   7.918  13.618  1.00 12.68           O  
ATOM   1893  OD2 ASP B 101      15.679   9.731  13.495  1.00  9.61           O  
ATOM   1894  N   VAL B 102      13.779   5.449  16.728  1.00  9.98           N  
ATOM   1895  CA  VAL B 102      12.630   4.921  17.444  1.00  9.95           C  
ATOM   1896  C   VAL B 102      11.833   6.132  17.899  1.00 10.42           C  
ATOM   1897  O   VAL B 102      12.365   6.979  18.642  1.00 11.42           O  
ATOM   1898  CB  VAL B 102      13.103   4.115  18.653  1.00 10.37           C  
ATOM   1899  CG1 VAL B 102      11.945   3.609  19.461  1.00 11.20           C  
ATOM   1900  CG2 VAL B 102      13.987   2.999  18.177  1.00 11.45           C  
ATOM   1901  N   LEU B 103      10.622   6.261  17.353  1.00 10.24           N  
ATOM   1902  CA  LEU B 103       9.760   7.412  17.552  1.00 10.85           C  
ATOM   1903  C   LEU B 103       8.525   7.015  18.339  1.00 10.65           C  
ATOM   1904  O   LEU B 103       7.928   6.006  18.076  1.00 11.43           O  
ATOM   1905  CB  LEU B 103       9.325   7.974  16.198  1.00 10.71           C  
ATOM   1906  CG  LEU B 103      10.473   8.307  15.254  1.00 13.16           C  
ATOM   1907  CD1 LEU B 103       9.931   8.722  13.912  1.00 14.19           C  
ATOM   1908  CD2 LEU B 103      11.394   9.377  15.807  1.00 14.21           C  
ATOM   1909  N   ARG B 104       8.159   7.830  19.325  1.00 10.45           N  
ATOM   1910  CA  ARG B 104       6.996   7.570  20.144  1.00 10.27           C  
ATOM   1911  C   ARG B 104       6.059   8.768  20.037  1.00 10.10           C  
ATOM   1912  O   ARG B 104       6.479   9.911  20.267  1.00  9.90           O  
ATOM   1913  CB  ARG B 104       7.443   7.363  21.587  1.00 10.11           C  
ATOM   1914  CG  ARG B 104       6.306   7.197  22.560  1.00 12.02           C  
ATOM   1915  CD  ARG B 104       6.742   6.690  23.913  1.00 11.59           C  
ATOM   1916  NE  ARG B 104       7.936   7.353  24.386  1.00 12.46           N  
ATOM   1917  CZ  ARG B 104       7.912   8.457  25.113  1.00  9.59           C  
ATOM   1918  NH1 ARG B 104       6.759   9.032  25.444  1.00 11.75           N  
ATOM   1919  NH2 ARG B 104       9.033   9.001  25.479  1.00 11.64           N  
ATOM   1920  N   ALA B 105       4.800   8.508  19.697  1.00 10.58           N  
ATOM   1921  CA  ALA B 105       3.813   9.572  19.583  1.00 10.95           C  
ATOM   1922  C   ALA B 105       3.355   9.965  20.979  1.00 11.44           C  
ATOM   1923  O   ALA B 105       2.921   9.119  21.754  1.00 11.86           O  
ATOM   1924  CB  ALA B 105       2.653   9.155  18.723  1.00 10.26           C  
ATOM   1925  N   LEU B 106       3.416  11.244  21.297  1.00 11.70           N  
ATOM   1926  CA  LEU B 106       3.013  11.685  22.623  1.00 11.74           C  
ATOM   1927  C   LEU B 106       1.512  11.575  22.849  1.00 12.66           C  
ATOM   1928  O   LEU B 106       1.133  11.231  23.955  1.00 14.24           O  
ATOM   1929  CB  LEU B 106       3.531  13.073  22.914  1.00 10.90           C  
ATOM   1930  CG  LEU B 106       5.035  13.280  22.910  1.00 12.34           C  
ATOM   1931  CD1 LEU B 106       5.438  14.687  23.206  1.00 12.95           C  
ATOM   1932  CD2 LEU B 106       5.735  12.321  23.864  1.00 12.62           C  
ATOM   1933  N   PRO B 107       0.655  11.885  21.878  1.00 14.55           N  
ATOM   1934  CA  PRO B 107      -0.794  11.706  22.049  1.00 14.79           C  
ATOM   1935  C   PRO B 107      -1.218  10.251  22.306  1.00 14.60           C  
ATOM   1936  O   PRO B 107      -2.243  10.036  22.929  1.00 16.69           O  
ATOM   1937  CB  PRO B 107      -1.367  12.157  20.717  1.00 15.83           C  
ATOM   1938  CG  PRO B 107      -0.390  13.045  20.161  1.00 16.27           C  
ATOM   1939  CD  PRO B 107       0.937  12.616  20.629  1.00 14.44           C  
ATOM   1940  N   THR B 108      -0.484   9.279  21.804  1.00 13.13           N  
ATOM   1941  CA  THR B 108      -1.005   7.899  21.810  1.00 12.90           C  
ATOM   1942  C   THR B 108      -0.211   6.865  22.586  1.00 13.25           C  
ATOM   1943  O   THR B 108      -0.734   5.756  22.831  1.00 13.66           O  
ATOM   1944  CB  THR B 108      -1.180   7.371  20.367  1.00 12.40           C  
ATOM   1945  OG1 THR B 108       0.097   7.099  19.846  1.00 11.25           O  
ATOM   1946  CG2 THR B 108      -1.820   8.408  19.475  1.00 13.26           C  
ATOM   1947  N   GLY B 109       1.008   7.205  22.986  1.00 12.64           N  
ATOM   1948  CA  GLY B 109       1.938   6.284  23.593  1.00 12.90           C  
ATOM   1949  C   GLY B 109       2.509   5.200  22.717  1.00 12.55           C  
ATOM   1950  O   GLY B 109       3.273   4.360  23.204  1.00 12.49           O  
ATOM   1951  N   LYS B 110       2.174   5.223  21.417  1.00 11.62           N  
ATOM   1952  CA  LYS B 110       2.622   4.167  20.499  1.00 12.07           C  
ATOM   1953  C   LYS B 110       3.978   4.534  19.876  1.00 12.74           C  
ATOM   1954  O   LYS B 110       4.228   5.715  19.616  1.00  9.99           O  
ATOM   1955  CB  LYS B 110       1.573   3.911  19.435  1.00 11.46           C  
ATOM   1956  CG  LYS B 110       0.299   3.216  19.917  1.00 12.70           C  
ATOM   1957  CD  LYS B 110      -0.673   2.892  18.779  1.00 14.10           C  
ATOM   1958  CE  LYS B 110      -1.971   2.261  19.263  1.00 19.20           C  
ATOM   1959  NZ  LYS B 110      -2.734   1.628  18.149  1.00 20.66           N  
ATOM   1960  N   SER B 111       4.825   3.516  19.657  1.00 13.54           N  
ATOM   1961  CA  SER B 111       6.169   3.686  19.109  1.00 13.18           C  
ATOM   1962  C   SER B 111       6.286   2.984  17.754  1.00 12.68           C  
ATOM   1963  O   SER B 111       5.560   2.032  17.460  1.00 13.16           O  
ATOM   1964  CB  SER B 111       7.293   3.178  20.059  1.00 13.20           C  
ATOM   1965  OG  SER B 111       7.380   3.946  21.283  1.00 18.16           O  
ATOM   1966  N   TYR B 112       7.272   3.430  16.975  1.00 11.41           N  
ATOM   1967  CA  TYR B 112       7.568   2.839  15.683  1.00 10.95           C  
ATOM   1968  C   TYR B 112       9.037   2.992  15.416  1.00 10.46           C  
ATOM   1969  O   TYR B 112       9.609   4.017  15.713  1.00 10.53           O  
ATOM   1970  CB  TYR B 112       6.776   3.540  14.625  1.00 11.50           C  
ATOM   1971  CG  TYR B 112       6.932   2.966  13.236  1.00 11.72           C  
ATOM   1972  CD1 TYR B 112       6.471   1.706  12.943  1.00 13.59           C  
ATOM   1973  CD2 TYR B 112       7.590   3.668  12.260  1.00 10.97           C  
ATOM   1974  CE1 TYR B 112       6.614   1.172  11.671  1.00 15.91           C  
ATOM   1975  CE2 TYR B 112       7.741   3.153  10.992  1.00 12.22           C  
ATOM   1976  CZ  TYR B 112       7.243   1.911  10.706  1.00 13.88           C  
ATOM   1977  OH  TYR B 112       7.423   1.364   9.470  1.00 18.74           O  
ATOM   1978  N   ASN B 113       9.642   1.959  14.866  1.00 10.58           N  
ATOM   1979  CA  ASN B 113      11.019   2.022  14.410  1.00  8.94           C  
ATOM   1980  C   ASN B 113      11.044   2.458  12.957  1.00  9.48           C  
ATOM   1981  O   ASN B 113      10.655   1.675  12.071  1.00  9.17           O  
ATOM   1982  CB  ASN B 113      11.677   0.642  14.559  1.00  9.96           C  
ATOM   1983  CG  ASN B 113      11.930   0.262  16.022  1.00 12.19           C  
ATOM   1984  OD1 ASN B 113      11.380   0.872  16.943  1.00 11.77           O  
ATOM   1985  ND2 ASN B 113      12.864  -0.683  16.227  1.00 18.45           N  
ATOM   1986  N   LEU B 114      11.508   3.684  12.724  1.00  9.65           N  
ATOM   1987  CA  LEU B 114      11.475   4.275  11.423  1.00  8.96           C  
ATOM   1988  C   LEU B 114      12.840   4.146  10.752  1.00  9.12           C  
ATOM   1989  O   LEU B 114      13.805   4.704  11.243  1.00  9.91           O  
ATOM   1990  CB  LEU B 114      11.096   5.760  11.557  1.00  9.81           C  
ATOM   1991  CG  LEU B 114      10.949   6.444  10.176  1.00 11.05           C  
ATOM   1992  CD1 LEU B 114       9.918   5.853   9.241  1.00  9.76           C  
ATOM   1993  CD2 LEU B 114      10.727   7.907  10.425  1.00 11.29           C  
ATOM   1994  N   SER B 115      12.883   3.488   9.586  1.00  9.75           N  
ATOM   1995  CA  SER B 115      14.110   3.345   8.800  1.00  8.56           C  
ATOM   1996  C   SER B 115      14.302   4.626   7.978  1.00  8.64           C  
ATOM   1997  O   SER B 115      13.421   5.048   7.249  1.00  7.09           O  
ATOM   1998  CB  SER B 115      14.007   2.168   7.844  1.00  9.42           C  
ATOM   1999  OG  SER B 115      13.744   0.942   8.531  1.00  9.58           O  
ATOM   2000  N   ILE B 116      15.487   5.213   8.131  1.00  8.24           N  
ATOM   2001  CA  ILE B 116      15.812   6.490   7.500  1.00  8.38           C  
ATOM   2002  C   ILE B 116      17.170   6.458   6.809  1.00  9.47           C  
ATOM   2003  O   ILE B 116      18.130   5.891   7.329  1.00  8.88           O  
ATOM   2004  CB  ILE B 116      15.837   7.609   8.554  1.00  8.81           C  
ATOM   2005  CG1 ILE B 116      14.463   7.748   9.255  1.00  9.29           C  
ATOM   2006  CG2 ILE B 116      16.227   8.943   7.962  1.00  9.09           C  
ATOM   2007  CD1 ILE B 116      14.549   8.525  10.502  1.00 10.11           C  
ATOM   2008  N   LEU B 117      17.255   7.088   5.651  1.00  8.50           N  
ATOM   2009  CA  LEU B 117      18.540   7.378   5.038  1.00  8.85           C  
ATOM   2010  C   LEU B 117      18.590   8.889   4.973  1.00  8.34           C  
ATOM   2011  O   LEU B 117      17.671   9.517   4.414  1.00  8.35           O  
ATOM   2012  CB  LEU B 117      18.661   6.741   3.651  1.00  7.95           C  
ATOM   2013  CG  LEU B 117      20.042   6.785   3.000  1.00  7.27           C  
ATOM   2014  CD1 LEU B 117      21.155   6.263   3.838  1.00 12.59           C  
ATOM   2015  CD2 LEU B 117      20.059   6.034   1.677  1.00  9.00           C  
ATOM   2016  N   GLY B 118      19.653   9.497   5.514  1.00  8.09           N  
ATOM   2017  CA  GLY B 118      19.748  10.939   5.599  1.00  7.61           C  
ATOM   2018  C   GLY B 118      21.068  11.480   5.118  1.00  8.47           C  
ATOM   2019  O   GLY B 118      22.072  10.761   5.082  1.00  8.14           O  
ATOM   2020  N   VAL B 119      21.039  12.731   4.703  1.00  9.20           N  
ATOM   2021  CA  VAL B 119      22.226  13.410   4.196  1.00  9.56           C  
ATOM   2022  C   VAL B 119      22.372  14.743   4.915  1.00  9.22           C  
ATOM   2023  O   VAL B 119      21.384  15.421   5.233  1.00  9.60           O  
ATOM   2024  CB  VAL B 119      22.193  13.579   2.624  1.00  9.42           C  
ATOM   2025  CG1 VAL B 119      20.930  14.311   2.135  1.00 10.46           C  
ATOM   2026  CG2 VAL B 119      23.510  14.242   2.112  1.00 10.06           C  
ATOM   2027  N   PHE B 120      23.640  15.085   5.193  1.00 10.21           N  
ATOM   2028  CA  PHE B 120      24.002  16.260   5.961  1.00 10.74           C  
ATOM   2029  C   PHE B 120      25.074  17.011   5.220  1.00 11.32           C  
ATOM   2030  O   PHE B 120      25.987  16.398   4.740  1.00 11.08           O  
ATOM   2031  CB  PHE B 120      24.566  15.860   7.346  1.00 10.03           C  
ATOM   2032  CG  PHE B 120      23.599  15.098   8.229  1.00 11.06           C  
ATOM   2033  CD1 PHE B 120      23.375  13.713   8.035  1.00  8.34           C  
ATOM   2034  CD2 PHE B 120      22.924  15.723   9.268  1.00 11.49           C  
ATOM   2035  CE1 PHE B 120      22.466  13.022   8.824  1.00 10.92           C  
ATOM   2036  CE2 PHE B 120      22.034  14.998  10.057  1.00 11.91           C  
ATOM   2037  CZ  PHE B 120      21.815  13.655   9.842  1.00 11.36           C  
ATOM   2038  N   GLN B 121      24.972  18.331   5.147  1.00 11.38           N  
ATOM   2039  CA  GLN B 121      26.052  19.167   4.658  1.00 12.51           C  
ATOM   2040  C   GLN B 121      26.544  20.035   5.830  1.00 13.01           C  
ATOM   2041  O   GLN B 121      25.749  20.695   6.490  1.00 12.76           O  
ATOM   2042  CB  GLN B 121      25.541  20.048   3.529  1.00 12.78           C  
ATOM   2043  CG  GLN B 121      26.655  20.827   2.861  1.00 13.49           C  
ATOM   2044  CD  GLN B 121      26.164  21.926   2.014  1.00 19.71           C  
ATOM   2045  OE1 GLN B 121      26.362  21.911   0.804  1.00 26.71           O  
ATOM   2046  NE2 GLN B 121      25.534  22.923   2.636  1.00 20.75           N  
ATOM   2047  N   LEU B 122      27.855  20.004   6.069  1.00 13.81           N  
ATOM   2048  CA  LEU B 122      28.477  20.735   7.180  1.00 15.10           C  
ATOM   2049  C   LEU B 122      29.441  21.727   6.604  1.00 15.82           C  
ATOM   2050  O   LEU B 122      30.182  21.428   5.657  1.00 16.71           O  
ATOM   2051  CB  LEU B 122      29.211  19.802   8.125  1.00 16.38           C  
ATOM   2052  CG  LEU B 122      28.285  19.310   9.219  1.00 19.15           C  
ATOM   2053  CD1 LEU B 122      27.226  18.358   8.689  1.00 22.79           C  
ATOM   2054  CD2 LEU B 122      29.044  18.701  10.376  1.00 18.50           C  
ATOM   2055  N   THR B 123      29.356  22.945   7.112  1.00 15.87           N  
ATOM   2056  CA  THR B 123      30.268  24.016   6.729  1.00 16.75           C  
ATOM   2057  C   THR B 123      30.924  24.495   8.018  1.00 16.33           C  
ATOM   2058  O   THR B 123      30.252  25.001   8.917  1.00 16.08           O  
ATOM   2059  CB  THR B 123      29.508  25.150   6.018  1.00 17.17           C  
ATOM   2060  OG1 THR B 123      28.935  24.688   4.792  1.00 18.07           O  
ATOM   2061  CG2 THR B 123      30.451  26.260   5.551  1.00 18.76           C  
ATOM   2062  N   GLU B 124      32.248  24.371   8.068  1.00 17.11           N  
ATOM   2063  CA  GLU B 124      33.033  24.675   9.293  1.00 16.71           C  
ATOM   2064  C   GLU B 124      32.403  24.062  10.537  1.00 15.66           C  
ATOM   2065  O   GLU B 124      32.290  24.708  11.577  1.00 15.94           O  
ATOM   2066  CB  GLU B 124      33.251  26.198   9.433  1.00 18.06           C  
ATOM   2067  CG  GLU B 124      34.027  26.767   8.243  1.00 22.04           C  
ATOM   2068  CD  GLU B 124      34.420  28.230   8.380  1.00 28.02           C  
ATOM   2069  OE1 GLU B 124      33.968  28.928   9.306  1.00 28.67           O  
ATOM   2070  OE2 GLU B 124      35.202  28.686   7.531  1.00 31.73           O  
ATOM   2071  N   GLY B 125      31.947  22.809  10.403  1.00 15.01           N  
ATOM   2072  CA  GLY B 125      31.459  22.007  11.504  1.00 14.82           C  
ATOM   2073  C   GLY B 125      30.014  22.300  11.892  1.00 13.80           C  
ATOM   2074  O   GLY B 125      29.543  21.744  12.878  1.00 17.03           O  
ATOM   2075  N   LYS B 126      29.337  23.181  11.162  1.00 13.51           N  
ATOM   2076  CA  LYS B 126      27.935  23.533  11.447  1.00 13.03           C  
ATOM   2077  C   LYS B 126      27.017  23.046  10.331  1.00 12.08           C  
ATOM   2078  O   LYS B 126      27.408  23.014   9.166  1.00 12.31           O  
ATOM   2079  CB  LYS B 126      27.771  25.040  11.657  1.00 15.12           C  
ATOM   2080  CG  LYS B 126      28.580  25.556  12.891  1.00 15.93           C  
ATOM   2081  CD  LYS B 126      28.004  24.995  14.181  1.00 20.52           C  
ATOM   2082  CE  LYS B 126      28.365  25.716  15.448  1.00 25.55           C  
ATOM   2083  NZ  LYS B 126      27.906  24.848  16.603  1.00 26.55           N  
ATOM   2084  N   ILE B 127      25.793  22.639  10.668  1.00 11.72           N  
ATOM   2085  CA  ILE B 127      24.929  22.049   9.639  1.00 12.39           C  
ATOM   2086  C   ILE B 127      24.359  23.117   8.716  1.00 11.68           C  
ATOM   2087  O   ILE B 127      23.646  24.010   9.135  1.00 11.52           O  
ATOM   2088  CB  ILE B 127      23.780  21.201  10.298  1.00 12.13           C  
ATOM   2089  CG1 ILE B 127      24.363  20.058  11.153  1.00 11.93           C  
ATOM   2090  CG2 ILE B 127      22.819  20.661   9.215  1.00 13.21           C  
ATOM   2091  CD1 ILE B 127      23.316  19.290  11.923  1.00 14.40           C  
ATOM   2092  N   THR B 128      24.635  23.012   7.432  1.00 11.19           N  
ATOM   2093  CA  THR B 128      24.029  23.865   6.444  1.00 12.19           C  
ATOM   2094  C   THR B 128      22.903  23.224   5.629  1.00 11.79           C  
ATOM   2095  O   THR B 128      22.154  23.916   4.967  1.00 10.57           O  
ATOM   2096  CB  THR B 128      25.130  24.457   5.520  1.00 15.25           C  
ATOM   2097  OG1 THR B 128      25.908  23.430   4.950  1.00 20.75           O  
ATOM   2098  CG2 THR B 128      26.101  25.190   6.329  1.00 14.16           C  
ATOM   2099  N   GLY B 129      22.780  21.908   5.740  1.00 10.99           N  
ATOM   2100  CA  GLY B 129      21.660  21.213   5.112  1.00 10.87           C  
ATOM   2101  C   GLY B 129      21.469  19.865   5.801  1.00 10.45           C  
ATOM   2102  O   GLY B 129      22.445  19.207   6.129  1.00 10.31           O  
ATOM   2103  N   TRP B 130      20.222  19.449   6.000  1.00  9.95           N  
ATOM   2104  CA  TRP B 130      19.948  18.104   6.531  1.00  9.76           C  
ATOM   2105  C   TRP B 130      18.646  17.637   5.912  1.00  9.40           C  
ATOM   2106  O   TRP B 130      17.625  18.285   6.063  1.00  8.60           O  
ATOM   2107  CB  TRP B 130      19.840  18.123   8.047  1.00  9.39           C  
ATOM   2108  CG  TRP B 130      19.326  16.880   8.717  1.00  9.95           C  
ATOM   2109  CD1 TRP B 130      19.411  15.586   8.262  1.00  9.09           C  
ATOM   2110  CD2 TRP B 130      18.699  16.819  10.000  1.00 10.82           C  
ATOM   2111  NE1 TRP B 130      18.822  14.741   9.174  1.00 11.51           N  
ATOM   2112  CE2 TRP B 130      18.388  15.478  10.256  1.00  9.61           C  
ATOM   2113  CE3 TRP B 130      18.349  17.774  10.954  1.00 10.95           C  
ATOM   2114  CZ2 TRP B 130      17.725  15.063  11.440  1.00 11.02           C  
ATOM   2115  CZ3 TRP B 130      17.689  17.371  12.119  1.00  9.29           C  
ATOM   2116  CH2 TRP B 130      17.407  16.013  12.358  1.00  9.87           C  
ATOM   2117  N   ARG B 131      18.700  16.532   5.199  1.00  9.44           N  
ATOM   2118  CA  ARG B 131      17.513  15.967   4.541  1.00  8.67           C  
ATOM   2119  C   ARG B 131      17.400  14.484   4.910  1.00  9.30           C  
ATOM   2120  O   ARG B 131      18.350  13.764   4.662  1.00  8.64           O  
ATOM   2121  CB  ARG B 131      17.617  16.100   3.015  1.00 10.13           C  
ATOM   2122  CG  ARG B 131      17.598  17.550   2.523  1.00  9.27           C  
ATOM   2123  CD  ARG B 131      17.797  17.749   1.041  1.00  8.67           C  
ATOM   2124  NE  ARG B 131      19.108  17.356   0.573  1.00  9.53           N  
ATOM   2125  CZ  ARG B 131      20.215  18.037   0.730  1.00 10.89           C  
ATOM   2126  NH1 ARG B 131      20.244  19.212   1.360  1.00 10.23           N  
ATOM   2127  NH2 ARG B 131      21.345  17.520   0.290  1.00 12.93           N  
ATOM   2128  N   ASP B 132      16.274  14.067   5.505  1.00  8.20           N  
ATOM   2129  CA  ASP B 132      16.028  12.698   5.864  1.00  8.26           C  
ATOM   2130  C   ASP B 132      14.929  12.145   4.943  1.00  7.59           C  
ATOM   2131  O   ASP B 132      13.864  12.744   4.788  1.00  7.83           O  
ATOM   2132  CB  ASP B 132      15.535  12.561   7.320  1.00  8.38           C  
ATOM   2133  CG  ASP B 132      16.650  12.487   8.340  1.00  9.10           C  
ATOM   2134  OD1 ASP B 132      17.810  12.174   8.013  1.00  8.12           O  
ATOM   2135  OD2 ASP B 132      16.408  12.641   9.529  1.00  9.72           O  
ATOM   2136  N   TYR B 133      15.203  10.973   4.377  1.00  7.71           N  
ATOM   2137  CA  TYR B 133      14.316  10.262   3.458  1.00  6.86           C  
ATOM   2138  C   TYR B 133      13.791   9.025   4.147  1.00  7.65           C  
ATOM   2139  O   TYR B 133      14.541   8.270   4.740  1.00  7.95           O  
ATOM   2140  CB  TYR B 133      15.070   9.845   2.201  1.00  6.51           C  
ATOM   2141  CG  TYR B 133      15.513  10.942   1.266  1.00  6.02           C  
ATOM   2142  CD1 TYR B 133      16.530  11.839   1.611  1.00  8.25           C  
ATOM   2143  CD2 TYR B 133      14.900  11.086   0.034  1.00  7.30           C  
ATOM   2144  CE1 TYR B 133      16.946  12.866   0.730  1.00  7.86           C  
ATOM   2145  CE2 TYR B 133      15.310  12.086  -0.861  1.00  9.59           C  
ATOM   2146  CZ  TYR B 133      16.326  12.967  -0.520  1.00  8.78           C  
ATOM   2147  OH  TYR B 133      16.687  13.975  -1.407  1.00 10.68           O  
ATOM   2148  N   PHE B 134      12.470   8.849   4.058  1.00  6.48           N  
ATOM   2149  CA  PHE B 134      11.740   7.768   4.721  1.00  7.34           C  
ATOM   2150  C   PHE B 134      10.313   7.799   4.257  1.00  7.09           C  
ATOM   2151  O   PHE B 134       9.873   8.716   3.582  1.00  6.48           O  
ATOM   2152  CB  PHE B 134      11.772   7.880   6.263  1.00  6.47           C  
ATOM   2153  CG  PHE B 134      11.196   9.170   6.790  1.00  7.05           C  
ATOM   2154  CD1 PHE B 134       9.851   9.286   7.094  1.00  7.37           C  
ATOM   2155  CD2 PHE B 134      12.022  10.281   6.995  1.00  7.95           C  
ATOM   2156  CE1 PHE B 134       9.328  10.478   7.581  1.00  7.99           C  
ATOM   2157  CE2 PHE B 134      11.506  11.422   7.467  1.00  8.99           C  
ATOM   2158  CZ  PHE B 134      10.163  11.539   7.754  1.00  6.72           C  
ATOM   2159  N   ASP B 135       9.585   6.758   4.633  1.00  6.83           N  
ATOM   2160  CA  ASP B 135       8.172   6.677   4.362  1.00  6.84           C  
ATOM   2161  C   ASP B 135       7.339   7.157   5.528  1.00  7.02           C  
ATOM   2162  O   ASP B 135       7.427   6.642   6.621  1.00  8.10           O  
ATOM   2163  CB  ASP B 135       7.791   5.213   4.025  1.00  6.12           C  
ATOM   2164  CG  ASP B 135       6.333   5.085   3.579  1.00 10.05           C  
ATOM   2165  OD1 ASP B 135       6.043   5.461   2.415  1.00 10.17           O  
ATOM   2166  OD2 ASP B 135       5.454   4.772   4.400  1.00 12.11           O  
ATOM   2167  N   LEU B 136       6.493   8.141   5.294  1.00  7.47           N  
ATOM   2168  CA  LEU B 136       5.756   8.774   6.386  1.00  7.64           C  
ATOM   2169  C   LEU B 136       4.500   7.985   6.761  1.00  8.33           C  
ATOM   2170  O   LEU B 136       4.176   7.883   7.931  1.00  7.12           O  
ATOM   2171  CB  LEU B 136       5.456  10.233   6.057  1.00  8.31           C  
ATOM   2172  CG  LEU B 136       4.659  11.035   7.086  1.00 10.92           C  
ATOM   2173  CD1 LEU B 136       5.343  11.054   8.444  1.00 11.94           C  
ATOM   2174  CD2 LEU B 136       4.447  12.491   6.637  1.00 11.09           C  
ATOM   2175  N   ARG B 137       3.814   7.407   5.773  1.00  7.90           N  
ATOM   2176  CA  ARG B 137       2.545   6.741   6.010  1.00  8.56           C  
ATOM   2177  C   ARG B 137       2.677   5.594   6.994  1.00  8.83           C  
ATOM   2178  O   ARG B 137       1.831   5.438   7.861  1.00  9.70           O  
ATOM   2179  CB  ARG B 137       1.902   6.240   4.730  1.00  7.79           C  
ATOM   2180  CG  ARG B 137       0.690   5.351   4.932  1.00  8.09           C  
ATOM   2181  CD  ARG B 137      -0.006   4.998   3.630  1.00 11.38           C  
ATOM   2182  NE  ARG B 137       0.922   4.354   2.722  1.00 11.34           N  
ATOM   2183  CZ  ARG B 137       0.715   4.199   1.411  1.00 11.32           C  
ATOM   2184  NH1 ARG B 137      -0.443   4.615   0.855  1.00 12.62           N  
ATOM   2185  NH2 ARG B 137       1.648   3.630   0.669  1.00 11.80           N  
ATOM   2186  N   GLU B 138       3.718   4.773   6.844  1.00  9.74           N  
ATOM   2187  CA  GLU B 138       3.862   3.613   7.722  1.00 11.49           C  
ATOM   2188  C   GLU B 138       4.020   4.050   9.193  1.00 10.05           C  
ATOM   2189  O   GLU B 138       3.503   3.374  10.094  1.00 13.03           O  
ATOM   2190  CB  GLU B 138       5.019   2.704   7.272  1.00 11.95           C  
ATOM   2191  CG  GLU B 138       6.390   3.331   7.317  1.00 17.14           C  
ATOM   2192  CD  GLU B 138       7.481   2.512   6.572  1.00 22.54           C  
ATOM   2193  OE1 GLU B 138       7.181   1.792   5.604  1.00 20.26           O  
ATOM   2194  OE2 GLU B 138       8.674   2.631   6.948  1.00 28.66           O  
ATOM   2195  N   PHE B 139       4.710   5.156   9.411  1.00  9.66           N  
ATOM   2196  CA  PHE B 139       4.876   5.713  10.752  1.00  9.95           C  
ATOM   2197  C   PHE B 139       3.513   6.207  11.252  1.00 10.16           C  
ATOM   2198  O   PHE B 139       3.123   5.908  12.350  1.00  8.87           O  
ATOM   2199  CB  PHE B 139       5.912   6.821  10.701  1.00 10.41           C  
ATOM   2200  CG  PHE B 139       6.001   7.677  11.951  1.00 13.27           C  
ATOM   2201  CD1 PHE B 139       6.086   7.130  13.196  1.00 12.39           C  
ATOM   2202  CD2 PHE B 139       6.051   9.041  11.849  1.00 21.19           C  
ATOM   2203  CE1 PHE B 139       6.159   7.890  14.306  1.00 12.97           C  
ATOM   2204  CE2 PHE B 139       6.145   9.827  12.997  1.00 23.10           C  
ATOM   2205  CZ  PHE B 139       6.200   9.222  14.229  1.00 20.73           C  
ATOM   2206  N   GLU B 140       2.820   7.010  10.451  1.00  9.78           N  
ATOM   2207  CA  GLU B 140       1.536   7.577  10.882  1.00 10.49           C  
ATOM   2208  C   GLU B 140       0.547   6.475  11.291  1.00 11.25           C  
ATOM   2209  O   GLU B 140      -0.160   6.598  12.322  1.00 10.87           O  
ATOM   2210  CB  GLU B 140       0.886   8.334   9.727  1.00 10.84           C  
ATOM   2211  CG  GLU B 140       1.577   9.599   9.333  1.00 10.57           C  
ATOM   2212  CD  GLU B 140       0.814  10.413   8.284  1.00 10.55           C  
ATOM   2213  OE1 GLU B 140      -0.267  10.039   7.886  1.00 13.25           O  
ATOM   2214  OE2 GLU B 140       1.306  11.482   7.877  1.00 12.81           O  
ATOM   2215  N   GLU B 141       0.484   5.407  10.496  1.00 11.24           N  
ATOM   2216  CA  GLU B 141      -0.459   4.310  10.756  1.00 12.48           C  
ATOM   2217  C   GLU B 141      -0.024   3.508  12.005  1.00 12.60           C  
ATOM   2218  O   GLU B 141      -0.882   3.027  12.745  1.00 14.97           O  
ATOM   2219  CB  GLU B 141      -0.577   3.368   9.518  1.00 13.47           C  
ATOM   2220  CG  GLU B 141      -1.203   4.113   8.347  1.00 13.78           C  
ATOM   2221  CD  GLU B 141      -1.328   3.304   7.072  1.00 15.94           C  
ATOM   2222  OE1 GLU B 141      -0.671   2.244   6.960  1.00 18.66           O  
ATOM   2223  OE2 GLU B 141      -2.106   3.763   6.227  1.00 19.07           O  
ATOM   2224  N   ALA B 142       1.268   3.329  12.189  1.00 11.49           N  
ATOM   2225  CA  ALA B 142       1.810   2.567  13.324  1.00 11.70           C  
ATOM   2226  C   ALA B 142       1.457   3.234  14.658  1.00 13.35           C  
ATOM   2227  O   ALA B 142       1.203   2.549  15.650  1.00 13.98           O  
ATOM   2228  CB  ALA B 142       3.295   2.395  13.225  1.00 11.66           C  
ATOM   2229  N   VAL B 143       1.564   4.540  14.710  1.00 11.08           N  
ATOM   2230  CA  VAL B 143       1.408   5.285  15.982  1.00 12.35           C  
ATOM   2231  C   VAL B 143       0.097   6.102  16.107  1.00 12.71           C  
ATOM   2232  O   VAL B 143      -0.150   6.795  17.147  1.00 13.54           O  
ATOM   2233  CB  VAL B 143       2.645   6.176  16.285  1.00 11.73           C  
ATOM   2234  CG1 VAL B 143       3.937   5.335  16.230  1.00 10.78           C  
ATOM   2235  CG2 VAL B 143       2.717   7.393  15.337  1.00 12.58           C  
ATOM   2236  N   ASP B 144      -0.750   6.040  15.083  1.00 13.14           N  
ATOM   2237  CA  ASP B 144      -2.059   6.751  15.085  1.00 13.58           C  
ATOM   2238  C   ASP B 144      -1.935   8.262  15.208  1.00 13.67           C  
ATOM   2239  O   ASP B 144      -2.674   8.942  15.984  1.00 13.15           O  
ATOM   2240  CB  ASP B 144      -2.997   6.214  16.168  1.00 14.28           C  
ATOM   2241  CG  ASP B 144      -3.350   4.742  16.000  1.00 17.02           C  
ATOM   2242  OD1 ASP B 144      -3.349   4.218  14.876  1.00 15.92           O  
ATOM   2243  OD2 ASP B 144      -3.708   4.017  16.969  1.00 15.97           O  
ATOM   2244  N   LEU B 145      -0.996   8.807  14.446  1.00 13.18           N  
ATOM   2245  CA  LEU B 145      -0.680  10.243  14.440  1.00 13.95           C  
ATOM   2246  C   LEU B 145      -0.584  10.654  12.957  1.00 14.09           C  
ATOM   2247  O   LEU B 145       0.444  10.423  12.359  1.00 14.14           O  
ATOM   2248  CB  LEU B 145       0.673  10.502  15.137  1.00 15.02           C  
ATOM   2249  CG  LEU B 145       1.069  11.974  15.307  1.00 17.06           C  
ATOM   2250  CD1 LEU B 145       0.148  12.586  16.299  1.00 18.50           C  
ATOM   2251  CD2 LEU B 145       2.520  12.157  15.738  1.00 18.97           C  
ATOM   2252  N   PRO B 146      -1.640  11.186  12.378  1.00 14.75           N  
ATOM   2253  CA  PRO B 146      -1.659  11.624  10.987  1.00 15.70           C  
ATOM   2254  C   PRO B 146      -0.871  12.932  10.808  1.00 16.37           C  
ATOM   2255  O   PRO B 146      -1.466  13.982  10.618  1.00 18.61           O  
ATOM   2256  CB  PRO B 146      -3.160  11.841  10.711  1.00 17.16           C  
ATOM   2257  CG  PRO B 146      -3.712  12.157  12.036  1.00 16.64           C  
ATOM   2258  CD  PRO B 146      -2.914  11.482  13.055  1.00 15.91           C  
ATOM   2259  N   LEU B 147       0.442  12.844  10.826  1.00 16.21           N  
ATOM   2260  CA  LEU B 147       1.330  14.002  10.855  1.00 17.24           C  
ATOM   2261  C   LEU B 147       1.108  14.889   9.640  1.00 17.39           C  
ATOM   2262  O   LEU B 147       0.996  16.148   9.748  1.00 18.19           O  
ATOM   2263  CB  LEU B 147       2.774  13.502  10.900  1.00 17.11           C  
ATOM   2264  CG  LEU B 147       3.829  14.565  11.150  1.00 19.51           C  
ATOM   2265  CD1 LEU B 147       3.585  15.214  12.498  1.00 24.21           C  
ATOM   2266  CD2 LEU B 147       5.274  13.959  11.061  1.00 20.58           C  
ATOM   2267  N   ARG B 148       1.085  14.234   8.472  1.00 16.88           N  
ATOM   2268  CA  ARG B 148       0.572  14.805   7.253  1.00 17.96           C  
ATOM   2269  C   ARG B 148      -0.876  14.389   7.035  1.00 18.18           C  
ATOM   2270  O   ARG B 148      -1.722  15.258   6.918  1.00 18.06           O  
ATOM   2271  CB  ARG B 148       1.401  14.398   6.041  1.00 16.91           C  
ATOM   2272  CG  ARG B 148       1.222  15.291   4.857  1.00 19.34           C  
ATOM   2273  CD  ARG B 148       1.511  14.590   3.577  1.00 21.29           C  
ATOM   2274  NE  ARG B 148       0.366  13.779   3.215  1.00 21.23           N  
ATOM   2275  CZ  ARG B 148       0.131  13.336   1.986  1.00 20.22           C  
ATOM   2276  NH1 ARG B 148       1.015  13.555   0.983  1.00 21.71           N  
ATOM   2277  NH2 ARG B 148      -0.982  12.681   1.777  1.00 16.02           N  
ATOM   2278  N   GLY B 149      -1.156  13.076   7.001  1.00 16.64           N  
ATOM   2279  CA  GLY B 149      -2.482  12.552   6.746  1.00 18.43           C  
ATOM   2280  C   GLY B 149      -2.750  12.264   5.288  1.00 19.36           C  
ATOM   2281  O   GLY B 149      -3.782  11.654   4.955  1.00 21.58           O  
ATOM   2282  OXT GLY B 149      -1.935  12.575   4.417  1.00 19.69           O  
TER    2283      GLY B 149                                                      
END
MOLECULE T0451.pdb
ATOM      5  N   MET     1      36.190   5.525   0.753  1.00 16.76           N  
ATOM      6  CA  MET     1      36.556   4.348   1.534  1.00 16.70           C  
ATOM      7  C   MET     1      37.384   4.719   2.768  1.00 15.52           C  
ATOM      8  O   MET     1      37.281   4.061   3.808  1.00 16.29           O  
ATOM      9  CB  MET     1      37.374   3.375   0.675  1.00 20.02           C  
ATOM     10  CG  MET     1      37.869   2.182   1.408  1.00 22.08           C  
ATOM     11  SD  MET     1      38.432   0.910   0.076  0.75 18.74          SE  
ATOM     12  CE  MET     1      36.715   0.453  -0.660  1.00 12.40           C  
ATOM     13  N   MET     2      38.198   5.765   2.623  1.00 14.16           N  
ATOM     14  CA  MET     2      39.252   6.078   3.624  1.00 12.96           C  
ATOM     15  C   MET     2      38.951   7.259   4.543  1.00 16.21           C  
ATOM     16  O   MET     2      38.513   8.331   4.122  1.00 17.06           O  
ATOM     17  CB  MET     2      40.625   6.294   2.976  1.00 13.76           C  
ATOM     18  CG  MET     2      41.695   6.496   4.092  1.00 24.22           C  
ATOM     19  SD  MET     2      43.468   6.880   3.416  0.75 39.96          SE  
ATOM     20  CE  MET     2      43.383   5.684   1.998  1.00  5.02           C  
ATOM     21  N   THR     3      39.261   7.057   5.809  1.00 18.06           N  
ATOM     22  CA  THR     3      39.155   8.116   6.792  1.00 18.93           C  
ATOM     23  C   THR     3      40.413   8.185   7.675  1.00 20.74           C  
ATOM     24  O   THR     3      41.375   7.448   7.494  1.00 22.43           O  
ATOM     25  CB  THR     3      37.893   7.966   7.655  1.00 21.75           C  
ATOM     26  OG1 THR     3      37.694   9.133   8.465  1.00 18.69           O  
ATOM     27  CG2 THR     3      37.987   6.713   8.557  1.00 17.94           C  
ATOM     28  N   HIS     4      40.366   9.122   8.602  1.00 21.74           N  
ATOM     29  CA  HIS     4      41.543   9.535   9.390  1.00 19.82           C  
ATOM     30  C   HIS     4      41.063  10.538  10.400  1.00 20.35           C  
ATOM     31  O   HIS     4      39.997  11.129  10.244  1.00 21.12           O  
ATOM     32  CB  HIS     4      42.599  10.173   8.477  1.00 19.14           C  
ATOM     33  CG  HIS     4      43.871  10.570   9.164  1.00 16.70           C  
ATOM     34  ND1 HIS     4      44.149  11.870   9.535  1.00 11.70           N  
ATOM     35  CD2 HIS     4      44.964   9.844   9.504  1.00 15.71           C  
ATOM     36  CE1 HIS     4      45.351  11.927  10.074  1.00 15.16           C  
ATOM     37  NE2 HIS     4      45.869  10.708  10.067  1.00 16.41           N  
ATOM     38  N   TYR     5      41.843  10.728  11.448  1.00 18.41           N  
ATOM     39  CA  TYR     5      41.376  11.592  12.525  1.00 15.73           C  
ATOM     40  C   TYR     5      41.136  13.014  11.999  1.00 14.66           C  
ATOM     41  O   TYR     5      40.441  13.806  12.632  1.00 18.12           O  
ATOM     42  CB  TYR     5      42.302  11.582  13.772  1.00 16.57           C  
ATOM     43  CG  TYR     5      43.705  12.035  13.493  1.00 19.67           C  
ATOM     44  CD1 TYR     5      44.017  13.382  13.410  1.00 15.83           C  
ATOM     45  CD2 TYR     5      44.724  11.116  13.323  1.00 16.32           C  
ATOM     46  CE1 TYR     5      45.311  13.812  13.133  1.00 14.80           C  
ATOM     47  CE2 TYR     5      46.021  11.522  13.052  1.00 15.68           C  
ATOM     48  CZ  TYR     5      46.316  12.880  12.952  1.00 18.58           C  
ATOM     49  OH  TYR     5      47.619  13.285  12.672  1.00 19.48           O  
ATOM     50  N   SER     6      41.701  13.334  10.835  1.00 12.58           N  
ATOM     51  CA  SER     6      41.589  14.689  10.235  1.00 15.64           C  
ATOM     52  C   SER     6      40.297  14.879   9.452  1.00 15.04           C  
ATOM     53  O   SER     6      40.057  15.923   8.874  1.00 13.28           O  
ATOM     54  CB  SER     6      42.779  14.991   9.315  1.00 15.80           C  
ATOM     55  OG  SER     6      42.944  14.017   8.309  1.00 13.91           O  
ATOM     56  N   ASP     7      39.486  13.832   9.445  1.00 13.15           N  
ATOM     57  CA  ASP     7      38.153  13.853   8.788  1.00 13.53           C  
ATOM     58  C   ASP     7      37.129  14.682   9.611  1.00 12.10           C  
ATOM     59  O   ASP     7      36.377  14.174  10.440  1.00 12.59           O  
ATOM     60  CB  ASP     7      37.702  12.405   8.535  1.00 11.45           C  
ATOM     61  CG  ASP     7      36.580  12.296   7.519  1.00 11.94           C  
ATOM     62  OD1 ASP     7      35.865  13.295   7.333  1.00 10.90           O  
ATOM     63  OD2 ASP     7      36.405  11.174   6.976  1.00 14.51           O  
ATOM     64  N   ASN     8      37.115  15.979   9.346  1.00 12.97           N  
ATOM     65  CA  ASN     8      36.335  16.950  10.116  1.00 10.97           C  
ATOM     66  C   ASN     8      34.875  16.765   9.785  1.00 11.01           C  
ATOM     67  O   ASN     8      33.989  16.958  10.621  1.00 13.27           O  
ATOM     68  CB  ASN     8      36.727  18.377   9.707  1.00 12.06           C  
ATOM     69  CG  ASN     8      35.912  19.446  10.381  1.00 22.23           C  
ATOM     70  OD1 ASN     8      36.084  19.715  11.579  1.00 23.84           O  
ATOM     71  ND2 ASN     8      35.057  20.129   9.593  1.00 22.82           N  
ATOM     72  N   THR     9      34.638  16.374   8.548  1.00 10.91           N  
ATOM     73  CA  THR     9      33.260  16.169   8.090  1.00 11.35           C  
ATOM     74  C   THR     9      32.572  15.094   8.952  1.00  9.83           C  
ATOM     75  O   THR     9      31.485  15.297   9.479  1.00 10.44           O  
ATOM     76  CB  THR     9      33.206  15.889   6.558  1.00 10.50           C  
ATOM     77  OG1 THR     9      33.605  17.096   5.855  1.00 11.25           O  
ATOM     78  CG2 THR     9      31.819  15.438   6.121  1.00 11.84           C  
ATOM     79  N   LEU    10      33.241  13.964   9.089  1.00 11.01           N  
ATOM     80  CA  LEU    10      32.730  12.862   9.902  1.00 11.44           C  
ATOM     81  C   LEU    10      32.618  13.268  11.363  1.00 10.38           C  
ATOM     82  O   LEU    10      31.607  13.008  12.023  1.00 11.91           O  
ATOM     83  CB  LEU    10      33.592  11.607   9.789  1.00 11.87           C  
ATOM     84  CG  LEU    10      33.196  10.514   8.805  1.00 20.01           C  
ATOM     85  CD1 LEU    10      34.151   9.348   8.962  1.00 13.93           C  
ATOM     86  CD2 LEU    10      31.741  10.058   9.065  1.00 16.23           C  
ATOM     87  N   LYS    11      33.669  13.921  11.873  1.00 13.30           N  
ATOM     88  CA  LYS    11      33.698  14.325  13.257  1.00 12.30           C  
ATOM     89  C   LYS    11      32.511  15.221  13.601  1.00 14.11           C  
ATOM     90  O   LYS    11      31.738  14.965  14.528  1.00 12.36           O  
ATOM     91  CB  LYS    11      35.013  15.032  13.596  1.00 15.29           C  
ATOM     92  CG  LYS    11      35.143  15.316  15.082  1.00 21.53           C  
ATOM     93  CD  LYS    11      36.584  15.638  15.457  1.00 33.25           C  
ATOM     94  CE  LYS    11      36.692  16.115  16.898  1.00 32.81           C  
ATOM     95  NZ  LYS    11      36.023  17.433  17.061  1.00 39.78           N  
ATOM     96  N   VAL    12      32.365  16.273  12.811  1.00 12.56           N  
ATOM     97  CA  VAL    12      31.315  17.271  13.041  1.00 13.63           C  
ATOM     98  C   VAL    12      29.932  16.635  12.873  1.00  9.02           C  
ATOM     99  O   VAL    12      29.043  16.841  13.693  1.00  8.89           O  
ATOM    100  CB  VAL    12      31.487  18.508  12.130  1.00 12.75           C  
ATOM    101  CG1 VAL    12      30.258  19.425  12.192  1.00 12.24           C  
ATOM    102  CG2 VAL    12      32.732  19.247  12.536  1.00 17.16           C  
ATOM    103  N   ALA    13      29.756  15.869  11.811  1.00 10.10           N  
ATOM    104  CA  ALA    13      28.441  15.186  11.570  1.00 10.43           C  
ATOM    105  C   ALA    13      28.083  14.282  12.752  1.00 11.97           C  
ATOM    106  O   ALA    13      26.921  14.252  13.218  1.00 10.99           O  
ATOM    107  CB  ALA    13      28.441  14.367  10.245  1.00 11.80           C  
ATOM    108  N   HIS    14      29.071  13.533  13.221  1.00 13.09           N  
ATOM    109  CA  HIS    14      28.809  12.613  14.344  1.00 13.16           C  
ATOM    110  C   HIS    14      28.404  13.407  15.569  1.00 13.12           C  
ATOM    111  O   HIS    14      27.555  12.968  16.354  1.00 14.04           O  
ATOM    112  CB  HIS    14      29.985  11.686  14.681  1.00 13.86           C  
ATOM    113  CG  HIS    14      30.040  10.416  13.876  1.00 12.08           C  
ATOM    114  ND1 HIS    14      29.194   9.350  14.098  1.00 12.29           N  
ATOM    115  CD2 HIS    14      30.856  10.041  12.865  1.00 13.32           C  
ATOM    116  CE1 HIS    14      29.482   8.379  13.247  1.00 15.10           C  
ATOM    117  NE2 HIS    14      30.492   8.772  12.490  1.00 11.77           N  
ATOM    118  N   GLN    15      29.002  14.574  15.761  1.00 13.37           N  
ATOM    119  CA  GLN    15      28.634  15.385  16.926  1.00 13.64           C  
ATOM    120  C   GLN    15      27.209  15.854  16.747  1.00 13.49           C  
ATOM    121  O   GLN    15      26.409  15.807  17.663  1.00 11.78           O  
ATOM    122  CB  GLN    15      29.556  16.583  17.134  1.00 18.56           C  
ATOM    123  CG  GLN    15      29.195  17.384  18.380  1.00 24.05           C  
ATOM    124  CD  GLN    15      29.291  16.545  19.659  1.00 26.08           C  
ATOM    125  OE1 GLN    15      28.276  16.113  20.231  1.00 28.19           O  
ATOM    126  NE2 GLN    15      30.516  16.294  20.093  1.00 30.33           N  
ATOM    127  N   GLY    16      26.891  16.306  15.551  1.00 12.46           N  
ATOM    128  CA  GLY    16      25.507  16.684  15.215  1.00 13.56           C  
ATOM    129  C   GLY    16      24.520  15.565  15.460  1.00 10.34           C  
ATOM    130  O   GLY    16      23.409  15.799  15.988  1.00 12.49           O  
ATOM    131  N   PHE    17      24.933  14.347  15.122  1.00 12.77           N  
ATOM    132  CA  PHE    17      24.033  13.193  15.242  1.00 12.51           C  
ATOM    133  C   PHE    17      23.801  12.873  16.719  1.00 11.14           C  
ATOM    134  O   PHE    17      22.712  12.515  17.129  1.00  9.21           O  
ATOM    135  CB  PHE    17      24.504  11.961  14.484  1.00 16.01           C  
ATOM    136  CG  PHE    17      23.390  11.017  14.173  1.00 15.06           C  
ATOM    137  CD1 PHE    17      22.429  11.367  13.227  1.00 18.62           C  
ATOM    138  CD2 PHE    17      23.267   9.817  14.841  1.00 17.36           C  
ATOM    139  CE1 PHE    17      21.388  10.516  12.937  1.00 22.55           C  
ATOM    140  CE2 PHE    17      22.206   8.959  14.565  1.00 20.39           C  
ATOM    141  CZ  PHE    17      21.266   9.322  13.598  1.00 17.39           C  
ATOM    142  N   GLU    18      24.826  13.078  17.535  1.00 11.43           N  
ATOM    143  CA  GLU    18      24.643  12.935  18.991  1.00  9.34           C  
ATOM    144  C   GLU    18      23.591  13.916  19.490  1.00  9.51           C  
ATOM    145  O   GLU    18      22.708  13.552  20.231  1.00 11.21           O  
ATOM    146  CB  GLU    18      25.960  13.194  19.728  1.00 12.55           C  
ATOM    147  CG  GLU    18      26.947  12.085  19.555  1.00 14.94           C  
ATOM    148  CD  GLU    18      26.694  10.918  20.477  1.00 16.13           C  
ATOM    149  OE1 GLU    18      26.643  11.120  21.707  1.00 23.39           O  
ATOM    150  OE2 GLU    18      26.524   9.788  19.972  1.00 21.79           O  
ATOM    151  N   PHE    19      23.696  15.178  19.093  1.00 10.50           N  
ATOM    152  CA  PHE    19      22.735  16.198  19.554  1.00  7.69           C  
ATOM    153  C   PHE    19      21.331  15.955  18.976  1.00 10.71           C  
ATOM    154  O   PHE    19      20.315  16.270  19.608  1.00 11.65           O  
ATOM    155  CB  PHE    19      23.201  17.652  19.323  1.00  8.31           C  
ATOM    156  CG  PHE    19      24.412  18.007  20.141  1.00 12.83           C  
ATOM    157  CD1 PHE    19      24.595  17.419  21.366  1.00 18.48           C  
ATOM    158  CD2 PHE    19      25.369  18.892  19.680  1.00 16.97           C  
ATOM    159  CE1 PHE    19      25.715  17.698  22.143  1.00 23.28           C  
ATOM    160  CE2 PHE    19      26.497  19.180  20.454  1.00 16.71           C  
ATOM    161  CZ  PHE    19      26.660  18.571  21.687  1.00 17.32           C  
ATOM    162  N   PHE    20      21.298  15.334  17.802  1.00  8.23           N  
ATOM    163  CA  PHE    20      20.029  14.992  17.121  1.00  9.66           C  
ATOM    164  C   PHE    20      19.358  13.838  17.892  1.00  9.49           C  
ATOM    165  O   PHE    20      18.166  13.864  18.203  1.00 12.22           O  
ATOM    166  CB  PHE    20      20.325  14.602  15.666  1.00  9.04           C  
ATOM    167  CG  PHE    20      19.148  14.116  14.896  1.00  9.77           C  
ATOM    168  CD1 PHE    20      18.223  14.993  14.323  1.00 10.52           C  
ATOM    169  CD2 PHE    20      19.012  12.761  14.644  1.00 10.00           C  
ATOM    170  CE1 PHE    20      17.152  14.497  13.548  1.00  7.79           C  
ATOM    171  CE2 PHE    20      17.961  12.277  13.877  1.00 15.25           C  
ATOM    172  CZ  PHE    20      17.051  13.120  13.342  1.00  9.60           C  
ATOM    173  N   THR    21      20.180  12.879  18.293  1.00 12.27           N  
ATOM    174  CA  THR    21      19.718  11.744  19.096  1.00 11.13           C  
ATOM    175  C   THR    21      19.085  12.287  20.383  1.00 10.77           C  
ATOM    176  O   THR    21      17.989  11.900  20.782  1.00 10.47           O  
ATOM    177  CB  THR    21      20.884  10.765  19.412  1.00 11.73           C  
ATOM    178  OG1 THR    21      21.315  10.141  18.195  1.00  9.46           O  
ATOM    179  CG2 THR    21      20.484   9.689  20.455  1.00 10.83           C  
ATOM    180  N   GLN    22      19.820  13.198  21.010  1.00 11.52           N  
ATOM    181  CA  GLN    22      19.401  13.798  22.297  1.00 12.37           C  
ATOM    182  C   GLN    22      18.076  14.579  22.144  1.00 11.29           C  
ATOM    183  O   GLN    22      17.173  14.503  22.981  1.00 12.02           O  
ATOM    184  CB  GLN    22      20.503  14.701  22.839  1.00 14.50           C  
ATOM    185  CG  GLN    22      20.144  15.381  24.125  1.00 13.55           C  
ATOM    186  CD  GLN    22      21.301  16.171  24.706  1.00 18.54           C  
ATOM    187  OE1 GLN    22      22.427  16.088  24.220  1.00 20.45           O  
ATOM    188  NE2 GLN    22      21.026  16.927  25.764  1.00 18.35           N  
ATOM    189  N   GLY    23      17.946  15.277  21.021  1.00 12.24           N  
ATOM    190  CA  GLY    23      16.752  16.043  20.743  1.00 12.59           C  
ATOM    191  C   GLY    23      15.563  15.138  20.567  1.00 11.27           C  
ATOM    192  O   GLY    23      14.472  15.386  21.074  1.00 11.77           O  
ATOM    193  N   LEU    24      15.777  14.033  19.861  1.00 10.38           N  
ATOM    194  CA  LEU    24      14.697  13.106  19.633  1.00 12.94           C  
ATOM    195  C   LEU    24      14.255  12.491  20.957  1.00 11.49           C  
ATOM    196  O   LEU    24      13.087  12.295  21.185  1.00  9.59           O  
ATOM    197  CB  LEU    24      15.126  11.981  18.720  1.00 10.27           C  
ATOM    198  CG  LEU    24      15.230  12.386  17.254  1.00 10.66           C  
ATOM    199  CD1 LEU    24      15.689  11.145  16.477  1.00 12.63           C  
ATOM    200  CD2 LEU    24      13.856  12.866  16.762  1.00  6.91           C  
ATOM    201  N   ALA    25      15.218  12.155  21.809  1.00 11.45           N  
ATOM    202  CA  ALA    25      14.906  11.379  23.038  1.00 10.73           C  
ATOM    203  C   ALA    25      14.298  12.267  24.104  1.00 12.29           C  
ATOM    204  O   ALA    25      13.548  11.817  24.956  1.00 14.57           O  
ATOM    205  CB  ALA    25      16.157  10.692  23.599  1.00 12.41           C  
ATOM    206  N   THR    26      14.653  13.537  24.066  1.00 11.55           N  
ATOM    207  CA  THR    26      14.371  14.463  25.193  1.00 13.36           C  
ATOM    208  C   THR    26      13.546  15.702  24.853  1.00 12.24           C  
ATOM    209  O   THR    26      12.969  16.332  25.734  1.00 15.80           O  
ATOM    210  CB  THR    26      15.670  14.983  25.860  1.00 14.02           C  
ATOM    211  OG1 THR    26      16.332  15.901  24.992  1.00 14.31           O  
ATOM    212  CG2 THR    26      16.590  13.831  26.273  1.00 11.67           C  
ATOM    213  N   GLY    27      13.534  16.061  23.583  1.00 12.86           N  
ATOM    214  CA  GLY    27      12.792  17.208  23.074  1.00 15.08           C  
ATOM    215  C   GLY    27      13.531  18.513  23.299  1.00 14.86           C  
ATOM    216  O   GLY    27      13.026  19.606  23.064  1.00 17.78           O  
ATOM    217  N   GLU    28      14.752  18.376  23.779  1.00 15.76           N  
ATOM    218  CA  GLU    28      15.653  19.526  23.944  1.00 17.87           C  
ATOM    219  C   GLU    28      16.608  19.631  22.758  1.00 13.89           C  
ATOM    220  O   GLU    28      17.513  18.806  22.579  1.00 15.40           O  
ATOM    221  CB  GLU    28      16.467  19.398  25.229  1.00 18.87           C  
ATOM    222  CG  GLU    28      15.615  19.303  26.461  1.00 25.87           C  
ATOM    223  CD  GLU    28      14.956  20.617  26.771  1.00 31.86           C  
ATOM    224  OE1 GLU    28      15.554  21.670  26.444  1.00 37.17           O  
ATOM    225  OE2 GLU    28      13.839  20.602  27.335  1.00 42.78           O  
ATOM    226  N   TRP    29      16.385  20.652  21.961  1.00 16.28           N  
ATOM    227  CA  TRP    29      17.059  20.808  20.665  1.00 15.30           C  
ATOM    228  C   TRP    29      18.135  21.909  20.627  1.00 16.94           C  
ATOM    229  O   TRP    29      18.797  22.087  19.601  1.00 14.19           O  
ATOM    230  CB  TRP    29      16.015  21.057  19.572  1.00 16.33           C  
ATOM    231  CG  TRP    29      15.212  19.840  19.280  1.00 13.32           C  
ATOM    232  CD1 TRP    29      13.976  19.529  19.760  1.00 10.70           C  
ATOM    233  CD2 TRP    29      15.604  18.752  18.443  1.00 15.31           C  
ATOM    234  NE1 TRP    29      13.584  18.296  19.287  1.00 11.22           N  
ATOM    235  CE2 TRP    29      14.561  17.810  18.466  1.00 17.69           C  
ATOM    236  CE3 TRP    29      16.731  18.494  17.658  1.00 13.07           C  
ATOM    237  CZ2 TRP    29      14.615  16.633  17.729  1.00 13.24           C  
ATOM    238  CZ3 TRP    29      16.788  17.324  16.936  1.00 12.35           C  
ATOM    239  CH2 TRP    29      15.738  16.410  16.976  1.00 16.87           C  
ATOM    240  N   GLN    30      18.335  22.636  21.730  1.00 16.29           N  
ATOM    241  CA  GLN    30      19.257  23.785  21.658  1.00 16.19           C  
ATOM    242  C   GLN    30      20.664  23.410  21.211  1.00 12.03           C  
ATOM    243  O   GLN    30      21.308  24.140  20.459  1.00 13.55           O  
ATOM    244  CB  GLN    30      19.306  24.588  22.962  1.00 17.29           C  
ATOM    245  CG  GLN    30      19.864  25.980  22.721  1.00 18.78           C  
ATOM    246  CD  GLN    30      19.074  26.737  21.659  1.00 23.58           C  
ATOM    247  OE1 GLN    30      17.851  26.872  21.760  1.00 25.39           O  
ATOM    248  NE2 GLN    30      19.767  27.230  20.634  1.00 25.31           N  
ATOM    249  N   LYS    31      21.138  22.252  21.644  1.00 14.71           N  
ATOM    250  CA  LYS    31      22.531  21.866  21.400  1.00 15.47           C  
ATOM    251  C   LYS    31      22.698  21.589  19.908  1.00 12.67           C  
ATOM    252  O   LYS    31      23.692  21.974  19.299  1.00 14.25           O  
ATOM    253  CB  LYS    31      22.964  20.678  22.266  1.00 16.15           C  
ATOM    254  CG  LYS    31      23.211  21.084  23.708  1.00 19.77           C  
ATOM    255  CD  LYS    31      24.136  20.131  24.407  1.00 28.45           C  
ATOM    256  CE  LYS    31      24.378  20.549  25.864  1.00 36.82           C  
ATOM    257  NZ  LYS    31      25.118  21.841  25.970  1.00 39.91           N  
ATOM    258  N   PHE    32      21.694  20.924  19.331  1.00 12.48           N  
ATOM    259  CA  PHE    32      21.682  20.667  17.879  1.00 10.72           C  
ATOM    260  C   PHE    32      21.609  21.988  17.103  1.00 11.58           C  
ATOM    261  O   PHE    32      22.368  22.216  16.168  1.00 13.01           O  
ATOM    262  CB  PHE    32      20.531  19.724  17.469  1.00  9.77           C  
ATOM    263  CG  PHE    32      20.548  19.385  16.023  1.00 13.73           C  
ATOM    264  CD1 PHE    32      21.580  18.602  15.505  1.00  9.81           C  
ATOM    265  CD2 PHE    32      19.541  19.822  15.168  1.00 15.39           C  
ATOM    266  CE1 PHE    32      21.616  18.260  14.158  1.00  9.77           C  
ATOM    267  CE2 PHE    32      19.585  19.491  13.826  1.00 11.55           C  
ATOM    268  CZ  PHE    32      20.643  18.709  13.324  1.00 14.39           C  
ATOM    269  N   LEU    33      20.699  22.862  17.511  1.00 13.15           N  
ATOM    270  CA  LEU    33      20.483  24.138  16.826  1.00 13.19           C  
ATOM    271  C   LEU    33      21.743  25.001  16.836  1.00 13.71           C  
ATOM    272  O   LEU    33      22.065  25.693  15.871  1.00 13.58           O  
ATOM    273  CB  LEU    33      19.334  24.921  17.481  1.00 14.37           C  
ATOM    274  CG  LEU    33      17.926  24.376  17.285  1.00 16.90           C  
ATOM    275  CD1 LEU    33      16.941  25.092  18.192  1.00 13.81           C  
ATOM    276  CD2 LEU    33      17.489  24.485  15.815  1.00 17.06           C  
ATOM    277  N   ASP    34      22.460  24.920  17.944  1.00 15.03           N  
ATOM    278  CA  ASP    34      23.642  25.753  18.144  1.00 15.97           C  
ATOM    279  C   ASP    34      24.732  25.363  17.136  1.00 18.09           C  
ATOM    280  O   ASP    34      25.680  26.117  16.871  1.00 19.45           O  
ATOM    281  CB  ASP    34      24.166  25.648  19.581  1.00 16.58           C  
ATOM    282  CG  ASP    34      23.348  26.470  20.569  1.00 19.15           C  
ATOM    283  OD1 ASP    34      22.471  27.249  20.153  1.00 20.73           O  
ATOM    284  OD2 ASP    34      23.590  26.332  21.792  1.00 23.53           O  
ATOM    285  N   MET    35      24.597  24.163  16.585  1.00 16.32           N  
ATOM    286  CA  MET    35      25.606  23.668  15.659  1.00 15.78           C  
ATOM    287  C   MET    35      25.248  23.956  14.226  1.00 13.62           C  
ATOM    288  O   MET    35      25.985  23.574  13.316  1.00 14.37           O  
ATOM    289  CB  MET    35      25.813  22.169  15.816  1.00 17.08           C  
ATOM    290  CG  MET    35      26.852  21.814  16.835  1.00 21.53           C  
ATOM    291  SD  MET    35      26.974  19.940  16.638  0.75 23.34          SE  
ATOM    292  CE  MET    35      28.196  19.818  15.087  1.00 16.98           C  
ATOM    293  N   LEU    36      24.121  24.628  14.028  1.00 12.32           N  
ATOM    294  CA  LEU    36      23.644  24.934  12.664  1.00 13.58           C  
ATOM    295  C   LEU    36      24.101  26.319  12.201  1.00 15.09           C  
ATOM    296  O   LEU    36      24.126  27.276  12.973  1.00 16.54           O  
ATOM    297  CB  LEU    36      22.110  24.816  12.586  1.00 14.98           C  
ATOM    298  CG  LEU    36      21.513  23.569  13.234  1.00  9.40           C  
ATOM    299  CD1 LEU    36      19.996  23.498  13.067  1.00 12.92           C  
ATOM    300  CD2 LEU    36      22.164  22.327  12.620  1.00  9.04           C  
ATOM    301  N   THR    37      24.462  26.403  10.928  1.00 15.90           N  
ATOM    302  CA  THR    37      24.878  27.662  10.302  1.00 14.15           C  
ATOM    303  C   THR    37      23.681  28.603  10.144  1.00 14.96           C  
ATOM    304  O   THR    37      22.520  28.198  10.161  1.00 14.21           O  
ATOM    305  CB  THR    37      25.543  27.447   8.919  1.00 12.74           C  
ATOM    306  OG1 THR    37      24.588  26.882   8.026  1.00 13.81           O  
ATOM    307  CG2 THR    37      26.781  26.603   9.010  1.00 16.22           C  
ATOM    308  N   GLU    38      23.962  29.891   9.985  1.00 15.38           N  
ATOM    309  CA  GLU    38      22.890  30.866   9.904  1.00 17.39           C  
ATOM    310  C   GLU    38      22.038  30.676   8.649  1.00 17.09           C  
ATOM    311  O   GLU    38      20.868  31.065   8.613  1.00 19.29           O  
ATOM    312  CB  GLU    38      23.439  32.304   9.946  1.00 19.64           C  
ATOM    313  CG  GLU    38      24.164  32.639  11.250  1.00 28.80           C  
ATOM    314  CD  GLU    38      23.324  32.339  12.489  1.00 38.46           C  
ATOM    315  OE1 GLU    38      22.169  32.816  12.579  1.00 42.24           O  
ATOM    316  OE2 GLU    38      23.827  31.624  13.386  1.00 42.86           O  
ATOM    317  N   ASP    39      22.654  30.086   7.631  1.00 16.45           N  
ATOM    318  CA  ASP    39      22.000  29.862   6.329  1.00 15.56           C  
ATOM    319  C   ASP    39      21.507  28.416   6.224  1.00 13.72           C  
ATOM    320  O   ASP    39      21.251  27.909   5.144  1.00 11.13           O  
ATOM    321  CB  ASP    39      22.896  30.210   5.132  1.00 14.84           C  
ATOM    322  CG  ASP    39      24.153  29.368   5.047  1.00 14.73           C  
ATOM    323  OD1 ASP    39      24.561  28.754   6.069  1.00 15.34           O  
ATOM    324  OD2 ASP    39      24.775  29.343   3.963  1.00 19.52           O  
ATOM    325  N   PHE    40      21.370  27.796   7.384  1.00 15.10           N  
ATOM    326  CA  PHE    40      20.911  26.395   7.476  1.00 14.39           C  
ATOM    327  C   PHE    40      19.624  26.173   6.672  1.00 14.14           C  
ATOM    328  O   PHE    40      18.681  26.954   6.781  1.00 16.17           O  
ATOM    329  CB  PHE    40      20.650  26.023   8.939  1.00 13.84           C  
ATOM    330  CG  PHE    40      20.144  24.615   9.126  1.00 13.08           C  
ATOM    331  CD1 PHE    40      21.012  23.546   9.038  1.00 12.45           C  
ATOM    332  CD2 PHE    40      18.791  24.363   9.401  1.00 16.37           C  
ATOM    333  CE1 PHE    40      20.539  22.220   9.227  1.00 10.66           C  
ATOM    334  CE2 PHE    40      18.317  23.044   9.604  1.00 12.33           C  
ATOM    335  CZ  PHE    40      19.212  21.983   9.501  1.00  9.72           C  
ATOM    336  N   THR    41      19.590  25.100   5.876  1.00 12.06           N  
ATOM    337  CA  THR    41      18.338  24.703   5.196  1.00  8.77           C  
ATOM    338  C   THR    41      18.062  23.253   5.486  1.00 11.83           C  
ATOM    339  O   THR    41      18.961  22.491   5.845  1.00 10.57           O  
ATOM    340  CB  THR    41      18.399  24.841   3.676  1.00 14.53           C  
ATOM    341  OG1 THR    41      19.229  23.798   3.126  1.00 14.69           O  
ATOM    342  CG2 THR    41      18.891  26.211   3.254  1.00 13.54           C  
ATOM    343  N   PHE    42      16.803  22.894   5.400  1.00 11.17           N  
ATOM    344  CA  PHE    42      16.434  21.483   5.642  1.00 12.63           C  
ATOM    345  C   PHE    42      15.305  21.116   4.719  1.00 11.99           C  
ATOM    346  O   PHE    42      14.414  21.912   4.437  1.00 14.90           O  
ATOM    347  CB  PHE    42      16.081  21.168   7.104  1.00 13.88           C  
ATOM    348  CG  PHE    42      14.893  21.940   7.669  1.00 15.08           C  
ATOM    349  CD1 PHE    42      15.023  23.267   8.063  1.00 14.41           C  
ATOM    350  CD2 PHE    42      13.673  21.341   7.850  1.00 19.28           C  
ATOM    351  CE1 PHE    42      13.943  23.955   8.594  1.00 15.81           C  
ATOM    352  CE2 PHE    42      12.599  22.037   8.369  1.00 17.18           C  
ATOM    353  CZ  PHE    42      12.751  23.347   8.744  1.00 15.56           C  
ATOM    354  N   TRP    43      15.375  19.890   4.242  1.00  8.68           N  
ATOM    355  CA  TRP    43      14.350  19.340   3.336  1.00  8.72           C  
ATOM    356  C   TRP    43      13.628  18.186   4.051  1.00  8.36           C  
ATOM    357  O   TRP    43      14.259  17.317   4.649  1.00  9.64           O  
ATOM    358  CB  TRP    43      15.013  18.803   2.058  1.00  8.15           C  
ATOM    359  CG  TRP    43      14.488  19.324   0.772  1.00 11.56           C  
ATOM    360  CD1 TRP    43      15.044  20.309   0.008  1.00 15.18           C  
ATOM    361  CD2 TRP    43      13.328  18.872   0.059  1.00 13.48           C  
ATOM    362  NE1 TRP    43      14.295  20.510  -1.110  1.00 19.33           N  
ATOM    363  CE2 TRP    43      13.233  19.646  -1.110  1.00 15.62           C  
ATOM    364  CE3 TRP    43      12.349  17.917   0.309  1.00 11.39           C  
ATOM    365  CZ2 TRP    43      12.205  19.479  -2.039  1.00 11.62           C  
ATOM    366  CZ3 TRP    43      11.320  17.745  -0.628  1.00 13.12           C  
ATOM    367  CH2 TRP    43      11.255  18.544  -1.779  1.00 15.27           C  
ATOM    368  N   PHE    44      12.306  18.194   3.961  1.00 11.06           N  
ATOM    369  CA  PHE    44      11.462  17.187   4.604  1.00 10.79           C  
ATOM    370  C   PHE    44      10.351  16.708   3.632  1.00  8.81           C  
ATOM    371  O   PHE    44       9.914  17.434   2.774  1.00 10.22           O  
ATOM    372  CB  PHE    44      10.927  17.764   5.926  1.00 10.46           C  
ATOM    373  CG  PHE    44      10.175  16.785   6.781  1.00 10.17           C  
ATOM    374  CD1 PHE    44      10.843  15.959   7.669  1.00  9.68           C  
ATOM    375  CD2 PHE    44       8.787  16.715   6.720  1.00  9.23           C  
ATOM    376  CE1 PHE    44      10.139  15.070   8.476  1.00  9.34           C  
ATOM    377  CE2 PHE    44       8.088  15.827   7.515  1.00 12.62           C  
ATOM    378  CZ  PHE    44       8.760  15.009   8.394  1.00 12.03           C  
ATOM    379  N   PRO    45       9.926  15.436   3.741  1.00  8.41           N  
ATOM    380  CA  PRO    45       9.158  14.909   2.621  1.00  7.96           C  
ATOM    381  C   PRO    45       7.728  15.353   2.464  1.00 10.34           C  
ATOM    382  O   PRO    45       7.214  15.350   1.351  1.00 13.63           O  
ATOM    383  CB  PRO    45       9.195  13.386   2.862  1.00 10.53           C  
ATOM    384  CG  PRO    45      10.405  13.180   3.720  1.00 10.16           C  
ATOM    385  CD  PRO    45      10.438  14.366   4.611  1.00  9.99           C  
ATOM    386  N   MET    46       7.092  15.701   3.573  1.00 10.70           N  
ATOM    387  CA  MET    46       5.642  15.940   3.578  1.00 12.79           C  
ATOM    388  C   MET    46       5.169  16.853   4.680  1.00 13.87           C  
ATOM    389  O   MET    46       5.850  17.121   5.664  1.00 12.21           O  
ATOM    390  CB  MET    46       4.859  14.607   3.653  1.00 12.79           C  
ATOM    391  CG  MET    46       4.965  13.881   4.958  1.00 16.29           C  
ATOM    392  SD  MET    46       3.914  12.197   4.927  0.75 20.20          SE  
ATOM    393  CE  MET    46       2.522  12.551   6.241  1.00 15.87           C  
ATOM    394  N   GLY    47       3.950  17.293   4.473  1.00 14.84           N  
ATOM    395  CA  GLY    47       3.184  18.019   5.456  1.00 16.83           C  
ATOM    396  C   GLY    47       3.570  19.461   5.480  1.00 14.67           C  
ATOM    397  O   GLY    47       4.020  20.005   4.479  1.00 14.30           O  
ATOM    398  N   GLU    48       3.377  20.049   6.645  1.00 12.39           N  
ATOM    399  CA  GLU    48       3.588  21.493   6.829  1.00 15.35           C  
ATOM    400  C   GLU    48       4.975  21.909   6.411  1.00 13.60           C  
ATOM    401  O   GLU    48       5.167  22.994   5.879  1.00 15.07           O  
ATOM    402  CB  GLU    48       3.384  21.901   8.293  1.00 17.75           C  
ATOM    403  CG  GLU    48       3.887  23.330   8.605  1.00 23.91           C  
ATOM    404  CD  GLU    48       3.789  23.647  10.093  1.00 38.45           C  
ATOM    405  OE1 GLU    48       3.450  22.720  10.874  1.00 35.19           O  
ATOM    406  OE2 GLU    48       4.049  24.811  10.484  1.00 45.28           O  
ATOM    407  N   PHE    49       5.944  21.044   6.690  1.00 12.21           N  
ATOM    408  CA  PHE    49       7.357  21.312   6.420  1.00 10.89           C  
ATOM    409  C   PHE    49       7.876  20.634   5.139  1.00 11.85           C  
ATOM    410  O   PHE    49       9.073  20.498   4.912  1.00 10.72           O  
ATOM    411  CB  PHE    49       8.211  20.930   7.634  1.00 11.95           C  
ATOM    412  CG  PHE    49       7.918  21.751   8.867  1.00 13.48           C  
ATOM    413  CD1 PHE    49       8.560  22.964   9.068  1.00 17.18           C  
ATOM    414  CD2 PHE    49       7.007  21.323   9.806  1.00 12.34           C  
ATOM    415  CE1 PHE    49       8.297  23.734  10.202  1.00 17.78           C  
ATOM    416  CE2 PHE    49       6.727  22.083  10.935  1.00 15.75           C  
ATOM    417  CZ  PHE    49       7.377  23.298  11.136  1.00 14.07           C  
ATOM    418  N   HIS    50       6.953  20.236   4.275  1.00 10.64           N  
ATOM    419  CA  HIS    50       7.370  19.656   3.013  1.00 12.19           C  
ATOM    420  C   HIS    50       8.268  20.623   2.272  1.00 12.95           C  
ATOM    421  O   HIS    50       8.033  21.830   2.237  1.00 11.74           O  
ATOM    422  CB  HIS    50       6.163  19.332   2.131  1.00 12.83           C  
ATOM    423  CG  HIS    50       6.529  19.155   0.695  1.00 15.54           C  
ATOM    424  ND1 HIS    50       6.901  17.930   0.182  1.00 17.36           N  
ATOM    425  CD2 HIS    50       6.631  20.039  -0.322  1.00 14.80           C  
ATOM    426  CE1 HIS    50       7.199  18.069  -1.100  1.00 14.14           C  
ATOM    427  NE2 HIS    50       7.053  19.339  -1.430  1.00 20.47           N  
ATOM    428  N   GLY    51       9.310  20.071   1.675  1.00 13.71           N  
ATOM    429  CA  GLY    51      10.217  20.763   0.777  1.00 14.11           C  
ATOM    430  C   GLY    51      11.371  21.467   1.451  1.00 13.46           C  
ATOM    431  O   GLY    51      11.824  21.067   2.520  1.00 13.11           O  
ATOM    432  N   LEU    52      11.820  22.541   0.810  1.00 15.18           N  
ATOM    433  CA  LEU    52      12.963  23.305   1.287  1.00 15.63           C  
ATOM    434  C   LEU    52      12.516  24.331   2.322  1.00 18.48           C  
ATOM    435  O   LEU    52      11.572  25.108   2.106  1.00 16.37           O  
ATOM    436  CB  LEU    52      13.679  24.012   0.126  1.00 16.38           C  
ATOM    437  CG  LEU    52      14.921  24.785   0.578  1.00 20.77           C  
ATOM    438  CD1 LEU    52      16.092  23.855   0.784  1.00 20.83           C  
ATOM    439  CD2 LEU    52      15.223  25.888  -0.446  1.00 26.43           C  
ATOM    440  N   ASN    53      13.201  24.296   3.455  1.00 14.02           N  
ATOM    441  CA  ASN    53      12.947  25.207   4.573  1.00 14.04           C  
ATOM    442  C   ASN    53      14.207  25.951   4.880  1.00 14.26           C  
ATOM    443  O   ASN    53      15.265  25.363   4.916  1.00 11.51           O  
ATOM    444  CB  ASN    53      12.528  24.408   5.806  1.00 14.22           C  
ATOM    445  CG  ASN    53      11.211  23.683   5.611  1.00 15.97           C  
ATOM    446  OD1 ASN    53      10.165  24.199   5.948  1.00 15.74           O  
ATOM    447  ND2 ASN    53      11.269  22.471   5.074  1.00 13.28           N  
ATOM    448  N   VAL    54      14.094  27.261   5.111  1.00 13.87           N  
ATOM    449  CA  VAL    54      15.292  28.090   5.235  1.00 15.85           C  
ATOM    450  C   VAL    54      15.386  28.736   6.600  1.00 13.66           C  
ATOM    451  O   VAL    54      14.419  29.288   7.111  1.00 14.82           O  
ATOM    452  CB  VAL    54      15.300  29.182   4.118  1.00 18.14           C  
ATOM    453  CG1 VAL    54      16.477  30.147   4.286  1.00 18.78           C  
ATOM    454  CG2 VAL    54      15.316  28.524   2.743  1.00 15.69           C  
ATOM    455  N   GLY    55      16.569  28.633   7.188  1.00 15.29           N  
ATOM    456  CA  GLY    55      16.886  29.305   8.453  1.00 16.72           C  
ATOM    457  C   GLY    55      16.613  28.616   9.767  1.00 17.30           C  
ATOM    458  O   GLY    55      15.820  27.674   9.862  1.00 17.63           O  
ATOM    459  N   LYS    56      17.271  29.136  10.807  1.00 16.26           N  
ATOM    460  CA  LYS    56      17.286  28.501  12.140  1.00 16.13           C  
ATOM    461  C   LYS    56      16.020  28.712  12.969  1.00 16.81           C  
ATOM    462  O   LYS    56      15.686  27.897  13.809  1.00 17.56           O  
ATOM    463  CB  LYS    56      18.519  28.919  12.949  1.00 16.55           C  
ATOM    464  CG  LYS    56      19.817  28.381  12.361  1.00 19.01           C  
ATOM    465  CD  LYS    56      21.038  28.849  13.120  1.00 18.61           C  
ATOM    466  CE  LYS    56      21.073  28.316  14.519  1.00 14.44           C  
ATOM    467  NZ  LYS    56      22.410  28.510  15.174  1.00 21.11           N  
ATOM    468  N   GLU    57      15.312  29.798  12.709  1.00 17.21           N  
ATOM    469  CA  GLU    57      14.013  30.024  13.370  1.00 18.77           C  
ATOM    470  C   GLU    57      13.047  28.939  12.922  1.00 17.40           C  
ATOM    471  O   GLU    57      12.328  28.343  13.715  1.00 16.87           O  
ATOM    472  CB  GLU    57      13.407  31.371  13.002  1.00 20.71           C  
ATOM    473  CG  GLU    57      14.236  32.568  13.438  1.00 27.64           C  
ATOM    474  N   ARG    58      13.011  28.753  11.616  1.00 17.37           N  
ATOM    475  CA  ARG    58      12.144  27.740  11.009  1.00 17.15           C  
ATOM    476  C   ARG    58      12.590  26.327  11.445  1.00 15.38           C  
ATOM    477  O   ARG    58      11.770  25.434  11.697  1.00 16.07           O  
ATOM    478  CB  ARG    58      12.130  27.860   9.491  1.00 17.87           C  
ATOM    479  CG  ARG    58      11.252  26.845   8.820  1.00 21.39           C  
ATOM    480  CD  ARG    58       9.785  27.166   8.967  1.00 27.34           C  
ATOM    481  NE  ARG    58       9.003  26.429   7.967  1.00 30.10           N  
ATOM    482  CZ  ARG    58       7.687  26.247   8.022  1.00 31.12           C  
ATOM    483  NH1 ARG    58       6.975  26.729   9.041  1.00 26.47           N  
ATOM    484  NH2 ARG    58       7.093  25.548   7.069  1.00 27.25           N  
ATOM    485  N   ALA    59      13.893  26.158  11.600  1.00 14.34           N  
ATOM    486  CA  ALA    59      14.435  24.847  12.066  1.00 13.75           C  
ATOM    487  C   ALA    59      13.904  24.542  13.464  1.00 15.98           C  
ATOM    488  O   ALA    59      13.449  23.441  13.756  1.00 12.25           O  
ATOM    489  CB  ALA    59      15.949  24.865  12.072  1.00 14.10           C  
ATOM    490  N   LYS    60      13.945  25.540  14.327  1.00 14.03           N  
ATOM    491  CA  LYS    60      13.419  25.373  15.691  1.00 15.12           C  
ATOM    492  C   LYS    60      11.942  24.984  15.695  1.00 14.90           C  
ATOM    493  O   LYS    60      11.488  24.114  16.451  1.00 14.26           O  
ATOM    494  CB  LYS    60      13.614  26.640  16.531  1.00 17.07           C  
ATOM    495  CG  LYS    60      13.207  26.399  17.955  1.00 18.98           C  
ATOM    496  CD  LYS    60      13.790  27.396  18.928  1.00 24.82           C  
ATOM    497  CE  LYS    60      13.342  27.065  20.354  1.00 26.68           C  
ATOM    498  NZ  LYS    60      13.258  28.282  21.218  1.00 30.23           N  
ATOM    499  N   GLU    61      11.190  25.611  14.814  1.00 13.55           N  
ATOM    500  CA  GLU    61       9.761  25.314  14.719  1.00 15.45           C  
ATOM    501  C   GLU    61       9.608  23.832  14.379  1.00 13.98           C  
ATOM    502  O   GLU    61       8.862  23.093  15.010  1.00 15.15           O  
ATOM    503  CB  GLU    61       9.098  26.167  13.659  1.00 18.00           C  
ATOM    504  CG  GLU    61       9.195  27.654  13.988  1.00 26.81           C  
ATOM    505  CD  GLU    61       8.591  28.561  12.927  1.00 32.35           C  
ATOM    506  OE1 GLU    61       8.060  28.057  11.908  1.00 36.05           O  
ATOM    507  OE2 GLU    61       8.655  29.790  13.132  1.00 43.74           O  
ATOM    508  N   PHE    62      10.336  23.444  13.349  1.00 13.64           N  
ATOM    509  CA  PHE    62      10.300  22.051  12.860  1.00 12.13           C  
ATOM    510  C   PHE    62      10.629  21.032  13.977  1.00 12.09           C  
ATOM    511  O   PHE    62       9.884  20.049  14.254  1.00 13.14           O  
ATOM    512  CB  PHE    62      11.279  21.879  11.702  1.00 12.00           C  
ATOM    513  CG  PHE    62      11.418  20.468  11.267  1.00 12.94           C  
ATOM    514  CD1 PHE    62      10.349  19.809  10.703  1.00 17.22           C  
ATOM    515  CD2 PHE    62      12.614  19.780  11.460  1.00 17.59           C  
ATOM    516  CE1 PHE    62      10.464  18.494  10.295  1.00 17.53           C  
ATOM    517  CE2 PHE    62      12.728  18.441  11.066  1.00 10.67           C  
ATOM    518  CZ  PHE    62      11.646  17.816  10.470  1.00 18.44           C  
ATOM    519  N   PHE    63      11.749  21.260  14.653  1.00 11.63           N  
ATOM    520  CA  PHE    63      12.211  20.253  15.635  1.00 12.54           C  
ATOM    521  C   PHE    63      11.273  20.209  16.856  1.00 12.56           C  
ATOM    522  O   PHE    63      11.008  19.157  17.427  1.00 12.48           O  
ATOM    523  CB  PHE    63      13.681  20.492  15.978  1.00 13.35           C  
ATOM    524  CG  PHE    63      14.598  20.083  14.868  1.00 15.40           C  
ATOM    525  CD1 PHE    63      14.618  18.761  14.438  1.00 10.62           C  
ATOM    526  CD2 PHE    63      15.399  20.994  14.222  1.00 18.27           C  
ATOM    527  CE1 PHE    63      15.462  18.355  13.393  1.00 11.05           C  
ATOM    528  CE2 PHE    63      16.227  20.587  13.171  1.00 17.65           C  
ATOM    529  CZ  PHE    63      16.248  19.262  12.765  1.00 16.57           C  
ATOM    530  N   THR    64      10.746  21.374  17.215  1.00 12.52           N  
ATOM    531  CA  THR    64       9.745  21.445  18.270  1.00 15.56           C  
ATOM    532  C   THR    64       8.487  20.661  17.898  1.00 16.01           C  
ATOM    533  O   THR    64       7.896  19.944  18.709  1.00 19.91           O  
ATOM    534  CB  THR    64       9.364  22.900  18.589  1.00 13.64           C  
ATOM    535  OG1 THR    64      10.535  23.599  19.030  1.00 16.57           O  
ATOM    536  CG2 THR    64       8.308  22.941  19.646  1.00 17.91           C  
ATOM    537  N   TYR    65       8.145  20.780  16.630  1.00 16.36           N  
ATOM    538  CA  TYR    65       6.977  20.129  16.043  1.00 15.56           C  
ATOM    539  C   TYR    65       7.172  18.634  16.070  1.00 18.87           C  
ATOM    540  O   TYR    65       6.261  17.874  16.374  1.00 19.15           O  
ATOM    541  CB  TYR    65       6.756  20.615  14.603  1.00 17.22           C  
ATOM    542  CG  TYR    65       5.703  19.828  13.851  1.00 22.45           C  
ATOM    543  CD1 TYR    65       4.369  19.874  14.246  1.00 28.48           C  
ATOM    544  CD2 TYR    65       6.035  19.040  12.755  1.00 25.26           C  
ATOM    545  CE1 TYR    65       3.391  19.156  13.576  1.00 32.19           C  
ATOM    546  CE2 TYR    65       5.063  18.326  12.067  1.00 27.42           C  
ATOM    547  CZ  TYR    65       3.742  18.384  12.484  1.00 35.21           C  
ATOM    548  OH  TYR    65       2.758  17.671  11.822  1.00 35.99           O  
ATOM    549  N   VAL    66       8.382  18.224  15.743  1.00 18.54           N  
ATOM    550  CA  VAL    66       8.701  16.781  15.691  1.00 16.75           C  
ATOM    551  C   VAL    66       8.452  16.193  17.065  1.00 18.24           C  
ATOM    552  O   VAL    66       7.828  15.145  17.209  1.00 19.47           O  
ATOM    553  CB  VAL    66      10.144  16.523  15.234  1.00 16.29           C  
ATOM    554  CG1 VAL    66      10.587  15.079  15.641  1.00 13.88           C  
ATOM    555  CG2 VAL    66      10.270  16.773  13.719  1.00 13.64           C  
ATOM    556  N   SER    67       8.948  16.882  18.087  1.00 15.85           N  
ATOM    557  CA  SER    67       8.904  16.366  19.466  1.00 17.39           C  
ATOM    558  C   SER    67       7.538  16.529  20.170  1.00 19.91           C  
ATOM    559  O   SER    67       7.243  15.842  21.135  1.00 18.78           O  
ATOM    560  CB  SER    67       9.993  17.010  20.330  1.00 17.72           C  
ATOM    561  OG  SER    67      11.283  16.560  19.945  1.00 15.42           O  
ATOM    562  N   GLU    68       6.701  17.419  19.657  1.00 18.39           N  
ATOM    563  CA  GLU    68       5.479  17.800  20.382  1.00 21.34           C  
ATOM    564  C   GLU    68       4.554  16.625  20.696  1.00 19.83           C  
ATOM    565  O   GLU    68       3.872  16.627  21.723  1.00 20.86           O  
ATOM    566  CB  GLU    68       4.694  18.895  19.640  1.00 22.70           C  
ATOM    567  CG  GLU    68       3.875  18.358  18.493  1.00 32.14           C  
ATOM    568  CD  GLU    68       2.931  19.410  17.932  1.00 43.17           C  
ATOM    569  OE1 GLU    68       3.214  20.608  18.153  1.00 47.81           O  
ATOM    570  OE2 GLU    68       1.921  19.057  17.280  1.00 40.45           O  
ATOM    571  N   SER    69       4.522  15.626  19.828  1.00 21.52           N  
ATOM    572  CA  SER    69       3.562  14.517  19.999  1.00 22.41           C  
ATOM    573  C   SER    69       4.228  13.240  20.474  1.00 18.02           C  
ATOM    574  O   SER    69       3.582  12.230  20.756  1.00 19.35           O  
ATOM    575  CB  SER    69       2.747  14.272  18.728  1.00 21.77           C  
ATOM    576  OG  SER    69       1.870  15.365  18.493  1.00 26.75           O  
ATOM    577  N   PHE    70       5.530  13.320  20.655  1.00 15.96           N  
ATOM    578  CA  PHE    70       6.234  12.206  21.305  1.00 12.18           C  
ATOM    579  C   PHE    70       6.534  12.520  22.756  1.00 12.60           C  
ATOM    580  O   PHE    70       7.621  13.011  23.110  1.00 13.57           O  
ATOM    581  CB  PHE    70       7.496  11.857  20.546  1.00 15.72           C  
ATOM    582  CG  PHE    70       7.208  11.229  19.216  1.00 14.77           C  
ATOM    583  CD1 PHE    70       6.941  12.014  18.109  1.00 15.44           C  
ATOM    584  CD2 PHE    70       7.086   9.847  19.100  1.00 15.12           C  
ATOM    585  CE1 PHE    70       6.643  11.416  16.875  1.00 13.76           C  
ATOM    586  CE2 PHE    70       6.784   9.265  17.877  1.00 14.82           C  
ATOM    587  CZ  PHE    70       6.554  10.054  16.772  1.00 15.46           C  
ATOM    588  N   HIS    71       5.535  12.254  23.590  1.00 14.26           N  
ATOM    589  CA  HIS    71       5.574  12.747  24.963  1.00 14.38           C  
ATOM    590  C   HIS    71       6.729  12.163  25.767  1.00 14.99           C  
ATOM    591  O   HIS    71       7.187  12.763  26.733  1.00 18.19           O  
ATOM    592  CB  HIS    71       4.248  12.521  25.660  1.00 14.92           C  
ATOM    593  CG  HIS    71       3.140  13.343  25.078  1.00 18.15           C  
ATOM    594  ND1 HIS    71       1.825  12.928  25.065  1.00 20.36           N  
ATOM    595  CD2 HIS    71       3.164  14.548  24.461  1.00 20.36           C  
ATOM    596  CE1 HIS    71       1.085  13.854  24.480  1.00 24.74           C  
ATOM    597  NE2 HIS    71       1.873  14.843  24.097  1.00 28.17           N  
ATOM    598  N   THR    72       7.220  11.013  25.352  1.00 15.29           N  
ATOM    599  CA  THR    72       8.391  10.431  26.004  1.00 16.57           C  
ATOM    600  C   THR    72       9.554  10.213  25.034  1.00 16.18           C  
ATOM    601  O   THR    72      10.489   9.466  25.321  1.00 16.37           O  
ATOM    602  CB  THR    72       8.063   9.152  26.716  1.00 15.49           C  
ATOM    603  OG1 THR    72       7.394   8.236  25.828  1.00 17.06           O  
ATOM    604  CG2 THR    72       7.175   9.474  27.936  1.00 15.87           C  
ATOM    605  N   GLY    73       9.462  10.927  23.914  1.00 14.03           N  
ATOM    606  CA  GLY    73      10.490  10.942  22.877  1.00 13.06           C  
ATOM    607  C   GLY    73      10.493   9.794  21.883  1.00 11.83           C  
ATOM    608  O   GLY    73       9.653   8.913  21.876  1.00 12.97           O  
ATOM    609  N   ILE    74      11.495   9.892  21.023  1.00  7.22           N  
ATOM    610  CA  ILE    74      11.860   8.889  20.010  1.00  9.96           C  
ATOM    611  C   ILE    74      13.253   8.376  20.323  1.00 10.78           C  
ATOM    612  O   ILE    74      14.161   9.145  20.643  1.00 10.58           O  
ATOM    613  CB  ILE    74      11.876   9.459  18.596  1.00  9.25           C  
ATOM    614  CG1 ILE    74      10.456   9.788  18.145  1.00 12.34           C  
ATOM    615  CG2 ILE    74      12.514   8.472  17.572  1.00  9.74           C  
ATOM    616  CD1 ILE    74      10.416  10.712  16.964  1.00 11.34           C  
ATOM    617  N   GLN    75      13.364   7.062  20.287  1.00 10.53           N  
ATOM    618  CA  GLN    75      14.630   6.345  20.480  1.00 12.80           C  
ATOM    619  C   GLN    75      15.205   5.907  19.129  1.00  8.26           C  
ATOM    620  O   GLN    75      14.463   5.504  18.196  1.00 10.42           O  
ATOM    621  CB  GLN    75      14.455   5.096  21.339  1.00 16.49           C  
ATOM    622  CG  GLN    75      14.298   5.391  22.835  1.00 11.69           C  
ATOM    623  CD  GLN    75      15.522   6.044  23.438  1.00 11.61           C  
ATOM    624  OE1 GLN    75      16.643   5.573  23.266  1.00 12.47           O  
ATOM    625  NE2 GLN    75      15.310   7.176  24.135  1.00 13.64           N  
ATOM    626  N   ILE    76      16.520   5.967  19.052  1.00  9.70           N  
ATOM    627  CA  ILE    76      17.264   5.395  17.927  1.00 12.88           C  
ATOM    628  C   ILE    76      17.679   3.996  18.332  1.00 13.69           C  
ATOM    629  O   ILE    76      18.539   3.798  19.202  1.00 11.95           O  
ATOM    630  CB  ILE    76      18.460   6.281  17.466  1.00 12.64           C  
ATOM    631  CG1 ILE    76      17.922   7.571  16.872  1.00 14.61           C  
ATOM    632  CG2 ILE    76      19.317   5.562  16.421  1.00 12.15           C  
ATOM    633  CD1 ILE    76      18.990   8.455  16.240  1.00 16.12           C  
ATOM    634  N   SER    77      16.985   3.052  17.702  1.00 10.50           N  
ATOM    635  CA  SER    77      17.060   1.627  18.016  1.00 13.19           C  
ATOM    636  C   SER    77      18.385   1.063  17.513  1.00 14.71           C  
ATOM    637  O   SER    77      19.041   0.246  18.152  1.00 12.18           O  
ATOM    638  CB  SER    77      15.864   0.869  17.403  1.00 14.50           C  
ATOM    639  OG  SER    77      14.620   1.364  17.911  1.00 18.26           O  
ATOM    640  N   SER    78      18.760   1.531  16.343  1.00 10.94           N  
ATOM    641  CA  SER    78      20.053   1.171  15.741  1.00 11.67           C  
ATOM    642  C   SER    78      20.492   2.221  14.750  1.00 11.58           C  
ATOM    643  O   SER    78      19.674   2.791  14.014  1.00 11.66           O  
ATOM    644  CB  SER    78      19.995  -0.181  15.028  1.00 12.13           C  
ATOM    645  OG  SER    78      19.111  -0.150  13.919  1.00 17.26           O  
ATOM    646  N   LEU    79      21.790   2.436  14.737  1.00 12.16           N  
ATOM    647  CA  LEU    79      22.475   3.222  13.682  1.00 11.20           C  
ATOM    648  C   LEU    79      23.279   2.252  12.815  1.00 11.08           C  
ATOM    649  O   LEU    79      24.299   1.691  13.281  1.00 11.68           O  
ATOM    650  CB  LEU    79      23.386   4.287  14.291  1.00  9.27           C  
ATOM    651  CG  LEU    79      24.169   5.126  13.265  1.00 13.82           C  
ATOM    652  CD1 LEU    79      23.217   5.912  12.296  1.00  8.95           C  
ATOM    653  CD2 LEU    79      25.142   6.065  13.995  1.00 14.75           C  
ATOM    654  N   ASP    80      22.814   2.041  11.583  1.00  8.71           N  
ATOM    655  CA  ASP    80      23.202   0.859  10.803  1.00 10.86           C  
ATOM    656  C   ASP    80      24.305   1.151   9.795  1.00 12.75           C  
ATOM    657  O   ASP    80      25.184   0.330   9.577  1.00 12.83           O  
ATOM    658  CB  ASP    80      21.986   0.205  10.135  1.00 10.82           C  
ATOM    659  CG  ASP    80      20.971  -0.268  11.158  1.00 17.63           C  
ATOM    660  OD1 ASP    80      21.396  -0.906  12.118  1.00 16.50           O  
ATOM    661  OD2 ASP    80      19.785   0.037  11.033  1.00 22.63           O  
ATOM    662  N   ARG    81      24.234   2.330   9.192  1.00 11.32           N  
ATOM    663  CA  ARG    81      25.176   2.718   8.145  1.00 10.67           C  
ATOM    664  C   ARG    81      25.429   4.205   8.197  1.00  9.27           C  
ATOM    665  O   ARG    81      24.496   4.988   8.287  1.00 10.05           O  
ATOM    666  CB  ARG    81      24.641   2.303   6.761  1.00  9.07           C  
ATOM    667  CG  ARG    81      24.428   0.795   6.611  1.00 15.03           C  
ATOM    668  CD  ARG    81      23.881   0.356   5.264  1.00 15.60           C  
ATOM    669  NE  ARG    81      24.100  -1.072   5.063  1.00 16.48           N  
ATOM    670  CZ  ARG    81      23.372  -2.034   5.634  1.00 24.61           C  
ATOM    671  NH1 ARG    81      22.355  -1.734   6.444  1.00 18.98           N  
ATOM    672  NH2 ARG    81      23.666  -3.306   5.409  1.00 17.05           N  
ATOM    673  N   VAL    82      26.710   4.549   8.170  1.00  8.24           N  
ATOM    674  CA  VAL    82      27.136   5.943   8.113  1.00  7.04           C  
ATOM    675  C   VAL    82      28.121   6.089   6.969  1.00  8.28           C  
ATOM    676  O   VAL    82      29.223   5.523   6.981  1.00 11.12           O  
ATOM    677  CB  VAL    82      27.812   6.338   9.426  1.00 12.04           C  
ATOM    678  CG1 VAL    82      28.321   7.762   9.358  1.00  7.77           C  
ATOM    679  CG2 VAL    82      26.808   6.188  10.586  1.00  9.42           C  
ATOM    680  N   THR    83      27.722   6.880   5.988  1.00  8.91           N  
ATOM    681  CA  THR    83      28.552   7.085   4.799  1.00  5.50           C  
ATOM    682  C   THR    83      28.884   8.546   4.650  1.00  5.15           C  
ATOM    683  O   THR    83      28.174   9.397   5.150  1.00  6.09           O  
ATOM    684  CB  THR    83      27.809   6.596   3.522  1.00  8.55           C  
ATOM    685  OG1 THR    83      26.547   7.249   3.440  1.00  7.25           O  
ATOM    686  CG2 THR    83      27.610   5.039   3.499  1.00  7.88           C  
ATOM    687  N   SER    84      30.010   8.837   3.990  1.00  6.76           N  
ATOM    688  CA  SER    84      30.403  10.236   3.815  1.00  9.15           C  
ATOM    689  C   SER    84      31.200  10.477   2.546  1.00  8.96           C  
ATOM    690  O   SER    84      31.627   9.562   1.836  1.00  8.64           O  
ATOM    691  CB  SER    84      31.183  10.758   5.041  1.00 11.98           C  
ATOM    692  OG  SER    84      32.463  10.174   5.210  1.00 10.59           O  
ATOM    693  N   ASN    85      31.370  11.755   2.326  1.00  9.84           N  
ATOM    694  CA  ASN    85      32.307  12.283   1.300  1.00 10.83           C  
ATOM    695  C   ASN    85      33.008  13.511   1.889  1.00 12.20           C  
ATOM    696  O   ASN    85      33.107  13.633   3.110  1.00 12.31           O  
ATOM    697  CB  ASN    85      31.622  12.529  -0.051  1.00 11.96           C  
ATOM    698  CG  ASN    85      30.528  13.596  -0.016  1.00  8.61           C  
ATOM    699  OD1 ASN    85      30.552  14.498   0.793  1.00  9.55           O  
ATOM    700  ND2 ASN    85      29.568  13.509  -0.976  1.00 10.81           N  
ATOM    701  N   GLU    86      33.510  14.404   1.036  1.00 12.32           N  
ATOM    702  CA  GLU    86      34.268  15.558   1.551  1.00 13.82           C  
ATOM    703  C   GLU    86      33.416  16.484   2.433  1.00 13.82           C  
ATOM    704  O   GLU    86      33.942  17.128   3.325  1.00 13.86           O  
ATOM    705  CB  GLU    86      34.891  16.376   0.426  1.00 15.97           C  
ATOM    706  CG  GLU    86      35.971  15.665  -0.324  1.00 21.53           C  
ATOM    707  CD  GLU    86      36.705  16.593  -1.272  1.00 34.60           C  
ATOM    708  OE1 GLU    86      36.185  17.701  -1.522  1.00 41.90           O  
ATOM    709  OE2 GLU    86      37.796  16.222  -1.761  1.00 46.87           O  
ATOM    710  N   THR    87      32.108  16.515   2.180  1.00 10.51           N  
ATOM    711  CA  THR    87      31.207  17.475   2.819  1.00 10.69           C  
ATOM    712  C   THR    87      29.899  16.961   3.429  1.00 11.12           C  
ATOM    713  O   THR    87      29.331  17.615   4.254  1.00 16.25           O  
ATOM    714  CB  THR    87      30.857  18.665   1.865  1.00 12.70           C  
ATOM    715  OG1 THR    87      30.054  18.198   0.787  1.00 24.15           O  
ATOM    716  CG2 THR    87      32.128  19.272   1.321  1.00 17.81           C  
ATOM    717  N   THR    88      29.500  15.742   3.079  1.00 11.58           N  
ATOM    718  CA  THR    88      28.178  15.217   3.396  1.00 10.87           C  
ATOM    719  C   THR    88      28.338  13.916   4.161  1.00  8.74           C  
ATOM    720  O   THR    88      29.214  13.099   3.852  1.00 10.36           O  
ATOM    721  CB  THR    88      27.366  14.933   2.102  1.00 11.43           C  
ATOM    722  OG1 THR    88      27.230  16.123   1.316  1.00 13.54           O  
ATOM    723  CG2 THR    88      25.975  14.413   2.398  1.00 10.57           C  
ATOM    724  N   VAL    89      27.463  13.743   5.145  1.00  8.52           N  
ATOM    725  CA  VAL    89      27.375  12.473   5.891  1.00  9.16           C  
ATOM    726  C   VAL    89      25.931  12.038   5.943  1.00  8.69           C  
ATOM    727  O   VAL    89      25.012  12.857   6.178  1.00  8.40           O  
ATOM    728  CB  VAL    89      27.902  12.593   7.330  1.00  9.61           C  
ATOM    729  CG1 VAL    89      27.969  11.226   7.930  1.00 12.40           C  
ATOM    730  CG2 VAL    89      29.310  13.270   7.340  1.00  8.87           C  
ATOM    731  N   VAL    90      25.721  10.752   5.697  1.00  8.13           N  
ATOM    732  CA  VAL    90      24.364  10.180   5.776  1.00  8.49           C  
ATOM    733  C   VAL    90      24.374   9.102   6.832  1.00  9.58           C  
ATOM    734  O   VAL    90      25.291   8.274   6.904  1.00  8.50           O  
ATOM    735  CB  VAL    90      23.892   9.516   4.441  1.00  9.15           C  
ATOM    736  CG1 VAL    90      22.465   8.915   4.554  1.00  8.68           C  
ATOM    737  CG2 VAL    90      23.943  10.486   3.257  1.00  5.92           C  
ATOM    738  N   PHE    91      23.346   9.187   7.656  1.00  9.72           N  
ATOM    739  CA  PHE    91      23.058   8.266   8.745  1.00  7.84           C  
ATOM    740  C   PHE    91      21.794   7.499   8.383  1.00  8.32           C  
ATOM    741  O   PHE    91      20.738   8.081   8.254  1.00 11.10           O  
ATOM    742  CB  PHE    91      22.830   9.072  10.032  1.00  9.55           C  
ATOM    743  CG  PHE    91      24.035   9.829  10.488  1.00  9.33           C  
ATOM    744  CD1 PHE    91      24.287  11.139   9.995  1.00  7.40           C  
ATOM    745  CD2 PHE    91      24.920   9.278  11.406  1.00 11.40           C  
ATOM    746  CE1 PHE    91      25.394  11.829  10.402  1.00 13.37           C  
ATOM    747  CE2 PHE    91      26.030   9.990  11.815  1.00 11.41           C  
ATOM    748  CZ  PHE    91      26.268  11.251  11.310  1.00 11.57           C  
ATOM    749  N   GLU    92      21.932   6.183   8.254  1.00  7.20           N  
ATOM    750  CA  GLU    92      20.813   5.300   8.020  1.00  9.03           C  
ATOM    751  C   GLU    92      20.548   4.605   9.347  1.00 10.48           C  
ATOM    752  O   GLU    92      21.407   3.855   9.874  1.00  6.97           O  
ATOM    753  CB  GLU    92      21.109   4.257   6.946  1.00  8.77           C  
ATOM    754  CG  GLU    92      21.291   4.793   5.543  1.00  8.38           C  
ATOM    755  CD  GLU    92      21.641   3.691   4.566  1.00 10.18           C  
ATOM    756  OE1 GLU    92      20.827   2.722   4.475  1.00  8.00           O  
ATOM    757  OE2 GLU    92      22.709   3.802   3.912  1.00 10.73           O  
ATOM    758  N   PHE    93      19.349   4.848   9.853  1.00  7.82           N  
ATOM    759  CA  PHE    93      18.970   4.384  11.197  1.00  8.84           C  
ATOM    760  C   PHE    93      17.530   3.849  11.315  1.00 10.78           C  
ATOM    761  O   PHE    93      16.697   3.987  10.408  1.00  7.25           O  
ATOM    762  CB  PHE    93      19.291   5.440  12.273  1.00 11.25           C  
ATOM    763  CG  PHE    93      18.455   6.692  12.185  1.00 11.00           C  
ATOM    764  CD1 PHE    93      18.860   7.788  11.431  1.00  9.94           C  
ATOM    765  CD2 PHE    93      17.254   6.780  12.874  1.00 12.31           C  
ATOM    766  CE1 PHE    93      18.080   8.923  11.370  1.00  9.40           C  
ATOM    767  CE2 PHE    93      16.479   7.906  12.804  1.00 10.52           C  
ATOM    768  CZ  PHE    93      16.886   8.987  12.051  1.00 11.69           C  
ATOM    769  N   ARG    94      17.276   3.211  12.456  1.00  9.99           N  
ATOM    770  CA  ARG    94      15.939   2.674  12.805  1.00  7.97           C  
ATOM    771  C   ARG    94      15.524   3.347  14.088  1.00  8.47           C  
ATOM    772  O   ARG    94      16.362   3.526  14.992  1.00  9.57           O  
ATOM    773  CB  ARG    94      15.973   1.129  12.974  1.00  8.94           C  
ATOM    774  CG  ARG    94      16.263   0.340  11.687  1.00 10.05           C  
ATOM    775  CD  ARG    94      16.686  -1.107  11.906  1.00 13.83           C  
ATOM    776  NE  ARG    94      15.651  -1.797  12.697  1.00 17.56           N  
ATOM    777  CZ  ARG    94      15.747  -2.051  14.007  1.00 21.76           C  
ATOM    778  NH1 ARG    94      16.833  -1.695  14.686  1.00 20.76           N  
ATOM    779  NH2 ARG    94      14.748  -2.667  14.648  1.00 19.40           N  
ATOM    780  N   ASP    95      14.264   3.795  14.144  1.00  6.95           N  
ATOM    781  CA  ASP    95      13.793   4.503  15.313  1.00  9.55           C  
ATOM    782  C   ASP    95      12.410   4.049  15.746  1.00  8.64           C  
ATOM    783  O   ASP    95      11.685   3.310  15.039  1.00 10.93           O  
ATOM    784  CB  ASP    95      13.923   6.029  15.163  1.00  9.23           C  
ATOM    785  CG  ASP    95      12.995   6.645  14.117  1.00 10.58           C  
ATOM    786  OD1 ASP    95      12.221   5.917  13.457  1.00 10.44           O  
ATOM    787  OD2 ASP    95      13.078   7.900  13.974  1.00 11.61           O  
ATOM    788  N   GLU    96      12.099   4.458  16.954  1.00 10.41           N  
ATOM    789  CA  GLU    96      10.777   4.195  17.524  1.00 10.22           C  
ATOM    790  C   GLU    96      10.435   5.057  18.706  1.00 11.86           C  
ATOM    791  O   GLU    96      11.298   5.476  19.477  1.00 12.31           O  
ATOM    792  CB  GLU    96      10.647   2.747  17.925  1.00 13.69           C  
ATOM    793  CG  GLU    96      11.550   2.340  19.023  1.00 21.95           C  
ATOM    794  CD  GLU    96      11.335   0.881  19.402  1.00 30.96           C  
ATOM    795  OE1 GLU    96      10.504   0.211  18.737  1.00 34.32           O  
ATOM    796  OE2 GLU    96      11.983   0.417  20.360  1.00 46.14           O  
ATOM    797  N   GLY    97       9.139   5.296  18.807  1.00 13.06           N  
ATOM    798  CA  GLY    97       8.545   6.046  19.941  1.00 13.15           C  
ATOM    799  C   GLY    97       7.040   6.093  19.891  1.00 14.46           C  
ATOM    800  O   GLY    97       6.434   5.747  18.891  1.00 11.40           O  
ATOM    801  N   LEU    98       6.453   6.491  21.015  1.00 13.92           N  
ATOM    802  CA  LEU    98       5.004   6.650  21.107  1.00 11.31           C  
ATOM    803  C   LEU    98       4.561   8.000  20.613  1.00  9.79           C  
ATOM    804  O   LEU    98       4.896   9.052  21.163  1.00 10.09           O  
ATOM    805  CB  LEU    98       4.479   6.401  22.532  1.00 11.69           C  
ATOM    806  CG  LEU    98       4.713   4.999  23.097  1.00 12.92           C  
ATOM    807  CD1 LEU    98       4.058   4.888  24.463  1.00 11.22           C  
ATOM    808  CD2 LEU    98       4.191   3.907  22.194  1.00  8.06           C  
ATOM    809  N   PHE    99       3.719   7.912  19.587  1.00 10.02           N  
ATOM    810  CA  PHE    99       3.077   9.062  18.982  1.00 13.17           C  
ATOM    811  C   PHE    99       1.688   9.120  19.590  1.00 13.23           C  
ATOM    812  O   PHE    99       0.823   8.365  19.215  1.00 13.92           O  
ATOM    813  CB  PHE    99       3.026   8.888  17.448  1.00 14.87           C  
ATOM    814  CG  PHE    99       2.220   9.928  16.747  1.00 18.17           C  
ATOM    815  CD1 PHE    99       2.510  11.259  16.901  1.00 19.93           C  
ATOM    816  CD2 PHE    99       1.189   9.564  15.881  1.00 28.87           C  
ATOM    817  CE1 PHE    99       1.780  12.221  16.242  1.00 19.08           C  
ATOM    818  CE2 PHE    99       0.454  10.524  15.206  1.00 25.06           C  
ATOM    819  CZ  PHE    99       0.742  11.857  15.392  1.00 24.50           C  
ATOM    820  N   LEU   100       1.516   9.991  20.574  1.00 14.16           N  
ATOM    821  CA  LEU   100       0.259  10.070  21.332  1.00 12.87           C  
ATOM    822  C   LEU   100      -0.184   8.653  21.713  1.00 13.12           C  
ATOM    823  O   LEU   100      -1.331   8.203  21.498  1.00 14.45           O  
ATOM    824  CB  LEU   100      -0.852  10.798  20.551  1.00 15.58           C  
ATOM    825  CG  LEU   100      -0.543  12.156  19.963  1.00 15.69           C  
ATOM    826  CD1 LEU   100      -1.743  12.647  19.126  1.00 23.51           C  
ATOM    827  CD2 LEU   100      -0.140  13.152  21.050  1.00 23.16           C  
ATOM    828  N   GLY   101       0.770   7.944  22.268  1.00 12.80           N  
ATOM    829  CA  GLY   101       0.536   6.669  22.892  1.00 12.44           C  
ATOM    830  C   GLY   101       0.547   5.527  21.929  1.00 13.01           C  
ATOM    831  O   GLY   101       0.459   4.359  22.324  1.00 14.26           O  
ATOM    832  N   LYS   102       0.694   5.875  20.660  1.00 15.48           N  
ATOM    833  CA  LYS   102       0.631   4.898  19.557  1.00 15.69           C  
ATOM    834  C   LYS   102       2.017   4.591  19.027  1.00 15.65           C  
ATOM    835  O   LYS   102       2.818   5.488  18.845  1.00 15.86           O  
ATOM    836  CB  LYS   102      -0.278   5.387  18.414  1.00 16.71           C  
ATOM    837  CG  LYS   102      -1.721   4.996  18.569  1.00 30.62           C  
ATOM    838  CD  LYS   102      -2.539   6.009  19.355  1.00 33.97           C  
ATOM    839  CE  LYS   102      -4.041   5.656  19.331  1.00 30.90           C  
ATOM    840  NZ  LYS   102      -4.807   6.456  20.346  1.00 34.95           N  
ATOM    841  N   PRO   103       2.308   3.310  18.792  1.00 15.53           N  
ATOM    842  CA  PRO   103       3.639   2.877  18.377  1.00 15.65           C  
ATOM    843  C   PRO   103       4.012   3.298  16.960  1.00 18.50           C  
ATOM    844  O   PRO   103       3.426   2.857  15.970  1.00 23.72           O  
ATOM    845  CB  PRO   103       3.584   1.347  18.506  1.00 16.03           C  
ATOM    846  CG  PRO   103       2.142   0.997  18.474  1.00 23.07           C  
ATOM    847  CD  PRO   103       1.340   2.205  18.836  1.00 18.60           C  
ATOM    848  N   TYR   104       4.985   4.192  16.915  1.00 13.29           N  
ATOM    849  CA  TYR   104       5.646   4.622  15.685  1.00 12.00           C  
ATOM    850  C   TYR   104       7.003   3.930  15.613  1.00 13.23           C  
ATOM    851  O   TYR   104       7.781   3.889  16.569  1.00 13.25           O  
ATOM    852  CB  TYR   104       5.798   6.154  15.647  1.00 11.67           C  
ATOM    853  CG  TYR   104       6.731   6.709  14.574  1.00 10.39           C  
ATOM    854  CD1 TYR   104       6.286   6.901  13.266  1.00 12.13           C  
ATOM    855  CD2 TYR   104       8.044   7.027  14.843  1.00  9.99           C  
ATOM    856  CE1 TYR   104       7.118   7.399  12.268  1.00 13.81           C  
ATOM    857  CE2 TYR   104       8.895   7.559  13.837  1.00 12.40           C  
ATOM    858  CZ  TYR   104       8.424   7.724  12.533  1.00 12.38           C  
ATOM    859  OH  TYR   104       9.256   8.247  11.529  1.00 10.55           O  
ATOM    860  N   LYS   105       7.247   3.326  14.469  1.00  9.51           N  
ATOM    861  CA  LYS   105       8.543   2.735  14.151  1.00 10.15           C  
ATOM    862  C   LYS   105       8.891   3.063  12.722  1.00  9.40           C  
ATOM    863  O   LYS   105       8.020   3.052  11.863  1.00 13.05           O  
ATOM    864  CB  LYS   105       8.496   1.226  14.296  1.00 11.28           C  
ATOM    865  CG  LYS   105       8.230   0.733  15.692  1.00 18.75           C  
ATOM    866  CD  LYS   105       8.092  -0.774  15.691  1.00 22.64           C  
ATOM    867  CE  LYS   105       9.457  -1.453  15.688  1.00 28.58           C  
ATOM    868  NZ  LYS   105       9.397  -2.886  16.139  1.00 30.77           N  
ATOM    869  N   ASN   106      10.150   3.383  12.466  1.00 10.00           N  
ATOM    870  CA  ASN   106      10.564   3.695  11.095  1.00  6.88           C  
ATOM    871  C   ASN   106      12.020   3.395  10.773  1.00  6.19           C  
ATOM    872  O   ASN   106      12.855   3.085  11.639  1.00  8.21           O  
ATOM    873  CB  ASN   106      10.237   5.159  10.782  1.00  8.65           C  
ATOM    874  CG  ASN   106       9.663   5.363   9.397  1.00  9.62           C  
ATOM    875  OD1 ASN   106       9.655   4.456   8.546  1.00 10.19           O  
ATOM    876  ND2 ASN   106       9.180   6.601   9.143  1.00 10.03           N  
ATOM    877  N   ARG   107      12.283   3.452   9.488  1.00  5.01           N  
ATOM    878  CA  ARG   107      13.611   3.489   8.942  1.00  6.26           C  
ATOM    879  C   ARG   107      13.755   4.879   8.345  1.00 10.17           C  
ATOM    880  O   ARG   107      12.817   5.418   7.749  1.00  9.96           O  
ATOM    881  CB  ARG   107      13.860   2.404   7.880  1.00  6.69           C  
ATOM    882  CG  ARG   107      13.984   0.988   8.434  1.00 11.17           C  
ATOM    883  CD  ARG   107      14.417  -0.015   7.425  1.00 15.14           C  
ATOM    884  NE  ARG   107      14.903  -1.218   8.111  1.00 20.35           N  
ATOM    885  CZ  ARG   107      15.947  -1.933   7.714  1.00 19.45           C  
ATOM    886  NH1 ARG   107      16.645  -1.579   6.640  1.00 17.40           N  
ATOM    887  NH2 ARG   107      16.290  -3.012   8.391  1.00 22.11           N  
ATOM    888  N   VAL   108      14.909   5.475   8.614  1.00  8.97           N  
ATOM    889  CA  VAL   108      15.176   6.853   8.221  1.00  7.78           C  
ATOM    890  C   VAL   108      16.590   6.995   7.726  1.00  7.75           C  
ATOM    891  O   VAL   108      17.507   6.355   8.199  1.00  7.51           O  
ATOM    892  CB  VAL   108      14.956   7.832   9.398  1.00  8.07           C  
ATOM    893  CG1 VAL   108      14.980   9.303   8.904  1.00  8.32           C  
ATOM    894  CG2 VAL   108      13.647   7.517  10.145  1.00  9.02           C  
ATOM    895  N   ALA   109      16.750   7.884   6.758  1.00  8.93           N  
ATOM    896  CA  ALA   109      18.058   8.366   6.405  1.00  6.93           C  
ATOM    897  C   ALA   109      18.051   9.877   6.556  1.00  7.50           C  
ATOM    898  O   ALA   109      17.211  10.561   6.023  1.00  8.94           O  
ATOM    899  CB  ALA   109      18.436   7.978   4.986  1.00  9.00           C  
ATOM    900  N   VAL   110      18.976  10.376   7.352  0.50  6.88           N  
ATOM    902  CA  VAL   110      19.215  11.813   7.400  0.50  8.45           C  
ATOM    904  C   VAL   110      20.626  12.108   6.928  0.50  9.09           C  
ATOM    906  O   VAL   110      21.604  11.466   7.321  0.50 10.53           O  
ATOM    908  CB  VAL   110      18.958  12.456   8.783  0.50  8.88           C  
ATOM    910  CG1 VAL   110      17.514  12.154   9.265  0.50  6.47           C  
ATOM    912  CG2 VAL   110      20.021  12.043   9.810  0.50  8.01           C  
ATOM    914  N   SER   111      20.680  13.121   6.082  1.00  9.11           N  
ATOM    915  CA  SER   111      21.876  13.556   5.404  1.00  7.22           C  
ATOM    916  C   SER   111      22.215  14.971   5.881  1.00  7.99           C  
ATOM    917  O   SER   111      21.347  15.830   5.908  1.00  9.34           O  
ATOM    918  CB  SER   111      21.616  13.540   3.888  1.00  8.15           C  
ATOM    919  OG  SER   111      22.763  13.901   3.157  1.00  8.89           O  
ATOM    920  N   PHE   112      23.446  15.151   6.343  1.00  6.85           N  
ATOM    921  CA  PHE   112      23.939  16.494   6.729  1.00  6.63           C  
ATOM    922  C   PHE   112      25.033  16.952   5.754  1.00  6.07           C  
ATOM    923  O   PHE   112      25.892  16.147   5.344  1.00 11.14           O  
ATOM    924  CB  PHE   112      24.637  16.479   8.129  1.00  9.40           C  
ATOM    925  CG  PHE   112      23.788  16.001   9.287  1.00 11.65           C  
ATOM    926  CD1 PHE   112      22.429  16.079   9.275  1.00 10.55           C  
ATOM    927  CD2 PHE   112      24.404  15.565  10.467  1.00 14.26           C  
ATOM    928  CE1 PHE   112      21.662  15.661  10.359  1.00 16.21           C  
ATOM    929  CE2 PHE   112      23.653  15.162  11.537  1.00 15.69           C  
ATOM    930  CZ  PHE   112      22.268  15.225  11.495  1.00 13.77           C  
ATOM    931  N   ASP   113      25.078  18.255   5.468  1.00  9.49           N  
ATOM    932  CA  ASP   113      26.302  18.875   4.939  1.00 11.17           C  
ATOM    933  C   ASP   113      27.005  19.580   6.077  1.00 12.18           C  
ATOM    934  O   ASP   113      26.365  20.233   6.912  1.00 13.26           O  
ATOM    935  CB  ASP   113      25.999  19.904   3.854  1.00 10.65           C  
ATOM    936  CG  ASP   113      25.696  19.281   2.528  1.00 13.48           C  
ATOM    937  OD1 ASP   113      25.500  18.059   2.446  1.00 13.73           O  
ATOM    938  OD2 ASP   113      25.695  20.023   1.528  1.00 18.82           O  
ATOM    939  N   VAL   114      28.321  19.479   6.060  1.00 12.86           N  
ATOM    940  CA  VAL   114      29.186  20.145   7.046  1.00 13.56           C  
ATOM    941  C   VAL   114      29.965  21.289   6.436  1.00 14.12           C  
ATOM    942  O   VAL   114      30.520  21.199   5.328  1.00 11.70           O  
ATOM    943  CB  VAL   114      30.171  19.147   7.678  1.00 14.18           C  
ATOM    944  CG1 VAL   114      31.189  19.850   8.595  1.00 11.69           C  
ATOM    945  CG2 VAL   114      29.420  18.079   8.467  1.00 13.94           C  
ATOM    946  N   ARG   115      29.985  22.367   7.202  1.00 13.92           N  
ATOM    947  CA  ARG   115      30.793  23.553   6.906  1.00 18.20           C  
ATOM    948  C   ARG   115      31.541  24.006   8.157  1.00 15.23           C  
ATOM    949  O   ARG   115      30.959  24.591   9.085  1.00 15.64           O  
ATOM    950  CB  ARG   115      29.936  24.680   6.341  1.00 18.33           C  
ATOM    951  CG  ARG   115      30.771  25.854   5.800  1.00 20.19           C  
ATOM    952  CD  ARG   115      29.955  27.150   5.663  1.00 22.06           C  
ATOM    953  NE  ARG   115      28.886  26.966   4.699  1.00 16.66           N  
ATOM    954  CZ  ARG   115      27.660  27.462   4.820  1.00 15.11           C  
ATOM    955  NH1 ARG   115      27.330  28.205   5.857  1.00 20.56           N  
ATOM    956  NH2 ARG   115      26.765  27.195   3.888  1.00 17.83           N  
ATOM    957  N   GLY   116      32.832  23.724   8.164  1.00 16.21           N  
ATOM    958  CA  GLY   116      33.671  24.045   9.327  1.00 17.49           C  
ATOM    959  C   GLY   116      33.259  23.216  10.517  1.00 16.60           C  
ATOM    960  O   GLY   116      33.200  21.992  10.447  1.00 17.51           O  
ATOM    961  N   ASP   117      32.928  23.906  11.590  1.00 18.59           N  
ATOM    962  CA  ASP   117      32.589  23.265  12.857  1.00 19.33           C  
ATOM    963  C   ASP   117      31.085  23.183  12.994  1.00 16.42           C  
ATOM    964  O   ASP   117      30.551  22.865  14.050  1.00 17.48           O  
ATOM    965  CB  ASP   117      33.243  23.968  14.055  1.00 20.86           C  
ATOM    966  CG  ASP   117      32.787  25.398  14.236  1.00 26.98           C  
ATOM    967  OD1 ASP   117      32.427  26.061  13.229  1.00 37.99           O  
ATOM    968  OD2 ASP   117      32.807  25.866  15.390  1.00 38.89           O  
ATOM    969  N   LYS   118      30.415  23.436  11.872  1.00 16.42           N  
ATOM    970  CA  LYS   118      28.942  23.423  11.819  1.00 15.44           C  
ATOM    971  C   LYS   118      28.320  22.605  10.674  1.00 14.10           C  
ATOM    972  O   LYS   118      28.993  22.148   9.752  1.00 13.04           O  
ATOM    973  CB  LYS   118      28.405  24.859  11.773  1.00 15.70           C  
ATOM    974  CG  LYS   118      28.631  25.604  13.081  1.00 19.40           C  
ATOM    975  CD  LYS   118      28.308  27.064  13.017  1.00 27.14           C  
ATOM    976  CE  LYS   118      28.696  27.748  14.325  1.00 34.65           C  
ATOM    977  NZ  LYS   118      28.393  29.207  14.304  1.00 42.82           N  
ATOM    978  N   ILE   119      26.999  22.512  10.778  1.00 13.84           N  
ATOM    979  CA  ILE   119      26.113  21.842   9.786  1.00 14.16           C  
ATOM    980  C   ILE   119      25.276  22.885   9.068  1.00 12.15           C  
ATOM    981  O   ILE   119      24.599  23.715   9.716  1.00 12.14           O  
ATOM    982  CB  ILE   119      25.192  20.800  10.487  1.00 12.10           C  
ATOM    983  CG1 ILE   119      26.055  19.670  11.083  1.00 16.09           C  
ATOM    984  CG2 ILE   119      24.076  20.277   9.541  1.00 14.64           C  
ATOM    985  CD1 ILE   119      25.337  18.822  12.149  1.00 15.88           C  
ATOM    986  N   CYS   120      25.313  22.833   7.728  1.00 11.97           N  
ATOM    987  CA  CYS   120      24.681  23.875   6.895  1.00 12.00           C  
ATOM    988  C   CYS   120      23.423  23.395   6.176  1.00 11.46           C  
ATOM    989  O   CYS   120      22.614  24.177   5.685  1.00 11.76           O  
ATOM    990  CB  CYS   120      25.686  24.461   5.878  1.00 14.73           C  
ATOM    991  SG  CYS   120      26.522  23.273   4.810  1.00 16.05           S  
ATOM    992  N   SER   121      23.201  22.090   6.173  1.00  9.79           N  
ATOM    993  CA  SER   121      21.932  21.600   5.617  1.00  9.15           C  
ATOM    994  C   SER   121      21.619  20.186   6.091  1.00  9.30           C  
ATOM    995  O   SER   121      22.491  19.456   6.557  1.00  8.05           O  
ATOM    996  CB  SER   121      21.946  21.631   4.096  1.00 11.30           C  
ATOM    997  OG  SER   121      22.925  20.738   3.603  1.00 14.18           O  
ATOM    998  N   TYR   122      20.347  19.865   5.925  1.00 10.59           N  
ATOM    999  CA  TYR   122      19.742  18.640   6.420  1.00  8.48           C  
ATOM   1000  C   TYR   122      18.696  18.157   5.435  1.00 10.56           C  
ATOM   1001  O   TYR   122      17.924  18.934   4.928  1.00  8.72           O  
ATOM   1002  CB  TYR   122      19.110  18.985   7.781  1.00 11.47           C  
ATOM   1003  CG  TYR   122      18.187  17.992   8.447  1.00 13.19           C  
ATOM   1004  CD1 TYR   122      16.911  17.709   7.941  1.00 12.22           C  
ATOM   1005  CD2 TYR   122      18.561  17.391   9.625  1.00 14.99           C  
ATOM   1006  CE1 TYR   122      16.042  16.832   8.606  1.00  9.31           C  
ATOM   1007  CE2 TYR   122      17.722  16.517  10.284  1.00 12.40           C  
ATOM   1008  CZ  TYR   122      16.456  16.257   9.795  1.00  7.85           C  
ATOM   1009  OH  TYR   122      15.666  15.371  10.493  1.00 16.10           O  
ATOM   1010  N   ARG   123      18.678  16.849   5.196  1.00  8.64           N  
ATOM   1011  CA  ARG   123      17.690  16.217   4.348  1.00  9.41           C  
ATOM   1012  C   ARG   123      17.282  14.913   4.993  1.00 11.69           C  
ATOM   1013  O   ARG   123      18.159  14.127   5.400  1.00  9.50           O  
ATOM   1014  CB  ARG   123      18.261  15.916   2.964  1.00  9.14           C  
ATOM   1015  CG  ARG   123      18.679  17.180   2.178  1.00  9.79           C  
ATOM   1016  CD  ARG   123      19.668  16.841   1.032  1.00 10.51           C  
ATOM   1017  NE  ARG   123      20.925  16.362   1.584  1.00 11.21           N  
ATOM   1018  CZ  ARG   123      21.828  17.160   2.120  1.00 11.60           C  
ATOM   1019  NH1 ARG   123      21.638  18.482   2.059  1.00 11.76           N  
ATOM   1020  NH2 ARG   123      22.916  16.650   2.657  1.00 12.60           N  
ATOM   1021  N   GLU   124      15.971  14.747   5.104  1.00  9.72           N  
ATOM   1022  CA  GLU   124      15.343  13.555   5.670  1.00  9.76           C  
ATOM   1023  C   GLU   124      14.559  12.746   4.651  1.00  8.31           C  
ATOM   1024  O   GLU   124      13.783  13.271   3.838  1.00  9.69           O  
ATOM   1025  CB  GLU   124      14.461  13.918   6.876  1.00 10.27           C  
ATOM   1026  CG  GLU   124      13.893  12.657   7.536  1.00  7.31           C  
ATOM   1027  CD  GLU   124      13.214  12.865   8.874  1.00 16.17           C  
ATOM   1028  OE1 GLU   124      13.493  13.864   9.570  1.00 14.38           O  
ATOM   1029  OE2 GLU   124      12.396  11.980   9.227  1.00 17.45           O  
ATOM   1030  N   TYR   125      14.799  11.433   4.719  1.00  7.08           N  
ATOM   1031  CA  TYR   125      14.150  10.444   3.836  1.00  6.77           C  
ATOM   1032  C   TYR   125      13.528   9.315   4.676  1.00  6.70           C  
ATOM   1033  O   TYR   125      14.124   8.872   5.670  1.00  9.84           O  
ATOM   1034  CB  TYR   125      15.167   9.813   2.878  1.00  7.85           C  
ATOM   1035  CG  TYR   125      16.000  10.760   2.036  1.00  7.29           C  
ATOM   1036  CD1 TYR   125      17.132  11.417   2.560  1.00  9.01           C  
ATOM   1037  CD2 TYR   125      15.668  10.999   0.695  1.00  7.78           C  
ATOM   1038  CE1 TYR   125      17.913  12.244   1.770  1.00  7.17           C  
ATOM   1039  CE2 TYR   125      16.446  11.873  -0.102  1.00 10.12           C  
ATOM   1040  CZ  TYR   125      17.567  12.502   0.459  1.00  9.28           C  
ATOM   1041  OH  TYR   125      18.342  13.345  -0.329  1.00 12.06           O  
ATOM   1042  N   PHE   126      12.339   8.869   4.274  1.00  8.11           N  
ATOM   1043  CA  PHE   126      11.593   7.788   4.967  1.00  8.79           C  
ATOM   1044  C   PHE   126      11.856   6.450   4.271  1.00  8.73           C  
ATOM   1045  O   PHE   126      11.702   6.352   3.053  1.00  8.91           O  
ATOM   1046  CB  PHE   126      10.058   8.015   4.916  1.00 10.91           C  
ATOM   1047  CG  PHE   126       9.563   9.334   5.486  1.00 14.57           C  
ATOM   1048  CD1 PHE   126      10.312  10.052   6.396  1.00  9.56           C  
ATOM   1049  CD2 PHE   126       8.298   9.791   5.167  1.00 17.13           C  
ATOM   1050  CE1 PHE   126       9.816  11.261   6.956  1.00 17.96           C  
ATOM   1051  CE2 PHE   126       7.787  10.971   5.710  1.00 18.41           C  
ATOM   1052  CZ  PHE   126       8.545  11.709   6.602  1.00 17.85           C  
ATOM   1053  N   GLY   127      12.188   5.414   5.059  1.00  7.81           N  
ATOM   1054  CA  GLY   127      12.525   4.085   4.543  1.00  4.81           C  
ATOM   1055  C   GLY   127      11.538   2.988   4.869  1.00  7.51           C  
ATOM   1056  O   GLY   127      11.690   1.872   4.405  1.00 10.00           O  
ATOM   1057  N   SER   128      10.548   3.299   5.707  1.00 10.27           N  
ATOM   1058  CA  SER   128       9.465   2.370   5.998  1.00 11.83           C  
ATOM   1059  C   SER   128       8.122   3.109   6.077  1.00 12.72           C  
ATOM   1060  O   SER   128       7.974   4.243   5.591  1.00 12.94           O  
ATOM   1061  CB  SER   128       9.765   1.588   7.283  1.00 11.83           C  
ATOM   1062  OG  SER   128       8.925   0.441   7.469  1.00 10.54           O  
ATOM   1063  N   ASP   129       7.192   2.502   6.793  1.00 11.16           N  
ATOM   1064  CA  ASP   129       5.771   2.900   6.789  1.00 13.73           C  
ATOM   1065  C   ASP   129       5.282   3.433   8.133  1.00 13.07           C  
ATOM   1066  O   ASP   129       4.094   3.636   8.337  1.00 12.72           O  
ATOM   1067  CB  ASP   129       4.860   1.753   6.362  1.00 10.87           C  
ATOM   1068  CG  ASP   129       4.907   0.586   7.294  1.00 19.51           C  
ATOM   1069  OD1 ASP   129       5.629   0.672   8.314  1.00 11.13           O  
ATOM   1070  OD2 ASP   129       4.201  -0.408   6.992  1.00 15.74           O  
ATOM   1071  N   GLY   130       6.223   3.686   9.030  1.00 12.26           N  
ATOM   1072  CA  GLY   130       5.909   4.264  10.341  1.00 11.04           C  
ATOM   1073  C   GLY   130       5.354   3.288  11.354  1.00 13.87           C  
ATOM   1074  O   GLY   130       5.074   3.675  12.492  1.00 15.93           O  
ATOM   1075  N   LYS   131       5.200   2.039  10.904  1.00 12.07           N  
ATOM   1076  CA  LYS   131       4.632   0.917  11.687  1.00 15.54           C  
ATOM   1077  C   LYS   131       5.630  -0.187  11.946  1.00 16.41           C  
ATOM   1078  O   LYS   131       5.392  -1.107  12.729  1.00 17.42           O  
ATOM   1079  CB  LYS   131       3.443   0.280  10.933  1.00 16.30           C  
ATOM   1080  CG  LYS   131       2.252   1.167  10.793  1.00 25.46           C  
ATOM   1081  CD  LYS   131       1.065   0.395  10.241  1.00 27.46           C  
ATOM   1082  CE  LYS   131       1.267   0.048   8.778  1.00 33.25           C  
ATOM   1083  N   SER   132       6.770  -0.092  11.282  1.00 13.89           N  
ATOM   1084  CA  SER   132       7.720  -1.190  11.221  1.00 14.50           C  
ATOM   1085  C   SER   132       9.089  -0.700  10.787  1.00 15.49           C  
ATOM   1086  O   SER   132       9.220   0.354  10.143  1.00 12.80           O  
ATOM   1087  CB  SER   132       7.259  -2.223  10.201  1.00 17.04           C  
ATOM   1088  OG  SER   132       7.312  -1.683   8.882  1.00 15.91           O  
ATOM   1089  N   ASN   133      10.104  -1.465  11.150  1.00 12.51           N  
ATOM   1090  CA  ASN   133      11.459  -1.135  10.727  1.00 12.69           C  
ATOM   1091  C   ASN   133      12.407  -2.342  10.679  1.00 13.42           C  
ATOM   1092  O   ASN   133      13.649  -2.210  10.642  1.00 14.20           O  
ATOM   1093  CB  ASN   133      12.002  -0.049  11.641  1.00 11.93           C  
ATOM   1094  CG  ASN   133      12.153  -0.519  13.074  1.00 10.96           C  
ATOM   1095  OD1 ASN   133      12.152  -1.726  13.336  1.00 14.18           O  
ATOM   1096  ND2 ASN   133      12.311   0.423  14.008  1.00 12.15           N  
ATOM   1097  OXT ASN   133      11.914  -3.488  10.658  1.00 16.09           O  
END
