
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  153 ( 2322),  selected  153 , name 2yt2_A
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2yt2_A.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      G       9           -
LGA    S     2_A      N      10           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    L     8_A      -       -           -
LGA    N     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    D    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    V    13_A      -       -           -
LGA    P    14_A      A      11           #
LGA    D    15_A      A      12          4.146
LGA    N    16_A      E      13          4.315
LGA    H    17_A      V      14          4.348
LGA    P    18_A      N      15           -
LGA    -       -      L      16           -
LGA    -       -      D      17           -
LGA    -       -      E      18           -
LGA    -       -      L      19           -
LGA    -       -      A      20           -
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    -       -      L      23           -
LGA    -       -      G      24           -
LGA    -       -      P      25           -
LGA    -       -      I      26           -
LGA    -       -      M      27           -
LGA    -       -      G      28           -
LGA    -       -      D      29           -
LGA    -       -      N      30           -
LGA    -       -      E      31           -
LGA    -       -      Q      32           -
LGA    -       -      L      33           -
LGA    -       -      A      34           -
LGA    T    19_A      L      35          1.328
LGA    K    20_A      A      36          1.093
LGA    F    21_A      Y      37          1.849
LGA    K    22_A      R      38          3.577
LGA    V    23_A      V      39          5.165
LGA    T    24_A      -       -           -
LGA    N    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    D    27_A      -       -           -
LGA    D    28_A      -       -           -
LGA    E    29_A      -       -           -
LGA    G    30_A      -       -           -
LGA    V    31_A      -       -           -
LGA    E    32_A      -       -           -
LGA    L    33_A      -       -           -
LGA    G    34_A      -       -           -
LGA    S    35_A      -       -           -
LGA    G    36_A      I      40           #
LGA    V    37_A      R      41           #
LGA    -       -      D      42           -
LGA    -       -      M      43           -
LGA    M    38_A      F      44          0.499
LGA    E    39_A      V      45          0.455
LGA    L    40_A      F      46          0.794
LGA    T    41_A      T      47          0.819
LGA    Q    42_A      N      48          1.027
LGA    S    43_A      K      49          1.614
LGA    E    44_A      R      50          1.182
LGA    L    45_A      L      51          1.267
LGA    V    46_A      I      52          0.843
LGA    L    47_A      L      53          0.560
LGA    H    48_A      I      54          1.203
LGA    L    49_A      D      55          0.957
LGA    H    50_A      K      56          0.496
LGA    -       -      Q      57           -
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    -       -      T      60           -
LGA    -       -      G      61           -
LGA    R    51_A      K      62          3.833
LGA    R    52_A      K      63          3.748
LGA    -       -      V      64           -
LGA    E    53_A      S      65          1.988
LGA    A    54_A      Y      66          1.454
LGA    V    55_A      H      67          1.027
LGA    R    56_A      S      68          1.381
LGA    W    57_A      V      69          1.200
LGA    P    58_A      P      70          1.657
LGA    Y    59_A      Y      71          1.090
LGA    L    60_A      K      72          0.923
LGA    C    61_A      A      73          1.757
LGA    L    62_A      I      74          0.958
LGA    R    63_A      T      75          1.339
LGA    R    64_A      H      76          0.709
LGA    Y    65_A      F      77          0.909
LGA    G    66_A      E      78          1.636
LGA    Y    67_A      V      79          1.883
LGA    D    68_A      E      80          2.947
LGA    S    69_A      T      81          3.353
LGA    -       -      A      82           -
LGA    -       -      G      83           -
LGA    -       -      T      84           -
LGA    -       -      F      85           -
LGA    -       -      D      86           -
LGA    -       -      M      87           -
LGA    -       -      D      88           -
LGA    N    70_A      A      89          2.439
LGA    L    71_A      E      90          1.842
LGA    F    72_A      L      91          1.650
LGA    S    73_A      K      92          1.412
LGA    F    74_A      L      93          0.835
LGA    E    75_A      W      94          0.517
LGA    S    76_A      I      95          0.398
LGA    G    77_A      S      96          0.672
LGA    R    78_A      G      97          1.059
LGA    R    79_A      -       -           -
LGA    C    80_A      -       -           -
LGA    Q    81_A      -       -           -
LGA    T    82_A      -       -           -
LGA    G    83_A      Q      98          3.404
LGA    Q    84_A      K      99          3.541
LGA    G    85_A      D     100          2.174
LGA    I    86_A      P     101          0.798
LGA    F    87_A      L     102          1.207
LGA    A    88_A      V     103          0.685
LGA    F    89_A      K     104          1.306
LGA    K    90_A      E     105          1.274
LGA    C    91_A      L     106          2.311
LGA    S    92_A      K     107          2.697
LGA    -       -      K     108           -
LGA    -       -      G     109           -
LGA    R    93_A      T     110          1.920
LGA    A    94_A      D     111          6.064
LGA    E    95_A      V     112          1.641
LGA    -       -      V     113           -
LGA    E    96_A      G     114          2.633
LGA    I    97_A      I     115          1.932
LGA    F    98_A      Q     116          2.070
LGA    N    99_A      K     117          1.806
LGA    L   100_A      T     118          1.255
LGA    L   101_A      I     119          1.772
LGA    Q   102_A      A     120          1.557
LGA    D   103_A      N     121          1.655
LGA    L   104_A      F     122          2.322
LGA    M   105_A      S     123          2.755
LGA    Q   106_A      -       -           -
LGA    C   107_A      -       -           -
LGA    N   108_A      -       -           -
LGA    S   109_A      -       -           -
LGA    I   110_A      -       -           -
LGA    N   111_A      -       -           -
LGA    V   112_A      -       -           -
LGA    M   113_A      -       -           -
LGA    E   114_A      -       -           -
LGA    E   115_A      -       -           -
LGA    P   116_A      -       -           -
LGA    V   117_A      -       -           -
LGA    I   118_A      -       -           -
LGA    I   119_A      -       -           -
LGA    T   120_A      -       -           -
LGA    S   121_A      -       -           -
LGA    G   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    S   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    S   126_A      -       -           -
LGA    S   127_A      -       -           -
LGA    G   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    S   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    S   132_A      -       -           -
LGA    S   133_A      -       -           -
LGA    G   134_A      -       -           -
LGA    L   135_A      -       -           -
LGA    F   136_A      -       -           -
LGA    R   137_A      -       -           -
LGA    L   138_A      -       -           -
LGA    R   139_A      -       -           -
LGA    H   140_A      -       -           -
LGA    F   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    C   143_A      -       -           -
LGA    G   144_A      -       -           -
LGA    N   145_A      -       -           -
LGA    V   146_A      -       -           -
LGA    N   147_A      -       -           -
LGA    Y   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    Y   150_A      L     124          5.004
LGA    Q   151_A      -       -           -
LGA    Q   152_A      -       -           -
LGA    Q   153_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  153  116    5.0     73    2.23     9.59     52.379     3.132

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.892073 * X  +  -0.218448 * Y  +   0.395583 * Z  +  58.405582
  Y_new =  -0.450825 * X  +   0.370128 * Y  +  -0.812257 * Z  + -15.789794
  Z_new =   0.031019 * X  +  -0.902932 * Y  +  -0.428663 * Z  +   8.261358 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.014037    1.127556  [ DEG:  -115.3958     64.6042 ]
  Theta =  -0.031024   -3.110569  [ DEG:    -1.7776   -178.2224 ]
  Phi   =  -2.673660    0.467932  [ DEG:  -153.1895     26.8106 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2yt2_A                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2yt2_A.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  153  116   5.0   73   2.23    9.59  52.379
REMARK  ---------------------------------------------------------- 
MOLECULE 2yt2_A
HEADER    SIGNALING PROTEIN                       05-APR-07   2YT2              
TITLE     SOLUTION STRUCTURE OF THE CHIMERA OF THE PTB DOMAIN OF SNT-           
TITLE    2 2 AND 19-RESIDUE PEPTIDE (AA 1571-1589) OF HALK                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FIBROBLAST GROWTH FACTOR RECEPTOR SUBSTRATE 3              
COMPND   3 AND ALK TYROSINE KINASE RECEPTOR;                                    
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: PTB DOMAIN AND 19-RESIDUE PEPTIDE;                         
COMPND   6 SYNONYM: FGFR SUBSTRATE 3, SUC1-ASSOCIATED NEUROTROPHIC              
COMPND   7 FACTOR TARGET 2, SNT-2, FGFR-SIGNALING ADAPTOR SNT2;                 
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: P060724-01;                               
SOURCE   6 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    CHIMERA, SNT-2, PTB DOMAIN, HALK, STRUCTURAL GENOMICS,                
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI, SIGNALING PROTEIN                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,S.KOSHIBA,T.TOMIZAWA,S.WATANABE,T.HARADA,T.KIGAWA,               
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   08-APR-08 2YT2    0                                                
JRNL        AUTH   H.LI,S.KOSHIBA,T.TOMIZAWA,S.WATANABE,T.HARADA,               
JRNL        AUTH 2 T.KIGAWA,S.YOKOYAMA                                          
JRNL        TITL   SOLUTION STRUCTURE OF THE CHIMERA OF THE PTB                 
JRNL        TITL 2 DOMAIN OF SNT-2 AND 19-RESIDUE PEPTIDE (AA                   
JRNL        TITL 3 1571-1589) OF HALK                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YT2 A    8   120  UNP    O43559   FRS3_HUMAN       8    120             
DBREF  2YT2 A  135   153  UNP    Q9UM73   ALK_HUMAN     1571   1589             
SEQRES   1 A  153  GLY SER SER GLY SER SER GLY LEU ASN ARG ASP SER VAL          
SEQRES   2 A  153  PRO ASP ASN HIS PRO THR LYS PHE LYS VAL THR ASN VAL          
SEQRES   3 A  153  ASP ASP GLU GLY VAL GLU LEU GLY SER GLY VAL MET GLU          
SEQRES   4 A  153  LEU THR GLN SER GLU LEU VAL LEU HIS LEU HIS ARG ARG          
SEQRES   5 A  153  GLU ALA VAL ARG TRP PRO TYR LEU CYS LEU ARG ARG TYR          
SEQRES   6 A  153  GLY TYR ASP SER ASN LEU PHE SER PHE GLU SER GLY ARG          
SEQRES   7 A  153  ARG CYS GLN THR GLY GLN GLY ILE PHE ALA PHE LYS CYS          
SEQRES   8 A  153  SER ARG ALA GLU GLU ILE PHE ASN LEU LEU GLN ASP LEU          
SEQRES   9 A  153  MET GLN CYS ASN SER ILE ASN VAL MET GLU GLU PRO VAL          
SEQRES  10 A  153  ILE ILE THR SER GLY SER SER GLY SER SER GLY SER SER          
SEQRES  11 A  153  GLY SER SER GLY LEU PHE ARG LEU ARG HIS PHE PRO CYS          
SEQRES  12 A  153  GLY ASN VAL ASN TYR GLY TYR GLN GLN GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      59.933 -37.805  -1.488  1.00  0.00           N  
ATOM      2  CA  GLY A   1      58.500 -37.983  -1.335  1.00  0.00           C  
ATOM      3  C   GLY A   1      58.155 -39.038  -0.303  1.00  0.00           C  
ATOM      4  O   GLY A   1      57.619 -40.093  -0.639  1.00  0.00           O  
ATOM      5  H1  GLY A   1      60.386 -38.155  -2.284  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      58.062 -37.043  -1.037  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      58.083 -38.278  -2.287  1.00  0.00           H  
ATOM      8  N   SER A   2      58.462 -38.752   0.958  1.00  0.00           N  
ATOM      9  CA  SER A   2      58.185 -39.686   2.043  1.00  0.00           C  
ATOM     10  C   SER A   2      57.515 -38.974   3.215  1.00  0.00           C  
ATOM     11  O   SER A   2      57.807 -37.813   3.499  1.00  0.00           O  
ATOM     12  CB  SER A   2      59.479 -40.355   2.510  1.00  0.00           C  
ATOM     13  OG  SER A   2      59.830 -41.434   1.663  1.00  0.00           O  
ATOM     14  H   SER A   2      58.888 -37.893   1.163  1.00  0.00           H  
ATOM     15  HA  SER A   2      57.514 -40.443   1.665  1.00  0.00           H  
ATOM     16  HB2 SER A   2      60.280 -39.631   2.501  1.00  0.00           H  
ATOM     17  HB3 SER A   2      59.344 -40.731   3.515  1.00  0.00           H  
ATOM     18  HG  SER A   2      60.066 -42.198   2.196  1.00  0.00           H  
ATOM     19  N   SER A   3      56.614 -39.681   3.891  1.00  0.00           N  
ATOM     20  CA  SER A   3      55.899 -39.117   5.029  1.00  0.00           C  
ATOM     21  C   SER A   3      56.576 -39.502   6.341  1.00  0.00           C  
ATOM     22  O   SER A   3      56.615 -40.674   6.712  1.00  0.00           O  
ATOM     23  CB  SER A   3      54.446 -39.595   5.033  1.00  0.00           C  
ATOM     24  OG  SER A   3      53.762 -39.139   6.187  1.00  0.00           O  
ATOM     25  H   SER A   3      56.426 -40.602   3.615  1.00  0.00           H  
ATOM     26  HA  SER A   3      55.915 -38.042   4.931  1.00  0.00           H  
ATOM     27  HB2 SER A   3      53.942 -39.215   4.157  1.00  0.00           H  
ATOM     28  HB3 SER A   3      54.426 -40.676   5.019  1.00  0.00           H  
ATOM     29  HG  SER A   3      53.866 -39.779   6.895  1.00  0.00           H  
ATOM     30  N   GLY A   4      57.110 -38.504   7.040  1.00  0.00           N  
ATOM     31  CA  GLY A   4      57.779 -38.757   8.302  1.00  0.00           C  
ATOM     32  C   GLY A   4      56.804 -39.046   9.427  1.00  0.00           C  
ATOM     33  O   GLY A   4      55.695 -38.514   9.448  1.00  0.00           O  
ATOM     34  H   GLY A   4      57.049 -37.589   6.694  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      58.438 -39.605   8.184  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      58.367 -37.890   8.565  1.00  0.00           H  
ATOM     37  N   SER A   5      57.219 -39.892  10.365  1.00  0.00           N  
ATOM     38  CA  SER A   5      56.373 -40.254  11.495  1.00  0.00           C  
ATOM     39  C   SER A   5      56.796 -39.504  12.754  1.00  0.00           C  
ATOM     40  O   SER A   5      57.970 -39.177  12.930  1.00  0.00           O  
ATOM     41  CB  SER A   5      56.434 -41.763  11.742  1.00  0.00           C  
ATOM     42  OG  SER A   5      55.789 -42.108  12.955  1.00  0.00           O  
ATOM     43  H   SER A   5      58.115 -40.283  10.292  1.00  0.00           H  
ATOM     44  HA  SER A   5      55.357 -39.980  11.251  1.00  0.00           H  
ATOM     45  HB2 SER A   5      55.945 -42.279  10.929  1.00  0.00           H  
ATOM     46  HB3 SER A   5      57.468 -42.075  11.796  1.00  0.00           H  
ATOM     47  HG  SER A   5      54.909 -42.443  12.766  1.00  0.00           H  
ATOM     48  N   SER A   6      55.831 -39.234  13.627  1.00  0.00           N  
ATOM     49  CA  SER A   6      56.102 -38.519  14.868  1.00  0.00           C  
ATOM     50  C   SER A   6      56.653 -39.463  15.931  1.00  0.00           C  
ATOM     51  O   SER A   6      55.905 -40.209  16.564  1.00  0.00           O  
ATOM     52  CB  SER A   6      54.828 -37.844  15.381  1.00  0.00           C  
ATOM     53  OG  SER A   6      54.483 -36.729  14.578  1.00  0.00           O  
ATOM     54  H   SER A   6      54.915 -39.521  13.430  1.00  0.00           H  
ATOM     55  HA  SER A   6      56.841 -37.760  14.659  1.00  0.00           H  
ATOM     56  HB2 SER A   6      54.015 -38.552  15.360  1.00  0.00           H  
ATOM     57  HB3 SER A   6      54.985 -37.507  16.396  1.00  0.00           H  
ATOM     58  HG  SER A   6      55.272 -36.216  14.386  1.00  0.00           H  
ATOM     59  N   GLY A   7      57.968 -39.429  16.121  1.00  0.00           N  
ATOM     60  CA  GLY A   7      58.600 -40.286  17.108  1.00  0.00           C  
ATOM     61  C   GLY A   7      57.900 -40.236  18.452  1.00  0.00           C  
ATOM     62  O   GLY A   7      57.227 -41.189  18.846  1.00  0.00           O  
ATOM     63  H   GLY A   7      58.515 -38.815  15.587  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      58.587 -41.304  16.745  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      59.625 -39.973  17.237  1.00  0.00           H  
ATOM     66  N   LEU A   8      58.059 -39.122  19.158  1.00  0.00           N  
ATOM     67  CA  LEU A   8      57.439 -38.952  20.467  1.00  0.00           C  
ATOM     68  C   LEU A   8      57.429 -37.483  20.878  1.00  0.00           C  
ATOM     69  O   LEU A   8      58.397 -36.758  20.649  1.00  0.00           O  
ATOM     70  CB  LEU A   8      58.180 -39.781  21.517  1.00  0.00           C  
ATOM     71  CG  LEU A   8      59.550 -39.252  21.947  1.00  0.00           C  
ATOM     72  CD1 LEU A   8      60.247 -40.251  22.857  1.00  0.00           C  
ATOM     73  CD2 LEU A   8      60.409 -38.947  20.729  1.00  0.00           C  
ATOM     74  H   LEU A   8      58.607 -38.398  18.792  1.00  0.00           H  
ATOM     75  HA  LEU A   8      56.420 -39.300  20.399  1.00  0.00           H  
ATOM     76  HB2 LEU A   8      57.557 -39.836  22.396  1.00  0.00           H  
ATOM     77  HB3 LEU A   8      58.321 -40.774  21.114  1.00  0.00           H  
ATOM     78  HG  LEU A   8      59.415 -38.333  22.501  1.00  0.00           H  
ATOM     79 HD11 LEU A   8      60.733 -39.724  23.664  1.00  0.00           H  
ATOM     80 HD12 LEU A   8      60.983 -40.801  22.291  1.00  0.00           H  
ATOM     81 HD13 LEU A   8      59.517 -40.938  23.263  1.00  0.00           H  
ATOM     82 HD21 LEU A   8      60.125 -39.597  19.915  1.00  0.00           H  
ATOM     83 HD22 LEU A   8      61.449 -39.109  20.973  1.00  0.00           H  
ATOM     84 HD23 LEU A   8      60.265 -37.917  20.436  1.00  0.00           H  
ATOM     85  N   ASN A   9      56.331 -37.051  21.488  1.00  0.00           N  
ATOM     86  CA  ASN A   9      56.196 -35.668  21.933  1.00  0.00           C  
ATOM     87  C   ASN A   9      55.822 -35.606  23.411  1.00  0.00           C  
ATOM     88  O   ASN A   9      54.727 -36.007  23.802  1.00  0.00           O  
ATOM     89  CB  ASN A   9      55.138 -34.944  21.098  1.00  0.00           C  
ATOM     90  CG  ASN A   9      55.641 -34.586  19.712  1.00  0.00           C  
ATOM     91  OD1 ASN A   9      55.796 -35.453  18.853  1.00  0.00           O  
ATOM     92  ND2 ASN A   9      55.899 -33.301  19.490  1.00  0.00           N  
ATOM     93  H   ASN A   9      55.592 -37.677  21.643  1.00  0.00           H  
ATOM     94  HA  ASN A   9      57.149 -35.181  21.792  1.00  0.00           H  
ATOM     95  HB2 ASN A   9      54.273 -35.581  20.991  1.00  0.00           H  
ATOM     96  HB3 ASN A   9      54.851 -34.034  21.602  1.00  0.00           H  
ATOM     97 HD21 ASN A   9      55.752 -32.666  20.222  1.00  0.00           H  
ATOM     98 HD22 ASN A   9      56.225 -33.042  18.603  1.00  0.00           H  
ATOM     99  N   ARG A  10      56.742 -35.100  24.226  1.00  0.00           N  
ATOM    100  CA  ARG A  10      56.510 -34.985  25.661  1.00  0.00           C  
ATOM    101  C   ARG A  10      56.516 -33.522  26.097  1.00  0.00           C  
ATOM    102  O   ARG A  10      57.292 -33.127  26.967  1.00  0.00           O  
ATOM    103  CB  ARG A  10      57.576 -35.763  26.435  1.00  0.00           C  
ATOM    104  CG  ARG A  10      58.996 -35.473  25.976  1.00  0.00           C  
ATOM    105  CD  ARG A  10      59.974 -36.512  26.500  1.00  0.00           C  
ATOM    106  NE  ARG A  10      61.353 -36.196  26.140  1.00  0.00           N  
ATOM    107  CZ  ARG A  10      62.385 -36.984  26.421  1.00  0.00           C  
ATOM    108  NH1 ARG A  10      62.194 -38.130  27.061  1.00  0.00           N  
ATOM    109  NH2 ARG A  10      63.612 -36.627  26.060  1.00  0.00           N  
ATOM    110  H   ARG A  10      57.596 -34.796  23.854  1.00  0.00           H  
ATOM    111  HA  ARG A  10      55.541 -35.409  25.875  1.00  0.00           H  
ATOM    112  HB2 ARG A  10      57.501 -35.509  27.482  1.00  0.00           H  
ATOM    113  HB3 ARG A  10      57.391 -36.820  26.314  1.00  0.00           H  
ATOM    114  HG2 ARG A  10      59.023 -35.481  24.896  1.00  0.00           H  
ATOM    115  HG3 ARG A  10      59.289 -34.499  26.339  1.00  0.00           H  
ATOM    116  HD2 ARG A  10      59.893 -36.553  27.576  1.00  0.00           H  
ATOM    117  HD3 ARG A  10      59.714 -37.474  26.084  1.00  0.00           H  
ATOM    118  HE  ARG A  10      61.518 -35.355  25.666  1.00  0.00           H  
ATOM    119 HH11 ARG A  10      61.271 -38.401  27.332  1.00  0.00           H  
ATOM    120 HH12 ARG A  10      62.972 -38.722  27.270  1.00  0.00           H  
ATOM    121 HH21 ARG A  10      63.760 -35.765  25.577  1.00  0.00           H  
ATOM    122 HH22 ARG A  10      64.388 -37.221  26.271  1.00  0.00           H  
ATOM    123  N   ASP A  11      55.646 -32.725  25.487  1.00  0.00           N  
ATOM    124  CA  ASP A  11      55.550 -31.307  25.812  1.00  0.00           C  
ATOM    125  C   ASP A  11      54.096 -30.848  25.820  1.00  0.00           C  
ATOM    126  O   ASP A  11      53.225 -31.503  25.246  1.00  0.00           O  
ATOM    127  CB  ASP A  11      56.355 -30.477  24.812  1.00  0.00           C  
ATOM    128  CG  ASP A  11      56.868 -29.182  25.413  1.00  0.00           C  
ATOM    129  OD1 ASP A  11      56.988 -29.111  26.655  1.00  0.00           O  
ATOM    130  OD2 ASP A  11      57.151 -28.242  24.643  1.00  0.00           O  
ATOM    131  H   ASP A  11      55.054 -33.100  24.801  1.00  0.00           H  
ATOM    132  HA  ASP A  11      55.964 -31.165  26.799  1.00  0.00           H  
ATOM    133  HB2 ASP A  11      57.202 -31.055  24.473  1.00  0.00           H  
ATOM    134  HB3 ASP A  11      55.727 -30.236  23.967  1.00  0.00           H  
ATOM    135  N   SER A  12      53.839 -29.720  26.474  1.00  0.00           N  
ATOM    136  CA  SER A  12      52.489 -29.176  26.559  1.00  0.00           C  
ATOM    137  C   SER A  12      52.083 -28.519  25.243  1.00  0.00           C  
ATOM    138  O   SER A  12      50.899 -28.294  24.988  1.00  0.00           O  
ATOM    139  CB  SER A  12      52.397 -28.159  27.698  1.00  0.00           C  
ATOM    140  OG  SER A  12      51.047 -27.848  27.998  1.00  0.00           O  
ATOM    141  H   SER A  12      54.575 -29.243  26.911  1.00  0.00           H  
ATOM    142  HA  SER A  12      51.814 -29.994  26.764  1.00  0.00           H  
ATOM    143  HB2 SER A  12      52.863 -28.569  28.582  1.00  0.00           H  
ATOM    144  HB3 SER A  12      52.908 -27.252  27.410  1.00  0.00           H  
ATOM    145  HG  SER A  12      50.966 -26.907  28.173  1.00  0.00           H  
ATOM    146  N   VAL A  13      53.072 -28.217  24.410  1.00  0.00           N  
ATOM    147  CA  VAL A  13      52.821 -27.588  23.119  1.00  0.00           C  
ATOM    148  C   VAL A  13      52.434 -28.624  22.069  1.00  0.00           C  
ATOM    149  O   VAL A  13      53.030 -29.698  21.972  1.00  0.00           O  
ATOM    150  CB  VAL A  13      54.052 -26.807  22.625  1.00  0.00           C  
ATOM    151  CG1 VAL A  13      53.713 -26.010  21.375  1.00  0.00           C  
ATOM    152  CG2 VAL A  13      54.578 -25.893  23.723  1.00  0.00           C  
ATOM    153  H   VAL A  13      53.996 -28.422  24.669  1.00  0.00           H  
ATOM    154  HA  VAL A  13      52.003 -26.892  23.241  1.00  0.00           H  
ATOM    155  HB  VAL A  13      54.827 -27.517  22.374  1.00  0.00           H  
ATOM    156 HG11 VAL A  13      54.625 -25.657  20.914  1.00  0.00           H  
ATOM    157 HG12 VAL A  13      53.180 -26.641  20.679  1.00  0.00           H  
ATOM    158 HG13 VAL A  13      53.095 -25.165  21.642  1.00  0.00           H  
ATOM    159 HG21 VAL A  13      55.578 -25.569  23.473  1.00  0.00           H  
ATOM    160 HG22 VAL A  13      53.933 -25.033  23.814  1.00  0.00           H  
ATOM    161 HG23 VAL A  13      54.597 -26.430  24.660  1.00  0.00           H  
ATOM    162  N   PRO A  14      51.415 -28.297  21.261  1.00  0.00           N  
ATOM    163  CA  PRO A  14      50.928 -29.184  20.202  1.00  0.00           C  
ATOM    164  C   PRO A  14      51.922 -29.319  19.054  1.00  0.00           C  
ATOM    165  O   PRO A  14      52.932 -28.617  19.010  1.00  0.00           O  
ATOM    166  CB  PRO A  14      49.647 -28.496  19.723  1.00  0.00           C  
ATOM    167  CG  PRO A  14      49.843 -27.057  20.058  1.00  0.00           C  
ATOM    168  CD  PRO A  14      50.661 -27.033  21.320  1.00  0.00           C  
ATOM    169  HA  PRO A  14      50.688 -30.166  20.587  1.00  0.00           H  
ATOM    170  HB2 PRO A  14      49.533 -28.643  18.658  1.00  0.00           H  
ATOM    171  HB3 PRO A  14      48.796 -28.909  20.243  1.00  0.00           H  
ATOM    172  HG2 PRO A  14      50.373 -26.564  19.258  1.00  0.00           H  
ATOM    173  HG3 PRO A  14      48.885 -26.586  20.223  1.00  0.00           H  
ATOM    174  HD2 PRO A  14      51.328 -26.184  21.321  1.00  0.00           H  
ATOM    175  HD3 PRO A  14      50.015 -27.010  22.186  1.00  0.00           H  
ATOM    176  N   ASP A  15      51.630 -30.224  18.127  1.00  0.00           N  
ATOM    177  CA  ASP A  15      52.498 -30.449  16.977  1.00  0.00           C  
ATOM    178  C   ASP A  15      51.962 -29.730  15.743  1.00  0.00           C  
ATOM    179  O   ASP A  15      52.648 -29.625  14.727  1.00  0.00           O  
ATOM    180  CB  ASP A  15      52.628 -31.946  16.694  1.00  0.00           C  
ATOM    181  CG  ASP A  15      51.303 -32.584  16.327  1.00  0.00           C  
ATOM    182  OD1 ASP A  15      50.794 -32.298  15.223  1.00  0.00           O  
ATOM    183  OD2 ASP A  15      50.775 -33.367  17.142  1.00  0.00           O  
ATOM    184  H   ASP A  15      50.809 -30.753  18.218  1.00  0.00           H  
ATOM    185  HA  ASP A  15      53.473 -30.050  17.215  1.00  0.00           H  
ATOM    186  HB2 ASP A  15      53.316 -32.093  15.875  1.00  0.00           H  
ATOM    187  HB3 ASP A  15      53.013 -32.439  17.575  1.00  0.00           H  
ATOM    188  N   ASN A  16      50.730 -29.240  15.838  1.00  0.00           N  
ATOM    189  CA  ASN A  16      50.101 -28.534  14.728  1.00  0.00           C  
ATOM    190  C   ASN A  16      49.600 -27.162  15.170  1.00  0.00           C  
ATOM    191  O   ASN A  16      48.622 -26.642  14.632  1.00  0.00           O  
ATOM    192  CB  ASN A  16      48.939 -29.355  14.165  1.00  0.00           C  
ATOM    193  CG  ASN A  16      48.625 -29.002  12.725  1.00  0.00           C  
ATOM    194  OD1 ASN A  16      49.048 -29.694  11.798  1.00  0.00           O  
ATOM    195  ND2 ASN A  16      47.880 -27.920  12.530  1.00  0.00           N  
ATOM    196  H   ASN A  16      50.232 -29.357  16.674  1.00  0.00           H  
ATOM    197  HA  ASN A  16      50.843 -28.401  13.955  1.00  0.00           H  
ATOM    198  HB2 ASN A  16      49.193 -30.404  14.211  1.00  0.00           H  
ATOM    199  HB3 ASN A  16      48.057 -29.176  14.761  1.00  0.00           H  
ATOM    200 HD21 ASN A  16      47.580 -27.417  13.315  1.00  0.00           H  
ATOM    201 HD22 ASN A  16      47.662 -27.669  11.608  1.00  0.00           H  
ATOM    202  N   HIS A  17      50.278 -26.579  16.155  1.00  0.00           N  
ATOM    203  CA  HIS A  17      49.903 -25.267  16.670  1.00  0.00           C  
ATOM    204  C   HIS A  17      49.628 -24.295  15.527  1.00  0.00           C  
ATOM    205  O   HIS A  17      50.506 -23.974  14.727  1.00  0.00           O  
ATOM    206  CB  HIS A  17      51.008 -24.715  17.569  1.00  0.00           C  
ATOM    207  CG  HIS A  17      50.496 -23.887  18.708  1.00  0.00           C  
ATOM    208  ND1 HIS A  17      49.464 -22.983  18.576  1.00  0.00           N  
ATOM    209  CD2 HIS A  17      50.878 -23.833  20.006  1.00  0.00           C  
ATOM    210  CE1 HIS A  17      49.235 -22.407  19.743  1.00  0.00           C  
ATOM    211  NE2 HIS A  17      50.079 -22.905  20.627  1.00  0.00           N  
ATOM    212  H   HIS A  17      51.049 -27.043  16.544  1.00  0.00           H  
ATOM    213  HA  HIS A  17      49.002 -25.384  17.252  1.00  0.00           H  
ATOM    214  HB2 HIS A  17      51.571 -25.538  17.985  1.00  0.00           H  
ATOM    215  HB3 HIS A  17      51.669 -24.095  16.979  1.00  0.00           H  
ATOM    216  HD1 HIS A  17      48.974 -22.790  17.751  1.00  0.00           H  
ATOM    217  HD2 HIS A  17      51.667 -24.411  20.467  1.00  0.00           H  
ATOM    218  HE1 HIS A  17      48.484 -21.655  19.941  1.00  0.00           H  
ATOM    219  HE2 HIS A  17      50.182 -22.591  21.549  1.00  0.00           H  
ATOM    220  N   PRO A  18      48.378 -23.814  15.448  1.00  0.00           N  
ATOM    221  CA  PRO A  18      47.957 -22.871  14.407  1.00  0.00           C  
ATOM    222  C   PRO A  18      48.581 -21.491  14.587  1.00  0.00           C  
ATOM    223  O   PRO A  18      49.158 -20.931  13.655  1.00  0.00           O  
ATOM    224  CB  PRO A  18      46.438 -22.798  14.587  1.00  0.00           C  
ATOM    225  CG  PRO A  18      46.209 -23.158  16.014  1.00  0.00           C  
ATOM    226  CD  PRO A  18      47.279 -24.152  16.368  1.00  0.00           C  
ATOM    227  HA  PRO A  18      48.186 -23.242  13.419  1.00  0.00           H  
ATOM    228  HB2 PRO A  18      46.095 -21.796  14.370  1.00  0.00           H  
ATOM    229  HB3 PRO A  18      45.960 -23.500  13.920  1.00  0.00           H  
ATOM    230  HG2 PRO A  18      46.294 -22.279  16.633  1.00  0.00           H  
ATOM    231  HG3 PRO A  18      45.231 -23.605  16.126  1.00  0.00           H  
ATOM    232  HD2 PRO A  18      47.585 -24.027  17.396  1.00  0.00           H  
ATOM    233  HD3 PRO A  18      46.931 -25.161  16.196  1.00  0.00           H  
ATOM    234  N   THR A  19      48.462 -20.947  15.795  1.00  0.00           N  
ATOM    235  CA  THR A  19      49.014 -19.632  16.097  1.00  0.00           C  
ATOM    236  C   THR A  19      50.527 -19.698  16.269  1.00  0.00           C  
ATOM    237  O   THR A  19      51.280 -19.201  15.430  1.00  0.00           O  
ATOM    238  CB  THR A  19      48.389 -19.042  17.376  1.00  0.00           C  
ATOM    239  OG1 THR A  19      48.489 -19.983  18.449  1.00  0.00           O  
ATOM    240  CG2 THR A  19      46.930 -18.678  17.146  1.00  0.00           C  
ATOM    241  H   THR A  19      47.991 -21.442  16.497  1.00  0.00           H  
ATOM    242  HA  THR A  19      48.783 -18.976  15.272  1.00  0.00           H  
ATOM    243  HB  THR A  19      48.931 -18.145  17.641  1.00  0.00           H  
ATOM    244  HG1 THR A  19      47.749 -20.594  18.409  1.00  0.00           H  
ATOM    245 HG21 THR A  19      46.516 -18.263  18.053  1.00  0.00           H  
ATOM    246 HG22 THR A  19      46.377 -19.565  16.872  1.00  0.00           H  
ATOM    247 HG23 THR A  19      46.861 -17.949  16.352  1.00  0.00           H  
ATOM    248  N   LYS A  20      50.968 -20.313  17.360  1.00  0.00           N  
ATOM    249  CA  LYS A  20      52.393 -20.447  17.642  1.00  0.00           C  
ATOM    250  C   LYS A  20      53.091 -21.251  16.549  1.00  0.00           C  
ATOM    251  O   LYS A  20      52.477 -22.096  15.899  1.00  0.00           O  
ATOM    252  CB  LYS A  20      52.605 -21.120  18.999  1.00  0.00           C  
ATOM    253  CG  LYS A  20      52.684 -20.140  20.158  1.00  0.00           C  
ATOM    254  CD  LYS A  20      51.302 -19.695  20.606  1.00  0.00           C  
ATOM    255  CE  LYS A  20      51.353 -18.991  21.954  1.00  0.00           C  
ATOM    256  NZ  LYS A  20      51.570 -17.525  21.806  1.00  0.00           N  
ATOM    257  H   LYS A  20      50.320 -20.689  17.992  1.00  0.00           H  
ATOM    258  HA  LYS A  20      52.820 -19.455  17.670  1.00  0.00           H  
ATOM    259  HB2 LYS A  20      51.785 -21.798  19.184  1.00  0.00           H  
ATOM    260  HB3 LYS A  20      53.527 -21.683  18.968  1.00  0.00           H  
ATOM    261  HG2 LYS A  20      53.183 -20.617  20.988  1.00  0.00           H  
ATOM    262  HG3 LYS A  20      53.249 -19.273  19.846  1.00  0.00           H  
ATOM    263  HD2 LYS A  20      50.897 -19.014  19.872  1.00  0.00           H  
ATOM    264  HD3 LYS A  20      50.663 -20.562  20.687  1.00  0.00           H  
ATOM    265  HE2 LYS A  20      50.420 -19.158  22.468  1.00  0.00           H  
ATOM    266  HE3 LYS A  20      52.163 -19.409  22.533  1.00  0.00           H  
ATOM    267  HZ1 LYS A  20      52.488 -17.256  22.214  1.00  0.00           H  
ATOM    268  HZ2 LYS A  20      50.818 -17.002  22.298  1.00  0.00           H  
ATOM    269  HZ3 LYS A  20      51.559 -17.262  20.800  1.00  0.00           H  
ATOM    270  N   PHE A  21      54.378 -20.983  16.354  1.00  0.00           N  
ATOM    271  CA  PHE A  21      55.159 -21.682  15.341  1.00  0.00           C  
ATOM    272  C   PHE A  21      56.622 -21.789  15.760  1.00  0.00           C  
ATOM    273  O   PHE A  21      57.298 -20.779  15.960  1.00  0.00           O  
ATOM    274  CB  PHE A  21      55.053 -20.960  13.996  1.00  0.00           C  
ATOM    275  CG  PHE A  21      53.705 -21.093  13.348  1.00  0.00           C  
ATOM    276  CD1 PHE A  21      53.378 -22.230  12.628  1.00  0.00           C  
ATOM    277  CD2 PHE A  21      52.765 -20.081  13.460  1.00  0.00           C  
ATOM    278  CE1 PHE A  21      52.137 -22.357  12.030  1.00  0.00           C  
ATOM    279  CE2 PHE A  21      51.523 -20.203  12.865  1.00  0.00           C  
ATOM    280  CZ  PHE A  21      51.209 -21.340  12.149  1.00  0.00           C  
ATOM    281  H   PHE A  21      54.812 -20.298  16.905  1.00  0.00           H  
ATOM    282  HA  PHE A  21      54.753 -22.676  15.239  1.00  0.00           H  
ATOM    283  HB2 PHE A  21      55.247 -19.908  14.144  1.00  0.00           H  
ATOM    284  HB3 PHE A  21      55.790 -21.365  13.319  1.00  0.00           H  
ATOM    285  HD1 PHE A  21      54.104 -23.025  12.534  1.00  0.00           H  
ATOM    286  HD2 PHE A  21      53.009 -19.190  14.020  1.00  0.00           H  
ATOM    287  HE1 PHE A  21      51.896 -23.248  11.471  1.00  0.00           H  
ATOM    288  HE2 PHE A  21      50.799 -19.407  12.959  1.00  0.00           H  
ATOM    289  HZ  PHE A  21      50.240 -21.438  11.684  1.00  0.00           H  
ATOM    290  N   LYS A  22      57.106 -23.019  15.892  1.00  0.00           N  
ATOM    291  CA  LYS A  22      58.488 -23.260  16.286  1.00  0.00           C  
ATOM    292  C   LYS A  22      59.451 -22.863  15.171  1.00  0.00           C  
ATOM    293  O   LYS A  22      59.439 -23.452  14.089  1.00  0.00           O  
ATOM    294  CB  LYS A  22      58.689 -24.735  16.645  1.00  0.00           C  
ATOM    295  CG  LYS A  22      58.422 -25.046  18.108  1.00  0.00           C  
ATOM    296  CD  LYS A  22      56.962 -24.823  18.468  1.00  0.00           C  
ATOM    297  CE  LYS A  22      56.137 -26.083  18.256  1.00  0.00           C  
ATOM    298  NZ  LYS A  22      56.144 -26.518  16.833  1.00  0.00           N  
ATOM    299  H   LYS A  22      56.519 -23.785  15.718  1.00  0.00           H  
ATOM    300  HA  LYS A  22      58.696 -22.656  17.156  1.00  0.00           H  
ATOM    301  HB2 LYS A  22      58.021 -25.333  16.044  1.00  0.00           H  
ATOM    302  HB3 LYS A  22      59.708 -25.012  16.420  1.00  0.00           H  
ATOM    303  HG2 LYS A  22      58.674 -26.078  18.299  1.00  0.00           H  
ATOM    304  HG3 LYS A  22      59.037 -24.403  18.721  1.00  0.00           H  
ATOM    305  HD2 LYS A  22      56.896 -24.534  19.506  1.00  0.00           H  
ATOM    306  HD3 LYS A  22      56.564 -24.034  17.847  1.00  0.00           H  
ATOM    307  HE2 LYS A  22      56.547 -26.873  18.867  1.00  0.00           H  
ATOM    308  HE3 LYS A  22      55.119 -25.887  18.560  1.00  0.00           H  
ATOM    309  HZ1 LYS A  22      55.308 -27.104  16.634  1.00  0.00           H  
ATOM    310  HZ2 LYS A  22      57.001 -27.073  16.632  1.00  0.00           H  
ATOM    311  HZ3 LYS A  22      56.129 -25.688  16.205  1.00  0.00           H  
ATOM    312  N   VAL A  23      60.283 -21.863  15.440  1.00  0.00           N  
ATOM    313  CA  VAL A  23      61.252 -21.389  14.460  1.00  0.00           C  
ATOM    314  C   VAL A  23      62.671 -21.464  15.011  1.00  0.00           C  
ATOM    315  O   VAL A  23      62.876 -21.630  16.214  1.00  0.00           O  
ATOM    316  CB  VAL A  23      60.955 -19.939  14.033  1.00  0.00           C  
ATOM    317  CG1 VAL A  23      59.517 -19.806  13.557  1.00  0.00           C  
ATOM    318  CG2 VAL A  23      61.238 -18.978  15.177  1.00  0.00           C  
ATOM    319  H   VAL A  23      60.243 -21.433  16.321  1.00  0.00           H  
ATOM    320  HA  VAL A  23      61.181 -22.021  13.588  1.00  0.00           H  
ATOM    321  HB  VAL A  23      61.608 -19.688  13.209  1.00  0.00           H  
ATOM    322 HG11 VAL A  23      59.294 -18.767  13.369  1.00  0.00           H  
ATOM    323 HG12 VAL A  23      59.384 -20.374  12.646  1.00  0.00           H  
ATOM    324 HG13 VAL A  23      58.850 -20.185  14.317  1.00  0.00           H  
ATOM    325 HG21 VAL A  23      62.303 -18.917  15.341  1.00  0.00           H  
ATOM    326 HG22 VAL A  23      60.855 -17.999  14.928  1.00  0.00           H  
ATOM    327 HG23 VAL A  23      60.755 -19.336  16.075  1.00  0.00           H  
ATOM    328  N   THR A  24      63.652 -21.341  14.123  1.00  0.00           N  
ATOM    329  CA  THR A  24      65.054 -21.395  14.519  1.00  0.00           C  
ATOM    330  C   THR A  24      65.881 -20.367  13.757  1.00  0.00           C  
ATOM    331  O   THR A  24      66.099 -20.498  12.553  1.00  0.00           O  
ATOM    332  CB  THR A  24      65.652 -22.795  14.280  1.00  0.00           C  
ATOM    333  OG1 THR A  24      64.716 -23.803  14.683  1.00  0.00           O  
ATOM    334  CG2 THR A  24      66.952 -22.967  15.049  1.00  0.00           C  
ATOM    335  H   THR A  24      63.427 -21.210  13.177  1.00  0.00           H  
ATOM    336  HA  THR A  24      65.110 -21.178  15.575  1.00  0.00           H  
ATOM    337  HB  THR A  24      65.856 -22.907  13.224  1.00  0.00           H  
ATOM    338  HG1 THR A  24      64.176 -23.467  15.404  1.00  0.00           H  
ATOM    339 HG21 THR A  24      67.592 -22.116  14.867  1.00  0.00           H  
ATOM    340 HG22 THR A  24      67.449 -23.867  14.719  1.00  0.00           H  
ATOM    341 HG23 THR A  24      66.740 -23.039  16.105  1.00  0.00           H  
ATOM    342  N   ASN A  25      66.342 -19.341  14.467  1.00  0.00           N  
ATOM    343  CA  ASN A  25      67.146 -18.288  13.857  1.00  0.00           C  
ATOM    344  C   ASN A  25      68.468 -18.845  13.340  1.00  0.00           C  
ATOM    345  O   ASN A  25      69.255 -19.413  14.099  1.00  0.00           O  
ATOM    346  CB  ASN A  25      67.409 -17.169  14.866  1.00  0.00           C  
ATOM    347  CG  ASN A  25      68.523 -16.241  14.422  1.00  0.00           C  
ATOM    348  OD1 ASN A  25      69.504 -16.044  15.138  1.00  0.00           O  
ATOM    349  ND2 ASN A  25      68.374 -15.665  13.235  1.00  0.00           N  
ATOM    350  H   ASN A  25      66.135 -19.290  15.423  1.00  0.00           H  
ATOM    351  HA  ASN A  25      66.589 -17.886  13.024  1.00  0.00           H  
ATOM    352  HB2 ASN A  25      66.509 -16.586  14.991  1.00  0.00           H  
ATOM    353  HB3 ASN A  25      67.685 -17.606  15.814  1.00  0.00           H  
ATOM    354 HD21 ASN A  25      67.566 -15.868  12.719  1.00  0.00           H  
ATOM    355 HD22 ASN A  25      69.080 -15.060  12.923  1.00  0.00           H  
ATOM    356  N   VAL A  26      68.709 -18.678  12.044  1.00  0.00           N  
ATOM    357  CA  VAL A  26      69.938 -19.162  11.425  1.00  0.00           C  
ATOM    358  C   VAL A  26      70.701 -18.025  10.754  1.00  0.00           C  
ATOM    359  O   VAL A  26      70.233 -16.887  10.719  1.00  0.00           O  
ATOM    360  CB  VAL A  26      69.648 -20.257  10.382  1.00  0.00           C  
ATOM    361  CG1 VAL A  26      68.846 -21.389  11.005  1.00  0.00           C  
ATOM    362  CG2 VAL A  26      68.916 -19.670   9.185  1.00  0.00           C  
ATOM    363  H   VAL A  26      68.045 -18.219  11.490  1.00  0.00           H  
ATOM    364  HA  VAL A  26      70.557 -19.588  12.202  1.00  0.00           H  
ATOM    365  HB  VAL A  26      70.590 -20.659  10.040  1.00  0.00           H  
ATOM    366 HG11 VAL A  26      67.869 -21.434  10.545  1.00  0.00           H  
ATOM    367 HG12 VAL A  26      69.362 -22.326  10.848  1.00  0.00           H  
ATOM    368 HG13 VAL A  26      68.736 -21.212  12.065  1.00  0.00           H  
ATOM    369 HG21 VAL A  26      69.623 -19.467   8.394  1.00  0.00           H  
ATOM    370 HG22 VAL A  26      68.177 -20.376   8.834  1.00  0.00           H  
ATOM    371 HG23 VAL A  26      68.428 -18.751   9.475  1.00  0.00           H  
ATOM    372  N   ASP A  27      71.876 -18.342  10.222  1.00  0.00           N  
ATOM    373  CA  ASP A  27      72.702 -17.347   9.549  1.00  0.00           C  
ATOM    374  C   ASP A  27      72.675 -17.549   8.037  1.00  0.00           C  
ATOM    375  O   ASP A  27      72.033 -18.473   7.536  1.00  0.00           O  
ATOM    376  CB  ASP A  27      74.143 -17.420  10.060  1.00  0.00           C  
ATOM    377  CG  ASP A  27      74.605 -18.846  10.286  1.00  0.00           C  
ATOM    378  OD1 ASP A  27      74.467 -19.669   9.356  1.00  0.00           O  
ATOM    379  OD2 ASP A  27      75.104 -19.139  11.392  1.00  0.00           O  
ATOM    380  H   ASP A  27      72.194 -19.267  10.281  1.00  0.00           H  
ATOM    381  HA  ASP A  27      72.299 -16.371   9.776  1.00  0.00           H  
ATOM    382  HB2 ASP A  27      74.799 -16.960   9.335  1.00  0.00           H  
ATOM    383  HB3 ASP A  27      74.213 -16.885  10.995  1.00  0.00           H  
ATOM    384  N   ASP A  28      73.374 -16.680   7.317  1.00  0.00           N  
ATOM    385  CA  ASP A  28      73.430 -16.762   5.861  1.00  0.00           C  
ATOM    386  C   ASP A  28      73.661 -18.200   5.408  1.00  0.00           C  
ATOM    387  O   ASP A  28      73.197 -18.607   4.343  1.00  0.00           O  
ATOM    388  CB  ASP A  28      74.539 -15.859   5.320  1.00  0.00           C  
ATOM    389  CG  ASP A  28      75.919 -16.324   5.737  1.00  0.00           C  
ATOM    390  OD1 ASP A  28      76.493 -17.182   5.036  1.00  0.00           O  
ATOM    391  OD2 ASP A  28      76.427 -15.830   6.767  1.00  0.00           O  
ATOM    392  H   ASP A  28      73.864 -15.964   7.774  1.00  0.00           H  
ATOM    393  HA  ASP A  28      72.481 -16.424   5.473  1.00  0.00           H  
ATOM    394  HB2 ASP A  28      74.493 -15.851   4.240  1.00  0.00           H  
ATOM    395  HB3 ASP A  28      74.390 -14.855   5.690  1.00  0.00           H  
ATOM    396  N   GLU A  29      74.382 -18.964   6.223  1.00  0.00           N  
ATOM    397  CA  GLU A  29      74.676 -20.356   5.903  1.00  0.00           C  
ATOM    398  C   GLU A  29      73.477 -21.249   6.209  1.00  0.00           C  
ATOM    399  O   GLU A  29      73.191 -22.196   5.477  1.00  0.00           O  
ATOM    400  CB  GLU A  29      75.897 -20.836   6.690  1.00  0.00           C  
ATOM    401  CG  GLU A  29      77.220 -20.398   6.087  1.00  0.00           C  
ATOM    402  CD  GLU A  29      77.691 -21.322   4.979  1.00  0.00           C  
ATOM    403  OE1 GLU A  29      78.386 -22.312   5.288  1.00  0.00           O  
ATOM    404  OE2 GLU A  29      77.364 -21.054   3.804  1.00  0.00           O  
ATOM    405  H   GLU A  29      74.723 -18.582   7.058  1.00  0.00           H  
ATOM    406  HA  GLU A  29      74.893 -20.415   4.848  1.00  0.00           H  
ATOM    407  HB2 GLU A  29      75.838 -20.448   7.696  1.00  0.00           H  
ATOM    408  HB3 GLU A  29      75.883 -21.915   6.729  1.00  0.00           H  
ATOM    409  HG2 GLU A  29      77.105 -19.405   5.680  1.00  0.00           H  
ATOM    410  HG3 GLU A  29      77.969 -20.382   6.864  1.00  0.00           H  
ATOM    411  N   GLY A  30      72.778 -20.941   7.297  1.00  0.00           N  
ATOM    412  CA  GLY A  30      71.619 -21.725   7.682  1.00  0.00           C  
ATOM    413  C   GLY A  30      71.826 -22.463   8.989  1.00  0.00           C  
ATOM    414  O   GLY A  30      70.964 -23.226   9.423  1.00  0.00           O  
ATOM    415  H   GLY A  30      73.052 -20.175   7.844  1.00  0.00           H  
ATOM    416  HA2 GLY A  30      70.770 -21.066   7.783  1.00  0.00           H  
ATOM    417  HA3 GLY A  30      71.413 -22.445   6.905  1.00  0.00           H  
ATOM    418  N   VAL A  31      72.974 -22.236   9.620  1.00  0.00           N  
ATOM    419  CA  VAL A  31      73.293 -22.886  10.886  1.00  0.00           C  
ATOM    420  C   VAL A  31      72.348 -22.429  11.991  1.00  0.00           C  
ATOM    421  O   VAL A  31      72.146 -21.231  12.192  1.00  0.00           O  
ATOM    422  CB  VAL A  31      74.744 -22.598  11.315  1.00  0.00           C  
ATOM    423  CG1 VAL A  31      75.130 -23.461  12.507  1.00  0.00           C  
ATOM    424  CG2 VAL A  31      75.698 -22.823  10.152  1.00  0.00           C  
ATOM    425  H   VAL A  31      73.623 -21.617   9.225  1.00  0.00           H  
ATOM    426  HA  VAL A  31      73.185 -23.952  10.751  1.00  0.00           H  
ATOM    427  HB  VAL A  31      74.811 -21.561  11.613  1.00  0.00           H  
ATOM    428 HG11 VAL A  31      74.527 -23.186  13.360  1.00  0.00           H  
ATOM    429 HG12 VAL A  31      74.964 -24.501  12.267  1.00  0.00           H  
ATOM    430 HG13 VAL A  31      76.173 -23.307  12.739  1.00  0.00           H  
ATOM    431 HG21 VAL A  31      75.377 -23.683   9.583  1.00  0.00           H  
ATOM    432 HG22 VAL A  31      75.701 -21.950   9.516  1.00  0.00           H  
ATOM    433 HG23 VAL A  31      76.695 -22.996  10.531  1.00  0.00           H  
ATOM    434  N   GLU A  32      71.771 -23.390  12.705  1.00  0.00           N  
ATOM    435  CA  GLU A  32      70.846 -23.086  13.790  1.00  0.00           C  
ATOM    436  C   GLU A  32      71.559 -22.351  14.922  1.00  0.00           C  
ATOM    437  O   GLU A  32      72.407 -22.920  15.610  1.00  0.00           O  
ATOM    438  CB  GLU A  32      70.209 -24.371  14.323  1.00  0.00           C  
ATOM    439  CG  GLU A  32      69.537 -25.208  13.249  1.00  0.00           C  
ATOM    440  CD  GLU A  32      69.354 -26.655  13.665  1.00  0.00           C  
ATOM    441  OE1 GLU A  32      70.349 -27.408  13.647  1.00  0.00           O  
ATOM    442  OE2 GLU A  32      68.214 -27.033  14.008  1.00  0.00           O  
ATOM    443  H   GLU A  32      71.972 -24.327  12.496  1.00  0.00           H  
ATOM    444  HA  GLU A  32      70.070 -22.448  13.395  1.00  0.00           H  
ATOM    445  HB2 GLU A  32      70.976 -24.971  14.791  1.00  0.00           H  
ATOM    446  HB3 GLU A  32      69.467 -24.110  15.064  1.00  0.00           H  
ATOM    447  HG2 GLU A  32      68.566 -24.786  13.037  1.00  0.00           H  
ATOM    448  HG3 GLU A  32      70.143 -25.180  12.355  1.00  0.00           H  
ATOM    449  N   LEU A  33      71.208 -21.083  15.109  1.00  0.00           N  
ATOM    450  CA  LEU A  33      71.814 -20.269  16.156  1.00  0.00           C  
ATOM    451  C   LEU A  33      71.006 -20.354  17.448  1.00  0.00           C  
ATOM    452  O   LEU A  33      71.522 -20.760  18.488  1.00  0.00           O  
ATOM    453  CB  LEU A  33      71.917 -18.812  15.702  1.00  0.00           C  
ATOM    454  CG  LEU A  33      72.778 -18.554  14.465  1.00  0.00           C  
ATOM    455  CD1 LEU A  33      72.630 -17.113  14.002  1.00  0.00           C  
ATOM    456  CD2 LEU A  33      74.237 -18.876  14.754  1.00  0.00           C  
ATOM    457  H   LEU A  33      70.527 -20.685  14.529  1.00  0.00           H  
ATOM    458  HA  LEU A  33      72.807 -20.651  16.340  1.00  0.00           H  
ATOM    459  HB2 LEU A  33      70.919 -18.461  15.488  1.00  0.00           H  
ATOM    460  HB3 LEU A  33      72.331 -18.239  16.520  1.00  0.00           H  
ATOM    461  HG  LEU A  33      72.446 -19.198  13.662  1.00  0.00           H  
ATOM    462 HD11 LEU A  33      72.381 -17.096  12.951  1.00  0.00           H  
ATOM    463 HD12 LEU A  33      73.561 -16.587  14.160  1.00  0.00           H  
ATOM    464 HD13 LEU A  33      71.845 -16.633  14.567  1.00  0.00           H  
ATOM    465 HD21 LEU A  33      74.619 -18.184  15.490  1.00  0.00           H  
ATOM    466 HD22 LEU A  33      74.812 -18.788  13.844  1.00  0.00           H  
ATOM    467 HD23 LEU A  33      74.315 -19.885  15.132  1.00  0.00           H  
ATOM    468  N   GLY A  34      69.735 -19.970  17.372  1.00  0.00           N  
ATOM    469  CA  GLY A  34      68.876 -20.013  18.541  1.00  0.00           C  
ATOM    470  C   GLY A  34      67.435 -20.324  18.190  1.00  0.00           C  
ATOM    471  O   GLY A  34      66.877 -19.744  17.259  1.00  0.00           O  
ATOM    472  H   GLY A  34      69.378 -19.655  16.515  1.00  0.00           H  
ATOM    473  HA2 GLY A  34      69.244 -20.772  19.216  1.00  0.00           H  
ATOM    474  HA3 GLY A  34      68.915 -19.054  19.036  1.00  0.00           H  
ATOM    475  N   SER A  35      66.833 -21.245  18.935  1.00  0.00           N  
ATOM    476  CA  SER A  35      65.448 -21.637  18.694  1.00  0.00           C  
ATOM    477  C   SER A  35      64.486 -20.730  19.456  1.00  0.00           C  
ATOM    478  O   SER A  35      64.819 -20.206  20.519  1.00  0.00           O  
ATOM    479  CB  SER A  35      65.229 -23.093  19.107  1.00  0.00           C  
ATOM    480  OG  SER A  35      65.672 -23.319  20.435  1.00  0.00           O  
ATOM    481  H   SER A  35      67.330 -21.672  19.663  1.00  0.00           H  
ATOM    482  HA  SER A  35      65.255 -21.538  17.636  1.00  0.00           H  
ATOM    483  HB2 SER A  35      64.177 -23.328  19.046  1.00  0.00           H  
ATOM    484  HB3 SER A  35      65.782 -23.740  18.441  1.00  0.00           H  
ATOM    485  HG  SER A  35      65.166 -24.038  20.823  1.00  0.00           H  
ATOM    486  N   GLY A  36      63.291 -20.548  18.904  1.00  0.00           N  
ATOM    487  CA  GLY A  36      62.298 -19.704  19.544  1.00  0.00           C  
ATOM    488  C   GLY A  36      60.900 -19.950  19.013  1.00  0.00           C  
ATOM    489  O   GLY A  36      60.723 -20.617  17.994  1.00  0.00           O  
ATOM    490  H   GLY A  36      63.081 -20.991  18.055  1.00  0.00           H  
ATOM    491  HA2 GLY A  36      62.308 -19.898  20.607  1.00  0.00           H  
ATOM    492  HA3 GLY A  36      62.559 -18.670  19.375  1.00  0.00           H  
ATOM    493  N   VAL A  37      59.903 -19.411  19.707  1.00  0.00           N  
ATOM    494  CA  VAL A  37      58.512 -19.575  19.300  1.00  0.00           C  
ATOM    495  C   VAL A  37      57.973 -18.301  18.660  1.00  0.00           C  
ATOM    496  O   VAL A  37      57.931 -17.246  19.292  1.00  0.00           O  
ATOM    497  CB  VAL A  37      57.618 -19.953  20.496  1.00  0.00           C  
ATOM    498  CG1 VAL A  37      56.181 -20.162  20.044  1.00  0.00           C  
ATOM    499  CG2 VAL A  37      58.154 -21.198  21.188  1.00  0.00           C  
ATOM    500  H   VAL A  37      60.106 -18.889  20.511  1.00  0.00           H  
ATOM    501  HA  VAL A  37      58.468 -20.377  18.577  1.00  0.00           H  
ATOM    502  HB  VAL A  37      57.634 -19.138  21.204  1.00  0.00           H  
ATOM    503 HG11 VAL A  37      55.878 -19.336  19.417  1.00  0.00           H  
ATOM    504 HG12 VAL A  37      56.109 -21.084  19.486  1.00  0.00           H  
ATOM    505 HG13 VAL A  37      55.535 -20.212  20.908  1.00  0.00           H  
ATOM    506 HG21 VAL A  37      59.151 -21.407  20.833  1.00  0.00           H  
ATOM    507 HG22 VAL A  37      58.179 -21.032  22.255  1.00  0.00           H  
ATOM    508 HG23 VAL A  37      57.510 -22.038  20.969  1.00  0.00           H  
ATOM    509  N   MET A  38      57.559 -18.408  17.400  1.00  0.00           N  
ATOM    510  CA  MET A  38      57.020 -17.264  16.674  1.00  0.00           C  
ATOM    511  C   MET A  38      55.511 -17.158  16.870  1.00  0.00           C  
ATOM    512  O   MET A  38      54.797 -18.159  16.811  1.00  0.00           O  
ATOM    513  CB  MET A  38      57.347 -17.378  15.185  1.00  0.00           C  
ATOM    514  CG  MET A  38      56.876 -16.187  14.366  1.00  0.00           C  
ATOM    515  SD  MET A  38      57.977 -14.767  14.509  1.00  0.00           S  
ATOM    516  CE  MET A  38      59.417 -15.364  13.628  1.00  0.00           C  
ATOM    517  H   MET A  38      57.617 -19.276  16.950  1.00  0.00           H  
ATOM    518  HA  MET A  38      57.485 -16.373  17.069  1.00  0.00           H  
ATOM    519  HB2 MET A  38      58.417 -17.467  15.069  1.00  0.00           H  
ATOM    520  HB3 MET A  38      56.876 -18.266  14.792  1.00  0.00           H  
ATOM    521  HG2 MET A  38      56.823 -16.479  13.328  1.00  0.00           H  
ATOM    522  HG3 MET A  38      55.893 -15.900  14.707  1.00  0.00           H  
ATOM    523  HE1 MET A  38      60.285 -15.294  14.268  1.00  0.00           H  
ATOM    524  HE2 MET A  38      59.263 -16.394  13.343  1.00  0.00           H  
ATOM    525  HE3 MET A  38      59.572 -14.764  12.743  1.00  0.00           H  
ATOM    526  N   GLU A  39      55.032 -15.940  17.102  1.00  0.00           N  
ATOM    527  CA  GLU A  39      53.607 -15.706  17.307  1.00  0.00           C  
ATOM    528  C   GLU A  39      53.097 -14.611  16.375  1.00  0.00           C  
ATOM    529  O   GLU A  39      53.806 -13.644  16.087  1.00  0.00           O  
ATOM    530  CB  GLU A  39      53.336 -15.320  18.762  1.00  0.00           C  
ATOM    531  CG  GLU A  39      51.878 -14.993  19.043  1.00  0.00           C  
ATOM    532  CD  GLU A  39      50.937 -16.101  18.611  1.00  0.00           C  
ATOM    533  OE1 GLU A  39      51.401 -17.253  18.475  1.00  0.00           O  
ATOM    534  OE2 GLU A  39      49.738 -15.817  18.410  1.00  0.00           O  
ATOM    535  H   GLU A  39      55.651 -15.181  17.138  1.00  0.00           H  
ATOM    536  HA  GLU A  39      53.085 -16.624  17.083  1.00  0.00           H  
ATOM    537  HB2 GLU A  39      53.628 -16.141  19.400  1.00  0.00           H  
ATOM    538  HB3 GLU A  39      53.931 -14.454  19.009  1.00  0.00           H  
ATOM    539  HG2 GLU A  39      51.757 -14.831  20.103  1.00  0.00           H  
ATOM    540  HG3 GLU A  39      51.617 -14.090  18.509  1.00  0.00           H  
ATOM    541  N   LEU A  40      51.864 -14.768  15.907  1.00  0.00           N  
ATOM    542  CA  LEU A  40      51.257 -13.792  15.007  1.00  0.00           C  
ATOM    543  C   LEU A  40      49.912 -13.318  15.546  1.00  0.00           C  
ATOM    544  O   LEU A  40      49.011 -14.121  15.794  1.00  0.00           O  
ATOM    545  CB  LEU A  40      51.076 -14.398  13.614  1.00  0.00           C  
ATOM    546  CG  LEU A  40      52.262 -14.253  12.660  1.00  0.00           C  
ATOM    547  CD1 LEU A  40      53.316 -15.311  12.952  1.00  0.00           C  
ATOM    548  CD2 LEU A  40      51.798 -14.345  11.214  1.00  0.00           C  
ATOM    549  H   LEU A  40      51.348 -15.557  16.172  1.00  0.00           H  
ATOM    550  HA  LEU A  40      51.923 -12.945  14.938  1.00  0.00           H  
ATOM    551  HB2 LEU A  40      50.878 -15.452  13.735  1.00  0.00           H  
ATOM    552  HB3 LEU A  40      50.221 -13.923  13.155  1.00  0.00           H  
ATOM    553  HG  LEU A  40      52.716 -13.283  12.805  1.00  0.00           H  
ATOM    554 HD11 LEU A  40      54.267 -14.991  12.555  1.00  0.00           H  
ATOM    555 HD12 LEU A  40      53.027 -16.242  12.488  1.00  0.00           H  
ATOM    556 HD13 LEU A  40      53.398 -15.451  14.019  1.00  0.00           H  
ATOM    557 HD21 LEU A  40      50.896 -14.937  11.162  1.00  0.00           H  
ATOM    558 HD22 LEU A  40      52.569 -14.809  10.617  1.00  0.00           H  
ATOM    559 HD23 LEU A  40      51.600 -13.352  10.835  1.00  0.00           H  
ATOM    560  N   THR A  41      49.780 -12.007  15.724  1.00  0.00           N  
ATOM    561  CA  THR A  41      48.544 -11.425  16.232  1.00  0.00           C  
ATOM    562  C   THR A  41      48.022 -10.340  15.297  1.00  0.00           C  
ATOM    563  O   THR A  41      48.798  -9.569  14.733  1.00  0.00           O  
ATOM    564  CB  THR A  41      48.743 -10.824  17.636  1.00  0.00           C  
ATOM    565  OG1 THR A  41      49.701  -9.762  17.584  1.00  0.00           O  
ATOM    566  CG2 THR A  41      49.210 -11.887  18.619  1.00  0.00           C  
ATOM    567  H   THR A  41      50.533 -11.419  15.508  1.00  0.00           H  
ATOM    568  HA  THR A  41      47.808 -12.213  16.301  1.00  0.00           H  
ATOM    569  HB  THR A  41      47.796 -10.429  17.979  1.00  0.00           H  
ATOM    570  HG1 THR A  41      49.716  -9.302  18.427  1.00  0.00           H  
ATOM    571 HG21 THR A  41      50.247 -12.118  18.432  1.00  0.00           H  
ATOM    572 HG22 THR A  41      48.614 -12.779  18.494  1.00  0.00           H  
ATOM    573 HG23 THR A  41      49.099 -11.519  19.627  1.00  0.00           H  
ATOM    574  N   GLN A  42      46.703 -10.287  15.137  1.00  0.00           N  
ATOM    575  CA  GLN A  42      46.079  -9.296  14.269  1.00  0.00           C  
ATOM    576  C   GLN A  42      46.807  -7.959  14.357  1.00  0.00           C  
ATOM    577  O   GLN A  42      47.019  -7.288  13.347  1.00  0.00           O  
ATOM    578  CB  GLN A  42      44.607  -9.114  14.644  1.00  0.00           C  
ATOM    579  CG  GLN A  42      43.725 -10.280  14.227  1.00  0.00           C  
ATOM    580  CD  GLN A  42      43.460 -10.306  12.735  1.00  0.00           C  
ATOM    581  OE1 GLN A  42      44.203  -9.717  11.950  1.00  0.00           O  
ATOM    582  NE2 GLN A  42      42.395 -10.992  12.334  1.00  0.00           N  
ATOM    583  H   GLN A  42      46.139 -10.930  15.614  1.00  0.00           H  
ATOM    584  HA  GLN A  42      46.140  -9.658  13.255  1.00  0.00           H  
ATOM    585  HB2 GLN A  42      44.532  -8.999  15.715  1.00  0.00           H  
ATOM    586  HB3 GLN A  42      44.234  -8.220  14.167  1.00  0.00           H  
ATOM    587  HG2 GLN A  42      44.212 -11.202  14.506  1.00  0.00           H  
ATOM    588  HG3 GLN A  42      42.780 -10.202  14.744  1.00  0.00           H  
ATOM    589 HE21 GLN A  42      41.848 -11.435  13.016  1.00  0.00           H  
ATOM    590 HE22 GLN A  42      42.200 -11.025  11.375  1.00  0.00           H  
ATOM    591  N   SER A  43      47.187  -7.577  15.573  1.00  0.00           N  
ATOM    592  CA  SER A  43      47.889  -6.318  15.794  1.00  0.00           C  
ATOM    593  C   SER A  43      49.192  -6.275  15.002  1.00  0.00           C  
ATOM    594  O   SER A  43      49.289  -5.594  13.982  1.00  0.00           O  
ATOM    595  CB  SER A  43      48.177  -6.124  17.284  1.00  0.00           C  
ATOM    596  OG  SER A  43      47.069  -5.539  17.946  1.00  0.00           O  
ATOM    597  H   SER A  43      46.989  -8.155  16.339  1.00  0.00           H  
ATOM    598  HA  SER A  43      47.248  -5.517  15.453  1.00  0.00           H  
ATOM    599  HB2 SER A  43      48.386  -7.083  17.735  1.00  0.00           H  
ATOM    600  HB3 SER A  43      49.035  -5.477  17.400  1.00  0.00           H  
ATOM    601  HG  SER A  43      47.136  -5.706  18.889  1.00  0.00           H  
ATOM    602  N   GLU A  44      50.192  -7.008  15.481  1.00  0.00           N  
ATOM    603  CA  GLU A  44      51.490  -7.054  14.819  1.00  0.00           C  
ATOM    604  C   GLU A  44      52.156  -8.413  15.019  1.00  0.00           C  
ATOM    605  O   GLU A  44      51.598  -9.301  15.665  1.00  0.00           O  
ATOM    606  CB  GLU A  44      52.399  -5.945  15.352  1.00  0.00           C  
ATOM    607  CG  GLU A  44      52.726  -6.084  16.830  1.00  0.00           C  
ATOM    608  CD  GLU A  44      53.090  -4.762  17.475  1.00  0.00           C  
ATOM    609  OE1 GLU A  44      53.732  -3.929  16.800  1.00  0.00           O  
ATOM    610  OE2 GLU A  44      52.732  -4.557  18.654  1.00  0.00           O  
ATOM    611  H   GLU A  44      50.054  -7.530  16.299  1.00  0.00           H  
ATOM    612  HA  GLU A  44      51.330  -6.898  13.763  1.00  0.00           H  
ATOM    613  HB2 GLU A  44      53.326  -5.957  14.797  1.00  0.00           H  
ATOM    614  HB3 GLU A  44      51.912  -4.994  15.202  1.00  0.00           H  
ATOM    615  HG2 GLU A  44      51.865  -6.491  17.339  1.00  0.00           H  
ATOM    616  HG3 GLU A  44      53.560  -6.763  16.939  1.00  0.00           H  
ATOM    617  N   LEU A  45      53.351  -8.567  14.460  1.00  0.00           N  
ATOM    618  CA  LEU A  45      54.094  -9.818  14.576  1.00  0.00           C  
ATOM    619  C   LEU A  45      54.906  -9.851  15.866  1.00  0.00           C  
ATOM    620  O   LEU A  45      55.706  -8.954  16.131  1.00  0.00           O  
ATOM    621  CB  LEU A  45      55.020  -9.997  13.371  1.00  0.00           C  
ATOM    622  CG  LEU A  45      55.253 -11.436  12.912  1.00  0.00           C  
ATOM    623  CD1 LEU A  45      56.086 -11.464  11.640  1.00  0.00           C  
ATOM    624  CD2 LEU A  45      55.927 -12.244  14.011  1.00  0.00           C  
ATOM    625  H   LEU A  45      53.744  -7.824  13.958  1.00  0.00           H  
ATOM    626  HA  LEU A  45      53.379 -10.627  14.594  1.00  0.00           H  
ATOM    627  HB2 LEU A  45      54.595  -9.451  12.544  1.00  0.00           H  
ATOM    628  HB3 LEU A  45      55.980  -9.571  13.627  1.00  0.00           H  
ATOM    629  HG  LEU A  45      54.299 -11.897  12.696  1.00  0.00           H  
ATOM    630 HD11 LEU A  45      55.805 -12.317  11.044  1.00  0.00           H  
ATOM    631 HD12 LEU A  45      57.132 -11.532  11.897  1.00  0.00           H  
ATOM    632 HD13 LEU A  45      55.913 -10.557  11.078  1.00  0.00           H  
ATOM    633 HD21 LEU A  45      56.934 -11.881  14.159  1.00  0.00           H  
ATOM    634 HD22 LEU A  45      55.958 -13.286  13.725  1.00  0.00           H  
ATOM    635 HD23 LEU A  45      55.369 -12.141  14.930  1.00  0.00           H  
ATOM    636  N   VAL A  46      54.696 -10.893  16.665  1.00  0.00           N  
ATOM    637  CA  VAL A  46      55.412 -11.045  17.926  1.00  0.00           C  
ATOM    638  C   VAL A  46      56.253 -12.316  17.931  1.00  0.00           C  
ATOM    639  O   VAL A  46      55.826 -13.359  17.433  1.00  0.00           O  
ATOM    640  CB  VAL A  46      54.441 -11.081  19.122  1.00  0.00           C  
ATOM    641  CG1 VAL A  46      55.210 -11.149  20.432  1.00  0.00           C  
ATOM    642  CG2 VAL A  46      53.521  -9.870  19.095  1.00  0.00           C  
ATOM    643  H   VAL A  46      54.046 -11.576  16.399  1.00  0.00           H  
ATOM    644  HA  VAL A  46      56.065 -10.192  18.045  1.00  0.00           H  
ATOM    645  HB  VAL A  46      53.834 -11.970  19.039  1.00  0.00           H  
ATOM    646 HG11 VAL A  46      56.215 -11.496  20.242  1.00  0.00           H  
ATOM    647 HG12 VAL A  46      55.245 -10.167  20.880  1.00  0.00           H  
ATOM    648 HG13 VAL A  46      54.714 -11.834  21.105  1.00  0.00           H  
ATOM    649 HG21 VAL A  46      53.807  -9.217  18.285  1.00  0.00           H  
ATOM    650 HG22 VAL A  46      52.501 -10.196  18.953  1.00  0.00           H  
ATOM    651 HG23 VAL A  46      53.600  -9.337  20.032  1.00  0.00           H  
ATOM    652  N   LEU A  47      57.452 -12.224  18.496  1.00  0.00           N  
ATOM    653  CA  LEU A  47      58.355 -13.367  18.566  1.00  0.00           C  
ATOM    654  C   LEU A  47      58.732 -13.675  20.013  1.00  0.00           C  
ATOM    655  O   LEU A  47      59.302 -12.834  20.709  1.00  0.00           O  
ATOM    656  CB  LEU A  47      59.617 -13.097  17.745  1.00  0.00           C  
ATOM    657  CG  LEU A  47      60.372 -14.331  17.249  1.00  0.00           C  
ATOM    658  CD1 LEU A  47      61.809 -13.973  16.902  1.00  0.00           C  
ATOM    659  CD2 LEU A  47      60.334 -15.435  18.296  1.00  0.00           C  
ATOM    660  H   LEU A  47      57.738 -11.367  18.876  1.00  0.00           H  
ATOM    661  HA  LEU A  47      57.841 -14.221  18.151  1.00  0.00           H  
ATOM    662  HB2 LEU A  47      59.331 -12.516  16.882  1.00  0.00           H  
ATOM    663  HB3 LEU A  47      60.292 -12.517  18.359  1.00  0.00           H  
ATOM    664  HG  LEU A  47      59.895 -14.702  16.353  1.00  0.00           H  
ATOM    665 HD11 LEU A  47      61.820 -13.327  16.038  1.00  0.00           H  
ATOM    666 HD12 LEU A  47      62.361 -14.875  16.684  1.00  0.00           H  
ATOM    667 HD13 LEU A  47      62.266 -13.464  17.739  1.00  0.00           H  
ATOM    668 HD21 LEU A  47      60.746 -15.067  19.224  1.00  0.00           H  
ATOM    669 HD22 LEU A  47      60.916 -16.277  17.951  1.00  0.00           H  
ATOM    670 HD23 LEU A  47      59.310 -15.745  18.455  1.00  0.00           H  
ATOM    671  N   HIS A  48      58.412 -14.886  20.457  1.00  0.00           N  
ATOM    672  CA  HIS A  48      58.720 -15.306  21.820  1.00  0.00           C  
ATOM    673  C   HIS A  48      60.137 -15.865  21.908  1.00  0.00           C  
ATOM    674  O   HIS A  48      60.471 -16.846  21.241  1.00  0.00           O  
ATOM    675  CB  HIS A  48      57.713 -16.356  22.292  1.00  0.00           C  
ATOM    676  CG  HIS A  48      56.315 -15.835  22.413  1.00  0.00           C  
ATOM    677  ND1 HIS A  48      55.923 -14.956  23.401  1.00  0.00           N  
ATOM    678  CD2 HIS A  48      55.214 -16.069  21.662  1.00  0.00           C  
ATOM    679  CE1 HIS A  48      54.641 -14.675  23.253  1.00  0.00           C  
ATOM    680  NE2 HIS A  48      54.187 -15.338  22.206  1.00  0.00           N  
ATOM    681  H   HIS A  48      57.959 -15.512  19.854  1.00  0.00           H  
ATOM    682  HA  HIS A  48      58.648 -14.439  22.458  1.00  0.00           H  
ATOM    683  HB2 HIS A  48      57.702 -17.175  21.587  1.00  0.00           H  
ATOM    684  HB3 HIS A  48      58.017 -16.726  23.261  1.00  0.00           H  
ATOM    685  HD1 HIS A  48      56.499 -14.593  24.106  1.00  0.00           H  
ATOM    686  HD2 HIS A  48      55.153 -16.714  20.796  1.00  0.00           H  
ATOM    687  HE1 HIS A  48      54.062 -14.016  23.883  1.00  0.00           H  
ATOM    688  HE2 HIS A  48      53.248 -15.376  21.925  1.00  0.00           H  
ATOM    689  N   LEU A  49      60.965 -15.237  22.735  1.00  0.00           N  
ATOM    690  CA  LEU A  49      62.347 -15.671  22.910  1.00  0.00           C  
ATOM    691  C   LEU A  49      62.674 -15.858  24.388  1.00  0.00           C  
ATOM    692  O   LEU A  49      61.825 -15.650  25.255  1.00  0.00           O  
ATOM    693  CB  LEU A  49      63.304 -14.654  22.288  1.00  0.00           C  
ATOM    694  CG  LEU A  49      63.064 -14.318  20.816  1.00  0.00           C  
ATOM    695  CD1 LEU A  49      63.916 -13.131  20.393  1.00  0.00           C  
ATOM    696  CD2 LEU A  49      63.357 -15.527  19.940  1.00  0.00           C  
ATOM    697  H   LEU A  49      60.641 -14.461  23.239  1.00  0.00           H  
ATOM    698  HA  LEU A  49      62.463 -16.618  22.405  1.00  0.00           H  
ATOM    699  HB2 LEU A  49      63.226 -13.738  22.853  1.00  0.00           H  
ATOM    700  HB3 LEU A  49      64.307 -15.046  22.380  1.00  0.00           H  
ATOM    701  HG  LEU A  49      62.026 -14.049  20.679  1.00  0.00           H  
ATOM    702 HD11 LEU A  49      64.501 -13.399  19.526  1.00  0.00           H  
ATOM    703 HD12 LEU A  49      64.576 -12.856  21.202  1.00  0.00           H  
ATOM    704 HD13 LEU A  49      63.275 -12.296  20.152  1.00  0.00           H  
ATOM    705 HD21 LEU A  49      64.378 -15.844  20.093  1.00  0.00           H  
ATOM    706 HD22 LEU A  49      63.215 -15.262  18.902  1.00  0.00           H  
ATOM    707 HD23 LEU A  49      62.685 -16.332  20.200  1.00  0.00           H  
ATOM    708  N   HIS A  50      63.913 -16.250  24.670  1.00  0.00           N  
ATOM    709  CA  HIS A  50      64.355 -16.462  26.043  1.00  0.00           C  
ATOM    710  C   HIS A  50      64.045 -15.243  26.908  1.00  0.00           C  
ATOM    711  O   HIS A  50      63.497 -14.252  26.427  1.00  0.00           O  
ATOM    712  CB  HIS A  50      65.854 -16.759  26.079  1.00  0.00           C  
ATOM    713  CG  HIS A  50      66.282 -17.804  25.094  1.00  0.00           C  
ATOM    714  ND1 HIS A  50      65.820 -19.102  25.128  1.00  0.00           N  
ATOM    715  CD2 HIS A  50      67.131 -17.734  24.043  1.00  0.00           C  
ATOM    716  CE1 HIS A  50      66.369 -19.788  24.141  1.00  0.00           C  
ATOM    717  NE2 HIS A  50      67.169 -18.981  23.468  1.00  0.00           N  
ATOM    718  H   HIS A  50      64.545 -16.398  23.935  1.00  0.00           H  
ATOM    719  HA  HIS A  50      63.819 -17.312  26.437  1.00  0.00           H  
ATOM    720  HB2 HIS A  50      66.400 -15.854  25.859  1.00  0.00           H  
ATOM    721  HB3 HIS A  50      66.123 -17.104  27.067  1.00  0.00           H  
ATOM    722  HD1 HIS A  50      65.186 -19.468  25.779  1.00  0.00           H  
ATOM    723  HD2 HIS A  50      67.679 -16.862  23.718  1.00  0.00           H  
ATOM    724  HE1 HIS A  50      66.195 -20.831  23.921  1.00  0.00           H  
ATOM    725  HE2 HIS A  50      67.765 -19.255  22.740  1.00  0.00           H  
ATOM    726  N   ARG A  51      64.398 -15.326  28.186  1.00  0.00           N  
ATOM    727  CA  ARG A  51      64.156 -14.231  29.118  1.00  0.00           C  
ATOM    728  C   ARG A  51      64.315 -12.881  28.424  1.00  0.00           C  
ATOM    729  O   ARG A  51      63.527 -11.961  28.648  1.00  0.00           O  
ATOM    730  CB  ARG A  51      65.117 -14.322  30.305  1.00  0.00           C  
ATOM    731  CG  ARG A  51      64.623 -15.229  31.421  1.00  0.00           C  
ATOM    732  CD  ARG A  51      64.902 -16.692  31.115  1.00  0.00           C  
ATOM    733  NE  ARG A  51      65.027 -17.491  32.330  1.00  0.00           N  
ATOM    734  CZ  ARG A  51      66.053 -17.399  33.169  1.00  0.00           C  
ATOM    735  NH1 ARG A  51      67.038 -16.546  32.925  1.00  0.00           N  
ATOM    736  NH2 ARG A  51      66.094 -18.161  34.254  1.00  0.00           N  
ATOM    737  H   ARG A  51      64.831 -16.143  28.512  1.00  0.00           H  
ATOM    738  HA  ARG A  51      63.142 -14.320  29.479  1.00  0.00           H  
ATOM    739  HB2 ARG A  51      66.066 -14.701  29.957  1.00  0.00           H  
ATOM    740  HB3 ARG A  51      65.261 -13.333  30.713  1.00  0.00           H  
ATOM    741  HG2 ARG A  51      65.125 -14.962  32.338  1.00  0.00           H  
ATOM    742  HG3 ARG A  51      63.558 -15.091  31.538  1.00  0.00           H  
ATOM    743  HD2 ARG A  51      64.091 -17.083  30.519  1.00  0.00           H  
ATOM    744  HD3 ARG A  51      65.823 -16.758  30.554  1.00  0.00           H  
ATOM    745  HE  ARG A  51      64.310 -18.128  32.530  1.00  0.00           H  
ATOM    746 HH11 ARG A  51      67.009 -15.970  32.108  1.00  0.00           H  
ATOM    747 HH12 ARG A  51      67.809 -16.478  33.558  1.00  0.00           H  
ATOM    748 HH21 ARG A  51      65.353 -18.804  34.442  1.00  0.00           H  
ATOM    749 HH22 ARG A  51      66.867 -18.091  34.885  1.00  0.00           H  
ATOM    750  N   ARG A  52      65.336 -12.771  27.581  1.00  0.00           N  
ATOM    751  CA  ARG A  52      65.598 -11.534  26.856  1.00  0.00           C  
ATOM    752  C   ARG A  52      64.305 -10.944  26.302  1.00  0.00           C  
ATOM    753  O   ARG A  52      63.460 -11.665  25.774  1.00  0.00           O  
ATOM    754  CB  ARG A  52      66.586 -11.786  25.716  1.00  0.00           C  
ATOM    755  CG  ARG A  52      67.167 -10.513  25.121  1.00  0.00           C  
ATOM    756  CD  ARG A  52      66.256  -9.931  24.052  1.00  0.00           C  
ATOM    757  NE  ARG A  52      66.931  -8.911  23.254  1.00  0.00           N  
ATOM    758  CZ  ARG A  52      66.397  -8.348  22.177  1.00  0.00           C  
ATOM    759  NH1 ARG A  52      65.186  -8.704  21.770  1.00  0.00           N  
ATOM    760  NH2 ARG A  52      67.073  -7.426  21.503  1.00  0.00           N  
ATOM    761  H   ARG A  52      65.928 -13.540  27.445  1.00  0.00           H  
ATOM    762  HA  ARG A  52      66.034 -10.830  27.549  1.00  0.00           H  
ATOM    763  HB2 ARG A  52      67.402 -12.389  26.087  1.00  0.00           H  
ATOM    764  HB3 ARG A  52      66.079 -12.326  24.930  1.00  0.00           H  
ATOM    765  HG2 ARG A  52      67.293  -9.784  25.908  1.00  0.00           H  
ATOM    766  HG3 ARG A  52      68.127 -10.739  24.681  1.00  0.00           H  
ATOM    767  HD2 ARG A  52      65.934 -10.729  23.399  1.00  0.00           H  
ATOM    768  HD3 ARG A  52      65.396  -9.489  24.533  1.00  0.00           H  
ATOM    769  HE  ARG A  52      67.827  -8.633  23.537  1.00  0.00           H  
ATOM    770 HH11 ARG A  52      64.673  -9.398  22.276  1.00  0.00           H  
ATOM    771 HH12 ARG A  52      64.785  -8.278  20.959  1.00  0.00           H  
ATOM    772 HH21 ARG A  52      67.986  -7.154  21.807  1.00  0.00           H  
ATOM    773 HH22 ARG A  52      66.670  -7.003  20.692  1.00  0.00           H  
ATOM    774  N   GLU A  53      64.159  -9.629  26.428  1.00  0.00           N  
ATOM    775  CA  GLU A  53      62.967  -8.942  25.941  1.00  0.00           C  
ATOM    776  C   GLU A  53      62.485  -9.556  24.629  1.00  0.00           C  
ATOM    777  O   GLU A  53      63.258 -10.177  23.901  1.00  0.00           O  
ATOM    778  CB  GLU A  53      63.255  -7.453  25.745  1.00  0.00           C  
ATOM    779  CG  GLU A  53      64.553  -7.175  25.007  1.00  0.00           C  
ATOM    780  CD  GLU A  53      64.882  -5.695  24.943  1.00  0.00           C  
ATOM    781  OE1 GLU A  53      65.060  -5.080  26.014  1.00  0.00           O  
ATOM    782  OE2 GLU A  53      64.962  -5.155  23.820  1.00  0.00           O  
ATOM    783  H   GLU A  53      64.869  -9.108  26.859  1.00  0.00           H  
ATOM    784  HA  GLU A  53      62.193  -9.055  26.684  1.00  0.00           H  
ATOM    785  HB2 GLU A  53      62.444  -7.013  25.183  1.00  0.00           H  
ATOM    786  HB3 GLU A  53      63.307  -6.979  26.714  1.00  0.00           H  
ATOM    787  HG2 GLU A  53      65.357  -7.685  25.516  1.00  0.00           H  
ATOM    788  HG3 GLU A  53      64.468  -7.554  23.999  1.00  0.00           H  
ATOM    789  N   ALA A  54      61.201  -9.377  24.338  1.00  0.00           N  
ATOM    790  CA  ALA A  54      60.615  -9.911  23.114  1.00  0.00           C  
ATOM    791  C   ALA A  54      60.718  -8.907  21.972  1.00  0.00           C  
ATOM    792  O   ALA A  54      60.917  -7.713  22.197  1.00  0.00           O  
ATOM    793  CB  ALA A  54      59.162 -10.296  23.350  1.00  0.00           C  
ATOM    794  H   ALA A  54      60.634  -8.874  24.959  1.00  0.00           H  
ATOM    795  HA  ALA A  54      61.159 -10.805  22.845  1.00  0.00           H  
ATOM    796  HB1 ALA A  54      58.579 -10.055  22.474  1.00  0.00           H  
ATOM    797  HB2 ALA A  54      59.098 -11.358  23.544  1.00  0.00           H  
ATOM    798  HB3 ALA A  54      58.778  -9.752  24.200  1.00  0.00           H  
ATOM    799  N   VAL A  55      60.586  -9.398  20.744  1.00  0.00           N  
ATOM    800  CA  VAL A  55      60.664  -8.543  19.565  1.00  0.00           C  
ATOM    801  C   VAL A  55      59.335  -8.511  18.819  1.00  0.00           C  
ATOM    802  O   VAL A  55      58.669  -9.537  18.674  1.00  0.00           O  
ATOM    803  CB  VAL A  55      61.769  -9.015  18.603  1.00  0.00           C  
ATOM    804  CG1 VAL A  55      61.838  -8.109  17.383  1.00  0.00           C  
ATOM    805  CG2 VAL A  55      63.112  -9.064  19.317  1.00  0.00           C  
ATOM    806  H   VAL A  55      60.429 -10.359  20.628  1.00  0.00           H  
ATOM    807  HA  VAL A  55      60.905  -7.542  19.894  1.00  0.00           H  
ATOM    808  HB  VAL A  55      61.526 -10.013  18.269  1.00  0.00           H  
ATOM    809 HG11 VAL A  55      61.069  -8.394  16.680  1.00  0.00           H  
ATOM    810 HG12 VAL A  55      61.688  -7.083  17.687  1.00  0.00           H  
ATOM    811 HG13 VAL A  55      62.807  -8.208  16.915  1.00  0.00           H  
ATOM    812 HG21 VAL A  55      63.476  -8.059  19.468  1.00  0.00           H  
ATOM    813 HG22 VAL A  55      62.993  -9.553  20.273  1.00  0.00           H  
ATOM    814 HG23 VAL A  55      63.820  -9.618  18.716  1.00  0.00           H  
ATOM    815  N   ARG A  56      58.955  -7.328  18.349  1.00  0.00           N  
ATOM    816  CA  ARG A  56      57.704  -7.163  17.618  1.00  0.00           C  
ATOM    817  C   ARG A  56      57.939  -6.440  16.294  1.00  0.00           C  
ATOM    818  O   ARG A  56      58.643  -5.432  16.243  1.00  0.00           O  
ATOM    819  CB  ARG A  56      56.694  -6.385  18.462  1.00  0.00           C  
ATOM    820  CG  ARG A  56      56.498  -6.957  19.857  1.00  0.00           C  
ATOM    821  CD  ARG A  56      57.496  -6.372  20.844  1.00  0.00           C  
ATOM    822  NE  ARG A  56      57.001  -5.145  21.463  1.00  0.00           N  
ATOM    823  CZ  ARG A  56      57.621  -4.521  22.458  1.00  0.00           C  
ATOM    824  NH1 ARG A  56      58.757  -5.004  22.943  1.00  0.00           N  
ATOM    825  NH2 ARG A  56      57.107  -3.409  22.968  1.00  0.00           N  
ATOM    826  H   ARG A  56      59.529  -6.548  18.497  1.00  0.00           H  
ATOM    827  HA  ARG A  56      57.308  -8.145  17.412  1.00  0.00           H  
ATOM    828  HB2 ARG A  56      57.034  -5.364  18.561  1.00  0.00           H  
ATOM    829  HB3 ARG A  56      55.740  -6.391  17.958  1.00  0.00           H  
ATOM    830  HG2 ARG A  56      55.498  -6.725  20.194  1.00  0.00           H  
ATOM    831  HG3 ARG A  56      56.628  -8.028  19.818  1.00  0.00           H  
ATOM    832  HD2 ARG A  56      57.687  -7.101  21.618  1.00  0.00           H  
ATOM    833  HD3 ARG A  56      58.415  -6.154  20.320  1.00  0.00           H  
ATOM    834  HE  ARG A  56      56.163  -4.770  21.120  1.00  0.00           H  
ATOM    835 HH11 ARG A  56      59.146  -5.841  22.560  1.00  0.00           H  
ATOM    836 HH12 ARG A  56      59.223  -4.531  23.691  1.00  0.00           H  
ATOM    837 HH21 ARG A  56      56.251  -3.041  22.604  1.00  0.00           H  
ATOM    838 HH22 ARG A  56      57.575  -2.940  23.716  1.00  0.00           H  
ATOM    839  N   TRP A  57      57.346  -6.964  15.228  1.00  0.00           N  
ATOM    840  CA  TRP A  57      57.493  -6.369  13.903  1.00  0.00           C  
ATOM    841  C   TRP A  57      56.130  -6.071  13.288  1.00  0.00           C  
ATOM    842  O   TRP A  57      55.339  -6.972  13.008  1.00  0.00           O  
ATOM    843  CB  TRP A  57      58.287  -7.302  12.988  1.00  0.00           C  
ATOM    844  CG  TRP A  57      59.702  -7.511  13.437  1.00  0.00           C  
ATOM    845  CD1 TRP A  57      60.720  -6.603  13.388  1.00  0.00           C  
ATOM    846  CD2 TRP A  57      60.254  -8.707  13.999  1.00  0.00           C  
ATOM    847  NE1 TRP A  57      61.872  -7.161  13.886  1.00  0.00           N  
ATOM    848  CE2 TRP A  57      61.612  -8.451  14.269  1.00  0.00           C  
ATOM    849  CE3 TRP A  57      59.733  -9.966  14.305  1.00  0.00           C  
ATOM    850  CZ2 TRP A  57      62.454  -9.409  14.828  1.00  0.00           C  
ATOM    851  CZ3 TRP A  57      60.569 -10.917  14.859  1.00  0.00           C  
ATOM    852  CH2 TRP A  57      61.917 -10.634  15.116  1.00  0.00           C  
ATOM    853  H   TRP A  57      56.798  -7.770  15.332  1.00  0.00           H  
ATOM    854  HA  TRP A  57      58.035  -5.442  14.016  1.00  0.00           H  
ATOM    855  HB2 TRP A  57      57.801  -8.266  12.956  1.00  0.00           H  
ATOM    856  HB3 TRP A  57      58.310  -6.882  11.992  1.00  0.00           H  
ATOM    857  HD1 TRP A  57      60.620  -5.598  13.008  1.00  0.00           H  
ATOM    858  HE1 TRP A  57      62.739  -6.709  13.958  1.00  0.00           H  
ATOM    859  HE3 TRP A  57      58.696 -10.204  14.114  1.00  0.00           H  
ATOM    860  HZ2 TRP A  57      63.495  -9.206  15.033  1.00  0.00           H  
ATOM    861  HZ3 TRP A  57      60.184 -11.897  15.101  1.00  0.00           H  
ATOM    862  HH2 TRP A  57      62.533 -11.407  15.549  1.00  0.00           H  
ATOM    863  N   PRO A  58      55.847  -4.778  13.071  1.00  0.00           N  
ATOM    864  CA  PRO A  58      54.580  -4.332  12.485  1.00  0.00           C  
ATOM    865  C   PRO A  58      54.458  -4.707  11.012  1.00  0.00           C  
ATOM    866  O   PRO A  58      55.373  -4.466  10.223  1.00  0.00           O  
ATOM    867  CB  PRO A  58      54.630  -2.811  12.648  1.00  0.00           C  
ATOM    868  CG  PRO A  58      56.082  -2.483  12.704  1.00  0.00           C  
ATOM    869  CD  PRO A  58      56.744  -3.652  13.381  1.00  0.00           C  
ATOM    870  HA  PRO A  58      53.732  -4.726  13.027  1.00  0.00           H  
ATOM    871  HB2 PRO A  58      54.151  -2.340  11.801  1.00  0.00           H  
ATOM    872  HB3 PRO A  58      54.125  -2.526  13.559  1.00  0.00           H  
ATOM    873  HG2 PRO A  58      56.470  -2.360  11.704  1.00  0.00           H  
ATOM    874  HG3 PRO A  58      56.233  -1.583  13.281  1.00  0.00           H  
ATOM    875  HD2 PRO A  58      57.728  -3.818  12.969  1.00  0.00           H  
ATOM    876  HD3 PRO A  58      56.801  -3.487  14.447  1.00  0.00           H  
ATOM    877  N   TYR A  59      53.326  -5.296  10.648  1.00  0.00           N  
ATOM    878  CA  TYR A  59      53.086  -5.706   9.269  1.00  0.00           C  
ATOM    879  C   TYR A  59      53.145  -4.508   8.327  1.00  0.00           C  
ATOM    880  O   TYR A  59      53.794  -4.556   7.281  1.00  0.00           O  
ATOM    881  CB  TYR A  59      51.727  -6.397   9.149  1.00  0.00           C  
ATOM    882  CG  TYR A  59      51.515  -7.495  10.167  1.00  0.00           C  
ATOM    883  CD1 TYR A  59      52.491  -8.456  10.395  1.00  0.00           C  
ATOM    884  CD2 TYR A  59      50.336  -7.572  10.899  1.00  0.00           C  
ATOM    885  CE1 TYR A  59      52.301  -9.461  11.324  1.00  0.00           C  
ATOM    886  CE2 TYR A  59      50.138  -8.573  11.830  1.00  0.00           C  
ATOM    887  CZ  TYR A  59      51.123  -9.516  12.039  1.00  0.00           C  
ATOM    888  OH  TYR A  59      50.930 -10.515  12.964  1.00  0.00           O  
ATOM    889  H   TYR A  59      52.634  -5.462  11.322  1.00  0.00           H  
ATOM    890  HA  TYR A  59      53.860  -6.406   8.991  1.00  0.00           H  
ATOM    891  HB2 TYR A  59      50.945  -5.666   9.284  1.00  0.00           H  
ATOM    892  HB3 TYR A  59      51.639  -6.835   8.165  1.00  0.00           H  
ATOM    893  HD1 TYR A  59      53.413  -8.411   9.833  1.00  0.00           H  
ATOM    894  HD2 TYR A  59      49.566  -6.832  10.733  1.00  0.00           H  
ATOM    895  HE1 TYR A  59      53.073 -10.200  11.487  1.00  0.00           H  
ATOM    896  HE2 TYR A  59      49.215  -8.615  12.390  1.00  0.00           H  
ATOM    897  HH  TYR A  59      51.305 -10.248  13.807  1.00  0.00           H  
ATOM    898  N   LEU A  60      52.462  -3.432   8.705  1.00  0.00           N  
ATOM    899  CA  LEU A  60      52.436  -2.218   7.895  1.00  0.00           C  
ATOM    900  C   LEU A  60      53.832  -1.870   7.390  1.00  0.00           C  
ATOM    901  O   LEU A  60      53.989  -1.321   6.299  1.00  0.00           O  
ATOM    902  CB  LEU A  60      51.869  -1.053   8.707  1.00  0.00           C  
ATOM    903  CG  LEU A  60      52.744  -0.545   9.853  1.00  0.00           C  
ATOM    904  CD1 LEU A  60      53.694   0.535   9.361  1.00  0.00           C  
ATOM    905  CD2 LEU A  60      51.881  -0.019  10.991  1.00  0.00           C  
ATOM    906  H   LEU A  60      51.964  -3.454   9.548  1.00  0.00           H  
ATOM    907  HA  LEU A  60      51.794  -2.402   7.046  1.00  0.00           H  
ATOM    908  HB2 LEU A  60      51.701  -0.230   8.030  1.00  0.00           H  
ATOM    909  HB3 LEU A  60      50.925  -1.371   9.126  1.00  0.00           H  
ATOM    910  HG  LEU A  60      53.340  -1.364  10.234  1.00  0.00           H  
ATOM    911 HD11 LEU A  60      54.175   0.205   8.451  1.00  0.00           H  
ATOM    912 HD12 LEU A  60      54.445   0.726  10.113  1.00  0.00           H  
ATOM    913 HD13 LEU A  60      53.140   1.441   9.166  1.00  0.00           H  
ATOM    914 HD21 LEU A  60      51.654  -0.825  11.672  1.00  0.00           H  
ATOM    915 HD22 LEU A  60      50.963   0.382  10.589  1.00  0.00           H  
ATOM    916 HD23 LEU A  60      52.415   0.758  11.517  1.00  0.00           H  
ATOM    917  N   CYS A  61      54.842  -2.196   8.189  1.00  0.00           N  
ATOM    918  CA  CYS A  61      56.226  -1.918   7.822  1.00  0.00           C  
ATOM    919  C   CYS A  61      56.761  -2.984   6.870  1.00  0.00           C  
ATOM    920  O   CYS A  61      57.563  -2.692   5.983  1.00  0.00           O  
ATOM    921  CB  CYS A  61      57.104  -1.850   9.073  1.00  0.00           C  
ATOM    922  SG  CYS A  61      56.840  -0.371  10.079  1.00  0.00           S  
ATOM    923  H   CYS A  61      54.654  -2.632   9.046  1.00  0.00           H  
ATOM    924  HA  CYS A  61      56.251  -0.962   7.323  1.00  0.00           H  
ATOM    925  HB2 CYS A  61      56.900  -2.709   9.695  1.00  0.00           H  
ATOM    926  HB3 CYS A  61      58.142  -1.866   8.778  1.00  0.00           H  
ATOM    927  HG  CYS A  61      55.773  -0.577  10.837  1.00  0.00           H  
ATOM    928  N   LEU A  62      56.311  -4.219   7.061  1.00  0.00           N  
ATOM    929  CA  LEU A  62      56.745  -5.329   6.220  1.00  0.00           C  
ATOM    930  C   LEU A  62      56.486  -5.031   4.747  1.00  0.00           C  
ATOM    931  O   LEU A  62      55.405  -5.309   4.228  1.00  0.00           O  
ATOM    932  CB  LEU A  62      56.022  -6.615   6.626  1.00  0.00           C  
ATOM    933  CG  LEU A  62      56.329  -7.143   8.028  1.00  0.00           C  
ATOM    934  CD1 LEU A  62      55.445  -8.337   8.353  1.00  0.00           C  
ATOM    935  CD2 LEU A  62      57.799  -7.516   8.148  1.00  0.00           C  
ATOM    936  H   LEU A  62      55.673  -4.390   7.784  1.00  0.00           H  
ATOM    937  HA  LEU A  62      57.806  -5.460   6.367  1.00  0.00           H  
ATOM    938  HB2 LEU A  62      54.961  -6.430   6.568  1.00  0.00           H  
ATOM    939  HB3 LEU A  62      56.292  -7.383   5.916  1.00  0.00           H  
ATOM    940  HG  LEU A  62      56.119  -6.367   8.752  1.00  0.00           H  
ATOM    941 HD11 LEU A  62      54.421  -8.107   8.102  1.00  0.00           H  
ATOM    942 HD12 LEU A  62      55.516  -8.560   9.408  1.00  0.00           H  
ATOM    943 HD13 LEU A  62      55.774  -9.193   7.783  1.00  0.00           H  
ATOM    944 HD21 LEU A  62      57.884  -8.539   8.481  1.00  0.00           H  
ATOM    945 HD22 LEU A  62      58.278  -6.863   8.864  1.00  0.00           H  
ATOM    946 HD23 LEU A  62      58.277  -7.408   7.185  1.00  0.00           H  
ATOM    947  N   ARG A  63      57.484  -4.464   4.079  1.00  0.00           N  
ATOM    948  CA  ARG A  63      57.365  -4.128   2.665  1.00  0.00           C  
ATOM    949  C   ARG A  63      57.345  -5.389   1.807  1.00  0.00           C  
ATOM    950  O   ARG A  63      56.540  -5.512   0.884  1.00  0.00           O  
ATOM    951  CB  ARG A  63      58.520  -3.222   2.234  1.00  0.00           C  
ATOM    952  CG  ARG A  63      58.238  -2.438   0.963  1.00  0.00           C  
ATOM    953  CD  ARG A  63      59.395  -1.517   0.608  1.00  0.00           C  
ATOM    954  NE  ARG A  63      59.160  -0.800  -0.641  1.00  0.00           N  
ATOM    955  CZ  ARG A  63      60.125  -0.227  -1.353  1.00  0.00           C  
ATOM    956  NH1 ARG A  63      61.383  -0.288  -0.940  1.00  0.00           N  
ATOM    957  NH2 ARG A  63      59.831   0.409  -2.480  1.00  0.00           N  
ATOM    958  H   ARG A  63      58.322  -4.265   4.548  1.00  0.00           H  
ATOM    959  HA  ARG A  63      56.433  -3.598   2.527  1.00  0.00           H  
ATOM    960  HB2 ARG A  63      58.726  -2.519   3.027  1.00  0.00           H  
ATOM    961  HB3 ARG A  63      59.396  -3.831   2.069  1.00  0.00           H  
ATOM    962  HG2 ARG A  63      58.083  -3.132   0.150  1.00  0.00           H  
ATOM    963  HG3 ARG A  63      57.348  -1.845   1.108  1.00  0.00           H  
ATOM    964  HD2 ARG A  63      59.525  -0.800   1.406  1.00  0.00           H  
ATOM    965  HD3 ARG A  63      60.292  -2.110   0.509  1.00  0.00           H  
ATOM    966  HE  ARG A  63      58.237  -0.741  -0.965  1.00  0.00           H  
ATOM    967 HH11 ARG A  63      61.607  -0.767  -0.092  1.00  0.00           H  
ATOM    968 HH12 ARG A  63      62.108   0.143  -1.478  1.00  0.00           H  
ATOM    969 HH21 ARG A  63      58.884   0.457  -2.795  1.00  0.00           H  
ATOM    970 HH22 ARG A  63      60.558   0.839  -3.015  1.00  0.00           H  
ATOM    971  N   ARG A  64      58.238  -6.324   2.117  1.00  0.00           N  
ATOM    972  CA  ARG A  64      58.325  -7.575   1.373  1.00  0.00           C  
ATOM    973  C   ARG A  64      58.563  -8.752   2.315  1.00  0.00           C  
ATOM    974  O   ARG A  64      59.112  -8.586   3.405  1.00  0.00           O  
ATOM    975  CB  ARG A  64      59.448  -7.499   0.337  1.00  0.00           C  
ATOM    976  CG  ARG A  64      60.809  -7.186   0.936  1.00  0.00           C  
ATOM    977  CD  ARG A  64      61.875  -7.059  -0.140  1.00  0.00           C  
ATOM    978  NE  ARG A  64      61.776  -5.792  -0.861  1.00  0.00           N  
ATOM    979  CZ  ARG A  64      62.362  -5.564  -2.031  1.00  0.00           C  
ATOM    980  NH1 ARG A  64      63.085  -6.513  -2.610  1.00  0.00           N  
ATOM    981  NH2 ARG A  64      62.225  -4.386  -2.625  1.00  0.00           N  
ATOM    982  H   ARG A  64      58.854  -6.168   2.863  1.00  0.00           H  
ATOM    983  HA  ARG A  64      57.385  -7.722   0.862  1.00  0.00           H  
ATOM    984  HB2 ARG A  64      59.513  -8.449  -0.175  1.00  0.00           H  
ATOM    985  HB3 ARG A  64      59.208  -6.729  -0.380  1.00  0.00           H  
ATOM    986  HG2 ARG A  64      60.747  -6.255   1.479  1.00  0.00           H  
ATOM    987  HG3 ARG A  64      61.086  -7.982   1.612  1.00  0.00           H  
ATOM    988  HD2 ARG A  64      62.847  -7.122   0.325  1.00  0.00           H  
ATOM    989  HD3 ARG A  64      61.758  -7.872  -0.842  1.00  0.00           H  
ATOM    990  HE  ARG A  64      61.246  -5.077  -0.451  1.00  0.00           H  
ATOM    991 HH11 ARG A  64      63.189  -7.402  -2.165  1.00  0.00           H  
ATOM    992 HH12 ARG A  64      63.524  -6.340  -3.492  1.00  0.00           H  
ATOM    993 HH21 ARG A  64      61.681  -3.668  -2.191  1.00  0.00           H  
ATOM    994 HH22 ARG A  64      62.666  -4.215  -3.506  1.00  0.00           H  
ATOM    995  N   TYR A  65      58.149  -9.938   1.885  1.00  0.00           N  
ATOM    996  CA  TYR A  65      58.316 -11.142   2.692  1.00  0.00           C  
ATOM    997  C   TYR A  65      58.193 -12.396   1.830  1.00  0.00           C  
ATOM    998  O   TYR A  65      57.367 -12.460   0.921  1.00  0.00           O  
ATOM    999  CB  TYR A  65      57.277 -11.179   3.813  1.00  0.00           C  
ATOM   1000  CG  TYR A  65      55.861 -10.951   3.335  1.00  0.00           C  
ATOM   1001  CD1 TYR A  65      55.402  -9.672   3.042  1.00  0.00           C  
ATOM   1002  CD2 TYR A  65      54.980 -12.014   3.177  1.00  0.00           C  
ATOM   1003  CE1 TYR A  65      54.109  -9.459   2.605  1.00  0.00           C  
ATOM   1004  CE2 TYR A  65      53.686 -11.811   2.739  1.00  0.00           C  
ATOM   1005  CZ  TYR A  65      53.255 -10.531   2.455  1.00  0.00           C  
ATOM   1006  OH  TYR A  65      51.966 -10.325   2.020  1.00  0.00           O  
ATOM   1007  H   TYR A  65      57.720 -10.007   1.007  1.00  0.00           H  
ATOM   1008  HA  TYR A  65      59.303 -11.115   3.128  1.00  0.00           H  
ATOM   1009  HB2 TYR A  65      57.312 -12.142   4.297  1.00  0.00           H  
ATOM   1010  HB3 TYR A  65      57.511 -10.409   4.536  1.00  0.00           H  
ATOM   1011  HD1 TYR A  65      56.075  -8.834   3.160  1.00  0.00           H  
ATOM   1012  HD2 TYR A  65      55.321 -13.014   3.401  1.00  0.00           H  
ATOM   1013  HE1 TYR A  65      53.772  -8.458   2.382  1.00  0.00           H  
ATOM   1014  HE2 TYR A  65      53.017 -12.650   2.622  1.00  0.00           H  
ATOM   1015  HH  TYR A  65      51.536 -11.171   1.881  1.00  0.00           H  
ATOM   1016  N   GLY A  66      59.025 -13.391   2.123  1.00  0.00           N  
ATOM   1017  CA  GLY A  66      58.994 -14.630   1.367  1.00  0.00           C  
ATOM   1018  C   GLY A  66      59.074 -15.854   2.258  1.00  0.00           C  
ATOM   1019  O   GLY A  66      59.232 -15.737   3.472  1.00  0.00           O  
ATOM   1020  H   GLY A  66      59.664 -13.283   2.858  1.00  0.00           H  
ATOM   1021  HA2 GLY A  66      58.077 -14.670   0.799  1.00  0.00           H  
ATOM   1022  HA3 GLY A  66      59.830 -14.641   0.683  1.00  0.00           H  
ATOM   1023  N   TYR A  67      58.963 -17.031   1.653  1.00  0.00           N  
ATOM   1024  CA  TYR A  67      59.020 -18.283   2.399  1.00  0.00           C  
ATOM   1025  C   TYR A  67      59.379 -19.448   1.483  1.00  0.00           C  
ATOM   1026  O   TYR A  67      58.838 -19.578   0.384  1.00  0.00           O  
ATOM   1027  CB  TYR A  67      57.679 -18.553   3.085  1.00  0.00           C  
ATOM   1028  CG  TYR A  67      56.624 -19.109   2.155  1.00  0.00           C  
ATOM   1029  CD1 TYR A  67      56.267 -18.433   0.995  1.00  0.00           C  
ATOM   1030  CD2 TYR A  67      55.986 -20.310   2.438  1.00  0.00           C  
ATOM   1031  CE1 TYR A  67      55.303 -18.938   0.143  1.00  0.00           C  
ATOM   1032  CE2 TYR A  67      55.023 -20.823   1.591  1.00  0.00           C  
ATOM   1033  CZ  TYR A  67      54.685 -20.133   0.445  1.00  0.00           C  
ATOM   1034  OH  TYR A  67      53.724 -20.640  -0.401  1.00  0.00           O  
ATOM   1035  H   TYR A  67      58.838 -17.061   0.681  1.00  0.00           H  
ATOM   1036  HA  TYR A  67      59.785 -18.184   3.154  1.00  0.00           H  
ATOM   1037  HB2 TYR A  67      57.827 -19.265   3.882  1.00  0.00           H  
ATOM   1038  HB3 TYR A  67      57.302 -17.629   3.499  1.00  0.00           H  
ATOM   1039  HD1 TYR A  67      56.754 -17.498   0.761  1.00  0.00           H  
ATOM   1040  HD2 TYR A  67      56.253 -20.848   3.336  1.00  0.00           H  
ATOM   1041  HE1 TYR A  67      55.039 -18.399  -0.755  1.00  0.00           H  
ATOM   1042  HE2 TYR A  67      54.537 -21.758   1.827  1.00  0.00           H  
ATOM   1043  HH  TYR A  67      53.360 -21.446  -0.025  1.00  0.00           H  
ATOM   1044  N   ASP A  68      60.295 -20.293   1.942  1.00  0.00           N  
ATOM   1045  CA  ASP A  68      60.726 -21.450   1.167  1.00  0.00           C  
ATOM   1046  C   ASP A  68      60.106 -22.732   1.712  1.00  0.00           C  
ATOM   1047  O   ASP A  68      59.384 -22.710   2.708  1.00  0.00           O  
ATOM   1048  CB  ASP A  68      62.252 -21.561   1.181  1.00  0.00           C  
ATOM   1049  CG  ASP A  68      62.780 -22.414   0.045  1.00  0.00           C  
ATOM   1050  OD1 ASP A  68      62.392 -22.164  -1.115  1.00  0.00           O  
ATOM   1051  OD2 ASP A  68      63.582 -23.332   0.317  1.00  0.00           O  
ATOM   1052  H   ASP A  68      60.690 -20.135   2.826  1.00  0.00           H  
ATOM   1053  HA  ASP A  68      60.394 -21.309   0.149  1.00  0.00           H  
ATOM   1054  HB2 ASP A  68      62.678 -20.572   1.092  1.00  0.00           H  
ATOM   1055  HB3 ASP A  68      62.565 -22.001   2.115  1.00  0.00           H  
ATOM   1056  N   SER A  69      60.392 -23.850   1.051  1.00  0.00           N  
ATOM   1057  CA  SER A  69      59.858 -25.142   1.467  1.00  0.00           C  
ATOM   1058  C   SER A  69      59.774 -25.231   2.987  1.00  0.00           C  
ATOM   1059  O   SER A  69      58.711 -25.496   3.546  1.00  0.00           O  
ATOM   1060  CB  SER A  69      60.730 -26.276   0.925  1.00  0.00           C  
ATOM   1061  OG  SER A  69      60.408 -26.568  -0.424  1.00  0.00           O  
ATOM   1062  H   SER A  69      60.973 -23.803   0.264  1.00  0.00           H  
ATOM   1063  HA  SER A  69      58.863 -25.237   1.056  1.00  0.00           H  
ATOM   1064  HB2 SER A  69      61.768 -25.985   0.979  1.00  0.00           H  
ATOM   1065  HB3 SER A  69      60.573 -27.163   1.521  1.00  0.00           H  
ATOM   1066  HG  SER A  69      59.720 -27.238  -0.451  1.00  0.00           H  
ATOM   1067  N   ASN A  70      60.905 -25.007   3.650  1.00  0.00           N  
ATOM   1068  CA  ASN A  70      60.960 -25.063   5.107  1.00  0.00           C  
ATOM   1069  C   ASN A  70      61.730 -23.871   5.667  1.00  0.00           C  
ATOM   1070  O   ASN A  70      62.454 -23.995   6.656  1.00  0.00           O  
ATOM   1071  CB  ASN A  70      61.615 -26.368   5.563  1.00  0.00           C  
ATOM   1072  CG  ASN A  70      60.682 -27.557   5.442  1.00  0.00           C  
ATOM   1073  OD1 ASN A  70      59.597 -27.453   4.870  1.00  0.00           O  
ATOM   1074  ND2 ASN A  70      61.101 -28.696   5.983  1.00  0.00           N  
ATOM   1075  H   ASN A  70      61.720 -24.801   3.149  1.00  0.00           H  
ATOM   1076  HA  ASN A  70      59.947 -25.030   5.478  1.00  0.00           H  
ATOM   1077  HB2 ASN A  70      62.488 -26.557   4.955  1.00  0.00           H  
ATOM   1078  HB3 ASN A  70      61.915 -26.272   6.596  1.00  0.00           H  
ATOM   1079 HD21 ASN A  70      61.977 -28.705   6.421  1.00  0.00           H  
ATOM   1080 HD22 ASN A  70      60.518 -29.480   5.918  1.00  0.00           H  
ATOM   1081  N   LEU A  71      61.569 -22.717   5.030  1.00  0.00           N  
ATOM   1082  CA  LEU A  71      62.247 -21.501   5.465  1.00  0.00           C  
ATOM   1083  C   LEU A  71      61.282 -20.320   5.496  1.00  0.00           C  
ATOM   1084  O   LEU A  71      60.303 -20.286   4.752  1.00  0.00           O  
ATOM   1085  CB  LEU A  71      63.423 -21.189   4.536  1.00  0.00           C  
ATOM   1086  CG  LEU A  71      64.476 -20.228   5.087  1.00  0.00           C  
ATOM   1087  CD1 LEU A  71      65.177 -20.838   6.292  1.00  0.00           C  
ATOM   1088  CD2 LEU A  71      65.485 -19.868   4.007  1.00  0.00           C  
ATOM   1089  H   LEU A  71      60.979 -22.680   4.248  1.00  0.00           H  
ATOM   1090  HA  LEU A  71      62.622 -21.671   6.463  1.00  0.00           H  
ATOM   1091  HB2 LEU A  71      63.915 -22.121   4.303  1.00  0.00           H  
ATOM   1092  HB3 LEU A  71      63.021 -20.759   3.630  1.00  0.00           H  
ATOM   1093  HG  LEU A  71      63.990 -19.318   5.410  1.00  0.00           H  
ATOM   1094 HD11 LEU A  71      65.396 -21.876   6.093  1.00  0.00           H  
ATOM   1095 HD12 LEU A  71      64.535 -20.765   7.157  1.00  0.00           H  
ATOM   1096 HD13 LEU A  71      66.096 -20.304   6.481  1.00  0.00           H  
ATOM   1097 HD21 LEU A  71      66.487 -19.981   4.397  1.00  0.00           H  
ATOM   1098 HD22 LEU A  71      65.332 -18.844   3.700  1.00  0.00           H  
ATOM   1099 HD23 LEU A  71      65.353 -20.522   3.158  1.00  0.00           H  
ATOM   1100  N   PHE A  72      61.568 -19.352   6.361  1.00  0.00           N  
ATOM   1101  CA  PHE A  72      60.725 -18.169   6.488  1.00  0.00           C  
ATOM   1102  C   PHE A  72      61.574 -16.919   6.702  1.00  0.00           C  
ATOM   1103  O   PHE A  72      62.165 -16.730   7.765  1.00  0.00           O  
ATOM   1104  CB  PHE A  72      59.745 -18.338   7.651  1.00  0.00           C  
ATOM   1105  CG  PHE A  72      58.955 -17.095   7.952  1.00  0.00           C  
ATOM   1106  CD1 PHE A  72      58.275 -16.429   6.945  1.00  0.00           C  
ATOM   1107  CD2 PHE A  72      58.891 -16.596   9.243  1.00  0.00           C  
ATOM   1108  CE1 PHE A  72      57.548 -15.287   7.221  1.00  0.00           C  
ATOM   1109  CE2 PHE A  72      58.166 -15.454   9.525  1.00  0.00           C  
ATOM   1110  CZ  PHE A  72      57.492 -14.799   8.512  1.00  0.00           C  
ATOM   1111  H   PHE A  72      62.364 -19.437   6.927  1.00  0.00           H  
ATOM   1112  HA  PHE A  72      60.169 -18.059   5.571  1.00  0.00           H  
ATOM   1113  HB2 PHE A  72      59.045 -19.124   7.411  1.00  0.00           H  
ATOM   1114  HB3 PHE A  72      60.294 -18.607   8.539  1.00  0.00           H  
ATOM   1115  HD1 PHE A  72      58.317 -16.809   5.936  1.00  0.00           H  
ATOM   1116  HD2 PHE A  72      59.417 -17.108  10.037  1.00  0.00           H  
ATOM   1117  HE1 PHE A  72      57.022 -14.776   6.428  1.00  0.00           H  
ATOM   1118  HE2 PHE A  72      58.123 -15.076  10.535  1.00  0.00           H  
ATOM   1119  HZ  PHE A  72      56.925 -13.906   8.729  1.00  0.00           H  
ATOM   1120  N   SER A  73      61.631 -16.067   5.682  1.00  0.00           N  
ATOM   1121  CA  SER A  73      62.411 -14.837   5.755  1.00  0.00           C  
ATOM   1122  C   SER A  73      61.556 -13.630   5.382  1.00  0.00           C  
ATOM   1123  O   SER A  73      60.763 -13.682   4.442  1.00  0.00           O  
ATOM   1124  CB  SER A  73      63.624 -14.922   4.827  1.00  0.00           C  
ATOM   1125  OG  SER A  73      64.608 -13.968   5.187  1.00  0.00           O  
ATOM   1126  H   SER A  73      61.139 -16.275   4.860  1.00  0.00           H  
ATOM   1127  HA  SER A  73      62.752 -14.723   6.772  1.00  0.00           H  
ATOM   1128  HB2 SER A  73      64.056 -15.909   4.893  1.00  0.00           H  
ATOM   1129  HB3 SER A  73      63.312 -14.733   3.811  1.00  0.00           H  
ATOM   1130  HG  SER A  73      64.183 -13.204   5.584  1.00  0.00           H  
ATOM   1131  N   PHE A  74      61.723 -12.543   6.129  1.00  0.00           N  
ATOM   1132  CA  PHE A  74      60.965 -11.321   5.879  1.00  0.00           C  
ATOM   1133  C   PHE A  74      61.840 -10.088   6.088  1.00  0.00           C  
ATOM   1134  O   PHE A  74      62.874 -10.153   6.751  1.00  0.00           O  
ATOM   1135  CB  PHE A  74      59.745 -11.256   6.798  1.00  0.00           C  
ATOM   1136  CG  PHE A  74      60.083 -11.398   8.255  1.00  0.00           C  
ATOM   1137  CD1 PHE A  74      60.391 -10.286   9.021  1.00  0.00           C  
ATOM   1138  CD2 PHE A  74      60.090 -12.645   8.859  1.00  0.00           C  
ATOM   1139  CE1 PHE A  74      60.703 -10.414  10.361  1.00  0.00           C  
ATOM   1140  CE2 PHE A  74      60.401 -12.780  10.200  1.00  0.00           C  
ATOM   1141  CZ  PHE A  74      60.707 -11.663  10.951  1.00  0.00           C  
ATOM   1142  H   PHE A  74      62.369 -12.562   6.865  1.00  0.00           H  
ATOM   1143  HA  PHE A  74      60.632 -11.342   4.853  1.00  0.00           H  
ATOM   1144  HB2 PHE A  74      59.253 -10.304   6.665  1.00  0.00           H  
ATOM   1145  HB3 PHE A  74      59.062 -12.050   6.536  1.00  0.00           H  
ATOM   1146  HD1 PHE A  74      60.388  -9.308   8.560  1.00  0.00           H  
ATOM   1147  HD2 PHE A  74      59.851 -13.520   8.272  1.00  0.00           H  
ATOM   1148  HE1 PHE A  74      60.942  -9.539  10.947  1.00  0.00           H  
ATOM   1149  HE2 PHE A  74      60.402 -13.758  10.658  1.00  0.00           H  
ATOM   1150  HZ  PHE A  74      60.951 -11.766  11.997  1.00  0.00           H  
ATOM   1151  N   GLU A  75      61.416  -8.966   5.515  1.00  0.00           N  
ATOM   1152  CA  GLU A  75      62.160  -7.718   5.637  1.00  0.00           C  
ATOM   1153  C   GLU A  75      61.375  -6.693   6.449  1.00  0.00           C  
ATOM   1154  O   GLU A  75      60.220  -6.398   6.145  1.00  0.00           O  
ATOM   1155  CB  GLU A  75      62.480  -7.152   4.252  1.00  0.00           C  
ATOM   1156  CG  GLU A  75      63.673  -6.212   4.239  1.00  0.00           C  
ATOM   1157  CD  GLU A  75      63.398  -4.908   4.963  1.00  0.00           C  
ATOM   1158  OE1 GLU A  75      62.234  -4.456   4.950  1.00  0.00           O  
ATOM   1159  OE2 GLU A  75      64.347  -4.340   5.544  1.00  0.00           O  
ATOM   1160  H   GLU A  75      60.583  -8.977   4.999  1.00  0.00           H  
ATOM   1161  HA  GLU A  75      63.086  -7.933   6.150  1.00  0.00           H  
ATOM   1162  HB2 GLU A  75      62.685  -7.971   3.580  1.00  0.00           H  
ATOM   1163  HB3 GLU A  75      61.618  -6.609   3.891  1.00  0.00           H  
ATOM   1164  HG2 GLU A  75      64.507  -6.702   4.719  1.00  0.00           H  
ATOM   1165  HG3 GLU A  75      63.930  -5.990   3.214  1.00  0.00           H  
ATOM   1166  N   SER A  76      62.011  -6.153   7.484  1.00  0.00           N  
ATOM   1167  CA  SER A  76      61.372  -5.164   8.343  1.00  0.00           C  
ATOM   1168  C   SER A  76      62.005  -3.789   8.154  1.00  0.00           C  
ATOM   1169  O   SER A  76      63.201  -3.608   8.385  1.00  0.00           O  
ATOM   1170  CB  SER A  76      61.474  -5.589   9.810  1.00  0.00           C  
ATOM   1171  OG  SER A  76      60.812  -6.822  10.031  1.00  0.00           O  
ATOM   1172  H   SER A  76      62.932  -6.429   7.676  1.00  0.00           H  
ATOM   1173  HA  SER A  76      60.329  -5.108   8.066  1.00  0.00           H  
ATOM   1174  HB2 SER A  76      62.514  -5.698  10.079  1.00  0.00           H  
ATOM   1175  HB3 SER A  76      61.019  -4.833  10.433  1.00  0.00           H  
ATOM   1176  HG  SER A  76      60.272  -6.758  10.821  1.00  0.00           H  
ATOM   1177  N   GLY A  77      61.195  -2.823   7.734  1.00  0.00           N  
ATOM   1178  CA  GLY A  77      61.694  -1.476   7.521  1.00  0.00           C  
ATOM   1179  C   GLY A  77      62.504  -0.966   8.695  1.00  0.00           C  
ATOM   1180  O   GLY A  77      62.627  -1.643   9.715  1.00  0.00           O  
ATOM   1181  H   GLY A  77      60.251  -3.026   7.567  1.00  0.00           H  
ATOM   1182  HA2 GLY A  77      62.314  -1.470   6.637  1.00  0.00           H  
ATOM   1183  HA3 GLY A  77      60.854  -0.815   7.364  1.00  0.00           H  
ATOM   1184  N   ARG A  78      63.063   0.232   8.551  1.00  0.00           N  
ATOM   1185  CA  ARG A  78      63.870   0.831   9.607  1.00  0.00           C  
ATOM   1186  C   ARG A  78      62.986   1.534  10.633  1.00  0.00           C  
ATOM   1187  O   ARG A  78      63.346   2.589  11.156  1.00  0.00           O  
ATOM   1188  CB  ARG A  78      64.870   1.824   9.013  1.00  0.00           C  
ATOM   1189  CG  ARG A  78      64.224   3.090   8.474  1.00  0.00           C  
ATOM   1190  CD  ARG A  78      65.088   3.747   7.409  1.00  0.00           C  
ATOM   1191  NE  ARG A  78      66.067   4.665   7.987  1.00  0.00           N  
ATOM   1192  CZ  ARG A  78      67.134   5.108   7.332  1.00  0.00           C  
ATOM   1193  NH1 ARG A  78      67.359   4.721   6.085  1.00  0.00           N  
ATOM   1194  NH2 ARG A  78      67.979   5.940   7.927  1.00  0.00           N  
ATOM   1195  H   ARG A  78      62.931   0.723   7.714  1.00  0.00           H  
ATOM   1196  HA  ARG A  78      64.413   0.038  10.100  1.00  0.00           H  
ATOM   1197  HB2 ARG A  78      65.579   2.105   9.777  1.00  0.00           H  
ATOM   1198  HB3 ARG A  78      65.398   1.343   8.203  1.00  0.00           H  
ATOM   1199  HG2 ARG A  78      63.267   2.839   8.041  1.00  0.00           H  
ATOM   1200  HG3 ARG A  78      64.082   3.784   9.289  1.00  0.00           H  
ATOM   1201  HD2 ARG A  78      65.611   2.976   6.862  1.00  0.00           H  
ATOM   1202  HD3 ARG A  78      64.448   4.296   6.734  1.00  0.00           H  
ATOM   1203  HE  ARG A  78      65.919   4.964   8.908  1.00  0.00           H  
ATOM   1204 HH11 ARG A  78      66.723   4.094   5.634  1.00  0.00           H  
ATOM   1205 HH12 ARG A  78      68.163   5.057   5.593  1.00  0.00           H  
ATOM   1206 HH21 ARG A  78      67.813   6.235   8.867  1.00  0.00           H  
ATOM   1207 HH22 ARG A  78      68.782   6.274   7.432  1.00  0.00           H  
ATOM   1208  N   ARG A  79      61.832   0.942  10.916  1.00  0.00           N  
ATOM   1209  CA  ARG A  79      60.896   1.512  11.878  1.00  0.00           C  
ATOM   1210  C   ARG A  79      60.560   0.505  12.974  1.00  0.00           C  
ATOM   1211  O   ARG A  79      59.463   0.521  13.531  1.00  0.00           O  
ATOM   1212  CB  ARG A  79      59.615   1.960  11.172  1.00  0.00           C  
ATOM   1213  CG  ARG A  79      59.838   3.056  10.144  1.00  0.00           C  
ATOM   1214  CD  ARG A  79      58.520   3.623   9.640  1.00  0.00           C  
ATOM   1215  NE  ARG A  79      58.032   4.709  10.484  1.00  0.00           N  
ATOM   1216  CZ  ARG A  79      56.787   5.171  10.444  1.00  0.00           C  
ATOM   1217  NH1 ARG A  79      55.908   4.641   9.603  1.00  0.00           N  
ATOM   1218  NH2 ARG A  79      56.418   6.162  11.244  1.00  0.00           N  
ATOM   1219  H   ARG A  79      61.602   0.102  10.467  1.00  0.00           H  
ATOM   1220  HA  ARG A  79      61.367   2.373  12.330  1.00  0.00           H  
ATOM   1221  HB2 ARG A  79      59.178   1.110  10.671  1.00  0.00           H  
ATOM   1222  HB3 ARG A  79      58.920   2.327  11.913  1.00  0.00           H  
ATOM   1223  HG2 ARG A  79      60.409   3.853  10.598  1.00  0.00           H  
ATOM   1224  HG3 ARG A  79      60.387   2.647   9.309  1.00  0.00           H  
ATOM   1225  HD2 ARG A  79      58.665   3.997   8.637  1.00  0.00           H  
ATOM   1226  HD3 ARG A  79      57.785   2.832   9.626  1.00  0.00           H  
ATOM   1227  HE  ARG A  79      58.665   5.115  11.113  1.00  0.00           H  
ATOM   1228 HH11 ARG A  79      56.183   3.893   8.999  1.00  0.00           H  
ATOM   1229 HH12 ARG A  79      54.971   4.989   9.575  1.00  0.00           H  
ATOM   1230 HH21 ARG A  79      57.077   6.563  11.879  1.00  0.00           H  
ATOM   1231 HH22 ARG A  79      55.481   6.508  11.212  1.00  0.00           H  
ATOM   1232  N   CYS A  80      61.512  -0.371  13.277  1.00  0.00           N  
ATOM   1233  CA  CYS A  80      61.317  -1.388  14.305  1.00  0.00           C  
ATOM   1234  C   CYS A  80      62.538  -1.482  15.214  1.00  0.00           C  
ATOM   1235  O   CYS A  80      63.657  -1.176  14.801  1.00  0.00           O  
ATOM   1236  CB  CYS A  80      61.039  -2.747  13.661  1.00  0.00           C  
ATOM   1237  SG  CYS A  80      62.306  -3.280  12.485  1.00  0.00           S  
ATOM   1238  H   CYS A  80      62.367  -0.334  12.798  1.00  0.00           H  
ATOM   1239  HA  CYS A  80      60.464  -1.098  14.898  1.00  0.00           H  
ATOM   1240  HB2 CYS A  80      60.975  -3.497  14.435  1.00  0.00           H  
ATOM   1241  HB3 CYS A  80      60.098  -2.701  13.134  1.00  0.00           H  
ATOM   1242  HG  CYS A  80      62.749  -2.207  11.847  1.00  0.00           H  
ATOM   1243  N   GLN A  81      62.315  -1.907  16.453  1.00  0.00           N  
ATOM   1244  CA  GLN A  81      63.397  -2.039  17.422  1.00  0.00           C  
ATOM   1245  C   GLN A  81      64.672  -2.540  16.749  1.00  0.00           C  
ATOM   1246  O   GLN A  81      65.643  -1.797  16.604  1.00  0.00           O  
ATOM   1247  CB  GLN A  81      62.992  -2.996  18.544  1.00  0.00           C  
ATOM   1248  CG  GLN A  81      64.135  -3.359  19.478  1.00  0.00           C  
ATOM   1249  CD  GLN A  81      64.889  -4.592  19.024  1.00  0.00           C  
ATOM   1250  OE1 GLN A  81      66.064  -4.519  18.665  1.00  0.00           O  
ATOM   1251  NE2 GLN A  81      64.215  -5.737  19.038  1.00  0.00           N  
ATOM   1252  H   GLN A  81      61.402  -2.136  16.723  1.00  0.00           H  
ATOM   1253  HA  GLN A  81      63.586  -1.064  17.842  1.00  0.00           H  
ATOM   1254  HB2 GLN A  81      62.210  -2.534  19.130  1.00  0.00           H  
ATOM   1255  HB3 GLN A  81      62.610  -3.906  18.106  1.00  0.00           H  
ATOM   1256  HG2 GLN A  81      64.826  -2.530  19.520  1.00  0.00           H  
ATOM   1257  HG3 GLN A  81      63.733  -3.541  20.463  1.00  0.00           H  
ATOM   1258 HE21 GLN A  81      63.280  -5.720  19.336  1.00  0.00           H  
ATOM   1259 HE22 GLN A  81      64.678  -6.551  18.749  1.00  0.00           H  
ATOM   1260  N   THR A  82      64.662  -3.804  16.338  1.00  0.00           N  
ATOM   1261  CA  THR A  82      65.816  -4.404  15.682  1.00  0.00           C  
ATOM   1262  C   THR A  82      66.362  -3.493  14.589  1.00  0.00           C  
ATOM   1263  O   THR A  82      67.571  -3.299  14.474  1.00  0.00           O  
ATOM   1264  CB  THR A  82      65.466  -5.771  15.068  1.00  0.00           C  
ATOM   1265  OG1 THR A  82      64.358  -5.637  14.172  1.00  0.00           O  
ATOM   1266  CG2 THR A  82      65.127  -6.782  16.153  1.00  0.00           C  
ATOM   1267  H   THR A  82      63.858  -4.345  16.482  1.00  0.00           H  
ATOM   1268  HA  THR A  82      66.584  -4.553  16.429  1.00  0.00           H  
ATOM   1269  HB  THR A  82      66.323  -6.132  14.518  1.00  0.00           H  
ATOM   1270  HG1 THR A  82      64.507  -6.180  13.394  1.00  0.00           H  
ATOM   1271 HG21 THR A  82      65.746  -6.602  17.019  1.00  0.00           H  
ATOM   1272 HG22 THR A  82      65.305  -7.781  15.785  1.00  0.00           H  
ATOM   1273 HG23 THR A  82      64.087  -6.680  16.428  1.00  0.00           H  
ATOM   1274  N   GLY A  83      65.461  -2.935  13.785  1.00  0.00           N  
ATOM   1275  CA  GLY A  83      65.872  -2.050  12.711  1.00  0.00           C  
ATOM   1276  C   GLY A  83      65.875  -2.740  11.361  1.00  0.00           C  
ATOM   1277  O   GLY A  83      65.418  -3.876  11.237  1.00  0.00           O  
ATOM   1278  H   GLY A  83      64.510  -3.126  13.924  1.00  0.00           H  
ATOM   1279  HA2 GLY A  83      65.196  -1.209  12.673  1.00  0.00           H  
ATOM   1280  HA3 GLY A  83      66.869  -1.689  12.919  1.00  0.00           H  
ATOM   1281  N   GLN A  84      66.388  -2.051  10.347  1.00  0.00           N  
ATOM   1282  CA  GLN A  84      66.444  -2.604   9.000  1.00  0.00           C  
ATOM   1283  C   GLN A  84      67.322  -3.850   8.959  1.00  0.00           C  
ATOM   1284  O   GLN A  84      68.356  -3.916   9.623  1.00  0.00           O  
ATOM   1285  CB  GLN A  84      66.977  -1.558   8.018  1.00  0.00           C  
ATOM   1286  CG  GLN A  84      66.463  -1.737   6.599  1.00  0.00           C  
ATOM   1287  CD  GLN A  84      67.093  -0.764   5.623  1.00  0.00           C  
ATOM   1288  OE1 GLN A  84      67.591   0.292   6.014  1.00  0.00           O  
ATOM   1289  NE2 GLN A  84      67.077  -1.115   4.342  1.00  0.00           N  
ATOM   1290  H   GLN A  84      66.736  -1.149  10.509  1.00  0.00           H  
ATOM   1291  HA  GLN A  84      65.441  -2.876   8.710  1.00  0.00           H  
ATOM   1292  HB2 GLN A  84      66.687  -0.577   8.363  1.00  0.00           H  
ATOM   1293  HB3 GLN A  84      68.056  -1.618   7.997  1.00  0.00           H  
ATOM   1294  HG2 GLN A  84      66.683  -2.743   6.274  1.00  0.00           H  
ATOM   1295  HG3 GLN A  84      65.394  -1.586   6.596  1.00  0.00           H  
ATOM   1296 HE21 GLN A  84      66.663  -1.971   4.102  1.00  0.00           H  
ATOM   1297 HE22 GLN A  84      67.477  -0.505   3.689  1.00  0.00           H  
ATOM   1298  N   GLY A  85      66.903  -4.838   8.174  1.00  0.00           N  
ATOM   1299  CA  GLY A  85      67.662  -6.070   8.063  1.00  0.00           C  
ATOM   1300  C   GLY A  85      66.829  -7.218   7.529  1.00  0.00           C  
ATOM   1301  O   GLY A  85      65.640  -7.055   7.251  1.00  0.00           O  
ATOM   1302  H   GLY A  85      66.070  -4.730   7.668  1.00  0.00           H  
ATOM   1303  HA2 GLY A  85      68.497  -5.906   7.398  1.00  0.00           H  
ATOM   1304  HA3 GLY A  85      68.038  -6.337   9.039  1.00  0.00           H  
ATOM   1305  N   ILE A  86      67.452  -8.383   7.385  1.00  0.00           N  
ATOM   1306  CA  ILE A  86      66.760  -9.562   6.879  1.00  0.00           C  
ATOM   1307  C   ILE A  86      66.896 -10.734   7.846  1.00  0.00           C  
ATOM   1308  O   ILE A  86      67.970 -11.321   7.979  1.00  0.00           O  
ATOM   1309  CB  ILE A  86      67.298  -9.983   5.500  1.00  0.00           C  
ATOM   1310  CG1 ILE A  86      67.064  -8.872   4.475  1.00  0.00           C  
ATOM   1311  CG2 ILE A  86      66.639 -11.277   5.046  1.00  0.00           C  
ATOM   1312  CD1 ILE A  86      67.972  -8.959   3.269  1.00  0.00           C  
ATOM   1313  H   ILE A  86      68.400  -8.450   7.624  1.00  0.00           H  
ATOM   1314  HA  ILE A  86      65.713  -9.315   6.776  1.00  0.00           H  
ATOM   1315  HB  ILE A  86      68.359 -10.161   5.591  1.00  0.00           H  
ATOM   1316 HG12 ILE A  86      66.045  -8.922   4.126  1.00  0.00           H  
ATOM   1317 HG13 ILE A  86      67.231  -7.915   4.949  1.00  0.00           H  
ATOM   1318 HG21 ILE A  86      66.000 -11.650   5.833  1.00  0.00           H  
ATOM   1319 HG22 ILE A  86      66.047 -11.089   4.163  1.00  0.00           H  
ATOM   1320 HG23 ILE A  86      67.398 -12.010   4.821  1.00  0.00           H  
ATOM   1321 HD11 ILE A  86      67.377  -8.948   2.368  1.00  0.00           H  
ATOM   1322 HD12 ILE A  86      68.646  -8.116   3.264  1.00  0.00           H  
ATOM   1323 HD13 ILE A  86      68.541  -9.876   3.312  1.00  0.00           H  
ATOM   1324  N   PHE A  87      65.799 -11.071   8.516  1.00  0.00           N  
ATOM   1325  CA  PHE A  87      65.794 -12.174   9.470  1.00  0.00           C  
ATOM   1326  C   PHE A  87      65.123 -13.407   8.872  1.00  0.00           C  
ATOM   1327  O   PHE A  87      63.985 -13.344   8.409  1.00  0.00           O  
ATOM   1328  CB  PHE A  87      65.077 -11.762  10.757  1.00  0.00           C  
ATOM   1329  CG  PHE A  87      65.486 -10.408  11.263  1.00  0.00           C  
ATOM   1330  CD1 PHE A  87      64.921  -9.258  10.738  1.00  0.00           C  
ATOM   1331  CD2 PHE A  87      66.437 -10.287  12.264  1.00  0.00           C  
ATOM   1332  CE1 PHE A  87      65.294  -8.010  11.203  1.00  0.00           C  
ATOM   1333  CE2 PHE A  87      66.814  -9.042  12.733  1.00  0.00           C  
ATOM   1334  CZ  PHE A  87      66.243  -7.903  12.201  1.00  0.00           C  
ATOM   1335  H   PHE A  87      64.973 -10.565   8.367  1.00  0.00           H  
ATOM   1336  HA  PHE A  87      66.821 -12.416   9.702  1.00  0.00           H  
ATOM   1337  HB2 PHE A  87      64.013 -11.740  10.576  1.00  0.00           H  
ATOM   1338  HB3 PHE A  87      65.292 -12.485  11.528  1.00  0.00           H  
ATOM   1339  HD1 PHE A  87      64.179  -9.341   9.957  1.00  0.00           H  
ATOM   1340  HD2 PHE A  87      66.884 -11.176  12.681  1.00  0.00           H  
ATOM   1341  HE1 PHE A  87      64.846  -7.121  10.784  1.00  0.00           H  
ATOM   1342  HE2 PHE A  87      67.555  -8.960  13.513  1.00  0.00           H  
ATOM   1343  HZ  PHE A  87      66.536  -6.929  12.565  1.00  0.00           H  
ATOM   1344  N   ALA A  88      65.837 -14.528   8.887  1.00  0.00           N  
ATOM   1345  CA  ALA A  88      65.310 -15.776   8.348  1.00  0.00           C  
ATOM   1346  C   ALA A  88      65.368 -16.890   9.387  1.00  0.00           C  
ATOM   1347  O   ALA A  88      66.389 -17.085  10.046  1.00  0.00           O  
ATOM   1348  CB  ALA A  88      66.079 -16.177   7.098  1.00  0.00           C  
ATOM   1349  H   ALA A  88      66.739 -14.515   9.270  1.00  0.00           H  
ATOM   1350  HA  ALA A  88      64.279 -15.610   8.068  1.00  0.00           H  
ATOM   1351  HB1 ALA A  88      67.140 -16.117   7.293  1.00  0.00           H  
ATOM   1352  HB2 ALA A  88      65.820 -17.191   6.826  1.00  0.00           H  
ATOM   1353  HB3 ALA A  88      65.824 -15.511   6.288  1.00  0.00           H  
ATOM   1354  N   PHE A  89      64.264 -17.618   9.529  1.00  0.00           N  
ATOM   1355  CA  PHE A  89      64.189 -18.711  10.490  1.00  0.00           C  
ATOM   1356  C   PHE A  89      63.757 -20.006   9.808  1.00  0.00           C  
ATOM   1357  O   PHE A  89      63.055 -19.984   8.796  1.00  0.00           O  
ATOM   1358  CB  PHE A  89      63.211 -18.364  11.615  1.00  0.00           C  
ATOM   1359  CG  PHE A  89      63.336 -16.948  12.102  1.00  0.00           C  
ATOM   1360  CD1 PHE A  89      63.075 -15.884  11.254  1.00  0.00           C  
ATOM   1361  CD2 PHE A  89      63.715 -16.682  13.408  1.00  0.00           C  
ATOM   1362  CE1 PHE A  89      63.189 -14.581  11.698  1.00  0.00           C  
ATOM   1363  CE2 PHE A  89      63.830 -15.380  13.858  1.00  0.00           C  
ATOM   1364  CZ  PHE A  89      63.568 -14.329  13.003  1.00  0.00           C  
ATOM   1365  H   PHE A  89      63.482 -17.413   8.975  1.00  0.00           H  
ATOM   1366  HA  PHE A  89      65.172 -18.852  10.911  1.00  0.00           H  
ATOM   1367  HB2 PHE A  89      62.201 -18.504  11.261  1.00  0.00           H  
ATOM   1368  HB3 PHE A  89      63.388 -19.021  12.453  1.00  0.00           H  
ATOM   1369  HD1 PHE A  89      62.779 -16.080  10.233  1.00  0.00           H  
ATOM   1370  HD2 PHE A  89      63.922 -17.503  14.078  1.00  0.00           H  
ATOM   1371  HE1 PHE A  89      62.984 -13.761  11.027  1.00  0.00           H  
ATOM   1372  HE2 PHE A  89      64.127 -15.186  14.878  1.00  0.00           H  
ATOM   1373  HZ  PHE A  89      63.657 -13.311  13.352  1.00  0.00           H  
ATOM   1374  N   LYS A  90      64.181 -21.133  10.368  1.00  0.00           N  
ATOM   1375  CA  LYS A  90      63.840 -22.439   9.816  1.00  0.00           C  
ATOM   1376  C   LYS A  90      62.601 -23.011  10.498  1.00  0.00           C  
ATOM   1377  O   LYS A  90      62.583 -23.202  11.716  1.00  0.00           O  
ATOM   1378  CB  LYS A  90      65.015 -23.406   9.976  1.00  0.00           C  
ATOM   1379  CG  LYS A  90      66.146 -23.155   8.995  1.00  0.00           C  
ATOM   1380  CD  LYS A  90      67.470 -23.680   9.525  1.00  0.00           C  
ATOM   1381  CE  LYS A  90      67.696 -25.129   9.123  1.00  0.00           C  
ATOM   1382  NZ  LYS A  90      67.096 -26.076  10.102  1.00  0.00           N  
ATOM   1383  H   LYS A  90      64.738 -21.086  11.175  1.00  0.00           H  
ATOM   1384  HA  LYS A  90      63.630 -22.311   8.766  1.00  0.00           H  
ATOM   1385  HB2 LYS A  90      65.408 -23.315  10.977  1.00  0.00           H  
ATOM   1386  HB3 LYS A  90      64.657 -24.416   9.829  1.00  0.00           H  
ATOM   1387  HG2 LYS A  90      65.921 -23.654   8.064  1.00  0.00           H  
ATOM   1388  HG3 LYS A  90      66.234 -22.091   8.824  1.00  0.00           H  
ATOM   1389  HD2 LYS A  90      68.273 -23.078   9.124  1.00  0.00           H  
ATOM   1390  HD3 LYS A  90      67.470 -23.610  10.603  1.00  0.00           H  
ATOM   1391  HE2 LYS A  90      67.250 -25.295   8.155  1.00  0.00           H  
ATOM   1392  HE3 LYS A  90      68.759 -25.311   9.065  1.00  0.00           H  
ATOM   1393  HZ1 LYS A  90      66.447 -26.729   9.618  1.00  0.00           H  
ATOM   1394  HZ2 LYS A  90      66.566 -25.551  10.827  1.00  0.00           H  
ATOM   1395  HZ3 LYS A  90      67.842 -26.629  10.569  1.00  0.00           H  
ATOM   1396  N   CYS A  91      61.569 -23.283   9.708  1.00  0.00           N  
ATOM   1397  CA  CYS A  91      60.326 -23.834  10.237  1.00  0.00           C  
ATOM   1398  C   CYS A  91      59.544 -24.556   9.145  1.00  0.00           C  
ATOM   1399  O   CYS A  91      59.180 -23.960   8.130  1.00  0.00           O  
ATOM   1400  CB  CYS A  91      59.469 -22.723  10.845  1.00  0.00           C  
ATOM   1401  SG  CYS A  91      57.908 -23.299  11.554  1.00  0.00           S  
ATOM   1402  H   CYS A  91      61.643 -23.110   8.747  1.00  0.00           H  
ATOM   1403  HA  CYS A  91      60.580 -24.545  11.008  1.00  0.00           H  
ATOM   1404  HB2 CYS A  91      60.027 -22.238  11.632  1.00  0.00           H  
ATOM   1405  HB3 CYS A  91      59.236 -21.999  10.078  1.00  0.00           H  
ATOM   1406  HG  CYS A  91      58.186 -24.258  12.425  1.00  0.00           H  
ATOM   1407  N   SER A  92      59.291 -25.844   9.357  1.00  0.00           N  
ATOM   1408  CA  SER A  92      58.557 -26.649   8.388  1.00  0.00           C  
ATOM   1409  C   SER A  92      57.164 -26.074   8.148  1.00  0.00           C  
ATOM   1410  O   SER A  92      56.515 -26.387   7.150  1.00  0.00           O  
ATOM   1411  CB  SER A  92      58.447 -28.095   8.874  1.00  0.00           C  
ATOM   1412  OG  SER A  92      57.928 -28.937   7.860  1.00  0.00           O  
ATOM   1413  H   SER A  92      59.607 -26.262  10.185  1.00  0.00           H  
ATOM   1414  HA  SER A  92      59.106 -26.631   7.459  1.00  0.00           H  
ATOM   1415  HB2 SER A  92      59.426 -28.453   9.156  1.00  0.00           H  
ATOM   1416  HB3 SER A  92      57.788 -28.136   9.731  1.00  0.00           H  
ATOM   1417  HG  SER A  92      57.180 -29.432   8.204  1.00  0.00           H  
ATOM   1418  N   ARG A  93      56.711 -25.231   9.070  1.00  0.00           N  
ATOM   1419  CA  ARG A  93      55.396 -24.613   8.961  1.00  0.00           C  
ATOM   1420  C   ARG A  93      55.505 -23.196   8.406  1.00  0.00           C  
ATOM   1421  O   ARG A  93      54.606 -22.376   8.587  1.00  0.00           O  
ATOM   1422  CB  ARG A  93      54.706 -24.585  10.327  1.00  0.00           C  
ATOM   1423  CG  ARG A  93      54.465 -25.966  10.915  1.00  0.00           C  
ATOM   1424  CD  ARG A  93      53.239 -25.981  11.815  1.00  0.00           C  
ATOM   1425  NE  ARG A  93      52.003 -26.125  11.052  1.00  0.00           N  
ATOM   1426  CZ  ARG A  93      51.524 -27.294  10.641  1.00  0.00           C  
ATOM   1427  NH1 ARG A  93      52.175 -28.415  10.919  1.00  0.00           N  
ATOM   1428  NH2 ARG A  93      50.392 -27.343   9.951  1.00  0.00           N  
ATOM   1429  H   ARG A  93      57.275 -25.021   9.844  1.00  0.00           H  
ATOM   1430  HA  ARG A  93      54.805 -25.208   8.282  1.00  0.00           H  
ATOM   1431  HB2 ARG A  93      55.321 -24.026  11.017  1.00  0.00           H  
ATOM   1432  HB3 ARG A  93      53.753 -24.089  10.225  1.00  0.00           H  
ATOM   1433  HG2 ARG A  93      54.316 -26.669  10.110  1.00  0.00           H  
ATOM   1434  HG3 ARG A  93      55.329 -26.256  11.495  1.00  0.00           H  
ATOM   1435  HD2 ARG A  93      53.324 -26.809  12.503  1.00  0.00           H  
ATOM   1436  HD3 ARG A  93      53.204 -25.055  12.369  1.00  0.00           H  
ATOM   1437  HE  ARG A  93      51.505 -25.309  10.834  1.00  0.00           H  
ATOM   1438 HH11 ARG A  93      53.027 -28.381  11.440  1.00  0.00           H  
ATOM   1439 HH12 ARG A  93      51.811 -29.295  10.610  1.00  0.00           H  
ATOM   1440 HH21 ARG A  93      49.898 -26.501   9.739  1.00  0.00           H  
ATOM   1441 HH22 ARG A  93      50.032 -28.224   9.642  1.00  0.00           H  
ATOM   1442  N   ALA A  94      56.614 -22.915   7.730  1.00  0.00           N  
ATOM   1443  CA  ALA A  94      56.841 -21.599   7.147  1.00  0.00           C  
ATOM   1444  C   ALA A  94      55.690 -21.199   6.229  1.00  0.00           C  
ATOM   1445  O   ALA A  94      55.353 -20.020   6.121  1.00  0.00           O  
ATOM   1446  CB  ALA A  94      58.157 -21.579   6.384  1.00  0.00           C  
ATOM   1447  H   ALA A  94      57.296 -23.611   7.619  1.00  0.00           H  
ATOM   1448  HA  ALA A  94      56.910 -20.884   7.954  1.00  0.00           H  
ATOM   1449  HB1 ALA A  94      58.922 -21.127   6.998  1.00  0.00           H  
ATOM   1450  HB2 ALA A  94      58.445 -22.591   6.137  1.00  0.00           H  
ATOM   1451  HB3 ALA A  94      58.038 -21.006   5.475  1.00  0.00           H  
ATOM   1452  N   GLU A  95      55.093 -22.187   5.571  1.00  0.00           N  
ATOM   1453  CA  GLU A  95      53.980 -21.936   4.663  1.00  0.00           C  
ATOM   1454  C   GLU A  95      52.778 -21.373   5.416  1.00  0.00           C  
ATOM   1455  O   GLU A  95      52.101 -20.467   4.935  1.00  0.00           O  
ATOM   1456  CB  GLU A  95      53.585 -23.224   3.937  1.00  0.00           C  
ATOM   1457  CG  GLU A  95      52.331 -23.085   3.090  1.00  0.00           C  
ATOM   1458  CD  GLU A  95      51.648 -24.415   2.837  1.00  0.00           C  
ATOM   1459  OE1 GLU A  95      51.982 -25.072   1.829  1.00  0.00           O  
ATOM   1460  OE2 GLU A  95      50.779 -24.798   3.647  1.00  0.00           O  
ATOM   1461  H   GLU A  95      55.407 -23.106   5.700  1.00  0.00           H  
ATOM   1462  HA  GLU A  95      54.305 -21.209   3.934  1.00  0.00           H  
ATOM   1463  HB2 GLU A  95      54.398 -23.525   3.295  1.00  0.00           H  
ATOM   1464  HB3 GLU A  95      53.413 -23.998   4.671  1.00  0.00           H  
ATOM   1465  HG2 GLU A  95      51.638 -22.433   3.600  1.00  0.00           H  
ATOM   1466  HG3 GLU A  95      52.601 -22.648   2.140  1.00  0.00           H  
ATOM   1467  N   GLU A  96      52.521 -21.919   6.601  1.00  0.00           N  
ATOM   1468  CA  GLU A  96      51.400 -21.474   7.420  1.00  0.00           C  
ATOM   1469  C   GLU A  96      51.637 -20.060   7.942  1.00  0.00           C  
ATOM   1470  O   GLU A  96      50.733 -19.224   7.936  1.00  0.00           O  
ATOM   1471  CB  GLU A  96      51.183 -22.433   8.592  1.00  0.00           C  
ATOM   1472  CG  GLU A  96      50.267 -23.600   8.262  1.00  0.00           C  
ATOM   1473  CD  GLU A  96      49.512 -24.109   9.473  1.00  0.00           C  
ATOM   1474  OE1 GLU A  96      50.112 -24.168  10.567  1.00  0.00           O  
ATOM   1475  OE2 GLU A  96      48.319 -24.450   9.328  1.00  0.00           O  
ATOM   1476  H   GLU A  96      53.099 -22.640   6.931  1.00  0.00           H  
ATOM   1477  HA  GLU A  96      50.516 -21.472   6.800  1.00  0.00           H  
ATOM   1478  HB2 GLU A  96      52.139 -22.828   8.900  1.00  0.00           H  
ATOM   1479  HB3 GLU A  96      50.748 -21.884   9.414  1.00  0.00           H  
ATOM   1480  HG2 GLU A  96      49.552 -23.280   7.519  1.00  0.00           H  
ATOM   1481  HG3 GLU A  96      50.864 -24.407   7.862  1.00  0.00           H  
ATOM   1482  N   ILE A  97      52.859 -19.801   8.396  1.00  0.00           N  
ATOM   1483  CA  ILE A  97      53.216 -18.489   8.922  1.00  0.00           C  
ATOM   1484  C   ILE A  97      53.123 -17.419   7.840  1.00  0.00           C  
ATOM   1485  O   ILE A  97      52.553 -16.349   8.056  1.00  0.00           O  
ATOM   1486  CB  ILE A  97      54.639 -18.485   9.511  1.00  0.00           C  
ATOM   1487  CG1 ILE A  97      54.771 -19.563  10.590  1.00  0.00           C  
ATOM   1488  CG2 ILE A  97      54.974 -17.115  10.080  1.00  0.00           C  
ATOM   1489  CD1 ILE A  97      56.200 -19.973  10.862  1.00  0.00           C  
ATOM   1490  H   ILE A  97      53.537 -20.508   8.376  1.00  0.00           H  
ATOM   1491  HA  ILE A  97      52.520 -18.247   9.714  1.00  0.00           H  
ATOM   1492  HB  ILE A  97      55.334 -18.698   8.714  1.00  0.00           H  
ATOM   1493 HG12 ILE A  97      54.350 -19.193  11.512  1.00  0.00           H  
ATOM   1494 HG13 ILE A  97      54.226 -20.443  10.277  1.00  0.00           H  
ATOM   1495 HG21 ILE A  97      56.021 -16.905   9.918  1.00  0.00           H  
ATOM   1496 HG22 ILE A  97      54.377 -16.364   9.584  1.00  0.00           H  
ATOM   1497 HG23 ILE A  97      54.763 -17.103  11.138  1.00  0.00           H  
ATOM   1498 HD11 ILE A  97      56.746 -20.019   9.931  1.00  0.00           H  
ATOM   1499 HD12 ILE A  97      56.665 -19.248  11.514  1.00  0.00           H  
ATOM   1500 HD13 ILE A  97      56.214 -20.943  11.334  1.00  0.00           H  
ATOM   1501  N   PHE A  98      53.686 -17.715   6.674  1.00  0.00           N  
ATOM   1502  CA  PHE A  98      53.667 -16.778   5.556  1.00  0.00           C  
ATOM   1503  C   PHE A  98      52.238 -16.518   5.089  1.00  0.00           C  
ATOM   1504  O   PHE A  98      51.826 -15.370   4.926  1.00  0.00           O  
ATOM   1505  CB  PHE A  98      54.503 -17.320   4.394  1.00  0.00           C  
ATOM   1506  CG  PHE A  98      54.297 -16.573   3.108  1.00  0.00           C  
ATOM   1507  CD1 PHE A  98      53.258 -16.908   2.255  1.00  0.00           C  
ATOM   1508  CD2 PHE A  98      55.144 -15.535   2.751  1.00  0.00           C  
ATOM   1509  CE1 PHE A  98      53.067 -16.222   1.070  1.00  0.00           C  
ATOM   1510  CE2 PHE A  98      54.958 -14.845   1.568  1.00  0.00           C  
ATOM   1511  CZ  PHE A  98      53.917 -15.189   0.727  1.00  0.00           C  
ATOM   1512  H   PHE A  98      54.127 -18.584   6.562  1.00  0.00           H  
ATOM   1513  HA  PHE A  98      54.097 -15.849   5.895  1.00  0.00           H  
ATOM   1514  HB2 PHE A  98      55.549 -17.253   4.652  1.00  0.00           H  
ATOM   1515  HB3 PHE A  98      54.243 -18.354   4.225  1.00  0.00           H  
ATOM   1516  HD1 PHE A  98      52.592 -17.714   2.523  1.00  0.00           H  
ATOM   1517  HD2 PHE A  98      55.959 -15.265   3.409  1.00  0.00           H  
ATOM   1518  HE1 PHE A  98      52.253 -16.492   0.415  1.00  0.00           H  
ATOM   1519  HE2 PHE A  98      55.624 -14.038   1.303  1.00  0.00           H  
ATOM   1520  HZ  PHE A  98      53.771 -14.652  -0.198  1.00  0.00           H  
ATOM   1521  N   ASN A  99      51.485 -17.593   4.876  1.00  0.00           N  
ATOM   1522  CA  ASN A  99      50.102 -17.481   4.427  1.00  0.00           C  
ATOM   1523  C   ASN A  99      49.263 -16.707   5.439  1.00  0.00           C  
ATOM   1524  O   ASN A  99      48.484 -15.827   5.071  1.00  0.00           O  
ATOM   1525  CB  ASN A  99      49.502 -18.871   4.207  1.00  0.00           C  
ATOM   1526  CG  ASN A  99      50.071 -19.559   2.981  1.00  0.00           C  
ATOM   1527  OD1 ASN A  99      50.531 -18.904   2.046  1.00  0.00           O  
ATOM   1528  ND2 ASN A  99      50.041 -20.887   2.980  1.00  0.00           N  
ATOM   1529  H   ASN A  99      51.870 -18.483   5.023  1.00  0.00           H  
ATOM   1530  HA  ASN A  99      50.100 -16.946   3.490  1.00  0.00           H  
ATOM   1531  HB2 ASN A  99      49.710 -19.488   5.070  1.00  0.00           H  
ATOM   1532  HB3 ASN A  99      48.434 -18.782   4.084  1.00  0.00           H  
ATOM   1533 HD21 ASN A  99      49.659 -21.343   3.760  1.00  0.00           H  
ATOM   1534 HD22 ASN A  99      50.403 -21.358   2.200  1.00  0.00           H  
ATOM   1535  N   LEU A 100      49.428 -17.040   6.715  1.00  0.00           N  
ATOM   1536  CA  LEU A 100      48.686 -16.376   7.780  1.00  0.00           C  
ATOM   1537  C   LEU A 100      49.085 -14.907   7.889  1.00  0.00           C  
ATOM   1538  O   LEU A 100      48.233 -14.019   7.887  1.00  0.00           O  
ATOM   1539  CB  LEU A 100      48.930 -17.083   9.115  1.00  0.00           C  
ATOM   1540  CG  LEU A 100      48.436 -16.350  10.363  1.00  0.00           C  
ATOM   1541  CD1 LEU A 100      46.963 -15.996  10.225  1.00  0.00           C  
ATOM   1542  CD2 LEU A 100      48.670 -17.195  11.605  1.00  0.00           C  
ATOM   1543  H   LEU A 100      50.064 -17.749   6.946  1.00  0.00           H  
ATOM   1544  HA  LEU A 100      47.636 -16.433   7.539  1.00  0.00           H  
ATOM   1545  HB2 LEU A 100      48.436 -18.041   9.077  1.00  0.00           H  
ATOM   1546  HB3 LEU A 100      49.995 -17.233   9.218  1.00  0.00           H  
ATOM   1547  HG  LEU A 100      48.991 -15.428  10.475  1.00  0.00           H  
ATOM   1548 HD11 LEU A 100      46.633 -15.480  11.114  1.00  0.00           H  
ATOM   1549 HD12 LEU A 100      46.386 -16.900  10.100  1.00  0.00           H  
ATOM   1550 HD13 LEU A 100      46.824 -15.358   9.365  1.00  0.00           H  
ATOM   1551 HD21 LEU A 100      47.801 -17.146  12.244  1.00  0.00           H  
ATOM   1552 HD22 LEU A 100      49.531 -16.820  12.139  1.00  0.00           H  
ATOM   1553 HD23 LEU A 100      48.846 -18.221  11.315  1.00  0.00           H  
ATOM   1554  N   LEU A 101      50.387 -14.660   7.982  1.00  0.00           N  
ATOM   1555  CA  LEU A 101      50.901 -13.299   8.089  1.00  0.00           C  
ATOM   1556  C   LEU A 101      50.225 -12.380   7.077  1.00  0.00           C  
ATOM   1557  O   LEU A 101      49.766 -11.292   7.422  1.00  0.00           O  
ATOM   1558  CB  LEU A 101      52.416 -13.286   7.874  1.00  0.00           C  
ATOM   1559  CG  LEU A 101      53.063 -11.907   7.741  1.00  0.00           C  
ATOM   1560  CD1 LEU A 101      53.180 -11.239   9.103  1.00  0.00           C  
ATOM   1561  CD2 LEU A 101      54.429 -12.020   7.082  1.00  0.00           C  
ATOM   1562  H   LEU A 101      51.019 -15.409   7.978  1.00  0.00           H  
ATOM   1563  HA  LEU A 101      50.684 -12.940   9.084  1.00  0.00           H  
ATOM   1564  HB2 LEU A 101      52.873 -13.786   8.713  1.00  0.00           H  
ATOM   1565  HB3 LEU A 101      52.625 -13.839   6.970  1.00  0.00           H  
ATOM   1566  HG  LEU A 101      52.440 -11.282   7.117  1.00  0.00           H  
ATOM   1567 HD11 LEU A 101      52.266 -10.711   9.325  1.00  0.00           H  
ATOM   1568 HD12 LEU A 101      54.006 -10.542   9.092  1.00  0.00           H  
ATOM   1569 HD13 LEU A 101      53.355 -11.991   9.859  1.00  0.00           H  
ATOM   1570 HD21 LEU A 101      54.682 -11.081   6.613  1.00  0.00           H  
ATOM   1571 HD22 LEU A 101      54.405 -12.801   6.336  1.00  0.00           H  
ATOM   1572 HD23 LEU A 101      55.172 -12.262   7.830  1.00  0.00           H  
ATOM   1573  N   GLN A 102      50.164 -12.828   5.826  1.00  0.00           N  
ATOM   1574  CA  GLN A 102      49.542 -12.046   4.765  1.00  0.00           C  
ATOM   1575  C   GLN A 102      48.027 -12.005   4.935  1.00  0.00           C  
ATOM   1576  O   GLN A 102      47.359 -11.109   4.419  1.00  0.00           O  
ATOM   1577  CB  GLN A 102      49.898 -12.632   3.396  1.00  0.00           C  
ATOM   1578  CG  GLN A 102      49.271 -13.992   3.135  1.00  0.00           C  
ATOM   1579  CD  GLN A 102      49.078 -14.272   1.659  1.00  0.00           C  
ATOM   1580  OE1 GLN A 102      49.420 -13.450   0.809  1.00  0.00           O  
ATOM   1581  NE2 GLN A 102      48.526 -15.439   1.344  1.00  0.00           N  
ATOM   1582  H   GLN A 102      50.548 -13.704   5.614  1.00  0.00           H  
ATOM   1583  HA  GLN A 102      49.926 -11.039   4.825  1.00  0.00           H  
ATOM   1584  HB2 GLN A 102      49.561 -11.951   2.628  1.00  0.00           H  
ATOM   1585  HB3 GLN A 102      50.971 -12.734   3.330  1.00  0.00           H  
ATOM   1586  HG2 GLN A 102      49.915 -14.756   3.550  1.00  0.00           H  
ATOM   1587  HG3 GLN A 102      48.309 -14.031   3.625  1.00  0.00           H  
ATOM   1588 HE21 GLN A 102      48.278 -16.044   2.074  1.00  0.00           H  
ATOM   1589 HE22 GLN A 102      48.388 -15.645   0.398  1.00  0.00           H  
ATOM   1590  N   ASP A 103      47.492 -12.980   5.661  1.00  0.00           N  
ATOM   1591  CA  ASP A 103      46.056 -13.055   5.901  1.00  0.00           C  
ATOM   1592  C   ASP A 103      45.626 -12.038   6.954  1.00  0.00           C  
ATOM   1593  O   ASP A 103      44.507 -11.525   6.917  1.00  0.00           O  
ATOM   1594  CB  ASP A 103      45.664 -14.465   6.346  1.00  0.00           C  
ATOM   1595  CG  ASP A 103      44.268 -14.846   5.896  1.00  0.00           C  
ATOM   1596  OD1 ASP A 103      43.303 -14.541   6.628  1.00  0.00           O  
ATOM   1597  OD2 ASP A 103      44.139 -15.452   4.811  1.00  0.00           O  
ATOM   1598  H   ASP A 103      48.078 -13.666   6.046  1.00  0.00           H  
ATOM   1599  HA  ASP A 103      45.553 -12.827   4.973  1.00  0.00           H  
ATOM   1600  HB2 ASP A 103      46.363 -15.174   5.929  1.00  0.00           H  
ATOM   1601  HB3 ASP A 103      45.703 -14.519   7.425  1.00  0.00           H  
ATOM   1602  N   LEU A 104      46.523 -11.750   7.891  1.00  0.00           N  
ATOM   1603  CA  LEU A 104      46.238 -10.794   8.956  1.00  0.00           C  
ATOM   1604  C   LEU A 104      46.500  -9.366   8.490  1.00  0.00           C  
ATOM   1605  O   LEU A 104      45.596  -8.531   8.480  1.00  0.00           O  
ATOM   1606  CB  LEU A 104      47.088 -11.105  10.189  1.00  0.00           C  
ATOM   1607  CG  LEU A 104      47.203 -12.582  10.570  1.00  0.00           C  
ATOM   1608  CD1 LEU A 104      48.523 -12.850  11.275  1.00  0.00           C  
ATOM   1609  CD2 LEU A 104      46.033 -12.997  11.450  1.00  0.00           C  
ATOM   1610  H   LEU A 104      47.398 -12.191   7.868  1.00  0.00           H  
ATOM   1611  HA  LEU A 104      45.193 -10.890   9.215  1.00  0.00           H  
ATOM   1612  HB2 LEU A 104      48.084 -10.733  10.005  1.00  0.00           H  
ATOM   1613  HB3 LEU A 104      46.658 -10.578  11.028  1.00  0.00           H  
ATOM   1614  HG  LEU A 104      47.176 -13.182   9.672  1.00  0.00           H  
ATOM   1615 HD11 LEU A 104      48.438 -13.745  11.872  1.00  0.00           H  
ATOM   1616 HD12 LEU A 104      48.768 -12.013  11.912  1.00  0.00           H  
ATOM   1617 HD13 LEU A 104      49.304 -12.981  10.538  1.00  0.00           H  
ATOM   1618 HD21 LEU A 104      45.227 -13.361  10.830  1.00  0.00           H  
ATOM   1619 HD22 LEU A 104      45.692 -12.146  12.021  1.00  0.00           H  
ATOM   1620 HD23 LEU A 104      46.350 -13.779  12.125  1.00  0.00           H  
ATOM   1621  N   MET A 105      47.742  -9.093   8.103  1.00  0.00           N  
ATOM   1622  CA  MET A 105      48.121  -7.767   7.632  1.00  0.00           C  
ATOM   1623  C   MET A 105      47.144  -7.264   6.575  1.00  0.00           C  
ATOM   1624  O   MET A 105      46.904  -6.063   6.460  1.00  0.00           O  
ATOM   1625  CB  MET A 105      49.541  -7.792   7.062  1.00  0.00           C  
ATOM   1626  CG  MET A 105      49.674  -8.630   5.801  1.00  0.00           C  
ATOM   1627  SD  MET A 105      51.392  -8.950   5.357  1.00  0.00           S  
ATOM   1628  CE  MET A 105      51.992  -7.282   5.101  1.00  0.00           C  
ATOM   1629  H   MET A 105      48.419  -9.801   8.134  1.00  0.00           H  
ATOM   1630  HA  MET A 105      48.095  -7.096   8.477  1.00  0.00           H  
ATOM   1631  HB2 MET A 105      49.840  -6.781   6.829  1.00  0.00           H  
ATOM   1632  HB3 MET A 105      50.210  -8.194   7.807  1.00  0.00           H  
ATOM   1633  HG2 MET A 105      49.177  -9.576   5.958  1.00  0.00           H  
ATOM   1634  HG3 MET A 105      49.197  -8.106   4.985  1.00  0.00           H  
ATOM   1635  HE1 MET A 105      51.419  -6.811   4.313  1.00  0.00           H  
ATOM   1636  HE2 MET A 105      51.882  -6.716   6.013  1.00  0.00           H  
ATOM   1637  HE3 MET A 105      53.034  -7.314   4.819  1.00  0.00           H  
ATOM   1638  N   GLN A 106      46.584  -8.192   5.805  1.00  0.00           N  
ATOM   1639  CA  GLN A 106      45.633  -7.842   4.756  1.00  0.00           C  
ATOM   1640  C   GLN A 106      44.260  -7.536   5.345  1.00  0.00           C  
ATOM   1641  O   GLN A 106      43.605  -6.570   4.950  1.00  0.00           O  
ATOM   1642  CB  GLN A 106      45.522  -8.979   3.739  1.00  0.00           C  
ATOM   1643  CG  GLN A 106      44.776 -10.194   4.264  1.00  0.00           C  
ATOM   1644  CD  GLN A 106      44.607 -11.274   3.213  1.00  0.00           C  
ATOM   1645  OE1 GLN A 106      45.462 -11.451   2.345  1.00  0.00           O  
ATOM   1646  NE2 GLN A 106      43.499 -12.003   3.285  1.00  0.00           N  
ATOM   1647  H   GLN A 106      46.815  -9.133   5.945  1.00  0.00           H  
ATOM   1648  HA  GLN A 106      46.002  -6.959   4.257  1.00  0.00           H  
ATOM   1649  HB2 GLN A 106      45.004  -8.614   2.864  1.00  0.00           H  
ATOM   1650  HB3 GLN A 106      46.516  -9.289   3.454  1.00  0.00           H  
ATOM   1651  HG2 GLN A 106      45.327 -10.607   5.095  1.00  0.00           H  
ATOM   1652  HG3 GLN A 106      43.798  -9.883   4.600  1.00  0.00           H  
ATOM   1653 HE21 GLN A 106      42.861 -11.805   4.004  1.00  0.00           H  
ATOM   1654 HE22 GLN A 106      43.364 -12.706   2.619  1.00  0.00           H  
ATOM   1655  N   CYS A 107      43.831  -8.363   6.292  1.00  0.00           N  
ATOM   1656  CA  CYS A 107      42.535  -8.180   6.936  1.00  0.00           C  
ATOM   1657  C   CYS A 107      42.270  -6.705   7.219  1.00  0.00           C  
ATOM   1658  O   CYS A 107      41.121  -6.271   7.274  1.00  0.00           O  
ATOM   1659  CB  CYS A 107      42.472  -8.982   8.238  1.00  0.00           C  
ATOM   1660  SG  CYS A 107      42.028 -10.720   8.015  1.00  0.00           S  
ATOM   1661  H   CYS A 107      44.398  -9.114   6.566  1.00  0.00           H  
ATOM   1662  HA  CYS A 107      41.777  -8.547   6.262  1.00  0.00           H  
ATOM   1663  HB2 CYS A 107      43.438  -8.949   8.718  1.00  0.00           H  
ATOM   1664  HB3 CYS A 107      41.737  -8.534   8.891  1.00  0.00           H  
ATOM   1665  HG  CYS A 107      41.639 -10.884   6.759  1.00  0.00           H  
ATOM   1666  N   ASN A 108      43.342  -5.941   7.400  1.00  0.00           N  
ATOM   1667  CA  ASN A 108      43.226  -4.515   7.679  1.00  0.00           C  
ATOM   1668  C   ASN A 108      42.625  -3.774   6.488  1.00  0.00           C  
ATOM   1669  O   ASN A 108      42.942  -4.068   5.336  1.00  0.00           O  
ATOM   1670  CB  ASN A 108      44.597  -3.927   8.019  1.00  0.00           C  
ATOM   1671  CG  ASN A 108      44.500  -2.744   8.964  1.00  0.00           C  
ATOM   1672  OD1 ASN A 108      44.231  -2.906  10.154  1.00  0.00           O  
ATOM   1673  ND2 ASN A 108      44.721  -1.546   8.436  1.00  0.00           N  
ATOM   1674  H   ASN A 108      44.233  -6.346   7.344  1.00  0.00           H  
ATOM   1675  HA  ASN A 108      42.572  -4.396   8.529  1.00  0.00           H  
ATOM   1676  HB2 ASN A 108      45.202  -4.689   8.488  1.00  0.00           H  
ATOM   1677  HB3 ASN A 108      45.078  -3.601   7.109  1.00  0.00           H  
ATOM   1678 HD21 ASN A 108      44.929  -1.493   7.480  1.00  0.00           H  
ATOM   1679 HD22 ASN A 108      44.665  -0.764   9.024  1.00  0.00           H  
ATOM   1680  N   SER A 109      41.755  -2.812   6.775  1.00  0.00           N  
ATOM   1681  CA  SER A 109      41.105  -2.031   5.728  1.00  0.00           C  
ATOM   1682  C   SER A 109      42.138  -1.286   4.888  1.00  0.00           C  
ATOM   1683  O   SER A 109      42.595  -0.206   5.260  1.00  0.00           O  
ATOM   1684  CB  SER A 109      40.118  -1.037   6.342  1.00  0.00           C  
ATOM   1685  OG  SER A 109      39.340  -0.405   5.340  1.00  0.00           O  
ATOM   1686  H   SER A 109      41.541  -2.625   7.714  1.00  0.00           H  
ATOM   1687  HA  SER A 109      40.565  -2.715   5.091  1.00  0.00           H  
ATOM   1688  HB2 SER A 109      39.458  -1.560   7.018  1.00  0.00           H  
ATOM   1689  HB3 SER A 109      40.665  -0.280   6.887  1.00  0.00           H  
ATOM   1690  HG  SER A 109      38.584  -0.958   5.126  1.00  0.00           H  
ATOM   1691  N   ILE A 110      42.500  -1.873   3.751  1.00  0.00           N  
ATOM   1692  CA  ILE A 110      43.476  -1.265   2.856  1.00  0.00           C  
ATOM   1693  C   ILE A 110      43.136  -1.548   1.397  1.00  0.00           C  
ATOM   1694  O   ILE A 110      42.723  -2.654   1.049  1.00  0.00           O  
ATOM   1695  CB  ILE A 110      44.901  -1.774   3.148  1.00  0.00           C  
ATOM   1696  CG1 ILE A 110      45.342  -1.344   4.549  1.00  0.00           C  
ATOM   1697  CG2 ILE A 110      45.873  -1.258   2.097  1.00  0.00           C  
ATOM   1698  CD1 ILE A 110      45.978   0.029   4.587  1.00  0.00           C  
ATOM   1699  H   ILE A 110      42.099  -2.733   3.509  1.00  0.00           H  
ATOM   1700  HA  ILE A 110      43.457  -0.196   3.019  1.00  0.00           H  
ATOM   1701  HB  ILE A 110      44.891  -2.852   3.096  1.00  0.00           H  
ATOM   1702 HG12 ILE A 110      44.484  -1.329   5.202  1.00  0.00           H  
ATOM   1703 HG13 ILE A 110      46.064  -2.055   4.924  1.00  0.00           H  
ATOM   1704 HG21 ILE A 110      45.548  -0.288   1.753  1.00  0.00           H  
ATOM   1705 HG22 ILE A 110      46.859  -1.174   2.531  1.00  0.00           H  
ATOM   1706 HG23 ILE A 110      45.901  -1.945   1.265  1.00  0.00           H  
ATOM   1707 HD11 ILE A 110      45.735   0.512   5.522  1.00  0.00           H  
ATOM   1708 HD12 ILE A 110      47.050  -0.068   4.500  1.00  0.00           H  
ATOM   1709 HD13 ILE A 110      45.601   0.622   3.768  1.00  0.00           H  
ATOM   1710  N   ASN A 111      43.314  -0.541   0.547  1.00  0.00           N  
ATOM   1711  CA  ASN A 111      43.027  -0.683  -0.876  1.00  0.00           C  
ATOM   1712  C   ASN A 111      44.163  -1.409  -1.590  1.00  0.00           C  
ATOM   1713  O   ASN A 111      45.306  -0.953  -1.586  1.00  0.00           O  
ATOM   1714  CB  ASN A 111      42.806   0.691  -1.512  1.00  0.00           C  
ATOM   1715  CG  ASN A 111      41.397   1.208  -1.296  1.00  0.00           C  
ATOM   1716  OD1 ASN A 111      40.562   0.533  -0.692  1.00  0.00           O  
ATOM   1717  ND2 ASN A 111      41.126   2.410  -1.790  1.00  0.00           N  
ATOM   1718  H   ASN A 111      43.646   0.316   0.885  1.00  0.00           H  
ATOM   1719  HA  ASN A 111      42.124  -1.265  -0.976  1.00  0.00           H  
ATOM   1720  HB2 ASN A 111      43.498   1.398  -1.077  1.00  0.00           H  
ATOM   1721  HB3 ASN A 111      42.987   0.623  -2.573  1.00  0.00           H  
ATOM   1722 HD21 ASN A 111      41.840   2.890  -2.259  1.00  0.00           H  
ATOM   1723 HD22 ASN A 111      40.222   2.769  -1.664  1.00  0.00           H  
ATOM   1724  N   VAL A 112      43.839  -2.543  -2.203  1.00  0.00           N  
ATOM   1725  CA  VAL A 112      44.831  -3.334  -2.924  1.00  0.00           C  
ATOM   1726  C   VAL A 112      44.317  -3.737  -4.301  1.00  0.00           C  
ATOM   1727  O   VAL A 112      43.165  -4.144  -4.450  1.00  0.00           O  
ATOM   1728  CB  VAL A 112      45.215  -4.601  -2.140  1.00  0.00           C  
ATOM   1729  CG1 VAL A 112      44.040  -5.564  -2.070  1.00  0.00           C  
ATOM   1730  CG2 VAL A 112      46.426  -5.271  -2.772  1.00  0.00           C  
ATOM   1731  H   VAL A 112      42.911  -2.856  -2.171  1.00  0.00           H  
ATOM   1732  HA  VAL A 112      45.716  -2.727  -3.044  1.00  0.00           H  
ATOM   1733  HB  VAL A 112      45.475  -4.313  -1.132  1.00  0.00           H  
ATOM   1734 HG11 VAL A 112      43.116  -5.012  -2.163  1.00  0.00           H  
ATOM   1735 HG12 VAL A 112      44.113  -6.282  -2.874  1.00  0.00           H  
ATOM   1736 HG13 VAL A 112      44.054  -6.082  -1.122  1.00  0.00           H  
ATOM   1737 HG21 VAL A 112      46.211  -5.508  -3.802  1.00  0.00           H  
ATOM   1738 HG22 VAL A 112      47.272  -4.601  -2.725  1.00  0.00           H  
ATOM   1739 HG23 VAL A 112      46.658  -6.180  -2.234  1.00  0.00           H  
ATOM   1740  N   MET A 113      45.179  -3.620  -5.306  1.00  0.00           N  
ATOM   1741  CA  MET A 113      44.812  -3.974  -6.673  1.00  0.00           C  
ATOM   1742  C   MET A 113      45.849  -4.908  -7.289  1.00  0.00           C  
ATOM   1743  O   MET A 113      46.831  -5.273  -6.641  1.00  0.00           O  
ATOM   1744  CB  MET A 113      44.670  -2.714  -7.528  1.00  0.00           C  
ATOM   1745  CG  MET A 113      45.780  -1.700  -7.304  1.00  0.00           C  
ATOM   1746  SD  MET A 113      47.178  -1.943  -8.418  1.00  0.00           S  
ATOM   1747  CE  MET A 113      48.220  -0.559  -7.961  1.00  0.00           C  
ATOM   1748  H   MET A 113      46.083  -3.288  -5.125  1.00  0.00           H  
ATOM   1749  HA  MET A 113      43.862  -4.484  -6.638  1.00  0.00           H  
ATOM   1750  HB2 MET A 113      44.676  -2.999  -8.570  1.00  0.00           H  
ATOM   1751  HB3 MET A 113      43.728  -2.240  -7.298  1.00  0.00           H  
ATOM   1752  HG2 MET A 113      45.381  -0.709  -7.462  1.00  0.00           H  
ATOM   1753  HG3 MET A 113      46.129  -1.787  -6.286  1.00  0.00           H  
ATOM   1754  HE1 MET A 113      48.051  -0.310  -6.923  1.00  0.00           H  
ATOM   1755  HE2 MET A 113      49.256  -0.826  -8.103  1.00  0.00           H  
ATOM   1756  HE3 MET A 113      47.978   0.293  -8.579  1.00  0.00           H  
ATOM   1757  N   GLU A 114      45.625  -5.289  -8.542  1.00  0.00           N  
ATOM   1758  CA  GLU A 114      46.541  -6.182  -9.244  1.00  0.00           C  
ATOM   1759  C   GLU A 114      47.486  -5.393 -10.145  1.00  0.00           C  
ATOM   1760  O   GLU A 114      47.053  -4.535 -10.914  1.00  0.00           O  
ATOM   1761  CB  GLU A 114      45.758  -7.200 -10.075  1.00  0.00           C  
ATOM   1762  CG  GLU A 114      45.121  -6.609 -11.321  1.00  0.00           C  
ATOM   1763  CD  GLU A 114      44.426  -7.652 -12.174  1.00  0.00           C  
ATOM   1764  OE1 GLU A 114      43.655  -8.458 -11.612  1.00  0.00           O  
ATOM   1765  OE2 GLU A 114      44.654  -7.664 -13.401  1.00  0.00           O  
ATOM   1766  H   GLU A 114      44.825  -4.964  -9.005  1.00  0.00           H  
ATOM   1767  HA  GLU A 114      47.124  -6.707  -8.503  1.00  0.00           H  
ATOM   1768  HB2 GLU A 114      46.429  -7.991 -10.379  1.00  0.00           H  
ATOM   1769  HB3 GLU A 114      44.975  -7.622  -9.462  1.00  0.00           H  
ATOM   1770  HG2 GLU A 114      44.394  -5.868 -11.023  1.00  0.00           H  
ATOM   1771  HG3 GLU A 114      45.891  -6.136 -11.913  1.00  0.00           H  
ATOM   1772  N   GLU A 115      48.778  -5.688 -10.041  1.00  0.00           N  
ATOM   1773  CA  GLU A 115      49.784  -5.005 -10.845  1.00  0.00           C  
ATOM   1774  C   GLU A 115      50.876  -5.975 -11.290  1.00  0.00           C  
ATOM   1775  O   GLU A 115      51.236  -6.911 -10.578  1.00  0.00           O  
ATOM   1776  CB  GLU A 115      50.404  -3.851 -10.053  1.00  0.00           C  
ATOM   1777  CG  GLU A 115      51.311  -4.306  -8.923  1.00  0.00           C  
ATOM   1778  CD  GLU A 115      51.518  -3.231  -7.873  1.00  0.00           C  
ATOM   1779  OE1 GLU A 115      51.992  -2.134  -8.234  1.00  0.00           O  
ATOM   1780  OE2 GLU A 115      51.208  -3.488  -6.691  1.00  0.00           O  
ATOM   1781  H   GLU A 115      49.060  -6.382  -9.409  1.00  0.00           H  
ATOM   1782  HA  GLU A 115      49.295  -4.607 -11.721  1.00  0.00           H  
ATOM   1783  HB2 GLU A 115      50.983  -3.238 -10.729  1.00  0.00           H  
ATOM   1784  HB3 GLU A 115      49.609  -3.253  -9.632  1.00  0.00           H  
ATOM   1785  HG2 GLU A 115      50.869  -5.169  -8.449  1.00  0.00           H  
ATOM   1786  HG3 GLU A 115      52.272  -4.575  -9.336  1.00  0.00           H  
ATOM   1787  N   PRO A 116      51.414  -5.746 -12.497  1.00  0.00           N  
ATOM   1788  CA  PRO A 116      52.471  -6.587 -13.065  1.00  0.00           C  
ATOM   1789  C   PRO A 116      53.799  -6.423 -12.332  1.00  0.00           C  
ATOM   1790  O   PRO A 116      54.144  -5.327 -11.890  1.00  0.00           O  
ATOM   1791  CB  PRO A 116      52.589  -6.084 -14.506  1.00  0.00           C  
ATOM   1792  CG  PRO A 116      52.101  -4.678 -14.458  1.00  0.00           C  
ATOM   1793  CD  PRO A 116      51.032  -4.646 -13.400  1.00  0.00           C  
ATOM   1794  HA  PRO A 116      52.189  -7.630 -13.068  1.00  0.00           H  
ATOM   1795  HB2 PRO A 116      53.621  -6.134 -14.823  1.00  0.00           H  
ATOM   1796  HB3 PRO A 116      51.977  -6.692 -15.154  1.00  0.00           H  
ATOM   1797  HG2 PRO A 116      52.911  -4.016 -14.191  1.00  0.00           H  
ATOM   1798  HG3 PRO A 116      51.687  -4.400 -15.415  1.00  0.00           H  
ATOM   1799  HD2 PRO A 116      51.043  -3.700 -12.881  1.00  0.00           H  
ATOM   1800  HD3 PRO A 116      50.062  -4.828 -13.838  1.00  0.00           H  
ATOM   1801  N   VAL A 117      54.541  -7.519 -12.209  1.00  0.00           N  
ATOM   1802  CA  VAL A 117      55.832  -7.496 -11.533  1.00  0.00           C  
ATOM   1803  C   VAL A 117      56.892  -6.818 -12.393  1.00  0.00           C  
ATOM   1804  O   VAL A 117      56.890  -6.952 -13.617  1.00  0.00           O  
ATOM   1805  CB  VAL A 117      56.306  -8.918 -11.179  1.00  0.00           C  
ATOM   1806  CG1 VAL A 117      57.657  -8.873 -10.482  1.00  0.00           C  
ATOM   1807  CG2 VAL A 117      55.274  -9.624 -10.313  1.00  0.00           C  
ATOM   1808  H   VAL A 117      54.212  -8.363 -12.583  1.00  0.00           H  
ATOM   1809  HA  VAL A 117      55.718  -6.938 -10.613  1.00  0.00           H  
ATOM   1810  HB  VAL A 117      56.418  -9.477 -12.097  1.00  0.00           H  
ATOM   1811 HG11 VAL A 117      57.802  -9.784  -9.919  1.00  0.00           H  
ATOM   1812 HG12 VAL A 117      58.440  -8.775 -11.220  1.00  0.00           H  
ATOM   1813 HG13 VAL A 117      57.687  -8.028  -9.811  1.00  0.00           H  
ATOM   1814 HG21 VAL A 117      55.754 -10.406  -9.744  1.00  0.00           H  
ATOM   1815 HG22 VAL A 117      54.822  -8.911  -9.638  1.00  0.00           H  
ATOM   1816 HG23 VAL A 117      54.509 -10.055 -10.943  1.00  0.00           H  
ATOM   1817  N   ILE A 118      57.795  -6.090 -11.746  1.00  0.00           N  
ATOM   1818  CA  ILE A 118      58.862  -5.392 -12.452  1.00  0.00           C  
ATOM   1819  C   ILE A 118      60.233  -5.842 -11.960  1.00  0.00           C  
ATOM   1820  O   ILE A 118      60.429  -6.076 -10.767  1.00  0.00           O  
ATOM   1821  CB  ILE A 118      58.744  -3.865 -12.283  1.00  0.00           C  
ATOM   1822  CG1 ILE A 118      57.411  -3.369 -12.847  1.00  0.00           C  
ATOM   1823  CG2 ILE A 118      59.908  -3.166 -12.969  1.00  0.00           C  
ATOM   1824  CD1 ILE A 118      57.260  -3.601 -14.334  1.00  0.00           C  
ATOM   1825  H   ILE A 118      57.743  -6.021 -10.770  1.00  0.00           H  
ATOM   1826  HA  ILE A 118      58.774  -5.626 -13.504  1.00  0.00           H  
ATOM   1827  HB  ILE A 118      58.789  -3.638 -11.229  1.00  0.00           H  
ATOM   1828 HG12 ILE A 118      56.604  -3.882 -12.348  1.00  0.00           H  
ATOM   1829 HG13 ILE A 118      57.325  -2.308 -12.665  1.00  0.00           H  
ATOM   1830 HG21 ILE A 118      60.198  -3.725 -13.847  1.00  0.00           H  
ATOM   1831 HG22 ILE A 118      59.608  -2.170 -13.261  1.00  0.00           H  
ATOM   1832 HG23 ILE A 118      60.744  -3.105 -12.288  1.00  0.00           H  
ATOM   1833 HD11 ILE A 118      56.369  -4.183 -14.519  1.00  0.00           H  
ATOM   1834 HD12 ILE A 118      57.179  -2.650 -14.841  1.00  0.00           H  
ATOM   1835 HD13 ILE A 118      58.121  -4.135 -14.705  1.00  0.00           H  
ATOM   1836  N   ILE A 119      61.179  -5.959 -12.886  1.00  0.00           N  
ATOM   1837  CA  ILE A 119      62.533  -6.379 -12.546  1.00  0.00           C  
ATOM   1838  C   ILE A 119      63.098  -5.538 -11.406  1.00  0.00           C  
ATOM   1839  O   ILE A 119      62.902  -4.323 -11.358  1.00  0.00           O  
ATOM   1840  CB  ILE A 119      63.474  -6.278 -13.760  1.00  0.00           C  
ATOM   1841  CG1 ILE A 119      62.948  -7.133 -14.914  1.00  0.00           C  
ATOM   1842  CG2 ILE A 119      64.883  -6.708 -13.375  1.00  0.00           C  
ATOM   1843  CD1 ILE A 119      63.407  -6.660 -16.276  1.00  0.00           C  
ATOM   1844  H   ILE A 119      60.961  -5.759 -13.820  1.00  0.00           H  
ATOM   1845  HA  ILE A 119      62.492  -7.412 -12.232  1.00  0.00           H  
ATOM   1846  HB  ILE A 119      63.512  -5.246 -14.074  1.00  0.00           H  
ATOM   1847 HG12 ILE A 119      63.287  -8.149 -14.785  1.00  0.00           H  
ATOM   1848 HG13 ILE A 119      61.868  -7.114 -14.902  1.00  0.00           H  
ATOM   1849 HG21 ILE A 119      65.555  -6.518 -14.199  1.00  0.00           H  
ATOM   1850 HG22 ILE A 119      65.206  -6.147 -12.510  1.00  0.00           H  
ATOM   1851 HG23 ILE A 119      64.887  -7.762 -13.143  1.00  0.00           H  
ATOM   1852 HD11 ILE A 119      63.015  -5.670 -16.463  1.00  0.00           H  
ATOM   1853 HD12 ILE A 119      64.487  -6.628 -16.301  1.00  0.00           H  
ATOM   1854 HD13 ILE A 119      63.048  -7.338 -17.034  1.00  0.00           H  
ATOM   1855  N   THR A 120      63.805  -6.192 -10.490  1.00  0.00           N  
ATOM   1856  CA  THR A 120      64.400  -5.505  -9.350  1.00  0.00           C  
ATOM   1857  C   THR A 120      65.918  -5.443  -9.478  1.00  0.00           C  
ATOM   1858  O   THR A 120      66.567  -6.445  -9.781  1.00  0.00           O  
ATOM   1859  CB  THR A 120      64.036  -6.199  -8.024  1.00  0.00           C  
ATOM   1860  OG1 THR A 120      62.614  -6.312  -7.904  1.00  0.00           O  
ATOM   1861  CG2 THR A 120      64.589  -5.423  -6.838  1.00  0.00           C  
ATOM   1862  H   THR A 120      63.926  -7.160 -10.583  1.00  0.00           H  
ATOM   1863  HA  THR A 120      64.008  -4.499  -9.326  1.00  0.00           H  
ATOM   1864  HB  THR A 120      64.469  -7.189  -8.021  1.00  0.00           H  
ATOM   1865  HG1 THR A 120      62.304  -7.043  -8.445  1.00  0.00           H  
ATOM   1866 HG21 THR A 120      63.846  -5.383  -6.056  1.00  0.00           H  
ATOM   1867 HG22 THR A 120      64.837  -4.419  -7.149  1.00  0.00           H  
ATOM   1868 HG23 THR A 120      65.476  -5.915  -6.467  1.00  0.00           H  
ATOM   1869  N   SER A 121      66.479  -4.261  -9.243  1.00  0.00           N  
ATOM   1870  CA  SER A 121      67.921  -4.068  -9.336  1.00  0.00           C  
ATOM   1871  C   SER A 121      68.574  -4.191  -7.963  1.00  0.00           C  
ATOM   1872  O   SER A 121      67.987  -3.820  -6.948  1.00  0.00           O  
ATOM   1873  CB  SER A 121      68.236  -2.698  -9.941  1.00  0.00           C  
ATOM   1874  OG  SER A 121      67.805  -1.652  -9.088  1.00  0.00           O  
ATOM   1875  H   SER A 121      65.908  -3.501  -9.006  1.00  0.00           H  
ATOM   1876  HA  SER A 121      68.318  -4.838  -9.981  1.00  0.00           H  
ATOM   1877  HB2 SER A 121      69.301  -2.609 -10.091  1.00  0.00           H  
ATOM   1878  HB3 SER A 121      67.730  -2.604 -10.891  1.00  0.00           H  
ATOM   1879  HG  SER A 121      67.387  -2.026  -8.309  1.00  0.00           H  
ATOM   1880  N   GLY A 122      69.795  -4.719  -7.941  1.00  0.00           N  
ATOM   1881  CA  GLY A 122      70.509  -4.883  -6.688  1.00  0.00           C  
ATOM   1882  C   GLY A 122      71.282  -3.640  -6.293  1.00  0.00           C  
ATOM   1883  O   GLY A 122      70.883  -2.522  -6.621  1.00  0.00           O  
ATOM   1884  H   GLY A 122      70.214  -4.998  -8.781  1.00  0.00           H  
ATOM   1885  HA2 GLY A 122      69.799  -5.114  -5.909  1.00  0.00           H  
ATOM   1886  HA3 GLY A 122      71.201  -5.707  -6.786  1.00  0.00           H  
ATOM   1887  N   SER A 123      72.391  -3.834  -5.588  1.00  0.00           N  
ATOM   1888  CA  SER A 123      73.220  -2.719  -5.143  1.00  0.00           C  
ATOM   1889  C   SER A 123      74.598  -2.773  -5.796  1.00  0.00           C  
ATOM   1890  O   SER A 123      74.926  -3.726  -6.503  1.00  0.00           O  
ATOM   1891  CB  SER A 123      73.363  -2.738  -3.621  1.00  0.00           C  
ATOM   1892  OG  SER A 123      72.186  -2.263  -2.992  1.00  0.00           O  
ATOM   1893  H   SER A 123      72.658  -4.749  -5.358  1.00  0.00           H  
ATOM   1894  HA  SER A 123      72.730  -1.804  -5.439  1.00  0.00           H  
ATOM   1895  HB2 SER A 123      73.551  -3.748  -3.292  1.00  0.00           H  
ATOM   1896  HB3 SER A 123      74.190  -2.106  -3.332  1.00  0.00           H  
ATOM   1897  HG  SER A 123      71.436  -2.794  -3.273  1.00  0.00           H  
ATOM   1898  N   SER A 124      75.401  -1.741  -5.553  1.00  0.00           N  
ATOM   1899  CA  SER A 124      76.743  -1.668  -6.120  1.00  0.00           C  
ATOM   1900  C   SER A 124      77.738  -2.440  -5.260  1.00  0.00           C  
ATOM   1901  O   SER A 124      78.529  -3.235  -5.769  1.00  0.00           O  
ATOM   1902  CB  SER A 124      77.186  -0.209  -6.248  1.00  0.00           C  
ATOM   1903  OG  SER A 124      76.310   0.518  -7.091  1.00  0.00           O  
ATOM   1904  H   SER A 124      75.083  -1.012  -4.982  1.00  0.00           H  
ATOM   1905  HA  SER A 124      76.712  -2.113  -7.103  1.00  0.00           H  
ATOM   1906  HB2 SER A 124      77.190   0.250  -5.271  1.00  0.00           H  
ATOM   1907  HB3 SER A 124      78.182  -0.174  -6.666  1.00  0.00           H  
ATOM   1908  HG  SER A 124      76.051  -0.032  -7.834  1.00  0.00           H  
ATOM   1909  N   GLY A 125      77.694  -2.202  -3.953  1.00  0.00           N  
ATOM   1910  CA  GLY A 125      78.596  -2.882  -3.043  1.00  0.00           C  
ATOM   1911  C   GLY A 125      78.811  -2.111  -1.755  1.00  0.00           C  
ATOM   1912  O   GLY A 125      79.379  -1.020  -1.766  1.00  0.00           O  
ATOM   1913  H   GLY A 125      77.042  -1.558  -3.605  1.00  0.00           H  
ATOM   1914  HA2 GLY A 125      78.186  -3.852  -2.805  1.00  0.00           H  
ATOM   1915  HA3 GLY A 125      79.550  -3.015  -3.532  1.00  0.00           H  
ATOM   1916  N   SER A 126      78.354  -2.679  -0.644  1.00  0.00           N  
ATOM   1917  CA  SER A 126      78.495  -2.034   0.656  1.00  0.00           C  
ATOM   1918  C   SER A 126      78.630  -3.073   1.766  1.00  0.00           C  
ATOM   1919  O   SER A 126      77.852  -4.024   1.840  1.00  0.00           O  
ATOM   1920  CB  SER A 126      77.292  -1.131   0.934  1.00  0.00           C  
ATOM   1921  OG  SER A 126      77.312   0.016   0.101  1.00  0.00           O  
ATOM   1922  H   SER A 126      77.909  -3.551  -0.701  1.00  0.00           H  
ATOM   1923  HA  SER A 126      79.389  -1.431   0.633  1.00  0.00           H  
ATOM   1924  HB2 SER A 126      76.381  -1.679   0.748  1.00  0.00           H  
ATOM   1925  HB3 SER A 126      77.315  -0.812   1.966  1.00  0.00           H  
ATOM   1926  HG  SER A 126      77.089   0.793   0.620  1.00  0.00           H  
ATOM   1927  N   SER A 127      79.626  -2.885   2.625  1.00  0.00           N  
ATOM   1928  CA  SER A 127      79.868  -3.807   3.729  1.00  0.00           C  
ATOM   1929  C   SER A 127      80.338  -3.056   4.971  1.00  0.00           C  
ATOM   1930  O   SER A 127      80.737  -1.895   4.895  1.00  0.00           O  
ATOM   1931  CB  SER A 127      80.910  -4.853   3.327  1.00  0.00           C  
ATOM   1932  OG  SER A 127      82.216  -4.305   3.344  1.00  0.00           O  
ATOM   1933  H   SER A 127      80.213  -2.108   2.514  1.00  0.00           H  
ATOM   1934  HA  SER A 127      78.938  -4.306   3.955  1.00  0.00           H  
ATOM   1935  HB2 SER A 127      80.871  -5.680   4.020  1.00  0.00           H  
ATOM   1936  HB3 SER A 127      80.693  -5.209   2.331  1.00  0.00           H  
ATOM   1937  HG  SER A 127      82.369  -3.818   2.532  1.00  0.00           H  
ATOM   1938  N   GLY A 128      80.286  -3.730   6.116  1.00  0.00           N  
ATOM   1939  CA  GLY A 128      80.708  -3.112   7.360  1.00  0.00           C  
ATOM   1940  C   GLY A 128      81.004  -4.130   8.443  1.00  0.00           C  
ATOM   1941  O   GLY A 128      81.637  -5.153   8.186  1.00  0.00           O  
ATOM   1942  H   GLY A 128      79.957  -4.653   6.117  1.00  0.00           H  
ATOM   1943  HA2 GLY A 128      81.598  -2.529   7.176  1.00  0.00           H  
ATOM   1944  HA3 GLY A 128      79.924  -2.453   7.706  1.00  0.00           H  
ATOM   1945  N   SER A 129      80.546  -3.850   9.659  1.00  0.00           N  
ATOM   1946  CA  SER A 129      80.769  -4.747  10.785  1.00  0.00           C  
ATOM   1947  C   SER A 129      79.695  -4.558  11.853  1.00  0.00           C  
ATOM   1948  O   SER A 129      78.879  -3.639  11.772  1.00  0.00           O  
ATOM   1949  CB  SER A 129      82.153  -4.504  11.391  1.00  0.00           C  
ATOM   1950  OG  SER A 129      82.211  -3.249  12.044  1.00  0.00           O  
ATOM   1951  H   SER A 129      80.047  -3.018   9.801  1.00  0.00           H  
ATOM   1952  HA  SER A 129      80.718  -5.761  10.418  1.00  0.00           H  
ATOM   1953  HB2 SER A 129      82.370  -5.281  12.108  1.00  0.00           H  
ATOM   1954  HB3 SER A 129      82.894  -4.523  10.606  1.00  0.00           H  
ATOM   1955  HG  SER A 129      81.623  -3.255  12.804  1.00  0.00           H  
ATOM   1956  N   SER A 130      79.701  -5.433  12.852  1.00  0.00           N  
ATOM   1957  CA  SER A 130      78.725  -5.366  13.934  1.00  0.00           C  
ATOM   1958  C   SER A 130      78.425  -3.917  14.305  1.00  0.00           C  
ATOM   1959  O   SER A 130      79.238  -3.023  14.071  1.00  0.00           O  
ATOM   1960  CB  SER A 130      79.240  -6.123  15.161  1.00  0.00           C  
ATOM   1961  OG  SER A 130      79.504  -7.480  14.850  1.00  0.00           O  
ATOM   1962  H   SER A 130      80.377  -6.144  12.860  1.00  0.00           H  
ATOM   1963  HA  SER A 130      77.815  -5.834  13.590  1.00  0.00           H  
ATOM   1964  HB2 SER A 130      80.153  -5.662  15.508  1.00  0.00           H  
ATOM   1965  HB3 SER A 130      78.496  -6.082  15.942  1.00  0.00           H  
ATOM   1966  HG  SER A 130      80.448  -7.644  14.908  1.00  0.00           H  
ATOM   1967  N   GLY A 131      77.250  -3.693  14.886  1.00  0.00           N  
ATOM   1968  CA  GLY A 131      76.862  -2.352  15.281  1.00  0.00           C  
ATOM   1969  C   GLY A 131      75.980  -2.342  16.514  1.00  0.00           C  
ATOM   1970  O   GLY A 131      76.443  -2.044  17.615  1.00  0.00           O  
ATOM   1971  H   GLY A 131      76.643  -4.445  15.048  1.00  0.00           H  
ATOM   1972  HA2 GLY A 131      77.753  -1.775  15.484  1.00  0.00           H  
ATOM   1973  HA3 GLY A 131      76.326  -1.890  14.464  1.00  0.00           H  
ATOM   1974  N   SER A 132      74.704  -2.668  16.328  1.00  0.00           N  
ATOM   1975  CA  SER A 132      73.753  -2.690  17.434  1.00  0.00           C  
ATOM   1976  C   SER A 132      73.347  -4.121  17.771  1.00  0.00           C  
ATOM   1977  O   SER A 132      73.599  -5.048  17.001  1.00  0.00           O  
ATOM   1978  CB  SER A 132      72.513  -1.866  17.084  1.00  0.00           C  
ATOM   1979  OG  SER A 132      71.991  -2.239  15.820  1.00  0.00           O  
ATOM   1980  H   SER A 132      74.395  -2.895  15.427  1.00  0.00           H  
ATOM   1981  HA  SER A 132      74.235  -2.252  18.294  1.00  0.00           H  
ATOM   1982  HB2 SER A 132      71.754  -2.026  17.834  1.00  0.00           H  
ATOM   1983  HB3 SER A 132      72.776  -0.818  17.055  1.00  0.00           H  
ATOM   1984  HG  SER A 132      72.331  -1.648  15.145  1.00  0.00           H  
ATOM   1985  N   SER A 133      72.718  -4.294  18.929  1.00  0.00           N  
ATOM   1986  CA  SER A 133      72.280  -5.612  19.374  1.00  0.00           C  
ATOM   1987  C   SER A 133      71.078  -6.087  18.562  1.00  0.00           C  
ATOM   1988  O   SER A 133      70.361  -5.284  17.968  1.00  0.00           O  
ATOM   1989  CB  SER A 133      71.926  -5.580  20.862  1.00  0.00           C  
ATOM   1990  OG  SER A 133      70.819  -4.729  21.104  1.00  0.00           O  
ATOM   1991  H   SER A 133      72.547  -3.515  19.500  1.00  0.00           H  
ATOM   1992  HA  SER A 133      73.097  -6.301  19.222  1.00  0.00           H  
ATOM   1993  HB2 SER A 133      71.676  -6.578  21.191  1.00  0.00           H  
ATOM   1994  HB3 SER A 133      72.775  -5.218  21.423  1.00  0.00           H  
ATOM   1995  HG  SER A 133      70.512  -4.852  22.005  1.00  0.00           H  
ATOM   1996  N   GLY A 134      70.867  -7.400  18.544  1.00  0.00           N  
ATOM   1997  CA  GLY A 134      69.752  -7.959  17.803  1.00  0.00           C  
ATOM   1998  C   GLY A 134      70.098  -9.280  17.144  1.00  0.00           C  
ATOM   1999  O   GLY A 134      71.130  -9.882  17.448  1.00  0.00           O  
ATOM   2000  H   GLY A 134      71.472  -7.991  19.036  1.00  0.00           H  
ATOM   2001  HA2 GLY A 134      68.925  -8.113  18.479  1.00  0.00           H  
ATOM   2002  HA3 GLY A 134      69.453  -7.258  17.039  1.00  0.00           H  
ATOM   2003  N   LEU A 135      69.237  -9.733  16.240  1.00  0.00           N  
ATOM   2004  CA  LEU A 135      69.456 -10.993  15.538  1.00  0.00           C  
ATOM   2005  C   LEU A 135      70.451 -10.812  14.396  1.00  0.00           C  
ATOM   2006  O   LEU A 135      71.001  -9.728  14.203  1.00  0.00           O  
ATOM   2007  CB  LEU A 135      68.132 -11.534  14.996  1.00  0.00           C  
ATOM   2008  CG  LEU A 135      67.188 -12.154  16.026  1.00  0.00           C  
ATOM   2009  CD1 LEU A 135      66.390 -11.073  16.738  1.00  0.00           C  
ATOM   2010  CD2 LEU A 135      66.256 -13.156  15.361  1.00  0.00           C  
ATOM   2011  H   LEU A 135      68.433  -9.210  16.042  1.00  0.00           H  
ATOM   2012  HA  LEU A 135      69.862 -11.700  16.245  1.00  0.00           H  
ATOM   2013  HB2 LEU A 135      67.611 -10.717  14.519  1.00  0.00           H  
ATOM   2014  HB3 LEU A 135      68.362 -12.291  14.259  1.00  0.00           H  
ATOM   2015  HG  LEU A 135      67.771 -12.680  16.769  1.00  0.00           H  
ATOM   2016 HD11 LEU A 135      66.800 -10.104  16.494  1.00  0.00           H  
ATOM   2017 HD12 LEU A 135      66.444 -11.229  17.805  1.00  0.00           H  
ATOM   2018 HD13 LEU A 135      65.359 -11.118  16.419  1.00  0.00           H  
ATOM   2019 HD21 LEU A 135      66.210 -12.958  14.301  1.00  0.00           H  
ATOM   2020 HD22 LEU A 135      65.268 -13.066  15.787  1.00  0.00           H  
ATOM   2021 HD23 LEU A 135      66.628 -14.157  15.525  1.00  0.00           H  
ATOM   2022  N   PHE A 136      70.675 -11.882  13.640  1.00  0.00           N  
ATOM   2023  CA  PHE A 136      71.603 -11.842  12.515  1.00  0.00           C  
ATOM   2024  C   PHE A 136      70.913 -11.319  11.259  1.00  0.00           C  
ATOM   2025  O   PHE A 136      69.887 -11.852  10.833  1.00  0.00           O  
ATOM   2026  CB  PHE A 136      72.179 -13.235  12.252  1.00  0.00           C  
ATOM   2027  CG  PHE A 136      73.296 -13.242  11.247  1.00  0.00           C  
ATOM   2028  CD1 PHE A 136      73.024 -13.316   9.891  1.00  0.00           C  
ATOM   2029  CD2 PHE A 136      74.616 -13.174  11.659  1.00  0.00           C  
ATOM   2030  CE1 PHE A 136      74.048 -13.322   8.963  1.00  0.00           C  
ATOM   2031  CE2 PHE A 136      75.645 -13.180  10.737  1.00  0.00           C  
ATOM   2032  CZ  PHE A 136      75.361 -13.255   9.387  1.00  0.00           C  
ATOM   2033  H   PHE A 136      70.207 -12.718  13.843  1.00  0.00           H  
ATOM   2034  HA  PHE A 136      72.408 -11.172  12.774  1.00  0.00           H  
ATOM   2035  HB2 PHE A 136      72.564 -13.638  13.177  1.00  0.00           H  
ATOM   2036  HB3 PHE A 136      71.394 -13.877  11.883  1.00  0.00           H  
ATOM   2037  HD1 PHE A 136      71.996 -13.369   9.557  1.00  0.00           H  
ATOM   2038  HD2 PHE A 136      74.841 -13.117  12.714  1.00  0.00           H  
ATOM   2039  HE1 PHE A 136      73.823 -13.381   7.909  1.00  0.00           H  
ATOM   2040  HE2 PHE A 136      76.671 -13.128  11.070  1.00  0.00           H  
ATOM   2041  HZ  PHE A 136      76.163 -13.260   8.664  1.00  0.00           H  
ATOM   2042  N   ARG A 137      71.481 -10.273  10.670  1.00  0.00           N  
ATOM   2043  CA  ARG A 137      70.921  -9.676   9.464  1.00  0.00           C  
ATOM   2044  C   ARG A 137      71.619 -10.212   8.217  1.00  0.00           C  
ATOM   2045  O   ARG A 137      72.847 -10.194   8.125  1.00  0.00           O  
ATOM   2046  CB  ARG A 137      71.047  -8.152   9.517  1.00  0.00           C  
ATOM   2047  CG  ARG A 137      70.101  -7.497  10.510  1.00  0.00           C  
ATOM   2048  CD  ARG A 137      70.718  -7.420  11.899  1.00  0.00           C  
ATOM   2049  NE  ARG A 137      71.657  -6.309  12.020  1.00  0.00           N  
ATOM   2050  CZ  ARG A 137      71.297  -5.032  11.960  1.00  0.00           C  
ATOM   2051  NH1 ARG A 137      70.024  -4.706  11.782  1.00  0.00           N  
ATOM   2052  NH2 ARG A 137      72.211  -4.077  12.078  1.00  0.00           N  
ATOM   2053  H   ARG A 137      72.298  -9.892  11.057  1.00  0.00           H  
ATOM   2054  HA  ARG A 137      69.875  -9.940   9.418  1.00  0.00           H  
ATOM   2055  HB2 ARG A 137      72.059  -7.896   9.794  1.00  0.00           H  
ATOM   2056  HB3 ARG A 137      70.838  -7.751   8.536  1.00  0.00           H  
ATOM   2057  HG2 ARG A 137      69.876  -6.497  10.173  1.00  0.00           H  
ATOM   2058  HG3 ARG A 137      69.191  -8.076  10.562  1.00  0.00           H  
ATOM   2059  HD2 ARG A 137      69.926  -7.290  12.622  1.00  0.00           H  
ATOM   2060  HD3 ARG A 137      71.239  -8.344  12.097  1.00  0.00           H  
ATOM   2061  HE  ARG A 137      72.603  -6.526  12.150  1.00  0.00           H  
ATOM   2062 HH11 ARG A 137      69.333  -5.423  11.694  1.00  0.00           H  
ATOM   2063 HH12 ARG A 137      69.755  -3.744  11.739  1.00  0.00           H  
ATOM   2064 HH21 ARG A 137      73.171  -4.318  12.211  1.00  0.00           H  
ATOM   2065 HH22 ARG A 137      71.938  -3.116  12.033  1.00  0.00           H  
ATOM   2066  N   LEU A 138      70.828 -10.688   7.262  1.00  0.00           N  
ATOM   2067  CA  LEU A 138      71.370 -11.229   6.021  1.00  0.00           C  
ATOM   2068  C   LEU A 138      71.481 -10.144   4.955  1.00  0.00           C  
ATOM   2069  O   LEU A 138      70.748  -9.154   4.985  1.00  0.00           O  
ATOM   2070  CB  LEU A 138      70.488 -12.371   5.511  1.00  0.00           C  
ATOM   2071  CG  LEU A 138      70.177 -13.479   6.519  1.00  0.00           C  
ATOM   2072  CD1 LEU A 138      68.827 -14.111   6.217  1.00  0.00           C  
ATOM   2073  CD2 LEU A 138      71.275 -14.532   6.510  1.00  0.00           C  
ATOM   2074  H   LEU A 138      69.858 -10.675   7.393  1.00  0.00           H  
ATOM   2075  HA  LEU A 138      72.358 -11.613   6.229  1.00  0.00           H  
ATOM   2076  HB2 LEU A 138      69.551 -11.946   5.187  1.00  0.00           H  
ATOM   2077  HB3 LEU A 138      70.989 -12.823   4.666  1.00  0.00           H  
ATOM   2078  HG  LEU A 138      70.130 -13.051   7.511  1.00  0.00           H  
ATOM   2079 HD11 LEU A 138      68.616 -14.023   5.162  1.00  0.00           H  
ATOM   2080 HD12 LEU A 138      68.058 -13.604   6.781  1.00  0.00           H  
ATOM   2081 HD13 LEU A 138      68.848 -15.154   6.494  1.00  0.00           H  
ATOM   2082 HD21 LEU A 138      70.833 -15.512   6.408  1.00  0.00           H  
ATOM   2083 HD22 LEU A 138      71.828 -14.483   7.436  1.00  0.00           H  
ATOM   2084 HD23 LEU A 138      71.943 -14.349   5.681  1.00  0.00           H  
ATOM   2085  N   ARG A 139      72.398 -10.336   4.013  1.00  0.00           N  
ATOM   2086  CA  ARG A 139      72.604  -9.375   2.937  1.00  0.00           C  
ATOM   2087  C   ARG A 139      71.730  -9.711   1.733  1.00  0.00           C  
ATOM   2088  O   ARG A 139      71.151  -8.824   1.105  1.00  0.00           O  
ATOM   2089  CB  ARG A 139      74.075  -9.347   2.522  1.00  0.00           C  
ATOM   2090  CG  ARG A 139      75.013  -8.900   3.631  1.00  0.00           C  
ATOM   2091  CD  ARG A 139      76.466  -9.173   3.277  1.00  0.00           C  
ATOM   2092  NE  ARG A 139      76.753 -10.604   3.210  1.00  0.00           N  
ATOM   2093  CZ  ARG A 139      77.920 -11.102   2.818  1.00  0.00           C  
ATOM   2094  NH1 ARG A 139      78.904 -10.290   2.459  1.00  0.00           N  
ATOM   2095  NH2 ARG A 139      78.105 -12.415   2.786  1.00  0.00           N  
ATOM   2096  H   ARG A 139      72.952 -11.145   4.042  1.00  0.00           H  
ATOM   2097  HA  ARG A 139      72.325  -8.399   3.307  1.00  0.00           H  
ATOM   2098  HB2 ARG A 139      74.369 -10.340   2.213  1.00  0.00           H  
ATOM   2099  HB3 ARG A 139      74.190  -8.671   1.688  1.00  0.00           H  
ATOM   2100  HG2 ARG A 139      74.887  -7.839   3.790  1.00  0.00           H  
ATOM   2101  HG3 ARG A 139      74.766  -9.433   4.537  1.00  0.00           H  
ATOM   2102  HD2 ARG A 139      76.679  -8.729   2.316  1.00  0.00           H  
ATOM   2103  HD3 ARG A 139      77.097  -8.724   4.029  1.00  0.00           H  
ATOM   2104  HE  ARG A 139      76.040 -11.222   3.472  1.00  0.00           H  
ATOM   2105 HH11 ARG A 139      78.769  -9.299   2.484  1.00  0.00           H  
ATOM   2106 HH12 ARG A 139      79.783 -10.667   2.165  1.00  0.00           H  
ATOM   2107 HH21 ARG A 139      77.366 -13.031   3.055  1.00  0.00           H  
ATOM   2108 HH22 ARG A 139      78.984 -12.789   2.490  1.00  0.00           H  
ATOM   2109  N   HIS A 140      71.640 -10.999   1.415  1.00  0.00           N  
ATOM   2110  CA  HIS A 140      70.837 -11.453   0.286  1.00  0.00           C  
ATOM   2111  C   HIS A 140      69.663 -12.305   0.760  1.00  0.00           C  
ATOM   2112  O   HIS A 140      69.801 -13.111   1.681  1.00  0.00           O  
ATOM   2113  CB  HIS A 140      71.699 -12.253  -0.692  1.00  0.00           C  
ATOM   2114  CG  HIS A 140      72.234 -13.527  -0.114  1.00  0.00           C  
ATOM   2115  ND1 HIS A 140      71.804 -14.774  -0.514  1.00  0.00           N  
ATOM   2116  CD2 HIS A 140      73.172 -13.742   0.838  1.00  0.00           C  
ATOM   2117  CE1 HIS A 140      72.452 -15.702   0.168  1.00  0.00           C  
ATOM   2118  NE2 HIS A 140      73.288 -15.101   0.995  1.00  0.00           N  
ATOM   2119  H   HIS A 140      72.124 -11.658   1.953  1.00  0.00           H  
ATOM   2120  HA  HIS A 140      70.452 -10.581  -0.219  1.00  0.00           H  
ATOM   2121  HB2 HIS A 140      71.108 -12.505  -1.560  1.00  0.00           H  
ATOM   2122  HB3 HIS A 140      72.540 -11.647  -0.998  1.00  0.00           H  
ATOM   2123  HD1 HIS A 140      71.123 -14.953  -1.196  1.00  0.00           H  
ATOM   2124  HD2 HIS A 140      73.727 -12.986   1.376  1.00  0.00           H  
ATOM   2125  HE1 HIS A 140      72.320 -16.768   0.067  1.00  0.00           H  
ATOM   2126  HE2 HIS A 140      73.828 -15.553   1.677  1.00  0.00           H  
ATOM   2127  N   PHE A 141      68.509 -12.119   0.127  1.00  0.00           N  
ATOM   2128  CA  PHE A 141      67.311 -12.869   0.486  1.00  0.00           C  
ATOM   2129  C   PHE A 141      67.483 -14.351   0.172  1.00  0.00           C  
ATOM   2130  O   PHE A 141      67.683 -14.750  -0.976  1.00  0.00           O  
ATOM   2131  CB  PHE A 141      66.095 -12.315  -0.258  1.00  0.00           C  
ATOM   2132  CG  PHE A 141      64.802 -12.495   0.487  1.00  0.00           C  
ATOM   2133  CD1 PHE A 141      64.680 -12.071   1.799  1.00  0.00           C  
ATOM   2134  CD2 PHE A 141      63.711 -13.088  -0.127  1.00  0.00           C  
ATOM   2135  CE1 PHE A 141      63.492 -12.236   2.487  1.00  0.00           C  
ATOM   2136  CE2 PHE A 141      62.521 -13.256   0.555  1.00  0.00           C  
ATOM   2137  CZ  PHE A 141      62.411 -12.828   1.864  1.00  0.00           C  
ATOM   2138  H   PHE A 141      68.463 -11.461  -0.597  1.00  0.00           H  
ATOM   2139  HA  PHE A 141      67.155 -12.754   1.549  1.00  0.00           H  
ATOM   2140  HB2 PHE A 141      66.235 -11.258  -0.426  1.00  0.00           H  
ATOM   2141  HB3 PHE A 141      66.005 -12.817  -1.209  1.00  0.00           H  
ATOM   2142  HD1 PHE A 141      65.523 -11.606   2.288  1.00  0.00           H  
ATOM   2143  HD2 PHE A 141      63.797 -13.423  -1.151  1.00  0.00           H  
ATOM   2144  HE1 PHE A 141      63.408 -11.900   3.510  1.00  0.00           H  
ATOM   2145  HE2 PHE A 141      61.678 -13.720   0.065  1.00  0.00           H  
ATOM   2146  HZ  PHE A 141      61.483 -12.959   2.399  1.00  0.00           H  
ATOM   2147  N   PRO A 142      67.402 -15.191   1.215  1.00  0.00           N  
ATOM   2148  CA  PRO A 142      67.545 -16.643   1.075  1.00  0.00           C  
ATOM   2149  C   PRO A 142      66.363 -17.276   0.350  1.00  0.00           C  
ATOM   2150  O   PRO A 142      66.463 -18.389  -0.166  1.00  0.00           O  
ATOM   2151  CB  PRO A 142      67.608 -17.135   2.524  1.00  0.00           C  
ATOM   2152  CG  PRO A 142      66.892 -16.091   3.310  1.00  0.00           C  
ATOM   2153  CD  PRO A 142      67.163 -14.787   2.611  1.00  0.00           C  
ATOM   2154  HA  PRO A 142      68.461 -16.904   0.565  1.00  0.00           H  
ATOM   2155  HB2 PRO A 142      67.118 -18.094   2.603  1.00  0.00           H  
ATOM   2156  HB3 PRO A 142      68.638 -17.222   2.834  1.00  0.00           H  
ATOM   2157  HG2 PRO A 142      65.832 -16.299   3.316  1.00  0.00           H  
ATOM   2158  HG3 PRO A 142      67.275 -16.062   4.318  1.00  0.00           H  
ATOM   2159  HD2 PRO A 142      66.307 -14.134   2.683  1.00  0.00           H  
ATOM   2160  HD3 PRO A 142      68.039 -14.311   3.028  1.00  0.00           H  
ATOM   2161  N   CYS A 143      65.245 -16.559   0.314  1.00  0.00           N  
ATOM   2162  CA  CYS A 143      64.042 -17.051  -0.349  1.00  0.00           C  
ATOM   2163  C   CYS A 143      63.899 -16.439  -1.739  1.00  0.00           C  
ATOM   2164  O   CYS A 143      64.582 -15.474  -2.078  1.00  0.00           O  
ATOM   2165  CB  CYS A 143      62.805 -16.732   0.492  1.00  0.00           C  
ATOM   2166  SG  CYS A 143      62.501 -17.905   1.833  1.00  0.00           S  
ATOM   2167  H   CYS A 143      65.227 -15.678   0.744  1.00  0.00           H  
ATOM   2168  HA  CYS A 143      64.134 -18.121  -0.448  1.00  0.00           H  
ATOM   2169  HB2 CYS A 143      62.921 -15.752   0.934  1.00  0.00           H  
ATOM   2170  HB3 CYS A 143      61.935 -16.729  -0.149  1.00  0.00           H  
ATOM   2171  HG  CYS A 143      63.656 -18.152   2.430  1.00  0.00           H  
ATOM   2172  N   GLY A 144      63.006 -17.010  -2.542  1.00  0.00           N  
ATOM   2173  CA  GLY A 144      62.790 -16.509  -3.887  1.00  0.00           C  
ATOM   2174  C   GLY A 144      61.421 -15.883  -4.060  1.00  0.00           C  
ATOM   2175  O   GLY A 144      61.297 -14.787  -4.604  1.00  0.00           O  
ATOM   2176  H   GLY A 144      62.489 -17.777  -2.219  1.00  0.00           H  
ATOM   2177  HA2 GLY A 144      63.544 -15.769  -4.108  1.00  0.00           H  
ATOM   2178  HA3 GLY A 144      62.889 -17.329  -4.584  1.00  0.00           H  
ATOM   2179  N   ASN A 145      60.389 -16.580  -3.597  1.00  0.00           N  
ATOM   2180  CA  ASN A 145      59.021 -16.088  -3.705  1.00  0.00           C  
ATOM   2181  C   ASN A 145      58.769 -14.961  -2.707  1.00  0.00           C  
ATOM   2182  O   ASN A 145      58.517 -15.207  -1.528  1.00  0.00           O  
ATOM   2183  CB  ASN A 145      58.026 -17.225  -3.470  1.00  0.00           C  
ATOM   2184  CG  ASN A 145      58.565 -18.568  -3.924  1.00  0.00           C  
ATOM   2185  OD1 ASN A 145      58.408 -18.952  -5.083  1.00  0.00           O  
ATOM   2186  ND2 ASN A 145      59.204 -19.289  -3.010  1.00  0.00           N  
ATOM   2187  H   ASN A 145      60.552 -17.450  -3.172  1.00  0.00           H  
ATOM   2188  HA  ASN A 145      58.885 -15.704  -4.705  1.00  0.00           H  
ATOM   2189  HB2 ASN A 145      57.803 -17.288  -2.413  1.00  0.00           H  
ATOM   2190  HB3 ASN A 145      57.117 -17.019  -4.014  1.00  0.00           H  
ATOM   2191 HD21 ASN A 145      59.291 -18.920  -2.106  1.00  0.00           H  
ATOM   2192 HD22 ASN A 145      59.563 -20.160  -3.277  1.00  0.00           H  
ATOM   2193  N   VAL A 146      58.838 -13.725  -3.189  1.00  0.00           N  
ATOM   2194  CA  VAL A 146      58.615 -12.560  -2.341  1.00  0.00           C  
ATOM   2195  C   VAL A 146      57.231 -11.965  -2.576  1.00  0.00           C  
ATOM   2196  O   VAL A 146      56.753 -11.909  -3.708  1.00  0.00           O  
ATOM   2197  CB  VAL A 146      59.678 -11.473  -2.589  1.00  0.00           C  
ATOM   2198  CG1 VAL A 146      59.352 -10.216  -1.797  1.00  0.00           C  
ATOM   2199  CG2 VAL A 146      61.063 -11.993  -2.234  1.00  0.00           C  
ATOM   2200  H   VAL A 146      59.043 -13.592  -4.139  1.00  0.00           H  
ATOM   2201  HA  VAL A 146      58.689 -12.878  -1.311  1.00  0.00           H  
ATOM   2202  HB  VAL A 146      59.668 -11.222  -3.640  1.00  0.00           H  
ATOM   2203 HG11 VAL A 146      59.547 -10.390  -0.749  1.00  0.00           H  
ATOM   2204 HG12 VAL A 146      59.966  -9.400  -2.148  1.00  0.00           H  
ATOM   2205 HG13 VAL A 146      58.310  -9.966  -1.932  1.00  0.00           H  
ATOM   2206 HG21 VAL A 146      61.110 -12.200  -1.176  1.00  0.00           H  
ATOM   2207 HG22 VAL A 146      61.260 -12.898  -2.788  1.00  0.00           H  
ATOM   2208 HG23 VAL A 146      61.804 -11.247  -2.488  1.00  0.00           H  
ATOM   2209  N   ASN A 147      56.593 -11.520  -1.499  1.00  0.00           N  
ATOM   2210  CA  ASN A 147      55.263 -10.928  -1.588  1.00  0.00           C  
ATOM   2211  C   ASN A 147      55.271  -9.493  -1.072  1.00  0.00           C  
ATOM   2212  O   ASN A 147      55.925  -9.183  -0.076  1.00  0.00           O  
ATOM   2213  CB  ASN A 147      54.257 -11.763  -0.793  1.00  0.00           C  
ATOM   2214  CG  ASN A 147      52.862 -11.166  -0.819  1.00  0.00           C  
ATOM   2215  OD1 ASN A 147      52.603 -10.197  -1.532  1.00  0.00           O  
ATOM   2216  ND2 ASN A 147      51.957 -11.744  -0.038  1.00  0.00           N  
ATOM   2217  H   ASN A 147      57.027 -11.592  -0.623  1.00  0.00           H  
ATOM   2218  HA  ASN A 147      54.972 -10.924  -2.628  1.00  0.00           H  
ATOM   2219  HB2 ASN A 147      54.210 -12.756  -1.213  1.00  0.00           H  
ATOM   2220  HB3 ASN A 147      54.582 -11.826   0.234  1.00  0.00           H  
ATOM   2221 HD21 ASN A 147      52.236 -12.513   0.503  1.00  0.00           H  
ATOM   2222 HD22 ASN A 147      51.048 -11.380  -0.036  1.00  0.00           H  
ATOM   2223  N   TYR A 148      54.538  -8.621  -1.756  1.00  0.00           N  
ATOM   2224  CA  TYR A 148      54.461  -7.217  -1.368  1.00  0.00           C  
ATOM   2225  C   TYR A 148      53.117  -6.903  -0.720  1.00  0.00           C  
ATOM   2226  O   TYR A 148      52.061  -7.223  -1.267  1.00  0.00           O  
ATOM   2227  CB  TYR A 148      54.676  -6.317  -2.586  1.00  0.00           C  
ATOM   2228  CG  TYR A 148      56.038  -6.474  -3.223  1.00  0.00           C  
ATOM   2229  CD1 TYR A 148      57.188  -6.533  -2.446  1.00  0.00           C  
ATOM   2230  CD2 TYR A 148      56.175  -6.564  -4.602  1.00  0.00           C  
ATOM   2231  CE1 TYR A 148      58.435  -6.675  -3.023  1.00  0.00           C  
ATOM   2232  CE2 TYR A 148      57.417  -6.708  -5.189  1.00  0.00           C  
ATOM   2233  CZ  TYR A 148      58.544  -6.763  -4.395  1.00  0.00           C  
ATOM   2234  OH  TYR A 148      59.784  -6.906  -4.974  1.00  0.00           O  
ATOM   2235  H   TYR A 148      54.038  -8.927  -2.541  1.00  0.00           H  
ATOM   2236  HA  TYR A 148      55.247  -7.027  -0.650  1.00  0.00           H  
ATOM   2237  HB2 TYR A 148      53.932  -6.551  -3.332  1.00  0.00           H  
ATOM   2238  HB3 TYR A 148      54.566  -5.285  -2.287  1.00  0.00           H  
ATOM   2239  HD1 TYR A 148      57.098  -6.465  -1.370  1.00  0.00           H  
ATOM   2240  HD2 TYR A 148      55.291  -6.521  -5.222  1.00  0.00           H  
ATOM   2241  HE1 TYR A 148      59.317  -6.719  -2.401  1.00  0.00           H  
ATOM   2242  HE2 TYR A 148      57.504  -6.777  -6.264  1.00  0.00           H  
ATOM   2243  HH  TYR A 148      60.464  -6.809  -4.304  1.00  0.00           H  
ATOM   2244  N   GLY A 149      53.163  -6.274   0.450  1.00  0.00           N  
ATOM   2245  CA  GLY A 149      51.943  -5.926   1.155  1.00  0.00           C  
ATOM   2246  C   GLY A 149      51.673  -4.434   1.146  1.00  0.00           C  
ATOM   2247  O   GLY A 149      51.363  -3.859   0.103  1.00  0.00           O  
ATOM   2248  H   GLY A 149      54.033  -6.044   0.838  1.00  0.00           H  
ATOM   2249  HA2 GLY A 149      51.113  -6.434   0.687  1.00  0.00           H  
ATOM   2250  HA3 GLY A 149      52.025  -6.260   2.179  1.00  0.00           H  
ATOM   2251  N   TYR A 150      51.790  -3.807   2.311  1.00  0.00           N  
ATOM   2252  CA  TYR A 150      51.553  -2.374   2.435  1.00  0.00           C  
ATOM   2253  C   TYR A 150      52.300  -1.602   1.351  1.00  0.00           C  
ATOM   2254  O   TYR A 150      53.491  -1.818   1.131  1.00  0.00           O  
ATOM   2255  CB  TYR A 150      51.986  -1.882   3.817  1.00  0.00           C  
ATOM   2256  CG  TYR A 150      50.900  -1.986   4.863  1.00  0.00           C  
ATOM   2257  CD1 TYR A 150      50.407  -3.222   5.262  1.00  0.00           C  
ATOM   2258  CD2 TYR A 150      50.367  -0.847   5.456  1.00  0.00           C  
ATOM   2259  CE1 TYR A 150      49.415  -3.322   6.218  1.00  0.00           C  
ATOM   2260  CE2 TYR A 150      49.375  -0.936   6.413  1.00  0.00           C  
ATOM   2261  CZ  TYR A 150      48.902  -2.176   6.791  1.00  0.00           C  
ATOM   2262  OH  TYR A 150      47.915  -2.271   7.744  1.00  0.00           O  
ATOM   2263  H   TYR A 150      52.041  -4.320   3.108  1.00  0.00           H  
ATOM   2264  HA  TYR A 150      50.494  -2.202   2.318  1.00  0.00           H  
ATOM   2265  HB2 TYR A 150      52.827  -2.467   4.153  1.00  0.00           H  
ATOM   2266  HB3 TYR A 150      52.281  -0.844   3.746  1.00  0.00           H  
ATOM   2267  HD1 TYR A 150      50.810  -4.117   4.811  1.00  0.00           H  
ATOM   2268  HD2 TYR A 150      50.740   0.123   5.158  1.00  0.00           H  
ATOM   2269  HE1 TYR A 150      49.044  -4.292   6.513  1.00  0.00           H  
ATOM   2270  HE2 TYR A 150      48.974  -0.040   6.862  1.00  0.00           H  
ATOM   2271  HH  TYR A 150      47.056  -2.167   7.326  1.00  0.00           H  
ATOM   2272  N   GLN A 151      51.589  -0.703   0.678  1.00  0.00           N  
ATOM   2273  CA  GLN A 151      52.184   0.101  -0.383  1.00  0.00           C  
ATOM   2274  C   GLN A 151      51.551   1.487  -0.436  1.00  0.00           C  
ATOM   2275  O   GLN A 151      50.363   1.647  -0.159  1.00  0.00           O  
ATOM   2276  CB  GLN A 151      52.023  -0.599  -1.734  1.00  0.00           C  
ATOM   2277  CG  GLN A 151      52.846   0.029  -2.846  1.00  0.00           C  
ATOM   2278  CD  GLN A 151      52.744  -0.736  -4.151  1.00  0.00           C  
ATOM   2279  OE1 GLN A 151      51.703  -1.314  -4.466  1.00  0.00           O  
ATOM   2280  NE2 GLN A 151      53.828  -0.746  -4.918  1.00  0.00           N  
ATOM   2281  H   GLN A 151      50.644  -0.577   0.900  1.00  0.00           H  
ATOM   2282  HA  GLN A 151      53.237   0.208  -0.167  1.00  0.00           H  
ATOM   2283  HB2 GLN A 151      52.325  -1.630  -1.629  1.00  0.00           H  
ATOM   2284  HB3 GLN A 151      50.982  -0.564  -2.022  1.00  0.00           H  
ATOM   2285  HG2 GLN A 151      52.495   1.037  -3.011  1.00  0.00           H  
ATOM   2286  HG3 GLN A 151      53.881   0.055  -2.540  1.00  0.00           H  
ATOM   2287 HE21 GLN A 151      54.622  -0.265  -4.602  1.00  0.00           H  
ATOM   2288 HE22 GLN A 151      53.791  -1.234  -5.766  1.00  0.00           H  
ATOM   2289  N   GLN A 152      52.352   2.486  -0.793  1.00  0.00           N  
ATOM   2290  CA  GLN A 152      51.870   3.858  -0.881  1.00  0.00           C  
ATOM   2291  C   GLN A 152      52.887   4.750  -1.585  1.00  0.00           C  
ATOM   2292  O   GLN A 152      54.090   4.642  -1.347  1.00  0.00           O  
ATOM   2293  CB  GLN A 152      51.572   4.407   0.516  1.00  0.00           C  
ATOM   2294  CG  GLN A 152      52.750   4.306   1.472  1.00  0.00           C  
ATOM   2295  CD  GLN A 152      52.471   4.955   2.813  1.00  0.00           C  
ATOM   2296  OE1 GLN A 152      52.034   4.294   3.757  1.00  0.00           O  
ATOM   2297  NE2 GLN A 152      52.722   6.255   2.906  1.00  0.00           N  
ATOM   2298  H   GLN A 152      53.290   2.294  -1.001  1.00  0.00           H  
ATOM   2299  HA  GLN A 152      50.956   3.852  -1.455  1.00  0.00           H  
ATOM   2300  HB2 GLN A 152      51.295   5.448   0.430  1.00  0.00           H  
ATOM   2301  HB3 GLN A 152      50.746   3.857   0.939  1.00  0.00           H  
ATOM   2302  HG2 GLN A 152      52.977   3.263   1.635  1.00  0.00           H  
ATOM   2303  HG3 GLN A 152      53.604   4.792   1.024  1.00  0.00           H  
ATOM   2304 HE21 GLN A 152      53.067   6.717   2.113  1.00  0.00           H  
ATOM   2305 HE22 GLN A 152      52.549   6.700   3.761  1.00  0.00           H  
ATOM   2306  N   GLN A 153      52.396   5.630  -2.452  1.00  0.00           N  
ATOM   2307  CA  GLN A 153      53.263   6.538  -3.191  1.00  0.00           C  
ATOM   2308  C   GLN A 153      54.066   7.419  -2.240  1.00  0.00           C  
ATOM   2309  O   GLN A 153      53.540   7.920  -1.246  1.00  0.00           O  
ATOM   2310  CB  GLN A 153      52.436   7.411  -4.137  1.00  0.00           C  
ATOM   2311  CG  GLN A 153      51.591   6.614  -5.117  1.00  0.00           C  
ATOM   2312  CD  GLN A 153      50.268   6.172  -4.522  1.00  0.00           C  
ATOM   2313  OE1 GLN A 153      49.732   6.820  -3.623  1.00  0.00           O  
ATOM   2314  NE2 GLN A 153      49.734   5.064  -5.022  1.00  0.00           N  
ATOM   2315  H   GLN A 153      51.428   5.667  -2.598  1.00  0.00           H  
ATOM   2316  HA  GLN A 153      53.949   5.942  -3.774  1.00  0.00           H  
ATOM   2317  HB2 GLN A 153      51.778   8.033  -3.549  1.00  0.00           H  
ATOM   2318  HB3 GLN A 153      53.105   8.043  -4.702  1.00  0.00           H  
ATOM   2319  HG2 GLN A 153      51.391   7.229  -5.982  1.00  0.00           H  
ATOM   2320  HG3 GLN A 153      52.145   5.737  -5.419  1.00  0.00           H  
ATOM   2321 HE21 GLN A 153      50.219   4.599  -5.738  1.00  0.00           H  
ATOM   2322 HE22 GLN A 153      48.880   4.756  -4.656  1.00  0.00           H  
TER    2323      GLN A 153                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
