
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  146 ( 2254),  selected  146 , name 2ys5_A
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2ys5_A.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      G       9           -
LGA    S     2_A      N      10           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    L     8_A      -       -           -
LGA    N     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    D    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    V    13_A      -       -           -
LGA    P    14_A      A      11           #
LGA    D    15_A      A      12          1.376
LGA    N    16_A      E      13          3.466
LGA    H    17_A      V      14          4.938
LGA    P    18_A      N      15           -
LGA    -       -      L      16           -
LGA    -       -      D      17           -
LGA    -       -      E      18           -
LGA    -       -      L      19           -
LGA    -       -      A      20           -
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    -       -      L      23           -
LGA    -       -      G      24           -
LGA    -       -      P      25           -
LGA    -       -      I      26           -
LGA    -       -      M      27           -
LGA    -       -      G      28           -
LGA    -       -      D      29           -
LGA    -       -      N      30           -
LGA    -       -      E      31           -
LGA    -       -      Q      32           -
LGA    -       -      L      33           -
LGA    T    19_A      A      34          3.400
LGA    -       -      L      35           -
LGA    K    20_A      A      36          0.672
LGA    F    21_A      Y      37          2.288
LGA    K    22_A      R      38          3.147
LGA    V    23_A      -       -           -
LGA    T    24_A      -       -           -
LGA    N    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    D    27_A      -       -           -
LGA    D    28_A      -       -           -
LGA    E    29_A      -       -           -
LGA    G    30_A      -       -           -
LGA    V    31_A      -       -           -
LGA    E    32_A      -       -           -
LGA    L    33_A      -       -           -
LGA    G    34_A      -       -           -
LGA    S    35_A      V      39          4.807
LGA    -       -      I      40           -
LGA    -       -      R      41           -
LGA    G    36_A      D      42          2.859
LGA    V    37_A      M      43          1.659
LGA    M    38_A      F      44          1.287
LGA    E    39_A      V      45          1.189
LGA    L    40_A      F      46          1.170
LGA    T    41_A      T      47          0.736
LGA    Q    42_A      N      48          1.295
LGA    S    43_A      K      49          1.717
LGA    E    44_A      R      50          0.603
LGA    L    45_A      L      51          0.831
LGA    V    46_A      I      52          0.929
LGA    L    47_A      L      53          0.429
LGA    H    48_A      I      54          1.008
LGA    L    49_A      D      55          1.718
LGA    H    50_A      K      56          1.123
LGA    -       -      Q      57           -
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    -       -      T      60           -
LGA    -       -      G      61           -
LGA    R    51_A      K      62          3.148
LGA    R    52_A      K      63          2.997
LGA    E    53_A      V      64          3.895
LGA    -       -      S      65           -
LGA    A    54_A      Y      66          2.278
LGA    V    55_A      H      67          1.154
LGA    R    56_A      S      68          1.574
LGA    W    57_A      V      69          1.084
LGA    P    58_A      P      70          1.628
LGA    Y    59_A      Y      71          0.962
LGA    L    60_A      K      72          1.122
LGA    C    61_A      A      73          1.811
LGA    L    62_A      I      74          0.718
LGA    R    63_A      T      75          0.959
LGA    R    64_A      H      76          0.779
LGA    Y    65_A      F      77          1.976
LGA    G    66_A      E      78          2.423
LGA    Y    67_A      V      79          1.935
LGA    D    68_A      E      80          3.139
LGA    S    69_A      T      81          3.417
LGA    -       -      A      82           -
LGA    -       -      G      83           -
LGA    -       -      T      84           -
LGA    -       -      F      85           -
LGA    -       -      D      86           -
LGA    -       -      M      87           -
LGA    -       -      D      88           -
LGA    N    70_A      A      89          2.900
LGA    L    71_A      E      90          1.613
LGA    F    72_A      L      91          1.522
LGA    S    73_A      K      92          1.982
LGA    F    74_A      L      93          0.109
LGA    E    75_A      W      94          0.442
LGA    S    76_A      I      95          1.032
LGA    G    77_A      S      96          2.024
LGA    R    78_A      G      97          1.856
LGA    R    79_A      -       -           -
LGA    C    80_A      -       -           -
LGA    Q    81_A      -       -           -
LGA    T    82_A      -       -           -
LGA    G    83_A      Q      98          3.907
LGA    Q    84_A      K      99          3.475
LGA    G    85_A      D     100          2.264
LGA    I    86_A      P     101          1.023
LGA    F    87_A      L     102          1.170
LGA    A    88_A      V     103          0.608
LGA    F    89_A      K     104          1.180
LGA    K    90_A      E     105          1.238
LGA    C    91_A      L     106          2.485
LGA    S    92_A      K     107          2.813
LGA    -       -      K     108           -
LGA    -       -      G     109           -
LGA    R    93_A      T     110          2.232
LGA    -       -      D     111           -
LGA    A    94_A      V     112          3.052
LGA    E    95_A      V     113          2.698
LGA    E    96_A      G     114          2.004
LGA    I    97_A      I     115          0.896
LGA    F    98_A      Q     116          0.827
LGA    N    99_A      K     117          1.193
LGA    L   100_A      T     118          1.080
LGA    L   101_A      I     119          0.974
LGA    Q   102_A      A     120          0.804
LGA    D   103_A      N     121          1.071
LGA    L   104_A      F     122          1.678
LGA    M   105_A      S     123          2.212
LGA    Q   106_A      L     124          4.113
LGA    C   107_A      -       -           -
LGA    N   108_A      -       -           -
LGA    S   109_A      -       -           -
LGA    I   110_A      -       -           -
LGA    N   111_A      -       -           -
LGA    V   112_A      -       -           -
LGA    M   113_A      -       -           -
LGA    E   114_A      -       -           -
LGA    E   115_A      -       -           -
LGA    P   116_A      -       -           -
LGA    V   117_A      -       -           -
LGA    I   118_A      -       -           -
LGA    I   119_A      -       -           -
LGA    T   120_A      -       -           -
LGA    R   121_A      -       -           -
LGA    N   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    H   124_A      -       -           -
LGA    P   125_A      -       -           -
LGA    A   126_A      -       -           -
LGA    E   127_A      -       -           -
LGA    L   128_A      -       -           -
LGA    D   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    R   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    P   134_A      -       -           -
LGA    Q   135_A      -       -           -
LGA    P   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    N   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    L   140_A      -       -           -
LGA    G   141_A      -       -           -
LGA    Y   142_A      -       -           -
LGA    T   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    S   145_A      -       -           -
LGA    S   146_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  146  116    5.0     75    2.13     8.00     54.617     3.359

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.822745 * X  +   0.514201 * Y  +   0.242256 * Z  +  60.334892
  Y_new =  -0.004369 * X  +  -0.431908 * Y  +   0.901907 * Z  + -15.036163
  Z_new =   0.568394 * X  +   0.740981 * Y  +   0.357597 * Z  +   4.104712 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.121166   -2.020427  [ DEG:    64.2381   -115.7619 ]
  Theta =  -0.604553   -2.537040  [ DEG:   -34.6383   -145.3617 ]
  Phi   =  -3.136282    0.005311  [ DEG:  -179.6957      0.3043 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ys5_A                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ys5_A.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  146  116   5.0   75   2.13    8.00  54.617
REMARK  ---------------------------------------------------------- 
MOLECULE 2ys5_A
HEADER    SIGNALING PROTEIN                       03-APR-07   2YS5              
TITLE     SOLUTION STRUCTURE OF THE COMPLEX OF THE PTB DOMAIN OF SNT-           
TITLE    2 2 AND 19-RESIDUE PEPTIDE (AA 1571-1589) OF HALK                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FIBROBLAST GROWTH FACTOR RECEPTOR SUBSTRATE 3;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PTB DOMAIN;                                                
COMPND   5 SYNONYM: FGFR SUBSTRATE 3, SUC1-ASSOCIATED NEUROTROPHIC              
COMPND   6 FACTOR TARGET 2, SNT-2, FGFR-SIGNALING ADAPTOR SNT2;                 
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: ALK TYROSINE KINASE RECEPTOR;                              
COMPND  10 CHAIN: B;                                                            
COMPND  11 FRAGMENT: RESIDUES IN DATABASE 1571-1589;                            
COMPND  12 SYNONYM: ANAPLASTIC LYMPHOMA KINASE, CD246 ANTIGEN;                  
COMPND  13 EC: 2.7.10.1;                                                        
COMPND  14 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: FRS3;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060320-18;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS;                          
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 SYNTHETIC: YES;                                                      
SOURCE  10 OTHER_DETAILS: THE PEPTIDE WAS CHEMICALLY SYNTHESIZED. THE           
SOURCE  11 SEQUENCE IS TAKEN FROM HOMO SAPIENS.                                 
KEYWDS    COMPLEX, SNT-2, PTB DOMAIN, HALK, STRUCTURAL GENOMICS,                
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI, SIGNALING PROTEIN                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN STRUCTURAL           
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   08-APR-08 2YS5    0                                                
JRNL        AUTH   H.LI,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA                   
JRNL        TITL   SOLUTION STRUCTURE OF THE COMPLEX OF THE PTB                 
JRNL        TITL 2 DOMAIN OF SNT-2 AND 19-RESIDUE PEPTIDE (AA                   
JRNL        TITL 3 1571-1589) OF HALK                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YS5 A    8   146  UNP    O43559   FRS3_HUMAN       8    146             
DBREF  2YS5 B    1    19  UNP    Q9UM73   ALK_HUMAN     1571   1589             
SEQRES   1 A  146  GLY SER SER GLY SER SER GLY LEU ASN ARG ASP SER VAL          
SEQRES   2 A  146  PRO ASP ASN HIS PRO THR LYS PHE LYS VAL THR ASN VAL          
SEQRES   3 A  146  ASP ASP GLU GLY VAL GLU LEU GLY SER GLY VAL MET GLU          
SEQRES   4 A  146  LEU THR GLN SER GLU LEU VAL LEU HIS LEU HIS ARG ARG          
SEQRES   5 A  146  GLU ALA VAL ARG TRP PRO TYR LEU CYS LEU ARG ARG TYR          
SEQRES   6 A  146  GLY TYR ASP SER ASN LEU PHE SER PHE GLU SER GLY ARG          
SEQRES   7 A  146  ARG CYS GLN THR GLY GLN GLY ILE PHE ALA PHE LYS CYS          
SEQRES   8 A  146  SER ARG ALA GLU GLU ILE PHE ASN LEU LEU GLN ASP LEU          
SEQRES   9 A  146  MET GLN CYS ASN SER ILE ASN VAL MET GLU GLU PRO VAL          
SEQRES  10 A  146  ILE ILE THR ARG ASN SER HIS PRO ALA GLU LEU ASP LEU          
SEQRES  11 A  146  PRO ARG ALA PRO GLN PRO PRO ASN ALA LEU GLY TYR THR          
SEQRES  12 A  146  VAL SER SER                                                  
SEQRES   1 B   19  LEU PHE ARG LEU ARG HIS PHE PRO CYS GLY ASN VAL ASN          
SEQRES   2 B   19  TYR GLY TYR GLN GLN GLN                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      39.713 -16.943   5.991  1.00  0.00           N  
ATOM      2  CA  GLY A   1      38.489 -17.016   6.768  1.00  0.00           C  
ATOM      3  C   GLY A   1      38.434 -18.248   7.650  1.00  0.00           C  
ATOM      4  O   GLY A   1      38.597 -19.370   7.172  1.00  0.00           O  
ATOM      5  H1  GLY A   1      40.496 -17.465   6.265  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      38.417 -16.137   7.389  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      37.648 -17.036   6.090  1.00  0.00           H  
ATOM      8  N   SER A   2      38.207 -18.037   8.943  1.00  0.00           N  
ATOM      9  CA  SER A   2      38.137 -19.139   9.896  1.00  0.00           C  
ATOM     10  C   SER A   2      37.570 -18.667  11.231  1.00  0.00           C  
ATOM     11  O   SER A   2      37.507 -17.468  11.503  1.00  0.00           O  
ATOM     12  CB  SER A   2      39.524 -19.749  10.104  1.00  0.00           C  
ATOM     13  OG  SER A   2      39.474 -20.826  11.024  1.00  0.00           O  
ATOM     14  H   SER A   2      38.085 -17.119   9.263  1.00  0.00           H  
ATOM     15  HA  SER A   2      37.480 -19.892   9.485  1.00  0.00           H  
ATOM     16  HB2 SER A   2      39.900 -20.115   9.161  1.00  0.00           H  
ATOM     17  HB3 SER A   2      40.193 -18.993  10.489  1.00  0.00           H  
ATOM     18  HG  SER A   2      39.623 -21.653  10.559  1.00  0.00           H  
ATOM     19  N   SER A   3      37.158 -19.619  12.062  1.00  0.00           N  
ATOM     20  CA  SER A   3      36.592 -19.302  13.368  1.00  0.00           C  
ATOM     21  C   SER A   3      36.593 -20.531  14.273  1.00  0.00           C  
ATOM     22  O   SER A   3      36.949 -21.629  13.848  1.00  0.00           O  
ATOM     23  CB  SER A   3      35.167 -18.769  13.214  1.00  0.00           C  
ATOM     24  OG  SER A   3      34.325 -19.731  12.605  1.00  0.00           O  
ATOM     25  H   SER A   3      37.235 -20.557  11.788  1.00  0.00           H  
ATOM     26  HA  SER A   3      37.208 -18.538  13.818  1.00  0.00           H  
ATOM     27  HB2 SER A   3      34.770 -18.526  14.188  1.00  0.00           H  
ATOM     28  HB3 SER A   3      35.183 -17.881  12.600  1.00  0.00           H  
ATOM     29  HG  SER A   3      33.470 -19.733  13.042  1.00  0.00           H  
ATOM     30  N   GLY A   4      36.192 -20.336  15.525  1.00  0.00           N  
ATOM     31  CA  GLY A   4      36.153 -21.436  16.471  1.00  0.00           C  
ATOM     32  C   GLY A   4      36.781 -21.076  17.804  1.00  0.00           C  
ATOM     33  O   GLY A   4      38.004 -21.034  17.930  1.00  0.00           O  
ATOM     34  H   GLY A   4      35.919 -19.438  15.809  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      35.124 -21.720  16.635  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      36.685 -22.276  16.051  1.00  0.00           H  
ATOM     37  N   SER A   5      35.940 -20.816  18.801  1.00  0.00           N  
ATOM     38  CA  SER A   5      36.420 -20.452  20.129  1.00  0.00           C  
ATOM     39  C   SER A   5      35.951 -21.464  21.171  1.00  0.00           C  
ATOM     40  O   SER A   5      34.794 -21.884  21.168  1.00  0.00           O  
ATOM     41  CB  SER A   5      35.931 -19.052  20.506  1.00  0.00           C  
ATOM     42  OG  SER A   5      36.694 -18.053  19.852  1.00  0.00           O  
ATOM     43  H   SER A   5      34.974 -20.866  18.637  1.00  0.00           H  
ATOM     44  HA  SER A   5      37.499 -20.452  20.103  1.00  0.00           H  
ATOM     45  HB2 SER A   5      34.897 -18.944  20.216  1.00  0.00           H  
ATOM     46  HB3 SER A   5      36.022 -18.918  21.573  1.00  0.00           H  
ATOM     47  HG  SER A   5      37.630 -18.241  19.962  1.00  0.00           H  
ATOM     48  N   SER A   6      36.860 -21.850  22.061  1.00  0.00           N  
ATOM     49  CA  SER A   6      36.542 -22.815  23.107  1.00  0.00           C  
ATOM     50  C   SER A   6      37.106 -22.364  24.452  1.00  0.00           C  
ATOM     51  O   SER A   6      38.100 -21.642  24.510  1.00  0.00           O  
ATOM     52  CB  SER A   6      37.100 -24.193  22.746  1.00  0.00           C  
ATOM     53  OG  SER A   6      36.512 -24.684  21.553  1.00  0.00           O  
ATOM     54  H   SER A   6      37.766 -21.479  22.011  1.00  0.00           H  
ATOM     55  HA  SER A   6      35.468 -22.880  23.184  1.00  0.00           H  
ATOM     56  HB2 SER A   6      38.167 -24.121  22.603  1.00  0.00           H  
ATOM     57  HB3 SER A   6      36.889 -24.885  23.548  1.00  0.00           H  
ATOM     58  HG  SER A   6      36.305 -23.948  20.971  1.00  0.00           H  
ATOM     59  N   GLY A   7      36.459 -22.795  25.531  1.00  0.00           N  
ATOM     60  CA  GLY A   7      36.909 -22.426  26.861  1.00  0.00           C  
ATOM     61  C   GLY A   7      37.825 -23.466  27.473  1.00  0.00           C  
ATOM     62  O   GLY A   7      37.698 -23.802  28.651  1.00  0.00           O  
ATOM     63  H   GLY A   7      35.672 -23.368  25.424  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      37.436 -21.486  26.802  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      36.045 -22.304  27.499  1.00  0.00           H  
ATOM     66  N   LEU A   8      38.751 -23.982  26.672  1.00  0.00           N  
ATOM     67  CA  LEU A   8      39.693 -24.993  27.141  1.00  0.00           C  
ATOM     68  C   LEU A   8      41.087 -24.400  27.314  1.00  0.00           C  
ATOM     69  O   LEU A   8      41.631 -23.787  26.395  1.00  0.00           O  
ATOM     70  CB  LEU A   8      39.743 -26.165  26.160  1.00  0.00           C  
ATOM     71  CG  LEU A   8      38.654 -27.226  26.326  1.00  0.00           C  
ATOM     72  CD1 LEU A   8      38.576 -28.108  25.090  1.00  0.00           C  
ATOM     73  CD2 LEU A   8      38.913 -28.066  27.569  1.00  0.00           C  
ATOM     74  H   LEU A   8      38.804 -23.676  25.743  1.00  0.00           H  
ATOM     75  HA  LEU A   8      39.345 -25.349  28.100  1.00  0.00           H  
ATOM     76  HB2 LEU A   8      39.665 -25.765  25.162  1.00  0.00           H  
ATOM     77  HB3 LEU A   8      40.701 -26.652  26.277  1.00  0.00           H  
ATOM     78  HG  LEU A   8      37.698 -26.735  26.447  1.00  0.00           H  
ATOM     79 HD11 LEU A   8      38.675 -27.498  24.205  1.00  0.00           H  
ATOM     80 HD12 LEU A   8      37.624 -28.618  25.071  1.00  0.00           H  
ATOM     81 HD13 LEU A   8      39.373 -28.837  25.117  1.00  0.00           H  
ATOM     82 HD21 LEU A   8      38.884 -29.113  27.307  1.00  0.00           H  
ATOM     83 HD22 LEU A   8      38.153 -27.858  28.308  1.00  0.00           H  
ATOM     84 HD23 LEU A   8      39.885 -27.822  27.972  1.00  0.00           H  
ATOM     85  N   ASN A   9      41.663 -24.588  28.498  1.00  0.00           N  
ATOM     86  CA  ASN A   9      42.995 -24.072  28.790  1.00  0.00           C  
ATOM     87  C   ASN A   9      44.058 -24.837  28.008  1.00  0.00           C  
ATOM     88  O   ASN A   9      43.886 -26.016  27.697  1.00  0.00           O  
ATOM     89  CB  ASN A   9      43.283 -24.168  30.290  1.00  0.00           C  
ATOM     90  CG  ASN A   9      42.078 -23.802  31.135  1.00  0.00           C  
ATOM     91  OD1 ASN A   9      41.058 -24.492  31.114  1.00  0.00           O  
ATOM     92  ND2 ASN A   9      42.189 -22.711  31.884  1.00  0.00           N  
ATOM     93  H   ASN A   9      41.179 -25.084  29.191  1.00  0.00           H  
ATOM     94  HA  ASN A   9      43.022 -23.036  28.493  1.00  0.00           H  
ATOM     95  HB2 ASN A   9      43.573 -25.181  30.531  1.00  0.00           H  
ATOM     96  HB3 ASN A   9      44.092 -23.497  30.539  1.00  0.00           H  
ATOM     97 HD21 ASN A   9      43.032 -22.210  31.850  1.00  0.00           H  
ATOM     98 HD22 ASN A   9      41.425 -22.451  32.440  1.00  0.00           H  
ATOM     99  N   ARG A  10      45.156 -24.158  27.694  1.00  0.00           N  
ATOM    100  CA  ARG A  10      46.247 -24.774  26.948  1.00  0.00           C  
ATOM    101  C   ARG A  10      47.411 -25.120  27.871  1.00  0.00           C  
ATOM    102  O   ARG A  10      47.761 -24.346  28.762  1.00  0.00           O  
ATOM    103  CB  ARG A  10      46.725 -23.837  25.837  1.00  0.00           C  
ATOM    104  CG  ARG A  10      45.959 -23.996  24.534  1.00  0.00           C  
ATOM    105  CD  ARG A  10      44.653 -23.216  24.557  1.00  0.00           C  
ATOM    106  NE  ARG A  10      43.752 -23.625  23.482  1.00  0.00           N  
ATOM    107  CZ  ARG A  10      43.148 -24.807  23.440  1.00  0.00           C  
ATOM    108  NH1 ARG A  10      43.348 -25.693  24.406  1.00  0.00           N  
ATOM    109  NH2 ARG A  10      42.343 -25.106  22.428  1.00  0.00           N  
ATOM    110  H   ARG A  10      45.235 -23.221  27.970  1.00  0.00           H  
ATOM    111  HA  ARG A  10      45.874 -25.684  26.502  1.00  0.00           H  
ATOM    112  HB2 ARG A  10      46.615 -22.815  26.171  1.00  0.00           H  
ATOM    113  HB3 ARG A  10      47.769 -24.033  25.641  1.00  0.00           H  
ATOM    114  HG2 ARG A  10      46.569 -23.630  23.720  1.00  0.00           H  
ATOM    115  HG3 ARG A  10      45.741 -25.042  24.380  1.00  0.00           H  
ATOM    116  HD2 ARG A  10      44.165 -23.385  25.506  1.00  0.00           H  
ATOM    117  HD3 ARG A  10      44.875 -22.165  24.449  1.00  0.00           H  
ATOM    118  HE  ARG A  10      43.591 -22.986  22.758  1.00  0.00           H  
ATOM    119 HH11 ARG A  10      43.953 -25.470  25.170  1.00  0.00           H  
ATOM    120 HH12 ARG A  10      42.890 -26.582  24.372  1.00  0.00           H  
ATOM    121 HH21 ARG A  10      42.191 -24.440  21.698  1.00  0.00           H  
ATOM    122 HH22 ARG A  10      41.889 -25.995  22.396  1.00  0.00           H  
ATOM    123  N   ASP A  11      48.006 -26.288  27.653  1.00  0.00           N  
ATOM    124  CA  ASP A  11      49.130 -26.737  28.465  1.00  0.00           C  
ATOM    125  C   ASP A  11      50.457 -26.386  27.798  1.00  0.00           C  
ATOM    126  O   ASP A  11      51.315 -25.742  28.402  1.00  0.00           O  
ATOM    127  CB  ASP A  11      49.048 -28.246  28.700  1.00  0.00           C  
ATOM    128  CG  ASP A  11      49.054 -29.034  27.405  1.00  0.00           C  
ATOM    129  OD1 ASP A  11      47.970 -29.205  26.809  1.00  0.00           O  
ATOM    130  OD2 ASP A  11      50.143 -29.482  26.988  1.00  0.00           O  
ATOM    131  H   ASP A  11      47.681 -26.861  26.927  1.00  0.00           H  
ATOM    132  HA  ASP A  11      49.075 -26.230  29.417  1.00  0.00           H  
ATOM    133  HB2 ASP A  11      49.893 -28.559  29.294  1.00  0.00           H  
ATOM    134  HB3 ASP A  11      48.135 -28.470  29.233  1.00  0.00           H  
ATOM    135  N   SER A  12      50.618 -26.814  26.550  1.00  0.00           N  
ATOM    136  CA  SER A  12      51.842 -26.549  25.803  1.00  0.00           C  
ATOM    137  C   SER A  12      51.537 -26.319  24.326  1.00  0.00           C  
ATOM    138  O   SER A  12      50.932 -27.164  23.665  1.00  0.00           O  
ATOM    139  CB  SER A  12      52.821 -27.715  25.958  1.00  0.00           C  
ATOM    140  OG  SER A  12      52.234 -28.934  25.536  1.00  0.00           O  
ATOM    141  H   SER A  12      49.897 -27.323  26.124  1.00  0.00           H  
ATOM    142  HA  SER A  12      52.292 -25.656  26.209  1.00  0.00           H  
ATOM    143  HB2 SER A  12      53.698 -27.526  25.358  1.00  0.00           H  
ATOM    144  HB3 SER A  12      53.106 -27.806  26.995  1.00  0.00           H  
ATOM    145  HG  SER A  12      51.425 -28.750  25.052  1.00  0.00           H  
ATOM    146  N   VAL A  13      51.961 -25.168  23.813  1.00  0.00           N  
ATOM    147  CA  VAL A  13      51.735 -24.825  22.414  1.00  0.00           C  
ATOM    148  C   VAL A  13      52.335 -25.875  21.487  1.00  0.00           C  
ATOM    149  O   VAL A  13      53.530 -26.172  21.535  1.00  0.00           O  
ATOM    150  CB  VAL A  13      52.336 -23.449  22.070  1.00  0.00           C  
ATOM    151  CG1 VAL A  13      53.828 -23.428  22.366  1.00  0.00           C  
ATOM    152  CG2 VAL A  13      52.068 -23.100  20.614  1.00  0.00           C  
ATOM    153  H   VAL A  13      52.438 -24.535  24.390  1.00  0.00           H  
ATOM    154  HA  VAL A  13      50.669 -24.780  22.250  1.00  0.00           H  
ATOM    155  HB  VAL A  13      51.858 -22.704  22.691  1.00  0.00           H  
ATOM    156 HG11 VAL A  13      54.141 -24.404  22.706  1.00  0.00           H  
ATOM    157 HG12 VAL A  13      54.370 -23.168  21.469  1.00  0.00           H  
ATOM    158 HG13 VAL A  13      54.032 -22.697  23.134  1.00  0.00           H  
ATOM    159 HG21 VAL A  13      51.033 -22.813  20.497  1.00  0.00           H  
ATOM    160 HG22 VAL A  13      52.705 -22.280  20.318  1.00  0.00           H  
ATOM    161 HG23 VAL A  13      52.275 -23.960  19.993  1.00  0.00           H  
ATOM    162  N   PRO A  14      51.490 -26.454  20.622  1.00  0.00           N  
ATOM    163  CA  PRO A  14      51.914 -27.480  19.665  1.00  0.00           C  
ATOM    164  C   PRO A  14      52.807 -26.914  18.566  1.00  0.00           C  
ATOM    165  O   PRO A  14      52.896 -25.699  18.389  1.00  0.00           O  
ATOM    166  CB  PRO A  14      50.594 -27.983  19.075  1.00  0.00           C  
ATOM    167  CG  PRO A  14      49.648 -26.845  19.240  1.00  0.00           C  
ATOM    168  CD  PRO A  14      50.053 -26.149  20.509  1.00  0.00           C  
ATOM    169  HA  PRO A  14      52.424 -28.295  20.158  1.00  0.00           H  
ATOM    170  HB2 PRO A  14      50.735 -28.234  18.034  1.00  0.00           H  
ATOM    171  HB3 PRO A  14      50.262 -28.854  19.619  1.00  0.00           H  
ATOM    172  HG2 PRO A  14      49.732 -26.173  18.399  1.00  0.00           H  
ATOM    173  HG3 PRO A  14      48.637 -27.217  19.324  1.00  0.00           H  
ATOM    174  HD2 PRO A  14      49.890 -25.084  20.424  1.00  0.00           H  
ATOM    175  HD3 PRO A  14      49.508 -26.550  21.351  1.00  0.00           H  
ATOM    176  N   ASP A  15      53.466 -27.802  17.829  1.00  0.00           N  
ATOM    177  CA  ASP A  15      54.351 -27.391  16.746  1.00  0.00           C  
ATOM    178  C   ASP A  15      53.568 -27.188  15.452  1.00  0.00           C  
ATOM    179  O   ASP A  15      54.146 -26.897  14.406  1.00  0.00           O  
ATOM    180  CB  ASP A  15      55.450 -28.433  16.533  1.00  0.00           C  
ATOM    181  CG  ASP A  15      56.353 -28.092  15.364  1.00  0.00           C  
ATOM    182  OD1 ASP A  15      56.941 -26.991  15.369  1.00  0.00           O  
ATOM    183  OD2 ASP A  15      56.471 -28.928  14.443  1.00  0.00           O  
ATOM    184  H   ASP A  15      53.353 -28.757  18.019  1.00  0.00           H  
ATOM    185  HA  ASP A  15      54.807 -26.454  17.027  1.00  0.00           H  
ATOM    186  HB2 ASP A  15      56.056 -28.495  17.425  1.00  0.00           H  
ATOM    187  HB3 ASP A  15      54.993 -29.395  16.345  1.00  0.00           H  
ATOM    188  N   ASN A  16      52.251 -27.344  15.533  1.00  0.00           N  
ATOM    189  CA  ASN A  16      51.389 -27.179  14.369  1.00  0.00           C  
ATOM    190  C   ASN A  16      50.196 -26.285  14.697  1.00  0.00           C  
ATOM    191  O   ASN A  16      49.113 -26.444  14.132  1.00  0.00           O  
ATOM    192  CB  ASN A  16      50.899 -28.541  13.873  1.00  0.00           C  
ATOM    193  CG  ASN A  16      50.417 -29.428  15.005  1.00  0.00           C  
ATOM    194  OD1 ASN A  16      50.023 -28.942  16.066  1.00  0.00           O  
ATOM    195  ND2 ASN A  16      50.448 -30.737  14.784  1.00  0.00           N  
ATOM    196  H   ASN A  16      51.849 -27.576  16.396  1.00  0.00           H  
ATOM    197  HA  ASN A  16      51.971 -26.711  13.589  1.00  0.00           H  
ATOM    198  HB2 ASN A  16      50.080 -28.393  13.184  1.00  0.00           H  
ATOM    199  HB3 ASN A  16      51.706 -29.044  13.364  1.00  0.00           H  
ATOM    200 HD21 ASN A  16      50.774 -31.053  13.915  1.00  0.00           H  
ATOM    201 HD22 ASN A  16      50.141 -31.334  15.498  1.00  0.00           H  
ATOM    202  N   HIS A  17      50.402 -25.344  15.613  1.00  0.00           N  
ATOM    203  CA  HIS A  17      49.346 -24.424  16.015  1.00  0.00           C  
ATOM    204  C   HIS A  17      48.942 -23.519  14.856  1.00  0.00           C  
ATOM    205  O   HIS A  17      49.777 -23.062  14.073  1.00  0.00           O  
ATOM    206  CB  HIS A  17      49.802 -23.577  17.204  1.00  0.00           C  
ATOM    207  CG  HIS A  17      48.688 -23.194  18.129  1.00  0.00           C  
ATOM    208  ND1 HIS A  17      48.336 -21.885  18.380  1.00  0.00           N  
ATOM    209  CD2 HIS A  17      47.845 -23.957  18.864  1.00  0.00           C  
ATOM    210  CE1 HIS A  17      47.326 -21.859  19.231  1.00  0.00           C  
ATOM    211  NE2 HIS A  17      47.008 -23.104  19.540  1.00  0.00           N  
ATOM    212  H   HIS A  17      51.287 -25.267  16.026  1.00  0.00           H  
ATOM    213  HA  HIS A  17      48.490 -25.012  16.311  1.00  0.00           H  
ATOM    214  HB2 HIS A  17      50.530 -24.135  17.775  1.00  0.00           H  
ATOM    215  HB3 HIS A  17      50.258 -22.669  16.836  1.00  0.00           H  
ATOM    216  HD1 HIS A  17      48.764 -21.093  17.994  1.00  0.00           H  
ATOM    217  HD2 HIS A  17      47.833 -25.037  18.910  1.00  0.00           H  
ATOM    218  HE1 HIS A  17      46.841 -20.972  19.610  1.00  0.00           H  
ATOM    219  HE2 HIS A  17      46.350 -23.367  20.216  1.00  0.00           H  
ATOM    220  N   PRO A  18      47.633 -23.251  14.740  1.00  0.00           N  
ATOM    221  CA  PRO A  18      47.090 -22.398  13.678  1.00  0.00           C  
ATOM    222  C   PRO A  18      47.474 -20.933  13.858  1.00  0.00           C  
ATOM    223  O   PRO A  18      47.698 -20.214  12.884  1.00  0.00           O  
ATOM    224  CB  PRO A  18      45.577 -22.575  13.819  1.00  0.00           C  
ATOM    225  CG  PRO A  18      45.372 -22.959  15.244  1.00  0.00           C  
ATOM    226  CD  PRO A  18      46.582 -23.760  15.637  1.00  0.00           C  
ATOM    227  HA  PRO A  18      47.404 -22.734  12.701  1.00  0.00           H  
ATOM    228  HB2 PRO A  18      45.078 -21.646  13.584  1.00  0.00           H  
ATOM    229  HB3 PRO A  18      45.237 -23.352  13.150  1.00  0.00           H  
ATOM    230  HG2 PRO A  18      45.295 -22.072  15.856  1.00  0.00           H  
ATOM    231  HG3 PRO A  18      44.479 -23.559  15.339  1.00  0.00           H  
ATOM    232  HD2 PRO A  18      46.836 -23.579  16.669  1.00  0.00           H  
ATOM    233  HD3 PRO A  18      46.408 -24.813  15.467  1.00  0.00           H  
ATOM    234  N   THR A  19      47.548 -20.495  15.112  1.00  0.00           N  
ATOM    235  CA  THR A  19      47.904 -19.116  15.420  1.00  0.00           C  
ATOM    236  C   THR A  19      49.374 -19.000  15.807  1.00  0.00           C  
ATOM    237  O   THR A  19      49.973 -17.931  15.694  1.00  0.00           O  
ATOM    238  CB  THR A  19      47.038 -18.555  16.563  1.00  0.00           C  
ATOM    239  OG1 THR A  19      47.051 -19.457  17.676  1.00  0.00           O  
ATOM    240  CG2 THR A  19      45.606 -18.335  16.101  1.00  0.00           C  
ATOM    241  H   THR A  19      47.358 -21.116  15.846  1.00  0.00           H  
ATOM    242  HA  THR A  19      47.725 -18.521  14.537  1.00  0.00           H  
ATOM    243  HB  THR A  19      47.451 -17.605  16.875  1.00  0.00           H  
ATOM    244  HG1 THR A  19      46.341 -20.095  17.580  1.00  0.00           H  
ATOM    245 HG21 THR A  19      45.607 -17.749  15.194  1.00  0.00           H  
ATOM    246 HG22 THR A  19      45.056 -17.809  16.867  1.00  0.00           H  
ATOM    247 HG23 THR A  19      45.137 -19.289  15.913  1.00  0.00           H  
ATOM    248  N   LYS A  20      49.949 -20.108  16.262  1.00  0.00           N  
ATOM    249  CA  LYS A  20      51.351 -20.133  16.664  1.00  0.00           C  
ATOM    250  C   LYS A  20      52.161 -21.054  15.758  1.00  0.00           C  
ATOM    251  O   LYS A  20      51.618 -21.977  15.149  1.00  0.00           O  
ATOM    252  CB  LYS A  20      51.478 -20.589  18.119  1.00  0.00           C  
ATOM    253  CG  LYS A  20      51.454 -19.447  19.119  1.00  0.00           C  
ATOM    254  CD  LYS A  20      50.051 -19.190  19.642  1.00  0.00           C  
ATOM    255  CE  LYS A  20      49.816 -17.711  19.906  1.00  0.00           C  
ATOM    256  NZ  LYS A  20      50.329 -17.298  21.242  1.00  0.00           N  
ATOM    257  H   LYS A  20      49.419 -20.930  16.328  1.00  0.00           H  
ATOM    258  HA  LYS A  20      51.739 -19.129  16.575  1.00  0.00           H  
ATOM    259  HB2 LYS A  20      50.659 -21.255  18.347  1.00  0.00           H  
ATOM    260  HB3 LYS A  20      52.409 -21.124  18.236  1.00  0.00           H  
ATOM    261  HG2 LYS A  20      52.097 -19.695  19.951  1.00  0.00           H  
ATOM    262  HG3 LYS A  20      51.819 -18.550  18.637  1.00  0.00           H  
ATOM    263  HD2 LYS A  20      49.335 -19.531  18.908  1.00  0.00           H  
ATOM    264  HD3 LYS A  20      49.914 -19.738  20.562  1.00  0.00           H  
ATOM    265  HE2 LYS A  20      50.321 -17.137  19.144  1.00  0.00           H  
ATOM    266  HE3 LYS A  20      48.756 -17.514  19.860  1.00  0.00           H  
ATOM    267  HZ1 LYS A  20      50.936 -18.043  21.638  1.00  0.00           H  
ATOM    268  HZ2 LYS A  20      49.535 -17.130  21.892  1.00  0.00           H  
ATOM    269  HZ3 LYS A  20      50.883 -16.422  21.157  1.00  0.00           H  
ATOM    270  N   PHE A  21      53.463 -20.801  15.675  1.00  0.00           N  
ATOM    271  CA  PHE A  21      54.348 -21.609  14.844  1.00  0.00           C  
ATOM    272  C   PHE A  21      55.783 -21.545  15.356  1.00  0.00           C  
ATOM    273  O   PHE A  21      56.472 -20.540  15.183  1.00  0.00           O  
ATOM    274  CB  PHE A  21      54.290 -21.135  13.391  1.00  0.00           C  
ATOM    275  CG  PHE A  21      52.901 -21.118  12.819  1.00  0.00           C  
ATOM    276  CD1 PHE A  21      52.062 -20.037  13.036  1.00  0.00           C  
ATOM    277  CD2 PHE A  21      52.436 -22.184  12.067  1.00  0.00           C  
ATOM    278  CE1 PHE A  21      50.783 -20.019  12.512  1.00  0.00           C  
ATOM    279  CE2 PHE A  21      51.158 -22.171  11.538  1.00  0.00           C  
ATOM    280  CZ  PHE A  21      50.331 -21.088  11.763  1.00  0.00           C  
ATOM    281  H   PHE A  21      53.838 -20.052  16.185  1.00  0.00           H  
ATOM    282  HA  PHE A  21      54.005 -22.631  14.895  1.00  0.00           H  
ATOM    283  HB2 PHE A  21      54.685 -20.132  13.331  1.00  0.00           H  
ATOM    284  HB3 PHE A  21      54.894 -21.791  12.781  1.00  0.00           H  
ATOM    285  HD1 PHE A  21      52.415 -19.202  13.622  1.00  0.00           H  
ATOM    286  HD2 PHE A  21      53.081 -23.032  11.891  1.00  0.00           H  
ATOM    287  HE1 PHE A  21      50.139 -19.171  12.689  1.00  0.00           H  
ATOM    288  HE2 PHE A  21      50.806 -23.008  10.953  1.00  0.00           H  
ATOM    289  HZ  PHE A  21      49.332 -21.075  11.351  1.00  0.00           H  
ATOM    290  N   LYS A  22      56.228 -22.625  15.989  1.00  0.00           N  
ATOM    291  CA  LYS A  22      57.582 -22.696  16.527  1.00  0.00           C  
ATOM    292  C   LYS A  22      58.617 -22.551  15.415  1.00  0.00           C  
ATOM    293  O   LYS A  22      58.735 -23.415  14.547  1.00  0.00           O  
ATOM    294  CB  LYS A  22      57.793 -24.019  17.265  1.00  0.00           C  
ATOM    295  CG  LYS A  22      57.296 -24.001  18.700  1.00  0.00           C  
ATOM    296  CD  LYS A  22      56.928 -25.394  19.181  1.00  0.00           C  
ATOM    297  CE  LYS A  22      56.168 -25.347  20.497  1.00  0.00           C  
ATOM    298  NZ  LYS A  22      57.087 -25.279  21.667  1.00  0.00           N  
ATOM    299  H   LYS A  22      55.631 -23.397  16.095  1.00  0.00           H  
ATOM    300  HA  LYS A  22      57.704 -21.880  17.223  1.00  0.00           H  
ATOM    301  HB2 LYS A  22      57.268 -24.801  16.735  1.00  0.00           H  
ATOM    302  HB3 LYS A  22      58.848 -24.248  17.274  1.00  0.00           H  
ATOM    303  HG2 LYS A  22      58.075 -23.607  19.336  1.00  0.00           H  
ATOM    304  HG3 LYS A  22      56.424 -23.366  18.761  1.00  0.00           H  
ATOM    305  HD2 LYS A  22      56.306 -25.870  18.436  1.00  0.00           H  
ATOM    306  HD3 LYS A  22      57.832 -25.970  19.318  1.00  0.00           H  
ATOM    307  HE2 LYS A  22      55.531 -24.475  20.499  1.00  0.00           H  
ATOM    308  HE3 LYS A  22      55.559 -26.236  20.578  1.00  0.00           H  
ATOM    309  HZ1 LYS A  22      56.897 -26.069  22.316  1.00  0.00           H  
ATOM    310  HZ2 LYS A  22      56.950 -24.384  22.177  1.00  0.00           H  
ATOM    311  HZ3 LYS A  22      58.075 -25.336  21.348  1.00  0.00           H  
ATOM    312  N   VAL A  23      59.365 -21.453  15.449  1.00  0.00           N  
ATOM    313  CA  VAL A  23      60.392 -21.196  14.447  1.00  0.00           C  
ATOM    314  C   VAL A  23      61.789 -21.306  15.049  1.00  0.00           C  
ATOM    315  O   VAL A  23      61.954 -21.291  16.270  1.00  0.00           O  
ATOM    316  CB  VAL A  23      60.225 -19.801  13.817  1.00  0.00           C  
ATOM    317  CG1 VAL A  23      58.899 -19.703  13.078  1.00  0.00           C  
ATOM    318  CG2 VAL A  23      60.333 -18.720  14.881  1.00  0.00           C  
ATOM    319  H   VAL A  23      59.224 -20.800  16.167  1.00  0.00           H  
ATOM    320  HA  VAL A  23      60.288 -21.936  13.666  1.00  0.00           H  
ATOM    321  HB  VAL A  23      61.022 -19.653  13.102  1.00  0.00           H  
ATOM    322 HG11 VAL A  23      59.018 -20.087  12.075  1.00  0.00           H  
ATOM    323 HG12 VAL A  23      58.153 -20.282  13.601  1.00  0.00           H  
ATOM    324 HG13 VAL A  23      58.589 -18.670  13.032  1.00  0.00           H  
ATOM    325 HG21 VAL A  23      61.331 -18.306  14.876  1.00  0.00           H  
ATOM    326 HG22 VAL A  23      59.618 -17.937  14.673  1.00  0.00           H  
ATOM    327 HG23 VAL A  23      60.125 -19.147  15.851  1.00  0.00           H  
ATOM    328  N   THR A  24      62.794 -21.417  14.186  1.00  0.00           N  
ATOM    329  CA  THR A  24      64.176 -21.530  14.632  1.00  0.00           C  
ATOM    330  C   THR A  24      65.080 -20.568  13.869  1.00  0.00           C  
ATOM    331  O   THR A  24      65.480 -20.842  12.739  1.00  0.00           O  
ATOM    332  CB  THR A  24      64.707 -22.965  14.456  1.00  0.00           C  
ATOM    333  OG1 THR A  24      64.018 -23.854  15.342  1.00  0.00           O  
ATOM    334  CG2 THR A  24      66.203 -23.025  14.729  1.00  0.00           C  
ATOM    335  H   THR A  24      62.598 -21.422  13.225  1.00  0.00           H  
ATOM    336  HA  THR A  24      64.208 -21.283  15.683  1.00  0.00           H  
ATOM    337  HB  THR A  24      64.530 -23.275  13.436  1.00  0.00           H  
ATOM    338  HG1 THR A  24      64.574 -24.616  15.526  1.00  0.00           H  
ATOM    339 HG21 THR A  24      66.552 -22.051  15.038  1.00  0.00           H  
ATOM    340 HG22 THR A  24      66.721 -23.325  13.831  1.00  0.00           H  
ATOM    341 HG23 THR A  24      66.397 -23.742  15.513  1.00  0.00           H  
ATOM    342  N   ASN A  25      65.399 -19.440  14.496  1.00  0.00           N  
ATOM    343  CA  ASN A  25      66.258 -18.437  13.876  1.00  0.00           C  
ATOM    344  C   ASN A  25      67.565 -19.061  13.398  1.00  0.00           C  
ATOM    345  O   ASN A  25      68.339 -19.594  14.192  1.00  0.00           O  
ATOM    346  CB  ASN A  25      66.551 -17.306  14.863  1.00  0.00           C  
ATOM    347  CG  ASN A  25      67.225 -16.120  14.201  1.00  0.00           C  
ATOM    348  OD1 ASN A  25      68.225 -15.603  14.698  1.00  0.00           O  
ATOM    349  ND2 ASN A  25      66.677 -15.684  13.073  1.00  0.00           N  
ATOM    350  H   ASN A  25      65.049 -19.279  15.398  1.00  0.00           H  
ATOM    351  HA  ASN A  25      65.732 -18.032  13.025  1.00  0.00           H  
ATOM    352  HB2 ASN A  25      65.622 -16.969  15.302  1.00  0.00           H  
ATOM    353  HB3 ASN A  25      67.199 -17.675  15.644  1.00  0.00           H  
ATOM    354 HD21 ASN A  25      65.880 -16.144  12.735  1.00  0.00           H  
ATOM    355 HD22 ASN A  25      67.094 -14.919  12.622  1.00  0.00           H  
ATOM    356  N   VAL A  26      67.804 -18.991  12.092  1.00  0.00           N  
ATOM    357  CA  VAL A  26      69.018 -19.547  11.505  1.00  0.00           C  
ATOM    358  C   VAL A  26      69.882 -18.451  10.890  1.00  0.00           C  
ATOM    359  O   VAL A  26      69.493 -17.284  10.858  1.00  0.00           O  
ATOM    360  CB  VAL A  26      68.691 -20.595  10.426  1.00  0.00           C  
ATOM    361  CG1 VAL A  26      67.902 -21.750  11.025  1.00  0.00           C  
ATOM    362  CG2 VAL A  26      67.927 -19.955   9.277  1.00  0.00           C  
ATOM    363  H   VAL A  26      67.149 -18.553  11.508  1.00  0.00           H  
ATOM    364  HA  VAL A  26      69.576 -20.032  12.293  1.00  0.00           H  
ATOM    365  HB  VAL A  26      69.622 -20.986  10.040  1.00  0.00           H  
ATOM    366 HG11 VAL A  26      68.300 -22.685  10.659  1.00  0.00           H  
ATOM    367 HG12 VAL A  26      67.982 -21.720  12.102  1.00  0.00           H  
ATOM    368 HG13 VAL A  26      66.864 -21.664  10.738  1.00  0.00           H  
ATOM    369 HG21 VAL A  26      68.605 -19.756   8.461  1.00  0.00           H  
ATOM    370 HG22 VAL A  26      67.151 -20.628   8.945  1.00  0.00           H  
ATOM    371 HG23 VAL A  26      67.483 -19.029   9.611  1.00  0.00           H  
ATOM    372  N   ASP A  27      71.057 -18.836  10.402  1.00  0.00           N  
ATOM    373  CA  ASP A  27      71.976 -17.888   9.786  1.00  0.00           C  
ATOM    374  C   ASP A  27      72.033 -18.091   8.275  1.00  0.00           C  
ATOM    375  O   ASP A  27      71.379 -18.982   7.732  1.00  0.00           O  
ATOM    376  CB  ASP A  27      73.375 -18.038  10.386  1.00  0.00           C  
ATOM    377  CG  ASP A  27      74.166 -19.158   9.740  1.00  0.00           C  
ATOM    378  OD1 ASP A  27      73.561 -20.205   9.425  1.00  0.00           O  
ATOM    379  OD2 ASP A  27      75.388 -18.990   9.551  1.00  0.00           O  
ATOM    380  H   ASP A  27      71.310 -19.782  10.458  1.00  0.00           H  
ATOM    381  HA  ASP A  27      71.611 -16.892   9.989  1.00  0.00           H  
ATOM    382  HB2 ASP A  27      73.918 -17.114  10.249  1.00  0.00           H  
ATOM    383  HB3 ASP A  27      73.286 -18.245  11.442  1.00  0.00           H  
ATOM    384  N   ASP A  28      72.820 -17.259   7.601  1.00  0.00           N  
ATOM    385  CA  ASP A  28      72.962 -17.347   6.152  1.00  0.00           C  
ATOM    386  C   ASP A  28      73.137 -18.796   5.710  1.00  0.00           C  
ATOM    387  O   ASP A  28      72.547 -19.228   4.720  1.00  0.00           O  
ATOM    388  CB  ASP A  28      74.155 -16.510   5.684  1.00  0.00           C  
ATOM    389  CG  ASP A  28      74.187 -16.340   4.178  1.00  0.00           C  
ATOM    390  OD1 ASP A  28      73.134 -16.004   3.597  1.00  0.00           O  
ATOM    391  OD2 ASP A  28      75.265 -16.543   3.580  1.00  0.00           O  
ATOM    392  H   ASP A  28      73.317 -16.569   8.089  1.00  0.00           H  
ATOM    393  HA  ASP A  28      72.062 -16.953   5.705  1.00  0.00           H  
ATOM    394  HB2 ASP A  28      74.099 -15.531   6.138  1.00  0.00           H  
ATOM    395  HB3 ASP A  28      75.069 -16.995   5.994  1.00  0.00           H  
ATOM    396  N   GLU A  29      73.952 -19.542   6.450  1.00  0.00           N  
ATOM    397  CA  GLU A  29      74.206 -20.942   6.132  1.00  0.00           C  
ATOM    398  C   GLU A  29      72.953 -21.785   6.353  1.00  0.00           C  
ATOM    399  O   GLU A  29      72.714 -22.759   5.641  1.00  0.00           O  
ATOM    400  CB  GLU A  29      75.355 -21.481   6.986  1.00  0.00           C  
ATOM    401  CG  GLU A  29      76.572 -20.572   7.014  1.00  0.00           C  
ATOM    402  CD  GLU A  29      77.860 -21.329   7.275  1.00  0.00           C  
ATOM    403  OE1 GLU A  29      78.175 -22.250   6.493  1.00  0.00           O  
ATOM    404  OE2 GLU A  29      78.551 -20.998   8.261  1.00  0.00           O  
ATOM    405  H   GLU A  29      74.394 -19.140   7.226  1.00  0.00           H  
ATOM    406  HA  GLU A  29      74.484 -21.000   5.091  1.00  0.00           H  
ATOM    407  HB2 GLU A  29      75.004 -21.613   7.999  1.00  0.00           H  
ATOM    408  HB3 GLU A  29      75.658 -22.441   6.593  1.00  0.00           H  
ATOM    409  HG2 GLU A  29      76.653 -20.071   6.061  1.00  0.00           H  
ATOM    410  HG3 GLU A  29      76.438 -19.838   7.795  1.00  0.00           H  
ATOM    411  N   GLY A  30      72.157 -21.402   7.347  1.00  0.00           N  
ATOM    412  CA  GLY A  30      70.939 -22.133   7.645  1.00  0.00           C  
ATOM    413  C   GLY A  30      71.009 -22.858   8.975  1.00  0.00           C  
ATOM    414  O   GLY A  30      70.036 -23.476   9.405  1.00  0.00           O  
ATOM    415  H   GLY A  30      72.398 -20.617   7.882  1.00  0.00           H  
ATOM    416  HA2 GLY A  30      70.112 -21.439   7.669  1.00  0.00           H  
ATOM    417  HA3 GLY A  30      70.767 -22.857   6.862  1.00  0.00           H  
ATOM    418  N   VAL A  31      72.166 -22.785   9.627  1.00  0.00           N  
ATOM    419  CA  VAL A  31      72.360 -23.440  10.915  1.00  0.00           C  
ATOM    420  C   VAL A  31      71.353 -22.939  11.943  1.00  0.00           C  
ATOM    421  O   VAL A  31      70.694 -21.920  11.737  1.00  0.00           O  
ATOM    422  CB  VAL A  31      73.785 -23.210  11.452  1.00  0.00           C  
ATOM    423  CG1 VAL A  31      74.819 -23.638  10.423  1.00  0.00           C  
ATOM    424  CG2 VAL A  31      73.978 -21.752  11.840  1.00  0.00           C  
ATOM    425  H   VAL A  31      72.905 -22.277   9.233  1.00  0.00           H  
ATOM    426  HA  VAL A  31      72.217 -24.502  10.774  1.00  0.00           H  
ATOM    427  HB  VAL A  31      73.916 -23.816  12.336  1.00  0.00           H  
ATOM    428 HG11 VAL A  31      75.132 -22.779   9.848  1.00  0.00           H  
ATOM    429 HG12 VAL A  31      75.673 -24.067  10.928  1.00  0.00           H  
ATOM    430 HG13 VAL A  31      74.386 -24.374   9.762  1.00  0.00           H  
ATOM    431 HG21 VAL A  31      74.478 -21.696  12.795  1.00  0.00           H  
ATOM    432 HG22 VAL A  31      74.578 -21.258  11.090  1.00  0.00           H  
ATOM    433 HG23 VAL A  31      73.016 -21.266  11.909  1.00  0.00           H  
ATOM    434  N   GLU A  32      71.240 -23.661  13.054  1.00  0.00           N  
ATOM    435  CA  GLU A  32      70.313 -23.289  14.116  1.00  0.00           C  
ATOM    436  C   GLU A  32      71.028 -22.506  15.213  1.00  0.00           C  
ATOM    437  O   GLU A  32      71.899 -23.039  15.905  1.00  0.00           O  
ATOM    438  CB  GLU A  32      69.655 -24.536  14.709  1.00  0.00           C  
ATOM    439  CG  GLU A  32      68.927 -25.387  13.682  1.00  0.00           C  
ATOM    440  CD  GLU A  32      68.542 -26.750  14.222  1.00  0.00           C  
ATOM    441  OE1 GLU A  32      68.250 -26.848  15.433  1.00  0.00           O  
ATOM    442  OE2 GLU A  32      68.533 -27.720  13.434  1.00  0.00           O  
ATOM    443  H   GLU A  32      71.793 -24.463  13.161  1.00  0.00           H  
ATOM    444  HA  GLU A  32      69.549 -22.660  13.683  1.00  0.00           H  
ATOM    445  HB2 GLU A  32      70.416 -25.143  15.175  1.00  0.00           H  
ATOM    446  HB3 GLU A  32      68.942 -24.229  15.461  1.00  0.00           H  
ATOM    447  HG2 GLU A  32      68.028 -24.871  13.379  1.00  0.00           H  
ATOM    448  HG3 GLU A  32      69.569 -25.522  12.825  1.00  0.00           H  
ATOM    449  N   LEU A  33      70.656 -21.241  15.368  1.00  0.00           N  
ATOM    450  CA  LEU A  33      71.262 -20.383  16.381  1.00  0.00           C  
ATOM    451  C   LEU A  33      70.433 -20.384  17.662  1.00  0.00           C  
ATOM    452  O   LEU A  33      70.946 -20.659  18.745  1.00  0.00           O  
ATOM    453  CB  LEU A  33      71.403 -18.955  15.852  1.00  0.00           C  
ATOM    454  CG  LEU A  33      71.884 -18.819  14.407  1.00  0.00           C  
ATOM    455  CD1 LEU A  33      71.852 -17.364  13.968  1.00  0.00           C  
ATOM    456  CD2 LEU A  33      73.285 -19.393  14.255  1.00  0.00           C  
ATOM    457  H   LEU A  33      69.958 -20.872  14.788  1.00  0.00           H  
ATOM    458  HA  LEU A  33      72.244 -20.775  16.603  1.00  0.00           H  
ATOM    459  HB2 LEU A  33      70.437 -18.479  15.925  1.00  0.00           H  
ATOM    460  HB3 LEU A  33      72.107 -18.436  16.486  1.00  0.00           H  
ATOM    461  HG  LEU A  33      71.221 -19.378  13.759  1.00  0.00           H  
ATOM    462 HD11 LEU A  33      72.300 -16.747  14.732  1.00  0.00           H  
ATOM    463 HD12 LEU A  33      70.828 -17.057  13.813  1.00  0.00           H  
ATOM    464 HD13 LEU A  33      72.403 -17.253  13.046  1.00  0.00           H  
ATOM    465 HD21 LEU A  33      73.220 -20.429  13.958  1.00  0.00           H  
ATOM    466 HD22 LEU A  33      73.807 -19.320  15.198  1.00  0.00           H  
ATOM    467 HD23 LEU A  33      73.823 -18.835  13.503  1.00  0.00           H  
ATOM    468  N   GLY A  34      69.146 -20.076  17.528  1.00  0.00           N  
ATOM    469  CA  GLY A  34      68.266 -20.050  18.681  1.00  0.00           C  
ATOM    470  C   GLY A  34      66.835 -20.402  18.327  1.00  0.00           C  
ATOM    471  O   GLY A  34      66.402 -20.201  17.192  1.00  0.00           O  
ATOM    472  H   GLY A  34      68.792 -19.866  16.638  1.00  0.00           H  
ATOM    473  HA2 GLY A  34      68.628 -20.755  19.414  1.00  0.00           H  
ATOM    474  HA3 GLY A  34      68.285 -19.059  19.110  1.00  0.00           H  
ATOM    475  N   SER A  35      66.099 -20.929  19.299  1.00  0.00           N  
ATOM    476  CA  SER A  35      64.709 -21.315  19.083  1.00  0.00           C  
ATOM    477  C   SER A  35      63.763 -20.190  19.490  1.00  0.00           C  
ATOM    478  O   SER A  35      64.043 -19.434  20.419  1.00  0.00           O  
ATOM    479  CB  SER A  35      64.381 -22.584  19.872  1.00  0.00           C  
ATOM    480  OG  SER A  35      64.234 -22.301  21.253  1.00  0.00           O  
ATOM    481  H   SER A  35      66.501 -21.065  20.183  1.00  0.00           H  
ATOM    482  HA  SER A  35      64.581 -21.514  18.030  1.00  0.00           H  
ATOM    483  HB2 SER A  35      63.460 -23.006  19.503  1.00  0.00           H  
ATOM    484  HB3 SER A  35      65.182 -23.299  19.746  1.00  0.00           H  
ATOM    485  HG  SER A  35      64.754 -21.527  21.479  1.00  0.00           H  
ATOM    486  N   GLY A  36      62.639 -20.086  18.788  1.00  0.00           N  
ATOM    487  CA  GLY A  36      61.667 -19.051  19.090  1.00  0.00           C  
ATOM    488  C   GLY A  36      60.284 -19.385  18.570  1.00  0.00           C  
ATOM    489  O   GLY A  36      60.121 -20.297  17.758  1.00  0.00           O  
ATOM    490  H   GLY A  36      62.469 -20.718  18.058  1.00  0.00           H  
ATOM    491  HA2 GLY A  36      61.616 -18.923  20.161  1.00  0.00           H  
ATOM    492  HA3 GLY A  36      61.994 -18.125  18.642  1.00  0.00           H  
ATOM    493  N   VAL A  37      59.283 -18.646  19.037  1.00  0.00           N  
ATOM    494  CA  VAL A  37      57.905 -18.869  18.614  1.00  0.00           C  
ATOM    495  C   VAL A  37      57.315 -17.613  17.982  1.00  0.00           C  
ATOM    496  O   VAL A  37      57.283 -16.551  18.603  1.00  0.00           O  
ATOM    497  CB  VAL A  37      57.018 -19.302  19.796  1.00  0.00           C  
ATOM    498  CG1 VAL A  37      55.564 -19.404  19.363  1.00  0.00           C  
ATOM    499  CG2 VAL A  37      57.506 -20.623  20.372  1.00  0.00           C  
ATOM    500  H   VAL A  37      59.475 -17.934  19.682  1.00  0.00           H  
ATOM    501  HA  VAL A  37      57.905 -19.663  17.881  1.00  0.00           H  
ATOM    502  HB  VAL A  37      57.088 -18.549  20.568  1.00  0.00           H  
ATOM    503 HG11 VAL A  37      55.156 -18.412  19.236  1.00  0.00           H  
ATOM    504 HG12 VAL A  37      55.503 -19.942  18.428  1.00  0.00           H  
ATOM    505 HG13 VAL A  37      55.000 -19.930  20.118  1.00  0.00           H  
ATOM    506 HG21 VAL A  37      58.500 -20.830  20.006  1.00  0.00           H  
ATOM    507 HG22 VAL A  37      57.522 -20.560  21.450  1.00  0.00           H  
ATOM    508 HG23 VAL A  37      56.838 -21.416  20.068  1.00  0.00           H  
ATOM    509  N   MET A  38      56.848 -17.743  16.746  1.00  0.00           N  
ATOM    510  CA  MET A  38      56.256 -16.618  16.030  1.00  0.00           C  
ATOM    511  C   MET A  38      54.741 -16.600  16.203  1.00  0.00           C  
ATOM    512  O   MET A  38      54.091 -17.645  16.170  1.00  0.00           O  
ATOM    513  CB  MET A  38      56.610 -16.689  14.543  1.00  0.00           C  
ATOM    514  CG  MET A  38      56.369 -15.385  13.799  1.00  0.00           C  
ATOM    515  SD  MET A  38      57.511 -14.081  14.295  1.00  0.00           S  
ATOM    516  CE  MET A  38      58.937 -14.479  13.285  1.00  0.00           C  
ATOM    517  H   MET A  38      56.901 -18.615  16.303  1.00  0.00           H  
ATOM    518  HA  MET A  38      56.665 -15.709  16.446  1.00  0.00           H  
ATOM    519  HB2 MET A  38      57.654 -16.946  14.446  1.00  0.00           H  
ATOM    520  HB3 MET A  38      56.013 -17.459  14.079  1.00  0.00           H  
ATOM    521  HG2 MET A  38      56.485 -15.563  12.740  1.00  0.00           H  
ATOM    522  HG3 MET A  38      55.360 -15.055  13.997  1.00  0.00           H  
ATOM    523  HE1 MET A  38      59.112 -15.544  13.315  1.00  0.00           H  
ATOM    524  HE2 MET A  38      58.754 -14.172  12.266  1.00  0.00           H  
ATOM    525  HE3 MET A  38      59.803 -13.959  13.667  1.00  0.00           H  
ATOM    526  N   GLU A  39      54.185 -15.407  16.390  1.00  0.00           N  
ATOM    527  CA  GLU A  39      52.745 -15.255  16.569  1.00  0.00           C  
ATOM    528  C   GLU A  39      52.152 -14.366  15.480  1.00  0.00           C  
ATOM    529  O   GLU A  39      52.679 -13.293  15.183  1.00  0.00           O  
ATOM    530  CB  GLU A  39      52.441 -14.665  17.948  1.00  0.00           C  
ATOM    531  CG  GLU A  39      50.979 -14.298  18.144  1.00  0.00           C  
ATOM    532  CD  GLU A  39      50.787 -13.178  19.147  1.00  0.00           C  
ATOM    533  OE1 GLU A  39      51.581 -12.215  19.119  1.00  0.00           O  
ATOM    534  OE2 GLU A  39      49.843 -13.265  19.959  1.00  0.00           O  
ATOM    535  H   GLU A  39      54.755 -14.611  16.407  1.00  0.00           H  
ATOM    536  HA  GLU A  39      52.298 -16.235  16.502  1.00  0.00           H  
ATOM    537  HB2 GLU A  39      52.716 -15.385  18.703  1.00  0.00           H  
ATOM    538  HB3 GLU A  39      53.034 -13.772  18.082  1.00  0.00           H  
ATOM    539  HG2 GLU A  39      50.569 -13.985  17.195  1.00  0.00           H  
ATOM    540  HG3 GLU A  39      50.448 -15.171  18.494  1.00  0.00           H  
ATOM    541  N   LEU A  40      51.053 -14.820  14.888  1.00  0.00           N  
ATOM    542  CA  LEU A  40      50.387 -14.067  13.831  1.00  0.00           C  
ATOM    543  C   LEU A  40      49.056 -13.504  14.320  1.00  0.00           C  
ATOM    544  O   LEU A  40      48.000 -14.100  14.106  1.00  0.00           O  
ATOM    545  CB  LEU A  40      50.157 -14.959  12.610  1.00  0.00           C  
ATOM    546  CG  LEU A  40      51.358 -15.148  11.682  1.00  0.00           C  
ATOM    547  CD1 LEU A  40      52.397 -16.049  12.329  1.00  0.00           C  
ATOM    548  CD2 LEU A  40      50.913 -15.720  10.343  1.00  0.00           C  
ATOM    549  H   LEU A  40      50.680 -15.682  15.168  1.00  0.00           H  
ATOM    550  HA  LEU A  40      51.031 -13.247  13.553  1.00  0.00           H  
ATOM    551  HB2 LEU A  40      49.857 -15.934  12.964  1.00  0.00           H  
ATOM    552  HB3 LEU A  40      49.354 -14.525  12.031  1.00  0.00           H  
ATOM    553  HG  LEU A  40      51.818 -14.187  11.499  1.00  0.00           H  
ATOM    554 HD11 LEU A  40      53.383 -15.644  12.157  1.00  0.00           H  
ATOM    555 HD12 LEU A  40      52.334 -17.038  11.901  1.00  0.00           H  
ATOM    556 HD13 LEU A  40      52.212 -16.105  13.392  1.00  0.00           H  
ATOM    557 HD21 LEU A  40      51.437 -15.217   9.545  1.00  0.00           H  
ATOM    558 HD22 LEU A  40      49.849 -15.573  10.226  1.00  0.00           H  
ATOM    559 HD23 LEU A  40      51.135 -16.777  10.312  1.00  0.00           H  
ATOM    560  N   THR A  41      49.114 -12.349  14.976  1.00  0.00           N  
ATOM    561  CA  THR A  41      47.915 -11.703  15.495  1.00  0.00           C  
ATOM    562  C   THR A  41      47.648 -10.383  14.779  1.00  0.00           C  
ATOM    563  O   THR A  41      48.574  -9.626  14.490  1.00  0.00           O  
ATOM    564  CB  THR A  41      48.028 -11.439  17.008  1.00  0.00           C  
ATOM    565  OG1 THR A  41      47.237 -10.300  17.367  1.00  0.00           O  
ATOM    566  CG2 THR A  41      49.477 -11.204  17.409  1.00  0.00           C  
ATOM    567  H   THR A  41      49.985 -11.922  15.116  1.00  0.00           H  
ATOM    568  HA  THR A  41      47.080 -12.368  15.328  1.00  0.00           H  
ATOM    569  HB  THR A  41      47.660 -12.306  17.538  1.00  0.00           H  
ATOM    570  HG1 THR A  41      47.803  -9.529  17.443  1.00  0.00           H  
ATOM    571 HG21 THR A  41      49.837 -10.302  16.939  1.00  0.00           H  
ATOM    572 HG22 THR A  41      50.079 -12.042  17.091  1.00  0.00           H  
ATOM    573 HG23 THR A  41      49.540 -11.100  18.482  1.00  0.00           H  
ATOM    574  N   GLN A  42      46.376 -10.115  14.497  1.00  0.00           N  
ATOM    575  CA  GLN A  42      45.989  -8.886  13.815  1.00  0.00           C  
ATOM    576  C   GLN A  42      46.881  -7.724  14.239  1.00  0.00           C  
ATOM    577  O   GLN A  42      47.193  -6.844  13.437  1.00  0.00           O  
ATOM    578  CB  GLN A  42      44.525  -8.555  14.110  1.00  0.00           C  
ATOM    579  CG  GLN A  42      43.545  -9.242  13.172  1.00  0.00           C  
ATOM    580  CD  GLN A  42      43.159 -10.629  13.647  1.00  0.00           C  
ATOM    581  OE1 GLN A  42      43.276 -10.948  14.830  1.00  0.00           O  
ATOM    582  NE2 GLN A  42      42.695 -11.463  12.723  1.00  0.00           N  
ATOM    583  H   GLN A  42      45.684 -10.759  14.754  1.00  0.00           H  
ATOM    584  HA  GLN A  42      46.106  -9.045  12.754  1.00  0.00           H  
ATOM    585  HB2 GLN A  42      44.296  -8.857  15.120  1.00  0.00           H  
ATOM    586  HB3 GLN A  42      44.385  -7.487  14.021  1.00  0.00           H  
ATOM    587  HG2 GLN A  42      42.651  -8.640  13.103  1.00  0.00           H  
ATOM    588  HG3 GLN A  42      43.999  -9.325  12.196  1.00  0.00           H  
ATOM    589 HE21 GLN A  42      42.630 -11.140  11.799  1.00  0.00           H  
ATOM    590 HE22 GLN A  42      42.439 -12.366  13.001  1.00  0.00           H  
ATOM    591  N   SER A  43      47.288  -7.727  15.504  1.00  0.00           N  
ATOM    592  CA  SER A  43      48.140  -6.671  16.036  1.00  0.00           C  
ATOM    593  C   SER A  43      49.450  -6.586  15.257  1.00  0.00           C  
ATOM    594  O   SER A  43      49.677  -5.639  14.504  1.00  0.00           O  
ATOM    595  CB  SER A  43      48.430  -6.917  17.517  1.00  0.00           C  
ATOM    596  OG  SER A  43      49.038  -5.783  18.114  1.00  0.00           O  
ATOM    597  H   SER A  43      47.006  -8.456  16.095  1.00  0.00           H  
ATOM    598  HA  SER A  43      47.612  -5.735  15.931  1.00  0.00           H  
ATOM    599  HB2 SER A  43      47.506  -7.127  18.032  1.00  0.00           H  
ATOM    600  HB3 SER A  43      49.097  -7.762  17.616  1.00  0.00           H  
ATOM    601  HG  SER A  43      49.496  -5.275  17.440  1.00  0.00           H  
ATOM    602  N   GLU A  44      50.308  -7.584  15.446  1.00  0.00           N  
ATOM    603  CA  GLU A  44      51.596  -7.622  14.762  1.00  0.00           C  
ATOM    604  C   GLU A  44      52.326  -8.931  15.049  1.00  0.00           C  
ATOM    605  O   GLU A  44      51.828  -9.784  15.785  1.00  0.00           O  
ATOM    606  CB  GLU A  44      52.463  -6.437  15.192  1.00  0.00           C  
ATOM    607  CG  GLU A  44      53.093  -6.611  16.564  1.00  0.00           C  
ATOM    608  CD  GLU A  44      53.351  -5.288  17.258  1.00  0.00           C  
ATOM    609  OE1 GLU A  44      52.741  -4.276  16.853  1.00  0.00           O  
ATOM    610  OE2 GLU A  44      54.164  -5.263  18.207  1.00  0.00           O  
ATOM    611  H   GLU A  44      50.071  -8.311  16.059  1.00  0.00           H  
ATOM    612  HA  GLU A  44      51.410  -7.552  13.700  1.00  0.00           H  
ATOM    613  HB2 GLU A  44      53.254  -6.303  14.469  1.00  0.00           H  
ATOM    614  HB3 GLU A  44      51.850  -5.547  15.211  1.00  0.00           H  
ATOM    615  HG2 GLU A  44      52.429  -7.199  17.180  1.00  0.00           H  
ATOM    616  HG3 GLU A  44      54.033  -7.131  16.451  1.00  0.00           H  
ATOM    617  N   LEU A  45      53.508  -9.083  14.462  1.00  0.00           N  
ATOM    618  CA  LEU A  45      54.308 -10.288  14.654  1.00  0.00           C  
ATOM    619  C   LEU A  45      55.219 -10.149  15.869  1.00  0.00           C  
ATOM    620  O   LEU A  45      56.008  -9.209  15.963  1.00  0.00           O  
ATOM    621  CB  LEU A  45      55.143 -10.572  13.405  1.00  0.00           C  
ATOM    622  CG  LEU A  45      54.490 -11.465  12.349  1.00  0.00           C  
ATOM    623  CD1 LEU A  45      55.292 -11.436  11.057  1.00  0.00           C  
ATOM    624  CD2 LEU A  45      54.357 -12.891  12.864  1.00  0.00           C  
ATOM    625  H   LEU A  45      53.852  -8.369  13.887  1.00  0.00           H  
ATOM    626  HA  LEU A  45      53.630 -11.112  14.819  1.00  0.00           H  
ATOM    627  HB2 LEU A  45      55.376  -9.627  12.940  1.00  0.00           H  
ATOM    628  HB3 LEU A  45      56.060 -11.050  13.723  1.00  0.00           H  
ATOM    629  HG  LEU A  45      53.498 -11.092  12.135  1.00  0.00           H  
ATOM    630 HD11 LEU A  45      54.726 -10.921  10.294  1.00  0.00           H  
ATOM    631 HD12 LEU A  45      55.493 -12.447  10.735  1.00  0.00           H  
ATOM    632 HD13 LEU A  45      56.225 -10.919  11.223  1.00  0.00           H  
ATOM    633 HD21 LEU A  45      53.368 -13.263  12.643  1.00  0.00           H  
ATOM    634 HD22 LEU A  45      54.516 -12.904  13.932  1.00  0.00           H  
ATOM    635 HD23 LEU A  45      55.095 -13.517  12.383  1.00  0.00           H  
ATOM    636  N   VAL A  46      55.106 -11.094  16.798  1.00  0.00           N  
ATOM    637  CA  VAL A  46      55.923 -11.079  18.006  1.00  0.00           C  
ATOM    638  C   VAL A  46      56.658 -12.403  18.189  1.00  0.00           C  
ATOM    639  O   VAL A  46      56.062 -13.475  18.087  1.00  0.00           O  
ATOM    640  CB  VAL A  46      55.068 -10.802  19.257  1.00  0.00           C  
ATOM    641  CG1 VAL A  46      55.897 -10.980  20.520  1.00  0.00           C  
ATOM    642  CG2 VAL A  46      54.471  -9.404  19.195  1.00  0.00           C  
ATOM    643  H   VAL A  46      54.460 -11.818  16.666  1.00  0.00           H  
ATOM    644  HA  VAL A  46      56.649 -10.285  17.909  1.00  0.00           H  
ATOM    645  HB  VAL A  46      54.258 -11.517  19.280  1.00  0.00           H  
ATOM    646 HG11 VAL A  46      55.904 -12.024  20.801  1.00  0.00           H  
ATOM    647 HG12 VAL A  46      56.908 -10.648  20.338  1.00  0.00           H  
ATOM    648 HG13 VAL A  46      55.464 -10.397  21.319  1.00  0.00           H  
ATOM    649 HG21 VAL A  46      55.227  -8.703  18.877  1.00  0.00           H  
ATOM    650 HG22 VAL A  46      53.651  -9.395  18.491  1.00  0.00           H  
ATOM    651 HG23 VAL A  46      54.108  -9.124  20.173  1.00  0.00           H  
ATOM    652  N   LEU A  47      57.956 -12.319  18.460  1.00  0.00           N  
ATOM    653  CA  LEU A  47      58.774 -13.510  18.658  1.00  0.00           C  
ATOM    654  C   LEU A  47      59.009 -13.769  20.143  1.00  0.00           C  
ATOM    655  O   LEU A  47      59.204 -12.837  20.923  1.00  0.00           O  
ATOM    656  CB  LEU A  47      60.114 -13.358  17.938  1.00  0.00           C  
ATOM    657  CG  LEU A  47      60.130 -13.747  16.459  1.00  0.00           C  
ATOM    658  CD1 LEU A  47      61.464 -13.383  15.825  1.00  0.00           C  
ATOM    659  CD2 LEU A  47      59.846 -15.233  16.296  1.00  0.00           C  
ATOM    660  H   LEU A  47      58.374 -11.436  18.529  1.00  0.00           H  
ATOM    661  HA  LEU A  47      58.242 -14.351  18.238  1.00  0.00           H  
ATOM    662  HB2 LEU A  47      60.413 -12.324  18.011  1.00  0.00           H  
ATOM    663  HB3 LEU A  47      60.837 -13.976  18.452  1.00  0.00           H  
ATOM    664  HG  LEU A  47      59.355 -13.198  15.941  1.00  0.00           H  
ATOM    665 HD11 LEU A  47      61.881 -14.253  15.341  1.00  0.00           H  
ATOM    666 HD12 LEU A  47      62.142 -13.036  16.590  1.00  0.00           H  
ATOM    667 HD13 LEU A  47      61.314 -12.602  15.096  1.00  0.00           H  
ATOM    668 HD21 LEU A  47      60.556 -15.801  16.879  1.00  0.00           H  
ATOM    669 HD22 LEU A  47      59.938 -15.504  15.254  1.00  0.00           H  
ATOM    670 HD23 LEU A  47      58.844 -15.448  16.636  1.00  0.00           H  
ATOM    671  N   HIS A  48      58.988 -15.041  20.527  1.00  0.00           N  
ATOM    672  CA  HIS A  48      59.201 -15.424  21.919  1.00  0.00           C  
ATOM    673  C   HIS A  48      60.477 -16.245  22.067  1.00  0.00           C  
ATOM    674  O   HIS A  48      60.788 -17.087  21.223  1.00  0.00           O  
ATOM    675  CB  HIS A  48      58.004 -16.219  22.441  1.00  0.00           C  
ATOM    676  CG  HIS A  48      56.715 -15.457  22.404  1.00  0.00           C  
ATOM    677  ND1 HIS A  48      56.265 -14.689  23.457  1.00  0.00           N  
ATOM    678  CD2 HIS A  48      55.780 -15.345  21.431  1.00  0.00           C  
ATOM    679  CE1 HIS A  48      55.107 -14.140  23.135  1.00  0.00           C  
ATOM    680  NE2 HIS A  48      54.792 -14.521  21.910  1.00  0.00           N  
ATOM    681  H   HIS A  48      58.826 -15.740  19.859  1.00  0.00           H  
ATOM    682  HA  HIS A  48      59.301 -14.519  22.499  1.00  0.00           H  
ATOM    683  HB2 HIS A  48      57.880 -17.107  21.838  1.00  0.00           H  
ATOM    684  HB3 HIS A  48      58.190 -16.508  23.464  1.00  0.00           H  
ATOM    685  HD1 HIS A  48      56.723 -14.568  24.314  1.00  0.00           H  
ATOM    686  HD2 HIS A  48      55.807 -15.816  20.458  1.00  0.00           H  
ATOM    687  HE1 HIS A  48      54.519 -13.490  23.765  1.00  0.00           H  
ATOM    688  HE2 HIS A  48      53.943 -14.327  21.460  1.00  0.00           H  
ATOM    689  N   LEU A  49      61.213 -15.998  23.145  1.00  0.00           N  
ATOM    690  CA  LEU A  49      62.457 -16.714  23.404  1.00  0.00           C  
ATOM    691  C   LEU A  49      62.737 -16.797  24.901  1.00  0.00           C  
ATOM    692  O   LEU A  49      61.926 -16.362  25.719  1.00  0.00           O  
ATOM    693  CB  LEU A  49      63.624 -16.026  22.693  1.00  0.00           C  
ATOM    694  CG  LEU A  49      63.568 -14.499  22.639  1.00  0.00           C  
ATOM    695  CD1 LEU A  49      64.972 -13.916  22.584  1.00  0.00           C  
ATOM    696  CD2 LEU A  49      62.749 -14.036  21.443  1.00  0.00           C  
ATOM    697  H   LEU A  49      60.914 -15.316  23.782  1.00  0.00           H  
ATOM    698  HA  LEU A  49      62.349 -17.716  23.013  1.00  0.00           H  
ATOM    699  HB2 LEU A  49      64.532 -16.306  23.202  1.00  0.00           H  
ATOM    700  HB3 LEU A  49      63.654 -16.393  21.677  1.00  0.00           H  
ATOM    701  HG  LEU A  49      63.090 -14.129  23.536  1.00  0.00           H  
ATOM    702 HD11 LEU A  49      65.023 -13.038  23.211  1.00  0.00           H  
ATOM    703 HD12 LEU A  49      65.209 -13.644  21.565  1.00  0.00           H  
ATOM    704 HD13 LEU A  49      65.681 -14.651  22.934  1.00  0.00           H  
ATOM    705 HD21 LEU A  49      63.302 -13.286  20.896  1.00  0.00           H  
ATOM    706 HD22 LEU A  49      61.815 -13.617  21.787  1.00  0.00           H  
ATOM    707 HD23 LEU A  49      62.548 -14.879  20.797  1.00  0.00           H  
ATOM    708  N   HIS A  50      63.889 -17.357  25.252  1.00  0.00           N  
ATOM    709  CA  HIS A  50      64.278 -17.494  26.652  1.00  0.00           C  
ATOM    710  C   HIS A  50      64.084 -16.179  27.401  1.00  0.00           C  
ATOM    711  O   HIS A  50      63.714 -15.165  26.808  1.00  0.00           O  
ATOM    712  CB  HIS A  50      65.735 -17.945  26.757  1.00  0.00           C  
ATOM    713  CG  HIS A  50      66.098 -18.490  28.104  1.00  0.00           C  
ATOM    714  ND1 HIS A  50      65.248 -19.280  28.850  1.00  0.00           N  
ATOM    715  CD2 HIS A  50      67.227 -18.356  28.839  1.00  0.00           C  
ATOM    716  CE1 HIS A  50      65.839 -19.607  29.986  1.00  0.00           C  
ATOM    717  NE2 HIS A  50      67.041 -19.059  30.003  1.00  0.00           N  
ATOM    718  H   HIS A  50      64.494 -17.685  24.554  1.00  0.00           H  
ATOM    719  HA  HIS A  50      63.645 -18.246  27.100  1.00  0.00           H  
ATOM    720  HB2 HIS A  50      65.919 -18.719  26.026  1.00  0.00           H  
ATOM    721  HB3 HIS A  50      66.381 -17.103  26.553  1.00  0.00           H  
ATOM    722  HD1 HIS A  50      64.347 -19.558  28.587  1.00  0.00           H  
ATOM    723  HD2 HIS A  50      68.110 -17.798  28.561  1.00  0.00           H  
ATOM    724  HE1 HIS A  50      65.413 -20.219  30.766  1.00  0.00           H  
ATOM    725  HE2 HIS A  50      67.655 -19.073  30.766  1.00  0.00           H  
ATOM    726  N   ARG A  51      64.336 -16.205  28.705  1.00  0.00           N  
ATOM    727  CA  ARG A  51      64.187 -15.015  29.535  1.00  0.00           C  
ATOM    728  C   ARG A  51      64.563 -13.758  28.756  1.00  0.00           C  
ATOM    729  O   ARG A  51      63.985 -12.691  28.964  1.00  0.00           O  
ATOM    730  CB  ARG A  51      65.056 -15.130  30.789  1.00  0.00           C  
ATOM    731  CG  ARG A  51      64.688 -16.305  31.679  1.00  0.00           C  
ATOM    732  CD  ARG A  51      63.475 -15.993  32.542  1.00  0.00           C  
ATOM    733  NE  ARG A  51      63.746 -14.924  33.499  1.00  0.00           N  
ATOM    734  CZ  ARG A  51      63.050 -14.746  34.617  1.00  0.00           C  
ATOM    735  NH1 ARG A  51      62.047 -15.560  34.915  1.00  0.00           N  
ATOM    736  NH2 ARG A  51      63.356 -13.750  35.440  1.00  0.00           N  
ATOM    737  H   ARG A  51      64.628 -17.043  29.120  1.00  0.00           H  
ATOM    738  HA  ARG A  51      63.151 -14.944  29.831  1.00  0.00           H  
ATOM    739  HB2 ARG A  51      66.088 -15.244  30.489  1.00  0.00           H  
ATOM    740  HB3 ARG A  51      64.956 -14.223  31.366  1.00  0.00           H  
ATOM    741  HG2 ARG A  51      64.463 -17.159  31.058  1.00  0.00           H  
ATOM    742  HG3 ARG A  51      65.525 -16.535  32.321  1.00  0.00           H  
ATOM    743  HD2 ARG A  51      62.662 -15.689  31.898  1.00  0.00           H  
ATOM    744  HD3 ARG A  51      63.193 -16.885  33.081  1.00  0.00           H  
ATOM    745  HE  ARG A  51      64.482 -14.309  33.299  1.00  0.00           H  
ATOM    746 HH11 ARG A  51      61.815 -16.312  34.298  1.00  0.00           H  
ATOM    747 HH12 ARG A  51      61.526 -15.425  35.758  1.00  0.00           H  
ATOM    748 HH21 ARG A  51      64.112 -13.134  35.218  1.00  0.00           H  
ATOM    749 HH22 ARG A  51      62.833 -13.617  36.280  1.00  0.00           H  
ATOM    750  N   ARG A  52      65.534 -13.893  27.859  1.00  0.00           N  
ATOM    751  CA  ARG A  52      65.989 -12.768  27.050  1.00  0.00           C  
ATOM    752  C   ARG A  52      64.811 -11.905  26.609  1.00  0.00           C  
ATOM    753  O   ARG A  52      63.669 -12.363  26.583  1.00  0.00           O  
ATOM    754  CB  ARG A  52      66.754 -13.270  25.824  1.00  0.00           C  
ATOM    755  CG  ARG A  52      68.043 -13.999  26.168  1.00  0.00           C  
ATOM    756  CD  ARG A  52      69.222 -13.041  26.237  1.00  0.00           C  
ATOM    757  NE  ARG A  52      70.500 -13.748  26.255  1.00  0.00           N  
ATOM    758  CZ  ARG A  52      71.665 -13.156  26.501  1.00  0.00           C  
ATOM    759  NH1 ARG A  52      71.711 -11.854  26.748  1.00  0.00           N  
ATOM    760  NH2 ARG A  52      72.785 -13.867  26.500  1.00  0.00           N  
ATOM    761  H   ARG A  52      65.957 -14.769  27.739  1.00  0.00           H  
ATOM    762  HA  ARG A  52      66.652 -12.169  27.656  1.00  0.00           H  
ATOM    763  HB2 ARG A  52      66.120 -13.947  25.271  1.00  0.00           H  
ATOM    764  HB3 ARG A  52      66.999 -12.425  25.198  1.00  0.00           H  
ATOM    765  HG2 ARG A  52      67.928 -14.481  27.127  1.00  0.00           H  
ATOM    766  HG3 ARG A  52      68.238 -14.742  25.409  1.00  0.00           H  
ATOM    767  HD2 ARG A  52      69.193 -12.392  25.375  1.00  0.00           H  
ATOM    768  HD3 ARG A  52      69.136 -12.449  27.136  1.00  0.00           H  
ATOM    769  HE  ARG A  52      70.490 -14.711  26.074  1.00  0.00           H  
ATOM    770 HH11 ARG A  52      70.868 -11.317  26.751  1.00  0.00           H  
ATOM    771 HH12 ARG A  52      72.588 -11.412  26.934  1.00  0.00           H  
ATOM    772 HH21 ARG A  52      72.754 -14.849  26.313  1.00  0.00           H  
ATOM    773 HH22 ARG A  52      73.660 -13.421  26.684  1.00  0.00           H  
ATOM    774  N   GLU A  53      65.097 -10.654  26.264  1.00  0.00           N  
ATOM    775  CA  GLU A  53      64.060  -9.727  25.824  1.00  0.00           C  
ATOM    776  C   GLU A  53      63.434 -10.192  24.513  1.00  0.00           C  
ATOM    777  O   GLU A  53      64.107 -10.774  23.664  1.00  0.00           O  
ATOM    778  CB  GLU A  53      64.640  -8.321  25.655  1.00  0.00           C  
ATOM    779  CG  GLU A  53      65.726  -8.233  24.596  1.00  0.00           C  
ATOM    780  CD  GLU A  53      66.672  -7.071  24.824  1.00  0.00           C  
ATOM    781  OE1 GLU A  53      66.358  -5.951  24.368  1.00  0.00           O  
ATOM    782  OE2 GLU A  53      67.727  -7.281  25.458  1.00  0.00           O  
ATOM    783  H   GLU A  53      66.027 -10.347  26.305  1.00  0.00           H  
ATOM    784  HA  GLU A  53      63.295  -9.701  26.585  1.00  0.00           H  
ATOM    785  HB2 GLU A  53      63.843  -7.646  25.382  1.00  0.00           H  
ATOM    786  HB3 GLU A  53      65.061  -8.002  26.598  1.00  0.00           H  
ATOM    787  HG2 GLU A  53      66.296  -9.150  24.606  1.00  0.00           H  
ATOM    788  HG3 GLU A  53      65.257  -8.113  23.629  1.00  0.00           H  
ATOM    789  N   ALA A  54      62.141  -9.930  24.356  1.00  0.00           N  
ATOM    790  CA  ALA A  54      61.423 -10.319  23.148  1.00  0.00           C  
ATOM    791  C   ALA A  54      61.513  -9.233  22.082  1.00  0.00           C  
ATOM    792  O   ALA A  54      62.144  -8.196  22.289  1.00  0.00           O  
ATOM    793  CB  ALA A  54      59.969 -10.624  23.474  1.00  0.00           C  
ATOM    794  H   ALA A  54      61.658  -9.462  25.069  1.00  0.00           H  
ATOM    795  HA  ALA A  54      61.878 -11.222  22.766  1.00  0.00           H  
ATOM    796  HB1 ALA A  54      59.353 -10.398  22.616  1.00  0.00           H  
ATOM    797  HB2 ALA A  54      59.868 -11.669  23.724  1.00  0.00           H  
ATOM    798  HB3 ALA A  54      59.654 -10.020  24.311  1.00  0.00           H  
ATOM    799  N   VAL A  55      60.879  -9.478  20.939  1.00  0.00           N  
ATOM    800  CA  VAL A  55      60.886  -8.520  19.841  1.00  0.00           C  
ATOM    801  C   VAL A  55      59.531  -8.472  19.143  1.00  0.00           C  
ATOM    802  O   VAL A  55      58.751  -9.422  19.215  1.00  0.00           O  
ATOM    803  CB  VAL A  55      61.973  -8.863  18.804  1.00  0.00           C  
ATOM    804  CG1 VAL A  55      62.147  -7.722  17.814  1.00  0.00           C  
ATOM    805  CG2 VAL A  55      63.288  -9.183  19.498  1.00  0.00           C  
ATOM    806  H   VAL A  55      60.393 -10.322  20.834  1.00  0.00           H  
ATOM    807  HA  VAL A  55      61.104  -7.544  20.250  1.00  0.00           H  
ATOM    808  HB  VAL A  55      61.656  -9.740  18.258  1.00  0.00           H  
ATOM    809 HG11 VAL A  55      61.382  -7.786  17.054  1.00  0.00           H  
ATOM    810 HG12 VAL A  55      62.062  -6.779  18.333  1.00  0.00           H  
ATOM    811 HG13 VAL A  55      63.120  -7.793  17.351  1.00  0.00           H  
ATOM    812 HG21 VAL A  55      63.497  -8.427  20.241  1.00  0.00           H  
ATOM    813 HG22 VAL A  55      63.217 -10.149  19.977  1.00  0.00           H  
ATOM    814 HG23 VAL A  55      64.085  -9.200  18.769  1.00  0.00           H  
ATOM    815  N   ARG A  56      59.258  -7.361  18.468  1.00  0.00           N  
ATOM    816  CA  ARG A  56      57.997  -7.188  17.758  1.00  0.00           C  
ATOM    817  C   ARG A  56      58.225  -6.553  16.389  1.00  0.00           C  
ATOM    818  O   ARG A  56      59.177  -5.796  16.197  1.00  0.00           O  
ATOM    819  CB  ARG A  56      57.038  -6.324  18.580  1.00  0.00           C  
ATOM    820  CG  ARG A  56      57.151  -6.547  20.079  1.00  0.00           C  
ATOM    821  CD  ARG A  56      56.557  -5.386  20.860  1.00  0.00           C  
ATOM    822  NE  ARG A  56      56.062  -5.803  22.169  1.00  0.00           N  
ATOM    823  CZ  ARG A  56      55.393  -5.002  22.992  1.00  0.00           C  
ATOM    824  NH1 ARG A  56      55.140  -3.748  22.642  1.00  0.00           N  
ATOM    825  NH2 ARG A  56      54.975  -5.455  24.166  1.00  0.00           N  
ATOM    826  H   ARG A  56      59.920  -6.638  18.448  1.00  0.00           H  
ATOM    827  HA  ARG A  56      57.558  -8.165  17.619  1.00  0.00           H  
ATOM    828  HB2 ARG A  56      57.245  -5.284  18.376  1.00  0.00           H  
ATOM    829  HB3 ARG A  56      56.026  -6.547  18.279  1.00  0.00           H  
ATOM    830  HG2 ARG A  56      56.620  -7.451  20.340  1.00  0.00           H  
ATOM    831  HG3 ARG A  56      58.193  -6.650  20.340  1.00  0.00           H  
ATOM    832  HD2 ARG A  56      57.320  -4.634  20.997  1.00  0.00           H  
ATOM    833  HD3 ARG A  56      55.739  -4.968  20.292  1.00  0.00           H  
ATOM    834  HE  ARG A  56      56.237  -6.725  22.447  1.00  0.00           H  
ATOM    835 HH11 ARG A  56      55.453  -3.405  21.757  1.00  0.00           H  
ATOM    836 HH12 ARG A  56      54.636  -3.148  23.262  1.00  0.00           H  
ATOM    837 HH21 ARG A  56      55.163  -6.400  24.434  1.00  0.00           H  
ATOM    838 HH22 ARG A  56      54.472  -4.852  24.784  1.00  0.00           H  
ATOM    839  N   TRP A  57      57.348  -6.866  15.444  1.00  0.00           N  
ATOM    840  CA  TRP A  57      57.455  -6.326  14.093  1.00  0.00           C  
ATOM    841  C   TRP A  57      56.080  -5.959  13.544  1.00  0.00           C  
ATOM    842  O   TRP A  57      55.223  -6.816  13.327  1.00  0.00           O  
ATOM    843  CB  TRP A  57      58.133  -7.338  13.169  1.00  0.00           C  
ATOM    844  CG  TRP A  57      59.582  -7.555  13.487  1.00  0.00           C  
ATOM    845  CD1 TRP A  57      60.637  -6.801  13.058  1.00  0.00           C  
ATOM    846  CD2 TRP A  57      60.134  -8.596  14.300  1.00  0.00           C  
ATOM    847  NE1 TRP A  57      61.811  -7.310  13.557  1.00  0.00           N  
ATOM    848  CE2 TRP A  57      61.530  -8.411  14.322  1.00  0.00           C  
ATOM    849  CE3 TRP A  57      59.585  -9.664  15.014  1.00  0.00           C  
ATOM    850  CZ2 TRP A  57      62.383  -9.257  15.028  1.00  0.00           C  
ATOM    851  CZ3 TRP A  57      60.432 -10.503  15.715  1.00  0.00           C  
ATOM    852  CH2 TRP A  57      61.818 -10.294  15.718  1.00  0.00           C  
ATOM    853  H   TRP A  57      56.610  -7.475  15.659  1.00  0.00           H  
ATOM    854  HA  TRP A  57      58.060  -5.433  14.141  1.00  0.00           H  
ATOM    855  HB2 TRP A  57      57.628  -8.289  13.254  1.00  0.00           H  
ATOM    856  HB3 TRP A  57      58.064  -6.987  12.150  1.00  0.00           H  
ATOM    857  HD1 TRP A  57      60.546  -5.935  12.421  1.00  0.00           H  
ATOM    858  HE1 TRP A  57      62.706  -6.944  13.391  1.00  0.00           H  
ATOM    859  HE3 TRP A  57      58.520  -9.842  15.024  1.00  0.00           H  
ATOM    860  HZ2 TRP A  57      63.452  -9.109  15.042  1.00  0.00           H  
ATOM    861  HZ3 TRP A  57      60.026 -11.334  16.272  1.00  0.00           H  
ATOM    862  HH2 TRP A  57      62.441 -10.974  16.278  1.00  0.00           H  
ATOM    863  N   PRO A  58      55.863  -4.657  13.310  1.00  0.00           N  
ATOM    864  CA  PRO A  58      54.594  -4.147  12.782  1.00  0.00           C  
ATOM    865  C   PRO A  58      54.371  -4.545  11.327  1.00  0.00           C  
ATOM    866  O   PRO A  58      55.258  -4.388  10.487  1.00  0.00           O  
ATOM    867  CB  PRO A  58      54.742  -2.629  12.905  1.00  0.00           C  
ATOM    868  CG  PRO A  58      56.212  -2.388  12.876  1.00  0.00           C  
ATOM    869  CD  PRO A  58      56.840  -3.580  13.545  1.00  0.00           C  
ATOM    870  HA  PRO A  58      53.756  -4.478  13.376  1.00  0.00           H  
ATOM    871  HB2 PRO A  58      54.247  -2.147  12.073  1.00  0.00           H  
ATOM    872  HB3 PRO A  58      54.306  -2.295  13.834  1.00  0.00           H  
ATOM    873  HG2 PRO A  58      56.552  -2.310  11.855  1.00  0.00           H  
ATOM    874  HG3 PRO A  58      56.447  -1.486  13.422  1.00  0.00           H  
ATOM    875  HD2 PRO A  58      57.790  -3.813  13.086  1.00  0.00           H  
ATOM    876  HD3 PRO A  58      56.965  -3.397  14.602  1.00  0.00           H  
ATOM    877  N   TYR A  59      53.182  -5.060  11.034  1.00  0.00           N  
ATOM    878  CA  TYR A  59      52.844  -5.481   9.681  1.00  0.00           C  
ATOM    879  C   TYR A  59      53.103  -4.360   8.680  1.00  0.00           C  
ATOM    880  O   TYR A  59      53.270  -4.605   7.484  1.00  0.00           O  
ATOM    881  CB  TYR A  59      51.378  -5.915   9.611  1.00  0.00           C  
ATOM    882  CG  TYR A  59      51.103  -7.235  10.295  1.00  0.00           C  
ATOM    883  CD1 TYR A  59      51.896  -8.348  10.045  1.00  0.00           C  
ATOM    884  CD2 TYR A  59      50.051  -7.368  11.192  1.00  0.00           C  
ATOM    885  CE1 TYR A  59      51.649  -9.555  10.668  1.00  0.00           C  
ATOM    886  CE2 TYR A  59      49.797  -8.572  11.821  1.00  0.00           C  
ATOM    887  CZ  TYR A  59      50.598  -9.662  11.555  1.00  0.00           C  
ATOM    888  OH  TYR A  59      50.349 -10.864  12.179  1.00  0.00           O  
ATOM    889  H   TYR A  59      52.517  -5.160  11.747  1.00  0.00           H  
ATOM    890  HA  TYR A  59      53.470  -6.325   9.429  1.00  0.00           H  
ATOM    891  HB2 TYR A  59      50.764  -5.163  10.083  1.00  0.00           H  
ATOM    892  HB3 TYR A  59      51.088  -6.011   8.574  1.00  0.00           H  
ATOM    893  HD1 TYR A  59      52.719  -8.260   9.350  1.00  0.00           H  
ATOM    894  HD2 TYR A  59      49.425  -6.513  11.399  1.00  0.00           H  
ATOM    895  HE1 TYR A  59      52.276 -10.410  10.460  1.00  0.00           H  
ATOM    896  HE2 TYR A  59      48.974  -8.657  12.515  1.00  0.00           H  
ATOM    897  HH  TYR A  59      49.742 -10.725  12.909  1.00  0.00           H  
ATOM    898  N   LEU A  60      53.135  -3.129   9.177  1.00  0.00           N  
ATOM    899  CA  LEU A  60      53.374  -1.966   8.328  1.00  0.00           C  
ATOM    900  C   LEU A  60      54.765  -2.024   7.705  1.00  0.00           C  
ATOM    901  O   LEU A  60      54.914  -2.328   6.521  1.00  0.00           O  
ATOM    902  CB  LEU A  60      53.218  -0.677   9.137  1.00  0.00           C  
ATOM    903  CG  LEU A  60      51.815  -0.069   9.167  1.00  0.00           C  
ATOM    904  CD1 LEU A  60      51.391   0.363   7.773  1.00  0.00           C  
ATOM    905  CD2 LEU A  60      50.817  -1.060   9.747  1.00  0.00           C  
ATOM    906  H   LEU A  60      52.994  -2.996  10.137  1.00  0.00           H  
ATOM    907  HA  LEU A  60      52.638  -1.976   7.538  1.00  0.00           H  
ATOM    908  HB2 LEU A  60      53.508  -0.889  10.155  1.00  0.00           H  
ATOM    909  HB3 LEU A  60      53.890   0.058   8.719  1.00  0.00           H  
ATOM    910  HG  LEU A  60      51.823   0.807   9.800  1.00  0.00           H  
ATOM    911 HD11 LEU A  60      52.068  -0.057   7.044  1.00  0.00           H  
ATOM    912 HD12 LEU A  60      51.416   1.441   7.708  1.00  0.00           H  
ATOM    913 HD13 LEU A  60      50.388   0.014   7.577  1.00  0.00           H  
ATOM    914 HD21 LEU A  60      50.961  -2.027   9.289  1.00  0.00           H  
ATOM    915 HD22 LEU A  60      49.812  -0.716   9.550  1.00  0.00           H  
ATOM    916 HD23 LEU A  60      50.967  -1.140  10.815  1.00  0.00           H  
ATOM    917  N   CYS A  61      55.781  -1.733   8.510  1.00  0.00           N  
ATOM    918  CA  CYS A  61      57.160  -1.754   8.039  1.00  0.00           C  
ATOM    919  C   CYS A  61      57.374  -2.877   7.031  1.00  0.00           C  
ATOM    920  O   CYS A  61      57.892  -2.655   5.936  1.00  0.00           O  
ATOM    921  CB  CYS A  61      58.121  -1.920   9.217  1.00  0.00           C  
ATOM    922  SG  CYS A  61      58.620  -0.361   9.988  1.00  0.00           S  
ATOM    923  H   CYS A  61      55.598  -1.498   9.445  1.00  0.00           H  
ATOM    924  HA  CYS A  61      57.358  -0.810   7.554  1.00  0.00           H  
ATOM    925  HB2 CYS A  61      57.648  -2.524   9.977  1.00  0.00           H  
ATOM    926  HB3 CYS A  61      59.015  -2.420   8.875  1.00  0.00           H  
ATOM    927  HG  CYS A  61      57.630   0.044  10.768  1.00  0.00           H  
ATOM    928  N   LEU A  62      56.974  -4.087   7.408  1.00  0.00           N  
ATOM    929  CA  LEU A  62      57.122  -5.249   6.537  1.00  0.00           C  
ATOM    930  C   LEU A  62      56.932  -4.860   5.074  1.00  0.00           C  
ATOM    931  O   LEU A  62      55.805  -4.777   4.585  1.00  0.00           O  
ATOM    932  CB  LEU A  62      56.115  -6.332   6.924  1.00  0.00           C  
ATOM    933  CG  LEU A  62      56.426  -7.113   8.201  1.00  0.00           C  
ATOM    934  CD1 LEU A  62      55.309  -8.097   8.512  1.00  0.00           C  
ATOM    935  CD2 LEU A  62      57.757  -7.838   8.073  1.00  0.00           C  
ATOM    936  H   LEU A  62      56.568  -4.203   8.292  1.00  0.00           H  
ATOM    937  HA  LEU A  62      58.122  -5.634   6.667  1.00  0.00           H  
ATOM    938  HB2 LEU A  62      55.153  -5.860   7.051  1.00  0.00           H  
ATOM    939  HB3 LEU A  62      56.062  -7.040   6.107  1.00  0.00           H  
ATOM    940  HG  LEU A  62      56.500  -6.421   9.029  1.00  0.00           H  
ATOM    941 HD11 LEU A  62      55.287  -8.294   9.573  1.00  0.00           H  
ATOM    942 HD12 LEU A  62      55.482  -9.019   7.977  1.00  0.00           H  
ATOM    943 HD13 LEU A  62      54.363  -7.676   8.203  1.00  0.00           H  
ATOM    944 HD21 LEU A  62      58.140  -7.713   7.072  1.00  0.00           H  
ATOM    945 HD22 LEU A  62      57.615  -8.889   8.277  1.00  0.00           H  
ATOM    946 HD23 LEU A  62      58.461  -7.427   8.782  1.00  0.00           H  
ATOM    947  N   ARG A  63      58.042  -4.625   4.381  1.00  0.00           N  
ATOM    948  CA  ARG A  63      57.997  -4.247   2.974  1.00  0.00           C  
ATOM    949  C   ARG A  63      57.761  -5.469   2.089  1.00  0.00           C  
ATOM    950  O   ARG A  63      56.945  -5.433   1.169  1.00  0.00           O  
ATOM    951  CB  ARG A  63      59.299  -3.555   2.568  1.00  0.00           C  
ATOM    952  CG  ARG A  63      60.524  -4.091   3.290  1.00  0.00           C  
ATOM    953  CD  ARG A  63      60.803  -3.315   4.567  1.00  0.00           C  
ATOM    954  NE  ARG A  63      61.552  -2.087   4.310  1.00  0.00           N  
ATOM    955  CZ  ARG A  63      61.603  -1.067   5.158  1.00  0.00           C  
ATOM    956  NH1 ARG A  63      60.955  -1.126   6.312  1.00  0.00           N  
ATOM    957  NH2 ARG A  63      62.306   0.017   4.852  1.00  0.00           N  
ATOM    958  H   ARG A  63      58.910  -4.708   4.826  1.00  0.00           H  
ATOM    959  HA  ARG A  63      57.177  -3.558   2.841  1.00  0.00           H  
ATOM    960  HB2 ARG A  63      59.448  -3.686   1.506  1.00  0.00           H  
ATOM    961  HB3 ARG A  63      59.214  -2.500   2.785  1.00  0.00           H  
ATOM    962  HG2 ARG A  63      60.357  -5.128   3.541  1.00  0.00           H  
ATOM    963  HG3 ARG A  63      61.380  -4.010   2.635  1.00  0.00           H  
ATOM    964  HD2 ARG A  63      59.862  -3.060   5.031  1.00  0.00           H  
ATOM    965  HD3 ARG A  63      61.376  -3.941   5.235  1.00  0.00           H  
ATOM    966  HE  ARG A  63      62.039  -2.022   3.462  1.00  0.00           H  
ATOM    967 HH11 ARG A  63      60.425  -1.942   6.546  1.00  0.00           H  
ATOM    968 HH12 ARG A  63      60.996  -0.357   6.950  1.00  0.00           H  
ATOM    969 HH21 ARG A  63      62.797   0.065   3.983  1.00  0.00           H  
ATOM    970 HH22 ARG A  63      62.344   0.784   5.491  1.00  0.00           H  
ATOM    971  N   ARG A  64      58.483  -6.547   2.374  1.00  0.00           N  
ATOM    972  CA  ARG A  64      58.354  -7.778   1.604  1.00  0.00           C  
ATOM    973  C   ARG A  64      58.281  -8.991   2.527  1.00  0.00           C  
ATOM    974  O   ARG A  64      59.010  -9.077   3.516  1.00  0.00           O  
ATOM    975  CB  ARG A  64      59.533  -7.928   0.641  1.00  0.00           C  
ATOM    976  CG  ARG A  64      60.735  -8.630   1.252  1.00  0.00           C  
ATOM    977  CD  ARG A  64      61.830  -8.856   0.222  1.00  0.00           C  
ATOM    978  NE  ARG A  64      62.555  -7.627  -0.086  1.00  0.00           N  
ATOM    979  CZ  ARG A  64      63.524  -7.552  -0.991  1.00  0.00           C  
ATOM    980  NH1 ARG A  64      63.884  -8.630  -1.673  1.00  0.00           N  
ATOM    981  NH2 ARG A  64      64.136  -6.396  -1.216  1.00  0.00           N  
ATOM    982  H   ARG A  64      59.118  -6.513   3.120  1.00  0.00           H  
ATOM    983  HA  ARG A  64      57.440  -7.719   1.035  1.00  0.00           H  
ATOM    984  HB2 ARG A  64      59.210  -8.497  -0.218  1.00  0.00           H  
ATOM    985  HB3 ARG A  64      59.843  -6.947   0.316  1.00  0.00           H  
ATOM    986  HG2 ARG A  64      61.128  -8.019   2.052  1.00  0.00           H  
ATOM    987  HG3 ARG A  64      60.420  -9.584   1.647  1.00  0.00           H  
ATOM    988  HD2 ARG A  64      62.526  -9.584   0.612  1.00  0.00           H  
ATOM    989  HD3 ARG A  64      61.382  -9.236  -0.683  1.00  0.00           H  
ATOM    990  HE  ARG A  64      62.305  -6.816   0.406  1.00  0.00           H  
ATOM    991 HH11 ARG A  64      63.424  -9.502  -1.506  1.00  0.00           H  
ATOM    992 HH12 ARG A  64      64.614  -8.572  -2.355  1.00  0.00           H  
ATOM    993 HH21 ARG A  64      63.867  -5.581  -0.704  1.00  0.00           H  
ATOM    994 HH22 ARG A  64      64.866  -6.341  -1.897  1.00  0.00           H  
ATOM    995  N   TYR A  65      57.396  -9.925   2.199  1.00  0.00           N  
ATOM    996  CA  TYR A  65      57.225 -11.132   2.999  1.00  0.00           C  
ATOM    997  C   TYR A  65      57.016 -12.352   2.107  1.00  0.00           C  
ATOM    998  O   TYR A  65      55.965 -12.512   1.490  1.00  0.00           O  
ATOM    999  CB  TYR A  65      56.038 -10.974   3.951  1.00  0.00           C  
ATOM   1000  CG  TYR A  65      54.709 -10.829   3.245  1.00  0.00           C  
ATOM   1001  CD1 TYR A  65      54.358  -9.637   2.622  1.00  0.00           C  
ATOM   1002  CD2 TYR A  65      53.806 -11.883   3.199  1.00  0.00           C  
ATOM   1003  CE1 TYR A  65      53.145  -9.501   1.975  1.00  0.00           C  
ATOM   1004  CE2 TYR A  65      52.591 -11.756   2.554  1.00  0.00           C  
ATOM   1005  CZ  TYR A  65      52.265 -10.563   1.943  1.00  0.00           C  
ATOM   1006  OH  TYR A  65      51.056 -10.430   1.300  1.00  0.00           O  
ATOM   1007  H   TYR A  65      56.842  -9.800   1.399  1.00  0.00           H  
ATOM   1008  HA  TYR A  65      58.124 -11.274   3.581  1.00  0.00           H  
ATOM   1009  HB2 TYR A  65      55.980 -11.842   4.591  1.00  0.00           H  
ATOM   1010  HB3 TYR A  65      56.189 -10.093   4.559  1.00  0.00           H  
ATOM   1011  HD1 TYR A  65      55.049  -8.808   2.649  1.00  0.00           H  
ATOM   1012  HD2 TYR A  65      54.064 -12.817   3.678  1.00  0.00           H  
ATOM   1013  HE1 TYR A  65      52.889  -8.566   1.498  1.00  0.00           H  
ATOM   1014  HE2 TYR A  65      51.902 -12.586   2.529  1.00  0.00           H  
ATOM   1015  HH  TYR A  65      50.419 -10.026   1.895  1.00  0.00           H  
ATOM   1016  N   GLY A  66      58.028 -13.212   2.046  1.00  0.00           N  
ATOM   1017  CA  GLY A  66      57.937 -14.408   1.229  1.00  0.00           C  
ATOM   1018  C   GLY A  66      58.013 -15.679   2.051  1.00  0.00           C  
ATOM   1019  O   GLY A  66      57.821 -15.653   3.267  1.00  0.00           O  
ATOM   1020  H   GLY A  66      58.843 -13.033   2.561  1.00  0.00           H  
ATOM   1021  HA2 GLY A  66      57.002 -14.393   0.692  1.00  0.00           H  
ATOM   1022  HA3 GLY A  66      58.750 -14.405   0.517  1.00  0.00           H  
ATOM   1023  N   TYR A  67      58.292 -16.796   1.387  1.00  0.00           N  
ATOM   1024  CA  TYR A  67      58.387 -18.084   2.063  1.00  0.00           C  
ATOM   1025  C   TYR A  67      59.162 -19.089   1.216  1.00  0.00           C  
ATOM   1026  O   TYR A  67      59.446 -18.841   0.044  1.00  0.00           O  
ATOM   1027  CB  TYR A  67      56.990 -18.627   2.369  1.00  0.00           C  
ATOM   1028  CG  TYR A  67      56.411 -19.469   1.253  1.00  0.00           C  
ATOM   1029  CD1 TYR A  67      56.034 -18.894   0.047  1.00  0.00           C  
ATOM   1030  CD2 TYR A  67      56.242 -20.839   1.407  1.00  0.00           C  
ATOM   1031  CE1 TYR A  67      55.504 -19.658  -0.975  1.00  0.00           C  
ATOM   1032  CE2 TYR A  67      55.713 -21.612   0.392  1.00  0.00           C  
ATOM   1033  CZ  TYR A  67      55.345 -21.016  -0.797  1.00  0.00           C  
ATOM   1034  OH  TYR A  67      54.818 -21.781  -1.813  1.00  0.00           O  
ATOM   1035  H   TYR A  67      58.434 -16.753   0.419  1.00  0.00           H  
ATOM   1036  HA  TYR A  67      58.914 -17.932   2.994  1.00  0.00           H  
ATOM   1037  HB2 TYR A  67      57.036 -19.241   3.256  1.00  0.00           H  
ATOM   1038  HB3 TYR A  67      56.319 -17.800   2.544  1.00  0.00           H  
ATOM   1039  HD1 TYR A  67      56.160 -17.828  -0.088  1.00  0.00           H  
ATOM   1040  HD2 TYR A  67      56.530 -21.303   2.339  1.00  0.00           H  
ATOM   1041  HE1 TYR A  67      55.216 -19.192  -1.905  1.00  0.00           H  
ATOM   1042  HE2 TYR A  67      55.587 -22.676   0.529  1.00  0.00           H  
ATOM   1043  HH  TYR A  67      55.459 -21.854  -2.524  1.00  0.00           H  
ATOM   1044  N   ASP A  68      59.502 -20.222   1.818  1.00  0.00           N  
ATOM   1045  CA  ASP A  68      60.242 -21.267   1.120  1.00  0.00           C  
ATOM   1046  C   ASP A  68      60.376 -22.513   1.989  1.00  0.00           C  
ATOM   1047  O   ASP A  68      60.133 -22.469   3.196  1.00  0.00           O  
ATOM   1048  CB  ASP A  68      61.628 -20.758   0.720  1.00  0.00           C  
ATOM   1049  CG  ASP A  68      61.639 -20.133  -0.662  1.00  0.00           C  
ATOM   1050  OD1 ASP A  68      60.957 -20.670  -1.561  1.00  0.00           O  
ATOM   1051  OD2 ASP A  68      62.328 -19.108  -0.843  1.00  0.00           O  
ATOM   1052  H   ASP A  68      59.247 -20.362   2.754  1.00  0.00           H  
ATOM   1053  HA  ASP A  68      59.692 -21.523   0.227  1.00  0.00           H  
ATOM   1054  HB2 ASP A  68      61.951 -20.013   1.433  1.00  0.00           H  
ATOM   1055  HB3 ASP A  68      62.324 -21.584   0.727  1.00  0.00           H  
ATOM   1056  N   SER A  69      60.763 -23.623   1.369  1.00  0.00           N  
ATOM   1057  CA  SER A  69      60.924 -24.883   2.086  1.00  0.00           C  
ATOM   1058  C   SER A  69      61.517 -24.647   3.472  1.00  0.00           C  
ATOM   1059  O   SER A  69      62.625 -24.129   3.604  1.00  0.00           O  
ATOM   1060  CB  SER A  69      61.819 -25.835   1.291  1.00  0.00           C  
ATOM   1061  OG  SER A  69      61.450 -25.859  -0.077  1.00  0.00           O  
ATOM   1062  H   SER A  69      60.941 -23.594   0.406  1.00  0.00           H  
ATOM   1063  HA  SER A  69      59.947 -25.328   2.196  1.00  0.00           H  
ATOM   1064  HB2 SER A  69      62.845 -25.509   1.368  1.00  0.00           H  
ATOM   1065  HB3 SER A  69      61.726 -26.833   1.695  1.00  0.00           H  
ATOM   1066  HG  SER A  69      61.791 -25.078  -0.516  1.00  0.00           H  
ATOM   1067  N   ASN A  70      60.770 -25.032   4.501  1.00  0.00           N  
ATOM   1068  CA  ASN A  70      61.220 -24.863   5.878  1.00  0.00           C  
ATOM   1069  C   ASN A  70      62.076 -23.607   6.020  1.00  0.00           C  
ATOM   1070  O   ASN A  70      63.104 -23.617   6.697  1.00  0.00           O  
ATOM   1071  CB  ASN A  70      62.015 -26.088   6.331  1.00  0.00           C  
ATOM   1072  CG  ASN A  70      63.127 -26.446   5.364  1.00  0.00           C  
ATOM   1073  OD1 ASN A  70      62.879 -26.996   4.291  1.00  0.00           O  
ATOM   1074  ND2 ASN A  70      64.362 -26.134   5.740  1.00  0.00           N  
ATOM   1075  H   ASN A  70      59.894 -25.439   4.332  1.00  0.00           H  
ATOM   1076  HA  ASN A  70      60.345 -24.761   6.502  1.00  0.00           H  
ATOM   1077  HB2 ASN A  70      62.456 -25.888   7.297  1.00  0.00           H  
ATOM   1078  HB3 ASN A  70      61.349 -26.933   6.413  1.00  0.00           H  
ATOM   1079 HD21 ASN A  70      64.485 -25.697   6.609  1.00  0.00           H  
ATOM   1080 HD22 ASN A  70      65.099 -26.353   5.133  1.00  0.00           H  
ATOM   1081  N   LEU A  71      61.643 -22.527   5.379  1.00  0.00           N  
ATOM   1082  CA  LEU A  71      62.368 -21.263   5.433  1.00  0.00           C  
ATOM   1083  C   LEU A  71      61.405 -20.081   5.385  1.00  0.00           C  
ATOM   1084  O   LEU A  71      60.572 -19.980   4.484  1.00  0.00           O  
ATOM   1085  CB  LEU A  71      63.362 -21.171   4.275  1.00  0.00           C  
ATOM   1086  CG  LEU A  71      64.549 -20.231   4.482  1.00  0.00           C  
ATOM   1087  CD1 LEU A  71      64.102 -18.779   4.400  1.00  0.00           C  
ATOM   1088  CD2 LEU A  71      65.223 -20.508   5.818  1.00  0.00           C  
ATOM   1089  H   LEU A  71      60.816 -22.581   4.855  1.00  0.00           H  
ATOM   1090  HA  LEU A  71      62.910 -21.232   6.366  1.00  0.00           H  
ATOM   1091  HB2 LEU A  71      63.753 -22.162   4.096  1.00  0.00           H  
ATOM   1092  HB3 LEU A  71      62.822 -20.837   3.401  1.00  0.00           H  
ATOM   1093  HG  LEU A  71      65.276 -20.399   3.700  1.00  0.00           H  
ATOM   1094 HD11 LEU A  71      63.229 -18.708   3.767  1.00  0.00           H  
ATOM   1095 HD12 LEU A  71      64.897 -18.180   3.985  1.00  0.00           H  
ATOM   1096 HD13 LEU A  71      63.860 -18.420   5.389  1.00  0.00           H  
ATOM   1097 HD21 LEU A  71      64.995 -21.514   6.134  1.00  0.00           H  
ATOM   1098 HD22 LEU A  71      64.860 -19.807   6.556  1.00  0.00           H  
ATOM   1099 HD23 LEU A  71      66.292 -20.396   5.713  1.00  0.00           H  
ATOM   1100  N   PHE A  72      61.525 -19.186   6.360  1.00  0.00           N  
ATOM   1101  CA  PHE A  72      60.667 -18.009   6.429  1.00  0.00           C  
ATOM   1102  C   PHE A  72      61.440 -16.801   6.949  1.00  0.00           C  
ATOM   1103  O   PHE A  72      62.126 -16.880   7.968  1.00  0.00           O  
ATOM   1104  CB  PHE A  72      59.461 -18.283   7.330  1.00  0.00           C  
ATOM   1105  CG  PHE A  72      58.609 -17.072   7.578  1.00  0.00           C  
ATOM   1106  CD1 PHE A  72      57.957 -16.441   6.530  1.00  0.00           C  
ATOM   1107  CD2 PHE A  72      58.460 -16.562   8.858  1.00  0.00           C  
ATOM   1108  CE1 PHE A  72      57.173 -15.325   6.755  1.00  0.00           C  
ATOM   1109  CE2 PHE A  72      57.677 -15.447   9.088  1.00  0.00           C  
ATOM   1110  CZ  PHE A  72      57.032 -14.828   8.035  1.00  0.00           C  
ATOM   1111  H   PHE A  72      62.208 -19.321   7.051  1.00  0.00           H  
ATOM   1112  HA  PHE A  72      60.317 -17.796   5.430  1.00  0.00           H  
ATOM   1113  HB2 PHE A  72      58.840 -19.036   6.870  1.00  0.00           H  
ATOM   1114  HB3 PHE A  72      59.810 -18.645   8.286  1.00  0.00           H  
ATOM   1115  HD1 PHE A  72      58.065 -16.830   5.528  1.00  0.00           H  
ATOM   1116  HD2 PHE A  72      58.964 -17.046   9.682  1.00  0.00           H  
ATOM   1117  HE1 PHE A  72      56.669 -14.844   5.929  1.00  0.00           H  
ATOM   1118  HE2 PHE A  72      57.569 -15.060  10.091  1.00  0.00           H  
ATOM   1119  HZ  PHE A  72      56.421 -13.956   8.213  1.00  0.00           H  
ATOM   1120  N   SER A  73      61.325 -15.683   6.240  1.00  0.00           N  
ATOM   1121  CA  SER A  73      62.016 -14.458   6.625  1.00  0.00           C  
ATOM   1122  C   SER A  73      61.212 -13.228   6.214  1.00  0.00           C  
ATOM   1123  O   SER A  73      60.247 -13.328   5.457  1.00  0.00           O  
ATOM   1124  CB  SER A  73      63.407 -14.410   5.989  1.00  0.00           C  
ATOM   1125  OG  SER A  73      64.157 -13.316   6.487  1.00  0.00           O  
ATOM   1126  H   SER A  73      60.762 -15.682   5.436  1.00  0.00           H  
ATOM   1127  HA  SER A  73      62.121 -14.461   7.700  1.00  0.00           H  
ATOM   1128  HB2 SER A  73      63.933 -15.325   6.212  1.00  0.00           H  
ATOM   1129  HB3 SER A  73      63.306 -14.304   4.918  1.00  0.00           H  
ATOM   1130  HG  SER A  73      64.898 -13.143   5.901  1.00  0.00           H  
ATOM   1131  N   PHE A  74      61.620 -12.068   6.718  1.00  0.00           N  
ATOM   1132  CA  PHE A  74      60.939 -10.817   6.404  1.00  0.00           C  
ATOM   1133  C   PHE A  74      61.905  -9.638   6.474  1.00  0.00           C  
ATOM   1134  O   PHE A  74      62.827  -9.627   7.289  1.00  0.00           O  
ATOM   1135  CB  PHE A  74      59.771 -10.591   7.368  1.00  0.00           C  
ATOM   1136  CG  PHE A  74      60.116 -10.874   8.802  1.00  0.00           C  
ATOM   1137  CD1 PHE A  74      59.982 -12.152   9.321  1.00  0.00           C  
ATOM   1138  CD2 PHE A  74      60.573  -9.863   9.631  1.00  0.00           C  
ATOM   1139  CE1 PHE A  74      60.297 -12.415  10.641  1.00  0.00           C  
ATOM   1140  CE2 PHE A  74      60.889 -10.120  10.952  1.00  0.00           C  
ATOM   1141  CZ  PHE A  74      60.753 -11.398  11.457  1.00  0.00           C  
ATOM   1142  H   PHE A  74      62.397 -12.052   7.315  1.00  0.00           H  
ATOM   1143  HA  PHE A  74      60.554 -10.893   5.399  1.00  0.00           H  
ATOM   1144  HB2 PHE A  74      59.452  -9.562   7.301  1.00  0.00           H  
ATOM   1145  HB3 PHE A  74      58.954 -11.237   7.087  1.00  0.00           H  
ATOM   1146  HD1 PHE A  74      59.627 -12.949   8.684  1.00  0.00           H  
ATOM   1147  HD2 PHE A  74      60.680  -8.862   9.237  1.00  0.00           H  
ATOM   1148  HE1 PHE A  74      60.189 -13.416  11.033  1.00  0.00           H  
ATOM   1149  HE2 PHE A  74      61.245  -9.322  11.587  1.00  0.00           H  
ATOM   1150  HZ  PHE A  74      60.999 -11.601  12.488  1.00  0.00           H  
ATOM   1151  N   GLU A  75      61.688  -8.649   5.612  1.00  0.00           N  
ATOM   1152  CA  GLU A  75      62.541  -7.467   5.576  1.00  0.00           C  
ATOM   1153  C   GLU A  75      61.897  -6.309   6.333  1.00  0.00           C  
ATOM   1154  O   GLU A  75      60.722  -6.001   6.135  1.00  0.00           O  
ATOM   1155  CB  GLU A  75      62.816  -7.055   4.128  1.00  0.00           C  
ATOM   1156  CG  GLU A  75      64.115  -6.286   3.952  1.00  0.00           C  
ATOM   1157  CD  GLU A  75      64.275  -5.171   4.967  1.00  0.00           C  
ATOM   1158  OE1 GLU A  75      63.536  -4.170   4.872  1.00  0.00           O  
ATOM   1159  OE2 GLU A  75      65.141  -5.300   5.857  1.00  0.00           O  
ATOM   1160  H   GLU A  75      60.936  -8.718   4.987  1.00  0.00           H  
ATOM   1161  HA  GLU A  75      63.476  -7.718   6.053  1.00  0.00           H  
ATOM   1162  HB2 GLU A  75      62.861  -7.944   3.516  1.00  0.00           H  
ATOM   1163  HB3 GLU A  75      62.003  -6.433   3.783  1.00  0.00           H  
ATOM   1164  HG2 GLU A  75      64.942  -6.972   4.059  1.00  0.00           H  
ATOM   1165  HG3 GLU A  75      64.132  -5.856   2.961  1.00  0.00           H  
ATOM   1166  N   SER A  76      62.676  -5.672   7.200  1.00  0.00           N  
ATOM   1167  CA  SER A  76      62.182  -4.550   7.991  1.00  0.00           C  
ATOM   1168  C   SER A  76      63.106  -3.342   7.855  1.00  0.00           C  
ATOM   1169  O   SER A  76      64.299  -3.485   7.596  1.00  0.00           O  
ATOM   1170  CB  SER A  76      62.061  -4.951   9.462  1.00  0.00           C  
ATOM   1171  OG  SER A  76      60.805  -5.555   9.723  1.00  0.00           O  
ATOM   1172  H   SER A  76      63.605  -5.965   7.313  1.00  0.00           H  
ATOM   1173  HA  SER A  76      61.205  -4.285   7.616  1.00  0.00           H  
ATOM   1174  HB2 SER A  76      62.842  -5.652   9.708  1.00  0.00           H  
ATOM   1175  HB3 SER A  76      62.158  -4.070  10.081  1.00  0.00           H  
ATOM   1176  HG  SER A  76      60.692  -6.317   9.150  1.00  0.00           H  
ATOM   1177  N   GLY A  77      62.542  -2.151   8.035  1.00  0.00           N  
ATOM   1178  CA  GLY A  77      63.327  -0.935   7.929  1.00  0.00           C  
ATOM   1179  C   GLY A  77      64.280  -0.757   9.094  1.00  0.00           C  
ATOM   1180  O   GLY A  77      64.777  -1.735   9.652  1.00  0.00           O  
ATOM   1181  H   GLY A  77      61.584  -2.099   8.240  1.00  0.00           H  
ATOM   1182  HA2 GLY A  77      63.896  -0.967   7.012  1.00  0.00           H  
ATOM   1183  HA3 GLY A  77      62.655  -0.089   7.895  1.00  0.00           H  
ATOM   1184  N   ARG A  78      64.535   0.494   9.461  1.00  0.00           N  
ATOM   1185  CA  ARG A  78      65.438   0.796  10.566  1.00  0.00           C  
ATOM   1186  C   ARG A  78      64.682   1.438  11.725  1.00  0.00           C  
ATOM   1187  O   ARG A  78      65.261   1.730  12.771  1.00  0.00           O  
ATOM   1188  CB  ARG A  78      66.558   1.727  10.096  1.00  0.00           C  
ATOM   1189  CG  ARG A  78      66.079   3.124   9.735  1.00  0.00           C  
ATOM   1190  CD  ARG A  78      65.625   3.200   8.286  1.00  0.00           C  
ATOM   1191  NE  ARG A  78      65.800   4.538   7.727  1.00  0.00           N  
ATOM   1192  CZ  ARG A  78      65.933   4.779   6.427  1.00  0.00           C  
ATOM   1193  NH1 ARG A  78      65.909   3.778   5.558  1.00  0.00           N  
ATOM   1194  NH2 ARG A  78      66.088   6.024   5.995  1.00  0.00           N  
ATOM   1195  H   ARG A  78      64.108   1.231   8.977  1.00  0.00           H  
ATOM   1196  HA  ARG A  78      65.871  -0.132  10.905  1.00  0.00           H  
ATOM   1197  HB2 ARG A  78      67.291   1.815  10.885  1.00  0.00           H  
ATOM   1198  HB3 ARG A  78      67.027   1.295   9.225  1.00  0.00           H  
ATOM   1199  HG2 ARG A  78      65.249   3.386  10.375  1.00  0.00           H  
ATOM   1200  HG3 ARG A  78      66.888   3.822   9.887  1.00  0.00           H  
ATOM   1201  HD2 ARG A  78      66.204   2.498   7.704  1.00  0.00           H  
ATOM   1202  HD3 ARG A  78      64.580   2.933   8.236  1.00  0.00           H  
ATOM   1203  HE  ARG A  78      65.820   5.291   8.352  1.00  0.00           H  
ATOM   1204 HH11 ARG A  78      65.791   2.840   5.880  1.00  0.00           H  
ATOM   1205 HH12 ARG A  78      66.008   3.963   4.580  1.00  0.00           H  
ATOM   1206 HH21 ARG A  78      66.106   6.780   6.648  1.00  0.00           H  
ATOM   1207 HH22 ARG A  78      66.188   6.205   5.017  1.00  0.00           H  
ATOM   1208  N   ARG A  79      63.385   1.656  11.531  1.00  0.00           N  
ATOM   1209  CA  ARG A  79      62.550   2.264  12.560  1.00  0.00           C  
ATOM   1210  C   ARG A  79      62.058   1.214  13.551  1.00  0.00           C  
ATOM   1211  O   ARG A  79      61.540   1.548  14.618  1.00  0.00           O  
ATOM   1212  CB  ARG A  79      61.355   2.976  11.922  1.00  0.00           C  
ATOM   1213  CG  ARG A  79      60.466   2.058  11.099  1.00  0.00           C  
ATOM   1214  CD  ARG A  79      59.517   2.849  10.213  1.00  0.00           C  
ATOM   1215  NE  ARG A  79      58.400   3.408  10.969  1.00  0.00           N  
ATOM   1216  CZ  ARG A  79      57.362   4.017  10.406  1.00  0.00           C  
ATOM   1217  NH1 ARG A  79      57.299   4.144   9.087  1.00  0.00           N  
ATOM   1218  NH2 ARG A  79      56.385   4.501  11.162  1.00  0.00           N  
ATOM   1219  H   ARG A  79      62.979   1.401  10.675  1.00  0.00           H  
ATOM   1220  HA  ARG A  79      63.149   2.989  13.089  1.00  0.00           H  
ATOM   1221  HB2 ARG A  79      60.755   3.417  12.703  1.00  0.00           H  
ATOM   1222  HB3 ARG A  79      61.723   3.759  11.275  1.00  0.00           H  
ATOM   1223  HG2 ARG A  79      61.088   1.434  10.475  1.00  0.00           H  
ATOM   1224  HG3 ARG A  79      59.888   1.438  11.769  1.00  0.00           H  
ATOM   1225  HD2 ARG A  79      60.066   3.656   9.751  1.00  0.00           H  
ATOM   1226  HD3 ARG A  79      59.129   2.192   9.448  1.00  0.00           H  
ATOM   1227  HE  ARG A  79      58.426   3.326  11.945  1.00  0.00           H  
ATOM   1228 HH11 ARG A  79      58.034   3.779   8.516  1.00  0.00           H  
ATOM   1229 HH12 ARG A  79      56.516   4.601   8.666  1.00  0.00           H  
ATOM   1230 HH21 ARG A  79      56.427   4.407  12.156  1.00  0.00           H  
ATOM   1231 HH22 ARG A  79      55.604   4.959  10.737  1.00  0.00           H  
ATOM   1232  N   CYS A  80      62.223  -0.054  13.194  1.00  0.00           N  
ATOM   1233  CA  CYS A  80      61.795  -1.153  14.052  1.00  0.00           C  
ATOM   1234  C   CYS A  80      62.777  -1.360  15.201  1.00  0.00           C  
ATOM   1235  O   CYS A  80      63.965  -1.067  15.074  1.00  0.00           O  
ATOM   1236  CB  CYS A  80      61.664  -2.442  13.239  1.00  0.00           C  
ATOM   1237  SG  CYS A  80      63.128  -2.849  12.259  1.00  0.00           S  
ATOM   1238  H   CYS A  80      62.642  -0.257  12.331  1.00  0.00           H  
ATOM   1239  HA  CYS A  80      60.830  -0.896  14.462  1.00  0.00           H  
ATOM   1240  HB2 CYS A  80      61.480  -3.266  13.912  1.00  0.00           H  
ATOM   1241  HB3 CYS A  80      60.829  -2.347  12.560  1.00  0.00           H  
ATOM   1242  HG  CYS A  80      63.082  -2.140  11.142  1.00  0.00           H  
ATOM   1243  N   GLN A  81      62.271  -1.866  16.321  1.00  0.00           N  
ATOM   1244  CA  GLN A  81      63.104  -2.109  17.493  1.00  0.00           C  
ATOM   1245  C   GLN A  81      64.484  -2.614  17.085  1.00  0.00           C  
ATOM   1246  O   GLN A  81      65.484  -1.911  17.235  1.00  0.00           O  
ATOM   1247  CB  GLN A  81      62.432  -3.122  18.421  1.00  0.00           C  
ATOM   1248  CG  GLN A  81      63.408  -3.870  19.316  1.00  0.00           C  
ATOM   1249  CD  GLN A  81      62.731  -4.501  20.517  1.00  0.00           C  
ATOM   1250  OE1 GLN A  81      62.038  -3.828  21.280  1.00  0.00           O  
ATOM   1251  NE2 GLN A  81      62.930  -5.803  20.690  1.00  0.00           N  
ATOM   1252  H   GLN A  81      61.316  -2.079  16.360  1.00  0.00           H  
ATOM   1253  HA  GLN A  81      63.218  -1.173  18.019  1.00  0.00           H  
ATOM   1254  HB2 GLN A  81      61.725  -2.602  19.051  1.00  0.00           H  
ATOM   1255  HB3 GLN A  81      61.901  -3.846  17.820  1.00  0.00           H  
ATOM   1256  HG2 GLN A  81      63.882  -4.648  18.738  1.00  0.00           H  
ATOM   1257  HG3 GLN A  81      64.157  -3.175  19.666  1.00  0.00           H  
ATOM   1258 HE21 GLN A  81      63.495  -6.275  20.043  1.00  0.00           H  
ATOM   1259 HE22 GLN A  81      62.505  -6.237  21.459  1.00  0.00           H  
ATOM   1260  N   THR A  82      64.531  -3.838  16.567  1.00  0.00           N  
ATOM   1261  CA  THR A  82      65.789  -4.438  16.138  1.00  0.00           C  
ATOM   1262  C   THR A  82      66.598  -3.468  15.284  1.00  0.00           C  
ATOM   1263  O   THR A  82      67.723  -3.112  15.630  1.00  0.00           O  
ATOM   1264  CB  THR A  82      65.549  -5.732  15.337  1.00  0.00           C  
ATOM   1265  OG1 THR A  82      64.595  -5.495  14.297  1.00  0.00           O  
ATOM   1266  CG2 THR A  82      65.049  -6.845  16.246  1.00  0.00           C  
ATOM   1267  H   THR A  82      63.701  -4.349  16.473  1.00  0.00           H  
ATOM   1268  HA  THR A  82      66.358  -4.686  17.022  1.00  0.00           H  
ATOM   1269  HB  THR A  82      66.485  -6.042  14.895  1.00  0.00           H  
ATOM   1270  HG1 THR A  82      63.718  -5.414  14.678  1.00  0.00           H  
ATOM   1271 HG21 THR A  82      64.294  -7.419  15.730  1.00  0.00           H  
ATOM   1272 HG22 THR A  82      64.625  -6.416  17.143  1.00  0.00           H  
ATOM   1273 HG23 THR A  82      65.873  -7.491  16.511  1.00  0.00           H  
ATOM   1274  N   GLY A  83      66.016  -3.044  14.166  1.00  0.00           N  
ATOM   1275  CA  GLY A  83      66.698  -2.119  13.281  1.00  0.00           C  
ATOM   1276  C   GLY A  83      66.842  -2.663  11.873  1.00  0.00           C  
ATOM   1277  O   GLY A  83      66.302  -3.721  11.552  1.00  0.00           O  
ATOM   1278  H   GLY A  83      65.116  -3.363  13.941  1.00  0.00           H  
ATOM   1279  HA2 GLY A  83      66.139  -1.195  13.243  1.00  0.00           H  
ATOM   1280  HA3 GLY A  83      67.682  -1.916  13.678  1.00  0.00           H  
ATOM   1281  N   GLN A  84      67.570  -1.937  11.031  1.00  0.00           N  
ATOM   1282  CA  GLN A  84      67.781  -2.353   9.650  1.00  0.00           C  
ATOM   1283  C   GLN A  84      68.448  -3.723   9.589  1.00  0.00           C  
ATOM   1284  O   GLN A  84      69.459  -3.963  10.247  1.00  0.00           O  
ATOM   1285  CB  GLN A  84      68.637  -1.324   8.910  1.00  0.00           C  
ATOM   1286  CG  GLN A  84      68.345  -1.246   7.420  1.00  0.00           C  
ATOM   1287  CD  GLN A  84      69.557  -0.837   6.608  1.00  0.00           C  
ATOM   1288  OE1 GLN A  84      70.694  -1.135   6.974  1.00  0.00           O  
ATOM   1289  NE2 GLN A  84      69.321  -0.149   5.496  1.00  0.00           N  
ATOM   1290  H   GLN A  84      67.976  -1.103  11.346  1.00  0.00           H  
ATOM   1291  HA  GLN A  84      66.815  -2.415   9.171  1.00  0.00           H  
ATOM   1292  HB2 GLN A  84      68.460  -0.349   9.340  1.00  0.00           H  
ATOM   1293  HB3 GLN A  84      69.679  -1.581   9.037  1.00  0.00           H  
ATOM   1294  HG2 GLN A  84      68.014  -2.217   7.080  1.00  0.00           H  
ATOM   1295  HG3 GLN A  84      67.559  -0.523   7.258  1.00  0.00           H  
ATOM   1296 HE21 GLN A  84      68.388   0.053   5.267  1.00  0.00           H  
ATOM   1297 HE22 GLN A  84      70.085   0.129   4.953  1.00  0.00           H  
ATOM   1298  N   GLY A  85      67.873  -4.622   8.794  1.00  0.00           N  
ATOM   1299  CA  GLY A  85      68.424  -5.957   8.663  1.00  0.00           C  
ATOM   1300  C   GLY A  85      67.351  -7.014   8.495  1.00  0.00           C  
ATOM   1301  O   GLY A  85      66.245  -6.873   9.017  1.00  0.00           O  
ATOM   1302  H   GLY A  85      67.068  -4.374   8.294  1.00  0.00           H  
ATOM   1303  HA2 GLY A  85      69.078  -5.982   7.804  1.00  0.00           H  
ATOM   1304  HA3 GLY A  85      69.001  -6.184   9.548  1.00  0.00           H  
ATOM   1305  N   ILE A  86      67.677  -8.075   7.764  1.00  0.00           N  
ATOM   1306  CA  ILE A  86      66.731  -9.158   7.528  1.00  0.00           C  
ATOM   1307  C   ILE A  86      66.903 -10.271   8.557  1.00  0.00           C  
ATOM   1308  O   ILE A  86      67.992 -10.470   9.095  1.00  0.00           O  
ATOM   1309  CB  ILE A  86      66.894  -9.751   6.116  1.00  0.00           C  
ATOM   1310  CG1 ILE A  86      66.415  -8.751   5.062  1.00  0.00           C  
ATOM   1311  CG2 ILE A  86      66.127 -11.059   5.999  1.00  0.00           C  
ATOM   1312  CD1 ILE A  86      67.010  -8.986   3.692  1.00  0.00           C  
ATOM   1313  H   ILE A  86      68.573  -8.130   7.374  1.00  0.00           H  
ATOM   1314  HA  ILE A  86      65.732  -8.754   7.615  1.00  0.00           H  
ATOM   1315  HB  ILE A  86      67.940  -9.958   5.956  1.00  0.00           H  
ATOM   1316 HG12 ILE A  86      65.342  -8.817   4.973  1.00  0.00           H  
ATOM   1317 HG13 ILE A  86      66.685  -7.752   5.374  1.00  0.00           H  
ATOM   1318 HG21 ILE A  86      66.535 -11.779   6.695  1.00  0.00           H  
ATOM   1319 HG22 ILE A  86      65.086 -10.889   6.228  1.00  0.00           H  
ATOM   1320 HG23 ILE A  86      66.217 -11.441   4.993  1.00  0.00           H  
ATOM   1321 HD11 ILE A  86      67.116  -8.041   3.178  1.00  0.00           H  
ATOM   1322 HD12 ILE A  86      67.980  -9.449   3.794  1.00  0.00           H  
ATOM   1323 HD13 ILE A  86      66.360  -9.634   3.123  1.00  0.00           H  
ATOM   1324  N   PHE A  87      65.821 -10.995   8.823  1.00  0.00           N  
ATOM   1325  CA  PHE A  87      65.852 -12.089   9.788  1.00  0.00           C  
ATOM   1326  C   PHE A  87      65.093 -13.302   9.258  1.00  0.00           C  
ATOM   1327  O   PHE A  87      63.893 -13.231   8.996  1.00  0.00           O  
ATOM   1328  CB  PHE A  87      65.250 -11.640  11.121  1.00  0.00           C  
ATOM   1329  CG  PHE A  87      65.535 -10.202  11.453  1.00  0.00           C  
ATOM   1330  CD1 PHE A  87      64.752  -9.188  10.926  1.00  0.00           C  
ATOM   1331  CD2 PHE A  87      66.585  -9.867  12.291  1.00  0.00           C  
ATOM   1332  CE1 PHE A  87      65.012  -7.865  11.231  1.00  0.00           C  
ATOM   1333  CE2 PHE A  87      66.851  -8.545  12.599  1.00  0.00           C  
ATOM   1334  CZ  PHE A  87      66.062  -7.543  12.068  1.00  0.00           C  
ATOM   1335  H   PHE A  87      64.981 -10.788   8.363  1.00  0.00           H  
ATOM   1336  HA  PHE A  87      66.883 -12.364   9.943  1.00  0.00           H  
ATOM   1337  HB2 PHE A  87      64.178 -11.766  11.085  1.00  0.00           H  
ATOM   1338  HB3 PHE A  87      65.654 -12.252  11.913  1.00  0.00           H  
ATOM   1339  HD1 PHE A  87      63.929  -9.438  10.272  1.00  0.00           H  
ATOM   1340  HD2 PHE A  87      67.203 -10.651  12.707  1.00  0.00           H  
ATOM   1341  HE1 PHE A  87      64.393  -7.084  10.815  1.00  0.00           H  
ATOM   1342  HE2 PHE A  87      67.672  -8.298  13.255  1.00  0.00           H  
ATOM   1343  HZ  PHE A  87      66.267  -6.511  12.307  1.00  0.00           H  
ATOM   1344  N   ALA A  88      65.803 -14.415   9.102  1.00  0.00           N  
ATOM   1345  CA  ALA A  88      65.197 -15.644   8.605  1.00  0.00           C  
ATOM   1346  C   ALA A  88      65.100 -16.693   9.707  1.00  0.00           C  
ATOM   1347  O   ALA A  88      65.857 -16.661  10.677  1.00  0.00           O  
ATOM   1348  CB  ALA A  88      65.994 -16.185   7.426  1.00  0.00           C  
ATOM   1349  H   ALA A  88      66.756 -14.409   9.328  1.00  0.00           H  
ATOM   1350  HA  ALA A  88      64.201 -15.409   8.256  1.00  0.00           H  
ATOM   1351  HB1 ALA A  88      67.011 -16.373   7.736  1.00  0.00           H  
ATOM   1352  HB2 ALA A  88      65.545 -17.106   7.083  1.00  0.00           H  
ATOM   1353  HB3 ALA A  88      65.988 -15.462   6.625  1.00  0.00           H  
ATOM   1354  N   PHE A  89      64.163 -17.623   9.551  1.00  0.00           N  
ATOM   1355  CA  PHE A  89      63.966 -18.681  10.535  1.00  0.00           C  
ATOM   1356  C   PHE A  89      63.520 -19.976   9.860  1.00  0.00           C  
ATOM   1357  O   PHE A  89      62.856 -19.952   8.824  1.00  0.00           O  
ATOM   1358  CB  PHE A  89      62.929 -18.253  11.576  1.00  0.00           C  
ATOM   1359  CG  PHE A  89      63.142 -16.860  12.095  1.00  0.00           C  
ATOM   1360  CD1 PHE A  89      63.051 -15.768  11.247  1.00  0.00           C  
ATOM   1361  CD2 PHE A  89      63.433 -16.642  13.432  1.00  0.00           C  
ATOM   1362  CE1 PHE A  89      63.248 -14.485  11.723  1.00  0.00           C  
ATOM   1363  CE2 PHE A  89      63.630 -15.361  13.914  1.00  0.00           C  
ATOM   1364  CZ  PHE A  89      63.536 -14.282  13.059  1.00  0.00           C  
ATOM   1365  H   PHE A  89      63.591 -17.596   8.756  1.00  0.00           H  
ATOM   1366  HA  PHE A  89      64.909 -18.853  11.030  1.00  0.00           H  
ATOM   1367  HB2 PHE A  89      61.946 -18.294  11.132  1.00  0.00           H  
ATOM   1368  HB3 PHE A  89      62.970 -18.931  12.414  1.00  0.00           H  
ATOM   1369  HD1 PHE A  89      62.825 -15.925  10.203  1.00  0.00           H  
ATOM   1370  HD2 PHE A  89      63.506 -17.486  14.104  1.00  0.00           H  
ATOM   1371  HE1 PHE A  89      63.173 -13.642  11.052  1.00  0.00           H  
ATOM   1372  HE2 PHE A  89      63.855 -15.206  14.959  1.00  0.00           H  
ATOM   1373  HZ  PHE A  89      63.690 -13.281  13.433  1.00  0.00           H  
ATOM   1374  N   LYS A  90      63.893 -21.104  10.454  1.00  0.00           N  
ATOM   1375  CA  LYS A  90      63.532 -22.409   9.913  1.00  0.00           C  
ATOM   1376  C   LYS A  90      62.317 -22.981  10.636  1.00  0.00           C  
ATOM   1377  O   LYS A  90      62.307 -23.089  11.863  1.00  0.00           O  
ATOM   1378  CB  LYS A  90      64.713 -23.376  10.031  1.00  0.00           C  
ATOM   1379  CG  LYS A  90      65.644 -23.348   8.832  1.00  0.00           C  
ATOM   1380  CD  LYS A  90      66.681 -24.456   8.906  1.00  0.00           C  
ATOM   1381  CE  LYS A  90      67.594 -24.448   7.688  1.00  0.00           C  
ATOM   1382  NZ  LYS A  90      68.167 -25.795   7.416  1.00  0.00           N  
ATOM   1383  H   LYS A  90      64.422 -21.058  11.278  1.00  0.00           H  
ATOM   1384  HA  LYS A  90      63.287 -22.279   8.870  1.00  0.00           H  
ATOM   1385  HB2 LYS A  90      65.284 -23.122  10.911  1.00  0.00           H  
ATOM   1386  HB3 LYS A  90      64.329 -24.381  10.138  1.00  0.00           H  
ATOM   1387  HG2 LYS A  90      65.062 -23.473   7.931  1.00  0.00           H  
ATOM   1388  HG3 LYS A  90      66.153 -22.394   8.805  1.00  0.00           H  
ATOM   1389  HD2 LYS A  90      67.281 -24.318   9.792  1.00  0.00           H  
ATOM   1390  HD3 LYS A  90      66.173 -25.409   8.957  1.00  0.00           H  
ATOM   1391  HE2 LYS A  90      67.023 -24.130   6.829  1.00  0.00           H  
ATOM   1392  HE3 LYS A  90      68.399 -23.752   7.864  1.00  0.00           H  
ATOM   1393  HZ1 LYS A  90      69.189 -25.720   7.242  1.00  0.00           H  
ATOM   1394  HZ2 LYS A  90      67.714 -26.214   6.579  1.00  0.00           H  
ATOM   1395  HZ3 LYS A  90      68.009 -26.422   8.231  1.00  0.00           H  
ATOM   1396  N   CYS A  91      61.297 -23.348   9.869  1.00  0.00           N  
ATOM   1397  CA  CYS A  91      60.077 -23.910  10.437  1.00  0.00           C  
ATOM   1398  C   CYS A  91      59.589 -25.096   9.610  1.00  0.00           C  
ATOM   1399  O   CYS A  91      60.199 -25.457   8.604  1.00  0.00           O  
ATOM   1400  CB  CYS A  91      58.985 -22.843  10.513  1.00  0.00           C  
ATOM   1401  SG  CYS A  91      57.807 -23.086  11.863  1.00  0.00           S  
ATOM   1402  H   CYS A  91      61.364 -23.238   8.897  1.00  0.00           H  
ATOM   1403  HA  CYS A  91      60.304 -24.253  11.435  1.00  0.00           H  
ATOM   1404  HB2 CYS A  91      59.448 -21.875  10.652  1.00  0.00           H  
ATOM   1405  HB3 CYS A  91      58.431 -22.839   9.587  1.00  0.00           H  
ATOM   1406  HG  CYS A  91      57.330 -21.899  12.208  1.00  0.00           H  
ATOM   1407  N   SER A  92      58.485 -25.697  10.043  1.00  0.00           N  
ATOM   1408  CA  SER A  92      57.917 -26.846   9.346  1.00  0.00           C  
ATOM   1409  C   SER A  92      56.672 -26.444   8.561  1.00  0.00           C  
ATOM   1410  O   SER A  92      56.305 -27.094   7.583  1.00  0.00           O  
ATOM   1411  CB  SER A  92      57.571 -27.953  10.343  1.00  0.00           C  
ATOM   1412  OG  SER A  92      57.413 -29.199   9.686  1.00  0.00           O  
ATOM   1413  H   SER A  92      58.044 -25.363  10.851  1.00  0.00           H  
ATOM   1414  HA  SER A  92      58.661 -27.215   8.655  1.00  0.00           H  
ATOM   1415  HB2 SER A  92      58.364 -28.042  11.069  1.00  0.00           H  
ATOM   1416  HB3 SER A  92      56.647 -27.705  10.846  1.00  0.00           H  
ATOM   1417  HG  SER A  92      57.158 -29.050   8.772  1.00  0.00           H  
ATOM   1418  N   ARG A  93      56.027 -25.368   8.998  1.00  0.00           N  
ATOM   1419  CA  ARG A  93      54.822 -24.879   8.339  1.00  0.00           C  
ATOM   1420  C   ARG A  93      54.995 -23.429   7.897  1.00  0.00           C  
ATOM   1421  O   ARG A  93      54.143 -22.582   8.167  1.00  0.00           O  
ATOM   1422  CB  ARG A  93      53.618 -24.998   9.275  1.00  0.00           C  
ATOM   1423  CG  ARG A  93      53.510 -26.351   9.958  1.00  0.00           C  
ATOM   1424  CD  ARG A  93      52.681 -26.268  11.231  1.00  0.00           C  
ATOM   1425  NE  ARG A  93      51.290 -25.919  10.957  1.00  0.00           N  
ATOM   1426  CZ  ARG A  93      50.403 -26.772  10.456  1.00  0.00           C  
ATOM   1427  NH1 ARG A  93      50.760 -28.018  10.177  1.00  0.00           N  
ATOM   1428  NH2 ARG A  93      49.156 -26.378  10.234  1.00  0.00           N  
ATOM   1429  H   ARG A  93      56.368 -24.891   9.784  1.00  0.00           H  
ATOM   1430  HA  ARG A  93      54.650 -25.491   7.467  1.00  0.00           H  
ATOM   1431  HB2 ARG A  93      53.695 -24.239  10.040  1.00  0.00           H  
ATOM   1432  HB3 ARG A  93      52.716 -24.834   8.705  1.00  0.00           H  
ATOM   1433  HG2 ARG A  93      53.040 -27.050   9.282  1.00  0.00           H  
ATOM   1434  HG3 ARG A  93      54.501 -26.699  10.207  1.00  0.00           H  
ATOM   1435  HD2 ARG A  93      52.710 -27.227  11.727  1.00  0.00           H  
ATOM   1436  HD3 ARG A  93      53.111 -25.516  11.876  1.00  0.00           H  
ATOM   1437  HE  ARG A  93      51.005 -25.003  11.155  1.00  0.00           H  
ATOM   1438 HH11 ARG A  93      51.700 -28.317  10.345  1.00  0.00           H  
ATOM   1439 HH12 ARG A  93      50.091 -28.658   9.802  1.00  0.00           H  
ATOM   1440 HH21 ARG A  93      48.882 -25.440  10.443  1.00  0.00           H  
ATOM   1441 HH22 ARG A  93      48.488 -27.021   9.858  1.00  0.00           H  
ATOM   1442  N   ALA A  94      56.102 -23.151   7.217  1.00  0.00           N  
ATOM   1443  CA  ALA A  94      56.386 -21.804   6.737  1.00  0.00           C  
ATOM   1444  C   ALA A  94      55.250 -21.282   5.864  1.00  0.00           C  
ATOM   1445  O   ALA A  94      54.794 -20.152   6.033  1.00  0.00           O  
ATOM   1446  CB  ALA A  94      57.698 -21.783   5.967  1.00  0.00           C  
ATOM   1447  H   ALA A  94      56.743 -23.869   7.033  1.00  0.00           H  
ATOM   1448  HA  ALA A  94      56.491 -21.158   7.597  1.00  0.00           H  
ATOM   1449  HB1 ALA A  94      58.420 -21.187   6.504  1.00  0.00           H  
ATOM   1450  HB2 ALA A  94      58.069 -22.792   5.864  1.00  0.00           H  
ATOM   1451  HB3 ALA A  94      57.534 -21.358   4.988  1.00  0.00           H  
ATOM   1452  N   GLU A  95      54.798 -22.113   4.929  1.00  0.00           N  
ATOM   1453  CA  GLU A  95      53.716 -21.734   4.029  1.00  0.00           C  
ATOM   1454  C   GLU A  95      52.498 -21.255   4.813  1.00  0.00           C  
ATOM   1455  O   GLU A  95      51.929 -20.205   4.515  1.00  0.00           O  
ATOM   1456  CB  GLU A  95      53.330 -22.912   3.134  1.00  0.00           C  
ATOM   1457  CG  GLU A  95      52.494 -22.514   1.929  1.00  0.00           C  
ATOM   1458  CD  GLU A  95      52.646 -23.480   0.769  1.00  0.00           C  
ATOM   1459  OE1 GLU A  95      53.655 -24.213   0.735  1.00  0.00           O  
ATOM   1460  OE2 GLU A  95      51.753 -23.502  -0.104  1.00  0.00           O  
ATOM   1461  H   GLU A  95      55.203 -23.001   4.843  1.00  0.00           H  
ATOM   1462  HA  GLU A  95      54.070 -20.924   3.408  1.00  0.00           H  
ATOM   1463  HB2 GLU A  95      54.230 -23.391   2.780  1.00  0.00           H  
ATOM   1464  HB3 GLU A  95      52.763 -23.622   3.719  1.00  0.00           H  
ATOM   1465  HG2 GLU A  95      51.455 -22.487   2.221  1.00  0.00           H  
ATOM   1466  HG3 GLU A  95      52.802 -21.532   1.603  1.00  0.00           H  
ATOM   1467  N   GLU A  96      52.104 -22.034   5.816  1.00  0.00           N  
ATOM   1468  CA  GLU A  96      50.952 -21.690   6.643  1.00  0.00           C  
ATOM   1469  C   GLU A  96      51.038 -20.244   7.121  1.00  0.00           C  
ATOM   1470  O   GLU A  96      50.073 -19.487   7.020  1.00  0.00           O  
ATOM   1471  CB  GLU A  96      50.861 -22.631   7.845  1.00  0.00           C  
ATOM   1472  CG  GLU A  96      50.332 -24.013   7.496  1.00  0.00           C  
ATOM   1473  CD  GLU A  96      48.827 -24.033   7.316  1.00  0.00           C  
ATOM   1474  OE1 GLU A  96      48.281 -23.055   6.766  1.00  0.00           O  
ATOM   1475  OE2 GLU A  96      48.194 -25.029   7.726  1.00  0.00           O  
ATOM   1476  H   GLU A  96      52.599 -22.858   6.005  1.00  0.00           H  
ATOM   1477  HA  GLU A  96      50.065 -21.805   6.039  1.00  0.00           H  
ATOM   1478  HB2 GLU A  96      51.845 -22.743   8.276  1.00  0.00           H  
ATOM   1479  HB3 GLU A  96      50.203 -22.193   8.580  1.00  0.00           H  
ATOM   1480  HG2 GLU A  96      50.793 -24.340   6.577  1.00  0.00           H  
ATOM   1481  HG3 GLU A  96      50.594 -24.696   8.292  1.00  0.00           H  
ATOM   1482  N   ILE A  97      52.202 -19.867   7.642  1.00  0.00           N  
ATOM   1483  CA  ILE A  97      52.414 -18.512   8.136  1.00  0.00           C  
ATOM   1484  C   ILE A  97      52.385 -17.500   6.995  1.00  0.00           C  
ATOM   1485  O   ILE A  97      51.967 -16.357   7.176  1.00  0.00           O  
ATOM   1486  CB  ILE A  97      53.756 -18.389   8.882  1.00  0.00           C  
ATOM   1487  CG1 ILE A  97      53.842 -19.434   9.995  1.00  0.00           C  
ATOM   1488  CG2 ILE A  97      53.919 -16.987   9.451  1.00  0.00           C  
ATOM   1489  CD1 ILE A  97      55.252 -19.913  10.267  1.00  0.00           C  
ATOM   1490  H   ILE A  97      52.934 -20.515   7.695  1.00  0.00           H  
ATOM   1491  HA  ILE A  97      51.617 -18.282   8.828  1.00  0.00           H  
ATOM   1492  HB  ILE A  97      54.553 -18.560   8.175  1.00  0.00           H  
ATOM   1493 HG12 ILE A  97      53.454 -19.012  10.909  1.00  0.00           H  
ATOM   1494 HG13 ILE A  97      53.247 -20.294   9.720  1.00  0.00           H  
ATOM   1495 HG21 ILE A  97      54.860 -16.573   9.123  1.00  0.00           H  
ATOM   1496 HG22 ILE A  97      53.111 -16.362   9.102  1.00  0.00           H  
ATOM   1497 HG23 ILE A  97      53.901 -17.032  10.529  1.00  0.00           H  
ATOM   1498 HD11 ILE A  97      55.387 -20.048  11.331  1.00  0.00           H  
ATOM   1499 HD12 ILE A  97      55.417 -20.853   9.761  1.00  0.00           H  
ATOM   1500 HD13 ILE A  97      55.956 -19.180   9.906  1.00  0.00           H  
ATOM   1501  N   PHE A  98      52.831 -17.930   5.819  1.00  0.00           N  
ATOM   1502  CA  PHE A  98      52.855 -17.062   4.647  1.00  0.00           C  
ATOM   1503  C   PHE A  98      51.445 -16.831   4.112  1.00  0.00           C  
ATOM   1504  O   PHE A  98      51.111 -15.734   3.667  1.00  0.00           O  
ATOM   1505  CB  PHE A  98      53.735 -17.672   3.553  1.00  0.00           C  
ATOM   1506  CG  PHE A  98      53.192 -17.472   2.168  1.00  0.00           C  
ATOM   1507  CD1 PHE A  98      53.024 -16.197   1.652  1.00  0.00           C  
ATOM   1508  CD2 PHE A  98      52.850 -18.559   1.380  1.00  0.00           C  
ATOM   1509  CE1 PHE A  98      52.524 -16.010   0.377  1.00  0.00           C  
ATOM   1510  CE2 PHE A  98      52.349 -18.380   0.104  1.00  0.00           C  
ATOM   1511  CZ  PHE A  98      52.188 -17.103  -0.398  1.00  0.00           C  
ATOM   1512  H   PHE A  98      53.151 -18.853   5.738  1.00  0.00           H  
ATOM   1513  HA  PHE A  98      53.274 -16.114   4.947  1.00  0.00           H  
ATOM   1514  HB2 PHE A  98      54.714 -17.218   3.594  1.00  0.00           H  
ATOM   1515  HB3 PHE A  98      53.827 -18.733   3.726  1.00  0.00           H  
ATOM   1516  HD1 PHE A  98      53.288 -15.342   2.256  1.00  0.00           H  
ATOM   1517  HD2 PHE A  98      52.976 -19.559   1.773  1.00  0.00           H  
ATOM   1518  HE1 PHE A  98      52.399 -15.012  -0.014  1.00  0.00           H  
ATOM   1519  HE2 PHE A  98      52.087 -19.236  -0.498  1.00  0.00           H  
ATOM   1520  HZ  PHE A  98      51.796 -16.961  -1.394  1.00  0.00           H  
ATOM   1521  N   ASN A  99      50.623 -17.873   4.159  1.00  0.00           N  
ATOM   1522  CA  ASN A  99      49.248 -17.786   3.678  1.00  0.00           C  
ATOM   1523  C   ASN A  99      48.376 -17.015   4.664  1.00  0.00           C  
ATOM   1524  O   ASN A  99      47.313 -16.507   4.304  1.00  0.00           O  
ATOM   1525  CB  ASN A  99      48.673 -19.186   3.457  1.00  0.00           C  
ATOM   1526  CG  ASN A  99      49.000 -19.735   2.082  1.00  0.00           C  
ATOM   1527  OD1 ASN A  99      49.328 -18.983   1.164  1.00  0.00           O  
ATOM   1528  ND2 ASN A  99      48.910 -21.051   1.934  1.00  0.00           N  
ATOM   1529  H   ASN A  99      50.946 -18.723   4.526  1.00  0.00           H  
ATOM   1530  HA  ASN A  99      49.260 -17.258   2.737  1.00  0.00           H  
ATOM   1531  HB2 ASN A  99      49.082 -19.857   4.198  1.00  0.00           H  
ATOM   1532  HB3 ASN A  99      47.600 -19.148   3.565  1.00  0.00           H  
ATOM   1533 HD21 ASN A  99      48.643 -21.587   2.709  1.00  0.00           H  
ATOM   1534 HD22 ASN A  99      49.117 -21.432   1.055  1.00  0.00           H  
ATOM   1535  N   LEU A 100      48.831 -16.930   5.909  1.00  0.00           N  
ATOM   1536  CA  LEU A 100      48.093 -16.221   6.947  1.00  0.00           C  
ATOM   1537  C   LEU A 100      48.552 -14.770   7.049  1.00  0.00           C  
ATOM   1538  O   LEU A 100      47.754 -13.870   7.311  1.00  0.00           O  
ATOM   1539  CB  LEU A 100      48.272 -16.920   8.297  1.00  0.00           C  
ATOM   1540  CG  LEU A 100      47.469 -16.343   9.464  1.00  0.00           C  
ATOM   1541  CD1 LEU A 100      45.989 -16.291   9.118  1.00  0.00           C  
ATOM   1542  CD2 LEU A 100      47.695 -17.164  10.725  1.00  0.00           C  
ATOM   1543  H   LEU A 100      49.684 -17.356   6.137  1.00  0.00           H  
ATOM   1544  HA  LEU A 100      47.047 -16.237   6.680  1.00  0.00           H  
ATOM   1545  HB2 LEU A 100      47.983 -17.951   8.175  1.00  0.00           H  
ATOM   1546  HB3 LEU A 100      49.319 -16.869   8.558  1.00  0.00           H  
ATOM   1547  HG  LEU A 100      47.803 -15.333   9.657  1.00  0.00           H  
ATOM   1548 HD11 LEU A 100      45.806 -15.466   8.445  1.00  0.00           H  
ATOM   1549 HD12 LEU A 100      45.413 -16.153  10.022  1.00  0.00           H  
ATOM   1550 HD13 LEU A 100      45.698 -17.216   8.643  1.00  0.00           H  
ATOM   1551 HD21 LEU A 100      48.508 -16.736  11.292  1.00  0.00           H  
ATOM   1552 HD22 LEU A 100      47.943 -18.179  10.452  1.00  0.00           H  
ATOM   1553 HD23 LEU A 100      46.796 -17.161  11.322  1.00  0.00           H  
ATOM   1554  N   LEU A 101      49.845 -14.549   6.837  1.00  0.00           N  
ATOM   1555  CA  LEU A 101      50.413 -13.207   6.901  1.00  0.00           C  
ATOM   1556  C   LEU A 101      49.641 -12.245   6.003  1.00  0.00           C  
ATOM   1557  O   LEU A 101      49.184 -11.195   6.450  1.00  0.00           O  
ATOM   1558  CB  LEU A 101      51.886 -13.234   6.490  1.00  0.00           C  
ATOM   1559  CG  LEU A 101      52.893 -13.463   7.618  1.00  0.00           C  
ATOM   1560  CD1 LEU A 101      54.287 -13.683   7.052  1.00  0.00           C  
ATOM   1561  CD2 LEU A 101      52.887 -12.288   8.585  1.00  0.00           C  
ATOM   1562  H   LEU A 101      50.433 -15.305   6.631  1.00  0.00           H  
ATOM   1563  HA  LEU A 101      50.338 -12.864   7.922  1.00  0.00           H  
ATOM   1564  HB2 LEU A 101      52.014 -14.026   5.768  1.00  0.00           H  
ATOM   1565  HB3 LEU A 101      52.118 -12.286   6.027  1.00  0.00           H  
ATOM   1566  HG  LEU A 101      52.613 -14.351   8.168  1.00  0.00           H  
ATOM   1567 HD11 LEU A 101      54.686 -14.613   7.428  1.00  0.00           H  
ATOM   1568 HD12 LEU A 101      54.930 -12.869   7.352  1.00  0.00           H  
ATOM   1569 HD13 LEU A 101      54.236 -13.723   5.974  1.00  0.00           H  
ATOM   1570 HD21 LEU A 101      53.676 -11.600   8.319  1.00  0.00           H  
ATOM   1571 HD22 LEU A 101      53.047 -12.649   9.590  1.00  0.00           H  
ATOM   1572 HD23 LEU A 101      51.934 -11.783   8.531  1.00  0.00           H  
ATOM   1573  N   GLN A 102      49.498 -12.615   4.734  1.00  0.00           N  
ATOM   1574  CA  GLN A 102      48.779 -11.786   3.773  1.00  0.00           C  
ATOM   1575  C   GLN A 102      47.312 -11.647   4.165  1.00  0.00           C  
ATOM   1576  O   GLN A 102      46.590 -10.812   3.621  1.00  0.00           O  
ATOM   1577  CB  GLN A 102      48.890 -12.383   2.369  1.00  0.00           C  
ATOM   1578  CG  GLN A 102      48.290 -13.774   2.250  1.00  0.00           C  
ATOM   1579  CD  GLN A 102      48.508 -14.387   0.880  1.00  0.00           C  
ATOM   1580  OE1 GLN A 102      47.594 -14.435   0.056  1.00  0.00           O  
ATOM   1581  NE2 GLN A 102      49.722 -14.862   0.630  1.00  0.00           N  
ATOM   1582  H   GLN A 102      49.884 -13.465   4.437  1.00  0.00           H  
ATOM   1583  HA  GLN A 102      49.233 -10.807   3.775  1.00  0.00           H  
ATOM   1584  HB2 GLN A 102      48.381 -11.733   1.674  1.00  0.00           H  
ATOM   1585  HB3 GLN A 102      49.934 -12.440   2.097  1.00  0.00           H  
ATOM   1586  HG2 GLN A 102      48.747 -14.414   2.990  1.00  0.00           H  
ATOM   1587  HG3 GLN A 102      47.228 -13.711   2.435  1.00  0.00           H  
ATOM   1588 HE21 GLN A 102      50.401 -14.791   1.335  1.00  0.00           H  
ATOM   1589 HE22 GLN A 102      49.891 -15.265  -0.246  1.00  0.00           H  
ATOM   1590  N   ASP A 103      46.876 -12.472   5.111  1.00  0.00           N  
ATOM   1591  CA  ASP A 103      45.494 -12.440   5.576  1.00  0.00           C  
ATOM   1592  C   ASP A 103      45.298 -11.347   6.621  1.00  0.00           C  
ATOM   1593  O   ASP A 103      44.254 -10.693   6.663  1.00  0.00           O  
ATOM   1594  CB  ASP A 103      45.100 -13.799   6.159  1.00  0.00           C  
ATOM   1595  CG  ASP A 103      43.621 -14.091   5.994  1.00  0.00           C  
ATOM   1596  OD1 ASP A 103      43.129 -14.029   4.849  1.00  0.00           O  
ATOM   1597  OD2 ASP A 103      42.956 -14.380   7.012  1.00  0.00           O  
ATOM   1598  H   ASP A 103      47.499 -13.117   5.507  1.00  0.00           H  
ATOM   1599  HA  ASP A 103      44.864 -12.227   4.726  1.00  0.00           H  
ATOM   1600  HB2 ASP A 103      45.658 -14.575   5.658  1.00  0.00           H  
ATOM   1601  HB3 ASP A 103      45.336 -13.812   7.213  1.00  0.00           H  
ATOM   1602  N   LEU A 104      46.305 -11.154   7.465  1.00  0.00           N  
ATOM   1603  CA  LEU A 104      46.243 -10.140   8.512  1.00  0.00           C  
ATOM   1604  C   LEU A 104      46.684  -8.781   7.981  1.00  0.00           C  
ATOM   1605  O   LEU A 104      46.221  -7.741   8.448  1.00  0.00           O  
ATOM   1606  CB  LEU A 104      47.121 -10.547   9.696  1.00  0.00           C  
ATOM   1607  CG  LEU A 104      47.005 -12.003  10.150  1.00  0.00           C  
ATOM   1608  CD1 LEU A 104      48.017 -12.305  11.243  1.00  0.00           C  
ATOM   1609  CD2 LEU A 104      45.592 -12.300  10.632  1.00  0.00           C  
ATOM   1610  H   LEU A 104      47.111 -11.706   7.383  1.00  0.00           H  
ATOM   1611  HA  LEU A 104      45.218 -10.068   8.843  1.00  0.00           H  
ATOM   1612  HB2 LEU A 104      48.149 -10.368   9.422  1.00  0.00           H  
ATOM   1613  HB3 LEU A 104      46.858  -9.916  10.534  1.00  0.00           H  
ATOM   1614  HG  LEU A 104      47.216 -12.652   9.312  1.00  0.00           H  
ATOM   1615 HD11 LEU A 104      48.986 -12.476  10.799  1.00  0.00           H  
ATOM   1616 HD12 LEU A 104      47.709 -13.186  11.787  1.00  0.00           H  
ATOM   1617 HD13 LEU A 104      48.074 -11.466  11.922  1.00  0.00           H  
ATOM   1618 HD21 LEU A 104      45.636 -12.856  11.556  1.00  0.00           H  
ATOM   1619 HD22 LEU A 104      45.072 -12.882   9.886  1.00  0.00           H  
ATOM   1620 HD23 LEU A 104      45.065 -11.371  10.795  1.00  0.00           H  
ATOM   1621  N   MET A 105      47.582  -8.798   7.000  1.00  0.00           N  
ATOM   1622  CA  MET A 105      48.082  -7.565   6.402  1.00  0.00           C  
ATOM   1623  C   MET A 105      46.984  -6.855   5.617  1.00  0.00           C  
ATOM   1624  O   MET A 105      46.781  -5.651   5.767  1.00  0.00           O  
ATOM   1625  CB  MET A 105      49.269  -7.864   5.485  1.00  0.00           C  
ATOM   1626  CG  MET A 105      50.462  -8.468   6.210  1.00  0.00           C  
ATOM   1627  SD  MET A 105      51.645  -9.232   5.084  1.00  0.00           S  
ATOM   1628  CE  MET A 105      52.901  -7.958   4.998  1.00  0.00           C  
ATOM   1629  H   MET A 105      47.913  -9.658   6.669  1.00  0.00           H  
ATOM   1630  HA  MET A 105      48.411  -6.919   7.202  1.00  0.00           H  
ATOM   1631  HB2 MET A 105      48.951  -8.558   4.720  1.00  0.00           H  
ATOM   1632  HB3 MET A 105      49.589  -6.945   5.016  1.00  0.00           H  
ATOM   1633  HG2 MET A 105      50.964  -7.687   6.762  1.00  0.00           H  
ATOM   1634  HG3 MET A 105      50.103  -9.219   6.898  1.00  0.00           H  
ATOM   1635  HE1 MET A 105      52.864  -7.481   4.029  1.00  0.00           H  
ATOM   1636  HE2 MET A 105      52.721  -7.222   5.767  1.00  0.00           H  
ATOM   1637  HE3 MET A 105      53.874  -8.402   5.143  1.00  0.00           H  
ATOM   1638  N   GLN A 106      46.278  -7.610   4.781  1.00  0.00           N  
ATOM   1639  CA  GLN A 106      45.201  -7.052   3.972  1.00  0.00           C  
ATOM   1640  C   GLN A 106      44.115  -6.447   4.855  1.00  0.00           C  
ATOM   1641  O   GLN A 106      43.562  -5.392   4.541  1.00  0.00           O  
ATOM   1642  CB  GLN A 106      44.600  -8.131   3.070  1.00  0.00           C  
ATOM   1643  CG  GLN A 106      43.640  -9.063   3.794  1.00  0.00           C  
ATOM   1644  CD  GLN A 106      42.248  -8.477   3.926  1.00  0.00           C  
ATOM   1645  OE1 GLN A 106      41.994  -7.348   3.505  1.00  0.00           O  
ATOM   1646  NE2 GLN A 106      41.336  -9.244   4.512  1.00  0.00           N  
ATOM   1647  H   GLN A 106      46.488  -8.565   4.706  1.00  0.00           H  
ATOM   1648  HA  GLN A 106      45.621  -6.273   3.354  1.00  0.00           H  
ATOM   1649  HB2 GLN A 106      44.064  -7.653   2.264  1.00  0.00           H  
ATOM   1650  HB3 GLN A 106      45.401  -8.726   2.658  1.00  0.00           H  
ATOM   1651  HG2 GLN A 106      43.573  -9.989   3.242  1.00  0.00           H  
ATOM   1652  HG3 GLN A 106      44.027  -9.260   4.782  1.00  0.00           H  
ATOM   1653 HE21 GLN A 106      41.610 -10.132   4.824  1.00  0.00           H  
ATOM   1654 HE22 GLN A 106      40.428  -8.891   4.611  1.00  0.00           H  
ATOM   1655  N   CYS A 107      43.814  -7.120   5.959  1.00  0.00           N  
ATOM   1656  CA  CYS A 107      42.793  -6.650   6.888  1.00  0.00           C  
ATOM   1657  C   CYS A 107      43.141  -5.265   7.424  1.00  0.00           C  
ATOM   1658  O   CYS A 107      42.268  -4.525   7.874  1.00  0.00           O  
ATOM   1659  CB  CYS A 107      42.635  -7.633   8.048  1.00  0.00           C  
ATOM   1660  SG  CYS A 107      41.064  -7.489   8.930  1.00  0.00           S  
ATOM   1661  H   CYS A 107      44.289  -7.955   6.155  1.00  0.00           H  
ATOM   1662  HA  CYS A 107      41.859  -6.589   6.349  1.00  0.00           H  
ATOM   1663  HB2 CYS A 107      42.706  -8.642   7.667  1.00  0.00           H  
ATOM   1664  HB3 CYS A 107      43.430  -7.469   8.759  1.00  0.00           H  
ATOM   1665  HG  CYS A 107      40.469  -6.378   8.527  1.00  0.00           H  
ATOM   1666  N   ASN A 108      44.425  -4.922   7.372  1.00  0.00           N  
ATOM   1667  CA  ASN A 108      44.890  -3.627   7.855  1.00  0.00           C  
ATOM   1668  C   ASN A 108      44.124  -3.206   9.105  1.00  0.00           C  
ATOM   1669  O   ASN A 108      43.614  -2.088   9.186  1.00  0.00           O  
ATOM   1670  CB  ASN A 108      44.730  -2.566   6.764  1.00  0.00           C  
ATOM   1671  CG  ASN A 108      45.949  -2.471   5.867  1.00  0.00           C  
ATOM   1672  OD1 ASN A 108      45.944  -2.968   4.740  1.00  0.00           O  
ATOM   1673  ND2 ASN A 108      47.000  -1.830   6.362  1.00  0.00           N  
ATOM   1674  H   ASN A 108      45.074  -5.555   7.002  1.00  0.00           H  
ATOM   1675  HA  ASN A 108      45.936  -3.721   8.102  1.00  0.00           H  
ATOM   1676  HB2 ASN A 108      43.874  -2.814   6.152  1.00  0.00           H  
ATOM   1677  HB3 ASN A 108      44.569  -1.603   7.226  1.00  0.00           H  
ATOM   1678 HD21 ASN A 108      46.932  -1.459   7.268  1.00  0.00           H  
ATOM   1679 HD22 ASN A 108      47.801  -1.752   5.804  1.00  0.00           H  
ATOM   1680  N   SER A 109      44.051  -4.107  10.080  1.00  0.00           N  
ATOM   1681  CA  SER A 109      43.346  -3.830  11.326  1.00  0.00           C  
ATOM   1682  C   SER A 109      43.532  -2.375  11.743  1.00  0.00           C  
ATOM   1683  O   SER A 109      44.633  -1.955  12.097  1.00  0.00           O  
ATOM   1684  CB  SER A 109      43.845  -4.758  12.435  1.00  0.00           C  
ATOM   1685  OG  SER A 109      43.563  -6.113  12.132  1.00  0.00           O  
ATOM   1686  H   SER A 109      44.479  -4.981   9.955  1.00  0.00           H  
ATOM   1687  HA  SER A 109      42.295  -4.015  11.160  1.00  0.00           H  
ATOM   1688  HB2 SER A 109      44.912  -4.641  12.547  1.00  0.00           H  
ATOM   1689  HB3 SER A 109      43.356  -4.500  13.363  1.00  0.00           H  
ATOM   1690  HG  SER A 109      43.623  -6.249  11.183  1.00  0.00           H  
ATOM   1691  N   ILE A 110      42.444  -1.611  11.699  1.00  0.00           N  
ATOM   1692  CA  ILE A 110      42.487  -0.203  12.073  1.00  0.00           C  
ATOM   1693  C   ILE A 110      42.132  -0.014  13.544  1.00  0.00           C  
ATOM   1694  O   ILE A 110      40.961  -0.040  13.919  1.00  0.00           O  
ATOM   1695  CB  ILE A 110      41.523   0.637  11.213  1.00  0.00           C  
ATOM   1696  CG1 ILE A 110      41.782   0.385   9.725  1.00  0.00           C  
ATOM   1697  CG2 ILE A 110      41.673   2.116  11.539  1.00  0.00           C  
ATOM   1698  CD1 ILE A 110      40.960  -0.748   9.153  1.00  0.00           C  
ATOM   1699  H   ILE A 110      41.595  -2.004  11.408  1.00  0.00           H  
ATOM   1700  HA  ILE A 110      43.491   0.157  11.906  1.00  0.00           H  
ATOM   1701  HB  ILE A 110      40.513   0.341  11.451  1.00  0.00           H  
ATOM   1702 HG12 ILE A 110      41.546   1.279   9.169  1.00  0.00           H  
ATOM   1703 HG13 ILE A 110      42.825   0.144   9.585  1.00  0.00           H  
ATOM   1704 HG21 ILE A 110      42.131   2.224  12.511  1.00  0.00           H  
ATOM   1705 HG22 ILE A 110      42.296   2.586  10.794  1.00  0.00           H  
ATOM   1706 HG23 ILE A 110      40.701   2.583  11.545  1.00  0.00           H  
ATOM   1707 HD11 ILE A 110      40.540  -1.332   9.960  1.00  0.00           H  
ATOM   1708 HD12 ILE A 110      40.161  -0.345   8.548  1.00  0.00           H  
ATOM   1709 HD13 ILE A 110      41.590  -1.379   8.545  1.00  0.00           H  
ATOM   1710  N   ASN A 111      43.153   0.177  14.373  1.00  0.00           N  
ATOM   1711  CA  ASN A 111      42.949   0.372  15.803  1.00  0.00           C  
ATOM   1712  C   ASN A 111      41.847  -0.544  16.326  1.00  0.00           C  
ATOM   1713  O   ASN A 111      41.134  -0.201  17.269  1.00  0.00           O  
ATOM   1714  CB  ASN A 111      42.595   1.832  16.096  1.00  0.00           C  
ATOM   1715  CG  ASN A 111      43.486   2.804  15.346  1.00  0.00           C  
ATOM   1716  OD1 ASN A 111      44.710   2.750  15.454  1.00  0.00           O  
ATOM   1717  ND2 ASN A 111      42.871   3.698  14.581  1.00  0.00           N  
ATOM   1718  H   ASN A 111      44.065   0.188  14.014  1.00  0.00           H  
ATOM   1719  HA  ASN A 111      43.873   0.127  16.306  1.00  0.00           H  
ATOM   1720  HB2 ASN A 111      41.571   2.012  15.804  1.00  0.00           H  
ATOM   1721  HB3 ASN A 111      42.701   2.017  17.155  1.00  0.00           H  
ATOM   1722 HD21 ASN A 111      41.892   3.681  14.543  1.00  0.00           H  
ATOM   1723 HD22 ASN A 111      43.423   4.339  14.084  1.00  0.00           H  
ATOM   1724  N   VAL A 112      41.713  -1.713  15.707  1.00  0.00           N  
ATOM   1725  CA  VAL A 112      40.700  -2.680  16.109  1.00  0.00           C  
ATOM   1726  C   VAL A 112      40.498  -2.669  17.621  1.00  0.00           C  
ATOM   1727  O   VAL A 112      39.402  -2.934  18.113  1.00  0.00           O  
ATOM   1728  CB  VAL A 112      41.075  -4.106  15.664  1.00  0.00           C  
ATOM   1729  CG1 VAL A 112      41.993  -4.761  16.686  1.00  0.00           C  
ATOM   1730  CG2 VAL A 112      39.825  -4.943  15.444  1.00  0.00           C  
ATOM   1731  H   VAL A 112      42.312  -1.929  14.961  1.00  0.00           H  
ATOM   1732  HA  VAL A 112      39.770  -2.409  15.630  1.00  0.00           H  
ATOM   1733  HB  VAL A 112      41.607  -4.040  14.726  1.00  0.00           H  
ATOM   1734 HG11 VAL A 112      41.397  -5.261  17.435  1.00  0.00           H  
ATOM   1735 HG12 VAL A 112      42.629  -5.479  16.190  1.00  0.00           H  
ATOM   1736 HG13 VAL A 112      42.603  -4.004  17.158  1.00  0.00           H  
ATOM   1737 HG21 VAL A 112      39.247  -4.974  16.357  1.00  0.00           H  
ATOM   1738 HG22 VAL A 112      39.231  -4.503  14.657  1.00  0.00           H  
ATOM   1739 HG23 VAL A 112      40.107  -5.947  15.164  1.00  0.00           H  
ATOM   1740  N   MET A 113      41.564  -2.359  18.351  1.00  0.00           N  
ATOM   1741  CA  MET A 113      41.504  -2.311  19.808  1.00  0.00           C  
ATOM   1742  C   MET A 113      41.915  -0.935  20.323  1.00  0.00           C  
ATOM   1743  O   MET A 113      42.723  -0.247  19.703  1.00  0.00           O  
ATOM   1744  CB  MET A 113      42.408  -3.386  20.413  1.00  0.00           C  
ATOM   1745  CG  MET A 113      43.890  -3.064  20.307  1.00  0.00           C  
ATOM   1746  SD  MET A 113      44.633  -3.700  18.793  1.00  0.00           S  
ATOM   1747  CE  MET A 113      45.074  -2.173  17.966  1.00  0.00           C  
ATOM   1748  H   MET A 113      42.412  -2.156  17.901  1.00  0.00           H  
ATOM   1749  HA  MET A 113      40.484  -2.503  20.103  1.00  0.00           H  
ATOM   1750  HB2 MET A 113      42.160  -3.502  21.458  1.00  0.00           H  
ATOM   1751  HB3 MET A 113      42.229  -4.321  19.902  1.00  0.00           H  
ATOM   1752  HG2 MET A 113      44.014  -1.992  20.329  1.00  0.00           H  
ATOM   1753  HG3 MET A 113      44.400  -3.501  21.154  1.00  0.00           H  
ATOM   1754  HE1 MET A 113      44.392  -1.391  18.267  1.00  0.00           H  
ATOM   1755  HE2 MET A 113      46.082  -1.895  18.235  1.00  0.00           H  
ATOM   1756  HE3 MET A 113      45.013  -2.312  16.896  1.00  0.00           H  
ATOM   1757  N   GLU A 114      41.351  -0.542  21.462  1.00  0.00           N  
ATOM   1758  CA  GLU A 114      41.660   0.751  22.059  1.00  0.00           C  
ATOM   1759  C   GLU A 114      43.113   0.806  22.520  1.00  0.00           C  
ATOM   1760  O   GLU A 114      43.444   0.356  23.617  1.00  0.00           O  
ATOM   1761  CB  GLU A 114      40.728   1.027  23.241  1.00  0.00           C  
ATOM   1762  CG  GLU A 114      39.372   1.579  22.832  1.00  0.00           C  
ATOM   1763  CD  GLU A 114      38.523   1.982  24.022  1.00  0.00           C  
ATOM   1764  OE1 GLU A 114      39.099   2.266  25.092  1.00  0.00           O  
ATOM   1765  OE2 GLU A 114      37.283   2.011  23.883  1.00  0.00           O  
ATOM   1766  H   GLU A 114      40.714  -1.137  21.910  1.00  0.00           H  
ATOM   1767  HA  GLU A 114      41.505   1.509  21.306  1.00  0.00           H  
ATOM   1768  HB2 GLU A 114      40.570   0.106  23.783  1.00  0.00           H  
ATOM   1769  HB3 GLU A 114      41.201   1.743  23.897  1.00  0.00           H  
ATOM   1770  HG2 GLU A 114      39.524   2.447  22.208  1.00  0.00           H  
ATOM   1771  HG3 GLU A 114      38.845   0.822  22.270  1.00  0.00           H  
ATOM   1772  N   GLU A 115      43.977   1.360  21.673  1.00  0.00           N  
ATOM   1773  CA  GLU A 115      45.394   1.472  21.994  1.00  0.00           C  
ATOM   1774  C   GLU A 115      45.656   2.673  22.897  1.00  0.00           C  
ATOM   1775  O   GLU A 115      44.922   3.661  22.885  1.00  0.00           O  
ATOM   1776  CB  GLU A 115      46.221   1.593  20.712  1.00  0.00           C  
ATOM   1777  CG  GLU A 115      46.580   0.255  20.088  1.00  0.00           C  
ATOM   1778  CD  GLU A 115      46.995   0.382  18.636  1.00  0.00           C  
ATOM   1779  OE1 GLU A 115      46.370   1.180  17.907  1.00  0.00           O  
ATOM   1780  OE2 GLU A 115      47.946  -0.318  18.227  1.00  0.00           O  
ATOM   1781  H   GLU A 115      43.651   1.700  20.814  1.00  0.00           H  
ATOM   1782  HA  GLU A 115      45.688   0.574  22.516  1.00  0.00           H  
ATOM   1783  HB2 GLU A 115      45.658   2.166  19.988  1.00  0.00           H  
ATOM   1784  HB3 GLU A 115      47.138   2.118  20.938  1.00  0.00           H  
ATOM   1785  HG2 GLU A 115      47.397  -0.179  20.645  1.00  0.00           H  
ATOM   1786  HG3 GLU A 115      45.720  -0.396  20.146  1.00  0.00           H  
ATOM   1787  N   PRO A 116      46.726   2.587  23.701  1.00  0.00           N  
ATOM   1788  CA  PRO A 116      47.109   3.657  24.626  1.00  0.00           C  
ATOM   1789  C   PRO A 116      47.631   4.892  23.899  1.00  0.00           C  
ATOM   1790  O   PRO A 116      47.609   4.957  22.670  1.00  0.00           O  
ATOM   1791  CB  PRO A 116      48.220   3.021  25.464  1.00  0.00           C  
ATOM   1792  CG  PRO A 116      48.790   1.956  24.592  1.00  0.00           C  
ATOM   1793  CD  PRO A 116      47.645   1.439  23.768  1.00  0.00           C  
ATOM   1794  HA  PRO A 116      46.288   3.939  25.268  1.00  0.00           H  
ATOM   1795  HB2 PRO A 116      48.961   3.768  25.713  1.00  0.00           H  
ATOM   1796  HB3 PRO A 116      47.801   2.606  26.369  1.00  0.00           H  
ATOM   1797  HG2 PRO A 116      49.553   2.375  23.953  1.00  0.00           H  
ATOM   1798  HG3 PRO A 116      49.203   1.165  25.201  1.00  0.00           H  
ATOM   1799  HD2 PRO A 116      47.985   1.159  22.781  1.00  0.00           H  
ATOM   1800  HD3 PRO A 116      47.176   0.598  24.259  1.00  0.00           H  
ATOM   1801  N   VAL A 117      48.101   5.870  24.667  1.00  0.00           N  
ATOM   1802  CA  VAL A 117      48.631   7.103  24.095  1.00  0.00           C  
ATOM   1803  C   VAL A 117      49.929   6.844  23.338  1.00  0.00           C  
ATOM   1804  O   VAL A 117      50.832   6.178  23.843  1.00  0.00           O  
ATOM   1805  CB  VAL A 117      48.887   8.162  25.185  1.00  0.00           C  
ATOM   1806  CG1 VAL A 117      49.928   7.666  26.177  1.00  0.00           C  
ATOM   1807  CG2 VAL A 117      49.322   9.477  24.556  1.00  0.00           C  
ATOM   1808  H   VAL A 117      48.092   5.761  25.641  1.00  0.00           H  
ATOM   1809  HA  VAL A 117      47.896   7.495  23.409  1.00  0.00           H  
ATOM   1810  HB  VAL A 117      47.964   8.329  25.719  1.00  0.00           H  
ATOM   1811 HG11 VAL A 117      49.768   8.140  27.135  1.00  0.00           H  
ATOM   1812 HG12 VAL A 117      49.841   6.594  26.285  1.00  0.00           H  
ATOM   1813 HG13 VAL A 117      50.915   7.911  25.816  1.00  0.00           H  
ATOM   1814 HG21 VAL A 117      49.991   9.993  25.228  1.00  0.00           H  
ATOM   1815 HG22 VAL A 117      49.829   9.280  23.624  1.00  0.00           H  
ATOM   1816 HG23 VAL A 117      48.454  10.093  24.372  1.00  0.00           H  
ATOM   1817  N   ILE A 118      50.014   7.377  22.123  1.00  0.00           N  
ATOM   1818  CA  ILE A 118      51.201   7.205  21.296  1.00  0.00           C  
ATOM   1819  C   ILE A 118      51.721   8.548  20.793  1.00  0.00           C  
ATOM   1820  O   ILE A 118      50.942   9.460  20.514  1.00  0.00           O  
ATOM   1821  CB  ILE A 118      50.921   6.291  20.089  1.00  0.00           C  
ATOM   1822  CG1 ILE A 118      50.558   4.882  20.563  1.00  0.00           C  
ATOM   1823  CG2 ILE A 118      52.126   6.251  19.163  1.00  0.00           C  
ATOM   1824  CD1 ILE A 118      51.724   4.127  21.160  1.00  0.00           C  
ATOM   1825  H   ILE A 118      49.261   7.899  21.776  1.00  0.00           H  
ATOM   1826  HA  ILE A 118      51.966   6.741  21.904  1.00  0.00           H  
ATOM   1827  HB  ILE A 118      50.088   6.704  19.540  1.00  0.00           H  
ATOM   1828 HG12 ILE A 118      49.787   4.950  21.314  1.00  0.00           H  
ATOM   1829 HG13 ILE A 118      50.187   4.313  19.723  1.00  0.00           H  
ATOM   1830 HG21 ILE A 118      52.298   5.234  18.839  1.00  0.00           H  
ATOM   1831 HG22 ILE A 118      51.940   6.875  18.302  1.00  0.00           H  
ATOM   1832 HG23 ILE A 118      52.996   6.612  19.689  1.00  0.00           H  
ATOM   1833 HD11 ILE A 118      51.535   3.944  22.208  1.00  0.00           H  
ATOM   1834 HD12 ILE A 118      51.842   3.183  20.648  1.00  0.00           H  
ATOM   1835 HD13 ILE A 118      52.624   4.711  21.053  1.00  0.00           H  
ATOM   1836  N   ILE A 119      53.039   8.662  20.679  1.00  0.00           N  
ATOM   1837  CA  ILE A 119      53.661   9.892  20.206  1.00  0.00           C  
ATOM   1838  C   ILE A 119      52.863  10.507  19.061  1.00  0.00           C  
ATOM   1839  O   ILE A 119      52.742  11.729  18.959  1.00  0.00           O  
ATOM   1840  CB  ILE A 119      55.107   9.648  19.734  1.00  0.00           C  
ATOM   1841  CG1 ILE A 119      55.145   8.523  18.696  1.00  0.00           C  
ATOM   1842  CG2 ILE A 119      56.000   9.313  20.919  1.00  0.00           C  
ATOM   1843  CD1 ILE A 119      56.545   8.142  18.269  1.00  0.00           C  
ATOM   1844  H   ILE A 119      53.607   7.900  20.916  1.00  0.00           H  
ATOM   1845  HA  ILE A 119      53.685  10.591  21.030  1.00  0.00           H  
ATOM   1846  HB  ILE A 119      55.474  10.557  19.284  1.00  0.00           H  
ATOM   1847 HG12 ILE A 119      54.674   7.645  19.109  1.00  0.00           H  
ATOM   1848 HG13 ILE A 119      54.602   8.838  17.817  1.00  0.00           H  
ATOM   1849 HG21 ILE A 119      56.711  10.110  21.071  1.00  0.00           H  
ATOM   1850 HG22 ILE A 119      55.395   9.198  21.806  1.00  0.00           H  
ATOM   1851 HG23 ILE A 119      56.529   8.391  20.723  1.00  0.00           H  
ATOM   1852 HD11 ILE A 119      57.264   8.683  18.869  1.00  0.00           H  
ATOM   1853 HD12 ILE A 119      56.687   7.081  18.408  1.00  0.00           H  
ATOM   1854 HD13 ILE A 119      56.685   8.393  17.228  1.00  0.00           H  
ATOM   1855  N   THR A 120      52.316   9.653  18.202  1.00  0.00           N  
ATOM   1856  CA  THR A 120      51.528  10.112  17.065  1.00  0.00           C  
ATOM   1857  C   THR A 120      50.713  11.348  17.424  1.00  0.00           C  
ATOM   1858  O   THR A 120      50.526  12.241  16.598  1.00  0.00           O  
ATOM   1859  CB  THR A 120      50.576   9.010  16.561  1.00  0.00           C  
ATOM   1860  OG1 THR A 120      50.277   9.218  15.176  1.00  0.00           O  
ATOM   1861  CG2 THR A 120      49.286   9.001  17.367  1.00  0.00           C  
ATOM   1862  H   THR A 120      52.447   8.691  18.337  1.00  0.00           H  
ATOM   1863  HA  THR A 120      52.211  10.361  16.265  1.00  0.00           H  
ATOM   1864  HB  THR A 120      51.063   8.053  16.677  1.00  0.00           H  
ATOM   1865  HG1 THR A 120      49.654   8.549  14.879  1.00  0.00           H  
ATOM   1866 HG21 THR A 120      49.509   8.775  18.399  1.00  0.00           H  
ATOM   1867 HG22 THR A 120      48.619   8.249  16.972  1.00  0.00           H  
ATOM   1868 HG23 THR A 120      48.814   9.970  17.304  1.00  0.00           H  
ATOM   1869  N   ARG A 121      50.230  11.394  18.661  1.00  0.00           N  
ATOM   1870  CA  ARG A 121      49.434  12.523  19.128  1.00  0.00           C  
ATOM   1871  C   ARG A 121      50.042  13.845  18.670  1.00  0.00           C  
ATOM   1872  O   ARG A 121      51.252  13.948  18.479  1.00  0.00           O  
ATOM   1873  CB  ARG A 121      49.326  12.500  20.654  1.00  0.00           C  
ATOM   1874  CG  ARG A 121      50.671  12.554  21.361  1.00  0.00           C  
ATOM   1875  CD  ARG A 121      50.552  12.135  22.818  1.00  0.00           C  
ATOM   1876  NE  ARG A 121      51.858  11.921  23.434  1.00  0.00           N  
ATOM   1877  CZ  ARG A 121      52.703  12.901  23.727  1.00  0.00           C  
ATOM   1878  NH1 ARG A 121      52.382  14.160  23.461  1.00  0.00           N  
ATOM   1879  NH2 ARG A 121      53.875  12.625  24.287  1.00  0.00           N  
ATOM   1880  H   ARG A 121      50.413  10.652  19.274  1.00  0.00           H  
ATOM   1881  HA  ARG A 121      48.445  12.429  18.706  1.00  0.00           H  
ATOM   1882  HB2 ARG A 121      48.742  13.350  20.975  1.00  0.00           H  
ATOM   1883  HB3 ARG A 121      48.822  11.594  20.955  1.00  0.00           H  
ATOM   1884  HG2 ARG A 121      51.356  11.885  20.861  1.00  0.00           H  
ATOM   1885  HG3 ARG A 121      51.051  13.563  21.314  1.00  0.00           H  
ATOM   1886  HD2 ARG A 121      50.033  12.913  23.360  1.00  0.00           H  
ATOM   1887  HD3 ARG A 121      49.983  11.220  22.871  1.00  0.00           H  
ATOM   1888  HE  ARG A 121      52.116  10.997  23.638  1.00  0.00           H  
ATOM   1889 HH11 ARG A 121      51.500  14.371  23.041  1.00  0.00           H  
ATOM   1890 HH12 ARG A 121      53.020  14.898  23.684  1.00  0.00           H  
ATOM   1891 HH21 ARG A 121      54.121  11.677  24.489  1.00  0.00           H  
ATOM   1892 HH22 ARG A 121      54.510  13.364  24.507  1.00  0.00           H  
ATOM   1893  N   ASN A 122      49.193  14.851  18.496  1.00  0.00           N  
ATOM   1894  CA  ASN A 122      49.647  16.167  18.059  1.00  0.00           C  
ATOM   1895  C   ASN A 122      50.643  16.757  19.053  1.00  0.00           C  
ATOM   1896  O   ASN A 122      50.329  16.941  20.227  1.00  0.00           O  
ATOM   1897  CB  ASN A 122      48.455  17.112  17.895  1.00  0.00           C  
ATOM   1898  CG  ASN A 122      48.765  18.279  16.977  1.00  0.00           C  
ATOM   1899  OD1 ASN A 122      48.924  18.108  15.769  1.00  0.00           O  
ATOM   1900  ND2 ASN A 122      48.852  19.475  17.550  1.00  0.00           N  
ATOM   1901  H   ASN A 122      48.238  14.707  18.664  1.00  0.00           H  
ATOM   1902  HA  ASN A 122      50.136  16.048  17.104  1.00  0.00           H  
ATOM   1903  HB2 ASN A 122      47.623  16.563  17.477  1.00  0.00           H  
ATOM   1904  HB3 ASN A 122      48.175  17.502  18.861  1.00  0.00           H  
ATOM   1905 HD21 ASN A 122      48.713  19.535  18.519  1.00  0.00           H  
ATOM   1906 HD22 ASN A 122      49.050  20.247  16.981  1.00  0.00           H  
ATOM   1907  N   SER A 123      51.847  17.051  18.571  1.00  0.00           N  
ATOM   1908  CA  SER A 123      52.891  17.616  19.417  1.00  0.00           C  
ATOM   1909  C   SER A 123      53.983  18.264  18.571  1.00  0.00           C  
ATOM   1910  O   SER A 123      53.961  18.188  17.343  1.00  0.00           O  
ATOM   1911  CB  SER A 123      53.497  16.531  20.309  1.00  0.00           C  
ATOM   1912  OG  SER A 123      53.974  15.443  19.537  1.00  0.00           O  
ATOM   1913  H   SER A 123      52.038  16.880  17.625  1.00  0.00           H  
ATOM   1914  HA  SER A 123      52.439  18.372  20.041  1.00  0.00           H  
ATOM   1915  HB2 SER A 123      54.321  16.947  20.869  1.00  0.00           H  
ATOM   1916  HB3 SER A 123      52.744  16.169  20.994  1.00  0.00           H  
ATOM   1917  HG  SER A 123      54.852  15.644  19.207  1.00  0.00           H  
ATOM   1918  N   HIS A 124      54.941  18.901  19.239  1.00  0.00           N  
ATOM   1919  CA  HIS A 124      56.042  19.562  18.550  1.00  0.00           C  
ATOM   1920  C   HIS A 124      56.501  18.744  17.347  1.00  0.00           C  
ATOM   1921  O   HIS A 124      56.516  17.512  17.372  1.00  0.00           O  
ATOM   1922  CB  HIS A 124      57.214  19.781  19.509  1.00  0.00           C  
ATOM   1923  CG  HIS A 124      57.858  18.508  19.967  1.00  0.00           C  
ATOM   1924  ND1 HIS A 124      57.608  17.938  21.197  1.00  0.00           N  
ATOM   1925  CD2 HIS A 124      58.746  17.693  19.351  1.00  0.00           C  
ATOM   1926  CE1 HIS A 124      58.315  16.830  21.318  1.00  0.00           C  
ATOM   1927  NE2 HIS A 124      59.014  16.658  20.212  1.00  0.00           N  
ATOM   1928  H   HIS A 124      54.904  18.927  20.218  1.00  0.00           H  
ATOM   1929  HA  HIS A 124      55.690  20.521  18.204  1.00  0.00           H  
ATOM   1930  HB2 HIS A 124      57.969  20.374  19.016  1.00  0.00           H  
ATOM   1931  HB3 HIS A 124      56.861  20.308  20.383  1.00  0.00           H  
ATOM   1932  HD1 HIS A 124      57.002  18.294  21.880  1.00  0.00           H  
ATOM   1933  HD2 HIS A 124      59.168  17.832  18.365  1.00  0.00           H  
ATOM   1934  HE1 HIS A 124      58.320  16.173  22.176  1.00  0.00           H  
ATOM   1935  HE2 HIS A 124      59.687  15.959  20.072  1.00  0.00           H  
ATOM   1936  N   PRO A 125      56.883  19.441  16.267  1.00  0.00           N  
ATOM   1937  CA  PRO A 125      57.349  18.798  15.034  1.00  0.00           C  
ATOM   1938  C   PRO A 125      58.709  18.130  15.206  1.00  0.00           C  
ATOM   1939  O   PRO A 125      59.550  18.601  15.971  1.00  0.00           O  
ATOM   1940  CB  PRO A 125      57.446  19.961  14.043  1.00  0.00           C  
ATOM   1941  CG  PRO A 125      57.649  21.167  14.892  1.00  0.00           C  
ATOM   1942  CD  PRO A 125      56.892  20.910  16.166  1.00  0.00           C  
ATOM   1943  HA  PRO A 125      56.636  18.072  14.672  1.00  0.00           H  
ATOM   1944  HB2 PRO A 125      58.281  19.800  13.377  1.00  0.00           H  
ATOM   1945  HB3 PRO A 125      56.531  20.030  13.473  1.00  0.00           H  
ATOM   1946  HG2 PRO A 125      58.701  21.296  15.101  1.00  0.00           H  
ATOM   1947  HG3 PRO A 125      57.254  22.039  14.393  1.00  0.00           H  
ATOM   1948  HD2 PRO A 125      57.407  21.351  17.007  1.00  0.00           H  
ATOM   1949  HD3 PRO A 125      55.886  21.296  16.092  1.00  0.00           H  
ATOM   1950  N   ALA A 126      58.918  17.032  14.488  1.00  0.00           N  
ATOM   1951  CA  ALA A 126      60.178  16.301  14.560  1.00  0.00           C  
ATOM   1952  C   ALA A 126      60.438  15.530  13.270  1.00  0.00           C  
ATOM   1953  O   ALA A 126      59.608  15.523  12.362  1.00  0.00           O  
ATOM   1954  CB  ALA A 126      60.172  15.356  15.752  1.00  0.00           C  
ATOM   1955  H   ALA A 126      58.209  16.706  13.895  1.00  0.00           H  
ATOM   1956  HA  ALA A 126      60.973  17.019  14.704  1.00  0.00           H  
ATOM   1957  HB1 ALA A 126      59.209  15.398  16.239  1.00  0.00           H  
ATOM   1958  HB2 ALA A 126      60.360  14.347  15.410  1.00  0.00           H  
ATOM   1959  HB3 ALA A 126      60.942  15.650  16.448  1.00  0.00           H  
ATOM   1960  N   GLU A 127      61.597  14.881  13.199  1.00  0.00           N  
ATOM   1961  CA  GLU A 127      61.966  14.107  12.019  1.00  0.00           C  
ATOM   1962  C   GLU A 127      61.072  12.880  11.871  1.00  0.00           C  
ATOM   1963  O   GLU A 127      61.442  11.776  12.270  1.00  0.00           O  
ATOM   1964  CB  GLU A 127      63.432  13.676  12.103  1.00  0.00           C  
ATOM   1965  CG  GLU A 127      64.409  14.744  11.641  1.00  0.00           C  
ATOM   1966  CD  GLU A 127      65.855  14.317  11.792  1.00  0.00           C  
ATOM   1967  OE1 GLU A 127      66.336  14.248  12.944  1.00  0.00           O  
ATOM   1968  OE2 GLU A 127      66.507  14.052  10.760  1.00  0.00           O  
ATOM   1969  H   GLU A 127      62.217  14.924  13.956  1.00  0.00           H  
ATOM   1970  HA  GLU A 127      61.836  14.739  11.154  1.00  0.00           H  
ATOM   1971  HB2 GLU A 127      63.662  13.425  13.128  1.00  0.00           H  
ATOM   1972  HB3 GLU A 127      63.572  12.800  11.487  1.00  0.00           H  
ATOM   1973  HG2 GLU A 127      64.220  14.961  10.601  1.00  0.00           H  
ATOM   1974  HG3 GLU A 127      64.249  15.637  12.228  1.00  0.00           H  
ATOM   1975  N   LEU A 128      59.891  13.082  11.295  1.00  0.00           N  
ATOM   1976  CA  LEU A 128      58.942  11.994  11.093  1.00  0.00           C  
ATOM   1977  C   LEU A 128      58.923  11.550   9.633  1.00  0.00           C  
ATOM   1978  O   LEU A 128      58.953  12.377   8.723  1.00  0.00           O  
ATOM   1979  CB  LEU A 128      57.540  12.427  11.524  1.00  0.00           C  
ATOM   1980  CG  LEU A 128      56.626  11.319  12.049  1.00  0.00           C  
ATOM   1981  CD1 LEU A 128      55.600  11.886  13.017  1.00  0.00           C  
ATOM   1982  CD2 LEU A 128      55.936  10.606  10.894  1.00  0.00           C  
ATOM   1983  H   LEU A 128      59.653  13.984  10.997  1.00  0.00           H  
ATOM   1984  HA  LEU A 128      59.257  11.162  11.706  1.00  0.00           H  
ATOM   1985  HB2 LEU A 128      57.647  13.164  12.306  1.00  0.00           H  
ATOM   1986  HB3 LEU A 128      57.056  12.879  10.670  1.00  0.00           H  
ATOM   1987  HG  LEU A 128      57.222  10.592  12.583  1.00  0.00           H  
ATOM   1988 HD11 LEU A 128      55.321  12.881  12.704  1.00  0.00           H  
ATOM   1989 HD12 LEU A 128      56.024  11.926  14.009  1.00  0.00           H  
ATOM   1990 HD13 LEU A 128      54.724  11.253  13.026  1.00  0.00           H  
ATOM   1991 HD21 LEU A 128      56.062   9.538  11.004  1.00  0.00           H  
ATOM   1992 HD22 LEU A 128      56.374  10.927   9.960  1.00  0.00           H  
ATOM   1993 HD23 LEU A 128      54.883  10.847  10.901  1.00  0.00           H  
ATOM   1994  N   ASP A 129      58.871  10.240   9.420  1.00  0.00           N  
ATOM   1995  CA  ASP A 129      58.844   9.687   8.072  1.00  0.00           C  
ATOM   1996  C   ASP A 129      57.893  10.477   7.178  1.00  0.00           C  
ATOM   1997  O   ASP A 129      57.008  11.180   7.665  1.00  0.00           O  
ATOM   1998  CB  ASP A 129      58.425   8.216   8.109  1.00  0.00           C  
ATOM   1999  CG  ASP A 129      57.037   8.025   8.688  1.00  0.00           C  
ATOM   2000  OD1 ASP A 129      56.052   8.347   7.991  1.00  0.00           O  
ATOM   2001  OD2 ASP A 129      56.935   7.551   9.840  1.00  0.00           O  
ATOM   2002  H   ASP A 129      58.849   9.630  10.187  1.00  0.00           H  
ATOM   2003  HA  ASP A 129      59.842   9.756   7.665  1.00  0.00           H  
ATOM   2004  HB2 ASP A 129      58.432   7.821   7.103  1.00  0.00           H  
ATOM   2005  HB3 ASP A 129      59.128   7.663   8.714  1.00  0.00           H  
ATOM   2006  N   LEU A 130      58.084  10.357   5.868  1.00  0.00           N  
ATOM   2007  CA  LEU A 130      57.244  11.061   4.905  1.00  0.00           C  
ATOM   2008  C   LEU A 130      56.456  10.078   4.047  1.00  0.00           C  
ATOM   2009  O   LEU A 130      56.906   8.967   3.761  1.00  0.00           O  
ATOM   2010  CB  LEU A 130      58.101  11.961   4.013  1.00  0.00           C  
ATOM   2011  CG  LEU A 130      59.269  11.281   3.299  1.00  0.00           C  
ATOM   2012  CD1 LEU A 130      58.801  10.646   1.998  1.00  0.00           C  
ATOM   2013  CD2 LEU A 130      60.387  12.279   3.035  1.00  0.00           C  
ATOM   2014  H   LEU A 130      58.806   9.782   5.540  1.00  0.00           H  
ATOM   2015  HA  LEU A 130      56.548  11.675   5.460  1.00  0.00           H  
ATOM   2016  HB2 LEU A 130      57.457  12.390   3.260  1.00  0.00           H  
ATOM   2017  HB3 LEU A 130      58.505  12.750   4.632  1.00  0.00           H  
ATOM   2018  HG  LEU A 130      59.662  10.497   3.930  1.00  0.00           H  
ATOM   2019 HD11 LEU A 130      57.922  11.161   1.641  1.00  0.00           H  
ATOM   2020 HD12 LEU A 130      58.564   9.607   2.171  1.00  0.00           H  
ATOM   2021 HD13 LEU A 130      59.587  10.718   1.260  1.00  0.00           H  
ATOM   2022 HD21 LEU A 130      61.322  11.875   3.395  1.00  0.00           H  
ATOM   2023 HD22 LEU A 130      60.172  13.204   3.550  1.00  0.00           H  
ATOM   2024 HD23 LEU A 130      60.459  12.467   1.973  1.00  0.00           H  
ATOM   2025  N   PRO A 131      55.253  10.492   3.624  1.00  0.00           N  
ATOM   2026  CA  PRO A 131      54.377   9.662   2.791  1.00  0.00           C  
ATOM   2027  C   PRO A 131      54.922   9.485   1.377  1.00  0.00           C  
ATOM   2028  O   PRO A 131      56.059   9.858   1.088  1.00  0.00           O  
ATOM   2029  CB  PRO A 131      53.064  10.448   2.764  1.00  0.00           C  
ATOM   2030  CG  PRO A 131      53.463  11.861   3.011  1.00  0.00           C  
ATOM   2031  CD  PRO A 131      54.652  11.802   3.929  1.00  0.00           C  
ATOM   2032  HA  PRO A 131      54.210   8.692   3.234  1.00  0.00           H  
ATOM   2033  HB2 PRO A 131      52.593  10.332   1.798  1.00  0.00           H  
ATOM   2034  HB3 PRO A 131      52.406  10.082   3.538  1.00  0.00           H  
ATOM   2035  HG2 PRO A 131      53.732  12.335   2.079  1.00  0.00           H  
ATOM   2036  HG3 PRO A 131      52.651  12.394   3.484  1.00  0.00           H  
ATOM   2037  HD2 PRO A 131      55.342  12.603   3.705  1.00  0.00           H  
ATOM   2038  HD3 PRO A 131      54.336  11.850   4.960  1.00  0.00           H  
ATOM   2039  N   ARG A 132      54.103   8.914   0.500  1.00  0.00           N  
ATOM   2040  CA  ARG A 132      54.503   8.687  -0.883  1.00  0.00           C  
ATOM   2041  C   ARG A 132      54.456   9.986  -1.683  1.00  0.00           C  
ATOM   2042  O   ARG A 132      54.047  11.028  -1.170  1.00  0.00           O  
ATOM   2043  CB  ARG A 132      53.595   7.642  -1.534  1.00  0.00           C  
ATOM   2044  CG  ARG A 132      52.189   8.145  -1.813  1.00  0.00           C  
ATOM   2045  CD  ARG A 132      51.267   7.014  -2.242  1.00  0.00           C  
ATOM   2046  NE  ARG A 132      50.652   6.346  -1.098  1.00  0.00           N  
ATOM   2047  CZ  ARG A 132      49.576   6.807  -0.470  1.00  0.00           C  
ATOM   2048  NH1 ARG A 132      48.999   7.931  -0.872  1.00  0.00           N  
ATOM   2049  NH2 ARG A 132      49.075   6.142   0.564  1.00  0.00           N  
ATOM   2050  H   ARG A 132      53.209   8.638   0.791  1.00  0.00           H  
ATOM   2051  HA  ARG A 132      55.517   8.318  -0.879  1.00  0.00           H  
ATOM   2052  HB2 ARG A 132      54.036   7.333  -2.471  1.00  0.00           H  
ATOM   2053  HB3 ARG A 132      53.525   6.786  -0.879  1.00  0.00           H  
ATOM   2054  HG2 ARG A 132      51.793   8.597  -0.916  1.00  0.00           H  
ATOM   2055  HG3 ARG A 132      52.230   8.882  -2.601  1.00  0.00           H  
ATOM   2056  HD2 ARG A 132      50.488   7.421  -2.870  1.00  0.00           H  
ATOM   2057  HD3 ARG A 132      51.841   6.293  -2.803  1.00  0.00           H  
ATOM   2058  HE  ARG A 132      51.063   5.514  -0.784  1.00  0.00           H  
ATOM   2059 HH11 ARG A 132      49.374   8.433  -1.652  1.00  0.00           H  
ATOM   2060 HH12 ARG A 132      48.188   8.274  -0.398  1.00  0.00           H  
ATOM   2061 HH21 ARG A 132      49.508   5.295   0.870  1.00  0.00           H  
ATOM   2062 HH22 ARG A 132      48.266   6.489   1.037  1.00  0.00           H  
ATOM   2063  N   ALA A 133      54.876   9.917  -2.941  1.00  0.00           N  
ATOM   2064  CA  ALA A 133      54.880  11.086  -3.812  1.00  0.00           C  
ATOM   2065  C   ALA A 133      54.648  10.689  -5.266  1.00  0.00           C  
ATOM   2066  O   ALA A 133      55.110   9.646  -5.731  1.00  0.00           O  
ATOM   2067  CB  ALA A 133      56.192  11.842  -3.673  1.00  0.00           C  
ATOM   2068  H   ALA A 133      55.190   9.057  -3.293  1.00  0.00           H  
ATOM   2069  HA  ALA A 133      54.080  11.739  -3.495  1.00  0.00           H  
ATOM   2070  HB1 ALA A 133      57.002  11.139  -3.543  1.00  0.00           H  
ATOM   2071  HB2 ALA A 133      56.365  12.430  -4.564  1.00  0.00           H  
ATOM   2072  HB3 ALA A 133      56.143  12.495  -2.815  1.00  0.00           H  
ATOM   2073  N   PRO A 134      53.914  11.537  -6.001  1.00  0.00           N  
ATOM   2074  CA  PRO A 134      53.604  11.294  -7.413  1.00  0.00           C  
ATOM   2075  C   PRO A 134      54.831  11.427  -8.308  1.00  0.00           C  
ATOM   2076  O   PRO A 134      55.867  11.940  -7.884  1.00  0.00           O  
ATOM   2077  CB  PRO A 134      52.582  12.385  -7.744  1.00  0.00           C  
ATOM   2078  CG  PRO A 134      52.863  13.476  -6.769  1.00  0.00           C  
ATOM   2079  CD  PRO A 134      53.332  12.797  -5.512  1.00  0.00           C  
ATOM   2080  HA  PRO A 134      53.155  10.323  -7.560  1.00  0.00           H  
ATOM   2081  HB2 PRO A 134      52.724  12.718  -8.762  1.00  0.00           H  
ATOM   2082  HB3 PRO A 134      51.582  11.995  -7.622  1.00  0.00           H  
ATOM   2083  HG2 PRO A 134      53.636  14.124  -7.156  1.00  0.00           H  
ATOM   2084  HG3 PRO A 134      51.961  14.038  -6.577  1.00  0.00           H  
ATOM   2085  HD2 PRO A 134      54.077  13.399  -5.013  1.00  0.00           H  
ATOM   2086  HD3 PRO A 134      52.497  12.605  -4.853  1.00  0.00           H  
ATOM   2087  N   GLN A 135      54.709  10.960  -9.546  1.00  0.00           N  
ATOM   2088  CA  GLN A 135      55.810  11.027 -10.499  1.00  0.00           C  
ATOM   2089  C   GLN A 135      55.712  12.284 -11.358  1.00  0.00           C  
ATOM   2090  O   GLN A 135      54.639  12.662 -11.828  1.00  0.00           O  
ATOM   2091  CB  GLN A 135      55.814   9.785 -11.393  1.00  0.00           C  
ATOM   2092  CG  GLN A 135      57.087   9.628 -12.210  1.00  0.00           C  
ATOM   2093  CD  GLN A 135      58.267   9.178 -11.371  1.00  0.00           C  
ATOM   2094  OE1 GLN A 135      58.099   8.697 -10.251  1.00  0.00           O  
ATOM   2095  NE2 GLN A 135      59.470   9.333 -11.912  1.00  0.00           N  
ATOM   2096  H   GLN A 135      53.858  10.562  -9.825  1.00  0.00           H  
ATOM   2097  HA  GLN A 135      56.732  11.060  -9.939  1.00  0.00           H  
ATOM   2098  HB2 GLN A 135      55.701   8.909 -10.773  1.00  0.00           H  
ATOM   2099  HB3 GLN A 135      54.980   9.844 -12.076  1.00  0.00           H  
ATOM   2100  HG2 GLN A 135      56.915   8.895 -12.984  1.00  0.00           H  
ATOM   2101  HG3 GLN A 135      57.328  10.579 -12.664  1.00  0.00           H  
ATOM   2102 HE21 GLN A 135      59.528   9.725 -12.809  1.00  0.00           H  
ATOM   2103 HE22 GLN A 135      60.251   9.053 -11.392  1.00  0.00           H  
ATOM   2104  N   PRO A 136      56.858  12.949 -11.566  1.00  0.00           N  
ATOM   2105  CA  PRO A 136      56.928  14.175 -12.369  1.00  0.00           C  
ATOM   2106  C   PRO A 136      56.697  13.909 -13.852  1.00  0.00           C  
ATOM   2107  O   PRO A 136      57.285  13.004 -14.445  1.00  0.00           O  
ATOM   2108  CB  PRO A 136      58.354  14.673 -12.130  1.00  0.00           C  
ATOM   2109  CG  PRO A 136      59.130  13.452 -11.775  1.00  0.00           C  
ATOM   2110  CD  PRO A 136      58.175  12.556 -11.036  1.00  0.00           C  
ATOM   2111  HA  PRO A 136      56.222  14.915 -12.023  1.00  0.00           H  
ATOM   2112  HB2 PRO A 136      58.733  15.135 -13.032  1.00  0.00           H  
ATOM   2113  HB3 PRO A 136      58.359  15.391 -11.324  1.00  0.00           H  
ATOM   2114  HG2 PRO A 136      59.481  12.966 -12.673  1.00  0.00           H  
ATOM   2115  HG3 PRO A 136      59.962  13.717 -11.140  1.00  0.00           H  
ATOM   2116  HD2 PRO A 136      58.384  11.519 -11.253  1.00  0.00           H  
ATOM   2117  HD3 PRO A 136      58.231  12.739  -9.973  1.00  0.00           H  
ATOM   2118  N   PRO A 137      55.821  14.716 -14.469  1.00  0.00           N  
ATOM   2119  CA  PRO A 137      55.492  14.589 -15.892  1.00  0.00           C  
ATOM   2120  C   PRO A 137      56.653  14.998 -16.793  1.00  0.00           C  
ATOM   2121  O   PRO A 137      57.751  15.280 -16.316  1.00  0.00           O  
ATOM   2122  CB  PRO A 137      54.313  15.547 -16.072  1.00  0.00           C  
ATOM   2123  CG  PRO A 137      54.472  16.553 -14.985  1.00  0.00           C  
ATOM   2124  CD  PRO A 137      55.082  15.815 -13.824  1.00  0.00           C  
ATOM   2125  HA  PRO A 137      55.183  13.583 -16.139  1.00  0.00           H  
ATOM   2126  HB2 PRO A 137      54.365  16.008 -17.048  1.00  0.00           H  
ATOM   2127  HB3 PRO A 137      53.385  15.004 -15.973  1.00  0.00           H  
ATOM   2128  HG2 PRO A 137      55.128  17.346 -15.311  1.00  0.00           H  
ATOM   2129  HG3 PRO A 137      53.507  16.951 -14.709  1.00  0.00           H  
ATOM   2130  HD2 PRO A 137      55.752  16.461 -13.277  1.00  0.00           H  
ATOM   2131  HD3 PRO A 137      54.310  15.431 -13.174  1.00  0.00           H  
ATOM   2132  N   ASN A 138      56.400  15.029 -18.098  1.00  0.00           N  
ATOM   2133  CA  ASN A 138      57.425  15.404 -19.065  1.00  0.00           C  
ATOM   2134  C   ASN A 138      57.172  16.807 -19.609  1.00  0.00           C  
ATOM   2135  O   ASN A 138      56.149  17.423 -19.313  1.00  0.00           O  
ATOM   2136  CB  ASN A 138      57.462  14.398 -20.217  1.00  0.00           C  
ATOM   2137  CG  ASN A 138      56.127  14.287 -20.930  1.00  0.00           C  
ATOM   2138  OD1 ASN A 138      55.151  14.929 -20.546  1.00  0.00           O  
ATOM   2139  ND2 ASN A 138      56.082  13.468 -21.975  1.00  0.00           N  
ATOM   2140  H   ASN A 138      55.505  14.793 -18.417  1.00  0.00           H  
ATOM   2141  HA  ASN A 138      58.379  15.393 -18.559  1.00  0.00           H  
ATOM   2142  HB2 ASN A 138      58.206  14.707 -20.935  1.00  0.00           H  
ATOM   2143  HB3 ASN A 138      57.723  13.424 -19.830  1.00  0.00           H  
ATOM   2144 HD21 ASN A 138      56.899  12.988 -22.224  1.00  0.00           H  
ATOM   2145 HD22 ASN A 138      55.232  13.379 -22.455  1.00  0.00           H  
ATOM   2146  N   ALA A 139      58.111  17.304 -20.407  1.00  0.00           N  
ATOM   2147  CA  ALA A 139      57.989  18.633 -20.994  1.00  0.00           C  
ATOM   2148  C   ALA A 139      57.804  18.550 -22.505  1.00  0.00           C  
ATOM   2149  O   ALA A 139      58.116  17.532 -23.125  1.00  0.00           O  
ATOM   2150  CB  ALA A 139      59.212  19.474 -20.656  1.00  0.00           C  
ATOM   2151  H   ALA A 139      58.904  16.765 -20.606  1.00  0.00           H  
ATOM   2152  HA  ALA A 139      57.123  19.111 -20.560  1.00  0.00           H  
ATOM   2153  HB1 ALA A 139      59.574  19.958 -21.551  1.00  0.00           H  
ATOM   2154  HB2 ALA A 139      58.941  20.222 -19.926  1.00  0.00           H  
ATOM   2155  HB3 ALA A 139      59.985  18.838 -20.251  1.00  0.00           H  
ATOM   2156  N   LEU A 140      57.292  19.626 -23.093  1.00  0.00           N  
ATOM   2157  CA  LEU A 140      57.062  19.674 -24.534  1.00  0.00           C  
ATOM   2158  C   LEU A 140      57.928  20.748 -25.186  1.00  0.00           C  
ATOM   2159  O   LEU A 140      57.894  21.912 -24.790  1.00  0.00           O  
ATOM   2160  CB  LEU A 140      55.586  19.946 -24.826  1.00  0.00           C  
ATOM   2161  CG  LEU A 140      55.043  19.366 -26.132  1.00  0.00           C  
ATOM   2162  CD1 LEU A 140      54.682  17.899 -25.956  1.00  0.00           C  
ATOM   2163  CD2 LEU A 140      53.836  20.161 -26.608  1.00  0.00           C  
ATOM   2164  H   LEU A 140      57.062  20.406 -22.547  1.00  0.00           H  
ATOM   2165  HA  LEU A 140      57.332  18.713 -24.944  1.00  0.00           H  
ATOM   2166  HB2 LEU A 140      55.007  19.533 -24.014  1.00  0.00           H  
ATOM   2167  HB3 LEU A 140      55.447  21.018 -24.855  1.00  0.00           H  
ATOM   2168  HG  LEU A 140      55.809  19.431 -26.893  1.00  0.00           H  
ATOM   2169 HD11 LEU A 140      54.739  17.638 -24.910  1.00  0.00           H  
ATOM   2170 HD12 LEU A 140      55.373  17.288 -26.517  1.00  0.00           H  
ATOM   2171 HD13 LEU A 140      53.677  17.730 -26.317  1.00  0.00           H  
ATOM   2172 HD21 LEU A 140      53.683  19.987 -27.662  1.00  0.00           H  
ATOM   2173 HD22 LEU A 140      54.009  21.214 -26.438  1.00  0.00           H  
ATOM   2174 HD23 LEU A 140      52.959  19.848 -26.059  1.00  0.00           H  
ATOM   2175  N   GLY A 141      58.702  20.347 -26.191  1.00  0.00           N  
ATOM   2176  CA  GLY A 141      59.564  21.287 -26.883  1.00  0.00           C  
ATOM   2177  C   GLY A 141      58.781  22.346 -27.634  1.00  0.00           C  
ATOM   2178  O   GLY A 141      57.637  22.643 -27.290  1.00  0.00           O  
ATOM   2179  H   GLY A 141      58.688  19.405 -26.463  1.00  0.00           H  
ATOM   2180  HA2 GLY A 141      60.205  21.771 -26.162  1.00  0.00           H  
ATOM   2181  HA3 GLY A 141      60.178  20.743 -27.587  1.00  0.00           H  
ATOM   2182  N   TYR A 142      59.399  22.919 -28.661  1.00  0.00           N  
ATOM   2183  CA  TYR A 142      58.754  23.954 -29.460  1.00  0.00           C  
ATOM   2184  C   TYR A 142      59.321  23.982 -30.876  1.00  0.00           C  
ATOM   2185  O   TYR A 142      60.446  23.541 -31.116  1.00  0.00           O  
ATOM   2186  CB  TYR A 142      58.934  25.323 -28.799  1.00  0.00           C  
ATOM   2187  CG  TYR A 142      60.292  25.939 -29.044  1.00  0.00           C  
ATOM   2188  CD1 TYR A 142      61.438  25.384 -28.488  1.00  0.00           C  
ATOM   2189  CD2 TYR A 142      60.430  27.076 -29.829  1.00  0.00           C  
ATOM   2190  CE1 TYR A 142      62.682  25.945 -28.707  1.00  0.00           C  
ATOM   2191  CE2 TYR A 142      61.670  27.643 -30.055  1.00  0.00           C  
ATOM   2192  CZ  TYR A 142      62.792  27.073 -29.492  1.00  0.00           C  
ATOM   2193  OH  TYR A 142      64.029  27.635 -29.714  1.00  0.00           O  
ATOM   2194  H   TYR A 142      60.311  22.639 -28.887  1.00  0.00           H  
ATOM   2195  HA  TYR A 142      57.700  23.725 -29.511  1.00  0.00           H  
ATOM   2196  HB2 TYR A 142      58.188  26.001 -29.185  1.00  0.00           H  
ATOM   2197  HB3 TYR A 142      58.802  25.220 -27.733  1.00  0.00           H  
ATOM   2198  HD1 TYR A 142      61.349  24.500 -27.874  1.00  0.00           H  
ATOM   2199  HD2 TYR A 142      59.548  27.521 -30.268  1.00  0.00           H  
ATOM   2200  HE1 TYR A 142      63.562  25.499 -28.266  1.00  0.00           H  
ATOM   2201  HE2 TYR A 142      61.756  28.527 -30.669  1.00  0.00           H  
ATOM   2202  HH  TYR A 142      64.709  26.965 -29.606  1.00  0.00           H  
ATOM   2203  N   THR A 143      58.535  24.505 -31.811  1.00  0.00           N  
ATOM   2204  CA  THR A 143      58.957  24.591 -33.204  1.00  0.00           C  
ATOM   2205  C   THR A 143      59.841  25.811 -33.436  1.00  0.00           C  
ATOM   2206  O   THR A 143      59.798  26.776 -32.672  1.00  0.00           O  
ATOM   2207  CB  THR A 143      57.746  24.661 -34.154  1.00  0.00           C  
ATOM   2208  OG1 THR A 143      58.191  24.697 -35.514  1.00  0.00           O  
ATOM   2209  CG2 THR A 143      56.897  25.889 -33.860  1.00  0.00           C  
ATOM   2210  H   THR A 143      57.649  24.840 -31.558  1.00  0.00           H  
ATOM   2211  HA  THR A 143      59.519  23.700 -33.438  1.00  0.00           H  
ATOM   2212  HB  THR A 143      57.140  23.778 -34.005  1.00  0.00           H  
ATOM   2213  HG1 THR A 143      58.885  24.046 -35.641  1.00  0.00           H  
ATOM   2214 HG21 THR A 143      56.743  25.973 -32.795  1.00  0.00           H  
ATOM   2215 HG22 THR A 143      55.942  25.794 -34.355  1.00  0.00           H  
ATOM   2216 HG23 THR A 143      57.404  26.771 -34.222  1.00  0.00           H  
ATOM   2217  N   VAL A 144      60.642  25.762 -34.495  1.00  0.00           N  
ATOM   2218  CA  VAL A 144      61.536  26.864 -34.830  1.00  0.00           C  
ATOM   2219  C   VAL A 144      60.979  27.693 -35.982  1.00  0.00           C  
ATOM   2220  O   VAL A 144      60.451  27.150 -36.952  1.00  0.00           O  
ATOM   2221  CB  VAL A 144      62.938  26.353 -35.210  1.00  0.00           C  
ATOM   2222  CG1 VAL A 144      62.895  25.610 -36.536  1.00  0.00           C  
ATOM   2223  CG2 VAL A 144      63.928  27.507 -35.268  1.00  0.00           C  
ATOM   2224  H   VAL A 144      60.631  24.966 -35.067  1.00  0.00           H  
ATOM   2225  HA  VAL A 144      61.629  27.494 -33.957  1.00  0.00           H  
ATOM   2226  HB  VAL A 144      63.268  25.663 -34.446  1.00  0.00           H  
ATOM   2227 HG11 VAL A 144      63.239  26.263 -37.325  1.00  0.00           H  
ATOM   2228 HG12 VAL A 144      63.535  24.740 -36.483  1.00  0.00           H  
ATOM   2229 HG13 VAL A 144      61.882  25.301 -36.742  1.00  0.00           H  
ATOM   2230 HG21 VAL A 144      63.467  28.397 -34.865  1.00  0.00           H  
ATOM   2231 HG22 VAL A 144      64.803  27.260 -34.687  1.00  0.00           H  
ATOM   2232 HG23 VAL A 144      64.216  27.685 -36.294  1.00  0.00           H  
ATOM   2233  N   SER A 145      61.104  29.011 -35.869  1.00  0.00           N  
ATOM   2234  CA  SER A 145      60.610  29.917 -36.900  1.00  0.00           C  
ATOM   2235  C   SER A 145      61.583  29.986 -38.073  1.00  0.00           C  
ATOM   2236  O   SER A 145      62.634  29.345 -38.060  1.00  0.00           O  
ATOM   2237  CB  SER A 145      60.393  31.315 -36.319  1.00  0.00           C  
ATOM   2238  OG  SER A 145      59.380  32.010 -37.026  1.00  0.00           O  
ATOM   2239  H   SER A 145      61.535  29.384 -35.072  1.00  0.00           H  
ATOM   2240  HA  SER A 145      59.665  29.533 -37.254  1.00  0.00           H  
ATOM   2241  HB2 SER A 145      60.099  31.231 -35.285  1.00  0.00           H  
ATOM   2242  HB3 SER A 145      61.314  31.877 -36.388  1.00  0.00           H  
ATOM   2243  HG  SER A 145      59.578  32.950 -37.027  1.00  0.00           H  
ATOM   2244  N   SER A 146      61.224  30.768 -39.086  1.00  0.00           N  
ATOM   2245  CA  SER A 146      62.062  30.919 -40.270  1.00  0.00           C  
ATOM   2246  C   SER A 146      63.399  31.562 -39.910  1.00  0.00           C  
ATOM   2247  O   SER A 146      63.655  31.802 -38.731  1.00  0.00           O  
ATOM   2248  CB  SER A 146      61.345  31.763 -41.325  1.00  0.00           C  
ATOM   2249  OG  SER A 146      60.552  30.951 -42.174  1.00  0.00           O  
ATOM   2250  H   SER A 146      60.374  31.253 -39.037  1.00  0.00           H  
ATOM   2251  HA  SER A 146      62.247  29.935 -40.672  1.00  0.00           H  
ATOM   2252  HB2 SER A 146      60.706  32.481 -40.834  1.00  0.00           H  
ATOM   2253  HB3 SER A 146      62.077  32.284 -41.925  1.00  0.00           H  
ATOM   2254  HG  SER A 146      60.907  30.979 -43.065  1.00  0.00           H  
TER    2255      SER A 146                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
