
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  141 ( 1153),  selected  141 , name 3d9k_B
# Molecule2: number of CA atoms  200 ( 1623),  selected  200 , name T0443.pdb
# PARAMETERS: 3d9k_B.T0443.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L      31           -
LGA    -       -      N      32           -
LGA    -       -      V      33           -
LGA    -       -      Y      34           -
LGA    -       -      I      35           -
LGA    -       -      R      36           -
LGA    -       -      L      37           -
LGA    M     1_B      I      38          1.542
LGA    -       -      R      39           -
LGA    E     2_B      N      40          3.323
LGA    A     3_B      N      41          2.164
LGA    V     4_B      I      42          1.748
LGA    K     5_B      H      43          2.117
LGA    T     6_B      S      44          1.120
LGA    F     7_B      F      45          2.029
LGA    N     8_B      I      46          2.912
LGA    S     9_B      D      47          3.821
LGA    E    10_B      R      48          4.439
LGA    -       -      C      49           -
LGA    L    11_B      Y      50          3.063
LGA    Y    12_B      T      51           -
LGA    -       -      E      52           -
LGA    -       -      T      53           -
LGA    S    13_B      R      54          2.100
LGA    L    14_B      Q      55          3.847
LGA    N    15_B      Y      56          2.841
LGA    D    16_B      F      57          2.775
LGA    Y    17_B      D      58           -
LGA    K    18_B      S      59           -
LGA    P    19_B      K      60           -
LGA    P    20_B      E      61           -
LGA    I    21_B      W      62           -
LGA    S    22_B      S      63           -
LGA    K    23_B      R      64           -
LGA    A    24_B      L      65           -
LGA    K    25_B      K      66           -
LGA    M    26_B      E      67           -
LGA    T    27_B      G      68           -
LGA    Q    28_B      F      69           -
LGA    I    29_B      V      70           -
LGA    T    30_B      R      71           -
LGA    K    31_B      D      72           -
LGA    A    32_B      A      73           -
LGA    A    33_B      R      74           -
LGA    I    34_B      A      75           -
LGA    K    35_B      Q      76           -
LGA    A    36_B      T      77           -
LGA    I    37_B      P      78           -
LGA    K    38_B      Y      79          5.005
LGA    F    39_B      F      80          0.803
LGA    Y    40_B      Q      81          1.224
LGA    K    41_B      E      82          1.655
LGA    H    42_B      I      83          2.328
LGA    V    43_B      P      84          2.151
LGA    V    44_B      G      85          1.255
LGA    Q    45_B      E      86          0.729
LGA    S    46_B      F      87          0.754
LGA    V    47_B      L      88          2.085
LGA    E    48_B      Q      89          2.552
LGA    K    49_B      Y      90          2.373
LGA    F    50_B      C      91          2.698
LGA    I    51_B      Q      92          4.190
LGA    Q    52_B      S      93          4.488
LGA    -       -      L      94           -
LGA    K    53_B      P      95          2.240
LGA    C    54_B      L      96          1.994
LGA    K    55_B      S      97          1.752
LGA    P    56_B      D      98          2.472
LGA    E    57_B      G      99          2.451
LGA    Y    58_B      I     100          1.406
LGA    K    59_B      L     101          2.827
LGA    V    60_B      A     102          3.012
LGA    P    61_B      L     103          1.526
LGA    G    62_B      M     104          1.084
LGA    L    63_B      D     105          2.285
LGA    Y    64_B      F     106          1.802
LGA    V    65_B      E     107          0.903
LGA    I    66_B      Y     108          1.942
LGA    D    67_B      T     109          1.982
LGA    S    68_B      Q     110          1.077
LGA    I    69_B      L     111          0.369
LGA    V    70_B      L     112          0.851
LGA    R    71_B      A     113          1.219
LGA    Q    72_B      E     114          1.014
LGA    S    73_B      V     115          0.876
LGA    R    74_B      A     116          2.258
LGA    H    75_B      -       -           -
LGA    Q    76_B      -       -           -
LGA    F    77_B      -       -           -
LGA    G    78_B      Q     117          2.894
LGA    Q    79_B      I     118          2.536
LGA    E    80_B      P     119          5.692
LGA    K    81_B      D     120           -
LGA    -       -      I     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      I     124           -
LGA    -       -      H     125           -
LGA    -       -      Y     126           -
LGA    -       -      S     127           -
LGA    -       -      N     128           -
LGA    -       -      D     129           -
LGA    -       -      S     130           -
LGA    -       -      K     131           -
LGA    -       -      Y     132           -
LGA    -       -      T     133           -
LGA    -       -      P     134           -
LGA    -       -      S     135           -
LGA    -       -      P     136           -
LGA    D    82_B      A     137           #
LGA    V    83_B      A     138           -
LGA    F    84_B      -       -           -
LGA    A    85_B      F     139           #
LGA    P    86_B      I     140           -
LGA    R    87_B      -       -           -
LGA    F    88_B      -       -           -
LGA    S    89_B      -       -           -
LGA    N    90_B      -       -           -
LGA    N    91_B      -       -           -
LGA    I    92_B      -       -           -
LGA    I    93_B      -       -           -
LGA    S    94_B      -       -           -
LGA    T    95_B      -       -           -
LGA    F    96_B      R     141           #
LGA    Q    97_B      Q     142           -
LGA    N    98_B      -       -           -
LGA    L    99_B      -       -           -
LGA    Y   100_B      Y     143          5.694
LGA    R   101_B      R     144           #
LGA    C   102_B      -       -           -
LGA    P   103_B      Y     145          4.858
LGA    -       -      D     146           -
LGA    -       -      V     147           -
LGA    -       -      T     148           -
LGA    -       -      H     149           -
LGA    -       -      D     150           -
LGA    -       -      L     151           -
LGA    -       -      Q     152           -
LGA    G   104_B      E     153          3.787
LGA    D   105_B      A     154          0.949
LGA    D   106_B      -       -           -
LGA    K   107_B      E     155          2.606
LGA    S   108_B      T     156          1.865
LGA    K   109_B      -       -           -
LGA    I   110_B      -       -           -
LGA    V   111_B      -       -           -
LGA    R   112_B      A     157          2.106
LGA    V   113_B      L     158          2.415
LGA    L   114_B      -       -           -
LGA    N   115_B      L     159          4.597
LGA    L   116_B      I     160          4.855
LGA    W   117_B      W     161           #
LGA    -       -      R     162           -
LGA    -       -      N     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      D     166           -
LGA    -       -      D     167           -
LGA    -       -      V     168           -
LGA    -       -      M     169           -
LGA    -       -      Y     170           -
LGA    -       -      Q     171           -
LGA    -       -      T     172           -
LGA    -       -      L     173           -
LGA    -       -      D     174           -
LGA    -       -      G     175           -
LGA    -       -      F     176           -
LGA    -       -      D     177           -
LGA    -       -      M     178           -
LGA    -       -      M     179           -
LGA    -       -      L     180           -
LGA    Q   118_B      L     181          4.183
LGA    K   119_B      E     182           #
LGA    N   120_B      I     183           -
LGA    N   121_B      M     184           -
LGA    V   122_B      -       -           -
LGA    F   123_B      -       -           -
LGA    K   124_B      G     185          5.463
LGA    S   125_B      S     186           #
LGA    E   126_B      S     187           -
LGA    I   127_B      A     188           -
LGA    I   128_B      L     189           -
LGA    Q   129_B      S     190           -
LGA    P   130_B      F     191           -
LGA    L   131_B      D     192           -
LGA    L   132_B      T     193           -
LGA    D   133_B      L     194           -
LGA    M   134_B      A     195           -
LGA    A   135_B      Q     196           -
LGA    A   136_B      T     197           -
LGA    A   137_B      L     198           -
LGA    L   138_B      V     199           -
LGA    E   139_B      E     200           -
LGA    H   140_B      F     201           -
LGA    H   141_B      M     202           -
LGA    -       -      P     203           -
LGA    -       -      K     204           -
LGA    -       -      A     205           -
LGA    -       -      D     206           -
LGA    -       -      N     207           -
LGA    -       -      W     208           -
LGA    -       -      K     209           -
LGA    -       -      N     210           -
LGA    -       -      I     211           -
LGA    -       -      L     212           -
LGA    -       -      L     213           -
LGA    -       -      G     214           -
LGA    -       -      K     215           -
LGA    -       -      W     216           -
LGA    -       -      S     217           -
LGA    -       -      G     218           -
LGA    -       -      W     219           -
LGA    -       -      I     220           -
LGA    -       -      E     221           -
LGA    -       -      Q     222           -
LGA    -       -      R     223           -
LGA    -       -      I     224           -
LGA    -       -      I     225           -
LGA    -       -      I     226           -
LGA    -       -      P     227           -
LGA    -       -      S     228           -
LGA    -       -      L     229           -
LGA    -       -      S     230           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  141  200    5.0     67    2.81     4.48     22.736     2.306

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.966481 * X  +  -0.194629 * Y  +   0.167433 * Z  + -21.758015
  Y_new =  -0.255299 * X  +  -0.659622 * Y  +   0.706910 * Z  +  31.623951
  Z_new =  -0.027143 * X  +  -0.725961 * Y  +  -0.687200 * Z  +  24.252296 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.328773    0.812819  [ DEG:  -133.4289     46.5711 ]
  Theta =   0.027147    3.114446  [ DEG:     1.5554    178.4446 ]
  Phi   =  -0.258254    2.883338  [ DEG:   -14.7969    165.2031 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3d9k_B                                        
REMARK     2: T0443.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3d9k_B.T0443.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  141  200   5.0   67   2.81    4.48  22.736
REMARK  ---------------------------------------------------------- 
MOLECULE 3d9k_B
HEADER    TRANSCRIPTION                           27-MAY-08   3D9K              
TITLE     SNAPSHOTS OF THE RNA PROCESSING FACTOR SCAF8 BOUND TO                 
TITLE    2 DIFFERENT PHOSPHORYLATED FORMS OF THE CARBOXY-TERMINAL               
TITLE    3 DOMAIN OF RNA-POLYMERASE II                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RNA-BINDING PROTEIN 16;                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CTD INTERACTING DOMAIN OF SCAF8, UNP RESIDUES 1-           
COMPND   5 136;                                                                 
COMPND   6 SYNONYM: RNA-BINDING MOTIF PROTEIN 16;                               
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: CTD-PEPTIDE;                                               
COMPND  10 CHAIN: Y, Z;                                                         
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: MAN;                                                
SOURCE   4 GENE: RBM16, KIAA1116;                                               
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-RIL;                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B;                                   
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 SYNTHETIC: YES;                                                      
SOURCE  11 OTHER_DETAILS: PEPTIDE DERIVED FROM THE CONSERVED REPEAT             
SOURCE  12 SEQUENCE IN RNA POLYMERASE II CTD                                    
KEYWDS    SCAF8, RNA POLYMERASE II CTD INTERACTING DOMAIN, ARM                  
KEYWDS   2 REPEATS, PHOSPHO-CTD, PHOSPHOPROTEIN, RNA-BINDING,                   
KEYWDS   3 TRANSCRIPTION                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.BECKER,B.LOLL,A.MEINHART                                            
REVDAT   1   10-JUN-08 3D9K    0                                                
JRNL        AUTH   R.BECKER,B.LOLL,A.MEINHART                                   
JRNL        TITL   SNAPSHOTS OF THE RNA PROCESSING FACTOR SCAF8 BOUND           
JRNL        TITL 2 TO DIFFERENT PHOSPHORYLATED FORMS OF THE                     
JRNL        TITL 3 CARBOXY-TERMINAL DOMAIN OF RNA-POLYMERASE II                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  3D9K A    1   136  UNP    Q9UPN6   RBM16_HUMAN      1    136             
DBREF  3D9K B    1   136  UNP    Q9UPN6   RBM16_HUMAN      1    136             
DBREF  3D9K Y   -6     7  PDB    3D9K     3D9K             1     14             
DBREF  3D9K Z    1    14  PDB    3D9K     3D9K             1     14             
SEQRES   1 A  145  MET GLU ALA VAL LYS THR PHE ASN SER GLU LEU TYR SER          
SEQRES   2 A  145  LEU ASN ASP TYR LYS PRO PRO ILE SER LYS ALA LYS MET          
SEQRES   3 A  145  THR GLN ILE THR LYS ALA ALA ILE LYS ALA ILE LYS PHE          
SEQRES   4 A  145  TYR LYS HIS VAL VAL GLN SER VAL GLU LYS PHE ILE GLN          
SEQRES   5 A  145  LYS CYS LYS PRO GLU TYR LYS VAL PRO GLY LEU TYR VAL          
SEQRES   6 A  145  ILE ASP SER ILE VAL ARG GLN SER ARG HIS GLN PHE GLY          
SEQRES   7 A  145  GLN GLU LYS ASP VAL PHE ALA PRO ARG PHE SER ASN ASN          
SEQRES   8 A  145  ILE ILE SER THR PHE GLN ASN LEU TYR ARG CYS PRO GLY          
SEQRES   9 A  145  ASP ASP LYS SER LYS ILE VAL ARG VAL LEU ASN LEU TRP          
SEQRES  10 A  145  GLN LYS ASN ASN VAL PHE LYS SER GLU ILE ILE GLN PRO          
SEQRES  11 A  145  LEU LEU ASP MET ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  12 A  145  HIS HIS                                                      
SEQRES   1 B  145  MET GLU ALA VAL LYS THR PHE ASN SER GLU LEU TYR SER          
SEQRES   2 B  145  LEU ASN ASP TYR LYS PRO PRO ILE SER LYS ALA LYS MET          
SEQRES   3 B  145  THR GLN ILE THR LYS ALA ALA ILE LYS ALA ILE LYS PHE          
SEQRES   4 B  145  TYR LYS HIS VAL VAL GLN SER VAL GLU LYS PHE ILE GLN          
SEQRES   5 B  145  LYS CYS LYS PRO GLU TYR LYS VAL PRO GLY LEU TYR VAL          
SEQRES   6 B  145  ILE ASP SER ILE VAL ARG GLN SER ARG HIS GLN PHE GLY          
SEQRES   7 B  145  GLN GLU LYS ASP VAL PHE ALA PRO ARG PHE SER ASN ASN          
SEQRES   8 B  145  ILE ILE SER THR PHE GLN ASN LEU TYR ARG CYS PRO GLY          
SEQRES   9 B  145  ASP ASP LYS SER LYS ILE VAL ARG VAL LEU ASN LEU TRP          
SEQRES  10 B  145  GLN LYS ASN ASN VAL PHE LYS SER GLU ILE ILE GLN PRO          
SEQRES  11 B  145  LEU LEU ASP MET ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  12 B  145  HIS HIS                                                      
SEQRES   1 Y   14  TYR SEP PRO THR SEP PRO SER TYR SEP PRO THR SEP PRO          
SEQRES   2 Y   14  SER                                                          
SEQRES   1 Z   14  TYR SEP PRO THR SEP PRO SER TYR SEP PRO THR SEP PRO          
SEQRES   2 Z   14  SER                                                          
HET    SEP  Y   2      10                                                       
HET    SEP  Z   2      10                                                       
HET    SEP  Z   5      10                                                       
HET    SEP  Z   9      10                                                       
HET    SO4  A1001       5                                                       
HET    SO4  A1003       5                                                       
HET    SO4  A1004       5                                                       
HET    SO4  A1008       5                                                       
HET    SO4  A1010       5                                                       
HET    SO4  B1002       5                                                       
HET    SO4  B1007       5                                                       
HET    SO4  B1012       5                                                       
HET    SO4  Z1006       5                                                       
HETNAM     SEP PHOSPHOSERINE                                                    
HETNAM     SO4 SULFATE ION                                                      
HETSYN     SEP PHOSPHONOSERINE                                                  
FORMUL   3  SEP    4(C3 H8 N O6 P)                                              
FORMUL   5  SO4    9(O4 S 2-)                                                   
FORMUL  14  HOH   *83(H2 O)                                                     
CRYST1   56.450   56.450  106.270  90.00  90.00  90.00 P 43          8          
ATOM   1146  N   MET B   1       5.932  12.193  -0.961  1.00 48.92           N  
ATOM   1147  CA  MET B   1       5.221  12.015   0.336  1.00 49.07           C  
ATOM   1148  C   MET B   1       5.017  13.363   1.035  1.00 47.66           C  
ATOM   1149  O   MET B   1       5.353  13.527   2.217  1.00 47.73           O  
ATOM   1150  CB  MET B   1       5.968  11.008   1.225  1.00 49.05           C  
ATOM   1151  CG  MET B   1       6.034   9.590   0.622  1.00 50.34           C  
ATOM   1152  SD  MET B   1       6.687   8.274   1.699  1.00 52.19           S  
ATOM   1153  CE  MET B   1       5.710   8.489   3.177  1.00 49.25           C  
ATOM   1154  N   GLU B   2       4.459  14.316   0.287  1.00 46.21           N  
ATOM   1155  CA  GLU B   2       4.251  15.688   0.765  1.00 45.00           C  
ATOM   1156  C   GLU B   2       3.242  15.747   1.916  1.00 43.70           C  
ATOM   1157  O   GLU B   2       3.485  16.404   2.930  1.00 43.30           O  
ATOM   1158  CB  GLU B   2       3.853  16.623  -0.397  1.00 45.15           C  
ATOM   1159  CG  GLU B   2       3.013  17.844   0.004  1.00 46.15           C  
ATOM   1160  CD  GLU B   2       3.612  19.185  -0.424  1.00 48.57           C  
ATOM   1161  OE1 GLU B   2       4.645  19.211  -1.135  1.00 48.84           O  
ATOM   1162  OE2 GLU B   2       3.037  20.230  -0.033  1.00 49.36           O  
ATOM   1163  N   ALA B   3       2.129  15.038   1.757  1.00 42.27           N  
ATOM   1164  CA  ALA B   3       1.065  15.011   2.761  1.00 40.89           C  
ATOM   1165  C   ALA B   3       1.566  14.624   4.160  1.00 39.94           C  
ATOM   1166  O   ALA B   3       1.148  15.211   5.156  1.00 39.54           O  
ATOM   1167  CB  ALA B   3      -0.053  14.092   2.312  1.00 40.83           C  
ATOM   1168  N   VAL B   4       2.465  13.645   4.222  1.00 39.23           N  
ATOM   1169  CA  VAL B   4       3.065  13.194   5.492  1.00 38.80           C  
ATOM   1170  C   VAL B   4       3.899  14.297   6.150  1.00 38.04           C  
ATOM   1171  O   VAL B   4       3.824  14.501   7.366  1.00 37.87           O  
ATOM   1172  CB  VAL B   4       3.955  11.935   5.294  1.00 39.17           C  
ATOM   1173  CG1 VAL B   4       4.672  11.540   6.601  1.00 38.98           C  
ATOM   1174  CG2 VAL B   4       3.116  10.768   4.787  1.00 38.65           C  
ATOM   1175  N   LYS B   5       4.675  15.010   5.340  1.00 37.31           N  
ATOM   1176  CA  LYS B   5       5.551  16.076   5.836  1.00 36.63           C  
ATOM   1177  C   LYS B   5       4.772  17.255   6.435  1.00 36.37           C  
ATOM   1178  O   LYS B   5       5.246  17.904   7.354  1.00 35.92           O  
ATOM   1179  CB  LYS B   5       6.484  16.550   4.727  1.00 36.62           C  
ATOM   1180  CG  LYS B   5       7.456  15.477   4.252  1.00 36.28           C  
ATOM   1181  CD  LYS B   5       8.453  16.066   3.297  1.00 36.66           C  
ATOM   1182  CE  LYS B   5       9.343  14.994   2.694  1.00 37.53           C  
ATOM   1183  NZ  LYS B   5      10.426  15.615   1.898  1.00 36.78           N  
ATOM   1184  N   THR B   6       3.577  17.515   5.905  1.00 36.19           N  
ATOM   1185  CA  THR B   6       2.681  18.537   6.444  1.00 36.07           C  
ATOM   1186  C   THR B   6       2.081  18.079   7.785  1.00 35.67           C  
ATOM   1187  O   THR B   6       2.020  18.848   8.753  1.00 35.39           O  
ATOM   1188  CB  THR B   6       1.569  18.885   5.417  1.00 36.44           C  
ATOM   1189  OG1 THR B   6       2.173  19.350   4.196  1.00 36.95           O  
ATOM   1190  CG2 THR B   6       0.623  19.945   5.956  1.00 36.51           C  
ATOM   1191  N   PHE B   7       1.655  16.822   7.838  1.00 35.00           N  
ATOM   1192  CA  PHE B   7       1.281  16.209   9.109  1.00 34.47           C  
ATOM   1193  C   PHE B   7       2.411  16.279  10.148  1.00 33.95           C  
ATOM   1194  O   PHE B   7       2.172  16.678  11.275  1.00 34.27           O  
ATOM   1195  CB  PHE B   7       0.799  14.761   8.958  1.00 34.21           C  
ATOM   1196  CG  PHE B   7       0.548  14.104  10.278  1.00 34.33           C  
ATOM   1197  CD1 PHE B   7      -0.497  14.545  11.088  1.00 32.61           C  
ATOM   1198  CD2 PHE B   7       1.397  13.111  10.754  1.00 34.08           C  
ATOM   1199  CE1 PHE B   7      -0.716  13.977  12.338  1.00 33.16           C  
ATOM   1200  CE2 PHE B   7       1.185  12.543  12.004  1.00 34.60           C  
ATOM   1201  CZ  PHE B   7       0.132  12.997  12.801  1.00 33.84           C  
ATOM   1202  N   ASN B   8       3.622  15.893   9.752  1.00 33.33           N  
ATOM   1203  CA  ASN B   8       4.802  15.889  10.616  1.00 32.75           C  
ATOM   1204  C   ASN B   8       5.077  17.261  11.225  1.00 32.83           C  
ATOM   1205  O   ASN B   8       5.369  17.372  12.416  1.00 32.52           O  
ATOM   1206  CB  ASN B   8       6.029  15.422   9.822  1.00 32.98           C  
ATOM   1207  CG  ASN B   8       6.153  13.908   9.756  1.00 33.55           C  
ATOM   1208  OD1 ASN B   8       5.528  13.188  10.533  1.00 35.51           O  
ATOM   1209  ND2 ASN B   8       6.993  13.422   8.853  1.00 34.03           N  
ATOM   1210  N   SER B   9       4.992  18.296  10.386  1.00 32.37           N  
ATOM   1211  CA  SER B   9       5.031  19.675  10.831  1.00 32.35           C  
ATOM   1212  C   SER B   9       3.953  20.025  11.893  1.00 32.50           C  
ATOM   1213  O   SER B   9       4.270  20.628  12.916  1.00 32.08           O  
ATOM   1214  CB  SER B   9       4.953  20.612   9.619  1.00 32.39           C  
ATOM   1215  OG  SER B   9       6.167  20.562   8.878  1.00 30.69           O  
ATOM   1216  N   GLU B  10       2.702  19.640  11.649  1.00 32.48           N  
ATOM   1217  CA  GLU B  10       1.590  19.953  12.552  1.00 33.04           C  
ATOM   1218  C   GLU B  10       1.774  19.260  13.891  1.00 33.07           C  
ATOM   1219  O   GLU B  10       1.663  19.896  14.945  1.00 32.88           O  
ATOM   1220  CB  GLU B  10       0.244  19.538  11.950  1.00 33.36           C  
ATOM   1221  CG  GLU B  10      -0.285  20.503  10.894  1.00 34.88           C  
ATOM   1222  CD  GLU B  10      -0.461  21.926  11.410  1.00 35.80           C  
ATOM   1223  OE1 GLU B  10      -0.749  22.128  12.609  1.00 39.37           O  
ATOM   1224  OE2 GLU B  10      -0.300  22.852  10.611  1.00 35.59           O  
ATOM   1225  N   LEU B  11       2.090  17.969  13.817  1.00 32.12           N  
ATOM   1226  CA  LEU B  11       2.353  17.136  14.979  1.00 32.24           C  
ATOM   1227  C   LEU B  11       3.465  17.717  15.830  1.00 31.97           C  
ATOM   1228  O   LEU B  11       3.255  17.995  17.010  1.00 32.37           O  
ATOM   1229  CB  LEU B  11       2.723  15.711  14.531  1.00 32.55           C  
ATOM   1230  CG  LEU B  11       2.943  14.657  15.624  1.00 33.21           C  
ATOM   1231  CD1 LEU B  11       1.771  14.594  16.650  1.00 31.39           C  
ATOM   1232  CD2 LEU B  11       3.177  13.303  14.984  1.00 31.85           C  
ATOM   1233  N   TYR B  12       4.629  17.932  15.220  1.00 31.68           N  
ATOM   1234  CA  TYR B  12       5.800  18.477  15.933  1.00 32.09           C  
ATOM   1235  C   TYR B  12       5.570  19.869  16.537  1.00 31.68           C  
ATOM   1236  O   TYR B  12       6.174  20.207  17.544  1.00 31.68           O  
ATOM   1237  CB  TYR B  12       7.068  18.479  15.040  1.00 32.17           C  
ATOM   1238  CG  TYR B  12       8.335  18.558  15.850  1.00 32.82           C  
ATOM   1239  CD1 TYR B  12       8.917  19.793  16.161  1.00 32.17           C  
ATOM   1240  CD2 TYR B  12       8.924  17.407  16.372  1.00 33.73           C  
ATOM   1241  CE1 TYR B  12      10.051  19.873  16.948  1.00 31.07           C  
ATOM   1242  CE2 TYR B  12      10.078  17.487  17.167  1.00 32.23           C  
ATOM   1243  CZ  TYR B  12      10.629  18.721  17.444  1.00 32.16           C  
ATOM   1244  OH  TYR B  12      11.782  18.819  18.214  1.00 35.12           O  
ATOM   1245  N   SER B  13       4.685  20.656  15.932  1.00 31.74           N  
ATOM   1246  CA  SER B  13       4.420  22.019  16.388  1.00 32.15           C  
ATOM   1247  C   SER B  13       3.720  22.076  17.754  1.00 31.95           C  
ATOM   1248  O   SER B  13       3.590  23.153  18.324  1.00 32.04           O  
ATOM   1249  CB  SER B  13       3.621  22.809  15.342  1.00 32.13           C  
ATOM   1250  OG  SER B  13       2.248  22.422  15.361  1.00 35.41           O  
ATOM   1251  N   LEU B  14       3.284  20.923  18.266  1.00 32.24           N  
ATOM   1252  CA  LEU B  14       2.835  20.774  19.659  1.00 32.88           C  
ATOM   1253  C   LEU B  14       3.881  21.266  20.652  1.00 32.96           C  
ATOM   1254  O   LEU B  14       3.534  21.830  21.693  1.00 33.64           O  
ATOM   1255  CB  LEU B  14       2.509  19.312  19.988  1.00 32.63           C  
ATOM   1256  CG  LEU B  14       1.173  18.713  19.532  1.00 34.26           C  
ATOM   1257  CD1 LEU B  14       1.121  17.251  19.906  1.00 34.11           C  
ATOM   1258  CD2 LEU B  14      -0.027  19.464  20.116  1.00 32.67           C  
ATOM   1259  N   ASN B  15       5.153  21.025  20.328  1.00 33.11           N  
ATOM   1260  CA  ASN B  15       6.300  21.516  21.100  1.00 32.94           C  
ATOM   1261  C   ASN B  15       6.393  23.047  21.223  1.00 33.17           C  
ATOM   1262  O   ASN B  15       7.146  23.563  22.053  1.00 32.87           O  
ATOM   1263  CB  ASN B  15       7.604  20.956  20.512  1.00 32.68           C  
ATOM   1264  CG  ASN B  15       7.772  19.455  20.750  1.00 33.12           C  
ATOM   1265  OD1 ASN B  15       7.714  18.983  21.879  1.00 35.56           O  
ATOM   1266  ND2 ASN B  15       8.003  18.710  19.684  1.00 32.96           N  
ATOM   1267  N   ASP B  16       5.657  23.767  20.377  1.00 33.80           N  
ATOM   1268  CA  ASP B  16       5.643  25.236  20.417  1.00 34.13           C  
ATOM   1269  C   ASP B  16       4.565  25.759  21.370  1.00 34.73           C  
ATOM   1270  O   ASP B  16       4.450  26.957  21.581  1.00 34.73           O  
ATOM   1271  CB  ASP B  16       5.403  25.824  19.029  1.00 34.12           C  
ATOM   1272  CG  ASP B  16       6.512  25.499  18.045  1.00 34.29           C  
ATOM   1273  OD1 ASP B  16       7.664  25.875  18.298  1.00 35.24           O  
ATOM   1274  OD2 ASP B  16       6.221  24.878  17.001  1.00 36.37           O  
ATOM   1275  N   TYR B  17       3.776  24.847  21.935  1.00 35.87           N  
ATOM   1276  CA  TYR B  17       2.642  25.200  22.794  1.00 36.43           C  
ATOM   1277  C   TYR B  17       2.757  24.529  24.156  1.00 36.42           C  
ATOM   1278  O   TYR B  17       3.154  23.375  24.261  1.00 36.70           O  
ATOM   1279  CB  TYR B  17       1.312  24.814  22.117  1.00 36.69           C  
ATOM   1280  CG  TYR B  17       1.048  25.549  20.816  1.00 36.88           C  
ATOM   1281  CD1 TYR B  17       0.462  26.816  20.813  1.00 37.95           C  
ATOM   1282  CD2 TYR B  17       1.405  24.986  19.593  1.00 38.02           C  
ATOM   1283  CE1 TYR B  17       0.231  27.501  19.620  1.00 38.14           C  
ATOM   1284  CE2 TYR B  17       1.179  25.655  18.392  1.00 37.30           C  
ATOM   1285  CZ  TYR B  17       0.590  26.912  18.417  1.00 38.37           C  
ATOM   1286  OH  TYR B  17       0.359  27.582  17.241  1.00 38.08           O  
ATOM   1287  N   LYS B  18       2.404  25.261  25.198  1.00 36.43           N  
ATOM   1288  CA  LYS B  18       2.375  24.706  26.535  1.00 36.73           C  
ATOM   1289  C   LYS B  18       1.024  24.031  26.694  1.00 36.96           C  
ATOM   1290  O   LYS B  18      -0.006  24.653  26.427  1.00 37.45           O  
ATOM   1291  CB  LYS B  18       2.573  25.825  27.568  1.00 36.67           C  
ATOM   1292  CG  LYS B  18       2.499  25.411  29.036  1.00 36.86           C  
ATOM   1293  CD  LYS B  18       2.835  26.605  29.920  1.00 36.40           C  
ATOM   1294  CE  LYS B  18       2.192  26.482  31.318  1.00 35.83           C  
ATOM   1295  NZ  LYS B  18       2.683  27.714  32.158  1.00 34.71           N  
ATOM   1296  N   PRO B  19       1.017  22.740  27.074  1.00 36.98           N  
ATOM   1297  CA  PRO B  19      -0.251  22.089  27.405  1.00 37.14           C  
ATOM   1298  C   PRO B  19      -0.971  22.828  28.547  1.00 37.06           C  
ATOM   1299  O   PRO B  19      -0.305  23.390  29.430  1.00 37.22           O  
ATOM   1300  CB  PRO B  19       0.187  20.691  27.837  1.00 37.20           C  
ATOM   1301  CG  PRO B  19       1.469  20.469  27.102  1.00 36.62           C  
ATOM   1302  CD  PRO B  19       2.150  21.803  27.178  1.00 36.88           C  
ATOM   1303  N   PRO B  20      -2.321  22.841  28.538  1.00 37.14           N  
ATOM   1304  CA  PRO B  20      -3.277  22.148  27.660  1.00 37.07           C  
ATOM   1305  C   PRO B  20      -3.300  22.657  26.220  1.00 37.00           C  
ATOM   1306  O   PRO B  20      -3.269  23.867  25.978  1.00 36.72           O  
ATOM   1307  CB  PRO B  20      -4.629  22.417  28.331  1.00 37.02           C  
ATOM   1308  CG  PRO B  20      -4.434  23.693  29.069  1.00 37.44           C  
ATOM   1309  CD  PRO B  20      -3.016  23.672  29.550  1.00 37.25           C  
ATOM   1310  N   ILE B  21      -3.359  21.725  25.274  1.00 37.23           N  
ATOM   1311  CA  ILE B  21      -3.414  22.060  23.853  1.00 37.43           C  
ATOM   1312  C   ILE B  21      -4.833  22.458  23.459  1.00 38.26           C  
ATOM   1313  O   ILE B  21      -5.808  21.847  23.908  1.00 38.57           O  
ATOM   1314  CB  ILE B  21      -2.868  20.898  22.977  1.00 37.59           C  
ATOM   1315  CG1 ILE B  21      -1.439  20.509  23.423  1.00 36.82           C  
ATOM   1316  CG2 ILE B  21      -2.924  21.246  21.481  1.00 37.45           C  
ATOM   1317  CD1 ILE B  21      -0.386  21.630  23.287  1.00 35.95           C  
ATOM   1318  N   SER B  22      -4.936  23.497  22.635  1.00 38.85           N  
ATOM   1319  CA  SER B  22      -6.218  24.051  22.204  1.00 39.34           C  
ATOM   1320  C   SER B  22      -6.955  23.145  21.215  1.00 39.30           C  
ATOM   1321  O   SER B  22      -6.333  22.380  20.480  1.00 39.77           O  
ATOM   1322  CB  SER B  22      -6.004  25.435  21.580  1.00 39.20           C  
ATOM   1323  OG  SER B  22      -5.361  25.316  20.318  1.00 40.02           O  
ATOM   1324  N   LYS B  23      -8.286  23.236  21.224  1.00 39.43           N  
ATOM   1325  CA  LYS B  23      -9.166  22.588  20.242  1.00 39.22           C  
ATOM   1326  C   LYS B  23      -8.708  22.901  18.814  1.00 38.83           C  
ATOM   1327  O   LYS B  23      -8.631  22.002  17.960  1.00 38.01           O  
ATOM   1328  CB  LYS B  23     -10.615  23.065  20.460  1.00 39.56           C  
ATOM   1329  CG  LYS B  23     -11.580  22.854  19.284  1.00 39.80           C  
ATOM   1330  CD  LYS B  23     -12.931  23.528  19.544  1.00 40.00           C  
ATOM   1331  CE  LYS B  23     -13.816  23.554  18.296  1.00 40.73           C  
ATOM   1332  NZ  LYS B  23     -14.991  24.498  18.448  1.00 40.84           N  
ATOM   1333  N   ALA B  24      -8.382  24.175  18.583  1.00 38.31           N  
ATOM   1334  CA  ALA B  24      -7.953  24.666  17.276  1.00 38.26           C  
ATOM   1335  C   ALA B  24      -6.663  23.998  16.784  1.00 38.31           C  
ATOM   1336  O   ALA B  24      -6.572  23.605  15.620  1.00 38.45           O  
ATOM   1337  CB  ALA B  24      -7.802  26.166  17.297  1.00 38.09           C  
ATOM   1338  N   LYS B  25      -5.674  23.858  17.662  1.00 38.24           N  
ATOM   1339  CA  LYS B  25      -4.408  23.252  17.262  1.00 37.97           C  
ATOM   1340  C   LYS B  25      -4.606  21.758  17.040  1.00 37.82           C  
ATOM   1341  O   LYS B  25      -4.053  21.190  16.105  1.00 37.49           O  
ATOM   1342  CB  LYS B  25      -3.289  23.581  18.264  1.00 37.90           C  
ATOM   1343  CG  LYS B  25      -1.968  22.779  18.139  1.00 39.43           C  
ATOM   1344  CD  LYS B  25      -1.404  22.642  16.725  1.00 40.39           C  
ATOM   1345  CE  LYS B  25      -0.785  23.906  16.190  1.00 42.98           C  
ATOM   1346  NZ  LYS B  25      -0.187  23.656  14.827  1.00 44.69           N  
ATOM   1347  N   MET B  26      -5.434  21.141  17.873  1.00 37.74           N  
ATOM   1348  CA  MET B  26      -5.751  19.720  17.721  1.00 37.75           C  
ATOM   1349  C   MET B  26      -6.434  19.415  16.390  1.00 37.35           C  
ATOM   1350  O   MET B  26      -6.123  18.407  15.733  1.00 37.40           O  
ATOM   1351  CB  MET B  26      -6.599  19.231  18.895  1.00 37.99           C  
ATOM   1352  CG  MET B  26      -6.514  17.729  19.117  1.00 40.00           C  
ATOM   1353  SD  MET B  26      -4.832  17.098  19.223  1.00 45.23           S  
ATOM   1354  CE  MET B  26      -4.239  17.739  20.769  1.00 39.35           C  
ATOM   1355  N   THR B  27      -7.349  20.297  16.007  1.00 36.89           N  
ATOM   1356  CA  THR B  27      -8.056  20.256  14.728  1.00 36.98           C  
ATOM   1357  C   THR B  27      -7.096  20.319  13.525  1.00 37.07           C  
ATOM   1358  O   THR B  27      -7.233  19.527  12.594  1.00 37.14           O  
ATOM   1359  CB  THR B  27      -9.110  21.393  14.670  1.00 36.98           C  
ATOM   1360  OG1 THR B  27     -10.122  21.151  15.663  1.00 37.62           O  
ATOM   1361  CG2 THR B  27      -9.773  21.476  13.324  1.00 36.71           C  
ATOM   1362  N   GLN B  28      -6.129  21.242  13.568  1.00 37.06           N  
ATOM   1363  CA  GLN B  28      -5.100  21.405  12.527  1.00 37.00           C  
ATOM   1364  C   GLN B  28      -4.288  20.131  12.323  1.00 36.23           C  
ATOM   1365  O   GLN B  28      -4.058  19.696  11.178  1.00 35.19           O  
ATOM   1366  CB  GLN B  28      -4.142  22.566  12.866  1.00 36.83           C  
ATOM   1367  CG  GLN B  28      -4.660  23.982  12.563  1.00 38.28           C  
ATOM   1368  CD  GLN B  28      -3.670  25.068  12.975  1.00 39.48           C  
ATOM   1369  OE1 GLN B  28      -3.121  25.045  14.089  1.00 44.33           O  
ATOM   1370  NE2 GLN B  28      -3.434  26.022  12.082  1.00 39.95           N  
ATOM   1371  N   ILE B  29      -3.849  19.544  13.442  1.00 35.66           N  
ATOM   1372  CA  ILE B  29      -3.108  18.278  13.427  1.00 34.47           C  
ATOM   1373  C   ILE B  29      -3.963  17.200  12.774  1.00 34.38           C  
ATOM   1374  O   ILE B  29      -3.501  16.470  11.891  1.00 34.77           O  
ATOM   1375  CB  ILE B  29      -2.638  17.867  14.865  1.00 34.32           C  
ATOM   1376  CG1 ILE B  29      -1.698  18.930  15.439  1.00 34.46           C  
ATOM   1377  CG2 ILE B  29      -1.932  16.519  14.874  1.00 32.73           C  
ATOM   1378  CD1 ILE B  29      -1.455  18.775  16.926  1.00 34.26           C  
ATOM   1379  N   THR B  30      -5.211  17.112  13.202  1.00 34.50           N  
ATOM   1380  CA  THR B  30      -6.150  16.094  12.709  1.00 34.86           C  
ATOM   1381  C   THR B  30      -6.506  16.280  11.221  1.00 33.96           C  
ATOM   1382  O   THR B  30      -6.504  15.310  10.448  1.00 33.56           O  
ATOM   1383  CB  THR B  30      -7.414  16.062  13.588  1.00 35.04           C  
ATOM   1384  OG1 THR B  30      -7.026  15.863  14.960  1.00 38.25           O  
ATOM   1385  CG2 THR B  30      -8.343  14.932  13.163  1.00 36.00           C  
ATOM   1386  N   LYS B  31      -6.801  17.518  10.831  1.00 33.11           N  
ATOM   1387  CA  LYS B  31      -6.986  17.853   9.422  1.00 33.46           C  
ATOM   1388  C   LYS B  31      -5.823  17.381   8.562  1.00 32.57           C  
ATOM   1389  O   LYS B  31      -6.041  16.804   7.503  1.00 33.29           O  
ATOM   1390  CB  LYS B  31      -7.237  19.355   9.231  1.00 33.78           C  
ATOM   1391  CG  LYS B  31      -8.704  19.719   9.403  1.00 35.18           C  
ATOM   1392  CD  LYS B  31      -8.896  21.190   9.684  1.00 38.32           C  
ATOM   1393  CE  LYS B  31     -10.308  21.441  10.230  1.00 40.29           C  
ATOM   1394  NZ  LYS B  31     -11.359  21.523   9.186  1.00 42.51           N  
ATOM   1395  N   ALA B  32      -4.601  17.599   9.042  1.00 31.59           N  
ATOM   1396  CA  ALA B  32      -3.382  17.189   8.352  1.00 30.71           C  
ATOM   1397  C   ALA B  32      -3.227  15.666   8.240  1.00 30.62           C  
ATOM   1398  O   ALA B  32      -2.810  15.162   7.200  1.00 30.69           O  
ATOM   1399  CB  ALA B  32      -2.167  17.798   9.045  1.00 29.99           C  
ATOM   1400  N   ALA B  33      -3.548  14.939   9.311  1.00 30.28           N  
ATOM   1401  CA  ALA B  33      -3.483  13.489   9.299  1.00 30.81           C  
ATOM   1402  C   ALA B  33      -4.477  12.878   8.315  1.00 31.00           C  
ATOM   1403  O   ALA B  33      -4.150  11.896   7.640  1.00 31.34           O  
ATOM   1404  CB  ALA B  33      -3.726  12.916  10.715  1.00 30.40           C  
ATOM   1405  N   ILE B  34      -5.689  13.436   8.260  1.00 31.59           N  
ATOM   1406  CA  ILE B  34      -6.737  12.956   7.326  1.00 32.07           C  
ATOM   1407  C   ILE B  34      -6.305  13.190   5.872  1.00 32.27           C  
ATOM   1408  O   ILE B  34      -6.438  12.307   5.019  1.00 32.26           O  
ATOM   1409  CB  ILE B  34      -8.132  13.624   7.581  1.00 32.02           C  
ATOM   1410  CG1 ILE B  34      -8.647  13.368   9.016  1.00 32.28           C  
ATOM   1411  CG2 ILE B  34      -9.163  13.161   6.533  1.00 31.45           C  
ATOM   1412  CD1 ILE B  34      -9.100  11.942   9.326  1.00 31.33           C  
ATOM   1413  N   LYS B  35      -5.768  14.379   5.604  1.00 33.07           N  
ATOM   1414  CA  LYS B  35      -5.279  14.726   4.264  1.00 33.88           C  
ATOM   1415  C   LYS B  35      -4.162  13.772   3.800  1.00 33.99           C  
ATOM   1416  O   LYS B  35      -3.971  13.554   2.596  1.00 34.50           O  
ATOM   1417  CB  LYS B  35      -4.833  16.192   4.216  1.00 33.48           C  
ATOM   1418  CG  LYS B  35      -6.009  17.167   4.279  1.00 34.96           C  
ATOM   1419  CD  LYS B  35      -5.574  18.639   4.269  1.00 35.40           C  
ATOM   1420  CE  LYS B  35      -6.794  19.520   4.542  1.00 39.54           C  
ATOM   1421  NZ  LYS B  35      -6.458  20.932   4.923  1.00 42.51           N  
ATOM   1422  N   ALA B  36      -3.477  13.167   4.770  1.00 33.86           N  
ATOM   1423  CA  ALA B  36      -2.392  12.216   4.514  1.00 33.86           C  
ATOM   1424  C   ALA B  36      -2.822  10.747   4.589  1.00 33.85           C  
ATOM   1425  O   ALA B  36      -1.984   9.862   4.776  1.00 34.14           O  
ATOM   1426  CB  ALA B  36      -1.213  12.496   5.496  1.00 33.24           C  
ATOM   1427  N   ILE B  37      -4.117  10.481   4.430  1.00 33.77           N  
ATOM   1428  CA  ILE B  37      -4.656   9.129   4.596  1.00 34.27           C  
ATOM   1429  C   ILE B  37      -4.084   8.036   3.658  1.00 34.56           C  
ATOM   1430  O   ILE B  37      -4.085   6.853   4.017  1.00 34.30           O  
ATOM   1431  CB  ILE B  37      -6.208   9.130   4.626  1.00 34.23           C  
ATOM   1432  CG1 ILE B  37      -6.738   7.795   5.174  1.00 35.68           C  
ATOM   1433  CG2 ILE B  37      -6.792   9.432   3.244  1.00 35.02           C  
ATOM   1434  CD1 ILE B  37      -7.980   7.931   6.032  1.00 36.81           C  
ATOM   1435  N   LYS B  38      -3.605   8.417   2.471  1.00 34.66           N  
ATOM   1436  CA  LYS B  38      -2.865   7.483   1.602  1.00 35.23           C  
ATOM   1437  C   LYS B  38      -1.630   6.927   2.334  1.00 35.49           C  
ATOM   1438  O   LYS B  38      -1.222   5.789   2.098  1.00 36.01           O  
ATOM   1439  CB  LYS B  38      -2.445   8.166   0.286  1.00 34.98           C  
ATOM   1440  CG  LYS B  38      -1.563   7.324  -0.638  1.00 35.40           C  
ATOM   1441  CD  LYS B  38      -0.857   8.194  -1.708  1.00 35.21           C  
ATOM   1442  CE  LYS B  38      -0.089   7.343  -2.734  1.00 35.39           C  
ATOM   1443  NZ  LYS B  38       0.603   8.168  -3.782  1.00 34.95           N  
ATOM   1444  N   PHE B  39      -1.045   7.737   3.214  1.00 35.25           N  
ATOM   1445  CA  PHE B  39       0.097   7.310   4.012  1.00 35.33           C  
ATOM   1446  C   PHE B  39      -0.252   7.164   5.502  1.00 35.41           C  
ATOM   1447  O   PHE B  39       0.528   7.572   6.376  1.00 35.52           O  
ATOM   1448  CB  PHE B  39       1.243   8.292   3.846  1.00 35.05           C  
ATOM   1449  CG  PHE B  39       1.585   8.611   2.406  1.00 35.96           C  
ATOM   1450  CD1 PHE B  39       2.309   7.709   1.629  1.00 35.88           C  
ATOM   1451  CD2 PHE B  39       1.204   9.830   1.841  1.00 36.36           C  
ATOM   1452  CE1 PHE B  39       2.645   8.008   0.296  1.00 36.15           C  
ATOM   1453  CE2 PHE B  39       1.532  10.143   0.515  1.00 36.73           C  
ATOM   1454  CZ  PHE B  39       2.255   9.230  -0.257  1.00 36.09           C  
ATOM   1455  N   TYR B  40      -1.416   6.578   5.785  1.00 34.80           N  
ATOM   1456  CA  TYR B  40      -1.903   6.453   7.157  1.00 34.55           C  
ATOM   1457  C   TYR B  40      -0.931   5.688   8.055  1.00 33.67           C  
ATOM   1458  O   TYR B  40      -0.822   5.982   9.237  1.00 33.65           O  
ATOM   1459  CB  TYR B  40      -3.305   5.823   7.193  1.00 35.18           C  
ATOM   1460  CG  TYR B  40      -3.337   4.344   6.881  1.00 35.21           C  
ATOM   1461  CD1 TYR B  40      -3.215   3.396   7.901  1.00 35.94           C  
ATOM   1462  CD2 TYR B  40      -3.495   3.891   5.573  1.00 35.13           C  
ATOM   1463  CE1 TYR B  40      -3.239   2.049   7.622  1.00 36.62           C  
ATOM   1464  CE2 TYR B  40      -3.523   2.534   5.284  1.00 36.39           C  
ATOM   1465  CZ  TYR B  40      -3.399   1.623   6.317  1.00 36.11           C  
ATOM   1466  OH  TYR B  40      -3.421   0.283   6.051  1.00 36.49           O  
ATOM   1467  N   LYS B  41      -0.222   4.724   7.476  1.00 32.77           N  
ATOM   1468  CA  LYS B  41       0.787   3.935   8.199  1.00 32.34           C  
ATOM   1469  C   LYS B  41       1.944   4.817   8.683  1.00 31.99           C  
ATOM   1470  O   LYS B  41       2.451   4.650   9.798  1.00 31.70           O  
ATOM   1471  CB  LYS B  41       1.348   2.826   7.311  1.00 31.48           C  
ATOM   1472  CG  LYS B  41       0.381   1.726   6.946  1.00 32.42           C  
ATOM   1473  CD  LYS B  41       1.099   0.691   6.044  1.00 31.99           C  
ATOM   1474  CE  LYS B  41       0.196  -0.463   5.643  1.00 32.84           C  
ATOM   1475  NZ  LYS B  41       0.748  -1.185   4.432  1.00 32.92           N  
ATOM   1476  N   HIS B  42       2.351   5.747   7.826  1.00 31.80           N  
ATOM   1477  CA  HIS B  42       3.377   6.734   8.152  1.00 32.26           C  
ATOM   1478  C   HIS B  42       2.923   7.734   9.217  1.00 32.22           C  
ATOM   1479  O   HIS B  42       3.697   8.108  10.100  1.00 32.65           O  
ATOM   1480  CB  HIS B  42       3.819   7.427   6.866  1.00 32.55           C  
ATOM   1481  CG  HIS B  42       4.585   6.524   5.944  1.00 34.20           C  
ATOM   1482  ND1 HIS B  42       3.972   5.629   5.087  1.00 36.91           N  
ATOM   1483  CD2 HIS B  42       5.919   6.359   5.769  1.00 36.33           C  
ATOM   1484  CE1 HIS B  42       4.894   4.967   4.409  1.00 37.17           C  
ATOM   1485  NE2 HIS B  42       6.084   5.391   4.802  1.00 37.56           N  
ATOM   1486  N   VAL B  43       1.656   8.134   9.140  1.00 32.09           N  
ATOM   1487  CA  VAL B  43       1.024   8.996  10.148  1.00 32.53           C  
ATOM   1488  C   VAL B  43       1.031   8.309  11.515  1.00 33.09           C  
ATOM   1489  O   VAL B  43       1.505   8.870  12.499  1.00 33.74           O  
ATOM   1490  CB  VAL B  43      -0.423   9.389   9.722  1.00 31.69           C  
ATOM   1491  CG1 VAL B  43      -1.173  10.110  10.840  1.00 33.34           C  
ATOM   1492  CG2 VAL B  43      -0.379  10.264   8.492  1.00 32.75           C  
ATOM   1493  N   VAL B  44       0.553   7.070  11.564  1.00 33.37           N  
ATOM   1494  CA  VAL B  44       0.552   6.314  12.812  1.00 33.68           C  
ATOM   1495  C   VAL B  44       1.979   6.172  13.349  1.00 34.31           C  
ATOM   1496  O   VAL B  44       2.218   6.391  14.536  1.00 35.12           O  
ATOM   1497  CB  VAL B  44      -0.142   4.944  12.647  1.00 33.37           C  
ATOM   1498  CG1 VAL B  44       0.037   4.092  13.898  1.00 34.40           C  
ATOM   1499  CG2 VAL B  44      -1.611   5.137  12.323  1.00 32.86           C  
ATOM   1500  N   GLN B  45       2.916   5.844  12.459  1.00 34.77           N  
ATOM   1501  CA  GLN B  45       4.332   5.766  12.793  1.00 35.29           C  
ATOM   1502  C   GLN B  45       4.903   7.051  13.403  1.00 35.25           C  
ATOM   1503  O   GLN B  45       5.564   6.981  14.434  1.00 35.65           O  
ATOM   1504  CB  GLN B  45       5.146   5.346  11.561  1.00 35.32           C  
ATOM   1505  CG  GLN B  45       6.629   5.283  11.800  1.00 36.35           C  
ATOM   1506  CD  GLN B  45       7.382   4.773  10.593  1.00 39.91           C  
ATOM   1507  OE1 GLN B  45       7.267   5.320   9.496  1.00 43.00           O  
ATOM   1508  NE2 GLN B  45       8.164   3.724  10.789  1.00 39.40           N  
ATOM   1509  N   SER B  46       4.669   8.204  12.759  1.00 35.72           N  
ATOM   1510  CA  SER B  46       5.073   9.530  13.289  1.00 35.14           C  
ATOM   1511  C   SER B  46       4.484   9.832  14.673  1.00 34.95           C  
ATOM   1512  O   SER B  46       5.173  10.330  15.564  1.00 34.10           O  
ATOM   1513  CB  SER B  46       4.628  10.642  12.346  1.00 35.29           C  
ATOM   1514  OG  SER B  46       5.422  10.712  11.189  1.00 36.74           O  
ATOM   1515  N   VAL B  47       3.192   9.558  14.835  1.00 35.25           N  
ATOM   1516  CA  VAL B  47       2.500   9.753  16.134  1.00 34.85           C  
ATOM   1517  C   VAL B  47       3.141   8.888  17.234  1.00 35.23           C  
ATOM   1518  O   VAL B  47       3.423   9.383  18.325  1.00 35.47           O  
ATOM   1519  CB  VAL B  47       0.984   9.460  16.031  1.00 35.03           C  
ATOM   1520  CG1 VAL B  47       0.277   9.570  17.434  1.00 35.27           C  
ATOM   1521  CG2 VAL B  47       0.325  10.400  15.034  1.00 34.16           C  
ATOM   1522  N   GLU B  48       3.373   7.611  16.923  1.00 35.10           N  
ATOM   1523  CA  GLU B  48       3.969   6.654  17.854  1.00 35.68           C  
ATOM   1524  C   GLU B  48       5.392   7.085  18.245  1.00 35.60           C  
ATOM   1525  O   GLU B  48       5.769   6.990  19.410  1.00 35.36           O  
ATOM   1526  CB  GLU B  48       3.959   5.226  17.244  1.00 35.67           C  
ATOM   1527  CG  GLU B  48       2.565   4.563  17.272  1.00 36.40           C  
ATOM   1528  CD  GLU B  48       2.481   3.203  16.552  1.00 36.02           C  
ATOM   1529  OE1 GLU B  48       3.492   2.684  16.044  1.00 36.46           O  
ATOM   1530  OE2 GLU B  48       1.376   2.632  16.509  1.00 35.96           O  
ATOM   1531  N   LYS B  49       6.146   7.570  17.254  1.00 35.66           N  
ATOM   1532  CA  LYS B  49       7.476   8.166  17.426  1.00 36.64           C  
ATOM   1533  C   LYS B  49       7.462   9.416  18.317  1.00 35.66           C  
ATOM   1534  O   LYS B  49       8.275   9.524  19.242  1.00 35.44           O  
ATOM   1535  CB  LYS B  49       8.085   8.465  16.037  1.00 37.11           C  
ATOM   1536  CG  LYS B  49       9.491   9.062  16.003  1.00 38.96           C  
ATOM   1537  CD  LYS B  49       9.764   9.687  14.610  1.00 39.54           C  
ATOM   1538  CE  LYS B  49      11.088  10.456  14.550  1.00 45.12           C  
ATOM   1539  NZ  LYS B  49      11.127  11.617  15.512  1.00 48.14           N  
ATOM   1540  N   PHE B  50       6.539  10.345  18.046  1.00 34.57           N  
ATOM   1541  CA  PHE B  50       6.360  11.534  18.889  1.00 34.16           C  
ATOM   1542  C   PHE B  50       6.135  11.108  20.353  1.00 34.12           C  
ATOM   1543  O   PHE B  50       6.851  11.560  21.244  1.00 33.82           O  
ATOM   1544  CB  PHE B  50       5.188  12.408  18.388  1.00 33.36           C  
ATOM   1545  CG  PHE B  50       4.928  13.627  19.241  1.00 33.91           C  
ATOM   1546  CD1 PHE B  50       5.619  14.822  19.005  1.00 34.27           C  
ATOM   1547  CD2 PHE B  50       4.006  13.585  20.286  1.00 32.48           C  
ATOM   1548  CE1 PHE B  50       5.393  15.950  19.804  1.00 32.24           C  
ATOM   1549  CE2 PHE B  50       3.775  14.699  21.087  1.00 33.57           C  
ATOM   1550  CZ  PHE B  50       4.482  15.889  20.842  1.00 32.98           C  
ATOM   1551  N   ILE B  51       5.150  10.234  20.582  1.00 33.56           N  
ATOM   1552  CA  ILE B  51       4.832   9.730  21.931  1.00 33.76           C  
ATOM   1553  C   ILE B  51       6.025   9.082  22.648  1.00 34.01           C  
ATOM   1554  O   ILE B  51       6.182   9.249  23.848  1.00 34.06           O  
ATOM   1555  CB  ILE B  51       3.610   8.766  21.902  1.00 34.00           C  
ATOM   1556  CG1 ILE B  51       2.302   9.562  21.753  1.00 34.28           C  
ATOM   1557  CG2 ILE B  51       3.577   7.832  23.143  1.00 33.66           C  
ATOM   1558  CD1 ILE B  51       1.108   8.707  21.209  1.00 32.92           C  
ATOM   1559  N   GLN B  52       6.841   8.334  21.909  1.00 34.57           N  
ATOM   1560  CA  GLN B  52       8.037   7.683  22.453  1.00 35.38           C  
ATOM   1561  C   GLN B  52       9.073   8.710  22.891  1.00 35.61           C  
ATOM   1562  O   GLN B  52       9.678   8.561  23.951  1.00 35.76           O  
ATOM   1563  CB  GLN B  52       8.667   6.738  21.405  1.00 35.55           C  
ATOM   1564  CG  GLN B  52       9.836   5.908  21.920  1.00 37.15           C  
ATOM   1565  CD  GLN B  52      10.807   5.489  20.816  1.00 39.43           C  
ATOM   1566  OE1 GLN B  52      10.414   4.890  19.820  1.00 40.20           O  
ATOM   1567  NE2 GLN B  52      12.084   5.811  20.996  1.00 40.18           N  
ATOM   1568  N   LYS B  53       9.264   9.747  22.073  1.00 36.08           N  
ATOM   1569  CA  LYS B  53      10.354  10.721  22.250  1.00 36.60           C  
ATOM   1570  C   LYS B  53      10.002  12.016  23.009  1.00 36.53           C  
ATOM   1571  O   LYS B  53      10.870  12.600  23.655  1.00 36.32           O  
ATOM   1572  CB  LYS B  53      10.978  11.054  20.890  1.00 36.70           C  
ATOM   1573  CG  LYS B  53      11.645   9.852  20.230  1.00 39.46           C  
ATOM   1574  CD  LYS B  53      11.878  10.058  18.742  1.00 42.81           C  
ATOM   1575  CE  LYS B  53      12.501   8.804  18.119  1.00 44.89           C  
ATOM   1576  NZ  LYS B  53      13.071   9.063  16.771  1.00 46.79           N  
ATOM   1577  N   CYS B  54       8.749  12.465  22.927  1.00 36.11           N  
ATOM   1578  CA  CYS B  54       8.339  13.767  23.504  1.00 36.31           C  
ATOM   1579  C   CYS B  54       8.590  13.927  25.016  1.00 36.51           C  
ATOM   1580  O   CYS B  54       8.752  12.939  25.737  1.00 36.49           O  
ATOM   1581  CB  CYS B  54       6.859  14.018  23.214  1.00 36.19           C  
ATOM   1582  SG  CYS B  54       5.740  12.981  24.185  1.00 36.66           S  
ATOM   1583  N   LYS B  55       8.604  15.170  25.497  1.00 36.57           N  
ATOM   1584  CA  LYS B  55       8.658  15.422  26.937  1.00 36.78           C  
ATOM   1585  C   LYS B  55       7.399  14.844  27.611  1.00 36.66           C  
ATOM   1586  O   LYS B  55       6.356  14.724  26.956  1.00 36.87           O  
ATOM   1587  CB  LYS B  55       8.769  16.918  27.244  1.00 37.17           C  
ATOM   1588  CG  LYS B  55       9.700  17.728  26.358  1.00 38.58           C  
ATOM   1589  CD  LYS B  55       9.926  19.091  26.981  1.00 40.11           C  
ATOM   1590  CE  LYS B  55       9.966  20.205  25.944  1.00 41.97           C  
ATOM   1591  NZ  LYS B  55      10.514  21.461  26.575  1.00 41.93           N  
ATOM   1592  N   PRO B  56       7.495  14.454  28.907  1.00 36.53           N  
ATOM   1593  CA  PRO B  56       6.371  13.913  29.696  1.00 36.41           C  
ATOM   1594  C   PRO B  56       5.060  14.714  29.613  1.00 36.20           C  
ATOM   1595  O   PRO B  56       3.991  14.108  29.526  1.00 36.24           O  
ATOM   1596  CB  PRO B  56       6.913  13.937  31.131  1.00 36.32           C  
ATOM   1597  CG  PRO B  56       8.346  13.714  30.969  1.00 36.64           C  
ATOM   1598  CD  PRO B  56       8.734  14.476  29.708  1.00 36.42           C  
ATOM   1599  N   GLU B  57       5.147  16.048  29.645  1.00 35.76           N  
ATOM   1600  CA  GLU B  57       3.962  16.909  29.542  1.00 35.84           C  
ATOM   1601  C   GLU B  57       3.261  16.795  28.188  1.00 35.59           C  
ATOM   1602  O   GLU B  57       2.159  17.306  28.025  1.00 36.23           O  
ATOM   1603  CB  GLU B  57       4.288  18.382  29.817  1.00 35.86           C  
ATOM   1604  CG  GLU B  57       5.113  19.088  28.738  1.00 36.26           C  
ATOM   1605  CD  GLU B  57       6.582  19.206  29.112  1.00 37.39           C  
ATOM   1606  OE1 GLU B  57       7.106  18.289  29.794  1.00 38.57           O  
ATOM   1607  OE2 GLU B  57       7.209  20.220  28.732  1.00 36.74           O  
ATOM   1608  N   TYR B  58       3.897  16.134  27.226  1.00 34.51           N  
ATOM   1609  CA  TYR B  58       3.308  16.002  25.896  1.00 34.12           C  
ATOM   1610  C   TYR B  58       2.698  14.634  25.623  1.00 34.01           C  
ATOM   1611  O   TYR B  58       2.119  14.430  24.558  1.00 33.94           O  
ATOM   1612  CB  TYR B  58       4.322  16.386  24.804  1.00 33.53           C  
ATOM   1613  CG  TYR B  58       4.625  17.872  24.755  1.00 32.38           C  
ATOM   1614  CD1 TYR B  58       3.665  18.780  24.310  1.00 31.93           C  
ATOM   1615  CD2 TYR B  58       5.862  18.364  25.161  1.00 30.93           C  
ATOM   1616  CE1 TYR B  58       3.927  20.136  24.259  1.00 31.88           C  
ATOM   1617  CE2 TYR B  58       6.140  19.724  25.112  1.00 32.19           C  
ATOM   1618  CZ  TYR B  58       5.167  20.605  24.661  1.00 32.28           C  
ATOM   1619  OH  TYR B  58       5.423  21.958  24.617  1.00 31.36           O  
ATOM   1620  N   LYS B  59       2.800  13.713  26.587  1.00 34.43           N  
ATOM   1621  CA  LYS B  59       2.276  12.345  26.400  1.00 35.17           C  
ATOM   1622  C   LYS B  59       0.760  12.411  26.242  1.00 35.72           C  
ATOM   1623  O   LYS B  59       0.232  11.869  25.287  1.00 36.84           O  
ATOM   1624  CB  LYS B  59       2.661  11.407  27.566  1.00 35.16           C  
ATOM   1625  CG  LYS B  59       4.160  11.293  27.885  1.00 34.97           C  
ATOM   1626  CD  LYS B  59       4.936  10.437  26.866  1.00 35.31           C  
ATOM   1627  CE  LYS B  59       6.430  10.559  27.096  1.00 36.18           C  
ATOM   1628  NZ  LYS B  59       7.258   9.810  26.100  1.00 39.77           N  
ATOM   1629  N   VAL B  60       0.067  13.094  27.167  1.00 35.74           N  
ATOM   1630  CA  VAL B  60      -1.391  13.241  27.085  1.00 35.50           C  
ATOM   1631  C   VAL B  60      -1.825  13.946  25.760  1.00 35.38           C  
ATOM   1632  O   VAL B  60      -2.700  13.437  25.059  1.00 35.54           O  
ATOM   1633  CB  VAL B  60      -2.014  13.876  28.392  1.00 35.85           C  
ATOM   1634  CG1 VAL B  60      -3.482  14.178  28.214  1.00 36.17           C  
ATOM   1635  CG2 VAL B  60      -1.839  12.951  29.600  1.00 34.90           C  
ATOM   1636  N   PRO B  61      -1.218  15.102  25.411  1.00 34.65           N  
ATOM   1637  CA  PRO B  61      -1.407  15.640  24.050  1.00 34.57           C  
ATOM   1638  C   PRO B  61      -1.217  14.652  22.890  1.00 34.05           C  
ATOM   1639  O   PRO B  61      -1.994  14.683  21.939  1.00 34.97           O  
ATOM   1640  CB  PRO B  61      -0.378  16.784  23.978  1.00 34.27           C  
ATOM   1641  CG  PRO B  61      -0.316  17.277  25.389  1.00 34.93           C  
ATOM   1642  CD  PRO B  61      -0.416  16.022  26.248  1.00 34.72           C  
ATOM   1643  N   GLY B  62      -0.198  13.802  22.950  1.00 33.77           N  
ATOM   1644  CA  GLY B  62      -0.011  12.770  21.957  1.00 33.46           C  
ATOM   1645  C   GLY B  62      -1.187  11.799  21.941  1.00 34.06           C  
ATOM   1646  O   GLY B  62      -1.668  11.395  20.880  1.00 33.97           O  
ATOM   1647  N   LEU B  63      -1.646  11.412  23.124  1.00 33.81           N  
ATOM   1648  CA  LEU B  63      -2.832  10.583  23.210  1.00 33.58           C  
ATOM   1649  C   LEU B  63      -4.059  11.279  22.631  1.00 33.81           C  
ATOM   1650  O   LEU B  63      -4.838  10.638  21.937  1.00 34.36           O  
ATOM   1651  CB  LEU B  63      -3.087  10.103  24.638  1.00 33.09           C  
ATOM   1652  CG  LEU B  63      -4.419   9.396  24.896  1.00 33.06           C  
ATOM   1653  CD1 LEU B  63      -4.523   8.091  24.125  1.00 34.18           C  
ATOM   1654  CD2 LEU B  63      -4.617   9.157  26.399  1.00 33.39           C  
ATOM   1655  N   TYR B  64      -4.219  12.576  22.898  1.00 33.87           N  
ATOM   1656  CA  TYR B  64      -5.319  13.337  22.317  1.00 34.05           C  
ATOM   1657  C   TYR B  64      -5.267  13.390  20.786  1.00 33.95           C  
ATOM   1658  O   TYR B  64      -6.295  13.452  20.138  1.00 33.87           O  
ATOM   1659  CB  TYR B  64      -5.397  14.758  22.893  1.00 34.07           C  
ATOM   1660  CG  TYR B  64      -5.938  14.838  24.310  1.00 33.95           C  
ATOM   1661  CD1 TYR B  64      -6.587  13.751  24.908  1.00 34.25           C  
ATOM   1662  CD2 TYR B  64      -5.804  16.016  25.053  1.00 33.94           C  
ATOM   1663  CE1 TYR B  64      -7.088  13.841  26.241  1.00 35.26           C  
ATOM   1664  CE2 TYR B  64      -6.317  16.127  26.354  1.00 34.95           C  
ATOM   1665  CZ  TYR B  64      -6.947  15.035  26.947  1.00 34.62           C  
ATOM   1666  OH  TYR B  64      -7.432  15.154  28.235  1.00 34.75           O  
ATOM   1667  N   VAL B  65      -4.065  13.382  20.226  1.00 34.46           N  
ATOM   1668  CA  VAL B  65      -3.885  13.250  18.763  1.00 33.87           C  
ATOM   1669  C   VAL B  65      -4.439  11.914  18.240  1.00 34.26           C  
ATOM   1670  O   VAL B  65      -5.179  11.899  17.252  1.00 34.47           O  
ATOM   1671  CB  VAL B  65      -2.393  13.457  18.348  1.00 33.75           C  
ATOM   1672  CG1 VAL B  65      -2.177  13.060  16.898  1.00 33.44           C  
ATOM   1673  CG2 VAL B  65      -1.938  14.933  18.604  1.00 32.12           C  
ATOM   1674  N   ILE B  66      -4.085  10.798  18.890  1.00 34.28           N  
ATOM   1675  CA  ILE B  66      -4.678   9.499  18.538  1.00 33.57           C  
ATOM   1676  C   ILE B  66      -6.202   9.550  18.628  1.00 34.37           C  
ATOM   1677  O   ILE B  66      -6.898   9.249  17.655  1.00 34.66           O  
ATOM   1678  CB  ILE B  66      -4.149   8.335  19.428  1.00 33.53           C  
ATOM   1679  CG1 ILE B  66      -2.629   8.191  19.275  1.00 30.89           C  
ATOM   1680  CG2 ILE B  66      -4.871   6.997  19.081  1.00 31.84           C  
ATOM   1681  CD1 ILE B  66      -2.024   7.307  20.317  1.00 29.02           C  
ATOM   1682  N   ASP B  67      -6.724   9.954  19.787  1.00 35.05           N  
ATOM   1683  CA  ASP B  67      -8.170  10.058  19.956  1.00 35.33           C  
ATOM   1684  C   ASP B  67      -8.781  10.928  18.855  1.00 36.01           C  
ATOM   1685  O   ASP B  67      -9.784  10.560  18.228  1.00 36.12           O  
ATOM   1686  CB  ASP B  67      -8.492  10.652  21.318  1.00 35.55           C  
ATOM   1687  CG  ASP B  67      -9.971  10.723  21.575  1.00 35.80           C  
ATOM   1688  OD1 ASP B  67     -10.600   9.637  21.666  1.00 36.42           O  
ATOM   1689  OD2 ASP B  67     -10.499  11.852  21.671  1.00 34.39           O  
ATOM   1690  N   SER B  68      -8.168  12.083  18.616  1.00 35.59           N  
ATOM   1691  CA  SER B  68      -8.734  13.030  17.671  1.00 36.40           C  
ATOM   1692  C   SER B  68      -8.746  12.495  16.223  1.00 35.47           C  
ATOM   1693  O   SER B  68      -9.744  12.615  15.532  1.00 36.19           O  
ATOM   1694  CB  SER B  68      -8.010  14.370  17.763  1.00 36.12           C  
ATOM   1695  OG  SER B  68      -8.739  15.346  17.052  1.00 37.44           O  
ATOM   1696  N   ILE B  69      -7.646  11.888  15.800  1.00 35.25           N  
ATOM   1697  CA  ILE B  69      -7.524  11.315  14.464  1.00 34.87           C  
ATOM   1698  C   ILE B  69      -8.469  10.151  14.273  1.00 34.85           C  
ATOM   1699  O   ILE B  69      -9.143  10.077  13.262  1.00 35.07           O  
ATOM   1700  CB  ILE B  69      -6.097  10.858  14.156  1.00 34.94           C  
ATOM   1701  CG1 ILE B  69      -5.180  12.078  13.981  1.00 35.83           C  
ATOM   1702  CG2 ILE B  69      -6.070   9.956  12.904  1.00 33.50           C  
ATOM   1703  CD1 ILE B  69      -3.649  11.752  14.059  1.00 35.24           C  
ATOM   1704  N   VAL B  70      -8.519   9.254  15.251  1.00 35.13           N  
ATOM   1705  CA  VAL B  70      -9.362   8.065  15.158  1.00 35.66           C  
ATOM   1706  C   VAL B  70     -10.826   8.463  15.052  1.00 35.53           C  
ATOM   1707  O   VAL B  70     -11.534   8.009  14.158  1.00 35.70           O  
ATOM   1708  CB  VAL B  70      -9.121   7.098  16.343  1.00 35.51           C  
ATOM   1709  CG1 VAL B  70     -10.213   6.071  16.401  1.00 36.84           C  
ATOM   1710  CG2 VAL B  70      -7.785   6.390  16.168  1.00 35.92           C  
ATOM   1711  N   ARG B  71     -11.260   9.343  15.948  1.00 35.61           N  
ATOM   1712  CA  ARG B  71     -12.643   9.806  15.976  1.00 35.74           C  
ATOM   1713  C   ARG B  71     -13.035  10.570  14.713  1.00 34.85           C  
ATOM   1714  O   ARG B  71     -14.133  10.403  14.194  1.00 34.88           O  
ATOM   1715  CB  ARG B  71     -12.895  10.637  17.240  1.00 35.45           C  
ATOM   1716  CG  ARG B  71     -13.002   9.768  18.505  1.00 37.04           C  
ATOM   1717  CD  ARG B  71     -13.124  10.574  19.798  1.00 38.06           C  
ATOM   1718  NE  ARG B  71     -14.193  11.561  19.732  1.00 44.77           N  
ATOM   1719  CZ  ARG B  71     -14.015  12.879  19.767  1.00 45.90           C  
ATOM   1720  NH1 ARG B  71     -12.801  13.404  19.907  1.00 47.22           N  
ATOM   1721  NH2 ARG B  71     -15.065  13.674  19.671  1.00 48.64           N  
ATOM   1722  N   GLN B  72     -12.128  11.397  14.208  1.00 33.87           N  
ATOM   1723  CA  GLN B  72     -12.395  12.149  12.987  1.00 33.30           C  
ATOM   1724  C   GLN B  72     -12.517  11.235  11.762  1.00 32.42           C  
ATOM   1725  O   GLN B  72     -13.393  11.426  10.926  1.00 31.11           O  
ATOM   1726  CB  GLN B  72     -11.292  13.190  12.754  1.00 33.63           C  
ATOM   1727  CG  GLN B  72     -11.530  14.090  11.547  1.00 34.76           C  
ATOM   1728  CD  GLN B  72     -12.867  14.809  11.621  1.00 36.97           C  
ATOM   1729  OE1 GLN B  72     -13.175  15.453  12.621  1.00 39.76           O  
ATOM   1730  NE2 GLN B  72     -13.660  14.697  10.570  1.00 35.51           N  
ATOM   1731  N   SER B  73     -11.625  10.251  11.680  1.00 32.07           N  
ATOM   1732  CA  SER B  73     -11.606   9.282  10.597  1.00 31.85           C  
ATOM   1733  C   SER B  73     -12.850   8.383  10.625  1.00 31.92           C  
ATOM   1734  O   SER B  73     -13.410   8.060   9.579  1.00 31.71           O  
ATOM   1735  CB  SER B  73     -10.339   8.440  10.701  1.00 32.09           C  
ATOM   1736  OG  SER B  73     -10.323   7.406   9.735  1.00 30.87           O  
ATOM   1737  N   ARG B  74     -13.291   7.997  11.823  1.00 31.28           N  
ATOM   1738  CA  ARG B  74     -14.496   7.202  11.932  1.00 31.55           C  
ATOM   1739  C   ARG B  74     -15.684   8.043  11.497  1.00 31.35           C  
ATOM   1740  O   ARG B  74     -16.601   7.552  10.834  1.00 31.25           O  
ATOM   1741  CB  ARG B  74     -14.680   6.690  13.354  1.00 31.16           C  
ATOM   1742  CG  ARG B  74     -13.757   5.541  13.699  1.00 32.28           C  
ATOM   1743  CD  ARG B  74     -13.612   5.351  15.218  1.00 33.76           C  
ATOM   1744  NE  ARG B  74     -14.901   5.173  15.889  1.00 34.79           N  
ATOM   1745  CZ  ARG B  74     -15.571   4.026  15.934  1.00 35.04           C  
ATOM   1746  NH1 ARG B  74     -15.075   2.940  15.363  1.00 34.13           N  
ATOM   1747  NH2 ARG B  74     -16.735   3.961  16.568  1.00 37.45           N  
ATOM   1748  N   HIS B  75     -15.661   9.319  11.868  1.00 31.13           N  
ATOM   1749  CA  HIS B  75     -16.752  10.216  11.507  1.00 30.98           C  
ATOM   1750  C   HIS B  75     -16.741  10.475  10.002  1.00 30.66           C  
ATOM   1751  O   HIS B  75     -17.790  10.464   9.344  1.00 30.07           O  
ATOM   1752  CB  HIS B  75     -16.615  11.541  12.263  1.00 31.75           C  
ATOM   1753  CG  HIS B  75     -17.716  12.509  11.974  1.00 30.57           C  
ATOM   1754  ND1 HIS B  75     -18.925  12.471  12.627  1.00 31.05           N  
ATOM   1755  CD2 HIS B  75     -17.793  13.533  11.095  1.00 32.27           C  
ATOM   1756  CE1 HIS B  75     -19.701  13.436  12.169  1.00 32.09           C  
ATOM   1757  NE2 HIS B  75     -19.045  14.088  11.227  1.00 32.48           N  
ATOM   1758  N   GLN B  76     -15.539  10.677   9.469  1.00 30.09           N  
ATOM   1759  CA  GLN B  76     -15.364  11.075   8.086  1.00 30.25           C  
ATOM   1760  C   GLN B  76     -15.438   9.933   7.080  1.00 30.09           C  
ATOM   1761  O   GLN B  76     -15.967  10.120   5.999  1.00 29.64           O  
ATOM   1762  CB  GLN B  76     -14.053  11.832   7.915  1.00 29.83           C  
ATOM   1763  CG  GLN B  76     -14.018  12.700   6.672  1.00 30.94           C  
ATOM   1764  CD  GLN B  76     -12.909  13.718   6.734  1.00 31.03           C  
ATOM   1765  OE1 GLN B  76     -12.494  14.132   7.817  1.00 33.45           O  
ATOM   1766  NE2 GLN B  76     -12.433  14.135   5.582  1.00 30.17           N  
ATOM   1767  N   PHE B  77     -14.918   8.761   7.433  1.00 30.46           N  
ATOM   1768  CA  PHE B  77     -14.873   7.649   6.489  1.00 31.33           C  
ATOM   1769  C   PHE B  77     -15.782   6.478   6.831  1.00 31.91           C  
ATOM   1770  O   PHE B  77     -15.903   5.540   6.039  1.00 31.24           O  
ATOM   1771  CB  PHE B  77     -13.439   7.170   6.308  1.00 31.30           C  
ATOM   1772  CG  PHE B  77     -12.521   8.240   5.811  1.00 32.07           C  
ATOM   1773  CD1 PHE B  77     -12.413   8.500   4.454  1.00 31.03           C  
ATOM   1774  CD2 PHE B  77     -11.789   9.013   6.708  1.00 31.13           C  
ATOM   1775  CE1 PHE B  77     -11.570   9.508   3.996  1.00 31.20           C  
ATOM   1776  CE2 PHE B  77     -10.973  10.012   6.262  1.00 31.43           C  
ATOM   1777  CZ  PHE B  77     -10.861  10.262   4.886  1.00 31.49           C  
ATOM   1778  N   GLY B  78     -16.418   6.548   8.004  1.00 32.59           N  
ATOM   1779  CA  GLY B  78     -17.232   5.463   8.528  1.00 33.24           C  
ATOM   1780  C   GLY B  78     -16.468   4.678   9.580  1.00 33.79           C  
ATOM   1781  O   GLY B  78     -15.281   4.409   9.407  1.00 33.55           O  
ATOM   1782  N   GLN B  79     -17.159   4.309  10.660  1.00 34.54           N  
ATOM   1783  CA  GLN B  79     -16.609   3.477  11.742  1.00 35.70           C  
ATOM   1784  C   GLN B  79     -15.825   2.272  11.249  1.00 35.58           C  
ATOM   1785  O   GLN B  79     -14.701   2.026  11.705  1.00 35.94           O  
ATOM   1786  CB  GLN B  79     -17.730   2.925  12.612  1.00 35.80           C  
ATOM   1787  CG  GLN B  79     -18.359   3.870  13.605  1.00 37.49           C  
ATOM   1788  CD  GLN B  79     -19.390   3.158  14.475  1.00 37.58           C  
ATOM   1789  OE1 GLN B  79     -19.307   1.945  14.709  1.00 39.83           O  
ATOM   1790  NE2 GLN B  79     -20.373   3.910  14.956  1.00 40.62           N  
ATOM   1791  N   GLU B  80     -16.440   1.524  10.335  1.00 35.14           N  
ATOM   1792  CA  GLU B  80     -15.918   0.252   9.845  1.00 35.68           C  
ATOM   1793  C   GLU B  80     -14.990   0.416   8.639  1.00 35.19           C  
ATOM   1794  O   GLU B  80     -14.373  -0.555   8.199  1.00 35.33           O  
ATOM   1795  CB  GLU B  80     -17.077  -0.709   9.486  1.00 35.41           C  
ATOM   1796  CG  GLU B  80     -17.892  -1.235  10.690  1.00 36.44           C  
ATOM   1797  CD  GLU B  80     -19.020  -2.204  10.293  1.00 37.56           C  
ATOM   1798  OE1 GLU B  80     -19.316  -2.343   9.077  1.00 40.13           O  
ATOM   1799  OE2 GLU B  80     -19.617  -2.836  11.202  1.00 39.80           O  
ATOM   1800  N   LYS B  81     -14.906   1.629   8.089  1.00 34.71           N  
ATOM   1801  CA  LYS B  81     -13.976   1.880   6.989  1.00 34.44           C  
ATOM   1802  C   LYS B  81     -12.673   2.549   7.476  1.00 34.44           C  
ATOM   1803  O   LYS B  81     -11.670   2.568   6.759  1.00 34.24           O  
ATOM   1804  CB  LYS B  81     -14.656   2.688   5.861  1.00 34.40           C  
ATOM   1805  CG  LYS B  81     -15.954   2.041   5.296  1.00 34.81           C  
ATOM   1806  CD  LYS B  81     -15.709   0.623   4.677  1.00 33.86           C  
ATOM   1807  CE  LYS B  81     -16.967   0.364   3.691  1.00 37.32           C  
ATOM   1808  NZ  LYS B  81     -18.288  -0.149   4.398  1.00 40.03           N  
ATOM   1809  N   ASP B  82     -12.702   3.074   8.701  1.00 34.27           N  
ATOM   1810  CA  ASP B  82     -11.532   3.698   9.346  1.00 34.30           C  
ATOM   1811  C   ASP B  82     -10.285   2.802   9.339  1.00 34.01           C  
ATOM   1812  O   ASP B  82     -10.313   1.676   9.842  1.00 33.43           O  
ATOM   1813  CB  ASP B  82     -11.871   4.124  10.792  1.00 34.10           C  
ATOM   1814  CG  ASP B  82     -10.623   4.535  11.608  1.00 34.99           C  
ATOM   1815  OD1 ASP B  82      -9.834   5.379  11.142  1.00 33.33           O  
ATOM   1816  OD2 ASP B  82     -10.432   4.018  12.729  1.00 35.39           O  
ATOM   1817  N   VAL B  83      -9.200   3.337   8.783  1.00 33.81           N  
ATOM   1818  CA  VAL B  83      -7.893   2.678   8.765  1.00 33.61           C  
ATOM   1819  C   VAL B  83      -7.020   2.936  10.014  1.00 33.22           C  
ATOM   1820  O   VAL B  83      -6.090   2.173  10.292  1.00 32.67           O  
ATOM   1821  CB  VAL B  83      -7.069   3.093   7.502  1.00 33.72           C  
ATOM   1822  CG1 VAL B  83      -7.800   2.737   6.240  1.00 33.87           C  
ATOM   1823  CG2 VAL B  83      -6.745   4.589   7.514  1.00 35.00           C  
ATOM   1824  N   PHE B  84      -7.300   4.014  10.749  1.00 33.21           N  
ATOM   1825  CA  PHE B  84      -6.410   4.465  11.831  1.00 32.94           C  
ATOM   1826  C   PHE B  84      -6.462   3.656  13.122  1.00 33.42           C  
ATOM   1827  O   PHE B  84      -5.399   3.310  13.645  1.00 33.93           O  
ATOM   1828  CB  PHE B  84      -6.589   5.959  12.134  1.00 32.81           C  
ATOM   1829  CG  PHE B  84      -5.983   6.867  11.099  1.00 32.41           C  
ATOM   1830  CD1 PHE B  84      -4.598   7.082  11.057  1.00 33.16           C  
ATOM   1831  CD2 PHE B  84      -6.790   7.514  10.171  1.00 32.57           C  
ATOM   1832  CE1 PHE B  84      -4.021   7.936  10.095  1.00 32.19           C  
ATOM   1833  CE2 PHE B  84      -6.227   8.377   9.201  1.00 33.34           C  
ATOM   1834  CZ  PHE B  84      -4.833   8.577   9.165  1.00 32.51           C  
ATOM   1835  N   ALA B  85      -7.665   3.391  13.645  1.00 32.85           N  
ATOM   1836  CA  ALA B  85      -7.839   2.542  14.849  1.00 33.55           C  
ATOM   1837  C   ALA B  85      -7.208   1.155  14.715  1.00 33.66           C  
ATOM   1838  O   ALA B  85      -6.476   0.754  15.613  1.00 34.42           O  
ATOM   1839  CB  ALA B  85      -9.331   2.428  15.280  1.00 32.97           C  
ATOM   1840  N   PRO B  86      -7.470   0.420  13.597  1.00 33.80           N  
ATOM   1841  CA  PRO B  86      -6.840  -0.901  13.483  1.00 33.16           C  
ATOM   1842  C   PRO B  86      -5.324  -0.810  13.404  1.00 32.71           C  
ATOM   1843  O   PRO B  86      -4.637  -1.612  14.027  1.00 31.84           O  
ATOM   1844  CB  PRO B  86      -7.403  -1.464  12.170  1.00 33.63           C  
ATOM   1845  CG  PRO B  86      -8.580  -0.633  11.848  1.00 33.97           C  
ATOM   1846  CD  PRO B  86      -8.314   0.711  12.424  1.00 33.51           C  
ATOM   1847  N   ARG B  87      -4.818   0.150  12.627  1.00 32.39           N  
ATOM   1848  CA  ARG B  87      -3.377   0.445  12.577  1.00 32.38           C  
ATOM   1849  C   ARG B  87      -2.758   0.871  13.930  1.00 31.68           C  
ATOM   1850  O   ARG B  87      -1.709   0.371  14.305  1.00 31.76           O  
ATOM   1851  CB  ARG B  87      -3.065   1.475  11.483  1.00 32.69           C  
ATOM   1852  CG  ARG B  87      -1.570   1.661  11.198  1.00 33.42           C  
ATOM   1853  CD  ARG B  87      -0.995   0.503  10.378  1.00 34.82           C  
ATOM   1854  NE  ARG B  87       0.469   0.565  10.356  1.00 35.88           N  
ATOM   1855  CZ  ARG B  87       1.268  -0.346   9.796  1.00 35.47           C  
ATOM   1856  NH1 ARG B  87       0.756  -1.418   9.207  1.00 36.58           N  
ATOM   1857  NH2 ARG B  87       2.588  -0.177   9.828  1.00 33.53           N  
ATOM   1858  N   PHE B  88      -3.393   1.794  14.645  1.00 31.81           N  
ATOM   1859  CA  PHE B  88      -2.926   2.195  15.992  1.00 32.32           C  
ATOM   1860  C   PHE B  88      -2.932   1.033  16.980  1.00 33.11           C  
ATOM   1861  O   PHE B  88      -2.082   0.993  17.882  1.00 32.87           O  
ATOM   1862  CB  PHE B  88      -3.749   3.353  16.580  1.00 31.97           C  
ATOM   1863  CG  PHE B  88      -3.268   4.727  16.171  1.00 32.45           C  
ATOM   1864  CD1 PHE B  88      -1.990   5.164  16.504  1.00 30.80           C  
ATOM   1865  CD2 PHE B  88      -4.114   5.599  15.486  1.00 31.65           C  
ATOM   1866  CE1 PHE B  88      -1.562   6.429  16.139  1.00 28.23           C  
ATOM   1867  CE2 PHE B  88      -3.693   6.857  15.112  1.00 30.29           C  
ATOM   1868  CZ  PHE B  88      -2.397   7.272  15.435  1.00 30.87           C  
ATOM   1869  N   SER B  89      -3.873   0.091  16.797  1.00 33.61           N  
ATOM   1870  CA  SER B  89      -4.015  -1.079  17.673  0.40 34.17           C  
ATOM   1872  C   SER B  89      -2.790  -1.998  17.649  1.00 34.88           C  
ATOM   1873  O   SER B  89      -2.465  -2.643  18.654  1.00 35.46           O  
ATOM   1874  CB  SER B  89      -5.273  -1.885  17.315  0.40 33.98           C  
ATOM   1876  OG  SER B  89      -6.456  -1.125  17.485  0.40 32.94           O  
ATOM   1878  N   ASN B  90      -2.125  -2.073  16.495  1.00 35.42           N  
ATOM   1879  CA  ASN B  90      -0.953  -2.942  16.317  1.00 35.72           C  
ATOM   1880  C   ASN B  90       0.172  -2.749  17.377  1.00 35.75           C  
ATOM   1881  O   ASN B  90       0.668  -3.730  17.936  1.00 35.25           O  
ATOM   1882  CB  ASN B  90      -0.393  -2.827  14.882  1.00 35.93           C  
ATOM   1883  CG  ASN B  90      -1.412  -3.232  13.790  1.00 37.96           C  
ATOM   1884  OD1 ASN B  90      -2.524  -3.682  14.082  1.00 41.06           O  
ATOM   1885  ND2 ASN B  90      -1.023  -3.065  12.528  1.00 37.61           N  
ATOM   1886  N   ASN B  91       0.570  -1.504  17.656  1.00 35.03           N  
ATOM   1887  CA  ASN B  91       1.631  -1.246  18.665  1.00 34.79           C  
ATOM   1888  C   ASN B  91       1.085  -0.603  19.947  1.00 35.15           C  
ATOM   1889  O   ASN B  91       1.841   0.040  20.683  1.00 35.41           O  
ATOM   1890  CB  ASN B  91       2.744  -0.340  18.099  1.00 34.48           C  
ATOM   1891  CG  ASN B  91       3.603  -1.021  17.019  1.00 34.89           C  
ATOM   1892  OD1 ASN B  91       3.909  -2.205  17.104  1.00 33.97           O  
ATOM   1893  ND2 ASN B  91       4.020  -0.246  16.016  1.00 34.37           N  
ATOM   1894  N   ILE B  92      -0.215  -0.765  20.213  1.00 34.63           N  
ATOM   1895  CA  ILE B  92      -0.889   0.050  21.239  1.00 35.06           C  
ATOM   1896  C   ILE B  92      -0.332  -0.198  22.644  1.00 34.66           C  
ATOM   1897  O   ILE B  92      -0.333   0.701  23.479  1.00 34.90           O  
ATOM   1898  CB  ILE B  92      -2.444  -0.112  21.211  1.00 34.58           C  
ATOM   1899  CG1 ILE B  92      -3.103   1.042  21.970  1.00 36.05           C  
ATOM   1900  CG2 ILE B  92      -2.886  -1.506  21.717  1.00 33.86           C  
ATOM   1901  CD1 ILE B  92      -4.513   1.380  21.519  1.00 40.03           C  
ATOM   1902  N   ILE B  93       0.130  -1.422  22.895  1.00 34.17           N  
ATOM   1903  CA  ILE B  93       0.723  -1.769  24.187  1.00 34.11           C  
ATOM   1904  C   ILE B  93       1.997  -0.949  24.425  1.00 34.47           C  
ATOM   1905  O   ILE B  93       2.140  -0.285  25.448  1.00 35.17           O  
ATOM   1906  CB  ILE B  93       1.039  -3.291  24.305  1.00 33.85           C  
ATOM   1907  CG1 ILE B  93      -0.252  -4.129  24.181  1.00 32.93           C  
ATOM   1908  CG2 ILE B  93       1.801  -3.576  25.616  1.00 32.84           C  
ATOM   1909  CD1 ILE B  93      -1.310  -3.853  25.267  1.00 33.78           C  
ATOM   1910  N   SER B  94       2.909  -1.004  23.471  1.00 34.77           N  
ATOM   1911  CA  SER B  94       4.110  -0.182  23.473  1.00 35.95           C  
ATOM   1912  C   SER B  94       3.807   1.333  23.606  1.00 35.96           C  
ATOM   1913  O   SER B  94       4.522   2.061  24.306  1.00 35.59           O  
ATOM   1914  CB  SER B  94       4.896  -0.479  22.196  1.00 36.38           C  
ATOM   1915  OG  SER B  94       5.694   0.622  21.808  1.00 39.82           O  
ATOM   1916  N   THR B  95       2.736   1.779  22.944  1.00 35.80           N  
ATOM   1917  CA  THR B  95       2.358   3.189  22.870  1.00 35.82           C  
ATOM   1918  C   THR B  95       1.955   3.677  24.258  1.00 35.68           C  
ATOM   1919  O   THR B  95       2.418   4.731  24.718  1.00 35.11           O  
ATOM   1920  CB  THR B  95       1.207   3.407  21.832  1.00 36.03           C  
ATOM   1921  OG1 THR B  95       1.688   3.070  20.527  1.00 35.19           O  
ATOM   1922  CG2 THR B  95       0.702   4.841  21.821  1.00 35.99           C  
ATOM   1923  N   PHE B  96       1.150   2.863  24.942  1.00 35.57           N  
ATOM   1924  CA  PHE B  96       0.676   3.198  26.285  1.00 35.14           C  
ATOM   1925  C   PHE B  96       1.762   3.079  27.356  1.00 34.58           C  
ATOM   1926  O   PHE B  96       1.790   3.873  28.286  1.00 34.50           O  
ATOM   1927  CB  PHE B  96      -0.601   2.425  26.640  1.00 34.73           C  
ATOM   1928  CG  PHE B  96      -1.845   3.124  26.189  1.00 35.63           C  
ATOM   1929  CD1 PHE B  96      -2.153   3.208  24.827  1.00 35.39           C  
ATOM   1930  CD2 PHE B  96      -2.680   3.765  27.115  1.00 35.27           C  
ATOM   1931  CE1 PHE B  96      -3.292   3.883  24.391  1.00 34.85           C  
ATOM   1932  CE2 PHE B  96      -3.822   4.444  26.684  1.00 36.49           C  
ATOM   1933  CZ  PHE B  96      -4.128   4.506  25.316  1.00 34.86           C  
ATOM   1934  N   GLN B  97       2.657   2.110  27.208  1.00 34.30           N  
ATOM   1935  CA  GLN B  97       3.864   2.041  28.045  1.00 34.22           C  
ATOM   1936  C   GLN B  97       4.617   3.368  28.005  1.00 34.45           C  
ATOM   1937  O   GLN B  97       5.044   3.865  29.040  1.00 34.90           O  
ATOM   1938  CB  GLN B  97       4.794   0.909  27.600  1.00 33.35           C  
ATOM   1939  CG  GLN B  97       4.328  -0.480  28.011  1.00 33.80           C  
ATOM   1940  CD  GLN B  97       5.142  -1.608  27.371  1.00 33.57           C  
ATOM   1941  OE1 GLN B  97       5.997  -1.374  26.512  1.00 33.09           O  
ATOM   1942  NE2 GLN B  97       4.859  -2.836  27.777  1.00 31.15           N  
ATOM   1943  N   ASN B  98       4.767   3.937  26.808  1.00 34.48           N  
ATOM   1944  CA  ASN B  98       5.376   5.246  26.664  1.00 34.65           C  
ATOM   1945  C   ASN B  98       4.475   6.368  27.210  1.00 34.85           C  
ATOM   1946  O   ASN B  98       4.975   7.282  27.856  1.00 34.63           O  
ATOM   1947  CB  ASN B  98       5.787   5.522  25.216  1.00 34.59           C  
ATOM   1948  CG  ASN B  98       6.707   4.444  24.628  1.00 35.22           C  
ATOM   1949  OD1 ASN B  98       7.536   3.845  25.317  1.00 38.38           O  
ATOM   1950  ND2 ASN B  98       6.562   4.208  23.347  1.00 34.80           N  
ATOM   1951  N   LEU B  99       3.155   6.295  26.969  1.00 35.50           N  
ATOM   1952  CA  LEU B  99       2.196   7.286  27.489  1.00 35.82           C  
ATOM   1953  C   LEU B  99       2.172   7.361  29.010  1.00 36.34           C  
ATOM   1954  O   LEU B  99       1.976   8.443  29.592  1.00 36.12           O  
ATOM   1955  CB  LEU B  99       0.763   7.018  26.988  1.00 36.46           C  
ATOM   1956  CG  LEU B  99       0.402   7.320  25.520  1.00 35.75           C  
ATOM   1957  CD1 LEU B  99      -1.012   6.795  25.180  1.00 35.00           C  
ATOM   1958  CD2 LEU B  99       0.518   8.797  25.230  1.00 33.13           C  
ATOM   1959  N   TYR B 100       2.353   6.216  29.661  1.00 36.69           N  
ATOM   1960  CA  TYR B 100       2.278   6.152  31.119  1.00 37.45           C  
ATOM   1961  C   TYR B 100       3.528   6.714  31.800  1.00 37.98           C  
ATOM   1962  O   TYR B 100       3.572   6.820  33.020  1.00 37.29           O  
ATOM   1963  CB  TYR B 100       1.939   4.731  31.605  1.00 37.44           C  
ATOM   1964  CG  TYR B 100       0.471   4.352  31.423  1.00 38.46           C  
ATOM   1965  CD1 TYR B 100      -0.552   5.173  31.911  1.00 38.38           C  
ATOM   1966  CD2 TYR B 100       0.107   3.174  30.781  1.00 37.57           C  
ATOM   1967  CE1 TYR B 100      -1.884   4.836  31.747  1.00 37.35           C  
ATOM   1968  CE2 TYR B 100      -1.245   2.830  30.607  1.00 37.42           C  
ATOM   1969  CZ  TYR B 100      -2.222   3.664  31.088  1.00 37.82           C  
ATOM   1970  OH  TYR B 100      -3.550   3.323  30.924  1.00 38.42           O  
ATOM   1971  N   ARG B 101       4.531   7.088  30.997  1.00 38.95           N  
ATOM   1972  CA  ARG B 101       5.701   7.832  31.487  1.00 40.07           C  
ATOM   1973  C   ARG B 101       5.415   9.343  31.635  1.00 39.72           C  
ATOM   1974  O   ARG B 101       6.339  10.152  31.707  1.00 39.93           O  
ATOM   1975  CB  ARG B 101       6.909   7.593  30.574  1.00 39.78           C  
ATOM   1976  CG  ARG B 101       7.717   6.353  30.920  1.00 41.34           C  
ATOM   1977  CD  ARG B 101       9.021   6.292  30.112  1.00 42.09           C  
ATOM   1978  NE  ARG B 101       8.870   5.578  28.839  1.00 46.03           N  
ATOM   1979  CZ  ARG B 101       9.882   5.151  28.073  1.00 48.00           C  
ATOM   1980  NH1 ARG B 101      11.150   5.359  28.430  1.00 48.56           N  
ATOM   1981  NH2 ARG B 101       9.625   4.507  26.937  1.00 48.70           N  
ATOM   1982  N   CYS B 102       4.130   9.699  31.671  1.00 39.51           N  
ATOM   1983  CA  CYS B 102       3.643  11.067  31.818  1.00 38.72           C  
ATOM   1984  C   CYS B 102       3.728  11.475  33.282  1.00 38.80           C  
ATOM   1985  O   CYS B 102       3.982  10.623  34.120  1.00 38.78           O  
ATOM   1986  CB  CYS B 102       2.176  11.134  31.355  1.00 38.54           C  
ATOM   1987  SG  CYS B 102       1.026  10.115  32.358  1.00 37.77           S  
ATOM   1988  N   PRO B 103       3.493  12.770  33.605  1.00 38.76           N  
ATOM   1989  CA  PRO B 103       3.424  13.163  35.016  1.00 38.88           C  
ATOM   1990  C   PRO B 103       2.325  12.430  35.786  1.00 39.05           C  
ATOM   1991  O   PRO B 103       1.300  12.050  35.207  1.00 38.76           O  
ATOM   1992  CB  PRO B 103       3.096  14.662  34.952  1.00 38.82           C  
ATOM   1993  CG  PRO B 103       3.589  15.100  33.599  1.00 39.01           C  
ATOM   1994  CD  PRO B 103       3.304  13.928  32.710  1.00 38.69           C  
ATOM   1995  N   GLY B 104       2.556  12.247  37.084  1.00 39.32           N  
ATOM   1996  CA  GLY B 104       1.595  11.623  38.001  1.00 39.58           C  
ATOM   1997  C   GLY B 104       0.159  12.067  37.806  1.00 39.84           C  
ATOM   1998  O   GLY B 104      -0.724  11.223  37.607  1.00 40.13           O  
ATOM   1999  N   ASP B 105      -0.058  13.386  37.830  1.00 39.65           N  
ATOM   2000  CA  ASP B 105      -1.389  13.983  37.669  0.60 39.79           C  
ATOM   2002  C   ASP B 105      -2.024  13.757  36.292  1.00 39.70           C  
ATOM   2003  O   ASP B 105      -3.200  14.080  36.087  1.00 39.80           O  
ATOM   2004  CB  ASP B 105      -1.330  15.490  37.940  0.60 40.13           C  
ATOM   2006  CG  ASP B 105      -0.953  16.293  36.700  0.60 41.11           C  
ATOM   2008  OD1 ASP B 105       0.172  16.102  36.181  0.60 41.17           O  
ATOM   2010  OD2 ASP B 105      -1.786  17.117  36.249  0.60 41.99           O  
ATOM   2012  N   ASP B 106      -1.256  13.219  35.345  1.00 39.19           N  
ATOM   2013  CA  ASP B 106      -1.757  13.035  33.979  1.00 38.96           C  
ATOM   2014  C   ASP B 106      -2.282  11.631  33.712  1.00 38.78           C  
ATOM   2015  O   ASP B 106      -2.924  11.408  32.692  1.00 38.80           O  
ATOM   2016  CB  ASP B 106      -0.674  13.383  32.942  1.00 39.33           C  
ATOM   2017  CG  ASP B 106      -0.744  14.830  32.475  1.00 40.10           C  
ATOM   2018  OD1 ASP B 106      -1.566  15.599  33.000  1.00 42.50           O  
ATOM   2019  OD2 ASP B 106       0.026  15.209  31.574  1.00 40.63           O  
ATOM   2020  N   LYS B 107      -1.991  10.689  34.612  1.00 38.40           N  
ATOM   2021  CA  LYS B 107      -2.422   9.300  34.447  1.00 38.62           C  
ATOM   2022  C   LYS B 107      -3.945   9.209  34.295  1.00 37.89           C  
ATOM   2023  O   LYS B 107      -4.437   8.535  33.389  1.00 37.87           O  
ATOM   2024  CB  LYS B 107      -1.963   8.439  35.630  1.00 38.71           C  
ATOM   2025  CG  LYS B 107      -0.691   7.618  35.388  1.00 39.82           C  
ATOM   2026  CD  LYS B 107      -0.306   6.838  36.669  1.00 40.11           C  
ATOM   2027  CE  LYS B 107       0.406   7.737  37.686  1.00 40.89           C  
ATOM   2028  NZ  LYS B 107       0.426   7.169  39.072  1.00 42.19           N  
ATOM   2029  N   SER B 108      -4.673   9.894  35.177  1.00 36.77           N  
ATOM   2030  CA  SER B 108      -6.135   9.923  35.143  1.00 36.53           C  
ATOM   2031  C   SER B 108      -6.734  10.392  33.797  1.00 36.38           C  
ATOM   2032  O   SER B 108      -7.803   9.919  33.392  1.00 36.40           O  
ATOM   2033  CB  SER B 108      -6.677  10.784  36.285  1.00 36.28           C  
ATOM   2034  OG  SER B 108      -6.592  12.173  35.987  1.00 37.08           O  
ATOM   2035  N   LYS B 109      -6.049  11.320  33.126  1.00 35.60           N  
ATOM   2036  CA  LYS B 109      -6.480  11.815  31.812  1.00 35.37           C  
ATOM   2037  C   LYS B 109      -6.398  10.744  30.733  1.00 34.93           C  
ATOM   2038  O   LYS B 109      -7.196  10.751  29.792  1.00 35.04           O  
ATOM   2039  CB  LYS B 109      -5.649  13.027  31.383  1.00 35.50           C  
ATOM   2040  CG  LYS B 109      -5.894  14.283  32.203  1.00 36.49           C  
ATOM   2041  CD  LYS B 109      -4.784  15.286  31.919  1.00 37.07           C  
ATOM   2042  CE  LYS B 109      -4.790  16.443  32.898  1.00 38.63           C  
ATOM   2043  NZ  LYS B 109      -3.696  17.382  32.528  1.00 39.12           N  
ATOM   2044  N   ILE B 110      -5.426   9.842  30.869  1.00 34.34           N  
ATOM   2045  CA  ILE B 110      -5.280   8.690  29.965  1.00 34.23           C  
ATOM   2046  C   ILE B 110      -6.396   7.663  30.189  1.00 34.00           C  
ATOM   2047  O   ILE B 110      -6.941   7.102  29.230  1.00 33.42           O  
ATOM   2048  CB  ILE B 110      -3.878   7.998  30.118  1.00 34.93           C  
ATOM   2049  CG1 ILE B 110      -2.740   8.967  29.764  1.00 34.71           C  
ATOM   2050  CG2 ILE B 110      -3.755   6.734  29.217  1.00 33.98           C  
ATOM   2051  CD1 ILE B 110      -1.353   8.440  30.140  1.00 34.24           C  
ATOM   2052  N   VAL B 111      -6.737   7.412  31.456  1.00 33.42           N  
ATOM   2053  CA  VAL B 111      -7.801   6.469  31.760  1.00 32.92           C  
ATOM   2054  C   VAL B 111      -9.133   7.004  31.229  1.00 33.49           C  
ATOM   2055  O   VAL B 111      -9.944   6.249  30.672  1.00 33.15           O  
ATOM   2056  CB  VAL B 111      -7.877   6.151  33.271  1.00 32.74           C  
ATOM   2057  CG1 VAL B 111      -9.083   5.279  33.583  1.00 32.56           C  
ATOM   2058  CG2 VAL B 111      -6.608   5.459  33.723  1.00 32.38           C  
ATOM   2059  N   ARG B 112      -9.344   8.311  31.394  1.00 33.85           N  
ATOM   2060  CA  ARG B 112     -10.561   8.957  30.910  1.00 34.44           C  
ATOM   2061  C   ARG B 112     -10.749   8.675  29.419  1.00 34.03           C  
ATOM   2062  O   ARG B 112     -11.830   8.271  29.002  1.00 34.51           O  
ATOM   2063  CB  ARG B 112     -10.543  10.460  31.175  1.00 34.28           C  
ATOM   2064  CG  ARG B 112     -11.911  11.076  31.054  1.00 35.61           C  
ATOM   2065  CD  ARG B 112     -11.849  12.565  30.856  1.00 38.44           C  
ATOM   2066  NE  ARG B 112     -13.198  13.116  30.732  1.00 40.00           N  
ATOM   2067  CZ  ARG B 112     -13.507  14.206  30.036  1.00 40.92           C  
ATOM   2068  NH1 ARG B 112     -12.570  14.880  29.372  1.00 41.60           N  
ATOM   2069  NH2 ARG B 112     -14.765  14.607  29.981  1.00 41.11           N  
ATOM   2070  N   VAL B 113      -9.692   8.858  28.629  1.00 34.00           N  
ATOM   2071  CA  VAL B 113      -9.735   8.507  27.195  1.00 33.59           C  
ATOM   2072  C   VAL B 113     -10.056   7.014  26.955  1.00 33.36           C  
ATOM   2073  O   VAL B 113     -10.960   6.696  26.184  1.00 32.84           O  
ATOM   2074  CB  VAL B 113      -8.447   8.937  26.444  1.00 33.66           C  
ATOM   2075  CG1 VAL B 113      -8.402   8.335  25.047  1.00 32.89           C  
ATOM   2076  CG2 VAL B 113      -8.377  10.444  26.349  1.00 32.66           C  
ATOM   2077  N   LEU B 114      -9.335   6.114  27.626  1.00 33.00           N  
ATOM   2078  CA  LEU B 114      -9.626   4.666  27.555  1.00 32.89           C  
ATOM   2079  C   LEU B 114     -11.071   4.293  27.900  1.00 33.16           C  
ATOM   2080  O   LEU B 114     -11.649   3.413  27.253  1.00 32.86           O  
ATOM   2081  CB  LEU B 114      -8.694   3.867  28.464  1.00 32.98           C  
ATOM   2082  CG  LEU B 114      -7.219   3.745  28.080  1.00 32.40           C  
ATOM   2083  CD1 LEU B 114      -6.468   3.070  29.232  1.00 31.24           C  
ATOM   2084  CD2 LEU B 114      -7.051   2.975  26.764  1.00 32.00           C  
ATOM   2085  N   ASN B 115     -11.638   4.933  28.932  1.00 32.58           N  
ATOM   2086  CA  ASN B 115     -13.036   4.724  29.291  1.00 32.54           C  
ATOM   2087  C   ASN B 115     -13.996   5.206  28.200  1.00 32.70           C  
ATOM   2088  O   ASN B 115     -14.993   4.546  27.896  1.00 32.65           O  
ATOM   2089  CB  ASN B 115     -13.379   5.393  30.639  1.00 32.48           C  
ATOM   2090  CG  ASN B 115     -13.021   4.522  31.839  1.00 32.85           C  
ATOM   2091  OD1 ASN B 115     -12.631   3.368  31.689  1.00 34.52           O  
ATOM   2092  ND2 ASN B 115     -13.143   5.080  33.034  1.00 32.85           N  
ATOM   2093  N   LEU B 116     -13.712   6.373  27.633  1.00 32.73           N  
ATOM   2094  CA  LEU B 116     -14.478   6.859  26.486  1.00 33.20           C  
ATOM   2095  C   LEU B 116     -14.360   5.937  25.264  1.00 33.85           C  
ATOM   2096  O   LEU B 116     -15.367   5.650  24.623  1.00 34.56           O  
ATOM   2097  CB  LEU B 116     -14.097   8.299  26.134  1.00 32.74           C  
ATOM   2098  CG  LEU B 116     -14.570   9.347  27.151  1.00 32.54           C  
ATOM   2099  CD1 LEU B 116     -13.857  10.669  26.910  1.00 33.42           C  
ATOM   2100  CD2 LEU B 116     -16.089   9.539  27.138  1.00 27.87           C  
ATOM   2101  N   TRP B 117     -13.152   5.468  24.957  1.00 33.89           N  
ATOM   2102  CA  TRP B 117     -12.945   4.519  23.859  1.00 34.87           C  
ATOM   2103  C   TRP B 117     -13.754   3.252  24.036  1.00 35.59           C  
ATOM   2104  O   TRP B 117     -14.304   2.728  23.070  1.00 35.54           O  
ATOM   2105  CB  TRP B 117     -11.469   4.129  23.714  1.00 33.93           C  
ATOM   2106  CG  TRP B 117     -10.626   5.171  23.107  1.00 33.67           C  
ATOM   2107  CD1 TRP B 117     -11.046   6.361  22.580  1.00 33.08           C  
ATOM   2108  CD2 TRP B 117      -9.203   5.124  22.922  1.00 33.46           C  
ATOM   2109  NE1 TRP B 117      -9.974   7.063  22.083  1.00 33.80           N  
ATOM   2110  CE2 TRP B 117      -8.828   6.331  22.283  1.00 33.86           C  
ATOM   2111  CE3 TRP B 117      -8.208   4.177  23.232  1.00 32.41           C  
ATOM   2112  CZ2 TRP B 117      -7.498   6.629  21.951  1.00 33.93           C  
ATOM   2113  CZ3 TRP B 117      -6.884   4.469  22.907  1.00 33.23           C  
ATOM   2114  CH2 TRP B 117      -6.539   5.692  22.273  1.00 34.43           C  
ATOM   2115  N   GLN B 118     -13.778   2.749  25.267  1.00 36.85           N  
ATOM   2116  CA  GLN B 118     -14.531   1.552  25.608  1.00 38.60           C  
ATOM   2117  C   GLN B 118     -16.038   1.818  25.513  1.00 39.12           C  
ATOM   2118  O   GLN B 118     -16.783   1.018  24.947  1.00 39.43           O  
ATOM   2119  CB  GLN B 118     -14.133   1.065  27.009  1.00 38.76           C  
ATOM   2120  CG  GLN B 118     -14.838  -0.211  27.469  1.00 41.63           C  
ATOM   2121  CD  GLN B 118     -14.083  -0.924  28.585  1.00 44.65           C  
ATOM   2122  OE1 GLN B 118     -13.510  -2.002  28.373  1.00 46.47           O  
ATOM   2123  NE2 GLN B 118     -14.059  -0.319  29.773  1.00 43.69           N  
ATOM   2124  N   LYS B 119     -16.471   2.951  26.065  1.00 39.74           N  
ATOM   2125  CA  LYS B 119     -17.867   3.350  26.051  1.00 40.29           C  
ATOM   2126  C   LYS B 119     -18.367   3.513  24.616  1.00 40.64           C  
ATOM   2127  O   LYS B 119     -19.457   3.061  24.278  1.00 39.97           O  
ATOM   2128  CB  LYS B 119     -18.034   4.664  26.817  1.00 40.53           C  
ATOM   2129  CG  LYS B 119     -19.459   5.172  26.896  1.00 41.86           C  
ATOM   2130  CD  LYS B 119     -19.499   6.616  27.373  1.00 43.55           C  
ATOM   2131  CE  LYS B 119     -20.923   7.039  27.663  1.00 45.46           C  
ATOM   2132  NZ  LYS B 119     -20.987   8.261  28.517  1.00 46.76           N  
ATOM   2133  N   ASN B 120     -17.554   4.145  23.772  1.00 40.94           N  
ATOM   2134  CA  ASN B 120     -17.993   4.462  22.416  1.00 41.56           C  
ATOM   2135  C   ASN B 120     -17.535   3.470  21.355  1.00 41.78           C  
ATOM   2136  O   ASN B 120     -17.661   3.732  20.165  1.00 42.01           O  
ATOM   2137  CB  ASN B 120     -17.598   5.892  22.054  1.00 41.26           C  
ATOM   2138  CG  ASN B 120     -18.288   6.915  22.924  1.00 42.02           C  
ATOM   2139  OD1 ASN B 120     -19.488   6.824  23.189  1.00 41.32           O  
ATOM   2140  ND2 ASN B 120     -17.533   7.899  23.379  1.00 43.44           N  
ATOM   2141  N   ASN B 121     -17.017   2.331  21.804  1.00 42.44           N  
ATOM   2142  CA  ASN B 121     -16.563   1.251  20.924  1.00 43.22           C  
ATOM   2143  C   ASN B 121     -15.544   1.697  19.875  1.00 43.19           C  
ATOM   2144  O   ASN B 121     -15.472   1.127  18.786  1.00 43.28           O  
ATOM   2145  CB  ASN B 121     -17.759   0.539  20.276  1.00 43.41           C  
ATOM   2146  CG  ASN B 121     -18.726  -0.020  21.297  1.00 44.42           C  
ATOM   2147  OD1 ASN B 121     -18.338  -0.744  22.217  1.00 45.63           O  
ATOM   2148  ND2 ASN B 121     -20.004   0.309  21.138  1.00 46.61           N  
ATOM   2149  N   VAL B 122     -14.751   2.706  20.233  1.00 43.41           N  
ATOM   2150  CA  VAL B 122     -13.699   3.256  19.380  1.00 43.46           C  
ATOM   2151  C   VAL B 122     -12.611   2.206  19.097  1.00 44.07           C  
ATOM   2152  O   VAL B 122     -12.168   2.053  17.955  1.00 44.39           O  
ATOM   2153  CB  VAL B 122     -13.091   4.543  19.991  1.00 43.29           C  
ATOM   2154  CG1 VAL B 122     -12.103   5.181  19.037  1.00 43.62           C  
ATOM   2155  CG2 VAL B 122     -14.181   5.549  20.343  1.00 42.86           C  
ATOM   2156  N   PHE B 123     -12.191   1.484  20.135  1.00 44.45           N  
ATOM   2157  CA  PHE B 123     -11.296   0.333  19.981  1.00 44.65           C  
ATOM   2158  C   PHE B 123     -12.011  -0.854  20.565  1.00 44.98           C  
ATOM   2159  O   PHE B 123     -12.854  -0.686  21.442  1.00 44.99           O  
ATOM   2160  CB  PHE B 123      -9.967   0.551  20.723  1.00 44.61           C  
ATOM   2161  CG  PHE B 123      -9.051   1.530  20.050  1.00 44.29           C  
ATOM   2162  CD1 PHE B 123      -9.316   2.896  20.085  1.00 43.92           C  
ATOM   2163  CD2 PHE B 123      -7.928   1.086  19.365  1.00 44.43           C  
ATOM   2164  CE1 PHE B 123      -8.481   3.792  19.449  1.00 42.81           C  
ATOM   2165  CE2 PHE B 123      -7.078   1.984  18.741  1.00 43.59           C  
ATOM   2166  CZ  PHE B 123      -7.357   3.335  18.782  1.00 44.19           C  
ATOM   2167  N   LYS B 124     -11.683  -2.052  20.083  1.00 45.78           N  
ATOM   2168  CA  LYS B 124     -12.267  -3.282  20.615  1.00 46.78           C  
ATOM   2169  C   LYS B 124     -11.972  -3.387  22.116  1.00 46.62           C  
ATOM   2170  O   LYS B 124     -10.901  -2.976  22.573  1.00 46.84           O  
ATOM   2171  CB  LYS B 124     -11.744  -4.511  19.856  1.00 47.11           C  
ATOM   2172  CG  LYS B 124     -11.767  -4.355  18.326  1.00 47.90           C  
ATOM   2173  CD  LYS B 124     -11.471  -5.672  17.619  1.00 48.06           C  
ATOM   2174  CE  LYS B 124     -11.642  -5.525  16.103  1.00 50.17           C  
ATOM   2175  NZ  LYS B 124     -11.576  -6.835  15.397  1.00 50.32           N  
ATOM   2176  N   SER B 125     -12.930  -3.901  22.882  1.00 46.41           N  
ATOM   2177  CA  SER B 125     -12.798  -3.964  24.340  1.00 46.35           C  
ATOM   2178  C   SER B 125     -11.630  -4.855  24.764  1.00 46.14           C  
ATOM   2179  O   SER B 125     -10.992  -4.612  25.790  1.00 46.09           O  
ATOM   2180  CB  SER B 125     -14.092  -4.472  24.977  1.00 46.57           C  
ATOM   2181  OG  SER B 125     -14.020  -4.384  26.391  1.00 46.70           O  
ATOM   2182  N   GLU B 126     -11.377  -5.891  23.965  1.00 45.62           N  
ATOM   2183  CA  GLU B 126     -10.247  -6.791  24.148  1.00 44.98           C  
ATOM   2184  C   GLU B 126      -8.917  -6.048  24.028  1.00 44.39           C  
ATOM   2185  O   GLU B 126      -7.928  -6.409  24.667  1.00 44.25           O  
ATOM   2186  CB  GLU B 126     -10.329  -7.893  23.101  1.00 45.14           C  
ATOM   2187  CG  GLU B 126      -8.998  -8.417  22.610  1.00 45.76           C  
ATOM   2188  CD  GLU B 126      -9.153  -9.244  21.356  1.00 46.75           C  
ATOM   2189  OE1 GLU B 126      -9.210  -8.647  20.254  1.00 46.80           O  
ATOM   2190  OE2 GLU B 126      -9.217 -10.487  21.477  1.00 46.08           O  
ATOM   2191  N   ILE B 127      -8.900  -5.017  23.188  1.00 43.46           N  
ATOM   2192  CA  ILE B 127      -7.726  -4.181  23.028  1.00 42.71           C  
ATOM   2193  C   ILE B 127      -7.571  -3.287  24.265  1.00 41.52           C  
ATOM   2194  O   ILE B 127      -6.464  -3.123  24.792  1.00 41.30           O  
ATOM   2195  CB  ILE B 127      -7.820  -3.304  21.735  1.00 43.23           C  
ATOM   2196  CG1 ILE B 127      -8.123  -4.152  20.480  1.00 44.13           C  
ATOM   2197  CG2 ILE B 127      -6.576  -2.428  21.563  1.00 43.45           C  
ATOM   2198  CD1 ILE B 127      -7.175  -5.321  20.228  1.00 45.58           C  
ATOM   2199  N   ILE B 128      -8.691  -2.740  24.733  1.00 39.95           N  
ATOM   2200  CA  ILE B 128      -8.684  -1.686  25.754  1.00 38.93           C  
ATOM   2201  C   ILE B 128      -8.377  -2.191  27.169  1.00 38.03           C  
ATOM   2202  O   ILE B 128      -7.689  -1.509  27.936  1.00 37.61           O  
ATOM   2203  CB  ILE B 128     -10.001  -0.852  25.725  1.00 39.02           C  
ATOM   2204  CG1 ILE B 128     -10.009   0.041  24.489  1.00 39.97           C  
ATOM   2205  CG2 ILE B 128     -10.134   0.038  26.968  1.00 38.04           C  
ATOM   2206  CD1 ILE B 128     -11.402   0.483  24.065  1.00 42.98           C  
ATOM   2207  N   GLN B 129      -8.870  -3.381  27.504  1.00 36.58           N  
ATOM   2208  CA  GLN B 129      -8.781  -3.876  28.879  1.00 36.22           C  
ATOM   2209  C   GLN B 129      -7.351  -3.980  29.464  1.00 35.31           C  
ATOM   2210  O   GLN B 129      -7.128  -3.529  30.578  1.00 35.30           O  
ATOM   2211  CB  GLN B 129      -9.580  -5.174  29.072  1.00 35.98           C  
ATOM   2212  CG  GLN B 129      -9.842  -5.517  30.528  1.00 37.18           C  
ATOM   2213  CD  GLN B 129     -10.524  -4.384  31.318  1.00 38.50           C  
ATOM   2214  OE1 GLN B 129     -11.450  -3.728  30.827  1.00 38.12           O  
ATOM   2215  NE2 GLN B 129     -10.066  -4.168  32.552  1.00 37.43           N  
ATOM   2216  N   PRO B 130      -6.393  -4.583  28.726  1.00 34.69           N  
ATOM   2217  CA  PRO B 130      -5.015  -4.603  29.238  1.00 34.36           C  
ATOM   2218  C   PRO B 130      -4.398  -3.204  29.458  1.00 33.39           C  
ATOM   2219  O   PRO B 130      -3.597  -3.024  30.362  1.00 32.94           O  
ATOM   2220  CB  PRO B 130      -4.252  -5.396  28.158  1.00 34.49           C  
ATOM   2221  CG  PRO B 130      -5.313  -6.248  27.493  1.00 34.83           C  
ATOM   2222  CD  PRO B 130      -6.496  -5.315  27.449  1.00 34.95           C  
ATOM   2223  N   LEU B 131      -4.786  -2.232  28.639  1.00 33.23           N  
ATOM   2224  CA  LEU B 131      -4.384  -0.828  28.814  1.00 33.03           C  
ATOM   2225  C   LEU B 131      -4.910  -0.219  30.128  1.00 32.80           C  
ATOM   2226  O   LEU B 131      -4.241   0.596  30.774  1.00 32.43           O  
ATOM   2227  CB  LEU B 131      -4.859   0.004  27.624  1.00 32.75           C  
ATOM   2228  CG  LEU B 131      -4.363  -0.379  26.224  1.00 33.30           C  
ATOM   2229  CD1 LEU B 131      -4.952   0.561  25.182  1.00 34.22           C  
ATOM   2230  CD2 LEU B 131      -2.837  -0.353  26.134  1.00 33.52           C  
ATOM   2231  N   LEU B 132      -6.120  -0.618  30.502  1.00 32.17           N  
ATOM   2232  CA  LEU B 132      -6.728  -0.175  31.740  1.00 31.71           C  
ATOM   2233  C   LEU B 132      -6.055  -0.876  32.920  1.00 31.51           C  
ATOM   2234  O   LEU B 132      -5.697  -0.232  33.903  1.00 31.46           O  
ATOM   2235  CB  LEU B 132      -8.235  -0.447  31.715  1.00 31.75           C  
ATOM   2236  CG  LEU B 132      -9.125   0.541  30.943  1.00 31.50           C  
ATOM   2237  CD1 LEU B 132     -10.579   0.045  30.931  1.00 29.84           C  
ATOM   2238  CD2 LEU B 132      -9.037   1.929  31.576  1.00 30.84           C  
ATOM   2239  N   ASP B 133      -5.873  -2.192  32.807  1.00 31.25           N  
ATOM   2240  CA  ASP B 133      -5.120  -2.972  33.797  1.00 31.33           C  
ATOM   2241  C   ASP B 133      -3.735  -2.365  34.075  1.00 31.43           C  
ATOM   2242  O   ASP B 133      -3.327  -2.260  35.231  1.00 31.37           O  
ATOM   2243  CB  ASP B 133      -5.008  -4.445  33.364  1.00 30.95           C  
ATOM   2244  CG  ASP B 133      -6.366  -5.157  33.299  1.00 31.86           C  
ATOM   2245  OD1 ASP B 133      -7.387  -4.593  33.769  1.00 30.36           O  
ATOM   2246  OD2 ASP B 133      -6.409  -6.291  32.764  1.00 31.94           O  
ATOM   2247  N   MET B 134      -3.038  -1.950  33.011  1.00 31.77           N  
ATOM   2248  CA  MET B 134      -1.730  -1.280  33.096  0.50 32.35           C  
ATOM   2250  C   MET B 134      -1.750  -0.047  34.001  1.00 32.01           C  
ATOM   2251  O   MET B 134      -0.863   0.154  34.825  1.00 31.89           O  
ATOM   2252  CB  MET B 134      -1.271  -0.828  31.707  0.50 32.46           C  
ATOM   2254  CG  MET B 134      -0.599  -1.878  30.848  0.50 32.52           C  
ATOM   2256  SD  MET B 134      -0.508  -1.326  29.119  0.50 34.08           S  
ATOM   2258  CE  MET B 134       0.692  -0.002  29.232  0.50 32.62           C  
ATOM   2260  N   ALA B 135      -2.756   0.805  33.805  1.00 32.05           N  
ATOM   2261  CA  ALA B 135      -2.939   2.031  34.609  1.00 32.27           C  
ATOM   2262  C   ALA B 135      -3.209   1.728  36.077  1.00 32.01           C  
ATOM   2263  O   ALA B 135      -2.671   2.396  36.971  1.00 32.55           O  
ATOM   2264  CB  ALA B 135      -4.088   2.889  34.037  1.00 32.22           C  
ATOM   2265  N   ALA B 136      -4.056   0.733  36.323  1.00 31.80           N  
ATOM   2266  CA  ALA B 136      -4.357   0.282  37.683  1.00 31.99           C  
ATOM   2267  C   ALA B 136      -3.127  -0.269  38.420  1.00 32.51           C  
ATOM   2268  O   ALA B 136      -2.910   0.044  39.595  1.00 32.35           O  
ATOM   2269  CB  ALA B 136      -5.461  -0.754  37.659  1.00 31.52           C  
ATOM   2270  N   ALA B 137      -2.336  -1.092  37.727  1.00 32.90           N  
ATOM   2271  CA  ALA B 137      -1.164  -1.720  38.337  1.00 33.63           C  
ATOM   2272  C   ALA B 137      -0.118  -0.662  38.703  1.00 33.95           C  
ATOM   2273  O   ALA B 137       0.607  -0.806  39.684  1.00 33.25           O  
ATOM   2274  CB  ALA B 137      -0.569  -2.785  37.406  1.00 33.60           C  
ATOM   2275  N   LEU B 138      -0.079   0.415  37.923  1.00 34.89           N  
ATOM   2276  CA  LEU B 138       0.793   1.554  38.214  1.00 35.96           C  
ATOM   2277  C   LEU B 138       0.513   2.232  39.555  1.00 36.58           C  
ATOM   2278  O   LEU B 138       1.422   2.811  40.156  1.00 36.80           O  
ATOM   2279  CB  LEU B 138       0.702   2.598  37.096  1.00 36.03           C  
ATOM   2280  CG  LEU B 138       1.447   2.321  35.792  1.00 36.07           C  
ATOM   2281  CD1 LEU B 138       1.406   3.573  34.934  1.00 36.93           C  
ATOM   2282  CD2 LEU B 138       2.891   1.873  36.007  1.00 35.72           C  
ATOM   2283  N   GLU B 139      -0.737   2.162  40.020  1.00 37.35           N  
ATOM   2284  CA  GLU B 139      -1.135   2.810  41.276  1.00 38.10           C  
ATOM   2285  C   GLU B 139      -0.740   1.968  42.482  1.00 38.72           C  
ATOM   2286  O   GLU B 139      -0.629   2.481  43.608  1.00 38.97           O  
ATOM   2287  CB  GLU B 139      -2.644   3.086  41.305  1.00 37.97           C  
ATOM   2288  CG  GLU B 139      -3.218   3.806  40.077  1.00 38.70           C  
ATOM   2289  CD  GLU B 139      -2.717   5.248  39.890  1.00 39.89           C  
ATOM   2290  OE1 GLU B 139      -2.175   5.854  40.840  1.00 41.76           O  
ATOM   2291  OE2 GLU B 139      -2.879   5.784  38.774  1.00 41.85           O  
ATOM   2292  N   HIS B 140      -0.529   0.674  42.245  1.00 39.18           N  
ATOM   2293  CA  HIS B 140      -0.143  -0.247  43.312  1.00 39.86           C  
ATOM   2294  C   HIS B 140       1.376  -0.370  43.441  1.00 40.57           C  
ATOM   2295  O   HIS B 140       1.880  -1.080  44.315  1.00 40.90           O  
ATOM   2296  CB  HIS B 140      -0.805  -1.610  43.114  1.00 39.43           C  
ATOM   2297  CG  HIS B 140      -2.304  -1.558  43.137  1.00 39.27           C  
ATOM   2298  ND1 HIS B 140      -3.025  -1.409  44.302  1.00 38.26           N  
ATOM   2299  CD2 HIS B 140      -3.215  -1.632  42.137  1.00 38.02           C  
ATOM   2300  CE1 HIS B 140      -4.316  -1.401  44.021  1.00 38.54           C  
ATOM   2301  NE2 HIS B 140      -4.458  -1.531  42.714  1.00 37.99           N  
ATOM   2302  N   HIS B 141       2.091   0.353  42.584  1.00 41.53           N  
ATOM   2303  CA  HIS B 141       3.553   0.359  42.577  1.00 42.64           C  
ATOM   2304  C   HIS B 141       4.104   1.781  42.653  1.00 42.83           C  
ATOM   2305  O   HIS B 141       4.641   2.185  43.690  1.00 43.43           O  
ATOM   2306  CB  HIS B 141       4.095  -0.370  41.336  1.00 42.84           C  
ATOM   2307  CG  HIS B 141       3.659  -1.802  41.243  1.00 44.21           C  
ATOM   2308  ND1 HIS B 141       2.881  -2.279  40.209  1.00 45.34           N  
ATOM   2309  CD2 HIS B 141       3.872  -2.855  42.068  1.00 45.40           C  
ATOM   2310  CE1 HIS B 141       2.638  -3.564  40.397  1.00 44.98           C  
ATOM   2311  NE2 HIS B 141       3.231  -3.939  41.517  1.00 46.32           N  
TER    2312      HIS B 141                                                      
END
MOLECULE T0443.pdb
ATOM      1  N   LEU    31      17.573  12.561  -4.844  1.00 44.52           N  
ATOM      2  CA  LEU    31      16.276  12.957  -4.211  1.00 43.54           C  
ATOM      3  C   LEU    31      15.334  13.605  -5.268  1.00 43.20           C  
ATOM      4  O   LEU    31      15.322  14.825  -5.467  1.00 43.85           O  
ATOM      5  CB  LEU    31      16.564  13.888  -3.031  1.00 44.76           C  
ATOM      6  CG  LEU    31      15.563  13.836  -1.877  1.00 45.52           C  
ATOM      7  CD1 LEU    31      16.076  14.602  -0.669  1.00 45.49           C  
ATOM      8  CD2 LEU    31      14.212  14.362  -2.329  1.00 46.09           C  
ATOM      9  N   ASN    32      14.528  12.772  -5.920  1.00 41.03           N  
ATOM     10  CA  ASN    32      13.645  13.222  -7.005  1.00 40.05           C  
ATOM     11  C   ASN    32      12.429  14.110  -6.613  1.00 38.84           C  
ATOM     12  O   ASN    32      12.146  14.344  -5.433  1.00 38.46           O  
ATOM     13  CB  ASN    32      13.254  12.027  -7.901  1.00 39.14           C  
ATOM     14  CG  ASN    32      12.441  10.973  -7.181  1.00 38.38           C  
ATOM     15  OD1 ASN    32      11.411  11.270  -6.598  1.00 37.94           O  
ATOM     16  ND2 ASN    32      12.869   9.722  -7.280  1.00 37.45           N  
ATOM     17  N   VAL    33      11.736  14.625  -7.619  1.00 37.57           N  
ATOM     18  CA  VAL    33      10.610  15.536  -7.400  1.00 37.88           C  
ATOM     19  C   VAL    33       9.437  14.879  -6.622  1.00 38.17           C  
ATOM     20  O   VAL    33       8.710  15.567  -5.895  1.00 37.81           O  
ATOM     21  CB  VAL    33      10.146  16.171  -8.752  1.00 37.94           C  
ATOM     22  CG1 VAL    33       9.582  15.124  -9.669  1.00 38.16           C  
ATOM     23  CG2 VAL    33       9.120  17.263  -8.531  1.00 38.67           C  
ATOM     24  N   TYR    34       9.279  13.557  -6.782  1.00 37.61           N  
ATOM     25  CA  TYR    34       8.266  12.775  -6.094  1.00 36.92           C  
ATOM     26  C   TYR    34       8.579  12.641  -4.591  1.00 36.39           C  
ATOM     27  O   TYR    34       7.687  12.801  -3.752  1.00 34.21           O  
ATOM     28  CB  TYR    34       8.075  11.388  -6.771  1.00 38.00           C  
ATOM     29  CG  TYR    34       7.128  10.484  -6.007  1.00 38.31           C  
ATOM     30  CD1 TYR    34       5.763  10.731  -6.001  1.00 38.37           C  
ATOM     31  CD2 TYR    34       7.603   9.409  -5.247  1.00 38.86           C  
ATOM     32  CE1 TYR    34       4.897   9.949  -5.275  1.00 38.25           C  
ATOM     33  CE2 TYR    34       6.723   8.608  -4.515  1.00 38.40           C  
ATOM     34  CZ  TYR    34       5.373   8.890  -4.541  1.00 38.20           C  
ATOM     35  OH  TYR    34       4.470   8.131  -3.816  1.00 38.57           O  
ATOM     36  N   ILE    35       9.843  12.364  -4.260  1.00 36.54           N  
ATOM     37  CA  ILE    35      10.288  12.240  -2.863  1.00 36.34           C  
ATOM     38  C   ILE    35      10.135  13.583  -2.136  1.00 36.17           C  
ATOM     39  O   ILE    35       9.784  13.613  -0.947  1.00 33.51           O  
ATOM     40  CB  ILE    35      11.752  11.733  -2.758  1.00 36.54           C  
ATOM     41  CG1 ILE    35      11.904  10.342  -3.389  1.00 37.22           C  
ATOM     42  CG2 ILE    35      12.213  11.660  -1.319  1.00 36.22           C  
ATOM     43  CD1 ILE    35      11.129   9.223  -2.697  1.00 37.21           C  
ATOM     44  N   ARG    36      10.384  14.682  -2.853  1.00 36.24           N  
ATOM     45  CA  ARG    36      10.229  16.021  -2.282  1.00 38.06           C  
ATOM     46  C   ARG    36       8.748  16.345  -2.052  1.00 37.48           C  
ATOM     47  O   ARG    36       8.398  16.972  -1.052  1.00 37.67           O  
ATOM     48  CB  ARG    36      10.871  17.107  -3.160  1.00 39.21           C  
ATOM     49  CG  ARG    36      12.394  17.179  -3.103  1.00 40.33           C  
ATOM     50  CD  ARG    36      12.932  18.438  -3.830  1.00 40.62           C  
ATOM     51  NE  ARG    36      14.375  18.634  -3.621  1.00 41.51           N  
ATOM     52  N   LEU    37       7.889  15.935  -2.986  1.00 36.32           N  
ATOM     53  CA  LEU    37       6.453  16.135  -2.845  1.00 35.88           C  
ATOM     54  C   LEU    37       5.916  15.380  -1.619  1.00 35.36           C  
ATOM     55  O   LEU    37       5.257  15.979  -0.779  1.00 34.58           O  
ATOM     56  CB  LEU    37       5.706  15.722  -4.133  1.00 35.78           C  
ATOM     57  CG  LEU    37       4.184  15.878  -4.172  1.00 35.65           C  
ATOM     58  CD1 LEU    37       3.787  17.308  -3.838  1.00 35.55           C  
ATOM     59  CD2 LEU    37       3.612  15.476  -5.538  1.00 35.55           C  
ATOM     60  N   ILE    38       6.220  14.087  -1.496  1.00 35.62           N  
ATOM     61  CA  ILE    38       5.716  13.300  -0.358  1.00 36.20           C  
ATOM     62  C   ILE    38       6.279  13.740   0.980  1.00 35.39           C  
ATOM     63  O   ILE    38       5.596  13.602   1.985  1.00 32.16           O  
ATOM     64  CB  ILE    38       5.862  11.741  -0.511  1.00 36.97           C  
ATOM     65  CG1 ILE    38       7.303  11.292  -0.676  1.00 37.64           C  
ATOM     66  CG2 ILE    38       5.047  11.239  -1.654  1.00 37.31           C  
ATOM     67  CD1 ILE    38       7.441   9.799  -1.046  1.00 37.85           C  
ATOM     68  N   ARG    39       7.516  14.251   1.004  1.00 35.25           N  
ATOM     69  CA  ARG    39       8.075  14.794   2.240  1.00 35.73           C  
ATOM     70  C   ARG    39       7.334  16.062   2.652  1.00 35.39           C  
ATOM     71  O   ARG    39       7.077  16.255   3.830  1.00 35.59           O  
ATOM     72  CB  ARG    39       9.586  15.035   2.153  1.00 36.43           C  
ATOM     73  CG  ARG    39      10.399  13.758   2.251  1.00 36.58           C  
ATOM     74  CD  ARG    39      11.892  14.023   2.215  1.00 37.77           C  
ATOM     75  NE  ARG    39      12.614  12.754   2.225  1.00 38.50           N  
ATOM     76  CZ  ARG    39      13.918  12.612   2.442  1.00 39.28           C  
ATOM     77  NH1 ARG    39      14.675  13.665   2.717  1.00 39.99           N  
ATOM     78  NH2 ARG    39      14.456  11.393   2.422  1.00 39.30           N  
ATOM     79  N   ASN    40       6.974  16.919   1.701  1.00 36.47           N  
ATOM     80  CA  ASN    40       6.147  18.102   2.036  1.00 37.87           C  
ATOM     81  C   ASN    40       4.726  17.728   2.520  1.00 36.33           C  
ATOM     82  O   ASN    40       4.179  18.387   3.394  1.00 36.31           O  
ATOM     83  CB  ASN    40       6.085  19.098   0.869  1.00 39.93           C  
ATOM     84  CG  ASN    40       7.362  19.912   0.735  1.00 41.61           C  
ATOM     85  OD1 ASN    40       8.083  20.134   1.718  1.00 43.85           O  
ATOM     86  ND2 ASN    40       7.649  20.366  -0.476  1.00 43.10           N  
ATOM     87  N   ASN    41       4.158  16.664   1.961  1.00 34.58           N  
ATOM     88  CA  ASN    41       2.842  16.183   2.368  1.00 34.12           C  
ATOM     89  C   ASN    41       2.913  15.549   3.749  1.00 33.10           C  
ATOM     90  O   ASN    41       1.945  15.575   4.474  1.00 32.27           O  
ATOM     91  CB  ASN    41       2.268  15.183   1.366  1.00 33.77           C  
ATOM     92  CG  ASN    41       1.945  15.805   0.030  1.00 33.71           C  
ATOM     93  OD1 ASN    41       2.195  17.001  -0.204  1.00 33.95           O  
ATOM     94  ND2 ASN    41       1.369  14.997  -0.866  1.00 32.28           N  
ATOM     95  N   ILE    42       4.072  14.993   4.101  1.00 33.48           N  
ATOM     96  CA  ILE    42       4.303  14.426   5.441  1.00 34.18           C  
ATOM     97  C   ILE    42       4.342  15.558   6.499  1.00 34.18           C  
ATOM     98  O   ILE    42       3.648  15.515   7.514  1.00 35.39           O  
ATOM     99  CB  ILE    42       5.594  13.538   5.461  1.00 33.79           C  
ATOM    100  CG1 ILE    42       5.329  12.238   4.687  1.00 34.00           C  
ATOM    101  CG2 ILE    42       6.026  13.205   6.893  1.00 33.13           C  
ATOM    102  CD1 ILE    42       6.466  11.222   4.689  1.00 34.19           C  
ATOM    103  N   HIS    43       5.149  16.568   6.237  1.00 35.51           N  
ATOM    104  CA  HIS    43       5.255  17.746   7.103  1.00 36.15           C  
ATOM    105  C   HIS    43       3.855  18.338   7.336  1.00 35.62           C  
ATOM    106  O   HIS    43       3.429  18.481   8.471  1.00 35.79           O  
ATOM    107  CB  HIS    43       6.215  18.782   6.479  1.00 37.26           C  
ATOM    108  CG  HIS    43       7.670  18.420   6.591  1.00 38.69           C  
ATOM    109  ND1 HIS    43       8.613  19.272   7.130  1.00 40.26           N  
ATOM    110  CD2 HIS    43       8.341  17.288   6.266  1.00 39.87           C  
ATOM    111  CE1 HIS    43       9.802  18.692   7.106  1.00 39.55           C  
ATOM    112  NE2 HIS    43       9.663  17.483   6.595  1.00 38.90           N  
ATOM    113  N   SER    44       3.126  18.615   6.257  1.00 34.74           N  
ATOM    114  CA  SER    44       1.788  19.203   6.325  1.00 34.39           C  
ATOM    115  C   SER    44       0.743  18.397   7.093  1.00 33.88           C  
ATOM    116  O   SER    44      -0.125  18.968   7.767  1.00 33.16           O  
ATOM    117  CB  SER    44       1.270  19.419   4.904  1.00 35.00           C  
ATOM    118  OG  SER    44       2.093  20.322   4.212  1.00 35.16           O  
ATOM    119  N   PHE    45       0.811  17.070   6.958  1.00 32.94           N  
ATOM    120  CA  PHE    45      -0.109  16.147   7.632  1.00 31.66           C  
ATOM    121  C   PHE    45       0.177  16.082   9.140  1.00 31.61           C  
ATOM    122  O   PHE    45      -0.750  16.119   9.963  1.00 30.31           O  
ATOM    123  CB  PHE    45       0.002  14.770   6.952  1.00 31.68           C  
ATOM    124  CG  PHE    45      -1.033  13.783   7.354  1.00 31.49           C  
ATOM    125  CD1 PHE    45      -2.238  14.163   7.952  1.00 32.31           C  
ATOM    126  CD2 PHE    45      -0.843  12.442   7.054  1.00 32.43           C  
ATOM    127  CE1 PHE    45      -3.200  13.211   8.299  1.00 32.72           C  
ATOM    128  CE2 PHE    45      -1.813  11.488   7.375  1.00 31.99           C  
ATOM    129  CZ  PHE    45      -2.991  11.877   8.005  1.00 32.00           C  
ATOM    130  N   ILE    46       1.458  15.962   9.493  1.00 30.96           N  
ATOM    131  CA  ILE    46       1.905  16.018  10.883  1.00 30.52           C  
ATOM    132  C   ILE    46       1.479  17.353  11.545  1.00 31.33           C  
ATOM    133  O   ILE    46       0.934  17.352  12.654  1.00 30.46           O  
ATOM    134  CB  ILE    46       3.453  15.778  10.976  1.00 30.24           C  
ATOM    135  CG1 ILE    46       3.761  14.284  10.784  1.00 29.75           C  
ATOM    136  CG2 ILE    46       4.049  16.323  12.284  1.00 28.54           C  
ATOM    137  CD1 ILE    46       5.233  14.026  10.605  1.00 30.42           C  
ATOM    138  N   ASP    47       1.700  18.483  10.874  1.00 32.29           N  
ATOM    139  CA  ASP    47       1.259  19.775  11.432  1.00 33.40           C  
ATOM    140  C   ASP    47      -0.249  19.769  11.718  1.00 34.76           C  
ATOM    141  O   ASP    47      -0.711  20.336  12.700  1.00 35.50           O  
ATOM    142  CB  ASP    47       1.567  20.954  10.495  1.00 33.10           C  
ATOM    143  CG  ASP    47       3.051  21.253  10.364  1.00 33.77           C  
ATOM    144  OD1 ASP    47       3.838  20.610  11.062  1.00 32.98           O  
ATOM    145  OD2 ASP    47       3.431  22.151   9.555  1.00 33.38           O  
ATOM    146  N   ARG    48      -1.011  19.137  10.842  1.00 36.67           N  
ATOM    147  CA  ARG    48      -2.471  19.075  10.991  1.00 38.26           C  
ATOM    148  C   ARG    48      -2.949  18.137  12.107  1.00 36.84           C  
ATOM    149  O   ARG    48      -3.879  18.476  12.833  1.00 36.39           O  
ATOM    150  CB  ARG    48      -3.131  18.760   9.638  1.00 38.90           C  
ATOM    151  CG  ARG    48      -3.001  19.956   8.648  1.00 40.27           C  
ATOM    152  CD  ARG    48      -3.502  19.648   7.238  1.00 41.33           C  
ATOM    153  NE  ARG    48      -3.830  20.897   6.526  1.00 42.67           N  
ATOM    154  CZ  ARG    48      -3.237  21.394   5.429  1.00 43.11           C  
ATOM    155  NH1 ARG    48      -2.255  20.752   4.765  1.00 43.47           N  
ATOM    156  NH2 ARG    48      -3.677  22.555   4.947  1.00 42.85           N  
ATOM    157  N   CYS    49      -2.312  16.978  12.247  1.00 35.74           N  
ATOM    158  CA  CYS    49      -2.692  16.011  13.265  0.50 35.05           C  
ATOM    160  C   CYS    49      -2.218  16.408  14.677  1.00 34.67           C  
ATOM    161  O   CYS    49      -2.892  16.146  15.648  1.00 34.22           O  
ATOM    162  CB  CYS    49      -2.126  14.645  12.891  0.50 34.91           C  
ATOM    164  SG  CYS    49      -2.601  13.326  14.001  0.50 35.32           S  
ATOM    166  N   TYR    50      -1.063  17.058  14.775  1.00 35.09           N  
ATOM    167  CA  TYR    50      -0.494  17.396  16.080  1.00 33.36           C  
ATOM    168  C   TYR    50      -0.430  18.881  16.384  1.00 33.94           C  
ATOM    169  O   TYR    50       0.615  19.402  16.813  1.00 32.29           O  
ATOM    170  CB  TYR    50       0.873  16.729  16.193  1.00 30.87           C  
ATOM    171  CG  TYR    50       0.785  15.191  16.130  1.00 30.70           C  
ATOM    172  CD1 TYR    50       0.368  14.444  17.224  1.00 29.65           C  
ATOM    173  CD2 TYR    50       1.122  14.505  14.979  1.00 29.84           C  
ATOM    174  CE1 TYR    50       0.300  13.036  17.160  1.00 30.64           C  
ATOM    175  CE2 TYR    50       1.067  13.125  14.914  1.00 30.22           C  
ATOM    176  CZ  TYR    50       0.657  12.387  16.003  1.00 30.31           C  
ATOM    177  OH  TYR    50       0.616  11.003  15.910  1.00 30.32           O  
ATOM    178  N   THR    51      -1.587  19.532  16.227  1.00 34.38           N  
ATOM    179  CA  THR    51      -1.742  20.985  16.448  1.00 35.46           C  
ATOM    180  C   THR    51      -1.497  21.472  17.885  1.00 35.45           C  
ATOM    181  O   THR    51      -0.948  22.564  18.068  1.00 35.69           O  
ATOM    182  CB  THR    51      -3.129  21.474  15.967  1.00 36.40           C  
ATOM    183  OG1 THR    51      -4.121  20.496  16.344  1.00 36.73           O  
ATOM    184  CG2 THR    51      -3.136  21.638  14.446  1.00 36.23           C  
ATOM    185  N   GLU    52      -1.910  20.685  18.886  1.00 35.22           N  
ATOM    186  CA  GLU    52      -1.650  21.027  20.297  1.00 35.46           C  
ATOM    187  C   GLU    52      -0.168  20.764  20.634  1.00 33.96           C  
ATOM    188  O   GLU    52       0.519  21.638  21.119  1.00 33.70           O  
ATOM    189  CB  GLU    52      -2.557  20.253  21.259  1.00 36.10           C  
ATOM    190  CG  GLU    52      -4.049  20.464  21.051  1.00 37.71           C  
ATOM    191  CD  GLU    52      -4.491  21.909  21.293  1.00 39.84           C  
ATOM    192  OE1 GLU    52      -3.813  22.624  22.080  1.00 39.57           O  
ATOM    193  OE2 GLU    52      -5.533  22.317  20.703  1.00 41.37           O  
ATOM    194  N   THR    53       0.314  19.561  20.359  1.00 33.44           N  
ATOM    195  CA  THR    53       1.717  19.215  20.623  1.00 33.65           C  
ATOM    196  C   THR    53       2.652  20.270  20.032  1.00 35.50           C  
ATOM    197  O   THR    53       3.551  20.752  20.716  1.00 36.21           O  
ATOM    198  CB  THR    53       2.055  17.799  20.061  1.00 32.37           C  
ATOM    199  OG1 THR    53       1.103  16.860  20.555  1.00 28.94           O  
ATOM    200  CG2 THR    53       3.457  17.348  20.430  1.00 31.86           C  
ATOM    201  N   ARG    54       2.399  20.661  18.779  1.00 37.65           N  
ATOM    202  CA  ARG    54       3.207  21.652  18.062  1.00 38.57           C  
ATOM    203  C   ARG    54       3.445  22.944  18.847  1.00 39.99           C  
ATOM    204  O   ARG    54       4.480  23.581  18.707  1.00 38.14           O  
ATOM    205  N   GLN    55       2.475  23.311  19.677  1.00 41.69           N  
ATOM    206  CA  GLN    55       2.568  24.516  20.510  1.00 42.42           C  
ATOM    207  C   GLN    55       3.557  24.436  21.671  1.00 41.81           C  
ATOM    208  O   GLN    55       3.893  25.458  22.249  1.00 42.84           O  
ATOM    209  CB  GLN    55       1.183  24.930  21.012  1.00 42.92           C  
ATOM    210  CG  GLN    55       0.360  25.547  19.897  1.00 43.71           C  
ATOM    211  CD  GLN    55      -1.083  25.734  20.269  1.00 43.68           C  
ATOM    212  OE1 GLN    55      -1.779  24.780  20.626  1.00 44.23           O  
ATOM    213  NE2 GLN    55      -1.560  26.971  20.157  1.00 44.84           N  
ATOM    214  N   TYR    56       4.044  23.246  22.001  1.00 40.40           N  
ATOM    215  CA  TYR    56       5.030  23.112  23.077  1.00 39.48           C  
ATOM    216  C   TYR    56       6.439  23.213  22.534  1.00 38.45           C  
ATOM    217  O   TYR    56       7.402  23.108  23.278  1.00 37.75           O  
ATOM    218  CB  TYR    56       4.824  21.797  23.847  1.00 39.65           C  
ATOM    219  CG  TYR    56       3.604  21.840  24.727  1.00 39.51           C  
ATOM    220  CD1 TYR    56       2.355  21.497  24.231  1.00 39.63           C  
ATOM    221  CD2 TYR    56       3.696  22.253  26.052  1.00 39.81           C  
ATOM    222  CE1 TYR    56       1.227  21.541  25.030  1.00 40.29           C  
ATOM    223  CE2 TYR    56       2.564  22.307  26.874  1.00 39.69           C  
ATOM    224  CZ  TYR    56       1.339  21.957  26.356  1.00 39.71           C  
ATOM    225  OH  TYR    56       0.225  22.012  27.144  1.00 40.05           O  
ATOM    226  N   PHE    57       6.555  23.413  21.225  1.00 38.66           N  
ATOM    227  CA  PHE    57       7.840  23.551  20.595  1.00 38.68           C  
ATOM    228  C   PHE    57       7.989  24.877  19.837  1.00 39.20           C  
ATOM    229  O   PHE    57       7.023  25.580  19.531  1.00 38.81           O  
ATOM    230  CB  PHE    57       8.104  22.384  19.641  1.00 38.40           C  
ATOM    231  CG  PHE    57       8.050  21.042  20.301  1.00 38.59           C  
ATOM    232  CD1 PHE    57       9.195  20.487  20.870  1.00 38.43           C  
ATOM    233  CD2 PHE    57       6.868  20.320  20.343  1.00 38.43           C  
ATOM    234  CE1 PHE    57       9.148  19.242  21.488  1.00 38.66           C  
ATOM    235  CE2 PHE    57       6.822  19.067  20.963  1.00 38.81           C  
ATOM    236  CZ  PHE    57       7.960  18.530  21.526  1.00 38.33           C  
ATOM    237  N   ASP    58       9.249  25.178  19.569  1.00 39.49           N  
ATOM    238  CA  ASP    58       9.687  26.319  18.807  1.00 40.80           C  
ATOM    239  C   ASP    58       9.550  25.947  17.313  1.00 40.39           C  
ATOM    240  O   ASP    58       9.426  24.771  16.978  1.00 40.16           O  
ATOM    241  CB  ASP    58      11.164  26.534  19.150  1.00 41.80           C  
ATOM    242  CG  ASP    58      11.700  27.811  18.641  1.00 43.01           C  
ATOM    243  OD1 ASP    58      11.321  28.852  19.212  1.00 44.51           O  
ATOM    244  OD2 ASP    58      12.537  27.773  17.706  1.00 44.59           O  
ATOM    245  N   SER    59       9.598  26.939  16.423  1.00 40.58           N  
ATOM    246  CA  SER    59       9.544  26.696  14.972  1.00 40.21           C  
ATOM    247  C   SER    59      10.682  25.764  14.572  1.00 39.44           C  
ATOM    248  O   SER    59      10.452  24.739  13.919  1.00 38.38           O  
ATOM    249  CB  SER    59       9.709  28.003  14.200  1.00 40.59           C  
ATOM    250  OG  SER    59       9.024  29.054  14.842  1.00 41.19           O  
ATOM    251  N   LYS    60      11.898  26.117  15.007  1.00 39.20           N  
ATOM    252  CA  LYS    60      13.120  25.345  14.703  1.00 38.68           C  
ATOM    253  C   LYS    60      13.118  23.946  15.315  1.00 37.27           C  
ATOM    254  O   LYS    60      13.531  22.993  14.667  1.00 36.60           O  
ATOM    255  CB  LYS    60      14.383  26.099  15.151  1.00 39.13           C  
ATOM    256  CG  LYS    60      14.720  27.325  14.305  1.00 40.06           C  
ATOM    257  N   GLU    61      12.669  23.840  16.560  1.00 36.56           N  
ATOM    258  CA  GLU    61      12.586  22.563  17.268  1.00 37.10           C  
ATOM    259  C   GLU    61      11.598  21.610  16.586  1.00 36.59           C  
ATOM    260  O   GLU    61      11.863  20.415  16.428  1.00 36.60           O  
ATOM    261  CB  GLU    61      12.118  22.786  18.718  1.00 37.52           C  
ATOM    262  CG  GLU    61      13.033  23.614  19.614  1.00 38.05           C  
ATOM    263  CD  GLU    61      12.376  24.015  20.948  1.00 38.16           C  
ATOM    264  OE1 GLU    61      11.137  23.965  21.074  1.00 38.70           O  
ATOM    265  OE2 GLU    61      13.100  24.403  21.875  1.00 39.54           O  
ATOM    266  N   TRP    62      10.433  22.147  16.229  1.00 36.46           N  
ATOM    267  CA  TRP    62       9.401  21.386  15.547  1.00 36.63           C  
ATOM    268  C   TRP    62       9.892  20.915  14.161  1.00 36.33           C  
ATOM    269  O   TRP    62       9.733  19.743  13.817  1.00 35.34           O  
ATOM    270  CB  TRP    62       8.111  22.213  15.453  1.00 37.24           C  
ATOM    271  CG  TRP    62       6.932  21.469  14.891  1.00 37.24           C  
ATOM    272  CD1 TRP    62       6.334  21.691  13.702  1.00 37.51           C  
ATOM    273  CD2 TRP    62       6.219  20.376  15.506  1.00 37.80           C  
ATOM    274  NE1 TRP    62       5.285  20.818  13.525  1.00 37.79           N  
ATOM    275  CE2 TRP    62       5.194  19.995  14.614  1.00 37.74           C  
ATOM    276  CE3 TRP    62       6.352  19.683  16.720  1.00 37.51           C  
ATOM    277  CZ2 TRP    62       4.303  18.950  14.888  1.00 37.23           C  
ATOM    278  CZ3 TRP    62       5.479  18.647  16.992  1.00 37.58           C  
ATOM    279  CH2 TRP    62       4.459  18.288  16.076  1.00 37.52           C  
ATOM    280  N   SER    63      10.493  21.804  13.376  1.00 36.51           N  
ATOM    281  CA  SER    63      11.074  21.408  12.076  1.00 37.30           C  
ATOM    282  C   SER    63      12.163  20.307  12.223  1.00 37.53           C  
ATOM    283  O   SER    63      12.237  19.371  11.411  1.00 37.00           O  
ATOM    284  CB  SER    63      11.694  22.614  11.373  1.00 38.30           C  
ATOM    285  OG  SER    63      10.782  23.692  11.249  1.00 38.42           O  
ATOM    286  N   ARG    64      13.007  20.424  13.251  1.00 37.53           N  
ATOM    287  CA  ARG    64      14.038  19.412  13.517  1.00 37.52           C  
ATOM    288  C   ARG    64      13.444  18.039  13.756  1.00 37.48           C  
ATOM    289  O   ARG    64      13.940  17.056  13.228  1.00 37.42           O  
ATOM    290  CB  ARG    64      14.865  19.779  14.736  1.00 38.25           C  
ATOM    291  CG  ARG    64      15.668  21.020  14.585  1.00 38.50           C  
ATOM    292  CD  ARG    64      16.597  21.216  15.768  1.00 38.90           C  
ATOM    293  NE  ARG    64      17.124  22.568  15.726  1.00 39.25           N  
ATOM    294  CZ  ARG    64      16.975  23.495  16.661  1.00 39.76           C  
ATOM    295  NH1 ARG    64      16.388  23.227  17.826  1.00 40.58           N  
ATOM    296  NH2 ARG    64      17.496  24.698  16.449  1.00 40.34           N  
ATOM    297  N   LEU    65      12.396  17.969  14.584  1.00 38.01           N  
ATOM    298  CA  LEU    65      11.692  16.704  14.829  1.00 37.24           C  
ATOM    299  C   LEU    65      11.258  16.049  13.538  1.00 36.38           C  
ATOM    300  O   LEU    65      11.483  14.868  13.335  1.00 35.33           O  
ATOM    301  CB  LEU    65      10.460  16.895  15.732  1.00 37.31           C  
ATOM    302  CG  LEU    65      10.599  16.691  17.233  1.00 37.54           C  
ATOM    303  CD1 LEU    65       9.326  17.170  17.945  1.00 37.07           C  
ATOM    304  CD2 LEU    65      10.877  15.205  17.515  1.00 37.77           C  
ATOM    305  N   LYS    66      10.624  16.843  12.680  1.00 37.70           N  
ATOM    306  CA  LYS    66      10.108  16.406  11.382  1.00 37.64           C  
ATOM    307  C   LYS    66      11.188  16.018  10.374  1.00 38.01           C  
ATOM    308  O   LYS    66      10.989  15.080   9.570  1.00 37.34           O  
ATOM    309  CB  LYS    66       9.358  17.543  10.731  1.00 38.09           C  
ATOM    310  CG  LYS    66       7.972  17.860  11.209  1.00 39.27           C  
ATOM    311  CD  LYS    66       7.732  19.208  10.593  1.00 39.88           C  
ATOM    312  CE  LYS    66       6.376  19.665  10.584  1.00 40.20           C  
ATOM    313  NZ  LYS    66       6.469  21.084  10.090  1.00 40.11           N  
ATOM    314  N   GLU    67      12.273  16.793  10.341  1.00 37.69           N  
ATOM    315  CA  GLU    67      13.385  16.486   9.438  1.00 38.36           C  
ATOM    316  C   GLU    67      13.988  15.146   9.831  1.00 37.23           C  
ATOM    317  O   GLU    67      14.392  14.383   8.975  1.00 38.39           O  
ATOM    318  CB  GLU    67      14.461  17.582   9.439  1.00 40.22           C  
ATOM    319  CG  GLU    67      14.046  18.891   8.735  1.00 42.62           C  
ATOM    320  CD  GLU    67      13.709  18.696   7.245  1.00 44.55           C  
ATOM    321  OE1 GLU    67      14.081  17.641   6.674  1.00 45.14           O  
ATOM    322  OE2 GLU    67      13.063  19.598   6.648  1.00 45.94           O  
ATOM    323  N   GLY    68      14.034  14.860  11.128  1.00 36.08           N  
ATOM    324  CA  GLY    68      14.533  13.589  11.606  1.00 34.73           C  
ATOM    325  C   GLY    68      13.596  12.474  11.209  1.00 34.19           C  
ATOM    326  O   GLY    68      14.033  11.445  10.724  1.00 35.37           O  
ATOM    327  N   PHE    69      12.293  12.660  11.404  1.00 34.14           N  
ATOM    328  CA  PHE    69      11.337  11.622  11.016  1.00 32.94           C  
ATOM    329  C   PHE    69      11.440  11.264   9.516  1.00 33.21           C  
ATOM    330  O   PHE    69      11.539  10.090   9.139  1.00 33.26           O  
ATOM    331  CB  PHE    69       9.895  12.022  11.386  1.00 31.51           C  
ATOM    332  CG  PHE    69       8.870  11.040  10.920  1.00 30.14           C  
ATOM    333  CD1 PHE    69       8.871   9.741  11.402  1.00 30.28           C  
ATOM    334  CD2 PHE    69       7.921  11.398   9.993  1.00 31.00           C  
ATOM    335  CE1 PHE    69       7.939   8.802  10.963  1.00 29.64           C  
ATOM    336  CE2 PHE    69       6.975  10.480   9.560  1.00 30.27           C  
ATOM    337  CZ  PHE    69       6.984   9.174  10.049  1.00 30.55           C  
ATOM    338  N   VAL    70      11.447  12.287   8.678  1.00 34.13           N  
ATOM    339  CA  VAL    70      11.508  12.140   7.223  1.00 35.69           C  
ATOM    340  C   VAL    70      12.739  11.371   6.690  1.00 37.01           C  
ATOM    341  O   VAL    70      12.674  10.692   5.633  1.00 36.42           O  
ATOM    342  CB  VAL    70      11.400  13.534   6.590  1.00 36.04           C  
ATOM    343  CG1 VAL    70      12.194  13.615   5.360  1.00 37.99           C  
ATOM    344  CG2 VAL    70       9.930  13.898   6.375  1.00 36.51           C  
ATOM    345  N   ARG    71      13.834  11.481   7.445  1.00 38.47           N  
ATOM    346  CA  ARG    71      15.089  10.810   7.164  1.00 39.55           C  
ATOM    347  C   ARG    71      15.125   9.421   7.825  1.00 40.19           C  
ATOM    348  O   ARG    71      16.049   8.645   7.584  1.00 41.19           O  
ATOM    349  CB  ARG    71      16.255  11.677   7.654  1.00 39.14           C  
ATOM    350  CG  ARG    71      16.354  13.038   6.934  1.00 39.56           C  
ATOM    351  CD  ARG    71      17.481  13.925   7.506  1.00 39.89           C  
ATOM    352  N   ASP    72      14.121   9.108   8.644  1.00 39.78           N  
ATOM    353  CA  ASP    72      14.038   7.814   9.335  1.00 39.54           C  
ATOM    354  C   ASP    72      13.268   6.793   8.485  1.00 39.00           C  
ATOM    355  O   ASP    72      12.421   7.170   7.701  1.00 38.39           O  
ATOM    356  CB  ASP    72      13.311   7.978  10.674  1.00 39.70           C  
ATOM    357  CG  ASP    72      13.405   6.751  11.544  1.00 39.57           C  
ATOM    358  OD1 ASP    72      14.490   6.519  12.112  1.00 41.05           O  
ATOM    359  OD2 ASP    72      12.394   6.044  11.691  1.00 38.99           O  
ATOM    360  N   ALA    73      13.565   5.506   8.700  1.00 39.88           N  
ATOM    361  CA  ALA    73      12.956   4.358   8.012  1.00 39.58           C  
ATOM    362  C   ALA    73      11.435   4.259   8.161  1.00 40.30           C  
ATOM    363  O   ALA    73      10.778   3.676   7.299  1.00 40.44           O  
ATOM    364  CB  ALA    73      13.602   3.052   8.497  1.00 38.45           C  
ATOM    365  N   ARG    74      10.887   4.785   9.258  1.00 41.15           N  
ATOM    366  CA  ARG    74       9.435   4.766   9.482  1.00 42.13           C  
ATOM    367  C   ARG    74       8.662   5.661   8.471  1.00 42.62           C  
ATOM    368  O   ARG    74       7.507   5.372   8.134  1.00 43.50           O  
ATOM    369  CB  ARG    74       9.093   5.167  10.927  1.00 42.17           C  
ATOM    370  CG  ARG    74       9.608   4.220  12.028  1.00 42.15           C  
ATOM    371  CD  ARG    74       9.162   4.710  13.414  1.00 42.78           C  
ATOM    372  NE  ARG    74       9.772   3.984  14.530  1.00 42.91           N  
ATOM    373  CZ  ARG    74      10.943   4.291  15.103  1.00 44.13           C  
ATOM    374  NH1 ARG    74      11.666   5.334  14.687  1.00 44.51           N  
ATOM    375  NH2 ARG    74      11.405   3.554  16.116  1.00 43.91           N  
ATOM    376  N   ALA    75       9.310   6.718   7.980  1.00 41.86           N  
ATOM    377  CA  ALA    75       8.706   7.632   7.020  1.00 41.40           C  
ATOM    378  C   ALA    75       8.813   7.115   5.574  1.00 41.62           C  
ATOM    379  O   ALA    75       8.490   7.834   4.645  1.00 41.03           O  
ATOM    380  CB  ALA    75       9.360   9.012   7.138  1.00 40.41           C  
ATOM    381  N   GLN    76       9.271   5.876   5.385  1.00 42.77           N  
ATOM    382  CA  GLN    76       9.394   5.270   4.046  1.00 43.01           C  
ATOM    383  C   GLN    76       8.172   4.430   3.693  1.00 41.84           C  
ATOM    384  O   GLN    76       8.153   3.750   2.677  1.00 41.81           O  
ATOM    385  CB  GLN    76      10.652   4.409   3.945  1.00 44.92           C  
ATOM    386  CG  GLN    76      11.922   5.115   4.407  1.00 46.84           C  
ATOM    387  CD  GLN    76      12.140   6.436   3.696  1.00 48.40           C  
ATOM    388  OE1 GLN    76      12.086   6.495   2.461  1.00 49.56           O  
ATOM    389  NE2 GLN    76      12.381   7.515   4.474  1.00 49.14           N  
ATOM    390  N   THR    77       7.147   4.478   4.533  1.00 40.41           N  
ATOM    391  CA  THR    77       5.914   3.745   4.263  1.00 39.71           C  
ATOM    392  C   THR    77       5.239   4.216   2.958  1.00 38.93           C  
ATOM    393  O   THR    77       5.185   5.422   2.674  1.00 39.12           O  
ATOM    394  CB  THR    77       4.882   3.875   5.431  1.00 39.07           C  
ATOM    395  OG1 THR    77       3.739   3.054   5.155  1.00 39.10           O  
ATOM    396  CG2 THR    77       4.428   5.356   5.650  1.00 38.80           C  
ATOM    397  N   PRO    78       4.757   3.259   2.143  1.00 38.60           N  
ATOM    398  CA  PRO    78       3.988   3.592   0.943  1.00 38.17           C  
ATOM    399  C   PRO    78       2.529   3.983   1.249  1.00 37.52           C  
ATOM    400  O   PRO    78       1.790   4.348   0.333  1.00 38.19           O  
ATOM    401  CB  PRO    78       4.035   2.299   0.143  1.00 38.03           C  
ATOM    402  CG  PRO    78       4.108   1.239   1.173  1.00 38.06           C  
ATOM    403  CD  PRO    78       4.953   1.802   2.274  1.00 38.18           C  
ATOM    404  N   TYR    79       2.117   3.909   2.512  1.00 37.30           N  
ATOM    405  CA  TYR    79       0.752   4.277   2.903  1.00 37.06           C  
ATOM    406  C   TYR    79       0.729   5.606   3.677  1.00 36.81           C  
ATOM    407  O   TYR    79       1.125   5.674   4.855  1.00 36.57           O  
ATOM    408  CB  TYR    79       0.107   3.170   3.732  1.00 37.18           C  
ATOM    409  CG  TYR    79       0.142   1.806   3.102  1.00 37.01           C  
ATOM    410  CD1 TYR    79      -0.799   1.433   2.159  1.00 37.18           C  
ATOM    411  CD2 TYR    79       1.108   0.873   3.473  1.00 37.97           C  
ATOM    412  CE1 TYR    79      -0.780   0.177   1.580  1.00 37.29           C  
ATOM    413  CE2 TYR    79       1.152  -0.395   2.884  1.00 37.76           C  
ATOM    414  CZ  TYR    79       0.196  -0.734   1.936  1.00 37.33           C  
ATOM    415  OH  TYR    79       0.210  -1.985   1.357  1.00 37.49           O  
ATOM    416  N   PHE    80       0.259   6.658   3.013  1.00 36.23           N  
ATOM    417  CA  PHE    80       0.154   7.999   3.603  1.00 37.21           C  
ATOM    418  C   PHE    80      -0.652   8.032   4.925  1.00 37.56           C  
ATOM    419  O   PHE    80      -0.373   8.865   5.779  1.00 37.45           O  
ATOM    420  CB  PHE    80      -0.451   8.953   2.561  1.00 35.97           C  
ATOM    421  CG  PHE    80      -0.577  10.387   3.018  1.00 35.89           C  
ATOM    422  CD1 PHE    80       0.526  11.231   3.016  1.00 35.13           C  
ATOM    423  CD2 PHE    80      -1.816  10.909   3.378  1.00 35.63           C  
ATOM    424  CE1 PHE    80       0.413  12.549   3.420  1.00 35.29           C  
ATOM    425  CE2 PHE    80      -1.941  12.238   3.780  1.00 35.65           C  
ATOM    426  CZ  PHE    80      -0.830  13.053   3.811  1.00 35.28           C  
ATOM    427  N   GLN    81      -1.641   7.136   5.068  1.00 39.01           N  
ATOM    428  CA  GLN    81      -2.531   7.009   6.266  1.00 39.99           C  
ATOM    429  C   GLN    81      -1.786   6.615   7.537  1.00 38.96           C  
ATOM    430  O   GLN    81      -2.204   6.938   8.667  1.00 37.94           O  
ATOM    431  CB  GLN    81      -3.658   5.969   6.004  1.00 41.53           C  
ATOM    432  CG  GLN    81      -3.152   4.521   5.724  1.00 43.63           C  
ATOM    433  CD  GLN    81      -4.045   3.686   4.773  1.00 44.28           C  
ATOM    434  OE1 GLN    81      -5.212   4.017   4.516  1.00 47.08           O  
ATOM    435  NE2 GLN    81      -3.480   2.592   4.251  1.00 45.82           N  
ATOM    436  N   GLU    82      -0.680   5.915   7.329  1.00 38.65           N  
ATOM    437  CA  GLU    82       0.175   5.459   8.401  1.00 38.49           C  
ATOM    438  C   GLU    82       1.183   6.493   8.904  1.00 37.28           C  
ATOM    439  O   GLU    82       1.880   6.211   9.861  1.00 37.02           O  
ATOM    440  CB  GLU    82       0.955   4.227   7.947  1.00 39.32           C  
ATOM    441  CG  GLU    82       0.111   3.044   7.580  1.00 40.06           C  
ATOM    442  CD  GLU    82       0.953   1.809   7.314  1.00 40.94           C  
ATOM    443  OE1 GLU    82       2.185   1.935   7.108  1.00 41.22           O  
ATOM    444  OE2 GLU    82       0.378   0.703   7.283  1.00 43.20           O  
ATOM    445  N   ILE    83       1.259   7.670   8.283  1.00 35.69           N  
ATOM    446  CA  ILE    83       2.240   8.696   8.679  1.00 34.80           C  
ATOM    447  C   ILE    83       2.067   9.259  10.105  1.00 34.57           C  
ATOM    448  O   ILE    83       3.036   9.266  10.849  1.00 36.43           O  
ATOM    449  CB  ILE    83       2.391   9.820   7.602  1.00 34.27           C  
ATOM    450  CG1 ILE    83       3.203   9.303   6.400  1.00 34.23           C  
ATOM    451  CG2 ILE    83       3.082  11.078   8.160  1.00 34.12           C  
ATOM    452  CD1 ILE    83       4.670   8.861   6.701  1.00 32.92           C  
ATOM    453  N   PRO    84       0.872   9.759  10.490  1.00 34.29           N  
ATOM    454  CA  PRO    84       0.691  10.257  11.858  1.00 34.05           C  
ATOM    455  C   PRO    84       1.080   9.271  12.960  1.00 32.73           C  
ATOM    456  O   PRO    84       1.689   9.668  13.927  1.00 32.82           O  
ATOM    457  CB  PRO    84      -0.802  10.568  11.910  1.00 34.36           C  
ATOM    458  CG  PRO    84      -1.102  10.935  10.545  1.00 34.73           C  
ATOM    459  CD  PRO    84      -0.364   9.955   9.716  1.00 34.31           C  
ATOM    460  N   GLY    85       0.731   8.000  12.794  1.00 31.91           N  
ATOM    461  CA  GLY    85       1.096   6.963  13.738  1.00 31.63           C  
ATOM    462  C   GLY    85       2.567   6.599  13.760  1.00 31.41           C  
ATOM    463  O   GLY    85       3.090   6.201  14.810  1.00 33.41           O  
ATOM    464  N   GLU    86       3.229   6.663  12.607  1.00 29.25           N  
ATOM    465  CA  GLU    86       4.634   6.386  12.557  1.00 29.44           C  
ATOM    466  C   GLU    86       5.421   7.534  13.169  1.00 28.21           C  
ATOM    467  O   GLU    86       6.460   7.279  13.754  1.00 28.92           O  
ATOM    468  CB  GLU    86       5.115   6.080  11.127  1.00 30.78           C  
ATOM    469  CG  GLU    86       4.656   4.727  10.559  1.00 32.94           C  
ATOM    470  CD  GLU    86       5.365   3.520  11.181  1.00 34.78           C  
ATOM    471  OE1 GLU    86       6.231   3.694  12.045  1.00 37.21           O  
ATOM    472  OE2 GLU    86       5.060   2.375  10.804  1.00 36.77           O  
ATOM    473  N   PHE    87       4.964   8.783  13.001  1.00 26.80           N  
ATOM    474  CA  PHE    87       5.616   9.924  13.634  1.00 28.21           C  
ATOM    475  C   PHE    87       5.514   9.804  15.163  1.00 29.41           C  
ATOM    476  O   PHE    87       6.454  10.162  15.871  1.00 31.23           O  
ATOM    477  CB  PHE    87       5.013  11.261  13.143  1.00 28.09           C  
ATOM    478  CG  PHE    87       5.670  12.514  13.751  1.00 27.89           C  
ATOM    479  CD1 PHE    87       7.031  12.754  13.595  1.00 27.99           C  
ATOM    480  CD2 PHE    87       4.911  13.470  14.400  1.00 28.57           C  
ATOM    481  CE1 PHE    87       7.618  13.916  14.106  1.00 28.10           C  
ATOM    482  CE2 PHE    87       5.483  14.639  14.922  1.00 28.19           C  
ATOM    483  CZ  PHE    87       6.842  14.860  14.779  1.00 28.07           C  
ATOM    484  N   LEU    88       4.378   9.324  15.677  1.00 30.36           N  
ATOM    485  CA  LEU    88       4.220   9.109  17.121  1.00 30.46           C  
ATOM    486  C   LEU    88       5.224   8.069  17.637  1.00 31.42           C  
ATOM    487  O   LEU    88       5.833   8.271  18.698  1.00 29.42           O  
ATOM    488  CB  LEU    88       2.784   8.666  17.467  1.00 31.13           C  
ATOM    489  CG  LEU    88       2.412   8.532  18.953  1.00 31.21           C  
ATOM    490  CD1 LEU    88       2.684   9.812  19.710  1.00 31.01           C  
ATOM    491  CD2 LEU    88       0.929   8.096  19.140  1.00 31.40           C  
ATOM    492  N   GLN    89       5.393   6.967  16.901  1.00 31.85           N  
ATOM    493  CA  GLN    89       6.357   5.947  17.298  1.00 34.37           C  
ATOM    494  C   GLN    89       7.800   6.468  17.155  1.00 34.03           C  
ATOM    495  O   GLN    89       8.666   6.108  17.933  1.00 33.46           O  
ATOM    496  CB  GLN    89       6.174   4.666  16.492  1.00 35.02           C  
ATOM    497  CG  GLN    89       4.813   4.027  16.684  1.00 36.73           C  
ATOM    498  CD  GLN    89       4.686   2.702  15.951  1.00 37.09           C  
ATOM    499  OE1 GLN    89       5.443   1.746  16.201  1.00 39.15           O  
ATOM    500  NE2 GLN    89       3.731   2.636  15.038  1.00 37.94           N  
ATOM    501  N   TYR    90       8.059   7.302  16.157  1.00 34.20           N  
ATOM    502  CA  TYR    90       9.378   7.913  16.030  1.00 34.41           C  
ATOM    503  C   TYR    90       9.673   8.721  17.304  1.00 34.93           C  
ATOM    504  O   TYR    90      10.740   8.585  17.911  1.00 35.59           O  
ATOM    505  CB  TYR    90       9.465   8.805  14.774  1.00 33.05           C  
ATOM    506  CG  TYR    90      10.776   9.585  14.662  1.00 32.56           C  
ATOM    507  CD1 TYR    90      11.970   8.946  14.331  1.00 32.25           C  
ATOM    508  CD2 TYR    90      10.807  10.960  14.887  1.00 32.58           C  
ATOM    509  CE1 TYR    90      13.177   9.660  14.260  1.00 32.10           C  
ATOM    510  CE2 TYR    90      11.998  11.683  14.821  1.00 32.58           C  
ATOM    511  CZ  TYR    90      13.168  11.035  14.491  1.00 32.09           C  
ATOM    512  OH  TYR    90      14.313  11.769  14.418  1.00 31.83           O  
ATOM    513  N   CYS    91       8.713   9.563  17.692  1.00 35.16           N  
ATOM    514  CA  CYS    91       8.809  10.402  18.899  1.00 33.78           C  
ATOM    515  C   CYS    91       8.950   9.627  20.216  1.00 34.05           C  
ATOM    516  O   CYS    91       9.608  10.096  21.122  1.00 33.30           O  
ATOM    517  CB  CYS    91       7.607  11.318  18.983  1.00 32.68           C  
ATOM    518  SG  CYS    91       7.605  12.534  17.689  1.00 31.54           S  
ATOM    519  N   GLN    92       8.315   8.458  20.311  1.00 34.20           N  
ATOM    520  CA  GLN    92       8.417   7.606  21.493  1.00 35.03           C  
ATOM    521  C   GLN    92       9.767   6.916  21.576  1.00 34.16           C  
ATOM    522  O   GLN    92      10.193   6.491  22.638  1.00 34.81           O  
ATOM    523  CB  GLN    92       7.304   6.565  21.485  1.00 35.59           C  
ATOM    524  CG  GLN    92       5.914   7.175  21.698  1.00 36.42           C  
ATOM    525  CD  GLN    92       4.751   6.237  21.334  1.00 37.22           C  
ATOM    526  OE1 GLN    92       4.947   5.125  20.847  1.00 36.76           O  
ATOM    527  NE2 GLN    92       3.523   6.717  21.568  1.00 39.66           N  
ATOM    528  N   SER    93      10.454   6.798  20.451  1.00 34.03           N  
ATOM    529  CA  SER    93      11.752   6.163  20.446  1.00 32.81           C  
ATOM    530  C   SER    93      12.870   7.156  20.707  1.00 31.91           C  
ATOM    531  O   SER    93      13.942   6.741  21.110  1.00 30.81           O  
ATOM    532  CB  SER    93      11.999   5.469  19.113  1.00 34.11           C  
ATOM    533  OG  SER    93      12.114   6.403  18.055  1.00 34.71           O  
ATOM    534  N   LEU    94      12.631   8.456  20.479  1.00 31.83           N  
ATOM    535  CA  LEU    94      13.685   9.486  20.653  1.00 31.51           C  
ATOM    536  C   LEU    94      14.342   9.464  22.029  1.00 31.46           C  
ATOM    537  O   LEU    94      15.574   9.451  22.101  1.00 31.87           O  
ATOM    538  CB  LEU    94      13.193  10.902  20.304  1.00 30.79           C  
ATOM    539  CG  LEU    94      13.038  11.228  18.819  1.00 30.95           C  
ATOM    540  CD1 LEU    94      12.328  12.594  18.633  1.00 30.72           C  
ATOM    541  CD2 LEU    94      14.373  11.164  18.090  1.00 30.03           C  
ATOM    542  N   PRO    95      13.545   9.543  23.121  1.00 31.16           N  
ATOM    543  CA  PRO    95      12.104   9.764  23.270  1.00 31.24           C  
ATOM    544  C   PRO    95      11.760  11.193  23.647  1.00 31.96           C  
ATOM    545  O   PRO    95      12.596  11.871  24.235  1.00 33.19           O  
ATOM    546  CB  PRO    95      11.759   8.882  24.457  1.00 30.56           C  
ATOM    547  CG  PRO    95      12.999   8.957  25.346  1.00 30.77           C  
ATOM    548  CD  PRO    95      14.174   9.262  24.431  1.00 31.16           C  
ATOM    549  N   LEU    96      10.552  11.668  23.331  1.00 31.46           N  
ATOM    550  CA  LEU    96      10.156  13.006  23.809  1.00 31.65           C  
ATOM    551  C   LEU    96       9.721  12.819  25.276  1.00 32.28           C  
ATOM    552  O   LEU    96       9.670  11.693  25.757  1.00 32.15           O  
ATOM    553  CB  LEU    96       9.045  13.647  22.957  1.00 29.95           C  
ATOM    554  CG  LEU    96       9.370  13.934  21.476  1.00 29.64           C  
ATOM    555  CD1 LEU    96       8.198  14.615  20.747  1.00 27.64           C  
ATOM    556  CD2 LEU    96      10.677  14.795  21.361  1.00 28.59           C  
ATOM    557  N   SER    97       9.444  13.904  25.999  1.00 32.65           N  
ATOM    558  CA  SER    97       9.019  13.771  27.400  1.00 32.55           C  
ATOM    559  C   SER    97       7.759  12.923  27.498  1.00 32.70           C  
ATOM    560  O   SER    97       7.026  12.769  26.517  1.00 33.71           O  
ATOM    561  CB  SER    97       8.716  15.139  27.997  1.00 32.59           C  
ATOM    562  OG  SER    97       7.547  15.663  27.400  1.00 31.84           O  
ATOM    563  N   ASP    98       7.467  12.409  28.690  1.00 33.19           N  
ATOM    564  CA  ASP    98       6.275  11.582  28.879  1.00 33.23           C  
ATOM    565  C   ASP    98       4.966  12.366  28.697  1.00 32.35           C  
ATOM    566  O   ASP    98       3.961  11.797  28.233  1.00 31.66           O  
ATOM    567  CB  ASP    98       6.314  10.868  30.227  1.00 34.81           C  
ATOM    568  CG  ASP    98       7.346   9.752  30.271  1.00 35.79           C  
ATOM    569  OD1 ASP    98       7.927   9.397  29.218  1.00 36.03           O  
ATOM    570  OD2 ASP    98       7.566   9.216  31.376  1.00 38.06           O  
ATOM    571  N   GLY    99       4.990  13.651  29.055  1.00 30.82           N  
ATOM    572  CA  GLY    99       3.842  14.548  28.894  1.00 30.89           C  
ATOM    573  C   GLY    99       3.507  14.851  27.439  1.00 31.23           C  
ATOM    574  O   GLY    99       2.338  14.867  27.051  1.00 32.26           O  
ATOM    575  N   ILE   100       4.532  15.128  26.633  1.00 31.16           N  
ATOM    576  CA  ILE   100       4.345  15.348  25.206  1.00 29.39           C  
ATOM    577  C   ILE   100       3.859  14.036  24.541  1.00 29.36           C  
ATOM    578  O   ILE   100       2.931  14.074  23.743  1.00 30.42           O  
ATOM    579  CB  ILE   100       5.637  15.902  24.562  1.00 30.48           C  
ATOM    580  CG1 ILE   100       5.934  17.321  25.075  1.00 31.37           C  
ATOM    581  CG2 ILE   100       5.542  15.941  23.038  1.00 30.03           C  
ATOM    582  CD1 ILE   100       4.947  18.391  24.593  1.00 31.63           C  
ATOM    583  N   LEU   101       4.433  12.889  24.915  1.00 27.54           N  
ATOM    584  CA  LEU   101       4.056  11.584  24.340  1.00 27.41           C  
ATOM    585  C   LEU   101       2.603  11.212  24.618  1.00 27.36           C  
ATOM    586  O   LEU   101       1.952  10.611  23.761  1.00 26.82           O  
ATOM    587  CB  LEU   101       4.997  10.452  24.813  1.00 27.14           C  
ATOM    588  CG  LEU   101       6.374  10.483  24.155  1.00 27.77           C  
ATOM    589  CD1 LEU   101       7.364   9.480  24.749  1.00 28.09           C  
ATOM    590  CD2 LEU   101       6.204  10.283  22.646  1.00 27.85           C  
ATOM    591  N   ALA   102       2.113  11.536  25.809  1.00 26.46           N  
ATOM    592  CA  ALA   102       0.725  11.313  26.148  1.00 27.20           C  
ATOM    593  C   ALA   102      -0.163  12.246  25.304  1.00 27.49           C  
ATOM    594  O   ALA   102      -1.179  11.829  24.744  1.00 28.34           O  
ATOM    595  CB  ALA   102       0.495  11.534  27.664  1.00 26.33           C  
ATOM    596  N   LEU   103       0.242  13.502  25.194  1.00 28.56           N  
ATOM    597  CA  LEU   103      -0.483  14.476  24.398  1.00 28.57           C  
ATOM    598  C   LEU   103      -0.498  14.094  22.928  1.00 30.29           C  
ATOM    599  O   LEU   103      -1.466  14.368  22.211  1.00 31.20           O  
ATOM    600  CB  LEU   103       0.150  15.852  24.550  1.00 27.97           C  
ATOM    601  CG  LEU   103      -0.540  16.927  23.734  1.00 27.93           C  
ATOM    602  CD1 LEU   103      -2.056  16.931  24.028  1.00 28.16           C  
ATOM    603  CD2 LEU   103       0.114  18.260  24.005  1.00 27.38           C  
ATOM    604  N   MET   104       0.578  13.477  22.459  1.00 30.91           N  
ATOM    605  CA  MET   104       0.587  13.021  21.088  1.00 31.03           C  
ATOM    606  C   MET   104      -0.356  11.843  20.907  1.00 31.30           C  
ATOM    607  O   MET   104      -1.078  11.768  19.908  1.00 31.91           O  
ATOM    608  CB  MET   104       2.011  12.700  20.593  1.00 29.78           C  
ATOM    609  CG  MET   104       2.852  13.953  20.409  1.00 29.50           C  
ATOM    610  SD  MET   104       4.547  13.560  19.600  0.75 28.40          SE  
ATOM    611  CE  MET   104       4.041  13.148  17.802  1.00 27.34           C  
ATOM    612  N   ASP   105      -0.376  10.926  21.857  1.00 31.23           N  
ATOM    613  CA  ASP   105      -1.286   9.791  21.726  1.00 32.67           C  
ATOM    614  C   ASP   105      -2.788  10.253  21.729  1.00 32.95           C  
ATOM    615  O   ASP   105      -3.590   9.801  20.916  1.00 32.42           O  
ATOM    616  CB  ASP   105      -0.974   8.721  22.766  1.00 32.38           C  
ATOM    617  CG  ASP   105      -1.939   7.573  22.686  1.00 33.91           C  
ATOM    618  OD1 ASP   105      -3.040   7.652  23.253  1.00 33.56           O  
ATOM    619  OD2 ASP   105      -1.555   6.530  22.122  1.00 35.97           O  
ATOM    620  N   PHE   106      -3.129  11.160  22.630  1.00 33.56           N  
ATOM    621  CA  PHE   106      -4.457  11.802  22.702  1.00 35.01           C  
ATOM    622  C   PHE   106      -4.878  12.370  21.332  1.00 36.24           C  
ATOM    623  O   PHE   106      -5.978  12.083  20.818  1.00 36.06           O  
ATOM    624  CB  PHE   106      -4.385  12.903  23.770  1.00 35.80           C  
ATOM    625  CG  PHE   106      -5.655  13.703  23.965  1.00 36.05           C  
ATOM    626  CD1 PHE   106      -6.880  13.073  24.216  1.00 35.54           C  
ATOM    627  CD2 PHE   106      -5.600  15.108  23.982  1.00 36.94           C  
ATOM    628  CE1 PHE   106      -8.029  13.817  24.425  1.00 36.07           C  
ATOM    629  CE2 PHE   106      -6.743  15.860  24.198  1.00 36.31           C  
ATOM    630  CZ  PHE   106      -7.966  15.215  24.432  1.00 36.38           C  
ATOM    631  N   GLU   107      -3.976  13.149  20.733  1.00 37.10           N  
ATOM    632  CA  GLU   107      -4.199  13.781  19.423  1.00 35.80           C  
ATOM    633  C   GLU   107      -4.382  12.751  18.330  1.00 35.02           C  
ATOM    634  O   GLU   107      -5.280  12.864  17.512  1.00 33.91           O  
ATOM    635  CB  GLU   107      -3.049  14.734  19.088  1.00 36.77           C  
ATOM    636  CG  GLU   107      -3.160  16.067  19.838  1.00 35.57           C  
ATOM    637  CD  GLU   107      -2.247  17.140  19.300  1.00 36.65           C  
ATOM    638  OE1 GLU   107      -1.006  16.977  19.321  1.00 37.42           O  
ATOM    639  OE2 GLU   107      -2.761  18.199  18.885  1.00 37.20           O  
ATOM    640  N   TYR   108      -3.534  11.735  18.321  1.00 34.20           N  
ATOM    641  CA  TYR   108      -3.688  10.676  17.353  1.00 35.65           C  
ATOM    642  C   TYR   108      -5.048   9.963  17.523  1.00 34.35           C  
ATOM    643  O   TYR   108      -5.718   9.617  16.551  1.00 34.92           O  
ATOM    644  CB  TYR   108      -2.523   9.682  17.454  1.00 35.28           C  
ATOM    645  CG  TYR   108      -2.558   8.616  16.409  1.00 35.58           C  
ATOM    646  CD1 TYR   108      -2.544   8.953  15.053  1.00 35.63           C  
ATOM    647  CD2 TYR   108      -2.590   7.270  16.761  1.00 34.32           C  
ATOM    648  CE1 TYR   108      -2.584   7.978  14.075  1.00 35.54           C  
ATOM    649  CE2 TYR   108      -2.619   6.298  15.802  1.00 35.87           C  
ATOM    650  CZ  TYR   108      -2.616   6.649  14.449  1.00 35.77           C  
ATOM    651  OH  TYR   108      -2.658   5.681  13.471  1.00 35.26           O  
ATOM    652  N   THR   109      -5.448   9.746  18.769  1.00 35.03           N  
ATOM    653  CA  THR   109      -6.698   9.064  19.076  1.00 33.68           C  
ATOM    654  C   THR   109      -7.861   9.886  18.507  1.00 31.85           C  
ATOM    655  O   THR   109      -8.816   9.315  18.010  1.00 32.82           O  
ATOM    656  CB  THR   109      -6.808   8.731  20.607  1.00 35.01           C  
ATOM    657  OG1 THR   109      -5.735   7.858  20.969  1.00 34.59           O  
ATOM    658  CG2 THR   109      -8.135   8.031  20.970  1.00 33.15           C  
ATOM    659  N   GLN   110      -7.801  11.217  18.549  1.00 30.28           N  
ATOM    660  CA  GLN   110      -8.859  12.002  17.968  1.00 30.39           C  
ATOM    661  C   GLN   110      -8.990  11.707  16.478  1.00 31.29           C  
ATOM    662  O   GLN   110     -10.103  11.494  15.963  1.00 30.97           O  
ATOM    663  CB  GLN   110      -8.678  13.509  18.239  1.00 31.63           C  
ATOM    664  CG  GLN   110      -8.869  13.893  19.712  1.00 31.90           C  
ATOM    665  CD  GLN   110      -8.517  15.343  19.995  1.00 33.22           C  
ATOM    666  OE1 GLN   110      -7.835  15.657  20.974  1.00 34.63           O  
ATOM    667  NE2 GLN   110      -8.977  16.233  19.134  1.00 35.22           N  
ATOM    668  N   LEU   111      -7.858  11.648  15.775  1.00 30.57           N  
ATOM    669  CA  LEU   111      -7.878  11.335  14.362  1.00 30.61           C  
ATOM    670  C   LEU   111      -8.434   9.911  14.164  1.00 31.02           C  
ATOM    671  O   LEU   111      -9.228   9.651  13.260  1.00 30.94           O  
ATOM    672  CB  LEU   111      -6.471  11.490  13.758  1.00 30.95           C  
ATOM    673  CG  LEU   111      -6.293  11.231  12.256  1.00 31.08           C  
ATOM    674  CD1 LEU   111      -7.111  12.147  11.455  1.00 30.25           C  
ATOM    675  CD2 LEU   111      -4.806  11.369  11.903  1.00 31.37           C  
ATOM    676  N   LEU   112      -8.077   8.985  15.037  1.00 31.17           N  
ATOM    677  CA  LEU   112      -8.657   7.657  14.911  1.00 31.52           C  
ATOM    678  C   LEU   112     -10.191   7.645  15.018  1.00 34.16           C  
ATOM    679  O   LEU   112     -10.858   6.803  14.374  1.00 33.67           O  
ATOM    680  CB  LEU   112      -8.070   6.724  15.939  1.00 30.68           C  
ATOM    681  CG  LEU   112      -6.630   6.333  15.739  1.00 28.89           C  
ATOM    682  CD1 LEU   112      -6.242   5.410  16.888  1.00 28.54           C  
ATOM    683  CD2 LEU   112      -6.406   5.663  14.382  1.00 28.98           C  
ATOM    684  N   ALA   113     -10.747   8.598  15.784  1.00 34.42           N  
ATOM    685  CA  ALA   113     -12.190   8.674  15.988  1.00 34.82           C  
ATOM    686  C   ALA   113     -12.821   9.386  14.806  1.00 36.77           C  
ATOM    687  O   ALA   113     -13.933   9.038  14.385  1.00 34.40           O  
ATOM    688  CB  ALA   113     -12.513   9.386  17.282  1.00 33.82           C  
ATOM    689  N   GLU   114     -12.105  10.396  14.285  1.00 38.02           N  
ATOM    690  CA  GLU   114     -12.525  11.148  13.083  1.00 38.27           C  
ATOM    691  C   GLU   114     -12.688  10.230  11.866  1.00 37.71           C  
ATOM    692  O   GLU   114     -13.631  10.376  11.072  1.00 35.85           O  
ATOM    693  CB  GLU   114     -11.479  12.231  12.748  1.00 38.46           C  
ATOM    694  CG  GLU   114     -11.625  12.955  11.411  1.00 38.44           C  
ATOM    695  CD  GLU   114     -12.912  13.774  11.263  1.00 39.18           C  
ATOM    696  OE1 GLU   114     -13.863  13.564  12.052  1.00 39.13           O  
ATOM    697  OE2 GLU   114     -12.969  14.629  10.339  1.00 38.38           O  
ATOM    698  N   VAL   115     -11.786   9.260  11.783  1.00 36.86           N  
ATOM    699  CA  VAL   115     -11.649   8.407  10.616  1.00 37.42           C  
ATOM    700  C   VAL   115     -12.283   7.031  10.766  1.00 37.20           C  
ATOM    701  O   VAL   115     -12.437   6.316   9.783  1.00 36.94           O  
ATOM    702  CB  VAL   115     -10.088   8.346  10.255  1.00 37.61           C  
ATOM    703  CG1 VAL   115      -9.631   7.000   9.754  1.00 37.26           C  
ATOM    704  CG2 VAL   115      -9.717   9.491   9.349  1.00 35.81           C  
ATOM    705  N   ALA   116     -12.693   6.662  11.972  1.00 37.42           N  
ATOM    706  CA  ALA   116     -13.258   5.331  12.187  1.00 37.49           C  
ATOM    707  C   ALA   116     -14.540   5.101  11.376  1.00 37.88           C  
ATOM    708  O   ALA   116     -15.338   6.015  11.165  1.00 37.84           O  
ATOM    709  CB  ALA   116     -13.500   5.083  13.680  1.00 38.00           C  
ATOM    710  N   GLN   117     -14.690   3.876  10.881  1.00 39.14           N  
ATOM    711  CA  GLN   117     -15.857   3.473  10.117  1.00 39.51           C  
ATOM    712  C   GLN   117     -16.844   2.904  11.096  1.00 39.20           C  
ATOM    713  O   GLN   117     -16.541   1.915  11.775  1.00 39.62           O  
ATOM    714  CB  GLN   117     -15.520   2.391   9.087  1.00 40.02           C  
ATOM    715  CG  GLN   117     -16.761   1.831   8.351  1.00 40.38           C  
ATOM    716  N   ILE   118     -18.023   3.517  11.148  1.00 38.74           N  
ATOM    717  CA  ILE   118     -19.100   3.113  12.047  1.00 37.74           C  
ATOM    718  C   ILE   118     -20.190   2.493  11.173  1.00 37.96           C  
ATOM    719  O   ILE   118     -20.690   3.184  10.284  1.00 37.83           O  
ATOM    720  CB  ILE   118     -19.650   4.354  12.786  1.00 36.97           C  
ATOM    721  CG1 ILE   118     -18.576   4.967  13.676  1.00 36.79           C  
ATOM    722  CG2 ILE   118     -20.836   3.996  13.663  1.00 37.44           C  
ATOM    723  CD1 ILE   118     -18.946   6.361  14.158  1.00 36.94           C  
ATOM    724  N   PRO   119     -20.504   1.180  11.345  1.00 37.96           N  
ATOM    725  CA  PRO   119     -21.559   0.572  10.535  1.00 37.61           C  
ATOM    726  C   PRO   119     -22.869   1.352  10.481  1.00 37.30           C  
ATOM    727  O   PRO   119     -23.244   2.008  11.459  1.00 37.04           O  
ATOM    728  CB  PRO   119     -21.800  -0.801  11.196  1.00 38.22           C  
ATOM    729  CG  PRO   119     -20.857  -0.881  12.383  1.00 38.45           C  
ATOM    730  CD  PRO   119     -19.820   0.169  12.178  1.00 38.93           C  
ATOM    731  N   ASP   120     -23.525   1.290   9.321  1.00 36.76           N  
ATOM    732  CA  ASP   120     -24.832   1.907   9.121  1.00 36.79           C  
ATOM    733  C   ASP   120     -25.816   1.213  10.070  1.00 36.53           C  
ATOM    734  O   ASP   120     -25.821  -0.020  10.190  1.00 36.76           O  
ATOM    735  CB  ASP   120     -25.290   1.781   7.665  1.00 35.70           C  
ATOM    736  N   ILE   121     -26.612   2.007  10.777  1.00 36.81           N  
ATOM    737  CA  ILE   121     -27.601   1.463  11.728  1.00 36.43           C  
ATOM    738  C   ILE   121     -29.007   1.772  11.216  1.00 36.10           C  
ATOM    739  O   ILE   121     -29.369   2.955  11.079  1.00 36.53           O  
ATOM    740  CB  ILE   121     -27.441   2.053  13.157  1.00 36.35           C  
ATOM    741  CG1 ILE   121     -26.346   1.342  13.987  1.00 36.03           C  
ATOM    742  CG2 ILE   121     -28.747   1.798  13.971  1.00 36.54           C  
ATOM    743  CD1 ILE   121     -25.097   1.027  13.356  1.00 35.96           C  
ATOM    744  N   PRO   122     -29.788   0.728  10.870  1.00 35.15           N  
ATOM    745  CA  PRO   122     -31.171   1.018  10.479  1.00 34.84           C  
ATOM    746  C   PRO   122     -31.915   1.759  11.588  1.00 34.29           C  
ATOM    747  O   PRO   122     -31.737   1.480  12.791  1.00 32.53           O  
ATOM    748  CB  PRO   122     -31.781  -0.367  10.236  1.00 35.03           C  
ATOM    749  CG  PRO   122     -30.621  -1.233   9.907  1.00 35.38           C  
ATOM    750  CD  PRO   122     -29.488  -0.711  10.766  1.00 35.15           C  
ATOM    751  N   ASP   123     -32.722   2.719  11.165  1.00 34.56           N  
ATOM    752  CA  ASP   123     -33.461   3.540  12.081  1.00 34.50           C  
ATOM    753  C   ASP   123     -34.829   2.908  12.365  1.00 33.08           C  
ATOM    754  O   ASP   123     -35.856   3.309  11.826  1.00 32.07           O  
ATOM    755  CB  ASP   123     -33.559   4.950  11.511  1.00 35.67           C  
ATOM    756  CG  ASP   123     -33.888   5.972  12.555  1.00 36.62           C  
ATOM    757  OD1 ASP   123     -33.929   5.622  13.755  1.00 37.75           O  
ATOM    758  OD2 ASP   123     -34.108   7.133  12.166  1.00 38.52           O  
ATOM    759  N   ILE   124     -34.798   1.901  13.241  1.00 32.79           N  
ATOM    760  CA  ILE   124     -35.975   1.159  13.684  1.00 31.54           C  
ATOM    761  C   ILE   124     -36.037   1.214  15.210  1.00 31.99           C  
ATOM    762  O   ILE   124     -35.290   1.969  15.851  1.00 31.86           O  
ATOM    763  CB  ILE   124     -35.939  -0.318  13.192  1.00 30.72           C  
ATOM    764  CG1 ILE   124     -34.792  -1.106  13.840  1.00 30.34           C  
ATOM    765  CG2 ILE   124     -35.842  -0.352  11.657  1.00 30.34           C  
ATOM    766  CD1 ILE   124     -34.778  -2.601  13.479  1.00 30.60           C  
ATOM    767  N   HIS   125     -36.940   0.427  15.795  1.00 31.68           N  
ATOM    768  CA  HIS   125     -37.063   0.371  17.238  1.00 30.63           C  
ATOM    769  C   HIS   125     -36.133  -0.690  17.806  1.00 31.38           C  
ATOM    770  O   HIS   125     -36.158  -1.848  17.378  1.00 31.11           O  
ATOM    771  CB  HIS   125     -38.491   0.061  17.652  1.00 30.09           C  
ATOM    772  CG  HIS   125     -38.703   0.103  19.128  1.00 29.67           C  
ATOM    773  ND1 HIS   125     -39.161   1.227  19.774  1.00 29.17           N  
ATOM    774  CD2 HIS   125     -38.504  -0.835  20.088  1.00 29.71           C  
ATOM    775  CE1 HIS   125     -39.249   0.976  21.071  1.00 30.24           C  
ATOM    776  NE2 HIS   125     -38.846  -0.265  21.288  1.00 29.36           N  
ATOM    777  N   TYR   126     -35.284  -0.281  18.752  1.00 32.16           N  
ATOM    778  CA  TYR   126     -34.413  -1.222  19.455  1.00 32.02           C  
ATOM    779  C   TYR   126     -34.825  -1.190  20.918  1.00 30.88           C  
ATOM    780  O   TYR   126     -34.697  -0.178  21.569  1.00 30.80           O  
ATOM    781  CB  TYR   126     -32.932  -0.859  19.288  1.00 31.79           C  
ATOM    782  CG  TYR   126     -32.460  -0.901  17.833  1.00 31.58           C  
ATOM    783  CD1 TYR   126     -32.175  -2.120  17.209  1.00 31.68           C  
ATOM    784  CD2 TYR   126     -32.302   0.271  17.090  1.00 31.54           C  
ATOM    785  CE1 TYR   126     -31.745  -2.176  15.868  1.00 31.67           C  
ATOM    786  CE2 TYR   126     -31.876   0.230  15.763  1.00 31.47           C  
ATOM    787  CZ  TYR   126     -31.592  -1.006  15.157  1.00 31.98           C  
ATOM    788  OH  TYR   126     -31.172  -1.075  13.832  1.00 32.02           O  
ATOM    789  N   SER   127     -35.346  -2.299  21.429  1.00 30.50           N  
ATOM    790  CA  SER   127     -35.776  -2.363  22.835  1.00 28.63           C  
ATOM    791  C   SER   127     -34.573  -2.540  23.798  1.00 28.44           C  
ATOM    792  O   SER   127     -33.393  -2.582  23.369  1.00 27.83           O  
ATOM    793  CB  SER   127     -36.712  -3.532  23.010  1.00 27.86           C  
ATOM    794  OG  SER   127     -35.992  -4.736  22.923  1.00 26.15           O  
ATOM    795  N   ASN   128     -34.881  -2.633  25.088  1.00 27.65           N  
ATOM    796  CA  ASN   128     -33.875  -2.896  26.115  1.00 27.69           C  
ATOM    797  C   ASN   128     -33.578  -4.373  26.171  1.00 27.51           C  
ATOM    798  O   ASN   128     -32.877  -4.812  27.051  1.00 26.32           O  
ATOM    799  CB  ASN   128     -34.288  -2.387  27.484  1.00 27.86           C  
ATOM    800  CG  ASN   128     -34.374  -0.865  27.550  1.00 29.20           C  
ATOM    801  OD1 ASN   128     -33.713  -0.173  26.812  1.00 30.68           O  
ATOM    802  ND2 ASN   128     -35.174  -0.362  28.454  1.00 30.11           N  
ATOM    803  N   ASP   129     -34.124  -5.130  25.235  1.00 29.56           N  
ATOM    804  CA  ASP   129     -33.754  -6.527  25.072  1.00 32.20           C  
ATOM    805  C   ASP   129     -32.702  -6.608  23.947  1.00 32.50           C  
ATOM    806  O   ASP   129     -32.026  -7.621  23.812  1.00 31.46           O  
ATOM    807  CB  ASP   129     -34.944  -7.367  24.692  1.00 32.76           C  
ATOM    808  CG  ASP   129     -34.645  -8.857  24.803  1.00 33.97           C  
ATOM    809  OD1 ASP   129     -34.244  -9.281  25.911  1.00 35.60           O  
ATOM    810  OD2 ASP   129     -34.794  -9.594  23.799  1.00 33.96           O  
ATOM    811  N   SER   130     -32.564  -5.529  23.158  1.00 33.49           N  
ATOM    812  CA  SER   130     -31.562  -5.471  22.058  1.00 34.51           C  
ATOM    813  C   SER   130     -30.140  -5.183  22.523  1.00 33.88           C  
ATOM    814  O   SER   130     -29.894  -4.208  23.252  1.00 34.32           O  
ATOM    815  CB  SER   130     -31.914  -4.418  20.997  1.00 35.21           C  
ATOM    816  OG  SER   130     -32.926  -4.883  20.134  1.00 37.41           O  
ATOM    817  N   LYS   131     -29.203  -5.992  22.028  1.00 32.98           N  
ATOM    818  CA  LYS   131     -27.788  -5.831  22.372  1.00 33.25           C  
ATOM    819  C   LYS   131     -27.079  -4.623  21.752  1.00 34.21           C  
ATOM    820  O   LYS   131     -27.345  -4.219  20.600  1.00 35.24           O  
ATOM    821  CB  LYS   131     -26.998  -7.079  21.997  1.00 32.43           C  
ATOM    822  CG  LYS   131     -27.365  -8.340  22.731  1.00 30.56           C  
ATOM    823  CD  LYS   131     -26.298  -9.360  22.420  1.00 30.14           C  
ATOM    824  CE  LYS   131     -26.583 -10.694  23.034  1.00 29.35           C  
ATOM    825  NZ  LYS   131     -25.600 -11.650  22.472  1.00 28.55           N  
ATOM    826  N   TYR   132     -26.167  -4.059  22.541  1.00 34.56           N  
ATOM    827  CA  TYR   132     -25.337  -2.923  22.138  1.00 34.57           C  
ATOM    828  C   TYR   132     -23.860  -3.303  22.258  1.00 34.03           C  
ATOM    829  O   TYR   132     -23.496  -4.298  22.895  1.00 34.91           O  
ATOM    830  CB  TYR   132     -25.671  -1.656  22.924  1.00 34.95           C  
ATOM    831  CG  TYR   132     -26.909  -0.970  22.392  1.00 35.34           C  
ATOM    832  CD1 TYR   132     -28.161  -1.550  22.548  1.00 34.93           C  
ATOM    833  CD2 TYR   132     -26.833   0.271  21.743  1.00 34.71           C  
ATOM    834  CE1 TYR   132     -29.296  -0.961  22.038  1.00 34.57           C  
ATOM    835  CE2 TYR   132     -27.960   0.871  21.238  1.00 35.07           C  
ATOM    836  CZ  TYR   132     -29.195   0.240  21.397  1.00 35.45           C  
ATOM    837  OH  TYR   132     -30.333   0.810  20.913  1.00 35.94           O  
ATOM    838  N   THR   133     -23.056  -2.574  21.513  1.00 33.01           N  
ATOM    839  CA  THR   133     -21.608  -2.737  21.451  1.00 33.04           C  
ATOM    840  C   THR   133     -21.076  -1.286  21.444  1.00 32.43           C  
ATOM    841  O   THR   133     -21.792  -0.373  21.008  1.00 31.13           O  
ATOM    842  CB  THR   133     -21.239  -3.499  20.159  1.00 33.45           C  
ATOM    843  OG1 THR   133     -19.837  -3.816  20.132  1.00 34.34           O  
ATOM    844  CG2 THR   133     -21.665  -2.709  18.889  1.00 32.15           C  
ATOM    845  N   PRO   134     -19.856  -1.044  21.947  1.00 33.28           N  
ATOM    846  CA  PRO   134     -19.356   0.372  21.853  1.00 32.73           C  
ATOM    847  C   PRO   134     -19.064   0.749  20.393  1.00 31.84           C  
ATOM    848  O   PRO   134     -18.792  -0.114  19.609  1.00 31.68           O  
ATOM    849  CB  PRO   134     -18.052   0.372  22.660  1.00 33.47           C  
ATOM    850  CG  PRO   134     -17.881  -1.021  23.202  1.00 34.04           C  
ATOM    851  CD  PRO   134     -18.877  -1.956  22.542  1.00 33.56           C  
ATOM    852  N   SER   135     -19.118   2.029  20.027  1.00 33.13           N  
ATOM    853  CA  SER   135     -18.845   2.424  18.654  0.50 31.70           C  
ATOM    855  C   SER   135     -17.407   2.086  18.288  1.00 32.82           C  
ATOM    856  O   SER   135     -16.504   2.197  19.131  1.00 34.51           O  
ATOM    857  CB  SER   135     -19.048   3.926  18.440  0.50 30.68           C  
ATOM    859  OG  SER   135     -18.698   4.292  17.117  0.50 27.27           O  
ATOM    861  N   PRO   136     -17.181   1.647  17.036  1.00 30.78           N  
ATOM    862  CA  PRO   136     -15.796   1.420  16.680  1.00 30.75           C  
ATOM    863  C   PRO   136     -15.003   2.724  16.706  1.00 31.52           C  
ATOM    864  O   PRO   136     -13.776   2.688  16.676  1.00 33.29           O  
ATOM    865  CB  PRO   136     -15.860   0.839  15.259  1.00 31.65           C  
ATOM    866  CG  PRO   136     -17.265   0.651  14.924  1.00 30.94           C  
ATOM    867  CD  PRO   136     -18.124   1.292  15.964  1.00 30.49           C  
ATOM    868  N   ALA   137     -15.693   3.870  16.781  1.00 32.33           N  
ATOM    869  CA  ALA   137     -15.056   5.159  16.842  1.00 33.46           C  
ATOM    870  C   ALA   137     -14.846   5.650  18.274  1.00 34.89           C  
ATOM    871  O   ALA   137     -14.559   6.845  18.467  1.00 34.59           O  
ATOM    872  CB  ALA   137     -15.902   6.193  16.070  1.00 32.66           C  
ATOM    873  N   ALA   138     -15.024   4.752  19.248  1.00 34.13           N  
ATOM    874  CA  ALA   138     -14.902   5.049  20.685  1.00 35.16           C  
ATOM    875  C   ALA   138     -13.668   4.388  21.264  1.00 35.13           C  
ATOM    876  O   ALA   138     -13.452   3.192  21.086  1.00 34.97           O  
ATOM    877  CB  ALA   138     -16.161   4.574  21.462  1.00 35.04           C  
ATOM    878  N   PHE   139     -12.870   5.180  21.959  1.00 35.95           N  
ATOM    879  CA  PHE   139     -11.614   4.734  22.528  1.00 36.87           C  
ATOM    880  C   PHE   139     -11.471   5.138  23.993  1.00 36.57           C  
ATOM    881  O   PHE   139     -11.821   6.270  24.388  1.00 36.96           O  
ATOM    882  CB  PHE   139     -10.447   5.322  21.731  1.00 37.58           C  
ATOM    883  CG  PHE   139     -10.437   4.917  20.257  1.00 38.18           C  
ATOM    884  CD1 PHE   139     -11.110   5.675  19.304  1.00 37.01           C  
ATOM    885  CD2 PHE   139      -9.756   3.790  19.838  1.00 37.84           C  
ATOM    886  CE1 PHE   139     -11.115   5.313  17.985  1.00 36.83           C  
ATOM    887  CE2 PHE   139      -9.764   3.431  18.501  1.00 37.78           C  
ATOM    888  CZ  PHE   139     -10.441   4.210  17.578  1.00 37.29           C  
ATOM    889  N   ILE   140     -10.952   4.201  24.778  1.00 35.26           N  
ATOM    890  CA  ILE   140     -10.656   4.414  26.186  1.00 36.28           C  
ATOM    891  C   ILE   140      -9.157   4.673  26.333  1.00 36.01           C  
ATOM    892  O   ILE   140      -8.360   3.790  25.981  1.00 35.21           O  
ATOM    893  CB  ILE   140     -10.980   3.153  27.042  1.00 36.47           C  
ATOM    894  CG1 ILE   140     -12.471   2.827  26.992  1.00 36.86           C  
ATOM    895  CG2 ILE   140     -10.505   3.359  28.507  1.00 36.54           C  
ATOM    896  CD1 ILE   140     -12.823   1.467  27.609  1.00 37.66           C  
ATOM    897  N   ARG   141      -8.788   5.832  26.895  1.00 35.41           N  
ATOM    898  CA  ARG   141      -7.369   6.211  27.124  1.00 34.78           C  
ATOM    899  C   ARG   141      -7.021   6.495  28.588  1.00 34.90           C  
ATOM    900  O   ARG   141      -7.810   7.115  29.289  1.00 34.61           O  
ATOM    901  CB  ARG   141      -7.002   7.454  26.281  1.00 34.37           C  
ATOM    902  CG  ARG   141      -6.906   7.196  24.783  1.00 34.55           C  
ATOM    903  CD  ARG   141      -5.886   6.100  24.513  1.00 34.71           C  
ATOM    904  NE  ARG   141      -5.766   5.735  23.120  1.00 35.21           N  
ATOM    905  CZ  ARG   141      -6.274   4.642  22.544  1.00 35.59           C  
ATOM    906  NH1 ARG   141      -6.948   3.726  23.222  1.00 36.12           N  
ATOM    907  NH2 ARG   141      -6.061   4.446  21.255  1.00 35.22           N  
ATOM    908  N   GLN   142      -5.829   6.055  29.026  1.00 35.09           N  
ATOM    909  CA  GLN   142      -5.313   6.302  30.408  1.00 34.44           C  
ATOM    910  C   GLN   142      -3.952   6.997  30.332  1.00 33.94           C  
ATOM    911  O   GLN   142      -2.990   6.428  29.822  1.00 33.71           O  
ATOM    912  CB  GLN   142      -5.165   4.993  31.211  1.00 34.70           C  
ATOM    913  CG  GLN   142      -6.405   4.095  31.212  1.00 34.93           C  
ATOM    914  CD  GLN   142      -6.277   2.878  32.097  1.00 35.35           C  
ATOM    915  OE1 GLN   142      -5.995   1.783  31.618  1.00 37.10           O  
ATOM    916  NE2 GLN   142      -6.483   3.062  33.407  1.00 35.35           N  
ATOM    917  N   TYR   143      -3.881   8.225  30.827  1.00 34.02           N  
ATOM    918  CA  TYR   143      -2.631   9.020  30.818  1.00 34.50           C  
ATOM    919  C   TYR   143      -2.240   9.431  32.225  1.00 34.11           C  
ATOM    920  O   TYR   143      -3.114   9.610  33.080  1.00 31.71           O  
ATOM    921  CB  TYR   143      -2.790  10.270  29.944  1.00 34.05           C  
ATOM    922  CG  TYR   143      -3.195   9.923  28.526  1.00 34.61           C  
ATOM    923  CD1 TYR   143      -2.358   9.148  27.710  1.00 34.14           C  
ATOM    924  CD2 TYR   143      -4.393  10.372  27.990  1.00 34.69           C  
ATOM    925  CE1 TYR   143      -2.723   8.821  26.415  1.00 34.01           C  
ATOM    926  CE2 TYR   143      -4.752  10.053  26.693  1.00 34.66           C  
ATOM    927  CZ  TYR   143      -3.917   9.279  25.920  1.00 33.99           C  
ATOM    928  OH  TYR   143      -4.288   8.971  24.642  1.00 34.35           O  
ATOM    929  N   ARG   144      -0.930   9.536  32.463  1.00 33.80           N  
ATOM    930  CA  ARG   144      -0.404   9.988  33.742  1.00 35.60           C  
ATOM    931  C   ARG   144      -0.280  11.510  33.721  1.00 34.05           C  
ATOM    932  O   ARG   144       0.192  12.107  34.681  1.00 33.51           O  
ATOM    933  CB  ARG   144       0.960   9.359  34.046  1.00 36.36           C  
ATOM    934  CG  ARG   144       0.991   7.822  33.954  1.00 38.03           C  
ATOM    935  CD  ARG   144       2.367   7.245  34.238  1.00 39.35           C  
ATOM    936  NE  ARG   144       3.382   8.268  34.007  1.00 41.24           N  
ATOM    937  CZ  ARG   144       4.601   8.071  33.506  1.00 42.86           C  
ATOM    938  NH1 ARG   144       5.012   6.867  33.093  1.00 43.50           N  
ATOM    939  NH2 ARG   144       5.405   9.127  33.377  1.00 42.35           N  
ATOM    940  N   TYR   145      -0.745  12.128  32.635  1.00 34.23           N  
ATOM    941  CA  TYR   145      -0.684  13.578  32.457  1.00 32.95           C  
ATOM    942  C   TYR   145      -2.013  14.174  32.013  1.00 33.09           C  
ATOM    943  O   TYR   145      -2.810  13.522  31.365  1.00 32.37           O  
ATOM    944  CB  TYR   145       0.391  13.878  31.438  1.00 33.59           C  
ATOM    945  CG  TYR   145       1.744  13.420  31.917  1.00 33.35           C  
ATOM    946  CD1 TYR   145       2.172  12.122  31.711  1.00 33.26           C  
ATOM    947  CD2 TYR   145       2.574  14.285  32.608  1.00 33.75           C  
ATOM    948  CE1 TYR   145       3.389  11.697  32.170  1.00 33.34           C  
ATOM    949  CE2 TYR   145       3.791  13.876  33.057  1.00 33.71           C  
ATOM    950  CZ  TYR   145       4.194  12.583  32.837  1.00 33.55           C  
ATOM    951  OH  TYR   145       5.411  12.193  33.306  1.00 34.34           O  
ATOM    952  N   ASP   146      -2.262  15.439  32.332  1.00 34.92           N  
ATOM    953  CA  ASP   146      -3.539  16.038  31.934  1.00 35.59           C  
ATOM    954  C   ASP   146      -3.410  16.548  30.509  1.00 36.12           C  
ATOM    955  O   ASP   146      -3.083  17.710  30.275  1.00 36.73           O  
ATOM    956  CB  ASP   146      -4.019  17.144  32.888  1.00 35.23           C  
ATOM    957  CG  ASP   146      -5.482  17.501  32.657  1.00 35.45           C  
ATOM    958  OD1 ASP   146      -6.054  17.045  31.633  1.00 35.51           O  
ATOM    959  OD2 ASP   146      -6.072  18.196  33.509  1.00 34.99           O  
ATOM    960  N   VAL   147      -3.683  15.652  29.569  1.00 36.09           N  
ATOM    961  CA  VAL   147      -3.580  15.934  28.139  1.00 36.00           C  
ATOM    962  C   VAL   147      -4.681  16.859  27.646  1.00 37.54           C  
ATOM    963  O   VAL   147      -4.578  17.393  26.557  1.00 38.09           O  
ATOM    964  CB  VAL   147      -3.653  14.622  27.297  1.00 35.38           C  
ATOM    965  CG1 VAL   147      -2.531  13.675  27.681  1.00 34.28           C  
ATOM    966  CG2 VAL   147      -5.046  13.949  27.459  1.00 35.03           C  
ATOM    967  N   THR   148      -5.742  17.046  28.430  1.00 40.08           N  
ATOM    968  CA  THR   148      -6.843  17.939  28.035  1.00 40.62           C  
ATOM    969  C   THR   148      -6.586  19.399  28.419  1.00 41.55           C  
ATOM    970  O   THR   148      -7.293  20.309  27.964  1.00 40.82           O  
ATOM    971  CB  THR   148      -8.162  17.553  28.734  1.00 41.38           C  
ATOM    972  OG1 THR   148      -8.043  17.840  30.131  1.00 41.87           O  
ATOM    973  CG2 THR   148      -8.513  16.076  28.536  1.00 40.38           C  
ATOM    974  N   HIS   149      -5.595  19.618  29.276  1.00 42.58           N  
ATOM    975  CA  HIS   149      -5.297  20.956  29.770  1.00 43.38           C  
ATOM    976  C   HIS   149      -3.855  21.343  29.493  1.00 44.04           C  
ATOM    977  O   HIS   149      -3.579  21.904  28.430  1.00 43.03           O  
ATOM    978  CB  HIS   149      -5.634  21.082  31.267  1.00 44.14           C  
ATOM    979  CG  HIS   149      -5.333  22.430  31.836  1.00 44.34           C  
ATOM    980  ND1 HIS   149      -4.211  22.681  32.599  1.00 45.27           N  
ATOM    981  CD2 HIS   149      -5.980  23.614  31.721  1.00 44.87           C  
ATOM    982  CE1 HIS   149      -4.182  23.959  32.938  1.00 44.79           C  
ATOM    983  NE2 HIS   149      -5.249  24.547  32.422  1.00 44.80           N  
ATOM    984  N   ASP   150      -2.930  21.021  30.401  1.00 44.79           N  
ATOM    985  CA  ASP   150      -1.545  21.482  30.234  1.00 45.74           C  
ATOM    986  C   ASP   150      -0.462  20.502  30.737  1.00 45.36           C  
ATOM    987  O   ASP   150       0.588  20.917  31.227  1.00 44.69           O  
ATOM    988  CB  ASP   150      -1.397  22.858  30.890  1.00 46.83           C  
ATOM    989  CG  ASP   150      -0.334  23.714  30.233  1.00 48.68           C  
ATOM    990  OD1 ASP   150       0.428  23.212  29.361  1.00 50.39           O  
ATOM    991  OD2 ASP   150      -0.277  24.916  30.573  1.00 49.33           O  
ATOM    992  N   LEU   151      -0.739  19.209  30.572  1.00 44.73           N  
ATOM    993  CA  LEU   151       0.187  18.114  30.895  1.00 44.03           C  
ATOM    994  C   LEU   151       0.579  18.010  32.352  1.00 43.81           C  
ATOM    995  O   LEU   151       1.716  17.673  32.662  1.00 43.47           O  
ATOM    996  CB  LEU   151       1.441  18.183  30.011  1.00 43.12           C  
ATOM    997  CG  LEU   151       1.178  18.324  28.509  1.00 42.79           C  
ATOM    998  CD1 LEU   151       2.482  18.181  27.706  1.00 41.99           C  
ATOM    999  CD2 LEU   151       0.145  17.316  28.042  1.00 42.24           C  
ATOM   1000  N   GLN   152      -0.378  18.295  33.234  1.00 44.58           N  
ATOM   1001  CA  GLN   152      -0.191  18.162  34.682  1.00 44.48           C  
ATOM   1002  C   GLN   152       0.076  16.686  34.995  1.00 43.53           C  
ATOM   1003  O   GLN   152      -0.577  15.837  34.422  1.00 42.55           O  
ATOM   1004  CB  GLN   152      -1.480  18.582  35.445  1.00 44.70           C  
ATOM   1005  CG  GLN   152      -1.749  20.098  35.662  1.00 45.24           C  
ATOM   1006  CD  GLN   152      -2.106  20.916  34.406  1.00 45.34           C  
ATOM   1007  OE1 GLN   152      -2.549  20.376  33.391  1.00 43.86           O  
ATOM   1008  NE2 GLN   152      -1.931  22.247  34.501  1.00 45.02           N  
ATOM   1009  N   GLU   153       1.051  16.373  35.851  1.00 43.57           N  
ATOM   1010  CA  GLU   153       1.211  14.992  36.314  1.00 43.21           C  
ATOM   1011  C   GLU   153      -0.005  14.717  37.178  1.00 42.36           C  
ATOM   1012  O   GLU   153      -0.084  15.217  38.289  1.00 42.69           O  
ATOM   1013  CB  GLU   153       2.466  14.763  37.150  1.00 43.26           C  
ATOM   1014  CG  GLU   153       3.628  14.244  36.395  1.00 44.27           C  
ATOM   1015  CD  GLU   153       4.799  13.889  37.298  1.00 45.15           C  
ATOM   1016  OE1 GLU   153       5.089  14.665  38.243  1.00 46.26           O  
ATOM   1017  OE2 GLU   153       5.453  12.849  37.043  1.00 46.21           O  
ATOM   1018  N   ALA   154      -0.938  13.936  36.642  1.00 41.00           N  
ATOM   1019  CA  ALA   154      -2.180  13.601  37.311  1.00 40.63           C  
ATOM   1020  C   ALA   154      -2.851  12.510  36.492  1.00 39.98           C  
ATOM   1021  O   ALA   154      -3.087  12.710  35.296  1.00 40.14           O  
ATOM   1022  CB  ALA   154      -3.083  14.827  37.394  1.00 40.73           C  
ATOM   1023  N   GLU   155      -3.118  11.358  37.113  1.00 39.02           N  
ATOM   1024  CA  GLU   155      -3.806  10.248  36.442  1.00 38.44           C  
ATOM   1025  C   GLU   155      -5.091  10.729  35.778  1.00 38.05           C  
ATOM   1026  O   GLU   155      -6.012  11.181  36.454  1.00 36.52           O  
ATOM   1027  CB  GLU   155      -4.125   9.092  37.413  1.00 38.51           C  
ATOM   1028  CG  GLU   155      -2.928   8.203  37.826  1.00 39.18           C  
ATOM   1029  CD  GLU   155      -2.304   7.406  36.667  1.00 39.11           C  
ATOM   1030  OE1 GLU   155      -2.806   7.502  35.528  1.00 39.80           O  
ATOM   1031  OE2 GLU   155      -1.309   6.676  36.900  1.00 39.33           O  
ATOM   1032  N   THR   156      -5.150  10.605  34.450  1.00 38.58           N  
ATOM   1033  CA  THR   156      -6.315  11.049  33.668  1.00 39.32           C  
ATOM   1034  C   THR   156      -6.908   9.901  32.842  1.00 38.56           C  
ATOM   1035  O   THR   156      -6.191   9.175  32.177  1.00 38.94           O  
ATOM   1036  CB  THR   156      -5.961  12.238  32.748  1.00 39.69           C  
ATOM   1037  OG1 THR   156      -5.110  13.151  33.460  1.00 39.65           O  
ATOM   1038  CG2 THR   156      -7.238  12.951  32.288  1.00 38.88           C  
ATOM   1039  N   ALA   157      -8.228   9.758  32.907  1.00 38.33           N  
ATOM   1040  CA  ALA   157      -8.964   8.679  32.254  1.00 38.48           C  
ATOM   1041  C   ALA   157     -10.000   9.322  31.326  1.00 38.25           C  
ATOM   1042  O   ALA   157     -10.901  10.005  31.789  1.00 38.07           O  
ATOM   1043  CB  ALA   157      -9.649   7.780  33.328  1.00 37.18           C  
ATOM   1044  N   LEU   158      -9.871   9.098  30.019  1.00 38.80           N  
ATOM   1045  CA  LEU   158     -10.745   9.736  29.012  1.00 38.15           C  
ATOM   1046  C   LEU   158     -11.397   8.749  28.057  1.00 38.07           C  
ATOM   1047  O   LEU   158     -10.844   7.676  27.783  1.00 37.00           O  
ATOM   1048  CB  LEU   158      -9.907  10.718  28.177  1.00 37.77           C  
ATOM   1049  CG  LEU   158      -9.233  11.893  28.915  1.00 38.21           C  
ATOM   1050  CD1 LEU   158      -8.066  12.510  28.104  1.00 36.98           C  
ATOM   1051  CD2 LEU   158     -10.248  12.946  29.326  1.00 36.74           C  
ATOM   1052  N   LEU   159     -12.573   9.125  27.553  1.00 38.32           N  
ATOM   1053  CA  LEU   159     -13.288   8.364  26.494  1.00 37.73           C  
ATOM   1054  C   LEU   159     -13.305   9.288  25.310  1.00 37.07           C  
ATOM   1055  O   LEU   159     -13.845  10.410  25.428  1.00 37.83           O  
ATOM   1056  CB  LEU   159     -14.742   8.037  26.854  1.00 37.83           C  
ATOM   1057  CG  LEU   159     -15.545   7.301  25.775  1.00 38.57           C  
ATOM   1058  CD1 LEU   159     -14.891   5.919  25.489  1.00 38.98           C  
ATOM   1059  CD2 LEU   159     -17.048   7.119  26.134  1.00 37.71           C  
ATOM   1060  N   ILE   160     -12.697   8.869  24.198  1.00 35.82           N  
ATOM   1061  CA  ILE   160     -12.689   9.678  22.962  1.00 35.81           C  
ATOM   1062  C   ILE   160     -13.626   8.993  21.964  1.00 35.30           C  
ATOM   1063  O   ILE   160     -13.571   7.751  21.790  1.00 32.61           O  
ATOM   1064  CB  ILE   160     -11.259   9.822  22.346  1.00 35.67           C  
ATOM   1065  CG1 ILE   160     -10.329  10.615  23.269  1.00 36.38           C  
ATOM   1066  CG2 ILE   160     -11.341  10.519  21.005  1.00 36.24           C  
ATOM   1067  CD1 ILE   160      -9.693   9.814  24.356  1.00 35.92           C  
ATOM   1068  N   TRP   161     -14.533   9.753  21.358  1.00 34.16           N  
ATOM   1069  CA  TRP   161     -15.456   9.155  20.384  1.00 35.62           C  
ATOM   1070  C   TRP   161     -15.980  10.135  19.343  1.00 36.26           C  
ATOM   1071  O   TRP   161     -15.693  11.326  19.429  1.00 35.77           O  
ATOM   1072  CB  TRP   161     -16.644   8.522  21.109  1.00 37.38           C  
ATOM   1073  CG  TRP   161     -17.718   9.455  21.577  1.00 37.18           C  
ATOM   1074  CD1 TRP   161     -18.903   9.685  20.966  1.00 37.71           C  
ATOM   1075  CD2 TRP   161     -17.728  10.237  22.773  1.00 37.19           C  
ATOM   1076  NE1 TRP   161     -19.642  10.576  21.678  1.00 37.89           N  
ATOM   1077  CE2 TRP   161     -18.945  10.934  22.798  1.00 38.42           C  
ATOM   1078  CE3 TRP   161     -16.816  10.435  23.808  1.00 37.18           C  
ATOM   1079  CZ2 TRP   161     -19.276  11.835  23.813  1.00 38.40           C  
ATOM   1080  CZ3 TRP   161     -17.142  11.285  24.818  1.00 37.74           C  
ATOM   1081  CH2 TRP   161     -18.369  11.986  24.824  1.00 38.15           C  
ATOM   1082  N   ARG   162     -16.759   9.632  18.381  1.00 36.30           N  
ATOM   1083  CA  ARG   162     -17.405  10.495  17.383  1.00 36.65           C  
ATOM   1084  C   ARG   162     -18.910  10.371  17.580  1.00 36.51           C  
ATOM   1085  O   ARG   162     -19.440   9.263  17.606  1.00 35.78           O  
ATOM   1086  CB  ARG   162     -17.036  10.123  15.944  1.00 36.17           C  
ATOM   1087  CG  ARG   162     -17.505  11.169  14.969  1.00 36.54           C  
ATOM   1088  CD  ARG   162     -16.821  11.107  13.626  1.00 36.00           C  
ATOM   1089  NE  ARG   162     -17.436  10.134  12.715  1.00 35.70           N  
ATOM   1090  CZ  ARG   162     -17.007   8.899  12.463  1.00 35.72           C  
ATOM   1091  NH1 ARG   162     -15.925   8.408  13.036  1.00 36.11           N  
ATOM   1092  NH2 ARG   162     -17.668   8.156  11.588  1.00 35.62           N  
ATOM   1093  N   ASN   163     -19.597  11.505  17.694  1.00 37.07           N  
ATOM   1094  CA  ASN   163     -21.015  11.459  18.004  1.00 38.11           C  
ATOM   1095  C   ASN   163     -21.908  11.453  16.780  1.00 39.76           C  
ATOM   1096  O   ASN   163     -21.410  11.428  15.668  1.00 40.47           O  
ATOM   1097  CB  ASN   163     -21.359  12.566  18.979  1.00 37.72           C  
ATOM   1098  CG  ASN   163     -21.269  13.932  18.358  1.00 37.22           C  
ATOM   1099  OD1 ASN   163     -21.160  14.070  17.146  1.00 38.13           O  
ATOM   1100  ND2 ASN   163     -21.356  14.949  19.185  1.00 37.50           N  
ATOM   1101  N   ALA   164     -23.226  11.443  16.989  1.00 41.32           N  
ATOM   1102  CA  ALA   164     -24.203  11.411  15.897  1.00 41.49           C  
ATOM   1103  C   ALA   164     -24.046  12.531  14.871  1.00 42.17           C  
ATOM   1104  O   ALA   164     -24.417  12.345  13.715  1.00 41.92           O  
ATOM   1105  CB  ALA   164     -25.641  11.401  16.471  1.00 42.29           C  
ATOM   1106  N   GLU   165     -23.515  13.682  15.289  1.00 42.49           N  
ATOM   1107  CA  GLU   165     -23.253  14.805  14.375  1.00 43.04           C  
ATOM   1108  C   GLU   165     -21.858  14.735  13.715  1.00 42.42           C  
ATOM   1109  O   GLU   165     -21.395  15.723  13.153  1.00 40.99           O  
ATOM   1110  CB  GLU   165     -23.353  16.131  15.123  1.00 43.93           C  
ATOM   1111  CG  GLU   165     -24.748  16.511  15.540  1.00 45.40           C  
ATOM   1112  CD  GLU   165     -24.763  17.805  16.346  1.00 46.25           C  
ATOM   1113  OE1 GLU   165     -24.250  17.781  17.504  1.00 47.45           O  
ATOM   1114  OE2 GLU   165     -25.300  18.828  15.826  1.00 47.05           O  
ATOM   1115  N   ASP   166     -21.201  13.579  13.808  1.00 40.89           N  
ATOM   1116  CA  ASP   166     -19.862  13.355  13.259  1.00 41.15           C  
ATOM   1117  C   ASP   166     -18.775  14.319  13.804  1.00 40.03           C  
ATOM   1118  O   ASP   166     -17.812  14.628  13.100  1.00 38.42           O  
ATOM   1119  CB  ASP   166     -19.876  13.307  11.704  1.00 41.47           C  
ATOM   1120  CG  ASP   166     -20.427  11.982  11.143  1.00 41.09           C  
ATOM   1121  OD1 ASP   166     -20.142  10.911  11.701  1.00 40.80           O  
ATOM   1122  OD2 ASP   166     -21.117  12.003  10.101  1.00 41.82           O  
ATOM   1123  N   ASP   167     -18.934  14.767  15.057  1.00 40.27           N  
ATOM   1124  CA  ASP   167     -17.931  15.619  15.742  1.00 40.57           C  
ATOM   1125  C   ASP   167     -17.164  14.774  16.756  1.00 39.01           C  
ATOM   1126  O   ASP   167     -17.783  13.962  17.449  1.00 39.31           O  
ATOM   1127  CB  ASP   167     -18.599  16.781  16.492  1.00 41.60           C  
ATOM   1128  CG  ASP   167     -19.185  17.828  15.566  1.00 42.34           C  
ATOM   1129  OD1 ASP   167     -18.468  18.360  14.701  1.00 43.82           O  
ATOM   1130  OD2 ASP   167     -20.363  18.165  15.743  1.00 44.30           O  
ATOM   1131  N   VAL   168     -15.838  14.958  16.829  1.00 36.76           N  
ATOM   1132  CA  VAL   168     -15.006  14.240  17.789  1.00 35.36           C  
ATOM   1133  C   VAL   168     -15.226  14.869  19.171  1.00 35.50           C  
ATOM   1134  O   VAL   168     -15.207  16.106  19.342  1.00 32.60           O  
ATOM   1135  CB  VAL   168     -13.510  14.245  17.431  1.00 35.37           C  
ATOM   1136  CG1 VAL   168     -12.719  13.431  18.436  1.00 35.65           C  
ATOM   1137  CG2 VAL   168     -13.292  13.682  16.052  1.00 35.05           C  
ATOM   1138  N   MET   169     -15.476  14.008  20.146  1.00 33.94           N  
ATOM   1139  CA  MET   169     -15.734  14.428  21.512  1.00 33.79           C  
ATOM   1140  C   MET   169     -14.858  13.600  22.453  1.00 34.81           C  
ATOM   1141  O   MET   169     -14.458  12.471  22.130  1.00 30.90           O  
ATOM   1142  CB  MET   169     -17.201  14.148  21.890  1.00 34.13           C  
ATOM   1143  CG  MET   169     -18.291  14.595  20.964  1.00 33.48           C  
ATOM   1144  SD  MET   169     -18.437  16.527  20.858  0.75 37.47          SE  
ATOM   1145  CE  MET   169     -19.112  16.847  22.681  1.00 31.68           C  
ATOM   1146  N   TYR   170     -14.569  14.167  23.618  1.00 35.79           N  
ATOM   1147  CA  TYR   170     -13.835  13.455  24.636  1.00 36.09           C  
ATOM   1148  C   TYR   170     -14.502  13.833  25.959  1.00 37.22           C  
ATOM   1149  O   TYR   170     -15.080  14.917  26.071  1.00 34.89           O  
ATOM   1150  CB  TYR   170     -12.317  13.783  24.601  1.00 36.65           C  
ATOM   1151  CG  TYR   170     -11.885  15.201  24.997  1.00 37.32           C  
ATOM   1152  CD1 TYR   170     -11.850  15.587  26.339  1.00 38.17           C  
ATOM   1153  CD2 TYR   170     -11.444  16.128  24.041  1.00 36.93           C  
ATOM   1154  CE1 TYR   170     -11.448  16.895  26.731  1.00 36.83           C  
ATOM   1155  CE2 TYR   170     -11.027  17.440  24.427  1.00 37.45           C  
ATOM   1156  CZ  TYR   170     -11.037  17.798  25.777  1.00 37.46           C  
ATOM   1157  OH  TYR   170     -10.647  19.065  26.197  1.00 37.82           O  
ATOM   1158  N   GLN   171     -14.427  12.950  26.952  1.00 36.97           N  
ATOM   1159  CA  GLN   171     -14.931  13.264  28.302  1.00 38.53           C  
ATOM   1160  C   GLN   171     -14.247  12.413  29.334  1.00 36.99           C  
ATOM   1161  O   GLN   171     -13.814  11.296  29.038  1.00 37.34           O  
ATOM   1162  CB  GLN   171     -16.450  13.039  28.429  1.00 39.94           C  
ATOM   1163  CG  GLN   171     -16.874  11.573  28.480  1.00 41.08           C  
ATOM   1164  CD  GLN   171     -18.399  11.383  28.609  1.00 42.57           C  
ATOM   1165  OE1 GLN   171     -19.202  12.314  28.348  1.00 45.34           O  
ATOM   1166  NE2 GLN   171     -18.801  10.179  29.008  1.00 44.67           N  
ATOM   1167  N   THR   172     -14.187  12.906  30.567  1.00 35.94           N  
ATOM   1168  CA  THR   172     -13.585  12.134  31.649  0.50 35.77           C  
ATOM   1170  C   THR   172     -14.403  10.853  31.826  1.00 35.48           C  
ATOM   1171  O   THR   172     -15.610  10.851  31.681  1.00 34.08           O  
ATOM   1172  CB  THR   172     -13.508  12.937  32.961  0.50 35.97           C  
ATOM   1174  OG1 THR   172     -14.832  13.263  33.407  0.50 36.62           O  
ATOM   1176  CG2 THR   172     -12.703  14.212  32.757  0.50 35.21           C  
ATOM   1178  N   LEU   173     -13.723   9.749  32.094  1.00 37.16           N  
ATOM   1179  CA  LEU   173     -14.361   8.480  32.248  1.00 38.77           C  
ATOM   1180  C   LEU   173     -14.133   8.031  33.687  1.00 41.89           C  
ATOM   1181  O   LEU   173     -12.973   7.958  34.150  1.00 42.80           O  
ATOM   1182  CB  LEU   173     -13.715   7.490  31.288  1.00 38.76           C  
ATOM   1183  CG  LEU   173     -14.480   6.251  30.833  1.00 38.66           C  
ATOM   1184  CD1 LEU   173     -15.783   6.646  30.191  1.00 36.48           C  
ATOM   1185  CD2 LEU   173     -13.607   5.482  29.866  1.00 37.79           C  
ATOM   1186  N   ASP   174     -15.226   7.774  34.412  1.00 43.53           N  
ATOM   1187  CA  ASP   174     -15.114   7.254  35.771  1.00 44.88           C  
ATOM   1188  C   ASP   174     -14.975   5.716  35.690  1.00 44.13           C  
ATOM   1189  O   ASP   174     -15.195   5.120  34.639  1.00 42.26           O  
ATOM   1190  CB  ASP   174     -16.253   7.760  36.706  1.00 45.97           C  
ATOM   1191  CG  ASP   174     -17.658   7.312  36.286  1.00 46.82           C  
ATOM   1192  OD1 ASP   174     -17.829   6.394  35.462  1.00 48.80           O  
ATOM   1193  OD2 ASP   174     -18.629   7.886  36.815  1.00 47.87           O  
ATOM   1194  N   GLY   175     -14.578   5.100  36.798  1.00 45.15           N  
ATOM   1195  CA  GLY   175     -14.337   3.644  36.858  1.00 46.19           C  
ATOM   1196  C   GLY   175     -15.469   2.691  36.490  1.00 46.07           C  
ATOM   1197  O   GLY   175     -15.213   1.631  35.921  1.00 44.48           O  
ATOM   1198  N   PHE   176     -16.705   3.029  36.858  1.00 47.77           N  
ATOM   1199  CA  PHE   176     -17.872   2.181  36.511  1.00 48.38           C  
ATOM   1200  C   PHE   176     -18.038   2.124  34.998  1.00 46.08           C  
ATOM   1201  O   PHE   176     -18.206   1.055  34.422  1.00 44.30           O  
ATOM   1202  CB  PHE   176     -19.184   2.741  37.104  1.00 50.64           C  
ATOM   1203  CG  PHE   176     -20.358   1.787  36.991  1.00 50.93           C  
ATOM   1204  CD1 PHE   176     -21.063   1.663  35.793  1.00 51.81           C  
ATOM   1205  CD2 PHE   176     -20.744   1.003  38.074  1.00 51.75           C  
ATOM   1206  CE1 PHE   176     -22.127   0.782  35.684  1.00 52.34           C  
ATOM   1207  CE2 PHE   176     -21.813   0.120  37.978  1.00 51.91           C  
ATOM   1208  CZ  PHE   176     -22.501   0.006  36.786  1.00 52.07           C  
ATOM   1209  N   ASP   177     -18.030   3.316  34.402  1.00 43.78           N  
ATOM   1210  CA  ASP   177     -18.138   3.506  32.961  1.00 42.31           C  
ATOM   1211  C   ASP   177     -17.038   2.803  32.187  1.00 40.47           C  
ATOM   1212  O   ASP   177     -17.315   2.124  31.183  1.00 38.92           O  
ATOM   1213  CB  ASP   177     -18.098   5.006  32.652  1.00 42.66           C  
ATOM   1214  CG  ASP   177     -19.338   5.708  33.107  1.00 43.24           C  
ATOM   1215  OD1 ASP   177     -20.192   5.039  33.727  1.00 43.85           O  
ATOM   1216  OD2 ASP   177     -19.479   6.910  32.810  1.00 42.81           O  
ATOM   1217  N   MET   178     -15.798   2.949  32.656  1.00 39.39           N  
ATOM   1218  CA  MET   178     -14.663   2.298  32.000  1.00 40.64           C  
ATOM   1219  C   MET   178     -14.869   0.766  31.995  1.00 40.74           C  
ATOM   1220  O   MET   178     -14.648   0.085  30.975  1.00 41.40           O  
ATOM   1221  CB  MET   178     -13.345   2.681  32.690  1.00 40.52           C  
ATOM   1222  CG  MET   178     -12.078   2.251  31.974  1.00 41.29           C  
ATOM   1223  SD  MET   178     -10.453   2.665  33.068  0.75 42.72          SE  
ATOM   1224  CE  MET   178     -10.429   4.544  32.789  1.00 41.52           C  
ATOM   1225  N   MET   179     -15.315   0.256  33.124  1.00 41.35           N  
ATOM   1226  CA  MET   179     -15.556  -1.178  33.300  1.00 43.56           C  
ATOM   1227  C   MET   179     -16.640  -1.689  32.352  1.00 41.60           C  
ATOM   1228  O   MET   179     -16.456  -2.675  31.679  1.00 41.85           O  
ATOM   1229  CB  MET   179     -15.942  -1.460  34.764  1.00 44.08           C  
ATOM   1230  CG  MET   179     -16.440  -2.879  35.053  1.00 45.36           C  
ATOM   1231  SD  MET   179     -16.813  -3.096  36.947  0.75 47.94          SE  
ATOM   1232  CE  MET   179     -14.922  -3.086  37.444  1.00 47.55           C  
ATOM   1233  N   LEU   180     -17.770  -1.002  32.329  1.00 41.88           N  
ATOM   1234  CA  LEU   180     -18.876  -1.351  31.456  1.00 41.24           C  
ATOM   1235  C   LEU   180     -18.467  -1.298  29.978  1.00 41.06           C  
ATOM   1236  O   LEU   180     -18.760  -2.229  29.222  1.00 41.65           O  
ATOM   1237  CB  LEU   180     -20.062  -0.411  31.683  1.00 42.02           C  
ATOM   1238  CG  LEU   180     -21.271  -0.875  30.862  1.00 42.92           C  
ATOM   1239  CD1 LEU   180     -21.695  -2.288  31.332  1.00 42.64           C  
ATOM   1240  CD2 LEU   180     -22.429   0.094  30.902  1.00 41.63           C  
ATOM   1241  N   LEU   181     -17.805  -0.223  29.543  1.00 39.70           N  
ATOM   1242  CA  LEU   181     -17.411  -0.135  28.130  1.00 38.32           C  
ATOM   1243  C   LEU   181     -16.451  -1.246  27.773  1.00 38.31           C  
ATOM   1244  O   LEU   181     -16.532  -1.782  26.686  1.00 36.05           O  
ATOM   1245  CB  LEU   181     -16.762   1.183  27.782  1.00 38.28           C  
ATOM   1246  CG  LEU   181     -17.665   2.399  27.911  1.00 36.54           C  
ATOM   1247  CD1 LEU   181     -16.873   3.622  27.735  1.00 37.18           C  
ATOM   1248  CD2 LEU   181     -18.810   2.275  26.897  1.00 36.99           C  
ATOM   1249  N   GLU   182     -15.512  -1.535  28.669  1.00 38.51           N  
ATOM   1250  CA  GLU   182     -14.522  -2.609  28.446  1.00 40.12           C  
ATOM   1251  C   GLU   182     -15.173  -3.999  28.354  1.00 38.77           C  
ATOM   1252  O   GLU   182     -14.787  -4.833  27.514  1.00 41.22           O  
ATOM   1253  CB  GLU   182     -13.507  -2.634  29.591  1.00 41.80           C  
ATOM   1254  CG  GLU   182     -12.290  -3.511  29.311  1.00 42.74           C  
ATOM   1255  CD  GLU   182     -11.361  -2.891  28.303  1.00 43.71           C  
ATOM   1256  OE1 GLU   182     -11.405  -1.639  28.138  1.00 44.55           O  
ATOM   1257  OE2 GLU   182     -10.564  -3.644  27.703  1.00 44.05           O  
ATOM   1258  N   ILE   183     -16.106  -4.252  29.273  1.00 37.91           N  
ATOM   1259  CA  ILE   183     -16.902  -5.493  29.336  1.00 37.16           C  
ATOM   1260  C   ILE   183     -17.745  -5.546  28.049  1.00 36.31           C  
ATOM   1261  O   ILE   183     -17.742  -6.521  27.329  1.00 35.36           O  
ATOM   1262  CB  ILE   183     -17.828  -5.442  30.587  1.00 37.12           C  
ATOM   1263  CG1 ILE   183     -17.063  -5.750  31.869  1.00 36.95           C  
ATOM   1264  CG2 ILE   183     -19.031  -6.343  30.458  1.00 38.23           C  
ATOM   1265  CD1 ILE   183     -17.942  -5.655  33.137  1.00 37.12           C  
ATOM   1266  N   MET   184     -18.440  -4.454  27.744  1.00 35.71           N  
ATOM   1267  CA  MET   184     -19.238  -4.380  26.526  1.00 34.96           C  
ATOM   1268  C   MET   184     -18.418  -4.586  25.249  1.00 35.85           C  
ATOM   1269  O   MET   184     -18.939  -5.122  24.265  1.00 36.27           O  
ATOM   1270  CB  MET   184     -20.033  -3.085  26.446  1.00 33.23           C  
ATOM   1271  CG  MET   184     -21.222  -3.019  27.395  1.00 31.28           C  
ATOM   1272  SD  MET   184     -22.000  -1.323  27.109  0.75 33.38          SE  
ATOM   1273  CE  MET   184     -22.939  -1.763  25.378  1.00 31.32           C  
ATOM   1274  N   GLY   185     -17.148  -4.197  25.274  1.00 34.94           N  
ATOM   1275  CA  GLY   185     -16.274  -4.433  24.146  1.00 35.89           C  
ATOM   1276  C   GLY   185     -15.982  -5.923  24.017  1.00 37.67           C  
ATOM   1277  O   GLY   185     -15.725  -6.435  22.910  1.00 38.56           O  
ATOM   1278  N   SER   186     -16.026  -6.632  25.144  1.00 38.48           N  
ATOM   1279  CA  SER   186     -15.778  -8.080  25.147  1.00 39.76           C  
ATOM   1280  C   SER   186     -16.968  -8.860  24.587  1.00 40.37           C  
ATOM   1281  O   SER   186     -16.806  -9.865  23.877  1.00 40.00           O  
ATOM   1282  CB  SER   186     -15.495  -8.592  26.570  1.00 39.79           C  
ATOM   1283  OG  SER   186     -14.333  -8.012  27.134  1.00 39.83           O  
ATOM   1284  N   SER   187     -18.167  -8.445  24.965  1.00 40.53           N  
ATOM   1285  CA  SER   187     -19.350  -9.129  24.488  1.00 41.39           C  
ATOM   1286  C   SER   187     -20.579  -8.234  24.546  1.00 40.22           C  
ATOM   1287  O   SER   187     -20.978  -7.820  25.624  1.00 40.70           O  
ATOM   1288  CB  SER   187     -19.578 -10.406  25.298  1.00 42.49           C  
ATOM   1289  OG  SER   187     -19.582 -10.126  26.684  1.00 44.00           O  
ATOM   1290  N   ALA   188     -21.157  -7.973  23.372  1.00 38.68           N  
ATOM   1291  CA  ALA   188     -22.369  -7.193  23.207  1.00 38.36           C  
ATOM   1292  C   ALA   188     -23.358  -7.535  24.313  1.00 37.68           C  
ATOM   1293  O   ALA   188     -23.562  -8.701  24.646  1.00 39.44           O  
ATOM   1294  CB  ALA   188     -22.978  -7.454  21.840  1.00 36.97           C  
ATOM   1295  N   LEU   189     -23.989  -6.506  24.834  1.00 37.15           N  
ATOM   1296  CA  LEU   189     -24.850  -6.570  26.003  1.00 38.47           C  
ATOM   1297  C   LEU   189     -26.162  -5.759  25.830  1.00 37.16           C  
ATOM   1298  O   LEU   189     -26.156  -4.703  25.248  1.00 37.13           O  
ATOM   1299  CB  LEU   189     -24.006  -5.922  27.127  1.00 38.77           C  
ATOM   1300  CG  LEU   189     -24.536  -5.584  28.514  1.00 40.39           C  
ATOM   1301  CD1 LEU   189     -24.419  -6.807  29.417  1.00 41.44           C  
ATOM   1302  CD2 LEU   189     -23.760  -4.419  29.132  1.00 40.31           C  
ATOM   1303  N   SER   190     -27.282  -6.254  26.331  1.00 37.95           N  
ATOM   1304  CA  SER   190     -28.518  -5.453  26.348  1.00 37.69           C  
ATOM   1305  C   SER   190     -28.605  -4.730  27.687  1.00 36.73           C  
ATOM   1306  O   SER   190     -27.894  -5.081  28.625  1.00 33.55           O  
ATOM   1307  CB  SER   190     -29.771  -6.342  26.171  1.00 37.26           C  
ATOM   1308  OG  SER   190     -30.007  -7.182  27.293  1.00 35.50           O  
ATOM   1309  N   PHE   191     -29.451  -3.695  27.775  1.00 38.21           N  
ATOM   1310  CA  PHE   191     -29.691  -3.038  29.055  1.00 36.68           C  
ATOM   1311  C   PHE   191     -30.306  -4.054  30.014  1.00 36.63           C  
ATOM   1312  O   PHE   191     -29.943  -4.074  31.177  1.00 36.15           O  
ATOM   1313  CB  PHE   191     -30.633  -1.846  28.929  1.00 37.61           C  
ATOM   1314  CG  PHE   191     -30.909  -1.152  30.230  1.00 37.73           C  
ATOM   1315  CD1 PHE   191     -29.970  -0.294  30.788  1.00 38.70           C  
ATOM   1316  CD2 PHE   191     -32.107  -1.347  30.903  1.00 38.74           C  
ATOM   1317  CE1 PHE   191     -30.217   0.351  31.989  1.00 37.92           C  
ATOM   1318  CE2 PHE   191     -32.360  -0.703  32.102  1.00 37.90           C  
ATOM   1319  CZ  PHE   191     -31.407   0.148  32.643  1.00 38.10           C  
ATOM   1320  N   ASP   192     -31.220  -4.911  29.537  1.00 36.19           N  
ATOM   1321  CA  ASP   192     -31.854  -5.864  30.429  1.00 35.73           C  
ATOM   1322  C   ASP   192     -30.837  -6.798  31.035  1.00 34.04           C  
ATOM   1323  O   ASP   192     -30.936  -7.099  32.218  1.00 31.85           O  
ATOM   1324  CB  ASP   192     -32.991  -6.668  29.769  1.00 36.97           C  
ATOM   1325  CG  ASP   192     -34.241  -5.818  29.511  1.00 37.83           C  
ATOM   1326  OD1 ASP   192     -34.239  -4.589  29.827  1.00 36.14           O  
ATOM   1327  OD2 ASP   192     -35.215  -6.396  28.968  1.00 37.83           O  
ATOM   1328  N   THR   193     -29.882  -7.251  30.228  1.00 33.57           N  
ATOM   1329  CA  THR   193     -28.784  -8.108  30.701  1.00 33.05           C  
ATOM   1330  C   THR   193     -27.885  -7.293  31.674  1.00 33.22           C  
ATOM   1331  O   THR   193     -27.553  -7.752  32.763  1.00 32.46           O  
ATOM   1332  CB  THR   193     -27.951  -8.657  29.516  1.00 33.39           C  
ATOM   1333  OG1 THR   193     -28.748  -9.558  28.714  1.00 32.30           O  
ATOM   1334  CG2 THR   193     -26.703  -9.397  29.999  1.00 32.95           C  
ATOM   1335  N   LEU   194     -27.530  -6.061  31.321  1.00 33.14           N  
ATOM   1336  CA  LEU   194     -26.707  -5.264  32.232  1.00 32.74           C  
ATOM   1337  C   LEU   194     -27.412  -5.148  33.579  1.00 34.32           C  
ATOM   1338  O   LEU   194     -26.905  -5.610  34.606  1.00 34.58           O  
ATOM   1339  CB  LEU   194     -26.451  -3.866  31.655  1.00 33.10           C  
ATOM   1340  CG  LEU   194     -25.699  -2.841  32.508  1.00 32.84           C  
ATOM   1341  CD1 LEU   194     -24.341  -3.367  32.928  1.00 32.94           C  
ATOM   1342  CD2 LEU   194     -25.598  -1.508  31.737  1.00 32.98           C  
ATOM   1343  N   ALA   195     -28.597  -4.546  33.576  1.00 35.92           N  
ATOM   1344  CA  ALA   195     -29.320  -4.299  34.825  1.00 37.64           C  
ATOM   1345  C   ALA   195     -29.554  -5.561  35.667  1.00 37.88           C  
ATOM   1346  O   ALA   195     -29.464  -5.514  36.880  1.00 40.48           O  
ATOM   1347  CB  ALA   195     -30.639  -3.534  34.551  1.00 36.84           C  
ATOM   1348  N   GLN   196     -29.800  -6.697  35.042  1.00 39.20           N  
ATOM   1349  CA  GLN   196     -30.019  -7.934  35.786  1.00 39.69           C  
ATOM   1350  C   GLN   196     -28.737  -8.493  36.437  1.00 40.33           C  
ATOM   1351  O   GLN   196     -28.802  -9.184  37.470  1.00 41.04           O  
ATOM   1352  CB  GLN   196     -30.624  -9.008  34.858  1.00 40.42           C  
ATOM   1353  CG  GLN   196     -30.778 -10.420  35.472  1.00 40.58           C  
ATOM   1354  CD  GLN   196     -31.645 -10.452  36.735  1.00 41.73           C  
ATOM   1355  OE1 GLN   196     -32.548  -9.633  36.907  1.00 43.88           O  
ATOM   1356  NE2 GLN   196     -31.391 -11.423  37.606  1.00 41.67           N  
ATOM   1357  N   THR   197     -27.588  -8.255  35.810  1.00 38.92           N  
ATOM   1358  CA  THR   197     -26.328  -8.785  36.321  1.00 37.94           C  
ATOM   1359  C   THR   197     -25.937  -8.023  37.571  1.00 36.70           C  
ATOM   1360  O   THR   197     -25.409  -8.630  38.485  1.00 35.53           O  
ATOM   1361  CB  THR   197     -25.192  -8.642  35.280  1.00 39.04           C  
ATOM   1362  OG1 THR   197     -25.568  -9.302  34.071  1.00 39.48           O  
ATOM   1363  CG2 THR   197     -23.883  -9.235  35.804  1.00 39.19           C  
ATOM   1364  N   LEU   198     -26.194  -6.700  37.581  1.00 33.17           N  
ATOM   1365  CA  LEU   198     -25.887  -5.832  38.711  1.00 33.38           C  
ATOM   1366  C   LEU   198     -26.846  -5.943  39.894  1.00 34.22           C  
ATOM   1367  O   LEU   198     -26.519  -5.510  41.000  1.00 33.03           O  
ATOM   1368  CB  LEU   198     -25.853  -4.354  38.276  1.00 32.60           C  
ATOM   1369  CG  LEU   198     -24.821  -3.832  37.292  1.00 32.72           C  
ATOM   1370  CD1 LEU   198     -25.148  -2.360  36.810  1.00 29.29           C  
ATOM   1371  CD2 LEU   198     -23.429  -3.896  37.907  1.00 33.12           C  
ATOM   1372  N   VAL   199     -28.022  -6.522  39.683  1.00 36.58           N  
ATOM   1373  CA  VAL   199     -29.008  -6.681  40.750  1.00 37.54           C  
ATOM   1374  C   VAL   199     -28.443  -7.249  42.050  1.00 39.42           C  
ATOM   1375  O   VAL   199     -28.828  -6.816  43.151  1.00 39.34           O  
ATOM   1376  CB  VAL   199     -30.224  -7.544  40.276  1.00 36.98           C  
ATOM   1377  CG1 VAL   199     -30.957  -8.122  41.434  1.00 35.71           C  
ATOM   1378  CG2 VAL   199     -31.155  -6.689  39.401  1.00 36.23           C  
ATOM   1379  N   GLU   200     -27.521  -8.200  41.945  1.00 41.22           N  
ATOM   1380  CA  GLU   200     -26.982  -8.823  43.150  1.00 42.00           C  
ATOM   1381  C   GLU   200     -25.916  -7.994  43.879  1.00 41.83           C  
ATOM   1382  O   GLU   200     -25.615  -8.261  45.037  1.00 42.68           O  
ATOM   1383  CB  GLU   200     -26.468 -10.245  42.873  1.00 42.76           C  
ATOM   1384  CG  GLU   200     -25.208 -10.396  42.009  1.00 42.85           C  
ATOM   1385  CD  GLU   200     -24.499 -11.743  42.272  1.00 43.32           C  
ATOM   1386  OE1 GLU   200     -24.374 -12.129  43.462  1.00 44.06           O  
ATOM   1387  OE2 GLU   200     -24.040 -12.401  41.308  1.00 43.24           O  
ATOM   1388  N   PHE   201     -25.351  -6.989  43.227  1.00 41.69           N  
ATOM   1389  CA  PHE   201     -24.333  -6.163  43.858  1.00 41.84           C  
ATOM   1390  C   PHE   201     -24.857  -4.766  44.149  1.00 41.15           C  
ATOM   1391  O   PHE   201     -24.074  -3.818  44.199  1.00 41.58           O  
ATOM   1392  CB  PHE   201     -23.119  -6.041  42.935  1.00 42.85           C  
ATOM   1393  CG  PHE   201     -22.711  -7.325  42.327  1.00 43.28           C  
ATOM   1394  CD1 PHE   201     -22.106  -8.313  43.106  1.00 43.38           C  
ATOM   1395  CD2 PHE   201     -22.944  -7.568  40.980  1.00 43.18           C  
ATOM   1396  CE1 PHE   201     -21.736  -9.526  42.544  1.00 43.77           C  
ATOM   1397  CE2 PHE   201     -22.571  -8.775  40.405  1.00 43.77           C  
ATOM   1398  CZ  PHE   201     -21.972  -9.757  41.185  1.00 43.34           C  
ATOM   1399  N   MET   202     -26.167  -4.644  44.337  1.00 39.31           N  
ATOM   1400  CA  MET   202     -26.809  -3.367  44.555  1.00 38.45           C  
ATOM   1401  C   MET   202     -27.879  -3.471  45.655  1.00 38.54           C  
ATOM   1402  O   MET   202     -28.298  -4.575  46.011  1.00 39.36           O  
ATOM   1403  CB  MET   202     -27.421  -2.925  43.232  1.00 38.67           C  
ATOM   1404  CG  MET   202     -26.387  -2.622  42.128  1.00 37.28           C  
ATOM   1405  SD  MET   202     -25.423  -0.969  42.396  0.75 37.93          SE  
ATOM   1406  CE  MET   202     -26.624   0.243  41.755  1.00 39.90           C  
ATOM   1407  N   PRO   203     -28.287  -2.338  46.245  1.00 37.65           N  
ATOM   1408  CA  PRO   203     -29.354  -2.368  47.264  1.00 38.20           C  
ATOM   1409  C   PRO   203     -30.669  -2.907  46.713  1.00 38.81           C  
ATOM   1410  O   PRO   203     -30.902  -2.803  45.508  1.00 39.63           O  
ATOM   1411  CB  PRO   203     -29.523  -0.895  47.649  1.00 37.58           C  
ATOM   1412  CG  PRO   203     -28.263  -0.263  47.275  1.00 37.55           C  
ATOM   1413  CD  PRO   203     -27.751  -0.990  46.059  1.00 37.28           C  
ATOM   1414  N   LYS   204     -31.508  -3.468  47.587  1.00 39.31           N  
ATOM   1415  CA  LYS   204     -32.810  -4.047  47.207  1.00 39.35           C  
ATOM   1416  C   LYS   204     -33.734  -3.053  46.477  1.00 39.72           C  
ATOM   1417  O   LYS   204     -34.442  -3.452  45.558  1.00 40.18           O  
ATOM   1418  CB  LYS   204     -33.521  -4.681  48.426  1.00 39.78           C  
ATOM   1419  N   ALA   205     -33.708  -1.778  46.879  1.00 38.98           N  
ATOM   1420  CA  ALA   205     -34.517  -0.728  46.255  1.00 38.75           C  
ATOM   1421  C   ALA   205     -33.930  -0.470  44.874  1.00 38.44           C  
ATOM   1422  O   ALA   205     -32.742  -0.128  44.749  1.00 37.86           O  
ATOM   1423  CB  ALA   205     -34.488   0.555  47.087  1.00 38.54           C  
ATOM   1424  N   ASP   206     -34.768  -0.614  43.846  1.00 37.50           N  
ATOM   1425  CA  ASP   206     -34.311  -0.545  42.470  1.00 35.82           C  
ATOM   1426  C   ASP   206     -34.325   0.809  41.811  1.00 32.28           C  
ATOM   1427  O   ASP   206     -34.361   0.864  40.607  1.00 31.31           O  
ATOM   1428  CB  ASP   206     -35.078  -1.551  41.596  1.00 38.60           C  
ATOM   1429  CG  ASP   206     -36.537  -1.153  41.345  1.00 40.47           C  
ATOM   1430  OD1 ASP   206     -36.912   0.028  41.591  1.00 39.42           O  
ATOM   1431  OD2 ASP   206     -37.295  -2.043  40.861  1.00 42.49           O  
ATOM   1432  N   ASN   207     -34.223   1.891  42.572  1.00 31.67           N  
ATOM   1433  CA  ASN   207     -34.119   3.245  41.978  1.00 30.34           C  
ATOM   1434  C   ASN   207     -32.881   3.443  41.059  1.00 32.22           C  
ATOM   1435  O   ASN   207     -32.851   4.328  40.140  1.00 32.13           O  
ATOM   1436  CB  ASN   207     -34.022   4.313  43.076  1.00 29.95           C  
ATOM   1437  CG  ASN   207     -35.200   4.302  44.057  1.00 28.77           C  
ATOM   1438  OD1 ASN   207     -35.559   3.275  44.609  1.00 29.54           O  
ATOM   1439  ND2 ASN   207     -35.755   5.465  44.307  1.00 27.36           N  
ATOM   1440  N   TRP   208     -31.817   2.694  41.364  1.00 32.69           N  
ATOM   1441  CA  TRP   208     -30.556   2.768  40.603  1.00 31.91           C  
ATOM   1442  C   TRP   208     -30.776   2.359  39.170  1.00 32.17           C  
ATOM   1443  O   TRP   208     -30.167   2.961  38.311  1.00 31.13           O  
ATOM   1444  CB  TRP   208     -29.448   1.923  41.247  1.00 32.15           C  
ATOM   1445  CG  TRP   208     -29.846   0.532  41.554  1.00 32.23           C  
ATOM   1446  CD1 TRP   208     -30.470   0.092  42.688  1.00 32.29           C  
ATOM   1447  CD2 TRP   208     -29.671  -0.626  40.718  1.00 32.46           C  
ATOM   1448  NE1 TRP   208     -30.690  -1.258  42.612  1.00 32.16           N  
ATOM   1449  CE2 TRP   208     -30.200  -1.727  41.418  1.00 32.61           C  
ATOM   1450  CE3 TRP   208     -29.107  -0.836  39.450  1.00 32.63           C  
ATOM   1451  CZ2 TRP   208     -30.182  -3.037  40.884  1.00 32.23           C  
ATOM   1452  CZ3 TRP   208     -29.099  -2.105  38.924  1.00 31.68           C  
ATOM   1453  CH2 TRP   208     -29.614  -3.200  39.643  1.00 31.68           C  
ATOM   1454  N   LYS   209     -31.621   1.339  38.918  1.00 33.06           N  
ATOM   1455  CA  LYS   209     -32.004   0.923  37.544  1.00 33.39           C  
ATOM   1456  C   LYS   209     -32.502   2.114  36.713  1.00 34.33           C  
ATOM   1457  O   LYS   209     -32.221   2.198  35.520  1.00 37.07           O  
ATOM   1458  CB  LYS   209     -33.085  -0.168  37.508  1.00 34.04           C  
ATOM   1459  CG  LYS   209     -32.646  -1.527  38.040  1.00 35.43           C  
ATOM   1460  CD  LYS   209     -33.611  -2.691  37.657  1.00 35.19           C  
ATOM   1461  CE  LYS   209     -33.276  -3.967  38.447  1.00 36.00           C  
ATOM   1462  NZ  LYS   209     -33.853  -5.242  37.838  1.00 36.60           N  
ATOM   1463  N   ASN   210     -33.244   3.027  37.304  1.00 34.51           N  
ATOM   1464  CA  ASN   210     -33.677   4.231  36.551  1.00 36.49           C  
ATOM   1465  C   ASN   210     -32.501   5.192  36.240  1.00 35.37           C  
ATOM   1466  O   ASN   210     -32.445   5.812  35.160  1.00 36.42           O  
ATOM   1467  CB  ASN   210     -34.839   4.942  37.274  1.00 37.19           C  
ATOM   1468  CG  ASN   210     -36.022   3.995  37.529  1.00 38.90           C  
ATOM   1469  OD1 ASN   210     -36.385   3.209  36.654  1.00 40.42           O  
ATOM   1470  ND2 ASN   210     -36.583   4.026  38.745  1.00 38.09           N  
ATOM   1471  N   ILE   211     -31.552   5.321  37.164  1.00 34.75           N  
ATOM   1472  CA  ILE   211     -30.402   6.196  36.933  1.00 34.72           C  
ATOM   1473  C   ILE   211     -29.506   5.618  35.844  1.00 33.48           C  
ATOM   1474  O   ILE   211     -28.947   6.352  35.002  1.00 29.16           O  
ATOM   1475  CB  ILE   211     -29.609   6.469  38.249  1.00 36.00           C  
ATOM   1476  CG1 ILE   211     -30.486   7.263  39.223  1.00 35.99           C  
ATOM   1477  CG2 ILE   211     -28.321   7.298  37.985  1.00 34.49           C  
ATOM   1478  CD1 ILE   211     -29.809   7.654  40.520  1.00 35.96           C  
ATOM   1479  N   LEU   212     -29.411   4.290  35.858  1.00 32.77           N  
ATOM   1480  CA  LEU   212     -28.597   3.560  34.949  1.00 33.23           C  
ATOM   1481  C   LEU   212     -29.152   3.659  33.546  1.00 34.91           C  
ATOM   1482  O   LEU   212     -28.404   3.863  32.587  1.00 34.20           O  
ATOM   1483  CB  LEU   212     -28.563   2.076  35.381  1.00 33.12           C  
ATOM   1484  CG  LEU   212     -27.602   1.182  34.612  1.00 33.09           C  
ATOM   1485  CD1 LEU   212     -26.133   1.627  34.822  1.00 31.85           C  
ATOM   1486  CD2 LEU   212     -27.801  -0.229  35.052  1.00 32.08           C  
ATOM   1487  N   LEU   213     -30.463   3.460  33.419  1.00 36.65           N  
ATOM   1488  CA  LEU   213     -31.106   3.532  32.112  1.00 37.15           C  
ATOM   1489  C   LEU   213     -30.851   4.917  31.550  1.00 36.30           C  
ATOM   1490  O   LEU   213     -30.586   5.053  30.373  1.00 36.77           O  
ATOM   1491  CB  LEU   213     -32.620   3.252  32.192  1.00 37.58           C  
ATOM   1492  CG  LEU   213     -33.371   3.435  30.867  1.00 36.80           C  
ATOM   1493  CD1 LEU   213     -32.675   2.648  29.761  1.00 36.19           C  
ATOM   1494  CD2 LEU   213     -34.842   3.031  31.016  1.00 36.87           C  
ATOM   1495  N   GLY   214     -30.914   5.934  32.394  1.00 36.15           N  
ATOM   1496  CA  GLY   214     -30.612   7.314  31.963  1.00 36.31           C  
ATOM   1497  C   GLY   214     -29.201   7.391  31.377  1.00 36.76           C  
ATOM   1498  O   GLY   214     -29.002   7.906  30.282  1.00 34.16           O  
ATOM   1499  N   LYS   215     -28.225   6.833  32.095  1.00 38.08           N  
ATOM   1500  CA  LYS   215     -26.839   6.832  31.623  1.00 39.02           C  
ATOM   1501  C   LYS   215     -26.714   6.102  30.291  1.00 38.67           C  
ATOM   1502  O   LYS   215     -26.045   6.582  29.393  1.00 40.02           O  
ATOM   1503  CB  LYS   215     -25.895   6.169  32.645  1.00 38.95           C  
ATOM   1504  CG  LYS   215     -24.460   6.012  32.121  1.00 40.11           C  
ATOM   1505  CD  LYS   215     -23.490   5.230  33.046  1.00 41.64           C  
ATOM   1506  CE  LYS   215     -23.872   3.752  33.214  1.00 42.33           C  
ATOM   1507  NZ  LYS   215     -24.217   3.083  31.907  1.00 42.80           N  
ATOM   1508  N   TRP   216     -27.320   4.911  30.213  1.00 38.44           N  
ATOM   1509  CA  TRP   216     -27.328   4.055  29.010  1.00 37.73           C  
ATOM   1510  C   TRP   216     -27.931   4.760  27.802  1.00 36.69           C  
ATOM   1511  O   TRP   216     -27.353   4.712  26.709  1.00 37.44           O  
ATOM   1512  CB  TRP   216     -28.109   2.800  29.321  1.00 37.33           C  
ATOM   1513  CG  TRP   216     -28.319   1.837  28.235  1.00 37.88           C  
ATOM   1514  CD1 TRP   216     -29.384   1.799  27.373  1.00 37.86           C  
ATOM   1515  CD2 TRP   216     -27.541   0.663  27.956  1.00 37.86           C  
ATOM   1516  NE1 TRP   216     -29.269   0.727  26.545  1.00 37.80           N  
ATOM   1517  CE2 TRP   216     -28.155   0.008  26.880  1.00 37.05           C  
ATOM   1518  CE3 TRP   216     -26.355   0.134  28.475  1.00 37.81           C  
ATOM   1519  CZ2 TRP   216     -27.627  -1.142  26.312  1.00 37.75           C  
ATOM   1520  CZ3 TRP   216     -25.836  -1.013  27.910  1.00 37.54           C  
ATOM   1521  CH2 TRP   216     -26.476  -1.650  26.857  1.00 37.69           C  
ATOM   1522  N   SER   217     -29.079   5.405  28.011  1.00 34.69           N  
ATOM   1523  CA  SER   217     -29.758   6.195  26.964  1.00 34.80           C  
ATOM   1524  C   SER   217     -28.914   7.353  26.456  1.00 34.06           C  
ATOM   1525  O   SER   217     -28.999   7.724  25.289  1.00 34.05           O  
ATOM   1526  CB  SER   217     -31.099   6.759  27.465  1.00 34.33           C  
ATOM   1527  OG  SER   217     -32.049   5.728  27.666  1.00 34.19           O  
ATOM   1528  N   GLY   218     -28.151   7.959  27.359  1.00 34.17           N  
ATOM   1529  CA  GLY   218     -27.270   9.076  27.018  1.00 33.98           C  
ATOM   1530  C   GLY   218     -26.109   8.619  26.147  1.00 33.23           C  
ATOM   1531  O   GLY   218     -25.666   9.331  25.281  1.00 32.30           O  
ATOM   1532  N   TRP   219     -25.619   7.404  26.391  1.00 33.89           N  
ATOM   1533  CA  TRP   219     -24.562   6.807  25.584  1.00 32.51           C  
ATOM   1534  C   TRP   219     -25.056   6.479  24.156  1.00 31.46           C  
ATOM   1535  O   TRP   219     -24.291   6.485  23.200  1.00 29.93           O  
ATOM   1536  CB  TRP   219     -24.075   5.544  26.315  1.00 34.90           C  
ATOM   1537  CG  TRP   219     -23.044   5.761  27.391  1.00 35.00           C  
ATOM   1538  CD1 TRP   219     -22.690   6.928  27.981  1.00 36.21           C  
ATOM   1539  CD2 TRP   219     -22.297   4.739  28.054  1.00 36.69           C  
ATOM   1540  NE1 TRP   219     -21.727   6.712  28.932  1.00 36.02           N  
ATOM   1541  CE2 TRP   219     -21.464   5.373  29.002  1.00 36.36           C  
ATOM   1542  CE3 TRP   219     -22.238   3.354  27.922  1.00 35.77           C  
ATOM   1543  CZ2 TRP   219     -20.568   4.665  29.819  1.00 36.18           C  
ATOM   1544  CZ3 TRP   219     -21.332   2.630  28.736  1.00 36.36           C  
ATOM   1545  CH2 TRP   219     -20.526   3.286  29.680  1.00 36.68           C  
ATOM   1546  N   ILE   220     -26.332   6.140  24.019  1.00 31.33           N  
ATOM   1547  CA  ILE   220     -26.941   5.905  22.713  1.00 31.05           C  
ATOM   1548  C   ILE   220     -27.082   7.237  21.940  1.00 33.15           C  
ATOM   1549  O   ILE   220     -26.722   7.330  20.755  1.00 32.49           O  
ATOM   1550  CB  ILE   220     -28.304   5.253  22.875  1.00 29.75           C  
ATOM   1551  CG1 ILE   220     -28.157   3.828  23.465  1.00 29.30           C  
ATOM   1552  CG2 ILE   220     -29.014   5.142  21.512  1.00 30.31           C  
ATOM   1553  CD1 ILE   220     -29.494   3.274  23.922  1.00 28.25           C  
ATOM   1554  N   GLU   221     -27.604   8.262  22.608  1.00 35.10           N  
ATOM   1555  CA  GLU   221     -27.741   9.611  21.989  1.00 35.33           C  
ATOM   1556  C   GLU   221     -26.379  10.186  21.502  1.00 36.09           C  
ATOM   1557  O   GLU   221     -26.283  10.752  20.409  1.00 37.21           O  
ATOM   1558  CB  GLU   221     -28.410  10.577  22.987  1.00 36.75           C  
ATOM   1559  CG  GLU   221     -28.923  11.952  22.398  1.00 38.27           C  
ATOM   1560  CD  GLU   221     -27.892  13.097  22.374  1.00 41.37           C  
ATOM   1561  OE1 GLU   221     -26.798  12.930  22.990  1.00 42.19           O  
ATOM   1562  OE2 GLU   221     -28.193  14.192  21.752  1.00 42.76           O  
ATOM   1563  N   GLN   222     -25.344  10.047  22.328  1.00 36.89           N  
ATOM   1564  CA  GLN   222     -23.983  10.545  22.027  1.00 36.28           C  
ATOM   1565  C   GLN   222     -23.212   9.642  21.077  1.00 34.50           C  
ATOM   1566  O   GLN   222     -22.091   9.950  20.718  1.00 31.88           O  
ATOM   1567  CB  GLN   222     -23.159  10.657  23.322  1.00 37.58           C  
ATOM   1568  CG  GLN   222     -23.716  11.611  24.368  1.00 39.28           C  
ATOM   1569  CD  GLN   222     -23.446  13.088  24.074  1.00 41.32           C  
ATOM   1570  OE1 GLN   222     -22.294  13.500  23.894  1.00 43.78           O  
ATOM   1571  NE2 GLN   222     -24.511  13.897  24.041  1.00 40.72           N  
ATOM   1572  N   ARG   223     -23.787   8.494  20.735  1.00 34.13           N  
ATOM   1573  CA  ARG   223     -23.179   7.523  19.831  1.00 33.61           C  
ATOM   1574  C   ARG   223     -21.917   6.873  20.400  1.00 34.35           C  
ATOM   1575  O   ARG   223     -20.949   6.632  19.654  1.00 35.88           O  
ATOM   1576  CB  ARG   223     -22.898   8.168  18.485  1.00 34.96           C  
ATOM   1577  CG  ARG   223     -22.824   7.244  17.284  1.00 35.66           C  
ATOM   1578  CD  ARG   223     -22.314   8.071  16.136  1.00 36.64           C  
ATOM   1579  NE  ARG   223     -22.460   7.421  14.851  1.00 36.77           N  
ATOM   1580  CZ  ARG   223     -22.173   8.005  13.695  1.00 37.14           C  
ATOM   1581  NH1 ARG   223     -21.712   9.244  13.648  1.00 37.54           N  
ATOM   1582  NH2 ARG   223     -22.356   7.338  12.565  1.00 38.08           N  
ATOM   1583  N   ILE   224     -21.926   6.592  21.712  1.00 32.16           N  
ATOM   1584  CA  ILE   224     -20.824   5.884  22.403  1.00 30.24           C  
ATOM   1585  C   ILE   224     -21.037   4.388  22.261  1.00 29.99           C  
ATOM   1586  O   ILE   224     -20.081   3.600  22.134  1.00 26.56           O  
ATOM   1587  CB  ILE   224     -20.757   6.269  23.908  1.00 29.79           C  
ATOM   1588  CG1 ILE   224     -20.396   7.761  24.076  1.00 29.73           C  
ATOM   1589  CG2 ILE   224     -19.763   5.447  24.614  1.00 30.17           C  
ATOM   1590  CD1 ILE   224     -20.563   8.314  25.494  1.00 29.42           C  
ATOM   1591  N   ILE   225     -22.312   3.986  22.300  1.00 30.18           N  
ATOM   1592  CA  ILE   225     -22.678   2.590  22.089  1.00 28.73           C  
ATOM   1593  C   ILE   225     -23.656   2.595  20.934  1.00 30.68           C  
ATOM   1594  O   ILE   225     -24.386   3.580  20.726  1.00 30.26           O  
ATOM   1595  CB  ILE   225     -23.200   1.918  23.379  1.00 28.42           C  
ATOM   1596  CG1 ILE   225     -24.620   2.348  23.737  1.00 26.99           C  
ATOM   1597  CG2 ILE   225     -22.217   2.217  24.514  1.00 29.60           C  
ATOM   1598  CD1 ILE   225     -25.110   1.976  25.113  1.00 26.01           C  
ATOM   1599  N   ILE   226     -23.642   1.506  20.155  1.00 30.62           N  
ATOM   1600  CA  ILE   226     -24.499   1.394  18.976  1.00 30.56           C  
ATOM   1601  C   ILE   226     -25.110   0.009  18.972  1.00 29.99           C  
ATOM   1602  O   ILE   226     -24.574  -0.883  19.606  1.00 28.78           O  
ATOM   1603  CB  ILE   226     -23.740   1.708  17.596  1.00 30.62           C  
ATOM   1604  CG1 ILE   226     -22.567   0.765  17.340  1.00 30.74           C  
ATOM   1605  CG2 ILE   226     -23.274   3.214  17.504  1.00 30.74           C  
ATOM   1606  CD1 ILE   226     -21.914   0.946  15.918  1.00 30.80           C  
ATOM   1607  N   PRO   227     -26.270  -0.161  18.317  1.00 30.20           N  
ATOM   1608  CA  PRO   227     -26.836  -1.526  18.246  1.00 30.62           C  
ATOM   1609  C   PRO   227     -25.852  -2.518  17.629  1.00 33.79           C  
ATOM   1610  O   PRO   227     -25.105  -2.175  16.706  1.00 32.59           O  
ATOM   1611  CB  PRO   227     -28.079  -1.360  17.373  1.00 29.34           C  
ATOM   1612  CG  PRO   227     -28.421   0.098  17.460  1.00 29.26           C  
ATOM   1613  CD  PRO   227     -27.145   0.845  17.691  1.00 29.25           C  
ATOM   1614  N   SER   228     -25.827  -3.722  18.183  1.00 37.62           N  
ATOM   1615  CA  SER   228     -24.979  -4.781  17.679  1.00 40.86           C  
ATOM   1616  C   SER   228     -25.762  -5.611  16.664  1.00 43.11           C  
ATOM   1617  O   SER   228     -26.490  -6.533  17.032  1.00 44.20           O  
ATOM   1618  CB  SER   228     -24.474  -5.666  18.812  1.00 40.76           C  
ATOM   1619  OG  SER   228     -23.551  -6.594  18.271  1.00 41.97           O  
ATOM   1620  N   LEU   229     -25.572  -5.292  15.386  1.00 45.83           N  
ATOM   1621  CA  LEU   229     -26.333  -5.890  14.290  1.00 47.76           C  
ATOM   1622  C   LEU   229     -25.604  -7.011  13.560  1.00 49.40           C  
ATOM   1623  O   LEU   229     -24.593  -6.779  12.910  1.00 49.60           O  
ATOM   1624  CB  LEU   229     -26.711  -4.786  13.289  1.00 47.66           C  
ATOM   1625  CG  LEU   229     -27.607  -3.690  13.883  1.00 47.20           C  
ATOM   1626  CD1 LEU   229     -27.754  -2.509  12.947  1.00 46.75           C  
ATOM   1627  CD2 LEU   229     -28.965  -4.279  14.249  1.00 47.53           C  
ATOM   1628  N   SER   230     -26.155  -8.220  13.659  1.00 51.73           N  
ATOM   1629  CA  SER   230     -25.586  -9.409  13.031  1.00 52.88           C  
ATOM   1630  C   SER   230     -26.236  -9.706  11.680  1.00 53.74           C  
ATOM   1631  O   SER   230     -25.565  -9.657  10.646  1.00 54.94           O  
ATOM   1632  CB  SER   230     -25.730 -10.610  13.970  1.00 52.98           C  
ATOM   1633  OG  SER   230     -25.042 -10.362  15.191  1.00 53.17           O  
END
