
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 ( 1034),  selected  124 , name 3lyn_B
# Molecule2: number of CA atoms   66 (  553),  selected   66 , name T0443_31_96.pdb
# PARAMETERS: 3lyn_B.T0443_31_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    I    11_B      -       -           -
LGA    N    12_B      -       -           -
LGA    K    13_B      -       -           -
LGA    A    14_B      L      31           #
LGA    Y    15_B      -       -           -
LGA    E    16_B      N      32          4.342
LGA    V    17_B      V      33          2.672
LGA    T    18_B      -       -           -
LGA    M    19_B      Y      34          2.092
LGA    K    20_B      I      35          0.479
LGA    I    21_B      R      36          2.369
LGA    Q    22_B      L      37          2.397
LGA    I    23_B      I      38          1.174
LGA    I    24_B      R      39          0.558
LGA    S    25_B      N      40          1.742
LGA    G    26_B      N      41          1.425
LGA    F    27_B      I      42          0.392
LGA    D    28_B      H      43          1.021
LGA    R    29_B      S      44          1.192
LGA    Q    30_B      F      45          1.233
LGA    L    31_B      I      46          1.639
LGA    T    32_B      D      47          1.394
LGA    A    33_B      R      48          0.763
LGA    W    34_B      C      49          2.683
LGA    L    35_B      Y      50          3.420
LGA    R    36_B      T      51          1.285
LGA    V    37_B      E      52          2.485
LGA    H    38_B      T      53          1.537
LGA    G    39_B      R      54          1.389
LGA    R    40_B      Q      55          1.541
LGA    R    41_B      Y      56          1.163
LGA    L    42_B      F      57          1.525
LGA    T    43_B      D      58          2.631
LGA    N    44_B      S      59          2.876
LGA    N    45_B      K      60          3.358
LGA    Q    46_B      E      61          2.262
LGA    K    47_B      W      62          0.123
LGA    K    48_B      S      63          1.639
LGA    T    49_B      R      64          1.305
LGA    L    50_B      L      65          2.044
LGA    F    51_B      K      66          2.452
LGA    F    52_B      E      67          0.514
LGA    V    53_B      G      68          2.411
LGA    N    54_B      F      69          3.975
LGA    R    55_B      V      70          2.605
LGA    R    56_B      R      71          0.557
LGA    Y    57_B      D      72          3.296
LGA    M    58_B      -       -           -
LGA    Q    59_B      -       -           -
LGA    T    60_B      A      73          3.179
LGA    H    61_B      R      74          5.942
LGA    -       -      A      75           -
LGA    W    62_B      Q      76          4.917
LGA    Q    63_B      -       -           -
LGA    N    64_B      T      77           #
LGA    Y    65_B      P      78          4.583
LGA    M    66_B      -       -           -
LGA    L    67_B      -       -           -
LGA    W    68_B      -       -           -
LGA    V    69_B      -       -           -
LGA    K    70_B      -       -           -
LGA    R    71_B      -       -           -
LGA    K    72_B      -       -           -
LGA    I    73_B      -       -           -
LGA    K    74_B      -       -           -
LGA    A    75_B      -       -           -
LGA    L    76_B      -       -           -
LGA    G    77_B      -       -           -
LGA    R    78_B      -       -           -
LGA    P    79_B      -       -           -
LGA    A    80_B      -       -           -
LGA    A    81_B      -       -           -
LGA    V    82_B      -       -           -
LGA    G    83_B      -       -           -
LGA    D    84_B      -       -           -
LGA    Y    85_B      -       -           -
LGA    T    86_B      -       -           -
LGA    R    87_B      -       -           -
LGA    L    88_B      -       -           -
LGA    G    89_B      -       -           -
LGA    A    90_B      -       -           -
LGA    E    91_B      -       -           -
LGA    I    92_B      -       -           -
LGA    G    93_B      Y      79           #
LGA    R    94_B      F      80          3.158
LGA    R    95_B      Q      81          2.183
LGA    V    96_B      E      82          2.936
LGA    D    97_B      I      83          2.277
LGA    M    98_B      -       -           -
LGA    V    99_B      P      84          1.917
LGA    F   100_B      G      85          2.010
LGA    F   101_B      E      86          3.356
LGA    Y   102_B      F      87          3.214
LGA    N   103_B      L      88          2.684
LGA    F   104_B      Q      89          3.602
LGA    -       -      Y      90           -
LGA    L   105_B      C      91          1.202
LGA    S   106_B      Q      92           #
LGA    G   107_B      S      93           -
LGA    -       -      L      94           -
LGA    R   108_B      P      95          4.119
LGA    K   109_B      L      96          1.725
LGA    M   110_B      -       -           -
LGA    I   111_B      -       -           -
LGA    P   112_B      -       -           -
LGA    P   113_B      -       -           -
LGA    Y   114_B      -       -           -
LGA    S   115_B      -       -           -
LGA    A   116_B      -       -           -
LGA    Y   117_B      -       -           -
LGA    M   118_B      -       -           -
LGA    A   119_B      -       -           -
LGA    K   120_B      -       -           -
LGA    L   121_B      -       -           -
LGA    N   122_B      -       -           -
LGA    A   123_B      -       -           -
LGA    L   124_B      -       -           -
LGA    R   125_B      -       -           -
LGA    P   126_B      -       -           -
LGA    A   127_B      -       -           -
LGA    D   128_B      -       -           -
LGA    V   129_B      -       -           -
LGA    P   130_B      -       -           -
LGA    V   131_B      -       -           -
LGA    K   132_B      -       -           -
LGA    N   133_B      -       -           -
LGA    H   134_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124   66    5.0     58    2.53     6.90     62.769     2.206

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.435128 * X  +   0.736682 * Y  +   0.517652 * Z  + -128.923172
  Y_new =  -0.130673 * X  +  -0.517175 * Y  +   0.845845 * Z  + -82.834808
  Z_new =   0.890836 * X  +  -0.435694 * Y  +  -0.128773 * Z  +  -7.906441 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.858173    1.283419  [ DEG:  -106.4655     73.5345 ]
  Theta =  -1.099182   -2.042411  [ DEG:   -62.9785   -117.0215 ]
  Phi   =  -0.291740    2.849852  [ DEG:   -16.7155    163.2845 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3lyn_B                                        
REMARK     2: T0443_31_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3lyn_B.T0443_31_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124   66   5.0   58   2.53    6.90  62.769
REMARK  ---------------------------------------------------------- 
MOLECULE 3lyn_B
HEADER    CELL ADHESION                           19-MAY-99   3LYN              
TITLE     STRUCTURE OF GREEN ABALONE LYSIN DIMER                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SPERM LYSIN;                                               
COMPND   3 CHAIN: A, B                                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HALIOTIS FULGENS;                               
SOURCE   3 ORGANISM_COMMON: GREEN ABALONE;                                      
SOURCE   4 ORGAN: GONAD;                                                        
SOURCE   5 CELL: SPERM;                                                         
SOURCE   6 ORGANELLE: ACROSOME GRANULE                                          
KEYWDS    ABALONE LYSIN, FERTILIZATION PROTEIN, GAMETE RECOGNITION              
KEYWDS   2 PROTEIN                                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.KRESGE,V.D.VACQUIER,C.D.STOUT                                       
REVDAT   1   15-MAR-00 3LYN    0                                                
JRNL        AUTH   N.KRESGE,V.D.VACQUIER,C.D.STOUT                              
JRNL        TITL   THE HIGH RESOLUTION CRYSTAL STRUCTURE OF GREEN               
JRNL        TITL 2 ABALONE SPERM LYSIN: IMPLICATIONS FOR                        
JRNL        TITL 3 SPECIES-SPECIFIC BINDING OF THE EGG RECEPTOR.                
JRNL        REF    J.MOL.BIOL.                   V. 296  1225 2000              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  3LYN A    1   136  UNP    Q01381   ELYS_HALFU      19    154             
DBREF  3LYN B    1   136  UNP    Q01381   ELYS_HALFU      19    154             
SEQRES   1 A  136  ARG ARG TRP THR PHE VAL ARG TYR HIS TYR ILE ASN LYS          
SEQRES   2 A  136  ALA TYR GLU VAL THR MET LYS ILE GLN ILE ILE SER GLY          
SEQRES   3 A  136  PHE ASP ARG GLN LEU THR ALA TRP LEU ARG VAL HIS GLY          
SEQRES   4 A  136  ARG ARG LEU THR ASN ASN GLN LYS LYS THR LEU PHE PHE          
SEQRES   5 A  136  VAL ASN ARG ARG TYR MET GLN THR HIS TRP GLN ASN TYR          
SEQRES   6 A  136  MET LEU TRP VAL LYS ARG LYS ILE LYS ALA LEU GLY ARG          
SEQRES   7 A  136  PRO ALA ALA VAL GLY ASP TYR THR ARG LEU GLY ALA GLU          
SEQRES   8 A  136  ILE GLY ARG ARG VAL ASP MET VAL PHE PHE TYR ASN PHE          
SEQRES   9 A  136  LEU SER GLY ARG LYS MET ILE PRO PRO TYR SER ALA TYR          
SEQRES  10 A  136  MET ALA LYS LEU ASN ALA LEU ARG PRO ALA ASP VAL PRO          
SEQRES  11 A  136  VAL LYS ASN HIS GLY LYS                                      
SEQRES   1 B  136  ARG ARG TRP THR PHE VAL ARG TYR HIS TYR ILE ASN LYS          
SEQRES   2 B  136  ALA TYR GLU VAL THR MET LYS ILE GLN ILE ILE SER GLY          
SEQRES   3 B  136  PHE ASP ARG GLN LEU THR ALA TRP LEU ARG VAL HIS GLY          
SEQRES   4 B  136  ARG ARG LEU THR ASN ASN GLN LYS LYS THR LEU PHE PHE          
SEQRES   5 B  136  VAL ASN ARG ARG TYR MET GLN THR HIS TRP GLN ASN TYR          
SEQRES   6 B  136  MET LEU TRP VAL LYS ARG LYS ILE LYS ALA LEU GLY ARG          
SEQRES   7 B  136  PRO ALA ALA VAL GLY ASP TYR THR ARG LEU GLY ALA GLU          
SEQRES   8 B  136  ILE GLY ARG ARG VAL ASP MET VAL PHE PHE TYR ASN PHE          
SEQRES   9 B  136  LEU SER GLY ARG LYS MET ILE PRO PRO TYR SER ALA TYR          
SEQRES  10 B  136  MET ALA LYS LEU ASN ALA LEU ARG PRO ALA ASP VAL PRO          
SEQRES  11 B  136  VAL LYS ASN HIS GLY LYS                                      
FORMUL   3  HOH   *218(H2 O)                                                    
CRYST1  119.170  119.170   51.290  90.00  90.00 120.00 P 61         12          
ATOM   1018  N   ILE B  11      13.654   2.469 -10.401  1.00 60.10           N  
ATOM   1019  CA  ILE B  11      12.705   3.505 -10.826  1.00 42.25           C  
ATOM   1020  C   ILE B  11      13.419   4.731 -11.368  1.00 27.30           C  
ATOM   1021  O   ILE B  11      14.415   5.209 -10.821  1.00 34.36           O  
ATOM   1022  CB  ILE B  11      11.785   3.856  -9.644  1.00 48.97           C  
ATOM   1023  CG1 ILE B  11      11.046   5.179  -9.750  1.00 39.81           C  
ATOM   1024  CG2 ILE B  11      12.605   3.807  -8.359  1.00 67.32           C  
ATOM   1025  CD1 ILE B  11      10.978   5.924  -8.433  1.00 45.74           C  
ATOM   1026  N   ASN B  12      12.912   5.263 -12.485  1.00 24.71           N  
ATOM   1027  CA  ASN B  12      13.714   6.309 -13.124  1.00 24.45           C  
ATOM   1028  C   ASN B  12      13.713   7.596 -12.308  1.00 24.17           C  
ATOM   1029  O   ASN B  12      12.862   7.881 -11.468  1.00 21.97           O  
ATOM   1030  CB  ASN B  12      13.274   6.555 -14.568  1.00 28.44           C  
ATOM   1031  CG  ASN B  12      11.996   7.308 -14.793  1.00 41.78           C  
ATOM   1032  OD1 ASN B  12      11.693   8.336 -14.177  1.00 45.14           O  
ATOM   1033  ND2 ASN B  12      11.195   6.795 -15.736  1.00 47.09           N  
ATOM   1034  N   LYS B  13      14.737   8.397 -12.598  1.00 21.03           N  
ATOM   1035  CA  LYS B  13      14.999   9.637 -11.898  1.00 19.76           C  
ATOM   1036  C   LYS B  13      13.810  10.594 -11.881  1.00 21.49           C  
ATOM   1037  O   LYS B  13      13.544  11.156 -10.825  1.00 18.99           O  
ATOM   1038  CB  LYS B  13      16.205  10.367 -12.520  1.00 21.37           C  
ATOM   1039  CG  LYS B  13      16.490  11.691 -11.803  1.00 26.53           C  
ATOM   1040  CD  LYS B  13      16.694  11.415 -10.308  1.00 41.96           C  
ATOM   1041  CE  LYS B  13      17.444  12.566  -9.644  1.00 55.81           C  
ATOM   1042  NZ  LYS B  13      17.382  13.800 -10.478  1.00 97.55           N  
ATOM   1043  N   ALA B  14      13.132  10.793 -13.008  1.00 18.73           N  
ATOM   1044  CA  ALA B  14      12.008  11.732 -13.022  1.00 21.32           C  
ATOM   1045  C   ALA B  14      10.902  11.241 -12.091  1.00 16.12           C  
ATOM   1046  O   ALA B  14      10.192  11.988 -11.423  1.00 16.54           O  
ATOM   1047  CB  ALA B  14      11.457  11.932 -14.430  1.00 23.51           C  
ATOM   1048  N   TYR B  15      10.726   9.924 -12.076  1.00 14.67           N  
ATOM   1049  CA  TYR B  15       9.670   9.389 -11.221  1.00 16.80           C  
ATOM   1050  C   TYR B  15      10.071   9.499  -9.748  1.00 16.99           C  
ATOM   1051  O   TYR B  15       9.255   9.765  -8.857  1.00 16.08           O  
ATOM   1052  CB  TYR B  15       9.432   7.929 -11.621  1.00 20.69           C  
ATOM   1053  CG  TYR B  15       8.864   7.731 -13.013  1.00 18.88           C  
ATOM   1054  CD1 TYR B  15       8.303   8.752 -13.756  1.00 24.08           C  
ATOM   1055  CD2 TYR B  15       8.915   6.452 -13.554  1.00 22.52           C  
ATOM   1056  CE1 TYR B  15       7.793   8.516 -15.024  1.00 23.85           C  
ATOM   1057  CE2 TYR B  15       8.402   6.218 -14.810  1.00 22.70           C  
ATOM   1058  CZ  TYR B  15       7.851   7.239 -15.532  1.00 21.86           C  
ATOM   1059  OH  TYR B  15       7.355   6.977 -16.793  1.00 31.19           O  
ATOM   1060  N   GLU B  16      11.355   9.264  -9.515  1.00 15.60           N  
ATOM   1061  CA  GLU B  16      11.903   9.421  -8.176  1.00 17.75           C  
ATOM   1062  C   GLU B  16      11.609  10.832  -7.681  1.00 21.91           C  
ATOM   1063  O   GLU B  16      11.156  11.043  -6.549  1.00 19.60           O  
ATOM   1064  CB  GLU B  16      13.408   9.149  -8.146  1.00 17.94           C  
ATOM   1065  CG  GLU B  16      14.040   9.636  -6.840  1.00 22.26           C  
ATOM   1066  CD  GLU B  16      15.555   9.615  -6.884  1.00 28.52           C  
ATOM   1067  OE1 GLU B  16      16.076   8.729  -7.589  1.00 36.35           O  
ATOM   1068  OE2 GLU B  16      16.195  10.471  -6.232  1.00 27.01           O  
ATOM   1069  N   VAL B  17      11.881  11.815  -8.538  1.00 14.90           N  
ATOM   1070  CA  VAL B  17      11.714  13.198  -8.076  1.00 15.61           C  
ATOM   1071  C   VAL B  17      10.271  13.518  -7.744  1.00 14.99           C  
ATOM   1072  O   VAL B  17       9.986  14.114  -6.699  1.00 15.00           O  
ATOM   1073  CB  VAL B  17      12.275  14.176  -9.131  1.00 19.77           C  
ATOM   1074  CG1 VAL B  17      11.802  15.594  -8.845  1.00 20.29           C  
ATOM   1075  CG2 VAL B  17      13.803  14.093  -9.128  1.00 23.00           C  
ATOM   1076  N   THR B  18       9.286  13.162  -8.591  1.00 14.33           N  
ATOM   1077  CA  THR B  18       7.915  13.545  -8.194  1.00 13.89           C  
ATOM   1078  C   THR B  18       7.511  12.811  -6.911  1.00 13.93           C  
ATOM   1079  O   THR B  18       6.786  13.342  -6.072  1.00 14.65           O  
ATOM   1080  CB  THR B  18       6.936  13.303  -9.350  1.00 12.87           C  
ATOM   1081  OG1 THR B  18       5.681  13.891  -9.034  1.00 14.96           O  
ATOM   1082  CG2 THR B  18       6.671  11.810  -9.580  1.00 17.29           C  
ATOM   1083  N   MET B  19       8.009  11.593  -6.698  1.00 14.79           N  
ATOM   1084  CA  MET B  19       7.621  10.889  -5.460  1.00 16.29           C  
ATOM   1085  C   MET B  19       8.213  11.543  -4.216  1.00 15.91           C  
ATOM   1086  O   MET B  19       7.491  11.693  -3.210  1.00 15.46           O  
ATOM   1087  CB  MET B  19       8.000   9.405  -5.569  1.00 14.04           C  
ATOM   1088  CG  MET B  19       6.844   8.767  -6.367  0.50 13.42           C  
ATOM   1090  SD  MET B  19       6.664   7.007  -6.121  0.50 24.43           S  
ATOM   1092  CE  MET B  19       8.298   6.443  -6.586  0.50 10.17           C  
ATOM   1094  N   LYS B  20       9.464  11.955  -4.252  1.00 14.33           N  
ATOM   1095  CA  LYS B  20      10.070  12.612  -3.072  1.00 11.20           C  
ATOM   1096  C   LYS B  20       9.327  13.889  -2.732  1.00 16.78           C  
ATOM   1097  O   LYS B  20       9.086  14.180  -1.555  1.00 16.72           O  
ATOM   1098  CB  LYS B  20      11.546  12.911  -3.339  1.00 11.19           C  
ATOM   1099  CG  LYS B  20      12.371  11.638  -3.515  1.00 16.55           C  
ATOM   1100  CD  LYS B  20      13.869  11.883  -3.410  1.00 17.32           C  
ATOM   1101  CE  LYS B  20      14.352  12.866  -4.460  1.00 20.23           C  
ATOM   1102  NZ  LYS B  20      15.853  12.791  -4.587  1.00 20.58           N  
ATOM   1103  N   ILE B  21       8.974  14.640  -3.804  1.00 14.42           N  
ATOM   1104  CA  ILE B  21       8.233  15.869  -3.548  1.00 17.43           C  
ATOM   1105  C   ILE B  21       6.904  15.606  -2.868  1.00 14.05           C  
ATOM   1106  O   ILE B  21       6.539  16.261  -1.882  1.00 16.74           O  
ATOM   1107  CB  ILE B  21       7.966  16.613  -4.886  1.00 20.21           C  
ATOM   1108  CG1 ILE B  21       9.270  17.152  -5.473  1.00 17.99           C  
ATOM   1109  CG2 ILE B  21       6.902  17.676  -4.717  1.00 20.78           C  
ATOM   1110  CD1 ILE B  21       9.057  17.715  -6.869  1.00 17.44           C  
ATOM   1111  N   GLN B  22       6.153  14.654  -3.419  1.00 15.31           N  
ATOM   1112  CA  GLN B  22       4.814  14.386  -2.878  1.00 14.94           C  
ATOM   1113  C   GLN B  22       4.867  13.751  -1.486  1.00 14.16           C  
ATOM   1114  O   GLN B  22       4.032  14.077  -0.658  1.00 16.92           O  
ATOM   1115  CB  GLN B  22       4.053  13.454  -3.825  1.00 13.76           C  
ATOM   1116  CG  GLN B  22       3.781  14.093  -5.194  1.00 13.52           C  
ATOM   1117  CD  GLN B  22       2.876  15.308  -5.110  1.00 18.91           C  
ATOM   1118  OE1 GLN B  22       1.944  15.348  -4.311  1.00 21.53           O  
ATOM   1119  NE2 GLN B  22       3.094  16.335  -5.924  1.00 23.88           N  
ATOM   1120  N   ILE B  23       5.821  12.846  -1.270  1.00 16.74           N  
ATOM   1121  CA  ILE B  23       5.931  12.220   0.048  1.00 13.03           C  
ATOM   1122  C   ILE B  23       6.319  13.227   1.108  1.00 14.71           C  
ATOM   1123  O   ILE B  23       5.708  13.283   2.175  1.00 17.47           O  
ATOM   1124  CB  ILE B  23       6.950  11.063   0.009  1.00 17.46           C  
ATOM   1125  CG1 ILE B  23       6.503   9.912  -0.894  1.00 14.44           C  
ATOM   1126  CG2 ILE B  23       7.253  10.552   1.413  1.00 15.84           C  
ATOM   1127  CD1 ILE B  23       7.568   8.861  -1.148  1.00 14.23           C  
ATOM   1128  N   ILE B  24       7.345  14.037   0.835  1.00 14.93           N  
ATOM   1129  CA  ILE B  24       7.760  15.028   1.843  1.00 16.48           C  
ATOM   1130  C   ILE B  24       6.625  16.016   2.066  1.00 21.80           C  
ATOM   1131  O   ILE B  24       6.332  16.428   3.196  1.00 16.87           O  
ATOM   1132  CB  ILE B  24       9.091  15.692   1.447  1.00 14.79           C  
ATOM   1133  CG1 ILE B  24      10.278  14.738   1.589  1.00 16.49           C  
ATOM   1134  CG2 ILE B  24       9.371  16.977   2.230  1.00 18.44           C  
ATOM   1135  CD1 ILE B  24      11.605  15.264   1.079  1.00 19.31           C  
ATOM   1136  N   SER B  25       5.957  16.412   0.975  1.00 18.15           N  
ATOM   1137  CA  SER B  25       4.848  17.345   1.157  1.00 16.77           C  
ATOM   1138  C   SER B  25       3.753  16.736   2.023  1.00 15.39           C  
ATOM   1139  O   SER B  25       3.218  17.382   2.933  1.00 24.27           O  
ATOM   1140  CB  SER B  25       4.219  17.762  -0.194  1.00 21.24           C  
ATOM   1141  OG  SER B  25       5.166  18.559  -0.888  1.00 35.84           O  
ATOM   1142  N   GLY B  26       3.407  15.478   1.751  1.00 16.18           N  
ATOM   1143  CA  GLY B  26       2.354  14.854   2.528  1.00 22.80           C  
ATOM   1144  C   GLY B  26       2.721  14.696   3.993  1.00 24.80           C  
ATOM   1145  O   GLY B  26       1.905  14.940   4.887  1.00 22.56           O  
ATOM   1146  N   PHE B  27       3.959  14.257   4.234  1.00 19.27           N  
ATOM   1147  CA  PHE B  27       4.389  14.091   5.626  1.00 23.97           C  
ATOM   1148  C   PHE B  27       4.347  15.431   6.351  1.00 18.07           C  
ATOM   1149  O   PHE B  27       3.937  15.500   7.516  1.00 23.46           O  
ATOM   1150  CB  PHE B  27       5.793  13.478   5.711  1.00 15.20           C  
ATOM   1151  CG  PHE B  27       5.885  12.003   5.339  1.00 17.75           C  
ATOM   1152  CD1 PHE B  27       4.781  11.259   4.952  1.00 13.45           C  
ATOM   1153  CD2 PHE B  27       7.130  11.368   5.370  1.00 15.74           C  
ATOM   1154  CE1 PHE B  27       4.923   9.930   4.601  1.00 17.91           C  
ATOM   1155  CE2 PHE B  27       7.284  10.039   5.014  1.00 16.87           C  
ATOM   1156  CZ  PHE B  27       6.173   9.314   4.622  1.00 16.95           C  
ATOM   1157  N   ASP B  28       4.783  16.481   5.685  1.00 16.23           N  
ATOM   1158  CA  ASP B  28       4.828  17.832   6.180  1.00 19.98           C  
ATOM   1159  C   ASP B  28       3.418  18.322   6.513  1.00 27.50           C  
ATOM   1160  O   ASP B  28       3.211  19.037   7.498  1.00 24.27           O  
ATOM   1161  CB  ASP B  28       5.485  18.758   5.160  1.00 23.77           C  
ATOM   1162  CG  ASP B  28       6.997  18.711   5.198  1.00 28.37           C  
ATOM   1163  OD1 ASP B  28       7.566  17.951   6.014  1.00 20.33           O  
ATOM   1164  OD2 ASP B  28       7.649  19.441   4.409  1.00 25.53           O  
ATOM   1165  N   ARG B  29       2.456  17.923   5.682  1.00 27.66           N  
ATOM   1166  CA  ARG B  29       1.073  18.308   5.996  1.00 29.08           C  
ATOM   1167  C   ARG B  29       0.600  17.558   7.227  1.00 21.48           C  
ATOM   1168  O   ARG B  29      -0.079  18.099   8.096  1.00 24.48           O  
ATOM   1169  CB  ARG B  29       0.133  18.058   4.809  1.00 22.68           C  
ATOM   1170  CG  ARG B  29       0.125  19.255   3.870  1.00 41.70           C  
ATOM   1171  CD  ARG B  29      -0.733  19.040   2.636  1.00 53.77           C  
ATOM   1172  NE  ARG B  29      -2.014  18.426   2.979  1.00 68.22           N  
ATOM   1173  CZ  ARG B  29      -2.874  17.979   2.071  1.00 78.33           C  
ATOM   1174  NH1 ARG B  29      -2.592  18.079   0.777  1.00 70.16           N  
ATOM   1175  NH2 ARG B  29      -4.015  17.435   2.472  1.00 96.23           N  
ATOM   1176  N   GLN B  30       0.934  16.273   7.318  1.00 25.85           N  
ATOM   1177  CA  GLN B  30       0.521  15.566   8.519  1.00 23.47           C  
ATOM   1178  C   GLN B  30       1.103  16.201   9.790  1.00 27.65           C  
ATOM   1179  O   GLN B  30       0.390  16.345  10.791  1.00 27.50           O  
ATOM   1180  CB  GLN B  30       0.943  14.102   8.462  1.00 24.92           C  
ATOM   1181  CG  GLN B  30       0.400  13.317   7.284  1.00 25.93           C  
ATOM   1182  CD  GLN B  30       0.708  11.860   7.508  1.00 23.70           C  
ATOM   1183  OE1 GLN B  30       0.576  11.445   8.670  1.00 32.02           O  
ATOM   1184  NE2 GLN B  30       1.121  11.119   6.499  1.00 21.28           N  
ATOM   1185  N   LEU B  31       2.384  16.552   9.761  1.00 26.00           N  
ATOM   1186  CA  LEU B  31       3.057  17.183  10.898  1.00 28.04           C  
ATOM   1187  C   LEU B  31       2.402  18.527  11.208  1.00 34.64           C  
ATOM   1188  O   LEU B  31       2.115  18.849  12.355  1.00 24.36           O  
ATOM   1189  CB  LEU B  31       4.559  17.388  10.655  1.00 21.10           C  
ATOM   1190  CG  LEU B  31       5.345  18.199  11.686  1.00 29.75           C  
ATOM   1191  CD1 LEU B  31       5.207  17.583  13.078  1.00 22.54           C  
ATOM   1192  CD2 LEU B  31       6.814  18.331  11.300  1.00 22.90           C  
ATOM   1193  N   THR B  32       2.168  19.331  10.175  1.00 31.62           N  
ATOM   1194  CA  THR B  32       1.525  20.639  10.370  1.00 31.87           C  
ATOM   1195  C   THR B  32       0.187  20.471  11.062  1.00 31.05           C  
ATOM   1196  O   THR B  32      -0.205  21.247  11.940  1.00 32.10           O  
ATOM   1197  CB  THR B  32       1.373  21.358   9.016  1.00 43.43           C  
ATOM   1198  OG1 THR B  32       2.687  21.731   8.551  1.00 33.95           O  
ATOM   1199  CG2 THR B  32       0.561  22.643   9.122  1.00 39.83           C  
ATOM   1200  N   ALA B  33      -0.548  19.418  10.701  1.00 30.73           N  
ATOM   1201  CA  ALA B  33      -1.816  19.147  11.376  1.00 39.04           C  
ATOM   1202  C   ALA B  33      -1.635  18.730  12.831  1.00 42.45           C  
ATOM   1203  O   ALA B  33      -2.237  19.220  13.784  1.00 33.18           O  
ATOM   1204  CB  ALA B  33      -2.569  18.024  10.669  1.00 29.09           C  
ATOM   1205  N   TRP B  34      -0.790  17.719  13.009  1.00 34.22           N  
ATOM   1206  CA  TRP B  34      -0.537  17.191  14.341  1.00 28.17           C  
ATOM   1207  C   TRP B  34      -0.060  18.297  15.271  1.00 31.07           C  
ATOM   1208  O   TRP B  34      -0.344  18.253  16.471  1.00 27.81           O  
ATOM   1209  CB  TRP B  34       0.515  16.103  14.220  1.00 30.20           C  
ATOM   1210  CG  TRP B  34       0.962  15.438  15.477  1.00 27.30           C  
ATOM   1211  CD1 TRP B  34       0.438  14.282  15.992  1.00 25.57           C  
ATOM   1212  CD2 TRP B  34       2.002  15.855  16.376  1.00 23.78           C  
ATOM   1213  NE1 TRP B  34       1.099  13.965  17.153  1.00 22.32           N  
ATOM   1214  CE2 TRP B  34       2.057  14.909  17.410  1.00 25.68           C  
ATOM   1215  CE3 TRP B  34       2.888  16.940  16.395  1.00 24.93           C  
ATOM   1216  CZ2 TRP B  34       2.965  14.995  18.477  1.00 21.43           C  
ATOM   1217  CZ3 TRP B  34       3.786  17.031  17.441  1.00 32.26           C  
ATOM   1218  CH2 TRP B  34       3.813  16.070  18.460  1.00 24.44           C  
ATOM   1219  N   LEU B  35       0.646  19.283  14.705  1.00 23.32           N  
ATOM   1220  CA  LEU B  35       1.236  20.303  15.575  1.00 24.96           C  
ATOM   1221  C   LEU B  35       0.173  21.169  16.226  1.00 31.05           C  
ATOM   1222  O   LEU B  35       0.369  21.713  17.317  1.00 36.42           O  
ATOM   1223  CB  LEU B  35       2.229  21.178  14.797  1.00 23.36           C  
ATOM   1224  CG  LEU B  35       3.672  20.643  14.759  1.00 33.70           C  
ATOM   1225  CD1 LEU B  35       4.569  21.524  13.887  1.00 26.59           C  
ATOM   1226  CD2 LEU B  35       4.274  20.517  16.149  1.00 36.31           C  
ATOM   1227  N   ARG B  36      -0.961  21.331  15.541  1.00 40.49           N  
ATOM   1228  CA  ARG B  36      -2.021  22.182  16.070  1.00 42.68           C  
ATOM   1229  C   ARG B  36      -2.522  21.651  17.412  1.00 35.33           C  
ATOM   1230  O   ARG B  36      -2.887  22.404  18.308  1.00 33.87           O  
ATOM   1231  CB  ARG B  36      -3.204  22.274  15.101  1.00 62.32           C  
ATOM   1232  CG  ARG B  36      -2.830  22.526  13.656  1.00 77.64           C  
ATOM   1233  CD  ARG B  36      -3.199  23.926  13.193  1.00 91.84           C  
ATOM   1234  NE  ARG B  36      -3.017  24.043  11.746  1.00104.38           N  
ATOM   1235  CZ  ARG B  36      -1.983  24.625  11.153  1.00106.28           C  
ATOM   1236  NH1 ARG B  36      -1.006  25.164  11.863  1.00 88.39           N  
ATOM   1237  NH2 ARG B  36      -1.917  24.674   9.826  1.00117.17           N  
ATOM   1238  N   VAL B  37      -2.526  20.330  17.501  1.00 26.10           N  
ATOM   1239  CA  VAL B  37      -2.960  19.646  18.699  1.00 29.71           C  
ATOM   1240  C   VAL B  37      -1.839  19.514  19.730  1.00 44.34           C  
ATOM   1241  O   VAL B  37      -2.036  19.771  20.926  1.00 30.69           O  
ATOM   1242  CB  VAL B  37      -3.464  18.224  18.363  1.00 30.67           C  
ATOM   1243  CG1 VAL B  37      -4.035  17.588  19.626  1.00 32.98           C  
ATOM   1244  CG2 VAL B  37      -4.471  18.256  17.228  1.00 33.59           C  
ATOM   1245  N   HIS B  38      -0.672  19.092  19.228  1.00 28.78           N  
ATOM   1246  CA  HIS B  38       0.388  18.635  20.114  1.00 31.69           C  
ATOM   1247  C   HIS B  38       1.600  19.544  20.158  1.00 31.16           C  
ATOM   1248  O   HIS B  38       2.602  19.190  20.796  1.00 40.27           O  
ATOM   1249  CB  HIS B  38       0.843  17.226  19.666  1.00 34.12           C  
ATOM   1250  CG  HIS B  38      -0.270  16.239  19.813  1.00 30.06           C  
ATOM   1251  ND1 HIS B  38      -1.083  15.872  18.773  1.00 34.51           N  
ATOM   1252  CD2 HIS B  38      -0.704  15.560  20.900  1.00 24.96           C  
ATOM   1253  CE1 HIS B  38      -1.977  14.993  19.199  1.00 36.86           C  
ATOM   1254  NE2 HIS B  38      -1.772  14.788  20.490  1.00 38.49           N  
ATOM   1255  N   GLY B  39       1.554  20.707  19.519  1.00 34.09           N  
ATOM   1256  CA  GLY B  39       2.795  21.457  19.375  1.00 36.61           C  
ATOM   1257  C   GLY B  39       2.911  22.714  20.193  1.00 42.06           C  
ATOM   1258  O   GLY B  39       3.926  23.427  20.088  1.00 37.06           O  
ATOM   1259  N   ARG B  40       1.890  22.989  20.997  1.00 44.17           N  
ATOM   1260  CA  ARG B  40       1.851  24.184  21.833  1.00 51.58           C  
ATOM   1261  C   ARG B  40       3.101  24.352  22.687  1.00 46.48           C  
ATOM   1262  O   ARG B  40       3.625  25.464  22.814  1.00 58.12           O  
ATOM   1263  CB  ARG B  40       0.604  24.154  22.726  1.00 64.75           C  
ATOM   1264  CG  ARG B  40       0.895  24.286  24.215  1.00 76.81           C  
ATOM   1265  CD  ARG B  40       0.717  25.719  24.690  1.00 82.64           C  
ATOM   1266  NE  ARG B  40       1.158  25.930  26.069  1.00 87.42           N  
ATOM   1267  CZ  ARG B  40       1.553  27.114  26.524  1.00 92.12           C  
ATOM   1268  NH1 ARG B  40       1.564  28.160  25.703  1.00108.32           N  
ATOM   1269  NH2 ARG B  40       1.947  27.281  27.778  1.00 84.51           N  
ATOM   1270  N   ARG B  41       3.632  23.289  23.293  1.00 48.25           N  
ATOM   1271  CA  ARG B  41       4.802  23.489  24.153  1.00 50.40           C  
ATOM   1272  C   ARG B  41       6.099  22.978  23.552  1.00 50.05           C  
ATOM   1273  O   ARG B  41       7.047  22.630  24.267  1.00 44.44           O  
ATOM   1274  CB  ARG B  41       4.541  22.825  25.511  1.00 63.18           C  
ATOM   1275  CG  ARG B  41       3.434  23.502  26.312  1.00 73.90           C  
ATOM   1276  CD  ARG B  41       3.867  23.793  27.736  1.00 80.49           C  
ATOM   1277  NE  ARG B  41       2.921  24.605  28.480  1.00 88.04           N  
ATOM   1278  CZ  ARG B  41       1.616  24.422  28.616  1.00 94.33           C  
ATOM   1279  NH1 ARG B  41       0.989  23.406  28.042  1.00103.12           N  
ATOM   1280  NH2 ARG B  41       0.907  25.281  29.344  1.00 88.61           N  
ATOM   1281  N   LEU B  42       6.218  22.923  22.225  1.00 44.70           N  
ATOM   1282  CA  LEU B  42       7.518  22.514  21.665  1.00 33.91           C  
ATOM   1283  C   LEU B  42       8.326  23.759  21.355  1.00 28.94           C  
ATOM   1284  O   LEU B  42       7.728  24.818  21.146  1.00 42.95           O  
ATOM   1285  CB  LEU B  42       7.325  21.623  20.431  1.00 28.15           C  
ATOM   1286  CG  LEU B  42       6.506  20.349  20.676  1.00 31.18           C  
ATOM   1287  CD1 LEU B  42       6.400  19.536  19.397  1.00 42.08           C  
ATOM   1288  CD2 LEU B  42       7.091  19.501  21.797  1.00 28.47           C  
ATOM   1289  N   THR B  43       9.654  23.710  21.319  1.00 26.92           N  
ATOM   1290  CA  THR B  43      10.429  24.845  20.856  1.00 30.17           C  
ATOM   1291  C   THR B  43      10.435  24.835  19.319  1.00 36.04           C  
ATOM   1292  O   THR B  43      10.064  23.833  18.717  1.00 37.97           O  
ATOM   1293  CB  THR B  43      11.919  24.863  21.230  1.00 33.93           C  
ATOM   1294  OG1 THR B  43      12.522  23.662  20.707  1.00 30.30           O  
ATOM   1295  CG2 THR B  43      12.108  24.865  22.735  1.00 50.57           C  
ATOM   1296  N   ASN B  44      10.891  25.954  18.793  1.00 32.45           N  
ATOM   1297  CA  ASN B  44      11.036  26.056  17.346  1.00 44.96           C  
ATOM   1298  C   ASN B  44      12.034  24.978  16.919  1.00 38.88           C  
ATOM   1299  O   ASN B  44      11.875  24.387  15.860  1.00 32.75           O  
ATOM   1300  CB  ASN B  44      11.513  27.428  16.897  1.00 55.16           C  
ATOM   1301  CG  ASN B  44      10.544  28.572  17.111  1.00 63.26           C  
ATOM   1302  OD1 ASN B  44       9.378  28.393  17.474  1.00 61.82           O  
ATOM   1303  ND2 ASN B  44      11.046  29.788  16.878  1.00 46.82           N  
ATOM   1304  N   ASN B  45      13.039  24.753  17.761  1.00 36.88           N  
ATOM   1305  CA  ASN B  45      14.023  23.710  17.494  1.00 34.06           C  
ATOM   1306  C   ASN B  45      13.363  22.345  17.380  1.00 25.20           C  
ATOM   1307  O   ASN B  45      13.647  21.579  16.449  1.00 25.28           O  
ATOM   1308  CB  ASN B  45      15.099  23.694  18.592  1.00 38.42           C  
ATOM   1309  CG  ASN B  45      16.176  24.707  18.257  1.00 39.81           C  
ATOM   1310  OD1 ASN B  45      16.093  25.331  17.194  1.00 48.69           O  
ATOM   1311  ND2 ASN B  45      17.163  24.886  19.118  1.00 40.36           N  
ATOM   1312  N   GLN B  46      12.497  22.033  18.335  1.00 22.38           N  
ATOM   1313  CA  GLN B  46      11.843  20.724  18.357  1.00 24.67           C  
ATOM   1314  C   GLN B  46      10.919  20.532  17.168  1.00 26.17           C  
ATOM   1315  O   GLN B  46      10.839  19.474  16.553  1.00 21.68           O  
ATOM   1316  CB  GLN B  46      11.096  20.602  19.680  1.00 32.01           C  
ATOM   1317  CG  GLN B  46      12.068  20.340  20.841  1.00 24.26           C  
ATOM   1318  CD  GLN B  46      11.254  20.311  22.133  1.00 30.57           C  
ATOM   1319  OE1 GLN B  46      10.302  21.087  22.227  1.00 30.99           O  
ATOM   1320  NE2 GLN B  46      11.635  19.437  23.051  1.00 39.41           N  
ATOM   1321  N   LYS B  47      10.185  21.577  16.796  1.00 26.40           N  
ATOM   1322  CA  LYS B  47       9.416  21.508  15.555  1.00 26.09           C  
ATOM   1323  C   LYS B  47      10.294  21.293  14.327  1.00 22.06           C  
ATOM   1324  O   LYS B  47       9.993  20.459  13.476  1.00 23.72           O  
ATOM   1325  CB  LYS B  47       8.600  22.803  15.398  1.00 27.46           C  
ATOM   1326  CG  LYS B  47       7.642  22.989  16.568  1.00 31.00           C  
ATOM   1327  CD  LYS B  47       7.084  24.401  16.637  1.00 43.34           C  
ATOM   1328  CE  LYS B  47       5.946  24.477  17.647  1.00 43.30           C  
ATOM   1329  NZ  LYS B  47       5.301  25.827  17.638  1.00 42.73           N  
ATOM   1330  N   LYS B  48      11.378  22.049  14.187  1.00 17.87           N  
ATOM   1331  CA  LYS B  48      12.293  21.847  13.080  1.00 23.76           C  
ATOM   1332  C   LYS B  48      12.878  20.440  13.075  1.00 28.53           C  
ATOM   1333  O   LYS B  48      13.094  19.908  11.988  1.00 19.79           O  
ATOM   1334  CB  LYS B  48      13.428  22.856  13.122  1.00 23.17           C  
ATOM   1335  CG  LYS B  48      12.997  24.287  12.776  1.00 29.35           C  
ATOM   1336  CD  LYS B  48      14.192  25.200  13.066  1.00 24.64           C  
ATOM   1337  CE  LYS B  48      13.768  26.660  13.118  1.00 42.40           C  
ATOM   1338  NZ  LYS B  48      14.962  27.527  13.372  1.00 50.37           N  
ATOM   1339  N   THR B  49      13.135  19.844  14.243  1.00 22.85           N  
ATOM   1340  CA  THR B  49      13.560  18.446  14.253  1.00 18.16           C  
ATOM   1341  C   THR B  49      12.496  17.521  13.690  1.00 16.56           C  
ATOM   1342  O   THR B  49      12.823  16.581  12.951  1.00 18.85           O  
ATOM   1343  CB  THR B  49      13.920  18.021  15.703  1.00 18.08           C  
ATOM   1344  OG1 THR B  49      15.049  18.821  16.076  1.00 21.10           O  
ATOM   1345  CG2 THR B  49      14.292  16.559  15.767  1.00 18.11           C  
ATOM   1346  N   LEU B  50      11.212  17.754  13.992  1.00 14.75           N  
ATOM   1347  CA  LEU B  50      10.200  16.839  13.439  1.00 20.77           C  
ATOM   1348  C   LEU B  50      10.044  17.014  11.920  1.00 17.02           C  
ATOM   1349  O   LEU B  50       9.816  16.001  11.256  1.00 16.08           O  
ATOM   1350  CB  LEU B  50       8.861  16.993  14.163  1.00 21.56           C  
ATOM   1351  CG  LEU B  50       8.851  16.487  15.616  1.00 22.24           C  
ATOM   1352  CD1 LEU B  50       7.537  16.856  16.307  1.00 23.44           C  
ATOM   1353  CD2 LEU B  50       9.095  14.989  15.688  1.00 21.00           C  
ATOM   1354  N   PHE B  51      10.202  18.213  11.384  1.00 17.87           N  
ATOM   1355  CA  PHE B  51      10.280  18.373   9.927  1.00 18.15           C  
ATOM   1356  C   PHE B  51      11.469  17.627   9.322  1.00 21.14           C  
ATOM   1357  O   PHE B  51      11.352  17.014   8.257  1.00 17.37           O  
ATOM   1358  CB  PHE B  51      10.356  19.856   9.510  1.00 18.17           C  
ATOM   1359  CG  PHE B  51       8.958  20.475   9.570  1.00 24.53           C  
ATOM   1360  CD1 PHE B  51       8.015  20.156   8.606  1.00 19.45           C  
ATOM   1361  CD2 PHE B  51       8.602  21.330  10.599  1.00 27.38           C  
ATOM   1362  CE1 PHE B  51       6.727  20.663   8.675  1.00 24.02           C  
ATOM   1363  CE2 PHE B  51       7.310  21.844  10.662  1.00 30.84           C  
ATOM   1364  CZ  PHE B  51       6.369  21.511   9.708  1.00 26.07           C  
ATOM   1365  N   PHE B  52      12.634  17.656   9.961  1.00 16.64           N  
ATOM   1366  CA  PHE B  52      13.762  16.815   9.555  1.00 11.95           C  
ATOM   1367  C   PHE B  52      13.356  15.346   9.613  1.00 17.91           C  
ATOM   1368  O   PHE B  52      13.694  14.535   8.745  1.00 17.54           O  
ATOM   1369  CB  PHE B  52      14.972  17.104  10.479  1.00 17.05           C  
ATOM   1370  CG  PHE B  52      15.915  15.911  10.622  1.00 17.59           C  
ATOM   1371  CD1 PHE B  52      16.865  15.677   9.653  1.00 18.27           C  
ATOM   1372  CD2 PHE B  52      15.845  15.050  11.714  1.00 18.57           C  
ATOM   1373  CE1 PHE B  52      17.718  14.586   9.712  1.00 22.87           C  
ATOM   1374  CE2 PHE B  52      16.666  13.933  11.758  1.00 25.66           C  
ATOM   1375  CZ  PHE B  52      17.588  13.684  10.757  1.00 17.99           C  
ATOM   1376  N   VAL B  53      12.652  14.957  10.690  1.00 15.41           N  
ATOM   1377  CA  VAL B  53      12.244  13.555  10.850  1.00 16.26           C  
ATOM   1378  C   VAL B  53      11.435  13.084   9.645  1.00 12.86           C  
ATOM   1379  O   VAL B  53      11.509  11.949   9.193  1.00 14.84           O  
ATOM   1380  CB  VAL B  53      11.447  13.364  12.159  1.00 16.97           C  
ATOM   1381  CG1 VAL B  53      10.595  12.099  12.139  1.00 17.19           C  
ATOM   1382  CG2 VAL B  53      12.378  13.264  13.374  1.00 18.17           C  
ATOM   1383  N   ASN B  54      10.591  13.965   9.092  1.00 16.64           N  
ATOM   1384  CA  ASN B  54       9.791  13.579   7.920  1.00 14.71           C  
ATOM   1385  C   ASN B  54      10.674  13.175   6.748  1.00 12.39           C  
ATOM   1386  O   ASN B  54      10.455  12.216   6.004  1.00 12.98           O  
ATOM   1387  CB  ASN B  54       8.905  14.772   7.526  1.00 18.16           C  
ATOM   1388  CG  ASN B  54       7.673  14.971   8.404  1.00 19.45           C  
ATOM   1389  OD1 ASN B  54       7.362  14.032   9.139  1.00 19.32           O  
ATOM   1390  ND2 ASN B  54       7.003  16.128   8.278  1.00 18.93           N  
ATOM   1391  N   ARG B  55      11.751  13.956   6.545  1.00 13.75           N  
ATOM   1392  CA  ARG B  55      12.650  13.642   5.427  1.00 12.95           C  
ATOM   1393  C   ARG B  55      13.415  12.350   5.651  1.00 15.41           C  
ATOM   1394  O   ARG B  55      13.570  11.473   4.798  1.00 13.84           O  
ATOM   1395  CB  ARG B  55      13.615  14.834   5.238  1.00 15.90           C  
ATOM   1396  CG  ARG B  55      12.826  16.028   4.693  1.00 15.78           C  
ATOM   1397  CD  ARG B  55      13.609  17.330   4.768  1.00 18.41           C  
ATOM   1398  NE  ARG B  55      12.763  18.396   4.188  1.00 21.51           N  
ATOM   1399  CZ  ARG B  55      13.178  19.144   3.162  1.00 27.73           C  
ATOM   1400  NH1 ARG B  55      14.387  18.973   2.630  1.00 21.14           N  
ATOM   1401  NH2 ARG B  55      12.363  20.078   2.679  1.00 25.91           N  
ATOM   1402  N   ARG B  56      13.899  12.233   6.887  1.00 13.55           N  
ATOM   1403  CA  ARG B  56      14.598  11.030   7.307  1.00 13.23           C  
ATOM   1404  C   ARG B  56      13.716   9.803   7.204  1.00 15.51           C  
ATOM   1405  O   ARG B  56      14.172   8.745   6.739  1.00 13.94           O  
ATOM   1406  CB  ARG B  56      15.065  11.295   8.752  1.00 20.11           C  
ATOM   1407  CG  ARG B  56      15.823  10.134   9.366  1.00 24.42           C  
ATOM   1408  CD  ARG B  56      17.195   9.967   8.708  1.00 21.89           C  
ATOM   1409  NE  ARG B  56      17.816   8.801   9.355  1.00 23.75           N  
ATOM   1410  CZ  ARG B  56      18.898   8.204   8.890  1.00 31.47           C  
ATOM   1411  NH1 ARG B  56      19.481   8.647   7.791  1.00 35.70           N  
ATOM   1412  NH2 ARG B  56      19.369   7.157   9.557  1.00 37.00           N  
ATOM   1413  N   TYR B  57      12.449   9.944   7.622  1.00 14.44           N  
ATOM   1414  CA  TYR B  57      11.491   8.831   7.507  1.00 17.77           C  
ATOM   1415  C   TYR B  57      11.368   8.361   6.058  1.00 16.82           C  
ATOM   1416  O   TYR B  57      11.416   7.174   5.717  1.00 13.47           O  
ATOM   1417  CB  TYR B  57      10.145   9.263   8.088  1.00 15.43           C  
ATOM   1418  CG  TYR B  57       9.323   8.100   8.628  1.00 16.20           C  
ATOM   1419  CD1 TYR B  57       8.533   7.351   7.772  1.00 17.02           C  
ATOM   1420  CD2 TYR B  57       9.333   7.758   9.971  1.00 18.59           C  
ATOM   1421  CE1 TYR B  57       7.782   6.291   8.264  1.00 27.12           C  
ATOM   1422  CE2 TYR B  57       8.581   6.703  10.474  1.00 22.83           C  
ATOM   1423  CZ  TYR B  57       7.806   5.970   9.602  1.00 27.74           C  
ATOM   1424  OH  TYR B  57       7.054   4.910  10.062  1.00 26.97           O  
ATOM   1425  N   MET B  58      11.240   9.320   5.132  1.00 15.23           N  
ATOM   1426  CA  MET B  58      11.184   8.916   3.731  1.00 12.63           C  
ATOM   1427  C   MET B  58      12.435   8.188   3.282  1.00 13.42           C  
ATOM   1428  O   MET B  58      12.370   7.153   2.612  1.00 16.62           O  
ATOM   1429  CB  MET B  58      10.964  10.174   2.849  1.00 15.14           C  
ATOM   1430  CG  MET B  58      10.907   9.768   1.372  1.00 18.62           C  
ATOM   1431  SD  MET B  58      10.905  11.241   0.299  1.00 17.82           S  
ATOM   1432  CE  MET B  58      12.697  11.570   0.412  1.00 15.14           C  
ATOM   1433  N   GLN B  59      13.599   8.734   3.651  1.00 12.86           N  
ATOM   1434  CA  GLN B  59      14.845   8.076   3.263  1.00 13.66           C  
ATOM   1435  C   GLN B  59      14.892   6.643   3.777  1.00 13.80           C  
ATOM   1436  O   GLN B  59      15.238   5.729   3.030  1.00 15.60           O  
ATOM   1437  CB  GLN B  59      16.069   8.823   3.816  1.00 13.53           C  
ATOM   1438  CG  GLN B  59      16.265  10.187   3.135  1.00 17.46           C  
ATOM   1439  CD  GLN B  59      17.394  10.981   3.753  1.00 20.07           C  
ATOM   1440  OE1 GLN B  59      17.440  11.184   4.976  1.00 20.86           O  
ATOM   1441  NE2 GLN B  59      18.322  11.440   2.931  1.00 16.86           N  
ATOM   1442  N   THR B  60      14.594   6.438   5.052  1.00 14.81           N  
ATOM   1443  CA  THR B  60      14.834   5.064   5.546  1.00 18.49           C  
ATOM   1444  C   THR B  60      13.752   4.098   5.079  1.00 21.46           C  
ATOM   1445  O   THR B  60      13.942   2.879   5.196  1.00 18.40           O  
ATOM   1446  CB  THR B  60      14.935   4.986   7.084  1.00 18.88           C  
ATOM   1447  OG1 THR B  60      13.713   5.448   7.666  1.00 14.76           O  
ATOM   1448  CG2 THR B  60      16.034   5.906   7.613  1.00 15.64           C  
ATOM   1449  N   HIS B  61      12.639   4.600   4.567  1.00 16.01           N  
ATOM   1450  CA  HIS B  61      11.594   3.715   4.047  1.00 17.21           C  
ATOM   1451  C   HIS B  61      11.598   3.654   2.529  1.00 25.21           C  
ATOM   1452  O   HIS B  61      10.680   3.076   1.932  1.00 20.86           O  
ATOM   1453  CB  HIS B  61      10.199   4.158   4.532  1.00 16.41           C  
ATOM   1454  CG  HIS B  61      10.110   3.941   6.018  1.00 23.09           C  
ATOM   1455  ND1 HIS B  61      10.678   4.821   6.910  1.00 17.40           N  
ATOM   1456  CD2 HIS B  61       9.564   2.935   6.744  1.00 24.11           C  
ATOM   1457  CE1 HIS B  61      10.469   4.387   8.148  1.00 21.02           C  
ATOM   1458  NE2 HIS B  61       9.793   3.250   8.065  1.00 25.82           N  
ATOM   1459  N   TRP B  62      12.628   4.222   1.900  1.00 22.59           N  
ATOM   1460  CA  TRP B  62      12.591   4.275   0.445  1.00 21.52           C  
ATOM   1461  C   TRP B  62      12.475   2.899  -0.204  1.00 21.40           C  
ATOM   1462  O   TRP B  62      11.673   2.742  -1.124  1.00 20.19           O  
ATOM   1463  CB  TRP B  62      13.826   5.005  -0.117  1.00 18.45           C  
ATOM   1464  CG  TRP B  62      13.660   5.272  -1.593  1.00 17.78           C  
ATOM   1465  CD1 TRP B  62      14.314   4.629  -2.605  1.00 18.19           C  
ATOM   1466  CD2 TRP B  62      12.806   6.243  -2.202  1.00 14.46           C  
ATOM   1467  NE1 TRP B  62      13.908   5.140  -3.812  1.00 21.22           N  
ATOM   1468  CE2 TRP B  62      12.988   6.128  -3.592  1.00 19.75           C  
ATOM   1469  CE3 TRP B  62      11.906   7.193  -1.740  1.00 16.06           C  
ATOM   1470  CZ2 TRP B  62      12.293   6.941  -4.490  1.00 27.85           C  
ATOM   1471  CZ3 TRP B  62      11.213   7.999  -2.626  1.00 19.77           C  
ATOM   1472  CH2 TRP B  62      11.409   7.869  -4.003  1.00 25.72           C  
ATOM   1473  N   GLN B  63      13.225   1.895   0.238  1.00 23.56           N  
ATOM   1474  CA  GLN B  63      13.166   0.604  -0.438  1.00 32.51           C  
ATOM   1475  C   GLN B  63      11.788  -0.016  -0.255  1.00 24.15           C  
ATOM   1476  O   GLN B  63      11.295  -0.630  -1.189  1.00 26.69           O  
ATOM   1477  CB  GLN B  63      14.199  -0.401   0.078  1.00 40.49           C  
ATOM   1478  CG  GLN B  63      13.780  -1.832  -0.242  1.00 52.55           C  
ATOM   1479  CD  GLN B  63      13.954  -2.829   0.884  1.00 59.32           C  
ATOM   1480  OE1 GLN B  63      15.059  -3.313   1.137  1.00 67.64           O  
ATOM   1481  NE2 GLN B  63      12.875  -3.177   1.579  1.00 45.17           N  
ATOM   1482  N   ASN B  64      11.218   0.168   0.937  1.00 20.10           N  
ATOM   1483  CA  ASN B  64       9.857  -0.307   1.146  1.00 27.06           C  
ATOM   1484  C   ASN B  64       8.876   0.387   0.202  1.00 32.71           C  
ATOM   1485  O   ASN B  64       7.984  -0.275  -0.333  1.00 24.09           O  
ATOM   1486  CB  ASN B  64       9.382  -0.081   2.577  1.00 25.21           C  
ATOM   1487  CG  ASN B  64      10.047  -1.026   3.562  1.00 35.47           C  
ATOM   1488  OD1 ASN B  64       9.607  -1.145   4.703  1.00 53.89           O  
ATOM   1489  ND2 ASN B  64      11.104  -1.706   3.132  1.00 48.58           N  
ATOM   1490  N   TYR B  65       9.009   1.703   0.010  1.00 18.58           N  
ATOM   1491  CA  TYR B  65       8.021   2.359  -0.851  1.00 20.27           C  
ATOM   1492  C   TYR B  65       8.170   1.900  -2.299  1.00 25.71           C  
ATOM   1493  O   TYR B  65       7.184   1.800  -3.037  1.00 26.60           O  
ATOM   1494  CB  TYR B  65       8.129   3.889  -0.771  1.00 18.55           C  
ATOM   1495  CG  TYR B  65       7.875   4.430   0.625  1.00 21.68           C  
ATOM   1496  CD1 TYR B  65       7.010   3.795   1.513  1.00 21.91           C  
ATOM   1497  CD2 TYR B  65       8.519   5.586   1.062  1.00 18.58           C  
ATOM   1498  CE1 TYR B  65       6.769   4.278   2.783  1.00 21.37           C  
ATOM   1499  CE2 TYR B  65       8.294   6.088   2.332  1.00 20.20           C  
ATOM   1500  CZ  TYR B  65       7.421   5.430   3.184  1.00 23.26           C  
ATOM   1501  OH  TYR B  65       7.215   5.938   4.445  1.00 23.53           O  
ATOM   1502  N   MET B  66       9.403   1.638  -2.713  1.00 26.40           N  
ATOM   1503  CA  MET B  66       9.684   1.246  -4.097  1.00 26.74           C  
ATOM   1504  C   MET B  66       9.077  -0.130  -4.386  1.00 38.88           C  
ATOM   1505  O   MET B  66       8.561  -0.376  -5.483  1.00 26.17           O  
ATOM   1506  CB  MET B  66      11.177   1.281  -4.375  1.00 23.76           C  
ATOM   1507  CG  MET B  66      11.818   2.650  -4.497  1.00 24.48           C  
ATOM   1508  SD  MET B  66      10.891   3.802  -5.546  1.00 26.01           S  
ATOM   1509  CE  MET B  66       9.808   4.562  -4.354  1.00 18.65           C  
ATOM   1510  N   LEU B  67       9.097  -1.055  -3.422  1.00 30.97           N  
ATOM   1511  CA  LEU B  67       8.413  -2.337  -3.644  1.00 35.19           C  
ATOM   1512  C   LEU B  67       6.900  -2.190  -3.663  1.00 32.81           C  
ATOM   1513  O   LEU B  67       6.146  -2.821  -4.411  1.00 28.70           O  
ATOM   1514  CB  LEU B  67       8.778  -3.352  -2.558  1.00 40.29           C  
ATOM   1515  CG  LEU B  67      10.266  -3.580  -2.299  1.00 55.69           C  
ATOM   1516  CD1 LEU B  67      10.465  -4.426  -1.044  1.00 71.24           C  
ATOM   1517  CD2 LEU B  67      10.933  -4.228  -3.501  1.00 70.78           C  
ATOM   1518  N   TRP B  68       6.394  -1.317  -2.786  1.00 23.18           N  
ATOM   1519  CA  TRP B  68       4.958  -1.067  -2.807  1.00 20.16           C  
ATOM   1520  C   TRP B  68       4.559  -0.454  -4.152  1.00 30.90           C  
ATOM   1521  O   TRP B  68       3.580  -0.797  -4.807  1.00 27.02           O  
ATOM   1522  CB  TRP B  68       4.558  -0.158  -1.659  1.00 21.28           C  
ATOM   1523  CG  TRP B  68       3.100   0.192  -1.631  1.00 30.02           C  
ATOM   1524  CD1 TRP B  68       2.095  -0.643  -1.213  1.00 35.00           C  
ATOM   1525  CD2 TRP B  68       2.460   1.414  -2.018  1.00 31.93           C  
ATOM   1526  NE1 TRP B  68       0.883  -0.010  -1.317  1.00 33.53           N  
ATOM   1527  CE2 TRP B  68       1.074   1.254  -1.809  1.00 32.63           C  
ATOM   1528  CE3 TRP B  68       2.904   2.644  -2.526  1.00 25.86           C  
ATOM   1529  CZ2 TRP B  68       0.140   2.250  -2.081  1.00 31.63           C  
ATOM   1530  CZ3 TRP B  68       1.978   3.628  -2.793  1.00 23.90           C  
ATOM   1531  CH2 TRP B  68       0.610   3.438  -2.575  1.00 28.70           C  
ATOM   1532  N   VAL B  69       5.362   0.514  -4.593  1.00 25.96           N  
ATOM   1533  CA  VAL B  69       5.046   1.187  -5.864  1.00 20.83           C  
ATOM   1534  C   VAL B  69       5.065   0.211  -7.021  1.00 21.58           C  
ATOM   1535  O   VAL B  69       4.180   0.219  -7.893  1.00 26.86           O  
ATOM   1536  CB  VAL B  69       6.072   2.333  -6.018  1.00 21.23           C  
ATOM   1537  CG1 VAL B  69       6.187   2.806  -7.451  1.00 30.12           C  
ATOM   1538  CG2 VAL B  69       5.665   3.474  -5.080  1.00 22.96           C  
ATOM   1539  N   LYS B  70       6.063  -0.667  -7.083  1.00 26.61           N  
ATOM   1540  CA  LYS B  70       6.173  -1.658  -8.149  1.00 33.30           C  
ATOM   1541  C   LYS B  70       4.922  -2.526  -8.231  1.00 41.29           C  
ATOM   1542  O   LYS B  70       4.391  -2.825  -9.309  1.00 32.11           O  
ATOM   1543  CB  LYS B  70       7.401  -2.538  -7.921  1.00 39.01           C  
ATOM   1544  CG  LYS B  70       8.671  -1.977  -8.543  1.00 59.13           C  
ATOM   1545  CD  LYS B  70       8.811  -0.488  -8.268  1.00 70.32           C  
ATOM   1546  CE  LYS B  70      10.278  -0.081  -8.188  1.00 73.98           C  
ATOM   1547  NZ  LYS B  70      11.181  -1.250  -8.365  1.00 77.71           N  
ATOM   1548  N   ARG B  71       4.438  -2.936  -7.054  1.00 29.20           N  
ATOM   1549  CA  ARG B  71       3.194  -3.704  -7.028  1.00 36.44           C  
ATOM   1550  C   ARG B  71       2.016  -2.865  -7.502  1.00 38.85           C  
ATOM   1551  O   ARG B  71       1.184  -3.321  -8.294  1.00 44.23           O  
ATOM   1552  CB  ARG B  71       2.920  -4.235  -5.621  1.00 38.10           C  
ATOM   1553  CG  ARG B  71       4.121  -4.932  -4.997  1.00 59.61           C  
ATOM   1554  CD  ARG B  71       4.850  -5.820  -5.988  1.00 72.62           C  
ATOM   1555  NE  ARG B  71       6.266  -5.475  -6.120  1.00 82.09           N  
ATOM   1556  CZ  ARG B  71       6.988  -5.756  -7.200  1.00 87.12           C  
ATOM   1557  NH1 ARG B  71       6.443  -6.380  -8.235  1.00 71.14           N  
ATOM   1558  NH2 ARG B  71       8.269  -5.414  -7.256  1.00101.06           N  
ATOM   1559  N   LYS B  72       1.915  -1.620  -7.021  1.00 24.65           N  
ATOM   1560  CA  LYS B  72       0.768  -0.819  -7.446  1.00 28.75           C  
ATOM   1561  C   LYS B  72       0.815  -0.629  -8.969  1.00 31.31           C  
ATOM   1562  O   LYS B  72      -0.231  -0.634  -9.614  1.00 29.59           O  
ATOM   1563  CB  LYS B  72       0.694   0.530  -6.738  1.00 40.43           C  
ATOM   1564  CG  LYS B  72       0.467   0.444  -5.234  1.00 44.04           C  
ATOM   1565  CD  LYS B  72      -0.947  -0.030  -4.937  1.00 42.36           C  
ATOM   1566  CE  LYS B  72      -1.936   1.126  -4.925  1.00 50.11           C  
ATOM   1567  NZ  LYS B  72      -3.285   0.651  -4.499  1.00 72.52           N  
ATOM   1568  N   ILE B  73       2.015  -0.471  -9.518  1.00 27.95           N  
ATOM   1569  CA  ILE B  73       2.147  -0.202 -10.954  1.00 28.09           C  
ATOM   1570  C   ILE B  73       1.832  -1.463 -11.741  1.00 37.23           C  
ATOM   1571  O   ILE B  73       1.220  -1.444 -12.808  1.00 38.46           O  
ATOM   1572  CB  ILE B  73       3.559   0.299 -11.294  1.00 30.52           C  
ATOM   1573  CG1 ILE B  73       3.897   1.691 -10.738  1.00 28.95           C  
ATOM   1574  CG2 ILE B  73       3.821   0.230 -12.797  1.00 25.74           C  
ATOM   1575  CD1 ILE B  73       2.965   2.794 -11.183  1.00 49.20           C  
ATOM   1576  N   LYS B  74       2.240  -2.619 -11.209  1.00 38.69           N  
ATOM   1577  CA  LYS B  74       1.893  -3.857 -11.908  1.00 42.58           C  
ATOM   1578  C   LYS B  74       0.374  -3.997 -12.038  1.00 39.74           C  
ATOM   1579  O   LYS B  74      -0.069  -4.543 -13.052  1.00 41.18           O  
ATOM   1580  CB  LYS B  74       2.475  -5.080 -11.206  1.00 49.12           C  
ATOM   1581  CG  LYS B  74       3.681  -5.666 -11.922  1.00 56.55           C  
ATOM   1582  CD  LYS B  74       3.582  -7.175 -12.040  1.00 60.73           C  
ATOM   1583  CE  LYS B  74       2.636  -7.769 -11.015  1.00 64.29           C  
ATOM   1584  NZ  LYS B  74       3.089  -9.123 -10.571  1.00 84.60           N  
ATOM   1585  N   ALA B  75      -0.352  -3.503 -11.053  1.00 38.18           N  
ATOM   1586  CA  ALA B  75      -1.799  -3.581 -10.929  1.00 39.05           C  
ATOM   1587  C   ALA B  75      -2.597  -2.481 -11.618  1.00 40.53           C  
ATOM   1588  O   ALA B  75      -3.838  -2.472 -11.555  1.00 35.24           O  
ATOM   1589  CB  ALA B  75      -2.152  -3.568  -9.435  1.00 39.50           C  
ATOM   1590  N   LEU B  76      -1.933  -1.535 -12.267  1.00 40.52           N  
ATOM   1591  CA  LEU B  76      -2.545  -0.339 -12.842  1.00 43.58           C  
ATOM   1592  C   LEU B  76      -3.511  -0.620 -13.994  1.00 31.61           C  
ATOM   1593  O   LEU B  76      -4.537   0.064 -14.200  1.00 29.67           O  
ATOM   1594  CB  LEU B  76      -1.409   0.594 -13.300  1.00 36.82           C  
ATOM   1595  CG  LEU B  76      -1.625   2.099 -13.189  1.00 45.05           C  
ATOM   1596  CD1 LEU B  76      -2.692   2.564 -14.163  1.00 57.55           C  
ATOM   1597  CD2 LEU B  76      -2.030   2.523 -11.785  1.00 58.17           C  
ATOM   1598  N   GLY B  77      -3.178  -1.631 -14.792  1.00 26.48           N  
ATOM   1599  CA  GLY B  77      -4.048  -1.992 -15.901  1.00 26.59           C  
ATOM   1600  C   GLY B  77      -3.632  -1.259 -17.171  1.00 26.97           C  
ATOM   1601  O   GLY B  77      -4.391  -1.292 -18.132  1.00 28.00           O  
ATOM   1602  N   ARG B  78      -2.460  -0.643 -17.139  1.00 26.13           N  
ATOM   1603  CA  ARG B  78      -1.888   0.098 -18.254  1.00 21.40           C  
ATOM   1604  C   ARG B  78      -0.461   0.568 -17.958  1.00 27.72           C  
ATOM   1605  O   ARG B  78      -0.071   0.641 -16.784  1.00 29.72           O  
ATOM   1606  CB  ARG B  78      -2.759   1.324 -18.542  1.00 21.26           C  
ATOM   1607  CG  ARG B  78      -2.713   2.392 -17.456  1.00 23.98           C  
ATOM   1608  CD  ARG B  78      -3.191   3.739 -18.004  1.00 27.96           C  
ATOM   1609  NE  ARG B  78      -3.733   4.544 -16.897  1.00 29.46           N  
ATOM   1610  CZ  ARG B  78      -2.889   5.208 -16.098  1.00 30.83           C  
ATOM   1611  NH1 ARG B  78      -1.581   5.110 -16.345  1.00 26.44           N  
ATOM   1612  NH2 ARG B  78      -3.371   5.928 -15.094  1.00 23.62           N  
ATOM   1613  N   PRO B  79       0.343   0.919 -18.957  1.00 21.41           N  
ATOM   1614  CA  PRO B  79       1.709   1.390 -18.674  1.00 20.59           C  
ATOM   1615  C   PRO B  79       1.649   2.624 -17.773  1.00 21.62           C  
ATOM   1616  O   PRO B  79       0.742   3.442 -17.898  1.00 22.69           O  
ATOM   1617  CB  PRO B  79       2.280   1.728 -20.048  1.00 22.30           C  
ATOM   1618  CG  PRO B  79       1.432   0.945 -21.011  1.00 19.57           C  
ATOM   1619  CD  PRO B  79       0.050   0.928 -20.398  1.00 23.74           C  
ATOM   1620  N   ALA B  80       2.615   2.723 -16.861  1.00 18.82           N  
ATOM   1621  CA  ALA B  80       2.631   3.849 -15.926  1.00 20.98           C  
ATOM   1622  C   ALA B  80       3.228   5.099 -16.589  1.00 22.16           C  
ATOM   1623  O   ALA B  80       3.953   5.025 -17.586  1.00 22.04           O  
ATOM   1624  CB  ALA B  80       3.404   3.491 -14.669  1.00 24.99           C  
ATOM   1625  N   ALA B  81       2.892   6.268 -16.055  1.00 16.17           N  
ATOM   1626  CA  ALA B  81       3.458   7.524 -16.540  1.00 15.10           C  
ATOM   1627  C   ALA B  81       3.719   8.382 -15.306  1.00 14.43           C  
ATOM   1628  O   ALA B  81       3.366   7.958 -14.207  1.00 14.79           O  
ATOM   1629  CB  ALA B  81       2.525   8.242 -17.491  1.00 16.79           C  
ATOM   1630  N   VAL B  82       4.285   9.580 -15.467  1.00 15.20           N  
ATOM   1631  CA  VAL B  82       4.661  10.302 -14.226  1.00 16.93           C  
ATOM   1632  C   VAL B  82       3.463  10.611 -13.347  1.00 12.65           C  
ATOM   1633  O   VAL B  82       3.609  10.595 -12.118  1.00 15.10           O  
ATOM   1634  CB  VAL B  82       5.481  11.577 -14.559  1.00 13.80           C  
ATOM   1635  CG1 VAL B  82       4.637  12.579 -15.317  1.00 12.55           C  
ATOM   1636  CG2 VAL B  82       6.053  12.174 -13.278  1.00 12.79           C  
ATOM   1637  N   GLY B  83       2.279  10.858 -13.907  1.00 11.56           N  
ATOM   1638  CA  GLY B  83       1.082  11.171 -13.140  1.00 13.31           C  
ATOM   1639  C   GLY B  83       0.777  10.035 -12.150  1.00 16.14           C  
ATOM   1640  O   GLY B  83       0.331  10.273 -11.020  1.00 17.62           O  
ATOM   1641  N   ASP B  84       1.032   8.794 -12.524  1.00 16.36           N  
ATOM   1642  CA  ASP B  84       0.797   7.669 -11.601  1.00 19.15           C  
ATOM   1643  C   ASP B  84       1.764   7.717 -10.420  1.00 23.09           C  
ATOM   1644  O   ASP B  84       1.367   7.437  -9.278  1.00 17.64           O  
ATOM   1645  CB  ASP B  84       0.931   6.338 -12.344  1.00 17.85           C  
ATOM   1646  CG  ASP B  84      -0.010   6.318 -13.552  1.00 18.51           C  
ATOM   1647  OD1 ASP B  84      -1.213   6.550 -13.311  1.00 23.26           O  
ATOM   1648  OD2 ASP B  84       0.508   6.102 -14.669  1.00 20.75           O  
ATOM   1649  N   TYR B  85       3.018   8.064 -10.697  1.00 14.33           N  
ATOM   1650  CA  TYR B  85       4.002   8.170  -9.620  1.00 14.98           C  
ATOM   1651  C   TYR B  85       3.694   9.347  -8.702  1.00 22.02           C  
ATOM   1652  O   TYR B  85       3.869   9.239  -7.468  1.00 16.88           O  
ATOM   1653  CB  TYR B  85       5.430   8.263 -10.168  1.00 13.33           C  
ATOM   1654  CG  TYR B  85       5.838   6.909 -10.748  1.00 16.79           C  
ATOM   1655  CD1 TYR B  85       6.450   5.932  -9.979  1.00 15.70           C  
ATOM   1656  CD2 TYR B  85       5.576   6.641 -12.089  1.00 16.34           C  
ATOM   1657  CE1 TYR B  85       6.801   4.710 -10.552  1.00 26.07           C  
ATOM   1658  CE2 TYR B  85       5.919   5.432 -12.659  1.00 15.37           C  
ATOM   1659  CZ  TYR B  85       6.532   4.469 -11.882  1.00 24.56           C  
ATOM   1660  OH  TYR B  85       6.868   3.272 -12.476  1.00 24.58           O  
ATOM   1661  N   THR B  86       3.228  10.454  -9.272  1.00 12.91           N  
ATOM   1662  CA  THR B  86       2.823  11.606  -8.468  1.00 12.95           C  
ATOM   1663  C   THR B  86       1.690  11.203  -7.515  1.00 17.48           C  
ATOM   1664  O   THR B  86       1.647  11.523  -6.323  1.00 17.31           O  
ATOM   1665  CB  THR B  86       2.382  12.760  -9.382  1.00 19.12           C  
ATOM   1666  OG1 THR B  86       3.547  13.114 -10.177  1.00 15.13           O  
ATOM   1667  CG2 THR B  86       1.919  13.949  -8.547  1.00 14.28           C  
ATOM   1668  N   ARG B  87       0.750  10.447  -8.086  1.00 14.25           N  
ATOM   1669  CA  ARG B  87      -0.384   9.964  -7.294  1.00 17.15           C  
ATOM   1670  C   ARG B  87       0.073   9.002  -6.207  1.00 14.04           C  
ATOM   1671  O   ARG B  87      -0.385   9.134  -5.070  1.00 21.35           O  
ATOM   1672  CB  ARG B  87      -1.398   9.269  -8.219  1.00 19.14           C  
ATOM   1673  CG  ARG B  87      -2.642   8.778  -7.479  1.00 30.69           C  
ATOM   1674  CD  ARG B  87      -3.537   7.971  -8.428  1.00 47.56           C  
ATOM   1675  NE  ARG B  87      -2.887   6.733  -8.856  1.00 60.80           N  
ATOM   1676  CZ  ARG B  87      -2.545   6.381 -10.085  1.00 58.65           C  
ATOM   1677  NH1 ARG B  87      -2.779   7.169 -11.126  1.00 46.89           N  
ATOM   1678  NH2 ARG B  87      -1.953   5.210 -10.289  1.00 47.91           N  
ATOM   1679  N   LEU B  88       0.959   8.077  -6.547  1.00 14.58           N  
ATOM   1680  CA  LEU B  88       1.392   7.085  -5.546  1.00 16.27           C  
ATOM   1681  C   LEU B  88       2.207   7.745  -4.455  1.00 23.20           C  
ATOM   1682  O   LEU B  88       2.094   7.445  -3.257  1.00 20.05           O  
ATOM   1683  CB  LEU B  88       2.161   5.965  -6.253  1.00 19.22           C  
ATOM   1684  CG  LEU B  88       1.290   5.022  -7.100  1.00 21.77           C  
ATOM   1685  CD1 LEU B  88       2.127   4.088  -7.950  1.00 23.42           C  
ATOM   1686  CD2 LEU B  88       0.358   4.215  -6.196  1.00 26.78           C  
ATOM   1687  N   GLY B  89       3.046   8.708  -4.854  1.00 21.92           N  
ATOM   1688  CA  GLY B  89       3.815   9.452  -3.836  1.00 14.52           C  
ATOM   1689  C   GLY B  89       2.855  10.232  -2.950  1.00 20.82           C  
ATOM   1690  O   GLY B  89       3.026  10.342  -1.726  1.00 22.86           O  
ATOM   1691  N   ALA B  90       1.790  10.803  -3.523  1.00 15.96           N  
ATOM   1692  CA  ALA B  90       0.845  11.541  -2.691  1.00 15.09           C  
ATOM   1693  C   ALA B  90       0.095  10.588  -1.754  1.00 19.06           C  
ATOM   1694  O   ALA B  90      -0.232  11.011  -0.645  1.00 24.03           O  
ATOM   1695  CB  ALA B  90      -0.189  12.299  -3.508  1.00 17.20           C  
ATOM   1696  N   GLU B  91      -0.147   9.371  -2.224  1.00 18.54           N  
ATOM   1697  CA  GLU B  91      -0.866   8.393  -1.400  1.00 19.94           C  
ATOM   1698  C   GLU B  91       0.018   7.974  -0.236  1.00 27.07           C  
ATOM   1699  O   GLU B  91      -0.404   7.927   0.921  1.00 23.98           O  
ATOM   1700  CB  GLU B  91      -1.282   7.173  -2.207  1.00 22.21           C  
ATOM   1701  CG  GLU B  91      -2.436   7.472  -3.156  1.00 28.47           C  
ATOM   1702  CD  GLU B  91      -2.803   6.255  -3.989  1.00 34.93           C  
ATOM   1703  OE1 GLU B  91      -2.334   5.147  -3.648  1.00 30.49           O  
ATOM   1704  OE2 GLU B  91      -3.556   6.420  -4.970  1.00 43.63           O  
ATOM   1705  N   ILE B  92       1.274   7.666  -0.535  1.00 17.52           N  
ATOM   1706  CA  ILE B  92       2.197   7.417   0.572  1.00 17.56           C  
ATOM   1707  C   ILE B  92       2.252   8.601   1.513  1.00 21.92           C  
ATOM   1708  O   ILE B  92       2.184   8.393   2.730  1.00 21.97           O  
ATOM   1709  CB  ILE B  92       3.617   7.122   0.057  1.00 16.90           C  
ATOM   1710  CG1 ILE B  92       3.697   5.825  -0.740  1.00 22.43           C  
ATOM   1711  CG2 ILE B  92       4.604   7.155   1.225  1.00 20.88           C  
ATOM   1712  CD1 ILE B  92       4.932   5.635  -1.591  1.00 18.55           C  
ATOM   1713  N   GLY B  93       2.357   9.821   1.000  1.00 17.45           N  
ATOM   1714  CA  GLY B  93       2.407  11.027   1.799  1.00 15.84           C  
ATOM   1715  C   GLY B  93       1.241  11.168   2.773  1.00 21.79           C  
ATOM   1716  O   GLY B  93       1.395  11.755   3.853  1.00 19.42           O  
ATOM   1717  N   ARG B  94       0.080  10.673   2.367  1.00 24.08           N  
ATOM   1718  CA  ARG B  94      -1.191  10.806   3.067  1.00 30.45           C  
ATOM   1719  C   ARG B  94      -1.432   9.694   4.072  1.00 19.45           C  
ATOM   1720  O   ARG B  94      -1.894   9.952   5.180  1.00 34.25           O  
ATOM   1721  CB  ARG B  94      -2.368  10.763   2.070  1.00 28.40           C  
ATOM   1722  CG  ARG B  94      -3.339  11.916   2.157  1.00 43.50           C  
ATOM   1723  CD  ARG B  94      -4.168  12.087   0.897  1.00 43.67           C  
ATOM   1724  NE  ARG B  94      -4.382  10.861   0.129  1.00 48.22           N  
ATOM   1725  CZ  ARG B  94      -4.097  10.771  -1.173  1.00 49.18           C  
ATOM   1726  NH1 ARG B  94      -3.595  11.827  -1.796  1.00 34.65           N  
ATOM   1727  NH2 ARG B  94      -4.295   9.655  -1.855  1.00 46.80           N  
ATOM   1728  N   ARG B  95      -1.134   8.469   3.666  1.00 20.10           N  
ATOM   1729  CA  ARG B  95      -1.513   7.260   4.351  1.00 30.52           C  
ATOM   1730  C   ARG B  95      -0.491   6.680   5.309  1.00 38.43           C  
ATOM   1731  O   ARG B  95      -0.927   5.950   6.202  1.00 25.95           O  
ATOM   1732  CB  ARG B  95      -1.833   6.163   3.303  1.00 32.68           C  
ATOM   1733  CG  ARG B  95      -3.063   6.591   2.495  1.00 36.86           C  
ATOM   1734  CD  ARG B  95      -3.484   5.504   1.519  1.00 42.97           C  
ATOM   1735  NE  ARG B  95      -4.472   6.055   0.588  1.00 52.90           N  
ATOM   1736  CZ  ARG B  95      -4.376   5.911  -0.727  1.00 66.19           C  
ATOM   1737  NH1 ARG B  95      -3.348   5.238  -1.223  1.00 75.15           N  
ATOM   1738  NH2 ARG B  95      -5.300   6.437  -1.516  1.00 81.48           N  
ATOM   1739  N   VAL B  96       0.803   6.933   5.135  1.00 27.52           N  
ATOM   1740  CA  VAL B  96       1.764   6.417   6.126  1.00 25.18           C  
ATOM   1741  C   VAL B  96       1.399   6.992   7.467  1.00 20.42           C  
ATOM   1742  O   VAL B  96       1.045   8.176   7.528  1.00 25.79           O  
ATOM   1743  CB  VAL B  96       3.202   6.834   5.763  1.00 26.01           C  
ATOM   1744  CG1 VAL B  96       4.162   6.662   6.944  1.00 21.15           C  
ATOM   1745  CG2 VAL B  96       3.655   6.004   4.580  1.00 18.15           C  
ATOM   1746  N   ASP B  97       1.444   6.303   8.612  1.00 25.37           N  
ATOM   1747  CA  ASP B  97       0.961   7.131   9.727  1.00 31.35           C  
ATOM   1748  C   ASP B  97       2.090   7.769  10.534  1.00 35.65           C  
ATOM   1749  O   ASP B  97       2.538   7.187  11.519  1.00 27.72           O  
ATOM   1750  CB  ASP B  97       0.066   6.346  10.689  1.00 49.60           C  
ATOM   1751  CG  ASP B  97      -0.777   7.388  11.424  1.00 68.71           C  
ATOM   1752  OD1 ASP B  97      -1.575   8.064  10.737  1.00101.69           O  
ATOM   1753  OD2 ASP B  97      -0.614   7.527  12.645  1.00 72.50           O  
ATOM   1754  N   MET B  98       2.485   8.956  10.079  1.00 31.58           N  
ATOM   1755  CA  MET B  98       3.534   9.735  10.722  1.00 32.63           C  
ATOM   1756  C   MET B  98       3.084  10.106  12.132  1.00 36.10           C  
ATOM   1757  O   MET B  98       3.903  10.349  13.021  1.00 23.02           O  
ATOM   1758  CB  MET B  98       3.890  10.986   9.910  1.00 30.15           C  
ATOM   1759  CG  MET B  98       4.586  10.650   8.588  1.00 18.31           C  
ATOM   1760  SD  MET B  98       6.011   9.554   8.786  1.00 21.49           S  
ATOM   1761  CE  MET B  98       7.049  10.642   9.760  1.00 21.73           C  
ATOM   1762  N   VAL B  99       1.763  10.140  12.333  1.00 29.34           N  
ATOM   1763  CA  VAL B  99       1.262  10.521  13.669  1.00 25.11           C  
ATOM   1764  C   VAL B  99       1.647   9.498  14.704  1.00 16.87           C  
ATOM   1765  O   VAL B  99       1.998   9.842  15.838  1.00 27.59           O  
ATOM   1766  CB  VAL B  99      -0.267  10.744  13.609  1.00 26.08           C  
ATOM   1767  CG1 VAL B  99      -0.831  10.861  15.006  1.00 31.01           C  
ATOM   1768  CG2 VAL B  99      -0.538  12.011  12.810  1.00 27.70           C  
ATOM   1769  N   PHE B 100       1.656   8.195  14.403  1.00 20.97           N  
ATOM   1770  CA  PHE B 100       2.106   7.269  15.449  1.00 26.48           C  
ATOM   1771  C   PHE B 100       3.578   7.503  15.764  1.00 33.47           C  
ATOM   1772  O   PHE B 100       4.051   7.252  16.879  1.00 23.55           O  
ATOM   1773  CB  PHE B 100       1.848   5.822  15.038  1.00 35.85           C  
ATOM   1774  CG  PHE B 100       0.398   5.654  14.588  1.00 52.32           C  
ATOM   1775  CD1 PHE B 100      -0.601   6.399  15.200  1.00 58.73           C  
ATOM   1776  CD2 PHE B 100       0.069   4.766  13.584  1.00 56.35           C  
ATOM   1777  CE1 PHE B 100      -1.918   6.295  14.792  1.00 52.87           C  
ATOM   1778  CE2 PHE B 100      -1.250   4.637  13.182  1.00 59.86           C  
ATOM   1779  CZ  PHE B 100      -2.232   5.409  13.779  1.00 59.53           C  
ATOM   1780  N   PHE B 101       4.352   8.016  14.805  1.00 25.16           N  
ATOM   1781  CA  PHE B 101       5.765   8.251  15.108  1.00 22.39           C  
ATOM   1782  C   PHE B 101       5.979   9.553  15.856  1.00 29.58           C  
ATOM   1783  O   PHE B 101       6.786   9.673  16.775  1.00 22.68           O  
ATOM   1784  CB  PHE B 101       6.619   8.277  13.823  1.00 18.46           C  
ATOM   1785  CG  PHE B 101       8.098   8.194  14.191  1.00 20.53           C  
ATOM   1786  CD1 PHE B 101       8.640   7.002  14.629  1.00 24.17           C  
ATOM   1787  CD2 PHE B 101       8.904   9.318  14.083  1.00 23.12           C  
ATOM   1788  CE1 PHE B 101       9.985   6.921  14.965  1.00 31.62           C  
ATOM   1789  CE2 PHE B 101      10.244   9.236  14.413  1.00 24.18           C  
ATOM   1790  CZ  PHE B 101      10.782   8.046  14.859  1.00 23.95           C  
ATOM   1791  N   TYR B 102       5.255  10.604  15.473  1.00 21.18           N  
ATOM   1792  CA  TYR B 102       5.393  11.850  16.197  1.00 18.33           C  
ATOM   1793  C   TYR B 102       4.931  11.687  17.658  1.00 32.39           C  
ATOM   1794  O   TYR B 102       5.519  12.321  18.545  1.00 23.87           O  
ATOM   1795  CB  TYR B 102       4.549  12.966  15.620  1.00 21.59           C  
ATOM   1796  CG  TYR B 102       4.705  13.259  14.149  1.00 27.35           C  
ATOM   1797  CD1 TYR B 102       5.950  13.258  13.527  1.00 22.97           C  
ATOM   1798  CD2 TYR B 102       3.565  13.554  13.402  1.00 26.05           C  
ATOM   1799  CE1 TYR B 102       6.060  13.543  12.169  1.00 22.02           C  
ATOM   1800  CE2 TYR B 102       3.678  13.834  12.052  1.00 22.11           C  
ATOM   1801  CZ  TYR B 102       4.917  13.828  11.448  1.00 22.35           C  
ATOM   1802  OH  TYR B 102       4.999  14.103  10.103  1.00 21.45           O  
ATOM   1803  N   ASN B 103       3.888  10.870  17.830  1.00 22.69           N  
ATOM   1804  CA  ASN B 103       3.397  10.614  19.185  1.00 27.28           C  
ATOM   1805  C   ASN B 103       4.449   9.893  20.013  1.00 26.53           C  
ATOM   1806  O   ASN B 103       4.602  10.087  21.212  1.00 27.07           O  
ATOM   1807  CB  ASN B 103       2.148   9.730  19.186  1.00 26.36           C  
ATOM   1808  CG  ASN B 103       0.898  10.527  18.854  1.00 31.56           C  
ATOM   1809  OD1 ASN B 103       0.926  11.759  18.919  1.00 26.10           O  
ATOM   1810  ND2 ASN B 103      -0.149   9.777  18.510  1.00 27.66           N  
ATOM   1811  N   PHE B 104       5.167   9.004  19.323  1.00 21.65           N  
ATOM   1812  CA  PHE B 104       6.190   8.255  20.058  1.00 25.33           C  
ATOM   1813  C   PHE B 104       7.335   9.155  20.497  1.00 35.11           C  
ATOM   1814  O   PHE B 104       7.782   9.091  21.648  1.00 26.03           O  
ATOM   1815  CB  PHE B 104       6.628   7.130  19.138  1.00 28.14           C  
ATOM   1816  CG  PHE B 104       7.827   6.360  19.636  1.00 23.78           C  
ATOM   1817  CD1 PHE B 104       7.661   5.357  20.568  1.00 25.38           C  
ATOM   1818  CD2 PHE B 104       9.085   6.679  19.151  1.00 30.40           C  
ATOM   1819  CE1 PHE B 104       8.771   4.651  20.982  1.00 31.53           C  
ATOM   1820  CE2 PHE B 104      10.200   5.996  19.591  1.00 31.45           C  
ATOM   1821  CZ  PHE B 104      10.018   4.952  20.478  1.00 32.38           C  
ATOM   1822  N   LEU B 105       7.859  10.016  19.621  1.00 26.96           N  
ATOM   1823  CA  LEU B 105       8.997  10.862  19.993  1.00 24.66           C  
ATOM   1824  C   LEU B 105       8.618  11.883  21.048  1.00 25.13           C  
ATOM   1825  O   LEU B 105       9.240  12.030  22.103  1.00 25.13           O  
ATOM   1826  CB  LEU B 105       9.556  11.595  18.761  1.00 25.03           C  
ATOM   1827  CG  LEU B 105      10.273  10.754  17.710  1.00 28.96           C  
ATOM   1828  CD1 LEU B 105      10.805  11.645  16.597  1.00 24.30           C  
ATOM   1829  CD2 LEU B 105      11.394   9.920  18.327  1.00 22.54           C  
ATOM   1830  N   SER B 106       7.550  12.640  20.804  1.00 20.62           N  
ATOM   1831  CA  SER B 106       7.048  13.596  21.763  1.00 17.72           C  
ATOM   1832  C   SER B 106       6.543  12.972  23.061  1.00 19.10           C  
ATOM   1833  O   SER B 106       6.827  13.503  24.152  1.00 25.36           O  
ATOM   1834  CB  SER B 106       5.878  14.386  21.138  1.00 27.36           C  
ATOM   1835  OG  SER B 106       5.678  15.583  21.870  1.00 43.01           O  
ATOM   1836  N   GLY B 107       5.823  11.871  22.958  1.00 19.03           N  
ATOM   1837  CA  GLY B 107       5.264  11.177  24.125  1.00 21.24           C  
ATOM   1838  C   GLY B 107       6.337  10.720  25.088  1.00 27.84           C  
ATOM   1839  O   GLY B 107       6.150  10.642  26.314  1.00 23.18           O  
ATOM   1840  N   ARG B 108       7.516  10.392  24.551  1.00 19.99           N  
ATOM   1841  CA  ARG B 108       8.584   9.881  25.406  1.00 17.69           C  
ATOM   1842  C   ARG B 108       9.629  10.940  25.732  1.00 18.96           C  
ATOM   1843  O   ARG B 108      10.654  10.543  26.285  1.00 21.38           O  
ATOM   1844  CB  ARG B 108       9.371   8.741  24.756  1.00 23.83           C  
ATOM   1845  CG  ARG B 108       8.608   7.573  24.208  1.00 29.23           C  
ATOM   1846  CD  ARG B 108       7.859   6.840  25.299  1.00 25.31           C  
ATOM   1847  NE  ARG B 108       7.141   5.688  24.748  1.00 32.22           N  
ATOM   1848  CZ  ARG B 108       7.446   4.459  25.164  1.00 33.56           C  
ATOM   1849  NH1 ARG B 108       8.412   4.367  26.067  1.00 24.42           N  
ATOM   1850  NH2 ARG B 108       6.787   3.424  24.671  1.00 28.58           N  
ATOM   1851  N   LYS B 109       9.363  12.177  25.355  1.00 21.78           N  
ATOM   1852  CA  LYS B 109      10.354  13.247  25.506  1.00 20.98           C  
ATOM   1853  C   LYS B 109      11.666  12.816  24.848  1.00 27.63           C  
ATOM   1854  O   LYS B 109      12.721  13.026  25.456  1.00 24.94           O  
ATOM   1855  CB  LYS B 109      10.593  13.599  26.967  1.00 19.16           C  
ATOM   1856  CG  LYS B 109       9.332  13.889  27.761  1.00 30.23           C  
ATOM   1857  CD  LYS B 109       9.700  14.585  29.069  1.00 29.91           C  
ATOM   1858  CE  LYS B 109       9.658  13.592  30.215  1.00 33.74           C  
ATOM   1859  NZ  LYS B 109      10.037  14.297  31.482  1.00 46.49           N  
ATOM   1860  N   MET B 110      11.586  12.234  23.649  1.00 18.34           N  
ATOM   1861  CA  MET B 110      12.816  11.854  22.947  1.00 17.70           C  
ATOM   1862  C   MET B 110      12.953  12.581  21.623  1.00 20.34           C  
ATOM   1863  O   MET B 110      13.598  12.128  20.674  1.00 18.54           O  
ATOM   1864  CB  MET B 110      12.896  10.328  22.763  1.00 17.55           C  
ATOM   1865  CG  MET B 110      13.133   9.635  24.127  1.00 20.07           C  
ATOM   1866  SD  MET B 110      14.763  10.057  24.816  1.00 17.43           S  
ATOM   1867  CE  MET B 110      15.854   9.107  23.764  1.00 18.79           C  
ATOM   1868  N   ILE B 111      12.350  13.773  21.512  1.00 20.12           N  
ATOM   1869  CA  ILE B 111      12.664  14.498  20.272  1.00 23.14           C  
ATOM   1870  C   ILE B 111      14.131  14.919  20.346  1.00 21.02           C  
ATOM   1871  O   ILE B 111      14.558  15.571  21.289  1.00 24.18           O  
ATOM   1872  CB  ILE B 111      11.758  15.717  20.078  1.00 20.54           C  
ATOM   1873  CG1 ILE B 111      10.275  15.321  20.015  1.00 20.60           C  
ATOM   1874  CG2 ILE B 111      12.166  16.539  18.865  1.00 18.82           C  
ATOM   1875  CD1 ILE B 111       9.339  16.511  20.109  1.00 31.77           C  
ATOM   1876  N   PRO B 112      14.883  14.545  19.334  1.00 19.97           N  
ATOM   1877  CA  PRO B 112      16.308  14.874  19.300  1.00 21.00           C  
ATOM   1878  C   PRO B 112      16.565  16.370  19.262  1.00 28.29           C  
ATOM   1879  O   PRO B 112      15.755  17.202  18.828  1.00 20.85           O  
ATOM   1880  CB  PRO B 112      16.784  14.270  17.979  1.00 34.23           C  
ATOM   1881  CG  PRO B 112      15.697  13.403  17.463  1.00 24.83           C  
ATOM   1882  CD  PRO B 112      14.424  13.802  18.153  1.00 16.33           C  
ATOM   1883  N   PRO B 113      17.753  16.772  19.715  1.00 29.15           N  
ATOM   1884  CA  PRO B 113      18.111  18.185  19.545  1.00 28.45           C  
ATOM   1885  C   PRO B 113      18.265  18.471  18.056  1.00 20.68           C  
ATOM   1886  O   PRO B 113      18.618  17.608  17.250  1.00 23.86           O  
ATOM   1887  CB  PRO B 113      19.472  18.297  20.221  1.00 30.49           C  
ATOM   1888  CG  PRO B 113      20.029  16.913  20.061  1.00 26.71           C  
ATOM   1889  CD  PRO B 113      18.836  16.026  20.359  1.00 32.43           C  
ATOM   1890  N   TYR B 114      17.993  19.707  17.684  1.00 28.36           N  
ATOM   1891  CA  TYR B 114      18.182  20.104  16.290  1.00 21.55           C  
ATOM   1892  C   TYR B 114      19.652  20.326  16.026  1.00 26.88           C  
ATOM   1893  O   TYR B 114      20.217  21.276  16.569  1.00 28.56           O  
ATOM   1894  CB  TYR B 114      17.383  21.380  16.035  1.00 30.95           C  
ATOM   1895  CG  TYR B 114      17.152  21.736  14.585  1.00 28.93           C  
ATOM   1896  CD1 TYR B 114      16.706  20.767  13.691  1.00 24.55           C  
ATOM   1897  CD2 TYR B 114      17.355  23.030  14.119  1.00 29.60           C  
ATOM   1898  CE1 TYR B 114      16.476  21.059  12.364  1.00 23.18           C  
ATOM   1899  CE2 TYR B 114      17.126  23.331  12.786  1.00 34.30           C  
ATOM   1900  CZ  TYR B 114      16.687  22.349  11.922  1.00 31.12           C  
ATOM   1901  OH  TYR B 114      16.466  22.640  10.594  1.00 30.16           O  
ATOM   1902  N   SER B 115      20.266  19.485  15.206  1.00 18.56           N  
ATOM   1903  CA  SER B 115      21.656  19.603  14.848  1.00 16.45           C  
ATOM   1904  C   SER B 115      21.907  20.222  13.479  1.00 19.70           C  
ATOM   1905  O   SER B 115      21.053  20.176  12.584  1.00 25.34           O  
ATOM   1906  CB  SER B 115      22.257  18.178  14.846  1.00 19.98           C  
ATOM   1907  OG  SER B 115      22.087  17.667  16.176  1.00 44.04           O  
ATOM   1908  N   ALA B 116      23.117  20.736  13.286  1.00 24.53           N  
ATOM   1909  CA  ALA B 116      23.539  21.231  11.976  1.00 25.50           C  
ATOM   1910  C   ALA B 116      23.259  20.240  10.863  1.00 26.45           C  
ATOM   1911  O   ALA B 116      22.752  20.636   9.799  1.00 23.33           O  
ATOM   1912  CB  ALA B 116      25.023  21.618  12.040  1.00 28.72           C  
ATOM   1913  N   TYR B 117      23.549  18.939  10.986  1.00 19.18           N  
ATOM   1914  CA  TYR B 117      23.264  18.068   9.847  1.00 20.10           C  
ATOM   1915  C   TYR B 117      21.770  18.026   9.544  1.00 17.52           C  
ATOM   1916  O   TYR B 117      21.359  17.768   8.413  1.00 20.66           O  
ATOM   1917  CB  TYR B 117      23.817  16.659  10.098  1.00 20.14           C  
ATOM   1918  CG  TYR B 117      22.989  15.738  10.962  1.00 20.01           C  
ATOM   1919  CD1 TYR B 117      23.121  15.719  12.348  1.00 21.45           C  
ATOM   1920  CD2 TYR B 117      22.066  14.860  10.391  1.00 25.06           C  
ATOM   1921  CE1 TYR B 117      22.344  14.865  13.122  1.00 22.32           C  
ATOM   1922  CE2 TYR B 117      21.299  14.002  11.160  1.00 23.44           C  
ATOM   1923  CZ  TYR B 117      21.441  14.012  12.534  1.00 26.25           C  
ATOM   1924  OH  TYR B 117      20.671  13.157  13.292  1.00 28.68           O  
ATOM   1925  N   MET B 118      20.939  18.241  10.538  1.00 16.70           N  
ATOM   1926  CA  MET B 118      19.493  18.220  10.354  1.00 16.70           C  
ATOM   1927  C   MET B 118      19.028  19.462   9.601  1.00 23.36           C  
ATOM   1928  O   MET B 118      18.174  19.384   8.720  1.00 22.27           O  
ATOM   1929  CB  MET B 118      18.796  18.166  11.703  1.00 20.69           C  
ATOM   1930  CG  MET B 118      19.115  16.853  12.445  1.00 22.09           C  
ATOM   1931  SD  MET B 118      18.398  16.975  14.094  1.00 25.32           S  
ATOM   1932  CE  MET B 118      19.463  15.867  15.009  1.00 45.90           C  
ATOM   1933  N   ALA B 119      19.584  20.610   9.979  1.00 20.89           N  
ATOM   1934  CA  ALA B 119      19.250  21.838   9.253  1.00 21.10           C  
ATOM   1935  C   ALA B 119      19.699  21.712   7.802  1.00 24.18           C  
ATOM   1936  O   ALA B 119      19.038  22.216   6.892  1.00 26.02           O  
ATOM   1937  CB  ALA B 119      19.896  23.066   9.890  1.00 22.94           C  
ATOM   1938  N   LYS B 120      20.826  21.030   7.587  1.00 19.34           N  
ATOM   1939  CA  LYS B 120      21.296  20.804   6.233  1.00 21.23           C  
ATOM   1940  C   LYS B 120      20.267  20.009   5.425  1.00 24.94           C  
ATOM   1941  O   LYS B 120      19.994  20.300   4.261  1.00 23.25           O  
ATOM   1942  CB  LYS B 120      22.600  20.035   6.206  1.00 27.52           C  
ATOM   1943  CG  LYS B 120      23.889  20.802   6.426  1.00 43.71           C  
ATOM   1944  CD  LYS B 120      25.024  19.908   5.905  1.00 63.74           C  
ATOM   1945  CE  LYS B 120      24.532  19.157   4.668  1.00 72.44           C  
ATOM   1946  NZ  LYS B 120      24.092  17.769   4.971  1.00 71.56           N  
ATOM   1947  N   LEU B 121      19.718  18.959   6.046  1.00 20.33           N  
ATOM   1948  CA  LEU B 121      18.784  18.145   5.248  1.00 22.13           C  
ATOM   1949  C   LEU B 121      17.492  18.914   4.981  1.00 16.55           C  
ATOM   1950  O   LEU B 121      16.905  18.750   3.912  1.00 19.93           O  
ATOM   1951  CB  LEU B 121      18.471  16.808   5.934  1.00 22.44           C  
ATOM   1952  CG  LEU B 121      17.679  15.767   5.141  1.00 22.59           C  
ATOM   1953  CD1 LEU B 121      18.504  15.215   3.989  1.00 22.02           C  
ATOM   1954  CD2 LEU B 121      17.234  14.628   6.054  1.00 14.32           C  
ATOM   1955  N   ASN B 122      17.068  19.724   5.927  1.00 20.01           N  
ATOM   1956  CA  ASN B 122      15.848  20.517   5.862  1.00 18.38           C  
ATOM   1957  C   ASN B 122      15.973  21.632   4.807  1.00 23.29           C  
ATOM   1958  O   ASN B 122      14.931  22.061   4.309  1.00 24.49           O  
ATOM   1959  CB  ASN B 122      15.533  21.141   7.204  1.00 16.92           C  
ATOM   1960  CG  ASN B 122      14.612  20.323   8.071  1.00 20.10           C  
ATOM   1961  OD1 ASN B 122      13.985  19.372   7.616  1.00 25.87           O  
ATOM   1962  ND2 ASN B 122      14.532  20.708   9.341  1.00 16.71           N  
ATOM   1963  N   ALA B 123      17.200  22.038   4.504  1.00 20.90           N  
ATOM   1964  CA  ALA B 123      17.470  23.115   3.567  1.00 24.75           C  
ATOM   1965  C   ALA B 123      17.457  22.643   2.124  1.00 29.45           C  
ATOM   1966  O   ALA B 123      17.263  23.436   1.192  1.00 22.53           O  
ATOM   1967  CB  ALA B 123      18.819  23.793   3.828  1.00 22.07           C  
ATOM   1968  N   LEU B 124      17.670  21.353   1.894  1.00 23.08           N  
ATOM   1969  CA  LEU B 124      17.583  20.849   0.528  1.00 19.65           C  
ATOM   1970  C   LEU B 124      16.166  20.933  -0.035  1.00 20.26           C  
ATOM   1971  O   LEU B 124      15.197  20.828   0.707  1.00 22.69           O  
ATOM   1972  CB  LEU B 124      17.978  19.383   0.416  1.00 18.87           C  
ATOM   1973  CG  LEU B 124      19.402  19.017   0.848  1.00 28.09           C  
ATOM   1974  CD1 LEU B 124      19.519  17.505   1.020  1.00 20.52           C  
ATOM   1975  CD2 LEU B 124      20.429  19.540  -0.150  1.00 22.71           C  
ATOM   1976  N   ARG B 125      16.079  21.076  -1.351  1.00 18.86           N  
ATOM   1977  CA  ARG B 125      14.790  20.935  -2.016  1.00 16.47           C  
ATOM   1978  C   ARG B 125      14.421  19.451  -1.923  1.00 15.63           C  
ATOM   1979  O   ARG B 125      15.329  18.654  -2.105  1.00 16.31           O  
ATOM   1980  CB  ARG B 125      14.904  21.353  -3.488  1.00 21.61           C  
ATOM   1981  CG  ARG B 125      15.260  22.826  -3.670  1.00 24.66           C  
ATOM   1982  CD  ARG B 125      15.232  23.208  -5.156  1.00 28.16           C  
ATOM   1983  NE  ARG B 125      16.421  22.644  -5.814  1.00 39.58           N  
ATOM   1984  CZ  ARG B 125      17.553  23.348  -5.920  1.00 41.27           C  
ATOM   1985  NH1 ARG B 125      17.597  24.580  -5.429  1.00 37.11           N  
ATOM   1986  NH2 ARG B 125      18.614  22.820  -6.511  1.00 42.47           N  
ATOM   1987  N   PRO B 126      13.175  19.100  -1.666  1.00 18.82           N  
ATOM   1988  CA  PRO B 126      12.778  17.684  -1.638  1.00 19.38           C  
ATOM   1989  C   PRO B 126      13.292  16.897  -2.825  1.00 19.47           C  
ATOM   1990  O   PRO B 126      13.703  15.746  -2.698  1.00 20.07           O  
ATOM   1991  CB  PRO B 126      11.241  17.781  -1.714  1.00 18.50           C  
ATOM   1992  CG  PRO B 126      10.993  19.018  -0.886  1.00 23.91           C  
ATOM   1993  CD  PRO B 126      12.045  19.997  -1.375  1.00 19.47           C  
ATOM   1994  N   ALA B 127      13.306  17.519  -4.004  1.00 16.57           N  
ATOM   1995  CA  ALA B 127      13.804  16.824  -5.181  1.00 22.05           C  
ATOM   1996  C   ALA B 127      15.252  16.378  -5.041  1.00 21.85           C  
ATOM   1997  O   ALA B 127      15.680  15.429  -5.703  1.00 20.90           O  
ATOM   1998  CB  ALA B 127      13.681  17.741  -6.399  1.00 34.97           C  
ATOM   1999  N   ASP B 128      15.999  17.055  -4.167  1.00 19.25           N  
ATOM   2000  CA  ASP B 128      17.403  16.724  -3.984  1.00 20.47           C  
ATOM   2001  C   ASP B 128      17.710  15.905  -2.738  1.00 25.68           C  
ATOM   2002  O   ASP B 128      18.883  15.634  -2.444  1.00 24.28           O  
ATOM   2003  CB  ASP B 128      18.250  18.014  -3.873  1.00 25.83           C  
ATOM   2004  CG  ASP B 128      18.154  18.888  -5.107  1.00 34.06           C  
ATOM   2005  OD1 ASP B 128      18.075  18.325  -6.218  1.00 37.28           O  
ATOM   2006  OD2 ASP B 128      18.153  20.129  -4.940  1.00 34.30           O  
ATOM   2007  N   VAL B 129      16.705  15.508  -1.968  1.00 14.94           N  
ATOM   2008  CA  VAL B 129      16.988  14.687  -0.786  1.00 13.52           C  
ATOM   2009  C   VAL B 129      17.488  13.336  -1.239  1.00 20.41           C  
ATOM   2010  O   VAL B 129      16.826  12.616  -2.010  1.00 20.79           O  
ATOM   2011  CB  VAL B 129      15.715  14.577   0.078  1.00 17.08           C  
ATOM   2012  CG1 VAL B 129      15.834  13.552   1.195  1.00 15.95           C  
ATOM   2013  CG2 VAL B 129      15.391  15.940   0.684  1.00 18.12           C  
ATOM   2014  N   PRO B 130      18.687  12.936  -0.832  1.00 23.73           N  
ATOM   2015  CA  PRO B 130      19.206  11.671  -1.365  1.00 21.11           C  
ATOM   2016  C   PRO B 130      18.456  10.449  -0.840  1.00 24.63           C  
ATOM   2017  O   PRO B 130      18.101  10.320   0.331  1.00 19.09           O  
ATOM   2018  CB  PRO B 130      20.661  11.649  -0.875  1.00 21.64           C  
ATOM   2019  CG  PRO B 130      20.746  12.606   0.247  1.00 20.45           C  
ATOM   2020  CD  PRO B 130      19.623  13.598   0.081  1.00 20.53           C  
ATOM   2021  N   VAL B 131      18.224   9.502  -1.750  1.00 21.08           N  
ATOM   2022  CA  VAL B 131      17.637   8.231  -1.340  1.00 23.07           C  
ATOM   2023  C   VAL B 131      18.408   7.113  -2.027  1.00 31.37           C  
ATOM   2024  O   VAL B 131      19.154   7.373  -2.967  1.00 28.30           O  
ATOM   2025  CB  VAL B 131      16.160   8.108  -1.716  1.00 20.32           C  
ATOM   2026  CG1 VAL B 131      15.320   9.195  -1.066  1.00 16.81           C  
ATOM   2027  CG2 VAL B 131      16.018   8.161  -3.237  1.00 20.88           C  
ATOM   2028  N   LYS B 132      18.219   5.879  -1.588  1.00 32.83           N  
ATOM   2029  CA  LYS B 132      18.958   4.792  -2.240  1.00 36.01           C  
ATOM   2030  C   LYS B 132      18.168   4.247  -3.421  1.00 34.15           C  
ATOM   2031  O   LYS B 132      17.411   3.290  -3.295  1.00 36.21           O  
ATOM   2032  CB  LYS B 132      19.298   3.719  -1.206  1.00 42.64           C  
ATOM   2033  CG  LYS B 132      20.280   4.234  -0.158  1.00 56.34           C  
ATOM   2034  CD  LYS B 132      19.700   4.138   1.245  1.00 72.49           C  
ATOM   2035  CE  LYS B 132      20.506   3.190   2.117  1.00 80.98           C  
ATOM   2036  NZ  LYS B 132      19.641   2.222   2.861  1.00 89.10           N  
ATOM   2037  N   ASN B 133      18.364   4.878  -4.577  1.00 35.85           N  
ATOM   2038  CA  ASN B 133      17.610   4.636  -5.786  1.00 52.81           C  
ATOM   2039  C   ASN B 133      18.433   4.696  -7.070  1.00 80.35           C  
ATOM   2040  O   ASN B 133      17.944   4.285  -8.126  1.00 94.48           O  
ATOM   2041  CB  ASN B 133      16.515   5.707  -5.930  1.00 48.91           C  
ATOM   2042  CG  ASN B 133      15.457   5.259  -6.923  1.00 50.52           C  
ATOM   2043  OD1 ASN B 133      14.770   4.279  -6.651  1.00 59.50           O  
ATOM   2044  ND2 ASN B 133      15.328   5.963  -8.038  1.00 37.43           N  
ATOM   2045  N   HIS B 134      19.641   5.228  -6.968  1.00 96.15           N  
ATOM   2046  CA  HIS B 134      20.507   5.447  -8.121  1.00106.52           C  
ATOM   2047  C   HIS B 134      20.602   4.210  -9.001  1.00111.00           C  
ATOM   2048  O   HIS B 134      19.669   3.919  -9.755  1.00121.62           O  
ATOM   2049  CB  HIS B 134      21.896   5.875  -7.623  1.00109.65           C  
ATOM   2050  CG  HIS B 134      21.883   6.082  -6.138  1.00114.34           C  
ATOM   2051  ND1 HIS B 134      21.711   5.042  -5.248  1.00116.42           N  
ATOM   2052  CD2 HIS B 134      22.004   7.201  -5.390  1.00117.74           C  
ATOM   2053  CE1 HIS B 134      21.735   5.513  -4.016  1.00118.65           C  
ATOM   2054  NE2 HIS B 134      21.915   6.821  -4.072  1.00119.26           N  
TER    2055      HIS B 134                                                      
END
MOLECULE T0443_31_96.pdb
ATOM      1  N   LEU    31      17.573  12.561  -4.844  1.00 44.52           N  
ATOM      2  CA  LEU    31      16.276  12.957  -4.211  1.00 43.54           C  
ATOM      3  C   LEU    31      15.334  13.605  -5.268  1.00 43.20           C  
ATOM      4  O   LEU    31      15.322  14.825  -5.467  1.00 43.85           O  
ATOM      5  CB  LEU    31      16.564  13.888  -3.031  1.00 44.76           C  
ATOM      6  CG  LEU    31      15.563  13.836  -1.877  1.00 45.52           C  
ATOM      7  CD1 LEU    31      16.076  14.602  -0.669  1.00 45.49           C  
ATOM      8  CD2 LEU    31      14.212  14.362  -2.329  1.00 46.09           C  
ATOM      9  N   ASN    32      14.528  12.772  -5.920  1.00 41.03           N  
ATOM     10  CA  ASN    32      13.645  13.222  -7.005  1.00 40.05           C  
ATOM     11  C   ASN    32      12.429  14.110  -6.613  1.00 38.84           C  
ATOM     12  O   ASN    32      12.146  14.344  -5.433  1.00 38.46           O  
ATOM     13  CB  ASN    32      13.254  12.027  -7.901  1.00 39.14           C  
ATOM     14  CG  ASN    32      12.441  10.973  -7.181  1.00 38.38           C  
ATOM     15  OD1 ASN    32      11.411  11.270  -6.598  1.00 37.94           O  
ATOM     16  ND2 ASN    32      12.869   9.722  -7.280  1.00 37.45           N  
ATOM     17  N   VAL    33      11.736  14.625  -7.619  1.00 37.57           N  
ATOM     18  CA  VAL    33      10.610  15.536  -7.400  1.00 37.88           C  
ATOM     19  C   VAL    33       9.437  14.879  -6.622  1.00 38.17           C  
ATOM     20  O   VAL    33       8.710  15.567  -5.895  1.00 37.81           O  
ATOM     21  CB  VAL    33      10.146  16.171  -8.752  1.00 37.94           C  
ATOM     22  CG1 VAL    33       9.582  15.124  -9.669  1.00 38.16           C  
ATOM     23  CG2 VAL    33       9.120  17.263  -8.531  1.00 38.67           C  
ATOM     24  N   TYR    34       9.279  13.557  -6.782  1.00 37.61           N  
ATOM     25  CA  TYR    34       8.266  12.775  -6.094  1.00 36.92           C  
ATOM     26  C   TYR    34       8.579  12.641  -4.591  1.00 36.39           C  
ATOM     27  O   TYR    34       7.687  12.801  -3.752  1.00 34.21           O  
ATOM     28  CB  TYR    34       8.075  11.388  -6.771  1.00 38.00           C  
ATOM     29  CG  TYR    34       7.128  10.484  -6.007  1.00 38.31           C  
ATOM     30  CD1 TYR    34       5.763  10.731  -6.001  1.00 38.37           C  
ATOM     31  CD2 TYR    34       7.603   9.409  -5.247  1.00 38.86           C  
ATOM     32  CE1 TYR    34       4.897   9.949  -5.275  1.00 38.25           C  
ATOM     33  CE2 TYR    34       6.723   8.608  -4.515  1.00 38.40           C  
ATOM     34  CZ  TYR    34       5.373   8.890  -4.541  1.00 38.20           C  
ATOM     35  OH  TYR    34       4.470   8.131  -3.816  1.00 38.57           O  
ATOM     36  N   ILE    35       9.843  12.364  -4.260  1.00 36.54           N  
ATOM     37  CA  ILE    35      10.288  12.240  -2.863  1.00 36.34           C  
ATOM     38  C   ILE    35      10.135  13.583  -2.136  1.00 36.17           C  
ATOM     39  O   ILE    35       9.784  13.613  -0.947  1.00 33.51           O  
ATOM     40  CB  ILE    35      11.752  11.733  -2.758  1.00 36.54           C  
ATOM     41  CG1 ILE    35      11.904  10.342  -3.389  1.00 37.22           C  
ATOM     42  CG2 ILE    35      12.213  11.660  -1.319  1.00 36.22           C  
ATOM     43  CD1 ILE    35      11.129   9.223  -2.697  1.00 37.21           C  
ATOM     44  N   ARG    36      10.384  14.682  -2.853  1.00 36.24           N  
ATOM     45  CA  ARG    36      10.229  16.021  -2.282  1.00 38.06           C  
ATOM     46  C   ARG    36       8.748  16.345  -2.052  1.00 37.48           C  
ATOM     47  O   ARG    36       8.398  16.972  -1.052  1.00 37.67           O  
ATOM     48  CB  ARG    36      10.871  17.107  -3.160  1.00 39.21           C  
ATOM     49  CG  ARG    36      12.394  17.179  -3.103  1.00 40.33           C  
ATOM     50  CD  ARG    36      12.932  18.438  -3.830  1.00 40.62           C  
ATOM     51  NE  ARG    36      14.375  18.634  -3.621  1.00 41.51           N  
ATOM     52  N   LEU    37       7.889  15.935  -2.986  1.00 36.32           N  
ATOM     53  CA  LEU    37       6.453  16.135  -2.845  1.00 35.88           C  
ATOM     54  C   LEU    37       5.916  15.380  -1.619  1.00 35.36           C  
ATOM     55  O   LEU    37       5.257  15.979  -0.779  1.00 34.58           O  
ATOM     56  CB  LEU    37       5.706  15.722  -4.133  1.00 35.78           C  
ATOM     57  CG  LEU    37       4.184  15.878  -4.172  1.00 35.65           C  
ATOM     58  CD1 LEU    37       3.787  17.308  -3.838  1.00 35.55           C  
ATOM     59  CD2 LEU    37       3.612  15.476  -5.538  1.00 35.55           C  
ATOM     60  N   ILE    38       6.220  14.087  -1.496  1.00 35.62           N  
ATOM     61  CA  ILE    38       5.716  13.300  -0.358  1.00 36.20           C  
ATOM     62  C   ILE    38       6.279  13.740   0.980  1.00 35.39           C  
ATOM     63  O   ILE    38       5.596  13.602   1.985  1.00 32.16           O  
ATOM     64  CB  ILE    38       5.862  11.741  -0.511  1.00 36.97           C  
ATOM     65  CG1 ILE    38       7.303  11.292  -0.676  1.00 37.64           C  
ATOM     66  CG2 ILE    38       5.047  11.239  -1.654  1.00 37.31           C  
ATOM     67  CD1 ILE    38       7.441   9.799  -1.046  1.00 37.85           C  
ATOM     68  N   ARG    39       7.516  14.251   1.004  1.00 35.25           N  
ATOM     69  CA  ARG    39       8.075  14.794   2.240  1.00 35.73           C  
ATOM     70  C   ARG    39       7.334  16.062   2.652  1.00 35.39           C  
ATOM     71  O   ARG    39       7.077  16.255   3.830  1.00 35.59           O  
ATOM     72  CB  ARG    39       9.586  15.035   2.153  1.00 36.43           C  
ATOM     73  CG  ARG    39      10.399  13.758   2.251  1.00 36.58           C  
ATOM     74  CD  ARG    39      11.892  14.023   2.215  1.00 37.77           C  
ATOM     75  NE  ARG    39      12.614  12.754   2.225  1.00 38.50           N  
ATOM     76  CZ  ARG    39      13.918  12.612   2.442  1.00 39.28           C  
ATOM     77  NH1 ARG    39      14.675  13.665   2.717  1.00 39.99           N  
ATOM     78  NH2 ARG    39      14.456  11.393   2.422  1.00 39.30           N  
ATOM     79  N   ASN    40       6.974  16.919   1.701  1.00 36.47           N  
ATOM     80  CA  ASN    40       6.147  18.102   2.036  1.00 37.87           C  
ATOM     81  C   ASN    40       4.726  17.728   2.520  1.00 36.33           C  
ATOM     82  O   ASN    40       4.179  18.387   3.394  1.00 36.31           O  
ATOM     83  CB  ASN    40       6.085  19.098   0.869  1.00 39.93           C  
ATOM     84  CG  ASN    40       7.362  19.912   0.735  1.00 41.61           C  
ATOM     85  OD1 ASN    40       8.083  20.134   1.718  1.00 43.85           O  
ATOM     86  ND2 ASN    40       7.649  20.366  -0.476  1.00 43.10           N  
ATOM     87  N   ASN    41       4.158  16.664   1.961  1.00 34.58           N  
ATOM     88  CA  ASN    41       2.842  16.183   2.368  1.00 34.12           C  
ATOM     89  C   ASN    41       2.913  15.549   3.749  1.00 33.10           C  
ATOM     90  O   ASN    41       1.945  15.575   4.474  1.00 32.27           O  
ATOM     91  CB  ASN    41       2.268  15.183   1.366  1.00 33.77           C  
ATOM     92  CG  ASN    41       1.945  15.805   0.030  1.00 33.71           C  
ATOM     93  OD1 ASN    41       2.195  17.001  -0.204  1.00 33.95           O  
ATOM     94  ND2 ASN    41       1.369  14.997  -0.866  1.00 32.28           N  
ATOM     95  N   ILE    42       4.072  14.993   4.101  1.00 33.48           N  
ATOM     96  CA  ILE    42       4.303  14.426   5.441  1.00 34.18           C  
ATOM     97  C   ILE    42       4.342  15.558   6.499  1.00 34.18           C  
ATOM     98  O   ILE    42       3.648  15.515   7.514  1.00 35.39           O  
ATOM     99  CB  ILE    42       5.594  13.538   5.461  1.00 33.79           C  
ATOM    100  CG1 ILE    42       5.329  12.238   4.687  1.00 34.00           C  
ATOM    101  CG2 ILE    42       6.026  13.205   6.893  1.00 33.13           C  
ATOM    102  CD1 ILE    42       6.466  11.222   4.689  1.00 34.19           C  
ATOM    103  N   HIS    43       5.149  16.568   6.237  1.00 35.51           N  
ATOM    104  CA  HIS    43       5.255  17.746   7.103  1.00 36.15           C  
ATOM    105  C   HIS    43       3.855  18.338   7.336  1.00 35.62           C  
ATOM    106  O   HIS    43       3.429  18.481   8.471  1.00 35.79           O  
ATOM    107  CB  HIS    43       6.215  18.782   6.479  1.00 37.26           C  
ATOM    108  CG  HIS    43       7.670  18.420   6.591  1.00 38.69           C  
ATOM    109  ND1 HIS    43       8.613  19.272   7.130  1.00 40.26           N  
ATOM    110  CD2 HIS    43       8.341  17.288   6.266  1.00 39.87           C  
ATOM    111  CE1 HIS    43       9.802  18.692   7.106  1.00 39.55           C  
ATOM    112  NE2 HIS    43       9.663  17.483   6.595  1.00 38.90           N  
ATOM    113  N   SER    44       3.126  18.615   6.257  1.00 34.74           N  
ATOM    114  CA  SER    44       1.788  19.203   6.325  1.00 34.39           C  
ATOM    115  C   SER    44       0.743  18.397   7.093  1.00 33.88           C  
ATOM    116  O   SER    44      -0.125  18.968   7.767  1.00 33.16           O  
ATOM    117  CB  SER    44       1.270  19.419   4.904  1.00 35.00           C  
ATOM    118  OG  SER    44       2.093  20.322   4.212  1.00 35.16           O  
ATOM    119  N   PHE    45       0.811  17.070   6.958  1.00 32.94           N  
ATOM    120  CA  PHE    45      -0.109  16.147   7.632  1.00 31.66           C  
ATOM    121  C   PHE    45       0.177  16.082   9.140  1.00 31.61           C  
ATOM    122  O   PHE    45      -0.750  16.119   9.963  1.00 30.31           O  
ATOM    123  CB  PHE    45       0.002  14.770   6.952  1.00 31.68           C  
ATOM    124  CG  PHE    45      -1.033  13.783   7.354  1.00 31.49           C  
ATOM    125  CD1 PHE    45      -2.238  14.163   7.952  1.00 32.31           C  
ATOM    126  CD2 PHE    45      -0.843  12.442   7.054  1.00 32.43           C  
ATOM    127  CE1 PHE    45      -3.200  13.211   8.299  1.00 32.72           C  
ATOM    128  CE2 PHE    45      -1.813  11.488   7.375  1.00 31.99           C  
ATOM    129  CZ  PHE    45      -2.991  11.877   8.005  1.00 32.00           C  
ATOM    130  N   ILE    46       1.458  15.962   9.493  1.00 30.96           N  
ATOM    131  CA  ILE    46       1.905  16.018  10.883  1.00 30.52           C  
ATOM    132  C   ILE    46       1.479  17.353  11.545  1.00 31.33           C  
ATOM    133  O   ILE    46       0.934  17.352  12.654  1.00 30.46           O  
ATOM    134  CB  ILE    46       3.453  15.778  10.976  1.00 30.24           C  
ATOM    135  CG1 ILE    46       3.761  14.284  10.784  1.00 29.75           C  
ATOM    136  CG2 ILE    46       4.049  16.323  12.284  1.00 28.54           C  
ATOM    137  CD1 ILE    46       5.233  14.026  10.605  1.00 30.42           C  
ATOM    138  N   ASP    47       1.700  18.483  10.874  1.00 32.29           N  
ATOM    139  CA  ASP    47       1.259  19.775  11.432  1.00 33.40           C  
ATOM    140  C   ASP    47      -0.249  19.769  11.718  1.00 34.76           C  
ATOM    141  O   ASP    47      -0.711  20.336  12.700  1.00 35.50           O  
ATOM    142  CB  ASP    47       1.567  20.954  10.495  1.00 33.10           C  
ATOM    143  CG  ASP    47       3.051  21.253  10.364  1.00 33.77           C  
ATOM    144  OD1 ASP    47       3.838  20.610  11.062  1.00 32.98           O  
ATOM    145  OD2 ASP    47       3.431  22.151   9.555  1.00 33.38           O  
ATOM    146  N   ARG    48      -1.011  19.137  10.842  1.00 36.67           N  
ATOM    147  CA  ARG    48      -2.471  19.075  10.991  1.00 38.26           C  
ATOM    148  C   ARG    48      -2.949  18.137  12.107  1.00 36.84           C  
ATOM    149  O   ARG    48      -3.879  18.476  12.833  1.00 36.39           O  
ATOM    150  CB  ARG    48      -3.131  18.760   9.638  1.00 38.90           C  
ATOM    151  CG  ARG    48      -3.001  19.956   8.648  1.00 40.27           C  
ATOM    152  CD  ARG    48      -3.502  19.648   7.238  1.00 41.33           C  
ATOM    153  NE  ARG    48      -3.830  20.897   6.526  1.00 42.67           N  
ATOM    154  CZ  ARG    48      -3.237  21.394   5.429  1.00 43.11           C  
ATOM    155  NH1 ARG    48      -2.255  20.752   4.765  1.00 43.47           N  
ATOM    156  NH2 ARG    48      -3.677  22.555   4.947  1.00 42.85           N  
ATOM    157  N   CYS    49      -2.312  16.978  12.247  1.00 35.74           N  
ATOM    158  CA  CYS    49      -2.692  16.011  13.265  0.50 35.05           C  
ATOM    160  C   CYS    49      -2.218  16.408  14.677  1.00 34.67           C  
ATOM    161  O   CYS    49      -2.892  16.146  15.648  1.00 34.22           O  
ATOM    162  CB  CYS    49      -2.126  14.645  12.891  0.50 34.91           C  
ATOM    164  SG  CYS    49      -2.601  13.326  14.001  0.50 35.32           S  
ATOM    166  N   TYR    50      -1.063  17.058  14.775  1.00 35.09           N  
ATOM    167  CA  TYR    50      -0.494  17.396  16.080  1.00 33.36           C  
ATOM    168  C   TYR    50      -0.430  18.881  16.384  1.00 33.94           C  
ATOM    169  O   TYR    50       0.615  19.402  16.813  1.00 32.29           O  
ATOM    170  CB  TYR    50       0.873  16.729  16.193  1.00 30.87           C  
ATOM    171  CG  TYR    50       0.785  15.191  16.130  1.00 30.70           C  
ATOM    172  CD1 TYR    50       0.368  14.444  17.224  1.00 29.65           C  
ATOM    173  CD2 TYR    50       1.122  14.505  14.979  1.00 29.84           C  
ATOM    174  CE1 TYR    50       0.300  13.036  17.160  1.00 30.64           C  
ATOM    175  CE2 TYR    50       1.067  13.125  14.914  1.00 30.22           C  
ATOM    176  CZ  TYR    50       0.657  12.387  16.003  1.00 30.31           C  
ATOM    177  OH  TYR    50       0.616  11.003  15.910  1.00 30.32           O  
ATOM    178  N   THR    51      -1.587  19.532  16.227  1.00 34.38           N  
ATOM    179  CA  THR    51      -1.742  20.985  16.448  1.00 35.46           C  
ATOM    180  C   THR    51      -1.497  21.472  17.885  1.00 35.45           C  
ATOM    181  O   THR    51      -0.948  22.564  18.068  1.00 35.69           O  
ATOM    182  CB  THR    51      -3.129  21.474  15.967  1.00 36.40           C  
ATOM    183  OG1 THR    51      -4.121  20.496  16.344  1.00 36.73           O  
ATOM    184  CG2 THR    51      -3.136  21.638  14.446  1.00 36.23           C  
ATOM    185  N   GLU    52      -1.910  20.685  18.886  1.00 35.22           N  
ATOM    186  CA  GLU    52      -1.650  21.027  20.297  1.00 35.46           C  
ATOM    187  C   GLU    52      -0.168  20.764  20.634  1.00 33.96           C  
ATOM    188  O   GLU    52       0.519  21.638  21.119  1.00 33.70           O  
ATOM    189  CB  GLU    52      -2.557  20.253  21.259  1.00 36.10           C  
ATOM    190  CG  GLU    52      -4.049  20.464  21.051  1.00 37.71           C  
ATOM    191  CD  GLU    52      -4.491  21.909  21.293  1.00 39.84           C  
ATOM    192  OE1 GLU    52      -3.813  22.624  22.080  1.00 39.57           O  
ATOM    193  OE2 GLU    52      -5.533  22.317  20.703  1.00 41.37           O  
ATOM    194  N   THR    53       0.314  19.561  20.359  1.00 33.44           N  
ATOM    195  CA  THR    53       1.717  19.215  20.623  1.00 33.65           C  
ATOM    196  C   THR    53       2.652  20.270  20.032  1.00 35.50           C  
ATOM    197  O   THR    53       3.551  20.752  20.716  1.00 36.21           O  
ATOM    198  CB  THR    53       2.055  17.799  20.061  1.00 32.37           C  
ATOM    199  OG1 THR    53       1.103  16.860  20.555  1.00 28.94           O  
ATOM    200  CG2 THR    53       3.457  17.348  20.430  1.00 31.86           C  
ATOM    201  N   ARG    54       2.399  20.661  18.779  1.00 37.65           N  
ATOM    202  CA  ARG    54       3.207  21.652  18.062  1.00 38.57           C  
ATOM    203  C   ARG    54       3.445  22.944  18.847  1.00 39.99           C  
ATOM    204  O   ARG    54       4.480  23.581  18.707  1.00 38.14           O  
ATOM    205  N   GLN    55       2.475  23.311  19.677  1.00 41.69           N  
ATOM    206  CA  GLN    55       2.568  24.516  20.510  1.00 42.42           C  
ATOM    207  C   GLN    55       3.557  24.436  21.671  1.00 41.81           C  
ATOM    208  O   GLN    55       3.893  25.458  22.249  1.00 42.84           O  
ATOM    209  CB  GLN    55       1.183  24.930  21.012  1.00 42.92           C  
ATOM    210  CG  GLN    55       0.360  25.547  19.897  1.00 43.71           C  
ATOM    211  CD  GLN    55      -1.083  25.734  20.269  1.00 43.68           C  
ATOM    212  OE1 GLN    55      -1.779  24.780  20.626  1.00 44.23           O  
ATOM    213  NE2 GLN    55      -1.560  26.971  20.157  1.00 44.84           N  
ATOM    214  N   TYR    56       4.044  23.246  22.001  1.00 40.40           N  
ATOM    215  CA  TYR    56       5.030  23.112  23.077  1.00 39.48           C  
ATOM    216  C   TYR    56       6.439  23.213  22.534  1.00 38.45           C  
ATOM    217  O   TYR    56       7.402  23.108  23.278  1.00 37.75           O  
ATOM    218  CB  TYR    56       4.824  21.797  23.847  1.00 39.65           C  
ATOM    219  CG  TYR    56       3.604  21.840  24.727  1.00 39.51           C  
ATOM    220  CD1 TYR    56       2.355  21.497  24.231  1.00 39.63           C  
ATOM    221  CD2 TYR    56       3.696  22.253  26.052  1.00 39.81           C  
ATOM    222  CE1 TYR    56       1.227  21.541  25.030  1.00 40.29           C  
ATOM    223  CE2 TYR    56       2.564  22.307  26.874  1.00 39.69           C  
ATOM    224  CZ  TYR    56       1.339  21.957  26.356  1.00 39.71           C  
ATOM    225  OH  TYR    56       0.225  22.012  27.144  1.00 40.05           O  
ATOM    226  N   PHE    57       6.555  23.413  21.225  1.00 38.66           N  
ATOM    227  CA  PHE    57       7.840  23.551  20.595  1.00 38.68           C  
ATOM    228  C   PHE    57       7.989  24.877  19.837  1.00 39.20           C  
ATOM    229  O   PHE    57       7.023  25.580  19.531  1.00 38.81           O  
ATOM    230  CB  PHE    57       8.104  22.384  19.641  1.00 38.40           C  
ATOM    231  CG  PHE    57       8.050  21.042  20.301  1.00 38.59           C  
ATOM    232  CD1 PHE    57       9.195  20.487  20.870  1.00 38.43           C  
ATOM    233  CD2 PHE    57       6.868  20.320  20.343  1.00 38.43           C  
ATOM    234  CE1 PHE    57       9.148  19.242  21.488  1.00 38.66           C  
ATOM    235  CE2 PHE    57       6.822  19.067  20.963  1.00 38.81           C  
ATOM    236  CZ  PHE    57       7.960  18.530  21.526  1.00 38.33           C  
ATOM    237  N   ASP    58       9.249  25.178  19.569  1.00 39.49           N  
ATOM    238  CA  ASP    58       9.687  26.319  18.807  1.00 40.80           C  
ATOM    239  C   ASP    58       9.550  25.947  17.313  1.00 40.39           C  
ATOM    240  O   ASP    58       9.426  24.771  16.978  1.00 40.16           O  
ATOM    241  CB  ASP    58      11.164  26.534  19.150  1.00 41.80           C  
ATOM    242  CG  ASP    58      11.700  27.811  18.641  1.00 43.01           C  
ATOM    243  OD1 ASP    58      11.321  28.852  19.212  1.00 44.51           O  
ATOM    244  OD2 ASP    58      12.537  27.773  17.706  1.00 44.59           O  
ATOM    245  N   SER    59       9.598  26.939  16.423  1.00 40.58           N  
ATOM    246  CA  SER    59       9.544  26.696  14.972  1.00 40.21           C  
ATOM    247  C   SER    59      10.682  25.764  14.572  1.00 39.44           C  
ATOM    248  O   SER    59      10.452  24.739  13.919  1.00 38.38           O  
ATOM    249  CB  SER    59       9.709  28.003  14.200  1.00 40.59           C  
ATOM    250  OG  SER    59       9.024  29.054  14.842  1.00 41.19           O  
ATOM    251  N   LYS    60      11.898  26.117  15.007  1.00 39.20           N  
ATOM    252  CA  LYS    60      13.120  25.345  14.703  1.00 38.68           C  
ATOM    253  C   LYS    60      13.118  23.946  15.315  1.00 37.27           C  
ATOM    254  O   LYS    60      13.531  22.993  14.667  1.00 36.60           O  
ATOM    255  CB  LYS    60      14.383  26.099  15.151  1.00 39.13           C  
ATOM    256  CG  LYS    60      14.720  27.325  14.305  1.00 40.06           C  
ATOM    257  N   GLU    61      12.669  23.840  16.560  1.00 36.56           N  
ATOM    258  CA  GLU    61      12.586  22.563  17.268  1.00 37.10           C  
ATOM    259  C   GLU    61      11.598  21.610  16.586  1.00 36.59           C  
ATOM    260  O   GLU    61      11.863  20.415  16.428  1.00 36.60           O  
ATOM    261  CB  GLU    61      12.118  22.786  18.718  1.00 37.52           C  
ATOM    262  CG  GLU    61      13.033  23.614  19.614  1.00 38.05           C  
ATOM    263  CD  GLU    61      12.376  24.015  20.948  1.00 38.16           C  
ATOM    264  OE1 GLU    61      11.137  23.965  21.074  1.00 38.70           O  
ATOM    265  OE2 GLU    61      13.100  24.403  21.875  1.00 39.54           O  
ATOM    266  N   TRP    62      10.433  22.147  16.229  1.00 36.46           N  
ATOM    267  CA  TRP    62       9.401  21.386  15.547  1.00 36.63           C  
ATOM    268  C   TRP    62       9.892  20.915  14.161  1.00 36.33           C  
ATOM    269  O   TRP    62       9.733  19.743  13.817  1.00 35.34           O  
ATOM    270  CB  TRP    62       8.111  22.213  15.453  1.00 37.24           C  
ATOM    271  CG  TRP    62       6.932  21.469  14.891  1.00 37.24           C  
ATOM    272  CD1 TRP    62       6.334  21.691  13.702  1.00 37.51           C  
ATOM    273  CD2 TRP    62       6.219  20.376  15.506  1.00 37.80           C  
ATOM    274  NE1 TRP    62       5.285  20.818  13.525  1.00 37.79           N  
ATOM    275  CE2 TRP    62       5.194  19.995  14.614  1.00 37.74           C  
ATOM    276  CE3 TRP    62       6.352  19.683  16.720  1.00 37.51           C  
ATOM    277  CZ2 TRP    62       4.303  18.950  14.888  1.00 37.23           C  
ATOM    278  CZ3 TRP    62       5.479  18.647  16.992  1.00 37.58           C  
ATOM    279  CH2 TRP    62       4.459  18.288  16.076  1.00 37.52           C  
ATOM    280  N   SER    63      10.493  21.804  13.376  1.00 36.51           N  
ATOM    281  CA  SER    63      11.074  21.408  12.076  1.00 37.30           C  
ATOM    282  C   SER    63      12.163  20.307  12.223  1.00 37.53           C  
ATOM    283  O   SER    63      12.237  19.371  11.411  1.00 37.00           O  
ATOM    284  CB  SER    63      11.694  22.614  11.373  1.00 38.30           C  
ATOM    285  OG  SER    63      10.782  23.692  11.249  1.00 38.42           O  
ATOM    286  N   ARG    64      13.007  20.424  13.251  1.00 37.53           N  
ATOM    287  CA  ARG    64      14.038  19.412  13.517  1.00 37.52           C  
ATOM    288  C   ARG    64      13.444  18.039  13.756  1.00 37.48           C  
ATOM    289  O   ARG    64      13.940  17.056  13.228  1.00 37.42           O  
ATOM    290  CB  ARG    64      14.865  19.779  14.736  1.00 38.25           C  
ATOM    291  CG  ARG    64      15.668  21.020  14.585  1.00 38.50           C  
ATOM    292  CD  ARG    64      16.597  21.216  15.768  1.00 38.90           C  
ATOM    293  NE  ARG    64      17.124  22.568  15.726  1.00 39.25           N  
ATOM    294  CZ  ARG    64      16.975  23.495  16.661  1.00 39.76           C  
ATOM    295  NH1 ARG    64      16.388  23.227  17.826  1.00 40.58           N  
ATOM    296  NH2 ARG    64      17.496  24.698  16.449  1.00 40.34           N  
ATOM    297  N   LEU    65      12.396  17.969  14.584  1.00 38.01           N  
ATOM    298  CA  LEU    65      11.692  16.704  14.829  1.00 37.24           C  
ATOM    299  C   LEU    65      11.258  16.049  13.538  1.00 36.38           C  
ATOM    300  O   LEU    65      11.483  14.868  13.335  1.00 35.33           O  
ATOM    301  CB  LEU    65      10.460  16.895  15.732  1.00 37.31           C  
ATOM    302  CG  LEU    65      10.599  16.691  17.233  1.00 37.54           C  
ATOM    303  CD1 LEU    65       9.326  17.170  17.945  1.00 37.07           C  
ATOM    304  CD2 LEU    65      10.877  15.205  17.515  1.00 37.77           C  
ATOM    305  N   LYS    66      10.624  16.843  12.680  1.00 37.70           N  
ATOM    306  CA  LYS    66      10.108  16.406  11.382  1.00 37.64           C  
ATOM    307  C   LYS    66      11.188  16.018  10.374  1.00 38.01           C  
ATOM    308  O   LYS    66      10.989  15.080   9.570  1.00 37.34           O  
ATOM    309  CB  LYS    66       9.358  17.543  10.731  1.00 38.09           C  
ATOM    310  CG  LYS    66       7.972  17.860  11.209  1.00 39.27           C  
ATOM    311  CD  LYS    66       7.732  19.208  10.593  1.00 39.88           C  
ATOM    312  CE  LYS    66       6.376  19.665  10.584  1.00 40.20           C  
ATOM    313  NZ  LYS    66       6.469  21.084  10.090  1.00 40.11           N  
ATOM    314  N   GLU    67      12.273  16.793  10.341  1.00 37.69           N  
ATOM    315  CA  GLU    67      13.385  16.486   9.438  1.00 38.36           C  
ATOM    316  C   GLU    67      13.988  15.146   9.831  1.00 37.23           C  
ATOM    317  O   GLU    67      14.392  14.383   8.975  1.00 38.39           O  
ATOM    318  CB  GLU    67      14.461  17.582   9.439  1.00 40.22           C  
ATOM    319  CG  GLU    67      14.046  18.891   8.735  1.00 42.62           C  
ATOM    320  CD  GLU    67      13.709  18.696   7.245  1.00 44.55           C  
ATOM    321  OE1 GLU    67      14.081  17.641   6.674  1.00 45.14           O  
ATOM    322  OE2 GLU    67      13.063  19.598   6.648  1.00 45.94           O  
ATOM    323  N   GLY    68      14.034  14.860  11.128  1.00 36.08           N  
ATOM    324  CA  GLY    68      14.533  13.589  11.606  1.00 34.73           C  
ATOM    325  C   GLY    68      13.596  12.474  11.209  1.00 34.19           C  
ATOM    326  O   GLY    68      14.033  11.445  10.724  1.00 35.37           O  
ATOM    327  N   PHE    69      12.293  12.660  11.404  1.00 34.14           N  
ATOM    328  CA  PHE    69      11.337  11.622  11.016  1.00 32.94           C  
ATOM    329  C   PHE    69      11.440  11.264   9.516  1.00 33.21           C  
ATOM    330  O   PHE    69      11.539  10.090   9.139  1.00 33.26           O  
ATOM    331  CB  PHE    69       9.895  12.022  11.386  1.00 31.51           C  
ATOM    332  CG  PHE    69       8.870  11.040  10.920  1.00 30.14           C  
ATOM    333  CD1 PHE    69       8.871   9.741  11.402  1.00 30.28           C  
ATOM    334  CD2 PHE    69       7.921  11.398   9.993  1.00 31.00           C  
ATOM    335  CE1 PHE    69       7.939   8.802  10.963  1.00 29.64           C  
ATOM    336  CE2 PHE    69       6.975  10.480   9.560  1.00 30.27           C  
ATOM    337  CZ  PHE    69       6.984   9.174  10.049  1.00 30.55           C  
ATOM    338  N   VAL    70      11.447  12.287   8.678  1.00 34.13           N  
ATOM    339  CA  VAL    70      11.508  12.140   7.223  1.00 35.69           C  
ATOM    340  C   VAL    70      12.739  11.371   6.690  1.00 37.01           C  
ATOM    341  O   VAL    70      12.674  10.692   5.633  1.00 36.42           O  
ATOM    342  CB  VAL    70      11.400  13.534   6.590  1.00 36.04           C  
ATOM    343  CG1 VAL    70      12.194  13.615   5.360  1.00 37.99           C  
ATOM    344  CG2 VAL    70       9.930  13.898   6.375  1.00 36.51           C  
ATOM    345  N   ARG    71      13.834  11.481   7.445  1.00 38.47           N  
ATOM    346  CA  ARG    71      15.089  10.810   7.164  1.00 39.55           C  
ATOM    347  C   ARG    71      15.125   9.421   7.825  1.00 40.19           C  
ATOM    348  O   ARG    71      16.049   8.645   7.584  1.00 41.19           O  
ATOM    349  CB  ARG    71      16.255  11.677   7.654  1.00 39.14           C  
ATOM    350  CG  ARG    71      16.354  13.038   6.934  1.00 39.56           C  
ATOM    351  CD  ARG    71      17.481  13.925   7.506  1.00 39.89           C  
ATOM    352  N   ASP    72      14.121   9.108   8.644  1.00 39.78           N  
ATOM    353  CA  ASP    72      14.038   7.814   9.335  1.00 39.54           C  
ATOM    354  C   ASP    72      13.268   6.793   8.485  1.00 39.00           C  
ATOM    355  O   ASP    72      12.421   7.170   7.701  1.00 38.39           O  
ATOM    356  CB  ASP    72      13.311   7.978  10.674  1.00 39.70           C  
ATOM    357  CG  ASP    72      13.405   6.751  11.544  1.00 39.57           C  
ATOM    358  OD1 ASP    72      14.490   6.519  12.112  1.00 41.05           O  
ATOM    359  OD2 ASP    72      12.394   6.044  11.691  1.00 38.99           O  
ATOM    360  N   ALA    73      13.565   5.506   8.700  1.00 39.88           N  
ATOM    361  CA  ALA    73      12.956   4.358   8.012  1.00 39.58           C  
ATOM    362  C   ALA    73      11.435   4.259   8.161  1.00 40.30           C  
ATOM    363  O   ALA    73      10.778   3.676   7.299  1.00 40.44           O  
ATOM    364  CB  ALA    73      13.602   3.052   8.497  1.00 38.45           C  
ATOM    365  N   ARG    74      10.887   4.785   9.258  1.00 41.15           N  
ATOM    366  CA  ARG    74       9.435   4.766   9.482  1.00 42.13           C  
ATOM    367  C   ARG    74       8.662   5.661   8.471  1.00 42.62           C  
ATOM    368  O   ARG    74       7.507   5.372   8.134  1.00 43.50           O  
ATOM    369  CB  ARG    74       9.093   5.167  10.927  1.00 42.17           C  
ATOM    370  CG  ARG    74       9.608   4.220  12.028  1.00 42.15           C  
ATOM    371  CD  ARG    74       9.162   4.710  13.414  1.00 42.78           C  
ATOM    372  NE  ARG    74       9.772   3.984  14.530  1.00 42.91           N  
ATOM    373  CZ  ARG    74      10.943   4.291  15.103  1.00 44.13           C  
ATOM    374  NH1 ARG    74      11.666   5.334  14.687  1.00 44.51           N  
ATOM    375  NH2 ARG    74      11.405   3.554  16.116  1.00 43.91           N  
ATOM    376  N   ALA    75       9.310   6.718   7.980  1.00 41.86           N  
ATOM    377  CA  ALA    75       8.706   7.632   7.020  1.00 41.40           C  
ATOM    378  C   ALA    75       8.813   7.115   5.574  1.00 41.62           C  
ATOM    379  O   ALA    75       8.490   7.834   4.645  1.00 41.03           O  
ATOM    380  CB  ALA    75       9.360   9.012   7.138  1.00 40.41           C  
ATOM    381  N   GLN    76       9.271   5.876   5.385  1.00 42.77           N  
ATOM    382  CA  GLN    76       9.394   5.270   4.046  1.00 43.01           C  
ATOM    383  C   GLN    76       8.172   4.430   3.693  1.00 41.84           C  
ATOM    384  O   GLN    76       8.153   3.750   2.677  1.00 41.81           O  
ATOM    385  CB  GLN    76      10.652   4.409   3.945  1.00 44.92           C  
ATOM    386  CG  GLN    76      11.922   5.115   4.407  1.00 46.84           C  
ATOM    387  CD  GLN    76      12.140   6.436   3.696  1.00 48.40           C  
ATOM    388  OE1 GLN    76      12.086   6.495   2.461  1.00 49.56           O  
ATOM    389  NE2 GLN    76      12.381   7.515   4.474  1.00 49.14           N  
ATOM    390  N   THR    77       7.147   4.478   4.533  1.00 40.41           N  
ATOM    391  CA  THR    77       5.914   3.745   4.263  1.00 39.71           C  
ATOM    392  C   THR    77       5.239   4.216   2.958  1.00 38.93           C  
ATOM    393  O   THR    77       5.185   5.422   2.674  1.00 39.12           O  
ATOM    394  CB  THR    77       4.882   3.875   5.431  1.00 39.07           C  
ATOM    395  OG1 THR    77       3.739   3.054   5.155  1.00 39.10           O  
ATOM    396  CG2 THR    77       4.428   5.356   5.650  1.00 38.80           C  
ATOM    397  N   PRO    78       4.757   3.259   2.143  1.00 38.60           N  
ATOM    398  CA  PRO    78       3.988   3.592   0.943  1.00 38.17           C  
ATOM    399  C   PRO    78       2.529   3.983   1.249  1.00 37.52           C  
ATOM    400  O   PRO    78       1.790   4.348   0.333  1.00 38.19           O  
ATOM    401  CB  PRO    78       4.035   2.299   0.143  1.00 38.03           C  
ATOM    402  CG  PRO    78       4.108   1.239   1.173  1.00 38.06           C  
ATOM    403  CD  PRO    78       4.953   1.802   2.274  1.00 38.18           C  
ATOM    404  N   TYR    79       2.117   3.909   2.512  1.00 37.30           N  
ATOM    405  CA  TYR    79       0.752   4.277   2.903  1.00 37.06           C  
ATOM    406  C   TYR    79       0.729   5.606   3.677  1.00 36.81           C  
ATOM    407  O   TYR    79       1.125   5.674   4.855  1.00 36.57           O  
ATOM    408  CB  TYR    79       0.107   3.170   3.732  1.00 37.18           C  
ATOM    409  CG  TYR    79       0.142   1.806   3.102  1.00 37.01           C  
ATOM    410  CD1 TYR    79      -0.799   1.433   2.159  1.00 37.18           C  
ATOM    411  CD2 TYR    79       1.108   0.873   3.473  1.00 37.97           C  
ATOM    412  CE1 TYR    79      -0.780   0.177   1.580  1.00 37.29           C  
ATOM    413  CE2 TYR    79       1.152  -0.395   2.884  1.00 37.76           C  
ATOM    414  CZ  TYR    79       0.196  -0.734   1.936  1.00 37.33           C  
ATOM    415  OH  TYR    79       0.210  -1.985   1.357  1.00 37.49           O  
ATOM    416  N   PHE    80       0.259   6.658   3.013  1.00 36.23           N  
ATOM    417  CA  PHE    80       0.154   7.999   3.603  1.00 37.21           C  
ATOM    418  C   PHE    80      -0.652   8.032   4.925  1.00 37.56           C  
ATOM    419  O   PHE    80      -0.373   8.865   5.779  1.00 37.45           O  
ATOM    420  CB  PHE    80      -0.451   8.953   2.561  1.00 35.97           C  
ATOM    421  CG  PHE    80      -0.577  10.387   3.018  1.00 35.89           C  
ATOM    422  CD1 PHE    80       0.526  11.231   3.016  1.00 35.13           C  
ATOM    423  CD2 PHE    80      -1.816  10.909   3.378  1.00 35.63           C  
ATOM    424  CE1 PHE    80       0.413  12.549   3.420  1.00 35.29           C  
ATOM    425  CE2 PHE    80      -1.941  12.238   3.780  1.00 35.65           C  
ATOM    426  CZ  PHE    80      -0.830  13.053   3.811  1.00 35.28           C  
ATOM    427  N   GLN    81      -1.641   7.136   5.068  1.00 39.01           N  
ATOM    428  CA  GLN    81      -2.531   7.009   6.266  1.00 39.99           C  
ATOM    429  C   GLN    81      -1.786   6.615   7.537  1.00 38.96           C  
ATOM    430  O   GLN    81      -2.204   6.938   8.667  1.00 37.94           O  
ATOM    431  CB  GLN    81      -3.658   5.969   6.004  1.00 41.53           C  
ATOM    432  CG  GLN    81      -3.152   4.521   5.724  1.00 43.63           C  
ATOM    433  CD  GLN    81      -4.045   3.686   4.773  1.00 44.28           C  
ATOM    434  OE1 GLN    81      -5.212   4.017   4.516  1.00 47.08           O  
ATOM    435  NE2 GLN    81      -3.480   2.592   4.251  1.00 45.82           N  
ATOM    436  N   GLU    82      -0.680   5.915   7.329  1.00 38.65           N  
ATOM    437  CA  GLU    82       0.175   5.459   8.401  1.00 38.49           C  
ATOM    438  C   GLU    82       1.183   6.493   8.904  1.00 37.28           C  
ATOM    439  O   GLU    82       1.880   6.211   9.861  1.00 37.02           O  
ATOM    440  CB  GLU    82       0.955   4.227   7.947  1.00 39.32           C  
ATOM    441  CG  GLU    82       0.111   3.044   7.580  1.00 40.06           C  
ATOM    442  CD  GLU    82       0.953   1.809   7.314  1.00 40.94           C  
ATOM    443  OE1 GLU    82       2.185   1.935   7.108  1.00 41.22           O  
ATOM    444  OE2 GLU    82       0.378   0.703   7.283  1.00 43.20           O  
ATOM    445  N   ILE    83       1.259   7.670   8.283  1.00 35.69           N  
ATOM    446  CA  ILE    83       2.240   8.696   8.679  1.00 34.80           C  
ATOM    447  C   ILE    83       2.067   9.259  10.105  1.00 34.57           C  
ATOM    448  O   ILE    83       3.036   9.266  10.849  1.00 36.43           O  
ATOM    449  CB  ILE    83       2.391   9.820   7.602  1.00 34.27           C  
ATOM    450  CG1 ILE    83       3.203   9.303   6.400  1.00 34.23           C  
ATOM    451  CG2 ILE    83       3.082  11.078   8.160  1.00 34.12           C  
ATOM    452  CD1 ILE    83       4.670   8.861   6.701  1.00 32.92           C  
ATOM    453  N   PRO    84       0.872   9.759  10.490  1.00 34.29           N  
ATOM    454  CA  PRO    84       0.691  10.257  11.858  1.00 34.05           C  
ATOM    455  C   PRO    84       1.080   9.271  12.960  1.00 32.73           C  
ATOM    456  O   PRO    84       1.689   9.668  13.927  1.00 32.82           O  
ATOM    457  CB  PRO    84      -0.802  10.568  11.910  1.00 34.36           C  
ATOM    458  CG  PRO    84      -1.102  10.935  10.545  1.00 34.73           C  
ATOM    459  CD  PRO    84      -0.364   9.955   9.716  1.00 34.31           C  
ATOM    460  N   GLY    85       0.731   8.000  12.794  1.00 31.91           N  
ATOM    461  CA  GLY    85       1.096   6.963  13.738  1.00 31.63           C  
ATOM    462  C   GLY    85       2.567   6.599  13.760  1.00 31.41           C  
ATOM    463  O   GLY    85       3.090   6.201  14.810  1.00 33.41           O  
ATOM    464  N   GLU    86       3.229   6.663  12.607  1.00 29.25           N  
ATOM    465  CA  GLU    86       4.634   6.386  12.557  1.00 29.44           C  
ATOM    466  C   GLU    86       5.421   7.534  13.169  1.00 28.21           C  
ATOM    467  O   GLU    86       6.460   7.279  13.754  1.00 28.92           O  
ATOM    468  CB  GLU    86       5.115   6.080  11.127  1.00 30.78           C  
ATOM    469  CG  GLU    86       4.656   4.727  10.559  1.00 32.94           C  
ATOM    470  CD  GLU    86       5.365   3.520  11.181  1.00 34.78           C  
ATOM    471  OE1 GLU    86       6.231   3.694  12.045  1.00 37.21           O  
ATOM    472  OE2 GLU    86       5.060   2.375  10.804  1.00 36.77           O  
ATOM    473  N   PHE    87       4.964   8.783  13.001  1.00 26.80           N  
ATOM    474  CA  PHE    87       5.616   9.924  13.634  1.00 28.21           C  
ATOM    475  C   PHE    87       5.514   9.804  15.163  1.00 29.41           C  
ATOM    476  O   PHE    87       6.454  10.162  15.871  1.00 31.23           O  
ATOM    477  CB  PHE    87       5.013  11.261  13.143  1.00 28.09           C  
ATOM    478  CG  PHE    87       5.670  12.514  13.751  1.00 27.89           C  
ATOM    479  CD1 PHE    87       7.031  12.754  13.595  1.00 27.99           C  
ATOM    480  CD2 PHE    87       4.911  13.470  14.400  1.00 28.57           C  
ATOM    481  CE1 PHE    87       7.618  13.916  14.106  1.00 28.10           C  
ATOM    482  CE2 PHE    87       5.483  14.639  14.922  1.00 28.19           C  
ATOM    483  CZ  PHE    87       6.842  14.860  14.779  1.00 28.07           C  
ATOM    484  N   LEU    88       4.378   9.324  15.677  1.00 30.36           N  
ATOM    485  CA  LEU    88       4.220   9.109  17.121  1.00 30.46           C  
ATOM    486  C   LEU    88       5.224   8.069  17.637  1.00 31.42           C  
ATOM    487  O   LEU    88       5.833   8.271  18.698  1.00 29.42           O  
ATOM    488  CB  LEU    88       2.784   8.666  17.467  1.00 31.13           C  
ATOM    489  CG  LEU    88       2.412   8.532  18.953  1.00 31.21           C  
ATOM    490  CD1 LEU    88       2.684   9.812  19.710  1.00 31.01           C  
ATOM    491  CD2 LEU    88       0.929   8.096  19.140  1.00 31.40           C  
ATOM    492  N   GLN    89       5.393   6.967  16.901  1.00 31.85           N  
ATOM    493  CA  GLN    89       6.357   5.947  17.298  1.00 34.37           C  
ATOM    494  C   GLN    89       7.800   6.468  17.155  1.00 34.03           C  
ATOM    495  O   GLN    89       8.666   6.108  17.933  1.00 33.46           O  
ATOM    496  CB  GLN    89       6.174   4.666  16.492  1.00 35.02           C  
ATOM    497  CG  GLN    89       4.813   4.027  16.684  1.00 36.73           C  
ATOM    498  CD  GLN    89       4.686   2.702  15.951  1.00 37.09           C  
ATOM    499  OE1 GLN    89       5.443   1.746  16.201  1.00 39.15           O  
ATOM    500  NE2 GLN    89       3.731   2.636  15.038  1.00 37.94           N  
ATOM    501  N   TYR    90       8.059   7.302  16.157  1.00 34.20           N  
ATOM    502  CA  TYR    90       9.378   7.913  16.030  1.00 34.41           C  
ATOM    503  C   TYR    90       9.673   8.721  17.304  1.00 34.93           C  
ATOM    504  O   TYR    90      10.740   8.585  17.911  1.00 35.59           O  
ATOM    505  CB  TYR    90       9.465   8.805  14.774  1.00 33.05           C  
ATOM    506  CG  TYR    90      10.776   9.585  14.662  1.00 32.56           C  
ATOM    507  CD1 TYR    90      11.970   8.946  14.331  1.00 32.25           C  
ATOM    508  CD2 TYR    90      10.807  10.960  14.887  1.00 32.58           C  
ATOM    509  CE1 TYR    90      13.177   9.660  14.260  1.00 32.10           C  
ATOM    510  CE2 TYR    90      11.998  11.683  14.821  1.00 32.58           C  
ATOM    511  CZ  TYR    90      13.168  11.035  14.491  1.00 32.09           C  
ATOM    512  OH  TYR    90      14.313  11.769  14.418  1.00 31.83           O  
ATOM    513  N   CYS    91       8.713   9.563  17.692  1.00 35.16           N  
ATOM    514  CA  CYS    91       8.809  10.402  18.899  1.00 33.78           C  
ATOM    515  C   CYS    91       8.950   9.627  20.216  1.00 34.05           C  
ATOM    516  O   CYS    91       9.608  10.096  21.122  1.00 33.30           O  
ATOM    517  CB  CYS    91       7.607  11.318  18.983  1.00 32.68           C  
ATOM    518  SG  CYS    91       7.605  12.534  17.689  1.00 31.54           S  
ATOM    519  N   GLN    92       8.315   8.458  20.311  1.00 34.20           N  
ATOM    520  CA  GLN    92       8.417   7.606  21.493  1.00 35.03           C  
ATOM    521  C   GLN    92       9.767   6.916  21.576  1.00 34.16           C  
ATOM    522  O   GLN    92      10.193   6.491  22.638  1.00 34.81           O  
ATOM    523  CB  GLN    92       7.304   6.565  21.485  1.00 35.59           C  
ATOM    524  CG  GLN    92       5.914   7.175  21.698  1.00 36.42           C  
ATOM    525  CD  GLN    92       4.751   6.237  21.334  1.00 37.22           C  
ATOM    526  OE1 GLN    92       4.947   5.125  20.847  1.00 36.76           O  
ATOM    527  NE2 GLN    92       3.523   6.717  21.568  1.00 39.66           N  
ATOM    528  N   SER    93      10.454   6.798  20.451  1.00 34.03           N  
ATOM    529  CA  SER    93      11.752   6.163  20.446  1.00 32.81           C  
ATOM    530  C   SER    93      12.870   7.156  20.707  1.00 31.91           C  
ATOM    531  O   SER    93      13.942   6.741  21.110  1.00 30.81           O  
ATOM    532  CB  SER    93      11.999   5.469  19.113  1.00 34.11           C  
ATOM    533  OG  SER    93      12.114   6.403  18.055  1.00 34.71           O  
ATOM    534  N   LEU    94      12.631   8.456  20.479  1.00 31.83           N  
ATOM    535  CA  LEU    94      13.685   9.486  20.653  1.00 31.51           C  
ATOM    536  C   LEU    94      14.342   9.464  22.029  1.00 31.46           C  
ATOM    537  O   LEU    94      15.574   9.451  22.101  1.00 31.87           O  
ATOM    538  CB  LEU    94      13.193  10.902  20.304  1.00 30.79           C  
ATOM    539  CG  LEU    94      13.038  11.228  18.819  1.00 30.95           C  
ATOM    540  CD1 LEU    94      12.328  12.594  18.633  1.00 30.72           C  
ATOM    541  CD2 LEU    94      14.373  11.164  18.090  1.00 30.03           C  
ATOM    542  N   PRO    95      13.545   9.543  23.121  1.00 31.16           N  
ATOM    543  CA  PRO    95      12.104   9.764  23.270  1.00 31.24           C  
ATOM    544  C   PRO    95      11.760  11.193  23.647  1.00 31.96           C  
ATOM    545  O   PRO    95      12.596  11.871  24.235  1.00 33.19           O  
ATOM    546  CB  PRO    95      11.759   8.882  24.457  1.00 30.56           C  
ATOM    547  CG  PRO    95      12.999   8.957  25.346  1.00 30.77           C  
ATOM    548  CD  PRO    95      14.174   9.262  24.431  1.00 31.16           C  
ATOM    549  N   LEU    96      10.552  11.668  23.331  1.00 31.46           N  
ATOM    550  CA  LEU    96      10.156  13.006  23.809  1.00 31.65           C  
ATOM    551  C   LEU    96       9.721  12.819  25.276  1.00 32.28           C  
ATOM    552  O   LEU    96       9.670  11.693  25.757  1.00 32.15           O  
ATOM    553  CB  LEU    96       9.045  13.647  22.957  1.00 29.95           C  
ATOM    554  CG  LEU    96       9.370  13.934  21.476  1.00 29.64           C  
ATOM    555  CD1 LEU    96       8.198  14.615  20.747  1.00 27.64           C  
ATOM    556  CD2 LEU    96      10.677  14.795  21.361  1.00 28.59           C  
END
