
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  266 ( 2127),  selected  266 , name 3ctp_A
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 3ctp_A.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    60_A      Y      71          3.007
LGA    K    61_A      S      72          3.599
LGA    T    62_A      I      73          3.856
LGA    I    63_A      -       -           -
LGA    G    64_A      A      74          2.560
LGA    L    65_A      L      75          2.683
LGA    M    66_A      I      76          2.384
LGA    V    67_A      I      77          2.273
LGA    P    68_A      P      78          2.401
LGA    N    69_A      S      79          1.738
LGA    I    70_A      L      80          2.096
LGA    S    71_A      F      81          1.996
LGA    N    72_A      E      82          2.749
LGA    P    73_A      K      83          3.355
LGA    F    74_A      A      84          3.807
LGA    F    75_A      C      85          2.394
LGA    N    76_A      A      86          0.772
LGA    Q    77_A      H      87          1.108
LGA    M    78_A      F      88          1.564
LGA    A    79_A      L      89          1.474
LGA    S    80_A      P      90          2.064
LGA    V    81_A      S      91          2.406
LGA    I    82_A      F      92          1.808
LGA    E    83_A      Q      93          1.870
LGA    E    84_A      Q      94          2.415
LGA    Y    85_A      A      95          2.284
LGA    A    86_A      L      96          1.836
LGA    K    87_A      N      97          2.293
LGA    N    88_A      K      98          2.965
LGA    K    89_A      A      99          2.263
LGA    G    90_A      G     100          2.057
LGA    Y    91_A      Y     101          2.327
LGA    T    92_A      Q     102          3.369
LGA    L    93_A      L     103          2.623
LGA    F    94_A      L     104          3.620
LGA    L    95_A      L     105          3.908
LGA    C    96_A      G     106          2.416
LGA    N    97_A      Y     107          2.348
LGA    T    98_A      S     108          1.976
LGA    D    99_A      D     109          2.542
LGA    D   100_A      Y     110          1.645
LGA    D   101_A      S     111          2.121
LGA    K   102_A      I     112          2.010
LGA    E   103_A      E     113          2.242
LGA    K   104_A      Q     114          2.669
LGA    E   105_A      E     115          2.134
LGA    K   106_A      E     116          2.191
LGA    T   107_A      K     117          2.709
LGA    Y   108_A      L     118          2.574
LGA    L   109_A      L     119          1.487
LGA    E   110_A      S     120          2.077
LGA    V   111_A      T     121          3.172
LGA    L   112_A      F     122          2.379
LGA    Q   113_A      L     123          1.902
LGA    S   114_A      E     124          3.336
LGA    H   115_A      S     125          3.588
LGA    R   116_A      R     126          2.243
LGA    V   117_A      P     127           #
LGA    A   118_A      A     128          2.693
LGA    G   119_A      G     129          2.394
LGA    I   120_A      V     130          2.025
LGA    I   121_A      V     131          1.799
LGA    A   122_A      L     132          0.902
LGA    S   123_A      F     133          1.273
LGA    R   124_A      G     134          2.465
LGA    S   125_A      S     135          4.602
LGA    Q   126_A      E     136          3.051
LGA    C   127_A      H     137          0.786
LGA    E   128_A      S     138          4.073
LGA    D   129_A      Q     139          1.951
LGA    E   130_A      R     140          2.986
LGA    Y   131_A      T     141          2.847
LGA    A   132_A      H     142          2.364
LGA    N   133_A      Q     143          2.488
LGA    I   134_A      L     144          2.294
LGA    D   135_A      L     145          4.363
LGA    -       -      E     146           -
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    -       -      N     149           -
LGA    I   136_A      T     150          3.412
LGA    P   137_A      P     151          2.248
LGA    V   138_A      V     152          1.524
LGA    V   139_A      L     153          0.333
LGA    A   140_A      E     154          0.522
LGA    F   141_A      I     155          0.840
LGA    E   142_A      A     156          1.690
LGA    N   143_A      E     157           #
LGA    -       -      L     158           -
LGA    H   144_A      S     159          2.962
LGA    I   145_A      S     160          3.041
LGA    L   146_A      K     161          2.093
LGA    D   147_A      A     162          1.901
LGA    N   148_A      S     163          1.895
LGA    I   149_A      Y     164          1.148
LGA    I   150_A      L     165          2.252
LGA    T   151_A      N     166          2.579
LGA    I   152_A      I     167          0.932
LGA    S   153_A      G     168          0.996
LGA    S   154_A      V     169          1.337
LGA    D   155_A      D     170          2.771
LGA    N   156_A      H     171          1.857
LGA    Y   157_A      F     172          2.106
LGA    N   158_A      E     173          1.645
LGA    G   159_A      V     174          1.398
LGA    G   160_A      G     175          1.464
LGA    R   161_A      K     176          1.466
LGA    M   162_A      A     177          0.860
LGA    A   163_A      C     178          0.673
LGA    F   164_A      T     179          0.966
LGA    D   165_A      R     180          0.970
LGA    H   166_A      H     181          0.797
LGA    L   167_A      L     182          0.729
LGA    Y   168_A      I     183          0.681
LGA    E   169_A      E     184          1.825
LGA    K   170_A      Q     185          2.006
LGA    G   171_A      G     186          1.438
LGA    C   172_A      F     187          1.118
LGA    R   173_A      K     188          1.627
LGA    K   174_A      N     189          1.538
LGA    I   175_A      V     190          0.944
LGA    L   176_A      G     191          0.842
LGA    H   177_A      F     192          1.601
LGA    I   178_A      I     193          1.857
LGA    K   179_A      G     194          3.625
LGA    G   180_A      A     195          4.129
LGA    -       -      R     196           -
LGA    P   181_A      G     197          1.206
LGA    E   182_A      N     198          3.817
LGA    V   183_A      H     199          2.750
LGA    F   184_A      S     200          1.795
LGA    E   185_A      T     201          3.939
LGA    A   186_A      -       -           -
LGA    T   187_A      L     202          2.707
LGA    E   188_A      Q     203          2.397
LGA    L   189_A      R     204          2.343
LGA    R   190_A      Q     205          2.151
LGA    Y   191_A      L     206          2.186
LGA    K   192_A      H     207          2.216
LGA    G   193_A      G     208          2.330
LGA    F   194_A      W     209          1.966
LGA    L   195_A      Q     210          1.612
LGA    D   196_A      S     211          1.605
LGA    G   197_A      A     212          1.482
LGA    A   198_A      M     213          1.230
LGA    R   199_A      I     214          1.543
LGA    A   200_A      E     215          1.538
LGA    K   201_A      N     216          0.778
LGA    D   202_A      Y     217          0.501
LGA    L   203_A      L     218          0.390
LGA    E   204_A      T     219          0.742
LGA    I   205_A      P     220          1.861
LGA    D   206_A      D     221          2.780
LGA    -       -      H     222           -
LGA    F   207_A      F     223          1.618
LGA    I   208_A      L     224          1.145
LGA    E   209_A      T     225          1.520
LGA    F   210_A      T     226          1.974
LGA    Q   211_A      H     227          1.073
LGA    H   212_A      E     228          3.074
LGA    D   213_A      A     229          3.429
LGA    F   214_A      P     230          2.963
LGA    Q   215_A      -       -           -
LGA    V   216_A      -       -           -
LGA    K   217_A      -       -           -
LGA    M   218_A      S     231          4.368
LGA    L   219_A      S     232          5.645
LGA    E   220_A      Q     233           #
LGA    E   221_A      L     234           #
LGA    -       -      G     235           -
LGA    D   222_A      A     236           #
LGA    I   223_A      E     237          3.819
LGA    N   224_A      G     238           #
LGA    S   225_A      -       -           -
LGA    M   226_A      L     239          4.851
LGA    K   227_A      A     240          3.001
LGA    D   228_A      K     241          4.497
LGA    I   229_A      L     242          3.398
LGA    V   230_A      L     243          4.657
LGA    -       -      L     244           -
LGA    -       -      R     245           -
LGA    -       -      D     246           -
LGA    N   231_A      S     247          3.306
LGA    -       -      S     248           -
LGA    Y   232_A      L     249          1.904
LGA    D   233_A      N     250          1.005
LGA    G   234_A      A     251          0.898
LGA    I   235_A      L     252          0.888
LGA    F   236_A      V     253          0.806
LGA    V   237_A      C     254          1.285
LGA    F   238_A      S     255          1.544
LGA    N   239_A      H     256          2.432
LGA    D   240_A      E     257          2.209
LGA    I   241_A      E     258          3.313
LGA    A   242_A      I     259          3.289
LGA    A   243_A      A     260          2.568
LGA    A   244_A      I     261          2.867
LGA    T   245_A      G     262          3.713
LGA    V   246_A      A     263          3.668
LGA    M   247_A      L     264          3.452
LGA    R   248_A      F     265          4.371
LGA    A   249_A      E     266          4.571
LGA    L   250_A      C     267          4.384
LGA    K   251_A      H     268          4.347
LGA    K   252_A      -       -           -
LGA    R   253_A      R     269          3.374
LGA    G   254_A      R     270          3.230
LGA    V   255_A      V     271          4.142
LGA    S   256_A      L     272          3.980
LGA    I   257_A      K     273          5.134
LGA    P   258_A      V     274          1.604
LGA    -       -      P     275           -
LGA    Q   259_A      T     276          3.589
LGA    E   260_A      D     277          2.563
LGA    V   261_A      I     278          1.325
LGA    Q   262_A      A     279          1.399
LGA    I   263_A      I     280          1.339
LGA    I   264_A      I     281          0.992
LGA    G   265_A      C     282          1.271
LGA    F   266_A      L     283          1.807
LGA    D   267_A      E     284          2.485
LGA    N   268_A      G     285          3.272
LGA    S   269_A      S     286          2.898
LGA    F   270_A      S     287          3.809
LGA    I   271_A      M     288          2.949
LGA    G   272_A      G     289          2.117
LGA    E   273_A      E     290          2.758
LGA    L   274_A      H     291          4.928
LGA    L   275_A      A     292          3.693
LGA    Y   276_A      Y     293          3.527
LGA    P   277_A      P     294          3.242
LGA    S   278_A      S     295          2.688
LGA    L   279_A      L     296          2.596
LGA    T   280_A      T     297          1.417
LGA    T   281_A      S     298          1.175
LGA    I   282_A      A     299          1.318
LGA    N   283_A      E     300          1.957
LGA    Q   284_A      F     301          1.869
LGA    P   285_A      D     302          2.805
LGA    I   286_A      Y     303          1.937
LGA    E   287_A      E     304          3.809
LGA    A   288_A      R     305          3.668
LGA    L   289_A      M     306          2.014
LGA    A   290_A      G     307          2.081
LGA    Y   291_A      T     308          2.776
LGA    T   292_A      K     309          2.478
LGA    I   293_A      A     310          1.303
LGA    I   294_A      A     311          1.224
LGA    E   295_A      E     312          1.716
LGA    L   296_A      K     313          1.702
LGA    L   297_A      L     314          1.547
LGA    I   298_A      L     315          1.728
LGA    K   299_A      H     316          2.926
LGA    I   300_A      A     317          2.952
LGA    I   301_A      I     318          2.850
LGA    N   302_A      K     319          3.358
LGA    G   303_A      -       -           -
LGA    E   304_A      E     321          1.739
LGA    G   305_A      P     322          2.867
LGA    V   306_A      E     323          1.881
LGA    L   307_A      E     324           #
LGA    I   308_A      -       -           -
LGA    E   309_A      -       -           -
LGA    D   310_A      P     326           #
LGA    Y   311_A      T     327          2.959
LGA    I   312_A      S     328          3.091
LGA    M   313_A      M     329          1.021
LGA    E   314_A      G     330          2.165
LGA    V   315_A      F     331          1.998
LGA    K   316_A      K     332          2.307
LGA    L   317_A      L     333          0.921
LGA    I   318_A      K     334          1.076
LGA    E   319_A      R     335          1.216
LGA    R   320_A      R     336          2.016
LGA    E   321_A      A     337          2.565
LGA    T   322_A      S     338          2.081
LGA    T   323_A      T     339          1.715
LGA    I   324_A      A     340          1.737
LGA    S   325_A      I     341          3.676
LGA    -       -      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  266  270    5.0    248    2.53    20.56     60.803     9.419

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.276123 * X  +   0.400034 * Y  +   0.873916 * Z  +  32.688293
  Y_new =   0.957036 * X  +   0.198200 * Y  +   0.211660 * Z  +  29.899118
  Z_new =  -0.088539 * X  +   0.894813 * Y  +  -0.437574 * Z  +   2.567206 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.025615   -1.115978  [ DEG:   116.0592    -63.9408 ]
  Theta =   0.088655    3.052938  [ DEG:     5.0795    174.9205 ]
  Phi   =   1.851687   -1.289905  [ DEG:   106.0939    -73.9061 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3ctp_A                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3ctp_A.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  266  270   5.0  248   2.53   20.56  60.803
REMARK  ---------------------------------------------------------- 
MOLECULE 3ctp_A
HEADER    TRANSCRIPTION REGULATOR                 14-APR-08   3CTP              
TITLE     CRYSTAL STRUCTURE OF PERIPLASMIC BINDING PROTEIN/LACI                 
TITLE    2 TRANSCRIPTIONAL REGULATOR FROM ALKALIPHILUS                          
TITLE    3 METALLIREDIGENS QYMF COMPLEXED WITH D-XYLULOFURANOSE                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PERIPLASMIC BINDING PROTEIN/LACI TRANSCRIPTIONAL           
COMPND   3 REGULATOR;                                                           
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ALKALIPHILUS METALLIREDIGENS QYMF;              
SOURCE   3 STRAIN: QYMF;                                                        
SOURCE   4 GENE: AMET_0586;                                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)CODON+RIL;                        
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: BC-PSGX3(BC)                              
KEYWDS    STRUCTURAL GENOMICS, CRYSTAL STRUCTURE, PROTEIN STRUCTURE             
KEYWDS   2 INITIATIVE, NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM,         
KEYWDS   3 NYSGXRC, TRANSCRIPTIONAL REGULATOR, L-XYLULOSE, D-                   
KEYWDS   4 XYLULOFURANOSE, DNA-BINDING, TRANSCRIPTION REGULATION,               
KEYWDS   5 TRANSCRIPTION REGULATOR, PSI-2                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.N.MALASHKEVICH,R.TORO,S.R.WASSERMAN,A.MEYER,J.M.SAUDER,             
AUTHOR   2 S.K.BURLEY,S.C.ALMO,NEW YORK STRUCTURAL GENOMIX RESEARCH             
AUTHOR   3 CONSORTIUM (NYSGXRC)                                                 
REVDAT   1   06-MAY-08 3CTP    0                                                
JRNL        AUTH   V.N.MALASHKEVICH,R.TORO,S.R.WASSERMAN,A.MEYER,               
JRNL        AUTH 2 J.M.SAUDER,S.K.BURLEY,S.C.ALMO                               
JRNL        TITL   CRYSTAL STRUCTURE OF PERIPLASMIC BINDING                     
JRNL        TITL 2 PROTEIN/LACI TRANSCRIPTIONAL REGULATOR FROM                  
JRNL        TITL 3 ALKALIPHILUS METALLIREDIGENS QYMF COMPLEXED WITH             
JRNL        TITL 4 L-XYLULOSE.                                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.41 ANGSTROMS.                                          
DBREF  3CTP A    3   328  UNP    A6TKU5   A6TKU5_ALKMQ     2    327             
DBREF  3CTP B    3   328  UNP    A6TKU5   A6TKU5_ALKMQ     2    327             
SEQRES   1 A  330  SER LEU ALA ASN ILE ARG GLU ILE ALA LYS ARG ALA GLY          
SEQRES   2 A  330  ILE SER ILE ALA THR VAL SER ARG HIS LEU ASN ASN THR          
SEQRES   3 A  330  GLY TYR VAL SER GLU ASP ALA ARG GLU LYS ILE GLN LYS          
SEQRES   4 A  330  VAL VAL ASP GLU LEU ASN TYR THR PRO ASN ALA LEU ALA          
SEQRES   5 A  330  ARG ALA MET PHE THR LYS ASN SER LYS THR ILE GLY LEU          
SEQRES   6 A  330  MET VAL PRO ASN ILE SER ASN PRO PHE PHE ASN GLN MET          
SEQRES   7 A  330  ALA SER VAL ILE GLU GLU TYR ALA LYS ASN LYS GLY TYR          
SEQRES   8 A  330  THR LEU PHE LEU CYS ASN THR ASP ASP ASP LYS GLU LYS          
SEQRES   9 A  330  GLU LYS THR TYR LEU GLU VAL LEU GLN SER HIS ARG VAL          
SEQRES  10 A  330  ALA GLY ILE ILE ALA SER ARG SER GLN CYS GLU ASP GLU          
SEQRES  11 A  330  TYR ALA ASN ILE ASP ILE PRO VAL VAL ALA PHE GLU ASN          
SEQRES  12 A  330  HIS ILE LEU ASP ASN ILE ILE THR ILE SER SER ASP ASN          
SEQRES  13 A  330  TYR ASN GLY GLY ARG MET ALA PHE ASP HIS LEU TYR GLU          
SEQRES  14 A  330  LYS GLY CYS ARG LYS ILE LEU HIS ILE LYS GLY PRO GLU          
SEQRES  15 A  330  VAL PHE GLU ALA THR GLU LEU ARG TYR LYS GLY PHE LEU          
SEQRES  16 A  330  ASP GLY ALA ARG ALA LYS ASP LEU GLU ILE ASP PHE ILE          
SEQRES  17 A  330  GLU PHE GLN HIS ASP PHE GLN VAL LYS MET LEU GLU GLU          
SEQRES  18 A  330  ASP ILE ASN SER MET LYS ASP ILE VAL ASN TYR ASP GLY          
SEQRES  19 A  330  ILE PHE VAL PHE ASN ASP ILE ALA ALA ALA THR VAL MET          
SEQRES  20 A  330  ARG ALA LEU LYS LYS ARG GLY VAL SER ILE PRO GLN GLU          
SEQRES  21 A  330  VAL GLN ILE ILE GLY PHE ASP ASN SER PHE ILE GLY GLU          
SEQRES  22 A  330  LEU LEU TYR PRO SER LEU THR THR ILE ASN GLN PRO ILE          
SEQRES  23 A  330  GLU ALA LEU ALA TYR THR ILE ILE GLU LEU LEU ILE LYS          
SEQRES  24 A  330  ILE ILE ASN GLY GLU GLY VAL LEU ILE GLU ASP TYR ILE          
SEQRES  25 A  330  MET GLU VAL LYS LEU ILE GLU ARG GLU THR THR ILE SER          
SEQRES  26 A  330  LEU LYS ASP GLU GLY                                          
SEQRES   1 B  330  SER LEU ALA ASN ILE ARG GLU ILE ALA LYS ARG ALA GLY          
SEQRES   2 B  330  ILE SER ILE ALA THR VAL SER ARG HIS LEU ASN ASN THR          
SEQRES   3 B  330  GLY TYR VAL SER GLU ASP ALA ARG GLU LYS ILE GLN LYS          
SEQRES   4 B  330  VAL VAL ASP GLU LEU ASN TYR THR PRO ASN ALA LEU ALA          
SEQRES   5 B  330  ARG ALA MET PHE THR LYS ASN SER LYS THR ILE GLY LEU          
SEQRES   6 B  330  MET VAL PRO ASN ILE SER ASN PRO PHE PHE ASN GLN MET          
SEQRES   7 B  330  ALA SER VAL ILE GLU GLU TYR ALA LYS ASN LYS GLY TYR          
SEQRES   8 B  330  THR LEU PHE LEU CYS ASN THR ASP ASP ASP LYS GLU LYS          
SEQRES   9 B  330  GLU LYS THR TYR LEU GLU VAL LEU GLN SER HIS ARG VAL          
SEQRES  10 B  330  ALA GLY ILE ILE ALA SER ARG SER GLN CYS GLU ASP GLU          
SEQRES  11 B  330  TYR ALA ASN ILE ASP ILE PRO VAL VAL ALA PHE GLU ASN          
SEQRES  12 B  330  HIS ILE LEU ASP ASN ILE ILE THR ILE SER SER ASP ASN          
SEQRES  13 B  330  TYR ASN GLY GLY ARG MET ALA PHE ASP HIS LEU TYR GLU          
SEQRES  14 B  330  LYS GLY CYS ARG LYS ILE LEU HIS ILE LYS GLY PRO GLU          
SEQRES  15 B  330  VAL PHE GLU ALA THR GLU LEU ARG TYR LYS GLY PHE LEU          
SEQRES  16 B  330  ASP GLY ALA ARG ALA LYS ASP LEU GLU ILE ASP PHE ILE          
SEQRES  17 B  330  GLU PHE GLN HIS ASP PHE GLN VAL LYS MET LEU GLU GLU          
SEQRES  18 B  330  ASP ILE ASN SER MET LYS ASP ILE VAL ASN TYR ASP GLY          
SEQRES  19 B  330  ILE PHE VAL PHE ASN ASP ILE ALA ALA ALA THR VAL MET          
SEQRES  20 B  330  ARG ALA LEU LYS LYS ARG GLY VAL SER ILE PRO GLN GLU          
SEQRES  21 B  330  VAL GLN ILE ILE GLY PHE ASP ASN SER PHE ILE GLY GLU          
SEQRES  22 B  330  LEU LEU TYR PRO SER LEU THR THR ILE ASN GLN PRO ILE          
SEQRES  23 B  330  GLU ALA LEU ALA TYR THR ILE ILE GLU LEU LEU ILE LYS          
SEQRES  24 B  330  ILE ILE ASN GLY GLU GLY VAL LEU ILE GLU ASP TYR ILE          
SEQRES  25 B  330  MET GLU VAL LYS LEU ILE GLU ARG GLU THR THR ILE SER          
SEQRES  26 B  330  LEU LYS ASP GLU GLY                                          
HET    XLF  A 401      10                                                       
HET    XLF  B 401      10                                                       
HET     NA  A 402       1                                                       
HET     NA  B 402       1                                                       
HETNAM     XLF BETA-D-XYLULOFURANOSE                                            
HETNAM      NA SODIUM ION                                                       
FORMUL   3  XLF    2(C5 H10 O5)                                                 
FORMUL   5   NA    2(NA 1+)                                                     
FORMUL   7  HOH   *489(H2 O)                                                    
CRYST1   64.172   61.903   74.362  90.00 104.81  90.00 P 1 21 1      4          
ATOM      1  N   SER A  60      50.509  88.688  11.824  1.00 31.32           N  
ATOM      2  CA  SER A  60      51.094  87.432  12.358  1.00 29.75           C  
ATOM      3  C   SER A  60      50.745  86.242  11.465  1.00 26.54           C  
ATOM      4  O   SER A  60      49.601  86.087  11.028  1.00 27.20           O  
ATOM      5  CB  SER A  60      50.555  87.158  13.765  1.00 30.59           C  
ATOM      6  OG  SER A  60      50.951  85.873  14.208  1.00 29.97           O  
ATOM      7  N   LYS A  61      51.727  85.395  11.201  1.00 22.02           N  
ATOM      8  CA  LYS A  61      51.419  84.125  10.588  1.00 18.70           C  
ATOM      9  C   LYS A  61      51.675  83.030  11.591  1.00 15.10           C  
ATOM     10  O   LYS A  61      52.174  81.977  11.233  1.00 14.96           O  
ATOM     11  CB  LYS A  61      52.247  83.900   9.317  1.00 20.77           C  
ATOM     12  CG  LYS A  61      51.977  84.958   8.257  1.00 26.14           C  
ATOM     13  CD  LYS A  61      50.539  84.846   7.767  1.00 25.55           C  
ATOM     14  CE  LYS A  61      50.366  83.702   6.763  1.00 22.49           C  
ATOM     15  NZ  LYS A  61      49.115  83.907   5.970  1.00 33.52           N  
ATOM     16  N   THR A  62      51.279  83.259  12.847  1.00 12.96           N  
ATOM     17  CA  THR A  62      51.427  82.234  13.875  1.00 11.61           C  
ATOM     18  C   THR A  62      50.079  81.935  14.522  1.00 11.76           C  
ATOM     19  O   THR A  62      49.271  82.860  14.748  1.00 14.70           O  
ATOM     20  CB  THR A  62      52.457  82.636  14.925  1.00 14.41           C  
ATOM     21  OG1 THR A  62      53.722  82.836  14.264  1.00 17.35           O  
ATOM     22  CG2 THR A  62      52.637  81.532  15.980  1.00 16.14           C  
ATOM     23  N   ILE A  63      49.846  80.650  14.767  1.00 10.30           N  
ATOM     24  CA  ILE A  63      48.642  80.170  15.451  1.00  9.31           C  
ATOM     25  C   ILE A  63      49.066  79.628  16.813  1.00  9.63           C  
ATOM     26  O   ILE A  63      50.126  79.004  16.936  1.00 10.82           O  
ATOM     27  CB  ILE A  63      48.010  79.036  14.644  1.00  9.76           C  
ATOM     28  CG1 ILE A  63      47.356  79.651  13.417  1.00 11.11           C  
ATOM     29  CG2 ILE A  63      47.004  78.249  15.501  1.00 11.95           C  
ATOM     30  CD1 ILE A  63      47.115  78.663  12.256  1.00 12.92           C  
ATOM     31  N   GLY A  64      48.276  79.890  17.845  1.00  9.23           N  
ATOM     32  CA  GLY A  64      48.591  79.335  19.165  1.00  9.66           C  
ATOM     33  C   GLY A  64      47.809  78.060  19.354  1.00  9.89           C  
ATOM     34  O   GLY A  64      46.590  78.049  19.142  1.00 11.47           O  
ATOM     35  N   LEU A  65      48.487  76.982  19.697  1.00  8.45           N  
ATOM     36  CA  LEU A  65      47.822  75.710  19.971  1.00  7.83           C  
ATOM     37  C   LEU A  65      47.914  75.424  21.460  1.00  9.24           C  
ATOM     38  O   LEU A  65      49.018  75.235  21.982  1.00  9.17           O  
ATOM     39  CB  LEU A  65      48.506  74.568  19.215  1.00  8.95           C  
ATOM     40  CG  LEU A  65      48.101  73.125  19.580  1.00  8.81           C  
ATOM     41  CD1 LEU A  65      46.581  72.911  19.371  1.00 12.48           C  
ATOM     42  CD2 LEU A  65      48.860  72.099  18.763  1.00 11.55           C  
ATOM     43  N   MET A  66      46.774  75.399  22.144  1.00  8.48           N  
ATOM     44  CA  MET A  66      46.774  75.020  23.531  1.00  9.86           C  
ATOM     45  C   MET A  66      46.635  73.522  23.634  1.00 13.29           C  
ATOM     46  O   MET A  66      45.700  72.932  23.034  1.00 16.16           O  
ATOM     47  CB  MET A  66      45.697  75.816  24.304  1.00 12.93           C  
ATOM     48  CG  MET A  66      46.229  77.329  24.542  1.00 15.17           C  
ATOM     49  SD  MET A  66      45.275  78.331  25.521  1.00 21.09           S  
ATOM     50  CE  MET A  66      43.726  78.135  24.675  1.00 16.81           C  
ATOM     51  N   VAL A  67      47.554  72.943  24.408  1.00 12.65           N  
ATOM     52  CA  VAL A  67      47.745  71.543  24.610  1.00 15.68           C  
ATOM     53  C   VAL A  67      47.508  71.241  26.115  1.00 13.20           C  
ATOM     54  O   VAL A  67      48.179  71.826  26.949  1.00 14.19           O  
ATOM     55  CB  VAL A  67      49.249  71.227  24.278  1.00 16.24           C  
ATOM     56  CG1 VAL A  67      49.516  69.787  24.329  1.00 17.04           C  
ATOM     57  CG2 VAL A  67      49.633  71.779  22.876  1.00 22.01           C  
ATOM     58  N   PRO A  68      46.623  70.267  26.481  0.50 11.73           N  
ATOM     60  CA  PRO A  68      46.615  69.892  27.930  0.50 10.88           C  
ATOM     62  C   PRO A  68      48.005  69.545  28.431  0.50 11.06           C  
ATOM     64  O   PRO A  68      48.586  70.302  29.202  0.50  8.93           O  
ATOM     66  CB  PRO A  68      45.740  68.633  27.989  0.50 12.67           C  
ATOM     68  CG  PRO A  68      44.772  68.841  26.799  0.50 10.33           C  
ATOM     70  CD  PRO A  68      45.541  69.586  25.732  0.50 14.06           C  
ATOM     72  N   ASN A  69      48.511  68.364  28.086  0.50 12.67           N  
ATOM     74  CA  ASN A  69      49.977  68.214  28.150  0.50 15.38           C  
ATOM     76  C   ASN A  69      50.540  67.325  27.101  0.50 15.14           C  
ATOM     78  O   ASN A  69      49.961  66.297  26.756  0.50 10.66           O  
ATOM     80  CB  ASN A  69      50.493  67.833  29.543  0.50 15.87           C  
ATOM     82  CG  ASN A  69      51.920  68.289  29.757  0.50 17.86           C  
ATOM     84  OD1 ASN A  69      52.859  67.701  29.231  0.50 13.55           O  
ATOM     86  ND2 ASN A  69      52.086  69.384  30.479  0.50 20.54           N  
ATOM     88  N   ILE A  70      51.668  67.763  26.543  1.00 17.73           N  
ATOM     89  CA  ILE A  70      52.314  66.998  25.440  1.00 19.34           C  
ATOM     90  C   ILE A  70      52.997  65.760  25.995  1.00 20.48           C  
ATOM     91  O   ILE A  70      53.445  64.882  25.215  1.00 22.78           O  
ATOM     92  CB  ILE A  70      53.347  67.801  24.586  1.00 19.16           C  
ATOM     93  CG1 ILE A  70      54.392  68.474  25.472  1.00 19.66           C  
ATOM     94  CG2 ILE A  70      52.627  68.792  23.639  1.00 24.17           C  
ATOM     95  CD1 ILE A  70      55.539  69.109  24.703  1.00 22.74           C  
ATOM     96  N   SER A  71      53.027  65.669  27.322  1.00 17.86           N  
ATOM     97  CA  SER A  71      53.366  64.352  27.969  1.00 16.83           C  
ATOM     98  C   SER A  71      52.412  63.202  27.661  1.00 14.25           C  
ATOM     99  O   SER A  71      52.795  62.037  27.749  1.00 14.58           O  
ATOM    100  CB  SER A  71      53.522  64.437  29.466  1.00 18.43           C  
ATOM    101  OG  SER A  71      52.279  64.361  30.137  1.00 22.18           O  
ATOM    102  N   ASN A  72      51.188  63.513  27.253  1.00  9.90           N  
ATOM    103  CA  ASN A  72      50.321  62.459  26.694  1.00  7.75           C  
ATOM    104  C   ASN A  72      50.641  62.292  25.211  1.00  7.93           C  
ATOM    105  O   ASN A  72      50.530  63.250  24.443  1.00  9.36           O  
ATOM    106  CB  ASN A  72      48.861  62.896  26.900  1.00  7.96           C  
ATOM    107  CG  ASN A  72      47.874  61.904  26.334  1.00  8.96           C  
ATOM    108  OD1 ASN A  72      48.216  61.036  25.506  1.00 10.44           O  
ATOM    109  ND2 ASN A  72      46.612  62.009  26.797  1.00  8.46           N  
ATOM    110  N   PRO A  73      51.111  61.098  24.826  1.00  8.83           N  
ATOM    111  CA  PRO A  73      51.491  60.853  23.439  1.00  8.30           C  
ATOM    112  C   PRO A  73      50.471  61.332  22.443  1.00  9.58           C  
ATOM    113  O   PRO A  73      50.829  61.836  21.392  1.00 10.01           O  
ATOM    114  CB  PRO A  73      51.601  59.319  23.386  1.00  9.62           C  
ATOM    115  CG  PRO A  73      52.181  59.000  24.734  1.00 12.49           C  
ATOM    116  CD  PRO A  73      51.380  59.912  25.680  1.00  9.81           C  
ATOM    117  N   PHE A  74      49.188  61.198  22.755  1.00  7.61           N  
ATOM    118  CA  PHE A  74      48.185  61.602  21.768  1.00  8.47           C  
ATOM    119  C   PHE A  74      48.329  63.104  21.469  1.00  9.09           C  
ATOM    120  O   PHE A  74      48.246  63.545  20.314  1.00  9.68           O  
ATOM    121  CB  PHE A  74      46.759  61.340  22.306  1.00  8.24           C  
ATOM    122  CG  PHE A  74      45.682  61.867  21.380  1.00  7.61           C  
ATOM    123  CD1 PHE A  74      45.335  61.146  20.251  1.00 10.97           C  
ATOM    124  CD2 PHE A  74      45.090  63.094  21.625  1.00  9.41           C  
ATOM    125  CE1 PHE A  74      44.364  61.648  19.361  1.00 12.98           C  
ATOM    126  CE2 PHE A  74      44.125  63.621  20.753  1.00 13.24           C  
ATOM    127  CZ  PHE A  74      43.772  62.885  19.614  1.00 12.28           C  
ATOM    128  N   PHE A  75      48.550  63.908  22.500  1.00  8.75           N  
ATOM    129  CA  PHE A  75      48.639  65.345  22.229  1.00  7.94           C  
ATOM    130  C   PHE A  75      49.951  65.742  21.567  1.00  8.92           C  
ATOM    131  O   PHE A  75      49.976  66.732  20.811  1.00  9.96           O  
ATOM    132  CB  PHE A  75      48.399  66.182  23.488  1.00  8.86           C  
ATOM    133  CG  PHE A  75      46.962  66.170  23.910  1.00  9.68           C  
ATOM    134  CD1 PHE A  75      45.997  66.778  23.111  1.00  9.56           C  
ATOM    135  CD2 PHE A  75      46.580  65.519  25.059  1.00 10.97           C  
ATOM    136  CE1 PHE A  75      44.631  66.731  23.478  1.00  9.73           C  
ATOM    137  CE2 PHE A  75      45.228  65.452  25.415  1.00  9.73           C  
ATOM    138  CZ  PHE A  75      44.261  66.074  24.636  1.00 12.02           C  
ATOM    139  N   ASN A  76      51.029  65.030  21.839  1.00  9.02           N  
ATOM    140  CA  ASN A  76      52.216  65.412  21.067  1.00  9.22           C  
ATOM    141  C   ASN A  76      52.108  64.989  19.610  1.00  9.95           C  
ATOM    142  O   ASN A  76      52.586  65.690  18.718  1.00 10.69           O  
ATOM    143  CB  ASN A  76      53.548  65.058  21.743  1.00 13.38           C  
ATOM    144  CG  ASN A  76      53.769  63.593  21.953  1.00 15.07           C  
ATOM    145  OD1 ASN A  76      53.877  62.840  20.971  1.00 21.59           O  
ATOM    146  ND2 ASN A  76      54.005  63.172  23.243  1.00 12.08           N  
ATOM    147  N   GLN A  77      51.464  63.889  19.311  1.00  9.62           N  
ATOM    148  CA  GLN A  77      51.261  63.528  17.918  1.00  9.05           C  
ATOM    149  C   GLN A  77      50.299  64.481  17.244  1.00 10.17           C  
ATOM    150  O   GLN A  77      50.517  64.877  16.161  1.00 10.06           O  
ATOM    151  CB  GLN A  77      50.705  62.128  17.797  1.00  9.87           C  
ATOM    152  CG  GLN A  77      51.691  61.030  18.212  1.00 11.08           C  
ATOM    153  CD  GLN A  77      51.084  59.654  18.191  1.00 12.64           C  
ATOM    154  OE1 GLN A  77      50.732  59.121  19.199  1.00 14.43           O  
ATOM    155  NE2 GLN A  77      51.015  59.084  17.041  1.00 11.24           N  
ATOM    156  N   MET A  78      49.234  64.837  17.940  1.00  8.74           N  
ATOM    157  CA  MET A  78      48.306  65.822  17.379  1.00 10.02           C  
ATOM    158  C   MET A  78      49.037  67.133  17.090  1.00  9.40           C  
ATOM    159  O   MET A  78      48.834  67.759  16.029  1.00 11.07           O  
ATOM    160  CB  MET A  78      47.132  66.090  18.352  1.00 12.51           C  
ATOM    161  CG  MET A  78      46.032  65.068  18.238  1.00 17.59           C  
ATOM    162  SD  MET A  78      44.841  65.460  16.896  1.00 16.06           S  
ATOM    163  CE  MET A  78      44.011  66.747  17.822  1.00  8.64           C  
ATOM    164  N   ALA A  79      49.879  67.585  18.014  1.00  9.22           N  
ATOM    165  CA  ALA A  79      50.590  68.853  17.800  1.00  8.63           C  
ATOM    166  C   ALA A  79      51.517  68.745  16.589  1.00  9.38           C  
ATOM    167  O   ALA A  79      51.654  69.713  15.819  1.00 10.50           O  
ATOM    168  CB  ALA A  79      51.395  69.210  19.043  1.00  9.64           C  
ATOM    169  N   SER A  80      52.172  67.592  16.426  1.00  9.09           N  
ATOM    170  CA  SER A  80      53.059  67.436  15.258  1.00 10.04           C  
ATOM    171  C   SER A  80      52.280  67.535  13.952  1.00 10.80           C  
ATOM    172  O   SER A  80      52.748  68.137  12.984  1.00 12.23           O  
ATOM    173  CB  SER A  80      53.788  66.088  15.305  1.00 11.47           C  
ATOM    174  OG  SER A  80      54.705  66.048  16.416  1.00 15.26           O  
ATOM    175  N   VAL A  81      51.112  66.904  13.900  1.00  9.51           N  
ATOM    176  CA  VAL A  81      50.361  66.865  12.642  1.00  8.84           C  
ATOM    177  C   VAL A  81      49.647  68.197  12.395  1.00  9.76           C  
ATOM    178  O   VAL A  81      49.585  68.686  11.273  1.00 10.35           O  
ATOM    179  CB  VAL A  81      49.407  65.665  12.607  1.00 10.26           C  
ATOM    180  CG1 VAL A  81      48.642  65.642  11.296  1.00 12.96           C  
ATOM    181  CG2 VAL A  81      50.207  64.359  12.800  1.00 12.45           C  
ATOM    182  N   ILE A  82      49.101  68.823  13.449  1.00  8.56           N  
ATOM    183  CA  ILE A  82      48.555  70.164  13.266  1.00  8.58           C  
ATOM    184  C   ILE A  82      49.635  71.102  12.712  1.00  9.46           C  
ATOM    185  O   ILE A  82      49.364  71.930  11.847  1.00 10.84           O  
ATOM    186  CB  ILE A  82      48.011  70.703  14.590  1.00  8.77           C  
ATOM    187  CG1 ILE A  82      46.759  69.900  14.991  1.00 10.11           C  
ATOM    188  CG2 ILE A  82      47.636  72.159  14.453  1.00  9.61           C  
ATOM    189  CD1 ILE A  82      46.200  70.218  16.385  1.00 10.29           C  
ATOM    190  N   GLU A  83      50.870  70.975  13.211  1.00  8.76           N  
ATOM    191  CA  GLU A  83      51.933  71.849  12.715  1.00  9.53           C  
ATOM    192  C   GLU A  83      52.132  71.659  11.209  1.00 10.44           C  
ATOM    193  O   GLU A  83      52.312  72.632  10.470  1.00 11.29           O  
ATOM    194  CB  GLU A  83      53.248  71.637  13.477  1.00 13.41           C  
ATOM    195  CG  GLU A  83      54.368  72.515  12.893  1.00 18.60           C  
ATOM    196  CD  GLU A  83      55.182  73.245  13.935  1.00 23.71           C  
ATOM    197  OE1 GLU A  83      54.867  73.157  15.145  1.00 21.91           O  
ATOM    198  OE2 GLU A  83      56.133  73.947  13.521  1.00 25.93           O  
ATOM    199  N   GLU A  84      52.059  70.423  10.747  1.00 10.04           N  
ATOM    200  CA  GLU A  84      52.210  70.145   9.302  1.00 10.69           C  
ATOM    201  C   GLU A  84      51.117  70.814   8.489  1.00 10.47           C  
ATOM    202  O   GLU A  84      51.384  71.451   7.446  1.00 11.82           O  
ATOM    203  CB  GLU A  84      52.154  68.638   9.038  1.00 13.71           C  
ATOM    204  CG  GLU A  84      53.338  67.873   9.597  1.00 17.04           C  
ATOM    205  CD  GLU A  84      54.616  68.006   8.753  1.00 23.66           C  
ATOM    206  OE1 GLU A  84      54.613  68.664   7.676  1.00 23.05           O  
ATOM    207  OE2 GLU A  84      55.622  67.403   9.174  1.00 27.99           O  
ATOM    208  N   TYR A  85      49.867  70.623   8.914  1.00  9.10           N  
ATOM    209  CA  TYR A  85      48.774  71.243   8.194  1.00  8.42           C  
ATOM    210  C   TYR A  85      48.808  72.761   8.265  1.00  9.07           C  
ATOM    211  O   TYR A  85      48.439  73.438   7.291  1.00 10.69           O  
ATOM    212  CB  TYR A  85      47.415  70.681   8.622  1.00 10.21           C  
ATOM    213  CG  TYR A  85      47.163  69.292   8.089  1.00 10.71           C  
ATOM    214  CD1 TYR A  85      47.350  68.189   8.878  1.00 16.27           C  
ATOM    215  CD2 TYR A  85      46.759  69.094   6.762  1.00 17.00           C  
ATOM    216  CE1 TYR A  85      47.125  66.902   8.395  1.00 16.21           C  
ATOM    217  CE2 TYR A  85      46.531  67.792   6.269  1.00 16.87           C  
ATOM    218  CZ  TYR A  85      46.731  66.712   7.097  1.00 19.91           C  
ATOM    219  OH  TYR A  85      46.523  65.417   6.651  1.00 20.66           O  
ATOM    220  N   ALA A  86      49.232  73.315   9.402  1.00  7.86           N  
ATOM    221  CA  ALA A  86      49.369  74.774   9.520  1.00  8.27           C  
ATOM    222  C   ALA A  86      50.427  75.281   8.550  1.00 10.22           C  
ATOM    223  O   ALA A  86      50.237  76.286   7.876  1.00  9.83           O  
ATOM    224  CB  ALA A  86      49.789  75.131  10.953  1.00  9.46           C  
ATOM    225  N   LYS A  87      51.544  74.566   8.480  1.00  9.86           N  
ATOM    226  CA  LYS A  87      52.614  74.942   7.560  1.00  9.90           C  
ATOM    227  C   LYS A  87      52.113  74.961   6.107  1.00 11.15           C  
ATOM    228  O   LYS A  87      52.485  75.865   5.334  1.00 11.95           O  
ATOM    229  CB  LYS A  87      53.795  73.991   7.733  1.00 11.59           C  
ATOM    230  CG  LYS A  87      54.944  74.290   6.766  1.00 14.00           C  
ATOM    231  CD  LYS A  87      56.204  73.517   7.170  1.00 15.28           C  
ATOM    232  CE  LYS A  87      56.051  72.054   6.825  1.00 18.63           C  
ATOM    233  NZ  LYS A  87      57.214  71.251   7.332  1.00 21.22           N  
ATOM    234  N   ASN A  88      51.299  73.986   5.720  1.00 11.89           N  
ATOM    235  CA  ASN A  88      50.747  73.986   4.355  1.00 12.85           C  
ATOM    236  C   ASN A  88      49.987  75.279   4.045  1.00 13.78           C  
ATOM    237  O   ASN A  88      49.908  75.702   2.878  1.00 15.68           O  
ATOM    238  CB  ASN A  88      49.786  72.813   4.164  1.00 14.44           C  
ATOM    239  CG  ASN A  88      50.476  71.474   4.233  1.00 19.83           C  
ATOM    240  OD1 ASN A  88      51.696  71.398   4.344  1.00 26.33           O  
ATOM    241  ND2 ASN A  88      49.693  70.404   4.162  1.00 25.08           N  
ATOM    242  N   LYS A  89      49.386  75.883   5.073  1.00 11.50           N  
ATOM    243  CA  LYS A  89      48.589  77.099   4.904  1.00 12.59           C  
ATOM    244  C   LYS A  89      49.408  78.356   5.125  1.00 12.93           C  
ATOM    245  O   LYS A  89      48.855  79.468   5.028  1.00 15.18           O  
ATOM    246  CB  LYS A  89      47.410  77.115   5.902  1.00 15.14           C  
ATOM    247  CG  LYS A  89      46.387  76.001   5.693  1.00 20.32           C  
ATOM    248  CD  LYS A  89      45.432  76.365   4.548  1.00 23.43           C  
ATOM    249  CE  LYS A  89      44.523  75.204   4.160  1.00 29.48           C  
ATOM    250  NZ  LYS A  89      43.837  74.564   5.317  1.00 36.80           N  
ATOM    251  N   GLY A  90      50.694  78.191   5.466  1.00 10.47           N  
ATOM    252  CA  GLY A  90      51.595  79.311   5.689  1.00 11.30           C  
ATOM    253  C   GLY A  90      51.736  79.816   7.120  1.00 12.75           C  
ATOM    254  O   GLY A  90      52.218  80.937   7.314  1.00 13.12           O  
ATOM    255  N   TYR A  91      51.393  78.983   8.112  1.00  9.75           N  
ATOM    256  CA  TYR A  91      51.449  79.397   9.522  1.00  9.77           C  
ATOM    257  C   TYR A  91      52.442  78.560  10.322  1.00 11.26           C  
ATOM    258  O   TYR A  91      52.622  77.359  10.056  1.00 12.93           O  
ATOM    259  CB  TYR A  91      50.069  79.237  10.180  1.00  9.70           C  
ATOM    260  CG  TYR A  91      49.060  80.215   9.647  1.00 10.22           C  
ATOM    261  CD1 TYR A  91      48.826  81.414  10.300  1.00 11.57           C  
ATOM    262  CD2 TYR A  91      48.370  79.953   8.463  1.00 12.68           C  
ATOM    263  CE1 TYR A  91      47.897  82.316   9.816  1.00 13.50           C  
ATOM    264  CE2 TYR A  91      47.470  80.852   7.959  1.00 12.73           C  
ATOM    265  CZ  TYR A  91      47.235  82.038   8.623  1.00 13.33           C  
ATOM    266  OH  TYR A  91      46.312  82.928   8.090  1.00 17.49           O  
ATOM    267  N   THR A  92      53.080  79.205  11.300  1.00 11.15           N  
ATOM    268  CA  THR A  92      53.833  78.478  12.326  1.00 11.39           C  
ATOM    269  C   THR A  92      52.960  78.335  13.578  1.00 12.04           C  
ATOM    270  O   THR A  92      51.893  78.931  13.652  1.00 13.53           O  
ATOM    271  CB  THR A  92      55.097  79.221  12.669  1.00 13.61           C  
ATOM    272  OG1 THR A  92      54.805  80.611  12.805  1.00 17.03           O  
ATOM    273  CG2 THR A  92      56.075  79.099  11.496  1.00 15.94           C  
ATOM    274  N   LEU A  93      53.393  77.523  14.545  1.00 12.02           N  
ATOM    275  CA  LEU A  93      52.609  77.299  15.766  1.00 12.07           C  
ATOM    276  C   LEU A  93      53.443  77.633  17.020  1.00 12.07           C  
ATOM    277  O   LEU A  93      54.638  77.345  17.069  1.00 12.97           O  
ATOM    278  CB  LEU A  93      52.278  75.818  15.917  1.00 15.97           C  
ATOM    279  CG  LEU A  93      51.216  75.105  15.125  1.00 22.63           C  
ATOM    280  CD1 LEU A  93      51.067  73.703  15.722  1.00 16.75           C  
ATOM    281  CD2 LEU A  93      49.926  75.871  15.247  1.00 17.87           C  
ATOM    282  N   PHE A  94      52.795  78.226  18.013  1.00 10.62           N  
ATOM    283  CA  PHE A  94      53.313  78.272  19.385  1.00 10.92           C  
ATOM    284  C   PHE A  94      52.503  77.256  20.170  1.00 12.10           C  
ATOM    285  O   PHE A  94      51.267  77.298  20.124  1.00 14.32           O  
ATOM    286  CB  PHE A  94      53.066  79.638  20.023  1.00 12.03           C  
ATOM    287  CG  PHE A  94      53.950  80.745  19.511  1.00 12.48           C  
ATOM    288  CD1 PHE A  94      55.226  80.483  19.083  1.00 14.34           C  
ATOM    289  CD2 PHE A  94      53.506  82.047  19.532  1.00 14.52           C  
ATOM    290  CE1 PHE A  94      56.061  81.524  18.626  1.00 20.50           C  
ATOM    291  CE2 PHE A  94      54.315  83.070  19.099  1.00 17.86           C  
ATOM    292  CZ  PHE A  94      55.576  82.813  18.634  1.00 16.60           C  
ATOM    293  N   LEU A  95      53.149  76.348  20.893  1.00  9.69           N  
ATOM    294  CA  LEU A  95      52.411  75.406  21.740  1.00  9.84           C  
ATOM    295  C   LEU A  95      52.379  75.921  23.156  1.00 12.38           C  
ATOM    296  O   LEU A  95      53.396  76.400  23.664  1.00 11.99           O  
ATOM    297  CB  LEU A  95      53.075  74.034  21.780  1.00 11.49           C  
ATOM    298  CG  LEU A  95      53.484  73.419  20.468  1.00 16.62           C  
ATOM    299  CD1 LEU A  95      54.000  71.978  20.777  1.00 16.83           C  
ATOM    300  CD2 LEU A  95      52.295  73.358  19.553  1.00 17.47           C  
ATOM    301  N   CYS A  96      51.213  75.812  23.795  1.00 12.77           N  
ATOM    302  CA  CYS A  96      51.008  76.322  25.148  1.00 14.73           C  
ATOM    303  C   CYS A  96      50.426  75.215  25.977  1.00 16.99           C  
ATOM    304  O   CYS A  96      49.397  74.641  25.665  1.00 16.79           O  
ATOM    305  CB  CYS A  96      50.012  77.490  25.123  1.00 15.02           C  
ATOM    306  SG  CYS A  96      50.609  78.915  24.136  1.00 21.37           S  
ATOM    307  N   ASN A  97      51.106  74.938  27.078  1.00 16.76           N  
ATOM    308  CA  ASN A  97      50.789  73.856  27.915  1.00 17.10           C  
ATOM    309  C   ASN A  97      49.725  74.276  28.959  1.00 15.18           C  
ATOM    310  O   ASN A  97      50.049  75.036  29.857  1.00 15.32           O  
ATOM    311  CB  ASN A  97      52.099  73.603  28.663  1.00 19.32           C  
ATOM    312  CG  ASN A  97      51.983  72.535  29.631  1.00 26.28           C  
ATOM    313  OD1 ASN A  97      50.900  72.016  29.820  1.00 24.58           O  
ATOM    314  ND2 ASN A  97      53.096  72.169  30.274  1.00 24.23           N  
ATOM    315  N   THR A  98      48.471  73.825  28.849  1.00 14.08           N  
ATOM    316  CA  THR A  98      47.468  74.330  29.851  1.00 12.59           C  
ATOM    317  C   THR A  98      47.264  73.397  31.028  1.00 13.63           C  
ATOM    318  O   THR A  98      46.665  73.787  32.038  1.00 12.96           O  
ATOM    319  CB  THR A  98      46.088  74.596  29.241  1.00 13.18           C  
ATOM    320  OG1 THR A  98      45.554  73.359  28.776  1.00 22.54           O  
ATOM    321  CG2 THR A  98      46.159  75.631  28.113  1.00 17.13           C  
ATOM    322  N   ASP A  99      47.758  72.163  30.932  0.50 14.10           N  
ATOM    324  CA  ASP A  99      47.657  71.198  32.031  0.50 14.56           C  
ATOM    326  C   ASP A  99      46.268  71.028  32.615  0.50 14.96           C  
ATOM    328  O   ASP A  99      46.105  70.820  33.821  0.50 16.88           O  
ATOM    330  CB  ASP A  99      48.603  71.582  33.153  0.50 15.30           C  
ATOM    332  CG  ASP A  99      49.965  71.065  32.925  0.50 22.95           C  
ATOM    334  OD1 ASP A  99      50.083  69.916  32.433  0.50 14.85           O  
ATOM    336  OD2 ASP A  99      50.903  71.816  33.226  0.50 18.98           O  
ATOM    338  N   ASP A 100      45.265  71.108  31.758  1.00 12.92           N  
ATOM    339  CA  ASP A 100      43.889  70.967  32.202  1.00 11.86           C  
ATOM    340  C   ASP A 100      43.603  71.861  33.398  1.00 11.74           C  
ATOM    341  O   ASP A 100      42.828  71.507  34.300  1.00 14.04           O  
ATOM    342  CB  ASP A 100      43.582  69.518  32.564  1.00 12.05           C  
ATOM    343  CG  ASP A 100      43.651  68.598  31.343  1.00 12.34           C  
ATOM    344  OD1 ASP A 100      43.006  68.914  30.317  1.00 12.74           O  
ATOM    345  OD2 ASP A 100      44.313  67.549  31.438  1.00 12.79           O  
ATOM    346  N   ASP A 101      44.146  73.066  33.349  1.00 10.79           N  
ATOM    347  CA  ASP A 101      43.942  74.033  34.429  1.00 10.90           C  
ATOM    348  C   ASP A 101      43.315  75.298  33.872  1.00 11.80           C  
ATOM    349  O   ASP A 101      43.847  75.918  32.950  1.00 12.69           O  
ATOM    350  CB  ASP A 101      45.276  74.376  35.084  1.00 10.29           C  
ATOM    351  CG  ASP A 101      45.104  75.323  36.263  1.00 15.55           C  
ATOM    352  OD1 ASP A 101      44.677  74.866  37.337  1.00 24.09           O  
ATOM    353  OD2 ASP A 101      45.356  76.509  36.094  1.00 18.37           O  
ATOM    354  N   LYS A 102      42.185  75.688  34.444  1.00 11.53           N  
ATOM    355  CA  LYS A 102      41.468  76.841  33.944  1.00 12.83           C  
ATOM    356  C   LYS A 102      42.324  78.102  34.030  1.00 12.06           C  
ATOM    357  O   LYS A 102      42.289  78.962  33.153  1.00 13.33           O  
ATOM    358  CB  LYS A 102      40.162  77.011  34.758  1.00 15.56           C  
ATOM    359  CG  LYS A 102      39.194  78.013  34.149  1.00 33.27           C  
ATOM    360  CD  LYS A 102      37.915  78.189  34.991  1.00 30.58           C  
ATOM    361  CE  LYS A 102      37.268  76.856  35.318  1.00 35.42           C  
ATOM    362  NZ  LYS A 102      35.833  77.038  35.765  1.00 36.05           N  
ATOM    363  N   GLU A 103      43.087  78.258  35.106  1.00 11.78           N  
ATOM    364  CA  GLU A 103      43.862  79.491  35.217  1.00 12.89           C  
ATOM    365  C   GLU A 103      45.055  79.540  34.249  1.00 12.27           C  
ATOM    366  O   GLU A 103      45.417  80.602  33.748  1.00 13.57           O  
ATOM    367  CB  GLU A 103      44.297  79.720  36.661  1.00 14.47           C  
ATOM    368  CG  GLU A 103      43.102  79.654  37.638  1.00 36.30           C  
ATOM    369  CD  GLU A 103      41.910  80.559  37.267  1.00 29.43           C  
ATOM    370  OE1 GLU A 103      42.114  81.734  36.881  1.00 36.87           O  
ATOM    371  OE2 GLU A 103      40.753  80.093  37.388  1.00 39.86           O  
ATOM    372  N   LYS A 104      45.677  78.399  33.975  1.00 10.94           N  
ATOM    373  CA  LYS A 104      46.735  78.393  32.960  1.00 11.20           C  
ATOM    374  C   LYS A 104      46.151  78.690  31.589  1.00 11.39           C  
ATOM    375  O   LYS A 104      46.752  79.394  30.778  1.00 12.27           O  
ATOM    376  CB  LYS A 104      47.468  77.045  32.922  1.00 12.89           C  
ATOM    377  CG  LYS A 104      48.377  76.848  34.130  1.00 15.61           C  
ATOM    378  CD  LYS A 104      48.993  75.461  34.142  1.00 17.01           C  
ATOM    379  CE  LYS A 104      49.780  75.271  35.441  1.00 24.61           C  
ATOM    380  NZ  LYS A 104      50.435  73.939  35.551  1.00 21.92           N  
ATOM    381  N   GLU A 105      44.978  78.140  31.312  1.00 10.72           N  
ATOM    382  CA  GLU A 105      44.326  78.452  30.040  1.00 10.56           C  
ATOM    383  C   GLU A 105      44.038  79.948  29.939  1.00 11.31           C  
ATOM    384  O   GLU A 105      44.284  80.580  28.905  1.00 12.05           O  
ATOM    385  CB  GLU A 105      43.023  77.644  29.891  1.00 12.10           C  
ATOM    386  CG  GLU A 105      42.363  77.904  28.562  1.00 13.19           C  
ATOM    387  CD  GLU A 105      41.092  77.108  28.377  1.00 17.50           C  
ATOM    388  OE1 GLU A 105      40.690  76.359  29.310  1.00 17.59           O  
ATOM    389  OE2 GLU A 105      40.522  77.241  27.263  1.00 21.25           O  
ATOM    390  N   LYS A 106      43.501  80.530  31.011  1.00 11.59           N  
ATOM    391  CA  LYS A 106      43.209  81.963  30.974  1.00 11.42           C  
ATOM    392  C   LYS A 106      44.469  82.798  30.720  1.00 12.41           C  
ATOM    393  O   LYS A 106      44.470  83.770  29.949  1.00 12.37           O  
ATOM    394  CB  LYS A 106      42.548  82.381  32.299  1.00 12.73           C  
ATOM    395  CG  LYS A 106      42.260  83.860  32.390  1.00 23.54           C  
ATOM    396  CD  LYS A 106      41.513  84.182  33.694  1.00 26.59           C  
ATOM    397  CE  LYS A 106      40.109  83.572  33.732  1.00 30.17           C  
ATOM    398  NZ  LYS A 106      39.405  83.858  35.052  1.00 34.52           N  
ATOM    399  N   THR A 107      45.566  82.403  31.365  1.00 10.73           N  
ATOM    400  CA  THR A 107      46.813  83.122  31.227  1.00 10.68           C  
ATOM    401  C   THR A 107      47.310  83.042  29.790  1.00 10.32           C  
ATOM    402  O   THR A 107      47.698  84.036  29.206  1.00 10.77           O  
ATOM    403  CB  THR A 107      47.870  82.515  32.156  1.00 13.42           C  
ATOM    404  OG1 THR A 107      47.470  82.719  33.520  1.00 14.75           O  
ATOM    405  CG2 THR A 107      49.238  83.174  31.896  1.00 14.74           C  
ATOM    406  N   TYR A 108      47.259  81.845  29.205  1.00  8.91           N  
ATOM    407  CA  TYR A 108      47.749  81.702  27.826  1.00 10.54           C  
ATOM    408  C   TYR A 108      46.844  82.405  26.818  1.00 11.12           C  
ATOM    409  O   TYR A 108      47.304  82.909  25.792  1.00 11.88           O  
ATOM    410  CB  TYR A 108      48.002  80.218  27.451  1.00 10.33           C  
ATOM    411  CG  TYR A 108      49.374  79.850  27.944  1.00 14.04           C  
ATOM    412  CD1 TYR A 108      50.484  80.505  27.434  1.00 16.37           C  
ATOM    413  CD2 TYR A 108      49.551  78.938  28.949  1.00 19.04           C  
ATOM    414  CE1 TYR A 108      51.758  80.256  27.921  1.00 20.28           C  
ATOM    415  CE2 TYR A 108      50.837  78.671  29.456  1.00 22.63           C  
ATOM    416  CZ  TYR A 108      51.926  79.343  28.927  1.00 20.95           C  
ATOM    417  OH  TYR A 108      53.203  79.095  29.423  1.00 24.49           O  
ATOM    418  N   LEU A 109      45.548  82.446  27.102  0.50 11.81           N  
ATOM    420  CA  LEU A 109      44.651  83.193  26.223  0.50 12.58           C  
ATOM    422  C   LEU A 109      45.079  84.657  26.222  0.50 13.12           C  
ATOM    424  O   LEU A 109      45.128  85.306  25.172  0.50 14.45           O  
ATOM    426  CB  LEU A 109      43.204  83.041  26.699  0.50 13.21           C  
ATOM    428  CG  LEU A 109      42.078  83.700  25.899  0.50 11.39           C  
ATOM    430  CD1 LEU A 109      42.031  83.171  24.473  0.50 14.45           C  
ATOM    432  CD2 LEU A 109      40.752  83.478  26.612  0.50 15.04           C  
ATOM    434  N   GLU A 110      45.409  85.186  27.395  1.00 12.79           N  
ATOM    435  CA  GLU A 110      45.804  86.600  27.491  1.00 13.76           C  
ATOM    436  C   GLU A 110      47.151  86.838  26.791  1.00 13.83           C  
ATOM    437  O   GLU A 110      47.361  87.847  26.115  1.00 14.60           O  
ATOM    438  CB  GLU A 110      45.881  87.043  28.957  1.00 16.30           C  
ATOM    439  CG  GLU A 110      44.536  87.015  29.670  1.00 33.29           C  
ATOM    440  CD  GLU A 110      44.621  87.543  31.097  1.00 31.36           C  
ATOM    441  OE1 GLU A 110      45.733  87.922  31.530  1.00 40.35           O  
ATOM    442  OE2 GLU A 110      43.571  87.584  31.781  1.00 39.73           O  
ATOM    443  N   VAL A 111      48.073  85.905  26.987  1.00 12.59           N  
ATOM    444  CA  VAL A 111      49.396  86.032  26.393  1.00 12.86           C  
ATOM    445  C   VAL A 111      49.309  85.902  24.862  1.00 12.44           C  
ATOM    446  O   VAL A 111      49.918  86.688  24.124  1.00 14.73           O  
ATOM    447  CB  VAL A 111      50.343  84.984  26.970  1.00 15.33           C  
ATOM    448  CG1 VAL A 111      51.666  85.026  26.244  1.00 21.50           C  
ATOM    449  CG2 VAL A 111      50.537  85.231  28.471  1.00 17.55           C  
ATOM    450  N   LEU A 112      48.547  84.929  24.367  1.00 12.17           N  
ATOM    451  CA  LEU A 112      48.382  84.799  22.913  1.00 11.87           C  
ATOM    452  C   LEU A 112      47.739  86.044  22.303  1.00 14.02           C  
ATOM    453  O   LEU A 112      48.146  86.509  21.238  1.00 14.84           O  
ATOM    454  CB  LEU A 112      47.545  83.551  22.597  1.00 11.38           C  
ATOM    455  CG  LEU A 112      48.295  82.249  22.896  1.00 12.86           C  
ATOM    456  CD1 LEU A 112      47.363  81.034  22.932  1.00 14.73           C  
ATOM    457  CD2 LEU A 112      49.440  82.053  21.851  1.00 13.54           C  
ATOM    458  N   GLN A 113      46.718  86.588  22.957  1.00 14.01           N  
ATOM    459  CA  GLN A 113      46.095  87.838  22.479  1.00 16.48           C  
ATOM    460  C   GLN A 113      47.096  88.994  22.450  1.00 17.00           C  
ATOM    461  O   GLN A 113      47.124  89.788  21.499  1.00 18.11           O  
ATOM    462  CB  GLN A 113      44.910  88.203  23.384  1.00 18.53           C  
ATOM    463  CG  GLN A 113      44.407  89.623  23.252  1.00 42.77           C  
ATOM    464  CD  GLN A 113      43.233  89.888  24.177  1.00 31.73           C  
ATOM    465  OE1 GLN A 113      43.386  90.520  25.225  1.00 48.11           O  
ATOM    466  NE2 GLN A 113      42.061  89.380  23.810  1.00 45.37           N  
ATOM    467  N   SER A 114      47.911  89.108  23.498  1.00 15.31           N  
ATOM    468  CA  SER A 114      48.844  90.222  23.599  1.00 16.22           C  
ATOM    469  C   SER A 114      49.913  90.113  22.518  1.00 17.05           C  
ATOM    470  O   SER A 114      50.453  91.119  22.047  1.00 17.87           O  
ATOM    471  CB  SER A 114      49.480  90.277  24.995  1.00 17.29           C  
ATOM    472  OG  SER A 114      50.493  89.287  25.135  1.00 30.69           O  
ATOM    473  N   HIS A 115      50.193  88.877  22.098  1.00 16.74           N  
ATOM    474  CA  HIS A 115      51.149  88.613  21.005  1.00 15.99           C  
ATOM    475  C   HIS A 115      50.518  88.606  19.615  1.00 17.50           C  
ATOM    476  O   HIS A 115      51.203  88.353  18.618  1.00 19.78           O  
ATOM    477  CB  HIS A 115      51.888  87.297  21.256  1.00 16.70           C  
ATOM    478  CG  HIS A 115      52.961  87.428  22.280  1.00 21.15           C  
ATOM    479  ND1 HIS A 115      52.698  87.402  23.633  1.00 19.63           N  
ATOM    480  CD2 HIS A 115      54.290  87.659  22.158  1.00 22.05           C  
ATOM    481  CE1 HIS A 115      53.823  87.579  24.300  1.00 27.68           C  
ATOM    482  NE2 HIS A 115      54.803  87.743  23.428  1.00 21.62           N  
ATOM    483  N   ARG A 116      49.223  88.878  19.550  1.00 16.54           N  
ATOM    484  CA  ARG A 116      48.538  89.076  18.282  1.00 17.58           C  
ATOM    485  C   ARG A 116      48.691  87.891  17.337  1.00 18.00           C  
ATOM    486  O   ARG A 116      48.950  88.065  16.131  1.00 17.92           O  
ATOM    487  CB  ARG A 116      49.045  90.347  17.582  1.00 20.31           C  
ATOM    488  CG  ARG A 116      48.677  91.640  18.293  1.00 37.05           C  
ATOM    489  CD  ARG A 116      49.133  92.831  17.449  1.00 35.66           C  
ATOM    490  NE  ARG A 116      48.416  94.058  17.782  1.00 44.15           N  
ATOM    491  CZ  ARG A 116      47.294  94.452  17.189  1.00 42.78           C  
ATOM    492  NH1 ARG A 116      46.745  93.706  16.235  1.00 45.62           N  
ATOM    493  NH2 ARG A 116      46.710  95.583  17.563  1.00 46.50           N  
ATOM    494  N   VAL A 117      48.552  86.687  17.864  1.00 15.78           N  
ATOM    495  CA  VAL A 117      48.541  85.518  16.965  1.00 14.65           C  
ATOM    496  C   VAL A 117      47.345  85.591  16.032  1.00 14.15           C  
ATOM    497  O   VAL A 117      46.354  86.276  16.320  1.00 14.38           O  
ATOM    498  CB  VAL A 117      48.559  84.183  17.747  1.00 14.52           C  
ATOM    499  CG1 VAL A 117      49.826  84.114  18.594  1.00 16.97           C  
ATOM    500  CG2 VAL A 117      47.298  84.028  18.612  1.00 14.32           C  
ATOM    501  N   ALA A 118      47.404  84.859  14.919  1.00 12.15           N  
ATOM    502  CA  ALA A 118      46.356  84.944  13.930  1.00 13.08           C  
ATOM    503  C   ALA A 118      45.117  84.180  14.357  1.00 13.14           C  
ATOM    504  O   ALA A 118      44.007  84.483  13.925  1.00 13.30           O  
ATOM    505  CB  ALA A 118      46.851  84.380  12.590  1.00 15.64           C  
ATOM    506  N   GLY A 119      45.321  83.151  15.172  1.00 11.78           N  
ATOM    507  CA  GLY A 119      44.206  82.303  15.594  1.00 10.95           C  
ATOM    508  C   GLY A 119      44.656  81.411  16.740  1.00  8.78           C  
ATOM    509  O   GLY A 119      45.841  81.295  16.997  1.00  9.72           O  
ATOM    510  N   ILE A 120      43.686  80.820  17.433  1.00  8.38           N  
ATOM    511  CA  ILE A 120      43.959  79.967  18.585  1.00  8.52           C  
ATOM    512  C   ILE A 120      43.172  78.668  18.444  1.00  8.89           C  
ATOM    513  O   ILE A 120      41.994  78.685  18.035  1.00  9.51           O  
ATOM    514  CB  ILE A 120      43.511  80.676  19.877  1.00 10.08           C  
ATOM    515  CG1 ILE A 120      44.394  81.919  20.096  1.00 10.38           C  
ATOM    516  CG2 ILE A 120      43.558  79.721  21.091  1.00 11.55           C  
ATOM    517  CD1 ILE A 120      43.948  82.775  21.336  1.00 15.74           C  
ATOM    518  N   ILE A 121      43.827  77.554  18.758  1.00  7.82           N  
ATOM    519  CA  ILE A 121      43.176  76.239  18.833  1.00  7.70           C  
ATOM    520  C   ILE A 121      43.139  75.891  20.310  1.00  9.34           C  
ATOM    521  O   ILE A 121      44.180  75.710  20.922  1.00  9.71           O  
ATOM    522  CB  ILE A 121      43.984  75.157  18.060  1.00  7.64           C  
ATOM    523  CG1 ILE A 121      44.080  75.544  16.584  1.00  9.91           C  
ATOM    524  CG2 ILE A 121      43.320  73.762  18.242  1.00  9.78           C  
ATOM    525  CD1 ILE A 121      45.250  74.804  15.827  1.00  9.73           C  
ATOM    526  N   ALA A 122      41.930  75.722  20.855  0.50  9.26           N  
ATOM    528  CA  ALA A 122      41.707  75.542  22.292  0.50  8.43           C  
ATOM    530  C   ALA A 122      41.296  74.105  22.630  0.50  8.07           C  
ATOM    532  O   ALA A 122      40.144  73.698  22.402  0.50  6.58           O  
ATOM    534  CB  ALA A 122      40.619  76.527  22.750  0.50  9.46           C  
ATOM    536  N   SER A 123      42.229  73.337  23.189  0.50  9.81           N  
ATOM    538  CA  SER A 123      41.988  71.911  23.426  0.50  9.69           C  
ATOM    540  C   SER A 123      41.439  71.655  24.826  0.50 10.15           C  
ATOM    542  O   SER A 123      41.971  72.173  25.831  0.50  9.40           O  
ATOM    544  CB  SER A 123      43.263  71.052  23.180  0.50 11.06           C  
ATOM    546  OG  SER A 123      43.754  71.264  21.874  0.50 16.27           O  
ATOM    548  N   ARG A 124      40.380  70.849  24.898  1.00  9.65           N  
ATOM    549  CA  ARG A 124      39.879  70.415  26.186  1.00 10.33           C  
ATOM    550  C   ARG A 124      39.693  71.620  27.128  1.00 11.23           C  
ATOM    551  O   ARG A 124      40.030  71.586  28.332  1.00 13.56           O  
ATOM    552  CB  ARG A 124      40.797  69.327  26.780  1.00 12.09           C  
ATOM    553  CG  ARG A 124      40.053  68.337  27.638  1.00 16.12           C  
ATOM    554  CD  ARG A 124      40.731  66.970  27.597  1.00 10.75           C  
ATOM    555  NE  ARG A 124      42.012  66.974  28.323  1.00  9.74           N  
ATOM    556  CZ  ARG A 124      42.844  65.931  28.318  1.00 10.95           C  
ATOM    557  NH1 ARG A 124      43.974  65.969  29.019  1.00 11.14           N  
ATOM    558  NH2 ARG A 124      42.515  64.829  27.626  1.00 10.22           N  
ATOM    559  N   SER A 125      39.122  72.681  26.577  1.00 10.24           N  
ATOM    560  CA  SER A 125      38.983  73.936  27.319  1.00 11.17           C  
ATOM    561  C   SER A 125      38.096  73.812  28.555  1.00 11.76           C  
ATOM    562  O   SER A 125      37.064  73.127  28.530  1.00 12.73           O  
ATOM    563  CB  SER A 125      38.372  75.016  26.402  1.00 13.25           C  
ATOM    564  OG  SER A 125      38.185  76.241  27.130  1.00 17.60           O  
ATOM    565  N   GLN A 126      38.472  74.535  29.614  1.00 12.75           N  
ATOM    566  CA  GLN A 126      37.606  74.690  30.790  1.00 14.97           C  
ATOM    567  C   GLN A 126      37.038  76.098  30.966  1.00 19.23           C  
ATOM    568  O   GLN A 126      36.337  76.386  31.947  1.00 21.27           O  
ATOM    569  CB  GLN A 126      38.329  74.254  32.053  1.00 14.54           C  
ATOM    570  CG  GLN A 126      38.680  72.773  32.001  1.00 22.52           C  
ATOM    571  CD  GLN A 126      39.283  72.286  33.288  1.00 22.23           C  
ATOM    572  OE1 GLN A 126      38.997  72.823  34.371  1.00 25.64           O  
ATOM    573  NE2 GLN A 126      40.121  71.265  33.194  1.00 21.75           N  
ATOM    574  N   CYS A 127      37.315  76.975  30.022  1.00 20.90           N  
ATOM    575  CA  CYS A 127      36.694  78.305  30.056  1.00 24.29           C  
ATOM    576  C   CYS A 127      35.430  78.408  29.227  1.00 26.31           C  
ATOM    577  O   CYS A 127      35.022  77.475  28.527  1.00 26.18           O  
ATOM    578  CB  CYS A 127      37.665  79.352  29.557  1.00 25.37           C  
ATOM    579  SG  CYS A 127      39.232  79.259  30.410  1.00 40.65           S  
ATOM    580  N   GLU A 128      34.825  79.584  29.312  1.00 27.92           N  
ATOM    581  CA  GLU A 128      33.639  79.904  28.571  1.00 29.37           C  
ATOM    582  C   GLU A 128      33.706  81.414  28.427  1.00 30.44           C  
ATOM    583  O   GLU A 128      34.119  81.928  27.396  1.00 29.66           O  
ATOM    584  CB  GLU A 128      32.418  79.483  29.389  1.00 30.16           C  
ATOM    585  CG  GLU A 128      31.079  79.875  28.797  1.00 37.15           C  
ATOM    586  CD  GLU A 128      29.935  79.075  29.391  1.00 36.38           C  
ATOM    587  OE1 GLU A 128      30.206  78.007  29.984  1.00 39.08           O  
ATOM    588  OE2 GLU A 128      28.767  79.511  29.265  1.00 41.53           O  
ATOM    589  N   ASP A 129      33.300  82.086  29.500  1.00 32.63           N  
ATOM    590  CA  ASP A 129      33.534  83.503  29.790  1.00 33.64           C  
ATOM    591  C   ASP A 129      34.657  84.198  29.047  1.00 31.49           C  
ATOM    592  O   ASP A 129      34.446  85.180  28.326  1.00 31.00           O  
ATOM    593  CB  ASP A 129      33.902  83.650  31.274  1.00 35.85           C  
ATOM    594  CG  ASP A 129      32.847  83.094  32.213  1.00 55.60           C  
ATOM    595  OD1 ASP A 129      32.048  82.223  31.795  1.00 39.80           O  
ATOM    596  OD2 ASP A 129      32.845  83.532  33.389  1.00 42.30           O  
ATOM    597  N   GLU A 130      35.869  83.725  29.309  1.00 29.65           N  
ATOM    598  CA  GLU A 130      37.084  84.388  28.868  1.00 27.52           C  
ATOM    599  C   GLU A 130      37.146  84.567  27.363  1.00 24.75           C  
ATOM    600  O   GLU A 130      37.827  85.463  26.866  1.00 23.57           O  
ATOM    601  CB  GLU A 130      38.310  83.610  29.345  1.00 28.63           C  
ATOM    602  CG  GLU A 130      38.612  83.790  30.821  1.00 58.65           C  
ATOM    603  CD  GLU A 130      37.444  83.408  31.713  1.00 34.54           C  
ATOM    604  OE1 GLU A 130      36.643  82.529  31.318  1.00 59.24           O  
ATOM    605  OE2 GLU A 130      37.344  83.973  32.826  1.00 59.45           O  
ATOM    606  N   TYR A 131      36.428  83.719  26.637  1.00 24.07           N  
ATOM    607  CA  TYR A 131      36.498  83.736  25.184  1.00 24.44           C  
ATOM    608  C   TYR A 131      35.546  84.727  24.527  1.00 27.74           C  
ATOM    609  O   TYR A 131      35.668  85.010  23.329  1.00 28.77           O  
ATOM    610  CB  TYR A 131      36.213  82.338  24.646  1.00 22.86           C  
ATOM    611  CG  TYR A 131      37.388  81.414  24.817  1.00 17.00           C  
ATOM    612  CD1 TYR A 131      38.325  81.296  23.824  1.00 18.83           C  
ATOM    613  CD2 TYR A 131      37.560  80.671  25.983  1.00 17.68           C  
ATOM    614  CE1 TYR A 131      39.413  80.455  23.947  1.00 17.61           C  
ATOM    615  CE2 TYR A 131      38.634  79.819  26.115  1.00 16.58           C  
ATOM    616  CZ  TYR A 131      39.564  79.727  25.085  1.00 19.25           C  
ATOM    617  OH  TYR A 131      40.665  78.908  25.168  1.00 20.68           O  
ATOM    618  N   ALA A 132      34.610  85.254  25.314  1.00 28.52           N  
ATOM    619  CA  ALA A 132      33.492  86.019  24.766  1.00 31.95           C  
ATOM    620  C   ALA A 132      33.916  87.336  24.125  1.00 35.78           C  
ATOM    621  O   ALA A 132      33.303  87.797  23.160  1.00 37.21           O  
ATOM    622  CB  ALA A 132      32.445  86.270  25.856  1.00 31.01           C  
ATOM    623  N   ASN A 133      34.963  87.944  24.661  1.00 38.02           N  
ATOM    624  CA  ASN A 133      35.389  89.244  24.176  1.00 41.43           C  
ATOM    625  C   ASN A 133      36.623  89.168  23.285  1.00 43.48           C  
ATOM    626  O   ASN A 133      36.821  90.015  22.411  1.00 44.70           O  
ATOM    627  CB  ASN A 133      35.627  90.179  25.362  1.00 42.36           C  
ATOM    628  CG  ASN A 133      35.867  89.421  26.653  1.00 54.46           C  
ATOM    629  OD1 ASN A 133      35.382  89.817  27.718  1.00 45.15           O  
ATOM    630  ND2 ASN A 133      36.598  88.306  26.564  1.00 43.93           N  
ATOM    631  N   ILE A 134      37.452  88.153  23.500  1.00 43.62           N  
ATOM    632  CA  ILE A 134      38.666  88.045  22.715  1.00 43.16           C  
ATOM    633  C   ILE A 134      38.248  88.244  21.271  1.00 42.51           C  
ATOM    634  O   ILE A 134      37.163  87.825  20.871  1.00 44.41           O  
ATOM    635  CB  ILE A 134      39.395  86.709  22.940  1.00 43.08           C  
ATOM    636  CG1 ILE A 134      38.975  85.664  21.911  1.00 50.22           C  
ATOM    637  CG2 ILE A 134      39.154  86.203  24.358  1.00 50.97           C  
ATOM    638  CD1 ILE A 134      39.810  84.397  21.992  1.00 43.17           C  
ATOM    639  N   ASP A 135      39.077  88.937  20.503  1.00 39.74           N  
ATOM    640  CA  ASP A 135      38.728  89.277  19.138  1.00 37.06           C  
ATOM    641  C   ASP A 135      39.704  88.593  18.194  1.00 32.53           C  
ATOM    642  O   ASP A 135      40.275  89.215  17.301  1.00 34.23           O  
ATOM    643  CB  ASP A 135      38.791  90.792  18.948  1.00 38.92           C  
ATOM    644  CG  ASP A 135      38.100  91.243  17.688  1.00 49.62           C  
ATOM    645  OD1 ASP A 135      37.096  91.978  17.794  1.00 43.37           O  
ATOM    646  OD2 ASP A 135      38.555  90.849  16.595  1.00 46.03           O  
ATOM    647  N   ILE A 136      39.902  87.304  18.419  1.00 25.61           N  
ATOM    648  CA  ILE A 136      40.854  86.520  17.653  1.00 20.50           C  
ATOM    649  C   ILE A 136      40.119  85.238  17.314  1.00 16.76           C  
ATOM    650  O   ILE A 136      39.373  84.725  18.150  1.00 16.32           O  
ATOM    651  CB  ILE A 136      42.096  86.178  18.497  1.00 20.89           C  
ATOM    652  CG1 ILE A 136      42.946  87.430  18.744  1.00 26.89           C  
ATOM    653  CG2 ILE A 136      42.953  85.142  17.799  1.00 22.97           C  
ATOM    654  CD1 ILE A 136      44.230  87.144  19.520  1.00 26.62           C  
ATOM    655  N   PRO A 137      40.296  84.726  16.092  1.00 14.67           N  
ATOM    656  CA  PRO A 137      39.622  83.477  15.709  1.00 12.27           C  
ATOM    657  C   PRO A 137      40.019  82.314  16.608  1.00 11.03           C  
ATOM    658  O   PRO A 137      41.210  82.151  16.924  1.00 11.24           O  
ATOM    659  CB  PRO A 137      40.142  83.218  14.287  1.00 13.40           C  
ATOM    660  CG  PRO A 137      40.415  84.649  13.753  1.00 14.44           C  
ATOM    661  CD  PRO A 137      40.949  85.400  14.947  1.00 15.38           C  
ATOM    662  N   VAL A 138      39.035  81.505  16.987  1.00  9.65           N  
ATOM    663  CA  VAL A 138      39.267  80.344  17.850  1.00  9.45           C  
ATOM    664  C   VAL A 138      38.476  79.165  17.298  1.00 10.01           C  
ATOM    665  O   VAL A 138      37.321  79.337  16.863  1.00 10.87           O  
ATOM    666  CB  VAL A 138      38.725  80.584  19.303  1.00  9.31           C  
ATOM    667  CG1 VAL A 138      38.831  79.298  20.142  1.00 11.53           C  
ATOM    668  CG2 VAL A 138      39.468  81.721  19.981  1.00 12.93           C  
ATOM    669  N   VAL A 139      39.086  77.978  17.290  1.00  9.19           N  
ATOM    670  CA  VAL A 139      38.346  76.723  17.154  1.00  9.18           C  
ATOM    671  C   VAL A 139      38.699  75.837  18.350  1.00  9.59           C  
ATOM    672  O   VAL A 139      39.759  76.022  18.965  1.00 10.08           O  
ATOM    673  CB  VAL A 139      38.616  75.968  15.855  1.00  9.79           C  
ATOM    674  CG1 VAL A 139      38.198  76.836  14.666  1.00  8.41           C  
ATOM    675  CG2 VAL A 139      40.103  75.559  15.721  1.00 10.26           C  
ATOM    676  N   ALA A 140      37.800  74.918  18.706  1.00  8.33           N  
ATOM    677  CA  ALA A 140      37.987  74.127  19.942  1.00  9.36           C  
ATOM    678  C   ALA A 140      38.122  72.668  19.599  1.00  9.47           C  
ATOM    679  O   ALA A 140      37.439  72.181  18.700  1.00 10.42           O  
ATOM    680  CB  ALA A 140      36.777  74.290  20.856  1.00 10.47           C  
ATOM    681  N   PHE A 141      39.020  71.973  20.298  1.00  9.58           N  
ATOM    682  CA  PHE A 141      39.062  70.495  20.248  1.00  9.73           C  
ATOM    683  C   PHE A 141      38.351  69.884  21.481  1.00  9.75           C  
ATOM    684  O   PHE A 141      38.709  70.214  22.626  1.00 10.19           O  
ATOM    685  CB  PHE A 141      40.529  70.007  20.125  1.00  9.86           C  
ATOM    686  CG  PHE A 141      40.683  68.494  20.158  1.00 10.67           C  
ATOM    687  CD1 PHE A 141      40.158  67.704  19.142  1.00 11.58           C  
ATOM    688  CD2 PHE A 141      41.355  67.876  21.205  1.00  9.74           C  
ATOM    689  CE1 PHE A 141      40.316  66.298  19.183  1.00  9.96           C  
ATOM    690  CE2 PHE A 141      41.509  66.478  21.251  1.00 10.55           C  
ATOM    691  CZ  PHE A 141      40.990  65.707  20.246  1.00 11.26           C  
ATOM    692  N   GLU A 142      37.319  69.066  21.228  1.00  9.60           N  
ATOM    693  CA  GLU A 142      36.535  68.336  22.252  1.00 10.66           C  
ATOM    694  C   GLU A 142      35.538  69.113  23.071  1.00 12.29           C  
ATOM    695  O   GLU A 142      34.333  68.821  23.028  1.00 12.69           O  
ATOM    696  CB  GLU A 142      37.431  67.525  23.187  1.00 11.07           C  
ATOM    697  CG  GLU A 142      38.066  66.375  22.405  1.00 12.53           C  
ATOM    698  CD  GLU A 142      38.860  65.406  23.275  1.00 13.27           C  
ATOM    699  OE1 GLU A 142      39.224  64.323  22.749  1.00 11.75           O  
ATOM    700  OE2 GLU A 142      39.116  65.724  24.462  1.00  9.99           O  
ATOM    701  N   ASN A 143      36.027  70.031  23.907  1.00  9.37           N  
ATOM    702  CA  ASN A 143      35.109  70.679  24.826  1.00  8.74           C  
ATOM    703  C   ASN A 143      34.508  71.907  24.170  1.00 10.37           C  
ATOM    704  O   ASN A 143      35.222  72.710  23.555  1.00 12.57           O  
ATOM    705  CB  ASN A 143      35.843  71.120  26.099  1.00  8.24           C  
ATOM    706  CG  ASN A 143      36.102  69.983  27.062  1.00 10.89           C  
ATOM    707  OD1 ASN A 143      35.791  68.824  26.798  1.00  9.86           O  
ATOM    708  ND2 ASN A 143      36.686  70.326  28.215  1.00 10.94           N  
ATOM    709  N   HIS A 144      33.201  72.051  24.333  1.00 10.03           N  
ATOM    710  CA  HIS A 144      32.480  73.200  23.791  1.00  9.42           C  
ATOM    711  C   HIS A 144      32.779  74.424  24.632  1.00 12.57           C  
ATOM    712  O   HIS A 144      32.747  74.363  25.856  1.00 16.22           O  
ATOM    713  CB  HIS A 144      30.979  72.900  23.816  1.00 10.13           C  
ATOM    714  CG  HIS A 144      30.579  71.864  22.814  1.00 11.43           C  
ATOM    715  ND1 HIS A 144      30.696  70.510  23.052  1.00 15.22           N  
ATOM    716  CD2 HIS A 144      30.107  71.984  21.548  1.00 12.55           C  
ATOM    717  CE1 HIS A 144      30.316  69.839  21.976  1.00 15.32           C  
ATOM    718  NE2 HIS A 144      29.954  70.709  21.050  1.00 17.72           N  
ATOM    719  N   ILE A 145      32.996  75.562  23.985  1.00 11.28           N  
ATOM    720  CA  ILE A 145      33.362  76.760  24.713  1.00 12.31           C  
ATOM    721  C   ILE A 145      32.211  77.750  24.727  1.00 15.18           C  
ATOM    722  O   ILE A 145      31.625  78.031  25.792  1.00 16.89           O  
ATOM    723  CB  ILE A 145      34.634  77.364  24.096  1.00 12.31           C  
ATOM    724  CG1 ILE A 145      35.736  76.333  24.198  1.00 12.02           C  
ATOM    725  CG2 ILE A 145      35.074  78.608  24.894  1.00 16.00           C  
ATOM    726  CD1 ILE A 145      37.088  76.842  23.684  1.00 13.56           C  
ATOM    727  N   LEU A 146      31.872  78.243  23.549  1.00 14.57           N  
ATOM    728  CA  LEU A 146      30.721  79.129  23.401  1.00 15.66           C  
ATOM    729  C   LEU A 146      30.003  78.712  22.139  1.00 16.13           C  
ATOM    730  O   LEU A 146      30.599  78.063  21.271  1.00 15.15           O  
ATOM    731  CB  LEU A 146      31.177  80.562  23.249  1.00 16.43           C  
ATOM    732  CG  LEU A 146      31.862  81.224  24.448  1.00 20.35           C  
ATOM    733  CD1 LEU A 146      32.489  82.540  24.019  1.00 19.23           C  
ATOM    734  CD2 LEU A 146      30.884  81.451  25.616  1.00 20.75           C  
ATOM    735  N   ASP A 147      28.739  79.110  22.019  1.00 15.96           N  
ATOM    736  CA  ASP A 147      27.943  78.641  20.904  1.00 17.31           C  
ATOM    737  C   ASP A 147      28.467  79.181  19.574  1.00 15.87           C  
ATOM    738  O   ASP A 147      28.086  78.684  18.499  1.00 17.15           O  
ATOM    739  CB  ASP A 147      26.482  79.064  21.107  1.00 18.64           C  
ATOM    740  CG  ASP A 147      25.844  78.364  22.287  1.00 35.44           C  
ATOM    741  OD1 ASP A 147      26.399  77.339  22.721  1.00 28.98           O  
ATOM    742  OD2 ASP A 147      24.805  78.835  22.791  1.00 32.55           O  
ATOM    743  N   ASN A 148      29.332  80.188  19.621  1.00 13.91           N  
ATOM    744  CA  ASN A 148      29.838  80.735  18.374  1.00 13.81           C  
ATOM    745  C   ASN A 148      31.259  80.296  18.041  1.00 12.38           C  
ATOM    746  O   ASN A 148      31.894  80.879  17.182  1.00 12.69           O  
ATOM    747  CB  ASN A 148      29.691  82.262  18.310  1.00 17.15           C  
ATOM    748  CG  ASN A 148      30.586  82.974  19.280  1.00 26.69           C  
ATOM    749  OD1 ASN A 148      31.089  82.380  20.234  1.00 21.94           O  
ATOM    750  ND2 ASN A 148      30.781  84.275  19.056  1.00 30.40           N  
ATOM    751  N   ILE A 149      31.716  79.209  18.681  1.00 10.37           N  
ATOM    752  CA  ILE A 149      33.042  78.618  18.392  1.00  8.22           C  
ATOM    753  C   ILE A 149      32.849  77.170  17.952  1.00  9.42           C  
ATOM    754  O   ILE A 149      32.186  76.392  18.639  1.00 10.18           O  
ATOM    755  CB  ILE A 149      33.940  78.680  19.649  1.00  8.95           C  
ATOM    756  CG1 ILE A 149      34.275  80.151  19.958  1.00  9.92           C  
ATOM    757  CG2 ILE A 149      35.220  77.830  19.468  1.00 12.33           C  
ATOM    758  CD1 ILE A 149      34.955  80.329  21.324  1.00 12.83           C  
ATOM    759  N   ILE A 150      33.408  76.825  16.786  1.00  9.04           N  
ATOM    760  CA  ILE A 150      33.299  75.475  16.245  1.00  9.89           C  
ATOM    761  C   ILE A 150      34.060  74.498  17.113  1.00  9.55           C  
ATOM    762  O   ILE A 150      35.179  74.789  17.521  1.00  9.96           O  
ATOM    763  CB  ILE A 150      33.943  75.417  14.863  1.00 10.45           C  
ATOM    764  CG1 ILE A 150      33.105  76.246  13.869  1.00 13.16           C  
ATOM    765  CG2 ILE A 150      34.041  73.937  14.362  1.00 11.23           C  
ATOM    766  CD1 ILE A 150      33.818  76.456  12.506  1.00 14.91           C  
ATOM    767  N   THR A 151      33.478  73.337  17.359  1.00  8.44           N  
ATOM    768  CA  THR A 151      34.134  72.280  18.155  1.00 10.15           C  
ATOM    769  C   THR A 151      34.370  71.062  17.251  1.00 10.99           C  
ATOM    770  O   THR A 151      33.428  70.560  16.589  1.00 12.56           O  
ATOM    771  CB  THR A 151      33.218  71.853  19.330  1.00 12.31           C  
ATOM    772  OG1 THR A 151      32.789  73.012  20.062  1.00 18.07           O  
ATOM    773  CG2 THR A 151      33.942  70.898  20.264  1.00 13.62           C  
ATOM    774  N   ILE A 152      35.618  70.579  17.211  1.00  8.58           N  
ATOM    775  CA  ILE A 152      35.998  69.421  16.418  1.00  8.44           C  
ATOM    776  C   ILE A 152      36.325  68.299  17.412  1.00  8.48           C  
ATOM    777  O   ILE A 152      36.998  68.529  18.418  1.00  9.16           O  
ATOM    778  CB  ILE A 152      37.287  69.729  15.581  1.00  8.74           C  
ATOM    779  CG1 ILE A 152      37.089  70.921  14.617  1.00 11.69           C  
ATOM    780  CG2 ILE A 152      37.730  68.504  14.775  1.00  9.61           C  
ATOM    781  CD1 ILE A 152      37.428  72.353  15.237  1.00 10.49           C  
ATOM    782  N   SER A 153      35.887  67.089  17.126  1.00  9.27           N  
ATOM    783  CA  SER A 153      36.157  65.988  18.032  1.00  9.54           C  
ATOM    784  C   SER A 153      36.135  64.680  17.294  1.00  9.76           C  
ATOM    785  O   SER A 153      35.681  64.646  16.155  1.00 10.29           O  
ATOM    786  CB  SER A 153      35.085  65.995  19.110  1.00 12.41           C  
ATOM    787  OG  SER A 153      35.363  65.013  20.095  1.00 27.13           O  
ATOM    788  N   SER A 154      36.641  63.603  17.907  1.00  8.83           N  
ATOM    789  CA  SER A 154      36.364  62.276  17.373  1.00  8.92           C  
ATOM    790  C   SER A 154      34.974  61.836  17.827  1.00  9.90           C  
ATOM    791  O   SER A 154      34.379  62.464  18.691  1.00 10.30           O  
ATOM    792  CB  SER A 154      37.387  61.248  17.855  1.00  9.72           C  
ATOM    793  OG  SER A 154      38.700  61.543  17.356  1.00 10.73           O  
ATOM    794  N   ASP A 155      34.477  60.740  17.257  1.00  8.52           N  
ATOM    795  CA  ASP A 155      33.169  60.204  17.635  1.00  8.50           C  
ATOM    796  C   ASP A 155      33.288  59.400  18.917  1.00  9.23           C  
ATOM    797  O   ASP A 155      33.292  58.170  18.935  1.00  9.87           O  
ATOM    798  CB  ASP A 155      32.623  59.357  16.471  1.00  9.28           C  
ATOM    799  CG  ASP A 155      31.205  58.922  16.679  1.00 13.59           C  
ATOM    800  OD1 ASP A 155      30.604  59.224  17.743  1.00 13.06           O  
ATOM    801  OD2 ASP A 155      30.722  58.225  15.756  1.00 14.84           O  
ATOM    802  N   ASN A 156      33.401  60.124  20.014  1.00  8.21           N  
ATOM    803  CA  ASN A 156      33.699  59.466  21.283  1.00  8.23           C  
ATOM    804  C   ASN A 156      32.565  58.603  21.829  1.00  7.37           C  
ATOM    805  O   ASN A 156      32.810  57.570  22.472  1.00  7.96           O  
ATOM    806  CB  ASN A 156      34.116  60.556  22.265  1.00  8.88           C  
ATOM    807  CG  ASN A 156      35.502  61.074  21.935  1.00  8.23           C  
ATOM    808  OD1 ASN A 156      36.446  60.283  21.842  1.00 10.11           O  
ATOM    809  ND2 ASN A 156      35.617  62.392  21.683  1.00 10.24           N  
ATOM    810  N   TYR A 157      31.327  58.995  21.552  1.00  8.64           N  
ATOM    811  CA  TYR A 157      30.208  58.200  22.017  1.00  8.93           C  
ATOM    812  C   TYR A 157      30.234  56.829  21.344  1.00  8.37           C  
ATOM    813  O   TYR A 157      30.183  55.777  22.005  1.00  8.65           O  
ATOM    814  CB  TYR A 157      28.870  58.909  21.730  1.00 10.01           C  
ATOM    815  CG  TYR A 157      27.720  58.016  22.112  1.00 11.77           C  
ATOM    816  CD1 TYR A 157      27.246  57.970  23.427  1.00 10.38           C  
ATOM    817  CD2 TYR A 157      27.150  57.159  21.176  1.00 14.12           C  
ATOM    818  CE1 TYR A 157      26.211  57.118  23.789  1.00  9.82           C  
ATOM    819  CE2 TYR A 157      26.136  56.295  21.534  1.00 10.67           C  
ATOM    820  CZ  TYR A 157      25.670  56.279  22.837  1.00 10.02           C  
ATOM    821  OH  TYR A 157      24.671  55.383  23.185  1.00 14.37           O  
ATOM    822  N   ASN A 158      30.308  56.822  20.049  1.00  8.89           N  
ATOM    823  CA  ASN A 158      30.316  55.557  19.338  1.00  8.89           C  
ATOM    824  C   ASN A 158      31.581  54.736  19.607  1.00  9.29           C  
ATOM    825  O   ASN A 158      31.509  53.555  19.677  1.00  9.82           O  
ATOM    826  CB  ASN A 158      30.104  55.731  17.844  1.00  9.74           C  
ATOM    827  CG  ASN A 158      28.658  56.018  17.485  1.00 14.31           C  
ATOM    828  OD1 ASN A 158      27.754  55.520  18.071  1.00 16.39           O  
ATOM    829  ND2 ASN A 158      28.491  56.815  16.489  1.00  9.18           N  
ATOM    830  N   GLY A 159      32.700  55.418  19.832  1.00  8.44           N  
ATOM    831  CA  GLY A 159      33.922  54.697  20.222  1.00  8.25           C  
ATOM    832  C   GLY A 159      33.744  53.983  21.537  1.00  9.13           C  
ATOM    833  O   GLY A 159      34.218  52.855  21.681  1.00  8.86           O  
ATOM    834  N   GLY A 160      33.039  54.597  22.494  1.00  8.84           N  
ATOM    835  CA  GLY A 160      32.787  53.879  23.759  1.00  9.33           C  
ATOM    836  C   GLY A 160      31.876  52.681  23.541  1.00 10.33           C  
ATOM    837  O   GLY A 160      32.091  51.612  24.144  1.00 10.65           O  
ATOM    838  N   ARG A 161      30.848  52.833  22.704  1.00  9.62           N  
ATOM    839  CA  ARG A 161      30.010  51.659  22.374  1.00 10.05           C  
ATOM    840  C   ARG A 161      30.841  50.558  21.724  1.00  9.93           C  
ATOM    841  O   ARG A 161      30.672  49.367  22.044  1.00 11.41           O  
ATOM    842  CB  ARG A 161      28.859  52.061  21.463  1.00 12.01           C  
ATOM    843  CG  ARG A 161      27.998  50.844  21.110  1.00 15.74           C  
ATOM    844  CD  ARG A 161      27.497  50.110  22.377  1.00 21.10           C  
ATOM    845  NE  ARG A 161      26.583  48.998  22.056  1.00 20.42           N  
ATOM    846  CZ  ARG A 161      25.264  49.139  21.922  1.00 27.88           C  
ATOM    847  NH1 ARG A 161      24.700  50.348  22.056  1.00 23.09           N  
ATOM    848  NH2 ARG A 161      24.501  48.077  21.649  1.00 24.53           N  
ATOM    849  N   MET A 162      31.725  50.942  20.795  1.00  9.45           N  
ATOM    850  CA  MET A 162      32.538  49.926  20.079  1.00 10.92           C  
ATOM    851  C   MET A 162      33.401  49.181  21.082  1.00 10.03           C  
ATOM    852  O   MET A 162      33.653  47.969  20.959  1.00 11.36           O  
ATOM    853  CB  MET A 162      33.500  50.544  19.033  1.00 12.99           C  
ATOM    854  CG  MET A 162      32.897  51.083  17.765  1.00 25.16           C  
ATOM    855  SD  MET A 162      34.200  51.866  16.727  1.00 15.53           S  
ATOM    856  CE  MET A 162      33.099  52.955  15.854  1.00 28.18           C  
ATOM    857  N   ALA A 163      33.948  49.915  22.039  1.00  9.03           N  
ATOM    858  CA  ALA A 163      34.794  49.264  23.038  1.00  9.47           C  
ATOM    859  C   ALA A 163      34.005  48.265  23.846  1.00 10.04           C  
ATOM    860  O   ALA A 163      34.485  47.160  24.103  1.00 10.10           O  
ATOM    861  CB  ALA A 163      35.442  50.311  23.959  1.00 10.41           C  
ATOM    862  N   PHE A 164      32.773  48.621  24.225  1.00  9.91           N  
ATOM    863  CA  PHE A 164      31.987  47.636  24.971  1.00 10.12           C  
ATOM    864  C   PHE A 164      31.699  46.417  24.102  1.00  9.51           C  
ATOM    865  O   PHE A 164      31.829  45.268  24.546  1.00  9.63           O  
ATOM    866  CB  PHE A 164      30.628  48.205  25.409  1.00 10.74           C  
ATOM    867  CG  PHE A 164      29.798  47.172  26.083  1.00  9.63           C  
ATOM    868  CD1 PHE A 164      29.996  46.902  27.414  1.00 10.97           C  
ATOM    869  CD2 PHE A 164      28.907  46.380  25.353  1.00 14.25           C  
ATOM    870  CE1 PHE A 164      29.274  45.892  28.056  1.00 11.71           C  
ATOM    871  CE2 PHE A 164      28.178  45.360  26.001  1.00 10.57           C  
ATOM    872  CZ  PHE A 164      28.368  45.127  27.329  1.00 12.37           C  
ATOM    873  N   ASP A 165      31.242  46.684  22.881  1.00 10.47           N  
ATOM    874  CA  ASP A 165      30.820  45.587  21.981  1.00 10.88           C  
ATOM    875  C   ASP A 165      32.003  44.639  21.775  1.00 11.33           C  
ATOM    876  O   ASP A 165      31.830  43.413  21.707  1.00 13.00           O  
ATOM    877  CB  ASP A 165      30.388  46.133  20.616  1.00 12.79           C  
ATOM    878  CG  ASP A 165      29.045  46.837  20.665  1.00 19.02           C  
ATOM    879  OD1 ASP A 165      28.324  46.681  21.673  1.00 19.48           O  
ATOM    880  OD2 ASP A 165      28.731  47.531  19.688  1.00 21.16           O  
ATOM    881  N   HIS A 166      33.215  45.191  21.690  1.00  9.98           N  
ATOM    882  CA  HIS A 166      34.383  44.326  21.455  1.00 10.41           C  
ATOM    883  C   HIS A 166      34.658  43.440  22.675  1.00 10.37           C  
ATOM    884  O   HIS A 166      34.854  42.225  22.543  1.00 11.04           O  
ATOM    885  CB  HIS A 166      35.600  45.179  21.071  1.00 10.17           C  
ATOM    886  CG  HIS A 166      36.842  44.386  20.812  1.00 13.24           C  
ATOM    887  ND1 HIS A 166      36.955  43.493  19.767  1.00 14.01           N  
ATOM    888  CD2 HIS A 166      38.037  44.377  21.453  1.00 16.42           C  
ATOM    889  CE1 HIS A 166      38.165  42.940  19.795  1.00 12.38           C  
ATOM    890  NE2 HIS A 166      38.844  43.475  20.800  1.00 17.40           N  
ATOM    891  N   LEU A 167      34.668  44.024  23.874  1.00  8.12           N  
ATOM    892  CA  LEU A 167      34.889  43.205  25.067  1.00  9.25           C  
ATOM    893  C   LEU A 167      33.803  42.140  25.179  1.00 10.84           C  
ATOM    894  O   LEU A 167      34.076  40.977  25.470  1.00 12.38           O  
ATOM    895  CB  LEU A 167      34.890  44.036  26.341  1.00  9.63           C  
ATOM    896  CG  LEU A 167      36.105  44.954  26.457  1.00 10.73           C  
ATOM    897  CD1 LEU A 167      35.987  45.706  27.767  1.00 12.37           C  
ATOM    898  CD2 LEU A 167      37.409  44.156  26.424  1.00 13.41           C  
ATOM    899  N   TYR A 168      32.557  42.528  24.982  1.00 10.15           N  
ATOM    900  CA  TYR A 168      31.435  41.570  25.108  1.00 11.46           C  
ATOM    901  C   TYR A 168      31.546  40.425  24.075  1.00 12.19           C  
ATOM    902  O   TYR A 168      31.362  39.223  24.397  1.00 13.31           O  
ATOM    903  CB  TYR A 168      30.106  42.343  24.975  1.00 12.29           C  
ATOM    904  CG  TYR A 168      28.878  41.525  25.368  1.00 13.73           C  
ATOM    905  CD1 TYR A 168      28.443  41.484  26.686  1.00 15.48           C  
ATOM    906  CD2 TYR A 168      28.206  40.787  24.429  1.00 17.12           C  
ATOM    907  CE1 TYR A 168      27.311  40.719  27.058  1.00 16.32           C  
ATOM    908  CE2 TYR A 168      27.092  40.032  24.789  1.00 16.95           C  
ATOM    909  CZ  TYR A 168      26.660  40.007  26.095  1.00 20.32           C  
ATOM    910  OH  TYR A 168      25.549  39.248  26.444  1.00 19.52           O  
ATOM    911  N   GLU A 169      31.888  40.783  22.839  1.00 12.44           N  
ATOM    912  CA  GLU A 169      32.039  39.787  21.763  1.00 12.64           C  
ATOM    913  C   GLU A 169      33.149  38.807  22.118  1.00 13.79           C  
ATOM    914  O   GLU A 169      33.059  37.617  21.767  1.00 14.84           O  
ATOM    915  CB  GLU A 169      32.370  40.471  20.435  1.00 14.87           C  
ATOM    916  CG  GLU A 169      32.880  39.513  19.342  1.00 48.07           C  
ATOM    917  CD  GLU A 169      33.805  40.189  18.323  1.00 29.13           C  
ATOM    918  OE1 GLU A 169      34.222  41.347  18.560  1.00 51.65           O  
ATOM    919  OE2 GLU A 169      34.120  39.558  17.292  1.00 51.81           O  
ATOM    920  N   LYS A 170      34.175  39.282  22.827  1.00 13.17           N  
ATOM    921  CA  LYS A 170      35.272  38.408  23.265  1.00 14.99           C  
ATOM    922  C   LYS A 170      34.994  37.711  24.591  1.00 15.91           C  
ATOM    923  O   LYS A 170      35.924  37.199  25.228  1.00 17.45           O  
ATOM    924  CB  LYS A 170      36.595  39.184  23.373  1.00 16.01           C  
ATOM    925  CG  LYS A 170      37.110  39.745  22.048  1.00 18.56           C  
ATOM    926  CD  LYS A 170      36.971  38.736  20.900  1.00 28.32           C  
ATOM    927  CE  LYS A 170      37.415  39.333  19.570  1.00 22.52           C  
ATOM    928  NZ  LYS A 170      36.872  38.571  18.389  1.00 36.88           N  
ATOM    929  N   GLY A 171      33.731  37.698  25.009  1.00 13.79           N  
ATOM    930  CA  GLY A 171      33.312  36.863  26.121  1.00 14.13           C  
ATOM    931  C   GLY A 171      33.353  37.501  27.496  1.00 14.27           C  
ATOM    932  O   GLY A 171      33.057  36.850  28.507  1.00 15.38           O  
ATOM    933  N   CYS A 172      33.659  38.798  27.553  1.00 12.95           N  
ATOM    934  CA  CYS A 172      33.761  39.423  28.861  1.00 11.90           C  
ATOM    935  C   CYS A 172      32.376  39.702  29.431  1.00 11.98           C  
ATOM    936  O   CYS A 172      31.500  40.228  28.727  1.00 11.47           O  
ATOM    937  CB  CYS A 172      34.505  40.751  28.755  1.00 12.34           C  
ATOM    938  SG  CYS A 172      36.225  40.563  28.226  1.00 14.03           S  
ATOM    939  N   ARG A 173      32.203  39.376  30.713  1.00 12.51           N  
ATOM    940  CA  ARG A 173      30.947  39.668  31.398  1.00 13.35           C  
ATOM    941  C   ARG A 173      31.142  40.435  32.708  1.00 14.50           C  
ATOM    942  O   ARG A 173      30.266  41.206  33.095  1.00 17.39           O  
ATOM    943  CB  ARG A 173      30.144  38.376  31.655  1.00 13.76           C  
ATOM    944  CG  ARG A 173      29.809  37.594  30.374  1.00 16.26           C  
ATOM    945  CD  ARG A 173      28.810  38.340  29.483  1.00 16.73           C  
ATOM    946  NE  ARG A 173      28.423  37.593  28.277  1.00 13.93           N  
ATOM    947  CZ  ARG A 173      29.029  37.672  27.096  1.00 17.77           C  
ATOM    948  NH1 ARG A 173      28.577  36.935  26.082  1.00 15.89           N  
ATOM    949  NH2 ARG A 173      30.094  38.472  26.911  1.00 12.88           N  
ATOM    950  N   LYS A 174      32.267  40.222  33.385  1.00 12.17           N  
ATOM    951  CA  LYS A 174      32.650  41.049  34.516  1.00 12.49           C  
ATOM    952  C   LYS A 174      33.534  42.144  33.945  1.00 11.47           C  
ATOM    953  O   LYS A 174      34.667  41.889  33.593  1.00 11.92           O  
ATOM    954  CB  LYS A 174      33.452  40.250  35.528  1.00 14.02           C  
ATOM    955  CG  LYS A 174      32.665  39.095  36.189  1.00 23.80           C  
ATOM    956  CD  LYS A 174      33.612  38.155  36.938  1.00 27.11           C  
ATOM    957  CE  LYS A 174      32.852  37.006  37.610  1.00 28.74           C  
ATOM    958  NZ  LYS A 174      33.768  36.196  38.468  1.00 36.70           N  
ATOM    959  N   ILE A 175      33.005  43.359  33.874  1.00 10.67           N  
ATOM    960  CA  ILE A 175      33.682  44.442  33.142  1.00 10.64           C  
ATOM    961  C   ILE A 175      33.868  45.686  33.994  1.00 10.83           C  
ATOM    962  O   ILE A 175      32.955  46.073  34.729  1.00 10.38           O  
ATOM    963  CB  ILE A 175      32.869  44.762  31.885  1.00 10.85           C  
ATOM    964  CG1 ILE A 175      32.976  43.576  30.920  1.00  9.41           C  
ATOM    965  CG2 ILE A 175      33.324  46.077  31.219  1.00 12.72           C  
ATOM    966  CD1 ILE A 175      32.005  43.666  29.735  1.00 12.97           C  
ATOM    967  N   LEU A 176      35.059  46.294  33.870  1.00  9.80           N  
ATOM    968  CA  LEU A 176      35.387  47.539  34.554  1.00  8.70           C  
ATOM    969  C   LEU A 176      35.650  48.596  33.504  1.00  8.47           C  
ATOM    970  O   LEU A 176      36.325  48.319  32.493  1.00  8.65           O  
ATOM    971  CB  LEU A 176      36.696  47.340  35.329  1.00  9.52           C  
ATOM    972  CG  LEU A 176      37.344  48.573  35.968  1.00  9.05           C  
ATOM    973  CD1 LEU A 176      36.443  49.180  37.030  1.00 10.60           C  
ATOM    974  CD2 LEU A 176      38.676  48.198  36.600  1.00 10.93           C  
ATOM    975  N   HIS A 177      35.164  49.809  33.743  1.00  8.08           N  
ATOM    976  CA  HIS A 177      35.592  50.957  32.912  1.00  7.67           C  
ATOM    977  C   HIS A 177      36.307  51.942  33.829  1.00  8.76           C  
ATOM    978  O   HIS A 177      35.731  52.405  34.819  1.00  8.70           O  
ATOM    979  CB  HIS A 177      34.397  51.627  32.220  1.00  9.50           C  
ATOM    980  CG  HIS A 177      34.743  52.904  31.513  1.00  7.82           C  
ATOM    981  ND1 HIS A 177      35.930  53.070  30.834  1.00  7.36           N  
ATOM    982  CD2 HIS A 177      34.060  54.064  31.368  1.00 11.25           C  
ATOM    983  CE1 HIS A 177      35.968  54.292  30.302  1.00  9.18           C  
ATOM    984  NE2 HIS A 177      34.840  54.906  30.601  1.00 10.64           N  
ATOM    985  N   ILE A 178      37.585  52.192  33.526  1.00  7.05           N  
ATOM    986  CA  ILE A 178      38.330  53.247  34.194  1.00  8.45           C  
ATOM    987  C   ILE A 178      38.051  54.490  33.368  1.00  8.82           C  
ATOM    988  O   ILE A 178      38.537  54.611  32.223  1.00  8.62           O  
ATOM    989  CB  ILE A 178      39.811  52.920  34.252  1.00  9.83           C  
ATOM    990  CG1 ILE A 178      39.957  51.675  35.151  1.00 11.63           C  
ATOM    991  CG2 ILE A 178      40.601  54.119  34.850  1.00 11.70           C  
ATOM    992  CD1 ILE A 178      41.367  51.111  35.289  1.00 14.64           C  
ATOM    993  N   LYS A 179      37.194  55.353  33.920  1.00  9.18           N  
ATOM    994  CA  LYS A 179      36.721  56.537  33.195  1.00  9.12           C  
ATOM    995  C   LYS A 179      37.539  57.761  33.511  1.00  9.29           C  
ATOM    996  O   LYS A 179      38.250  57.823  34.522  1.00  9.62           O  
ATOM    997  CB  LYS A 179      35.223  56.784  33.452  1.00 12.66           C  
ATOM    998  CG  LYS A 179      34.900  57.243  34.822  1.00 15.90           C  
ATOM    999  CD  LYS A 179      33.349  57.568  34.976  1.00 12.37           C  
ATOM   1000  CE  LYS A 179      32.910  58.741  34.157  1.00 17.59           C  
ATOM   1001  NZ  LYS A 179      33.473  60.064  34.587  1.00 21.34           N  
ATOM   1002  N   GLY A 180      37.470  58.724  32.612  1.00  8.95           N  
ATOM   1003  CA  GLY A 180      38.256  59.943  32.762  1.00  8.79           C  
ATOM   1004  C   GLY A 180      37.526  60.953  33.612  1.00  9.43           C  
ATOM   1005  O   GLY A 180      36.369  60.728  34.020  1.00  9.88           O  
ATOM   1006  N   PRO A 181      38.199  62.078  33.892  1.00 10.83           N  
ATOM   1007  CA  PRO A 181      37.666  63.191  34.632  1.00 13.59           C  
ATOM   1008  C   PRO A 181      36.364  63.684  33.992  1.00 13.19           C  
ATOM   1009  O   PRO A 181      36.292  63.751  32.777  1.00 12.63           O  
ATOM   1010  CB  PRO A 181      38.727  64.277  34.382  1.00 14.76           C  
ATOM   1011  CG  PRO A 181      39.971  63.585  34.192  1.00 18.82           C  
ATOM   1012  CD  PRO A 181      39.613  62.262  33.534  1.00 12.60           C  
ATOM   1013  N   GLU A 182      35.388  64.067  34.807  1.00 12.70           N  
ATOM   1014  CA  GLU A 182      34.105  64.558  34.337  1.00 13.40           C  
ATOM   1015  C   GLU A 182      34.189  65.815  33.462  1.00 11.93           C  
ATOM   1016  O   GLU A 182      33.282  66.068  32.638  1.00 13.00           O  
ATOM   1017  CB  GLU A 182      33.185  64.820  35.535  1.00 16.43           C  
ATOM   1018  CG  GLU A 182      31.775  65.166  35.176  1.00 30.26           C  
ATOM   1019  CD  GLU A 182      30.903  65.294  36.410  1.00 30.50           C  
ATOM   1020  OE1 GLU A 182      31.119  64.516  37.372  1.00 34.47           O  
ATOM   1021  OE2 GLU A 182      30.017  66.170  36.412  1.00 35.92           O  
ATOM   1022  N   VAL A 183      35.254  66.595  33.641  1.00 10.78           N  
ATOM   1023  CA  VAL A 183      35.399  67.837  32.890  1.00 10.69           C  
ATOM   1024  C   VAL A 183      35.854  67.604  31.455  1.00 10.37           C  
ATOM   1025  O   VAL A 183      35.930  68.566  30.695  1.00 10.65           O  
ATOM   1026  CB  VAL A 183      36.381  68.795  33.584  1.00 13.64           C  
ATOM   1027  CG1 VAL A 183      35.779  69.234  34.924  1.00 23.32           C  
ATOM   1028  CG2 VAL A 183      37.733  68.157  33.778  1.00 16.44           C  
ATOM   1029  N   PHE A 184      36.169  66.356  31.079  1.00  8.75           N  
ATOM   1030  CA  PHE A 184      36.526  66.063  29.686  1.00  8.25           C  
ATOM   1031  C   PHE A 184      35.266  65.576  28.985  1.00  8.50           C  
ATOM   1032  O   PHE A 184      34.831  64.430  29.212  1.00  9.17           O  
ATOM   1033  CB  PHE A 184      37.568  64.933  29.598  1.00  9.49           C  
ATOM   1034  CG  PHE A 184      38.896  65.206  30.297  1.00  8.56           C  
ATOM   1035  CD1 PHE A 184      39.260  66.476  30.734  1.00 10.58           C  
ATOM   1036  CD2 PHE A 184      39.792  64.146  30.453  1.00  8.21           C  
ATOM   1037  CE1 PHE A 184      40.514  66.678  31.373  1.00  9.31           C  
ATOM   1038  CE2 PHE A 184      41.032  64.338  31.040  1.00 10.90           C  
ATOM   1039  CZ  PHE A 184      41.383  65.612  31.493  1.00 10.23           C  
ATOM   1040  N   GLU A 185      34.661  66.416  28.145  1.00  8.15           N  
ATOM   1041  CA  GLU A 185      33.457  65.990  27.438  1.00  8.90           C  
ATOM   1042  C   GLU A 185      33.696  64.678  26.686  1.00  8.87           C  
ATOM   1043  O   GLU A 185      32.786  63.863  26.560  1.00  9.50           O  
ATOM   1044  CB  GLU A 185      32.994  67.081  26.444  1.00 10.59           C  
ATOM   1045  CG  GLU A 185      32.419  68.297  27.149  1.00 13.81           C  
ATOM   1046  CD  GLU A 185      31.814  69.304  26.182  1.00 14.81           C  
ATOM   1047  OE1 GLU A 185      31.174  68.883  25.198  1.00 17.74           O  
ATOM   1048  OE2 GLU A 185      32.050  70.492  26.391  1.00 14.92           O  
ATOM   1049  N   ALA A 186      34.895  64.511  26.140  1.00  7.88           N  
ATOM   1050  CA  ALA A 186      35.169  63.322  25.334  1.00  9.19           C  
ATOM   1051  C   ALA A 186      35.080  62.056  26.159  1.00  8.90           C  
ATOM   1052  O   ALA A 186      34.528  61.054  25.708  1.00  8.83           O  
ATOM   1053  CB  ALA A 186      36.537  63.431  24.677  1.00  9.71           C  
ATOM   1054  N   THR A 187      35.667  62.075  27.356  1.00  8.09           N  
ATOM   1055  CA  THR A 187      35.627  60.849  28.148  1.00  7.22           C  
ATOM   1056  C   THR A 187      34.236  60.601  28.716  1.00  8.85           C  
ATOM   1057  O   THR A 187      33.847  59.436  28.961  1.00  9.63           O  
ATOM   1058  CB  THR A 187      36.724  60.800  29.242  1.00  9.36           C  
ATOM   1059  OG1 THR A 187      36.594  61.908  30.127  1.00  9.63           O  
ATOM   1060  CG2 THR A 187      38.092  60.905  28.587  1.00 10.26           C  
ATOM   1061  N   GLU A 188      33.484  61.664  28.945  1.00  8.19           N  
ATOM   1062  CA  GLU A 188      32.098  61.473  29.400  1.00  8.41           C  
ATOM   1063  C   GLU A 188      31.294  60.766  28.306  1.00  8.74           C  
ATOM   1064  O   GLU A 188      30.489  59.890  28.601  1.00  9.07           O  
ATOM   1065  CB  GLU A 188      31.425  62.798  29.752  1.00  9.66           C  
ATOM   1066  CG  GLU A 188      31.939  63.410  31.070  1.00 11.84           C  
ATOM   1067  CD  GLU A 188      31.546  62.546  32.265  1.00 17.15           C  
ATOM   1068  OE1 GLU A 188      30.395  62.647  32.737  1.00 20.12           O  
ATOM   1069  OE2 GLU A 188      32.369  61.743  32.722  1.00 15.16           O  
ATOM   1070  N   LEU A 189      31.514  61.149  27.053  1.00  8.37           N  
ATOM   1071  CA  LEU A 189      30.797  60.472  25.963  1.00  8.53           C  
ATOM   1072  C   LEU A 189      31.264  59.022  25.826  1.00  8.99           C  
ATOM   1073  O   LEU A 189      30.449  58.125  25.554  1.00  9.66           O  
ATOM   1074  CB  LEU A 189      30.989  61.251  24.660  1.00  8.97           C  
ATOM   1075  CG  LEU A 189      30.163  62.530  24.568  1.00 14.83           C  
ATOM   1076  CD1 LEU A 189      30.615  63.335  23.352  1.00 16.66           C  
ATOM   1077  CD2 LEU A 189      28.679  62.175  24.494  1.00 15.90           C  
ATOM   1078  N   ARG A 190      32.571  58.763  25.994  1.00  7.60           N  
ATOM   1079  CA  ARG A 190      33.016  57.366  25.948  1.00  7.53           C  
ATOM   1080  C   ARG A 190      32.344  56.530  27.032  1.00  8.19           C  
ATOM   1081  O   ARG A 190      31.925  55.399  26.804  1.00  8.88           O  
ATOM   1082  CB  ARG A 190      34.552  57.245  26.098  1.00  8.93           C  
ATOM   1083  CG  ARG A 190      35.275  57.890  24.932  1.00  7.04           C  
ATOM   1084  CD  ARG A 190      36.777  58.038  25.193  1.00  8.54           C  
ATOM   1085  NE  ARG A 190      37.328  58.962  24.199  1.00  8.61           N  
ATOM   1086  CZ  ARG A 190      38.542  59.502  24.252  1.00 10.38           C  
ATOM   1087  NH1 ARG A 190      39.378  59.202  25.248  1.00 10.30           N  
ATOM   1088  NH2 ARG A 190      38.902  60.361  23.303  1.00 10.00           N  
ATOM   1089  N   TYR A 191      32.246  57.104  28.228  1.00  8.01           N  
ATOM   1090  CA  TYR A 191      31.576  56.435  29.336  1.00  8.79           C  
ATOM   1091  C   TYR A 191      30.120  56.145  28.991  1.00  9.05           C  
ATOM   1092  O   TYR A 191      29.633  55.032  29.197  1.00  9.19           O  
ATOM   1093  CB  TYR A 191      31.695  57.347  30.570  1.00  8.91           C  
ATOM   1094  CG  TYR A 191      30.623  57.195  31.600  1.00 13.55           C  
ATOM   1095  CD1 TYR A 191      30.661  56.171  32.518  1.00 13.06           C  
ATOM   1096  CD2 TYR A 191      29.606  58.118  31.690  1.00 15.83           C  
ATOM   1097  CE1 TYR A 191      29.663  56.037  33.489  1.00 14.54           C  
ATOM   1098  CE2 TYR A 191      28.618  58.007  32.651  1.00 15.90           C  
ATOM   1099  CZ  TYR A 191      28.656  56.961  33.528  1.00 15.39           C  
ATOM   1100  OH  TYR A 191      27.678  56.860  34.502  1.00 21.35           O  
ATOM   1101  N   LYS A 192      29.446  57.144  28.434  1.00  7.96           N  
ATOM   1102  CA  LYS A 192      28.024  56.983  28.130  1.00  9.14           C  
ATOM   1103  C   LYS A 192      27.823  55.921  27.038  1.00  9.39           C  
ATOM   1104  O   LYS A 192      26.885  55.107  27.110  1.00 10.15           O  
ATOM   1105  CB  LYS A 192      27.462  58.324  27.673  1.00 10.80           C  
ATOM   1106  CG  LYS A 192      25.933  58.311  27.592  1.00 26.47           C  
ATOM   1107  CD  LYS A 192      25.345  57.771  28.884  1.00 26.62           C  
ATOM   1108  CE  LYS A 192      23.843  57.531  28.761  1.00 33.43           C  
ATOM   1109  NZ  LYS A 192      23.296  56.823  29.946  1.00 40.20           N  
ATOM   1110  N   GLY A 193      28.690  55.905  26.029  1.00  8.29           N  
ATOM   1111  CA  GLY A 193      28.507  54.906  24.956  1.00  7.87           C  
ATOM   1112  C   GLY A 193      28.756  53.515  25.502  1.00  8.47           C  
ATOM   1113  O   GLY A 193      28.067  52.549  25.143  1.00 10.47           O  
ATOM   1114  N   PHE A 194      29.761  53.400  26.369  1.00  8.41           N  
ATOM   1115  CA  PHE A 194      30.099  52.092  26.948  1.00  7.78           C  
ATOM   1116  C   PHE A 194      28.946  51.597  27.818  1.00  8.86           C  
ATOM   1117  O   PHE A 194      28.524  50.433  27.718  1.00 10.40           O  
ATOM   1118  CB  PHE A 194      31.376  52.268  27.782  1.00  8.05           C  
ATOM   1119  CG  PHE A 194      32.038  50.973  28.166  1.00  7.72           C  
ATOM   1120  CD1 PHE A 194      32.883  50.323  27.284  1.00  9.29           C  
ATOM   1121  CD2 PHE A 194      31.861  50.461  29.435  1.00  8.54           C  
ATOM   1122  CE1 PHE A 194      33.543  49.134  27.657  1.00  9.30           C  
ATOM   1123  CE2 PHE A 194      32.497  49.295  29.826  1.00  9.55           C  
ATOM   1124  CZ  PHE A 194      33.336  48.617  28.933  1.00 10.12           C  
ATOM   1125  N   LEU A 195      28.430  52.489  28.663  1.00  7.86           N  
ATOM   1126  CA  LEU A 195      27.336  52.140  29.568  1.00  8.52           C  
ATOM   1127  C   LEU A 195      26.074  51.800  28.783  1.00 10.40           C  
ATOM   1128  O   LEU A 195      25.392  50.813  29.102  1.00 10.46           O  
ATOM   1129  CB  LEU A 195      27.093  53.302  30.532  1.00  9.32           C  
ATOM   1130  CG  LEU A 195      25.928  53.124  31.497  1.00 13.91           C  
ATOM   1131  CD1 LEU A 195      26.069  51.852  32.358  1.00 15.31           C  
ATOM   1132  CD2 LEU A 195      25.821  54.403  32.346  1.00 18.52           C  
ATOM   1133  N   ASP A 196      25.774  52.578  27.741  1.00 10.42           N  
ATOM   1134  CA  ASP A 196      24.578  52.262  26.940  1.00 11.54           C  
ATOM   1135  C   ASP A 196      24.718  50.856  26.336  1.00 10.99           C  
ATOM   1136  O   ASP A 196      23.739  50.120  26.217  1.00 11.48           O  
ATOM   1137  CB  ASP A 196      24.336  53.283  25.817  1.00 11.51           C  
ATOM   1138  CG  ASP A 196      23.858  54.617  26.336  1.00 13.83           C  
ATOM   1139  OD1 ASP A 196      23.495  54.691  27.535  1.00 15.52           O  
ATOM   1140  OD2 ASP A 196      23.863  55.601  25.538  1.00 14.42           O  
ATOM   1141  N   GLY A 197      25.928  50.499  25.910  1.00  9.56           N  
ATOM   1142  CA  GLY A 197      26.147  49.132  25.415  1.00  9.48           C  
ATOM   1143  C   GLY A 197      25.855  48.076  26.469  1.00 10.96           C  
ATOM   1144  O   GLY A 197      25.190  47.062  26.199  1.00 11.52           O  
ATOM   1145  N   ALA A 198      26.352  48.300  27.687  1.00  9.95           N  
ATOM   1146  CA  ALA A 198      26.117  47.366  28.777  1.00 10.04           C  
ATOM   1147  C   ALA A 198      24.625  47.255  29.089  1.00 10.10           C  
ATOM   1148  O   ALA A 198      24.124  46.151  29.330  1.00 12.02           O  
ATOM   1149  CB  ALA A 198      26.889  47.800  30.037  1.00 11.69           C  
ATOM   1150  N   ARG A 199      23.918  48.381  29.061  1.00  9.86           N  
ATOM   1151  CA  ARG A 199      22.486  48.351  29.385  1.00  9.97           C  
ATOM   1152  C   ARG A 199      21.727  47.525  28.359  1.00 11.30           C  
ATOM   1153  O   ARG A 199      20.748  46.822  28.702  1.00 12.05           O  
ATOM   1154  CB  ARG A 199      21.927  49.772  29.429  1.00 11.07           C  
ATOM   1155  CG  ARG A 199      22.479  50.612  30.569  1.00 18.16           C  
ATOM   1156  CD  ARG A 199      21.624  50.479  31.808  1.00 23.85           C  
ATOM   1157  NE  ARG A 199      22.230  51.113  32.985  1.00 24.59           N  
ATOM   1158  CZ  ARG A 199      22.115  52.399  33.287  1.00 32.30           C  
ATOM   1159  NH1 ARG A 199      21.419  53.214  32.492  1.00 29.70           N  
ATOM   1160  NH2 ARG A 199      22.678  52.872  34.399  1.00 27.36           N  
ATOM   1161  N   ALA A 200      22.164  47.592  27.104  1.00 10.97           N  
ATOM   1162  CA  ALA A 200      21.501  46.820  26.034  1.00 10.85           C  
ATOM   1163  C   ALA A 200      21.658  45.325  26.263  1.00 12.35           C  
ATOM   1164  O   ALA A 200      20.807  44.540  25.841  1.00 13.58           O  
ATOM   1165  CB  ALA A 200      22.044  47.209  24.677  1.00 11.36           C  
ATOM   1166  N   LYS A 201      22.721  44.928  26.953  1.00 12.56           N  
ATOM   1167  CA  LYS A 201      22.949  43.501  27.250  1.00 13.18           C  
ATOM   1168  C   LYS A 201      22.552  43.141  28.692  1.00 14.68           C  
ATOM   1169  O   LYS A 201      22.860  42.056  29.185  1.00 15.89           O  
ATOM   1170  CB  LYS A 201      24.419  43.135  27.013  1.00 13.04           C  
ATOM   1171  CG  LYS A 201      24.862  43.320  25.577  1.00 13.71           C  
ATOM   1172  CD  LYS A 201      24.049  42.455  24.602  1.00 18.18           C  
ATOM   1173  CE  LYS A 201      24.625  42.464  23.185  1.00 21.88           C  
ATOM   1174  NZ  LYS A 201      24.517  43.789  22.470  1.00 28.33           N  
ATOM   1175  N   ASP A 202      21.904  44.068  29.387  1.00 15.31           N  
ATOM   1176  CA  ASP A 202      21.509  43.826  30.774  1.00 16.87           C  
ATOM   1177  C   ASP A 202      22.686  43.433  31.650  1.00 16.69           C  
ATOM   1178  O   ASP A 202      22.574  42.566  32.527  1.00 17.08           O  
ATOM   1179  CB  ASP A 202      20.405  42.772  30.830  1.00 20.27           C  
ATOM   1180  CG  ASP A 202      19.112  43.288  30.247  1.00 30.28           C  
ATOM   1181  OD1 ASP A 202      18.478  44.156  30.885  1.00 34.27           O  
ATOM   1182  OD2 ASP A 202      18.748  42.858  29.138  1.00 36.04           O  
ATOM   1183  N   LEU A 203      23.819  44.086  31.420  1.00 14.79           N  
ATOM   1184  CA  LEU A 203      25.026  43.767  32.169  1.00 15.56           C  
ATOM   1185  C   LEU A 203      25.353  44.910  33.101  1.00 17.78           C  
ATOM   1186  O   LEU A 203      25.353  46.050  32.673  1.00 18.88           O  
ATOM   1187  CB  LEU A 203      26.200  43.541  31.215  1.00 16.51           C  
ATOM   1188  CG  LEU A 203      27.381  42.722  31.708  1.00 26.88           C  
ATOM   1189  CD1 LEU A 203      26.948  41.252  31.822  1.00 17.87           C  
ATOM   1190  CD2 LEU A 203      28.562  42.886  30.756  1.00 21.05           C  
ATOM   1191  N   GLU A 204      25.613  44.607  34.370  1.00 18.18           N  
ATOM   1192  CA  GLU A 204      26.102  45.617  35.289  1.00 18.84           C  
ATOM   1193  C   GLU A 204      27.615  45.765  35.104  1.00 19.03           C  
ATOM   1194  O   GLU A 204      28.326  44.756  34.986  1.00 21.21           O  
ATOM   1195  CB  GLU A 204      25.786  45.226  36.735  1.00 20.93           C  
ATOM   1196  CG  GLU A 204      24.381  45.621  37.176  1.00 48.09           C  
ATOM   1197  CD  GLU A 204      24.228  45.649  38.686  1.00 35.01           C  
ATOM   1198  OE1 GLU A 204      24.856  44.803  39.360  1.00 50.50           O  
ATOM   1199  OE2 GLU A 204      23.485  46.518  39.195  1.00 50.75           O  
ATOM   1200  N   ILE A 205      28.070  47.012  35.108  1.00 17.47           N  
ATOM   1201  CA  ILE A 205      29.487  47.380  34.897  1.00 16.83           C  
ATOM   1202  C   ILE A 205      29.983  48.133  36.125  1.00 14.82           C  
ATOM   1203  O   ILE A 205      29.215  48.870  36.747  1.00 16.02           O  
ATOM   1204  CB  ILE A 205      29.612  48.417  33.764  1.00 18.18           C  
ATOM   1205  CG1 ILE A 205      29.093  47.856  32.444  1.00 36.17           C  
ATOM   1206  CG2 ILE A 205      31.065  48.905  33.634  1.00 33.59           C  
ATOM   1207  CD1 ILE A 205      29.868  46.657  31.969  1.00 18.37           C  
ATOM   1208  N   ASP A 206      31.269  48.013  36.435  1.00 11.23           N  
ATOM   1209  CA  ASP A 206      31.853  48.781  37.530  1.00 11.13           C  
ATOM   1210  C   ASP A 206      32.675  49.923  36.936  1.00 11.00           C  
ATOM   1211  O   ASP A 206      33.188  49.791  35.828  1.00 11.07           O  
ATOM   1212  CB  ASP A 206      32.794  47.911  38.361  1.00 11.84           C  
ATOM   1213  CG  ASP A 206      32.057  46.909  39.224  1.00 16.16           C  
ATOM   1214  OD1 ASP A 206      30.826  47.076  39.397  1.00 16.43           O  
ATOM   1215  OD2 ASP A 206      32.714  45.955  39.714  1.00 16.05           O  
ATOM   1216  N   PHE A 207      32.791  51.023  37.680  1.00 11.00           N  
ATOM   1217  CA  PHE A 207      33.559  52.190  37.246  1.00 11.92           C  
ATOM   1218  C   PHE A 207      34.567  52.617  38.293  1.00 12.77           C  
ATOM   1219  O   PHE A 207      34.296  52.545  39.505  1.00 13.81           O  
ATOM   1220  CB  PHE A 207      32.605  53.368  36.972  1.00 12.52           C  
ATOM   1221  CG  PHE A 207      31.624  53.090  35.888  1.00 13.37           C  
ATOM   1222  CD1 PHE A 207      32.003  53.188  34.567  1.00 13.02           C  
ATOM   1223  CD2 PHE A 207      30.309  52.701  36.187  1.00 14.53           C  
ATOM   1224  CE1 PHE A 207      31.120  52.887  33.531  1.00 15.34           C  
ATOM   1225  CE2 PHE A 207      29.414  52.401  35.162  1.00 13.64           C  
ATOM   1226  CZ  PHE A 207      29.822  52.494  33.831  1.00 15.41           C  
ATOM   1227  N   ILE A 208      35.730  53.088  37.826  1.00 10.20           N  
ATOM   1228  CA  ILE A 208      36.691  53.830  38.673  1.00  9.18           C  
ATOM   1229  C   ILE A 208      36.976  55.122  37.918  1.00 10.66           C  
ATOM   1230  O   ILE A 208      37.214  55.072  36.719  1.00 12.43           O  
ATOM   1231  CB  ILE A 208      37.999  53.029  38.803  1.00 10.15           C  
ATOM   1232  CG1 ILE A 208      37.751  51.770  39.642  1.00 11.85           C  
ATOM   1233  CG2 ILE A 208      39.131  53.865  39.452  1.00 15.29           C  
ATOM   1234  CD1 ILE A 208      38.964  50.830  39.707  1.00 14.04           C  
ATOM   1235  N   GLU A 209      36.917  56.267  38.586  1.00 10.12           N  
ATOM   1236  CA  GLU A 209      37.059  57.543  37.875  1.00  9.79           C  
ATOM   1237  C   GLU A 209      38.360  58.221  38.227  1.00 10.28           C  
ATOM   1238  O   GLU A 209      38.547  58.674  39.364  1.00 11.42           O  
ATOM   1239  CB  GLU A 209      35.921  58.494  38.252  1.00 11.65           C  
ATOM   1240  CG  GLU A 209      35.926  59.829  37.493  1.00 16.70           C  
ATOM   1241  CD  GLU A 209      34.741  60.690  37.915  1.00 23.51           C  
ATOM   1242  OE1 GLU A 209      34.860  61.420  38.921  1.00 22.57           O  
ATOM   1243  OE2 GLU A 209      33.681  60.609  37.263  1.00 20.49           O  
ATOM   1244  N   PHE A 210      39.265  58.324  37.256  1.00  9.19           N  
ATOM   1245  CA  PHE A 210      40.521  59.033  37.508  1.00  9.08           C  
ATOM   1246  C   PHE A 210      40.233  60.517  37.423  1.00 10.70           C  
ATOM   1247  O   PHE A 210      39.396  60.938  36.608  1.00 12.28           O  
ATOM   1248  CB  PHE A 210      41.545  58.707  36.409  1.00  9.81           C  
ATOM   1249  CG  PHE A 210      42.264  57.386  36.577  1.00  8.90           C  
ATOM   1250  CD1 PHE A 210      41.811  56.401  37.440  1.00 11.49           C  
ATOM   1251  CD2 PHE A 210      43.403  57.132  35.816  1.00 10.26           C  
ATOM   1252  CE1 PHE A 210      42.499  55.193  37.582  1.00  9.48           C  
ATOM   1253  CE2 PHE A 210      44.096  55.909  35.937  1.00  9.74           C  
ATOM   1254  CZ  PHE A 210      43.639  54.945  36.816  1.00 10.03           C  
ATOM   1255  N   GLN A 211      40.924  61.327  38.235  1.00  8.99           N  
ATOM   1256  CA  GLN A 211      40.626  62.773  38.243  1.00 10.13           C  
ATOM   1257  C   GLN A 211      41.527  63.596  37.358  1.00 10.34           C  
ATOM   1258  O   GLN A 211      41.330  64.837  37.212  1.00 11.76           O  
ATOM   1259  CB  GLN A 211      40.743  63.326  39.673  1.00 10.84           C  
ATOM   1260  CG  GLN A 211      39.823  62.591  40.647  1.00 11.48           C  
ATOM   1261  CD  GLN A 211      38.371  62.696  40.241  1.00 13.60           C  
ATOM   1262  OE1 GLN A 211      37.853  63.802  40.055  1.00 18.19           O  
ATOM   1263  NE2 GLN A 211      37.703  61.551  40.102  1.00 13.49           N  
ATOM   1264  N   HIS A 212      42.529  62.937  36.773  1.00  9.87           N  
ATOM   1265  CA  HIS A 212      43.494  63.626  35.922  1.00 10.33           C  
ATOM   1266  C   HIS A 212      43.809  62.728  34.730  1.00  9.30           C  
ATOM   1267  O   HIS A 212      43.701  61.506  34.828  1.00 10.15           O  
ATOM   1268  CB  HIS A 212      44.822  63.843  36.668  1.00 12.00           C  
ATOM   1269  CG  HIS A 212      44.680  64.636  37.927  1.00 16.16           C  
ATOM   1270  ND1 HIS A 212      44.433  64.047  39.150  1.00 16.00           N  
ATOM   1271  CD2 HIS A 212      44.751  65.968  38.153  1.00 19.38           C  
ATOM   1272  CE1 HIS A 212      44.358  64.987  40.081  1.00 18.36           C  
ATOM   1273  NE2 HIS A 212      44.553  66.163  39.504  1.00 17.58           N  
ATOM   1274  N   ASP A 213      44.217  63.352  33.631  1.00  8.83           N  
ATOM   1275  CA  ASP A 213      44.888  62.617  32.556  1.00  9.19           C  
ATOM   1276  C   ASP A 213      46.261  62.208  33.095  1.00 11.25           C  
ATOM   1277  O   ASP A 213      46.659  62.566  34.218  1.00 10.87           O  
ATOM   1278  CB  ASP A 213      45.025  63.555  31.338  1.00  9.00           C  
ATOM   1279  CG  ASP A 213      45.332  62.835  30.039  1.00  9.29           C  
ATOM   1280  OD1 ASP A 213      45.450  61.590  30.029  1.00  9.83           O  
ATOM   1281  OD2 ASP A 213      45.423  63.550  29.012  1.00  9.73           O  
ATOM   1282  N   PHE A 214      47.014  61.476  32.290  1.00 11.00           N  
ATOM   1283  CA  PHE A 214      48.350  61.036  32.729  1.00 10.97           C  
ATOM   1284  C   PHE A 214      49.212  62.168  33.274  1.00 11.10           C  
ATOM   1285  O   PHE A 214      49.329  63.264  32.684  1.00 11.40           O  
ATOM   1286  CB  PHE A 214      49.110  60.414  31.544  1.00 11.66           C  
ATOM   1287  CG  PHE A 214      50.498  59.950  31.908  1.00 11.63           C  
ATOM   1288  CD1 PHE A 214      50.657  58.823  32.700  1.00 10.25           C  
ATOM   1289  CD2 PHE A 214      51.624  60.634  31.471  1.00 14.40           C  
ATOM   1290  CE1 PHE A 214      51.954  58.377  33.082  1.00 12.75           C  
ATOM   1291  CE2 PHE A 214      52.922  60.175  31.836  1.00 13.21           C  
ATOM   1292  CZ  PHE A 214      53.072  59.063  32.631  1.00 13.34           C  
ATOM   1293  N   GLN A 215      49.838  61.902  34.432  1.00 10.71           N  
ATOM   1294  CA  GLN A 215      50.865  62.758  34.985  1.00 12.70           C  
ATOM   1295  C   GLN A 215      51.945  61.789  35.429  1.00 11.57           C  
ATOM   1296  O   GLN A 215      51.642  60.649  35.789  1.00 11.45           O  
ATOM   1297  CB  GLN A 215      50.364  63.435  36.272  1.00 16.62           C  
ATOM   1298  CG  GLN A 215      49.191  64.397  36.123  1.00 25.44           C  
ATOM   1299  CD  GLN A 215      48.746  64.976  37.486  1.00 21.42           C  
ATOM   1300  OE1 GLN A 215      48.863  66.173  37.722  1.00 33.96           O  
ATOM   1301  NE2 GLN A 215      48.266  64.111  38.375  1.00 27.14           N  
ATOM   1302  N   VAL A 216      53.188  62.246  35.436  1.00 11.84           N  
ATOM   1303  CA  VAL A 216      54.283  61.368  35.810  1.00 12.25           C  
ATOM   1304  C   VAL A 216      54.079  60.834  37.234  1.00 11.84           C  
ATOM   1305  O   VAL A 216      54.429  59.684  37.532  1.00 12.64           O  
ATOM   1306  CB  VAL A 216      55.621  62.084  35.666  1.00 13.47           C  
ATOM   1307  CG1 VAL A 216      56.752  61.232  36.222  1.00 17.20           C  
ATOM   1308  CG2 VAL A 216      55.846  62.369  34.178  1.00 15.07           C  
ATOM   1309  N   LYS A 217      53.462  61.643  38.088  1.00 11.40           N  
ATOM   1310  CA  LYS A 217      53.162  61.172  39.458  1.00 12.40           C  
ATOM   1311  C   LYS A 217      52.279  59.931  39.517  1.00 13.07           C  
ATOM   1312  O   LYS A 217      52.319  59.177  40.505  1.00 15.12           O  
ATOM   1313  CB  LYS A 217      52.579  62.293  40.324  1.00 15.23           C  
ATOM   1314  CG  LYS A 217      51.270  62.833  39.853  1.00 23.86           C  
ATOM   1315  CD  LYS A 217      50.832  63.946  40.814  1.00 27.38           C  
ATOM   1316  CE  LYS A 217      51.324  63.635  42.226  1.00 25.90           C  
ATOM   1317  NZ  LYS A 217      50.502  62.630  42.939  1.00 37.71           N  
ATOM   1318  N   MET A 218      51.484  59.706  38.476  1.00 12.29           N  
ATOM   1319  CA  MET A 218      50.616  58.535  38.434  1.00 13.60           C  
ATOM   1320  C   MET A 218      51.429  57.262  38.578  1.00 15.42           C  
ATOM   1321  O   MET A 218      50.920  56.239  39.032  1.00 15.82           O  
ATOM   1322  CB  MET A 218      49.817  58.552  37.111  1.00 14.09           C  
ATOM   1323  CG  MET A 218      48.539  57.719  37.027  1.00 24.51           C  
ATOM   1324  SD  MET A 218      47.538  58.202  35.555  1.00 15.55           S  
ATOM   1325  CE  MET A 218      46.554  59.569  36.206  1.00 22.78           C  
ATOM   1326  N   LEU A 219      52.711  57.295  38.201  1.00 16.17           N  
ATOM   1327  CA  LEU A 219      53.506  56.069  38.272  1.00 18.29           C  
ATOM   1328  C   LEU A 219      53.851  55.687  39.718  1.00 20.78           C  
ATOM   1329  O   LEU A 219      54.313  54.559  39.967  1.00 24.27           O  
ATOM   1330  CB  LEU A 219      54.783  56.216  37.425  1.00 20.08           C  
ATOM   1331  CG  LEU A 219      54.503  56.466  35.937  1.00 17.40           C  
ATOM   1332  CD1 LEU A 219      55.782  56.824  35.187  1.00 22.38           C  
ATOM   1333  CD2 LEU A 219      53.893  55.231  35.290  1.00 23.81           C  
ATOM   1334  N   GLU A 220      53.622  56.624  40.649  1.00 17.84           N  
ATOM   1335  CA  GLU A 220      53.868  56.436  42.083  1.00 19.48           C  
ATOM   1336  C   GLU A 220      52.560  56.344  42.877  1.00 17.85           C  
ATOM   1337  O   GLU A 220      52.590  56.394  44.115  1.00 19.24           O  
ATOM   1338  CB  GLU A 220      54.697  57.600  42.666  1.00 22.18           C  
ATOM   1339  CG  GLU A 220      55.856  58.080  41.782  1.00 47.00           C  
ATOM   1340  CD  GLU A 220      56.271  59.523  42.076  1.00 34.84           C  
ATOM   1341  OE1 GLU A 220      56.072  59.984  43.224  1.00 50.23           O  
ATOM   1342  OE2 GLU A 220      56.808  60.195  41.159  1.00 49.48           O  
ATOM   1343  N   GLU A 221      51.430  56.239  42.174  1.00 13.95           N  
ATOM   1344  CA  GLU A 221      50.101  56.178  42.813  1.00 12.97           C  
ATOM   1345  C   GLU A 221      49.502  54.781  42.671  1.00 14.81           C  
ATOM   1346  O   GLU A 221      49.649  54.151  41.619  1.00 17.90           O  
ATOM   1347  CB  GLU A 221      49.169  57.213  42.194  1.00 13.47           C  
ATOM   1348  CG  GLU A 221      49.654  58.629  42.470  1.00 12.53           C  
ATOM   1349  CD  GLU A 221      48.807  59.687  41.825  1.00 13.02           C  
ATOM   1350  OE1 GLU A 221      48.176  59.424  40.774  1.00 15.02           O  
ATOM   1351  OE2 GLU A 221      48.812  60.814  42.349  1.00 16.88           O  
ATOM   1352  N   ASP A 222      48.839  54.304  43.718  1.00 14.40           N  
ATOM   1353  CA  ASP A 222      48.196  52.981  43.708  1.00 15.24           C  
ATOM   1354  C   ASP A 222      46.704  53.131  43.531  1.00 14.61           C  
ATOM   1355  O   ASP A 222      46.149  54.179  43.850  1.00 13.00           O  
ATOM   1356  CB  ASP A 222      48.372  52.312  45.068  1.00 17.63           C  
ATOM   1357  CG  ASP A 222      49.818  52.029  45.418  1.00 35.77           C  
ATOM   1358  OD1 ASP A 222      50.621  51.755  44.504  1.00 32.93           O  
ATOM   1359  OD2 ASP A 222      50.134  52.058  46.629  1.00 33.64           O  
ATOM   1360  N   ILE A 223      46.053  52.082  43.031  1.00 14.63           N  
ATOM   1361  CA  ILE A 223      44.594  51.989  43.081  1.00 13.65           C  
ATOM   1362  C   ILE A 223      44.237  51.157  44.314  1.00 14.36           C  
ATOM   1363  O   ILE A 223      44.833  50.093  44.555  1.00 14.98           O  
ATOM   1364  CB  ILE A 223      44.035  51.329  41.808  1.00 14.49           C  
ATOM   1365  CG1 ILE A 223      44.245  52.256  40.599  1.00 15.25           C  
ATOM   1366  CG2 ILE A 223      42.544  51.024  41.963  1.00 15.30           C  
ATOM   1367  CD1 ILE A 223      43.818  51.625  39.292  1.00 20.49           C  
ATOM   1368  N   ASN A 224      43.312  51.653  45.129  1.00 14.19           N  
ATOM   1369  CA  ASN A 224      42.893  50.927  46.322  1.00 15.05           C  
ATOM   1370  C   ASN A 224      42.323  49.603  45.847  1.00 17.07           C  
ATOM   1371  O   ASN A 224      41.584  49.588  44.868  1.00 17.65           O  
ATOM   1372  CB  ASN A 224      41.794  51.703  47.025  1.00 15.65           C  
ATOM   1373  CG  ASN A 224      41.408  51.083  48.342  1.00 19.80           C  
ATOM   1374  OD1 ASN A 224      42.262  50.862  49.194  1.00 19.49           O  
ATOM   1375  ND2 ASN A 224      40.113  50.806  48.522  1.00 15.88           N  
ATOM   1376  N   SER A 225      42.652  48.506  46.520  1.00 19.09           N  
ATOM   1377  CA  SER A 225      42.091  47.197  46.117  1.00 20.96           C  
ATOM   1378  C   SER A 225      42.531  46.800  44.717  1.00 20.76           C  
ATOM   1379  O   SER A 225      41.799  46.133  43.971  1.00 20.72           O  
ATOM   1380  CB  SER A 225      40.568  47.208  46.193  1.00 23.07           C  
ATOM   1381  OG  SER A 225      40.132  47.039  47.539  1.00 39.85           O  
ATOM   1382  N   MET A 226      43.742  47.202  44.359  1.00 20.70           N  
ATOM   1383  CA  MET A 226      44.341  46.785  43.102  1.00 19.91           C  
ATOM   1384  C   MET A 226      44.307  45.265  42.992  1.00 19.47           C  
ATOM   1385  O   MET A 226      44.195  44.707  41.904  1.00 18.84           O  
ATOM   1386  CB  MET A 226      45.789  47.279  43.048  1.00 20.09           C  
ATOM   1387  CG  MET A 226      46.503  47.060  41.731  1.00 26.27           C  
ATOM   1388  SD  MET A 226      45.872  48.013  40.352  1.00 18.01           S  
ATOM   1389  CE  MET A 226      46.028  46.748  39.069  1.00 22.44           C  
ATOM   1390  N   LYS A 227      44.400  44.581  44.127  1.00 20.29           N  
ATOM   1391  CA  LYS A 227      44.449  43.105  44.109  1.00 22.71           C  
ATOM   1392  C   LYS A 227      43.199  42.452  43.491  1.00 23.83           C  
ATOM   1393  O   LYS A 227      43.243  41.288  43.061  1.00 23.61           O  
ATOM   1394  CB  LYS A 227      44.687  42.574  45.521  1.00 24.14           C  
ATOM   1395  CG  LYS A 227      43.469  42.654  46.424  1.00 33.44           C  
ATOM   1396  CD  LYS A 227      43.769  42.040  47.804  1.00 33.18           C  
ATOM   1397  CE  LYS A 227      42.836  42.584  48.873  1.00 35.80           C  
ATOM   1398  NZ  LYS A 227      43.228  42.099  50.237  1.00 38.77           N  
ATOM   1399  N   ASP A 228      42.096  43.195  43.440  1.00 22.76           N  
ATOM   1400  CA  ASP A 228      40.835  42.671  42.928  1.00 22.42           C  
ATOM   1401  C   ASP A 228      40.681  42.894  41.411  1.00 20.65           C  
ATOM   1402  O   ASP A 228      39.761  42.354  40.796  1.00 20.79           O  
ATOM   1403  CB  ASP A 228      39.649  43.368  43.607  1.00 24.53           C  
ATOM   1404  CG  ASP A 228      39.545  43.065  45.091  1.00 45.66           C  
ATOM   1405  OD1 ASP A 228      40.124  42.056  45.557  1.00 32.05           O  
ATOM   1406  OD2 ASP A 228      38.865  43.848  45.791  1.00 32.64           O  
ATOM   1407  N   ILE A 229      41.554  43.700  40.807  1.00 18.52           N  
ATOM   1408  CA  ILE A 229      41.332  44.109  39.413  1.00 18.10           C  
ATOM   1409  C   ILE A 229      41.488  42.919  38.479  1.00 17.72           C  
ATOM   1410  O   ILE A 229      40.818  42.831  37.448  1.00 16.56           O  
ATOM   1411  CB  ILE A 229      42.309  45.246  39.035  1.00 19.26           C  
ATOM   1412  CG1 ILE A 229      42.053  46.475  39.912  1.00 21.64           C  
ATOM   1413  CG2 ILE A 229      42.255  45.586  37.550  1.00 19.22           C  
ATOM   1414  CD1 ILE A 229      40.707  47.144  39.696  1.00 26.55           C  
ATOM   1415  N   VAL A 230      42.374  41.986  38.834  1.00 17.59           N  
ATOM   1416  CA  VAL A 230      42.559  40.809  38.005  1.00 18.87           C  
ATOM   1417  C   VAL A 230      41.262  40.015  37.905  1.00 18.04           C  
ATOM   1418  O   VAL A 230      41.103  39.200  36.989  1.00 19.79           O  
ATOM   1419  CB  VAL A 230      43.684  39.890  38.530  1.00 19.63           C  
ATOM   1420  CG1 VAL A 230      43.281  39.264  39.844  1.00 22.17           C  
ATOM   1421  CG2 VAL A 230      43.999  38.797  37.493  1.00 21.35           C  
ATOM   1422  N   ASN A 231      40.320  40.245  38.822  1.00 17.02           N  
ATOM   1423  CA  ASN A 231      39.084  39.454  38.821  1.00 18.00           C  
ATOM   1424  C   ASN A 231      38.115  39.823  37.694  1.00 16.44           C  
ATOM   1425  O   ASN A 231      37.169  39.076  37.408  1.00 16.83           O  
ATOM   1426  CB  ASN A 231      38.357  39.558  40.168  1.00 20.41           C  
ATOM   1427  CG  ASN A 231      39.085  38.823  41.271  1.00 29.76           C  
ATOM   1428  OD1 ASN A 231      39.839  37.884  41.009  1.00 26.29           O  
ATOM   1429  ND2 ASN A 231      38.874  39.252  42.507  1.00 29.82           N  
ATOM   1430  N   TYR A 232      38.328  40.985  37.075  1.00 13.73           N  
ATOM   1431  CA  TYR A 232      37.502  41.360  35.926  1.00 11.79           C  
ATOM   1432  C   TYR A 232      37.879  40.539  34.698  1.00 13.12           C  
ATOM   1433  O   TYR A 232      39.018  40.088  34.587  1.00 14.88           O  
ATOM   1434  CB  TYR A 232      37.673  42.861  35.603  1.00  9.95           C  
ATOM   1435  CG  TYR A 232      37.048  43.744  36.681  1.00 12.26           C  
ATOM   1436  CD1 TYR A 232      35.680  43.945  36.716  1.00 11.92           C  
ATOM   1437  CD2 TYR A 232      37.834  44.327  37.678  1.00 12.38           C  
ATOM   1438  CE1 TYR A 232      35.088  44.742  37.703  1.00 12.52           C  
ATOM   1439  CE2 TYR A 232      37.265  45.105  38.682  1.00 13.01           C  
ATOM   1440  CZ  TYR A 232      35.883  45.311  38.683  1.00 13.23           C  
ATOM   1441  OH  TYR A 232      35.284  46.078  39.655  1.00 15.69           O  
ATOM   1442  N   ASP A 233      36.929  40.362  33.780  1.00 11.56           N  
ATOM   1443  CA  ASP A 233      37.213  39.718  32.494  1.00 11.91           C  
ATOM   1444  C   ASP A 233      37.862  40.728  31.546  1.00 11.08           C  
ATOM   1445  O   ASP A 233      38.751  40.372  30.765  1.00 11.48           O  
ATOM   1446  CB  ASP A 233      35.915  39.217  31.816  1.00 13.01           C  
ATOM   1447  CG  ASP A 233      35.196  38.135  32.605  1.00 16.56           C  
ATOM   1448  OD1 ASP A 233      35.863  37.387  33.347  1.00 17.42           O  
ATOM   1449  OD2 ASP A 233      33.950  38.043  32.462  1.00 17.69           O  
ATOM   1450  N   GLY A 234      37.390  41.972  31.586  1.00 11.28           N  
ATOM   1451  CA  GLY A 234      37.863  42.970  30.633  1.00 11.56           C  
ATOM   1452  C   GLY A 234      37.818  44.349  31.265  1.00 10.91           C  
ATOM   1453  O   GLY A 234      36.965  44.619  32.115  1.00 10.18           O  
ATOM   1454  N   ILE A 235      38.711  45.223  30.814  1.00  9.56           N  
ATOM   1455  CA  ILE A 235      38.771  46.591  31.326  1.00  8.59           C  
ATOM   1456  C   ILE A 235      38.866  47.528  30.138  1.00  8.72           C  
ATOM   1457  O   ILE A 235      39.719  47.321  29.258  1.00  8.80           O  
ATOM   1458  CB  ILE A 235      40.041  46.781  32.176  1.00  9.28           C  
ATOM   1459  CG1 ILE A 235      40.047  45.801  33.348  1.00 11.40           C  
ATOM   1460  CG2 ILE A 235      40.093  48.222  32.732  1.00 11.03           C  
ATOM   1461  CD1 ILE A 235      41.360  45.801  34.118  1.00 13.80           C  
ATOM   1462  N   PHE A 236      38.012  48.554  30.110  1.00  7.35           N  
ATOM   1463  CA  PHE A 236      38.120  49.623  29.119  1.00  6.77           C  
ATOM   1464  C   PHE A 236      38.699  50.829  29.853  1.00  8.71           C  
ATOM   1465  O   PHE A 236      38.120  51.279  30.845  1.00  7.95           O  
ATOM   1466  CB  PHE A 236      36.708  49.961  28.567  1.00  7.07           C  
ATOM   1467  CG  PHE A 236      36.643  51.204  27.688  1.00  8.50           C  
ATOM   1468  CD1 PHE A 236      37.647  51.491  26.779  1.00  8.28           C  
ATOM   1469  CD2 PHE A 236      35.516  52.048  27.750  1.00  7.80           C  
ATOM   1470  CE1 PHE A 236      37.572  52.641  25.973  1.00  8.51           C  
ATOM   1471  CE2 PHE A 236      35.433  53.214  26.949  1.00  7.87           C  
ATOM   1472  CZ  PHE A 236      36.455  53.492  26.043  1.00  8.80           C  
ATOM   1473  N   VAL A 237      39.847  51.321  29.383  1.00  7.46           N  
ATOM   1474  CA  VAL A 237      40.473  52.489  30.006  1.00  6.83           C  
ATOM   1475  C   VAL A 237      40.339  53.695  29.089  1.00  7.38           C  
ATOM   1476  O   VAL A 237      40.472  53.581  27.868  1.00  8.58           O  
ATOM   1477  CB  VAL A 237      41.970  52.235  30.298  1.00  8.55           C  
ATOM   1478  CG1 VAL A 237      42.518  53.389  31.150  1.00  9.27           C  
ATOM   1479  CG2 VAL A 237      42.162  50.900  31.027  1.00  8.59           C  
ATOM   1480  N   PHE A 238      40.058  54.854  29.675  1.00  7.32           N  
ATOM   1481  CA  PHE A 238      39.633  56.010  28.875  1.00  7.64           C  
ATOM   1482  C   PHE A 238      40.629  56.502  27.840  1.00  8.14           C  
ATOM   1483  O   PHE A 238      40.226  57.181  26.885  1.00  8.86           O  
ATOM   1484  CB  PHE A 238      39.186  57.176  29.786  1.00  7.82           C  
ATOM   1485  CG  PHE A 238      40.310  57.796  30.598  1.00  6.99           C  
ATOM   1486  CD1 PHE A 238      40.992  58.918  30.118  1.00  7.91           C  
ATOM   1487  CD2 PHE A 238      40.634  57.305  31.857  1.00  8.09           C  
ATOM   1488  CE1 PHE A 238      41.996  59.477  30.881  1.00  7.59           C  
ATOM   1489  CE2 PHE A 238      41.631  57.875  32.629  1.00  7.37           C  
ATOM   1490  CZ  PHE A 238      42.309  58.971  32.136  1.00  9.57           C  
ATOM   1491  N   ASN A 239      41.927  56.245  28.019  1.00  6.99           N  
ATOM   1492  CA  ASN A 239      42.857  56.504  26.918  1.00  5.96           C  
ATOM   1493  C   ASN A 239      44.056  55.604  26.992  1.00  7.64           C  
ATOM   1494  O   ASN A 239      44.189  54.819  27.938  1.00  8.81           O  
ATOM   1495  CB  ASN A 239      43.242  57.999  26.793  1.00  7.00           C  
ATOM   1496  CG  ASN A 239      44.099  58.487  27.921  1.00  8.04           C  
ATOM   1497  OD1 ASN A 239      44.691  57.700  28.641  1.00 10.00           O  
ATOM   1498  ND2 ASN A 239      44.178  59.825  28.090  1.00  8.00           N  
ATOM   1499  N   ASP A 240      44.874  55.630  25.943  1.00  8.05           N  
ATOM   1500  CA  ASP A 240      45.960  54.666  25.844  1.00  7.17           C  
ATOM   1501  C   ASP A 240      47.049  54.885  26.886  1.00  8.37           C  
ATOM   1502  O   ASP A 240      47.600  53.921  27.404  1.00  8.79           O  
ATOM   1503  CB  ASP A 240      46.612  54.672  24.450  1.00  8.10           C  
ATOM   1504  CG  ASP A 240      45.713  54.098  23.374  1.00  9.23           C  
ATOM   1505  OD1 ASP A 240      44.692  53.448  23.689  1.00  8.96           O  
ATOM   1506  OD2 ASP A 240      46.063  54.291  22.180  1.00 10.87           O  
ATOM   1507  N   ILE A 241      47.380  56.145  27.171  1.00  8.42           N  
ATOM   1508  CA  ILE A 241      48.451  56.386  28.168  1.00  7.98           C  
ATOM   1509  C   ILE A 241      47.991  55.961  29.574  1.00  8.76           C  
ATOM   1510  O   ILE A 241      48.766  55.362  30.334  1.00  8.70           O  
ATOM   1511  CB  ILE A 241      49.001  57.848  28.086  1.00  9.62           C  
ATOM   1512  CG1 ILE A 241      50.194  58.033  29.030  1.00 11.73           C  
ATOM   1513  CG2 ILE A 241      47.904  58.855  28.326  1.00 10.52           C  
ATOM   1514  CD1 ILE A 241      51.407  57.223  28.608  1.00 10.79           C  
ATOM   1515  N   ALA A 242      46.729  56.214  29.918  1.00  8.15           N  
ATOM   1516  CA  ALA A 242      46.219  55.695  31.194  1.00  7.27           C  
ATOM   1517  C   ALA A 242      46.215  54.154  31.170  1.00  7.65           C  
ATOM   1518  O   ALA A 242      46.535  53.489  32.156  1.00  9.83           O  
ATOM   1519  CB  ALA A 242      44.808  56.243  31.444  1.00  8.58           C  
ATOM   1520  N   ALA A 243      45.847  53.566  30.037  1.00  7.54           N  
ATOM   1521  CA  ALA A 243      45.857  52.084  29.952  1.00  7.26           C  
ATOM   1522  C   ALA A 243      47.259  51.535  30.211  1.00  8.40           C  
ATOM   1523  O   ALA A 243      47.413  50.482  30.830  1.00  9.78           O  
ATOM   1524  CB  ALA A 243      45.386  51.609  28.555  1.00  8.65           C  
ATOM   1525  N   ALA A 244      48.280  52.218  29.692  1.00  9.53           N  
ATOM   1526  CA  ALA A 244      49.656  51.776  29.909  1.00  8.55           C  
ATOM   1527  C   ALA A 244      49.970  51.735  31.399  1.00  8.67           C  
ATOM   1528  O   ALA A 244      50.692  50.820  31.867  1.00  9.71           O  
ATOM   1529  CB  ALA A 244      50.639  52.749  29.204  1.00  9.82           C  
ATOM   1530  N   THR A 245      49.468  52.721  32.145  1.00 10.19           N  
ATOM   1531  CA  THR A 245      49.753  52.739  33.596  1.00 11.52           C  
ATOM   1532  C   THR A 245      49.025  51.593  34.296  1.00 11.45           C  
ATOM   1533  O   THR A 245      49.552  50.958  35.218  1.00 11.72           O  
ATOM   1534  CB  THR A 245      49.355  54.078  34.283  1.00 13.26           C  
ATOM   1535  OG1 THR A 245      47.908  54.199  34.311  1.00 14.47           O  
ATOM   1536  CG2 THR A 245      49.989  55.235  33.541  1.00 12.53           C  
ATOM   1537  N   VAL A 246      47.804  51.323  33.838  1.00 10.43           N  
ATOM   1538  CA  VAL A 246      47.025  50.215  34.412  1.00  9.84           C  
ATOM   1539  C   VAL A 246      47.718  48.888  34.121  1.00 10.27           C  
ATOM   1540  O   VAL A 246      47.848  48.038  34.993  1.00 10.84           O  
ATOM   1541  CB  VAL A 246      45.583  50.205  33.854  1.00 10.82           C  
ATOM   1542  CG1 VAL A 246      44.817  48.912  34.290  1.00 13.80           C  
ATOM   1543  CG2 VAL A 246      44.840  51.479  34.270  1.00 12.57           C  
ATOM   1544  N   MET A 247      48.169  48.693  32.889  1.00 10.06           N  
ATOM   1545  CA  MET A 247      48.840  47.439  32.555  1.00  9.67           C  
ATOM   1546  C   MET A 247      50.135  47.303  33.359  1.00 10.31           C  
ATOM   1547  O   MET A 247      50.507  46.184  33.741  1.00 11.86           O  
ATOM   1548  CB  MET A 247      49.152  47.409  31.060  1.00 12.04           C  
ATOM   1549  CG  MET A 247      47.897  47.192  30.199  1.00 15.69           C  
ATOM   1550  SD  MET A 247      48.118  47.227  28.368  1.00 10.80           S  
ATOM   1551  CE  MET A 247      49.336  45.911  28.108  1.00 20.49           C  
ATOM   1552  N   ARG A 248      50.844  48.414  33.569  1.00  9.29           N  
ATOM   1553  CA  ARG A 248      52.095  48.354  34.362  1.00 11.54           C  
ATOM   1554  C   ARG A 248      51.793  47.844  35.764  1.00 12.42           C  
ATOM   1555  O   ARG A 248      52.517  46.987  36.307  1.00 13.39           O  
ATOM   1556  CB  ARG A 248      52.738  49.740  34.464  1.00 13.80           C  
ATOM   1557  CG  ARG A 248      53.689  49.922  35.701  1.00 19.13           C  
ATOM   1558  CD  ARG A 248      54.267  51.351  35.698  1.00 19.34           C  
ATOM   1559  NE  ARG A 248      55.234  51.626  36.763  1.00 20.93           N  
ATOM   1560  CZ  ARG A 248      54.914  52.182  37.923  1.00 26.60           C  
ATOM   1561  NH1 ARG A 248      53.653  52.493  38.176  1.00 21.33           N  
ATOM   1562  NH2 ARG A 248      55.861  52.428  38.829  1.00 27.69           N  
ATOM   1563  N   ALA A 249      50.716  48.361  36.351  1.00 12.06           N  
ATOM   1564  CA  ALA A 249      50.322  47.933  37.700  1.00 13.26           C  
ATOM   1565  C   ALA A 249      49.951  46.466  37.720  1.00 13.94           C  
ATOM   1566  O   ALA A 249      50.313  45.747  38.646  1.00 15.57           O  
ATOM   1567  CB  ALA A 249      49.174  48.762  38.219  1.00 14.99           C  
ATOM   1568  N   LEU A 250      49.204  46.020  36.715  1.00 12.72           N  
ATOM   1569  CA  LEU A 250      48.825  44.597  36.629  1.00 13.22           C  
ATOM   1570  C   LEU A 250      50.060  43.719  36.458  1.00 13.99           C  
ATOM   1571  O   LEU A 250      50.187  42.668  37.128  1.00 15.05           O  
ATOM   1572  CB  LEU A 250      47.845  44.385  35.462  1.00 14.58           C  
ATOM   1573  CG  LEU A 250      46.428  44.925  35.692  1.00 13.05           C  
ATOM   1574  CD1 LEU A 250      45.627  44.953  34.406  1.00 17.60           C  
ATOM   1575  CD2 LEU A 250      45.678  44.114  36.764  1.00 18.97           C  
ATOM   1576  N   LYS A 251      50.987  44.139  35.584  1.00 13.35           N  
ATOM   1577  CA  LYS A 251      52.221  43.360  35.363  1.00 14.08           C  
ATOM   1578  C   LYS A 251      53.032  43.226  36.663  1.00 16.95           C  
ATOM   1579  O   LYS A 251      53.622  42.155  36.940  1.00 17.34           O  
ATOM   1580  CB  LYS A 251      53.084  44.016  34.265  1.00 14.87           C  
ATOM   1581  CG  LYS A 251      52.567  43.828  32.845  1.00 22.14           C  
ATOM   1582  CD  LYS A 251      53.368  44.715  31.892  1.00 27.05           C  
ATOM   1583  CE  LYS A 251      52.967  44.523  30.440  1.00 27.90           C  
ATOM   1584  NZ  LYS A 251      53.888  45.300  29.538  1.00 36.34           N  
ATOM   1585  N   LYS A 252      53.086  44.292  37.457  1.00 17.04           N  
ATOM   1586  CA  LYS A 252      53.843  44.253  38.716  1.00 18.63           C  
ATOM   1587  C   LYS A 252      53.281  43.181  39.647  1.00 19.25           C  
ATOM   1588  O   LYS A 252      53.997  42.658  40.514  1.00 20.22           O  
ATOM   1589  CB  LYS A 252      53.807  45.605  39.416  1.00 20.53           C  
ATOM   1590  CG  LYS A 252      54.568  46.721  38.715  1.00 39.31           C  
ATOM   1591  CD  LYS A 252      56.033  46.374  38.539  1.00 37.23           C  
ATOM   1592  CE  LYS A 252      56.875  47.628  38.363  1.00 40.80           C  
ATOM   1593  NZ  LYS A 252      58.203  47.316  37.761  1.00 42.37           N  
ATOM   1594  N   ARG A 253      52.007  42.850  39.473  1.00 18.20           N  
ATOM   1595  CA  ARG A 253      51.360  41.858  40.333  1.00 18.77           C  
ATOM   1596  C   ARG A 253      51.386  40.487  39.674  1.00 20.31           C  
ATOM   1597  O   ARG A 253      50.731  39.569  40.146  1.00 22.09           O  
ATOM   1598  CB  ARG A 253      49.899  42.210  40.609  1.00 19.42           C  
ATOM   1599  CG  ARG A 253      49.530  43.665  40.643  1.00 41.20           C  
ATOM   1600  CD  ARG A 253      48.981  44.070  41.995  1.00 26.18           C  
ATOM   1601  NE  ARG A 253      48.215  43.025  42.666  1.00 42.30           N  
ATOM   1602  CZ  ARG A 253      48.042  42.975  43.985  1.00 30.01           C  
ATOM   1603  NH1 ARG A 253      48.576  43.915  44.757  1.00 41.73           N  
ATOM   1604  NH2 ARG A 253      47.339  41.996  44.534  1.00 44.59           N  
ATOM   1605  N   GLY A 254      52.089  40.356  38.559  1.00 19.78           N  
ATOM   1606  CA  GLY A 254      52.190  39.065  37.884  1.00 20.66           C  
ATOM   1607  C   GLY A 254      50.988  38.663  37.058  1.00 21.14           C  
ATOM   1608  O   GLY A 254      50.832  37.491  36.704  1.00 21.93           O  
ATOM   1609  N   VAL A 255      50.138  39.633  36.722  1.00 20.36           N  
ATOM   1610  CA  VAL A 255      48.919  39.352  35.958  1.00 19.93           C  
ATOM   1611  C   VAL A 255      49.251  39.137  34.487  1.00 20.70           C  
ATOM   1612  O   VAL A 255      50.084  39.857  33.925  1.00 21.91           O  
ATOM   1613  CB  VAL A 255      47.877  40.498  36.140  1.00 19.55           C  
ATOM   1614  CG1 VAL A 255      46.699  40.339  35.190  1.00 14.73           C  
ATOM   1615  CG2 VAL A 255      47.377  40.519  37.563  1.00 19.85           C  
ATOM   1616  N   SER A 256      48.621  38.132  33.868  1.00 18.49           N  
ATOM   1617  CA  SER A 256      48.865  37.833  32.470  1.00 18.18           C  
ATOM   1618  C   SER A 256      47.764  38.458  31.639  1.00 17.51           C  
ATOM   1619  O   SER A 256      46.584  38.242  31.889  1.00 18.26           O  
ATOM   1620  CB  SER A 256      48.907  36.314  32.216  1.00 19.77           C  
ATOM   1621  OG  SER A 256      50.167  35.795  32.620  1.00 28.87           O  
ATOM   1622  N   ILE A 257      48.168  39.253  30.656  1.00 14.98           N  
ATOM   1623  CA  ILE A 257      47.235  39.891  29.727  1.00 13.95           C  
ATOM   1624  C   ILE A 257      47.559  39.318  28.352  1.00 13.26           C  
ATOM   1625  O   ILE A 257      48.715  39.335  27.940  1.00 14.57           O  
ATOM   1626  CB  ILE A 257      47.474  41.411  29.731  1.00 14.90           C  
ATOM   1627  CG1 ILE A 257      47.205  41.987  31.127  1.00 16.54           C  
ATOM   1628  CG2 ILE A 257      46.595  42.118  28.706  1.00 15.19           C  
ATOM   1629  CD1 ILE A 257      47.810  43.387  31.335  1.00 18.95           C  
ATOM   1630  N   PRO A 258      46.546  38.824  27.628  1.00 13.10           N  
ATOM   1631  CA  PRO A 258      45.110  38.881  27.905  1.00 12.10           C  
ATOM   1632  C   PRO A 258      44.543  37.629  28.574  1.00 12.98           C  
ATOM   1633  O   PRO A 258      43.322  37.514  28.703  1.00 12.51           O  
ATOM   1634  CB  PRO A 258      44.515  38.946  26.497  1.00 13.28           C  
ATOM   1635  CG  PRO A 258      45.438  38.095  25.682  1.00 13.99           C  
ATOM   1636  CD  PRO A 258      46.815  38.295  26.275  1.00 14.53           C  
ATOM   1637  N   GLN A 259      45.414  36.701  28.971  1.00 14.46           N  
ATOM   1638  CA  GLN A 259      44.952  35.412  29.519  1.00 16.83           C  
ATOM   1639  C   GLN A 259      44.062  35.565  30.748  1.00 16.87           C  
ATOM   1640  O   GLN A 259      43.084  34.828  30.917  1.00 18.12           O  
ATOM   1641  CB  GLN A 259      46.145  34.526  29.881  1.00 18.90           C  
ATOM   1642  CG  GLN A 259      46.948  34.051  28.688  1.00 28.47           C  
ATOM   1643  CD  GLN A 259      48.128  34.946  28.379  1.00 29.10           C  
ATOM   1644  OE1 GLN A 259      48.087  36.153  28.607  1.00 24.55           O  
ATOM   1645  NE2 GLN A 259      49.206  34.346  27.860  1.00 31.30           N  
ATOM   1646  N   GLU A 260      44.401  36.514  31.612  1.00 14.22           N  
ATOM   1647  CA  GLU A 260      43.661  36.677  32.847  1.00 13.59           C  
ATOM   1648  C   GLU A 260      42.714  37.869  32.796  1.00 14.45           C  
ATOM   1649  O   GLU A 260      41.679  37.888  33.469  1.00 15.48           O  
ATOM   1650  CB  GLU A 260      44.637  36.861  33.997  1.00 14.76           C  
ATOM   1651  CG  GLU A 260      45.405  35.578  34.291  1.00 23.56           C  
ATOM   1652  CD  GLU A 260      46.205  35.667  35.556  1.00 27.03           C  
ATOM   1653  OE1 GLU A 260      47.238  36.357  35.567  1.00 25.40           O  
ATOM   1654  OE2 GLU A 260      45.808  35.007  36.545  1.00 35.42           O  
ATOM   1655  N   VAL A 261      43.080  38.888  32.027  1.00 13.44           N  
ATOM   1656  CA  VAL A 261      42.188  40.023  31.888  1.00 12.07           C  
ATOM   1657  C   VAL A 261      42.497  40.671  30.553  1.00 12.14           C  
ATOM   1658  O   VAL A 261      43.670  40.711  30.141  1.00 12.65           O  
ATOM   1659  CB  VAL A 261      42.360  41.006  33.037  1.00 15.26           C  
ATOM   1660  CG1 VAL A 261      43.755  41.521  33.040  1.00 16.90           C  
ATOM   1661  CG2 VAL A 261      41.346  42.173  32.907  1.00 14.69           C  
ATOM   1662  N   GLN A 262      41.453  41.120  29.862  1.00 10.57           N  
ATOM   1663  CA  GLN A 262      41.614  41.771  28.552  1.00  8.98           C  
ATOM   1664  C   GLN A 262      41.509  43.272  28.744  1.00 10.37           C  
ATOM   1665  O   GLN A 262      40.793  43.712  29.641  1.00 12.34           O  
ATOM   1666  CB  GLN A 262      40.544  41.309  27.585  1.00  9.58           C  
ATOM   1667  CG  GLN A 262      40.565  39.770  27.353  1.00 12.13           C  
ATOM   1668  CD  GLN A 262      39.604  39.365  26.270  1.00 16.67           C  
ATOM   1669  OE1 GLN A 262      39.678  39.863  25.151  1.00 15.14           O  
ATOM   1670  NE2 GLN A 262      38.646  38.489  26.611  1.00 17.61           N  
ATOM   1671  N   ILE A 263      42.216  44.039  27.905  1.00  9.20           N  
ATOM   1672  CA  ILE A 263      42.286  45.509  28.067  1.00  9.98           C  
ATOM   1673  C   ILE A 263      42.026  46.150  26.714  1.00  9.47           C  
ATOM   1674  O   ILE A 263      42.587  45.722  25.692  1.00  9.15           O  
ATOM   1675  CB  ILE A 263      43.704  45.965  28.507  1.00  9.44           C  
ATOM   1676  CG1 ILE A 263      44.242  45.099  29.658  1.00 14.50           C  
ATOM   1677  CG2 ILE A 263      43.709  47.466  28.837  1.00 11.33           C  
ATOM   1678  CD1 ILE A 263      43.550  45.295  30.957  1.00 16.15           C  
ATOM   1679  N   ILE A 264      41.183  47.190  26.704  1.00  8.23           N  
ATOM   1680  CA  ILE A 264      41.076  48.047  25.521  1.00  8.31           C  
ATOM   1681  C   ILE A 264      41.241  49.496  25.975  1.00  8.16           C  
ATOM   1682  O   ILE A 264      40.698  49.883  27.016  1.00  8.34           O  
ATOM   1683  CB  ILE A 264      39.741  47.825  24.787  1.00  8.38           C  
ATOM   1684  CG1 ILE A 264      39.610  48.762  23.571  1.00  9.26           C  
ATOM   1685  CG2 ILE A 264      38.563  47.983  25.742  1.00 11.62           C  
ATOM   1686  CD1 ILE A 264      38.497  48.324  22.630  1.00 13.41           C  
ATOM   1687  N   GLY A 265      42.017  50.282  25.220  1.00  7.96           N  
ATOM   1688  CA  GLY A 265      42.200  51.720  25.519  1.00  7.72           C  
ATOM   1689  C   GLY A 265      41.435  52.609  24.548  1.00  8.82           C  
ATOM   1690  O   GLY A 265      40.398  52.208  23.991  1.00 10.27           O  
ATOM   1691  N   PHE A 266      41.949  53.832  24.341  1.00  7.38           N  
ATOM   1692  CA  PHE A 266      41.360  54.728  23.361  1.00  7.46           C  
ATOM   1693  C   PHE A 266      42.429  55.703  22.920  1.00  8.05           C  
ATOM   1694  O   PHE A 266      43.148  56.234  23.765  1.00  9.01           O  
ATOM   1695  CB  PHE A 266      40.213  55.535  24.005  1.00  7.82           C  
ATOM   1696  CG  PHE A 266      39.145  56.005  23.030  1.00  8.17           C  
ATOM   1697  CD1 PHE A 266      37.898  55.382  23.008  1.00  9.71           C  
ATOM   1698  CD2 PHE A 266      39.352  57.107  22.218  1.00  9.17           C  
ATOM   1699  CE1 PHE A 266      36.893  55.826  22.147  1.00 10.59           C  
ATOM   1700  CE2 PHE A 266      38.359  57.551  21.351  1.00  8.10           C  
ATOM   1701  CZ  PHE A 266      37.120  56.896  21.314  1.00  9.46           C  
ATOM   1702  N   ASP A 267      42.503  55.928  21.608  1.00  8.66           N  
ATOM   1703  CA  ASP A 267      43.315  56.955  20.937  1.00  7.98           C  
ATOM   1704  C   ASP A 267      44.043  56.389  19.707  1.00  8.52           C  
ATOM   1705  O   ASP A 267      44.162  57.062  18.691  1.00  9.19           O  
ATOM   1706  CB  ASP A 267      44.452  57.526  21.783  1.00  8.32           C  
ATOM   1707  CG  ASP A 267      43.988  58.492  22.858  1.00 10.91           C  
ATOM   1708  OD1 ASP A 267      42.853  59.038  22.773  1.00 10.72           O  
ATOM   1709  OD2 ASP A 267      44.820  58.749  23.769  1.00 10.94           O  
ATOM   1710  N   ASN A 268      44.612  55.197  19.862  1.00  8.49           N  
ATOM   1711  CA  ASN A 268      45.684  54.744  18.962  1.00  7.98           C  
ATOM   1712  C   ASN A 268      46.831  55.749  18.954  1.00 10.02           C  
ATOM   1713  O   ASN A 268      47.292  56.178  17.892  1.00 11.68           O  
ATOM   1714  CB  ASN A 268      45.186  54.512  17.533  1.00  8.45           C  
ATOM   1715  CG  ASN A 268      46.191  53.706  16.712  1.00 13.35           C  
ATOM   1716  OD1 ASN A 268      47.086  53.067  17.273  1.00 13.12           O  
ATOM   1717  ND2 ASN A 268      46.062  53.754  15.377  1.00 14.92           N  
ATOM   1718  N   SER A 269      47.308  56.093  20.147  1.00  9.43           N  
ATOM   1719  CA  SER A 269      48.559  56.846  20.237  1.00  9.59           C  
ATOM   1720  C   SER A 269      49.772  55.889  20.295  1.00  9.84           C  
ATOM   1721  O   SER A 269      49.630  54.657  20.451  1.00  9.89           O  
ATOM   1722  CB  SER A 269      48.551  57.771  21.454  1.00 11.27           C  
ATOM   1723  OG  SER A 269      48.597  57.016  22.656  1.00 11.72           O  
ATOM   1724  N   PHE A 270      50.974  56.433  20.136  1.00  9.25           N  
ATOM   1725  CA  PHE A 270      52.085  55.524  19.916  1.00  9.82           C  
ATOM   1726  C   PHE A 270      52.394  54.625  21.098  1.00  9.78           C  
ATOM   1727  O   PHE A 270      53.016  53.575  20.939  1.00 10.64           O  
ATOM   1728  CB  PHE A 270      53.342  56.282  19.433  1.00  9.51           C  
ATOM   1729  CG  PHE A 270      54.022  57.127  20.486  1.00  9.89           C  
ATOM   1730  CD1 PHE A 270      54.819  56.530  21.456  1.00 12.89           C  
ATOM   1731  CD2 PHE A 270      53.950  58.527  20.433  1.00  9.59           C  
ATOM   1732  CE1 PHE A 270      55.510  57.309  22.433  1.00 12.58           C  
ATOM   1733  CE2 PHE A 270      54.633  59.319  21.385  1.00 13.29           C  
ATOM   1734  CZ  PHE A 270      55.411  58.698  22.393  1.00 12.44           C  
ATOM   1735  N   ILE A 271      51.951  55.004  22.288  1.00  8.46           N  
ATOM   1736  CA  ILE A 271      52.289  54.206  23.466  1.00  9.13           C  
ATOM   1737  C   ILE A 271      51.695  52.804  23.390  1.00 10.41           C  
ATOM   1738  O   ILE A 271      52.255  51.845  23.950  1.00 10.50           O  
ATOM   1739  CB  ILE A 271      51.858  54.935  24.771  1.00  8.33           C  
ATOM   1740  CG1 ILE A 271      52.465  54.255  25.998  1.00 11.63           C  
ATOM   1741  CG2 ILE A 271      50.358  55.000  24.879  1.00 10.57           C  
ATOM   1742  CD1 ILE A 271      53.982  54.481  26.096  1.00 15.45           C  
ATOM   1743  N   GLY A 272      50.568  52.659  22.709  1.00  9.73           N  
ATOM   1744  CA  GLY A 272      49.926  51.338  22.606  1.00 10.72           C  
ATOM   1745  C   GLY A 272      50.692  50.324  21.760  1.00 12.74           C  
ATOM   1746  O   GLY A 272      50.554  49.099  21.947  1.00 13.47           O  
ATOM   1747  N   GLU A 273      51.527  50.817  20.847  1.00 12.70           N  
ATOM   1748  CA  GLU A 273      52.309  49.942  19.985  1.00 15.65           C  
ATOM   1749  C   GLU A 273      53.699  49.763  20.564  1.00 16.58           C  
ATOM   1750  O   GLU A 273      54.377  48.742  20.384  1.00 16.30           O  
ATOM   1751  CB  GLU A 273      52.353  50.524  18.559  1.00 18.65           C  
ATOM   1752  CG  GLU A 273      53.072  49.640  17.536  1.00 30.24           C  
ATOM   1753  CD  GLU A 273      52.628  48.174  17.557  1.00 32.91           C  
ATOM   1754  OE1 GLU A 273      51.430  47.901  17.310  1.00 32.76           O  
ATOM   1755  OE2 GLU A 273      53.490  47.287  17.799  1.00 32.85           O  
ATOM   1756  N   LEU A 274      54.124  50.755  21.318  1.00 15.39           N  
ATOM   1757  CA  LEU A 274      55.451  50.742  21.853  1.00 17.87           C  
ATOM   1758  C   LEU A 274      55.555  49.689  22.940  1.00 19.18           C  
ATOM   1759  O   LEU A 274      56.582  49.001  23.027  1.00 21.63           O  
ATOM   1760  CB  LEU A 274      55.765  52.130  22.412  1.00 17.28           C  
ATOM   1761  CG  LEU A 274      57.148  52.286  22.994  1.00 18.79           C  
ATOM   1762  CD1 LEU A 274      58.178  51.870  21.973  1.00 16.78           C  
ATOM   1763  CD2 LEU A 274      57.304  53.736  23.382  1.00 16.00           C  
ATOM   1764  N   LEU A 275      54.501  49.536  23.743  1.00 20.70           N  
ATOM   1765  CA  LEU A 275      54.462  48.532  24.831  1.00 24.05           C  
ATOM   1766  C   LEU A 275      53.861  47.135  24.488  1.00 24.27           C  
ATOM   1767  O   LEU A 275      53.344  46.926  23.405  1.00 21.73           O  
ATOM   1768  CB  LEU A 275      53.734  49.091  26.052  1.00 25.93           C  
ATOM   1769  CG  LEU A 275      52.246  49.471  25.857  1.00 38.30           C  
ATOM   1770  CD1 LEU A 275      51.423  48.409  25.127  1.00 26.83           C  
ATOM   1771  CD2 LEU A 275      51.619  49.742  27.183  1.00 33.10           C  
ATOM   1772  N   TYR A 276      53.907  46.210  25.457  1.00 24.90           N  
ATOM   1773  CA  TYR A 276      53.713  44.766  25.202  1.00 26.18           C  
ATOM   1774  C   TYR A 276      52.977  44.062  26.337  1.00 26.24           C  
ATOM   1775  O   TYR A 276      53.285  44.275  27.513  1.00 28.82           O  
ATOM   1776  CB  TYR A 276      55.089  44.119  25.006  1.00 28.16           C  
ATOM   1777  CG  TYR A 276      55.072  42.617  24.861  1.00 43.83           C  
ATOM   1778  CD1 TYR A 276      55.284  42.022  23.628  1.00 35.29           C  
ATOM   1779  CD2 TYR A 276      54.856  41.799  25.958  1.00 33.93           C  
ATOM   1780  CE1 TYR A 276      55.271  40.641  23.481  1.00 46.14           C  
ATOM   1781  CE2 TYR A 276      54.844  40.416  25.826  1.00 47.34           C  
ATOM   1782  CZ  TYR A 276      55.054  39.846  24.582  1.00 37.01           C  
ATOM   1783  OH  TYR A 276      55.046  38.476  24.446  1.00 47.99           O  
ATOM   1784  N   PRO A 277      51.973  43.243  26.003  1.00 23.14           N  
ATOM   1785  CA  PRO A 277      51.505  43.050  24.637  1.00 19.76           C  
ATOM   1786  C   PRO A 277      50.932  44.357  24.102  1.00 16.22           C  
ATOM   1787  O   PRO A 277      50.537  45.219  24.888  1.00 14.99           O  
ATOM   1788  CB  PRO A 277      50.407  41.986  24.778  1.00 20.57           C  
ATOM   1789  CG  PRO A 277      49.991  42.026  26.191  1.00 26.78           C  
ATOM   1790  CD  PRO A 277      51.151  42.522  26.990  1.00 23.23           C  
ATOM   1791  N   SER A 278      50.899  44.499  22.779  1.00 12.73           N  
ATOM   1792  CA  SER A 278      50.394  45.721  22.168  1.00 11.70           C  
ATOM   1793  C   SER A 278      48.896  45.881  22.428  1.00 10.60           C  
ATOM   1794  O   SER A 278      48.166  44.905  22.533  1.00 10.37           O  
ATOM   1795  CB  SER A 278      50.677  45.742  20.680  1.00 12.69           C  
ATOM   1796  OG  SER A 278      50.136  44.549  20.097  1.00 19.31           O  
ATOM   1797  N   LEU A 279      48.462  47.138  22.507  1.00  9.78           N  
ATOM   1798  CA  LEU A 279      47.174  47.494  23.090  1.00  9.07           C  
ATOM   1799  C   LEU A 279      46.044  47.581  22.065  1.00  9.18           C  
ATOM   1800  O   LEU A 279      46.101  48.381  21.131  1.00  9.69           O  
ATOM   1801  CB  LEU A 279      47.324  48.873  23.761  1.00  8.78           C  
ATOM   1802  CG  LEU A 279      46.096  49.482  24.424  1.00  8.64           C  
ATOM   1803  CD1 LEU A 279      45.615  48.639  25.578  1.00 10.00           C  
ATOM   1804  CD2 LEU A 279      46.493  50.854  24.939  1.00 10.99           C  
ATOM   1805  N   THR A 280      44.994  46.790  22.251  1.00  8.60           N  
ATOM   1806  CA  THR A 280      43.770  46.988  21.483  1.00  8.51           C  
ATOM   1807  C   THR A 280      43.184  48.342  21.858  1.00  8.88           C  
ATOM   1808  O   THR A 280      43.196  48.733  23.039  1.00  8.42           O  
ATOM   1809  CB  THR A 280      42.771  45.892  21.818  1.00 10.30           C  
ATOM   1810  OG1 THR A 280      43.318  44.644  21.377  1.00  9.63           O  
ATOM   1811  CG2 THR A 280      41.420  46.154  21.147  1.00  8.44           C  
ATOM   1812  N   THR A 281      42.691  49.070  20.871  1.00  7.52           N  
ATOM   1813  CA  THR A 281      42.312  50.460  21.145  1.00  7.86           C  
ATOM   1814  C   THR A 281      41.307  50.939  20.113  1.00  8.96           C  
ATOM   1815  O   THR A 281      40.944  50.211  19.196  1.00 10.17           O  
ATOM   1816  CB  THR A 281      43.573  51.368  21.179  1.00  9.35           C  
ATOM   1817  OG1 THR A 281      43.221  52.691  21.625  1.00 11.06           O  
ATOM   1818  CG2 THR A 281      44.201  51.438  19.785  1.00 10.33           C  
ATOM   1819  N   ILE A 282      40.815  52.152  20.308  1.00  9.02           N  
ATOM   1820  CA  ILE A 282      39.932  52.800  19.358  1.00  9.03           C  
ATOM   1821  C   ILE A 282      40.727  53.939  18.739  1.00  9.36           C  
ATOM   1822  O   ILE A 282      41.262  54.815  19.428  1.00  9.19           O  
ATOM   1823  CB  ILE A 282      38.699  53.416  20.051  1.00  8.52           C  
ATOM   1824  CG1 ILE A 282      37.945  52.359  20.882  1.00 11.18           C  
ATOM   1825  CG2 ILE A 282      37.772  54.061  19.001  1.00 10.24           C  
ATOM   1826  CD1 ILE A 282      37.368  51.190  20.040  1.00  9.55           C  
ATOM   1827  N   ASN A 283      40.822  53.923  17.419  1.00  8.62           N  
ATOM   1828  CA  ASN A 283      41.558  54.940  16.693  1.00  8.88           C  
ATOM   1829  C   ASN A 283      40.879  56.295  16.659  1.00  9.45           C  
ATOM   1830  O   ASN A 283      39.747  56.396  16.190  1.00 10.81           O  
ATOM   1831  CB  ASN A 283      41.718  54.475  15.230  1.00 10.10           C  
ATOM   1832  CG  ASN A 283      42.618  55.381  14.422  1.00 13.77           C  
ATOM   1833  OD1 ASN A 283      43.843  55.378  14.616  1.00 14.28           O  
ATOM   1834  ND2 ASN A 283      42.028  56.151  13.489  1.00 13.54           N  
ATOM   1835  N   GLN A 284      41.583  57.346  17.111  1.00  9.21           N  
ATOM   1836  CA  GLN A 284      41.212  58.715  16.720  1.00  8.80           C  
ATOM   1837  C   GLN A 284      41.988  59.123  15.488  1.00  9.35           C  
ATOM   1838  O   GLN A 284      43.220  58.930  15.440  1.00  9.49           O  
ATOM   1839  CB  GLN A 284      41.553  59.718  17.833  1.00  9.16           C  
ATOM   1840  CG  GLN A 284      40.743  59.554  19.089  1.00  9.28           C  
ATOM   1841  CD  GLN A 284      40.758  60.827  19.913  1.00  8.61           C  
ATOM   1842  OE1 GLN A 284      40.191  61.829  19.499  1.00 10.61           O  
ATOM   1843  NE2 GLN A 284      41.364  60.782  21.112  1.00  9.70           N  
ATOM   1844  N   PRO A 285      41.293  59.654  14.468  1.00  9.13           N  
ATOM   1845  CA  PRO A 285      41.971  59.889  13.190  1.00  9.82           C  
ATOM   1846  C   PRO A 285      42.718  61.209  13.209  1.00  9.91           C  
ATOM   1847  O   PRO A 285      42.193  62.255  12.788  1.00 10.97           O  
ATOM   1848  CB  PRO A 285      40.822  59.930  12.176  1.00 11.33           C  
ATOM   1849  CG  PRO A 285      39.626  60.420  12.986  1.00 12.24           C  
ATOM   1850  CD  PRO A 285      39.827  59.829  14.386  1.00 10.02           C  
ATOM   1851  N   ILE A 286      43.941  61.169  13.743  1.00  9.52           N  
ATOM   1852  CA  ILE A 286      44.700  62.393  13.970  1.00 10.19           C  
ATOM   1853  C   ILE A 286      44.856  63.219  12.691  1.00 10.22           C  
ATOM   1854  O   ILE A 286      44.741  64.452  12.715  1.00  9.78           O  
ATOM   1855  CB  ILE A 286      46.087  62.054  14.585  1.00 10.88           C  
ATOM   1856  CG1 ILE A 286      45.862  61.545  16.023  1.00 14.50           C  
ATOM   1857  CG2 ILE A 286      46.978  63.270  14.595  1.00 15.60           C  
ATOM   1858  CD1 ILE A 286      47.164  61.152  16.785  1.00 16.93           C  
ATOM   1859  N   GLU A 287      45.140  62.563  11.562  1.00 10.97           N  
ATOM   1860  CA  GLU A 287      45.313  63.343  10.330  1.00 12.47           C  
ATOM   1861  C   GLU A 287      44.027  64.091   9.963  1.00 12.06           C  
ATOM   1862  O   GLU A 287      44.067  65.286   9.583  1.00 12.40           O  
ATOM   1863  CB  GLU A 287      45.760  62.468   9.144  1.00 13.75           C  
ATOM   1864  CG  GLU A 287      47.179  61.939   9.300  1.00 26.11           C  
ATOM   1865  CD  GLU A 287      48.233  62.939   8.883  1.00 25.79           C  
ATOM   1866  OE1 GLU A 287      47.927  63.830   8.055  1.00 36.48           O  
ATOM   1867  OE2 GLU A 287      49.381  62.820   9.365  1.00 37.29           O  
ATOM   1868  N   ALA A 288      42.885  63.403  10.014  1.00 10.24           N  
ATOM   1869  CA  ALA A 288      41.618  64.079   9.698  1.00  9.76           C  
ATOM   1870  C   ALA A 288      41.289  65.175  10.717  1.00  9.76           C  
ATOM   1871  O   ALA A 288      40.767  66.243  10.352  1.00 10.46           O  
ATOM   1872  CB  ALA A 288      40.461  63.072   9.628  1.00 10.46           C  
ATOM   1873  N   LEU A 289      41.546  64.917  11.998  1.00  9.58           N  
ATOM   1874  CA  LEU A 289      41.274  65.940  13.018  1.00  9.51           C  
ATOM   1875  C   LEU A 289      42.125  67.175  12.761  1.00  9.97           C  
ATOM   1876  O   LEU A 289      41.627  68.301  12.803  1.00 10.32           O  
ATOM   1877  CB  LEU A 289      41.608  65.408  14.412  1.00  9.06           C  
ATOM   1878  CG  LEU A 289      40.646  64.340  14.924  1.00  9.64           C  
ATOM   1879  CD1 LEU A 289      41.291  63.609  16.111  1.00 10.69           C  
ATOM   1880  CD2 LEU A 289      39.303  64.978  15.350  1.00 10.89           C  
ATOM   1881  N   ALA A 290      43.424  66.963  12.514  1.00 10.06           N  
ATOM   1882  CA  ALA A 290      44.337  68.091  12.329  1.00  9.68           C  
ATOM   1883  C   ALA A 290      43.992  68.867  11.075  1.00  8.90           C  
ATOM   1884  O   ALA A 290      43.988  70.099  11.063  1.00  9.65           O  
ATOM   1885  CB  ALA A 290      45.795  67.558  12.259  1.00  9.29           C  
ATOM   1886  N   TYR A 291      43.736  68.147   9.983  1.00 10.32           N  
ATOM   1887  CA  TYR A 291      43.322  68.785   8.750  1.00  9.63           C  
ATOM   1888  C   TYR A 291      42.103  69.671   8.979  1.00 10.32           C  
ATOM   1889  O   TYR A 291      42.055  70.841   8.542  1.00 10.53           O  
ATOM   1890  CB  TYR A 291      42.999  67.718   7.680  1.00 10.49           C  
ATOM   1891  CG  TYR A 291      42.306  68.273   6.451  1.00 14.78           C  
ATOM   1892  CD1 TYR A 291      43.032  68.841   5.433  1.00 18.56           C  
ATOM   1893  CD2 TYR A 291      40.923  68.230   6.332  1.00 16.64           C  
ATOM   1894  CE1 TYR A 291      42.399  69.376   4.309  1.00 18.52           C  
ATOM   1895  CE2 TYR A 291      40.279  68.745   5.198  1.00 23.37           C  
ATOM   1896  CZ  TYR A 291      41.035  69.310   4.202  1.00 21.67           C  
ATOM   1897  OH  TYR A 291      40.415  69.816   3.075  1.00 26.75           O  
ATOM   1898  N   THR A 292      41.116  69.118   9.665  1.00  8.88           N  
ATOM   1899  CA  THR A 292      39.835  69.794   9.856  1.00  9.68           C  
ATOM   1900  C   THR A 292      39.998  71.032  10.734  1.00  9.03           C  
ATOM   1901  O   THR A 292      39.464  72.084  10.444  1.00  9.57           O  
ATOM   1902  CB  THR A 292      38.828  68.798  10.444  1.00 10.33           C  
ATOM   1903  OG1 THR A 292      38.643  67.756   9.472  1.00 11.32           O  
ATOM   1904  CG2 THR A 292      37.468  69.466  10.750  1.00 10.12           C  
ATOM   1905  N   ILE A 293      40.758  70.886  11.823  1.00  7.70           N  
ATOM   1906  CA  ILE A 293      40.953  71.996  12.737  1.00  8.26           C  
ATOM   1907  C   ILE A 293      41.591  73.162  11.980  1.00  9.30           C  
ATOM   1908  O   ILE A 293      41.156  74.322  12.099  1.00 10.45           O  
ATOM   1909  CB  ILE A 293      41.876  71.540  13.884  1.00  9.47           C  
ATOM   1910  CG1 ILE A 293      41.140  70.573  14.823  1.00  9.75           C  
ATOM   1911  CG2 ILE A 293      42.486  72.721  14.617  1.00 12.01           C  
ATOM   1912  CD1 ILE A 293      42.059  69.839  15.834  1.00 10.69           C  
ATOM   1913  N   ILE A 294      42.628  72.864  11.187  1.00  8.43           N  
ATOM   1914  CA  ILE A 294      43.309  73.938  10.472  1.00  9.01           C  
ATOM   1915  C   ILE A 294      42.426  74.512   9.348  1.00  9.51           C  
ATOM   1916  O   ILE A 294      42.351  75.728   9.157  1.00 10.44           O  
ATOM   1917  CB  ILE A 294      44.643  73.431   9.940  1.00  8.77           C  
ATOM   1918  CG1 ILE A 294      45.601  73.244  11.114  1.00  8.56           C  
ATOM   1919  CG2 ILE A 294      45.207  74.401   8.891  1.00 10.14           C  
ATOM   1920  CD1 ILE A 294      45.953  74.532  11.855  1.00 10.33           C  
ATOM   1921  N   GLU A 295      41.746  73.653   8.599  1.00  9.10           N  
ATOM   1922  CA  GLU A 295      40.867  74.142   7.542  1.00 10.89           C  
ATOM   1923  C   GLU A 295      39.852  75.107   8.097  1.00  9.91           C  
ATOM   1924  O   GLU A 295      39.623  76.166   7.517  1.00 11.01           O  
ATOM   1925  CB  GLU A 295      40.104  72.991   6.886  1.00 13.26           C  
ATOM   1926  CG  GLU A 295      40.884  72.205   5.848  1.00 24.51           C  
ATOM   1927  CD  GLU A 295      41.399  73.053   4.701  1.00 17.40           C  
ATOM   1928  OE1 GLU A 295      40.589  73.709   3.989  1.00 26.76           O  
ATOM   1929  OE2 GLU A 295      42.612  73.045   4.510  1.00 21.42           O  
ATOM   1930  N   LEU A 296      39.236  74.752   9.219  1.00  8.19           N  
ATOM   1931  CA  LEU A 296      38.161  75.586   9.770  1.00  8.78           C  
ATOM   1932  C   LEU A 296      38.738  76.858  10.394  1.00  9.57           C  
ATOM   1933  O   LEU A 296      38.176  77.951  10.240  1.00 10.03           O  
ATOM   1934  CB  LEU A 296      37.359  74.805  10.805  1.00  9.59           C  
ATOM   1935  CG  LEU A 296      36.612  73.614  10.226  1.00  9.16           C  
ATOM   1936  CD1 LEU A 296      35.984  72.770  11.339  1.00  9.42           C  
ATOM   1937  CD2 LEU A 296      35.505  74.116   9.256  1.00 12.40           C  
ATOM   1938  N   LEU A 297      39.850  76.741  11.114  1.00  8.77           N  
ATOM   1939  CA  LEU A 297      40.428  77.959  11.693  1.00  9.18           C  
ATOM   1940  C   LEU A 297      40.786  78.956  10.586  1.00 10.04           C  
ATOM   1941  O   LEU A 297      40.557  80.171  10.719  1.00 10.82           O  
ATOM   1942  CB  LEU A 297      41.672  77.610  12.553  1.00  9.26           C  
ATOM   1943  CG  LEU A 297      42.307  78.808  13.266  1.00 11.96           C  
ATOM   1944  CD1 LEU A 297      41.318  79.430  14.240  1.00 12.36           C  
ATOM   1945  CD2 LEU A 297      43.595  78.350  13.985  1.00 10.38           C  
ATOM   1946  N   ILE A 298      41.324  78.463   9.477  1.00  9.27           N  
ATOM   1947  CA  ILE A 298      41.693  79.366   8.390  1.00 12.22           C  
ATOM   1948  C   ILE A 298      40.442  80.032   7.775  1.00 12.72           C  
ATOM   1949  O   ILE A 298      40.467  81.204   7.381  1.00 12.79           O  
ATOM   1950  CB  ILE A 298      42.482  78.627   7.311  1.00 14.54           C  
ATOM   1951  CG1 ILE A 298      43.894  78.292   7.780  1.00 22.38           C  
ATOM   1952  CG2 ILE A 298      42.497  79.427   5.995  1.00 16.94           C  
ATOM   1953  CD1 ILE A 298      44.642  79.454   8.284  1.00 26.48           C  
ATOM   1954  N   LYS A 299      39.334  79.299   7.712  1.00 12.94           N  
ATOM   1955  CA  LYS A 299      38.076  79.953   7.268  1.00 13.86           C  
ATOM   1956  C   LYS A 299      37.700  81.115   8.167  1.00 14.55           C  
ATOM   1957  O   LYS A 299      37.318  82.205   7.682  1.00 16.80           O  
ATOM   1958  CB  LYS A 299      36.902  78.954   7.231  1.00 13.22           C  
ATOM   1959  CG  LYS A 299      36.986  77.977   6.114  1.00 17.46           C  
ATOM   1960  CD  LYS A 299      35.700  77.142   6.072  1.00 18.65           C  
ATOM   1961  CE  LYS A 299      35.937  75.848   5.346  1.00 24.80           C  
ATOM   1962  NZ  LYS A 299      36.164  76.107   3.917  1.00 24.42           N  
ATOM   1963  N   ILE A 300      37.783  80.907   9.476  1.00 14.71           N  
ATOM   1964  CA  ILE A 300      37.436  81.963  10.410  1.00 14.33           C  
ATOM   1965  C   ILE A 300      38.437  83.115  10.242  1.00 15.70           C  
ATOM   1966  O   ILE A 300      38.044  84.278  10.181  1.00 15.50           O  
ATOM   1967  CB  ILE A 300      37.398  81.505  11.888  1.00 14.42           C  
ATOM   1968  CG1 ILE A 300      36.448  80.313  12.110  1.00 14.48           C  
ATOM   1969  CG2 ILE A 300      36.993  82.666  12.810  1.00 16.05           C  
ATOM   1970  CD1 ILE A 300      35.014  80.628  11.785  1.00 17.37           C  
ATOM   1971  N   ILE A 301      39.732  82.793  10.156  1.00 14.06           N  
ATOM   1972  CA  ILE A 301      40.726  83.854   9.994  1.00 14.82           C  
ATOM   1973  C   ILE A 301      40.441  84.710   8.772  1.00 16.48           C  
ATOM   1974  O   ILE A 301      40.580  85.946   8.812  1.00 18.22           O  
ATOM   1975  CB  ILE A 301      42.155  83.260   9.891  1.00 13.79           C  
ATOM   1976  CG1 ILE A 301      42.583  82.686  11.244  1.00 11.45           C  
ATOM   1977  CG2 ILE A 301      43.147  84.323   9.333  1.00 14.05           C  
ATOM   1978  CD1 ILE A 301      43.884  81.850  11.143  1.00 13.75           C  
ATOM   1979  N   ASN A 302      40.064  84.051   7.678  1.00 15.60           N  
ATOM   1980  CA  ASN A 302      39.866  84.687   6.377  1.00 16.98           C  
ATOM   1981  C   ASN A 302      38.492  85.324   6.219  1.00 19.02           C  
ATOM   1982  O   ASN A 302      38.230  86.007   5.215  1.00 20.90           O  
ATOM   1983  CB  ASN A 302      40.030  83.643   5.270  1.00 17.34           C  
ATOM   1984  CG  ASN A 302      41.486  83.208   5.077  1.00 24.08           C  
ATOM   1985  OD1 ASN A 302      42.391  83.791   5.644  1.00 23.95           O  
ATOM   1986  ND2 ASN A 302      41.698  82.177   4.273  1.00 24.23           N  
ATOM   1987  N   GLY A 303      37.614  85.077   7.187  1.00 18.28           N  
ATOM   1988  CA  GLY A 303      36.247  85.597   7.155  1.00 18.95           C  
ATOM   1989  C   GLY A 303      35.342  84.888   6.158  1.00 19.39           C  
ATOM   1990  O   GLY A 303      34.406  85.494   5.616  1.00 21.02           O  
ATOM   1991  N   GLU A 304      35.605  83.608   5.912  1.00 17.34           N  
ATOM   1992  CA  GLU A 304      34.822  82.836   4.973  1.00 17.57           C  
ATOM   1993  C   GLU A 304      33.607  82.247   5.673  1.00 17.61           C  
ATOM   1994  O   GLU A 304      33.600  82.065   6.901  1.00 17.30           O  
ATOM   1995  CB  GLU A 304      35.687  81.749   4.337  1.00 19.55           C  
ATOM   1996  CG  GLU A 304      36.836  82.340   3.535  1.00 28.71           C  
ATOM   1997  CD  GLU A 304      37.876  81.330   3.107  1.00 32.76           C  
ATOM   1998  OE1 GLU A 304      37.631  80.110   3.230  1.00 33.20           O  
ATOM   1999  OE2 GLU A 304      38.949  81.771   2.627  1.00 34.82           O  
ATOM   2000  N   GLY A 305      32.570  81.969   4.897  1.00 16.11           N  
ATOM   2001  CA  GLY A 305      31.355  81.465   5.488  1.00 14.57           C  
ATOM   2002  C   GLY A 305      31.502  80.029   5.906  1.00 13.52           C  
ATOM   2003  O   GLY A 305      32.013  79.188   5.160  1.00 14.12           O  
ATOM   2004  N   VAL A 306      31.016  79.743   7.108  1.00 12.23           N  
ATOM   2005  CA  VAL A 306      30.984  78.377   7.609  1.00 11.09           C  
ATOM   2006  C   VAL A 306      29.944  78.300   8.707  1.00  9.90           C  
ATOM   2007  O   VAL A 306      29.880  79.188   9.545  1.00 10.09           O  
ATOM   2008  CB  VAL A 306      32.372  77.899   8.112  1.00 12.93           C  
ATOM   2009  CG1 VAL A 306      32.937  78.843   9.092  1.00 16.23           C  
ATOM   2010  CG2 VAL A 306      32.306  76.502   8.716  1.00 14.89           C  
ATOM   2011  N   LEU A 307      29.124  77.253   8.695  1.00  8.86           N  
ATOM   2012  CA  LEU A 307      28.140  77.057   9.759  1.00  7.91           C  
ATOM   2013  C   LEU A 307      28.885  76.654  11.023  1.00  9.38           C  
ATOM   2014  O   LEU A 307      29.701  75.727  10.992  1.00  9.81           O  
ATOM   2015  CB  LEU A 307      27.153  75.949   9.358  1.00  7.98           C  
ATOM   2016  CG  LEU A 307      26.104  75.592  10.414  1.00  9.54           C  
ATOM   2017  CD1 LEU A 307      25.258  76.780  10.766  1.00 10.99           C  
ATOM   2018  CD2 LEU A 307      25.219  74.425   9.967  1.00  9.67           C  
ATOM   2019  N   ILE A 308      28.614  77.341  12.136  1.00 10.09           N  
ATOM   2020  CA  ILE A 308      29.280  76.994  13.396  1.00 10.47           C  
ATOM   2021  C   ILE A 308      28.560  75.832  14.041  1.00 11.19           C  
ATOM   2022  O   ILE A 308      27.513  76.019  14.663  1.00 13.03           O  
ATOM   2023  CB  ILE A 308      29.307  78.228  14.321  1.00 10.35           C  
ATOM   2024  CG1 ILE A 308      29.954  79.396  13.607  1.00 13.61           C  
ATOM   2025  CG2 ILE A 308      30.020  77.904  15.619  1.00 14.52           C  
ATOM   2026  CD1 ILE A 308      31.301  79.119  13.159  1.00 18.46           C  
ATOM   2027  N   GLU A 309      29.083  74.614  13.856  1.00  8.93           N  
ATOM   2028  CA  GLU A 309      28.436  73.391  14.310  1.00  9.67           C  
ATOM   2029  C   GLU A 309      29.529  72.387  14.657  1.00 10.89           C  
ATOM   2030  O   GLU A 309      30.703  72.646  14.365  1.00 11.92           O  
ATOM   2031  CB  GLU A 309      27.587  72.801  13.167  1.00  9.68           C  
ATOM   2032  CG  GLU A 309      28.388  72.470  11.902  1.00 10.19           C  
ATOM   2033  CD  GLU A 309      27.539  71.912  10.756  1.00 12.33           C  
ATOM   2034  OE1 GLU A 309      26.534  71.226  11.030  1.00 13.83           O  
ATOM   2035  OE2 GLU A 309      27.905  72.156   9.587  1.00 11.86           O  
ATOM   2036  N   ASP A 310      29.156  71.249  15.250  1.00 11.23           N  
ATOM   2037  CA  ASP A 310      30.154  70.228  15.614  1.00 10.92           C  
ATOM   2038  C   ASP A 310      30.694  69.512  14.380  1.00 11.09           C  
ATOM   2039  O   ASP A 310      29.933  69.139  13.475  1.00 11.04           O  
ATOM   2040  CB  ASP A 310      29.532  69.130  16.482  1.00 12.05           C  
ATOM   2041  CG  ASP A 310      29.069  69.623  17.847  1.00 18.64           C  
ATOM   2042  OD1 ASP A 310      29.532  70.678  18.311  1.00 16.57           O  
ATOM   2043  OD2 ASP A 310      28.224  68.936  18.461  1.00 19.29           O  
ATOM   2044  N   TYR A 311      32.012  69.288  14.369  1.00  9.80           N  
ATOM   2045  CA  TYR A 311      32.636  68.436  13.357  1.00  9.70           C  
ATOM   2046  C   TYR A 311      33.115  67.185  14.057  1.00 11.21           C  
ATOM   2047  O   TYR A 311      33.996  67.282  14.904  1.00 13.25           O  
ATOM   2048  CB  TYR A 311      33.831  69.148  12.722  1.00  8.70           C  
ATOM   2049  CG  TYR A 311      33.423  70.120  11.614  1.00  9.22           C  
ATOM   2050  CD1 TYR A 311      32.686  71.263  11.893  1.00  9.42           C  
ATOM   2051  CD2 TYR A 311      33.768  69.860  10.282  1.00  9.19           C  
ATOM   2052  CE1 TYR A 311      32.288  72.134  10.867  1.00 10.09           C  
ATOM   2053  CE2 TYR A 311      33.389  70.730   9.262  1.00  9.67           C  
ATOM   2054  CZ  TYR A 311      32.641  71.850   9.552  1.00  9.41           C  
ATOM   2055  OH  TYR A 311      32.275  72.676   8.501  1.00 11.31           O  
ATOM   2056  N   ILE A 312      32.522  66.033  13.751  1.00  9.07           N  
ATOM   2057  CA  ILE A 312      32.837  64.790  14.471  1.00  9.38           C  
ATOM   2058  C   ILE A 312      33.430  63.777  13.515  1.00 10.90           C  
ATOM   2059  O   ILE A 312      32.804  63.435  12.493  1.00 11.48           O  
ATOM   2060  CB  ILE A 312      31.538  64.237  15.101  1.00 10.01           C  
ATOM   2061  CG1 ILE A 312      30.964  65.287  16.046  1.00 13.86           C  
ATOM   2062  CG2 ILE A 312      31.810  62.947  15.843  1.00 16.50           C  
ATOM   2063  CD1 ILE A 312      29.653  64.873  16.691  1.00 22.76           C  
ATOM   2064  N   MET A 313      34.655  63.319  13.799  1.00  9.70           N  
ATOM   2065  CA  MET A 313      35.363  62.381  12.917  1.00 10.06           C  
ATOM   2066  C   MET A 313      35.192  60.917  13.343  1.00 11.53           C  
ATOM   2067  O   MET A 313      35.212  60.579  14.521  1.00 11.04           O  
ATOM   2068  CB  MET A 313      36.897  62.664  12.867  1.00 12.19           C  
ATOM   2069  CG  MET A 313      37.390  64.026  12.379  1.00 17.78           C  
ATOM   2070  SD  MET A 313      36.878  64.504  10.696  1.00 18.88           S  
ATOM   2071  CE  MET A 313      35.761  65.606  11.419  1.00  7.51           C  
ATOM   2072  N   GLU A 314      35.070  60.038  12.354  1.00 10.97           N  
ATOM   2073  CA  GLU A 314      34.815  58.630  12.592  1.00 10.21           C  
ATOM   2074  C   GLU A 314      35.997  57.947  13.276  1.00 10.72           C  
ATOM   2075  O   GLU A 314      37.165  58.194  12.933  1.00 11.18           O  
ATOM   2076  CB  GLU A 314      34.578  57.968  11.216  1.00 12.44           C  
ATOM   2077  CG  GLU A 314      34.310  56.475  11.237  1.00 24.28           C  
ATOM   2078  CD  GLU A 314      34.031  55.911   9.844  1.00 24.56           C  
ATOM   2079  OE1 GLU A 314      34.034  56.688   8.870  1.00 29.23           O  
ATOM   2080  OE2 GLU A 314      33.831  54.684   9.727  1.00 30.77           O  
ATOM   2081  N   VAL A 315      35.667  57.040  14.200  1.00 10.60           N  
ATOM   2082  CA  VAL A 315      36.659  56.194  14.884  1.00  9.45           C  
ATOM   2083  C   VAL A 315      36.521  54.744  14.437  1.00 10.87           C  
ATOM   2084  O   VAL A 315      35.511  54.357  13.835  1.00 12.49           O  
ATOM   2085  CB  VAL A 315      36.518  56.279  16.430  1.00  9.23           C  
ATOM   2086  CG1 VAL A 315      36.759  57.731  16.865  1.00 11.29           C  
ATOM   2087  CG2 VAL A 315      35.150  55.818  16.864  1.00 14.97           C  
ATOM   2088  N   LYS A 316      37.538  53.946  14.724  1.00 11.12           N  
ATOM   2089  CA  LYS A 316      37.466  52.529  14.389  1.00 12.16           C  
ATOM   2090  C   LYS A 316      38.275  51.701  15.365  1.00 11.90           C  
ATOM   2091  O   LYS A 316      39.254  52.178  15.948  1.00 11.75           O  
ATOM   2092  CB  LYS A 316      37.998  52.304  12.988  1.00 15.74           C  
ATOM   2093  CG  LYS A 316      39.452  52.586  12.875  1.00 21.33           C  
ATOM   2094  CD  LYS A 316      39.958  52.504  11.434  1.00 28.07           C  
ATOM   2095  CE  LYS A 316      41.455  52.825  11.423  1.00 30.03           C  
ATOM   2096  NZ  LYS A 316      41.874  53.572  10.193  1.00 34.33           N  
ATOM   2097  N   LEU A 317      37.865  50.449  15.528  1.00 11.60           N  
ATOM   2098  CA  LEU A 317      38.551  49.526  16.425  1.00 11.62           C  
ATOM   2099  C   LEU A 317      39.874  49.067  15.825  1.00 10.90           C  
ATOM   2100  O   LEU A 317      39.930  48.705  14.632  1.00 13.19           O  
ATOM   2101  CB  LEU A 317      37.646  48.311  16.633  1.00 13.65           C  
ATOM   2102  CG  LEU A 317      38.279  47.149  17.379  1.00 15.79           C  
ATOM   2103  CD1 LEU A 317      38.411  47.562  18.833  1.00 15.43           C  
ATOM   2104  CD2 LEU A 317      37.361  45.939  17.249  1.00 17.78           C  
ATOM   2105  N   ILE A 318      40.934  49.087  16.639  1.00  9.47           N  
ATOM   2106  CA  ILE A 318      42.239  48.550  16.228  1.00 10.94           C  
ATOM   2107  C   ILE A 318      42.527  47.354  17.135  1.00 11.62           C  
ATOM   2108  O   ILE A 318      42.797  47.521  18.334  1.00 10.93           O  
ATOM   2109  CB  ILE A 318      43.368  49.588  16.407  1.00 12.64           C  
ATOM   2110  CG1 ILE A 318      43.028  50.900  15.699  1.00 16.64           C  
ATOM   2111  CG2 ILE A 318      44.731  48.999  15.954  1.00 18.42           C  
ATOM   2112  CD1 ILE A 318      42.906  50.790  14.211  1.00 19.68           C  
ATOM   2113  N   GLU A 319      42.407  46.139  16.604  1.00 12.38           N  
ATOM   2114  CA  GLU A 319      42.574  44.947  17.438  1.00 13.07           C  
ATOM   2115  C   GLU A 319      44.043  44.582  17.514  1.00 13.24           C  
ATOM   2116  O   GLU A 319      44.680  44.417  16.480  1.00 14.05           O  
ATOM   2117  CB  GLU A 319      41.806  43.749  16.834  1.00 15.26           C  
ATOM   2118  CG  GLU A 319      40.311  43.813  16.980  1.00 22.91           C  
ATOM   2119  CD  GLU A 319      39.657  42.477  16.604  1.00 28.40           C  
ATOM   2120  OE1 GLU A 319      39.908  41.450  17.296  1.00 26.53           O  
ATOM   2121  OE2 GLU A 319      38.897  42.468  15.615  1.00 32.13           O  
ATOM   2122  N   ARG A 320      44.575  44.472  18.734  1.00 10.70           N  
ATOM   2123  CA  ARG A 320      45.947  44.058  18.935  1.00 11.15           C  
ATOM   2124  C   ARG A 320      45.996  42.906  19.937  1.00 12.62           C  
ATOM   2125  O   ARG A 320      45.155  42.007  19.867  1.00 14.73           O  
ATOM   2126  CB  ARG A 320      46.812  45.228  19.370  1.00 11.27           C  
ATOM   2127  CG  ARG A 320      46.802  46.383  18.371  1.00 11.73           C  
ATOM   2128  CD  ARG A 320      47.963  47.305  18.655  1.00 13.00           C  
ATOM   2129  NE  ARG A 320      48.094  48.387  17.682  1.00 13.76           N  
ATOM   2130  CZ  ARG A 320      47.912  49.673  17.977  1.00 13.15           C  
ATOM   2131  NH1 ARG A 320      47.536  50.047  19.209  1.00 11.90           N  
ATOM   2132  NH2 ARG A 320      48.110  50.585  17.039  1.00 14.34           N  
ATOM   2133  N   GLU A 321      46.986  42.896  20.825  1.00 11.04           N  
ATOM   2134  CA  GLU A 321      47.270  41.679  21.595  1.00 12.07           C  
ATOM   2135  C   GLU A 321      46.655  41.635  22.989  1.00 12.26           C  
ATOM   2136  O   GLU A 321      46.682  40.582  23.644  1.00 12.83           O  
ATOM   2137  CB  GLU A 321      48.792  41.461  21.705  1.00 14.68           C  
ATOM   2138  CG  GLU A 321      49.508  41.152  20.382  1.00 23.43           C  
ATOM   2139  CD  GLU A 321      51.036  41.257  20.499  1.00 29.76           C  
ATOM   2140  OE1 GLU A 321      51.543  42.014  21.358  1.00 25.69           O  
ATOM   2141  OE2 GLU A 321      51.742  40.582  19.719  1.00 30.49           O  
ATOM   2142  N   THR A 322      46.091  42.756  23.462  1.00  9.92           N  
ATOM   2143  CA  THR A 322      45.493  42.744  24.802  1.00  8.23           C  
ATOM   2144  C   THR A 322      44.029  42.286  24.846  1.00  9.72           C  
ATOM   2145  O   THR A 322      43.403  42.280  25.918  1.00 10.03           O  
ATOM   2146  CB  THR A 322      45.598  44.125  25.468  1.00  9.03           C  
ATOM   2147  OG1 THR A 322      44.959  45.069  24.622  1.00 10.38           O  
ATOM   2148  CG2 THR A 322      47.072  44.527  25.622  1.00 10.27           C  
ATOM   2149  N   THR A 323      43.470  41.925  23.688  1.00  9.86           N  
ATOM   2150  CA  THR A 323      42.187  41.213  23.667  1.00 11.42           C  
ATOM   2151  C   THR A 323      42.403  39.951  22.850  1.00 14.79           C  
ATOM   2152  O   THR A 323      43.313  39.891  22.017  1.00 14.37           O  
ATOM   2153  CB  THR A 323      41.050  42.059  23.063  1.00 12.48           C  
ATOM   2154  OG1 THR A 323      41.448  42.549  21.770  1.00 12.84           O  
ATOM   2155  CG2 THR A 323      40.770  43.240  23.963  1.00 13.47           C  
ATOM   2156  N   ILE A 324      41.585  38.939  23.119  1.00 17.15           N  
ATOM   2157  CA  ILE A 324      41.809  37.615  22.534  1.00 21.57           C  
ATOM   2158  C   ILE A 324      41.237  37.529  21.131  1.00 27.05           C  
ATOM   2159  O   ILE A 324      40.268  38.205  20.813  1.00 28.26           O  
ATOM   2160  CB  ILE A 324      41.148  36.554  23.394  1.00 21.56           C  
ATOM   2161  CG1 ILE A 324      39.656  36.866  23.528  1.00 22.89           C  
ATOM   2162  CG2 ILE A 324      41.841  36.471  24.767  1.00 22.21           C  
ATOM   2163  CD1 ILE A 324      38.879  35.910  24.456  1.00 28.78           C  
ATOM   2164  N   SER A 325      41.840  36.681  20.298  1.00 30.74           N  
ATOM   2165  CA  SER A 325      41.371  36.465  18.935  1.00 33.55           C  
ATOM   2166  C   SER A 325      41.617  35.020  18.523  1.00 34.86           C  
ATOM   2167  O   SER A 325      42.454  34.347  19.122  1.00 36.01           O  
ATOM   2168  CB  SER A 325      42.084  37.408  17.969  1.00 34.79           C  
ATOM   2169  OG  SER A 325      41.638  38.744  18.138  1.00 61.95           O  
TER    2170      SER A 325                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
