
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  275 ( 2135),  selected  275 , name 2o20_B
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 2o20_B.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    58_B      -       -           -
LGA    A    59_B      -       -           -
LGA    S    60_B      -       -           -
LGA    K    61_B      -       -           -
LGA    R    62_B      -       -           -
LGA    T    63_B      -       -           -
LGA    T    64_B      Y      71          3.386
LGA    T    65_B      S      72          1.955
LGA    V    66_B      I      73          2.147
LGA    G    67_B      A      74          1.950
LGA    V    68_B      L      75          2.282
LGA    I    69_B      I      76          2.227
LGA    L    70_B      I      77          2.179
LGA    P    71_B      P      78          3.348
LGA    T    72_B      S      79          3.518
LGA    I    73_B      L      80          3.273
LGA    T    74_B      F      81          4.379
LGA    S    75_B      E      82          3.712
LGA    T    76_B      K      83          3.933
LGA    Y    77_B      A      84          3.841
LGA    F    78_B      C      85          1.905
LGA    A    79_B      A      86          1.300
LGA    A    80_B      H      87          0.741
LGA    I    81_B      F      88          1.176
LGA    T    82_B      L      89          1.226
LGA    R    83_B      P      90          2.064
LGA    G    84_B      S      91          2.551
LGA    V    85_B      F      92          1.088
LGA    D    86_B      Q      93          1.230
LGA    D    87_B      Q      94          1.928
LGA    I    88_B      A      95          1.379
LGA    A    89_B      L      96          0.419
LGA    S    90_B      N      97          1.034
LGA    M    91_B      K      98          1.141
LGA    Y    92_B      A      99          0.809
LGA    K    93_B      G     100          1.566
LGA    Y    94_B      Y     101          0.563
LGA    N    95_B      Q     102          0.423
LGA    M    96_B      L     103          1.141
LGA    I    97_B      L     104          2.510
LGA    L    98_B      L     105          3.248
LGA    A    99_B      G     106          2.523
LGA    N   100_B      Y     107          2.719
LGA    S   101_B      S     108          2.337
LGA    D   102_B      D     109          3.027
LGA    N   103_B      Y     110          1.983
LGA    D   104_B      -       -           -
LGA    V   105_B      S     111          1.353
LGA    E   106_B      I     112           #
LGA    K   107_B      -       -           -
LGA    E   108_B      E     113           #
LGA    E   109_B      Q     114          1.977
LGA    K   110_B      E     115           #
LGA    -       -      E     116           -
LGA    -       -      K     117           -
LGA    V   111_B      L     118          2.908
LGA    L   112_B      L     119          1.937
LGA    E   113_B      S     120          3.084
LGA    T   114_B      T     121          3.417
LGA    F   115_B      F     122          2.253
LGA    L   116_B      L     123          2.462
LGA    S   117_B      E     124          3.265
LGA    K   118_B      S     125          3.068
LGA    Q   119_B      R     126          3.007
LGA    V   120_B      P     127          5.240
LGA    D   121_B      A     128          2.405
LGA    G   122_B      G     129          2.261
LGA    I   123_B      V     130          2.339
LGA    V   124_B      V     131          2.421
LGA    Y   125_B      L     132          2.321
LGA    M   126_B      F     133          3.128
LGA    G   127_B      -       -           -
LGA    S   128_B      -       -           -
LGA    S   129_B      G     134          3.628
LGA    L   130_B      S     135          3.907
LGA    D   131_B      E     136          3.408
LGA    E   132_B      H     137          3.653
LGA    K   133_B      S     138          2.352
LGA    I   134_B      -       -           -
LGA    R   135_B      -       -           -
LGA    T   136_B      Q     139          2.518
LGA    S   137_B      R     140          3.127
LGA    L   138_B      T     141          2.771
LGA    K   139_B      H     142          1.842
LGA    N   140_B      Q     143          1.459
LGA    S   141_B      L     144          1.694
LGA    R   142_B      L     145          2.095
LGA    -       -      E     146           -
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    -       -      N     149           -
LGA    T   143_B      T     150          4.171
LGA    P   144_B      P     151          2.324
LGA    V   145_B      V     152          2.151
LGA    V   146_B      L     153          1.390
LGA    L   147_B      E     154          2.095
LGA    V   148_B      I     155          2.073
LGA    G   149_B      -       -           -
LGA    T   150_B      A     156          2.940
LGA    I   151_B      E     157          2.904
LGA    D   152_B      L     158          3.869
LGA    G   153_B      -       -           -
LGA    D   154_B      -       -           -
LGA    K   155_B      S     159          3.246
LGA    E   156_B      S     160          4.086
LGA    I   157_B      K     161          5.271
LGA    -       -      A     162           -
LGA    -       -      S     163           -
LGA    -       -      Y     164           -
LGA    P   158_B      L     165          2.890
LGA    S   159_B      N     166          2.470
LGA    V   160_B      I     167          1.457
LGA    N   161_B      G     168          1.892
LGA    I   162_B      V     169          2.260
LGA    D   163_B      D     170          2.703
LGA    Y   164_B      H     171          1.950
LGA    H   165_B      F     172          2.271
LGA    L   166_B      E     173          1.986
LGA    A   167_B      V     174          1.703
LGA    A   168_B      G     175          1.372
LGA    Y   169_B      K     176          1.459
LGA    Q   170_B      A     177          1.460
LGA    S   171_B      C     178          0.767
LGA    T   172_B      T     179          0.802
LGA    K   173_B      R     180          1.110
LGA    K   174_B      H     181          1.187
LGA    L   175_B      L     182          1.018
LGA    I   176_B      I     183          1.273
LGA    D   177_B      E     184          2.475
LGA    S   178_B      Q     185          2.892
LGA    G   179_B      G     186          2.563
LGA    N   180_B      F     187          2.292
LGA    K   181_B      K     188          2.797
LGA    K   182_B      N     189          2.230
LGA    I   183_B      V     190          1.041
LGA    A   184_B      G     191          1.760
LGA    Y   185_B      F     192          2.391
LGA    I   186_B      I     193          2.628
LGA    M   187_B      G     194          3.104
LGA    G   188_B      A     195          3.930
LGA    S   189_B      R     196           #
LGA    L   190_B      G     197          5.405
LGA    K   191_B      N     198           #
LGA    D   192_B      H     199          5.217
LGA    V   193_B      S     200          4.945
LGA    E   194_B      T     201          3.868
LGA    N   195_B      L     202          3.924
LGA    T   196_B      Q     203          4.220
LGA    E   197_B      R     204          3.439
LGA    R   198_B      Q     205          2.625
LGA    M   199_B      L     206          3.662
LGA    V   200_B      H     207          3.892
LGA    G   201_B      G     208          2.883
LGA    Y   202_B      W     209          1.984
LGA    Q   203_B      Q     210          2.733
LGA    E   204_B      S     211          2.894
LGA    A   205_B      A     212          1.811
LGA    L   206_B      M     213          1.506
LGA    L   207_B      I     214          2.757
LGA    E   208_B      E     215          3.241
LGA    A   209_B      N     216          2.232
LGA    N   210_B      Y     217          1.970
LGA    I   211_B      L     218          0.982
LGA    E   212_B      T     219          2.013
LGA    F   213_B      P     220          2.637
LGA    D   214_B      D     221          1.880
LGA    E   215_B      -       -           -
LGA    N   216_B      -       -           -
LGA    L   217_B      H     222          1.485
LGA    V   218_B      F     223          2.350
LGA    F   219_B      L     224          2.042
LGA    E   220_B      T     225          2.262
LGA    G   221_B      T     226          2.778
LGA    -       -      H     227           -
LGA    N   222_B      E     228          5.071
LGA    Y   223_B      A     229          2.923
LGA    S   224_B      P     230          1.852
LGA    Y   225_B      S     231          1.624
LGA    -       -      S     232           -
LGA    E   226_B      Q     233          3.747
LGA    Q   227_B      L     234          2.931
LGA    G   228_B      G     235          3.010
LGA    K   229_B      A     236          3.523
LGA    A   230_B      E     237          3.186
LGA    L   231_B      G     238          1.693
LGA    A   232_B      L     239          2.346
LGA    E   233_B      A     240          0.968
LGA    R   234_B      K     241          1.443
LGA    L   235_B      L     242          2.023
LGA    L   236_B      L     243          1.719
LGA    E   237_B      L     244          1.358
LGA    R   238_B      R     245          2.166
LGA    G   239_B      D     246          2.851
LGA    -       -      S     247           -
LGA    -       -      S     248           -
LGA    A   240_B      L     249          2.856
LGA    T   241_B      N     250          2.000
LGA    S   242_B      A     251          1.514
LGA    A   243_B      L     252          1.630
LGA    V   244_B      V     253          1.538
LGA    V   245_B      C     254          1.934
LGA    S   246_B      S     255          2.301
LGA    H   247_B      H     256          2.249
LGA    D   248_B      E     257          2.274
LGA    T   249_B      E     258          2.748
LGA    V   250_B      I     259          2.581
LGA    A   251_B      A     260          2.368
LGA    V   252_B      I     261          2.539
LGA    G   253_B      G     262          2.867
LGA    L   254_B      A     263          2.671
LGA    L   255_B      L     264          2.505
LGA    S   256_B      F     265          3.125
LGA    A   257_B      E     266          3.110
LGA    M   258_B      C     267          2.928
LGA    M   259_B      H     268          2.912
LGA    D   260_B      R     269          3.750
LGA    K   261_B      R     270          3.688
LGA    G   262_B      V     271          3.150
LGA    V   263_B      L     272          2.711
LGA    K   264_B      K     273          1.841
LGA    V   265_B      V     274          1.663
LGA    P   266_B      P     275          1.719
LGA    E   267_B      T     276          1.924
LGA    D   268_B      D     277          1.313
LGA    F   269_B      I     278          1.511
LGA    E   270_B      A     279          1.768
LGA    I   271_B      I     280          1.622
LGA    I   272_B      I     281          1.174
LGA    S   273_B      C     282          1.195
LGA    G   274_B      L     283          1.686
LGA    A   275_B      E     284          2.307
LGA    N   276_B      G     285          2.483
LGA    S   277_B      S     286          3.246
LGA    P   278_B      -       -           -
LGA    I   279_B      -       -           -
LGA    T   280_B      S     287          3.641
LGA    Q   281_B      M     288          3.044
LGA    Y   282_B      G     289           #
LGA    T   283_B      E     290           #
LGA    -       -      H     291           -
LGA    Y   284_B      A     292          1.853
LGA    P   285_B      Y     293          1.366
LGA    -       -      P     294           -
LGA    T   286_B      S     295          1.729
LGA    L   287_B      L     296          2.211
LGA    T   288_B      T     297          1.437
LGA    S   289_B      S     298          0.819
LGA    V   290_B      A     299          0.721
LGA    N   291_B      E     300          1.303
LGA    Q   292_B      F     301          1.177
LGA    P   293_B      D     302          1.735
LGA    L   294_B      Y     303          1.341
LGA    Y   295_B      E     304          1.073
LGA    D   296_B      R     305          1.534
LGA    L   297_B      M     306          1.705
LGA    G   298_B      G     307          1.823
LGA    A   299_B      T     308          1.582
LGA    V   300_B      K     309          1.407
LGA    A   301_B      A     310          1.390
LGA    M   302_B      A     311          1.488
LGA    R   303_B      E     312          1.295
LGA    L   304_B      K     313          1.387
LGA    L   305_B      L     314          1.715
LGA    T   306_B      L     315          1.693
LGA    K   307_B      H     316          2.799
LGA    L   308_B      A     317          3.013
LGA    M   309_B      -       -           -
LGA    L   310_B      I     318          1.176
LGA    K   311_B      K     319           #
LGA    E   312_B      E     321          2.928
LGA    D   313_B      P     322          4.299
LGA    V   314_B      E     323          1.562
LGA    E   315_B      E     324          4.219
LGA    Q   316_B      P     326          3.789
LGA    N   317_B      -       -           -
LGA    Q   318_B      -       -           -
LGA    L   319_B      T     327          2.532
LGA    V   320_B      S     328          2.401
LGA    L   321_B      M     329          0.390
LGA    D   322_B      G     330          2.477
LGA    H   323_B      F     331          1.372
LGA    E   324_B      K     332          1.394
LGA    I   325_B      L     333          0.356
LGA    F   326_B      K     334          0.147
LGA    S   327_B      R     335          1.200
LGA    R   328_B      R     336          1.617
LGA    R   329_B      A     337          2.177
LGA    S   330_B      S     338          2.070
LGA    T   331_B      T     339          1.854
LGA    K   332_B      A     340          2.201
LGA    -       -      I     341           -
LGA    -       -      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  275  270    5.0    245    2.51    22.86     61.748     9.371

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.259924 * X  +   0.895007 * Y  +   0.362493 * Z  +  32.222057
  Y_new =   0.830670 * X  +   0.015831 * Y  +   0.556541 * Z  +  34.118885
  Z_new =   0.492369 * X  +   0.445771 * Y  +  -0.747570 * Z  +  74.498703 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.603904   -0.537689  [ DEG:   149.1927    -30.8073 ]
  Theta =  -0.514810   -2.626783  [ DEG:   -29.4964   -150.5036 ]
  Phi   =   1.874054   -1.267539  [ DEG:   107.3754    -72.6246 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o20_B                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o20_B.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  275  270   5.0  245   2.51   22.86  61.748
REMARK  ---------------------------------------------------------- 
MOLECULE 2o20_B
HEADER    TRANSCRIPTION                           29-NOV-06   2O20              
TITLE     CRYSTAL STRUCTURE OF TRANSCRIPTION REGULATOR CCPA OF                  
TITLE    2 LACTOCOCCUS LACTIS                                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CATABOLITE CONTROL PROTEIN A;                              
COMPND   3 CHAIN: A, C, D, B, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LACTOCOCCUS LACTIS;                             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: SSP.LACTIS IL1403;                                           
SOURCE   5 GENE: CCPA;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: XL1BLUE;                                   
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PQE30                                     
KEYWDS    CCPA, TRANSCRIPTIONAL REGULATOR, HELIX-TURN-HELIX                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.LOLL,M.KOWALCZYK,C.ALINGS,A.CHIEDUCH,J.BARDOWSKI,                   
AUTHOR   2 W.SAENGER,J.BIESIADKA                                                
REVDAT   1   27-MAR-07 2O20    0                                                
JRNL        AUTH   B.LOLL,M.KOWALCZYK,C.ALINGS,A.CHIEDUCH,J.BARDOWSKI,          
JRNL        AUTH 2 W.SAENGER,J.BIESIADKA                                        
JRNL        TITL   STRUCTURE OF THE TRANSCRIPTION REGULATOR CCPA FROM           
JRNL        TITL 2 LACTOCOCCUS LACTIS                                           
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  63   431 2007              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2O20 A    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 C    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 D    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 B    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 E    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 F    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 G    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
DBREF  2O20 H    1   332  UNP    Q9CF33   Q9CF33_LACLA     1    332             
SEQRES   1 A  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 A  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 A  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 A  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 A  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 A  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 A  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 A  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 A  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 A  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 A  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 A  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 A  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 A  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 A  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 A  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 A  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 A  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 A  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 A  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 A  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 A  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 A  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 A  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 A  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 A  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 C  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 C  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 C  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 C  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 C  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 C  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 C  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 C  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 C  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 C  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 C  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 C  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 C  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 C  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 C  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 C  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 C  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 C  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 C  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 C  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 C  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 C  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 C  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 C  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 C  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 C  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 D  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 D  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 D  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 D  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 D  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 D  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 D  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 D  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 D  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 D  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 D  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 D  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 D  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 D  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 D  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 D  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 D  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 D  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 D  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 D  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 D  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 D  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 D  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 D  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 D  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 D  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 B  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 B  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 B  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 B  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 B  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 B  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 B  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 B  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 B  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 B  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 B  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 B  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 B  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 B  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 B  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 B  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 B  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 B  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 B  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 B  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 B  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 B  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 B  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 B  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 B  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 B  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 E  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 E  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 E  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 E  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 E  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 E  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 E  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 E  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 E  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 E  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 E  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 E  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 E  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 E  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 E  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 E  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 E  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 E  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 E  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 E  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 E  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 E  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 E  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 E  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 E  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 E  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 F  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 F  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 F  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 F  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 F  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 F  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 F  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 F  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 F  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 F  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 F  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 F  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 F  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 F  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 F  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 F  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 F  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 F  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 F  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 F  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 F  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 F  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 F  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 F  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 F  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 F  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 G  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 G  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 G  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 G  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 G  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 G  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 G  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 G  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 G  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 G  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 G  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 G  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 G  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 G  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 G  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 G  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 G  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 G  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 G  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 G  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 G  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 G  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 G  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 G  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 G  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 G  332  PHE SER ARG ARG SER THR LYS                                  
SEQRES   1 H  332  MET VAL GLU SER THR THR THR ILE TYR ASP VAL ALA ARG          
SEQRES   2 H  332  VAL ALA GLY VAL SER MET ALA THR VAL SER ARG VAL VAL          
SEQRES   3 H  332  ASN GLY ASN ALA ASN VAL LYS GLU LYS THR ARG GLN LYS          
SEQRES   4 H  332  VAL LEU GLU ALA ILE ALA GLU LEU ASP TYR ARG PRO ASN          
SEQRES   5 H  332  ALA VAL ALA ARG GLY LEU ALA SER LYS ARG THR THR THR          
SEQRES   6 H  332  VAL GLY VAL ILE LEU PRO THR ILE THR SER THR TYR PHE          
SEQRES   7 H  332  ALA ALA ILE THR ARG GLY VAL ASP ASP ILE ALA SER MET          
SEQRES   8 H  332  TYR LYS TYR ASN MET ILE LEU ALA ASN SER ASP ASN ASP          
SEQRES   9 H  332  VAL GLU LYS GLU GLU LYS VAL LEU GLU THR PHE LEU SER          
SEQRES  10 H  332  LYS GLN VAL ASP GLY ILE VAL TYR MET GLY SER SER LEU          
SEQRES  11 H  332  ASP GLU LYS ILE ARG THR SER LEU LYS ASN SER ARG THR          
SEQRES  12 H  332  PRO VAL VAL LEU VAL GLY THR ILE ASP GLY ASP LYS GLU          
SEQRES  13 H  332  ILE PRO SER VAL ASN ILE ASP TYR HIS LEU ALA ALA TYR          
SEQRES  14 H  332  GLN SER THR LYS LYS LEU ILE ASP SER GLY ASN LYS LYS          
SEQRES  15 H  332  ILE ALA TYR ILE MET GLY SER LEU LYS ASP VAL GLU ASN          
SEQRES  16 H  332  THR GLU ARG MET VAL GLY TYR GLN GLU ALA LEU LEU GLU          
SEQRES  17 H  332  ALA ASN ILE GLU PHE ASP GLU ASN LEU VAL PHE GLU GLY          
SEQRES  18 H  332  ASN TYR SER TYR GLU GLN GLY LYS ALA LEU ALA GLU ARG          
SEQRES  19 H  332  LEU LEU GLU ARG GLY ALA THR SER ALA VAL VAL SER HIS          
SEQRES  20 H  332  ASP THR VAL ALA VAL GLY LEU LEU SER ALA MET MET ASP          
SEQRES  21 H  332  LYS GLY VAL LYS VAL PRO GLU ASP PHE GLU ILE ILE SER          
SEQRES  22 H  332  GLY ALA ASN SER PRO ILE THR GLN TYR THR TYR PRO THR          
SEQRES  23 H  332  LEU THR SER VAL ASN GLN PRO LEU TYR ASP LEU GLY ALA          
SEQRES  24 H  332  VAL ALA MET ARG LEU LEU THR LYS LEU MET LEU LYS GLU          
SEQRES  25 H  332  ASP VAL GLU GLN ASN GLN LEU VAL LEU ASP HIS GLU ILE          
SEQRES  26 H  332  PHE SER ARG ARG SER THR LYS                                  
HET    SO4   2001       5                                                       
HET    SO4   2002       5                                                       
HET    SO4   2003       5                                                       
HET    SO4   2004       5                                                       
HET    SO4   2005       5                                                       
HET    SO4   2006       5                                                       
HET    SO4   2007       5                                                       
HET    SO4   2008       5                                                       
HET     CL   2010       1                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      CL CHLORIDE ION                                                     
FORMUL   9  SO4    8(O4 S 2-)                                                   
FORMUL  17   CL    CL 1-                                                        
FORMUL  18  HOH   *1335(H2 O)                                                   
CRYST1  117.756   74.267  160.302  90.00 102.36  90.00 P 1 21 1     16          
ATOM   6365  N   LEU B  58      52.630 101.957   3.620  1.00 52.08           N  
ATOM   6366  CA  LEU B  58      51.507 100.968   3.519  1.00 51.98           C  
ATOM   6367  C   LEU B  58      52.015  99.526   3.599  1.00 51.79           C  
ATOM   6368  O   LEU B  58      51.992  98.794   2.604  1.00 51.88           O  
ATOM   6369  CB  LEU B  58      50.721 101.185   2.220  1.00 52.07           C  
ATOM   6370  N   ALA B  59      52.460  99.124   4.789  1.00 51.51           N  
ATOM   6371  CA  ALA B  59      53.061  97.797   4.992  1.00 51.15           C  
ATOM   6372  C   ALA B  59      52.015  96.690   5.121  1.00 50.80           C  
ATOM   6373  O   ALA B  59      50.874  96.940   5.511  1.00 50.59           O  
ATOM   6374  CB  ALA B  59      53.956  97.808   6.218  1.00 51.34           C  
ATOM   6375  N   SER B  60      52.423  95.460   4.800  1.00 50.37           N  
ATOM   6376  CA  SER B  60      51.530  94.298   4.886  1.00 49.85           C  
ATOM   6377  C   SER B  60      51.117  94.089   6.338  1.00 49.07           C  
ATOM   6378  O   SER B  60      51.856  94.468   7.250  1.00 49.24           O  
ATOM   6379  CB  SER B  60      52.212  93.027   4.351  1.00 49.86           C  
ATOM   6380  OG  SER B  60      52.971  92.369   5.364  1.00 50.28           O  
ATOM   6381  N   LYS B  61      49.941  93.503   6.561  1.00 47.86           N  
ATOM   6382  CA  LYS B  61      49.568  93.135   7.913  1.00 46.71           C  
ATOM   6383  C   LYS B  61      50.562  92.100   8.456  1.00 45.53           C  
ATOM   6384  O   LYS B  61      51.166  91.329   7.702  1.00 45.37           O  
ATOM   6385  CB  LYS B  61      48.131  92.600   8.006  1.00 46.73           C  
ATOM   6386  CG  LYS B  61      47.679  92.413   9.460  1.00 46.89           C  
ATOM   6387  CD  LYS B  61      46.215  92.073   9.590  1.00 47.58           C  
ATOM   6388  CE  LYS B  61      45.864  91.723  11.030  1.00 47.18           C  
ATOM   6389  NZ  LYS B  61      44.486  91.160  11.154  1.00 47.80           N  
ATOM   6390  N   ARG B  62      50.751  92.136   9.768  1.00 43.76           N  
ATOM   6391  CA  ARG B  62      51.520  91.135  10.483  1.00 42.58           C  
ATOM   6392  C   ARG B  62      51.217  89.720   9.940  1.00 40.46           C  
ATOM   6393  O   ARG B  62      50.056  89.389   9.637  1.00 41.13           O  
ATOM   6394  CB  ARG B  62      51.135  91.214  11.964  1.00 43.02           C  
ATOM   6395  CG  ARG B  62      51.913  90.303  12.905  1.00 45.67           C  
ATOM   6396  CD  ARG B  62      53.358  90.716  12.976  1.00 49.24           C  
ATOM   6397  NE  ARG B  62      53.512  92.152  13.243  1.00 51.07           N  
ATOM   6398  CZ  ARG B  62      54.675  92.793  13.201  1.00 51.54           C  
ATOM   6399  NH1 ARG B  62      55.796  92.132  12.910  1.00 52.48           N  
ATOM   6400  NH2 ARG B  62      54.720  94.097  13.458  1.00 51.35           N  
ATOM   6401  N   THR B  63      52.243  88.880   9.824  1.00 36.94           N  
ATOM   6402  CA  THR B  63      52.011  87.478   9.481  1.00 34.02           C  
ATOM   6403  C   THR B  63      51.029  86.873  10.461  1.00 31.11           C  
ATOM   6404  O   THR B  63      51.155  87.068  11.668  1.00 30.42           O  
ATOM   6405  CB  THR B  63      53.296  86.646   9.548  1.00 34.27           C  
ATOM   6406  OG1 THR B  63      54.263  87.226   8.672  1.00 35.52           O  
ATOM   6407  CG2 THR B  63      53.027  85.195   9.114  1.00 33.41           C  
ATOM   6408  N   THR B  64      50.053  86.145   9.939  1.00 27.98           N  
ATOM   6409  CA  THR B  64      49.080  85.453  10.787  1.00 26.51           C  
ATOM   6410  C   THR B  64      49.774  84.525  11.793  1.00 24.76           C  
ATOM   6411  O   THR B  64      50.744  83.809  11.449  1.00 23.70           O  
ATOM   6412  CB  THR B  64      48.089  84.680   9.902  1.00 26.45           C  
ATOM   6413  OG1 THR B  64      47.298  85.629   9.172  1.00 26.54           O  
ATOM   6414  CG2 THR B  64      47.212  83.752  10.697  1.00 26.06           C  
ATOM   6415  N   THR B  65      49.278  84.564  13.029  1.00 23.46           N  
ATOM   6416  CA  THR B  65      49.924  83.878  14.152  1.00 22.76           C  
ATOM   6417  C   THR B  65      48.857  83.072  14.859  1.00 22.40           C  
ATOM   6418  O   THR B  65      47.836  83.619  15.271  1.00 21.93           O  
ATOM   6419  CB  THR B  65      50.606  84.857  15.134  1.00 23.21           C  
ATOM   6420  OG1 THR B  65      51.646  85.583  14.457  1.00 22.77           O  
ATOM   6421  CG2 THR B  65      51.202  84.122  16.330  1.00 22.68           C  
ATOM   6422  N   VAL B  66      49.135  81.770  14.978  1.00 21.64           N  
ATOM   6423  CA  VAL B  66      48.304  80.805  15.660  1.00 21.31           C  
ATOM   6424  C   VAL B  66      48.892  80.381  17.020  1.00 21.83           C  
ATOM   6425  O   VAL B  66      50.055  79.932  17.104  1.00 21.65           O  
ATOM   6426  CB  VAL B  66      47.981  79.587  14.765  0.50 21.77           C  
ATOM   6428  CG1 VAL B  66      46.998  80.004  13.669  0.50 21.75           C  
ATOM   6430  CG2 VAL B  66      49.220  79.025  14.124  0.50 23.13           C  
ATOM   6432  N   GLY B  67      48.077  80.573  18.056  1.00 22.34           N  
ATOM   6433  CA  GLY B  67      48.358  80.100  19.425  1.00 22.67           C  
ATOM   6434  C   GLY B  67      47.818  78.689  19.627  1.00 22.89           C  
ATOM   6435  O   GLY B  67      46.642  78.425  19.384  1.00 23.11           O  
ATOM   6436  N   VAL B  68      48.668  77.786  20.118  1.00 22.48           N  
ATOM   6437  CA  VAL B  68      48.254  76.389  20.399  1.00 22.80           C  
ATOM   6438  C   VAL B  68      48.557  76.048  21.847  1.00 22.05           C  
ATOM   6439  O   VAL B  68      49.709  76.082  22.280  1.00 22.37           O  
ATOM   6440  CB  VAL B  68      48.988  75.368  19.473  1.00 23.57           C  
ATOM   6441  CG1 VAL B  68      48.456  73.957  19.676  1.00 23.73           C  
ATOM   6442  CG2 VAL B  68      48.884  75.786  17.997  1.00 24.29           C  
ATOM   6443  N   ILE B  69      47.513  75.678  22.574  1.00 22.00           N  
ATOM   6444  CA  ILE B  69      47.596  75.324  23.984  1.00 23.43           C  
ATOM   6445  C   ILE B  69      47.357  73.839  24.093  1.00 23.20           C  
ATOM   6446  O   ILE B  69      46.374  73.338  23.554  1.00 23.21           O  
ATOM   6447  CB  ILE B  69      46.526  76.032  24.823  1.00 23.80           C  
ATOM   6448  CG1 ILE B  69      46.587  77.523  24.544  1.00 27.07           C  
ATOM   6449  CG2 ILE B  69      46.749  75.702  26.333  1.00 25.30           C  
ATOM   6450  CD1 ILE B  69      45.542  78.335  25.190  1.00 28.27           C  
ATOM   6451  N   LEU B  70      48.270  73.150  24.778  1.00 22.77           N  
ATOM   6452  CA  LEU B  70      48.132  71.706  25.033  1.00 22.98           C  
ATOM   6453  C   LEU B  70      48.669  71.426  26.424  1.00 22.21           C  
ATOM   6454  O   LEU B  70      49.478  72.207  26.920  1.00 20.76           O  
ATOM   6455  CB  LEU B  70      48.895  70.867  23.981  1.00 22.65           C  
ATOM   6456  CG  LEU B  70      50.420  71.026  23.864  1.00 23.94           C  
ATOM   6457  CD1 LEU B  70      51.055  69.805  23.106  1.00 25.06           C  
ATOM   6458  CD2 LEU B  70      50.846  72.310  23.162  1.00 26.27           C  
ATOM   6459  N   PRO B  71      48.167  70.368  27.089  1.00 21.54           N  
ATOM   6460  CA  PRO B  71      48.673  70.069  28.443  1.00 21.92           C  
ATOM   6461  C   PRO B  71      50.202  69.914  28.483  1.00 21.76           C  
ATOM   6462  O   PRO B  71      50.885  70.568  29.273  1.00 22.35           O  
ATOM   6463  CB  PRO B  71      47.970  68.755  28.756  1.00 22.12           C  
ATOM   6464  CG  PRO B  71      46.687  68.900  28.071  1.00 21.62           C  
ATOM   6465  CD  PRO B  71      47.038  69.488  26.760  1.00 22.09           C  
ATOM   6466  N   THR B  72      50.738  69.061  27.618  1.00 20.97           N  
ATOM   6467  CA  THR B  72      52.195  68.893  27.554  1.00 20.55           C  
ATOM   6468  C   THR B  72      52.641  68.265  26.240  1.00 19.92           C  
ATOM   6469  O   THR B  72      51.975  67.405  25.671  1.00 18.44           O  
ATOM   6470  CB  THR B  72      52.751  68.053  28.758  1.00 20.59           C  
ATOM   6471  OG1 THR B  72      54.174  67.891  28.652  1.00 17.59           O  
ATOM   6472  CG2 THR B  72      52.088  66.700  28.820  1.00 21.63           C  
ATOM   6473  N   ILE B  73      53.772  68.757  25.761  1.00 20.02           N  
ATOM   6474  CA  ILE B  73      54.455  68.206  24.601  1.00 20.99           C  
ATOM   6475  C   ILE B  73      54.940  66.739  24.771  1.00 20.04           C  
ATOM   6476  O   ILE B  73      55.113  66.013  23.768  1.00 19.98           O  
ATOM   6477  CB  ILE B  73      55.650  69.158  24.206  1.00 21.72           C  
ATOM   6478  CG1 ILE B  73      56.066  68.939  22.763  1.00 24.32           C  
ATOM   6479  CG2 ILE B  73      56.790  69.041  25.152  1.00 22.29           C  
ATOM   6480  CD1 ILE B  73      55.107  69.591  21.788  1.00 27.84           C  
ATOM   6481  N   THR B  74      55.124  66.296  26.021  1.00 18.57           N  
ATOM   6482  CA  THR B  74      55.472  64.894  26.299  1.00 18.26           C  
ATOM   6483  C   THR B  74      54.298  63.899  26.257  1.00 18.07           C  
ATOM   6484  O   THR B  74      54.502  62.705  26.449  1.00 18.20           O  
ATOM   6485  CB  THR B  74      56.160  64.748  27.678  1.00 18.49           C  
ATOM   6486  OG1 THR B  74      55.236  65.153  28.687  1.00 18.90           O  
ATOM   6487  CG2 THR B  74      57.424  65.579  27.749  1.00 17.53           C  
ATOM   6488  N   SER B  75      53.087  64.356  25.989  1.00 19.29           N  
ATOM   6489  CA  SER B  75      52.002  63.427  25.555  1.00 19.46           C  
ATOM   6490  C   SER B  75      52.096  63.191  24.061  1.00 18.95           C  
ATOM   6491  O   SER B  75      51.907  64.141  23.282  1.00 19.50           O  
ATOM   6492  CB  SER B  75      50.600  63.998  25.830  1.00 20.68           C  
ATOM   6493  OG  SER B  75      49.586  63.244  25.123  1.00 19.94           O  
ATOM   6494  N   THR B  76      52.341  61.941  23.637  1.00 17.85           N  
ATOM   6495  CA  THR B  76      52.443  61.687  22.208  1.00 18.07           C  
ATOM   6496  C   THR B  76      51.086  61.842  21.519  1.00 18.82           C  
ATOM   6497  O   THR B  76      51.058  62.060  20.322  1.00 18.62           O  
ATOM   6498  CB  THR B  76      53.038  60.306  21.845  1.00 18.25           C  
ATOM   6499  OG1 THR B  76      52.239  59.248  22.378  1.00 16.10           O  
ATOM   6500  CG2 THR B  76      54.450  60.185  22.321  1.00 17.12           C  
ATOM   6501  N   TYR B  77      49.991  61.675  22.271  1.00 19.22           N  
ATOM   6502  CA  TYR B  77      48.621  61.960  21.814  1.00 20.61           C  
ATOM   6503  C   TYR B  77      48.482  63.422  21.353  1.00 20.53           C  
ATOM   6504  O   TYR B  77      48.108  63.682  20.198  1.00 20.24           O  
ATOM   6505  CB  TYR B  77      47.616  61.638  22.944  1.00 22.23           C  
ATOM   6506  CG  TYR B  77      46.194  62.019  22.654  1.00 22.37           C  
ATOM   6507  CD1 TYR B  77      45.361  61.156  22.004  1.00 25.19           C  
ATOM   6508  CD2 TYR B  77      45.696  63.273  23.014  1.00 26.98           C  
ATOM   6509  CE1 TYR B  77      44.034  61.501  21.701  1.00 24.69           C  
ATOM   6510  CE2 TYR B  77      44.366  63.636  22.719  1.00 28.01           C  
ATOM   6511  CZ  TYR B  77      43.555  62.741  22.056  1.00 26.38           C  
ATOM   6512  OH  TYR B  77      42.267  63.081  21.755  1.00 27.00           O  
ATOM   6513  N   PHE B  78      48.816  64.372  22.237  1.00 19.77           N  
ATOM   6514  CA  PHE B  78      48.746  65.792  21.887  1.00 20.16           C  
ATOM   6515  C   PHE B  78      49.820  66.202  20.866  1.00 19.44           C  
ATOM   6516  O   PHE B  78      49.541  66.977  19.946  1.00 19.91           O  
ATOM   6517  CB  PHE B  78      48.806  66.680  23.137  1.00 20.28           C  
ATOM   6518  CG  PHE B  78      47.629  66.513  24.042  1.00 20.99           C  
ATOM   6519  CD1 PHE B  78      46.358  66.845  23.603  1.00 24.22           C  
ATOM   6520  CD2 PHE B  78      47.795  66.045  25.333  1.00 23.70           C  
ATOM   6521  CE1 PHE B  78      45.256  66.707  24.433  1.00 25.02           C  
ATOM   6522  CE2 PHE B  78      46.699  65.885  26.177  1.00 24.59           C  
ATOM   6523  CZ  PHE B  78      45.420  66.211  25.704  1.00 24.60           C  
ATOM   6524  N   ALA B  79      51.017  65.646  20.987  1.00 19.09           N  
ATOM   6525  CA  ALA B  79      52.085  65.915  19.993  1.00 18.79           C  
ATOM   6526  C   ALA B  79      51.703  65.483  18.556  1.00 18.86           C  
ATOM   6527  O   ALA B  79      52.023  66.179  17.581  1.00 18.23           O  
ATOM   6528  CB  ALA B  79      53.401  65.281  20.432  1.00 18.86           C  
ATOM   6529  N   ALA B  80      51.001  64.352  18.410  1.00 18.06           N  
ATOM   6530  CA  ALA B  80      50.600  63.893  17.094  1.00 19.03           C  
ATOM   6531  C   ALA B  80      49.561  64.798  16.457  1.00 18.66           C  
ATOM   6532  O   ALA B  80      49.646  65.103  15.266  1.00 19.03           O  
ATOM   6533  CB  ALA B  80      50.105  62.457  17.170  1.00 18.90           C  
ATOM   6534  N   ILE B  81      48.602  65.250  17.239  1.00 18.57           N  
ATOM   6535  CA  ILE B  81      47.645  66.257  16.798  1.00 20.42           C  
ATOM   6536  C   ILE B  81      48.324  67.547  16.366  1.00 20.21           C  
ATOM   6537  O   ILE B  81      47.995  68.132  15.313  1.00 20.90           O  
ATOM   6538  CB  ILE B  81      46.579  66.582  17.897  1.00 20.14           C  
ATOM   6539  CG1 ILE B  81      45.733  65.337  18.204  1.00 20.78           C  
ATOM   6540  CG2 ILE B  81      45.672  67.730  17.443  1.00 23.23           C  
ATOM   6541  CD1 ILE B  81      44.915  65.471  19.465  1.00 20.56           C  
ATOM   6542  N   THR B  82      49.284  67.969  17.177  1.00 19.78           N  
ATOM   6543  CA  THR B  82      49.998  69.224  16.983  1.00 20.50           C  
ATOM   6544  C   THR B  82      50.762  69.195  15.648  1.00 19.82           C  
ATOM   6545  O   THR B  82      50.829  70.229  14.962  1.00 20.76           O  
ATOM   6546  CB  THR B  82      50.901  69.573  18.228  1.00 20.30           C  
ATOM   6547  OG1 THR B  82      50.092  69.744  19.414  1.00 22.67           O  
ATOM   6548  CG2 THR B  82      51.685  70.833  18.018  1.00 21.10           C  
ATOM   6549  N   ARG B  83      51.307  68.048  15.239  1.00 20.07           N  
ATOM   6550  CA  ARG B  83      51.979  67.970  13.924  1.00 19.07           C  
ATOM   6551  C   ARG B  83      51.014  68.211  12.749  1.00 19.38           C  
ATOM   6552  O   ARG B  83      51.405  68.815  11.740  1.00 18.24           O  
ATOM   6553  CB  ARG B  83      52.790  66.675  13.748  1.00 20.31           C  
ATOM   6554  CG  ARG B  83      54.010  66.617  14.729  1.00 21.40           C  
ATOM   6555  CD  ARG B  83      55.260  65.953  14.212  1.00 24.28           C  
ATOM   6556  NE  ARG B  83      55.719  66.521  12.953  1.00 22.69           N  
ATOM   6557  CZ  ARG B  83      56.661  65.980  12.191  1.00 23.31           C  
ATOM   6558  NH1 ARG B  83      57.292  64.865  12.562  1.00 23.22           N  
ATOM   6559  NH2 ARG B  83      56.985  66.560  11.048  1.00 23.92           N  
ATOM   6560  N   GLY B  84      49.758  67.793  12.894  1.00 18.26           N  
ATOM   6561  CA  GLY B  84      48.734  68.072  11.861  1.00 19.15           C  
ATOM   6562  C   GLY B  84      48.403  69.559  11.755  1.00 19.25           C  
ATOM   6563  O   GLY B  84      48.263  70.125  10.651  1.00 19.24           O  
ATOM   6564  N   VAL B  85      48.284  70.205  12.904  1.00 19.71           N  
ATOM   6565  CA  VAL B  85      48.118  71.667  12.987  1.00 20.24           C  
ATOM   6566  C   VAL B  85      49.303  72.395  12.323  1.00 20.70           C  
ATOM   6567  O   VAL B  85      49.109  73.263  11.443  1.00 19.67           O  
ATOM   6568  CB  VAL B  85      47.984  72.140  14.461  1.00 20.40           C  
ATOM   6569  CG1 VAL B  85      47.898  73.688  14.570  1.00 21.87           C  
ATOM   6570  CG2 VAL B  85      46.797  71.505  15.145  1.00 20.35           C  
ATOM   6571  N   ASP B  86      50.517  72.034  12.747  1.00 19.42           N  
ATOM   6572  CA  ASP B  86      51.762  72.629  12.246  1.00 21.16           C  
ATOM   6573  C   ASP B  86      51.894  72.554  10.718  1.00 20.99           C  
ATOM   6574  O   ASP B  86      52.261  73.533  10.069  1.00 19.61           O  
ATOM   6575  CB  ASP B  86      52.938  71.927  12.926  1.00 21.71           C  
ATOM   6576  CG  ASP B  86      54.288  72.549  12.604  1.00 26.03           C  
ATOM   6577  OD1 ASP B  86      55.235  71.786  12.286  1.00 30.25           O  
ATOM   6578  OD2 ASP B  86      54.408  73.778  12.701  1.00 32.34           O  
ATOM   6579  N   ASP B  87      51.608  71.379  10.146  1.00 20.99           N  
ATOM   6580  CA  ASP B  87      51.721  71.186   8.719  1.00 22.09           C  
ATOM   6581  C   ASP B  87      50.806  72.108   7.902  1.00 22.31           C  
ATOM   6582  O   ASP B  87      51.241  72.669   6.863  1.00 22.18           O  
ATOM   6583  CB  ASP B  87      51.516  69.713   8.370  1.00 22.24           C  
ATOM   6584  CG  ASP B  87      52.769  68.877   8.640  1.00 24.17           C  
ATOM   6585  OD1 ASP B  87      53.746  69.456   9.178  1.00 25.29           O  
ATOM   6586  OD2 ASP B  87      52.757  67.641   8.357  1.00 27.60           O  
ATOM   6587  N   ILE B  88      49.567  72.281   8.364  1.00 21.89           N  
ATOM   6588  CA  ILE B  88      48.616  73.124   7.661  1.00 22.54           C  
ATOM   6589  C   ILE B  88      48.953  74.609   7.818  1.00 22.83           C  
ATOM   6590  O   ILE B  88      48.871  75.401   6.846  1.00 23.22           O  
ATOM   6591  CB  ILE B  88      47.155  72.840   8.121  1.00 22.42           C  
ATOM   6592  CG1 ILE B  88      46.749  71.381   7.805  1.00 23.60           C  
ATOM   6593  CG2 ILE B  88      46.171  73.847   7.485  1.00 23.85           C  
ATOM   6594  CD1 ILE B  88      46.523  71.117   6.327  1.00 23.88           C  
ATOM   6595  N   ALA B  89      49.325  75.003   9.027  1.00 22.58           N  
ATOM   6596  CA  ALA B  89      49.726  76.389   9.283  1.00 23.04           C  
ATOM   6597  C   ALA B  89      51.015  76.762   8.508  1.00 23.52           C  
ATOM   6598  O   ALA B  89      51.103  77.822   7.884  1.00 23.19           O  
ATOM   6599  CB  ALA B  89      49.918  76.615  10.794  1.00 23.45           C  
ATOM   6600  N   SER B  90      51.995  75.868   8.510  1.00 22.88           N  
ATOM   6601  CA  SER B  90      53.237  76.088   7.779  1.00 23.16           C  
ATOM   6602  C   SER B  90      53.084  76.183   6.239  1.00 23.36           C  
ATOM   6603  O   SER B  90      53.883  76.858   5.562  1.00 22.55           O  
ATOM   6604  CB  SER B  90      54.247  75.003   8.149  0.50 22.99           C  
ATOM   6606  OG  SER B  90      54.580  75.126   9.521  0.50 24.26           O  
ATOM   6608  N   MET B  91      52.055  75.543   5.698  1.00 22.70           N  
ATOM   6609  CA  MET B  91      51.724  75.645   4.285  1.00 24.28           C  
ATOM   6610  C   MET B  91      51.443  77.096   3.875  1.00 22.42           C  
ATOM   6611  O   MET B  91      51.745  77.501   2.752  1.00 22.88           O  
ATOM   6612  CB  MET B  91      50.502  74.776   4.004  1.00 23.89           C  
ATOM   6613  CG  MET B  91      50.113  74.661   2.567  1.00 27.47           C  
ATOM   6614  SD  MET B  91      48.967  73.293   2.308  1.00 31.29           S  
ATOM   6615  CE  MET B  91      47.622  73.719   3.406  1.00 29.12           C  
ATOM   6616  N   TYR B  92      50.827  77.854   4.786  1.00 22.12           N  
ATOM   6617  CA  TYR B  92      50.530  79.268   4.560  1.00 22.16           C  
ATOM   6618  C   TYR B  92      51.593  80.209   5.141  1.00 21.89           C  
ATOM   6619  O   TYR B  92      51.402  81.405   5.143  1.00 19.71           O  
ATOM   6620  CB  TYR B  92      49.158  79.615   5.132  1.00 23.43           C  
ATOM   6621  CG  TYR B  92      48.022  78.838   4.508  1.00 24.35           C  
ATOM   6622  CD1 TYR B  92      47.671  79.023   3.165  1.00 25.29           C  
ATOM   6623  CD2 TYR B  92      47.316  77.898   5.244  1.00 25.63           C  
ATOM   6624  CE1 TYR B  92      46.626  78.289   2.581  1.00 24.87           C  
ATOM   6625  CE2 TYR B  92      46.263  77.189   4.682  1.00 26.53           C  
ATOM   6626  CZ  TYR B  92      45.923  77.397   3.350  1.00 26.02           C  
ATOM   6627  OH  TYR B  92      44.885  76.684   2.788  1.00 26.74           O  
ATOM   6628  N   LYS B  93      52.701  79.640   5.628  1.00 22.09           N  
ATOM   6629  CA  LYS B  93      53.759  80.350   6.336  1.00 22.63           C  
ATOM   6630  C   LYS B  93      53.273  81.188   7.543  1.00 22.79           C  
ATOM   6631  O   LYS B  93      53.781  82.278   7.812  1.00 22.21           O  
ATOM   6632  CB  LYS B  93      54.588  81.175   5.346  1.00 23.64           C  
ATOM   6633  CG  LYS B  93      54.720  80.514   3.986  1.00 25.59           C  
ATOM   6634  CD  LYS B  93      56.119  80.480   3.371  1.00 30.23           C  
ATOM   6635  CE  LYS B  93      56.859  81.777   3.405  1.00 31.00           C  
ATOM   6636  NZ  LYS B  93      58.146  81.714   2.627  1.00 33.46           N  
ATOM   6637  N   TYR B  94      52.284  80.662   8.266  1.00 22.58           N  
ATOM   6638  CA  TYR B  94      51.799  81.299   9.502  1.00 22.62           C  
ATOM   6639  C   TYR B  94      52.824  81.040  10.612  1.00 23.34           C  
ATOM   6640  O   TYR B  94      53.558  80.040  10.569  1.00 23.69           O  
ATOM   6641  CB  TYR B  94      50.446  80.729   9.966  1.00 22.33           C  
ATOM   6642  CG  TYR B  94      49.266  80.931   9.028  1.00 21.83           C  
ATOM   6643  CD1 TYR B  94      49.258  81.936   8.043  1.00 21.81           C  
ATOM   6644  CD2 TYR B  94      48.122  80.131   9.165  1.00 22.60           C  
ATOM   6645  CE1 TYR B  94      48.156  82.109   7.207  1.00 22.01           C  
ATOM   6646  CE2 TYR B  94      47.024  80.291   8.334  1.00 20.99           C  
ATOM   6647  CZ  TYR B  94      47.040  81.275   7.366  1.00 21.01           C  
ATOM   6648  OH  TYR B  94      45.939  81.386   6.578  1.00 21.45           O  
ATOM   6649  N   ASN B  95      52.868  81.911  11.602  1.00 22.92           N  
ATOM   6650  CA  ASN B  95      53.667  81.651  12.811  1.00 23.98           C  
ATOM   6651  C   ASN B  95      52.880  80.756  13.758  1.00 24.00           C  
ATOM   6652  O   ASN B  95      51.664  80.886  13.880  1.00 23.84           O  
ATOM   6653  CB  ASN B  95      54.035  82.956  13.535  1.00 24.57           C  
ATOM   6654  CG  ASN B  95      54.801  83.925  12.670  1.00 25.00           C  
ATOM   6655  OD1 ASN B  95      54.501  85.122  12.670  1.00 28.85           O  
ATOM   6656  ND2 ASN B  95      55.790  83.438  11.960  1.00 19.77           N  
ATOM   6657  N   MET B  96      53.577  79.846  14.440  1.00 24.72           N  
ATOM   6658  CA  MET B  96      52.974  78.915  15.414  1.00 25.38           C  
ATOM   6659  C   MET B  96      53.610  79.179  16.789  1.00 24.99           C  
ATOM   6660  O   MET B  96      54.834  79.231  16.883  1.00 24.33           O  
ATOM   6661  CB  MET B  96      53.317  77.464  15.046  1.00 26.99           C  
ATOM   6662  CG  MET B  96      52.613  76.899  13.835  1.00 30.42           C  
ATOM   6663  SD  MET B  96      51.030  76.198  14.276  1.00 40.07           S  
ATOM   6664  CE  MET B  96      51.572  74.903  15.399  1.00 37.01           C  
ATOM   6665  N   ILE B  97      52.793  79.328  17.829  1.00 24.80           N  
ATOM   6666  CA  ILE B  97      53.288  79.443  19.201  1.00 24.91           C  
ATOM   6667  C   ILE B  97      52.704  78.290  19.992  1.00 24.08           C  
ATOM   6668  O   ILE B  97      51.477  78.114  20.020  1.00 23.94           O  
ATOM   6669  CB  ILE B  97      52.876  80.787  19.885  1.00 24.87           C  
ATOM   6670  CG1 ILE B  97      53.387  82.003  19.101  1.00 27.28           C  
ATOM   6671  CG2 ILE B  97      53.392  80.836  21.342  1.00 26.09           C  
ATOM   6672  CD1 ILE B  97      52.802  83.347  19.569  1.00 26.55           C  
ATOM   6673  N   LEU B  98      53.546  77.490  20.640  1.00 22.93           N  
ATOM   6674  CA  LEU B  98      53.033  76.386  21.429  1.00 23.31           C  
ATOM   6675  C   LEU B  98      53.192  76.688  22.920  1.00 22.90           C  
ATOM   6676  O   LEU B  98      54.243  77.151  23.351  1.00 21.99           O  
ATOM   6677  CB  LEU B  98      53.772  75.080  21.097  1.00 24.09           C  
ATOM   6678  CG  LEU B  98      53.899  74.608  19.638  1.00 25.28           C  
ATOM   6679  CD1 LEU B  98      54.664  73.298  19.608  1.00 27.78           C  
ATOM   6680  CD2 LEU B  98      52.564  74.434  18.960  1.00 27.25           C  
ATOM   6681  N   ALA B  99      52.170  76.380  23.704  1.00 22.26           N  
ATOM   6682  CA  ALA B  99      52.234  76.626  25.139  1.00 22.96           C  
ATOM   6683  C   ALA B  99      51.762  75.391  25.894  1.00 22.97           C  
ATOM   6684  O   ALA B  99      50.748  74.799  25.537  1.00 22.83           O  
ATOM   6685  CB  ALA B  99      51.396  77.797  25.480  1.00 22.77           C  
ATOM   6686  N   ASN B 100      52.495  75.017  26.941  1.00 23.08           N  
ATOM   6687  CA  ASN B 100      52.127  73.891  27.795  1.00 23.37           C  
ATOM   6688  C   ASN B 100      51.323  74.391  28.987  1.00 23.63           C  
ATOM   6689  O   ASN B 100      51.776  75.292  29.708  1.00 23.19           O  
ATOM   6690  CB  ASN B 100      53.384  73.200  28.344  1.00 23.34           C  
ATOM   6691  CG  ASN B 100      54.244  72.572  27.245  1.00 24.83           C  
ATOM   6692  OD1 ASN B 100      53.810  71.652  26.520  1.00 22.47           O  
ATOM   6693  ND2 ASN B 100      55.462  73.081  27.101  1.00 26.27           N  
ATOM   6694  N   SER B 101      50.155  73.793  29.209  1.00 23.55           N  
ATOM   6695  CA  SER B 101      49.258  74.177  30.301  1.00 22.91           C  
ATOM   6696  C   SER B 101      49.280  73.226  31.501  1.00 23.24           C  
ATOM   6697  O   SER B 101      48.765  73.595  32.552  1.00 22.51           O  
ATOM   6698  CB  SER B 101      47.825  74.198  29.796  1.00 24.06           C  
ATOM   6699  OG  SER B 101      47.321  72.874  29.640  1.00 21.69           O  
ATOM   6700  N   ASP B 102      49.810  72.007  31.309  1.00 22.53           N  
ATOM   6701  CA  ASP B 102      49.781  70.931  32.314  1.00 23.48           C  
ATOM   6702  C   ASP B 102      48.352  70.664  32.826  1.00 23.62           C  
ATOM   6703  O   ASP B 102      48.167  70.195  33.955  1.00 22.77           O  
ATOM   6704  CB  ASP B 102      50.740  71.235  33.479  1.00 23.86           C  
ATOM   6705  CG  ASP B 102      52.190  71.338  33.023  1.00 25.36           C  
ATOM   6706  OD1 ASP B 102      52.693  70.363  32.421  1.00 26.32           O  
ATOM   6707  OD2 ASP B 102      52.810  72.393  33.229  1.00 27.44           O  
ATOM   6708  N   ASN B 103      47.356  70.974  31.988  1.00 24.28           N  
ATOM   6709  CA  ASN B 103      45.950  70.925  32.401  1.00 25.91           C  
ATOM   6710  C   ASN B 103      45.571  71.690  33.687  1.00 26.19           C  
ATOM   6711  O   ASN B 103      44.657  71.282  34.424  1.00 26.90           O  
ATOM   6712  CB  ASN B 103      45.538  69.461  32.549  1.00 26.58           C  
ATOM   6713  CG  ASN B 103      45.002  68.890  31.290  1.00 27.72           C  
ATOM   6714  OD1 ASN B 103      45.323  67.768  30.956  1.00 34.82           O  
ATOM   6715  ND2 ASN B 103      44.149  69.642  30.584  1.00 27.08           N  
ATOM   6716  N   ASP B 104      46.295  72.770  33.964  1.00 26.76           N  
ATOM   6717  CA  ASP B 104      46.092  73.611  35.149  1.00 27.27           C  
ATOM   6718  C   ASP B 104      45.359  74.887  34.689  1.00 27.11           C  
ATOM   6719  O   ASP B 104      45.870  75.616  33.857  1.00 25.74           O  
ATOM   6720  CB  ASP B 104      47.476  73.931  35.753  1.00 27.21           C  
ATOM   6721  CG  ASP B 104      47.425  74.831  36.993  1.00 30.05           C  
ATOM   6722  OD1 ASP B 104      48.314  74.679  37.857  1.00 34.51           O  
ATOM   6723  OD2 ASP B 104      46.545  75.698  37.125  1.00 31.81           O  
ATOM   6724  N   VAL B 105      44.189  75.174  35.266  1.00 28.08           N  
ATOM   6725  CA  VAL B 105      43.347  76.289  34.817  1.00 28.38           C  
ATOM   6726  C   VAL B 105      43.987  77.668  35.037  1.00 28.62           C  
ATOM   6727  O   VAL B 105      43.799  78.572  34.221  1.00 29.18           O  
ATOM   6728  CB  VAL B 105      41.931  76.224  35.457  1.00 29.38           C  
ATOM   6729  CG1 VAL B 105      41.074  77.393  35.000  1.00 29.47           C  
ATOM   6730  CG2 VAL B 105      41.257  74.913  35.079  1.00 30.71           C  
ATOM   6731  N   GLU B 106      44.776  77.817  36.095  1.00 28.24           N  
ATOM   6732  CA  GLU B 106      45.561  79.030  36.313  1.00 29.05           C  
ATOM   6733  C   GLU B 106      46.580  79.230  35.198  1.00 28.75           C  
ATOM   6734  O   GLU B 106      46.798  80.339  34.721  1.00 27.60           O  
ATOM   6735  CB  GLU B 106      46.331  78.954  37.634  1.00 29.08           C  
ATOM   6736  CG  GLU B 106      45.505  78.745  38.890  1.00 30.29           C  
ATOM   6737  CD  GLU B 106      46.366  78.793  40.168  1.00 31.94           C  
ATOM   6738  OE1 GLU B 106      47.510  79.315  40.106  1.00 35.01           O  
ATOM   6739  OE2 GLU B 106      45.894  78.331  41.239  1.00 36.71           O  
ATOM   6740  N   LYS B 107      47.211  78.126  34.801  1.00 29.29           N  
ATOM   6741  CA  LYS B 107      48.218  78.131  33.749  1.00 29.84           C  
ATOM   6742  C   LYS B 107      47.546  78.425  32.399  1.00 28.64           C  
ATOM   6743  O   LYS B 107      48.054  79.194  31.607  1.00 27.94           O  
ATOM   6744  CB  LYS B 107      48.954  76.787  33.745  1.00 30.24           C  
ATOM   6745  CG  LYS B 107      50.445  76.840  33.397  1.00 32.98           C  
ATOM   6746  CD  LYS B 107      51.175  75.514  33.805  1.00 32.70           C  
ATOM   6747  CE  LYS B 107      52.058  75.669  35.032  1.00 36.28           C  
ATOM   6748  NZ  LYS B 107      52.554  74.345  35.591  1.00 36.55           N  
ATOM   6749  N   GLU B 108      46.382  77.827  32.169  1.00 28.21           N  
ATOM   6750  CA  GLU B 108      45.599  78.104  30.958  1.00 28.19           C  
ATOM   6751  C   GLU B 108      45.233  79.593  30.856  1.00 27.34           C  
ATOM   6752  O   GLU B 108      45.379  80.186  29.783  1.00 25.85           O  
ATOM   6753  CB  GLU B 108      44.348  77.225  30.900  1.00 28.01           C  
ATOM   6754  CG  GLU B 108      44.675  75.753  30.634  1.00 29.15           C  
ATOM   6755  CD  GLU B 108      43.480  74.834  30.744  1.00 29.81           C  
ATOM   6756  OE1 GLU B 108      42.494  75.198  31.445  1.00 30.31           O  
ATOM   6757  OE2 GLU B 108      43.543  73.723  30.153  1.00 32.08           O  
ATOM   6758  N   GLU B 109      44.788  80.197  31.967  1.00 27.14           N  
ATOM   6759  CA  GLU B 109      44.431  81.625  31.977  1.00 27.29           C  
ATOM   6760  C   GLU B 109      45.608  82.525  31.657  1.00 26.84           C  
ATOM   6761  O   GLU B 109      45.461  83.491  30.924  1.00 26.88           O  
ATOM   6762  CB  GLU B 109      43.870  82.058  33.348  1.00 28.24           C  
ATOM   6763  CG  GLU B 109      42.408  81.741  33.539  1.00 31.23           C  
ATOM   6764  CD  GLU B 109      41.887  82.295  34.845  1.00 33.61           C  
ATOM   6765  OE1 GLU B 109      41.765  81.516  35.814  1.00 36.72           O  
ATOM   6766  OE2 GLU B 109      41.629  83.513  34.902  1.00 36.18           O  
ATOM   6767  N   LYS B 110      46.761  82.231  32.241  1.00 26.58           N  
ATOM   6768  CA  LYS B 110      47.971  82.995  31.968  1.00 27.41           C  
ATOM   6769  C   LYS B 110      48.375  82.869  30.490  1.00 27.17           C  
ATOM   6770  O   LYS B 110      48.713  83.859  29.855  1.00 26.46           O  
ATOM   6771  CB  LYS B 110      49.111  82.547  32.885  1.00 26.93           C  
ATOM   6772  CG  LYS B 110      48.884  82.935  34.335  1.00 29.08           C  
ATOM   6773  CD  LYS B 110      49.945  82.387  35.282  1.00 29.58           C  
ATOM   6774  CE  LYS B 110      51.305  83.033  35.047  1.00 32.06           C  
ATOM   6775  NZ  LYS B 110      52.254  82.675  36.137  1.00 32.24           N  
ATOM   6776  N   VAL B 111      48.313  81.651  29.954  1.00 28.16           N  
ATOM   6777  CA  VAL B 111      48.657  81.407  28.536  1.00 29.04           C  
ATOM   6778  C   VAL B 111      47.792  82.270  27.596  1.00 29.66           C  
ATOM   6779  O   VAL B 111      48.321  82.969  26.718  1.00 29.36           O  
ATOM   6780  CB  VAL B 111      48.567  79.898  28.174  1.00 29.22           C  
ATOM   6781  CG1 VAL B 111      48.630  79.687  26.665  1.00 30.42           C  
ATOM   6782  CG2 VAL B 111      49.691  79.119  28.868  1.00 29.21           C  
ATOM   6783  N   LEU B 112      46.477  82.247  27.795  1.00 30.81           N  
ATOM   6784  CA  LEU B 112      45.560  83.116  27.030  1.00 32.19           C  
ATOM   6785  C   LEU B 112      45.834  84.621  27.148  1.00 32.99           C  
ATOM   6786  O   LEU B 112      45.681  85.361  26.177  1.00 32.94           O  
ATOM   6787  CB  LEU B 112      44.110  82.858  27.418  1.00 32.38           C  
ATOM   6788  CG  LEU B 112      43.521  81.496  27.083  1.00 33.09           C  
ATOM   6789  CD1 LEU B 112      42.052  81.496  27.484  1.00 33.96           C  
ATOM   6790  CD2 LEU B 112      43.658  81.175  25.617  1.00 34.88           C  
ATOM   6791  N   GLU B 113      46.240  85.078  28.325  1.00 33.85           N  
ATOM   6792  CA  GLU B 113      46.639  86.470  28.484  1.00 34.56           C  
ATOM   6793  C   GLU B 113      47.805  86.787  27.576  1.00 33.91           C  
ATOM   6794  O   GLU B 113      47.815  87.814  26.902  1.00 33.08           O  
ATOM   6795  CB  GLU B 113      47.032  86.779  29.937  1.00 34.91           C  
ATOM   6796  CG  GLU B 113      45.858  86.813  30.883  1.00 36.33           C  
ATOM   6797  CD  GLU B 113      46.232  87.171  32.322  1.00 36.94           C  
ATOM   6798  OE1 GLU B 113      47.432  87.094  32.697  1.00 39.92           O  
ATOM   6799  OE2 GLU B 113      45.302  87.530  33.082  1.00 40.51           O  
ATOM   6800  N   THR B 114      48.792  85.897  27.569  1.00 33.47           N  
ATOM   6801  CA  THR B 114      49.967  86.087  26.740  1.00 33.46           C  
ATOM   6802  C   THR B 114      49.586  86.056  25.260  1.00 33.39           C  
ATOM   6803  O   THR B 114      50.082  86.883  24.491  1.00 34.50           O  
ATOM   6804  CB  THR B 114      51.052  85.057  27.064  1.00 33.45           C  
ATOM   6805  OG1 THR B 114      51.415  85.182  28.446  1.00 32.83           O  
ATOM   6806  CG2 THR B 114      52.290  85.295  26.214  1.00 34.55           C  
ATOM   6807  N   PHE B 115      48.706  85.126  24.868  1.00 32.57           N  
ATOM   6808  CA  PHE B 115      48.191  85.050  23.483  1.00 32.23           C  
ATOM   6809  C   PHE B 115      47.404  86.307  23.067  1.00 33.50           C  
ATOM   6810  O   PHE B 115      47.637  86.871  22.002  1.00 32.56           O  
ATOM   6811  CB  PHE B 115      47.269  83.815  23.300  1.00 30.91           C  
ATOM   6812  CG  PHE B 115      47.991  82.482  23.150  1.00 28.61           C  
ATOM   6813  CD1 PHE B 115      49.371  82.356  23.276  1.00 27.10           C  
ATOM   6814  CD2 PHE B 115      47.246  81.341  22.928  1.00 27.77           C  
ATOM   6815  CE1 PHE B 115      49.996  81.113  23.149  1.00 27.92           C  
ATOM   6816  CE2 PHE B 115      47.849  80.096  22.807  1.00 28.85           C  
ATOM   6817  CZ  PHE B 115      49.234  79.986  22.904  1.00 28.16           C  
ATOM   6818  N   LEU B 116      46.454  86.717  23.911  1.00 35.58           N  
ATOM   6819  CA  LEU B 116      45.591  87.878  23.640  1.00 36.90           C  
ATOM   6820  C   LEU B 116      46.412  89.169  23.601  1.00 37.39           C  
ATOM   6821  O   LEU B 116      46.128  90.049  22.794  1.00 37.47           O  
ATOM   6822  CB  LEU B 116      44.446  87.992  24.676  1.00 37.23           C  
ATOM   6823  CG  LEU B 116      43.165  87.130  24.540  1.00 37.49           C  
ATOM   6824  CD1 LEU B 116      43.404  85.607  24.394  1.00 38.27           C  
ATOM   6825  CD2 LEU B 116      42.222  87.385  25.735  1.00 37.67           C  
ATOM   6826  N   SER B 117      47.447  89.255  24.439  1.00 38.11           N  
ATOM   6827  CA  SER B 117      48.358  90.405  24.427  1.00 38.67           C  
ATOM   6828  C   SER B 117      49.279  90.417  23.214  1.00 38.47           C  
ATOM   6829  O   SER B 117      49.586  91.493  22.694  1.00 38.54           O  
ATOM   6830  CB  SER B 117      49.206  90.483  25.708  1.00 39.12           C  
ATOM   6831  OG  SER B 117      50.490  89.906  25.520  1.00 41.26           O  
ATOM   6832  N   LYS B 118      49.744  89.239  22.786  1.00 37.71           N  
ATOM   6833  CA  LYS B 118      50.518  89.122  21.543  1.00 37.45           C  
ATOM   6834  C   LYS B 118      49.656  89.312  20.304  1.00 36.24           C  
ATOM   6835  O   LYS B 118      50.181  89.387  19.212  1.00 37.52           O  
ATOM   6836  CB  LYS B 118      51.197  87.768  21.431  1.00 37.51           C  
ATOM   6837  CG  LYS B 118      52.404  87.570  22.301  1.00 38.98           C  
ATOM   6838  CD  LYS B 118      52.870  86.132  22.174  1.00 39.76           C  
ATOM   6839  CE  LYS B 118      53.941  85.788  23.175  1.00 42.53           C  
ATOM   6840  NZ  LYS B 118      54.039  84.291  23.377  1.00 43.28           N  
ATOM   6841  N   GLN B 119      48.341  89.385  20.474  1.00 35.29           N  
ATOM   6842  CA  GLN B 119      47.411  89.553  19.363  1.00 34.51           C  
ATOM   6843  C   GLN B 119      47.521  88.378  18.364  1.00 32.74           C  
ATOM   6844  O   GLN B 119      47.600  88.570  17.135  1.00 32.47           O  
ATOM   6845  CB  GLN B 119      47.623  90.906  18.656  1.00 34.57           C  
ATOM   6846  CG  GLN B 119      47.166  92.135  19.447  1.00 35.94           C  
ATOM   6847  CD  GLN B 119      47.658  93.424  18.817  1.00 35.59           C  
ATOM   6848  OE1 GLN B 119      46.898  94.143  18.172  1.00 38.55           O  
ATOM   6849  NE2 GLN B 119      48.949  93.692  18.954  1.00 36.28           N  
ATOM   6850  N   VAL B 120      47.529  87.159  18.888  1.00 30.28           N  
ATOM   6851  CA  VAL B 120      47.388  86.002  17.998  1.00 28.31           C  
ATOM   6852  C   VAL B 120      46.056  86.147  17.246  1.00 26.68           C  
ATOM   6853  O   VAL B 120      45.068  86.761  17.735  1.00 25.16           O  
ATOM   6854  CB  VAL B 120      47.513  84.623  18.724  1.00 28.04           C  
ATOM   6855  CG1 VAL B 120      48.770  84.567  19.591  1.00 27.36           C  
ATOM   6856  CG2 VAL B 120      46.261  84.292  19.519  1.00 28.78           C  
ATOM   6857  N   ASP B 121      46.059  85.596  16.040  1.00 25.00           N  
ATOM   6858  CA  ASP B 121      44.954  85.693  15.107  1.00 24.27           C  
ATOM   6859  C   ASP B 121      43.934  84.559  15.293  1.00 23.04           C  
ATOM   6860  O   ASP B 121      42.782  84.670  14.871  1.00 22.01           O  
ATOM   6861  CB  ASP B 121      45.509  85.720  13.677  1.00 23.57           C  
ATOM   6862  CG  ASP B 121      46.417  86.906  13.433  1.00 25.11           C  
ATOM   6863  OD1 ASP B 121      45.871  87.995  13.264  1.00 27.15           O  
ATOM   6864  OD2 ASP B 121      47.669  86.788  13.481  1.00 25.17           O  
ATOM   6865  N   GLY B 122      44.369  83.475  15.924  1.00 21.89           N  
ATOM   6866  CA  GLY B 122      43.539  82.309  16.139  1.00 21.74           C  
ATOM   6867  C   GLY B 122      44.184  81.356  17.142  1.00 21.61           C  
ATOM   6868  O   GLY B 122      45.395  81.371  17.317  1.00 20.76           O  
ATOM   6869  N   ILE B 123      43.349  80.565  17.813  1.00 21.62           N  
ATOM   6870  CA  ILE B 123      43.766  79.642  18.887  1.00 21.81           C  
ATOM   6871  C   ILE B 123      43.253  78.218  18.613  1.00 22.00           C  
ATOM   6872  O   ILE B 123      42.089  78.022  18.305  1.00 21.55           O  
ATOM   6873  CB  ILE B 123      43.249  80.154  20.301  1.00 22.20           C  
ATOM   6874  CG1 ILE B 123      43.959  81.452  20.669  1.00 21.77           C  
ATOM   6875  CG2 ILE B 123      43.505  79.150  21.400  1.00 23.57           C  
ATOM   6876  CD1 ILE B 123      43.296  82.261  21.763  1.00 22.99           C  
ATOM   6877  N   VAL B 124      44.137  77.238  18.751  1.00 21.84           N  
ATOM   6878  CA  VAL B 124      43.749  75.835  18.849  1.00 22.09           C  
ATOM   6879  C   VAL B 124      43.923  75.403  20.305  1.00 22.09           C  
ATOM   6880  O   VAL B 124      45.001  75.558  20.871  1.00 21.30           O  
ATOM   6881  CB  VAL B 124      44.630  74.933  17.972  1.00 22.60           C  
ATOM   6882  CG1 VAL B 124      44.216  73.455  18.109  1.00 23.05           C  
ATOM   6883  CG2 VAL B 124      44.610  75.393  16.497  1.00 23.68           C  
ATOM   6884  N   TYR B 125      42.842  74.889  20.899  1.00 21.75           N  
ATOM   6885  CA  TYR B 125      42.858  74.422  22.284  1.00 22.38           C  
ATOM   6886  C   TYR B 125      42.744  72.911  22.382  1.00 22.50           C  
ATOM   6887  O   TYR B 125      41.859  72.308  21.792  1.00 21.14           O  
ATOM   6888  CB  TYR B 125      41.691  75.025  23.057  1.00 22.99           C  
ATOM   6889  CG  TYR B 125      41.591  74.526  24.484  1.00 23.94           C  
ATOM   6890  CD1 TYR B 125      42.262  75.166  25.515  1.00 23.93           C  
ATOM   6891  CD2 TYR B 125      40.850  73.379  24.790  1.00 23.98           C  
ATOM   6892  CE1 TYR B 125      42.193  74.691  26.817  1.00 24.84           C  
ATOM   6893  CE2 TYR B 125      40.776  72.892  26.107  1.00 24.85           C  
ATOM   6894  CZ  TYR B 125      41.445  73.539  27.101  1.00 25.29           C  
ATOM   6895  OH  TYR B 125      41.349  73.056  28.408  1.00 27.22           O  
ATOM   6896  N   MET B 126      43.614  72.341  23.210  1.00 23.30           N  
ATOM   6897  CA  MET B 126      43.614  70.931  23.559  1.00 25.11           C  
ATOM   6898  C   MET B 126      43.737  70.873  25.077  1.00 25.28           C  
ATOM   6899  O   MET B 126      44.412  71.695  25.672  1.00 25.17           O  
ATOM   6900  CB  MET B 126      44.818  70.223  22.920  1.00 24.85           C  
ATOM   6901  CG  MET B 126      44.703  69.850  21.458  1.00 26.31           C  
ATOM   6902  SD  MET B 126      46.336  69.339  20.828  1.00 29.24           S  
ATOM   6903  CE  MET B 126      46.944  70.900  20.261  1.00 29.58           C  
ATOM   6904  N   GLY B 127      43.061  69.916  25.697  1.00 26.57           N  
ATOM   6905  CA  GLY B 127      43.075  69.770  27.154  1.00 27.69           C  
ATOM   6906  C   GLY B 127      41.811  69.062  27.597  1.00 29.01           C  
ATOM   6907  O   GLY B 127      40.933  68.801  26.784  1.00 28.62           O  
ATOM   6908  N   SER B 128      41.705  68.754  28.884  1.00 30.92           N  
ATOM   6909  CA  SER B 128      40.614  67.898  29.360  1.00 32.14           C  
ATOM   6910  C   SER B 128      39.252  68.523  29.080  1.00 33.87           C  
ATOM   6911  O   SER B 128      38.319  67.815  28.689  1.00 34.37           O  
ATOM   6912  CB  SER B 128      40.779  67.582  30.847  0.50 32.26           C  
ATOM   6914  OG  SER B 128      40.981  68.762  31.608  0.50 32.20           O  
ATOM   6916  N   SER B 129      39.138  69.837  29.277  1.00 35.52           N  
ATOM   6917  CA  SER B 129      37.963  70.588  28.835  1.00 37.49           C  
ATOM   6918  C   SER B 129      38.068  72.074  29.162  1.00 38.21           C  
ATOM   6919  O   SER B 129      38.791  72.480  30.071  1.00 38.27           O  
ATOM   6920  CB  SER B 129      36.682  70.048  29.472  1.00 37.70           C  
ATOM   6921  OG  SER B 129      36.856  70.011  30.871  1.00 40.42           O  
ATOM   6922  N   LEU B 130      37.285  72.858  28.429  1.00 39.34           N  
ATOM   6923  CA  LEU B 130      37.298  74.310  28.507  1.00 40.42           C  
ATOM   6924  C   LEU B 130      36.564  74.834  29.751  1.00 40.87           C  
ATOM   6925  O   LEU B 130      35.338  74.731  29.851  1.00 41.03           O  
ATOM   6926  CB  LEU B 130      36.676  74.890  27.228  1.00 40.47           C  
ATOM   6927  CG  LEU B 130      37.017  76.347  26.942  1.00 40.76           C  
ATOM   6928  CD1 LEU B 130      38.488  76.486  26.604  1.00 40.64           C  
ATOM   6929  CD2 LEU B 130      36.125  76.895  25.827  1.00 41.16           C  
ATOM   6930  N   ASP B 131      37.326  75.395  30.691  1.00 41.39           N  
ATOM   6931  CA  ASP B 131      36.780  75.968  31.930  1.00 41.89           C  
ATOM   6932  C   ASP B 131      36.014  77.260  31.646  1.00 42.03           C  
ATOM   6933  O   ASP B 131      36.309  77.975  30.692  1.00 40.84           O  
ATOM   6934  CB  ASP B 131      37.923  76.213  32.937  1.00 42.31           C  
ATOM   6935  CG  ASP B 131      37.436  76.690  34.301  1.00 42.85           C  
ATOM   6936  OD1 ASP B 131      37.376  75.856  35.231  1.00 43.63           O  
ATOM   6937  OD2 ASP B 131      37.134  77.899  34.448  1.00 44.17           O  
ATOM   6938  N   GLU B 132      35.028  77.551  32.491  1.00 42.54           N  
ATOM   6939  CA  GLU B 132      34.172  78.721  32.309  1.00 43.27           C  
ATOM   6940  C   GLU B 132      34.949  80.037  32.368  1.00 43.12           C  
ATOM   6941  O   GLU B 132      34.583  81.002  31.694  1.00 42.59           O  
ATOM   6942  CB  GLU B 132      33.057  78.728  33.367  1.00 43.82           C  
ATOM   6943  CG  GLU B 132      31.919  79.703  33.093  1.00 46.02           C  
ATOM   6944  CD  GLU B 132      31.156  79.361  31.819  1.00 49.09           C  
ATOM   6945  OE1 GLU B 132      30.450  78.328  31.814  1.00 50.68           O  
ATOM   6946  OE2 GLU B 132      31.276  80.118  30.820  1.00 51.20           O  
ATOM   6947  N   LYS B 133      35.995  80.075  33.199  1.00 43.55           N  
ATOM   6948  CA  LYS B 133      36.935  81.202  33.222  1.00 44.03           C  
ATOM   6949  C   LYS B 133      37.544  81.352  31.824  1.00 44.45           C  
ATOM   6950  O   LYS B 133      37.506  82.432  31.230  1.00 44.58           O  
ATOM   6951  CB  LYS B 133      38.061  80.972  34.242  1.00 43.86           C  
ATOM   6952  CG  LYS B 133      37.624  80.917  35.714  1.00 44.14           C  
ATOM   6953  CD  LYS B 133      38.837  81.093  36.641  1.00 44.17           C  
ATOM   6954  CE  LYS B 133      38.473  81.025  38.117  1.00 45.15           C  
ATOM   6955  NZ  LYS B 133      39.319  81.944  38.961  1.00 45.50           N  
ATOM   6956  N   ILE B 134      38.063  80.237  31.307  1.00 44.94           N  
ATOM   6957  CA  ILE B 134      38.706  80.174  29.980  1.00 45.24           C  
ATOM   6958  C   ILE B 134      37.684  80.510  28.871  1.00 45.45           C  
ATOM   6959  O   ILE B 134      37.938  81.354  28.012  1.00 45.51           O  
ATOM   6960  CB  ILE B 134      39.345  78.760  29.724  1.00 45.42           C  
ATOM   6961  CG1 ILE B 134      40.190  78.271  30.915  1.00 45.36           C  
ATOM   6962  CG2 ILE B 134      40.227  78.754  28.486  1.00 45.89           C  
ATOM   6963  CD1 ILE B 134      41.330  79.195  31.361  1.00 45.59           C  
ATOM   6964  N   ARG B 135      36.517  79.862  28.907  1.00 45.62           N  
ATOM   6965  CA  ARG B 135      35.467  80.118  27.917  1.00 45.93           C  
ATOM   6966  C   ARG B 135      35.091  81.601  27.842  1.00 45.38           C  
ATOM   6967  O   ARG B 135      34.879  82.139  26.755  1.00 44.71           O  
ATOM   6968  CB  ARG B 135      34.212  79.285  28.208  1.00 45.76           C  
ATOM   6969  CG  ARG B 135      33.125  79.444  27.137  1.00 47.00           C  
ATOM   6970  CD  ARG B 135      31.755  78.953  27.579  1.00 47.96           C  
ATOM   6971  NE  ARG B 135      31.697  77.497  27.548  1.00 50.30           N  
ATOM   6972  CZ  ARG B 135      31.948  76.698  28.585  1.00 50.99           C  
ATOM   6973  NH1 ARG B 135      32.260  77.195  29.777  1.00 51.06           N  
ATOM   6974  NH2 ARG B 135      31.873  75.381  28.428  1.00 50.92           N  
ATOM   6975  N   THR B 136      34.977  82.250  28.994  1.00 45.37           N  
ATOM   6976  CA  THR B 136      34.633  83.673  29.027  1.00 45.39           C  
ATOM   6977  C   THR B 136      35.816  84.541  28.570  1.00 45.19           C  
ATOM   6978  O   THR B 136      35.623  85.522  27.851  1.00 44.90           O  
ATOM   6979  CB  THR B 136      34.170  84.123  30.431  1.00 45.51           C  
ATOM   6980  OG1 THR B 136      33.073  83.305  30.861  1.00 44.74           O  
ATOM   6981  CG2 THR B 136      33.740  85.588  30.409  1.00 45.63           C  
ATOM   6982  N   SER B 137      37.023  84.180  29.005  1.00 45.12           N  
ATOM   6983  CA  SER B 137      38.249  84.803  28.497  1.00 45.15           C  
ATOM   6984  C   SER B 137      38.193  84.857  26.969  1.00 45.05           C  
ATOM   6985  O   SER B 137      38.358  85.920  26.383  1.00 45.19           O  
ATOM   6986  CB  SER B 137      39.492  84.034  28.963  0.50 45.26           C  
ATOM   6988  OG  SER B 137      39.497  83.861  30.373  0.50 45.32           O  
ATOM   6990  N   LEU B 138      37.926  83.709  26.342  1.00 44.85           N  
ATOM   6991  CA  LEU B 138      37.854  83.605  24.871  1.00 44.43           C  
ATOM   6992  C   LEU B 138      36.688  84.390  24.262  1.00 44.48           C  
ATOM   6993  O   LEU B 138      36.784  84.903  23.149  1.00 44.33           O  
ATOM   6994  CB  LEU B 138      37.768  82.131  24.460  1.00 44.30           C  
ATOM   6995  CG  LEU B 138      39.028  81.328  24.803  1.00 43.55           C  
ATOM   6996  CD1 LEU B 138      38.769  79.829  24.818  1.00 43.15           C  
ATOM   6997  CD2 LEU B 138      40.152  81.688  23.815  1.00 44.01           C  
ATOM   6998  N   LYS B 139      35.580  84.466  24.993  1.00 44.64           N  
ATOM   6999  CA  LYS B 139      34.413  85.226  24.545  1.00 44.89           C  
ATOM   7000  C   LYS B 139      34.639  86.735  24.730  1.00 44.83           C  
ATOM   7001  O   LYS B 139      34.118  87.546  23.957  1.00 44.63           O  
ATOM   7002  CB  LYS B 139      33.155  84.789  25.307  1.00 45.01           C  
ATOM   7003  CG  LYS B 139      31.844  85.203  24.625  1.00 44.85           C  
ATOM   7004  CD  LYS B 139      30.624  84.978  25.514  1.00 45.26           C  
ATOM   7005  CE  LYS B 139      30.571  85.959  26.683  1.00 45.90           C  
ATOM   7006  NZ  LYS B 139      29.199  86.050  27.276  1.00 46.33           N  
ATOM   7007  N   ASN B 140      35.392  87.108  25.768  1.00 44.82           N  
ATOM   7008  CA  ASN B 140      35.825  88.511  25.950  1.00 44.75           C  
ATOM   7009  C   ASN B 140      36.991  88.861  25.010  1.00 44.12           C  
ATOM   7010  O   ASN B 140      37.169  90.030  24.649  1.00 44.21           O  
ATOM   7011  CB  ASN B 140      36.239  88.800  27.407  1.00 44.98           C  
ATOM   7012  CG  ASN B 140      35.051  89.027  28.338  1.00 45.55           C  
ATOM   7013  OD1 ASN B 140      33.917  89.277  27.900  1.00 46.35           O  
ATOM   7014  ND2 ASN B 140      35.312  88.944  29.642  1.00 46.27           N  
ATOM   7015  N   SER B 141      37.777  87.852  24.627  1.00 43.24           N  
ATOM   7016  CA  SER B 141      38.874  88.033  23.665  1.00 42.44           C  
ATOM   7017  C   SER B 141      38.402  88.172  22.224  1.00 41.24           C  
ATOM   7018  O   SER B 141      39.052  88.847  21.435  1.00 41.59           O  
ATOM   7019  CB  SER B 141      39.873  86.868  23.745  1.00 42.65           C  
ATOM   7020  OG  SER B 141      39.400  85.698  23.107  1.00 43.42           O  
ATOM   7021  N   ARG B 142      37.295  87.512  21.886  1.00 39.90           N  
ATOM   7022  CA  ARG B 142      36.749  87.458  20.511  1.00 38.87           C  
ATOM   7023  C   ARG B 142      37.647  86.750  19.451  1.00 36.91           C  
ATOM   7024  O   ARG B 142      37.360  86.781  18.259  1.00 36.53           O  
ATOM   7025  CB  ARG B 142      36.371  88.850  20.030  1.00 38.82           C  
ATOM   7026  CG  ARG B 142      35.123  89.398  20.704  1.00 41.57           C  
ATOM   7027  CD  ARG B 142      34.451  90.464  19.826  1.00 44.47           C  
ATOM   7028  NE  ARG B 142      32.991  90.387  19.890  1.00 46.78           N  
ATOM   7029  CZ  ARG B 142      32.257  89.420  19.336  1.00 47.21           C  
ATOM   7030  NH1 ARG B 142      32.830  88.406  18.684  1.00 48.00           N  
ATOM   7031  NH2 ARG B 142      30.936  89.455  19.454  1.00 46.71           N  
ATOM   7032  N   THR B 143      38.700  86.085  19.900  1.00 35.47           N  
ATOM   7033  CA  THR B 143      39.623  85.395  18.998  1.00 33.62           C  
ATOM   7034  C   THR B 143      38.947  84.173  18.371  1.00 31.46           C  
ATOM   7035  O   THR B 143      38.309  83.403  19.078  1.00 31.11           O  
ATOM   7036  CB  THR B 143      40.841  84.858  19.774  1.00 34.36           C  
ATOM   7037  OG1 THR B 143      41.200  85.759  20.835  1.00 36.62           O  
ATOM   7038  CG2 THR B 143      42.015  84.631  18.844  1.00 33.33           C  
ATOM   7039  N   PRO B 144      39.112  83.959  17.058  1.00 28.84           N  
ATOM   7040  CA  PRO B 144      38.745  82.640  16.526  1.00 27.24           C  
ATOM   7041  C   PRO B 144      39.463  81.486  17.264  1.00 25.79           C  
ATOM   7042  O   PRO B 144      40.653  81.571  17.550  1.00 23.48           O  
ATOM   7043  CB  PRO B 144      39.182  82.729  15.056  1.00 27.48           C  
ATOM   7044  CG  PRO B 144      39.175  84.158  14.756  1.00 27.54           C  
ATOM   7045  CD  PRO B 144      39.597  84.851  15.991  1.00 28.62           C  
ATOM   7046  N   VAL B 145      38.697  80.461  17.625  1.00 24.11           N  
ATOM   7047  CA  VAL B 145      39.204  79.313  18.392  1.00 23.43           C  
ATOM   7048  C   VAL B 145      38.526  78.020  17.911  1.00 22.02           C  
ATOM   7049  O   VAL B 145      37.334  78.022  17.535  1.00 21.20           O  
ATOM   7050  CB  VAL B 145      38.990  79.537  19.930  1.00 23.50           C  
ATOM   7051  CG1 VAL B 145      37.570  79.934  20.207  1.00 25.56           C  
ATOM   7052  CG2 VAL B 145      39.352  78.316  20.749  1.00 23.44           C  
ATOM   7053  N   VAL B 146      39.304  76.948  17.853  1.00 21.28           N  
ATOM   7054  CA  VAL B 146      38.798  75.607  17.569  1.00 21.14           C  
ATOM   7055  C   VAL B 146      39.317  74.662  18.683  1.00 20.87           C  
ATOM   7056  O   VAL B 146      40.486  74.718  19.046  1.00 21.14           O  
ATOM   7057  CB  VAL B 146      39.274  75.095  16.210  1.00 22.00           C  
ATOM   7058  CG1 VAL B 146      38.635  73.712  15.889  1.00 21.98           C  
ATOM   7059  CG2 VAL B 146      38.935  76.124  15.117  1.00 23.33           C  
ATOM   7060  N   LEU B 147      38.430  73.821  19.209  1.00 21.31           N  
ATOM   7061  CA  LEU B 147      38.780  72.786  20.200  1.00 20.82           C  
ATOM   7062  C   LEU B 147      39.078  71.466  19.489  1.00 21.53           C  
ATOM   7063  O   LEU B 147      38.400  71.127  18.512  1.00 20.83           O  
ATOM   7064  CB  LEU B 147      37.622  72.599  21.194  1.00 20.80           C  
ATOM   7065  CG  LEU B 147      36.917  73.850  21.759  1.00 21.96           C  
ATOM   7066  CD1 LEU B 147      35.732  73.448  22.597  1.00 21.18           C  
ATOM   7067  CD2 LEU B 147      37.850  74.776  22.571  1.00 24.69           C  
ATOM   7068  N   VAL B 148      40.084  70.727  19.963  1.00 21.52           N  
ATOM   7069  CA  VAL B 148      40.409  69.391  19.448  1.00 23.50           C  
ATOM   7070  C   VAL B 148      40.494  68.385  20.608  1.00 24.45           C  
ATOM   7071  O   VAL B 148      41.224  68.616  21.585  1.00 24.52           O  
ATOM   7072  CB  VAL B 148      41.748  69.363  18.655  1.00 24.04           C  
ATOM   7073  CG1 VAL B 148      41.896  68.023  17.906  1.00 25.62           C  
ATOM   7074  CG2 VAL B 148      41.859  70.572  17.682  1.00 23.79           C  
ATOM   7075  N   GLY B 149      39.718  67.302  20.524  1.00 24.09           N  
ATOM   7076  CA  GLY B 149      39.702  66.271  21.554  1.00 25.01           C  
ATOM   7077  C   GLY B 149      38.808  66.602  22.731  1.00 25.90           C  
ATOM   7078  O   GLY B 149      38.759  65.847  23.717  1.00 26.08           O  
ATOM   7079  N   THR B 150      38.108  67.734  22.655  1.00 26.26           N  
ATOM   7080  CA  THR B 150      37.097  68.075  23.659  1.00 27.39           C  
ATOM   7081  C   THR B 150      35.917  68.774  23.000  1.00 27.39           C  
ATOM   7082  O   THR B 150      36.011  69.254  21.862  1.00 25.64           O  
ATOM   7083  CB  THR B 150      37.698  68.891  24.842  1.00 27.82           C  
ATOM   7084  OG1 THR B 150      36.754  68.944  25.938  1.00 29.44           O  
ATOM   7085  CG2 THR B 150      38.125  70.296  24.400  1.00 29.36           C  
ATOM   7086  N   ILE B 151      34.788  68.755  23.713  1.00 28.61           N  
ATOM   7087  CA  ILE B 151      33.511  69.243  23.208  1.00 29.54           C  
ATOM   7088  C   ILE B 151      32.945  70.284  24.172  1.00 30.57           C  
ATOM   7089  O   ILE B 151      32.885  70.047  25.385  1.00 29.72           O  
ATOM   7090  CB  ILE B 151      32.498  68.097  23.059  1.00 29.69           C  
ATOM   7091  CG1 ILE B 151      33.055  66.968  22.174  1.00 29.93           C  
ATOM   7092  CG2 ILE B 151      31.183  68.625  22.490  1.00 31.53           C  
ATOM   7093  CD1 ILE B 151      32.283  65.672  22.279  1.00 31.20           C  
ATOM   7094  N   ASP B 152      32.548  71.437  23.624  1.00 31.71           N  
ATOM   7095  CA  ASP B 152      31.845  72.481  24.372  1.00 33.03           C  
ATOM   7096  C   ASP B 152      30.396  72.017  24.632  1.00 33.76           C  
ATOM   7097  O   ASP B 152      29.703  71.600  23.709  1.00 33.63           O  
ATOM   7098  CB  ASP B 152      31.871  73.792  23.552  1.00 32.85           C  
ATOM   7099  CG  ASP B 152      31.080  74.945  24.197  1.00 34.48           C  
ATOM   7100  OD1 ASP B 152      30.993  75.009  25.448  1.00 35.24           O  
ATOM   7101  OD2 ASP B 152      30.561  75.807  23.431  1.00 33.52           O  
ATOM   7102  N   GLY B 153      29.955  72.107  25.884  1.00 35.58           N  
ATOM   7103  CA  GLY B 153      28.585  71.737  26.289  1.00 36.58           C  
ATOM   7104  C   GLY B 153      27.475  72.475  25.551  1.00 37.81           C  
ATOM   7105  O   GLY B 153      26.456  71.883  25.172  1.00 38.37           O  
ATOM   7106  N   ASP B 154      27.667  73.771  25.328  1.00 38.77           N  
ATOM   7107  CA  ASP B 154      26.691  74.566  24.588  1.00 39.39           C  
ATOM   7108  C   ASP B 154      26.739  74.221  23.100  1.00 39.45           C  
ATOM   7109  O   ASP B 154      25.763  74.411  22.383  1.00 39.40           O  
ATOM   7110  CB  ASP B 154      26.950  76.056  24.800  1.00 39.71           C  
ATOM   7111  CG  ASP B 154      27.032  76.435  26.277  1.00 41.18           C  
ATOM   7112  OD1 ASP B 154      26.166  75.982  27.064  1.00 42.47           O  
ATOM   7113  OD2 ASP B 154      27.976  77.174  26.646  1.00 43.24           O  
ATOM   7114  N   LYS B 155      27.881  73.703  22.654  1.00 39.57           N  
ATOM   7115  CA  LYS B 155      28.111  73.319  21.252  1.00 39.53           C  
ATOM   7116  C   LYS B 155      28.070  74.517  20.316  1.00 38.55           C  
ATOM   7117  O   LYS B 155      27.641  74.398  19.175  1.00 39.01           O  
ATOM   7118  CB  LYS B 155      27.124  72.228  20.779  1.00 40.11           C  
ATOM   7119  CG  LYS B 155      27.213  70.905  21.544  1.00 41.07           C  
ATOM   7120  CD  LYS B 155      28.425  70.072  21.123  1.00 41.88           C  
ATOM   7121  CE  LYS B 155      28.197  69.387  19.763  1.00 41.88           C  
ATOM   7122  NZ  LYS B 155      29.402  68.673  19.268  1.00 39.65           N  
ATOM   7123  N   GLU B 156      28.535  75.668  20.792  1.00 37.56           N  
ATOM   7124  CA  GLU B 156      28.715  76.837  19.925  1.00 36.54           C  
ATOM   7125  C   GLU B 156      30.179  76.959  19.438  1.00 34.47           C  
ATOM   7126  O   GLU B 156      30.435  77.351  18.301  1.00 33.88           O  
ATOM   7127  CB  GLU B 156      28.214  78.126  20.622  1.00 37.26           C  
ATOM   7128  CG  GLU B 156      29.156  78.774  21.674  1.00 39.64           C  
ATOM   7129  CD  GLU B 156      28.730  78.551  23.116  1.00 41.67           C  
ATOM   7130  OE1 GLU B 156      27.524  78.732  23.405  1.00 45.04           O  
ATOM   7131  OE2 GLU B 156      29.603  78.217  23.964  1.00 42.83           O  
ATOM   7132  N   ILE B 157      31.133  76.592  20.290  1.00 32.22           N  
ATOM   7133  CA  ILE B 157      32.547  76.738  19.951  1.00 30.07           C  
ATOM   7134  C   ILE B 157      32.920  75.627  18.963  1.00 28.20           C  
ATOM   7135  O   ILE B 157      32.618  74.466  19.210  1.00 26.91           O  
ATOM   7136  CB  ILE B 157      33.439  76.667  21.194  1.00 30.03           C  
ATOM   7137  CG1 ILE B 157      33.027  77.749  22.197  1.00 31.15           C  
ATOM   7138  CG2 ILE B 157      34.915  76.836  20.821  1.00 29.96           C  
ATOM   7139  CD1 ILE B 157      33.637  77.573  23.569  1.00 32.22           C  
ATOM   7140  N   PRO B 158      33.558  75.988  17.828  1.00 25.87           N  
ATOM   7141  CA  PRO B 158      34.019  74.946  16.891  1.00 25.06           C  
ATOM   7142  C   PRO B 158      34.872  73.841  17.537  1.00 23.69           C  
ATOM   7143  O   PRO B 158      35.670  74.112  18.435  1.00 23.40           O  
ATOM   7144  CB  PRO B 158      34.797  75.747  15.844  1.00 24.85           C  
ATOM   7145  CG  PRO B 158      34.155  77.101  15.877  1.00 24.90           C  
ATOM   7146  CD  PRO B 158      33.856  77.339  17.320  1.00 25.90           C  
ATOM   7147  N   SER B 159      34.703  72.606  17.070  1.00 22.91           N  
ATOM   7148  CA  SER B 159      35.441  71.457  17.617  1.00 22.01           C  
ATOM   7149  C   SER B 159      35.625  70.327  16.596  1.00 21.54           C  
ATOM   7150  O   SER B 159      34.860  70.201  15.647  1.00 21.51           O  
ATOM   7151  CB  SER B 159      34.763  70.922  18.888  1.00 21.97           C  
ATOM   7152  OG  SER B 159      33.624  70.118  18.616  1.00 21.74           O  
ATOM   7153  N   VAL B 160      36.688  69.563  16.778  1.00 21.23           N  
ATOM   7154  CA  VAL B 160      36.973  68.375  15.979  1.00 20.85           C  
ATOM   7155  C   VAL B 160      37.282  67.200  16.926  1.00 20.57           C  
ATOM   7156  O   VAL B 160      38.189  67.288  17.766  1.00 19.37           O  
ATOM   7157  CB  VAL B 160      38.139  68.607  15.016  1.00 21.02           C  
ATOM   7158  CG1 VAL B 160      38.282  67.402  14.029  1.00 21.84           C  
ATOM   7159  CG2 VAL B 160      37.931  69.900  14.259  1.00 22.00           C  
ATOM   7160  N   ASN B 161      36.547  66.095  16.740  1.00 19.85           N  
ATOM   7161  CA  ASN B 161      36.580  64.953  17.641  1.00 19.33           C  
ATOM   7162  C   ASN B 161      36.243  63.683  16.860  1.00 18.47           C  
ATOM   7163  O   ASN B 161      35.788  63.772  15.718  1.00 19.25           O  
ATOM   7164  CB  ASN B 161      35.548  65.124  18.786  1.00 18.54           C  
ATOM   7165  CG  ASN B 161      35.903  66.226  19.759  1.00 19.47           C  
ATOM   7166  OD1 ASN B 161      36.661  66.029  20.725  1.00 18.98           O  
ATOM   7167  ND2 ASN B 161      35.332  67.393  19.539  1.00 18.61           N  
ATOM   7168  N   ILE B 162      36.456  62.520  17.480  1.00 17.43           N  
ATOM   7169  CA  ILE B 162      35.769  61.270  17.087  1.00 17.22           C  
ATOM   7170  C   ILE B 162      34.411  61.195  17.786  1.00 17.68           C  
ATOM   7171  O   ILE B 162      34.077  62.074  18.590  1.00 18.49           O  
ATOM   7172  CB  ILE B 162      36.629  59.953  17.300  1.00 16.60           C  
ATOM   7173  CG1 ILE B 162      36.860  59.611  18.776  1.00 18.01           C  
ATOM   7174  CG2 ILE B 162      37.933  60.021  16.513  1.00 15.95           C  
ATOM   7175  CD1 ILE B 162      36.989  58.132  19.039  1.00 17.82           C  
ATOM   7176  N   ASP B 163      33.616  60.183  17.431  1.00 18.97           N  
ATOM   7177  CA  ASP B 163      32.343  59.852  18.079  1.00 18.78           C  
ATOM   7178  C   ASP B 163      32.679  58.968  19.308  1.00 18.79           C  
ATOM   7179  O   ASP B 163      32.843  57.761  19.204  1.00 18.02           O  
ATOM   7180  CB  ASP B 163      31.395  59.150  17.070  1.00 18.60           C  
ATOM   7181  CG  ASP B 163      30.039  58.821  17.656  1.00 20.47           C  
ATOM   7182  OD1 ASP B 163      29.878  58.895  18.882  1.00 23.06           O  
ATOM   7183  OD2 ASP B 163      29.101  58.493  16.883  1.00 22.83           O  
ATOM   7184  N   TYR B 164      32.823  59.605  20.469  1.00 19.78           N  
ATOM   7185  CA  TYR B 164      33.227  58.871  21.702  1.00 20.73           C  
ATOM   7186  C   TYR B 164      32.183  57.846  22.191  1.00 21.46           C  
ATOM   7187  O   TYR B 164      32.522  56.791  22.776  1.00 21.95           O  
ATOM   7188  CB  TYR B 164      33.538  59.860  22.822  1.00 20.85           C  
ATOM   7189  CG  TYR B 164      34.623  60.862  22.476  1.00 20.86           C  
ATOM   7190  CD1 TYR B 164      35.958  60.468  22.365  1.00 20.17           C  
ATOM   7191  CD2 TYR B 164      34.324  62.194  22.277  1.00 19.76           C  
ATOM   7192  CE1 TYR B 164      36.944  61.368  22.057  1.00 20.52           C  
ATOM   7193  CE2 TYR B 164      35.332  63.118  21.960  1.00 19.29           C  
ATOM   7194  CZ  TYR B 164      36.635  62.692  21.861  1.00 22.15           C  
ATOM   7195  OH  TYR B 164      37.648  63.588  21.548  1.00 22.16           O  
ATOM   7196  N   HIS B 165      30.918  58.168  21.970  1.00 21.15           N  
ATOM   7197  CA  HIS B 165      29.807  57.271  22.301  1.00 21.28           C  
ATOM   7198  C   HIS B 165      29.944  55.941  21.539  1.00 20.40           C  
ATOM   7199  O   HIS B 165      29.997  54.858  22.126  1.00 18.96           O  
ATOM   7200  CB  HIS B 165      28.494  57.965  21.959  1.00 22.60           C  
ATOM   7201  CG  HIS B 165      27.292  57.093  22.109  1.00 25.06           C  
ATOM   7202  ND1 HIS B 165      26.901  56.191  21.139  1.00 32.14           N  
ATOM   7203  CD2 HIS B 165      26.380  56.997  23.096  1.00 29.61           C  
ATOM   7204  CE1 HIS B 165      25.804  55.570  21.533  1.00 30.40           C  
ATOM   7205  NE2 HIS B 165      25.461  56.049  22.712  1.00 32.02           N  
ATOM   7206  N   LEU B 166      30.067  56.042  20.233  1.00 19.72           N  
ATOM   7207  CA  LEU B 166      30.189  54.858  19.386  1.00 21.36           C  
ATOM   7208  C   LEU B 166      31.461  54.054  19.709  1.00 19.95           C  
ATOM   7209  O   LEU B 166      31.410  52.819  19.793  1.00 20.95           O  
ATOM   7210  CB  LEU B 166      30.112  55.264  17.893  1.00 20.63           C  
ATOM   7211  CG  LEU B 166      30.262  54.169  16.840  1.00 21.60           C  
ATOM   7212  CD1 LEU B 166      29.107  53.182  16.946  1.00 23.59           C  
ATOM   7213  CD2 LEU B 166      30.332  54.797  15.461  1.00 22.95           C  
ATOM   7214  N   ALA B 167      32.596  54.730  19.867  1.00 20.52           N  
ATOM   7215  CA  ALA B 167      33.846  54.051  20.252  1.00 19.84           C  
ATOM   7216  C   ALA B 167      33.723  53.300  21.588  1.00 19.30           C  
ATOM   7217  O   ALA B 167      34.180  52.170  21.707  1.00 19.19           O  
ATOM   7218  CB  ALA B 167      35.013  55.054  20.287  1.00 19.03           C  
ATOM   7219  N   ALA B 168      33.104  53.930  22.579  1.00 18.95           N  
ATOM   7220  CA  ALA B 168      32.894  53.312  23.900  1.00 19.55           C  
ATOM   7221  C   ALA B 168      31.889  52.133  23.815  1.00 18.83           C  
ATOM   7222  O   ALA B 168      32.088  51.108  24.464  1.00 19.75           O  
ATOM   7223  CB  ALA B 168      32.435  54.361  24.923  1.00 18.53           C  
ATOM   7224  N   TYR B 169      30.842  52.265  22.997  1.00 19.47           N  
ATOM   7225  CA  TYR B 169      29.903  51.169  22.723  1.00 18.55           C  
ATOM   7226  C   TYR B 169      30.595  49.970  22.059  1.00 18.06           C  
ATOM   7227  O   TYR B 169      30.471  48.861  22.557  1.00 17.84           O  
ATOM   7228  CB  TYR B 169      28.718  51.655  21.849  1.00 19.69           C  
ATOM   7229  CG  TYR B 169      27.774  50.552  21.415  1.00 20.09           C  
ATOM   7230  CD1 TYR B 169      26.774  50.081  22.271  1.00 18.74           C  
ATOM   7231  CD2 TYR B 169      27.883  49.978  20.144  1.00 21.61           C  
ATOM   7232  CE1 TYR B 169      25.900  49.069  21.869  1.00 22.14           C  
ATOM   7233  CE2 TYR B 169      27.015  48.986  19.718  1.00 23.57           C  
ATOM   7234  CZ  TYR B 169      26.029  48.520  20.592  1.00 22.56           C  
ATOM   7235  OH  TYR B 169      25.176  47.528  20.168  1.00 23.00           O  
ATOM   7236  N   GLN B 170      31.342  50.202  20.972  1.00 17.47           N  
ATOM   7237  CA  GLN B 170      32.033  49.120  20.235  1.00 18.09           C  
ATOM   7238  C   GLN B 170      33.114  48.440  21.119  1.00 18.09           C  
ATOM   7239  O   GLN B 170      33.272  47.231  21.086  1.00 17.88           O  
ATOM   7240  CB  GLN B 170      32.695  49.650  18.967  1.00 18.87           C  
ATOM   7241  CG  GLN B 170      31.726  50.038  17.855  1.00 19.92           C  
ATOM   7242  CD  GLN B 170      32.374  50.917  16.808  1.00 24.54           C  
ATOM   7243  OE1 GLN B 170      33.495  51.392  16.987  1.00 24.42           O  
ATOM   7244  NE2 GLN B 170      31.654  51.154  15.705  1.00 26.16           N  
ATOM   7245  N   SER B 171      33.839  49.232  21.914  1.00 18.11           N  
ATOM   7246  CA  SER B 171      34.854  48.699  22.820  1.00 18.11           C  
ATOM   7247  C   SER B 171      34.244  47.767  23.885  1.00 17.87           C  
ATOM   7248  O   SER B 171      34.746  46.639  24.146  1.00 18.14           O  
ATOM   7249  CB  SER B 171      35.615  49.862  23.511  1.00 18.16           C  
ATOM   7250  OG  SER B 171      36.324  50.617  22.573  1.00 21.08           O  
ATOM   7251  N   THR B 172      33.186  48.249  24.531  1.00 18.22           N  
ATOM   7252  CA  THR B 172      32.495  47.473  25.568  1.00 18.67           C  
ATOM   7253  C   THR B 172      31.904  46.181  24.968  1.00 19.21           C  
ATOM   7254  O   THR B 172      32.086  45.110  25.527  1.00 17.71           O  
ATOM   7255  CB  THR B 172      31.419  48.323  26.266  1.00 18.64           C  
ATOM   7256  OG1 THR B 172      32.019  49.540  26.744  1.00 17.89           O  
ATOM   7257  CG2 THR B 172      30.732  47.547  27.416  1.00 19.46           C  
ATOM   7258  N   LYS B 173      31.241  46.283  23.807  1.00 19.94           N  
ATOM   7259  CA  LYS B 173      30.678  45.113  23.132  1.00 20.75           C  
ATOM   7260  C   LYS B 173      31.717  44.059  22.752  1.00 19.92           C  
ATOM   7261  O   LYS B 173      31.462  42.873  22.834  1.00 20.74           O  
ATOM   7262  CB  LYS B 173      29.905  45.564  21.865  1.00 21.37           C  
ATOM   7263  CG  LYS B 173      28.983  44.543  21.284  1.00 23.55           C  
ATOM   7264  CD  LYS B 173      28.191  45.140  20.086  1.00 24.35           C  
ATOM   7265  CE  LYS B 173      27.108  44.208  19.612  1.00 27.75           C  
ATOM   7266  NZ  LYS B 173      26.267  44.904  18.602  1.00 33.63           N  
ATOM   7267  N   LYS B 174      32.906  44.493  22.345  1.00 20.80           N  
ATOM   7268  CA  LYS B 174      33.986  43.576  22.051  1.00 20.50           C  
ATOM   7269  C   LYS B 174      34.365  42.724  23.277  1.00 19.86           C  
ATOM   7270  O   LYS B 174      34.630  41.530  23.159  1.00 20.41           O  
ATOM   7271  CB  LYS B 174      35.199  44.373  21.555  1.00 20.93           C  
ATOM   7272  CG  LYS B 174      36.372  43.526  21.157  1.00 22.57           C  
ATOM   7273  CD  LYS B 174      37.396  44.321  20.361  1.00 23.44           C  
ATOM   7274  CE  LYS B 174      38.659  43.550  20.210  1.00 24.09           C  
ATOM   7275  NZ  LYS B 174      38.492  42.412  19.272  1.00 24.63           N  
ATOM   7276  N   LEU B 175      34.390  43.338  24.450  1.00 19.78           N  
ATOM   7277  CA  LEU B 175      34.726  42.610  25.686  1.00 19.34           C  
ATOM   7278  C   LEU B 175      33.537  41.711  26.118  1.00 20.41           C  
ATOM   7279  O   LEU B 175      33.727  40.618  26.666  1.00 21.54           O  
ATOM   7280  CB  LEU B 175      35.088  43.591  26.800  1.00 19.48           C  
ATOM   7281  CG  LEU B 175      36.357  44.416  26.540  1.00 18.96           C  
ATOM   7282  CD1 LEU B 175      36.532  45.536  27.547  1.00 19.15           C  
ATOM   7283  CD2 LEU B 175      37.581  43.527  26.510  1.00 20.39           C  
ATOM   7284  N   ILE B 176      32.324  42.179  25.882  1.00 21.07           N  
ATOM   7285  CA  ILE B 176      31.121  41.342  26.124  1.00 21.26           C  
ATOM   7286  C   ILE B 176      31.202  40.093  25.256  1.00 21.41           C  
ATOM   7287  O   ILE B 176      30.972  38.988  25.723  1.00 20.40           O  
ATOM   7288  CB  ILE B 176      29.817  42.124  25.845  1.00 21.79           C  
ATOM   7289  CG1 ILE B 176      29.602  43.136  26.967  1.00 21.52           C  
ATOM   7290  CG2 ILE B 176      28.567  41.169  25.764  1.00 22.90           C  
ATOM   7291  CD1 ILE B 176      28.610  44.173  26.672  1.00 20.00           C  
ATOM   7292  N   ASP B 177      31.569  40.269  23.994  1.00 22.05           N  
ATOM   7293  CA  ASP B 177      31.575  39.163  23.054  1.00 22.87           C  
ATOM   7294  C   ASP B 177      32.670  38.128  23.303  1.00 22.92           C  
ATOM   7295  O   ASP B 177      32.538  36.999  22.827  1.00 23.69           O  
ATOM   7296  CB  ASP B 177      31.575  39.678  21.605  1.00 22.83           C  
ATOM   7297  CG  ASP B 177      30.241  40.361  21.214  1.00 25.36           C  
ATOM   7298  OD1 ASP B 177      29.236  40.239  21.951  1.00 29.29           O  
ATOM   7299  OD2 ASP B 177      30.198  41.027  20.161  1.00 29.49           O  
ATOM   7300  N   SER B 178      33.719  38.483  24.056  1.00 23.04           N  
ATOM   7301  CA  SER B 178      34.723  37.521  24.499  1.00 22.97           C  
ATOM   7302  C   SER B 178      34.412  36.945  25.896  1.00 23.47           C  
ATOM   7303  O   SER B 178      35.258  36.298  26.512  1.00 23.39           O  
ATOM   7304  CB  SER B 178      36.147  38.125  24.425  1.00 22.32           C  
ATOM   7305  OG  SER B 178      36.255  39.336  25.179  1.00 22.03           O  
ATOM   7306  N   GLY B 179      33.181  37.157  26.381  1.00 23.73           N  
ATOM   7307  CA  GLY B 179      32.709  36.524  27.606  1.00 23.41           C  
ATOM   7308  C   GLY B 179      32.863  37.292  28.904  1.00 23.51           C  
ATOM   7309  O   GLY B 179      32.588  36.749  29.976  1.00 23.25           O  
ATOM   7310  N   ASN B 180      33.297  38.547  28.846  1.00 22.68           N  
ATOM   7311  CA  ASN B 180      33.452  39.335  30.077  1.00 22.71           C  
ATOM   7312  C   ASN B 180      32.086  39.835  30.589  1.00 22.92           C  
ATOM   7313  O   ASN B 180      31.252  40.294  29.815  1.00 22.71           O  
ATOM   7314  CB  ASN B 180      34.400  40.501  29.864  1.00 21.66           C  
ATOM   7315  CG  ASN B 180      35.798  40.056  29.520  1.00 21.64           C  
ATOM   7316  OD1 ASN B 180      36.570  39.637  30.409  1.00 21.58           O  
ATOM   7317  ND2 ASN B 180      36.145  40.130  28.235  1.00 19.27           N  
ATOM   7318  N   LYS B 181      31.876  39.712  31.900  1.00 23.53           N  
ATOM   7319  CA  LYS B 181      30.656  40.173  32.569  1.00 24.28           C  
ATOM   7320  C   LYS B 181      30.898  41.335  33.521  1.00 23.56           C  
ATOM   7321  O   LYS B 181      29.979  42.103  33.775  1.00 24.12           O  
ATOM   7322  CB  LYS B 181      30.029  39.028  33.364  1.00 24.91           C  
ATOM   7323  CG  LYS B 181      29.641  37.795  32.533  1.00 28.66           C  
ATOM   7324  CD  LYS B 181      28.657  38.171  31.435  1.00 33.40           C  
ATOM   7325  CE  LYS B 181      28.047  36.957  30.746  1.00 35.31           C  
ATOM   7326  NZ  LYS B 181      26.919  36.354  31.519  1.00 37.81           N  
ATOM   7327  N   LYS B 182      32.112  41.425  34.070  1.00 22.30           N  
ATOM   7328  CA  LYS B 182      32.529  42.549  34.912  1.00 21.20           C  
ATOM   7329  C   LYS B 182      33.573  43.373  34.167  1.00 20.29           C  
ATOM   7330  O   LYS B 182      34.737  42.979  34.077  1.00 19.89           O  
ATOM   7331  CB  LYS B 182      33.045  42.049  36.257  1.00 21.57           C  
ATOM   7332  CG  LYS B 182      31.952  41.447  37.138  1.00 22.99           C  
ATOM   7333  CD  LYS B 182      32.435  41.298  38.552  1.00 26.62           C  
ATOM   7334  CE  LYS B 182      31.342  41.124  39.558  1.00 29.97           C  
ATOM   7335  NZ  LYS B 182      31.979  40.868  40.906  1.00 33.03           N  
ATOM   7336  N   ILE B 183      33.103  44.476  33.572  1.00 19.34           N  
ATOM   7337  CA  ILE B 183      33.903  45.315  32.668  1.00 19.30           C  
ATOM   7338  C   ILE B 183      34.031  46.703  33.312  1.00 19.43           C  
ATOM   7339  O   ILE B 183      33.042  47.398  33.532  1.00 20.78           O  
ATOM   7340  CB  ILE B 183      33.245  45.444  31.260  1.00 18.44           C  
ATOM   7341  CG1 ILE B 183      32.995  44.055  30.634  1.00 18.86           C  
ATOM   7342  CG2 ILE B 183      34.071  46.313  30.374  1.00 16.66           C  
ATOM   7343  CD1 ILE B 183      31.926  44.021  29.540  1.00 19.78           C  
ATOM   7344  N   ALA B 184      35.258  47.099  33.595  1.00 19.37           N  
ATOM   7345  CA  ALA B 184      35.546  48.443  34.087  1.00 19.10           C  
ATOM   7346  C   ALA B 184      35.650  49.453  32.935  1.00 18.52           C  
ATOM   7347  O   ALA B 184      36.057  49.113  31.835  1.00 17.77           O  
ATOM   7348  CB  ALA B 184      36.781  48.443  34.850  1.00 19.07           C  
ATOM   7349  N   TYR B 185      35.256  50.687  33.222  1.00 19.18           N  
ATOM   7350  CA  TYR B 185      35.561  51.839  32.376  1.00 20.70           C  
ATOM   7351  C   TYR B 185      36.428  52.830  33.175  1.00 20.73           C  
ATOM   7352  O   TYR B 185      36.058  53.312  34.263  1.00 20.90           O  
ATOM   7353  CB  TYR B 185      34.291  52.554  31.859  1.00 22.11           C  
ATOM   7354  CG  TYR B 185      34.574  53.211  30.523  1.00 24.09           C  
ATOM   7355  CD1 TYR B 185      34.087  52.660  29.344  1.00 24.71           C  
ATOM   7356  CD2 TYR B 185      35.413  54.325  30.428  1.00 23.62           C  
ATOM   7357  CE1 TYR B 185      34.397  53.215  28.126  1.00 25.02           C  
ATOM   7358  CE2 TYR B 185      35.721  54.898  29.191  1.00 26.26           C  
ATOM   7359  CZ  TYR B 185      35.214  54.318  28.051  1.00 26.40           C  
ATOM   7360  OH  TYR B 185      35.487  54.841  26.812  1.00 30.19           O  
ATOM   7361  N   ILE B 186      37.605  53.127  32.635  1.00 20.61           N  
ATOM   7362  CA  ILE B 186      38.542  54.056  33.281  1.00 20.64           C  
ATOM   7363  C   ILE B 186      38.580  55.360  32.424  1.00 21.10           C  
ATOM   7364  O   ILE B 186      38.874  55.317  31.223  1.00 20.90           O  
ATOM   7365  CB  ILE B 186      39.963  53.435  33.454  1.00 20.61           C  
ATOM   7366  CG1 ILE B 186      39.915  52.196  34.363  1.00 22.54           C  
ATOM   7367  CG2 ILE B 186      40.906  54.444  34.063  1.00 20.63           C  
ATOM   7368  CD1 ILE B 186      41.058  51.260  34.200  1.00 23.39           C  
ATOM   7369  N   MET B 187      38.272  56.492  33.044  1.00 21.55           N  
ATOM   7370  CA  MET B 187      38.161  57.767  32.333  1.00 23.62           C  
ATOM   7371  C   MET B 187      38.754  58.919  33.125  1.00 23.50           C  
ATOM   7372  O   MET B 187      39.204  58.730  34.264  1.00 22.88           O  
ATOM   7373  CB  MET B 187      36.677  58.083  32.047  1.00 23.58           C  
ATOM   7374  CG  MET B 187      35.788  58.168  33.313  1.00 25.12           C  
ATOM   7375  SD  MET B 187      34.130  58.787  32.898  1.00 28.70           S  
ATOM   7376  CE  MET B 187      33.673  57.652  31.622  1.00 28.74           C  
ATOM   7377  N   GLY B 188      38.702  60.113  32.512  1.00 24.53           N  
ATOM   7378  CA  GLY B 188      38.931  61.392  33.187  1.00 25.33           C  
ATOM   7379  C   GLY B 188      37.740  61.854  34.018  1.00 26.30           C  
ATOM   7380  O   GLY B 188      37.128  61.063  34.723  1.00 27.41           O  
ATOM   7381  N   SER B 189      37.413  63.135  33.965  1.00 27.84           N  
ATOM   7382  CA  SER B 189      36.265  63.677  34.721  1.00 28.66           C  
ATOM   7383  C   SER B 189      34.958  63.389  34.016  1.00 29.84           C  
ATOM   7384  O   SER B 189      34.761  63.772  32.853  1.00 29.21           O  
ATOM   7385  CB  SER B 189      36.418  65.180  34.944  1.00 29.14           C  
ATOM   7386  OG  SER B 189      35.212  65.732  35.463  1.00 30.03           O  
ATOM   7387  N   LEU B 190      34.032  62.735  34.715  1.00 30.88           N  
ATOM   7388  CA  LEU B 190      32.746  62.397  34.116  1.00 32.54           C  
ATOM   7389  C   LEU B 190      31.945  63.630  33.710  1.00 32.90           C  
ATOM   7390  O   LEU B 190      31.140  63.546  32.789  1.00 34.26           O  
ATOM   7391  CB  LEU B 190      31.916  61.516  35.060  1.00 32.98           C  
ATOM   7392  CG  LEU B 190      30.570  60.988  34.562  1.00 33.97           C  
ATOM   7393  CD1 LEU B 190      30.779  60.008  33.410  1.00 35.01           C  
ATOM   7394  CD2 LEU B 190      29.826  60.314  35.737  1.00 34.21           C  
ATOM   7395  N   LYS B 191      32.197  64.772  34.355  1.00 33.58           N  
ATOM   7396  CA  LYS B 191      31.458  66.023  34.087  1.00 34.65           C  
ATOM   7397  C   LYS B 191      31.638  66.553  32.665  1.00 34.30           C  
ATOM   7398  O   LYS B 191      30.764  67.247  32.142  1.00 34.87           O  
ATOM   7399  CB  LYS B 191      31.866  67.112  35.096  1.00 34.75           C  
ATOM   7400  CG  LYS B 191      31.551  66.719  36.535  1.00 36.30           C  
ATOM   7401  CD  LYS B 191      31.658  67.876  37.523  1.00 37.22           C  
ATOM   7402  CE  LYS B 191      33.063  68.024  38.082  1.00 39.43           C  
ATOM   7403  NZ  LYS B 191      33.182  69.217  38.984  1.00 41.16           N  
ATOM   7404  N   ASP B 192      32.771  66.218  32.054  1.00 33.30           N  
ATOM   7405  CA  ASP B 192      33.095  66.612  30.688  1.00 32.77           C  
ATOM   7406  C   ASP B 192      32.243  65.868  29.647  1.00 31.58           C  
ATOM   7407  O   ASP B 192      31.993  64.671  29.782  1.00 31.41           O  
ATOM   7408  CB  ASP B 192      34.589  66.363  30.445  1.00 32.68           C  
ATOM   7409  CG  ASP B 192      35.468  67.168  31.390  1.00 34.10           C  
ATOM   7410  OD1 ASP B 192      34.996  68.200  31.900  1.00 34.60           O  
ATOM   7411  OD2 ASP B 192      36.632  66.789  31.619  1.00 37.91           O  
ATOM   7412  N   VAL B 193      31.835  66.583  28.599  1.00 30.79           N  
ATOM   7413  CA  VAL B 193      30.860  66.070  27.624  1.00 29.68           C  
ATOM   7414  C   VAL B 193      31.302  64.741  27.005  1.00 28.84           C  
ATOM   7415  O   VAL B 193      30.543  63.783  26.968  1.00 28.29           O  
ATOM   7416  CB  VAL B 193      30.578  67.093  26.501  1.00 29.88           C  
ATOM   7417  CG1 VAL B 193      29.688  66.484  25.409  1.00 29.35           C  
ATOM   7418  CG2 VAL B 193      29.926  68.336  27.069  1.00 31.01           C  
ATOM   7419  N   GLU B 194      32.541  64.715  26.526  1.00 27.69           N  
ATOM   7420  CA  GLU B 194      33.153  63.525  25.931  1.00 27.91           C  
ATOM   7421  C   GLU B 194      33.084  62.278  26.825  1.00 27.20           C  
ATOM   7422  O   GLU B 194      32.883  61.163  26.341  1.00 26.88           O  
ATOM   7423  CB  GLU B 194      34.612  63.813  25.522  1.00 27.95           C  
ATOM   7424  CG  GLU B 194      35.487  64.479  26.582  1.00 28.71           C  
ATOM   7425  CD  GLU B 194      35.420  66.029  26.605  1.00 30.53           C  
ATOM   7426  OE1 GLU B 194      34.464  66.639  26.061  1.00 30.81           O  
ATOM   7427  OE2 GLU B 194      36.353  66.627  27.192  1.00 30.90           O  
ATOM   7428  N   ASN B 195      33.217  62.484  28.131  1.00 26.64           N  
ATOM   7429  CA  ASN B 195      33.126  61.383  29.104  1.00 26.15           C  
ATOM   7430  C   ASN B 195      31.693  60.935  29.466  1.00 25.72           C  
ATOM   7431  O   ASN B 195      31.449  59.757  29.714  1.00 25.38           O  
ATOM   7432  CB  ASN B 195      33.914  61.757  30.352  1.00 25.96           C  
ATOM   7433  CG  ASN B 195      35.394  61.740  30.103  1.00 26.25           C  
ATOM   7434  OD1 ASN B 195      35.865  60.911  29.324  1.00 26.14           O  
ATOM   7435  ND2 ASN B 195      36.144  62.660  30.733  1.00 25.01           N  
ATOM   7436  N   THR B 196      30.759  61.873  29.488  1.00 25.90           N  
ATOM   7437  CA  THR B 196      29.326  61.535  29.545  1.00 26.24           C  
ATOM   7438  C   THR B 196      28.901  60.780  28.282  1.00 25.32           C  
ATOM   7439  O   THR B 196      28.090  59.883  28.363  1.00 25.03           O  
ATOM   7440  CB  THR B 196      28.469  62.786  29.768  1.00 25.99           C  
ATOM   7441  OG1 THR B 196      28.795  63.747  28.775  1.00 31.98           O  
ATOM   7442  CG2 THR B 196      28.750  63.399  31.099  1.00 26.00           C  
ATOM   7443  N   GLU B 197      29.512  61.081  27.131  1.00 25.70           N  
ATOM   7444  CA  GLU B 197      29.252  60.334  25.882  1.00 25.47           C  
ATOM   7445  C   GLU B 197      29.830  58.907  25.938  1.00 24.05           C  
ATOM   7446  O   GLU B 197      29.172  57.961  25.520  1.00 22.69           O  
ATOM   7447  CB  GLU B 197      29.798  61.091  24.659  0.50 25.99           C  
ATOM   7449  CG  GLU B 197      29.217  62.507  24.465  0.50 27.57           C  
ATOM   7451  CD  GLU B 197      27.914  62.556  23.682  0.50 28.81           C  
ATOM   7453  OE1 GLU B 197      27.397  61.496  23.259  0.50 31.24           O  
ATOM   7455  OE2 GLU B 197      27.402  63.682  23.486  0.50 31.80           O  
ATOM   7457  N   ARG B 198      31.060  58.760  26.460  1.00 23.26           N  
ATOM   7458  CA  ARG B 198      31.649  57.444  26.694  1.00 22.80           C  
ATOM   7459  C   ARG B 198      30.763  56.620  27.635  1.00 23.08           C  
ATOM   7460  O   ARG B 198      30.497  55.441  27.382  1.00 23.14           O  
ATOM   7461  CB  ARG B 198      33.068  57.575  27.284  1.00 22.08           C  
ATOM   7462  CG  ARG B 198      34.080  58.093  26.275  1.00 21.41           C  
ATOM   7463  CD  ARG B 198      35.422  58.279  26.965  1.00 23.72           C  
ATOM   7464  NE  ARG B 198      36.489  58.598  26.026  1.00 24.37           N  
ATOM   7465  CZ  ARG B 198      37.079  59.784  25.903  1.00 26.06           C  
ATOM   7466  NH1 ARG B 198      36.696  60.832  26.608  1.00 28.25           N  
ATOM   7467  NH2 ARG B 198      38.065  59.934  25.042  1.00 27.32           N  
ATOM   7468  N   MET B 199      30.306  57.244  28.713  1.00 23.80           N  
ATOM   7469  CA  MET B 199      29.375  56.581  29.658  1.00 24.62           C  
ATOM   7470  C   MET B 199      28.085  56.070  29.009  1.00 24.00           C  
ATOM   7471  O   MET B 199      27.660  54.948  29.293  1.00 23.80           O  
ATOM   7472  CB  MET B 199      29.004  57.506  30.814  1.00 24.62           C  
ATOM   7473  CG  MET B 199      28.164  56.824  31.852  1.00 26.69           C  
ATOM   7474  SD  MET B 199      29.101  55.654  32.860  1.00 30.43           S  
ATOM   7475  CE  MET B 199      29.347  56.678  34.318  1.00 31.79           C  
ATOM   7476  N   VAL B 200      27.480  56.869  28.125  1.00 24.28           N  
ATOM   7477  CA  VAL B 200      26.251  56.453  27.476  1.00 24.21           C  
ATOM   7478  C   VAL B 200      26.542  55.231  26.615  1.00 22.67           C  
ATOM   7479  O   VAL B 200      25.805  54.271  26.661  1.00 22.48           O  
ATOM   7480  CB  VAL B 200      25.605  57.595  26.670  1.00 24.95           C  
ATOM   7481  CG1 VAL B 200      24.363  57.111  25.881  1.00 26.29           C  
ATOM   7482  CG2 VAL B 200      25.221  58.753  27.603  1.00 27.23           C  
ATOM   7483  N   GLY B 201      27.636  55.253  25.864  1.00 21.26           N  
ATOM   7484  CA  GLY B 201      27.955  54.142  24.965  1.00 20.95           C  
ATOM   7485  C   GLY B 201      28.248  52.848  25.726  1.00 20.46           C  
ATOM   7486  O   GLY B 201      27.765  51.771  25.364  1.00 18.93           O  
ATOM   7487  N   TYR B 202      29.025  52.970  26.800  1.00 20.08           N  
ATOM   7488  CA  TYR B 202      29.316  51.856  27.720  1.00 19.56           C  
ATOM   7489  C   TYR B 202      28.046  51.202  28.304  1.00 20.05           C  
ATOM   7490  O   TYR B 202      27.894  49.976  28.285  1.00 18.52           O  
ATOM   7491  CB  TYR B 202      30.238  52.399  28.833  1.00 19.85           C  
ATOM   7492  CG  TYR B 202      30.516  51.528  30.054  1.00 18.83           C  
ATOM   7493  CD1 TYR B 202      31.293  50.367  29.970  1.00 19.54           C  
ATOM   7494  CD2 TYR B 202      30.054  51.915  31.305  1.00 21.47           C  
ATOM   7495  CE1 TYR B 202      31.582  49.595  31.113  1.00 19.71           C  
ATOM   7496  CE2 TYR B 202      30.365  51.178  32.459  1.00 20.76           C  
ATOM   7497  CZ  TYR B 202      31.106  50.014  32.348  1.00 20.42           C  
ATOM   7498  OH  TYR B 202      31.355  49.300  33.487  1.00 20.98           O  
ATOM   7499  N   GLN B 203      27.167  52.036  28.829  1.00 19.98           N  
ATOM   7500  CA  GLN B 203      25.903  51.593  29.403  1.00 21.82           C  
ATOM   7501  C   GLN B 203      24.947  50.944  28.407  1.00 21.70           C  
ATOM   7502  O   GLN B 203      24.269  49.964  28.749  1.00 21.62           O  
ATOM   7503  CB  GLN B 203      25.205  52.765  30.092  1.00 21.86           C  
ATOM   7504  CG  GLN B 203      25.859  53.174  31.421  1.00 25.52           C  
ATOM   7505  CD  GLN B 203      25.388  54.546  31.871  1.00 28.47           C  
ATOM   7506  OE1 GLN B 203      24.814  55.312  31.077  1.00 29.45           O  
ATOM   7507  NE2 GLN B 203      25.622  54.869  33.124  1.00 28.26           N  
ATOM   7508  N   GLU B 204      24.892  51.505  27.203  1.00 22.93           N  
ATOM   7509  CA  GLU B 204      24.146  50.944  26.078  1.00 24.11           C  
ATOM   7510  C   GLU B 204      24.594  49.507  25.762  1.00 22.98           C  
ATOM   7511  O   GLU B 204      23.767  48.618  25.598  1.00 22.73           O  
ATOM   7512  CB  GLU B 204      24.383  51.848  24.877  1.00 25.24           C  
ATOM   7513  CG  GLU B 204      23.620  51.535  23.604  1.00 27.13           C  
ATOM   7514  CD  GLU B 204      23.849  52.603  22.543  1.00 28.86           C  
ATOM   7515  OE1 GLU B 204      23.320  53.736  22.718  1.00 34.73           O  
ATOM   7516  OE2 GLU B 204      24.557  52.323  21.542  1.00 36.62           O  
ATOM   7517  N   ALA B 205      25.908  49.279  25.700  1.00 21.74           N  
ATOM   7518  CA  ALA B 205      26.438  47.930  25.471  1.00 20.90           C  
ATOM   7519  C   ALA B 205      26.043  46.950  26.595  1.00 20.68           C  
ATOM   7520  O   ALA B 205      25.593  45.835  26.312  1.00 21.63           O  
ATOM   7521  CB  ALA B 205      27.954  47.971  25.273  1.00 22.06           C  
ATOM   7522  N   LEU B 206      26.190  47.360  27.855  1.00 20.61           N  
ATOM   7523  CA  LEU B 206      25.841  46.494  29.003  1.00 21.02           C  
ATOM   7524  C   LEU B 206      24.348  46.101  28.979  1.00 22.24           C  
ATOM   7525  O   LEU B 206      24.006  44.937  29.135  1.00 21.11           O  
ATOM   7526  CB  LEU B 206      26.155  47.177  30.340  1.00 21.05           C  
ATOM   7527  CG  LEU B 206      27.640  47.513  30.613  1.00 21.69           C  
ATOM   7528  CD1 LEU B 206      27.822  48.056  32.018  1.00 24.02           C  
ATOM   7529  CD2 LEU B 206      28.549  46.300  30.414  1.00 21.37           C  
ATOM   7530  N   LEU B 207      23.497  47.103  28.838  1.00 22.86           N  
ATOM   7531  CA  LEU B 207      22.036  46.928  28.695  1.00 24.74           C  
ATOM   7532  C   LEU B 207      21.587  45.900  27.650  1.00 24.10           C  
ATOM   7533  O   LEU B 207      20.673  45.095  27.892  1.00 24.47           O  
ATOM   7534  CB  LEU B 207      21.438  48.260  28.309  1.00 25.74           C  
ATOM   7535  CG  LEU B 207      20.826  49.083  29.422  1.00 29.37           C  
ATOM   7536  CD1 LEU B 207      20.753  50.567  29.033  1.00 32.03           C  
ATOM   7537  CD2 LEU B 207      19.444  48.555  29.620  1.00 32.16           C  
ATOM   7538  N   GLU B 208      22.202  45.949  26.480  1.00 24.21           N  
ATOM   7539  CA  GLU B 208      21.840  45.041  25.396  1.00 24.46           C  
ATOM   7540  C   GLU B 208      22.259  43.606  25.675  1.00 25.36           C  
ATOM   7541  O   GLU B 208      21.646  42.676  25.147  1.00 25.63           O  
ATOM   7542  CB  GLU B 208      22.419  45.509  24.077  1.00 23.99           C  
ATOM   7543  CG  GLU B 208      21.791  46.779  23.518  1.00 24.42           C  
ATOM   7544  CD  GLU B 208      22.556  47.281  22.298  1.00 27.57           C  
ATOM   7545  OE1 GLU B 208      23.523  46.590  21.913  1.00 31.72           O  
ATOM   7546  OE2 GLU B 208      22.219  48.354  21.751  1.00 26.78           O  
ATOM   7547  N   ALA B 209      23.273  43.430  26.531  1.00 25.19           N  
ATOM   7548  CA  ALA B 209      23.721  42.116  26.985  1.00 25.86           C  
ATOM   7549  C   ALA B 209      23.108  41.668  28.324  1.00 25.72           C  
ATOM   7550  O   ALA B 209      23.547  40.678  28.878  1.00 26.65           O  
ATOM   7551  CB  ALA B 209      25.276  42.114  27.091  1.00 25.79           C  
ATOM   7552  N   ASN B 210      22.132  42.410  28.853  1.00 26.24           N  
ATOM   7553  CA  ASN B 210      21.505  42.120  30.155  1.00 26.58           C  
ATOM   7554  C   ASN B 210      22.534  42.096  31.313  1.00 26.66           C  
ATOM   7555  O   ASN B 210      22.452  41.288  32.240  1.00 26.63           O  
ATOM   7556  CB  ASN B 210      20.660  40.831  30.110  0.50 26.67           C  
ATOM   7558  CG  ASN B 210      19.465  40.947  29.179  0.50 26.79           C  
ATOM   7560  OD1 ASN B 210      19.596  41.358  28.033  0.50 25.82           O  
ATOM   7562  ND2 ASN B 210      18.291  40.561  29.669  0.50 29.27           N  
ATOM   7564  N   ILE B 211      23.495  43.018  31.261  1.00 25.42           N  
ATOM   7565  CA  ILE B 211      24.439  43.212  32.363  1.00 25.42           C  
ATOM   7566  C   ILE B 211      24.050  44.459  33.141  1.00 25.33           C  
ATOM   7567  O   ILE B 211      23.904  45.507  32.561  1.00 27.05           O  
ATOM   7568  CB  ILE B 211      25.881  43.385  31.852  1.00 25.07           C  
ATOM   7569  CG1 ILE B 211      26.330  42.121  31.118  1.00 24.82           C  
ATOM   7570  CG2 ILE B 211      26.824  43.749  33.037  1.00 24.40           C  
ATOM   7571  CD1 ILE B 211      27.434  42.339  30.178  1.00 26.71           C  
ATOM   7572  N   GLU B 212      23.897  44.348  34.449  1.00 25.91           N  
ATOM   7573  CA  GLU B 212      23.594  45.515  35.290  1.00 26.79           C  
ATOM   7574  C   GLU B 212      24.776  46.462  35.383  1.00 27.12           C  
ATOM   7575  O   GLU B 212      25.922  46.019  35.531  1.00 27.04           O  
ATOM   7576  CB  GLU B 212      23.147  45.093  36.697  0.50 26.97           C  
ATOM   7578  CG  GLU B 212      21.969  44.126  36.702  0.50 29.12           C  
ATOM   7580  CD  GLU B 212      21.249  44.055  38.039  0.50 30.32           C  
ATOM   7582  OE1 GLU B 212      19.997  44.043  38.030  0.50 32.65           O  
ATOM   7584  OE2 GLU B 212      21.923  44.003  39.093  0.50 31.51           O  
ATOM   7586  N   PHE B 213      24.478  47.757  35.286  1.00 26.77           N  
ATOM   7587  CA  PHE B 213      25.446  48.814  35.465  1.00 26.40           C  
ATOM   7588  C   PHE B 213      25.799  48.944  36.933  1.00 26.41           C  
ATOM   7589  O   PHE B 213      24.948  48.888  37.798  1.00 25.41           O  
ATOM   7590  CB  PHE B 213      24.892  50.152  34.937  1.00 26.56           C  
ATOM   7591  CG  PHE B 213      25.710  51.351  35.320  1.00 25.77           C  
ATOM   7592  CD1 PHE B 213      26.979  51.550  34.786  1.00 26.17           C  
ATOM   7593  CD2 PHE B 213      25.213  52.287  36.203  1.00 27.23           C  
ATOM   7594  CE1 PHE B 213      27.734  52.643  35.142  1.00 26.22           C  
ATOM   7595  CE2 PHE B 213      25.961  53.379  36.567  1.00 26.71           C  
ATOM   7596  CZ  PHE B 213      27.229  53.570  36.024  1.00 26.62           C  
ATOM   7597  N   ASP B 214      27.077  49.143  37.204  1.00 26.00           N  
ATOM   7598  CA  ASP B 214      27.572  49.261  38.561  1.00 25.68           C  
ATOM   7599  C   ASP B 214      28.542  50.433  38.558  1.00 26.14           C  
ATOM   7600  O   ASP B 214      29.598  50.346  37.918  1.00 25.65           O  
ATOM   7601  CB  ASP B 214      28.292  47.969  38.944  1.00 25.36           C  
ATOM   7602  CG  ASP B 214      28.845  47.997  40.357  1.00 25.73           C  
ATOM   7603  OD1 ASP B 214      28.707  49.022  41.090  1.00 23.42           O  
ATOM   7604  OD2 ASP B 214      29.425  46.965  40.742  1.00 29.44           O  
ATOM   7605  N   GLU B 215      28.176  51.526  39.228  1.00 25.69           N  
ATOM   7606  CA  GLU B 215      29.029  52.705  39.257  1.00 27.08           C  
ATOM   7607  C   GLU B 215      30.406  52.385  39.871  1.00 26.65           C  
ATOM   7608  O   GLU B 215      31.383  53.102  39.629  1.00 27.90           O  
ATOM   7609  CB  GLU B 215      28.351  53.873  39.987  0.50 26.94           C  
ATOM   7611  CG  GLU B 215      28.099  53.642  41.461  0.50 26.96           C  
ATOM   7613  CD  GLU B 215      27.719  54.918  42.201  0.50 27.74           C  
ATOM   7615  OE1 GLU B 215      27.018  54.814  43.232  0.50 27.41           O  
ATOM   7617  OE2 GLU B 215      28.125  56.021  41.757  0.50 29.21           O  
ATOM   7619  N   ASN B 216      30.499  51.302  40.640  1.00 26.08           N  
ATOM   7620  CA  ASN B 216      31.777  50.940  41.268  1.00 25.78           C  
ATOM   7621  C   ASN B 216      32.820  50.326  40.327  1.00 24.64           C  
ATOM   7622  O   ASN B 216      33.981  50.126  40.728  1.00 23.67           O  
ATOM   7623  CB  ASN B 216      31.535  50.071  42.490  1.00 26.81           C  
ATOM   7624  CG  ASN B 216      30.855  50.842  43.614  1.00 29.86           C  
ATOM   7625  OD1 ASN B 216      30.144  50.266  44.439  1.00 35.80           O  
ATOM   7626  ND2 ASN B 216      31.056  52.158  43.638  1.00 33.61           N  
ATOM   7627  N   LEU B 217      32.425  50.057  39.075  1.00 22.01           N  
ATOM   7628  CA  LEU B 217      33.374  49.658  38.036  1.00 21.38           C  
ATOM   7629  C   LEU B 217      33.738  50.805  37.077  1.00 20.80           C  
ATOM   7630  O   LEU B 217      34.324  50.566  36.022  1.00 18.95           O  
ATOM   7631  CB  LEU B 217      32.863  48.434  37.269  1.00 20.99           C  
ATOM   7632  CG  LEU B 217      32.691  47.122  38.059  1.00 22.54           C  
ATOM   7633  CD1 LEU B 217      32.154  46.026  37.104  1.00 24.81           C  
ATOM   7634  CD2 LEU B 217      33.966  46.664  38.697  1.00 24.25           C  
ATOM   7635  N   VAL B 218      33.387  52.041  37.453  1.00 20.66           N  
ATOM   7636  CA  VAL B 218      33.787  53.232  36.726  1.00 20.28           C  
ATOM   7637  C   VAL B 218      34.780  53.994  37.601  1.00 20.78           C  
ATOM   7638  O   VAL B 218      34.564  54.219  38.804  1.00 20.40           O  
ATOM   7639  CB  VAL B 218      32.587  54.114  36.319  1.00 21.12           C  
ATOM   7640  CG1 VAL B 218      33.073  55.377  35.590  1.00 20.46           C  
ATOM   7641  CG2 VAL B 218      31.628  53.313  35.454  1.00 19.60           C  
ATOM   7642  N   PHE B 219      35.910  54.296  36.993  1.00 20.01           N  
ATOM   7643  CA  PHE B 219      37.042  54.888  37.684  1.00 20.97           C  
ATOM   7644  C   PHE B 219      37.344  56.223  37.013  1.00 21.94           C  
ATOM   7645  O   PHE B 219      37.874  56.253  35.902  1.00 20.68           O  
ATOM   7646  CB  PHE B 219      38.226  53.924  37.618  1.00 20.01           C  
ATOM   7647  CG  PHE B 219      37.981  52.633  38.348  1.00 20.14           C  
ATOM   7648  CD1 PHE B 219      38.322  52.494  39.692  1.00 20.82           C  
ATOM   7649  CD2 PHE B 219      37.345  51.558  37.716  1.00 19.74           C  
ATOM   7650  CE1 PHE B 219      38.061  51.301  40.380  1.00 21.85           C  
ATOM   7651  CE2 PHE B 219      37.072  50.374  38.401  1.00 18.96           C  
ATOM   7652  CZ  PHE B 219      37.438  50.239  39.732  1.00 21.50           C  
ATOM   7653  N   GLU B 220      36.958  57.319  37.682  1.00 23.13           N  
ATOM   7654  CA  GLU B 220      37.159  58.677  37.179  1.00 24.70           C  
ATOM   7655  C   GLU B 220      38.471  59.363  37.605  1.00 24.73           C  
ATOM   7656  O   GLU B 220      39.086  59.028  38.621  1.00 24.32           O  
ATOM   7657  CB  GLU B 220      36.033  59.590  37.682  1.00 25.88           C  
ATOM   7658  CG  GLU B 220      34.649  59.309  37.143  1.00 29.88           C  
ATOM   7659  CD  GLU B 220      33.680  60.328  37.709  1.00 35.07           C  
ATOM   7660  OE1 GLU B 220      33.890  61.550  37.450  1.00 36.46           O  
ATOM   7661  OE2 GLU B 220      32.750  59.917  38.433  1.00 38.20           O  
ATOM   7662  N   GLY B 221      38.867  60.359  36.830  1.00 25.65           N  
ATOM   7663  CA  GLY B 221      39.993  61.247  37.178  1.00 25.93           C  
ATOM   7664  C   GLY B 221      41.389  60.745  36.852  1.00 25.89           C  
ATOM   7665  O   GLY B 221      42.380  61.141  37.493  1.00 26.94           O  
ATOM   7666  N   ASN B 222      41.470  59.886  35.841  1.00 24.98           N  
ATOM   7667  CA  ASN B 222      42.688  59.158  35.507  1.00 24.72           C  
ATOM   7668  C   ASN B 222      43.288  59.629  34.214  1.00 24.07           C  
ATOM   7669  O   ASN B 222      42.642  59.538  33.178  1.00 25.51           O  
ATOM   7670  CB  ASN B 222      42.376  57.673  35.419  1.00 24.63           C  
ATOM   7671  CG  ASN B 222      42.018  57.117  36.752  1.00 25.70           C  
ATOM   7672  OD1 ASN B 222      42.862  57.095  37.656  1.00 25.13           O  
ATOM   7673  ND2 ASN B 222      40.754  56.715  36.921  1.00 25.53           N  
ATOM   7674  N   TYR B 223      44.516  60.143  34.301  1.00 24.18           N  
ATOM   7675  CA  TYR B 223      45.185  60.793  33.169  1.00 24.11           C  
ATOM   7676  C   TYR B 223      46.599  60.290  32.856  1.00 22.76           C  
ATOM   7677  O   TYR B 223      47.025  60.390  31.701  1.00 22.02           O  
ATOM   7678  CB  TYR B 223      45.214  62.313  33.394  1.00 25.78           C  
ATOM   7679  CG  TYR B 223      43.843  62.986  33.380  1.00 27.16           C  
ATOM   7680  CD1 TYR B 223      43.209  63.282  32.176  1.00 29.17           C  
ATOM   7681  CD2 TYR B 223      43.183  63.315  34.567  1.00 25.62           C  
ATOM   7682  CE1 TYR B 223      41.961  63.890  32.144  1.00 28.98           C  
ATOM   7683  CE2 TYR B 223      41.922  63.898  34.539  1.00 26.37           C  
ATOM   7684  CZ  TYR B 223      41.324  64.202  33.324  1.00 28.62           C  
ATOM   7685  OH  TYR B 223      40.071  64.814  33.268  1.00 29.06           O  
ATOM   7686  N   SER B 224      47.284  59.716  33.847  1.00 20.96           N  
ATOM   7687  CA  SER B 224      48.692  59.375  33.760  1.00 20.40           C  
ATOM   7688  C   SER B 224      48.995  57.865  33.796  1.00 20.10           C  
ATOM   7689  O   SER B 224      48.182  57.035  34.260  1.00 18.51           O  
ATOM   7690  CB  SER B 224      49.445  60.086  34.892  1.00 19.94           C  
ATOM   7691  OG  SER B 224      49.275  59.457  36.152  1.00 17.89           O  
ATOM   7692  N   TYR B 225      50.175  57.525  33.276  1.00 19.04           N  
ATOM   7693  CA  TYR B 225      50.736  56.169  33.376  1.00 18.92           C  
ATOM   7694  C   TYR B 225      50.779  55.662  34.838  1.00 19.36           C  
ATOM   7695  O   TYR B 225      50.317  54.553  35.126  1.00 18.90           O  
ATOM   7696  CB  TYR B 225      52.173  56.171  32.791  1.00 18.84           C  
ATOM   7697  CG  TYR B 225      52.917  54.871  32.876  1.00 16.04           C  
ATOM   7698  CD1 TYR B 225      52.618  53.804  32.022  1.00 19.53           C  
ATOM   7699  CD2 TYR B 225      53.969  54.707  33.782  1.00 18.05           C  
ATOM   7700  CE1 TYR B 225      53.335  52.598  32.109  1.00 15.86           C  
ATOM   7701  CE2 TYR B 225      54.676  53.517  33.859  1.00 19.34           C  
ATOM   7702  CZ  TYR B 225      54.341  52.468  33.023  1.00 15.55           C  
ATOM   7703  OH  TYR B 225      55.070  51.301  33.136  1.00 17.15           O  
ATOM   7704  N   GLU B 226      51.237  56.507  35.758  1.00 18.25           N  
ATOM   7705  CA  GLU B 226      51.301  56.118  37.190  1.00 19.01           C  
ATOM   7706  C   GLU B 226      49.902  55.879  37.790  1.00 18.38           C  
ATOM   7707  O   GLU B 226      49.709  54.982  38.593  1.00 17.85           O  
ATOM   7708  CB  GLU B 226      52.081  57.096  38.067  0.50 19.31           C  
ATOM   7710  CG  GLU B 226      53.610  56.950  38.004  0.50 22.28           C  
ATOM   7712  CD  GLU B 226      54.136  55.575  38.412  0.50 25.66           C  
ATOM   7714  OE1 GLU B 226      53.547  54.889  39.292  0.50 24.13           O  
ATOM   7716  OE2 GLU B 226      55.173  55.179  37.842  0.50 28.56           O  
ATOM   7718  N   GLN B 227      48.908  56.630  37.349  1.00 17.74           N  
ATOM   7719  CA  GLN B 227      47.555  56.406  37.826  1.00 18.00           C  
ATOM   7720  C   GLN B 227      47.034  55.055  37.334  1.00 18.43           C  
ATOM   7721  O   GLN B 227      46.368  54.328  38.091  1.00 18.32           O  
ATOM   7722  CB  GLN B 227      46.627  57.541  37.388  1.00 18.24           C  
ATOM   7723  CG  GLN B 227      46.803  58.815  38.200  1.00 20.17           C  
ATOM   7724  CD  GLN B 227      45.932  59.959  37.671  1.00 20.34           C  
ATOM   7725  OE1 GLN B 227      45.997  60.319  36.492  1.00 21.05           O  
ATOM   7726  NE2 GLN B 227      45.065  60.480  38.525  1.00 26.92           N  
ATOM   7727  N   GLY B 228      47.306  54.735  36.069  1.00 17.61           N  
ATOM   7728  CA  GLY B 228      46.916  53.447  35.458  1.00 17.37           C  
ATOM   7729  C   GLY B 228      47.493  52.283  36.231  1.00 17.12           C  
ATOM   7730  O   GLY B 228      46.773  51.334  36.551  1.00 17.45           O  
ATOM   7731  N   LYS B 229      48.788  52.344  36.513  1.00 16.82           N  
ATOM   7732  CA  LYS B 229      49.471  51.317  37.304  1.00 18.75           C  
ATOM   7733  C   LYS B 229      48.830  51.069  38.657  1.00 18.57           C  
ATOM   7734  O   LYS B 229      48.666  49.910  39.072  1.00 18.50           O  
ATOM   7735  CB  LYS B 229      50.945  51.689  37.521  1.00 19.48           C  
ATOM   7736  CG  LYS B 229      51.842  51.391  36.326  1.00 21.45           C  
ATOM   7737  CD  LYS B 229      53.356  51.273  36.711  1.00 22.08           C  
ATOM   7738  CE  LYS B 229      53.881  52.573  37.237  1.00 27.21           C  
ATOM   7739  NZ  LYS B 229      55.408  52.562  37.463  1.00 27.30           N  
ATOM   7740  N   ALA B 230      48.472  52.157  39.341  1.00 17.87           N  
ATOM   7741  CA  ALA B 230      47.911  52.080  40.689  1.00 19.43           C  
ATOM   7742  C   ALA B 230      46.462  51.565  40.743  1.00 19.80           C  
ATOM   7743  O   ALA B 230      45.986  51.099  41.796  1.00 20.41           O  
ATOM   7744  CB  ALA B 230      48.026  53.473  41.390  1.00 18.97           C  
ATOM   7745  N   LEU B 231      45.749  51.631  39.615  1.00 19.37           N  
ATOM   7746  CA  LEU B 231      44.404  51.120  39.529  1.00 19.38           C  
ATOM   7747  C   LEU B 231      44.307  49.595  39.463  1.00 19.06           C  
ATOM   7748  O   LEU B 231      43.250  49.038  39.779  1.00 18.85           O  
ATOM   7749  CB  LEU B 231      43.700  51.692  38.272  1.00 19.82           C  
ATOM   7750  CG  LEU B 231      43.150  53.115  38.452  1.00 22.68           C  
ATOM   7751  CD1 LEU B 231      42.537  53.587  37.150  1.00 23.58           C  
ATOM   7752  CD2 LEU B 231      42.112  53.172  39.556  1.00 24.49           C  
ATOM   7753  N   ALA B 232      45.365  48.938  39.001  1.00 17.35           N  
ATOM   7754  CA  ALA B 232      45.309  47.496  38.706  1.00 16.49           C  
ATOM   7755  C   ALA B 232      44.678  46.698  39.864  1.00 16.90           C  
ATOM   7756  O   ALA B 232      43.702  45.979  39.653  1.00 16.86           O  
ATOM   7757  CB  ALA B 232      46.664  46.946  38.342  1.00 17.06           C  
ATOM   7758  N   GLU B 233      45.212  46.849  41.075  1.00 17.88           N  
ATOM   7759  CA  GLU B 233      44.719  46.036  42.181  1.00 18.83           C  
ATOM   7760  C   GLU B 233      43.272  46.406  42.563  1.00 19.04           C  
ATOM   7761  O   GLU B 233      42.497  45.529  43.064  1.00 16.93           O  
ATOM   7762  CB  GLU B 233      45.682  46.092  43.371  1.00 18.94           C  
ATOM   7763  CG  GLU B 233      45.517  44.956  44.340  1.00 20.47           C  
ATOM   7764  CD  GLU B 233      45.935  43.601  43.788  1.00 22.93           C  
ATOM   7765  OE1 GLU B 233      45.358  42.576  44.204  1.00 25.83           O  
ATOM   7766  OE2 GLU B 233      46.848  43.536  42.948  1.00 20.67           O  
ATOM   7767  N   ARG B 234      42.887  47.673  42.295  1.00 18.44           N  
ATOM   7768  CA  ARG B 234      41.533  48.148  42.585  1.00 19.65           C  
ATOM   7769  C   ARG B 234      40.502  47.443  41.704  1.00 18.23           C  
ATOM   7770  O   ARG B 234      39.441  47.113  42.158  1.00 17.49           O  
ATOM   7771  CB  ARG B 234      41.415  49.664  42.408  1.00 19.59           C  
ATOM   7772  CG  ARG B 234      42.392  50.473  43.239  1.00 24.41           C  
ATOM   7773  CD  ARG B 234      42.175  50.276  44.740  1.00 30.84           C  
ATOM   7774  NE  ARG B 234      43.503  50.108  45.314  1.00 37.64           N  
ATOM   7775  CZ  ARG B 234      44.056  48.980  45.736  1.00 38.69           C  
ATOM   7776  NH1 ARG B 234      43.388  47.833  45.799  1.00 41.06           N  
ATOM   7777  NH2 ARG B 234      45.294  49.037  46.163  1.00 41.19           N  
ATOM   7778  N   LEU B 235      40.855  47.224  40.440  1.00 17.73           N  
ATOM   7779  CA  LEU B 235      40.017  46.499  39.502  1.00 17.62           C  
ATOM   7780  C   LEU B 235      39.928  45.014  39.890  1.00 16.92           C  
ATOM   7781  O   LEU B 235      38.853  44.441  39.912  1.00 15.63           O  
ATOM   7782  CB  LEU B 235      40.540  46.669  38.078  1.00 18.63           C  
ATOM   7783  CG  LEU B 235      40.019  47.930  37.324  1.00 19.57           C  
ATOM   7784  CD1 LEU B 235      40.561  49.202  37.888  1.00 21.24           C  
ATOM   7785  CD2 LEU B 235      40.323  47.879  35.849  1.00 20.98           C  
ATOM   7786  N   LEU B 236      41.078  44.405  40.180  1.00 16.85           N  
ATOM   7787  CA  LEU B 236      41.135  42.984  40.570  1.00 16.52           C  
ATOM   7788  C   LEU B 236      40.297  42.728  41.815  1.00 16.59           C  
ATOM   7789  O   LEU B 236      39.536  41.729  41.826  1.00 16.22           O  
ATOM   7790  CB  LEU B 236      42.567  42.478  40.793  1.00 17.26           C  
ATOM   7791  CG  LEU B 236      43.478  42.466  39.541  1.00 18.03           C  
ATOM   7792  CD1 LEU B 236      44.873  42.141  39.862  1.00 19.93           C  
ATOM   7793  CD2 LEU B 236      42.934  41.475  38.506  1.00 18.56           C  
ATOM   7794  N   GLU B 237      40.372  43.627  42.811  1.00 16.25           N  
ATOM   7795  CA  GLU B 237      39.671  43.418  44.069  1.00 18.53           C  
ATOM   7796  C   GLU B 237      38.157  43.461  43.926  1.00 17.96           C  
ATOM   7797  O   GLU B 237      37.435  42.776  44.636  1.00 16.56           O  
ATOM   7798  CB  GLU B 237      40.180  44.335  45.181  1.00 19.69           C  
ATOM   7799  CG  GLU B 237      39.531  45.641  45.454  1.00 23.56           C  
ATOM   7800  CD  GLU B 237      40.450  46.576  46.311  1.00 24.99           C  
ATOM   7801  OE1 GLU B 237      41.276  46.081  47.140  1.00 25.38           O  
ATOM   7802  OE2 GLU B 237      40.367  47.815  46.111  1.00 31.36           O  
ATOM   7803  N   ARG B 238      37.698  44.230  42.949  1.00 18.15           N  
ATOM   7804  CA  ARG B 238      36.283  44.240  42.606  1.00 19.51           C  
ATOM   7805  C   ARG B 238      35.852  43.134  41.623  1.00 19.04           C  
ATOM   7806  O   ARG B 238      34.669  43.058  41.269  1.00 19.79           O  
ATOM   7807  CB  ARG B 238      35.943  45.636  42.091  1.00 19.71           C  
ATOM   7808  CG  ARG B 238      36.215  46.676  43.184  1.00 24.85           C  
ATOM   7809  CD  ARG B 238      35.565  48.031  42.879  1.00 32.26           C  
ATOM   7810  NE  ARG B 238      36.250  49.281  43.301  1.00 36.38           N  
ATOM   7811  CZ  ARG B 238      37.494  49.461  43.808  1.00 37.72           C  
ATOM   7812  NH1 ARG B 238      38.320  48.470  44.133  1.00 37.70           N  
ATOM   7813  NH2 ARG B 238      37.912  50.713  44.054  1.00 36.36           N  
ATOM   7814  N   GLY B 239      36.777  42.265  41.211  1.00 19.34           N  
ATOM   7815  CA  GLY B 239      36.482  41.169  40.270  1.00 18.65           C  
ATOM   7816  C   GLY B 239      36.275  41.560  38.809  1.00 18.79           C  
ATOM   7817  O   GLY B 239      35.732  40.781  38.021  1.00 18.70           O  
ATOM   7818  N   ALA B 240      36.725  42.750  38.420  1.00 18.36           N  
ATOM   7819  CA  ALA B 240      36.741  43.134  37.014  1.00 17.36           C  
ATOM   7820  C   ALA B 240      37.674  42.172  36.266  1.00 17.68           C  
ATOM   7821  O   ALA B 240      38.734  41.791  36.785  1.00 16.67           O  
ATOM   7822  CB  ALA B 240      37.206  44.561  36.856  1.00 16.97           C  
ATOM   7823  N   THR B 241      37.263  41.747  35.070  1.00 17.55           N  
ATOM   7824  CA  THR B 241      38.098  40.880  34.229  1.00 18.02           C  
ATOM   7825  C   THR B 241      38.542  41.543  32.937  1.00 18.18           C  
ATOM   7826  O   THR B 241      39.222  40.909  32.134  1.00 18.63           O  
ATOM   7827  CB  THR B 241      37.391  39.560  33.867  1.00 18.58           C  
ATOM   7828  OG1 THR B 241      36.166  39.858  33.153  1.00 18.22           O  
ATOM   7829  CG2 THR B 241      37.121  38.730  35.143  1.00 20.21           C  
ATOM   7830  N   SER B 242      38.167  42.803  32.749  1.00 17.96           N  
ATOM   7831  CA  SER B 242      38.565  43.573  31.591  1.00 18.35           C  
ATOM   7832  C   SER B 242      38.303  45.050  31.854  1.00 17.78           C  
ATOM   7833  O   SER B 242      37.617  45.413  32.820  1.00 17.37           O  
ATOM   7834  CB  SER B 242      37.819  43.103  30.361  1.00 18.28           C  
ATOM   7835  OG  SER B 242      36.409  43.248  30.540  1.00 18.54           O  
ATOM   7836  N   ALA B 243      38.855  45.895  30.990  1.00 17.62           N  
ATOM   7837  CA  ALA B 243      38.654  47.320  31.068  1.00 17.45           C  
ATOM   7838  C   ALA B 243      38.756  48.002  29.705  1.00 17.55           C  
ATOM   7839  O   ALA B 243      39.614  47.642  28.888  1.00 18.91           O  
ATOM   7840  CB  ALA B 243      39.682  47.907  31.991  1.00 16.06           C  
ATOM   7841  N   VAL B 244      37.911  49.011  29.525  1.00 18.50           N  
ATOM   7842  CA  VAL B 244      38.020  50.023  28.451  1.00 18.94           C  
ATOM   7843  C   VAL B 244      38.597  51.273  29.107  1.00 19.13           C  
ATOM   7844  O   VAL B 244      38.143  51.687  30.182  1.00 18.57           O  
ATOM   7845  CB  VAL B 244      36.670  50.374  27.842  1.00 18.83           C  
ATOM   7846  CG1 VAL B 244      36.857  51.345  26.631  1.00 20.39           C  
ATOM   7847  CG2 VAL B 244      35.917  49.089  27.474  1.00 20.09           C  
ATOM   7848  N   VAL B 245      39.643  51.824  28.489  1.00 19.39           N  
ATOM   7849  CA  VAL B 245      40.411  52.904  29.070  1.00 19.53           C  
ATOM   7850  C   VAL B 245      40.505  54.078  28.069  1.00 20.47           C  
ATOM   7851  O   VAL B 245      40.841  53.887  26.885  1.00 20.51           O  
ATOM   7852  CB  VAL B 245      41.822  52.411  29.473  1.00 19.91           C  
ATOM   7853  CG1 VAL B 245      42.519  53.521  30.242  1.00 18.79           C  
ATOM   7854  CG2 VAL B 245      41.748  51.077  30.298  1.00 20.93           C  
ATOM   7855  N   SER B 246      40.117  55.270  28.494  1.00 20.24           N  
ATOM   7856  CA  SER B 246      40.021  56.344  27.531  1.00 20.71           C  
ATOM   7857  C   SER B 246      41.386  56.911  27.087  1.00 20.36           C  
ATOM   7858  O   SER B 246      41.500  57.353  25.952  1.00 20.48           O  
ATOM   7859  CB  SER B 246      39.120  57.467  28.040  1.00 21.55           C  
ATOM   7860  OG  SER B 246      39.699  58.055  29.158  1.00 21.34           O  
ATOM   7861  N   HIS B 247      42.377  56.923  27.968  1.00 19.96           N  
ATOM   7862  CA  HIS B 247      43.696  57.510  27.641  1.00 20.85           C  
ATOM   7863  C   HIS B 247      44.758  56.437  27.516  1.00 19.81           C  
ATOM   7864  O   HIS B 247      44.864  55.569  28.347  1.00 17.32           O  
ATOM   7865  CB  HIS B 247      44.110  58.539  28.677  1.00 22.91           C  
ATOM   7866  CG  HIS B 247      43.175  59.690  28.764  1.00 27.61           C  
ATOM   7867  ND1 HIS B 247      42.601  60.094  29.950  1.00 32.95           N  
ATOM   7868  CD2 HIS B 247      42.636  60.472  27.794  1.00 32.37           C  
ATOM   7869  CE1 HIS B 247      41.784  61.103  29.716  1.00 32.83           C  
ATOM   7870  NE2 HIS B 247      41.779  61.345  28.417  1.00 33.51           N  
ATOM   7871  N   ASP B 248      45.549  56.510  26.450  1.00 18.53           N  
ATOM   7872  CA  ASP B 248      46.573  55.505  26.188  1.00 17.58           C  
ATOM   7873  C   ASP B 248      47.602  55.373  27.313  1.00 16.26           C  
ATOM   7874  O   ASP B 248      48.012  54.268  27.626  1.00 14.52           O  
ATOM   7875  CB  ASP B 248      47.330  55.844  24.880  1.00 17.94           C  
ATOM   7876  CG  ASP B 248      46.460  55.737  23.632  1.00 19.11           C  
ATOM   7877  OD1 ASP B 248      45.509  54.902  23.540  1.00 19.30           O  
ATOM   7878  OD2 ASP B 248      46.734  56.548  22.715  1.00 20.74           O  
ATOM   7879  N   THR B 249      48.052  56.485  27.893  1.00 16.36           N  
ATOM   7880  CA  THR B 249      49.054  56.440  28.954  1.00 17.39           C  
ATOM   7881  C   THR B 249      48.539  55.654  30.165  1.00 16.42           C  
ATOM   7882  O   THR B 249      49.264  54.874  30.752  1.00 16.13           O  
ATOM   7883  CB  THR B 249      49.445  57.831  29.450  1.00 18.17           C  
ATOM   7884  OG1 THR B 249      48.243  58.604  29.619  1.00 21.82           O  
ATOM   7885  CG2 THR B 249      50.392  58.519  28.478  1.00 21.29           C  
ATOM   7886  N   VAL B 250      47.276  55.863  30.498  1.00 16.43           N  
ATOM   7887  CA  VAL B 250      46.607  55.109  31.563  1.00 16.26           C  
ATOM   7888  C   VAL B 250      46.509  53.590  31.260  1.00 15.81           C  
ATOM   7889  O   VAL B 250      46.762  52.753  32.117  1.00 15.30           O  
ATOM   7890  CB  VAL B 250      45.234  55.726  31.871  1.00 16.33           C  
ATOM   7891  CG1 VAL B 250      44.551  54.963  33.007  1.00 16.47           C  
ATOM   7892  CG2 VAL B 250      45.366  57.236  32.193  1.00 17.19           C  
ATOM   7893  N   ALA B 251      46.124  53.252  30.036  1.00 15.06           N  
ATOM   7894  CA  ALA B 251      46.009  51.863  29.573  1.00 14.87           C  
ATOM   7895  C   ALA B 251      47.314  51.135  29.628  1.00 15.63           C  
ATOM   7896  O   ALA B 251      47.333  49.969  29.992  1.00 15.54           O  
ATOM   7897  CB  ALA B 251      45.478  51.793  28.156  1.00 14.54           C  
ATOM   7898  N   VAL B 252      48.376  51.818  29.189  1.00 15.87           N  
ATOM   7899  CA  VAL B 252      49.706  51.249  29.202  1.00 16.92           C  
ATOM   7900  C   VAL B 252      50.156  51.001  30.649  1.00 16.41           C  
ATOM   7901  O   VAL B 252      50.792  49.972  30.922  1.00 17.00           O  
ATOM   7902  CB  VAL B 252      50.737  52.114  28.439  1.00 17.36           C  
ATOM   7903  CG1 VAL B 252      52.130  51.536  28.539  1.00 18.31           C  
ATOM   7904  CG2 VAL B 252      50.367  52.239  26.958  1.00 18.84           C  
ATOM   7905  N   GLY B 253      49.827  51.928  31.558  1.00 15.73           N  
ATOM   7906  CA  GLY B 253      50.055  51.740  32.986  1.00 16.19           C  
ATOM   7907  C   GLY B 253      49.325  50.558  33.602  1.00 15.71           C  
ATOM   7908  O   GLY B 253      49.934  49.775  34.348  1.00 17.31           O  
ATOM   7909  N   LEU B 254      48.045  50.403  33.268  1.00 16.47           N  
ATOM   7910  CA  LEU B 254      47.222  49.261  33.697  1.00 16.81           C  
ATOM   7911  C   LEU B 254      47.816  47.945  33.205  1.00 16.44           C  
ATOM   7912  O   LEU B 254      47.984  47.003  33.994  1.00 15.49           O  
ATOM   7913  CB  LEU B 254      45.766  49.397  33.185  1.00 17.20           C  
ATOM   7914  CG  LEU B 254      44.785  48.352  33.733  1.00 16.80           C  
ATOM   7915  CD1 LEU B 254      44.595  48.597  35.202  1.00 16.34           C  
ATOM   7916  CD2 LEU B 254      43.463  48.371  33.007  1.00 16.88           C  
ATOM   7917  N   LEU B 255      48.218  47.912  31.938  1.00 15.91           N  
ATOM   7918  CA  LEU B 255      48.852  46.708  31.356  1.00 16.41           C  
ATOM   7919  C   LEU B 255      50.175  46.373  32.039  1.00 15.25           C  
ATOM   7920  O   LEU B 255      50.392  45.213  32.410  1.00 14.68           O  
ATOM   7921  CB  LEU B 255      49.050  46.853  29.833  1.00 15.51           C  
ATOM   7922  CG  LEU B 255      49.683  45.679  29.066  1.00 17.85           C  
ATOM   7923  CD1 LEU B 255      48.870  44.438  29.248  1.00 18.29           C  
ATOM   7924  CD2 LEU B 255      49.804  46.007  27.601  1.00 17.46           C  
ATOM   7925  N   SER B 256      51.031  47.372  32.248  1.00 15.52           N  
ATOM   7926  CA  SER B 256      52.293  47.204  32.937  1.00 14.64           C  
ATOM   7927  C   SER B 256      52.090  46.540  34.291  1.00 15.51           C  
ATOM   7928  O   SER B 256      52.838  45.628  34.681  1.00 15.15           O  
ATOM   7929  CB  SER B 256      53.052  48.556  33.159  1.00 15.13           C  
ATOM   7930  OG  SER B 256      53.700  49.003  31.968  1.00 17.90           O  
ATOM   7931  N   ALA B 257      51.130  47.051  35.029  1.00 15.59           N  
ATOM   7932  CA  ALA B 257      50.871  46.525  36.384  1.00 16.54           C  
ATOM   7933  C   ALA B 257      50.299  45.099  36.384  1.00 15.21           C  
ATOM   7934  O   ALA B 257      50.726  44.270  37.200  1.00 15.44           O  
ATOM   7935  CB  ALA B 257      49.994  47.494  37.144  1.00 17.94           C  
ATOM   7936  N   MET B 258      49.358  44.797  35.482  1.00 15.12           N  
ATOM   7937  CA  MET B 258      48.855  43.435  35.310  1.00 15.73           C  
ATOM   7938  C   MET B 258      49.995  42.474  35.010  1.00 15.19           C  
ATOM   7939  O   MET B 258      50.124  41.438  35.660  1.00 14.22           O  
ATOM   7940  CB  MET B 258      47.783  43.363  34.217  1.00 15.41           C  
ATOM   7941  CG  MET B 258      46.498  44.134  34.548  1.00 16.20           C  
ATOM   7942  SD  MET B 258      45.743  43.504  36.075  1.00 17.95           S  
ATOM   7943  CE  MET B 258      44.319  44.594  36.161  1.00 18.12           C  
ATOM   7944  N   MET B 259      50.869  42.842  34.067  1.00 15.00           N  
ATOM   7945  CA  MET B 259      52.036  42.009  33.757  1.00 14.17           C  
ATOM   7946  C   MET B 259      53.046  41.865  34.933  1.00 14.62           C  
ATOM   7947  O   MET B 259      53.567  40.777  35.173  1.00 12.64           O  
ATOM   7948  CB  MET B 259      52.752  42.495  32.496  1.00 14.89           C  
ATOM   7949  CG  MET B 259      51.911  42.576  31.226  1.00 15.38           C  
ATOM   7950  SD  MET B 259      51.171  40.954  30.758  1.00 18.67           S  
ATOM   7951  CE  MET B 259      52.610  39.999  30.430  1.00 16.80           C  
ATOM   7952  N   ASP B 260      53.271  42.952  35.677  1.00 14.46           N  
ATOM   7953  CA  ASP B 260      54.162  42.955  36.859  1.00 15.31           C  
ATOM   7954  C   ASP B 260      53.685  41.963  37.957  1.00 15.77           C  
ATOM   7955  O   ASP B 260      54.513  41.309  38.617  1.00 16.96           O  
ATOM   7956  CB  ASP B 260      54.231  44.409  37.370  1.00 16.58           C  
ATOM   7957  CG  ASP B 260      55.293  44.634  38.464  1.00 18.83           C  
ATOM   7958  OD1 ASP B 260      54.953  45.275  39.489  1.00 22.25           O  
ATOM   7959  OD2 ASP B 260      56.398  44.130  38.314  1.00 18.32           O  
ATOM   7960  N   LYS B 261      52.370  41.805  38.054  1.00 15.51           N  
ATOM   7961  CA  LYS B 261      51.679  40.952  39.036  1.00 16.48           C  
ATOM   7962  C   LYS B 261      51.453  39.497  38.567  1.00 17.27           C  
ATOM   7963  O   LYS B 261      50.911  38.663  39.344  1.00 15.73           O  
ATOM   7964  CB  LYS B 261      50.325  41.593  39.349  1.00 16.12           C  
ATOM   7965  CG  LYS B 261      50.404  42.915  40.078  1.00 16.78           C  
ATOM   7966  CD  LYS B 261      49.076  43.718  40.104  1.00 17.14           C  
ATOM   7967  CE  LYS B 261      49.338  44.975  40.973  1.00 18.08           C  
ATOM   7968  NZ  LYS B 261      49.278  44.622  42.417  1.00 16.16           N  
ATOM   7969  N   GLY B 262      51.838  39.190  37.317  1.00 17.96           N  
ATOM   7970  CA  GLY B 262      51.663  37.840  36.750  1.00 17.99           C  
ATOM   7971  C   GLY B 262      50.241  37.461  36.368  1.00 17.92           C  
ATOM   7972  O   GLY B 262      49.905  36.293  36.294  1.00 17.84           O  
ATOM   7973  N   VAL B 263      49.394  38.450  36.170  1.00 18.10           N  
ATOM   7974  CA  VAL B 263      48.042  38.254  35.692  1.00 18.74           C  
ATOM   7975  C   VAL B 263      48.125  37.876  34.221  1.00 18.30           C  
ATOM   7976  O   VAL B 263      48.904  38.457  33.489  1.00 17.38           O  
ATOM   7977  CB  VAL B 263      47.201  39.540  35.905  1.00 19.32           C  
ATOM   7978  CG1 VAL B 263      45.856  39.449  35.173  1.00 20.05           C  
ATOM   7979  CG2 VAL B 263      47.004  39.790  37.397  1.00 20.05           C  
ATOM   7980  N   LYS B 264      47.361  36.862  33.801  1.00 18.24           N  
ATOM   7981  CA  LYS B 264      47.461  36.414  32.422  1.00 19.19           C  
ATOM   7982  C   LYS B 264      46.670  37.302  31.485  1.00 18.87           C  
ATOM   7983  O   LYS B 264      45.448  37.437  31.617  1.00 18.87           O  
ATOM   7984  CB  LYS B 264      46.991  34.964  32.286  1.00 19.07           C  
ATOM   7985  CG  LYS B 264      47.808  33.983  33.050  1.00 23.42           C  
ATOM   7986  CD  LYS B 264      47.145  32.623  32.971  1.00 29.57           C  
ATOM   7987  CE  LYS B 264      48.074  31.479  33.300  1.00 33.53           C  
ATOM   7988  NZ  LYS B 264      47.570  30.192  32.683  1.00 36.63           N  
ATOM   7989  N   VAL B 265      47.364  37.892  30.521  1.00 20.04           N  
ATOM   7990  CA  VAL B 265      46.718  38.769  29.546  1.00 19.80           C  
ATOM   7991  C   VAL B 265      46.918  38.124  28.160  1.00 20.45           C  
ATOM   7992  O   VAL B 265      48.052  37.873  27.763  1.00 20.99           O  
ATOM   7993  CB  VAL B 265      47.362  40.226  29.606  1.00 19.35           C  
ATOM   7994  CG1 VAL B 265      46.863  41.140  28.486  1.00 19.04           C  
ATOM   7995  CG2 VAL B 265      47.124  40.896  30.953  1.00 21.51           C  
ATOM   7996  N   PRO B 266      45.834  37.918  27.383  1.00 20.36           N  
ATOM   7997  CA  PRO B 266      44.434  38.269  27.614  1.00 20.60           C  
ATOM   7998  C   PRO B 266      43.554  37.189  28.259  1.00 20.60           C  
ATOM   7999  O   PRO B 266      42.337  37.373  28.341  1.00 21.27           O  
ATOM   8000  CB  PRO B 266      43.929  38.544  26.195  1.00 19.99           C  
ATOM   8001  CG  PRO B 266      44.646  37.555  25.389  1.00 20.68           C  
ATOM   8002  CD  PRO B 266      46.037  37.436  26.005  1.00 20.76           C  
ATOM   8003  N   GLU B 267      44.154  36.092  28.717  1.00 21.26           N  
ATOM   8004  CA  GLU B 267      43.369  34.945  29.197  1.00 21.51           C  
ATOM   8005  C   GLU B 267      42.467  35.265  30.383  1.00 21.41           C  
ATOM   8006  O   GLU B 267      41.288  34.851  30.392  1.00 20.94           O  
ATOM   8007  CB  GLU B 267      44.301  33.783  29.548  1.00 22.85           C  
ATOM   8008  CG  GLU B 267      44.988  33.125  28.321  1.00 26.77           C  
ATOM   8009  CD  GLU B 267      46.255  33.847  27.774  1.00 31.36           C  
ATOM   8010  OE1 GLU B 267      46.788  34.843  28.378  1.00 30.64           O  
ATOM   8011  OE2 GLU B 267      46.718  33.393  26.687  1.00 33.98           O  
ATOM   8012  N   ASP B 268      43.020  35.973  31.377  1.00 19.58           N  
ATOM   8013  CA  ASP B 268      42.317  36.340  32.607  1.00 19.65           C  
ATOM   8014  C   ASP B 268      41.975  37.824  32.732  1.00 18.80           C  
ATOM   8015  O   ASP B 268      41.137  38.213  33.563  1.00 19.13           O  
ATOM   8016  CB  ASP B 268      43.139  35.901  33.823  1.00 19.39           C  
ATOM   8017  CG  ASP B 268      43.249  34.391  33.936  1.00 22.25           C  
ATOM   8018  OD1 ASP B 268      42.383  33.669  33.392  1.00 28.15           O  
ATOM   8019  OD2 ASP B 268      44.186  33.908  34.581  1.00 25.21           O  
ATOM   8020  N   PHE B 269      42.636  38.666  31.943  1.00 18.28           N  
ATOM   8021  CA  PHE B 269      42.367  40.108  31.965  1.00 18.03           C  
ATOM   8022  C   PHE B 269      42.617  40.715  30.575  1.00 18.05           C  
ATOM   8023  O   PHE B 269      43.660  40.459  29.981  1.00 17.36           O  
ATOM   8024  CB  PHE B 269      43.171  40.865  33.033  1.00 18.97           C  
ATOM   8025  CG  PHE B 269      42.528  42.184  33.420  1.00 17.24           C  
ATOM   8026  CD1 PHE B 269      41.657  42.256  34.511  1.00 18.32           C  
ATOM   8027  CD2 PHE B 269      42.740  43.309  32.672  1.00 16.51           C  
ATOM   8028  CE1 PHE B 269      41.023  43.459  34.827  1.00 17.99           C  
ATOM   8029  CE2 PHE B 269      42.084  44.505  32.954  1.00 18.06           C  
ATOM   8030  CZ  PHE B 269      41.242  44.572  34.056  1.00 19.49           C  
ATOM   8031  N   GLU B 270      41.657  41.501  30.096  1.00 17.31           N  
ATOM   8032  CA  GLU B 270      41.714  42.106  28.764  1.00 17.93           C  
ATOM   8033  C   GLU B 270      41.603  43.625  28.871  1.00 16.78           C  
ATOM   8034  O   GLU B 270      40.923  44.138  29.746  1.00 16.73           O  
ATOM   8035  CB  GLU B 270      40.575  41.608  27.893  1.00 18.03           C  
ATOM   8036  CG  GLU B 270      40.514  40.094  27.648  1.00 18.28           C  
ATOM   8037  CD  GLU B 270      39.440  39.723  26.645  1.00 19.38           C  
ATOM   8038  OE1 GLU B 270      39.516  40.142  25.474  1.00 22.30           O  
ATOM   8039  OE2 GLU B 270      38.465  39.033  27.053  1.00 24.59           O  
ATOM   8040  N   ILE B 271      42.311  44.325  27.992  1.00 17.11           N  
ATOM   8041  CA  ILE B 271      42.378  45.787  28.003  1.00 16.76           C  
ATOM   8042  C   ILE B 271      42.184  46.346  26.568  1.00 16.56           C  
ATOM   8043  O   ILE B 271      42.780  45.867  25.609  1.00 16.11           O  
ATOM   8044  CB  ILE B 271      43.733  46.312  28.557  1.00 16.87           C  
ATOM   8045  CG1 ILE B 271      43.977  45.799  29.977  1.00 17.42           C  
ATOM   8046  CG2 ILE B 271      43.768  47.857  28.551  1.00 17.36           C  
ATOM   8047  CD1 ILE B 271      45.373  46.095  30.523  1.00 19.48           C  
ATOM   8048  N   ILE B 272      41.361  47.386  26.464  1.00 16.75           N  
ATOM   8049  CA  ILE B 272      41.215  48.144  25.216  1.00 17.63           C  
ATOM   8050  C   ILE B 272      41.487  49.614  25.552  1.00 16.75           C  
ATOM   8051  O   ILE B 272      40.872  50.169  26.451  1.00 17.87           O  
ATOM   8052  CB  ILE B 272      39.793  47.968  24.582  1.00 17.65           C  
ATOM   8053  CG1 ILE B 272      39.494  46.488  24.335  1.00 18.06           C  
ATOM   8054  CG2 ILE B 272      39.716  48.797  23.245  1.00 18.17           C  
ATOM   8055  CD1 ILE B 272      38.094  46.190  23.778  1.00 19.55           C  
ATOM   8056  N   SER B 273      42.450  50.208  24.867  1.00 17.66           N  
ATOM   8057  CA  SER B 273      42.802  51.614  25.014  1.00 17.90           C  
ATOM   8058  C   SER B 273      41.993  52.558  24.090  1.00 18.88           C  
ATOM   8059  O   SER B 273      41.201  52.133  23.257  1.00 17.87           O  
ATOM   8060  CB  SER B 273      44.319  51.779  24.771  1.00 18.94           C  
ATOM   8061  OG  SER B 273      44.775  53.055  25.212  1.00 19.91           O  
ATOM   8062  N   GLY B 274      42.212  53.851  24.276  1.00 20.42           N  
ATOM   8063  CA  GLY B 274      41.360  54.870  23.729  1.00 21.71           C  
ATOM   8064  C   GLY B 274      41.735  55.594  22.441  1.00 21.07           C  
ATOM   8065  O   GLY B 274      40.831  56.161  21.812  1.00 21.70           O  
ATOM   8066  N   ALA B 275      43.008  55.617  22.036  1.00 21.11           N  
ATOM   8067  CA  ALA B 275      43.420  56.403  20.833  1.00 20.63           C  
ATOM   8068  C   ALA B 275      44.499  55.854  19.884  1.00 19.52           C  
ATOM   8069  O   ALA B 275      44.612  56.315  18.724  1.00 19.81           O  
ATOM   8070  CB  ALA B 275      43.810  57.856  21.257  1.00 21.16           C  
ATOM   8071  N   ASN B 276      45.283  54.883  20.338  1.00 19.52           N  
ATOM   8072  CA  ASN B 276      46.401  54.348  19.570  1.00 19.45           C  
ATOM   8073  C   ASN B 276      47.443  55.419  19.219  1.00 18.53           C  
ATOM   8074  O   ASN B 276      47.925  55.477  18.081  1.00 18.30           O  
ATOM   8075  CB  ASN B 276      45.897  53.705  18.274  1.00 20.02           C  
ATOM   8076  CG  ASN B 276      46.871  52.738  17.697  1.00 21.75           C  
ATOM   8077  OD1 ASN B 276      47.530  52.010  18.435  1.00 25.73           O  
ATOM   8078  ND2 ASN B 276      46.993  52.730  16.376  1.00 22.68           N  
ATOM   8079  N   SER B 277      47.719  56.319  20.160  1.00 19.06           N  
ATOM   8080  CA  SER B 277      48.799  57.289  20.030  1.00 18.99           C  
ATOM   8081  C   SER B 277      50.158  56.591  19.838  1.00 19.06           C  
ATOM   8082  O   SER B 277      50.276  55.374  20.082  1.00 19.12           O  
ATOM   8083  CB  SER B 277      48.814  58.224  21.261  1.00 20.25           C  
ATOM   8084  OG  SER B 277      49.162  57.546  22.455  1.00 20.03           O  
ATOM   8085  N   PRO B 278      51.185  57.349  19.409  1.00 18.39           N  
ATOM   8086  CA  PRO B 278      52.481  56.729  19.142  1.00 18.84           C  
ATOM   8087  C   PRO B 278      53.099  55.824  20.212  1.00 18.89           C  
ATOM   8088  O   PRO B 278      53.676  54.804  19.840  1.00 18.14           O  
ATOM   8089  CB  PRO B 278      53.379  57.917  18.762  1.00 18.73           C  
ATOM   8090  CG  PRO B 278      52.412  58.933  18.209  1.00 19.92           C  
ATOM   8091  CD  PRO B 278      51.160  58.769  18.992  1.00 17.29           C  
ATOM   8092  N   ILE B 279      52.915  56.110  21.502  1.00 18.93           N  
ATOM   8093  CA  ILE B 279      53.475  55.212  22.531  1.00 19.00           C  
ATOM   8094  C   ILE B 279      52.952  53.773  22.514  1.00 19.94           C  
ATOM   8095  O   ILE B 279      53.653  52.871  22.989  1.00 20.59           O  
ATOM   8096  CB  ILE B 279      53.306  55.750  23.986  1.00 19.13           C  
ATOM   8097  CG1 ILE B 279      51.839  56.067  24.343  1.00 19.36           C  
ATOM   8098  CG2 ILE B 279      54.252  56.883  24.207  1.00 18.12           C  
ATOM   8099  CD1 ILE B 279      51.555  56.064  25.870  1.00 19.48           C  
ATOM   8100  N   THR B 280      51.718  53.580  22.029  1.00 20.84           N  
ATOM   8101  CA  THR B 280      51.080  52.253  22.021  1.00 21.91           C  
ATOM   8102  C   THR B 280      51.853  51.235  21.152  1.00 21.88           C  
ATOM   8103  O   THR B 280      51.770  50.033  21.391  1.00 23.00           O  
ATOM   8104  CB  THR B 280      49.591  52.328  21.560  1.00 22.27           C  
ATOM   8105  OG1 THR B 280      49.563  52.597  20.162  1.00 25.06           O  
ATOM   8106  CG2 THR B 280      48.854  53.433  22.298  1.00 23.38           C  
ATOM   8107  N   GLN B 281      52.617  51.698  20.162  1.00 21.92           N  
ATOM   8108  CA  GLN B 281      53.471  50.807  19.369  1.00 22.75           C  
ATOM   8109  C   GLN B 281      54.523  50.061  20.213  1.00 21.86           C  
ATOM   8110  O   GLN B 281      54.956  48.966  19.841  1.00 20.57           O  
ATOM   8111  CB  GLN B 281      54.179  51.568  18.226  1.00 23.62           C  
ATOM   8112  CG  GLN B 281      55.147  50.686  17.393  1.00 25.81           C  
ATOM   8113  CD  GLN B 281      55.790  51.406  16.215  1.00 26.60           C  
ATOM   8114  OE1 GLN B 281      56.182  52.563  16.333  1.00 31.05           O  
ATOM   8115  NE2 GLN B 281      55.918  50.712  15.076  1.00 30.61           N  
ATOM   8116  N   TYR B 282      54.893  50.643  21.350  1.00 19.96           N  
ATOM   8117  CA  TYR B 282      56.027  50.174  22.128  1.00 20.28           C  
ATOM   8118  C   TYR B 282      55.594  49.317  23.322  1.00 19.89           C  
ATOM   8119  O   TYR B 282      56.395  48.998  24.178  1.00 20.96           O  
ATOM   8120  CB  TYR B 282      56.873  51.376  22.571  1.00 19.28           C  
ATOM   8121  CG  TYR B 282      57.442  52.130  21.384  1.00 18.84           C  
ATOM   8122  CD1 TYR B 282      58.470  51.587  20.634  1.00 19.44           C  
ATOM   8123  CD2 TYR B 282      56.909  53.357  20.993  1.00 19.57           C  
ATOM   8124  CE1 TYR B 282      58.989  52.256  19.546  1.00 20.01           C  
ATOM   8125  CE2 TYR B 282      57.399  54.039  19.900  1.00 20.28           C  
ATOM   8126  CZ  TYR B 282      58.437  53.475  19.170  1.00 19.63           C  
ATOM   8127  OH  TYR B 282      58.918  54.126  18.085  1.00 19.83           O  
ATOM   8128  N   THR B 283      54.333  48.923  23.389  1.00 20.01           N  
ATOM   8129  CA  THR B 283      53.925  48.031  24.469  1.00 19.13           C  
ATOM   8130  C   THR B 283      54.285  46.571  24.153  1.00 18.70           C  
ATOM   8131  O   THR B 283      54.273  46.135  23.003  1.00 19.05           O  
ATOM   8132  CB  THR B 283      52.438  48.154  24.812  1.00 20.19           C  
ATOM   8133  OG1 THR B 283      51.651  47.613  23.743  1.00 20.66           O  
ATOM   8134  CG2 THR B 283      52.083  49.611  25.051  1.00 21.53           C  
ATOM   8135  N   TYR B 284      54.571  45.812  25.196  1.00 17.98           N  
ATOM   8136  CA  TYR B 284      54.603  44.349  25.116  1.00 18.41           C  
ATOM   8137  C   TYR B 284      53.990  43.783  26.377  1.00 18.17           C  
ATOM   8138  O   TYR B 284      54.435  44.108  27.473  1.00 19.00           O  
ATOM   8139  CB  TYR B 284      56.008  43.785  24.920  1.00 19.01           C  
ATOM   8140  CG  TYR B 284      55.951  42.328  24.461  1.00 18.66           C  
ATOM   8141  CD1 TYR B 284      55.886  42.004  23.119  1.00 18.34           C  
ATOM   8142  CD2 TYR B 284      55.891  41.289  25.390  1.00 22.05           C  
ATOM   8143  CE1 TYR B 284      55.795  40.657  22.701  1.00 20.59           C  
ATOM   8144  CE2 TYR B 284      55.797  39.959  24.990  1.00 21.97           C  
ATOM   8145  CZ  TYR B 284      55.743  39.647  23.648  1.00 20.25           C  
ATOM   8146  OH  TYR B 284      55.670  38.327  23.271  1.00 20.92           O  
ATOM   8147  N   PRO B 285      52.933  42.964  26.240  1.00 18.47           N  
ATOM   8148  CA  PRO B 285      52.193  42.598  25.010  1.00 18.49           C  
ATOM   8149  C   PRO B 285      51.597  43.775  24.241  1.00 18.47           C  
ATOM   8150  O   PRO B 285      51.403  44.869  24.795  1.00 19.18           O  
ATOM   8151  CB  PRO B 285      51.046  41.697  25.528  1.00 18.90           C  
ATOM   8152  CG  PRO B 285      51.012  41.843  26.904  1.00 18.51           C  
ATOM   8153  CD  PRO B 285      52.386  42.250  27.397  1.00 18.05           C  
ATOM   8154  N   THR B 286      51.310  43.533  22.973  1.00 17.97           N  
ATOM   8155  CA  THR B 286      50.697  44.539  22.125  1.00 19.42           C  
ATOM   8156  C   THR B 286      49.287  44.902  22.592  1.00 19.19           C  
ATOM   8157  O   THR B 286      48.538  44.066  23.119  1.00 19.24           O  
ATOM   8158  CB  THR B 286      50.698  44.137  20.623  1.00 19.06           C  
ATOM   8159  OG1 THR B 286      49.914  42.961  20.427  1.00 19.74           O  
ATOM   8160  CG2 THR B 286      52.087  43.925  20.124  1.00 20.03           C  
ATOM   8161  N   LEU B 287      48.993  46.184  22.483  1.00 19.63           N  
ATOM   8162  CA  LEU B 287      47.827  46.784  23.107  1.00 19.59           C  
ATOM   8163  C   LEU B 287      46.665  47.039  22.131  1.00 19.08           C  
ATOM   8164  O   LEU B 287      46.756  47.877  21.221  1.00 18.64           O  
ATOM   8165  CB  LEU B 287      48.241  48.103  23.788  0.50 20.15           C  
ATOM   8167  CG  LEU B 287      47.607  48.468  25.137  0.50 21.88           C  
ATOM   8169  CD1 LEU B 287      48.042  49.880  25.561  0.50 22.77           C  
ATOM   8171  CD2 LEU B 287      46.090  48.359  25.158  0.50 23.10           C  
ATOM   8173  N   THR B 288      45.556  46.344  22.334  1.00 17.81           N  
ATOM   8174  CA  THR B 288      44.330  46.619  21.579  1.00 18.27           C  
ATOM   8175  C   THR B 288      43.813  48.045  21.853  1.00 17.69           C  
ATOM   8176  O   THR B 288      43.793  48.501  22.991  1.00 17.36           O  
ATOM   8177  CB  THR B 288      43.228  45.563  21.912  1.00 16.29           C  
ATOM   8178  OG1 THR B 288      43.664  44.277  21.484  1.00 19.06           O  
ATOM   8179  CG2 THR B 288      41.904  45.868  21.217  1.00 18.06           C  
ATOM   8180  N   SER B 289      43.392  48.751  20.809  1.00 17.81           N  
ATOM   8181  CA  SER B 289      42.996  50.162  20.984  1.00 18.50           C  
ATOM   8182  C   SER B 289      41.997  50.633  19.918  1.00 18.94           C  
ATOM   8183  O   SER B 289      42.081  50.233  18.766  1.00 19.45           O  
ATOM   8184  CB  SER B 289      44.249  51.074  20.934  1.00 18.88           C  
ATOM   8185  OG  SER B 289      44.007  52.350  21.471  1.00 20.04           O  
ATOM   8186  N   VAL B 290      41.088  51.517  20.319  1.00 19.83           N  
ATOM   8187  CA  VAL B 290      40.462  52.445  19.381  1.00 19.40           C  
ATOM   8188  C   VAL B 290      41.584  53.264  18.711  1.00 19.70           C  
ATOM   8189  O   VAL B 290      42.469  53.820  19.396  1.00 19.50           O  
ATOM   8190  CB  VAL B 290      39.465  53.399  20.115  1.00 19.58           C  
ATOM   8191  CG1 VAL B 290      38.996  54.558  19.222  1.00 18.86           C  
ATOM   8192  CG2 VAL B 290      38.290  52.607  20.683  1.00 21.09           C  
ATOM   8193  N   ASN B 291      41.578  53.302  17.376  1.00 18.44           N  
ATOM   8194  CA  ASN B 291      42.472  54.166  16.604  1.00 18.25           C  
ATOM   8195  C   ASN B 291      41.767  55.494  16.263  1.00 19.04           C  
ATOM   8196  O   ASN B 291      40.794  55.509  15.480  1.00 18.31           O  
ATOM   8197  CB  ASN B 291      42.927  53.464  15.318  1.00 18.41           C  
ATOM   8198  CG  ASN B 291      44.013  54.245  14.565  1.00 21.11           C  
ATOM   8199  OD1 ASN B 291      45.122  54.436  15.058  1.00 23.66           O  
ATOM   8200  ND2 ASN B 291      43.691  54.690  13.362  1.00 25.09           N  
ATOM   8201  N   GLN B 292      42.241  56.587  16.856  1.00 18.26           N  
ATOM   8202  CA  GLN B 292      41.793  57.925  16.479  1.00 18.95           C  
ATOM   8203  C   GLN B 292      42.760  58.464  15.437  1.00 18.79           C  
ATOM   8204  O   GLN B 292      43.980  58.223  15.525  1.00 19.01           O  
ATOM   8205  CB  GLN B 292      41.756  58.863  17.680  1.00 18.49           C  
ATOM   8206  CG  GLN B 292      40.788  58.426  18.794  1.00 18.46           C  
ATOM   8207  CD  GLN B 292      40.674  59.501  19.883  1.00 19.29           C  
ATOM   8208  OE1 GLN B 292      40.775  60.679  19.593  1.00 21.02           O  
ATOM   8209  NE2 GLN B 292      40.489  59.089  21.128  1.00 17.66           N  
ATOM   8210  N   PRO B 293      42.234  59.198  14.441  1.00 19.20           N  
ATOM   8211  CA  PRO B 293      43.063  59.774  13.372  1.00 19.51           C  
ATOM   8212  C   PRO B 293      43.702  61.082  13.843  1.00 19.84           C  
ATOM   8213  O   PRO B 293      43.299  62.178  13.448  1.00 20.34           O  
ATOM   8214  CB  PRO B 293      42.053  59.946  12.237  1.00 19.46           C  
ATOM   8215  CG  PRO B 293      40.803  60.355  12.990  1.00 18.97           C  
ATOM   8216  CD  PRO B 293      40.807  59.525  14.251  1.00 19.12           C  
ATOM   8217  N   LEU B 294      44.723  60.954  14.698  1.00 19.63           N  
ATOM   8218  CA  LEU B 294      45.269  62.096  15.432  1.00 19.07           C  
ATOM   8219  C   LEU B 294      45.850  63.220  14.543  1.00 18.58           C  
ATOM   8220  O   LEU B 294      45.564  64.387  14.757  1.00 18.17           O  
ATOM   8221  CB  LEU B 294      46.320  61.607  16.408  1.00 20.11           C  
ATOM   8222  CG  LEU B 294      45.866  60.657  17.553  1.00 19.21           C  
ATOM   8223  CD1 LEU B 294      47.058  60.419  18.440  1.00 23.25           C  
ATOM   8224  CD2 LEU B 294      44.722  61.214  18.346  1.00 20.78           C  
ATOM   8225  N   TYR B 295      46.679  62.871  13.571  1.00 18.03           N  
ATOM   8226  CA  TYR B 295      47.162  63.870  12.624  1.00 18.97           C  
ATOM   8227  C   TYR B 295      46.006  64.611  11.932  1.00 19.07           C  
ATOM   8228  O   TYR B 295      46.018  65.824  11.820  1.00 19.06           O  
ATOM   8229  CB  TYR B 295      48.049  63.206  11.574  1.00 20.27           C  
ATOM   8230  CG  TYR B 295      48.618  64.171  10.549  1.00 19.10           C  
ATOM   8231  CD1 TYR B 295      49.834  64.790  10.769  1.00 18.77           C  
ATOM   8232  CD2 TYR B 295      47.945  64.450   9.365  1.00 21.79           C  
ATOM   8233  CE1 TYR B 295      50.372  65.665   9.834  1.00 18.93           C  
ATOM   8234  CE2 TYR B 295      48.473  65.334   8.423  1.00 21.59           C  
ATOM   8235  CZ  TYR B 295      49.691  65.942   8.676  1.00 21.27           C  
ATOM   8236  OH  TYR B 295      50.237  66.813   7.754  1.00 21.66           O  
ATOM   8237  N   ASP B 296      44.998  63.869  11.504  1.00 19.43           N  
ATOM   8238  CA  ASP B 296      43.831  64.447  10.817  1.00 20.55           C  
ATOM   8239  C   ASP B 296      42.975  65.336  11.709  1.00 20.75           C  
ATOM   8240  O   ASP B 296      42.388  66.305  11.254  1.00 20.13           O  
ATOM   8241  CB  ASP B 296      42.979  63.322  10.242  1.00 20.97           C  
ATOM   8242  CG  ASP B 296      43.643  62.619   9.067  1.00 24.84           C  
ATOM   8243  OD1 ASP B 296      44.514  63.242   8.405  1.00 29.07           O  
ATOM   8244  OD2 ASP B 296      43.253  61.470   8.772  1.00 28.11           O  
ATOM   8245  N   LEU B 297      42.886  64.999  12.993  1.00 20.63           N  
ATOM   8246  CA  LEU B 297      42.175  65.848  13.929  1.00 19.67           C  
ATOM   8247  C   LEU B 297      42.768  67.250  13.965  1.00 19.53           C  
ATOM   8248  O   LEU B 297      42.022  68.233  13.938  1.00 19.06           O  
ATOM   8249  CB  LEU B 297      42.193  65.230  15.356  1.00 19.65           C  
ATOM   8250  CG  LEU B 297      41.357  63.991  15.655  1.00 19.35           C  
ATOM   8251  CD1 LEU B 297      41.719  63.430  16.998  1.00 22.14           C  
ATOM   8252  CD2 LEU B 297      39.854  64.302  15.621  1.00 20.11           C  
ATOM   8253  N   GLY B 298      44.106  67.332  14.052  1.00 19.80           N  
ATOM   8254  CA  GLY B 298      44.865  68.599  13.973  1.00 19.97           C  
ATOM   8255  C   GLY B 298      44.756  69.318  12.610  1.00 19.72           C  
ATOM   8256  O   GLY B 298      44.514  70.529  12.554  1.00 19.60           O  
ATOM   8257  N   ALA B 299      44.960  68.581  11.521  1.00 19.38           N  
ATOM   8258  CA  ALA B 299      44.881  69.155  10.174  1.00 19.53           C  
ATOM   8259  C   ALA B 299      43.486  69.705   9.895  1.00 19.77           C  
ATOM   8260  O   ALA B 299      43.330  70.836   9.401  1.00 20.19           O  
ATOM   8261  CB  ALA B 299      45.279  68.126   9.129  1.00 19.07           C  
ATOM   8262  N   VAL B 300      42.462  68.921  10.226  1.00 19.91           N  
ATOM   8263  CA  VAL B 300      41.070  69.322   9.996  1.00 19.53           C  
ATOM   8264  C   VAL B 300      40.743  70.560  10.823  1.00 19.37           C  
ATOM   8265  O   VAL B 300      40.094  71.484  10.324  1.00 18.92           O  
ATOM   8266  CB  VAL B 300      40.068  68.134  10.253  1.00 19.85           C  
ATOM   8267  CG1 VAL B 300      38.643  68.613  10.307  1.00 20.93           C  
ATOM   8268  CG2 VAL B 300      40.223  67.087   9.157  1.00 20.29           C  
ATOM   8269  N   ALA B 301      41.215  70.588  12.074  1.00 19.42           N  
ATOM   8270  CA  ALA B 301      41.016  71.735  12.948  1.00 19.29           C  
ATOM   8271  C   ALA B 301      41.684  72.984  12.403  1.00 19.74           C  
ATOM   8272  O   ALA B 301      41.114  74.088  12.455  1.00 19.82           O  
ATOM   8273  CB  ALA B 301      41.558  71.441  14.321  1.00 20.58           C  
ATOM   8274  N   MET B 302      42.909  72.839  11.904  1.00 19.66           N  
ATOM   8275  CA  MET B 302      43.645  74.015  11.420  1.00 20.07           C  
ATOM   8276  C   MET B 302      43.028  74.553  10.089  1.00 20.81           C  
ATOM   8277  O   MET B 302      42.997  75.772   9.844  1.00 20.43           O  
ATOM   8278  CB  MET B 302      45.148  73.698  11.314  1.00 19.97           C  
ATOM   8279  CG  MET B 302      46.019  74.903  11.061  1.00 19.99           C  
ATOM   8280  SD  MET B 302      45.979  76.209  12.329  1.00 22.22           S  
ATOM   8281  CE  MET B 302      45.470  77.605  11.329  1.00 21.66           C  
ATOM   8282  N   ARG B 303      42.492  73.650   9.271  1.00 21.69           N  
ATOM   8283  CA  ARG B 303      41.753  74.035   8.052  1.00 21.80           C  
ATOM   8284  C   ARG B 303      40.531  74.886   8.393  1.00 22.08           C  
ATOM   8285  O   ARG B 303      40.253  75.897   7.721  1.00 20.69           O  
ATOM   8286  CB  ARG B 303      41.330  72.798   7.248  1.00 22.49           C  
ATOM   8287  CG  ARG B 303      42.436  72.225   6.405  1.00 25.04           C  
ATOM   8288  CD  ARG B 303      41.982  71.022   5.604  1.00 27.89           C  
ATOM   8289  NE  ARG B 303      43.142  70.279   5.118  1.00 28.63           N  
ATOM   8290  CZ  ARG B 303      43.371  68.985   5.310  1.00 31.80           C  
ATOM   8291  NH1 ARG B 303      42.496  68.213   5.969  1.00 33.58           N  
ATOM   8292  NH2 ARG B 303      44.486  68.451   4.810  1.00 31.45           N  
ATOM   8293  N   LEU B 304      39.808  74.473   9.442  1.00 21.23           N  
ATOM   8294  CA  LEU B 304      38.630  75.178   9.896  1.00 21.97           C  
ATOM   8295  C   LEU B 304      39.056  76.553  10.436  1.00 21.06           C  
ATOM   8296  O   LEU B 304      38.509  77.585  10.044  1.00 20.05           O  
ATOM   8297  CB  LEU B 304      37.886  74.346  10.963  1.00 22.46           C  
ATOM   8298  CG  LEU B 304      36.623  74.931  11.614  1.00 24.22           C  
ATOM   8299  CD1 LEU B 304      35.651  75.314  10.582  1.00 27.82           C  
ATOM   8300  CD2 LEU B 304      35.976  73.941  12.560  1.00 24.78           C  
ATOM   8301  N   LEU B 305      40.054  76.566  11.312  1.00 21.12           N  
ATOM   8302  CA  LEU B 305      40.541  77.827  11.882  1.00 21.04           C  
ATOM   8303  C   LEU B 305      41.002  78.832  10.789  1.00 21.37           C  
ATOM   8304  O   LEU B 305      40.809  80.024  10.935  1.00 20.50           O  
ATOM   8305  CB  LEU B 305      41.661  77.593  12.899  1.00 21.32           C  
ATOM   8306  CG  LEU B 305      42.171  78.811  13.708  1.00 20.99           C  
ATOM   8307  CD1 LEU B 305      41.064  79.502  14.549  1.00 21.25           C  
ATOM   8308  CD2 LEU B 305      43.315  78.423  14.607  1.00 22.26           C  
ATOM   8309  N   THR B 306      41.633  78.327   9.731  1.00 20.85           N  
ATOM   8310  CA  THR B 306      42.108  79.133   8.630  1.00 21.32           C  
ATOM   8311  C   THR B 306      40.943  79.921   8.033  1.00 21.63           C  
ATOM   8312  O   THR B 306      41.079  81.124   7.733  1.00 21.40           O  
ATOM   8313  CB  THR B 306      42.817  78.255   7.554  1.00 21.66           C  
ATOM   8314  OG1 THR B 306      43.994  77.690   8.123  1.00 20.39           O  
ATOM   8315  CG2 THR B 306      43.264  79.090   6.338  1.00 21.68           C  
ATOM   8316  N   LYS B 307      39.789  79.268   7.908  1.00 21.37           N  
ATOM   8317  CA  LYS B 307      38.605  79.941   7.361  1.00 21.96           C  
ATOM   8318  C   LYS B 307      38.069  81.008   8.316  1.00 22.21           C  
ATOM   8319  O   LYS B 307      37.725  82.096   7.874  1.00 22.44           O  
ATOM   8320  CB  LYS B 307      37.500  78.925   7.040  1.00 21.40           C  
ATOM   8321  CG  LYS B 307      37.874  77.865   6.029  1.00 21.45           C  
ATOM   8322  CD  LYS B 307      36.839  76.746   6.035  1.00 24.97           C  
ATOM   8323  CE  LYS B 307      37.209  75.612   5.098  1.00 26.03           C  
ATOM   8324  NZ  LYS B 307      36.139  74.579   5.087  1.00 26.47           N  
ATOM   8325  N   LEU B 308      38.024  80.691   9.612  1.00 22.62           N  
ATOM   8326  CA  LEU B 308      37.548  81.626  10.621  1.00 24.06           C  
ATOM   8327  C   LEU B 308      38.398  82.884  10.631  1.00 24.25           C  
ATOM   8328  O   LEU B 308      37.868  84.006  10.688  1.00 24.86           O  
ATOM   8329  CB  LEU B 308      37.502  80.971  12.017  1.00 23.95           C  
ATOM   8330  CG  LEU B 308      36.559  79.746  12.112  1.00 25.74           C  
ATOM   8331  CD1 LEU B 308      36.522  79.192  13.533  1.00 25.66           C  
ATOM   8332  CD2 LEU B 308      35.136  80.077  11.634  1.00 28.19           C  
ATOM   8333  N   MET B 309      39.712  82.712  10.536  1.00 24.45           N  
ATOM   8334  CA  MET B 309      40.628  83.843  10.595  1.00 24.48           C  
ATOM   8335  C   MET B 309      40.548  84.725   9.355  1.00 25.42           C  
ATOM   8336  O   MET B 309      40.914  85.877   9.423  1.00 24.80           O  
ATOM   8337  CB  MET B 309      42.068  83.364  10.798  1.00 24.52           C  
ATOM   8338  CG  MET B 309      42.302  82.675  12.141  1.00 24.39           C  
ATOM   8339  SD  MET B 309      44.051  82.326  12.463  1.00 23.41           S  
ATOM   8340  CE  MET B 309      44.487  81.093  11.219  1.00 26.43           C  
ATOM   8341  N   LEU B 310      40.125  84.155   8.228  1.00 26.20           N  
ATOM   8342  CA  LEU B 310      39.831  84.916   7.011  1.00 27.56           C  
ATOM   8343  C   LEU B 310      38.402  85.506   6.969  1.00 29.32           C  
ATOM   8344  O   LEU B 310      37.985  86.050   5.941  1.00 28.99           O  
ATOM   8345  CB  LEU B 310      40.052  84.030   5.792  1.00 27.38           C  
ATOM   8346  CG  LEU B 310      41.498  83.689   5.444  1.00 27.56           C  
ATOM   8347  CD1 LEU B 310      41.507  82.475   4.507  1.00 28.94           C  
ATOM   8348  CD2 LEU B 310      42.212  84.853   4.838  1.00 26.99           C  
ATOM   8349  N   LYS B 311      37.684  85.405   8.089  1.00 31.46           N  
ATOM   8350  CA  LYS B 311      36.315  85.890   8.254  1.00 33.61           C  
ATOM   8351  C   LYS B 311      35.328  85.136   7.368  1.00 35.29           C  
ATOM   8352  O   LYS B 311      34.246  85.659   7.050  1.00 35.72           O  
ATOM   8353  CB  LYS B 311      36.209  87.406   8.013  1.00 33.64           C  
ATOM   8354  CG  LYS B 311      37.117  88.252   8.890  1.00 33.97           C  
ATOM   8355  CD  LYS B 311      36.690  89.719   8.889  1.00 34.98           C  
ATOM   8356  CE  LYS B 311      37.712  90.598   9.594  1.00 36.84           C  
ATOM   8357  NZ  LYS B 311      37.171  91.973   9.836  1.00 39.38           N  
ATOM   8358  N   GLU B 312      35.689  83.912   6.983  1.00 37.07           N  
ATOM   8359  CA  GLU B 312      34.824  83.074   6.158  1.00 38.72           C  
ATOM   8360  C   GLU B 312      33.806  82.381   7.055  1.00 39.57           C  
ATOM   8361  O   GLU B 312      34.133  81.873   8.143  1.00 40.03           O  
ATOM   8362  CB  GLU B 312      35.628  82.048   5.346  1.00 39.01           C  
ATOM   8363  CG  GLU B 312      36.905  82.619   4.756  1.00 40.07           C  
ATOM   8364  CD  GLU B 312      37.484  81.828   3.589  1.00 40.44           C  
ATOM   8365  OE1 GLU B 312      38.015  80.707   3.783  1.00 43.92           O  
ATOM   8366  OE2 GLU B 312      37.457  82.374   2.469  1.00 43.34           O  
ATOM   8367  N   ASP B 313      32.560  82.388   6.595  1.00 40.86           N  
ATOM   8368  CA  ASP B 313      31.466  81.707   7.270  1.00 41.68           C  
ATOM   8369  C   ASP B 313      31.632  80.212   7.108  1.00 41.46           C  
ATOM   8370  O   ASP B 313      31.883  79.722   6.005  1.00 41.97           O  
ATOM   8371  CB  ASP B 313      30.126  82.124   6.664  1.00 42.38           C  
ATOM   8372  CG  ASP B 313      29.817  83.581   6.895  1.00 44.40           C  
ATOM   8373  OD1 ASP B 313      30.234  84.108   7.955  1.00 48.09           O  
ATOM   8374  OD2 ASP B 313      29.159  84.193   6.023  1.00 48.23           O  
ATOM   8375  N   VAL B 314      31.516  79.490   8.212  1.00 41.07           N  
ATOM   8376  CA  VAL B 314      31.595  78.047   8.166  1.00 40.53           C  
ATOM   8377  C   VAL B 314      30.258  77.464   8.601  1.00 40.38           C  
ATOM   8378  O   VAL B 314      29.786  77.702   9.707  1.00 40.72           O  
ATOM   8379  CB  VAL B 314      32.727  77.503   9.022  1.00 40.25           C  
ATOM   8380  CG1 VAL B 314      32.754  75.987   8.937  1.00 40.05           C  
ATOM   8381  CG2 VAL B 314      34.043  78.101   8.548  1.00 39.81           C  
ATOM   8382  N   GLU B 315      29.658  76.751   7.661  1.00 39.94           N  
ATOM   8383  CA  GLU B 315      28.504  75.888   7.873  1.00 39.85           C  
ATOM   8384  C   GLU B 315      28.599  74.980   9.112  1.00 38.58           C  
ATOM   8385  O   GLU B 315      27.930  75.213  10.131  1.00 38.67           O  
ATOM   8386  CB  GLU B 315      28.257  75.032   6.599  1.00 40.78           C  
ATOM   8387  CG  GLU B 315      29.379  75.025   5.481  1.00 42.81           C  
ATOM   8388  CD  GLU B 315      30.767  74.519   5.932  1.00 44.76           C  
ATOM   8389  OE1 GLU B 315      30.857  73.795   6.947  1.00 45.67           O  
ATOM   8390  OE2 GLU B 315      31.776  74.852   5.264  1.00 46.06           O  
ATOM   8391  N   GLN B 316      29.444  73.959   9.017  1.00 36.56           N  
ATOM   8392  CA  GLN B 316      29.497  72.901   9.998  1.00 35.09           C  
ATOM   8393  C   GLN B 316      30.708  73.092  10.879  1.00 32.69           C  
ATOM   8394  O   GLN B 316      31.833  72.938  10.412  1.00 32.45           O  
ATOM   8395  CB  GLN B 316      29.566  71.549   9.289  1.00 35.50           C  
ATOM   8396  CG  GLN B 316      28.351  71.245   8.430  1.00 38.70           C  
ATOM   8397  CD  GLN B 316      27.040  71.300   9.209  1.00 41.64           C  
ATOM   8398  OE1 GLN B 316      26.111  72.021   8.825  1.00 45.40           O  
ATOM   8399  NE2 GLN B 316      26.957  70.540  10.310  1.00 43.36           N  
ATOM   8400  N   ASN B 317      30.489  73.438  12.150  1.00 30.27           N  
ATOM   8401  CA  ASN B 317      31.626  73.668  13.074  1.00 28.78           C  
ATOM   8402  C   ASN B 317      31.818  72.603  14.172  1.00 27.49           C  
ATOM   8403  O   ASN B 317      32.784  72.671  14.917  1.00 26.48           O  
ATOM   8404  CB  ASN B 317      31.672  75.116  13.604  0.50 28.31           C  
ATOM   8406  CG  ASN B 317      30.462  75.501  14.427  0.50 26.85           C  
ATOM   8408  OD1 ASN B 317      29.823  74.666  15.047  0.50 24.85           O  
ATOM   8410  ND2 ASN B 317      30.164  76.792  14.453  0.50 23.50           N  
ATOM   8412  N   GLN B 318      30.935  71.608  14.247  1.00 25.82           N  
ATOM   8413  CA  GLN B 318      31.132  70.463  15.144  1.00 24.76           C  
ATOM   8414  C   GLN B 318      31.474  69.236  14.281  1.00 24.35           C  
ATOM   8415  O   GLN B 318      30.585  68.504  13.829  1.00 24.01           O  
ATOM   8416  CB  GLN B 318      29.876  70.206  15.969  1.00 25.13           C  
ATOM   8417  CG  GLN B 318      29.310  71.425  16.660  1.00 26.27           C  
ATOM   8418  CD  GLN B 318      30.239  71.981  17.693  1.00 26.90           C  
ATOM   8419  OE1 GLN B 318      30.630  71.277  18.619  1.00 32.70           O  
ATOM   8420  NE2 GLN B 318      30.610  73.251  17.544  1.00 27.89           N  
ATOM   8421  N   LEU B 319      32.769  69.044  14.032  1.00 22.49           N  
ATOM   8422  CA  LEU B 319      33.233  68.035  13.083  1.00 21.67           C  
ATOM   8423  C   LEU B 319      33.605  66.729  13.768  1.00 21.80           C  
ATOM   8424  O   LEU B 319      34.215  66.752  14.813  1.00 21.01           O  
ATOM   8425  CB  LEU B 319      34.422  68.572  12.312  1.00 21.71           C  
ATOM   8426  CG  LEU B 319      34.186  69.867  11.515  1.00 22.16           C  
ATOM   8427  CD1 LEU B 319      35.448  70.218  10.768  1.00 21.93           C  
ATOM   8428  CD2 LEU B 319      33.010  69.747  10.570  1.00 24.38           C  
ATOM   8429  N   VAL B 320      33.223  65.603  13.170  1.00 21.44           N  
ATOM   8430  CA  VAL B 320      33.424  64.280  13.771  1.00 21.58           C  
ATOM   8431  C   VAL B 320      34.106  63.382  12.746  1.00 21.68           C  
ATOM   8432  O   VAL B 320      33.603  63.214  11.630  1.00 21.48           O  
ATOM   8433  CB  VAL B 320      32.083  63.675  14.215  1.00 22.02           C  
ATOM   8434  CG1 VAL B 320      32.260  62.277  14.822  1.00 23.51           C  
ATOM   8435  CG2 VAL B 320      31.382  64.611  15.170  1.00 22.46           C  
ATOM   8436  N   LEU B 321      35.282  62.859  13.096  1.00 20.43           N  
ATOM   8437  CA  LEU B 321      36.061  62.037  12.178  1.00 20.28           C  
ATOM   8438  C   LEU B 321      35.880  60.564  12.514  1.00 20.52           C  
ATOM   8439  O   LEU B 321      35.670  60.212  13.671  1.00 19.87           O  
ATOM   8440  CB  LEU B 321      37.552  62.424  12.224  1.00 20.31           C  
ATOM   8441  CG  LEU B 321      37.942  63.891  11.950  1.00 20.81           C  
ATOM   8442  CD1 LEU B 321      39.462  64.011  11.852  1.00 21.54           C  
ATOM   8443  CD2 LEU B 321      37.245  64.470  10.709  1.00 21.85           C  
ATOM   8444  N   ASP B 322      35.972  59.689  11.515  1.00 21.04           N  
ATOM   8445  CA  ASP B 322      35.814  58.253  11.778  1.00 21.82           C  
ATOM   8446  C   ASP B 322      36.961  57.660  12.612  1.00 20.88           C  
ATOM   8447  O   ASP B 322      38.051  58.203  12.641  1.00 21.39           O  
ATOM   8448  CB  ASP B 322      35.756  57.473  10.478  1.00 22.75           C  
ATOM   8449  CG  ASP B 322      34.581  57.858   9.610  1.00 26.00           C  
ATOM   8450  OD1 ASP B 322      33.490  58.197  10.142  1.00 28.01           O  
ATOM   8451  OD2 ASP B 322      34.790  57.816   8.389  1.00 30.29           O  
ATOM   8452  N   HIS B 323      36.702  56.525  13.265  1.00 21.07           N  
ATOM   8453  CA  HIS B 323      37.731  55.772  14.009  1.00 20.79           C  
ATOM   8454  C   HIS B 323      37.588  54.284  13.647  1.00 21.34           C  
ATOM   8455  O   HIS B 323      36.619  53.888  13.008  1.00 21.42           O  
ATOM   8456  CB  HIS B 323      37.519  55.932  15.518  1.00 20.72           C  
ATOM   8457  CG  HIS B 323      36.261  55.295  16.017  1.00 21.35           C  
ATOM   8458  ND1 HIS B 323      35.034  55.924  15.939  1.00 20.69           N  
ATOM   8459  CD2 HIS B 323      36.025  54.070  16.548  1.00 20.09           C  
ATOM   8460  CE1 HIS B 323      34.107  55.131  16.445  1.00 21.43           C  
ATOM   8461  NE2 HIS B 323      34.677  53.989  16.794  1.00 21.10           N  
ATOM   8462  N   GLU B 324      38.543  53.471  14.082  1.00 22.10           N  
ATOM   8463  CA  GLU B 324      38.510  52.006  13.936  1.00 22.98           C  
ATOM   8464  C   GLU B 324      38.958  51.404  15.269  1.00 22.35           C  
ATOM   8465  O   GLU B 324      39.397  52.138  16.148  1.00 20.15           O  
ATOM   8466  CB  GLU B 324      39.508  51.549  12.865  1.00 23.96           C  
ATOM   8467  CG  GLU B 324      39.368  52.197  11.520  1.00 29.55           C  
ATOM   8468  CD  GLU B 324      40.718  52.640  10.986  1.00 37.02           C  
ATOM   8469  OE1 GLU B 324      41.233  53.682  11.484  1.00 39.44           O  
ATOM   8470  OE2 GLU B 324      41.266  51.946  10.083  1.00 40.19           O  
ATOM   8471  N   ILE B 325      38.843  50.074  15.403  1.00 22.02           N  
ATOM   8472  CA  ILE B 325      39.460  49.329  16.525  1.00 22.27           C  
ATOM   8473  C   ILE B 325      40.501  48.413  15.921  1.00 22.43           C  
ATOM   8474  O   ILE B 325      40.225  47.685  14.955  1.00 21.10           O  
ATOM   8475  CB  ILE B 325      38.424  48.543  17.337  1.00 22.82           C  
ATOM   8476  CG1 ILE B 325      37.496  49.524  18.071  1.00 25.85           C  
ATOM   8477  CG2 ILE B 325      39.097  47.567  18.323  1.00 23.49           C  
ATOM   8478  CD1 ILE B 325      36.519  48.913  19.015  1.00 27.45           C  
ATOM   8479  N   PHE B 326      41.727  48.507  16.437  1.00 22.24           N  
ATOM   8480  CA  PHE B 326      42.800  47.600  16.063  1.00 22.63           C  
ATOM   8481  C   PHE B 326      42.983  46.514  17.116  1.00 22.12           C  
ATOM   8482  O   PHE B 326      43.382  46.815  18.247  1.00 20.15           O  
ATOM   8483  CB  PHE B 326      44.115  48.375  15.915  1.00 23.78           C  
ATOM   8484  CG  PHE B 326      44.132  49.364  14.767  1.00 25.27           C  
ATOM   8485  CD1 PHE B 326      43.253  49.250  13.684  1.00 26.35           C  
ATOM   8486  CD2 PHE B 326      45.075  50.363  14.743  1.00 27.06           C  
ATOM   8487  CE1 PHE B 326      43.289  50.176  12.651  1.00 28.84           C  
ATOM   8488  CE2 PHE B 326      45.131  51.278  13.696  1.00 28.77           C  
ATOM   8489  CZ  PHE B 326      44.239  51.178  12.652  1.00 26.85           C  
ATOM   8490  N   SER B 327      42.727  45.262  16.736  1.00 21.28           N  
ATOM   8491  CA  SER B 327      42.799  44.136  17.682  1.00 21.81           C  
ATOM   8492  C   SER B 327      44.221  43.625  17.774  1.00 21.77           C  
ATOM   8493  O   SER B 327      44.825  43.286  16.754  1.00 21.62           O  
ATOM   8494  CB  SER B 327      41.850  43.007  17.261  1.00 21.99           C  
ATOM   8495  OG  SER B 327      40.508  43.425  17.400  1.00 23.31           O  
ATOM   8496  N   ARG B 328      44.757  43.577  18.994  1.00 21.26           N  
ATOM   8497  CA  ARG B 328      46.134  43.148  19.218  1.00 22.21           C  
ATOM   8498  C   ARG B 328      46.133  42.096  20.355  1.00 21.36           C  
ATOM   8499  O   ARG B 328      45.139  41.383  20.536  1.00 20.94           O  
ATOM   8500  CB  ARG B 328      47.047  44.368  19.452  1.00 21.01           C  
ATOM   8501  CG  ARG B 328      47.128  45.335  18.250  1.00 23.27           C  
ATOM   8502  CD  ARG B 328      48.183  46.416  18.453  1.00 27.50           C  
ATOM   8503  NE  ARG B 328      48.178  47.405  17.381  1.00 34.98           N  
ATOM   8504  CZ  ARG B 328      48.014  48.716  17.549  1.00 37.14           C  
ATOM   8505  NH1 ARG B 328      47.814  49.238  18.763  1.00 37.84           N  
ATOM   8506  NH2 ARG B 328      48.026  49.501  16.484  1.00 37.05           N  
ATOM   8507  N   ARG B 329      47.225  41.958  21.099  1.00 22.06           N  
ATOM   8508  CA  ARG B 329      47.344  40.830  22.024  1.00 21.99           C  
ATOM   8509  C   ARG B 329      46.893  41.121  23.474  1.00 21.56           C  
ATOM   8510  O   ARG B 329      47.052  40.258  24.335  1.00 23.58           O  
ATOM   8511  CB  ARG B 329      48.761  40.261  21.964  1.00 23.19           C  
ATOM   8512  CG  ARG B 329      49.075  39.762  20.533  1.00 27.61           C  
ATOM   8513  CD  ARG B 329      50.255  38.841  20.449  1.00 34.86           C  
ATOM   8514  NE  ARG B 329      50.482  38.317  19.092  1.00 39.17           N  
ATOM   8515  CZ  ARG B 329      51.062  38.975  18.078  1.00 41.27           C  
ATOM   8516  NH1 ARG B 329      51.481  40.242  18.188  1.00 42.17           N  
ATOM   8517  NH2 ARG B 329      51.221  38.351  16.915  1.00 42.44           N  
ATOM   8518  N   SER B 330      46.258  42.264  23.736  1.00 20.00           N  
ATOM   8519  CA  SER B 330      45.648  42.495  25.059  1.00 19.12           C  
ATOM   8520  C   SER B 330      44.168  42.154  25.143  1.00 18.40           C  
ATOM   8521  O   SER B 330      43.557  42.357  26.204  1.00 17.73           O  
ATOM   8522  CB  SER B 330      45.890  43.924  25.578  1.00 19.08           C  
ATOM   8523  OG  SER B 330      45.232  44.893  24.767  1.00 19.38           O  
ATOM   8524  N   THR B 331      43.615  41.632  24.031  1.00 18.90           N  
ATOM   8525  CA  THR B 331      42.261  41.094  23.963  1.00 19.19           C  
ATOM   8526  C   THR B 331      42.305  39.688  23.333  1.00 20.45           C  
ATOM   8527  O   THR B 331      43.265  39.326  22.637  1.00 19.78           O  
ATOM   8528  CB  THR B 331      41.281  42.023  23.184  1.00 18.74           C  
ATOM   8529  OG1 THR B 331      41.827  42.369  21.902  1.00 18.55           O  
ATOM   8530  CG2 THR B 331      41.042  43.314  23.967  1.00 19.16           C  
ATOM   8531  N   LYS B 332      41.262  38.914  23.609  1.00 21.45           N  
ATOM   8532  CA  LYS B 332      41.150  37.529  23.128  1.00 23.54           C  
ATOM   8533  C   LYS B 332      40.804  37.451  21.656  1.00 25.15           C  
ATOM   8534  O   LYS B 332      41.124  36.433  21.003  1.00 26.62           O  
ATOM   8535  CB  LYS B 332      40.062  36.787  23.900  1.00 22.97           C  
ATOM   8536  CG  LYS B 332      40.414  36.480  25.333  1.00 21.84           C  
ATOM   8537  CD  LYS B 332      39.215  35.815  26.027  1.00 20.78           C  
ATOM   8538  CE  LYS B 332      39.483  35.441  27.434  1.00 21.52           C  
ATOM   8539  NZ  LYS B 332      39.555  36.652  28.360  1.00 21.87           N  
ATOM   8540  OXT LYS B 332      40.192  38.389  21.125  1.00 26.50           O  
TER    8541      LYS B 332                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
