
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  275 ( 2141),  selected  275 , name 1sxg_A
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 1sxg_A.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K    58_A      -       -           -
LGA    K    59_A      -       -           -
LGA    T    60_A      -       -           -
LGA    T    61_A      Y      71           #
LGA    T    62_A      S      72          3.748
LGA    V    63_A      I      73          2.864
LGA    G    64_A      A      74          2.433
LGA    V    65_A      L      75          2.663
LGA    I    66_A      I      76          2.372
LGA    I    67_A      I      77          1.927
LGA    P    68_A      P      78          1.300
LGA    D    69_A      S      79          1.376
LGA    I    70_A      L      80          2.282
LGA    S    71_A      F      81          2.573
LGA    N    72_A      E      82          2.737
LGA    I    73_A      K      83          3.714
LGA    F    74_A      A      84          3.700
LGA    Y    75_A      C      85          2.311
LGA    A    76_A      A      86          1.458
LGA    E    77_A      H      87          1.811
LGA    L    78_A      F      88          1.940
LGA    A    79_A      L      89          1.921
LGA    R    80_A      P      90          2.643
LGA    G    81_A      S      91          3.504
LGA    I    82_A      F      92          2.067
LGA    E    83_A      Q      93          2.226
LGA    D    84_A      Q      94          3.496
LGA    I    85_A      A      95          3.105
LGA    A    86_A      L      96          2.831
LGA    T    87_A      N      97          3.683
LGA    M    88_A      K      98          3.535
LGA    Y    89_A      A      99          3.076
LGA    K    90_A      G     100          3.884
LGA    Y    91_A      Y     101          3.136
LGA    N    92_A      Q     102          2.503
LGA    I    93_A      L     103          2.401
LGA    I    94_A      L     104          3.150
LGA    L    95_A      L     105          3.380
LGA    S    96_A      G     106          2.117
LGA    N    97_A      Y     107          1.636
LGA    S    98_A      S     108          0.911
LGA    D    99_A      D     109          0.915
LGA    Q   100_A      Y     110          0.372
LGA    N   101_A      S     111          1.445
LGA    Q   102_A      I     112          1.118
LGA    D   103_A      E     113          1.306
LGA    K   104_A      Q     114          1.435
LGA    E   105_A      E     115          1.719
LGA    L   106_A      E     116          2.132
LGA    H   107_A      K     117          2.470
LGA    L   108_A      L     118          2.617
LGA    L   109_A      L     119          1.599
LGA    N   110_A      S     120          1.937
LGA    N   111_A      T     121          3.371
LGA    M   112_A      F     122          2.854
LGA    L   113_A      L     123          2.711
LGA    G   114_A      E     124          4.260
LGA    K   115_A      S     125           #
LGA    Q   116_A      R     126          3.034
LGA    V   117_A      P     127           #
LGA    D   118_A      A     128          2.420
LGA    G   119_A      G     129          2.585
LGA    I   120_A      V     130          2.601
LGA    I   121_A      V     131          2.643
LGA    F   122_A      L     132          1.617
LGA    M   123_A      F     133          2.009
LGA    S   124_A      G     134          3.418
LGA    G   125_A      -       -           -
LGA    N   126_A      -       -           -
LGA    V   127_A      S     135          2.795
LGA    T   128_A      E     136          2.241
LGA    E   129_A      H     137          5.607
LGA    E   130_A      S     138          3.318
LGA    H   131_A      Q     139           #
LGA    V   132_A      R     140           -
LGA    E   133_A      T     141          5.746
LGA    E   134_A      H     142          1.701
LGA    L   135_A      Q     143           #
LGA    -       -      L     144           -
LGA    K   136_A      L     145          4.673
LGA    K   137_A      E     146          1.936
LGA    S   138_A      A     147           #
LGA    P   139_A      S     148          2.981
LGA    -       -      N     149           -
LGA    V   140_A      T     150          3.448
LGA    P   141_A      P     151          2.097
LGA    V   142_A      V     152          2.127
LGA    V   143_A      L     153          0.547
LGA    L   144_A      E     154          1.726
LGA    A   145_A      I     155          2.014
LGA    A   146_A      -       -           -
LGA    S   147_A      A     156          2.508
LGA    I   148_A      E     157          3.356
LGA    E   149_A      L     158          3.743
LGA    S   150_A      -       -           -
LGA    T   151_A      S     159          5.281
LGA    N   152_A      S     160          4.979
LGA    Q   153_A      K     161          3.356
LGA    -       -      A     162           -
LGA    -       -      S     163           -
LGA    I   154_A      Y     164          2.642
LGA    P   155_A      L     165          1.888
LGA    S   156_A      N     166          1.405
LGA    V   157_A      I     167          0.668
LGA    T   158_A      G     168          1.146
LGA    I   159_A      V     169          1.685
LGA    D   160_A      D     170          1.495
LGA    Y   161_A      H     171          1.072
LGA    E   162_A      F     172          0.826
LGA    Q   163_A      E     173          0.828
LGA    A   164_A      V     174          1.059
LGA    A   165_A      G     175          0.791
LGA    F   166_A      K     176          0.429
LGA    D   167_A      A     177          0.403
LGA    A   168_A      C     178          0.180
LGA    V   169_A      T     179          0.313
LGA    Q   170_A      R     180          0.386
LGA    S   171_A      H     181          0.565
LGA    L   172_A      L     182          0.522
LGA    I   173_A      I     183          0.337
LGA    D   174_A      E     184          0.724
LGA    S   175_A      Q     185          0.810
LGA    G   176_A      G     186          0.263
LGA    H   177_A      F     187          1.206
LGA    K   178_A      K     188          1.249
LGA    N   179_A      N     189          0.838
LGA    I   180_A      V     190          0.548
LGA    A   181_A      G     191          0.880
LGA    F   182_A      F     192          1.025
LGA    V   183_A      I     193          0.871
LGA    S   184_A      G     194          1.371
LGA    G   185_A      A     195          1.682
LGA    T   186_A      R     196          2.530
LGA    L   187_A      G     197          2.348
LGA    E   188_A      N     198          1.775
LGA    E   189_A      H     199          1.657
LGA    P   190_A      S     200          1.516
LGA    I   191_A      T     201          1.398
LGA    N   192_A      L     202          1.846
LGA    H   193_A      Q     203          1.797
LGA    A   194_A      R     204          3.595
LGA    K   195_A      -       -           -
LGA    K   196_A      Q     205          0.775
LGA    V   197_A      L     206          1.234
LGA    K   198_A      H     207          1.326
LGA    G   199_A      G     208          1.074
LGA    Y   200_A      W     209          0.581
LGA    K   201_A      Q     210          0.941
LGA    R   202_A      S     211          1.040
LGA    A   203_A      A     212          0.697
LGA    L   204_A      M     213          0.891
LGA    T   205_A      I     214          1.194
LGA    E   206_A      E     215          1.220
LGA    S   207_A      N     216          1.511
LGA    G   208_A      Y     217          1.810
LGA    L   209_A      L     218          1.143
LGA    P   210_A      T     219          1.266
LGA    V   211_A      P     220          1.591
LGA    R   212_A      D     221          1.795
LGA    D   213_A      -       -           -
LGA    S   214_A      -       -           -
LGA    Y   215_A      H     222          0.977
LGA    I   216_A      F     223          1.080
LGA    V   217_A      L     224          0.556
LGA    E   218_A      T     225          0.627
LGA    G   219_A      T     226          3.536
LGA    -       -      H     227           -
LGA    D   220_A      E     228          2.694
LGA    Y   221_A      A     229          2.998
LGA    T   222_A      P     230          2.721
LGA    -       -      S     231           -
LGA    Y   223_A      S     232          2.680
LGA    D   224_A      Q     233          2.105
LGA    S   225_A      L     234          1.829
LGA    G   226_A      G     235          2.080
LGA    I   227_A      A     236          1.971
LGA    E   228_A      E     237          1.744
LGA    A   229_A      G     238          1.032
LGA    V   230_A      L     239          1.198
LGA    E   231_A      A     240          1.285
LGA    K   232_A      K     241          1.005
LGA    L   233_A      L     242          1.182
LGA    L   234_A      L     243          1.667
LGA    E   235_A      L     244          1.298
LGA    E   236_A      R     245          2.170
LGA    D   237_A      D     246          2.133
LGA    E   238_A      S     247          3.020
LGA    K   239_A      S     248          3.786
LGA    P   240_A      L     249          2.040
LGA    T   241_A      N     250          1.147
LGA    A   242_A      A     251          1.043
LGA    I   243_A      L     252          0.678
LGA    F   244_A      V     253          0.782
LGA    V   245_A      C     254          0.900
LGA    G   246_A      S     255          0.959
LGA    T   247_A      H     256          1.489
LGA    D   248_A      E     257          1.279
LGA    E   249_A      E     258          1.673
LGA    M   250_A      I     259          1.632
LGA    A   251_A      A     260          1.676
LGA    L   252_A      I     261          1.474
LGA    G   253_A      G     262          1.600
LGA    V   254_A      A     263          1.724
LGA    I   255_A      L     264          1.433
LGA    H   256_A      F     265          1.699
LGA    G   257_A      E     266          2.030
LGA    A   258_A      C     267          2.214
LGA    Q   259_A      H     268          1.999
LGA    D   260_A      R     269          1.750
LGA    R   261_A      R     270          1.891
LGA    G   262_A      V     271          1.680
LGA    L   263_A      L     272          1.567
LGA    N   264_A      K     273          2.336
LGA    V   265_A      V     274          2.156
LGA    P   266_A      P     275          2.261
LGA    N   267_A      T     276          2.778
LGA    D   268_A      D     277          1.974
LGA    L   269_A      I     278          1.458
LGA    E   270_A      A     279          1.382
LGA    I   271_A      I     280          1.172
LGA    I   272_A      I     281          1.238
LGA    G   273_A      C     282          1.098
LGA    F   274_A      L     283          2.233
LGA    D   275_A      E     284          2.484
LGA    N   276_A      G     285          2.749
LGA    T   277_A      S     286          2.952
LGA    R   278_A      S     287          4.216
LGA    L   279_A      M     288          2.478
LGA    S   280_A      G     289          2.635
LGA    T   281_A      E     290          2.858
LGA    M   282_A      H     291          4.601
LGA    V   283_A      A     292          2.377
LGA    R   284_A      Y     293          2.277
LGA    P   285_A      P     294          2.575
LGA    Q   286_A      S     295          2.485
LGA    L   287_A      L     296          2.658
LGA    T   288_A      T     297          2.167
LGA    S   289_A      S     298          1.680
LGA    V   290_A      A     299          1.234
LGA    V   291_A      E     300          1.721
LGA    Q   292_A      F     301          2.201
LGA    P   293_A      D     302          1.956
LGA    M   294_A      Y     303          0.861
LGA    Y   295_A      E     304          2.765
LGA    D   296_A      R     305          3.048
LGA    I   297_A      M     306          1.633
LGA    G   298_A      G     307          1.728
LGA    A   299_A      T     308          2.573
LGA    V   300_A      K     309          2.373
LGA    A   301_A      A     310          1.245
LGA    M   302_A      A     311          1.453
LGA    R   303_A      E     312          1.825
LGA    L   304_A      K     313          1.422
LGA    L   305_A      L     314          0.937
LGA    T   306_A      L     315          1.068
LGA    K   307_A      H     316          2.160
LGA    Y   308_A      A     317          2.169
LGA    M   309_A      I     318          2.369
LGA    N   310_A      K     319          2.763
LGA    K   311_A      -       -           -
LGA    E   312_A      E     321          1.994
LGA    T   313_A      P     322          2.958
LGA    V   314_A      E     323          1.273
LGA    D   315_A      E     324          3.971
LGA    S   316_A      P     326          4.021
LGA    S   317_A      -       -           -
LGA    I   318_A      -       -           -
LGA    V   319_A      T     327          2.638
LGA    Q   320_A      S     328          3.005
LGA    L   321_A      M     329          1.044
LGA    P   322_A      G     330          2.346
LGA    H   323_A      F     331          2.009
LGA    R   324_A      K     332          1.776
LGA    I   325_A      L     333          1.080
LGA    E   326_A      K     334          1.930
LGA    F   327_A      R     335          2.240
LGA    R   328_A      R     336          2.475
LGA    Q   329_A      A     337          2.567
LGA    S   330_A      S     338          2.424
LGA    T   331_A      T     339          1.979
LGA    K   332_A      A     340          1.078
LGA    -       -      I     341           -
LGA    -       -      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  275  270    5.0    255    2.24    21.18     72.353    10.887

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.950197 * X  +  -0.265950 * Y  +   0.162467 * Z  + -91.945938
  Y_new =  -0.186788 * X  +  -0.903299 * Y  +  -0.386214 * Z  +  97.359146
  Z_new =   0.249470 * X  +   0.336633 * Y  +  -0.907989 * Z  +   5.058191 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.786557   -0.355036  [ DEG:   159.6580    -20.3420 ]
  Theta =  -0.252133   -2.889460  [ DEG:   -14.4461   -165.5539 ]
  Phi   =  -0.194103    2.947490  [ DEG:   -11.1213    168.8787 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1sxg_A                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1sxg_A.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  275  270   5.0  255   2.24   21.18  72.353
REMARK  ---------------------------------------------------------- 
MOLECULE 1sxg_A
HEADER    TRANSCRIPTION                           30-MAR-04   1SXG              
TITLE     STRUCTURAL STUDIES ON THE APO TRANSCRIPTION FACTOR FORM B.            
TITLE    2 MEGATERIUM                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUCOSE-RESISTANCE AMYLASE REGULATOR;                      
COMPND   3 CHAIN: A, D, B, I, P, F;                                             
COMPND   4 SYNONYM: CATABOLITE CONTROL PROTEIN; CCPA;                           
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS MEGATERIUM;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: CCPA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ALLOSTERISM; PHOSPHOPROTEIN; TRANSCRIPTION REGULATION                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.A.SCHUMACHER,G.S.ALLEN,M.DIEL,G.SEIDEL,W.HILLEN,                    
AUTHOR   2 R.G.BRENNAN                                                          
REVDAT   1   19-OCT-04 1SXG    0                                                
JRNL        AUTH   M.A.SCHUMACHER,G.S.ALLEN,M.DIEL,G.SEIDEL,W.HILLEN,           
JRNL        AUTH 2 R.G.BRENNAN                                                  
JRNL        TITL   STRUCTURAL STUDIES ON THE APO TRANSCRIPTION FACTOR           
JRNL        TITL 2 FORM B. MEGATERIUM                                           
JRNL        REF    CELL (CAMBRIDGE,MASS.)        V. 118   731 2004              
JRNL        REFN   ASTM CELLB5  US ISSN 0092-8674                               
REMARK   2 RESOLUTION. 2.75 ANGSTROMS.                                          
DBREF  1SXG A   53   332  UNP    P46828   CCPA_BACME      53    332             
DBREF  1SXG D   53   332  UNP    P46828   CCPA_BACME      53    332             
DBREF  1SXG B   53   332  UNP    P46828   CCPA_BACME      53    332             
DBREF  1SXG I   53   332  UNP    P46828   CCPA_BACME      53    332             
DBREF  1SXG P   53   332  UNP    P46828   CCPA_BACME      53    332             
DBREF  1SXG F   53   332  UNP    P46828   CCPA_BACME      53    332             
SEQRES   1 A  280  ARG GLY LEU ALA SER LYS LYS THR THR THR VAL GLY VAL          
SEQRES   2 A  280  ILE ILE PRO ASP ILE SER ASN ILE PHE TYR ALA GLU LEU          
SEQRES   3 A  280  ALA ARG GLY ILE GLU ASP ILE ALA THR MET TYR LYS TYR          
SEQRES   4 A  280  ASN ILE ILE LEU SER ASN SER ASP GLN ASN GLN ASP LYS          
SEQRES   5 A  280  GLU LEU HIS LEU LEU ASN ASN MET LEU GLY LYS GLN VAL          
SEQRES   6 A  280  ASP GLY ILE ILE PHE MET SER GLY ASN VAL THR GLU GLU          
SEQRES   7 A  280  HIS VAL GLU GLU LEU LYS LYS SER PRO VAL PRO VAL VAL          
SEQRES   8 A  280  LEU ALA ALA SER ILE GLU SER THR ASN GLN ILE PRO SER          
SEQRES   9 A  280  VAL THR ILE ASP TYR GLU GLN ALA ALA PHE ASP ALA VAL          
SEQRES  10 A  280  GLN SER LEU ILE ASP SER GLY HIS LYS ASN ILE ALA PHE          
SEQRES  11 A  280  VAL SER GLY THR LEU GLU GLU PRO ILE ASN HIS ALA LYS          
SEQRES  12 A  280  LYS VAL LYS GLY TYR LYS ARG ALA LEU THR GLU SER GLY          
SEQRES  13 A  280  LEU PRO VAL ARG ASP SER TYR ILE VAL GLU GLY ASP TYR          
SEQRES  14 A  280  THR TYR ASP SER GLY ILE GLU ALA VAL GLU LYS LEU LEU          
SEQRES  15 A  280  GLU GLU ASP GLU LYS PRO THR ALA ILE PHE VAL GLY THR          
SEQRES  16 A  280  ASP GLU MET ALA LEU GLY VAL ILE HIS GLY ALA GLN ASP          
SEQRES  17 A  280  ARG GLY LEU ASN VAL PRO ASN ASP LEU GLU ILE ILE GLY          
SEQRES  18 A  280  PHE ASP ASN THR ARG LEU SER THR MET VAL ARG PRO GLN          
SEQRES  19 A  280  LEU THR SER VAL VAL GLN PRO MET TYR ASP ILE GLY ALA          
SEQRES  20 A  280  VAL ALA MET ARG LEU LEU THR LYS TYR MET ASN LYS GLU          
SEQRES  21 A  280  THR VAL ASP SER SER ILE VAL GLN LEU PRO HIS ARG ILE          
SEQRES  22 A  280  GLU PHE ARG GLN SER THR LYS                                  
SEQRES   1 D  280  ARG GLY LEU ALA SER LYS LYS THR THR THR VAL GLY VAL          
SEQRES   2 D  280  ILE ILE PRO ASP ILE SER ASN ILE PHE TYR ALA GLU LEU          
SEQRES   3 D  280  ALA ARG GLY ILE GLU ASP ILE ALA THR MET TYR LYS TYR          
SEQRES   4 D  280  ASN ILE ILE LEU SER ASN SER ASP GLN ASN GLN ASP LYS          
SEQRES   5 D  280  GLU LEU HIS LEU LEU ASN ASN MET LEU GLY LYS GLN VAL          
SEQRES   6 D  280  ASP GLY ILE ILE PHE MET SER GLY ASN VAL THR GLU GLU          
SEQRES   7 D  280  HIS VAL GLU GLU LEU LYS LYS SER PRO VAL PRO VAL VAL          
SEQRES   8 D  280  LEU ALA ALA SER ILE GLU SER THR ASN GLN ILE PRO SER          
SEQRES   9 D  280  VAL THR ILE ASP TYR GLU GLN ALA ALA PHE ASP ALA VAL          
SEQRES  10 D  280  GLN SER LEU ILE ASP SER GLY HIS LYS ASN ILE ALA PHE          
SEQRES  11 D  280  VAL SER GLY THR LEU GLU GLU PRO ILE ASN HIS ALA LYS          
SEQRES  12 D  280  LYS VAL LYS GLY TYR LYS ARG ALA LEU THR GLU SER GLY          
SEQRES  13 D  280  LEU PRO VAL ARG ASP SER TYR ILE VAL GLU GLY ASP TYR          
SEQRES  14 D  280  THR TYR ASP SER GLY ILE GLU ALA VAL GLU LYS LEU LEU          
SEQRES  15 D  280  GLU GLU ASP GLU LYS PRO THR ALA ILE PHE VAL GLY THR          
SEQRES  16 D  280  ASP GLU MET ALA LEU GLY VAL ILE HIS GLY ALA GLN ASP          
SEQRES  17 D  280  ARG GLY LEU ASN VAL PRO ASN ASP LEU GLU ILE ILE GLY          
SEQRES  18 D  280  PHE ASP ASN THR ARG LEU SER THR MET VAL ARG PRO GLN          
SEQRES  19 D  280  LEU THR SER VAL VAL GLN PRO MET TYR ASP ILE GLY ALA          
SEQRES  20 D  280  VAL ALA MET ARG LEU LEU THR LYS TYR MET ASN LYS GLU          
SEQRES  21 D  280  THR VAL ASP SER SER ILE VAL GLN LEU PRO HIS ARG ILE          
SEQRES  22 D  280  GLU PHE ARG GLN SER THR LYS                                  
SEQRES   1 B  280  ARG GLY LEU ALA SER LYS LYS THR THR THR VAL GLY VAL          
SEQRES   2 B  280  ILE ILE PRO ASP ILE SER ASN ILE PHE TYR ALA GLU LEU          
SEQRES   3 B  280  ALA ARG GLY ILE GLU ASP ILE ALA THR MET TYR LYS TYR          
SEQRES   4 B  280  ASN ILE ILE LEU SER ASN SER ASP GLN ASN GLN ASP LYS          
SEQRES   5 B  280  GLU LEU HIS LEU LEU ASN ASN MET LEU GLY LYS GLN VAL          
SEQRES   6 B  280  ASP GLY ILE ILE PHE MET SER GLY ASN VAL THR GLU GLU          
SEQRES   7 B  280  HIS VAL GLU GLU LEU LYS LYS SER PRO VAL PRO VAL VAL          
SEQRES   8 B  280  LEU ALA ALA SER ILE GLU SER THR ASN GLN ILE PRO SER          
SEQRES   9 B  280  VAL THR ILE ASP TYR GLU GLN ALA ALA PHE ASP ALA VAL          
SEQRES  10 B  280  GLN SER LEU ILE ASP SER GLY HIS LYS ASN ILE ALA PHE          
SEQRES  11 B  280  VAL SER GLY THR LEU GLU GLU PRO ILE ASN HIS ALA LYS          
SEQRES  12 B  280  LYS VAL LYS GLY TYR LYS ARG ALA LEU THR GLU SER GLY          
SEQRES  13 B  280  LEU PRO VAL ARG ASP SER TYR ILE VAL GLU GLY ASP TYR          
SEQRES  14 B  280  THR TYR ASP SER GLY ILE GLU ALA VAL GLU LYS LEU LEU          
SEQRES  15 B  280  GLU GLU ASP GLU LYS PRO THR ALA ILE PHE VAL GLY THR          
SEQRES  16 B  280  ASP GLU MET ALA LEU GLY VAL ILE HIS GLY ALA GLN ASP          
SEQRES  17 B  280  ARG GLY LEU ASN VAL PRO ASN ASP LEU GLU ILE ILE GLY          
SEQRES  18 B  280  PHE ASP ASN THR ARG LEU SER THR MET VAL ARG PRO GLN          
SEQRES  19 B  280  LEU THR SER VAL VAL GLN PRO MET TYR ASP ILE GLY ALA          
SEQRES  20 B  280  VAL ALA MET ARG LEU LEU THR LYS TYR MET ASN LYS GLU          
SEQRES  21 B  280  THR VAL ASP SER SER ILE VAL GLN LEU PRO HIS ARG ILE          
SEQRES  22 B  280  GLU PHE ARG GLN SER THR LYS                                  
SEQRES   1 I  280  ARG GLY LEU ALA SER LYS LYS THR THR THR VAL GLY VAL          
SEQRES   2 I  280  ILE ILE PRO ASP ILE SER ASN ILE PHE TYR ALA GLU LEU          
SEQRES   3 I  280  ALA ARG GLY ILE GLU ASP ILE ALA THR MET TYR LYS TYR          
SEQRES   4 I  280  ASN ILE ILE LEU SER ASN SER ASP GLN ASN GLN ASP LYS          
SEQRES   5 I  280  GLU LEU HIS LEU LEU ASN ASN MET LEU GLY LYS GLN VAL          
SEQRES   6 I  280  ASP GLY ILE ILE PHE MET SER GLY ASN VAL THR GLU GLU          
SEQRES   7 I  280  HIS VAL GLU GLU LEU LYS LYS SER PRO VAL PRO VAL VAL          
SEQRES   8 I  280  LEU ALA ALA SER ILE GLU SER THR ASN GLN ILE PRO SER          
SEQRES   9 I  280  VAL THR ILE ASP TYR GLU GLN ALA ALA PHE ASP ALA VAL          
SEQRES  10 I  280  GLN SER LEU ILE ASP SER GLY HIS LYS ASN ILE ALA PHE          
SEQRES  11 I  280  VAL SER GLY THR LEU GLU GLU PRO ILE ASN HIS ALA LYS          
SEQRES  12 I  280  LYS VAL LYS GLY TYR LYS ARG ALA LEU THR GLU SER GLY          
SEQRES  13 I  280  LEU PRO VAL ARG ASP SER TYR ILE VAL GLU GLY ASP TYR          
SEQRES  14 I  280  THR TYR ASP SER GLY ILE GLU ALA VAL GLU LYS LEU LEU          
SEQRES  15 I  280  GLU GLU ASP GLU LYS PRO THR ALA ILE PHE VAL GLY THR          
SEQRES  16 I  280  ASP GLU MET ALA LEU GLY VAL ILE HIS GLY ALA GLN ASP          
SEQRES  17 I  280  ARG GLY LEU ASN VAL PRO ASN ASP LEU GLU ILE ILE GLY          
SEQRES  18 I  280  PHE ASP ASN THR ARG LEU SER THR MET VAL ARG PRO GLN          
SEQRES  19 I  280  LEU THR SER VAL VAL GLN PRO MET TYR ASP ILE GLY ALA          
SEQRES  20 I  280  VAL ALA MET ARG LEU LEU THR LYS TYR MET ASN LYS GLU          
SEQRES  21 I  280  THR VAL ASP SER SER ILE VAL GLN LEU PRO HIS ARG ILE          
SEQRES  22 I  280  GLU PHE ARG GLN SER THR LYS                                  
SEQRES   1 P  280  ARG GLY LEU ALA SER LYS LYS THR THR THR VAL GLY VAL          
SEQRES   2 P  280  ILE ILE PRO ASP ILE SER ASN ILE PHE TYR ALA GLU LEU          
SEQRES   3 P  280  ALA ARG GLY ILE GLU ASP ILE ALA THR MET TYR LYS TYR          
SEQRES   4 P  280  ASN ILE ILE LEU SER ASN SER ASP GLN ASN GLN ASP LYS          
SEQRES   5 P  280  GLU LEU HIS LEU LEU ASN ASN MET LEU GLY LYS GLN VAL          
SEQRES   6 P  280  ASP GLY ILE ILE PHE MET SER GLY ASN VAL THR GLU GLU          
SEQRES   7 P  280  HIS VAL GLU GLU LEU LYS LYS SER PRO VAL PRO VAL VAL          
SEQRES   8 P  280  LEU ALA ALA SER ILE GLU SER THR ASN GLN ILE PRO SER          
SEQRES   9 P  280  VAL THR ILE ASP TYR GLU GLN ALA ALA PHE ASP ALA VAL          
SEQRES  10 P  280  GLN SER LEU ILE ASP SER GLY HIS LYS ASN ILE ALA PHE          
SEQRES  11 P  280  VAL SER GLY THR LEU GLU GLU PRO ILE ASN HIS ALA LYS          
SEQRES  12 P  280  LYS VAL LYS GLY TYR LYS ARG ALA LEU THR GLU SER GLY          
SEQRES  13 P  280  LEU PRO VAL ARG ASP SER TYR ILE VAL GLU GLY ASP TYR          
SEQRES  14 P  280  THR TYR ASP SER GLY ILE GLU ALA VAL GLU LYS LEU LEU          
SEQRES  15 P  280  GLU GLU ASP GLU LYS PRO THR ALA ILE PHE VAL GLY THR          
SEQRES  16 P  280  ASP GLU MET ALA LEU GLY VAL ILE HIS GLY ALA GLN ASP          
SEQRES  17 P  280  ARG GLY LEU ASN VAL PRO ASN ASP LEU GLU ILE ILE GLY          
SEQRES  18 P  280  PHE ASP ASN THR ARG LEU SER THR MET VAL ARG PRO GLN          
SEQRES  19 P  280  LEU THR SER VAL VAL GLN PRO MET TYR ASP ILE GLY ALA          
SEQRES  20 P  280  VAL ALA MET ARG LEU LEU THR LYS TYR MET ASN LYS GLU          
SEQRES  21 P  280  THR VAL ASP SER SER ILE VAL GLN LEU PRO HIS ARG ILE          
SEQRES  22 P  280  GLU PHE ARG GLN SER THR LYS                                  
SEQRES   1 F  280  ARG GLY LEU ALA SER LYS LYS THR THR THR VAL GLY VAL          
SEQRES   2 F  280  ILE ILE PRO ASP ILE SER ASN ILE PHE TYR ALA GLU LEU          
SEQRES   3 F  280  ALA ARG GLY ILE GLU ASP ILE ALA THR MET TYR LYS TYR          
SEQRES   4 F  280  ASN ILE ILE LEU SER ASN SER ASP GLN ASN GLN ASP LYS          
SEQRES   5 F  280  GLU LEU HIS LEU LEU ASN ASN MET LEU GLY LYS GLN VAL          
SEQRES   6 F  280  ASP GLY ILE ILE PHE MET SER GLY ASN VAL THR GLU GLU          
SEQRES   7 F  280  HIS VAL GLU GLU LEU LYS LYS SER PRO VAL PRO VAL VAL          
SEQRES   8 F  280  LEU ALA ALA SER ILE GLU SER THR ASN GLN ILE PRO SER          
SEQRES   9 F  280  VAL THR ILE ASP TYR GLU GLN ALA ALA PHE ASP ALA VAL          
SEQRES  10 F  280  GLN SER LEU ILE ASP SER GLY HIS LYS ASN ILE ALA PHE          
SEQRES  11 F  280  VAL SER GLY THR LEU GLU GLU PRO ILE ASN HIS ALA LYS          
SEQRES  12 F  280  LYS VAL LYS GLY TYR LYS ARG ALA LEU THR GLU SER GLY          
SEQRES  13 F  280  LEU PRO VAL ARG ASP SER TYR ILE VAL GLU GLY ASP TYR          
SEQRES  14 F  280  THR TYR ASP SER GLY ILE GLU ALA VAL GLU LYS LEU LEU          
SEQRES  15 F  280  GLU GLU ASP GLU LYS PRO THR ALA ILE PHE VAL GLY THR          
SEQRES  16 F  280  ASP GLU MET ALA LEU GLY VAL ILE HIS GLY ALA GLN ASP          
SEQRES  17 F  280  ARG GLY LEU ASN VAL PRO ASN ASP LEU GLU ILE ILE GLY          
SEQRES  18 F  280  PHE ASP ASN THR ARG LEU SER THR MET VAL ARG PRO GLN          
SEQRES  19 F  280  LEU THR SER VAL VAL GLN PRO MET TYR ASP ILE GLY ALA          
SEQRES  20 F  280  VAL ALA MET ARG LEU LEU THR LYS TYR MET ASN LYS GLU          
SEQRES  21 F  280  THR VAL ASP SER SER ILE VAL GLN LEU PRO HIS ARG ILE          
SEQRES  22 F  280  GLU PHE ARG GLN SER THR LYS                                  
HET    171   3256      13                                                       
HET    171   5256      13                                                       
HETNAM     171 2-PHENYLAMINO-ETHANESULFONIC ACID                                
FORMUL   7  171    2(C8 H11 N O3 S)                                             
FORMUL   9  HOH   *139(H2 O)                                                    
CRYST1  375.390   60.140   75.650  90.00  95.59  90.00 C 1 2 1      24          
ATOM      1  N   LYS A  58      50.865  87.899   1.631  1.00 28.49           N  
ATOM      2  CA  LYS A  58      52.331  87.985   1.841  1.00 28.91           C  
ATOM      3  C   LYS A  58      52.652  87.774   3.315  1.00 30.07           C  
ATOM      4  O   LYS A  58      53.423  86.874   3.667  1.00 31.91           O  
ATOM      5  CB  LYS A  58      52.853  89.353   1.412  1.00 29.72           C  
ATOM      6  CG  LYS A  58      54.158  89.329   0.635  1.00 30.26           C  
ATOM      7  CD  LYS A  58      53.913  88.984  -0.815  1.00 31.93           C  
ATOM      8  CE  LYS A  58      55.204  88.986  -1.619  1.00 34.82           C  
ATOM      9  NZ  LYS A  58      56.206  87.956  -1.156  1.00 34.43           N  
ATOM     10  N   LYS A  59      52.053  88.590   4.180  1.00 29.20           N  
ATOM     11  CA  LYS A  59      52.308  88.501   5.618  1.00 29.09           C  
ATOM     12  C   LYS A  59      52.220  87.068   6.127  1.00 30.14           C  
ATOM     13  O   LYS A  59      51.141  86.476   6.191  1.00 30.69           O  
ATOM     14  CB  LYS A  59      51.324  89.385   6.382  1.00 28.12           C  
ATOM     15  CG  LYS A  59      51.904  90.010   7.656  1.00 28.17           C  
ATOM     16  CD  LYS A  59      51.673  89.180   8.900  1.00 27.20           C  
ATOM     17  CE  LYS A  59      50.182  89.107   9.246  1.00 28.00           C  
ATOM     18  NZ  LYS A  59      49.900  88.180  10.384  1.00 26.31           N  
ATOM     19  N   THR A  60      53.360  86.500   6.486  1.00 30.14           N  
ATOM     20  CA  THR A  60      53.353  85.134   6.975  1.00 30.71           C  
ATOM     21  C   THR A  60      52.292  84.972   8.044  1.00 31.00           C  
ATOM     22  O   THR A  60      52.226  85.755   8.977  1.00 30.26           O  
ATOM     23  CB  THR A  60      54.690  84.732   7.598  1.00 30.56           C  
ATOM     24  OG1 THR A  60      55.723  84.789   6.607  1.00 31.42           O  
ATOM     25  CG2 THR A  60      54.592  83.331   8.139  1.00 28.16           C  
ATOM     26  N   THR A  61      51.467  83.946   7.902  1.00 32.56           N  
ATOM     27  CA  THR A  61      50.416  83.664   8.862  1.00 33.57           C  
ATOM     28  C   THR A  61      50.949  82.777   9.986  1.00 33.31           C  
ATOM     29  O   THR A  61      51.709  81.842   9.730  1.00 33.72           O  
ATOM     30  CB  THR A  61      49.259  82.938   8.183  1.00 35.25           C  
ATOM     31  OG1 THR A  61      48.744  83.761   7.128  1.00 36.21           O  
ATOM     32  CG2 THR A  61      48.153  82.622   9.199  1.00 35.81           C  
ATOM     33  N   THR A  62      50.563  83.074  11.225  1.00 32.23           N  
ATOM     34  CA  THR A  62      50.997  82.268  12.363  1.00 32.39           C  
ATOM     35  C   THR A  62      49.817  81.794  13.228  1.00 30.14           C  
ATOM     36  O   THR A  62      48.962  82.580  13.625  1.00 28.75           O  
ATOM     37  CB  THR A  62      51.991  83.027  13.253  1.00 33.61           C  
ATOM     38  OG1 THR A  62      52.182  82.295  14.466  1.00 37.69           O  
ATOM     39  CG2 THR A  62      51.470  84.391  13.593  1.00 36.62           C  
ATOM     40  N   VAL A  63      49.762  80.495  13.506  1.00 27.37           N  
ATOM     41  CA  VAL A  63      48.676  79.991  14.313  1.00 24.92           C  
ATOM     42  C   VAL A  63      49.190  79.555  15.677  1.00 23.40           C  
ATOM     43  O   VAL A  63      50.324  79.071  15.824  1.00 19.20           O  
ATOM     44  CB  VAL A  63      47.916  78.824  13.609  1.00 25.61           C  
ATOM     45  CG1 VAL A  63      47.893  79.042  12.099  1.00 23.02           C  
ATOM     46  CG2 VAL A  63      48.526  77.506  13.963  1.00 26.18           C  
ATOM     47  N   GLY A  64      48.343  79.770  16.678  1.00 22.86           N  
ATOM     48  CA  GLY A  64      48.702  79.432  18.035  1.00 21.88           C  
ATOM     49  C   GLY A  64      48.070  78.124  18.393  1.00 22.61           C  
ATOM     50  O   GLY A  64      46.939  77.843  17.986  1.00 24.01           O  
ATOM     51  N   VAL A  65      48.799  77.312  19.145  1.00 22.84           N  
ATOM     52  CA  VAL A  65      48.285  76.019  19.556  1.00 25.30           C  
ATOM     53  C   VAL A  65      48.476  75.847  21.045  1.00 26.49           C  
ATOM     54  O   VAL A  65      49.568  76.053  21.572  1.00 26.42           O  
ATOM     55  CB  VAL A  65      49.025  74.843  18.864  1.00 25.65           C  
ATOM     56  CG1 VAL A  65      48.223  73.561  19.032  1.00 24.15           C  
ATOM     57  CG2 VAL A  65      49.263  75.148  17.398  1.00 26.01           C  
ATOM     58  N   ILE A  66      47.413  75.492  21.745  1.00 28.11           N  
ATOM     59  CA  ILE A  66      47.583  75.263  23.162  1.00 29.47           C  
ATOM     60  C   ILE A  66      47.126  73.882  23.532  1.00 27.39           C  
ATOM     61  O   ILE A  66      46.072  73.417  23.097  1.00 26.36           O  
ATOM     62  CB  ILE A  66      46.857  76.313  24.052  1.00 32.14           C  
ATOM     63  CG1 ILE A  66      45.504  76.682  23.464  1.00 33.15           C  
ATOM     64  CG2 ILE A  66      47.753  77.543  24.218  1.00 34.38           C  
ATOM     65  CD1 ILE A  66      44.958  77.999  24.015  1.00 39.85           C  
ATOM     66  N   ILE A  67      47.966  73.223  24.317  1.00 26.42           N  
ATOM     67  CA  ILE A  67      47.684  71.894  24.793  1.00 26.14           C  
ATOM     68  C   ILE A  67      47.538  72.001  26.299  1.00 26.70           C  
ATOM     69  O   ILE A  67      48.124  72.882  26.935  1.00 21.26           O  
ATOM     70  CB  ILE A  67      48.814  70.916  24.423  1.00 26.08           C  
ATOM     71  CG1 ILE A  67      50.122  71.320  25.121  1.00 26.86           C  
ATOM     72  CG2 ILE A  67      48.974  70.904  22.913  1.00 23.01           C  
ATOM     73  CD1 ILE A  67      51.270  70.367  24.891  1.00 36.03           C  
ATOM     74  N   PRO A  68      46.736  71.102  26.886  1.00 29.78           N  
ATOM     75  CA  PRO A  68      46.502  71.096  28.329  1.00 33.40           C  
ATOM     76  C   PRO A  68      47.705  70.674  29.176  1.00 35.17           C  
ATOM     77  O   PRO A  68      47.854  71.139  30.299  1.00 35.55           O  
ATOM     78  CB  PRO A  68      45.300  70.166  28.470  1.00 32.29           C  
ATOM     79  CG  PRO A  68      45.501  69.209  27.381  1.00 32.11           C  
ATOM     80  CD  PRO A  68      45.948  70.051  26.222  1.00 29.77           C  
ATOM     81  N   ASP A  69      48.562  69.808  28.648  1.00 37.05           N  
ATOM     82  CA  ASP A  69      49.728  69.412  29.415  1.00 40.96           C  
ATOM     83  C   ASP A  69      50.798  68.595  28.696  1.00 43.18           C  
ATOM     84  O   ASP A  69      50.628  68.154  27.560  1.00 44.04           O  
ATOM     85  CB  ASP A  69      49.286  68.675  30.682  1.00 43.41           C  
ATOM     86  CG  ASP A  69      48.545  67.387  30.387  1.00 45.68           C  
ATOM     87  OD1 ASP A  69      49.161  66.469  29.799  1.00 45.02           O  
ATOM     88  OD2 ASP A  69      47.346  67.294  30.750  1.00 48.12           O  
ATOM     89  N   ILE A  70      51.918  68.415  29.382  1.00 45.61           N  
ATOM     90  CA  ILE A  70      53.043  67.650  28.872  1.00 48.26           C  
ATOM     91  C   ILE A  70      52.856  66.161  29.177  1.00 48.54           C  
ATOM     92  O   ILE A  70      53.469  65.306  28.535  1.00 49.16           O  
ATOM     93  CB  ILE A  70      54.349  68.183  29.499  1.00 50.48           C  
ATOM     94  CG1 ILE A  70      54.875  69.333  28.641  1.00 50.87           C  
ATOM     95  CG2 ILE A  70      55.374  67.062  29.693  1.00 52.88           C  
ATOM     96  CD1 ILE A  70      53.903  70.472  28.513  1.00 46.28           C  
ATOM     97  N   SER A  71      52.002  65.864  30.156  1.00 48.46           N  
ATOM     98  CA  SER A  71      51.705  64.487  30.550  1.00 48.33           C  
ATOM     99  C   SER A  71      51.085  63.692  29.409  1.00 47.93           C  
ATOM    100  O   SER A  71      51.792  63.026  28.663  1.00 48.48           O  
ATOM    101  CB  SER A  71      50.743  64.462  31.737  1.00 48.10           C  
ATOM    102  OG  SER A  71      51.393  64.886  32.911  1.00 51.34           O  
ATOM    103  N   ASN A  72      49.758  63.770  29.296  1.00 47.82           N  
ATOM    104  CA  ASN A  72      48.974  63.072  28.269  1.00 45.68           C  
ATOM    105  C   ASN A  72      49.570  63.241  26.869  1.00 44.73           C  
ATOM    106  O   ASN A  72      49.190  64.145  26.126  1.00 45.79           O  
ATOM    107  CB  ASN A  72      47.545  63.608  28.279  1.00 45.17           C  
ATOM    108  CG  ASN A  72      46.557  62.640  27.677  1.00 46.49           C  
ATOM    109  OD1 ASN A  72      46.922  61.767  26.882  1.00 46.97           O  
ATOM    110  ND2 ASN A  72      45.284  62.797  28.044  1.00 46.29           N  
ATOM    111  N   ILE A  73      50.481  62.344  26.504  1.00 43.16           N  
ATOM    112  CA  ILE A  73      51.160  62.420  25.224  1.00 40.91           C  
ATOM    113  C   ILE A  73      50.251  62.461  24.011  1.00 39.77           C  
ATOM    114  O   ILE A  73      50.717  62.747  22.920  1.00 42.00           O  
ATOM    115  CB  ILE A  73      52.226  61.259  25.042  1.00 42.54           C  
ATOM    116  CG1 ILE A  73      51.645  60.066  24.269  1.00 40.17           C  
ATOM    117  CG2 ILE A  73      52.746  60.806  26.409  1.00 43.22           C  
ATOM    118  CD1 ILE A  73      50.690  59.229  25.043  1.00 42.45           C  
ATOM    119  N   PHE A  74      48.965  62.178  24.164  1.00 37.86           N  
ATOM    120  CA  PHE A  74      48.104  62.246  22.990  1.00 35.70           C  
ATOM    121  C   PHE A  74      48.013  63.694  22.513  1.00 35.44           C  
ATOM    122  O   PHE A  74      48.121  63.974  21.324  1.00 35.21           O  
ATOM    123  CB  PHE A  74      46.703  61.716  23.290  1.00 34.03           C  
ATOM    124  CG  PHE A  74      45.649  62.234  22.345  1.00 32.41           C  
ATOM    125  CD1 PHE A  74      44.770  63.234  22.749  1.00 30.71           C  
ATOM    126  CD2 PHE A  74      45.549  61.740  21.043  1.00 31.74           C  
ATOM    127  CE1 PHE A  74      43.808  63.738  21.868  1.00 31.28           C  
ATOM    128  CE2 PHE A  74      44.586  62.243  20.157  1.00 31.19           C  
ATOM    129  CZ  PHE A  74      43.715  63.243  20.572  1.00 30.22           C  
ATOM    130  N   TYR A  75      47.815  64.616  23.447  1.00 35.39           N  
ATOM    131  CA  TYR A  75      47.713  66.021  23.091  1.00 35.07           C  
ATOM    132  C   TYR A  75      48.949  66.491  22.341  1.00 35.20           C  
ATOM    133  O   TYR A  75      48.835  67.129  21.287  1.00 35.40           O  
ATOM    134  CB  TYR A  75      47.489  66.867  24.344  1.00 34.98           C  
ATOM    135  CG  TYR A  75      46.079  66.748  24.879  1.00 38.11           C  
ATOM    136  CD1 TYR A  75      44.981  67.077  24.081  1.00 39.34           C  
ATOM    137  CD2 TYR A  75      45.838  66.273  26.162  1.00 38.52           C  
ATOM    138  CE1 TYR A  75      43.688  66.931  24.543  1.00 39.95           C  
ATOM    139  CE2 TYR A  75      44.545  66.125  26.638  1.00 39.98           C  
ATOM    140  CZ  TYR A  75      43.471  66.452  25.823  1.00 41.73           C  
ATOM    141  OH  TYR A  75      42.176  66.288  26.292  1.00 45.42           O  
ATOM    142  N   ALA A  76      50.123  66.159  22.871  1.00 34.14           N  
ATOM    143  CA  ALA A  76      51.391  66.546  22.255  1.00 33.65           C  
ATOM    144  C   ALA A  76      51.515  65.991  20.835  1.00 33.44           C  
ATOM    145  O   ALA A  76      51.944  66.694  19.905  1.00 31.83           O  
ATOM    146  CB  ALA A  76      52.543  66.054  23.106  1.00 34.44           C  
ATOM    147  N   GLU A  77      51.148  64.723  20.674  1.00 32.60           N  
ATOM    148  CA  GLU A  77      51.191  64.094  19.366  1.00 32.34           C  
ATOM    149  C   GLU A  77      50.253  64.843  18.428  1.00 31.29           C  
ATOM    150  O   GLU A  77      50.617  65.151  17.300  1.00 30.68           O  
ATOM    151  CB  GLU A  77      50.810  62.612  19.474  1.00 33.10           C  
ATOM    152  CG  GLU A  77      51.991  61.733  19.872  1.00 36.99           C  
ATOM    153  CD  GLU A  77      51.634  60.261  20.067  1.00 39.49           C  
ATOM    154  OE1 GLU A  77      50.965  59.676  19.177  1.00 40.39           O  
ATOM    155  OE2 GLU A  77      52.040  59.691  21.108  1.00 36.72           O  
ATOM    156  N   LEU A  78      49.055  65.159  18.903  1.00 32.18           N  
ATOM    157  CA  LEU A  78      48.091  65.895  18.089  1.00 33.58           C  
ATOM    158  C   LEU A  78      48.654  67.272  17.734  1.00 33.95           C  
ATOM    159  O   LEU A  78      48.485  67.753  16.615  1.00 33.26           O  
ATOM    160  CB  LEU A  78      46.773  66.084  18.844  1.00 34.66           C  
ATOM    161  CG  LEU A  78      45.428  65.998  18.097  1.00 33.39           C  
ATOM    162  CD1 LEU A  78      44.380  66.694  18.941  1.00 36.82           C  
ATOM    163  CD2 LEU A  78      45.483  66.633  16.735  1.00 33.48           C  
ATOM    164  N   ALA A  79      49.311  67.917  18.693  1.00 34.49           N  
ATOM    165  CA  ALA A  79      49.887  69.231  18.430  1.00 35.79           C  
ATOM    166  C   ALA A  79      50.877  69.062  17.294  1.00 36.88           C  
ATOM    167  O   ALA A  79      50.952  69.877  16.369  1.00 36.60           O  
ATOM    168  CB  ALA A  79      50.596  69.769  19.663  1.00 34.20           C  
ATOM    169  N   ARG A  80      51.644  67.986  17.369  1.00 38.13           N  
ATOM    170  CA  ARG A  80      52.617  67.712  16.333  1.00 39.81           C  
ATOM    171  C   ARG A  80      51.904  67.471  15.016  1.00 39.67           C  
ATOM    172  O   ARG A  80      52.373  67.904  13.967  1.00 41.42           O  
ATOM    173  CB  ARG A  80      53.448  66.493  16.701  1.00 41.92           C  
ATOM    174  CG  ARG A  80      54.795  66.843  17.226  1.00 43.81           C  
ATOM    175  CD  ARG A  80      55.796  66.017  16.461  1.00 48.46           C  
ATOM    176  NE  ARG A  80      57.122  66.623  16.447  1.00 49.50           N  
ATOM    177  CZ  ARG A  80      57.364  67.866  16.053  1.00 48.91           C  
ATOM    178  NH1 ARG A  80      56.373  68.647  15.647  1.00 47.00           N  
ATOM    179  NH2 ARG A  80      58.607  68.318  16.049  1.00 51.74           N  
ATOM    180  N   GLY A  81      50.770  66.779  15.072  1.00 38.26           N  
ATOM    181  CA  GLY A  81      50.020  66.518  13.857  1.00 37.06           C  
ATOM    182  C   GLY A  81      49.535  67.820  13.251  1.00 36.00           C  
ATOM    183  O   GLY A  81      49.543  68.000  12.040  1.00 35.58           O  
ATOM    184  N   ILE A  82      49.112  68.736  14.113  1.00 35.70           N  
ATOM    185  CA  ILE A  82      48.629  70.027  13.669  1.00 36.55           C  
ATOM    186  C   ILE A  82      49.783  70.803  13.024  1.00 37.48           C  
ATOM    187  O   ILE A  82      49.665  71.311  11.909  1.00 36.42           O  
ATOM    188  CB  ILE A  82      48.007  70.779  14.868  1.00 36.29           C  
ATOM    189  CG1 ILE A  82      46.693  70.083  15.252  1.00 37.45           C  
ATOM    190  CG2 ILE A  82      47.754  72.230  14.523  1.00 34.72           C  
ATOM    191  CD1 ILE A  82      46.228  70.298  16.673  1.00 40.52           C  
ATOM    192  N   GLU A  83      50.912  70.865  13.712  1.00 38.92           N  
ATOM    193  CA  GLU A  83      52.070  71.557  13.176  1.00 40.19           C  
ATOM    194  C   GLU A  83      52.429  71.030  11.787  1.00 41.11           C  
ATOM    195  O   GLU A  83      52.775  71.791  10.891  1.00 42.49           O  
ATOM    196  CB  GLU A  83      53.254  71.390  14.120  1.00 39.39           C  
ATOM    197  CG  GLU A  83      54.572  71.744  13.491  1.00 39.18           C  
ATOM    198  CD  GLU A  83      55.586  72.150  14.516  1.00 38.69           C  
ATOM    199  OE1 GLU A  83      55.609  71.520  15.591  1.00 39.03           O  
ATOM    200  OE2 GLU A  83      56.363  73.092  14.243  1.00 38.60           O  
ATOM    201  N   ASP A  84      52.342  69.723  11.608  1.00 42.76           N  
ATOM    202  CA  ASP A  84      52.652  69.121  10.321  1.00 43.85           C  
ATOM    203  C   ASP A  84      51.793  69.690   9.198  1.00 43.01           C  
ATOM    204  O   ASP A  84      52.306  70.182   8.191  1.00 42.13           O  
ATOM    205  CB  ASP A  84      52.453  67.612  10.401  1.00 46.28           C  
ATOM    206  CG  ASP A  84      53.744  66.856  10.223  1.00 49.32           C  
ATOM    207  OD1 ASP A  84      54.229  66.806   9.074  1.00 51.21           O  
ATOM    208  OD2 ASP A  84      54.274  66.324  11.226  1.00 51.20           O  
ATOM    209  N   ILE A  85      50.479  69.607   9.376  1.00 42.04           N  
ATOM    210  CA  ILE A  85      49.547  70.108   8.384  1.00 40.34           C  
ATOM    211  C   ILE A  85      49.778  71.594   8.182  1.00 38.98           C  
ATOM    212  O   ILE A  85      49.648  72.114   7.078  1.00 38.72           O  
ATOM    213  CB  ILE A  85      48.095  69.894   8.843  1.00 41.35           C  
ATOM    214  CG1 ILE A  85      47.812  68.396   8.978  1.00 41.18           C  
ATOM    215  CG2 ILE A  85      47.129  70.563   7.858  1.00 41.53           C  
ATOM    216  CD1 ILE A  85      47.975  67.628   7.680  1.00 43.78           C  
ATOM    217  N   ALA A  86      50.136  72.276   9.256  1.00 38.02           N  
ATOM    218  CA  ALA A  86      50.351  73.707   9.173  1.00 38.32           C  
ATOM    219  C   ALA A  86      51.549  74.051   8.306  1.00 38.59           C  
ATOM    220  O   ALA A  86      51.537  75.052   7.587  1.00 38.80           O  
ATOM    221  CB  ALA A  86      50.520  74.288  10.556  1.00 36.48           C  
ATOM    222  N   THR A  87      52.580  73.222   8.363  1.00 38.92           N  
ATOM    223  CA  THR A  87      53.777  73.470   7.573  1.00 39.60           C  
ATOM    224  C   THR A  87      53.488  73.516   6.075  1.00 39.42           C  
ATOM    225  O   THR A  87      54.119  74.271   5.339  1.00 40.75           O  
ATOM    226  CB  THR A  87      54.850  72.406   7.849  1.00 39.15           C  
ATOM    227  OG1 THR A  87      55.322  72.550   9.191  1.00 40.70           O  
ATOM    228  CG2 THR A  87      56.018  72.570   6.903  1.00 41.40           C  
ATOM    229  N   MET A  88      52.529  72.721   5.620  1.00 39.14           N  
ATOM    230  CA  MET A  88      52.189  72.701   4.205  1.00 38.50           C  
ATOM    231  C   MET A  88      51.382  73.926   3.792  1.00 36.92           C  
ATOM    232  O   MET A  88      51.427  74.344   2.636  1.00 36.27           O  
ATOM    233  CB  MET A  88      51.483  71.391   3.876  1.00 40.18           C  
ATOM    234  CG  MET A  88      52.444  70.215   4.067  1.00 43.32           C  
ATOM    235  SD  MET A  88      51.735  68.605   3.810  1.00 48.36           S  
ATOM    236  CE  MET A  88      50.241  68.805   4.857  1.00 46.17           C  
ATOM    237  N   TYR A  89      50.659  74.508   4.744  1.00 35.17           N  
ATOM    238  CA  TYR A  89      49.913  75.735   4.483  1.00 32.97           C  
ATOM    239  C   TYR A  89      50.980  76.822   4.470  1.00 32.19           C  
ATOM    240  O   TYR A  89      50.785  77.903   3.935  1.00 31.68           O  
ATOM    241  CB  TYR A  89      48.917  76.029   5.613  1.00 30.39           C  
ATOM    242  CG  TYR A  89      47.569  75.348   5.490  1.00 26.93           C  
ATOM    243  CD1 TYR A  89      46.437  76.072   5.118  1.00 23.42           C  
ATOM    244  CD2 TYR A  89      47.420  73.984   5.764  1.00 26.10           C  
ATOM    245  CE1 TYR A  89      45.194  75.463   5.024  1.00 22.15           C  
ATOM    246  CE2 TYR A  89      46.176  73.365   5.673  1.00 23.76           C  
ATOM    247  CZ  TYR A  89      45.076  74.116   5.302  1.00 23.07           C  
ATOM    248  OH  TYR A  89      43.859  73.516   5.193  1.00 24.79           O  
ATOM    249  N   LYS A  90      52.115  76.496   5.075  1.00 33.19           N  
ATOM    250  CA  LYS A  90      53.258  77.388   5.190  1.00 34.71           C  
ATOM    251  C   LYS A  90      53.073  78.357   6.349  1.00 35.39           C  
ATOM    252  O   LYS A  90      53.702  79.407   6.395  1.00 35.97           O  
ATOM    253  CB  LYS A  90      53.483  78.155   3.892  1.00 35.50           C  
ATOM    254  CG  LYS A  90      54.810  77.839   3.234  1.00 38.59           C  
ATOM    255  CD  LYS A  90      54.930  76.380   2.846  1.00 38.86           C  
ATOM    256  CE  LYS A  90      56.288  76.114   2.228  1.00 42.31           C  
ATOM    257  NZ  LYS A  90      57.414  76.497   3.147  1.00 42.82           N  
ATOM    258  N   TYR A  91      52.216  77.977   7.290  1.00 35.24           N  
ATOM    259  CA  TYR A  91      51.924  78.775   8.470  1.00 35.60           C  
ATOM    260  C   TYR A  91      53.010  78.640   9.535  1.00 36.88           C  
ATOM    261  O   TYR A  91      53.839  77.735   9.484  1.00 37.11           O  
ATOM    262  CB  TYR A  91      50.624  78.295   9.106  1.00 34.77           C  
ATOM    263  CG  TYR A  91      49.359  78.522   8.324  1.00 34.05           C  
ATOM    264  CD1 TYR A  91      48.247  77.718   8.547  1.00 33.30           C  
ATOM    265  CD2 TYR A  91      49.240  79.572   7.421  1.00 34.51           C  
ATOM    266  CE1 TYR A  91      47.053  77.952   7.903  1.00 32.21           C  
ATOM    267  CE2 TYR A  91      48.039  79.813   6.768  1.00 32.80           C  
ATOM    268  CZ  TYR A  91      46.953  78.994   7.021  1.00 32.21           C  
ATOM    269  OH  TYR A  91      45.747  79.204   6.409  1.00 33.21           O  
ATOM    270  N   ASN A  92      52.980  79.542  10.511  1.00 37.90           N  
ATOM    271  CA  ASN A  92      53.896  79.479  11.639  1.00 38.84           C  
ATOM    272  C   ASN A  92      53.086  78.915  12.784  1.00 38.26           C  
ATOM    273  O   ASN A  92      51.857  79.073  12.833  1.00 37.84           O  
ATOM    274  CB  ASN A  92      54.410  80.854  12.049  1.00 43.21           C  
ATOM    275  CG  ASN A  92      55.438  81.397  11.093  1.00 44.66           C  
ATOM    276  OD1 ASN A  92      55.203  82.394  10.426  1.00 49.02           O  
ATOM    277  ND2 ASN A  92      56.582  80.748  11.021  1.00 43.61           N  
ATOM    278  N   ILE A  93      53.777  78.262  13.707  1.00 36.74           N  
ATOM    279  CA  ILE A  93      53.109  77.672  14.839  1.00 36.43           C  
ATOM    280  C   ILE A  93      53.787  77.985  16.158  1.00 35.81           C  
ATOM    281  O   ILE A  93      54.985  77.775  16.326  1.00 35.89           O  
ATOM    282  CB  ILE A  93      52.999  76.124  14.685  1.00 37.38           C  
ATOM    283  CG1 ILE A  93      51.688  75.743  14.000  1.00 37.10           C  
ATOM    284  CG2 ILE A  93      53.035  75.446  16.046  1.00 38.81           C  
ATOM    285  CD1 ILE A  93      51.527  76.321  12.636  1.00 41.49           C  
ATOM    286  N   ILE A  94      52.995  78.495  17.090  1.00 35.74           N  
ATOM    287  CA  ILE A  94      53.462  78.796  18.441  1.00 34.19           C  
ATOM    288  C   ILE A  94      52.665  77.857  19.349  1.00 32.37           C  
ATOM    289  O   ILE A  94      51.435  77.827  19.302  1.00 31.58           O  
ATOM    290  CB  ILE A  94      53.166  80.245  18.832  1.00 34.65           C  
ATOM    291  CG1 ILE A  94      54.004  81.185  17.968  1.00 35.02           C  
ATOM    292  CG2 ILE A  94      53.430  80.440  20.310  1.00 32.03           C  
ATOM    293  CD1 ILE A  94      53.603  82.631  18.077  1.00 39.65           C  
ATOM    294  N   LEU A  95      53.374  77.091  20.166  1.00 30.47           N  
ATOM    295  CA  LEU A  95      52.750  76.124  21.050  1.00 29.60           C  
ATOM    296  C   LEU A  95      52.909  76.515  22.525  1.00 27.97           C  
ATOM    297  O   LEU A  95      54.016  76.733  22.992  1.00 28.59           O  
ATOM    298  CB  LEU A  95      53.410  74.776  20.792  1.00 31.23           C  
ATOM    299  CG  LEU A  95      52.697  73.438  20.930  1.00 33.09           C  
ATOM    300  CD1 LEU A  95      53.789  72.392  21.101  1.00 32.40           C  
ATOM    301  CD2 LEU A  95      51.744  73.405  22.125  1.00 34.62           C  
ATOM    302  N   SER A  96      51.801  76.604  23.249  1.00 28.25           N  
ATOM    303  CA  SER A  96      51.821  76.947  24.673  1.00 28.01           C  
ATOM    304  C   SER A  96      51.191  75.820  25.475  1.00 28.33           C  
ATOM    305  O   SER A  96      50.375  75.062  24.968  1.00 28.61           O  
ATOM    306  CB  SER A  96      51.040  78.228  24.923  1.00 28.69           C  
ATOM    307  OG  SER A  96      51.894  79.284  25.312  1.00 28.77           O  
ATOM    308  N   ASN A  97      51.583  75.704  26.729  1.00 29.82           N  
ATOM    309  CA  ASN A  97      51.050  74.663  27.596  1.00 31.68           C  
ATOM    310  C   ASN A  97      50.317  75.293  28.779  1.00 33.57           C  
ATOM    311  O   ASN A  97      50.858  76.164  29.453  1.00 35.31           O  
ATOM    312  CB  ASN A  97      52.191  73.777  28.085  1.00 30.39           C  
ATOM    313  CG  ASN A  97      51.783  72.877  29.220  1.00 30.72           C  
ATOM    314  OD1 ASN A  97      50.757  72.200  29.161  1.00 31.18           O  
ATOM    315  ND2 ASN A  97      52.592  72.854  30.267  1.00 32.88           N  
ATOM    316  N   SER A  98      49.100  74.835  29.054  1.00 35.74           N  
ATOM    317  CA  SER A  98      48.315  75.412  30.136  1.00 37.30           C  
ATOM    318  C   SER A  98      48.223  74.663  31.466  1.00 40.22           C  
ATOM    319  O   SER A  98      47.697  75.227  32.430  1.00 41.79           O  
ATOM    320  CB  SER A  98      46.898  75.659  29.644  1.00 33.99           C  
ATOM    321  OG  SER A  98      46.275  74.419  29.381  1.00 31.35           O  
ATOM    322  N   ASP A  99      48.701  73.420  31.541  1.00 41.02           N  
ATOM    323  CA  ASP A  99      48.598  72.651  32.797  1.00 42.93           C  
ATOM    324  C   ASP A  99      47.134  72.588  33.290  1.00 43.93           C  
ATOM    325  O   ASP A  99      46.857  72.432  34.483  1.00 43.78           O  
ATOM    326  CB  ASP A  99      49.459  73.292  33.881  1.00 42.94           C  
ATOM    327  CG  ASP A  99      50.904  73.403  33.477  1.00 44.73           C  
ATOM    328  OD1 ASP A  99      51.583  72.354  33.413  1.00 44.98           O  
ATOM    329  OD2 ASP A  99      51.362  74.539  33.215  1.00 45.81           O  
ATOM    330  N   GLN A 100      46.213  72.722  32.341  1.00 44.91           N  
ATOM    331  CA  GLN A 100      44.772  72.709  32.573  1.00 45.99           C  
ATOM    332  C   GLN A 100      44.207  73.553  33.747  1.00 46.87           C  
ATOM    333  O   GLN A 100      43.329  73.100  34.490  1.00 45.36           O  
ATOM    334  CB  GLN A 100      44.262  71.255  32.654  1.00 47.07           C  
ATOM    335  CG  GLN A 100      42.770  71.082  32.288  1.00 51.69           C  
ATOM    336  CD  GLN A 100      42.501  71.017  30.787  1.00 54.98           C  
ATOM    337  OE1 GLN A 100      41.440  70.564  30.362  1.00 56.96           O  
ATOM    338  NE2 GLN A 100      43.458  71.473  29.985  1.00 57.48           N  
ATOM    339  N   ASN A 101      44.721  74.766  33.941  1.00 46.79           N  
ATOM    340  CA  ASN A 101      44.109  75.620  34.942  1.00 48.73           C  
ATOM    341  C   ASN A 101      43.578  76.796  34.115  1.00 48.59           C  
ATOM    342  O   ASN A 101      44.335  77.527  33.479  1.00 48.61           O  
ATOM    343  CB  ASN A 101      45.086  75.992  36.100  1.00 51.06           C  
ATOM    344  CG  ASN A 101      45.752  77.359  35.964  1.00 50.13           C  
ATOM    345  OD1 ASN A 101      45.152  78.344  35.545  1.00 51.18           O  
ATOM    346  ND2 ASN A 101      47.006  77.423  36.383  1.00 51.02           N  
ATOM    347  N   GLN A 102      42.250  76.898  34.068  1.00 47.64           N  
ATOM    348  CA  GLN A 102      41.548  77.930  33.306  1.00 47.51           C  
ATOM    349  C   GLN A 102      42.297  79.241  33.156  1.00 46.40           C  
ATOM    350  O   GLN A 102      42.403  79.787  32.059  1.00 44.86           O  
ATOM    351  CB  GLN A 102      40.190  78.246  33.932  1.00 47.10           C  
ATOM    352  CG  GLN A 102      39.197  77.121  33.976  1.00 45.66           C  
ATOM    353  CD  GLN A 102      37.803  77.636  34.255  1.00 47.28           C  
ATOM    354  OE1 GLN A 102      36.898  76.870  34.578  1.00 48.95           O  
ATOM    355  NE2 GLN A 102      37.619  78.948  34.119  1.00 46.42           N  
ATOM    356  N   ASP A 103      42.786  79.753  34.277  1.00 46.52           N  
ATOM    357  CA  ASP A 103      43.515  81.005  34.281  1.00 46.45           C  
ATOM    358  C   ASP A 103      44.549  81.032  33.184  1.00 44.48           C  
ATOM    359  O   ASP A 103      44.445  81.838  32.265  1.00 44.75           O  
ATOM    360  CB  ASP A 103      44.168  81.233  35.642  1.00 48.30           C  
ATOM    361  CG  ASP A 103      43.173  81.720  36.682  1.00 50.92           C  
ATOM    362  OD1 ASP A 103      43.528  81.727  37.880  1.00 53.52           O  
ATOM    363  OD2 ASP A 103      42.039  82.104  36.303  1.00 49.60           O  
ATOM    364  N   LYS A 104      45.531  80.142  33.262  1.00 42.60           N  
ATOM    365  CA  LYS A 104      46.574  80.093  32.250  1.00 39.81           C  
ATOM    366  C   LYS A 104      45.943  79.915  30.870  1.00 37.85           C  
ATOM    367  O   LYS A 104      46.372  80.547  29.907  1.00 36.28           O  
ATOM    368  CB  LYS A 104      47.549  78.956  32.551  1.00 40.83           C  
ATOM    369  CG  LYS A 104      48.945  79.184  32.008  1.00 41.57           C  
ATOM    370  CD  LYS A 104      49.894  78.128  32.521  1.00 43.56           C  
ATOM    371  CE  LYS A 104      51.298  78.316  31.976  1.00 44.93           C  
ATOM    372  NZ  LYS A 104      52.193  77.173  32.346  1.00 47.09           N  
ATOM    373  N   GLU A 105      44.917  79.068  30.775  1.00 36.90           N  
ATOM    374  CA  GLU A 105      44.222  78.855  29.497  1.00 35.86           C  
ATOM    375  C   GLU A 105      43.648  80.180  29.007  1.00 35.64           C  
ATOM    376  O   GLU A 105      43.866  80.579  27.857  1.00 34.81           O  
ATOM    377  CB  GLU A 105      43.067  77.856  29.643  1.00 34.80           C  
ATOM    378  CG  GLU A 105      43.483  76.485  30.136  1.00 35.97           C  
ATOM    379  CD  GLU A 105      42.344  75.486  30.150  1.00 35.53           C  
ATOM    380  OE1 GLU A 105      41.323  75.732  30.832  1.00 34.59           O  
ATOM    381  OE2 GLU A 105      42.477  74.442  29.477  1.00 36.50           O  
ATOM    382  N   LEU A 106      42.913  80.855  29.888  1.00 35.08           N  
ATOM    383  CA  LEU A 106      42.301  82.129  29.550  1.00 34.66           C  
ATOM    384  C   LEU A 106      43.333  83.230  29.289  1.00 34.34           C  
ATOM    385  O   LEU A 106      43.109  84.104  28.460  1.00 34.27           O  
ATOM    386  CB  LEU A 106      41.322  82.552  30.654  1.00 35.10           C  
ATOM    387  CG  LEU A 106      40.041  81.709  30.830  1.00 36.95           C  
ATOM    388  CD1 LEU A 106      39.408  81.993  32.184  1.00 37.24           C  
ATOM    389  CD2 LEU A 106      39.051  81.993  29.718  1.00 35.35           C  
ATOM    390  N   HIS A 107      44.465  83.194  29.982  1.00 34.37           N  
ATOM    391  CA  HIS A 107      45.489  84.206  29.765  1.00 34.70           C  
ATOM    392  C   HIS A 107      46.196  83.909  28.459  1.00 36.07           C  
ATOM    393  O   HIS A 107      46.524  84.816  27.703  1.00 35.07           O  
ATOM    394  CB  HIS A 107      46.505  84.221  30.909  1.00 34.36           C  
ATOM    395  CG  HIS A 107      47.665  85.143  30.672  1.00 34.70           C  
ATOM    396  ND1 HIS A 107      48.910  84.689  30.294  1.00 32.68           N  
ATOM    397  CD2 HIS A 107      47.762  86.491  30.743  1.00 33.75           C  
ATOM    398  CE1 HIS A 107      49.723  85.716  30.145  1.00 33.25           C  
ATOM    399  NE2 HIS A 107      49.053  86.821  30.412  1.00 34.07           N  
ATOM    400  N   LEU A 108      46.440  82.629  28.205  1.00 38.37           N  
ATOM    401  CA  LEU A 108      47.081  82.210  26.964  1.00 40.56           C  
ATOM    402  C   LEU A 108      46.325  82.820  25.783  1.00 42.64           C  
ATOM    403  O   LEU A 108      46.912  83.098  24.735  1.00 43.22           O  
ATOM    404  CB  LEU A 108      47.093  80.677  26.854  1.00 38.13           C  
ATOM    405  CG  LEU A 108      48.249  80.019  27.598  1.00 34.30           C  
ATOM    406  CD1 LEU A 108      48.132  78.531  27.540  1.00 33.58           C  
ATOM    407  CD2 LEU A 108      49.546  80.474  26.969  1.00 34.18           C  
ATOM    408  N   LEU A 109      45.020  83.014  25.960  1.00 45.19           N  
ATOM    409  CA  LEU A 109      44.190  83.631  24.933  1.00 48.45           C  
ATOM    410  C   LEU A 109      44.562  85.108  24.755  1.00 50.18           C  
ATOM    411  O   LEU A 109      44.220  85.731  23.759  1.00 51.29           O  
ATOM    412  CB  LEU A 109      42.715  83.521  25.306  1.00 48.30           C  
ATOM    413  CG  LEU A 109      41.961  82.326  24.724  1.00 49.51           C  
ATOM    414  CD1 LEU A 109      42.132  82.331  23.206  1.00 49.96           C  
ATOM    415  CD2 LEU A 109      42.473  81.027  25.322  1.00 50.69           C  
ATOM    416  N   ASN A 110      45.268  85.647  25.740  1.00 52.50           N  
ATOM    417  CA  ASN A 110      45.733  87.030  25.745  1.00 54.04           C  
ATOM    418  C   ASN A 110      47.255  87.082  25.423  1.00 53.65           C  
ATOM    419  O   ASN A 110      47.788  88.117  25.015  1.00 52.41           O  
ATOM    420  CB  ASN A 110      45.423  87.632  27.124  1.00 56.84           C  
ATOM    421  CG  ASN A 110      46.223  88.871  27.418  1.00 59.07           C  
ATOM    422  OD1 ASN A 110      46.112  89.886  26.722  1.00 60.19           O  
ATOM    423  ND2 ASN A 110      47.042  88.799  28.462  1.00 60.27           N  
ATOM    424  N   ASN A 111      47.940  85.953  25.604  1.00 53.51           N  
ATOM    425  CA  ASN A 111      49.367  85.848  25.310  1.00 53.05           C  
ATOM    426  C   ASN A 111      49.534  85.488  23.838  1.00 54.39           C  
ATOM    427  O   ASN A 111      50.567  85.779  23.244  1.00 55.07           O  
ATOM    428  CB  ASN A 111      50.020  84.751  26.148  1.00 52.74           C  
ATOM    429  CG  ASN A 111      51.532  84.681  25.952  1.00 52.73           C  
ATOM    430  OD1 ASN A 111      52.277  85.375  26.627  1.00 53.38           O  
ATOM    431  ND2 ASN A 111      51.982  83.845  25.020  1.00 52.33           N  
ATOM    432  N   MET A 112      48.521  84.843  23.261  1.00 55.48           N  
ATOM    433  CA  MET A 112      48.550  84.443  21.856  1.00 56.85           C  
ATOM    434  C   MET A 112      48.253  85.606  20.931  1.00 59.20           C  
ATOM    435  O   MET A 112      48.762  85.653  19.813  1.00 60.51           O  
ATOM    436  CB  MET A 112      47.539  83.332  21.577  1.00 57.29           C  
ATOM    437  CG  MET A 112      47.843  81.995  22.248  1.00 55.67           C  
ATOM    438  SD  MET A 112      49.593  81.585  22.200  1.00 57.06           S  
ATOM    439  CE  MET A 112      49.888  81.429  20.467  1.00 55.32           C  
ATOM    440  N   LEU A 113      47.413  86.534  21.382  1.00 61.77           N  
ATOM    441  CA  LEU A 113      47.080  87.711  20.583  1.00 62.87           C  
ATOM    442  C   LEU A 113      48.255  88.674  20.710  1.00 63.92           C  
ATOM    443  O   LEU A 113      48.751  89.218  19.723  1.00 63.59           O  
ATOM    444  CB  LEU A 113      45.822  88.382  21.120  1.00 63.85           C  
ATOM    445  CG  LEU A 113      44.599  87.489  21.356  1.00 65.84           C  
ATOM    446  CD1 LEU A 113      43.578  88.233  22.230  1.00 65.00           C  
ATOM    447  CD2 LEU A 113      43.995  87.074  20.030  1.00 65.33           C  
ATOM    448  N   GLY A 114      48.698  88.873  21.946  1.00 65.37           N  
ATOM    449  CA  GLY A 114      49.829  89.751  22.193  1.00 66.83           C  
ATOM    450  C   GLY A 114      51.026  89.283  21.387  1.00 67.34           C  
ATOM    451  O   GLY A 114      51.875  90.094  20.980  1.00 69.03           O  
ATOM    452  N   LYS A 115      51.092  87.970  21.160  1.00 65.62           N  
ATOM    453  CA  LYS A 115      52.165  87.375  20.379  1.00 63.44           C  
ATOM    454  C   LYS A 115      51.725  87.327  18.916  1.00 61.62           C  
ATOM    455  O   LYS A 115      52.254  86.546  18.112  1.00 62.63           O  
ATOM    456  CB  LYS A 115      52.507  85.975  20.915  1.00 62.51           C  
ATOM    457  CG  LYS A 115      53.909  85.532  20.595  1.00 63.46           C  
ATOM    458  CD  LYS A 115      54.961  86.496  21.160  1.00 66.13           C  
ATOM    459  CE  LYS A 115      55.406  86.154  22.598  1.00 67.44           C  
ATOM    460  NZ  LYS A 115      54.447  86.540  23.688  1.00 68.42           N  
ATOM    461  N   GLN A 116      50.729  88.162  18.602  1.00 58.81           N  
ATOM    462  CA  GLN A 116      50.166  88.346  17.249  1.00 57.13           C  
ATOM    463  C   GLN A 116      49.943  87.080  16.407  1.00 54.59           C  
ATOM    464  O   GLN A 116      50.494  86.941  15.310  1.00 55.53           O  
ATOM    465  CB  GLN A 116      51.041  89.406  16.500  1.00 57.56           C  
ATOM    466  CG  GLN A 116      50.985  89.386  14.956  1.00 56.97           C  
ATOM    467  CD  GLN A 116      49.622  89.719  14.358  1.00 56.40           C  
ATOM    468  OE1 GLN A 116      49.197  90.875  14.355  1.00 57.02           O  
ATOM    469  NE2 GLN A 116      48.939  88.703  13.836  1.00 55.61           N  
ATOM    470  N   VAL A 117      49.171  86.136  16.938  1.00 48.78           N  
ATOM    471  CA  VAL A 117      48.872  84.955  16.145  1.00 44.04           C  
ATOM    472  C   VAL A 117      47.568  85.262  15.435  1.00 41.20           C  
ATOM    473  O   VAL A 117      46.725  85.971  15.969  1.00 41.35           O  
ATOM    474  CB  VAL A 117      48.715  83.699  17.009  1.00 43.23           C  
ATOM    475  CG1 VAL A 117      49.981  83.449  17.765  1.00 41.83           C  
ATOM    476  CG2 VAL A 117      47.514  83.852  17.942  1.00 43.80           C  
ATOM    477  N   ASP A 118      47.414  84.731  14.230  1.00 38.62           N  
ATOM    478  CA  ASP A 118      46.218  84.967  13.426  1.00 37.20           C  
ATOM    479  C   ASP A 118      45.075  83.977  13.705  1.00 35.67           C  
ATOM    480  O   ASP A 118      43.937  84.181  13.270  1.00 37.26           O  
ATOM    481  CB  ASP A 118      46.596  84.918  11.940  1.00 37.70           C  
ATOM    482  CG  ASP A 118      47.837  85.765  11.619  1.00 39.83           C  
ATOM    483  OD1 ASP A 118      48.985  85.270  11.780  1.00 37.21           O  
ATOM    484  OD2 ASP A 118      47.657  86.939  11.217  1.00 40.44           O  
ATOM    485  N   GLY A 119      45.378  82.907  14.432  1.00 32.55           N  
ATOM    486  CA  GLY A 119      44.367  81.912  14.729  1.00 28.14           C  
ATOM    487  C   GLY A 119      44.875  80.933  15.761  1.00 26.30           C  
ATOM    488  O   GLY A 119      46.089  80.753  15.926  1.00 24.57           O  
ATOM    489  N   ILE A 120      43.942  80.279  16.442  1.00 24.70           N  
ATOM    490  CA  ILE A 120      44.297  79.340  17.494  1.00 24.98           C  
ATOM    491  C   ILE A 120      43.570  77.998  17.461  1.00 25.41           C  
ATOM    492  O   ILE A 120      42.359  77.931  17.217  1.00 24.27           O  
ATOM    493  CB  ILE A 120      44.012  79.961  18.902  1.00 25.47           C  
ATOM    494  CG1 ILE A 120      44.849  81.223  19.109  1.00 24.93           C  
ATOM    495  CG2 ILE A 120      44.294  78.941  19.994  1.00 19.84           C  
ATOM    496  CD1 ILE A 120      44.269  82.161  20.122  1.00 35.16           C  
ATOM    497  N   ILE A 121      44.326  76.927  17.682  1.00 24.91           N  
ATOM    498  CA  ILE A 121      43.722  75.614  17.817  1.00 25.46           C  
ATOM    499  C   ILE A 121      43.894  75.451  19.324  1.00 24.81           C  
ATOM    500  O   ILE A 121      45.013  75.510  19.853  1.00 21.13           O  
ATOM    501  CB  ILE A 121      44.470  74.488  17.086  1.00 27.90           C  
ATOM    502  CG1 ILE A 121      44.295  74.626  15.578  1.00 28.73           C  
ATOM    503  CG2 ILE A 121      43.935  73.152  17.528  1.00 25.89           C  
ATOM    504  CD1 ILE A 121      45.328  75.514  14.950  1.00 38.90           C  
ATOM    505  N   PHE A 122      42.761  75.300  20.001  1.00 25.23           N  
ATOM    506  CA  PHE A 122      42.680  75.182  21.453  1.00 25.87           C  
ATOM    507  C   PHE A 122      42.266  73.759  21.869  1.00 26.85           C  
ATOM    508  O   PHE A 122      41.218  73.261  21.452  1.00 27.71           O  
ATOM    509  CB  PHE A 122      41.657  76.231  21.935  1.00 25.76           C  
ATOM    510  CG  PHE A 122      41.385  76.235  23.423  1.00 27.08           C  
ATOM    511  CD1 PHE A 122      40.080  76.387  23.887  1.00 26.92           C  
ATOM    512  CD2 PHE A 122      42.412  76.164  24.355  1.00 27.90           C  
ATOM    513  CE1 PHE A 122      39.804  76.469  25.250  1.00 26.35           C  
ATOM    514  CE2 PHE A 122      42.142  76.247  25.722  1.00 26.76           C  
ATOM    515  CZ  PHE A 122      40.838  76.401  26.166  1.00 26.46           C  
ATOM    516  N   MET A 123      43.114  73.100  22.655  1.00 26.76           N  
ATOM    517  CA  MET A 123      42.824  71.767  23.165  1.00 26.97           C  
ATOM    518  C   MET A 123      42.538  71.947  24.655  1.00 25.51           C  
ATOM    519  O   MET A 123      43.155  72.793  25.299  1.00 23.10           O  
ATOM    520  CB  MET A 123      44.029  70.848  22.955  1.00 29.66           C  
ATOM    521  CG  MET A 123      44.279  70.515  21.496  1.00 34.47           C  
ATOM    522  SD  MET A 123      45.727  69.484  21.214  1.00 37.81           S  
ATOM    523  CE  MET A 123      46.758  70.621  20.306  1.00 37.55           C  
ATOM    524  N   SER A 124      41.602  71.169  25.201  1.00 25.92           N  
ATOM    525  CA  SER A 124      41.261  71.291  26.616  1.00 26.62           C  
ATOM    526  C   SER A 124      40.312  70.224  27.135  1.00 27.34           C  
ATOM    527  O   SER A 124      39.439  69.740  26.427  1.00 27.47           O  
ATOM    528  CB  SER A 124      40.659  72.675  26.893  1.00 26.53           C  
ATOM    529  OG  SER A 124      40.355  72.838  28.259  1.00 24.04           O  
ATOM    530  N   GLY A 125      40.490  69.887  28.406  1.00 30.37           N  
ATOM    531  CA  GLY A 125      39.679  68.874  29.056  1.00 30.40           C  
ATOM    532  C   GLY A 125      38.477  69.400  29.806  1.00 31.23           C  
ATOM    533  O   GLY A 125      37.795  68.634  30.479  1.00 34.20           O  
ATOM    534  N   ASN A 126      38.219  70.700  29.719  1.00 30.92           N  
ATOM    535  CA  ASN A 126      37.053  71.280  30.374  1.00 30.26           C  
ATOM    536  C   ASN A 126      36.795  72.689  29.879  1.00 28.78           C  
ATOM    537  O   ASN A 126      37.235  73.656  30.473  1.00 25.55           O  
ATOM    538  CB  ASN A 126      37.209  71.284  31.897  1.00 31.75           C  
ATOM    539  CG  ASN A 126      35.863  71.206  32.615  1.00 32.77           C  
ATOM    540  OD1 ASN A 126      35.772  70.677  33.718  1.00 32.23           O  
ATOM    541  ND2 ASN A 126      34.814  71.735  31.986  1.00 33.90           N  
ATOM    542  N   VAL A 127      36.088  72.794  28.763  1.00 30.72           N  
ATOM    543  CA  VAL A 127      35.778  74.091  28.210  1.00 31.65           C  
ATOM    544  C   VAL A 127      34.467  74.467  28.857  1.00 33.46           C  
ATOM    545  O   VAL A 127      33.378  74.158  28.363  1.00 32.27           O  
ATOM    546  CB  VAL A 127      35.629  74.056  26.677  1.00 31.71           C  
ATOM    547  CG1 VAL A 127      35.666  75.465  26.146  1.00 32.09           C  
ATOM    548  CG2 VAL A 127      36.745  73.244  26.043  1.00 29.64           C  
ATOM    549  N   THR A 128      34.612  75.113  30.007  1.00 35.93           N  
ATOM    550  CA  THR A 128      33.507  75.574  30.827  1.00 35.07           C  
ATOM    551  C   THR A 128      32.787  76.697  30.144  1.00 36.64           C  
ATOM    552  O   THR A 128      33.307  77.323  29.232  1.00 35.80           O  
ATOM    553  CB  THR A 128      34.004  76.110  32.140  1.00 33.95           C  
ATOM    554  OG1 THR A 128      34.602  77.393  31.919  1.00 32.92           O  
ATOM    555  CG2 THR A 128      35.023  75.162  32.731  1.00 29.90           C  
ATOM    556  N   GLU A 129      31.585  76.968  30.619  1.00 41.07           N  
ATOM    557  CA  GLU A 129      30.771  78.010  30.037  1.00 44.67           C  
ATOM    558  C   GLU A 129      31.470  79.344  30.196  1.00 45.17           C  
ATOM    559  O   GLU A 129      31.227  80.268  29.430  1.00 44.07           O  
ATOM    560  CB  GLU A 129      29.379  77.985  30.672  1.00 48.70           C  
ATOM    561  CG  GLU A 129      28.557  76.713  30.286  1.00 55.02           C  
ATOM    562  CD  GLU A 129      29.208  75.377  30.740  1.00 58.65           C  
ATOM    563  OE1 GLU A 129      29.050  74.344  30.031  1.00 58.20           O  
ATOM    564  OE2 GLU A 129      29.868  75.357  31.810  1.00 59.35           O  
ATOM    565  N   GLU A 130      32.367  79.435  31.175  1.00 47.20           N  
ATOM    566  CA  GLU A 130      33.123  80.665  31.359  1.00 49.53           C  
ATOM    567  C   GLU A 130      34.088  80.791  30.177  1.00 50.08           C  
ATOM    568  O   GLU A 130      34.217  81.855  29.576  1.00 50.01           O  
ATOM    569  CB  GLU A 130      33.927  80.639  32.652  1.00 50.86           C  
ATOM    570  CG  GLU A 130      34.752  81.899  32.814  1.00 56.21           C  
ATOM    571  CD  GLU A 130      35.756  81.816  33.942  1.00 60.96           C  
ATOM    572  OE1 GLU A 130      36.528  82.789  34.119  1.00 61.52           O  
ATOM    573  OE2 GLU A 130      35.774  80.778  34.648  1.00 64.94           O  
ATOM    574  N   HIS A 131      34.771  79.693  29.863  1.00 50.68           N  
ATOM    575  CA  HIS A 131      35.699  79.651  28.738  1.00 50.34           C  
ATOM    576  C   HIS A 131      34.965  80.199  27.528  1.00 50.35           C  
ATOM    577  O   HIS A 131      35.384  81.161  26.897  1.00 51.75           O  
ATOM    578  CB  HIS A 131      36.115  78.207  28.416  1.00 50.47           C  
ATOM    579  CG  HIS A 131      37.279  77.699  29.212  1.00 49.91           C  
ATOM    580  ND1 HIS A 131      37.136  77.085  30.437  1.00 50.17           N  
ATOM    581  CD2 HIS A 131      38.605  77.682  28.936  1.00 49.59           C  
ATOM    582  CE1 HIS A 131      38.323  76.709  30.880  1.00 50.09           C  
ATOM    583  NE2 HIS A 131      39.231  77.059  29.987  1.00 49.83           N  
ATOM    584  N   VAL A 132      33.855  79.549  27.219  1.00 50.54           N  
ATOM    585  CA  VAL A 132      33.013  79.908  26.096  1.00 51.17           C  
ATOM    586  C   VAL A 132      32.816  81.405  25.929  1.00 52.34           C  
ATOM    587  O   VAL A 132      32.857  81.914  24.813  1.00 52.78           O  
ATOM    588  CB  VAL A 132      31.631  79.255  26.240  1.00 50.75           C  
ATOM    589  CG1 VAL A 132      30.836  79.432  24.968  1.00 49.93           C  
ATOM    590  CG2 VAL A 132      31.787  77.785  26.587  1.00 51.45           C  
ATOM    591  N   GLU A 133      32.598  82.113  27.033  1.00 54.11           N  
ATOM    592  CA  GLU A 133      32.365  83.552  26.961  1.00 56.02           C  
ATOM    593  C   GLU A 133      33.577  84.333  26.494  1.00 55.81           C  
ATOM    594  O   GLU A 133      33.498  85.105  25.532  1.00 56.03           O  
ATOM    595  CB  GLU A 133      31.886  84.100  28.312  1.00 58.09           C  
ATOM    596  CG  GLU A 133      30.372  84.372  28.369  1.00 62.58           C  
ATOM    597  CD  GLU A 133      29.529  83.122  28.641  1.00 65.06           C  
ATOM    598  OE1 GLU A 133      29.477  82.698  29.821  1.00 67.51           O  
ATOM    599  OE2 GLU A 133      28.924  82.567  27.686  1.00 63.81           O  
ATOM    600  N   GLU A 134      34.696  84.132  27.176  1.00 55.18           N  
ATOM    601  CA  GLU A 134      35.923  84.821  26.825  1.00 54.78           C  
ATOM    602  C   GLU A 134      36.256  84.459  25.383  1.00 53.68           C  
ATOM    603  O   GLU A 134      36.717  85.298  24.603  1.00 53.85           O  
ATOM    604  CB  GLU A 134      37.049  84.379  27.761  1.00 55.69           C  
ATOM    605  CG  GLU A 134      37.993  85.499  28.194  1.00 58.41           C  
ATOM    606  CD  GLU A 134      37.324  86.527  29.096  1.00 59.56           C  
ATOM    607  OE1 GLU A 134      37.993  87.520  29.464  1.00 59.64           O  
ATOM    608  OE2 GLU A 134      36.135  86.342  29.437  1.00 60.38           O  
ATOM    609  N   LEU A 135      35.982  83.202  25.043  1.00 52.43           N  
ATOM    610  CA  LEU A 135      36.240  82.648  23.713  1.00 51.71           C  
ATOM    611  C   LEU A 135      35.486  83.395  22.610  1.00 52.73           C  
ATOM    612  O   LEU A 135      36.093  83.910  21.662  1.00 52.32           O  
ATOM    613  CB  LEU A 135      35.865  81.162  23.709  1.00 49.08           C  
ATOM    614  CG  LEU A 135      36.811  80.139  23.066  1.00 48.66           C  
ATOM    615  CD1 LEU A 135      38.245  80.328  23.538  1.00 47.50           C  
ATOM    616  CD2 LEU A 135      36.326  78.742  23.430  1.00 48.88           C  
ATOM    617  N   LYS A 136      34.163  83.451  22.732  1.00 53.65           N  
ATOM    618  CA  LYS A 136      33.342  84.148  21.745  1.00 55.06           C  
ATOM    619  C   LYS A 136      33.837  85.570  21.506  1.00 55.96           C  
ATOM    620  O   LYS A 136      33.740  86.080  20.391  1.00 56.85           O  
ATOM    621  CB  LYS A 136      31.872  84.194  22.191  1.00 55.45           C  
ATOM    622  CG  LYS A 136      31.059  82.967  21.803  1.00 55.15           C  
ATOM    623  CD  LYS A 136      29.583  83.129  22.094  1.00 52.65           C  
ATOM    624  CE  LYS A 136      28.836  81.868  21.704  1.00 52.94           C  
ATOM    625  NZ  LYS A 136      27.420  81.884  22.149  1.00 53.87           N  
ATOM    626  N   LYS A 137      34.372  86.196  22.554  1.00 55.73           N  
ATOM    627  CA  LYS A 137      34.881  87.565  22.481  1.00 55.60           C  
ATOM    628  C   LYS A 137      36.233  87.654  21.797  1.00 55.32           C  
ATOM    629  O   LYS A 137      36.657  88.735  21.400  1.00 56.20           O  
ATOM    630  CB  LYS A 137      35.042  88.156  23.884  1.00 56.95           C  
ATOM    631  CG  LYS A 137      33.807  88.146  24.769  1.00 58.05           C  
ATOM    632  CD  LYS A 137      34.189  88.625  26.173  1.00 58.58           C  
ATOM    633  CE  LYS A 137      33.010  88.592  27.144  1.00 59.10           C  
ATOM    634  NZ  LYS A 137      33.406  89.067  28.506  1.00 57.41           N  
ATOM    635  N   SER A 138      36.916  86.523  21.683  1.00 54.85           N  
ATOM    636  CA  SER A 138      38.244  86.479  21.076  1.00 54.01           C  
ATOM    637  C   SER A 138      38.415  87.381  19.858  1.00 52.82           C  
ATOM    638  O   SER A 138      37.473  87.603  19.107  1.00 53.28           O  
ATOM    639  CB  SER A 138      38.582  85.043  20.681  1.00 54.52           C  
ATOM    640  OG  SER A 138      39.892  84.962  20.150  1.00 54.49           O  
ATOM    641  N   PRO A 139      39.631  87.916  19.653  1.00 52.25           N  
ATOM    642  CA  PRO A 139      39.939  88.795  18.516  1.00 50.37           C  
ATOM    643  C   PRO A 139      40.211  87.930  17.297  1.00 48.31           C  
ATOM    644  O   PRO A 139      39.696  88.182  16.206  1.00 48.37           O  
ATOM    645  CB  PRO A 139      41.215  89.515  18.949  1.00 51.68           C  
ATOM    646  CG  PRO A 139      41.302  89.272  20.439  1.00 52.96           C  
ATOM    647  CD  PRO A 139      40.760  87.887  20.597  1.00 53.04           C  
ATOM    648  N   VAL A 140      41.048  86.915  17.510  1.00 45.82           N  
ATOM    649  CA  VAL A 140      41.429  85.968  16.466  1.00 42.43           C  
ATOM    650  C   VAL A 140      40.549  84.729  16.528  1.00 40.47           C  
ATOM    651  O   VAL A 140      40.035  84.370  17.586  1.00 41.31           O  
ATOM    652  CB  VAL A 140      42.889  85.524  16.625  1.00 41.08           C  
ATOM    653  CG1 VAL A 140      43.802  86.735  16.599  1.00 41.29           C  
ATOM    654  CG2 VAL A 140      43.053  84.747  17.913  1.00 39.31           C  
ATOM    655  N   PRO A 141      40.364  84.053  15.391  1.00 38.25           N  
ATOM    656  CA  PRO A 141      39.531  82.852  15.386  1.00 37.63           C  
ATOM    657  C   PRO A 141      40.184  81.700  16.154  1.00 36.46           C  
ATOM    658  O   PRO A 141      41.399  81.507  16.095  1.00 36.73           O  
ATOM    659  CB  PRO A 141      39.391  82.529  13.897  1.00 38.52           C  
ATOM    660  CG  PRO A 141      39.708  83.824  13.209  1.00 39.37           C  
ATOM    661  CD  PRO A 141      40.823  84.374  14.033  1.00 38.33           C  
ATOM    662  N   VAL A 142      39.371  80.939  16.875  1.00 34.81           N  
ATOM    663  CA  VAL A 142      39.871  79.806  17.633  1.00 34.16           C  
ATOM    664  C   VAL A 142      38.914  78.648  17.459  1.00 31.82           C  
ATOM    665  O   VAL A 142      37.698  78.837  17.469  1.00 32.47           O  
ATOM    666  CB  VAL A 142      40.010  80.149  19.139  1.00 35.34           C  
ATOM    667  CG1 VAL A 142      38.806  80.902  19.596  1.00 37.39           C  
ATOM    668  CG2 VAL A 142      40.152  78.883  19.970  1.00 36.41           C  
ATOM    669  N   VAL A 143      39.459  77.460  17.244  1.00 28.39           N  
ATOM    670  CA  VAL A 143      38.618  76.288  17.103  1.00 27.84           C  
ATOM    671  C   VAL A 143      39.209  75.205  17.989  1.00 26.70           C  
ATOM    672  O   VAL A 143      40.414  75.160  18.208  1.00 26.62           O  
ATOM    673  CB  VAL A 143      38.506  75.810  15.614  1.00 28.03           C  
ATOM    674  CG1 VAL A 143      38.883  76.939  14.691  1.00 28.43           C  
ATOM    675  CG2 VAL A 143      39.349  74.574  15.357  1.00 27.44           C  
ATOM    676  N   LEU A 144      38.349  74.351  18.526  1.00 26.33           N  
ATOM    677  CA  LEU A 144      38.785  73.275  19.403  1.00 25.27           C  
ATOM    678  C   LEU A 144      39.212  72.055  18.604  1.00 23.80           C  
ATOM    679  O   LEU A 144      38.772  71.835  17.479  1.00 21.28           O  
ATOM    680  CB  LEU A 144      37.647  72.875  20.353  1.00 26.71           C  
ATOM    681  CG  LEU A 144      36.882  74.020  21.037  1.00 29.17           C  
ATOM    682  CD1 LEU A 144      35.619  73.479  21.656  1.00 29.05           C  
ATOM    683  CD2 LEU A 144      37.749  74.695  22.096  1.00 28.73           C  
ATOM    684  N   ALA A 145      40.102  71.277  19.199  1.00 24.35           N  
ATOM    685  CA  ALA A 145      40.578  70.048  18.599  1.00 23.83           C  
ATOM    686  C   ALA A 145      40.524  69.066  19.745  1.00 24.87           C  
ATOM    687  O   ALA A 145      41.054  69.350  20.825  1.00 23.05           O  
ATOM    688  CB  ALA A 145      41.997  70.200  18.111  1.00 20.81           C  
ATOM    689  N   ALA A 146      39.836  67.947  19.514  1.00 27.31           N  
ATOM    690  CA  ALA A 146      39.701  66.865  20.492  1.00 29.11           C  
ATOM    691  C   ALA A 146      39.267  67.354  21.867  1.00 30.50           C  
ATOM    692  O   ALA A 146      39.869  67.003  22.898  1.00 30.30           O  
ATOM    693  CB  ALA A 146      41.024  66.109  20.601  1.00 28.95           C  
ATOM    694  N   SER A 147      38.223  68.171  21.877  1.00 30.69           N  
ATOM    695  CA  SER A 147      37.716  68.705  23.124  1.00 32.09           C  
ATOM    696  C   SER A 147      36.223  68.955  23.016  1.00 33.53           C  
ATOM    697  O   SER A 147      35.748  69.646  22.114  1.00 34.15           O  
ATOM    698  CB  SER A 147      38.453  69.998  23.467  1.00 30.28           C  
ATOM    699  OG  SER A 147      39.852  69.773  23.488  1.00 29.02           O  
ATOM    700  N   ILE A 148      35.480  68.359  23.935  1.00 35.37           N  
ATOM    701  CA  ILE A 148      34.043  68.519  23.958  1.00 36.15           C  
ATOM    702  C   ILE A 148      33.689  69.872  24.599  1.00 37.23           C  
ATOM    703  O   ILE A 148      34.310  70.321  25.568  1.00 36.60           O  
ATOM    704  CB  ILE A 148      33.378  67.286  24.682  1.00 35.00           C  
ATOM    705  CG1 ILE A 148      31.956  67.615  25.145  1.00 36.70           C  
ATOM    706  CG2 ILE A 148      34.253  66.810  25.817  1.00 34.12           C  
ATOM    707  CD1 ILE A 148      31.851  68.358  26.464  1.00 40.38           C  
ATOM    708  N   GLU A 149      32.706  70.533  24.002  1.00 39.39           N  
ATOM    709  CA  GLU A 149      32.217  71.833  24.453  1.00 41.60           C  
ATOM    710  C   GLU A 149      30.712  71.761  24.179  1.00 42.90           C  
ATOM    711  O   GLU A 149      30.193  72.429  23.292  1.00 41.88           O  
ATOM    712  CB  GLU A 149      32.881  72.927  23.618  1.00 41.69           C  
ATOM    713  CG  GLU A 149      32.761  74.311  24.176  1.00 42.94           C  
ATOM    714  CD  GLU A 149      31.361  74.837  24.094  1.00 45.06           C  
ATOM    715  OE1 GLU A 149      30.855  74.974  22.959  1.00 44.65           O  
ATOM    716  OE2 GLU A 149      30.770  75.105  25.164  1.00 46.39           O  
ATOM    717  N   SER A 150      30.053  70.914  24.966  1.00 46.27           N  
ATOM    718  CA  SER A 150      28.627  70.581  24.901  1.00 48.10           C  
ATOM    719  C   SER A 150      27.598  71.569  24.378  1.00 48.47           C  
ATOM    720  O   SER A 150      26.576  71.154  23.824  1.00 49.47           O  
ATOM    721  CB  SER A 150      28.165  70.048  26.268  1.00 49.75           C  
ATOM    722  OG  SER A 150      28.687  68.740  26.515  1.00 52.49           O  
ATOM    723  N   THR A 151      27.840  72.863  24.539  1.00 48.24           N  
ATOM    724  CA  THR A 151      26.881  73.844  24.049  1.00 47.32           C  
ATOM    725  C   THR A 151      26.920  73.935  22.534  1.00 46.41           C  
ATOM    726  O   THR A 151      25.953  74.342  21.916  1.00 47.67           O  
ATOM    727  CB  THR A 151      27.169  75.232  24.601  1.00 47.97           C  
ATOM    728  OG1 THR A 151      28.492  75.614  24.216  1.00 49.02           O  
ATOM    729  CG2 THR A 151      27.039  75.251  26.128  1.00 48.00           C  
ATOM    730  N   ASN A 152      28.046  73.561  21.943  1.00 45.87           N  
ATOM    731  CA  ASN A 152      28.216  73.602  20.501  1.00 45.01           C  
ATOM    732  C   ASN A 152      28.228  75.050  19.985  1.00 45.28           C  
ATOM    733  O   ASN A 152      27.795  75.332  18.866  1.00 45.71           O  
ATOM    734  CB  ASN A 152      27.110  72.784  19.804  1.00 44.63           C  
ATOM    735  CG  ASN A 152      27.310  71.260  19.934  1.00 45.56           C  
ATOM    736  OD1 ASN A 152      26.630  70.467  19.269  1.00 45.16           O  
ATOM    737  ND2 ASN A 152      28.240  70.854  20.783  1.00 44.46           N  
ATOM    738  N   GLN A 153      28.747  75.968  20.799  1.00 44.61           N  
ATOM    739  CA  GLN A 153      28.819  77.378  20.412  1.00 43.23           C  
ATOM    740  C   GLN A 153      30.210  77.804  19.919  1.00 40.98           C  
ATOM    741  O   GLN A 153      30.421  78.952  19.567  1.00 40.89           O  
ATOM    742  CB  GLN A 153      28.436  78.280  21.578  1.00 45.08           C  
ATOM    743  CG  GLN A 153      27.324  77.773  22.454  1.00 49.07           C  
ATOM    744  CD  GLN A 153      27.304  78.507  23.785  1.00 52.57           C  
ATOM    745  OE1 GLN A 153      26.796  78.000  24.791  1.00 53.78           O  
ATOM    746  NE2 GLN A 153      27.859  79.716  23.797  1.00 54.25           N  
ATOM    747  N   ILE A 154      31.175  76.904  19.931  1.00 39.79           N  
ATOM    748  CA  ILE A 154      32.496  77.261  19.435  1.00 39.13           C  
ATOM    749  C   ILE A 154      32.863  76.253  18.370  1.00 37.01           C  
ATOM    750  O   ILE A 154      32.522  75.076  18.477  1.00 36.97           O  
ATOM    751  CB  ILE A 154      33.585  77.253  20.557  1.00 40.67           C  
ATOM    752  CG1 ILE A 154      33.771  78.665  21.112  1.00 40.79           C  
ATOM    753  CG2 ILE A 154      34.932  76.785  20.007  1.00 39.46           C  
ATOM    754  CD1 ILE A 154      32.516  79.289  21.655  1.00 43.17           C  
ATOM    755  N   PRO A 155      33.530  76.710  17.307  1.00 34.81           N  
ATOM    756  CA  PRO A 155      33.925  75.794  16.238  1.00 33.77           C  
ATOM    757  C   PRO A 155      34.803  74.701  16.831  1.00 33.26           C  
ATOM    758  O   PRO A 155      35.711  74.976  17.615  1.00 33.58           O  
ATOM    759  CB  PRO A 155      34.662  76.706  15.261  1.00 33.65           C  
ATOM    760  CG  PRO A 155      35.147  77.827  16.134  1.00 34.90           C  
ATOM    761  CD  PRO A 155      33.986  78.078  17.027  1.00 33.83           C  
ATOM    762  N   SER A 156      34.521  73.452  16.477  1.00 31.81           N  
ATOM    763  CA  SER A 156      35.299  72.359  17.021  1.00 27.46           C  
ATOM    764  C   SER A 156      35.305  71.157  16.114  1.00 25.46           C  
ATOM    765  O   SER A 156      34.400  70.979  15.307  1.00 24.41           O  
ATOM    766  CB  SER A 156      34.716  71.936  18.349  1.00 26.64           C  
ATOM    767  OG  SER A 156      33.573  71.153  18.107  1.00 27.30           O  
ATOM    768  N   VAL A 157      36.348  70.345  16.256  1.00 24.47           N  
ATOM    769  CA  VAL A 157      36.499  69.099  15.511  1.00 23.37           C  
ATOM    770  C   VAL A 157      37.010  68.040  16.501  1.00 23.86           C  
ATOM    771  O   VAL A 157      38.028  68.221  17.179  1.00 23.57           O  
ATOM    772  CB  VAL A 157      37.440  69.260  14.264  1.00 21.17           C  
ATOM    773  CG1 VAL A 157      38.451  70.330  14.499  1.00 21.99           C  
ATOM    774  CG2 VAL A 157      38.130  67.949  13.945  1.00 19.27           C  
ATOM    775  N   THR A 158      36.254  66.950  16.602  1.00 24.35           N  
ATOM    776  CA  THR A 158      36.559  65.836  17.500  1.00 23.76           C  
ATOM    777  C   THR A 158      35.881  64.606  16.921  1.00 22.87           C  
ATOM    778  O   THR A 158      35.246  64.684  15.882  1.00 22.60           O  
ATOM    779  CB  THR A 158      35.951  66.062  18.926  1.00 23.93           C  
ATOM    780  OG1 THR A 158      34.529  66.160  18.831  1.00 22.98           O  
ATOM    781  CG2 THR A 158      36.469  67.332  19.554  1.00 26.09           C  
ATOM    782  N   ILE A 159      36.025  63.467  17.585  1.00 24.02           N  
ATOM    783  CA  ILE A 159      35.346  62.254  17.150  1.00 24.78           C  
ATOM    784  C   ILE A 159      34.237  62.134  18.169  1.00 26.59           C  
ATOM    785  O   ILE A 159      34.242  62.853  19.164  1.00 26.79           O  
ATOM    786  CB  ILE A 159      36.195  60.982  17.310  1.00 25.49           C  
ATOM    787  CG1 ILE A 159      36.541  60.782  18.788  1.00 25.61           C  
ATOM    788  CG2 ILE A 159      37.413  61.047  16.418  1.00 22.49           C  
ATOM    789  CD1 ILE A 159      37.069  59.421  19.118  1.00 35.06           C  
ATOM    790  N   ASP A 160      33.289  61.233  17.937  1.00 28.64           N  
ATOM    791  CA  ASP A 160      32.221  61.032  18.914  1.00 29.46           C  
ATOM    792  C   ASP A 160      32.694  60.035  19.981  1.00 27.97           C  
ATOM    793  O   ASP A 160      32.499  58.833  19.853  1.00 27.35           O  
ATOM    794  CB  ASP A 160      30.952  60.515  18.233  1.00 30.98           C  
ATOM    795  CG  ASP A 160      29.846  60.195  19.232  1.00 31.00           C  
ATOM    796  OD1 ASP A 160      29.845  60.783  20.344  1.00 28.28           O  
ATOM    797  OD2 ASP A 160      28.983  59.361  18.887  1.00 29.48           O  
ATOM    798  N   TYR A 161      33.314  60.552  21.034  1.00 27.96           N  
ATOM    799  CA  TYR A 161      33.838  59.722  22.106  1.00 28.58           C  
ATOM    800  C   TYR A 161      32.858  58.706  22.685  1.00 28.74           C  
ATOM    801  O   TYR A 161      33.248  57.572  22.993  1.00 26.50           O  
ATOM    802  CB  TYR A 161      34.373  60.609  23.212  1.00 30.69           C  
ATOM    803  CG  TYR A 161      35.472  61.535  22.754  1.00 33.11           C  
ATOM    804  CD1 TYR A 161      35.181  62.800  22.259  1.00 34.22           C  
ATOM    805  CD2 TYR A 161      36.808  61.156  22.846  1.00 35.19           C  
ATOM    806  CE1 TYR A 161      36.194  63.669  21.876  1.00 37.56           C  
ATOM    807  CE2 TYR A 161      37.831  62.020  22.464  1.00 37.38           C  
ATOM    808  CZ  TYR A 161      37.517  63.273  21.985  1.00 37.59           C  
ATOM    809  OH  TYR A 161      38.526  64.138  21.638  1.00 40.07           O  
ATOM    810  N   GLU A 162      31.597  59.114  22.826  1.00 28.09           N  
ATOM    811  CA  GLU A 162      30.549  58.244  23.346  1.00 27.79           C  
ATOM    812  C   GLU A 162      30.475  56.957  22.518  1.00 28.78           C  
ATOM    813  O   GLU A 162      30.484  55.854  23.082  1.00 28.15           O  
ATOM    814  CB  GLU A 162      29.213  58.987  23.323  1.00 28.71           C  
ATOM    815  CG  GLU A 162      27.987  58.158  22.902  1.00 32.03           C  
ATOM    816  CD  GLU A 162      27.533  57.186  23.965  1.00 33.72           C  
ATOM    817  OE1 GLU A 162      27.622  57.534  25.164  1.00 38.06           O  
ATOM    818  OE2 GLU A 162      27.070  56.086  23.604  1.00 33.65           O  
ATOM    819  N   GLN A 163      30.401  57.103  21.189  1.00 28.07           N  
ATOM    820  CA  GLN A 163      30.355  55.954  20.271  1.00 28.43           C  
ATOM    821  C   GLN A 163      31.654  55.147  20.314  1.00 28.47           C  
ATOM    822  O   GLN A 163      31.645  53.915  20.224  1.00 28.23           O  
ATOM    823  CB  GLN A 163      30.130  56.407  18.820  1.00 29.39           C  
ATOM    824  CG  GLN A 163      28.711  56.260  18.333  1.00 32.83           C  
ATOM    825  CD  GLN A 163      28.180  54.859  18.510  1.00 34.04           C  
ATOM    826  OE1 GLN A 163      27.001  54.671  18.787  1.00 37.42           O  
ATOM    827  NE2 GLN A 163      29.044  53.865  18.343  1.00 34.76           N  
ATOM    828  N   ALA A 164      32.779  55.841  20.416  1.00 27.51           N  
ATOM    829  CA  ALA A 164      34.053  55.148  20.481  1.00 28.27           C  
ATOM    830  C   ALA A 164      34.009  54.175  21.680  1.00 27.65           C  
ATOM    831  O   ALA A 164      34.156  52.961  21.515  1.00 26.28           O  
ATOM    832  CB  ALA A 164      35.188  56.161  20.636  1.00 27.71           C  
ATOM    833  N   ALA A 165      33.778  54.730  22.871  1.00 26.41           N  
ATOM    834  CA  ALA A 165      33.689  53.964  24.106  1.00 24.47           C  
ATOM    835  C   ALA A 165      32.737  52.776  23.969  1.00 24.39           C  
ATOM    836  O   ALA A 165      33.088  51.654  24.330  1.00 23.47           O  
ATOM    837  CB  ALA A 165      33.236  54.871  25.237  1.00 23.96           C  
ATOM    838  N   PHE A 166      31.536  53.033  23.452  1.00 24.48           N  
ATOM    839  CA  PHE A 166      30.531  51.992  23.245  1.00 23.60           C  
ATOM    840  C   PHE A 166      31.057  50.919  22.289  1.00 24.30           C  
ATOM    841  O   PHE A 166      30.950  49.727  22.573  1.00 25.88           O  
ATOM    842  CB  PHE A 166      29.231  52.610  22.693  1.00 22.47           C  
ATOM    843  CG  PHE A 166      28.189  51.600  22.289  1.00 20.80           C  
ATOM    844  CD1 PHE A 166      28.328  50.863  21.106  1.00 21.16           C  
ATOM    845  CD2 PHE A 166      27.085  51.361  23.098  1.00 20.06           C  
ATOM    846  CE1 PHE A 166      27.379  49.891  20.733  1.00 19.52           C  
ATOM    847  CE2 PHE A 166      26.127  50.393  22.738  1.00 22.12           C  
ATOM    848  CZ  PHE A 166      26.277  49.655  21.549  1.00 19.78           C  
ATOM    849  N   ASP A 167      31.617  51.333  21.157  1.00 24.14           N  
ATOM    850  CA  ASP A 167      32.140  50.370  20.200  1.00 23.51           C  
ATOM    851  C   ASP A 167      33.215  49.507  20.872  1.00 23.18           C  
ATOM    852  O   ASP A 167      33.257  48.293  20.682  1.00 21.98           O  
ATOM    853  CB  ASP A 167      32.738  51.077  18.969  1.00 25.56           C  
ATOM    854  CG  ASP A 167      31.680  51.716  18.060  1.00 27.72           C  
ATOM    855  OD1 ASP A 167      30.516  51.261  18.061  1.00 30.31           O  
ATOM    856  OD2 ASP A 167      32.023  52.669  17.318  1.00 28.63           O  
ATOM    857  N   ALA A 168      34.076  50.138  21.664  1.00 22.53           N  
ATOM    858  CA  ALA A 168      35.145  49.431  22.346  1.00 22.78           C  
ATOM    859  C   ALA A 168      34.606  48.336  23.273  1.00 25.35           C  
ATOM    860  O   ALA A 168      34.987  47.175  23.147  1.00 26.81           O  
ATOM    861  CB  ALA A 168      35.982  50.409  23.119  1.00 21.25           C  
ATOM    862  N   VAL A 169      33.727  48.701  24.205  1.00 25.17           N  
ATOM    863  CA  VAL A 169      33.148  47.725  25.119  1.00 24.62           C  
ATOM    864  C   VAL A 169      32.306  46.717  24.319  1.00 23.84           C  
ATOM    865  O   VAL A 169      32.335  45.510  24.579  1.00 21.94           O  
ATOM    866  CB  VAL A 169      32.256  48.415  26.215  1.00 24.91           C  
ATOM    867  CG1 VAL A 169      31.585  47.352  27.095  1.00 21.07           C  
ATOM    868  CG2 VAL A 169      33.110  49.334  27.081  1.00 20.86           C  
ATOM    869  N   GLN A 170      31.561  47.212  23.342  1.00 22.14           N  
ATOM    870  CA  GLN A 170      30.747  46.320  22.535  1.00 24.18           C  
ATOM    871  C   GLN A 170      31.686  45.253  21.992  1.00 24.64           C  
ATOM    872  O   GLN A 170      31.373  44.061  21.990  1.00 24.65           O  
ATOM    873  CB  GLN A 170      30.079  47.090  21.388  1.00 23.96           C  
ATOM    874  CG  GLN A 170      29.151  46.253  20.533  1.00 25.24           C  
ATOM    875  CD  GLN A 170      28.095  45.523  21.355  1.00 27.99           C  
ATOM    876  OE1 GLN A 170      27.334  46.145  22.097  1.00 29.19           O  
ATOM    877  NE2 GLN A 170      28.047  44.193  21.226  1.00 27.53           N  
ATOM    878  N   SER A 171      32.854  45.701  21.548  1.00 26.05           N  
ATOM    879  CA  SER A 171      33.871  44.812  21.013  1.00 25.76           C  
ATOM    880  C   SER A 171      34.086  43.632  21.957  1.00 25.12           C  
ATOM    881  O   SER A 171      34.106  42.481  21.547  1.00 22.71           O  
ATOM    882  CB  SER A 171      35.175  45.585  20.849  1.00 25.21           C  
ATOM    883  OG  SER A 171      36.288  44.715  20.803  1.00 29.48           O  
ATOM    884  N   LEU A 172      34.236  43.946  23.233  1.00 25.80           N  
ATOM    885  CA  LEU A 172      34.473  42.944  24.238  1.00 26.24           C  
ATOM    886  C   LEU A 172      33.223  42.134  24.570  1.00 30.26           C  
ATOM    887  O   LEU A 172      33.329  40.952  24.921  1.00 30.84           O  
ATOM    888  CB  LEU A 172      35.052  43.626  25.467  1.00 24.01           C  
ATOM    889  CG  LEU A 172      36.414  44.295  25.209  1.00 21.43           C  
ATOM    890  CD1 LEU A 172      36.614  45.453  26.163  1.00 20.64           C  
ATOM    891  CD2 LEU A 172      37.534  43.284  25.380  1.00 20.89           C  
ATOM    892  N   ILE A 173      32.041  42.745  24.466  1.00 32.54           N  
ATOM    893  CA  ILE A 173      30.809  42.010  24.740  1.00 33.26           C  
ATOM    894  C   ILE A 173      30.816  40.845  23.781  1.00 33.66           C  
ATOM    895  O   ILE A 173      30.611  39.702  24.175  1.00 33.73           O  
ATOM    896  CB  ILE A 173      29.535  42.789  24.388  1.00 35.06           C  
ATOM    897  CG1 ILE A 173      29.544  44.178  25.027  1.00 37.57           C  
ATOM    898  CG2 ILE A 173      28.326  41.986  24.822  1.00 33.35           C  
ATOM    899  CD1 ILE A 173      29.603  44.174  26.524  1.00 42.82           C  
ATOM    900  N   ASP A 174      31.054  41.167  22.513  1.00 33.76           N  
ATOM    901  CA  ASP A 174      31.062  40.195  21.436  1.00 34.44           C  
ATOM    902  C   ASP A 174      32.155  39.136  21.551  1.00 34.74           C  
ATOM    903  O   ASP A 174      32.096  38.106  20.884  1.00 36.43           O  
ATOM    904  CB  ASP A 174      31.186  40.918  20.101  1.00 38.34           C  
ATOM    905  CG  ASP A 174      30.150  42.027  19.923  1.00 42.82           C  
ATOM    906  OD1 ASP A 174      28.942  41.762  20.099  1.00 44.23           O  
ATOM    907  OD2 ASP A 174      30.543  43.171  19.587  1.00 45.52           O  
ATOM    908  N   SER A 175      33.161  39.392  22.378  1.00 34.53           N  
ATOM    909  CA  SER A 175      34.247  38.436  22.581  1.00 33.57           C  
ATOM    910  C   SER A 175      33.761  37.435  23.602  1.00 32.84           C  
ATOM    911  O   SER A 175      34.381  36.399  23.797  1.00 34.14           O  
ATOM    912  CB  SER A 175      35.507  39.109  23.146  1.00 36.02           C  
ATOM    913  OG  SER A 175      36.140  39.991  22.227  1.00 39.57           O  
ATOM    914  N   GLY A 176      32.669  37.777  24.281  1.00 31.86           N  
ATOM    915  CA  GLY A 176      32.101  36.900  25.286  1.00 30.87           C  
ATOM    916  C   GLY A 176      32.203  37.402  26.712  1.00 31.72           C  
ATOM    917  O   GLY A 176      31.810  36.712  27.652  1.00 31.34           O  
ATOM    918  N   HIS A 177      32.725  38.607  26.892  1.00 32.09           N  
ATOM    919  CA  HIS A 177      32.852  39.142  28.234  1.00 33.09           C  
ATOM    920  C   HIS A 177      31.525  39.657  28.750  1.00 33.38           C  
ATOM    921  O   HIS A 177      30.782  40.332  28.050  1.00 33.73           O  
ATOM    922  CB  HIS A 177      33.919  40.232  28.248  1.00 32.71           C  
ATOM    923  CG  HIS A 177      35.255  39.736  27.798  1.00 32.27           C  
ATOM    924  ND1 HIS A 177      36.223  39.305  28.678  1.00 32.61           N  
ATOM    925  CD2 HIS A 177      35.745  39.506  26.558  1.00 32.05           C  
ATOM    926  CE1 HIS A 177      37.252  38.830  27.999  1.00 31.79           C  
ATOM    927  NE2 HIS A 177      36.986  38.939  26.710  1.00 31.48           N  
ATOM    928  N   LYS A 178      31.217  39.303  29.988  1.00 35.22           N  
ATOM    929  CA  LYS A 178      29.971  39.734  30.586  1.00 34.85           C  
ATOM    930  C   LYS A 178      30.240  40.811  31.626  1.00 33.43           C  
ATOM    931  O   LYS A 178      29.480  41.766  31.732  1.00 33.88           O  
ATOM    932  CB  LYS A 178      29.209  38.513  31.129  1.00 35.10           C  
ATOM    933  CG  LYS A 178      28.710  37.612  29.955  1.00 37.53           C  
ATOM    934  CD  LYS A 178      28.062  36.300  30.379  1.00 38.28           C  
ATOM    935  CE  LYS A 178      29.043  35.427  31.162  1.00 41.93           C  
ATOM    936  NZ  LYS A 178      28.402  34.241  31.836  1.00 44.10           N  
ATOM    937  N   ASN A 179      31.316  40.700  32.393  1.00 32.76           N  
ATOM    938  CA  ASN A 179      31.582  41.785  33.321  1.00 33.25           C  
ATOM    939  C   ASN A 179      32.937  42.448  33.021  1.00 31.76           C  
ATOM    940  O   ASN A 179      34.021  41.920  33.307  1.00 31.54           O  
ATOM    941  CB  ASN A 179      31.404  41.351  34.793  1.00 34.57           C  
ATOM    942  CG  ASN A 179      32.153  40.107  35.139  1.00 36.21           C  
ATOM    943  OD1 ASN A 179      33.376  40.070  35.043  1.00 39.33           O  
ATOM    944  ND2 ASN A 179      31.429  39.072  35.564  1.00 34.92           N  
ATOM    945  N   ILE A 180      32.803  43.619  32.394  1.00 29.09           N  
ATOM    946  CA  ILE A 180      33.878  44.479  31.911  1.00 26.56           C  
ATOM    947  C   ILE A 180      33.983  45.767  32.727  1.00 25.38           C  
ATOM    948  O   ILE A 180      33.005  46.508  32.865  1.00 23.66           O  
ATOM    949  CB  ILE A 180      33.598  44.878  30.438  1.00 27.08           C  
ATOM    950  CG1 ILE A 180      33.120  43.652  29.650  1.00 28.88           C  
ATOM    951  CG2 ILE A 180      34.854  45.448  29.791  1.00 26.02           C  
ATOM    952  CD1 ILE A 180      31.911  43.902  28.755  1.00 36.06           C  
ATOM    953  N   ALA A 181      35.179  46.048  33.233  1.00 24.10           N  
ATOM    954  CA  ALA A 181      35.411  47.244  34.024  1.00 25.17           C  
ATOM    955  C   ALA A 181      35.878  48.416  33.149  1.00 26.67           C  
ATOM    956  O   ALA A 181      36.217  48.222  31.981  1.00 25.98           O  
ATOM    957  CB  ALA A 181      36.432  46.947  35.088  1.00 26.08           C  
ATOM    958  N   PHE A 182      35.889  49.624  33.720  1.00 28.23           N  
ATOM    959  CA  PHE A 182      36.309  50.847  33.012  1.00 29.26           C  
ATOM    960  C   PHE A 182      37.252  51.740  33.815  1.00 29.27           C  
ATOM    961  O   PHE A 182      36.847  52.327  34.821  1.00 28.08           O  
ATOM    962  CB  PHE A 182      35.100  51.705  32.644  1.00 29.77           C  
ATOM    963  CG  PHE A 182      35.464  52.985  31.944  1.00 29.90           C  
ATOM    964  CD1 PHE A 182      34.785  54.162  32.220  1.00 28.65           C  
ATOM    965  CD2 PHE A 182      36.492  53.015  31.007  1.00 29.42           C  
ATOM    966  CE1 PHE A 182      35.121  55.337  31.582  1.00 27.38           C  
ATOM    967  CE2 PHE A 182      36.828  54.193  30.367  1.00 27.46           C  
ATOM    968  CZ  PHE A 182      36.142  55.353  30.657  1.00 26.98           C  
ATOM    969  N   VAL A 183      38.497  51.874  33.370  1.00 29.25           N  
ATOM    970  CA  VAL A 183      39.438  52.721  34.094  1.00 29.62           C  
ATOM    971  C   VAL A 183      39.532  54.012  33.334  1.00 31.75           C  
ATOM    972  O   VAL A 183      40.061  54.052  32.226  1.00 32.03           O  
ATOM    973  CB  VAL A 183      40.837  52.095  34.190  1.00 28.52           C  
ATOM    974  CG1 VAL A 183      41.798  53.087  34.845  1.00 27.21           C  
ATOM    975  CG2 VAL A 183      40.773  50.810  34.995  1.00 23.87           C  
ATOM    976  N   SER A 184      39.032  55.084  33.933  1.00 33.87           N  
ATOM    977  CA  SER A 184      39.035  56.352  33.236  1.00 36.29           C  
ATOM    978  C   SER A 184      39.958  57.411  33.789  1.00 36.83           C  
ATOM    979  O   SER A 184      40.755  57.177  34.700  1.00 36.46           O  
ATOM    980  CB  SER A 184      37.620  56.925  33.193  1.00 36.09           C  
ATOM    981  OG  SER A 184      37.310  57.532  34.428  1.00 40.15           O  
ATOM    982  N   GLY A 185      39.828  58.593  33.201  1.00 37.12           N  
ATOM    983  CA  GLY A 185      40.609  59.721  33.634  1.00 38.03           C  
ATOM    984  C   GLY A 185      39.744  60.533  34.579  1.00 38.96           C  
ATOM    985  O   GLY A 185      38.605  60.157  34.896  1.00 39.27           O  
ATOM    986  N   THR A 186      40.300  61.650  35.029  1.00 38.86           N  
ATOM    987  CA  THR A 186      39.627  62.562  35.932  1.00 38.56           C  
ATOM    988  C   THR A 186      38.167  62.729  35.544  1.00 37.67           C  
ATOM    989  O   THR A 186      37.841  63.360  34.542  1.00 36.19           O  
ATOM    990  CB  THR A 186      40.323  63.910  35.900  1.00 40.17           C  
ATOM    991  OG1 THR A 186      41.744  63.698  35.785  1.00 41.47           O  
ATOM    992  CG2 THR A 186      40.029  64.678  37.171  1.00 39.91           C  
ATOM    993  N   LEU A 187      37.301  62.147  36.358  1.00 37.81           N  
ATOM    994  CA  LEU A 187      35.871  62.182  36.128  1.00 37.86           C  
ATOM    995  C   LEU A 187      35.282  63.559  35.920  1.00 38.11           C  
ATOM    996  O   LEU A 187      34.287  63.701  35.215  1.00 37.56           O  
ATOM    997  CB  LEU A 187      35.158  61.496  37.283  1.00 37.20           C  
ATOM    998  CG  LEU A 187      35.050  59.989  37.082  1.00 38.78           C  
ATOM    999  CD1 LEU A 187      34.489  59.338  38.336  1.00 38.74           C  
ATOM   1000  CD2 LEU A 187      34.174  59.713  35.864  1.00 36.15           C  
ATOM   1001  N   GLU A 188      35.889  64.572  36.528  1.00 38.84           N  
ATOM   1002  CA  GLU A 188      35.382  65.930  36.397  1.00 40.39           C  
ATOM   1003  C   GLU A 188      35.358  66.432  34.962  1.00 40.60           C  
ATOM   1004  O   GLU A 188      34.558  67.296  34.618  1.00 39.56           O  
ATOM   1005  CB  GLU A 188      36.194  66.881  37.262  1.00 41.94           C  
ATOM   1006  CG  GLU A 188      36.321  66.401  38.682  1.00 47.02           C  
ATOM   1007  CD  GLU A 188      37.591  65.600  38.903  1.00 51.91           C  
ATOM   1008  OE1 GLU A 188      38.644  66.237  39.124  1.00 55.16           O  
ATOM   1009  OE2 GLU A 188      37.552  64.345  38.846  1.00 54.03           O  
ATOM   1010  N   GLU A 189      36.226  65.885  34.118  1.00 41.76           N  
ATOM   1011  CA  GLU A 189      36.275  66.298  32.723  1.00 41.18           C  
ATOM   1012  C   GLU A 189      35.149  65.706  31.888  1.00 40.96           C  
ATOM   1013  O   GLU A 189      34.857  64.508  31.950  1.00 39.62           O  
ATOM   1014  CB  GLU A 189      37.605  65.904  32.106  1.00 42.81           C  
ATOM   1015  CG  GLU A 189      38.790  66.489  32.810  1.00 44.77           C  
ATOM   1016  CD  GLU A 189      40.087  66.151  32.114  1.00 45.42           C  
ATOM   1017  OE1 GLU A 189      41.147  66.466  32.692  1.00 46.59           O  
ATOM   1018  OE2 GLU A 189      40.045  65.582  30.997  1.00 44.57           O  
ATOM   1019  N   PRO A 190      34.512  66.543  31.069  1.00 41.06           N  
ATOM   1020  CA  PRO A 190      33.413  66.069  30.229  1.00 41.09           C  
ATOM   1021  C   PRO A 190      33.688  64.822  29.375  1.00 41.12           C  
ATOM   1022  O   PRO A 190      32.895  63.895  29.426  1.00 44.19           O  
ATOM   1023  CB  PRO A 190      33.064  67.302  29.401  1.00 40.85           C  
ATOM   1024  CG  PRO A 190      33.353  68.423  30.356  1.00 40.16           C  
ATOM   1025  CD  PRO A 190      34.685  68.001  30.940  1.00 40.65           C  
ATOM   1026  N   ILE A 191      34.775  64.776  28.597  1.00 39.78           N  
ATOM   1027  CA  ILE A 191      35.041  63.581  27.770  1.00 38.97           C  
ATOM   1028  C   ILE A 191      34.876  62.280  28.559  1.00 37.48           C  
ATOM   1029  O   ILE A 191      34.642  61.216  27.989  1.00 36.21           O  
ATOM   1030  CB  ILE A 191      36.482  63.550  27.180  1.00 40.34           C  
ATOM   1031  CG1 ILE A 191      37.489  63.924  28.272  1.00 42.80           C  
ATOM   1032  CG2 ILE A 191      36.575  64.427  25.952  1.00 39.58           C  
ATOM   1033  CD1 ILE A 191      38.934  63.724  27.884  1.00 44.69           C  
ATOM   1034  N   ASN A 192      35.014  62.368  29.873  1.00 36.54           N  
ATOM   1035  CA  ASN A 192      34.889  61.197  30.714  1.00 36.26           C  
ATOM   1036  C   ASN A 192      33.493  60.984  31.282  1.00 36.77           C  
ATOM   1037  O   ASN A 192      32.788  60.062  30.884  1.00 37.62           O  
ATOM   1038  CB  ASN A 192      35.875  61.275  31.869  1.00 37.08           C  
ATOM   1039  CG  ASN A 192      37.297  61.045  31.433  1.00 37.62           C  
ATOM   1040  OD1 ASN A 192      38.165  61.892  31.636  1.00 36.04           O  
ATOM   1041  ND2 ASN A 192      37.550  59.885  30.832  1.00 41.11           N  
ATOM   1042  N   HIS A 193      33.092  61.842  32.213  1.00 35.66           N  
ATOM   1043  CA  HIS A 193      31.797  61.689  32.849  1.00 33.60           C  
ATOM   1044  C   HIS A 193      30.623  61.825  31.909  1.00 33.54           C  
ATOM   1045  O   HIS A 193      29.549  61.278  32.175  1.00 35.87           O  
ATOM   1046  CB  HIS A 193      31.641  62.689  34.003  1.00 31.20           C  
ATOM   1047  CG  HIS A 193      31.295  64.081  33.572  1.00 30.05           C  
ATOM   1048  ND1 HIS A 193      32.124  65.158  33.800  1.00 29.96           N  
ATOM   1049  CD2 HIS A 193      30.206  64.576  32.934  1.00 27.97           C  
ATOM   1050  CE1 HIS A 193      31.565  66.255  33.320  1.00 27.40           C  
ATOM   1051  NE2 HIS A 193      30.400  65.928  32.788  1.00 25.90           N  
ATOM   1052  N   ALA A 194      30.823  62.536  30.806  1.00 31.63           N  
ATOM   1053  CA  ALA A 194      29.740  62.775  29.870  1.00 30.96           C  
ATOM   1054  C   ALA A 194      29.729  61.965  28.596  1.00 31.90           C  
ATOM   1055  O   ALA A 194      28.696  61.901  27.928  1.00 32.87           O  
ATOM   1056  CB  ALA A 194      29.694  64.249  29.515  1.00 26.85           C  
ATOM   1057  N   LYS A 195      30.851  61.341  28.252  1.00 32.46           N  
ATOM   1058  CA  LYS A 195      30.929  60.597  26.998  1.00 32.90           C  
ATOM   1059  C   LYS A 195      31.450  59.168  27.071  1.00 33.12           C  
ATOM   1060  O   LYS A 195      30.797  58.232  26.604  1.00 33.30           O  
ATOM   1061  CB  LYS A 195      31.802  61.374  26.017  1.00 33.03           C  
ATOM   1062  CG  LYS A 195      31.502  62.857  25.941  1.00 31.64           C  
ATOM   1063  CD  LYS A 195      30.249  63.161  25.146  1.00 32.59           C  
ATOM   1064  CE  LYS A 195      30.147  64.671  24.923  1.00 33.44           C  
ATOM   1065  NZ  LYS A 195      28.857  65.119  24.325  1.00 32.40           N  
ATOM   1066  N   LYS A 196      32.650  59.018  27.619  1.00 33.38           N  
ATOM   1067  CA  LYS A 196      33.290  57.717  27.745  1.00 33.46           C  
ATOM   1068  C   LYS A 196      32.602  56.839  28.784  1.00 33.64           C  
ATOM   1069  O   LYS A 196      32.390  55.653  28.545  1.00 34.48           O  
ATOM   1070  CB  LYS A 196      34.781  57.900  28.070  1.00 33.79           C  
ATOM   1071  CG  LYS A 196      35.599  58.434  26.891  1.00 31.83           C  
ATOM   1072  CD  LYS A 196      37.039  58.728  27.278  1.00 32.17           C  
ATOM   1073  CE  LYS A 196      37.922  58.936  26.046  1.00 30.71           C  
ATOM   1074  NZ  LYS A 196      39.299  59.372  26.396  1.00 28.06           N  
ATOM   1075  N   VAL A 197      32.245  57.410  29.930  1.00 32.90           N  
ATOM   1076  CA  VAL A 197      31.557  56.633  30.953  1.00 32.36           C  
ATOM   1077  C   VAL A 197      30.211  56.195  30.388  1.00 32.88           C  
ATOM   1078  O   VAL A 197      29.782  55.065  30.594  1.00 34.12           O  
ATOM   1079  CB  VAL A 197      31.281  57.458  32.248  1.00 31.84           C  
ATOM   1080  CG1 VAL A 197      30.520  56.613  33.237  1.00 29.41           C  
ATOM   1081  CG2 VAL A 197      32.577  57.928  32.877  1.00 30.71           C  
ATOM   1082  N   LYS A 198      29.563  57.095  29.654  1.00 33.22           N  
ATOM   1083  CA  LYS A 198      28.244  56.842  29.076  1.00 33.00           C  
ATOM   1084  C   LYS A 198      28.203  55.864  27.906  1.00 32.20           C  
ATOM   1085  O   LYS A 198      27.235  55.123  27.748  1.00 33.66           O  
ATOM   1086  CB  LYS A 198      27.599  58.179  28.685  1.00 33.56           C  
ATOM   1087  CG  LYS A 198      27.595  59.176  29.843  1.00 36.56           C  
ATOM   1088  CD  LYS A 198      26.200  59.547  30.319  1.00 39.46           C  
ATOM   1089  CE  LYS A 198      25.586  60.635  29.429  1.00 42.95           C  
ATOM   1090  NZ  LYS A 198      24.243  61.113  29.884  1.00 42.27           N  
ATOM   1091  N   GLY A 199      29.240  55.865  27.078  1.00 31.87           N  
ATOM   1092  CA  GLY A 199      29.280  54.940  25.958  1.00 29.66           C  
ATOM   1093  C   GLY A 199      29.602  53.568  26.509  1.00 28.47           C  
ATOM   1094  O   GLY A 199      29.247  52.550  25.943  1.00 29.46           O  
ATOM   1095  N   TYR A 200      30.296  53.545  27.634  1.00 27.81           N  
ATOM   1096  CA  TYR A 200      30.648  52.296  28.281  1.00 28.29           C  
ATOM   1097  C   TYR A 200      29.371  51.692  28.869  1.00 29.81           C  
ATOM   1098  O   TYR A 200      29.009  50.545  28.573  1.00 30.14           O  
ATOM   1099  CB  TYR A 200      31.702  52.569  29.369  1.00 27.38           C  
ATOM   1100  CG  TYR A 200      31.773  51.560  30.500  1.00 25.62           C  
ATOM   1101  CD1 TYR A 200      31.176  51.823  31.728  1.00 25.18           C  
ATOM   1102  CD2 TYR A 200      32.481  50.375  30.356  1.00 24.44           C  
ATOM   1103  CE1 TYR A 200      31.301  50.934  32.786  1.00 24.80           C  
ATOM   1104  CE2 TYR A 200      32.606  49.482  31.403  1.00 24.15           C  
ATOM   1105  CZ  TYR A 200      32.024  49.770  32.613  1.00 24.55           C  
ATOM   1106  OH  TYR A 200      32.214  48.913  33.660  1.00 25.00           O  
ATOM   1107  N   LYS A 201      28.681  52.472  29.695  1.00 30.25           N  
ATOM   1108  CA  LYS A 201      27.444  52.011  30.301  1.00 30.58           C  
ATOM   1109  C   LYS A 201      26.394  51.650  29.238  1.00 30.51           C  
ATOM   1110  O   LYS A 201      25.676  50.654  29.370  1.00 31.17           O  
ATOM   1111  CB  LYS A 201      26.936  53.074  31.279  1.00 28.89           C  
ATOM   1112  CG  LYS A 201      27.910  53.237  32.432  1.00 31.22           C  
ATOM   1113  CD  LYS A 201      27.663  54.455  33.285  1.00 31.51           C  
ATOM   1114  CE  LYS A 201      26.453  54.301  34.133  1.00 33.59           C  
ATOM   1115  NZ  LYS A 201      26.245  55.558  34.887  1.00 37.90           N  
ATOM   1116  N   ARG A 202      26.310  52.428  28.169  1.00 29.53           N  
ATOM   1117  CA  ARG A 202      25.340  52.105  27.143  1.00 30.32           C  
ATOM   1118  C   ARG A 202      25.601  50.670  26.654  1.00 31.55           C  
ATOM   1119  O   ARG A 202      24.692  49.835  26.632  1.00 30.34           O  
ATOM   1120  CB  ARG A 202      25.459  53.085  25.977  1.00 30.07           C  
ATOM   1121  CG  ARG A 202      24.127  53.489  25.373  1.00 28.88           C  
ATOM   1122  CD  ARG A 202      24.329  54.346  24.145  1.00 27.09           C  
ATOM   1123  NE  ARG A 202      24.346  53.515  22.955  1.00 29.21           N  
ATOM   1124  CZ  ARG A 202      25.138  53.721  21.908  1.00 30.04           C  
ATOM   1125  NH1 ARG A 202      25.978  54.742  21.915  1.00 31.03           N  
ATOM   1126  NH2 ARG A 202      25.096  52.901  20.862  1.00 28.80           N  
ATOM   1127  N   ALA A 203      26.852  50.391  26.285  1.00 31.31           N  
ATOM   1128  CA  ALA A 203      27.247  49.073  25.781  1.00 31.36           C  
ATOM   1129  C   ALA A 203      26.794  47.942  26.693  1.00 30.75           C  
ATOM   1130  O   ALA A 203      26.189  46.969  26.240  1.00 29.35           O  
ATOM   1131  CB  ALA A 203      28.771  49.015  25.589  1.00 30.75           C  
ATOM   1132  N   LEU A 204      27.096  48.068  27.981  1.00 30.39           N  
ATOM   1133  CA  LEU A 204      26.703  47.052  28.934  1.00 30.06           C  
ATOM   1134  C   LEU A 204      25.185  46.935  29.070  1.00 32.83           C  
ATOM   1135  O   LEU A 204      24.623  45.864  28.822  1.00 32.99           O  
ATOM   1136  CB  LEU A 204      27.335  47.332  30.294  1.00 27.69           C  
ATOM   1137  CG  LEU A 204      28.838  47.043  30.388  1.00 24.69           C  
ATOM   1138  CD1 LEU A 204      29.353  47.321  31.789  1.00 21.75           C  
ATOM   1139  CD2 LEU A 204      29.097  45.599  30.020  1.00 24.59           C  
ATOM   1140  N   THR A 205      24.512  48.025  29.435  1.00 34.15           N  
ATOM   1141  CA  THR A 205      23.064  47.953  29.596  1.00 35.14           C  
ATOM   1142  C   THR A 205      22.366  47.460  28.330  1.00 35.95           C  
ATOM   1143  O   THR A 205      21.429  46.672  28.416  1.00 38.00           O  
ATOM   1144  CB  THR A 205      22.436  49.312  30.042  1.00 34.52           C  
ATOM   1145  OG1 THR A 205      22.362  50.202  28.934  1.00 36.17           O  
ATOM   1146  CG2 THR A 205      23.271  49.959  31.142  1.00 33.94           C  
ATOM   1147  N   GLU A 206      22.810  47.894  27.156  1.00 36.46           N  
ATOM   1148  CA  GLU A 206      22.159  47.439  25.931  1.00 36.13           C  
ATOM   1149  C   GLU A 206      22.272  45.929  25.782  1.00 37.34           C  
ATOM   1150  O   GLU A 206      21.375  45.287  25.229  1.00 37.67           O  
ATOM   1151  CB  GLU A 206      22.730  48.153  24.698  1.00 35.83           C  
ATOM   1152  CG  GLU A 206      21.895  49.365  24.278  1.00 37.50           C  
ATOM   1153  CD  GLU A 206      22.544  50.236  23.198  1.00 39.89           C  
ATOM   1154  OE1 GLU A 206      22.993  49.695  22.149  1.00 40.88           O  
ATOM   1155  OE2 GLU A 206      22.587  51.474  23.402  1.00 39.15           O  
ATOM   1156  N   SER A 207      23.359  45.352  26.286  1.00 38.76           N  
ATOM   1157  CA  SER A 207      23.535  43.904  26.201  1.00 39.64           C  
ATOM   1158  C   SER A 207      23.013  43.225  27.473  1.00 40.21           C  
ATOM   1159  O   SER A 207      23.282  42.054  27.748  1.00 39.64           O  
ATOM   1160  CB  SER A 207      25.007  43.564  25.945  1.00 39.66           C  
ATOM   1161  OG  SER A 207      25.352  43.892  24.608  1.00 39.44           O  
ATOM   1162  N   GLY A 208      22.245  43.984  28.241  1.00 41.27           N  
ATOM   1163  CA  GLY A 208      21.665  43.459  29.455  1.00 41.73           C  
ATOM   1164  C   GLY A 208      22.685  42.985  30.455  1.00 42.31           C  
ATOM   1165  O   GLY A 208      22.479  41.965  31.103  1.00 43.85           O  
ATOM   1166  N   LEU A 209      23.787  43.715  30.575  1.00 42.25           N  
ATOM   1167  CA  LEU A 209      24.830  43.363  31.529  1.00 42.07           C  
ATOM   1168  C   LEU A 209      24.685  44.265  32.746  1.00 43.39           C  
ATOM   1169  O   LEU A 209      24.057  45.322  32.668  1.00 44.59           O  
ATOM   1170  CB  LEU A 209      26.202  43.540  30.887  1.00 39.28           C  
ATOM   1171  CG  LEU A 209      26.428  42.564  29.735  1.00 38.48           C  
ATOM   1172  CD1 LEU A 209      27.594  43.014  28.870  1.00 36.64           C  
ATOM   1173  CD2 LEU A 209      26.656  41.170  30.301  1.00 35.83           C  
ATOM   1174  N   PRO A 210      25.256  43.866  33.893  1.00 43.92           N  
ATOM   1175  CA  PRO A 210      25.135  44.705  35.087  1.00 44.44           C  
ATOM   1176  C   PRO A 210      26.127  45.873  35.077  1.00 44.40           C  
ATOM   1177  O   PRO A 210      27.223  45.768  34.522  1.00 43.76           O  
ATOM   1178  CB  PRO A 210      25.435  43.725  36.206  1.00 44.42           C  
ATOM   1179  CG  PRO A 210      26.565  42.946  35.614  1.00 43.86           C  
ATOM   1180  CD  PRO A 210      26.062  42.668  34.188  1.00 44.14           C  
ATOM   1181  N   VAL A 211      25.737  46.985  35.686  1.00 43.32           N  
ATOM   1182  CA  VAL A 211      26.623  48.129  35.760  1.00 43.01           C  
ATOM   1183  C   VAL A 211      26.993  48.378  37.218  1.00 44.41           C  
ATOM   1184  O   VAL A 211      26.230  48.966  37.980  1.00 45.49           O  
ATOM   1185  CB  VAL A 211      25.976  49.370  35.142  1.00 40.99           C  
ATOM   1186  CG1 VAL A 211      26.775  50.600  35.477  1.00 40.80           C  
ATOM   1187  CG2 VAL A 211      25.920  49.204  33.643  1.00 41.03           C  
ATOM   1188  N   ARG A 212      28.171  47.903  37.601  1.00 45.01           N  
ATOM   1189  CA  ARG A 212      28.660  48.057  38.959  1.00 46.23           C  
ATOM   1190  C   ARG A 212      29.388  49.397  39.087  1.00 46.23           C  
ATOM   1191  O   ARG A 212      30.064  49.821  38.154  1.00 46.86           O  
ATOM   1192  CB  ARG A 212      29.630  46.916  39.281  1.00 47.64           C  
ATOM   1193  CG  ARG A 212      29.349  45.615  38.522  1.00 51.64           C  
ATOM   1194  CD  ARG A 212      30.360  44.525  38.887  1.00 55.33           C  
ATOM   1195  NE  ARG A 212      30.266  43.336  38.033  1.00 58.88           N  
ATOM   1196  CZ  ARG A 212      29.233  42.496  38.015  1.00 60.49           C  
ATOM   1197  NH1 ARG A 212      28.190  42.701  38.804  1.00 60.66           N  
ATOM   1198  NH2 ARG A 212      29.242  41.443  37.206  1.00 62.40           N  
ATOM   1199  N   ASP A 213      29.248  50.069  40.225  1.00 45.68           N  
ATOM   1200  CA  ASP A 213      29.945  51.335  40.427  1.00 46.03           C  
ATOM   1201  C   ASP A 213      31.424  51.022  40.584  1.00 45.80           C  
ATOM   1202  O   ASP A 213      32.287  51.687  40.016  1.00 46.15           O  
ATOM   1203  CB  ASP A 213      29.463  52.038  41.697  1.00 48.33           C  
ATOM   1204  CG  ASP A 213      28.064  52.585  41.567  1.00 50.72           C  
ATOM   1205  OD1 ASP A 213      27.842  53.408  40.651  1.00 52.67           O  
ATOM   1206  OD2 ASP A 213      27.191  52.193  42.377  1.00 51.88           O  
ATOM   1207  N   SER A 214      31.703  49.993  41.372  1.00 45.19           N  
ATOM   1208  CA  SER A 214      33.064  49.557  41.631  1.00 43.99           C  
ATOM   1209  C   SER A 214      33.787  49.096  40.355  1.00 44.53           C  
ATOM   1210  O   SER A 214      34.978  48.781  40.391  1.00 45.02           O  
ATOM   1211  CB  SER A 214      33.041  48.414  42.641  1.00 42.83           C  
ATOM   1212  OG  SER A 214      32.347  47.299  42.109  1.00 42.95           O  
ATOM   1213  N   TYR A 215      33.084  49.041  39.231  1.00 43.41           N  
ATOM   1214  CA  TYR A 215      33.728  48.612  38.001  1.00 43.18           C  
ATOM   1215  C   TYR A 215      34.165  49.767  37.136  1.00 42.13           C  
ATOM   1216  O   TYR A 215      34.532  49.578  35.980  1.00 42.25           O  
ATOM   1217  CB  TYR A 215      32.817  47.707  37.198  1.00 44.63           C  
ATOM   1218  CG  TYR A 215      33.146  46.236  37.304  1.00 46.98           C  
ATOM   1219  CD1 TYR A 215      33.637  45.685  38.490  1.00 46.37           C  
ATOM   1220  CD2 TYR A 215      32.842  45.375  36.251  1.00 48.57           C  
ATOM   1221  CE1 TYR A 215      33.802  44.317  38.621  1.00 48.35           C  
ATOM   1222  CE2 TYR A 215      33.000  44.014  36.373  1.00 49.70           C  
ATOM   1223  CZ  TYR A 215      33.475  43.489  37.556  1.00 50.56           C  
ATOM   1224  OH  TYR A 215      33.586  42.128  37.663  1.00 53.80           O  
ATOM   1225  N   ILE A 216      34.097  50.970  37.686  1.00 40.69           N  
ATOM   1226  CA  ILE A 216      34.547  52.144  36.965  1.00 39.92           C  
ATOM   1227  C   ILE A 216      35.488  52.884  37.909  1.00 38.53           C  
ATOM   1228  O   ILE A 216      35.070  53.466  38.896  1.00 37.31           O  
ATOM   1229  CB  ILE A 216      33.346  53.012  36.466  1.00 40.21           C  
ATOM   1230  CG1 ILE A 216      33.784  54.462  36.264  1.00 41.55           C  
ATOM   1231  CG2 ILE A 216      32.163  52.862  37.390  1.00 41.39           C  
ATOM   1232  CD1 ILE A 216      33.656  55.341  37.489  1.00 44.51           C  
ATOM   1233  N   VAL A 217      36.782  52.808  37.615  1.00 39.38           N  
ATOM   1234  CA  VAL A 217      37.779  53.441  38.461  1.00 40.48           C  
ATOM   1235  C   VAL A 217      38.474  54.635  37.807  1.00 40.67           C  
ATOM   1236  O   VAL A 217      38.935  54.587  36.658  1.00 39.37           O  
ATOM   1237  CB  VAL A 217      38.840  52.407  38.959  1.00 40.25           C  
ATOM   1238  CG1 VAL A 217      38.142  51.139  39.427  1.00 37.72           C  
ATOM   1239  CG2 VAL A 217      39.834  52.102  37.878  1.00 42.31           C  
ATOM   1240  N   GLU A 218      38.516  55.717  38.573  1.00 41.66           N  
ATOM   1241  CA  GLU A 218      39.107  56.964  38.135  1.00 43.18           C  
ATOM   1242  C   GLU A 218      40.608  56.962  38.383  1.00 42.55           C  
ATOM   1243  O   GLU A 218      41.071  56.641  39.483  1.00 42.74           O  
ATOM   1244  CB  GLU A 218      38.429  58.136  38.876  1.00 45.06           C  
ATOM   1245  CG  GLU A 218      39.007  59.533  38.584  1.00 49.27           C  
ATOM   1246  CD  GLU A 218      38.205  60.678  39.214  1.00 49.50           C  
ATOM   1247  OE1 GLU A 218      38.610  61.856  39.044  1.00 48.12           O  
ATOM   1248  OE2 GLU A 218      37.173  60.396  39.865  1.00 50.08           O  
ATOM   1249  N   GLY A 219      41.359  57.298  37.337  1.00 41.18           N  
ATOM   1250  CA  GLY A 219      42.803  57.375  37.438  1.00 39.74           C  
ATOM   1251  C   GLY A 219      43.134  58.810  37.102  1.00 39.73           C  
ATOM   1252  O   GLY A 219      42.224  59.599  36.867  1.00 39.29           O  
ATOM   1253  N   ASP A 220      44.413  59.164  37.073  1.00 40.17           N  
ATOM   1254  CA  ASP A 220      44.781  60.535  36.746  1.00 39.05           C  
ATOM   1255  C   ASP A 220      45.660  60.658  35.517  1.00 37.70           C  
ATOM   1256  O   ASP A 220      46.497  61.551  35.453  1.00 38.16           O  
ATOM   1257  CB  ASP A 220      45.464  61.198  37.937  1.00 39.77           C  
ATOM   1258  CG  ASP A 220      46.547  60.335  38.541  1.00 41.61           C  
ATOM   1259  OD1 ASP A 220      47.590  60.134  37.896  1.00 41.03           O  
ATOM   1260  OD2 ASP A 220      46.348  59.848  39.673  1.00 44.55           O  
ATOM   1261  N   TYR A 221      45.462  59.765  34.546  1.00 35.73           N  
ATOM   1262  CA  TYR A 221      46.206  59.768  33.285  1.00 33.40           C  
ATOM   1263  C   TYR A 221      47.663  59.377  33.378  1.00 33.22           C  
ATOM   1264  O   TYR A 221      48.357  59.375  32.373  1.00 34.89           O  
ATOM   1265  CB  TYR A 221      46.137  61.137  32.606  1.00 32.86           C  
ATOM   1266  CG  TYR A 221      44.753  61.573  32.220  1.00 32.92           C  
ATOM   1267  CD1 TYR A 221      43.981  60.822  31.340  1.00 34.35           C  
ATOM   1268  CD2 TYR A 221      44.199  62.723  32.757  1.00 33.94           C  
ATOM   1269  CE1 TYR A 221      42.690  61.208  31.010  1.00 33.65           C  
ATOM   1270  CE2 TYR A 221      42.913  63.114  32.431  1.00 33.94           C  
ATOM   1271  CZ  TYR A 221      42.169  62.355  31.560  1.00 32.62           C  
ATOM   1272  OH  TYR A 221      40.910  62.755  31.221  1.00 33.50           O  
ATOM   1273  N   THR A 222      48.151  59.072  34.572  1.00 33.27           N  
ATOM   1274  CA  THR A 222      49.543  58.669  34.692  1.00 32.44           C  
ATOM   1275  C   THR A 222      49.593  57.175  34.548  1.00 33.05           C  
ATOM   1276  O   THR A 222      48.617  56.476  34.796  1.00 34.77           O  
ATOM   1277  CB  THR A 222      50.145  58.976  36.057  1.00 32.24           C  
ATOM   1278  OG1 THR A 222      49.444  58.227  37.055  1.00 34.05           O  
ATOM   1279  CG2 THR A 222      50.067  60.454  36.362  1.00 31.19           C  
ATOM   1280  N   TYR A 223      50.745  56.674  34.149  1.00 33.21           N  
ATOM   1281  CA  TYR A 223      50.890  55.250  34.009  1.00 30.93           C  
ATOM   1282  C   TYR A 223      50.660  54.591  35.375  1.00 31.42           C  
ATOM   1283  O   TYR A 223      50.008  53.559  35.464  1.00 31.69           O  
ATOM   1284  CB  TYR A 223      52.265  54.957  33.446  1.00 25.86           C  
ATOM   1285  CG  TYR A 223      52.700  53.544  33.590  1.00 23.64           C  
ATOM   1286  CD1 TYR A 223      53.428  53.148  34.698  1.00 23.61           C  
ATOM   1287  CD2 TYR A 223      52.451  52.606  32.584  1.00 23.01           C  
ATOM   1288  CE1 TYR A 223      53.917  51.865  34.802  1.00 23.60           C  
ATOM   1289  CE2 TYR A 223      52.932  51.316  32.682  1.00 22.16           C  
ATOM   1290  CZ  TYR A 223      53.673  50.960  33.793  1.00 23.29           C  
ATOM   1291  OH  TYR A 223      54.235  49.718  33.885  1.00 26.91           O  
ATOM   1292  N   ASP A 224      51.145  55.201  36.447  1.00 32.33           N  
ATOM   1293  CA  ASP A 224      50.935  54.615  37.768  1.00 34.90           C  
ATOM   1294  C   ASP A 224      49.467  54.465  38.181  1.00 33.90           C  
ATOM   1295  O   ASP A 224      49.094  53.488  38.835  1.00 33.09           O  
ATOM   1296  CB  ASP A 224      51.651  55.432  38.831  1.00 38.97           C  
ATOM   1297  CG  ASP A 224      53.133  55.501  38.596  1.00 44.06           C  
ATOM   1298  OD1 ASP A 224      53.729  54.426  38.339  1.00 46.18           O  
ATOM   1299  OD2 ASP A 224      53.698  56.618  38.672  1.00 46.22           O  
ATOM   1300  N   SER A 225      48.632  55.431  37.817  1.00 33.02           N  
ATOM   1301  CA  SER A 225      47.228  55.354  38.196  1.00 32.43           C  
ATOM   1302  C   SER A 225      46.615  54.107  37.577  1.00 30.43           C  
ATOM   1303  O   SER A 225      45.730  53.489  38.164  1.00 28.94           O  
ATOM   1304  CB  SER A 225      46.466  56.618  37.754  1.00 34.16           C  
ATOM   1305  OG  SER A 225      46.284  56.681  36.345  1.00 37.31           O  
ATOM   1306  N   GLY A 226      47.108  53.743  36.396  1.00 29.24           N  
ATOM   1307  CA  GLY A 226      46.619  52.567  35.707  1.00 29.11           C  
ATOM   1308  C   GLY A 226      46.913  51.302  36.496  1.00 30.54           C  
ATOM   1309  O   GLY A 226      46.047  50.429  36.644  1.00 29.47           O  
ATOM   1310  N   ILE A 227      48.140  51.188  36.996  1.00 30.91           N  
ATOM   1311  CA  ILE A 227      48.513  50.028  37.785  1.00 32.48           C  
ATOM   1312  C   ILE A 227      47.581  49.935  38.980  1.00 34.71           C  
ATOM   1313  O   ILE A 227      46.881  48.941  39.157  1.00 35.66           O  
ATOM   1314  CB  ILE A 227      49.939  50.136  38.323  1.00 32.68           C  
ATOM   1315  CG1 ILE A 227      50.932  50.144  37.169  1.00 33.44           C  
ATOM   1316  CG2 ILE A 227      50.218  48.984  39.256  1.00 30.42           C  
ATOM   1317  CD1 ILE A 227      52.341  50.393  37.615  1.00 40.40           C  
ATOM   1318  N   GLU A 228      47.562  50.983  39.797  1.00 36.67           N  
ATOM   1319  CA  GLU A 228      46.713  50.963  40.971  1.00 39.60           C  
ATOM   1320  C   GLU A 228      45.277  50.619  40.601  1.00 38.83           C  
ATOM   1321  O   GLU A 228      44.562  49.968  41.363  1.00 40.94           O  
ATOM   1322  CB  GLU A 228      46.778  52.306  41.709  1.00 44.04           C  
ATOM   1323  CG  GLU A 228      45.825  53.389  41.213  1.00 50.50           C  
ATOM   1324  CD  GLU A 228      45.919  54.653  42.063  1.00 53.24           C  
ATOM   1325  OE1 GLU A 228      45.978  54.517  43.305  1.00 52.72           O  
ATOM   1326  OE2 GLU A 228      45.929  55.774  41.497  1.00 56.71           O  
ATOM   1327  N   ALA A 229      44.855  51.038  39.421  1.00 36.58           N  
ATOM   1328  CA  ALA A 229      43.509  50.758  38.993  1.00 34.72           C  
ATOM   1329  C   ALA A 229      43.253  49.264  38.818  1.00 34.70           C  
ATOM   1330  O   ALA A 229      42.200  48.772  39.225  1.00 32.27           O  
ATOM   1331  CB  ALA A 229      43.222  51.497  37.709  1.00 35.25           C  
ATOM   1332  N   VAL A 230      44.196  48.539  38.213  1.00 35.89           N  
ATOM   1333  CA  VAL A 230      44.008  47.097  38.018  1.00 37.83           C  
ATOM   1334  C   VAL A 230      44.041  46.372  39.349  1.00 39.23           C  
ATOM   1335  O   VAL A 230      43.384  45.351  39.524  1.00 39.28           O  
ATOM   1336  CB  VAL A 230      45.088  46.439  37.133  1.00 37.21           C  
ATOM   1337  CG1 VAL A 230      44.410  45.576  36.078  1.00 34.61           C  
ATOM   1338  CG2 VAL A 230      45.996  47.478  36.522  1.00 37.06           C  
ATOM   1339  N   GLU A 231      44.822  46.889  40.287  1.00 41.03           N  
ATOM   1340  CA  GLU A 231      44.884  46.257  41.588  1.00 43.38           C  
ATOM   1341  C   GLU A 231      43.548  46.403  42.291  1.00 42.31           C  
ATOM   1342  O   GLU A 231      43.005  45.419  42.775  1.00 41.89           O  
ATOM   1343  CB  GLU A 231      46.005  46.853  42.438  1.00 47.01           C  
ATOM   1344  CG  GLU A 231      47.393  46.526  41.916  1.00 52.12           C  
ATOM   1345  CD  GLU A 231      48.448  46.576  42.997  1.00 55.86           C  
ATOM   1346  OE1 GLU A 231      49.620  46.872  42.662  1.00 56.73           O  
ATOM   1347  OE2 GLU A 231      48.103  46.312  44.176  1.00 57.85           O  
ATOM   1348  N   LYS A 232      43.019  47.622  42.349  1.00 41.67           N  
ATOM   1349  CA  LYS A 232      41.728  47.831  42.987  1.00 42.18           C  
ATOM   1350  C   LYS A 232      40.740  46.860  42.358  1.00 42.04           C  
ATOM   1351  O   LYS A 232      40.020  46.152  43.055  1.00 42.70           O  
ATOM   1352  CB  LYS A 232      41.205  49.253  42.765  1.00 42.76           C  
ATOM   1353  CG  LYS A 232      42.173  50.367  43.126  1.00 46.86           C  
ATOM   1354  CD  LYS A 232      41.591  51.744  42.749  1.00 48.22           C  
ATOM   1355  CE  LYS A 232      42.618  52.869  42.879  1.00 47.06           C  
ATOM   1356  NZ  LYS A 232      42.076  54.193  42.460  1.00 47.57           N  
ATOM   1357  N   LEU A 233      40.713  46.825  41.031  1.00 42.05           N  
ATOM   1358  CA  LEU A 233      39.796  45.955  40.311  1.00 42.26           C  
ATOM   1359  C   LEU A 233      39.999  44.467  40.597  1.00 43.41           C  
ATOM   1360  O   LEU A 233      39.032  43.699  40.683  1.00 42.82           O  
ATOM   1361  CB  LEU A 233      39.898  46.242  38.811  1.00 42.09           C  
ATOM   1362  CG  LEU A 233      39.186  47.525  38.357  1.00 41.08           C  
ATOM   1363  CD1 LEU A 233      39.575  47.889  36.929  1.00 39.73           C  
ATOM   1364  CD2 LEU A 233      37.683  47.312  38.476  1.00 39.35           C  
ATOM   1365  N   LEU A 234      41.249  44.056  40.763  1.00 44.80           N  
ATOM   1366  CA  LEU A 234      41.522  42.662  41.047  1.00 45.61           C  
ATOM   1367  C   LEU A 234      41.258  42.320  42.506  1.00 47.98           C  
ATOM   1368  O   LEU A 234      41.324  41.159  42.893  1.00 50.09           O  
ATOM   1369  CB  LEU A 234      42.951  42.313  40.643  1.00 44.56           C  
ATOM   1370  CG  LEU A 234      43.126  42.339  39.119  1.00 44.30           C  
ATOM   1371  CD1 LEU A 234      44.548  41.986  38.732  1.00 43.08           C  
ATOM   1372  CD2 LEU A 234      42.142  41.366  38.484  1.00 43.51           C  
ATOM   1373  N   GLU A 235      40.954  43.329  43.318  1.00 50.15           N  
ATOM   1374  CA  GLU A 235      40.630  43.101  44.725  1.00 53.45           C  
ATOM   1375  C   GLU A 235      39.116  43.015  44.789  1.00 53.99           C  
ATOM   1376  O   GLU A 235      38.535  43.023  45.870  1.00 53.73           O  
ATOM   1377  CB  GLU A 235      41.055  44.274  45.606  1.00 56.33           C  
ATOM   1378  CG  GLU A 235      42.540  44.568  45.667  1.00 63.32           C  
ATOM   1379  CD  GLU A 235      42.802  45.993  46.143  1.00 66.93           C  
ATOM   1380  OE1 GLU A 235      42.201  46.386  47.171  1.00 68.94           O  
ATOM   1381  OE2 GLU A 235      43.596  46.718  45.492  1.00 69.02           O  
ATOM   1382  N   GLU A 236      38.479  42.945  43.623  1.00 55.02           N  
ATOM   1383  CA  GLU A 236      37.025  42.892  43.562  1.00 56.20           C  
ATOM   1384  C   GLU A 236      36.435  41.503  43.775  1.00 56.60           C  
ATOM   1385  O   GLU A 236      37.087  40.482  43.515  1.00 57.37           O  
ATOM   1386  CB  GLU A 236      36.531  43.444  42.226  1.00 57.14           C  
ATOM   1387  CG  GLU A 236      35.270  44.271  42.367  1.00 59.35           C  
ATOM   1388  CD  GLU A 236      35.508  45.552  43.156  1.00 61.28           C  
ATOM   1389  OE1 GLU A 236      34.599  45.976  43.898  1.00 62.75           O  
ATOM   1390  OE2 GLU A 236      36.603  46.146  43.028  1.00 62.17           O  
ATOM   1391  N   ASP A 237      35.193  41.486  44.257  1.00 56.26           N  
ATOM   1392  CA  ASP A 237      34.463  40.253  44.506  1.00 55.53           C  
ATOM   1393  C   ASP A 237      34.751  39.411  43.277  1.00 53.45           C  
ATOM   1394  O   ASP A 237      35.619  38.532  43.304  1.00 52.13           O  
ATOM   1395  CB  ASP A 237      32.963  40.559  44.626  1.00 59.07           C  
ATOM   1396  CG  ASP A 237      32.214  39.537  45.484  1.00 62.09           C  
ATOM   1397  OD1 ASP A 237      32.667  39.265  46.622  1.00 62.67           O  
ATOM   1398  OD2 ASP A 237      31.167  39.018  45.023  1.00 63.34           O  
ATOM   1399  N   GLU A 238      34.035  39.687  42.192  1.00 51.11           N  
ATOM   1400  CA  GLU A 238      34.297  38.968  40.962  1.00 48.28           C  
ATOM   1401  C   GLU A 238      35.066  39.913  40.061  1.00 45.57           C  
ATOM   1402  O   GLU A 238      34.623  41.022  39.782  1.00 46.05           O  
ATOM   1403  CB  GLU A 238      33.004  38.463  40.312  1.00 48.38           C  
ATOM   1404  CG  GLU A 238      32.006  39.476  39.836  1.00 48.23           C  
ATOM   1405  CD  GLU A 238      30.735  38.792  39.320  1.00 48.48           C  
ATOM   1406  OE1 GLU A 238      30.845  37.770  38.600  1.00 43.64           O  
ATOM   1407  OE2 GLU A 238      29.627  39.280  39.630  1.00 50.42           O  
ATOM   1408  N   LYS A 239      36.253  39.466  39.657  1.00 42.68           N  
ATOM   1409  CA  LYS A 239      37.155  40.245  38.820  1.00 38.56           C  
ATOM   1410  C   LYS A 239      36.582  40.536  37.445  1.00 34.34           C  
ATOM   1411  O   LYS A 239      35.591  39.954  37.040  1.00 33.72           O  
ATOM   1412  CB  LYS A 239      38.479  39.496  38.613  1.00 40.35           C  
ATOM   1413  CG  LYS A 239      38.945  38.587  39.741  1.00 42.09           C  
ATOM   1414  CD  LYS A 239      39.304  39.327  41.013  1.00 43.54           C  
ATOM   1415  CE  LYS A 239      40.306  38.511  41.816  1.00 44.21           C  
ATOM   1416  NZ  LYS A 239      39.899  37.072  41.918  1.00 45.30           N  
ATOM   1417  N   PRO A 240      37.196  41.469  36.714  1.00 31.55           N  
ATOM   1418  CA  PRO A 240      36.664  41.736  35.384  1.00 28.51           C  
ATOM   1419  C   PRO A 240      37.496  40.873  34.444  1.00 26.92           C  
ATOM   1420  O   PRO A 240      38.652  40.561  34.744  1.00 23.44           O  
ATOM   1421  CB  PRO A 240      36.957  43.220  35.173  1.00 28.69           C  
ATOM   1422  CG  PRO A 240      37.301  43.749  36.560  1.00 30.49           C  
ATOM   1423  CD  PRO A 240      38.018  42.598  37.175  1.00 31.23           C  
ATOM   1424  N   THR A 241      36.911  40.466  33.321  1.00 26.31           N  
ATOM   1425  CA  THR A 241      37.665  39.686  32.362  1.00 24.95           C  
ATOM   1426  C   THR A 241      38.122  40.618  31.246  1.00 25.02           C  
ATOM   1427  O   THR A 241      38.939  40.257  30.403  1.00 27.11           O  
ATOM   1428  CB  THR A 241      36.843  38.522  31.808  1.00 23.82           C  
ATOM   1429  OG1 THR A 241      35.540  38.972  31.428  1.00 25.67           O  
ATOM   1430  CG2 THR A 241      36.716  37.446  32.861  1.00 23.75           C  
ATOM   1431  N   ALA A 242      37.608  41.839  31.251  1.00 24.44           N  
ATOM   1432  CA  ALA A 242      38.010  42.814  30.252  1.00 23.52           C  
ATOM   1433  C   ALA A 242      37.920  44.207  30.846  1.00 23.91           C  
ATOM   1434  O   ALA A 242      36.943  44.540  31.524  1.00 23.90           O  
ATOM   1435  CB  ALA A 242      37.122  42.712  29.021  1.00 23.81           C  
ATOM   1436  N   ILE A 243      38.952  45.014  30.610  1.00 23.03           N  
ATOM   1437  CA  ILE A 243      38.956  46.377  31.107  1.00 22.06           C  
ATOM   1438  C   ILE A 243      39.220  47.369  29.988  1.00 22.48           C  
ATOM   1439  O   ILE A 243      40.226  47.292  29.288  1.00 25.27           O  
ATOM   1440  CB  ILE A 243      40.041  46.609  32.142  1.00 24.08           C  
ATOM   1441  CG1 ILE A 243      40.023  45.506  33.198  1.00 22.30           C  
ATOM   1442  CG2 ILE A 243      39.872  48.014  32.716  1.00 20.72           C  
ATOM   1443  CD1 ILE A 243      41.225  45.538  34.111  1.00 32.69           C  
ATOM   1444  N   PHE A 244      38.310  48.309  29.828  1.00 23.27           N  
ATOM   1445  CA  PHE A 244      38.437  49.353  28.826  1.00 23.97           C  
ATOM   1446  C   PHE A 244      39.103  50.504  29.564  1.00 23.27           C  
ATOM   1447  O   PHE A 244      38.671  50.874  30.659  1.00 23.79           O  
ATOM   1448  CB  PHE A 244      37.039  49.747  28.349  1.00 26.86           C  
ATOM   1449  CG  PHE A 244      36.993  50.980  27.503  1.00 29.30           C  
ATOM   1450  CD1 PHE A 244      37.731  51.067  26.327  1.00 31.02           C  
ATOM   1451  CD2 PHE A 244      36.159  52.036  27.853  1.00 28.79           C  
ATOM   1452  CE1 PHE A 244      37.627  52.201  25.505  1.00 31.17           C  
ATOM   1453  CE2 PHE A 244      36.054  53.161  27.042  1.00 29.67           C  
ATOM   1454  CZ  PHE A 244      36.789  53.244  25.864  1.00 28.80           C  
ATOM   1455  N   VAL A 245      40.168  51.049  28.988  1.00 23.24           N  
ATOM   1456  CA  VAL A 245      40.872  52.157  29.615  1.00 24.15           C  
ATOM   1457  C   VAL A 245      40.757  53.429  28.787  1.00 24.00           C  
ATOM   1458  O   VAL A 245      40.859  53.389  27.572  1.00 24.01           O  
ATOM   1459  CB  VAL A 245      42.364  51.847  29.818  1.00 23.82           C  
ATOM   1460  CG1 VAL A 245      42.993  52.954  30.618  1.00 25.79           C  
ATOM   1461  CG2 VAL A 245      42.545  50.535  30.534  1.00 22.29           C  
ATOM   1462  N   GLY A 246      40.541  54.552  29.465  1.00 25.00           N  
ATOM   1463  CA  GLY A 246      40.405  55.841  28.805  1.00 26.12           C  
ATOM   1464  C   GLY A 246      41.552  56.362  27.939  1.00 27.09           C  
ATOM   1465  O   GLY A 246      41.292  57.130  27.025  1.00 28.98           O  
ATOM   1466  N   THR A 247      42.806  56.008  28.219  1.00 28.02           N  
ATOM   1467  CA  THR A 247      43.939  56.451  27.372  1.00 28.02           C  
ATOM   1468  C   THR A 247      45.029  55.393  27.378  1.00 27.16           C  
ATOM   1469  O   THR A 247      45.138  54.604  28.317  1.00 26.43           O  
ATOM   1470  CB  THR A 247      44.602  57.785  27.841  1.00 27.93           C  
ATOM   1471  OG1 THR A 247      45.336  57.571  29.060  1.00 27.30           O  
ATOM   1472  CG2 THR A 247      43.556  58.860  28.036  1.00 25.85           C  
ATOM   1473  N   ASP A 248      45.855  55.394  26.344  1.00 26.33           N  
ATOM   1474  CA  ASP A 248      46.904  54.401  26.247  1.00 26.64           C  
ATOM   1475  C   ASP A 248      47.834  54.271  27.445  1.00 27.27           C  
ATOM   1476  O   ASP A 248      48.035  53.169  27.930  1.00 29.77           O  
ATOM   1477  CB  ASP A 248      47.727  54.619  24.984  1.00 26.92           C  
ATOM   1478  CG  ASP A 248      46.919  54.407  23.725  1.00 29.14           C  
ATOM   1479  OD1 ASP A 248      45.838  53.774  23.802  1.00 31.58           O  
ATOM   1480  OD2 ASP A 248      47.370  54.864  22.655  1.00 26.39           O  
ATOM   1481  N   GLU A 249      48.404  55.362  27.942  1.00 27.15           N  
ATOM   1482  CA  GLU A 249      49.324  55.246  29.072  1.00 26.16           C  
ATOM   1483  C   GLU A 249      48.754  54.580  30.328  1.00 25.00           C  
ATOM   1484  O   GLU A 249      49.447  53.813  30.992  1.00 25.92           O  
ATOM   1485  CB  GLU A 249      49.892  56.602  29.449  1.00 28.80           C  
ATOM   1486  CG  GLU A 249      51.138  56.474  30.284  1.00 31.22           C  
ATOM   1487  CD  GLU A 249      51.788  57.799  30.533  1.00 31.90           C  
ATOM   1488  OE1 GLU A 249      51.697  58.665  29.642  1.00 32.48           O  
ATOM   1489  OE2 GLU A 249      52.398  57.969  31.607  1.00 34.09           O  
ATOM   1490  N   MET A 250      47.515  54.870  30.693  1.00 22.44           N  
ATOM   1491  CA  MET A 250      46.976  54.197  31.864  1.00 20.15           C  
ATOM   1492  C   MET A 250      46.823  52.740  31.463  1.00 17.88           C  
ATOM   1493  O   MET A 250      47.113  51.830  32.232  1.00 16.61           O  
ATOM   1494  CB  MET A 250      45.625  54.785  32.275  1.00 19.83           C  
ATOM   1495  CG  MET A 250      45.742  56.013  33.162  1.00 20.76           C  
ATOM   1496  SD  MET A 250      44.139  56.740  33.588  1.00 27.12           S  
ATOM   1497  CE  MET A 250      43.332  56.790  31.926  1.00 20.19           C  
ATOM   1498  N   ALA A 251      46.381  52.534  30.229  1.00 17.13           N  
ATOM   1499  CA  ALA A 251      46.192  51.200  29.696  1.00 16.65           C  
ATOM   1500  C   ALA A 251      47.473  50.401  29.876  1.00 17.14           C  
ATOM   1501  O   ALA A 251      47.449  49.293  30.386  1.00 18.07           O  
ATOM   1502  CB  ALA A 251      45.809  51.277  28.233  1.00 14.88           C  
ATOM   1503  N   LEU A 252      48.598  50.968  29.467  1.00 18.42           N  
ATOM   1504  CA  LEU A 252      49.872  50.286  29.625  1.00 20.86           C  
ATOM   1505  C   LEU A 252      50.077  49.915  31.101  1.00 21.52           C  
ATOM   1506  O   LEU A 252      50.632  48.859  31.420  1.00 20.76           O  
ATOM   1507  CB  LEU A 252      51.019  51.172  29.110  1.00 20.39           C  
ATOM   1508  CG  LEU A 252      51.504  50.899  27.671  1.00 20.81           C  
ATOM   1509  CD1 LEU A 252      50.364  51.061  26.645  1.00 17.48           C  
ATOM   1510  CD2 LEU A 252      52.671  51.830  27.350  1.00 19.61           C  
ATOM   1511  N   GLY A 253      49.613  50.784  31.996  1.00 22.17           N  
ATOM   1512  CA  GLY A 253      49.727  50.514  33.423  1.00 21.80           C  
ATOM   1513  C   GLY A 253      48.802  49.380  33.853  1.00 22.03           C  
ATOM   1514  O   GLY A 253      49.099  48.626  34.783  1.00 22.44           O  
ATOM   1515  N   VAL A 254      47.669  49.258  33.172  1.00 21.15           N  
ATOM   1516  CA  VAL A 254      46.717  48.203  33.469  1.00 20.72           C  
ATOM   1517  C   VAL A 254      47.333  46.859  33.079  1.00 21.73           C  
ATOM   1518  O   VAL A 254      47.329  45.905  33.863  1.00 21.98           O  
ATOM   1519  CB  VAL A 254      45.415  48.439  32.689  1.00 21.02           C  
ATOM   1520  CG1 VAL A 254      44.462  47.289  32.884  1.00 19.37           C  
ATOM   1521  CG2 VAL A 254      44.768  49.757  33.151  1.00 22.39           C  
ATOM   1522  N   ILE A 255      47.874  46.796  31.864  1.00 21.99           N  
ATOM   1523  CA  ILE A 255      48.498  45.583  31.348  1.00 21.80           C  
ATOM   1524  C   ILE A 255      49.526  45.118  32.355  1.00 23.90           C  
ATOM   1525  O   ILE A 255      49.492  43.983  32.841  1.00 24.81           O  
ATOM   1526  CB  ILE A 255      49.300  45.835  30.046  1.00 23.36           C  
ATOM   1527  CG1 ILE A 255      48.413  46.404  28.933  1.00 23.47           C  
ATOM   1528  CG2 ILE A 255      49.990  44.548  29.625  1.00 20.43           C  
ATOM   1529  CD1 ILE A 255      47.568  45.408  28.261  1.00 36.18           C  
ATOM   1530  N   HIS A 256      50.449  46.021  32.665  1.00 24.15           N  
ATOM   1531  CA  HIS A 256      51.540  45.700  33.560  1.00 24.17           C  
ATOM   1532  C   HIS A 256      51.141  45.223  34.945  1.00 24.50           C  
ATOM   1533  O   HIS A 256      51.637  44.193  35.402  1.00 24.03           O  
ATOM   1534  CB  HIS A 256      52.530  46.875  33.594  1.00 22.18           C  
ATOM   1535  CG  HIS A 256      53.376  46.958  32.356  1.00 22.41           C  
ATOM   1536  ND1 HIS A 256      54.058  48.095  31.981  1.00 22.63           N  
ATOM   1537  CD2 HIS A 256      53.624  46.040  31.391  1.00 21.49           C  
ATOM   1538  CE1 HIS A 256      54.682  47.878  30.836  1.00 20.01           C  
ATOM   1539  NE2 HIS A 256      54.434  46.637  30.459  1.00 20.64           N  
ATOM   1540  N   GLY A 257      50.241  45.938  35.606  1.00 24.80           N  
ATOM   1541  CA  GLY A 257      49.824  45.496  36.923  1.00 25.31           C  
ATOM   1542  C   GLY A 257      49.199  44.115  36.825  1.00 26.43           C  
ATOM   1543  O   GLY A 257      49.459  43.239  37.645  1.00 26.19           O  
ATOM   1544  N   ALA A 258      48.369  43.909  35.810  1.00 26.48           N  
ATOM   1545  CA  ALA A 258      47.729  42.625  35.653  1.00 26.77           C  
ATOM   1546  C   ALA A 258      48.799  41.579  35.405  1.00 28.67           C  
ATOM   1547  O   ALA A 258      48.695  40.466  35.915  1.00 31.65           O  
ATOM   1548  CB  ALA A 258      46.764  42.669  34.508  1.00 27.12           C  
ATOM   1549  N   GLN A 259      49.828  41.939  34.628  1.00 28.51           N  
ATOM   1550  CA  GLN A 259      50.934  41.030  34.304  1.00 26.41           C  
ATOM   1551  C   GLN A 259      51.862  40.729  35.486  1.00 25.45           C  
ATOM   1552  O   GLN A 259      52.516  39.688  35.520  1.00 23.22           O  
ATOM   1553  CB  GLN A 259      51.768  41.594  33.162  1.00 26.67           C  
ATOM   1554  CG  GLN A 259      51.083  41.610  31.826  1.00 29.47           C  
ATOM   1555  CD  GLN A 259      52.022  42.027  30.685  1.00 32.25           C  
ATOM   1556  OE1 GLN A 259      52.847  42.938  30.835  1.00 34.48           O  
ATOM   1557  NE2 GLN A 259      51.876  41.376  29.533  1.00 31.94           N  
ATOM   1558  N   ASP A 260      51.942  41.652  36.441  1.00 26.57           N  
ATOM   1559  CA  ASP A 260      52.765  41.452  37.636  1.00 27.65           C  
ATOM   1560  C   ASP A 260      52.044  40.596  38.685  1.00 28.94           C  
ATOM   1561  O   ASP A 260      52.689  39.953  39.511  1.00 30.45           O  
ATOM   1562  CB  ASP A 260      53.137  42.778  38.284  1.00 25.74           C  
ATOM   1563  CG  ASP A 260      53.989  43.642  37.400  1.00 25.96           C  
ATOM   1564  OD1 ASP A 260      54.646  43.121  36.472  1.00 26.92           O  
ATOM   1565  OD2 ASP A 260      54.014  44.858  37.655  1.00 25.77           O  
ATOM   1566  N   ARG A 261      50.713  40.602  38.664  1.00 29.00           N  
ATOM   1567  CA  ARG A 261      49.943  39.806  39.603  1.00 30.30           C  
ATOM   1568  C   ARG A 261      49.951  38.358  39.120  1.00 30.54           C  
ATOM   1569  O   ARG A 261      49.737  37.437  39.898  1.00 32.88           O  
ATOM   1570  CB  ARG A 261      48.495  40.297  39.682  1.00 32.85           C  
ATOM   1571  CG  ARG A 261      48.299  41.706  40.214  1.00 36.16           C  
ATOM   1572  CD  ARG A 261      48.668  41.817  41.669  1.00 42.39           C  
ATOM   1573  NE  ARG A 261      47.710  42.626  42.428  1.00 49.29           N  
ATOM   1574  CZ  ARG A 261      46.586  42.148  42.967  1.00 52.76           C  
ATOM   1575  NH1 ARG A 261      46.277  40.857  42.833  1.00 54.28           N  
ATOM   1576  NH2 ARG A 261      45.765  42.958  43.633  1.00 53.93           N  
ATOM   1577  N   GLY A 262      50.186  38.153  37.831  1.00 30.55           N  
ATOM   1578  CA  GLY A 262      50.216  36.799  37.310  1.00 29.36           C  
ATOM   1579  C   GLY A 262      49.188  36.510  36.237  1.00 29.16           C  
ATOM   1580  O   GLY A 262      49.111  35.373  35.750  1.00 28.68           O  
ATOM   1581  N   LEU A 263      48.399  37.524  35.875  1.00 28.06           N  
ATOM   1582  CA  LEU A 263      47.379  37.374  34.840  1.00 27.43           C  
ATOM   1583  C   LEU A 263      48.005  37.585  33.484  1.00 27.29           C  
ATOM   1584  O   LEU A 263      48.959  38.346  33.365  1.00 26.55           O  
ATOM   1585  CB  LEU A 263      46.266  38.396  35.015  1.00 27.72           C  
ATOM   1586  CG  LEU A 263      45.264  38.179  36.138  1.00 28.50           C  
ATOM   1587  CD1 LEU A 263      44.098  39.155  35.992  1.00 27.41           C  
ATOM   1588  CD2 LEU A 263      44.764  36.756  36.068  1.00 31.01           C  
ATOM   1589  N   ASN A 264      47.450  36.918  32.472  1.00 28.58           N  
ATOM   1590  CA  ASN A 264      47.922  37.003  31.084  1.00 28.66           C  
ATOM   1591  C   ASN A 264      46.971  37.795  30.201  1.00 29.45           C  
ATOM   1592  O   ASN A 264      45.749  37.584  30.231  1.00 28.19           O  
ATOM   1593  CB  ASN A 264      48.077  35.598  30.481  1.00 29.32           C  
ATOM   1594  CG  ASN A 264      48.285  35.622  28.971  1.00 30.65           C  
ATOM   1595  OD1 ASN A 264      47.422  36.069  28.216  1.00 32.60           O  
ATOM   1596  ND2 ASN A 264      49.434  35.140  28.527  1.00 31.33           N  
ATOM   1597  N   VAL A 265      47.546  38.701  29.413  1.00 28.88           N  
ATOM   1598  CA  VAL A 265      46.779  39.509  28.475  1.00 28.90           C  
ATOM   1599  C   VAL A 265      47.100  38.925  27.087  1.00 28.88           C  
ATOM   1600  O   VAL A 265      48.255  38.831  26.698  1.00 29.62           O  
ATOM   1601  CB  VAL A 265      47.222  40.986  28.547  1.00 28.82           C  
ATOM   1602  CG1 VAL A 265      46.520  41.806  27.479  1.00 28.60           C  
ATOM   1603  CG2 VAL A 265      46.931  41.540  29.914  1.00 26.33           C  
ATOM   1604  N   PRO A 266      46.073  38.583  26.295  1.00 28.74           N  
ATOM   1605  CA  PRO A 266      44.624  38.667  26.511  1.00 29.78           C  
ATOM   1606  C   PRO A 266      43.918  37.404  27.035  1.00 32.08           C  
ATOM   1607  O   PRO A 266      42.698  37.399  27.230  1.00 32.61           O  
ATOM   1608  CB  PRO A 266      44.133  39.011  25.123  1.00 27.65           C  
ATOM   1609  CG  PRO A 266      44.980  38.125  24.302  1.00 25.64           C  
ATOM   1610  CD  PRO A 266      46.355  38.336  24.873  1.00 26.23           C  
ATOM   1611  N   ASN A 267      44.674  36.336  27.254  1.00 33.68           N  
ATOM   1612  CA  ASN A 267      44.102  35.071  27.705  1.00 32.72           C  
ATOM   1613  C   ASN A 267      43.376  35.045  29.041  1.00 32.88           C  
ATOM   1614  O   ASN A 267      42.647  34.102  29.320  1.00 33.10           O  
ATOM   1615  CB  ASN A 267      45.189  34.010  27.690  1.00 34.40           C  
ATOM   1616  CG  ASN A 267      45.604  33.653  26.291  1.00 35.84           C  
ATOM   1617  OD1 ASN A 267      44.846  33.034  25.556  1.00 39.88           O  
ATOM   1618  ND2 ASN A 267      46.800  34.060  25.904  1.00 39.72           N  
ATOM   1619  N   ASP A 268      43.564  36.064  29.870  1.00 32.80           N  
ATOM   1620  CA  ASP A 268      42.894  36.104  31.163  1.00 31.38           C  
ATOM   1621  C   ASP A 268      42.162  37.431  31.337  1.00 30.26           C  
ATOM   1622  O   ASP A 268      41.115  37.501  31.978  1.00 29.66           O  
ATOM   1623  CB  ASP A 268      43.920  35.924  32.288  1.00 33.29           C  
ATOM   1624  CG  ASP A 268      44.479  34.506  32.361  1.00 35.90           C  
ATOM   1625  OD1 ASP A 268      45.636  34.347  32.814  1.00 37.17           O  
ATOM   1626  OD2 ASP A 268      43.767  33.545  31.986  1.00 36.26           O  
ATOM   1627  N   LEU A 269      42.721  38.478  30.738  1.00 28.51           N  
ATOM   1628  CA  LEU A 269      42.172  39.821  30.833  1.00 25.12           C  
ATOM   1629  C   LEU A 269      42.375  40.547  29.518  1.00 23.85           C  
ATOM   1630  O   LEU A 269      43.498  40.825  29.141  1.00 23.16           O  
ATOM   1631  CB  LEU A 269      42.902  40.567  31.950  1.00 24.48           C  
ATOM   1632  CG  LEU A 269      42.551  41.989  32.399  1.00 24.79           C  
ATOM   1633  CD1 LEU A 269      41.175  42.001  33.055  1.00 26.66           C  
ATOM   1634  CD2 LEU A 269      43.586  42.475  33.407  1.00 21.88           C  
ATOM   1635  N   GLU A 270      41.298  40.827  28.796  1.00 23.87           N  
ATOM   1636  CA  GLU A 270      41.433  41.558  27.545  1.00 23.65           C  
ATOM   1637  C   GLU A 270      41.387  43.047  27.904  1.00 23.73           C  
ATOM   1638  O   GLU A 270      40.635  43.467  28.792  1.00 23.56           O  
ATOM   1639  CB  GLU A 270      40.313  41.171  26.555  1.00 23.50           C  
ATOM   1640  CG  GLU A 270      40.420  39.729  26.032  1.00 24.15           C  
ATOM   1641  CD  GLU A 270      39.569  39.428  24.783  1.00 26.76           C  
ATOM   1642  OE1 GLU A 270      39.635  40.181  23.781  1.00 25.55           O  
ATOM   1643  OE2 GLU A 270      38.845  38.404  24.796  1.00 29.83           O  
ATOM   1644  N   ILE A 271      42.212  43.846  27.240  1.00 23.63           N  
ATOM   1645  CA  ILE A 271      42.255  45.276  27.528  1.00 23.22           C  
ATOM   1646  C   ILE A 271      42.258  46.139  26.284  1.00 22.99           C  
ATOM   1647  O   ILE A 271      42.965  45.830  25.334  1.00 23.57           O  
ATOM   1648  CB  ILE A 271      43.514  45.625  28.286  1.00 25.03           C  
ATOM   1649  CG1 ILE A 271      43.623  44.746  29.538  1.00 26.94           C  
ATOM   1650  CG2 ILE A 271      43.513  47.116  28.588  1.00 25.59           C  
ATOM   1651  CD1 ILE A 271      44.925  44.871  30.280  1.00 35.15           C  
ATOM   1652  N   ILE A 272      41.461  47.203  26.264  1.00 22.63           N  
ATOM   1653  CA  ILE A 272      41.490  48.110  25.117  1.00 23.59           C  
ATOM   1654  C   ILE A 272      41.821  49.478  25.691  1.00 23.71           C  
ATOM   1655  O   ILE A 272      41.343  49.827  26.763  1.00 24.82           O  
ATOM   1656  CB  ILE A 272      40.138  48.243  24.343  1.00 26.19           C  
ATOM   1657  CG1 ILE A 272      39.859  47.019  23.480  1.00 25.52           C  
ATOM   1658  CG2 ILE A 272      40.215  49.424  23.368  1.00 24.65           C  
ATOM   1659  CD1 ILE A 272      39.104  45.964  24.169  1.00 37.61           C  
ATOM   1660  N   GLY A 273      42.648  50.237  24.975  1.00 23.35           N  
ATOM   1661  CA  GLY A 273      43.033  51.568  25.411  1.00 21.97           C  
ATOM   1662  C   GLY A 273      42.387  52.627  24.540  1.00 21.52           C  
ATOM   1663  O   GLY A 273      41.464  52.336  23.789  1.00 18.65           O  
ATOM   1664  N   PHE A 274      42.884  53.856  24.608  1.00 24.08           N  
ATOM   1665  CA  PHE A 274      42.280  54.935  23.824  1.00 26.61           C  
ATOM   1666  C   PHE A 274      43.290  56.002  23.423  1.00 27.40           C  
ATOM   1667  O   PHE A 274      44.200  56.330  24.198  1.00 27.65           O  
ATOM   1668  CB  PHE A 274      41.155  55.561  24.649  1.00 25.85           C  
ATOM   1669  CG  PHE A 274      40.125  56.293  23.855  1.00 24.32           C  
ATOM   1670  CD1 PHE A 274      40.376  57.559  23.359  1.00 24.91           C  
ATOM   1671  CD2 PHE A 274      38.859  55.743  23.676  1.00 26.31           C  
ATOM   1672  CE1 PHE A 274      39.370  58.283  22.696  1.00 26.37           C  
ATOM   1673  CE2 PHE A 274      37.842  56.452  23.018  1.00 24.84           C  
ATOM   1674  CZ  PHE A 274      38.101  57.723  22.530  1.00 25.97           C  
ATOM   1675  N   ASP A 275      43.097  56.529  22.210  1.00 27.90           N  
ATOM   1676  CA  ASP A 275      43.926  57.582  21.607  1.00 28.99           C  
ATOM   1677  C   ASP A 275      44.850  57.017  20.526  1.00 29.10           C  
ATOM   1678  O   ASP A 275      45.168  57.697  19.539  1.00 29.30           O  
ATOM   1679  CB  ASP A 275      44.761  58.317  22.673  1.00 28.92           C  
ATOM   1680  CG  ASP A 275      43.932  59.307  23.498  1.00 30.18           C  
ATOM   1681  OD1 ASP A 275      44.402  59.691  24.599  1.00 30.65           O  
ATOM   1682  OD2 ASP A 275      42.829  59.709  23.042  1.00 26.80           O  
ATOM   1683  N   ASN A 276      45.262  55.764  20.711  1.00 27.65           N  
ATOM   1684  CA  ASN A 276      46.152  55.114  19.771  1.00 25.04           C  
ATOM   1685  C   ASN A 276      47.385  55.998  19.585  1.00 25.54           C  
ATOM   1686  O   ASN A 276      47.661  56.511  18.501  1.00 25.26           O  
ATOM   1687  CB  ASN A 276      45.431  54.894  18.445  1.00 23.66           C  
ATOM   1688  CG  ASN A 276      46.310  54.238  17.411  1.00 22.07           C  
ATOM   1689  OD1 ASN A 276      46.897  53.184  17.653  1.00 20.95           O  
ATOM   1690  ND2 ASN A 276      46.404  54.860  16.244  1.00 23.34           N  
ATOM   1691  N   THR A 277      48.110  56.184  20.679  1.00 25.75           N  
ATOM   1692  CA  THR A 277      49.314  56.985  20.687  1.00 25.94           C  
ATOM   1693  C   THR A 277      50.502  56.062  20.399  1.00 27.41           C  
ATOM   1694  O   THR A 277      50.331  54.878  20.118  1.00 26.43           O  
ATOM   1695  CB  THR A 277      49.468  57.712  22.053  1.00 24.81           C  
ATOM   1696  OG1 THR A 277      49.382  56.766  23.121  1.00 25.79           O  
ATOM   1697  CG2 THR A 277      48.350  58.724  22.245  1.00 24.80           C  
ATOM   1698  N   ARG A 278      51.708  56.609  20.444  1.00 30.17           N  
ATOM   1699  CA  ARG A 278      52.901  55.827  20.167  1.00 30.76           C  
ATOM   1700  C   ARG A 278      53.041  54.659  21.138  1.00 29.70           C  
ATOM   1701  O   ARG A 278      53.526  53.587  20.765  1.00 31.20           O  
ATOM   1702  CB  ARG A 278      54.136  56.737  20.224  1.00 33.94           C  
ATOM   1703  CG  ARG A 278      54.229  57.747  19.074  1.00 39.79           C  
ATOM   1704  CD  ARG A 278      55.356  58.769  19.262  1.00 43.82           C  
ATOM   1705  NE  ARG A 278      56.502  58.186  19.954  1.00 49.67           N  
ATOM   1706  CZ  ARG A 278      56.858  58.491  21.202  1.00 52.78           C  
ATOM   1707  NH1 ARG A 278      56.164  59.382  21.905  1.00 54.29           N  
ATOM   1708  NH2 ARG A 278      57.907  57.896  21.755  1.00 52.75           N  
ATOM   1709  N   LEU A 279      52.606  54.864  22.377  1.00 27.05           N  
ATOM   1710  CA  LEU A 279      52.691  53.832  23.399  1.00 25.24           C  
ATOM   1711  C   LEU A 279      51.957  52.543  23.014  1.00 24.68           C  
ATOM   1712  O   LEU A 279      52.282  51.463  23.512  1.00 23.64           O  
ATOM   1713  CB  LEU A 279      52.126  54.368  24.710  1.00 24.61           C  
ATOM   1714  CG  LEU A 279      52.906  55.551  25.271  1.00 26.17           C  
ATOM   1715  CD1 LEU A 279      52.212  56.118  26.505  1.00 26.34           C  
ATOM   1716  CD2 LEU A 279      54.304  55.092  25.625  1.00 27.38           C  
ATOM   1717  N   SER A 280      50.977  52.668  22.122  1.00 22.67           N  
ATOM   1718  CA  SER A 280      50.170  51.546  21.670  1.00 22.12           C  
ATOM   1719  C   SER A 280      50.954  50.336  21.209  1.00 22.41           C  
ATOM   1720  O   SER A 280      50.551  49.205  21.467  1.00 21.54           O  
ATOM   1721  CB  SER A 280      49.271  51.980  20.523  1.00 22.23           C  
ATOM   1722  OG  SER A 280      48.517  53.109  20.882  1.00 26.45           O  
ATOM   1723  N   THR A 281      52.053  50.576  20.497  1.00 23.10           N  
ATOM   1724  CA  THR A 281      52.879  49.497  19.960  1.00 22.18           C  
ATOM   1725  C   THR A 281      54.182  49.340  20.716  1.00 22.12           C  
ATOM   1726  O   THR A 281      55.067  48.592  20.293  1.00 21.47           O  
ATOM   1727  CB  THR A 281      53.213  49.750  18.494  1.00 22.27           C  
ATOM   1728  OG1 THR A 281      53.874  51.017  18.373  1.00 23.49           O  
ATOM   1729  CG2 THR A 281      51.950  49.772  17.667  1.00 22.73           C  
ATOM   1730  N   MET A 282      54.296  50.071  21.819  1.00 22.54           N  
ATOM   1731  CA  MET A 282      55.470  50.015  22.666  1.00 23.60           C  
ATOM   1732  C   MET A 282      55.212  49.160  23.910  1.00 23.82           C  
ATOM   1733  O   MET A 282      55.712  49.434  25.011  1.00 23.11           O  
ATOM   1734  CB  MET A 282      55.887  51.419  23.065  1.00 24.79           C  
ATOM   1735  CG  MET A 282      56.638  52.143  21.998  1.00 25.15           C  
ATOM   1736  SD  MET A 282      56.772  53.859  22.434  1.00 28.41           S  
ATOM   1737  CE  MET A 282      58.027  53.760  23.790  1.00 25.04           C  
ATOM   1738  N   VAL A 283      54.404  48.123  23.732  1.00 23.84           N  
ATOM   1739  CA  VAL A 283      54.137  47.204  24.820  1.00 25.53           C  
ATOM   1740  C   VAL A 283      53.863  45.842  24.291  1.00 24.99           C  
ATOM   1741  O   VAL A 283      53.602  45.671  23.102  1.00 24.50           O  
ATOM   1742  CB  VAL A 283      52.931  47.604  25.706  1.00 26.41           C  
ATOM   1743  CG1 VAL A 283      53.389  48.658  26.705  1.00 30.06           C  
ATOM   1744  CG2 VAL A 283      51.758  48.094  24.844  1.00 22.40           C  
ATOM   1745  N   ARG A 284      53.938  44.882  25.206  1.00 26.14           N  
ATOM   1746  CA  ARG A 284      53.672  43.477  24.934  1.00 26.03           C  
ATOM   1747  C   ARG A 284      52.657  43.029  25.998  1.00 25.33           C  
ATOM   1748  O   ARG A 284      52.911  43.107  27.200  1.00 25.02           O  
ATOM   1749  CB  ARG A 284      54.961  42.646  25.049  1.00 23.72           C  
ATOM   1750  CG  ARG A 284      56.083  42.998  24.073  1.00 24.10           C  
ATOM   1751  CD  ARG A 284      55.728  42.744  22.596  1.00 24.39           C  
ATOM   1752  NE  ARG A 284      55.384  44.004  21.936  1.00 29.13           N  
ATOM   1753  CZ  ARG A 284      56.189  44.705  21.136  1.00 28.88           C  
ATOM   1754  NH1 ARG A 284      57.408  44.278  20.854  1.00 29.80           N  
ATOM   1755  NH2 ARG A 284      55.785  45.874  20.653  1.00 29.26           N  
ATOM   1756  N   PRO A 285      51.473  42.598  25.566  1.00 25.14           N  
ATOM   1757  CA  PRO A 285      51.061  42.519  24.169  1.00 25.86           C  
ATOM   1758  C   PRO A 285      50.684  43.899  23.620  1.00 26.67           C  
ATOM   1759  O   PRO A 285      50.138  44.737  24.333  1.00 26.15           O  
ATOM   1760  CB  PRO A 285      49.873  41.567  24.230  1.00 25.47           C  
ATOM   1761  CG  PRO A 285      49.241  41.930  25.534  1.00 25.45           C  
ATOM   1762  CD  PRO A 285      50.436  42.042  26.454  1.00 25.62           C  
ATOM   1763  N   GLN A 286      50.971  44.131  22.347  1.00 27.55           N  
ATOM   1764  CA  GLN A 286      50.642  45.405  21.747  1.00 27.17           C  
ATOM   1765  C   GLN A 286      49.190  45.690  22.038  1.00 25.95           C  
ATOM   1766  O   GLN A 286      48.342  44.823  21.910  1.00 26.46           O  
ATOM   1767  CB  GLN A 286      50.894  45.387  20.240  1.00 29.38           C  
ATOM   1768  CG  GLN A 286      52.357  45.311  19.865  1.00 29.17           C  
ATOM   1769  CD  GLN A 286      52.591  45.835  18.476  1.00 32.13           C  
ATOM   1770  OE1 GLN A 286      51.850  45.500  17.555  1.00 34.34           O  
ATOM   1771  NE2 GLN A 286      53.621  46.667  18.308  1.00 34.86           N  
ATOM   1772  N   LEU A 287      48.930  46.932  22.419  1.00 25.18           N  
ATOM   1773  CA  LEU A 287      47.620  47.415  22.803  1.00 22.52           C  
ATOM   1774  C   LEU A 287      46.638  47.769  21.703  1.00 23.50           C  
ATOM   1775  O   LEU A 287      46.893  48.687  20.914  1.00 24.57           O  
ATOM   1776  CB  LEU A 287      47.813  48.642  23.695  1.00 21.83           C  
ATOM   1777  CG  LEU A 287      46.614  49.436  24.209  1.00 20.34           C  
ATOM   1778  CD1 LEU A 287      45.913  48.645  25.282  1.00 17.55           C  
ATOM   1779  CD2 LEU A 287      47.080  50.771  24.754  1.00 17.84           C  
ATOM   1780  N   THR A 288      45.507  47.064  21.651  1.00 22.87           N  
ATOM   1781  CA  THR A 288      44.489  47.419  20.671  1.00 22.88           C  
ATOM   1782  C   THR A 288      43.959  48.724  21.283  1.00 22.14           C  
ATOM   1783  O   THR A 288      43.824  48.835  22.501  1.00 21.99           O  
ATOM   1784  CB  THR A 288      43.340  46.372  20.558  1.00 22.77           C  
ATOM   1785  OG1 THR A 288      42.217  46.805  21.331  1.00 24.15           O  
ATOM   1786  CG2 THR A 288      43.789  45.012  21.005  1.00 20.19           C  
ATOM   1787  N   SER A 289      43.666  49.715  20.460  1.00 21.80           N  
ATOM   1788  CA  SER A 289      43.243  51.001  21.011  1.00 21.25           C  
ATOM   1789  C   SER A 289      42.323  51.773  20.087  1.00 20.26           C  
ATOM   1790  O   SER A 289      42.405  51.653  18.859  1.00 19.23           O  
ATOM   1791  CB  SER A 289      44.503  51.833  21.342  1.00 20.65           C  
ATOM   1792  OG  SER A 289      44.245  53.214  21.493  1.00 21.40           O  
ATOM   1793  N   VAL A 290      41.416  52.537  20.685  1.00 19.65           N  
ATOM   1794  CA  VAL A 290      40.500  53.339  19.892  1.00 20.34           C  
ATOM   1795  C   VAL A 290      41.331  54.420  19.199  1.00 21.63           C  
ATOM   1796  O   VAL A 290      42.137  55.115  19.826  1.00 21.25           O  
ATOM   1797  CB  VAL A 290      39.407  53.989  20.764  1.00 18.16           C  
ATOM   1798  CG1 VAL A 290      38.719  55.094  19.989  1.00 14.16           C  
ATOM   1799  CG2 VAL A 290      38.399  52.932  21.196  1.00 16.51           C  
ATOM   1800  N   VAL A 291      41.143  54.541  17.897  1.00 22.75           N  
ATOM   1801  CA  VAL A 291      41.886  55.510  17.132  1.00 25.86           C  
ATOM   1802  C   VAL A 291      41.171  56.837  17.002  1.00 28.82           C  
ATOM   1803  O   VAL A 291      40.029  56.893  16.555  1.00 29.81           O  
ATOM   1804  CB  VAL A 291      42.156  55.022  15.694  1.00 24.65           C  
ATOM   1805  CG1 VAL A 291      42.879  56.112  14.928  1.00 22.17           C  
ATOM   1806  CG2 VAL A 291      42.963  53.739  15.701  1.00 21.57           C  
ATOM   1807  N   GLN A 292      41.855  57.901  17.397  1.00 31.50           N  
ATOM   1808  CA  GLN A 292      41.330  59.244  17.250  1.00 33.00           C  
ATOM   1809  C   GLN A 292      42.320  59.798  16.215  1.00 35.53           C  
ATOM   1810  O   GLN A 292      43.411  60.252  16.570  1.00 37.04           O  
ATOM   1811  CB  GLN A 292      41.422  59.986  18.567  1.00 32.16           C  
ATOM   1812  CG  GLN A 292      40.492  61.141  18.615  1.00 35.10           C  
ATOM   1813  CD  GLN A 292      40.383  61.777  19.986  1.00 37.62           C  
ATOM   1814  OE1 GLN A 292      39.594  62.705  20.173  1.00 39.11           O  
ATOM   1815  NE2 GLN A 292      41.170  61.293  20.950  1.00 35.77           N  
ATOM   1816  N   PRO A 293      41.955  59.743  14.912  1.00 36.13           N  
ATOM   1817  CA  PRO A 293      42.784  60.208  13.787  1.00 34.87           C  
ATOM   1818  C   PRO A 293      43.354  61.605  13.947  1.00 33.78           C  
ATOM   1819  O   PRO A 293      42.726  62.590  13.575  1.00 34.23           O  
ATOM   1820  CB  PRO A 293      41.841  60.089  12.596  1.00 34.05           C  
ATOM   1821  CG  PRO A 293      40.536  60.425  13.197  1.00 34.88           C  
ATOM   1822  CD  PRO A 293      40.551  59.616  14.477  1.00 35.49           C  
ATOM   1823  N   MET A 294      44.563  61.674  14.486  1.00 33.45           N  
ATOM   1824  CA  MET A 294      45.231  62.949  14.725  1.00 33.29           C  
ATOM   1825  C   MET A 294      45.423  63.829  13.492  1.00 32.52           C  
ATOM   1826  O   MET A 294      45.312  65.044  13.594  1.00 33.47           O  
ATOM   1827  CB  MET A 294      46.572  62.700  15.415  1.00 33.58           C  
ATOM   1828  CG  MET A 294      46.495  61.540  16.391  1.00 36.86           C  
ATOM   1829  SD  MET A 294      47.681  61.622  17.732  1.00 42.07           S  
ATOM   1830  CE  MET A 294      49.254  61.202  16.850  1.00 44.94           C  
ATOM   1831  N   TYR A 295      45.712  63.243  12.335  1.00 32.02           N  
ATOM   1832  CA  TYR A 295      45.892  64.068  11.146  1.00 32.93           C  
ATOM   1833  C   TYR A 295      44.552  64.536  10.584  1.00 32.05           C  
ATOM   1834  O   TYR A 295      44.460  65.623  10.020  1.00 30.90           O  
ATOM   1835  CB  TYR A 295      46.698  63.330  10.067  1.00 36.38           C  
ATOM   1836  CG  TYR A 295      48.195  63.276  10.341  1.00 39.90           C  
ATOM   1837  CD1 TYR A 295      48.800  62.103  10.824  1.00 41.10           C  
ATOM   1838  CD2 TYR A 295      49.002  64.405  10.149  1.00 39.63           C  
ATOM   1839  CE1 TYR A 295      50.168  62.057  11.108  1.00 41.47           C  
ATOM   1840  CE2 TYR A 295      50.364  64.366  10.432  1.00 41.53           C  
ATOM   1841  CZ  TYR A 295      50.940  63.186  10.913  1.00 42.76           C  
ATOM   1842  OH  TYR A 295      52.283  63.142  11.217  1.00 44.65           O  
ATOM   1843  N   ASP A 296      43.518  63.715  10.717  1.00 31.42           N  
ATOM   1844  CA  ASP A 296      42.204  64.128  10.250  1.00 31.92           C  
ATOM   1845  C   ASP A 296      41.823  65.355  11.087  1.00 31.21           C  
ATOM   1846  O   ASP A 296      41.385  66.386  10.551  1.00 30.18           O  
ATOM   1847  CB  ASP A 296      41.159  63.034  10.480  1.00 35.25           C  
ATOM   1848  CG  ASP A 296      41.142  61.993   9.389  1.00 37.07           C  
ATOM   1849  OD1 ASP A 296      40.190  61.180   9.365  1.00 38.78           O  
ATOM   1850  OD2 ASP A 296      42.073  61.989   8.560  1.00 39.51           O  
ATOM   1851  N   ILE A 297      41.992  65.228  12.406  1.00 28.92           N  
ATOM   1852  CA  ILE A 297      41.691  66.317  13.335  1.00 28.10           C  
ATOM   1853  C   ILE A 297      42.474  67.567  12.900  1.00 27.24           C  
ATOM   1854  O   ILE A 297      41.896  68.634  12.683  1.00 27.29           O  
ATOM   1855  CB  ILE A 297      42.106  65.955  14.778  1.00 30.04           C  
ATOM   1856  CG1 ILE A 297      41.487  64.618  15.207  1.00 30.43           C  
ATOM   1857  CG2 ILE A 297      41.666  67.047  15.717  1.00 29.63           C  
ATOM   1858  CD1 ILE A 297      39.989  64.609  15.210  1.00 38.28           C  
ATOM   1859  N   GLY A 298      43.790  67.425  12.765  1.00 25.78           N  
ATOM   1860  CA  GLY A 298      44.621  68.534  12.334  1.00 23.58           C  
ATOM   1861  C   GLY A 298      44.178  69.179  11.031  1.00 22.99           C  
ATOM   1862  O   GLY A 298      44.049  70.391  10.959  1.00 23.46           O  
ATOM   1863  N   ALA A 299      43.939  68.380   9.998  1.00 24.17           N  
ATOM   1864  CA  ALA A 299      43.516  68.895   8.690  1.00 24.65           C  
ATOM   1865  C   ALA A 299      42.221  69.707   8.711  1.00 25.08           C  
ATOM   1866  O   ALA A 299      42.186  70.849   8.230  1.00 23.35           O  
ATOM   1867  CB  ALA A 299      43.367  67.749   7.723  1.00 23.51           C  
ATOM   1868  N   VAL A 300      41.161  69.097   9.253  1.00 26.11           N  
ATOM   1869  CA  VAL A 300      39.841  69.731   9.359  1.00 25.11           C  
ATOM   1870  C   VAL A 300      39.975  71.006  10.165  1.00 25.04           C  
ATOM   1871  O   VAL A 300      39.525  72.066   9.746  1.00 26.74           O  
ATOM   1872  CB  VAL A 300      38.822  68.801  10.052  1.00 24.31           C  
ATOM   1873  CG1 VAL A 300      37.489  69.474  10.145  1.00 23.49           C  
ATOM   1874  CG2 VAL A 300      38.681  67.507   9.277  1.00 23.92           C  
ATOM   1875  N   ALA A 301      40.605  70.908  11.325  1.00 25.20           N  
ATOM   1876  CA  ALA A 301      40.821  72.081  12.155  1.00 27.20           C  
ATOM   1877  C   ALA A 301      41.523  73.212  11.375  1.00 28.62           C  
ATOM   1878  O   ALA A 301      41.223  74.378  11.597  1.00 29.04           O  
ATOM   1879  CB  ALA A 301      41.635  71.705  13.383  1.00 26.06           C  
ATOM   1880  N   MET A 302      42.448  72.882  10.469  1.00 30.94           N  
ATOM   1881  CA  MET A 302      43.146  73.912   9.681  1.00 32.92           C  
ATOM   1882  C   MET A 302      42.284  74.569   8.611  1.00 33.63           C  
ATOM   1883  O   MET A 302      42.273  75.793   8.490  1.00 32.50           O  
ATOM   1884  CB  MET A 302      44.388  73.356   8.992  1.00 34.95           C  
ATOM   1885  CG  MET A 302      45.616  73.258   9.866  1.00 36.87           C  
ATOM   1886  SD  MET A 302      46.112  74.817  10.591  1.00 39.52           S  
ATOM   1887  CE  MET A 302      46.638  74.282  12.190  1.00 36.00           C  
ATOM   1888  N   ARG A 303      41.576  73.781   7.807  1.00 34.32           N  
ATOM   1889  CA  ARG A 303      40.745  74.431   6.803  1.00 36.30           C  
ATOM   1890  C   ARG A 303      39.743  75.306   7.511  1.00 34.57           C  
ATOM   1891  O   ARG A 303      39.490  76.429   7.087  1.00 34.93           O  
ATOM   1892  CB  ARG A 303      40.011  73.433   5.909  1.00 38.69           C  
ATOM   1893  CG  ARG A 303      39.745  72.086   6.511  1.00 44.99           C  
ATOM   1894  CD  ARG A 303      39.093  71.185   5.461  1.00 50.02           C  
ATOM   1895  NE  ARG A 303      39.711  71.341   4.136  1.00 55.26           N  
ATOM   1896  CZ  ARG A 303      40.946  70.949   3.810  1.00 56.15           C  
ATOM   1897  NH1 ARG A 303      41.723  70.357   4.711  1.00 57.41           N  
ATOM   1898  NH2 ARG A 303      41.409  71.157   2.582  1.00 55.25           N  
ATOM   1899  N   LEU A 304      39.198  74.788   8.610  1.00 33.27           N  
ATOM   1900  CA  LEU A 304      38.208  75.508   9.401  1.00 31.01           C  
ATOM   1901  C   LEU A 304      38.799  76.814   9.906  1.00 29.25           C  
ATOM   1902  O   LEU A 304      38.256  77.888   9.666  1.00 28.75           O  
ATOM   1903  CB  LEU A 304      37.760  74.641  10.569  1.00 30.72           C  
ATOM   1904  CG  LEU A 304      36.340  74.826  11.101  1.00 32.55           C  
ATOM   1905  CD1 LEU A 304      35.321  74.539  10.021  1.00 33.16           C  
ATOM   1906  CD2 LEU A 304      36.125  73.866  12.248  1.00 33.82           C  
ATOM   1907  N   LEU A 305      39.935  76.722  10.581  1.00 27.29           N  
ATOM   1908  CA  LEU A 305      40.581  77.911  11.102  1.00 26.88           C  
ATOM   1909  C   LEU A 305      41.008  78.874  10.001  1.00 28.16           C  
ATOM   1910  O   LEU A 305      40.936  80.088  10.182  1.00 27.67           O  
ATOM   1911  CB  LEU A 305      41.798  77.528  11.936  1.00 23.71           C  
ATOM   1912  CG  LEU A 305      42.378  78.687  12.733  1.00 21.32           C  
ATOM   1913  CD1 LEU A 305      41.355  79.180  13.742  1.00 22.12           C  
ATOM   1914  CD2 LEU A 305      43.632  78.246  13.425  1.00 20.21           C  
ATOM   1915  N   THR A 306      41.454  78.333   8.865  1.00 31.06           N  
ATOM   1916  CA  THR A 306      41.896  79.157   7.729  1.00 32.51           C  
ATOM   1917  C   THR A 306      40.719  79.932   7.162  1.00 34.04           C  
ATOM   1918  O   THR A 306      40.814  81.137   6.914  1.00 34.58           O  
ATOM   1919  CB  THR A 306      42.498  78.318   6.589  1.00 30.88           C  
ATOM   1920  OG1 THR A 306      43.634  77.599   7.062  1.00 32.27           O  
ATOM   1921  CG2 THR A 306      42.969  79.208   5.483  1.00 30.59           C  
ATOM   1922  N   LYS A 307      39.616  79.233   6.941  1.00 34.42           N  
ATOM   1923  CA  LYS A 307      38.427  79.880   6.440  1.00 35.65           C  
ATOM   1924  C   LYS A 307      38.202  81.085   7.339  1.00 36.43           C  
ATOM   1925  O   LYS A 307      38.097  82.225   6.895  1.00 36.23           O  
ATOM   1926  CB  LYS A 307      37.247  78.921   6.538  1.00 36.06           C  
ATOM   1927  CG  LYS A 307      37.314  77.774   5.562  1.00 37.67           C  
ATOM   1928  CD  LYS A 307      36.152  76.827   5.768  1.00 40.60           C  
ATOM   1929  CE  LYS A 307      35.979  75.885   4.569  1.00 42.94           C  
ATOM   1930  NZ  LYS A 307      35.608  76.621   3.314  1.00 42.24           N  
ATOM   1931  N   TYR A 308      38.161  80.820   8.630  1.00 37.24           N  
ATOM   1932  CA  TYR A 308      37.949  81.891   9.574  1.00 38.89           C  
ATOM   1933  C   TYR A 308      38.963  83.012   9.356  1.00 41.34           C  
ATOM   1934  O   TYR A 308      38.577  84.150   9.097  1.00 43.08           O  
ATOM   1935  CB  TYR A 308      38.033  81.358  11.003  1.00 38.13           C  
ATOM   1936  CG  TYR A 308      36.820  80.538  11.394  1.00 38.43           C  
ATOM   1937  CD1 TYR A 308      35.551  81.119  11.446  1.00 37.23           C  
ATOM   1938  CD2 TYR A 308      36.932  79.170  11.684  1.00 38.88           C  
ATOM   1939  CE1 TYR A 308      34.424  80.362  11.773  1.00 37.36           C  
ATOM   1940  CE2 TYR A 308      35.807  78.406  12.011  1.00 38.75           C  
ATOM   1941  CZ  TYR A 308      34.560  79.013  12.051  1.00 38.56           C  
ATOM   1942  OH  TYR A 308      33.444  78.267  12.348  1.00 40.65           O  
ATOM   1943  N   MET A 309      40.254  82.707   9.446  1.00 42.14           N  
ATOM   1944  CA  MET A 309      41.260  83.738   9.255  1.00 42.57           C  
ATOM   1945  C   MET A 309      41.036  84.579   7.992  1.00 44.74           C  
ATOM   1946  O   MET A 309      41.308  85.777   7.987  1.00 44.12           O  
ATOM   1947  CB  MET A 309      42.643  83.103   9.235  1.00 41.00           C  
ATOM   1948  CG  MET A 309      43.174  82.810  10.622  1.00 40.00           C  
ATOM   1949  SD  MET A 309      44.618  81.734  10.726  1.00 37.98           S  
ATOM   1950  CE  MET A 309      44.041  80.245  10.533  1.00 40.97           C  
ATOM   1951  N   ASN A 310      40.529  83.960   6.929  1.00 48.57           N  
ATOM   1952  CA  ASN A 310      40.284  84.681   5.681  1.00 51.53           C  
ATOM   1953  C   ASN A 310      38.875  85.212   5.625  1.00 52.58           C  
ATOM   1954  O   ASN A 310      38.351  85.508   4.556  1.00 53.37           O  
ATOM   1955  CB  ASN A 310      40.545  83.774   4.487  1.00 52.46           C  
ATOM   1956  CG  ASN A 310      42.015  83.489   4.301  1.00 54.20           C  
ATOM   1957  OD1 ASN A 310      42.393  82.464   3.746  1.00 55.40           O  
ATOM   1958  ND2 ASN A 310      42.859  84.409   4.756  1.00 55.59           N  
ATOM   1959  N   LYS A 311      38.270  85.321   6.799  1.00 55.19           N  
ATOM   1960  CA  LYS A 311      36.916  85.831   6.953  1.00 57.42           C  
ATOM   1961  C   LYS A 311      35.884  85.235   6.026  1.00 58.51           C  
ATOM   1962  O   LYS A 311      35.048  85.939   5.459  1.00 57.65           O  
ATOM   1963  CB  LYS A 311      36.926  87.348   6.832  1.00 57.61           C  
ATOM   1964  CG  LYS A 311      37.655  87.991   7.984  1.00 59.55           C  
ATOM   1965  CD  LYS A 311      37.525  89.492   7.947  1.00 61.90           C  
ATOM   1966  CE  LYS A 311      38.518  90.098   6.971  1.00 64.44           C  
ATOM   1967  NZ  LYS A 311      39.941  89.917   7.442  1.00 65.21           N  
ATOM   1968  N   GLU A 312      35.954  83.915   5.899  1.00 60.80           N  
ATOM   1969  CA  GLU A 312      35.024  83.166   5.080  1.00 61.99           C  
ATOM   1970  C   GLU A 312      33.902  82.616   5.938  1.00 63.52           C  
ATOM   1971  O   GLU A 312      33.763  82.975   7.113  1.00 63.43           O  
ATOM   1972  CB  GLU A 312      35.746  82.037   4.364  1.00 61.88           C  
ATOM   1973  CG  GLU A 312      36.516  82.525   3.154  1.00 63.00           C  
ATOM   1974  CD  GLU A 312      37.549  81.532   2.674  1.00 63.55           C  
ATOM   1975  OE1 GLU A 312      37.219  80.326   2.593  1.00 62.97           O  
ATOM   1976  OE2 GLU A 312      38.685  81.967   2.371  1.00 63.92           O  
ATOM   1977  N   THR A 313      33.102  81.739   5.351  1.00 65.65           N  
ATOM   1978  CA  THR A 313      31.972  81.175   6.070  1.00 67.32           C  
ATOM   1979  C   THR A 313      32.086  79.677   6.312  1.00 68.03           C  
ATOM   1980  O   THR A 313      32.619  78.923   5.488  1.00 67.52           O  
ATOM   1981  CB  THR A 313      30.658  81.464   5.321  1.00 67.85           C  
ATOM   1982  OG1 THR A 313      30.668  80.784   4.059  1.00 67.99           O  
ATOM   1983  CG2 THR A 313      30.507  82.966   5.084  1.00 67.24           C  
ATOM   1984  N   VAL A 314      31.575  79.257   7.461  1.00 68.75           N  
ATOM   1985  CA  VAL A 314      31.603  77.857   7.834  1.00 70.15           C  
ATOM   1986  C   VAL A 314      30.184  77.310   7.899  1.00 70.06           C  
ATOM   1987  O   VAL A 314      29.393  77.684   8.766  1.00 69.84           O  
ATOM   1988  CB  VAL A 314      32.297  77.669   9.195  1.00 70.82           C  
ATOM   1989  CG1 VAL A 314      32.271  76.205   9.599  1.00 71.50           C  
ATOM   1990  CG2 VAL A 314      33.729  78.165   9.106  1.00 70.66           C  
ATOM   1991  N   ASP A 315      29.875  76.427   6.958  1.00 70.25           N  
ATOM   1992  CA  ASP A 315      28.561  75.803   6.867  1.00 70.72           C  
ATOM   1993  C   ASP A 315      28.386  74.734   7.949  1.00 69.79           C  
ATOM   1994  O   ASP A 315      27.266  74.455   8.394  1.00 70.66           O  
ATOM   1995  CB  ASP A 315      28.390  75.199   5.467  1.00 73.13           C  
ATOM   1996  CG  ASP A 315      29.592  74.358   5.033  1.00 73.84           C  
ATOM   1997  OD1 ASP A 315      30.750  74.740   5.339  1.00 72.57           O  
ATOM   1998  OD2 ASP A 315      29.365  73.319   4.369  1.00 74.71           O  
ATOM   1999  N   SER A 316      29.513  74.153   8.364  1.00 67.30           N  
ATOM   2000  CA  SER A 316      29.573  73.121   9.399  1.00 62.03           C  
ATOM   2001  C   SER A 316      30.714  73.555  10.327  1.00 58.16           C  
ATOM   2002  O   SER A 316      31.888  73.358  10.023  1.00 58.41           O  
ATOM   2003  CB  SER A 316      29.885  71.759   8.761  1.00 62.63           C  
ATOM   2004  OG  SER A 316      29.048  71.507   7.640  1.00 61.53           O  
ATOM   2005  N   SER A 317      30.366  74.164  11.450  1.00 53.80           N  
ATOM   2006  CA  SER A 317      31.363  74.656  12.394  1.00 49.11           C  
ATOM   2007  C   SER A 317      31.741  73.632  13.460  1.00 46.11           C  
ATOM   2008  O   SER A 317      32.836  73.676  14.028  1.00 45.04           O  
ATOM   2009  CB  SER A 317      30.831  75.917  13.062  1.00 49.05           C  
ATOM   2010  OG  SER A 317      31.788  76.460  13.933  1.00 48.51           O  
ATOM   2011  N   ILE A 318      30.819  72.718  13.729  1.00 42.44           N  
ATOM   2012  CA  ILE A 318      31.029  71.678  14.716  1.00 38.00           C  
ATOM   2013  C   ILE A 318      31.147  70.362  13.976  1.00 36.53           C  
ATOM   2014  O   ILE A 318      30.180  69.622  13.868  1.00 36.25           O  
ATOM   2015  CB  ILE A 318      29.845  71.605  15.726  1.00 37.18           C  
ATOM   2016  CG1 ILE A 318      29.793  72.877  16.580  1.00 33.92           C  
ATOM   2017  CG2 ILE A 318      29.988  70.388  16.629  1.00 36.32           C  
ATOM   2018  CD1 ILE A 318      28.892  73.934  16.023  1.00 41.09           C  
ATOM   2019  N   VAL A 319      32.339  70.074  13.473  1.00 36.61           N  
ATOM   2020  CA  VAL A 319      32.575  68.845  12.727  1.00 38.47           C  
ATOM   2021  C   VAL A 319      33.017  67.672  13.603  1.00 38.86           C  
ATOM   2022  O   VAL A 319      33.862  67.824  14.484  1.00 40.45           O  
ATOM   2023  CB  VAL A 319      33.654  69.050  11.658  1.00 39.78           C  
ATOM   2024  CG1 VAL A 319      33.287  68.272  10.397  1.00 40.27           C  
ATOM   2025  CG2 VAL A 319      33.834  70.529  11.375  1.00 39.46           C  
ATOM   2026  N   GLN A 320      32.452  66.499  13.342  1.00 38.40           N  
ATOM   2027  CA  GLN A 320      32.789  65.292  14.094  1.00 38.13           C  
ATOM   2028  C   GLN A 320      33.346  64.224  13.140  1.00 36.99           C  
ATOM   2029  O   GLN A 320      32.629  63.675  12.307  1.00 37.22           O  
ATOM   2030  CB  GLN A 320      31.548  64.772  14.818  1.00 39.13           C  
ATOM   2031  CG  GLN A 320      31.779  63.553  15.692  1.00 42.19           C  
ATOM   2032  CD  GLN A 320      30.569  63.225  16.554  1.00 43.26           C  
ATOM   2033  OE1 GLN A 320      29.590  62.630  16.084  1.00 41.82           O  
ATOM   2034  NE2 GLN A 320      30.623  63.636  17.826  1.00 43.48           N  
ATOM   2035  N   LEU A 321      34.633  63.938  13.268  1.00 35.13           N  
ATOM   2036  CA  LEU A 321      35.283  62.965  12.413  1.00 33.37           C  
ATOM   2037  C   LEU A 321      35.094  61.524  12.839  1.00 31.99           C  
ATOM   2038  O   LEU A 321      34.941  61.221  14.012  1.00 33.00           O  
ATOM   2039  CB  LEU A 321      36.772  63.287  12.325  1.00 33.16           C  
ATOM   2040  CG  LEU A 321      37.062  64.394  11.316  1.00 33.19           C  
ATOM   2041  CD1 LEU A 321      38.459  64.953  11.482  1.00 33.08           C  
ATOM   2042  CD2 LEU A 321      36.865  63.800   9.925  1.00 35.89           C  
ATOM   2043  N   PRO A 322      35.079  60.606  11.872  1.00 31.10           N  
ATOM   2044  CA  PRO A 322      34.910  59.193  12.213  1.00 30.79           C  
ATOM   2045  C   PRO A 322      36.047  58.602  13.059  1.00 30.29           C  
ATOM   2046  O   PRO A 322      37.116  59.197  13.199  1.00 28.61           O  
ATOM   2047  CB  PRO A 322      34.785  58.518  10.842  1.00 28.29           C  
ATOM   2048  CG  PRO A 322      35.385  59.495   9.895  1.00 27.43           C  
ATOM   2049  CD  PRO A 322      34.943  60.815  10.424  1.00 29.15           C  
ATOM   2050  N   HIS A 323      35.802  57.421  13.616  1.00 30.29           N  
ATOM   2051  CA  HIS A 323      36.798  56.747  14.435  1.00 30.18           C  
ATOM   2052  C   HIS A 323      36.815  55.262  14.130  1.00 30.38           C  
ATOM   2053  O   HIS A 323      35.867  54.710  13.572  1.00 30.46           O  
ATOM   2054  CB  HIS A 323      36.489  56.938  15.921  1.00 30.41           C  
ATOM   2055  CG  HIS A 323      35.220  56.275  16.357  1.00 30.73           C  
ATOM   2056  ND1 HIS A 323      33.981  56.852  16.182  1.00 30.99           N  
ATOM   2057  CD2 HIS A 323      34.992  55.059  16.910  1.00 30.93           C  
ATOM   2058  CE1 HIS A 323      33.047  56.019  16.607  1.00 31.48           C  
ATOM   2059  NE2 HIS A 323      33.634  54.924  17.054  1.00 29.38           N  
ATOM   2060  N   ARG A 324      37.905  54.619  14.517  1.00 31.40           N  
ATOM   2061  CA  ARG A 324      38.076  53.194  14.310  1.00 32.87           C  
ATOM   2062  C   ARG A 324      38.834  52.643  15.524  1.00 33.63           C  
ATOM   2063  O   ARG A 324      39.336  53.419  16.349  1.00 33.99           O  
ATOM   2064  CB  ARG A 324      38.855  52.943  13.001  1.00 32.74           C  
ATOM   2065  CG  ARG A 324      40.151  53.724  12.853  1.00 34.03           C  
ATOM   2066  CD  ARG A 324      40.875  53.365  11.566  1.00 37.74           C  
ATOM   2067  NE  ARG A 324      42.253  53.873  11.508  1.00 42.34           N  
ATOM   2068  CZ  ARG A 324      42.592  55.159  11.379  1.00 44.79           C  
ATOM   2069  NH1 ARG A 324      41.658  56.105  11.291  1.00 44.25           N  
ATOM   2070  NH2 ARG A 324      43.878  55.505  11.332  1.00 44.90           N  
ATOM   2071  N   ILE A 325      38.876  51.317  15.651  1.00 32.99           N  
ATOM   2072  CA  ILE A 325      39.594  50.657  16.744  1.00 31.56           C  
ATOM   2073  C   ILE A 325      40.747  49.895  16.100  1.00 30.95           C  
ATOM   2074  O   ILE A 325      40.514  49.021  15.274  1.00 29.02           O  
ATOM   2075  CB  ILE A 325      38.730  49.588  17.499  1.00 31.76           C  
ATOM   2076  CG1 ILE A 325      37.572  50.226  18.271  1.00 33.43           C  
ATOM   2077  CG2 ILE A 325      39.589  48.846  18.479  1.00 30.29           C  
ATOM   2078  CD1 ILE A 325      36.427  50.714  17.404  1.00 40.87           C  
ATOM   2079  N   GLU A 326      41.983  50.229  16.460  1.00 31.44           N  
ATOM   2080  CA  GLU A 326      43.134  49.506  15.917  1.00 30.44           C  
ATOM   2081  C   GLU A 326      43.315  48.297  16.824  1.00 28.26           C  
ATOM   2082  O   GLU A 326      43.703  48.427  17.984  1.00 25.60           O  
ATOM   2083  CB  GLU A 326      44.399  50.376  15.932  1.00 33.02           C  
ATOM   2084  CG  GLU A 326      45.575  49.775  15.164  1.00 36.66           C  
ATOM   2085  CD  GLU A 326      45.173  49.197  13.804  1.00 40.01           C  
ATOM   2086  OE1 GLU A 326      44.456  49.875  13.024  1.00 42.24           O  
ATOM   2087  OE2 GLU A 326      45.590  48.058  13.512  1.00 41.27           O  
ATOM   2088  N   PHE A 327      43.000  47.126  16.291  1.00 27.88           N  
ATOM   2089  CA  PHE A 327      43.099  45.888  17.044  1.00 28.95           C  
ATOM   2090  C   PHE A 327      44.475  45.232  16.995  1.00 28.59           C  
ATOM   2091  O   PHE A 327      45.013  44.957  15.918  1.00 28.69           O  
ATOM   2092  CB  PHE A 327      42.035  44.887  16.555  1.00 30.75           C  
ATOM   2093  CG  PHE A 327      40.631  45.276  16.904  1.00 32.44           C  
ATOM   2094  CD1 PHE A 327      39.820  45.917  15.974  1.00 32.80           C  
ATOM   2095  CD2 PHE A 327      40.133  45.038  18.184  1.00 34.34           C  
ATOM   2096  CE1 PHE A 327      38.538  46.317  16.310  1.00 34.70           C  
ATOM   2097  CE2 PHE A 327      38.845  45.435  18.535  1.00 35.96           C  
ATOM   2098  CZ  PHE A 327      38.044  46.077  17.596  1.00 36.12           C  
ATOM   2099  N   ARG A 328      45.031  44.966  18.171  1.00 28.56           N  
ATOM   2100  CA  ARG A 328      46.340  44.328  18.263  1.00 29.63           C  
ATOM   2101  C   ARG A 328      46.311  43.048  19.141  1.00 30.01           C  
ATOM   2102  O   ARG A 328      45.390  42.241  19.025  1.00 31.54           O  
ATOM   2103  CB  ARG A 328      47.361  45.360  18.773  1.00 27.60           C  
ATOM   2104  CG  ARG A 328      47.366  46.671  17.966  1.00 23.25           C  
ATOM   2105  CD  ARG A 328      48.589  47.511  18.289  1.00 23.56           C  
ATOM   2106  NE  ARG A 328      48.764  48.672  17.419  1.00 23.01           N  
ATOM   2107  CZ  ARG A 328      48.143  49.837  17.584  1.00 24.62           C  
ATOM   2108  NH1 ARG A 328      47.295  50.009  18.589  1.00 26.38           N  
ATOM   2109  NH2 ARG A 328      48.380  50.836  16.751  1.00 22.81           N  
ATOM   2110  N   GLN A 329      47.292  42.855  20.015  1.00 30.73           N  
ATOM   2111  CA  GLN A 329      47.330  41.650  20.852  1.00 32.01           C  
ATOM   2112  C   GLN A 329      46.773  41.748  22.259  1.00 31.79           C  
ATOM   2113  O   GLN A 329      46.849  40.783  23.018  1.00 29.80           O  
ATOM   2114  CB  GLN A 329      48.753  41.121  20.965  1.00 33.47           C  
ATOM   2115  CG  GLN A 329      49.254  40.433  19.740  1.00 34.52           C  
ATOM   2116  CD  GLN A 329      49.167  41.314  18.535  1.00 37.58           C  
ATOM   2117  OE1 GLN A 329      48.213  41.226  17.768  1.00 40.05           O  
ATOM   2118  NE2 GLN A 329      50.158  42.193  18.360  1.00 37.07           N  
ATOM   2119  N   SER A 330      46.227  42.899  22.620  1.00 33.02           N  
ATOM   2120  CA  SER A 330      45.680  43.045  23.957  1.00 34.77           C  
ATOM   2121  C   SER A 330      44.245  42.508  24.008  1.00 35.06           C  
ATOM   2122  O   SER A 330      43.589  42.540  25.053  1.00 34.81           O  
ATOM   2123  CB  SER A 330      45.751  44.510  24.406  1.00 34.80           C  
ATOM   2124  OG  SER A 330      45.040  45.370  23.535  1.00 36.40           O  
ATOM   2125  N   THR A 331      43.774  42.000  22.872  1.00 34.95           N  
ATOM   2126  CA  THR A 331      42.439  41.419  22.770  1.00 35.53           C  
ATOM   2127  C   THR A 331      42.585  40.125  22.002  1.00 37.92           C  
ATOM   2128  O   THR A 331      43.398  40.050  21.081  1.00 40.31           O  
ATOM   2129  CB  THR A 331      41.478  42.315  21.981  1.00 34.02           C  
ATOM   2130  OG1 THR A 331      42.098  42.705  20.750  1.00 33.23           O  
ATOM   2131  CG2 THR A 331      41.090  43.540  22.792  1.00 30.29           C  
ATOM   2132  N   LYS A 332      41.820  39.105  22.381  1.00 40.28           N  
ATOM   2133  CA  LYS A 332      41.871  37.817  21.689  1.00 42.22           C  
ATOM   2134  C   LYS A 332      41.277  38.005  20.295  1.00 43.36           C  
ATOM   2135  O   LYS A 332      41.909  37.577  19.306  1.00 43.47           O  
ATOM   2136  CB  LYS A 332      41.066  36.739  22.435  1.00 42.75           C  
ATOM   2137  CG  LYS A 332      41.814  36.007  23.539  1.00 44.53           C  
ATOM   2138  CD  LYS A 332      41.048  34.760  24.009  1.00 46.82           C  
ATOM   2139  CE  LYS A 332      41.506  33.494  23.277  1.00 49.86           C  
ATOM   2140  NZ  LYS A 332      40.810  32.243  23.728  1.00 49.83           N  
ATOM   2141  OXT LYS A 332      40.170  38.579  20.212  1.00 45.82           O  
TER    2142      LYS A 332                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
